#!/bin/bash
gmt begin chara1.31_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P chara1.31'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.716
    79.000     8.541
    80.000     7.449
    81.000     6.444
    82.000     5.525
    83.000     4.689
    84.000     3.938
    85.000     3.274
    86.000     2.696
    87.000     2.195
    88.000     1.799
    89.000     1.499
    90.000     1.241
    91.000     1.014
    92.000     0.813
    93.000     0.631
    94.000     0.465
    95.000     0.320
    96.000     0.200
    97.000     0.107
    98.000     0.042
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    17.835     2.867     0.200
    18.171     3.325     0.200
    18.186     3.541     0.200
    18.186     4.541     0.200
    18.687     0.793     0.200
    22.759     1.149     0.200
    23.448     2.492     0.200
    23.801     1.149     0.200
    24.219     0.335     0.200
    28.630     2.534     0.200
    30.330     1.461     0.200
    30.330     1.961     0.200
    30.522     0.770     0.200
    30.544     1.570     0.200
    31.754     1.009     0.200
    32.977     3.184     0.200
    34.287     3.573     0.200
    35.746     3.191     0.200
    35.746     2.894     0.200
    36.405     1.551     0.200
    36.489     2.837     0.200
    37.692     2.811     0.200
    37.884     0.993     0.200
    39.277     1.387     0.200
    39.879     1.271     0.200
    40.324     1.279     0.200
    40.324     1.870     0.200
    41.101     0.560     0.200
    41.453    -0.735     0.200
    41.523    -0.305     0.200
    41.619     0.905     0.200
    42.081    -0.075     0.200
    42.255     1.711     0.200
    42.239     0.841     0.200
    42.713     0.980     0.200
    42.865    -0.954     0.200
    42.909     1.597     0.200
    43.022     0.482     0.200
    43.081     0.702     0.200
    43.103     0.824     0.200
    43.093    -0.100     0.200
    43.115     2.729     0.200
    43.196     3.276     0.200
    43.745     1.744     0.200
    44.348    -1.093     0.200
    44.509     0.719     0.200
    44.527    -0.228     0.200
    44.933     0.737     0.200
    45.329    -0.015     0.200
    45.542     0.998     0.200
    46.904     1.584     0.200
    47.537     0.643     0.200
    47.495     1.968     0.200
    47.543     0.801     0.200
    48.034    -0.314     0.200
    48.275     1.930     0.200
    48.596     2.453     0.200
    48.604     2.395     0.200
    49.281    -0.201     0.200
    49.298     3.069     0.200
    49.511     2.441     0.200
    49.793     3.087     0.200
    49.794    -1.315     0.200
    52.096     0.961     0.200
    52.111     2.147     0.200
    52.342     1.130     0.200
    53.989    -2.000     0.200
    54.004     0.892     0.200
    54.298     0.749     0.200
    54.566     0.801     0.200
    54.873    -0.928     0.200
    54.882     1.302     0.200
    55.164     4.468     0.200
    55.455     3.666     0.200
    55.600     0.531     0.200
    55.960     2.445     0.200
    56.018     0.331     0.200
    56.381     1.238     0.200
    56.654     1.790     0.200
    56.926     1.067     0.200
    57.091     1.195     0.200
    57.262     0.984     0.200
    57.441     1.219     0.200
    57.988     1.371     0.200
    58.123     1.426     0.200
    58.605     0.060     0.200
    58.682     1.525     0.200
    58.730     0.092     0.200
    59.155     2.236     0.200
    59.313     1.440     0.200
    59.363     0.901     0.200
    59.414     0.446     0.200
    59.813     1.694     0.200
    60.262     0.816     0.200
    60.291     0.318     0.200
    60.331     0.640     0.200
    60.564     2.751     0.200
    60.596     0.831     0.200
    61.256     0.849     0.200
    61.293     0.594     0.200
    62.635     2.076     0.200
    62.875     0.180     0.200
    63.061    -0.262     0.200
    63.167     0.633     0.200
    63.182     0.331     0.200
    63.280    -0.317     0.200
    63.292    -0.293     0.200
    63.730    -0.591     0.200
    64.030     0.036     0.200
    64.102     0.156     0.200
    64.325     0.399     0.200
    64.620     0.470     0.200
    64.755     0.587     0.200
    64.963     0.028     0.200
    64.985     1.087     0.200
    65.022     0.451     0.200
    65.738     1.107     0.200
    66.000     1.127     0.200
    66.019     1.002     0.200
    66.054     1.174     0.200
    66.060     0.933     0.200
    66.319     1.472     0.200
    66.339     0.645     0.200
    68.616     1.341     0.200
    69.198     0.322     0.200
    69.230     1.627     0.200
    69.819     0.486     0.200
    70.249     1.349     0.200
    71.004     1.343     0.200
    71.066     0.269     0.200
    72.179     1.364     0.200
    73.144     2.421     0.200
    73.304    -0.024     0.200
    73.453     1.599     0.200
    74.097     1.921     0.200
    74.150     1.806     0.200
    74.333     2.341     0.200
    74.422     2.929     0.200
    74.545     1.914     0.200
    75.213     0.347     0.200
    75.579     2.541     0.200
    76.566     3.625     0.200
    76.659     2.395     0.200
    78.304     1.897     0.200
    79.201     2.463     0.200
    79.240     1.753     0.200
    80.871     0.935     0.200
    81.762     1.209     0.200
    82.700     1.298     0.200
    83.905     1.081     0.200
    84.095     0.315     0.200
    86.400    -0.017     0.200
    87.948     1.082     0.200
    89.553     2.019     0.200
    90.201     1.494     0.200
    91.274     0.705     0.200
    23.028     1.792     0.200
    28.893     2.037     0.200
    30.595     2.961     0.200
    30.792     2.219     0.200
    36.007     2.789     0.200
    36.018     2.691     0.200
    37.711     0.278     0.200
    41.805     4.209     0.200
    42.467     0.801     0.200
    42.797     0.123     0.200
    42.923     4.800     0.200
    43.323    -1.132     0.200
    44.002     2.101     0.200
    44.334     0.130     0.200
    45.206    -0.222     0.200
    48.222    -0.351     0.200
    48.506     5.956     0.200
    48.812     1.605     0.200
    49.462    -0.670     0.200
    49.968    -1.428     0.200
    50.391    -0.431     0.200
    52.379     1.667     0.200
    54.519     1.947     0.200
    54.763    -0.827     0.200
    55.655     3.737     0.200
    56.167     3.064     0.200
    56.944    -0.467     0.200
    57.652     1.038     0.200
    59.600     0.961     0.200
    66.208     0.979     0.200
    68.470     1.141     0.200
    69.071     0.996     0.200
    70.940    -0.084     0.200
    74.257     1.670     0.200
    74.738     1.271     0.200
    78.124     0.670     0.200
    81.616     1.454     0.200
    18.041     2.696     0.200
    18.041     3.196     0.200
    18.337     2.970     0.200
    18.531    -1.103     0.200
    18.531    -1.001     0.200
    22.330     3.702     0.200
    22.776     4.462     0.200
    22.926     1.375     0.200
    22.926     1.774     0.200
    23.100     3.047     0.200
    25.883     4.608     0.200
    28.791     2.511     0.200
    28.801     3.228     0.200
    30.385     1.390     0.200
    30.682     1.767     0.200
    30.682     2.067     0.200
    30.897     3.166     0.200
    31.891     1.113     0.200
    31.891     1.613     0.200
    34.457     1.718     0.200
    35.497     1.747     0.200
    35.497     2.349     0.200
    36.865     6.043     0.200
    36.865     6.344     0.200
    37.629     1.159     0.200
    39.448     2.276     0.200
    40.193     1.382     0.200
    40.029     2.439     0.200
    40.398     0.380     0.200
    40.961     0.932     0.200
    41.705     0.622     0.200
    42.148     0.701     0.200
    42.359     0.280     0.200
    42.891     0.757     0.200
    43.123     0.383     0.200
    43.214     1.143     0.200
    44.606     0.159     0.200
    45.026     0.811     0.200
    47.652     1.173     0.200
    48.122    -0.166     0.200
    48.397     3.804     0.200
    48.996    -0.174     0.200
    48.758     2.632     0.200
    49.255     0.060     0.200
    49.363    -0.207     0.200
    49.709     0.067     0.200
    49.871    -0.977     0.200
    54.116     1.499     0.200
    54.618     1.844     0.200
    54.723    -0.015     0.200
    54.693     1.299     0.200
    54.768    -0.245     0.200
    54.998     1.293     0.200
    55.104     0.826     0.200
    56.063     1.037     0.200
    56.118     0.739     0.200
    56.486     1.917     0.200
    57.190     0.918     0.200
    57.546     1.804     0.200
    57.829     1.214     0.200
    58.020     0.574     0.200
    58.241     1.330     0.200
    60.381     0.730     0.200
    60.693     0.995     0.200
    60.989    -2.418     0.200
    61.353     0.720     0.200
    61.390     0.370     0.200
    63.276     0.441     0.200
    63.487     0.443     0.200
    63.558     0.269     0.200
    64.665     0.602     0.200
    66.223     0.523     0.200
    70.864     1.529     0.200
    71.007     5.161     0.200
    72.151     0.761     0.200
    73.010     2.649     0.200
    73.509     1.203     0.200
    73.957     2.075     0.200
    74.288     2.141     0.200
    75.073     1.591     0.200
    77.253     0.190     0.200
    77.606     2.715     0.200
    77.823     2.004     0.200
    80.419     2.297     0.200
    81.638     1.600     0.200
    83.750     1.713     0.200
    83.800     1.555     0.200
    87.831     3.574     0.200
    18.386     3.297     0.200
    18.431     5.997     0.200
    19.527     1.865     0.200
    77.328     0.861     0.200
    18.276     0.596     0.200
    36.974     3.260     0.200
    42.665     2.319     0.200
    48.610     0.276     0.200
    48.610     0.476     0.200
    57.671     1.806     0.200
    14.260     6.797     0.200
    14.473     5.391     0.200
    15.906     2.989     0.200
    17.244     4.869     0.200
    17.487     2.555     0.200
    17.775     3.497     0.200
    17.921     2.900     0.200
    21.254     2.836     0.200
    21.607     5.151     0.200
    21.607     5.448     0.200
    21.662     2.558     0.200
    21.662     3.058     0.200
    21.740     4.727     0.200
    21.740     5.125     0.200
    21.852     4.635     0.200
    21.876     2.073     0.200
    22.886     1.540     0.200
    23.586     3.192     0.200
    23.634    -1.039     0.200
    23.634    -0.335     0.200
    23.735     2.533     0.200
    23.771     0.709     0.200
    23.771     1.412     0.200
    24.207     0.721     0.200
    24.207     0.822     0.200
    24.324     0.661     0.200
    24.324     1.457     0.200
    24.342     2.699     0.200
    24.372    -0.780     0.200
    24.372    -0.483     0.200
    24.549     0.607     0.200
    24.733     0.928     0.200
    24.733     1.529     0.200
    24.746     1.810     0.200
    24.746     2.209     0.200
    25.270     0.051     0.200
    25.373     2.617     0.200
    25.410     0.781     0.200
    25.410     0.883     0.200
    25.556     0.457     0.200
    25.618     0.894     0.200
    25.618     0.995     0.200
    25.836     0.911     0.200
    26.376     1.033     0.200
    27.057     2.393     0.200
    28.499     2.806     0.200
    29.166     1.083     0.200
    29.578     2.429     0.200
    29.588     2.341     0.200
    30.769     0.895     0.200
    30.769     1.598     0.200
    31.253     1.629     0.200
    31.253     2.027     0.200
    31.973     1.298     0.200
    32.141     3.821     0.200
    32.456     1.363     0.200
    32.892     2.245     0.200
    33.763     2.648     0.200
    33.911     3.361     0.200
    34.285     2.623     0.200
    34.535     1.955     0.200
    35.156     1.594     0.200
    36.265     2.293     0.200
    36.735     2.078     0.200
    37.357     1.796     0.200
    37.357     1.999     0.200
    37.411     2.340     0.200
    37.519     0.424     0.200
    37.519     1.221     0.200
    37.506     3.131     0.200
    37.869     3.065     0.200
    37.963     3.065     0.200
    38.004     3.527     0.200
    38.102     3.400     0.200
    38.959     1.097     0.200
    38.918     2.640     0.200
    39.753     0.676     0.200
    39.876    -0.248     0.200
    40.811     1.917     0.200
    40.811     2.417     0.200
    40.957     1.009     0.200
    40.965     1.645     0.200
    41.287     2.002     0.200
    41.550     0.842     0.200
    41.575     0.937     0.200
    41.655     0.980     0.200
    41.954     2.540     0.200
    42.716     0.331     0.200
    42.716     1.034     0.200
    42.772     1.880     0.200
    42.909     1.771     0.200
    43.101     1.217     0.200
    43.156     0.473     0.200
    43.474     3.202     0.200
    43.474     3.702     0.200
    43.607     1.933     0.200
    43.960     1.293     0.200
    44.125     0.469     0.200
    43.999     4.983     0.200
    44.074     2.881     0.200
    46.323     5.532     0.200
    46.388     0.022     0.200
    46.761     1.099     0.200
    47.065     2.928     0.200
    47.345     1.541     0.200
    47.703    -0.341     0.200
    47.890     0.310     0.200
    48.032     2.417     0.200
    48.038     2.169     0.200
    48.007     1.404     0.200
    48.068     0.136     0.200
    48.806     2.648     0.200
    49.083    -0.074     0.200
    49.313     2.365     0.200
    49.858     3.216     0.200
    49.898     2.515     0.200
    50.503     3.326     0.200
    51.051     2.203     0.200
    51.555     0.325     0.200
    52.130     3.139     0.200
    52.195     6.658     0.200
    52.104     3.535     0.200
    52.803     1.150     0.200
    52.994     2.239     0.200
    52.921     2.278     0.200
    52.999     1.701     0.200
    53.240     0.927     0.200
    53.372     1.958     0.200
    53.855     3.417     0.200
    53.767     2.062     0.200
    53.911     0.908     0.200
    53.935     4.338     0.200
    54.006     2.316     0.200
    54.223     1.735     0.200
    54.433     3.504     0.200
    54.651     2.626     0.200
    54.652     2.619     0.200
    54.640     2.102     0.200
    54.839     0.260     0.200
    54.949     4.464     0.200
    55.548     1.749     0.200
    55.588     1.862     0.200
    55.768     0.273     0.200
    55.804     0.411     0.200
    56.193     1.525     0.200
    56.213     0.886     0.200
    56.260    -3.346     0.200
    56.314     2.167     0.200
    56.537     3.081     0.200
    56.542     0.541     0.200
    56.635     2.379     0.200
    56.747     1.584     0.200
    56.815     0.602     0.200
    56.818     2.085     0.200
    56.870     0.714     0.200
    57.014     1.696     0.200
    57.028     0.596     0.200
    57.028     1.096     0.200
    57.275     1.644     0.200
    57.549     1.416     0.200
    57.620     0.917     0.200
    57.720     1.717     0.200
    57.779     1.199     0.200
    57.819     3.020     0.200
    57.835     3.407     0.200
    57.892     1.506     0.200
    58.138     2.785     0.200
    58.124     1.882     0.200
    58.237     1.090     0.200
    58.371     1.151     0.200
    58.502     3.040     0.200
    58.674     1.042     0.200
    58.674     1.440     0.200
    58.669     1.076     0.200
    58.684     1.673     0.200
    58.758     2.459     0.200
    58.788     3.146     0.200
    58.808     0.506     0.200
    58.992     1.833     0.200
    59.040     0.503     0.200
    59.100     0.883     0.200
    59.316     2.987     0.200
    59.393     2.258     0.200
    59.432     1.288     0.200
    59.424     2.345     0.200
    59.489     1.397     0.200
    59.524     1.953     0.200
    59.594     1.968     0.200
    59.601     2.123     0.200
    59.610     2.763     0.200
    59.755     0.769     0.200
    59.756     2.955     0.200
    59.757     0.648     0.200
    59.788     1.133     0.200
    59.906     0.628     0.200
    59.906     0.627     0.200
    59.980     0.718     0.200
    60.103     2.275     0.200
    60.115     1.793     0.200
    60.277    -1.014     0.200
    60.320     0.483     0.200
    60.351     0.437     0.200
    60.405     0.508     0.200
    60.417     1.025     0.200
    60.417     0.425     0.200
    60.502     0.232     0.200
    60.508     1.806     0.200
    60.519    -0.167     0.200
    60.557     0.368     0.200
    60.619     1.543     0.200
    60.675     1.469     0.200
    60.664     2.047     0.200
    60.821     5.771     0.200
    60.864    -0.023     0.200
    60.946     1.124     0.200
    61.006     0.312     0.200
    61.012     0.049     0.200
    61.035     0.522     0.200
    61.041     0.278     0.200
    61.065     1.515     0.200
    61.134     1.746     0.200
    61.268     5.940     0.200
    61.338     2.768     0.200
    61.394     0.289     0.200
    61.430     4.939     0.200
    61.533    -0.051     0.200
    61.604     0.766     0.200
    61.796     0.174     0.200
    61.841     0.475     0.200
    62.013     1.316     0.200
    62.031     2.696     0.200
    62.168     2.180     0.200
    62.210     1.396     0.200
    62.245     3.664     0.200
    62.349    -0.498     0.200
    62.354     0.333     0.200
    62.355     0.927     0.200
    62.407     0.875     0.200
    62.415     2.128     0.200
    62.465     0.794     0.200
    62.507     0.409     0.200
    62.524     0.798     0.200
    62.565     0.627     0.200
    62.597    -0.291     0.200
    62.757     2.038     0.200
    62.789    -0.174     0.200
    62.830     1.218     0.200
    62.857     1.080     0.200
    62.873     0.575     0.200
    62.902     0.276     0.200
    62.917    -0.526     0.200
    62.934    -0.231     0.200
    62.950     1.253     0.200
    63.019     0.574     0.200
    63.035    -0.354     0.200
    63.045     1.830     0.200
    63.101     1.957     0.200
    63.124    -0.093     0.200
    63.186    -0.009     0.200
    63.207     1.256     0.200
    63.227     0.417     0.200
    63.348     1.219     0.200
    63.367    -0.105     0.200
    63.355     3.068     0.200
    63.366     2.802     0.200
    63.411     0.905     0.200
    63.412     1.044     0.200
    63.429    -0.396     0.200
    63.488    -0.180     0.200
    63.502     1.803     0.200
    63.538    -0.939     0.200
    63.572    -0.160     0.200
    63.555     1.948     0.200
    63.574    -0.678     0.200
    63.593     0.699     0.200
    63.599     1.454     0.200
    63.625    -0.158     0.200
    63.628     1.670     0.200
    63.735    -0.035     0.200
    63.734    -1.293     0.200
    63.757    -0.816     0.200
    63.804     0.201     0.200
    63.959     0.387     0.200
    64.034     1.998     0.200
    64.029     0.329     0.200
    64.037     0.177     0.200
    64.322     0.011     0.200
    64.511     0.567     0.200
    64.599     0.497     0.200
    64.635     0.063     0.200
    64.802     0.771     0.200
    64.843     0.404     0.200
    64.968     0.695     0.200
    65.042     2.212     0.200
    65.128     0.451     0.200
    65.243     1.011     0.200
    65.102     1.522     0.200
    65.727     0.877     0.200
    65.779     0.741     0.200
    67.508     0.306     0.200
    68.022     1.876     0.200
    68.806    -0.729     0.200
    68.905     2.449     0.200
    70.746     1.329     0.200
    70.944     1.231     0.200
    71.876     1.502     0.200
    72.270     1.437     0.200
    72.666     1.988     0.200
    72.693     2.326     0.200
    73.794     2.027     0.200
    73.845     1.929     0.200
    73.865     2.006     0.200
    73.978     1.050     0.200
    74.165     0.662     0.200
    74.237     2.641     0.200
    74.314     1.590     0.200
    74.333     0.577     0.200
    74.309     2.119     0.200
    74.470     0.182     0.200
    74.617     2.329     0.200
    75.704     1.068     0.200
    76.352     1.675     0.200
    76.352     1.582     0.200
    76.457     1.782     0.200
    76.614     2.898     0.200
    76.934     2.089     0.200
    77.780     1.151     0.200
    77.804     2.224     0.200
    78.164     2.223     0.200
    78.095     0.603     0.200
    78.285    -2.449     0.200
    78.834     1.525     0.200
    79.201     2.517     0.200
    79.605     0.515     0.200
    80.391     2.272     0.200
    80.548     1.019     0.200
    81.763     0.766     0.200
    82.542     1.183     0.200
    82.543     1.881     0.200
    82.568     0.945     0.200
    82.727     0.721     0.200
    82.876     1.745     0.200
    84.534     0.960     0.200
    85.069     0.166     0.200
    86.370     1.309     0.200
    86.771     3.842     0.200
    87.296     0.791     0.200
    87.707     0.815     0.200
    87.986    -0.513     0.200
    88.278     0.103     0.200
    88.616     2.612     0.200
    88.675     0.228     0.200
    89.083     0.310     0.200
    89.186    -3.173     0.200
    90.012    -0.035     0.200
    91.011     1.316     0.200
    91.830     1.220     0.200
    94.839     1.560     0.200
    15.267     5.999     0.200
    16.663     4.505     0.200
    16.877     2.308     0.200
    17.915     2.385     0.200
    18.033     2.935     0.200
    20.148     1.377     0.200
    20.521     0.323     0.200
    20.521     0.424     0.200
    20.985     2.299     0.200
    21.710     5.502     0.200
    21.710     6.206     0.200
    21.776     1.792     0.200
    21.776     2.690     0.200
    22.677     3.191     0.200
    23.018     3.190     0.200
    23.447     2.071     0.200
    23.450     2.144     0.200
    23.493    -2.416     0.200
    23.493    -1.713     0.200
    23.570     0.875     0.200
    23.570     0.977     0.200
    23.900     0.648     0.200
    23.962     0.391     0.200
    24.083     0.380     0.200
    24.250     1.450     0.200
    24.270    -0.529     0.200
    24.381    -1.436     0.200
    24.599     3.072     0.200
    24.862     2.077     0.200
    25.004     0.587     0.200
    25.195     0.047     0.200
    25.643     1.984     0.200
    25.697     2.697     0.200
    26.220     1.256     0.200
    27.003     0.798     0.200
    27.591     3.213     0.200
    29.115     3.839     0.200
    30.054     0.914     0.200
    30.667     1.895     0.200
    30.679     3.994     0.200
    31.247     2.983     0.200
    31.678     0.197     0.200
    31.876     0.753     0.200
    32.249     1.175     0.200
    32.888     4.978     0.200
    33.379     2.293     0.200
    33.695     4.534     0.200
    34.419     1.255     0.200
    34.419     2.154     0.200
    36.197     0.951     0.200
    36.197     1.553     0.200
    36.368     3.173     0.200
    36.659     3.625     0.200
    36.742     3.542     0.200
    36.932     3.257     0.200
    37.025     3.708     0.200
    37.126     3.598     0.200
    37.159     3.358     0.200
    37.186     2.545     0.200
    37.222     4.001     0.200
    37.259     3.768     0.200
    37.786     3.446     0.200
    37.791     3.558     0.200
    37.976     0.839     0.200
    38.053     2.793     0.200
    38.986     2.346     0.200
    39.857     1.582     0.200
    40.042     2.540     0.200
    40.212     0.134     0.200
    40.378     1.462     0.200
    40.635     1.307     0.200
    41.790     2.239     0.200
    41.790     2.137     0.200
    41.956    -0.923     0.200
    42.289     0.060     0.200
    42.435     0.375     0.200
    42.554     1.514     0.200
    43.040     1.557     0.200
    43.073     1.483     0.200
    43.013     3.183     0.200
    43.086     0.589     0.200
    43.146     1.210     0.200
    43.093     4.035     0.200
    43.275    -0.041     0.200
    43.578     3.120     0.200
    43.722     1.062     0.200
    44.042     0.787     0.200
    44.069    -0.328     0.200
    44.286     0.385     0.200
    44.439    -0.086     0.200
    44.828     1.899     0.200
    44.870     1.274     0.200
    45.309     1.166     0.200
    46.145     3.172     0.200
    46.450     1.774     0.200
    46.918     1.755     0.200
    47.129    -0.035     0.200
    47.081     2.837     0.200
    47.330     2.694     0.200
    47.452     0.949     0.200
    47.494     0.620     0.200
    47.647     2.534     0.200
    47.781    -2.813     0.200
    47.971    -0.083     0.200
    49.059     2.335     0.200
    49.139     1.931     0.200
    49.201    -0.448     0.200
    49.413    -0.266     0.200
    49.498    -0.257     0.200
    49.466    -0.571     0.200
    49.534     2.908     0.200
    50.252     4.450     0.200
    50.979    -0.828     0.200
    51.798     2.831     0.200
    52.301     2.274     0.200
    52.376     0.529     0.200
    52.383    -0.525     0.200
    52.427     3.150     0.200
    52.906     0.607     0.200
    52.923     2.480     0.200
    53.176     3.612     0.200
    53.529     0.720     0.200
    53.823     1.863     0.200
    53.965     0.533     0.200
    53.997     1.590     0.200
    54.024     0.101     0.200
    54.030     0.649     0.200
    54.082     2.971     0.200
    54.324     1.211     0.200
    54.531     1.701     0.200
    54.634     2.455     0.200
    54.646     1.869     0.200
    54.758     2.052     0.200
    54.996     0.937     0.200
    55.241     6.562     0.200
    55.369    -0.361     0.200
    55.451    -0.949     0.200
    55.786     2.643     0.200
    55.946     0.699     0.200
    55.996     0.434     0.200
    55.915     3.715     0.200
    56.027     0.916     0.200
    56.212     1.598     0.200
    56.357     1.557     0.200
    56.375     0.728     0.200
    56.413     0.954     0.200
    56.622     1.874     0.200
    56.630     0.617     0.200
    56.653     1.158     0.200
    56.940     0.419     0.200
    57.067     1.018     0.200
    57.360     0.448     0.200
    57.436     1.409     0.200
    57.504     1.431     0.200
    57.606     1.011     0.200
    57.717     1.432     0.200
    57.746     6.227     0.200
    57.770     1.555     0.200
    57.875     0.818     0.200
    57.968     1.064     0.200
    58.035     1.493     0.200
    58.032     1.195     0.200
    58.083     0.359     0.200
    58.124     0.074     0.200
    58.238     0.977     0.200
    58.393    -1.805     0.200
    58.471     1.051     0.200
    58.558     0.644     0.200
    58.611    -0.389     0.200
    58.633     4.221     0.200
    58.655     0.762     0.200
    58.638     0.484     0.200
    58.708    -0.004     0.200
    58.737    -0.204     0.200
    58.826     1.883     0.200
    58.819     1.725     0.200
    58.839     2.090     0.200
    58.909     0.704     0.200
    58.932     4.644     0.200
    58.962    -0.770     0.200
    59.015     1.965     0.200
    59.065     1.340     0.200
    59.132     1.852     0.200
    59.145     1.364     0.200
    59.192    -0.363     0.200
    59.178     1.238     0.200
    59.260     4.668     0.200
    59.219     2.352     0.200
    59.241     1.300     0.200
    59.288     0.367     0.200
    59.255     1.805     0.200
    59.307     2.136     0.200
    59.329    -3.312     0.200
    59.366     1.322     0.200
    59.402     1.583     0.200
    59.407     0.995     0.200
    59.398     1.214     0.200
    59.433     0.975     0.200
    59.442     0.910     0.200
    59.429     2.103     0.200
    59.475     1.000     0.200
    59.517     2.191     0.200
    59.530     2.005     0.200
    59.680     4.472     0.200
    59.675     1.405     0.200
    59.649     2.183     0.200
    59.657     1.827     0.200
    59.707     1.585     0.200
    59.717     2.015     0.200
    59.729     2.134     0.200
    59.740     2.055     0.200
    59.764     1.581     0.200
    59.785     1.839     0.200
    59.831    -0.771     0.200
    59.865     1.295     0.200
    59.919     1.520     0.200
    59.936     0.427     0.200
    59.993     1.118     0.200
    60.017     3.339     0.200
    60.015     0.568     0.200
    60.026     0.388     0.200
    60.006     1.922     0.200
    60.073     2.069     0.200
    60.137     0.624     0.200
    60.236     1.051     0.200
    60.275     1.781     0.200
    60.382    -0.026     0.200
    60.390     2.277     0.200
    60.375     2.103     0.200
    60.412     1.042     0.200
    60.533     1.124     0.200
    60.520     0.507     0.200
    60.564     0.605     0.200
    60.546     2.229     0.200
    60.637     2.206     0.200
    60.671    -0.626     0.200
    60.703     0.551     0.200
    60.769     0.607     0.200
    60.786     1.395     0.200
    60.796     1.624     0.200
    60.868     0.741     0.200
    60.940     2.350     0.200
    60.993     0.284     0.200
    61.073     0.541     0.200
    61.126     0.883     0.200
    61.160     2.354     0.200
    61.221     0.342     0.200
    61.224     0.351     0.200
    61.236     0.749     0.200
    61.237     1.338     0.200
    61.259     0.383     0.200
    61.255     1.512     0.200
    61.297     0.229     0.200
    61.355     0.627     0.200
    61.483     2.366     0.200
    61.582     5.297     0.200
    61.574     1.958     0.200
    61.753     1.150     0.200
    61.778     0.684     0.200
    61.775     2.100     0.200
    61.866     1.147     0.200
    61.968     2.406     0.200
    62.195     1.275     0.200
    62.398     1.216     0.200
    62.600     0.767     0.200
    62.591    -0.474     0.200
    62.649     1.141     0.200
    62.798    -1.647     0.200
    62.805     0.100     0.200
    62.831     0.025     0.200
    63.014     1.231     0.200
    63.020    -0.032     0.200
    63.034     0.676     0.200
    63.131     1.430     0.200
    63.138     0.182     0.200
    63.139     1.583     0.200
    63.179     1.643     0.200
    63.207    -0.276     0.200
    63.219    -0.253     0.200
    63.215     0.128     0.200
    63.299     0.321     0.200
    63.353     0.167     0.200
    63.421     0.110     0.200
    63.466    -0.987     0.200
    63.530     1.018     0.200
    63.590    -0.395     0.200
    63.585     1.827     0.200
    63.617     1.816     0.200
    63.658    -0.255     0.200
    63.654     0.373     0.200
    63.596     3.458     0.200
    63.800    -1.592     0.200
    63.810     0.149     0.200
    63.903    -1.218     0.200
    63.927    -0.780     0.200
    64.024     0.034     0.200
    64.044     0.303     0.200
    64.089     0.902     0.200
    64.102     0.621     0.200
    64.197     0.798     0.200
    64.194     0.665     0.200
    64.206     0.135     0.200
    64.278     0.366     0.200
    64.285     1.223     0.200
    64.502     1.196     0.200
    64.570     0.162     0.200
    64.609     0.099     0.200
    64.769     0.554     0.200
    64.764     2.484     0.200
    64.903     0.388     0.200
    64.930     2.031     0.200
    64.975     0.817     0.200
    65.013     0.468     0.200
    65.249     2.226     0.200
    65.379     1.085     0.200
    65.367     0.568     0.200
    65.427     1.789     0.200
    65.473     1.187     0.200
    65.532     1.023     0.200
    65.568     1.113     0.200
    65.840     1.289     0.200
    65.853     0.344     0.200
    65.852     2.101     0.200
    65.971     1.075     0.200
    66.016     0.982     0.200
    66.122     1.858     0.200
    66.960     1.586     0.200
    67.341     2.103     0.200
    67.536     1.690     0.200
    67.740     0.608     0.200
    67.872     5.271     0.200
    68.150     1.821     0.200
    69.341     0.102     0.200
    69.484     2.626     0.200
    70.130     2.270     0.200
    70.538     1.599     0.200
    70.555     2.502     0.200
    71.265     2.224     0.200
    71.312     7.049     0.200
    71.826     1.405     0.200
    72.181     2.209     0.200
    72.375     1.831     0.200
    72.611     2.362     0.200
    73.022     1.932     0.200
    73.521     2.290     0.200
    73.555     2.644     0.200
    73.573     0.643     0.200
    73.575     2.099     0.200
    73.938     4.454     0.200
    74.233     2.597     0.200
    74.426     2.372     0.200
    74.441     2.926     0.200
    74.361     0.957     0.200
    74.549     3.797     0.200
    74.735     2.275     0.200
    74.754     1.876     0.200
    75.124     1.723     0.200
    75.439     2.113     0.200
    75.486     2.704     0.200
    76.152     2.391     0.200
    76.170     0.935     0.200
    76.362     1.930     0.200
    76.664     0.936     0.200
    76.811     2.715     0.200
    77.182     2.149     0.200
    77.261     2.129     0.200
    77.261     2.419     0.200
    77.324     2.682     0.200
    77.395     1.132     0.200
    77.525     0.906     0.200
    77.527     0.692     0.200
    77.844     1.627     0.200
    77.969     2.481     0.200
    78.111     6.144     0.200
    78.456     1.347     0.200
    78.626     0.952     0.200
    79.047     1.890     0.200
    79.195     6.176     0.200
    80.089     2.237     0.200
    81.122     0.676     0.200
    81.296     2.205     0.200
    82.034     1.030     0.200
    82.135     0.036     0.200
    82.704     0.666     0.200
    83.451     1.593     0.200
    85.441     1.415     0.200
    85.541    -0.482     0.200
    86.914     0.247     0.200
    87.225    -0.265     0.200
    87.839     0.902     0.200
    87.962     0.926     0.200
    87.986     1.018     0.200
    87.890     0.439     0.200
    88.288     0.155     0.200
    88.346     2.586     0.200
    88.461     1.244     0.200
    88.372     2.858     0.200
    88.592     1.425     0.200
    89.223     0.852     0.200
    90.427     0.625     0.200
    16.679     3.887     0.200
    17.930     3.783     0.200
    18.035     2.244     0.200
    18.035     2.494     0.200
    19.954     1.049     0.200
    19.954     1.850     0.200
    20.152     1.887     0.200
    21.000     2.700     0.200
    21.591     2.335     0.200
    21.591     2.535     0.200
    21.716     0.795     0.200
    21.779     2.316     0.200
    21.779     2.417     0.200
    22.693     3.381     0.200
    23.027     3.241     0.200
    23.500    -0.926     0.200
    23.500    -0.426     0.200
    23.466     2.927     0.200
    23.577     0.350     0.200
    23.577     0.951     0.200
    23.911     1.293     0.200
    23.911     1.492     0.200
    24.092     0.638     0.200
    24.092     0.837     0.200
    24.279    -0.375     0.200
    24.279    -0.066     0.200
    24.297     1.771     0.200
    24.391     0.914     0.200
    24.391     1.715     0.200
    24.615     2.670     0.200
    24.872    -0.474     0.200
    25.012     0.255     0.200
    25.116    -0.688     0.200
    25.116     0.211     0.200
    25.206     0.489     0.200
    25.330     1.363     0.200
    25.467    -0.877     0.200
    25.467    -0.377     0.200
    25.658     1.887     0.200
    27.256     1.960     0.200
    27.607     3.210     0.200
    29.122     3.314     0.200
    30.040     0.382     0.200
    30.665     1.658     0.200
    30.884     3.213     0.200
    31.264     3.376     0.200
    31.884     0.454     0.200
    31.873     0.837     0.200
    31.873     1.516     0.200
    32.257     3.640     0.200
    32.902     5.693     0.200
    33.712     2.731     0.200
    36.329     2.861     0.200
    36.381     3.541     0.200
    36.672     3.782     0.200
    36.755     3.690     0.200
    36.946     3.469     0.200
    37.039     3.940     0.200
    37.138    -1.481     0.200
    37.138     0.070     0.200
    37.139     3.909     0.200
    37.172     3.629     0.200
    37.200     2.769     0.200
    37.255    -0.129     0.200
    37.255    -0.469     0.200
    37.235     4.096     0.200
    37.272     4.024     0.200
    37.798     3.746     0.200
    37.803     3.977     0.200
    37.962     4.489     0.200
    38.069     2.588     0.200
    38.293     0.699     0.200
    39.001     3.452     0.200
    39.842     1.389     0.200
    39.842     1.541     0.200
    40.196     2.002     0.200
    40.262     1.053     0.200
    40.227    -0.460     0.200
    40.282     2.086     0.200
    40.426     0.573     0.200
    40.394     2.160     0.200
    40.421     3.939     0.200
    40.620     1.017     0.200
    41.061     0.142     0.200
    41.366     0.057     0.200
    41.776     1.624     0.200
    41.880    -1.065     0.200
    42.284    -0.367     0.200
    42.539     1.559     0.200
    42.539     1.290     0.200
    42.539     1.458     0.200
    43.026     2.122     0.200
    43.038    -3.588     0.200
    43.058     1.688     0.200
    43.017     4.679     0.200
    43.079     1.179     0.200
    43.141     0.681     0.200
    43.141     0.169     0.200
    43.109     4.237     0.200
    43.159     3.162     0.200
    43.159     3.033     0.200
    43.267     0.261     0.200
    43.583     3.911     0.200
    43.831     0.362     0.200
    44.028     0.524     0.200
    44.055    -0.483     0.200
    44.814     1.551     0.200
    44.826    -1.441     0.200
    44.881     0.812     0.200
    45.067     1.408     0.200
    45.067     0.634     0.200
    45.294     1.211     0.200
    45.716     2.085     0.200
    45.994     5.393     0.200
    46.465     3.186     0.200
    46.698    -0.130     0.200
    46.760     2.676     0.200
    46.904     0.752     0.200
    46.904     1.553     0.200
    47.080     1.370     0.200
    47.329     2.661     0.200
    47.329     2.930     0.200
    47.446     0.525     0.200
    47.494     1.149     0.200
    47.657    -1.015     0.200
    47.657    -0.216     0.200
    47.963     0.313     0.200
    48.373     6.339     0.200
    48.450     5.249     0.200
    48.748     5.454     0.200
    48.899     5.532     0.200
    48.899     5.673     0.200
    49.072     1.967     0.200
    49.137     3.467     0.200
    49.403    -0.063     0.200
    49.488     0.526     0.200
    49.464     1.970     0.200
    49.536     3.423     0.200
    49.823     2.235     0.200
    49.969     1.228     0.200
    50.264     4.887     0.200
    50.502     3.090     0.200
    50.966     0.439     0.200
    50.970     0.438     0.200
    50.970    -0.042     0.200
    51.037     1.053     0.200
    51.162     2.115     0.200
    51.220     4.578     0.200
    51.502     1.056     0.200
    51.771     0.664     0.200
    51.803    -3.128     0.200
    51.834    -3.392     0.200
    51.800     3.438     0.200
    51.955    -3.345     0.200
    51.950     2.025     0.200
    52.286     2.531     0.200
    52.221     2.204     0.200
    52.378    -0.959     0.200
    52.897     1.894     0.200
    52.936     2.409     0.200
    53.172     1.667     0.200
    53.292     2.782     0.200
    53.377     1.662     0.200
    53.545     2.427     0.200
    53.608     3.161     0.200
    53.745     2.562     0.200
    53.791     3.122     0.200
    53.819     1.415     0.200
    53.867     2.465     0.200
    53.958     0.798     0.200
    53.993     0.644     0.200
    54.018     0.268     0.200
    54.025     0.916     0.200
    54.078     2.524     0.200
    54.241     0.336     0.200
    54.289     2.985     0.200
    54.298     0.420     0.200
    54.318     1.779     0.200
    54.525     2.167     0.200
    54.613     2.327     0.200
    54.630     2.508     0.200
    54.642     0.423     0.200
    54.647     3.386     0.200
    54.752     1.623     0.200
    54.894     0.597     0.200
    54.926     0.164     0.200
    54.946     2.218     0.200
    55.005     1.915     0.200
    54.991     1.089     0.200
    54.989     1.011     0.200
    55.060     1.893     0.200
    55.237     3.117     0.200
    55.261     1.013     0.200
    55.256    -0.024     0.200
    55.348     1.467     0.200
    55.326    -0.025     0.200
    55.399     2.358     0.200
    53.310     3.755     0.200
    55.447     0.602     0.200
    55.536     1.392     0.200
    55.527     1.027     0.200
    55.657    -0.109     0.200
    55.742     2.984     0.200
    55.781     3.201     0.200
    55.939     0.572     0.200
    55.989     0.112     0.200
    56.021     1.256     0.200
    56.091     2.383     0.200
    56.160     4.094     0.200
    56.241     3.110     0.200
    56.280     1.630     0.200
    56.355     2.498     0.200
    56.368     1.204     0.200
    56.368     1.313     0.200
    56.341     0.698     0.200
    56.396    -0.193     0.200
    56.408     2.223     0.200
    56.581    -0.512     0.200
    56.622     0.947     0.200
    56.626     0.167     0.200
    56.646     1.722     0.200
    56.742     1.543     0.200
    56.933     1.788     0.200
    57.059     0.993     0.200
    57.087    -3.104     0.200
    57.211     2.022     0.200
    57.271     1.600     0.200
    57.271     1.010     0.200
    57.357     2.188     0.200
    57.383     3.807     0.200
    57.429     1.781     0.200
    57.508     1.127     0.200
    57.508     1.427     0.200
    57.543     0.679     0.200
    57.580    -0.023     0.200
    57.599     1.086     0.200
    57.692    -0.368     0.200
    57.710     1.606     0.200
    57.710     1.434     0.200
    57.767     0.101     0.200
    57.770     0.083     0.200
    57.824     0.802     0.200
    57.867     0.799     0.200
    57.866     0.982     0.200
    57.934     0.989     0.200
    57.947     1.341     0.200
    57.961     0.939     0.200
    57.973     0.984     0.200
    57.995     1.059     0.200
    57.997     0.984     0.200
    58.020     1.000     0.200
    58.029     1.067     0.200
    58.029     1.462     0.200
    58.080    -0.094     0.200
    58.120    -0.376     0.200
    58.090     1.835     0.200
    58.108     0.990     0.200
    58.117     0.687     0.200
    58.197     0.886     0.200
    58.229     0.989     0.200
    58.253     1.294     0.200
    58.237     3.610     0.200
    58.264     0.921     0.200
    58.310     0.993     0.200
    58.345     1.052     0.200
    58.384     0.992     0.200
    58.390     0.736     0.200
    58.441     0.993     0.200
    58.470     1.076     0.200
    58.544     0.840     0.200
    58.550     0.224     0.200
    58.601    -0.732     0.200
    58.629     1.571     0.200
    58.629     0.200     0.200
    58.648     0.840     0.200
    58.648     0.730     0.200
    58.705     1.436     0.200
    58.733    -0.655     0.200
    58.819     1.851     0.200
    58.819     1.750     0.200
    58.839     2.109     0.200
    58.903     0.865     0.200
    58.957     0.793     0.200
    59.016     2.183     0.200
    59.061     0.965     0.200
    59.138     1.436     0.200
    59.138     1.076     0.200
    59.184     0.218     0.200
    59.183     0.210     0.200
    59.175     2.380     0.200
    59.250     0.259     0.200
    59.239     0.832     0.200
    59.255     1.824     0.200
    59.279     0.447     0.200
    59.308     2.255     0.200
    59.352     1.680     0.200
    59.363     5.979     0.200
    59.398     1.733     0.200
    59.426     0.540     0.200
    59.438     0.960     0.200
    59.429     2.122     0.200
    59.472     1.354     0.200
    59.504     1.592     0.200
    59.521     1.889     0.200
    59.517     2.111     0.200
    59.531     2.019     0.200
    59.537     1.774     0.200
    59.656     1.419     0.200
    59.668     1.474     0.200
    59.650     2.197     0.200
    59.657     1.846     0.200
    59.700     1.853     0.200
    59.710     0.381     0.200
    59.703     1.630     0.200
    59.745     1.342     0.200
    59.744     0.653     0.200
    59.738     0.392     0.200
    59.730     1.948     0.200
    59.741     1.870     0.200
    59.859     0.858     0.200
    59.866    -2.490     0.200
    59.891     0.942     0.200
    59.912     1.590     0.200
    59.936     0.958     0.200
    59.984     1.118     0.200
    59.984     0.586     0.200
    60.009     0.440     0.200
    60.009     1.729     0.200
    60.020     0.453     0.200
    60.007     1.940     0.200
    60.070     0.216     0.200
    60.077     0.249     0.200
    60.073     2.086     0.200
    60.111     0.517     0.200
    60.133     1.875     0.200
    60.153     1.537     0.200
    60.204     0.533     0.200
    60.227     0.428     0.200
    60.379     0.494     0.200
    60.378     0.598     0.200
    60.375     2.018     0.200
    60.425     0.393     0.200
    60.452    -0.017     0.200
    60.479     0.367     0.200
    60.525     0.394     0.200
    60.556     0.680     0.200
    60.556     0.480     0.200
    60.547     2.045     0.200
    60.567     1.512     0.200
    60.593     1.231     0.200
    60.592     0.340     0.200
    60.592     0.539     0.200
    60.657     0.196     0.200
    60.667     0.128     0.200
    60.695     0.515     0.200
    60.710     2.232     0.200
    60.721     3.656     0.200
    60.767     1.244     0.200
    60.761     0.384     0.200
    60.761     0.533     0.200
    60.779     1.261     0.200
    60.779     1.761     0.200
    60.803    -0.203     0.200
    60.792     1.673     0.200
    60.818    -0.102     0.200
    60.860     0.813     0.200
    60.941     2.162     0.200
    60.981     1.490     0.200
    60.983     1.479     0.200
    61.065     0.516     0.200
    61.119     1.153     0.200
    61.119     1.653     0.200
    61.175     1.176     0.200
    61.161     2.165     0.200
    61.213     0.515     0.200
    61.217     0.593     0.200
    61.217     0.191     0.200
    61.228     0.841     0.200
    61.229     1.603     0.200
    61.229     1.806     0.200
    61.251     0.259     0.200
    61.251     0.059     0.200
    61.251     1.060     0.200
    61.291     0.887     0.200
    61.293    -1.329     0.200
    61.348     0.799     0.200
    61.378     0.291     0.200
    61.383     1.269     0.200
    61.419     2.923     0.200
    61.428     0.858     0.200
    61.484     2.283     0.200
    61.587     0.687     0.200
    61.592     0.649     0.200
    61.574     1.872     0.200
    61.688    -0.193     0.200
    61.771     1.050     0.200
    61.776     2.013     0.200
    61.976     1.969     0.200
    61.969     2.318     0.200
    62.000     1.406     0.200
    62.006     1.465     0.200
    62.130     0.735     0.200
    62.188     1.543     0.200
    62.188     0.844     0.200
    62.259     1.468     0.200
    62.289     1.369     0.200
    62.282     1.616     0.200
    62.282     1.217     0.200
    62.286     1.189     0.200
    62.360     1.094     0.200
    62.391     1.387     0.200
    62.391     1.586     0.200
    62.468     0.367     0.200
    62.604     1.358     0.200
    62.612     1.209     0.200
    62.643     1.704     0.200
    62.693     1.168     0.200
    62.795    -0.413     0.200
    62.801    -0.356     0.200
    62.823    -0.103     0.200
    62.823    -0.302     0.200
    62.839     1.694     0.200
    62.839     1.131     0.200
    62.920     0.955     0.200
    62.932     0.075     0.200
    62.998     0.734     0.200
    63.007     1.667     0.200
    63.012    -0.153     0.200
    63.012    -0.255     0.200
    63.124     1.300     0.200
    63.130     0.060     0.200
    63.130     0.658     0.200
    63.132     1.449     0.200
    63.132     1.348     0.200
    63.172     0.069     0.200
    63.172     1.580     0.200
    63.198    -0.392     0.200
    63.198    -0.595     0.200
    63.210    -0.373     0.200
    63.210    -0.572     0.200
    63.192     2.153     0.200
    63.208     0.567     0.200
    63.278     2.282     0.200
    63.290     0.295     0.200
    63.345    -0.064     0.200
    63.413    -0.117     0.200
    63.413    -0.219     0.200
    63.409     1.210     0.200
    63.515     0.911     0.200
    63.515     1.309     0.200
    63.526     1.141     0.200
    63.583    -0.181     0.200
    63.580     1.581     0.200
    63.587     1.034     0.200
    63.659     2.017     0.200
    63.613     1.663     0.200
    63.607     2.299     0.200
    63.629     0.853     0.200
    63.649    -0.371     0.200
    63.649    -0.574     0.200
    63.647     0.271     0.200
    63.651     1.810     0.200
    63.692     1.539     0.200
    63.747     1.075     0.200
    63.793    -0.322     0.200
    63.801     0.020     0.200
    63.801     1.622     0.200
    63.835     3.297     0.200
    63.896    -0.183     0.200
    63.920    -1.159     0.200
    63.958     0.738     0.200
    64.015    -0.188     0.200
    64.082     0.671     0.200
    64.098     0.968     0.200
    64.111     0.379     0.200
    64.142     0.680     0.200
    64.189     0.574     0.200
    64.187     0.379     0.200
    64.187     0.481     0.200
    64.198     0.510     0.200
    64.247     1.511     0.200
    64.212    -0.182     0.200
    64.299    -0.388     0.200
    64.270     0.240     0.200
    64.278    -0.110     0.200
    64.316     0.636     0.200
    64.410     0.623     0.200
    64.487     1.516     0.200
    64.487     1.817     0.200
    64.505     0.704     0.200
    64.561    -0.068     0.200
    64.570     1.678     0.200
    64.603    -0.238     0.200
    64.603     0.563     0.200
    64.694     2.358     0.200
    64.748     0.513     0.200
    64.762     0.221     0.200
    64.762     0.620     0.200
    64.774     1.642     0.200
    64.915     1.425     0.200
    64.894     0.261     0.200
    64.894     0.062     0.200
    64.968     0.281     0.200
    65.030     0.580     0.200
    65.052     1.036     0.200
    65.234     1.654     0.200
    65.234     1.853     0.200
    65.364     1.042     0.200
    65.359     0.343     0.200
    65.359     0.242     0.200
    65.412     1.768     0.200
    65.465     1.055     0.200
    65.465     0.856     0.200
    65.553     1.148     0.200
    65.825     1.584     0.200
    65.837     1.754     0.200
    65.837     2.153     0.200
    65.838     1.079     0.200
    65.848     2.007     0.200
    65.963     0.944     0.200
    66.008     0.854     0.200
    66.008     0.554     0.200
    66.107     1.828     0.200
    66.310     1.406     0.200
    66.362     1.683     0.200
    66.808     2.678     0.200
    66.894     2.116     0.200
    66.937     0.869     0.200
    67.041     2.009     0.200
    67.189     2.208     0.200
    67.192     1.588     0.200
    67.326     2.098     0.200
    67.329     1.893     0.200
    67.354    -3.201     0.200
    67.424     1.816     0.200
    67.521     1.898     0.200
    67.732     0.576     0.200
    67.732     0.279     0.200
    67.869     2.192     0.200
    67.864     1.739     0.200
    68.080     2.659     0.200
    68.451    -3.569     0.200
    69.106     3.079     0.200
    69.106     3.278     0.200
    69.180    -2.840     0.200
    69.505     1.709     0.200
    69.473    -3.712     0.200
    69.550     0.328     0.200
    70.043     3.772     0.200
    70.115     1.853     0.200
    70.115     1.954     0.200
    70.126     2.693     0.200
    70.099     1.271     0.200
    70.207    -3.792     0.200
    70.524     1.774     0.200
    70.547    -2.791     0.200
    70.935     2.528     0.200
    71.058    -3.095     0.200
    71.115    -3.782     0.200
    71.316     3.037     0.200
    71.811     1.086     0.200
    71.816    -3.274     0.200
    71.924     2.486     0.200
    71.885    -2.942     0.200
    72.096     1.344     0.200
    72.166     2.426     0.200
    72.361     2.220     0.200
    72.287     2.723     0.200
    72.525     1.283     0.200
    72.525     0.923     0.200
    72.677     1.877     0.200
    72.718    -3.993     0.200
    72.955     2.231     0.200
    73.007     1.421     0.200
    73.007     2.121     0.200
    73.083     1.972     0.200
    73.083     2.472     0.200
    73.162     0.844     0.200
    73.434    -1.101     0.200
    73.541     2.270     0.200
    73.541     2.570     0.200
    73.561     2.140     0.200
    73.708     1.289     0.200
    73.708     1.789     0.200
    73.730     2.567     0.200
    74.411     2.179     0.200
    74.369     1.424     0.200
    74.438     2.282     0.200
    74.454     3.361     0.200
    74.509     3.159     0.200
    74.462     2.885     0.200
    74.596     2.866     0.200
    74.720     2.031     0.200
    74.904     1.819     0.200
    75.019     2.657     0.200
    75.116    -3.543     0.200
    75.145    -3.892     0.200
    75.389     2.527     0.200
    75.424     1.927     0.200
    75.472     2.051     0.200
    75.472     2.551     0.200
    75.658    -3.180     0.200
    75.927    -0.553     0.200
    75.973     2.681     0.200
    76.137     1.250     0.200
    76.137     1.949     0.200
    76.155     1.287     0.200
    76.164     2.627     0.200
    76.347     1.053     0.200
    76.347     1.952     0.200
    76.374     1.203     0.200
    76.648     1.842     0.200
    76.592     3.665     0.200
    76.796     1.513     0.200
    76.796     2.114     0.200
    77.167     2.019     0.200
    77.245     1.899     0.200
    77.245     2.789     0.200
    77.245     2.060     0.200
    77.254     1.640     0.200
    77.308     2.262     0.200
    77.330     1.514     0.200
    77.539     0.842     0.200
    77.532     1.083     0.200
    77.547     0.698     0.200
    77.653     1.868     0.200
    77.954     2.368     0.200
    78.006     1.739     0.200
    78.006     2.540     0.200
    78.276    -0.582     0.200
    78.259     0.335     0.200
    78.441     1.401     0.200
    78.958     1.875     0.200
    78.939     0.591     0.200
    79.033     2.076     0.200
    79.033     2.177     0.200
    79.121     1.062     0.200
    79.191    -0.891     0.200
    79.359    -0.710     0.200
    79.484    -0.391     0.200
    79.829     2.750     0.200
    80.075     2.407     0.200
    80.069     1.585     0.200
    80.250     0.301     0.200
    80.802     0.928     0.200
    80.871     1.299     0.200
    80.871     2.025     0.200
    81.136     0.817     0.200
    81.281     1.986     0.200
    81.816     1.120     0.200
    82.119     0.564     0.200
    82.256     1.004     0.200
    82.278     2.090     0.200
    82.445     0.418     0.200
    82.688     0.712     0.200
    82.688    -0.448     0.200
    82.742     2.073     0.200
    82.863     0.583     0.200
    82.843     0.749     0.200
    82.971     0.085     0.200
    83.368     3.130     0.200
    83.435     1.086     0.200
    83.460     2.556     0.200
    83.569    -0.003     0.200
    83.569     0.599     0.200
    83.759     1.615     0.200
    83.769     1.072     0.200
    83.993     1.225     0.200
    84.692     0.281     0.200
    84.692     1.179     0.200
    85.035     0.554     0.200
    85.035     0.855     0.200
    85.278     0.891     0.200
    85.556     1.950     0.200
    86.061     1.552     0.200
    86.248     0.528     0.200
    86.211     3.709     0.200
    86.671     0.526     0.200
    86.775     1.939     0.200
    86.884     1.605     0.200
    86.930    -0.421     0.200
    87.159     1.478     0.200
    87.159     1.049     0.200
    87.444     0.287     0.200
    87.514     0.348     0.200
    87.823     0.873     0.200
    87.823     1.373     0.200
    87.946     0.287     0.200
    87.946     0.588     0.200
    87.969     0.176     0.200
    87.969     0.875     0.200
    88.050     2.990     0.200
    88.304     0.789     0.200
    88.445     1.745     0.200
    89.126     0.716     0.200
    89.126     1.415     0.200
    89.239     0.186     0.200
    89.409     3.627     0.200
    90.440     0.873     0.200
    94.335     3.077     0.200
    95.327     1.834     0.200
    16.960     7.179     0.200
    21.593     3.773     0.200
    23.509     4.114     0.200
    24.056     2.807     0.200
    41.833     0.904     0.200
    41.941     1.713     0.200
    42.330     1.644     0.200
    43.111     0.512     0.200
    43.607     0.711     0.200
    43.919     3.997     0.200
    44.250     1.245     0.200
    44.736     0.658     0.200
    47.470     1.434     0.200
    47.792     0.435     0.200
    49.000     1.122     0.200
    49.191     0.460     0.200
    49.304     0.601     0.200
    55.869     1.192     0.200
    56.937     0.589     0.200
    57.330     1.304     0.200
    57.503     1.686     0.200
    57.503     1.487     0.200
    58.360    -0.424     0.200
    61.084    -0.674     0.200
    62.676    -0.678     0.200
    62.676     0.022     0.200
    62.867    -0.150     0.200
    62.982     0.086     0.200
    63.014     0.173     0.200
    63.007     0.418     0.200
    63.029     0.172     0.200
    63.201     0.031     0.200
    63.464     0.290     0.200
    64.405    -0.100     0.200
    65.574     1.898     0.200
    68.264    -0.016     0.200
    72.110     1.521     0.200
    72.559     0.442     0.200
    73.811     1.315     0.200
    75.537     1.110     0.200
    76.641     0.938     0.200
    76.707     2.359     0.200
    77.950     1.022     0.200
    77.958     0.780     0.200
    80.679     2.536     0.200
    81.555     0.973     0.200
    82.833     2.382     0.200
    83.155     0.522     0.200
    86.750     2.249     0.200
    87.942     0.398     0.200
    90.818     0.910     0.200
    91.172     1.466     0.200
    43.839     0.841     0.200
    49.301     1.094     0.200
    54.738     0.293     0.200
    57.646     1.519     0.200
    62.903     1.424     0.200
    43.456     2.055     0.200
    43.695     0.631     0.200
    37.094     2.793     0.200
    37.196     2.063     0.200
    37.305     2.301     0.200
    37.608     2.434     0.200
    37.754     1.717     0.200
    39.521    -0.577     0.200
    43.259     0.727     0.200
    43.312     1.205     0.200
    43.744     0.322     0.200
    47.137     2.325     0.200
    49.432    -0.093     0.200
    49.432     0.509     0.200
    49.537    -0.396     0.200
    54.719     2.145     0.200
    57.382     2.484     0.200
    57.550     1.002     0.200
    57.927     0.954     0.200
    60.532     0.416     0.200
    62.808    -0.437     0.200
    63.096     1.146     0.200
    63.115     0.118     0.200
    63.208    -0.793     0.200
    63.217    -0.658     0.200
    63.327    -0.382     0.200
    63.658     0.026     0.200
    64.383    -0.341     0.200
    64.893    -0.173     0.200
    73.539     1.514     0.200
    73.539     0.724     0.200
    74.449     1.397     0.200
    74.793     2.405     0.200
    77.455     2.249     0.200
    77.546     2.251     0.200
    77.688     2.949     0.200
    80.959     2.090     0.200
    90.725     1.466     0.200
    18.607     3.011     0.200
    18.528    -0.218     0.200
    37.514     3.043     0.200
    37.636     2.900     0.200
    37.938     2.565     0.200
    37.894     1.355     0.200
    43.101     3.393     0.200
    44.081     0.193     0.200
    47.556     1.453     0.200
    57.910     0.974     0.200
    16.925     4.666     0.200
    19.211     2.306     0.200
    21.241     2.491     0.200
    21.743     2.092     0.200
    23.728     0.752     0.200
    23.922     3.079     0.200
    23.951     2.315     0.200
    28.136     1.773     0.200
    31.036     1.947     0.200
    31.456     1.772     0.200
    31.828     2.797     0.200
    32.661     0.585     0.200
    37.730    -0.062     0.200
    37.728     0.336     0.200
    39.141     1.377     0.200
    39.867     1.083     0.200
    41.839     0.835     0.200
    42.103     0.070     0.200
    42.236     0.962     0.200
    43.808    -0.116     0.200
    44.306     0.264     0.200
    45.402     1.922     0.200
    45.437     0.481     0.200
    46.794    -0.757     0.200
    48.168     2.177     0.200
    48.173     2.274     0.200
    48.351     1.895     0.200
    49.867    -0.079     0.200
    50.120    -0.555     0.200
    53.809    -0.328     0.200
    58.042     1.056     0.200
    58.216     1.843     0.200
    63.700     0.172     0.200
    63.717    -0.837     0.200
    64.150     0.610     0.200
    64.698     1.459     0.200
    64.886     1.211     0.200
    65.173     1.404     0.200
    67.627     1.114     0.200
    67.648     2.188     0.200
    68.606     0.006     0.200
    68.852     1.643     0.200
    69.024     0.935     0.200
    69.601     1.769     0.200
    69.666     1.412     0.200
    70.055     1.208     0.200
    70.189     1.117     0.200
    72.806     1.147     0.200
    72.893     1.692     0.200
    72.965    -0.417     0.200
    73.271     1.921     0.200
    73.724     1.541     0.200
    74.769     0.286     0.200
    77.018     1.639     0.200
    77.204     1.594     0.200
    77.426     0.770     0.200
    81.039     0.971     0.200
    81.039     0.921     0.200
    81.289     0.822     0.200
    83.172     0.591     0.200
    86.693     1.298     0.200
    90.257     1.011     0.200
    91.849     1.047     0.200
    76.618    -0.379     0.200
    80.229    -0.373     0.200
    24.313     2.968     0.200
    49.498    -0.392     0.200
    16.337     7.273     0.200
    16.647     5.529     0.200
    16.670     3.170     0.200
    16.856     2.690     0.200
    17.484     1.486     0.200
    22.655     3.000     0.200
    22.994     1.914     0.200
    23.469     2.711     0.200
    23.469     1.141     0.200
    23.784     0.834     0.200
    23.930     1.295     0.200
    24.586     2.331     0.200
    25.632     2.128     0.200
    27.196     0.879     0.200
    27.238     0.807     0.200
    30.433     2.783     0.200
    30.473     2.721     0.200
    30.595     2.856     0.200
    30.821     3.525     0.200
    30.855     2.645     0.200
    31.228     2.193     0.200
    31.232     2.768     0.200
    31.347     0.422     0.200
    31.863     0.904     0.200
    33.358     3.512     0.200
    36.290     1.686     0.200
    37.001     2.127     0.200
    37.197     2.658     0.200
    37.564     1.156     0.200
    37.567     3.201     0.200
    37.766     1.940     0.200
    37.834     3.165     0.200
    39.474    -0.151     0.200
    39.880     1.535     0.200
    40.697     1.796     0.200
    40.900     0.175     0.200
    42.968     1.125     0.200
    43.337     3.016     0.200
    43.760    -0.473     0.200
    44.066     0.598     0.200
    44.062    -0.050     0.200
    44.235     0.737     0.200
    44.892     0.995     0.200
    46.003     1.831     0.200
    46.377     1.570     0.200
    47.315     2.431     0.200
    47.315     2.552     0.200
    49.035     1.942     0.200
    49.381     0.415     0.200
    49.411    -0.237     0.200
    49.411    -0.448     0.200
    49.663     2.498     0.200
    50.046     1.661     0.200
    53.104     1.341     0.200
    53.588     2.677     0.200
    54.394    -0.450     0.200
    55.057     1.749     0.200
    55.260     0.242     0.200
    55.348     1.003     0.200
    55.991     0.385     0.200
    57.437     1.137     0.200
    57.430     0.762     0.200
    57.599     0.853     0.200
    60.077     3.136     0.200
    60.460     1.151     0.200
    60.836     0.830     0.200
    60.815     0.776     0.200
    61.207     3.735     0.200
    61.355     4.233     0.200
    62.135     1.470     0.200
    62.138     1.946     0.200
    62.299     2.613     0.200
    62.333     2.214     0.200
    62.529     2.110     0.200
    62.721     1.812     0.200
    62.917     1.906     0.200
    63.126     4.270     0.200
    63.527     4.761     0.200
    63.755     4.106     0.200
    64.336    -0.509     0.200
    64.374     3.639     0.200
    64.498     4.124     0.200
    64.875     3.765     0.200
    64.953     1.854     0.200
    65.380     1.850     0.200
    65.472     3.993     0.200
    65.855     2.079     0.200
    66.080     2.809     0.200
    66.738     4.159     0.200
    66.831     2.627     0.200
    68.195     5.045     0.200
    68.318     1.360     0.200
    68.825    -0.323     0.200
    68.946     1.104     0.200
    70.004     1.122     0.200
    70.301     1.677     0.200
    70.424     1.100     0.200
    70.753     1.735     0.200
    70.909     1.666     0.200
    72.272     0.784     0.200
    73.200     1.004     0.200
    73.601     1.809     0.200
    74.048     2.197     0.200
    74.450     1.919     0.200
    74.722     0.762     0.200
    76.175     2.405     0.200
    77.347     2.292     0.200
    77.510     0.210     0.200
    77.518     0.348     0.200
    77.520     0.126     0.200
    77.719     1.801     0.200
    77.791     1.672     0.200
    77.897     1.893     0.200
    79.043     1.445     0.200
    81.114     0.506     0.200
    83.796     1.312     0.200
    84.651     1.478     0.200
    15.271     4.020     0.200
    17.482     1.411     0.200
    18.053     4.861     0.200
    20.031     2.154     0.200
    20.328    -0.290     0.200
    22.663     3.204     0.200
    22.996     2.985     0.200
    23.440     1.913     0.200
    23.469     3.301     0.200
    24.283    -0.382     0.200
    24.492    -0.386     0.200
    24.492     1.354     0.200
    24.597     2.256     0.200
    25.643     1.853     0.200
    26.215     2.472     0.200
    27.027     1.794     0.200
    30.063     2.856     0.200
    30.433     3.008     0.200
    30.473     2.942     0.200
    30.594     3.199     0.200
    30.649     2.431     0.200
    30.657     2.358     0.200
    30.821     4.085     0.200
    30.855     3.029     0.200
    30.855    -0.691     0.200
    30.855     1.469     0.200
    31.121     3.293     0.200
    31.231     3.042     0.200
    31.436     0.588     0.200
    31.857     1.188     0.200
    32.870     6.504     0.200
    32.870     2.504     0.200
    36.640     2.938     0.200
    37.006     3.019     0.200
    37.106     3.367     0.200
    37.139     2.987     0.200
    37.239     3.139     0.200
    37.771     3.635     0.200
    37.824     0.784     0.200
    38.261     4.102     0.200
    40.021     0.881     0.200
    40.427     0.660     0.200
    41.368    -1.175     0.200
    42.273    -0.837     0.200
    42.566    -0.622     0.200
    42.566     2.378     0.200
    42.849     1.174     0.200
    43.129     1.211     0.200
    43.129     0.591     0.200
    43.262    -0.667     0.200
    43.180     2.196     0.200
    43.331     2.788     0.200
    44.051     0.181     0.200
    44.228     1.762     0.200
    44.304     1.455     0.200
    44.827    -2.969     0.200
    45.334     0.047     0.200
    45.997     2.358     0.200
    46.371     2.559     0.200
    47.310     3.120     0.200
    47.755     2.554     0.200
    48.474     1.200     0.200
    48.877     2.719     0.200
    49.040     2.354     0.200
    49.119     2.149     0.200
    49.401    -0.012     0.200
    49.654     0.063     0.200
    49.775    -0.259     0.200
    50.035     0.725     0.200
    50.761     3.972     0.200
    50.860     3.446     0.200
    51.021     1.816     0.200
    52.162     1.280     0.200
    52.367     1.363     0.200
    52.472     4.980     0.200
    52.787    -0.523     0.200
    53.097     1.765     0.200
    53.583     2.988     0.200
    53.794     2.449     0.200
    53.801     1.693     0.200
    53.805     1.662     0.200
    53.949     0.710     0.200
    54.187     1.171     0.200
    54.261     1.831     0.200
    54.321     2.292     0.200
    54.595     2.940     0.200
    54.751     3.203     0.200
    54.912     2.963     0.200
    54.981     1.110     0.200
    54.981     1.480     0.200
    55.124     2.414     0.200
    55.237     2.740     0.200
    55.252     0.449     0.200
    55.339     1.720     0.200
    55.351     1.335     0.200
    55.560     1.649     0.200
    55.617     1.319     0.200
    55.617     2.119     0.200
    55.636     2.303     0.200
    55.654     1.856     0.200
    55.699     2.793     0.200
    55.931     1.166     0.200
    55.937     1.329     0.200
    55.982     0.405     0.200
    56.070     2.673     0.200
    56.254     2.261     0.200
    56.360     1.303     0.200
    56.638     1.815     0.200
    56.637     2.632     0.200
    57.035     0.411     0.200
    57.041     2.185     0.200
    57.053     1.484     0.200
    57.135     2.251     0.200
    57.421     1.579     0.200
    57.591     1.385     0.200
    57.702     1.701     0.200
    57.885     1.257     0.200
    57.890     1.183     0.200
    57.954     1.532     0.200
    57.954     1.532     0.200
    58.047     2.079     0.200
    58.065     1.653     0.200
    58.106     0.365     0.200
    58.086     0.703     0.200
    58.086     1.143     0.200
    58.124     1.443     0.200
    58.470    -3.957     0.200
    58.620     0.776     0.200
    58.699     1.603     0.200
    58.799     1.393     0.200
    58.818     2.401     0.200
    58.915     2.227     0.200
    58.994     2.475     0.200
    59.044     2.028     0.200
    59.116     1.927     0.200
    59.130     1.933     0.200
    59.178     0.995     0.200
    59.258     2.246     0.200
    59.304     0.477     0.200
    59.417     1.169     0.200
    59.469     1.270     0.200
    59.498     0.792     0.200
    59.521     0.786     0.200
    59.572     2.277     0.200
    59.622     2.636     0.200
    59.660     1.672     0.200
    59.692     1.753     0.200
    59.699     1.032     0.200
    59.700     0.758     0.200
    59.715     2.094     0.200
    59.850     1.366     0.200
    59.904     1.490     0.200
    59.978     2.281     0.200
    60.132    -0.471     0.200
    60.187     2.548     0.200
    60.197     1.081     0.200
    60.398    -0.395     0.200
    60.402     1.781     0.200
    60.525     2.440     0.200
    60.550     0.067     0.200
    61.079     2.267     0.200
    61.090     2.196     0.200
    61.199    -0.242     0.200
    61.207    -0.500     0.200
    61.211     2.473     0.200
    61.245    -0.256     0.200
    61.346     0.058     0.200
    61.358     2.181     0.200
    61.462     2.576     0.200
    61.806     2.358     0.200
    61.924     2.661     0.200
    62.023     2.598     0.200
    62.023     1.728     0.200
    62.483    -0.984     0.200
    62.512     0.717     0.200
    62.565     1.346     0.200
    62.603     1.685     0.200
    62.669     1.902     0.200
    62.696     1.342     0.200
    62.706     0.915     0.200
    62.734     1.169     0.200
    62.737     1.446     0.200
    62.811     0.659     0.200
    62.829     1.408     0.200
    62.849     0.705     0.200
    63.000     1.269     0.200
    63.117     0.791     0.200
    63.125     0.941     0.200
    63.164     0.776     0.200
    63.195    -0.926     0.200
    63.200     0.340     0.200
    63.207    -1.104     0.200
    63.285    -0.425     0.200
    63.339    -0.480     0.200
    63.379     0.852     0.200
    63.408    -0.537     0.200
    63.451    -0.651     0.200
    63.518     0.533     0.200
    63.575    -0.342     0.200
    63.580     0.926     0.200
    63.639    -0.762     0.200
    63.645    -0.905     0.200
    63.747     0.026     0.200
    63.785    -0.928     0.200
    63.796    -0.400     0.200
    63.824     0.494     0.200
    63.870     0.185     0.200
    63.889    -0.709     0.200
    63.912    -0.264     0.200
    63.950     0.096     0.200
    63.953     0.370     0.200
    64.080    -0.470     0.200
    64.180     0.078     0.200
    64.265    -0.281     0.200
    64.364    -0.532     0.200
    64.490     0.248     0.200
    64.546    -0.419     0.200
    64.594     0.266     0.200
    64.852     0.179     0.200
    64.866    -0.408     0.200
    64.890    -0.464     0.200
    65.354    -0.277     0.200
    65.459     0.339     0.200
    65.463    -0.283     0.200
    65.869     1.408     0.200
    66.729     0.684     0.200
    67.211     5.228     0.200
    67.726    -0.040     0.200
    68.095     6.417     0.200
    68.186     0.070     0.200
    68.166     2.094     0.200
    68.273     4.691     0.200
    68.310     1.547     0.200
    68.859     5.579     0.200
    68.779     1.842     0.200
    68.938     1.512     0.200
    69.571     5.310     0.200
    69.538     0.792     0.200
    70.238     4.511     0.200
    70.144     1.824     0.200
    70.316     6.011     0.200
    70.267     1.173     0.200
    70.427     2.139     0.200
    70.893     5.091     0.200
    71.428     1.413     0.200
    71.493     4.802     0.200
    71.639     4.908     0.200
    71.841     3.825     0.200
    71.933     2.243     0.200
    72.039     1.918     0.200
    72.100     2.061     0.200
    72.100     2.371     0.200
    72.122     2.121     0.200
    72.241     0.929     0.200
    72.262     0.599     0.200
    72.187     2.490     0.200
    72.787     5.557     0.200
    73.038     1.887     0.200
    73.192     0.644     0.200
    73.508     5.943     0.200
    73.544     6.758     0.200
    73.594     2.389     0.200
    73.809     5.612     0.200
    74.085     2.531     0.200
    74.207     4.706     0.200
    74.535     2.279     0.200
    74.770    -0.255     0.200
    74.757     2.423     0.200
    74.951     5.637     0.200
    74.907     2.291     0.200
    75.164     1.870     0.200
    75.113     2.382     0.200
    75.435     4.654     0.200
    75.776     2.006     0.200
    76.164     2.488     0.200
    76.168     2.423     0.200
    76.379     1.626     0.200
    77.111     2.294     0.200
    77.339     2.392     0.200
    77.511     0.630     0.200
    77.521     0.295     0.200
    77.521     0.675     0.200
    77.711     2.242     0.200
    77.784     2.659     0.200
    77.833     2.252     0.200
    77.889     2.542     0.200
    78.195     2.217     0.200
    79.035     1.588     0.200
    79.187     1.406     0.200
    80.065     1.814     0.200
    80.065     0.914     0.200
    80.236     0.721     0.200
    80.825     0.767     0.200
    81.308     1.754     0.200
    81.834     2.794     0.200
    81.879     0.619     0.200
    81.984     2.478     0.200
    82.166     0.402     0.200
    82.325     0.799     0.200
    82.473     0.426     0.200
    82.831     1.982     0.200
    83.282     1.427     0.200
    83.788     2.129     0.200
    83.894     1.496     0.200
    84.507     1.371     0.200
    84.644     1.609     0.200
    84.797     1.075     0.200
    85.005     1.251     0.200
    85.031     0.430     0.200
    85.153     0.699     0.200
    85.216     0.602     0.200
    85.306     0.653     0.200
    86.275     0.848     0.200
    86.301     0.550     0.200
    87.500     1.875     0.200
    87.887     0.424     0.200
    88.193     0.750     0.200
    88.471     1.258     0.200
    24.581     3.383     0.200
    26.772    -0.485     0.200
    40.684     2.455     0.200
    42.983     1.051     0.200
    43.753    -0.545     0.200
    44.905     0.838     0.200
    49.371    -0.286     0.200
    54.407    -0.242     0.200
    55.044    -0.557     0.200
    26.773     0.379     0.200
    27.183     2.873     0.200
    43.754    -0.612     0.200
    49.194    -0.449     0.200
    49.372    -1.240     0.200
    49.406    -1.601     0.200
    55.045    -0.964     0.200
    24.167    -0.062     0.200
    24.304     3.063     0.200
    31.230     1.245     0.200
    42.748     0.012     0.200
    23.829     1.826     0.200
    23.868     2.582     0.200
    24.047     4.149     0.200
    25.094     3.706     0.200
    43.379     2.725     0.200
    76.994     0.983     0.200
    24.319     2.381     0.200
    24.319     3.107     0.200
    42.737     1.869     0.200
    44.052     1.608     0.200
    21.335     2.970     0.200
    23.975     0.364     0.200
    24.126    -0.115     0.200
    24.182     1.497     0.200
    27.325     1.204     0.200
    27.366     0.022     0.200
    28.100    -0.398     0.200
    31.103     1.846     0.200
    33.232     1.158     0.200
    35.245    -0.524     0.200
    35.245    -0.524     0.200
    40.812    -0.550     0.200
    43.177    -1.272     0.200
    43.670    -0.826     0.200
    43.670     0.252     0.200
    44.512     2.873     0.200
    47.408     1.159     0.200
    49.282     1.581     0.200
    49.376    -0.473     0.200
    57.544     1.239     0.200
    72.821     0.938     0.200
    73.223     2.083     0.200
    73.675     2.144     0.200
    92.874     0.430     0.200
    16.034     7.492     0.200
    23.443     0.278     0.200
    23.880     2.713     0.200
    23.968     0.713     0.200
    23.957     3.159     0.200
    24.240     1.325     0.200
    24.699     1.945     0.200
    25.281     3.745     0.200
    26.948     1.466     0.200
    27.352     1.682     0.200
    28.134     1.831     0.200
    30.887     2.126     0.200
    38.327     1.116     0.200
    43.395     1.422     0.200
    44.063     0.863     0.200
    47.498     4.292     0.200
    49.636     0.379     0.200
    55.253     2.759     0.200
    57.884     1.493     0.200
    70.241     1.198     0.200
    73.336     3.590     0.200
    73.438     1.429     0.200
    73.438     1.387     0.200
    73.852     1.354     0.200
    74.246     2.774     0.200
    77.165     0.453     0.200
    77.578     2.061     0.200
    77.951     2.470     0.200
    81.549     2.021     0.200
    83.089     2.267     0.200
    83.591     1.579     0.200
    23.873    -1.781     0.200
    23.953     2.266     0.200
    24.252     2.157     0.200
    27.343     2.819     0.200
    28.125    -0.745     0.200
    41.238    -1.929     0.200
    43.383     2.060     0.200
    44.050     0.736     0.200
    49.625     1.190     0.200
    57.871     1.401     0.200
    73.432     0.175     0.200
    77.178    -0.166     0.200
    80.774    -0.149     0.200
    44.057     2.171     0.200
    49.633     1.739     0.200
    73.428     1.842     0.200
    77.174     0.535     0.200
    24.570     2.220     0.200
    24.776     0.824     0.200
    78.043    -0.109     0.200
    20.137     0.630     0.200
    21.154     2.720     0.200
    24.126     2.919     0.200
    24.308    -0.500     0.200
    24.221     2.045     0.200
    24.258     2.160     0.200
    30.391     4.410     0.200
    31.184     2.206     0.200
    35.478     1.374     0.200
    35.478     1.374     0.200
    47.654     2.908     0.200
    54.288     0.137     0.200
    73.051     1.027     0.200
    80.977     0.228     0.200
    16.083     6.479     0.200
    24.092     2.171     0.200
    24.092     2.992     0.200
    24.163     3.770     0.200
    24.187     2.125     0.200
    27.561     2.437     0.200
    27.604     2.056     0.200
    32.826     3.395     0.200
    54.587     0.506     0.200
    77.089     0.039     0.200
    17.288     0.614     0.200
    24.716     2.550     0.200
    24.813     1.702     0.200
    44.175    -0.082     0.200
    49.725     1.312     0.200
    53.662     1.215     0.200
    81.208     0.687     0.200
    23.568     1.287     0.200
    27.091     0.698     0.200
    19.164     0.134     0.200
    19.164     0.224     0.200
    19.751    -0.298     0.200
    20.651    -0.692     0.200
    21.402    -1.007     0.200
    22.852     3.778     0.200
    22.854     3.750     0.200
    23.960     0.766     0.200
    23.960     1.915     0.200
    23.991     1.772     0.200
    23.991     1.475     0.200
    23.991     1.475     0.200
    23.991     1.772     0.200
    24.000     1.316     0.200
    24.054     1.430     0.200
    24.157     2.557     0.200
    24.823    -0.606     0.200
    27.469     1.447     0.200
    27.512     0.869     0.200
    30.923    -0.623     0.200
    35.044     1.210     0.200
    38.149     0.812     0.200
    43.322     1.116     0.200
    43.576    -2.478     0.200
    44.271     0.529     0.200
    44.271     0.486     0.200
    45.716    -0.971     0.200
    47.633     0.006     0.200
    48.095    -2.172     0.200
    49.816     0.431     0.200
    54.837     0.143     0.200
    55.395     1.568     0.200
    55.395     1.566     0.200
    73.587     1.249     0.200
    76.930     0.511     0.200
    76.930     0.511     0.200
    80.527     0.404     0.200
    18.435    -3.170     0.200
    19.037     0.755     0.200
    21.129     2.738     0.200
    23.876     1.083     0.200
    27.303    -0.394     0.200
    42.799     1.091     0.200
    43.728    -0.724     0.200
    43.728    -0.419     0.200
    49.388    -1.044     0.200
    23.800     1.197     0.200
    23.830     1.537     0.200
    43.331     1.475     0.200
    23.551     1.874     0.200
    17.645     0.151     0.200
    17.645     0.600     0.200
    22.383     0.515     0.200
    23.888    -0.657     0.200
    24.252     1.523     0.200
    24.349     0.666     0.200
    24.468     0.903     0.200
    24.468     1.153     0.200
    37.362    -0.706     0.200
    38.774    -0.274     0.200
    38.774    -0.172     0.200
    42.365     0.070     0.200
    43.819    -0.503     0.200
    44.246     2.167     0.200
    47.653    -1.303     0.200
    49.213    -0.669     0.200
    49.404    -0.876     0.200
    49.404    -0.579     0.200
    49.575    -0.720     0.200
    53.832    -0.552     0.200
    55.373     0.796     0.200
    72.323     0.298     0.200
    72.609     0.167     0.200
    73.438     1.613     0.200
    77.760    -0.047     0.200
    77.760    -0.447     0.200
    80.722     0.072     0.200
    81.366     0.421     0.200
    15.627     8.667     0.200
    17.950     1.083     0.200
    19.035     0.637     0.200
    19.620     0.936     0.200
    22.745    -0.297     0.200
    22.745     1.253     0.200
    22.745     0.003     0.200
    23.888     1.757     0.200
    23.985     0.912     0.200
    24.108     1.807     0.200
    24.108     1.647     0.200
    24.108     2.322     0.200
    24.108     2.127     0.200
    24.237     1.571     0.200
    27.229     0.628     0.200
    32.879     0.856     0.200
    34.801     0.545     0.200
    38.495     3.691     0.200
    39.222     0.785     0.200
    41.791     2.225     0.200
    42.792     0.262     0.200
    43.435     1.048     0.200
    43.567     0.444     0.200
    43.568     0.723     0.200
    43.568     0.068     0.200
    43.568     0.223     0.200
    44.264    -0.576     0.200
    46.148     2.146     0.200
    46.698    -1.250     0.200
    47.309     2.313     0.200
    48.961     1.877     0.200
    48.996     2.155     0.200
    49.149     1.458     0.200
    49.162     2.634     0.200
    49.182    -0.200     0.200
    49.272     0.110     0.200
    49.336     2.708     0.200
    54.001     1.202     0.200
    60.521     2.004     0.200
    62.553     0.897     0.200
    73.689     1.919     0.200
    77.853     0.463     0.200
    14.874     5.115     0.200
    15.840     7.482     0.200
    16.120     6.847     0.200
    17.677     1.641     0.200
    18.543    -0.663     0.200
    18.844     2.535     0.200
    19.408     2.641     0.200
    19.820     2.190     0.200
    19.820     2.772     0.200
    19.907     2.594     0.200
    20.590     1.557     0.200
    20.730     2.737     0.200
    21.502     2.905     0.200
    21.888     4.764     0.200
    22.067     0.370     0.200
    22.214     3.480     0.200
    22.965     0.702     0.200
    22.965     0.382     0.200
    22.965     1.092     0.200
    22.833     5.495     0.200
    22.938     1.091     0.200
    23.527     1.275     0.200
    23.510     1.749     0.200
    23.870    -0.089     0.200
    23.838     1.307     0.200
    23.838     2.147     0.200
    23.878     1.677     0.200
    23.878     2.279     0.200
    23.878     0.826     0.200
    23.878     1.826     0.200
    23.933     1.290     0.200
    24.044     2.203     0.200
    24.055     4.966     0.200
    24.874     0.656     0.200
    24.874     0.199     0.200
    24.658     0.261     0.200
    25.101     0.632     0.200
    25.362     4.257     0.200
    25.681     5.163     0.200
    26.515     2.580     0.200
    27.122     0.371     0.200
    27.110     4.349     0.200
    27.344     0.822     0.200
    27.387     2.232     0.200
    27.387     1.560     0.200
    27.515    -0.007     0.200
    27.722    -1.269     0.200
    27.947     2.057     0.200
    27.970    -0.451     0.200
    28.970    -0.004     0.200
    29.049     1.408     0.200
    30.011     4.058     0.200
    30.105     3.773     0.200
    30.204     0.766     0.200
    30.396     3.837     0.200
    30.545     4.202     0.200
    30.810     3.876     0.200
    30.810     4.118     0.200
    30.810     3.548     0.200
    30.905     1.500     0.200
    31.193     3.708     0.200
    31.829     4.563     0.200
    32.115     0.911     0.200
    32.728     2.561     0.200
    32.728     2.745     0.200
    32.728     2.343     0.200
    33.621     0.668     0.200
    33.747     0.460     0.200
    34.140     4.864     0.200
    34.919     2.124     0.200
    34.919     2.264     0.200
    35.197     1.016     0.200
    35.636     1.448     0.200
    36.157     0.999     0.200
    36.018     3.868     0.200
    36.578     1.082     0.200
    36.578     1.750     0.200
    36.330     4.693     0.200
    36.409     4.022     0.200
    36.489     3.052     0.200
    36.996     0.342     0.200
    36.996     1.221     0.200
    36.845     1.502     0.200
    36.917     4.990     0.200
    37.793     0.560     0.200
    39.011    -1.393     0.200
    39.766     1.469     0.200
    39.773     1.591     0.200
    39.540     3.048     0.200
    39.845     1.765     0.200
    39.887     1.206     0.200
    39.932     0.594     0.200
    40.074     1.436     0.200
    40.085     1.572     0.200
    40.112     1.269     0.200
    40.292     0.707     0.200
    40.356     0.908     0.200
    40.356     1.287     0.200
    40.415    -2.758     0.200
    40.243     1.589     0.200
    40.243     3.542     0.200
    40.595     1.085     0.200
    40.639     1.518     0.200
    40.720     1.189     0.200
    40.794     1.329     0.200
    40.794     1.212     0.200
    40.877     0.428     0.200
    40.877     1.053     0.200
    40.993     1.378     0.200
    40.994     1.395     0.200
    41.077     1.682     0.200
    41.110     2.222     0.200
    41.174     1.133     0.200
    41.207     1.178     0.200
    41.213     1.784     0.200
    41.338     1.081     0.200
    41.338     0.796     0.200
    41.377     1.240     0.200
    41.483     1.613     0.200
    41.542     1.298     0.200
    41.542     1.579     0.200
    41.620     1.354     0.200
    41.848     1.737     0.200
    41.848     1.339     0.200
    41.862     1.363     0.200
    41.876     1.520     0.200
    41.876     1.134     0.200
    41.892     1.552     0.200
    41.916     1.659     0.200
    41.978     1.444     0.200
    42.066     0.470     0.200
    42.093     0.560     0.200
    42.163     2.103     0.200
    42.211     1.432     0.200
    42.258     1.634     0.200
    42.275     1.185     0.200
    42.286     1.606     0.200
    42.286     1.173     0.200
    42.285     1.593     0.200
    42.299     1.492     0.200
    42.337     1.813     0.200
    42.413     1.285     0.200
    42.413     1.828     0.200
    42.419     1.245     0.200
    42.482     1.614     0.200
    42.510     0.706     0.200
    42.578     1.597     0.200
    42.594     1.296     0.200
    42.616     1.845     0.200
    42.701     1.387     0.200
    42.701     1.156     0.200
    42.718     1.572     0.200
    42.601    -0.029     0.200
    42.787     1.641     0.200
    42.909     1.764     0.200
    42.967     1.186     0.200
    42.967     1.436     0.200
    42.970     1.559     0.200
    42.970     1.309     0.200
    42.976     1.530     0.200
    43.039     1.955     0.200
    43.075     1.382     0.200
    43.109     1.600     0.200
    43.117     0.957     0.200
    43.208     1.943     0.200
    43.208     1.744     0.200
    43.242     1.253     0.200
    43.284     0.902     0.200
    43.297     1.430     0.200
    43.297     1.079     0.200
    43.358     0.551     0.200
    43.358     1.425     0.200
    43.366     1.162     0.200
    43.366     1.072     0.200
    43.366     1.373     0.200
    43.396     1.701     0.200
    43.171     2.726     0.200
    43.171     3.511     0.200
    43.171     4.652     0.200
    43.171     4.625     0.200
    43.520     0.705     0.200
    43.557     0.643     0.200
    43.456     1.251     0.200
    43.679     1.004     0.200
    43.732     0.586     0.200
    43.826     0.889     0.200
    43.832     0.730     0.200
    43.885     1.377     0.200
    43.891     1.085     0.200
    43.913     0.371     0.200
    43.964     1.329     0.200
    43.971     1.048     0.200
    43.986     0.429     0.200
    44.143     0.322     0.200
    44.231     0.571     0.200
    44.280     0.981     0.200
    44.162     0.096     0.200
    44.162    -0.228     0.200
    44.162    -0.029     0.200
    44.317     0.826     0.200
    44.332    -0.547     0.200
    44.406     1.037     0.200
    44.435     0.784     0.200
    44.505     0.692     0.200
    44.608     1.076     0.200
    44.614    -0.566     0.200
    44.640    -0.001     0.200
    44.675     0.019     0.200
    44.701    -0.565     0.200
    44.802    -0.217     0.200
    44.846    -0.318     0.200
    44.854    -0.708     0.200
    44.868     0.986     0.200
    44.868     0.126     0.200
    44.978    -0.171     0.200
    44.944     0.267     0.200
    44.952     0.143     0.200
    44.971    -0.324     0.200
    45.188    -1.178     0.200
    45.231     0.254     0.200
    45.311     1.122     0.200
    45.311     0.490     0.200
    45.339     0.839     0.200
    45.339    -0.067     0.200
    45.373     0.380     0.200
    45.417     0.083     0.200
    45.421     0.301     0.200
    45.440     0.548     0.200
    45.478     1.227     0.200
    45.478     0.500     0.200
    45.675     0.713     0.200
    45.692     0.846     0.200
    45.710     1.430     0.200
    45.858     1.245     0.200
    45.861     0.760     0.200
    46.089     1.470     0.200
    46.128     1.620     0.200
    46.184     1.319     0.200
    46.184     1.780     0.200
    46.197     0.980     0.200
    46.199     0.618     0.200
    46.358     0.380     0.200
    46.374     1.346     0.200
    46.624     1.487     0.200
    46.624     1.097     0.200
    46.850     0.131     0.200
    46.864     0.712     0.200
    46.946    -0.091     0.200
    46.896     0.069     0.200
    47.053    -0.198     0.200
    47.124     1.251     0.200
    47.418     0.669     0.200
    47.512     1.781     0.200
    47.662     0.262     0.200
    47.508     4.500     0.200
    47.508     3.238     0.200
    47.756     1.660     0.200
    47.549     1.614     0.200
    47.549     1.817     0.200
    47.824     1.535     0.200
    47.671     2.771     0.200
    48.090     0.500     0.200
    47.986     3.628     0.200
    47.969     2.852     0.200
    48.231     1.747     0.200
    48.286     0.116     0.200
    48.444     0.974     0.200
    48.723     0.536     0.200
    48.821     1.084     0.200
    48.907     0.483     0.200
    48.740     4.080     0.200
    49.190     0.899     0.200
    49.206     0.985     0.200
    49.294     1.241     0.200
    49.336     2.223     0.200
    49.336     0.965     0.200
    49.331     0.476     0.200
    49.616     0.494     0.200
    49.616     0.944     0.200
    49.737     0.875     0.200
    49.695     0.797     0.200
    49.695     2.316     0.200
    49.695     1.695     0.200
    49.695     0.996     0.200
    49.893     0.497     0.200
    49.847     0.435     0.200
    50.486     0.167     0.200
    50.579     0.410     0.200
    50.944    -0.289     0.200
    51.264     0.923     0.200
    51.264     0.372     0.200
    51.414     0.683     0.200
    51.709    -0.063     0.200
    51.883     0.300     0.200
    52.100    -1.061     0.200
    52.381    -0.299     0.200
    52.671    -0.336     0.200
    52.675    -0.361     0.200
    52.706     0.346     0.200
    52.704     3.196     0.200
    53.544    -0.207     0.200
    53.565    -0.389     0.200
    53.754    -0.454     0.200
    53.722     2.010     0.200
    53.735     1.362     0.200
    54.083     0.154     0.200
    54.052     0.027     0.200
    54.152     0.235     0.200
    54.223     0.248     0.200
    54.241     0.130     0.200
    54.273    -0.156     0.200
    54.587     0.510     0.200
    54.713    -0.034     0.200
    54.856    -0.467     0.200
    55.270     1.741     0.200
    55.356     2.820     0.200
    55.506     4.142     0.200
    55.603     3.743     0.200
    55.648     3.724     0.200
    55.712     2.158     0.200
    55.722     1.988     0.200
    55.726     3.456     0.200
    55.800     3.331     0.200
    56.006     3.852     0.200
    56.247     5.028     0.200
    56.378     3.893     0.200
    56.510     4.954     0.200
    56.612     4.924     0.200
    56.649     4.261     0.200
    56.784     3.104     0.200
    56.923     0.370     0.200
    57.728     3.933     0.200
    57.799     2.031     0.200
    57.799     2.230     0.200
    57.799     1.531     0.200
    57.966     1.534     0.200
    57.966     0.780     0.200
    57.966     2.874     0.200
    59.062     2.854     0.200
    59.404     3.418     0.200
    59.485     2.983     0.200
    60.641     2.406     0.200
    61.094     3.025     0.200
    62.642    -0.211     0.200
    62.660     0.915     0.200
    64.809    -0.063     0.200
    65.451     1.511     0.200
    66.285     1.686     0.200
    66.285     0.635     0.200
    68.590     0.852     0.200
    68.590     1.172     0.200
    68.835     0.437     0.200
    69.065     2.307     0.200
    69.109     2.166     0.200
    69.370     0.867     0.200
    69.354    -1.026     0.200
    69.431     1.669     0.200
    69.963     1.556     0.200
    70.001     0.981     0.200
    70.001     1.110     0.200
    70.001     0.825     0.200
    70.324     1.781     0.200
    70.340    -0.716     0.200
    70.426     1.209     0.200
    70.648     2.175     0.200
    70.717     2.302     0.200
    70.808     2.028     0.200
    71.071     0.092     0.200
    71.174     1.097     0.200
    71.314     0.910     0.200
    71.590     1.539     0.200
    71.590     0.645     0.200
    71.746    -0.046     0.200
    71.835     1.263     0.200
    72.187    -0.570     0.200
    72.361     1.912     0.200
    72.527     2.662     0.200
    72.582    -0.387     0.200
    72.676     0.459     0.200
    73.006     2.406     0.200
    73.073     1.548     0.200
    73.423     0.089     0.200
    73.423    -0.376     0.200
    73.452     1.759     0.200
    73.515     2.322     0.200
    73.623     1.037     0.200
    73.623     0.541     0.200
    73.623     0.884     0.200
    73.623    -0.120     0.200
    73.623     0.537     0.200
    74.013     2.020     0.200
    74.041     0.533     0.200
    74.041     0.189     0.200
    74.420     1.821     0.200
    74.666     0.154     0.200
    74.666     0.384     0.200
    74.696    -0.639     0.200
    74.852     1.148     0.200
    74.914     0.099     0.200
    75.004    -0.010     0.200
    75.091     0.083     0.200
    75.506     1.338     0.200
    75.601     2.161     0.200
    75.651     0.714     0.200
    75.754    -0.213     0.200
    75.763    -0.135     0.200
    75.763     0.162     0.200
    76.033     1.011     0.200
    76.204     1.335     0.200
    76.247     1.631     0.200
    76.244     0.291     0.200
    76.329    -0.079     0.200
    76.329     0.081     0.200
    76.380     0.624     0.200
    76.424     0.754     0.200
    76.446     1.407     0.200
    76.558     0.769     0.200
    76.571     2.642     0.200
    76.689     1.430     0.200
    76.775     0.879     0.200
    76.810     1.056     0.200
    76.921     0.826     0.200
    76.995     2.203     0.200
    76.835     0.233     0.200
    77.104     0.907     0.200
    77.129     1.737     0.200
    76.992     0.190     0.200
    76.992     1.499     0.200
    77.243     1.182     0.200
    76.999    -0.117     0.200
    76.999     0.469     0.200
    77.001     0.317     0.200
    77.293     2.455     0.200
    77.412     0.865     0.200
    77.541     1.365     0.200
    77.539     0.523     0.200
    77.550     1.468     0.200
    77.550     1.651     0.200
    77.550     1.788     0.200
    77.594     1.424     0.200
    77.647     1.505     0.200
    77.688     2.430     0.200
    77.737     1.582     0.200
    77.833     1.945     0.200
    77.955     0.688     0.200
    78.040     1.403     0.200
    78.064     1.046     0.200
    78.143     0.205     0.200
    78.334     1.402     0.200
    78.343     1.703     0.200
    78.459     0.800     0.200
    78.469     1.095     0.200
    78.500     0.650     0.200
    78.609     2.019     0.200
    78.631     2.463     0.200
    78.843     0.383     0.200
    78.997     1.903     0.200
    79.015     2.045     0.200
    79.051     2.334     0.200
    79.086     1.953     0.200
    79.196     1.707     0.200
    79.362     1.717     0.200
    79.369     1.640     0.200
    79.382     2.265     0.200
    79.470     1.244     0.200
    79.546     1.924     0.200
    79.546     2.029     0.200
    79.629     1.819     0.200
    79.710     1.829     0.200
    80.013     1.979     0.200
    80.207    -0.637     0.200
    80.348     1.890     0.200
    80.365     0.631     0.200
    80.365     1.119     0.200
    80.375     1.375     0.200
    80.477     1.382     0.200
    80.490     0.700     0.200
    80.511     2.044     0.200
    80.594    -0.010     0.200
    80.936     1.590     0.200
    80.949     0.296     0.200
    81.138     0.952     0.200
    81.372    -0.445     0.200
    81.428    -0.773     0.200
    81.733     1.600     0.200
    81.733     0.928     0.200
    81.733     1.752     0.200
    82.014    -0.509     0.200
    82.222    -0.370     0.200
    82.392    -0.842     0.200
    82.646     0.317     0.200
    82.638    -0.965     0.200
    82.690    -0.255     0.200
    82.793     0.003     0.200
    82.842     0.019     0.200
    82.961     0.053     0.200
    83.026     1.539     0.200
    83.107    -0.472     0.200
    83.276    -0.057     0.200
    83.361     0.164     0.200
    83.496     0.972     0.200
    83.496     0.534     0.200
    83.730     0.508     0.200
    83.782    -0.065     0.200
    83.785     0.763     0.200
    83.934     0.219     0.200
    83.979     0.071     0.200
    84.040    -0.076     0.200
    84.245     1.263     0.200
    84.411     0.438     0.200
    84.841    -1.034     0.200
    84.887    -0.217     0.200
    85.066     1.036     0.200
    85.733    -1.521     0.200
    85.906    -1.277     0.200
    85.983    -1.009     0.200
    86.765    -1.476     0.200
    87.196    -0.894     0.200
    87.808     0.599     0.200
    93.134     0.389     0.200
    18.954    -3.825     0.200
    23.878    -0.512     0.200
    24.878    -1.814     0.200
    44.167    -1.820     0.200
    54.862    -1.011     0.200
    76.992    -0.193     0.200
    22.965     2.367     0.200
    23.838     4.256     0.200
    23.879     3.357     0.200
    23.933     3.392     0.200
    43.363     2.269     0.200
    44.159     2.392     0.200
    45.336     2.227     0.200
    54.853     0.490     0.200
    54.862    -0.455     0.200
    18.794    -2.627     0.200
    18.794    -2.475     0.200
    23.753     2.268     0.200
    23.820     1.553     0.200
    23.820     1.827     0.200
    23.848     1.424     0.200
    27.237     1.528     0.200
    43.310     2.243     0.200
    44.011    -0.953     0.200
    44.011     0.707     0.200
    49.472    -0.057     0.200
    49.557    -0.173     0.200
    49.557     1.077     0.200
    49.694     0.624     0.200
    57.820     2.695     0.200
    77.149    -0.378     0.200
    77.149     0.372     0.200
    18.986    -1.263     0.200
    20.082    -2.231     0.200
    25.025     1.195     0.200
    25.122     0.313     0.200
    28.356    -0.331     0.200
    37.707    -0.608     0.200
    41.212    -0.560     0.200
    41.949     0.451     0.200
    43.620     0.341     0.200
    44.419    -0.682     0.200
    45.358    -0.268     0.200
    46.311    -0.870     0.200
    53.558    -0.913     0.200
    74.796    -3.147     0.200
    18.740    -2.998     0.200
    24.145     2.608     0.200
    24.241     1.766     0.200
    24.278     1.731     0.200
    16.247     5.662     0.200
    16.835     2.799     0.200
    19.067     3.070     0.200
    19.192     1.945     0.200
    19.192     3.656     0.200
    19.385     1.906     0.200
    19.447     1.454     0.200
    20.015     2.498     0.200
    20.110     0.530     0.200
    20.110     0.069     0.200
    20.110     2.045     0.200
    20.392     0.367     0.200
    20.392     2.968     0.200
    20.619     0.361     0.200
    20.657    -0.740     0.200
    20.657     0.627     0.200
    21.377     1.957     0.200
    21.891    -0.690     0.200
    21.891    -0.049     0.200
    21.891     1.600     0.200
    22.453     0.714     0.200
    22.453     1.956     0.200
    22.453     2.519     0.200
    22.183     3.328     0.200
    22.996     0.457     0.200
    22.996     1.605     0.200
    23.001     3.253     0.200
    23.163     2.250     0.200
    23.167     1.553     0.200
    23.167     1.303     0.200
    23.169    -0.113     0.200
    23.169     1.231     0.200
    23.143     2.940     0.200
    23.361     4.359     0.200
    23.718     0.307     0.200
    23.718    -2.841     0.200
    24.131    -0.520     0.200
    24.131     0.839     0.200
    23.833     1.289     0.200
    24.129     1.970     0.200
    23.868     2.834     0.200
    24.085     1.055     0.200
    24.228     0.325     0.200
    24.228     1.450     0.200
    24.386     0.240     0.200
    24.386     2.357     0.200
    24.916     0.434     0.200
    24.916     1.777     0.200
    24.916     2.769     0.200
    24.957     3.315     0.200
    24.957     1.955     0.200
    24.957     2.487     0.200
    25.011     0.891     0.200
    25.042     2.132     0.200
    25.123     0.968     0.200
    25.879     2.237     0.200
    26.203     3.306     0.200
    26.884     0.953     0.200
    28.201     2.552     0.200
    28.387     0.755     0.200
    28.415     1.353     0.200
    28.378     2.287     0.200
    28.586     2.550     0.200
    28.791     0.869     0.200
    29.041     2.815     0.200
    29.439     2.687     0.200
    30.124     2.800     0.200
    30.657     1.932     0.200
    30.732     1.162     0.200
    31.164     6.114     0.200
    31.284     2.505     0.200
    31.589    -0.131     0.200
    31.700     1.644     0.200
    31.867     2.430     0.200
    31.889     2.526     0.200
    31.889     2.737     0.200
    33.181     0.592     0.200
    33.181     1.412     0.200
    33.344     1.512     0.200
    33.811     1.312     0.200
    33.811     0.773     0.200
    34.423    -0.717     0.200
    34.520     0.192     0.200
    34.520     0.364     0.200
    34.237     4.719     0.200
    34.703     2.517     0.200
    35.077    -0.172     0.200
    34.768     6.427     0.200
    35.219    -0.020     0.200
    35.372    -1.077     0.200
    35.401    -0.267     0.200
    35.455     0.089     0.200
    35.514     0.555     0.200
    35.792    -0.298     0.200
    35.848     0.449     0.200
    35.848    -0.395     0.200
    35.523     1.910     0.200
    36.152    -0.549     0.200
    36.189    -0.603     0.200
    35.962     1.243     0.200
    35.962     1.188     0.200
    36.232    -0.300     0.200
    36.232    -0.417     0.200
    36.393    -0.798     0.200
    36.502     0.176     0.200
    36.502    -0.847     0.200
    36.646     0.475     0.200
    36.646    -1.173     0.200
    36.646    -0.098     0.200
    36.646    -0.465     0.200
    36.698    -0.067     0.200
    36.698    -1.246     0.200
    36.524     0.957     0.200
    36.861    -0.190     0.200
    36.957     0.071     0.200
    36.957    -0.890     0.200
    37.001    -0.803     0.200
    37.007    -1.502     0.200
    36.682     2.256     0.200
    36.687     2.207     0.200
    36.739     1.879     0.200
    36.753     2.328     0.200
    37.170    -1.202     0.200
    37.181    -2.205     0.200
    37.211    -1.358     0.200
    37.252    -1.288     0.200
    37.281    -0.762     0.200
    37.377    -1.371     0.200
    37.446    -0.606     0.200
    37.478    -0.989     0.200
    37.663    -0.226     0.200
    37.663    -0.601     0.200
    37.744    -0.613     0.200
    37.753     0.269     0.200
    37.753    -1.114     0.200
    37.775    -0.006     0.200
    37.775    -0.162     0.200
    37.800    -1.279     0.200
    37.833    -1.554     0.200
    37.567     2.112     0.200
    37.567     3.698     0.200
    37.934    -2.298     0.200
    37.650     2.126     0.200
    37.813     2.608     0.200
    38.245    -2.179     0.200
    38.269     0.659     0.200
    38.269    -0.661     0.200
    38.290    -0.543     0.200
    38.325     0.192     0.200
    38.372    -0.403     0.200
    38.387    -1.210     0.200
    38.447    -0.178     0.200
    38.401     1.947     0.200
    38.401     0.064     0.200
    38.401     0.548     0.200
    38.603    -0.097     0.200
    38.635     0.199     0.200
    38.802    -0.085     0.200
    38.814    -0.137     0.200
    38.830     0.213     0.200
    38.883     0.001     0.200
    39.018    -0.119     0.200
    38.911    -1.626     0.200
    39.089     0.357     0.200
    39.044     2.474     0.200
    39.209    -0.776     0.200
    39.229    -0.214     0.200
    38.978     1.081     0.200
    39.401     0.234     0.200
    39.408     0.276     0.200
    39.414     0.144     0.200
    39.413    -0.319     0.200
    39.440    -0.304     0.200
    39.454     0.418     0.200
    39.457     0.057     0.200
    39.474     0.397     0.200
    39.583     0.144     0.200
    39.700    -0.995     0.200
    39.708    -0.665     0.200
    39.718     0.513     0.200
    39.718    -0.128     0.200
    39.730    -1.501     0.200
    39.743    -0.350     0.200
    39.861    -0.793     0.200
    39.896    -0.489     0.200
    39.914     0.006     0.200
    39.941    -0.402     0.200
    39.977    -0.235     0.200
    39.989    -1.110     0.200
    39.814    -0.371     0.200
    40.019     0.057     0.200
    40.082    -0.079     0.200
    40.207     0.524     0.200
    40.207     0.313     0.200
    40.331     0.935     0.200
    40.338     0.231     0.200
    40.349     0.630     0.200
    40.383     0.388     0.200
    40.382     0.833     0.200
    40.420     1.769     0.200
    40.456     1.014     0.200
    40.473     0.886     0.200
    40.519     0.920     0.200
    40.528     0.099     0.200
    40.464     1.444     0.200
    40.612    -0.333     0.200
    40.621     0.133     0.200
    40.499     2.203     0.200
    40.499    -0.024     0.200
    40.782     0.944     0.200
    40.830     0.952     0.200
    40.623     1.927     0.200
    40.470     2.891     0.200
    40.607     1.893     0.200
    41.020     0.042     0.200
    41.028     1.016     0.200
    41.069     0.337     0.200
    41.092     0.200     0.200
    41.137    -0.040     0.200
    41.148    -0.107     0.200
    41.148     0.440     0.200
    41.155     0.982     0.200
    41.174     0.587     0.200
    40.807     2.080     0.200
    40.807     2.338     0.200
    40.807     1.815     0.200
    41.262     0.600     0.200
    41.319    -1.239     0.200
    41.399    -0.035     0.200
    41.425     1.188     0.200
    41.466    -1.153     0.200
    41.478     0.564     0.200
    41.488     0.629     0.200
    41.505     0.325     0.200
    41.522     0.598     0.200
    41.555     0.791     0.200
    41.555     0.565     0.200
    41.581     0.875     0.200
    41.462     1.963     0.200
    41.728     0.739     0.200
    41.752    -0.053     0.200
    41.752     0.267     0.200
    41.823     0.387     0.200
    41.875     0.723     0.200
    41.938     0.731     0.200
    41.946     0.258     0.200
    41.955     1.511     0.200
    41.983     0.004     0.200
    41.987     0.329     0.200
    42.051     0.116     0.200
    42.064     1.146     0.200
    42.075     0.820     0.200
    41.997     1.170     0.200
    42.169     0.897     0.200
    42.194     0.277     0.200
    42.217    -0.193     0.200
    42.268     0.930     0.200
    42.268     0.734     0.200
    42.268     0.500     0.200
    42.268     1.594     0.200
    42.280     1.067     0.200
    42.334     1.370     0.200
    42.395     0.332     0.200
    42.408     0.238     0.200
    42.411     0.442     0.200
    42.447    -0.020     0.200
    42.465     0.779     0.200
    42.468    -1.065     0.200
    42.481     0.695     0.200
    42.379     1.195     0.200
    42.490    -0.442     0.200
    42.382     1.212     0.200
    42.515     0.271     0.200
    42.515     0.873     0.200
    42.514    -0.060     0.200
    42.650    -0.230     0.200
    42.667     0.243     0.200
    42.667     0.493     0.200
    42.667     1.236     0.200
    42.686     0.401     0.200
    42.687     0.726     0.200
    42.718     1.039     0.200
    42.763     0.161     0.200
    42.830    -0.266     0.200
    42.843    -0.660     0.200
    42.852     0.394     0.200
    42.852     0.199     0.200
    42.843    -0.074     0.200
    42.790     4.091     0.200
    42.987     0.373     0.200
    42.989    -0.138     0.200
    43.117     0.553     0.200
    43.117     0.154     0.200
    43.156    -0.213     0.200
    43.158    -0.666     0.200
    43.173    -0.318     0.200
    43.164    -1.658     0.200
    43.194    -1.162     0.200
    43.249     2.247     0.200
    43.293     0.843     0.200
    43.330     1.915     0.200
    43.356     1.167     0.200
    43.403     0.458     0.200
    43.457     1.517     0.200
    43.468     0.411     0.200
    43.468     1.052     0.200
    43.623     0.761     0.200
    43.622     0.752     0.200
    43.635     2.104     0.200
    43.647     1.358     0.200
    43.646     0.829     0.200
    43.473     0.158     0.200
    43.672     0.583     0.200
    43.731     0.944     0.200
    43.808     0.402     0.200
    43.852     0.343     0.200
    43.852     1.218     0.200
    43.860     0.501     0.200
    43.984     2.456     0.200
    43.989     1.261     0.200
    43.996    -0.206     0.200
    43.996     0.278     0.200
    44.040     1.111     0.200
    44.094     0.780     0.200
    44.096     0.386     0.200
    44.118     0.449     0.200
    44.177    -0.540     0.200
    44.157    -0.276     0.200
    44.157     0.490     0.200
    44.221     0.593     0.200
    44.221     0.890     0.200
    44.231     0.717     0.200
    44.330     2.332     0.200
    44.390     0.883     0.200
    44.412     0.565     0.200
    44.418     0.596     0.200
    44.432     0.374     0.200
    44.492     1.310     0.200
    44.275     0.520     0.200
    44.331     0.570     0.200
    44.331     0.375     0.200
    44.535     0.801     0.200
    44.566     1.611     0.200
    44.572    -0.427     0.200
    44.572     0.713     0.200
    44.484     1.250     0.200
    44.633     2.012     0.200
    44.643     1.353     0.200
    44.655     1.967     0.200
    44.688     1.117     0.200
    44.774     0.051     0.200
    44.774     1.535     0.200
    44.793     1.355     0.200
    44.496     1.626     0.200
    44.837     1.288     0.200
    44.799     0.133     0.200
    44.889     0.564     0.200
    44.821     0.566     0.200
    44.963     1.312     0.200
    44.767     0.388     0.200
    44.882     0.211     0.200
    44.884     0.060     0.200
    44.884     0.583     0.200
    44.884     0.857     0.200
    44.893     0.333     0.200
    45.076     1.294     0.200
    45.219     1.426     0.200
    45.277     1.163     0.200
    45.311     1.022     0.200
    45.391     1.736     0.200
    45.417    -0.069     0.200
    45.462     1.166     0.200
    45.483     1.272     0.200
    45.485     1.635     0.200
    45.498     0.895     0.200
    45.614     0.471     0.200
    45.614     1.651     0.200
    45.689    -0.408     0.200
    45.689     0.233     0.200
    45.520     0.608     0.200
    45.789     0.902     0.200
    45.789     1.886     0.200
    45.833     1.873     0.200
    45.617     1.138     0.200
    45.914     2.266     0.200
    45.929     1.200     0.200
    45.812     0.244     0.200
    45.848     1.128     0.200
    45.867    -0.975     0.200
    46.058     0.409     0.200
    46.118    -0.256     0.200
    46.118     1.392     0.200
    46.181     0.629     0.200
    46.189     2.607     0.200
    46.173    -0.684     0.200
    46.173     1.581     0.200
    46.370     1.551     0.200
    46.309     1.352     0.200
    46.463     2.030     0.200
    46.498     1.989     0.200
    46.524     1.429     0.200
    46.560    -0.287     0.200
    46.567    -0.930     0.200
    46.493     0.486     0.200
    46.493     0.682     0.200
    46.742     2.091     0.200
    46.832     0.900     0.200
    46.834     2.078     0.200
    47.012     2.256     0.200
    47.068     2.509     0.200
    47.169     2.189     0.200
    47.302     2.066     0.200
    47.377     2.141     0.200
    47.555     1.919     0.200
    47.563     2.154     0.200
    47.739     2.253     0.200
    47.746     0.966     0.200
    47.991     2.074     0.200
    48.112     2.027     0.200
    48.213     2.698     0.200
    47.999     0.400     0.200
    48.471     2.630     0.200
    48.500     0.756     0.200
    48.500     2.373     0.200
    48.600     2.164     0.200
    48.628     1.759     0.200
    48.364     0.887     0.200
    48.651     2.545     0.200
    48.470     2.166     0.200
    48.521     1.939     0.200
    48.521     1.673     0.200
    48.521     3.228     0.200
    48.621     2.198     0.200
    48.638     0.541     0.200
    48.565     1.436     0.200
    48.685     2.104     0.200
    48.805     1.756     0.200
    49.040     2.459     0.200
    48.867     0.711     0.200
    48.889     1.044     0.200
    49.182     1.923     0.200
    49.075     0.663     0.200
    49.240     2.157     0.200
    49.078    -0.907     0.200
    49.365     0.821     0.200
    49.365     2.173     0.200
    49.279     0.407     0.200
    49.543     1.709     0.200
    49.587     1.044     0.200
    49.587     0.653     0.200
    49.587     3.645     0.200
    49.814     0.786     0.200
    49.863     1.063     0.200
    49.641     2.305     0.200
    50.235     2.145     0.200
    50.069     0.696     0.200
    50.073     1.828     0.200
    50.073     1.984     0.200
    50.073     2.812     0.200
    50.287     0.321     0.200
    50.294     0.013     0.200
    50.333    -0.966     0.200
    50.449     1.356     0.200
    50.581     1.862     0.200
    50.480     0.330     0.200
    50.480     0.251     0.200
    50.356     0.858     0.200
    50.536     1.278     0.200
    50.717     2.257     0.200
    50.592     0.319     0.200
    50.711     0.308     0.200
    50.578     0.710     0.200
    50.578     1.187     0.200
    50.578     1.687     0.200
    50.590     0.197     0.200
    50.590     2.057     0.200
    50.664    -1.161     0.200
    50.974     2.571     0.200
    51.126     2.483     0.200
    51.000     0.881     0.200
    50.950     0.630     0.200
    50.950     0.982     0.200
    50.819     2.601     0.200
    50.819     4.132     0.200
    51.305     1.032     0.200
    51.381     1.839     0.200
    51.686     1.806     0.200
    51.819     2.280     0.200
    51.708     1.467     0.200
    51.967     1.874     0.200
    52.015     0.601     0.200
    52.015     1.202     0.200
    51.966     0.759     0.200
    51.966     7.025     0.200
    52.020     1.499     0.200
    52.447     0.983     0.200
    52.860     2.246     0.200
    52.866     1.931     0.200
    52.682     1.188     0.200
    52.837     1.373     0.200
    53.029     2.514     0.200
    52.977     2.094     0.200
    53.439     1.551     0.200
    53.488     2.102     0.200
    53.532     1.648     0.200
    53.434     6.999     0.200
    53.434    -2.883     0.200
    53.434     7.117     0.200
    53.884     2.385     0.200
    53.971     2.775     0.200
    54.156     1.786     0.200
    54.337    -0.811     0.200
    54.337    -1.404     0.200
    54.337     0.416     0.200
    54.267     1.430     0.200
    54.260     1.533     0.200
    54.643     1.893     0.200
    54.609     0.813     0.200
    54.622     1.098     0.200
    54.622     1.824     0.200
    54.794    -0.586     0.200
    54.987     4.988     0.200
    54.852     1.034     0.200
    55.019     2.893     0.200
    55.132     0.432     0.200
    55.191     4.606     0.200
    55.239     6.102     0.200
    55.390     2.919     0.200
    55.410     5.413     0.200
    55.433     6.518     0.200
    55.468     3.734     0.200
    55.469     3.980     0.200
    55.501     1.191     0.200
    55.720     3.490     0.200
    55.938     0.071     0.200
    55.751     4.970     0.200
    55.839     0.890     0.200
    55.839     4.046     0.200
    55.928     4.204     0.200
    56.283     2.485     0.200
    56.292     6.637     0.200
    56.267     1.605     0.200
    56.267     1.252     0.200
    56.267    -0.217     0.200
    56.267     1.603     0.200
    56.303     2.988     0.200
    56.384     4.865     0.200
    56.430     1.216     0.200
    56.511     2.470     0.200
    56.551     5.714     0.200
    56.810     1.267     0.200
    56.810     5.110     0.200
    56.988     0.194     0.200
    57.070     4.601     0.200
    57.189     0.206     0.200
    57.189     3.558     0.200
    57.189     3.948     0.200
    57.257     3.157     0.200
    57.400     4.930     0.200
    57.431     4.388     0.200
    57.461     3.636     0.200
    57.768     4.412     0.200
    57.780     2.482     0.200
    57.954     2.432     0.200
    58.040     5.370     0.200
    58.356     3.454     0.200
    58.522     7.009     0.200
    58.559     5.133     0.200
    58.588     3.031     0.200
    58.760     1.714     0.200
    59.229     3.333     0.200
    59.299     2.810     0.200
    59.291     0.737     0.200
    59.649     0.783     0.200
    59.649     0.588     0.200
    59.687     2.718     0.200
    59.886     4.835     0.200
    59.920     2.621     0.200
    60.008     0.810     0.200
    60.226     5.025     0.200
    60.300     3.252     0.200
    60.387     3.228     0.200
    60.519     3.131     0.200
    60.828     3.142     0.200
    60.904     4.478     0.200
    61.043     3.268     0.200
    61.305     0.554     0.200
    61.305     3.444     0.200
    61.428     3.055     0.200
    61.563     2.979     0.200
    61.941     1.084     0.200
    62.177     1.422     0.200
    63.044     6.616     0.200
    64.071    -2.756     0.200
    64.329    -1.743     0.200
    64.134    -0.735     0.200
    64.137    -0.467     0.200
    65.742    -0.018     0.200
    68.476     0.248     0.200
    69.261     0.781     0.200
    69.893    -0.772     0.200
    70.053    -0.009     0.200
    70.625     0.732     0.200
    71.245     1.111     0.200
    71.612     0.635     0.200
    71.914     0.985     0.200
    72.797     0.663     0.200
    72.978    -0.266     0.200
    72.978     0.281     0.200
    73.388     0.846     0.200
    73.390     0.376     0.200
    73.390     1.571     0.200
    73.657     0.164     0.200
    73.657     2.101     0.200
    73.646    -0.389     0.200
    74.093     0.767     0.200
    75.114    -0.954     0.200
    75.835    -0.392     0.200
    75.856    -1.616     0.200
    76.335    -0.510     0.200
    76.582    -0.584     0.200
    76.928     0.024     0.200
    76.747     0.160     0.200
    76.747     0.332     0.200
    76.747     1.184     0.200
    76.782     0.831     0.200
    77.310    -1.974     0.200
    79.670     0.542     0.200
    80.187    -0.486     0.200
    80.360     0.804     0.200
    80.360     1.164     0.200
    81.706     1.287     0.200
    82.054    -0.451     0.200
    82.423    -0.180     0.200
    82.504    -0.319     0.200
    83.395     0.337     0.200
    83.673     0.031     0.200
    85.107    -0.502     0.200
    85.546     0.018     0.200
    86.316    -0.081     0.200
    86.366     0.060     0.200
    87.145     0.487     0.200
    87.146     0.632     0.200
    87.146     0.804     0.200
    86.840     1.517     0.200
    87.297     0.001     0.200
    94.060     1.716     0.200
    18.232     3.511     0.200
    23.962     0.934     0.200
    43.779    -0.976     0.200
    17.644     1.382     0.200
    18.552    -3.495     0.200
    18.552    -0.393     0.200
    19.458    -0.908     0.200
    20.398    -0.822     0.200
    23.910     1.659     0.200
    24.146    -0.129     0.200
    24.159     1.880     0.200
    24.405     1.401     0.200
    24.508     1.063     0.200
    27.654     0.898     0.200
    32.327     0.184     0.200
    37.111     3.858     0.200
    37.454    -1.439     0.200
    37.930     2.622     0.200
    42.392    -0.516     0.200
    42.392     2.323     0.200
    43.413     2.856     0.200
    43.913    -0.450     0.200
    49.308    -0.842     0.200
    49.499    -0.870     0.200
    53.877    -0.410     0.200
    72.417    -0.250     0.200
    77.669    -0.312     0.200
    81.276     0.392     0.200
    23.978     1.025     0.200
    24.074     0.196     0.200
    24.129     1.146     0.200
    24.129     0.099     0.200
    24.129     3.349     0.200
    27.379     0.646     0.200
    42.817    -0.103     0.200
    43.870    -0.368     0.200
    49.525     1.599     0.200
    54.273     0.794     0.200
    55.227     1.293     0.200
    77.500     0.494     0.200
    17.287     1.324     0.200
    18.075     0.969     0.200
    18.571    -3.793     0.200
    19.145    -1.430     0.200
    21.079     2.930     0.200
    22.711     1.762     0.200
    23.979     0.485     0.200
    23.979     0.938     0.200
    24.075     1.664     0.200
    24.131     0.800     0.200
    24.131    -0.724     0.200
    24.131     1.604     0.200
    24.131     3.198     0.200
    24.131     2.136     0.200
    24.293     1.818     0.200
    27.379     2.700     0.200
    27.407     1.213     0.200
    29.878     1.019     0.200
    29.939     2.707     0.200
    31.056     2.955     0.200
    31.056    -0.990     0.200
    31.056    -1.388     0.200
    32.363     0.858     0.200
    32.933     1.122     0.200
    34.837     2.968     0.200
    34.953     0.848     0.200
    34.953     0.355     0.200
    40.419     0.605     0.200
    40.533     2.179     0.200
    40.607     1.321     0.200
    41.043     1.643     0.200
    42.025     1.506     0.200
    42.812    -1.292     0.200
    42.812     0.513     0.200
    43.867     0.560     0.200
    43.867     2.404     0.200
    43.867     0.271     0.200
    44.578     2.158     0.200
    45.642     1.351     0.200
    47.489     0.953     0.200
    48.778     1.519     0.200
    49.293     1.183     0.200
    49.523     0.456     0.200
    49.523     1.878     0.200
    49.523     0.581     0.200
    49.535     1.145     0.200
    49.499     0.907     0.200
    53.554     1.070     0.200
    53.568     0.893     0.200
    54.268    -0.630     0.200
    54.268     1.487     0.200
    57.551    -0.137     0.200
    57.721     1.641     0.200
    59.655    -0.608     0.200
    77.504    -0.508     0.200
    77.504     0.445     0.200
    82.917     0.912     0.200
    83.785    -0.142     0.200
    17.285     3.038     0.200
    18.071     2.306     0.200
    19.143     0.993     0.200
    19.649     2.669     0.200
    20.288     2.086     0.200
    23.977     3.113     0.200
    24.073     0.791     0.200
    24.131    -0.792     0.200
    24.131     0.982     0.200
    24.179     2.664     0.200
    24.330     1.395     0.200
    27.376     1.935     0.200
    31.056     2.226     0.200
    42.806     0.719     0.200
    43.859    -0.279     0.200
    43.859     2.674     0.200
    47.485     3.001     0.200
    47.650     2.921     0.200
    49.285     0.822     0.200
    49.517    -0.224     0.200
    54.261    -1.058     0.200
    57.714     1.857     0.200
    60.313    -0.001     0.200
    72.369     1.119     0.200
    77.513     0.467     0.200
    77.513     0.217     0.200
    18.078     1.091     0.200
    18.078     0.684     0.200
    18.560    -3.735     0.200
    18.560    -3.313     0.200
    19.135    -1.355     0.200
    19.641    -1.159     0.200
    23.970     2.086     0.200
    23.970     0.125     0.200
    24.066     1.209     0.200
    24.123    -0.613     0.200
    24.123     1.293     0.200
    24.123     0.902     0.200
    24.285     1.405     0.200
    27.369     1.271     0.200
    31.048     0.999     0.200
    34.829     0.856     0.200
    34.943    -0.243     0.200
    34.943    -0.243     0.200
    35.870     0.723     0.200
    37.072    -1.111     0.200
    39.275    -0.479     0.200
    42.025     1.425     0.200
    42.813     1.348     0.200
    43.856     0.495     0.200
    43.856     0.924     0.200
    47.478     0.773     0.200
    49.282    -0.117     0.200
    49.512     0.321     0.200
    54.266     1.247     0.200
    57.710     1.279     0.200
    72.366     1.462     0.200
    77.513     0.514     0.200
    16.453     7.313     0.200
    17.276     0.833     0.200
    18.062     1.108     0.200
    18.562    -1.938     0.200
    18.562    -3.613     0.200
    18.562    -3.783     0.200
    19.149     1.841     0.200
    20.291     2.631     0.200
    21.094     2.875     0.200
    22.704     2.629     0.200
    23.203     4.278     0.200
    23.424     5.079     0.200
    23.984     0.075     0.200
    23.984     1.345     0.200
    24.080     2.223     0.200
    24.320    -0.998     0.200
    24.139    -0.440     0.200
    24.139     1.560     0.200
    24.139     2.960     0.200
    24.139     2.110     0.200
    24.301     2.979     0.200
    27.381     2.554     0.200
    27.409    -1.472     0.200
    29.500     3.980     0.200
    31.063    -0.717     0.200
    31.063     3.932     0.200
    32.129     0.608     0.200
    32.129     1.199     0.200
    32.939     3.305     0.200
    32.939     3.104     0.200
    34.955     1.449     0.200
    34.955     1.680     0.200
    37.057     1.239     0.200
    37.464     0.444     0.200
    37.806     0.652     0.200
    39.837     2.705     0.200
    40.403     0.837     0.200
    40.517    -1.464     0.200
    42.010    -0.752     0.200
    42.797     1.487     0.200
    42.797    -0.603     0.200
    42.968    -0.662     0.200
    43.860     0.756     0.200
    44.258    -0.654     0.200
    46.447    -0.080     0.200
    46.959    -0.386     0.200
    47.489     0.501     0.200
    49.285     1.086     0.200
    49.490    -0.508     0.200
    49.520     0.116     0.200
    49.520     1.959     0.200
    53.551     0.804     0.200
    53.564     0.894     0.200
    54.252    -0.440     0.200
    54.252     1.661     0.200
    55.226     0.944     0.200
    57.716     0.515     0.200
    57.716     0.866     0.200
    59.176     1.080     0.200
    59.245     0.836     0.200
    59.254     0.384     0.200
    59.470     0.732     0.200
    59.784     1.257     0.200
    59.857     0.981     0.200
    72.370     1.820     0.200
    73.039     1.815     0.200
    73.869     1.323     0.200
    77.517     0.836     0.200
    81.117     0.723     0.200
    16.881     5.419     0.200
    18.569    -2.406     0.200
    19.158     1.129     0.200
    23.992     1.039     0.200
    24.088     0.112     0.200
    24.147     1.032     0.200
    24.147     1.328     0.200
    24.147     2.828     0.200
    27.390     0.887     0.200
    31.071     1.590     0.200
    42.794     0.737     0.200
    43.282     0.987     0.200
    49.293     0.647     0.200
    54.251    -0.780     0.200
    77.512     0.110     0.200
    81.113     0.886     0.200
    17.283     0.770     0.200
    17.283     1.723     0.200
    18.069     0.113     0.200
    18.069     0.988     0.200
    18.566    -3.231     0.200
    19.146     1.081     0.200
    19.146     1.463     0.200
    20.285    -2.590     0.200
    21.086     3.037     0.200
    22.963     1.663     0.200
    23.980     0.984     0.200
    24.178    -0.428     0.200
    24.076     0.788     0.200
    24.133     2.684     0.200
    24.133     1.559     0.200
    24.133     1.785     0.200
    24.133     0.965     0.200
    24.329    -1.825     0.200
    24.296     0.304     0.200
    27.120    -0.184     0.200
    27.379     1.800     0.200
    27.407     1.821     0.200
    27.407     0.798     0.200
    27.882     1.165     0.200
    29.494     0.709     0.200
    30.868     0.739     0.200
    31.058     1.901     0.200
    32.128    -0.013     0.200
    32.935     2.621     0.200
    32.935     2.722     0.200
    37.090     1.884     0.200
    37.290     3.288     0.200
    37.321     3.023     0.200
    37.388     3.958     0.200
    37.952     3.080     0.200
    42.806    -0.057     0.200
    43.274    -0.200     0.200
    43.862    -0.692     0.200
    43.862    -1.137     0.200
    47.488     0.988     0.200
    47.533     1.338     0.200
    47.653     0.807     0.200
    47.958     2.736     0.200
    49.288    -1.304     0.200
    49.494    -1.469     0.200
    49.520    -0.742     0.200
    54.261    -1.426     0.200
    57.717    -0.249     0.200
    72.372     1.634     0.200
    73.048     1.915     0.200
    73.878     1.947     0.200
    77.511     0.229     0.200
    77.511     0.854     0.200
    81.111     0.849     0.200
    18.078     0.381     0.200
    18.570    -1.336     0.200
    23.976     3.001     0.200
    24.071     2.075     0.200
    24.128     1.238     0.200
    42.815     0.277     0.200
    43.865    -0.367     0.200
    54.270    -0.802     0.200
    54.270     0.573     0.200
    77.505     0.315     0.200
    81.105     0.265     0.200
    16.869     2.441     0.200
    18.075     0.168     0.200
    18.075     1.644     0.200
    18.563    -3.644     0.200
    18.563    -3.845     0.200
    19.645    -0.009     0.200
    21.081     2.890     0.200
    21.210     3.598     0.200
    22.715     1.922     0.200
    22.960     3.093     0.200
    23.974     2.822     0.200
    23.974     1.281     0.200
    24.070     1.903     0.200
    24.127    -1.079     0.200
    24.127     1.544     0.200
    24.127     2.321     0.200
    24.127     1.331     0.200
    27.401     2.455     0.200
    31.052     0.035     0.200
    32.772     3.718     0.200
    32.929     1.650     0.200
    32.929     1.650     0.200
    34.833     1.893     0.200
    34.947     1.931     0.200
    35.867     1.159     0.200
    35.969     1.312     0.200
    36.051     3.122     0.200
    37.582     0.425     0.200
    39.739     1.557     0.200
    40.241     1.098     0.200
    41.853     1.528     0.200
    42.810    -0.447     0.200
    43.651     0.750     0.200
    43.859    -0.069     0.200
    43.859     0.562     0.200
    44.574     1.665     0.200
    44.709     1.468     0.200
    45.474     1.439     0.200
    45.640     1.075     0.200
    47.482    -0.698     0.200
    49.285     0.565     0.200
    49.491     1.023     0.200
    49.516     1.178     0.200
    49.516     1.932     0.200
    49.516     0.233     0.200
    54.264    -1.152     0.200
    54.264     1.514     0.200
    55.219    -0.512     0.200
    57.713     2.652     0.200
    68.628     2.077     0.200
    70.150     2.150     0.200
    72.369     1.144     0.200
    73.052     1.045     0.200
    73.052     2.131     0.200
    73.882     1.254     0.200
    77.504     0.546     0.200
    77.512    -0.047     0.200
    77.549     0.109     0.200
    81.112    -0.463     0.200
    18.295     0.138     0.200
    18.540    -0.785     0.200
    18.957     1.455     0.200
    23.784     1.949     0.200
    23.880     1.090     0.200
    23.919     0.944     0.200
    54.447    -0.771     0.200
    15.656    10.694     0.200
    16.279     4.847     0.200
    16.531     6.836     0.200
    17.512     0.537     0.200
    17.512     1.319     0.200
    17.512     1.018     0.200
    17.512     1.787     0.200
    17.847     5.771     0.200
    18.029     0.934     0.200
    18.298     1.336     0.200
    18.298     1.535     0.200
    18.540    -3.856     0.200
    18.955    -0.848     0.200
    18.955    -0.348     0.200
    19.939     0.436     0.200
    20.265    -0.080     0.200
    20.265     0.100     0.200
    21.805     0.883     0.200
    22.601     3.580     0.200
    22.766     3.364     0.200
    22.968     4.696     0.200
    22.924     2.962     0.200
    22.924     0.552     0.200
    22.924     3.650     0.200
    22.924     1.353     0.200
    23.482     0.655     0.200
    23.782     0.676     0.200
    23.782     0.215     0.200
    23.782     1.348     0.200
    23.878     1.153     0.200
    23.917     1.550     0.200
    23.917     0.737     0.200
    23.917     1.335     0.200
    23.917     1.647     0.200
    23.917     1.190     0.200
    24.079     0.961     0.200
    24.079     1.633     0.200
    24.233     0.778     0.200
    24.229     1.263     0.200
    24.235     3.205     0.200
    24.235     0.232     0.200
    24.546     1.609     0.200
    24.546     0.757     0.200
    24.546     1.476     0.200
    24.865     1.059     0.200
    25.657     2.600     0.200
    27.205     1.295     0.200
    27.234     1.268     0.200
    27.234    -0.393     0.200
    27.662     0.525     0.200
    29.659     0.354     0.200
    30.151     0.501     0.200
    30.676     1.763     0.200
    30.842     2.895     0.200
    30.842     0.856     0.200
    30.842     3.113     0.200
    30.918     3.676     0.200
    31.991     0.983     0.200
    31.991     0.394     0.200
    32.562     0.071     0.200
    32.694     2.818     0.200
    32.725     0.140     0.200
    32.725     0.140     0.200
    34.780     0.565     0.200
    34.780     1.026     0.200
    35.354     0.823     0.200
    36.080     0.886     0.200
    36.134     0.285     0.200
    36.243     1.291     0.200
    36.175     1.298     0.200
    36.301     3.097     0.200
    36.266     0.894     0.200
    36.594     3.393     0.200
    36.866     2.978     0.200
    36.961     3.665     0.200
    36.865     1.087     0.200
    37.063     3.606     0.200
    37.095     3.232     0.200
    37.121     2.312     0.200
    37.160     3.883     0.200
    37.194     3.586     0.200
    37.619     0.811     0.200
    37.724     3.198     0.200
    37.728     2.763     0.200
    37.672     0.197     0.200
    37.680     1.291     0.200
    38.044    -0.492     0.200
    38.044     2.992     0.200
    38.025     0.615     0.200
    38.683     0.217     0.200
    38.838     0.249     0.200
    38.881     0.940     0.200
    39.271     0.785     0.200
    39.521     0.182     0.200
    39.610    -0.139     0.200
    39.610     2.107     0.200
    39.945     0.250     0.200
    39.948     0.866     0.200
    39.986     1.278     0.200
    40.292     1.002     0.200
    40.642     2.955     0.200
    40.642     3.599     0.200
    40.746     0.662     0.200
    40.872     0.150     0.200
    40.996     1.096     0.200
    41.150     0.313     0.200
    41.234     1.162     0.200
    41.519     0.964     0.200
    41.563     0.685     0.200
    41.705     1.188     0.200
    41.938     0.519     0.200
    42.058     0.630     0.200
    42.223     0.378     0.200
    42.622     1.879     0.200
    43.017     1.726     0.200
    43.017     0.867     0.200
    43.087     0.106     0.200
    43.166     1.168     0.200
    43.513     0.378     0.200
    43.587     0.173     0.200
    43.800     0.573     0.200
    43.800     0.858     0.200
    43.861    -0.035     0.200
    44.119    -0.204     0.200
    44.119    -0.329     0.200
    44.447     0.180     0.200
    44.683     0.953     0.200
    45.380    -0.460     0.200
    45.380    -0.963     0.200
    46.064     0.401     0.200
    46.343     2.034     0.200
    46.432    -0.415     0.200
    46.819     3.300     0.200
    47.185     3.743     0.200
    47.205    -0.015     0.200
    47.329     0.868     0.200
    47.329     2.939     0.200
    47.374     1.425     0.200
    47.374     2.073     0.200
    47.477     1.348     0.200
    47.687     3.639     0.200
    47.666     1.498     0.200
    47.722     3.864     0.200
    47.798     2.677     0.200
    48.891     2.447     0.200
    48.891     4.267     0.200
    49.012     3.611     0.200
    49.140     0.734     0.200
    49.179     3.738     0.200
    49.233     0.096     0.200
    49.242    -0.036     0.200
    49.410     0.317     0.200
    49.410     0.868     0.200
    49.410     0.767     0.200
    49.410    -0.042     0.200
    49.410     0.169     0.200
    49.422     0.206     0.200
    49.422     0.745     0.200
    49.437     3.856     0.200
    49.443     0.516     0.200
    49.491    -0.746     0.200
    49.455    -0.078     0.200
    49.455     0.200     0.200
    49.740    -0.118     0.200
    49.968     0.018     0.200
    50.104     0.389     0.200
    50.104     1.533     0.200
    50.104     1.377     0.200
    50.440     1.042     0.200
    50.509     0.521     0.200
    50.570     0.958     0.200
    50.630     0.107     0.200
    51.156     0.750     0.200
    51.609     0.354     0.200
    51.822     3.455     0.200
    52.192     0.307     0.200
    52.305     0.420     0.200
    52.865     3.362     0.200
    53.077     3.801     0.200
    53.136     1.520     0.200
    53.136     1.219     0.200
    53.247     1.496     0.200
    53.840     1.880     0.200
    53.990     1.078     0.200
    53.990     0.449     0.200
    54.042     1.773     0.200
    54.042     1.945     0.200
    54.227     1.419     0.200
    54.308     1.829     0.200
    54.362     2.560     0.200
    54.449    -0.073     0.200
    54.449    -0.198     0.200
    54.449    -0.979     0.200
    54.489     0.315     0.200
    54.568    -0.338     0.200
    54.662    -0.638     0.200
    55.025     1.152     0.200
    55.074     0.079     0.200
    55.074     2.327     0.200
    55.074    -0.114     0.200
    55.086     2.090     0.200
    55.294     0.785     0.200
    55.294    -0.317     0.200
    55.294     1.683     0.200
    55.376     2.816     0.200
    55.383     1.547     0.200
    55.383     1.445     0.200
    55.395     1.260     0.200
    55.775    -0.686     0.200
    55.859    -0.778     0.200
    55.929     2.421     0.200
    55.977     1.203     0.200
    55.977     1.000     0.200
    56.028     0.215     0.200
    56.054     1.226     0.200
    56.326     1.585     0.200
    56.326     1.905     0.200
    56.450     0.001     0.200
    56.601     1.246     0.200
    56.971     1.396     0.200
    57.398     1.479     0.200
    57.408     2.177     0.200
    57.421     1.847     0.200
    57.465     1.404     0.200
    57.465     0.705     0.200
    57.465     1.506     0.200
    57.635     0.935     0.200
    57.635     1.239     0.200
    57.635     0.813     0.200
    57.635     1.462     0.200
    58.166     1.752     0.200
    58.556     4.310     0.200
    58.665     0.945     0.200
    58.657     0.175     0.200
    58.745     1.724     0.200
    58.817     1.640     0.200
    58.817     0.952     0.200
    59.044     2.964     0.200
    59.086     1.792     0.200
    59.159     2.373     0.200
    59.172     1.868     0.200
    59.202     1.991     0.200
    59.324     0.547     0.200
    59.383     1.809     0.200
    59.563     0.136     0.200
    59.704     1.856     0.200
    59.736     2.142     0.200
    59.773     1.712     0.200
    59.894     1.611     0.200
    60.044     2.933     0.200
    60.134     0.235     0.200
    60.433     2.894     0.200
    60.528     3.537     0.200
    60.692     0.636     0.200
    61.318    -0.245     0.200
    61.371     2.834     0.200
    61.475     2.823     0.200
    61.703     3.166     0.200
    62.035     2.697     0.200
    62.204     0.012     0.200
    62.868     1.574     0.200
    63.564    -0.040     0.200
    64.392     0.418     0.200
    67.898     0.719     0.200
    68.491    -0.208     0.200
    68.835     0.336     0.200
    69.077     0.069     0.200
    72.312     1.153     0.200
    73.252     1.191     0.200
    73.252     0.723     0.200
    73.392     1.064     0.200
    73.649    -0.096     0.200
    74.095     2.814     0.200
    74.095     0.521     0.200
    77.454     1.086     0.200
    77.461     0.567     0.200
    77.461     0.442     0.200
    81.058     0.551     0.200
    81.058    -0.140     0.200
    92.878     0.666     0.200
    18.063     2.701     0.200
    18.063     1.725     0.200
    18.571    -0.186     0.200
    18.571    -0.288     0.200
    19.153     1.026     0.200
    20.282     1.237     0.200
    21.090     3.035     0.200
    22.701     3.409     0.200
    23.988     2.842     0.200
    23.988     1.670     0.200
    24.083     0.794     0.200
    24.141     1.442     0.200
    24.141     0.743     0.200
    24.141     1.341     0.200
    27.386     0.798     0.200
    31.066     2.060     0.200
    34.960    -0.800     0.200
    39.731     0.482     0.200
    42.015     1.199     0.200
    42.801     1.043     0.200
    42.801     1.094     0.200
    42.801     1.344     0.200
    43.281     2.066     0.200
    43.868     0.620     0.200
    43.868     0.198     0.200
    44.467     0.444     0.200
    49.294    -0.132     0.200
    49.527    -0.290     0.200
    49.527     0.389     0.200
    54.258    -0.245     0.200
    77.508     0.318     0.200
    77.545     0.613     0.200
    81.108     1.661     0.200
    16.877     1.238     0.200
    18.065     1.162     0.200
    18.563    -2.944     0.200
    19.654    -1.404     0.200
    21.091     3.086     0.200
    22.804     4.459     0.200
    24.077     1.749     0.200
    24.136     0.339     0.200
    24.136     1.915     0.200
    27.885    -2.380     0.200
    42.801     1.457     0.200
    77.515     1.034     0.200
    23.100     2.148     0.200
    23.740     1.426     0.200
    23.757     1.227     0.200
    43.326     2.919     0.200
    43.326     3.607     0.200
    43.914     0.452     0.200
    74.398     1.688     0.200
    15.995     7.691     0.200
    17.738     1.804     0.200
    17.738     2.211     0.200
    17.618     5.086     0.200
    18.061     4.523     0.200
    18.676    -1.490     0.200
    18.851     0.814     0.200
    18.851     1.822     0.200
    19.938     1.091     0.200
    20.044     2.047     0.200
    20.058     1.995     0.200
    20.085     3.201     0.200
    20.085     3.545     0.200
    20.118     3.136     0.200
    22.065     3.927     0.200
    22.478     3.055     0.200
    22.753     5.307     0.200
    23.094     0.000     0.200
    23.094     1.516     0.200
    23.094     2.102     0.200
    23.094     1.899     0.200
    23.094     1.172     0.200
    23.107    -0.030     0.200
    23.302     0.109     0.200
    23.087     4.272     0.200
    23.654     1.309     0.200
    23.654    -0.050     0.200
    23.654     2.552     0.200
    23.661     1.168     0.200
    23.661     1.746     0.200
    23.756     1.143     0.200
    23.746     1.815     0.200
    23.746     0.518     0.200
    23.746     1.416     0.200
    23.746     2.416     0.200
    23.910     0.415     0.200
    23.910     3.197     0.200
    23.910     0.517     0.200
    24.140     2.436     0.200
    24.277     5.465     0.200
    24.824     1.574     0.200
    24.824     0.074     0.200
    24.824     2.035     0.200
    25.386     2.969     0.200
    25.875     4.725     0.200
    26.676     1.582     0.200
    26.987     4.785     0.200
    27.133     1.449     0.200
    27.226     2.732     0.200
    27.478     1.176     0.200
    27.604     2.946     0.200
    27.824     4.979     0.200
    27.850     4.740     0.200
    28.920     4.811     0.200
    29.059     4.374     0.200
    29.076     1.361     0.200
    29.076     1.939     0.200
    30.663     2.572     0.200
    30.674     1.903     0.200
    30.674     0.371     0.200
    31.979     0.293     0.200
    31.979    -0.738     0.200
    31.979    -0.621     0.200
    32.258     4.912     0.200
    32.502     5.590     0.200
    32.576     0.457     0.200
    32.576     1.136     0.200
    32.584     1.676     0.200
    33.472     4.515     0.200
    33.595     3.937     0.200
    34.234     5.183     0.200
    34.708     0.414     0.200
    34.708     0.703     0.200
    35.964     2.371     0.200
    35.964     1.269     0.200
    36.598     4.157     0.200
    36.700     5.283     0.200
    36.804     5.699     0.200
    36.832     5.657     0.200
    36.833     5.654     0.200
    37.250    -0.890     0.200
    37.425    -1.375     0.200
    37.470     5.742     0.200
    37.472     4.624     0.200
    37.816    -0.114     0.200
    37.951    -1.048     0.200
    37.965    -1.219     0.200
    37.838     2.817     0.200
    37.838     1.278     0.200
    38.308    -0.965     0.200
    38.030     2.923     0.200
    38.485    -0.579     0.200
    38.963    -0.722     0.200
    39.017    -1.236     0.200
    39.661     0.005     0.200
    40.230     0.438     0.200
    40.732     0.214     0.200
    40.344     1.712     0.200
    40.354     1.487     0.200
    40.803    -0.769     0.200
    40.900    -0.502     0.200
    41.095     0.165     0.200
    42.464    -1.248     0.200
    42.343     2.136     0.200
    42.509     0.072     0.200
    42.639     0.938     0.200
    42.679     0.104     0.200
    42.757     0.739     0.200
    42.905     1.928     0.200
    43.016     1.318     0.200
    43.053    -1.336     0.200
    43.185     0.844     0.200
    43.185    -1.304     0.200
    43.082     1.131     0.200
    43.300    -1.332     0.200
    43.300     1.418     0.200
    43.300     1.301     0.200
    43.312    -1.329     0.200
    43.198    -0.405     0.200
    43.198    -0.905     0.200
    43.598     0.967     0.200
    43.799     0.604     0.200
    43.891     0.458     0.200
    43.891     0.012     0.200
    43.891     1.309     0.200
    44.338     0.626     0.200
    44.432     0.567     0.200
    44.636    -0.324     0.200
    44.921    -1.336     0.200
    45.145    -1.317     0.200
    45.233     0.453     0.200
    46.130     1.340     0.200
    46.138     0.310     0.200
    46.140    -0.150     0.200
    46.740     1.457     0.200
    47.282     0.873     0.200
    47.282    -0.134     0.200
    47.282     4.373     0.200
    47.282    -0.533     0.200
    47.527     1.075     0.200
    47.721     0.771     0.200
    49.101     1.005     0.200
    49.352     0.357     0.200
    49.422    -0.950     0.200
    49.438     0.233     0.200
    49.438     0.835     0.200
    49.438     0.335     0.200
    49.438    -0.970     0.200
    49.450    -0.210     0.200
    49.450     1.102     0.200
    49.450    -1.062     0.200
    49.442    -0.901     0.200
    49.450     1.907     0.200
    49.469    -0.898     0.200
    49.472    -0.923     0.200
    49.480    -0.891     0.200
    49.489    -0.960     0.200
    49.503    -0.967     0.200
    49.510    -0.914     0.200
    49.575     0.383     0.200
    49.575     0.360     0.200
    49.515    -0.952     0.200
    49.523    -0.914     0.200
    49.575    -0.913     0.200
    49.681     3.383     0.200
    50.271    -0.907     0.200
    50.481    -0.994     0.200
    50.549    -1.013     0.200
    50.658    -0.930     0.200
    51.169    -0.879     0.200
    51.627     1.073     0.200
    51.627    -0.810     0.200
    51.770    -0.873     0.200
    52.218    -0.914     0.200
    53.451    -0.830     0.200
    53.466    -0.831     0.200
    53.479     1.798     0.200
    53.505     5.300     0.200
    53.597     2.226     0.200
    53.843     2.254     0.200
    53.880     1.725     0.200
    53.880     2.171     0.200
    54.027     3.255     0.200
    54.027    -0.745     0.200
    54.075     6.408     0.200
    54.148     3.537     0.200
    54.238     2.418     0.200
    54.231    -0.002     0.200
    54.344     2.218     0.200
    54.344    -0.860     0.200
    54.410    -1.041     0.200
    54.738    -1.195     0.200
    54.738     0.477     0.200
    54.594     3.411     0.200
    54.676    -0.772     0.200
    54.676     3.807     0.200
    54.814     2.955     0.200
    54.976     2.854     0.200
    55.090    -1.073     0.200
    55.038    -0.497     0.200
    55.039     1.548     0.200
    55.144     2.163     0.200
    55.144     3.331     0.200
    55.144     2.949     0.200
    55.248     2.581     0.200
    55.248     2.284     0.200
    55.337     4.551     0.200
    55.352     1.833     0.200
    55.352     1.442     0.200
    55.394     2.796     0.200
    55.372    -0.510     0.200
    55.446     2.162     0.200
    55.446     2.318     0.200
    55.456     1.645     0.200
    55.460     1.861     0.200
    55.700     3.336     0.200
    55.743     1.424     0.200
    55.983     2.410     0.200
    55.983     3.394     0.200
    55.993    -0.866     0.200
    56.049     1.531     0.200
    56.049     1.374     0.200
    56.051     1.825     0.200
    56.051     2.372     0.200
    56.105    -0.664     0.200
    56.105     1.125     0.200
    56.105    -1.062     0.200
    56.113     1.370     0.200
    56.113     2.620     0.200
    56.124     1.368     0.200
    56.235     1.109     0.200
    56.254     1.527     0.200
    56.384     1.940     0.200
    56.384     2.542     0.200
    56.472     2.217     0.200
    56.520     3.971     0.200
    56.598     2.381     0.200
    56.630     1.550     0.200
    56.630     2.448     0.200
    57.037     1.799     0.200
    57.096     0.919     0.200
    57.154     2.128     0.200
    57.248     1.615     0.200
    57.462     1.402     0.200
    57.462     4.801     0.200
    57.461     1.188     0.200
    57.476     1.416     0.200
    57.532     1.500     0.200
    57.545     1.926     0.200
    57.545     0.262     0.200
    57.700     2.123     0.200
    57.700     0.725     0.200
    57.700     1.060     0.200
    57.816     1.568     0.200
    57.887    -0.894     0.200
    58.106     2.523     0.200
    58.110     2.042     0.200
    58.131     1.665     0.200
    58.143     1.249     0.200
    58.143     2.773     0.200
    58.219     2.473     0.200
    58.226     1.085     0.200
    58.494     2.020     0.200
    58.655     2.018     0.200
    58.665     1.759     0.200
    58.790     0.023     0.200
    58.764     1.715     0.200
    58.941     3.066     0.200
    59.083     1.690     0.200
    59.140     2.527     0.200
    59.235     1.627     0.200
    59.441     1.964     0.200
    59.620     2.112     0.200
    59.770     2.268     0.200
    59.802     2.139     0.200
    59.802     2.257     0.200
    59.786     2.861     0.200
    59.835     2.163     0.200
    59.962     1.623     0.200
    59.993     1.217     0.200
    60.016     1.410     0.200
    60.159     2.656     0.200
    60.172     2.863     0.200
    60.209     1.204     0.200
    60.257     2.349     0.200
    60.374     2.631     0.200
    60.518     2.422     0.200
    60.824     2.242     0.200
    60.887     1.391     0.200
    60.887     2.407     0.200
    60.931     0.790     0.200
    60.931     4.415     0.200
    60.931     0.173     0.200
    61.508     1.061     0.200
    61.780     1.393     0.200
    61.956     1.424     0.200
    61.958     2.513     0.200
    61.958    -0.167     0.200
    62.593     0.883     0.200
    62.659     0.132     0.200
    63.068     0.263     0.200
    62.912     0.998     0.200
    62.912     2.662     0.200
    62.912    -0.752     0.200
    63.442     2.721     0.200
    63.638     2.693     0.200
    63.679     0.587     0.200
    63.881     2.107     0.200
    63.881    -0.565     0.200
    64.320    -1.056     0.200
    64.679     1.299     0.200
    64.826     0.309     0.200
    67.085     0.843     0.200
    67.160     0.702     0.200
    67.621     0.921     0.200
    68.182     1.493     0.200
    68.733     0.619     0.200
    68.769    -0.225     0.200
    68.956    -0.412     0.200
    69.008     0.718     0.200
    69.147     0.222     0.200
    70.122     1.238     0.200
    70.752     2.556     0.200
    71.243     2.611     0.200
    71.311     1.026     0.200
    71.790    -0.924     0.200
    71.992     0.618     0.200
    72.052     0.632     0.200
    72.052    -1.071     0.200
    72.445     0.588     0.200
    72.405     0.898     0.200
    72.405     0.453     0.200
    73.048    -0.900     0.200
    73.537    -0.888     0.200
    73.538    -0.894     0.200
    73.538     1.254     0.200
    73.671     0.668     0.200
    73.905     2.255     0.200
    73.937     0.891     0.200
    73.937     1.266     0.200
    73.937    -0.930     0.200
    73.937     2.985     0.200
    74.373     2.170     0.200
    74.783    -0.762     0.200
    74.783     3.058     0.200
    76.071    -0.659     0.200
    76.183    -0.699     0.200
    76.203     1.013     0.200
    76.203    -0.909     0.200
    77.458    -0.586     0.200
    77.458     2.749     0.200
    77.252     1.263     0.200
    77.252     0.411     0.200
    77.608    -0.421     0.200
    77.906    -0.392     0.200
    78.340    -0.297     0.200
    78.920     1.930     0.200
    78.920    -0.289     0.200
    79.320     3.317     0.200
    79.320     3.028     0.200
    80.588    -0.444     0.200
    80.817    -0.470     0.200
    80.845     1.281     0.200
    81.653     1.419     0.200
    81.653     3.201     0.200
    81.653    -0.214     0.200
    82.513     0.022     0.200
    82.826    -1.194     0.200
    82.826     0.556     0.200
    82.826    -0.358     0.200
    83.095    -1.224     0.200
    83.124     1.745     0.200
    83.148     0.279     0.200
    83.180     1.051     0.200
    83.353     0.272     0.200
    83.387     1.887     0.200
    83.411     0.155     0.200
    83.635    -0.275     0.200
    83.635    -0.104     0.200
    83.635     1.342     0.200
    83.635    -0.432     0.200
    83.637    -0.117     0.200
    83.771     0.097     0.200
    84.333     0.595     0.200
    84.830     0.123     0.200
    84.852     0.640     0.200
    84.987     0.849     0.200
    84.987    -0.198     0.200
    85.248    -0.176     0.200
    85.384     1.473     0.200
    85.384    -0.386     0.200
    85.748     2.076     0.200
    87.323     1.345     0.200
    87.727     1.549     0.200
    92.884     1.502     0.200
    18.316     0.748     0.200
    19.199    -3.804     0.200
    22.646    -0.318     0.200
    22.646     1.157     0.200
    24.179     2.651     0.200
    24.202     1.497     0.200
    24.273     1.814     0.200
    27.689     2.119     0.200
    40.180     2.352     0.200
    43.217    -1.175     0.200
    43.217     2.624     0.200
    43.777    -1.587     0.200
    44.449    -1.213     0.200
    47.851     2.130     0.200
    50.113     0.668     0.200
    59.693     0.254     0.200
    80.435    -0.508     0.200
    18.563    -0.436     0.200
    18.563    -0.936     0.200
    18.678    -1.372     0.200
    22.468     1.670     0.200
    23.654     3.666     0.200
    23.737     2.803     0.200
    23.737     1.404     0.200
    23.749     0.422     0.200
    24.835    -0.214     0.200
    43.310    -1.201     0.200
    47.526     0.609     0.200
    49.436     0.829     0.200
    57.699     0.964     0.200
    58.791     0.121     0.200
    73.548     1.061     0.200
    77.248     1.005     0.200
    18.554    -1.412     0.200
    23.097     0.119     0.200
    43.299     2.422     0.200
    43.299     3.242     0.200
    47.522    -0.438     0.200
    82.585     2.243     0.200
    43.896    -0.366     0.200
    15.136     6.456     0.200
    15.136     6.494     0.200
    15.991     7.528     0.200
    18.552    -0.249     0.200
    18.685    -2.491     0.200
    18.685    -1.163     0.200
    18.858     1.085     0.200
    19.275     1.163     0.200
    20.076     3.202     0.200
    22.756     3.201     0.200
    23.089     1.774     0.200
    23.089     1.649     0.200
    23.649     0.989     0.200
    23.667     1.986     0.200
    23.667     2.681     0.200
    23.751     0.918     0.200
    23.751     3.816     0.200
    23.751     2.582     0.200
    23.915     2.620     0.200
    24.825    -0.181     0.200
    27.140     3.112     0.200
    28.640     3.249     0.200
    29.080     3.469     0.200
    30.680     2.332     0.200
    32.581     2.710     0.200
    34.461     1.867     0.200
    39.429     3.450     0.200
    41.456     0.645     0.200
    41.496     0.065     0.200
    42.511    -0.100     0.200
    43.301     1.009     0.200
    43.301    -1.170     0.200
    43.900     1.238     0.200
    44.967    -0.389     0.200
    46.140    -0.527     0.200
    47.290     1.370     0.200
    49.361     0.310     0.200
    49.447     0.938     0.200
    57.541     0.410     0.200
    57.709     1.776     0.200
    57.709     0.049     0.200
    74.374     2.878     0.200
    18.556    -0.453     0.200
    18.657    -0.668     0.200
    19.258     0.032     0.200
    23.105     2.367     0.200
    23.647     0.035     0.200
    23.735     0.832     0.200
    23.735     1.782     0.200
    23.742     3.065     0.200
    24.823     0.704     0.200
    43.297     2.267     0.200
    43.872     1.261     0.200
    47.265     0.220     0.200
    47.508    -1.231     0.200
    49.419     1.025     0.200
    57.680     1.684     0.200
    73.534     1.862     0.200
    74.372     2.658     0.200
    19.981     2.118     0.200
    22.940     2.959     0.200
    23.035     1.954     0.200
    23.016     1.315     0.200
    25.531     1.612     0.200
    35.611     0.012     0.200
    42.324    -1.850     0.200
    77.554     1.973     0.200
    80.960     1.117     0.200
    14.981     7.070     0.200
    15.985     6.884     0.200
    16.399     6.257     0.200
    18.070     4.246     0.200
    18.694    -1.577     0.200
    18.863     1.021     0.200
    18.863    -0.081     0.200
    18.863     1.638     0.200
    19.278     2.711     0.200
    19.759     3.756     0.200
    19.759     2.952     0.200
    19.759     3.256     0.200
    19.923     1.706     0.200
    20.041     3.179     0.200
    20.068     1.884     0.200
    20.068     1.865     0.200
    20.068     0.705     0.200
    20.104     2.487     0.200
    20.976     4.029     0.200
    21.629     7.095     0.200
    21.746     1.294     0.200
    21.863     3.091     0.200
    22.054     5.045     0.200
    22.307     3.741     0.200
    22.471     1.571     0.200
    22.758     4.853     0.200
    23.086    -1.533     0.200
    23.086     0.678     0.200
    23.086     2.525     0.200
    23.086     0.506     0.200
    23.077     2.671     0.200
    23.292    -1.196     0.200
    23.646    -1.142     0.200
    23.646     2.999     0.200
    23.646     2.288     0.200
    23.646    -0.712     0.200
    23.646     1.589     0.200
    23.672     1.582     0.200
    23.672    -0.390     0.200
    23.672    -0.148     0.200
    23.672     1.813     0.200
    23.672     2.750     0.200
    23.767     0.432     0.200
    23.754     0.701     0.200
    23.754     1.201     0.200
    23.754     1.177     0.200
    23.754     0.021     0.200
    23.764     1.205     0.200
    23.918    -0.001     0.200
    23.918     1.359     0.200
    24.121     1.142     0.200
    24.123     2.940     0.200
    24.123     1.819     0.200
    24.262     4.458     0.200
    24.828     0.304     0.200
    24.828    -1.958     0.200
    24.828     3.015     0.200
    24.828     1.304     0.200
    25.174    -0.741     0.200
    25.174     1.048     0.200
    25.320     4.026     0.200
    25.384     2.343     0.200
    25.862     3.704     0.200
    26.347     2.906     0.200
    26.347     4.566     0.200
    26.347     4.015     0.200
    26.347     3.715     0.200
    26.666     2.440     0.200
    26.666     4.139     0.200
    26.995     2.371     0.200
    27.146     1.440     0.200
    27.175     0.756     0.200
    27.219     4.759     0.200
    27.485     1.966     0.200
    27.816     4.905     0.200
    27.831     2.568     0.200
    27.858     2.330     0.200
    28.253     2.207     0.200
    28.315     3.952     0.200
    28.843     2.357     0.200
    29.067     2.361     0.200
    29.480     4.417     0.200
    29.480     5.788     0.200
    29.887     4.873     0.200
    30.265     4.743     0.200
    30.302     4.700     0.200
    30.420     4.980     0.200
    30.678     2.095     0.200
    30.683     4.022     0.200
    30.683     1.819     0.200
    30.683     4.537     0.200
    30.683     1.455     0.200
    30.683     3.217     0.200
    30.683     4.756     0.200
    30.683     4.908     0.200
    30.739     4.950     0.200
    30.945     5.270     0.200
    30.875     5.160     0.200
    31.063     4.893     0.200
    31.335     2.608     0.200
    31.420     4.557     0.200
    31.716     3.247     0.200
    31.716     4.907     0.200
    31.813     2.701     0.200
    31.994     0.413     0.200
    31.994     0.702     0.200
    31.935     4.629     0.200
    32.267     2.234     0.200
    32.509     5.285     0.200
    32.585     1.050     0.200
    32.585     0.800     0.200
    32.544     4.678     0.200
    32.569     3.564     0.200
    32.569     2.200     0.200
    32.569     3.872     0.200
    32.569     2.661     0.200
    33.009     4.310     0.200
    32.932     4.335     0.200
    32.980     3.860     0.200
    33.036     4.068     0.200
    33.036     3.631     0.200
    33.481     2.188     0.200
    34.320     5.339     0.200
    34.721     1.149     0.200
    34.721     0.938     0.200
    34.668     5.328     0.200
    35.014     4.519     0.200
    35.342     6.242     0.200
    35.558     4.769     0.200
    35.668     4.086     0.200
    35.685     5.271     0.200
    35.883     4.289     0.200
    35.883     5.969     0.200
    35.887     4.381     0.200
    36.032     4.746     0.200
    36.413     5.287     0.200
    36.402     4.875     0.200
    36.700     3.835     0.200
    36.804     5.350     0.200
    36.832     5.210     0.200
    36.832     5.004     0.200
    36.854     4.225     0.200
    36.920     4.500     0.200
    36.904     5.692     0.200
    36.933     5.348     0.200
    37.442    -0.875     0.200
    37.498     4.600     0.200
    37.471     5.485     0.200
    37.567     4.265     0.200
    37.832     0.885     0.200
    37.832    -0.682     0.200
    37.832     0.725     0.200
    37.970     0.228     0.200
    37.686     2.960     0.200
    37.738     4.103     0.200
    37.793     4.421     0.200
    37.844     3.502     0.200
    37.844     4.631     0.200
    37.844     1.495     0.200
    38.221     3.736     0.200
    38.283     3.920     0.200
    38.762     2.096     0.200
    38.967     0.785     0.200
    39.111     0.908     0.200
    39.172     0.519     0.200
    39.362     0.505     0.200
    39.433     0.375     0.200
    39.320     4.506     0.200
    39.431     3.886     0.200
    39.431     1.749     0.200
    39.431     3.089     0.200
    39.676     2.958     0.200
    39.678    -0.007     0.200
    39.678     1.743     0.200
    39.709     0.502     0.200
    39.884     4.766     0.200
    39.931     5.037     0.200
    40.234    -0.179     0.200
    39.979     2.292     0.200
    40.006     4.103     0.200
    40.006     0.674     0.200
    40.006     2.084     0.200
    40.006     4.213     0.200
    40.006     3.103     0.200
    40.006     3.507     0.200
    40.347     2.328     0.200
    40.347     1.379     0.200
    40.347     2.047     0.200
    40.640     1.718     0.200
    40.400     3.240     0.200
    40.400     3.235     0.200
    40.806     0.978     0.200
    40.561     3.497     0.200
    40.804     0.258     0.200
    40.683     0.921     0.200
    40.683     2.593     0.200
    41.201     0.728     0.200
    41.281     0.136     0.200
    41.419     0.584     0.200
    41.499     0.183     0.200
    41.592     2.177     0.200
    41.877     2.679     0.200
    41.658     4.775     0.200
    41.793     3.568     0.200
    42.359     0.647     0.200
    42.515     0.590     0.200
    42.643     0.936     0.200
    42.859     1.584     0.200
    42.909     0.975     0.200
    43.057     0.676     0.200
    43.060     0.358     0.200
    43.060     0.557     0.200
    43.189     1.008     0.200
    43.098     0.849     0.200
    43.304     0.878     0.200
    43.214     0.486     0.200
    43.214    -0.393     0.200
    43.410     0.920     0.200
    43.497     0.249     0.200
    43.614     0.882     0.200
    43.905     0.035     0.200
    43.908     0.334     0.200
    43.908     0.818     0.200
    43.908     0.209     0.200
    43.918     0.329     0.200
    44.009     0.240     0.200
    43.758     4.522     0.200
    44.049     1.678     0.200
    44.213     3.318     0.200
    44.239     4.855     0.200
    44.448     0.987     0.200
    44.563     0.863     0.200
    44.924     2.381     0.200
    44.970    -0.176     0.200
    44.990     1.527     0.200
    45.148     0.200     0.200
    45.240     2.067     0.200
    45.168     1.961     0.200
    44.990     4.121     0.200
    45.357    -1.202     0.200
    45.357     1.548     0.200
    45.252     4.290     0.200
    45.662     0.722     0.200
    46.134     0.938     0.200
    46.331     0.448     0.200
    46.280     1.851     0.200
    46.364     5.292     0.200
    46.581     4.211     0.200
    46.757    -0.192     0.200
    47.121     0.263     0.200
    47.086     4.959     0.200
    47.261     1.071     0.200
    47.296     2.551     0.200
    47.296     1.070     0.200
    47.296     2.090     0.200
    47.296     1.391     0.200
    47.296     1.891     0.200
    47.339     0.837     0.200
    47.339     1.161     0.200
    47.544     1.162     0.200
    47.625     0.138     0.200
    47.642     0.404     0.200
    47.738     1.334     0.200
    47.728     2.939     0.200
    47.761     0.475     0.200
    47.862     0.795     0.200
    48.544     1.125     0.200
    48.736     2.189     0.200
    49.113     0.257     0.200
    49.118     5.219     0.200
    49.370    -0.291     0.200
    49.454     0.492     0.200
    49.454    -0.489     0.200
    49.454     0.144     0.200
    49.454    -0.856     0.200
    49.466    -0.788     0.200
    49.466    -0.651     0.200
    49.466     0.326     0.200
    49.460     1.196     0.200
    49.590     0.635     0.200
    49.592     0.489     0.200
    49.592    -0.284     0.200
    49.695     4.173     0.200
    49.698     0.825     0.200
    49.895     1.448     0.200
    49.905     0.310     0.200
    50.018    -0.948     0.200
    50.287    -0.492     0.200
    50.298     6.187     0.200
    50.438     5.790     0.200
    50.497    -0.580     0.200
    50.557    -0.133     0.200
    50.566    -0.900     0.200
    50.626    -0.158     0.200
    50.675    -0.120     0.200
    50.843     4.097     0.200
    50.837     5.158     0.200
    51.185     0.234     0.200
    51.644     3.165     0.200
    51.644     0.302     0.200
    51.709    -2.508     0.200
    51.968     2.229     0.200
    52.234     0.701     0.200
    52.395     4.346     0.200
    52.562     1.036     0.200
    53.042     1.432     0.200
    53.042     3.607     0.200
    53.201     3.486     0.200
    53.321     4.014     0.200
    53.482     0.276     0.200
    53.495     2.026     0.200
    53.556     1.223     0.200
    53.521     2.309     0.200
    53.564     2.468     0.200
    53.569     3.744     0.200
    53.574     4.307     0.200
    53.613     3.592     0.200
    53.547     2.357     0.200
    53.566     3.671     0.200
    53.575     3.246     0.200
    53.794     4.558     0.200
    53.859     3.770     0.200
    53.896     1.440     0.200
    53.953     4.132     0.200
    53.878     3.417     0.200
    53.878     0.452     0.200
    53.878     2.995     0.200
    53.878     3.171     0.200
    53.878    -0.829     0.200
    54.042     3.032     0.200
    54.042    -0.429     0.200
    53.958     3.671     0.200
    54.091     2.791     0.200
    54.013     3.965     0.200
    54.013     3.657     0.200
    54.164     2.803     0.200
    54.143     5.506     0.200
    54.143     3.486     0.200
    54.254     2.263     0.200
    54.247     2.852     0.200
    54.245     4.322     0.200
    54.166     4.415     0.200
    54.166     3.786     0.200
    54.283     2.814     0.200
    54.277     4.320     0.200
    54.282     3.837     0.200
    54.313     3.914     0.200
    54.230     4.637     0.200
    54.361     0.347     0.200
    54.427    -0.531     0.200
    54.427     3.078     0.200
    54.341     4.107     0.200
    54.341     3.439     0.200
    54.444     3.946     0.200
    54.355     4.697     0.200
    54.374     4.063     0.200
    54.374     3.419     0.200
    54.362     3.695     0.200
    54.370     5.031     0.200
    54.610     3.019     0.200
    54.745     1.138     0.200
    54.676     3.101     0.200
    54.692     3.533     0.200
    54.692     0.341     0.200
    54.613     3.938     0.200
    54.609     6.343     0.200
    54.795     3.667     0.200
    54.919     0.986     0.200
    54.833     4.159     0.200
    54.833     3.358     0.200
    54.993     2.364     0.200
    54.895     4.593     0.200
    55.032     1.775     0.200
    55.032     5.076     0.200
    55.053     0.528     0.200
    55.053     1.573     0.200
    55.053     1.425     0.200
    55.107     1.666     0.200
    55.107     0.638     0.200
    54.983     4.619     0.200
    55.065     0.539     0.200
    55.180     1.097     0.200
    55.160     2.250     0.200
    55.086     4.779     0.200
    55.265     1.926     0.200
    55.079     4.237     0.200
    55.079     3.737     0.200
    55.079     2.135     0.200
    55.354     3.954     0.200
    55.369     1.557     0.200
    55.369     1.248     0.200
    55.372     3.168     0.200
    55.344     5.230     0.200
    55.398     1.736     0.200
    55.202     0.547     0.200
    55.410     4.795     0.200
    55.387     1.815     0.200
    55.387     0.515     0.200
    55.245     4.339     0.200
    55.463     1.968     0.200
    55.463     1.366     0.200
    55.473     1.197     0.200
    55.273     2.938     0.200
    55.517     1.199     0.200
    55.552     1.928     0.200
    55.542     3.597     0.200
    55.542     3.796     0.200
    55.717     2.456     0.200
    55.526     3.115     0.200
    55.760     2.134     0.200
    55.583     4.252     0.200
    55.761     2.823     0.200
    55.691     3.831     0.200
    55.758     3.745     0.200
    55.937     2.889     0.200
    56.000     2.615     0.200
    56.049     0.351     0.200
    56.066     0.980     0.200
    56.066     0.562     0.200
    56.068     1.630     0.200
    55.907     1.776     0.200
    56.122     0.641     0.200
    56.122    -0.558     0.200
    56.130     2.302     0.200
    56.130     1.286     0.200
    55.958     5.115     0.200
    56.141     2.104     0.200
    56.086     4.390     0.200
    56.252     1.812     0.200
    56.270     2.158     0.200
    56.205     4.278     0.200
    56.307     2.664     0.200
    56.124     3.828     0.200
    56.228     3.674     0.200
    56.365     2.203     0.200
    56.401     1.145     0.200
    56.426     0.962     0.200
    56.433    -0.079     0.200
    56.236     6.029     0.200
    56.468     1.007     0.200
    56.480     1.387     0.200
    56.272     4.668     0.200
    56.489     1.726     0.200
    56.510     0.775     0.200
    56.537     1.676     0.200
    56.615     1.827     0.200
    56.613     4.346     0.200
    56.646     1.778     0.200
    56.628     0.530     0.200
    56.695     0.640     0.200
    56.823     1.714     0.200
    56.865     0.346     0.200
    56.806     4.189     0.200
    57.026     1.146     0.200
    56.823     5.447     0.200
    56.924     3.383     0.200
    56.924     2.672     0.200
    57.029     3.610     0.200
    57.054     1.605     0.200
    57.096     1.197     0.200
    56.916     2.978     0.200
    56.916     4.810     0.200
    56.916     5.587     0.200
    57.014     4.885     0.200
    57.158     1.215     0.200
    57.171     1.476     0.200
    57.066     3.263     0.200
    57.194     1.156     0.200
    57.237     0.313     0.200
    57.228     1.294     0.200
    57.079     3.927     0.200
    57.376     1.033     0.200
    57.460     3.336     0.200
    57.379     1.107     0.200
    57.189     3.954     0.200
    57.189     4.353     0.200
    57.189     1.853     0.200
    57.420     0.463     0.200
    57.479     2.607     0.200
    57.549     1.110     0.200
    57.549     0.212     0.200
    57.561     1.230     0.200
    57.561    -0.078     0.200
    57.434     6.124     0.200
    57.645     1.292     0.200
    57.717     1.319     0.200
    57.717     0.530     0.200
    57.717     0.190     0.200
    57.600     6.148     0.200
    57.833     1.706     0.200
    57.799     3.352     0.200
    58.032     0.950     0.200
    58.093     1.380     0.200
    58.094     1.441     0.200
    58.096     3.909     0.200
    58.004     5.516     0.200
    58.205     0.301     0.200
    58.043     1.637     0.200
    58.289     0.705     0.200
    58.223     4.671     0.200
    58.553     2.973     0.200
    58.553     3.575     0.200
    58.553     0.575     0.200
    58.724     2.719     0.200
    58.724     0.484     0.200
    58.807    -0.049     0.200
    58.792     0.995     0.200
    58.776     1.587     0.200
    58.778     0.702     0.200
    58.766     3.692     0.200
    59.148     1.356     0.200
    59.262     1.537     0.200
    59.079     3.915     0.200
    59.409    -0.269     0.200
    59.577     0.819     0.200
    59.624     0.668     0.200
    59.410     5.625     0.200
    59.639     0.980     0.200
    59.573     3.392     0.200
    59.802     0.870     0.200
    59.907     0.693     0.200
    59.788     5.120     0.200
    60.003    -0.011     0.200
    59.808     5.078     0.200
    60.096     0.106     0.200
    60.135    -0.032     0.200
    60.135     1.324     0.200
    60.154     0.823     0.200
    60.170     0.050     0.200
    60.175     3.244     0.200
    60.098     3.472     0.200
    60.340    -1.127     0.200
    60.340     1.224     0.200
    60.340     0.865     0.200
    60.340    -0.475     0.200
    60.372     1.327     0.200
    60.372     4.403     0.200
    60.566     4.986     0.200
    60.722     2.115     0.200
    60.770     0.091     0.200
    60.902     1.591     0.200
    60.902    -0.108     0.200
    60.862     4.494     0.200
    60.941     1.436     0.200
    60.941     0.928     0.200
    60.941     3.697     0.200
    60.941     2.627     0.200
    60.941     0.627     0.200
    61.047     4.803     0.200
    61.595     3.496     0.200
    61.971     4.667     0.200
    62.597     1.159     0.200
    62.761     3.018     0.200
    62.928     0.062     0.200
    62.928     2.562     0.200
    62.973     0.563     0.200
    63.074     0.257     0.200
    63.655     0.343     0.200
    63.898    -0.969     0.200
    63.897     0.549     0.200
    63.897     1.885     0.200
    63.920     4.397     0.200
    64.338     1.254     0.200
    64.338    -0.047     0.200
    64.470     2.287     0.200
    64.688     0.040     0.200
    66.216     2.168     0.200
    67.510     2.572     0.200
    68.642     1.240     0.200
    69.122     1.921     0.200
    69.160     1.560     0.200
    69.830     3.673     0.200
    70.211    -0.721     0.200
    70.211    -0.296     0.200
    70.138     1.078     0.200
    70.431    -0.643     0.200
    70.756     3.075     0.200
    70.975    -0.559     0.200
    71.248     0.393     0.200
    71.605     4.697     0.200
    72.011     5.063     0.200
    72.174     1.117     0.200
    72.149     4.605     0.200
    72.097     1.224     0.200
    72.097     5.376     0.200
    72.269     4.394     0.200
    72.362     3.604     0.200
    72.413     0.085     0.200
    72.420     0.846     0.200
    72.422     1.132     0.200
    72.422     0.862     0.200
    73.053    -0.021     0.200
    73.127     4.743     0.200
    73.456     2.200     0.200
    73.543    -0.808     0.200
    73.544    -0.814     0.200
    73.544     0.584     0.200
    73.544     0.127     0.200
    73.595     4.706     0.200
    73.778     4.780     0.200
    73.944     0.639     0.200
    73.944    -0.861     0.200
    74.377     2.162     0.200
    74.377     1.162     0.200
    74.492     4.627     0.200
    74.547     4.550     0.200
    74.413     3.374     0.200
    74.733    -1.058     0.200
    75.067     1.548     0.200
    74.787     0.823     0.200
    75.075     4.474     0.200
    75.335     4.843     0.200
    75.535     5.085     0.200
    75.630     5.020     0.200
    75.747     5.074     0.200
    75.829     5.563     0.200
    76.074     2.034     0.200
    76.076     4.434     0.200
    76.211    -0.142     0.200
    76.449     2.707     0.200
    77.464     0.786     0.200
    77.175     2.847     0.200
    77.175     1.425     0.200
    77.229     1.006     0.200
    77.229     1.807     0.200
    77.236     1.362     0.200
    77.236     0.339     0.200
    77.236    -0.837     0.200
    77.610     0.567     0.200
    77.462     2.440     0.200
    77.462     3.300     0.200
    77.549     3.854     0.200
    77.580     3.357     0.200
    77.589     3.307     0.200
    77.589     2.065     0.200
    77.910     0.500     0.200
    78.344     0.890     0.200
    78.925     0.788     0.200
    79.323     1.628     0.200
    79.323     1.460     0.200
    79.819     3.709     0.200
    80.596    -0.082     0.200
    80.827     0.583     0.200
    80.828     1.577     0.200
    80.829     0.419     0.200
    80.829     0.052     0.200
    80.834     2.845     0.200
    80.834     0.443     0.200
    81.658     1.560     0.200
    81.658     1.716     0.200
    81.658     0.966     0.200
    81.658     0.865     0.200
    81.514     3.200     0.200
    82.835     0.322     0.200
    82.793     3.519     0.200
    82.614     2.745     0.200
    82.614     2.952     0.200
    82.925     2.157     0.200
    83.644     0.572     0.200
    83.644     0.221     0.200
    85.044     3.162     0.200
    85.044     0.920     0.200
    85.393     0.420     0.200
    85.393    -0.130     0.200
    85.579     4.363     0.200
    85.579     3.348     0.200
    85.579     1.047     0.200
    85.640     2.232     0.200
    85.640     4.685     0.200
    85.640     1.544     0.200
    85.973     2.590     0.200
    85.973     1.449     0.200
    86.209     2.752     0.200
    86.209     2.545     0.200
    86.577     2.756     0.200
    87.183     0.153     0.200
    87.395     2.753     0.200
    87.727     1.229     0.200
    87.732     0.507     0.200
    87.733     1.629     0.200
    87.733     1.922     0.200
    87.547     2.618     0.200
    87.942     2.581     0.200
    88.817     4.917     0.200
    88.817     0.671     0.200
    88.879     1.776     0.200
    89.284     1.275     0.200
    89.467     1.519     0.200
    90.678    -0.136     0.200
    92.900     1.326     0.200
    92.900     2.217     0.200
    95.068     4.066     0.200
    23.746     0.683     0.200
    43.885     1.123     0.200
    49.433    -0.061     0.200
    23.743     0.595     0.200
    43.887     0.805     0.200
    15.128     8.866     0.200
    15.128     7.923     0.200
    17.605     2.228     0.200
    17.730     1.628     0.200
    17.730     2.737     0.200
    18.549    -0.500     0.200
    18.693    -3.389     0.200
    18.693    -3.951     0.200
    18.693    -2.291     0.200
    20.028     0.594     0.200
    20.042     1.643     0.200
    20.069     1.427     0.200
    22.475     3.934     0.200
    23.083     0.295     0.200
    23.083     0.096     0.200
    23.083     2.186     0.200
    23.083     1.377     0.200
    23.096     0.164     0.200
    23.081     4.418     0.200
    23.643     2.264     0.200
    23.643     4.096     0.200
    23.643     0.236     0.200
    23.643     1.635     0.200
    23.675     1.484     0.200
    23.675    -0.355     0.200
    23.675     2.703     0.200
    23.757     1.590     0.200
    23.757     0.390     0.200
    23.757     2.261     0.200
    23.757     1.328     0.200
    23.770     1.713     0.200
    23.768     0.691     0.200
    23.921    -0.682     0.200
    23.921     1.576     0.200
    23.921     0.389     0.200
    24.123     1.490     0.200
    24.164     0.271     0.200
    24.823     0.858     0.200
    24.738     1.241     0.200
    24.823    -0.603     0.200
    24.823     0.968     0.200
    25.175     1.158     0.200
    26.349     1.321     0.200
    27.148     2.042     0.200
    27.177    -0.134     0.200
    27.177     1.456     0.200
    27.489    -0.642     0.200
    30.686    -0.738     0.200
    30.686     1.250     0.200
    30.686     3.363     0.200
    32.404     2.630     0.200
    32.513     3.880     0.200
    32.588     1.676     0.200
    32.588     2.066     0.200
    34.330     1.401     0.200
    34.467     1.604     0.200
    34.723     0.458     0.200
    37.830     0.824     0.200
    37.950     1.384     0.200
    37.966     1.495     0.200
    38.030     2.342     0.200
    38.249    -0.762     0.200
    38.309     1.133     0.200
    38.956     1.105     0.200
    38.963     0.971     0.200
    39.017     1.722     0.200
    39.168     1.095     0.200
    39.358     1.062     0.200
    39.435     0.775     0.200
    39.435     1.314     0.200
    39.545     0.988     0.200
    39.703    -0.774     0.200
    40.230     0.430     0.200
    40.273     0.590     0.200
    40.569     1.611     0.200
    40.732     0.776     0.200
    40.802     1.498     0.200
    40.912     1.096     0.200
    41.025     1.797     0.200
    41.991     1.258     0.200
    42.208     0.435     0.200
    42.230    -1.169     0.200
    42.360    -0.726     0.200
    42.510     1.751     0.200
    43.099     0.875     0.200
    43.215    -0.062     0.200
    43.300     0.860     0.200
    43.615     1.109     0.200
    43.908     0.419     0.200
    43.908     0.848     0.200
    43.918    -0.832     0.200
    44.050    -0.294     0.200
    44.142     0.275     0.200
    44.354     0.469     0.200
    46.130     1.068     0.200
    47.262     2.400     0.200
    47.298     1.441     0.200
    47.298     1.019     0.200
    47.298     3.077     0.200
    47.298    -0.282     0.200
    47.738     0.517     0.200
    49.369     1.119     0.200
    49.439    -0.197     0.200
    49.455    -0.178     0.200
    49.455     1.681     0.200
    49.455    -0.518     0.200
    49.467    -0.481     0.200
    49.467     0.847     0.200
    49.467    -0.711     0.200
    49.462    -1.569     0.200
    49.467    -0.512     0.200
    49.468    -0.516     0.200
    49.486    -0.352     0.200
    49.486    -0.654     0.200
    49.487    -0.361     0.200
    49.489    -0.576     0.200
    49.494    -0.714     0.200
    49.497    -1.041     0.200
    49.506    -0.707     0.200
    49.512    -0.656     0.200
    49.514    -0.368     0.200
    49.520    -0.515     0.200
    49.527    -0.165     0.200
    49.526    -0.164     0.200
    49.532    -0.703     0.200
    49.540    -0.164     0.200
    49.544    -0.398     0.200
    49.546    -0.510     0.200
    49.558    -0.401     0.200
    49.567    -0.371     0.200
    49.592     1.236     0.200
    49.592     1.162     0.200
    49.592    -0.363     0.200
    50.288    -0.555     0.200
    50.498    -0.541     0.200
    50.566    -0.361     0.200
    51.644    -0.460     0.200
    51.787    -1.324     0.200
    52.235    -0.060     0.200
    52.235    -0.361     0.200
    53.062    -0.684     0.200
    53.468    -0.478     0.200
    53.483    -0.581     0.200
    53.688    -1.489     0.200
    53.897     1.581     0.200
    54.237     0.000     0.200
    54.361     1.844     0.200
    54.361     0.191     0.200
    54.742     0.910     0.200
    54.993     2.312     0.200
    55.055     2.513     0.200
    55.265     2.345     0.200
    55.369     1.596     0.200
    55.369     2.096     0.200
    55.463     1.816     0.200
    55.463     2.375     0.200
    55.463    -0.184     0.200
    55.473     0.846     0.200
    55.473     2.084     0.200
    55.717     2.491     0.200
    55.760     1.681     0.200
    56.000     1.764     0.200
    56.000     1.975     0.200
    56.066     1.190     0.200
    56.066     0.971     0.200
    56.122     0.593     0.200
    56.130     1.635     0.200
    56.401     1.994     0.200
    56.401     2.295     0.200
    56.615     1.775     0.200
    56.647     2.007     0.200
    57.193     1.798     0.200
    57.333     2.310     0.200
    57.479     2.958     0.200
    57.549     0.563     0.200
    57.549     1.160     0.200
    57.549     1.961     0.200
    57.562     1.243     0.200
    57.562    -0.327     0.200
    57.717     1.046     0.200
    57.717     0.921     0.200
    57.717     1.882     0.200
    57.833     2.139     0.200
    58.244     2.146     0.200
    59.157     2.487     0.200
    59.435     0.659     0.200
    59.577     2.162     0.200
    59.819     1.858     0.200
    60.078    -1.474     0.200
    60.153     0.719     0.200
    60.770    -0.817     0.200
    60.902     0.987     0.200
    60.904     1.392     0.200
    60.904     2.303     0.200
    60.944     0.702     0.200
    62.593     0.903     0.200
    62.676     1.694     0.200
    62.952    -0.595     0.200
    63.655     1.002     0.200
    64.684     1.745     0.200
    65.884     1.101     0.200
    66.135     1.329     0.200
    70.752     1.555     0.200
    70.890     1.464     0.200
    72.422     0.746     0.200
    73.539     0.282     0.200
    73.540    -0.321     0.200
    73.540     0.936     0.200
    73.540     0.686     0.200
    73.938     1.690     0.200
    73.940     0.139     0.200
    73.940    -0.470     0.200
    74.365     0.245     0.200
    74.372     1.593     0.200
    74.372     2.394     0.200
    74.389     0.004     0.200
    74.425     1.875     0.200
    74.783     0.887     0.200
    74.783     0.215     0.200
    74.906     1.878     0.200
    74.975     0.909     0.200
    76.183     0.484     0.200
    77.231     1.263     0.200
    77.238     0.721     0.200
    77.238     0.053     0.200
    77.460    -0.121     0.200
    77.606    -0.039     0.200
    78.340     0.182     0.200
    78.921     0.283     0.200
    80.178     0.602     0.200
    80.592    -0.387     0.200
    80.831     0.746     0.200
    80.831     0.242     0.200
    82.520    -0.275     0.200
    82.521    -0.688     0.200
    83.641     1.025     0.200
    83.641    -0.385     0.200
    85.390     0.175     0.200
    85.402     0.832     0.200
    87.729     1.672     0.200
    87.729     2.011     0.200
    92.901     1.651     0.200
    15.143     5.897     0.200
    18.550    -1.874     0.200
    23.091     3.265     0.200
    23.664     2.129     0.200
    23.749     0.056     0.200
    23.749     1.455     0.200
    23.749     1.955     0.200
    23.759     1.291     0.200
    24.822     0.766     0.200
    27.135     1.458     0.200
    43.297     2.156     0.200
    43.893     1.381     0.200
    43.893     2.053     0.200
    49.440     1.214     0.200
    57.702     1.801     0.200
    73.536     1.729     0.200
    74.371     3.068     0.200
    23.637     2.322     0.200
    23.718     2.060     0.200
    23.732     1.473     0.200
    15.950     7.804     0.200
    16.222     4.501     0.200
    17.579     5.673     0.200
    19.742     0.341     0.200
    19.934     0.980     0.200
    22.021     6.636     0.200
    22.433     2.255     0.200
    22.723     3.358     0.200
    23.042     1.981     0.200
    23.117     1.492     0.200
    23.117     0.892     0.200
    23.117     2.069     0.200
    23.117     2.842     0.200
    23.647    -0.618     0.200
    23.647    -1.398     0.200
    23.647    -0.778     0.200
    23.723     0.903     0.200
    23.723     0.302     0.200
    23.723     1.002     0.200
    23.723     0.872     0.200
    23.734     0.305     0.200
    23.742     0.883     0.200
    23.888     0.098     0.200
    23.888     1.088     0.200
    23.888     0.298     0.200
    24.235     2.626     0.200
    24.866     0.873     0.200
    27.127     1.273     0.200
    27.155    -0.050     0.200
    27.181     1.615     0.200
    30.653     1.042     0.200
    30.653     0.242     0.200
    30.707     2.451     0.200
    31.983     0.325     0.200
    31.983    -0.275     0.200
    32.477     2.187     0.200
    32.557     0.895     0.200
    32.557     1.265     0.200
    34.434     1.425     0.200
    34.434     2.144     0.200
    34.702     0.643     0.200
    34.702     0.693     0.200
    35.388     0.383     0.200
    37.850     0.530     0.200
    38.018    -1.831     0.200
    38.527     1.123     0.200
    39.005     1.836     0.200
    39.399     0.682     0.200
    39.399     1.762     0.200
    39.587     1.654     0.200
    39.746     0.626     0.200
    40.273     1.627     0.200
    40.309     1.121     0.200
    40.612     1.760     0.200
    41.068     0.657     0.200
    41.537     1.569     0.200
    41.566     0.661     0.200
    42.250     1.795     0.200
    42.385     2.426     0.200
    42.553     1.394     0.200
    42.898     0.283     0.200
    43.087     1.650     0.200
    43.098     0.259     0.200
    43.208    -1.030     0.200
    43.343     1.710     0.200
    43.605     0.366     0.200
    43.907    -0.568     0.200
    43.910     0.428     0.200
    43.920     2.727     0.200
    43.920    -0.573     0.200
    44.040    -0.632     0.200
    45.470    -0.444     0.200
    47.280     1.899     0.200
    47.280     2.229     0.200
    47.280     0.889     0.200
    47.280    -0.172     0.200
    47.323     1.597     0.200
    47.444     2.456     0.200
    47.540     1.453     0.200
    47.735     1.659     0.200
    47.745     1.517     0.200
    49.374    -0.130     0.200
    49.432    -0.375     0.200
    49.448     0.103     0.200
    49.448     0.303     0.200
    49.448    -0.397     0.200
    49.460    -1.129     0.200
    49.460    -0.299     0.200
    49.460    -0.489     0.200
    49.460    -0.389     0.200
    49.460    -0.393     0.200
    49.478    -0.328     0.200
    49.479    -0.332     0.200
    49.479    -0.338     0.200
    49.507    -0.346     0.200
    49.524    -0.381     0.200
    49.550    -0.379     0.200
    49.598     0.571     0.200
    49.704     2.550     0.200
    50.012    -0.394     0.200
    50.281    -0.336     0.200
    50.492    -0.335     0.200
    50.561    -0.354     0.200
    50.668    -0.363     0.200
    51.636    -0.331     0.200
    52.227    -0.342     0.200
    53.475     1.286     0.200
    53.891     2.182     0.200
    54.355     1.336     0.200
    54.423     3.905     0.200
    54.783     0.109     0.200
    54.783     1.232     0.200
    54.826     1.920     0.200
    55.028     2.615     0.200
    55.038     1.540     0.200
    55.038     0.240     0.200
    55.038     0.688     0.200
    55.038     1.158     0.200
    55.050     0.254     0.200
    55.105    -0.045     0.200
    55.105     2.655     0.200
    55.191     1.644     0.200
    55.258    -0.630     0.200
    55.366     1.973     0.200
    55.366     2.412     0.200
    55.397     1.063     0.200
    55.402     1.453     0.200
    55.461     1.987     0.200
    55.461     0.718     0.200
    55.461     2.887     0.200
    55.461    -0.013     0.200
    55.471     0.748     0.200
    55.549     2.755     0.200
    55.712     3.883     0.200
    55.712     0.703     0.200
    55.756     2.567     0.200
    55.997     3.144     0.200
    55.997     1.574     0.200
    56.065     1.561     0.200
    56.065     2.141     0.200
    56.066     1.364     0.200
    56.122     0.149     0.200
    56.122     0.539     0.200
    56.122    -0.051     0.200
    56.127     3.109     0.200
    56.362     2.834     0.200
    56.399     1.072     0.200
    56.399     3.072     0.200
    56.399     1.981     0.200
    56.534     3.807     0.200
    56.613     3.347     0.200
    56.613     1.956     0.200
    56.640     1.913     0.200
    56.640     2.853     0.200
    57.053     1.321     0.200
    57.110     2.473     0.200
    57.194     1.081     0.200
    57.262     3.069     0.200
    57.328     2.424     0.200
    57.475     2.430     0.200
    57.477     2.726     0.200
    57.477     2.466     0.200
    57.490     2.046     0.200
    57.548     1.325     0.200
    57.548     1.676     0.200
    57.556     1.424     0.200
    57.556     2.364     0.200
    57.556     0.064     0.200
    57.715     0.296     0.200
    57.715     1.305     0.200
    57.831     1.979     0.200
    57.898     0.057     0.200
    58.156     1.517     0.200
    58.241     1.438     0.200
    58.679     1.539     0.200
    58.811     2.157     0.200
    58.815    -0.096     0.200
    58.956     2.542     0.200
    59.154     1.596     0.200
    59.154     1.860     0.200
    59.234     1.305     0.200
    59.234     1.555     0.200
    59.250     1.521     0.200
    59.455     0.872     0.200
    59.634     1.333     0.200
    59.786     0.993     0.200
    59.793     1.555     0.200
    59.817     0.860     0.200
    59.849     0.789     0.200
    60.008    -0.445     0.200
    60.031     1.448     0.200
    60.223     0.291     0.200
    60.390     2.484     0.200
    60.768     0.138     0.200
    60.903     2.040     0.200
    61.316     1.567     0.200
    61.971     0.893     0.200
    62.672     1.372     0.200
    62.924     0.515     0.200
    62.924     1.805     0.200
    62.924     0.194     0.200
    69.190     1.272     0.200
    69.190     0.436     0.200
    69.710     1.217     0.200
    70.133     1.096     0.200
    70.133     1.546     0.200
    71.286     0.859     0.200
    72.098     0.572     0.200
    72.425     0.749     0.200
    72.425     0.976     0.200
    73.582     1.208     0.200
    73.981     0.876     0.200
    73.981     0.715     0.200
    74.408     0.926     0.200
    74.415     1.587     0.200
    74.415     2.473     0.200
    74.432     0.985     0.200
    74.826     0.899     0.200
    74.913     0.997     0.200
    76.113     1.010     0.200
    76.247     0.644     0.200
    77.204     1.308     0.200
    77.243     1.333     0.200
    77.216     0.078     0.200
    77.254    -0.271     0.200
    77.324     1.785     0.200
    77.359     1.021     0.200
    77.502     1.748     0.200
    77.502     0.868     0.200
    77.560     2.005     0.200
    77.579     0.188     0.200
    77.649     1.048     0.200
    77.668     1.183     0.200
    77.713     0.771     0.200
    77.731     0.862     0.200
    77.735     1.601     0.200
    77.977     1.939     0.200
    80.633     0.815     0.200
    80.809     0.474     0.200
    81.696     1.877     0.200
    81.696     0.957     0.200
    82.871     0.997     0.200
    82.871     0.707     0.200
    83.680     0.544     0.200
    83.680     0.734     0.200
    85.429     0.015     0.200
    87.771     1.862     0.200
    89.322     0.488     0.200
    92.891     1.668     0.200
    23.743     0.229     0.200
    43.335     1.740     0.200
    18.681    -0.880     0.200
    23.633     1.107     0.200
    23.713     0.780     0.200
    23.713     1.131     0.200
    23.713     1.678     0.200
    31.963     0.288     0.200
    39.402    -2.743     0.200
    43.337     2.404     0.200
    43.889     1.173     0.200
    43.889     1.298     0.200
    49.427     1.217     0.200
    49.427     2.584     0.200
    49.427    -0.518     0.200
    57.694     1.990     0.200
    78.919    -2.307     0.200
    23.638     2.858     0.200
    23.716     1.967     0.200
    23.733     2.012     0.200
    43.897    -1.433     0.200
    15.156     3.946     0.200
    18.673    -1.599     0.200
    18.812    -0.785     0.200
    23.139     2.077     0.200
    23.139     2.271     0.200
    23.621    -0.256     0.200
    23.621     2.053     0.200
    23.701    -0.983     0.200
    23.701     0.867     0.200
    23.701     0.607     0.200
    23.716     1.609     0.200
    23.866     0.255     0.200
    24.152     3.675     0.200
    24.152     2.880     0.200
    27.098     1.533     0.200
    27.126    -1.126     0.200
    27.126    -0.376     0.200
    30.630    -0.744     0.200
    31.952    -0.286     0.200
    32.457     2.780     0.200
    34.274     0.606     0.200
    34.412     1.038     0.200
    34.673     0.633     0.200
    34.673     0.523     0.200
    37.792     0.880     0.200
    38.352     2.847     0.200
    39.209     1.957     0.200
    39.657     0.376     0.200
    40.954     1.713     0.200
    43.177     0.450     0.200
    43.344     1.701     0.200
    43.879    -0.116     0.200
    47.250     0.091     0.200
    49.416     0.701     0.200
    55.008     0.943     0.200
    57.684     0.730     0.200
    72.394     1.511     0.200
    73.580     2.218     0.200
    73.580     2.448     0.200
    74.418     3.066     0.200
    74.418     1.916     0.200
    18.562    -0.451     0.200
    20.289    -0.768     0.200
    21.084     3.060     0.200
    23.975    -1.163     0.200
    24.071     0.090     0.200
    24.129     1.330     0.200
    24.129     1.381     0.200
    24.129     2.033     0.200
    27.402    -0.523     0.200
    42.807     0.948     0.200
    42.807     1.397     0.200
    43.269     0.155     0.200
    43.858     0.063     0.200
    49.516    -0.505     0.200
    77.514    -0.764     0.200
    23.925     0.492     0.200
    27.207     0.777     0.200
    42.999     0.229     0.200
    18.881     0.926     0.200
    23.070     3.511     0.200
    23.785     1.637     0.200
    23.771     0.326     0.200
    27.165     0.657     0.200
    43.299    -0.152     0.200
    43.926     0.133     0.200
    49.473    -0.087     0.200
    23.095     1.968     0.200
    23.745     2.084     0.200
    23.755     1.490     0.200
    43.300     1.899     0.200
    43.891     0.137     0.200
    49.438     0.985     0.200
    54.738     0.694     0.200
    57.699     1.267     0.200
    73.539     1.099     0.200
    74.374     3.302     0.200
    18.683    -3.236     0.200
    23.735     1.538     0.200
    23.748     1.287     0.200
    27.127     1.242     0.200
    39.416     0.724     0.200
    43.895     0.818     0.200
    49.357     0.545     0.200
    49.438     0.688     0.200
    54.754     0.305     0.200
    57.702     1.318     0.200
    61.556     2.278     0.200
    18.816     0.934     0.200
    23.713     1.393     0.200
    23.717     1.971     0.200
    15.561     4.656     0.200
    15.995     4.246     0.200
    17.750     0.398     0.200
    18.483    -1.069     0.200
    18.625     0.770     0.200
    18.625     0.934     0.200
    18.625     1.094     0.200
    19.140     0.831     0.200
    20.284     1.165     0.200
    20.521     0.527     0.200
    20.521     2.687     0.200
    20.521     2.328     0.200
    20.758     3.193     0.200
    21.829     3.769     0.200
    22.416     4.987     0.200
    22.722     4.437     0.200
    22.724     2.958     0.200
    23.220     0.377     0.200
    23.220     0.867     0.200
    23.220     0.141     0.200
    23.232     0.346     0.200
    23.459     0.957     0.200
    23.459     1.367     0.200
    23.403     3.154     0.200
    23.554     0.382     0.200
    23.777     1.713     0.200
    23.625     1.302     0.200
    23.625     0.952     0.200
    23.786     2.112     0.200
    23.786     0.634     0.200
    24.660     0.346     0.200
    24.660    -1.263     0.200
    24.554     1.387     0.200
    25.521     1.618     0.200
    26.247     3.942     0.200
    26.864    -0.407     0.200
    26.892     0.517     0.200
    26.861     3.147     0.200
    27.105     2.680     0.200
    27.509     1.335     0.200
    27.719     3.303     0.200
    27.752     3.346     0.200
    28.806     3.406     0.200
    28.789     3.764     0.200
    29.382     0.187     0.200
    29.164     3.396     0.200
    30.328     1.508     0.200
    30.548     3.699     0.200
    30.548     3.068     0.200
    30.638     4.168     0.200
    31.643    -0.194     0.200
    31.643     0.043     0.200
    31.643     0.213     0.200
    32.418     1.937     0.200
    33.267     3.677     0.200
    34.329     2.637     0.200
    34.472     5.495     0.200
    34.805     0.669     0.200
    35.010     2.448     0.200
    36.135     3.382     0.200
    36.153     4.526     0.200
    36.135     4.012     0.200
    36.135     2.081     0.200
    36.616     1.641     0.200
    36.431     3.949     0.200
    36.718     3.803     0.200
    36.794     3.279     0.200
    36.794     4.150     0.200
    36.890     4.234     0.200
    36.980     4.769     0.200
    37.027     4.570     0.200
    37.382     0.082     0.200
    37.758     1.098     0.200
    37.785     0.086     0.200
    37.802     2.858     0.200
    37.802     1.499     0.200
    37.540     4.214     0.200
    37.550     4.231     0.200
    37.784     4.059     0.200
    38.951     1.348     0.200
    38.561     2.644     0.200
    39.225     2.354     0.200
    39.229     2.633     0.200
    39.229    -1.223     0.200
    39.397     1.278     0.200
    39.527     1.521     0.200
    39.886     1.055     0.200
    40.044     0.635     0.200
    39.959     1.890     0.200
    40.191     1.097     0.200
    40.567    -0.073     0.200
    40.274     3.559     0.200
    40.274     0.999     0.200
    40.750     2.313     0.200
    40.616     1.168     0.200
    40.616     2.371     0.200
    40.655     2.950     0.200
    40.669     2.131     0.200
    40.670     2.128     0.200
    41.141     2.943     0.200
    40.975     1.125     0.200
    41.437     0.969     0.200
    42.027     0.610     0.200
    42.290     1.032     0.200
    42.257     1.345     0.200
    42.714     1.282     0.200
    42.714     0.981     0.200
    42.740     2.372     0.200
    42.824     2.592     0.200
    43.007    -0.493     0.200
    43.108    -0.510     0.200
    43.108     0.076     0.200
    43.108     0.970     0.200
    43.120    -0.508     0.200
    43.232     1.025     0.200
    43.475    -0.177     0.200
    43.477    -0.470     0.200
    43.478    -0.878     0.200
    43.478    -0.343     0.200
    43.478    -0.003     0.200
    43.488    -0.182     0.200
    43.560     1.451     0.200
    43.741    -0.021     0.200
    43.911    -0.399     0.200
    43.989     0.589     0.200
    44.230     0.854     0.200
    44.593    -0.753     0.200
    44.542     1.339     0.200
    44.590     0.744     0.200
    44.744     2.503     0.200
    44.520     2.481     0.200
    44.984     0.802     0.200
    44.984    -0.569     0.200
    44.984     1.132     0.200
    45.028     1.013     0.200
    45.050     1.583     0.200
    45.237     0.830     0.200
    45.379     1.209     0.200
    45.937     1.007     0.200
    46.002     1.761     0.200
    46.458     2.003     0.200
    46.978     0.146     0.200
    46.983     3.551     0.200
    46.983     0.022     0.200
    46.983     0.561     0.200
    46.983     3.061     0.200
    47.028     0.987     0.200
    47.028     0.212     0.200
    47.028     2.013     0.200
    47.139     1.831     0.200
    47.330     1.965     0.200
    47.346     2.730     0.200
    47.386     0.116     0.200
    48.129     2.611     0.200
    48.129    -0.350     0.200
    48.549     1.606     0.200
    48.549     4.000     0.200
    48.667     3.589     0.200
    48.793     0.532     0.200
    48.930    -0.369     0.200
    49.067     0.253     0.200
    49.067     2.331     0.200
    49.067    -0.169     0.200
    49.067     0.131     0.200
    49.149    -0.102     0.200
    49.149    -0.400     0.200
    49.149     0.434     0.200
    49.248     1.555     0.200
    49.256     0.596     0.200
    49.276    -0.366     0.200
    49.515     2.707     0.200
    49.626    -0.042     0.200
    50.100    -0.045     0.200
    50.169    -0.068     0.200
    50.229    -0.129     0.200
    50.287    -0.365     0.200
    50.723     2.736     0.200
    50.714     1.204     0.200
    50.977     3.677     0.200
    51.523     1.359     0.200
    52.518     0.454     0.200
    52.732     4.282     0.200
    53.096     0.141     0.200
    53.499     1.151     0.200
    53.881     3.010     0.200
    54.469    -0.910     0.200
    54.316     4.609     0.200
    54.316    -0.006     0.200
    54.433     4.698     0.200
    54.726     0.118     0.200
    54.727     1.001     0.200
    54.727     1.726     0.200
    54.738     0.031     0.200
    54.902     4.092     0.200
    55.049     1.967     0.200
    55.049     2.278     0.200
    55.031     3.341     0.200
    55.719     0.121     0.200
    55.991     2.693     0.200
    55.991     2.003     0.200
    55.991     3.304     0.200
    56.110     2.760     0.200
    55.843     3.065     0.200
    56.258     3.252     0.200
    56.276     3.697     0.200
    57.065     3.546     0.200
    57.133     2.383     0.200
    57.133     1.373     0.200
    57.164     3.305     0.200
    57.302     1.106     0.200
    57.302     0.760     0.200
    57.787     2.270     0.200
    58.273     5.170     0.200
    58.360     0.798     0.200
    58.544     3.252     0.200
    58.472     0.367     0.200
    58.750     3.389     0.200
    58.750     3.045     0.200
    58.703     1.200     0.200
    58.838     3.464     0.200
    59.003     0.926     0.200
    59.048     2.645     0.200
    59.034     4.322     0.200
    59.167     3.110     0.200
    59.227     2.834     0.200
    59.240     2.428     0.200
    59.721    -0.408     0.200
    59.877     2.738     0.200
    60.488     3.594     0.200
    60.488     1.743     0.200
    60.508     0.601     0.200
    60.520     0.535     0.200
    60.751     2.274     0.200
    60.751     2.444     0.200
    61.110     1.625     0.200
    61.203     1.872     0.200
    61.236     1.444     0.200
    61.236     0.354     0.200
    61.555     2.212     0.200
    61.695     0.602     0.200
    62.398     1.136     0.200
    62.544     1.310     0.200
    62.597     0.562     0.200
    63.235     1.874     0.200
    63.515     0.097     0.200
    64.161     2.469     0.200
    64.396    -0.821     0.200
    65.004     2.348     0.200
    67.008     2.577     0.200
    68.762     0.643     0.200
    69.500     1.242     0.200
    69.913     0.428     0.200
    70.038     4.676     0.200
    70.432     0.647     0.200
    70.575     1.961     0.200
    70.575     1.310     0.200
    71.042     1.612     0.200
    71.167     2.708     0.200
    71.761    -1.106     0.200
    71.982    -0.006     0.200
    71.989    -0.045     0.200
    71.991     0.142     0.200
    71.991     0.722     0.200
    72.145     0.427     0.200
    72.250     0.693     0.200
    72.250     1.892     0.200
    72.690    -0.072     0.200
    72.690     2.598     0.200
    73.264     1.613     0.200
    73.316    -0.444     0.200
    73.317    -0.449     0.200
    73.317     0.178     0.200
    73.317     0.461     0.200
    73.688     0.340     0.200
    73.688     0.170     0.200
    73.688    -0.429     0.200
    73.728     1.790     0.200
    74.201    -0.336     0.200
    74.208     1.196     0.200
    74.208     1.432     0.200
    74.225     0.023     0.200
    74.585     1.840     0.200
    75.923     0.039     0.200
    77.683    -0.500     0.200
    78.709     1.454     0.200
    79.162     2.822     0.200
    79.162     1.661     0.200
    81.438     2.010     0.200
    81.438    -0.140     0.200
    81.275    -0.073     0.200
    81.275     0.189     0.200
    82.165     0.069     0.200
    82.533    -0.108     0.200
    83.321     0.509     0.200
    83.321     0.659     0.200
    83.321    -0.180     0.200
    83.886     1.124     0.200
    84.776     1.312     0.200
    85.079    -0.226     0.200
    85.382     0.780     0.200
    85.425     0.696     0.200
    86.086     4.161     0.200
    87.512    -0.403     0.200
    87.512     0.723     0.200
    87.512     1.594     0.200
    89.202     0.994     0.200
    43.126     2.447     0.200
    16.700     3.228     0.200
    18.496    -2.179     0.200
    18.496    -1.779     0.200
    18.613     1.155     0.200
    18.613     1.030     0.200
    18.613     1.700     0.200
    20.293     0.398     0.200
    20.291     0.480     0.200
    20.745     3.049     0.200
    22.150     1.379     0.200
    22.709     3.999     0.200
    23.233    -1.028     0.200
    23.233     0.222     0.200
    23.392     4.380     0.200
    23.447     2.575     0.200
    23.447     1.905     0.200
    23.543     3.086     0.200
    23.612     1.343     0.200
    23.612     3.251     0.200
    23.612     1.354     0.200
    23.789     3.522     0.200
    24.557     1.568     0.200
    24.673    -0.246     0.200
    26.854     3.437     0.200
    34.428     1.213     0.200
    34.428     0.992     0.200
    36.781     1.574     0.200
    37.043    -0.190     0.200
    37.384     1.062     0.200
    37.384     0.404     0.200
    38.128     0.508     0.200
    38.336     0.014     0.200
    38.549     1.020     0.200
    38.993     1.235     0.200
    39.410     0.767     0.200
    39.517     0.858     0.200
    40.419     1.226     0.200
    40.609     1.082     0.200
    40.604     2.747     0.200
    40.604     1.227     0.200
    40.705     0.095     0.200
    40.707     0.638     0.200
    40.870     1.344     0.200
    41.347     1.119     0.200
    41.629     1.327     0.200
    42.054     1.116     0.200
    42.302     1.222     0.200
    42.314     1.583     0.200
    42.763     1.337     0.200
    42.881     1.004     0.200
    43.120     1.238     0.200
    43.120    -0.068     0.200
    43.120     1.238     0.200
    43.473     1.206     0.200
    43.475     1.404     0.200
    43.475     2.204     0.200
    43.978     0.758     0.200
    44.460    -0.097     0.200
    45.040     0.293     0.200
    45.250     0.955     0.200
    45.503     1.261     0.200
    45.950     1.028     0.200
    48.963     1.070     0.200
    48.928     1.894     0.200
    49.061     2.285     0.200
    49.061     1.279     0.200
    49.148     1.150     0.200
    49.338     0.591     0.200
    49.711     1.503     0.200
    53.285     0.687     0.200
    54.481    -0.891     0.200
    54.481    -0.666     0.200
    56.381     0.189     0.200
    64.407    -0.337     0.200
    65.066     0.993     0.200
    65.686     0.925     0.200
    68.022     1.701     0.200
    68.450     0.925     0.200
    68.841     1.405     0.200
    68.938     1.420     0.200
    69.594     1.288     0.200
    71.988     0.478     0.200
    71.988     1.168     0.200
    73.329     0.418     0.200
    73.329     0.556     0.200
    74.221     1.464     0.200
    77.680     0.376     0.200
    77.680     0.491     0.200
    77.680     0.251     0.200
    81.271     0.759     0.200
    81.271     1.218     0.200
    23.540     1.901     0.200
    23.609     2.125     0.200
    26.851     1.441     0.200
    39.226     0.663     0.200
    40.603     2.794     0.200
    43.122     0.262     0.200
    43.473    -0.072     0.200
    48.926     1.585     0.200
    23.704     2.935     0.200
    15.169     4.637     0.200
    23.626     0.800     0.200
    18.553    -1.040     0.200
    18.807    -0.856     0.200
    18.807     2.165     0.200
    23.621     2.249     0.200
    23.716     1.328     0.200
    23.717     0.871     0.200
    23.717     1.648     0.200
    24.810    -0.107     0.200
    27.112    -0.853     0.200
    43.826     0.375     0.200
    49.377    -1.551     0.200
    15.574     2.659     0.200
    16.611     1.841     0.200
    17.811     0.395     0.200
    18.019     1.301     0.200
    18.396     3.059     0.200
    18.415     0.452     0.200
    18.545     1.149     0.200
    18.545     0.825     0.200
    18.574     0.102     0.200
    18.574     1.852     0.200
    18.574    -1.620     0.200
    19.128     0.620     0.200
    19.368     4.097     0.200
    20.317     3.373     0.200
    20.477     3.309     0.200
    20.515     3.102     0.200
    20.515     1.673     0.200
    20.515    -0.139     0.200
    21.420     0.614     0.200
    21.770     2.194     0.200
    22.376     4.203     0.200
    22.507     3.207     0.200
    22.661     1.377     0.200
    22.661     3.378     0.200
    22.670     3.104     0.200
    23.278     0.615     0.200
    23.278     2.213     0.200
    23.278     1.185     0.200
    23.406     1.402     0.200
    23.406     0.304     0.200
    23.406     1.113     0.200
    23.356     2.237     0.200
    23.502     1.399     0.200
    23.566     0.831     0.200
    23.566     1.080     0.200
    23.566     0.682     0.200
    23.728     0.632     0.200
    23.728    -0.469     0.200
    23.834     2.581     0.200
    23.834     1.843     0.200
    23.834     1.581     0.200
    24.720     0.202     0.200
    24.569     2.230     0.200
    24.701     1.025     0.200
    24.720     1.034     0.200
    24.651     3.232     0.200
    25.358     3.771     0.200
    25.460     1.370     0.200
    25.726     0.965     0.200
    26.210     2.580     0.200
    26.818     1.487     0.200
    26.803     1.526     0.200
    26.795     2.387     0.200
    26.795     1.976     0.200
    26.962     1.554     0.200
    27.449    -0.485     0.200
    27.660     1.431     0.200
    27.693     1.738     0.200
    28.084     1.641     0.200
    28.670     3.584     0.200
    28.748     1.331     0.200
    29.166     1.317     0.200
    29.379     1.546     0.200
    30.292     1.443     0.200
    30.490     1.737     0.200
    30.579     2.779     0.200
    30.856     1.189     0.200
    31.608     0.404     0.200
    31.608     0.244     0.200
    32.051     1.145     0.200
    32.120     2.132     0.200
    32.154     2.739     0.200
    32.362     0.920     0.200
    32.359     2.038     0.200
    32.782     2.939     0.200
    32.873     2.446     0.200
    33.264     1.229     0.200
    33.216     2.948     0.200
    33.383     1.287     0.200
    34.393     0.591     0.200
    34.418     2.697     0.200
    34.981    -0.375     0.200
    35.930     3.769     0.200
    36.257     1.475     0.200
    36.455     2.212     0.200
    36.991     1.346     0.200
    36.991    -0.584     0.200
    37.394     0.397     0.200
    37.394     0.096     0.200
    37.724     2.455     0.200
    38.173     1.091     0.200
    38.772     0.286     0.200
    38.841     0.465     0.200
    39.008     0.101     0.200
    39.184     1.592     0.200
    39.225    -0.169     0.200
    39.225     0.230     0.200
    39.517     0.523     0.200
    39.876     0.379     0.200
    39.952     0.307     0.200
    40.069     2.555     0.200
    40.222     2.477     0.200
    40.222     2.438     0.200
    40.374     0.256     0.200
    40.559    -0.073     0.200
    40.563     2.762     0.200
    40.563     1.262     0.200
    40.888     1.681     0.200
    40.911    -0.032     0.200
    41.427     0.138     0.200
    41.749     1.329     0.200
    41.941    -0.557     0.200
    42.201     1.626     0.200
    42.246     0.690     0.200
    42.706     0.112     0.200
    42.772     1.693     0.200
    42.772     1.021     0.200
    42.772     0.873     0.200
    42.796    -0.425     0.200
    42.759     0.729     0.200
    42.759    -0.432     0.200
    43.066    -0.126     0.200
    43.066     1.496     0.200
    43.166     1.186     0.200
    43.166     1.487     0.200
    43.166     1.237     0.200
    43.210     0.229     0.200
    43.290     0.115     0.200
    43.463    -0.037     0.200
    43.650     1.780     0.200
    43.929    -0.666     0.200
    43.929    -0.287     0.200
    44.051     0.452     0.200
    44.007     3.447     0.200
    44.289     1.447     0.200
    44.468     3.022     0.200
    44.727     0.820     0.200
    44.813     0.966     0.200
    44.867     0.541     0.200
    45.038     1.523     0.200
    45.038     0.875     0.200
    45.032     0.461     0.200
    45.032     0.723     0.200
    45.032    -0.378     0.200
    45.085     1.571     0.200
    45.298     1.590     0.200
    45.366     0.090     0.200
    45.321     3.287     0.200
    46.053     0.239     0.200
    46.432    -0.844     0.200
    46.891     1.263     0.200
    46.942     2.513     0.200
    46.942     1.377     0.200
    46.942     1.064     0.200
    46.986     1.394     0.200
    46.986     0.620     0.200
    47.116     0.287     0.200
    47.103     1.005     0.200
    47.300    -0.532     0.200
    47.338    -0.327     0.200
    47.410     1.213     0.200
    48.504     1.849     0.200
    48.504     3.677     0.200
    48.624     2.710     0.200
    48.920    -0.328     0.200
    49.039     0.185     0.200
    49.039     0.032     0.200
    49.051     0.182     0.200
    49.051     0.003     0.200
    49.141     0.152     0.200
    49.141    -0.172     0.200
    49.837     1.082     0.200
    49.938     0.971     0.200
    50.024     1.583     0.200
    50.259     0.340     0.200
    50.664     1.475     0.200
    50.706     0.516     0.200
    50.930     3.344     0.200
    51.094     3.435     0.200
    52.477     2.630     0.200
    52.689     3.321     0.200
    52.771     1.668     0.200
    52.766     1.089     0.200
    53.002     2.246     0.200
    53.068     1.554     0.200
    53.081     1.748     0.200
    53.116     2.106     0.200
    53.122     1.995     0.200
    53.205     1.829     0.200
    53.455     1.946     0.200
    53.458     1.271     0.200
    53.474     0.708     0.200
    53.474     1.134     0.200
    53.582     4.461     0.200
    53.626     2.105     0.200
    53.637     1.825     0.200
    53.637     1.052     0.200
    53.637     1.372     0.200
    53.669     1.766     0.200
    53.634     2.120     0.200
    53.837     1.990     0.200
    53.941     1.698     0.200
    54.000     2.786     0.200
    54.000     2.047     0.200
    54.196     0.086     0.200
    54.286     2.337     0.200
    54.286     1.950     0.200
    54.408     2.145     0.200
    54.522    -0.211     0.200
    54.522    -0.606     0.200
    54.565     2.151     0.200
    54.608     3.358     0.200
    54.671     0.626     0.200
    54.687     1.913     0.200
    54.687     2.064     0.200
    54.745     2.045     0.200
    54.752     1.780     0.200
    54.848     1.386     0.200
    54.860     2.780     0.200
    54.937     1.773     0.200
    54.937     1.343     0.200
    54.940     1.952     0.200
    54.981     2.351     0.200
    55.001     2.353     0.200
    55.029     1.118     0.200
    55.029     0.841     0.200
    55.029     2.341     0.200
    55.033     0.968     0.200
    55.040     0.910     0.200
    55.042     0.888     0.200
    55.056     1.200     0.200
    55.099     1.341     0.200
    55.127     1.389     0.200
    55.273     0.934     0.200
    55.292     1.535     0.200
    55.473     2.036     0.200
    55.472     2.445     0.200
    55.545    -1.146     0.200
    55.570     1.467     0.200
    55.628    -0.007     0.200
    55.628     0.606     0.200
    55.682     0.164     0.200
    55.682    -0.473     0.200
    55.682    -0.164     0.200
    55.698     0.843     0.200
    55.698     1.175     0.200
    55.745     1.833     0.200
    55.793     1.660     0.200
    55.793     0.137     0.200
    55.775     2.537     0.200
    55.775     0.838     0.200
    55.969     1.737     0.200
    56.052     1.602     0.200
    56.231     1.098     0.200
    56.217     1.606     0.200
    56.308     0.209     0.200
    56.308    -0.623     0.200
    56.308     0.018     0.200
    56.463     1.090     0.200
    56.463     1.328     0.200
    56.523     0.834     0.200
    56.754     1.055     0.200
    56.754     0.887     0.200
    56.754     0.511     0.200
    56.905     2.125     0.200
    57.062     0.431     0.200
    57.113     1.084     0.200
    57.139     1.318     0.200
    57.139     1.204     0.200
    57.191     1.409     0.200
    57.236     1.612     0.200
    57.266     0.505     0.200
    57.266     0.275     0.200
    57.281     1.308     0.200
    57.281     0.546     0.200
    57.284     1.329     0.200
    57.408     1.656     0.200
    57.396     0.998     0.200
    57.396     1.416     0.200
    57.480     0.693     0.200
    57.432     2.404     0.200
    57.432     1.154     0.200
    57.432     2.084     0.200
    57.688     2.549     0.200
    57.724     1.357     0.200
    57.762     1.717     0.200
    57.762     1.479     0.200
    57.810     1.540     0.200
    57.958     0.632     0.200
    58.355    -0.018     0.200
    58.355     0.209     0.200
    58.383     0.242     0.200
    58.429     1.617     0.200
    58.429     1.285     0.200
    58.585     1.927     0.200
    58.727     0.551     0.200
    58.785     1.396     0.200
    58.803     1.992     0.200
    58.894    -0.206     0.200
    58.957     3.017     0.200
    58.989     0.421     0.200
    59.145     1.511     0.200
    59.205     0.835     0.200
    59.202     1.911     0.200
    59.401     0.698     0.200
    59.490     1.127     0.200
    59.691     1.161     0.200
    59.707     0.226     0.200
    59.819    -0.668     0.200
    59.851     0.785     0.200
    59.899     1.315     0.200
    60.046     1.718     0.200
    60.460     0.736     0.200
    60.468     1.761     0.200
    60.468    -0.470     0.200
    60.850     1.149     0.200
    60.929     0.059     0.200
    60.968     1.009     0.200
    61.093     0.795     0.200
    61.536     0.549     0.200
    61.714    -1.543     0.200
    61.648     2.268     0.200
    61.836     0.933     0.200
    62.005     0.199     0.200
    62.018     1.825     0.200
    62.250    -0.515     0.200
    62.346     0.971     0.200
    62.382     2.030     0.200
    62.485     1.482     0.200
    62.504     1.909     0.200
    62.504     1.456     0.200
    62.529    -0.218     0.200
    62.565    -0.133     0.200
    63.043     1.736     0.200
    63.180     0.254     0.200
    63.280     1.002     0.200
    63.319     0.283     0.200
    63.373     1.508     0.200
    63.458     0.567     0.200
    63.652     1.224     0.200
    63.896     0.826     0.200
    63.896     0.627     0.200
    64.142    -0.713     0.200
    64.280     1.036     0.200
    64.446    -0.048     0.200
    64.446    -0.248     0.200
    64.446    -0.486     0.200
    64.526     2.944     0.200
    64.610     0.365     0.200
    66.063     1.553     0.200
    66.434     1.352     0.200
    66.885    -0.013     0.200
    66.912     1.231     0.200
    67.067     2.794     0.200
    68.045     0.906     0.200
    68.620     2.036     0.200
    68.704     1.031     0.200
    68.796     0.167     0.200
    68.887     2.020     0.200
    69.956    -0.637     0.200
    70.022     1.189     0.200
    70.222     1.122     0.200
    70.376     0.270     0.200
    70.634     2.495     0.200
    71.035     0.711     0.200
    71.155     1.005     0.200
    71.153     1.673     0.200
    71.561     1.069     0.200
    71.699     1.113     0.200
    71.820     0.936     0.200
    71.912    -0.466     0.200
    71.890     2.697     0.200
    71.977     1.196     0.200
    71.977     0.418     0.200
    72.203     2.841     0.200
    72.236     0.646     0.200
    72.236     1.119     0.200
    72.283     1.813     0.200
    72.527     1.388     0.200
    72.678     0.955     0.200
    72.678     1.166     0.200
    72.721     1.090     0.200
    72.967     0.694     0.200
    73.328     0.959     0.200
    73.373     1.092     0.200
    73.477     1.101     0.200
    73.522     1.277     0.200
    73.741     1.040     0.200
    73.741     0.309     0.200
    73.741     0.629     0.200
    73.785     2.392     0.200
    74.044     0.758     0.200
    74.098     0.768     0.200
    74.260     2.596     0.200
    74.268     2.901     0.200
    74.268     1.373     0.200
    74.618    -1.344     0.200
    74.449     1.267     0.200
    74.495     1.260     0.200
    74.495     0.842     0.200
    74.581     1.402     0.200
    74.643     2.483     0.200
    74.626     0.906     0.200
    74.689     0.750     0.200
    74.887     1.236     0.200
    74.821     1.510     0.200
    75.086     1.295     0.200
    75.182     1.245     0.200
    75.182     1.405     0.200
    75.299     1.290     0.200
    75.360     1.113     0.200
    75.381     1.189     0.200
    75.603     1.809     0.200
    75.974     0.669     0.200
    77.282     2.399     0.200
    77.660     0.207     0.200
    77.660     0.766     0.200
    77.668     0.666     0.200
    77.668     0.564     0.200
    77.983    -0.888     0.200
    77.983     0.112     0.200
    77.911     1.884     0.200
    79.221     2.185     0.200
    79.207     1.013     0.200
    79.207     0.392     0.200
    80.855     1.088     0.200
    80.901     1.622     0.200
    81.257     0.817     0.200
    81.258     0.761     0.200
    81.258     0.261     0.200
    81.264     0.483     0.200
    81.495     2.686     0.200
    82.207     0.471     0.200
    82.207    -0.299     0.200
    82.386     1.991     0.200
    82.583     0.443     0.200
    82.995     0.332     0.200
    83.368     1.279     0.200
    83.368     1.049     0.200
    83.368     0.779     0.200
    83.940     1.895     0.200
    84.832     2.071     0.200
    85.127     1.278     0.200
    85.127     0.118     0.200
    85.127     0.939     0.200
    85.433     1.221     0.200
    85.470     1.077     0.200
    85.449     2.623     0.200
    85.449     0.432     0.200
    86.025     1.946     0.200
    86.301     0.955     0.200
    86.414     0.958     0.200
    87.026     0.264     0.200
    87.563     1.862     0.200
    87.568     1.640     0.200
    87.569     1.535     0.200
    87.595     0.421     0.200
    87.595     0.261     0.200
    87.787     0.362     0.200
    88.548     1.315     0.200
    89.139     2.686     0.200
    90.557    -0.143     0.200
    90.596     0.969     0.200
    90.596     0.746     0.200
    91.124     1.875     0.200
    94.027     3.080     0.200
    34.393     0.399     0.200
    45.995     1.245     0.200
    42.346     2.206     0.200
    54.687     1.693     0.200
    40.102     1.193     0.200
    22.670     1.299     0.200
    48.915     0.825     0.200
    48.956     0.058     0.200
    51.387     2.415     0.200
    14.444     4.225     0.200
    15.452     4.011     0.200
    17.686     1.683     0.200
    19.676     2.712     0.200
    19.912     0.783     0.200
    22.039     1.845     0.200
    22.039     1.407     0.200
    24.113     2.365     0.200
    24.094     1.443     0.200
    24.728     1.660     0.200
    24.803     3.471     0.200
    24.803     2.471     0.200
    24.803     0.072     0.200
    24.803     3.772     0.200
    24.823     0.770     0.200
    34.231    -0.998     0.200
    35.747     1.063     0.200
    36.649     0.793     0.200
    37.649     1.145     0.200
    38.277     0.686     0.200
    39.849     0.344     0.200
    40.596     0.941     0.200
    40.872     4.126     0.200
    41.123     0.348     0.200
    42.637     0.614     0.200
    42.637     0.977     0.200
    42.637     0.614     0.200
    43.448     0.494     0.200
    43.635     0.952     0.200
    44.300    -0.432     0.200
    44.633    -0.944     0.200
    44.633     0.076     0.200
    44.633     0.704     0.200
    44.860     0.400     0.200
    44.948     0.613     0.200
    48.296     1.047     0.200
    48.555    -0.452     0.200
    50.037    -0.177     0.200
    50.332     0.386     0.200
    56.038     2.123     0.200
    56.260     0.814     0.200
    58.509     0.539     0.200
    58.509     1.086     0.200
    59.402    -0.182     0.200
    72.933     0.266     0.200
    73.648     1.970     0.200
    76.799    -0.130     0.200
    76.957    -0.390     0.200
    76.965     0.293     0.200
    80.575     0.617     0.200
    35.747     1.063     0.200
    45.468     0.985     0.200
    41.907     1.078     0.200
    56.038     1.373     0.200
    39.556     0.814     0.200
    18.513     0.802     0.200
    18.513     0.052     0.200
    43.150     0.467     0.200
    18.221     1.194     0.200
    43.517     1.619     0.200
    54.927    -0.306     0.200
    54.927    -0.431     0.200
    72.320     1.272     0.200
    18.633    -0.172     0.200
    18.625    -3.038     0.200
    18.621     1.441     0.200
    18.621     1.193     0.200
    18.810     2.434     0.200
    18.810     1.002     0.200
    20.096     2.215     0.200
    20.096     3.246     0.200
    23.351    -0.938     0.200
    23.351     0.531     0.200
    23.423     0.413     0.200
    23.423     1.743     0.200
    23.490     1.377     0.200
    23.490     1.207     0.200
    23.518     0.618     0.200
    25.062    -0.548     0.200
    26.918     1.798     0.200
    26.947     2.983     0.200
    30.419     1.065     0.200
    30.849    -0.162     0.200
    31.802     1.573     0.200
    37.046     2.096     0.200
    37.830    -0.430     0.200
    39.573     2.031     0.200
    39.610     0.580     0.200
    41.224     0.078     0.200
    43.529    -0.492     0.200
    43.795     1.027     0.200
    43.795    -0.104     0.200
    47.082     0.845     0.200
    49.273     0.035     0.200
    49.289     0.106     0.200
    49.301     0.406     0.200
    50.371    -0.454     0.200
    50.392    -0.400     0.200
    54.846     0.753     0.200
    54.936    -0.266     0.200
    54.976     0.247     0.200
    57.414     0.616     0.200
    57.580     0.822     0.200
    60.770     1.476     0.200
    70.644     0.962     0.200
    71.716     2.176     0.200
    72.309     1.043     0.200
    73.758     1.163     0.200
    74.142     2.018     0.200
    74.611     1.718     0.200
    74.611     0.428     0.200
    76.395     0.650     0.200
    76.560     2.026     0.200
    77.224     0.324     0.200
    80.812     0.391     0.200
    85.562     0.619     0.200
    87.949     1.261     0.200
    18.233     0.794     0.200
    18.633    -1.893     0.200
    18.646    -0.108     0.200
    18.646     1.052     0.200
    18.646     0.737     0.200
    18.784    -0.726     0.200
    18.784     0.860     0.200
    19.227     2.605     0.200
    20.089     0.511     0.200
    20.091     1.728     0.200
    20.091    -0.375     0.200
    20.091    -0.195     0.200
    23.324     0.830     0.200
    23.324     1.362     0.200
    23.324     0.516     0.200
    23.449     1.797     0.200
    23.449     1.356     0.200
    23.449     0.717     0.200
    23.517     1.306     0.200
    23.517     0.564     0.200
    23.543     0.362     0.200
    23.884    -0.086     0.200
    24.225     2.517     0.200
    25.039     1.910     0.200
    26.942     0.602     0.200
    26.971     1.914     0.200
    26.971     0.744     0.200
    30.446     2.870     0.200
    30.446     1.501     0.200
    31.204     2.451     0.200
    31.822     0.740     0.200
    31.822     0.109     0.200
    32.353     0.971     0.200
    32.407     1.276     0.200
    33.403     1.879     0.200
    34.518     0.696     0.200
    37.831    -0.107     0.200
    38.515    -0.269     0.200
    38.700     1.555     0.200
    39.157     1.565     0.200
    39.333     1.504     0.200
    39.366     1.437     0.200
    39.552     1.526     0.200
    39.618    -0.504     0.200
    39.764     1.380     0.200
    40.231     0.874     0.200
    42.786     1.016     0.200
    43.238     1.894     0.200
    43.507     0.354     0.200
    43.507     0.694     0.200
    43.807     0.916     0.200
    43.807    -0.041     0.200
    44.378    -0.694     0.200
    44.606     0.255     0.200
    45.421     2.496     0.200
    47.105     3.120     0.200
    47.105     1.989     0.200
    47.146     1.609     0.200
    49.284     0.001     0.200
    49.307     0.723     0.200
    49.307    -0.246     0.200
    49.319     0.660     0.200
    49.319    -0.170     0.200
    49.515    -0.173     0.200
    50.353    -0.393     0.200
    52.630     3.903     0.200
    52.914     1.397     0.200
    53.333     0.415     0.200
    53.697     2.378     0.200
    53.859     2.772     0.200
    54.218     2.135     0.200
    54.293     5.195     0.200
    54.868     0.402     0.200
    54.918    -0.371     0.200
    54.985     3.325     0.200
    55.118     1.535     0.200
    55.242     1.234     0.200
    55.339     1.884     0.200
    55.340     1.804     0.200
    55.405     1.863     0.200
    55.579     2.742     0.200
    55.720     1.099     0.200
    56.003     1.105     0.200
    56.490     0.541     0.200
    56.772     1.438     0.200
    56.933     1.593     0.200
    57.364    -0.273     0.200
    57.428     1.709     0.200
    57.595     0.886     0.200
    57.595     0.331     0.200
    57.713     1.682     0.200
    59.027    -0.075     0.200
    59.110     2.125     0.200
    59.129     0.880     0.200
    60.784     2.342     0.200
    60.784     1.983     0.200
    60.819     0.628     0.200
    61.287     1.759     0.200
    62.643    -0.791     0.200
    67.773     0.708     0.200
    68.711     1.048     0.200
    68.946     1.005     0.200
    69.249     0.299     0.200
    69.249    -0.194     0.200
    70.444     1.488     0.200
    72.322     0.502     0.200
    73.736     0.908     0.200
    74.119     1.857     0.200
    74.588     1.966     0.200
    74.588     1.341     0.200
    77.224     0.623     0.200
    80.813     1.003     0.200
    83.792     0.330     0.200
    85.546     0.192     0.200
    87.928     1.485     0.200
    87.928     0.987     0.200
    20.085     0.736     0.200
    54.918    -2.406     0.200
    18.806     1.390     0.200
    23.510     1.224     0.200
    23.543     0.757     0.200
    26.949     2.001     0.200
    43.832     0.169     0.200
    16.935     1.257     0.200
    19.796     2.666     0.200
    19.796     0.291     0.200
    20.282     2.667     0.200
    20.914    -0.663     0.200
    23.116     0.820     0.200
    24.425     1.281     0.200
    24.427    -0.326     0.200
    24.683     1.535     0.200
    25.011     1.048     0.200
    25.011     0.573     0.200
    25.168     1.657     0.200
    25.168     1.018     0.200
    27.896     1.013     0.200
    27.922     0.677     0.200
    31.921     2.577     0.200
    32.063     2.871     0.200
    32.400     0.774     0.200
    35.582     1.640     0.200
    35.700     2.207     0.200
    36.936     0.603     0.200
    37.600     2.025     0.200
    38.731     1.601     0.200
    39.163     2.807     0.200
    39.163     0.632     0.200
    41.607     1.348     0.200
    41.948     2.765     0.200
    42.020     1.964     0.200
    42.020     0.264     0.200
    43.311     2.193     0.200
    43.358     3.105     0.200
    43.692     0.044     0.200
    45.402     0.991     0.200
    47.888     1.768     0.200
    47.888     2.228     0.200
    49.027     2.916     0.200
    49.027     4.941     0.200
    49.030    -0.069     0.200
    49.195    -0.271     0.200
    49.616    -0.486     0.200
    49.616    -0.310     0.200
    49.628    -0.042     0.200
    53.081    -0.486     0.200
    53.213     0.543     0.200
    54.466     2.305     0.200
    54.471     1.634     0.200
    54.471     1.224     0.200
    54.471     0.334     0.200
    54.914     1.757     0.200
    54.914     0.427     0.200
    54.929     1.888     0.200
    55.351     1.121     0.200
    55.411     1.299     0.200
    55.410     0.943     0.200
    55.434     1.248     0.200
    55.434     0.967     0.200
    55.442     1.252     0.200
    55.574     1.260     0.200
    55.574     0.210     0.200
    55.549     1.145     0.200
    55.784     2.680     0.200
    55.784     0.152     0.200
    55.784     0.843     0.200
    56.106     0.583     0.200
    56.355     1.584     0.200
    56.379     0.138     0.200
    56.412     0.862     0.200
    56.855     1.022     0.200
    56.855     0.631     0.200
    57.475     1.231     0.200
    57.645     0.533     0.200
    57.651     0.905     0.200
    57.980     0.483     0.200
    58.323     0.481     0.200
    58.418     1.442     0.200
    58.599     2.153     0.200
    62.759     0.263     0.200
    69.550     2.300     0.200
    71.850     0.945     0.200
    72.263     1.078     0.200
    72.685     1.728     0.200
    75.600    -0.178     0.200
    75.600    -0.768     0.200
    77.228     0.221     0.200
    78.238     0.121     0.200
    78.238    -0.504     0.200
    81.854    -0.017     0.200
    86.037     1.685     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   105.435     1.489     0.200
   137.651     1.107     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    56.018    57.331     0.200
    59.155    50.236     0.200
    30.385   180.390     0.200
    29.166   186.083     0.200
    36.735   139.078     0.200
    43.101   111.217     0.200
    49.898    80.913     0.200
    78.095     8.603     0.200
    89.186     1.827     0.200
    31.876   166.456     0.200
    42.289   114.060     0.200
    43.146   108.210     0.200
    43.146   112.109     0.200
    47.330    87.694     0.200
    47.776    85.427     0.200
    47.781    85.390     0.200
    54.030    69.852     0.200
    68.150    28.727     0.200
    30.040   182.183     0.200
    32.257   164.640     0.200
    43.079   110.679     0.200
    43.141   108.681     0.200
    47.494    95.149     0.200
    49.072    84.467     0.200
    49.137    81.467     0.200
    52.176    75.537     0.200
    52.378    71.041     0.200
    54.991    64.890     0.200
    55.939    59.072     0.200
    57.059    55.094     0.200
    58.550    52.622     0.200
    59.279    50.228     0.200
    59.426    45.540     0.200
    59.438    43.460     0.200
    59.710    50.581     0.200
    59.745    49.342     0.200
    67.864    27.341     0.200
    83.759     5.584     0.200
    99.435     0.940     0.200
    57.503    57.386     0.200
    16.337   294.273     0.200
    31.863   170.802     0.200
    14.100   321.535     0.200
    31.857   166.688     0.200
    49.119    79.449     0.200
    81.308     6.554     0.200
    16.083   297.581     0.200
    47.653    89.797     0.200
    24.055   221.369     0.200
    40.243   124.792     0.200
    47.791    86.641     0.200
    39.814   125.934     0.200
    48.521    85.775     0.200
    48.621    87.237     0.200
    49.641    82.898     0.200
    43.282   109.389     0.200
    43.274   110.504     0.200
    31.991   167.085     0.200
    43.166   112.468     0.200
    46.343    97.135     0.200
    43.281   107.765     0.200
    43.777   107.612     0.200
    31.994   167.303     0.200
    38.012   133.999     0.200
    40.347   126.434     0.200
    42.359   115.147     0.200
    45.391    96.567     0.200
    46.280    95.253     0.200
    47.544    86.905     0.200
    48.736    87.060     0.200
    60.096    48.344     0.200
    43.215   108.938     0.200
    60.078    45.526     0.200
    60.135    46.074     0.200
    31.952   167.814     0.200
    43.269   107.456     0.200
    37.570   135.759     0.200
    46.002    97.962     0.200
    49.067    83.231     0.200
    45.094   101.186     0.200
    37.561   137.776     0.200
    42.796   111.775     0.200
    43.463   107.905     0.200
    45.059   102.507     0.200
    49.039    83.583     0.200
    54.687    64.365     0.200
    55.628    59.524     0.200
    55.682    59.836     0.200
    56.714    57.420     0.200
    56.974    56.254     0.200
    57.281    55.417     0.200
    57.281    55.816     0.200
    57.588    54.290     0.200
    57.653    54.513     0.200
    59.691    48.930     0.200
    59.899    47.448     0.200
    54.687    64.744     0.200
    23.517   225.914     0.200
    23.543   224.946     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
