#!/bin/bash
gmt begin chara1.31_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times chara1.31'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   324.128
    25.500   328.671
    26.000   333.203
    26.500   337.724
    27.000   342.233
    27.500   346.725
    28.000   351.197
    28.500   355.654
    29.000   360.099
    29.500   364.536
    30.000   368.964
    30.500   373.385
    31.000   377.798
    31.500   382.204
    32.000   386.601
    32.500   390.989
    33.000   395.366
    33.500   399.731
    34.000   404.082
    34.500   408.418
    35.000   412.738
    35.500   417.044
    36.000   421.334
    36.500   425.610
    37.000   429.870
    37.500   434.114
    38.000   438.342
    38.500   442.554
    39.000   446.750
    39.500   450.928
    40.000   455.090
    40.500   459.234
    41.000   463.362
    41.500   467.472
    42.000   471.566
    42.500   475.642
    43.000   479.701
    43.500   483.742
    44.000   487.765
    44.500   491.771
    45.000   495.759
    45.500   499.729
    46.000   503.680
    46.500   507.614
    47.000   511.530
    47.500   515.428
    48.000   519.307
    48.500   523.169
    49.000   527.012
    49.500   530.837
    50.000   534.644
    50.500   538.433
    51.000   542.203
    51.500   545.955
    52.000   549.688
    52.500   553.405
    53.000   557.103
    53.500   560.783
    54.000   564.446
    54.500   568.090
    55.000   571.715
    55.500   575.322
    56.000   578.911
    56.500   582.481
    57.000   586.032
    57.500   589.566
    58.000   593.082
    58.500   596.579
    59.000   600.058
    59.500   603.519
    60.000   606.962
    60.500   610.386
    61.000   613.792
    61.500   617.179
    62.000   620.548
    62.500   623.899
    63.000   627.233
    63.500   630.548
    64.000   633.845
    64.500   637.125
    65.000   640.386
    65.500   643.630
    66.000   646.855
    66.500   650.063
    67.000   653.252
    67.500   656.423
    68.000   659.577
    68.500   662.711
    69.000   665.828
    69.500   668.927
    70.000   672.007
    70.500   675.070
    71.000   678.114
    71.500   681.140
    72.000   684.148
    72.500   687.138
    73.000   690.109
    73.500   693.062
    74.000   695.996
    74.500   698.911
    75.000   701.808
    75.500   704.686
    76.000   707.545
    76.500   710.387
    77.000   713.210
    77.500   716.016
    78.000   718.803
    78.500   721.572
    79.000   724.323
    79.500   727.056
    80.000   729.770
    80.500   732.465
    81.000   735.140
    81.500   737.796
    82.000   740.433
    82.500   743.052
    83.000   745.651
    83.500   748.232
    84.000   750.794
    84.500   753.335
    85.000   755.855
    85.500   758.355
    86.000   760.837
    86.500   763.302
    87.000   765.748
    87.500   768.172
    88.000   770.561
    88.500   772.927
    89.000   775.282
    89.500   777.628
    90.000   779.965
    90.500   782.297
    91.000   784.622
    91.500   786.941
    92.000   789.256
    92.500   791.566
    93.000   793.874
    93.500   796.178
    94.000   798.478
    94.500   800.773
    95.000   803.064
    95.500   805.348
    96.000   807.626
    96.500   809.898
    97.000   812.163
    97.500   814.422
    98.000   816.673
    98.500   818.918
    99.000   821.154
    99.500   823.383
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.405
   116.000  1123.368
   116.500  1124.330
   117.000  1125.292
   117.500  1126.254
   118.000  1127.216
   118.500  1128.177
   119.000  1129.139
   119.500  1130.100
   120.000  1131.062
   120.500  1132.023
   121.000  1132.984
   121.500  1133.944
   122.000  1134.904
   122.500  1135.864
   123.000  1136.824
   123.500  1137.783
   124.000  1138.742
   124.500  1139.700
   125.000  1140.657
   125.500  1141.615
   126.000  1142.571
   126.500  1143.527
   127.000  1144.482
   127.500  1145.437
   128.000  1146.390
   128.500  1147.343
   129.000  1148.295
   129.500  1149.246
   130.000  1150.196
   130.500  1151.145
   131.000  1152.092
   131.500  1153.038
   132.000  1153.984
   132.500  1154.927
   133.000  1155.869
   133.500  1156.810
   134.000  1157.749
   134.500  1158.686
   135.000  1159.621
   135.500  1160.554
   136.000  1161.485
   136.500  1162.414
   137.000  1163.341
   137.500  1164.265
   138.000  1165.186
   138.500  1166.105
   139.000  1167.021
   139.500  1167.933
   140.000  1168.843
   140.500  1169.749
   141.000  1170.651
   141.500  1171.550
   142.000  1172.445
   142.500  1173.335
   143.000  1174.221
   143.500  1175.103
   144.000  1175.979
   144.500  1176.850
   145.000  1177.716
   145.500  1178.576
   146.000  1179.429
   146.500  1180.277
   147.000  1181.118
   147.500  1181.952
   148.000  1182.780
   148.500  1183.599
   149.000  1184.411
   149.500  1185.213
   150.000  1186.006
   150.500  1186.790
   151.000  1187.563
   151.500  1188.327
   152.000  1189.080
   152.500  1189.824
   153.000  1190.557
   153.500  1191.280
   154.000  1191.993
   154.500  1192.694
   155.000  1193.385
   155.500  1194.063
   156.000  1194.731
   156.500  1195.386
   157.000  1196.030
   157.500  1196.661
   158.000  1197.281
   158.500  1197.887
   159.000  1198.482
   159.500  1199.063
   160.000  1199.632
   160.500  1200.187
   161.000  1200.730
   161.500  1201.259
   162.000  1201.775
   162.500  1202.278
   163.000  1202.768
   163.500  1203.244
   164.000  1203.706
   164.500  1204.154
   165.000  1204.589
   165.500  1205.010
   166.000  1205.417
   166.500  1205.810
   167.000  1206.189
   167.500  1206.554
   168.000  1206.905
   168.500  1207.242
   169.000  1207.565
   169.500  1207.874
   170.000  1208.168
   170.500  1208.449
   171.000  1208.715
   171.500  1208.967
   172.000  1209.204
   172.500  1209.427
   173.000  1209.636
   173.500  1209.831
   174.000  1210.011
   174.500  1210.177
   175.000  1210.329
   175.500  1210.466
   176.000  1210.588
   176.500  1210.697
   177.000  1210.790
   177.500  1210.870
   178.000  1210.935
   178.500  1210.985
   179.000  1211.021
   179.500  1211.043
   180.000  1211.051
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   993.349
     1.000   993.357
     1.500   993.371
     2.000   993.391
     2.500   993.416
     3.000   993.447
     3.500   993.483
     4.000   993.525
     4.500   993.573
     5.000   993.626
     5.500   993.685
     6.000   993.749
     6.500   993.819
     7.000   993.894
     7.500   993.975
     8.000   994.062
     8.500   994.154
     9.000   994.252
     9.500   994.355
    10.000   994.464
    10.500   994.579
    11.000   994.699
    11.500   994.824
    12.000   994.955
    12.500   995.092
    13.000   995.234
    13.500   995.382
    14.000   995.535
    14.500   995.694
    15.000   995.858
    15.500   996.028
    16.000   996.203
    16.500   996.384
    17.000   996.570
    17.500   996.762
    18.000   996.959
    18.500   997.162
    19.000   997.370
    19.500   997.583
    20.000   997.802
    20.500   998.027
    21.000   998.257
    21.500   998.492
    22.000   998.733
    22.500   998.979
    23.000   999.231
    23.500   999.488
    24.000   999.750
    24.500  1000.018
    25.000  1000.291
    25.500  1000.570
    26.000  1000.853
    26.500  1001.143
    27.000  1001.437
    27.500  1001.737
    28.000  1002.042
    28.500  1002.352
    29.000  1002.668
    29.500  1002.989
    30.000  1003.315
    30.500  1003.647
    31.000  1003.983
    31.500  1004.325
    32.000  1004.672
    32.500  1005.025
    33.000  1005.382
    33.500  1005.745
    34.000  1006.113
    34.500  1006.486
    35.000  1006.864
    35.500  1007.248
    36.000  1007.636
    36.500  1008.030
    37.000  1008.429
    37.500  1008.832
    38.000  1009.241
    38.500  1009.655
    39.000  1010.074
    39.500  1010.498
    40.000  1010.927
    40.500  1011.361
    41.000  1011.800
    41.500  1012.244
    42.000  1012.693
    42.500  1013.147
    43.000  1013.605
    43.500  1014.069
    44.000  1014.538
    44.500  1015.011
    45.000  1015.489
    45.500  1015.973
    46.000  1016.461
    46.500  1016.953
    47.000  1017.451
    47.500  1017.953
    48.000  1018.461
    48.500  1018.972
    49.000  1019.489
    49.500  1020.010
    50.000  1020.537
    50.500  1021.067
    51.000  1021.603
    51.500  1022.143
    52.000  1022.688
    52.500  1023.237
    53.000  1023.791
    53.500  1024.349
    54.000  1024.912
    54.500  1025.480
    55.000  1026.052
    55.500  1026.629
    56.000  1027.210
    56.500  1027.796
    57.000  1028.386
    57.500  1028.980
    58.000  1029.579
    58.500  1030.182
    59.000  1030.790
    59.500  1031.402
    60.000  1032.018
    60.500  1032.639
    61.000  1033.264
    61.500  1033.893
    62.000  1034.527
    62.500  1035.165
    63.000  1035.807
    63.500  1036.453
    64.000  1037.104
    64.500  1037.758
    65.000  1038.417
    65.500  1039.080
    66.000  1039.747
    66.500  1040.418
    67.000  1041.093
    67.500  1041.772
    68.000  1042.455
    68.500  1043.142
    69.000  1043.833
    69.500  1044.528
    70.000  1045.227
    70.500  1045.930
    71.000  1046.637
    71.500  1047.348
    72.000  1048.062
    72.500  1048.781
    73.000  1049.503
    73.500  1050.229
    74.000  1050.959
    74.500  1051.692
    75.000  1052.429
    75.500  1053.170
    76.000  1053.915
    76.500  1054.663
    77.000  1055.415
    77.500  1056.171
    78.000  1056.930
    78.500  1057.692
    79.000  1058.458
    79.500  1059.228
    80.000  1060.002
    80.500  1060.778
    81.000  1061.558
    81.500  1062.342
    82.000  1063.129
    82.500  1063.919
    83.000  1064.713
    83.500  1065.510
    84.000  1066.311
    84.500  1067.115
    85.000  1067.922
    85.500  1068.732
    86.000  1069.545
    86.500  1070.362
    87.000  1071.182
    87.500  1072.005
    88.000  1072.831
    88.500  1073.660
    89.000  1074.493
    89.500  1075.328
    90.000  1076.167
    90.500  1077.008
    91.000  1077.852
    91.500  1078.700
    92.000  1079.550
    92.500  1080.404
    93.000  1081.260
    93.500  1082.119
    94.000  1082.981
    94.500  1083.846
    95.000  1084.713
    95.500  1085.584
    96.000  1086.457
    96.500  1087.333
    97.000  1088.211
    97.500  1089.093
    98.000  1089.977
    98.500  1090.863
    99.000  1091.752
    99.500  1092.644
   100.000  1093.538
   100.500  1094.435
   101.000  1095.335
   101.500  1096.237
   102.000  1097.141
   102.500  1098.048
   103.000  1098.957
   103.500  1099.869
   104.000  1100.783
   104.500  1101.699
   105.000  1102.618
   105.500  1103.539
   106.000  1104.462
   106.500  1105.388
   107.000  1106.315
   107.500  1107.245
   108.000  1108.177
   108.500  1109.112
   109.000  1110.048
   109.500  1110.987
   110.000  1111.927
   110.500  1112.870
   111.000  1113.815
   111.500  1114.762
   112.000  1115.711
   112.500  1116.661
   113.000  1117.614
   113.500  1118.568
   114.000  1119.525
   114.500  1120.483
   115.000  1121.444
   115.500  1122.406
   116.000  1123.369
   116.500  1124.335
   117.000  1125.302
   117.500  1126.271
   118.000  1127.242
   118.500  1128.215
   119.000  1129.189
   119.500  1130.164
   120.000  1131.142
   120.500  1132.120
   121.000  1133.101
   121.500  1134.083
   122.000  1135.067
   122.500  1136.052
   123.000  1137.038
   123.500  1138.026
   124.000  1139.015
   124.500  1140.006
   125.000  1140.998
   125.500  1141.991
   126.000  1142.986
   126.500  1143.982
   127.000  1144.980
   127.500  1145.978
   128.000  1146.978
   128.500  1147.979
   129.000  1148.981
   129.500  1149.984
   130.000  1150.989
   130.500  1151.994
   131.000  1153.001
   131.500  1154.009
   132.000  1155.018
   132.500  1156.027
   133.000  1157.038
   133.500  1158.050
   134.000  1159.063
   134.500  1160.076
   135.000  1161.091
   135.500  1162.106
   136.000  1163.122
   136.500  1164.140
   137.000  1165.157
   137.500  1166.176
   138.000  1167.196
   138.500  1168.216
   139.000  1169.237
   139.500  1170.258
   140.000  1171.281
   140.500  1172.304
   141.000  1173.327
   141.500  1174.351
   142.000  1175.376
   142.500  1176.402
   143.000  1177.428
   143.500  1178.454
   144.000  1179.481
   144.500  1180.508
   145.000  1181.536
   145.500  1182.565
   146.000  1183.593
   146.500  1184.622
   147.000  1185.652
   147.500  1186.682
   148.000  1187.712
   148.500  1188.742
   149.000  1189.773
   149.500  1190.804
   150.000  1191.835
   150.500  1192.867
   151.000  1193.899
   151.500  1194.931
   152.000  1195.963
   152.500  1196.995
   153.000  1198.027
   153.500  1199.060
   154.000  1200.092
   154.500  1201.125
   155.000  1202.157
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1177.022
   145.500  1178.845
   146.000  1180.725
   146.500  1182.641
   147.000  1184.586
   147.500  1186.554
   148.000  1188.542
   148.500  1190.548
   149.000  1192.569
   149.500  1194.604
   150.000  1196.652
   150.500  1198.711
   151.000  1200.781
   151.500  1202.860
   152.000  1204.949
   152.500  1207.046
   153.000  1209.151
   153.500  1211.263
   154.000  1213.382
   154.500  1215.507
   155.000  1217.639
   155.500  1219.776
   156.000  1221.919
   156.500  1224.067
   157.000  1226.219
   157.500  1228.376
   158.000  1230.537
   158.500  1232.702
   159.000  1234.871
   159.500  1237.044
   160.000  1239.221
   160.500  1241.400
   161.000  1243.583
   161.500  1245.768
   162.000  1247.956
   162.500  1250.147
   163.000  1252.340
   163.500  1254.535
   164.000  1256.733
   164.500  1258.933
   165.000  1261.134
   165.500  1263.338
   166.000  1265.542
   166.500  1267.749
   167.000  1269.957
   167.500  1272.167
   168.000  1274.378
   168.500  1276.590
   169.000  1278.803
   169.500  1281.018
   170.000  1283.233
   170.500  1285.450
   171.000  1287.667
   171.500  1289.885
   172.000  1292.104
   172.500  1294.323
   173.000  1296.543
   173.500  1298.764
   174.000  1300.985
   174.500  1303.206
   175.000  1305.428
   175.500  1307.650
   176.000  1309.872
   176.500  1312.095
   177.000  1314.317
   177.500  1316.540
   178.000  1318.763
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1177.020
   145.500  1178.647
   146.000  1180.195
   146.500  1181.685
   147.000  1183.125
   147.500  1184.519
   148.000  1185.871
   148.500  1187.184
   149.000  1188.461
   149.500  1189.710
   150.000  1190.933
   150.500  1192.134
   151.000  1193.314
   151.500  1194.475
   152.000  1195.617
   152.500  1196.742
   153.000  1197.851
   153.500  1198.945
   154.000  1200.026
   154.500  1201.095
   155.000  1202.150
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   510.224
     1.000   510.260
     1.500   510.321
     2.000   510.405
     2.500   510.513
     3.000   510.645
     3.500   510.800
     4.000   510.980
     4.500   511.184
     5.000   511.411
     5.500   511.663
     6.000   511.938
     6.500   512.236
     7.000   512.559
     7.500   512.904
     8.000   513.274
     8.500   513.667
     9.000   514.083
     9.500   514.522
    10.000   514.985
    10.500   515.471
    11.000   515.979
    11.500   516.511
    12.000   517.065
    12.500   517.642
    13.000   518.242
    13.500   518.865
    14.000   519.509
    14.500   520.176
    15.000   520.865
    15.500   521.576
    16.000   522.309
    16.500   523.064
    17.000   523.840
    17.500   524.638
    18.000   525.457
    18.500   526.298
    19.000   527.159
    19.500   528.042
    20.000   528.945
    20.500   529.868
    21.000   530.813
    21.500   531.777
    22.000   532.762
    22.500   533.767
    23.000   534.791
    23.500   535.835
    24.000   536.899
    24.500   537.982
    25.000   539.084
    25.500   540.205
    26.000   541.345
    26.500   542.503
    27.000   543.680
    27.500   544.875
    28.000   546.088
    28.500   547.320
    29.000   548.569
    29.500   549.835
    30.000   551.119
    30.500   552.420
    31.000   553.738
    31.500   555.073
    32.000   556.424
    32.500   557.792
    33.000   559.176
    33.500   560.576
    34.000   561.992
    34.500   563.424
    35.000   564.871
    35.500   566.334
    36.000   567.812
    36.500   569.304
    37.000   570.812
    37.500   572.334
    38.000   573.870
    38.500   575.421
    39.000   576.986
    39.500   578.564
    40.000   580.156
    40.500   581.762
    41.000   583.381
    41.500   585.013
    42.000   586.658
    42.500   588.315
    43.000   589.985
    43.500   591.668
    44.000   593.363
    44.500   595.069
    45.000   596.788
    45.500   598.518
    46.000   600.260
    46.500   602.013
    47.000   603.777
    47.500   605.553
    48.000   607.339
    48.500   609.135
    49.000   610.942
    49.500   612.760
    50.000   614.587
    50.500   616.425
    51.000   618.272
    51.500   620.129
    52.000   621.995
    52.500   623.871
    53.000   625.756
    53.500   627.649
    54.000   629.552
    54.500   631.463
    55.000   633.383
    55.500   635.311
    56.000   637.248
    56.500   639.192
    57.000   641.145
    57.500   643.105
    58.000   645.072
    58.500   647.048
    59.000   649.030
    59.500   651.020
    60.000   653.017
    60.500   655.021
    61.000   657.031
    61.500   659.048
    62.000   661.072
    62.500   663.102
    63.000   665.138
    63.500   667.180
    64.000   669.229
    64.500   671.283
    65.000   673.342
    65.500   675.408
    66.000   677.479
    66.500   679.555
    67.000   681.636
    67.500   683.723
    68.000   685.814
    68.500   687.911
    69.000   690.012
    69.500   692.118
    70.000   694.228
    70.500   696.343
    71.000   698.462
    71.500   700.585
    72.000   702.712
    72.500   704.843
    73.000   706.978
    73.500   709.117
    74.000   711.259
    74.500   713.405
    75.000   715.555
    75.500   717.708
    76.000   719.864
    76.500   722.023
    77.000   724.186
    77.500   726.351
    78.000   728.519
    78.500   730.690
    79.000   732.864
    79.500   735.040
    80.000   737.219
    80.500   739.400
    81.000   741.584
    81.500   743.770
    82.000   745.958
    82.500   748.148
    83.000   750.341
    83.500   752.535
    84.000   754.731
    84.500   756.929
    85.000   759.129
    85.500   761.330
    86.000   763.533
    86.500   765.738
    87.000   767.944
    87.500   770.151
    88.000   772.360
    88.500   774.569
    89.000   776.781
    89.500   778.993
    90.000   781.206
    90.500   783.420
    91.000   785.635
    91.500   787.852
    92.000   790.068
    92.500   792.286
    93.000   794.504
    93.500   796.723
    94.000   798.943
    94.500   801.163
    95.000   803.384
    95.500   805.605
    96.000   807.826
    96.500   810.048
    97.000   812.270
    97.500   814.492
    98.000   816.715
    98.500   818.938
    99.000   821.160
    99.500   823.383
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.941
    29.000   425.499
    29.500   431.056
    30.000   436.612
    30.500   442.167
    31.000   447.720
    31.500   453.272
    32.000   458.822
    32.500   464.370
    33.000   469.914
    33.500   475.455
    34.000   480.993
    34.500   486.526
    35.000   492.055
    35.500   497.579
    36.000   503.097
    36.500   508.610
    37.000   514.115
    37.500   519.614
    38.000   525.105
    38.500   530.587
    39.000   536.061
    39.500   541.525
    40.000   546.979
    40.500   552.423
    41.000   557.856
    41.500   563.277
    42.000   568.685
    42.500   574.081
    43.000   579.464
    43.500   584.832
    44.000   590.186
    44.500   595.526
    45.000   600.850
    45.500   606.158
    46.000   611.451
    46.500   616.726
    47.000   621.985
    47.500   626.748
    48.000   631.319
    48.500   635.885
    49.000   640.447
    49.500   645.003
    50.000   649.555
    50.500   654.101
    51.000   658.643
    51.500   663.178
    52.000   667.708
    52.500   672.233
    53.000   676.751
    53.500   681.263
    54.000   685.769
    54.500   690.266
    55.000   694.755
    55.500   699.233
    56.000   703.701
    56.500   708.161
    57.000   712.615
    57.500   717.063
    58.000   721.507
    58.500   725.946
    59.000   730.380
    59.500   734.811
    60.000   739.238
    60.500   743.661
    61.000   748.081
    61.500   752.496
    62.000   756.908
    62.500   761.316
    63.000   765.720
    63.500   770.119
    64.000   774.515
    64.500   778.906
    65.000   783.292
    65.500   787.672
    66.000   792.047
    66.500   796.416
    67.000   800.778
    67.500   805.133
    68.000   809.480
    68.500   813.820
    69.000   818.153
    69.500   822.478
    70.000   826.795
    70.500   831.105
    71.000   835.408
    71.500   839.703
    72.000   843.990
    72.500   848.270
    73.000   852.542
    73.500   856.806
    74.000   861.063
    74.500   865.311
    75.000   869.552
    75.500   873.785
    76.000   878.010
    76.500   882.227
    77.000   886.435
    77.500   890.636
    78.000   894.828
    78.500   899.011
    79.000   903.186
    79.500   907.353
    80.000   911.511
    80.500   915.660
    81.000   919.801
    81.500   923.933
    82.000   928.057
    82.500   932.172
    83.000   936.279
    83.500   940.378
    84.000   944.467
    84.500   948.548
    85.000   952.621
    85.500   956.685
    86.000   960.740
    86.500   964.786
    87.000   968.823
    87.500   972.852
    88.000   976.871
    88.500   980.882
    89.000   984.884
    89.500   988.877
    90.000   992.861
    90.500   996.836
    91.000  1000.802
    91.500  1004.759
    92.000  1008.707
    92.500  1012.646
    93.000  1016.576
    93.500  1020.497
    94.000  1024.409
    94.500  1028.312
    95.000  1032.205
    95.500  1036.090
    96.000  1039.966
    96.500  1043.833
    97.000  1047.690
    97.500  1051.538
    98.000  1055.378
    98.500  1059.208
    99.000  1063.029
    99.500  1066.841
   100.000  1070.644
   100.500  1074.438
   101.000  1078.222
   101.500  1081.997
   102.000  1085.764
   102.500  1089.521
   103.000  1093.269
   103.500  1097.008
   104.000  1100.738
   104.500  1104.459
   105.000  1108.171
   105.500  1111.874
   106.000  1115.569
   106.500  1119.254
   107.000  1122.930
   107.500  1126.598
   108.000  1130.256
   108.500  1133.905
   109.000  1137.545
   109.500  1141.176
   110.000  1144.798
   110.500  1148.410
   111.000  1152.013
   111.500  1155.606
   112.000  1159.191
   112.500  1162.766
   113.000  1166.332
   113.500  1169.889
   114.000  1173.437
   114.500  1176.976
   115.000  1180.505
   115.500  1184.026
   116.000  1187.537
   116.500  1191.040
   117.000  1194.533
   117.500  1198.018
   118.000  1201.493
   118.500  1204.959
   119.000  1208.416
   119.500  1211.864
   120.000  1215.302
   120.500  1218.732
   121.000  1222.152
   121.500  1225.563
   122.000  1228.964
   122.500  1232.357
   123.000  1235.740
   123.500  1239.115
   124.000  1242.480
   124.500  1245.836
   125.000  1249.183
   125.500  1252.521
   126.000  1255.850
   126.500  1259.170
   127.000  1262.482
   127.500  1265.784
   128.000  1269.077
   128.500  1272.362
   129.000  1275.637
   129.500  1278.904
   130.000  1282.161
   130.500  1285.410
   131.000  1288.650
   131.500  1291.880
   132.000  1295.102
   132.500  1298.314
   133.000  1301.518
   133.500  1304.712
   134.000  1307.897
   134.500  1311.074
   135.000  1314.241
   135.500  1317.399
   136.000  1320.548
   136.500  1323.688
   137.000  1326.819
   137.500  1329.941
   138.000  1333.054
   138.500  1336.157
   139.000  1339.252
   139.500  1342.337
   140.000  1345.414
   140.500  1348.481
   141.000  1351.539
   141.500  1354.589
   142.000  1357.629
   142.500  1360.660
   143.000  1363.682
   143.500  1366.695
   144.000  1369.699
   144.500  1372.693
   145.000  1375.679
   145.500  1378.655
   146.000  1381.623
   146.500  1384.580
   147.000  1387.529
   147.500  1390.468
   148.000  1393.398
   148.500  1396.319
   149.000  1399.229
   149.500  1402.131
   150.000  1405.024
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.606
   100.500   827.829
   101.000   830.052
   101.500   832.275
   102.000   834.497
   102.500   836.720
   103.000   838.943
   103.500   841.166
   104.000   843.389
   104.500   845.612
   105.000   847.834
   105.500   850.057
   106.000   852.280
   106.500   854.503
   107.000   856.726
   107.500   858.949
   108.000   861.171
   108.500   863.394
   109.000   865.617
   109.500   867.840
   110.000   870.063
   110.500   872.286
   111.000   874.508
   111.500   876.731
   112.000   878.954
   112.500   881.177
   113.000   883.400
   113.500   885.623
   114.000   887.846
   114.500   890.068
   115.000   892.291
   115.500   894.514
   116.000   896.737
   116.500   898.960
   117.000   901.182
   117.500   903.405
   118.000   905.628
   118.500   907.851
   119.000   910.074
   119.500   912.297
   120.000   914.520
   120.500   916.742
   121.000   918.965
   121.500   921.188
   122.000   923.411
   122.500   925.634
   123.000   927.857
   123.500   930.079
   124.000   932.302
   124.500   934.525
   125.000   936.748
   125.500   938.971
   126.000   941.193
   126.500   943.416
   127.000   945.639
   127.500   947.862
   128.000   950.085
   128.500   952.308
   129.000   954.531
   129.500   956.753
   130.000   958.976
   130.500   961.199
   131.000   963.422
   131.500   965.645
   132.000   967.868
   132.500   970.090
   133.000   972.313
   133.500   974.536
   134.000   976.759
   134.500   978.982
   135.000   981.205
   135.500   983.427
   136.000   985.650
   136.500   987.873
   137.000   990.096
   137.500   992.319
   138.000   994.542
   138.500   996.764
   139.000   998.987
   139.500  1001.210
   140.000  1003.433
   140.500  1005.656
   141.000  1007.879
   141.500  1010.101
   142.000  1012.324
   142.500  1014.547
   143.000  1016.770
   143.500  1018.993
   144.000  1021.216
   144.500  1023.438
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   386.047
    15.000   396.286
    15.500   406.521
    16.000   416.749
    16.500   426.967
    17.000   437.171
    17.500   447.356
    18.000   457.519
    18.500   467.654
    19.000   477.756
    19.500   487.818
    20.000   497.834
    20.500   507.799
    21.000   517.707
    21.500   527.553
    22.000   537.330
    22.500   547.035
    23.000   555.750
    23.500   563.894
    24.000   572.004
    24.500   580.082
    25.000   588.116
    25.500   596.071
    26.000   603.983
    26.500   611.884
    27.000   619.775
    27.500   627.659
    28.000   635.536
    28.500   643.407
    29.000   651.271
    29.500   659.128
    30.000   666.979
    30.500   674.820
    31.000   682.653
    31.500   690.474
    32.000   698.282
    32.500   706.076
    33.000   713.855
    33.500   721.617
    34.000   729.362
    34.500   737.087
    35.000   744.794
    35.500   752.481
    36.000   760.149
    36.500   767.797
    37.000   775.424
    37.500   783.031
    38.000   790.616
    38.500   798.180
    39.000   805.722
    39.500   813.241
    40.000   820.738
    40.500   828.211
    41.000   835.661
    41.500   843.088
    42.000   850.490
    42.500   857.869
    43.000   865.223
    43.500   872.552
    44.000   879.857
    44.500   887.137
    45.000   894.391
    45.500   901.621
    46.000   908.824
    46.500   916.003
    47.000   923.154
    47.500   930.280
    48.000   937.379
    48.500   944.451
    49.000   951.496
    49.500   958.513
    50.000   965.504
    50.500   972.468
    51.000   979.405
    51.500   986.315
    52.000   993.196
    52.500  1000.050
    53.000  1006.877
    53.500  1013.677
    54.000  1020.452
    54.500  1027.201
    55.000  1033.922
    55.500  1040.617
    56.000  1047.285
    56.500  1053.924
    57.000  1060.536
    57.500  1067.119
    58.000  1073.674
    58.500  1080.202
    59.000  1086.702
    59.500  1093.174
    60.000  1099.618
    60.500  1106.035
    61.000  1112.424
    61.500  1118.785
    62.000  1125.118
    62.500  1131.422
    63.000  1137.698
    63.500  1143.945
    64.000  1150.164
    64.500  1156.354
    65.000  1162.516
    65.500  1168.650
    66.000  1174.756
    66.500  1180.834
    67.000  1186.883
    67.500  1192.903
    68.000  1198.895
    68.500  1204.859
    69.000  1210.794
    69.500  1216.700
    70.000  1222.577
    70.500  1228.426
    71.000  1234.246
    71.500  1240.037
    72.000  1245.799
    72.500  1251.531
    73.000  1257.234
    73.500  1262.906
    74.000  1268.549
    74.500  1274.162
    75.000  1279.745
    75.500  1285.298
    76.000  1290.822
    76.500  1296.317
    77.000  1301.783
    77.500  1307.218
    78.000  1312.623
    78.500  1317.997
    79.000  1323.342
    79.500  1328.656
    80.000  1333.943
    80.500  1339.199
    81.000  1344.425
    81.500  1349.620
    82.000  1354.784
    82.500  1359.915
    83.000  1365.014
    83.500  1370.082
    84.000  1375.119
    84.500  1380.125
    85.000  1385.100
    85.500  1390.043
    86.000  1394.955
    86.500  1399.835
    87.000  1404.682
    87.500  1409.497
    88.000  1414.279
    88.500  1419.028
    89.000  1423.744
    89.500  1428.426
    90.000  1433.074
    90.500  1437.689
    91.000  1442.270
    91.500  1446.817
    92.000  1451.330
    92.500  1455.810
    93.000  1460.255
    93.500  1464.666
    94.000  1469.051
    94.500  1473.420
    95.000  1477.775
    95.500  1482.118
    96.000  1486.450
    96.500  1490.769
    97.000  1495.071
    97.500  1499.353
    98.000  1503.615
    98.500  1507.858
    99.000  1512.081
    99.500  1516.284
   100.000  1520.465
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   721.277
     1.000   721.323
     1.500   721.401
     2.000   721.510
     2.500   721.650
     3.000   721.821
     3.500   722.023
     4.000   722.256
     4.500   722.520
     5.000   722.815
     5.500   723.141
     6.000   723.497
     6.500   723.884
     7.000   724.301
     7.500   724.749
     8.000   725.227
     8.500   725.735
     9.000   726.273
     9.500   726.841
    10.000   727.439
    10.500   728.066
    11.000   728.723
    11.500   729.410
    12.000   730.125
    12.500   730.870
    13.000   731.643
    13.500   732.445
    14.000   733.276
    14.500   734.134
    15.000   735.021
    15.500   735.936
    16.000   736.878
    16.500   737.848
    17.000   738.845
    17.500   739.868
    18.000   740.919
    18.500   741.996
    19.000   743.099
    19.500   744.229
    20.000   745.384
    20.500   746.565
    21.000   747.771
    21.500   749.001
    22.000   750.257
    22.500   751.537
    23.000   752.841
    23.500   754.169
    24.000   755.521
    24.500   756.896
    25.000   758.294
    25.500   759.714
    26.000   761.158
    26.500   762.623
    27.000   764.110
    27.500   765.618
    28.000   767.148
    28.500   768.699
    29.000   770.270
    29.500   771.862
    30.000   773.473
    30.500   775.104
    31.000   776.754
    31.500   778.424
    32.000   780.112
    32.500   781.818
    33.000   783.542
    33.500   785.284
    34.000   787.044
    34.500   788.820
    35.000   790.613
    35.500   792.422
    36.000   794.248
    36.500   796.089
    37.000   797.945
    37.500   799.817
    38.000   801.703
    38.500   803.603
    39.000   805.518
    39.500   807.446
    40.000   809.387
    40.500   811.341
    41.000   813.308
    41.500   815.288
    42.000   817.279
    42.500   819.282
    43.000   821.297
    43.500   823.322
    44.000   825.358
    44.500   827.404
    45.000   829.461
    45.500   831.527
    46.000   833.602
    46.500   835.687
    47.000   837.780
    47.500   839.881
    48.000   841.991
    48.500   844.108
    49.000   846.233
    49.500   848.365
    50.000   850.504
    50.500   852.650
    51.000   854.801
    51.500   856.959
    52.000   859.122
    52.500   861.291
    53.000   863.465
    53.500   865.643
    54.000   867.826
    54.500   870.013
    55.000   872.205
    55.500   874.400
    56.000   876.598
    56.500   878.800
    57.000   881.004
    57.500   883.212
    58.000   885.422
    58.500   887.634
    59.000   889.848
    59.500   892.063
    60.000   894.281
    60.500   896.500
    61.000   898.720
    61.500   900.941
    62.000   903.162
    62.500   905.384
    63.000   907.607
    63.500   909.830
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   933.331
     1.000   933.397
     1.500   933.508
     2.000   933.663
     2.500   933.862
     3.000   934.106
     3.500   934.393
     4.000   934.725
     4.500   935.100
     5.000   935.520
     5.500   935.983
     6.000   936.490
     6.500   937.041
     7.000   937.636
     7.500   938.274
     8.000   938.955
     8.500   939.679
     9.000   940.447
     9.500   941.258
    10.000   942.111
    10.500   943.007
    11.000   943.945
    11.500   944.926
    12.000   945.949
    12.500   947.014
    13.000   948.120
    13.500   949.268
    14.000   950.458
    14.500   951.688
    15.000   952.960
    15.500   954.272
    16.000   955.624
    16.500   957.017
    17.000   958.450
    17.500   959.922
    18.000   961.434
    18.500   962.985
    19.000   964.575
    19.500   966.204
    20.000   967.871
    20.500   969.576
    21.000   971.320
    21.500   973.100
    22.000   974.918
    22.500   976.773
    23.000   978.665
    23.500   980.593
    24.000   982.557
    24.500   984.557
    25.000   986.593
    25.500   988.664
    26.000   990.769
    26.500   992.909
    27.000   995.083
    27.500   997.292
    28.000   999.533
    28.500  1001.808
    29.000  1004.116
    29.500  1006.457
    30.000  1008.830
    30.500  1011.234
    31.000  1013.671
    31.500  1016.138
    32.000  1018.637
    32.500  1021.166
    33.000  1023.725
    33.500  1026.314
    34.000  1028.933
    34.500  1031.581
    35.000  1034.258
    35.500  1036.964
    36.000  1039.698
    36.500  1042.459
    37.000  1045.249
    37.500  1048.065
    38.000  1050.909
    38.500  1053.779
    39.000  1056.675
    39.500  1059.597
    40.000  1062.544
    40.500  1065.517
    41.000  1068.515
    41.500  1071.537
    42.000  1074.584
    42.500  1077.654
    43.000  1080.748
    43.500  1083.865
    44.000  1087.006
    44.500  1090.168
    45.000  1093.354
    45.500  1096.561
    46.000  1099.789
    46.500  1103.039
    47.000  1106.310
    47.500  1109.602
    48.000  1112.914
    48.500  1116.247
    49.000  1119.599
    49.500  1122.970
    50.000  1126.361
    50.500  1129.770
    51.000  1133.199
    51.500  1136.645
    52.000  1140.109
    52.500  1143.592
    53.000  1147.091
    53.500  1150.608
    54.000  1154.141
    54.500  1157.692
    55.000  1161.258
    55.500  1164.840
    56.000  1168.438
    56.500  1172.052
    57.000  1175.681
    57.500  1179.324
    58.000  1182.983
    58.500  1186.655
    59.000  1190.342
    59.500  1194.043
    60.000  1197.757
    60.500  1201.485
    61.000  1205.225
    61.500  1208.979
    62.000  1212.745
    62.500  1216.524
    63.000  1220.314
    63.500  1224.117
    64.000  1227.931
    64.500  1231.757
    65.000  1235.594
    65.500  1239.441
    66.000  1243.300
    66.500  1247.168
    67.000  1251.048
    67.500  1254.937
    68.000  1258.836
    68.500  1262.745
    69.000  1266.663
    69.500  1270.590
    70.000  1274.526
    70.500  1278.471
    71.000  1282.425
    71.500  1286.386
    72.000  1290.356
    72.500  1294.334
    73.000  1298.320
    73.500  1302.313
    74.000  1306.314
    74.500  1310.322
    75.000  1314.337
    75.500  1318.359
    76.000  1322.387
    76.500  1326.422
    77.000  1330.463
    77.500  1334.510
    78.000  1338.563
    78.500  1342.622
    79.000  1346.687
    79.500  1350.756
    80.000  1354.832
    80.500  1358.912
    81.000  1362.997
    81.500  1367.087
    82.000  1371.181
    82.500  1375.280
    83.000  1379.383
    83.500  1383.490
    84.000  1387.602
    84.500  1391.717
    85.000  1395.836
    85.500  1399.958
    86.000  1404.084
    86.500  1408.213
    87.000  1412.345
    87.500  1416.480
    88.000  1420.619
    88.500  1424.759
    89.000  1428.903
    89.500  1433.048
    90.000  1437.197
    90.500  1441.347
    91.000  1445.499
    91.500  1449.654
    92.000  1453.810
    92.500  1457.968
    93.000  1462.127
    93.500  1466.288
    94.000  1470.451
    94.500  1474.614
    95.000  1478.779
    95.500  1482.945
    96.000  1487.111
    96.500  1491.279
    97.000  1495.447
    97.500  1499.616
    98.000  1503.785
    98.500  1507.955
    99.000  1512.125
    99.500  1516.295
   100.000  1520.465
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   774.001
    29.500   784.241
    30.000   794.479
    30.500   804.715
    31.000   814.949
    31.500   825.180
    32.000   835.407
    32.500   845.628
    33.000   855.844
    33.500   866.053
    34.000   876.254
    34.500   886.446
    35.000   896.628
    35.500   906.799
    36.000   916.957
    36.500   927.101
    37.000   937.230
    37.500   947.343
    38.000   957.438
    38.500   967.114
    39.000   977.567
    39.500   987.599
    40.000   997.606
    40.500  1007.588
    41.000  1017.543
    41.500  1027.470
    42.000  1037.366
    42.500  1047.232
    43.000  1057.065
    43.500  1066.864
    44.000  1076.628
    44.500  1086.355
    45.000  1096.046
    45.500  1105.463
    46.000  1113.633
    46.500  1121.786
    47.000  1129.923
    47.500  1138.043
    48.000  1146.147
    48.500  1154.234
    49.000  1162.304
    49.500  1170.354
    50.000  1178.378
    50.500  1186.365
    51.000  1194.296
    51.500  1202.212
    52.000  1210.121
    52.500  1218.024
    53.000  1225.923
    53.500  1233.817
    54.000  1241.707
    54.500  1249.593
    55.000  1257.475
    55.500  1265.355
    56.000  1273.231
    56.500  1281.103
    57.000  1288.972
    57.500  1296.838
    58.000  1304.701
    58.500  1312.560
    59.000  1320.416
    59.500  1328.269
    60.000  1336.117
    60.500  1343.962
    61.000  1351.802
    61.500  1359.637
    62.000  1367.467
    62.500  1375.292
    63.000  1383.110
    63.500  1390.922
    64.000  1398.728
    64.500  1406.527
    65.000  1414.318
    65.500  1422.102
    66.000  1429.877
    66.500  1437.644
    67.000  1445.402
    67.500  1453.152
    68.000  1460.892
    68.500  1468.624
    69.000  1476.346
    69.500  1484.058
    70.000  1491.761
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     8.512   123.023     0.150
     8.709   231.820     0.150
     8.709   127.820     0.150
     8.709   231.820     0.150
    16.142   220.320     0.150
    16.142   391.320     0.150
    16.142   220.320     0.150
    16.142   391.320     0.150
    16.142   394.820     0.150
    17.835   250.820     0.150
    20.241   280.523     0.150
    22.006   299.820     0.150
    22.759  3578.820     0.150
    23.448   311.820     0.150
    23.448   568.820     0.150
    23.801   313.820     0.150
    23.801   570.820     0.150
    24.219   570.820     0.150
    30.522   680.820     0.150
    30.522   373.820     0.150
    30.544   374.820     0.150
    30.544   674.820     0.150
    34.287   409.617     0.150
    36.405 22025.820     0.150
    37.927   789.820     0.150
    38.289   433.023     0.150
    39.037   448.820     0.150
    42.239 22073.820     0.150
    42.713 22078.320     0.150
    43.103 22080.820     0.150
    43.093 22079.820     0.150
    43.093 22466.820     0.150
    43.115 22082.820     0.150
    43.115 22467.820     0.150
    43.196  1409.820     0.150
    44.933   888.820     0.150
    48.245 22121.320     0.150
    48.275   935.820     0.150
    48.275 22122.820     0.150
    48.275 22535.820     0.150
    52.096   550.820     0.150
    52.342   552.820     0.150
    54.004    12.000     0.150
    54.298    12.000     0.150
    54.566   665.320     0.150
    54.566   666.320     0.150
    54.566   729.820     0.150
    54.566  1095.820     0.150
    55.164   716.523     0.150
    56.018   620.820     0.150
    56.316   582.820     0.150
    56.364   581.820     0.150
    57.262   601.820     0.150
    57.262   611.820     0.150
    57.262   626.820     0.150
    58.683   614.820     0.150
    59.155   658.820     0.150
    60.291  1122.820     0.150
    64.096   631.922     0.150
    64.102     0.906     0.150
    64.764   641.820     0.150
    78.143   709.820     0.150
    91.090   781.422     0.150
    16.094   220.422     0.150
    16.094   387.422     0.150
    36.018  3804.422     0.150
    40.494   463.320     0.150
    44.420   489.922     0.150
    45.129   500.422     0.150
    48.506   529.422     0.150
    55.106   579.422     0.150
    55.106   593.422     0.150
    56.222   583.422     0.150
    56.222   664.422     0.150
    57.294   592.422     0.150
    60.569   611.719     0.150
    63.071   632.023     0.150
    63.258   632.922     0.150
    69.743   665.422     0.150
     2.534    41.926     0.150
     2.534    44.926     0.150
     3.692    58.926     0.150
     3.692    67.527     0.150
     3.692   114.426     0.150
     4.634    71.625     0.150
     4.634    85.625     0.150
     4.966   154.926     0.150
     4.966    74.926     0.150
     4.966    88.926     0.150
     4.966   154.926     0.150
     5.017    78.324     0.150
     5.017    93.227     0.150
     5.017   159.125     0.150
     7.529   238.324     0.150
     7.529   111.324     0.150
     7.529   138.824     0.150
     7.529   238.324     0.150
     8.375   116.926     0.150
     8.877   235.926     0.150
     8.877   235.926     0.150
    10.487   272.027     0.150
    10.487   152.926     0.150
    10.487   272.027     0.150
    16.072   219.426     0.150
    16.072   219.426     0.150
    17.670   241.926     0.150
    18.337   255.926     0.150
    18.567   250.125     0.150
    18.567   250.125     0.150
    18.567   459.926     0.150
    19.447   267.926     0.150
    23.630   327.926     0.150
    23.630   327.926     0.150
    28.659   345.926     0.150
    28.659   345.926     0.150
    30.079   367.926     0.150
    30.079   367.926     0.150
    30.079   442.926     0.150
    30.385   372.926     0.150
    30.385     6.000     0.150
    30.385   440.926     0.150
    30.682   447.926     0.150
    34.457   408.926     0.150
    36.865   433.926     0.150
    36.865   434.227     0.150
    38.243   444.926     0.150
    39.102   446.926     0.150
    42.359   473.926     0.150
    43.123   480.227     0.150
    43.214   481.727     0.150
    44.354   483.227     0.150
    45.026   495.926     0.150
    48.397   525.324     0.150
    52.618   557.926     0.150
    54.116   565.926     0.150
    54.998   611.926     0.150
    54.998   620.926     0.150
    54.998   655.926     0.150
    56.063   579.527     0.150
    56.118   627.926     0.150
    57.190   587.426     0.150
    57.190   587.426     0.150
    57.546   590.824     0.150
    60.385   592.727     0.150
    63.155   627.625     0.150
    77.251   718.125     0.150
     0.643    10.883     0.150
     4.742   131.078     0.150
     5.112   160.281     0.150
    10.628   155.383     0.150
    15.943   220.281     0.150
    15.943   220.680     0.150
    15.943   391.281     0.150
    18.386   259.180     0.150
    18.531   252.281     0.150
    18.531   252.281     0.150
    18.531   458.281     0.150
    18.431   261.281     0.150
    18.431   261.484     0.150
    23.026   311.281     0.150
    23.026   311.883     0.150
    77.330   711.578     0.150
     0.591    13.320     0.150
     0.591    21.523     0.150
     1.225    37.523     0.150
     2.409    77.023     0.150
     4.722    76.023     0.150
     0.759    25.680     0.150
     2.444    73.680     0.150
     2.444    89.680     0.150
     3.459    91.180     0.150
     4.818    78.477     0.150
     5.635    81.680     0.150
     2.236    74.668     0.150
     2.236    40.168     0.150
     2.236    74.668     0.150
     2.680    44.270     0.150
     3.945    65.969     0.150
     3.945    96.867     0.150
     4.886    78.770     0.150
     5.019   157.668     0.150
     5.279    83.469     0.150
     5.279   143.367     0.150
     5.279   170.867     0.150
     7.579   137.367     0.150
     8.048   146.168     0.150
     8.048   145.367     0.150
     8.048   146.367     0.150
     8.142   248.367     0.150
     8.142   118.066     0.150
     8.142   207.168     0.150
     8.142   248.367     0.150
     9.140   170.168     0.150
     9.140   229.867     0.150
     9.140   263.168     0.150
     9.776   180.367     0.150
    10.276   189.566     0.150
    10.276   249.168     0.150
    10.276   327.168     0.150
    10.748   271.469     0.150
    10.748   271.469     0.150
    11.367   185.668     0.150
    11.367   319.469     0.150
    15.928   220.168     0.150
    15.928   220.668     0.150
    15.928   391.668     0.150
    17.407   231.168     0.150
    17.407   231.168     0.150
    18.276   255.168     0.150
    18.626   253.168     0.150
    18.626   454.168     0.150
    18.626   253.566     0.150
    18.626   454.168     0.150
    23.372   318.168     0.150
    23.372   554.168     0.150
    23.372   318.168     0.150
    23.372   554.168     0.150
    30.865   376.168     0.150
    30.865    16.898     0.150
    30.865   376.969     0.150
    30.865    16.098     0.150
    42.622   481.168     0.150
    57.671   593.566     0.150
    77.275   718.867     0.150
     2.683    79.062     0.150
     3.933    63.762     0.150
     5.132   157.963     0.150
     1.197    24.562     0.150
     1.197    40.461     0.150
     0.776    17.695     0.150
     1.040    21.898     0.150
     1.040    36.898     0.150
     2.288    68.797     0.150
     2.298    40.102     0.150
     2.298    69.297     0.150
     2.482    49.195     0.150
     4.128   134.398     0.150
     2.633    41.695     0.150
     2.633    47.391     0.150
     3.073    48.594     0.150
     3.073    93.594     0.150
     4.491   137.297     0.150
     4.491    67.992     0.150
     4.491   137.297     0.150
     5.400    81.695     0.150
     5.400   140.594     0.150
     6.222    91.594     0.150
     6.222   193.594     0.150
     7.160    99.297     0.150
     7.160   177.594     0.150
     7.160    99.297     0.150
     7.160   177.594     0.150
     8.867   132.594     0.150
    11.844   169.594     0.150
    14.260     3.797     0.150
    14.260   365.594     0.150
    14.473   214.594     0.150
    14.473    10.500     0.150
    14.863   202.594     0.150
    14.863   367.094     0.150
    14.863   202.594     0.150
    14.863   367.094     0.150
    15.483   216.594     0.150
    15.483   397.594     0.150
    15.906     9.000     0.150
    15.906   399.594     0.150
    16.668   416.594     0.150
    16.668   416.594     0.150
    17.487    12.500     0.150
    17.775    10.000     0.150
    17.775   450.594     0.150
    17.999   241.594     0.150
    17.999   241.594     0.150
    17.921   249.797     0.150
    18.892   258.797     0.150
    18.892   258.797     0.150
    18.892   467.594     0.150
    20.802   280.594     0.150
    20.802   509.594     0.150
    21.254    10.102     0.150
    21.876    10.203     0.150
    21.876    13.703     0.150
    21.876   686.594     0.150
    22.886   302.594     0.150
    22.886   552.594     0.150
    24.342     9.297     0.150
    24.342   570.594     0.150
    25.373   582.594     0.150
    26.376   611.594     0.150
    27.057   628.594     0.150
    28.499   748.594     0.150
    29.166   359.594     0.150
    29.166   433.594     0.150
    29.166   650.594     0.150
    29.195   359.594     0.150
    29.195   359.594     0.150
    29.195    11.000     0.150
    29.195   648.594     0.150
    29.195   760.594     0.150
    29.485   373.594     0.150
    29.485   373.594     0.150
    30.769   675.594     0.150
    31.253   462.594     0.150
    31.253   676.594     0.150
    31.973   384.594     0.150
    31.973     6.000     0.150
    33.911   403.594     0.150
    33.911   727.594     0.150
    35.156   412.594     0.150
    35.156   743.594     0.150
    35.156   910.594     0.150
    36.265   422.797     0.150
    36.265   521.594     0.150
    36.265   763.594     0.150
    36.735   426.594     0.150
    36.735   530.594     0.150
    36.735   770.594     0.150
    36.735   943.594     0.150
    37.374   443.094     0.150
    37.357   779.797     0.150
    37.411   432.594     0.150
    37.411   780.594     0.150
    37.519   520.594     0.150
    37.519   775.594     0.150
    38.518   441.594     0.150
    39.945   463.594     0.150
    42.909   477.594     0.150
    42.909     8.000     0.150
    43.101   868.594     0.150
    43.101   478.594     0.150
    43.101     9.000     0.150
    43.101    12.000     0.150
    43.101   582.594     0.150
    43.101   868.594     0.150
    43.474   871.094     0.150
    43.607   483.391     0.150
    43.607     7.203     0.150
    43.607   873.594     0.150
    44.660   489.297     0.150
    44.778   493.594     0.150
    46.323   508.594     0.150
    46.323   918.594     0.150
    46.388   503.594     0.150
    46.388   663.594     0.150
    46.388   908.594     0.150
    46.761   507.594     0.150
    46.761     7.500     0.150
    46.761   662.594     0.150
    46.761   914.594     0.150
    47.284   517.594     0.150
    47.284   916.594     0.150
    47.284   517.594     0.150
    47.284   916.594     0.150
    47.345   918.594     0.150
    47.345   512.594     0.150
    47.345   628.594     0.150
    47.345   918.594     0.150
    48.806   524.992     0.150
    48.806   947.594     0.150
    49.313   954.594     0.150
    49.313   528.594     0.150
    49.313   954.594     0.150
    49.599   536.594     0.150
    49.599   536.594     0.150
    49.599   956.594     0.150
    52.195   554.594     0.150
    52.195    17.000     0.150
    52.195   554.594     0.150
    52.195     5.000     0.150
    52.195    17.000     0.150
    52.177   556.594     0.150
    52.312   556.594     0.150
    52.312   556.594     0.150
    52.803  1002.594     0.150
    53.240   710.594     0.150
    53.289   569.094     0.150
    53.911   561.492     0.150
    53.911     7.000     0.150
    53.911    12.305     0.150
    53.958   551.594     0.150
    53.958  1018.594     0.150
    53.958   552.094     0.150
    53.958  1018.594     0.150
    54.006   746.594     0.150
    54.297   571.594     0.150
    54.341   571.594     0.150
    54.652   756.094     0.150
    54.652  1138.594     0.150
    54.886   574.594     0.150
    55.240   578.594     0.150
    55.261   578.594     0.150
    55.305   559.594     0.150
    55.588   614.594     0.150
    55.768   581.594     0.150
    55.768   676.594     0.150
    55.768   748.594     0.150
    55.768  1445.594     0.150
    55.768   574.297     0.150
    55.768    10.297     0.150
    55.804   706.594     0.150
    55.804   574.695     0.150
    56.213   578.094     0.150
    56.213     6.500     0.150
    56.260   573.594     0.150
    56.260   574.195     0.150
    56.314    21.297     0.150
    56.314   794.094     0.150
    56.314   580.094     0.150
    56.314     6.398     0.150
    56.475   586.594     0.150
    56.537   582.594     0.150
    56.537     5.000     0.150
    56.635   582.594     0.150
    56.635     6.000     0.150
    56.815   785.094     0.150
    56.815   582.094     0.150
    56.815    12.000     0.150
    56.815   785.094     0.150
    56.870   582.594     0.150
    56.870   588.594     0.150
    56.870   582.594     0.150
    56.870     6.000     0.150
    57.275   586.391     0.150
    57.275     6.703     0.150
    57.680   595.094     0.150
    57.779   591.195     0.150
    58.863   603.594     0.150
    59.023   602.594     0.150
    58.992     7.398     0.150
    58.992   598.594     0.150
    58.992     7.398     0.150
    59.444   602.094     0.150
    60.821   615.094     0.150
    61.268   618.297     0.150
    61.763   610.891     0.150
    64.638   635.195     0.150
    74.233   702.297     0.150
    89.186   769.594     0.150
   138.172  1153.594     0.150
   138.582  1153.594     0.150
   138.845  1156.594     0.150
   139.133  1156.594     0.150
   143.166  1143.594     0.150
   143.921  1168.797     0.150
     1.300    26.848     0.150
     2.379    47.945     0.150
     2.399    46.047     0.150
     2.399    78.047     0.150
     3.282    66.047     0.150
     3.647    74.047     0.150
     3.647   115.848     0.150
     4.169    80.547     0.150
     4.557    76.047     0.150
     4.557    86.547     0.150
     5.473    90.148     0.150
     5.612    87.848     0.150
     5.612    90.746     0.150
     6.588    83.547     0.150
     6.588   130.848     0.150
     7.723   116.648     0.150
     7.723   240.148     0.150
     7.920   112.246     0.150
     7.920   240.047     0.150
     8.045   121.445     0.150
     8.045   209.246     0.150
     0.296     9.672     0.150
     0.296     6.672     0.150
     0.851     9.672     0.150
     2.465    40.375     0.150
     2.465    40.375     0.150
     2.492    41.672     0.150
     2.492    41.672     0.150
     2.492    41.672     0.150
     2.708    44.875     0.150
     2.708    44.875     0.150
     3.522    56.172     0.150
     3.522    56.172     0.150
     3.522    60.172     0.150
     3.862    60.273     0.150
     3.862    60.273     0.150
     3.862    64.469     0.150
     4.246    65.672     0.150
     4.246    65.672     0.150
     4.246    69.273     0.150
     4.798    76.969     0.150
     4.798    73.672     0.150
     4.798    73.672     0.150
     4.798    77.773     0.150
     4.798    76.969     0.150
     5.313    79.672     0.150
     5.313    79.672     0.150
     5.313    79.672     0.150
     5.474    82.773     0.150
     5.474    82.773     0.150
     5.474    86.172     0.150
     5.474    94.172     0.150
     6.675   103.875     0.150
     6.675   120.969     0.150
     6.675   128.070     0.150
     7.728   111.773     0.150
     7.728   111.773     0.150
     7.728   141.070     0.150
     7.728   242.969     0.150
     7.786   114.672     0.150
     7.786   116.969     0.150
     7.786   127.273     0.150
     7.786   140.672     0.150
     7.786   244.570     0.150
     7.786   114.672     0.150
     8.045   113.875     0.150
     8.064   123.672     0.150
     8.064   147.672     0.150
     8.064   210.672     0.150
     8.064   253.172     0.150
     9.126   165.969     0.150
     9.126   277.172     0.150
     9.126   133.875     0.150
     9.768   164.469     0.150
     9.768   249.672     0.150
     9.768   290.469     0.150
    10.252   162.469     0.150
    10.252   186.375     0.150
    10.252   263.273     0.150
    10.762   278.672     0.150
    10.762   195.672     0.150
    10.762   155.672     0.150
    10.762   278.672     0.150
    11.134   165.172     0.150
    11.134   185.875     0.150
    11.134   319.172     0.150
    11.134   160.672     0.150
    11.134   165.172     0.150
    11.134   185.875     0.150
    11.134   319.172     0.150
    11.134   345.375     0.150
    11.312   162.172     0.150
    11.312   162.172     0.150
    11.312   315.672     0.150
    11.312   333.172     0.150
    12.147   170.273     0.150
    12.147   373.875     0.150
    13.438   187.172     0.150
    13.438   345.070     0.150
    13.705   200.672     0.150
    13.705   371.672     0.150
    13.705   384.672     0.150
    14.183   197.172     0.150
    14.089   202.469     0.150
    14.089   202.469     0.150
    14.089   202.469     0.150
    14.624   203.070     0.150
    15.269   210.570     0.150
    15.269   369.672     0.150
    15.275   211.875     0.150
    15.275   472.273     0.150
    15.267   388.672     0.150
    15.401   213.672     0.150
    15.401   393.070     0.150
    16.663   237.172     0.150
    16.877     4.000     0.150
    17.915   250.672     0.150
    18.033   252.672     0.150
    19.304   267.969     0.150
    20.451   289.672     0.150
    20.985     6.000     0.150
    21.710   296.375     0.150
    22.677   303.672     0.150
    23.018   307.273     0.150
    23.018     7.398     0.150
    23.018    11.898     0.150
    23.447   317.672     0.150
    23.447   310.672     0.150
    23.447     7.000     0.150
    23.450   310.773     0.150
    23.450   310.773     0.150
    23.450   310.773     0.150
    24.270   528.672     0.150
    24.599     5.398     0.150
    25.457   331.969     0.150
    25.643   330.672     0.150
    25.643     8.000     0.150
    29.115   429.672     0.150
    29.115   363.672     0.150
    29.115   429.672     0.150
    30.054   369.070     0.150
    30.667   375.469     0.150
    30.667   676.672     0.150
    30.667   796.672     0.150
    30.679   377.672     0.150
    30.679   671.672     0.150
    31.247    13.000     0.150
    31.876   463.672     0.150
    31.876   384.969     0.150
    31.876     4.703     0.150
    31.876   456.672     0.150
    31.876   463.672     0.150
    31.876   550.672     0.150
    31.876   696.672     0.150
    31.876   821.672     0.150
    32.249   388.672     0.150
    32.888   398.070     0.150
    33.379   399.672     0.150
    33.379    12.398     0.150
    33.379   399.672     0.150
    33.379   473.672     0.150
    33.379   719.672     0.150
    38.053   531.672     0.150
    40.042   456.672     0.150
    40.042   824.672     0.150
    41.864   463.672     0.150
    41.994   458.672     0.150
    42.289   606.672     0.150
    42.289   472.672     0.150
    42.289     6.000     0.150
    42.289   576.672     0.150
    42.289   586.672     0.150
    42.289   606.672     0.150
    42.289   852.672     0.150
    42.289   858.672     0.150
    42.289  1042.672     0.150
    42.289  1072.672     0.150
    42.554   476.273     0.150
    43.013  1099.672     0.150
    43.013   481.672     0.150
    43.013   582.672     0.150
    43.013   869.672     0.150
    43.013  1054.672     0.150
    43.013  1080.672     0.150
    43.013  1099.672     0.150
    43.086   618.672     0.150
    43.086   479.672     0.150
    43.086     5.000     0.150
    43.086   580.672     0.150
    43.086   618.672     0.150
    43.086   866.672     0.150
    43.086  1071.672     0.150
    43.146   480.773     0.150
    43.146   587.773     0.150
    43.146   591.672     0.150
    43.146   864.672     0.150
    43.146  1056.672     0.150
    43.146  1076.672     0.150
    44.069    22.500     0.150
    44.889   493.375     0.150
    44.889   602.672     0.150
    44.889   493.375     0.150
    45.453   500.672     0.150
    45.453   904.672     0.150
    45.453   500.672     0.150
    45.453   904.672     0.150
    45.992   488.672     0.150
    45.992   896.672     0.150
    45.992   488.672     0.150
    45.992   896.672     0.150
    46.145   620.672     0.150
    46.145   506.672     0.150
    46.145   620.672     0.150
    47.081   926.672     0.150
    47.081   513.672     0.150
    47.081     3.000     0.150
    47.081   926.672     0.150
    47.330   630.070     0.150
    47.330   941.172     0.150
    47.330   515.469     0.150
    47.330   600.469     0.150
    47.330   630.070     0.150
    47.330   931.469     0.150
    47.330   941.172     0.150
    47.452   632.672     0.150
    47.452   922.672     0.150
    47.452  1124.672     0.150
    47.452   514.672     0.150
    47.452   632.672     0.150
    47.452   922.672     0.150
    47.452  1124.672     0.150
    47.776   513.469     0.150
    47.776   635.672     0.150
    47.781   635.672     0.150
    49.139   648.672     0.150
    49.139   528.672     0.150
    49.139   648.672     0.150
    49.139   955.672     0.150
    49.466   959.672     0.150
    49.466   528.672     0.150
    49.466   644.672     0.150
    49.466   959.672     0.150
    49.808   519.672     0.150
    51.040   546.672     0.150
    51.040   546.672     0.150
    51.040   979.672     0.150
    52.180   550.672     0.150
    52.180  1002.672     0.150
    52.180   550.672     0.150
    52.180     5.000     0.150
    52.180   668.672     0.150
    52.180   992.672     0.150
    52.180  1002.672     0.150
    52.180  1137.672     0.150
    52.383   738.672     0.150
    52.383   550.672     0.150
    52.383   672.672     0.150
    52.383   738.672     0.150
    52.383   996.672     0.150
    53.558   552.969     0.150
    54.030   563.969     0.150
    54.030   633.172     0.150
    54.030   691.672     0.150
    54.030  1017.672     0.150
    54.030  1026.672     0.150
    54.257   566.672     0.150
    54.257  1260.672     0.150
    54.373   565.672     0.150
    54.962   571.273     0.150
    55.241   578.672     0.150
    55.946   577.875     0.150
    55.946     5.000     0.150
    55.996   577.969     0.150
    55.996   582.773     0.150
    55.996   614.273     0.150
    55.996   577.969     0.150
    56.348   582.672     0.150
    56.375   627.875     0.150
    56.375   580.969     0.150
    56.375     4.500     0.150
    56.375   710.672     0.150
    56.940   787.672     0.150
    57.067   586.172     0.150
    57.067   660.672     0.150
    57.067   670.672     0.150
    57.067  1299.672     0.150
    57.067  1422.672     0.150
    57.067   586.172     0.150
    57.436    12.000     0.150
    57.436   589.172     0.150
    57.436     4.500     0.150
    57.746   596.172     0.150
    57.875   628.672     0.150
    59.132     5.102     0.150
    59.132   813.672     0.150
    59.241   610.672     0.150
    59.329   597.672     0.150
    59.675     5.000     0.150
    59.675   620.070     0.150
    59.707     5.102     0.150
    59.707   822.875     0.150
    59.717   675.672     0.150
    59.754   608.672     0.150
    59.865     5.000     0.150
    59.919     4.898     0.150
    59.919   824.773     0.150
    61.393   627.672     0.150
    63.595   630.070     0.150
    63.903   630.672     0.150
    65.852   646.672     0.150
    67.872   697.172     0.150
    67.872   700.672     0.150
    67.872  1872.672     0.150
    67.872  1885.172     0.150
    69.838   672.172     0.150
    71.188   681.602     0.150
    71.312   685.672     0.150
    72.533   691.875     0.150
    72.858   692.320     0.150
    73.360   694.766     0.150
    73.555   694.672     0.150
    74.209   698.570     0.150
    74.527   701.422     0.150
    74.594   701.602     0.150
    77.261   715.672     0.150
    77.527   748.875     0.150
    78.111   724.172     0.150
    79.195   730.172     0.150
    81.296   737.469     0.150
    81.296     5.703     0.150
    82.232   743.414     0.150
   139.447  1158.469     0.150
   139.447  1344.969     0.150
   139.692  1152.469     0.150
   146.466  1179.273     0.150
     0.324     6.719     0.150
     0.324    11.320     0.150
     1.244    22.820     0.150
     2.447    40.719     0.150
     2.447    43.320     0.150
     2.447    74.922     0.150
     2.675    49.117     0.150
     2.675    83.523     0.150
     3.831    60.320     0.150
     3.831    69.117     0.150
     3.831   120.023     0.150
     4.214    65.922     0.150
     4.214    77.320     0.150
     4.214   132.320     0.150
     4.767    86.117     0.150
     4.767   149.117     0.150
     5.285    96.719     0.150
     5.285   164.617     0.150
     5.441    82.320     0.150
     5.441    99.320     0.150
     5.441   171.117     0.150
     7.701   239.719     0.150
     2.451    41.461     0.150
     2.451    44.164     0.150
     2.451    74.867     0.150
     2.573    47.961     0.150
     2.573    81.961     0.150
     2.684    45.664     0.150
     2.684    49.664     0.150
     2.684    84.461     0.150
     3.839    60.961     0.150
     3.839    70.961     0.150
     3.839   121.164     0.150
     4.222    66.164     0.150
     4.222    77.164     0.150
     4.222   130.664     0.150
     4.775    72.367     0.150
     4.775    86.867     0.150
     4.775   149.164     0.150
     5.292    96.961     0.150
     5.292   166.164     0.150
     5.449    82.766     0.150
     5.449   100.164     0.150
     5.449   142.867     0.150
     5.449   171.461     0.150
     2.490    74.320     0.150
     2.490    88.422     0.150
     4.222    67.625     0.150
     5.449    84.922     0.150
     0.281     6.182     0.150
     0.281     9.982     0.150
     1.284    23.682     0.150
     1.985    62.582     0.150
     2.466   107.082     0.150
     2.466    39.982     0.150
     2.466    43.582     0.150
     2.466    75.281     0.150
     2.466   107.082     0.150
     2.499    87.582     0.150
     2.499    41.383     0.150
     2.499    44.883     0.150
     2.499    78.482     0.150
     2.499    87.582     0.150
     2.721    50.582     0.150
     2.721    84.482     0.150
     3.873    97.482     0.150
     3.873    69.582     0.150
     3.873    97.482     0.150
     3.873   121.182     0.150
     4.259   110.082     0.150
     4.259    77.383     0.150
     4.259   110.082     0.150
     4.259   133.182     0.150
     4.808    87.482     0.150
     4.808   149.682     0.150
     5.328    80.883     0.150
     5.328   166.883     0.150
     5.487   100.682     0.150
     5.487   144.582     0.150
     5.487   172.182     0.150
     0.323    10.066     0.150
     1.251    27.969     0.150
     1.252    23.066     0.150
     1.252    23.066     0.150
     1.252    27.969     0.150
     2.456    51.969     0.150
     2.486    41.270     0.150
     2.486    41.270     0.150
     2.572    63.168     0.150
     3.838    92.969     0.150
     4.219   106.969     0.150
     4.774   136.168     0.150
     5.446    85.168     0.150
     5.446   137.668     0.150
     6.648   166.168     0.150
     7.701   140.566     0.150
     7.701   216.270     0.150
     7.758   180.770     0.150
     7.758   221.969     0.150
     0.284     9.909     0.150
     1.268    23.409     0.150
     2.448    41.108     0.150
     2.448    43.508     0.150
     2.448    75.909     0.150
     2.513    87.208     0.150
     2.513    41.708     0.150
     2.513    46.508     0.150
     2.513    78.708     0.150
     2.513    87.208     0.150
     2.590    47.309     0.150
     2.590    81.809     0.150
     2.708    49.309     0.150
     2.708    84.008     0.150
     3.857    58.309     0.150
     3.857    58.309     0.150
     3.857    69.708     0.150
     3.857   102.708     0.150
     3.857   121.108     0.150
     4.246    65.708     0.150
     4.246    78.708     0.150
     4.246   133.108     0.150
     4.792    87.008     0.150
     4.792   149.008     0.150
     5.325   167.809     0.150
     0.310    10.188     0.150
     2.453    41.287     0.150
     2.453    44.188     0.150
     2.453    70.688     0.150
     2.453    75.287     0.150
     2.494    48.387     0.150
     2.494    87.387     0.150
     2.494    41.988     0.150
     2.494    45.188     0.150
     2.494    48.387     0.150
     2.494    78.988     0.150
     2.494    87.387     0.150
     2.578    47.688     0.150
     2.578    81.688     0.150
     2.690    72.787     0.150
     2.690    43.988     0.150
     2.690    48.787     0.150
     2.690    72.787     0.150
     2.690    83.988     0.150
     3.504   109.188     0.150
     3.844    59.988     0.150
     3.844    69.488     0.150
     3.844   121.088     0.150
     4.228    65.688     0.150
     4.228    77.188     0.150
     4.228   113.688     0.150
     4.228   132.287     0.150
     4.780    86.988     0.150
     4.780   129.787     0.150
     4.780   148.988     0.150
     5.298   150.188     0.150
     5.298   150.188     0.150
     5.298   165.287     0.150
     5.456    81.988     0.150
     5.456    99.988     0.150
     5.456   171.688     0.150
     0.320     6.672     0.150
     0.320    10.773     0.150
     1.247    40.070     0.150
     1.248    42.977     0.150
     2.448    49.273     0.150
     2.448    67.172     0.150
     2.448    40.672     0.150
     2.448    43.875     0.150
     2.448    49.273     0.150
     2.448    67.172     0.150
     2.448    74.672     0.150
     2.494    68.773     0.150
     2.494    86.375     0.150
     2.494    41.375     0.150
     2.494    45.570     0.150
     2.494    68.773     0.150
     2.494    78.172     0.150
     2.494    86.375     0.150
     2.568    47.977     0.150
     2.568    81.875     0.150
     2.679    44.375     0.150
     2.679    48.875     0.150
     2.679    73.672     0.150
     2.679    83.977     0.150
     3.835    60.172     0.150
     3.835    69.375     0.150
     3.835   104.570     0.150
     3.835   120.273     0.150
     4.217   108.570     0.150
     4.217    65.172     0.150
     4.217    76.875     0.150
     4.217   108.570     0.150
     4.217   131.875     0.150
     4.770    83.977     0.150
     4.770    83.977     0.150
     4.770   148.570     0.150
     5.290   165.570     0.150
     5.445    81.977     0.150
     5.445    99.273     0.150
     5.445   169.570     0.150
     6.646   206.672     0.150
     0.308    11.117     0.150
     0.308    11.117     0.150
     2.468    40.816     0.150
     2.468    44.816     0.150
     2.468    76.717     0.150
     2.483    41.417     0.150
     2.483    50.217     0.150
     2.483    41.417     0.150
     2.483    45.517     0.150
     2.483    50.217     0.150
     2.483    78.117     0.150
     2.591    52.917     0.150
     2.591    48.117     0.150
     2.591    52.917     0.150
     2.591    82.017     0.150
     2.700    45.417     0.150
     2.700    49.316     0.150
     2.700    85.117     0.150
     3.517   109.417     0.150
     3.857    63.517     0.150
     3.857    63.517     0.150
     3.857    70.217     0.150
     3.857   120.517     0.150
     4.239    68.717     0.150
     4.239   104.717     0.150
     4.239    68.717     0.150
     4.239    77.717     0.150
     4.239   104.717     0.150
     4.239   132.417     0.150
     4.793    88.517     0.150
     4.793   126.417     0.150
     4.793   150.017     0.150
     5.301    96.517     0.150
     5.301   167.417     0.150
     6.668   209.017     0.150
     7.715   240.517     0.150
     7.777   241.017     0.150
     0.309    10.467     0.150
     1.264    24.068     0.150
     1.265    24.068     0.150
     1.265    24.068     0.150
     1.265    27.168     0.150
     2.461    40.268     0.150
     2.461    44.367     0.150
     2.461    75.467     0.150
     2.488    69.068     0.150
     2.488    73.068     0.150
     2.488    86.068     0.150
     2.488    41.367     0.150
     2.488    45.668     0.150
     2.488    69.068     0.150
     2.488    73.068     0.150
     2.488    79.467     0.150
     2.488    86.068     0.150
     2.586    48.068     0.150
     2.586    81.867     0.150
     2.696    48.068     0.150
     2.696    44.168     0.150
     2.696    48.068     0.150
     2.696    76.568     0.150
     2.696    84.668     0.150
     3.511   109.467     0.150
     3.852    62.768     0.150
     3.852    62.768     0.150
     3.852    69.467     0.150
     3.852   119.568     0.150
     4.234   105.568     0.150
     4.234    66.268     0.150
     4.234    77.367     0.150
     4.234   105.568     0.150
     4.234   133.068     0.150
     4.787    87.668     0.150
     4.787   149.768     0.150
     5.300   101.268     0.150
     5.300   101.268     0.150
     5.300   165.768     0.150
     5.461   100.168     0.150
     5.461   171.367     0.150
     6.663   207.367     0.150
     7.715   240.367     0.150
     7.773   241.068     0.150
     0.613    11.426     0.150
     0.613    11.426     0.150
     1.209    23.426     0.150
     1.209    23.426     0.150
     1.209    38.824     0.150
     1.209    38.824     0.150
     1.792    32.625     0.150
     1.792    32.625     0.150
     1.792    34.023     0.150
     1.792    56.125     0.150
     1.792    56.824     0.150
     1.811    59.227     0.150
     1.811    32.625     0.150
     1.811    34.227     0.150
     1.811    57.625     0.150
     1.811    59.227     0.150
     2.207    36.824     0.150
     2.207    40.023     0.150
     2.207    68.324     0.150
     2.574    42.625     0.150
     2.574    42.625     0.150
     2.574    46.625     0.150
     2.574    74.625     0.150
     2.574    81.625     0.150
     3.036    59.125     0.150
     3.036    96.625     0.150
     3.036    50.125     0.150
     3.036    55.227     0.150
     3.036    59.125     0.150
     3.036    96.625     0.150
     3.334    54.426     0.150
     3.334    61.625     0.150
     3.334   104.824     0.150
     3.979    62.926     0.150
     3.979    72.625     0.150
     3.979   107.727     0.150
     3.979   124.926     0.150
     4.489    71.125     0.150
     4.489    82.625     0.150
     4.489   121.125     0.150
     4.489   142.824     0.150
     4.540    83.625     0.150
     4.540    70.523     0.150
     4.540    83.625     0.150
     4.540   142.523     0.150
     6.922   217.227     0.150
     0.280     5.516     0.150
     0.280     6.117     0.150
     0.867    14.516     0.150
     2.461    39.914     0.150
     2.461    39.914     0.150
     2.504    41.715     0.150
     2.504    41.715     0.150
     2.504    73.516     0.150
     2.719    45.516     0.150
     2.719    45.516     0.150
     3.869    61.016     0.150
     4.256    66.617     0.150
     4.256    66.617     0.150
     4.256    80.016     0.150
     4.804    74.215     0.150
     4.804    74.215     0.150
     5.329    80.117     0.150
     5.329    80.117     0.150
     5.329    85.215     0.150
     5.329    98.117     0.150
     5.329    79.516     0.150
     5.329    98.516     0.150
     5.329   164.516     0.150
     5.486    83.414     0.150
     5.486    83.414     0.150
     5.486    88.316     0.150
     5.486   104.516     0.150
     6.053   110.715     0.150
     6.686    99.215     0.150
     6.686    99.215     0.150
     6.686   122.316     0.150
     6.686   128.516     0.150
     6.686   190.316     0.150
     7.744   113.516     0.150
     7.744   113.516     0.150
     7.744   139.215     0.150
     7.744   146.516     0.150
     7.796   180.016     0.150
     7.796   196.414     0.150
     7.796   114.516     0.150
     7.796   140.316     0.150
     7.796   195.816     0.150
     7.796   247.316     0.150
     8.030   113.715     0.150
     8.030   113.715     0.150
     8.076   118.516     0.150
     8.076   118.516     0.150
     8.076   216.516     0.150
     8.076   241.016     0.150
     9.136   173.516     0.150
     9.136   277.016     0.150
     9.136   132.016     0.150
     9.136   230.516     0.150
     9.778   185.016     0.150
     9.778   244.516     0.150
     9.778   141.516     0.150
     9.778   185.016     0.150
     9.778   244.516     0.150
     9.778   306.117     0.150
    10.262   153.516     0.150
    10.262   187.516     0.150
    10.773   155.516     0.150
    10.773   155.516     0.150
    11.143   160.016     0.150
    11.143   160.016     0.150
    11.143   305.016     0.150
    11.143   326.516     0.150
    11.320   162.516     0.150
    11.320   162.516     0.150
    11.320   322.016     0.150
    11.320   355.516     0.150
    13.718   193.516     0.150
    13.718   193.516     0.150
    13.718   204.516     0.150
    14.099   358.516     0.150
    15.281   216.715     0.150
    15.281   232.016     0.150
    16.373   231.516     0.150
    16.679   237.016     0.150
    16.679   237.016     0.150
    16.893   238.516     0.150
    16.893   255.516     0.150
    17.930   252.516     0.150
    17.930    13.000     0.150
    19.320   268.516     0.150
    20.152   275.516     0.150
    20.152   497.516     0.150
    20.467   280.316     0.150
    21.000   285.516     0.150
    21.000     5.000     0.150
    21.591   522.414     0.150
    21.716   290.516     0.150
    22.693   304.316     0.150
    22.693   304.316     0.150
    23.027   307.715     0.150
    23.440   306.516     0.150
    23.440   306.516     0.150
    23.440   564.516     0.150
    23.466   312.016     0.150
    24.279   316.516     0.150
    24.279   574.516     0.150
    24.615   322.316     0.150
    25.658   331.016     0.150
    25.658   596.516     0.150
    26.237   332.516     0.150
    26.237   332.516     0.150
    27.256   345.516     0.150
    27.256   624.516     0.150
    27.607   349.914     0.150
    27.607   349.914     0.150
    30.040   368.715     0.150
    30.040   426.516     0.150
    30.040   550.516     0.150
    30.040   664.516     0.150
    30.040   770.516     0.150
    30.665   675.516     0.150
    30.665   375.516     0.150
    30.665   675.516     0.150
    31.264   382.516     0.150
    31.873   465.516     0.150
    31.873   820.516     0.150
    31.873   385.316     0.150
    31.873   458.016     0.150
    31.873   465.516     0.150
    31.873   696.516     0.150
    31.873   804.516     0.150
    31.873   820.516     0.150
    32.257   391.516     0.150
    32.257   482.516     0.150
    32.902   399.215     0.150
    33.395   395.516     0.150
    33.395   395.516     0.150
    36.329   652.516     0.150
    36.329   932.516     0.150
    37.255   430.914     0.150
    37.255   516.016     0.150
    37.255   771.117     0.150
    38.897   444.945     0.150
    38.897   444.844     0.150
    40.620   460.215     0.150
    41.776   470.316     0.150
    42.284   580.516     0.150
    42.284   610.516     0.150
    42.284  1064.516     0.150
    42.284   472.516     0.150
    42.284   573.516     0.150
    42.284   580.516     0.150
    42.284   610.516     0.150
    42.284   854.516     0.150
    42.284  1064.516     0.150
    43.038   475.414     0.150
    43.079   880.516     0.150
    43.079   480.516     0.150
    43.079   590.016     0.150
    43.079   865.516     0.150
    43.079   880.516     0.150
    43.079  1074.516     0.150
    43.141   480.516     0.150
    43.141   616.516     0.150
    43.141   866.516     0.150
    43.141  1096.516     0.150
    43.267   481.117     0.150
    43.583   844.516     0.150
    43.831     9.359     0.150
    44.028   487.414     0.150
    44.881   494.617     0.150
    45.453   500.516     0.150
    45.453   500.516     0.150
    45.453  1148.516     0.150
    45.994   916.516     0.150
    45.994   508.016     0.150
    45.994   916.516     0.150
    47.104   503.715     0.150
    47.080   664.516     0.150
    47.080   942.516     0.150
    47.080  1196.516     0.150
    47.080   512.516     0.150
    47.080   624.516     0.150
    47.080   664.516     0.150
    47.080   926.516     0.150
    47.080   942.516     0.150
    47.080  1196.516     0.150
    47.329   941.617     0.150
    47.329   515.695     0.150
    47.329   625.016     0.150
    47.329   932.414     0.150
    47.329   941.617     0.150
    47.446   924.516     0.150
    47.446  1132.516     0.150
    47.446   514.516     0.150
    47.446   624.516     0.150
    47.446   924.516     0.150
    47.446  1132.516     0.150
    47.494   942.516     0.150
    47.963   518.367     0.150
    48.373   527.516     0.150
    49.072   714.516     0.150
    49.137   544.516     0.150
    49.137   972.516     0.150
    49.137  1152.516     0.150
    49.137   530.516     0.150
    49.137    14.000     0.150
    49.137   608.516     0.150
    49.137   640.516     0.150
    49.137   955.516     0.150
    49.137   972.516     0.150
    49.137  1113.516     0.150
    49.137  1152.516     0.150
    49.464   960.516     0.150
    49.464   978.516     0.150
    49.464   531.516     0.150
    49.464   648.516     0.150
    49.464   960.516     0.150
    49.464   978.516     0.150
    50.445   532.316     0.150
    51.037   542.516     0.150
    51.037   664.516     0.150
    51.037   981.516     0.150
    51.220  1008.516     0.150
    51.803     9.969     0.150
    51.834   544.035     0.150
    51.955   544.984     0.150
    51.956   542.516     0.150
    51.956   993.516     0.150
    52.176   550.516     0.150
    52.176   998.516     0.150
    52.176   550.516     0.150
    52.176   625.516     0.150
    52.176   673.516     0.150
    52.176   996.516     0.150
    52.176   998.516     0.150
    52.286   553.316     0.150
    52.378   550.516     0.150
    52.378     4.000     0.150
    52.378   622.516     0.150
    52.378   670.516     0.150
    52.378   996.516     0.150
    52.378  1216.516     0.150
    53.273   549.516     0.150
    53.759   568.516     0.150
    54.018    14.699     0.150
    54.025   761.516     0.150
    54.025  1036.516     0.150
    54.025  1353.516     0.150
    54.025   564.516     0.150
    54.025   693.516     0.150
    54.025   761.516     0.150
    54.025  1017.516     0.150
    54.025  1029.516     0.150
    54.025  1036.516     0.150
    54.025  1353.516     0.150
    54.357   566.516     0.150
    54.525   687.715     0.150
    54.752  1025.516     0.150
    54.956   571.516     0.150
    54.956   744.516     0.150
    54.991   571.805     0.150
    55.399   575.945     0.150
    55.939   577.957     0.150
    55.939   578.016     0.150
    55.939     4.801     0.150
    55.939   636.516     0.150
    55.939  1049.516     0.150
    55.989   578.004     0.150
    55.989   577.914     0.150
    55.989   582.516     0.150
    55.989   765.516     0.150
    55.989  1047.516     0.150
    55.989  1070.516     0.150
    55.989  1261.516     0.150
    55.989  1269.516     0.150
    55.989   577.914     0.150
    55.989  1047.516     0.150
    56.350   582.516     0.150
    56.368   581.715     0.150
    56.368     4.102     0.150
    56.408     1.000     0.150
    56.555   569.516     0.150
    56.646     0.902     0.150
    57.059   586.387     0.150
    57.059   586.414     0.150
    57.059   692.516     0.150
    57.059   727.516     0.150
    57.059  1280.516     0.150
    57.059   586.414     0.150
    57.087   582.516     0.150
    57.429   618.516     0.150
    57.961   592.754     0.150
    58.390  1555.516     0.150
    58.550  1380.516     0.150
    59.363   607.516     0.150
    59.438     0.500     0.150
    59.438   810.516     0.150
    59.438  1352.516     0.150
    59.438  1491.516     0.150
    59.668     4.797     0.150
    59.700     4.801     0.150
    59.710     1.098     0.150
    59.912     4.703     0.150
    60.020   820.516     0.150
    60.020  1128.516     0.150
    60.020  1472.516     0.150
    60.375   610.438     0.150
    60.408   604.516     0.150
    60.408    10.102     0.150
    63.345   628.316     0.150
    63.692   873.516     0.150
    64.015   631.715     0.150
    64.561   636.316     0.150
    64.915   639.516     0.150
    65.006   640.414     0.150
    65.517   644.277     0.150
    65.517   644.215     0.150
    65.838   645.816     0.150
    65.963   646.516     0.150
    67.354   651.254     0.150
    67.864   692.016     0.150
    67.864   693.516     0.150
    67.864   698.016     0.150
    67.864   927.516     0.150
    67.864  1240.516     0.150
    68.451   657.785     0.150
    69.473   663.996     0.150
    70.207   668.438     0.150
    71.058   674.316     0.150
    71.115   673.977     0.150
    71.180   675.016     0.150
    71.811   683.016     0.150
    71.816   678.715     0.150
    71.885   679.465     0.150
    72.603   683.277     0.150
    72.718   683.387     0.150
    72.851   685.715     0.150
    73.352   687.477     0.150
    74.201   692.457     0.150
    74.225   692.477     0.150
    74.371   692.824     0.150
    74.519   693.895     0.150
    74.541   694.555     0.150
    74.586   694.035     0.150
    74.720   701.117     0.150
    75.116   697.875     0.150
    75.145   697.695     0.150
    75.658   701.355     0.150
    76.648   711.914     0.150
    77.245   715.516     0.150
    77.330   716.215     0.150
    78.441   721.516     0.150
    81.281   737.516     0.150
    82.217   744.477     0.150
    82.217   748.707     0.150
   112.951  1104.516     0.150
   124.318  1138.516     0.150
   139.397  1158.215     0.150
   146.481  1177.777     0.150
     0.286     6.219     0.150
     0.286     6.219     0.150
     2.463    39.418     0.150
     2.463    43.418     0.150
     2.463    75.617     0.150
     2.499    41.418     0.150
     2.499    45.418     0.150
     2.499    78.418     0.150
     2.715    44.418     0.150
     2.715    49.617     0.150
     2.715    84.816     0.150
     3.526   111.418     0.150
     3.867    61.219     0.150
     3.867    70.617     0.150
     3.867   122.219     0.150
     4.253    66.020     0.150
     4.253    77.418     0.150
     4.253   133.219     0.150
     4.803    72.020     0.150
     4.803    87.418     0.150
     4.803   150.117     0.150
     5.323   103.418     0.150
     5.323    96.617     0.150
     5.323   166.617     0.150
     5.482   147.020     0.150
     5.482    83.020     0.150
     5.482   100.617     0.150
     5.482   147.020     0.150
     5.482   172.418     0.150
     6.682   114.418     0.150
     6.682   114.418     0.150
     6.682   210.418     0.150
     7.738   112.418     0.150
     7.738   136.418     0.150
     7.738   242.617     0.150
     2.422    38.023     0.150
     2.422    38.023     0.150
     2.560    49.125     0.150
     2.526    41.328     0.150
     2.526    41.328     0.150
     2.680    42.727     0.150
     2.680    65.125     0.150
     3.485    74.125     0.150
     3.827    63.523     0.150
     3.827    73.023     0.150
     3.827   108.125     0.150
     4.217    66.125     0.150
     4.217    69.023     0.150
     4.217    80.125     0.150
     4.217    88.922     0.150
     4.217   104.125     0.150
     4.762   104.625     0.150
     5.309    89.125     0.150
     5.309    99.523     0.150
     5.309   163.125     0.150
     5.450   101.125     0.150
     5.450   118.125     0.150
     5.450   174.125     0.150
     6.647   123.023     0.150
     6.647   185.828     0.150
     6.647   212.125     0.150
     7.758   118.125     0.150
     7.758   141.422     0.150
     7.758   222.125     0.150
     7.726   117.125     0.150
     7.726   174.422     0.150
     7.726   221.523     0.150
     7.726   232.922     0.150
     8.039   154.125     0.150
     9.097   174.125     0.150
     9.097   259.328     0.150
     9.097   274.422     0.150
     9.740   214.023     0.150
     9.740   266.328     0.150
     9.740   300.523     0.150
    10.737   159.125     0.150
    10.737   195.125     0.150
    10.737   256.125     0.150
    10.737   301.125     0.150
     0.313     7.289     0.150
     0.313    11.195     0.150
     2.418    38.992     0.150
     2.418    42.492     0.150
     2.418    72.492     0.150
     2.524    49.992     0.150
     2.524    41.391     0.150
     2.524    44.992     0.150
     2.524    49.992     0.150
     2.524    71.289     0.150
     2.524    79.492     0.150
     2.551    46.094     0.150
     2.551    80.289     0.150
     2.670    43.492     0.150
     2.670    43.492     0.150
     2.670    53.992     0.150
     3.476    70.992     0.150
     3.476    70.992     0.150
     3.476   107.992     0.150
     3.818    59.195     0.150
     3.818    67.992     0.150
     3.818   100.992     0.150
     3.818   118.789     0.150
     4.207   105.492     0.150
     4.207    65.195     0.150
     4.207    76.891     0.150
     4.207   105.492     0.150
     4.207   131.789     0.150
     4.753    89.992     0.150
     4.753    73.195     0.150
     4.753    85.289     0.150
     4.753    89.992     0.150
     4.753   126.992     0.150
     4.753   148.094     0.150
     5.299    95.195     0.150
     5.299   139.492     0.150
     5.299   165.594     0.150
     5.439   118.992     0.150
     5.439    81.992     0.150
     5.439    98.992     0.150
     5.439   118.992     0.150
     5.439   142.992     0.150
     5.439   170.789     0.150
     6.636   101.992     0.150
     6.636   211.992     0.150
     6.636   101.992     0.150
     6.636   207.789     0.150
     6.636   211.992     0.150
     7.716   138.789     0.150
     7.716   138.789     0.150
     7.716   239.492     0.150
     7.748   229.992     0.150
     7.748   229.992     0.150
     7.748   240.992     0.150
     9.087   283.992     0.150
     0.319     5.754     0.150
     0.319     5.754     0.150
     0.319     5.754     0.150
     0.319     7.453     0.150
     0.319    10.754     0.150
     0.826    15.754     0.150
     0.826    27.754     0.150
     1.271    22.754     0.150
     1.271    23.953     0.150
     1.272    22.754     0.150
     2.477    45.254     0.150
     2.477    76.055     0.150
     2.469    41.254     0.150
     2.469    88.754     0.150
     2.469    41.254     0.150
     2.469    45.754     0.150
     2.469    79.754     0.150
     2.592    83.754     0.150
     2.592    48.953     0.150
     2.592    83.754     0.150
     3.857    65.754     0.150
     3.857    61.754     0.150
     3.857    65.754     0.150
     3.857    71.055     0.150
     3.857   105.754     0.150
     3.857   122.453     0.150
     4.235   117.754     0.150
     4.235    66.754     0.150
     4.235    77.754     0.150
     4.235   117.754     0.150
     4.235   133.754     0.150
     0.297    10.055     0.150
     2.512    45.555     0.150
     2.512    77.555     0.150
     2.454    44.555     0.150
     2.454    78.055     0.150
     2.635    48.852     0.150
     2.635    76.055     0.150
     2.635    83.852     0.150
     2.738    46.156     0.150
     2.738    50.453     0.150
     2.738    85.758     0.150
     3.900    62.156     0.150
     3.900    71.156     0.150
     3.900   122.055     0.150
     4.277    67.555     0.150
     4.277    78.156     0.150
     4.277   134.055     0.150
     4.836    74.453     0.150
     4.836    87.656     0.150
     4.836   150.156     0.150
     5.316    97.258     0.150
     5.316   167.555     0.150
     5.499    83.656     0.150
     5.499   100.055     0.150
     5.499   172.656     0.150
     0.207     4.511     0.150
     0.207     4.511     0.150
     0.207     5.511     0.150
     2.512    41.511     0.150
     2.512    41.511     0.150
     2.512    44.610     0.150
     2.512    44.610     0.150
     2.688    78.511     0.150
     2.688   106.410     0.150
     2.810    65.610     0.150
     2.810    74.811     0.150
     3.956   100.110     0.150
     6.777   185.011     0.150
     6.777   191.211     0.150
     7.888   142.610     0.150
     7.888   224.410     0.150
     8.167   148.811     0.150
     9.870   150.110     0.150
     9.870   179.311     0.150
    10.353   155.410     0.150
    10.353   186.811     0.150
    10.353   260.311     0.150
    10.865   160.511     0.150
    10.865   198.311     0.150
    10.865   272.910     0.150
    10.865   280.610     0.150
    11.234   165.311     0.150
    11.234   194.511     0.150
    11.234   347.410     0.150
    11.409   322.711     0.150
     0.856    32.750     0.150
     2.442    46.449     0.150
     2.513    41.350     0.150
     2.513    88.150     0.150
     3.824    45.949     0.150
     5.584   104.051     0.150
     7.100   100.449     0.150
     0.611    12.039     0.150
     0.611    12.039     0.150
     0.611    14.539     0.150
     0.584    16.339     0.150
     1.337    30.639     0.150
     2.161    45.339     0.150
     2.633    87.039     0.150
     2.638    54.438     0.150
     2.638    92.238     0.150
     2.699    91.139     0.150
     3.878    75.139     0.150
     3.878   123.238     0.150
     4.178    65.039     0.150
     4.178    80.139     0.150
     4.178   127.938     0.150
     5.355    30.639     0.150
     5.355    68.139     0.150
     6.599   168.139     0.150
     7.447   188.438     0.150
     7.447   211.139     0.150
     7.447   229.139     0.150
     0.266     5.414     0.150
     0.266     5.414     0.150
     1.329    25.211     0.150
     1.329    25.211     0.150
     2.507    41.008     0.150
     2.507    41.008     0.150
     2.475    37.211     0.150
     3.915    65.008     0.150
     4.298    66.211     0.150
     4.298    69.711     0.150
     4.851    78.211     0.150
     5.346   163.414     0.150
     5.523    87.008     0.150
     6.727   102.609     0.150
     6.727   208.609     0.150
     6.727   214.609     0.150
     7.836   119.109     0.150
     7.836   149.414     0.150
    10.304   190.414     0.150
    10.304   273.414     0.150
     0.552    10.742     0.150
     0.552    10.742     0.150
     0.580    11.141     0.150
     0.580    19.441     0.150
     1.256    24.242     0.150
     1.256    24.242     0.150
     1.256    24.742     0.150
     1.256    41.840     0.150
     1.742    33.441     0.150
     1.742    56.441     0.150
     1.731    32.840     0.150
     1.731    32.840     0.150
     2.157    38.641     0.150
     2.157    38.641     0.150
     2.157    60.941     0.150
     2.633    44.840     0.150
     2.633    48.840     0.150
     2.633    76.441     0.150
     2.633    84.141     0.150
     2.968    52.242     0.150
     2.968    57.441     0.150
     2.968    87.441     0.150
     2.968    95.043     0.150
     2.968    52.242     0.150
     2.968    57.441     0.150
     2.968    87.441     0.150
     2.968    95.043     0.150
     3.273    57.441     0.150
     3.273    61.441     0.150
     3.273    53.742     0.150
     3.273    57.441     0.150
     3.273    61.441     0.150
     3.273   103.641     0.150
     3.911    73.641     0.150
     3.911    64.441     0.150
     3.911    73.641     0.150
     3.911   123.141     0.150
     4.470   128.141     0.150
     4.470    72.242     0.150
     4.470   128.141     0.150
     4.470   140.441     0.150
     6.904   129.742     0.150
     6.904   101.242     0.150
     6.904   129.742     0.150
     6.904   217.941     0.150
     2.300    45.805     0.150
     2.300    60.906     0.150
     2.341    41.707     0.150
     2.341    41.707     0.150
     2.449    66.605     0.150
     3.500    99.105     0.150
     3.841    76.906     0.150
     7.341 -1607.695     0.150
     7.341 -1600.395     0.150
     7.373   225.605     0.150
     2.866    45.581     0.150
     2.866    45.581     0.150
     2.866    94.981     0.150
     3.011    59.581     0.150
     3.011    86.682     0.150
     3.233    52.381     0.150
     3.233    54.781     0.150
     3.233    64.381     0.150
     3.953    63.981     0.150
     4.284    66.781     0.150
     4.284    72.682     0.150
     4.284    82.381     0.150
     4.284   117.581     0.150
     4.755    73.682     0.150
     4.755    90.581     0.150
     5.202    51.581     0.150
     5.202   100.281     0.150
     5.202   123.081     0.150
     5.202   142.281     0.150
     5.202   162.881     0.150
     6.017   186.182     0.150
     5.933   108.981     0.150
     5.933   183.682     0.150
     6.023   114.081     0.150
     6.023   171.981     0.150
     7.183   110.581     0.150
     7.183   128.682     0.150
     7.183   188.581     0.150
     7.183   225.581     0.150
     7.183   254.981     0.150
     8.307   125.981     0.150
     8.307   151.081     0.150
     8.307   221.781     0.150
     8.307   235.281     0.150
     8.307   247.581     0.150
     8.307   257.682     0.150
     8.307   285.281     0.150
     8.347   151.381     0.150
     8.347   170.682     0.150
     8.347   214.381     0.150
     8.611   248.781     0.150
     9.635   182.581     0.150
     9.635   258.981     0.150
    10.285   235.781     0.150
    10.285   307.381     0.150
    10.285   323.182     0.150
    11.305   165.281     0.150
    11.305   206.581     0.150
    11.305   280.981     0.150
    11.305   311.781     0.150
    11.305   356.981     0.150
    11.618   188.981     0.150
    11.618   288.981     0.150
    11.618   357.981     0.150
    11.755   172.981     0.150
    11.755   213.581     0.150
    11.755   271.682     0.150
    19.259   266.781     0.150
    19.896   272.981     0.150
    20.995   288.481     0.150
    21.593   686.281     0.150
    23.297   311.281     0.150
    23.297     7.000     0.150
    47.519   517.581     0.150
    53.755   559.481     0.150
    53.755   560.881     0.150
    55.829   572.781     0.150
    55.869   576.781     0.150
    55.869   584.781     0.150
    56.937   583.781     0.150
    57.330   616.281     0.150
    60.423   606.081     0.150
    63.015   624.981     0.150
    73.811   693.781     0.150
    81.555   737.981     0.150
     0.510    10.039     0.150
     0.510    10.039     0.150
     1.352    25.539     0.150
     1.352    25.539     0.150
     2.233    67.539     0.150
     2.233    38.539     0.150
     2.233    41.539     0.150
     2.233    67.539     0.150
     2.233    71.539     0.150
     2.665    43.836     0.150
     2.665    48.539     0.150
     2.665    74.641     0.150
     2.665    81.742     0.150
     2.659    48.938     0.150
     2.659    84.039     0.150
     2.692    45.539     0.150
     2.692    49.641     0.150
     2.692    78.539     0.150
     2.692    84.539     0.150
     3.911    62.141     0.150
     3.911    70.641     0.150
     3.911   106.641     0.150
     3.911   122.141     0.150
     4.234    67.641     0.150
     4.234    67.641     0.150
     4.234    79.039     0.150
     4.234   114.539     0.150
     4.234   133.539     0.150
     4.852    88.539     0.150
     4.852   129.539     0.150
     4.852   151.539     0.150
     5.423   169.742     0.150
     0.758    14.688     0.150
     0.758    14.688     0.150
     0.846    17.484     0.150
     0.846    17.484     0.150
     0.846    17.484     0.150
     3.409   108.688     0.150
     3.525   115.188     0.150
     4.897    91.891     0.150
     0.664    12.984     0.150
     0.664    12.984     0.150
     1.073    20.188     0.150
     1.073    20.188     0.150
     2.464    44.188     0.150
     2.464    44.188     0.150
     2.341    39.984     0.150
     2.341    39.984     0.150
     3.945   125.984     0.150
     4.209   113.484     0.150
     4.945   155.188     0.150
     5.144    83.188     0.150
     5.144   161.188     0.150
     5.666   176.781     0.150
     7.399   224.984     0.150
     7.362   135.984     0.150
     7.362   231.781     0.150
     7.470   139.781     0.150
     7.470   234.188     0.150
    18.327   442.188     0.150
    18.814   593.883     0.150
     0.764    14.816     0.150
     0.764    14.816     0.150
     0.764    18.816     0.150
     0.913    17.918     0.150
     0.913    17.918     0.150
     0.913    33.719     0.150
     0.915    29.117     0.150
     2.210    42.617     0.150
     2.210    74.918     0.150
     2.210    38.418     0.150
     2.210    42.617     0.150
     2.210    70.516     0.150
     2.210    74.918     0.150
     2.251    37.516     0.150
     2.251    40.219     0.150
     2.251    37.516     0.150
     2.251    40.219     0.150
     2.251    69.516     0.150
     2.339    41.418     0.150
     2.339    41.418     0.150
     2.439    41.516     0.150
     2.439    44.516     0.150
     2.439    71.516     0.150
     2.439    77.516     0.150
     3.133    57.617     0.150
     3.133    97.617     0.150
     3.459    55.516     0.150
     3.459    55.516     0.150
     3.459    66.617     0.150
     3.792    59.719     0.150
     3.792    59.719     0.150
     3.792    91.719     0.150
     4.400    83.816     0.150
     4.400    69.418     0.150
     4.400    80.117     0.150
     4.400    83.816     0.150
     4.400   121.719     0.150
     4.400   137.719     0.150
     4.865   126.418     0.150
     4.865   148.219     0.150
     4.865    74.816     0.150
     4.865    88.719     0.150
     4.865   126.418     0.150
     4.865   148.219     0.150
     4.865   152.117     0.150
     5.002    93.617     0.150
     5.002    76.016     0.150
     5.002    90.918     0.150
     5.002    93.617     0.150
     5.002   134.816     0.150
     5.002   157.816     0.150
     6.218   166.117     0.150
     6.218    92.516     0.150
     6.218   113.219     0.150
     6.218   166.117     0.150
     6.218   193.719     0.150
     7.288   144.719     0.150
     7.288   219.816     0.150
     7.288   144.719     0.150
     7.288   219.816     0.150
     7.288   227.516     0.150
     7.322   211.719     0.150
     7.322   211.719     0.150
     7.322   228.418     0.150
     7.591   237.617     0.150
     8.666   270.117     0.150
     9.305   290.719     0.150
     9.799   285.617     0.150
     9.799   304.418     0.150
    10.290   234.617     0.150
    10.290   234.617     0.150
    10.290   320.816     0.150
    10.684   307.117     0.150
    10.684   331.918     0.150
     0.811    14.125     0.150
     0.811    30.125     0.150
     0.859    16.125     0.150
     0.859    16.125     0.150
     0.859    31.426     0.150
     0.862    27.023     0.150
     2.194    40.223     0.150
     2.194    40.223     0.150
     2.194    42.223     0.150
     2.194    71.926     0.150
     2.304    40.723     0.150
     2.304    40.723     0.150
     2.467    40.625     0.150
     2.467    40.625     0.150
     2.467    43.426     0.150
     2.467    43.426     0.150
     2.467    43.426     0.150
     2.467    86.223     0.150
     3.402    54.426     0.150
     3.402    54.426     0.150
     3.402    64.125     0.150
     3.402    65.723     0.150
     3.402   127.125     0.150
     3.735    58.723     0.150
     3.735    58.723     0.150
     3.735    72.223     0.150
     3.735   108.426     0.150
     4.343   102.426     0.150
     4.343   120.625     0.150
     4.343   136.625     0.150
     4.829    87.125     0.150
     4.829    87.125     0.150
     4.829    94.324     0.150
     4.948    91.625     0.150
     4.948    95.723     0.150
     4.948   108.523     0.150
     4.948   150.625     0.150
     4.948   156.426     0.150
     5.874   180.723     0.150
     6.162   112.523     0.150
     6.162   174.426     0.150
     6.162   192.723     0.150
     6.324   197.426     0.150
     7.253   131.824     0.150
     7.253   188.723     0.150
     7.253   226.926     0.150
     7.266   226.023     0.150
     9.742   232.324     0.150
     9.742   274.223     0.150
    10.236   232.324     0.150
    10.236   278.926     0.150
    10.824   182.824     0.150
    10.824   216.125     0.150
    10.824   300.324     0.150
    10.824   313.926     0.150
    49.503   535.625     0.150
     0.887    17.227     0.150
     0.887    17.227     0.150
     2.124    58.930     0.150
     2.124    37.125     0.150
     2.124    39.328     0.150
     2.124    58.930     0.150
     2.124    67.328     0.150
     2.139    38.031     0.150
     2.139    38.031     0.150
     2.139    39.727     0.150
     2.139    62.727     0.150
     2.139    66.625     0.150
     2.333    41.930     0.150
     2.333    41.930     0.150
     2.430    84.930     0.150
     2.430    41.430     0.150
     2.430    44.727     0.150
     2.430    69.727     0.150
     2.430    76.031     0.150
     2.430    84.930     0.150
     3.365    65.031     0.150
     3.365    55.031     0.150
     3.365    62.328     0.150
     3.365    65.031     0.150
     3.365    92.328     0.150
     3.365   105.930     0.150
     3.680    95.328     0.150
     3.680    58.828     0.150
     3.680    68.227     0.150
     3.680    95.328     0.150
     3.680   115.031     0.150
     4.307    79.625     0.150
     4.307   115.328     0.150
     4.307   134.125     0.150
     4.747    85.727     0.150
     4.747   125.727     0.150
     4.747   148.328     0.150
     4.883    88.930     0.150
     4.883   131.430     0.150
     4.883   153.930     0.150
     6.105   189.930     0.150
     7.171   220.328     0.150
     7.171   184.625     0.150
     7.171   220.328     0.150
     0.928    18.008     0.150
     0.928    18.008     0.150
     0.928    28.508     0.150
     2.111    65.008     0.150
     2.111    64.906     0.150
     2.351    43.305     0.150
     2.351    43.305     0.150
     2.409    86.109     0.150
     3.348    56.109     0.150
     3.348    63.008     0.150
     3.348   106.703     0.150
     3.652    97.406     0.150
     4.849    89.703     0.150
     2.297    45.371     0.150
     2.297    74.871     0.150
     2.368    39.871     0.150
     2.368    39.871     0.150
     2.368    60.771     0.150
     2.353    46.971     0.150
     2.434    39.971     0.150
     2.434    39.971     0.150
     2.434    39.971     0.150
     2.434    73.672     0.150
     3.551    70.672     0.150
     3.551    97.271     0.150
     3.894    61.072     0.150
     3.894    61.072     0.150
     3.894    61.072     0.150
     3.894    64.771     0.150
     3.894    67.771     0.150
     3.894    77.271     0.150
     3.894    89.371     0.150
     4.116   103.371     0.150
     4.492    86.871     0.150
     4.959   129.271     0.150
     5.107   140.572     0.150
     5.107   162.672     0.150
     5.755   179.471     0.150
     6.321   115.672     0.150
     6.321   146.871     0.150
     6.321   176.572     0.150
     6.215   196.072     0.150
     7.426   187.271     0.150
     7.426   209.871     0.150
     7.380   133.771     0.150
     7.380   187.771     0.150
     7.380   230.672     0.150
     7.697   217.271     0.150
     8.417   124.572     0.150
     8.417   156.771     0.150
     8.417   263.771     0.150
     8.417   124.572     0.150
     8.417   156.771     0.150
     8.417   215.771     0.150
     8.417   263.771     0.150
     9.409   174.371     0.150
     9.409   268.871     0.150
     9.901   181.572     0.150
     9.901   239.771     0.150
    10.395   164.771     0.150
    10.395   261.771     0.150
    10.395   164.771     0.150
    10.395   261.771     0.150
    10.786   319.971     0.150
    18.184   257.572     0.150
    18.184   446.771     0.150
    18.184   257.572     0.150
    18.184   446.771     0.150
    18.236   248.471     0.150
    18.236   248.471     0.150
    18.236   457.471     0.150
    19.002   259.572     0.150
    19.287   265.771     0.150
    20.005   275.771     0.150
    20.213   280.572     0.150
    47.137   515.172     0.150
    57.927   593.771     0.150
    60.532   611.271     0.150
    62.808   625.771     0.150
    63.096   629.271     0.150
    63.115   628.371     0.150
    63.208   628.072     0.150
    63.217   628.271     0.150
    63.327   629.271     0.150
    63.658   631.871     0.150
    64.383   636.271     0.150
    64.893   639.771     0.150
    77.368   718.971     0.150
     1.415    33.016     0.150
     2.155    37.016     0.150
     2.155    37.016     0.150
     2.155    44.016     0.150
     2.730    45.117     0.150
     2.730    45.117     0.150
     2.730    48.414     0.150
     2.730    54.016     0.150
     2.717    52.816     0.150
     2.717    56.215     0.150
     2.717    91.516     0.150
     2.745    43.816     0.150
     2.745    43.816     0.150
     3.640    74.016     0.150
     3.964    62.016     0.150
     3.964    62.016     0.150
     3.964    77.215     0.150
     4.271    66.016     0.150
     4.271    66.016     0.150
     4.271    70.016     0.150
     4.271    70.016     0.150
     4.271    70.016     0.150
     4.271    82.016     0.150
     4.271   135.414     0.150
     4.906    85.016     0.150
     4.906    92.117     0.150
     5.126    76.016     0.150
     5.126   142.816     0.150
     5.126   160.016     0.150
     5.126    97.414     0.150
     5.126   144.516     0.150
     5.126    76.016     0.150
     5.126    94.516     0.150
     5.126   142.816     0.150
     5.126   160.016     0.150
     5.449    82.316     0.150
     5.449    82.316     0.150
     5.449   103.715     0.150
     5.449   151.316     0.150
     6.692   129.516     0.150
     6.692   182.914     0.150
     6.692   211.215     0.150
     7.144   102.914     0.150
     7.144   102.516     0.150
     7.524   138.016     0.150
     7.524   192.117     0.150
     7.785   188.016     0.150
     7.785   214.016     0.150
     8.184   148.016     0.150
     8.184   117.016     0.150
     8.184   148.016     0.150
     9.135   239.016     0.150
     9.769   214.016     0.150
    10.274   191.215     0.150
    10.274   264.516     0.150
    10.274   322.516     0.150
    10.734   280.715     0.150
    10.734   155.016     0.150
    10.734   155.016     0.150
    10.734   280.715     0.150
    10.834   280.215     0.150
    10.834   156.715     0.150
    10.834   280.215     0.150
    11.164   199.816     0.150
    11.164   231.516     0.150
    11.164   317.016     0.150
    11.375   212.816     0.150
    11.375   324.516     0.150
    18.300   259.016     0.150
    18.607   260.016     0.150
    18.528   255.914     0.150
    19.712   275.516     0.150
    19.712   275.516     0.150
    19.985   278.516     0.150
    20.423   279.215     0.150
     0.385     7.812     0.150
     0.385     7.812     0.150
     1.675    29.912     0.150
     1.675    31.312     0.150
     1.675    51.912     0.150
     2.297    37.912     0.150
     2.297    37.912     0.150
     2.297    41.912     0.150
     2.297    72.712     0.150
     2.838    48.712     0.150
     2.838    56.912     0.150
     2.838    48.712     0.150
     2.838    51.112     0.150
     2.838    56.912     0.150
     2.838    80.912     0.150
     2.838    86.712     0.150
     3.069    56.112     0.150
     3.069    95.812     0.150
     4.257    67.012     0.150
     4.257    76.912     0.150
     4.257   133.912     0.150
     5.195    95.112     0.150
     5.195   162.412     0.150
     5.169   163.912     0.150
     5.501   158.112     0.150
     5.501   173.912     0.150
     5.810   182.412     0.150
     7.036   132.912     0.150
     7.036   132.912     0.150
     7.036   221.112     0.150
     7.893   245.112     0.150
     8.137   255.912     0.150
     9.484   292.412     0.150
    10.617   332.112     0.150
    11.097   346.912     0.150
     0.578    11.367     0.150
     0.578    11.367     0.150
     0.578    15.664     0.150
     0.578    15.664     0.150
     0.578    18.664     0.150
     2.210    44.961     0.150
     2.210    75.367     0.150
     2.210    37.961     0.150
     2.210    40.664     0.150
     2.210    44.961     0.150
     2.210    64.961     0.150
     2.210    71.266     0.150
     2.210    75.367     0.150
     2.652    43.367     0.150
     2.652    48.367     0.150
     2.652    75.367     0.150
     2.652    82.164     0.150
     2.621    52.367     0.150
     2.621    43.664     0.150
     2.621    47.961     0.150
     2.621    52.367     0.150
     2.621    82.367     0.150
     3.850   122.664     0.150
     3.850    61.062     0.150
     3.850    69.367     0.150
     3.850   105.367     0.150
     3.850   120.164     0.150
     3.850   122.664     0.150
     4.162    65.367     0.150
     4.162    75.461     0.150
     4.162   112.164     0.150
     4.162   130.164     0.150
     4.792    74.164     0.150
     4.792    86.664     0.150
     4.792   149.664     0.150
     5.062    77.664     0.150
     5.062    91.961     0.150
     5.062   134.867     0.150
     5.062   157.664     0.150
     5.346   178.164     0.150
     5.346    80.367     0.150
     5.346    96.164     0.150
     5.346   166.961     0.150
     5.346   178.164     0.150
     6.584    99.461     0.150
     6.584   119.961     0.150
     6.584   206.164     0.150
     7.466   138.062     0.150
     7.466   235.766     0.150
     7.679   239.867     0.150
     0.383     7.605     0.150
     0.383     7.605     0.150
     1.685    30.906     0.150
     1.685    30.906     0.150
     2.304    39.605     0.150
     2.304    42.305     0.150
     2.304    68.305     0.150
     2.304    72.207     0.150
     2.842    46.605     0.150
     2.842    50.906     0.150
     2.842    78.906     0.150
     2.842    86.605     0.150
     2.842    46.707     0.150
     2.842    51.207     0.150
     2.842    86.906     0.150
     3.081    50.605     0.150
     3.081    56.004     0.150
     3.081    84.906     0.150
     3.081    95.906     0.150
     4.267    77.605     0.150
     4.267   142.805     0.150
     4.267    67.004     0.150
     4.267    77.605     0.150
     4.267   116.305     0.150
     4.267   133.605     0.150
     4.267   142.805     0.150
     4.267    67.207     0.150
     4.267    77.605     0.150
     4.267   116.004     0.150
     4.267   134.004     0.150
     4.622    71.707     0.150
     4.622    84.605     0.150
     4.622   124.504     0.150
     4.622   146.906     0.150
     5.205   164.105     0.150
     5.205    80.605     0.150
     5.205    94.605     0.150
     5.205   164.105     0.150
     5.205    80.707     0.150
     5.205    96.305     0.150
     5.205   164.105     0.150
     5.514   189.906     0.150
     5.514   100.406     0.150
     5.514   173.207     0.150
     5.514   189.906     0.150
     5.823    87.605     0.150
     5.823   105.105     0.150
     5.823   152.605     0.150
     5.823   182.605     0.150
     7.049   228.605     0.150
     7.049   104.105     0.150
     7.049   127.207     0.150
     7.049   181.605     0.150
     7.049   218.605     0.150
     7.049   228.605     0.150
     0.584    11.482     0.150
     0.584    18.582     0.150
     1.275    23.582     0.150
     1.275    23.582     0.150
     2.225    34.582     0.150
     2.225    45.582     0.150
     2.225    34.582     0.150
     2.225    41.082     0.150
     2.225    45.582     0.150
     2.225    70.582     0.150
     2.575    46.781     0.150
     2.575    81.582     0.150
     2.629    52.383     0.150
     2.629    43.281     0.150
     2.629    47.781     0.150
     2.629    52.383     0.150
     2.629    80.781     0.150
     2.595    47.582     0.150
     2.595    81.582     0.150
     3.498   109.582     0.150
     3.823    69.582     0.150
     3.823   120.383     0.150
     4.136    74.582     0.150
     4.136   130.082     0.150
     5.048   160.582     0.150
     5.322   168.082     0.150
     0.551    10.641     0.150
     0.551    10.641     0.150
     2.272    68.740     0.150
     2.415    40.840     0.150
     2.415    47.541     0.150
     3.570   113.439     0.150
     4.507    48.840     0.150
     4.507   117.740     0.150
     0.322     6.765     0.150
     0.322    11.365     0.150
     1.747    32.565     0.150
     1.747    32.565     0.150
     1.747    55.165     0.150
     2.597    77.265     0.150
     2.597    43.265     0.150
     2.597    46.365     0.150
     2.597    73.565     0.150
     2.597    77.265     0.150
     2.825    56.465     0.150
     2.825    45.765     0.150
     2.825    51.265     0.150
     2.825    56.465     0.150
     2.825    79.965     0.150
     2.825    87.465     0.150
     3.252    52.265     0.150
     3.252    58.665     0.150
     3.252    89.765     0.150
     3.252   100.665     0.150
     4.314   118.665     0.150
     4.314    77.265     0.150
     4.314   118.665     0.150
     4.314   133.565     0.150
     4.777    73.665     0.150
     4.777    85.765     0.150
     4.777   127.065     0.150
     4.777   148.265     0.150
     5.234    89.165     0.150
     5.234   160.565     0.150
     5.234    89.165     0.150
     5.234    95.665     0.150
     5.234   160.565     0.150
     6.039   183.865     0.150
     6.872   215.965     0.150
     7.205   220.265     0.150
     7.205   220.265     0.150
     8.338   260.765     0.150
     0.492    15.746     0.150
     0.492     9.848     0.150
     0.492    15.746     0.150
     1.497    27.848     0.150
     1.497    46.246     0.150
     2.183    37.246     0.150
     2.183    40.246     0.150
     2.183    64.047     0.150
     2.183    68.445     0.150
     2.778    45.445     0.150
     2.778    49.945     0.150
     2.778    77.645     0.150
     2.778    84.348     0.150
     2.778    45.445     0.150
     2.778    49.945     0.150
     2.778    77.645     0.150
     2.778    84.348     0.150
     2.838    46.445     0.150
     2.838    51.246     0.150
     2.838    89.047     0.150
     3.731   115.645     0.150
     4.059    63.746     0.150
     4.059    73.047     0.150
     4.059   127.047     0.150
     4.379    68.348     0.150
     4.379    79.445     0.150
     4.379   137.645     0.150
     5.000    76.848     0.150
     5.000    91.047     0.150
     5.000   131.246     0.150
     5.000   155.848     0.150
     5.239    88.746     0.150
     5.239    88.746     0.150
     5.239   163.246     0.150
     5.562   175.348     0.150
     6.801   211.746     0.150
     7.635   239.145     0.150
     7.774   241.246     0.150
     7.897   116.848     0.150
     7.897   244.246     0.150
    10.384   324.047     0.150
     0.790    15.902     0.150
     0.790    19.502     0.150
     2.226    38.602     0.150
     2.226    38.602     0.150
     2.226    41.602     0.150
     2.380    69.703     0.150
     2.380    47.502     0.150
     2.380    74.402     0.150
     3.254    58.703     0.150
     3.254    51.602     0.150
     3.254    53.703     0.150
     3.254    59.203     0.150
     3.254   100.303     0.150
     3.639    65.902     0.150
     3.639    58.002     0.150
     3.639    58.002     0.150
     3.639    58.002     0.150
     3.639    69.303     0.150
     3.639   112.602     0.150
     4.471    88.803     0.150
     4.813    87.303     0.150
     4.813    74.602     0.150
     4.813    74.602     0.150
     4.813    79.303     0.150
     4.813    91.203     0.150
     5.180    79.203     0.150
     5.180    79.203     0.150
     5.180    98.402     0.150
     5.748    87.402     0.150
     5.748   108.203     0.150
     5.977   109.303     0.150
     5.977   184.902     0.150
     5.977    89.303     0.150
     5.977   109.203     0.150
     5.977   112.902     0.150
     7.606   138.203     0.150
     8.344   155.602     0.150
     8.706   157.703     0.150
     8.706   127.303     0.150
    10.690   157.803     0.150
    11.186   209.602     0.150
    11.661   310.703     0.150
    12.072   318.402     0.150
    12.260   176.102     0.150
    15.404   212.602     0.150
    21.743     5.301     0.150
    21.743     8.500     0.150
    21.743   688.902     0.150
    23.922     6.801     0.150
    23.951    34.500     0.150
    23.951   360.402     0.150
    48.173   934.902     0.150
     1.193    39.677     0.150
     1.193    22.877     0.150
     1.193    39.677     0.150
     2.663    51.677     0.150
     2.895    55.177     0.150
     2.895    96.977     0.150
     2.895    53.077     0.150
     2.895    91.677     0.150
     3.272    56.877     0.150
     3.444    62.377     0.150
     3.444    61.276     0.150
     3.444   106.677     0.150
     4.143    75.477     0.150
     4.722    86.477     0.150
     4.722   147.677     0.150
     5.238   161.877     0.150
     5.659   167.677     0.150
     0.658    24.555     0.150
     0.658    12.961     0.150
     0.658    21.758     0.150
     0.658    24.555     0.150
     0.902    18.961     0.150
     0.902    32.258     0.150
     0.902    17.555     0.150
     0.902    18.961     0.150
     0.902    29.156     0.150
     0.902    32.258     0.150
     1.879    35.055     0.150
     1.879    59.758     0.150
     2.102    36.055     0.150
     2.102    37.859     0.150
     2.102    64.656     0.150
     2.057    44.156     0.150
     2.057    35.656     0.150
     2.057    38.461     0.150
     2.057    44.156     0.150
     2.057    65.055     0.150
     2.661    44.055     0.150
     2.661    48.758     0.150
     2.661    85.055     0.150
     2.891    90.758     0.150
     3.223    52.156     0.150
     3.223    59.258     0.150
     3.223   101.758     0.150
     3.593    56.859     0.150
     3.593    65.656     0.150
     3.593   112.961     0.150
     4.162   132.359     0.150
     4.162    77.461     0.150
     4.162   128.859     0.150
     4.162   132.359     0.150
     4.832   151.656     0.150
     4.825   162.859     0.150
     4.825   153.461     0.150
     4.825   162.859     0.150
     6.022   186.758     0.150
    10.118   312.461     0.150
     0.695    21.418     0.150
     1.183    22.719     0.150
     1.183    24.316     0.150
     1.183    22.719     0.150
     1.183    24.316     0.150
     1.183    38.816     0.150
     2.171    66.117     0.150
     2.171    37.816     0.150
     2.171    66.117     0.150
     2.171    37.816     0.150
     2.171    40.617     0.150
     2.171    40.617     0.150
     2.171    66.117     0.150
     2.171    69.918     0.150
     2.171    69.918     0.150
     2.426    42.418     0.150
     2.426    74.617     0.150
     2.568    44.418     0.150
     2.568    46.918     0.150
     2.568    80.016     0.150
     2.526    44.117     0.150
     2.526    77.316     0.150
     2.859    23.516     0.150
     2.859    47.816     0.150
     2.859    51.617     0.150
     2.859    90.516     0.150
     3.406    54.117     0.150
     3.406    58.816     0.150
     3.406    93.617     0.150
     3.662    57.418     0.150
     3.662    99.516     0.150
     3.662    57.418     0.150
     3.662    67.516     0.150
     3.662    99.516     0.150
     3.662   113.719     0.150
     3.919    77.418     0.150
     3.919    70.617     0.150
     3.919    73.219     0.150
     3.919    77.418     0.150
     3.919   105.617     0.150
     3.919   124.219     0.150
     4.343    79.617     0.150
     4.343   138.117     0.150
     4.811   151.816     0.150
     5.144    98.117     0.150
     5.144    78.316     0.150
     5.144    94.016     0.150
     5.144    98.117     0.150
     5.144   137.617     0.150
     5.144   161.219     0.150
     5.459    83.316     0.150
     5.459    98.816     0.150
     5.459   143.617     0.150
     5.459   170.617     0.150
     6.051   190.918     0.150
     6.084    93.117     0.150
     6.084   112.219     0.150
     6.084   191.719     0.150
     6.612   205.617     0.150
     7.258   124.918     0.150
     7.875   246.418     0.150
     8.381   260.117     0.150
     8.370   254.816     0.150
     8.370   254.816     0.150
     8.960   277.816     0.150
     9.289   290.016     0.150
    10.224   320.516     0.150
    11.888   369.719     0.150
     0.560    10.872     0.150
     0.560    10.872     0.150
     1.212    41.472     0.150
     1.212    23.272     0.150
     1.212    39.572     0.150
     1.772    32.672     0.150
     1.772    55.872     0.150
     1.772    32.672     0.150
     1.772    32.672     0.150
     1.772    32.672     0.150
     1.772    55.672     0.150
     2.153    39.272     0.150
     2.153    66.972     0.150
     2.687    84.372     0.150
     2.627    51.772     0.150
     2.627    44.872     0.150
     2.627    47.972     0.150
     2.627    84.372     0.150
     3.002    94.172     0.150
     3.002    49.572     0.150
     3.002    55.472     0.150
     3.002    94.172     0.150
     3.313    54.172     0.150
     3.313    54.172     0.150
     3.313    61.072     0.150
     3.313    92.472     0.150
     3.313   103.972     0.150
     3.945    63.272     0.150
     3.945    72.272     0.150
     3.945   123.272     0.150
     4.529    70.672     0.150
     4.529    70.672     0.150
     4.529    82.672     0.150
     4.529   122.672     0.150
     4.529   141.272     0.150
     4.510   143.372     0.150
     4.510    69.172     0.150
     4.510    80.872     0.150
     4.510   120.572     0.150
     4.510   142.972     0.150
     5.740   103.872     0.150
     5.740    88.072     0.150
     5.740   103.872     0.150
     5.740   177.972     0.150
     6.844   126.772     0.150
     6.844   214.672     0.150
     6.844   104.472     0.150
     6.844   212.772     0.150
     6.944   128.972     0.150
     6.944   219.372     0.150
     6.944   128.772     0.150
     6.944   128.772     0.150
     6.944   218.972     0.150
     7.255   227.572     0.150
     8.120   254.272     0.150
     8.827   272.672     0.150
     8.827   272.672     0.150
     8.827   275.872     0.150
     9.320   288.772     0.150
     9.817   306.672     0.150
    10.206   316.272     0.150
    10.407   152.572     0.150
    10.407   321.972     0.150
     0.659    12.566     0.150
     0.659    12.566     0.150
     0.901    39.664     0.150
     0.901    17.164     0.150
     0.901    18.465     0.150
     0.901    29.266     0.150
     0.901    39.664     0.150
     2.058    43.066     0.150
     2.058    34.965     0.150
     2.058    37.965     0.150
     2.058    43.066     0.150
     2.058    64.266     0.150
     2.102    37.965     0.150
     2.102    37.965     0.150
     2.661    76.664     0.150
     2.661    43.363     0.150
     2.661    43.363     0.150
     2.661    47.965     0.150
     2.661    84.066     0.150
     2.892    90.965     0.150
     3.225    54.664     0.150
     3.225    63.363     0.150
     3.225    51.465     0.150
     3.225    54.664     0.150
     3.225    58.465     0.150
     3.225    63.363     0.150
     3.225   101.766     0.150
     3.595    56.363     0.150
     3.595    56.363     0.150
     3.595    56.363     0.150
     3.595    65.164     0.150
     3.595    72.863     0.150
     4.164    82.465     0.150
     4.164   126.965     0.150
     4.164    75.266     0.150
     4.164    82.465     0.150
     4.164   126.965     0.150
     4.164   130.465     0.150
     4.833    80.566     0.150
     4.833   146.465     0.150
     4.833   153.566     0.150
     4.833    73.164     0.150
     4.833    80.566     0.150
     4.833    88.363     0.150
     4.833   146.465     0.150
     4.833   153.566     0.150
     4.826   150.164     0.150
     4.826    76.863     0.150
     4.826    87.965     0.150
     4.826   150.164     0.150
     4.826    76.863     0.150
     4.826    87.965     0.150
     4.826   124.465     0.150
     4.826   150.164     0.150
     6.024   187.766     0.150
     6.024    89.066     0.150
     6.024   187.766     0.150
     6.532   206.066     0.150
     0.267     9.867     0.150
     0.267    11.062     0.150
     1.716    31.664     0.150
     1.716    54.367     0.150
     1.716    31.664     0.150
     1.716    54.367     0.150
     2.522    41.164     0.150
     2.522    45.461     0.150
     2.522    79.867     0.150
     2.749    47.367     0.150
     2.749    43.164     0.150
     2.749    47.367     0.150
     2.749    74.961     0.150
     2.749    82.867     0.150
     2.968    93.664     0.150
     3.169    50.961     0.150
     3.169    57.867     0.150
     3.169   100.461     0.150
     3.958   104.266     0.150
     3.958   123.664     0.150
     4.304    77.062     0.150
     4.304   113.664     0.150
     4.304   134.266     0.150
     4.706    71.562     0.150
     4.706    85.461     0.150
     4.706   124.664     0.150
     4.706   148.062     0.150
     5.236   162.461     0.150
     5.705   180.766     0.150
     5.934   108.664     0.150
     5.934   187.367     0.150
     1.004    19.473     0.150
     1.004    19.473     0.150
     1.884    41.273     0.150
     2.000    37.074     0.150
     2.000    37.074     0.150
     2.000    42.574     0.150
     2.504    43.773     0.150
     2.504    48.074     0.150
     4.659   148.875     0.150
     4.750    79.676     0.150
     4.527    72.008     0.150
     6.941   213.711     0.150
     1.256    24.523     0.150
     1.256    24.320     0.150
     1.256    24.320     0.150
     1.561    51.023     0.150
     1.561    30.117     0.150
     1.561    34.922     0.150
     1.561    50.617     0.150
     2.346    43.523     0.150
     2.346    74.922     0.150
     2.346    74.523     0.150
     2.823    46.617     0.150
     2.915    52.820     0.150
     2.956    54.117     0.150
     3.506    64.922     0.150
     3.677    63.719     0.150
     3.677    98.820     0.150
     4.388    84.023     0.150
     4.388   137.820     0.150
     4.533    83.117     0.150
     4.533   144.023     0.150
     5.046    82.219     0.150
     5.414    86.617     0.150
     5.782   106.820     0.150
     6.474   101.023     0.150
     6.725   122.219     0.150
     6.725   209.820     0.150
     6.725    98.047     0.150
     6.725   122.242     0.150
     6.725   174.016     0.150
     6.725   209.852     0.150
     7.725   199.523     0.150
     8.079   208.617     0.150
     8.492   154.422     0.150
     8.492   266.320     0.150
     8.628   156.922     0.150
     8.761   138.219     0.150
     8.761   160.117     0.150
     8.761   221.617     0.150
    24.868   327.641     0.150
    27.952   355.523     0.150
    44.945   499.367     0.150
    50.558   542.219     0.150
    50.558   542.648     0.150
     0.719    13.992     0.150
     0.719    13.992     0.150
     1.117    20.891     0.150
     1.117    20.891     0.150
     1.117    35.789     0.150
     2.259    82.891     0.150
     2.259    41.688     0.150
     2.259    69.086     0.150
     2.259    39.891     0.150
     2.259    41.688     0.150
     2.259    65.891     0.150
     2.259    70.188     0.150
     2.259    82.891     0.150
     2.302    43.086     0.150
     2.302    72.688     0.150
     2.406    41.391     0.150
     2.406    43.992     0.150
     2.406    75.688     0.150
     2.538    41.391     0.150
     2.538    45.992     0.150
     2.538    78.891     0.150
     3.324   103.891     0.150
     3.645    58.492     0.150
     3.645    65.789     0.150
     3.645   113.391     0.150
     3.947    62.586     0.150
     3.947    71.688     0.150
     3.947   121.086     0.150
     3.947    62.586     0.150
     3.947    71.688     0.150
     3.947   108.586     0.150
     3.947   123.789     0.150
     4.587    72.086     0.150
     4.587    83.289     0.150
     4.587   123.391     0.150
     4.587   144.086     0.150
     4.891   153.188     0.150
     4.891    75.492     0.150
     4.891    89.586     0.150
     4.891   132.086     0.150
     4.891   153.289     0.150
     5.132    80.492     0.150
     5.132   158.492     0.150
     5.132    80.492     0.150
     5.132    94.891     0.150
     5.132   161.891     0.150
     6.369   116.289     0.150
     6.369    96.289     0.150
     6.369   116.289     0.150
     6.369   164.289     0.150
     6.369   199.492     0.150
     7.134   129.586     0.150
     7.134   129.586     0.150
     7.134   185.492     0.150
     7.134   221.492     0.150
     7.173   222.891     0.150
     7.304   133.086     0.150
     7.304   227.492     0.150
     7.304   108.289     0.150
     7.304   133.086     0.150
     7.304   189.188     0.150
     7.304   228.391     0.150
     7.464   111.391     0.150
     7.464   232.688     0.150
     7.667   238.789     0.150
     7.840   144.391     0.150
     7.840   144.391     0.150
     7.840   245.891     0.150
     9.448   295.492     0.150
     9.951   307.992     0.150
    10.419   323.188     0.150
     0.340    11.910     0.150
     1.637    29.707     0.150
     1.637    52.207     0.150
     2.335    84.008     0.150
     2.335    40.008     0.150
     2.335    42.410     0.150
     2.335    73.309     0.150
     2.335    84.008     0.150
     2.792    46.809     0.150
     2.792    50.008     0.150
     2.792    78.809     0.150
     2.792    85.910     0.150
     2.878    46.309     0.150
     2.878    52.109     0.150
     2.878    82.008     0.150
     2.878    90.508     0.150
     3.041    50.008     0.150
     3.041    54.609     0.150
     3.041    95.008     0.150
     3.354    53.410     0.150
     3.883    62.910     0.150
     3.883    71.109     0.150
     3.883   105.109     0.150
     3.883   120.707     0.150
     4.221    64.707     0.150
     4.221    75.609     0.150
     4.221   132.207     0.150
     4.582    71.309     0.150
     4.582    83.109     0.150
     4.582   124.207     0.150
     4.582   144.207     0.150
     5.158    79.809     0.150
     5.158    94.508     0.150
     5.158   161.207     0.150
     5.500   173.109     0.150
     5.787   104.508     0.150
     5.787   152.207     0.150
     5.787   181.309     0.150
     7.009   220.508     0.150
     7.791   241.008     0.150
     7.827   141.809     0.150
     7.827   141.809     0.150
     7.827   244.809     0.150
     7.895   143.207     0.150
     7.895   116.410     0.150
     7.895   143.207     0.150
     7.895   245.410     0.150
     8.112   147.707     0.150
     8.112   147.707     0.150
     8.112   252.008     0.150
     8.498   154.207     0.150
     8.498   154.207     0.150
     8.498   265.207     0.150
     0.360     7.119     0.150
     0.360     7.119     0.150
     0.360     7.219     0.150
     2.313    69.819     0.150
     2.313    85.419     0.150
     3.039    55.020     0.150
     3.442    61.619     0.150
     4.580   140.319     0.150
     5.162    93.719     0.150
     5.162   161.619     0.150
     5.203    79.219     0.150
     5.203    79.219     0.150
     5.203    95.020     0.150
     5.203   163.719     0.150
     5.485   101.819     0.150
     5.485   102.020     0.150
     5.485   171.719     0.150
     5.703   105.119     0.150
     5.782   104.619     0.150
     5.782   179.520     0.150
     6.761   109.619     0.150
     7.006   127.819     0.150
     7.675   231.819     0.150
     7.823   124.919     0.150
     7.823   140.919     0.150
     7.823   209.319     0.150
     7.785   143.219     0.150
     7.785   245.119     0.150
     7.822   144.619     0.150
     7.822   244.719     0.150
     7.880   143.319     0.150
     7.880   245.319     0.150
     7.880   143.419     0.150
     8.108   251.919     0.150
     8.318   261.619     0.150
    13.745   425.419     0.150
    15.697   218.719     0.150
    15.697   388.119     0.150
    19.360   271.520     0.150
    49.498   955.819     0.150
    49.498  1164.020     0.150
    49.498  1248.119     0.150
     0.933    18.238     0.150
     0.933    18.238     0.150
     0.933    30.039     0.150
     2.396    43.639     0.150
     2.396    73.639     0.150
     2.396    40.639     0.150
     2.396    43.639     0.150
     2.396    69.738     0.150
     2.396    73.639     0.150
     2.530    41.938     0.150
     2.530    46.438     0.150
     2.530    72.738     0.150
     2.530    79.938     0.150
     2.704    53.139     0.150
     2.704    86.539     0.150
     3.345    52.838     0.150
     3.345    59.539     0.150
     3.345   101.639     0.150
     3.356    63.238     0.150
     3.831    69.438     0.150
     3.831   117.738     0.150
     3.831    60.639     0.150
     3.831    69.438     0.150
     3.831   117.738     0.150
     4.695   147.438     0.150
     4.695   147.438     0.150
     4.984    91.238     0.150
     4.984   155.738     0.150
     5.372    98.039     0.150
     5.372   143.639     0.150
     5.372   166.039     0.150
     5.372    81.838     0.150
     5.372    98.039     0.150
     5.372   143.639     0.150
     5.372   166.639     0.150
     5.915   108.139     0.150
     5.915   184.838     0.150
     6.192   195.438     0.150
     6.577   120.838     0.150
     6.577   120.838     0.150
     6.577   205.338     0.150
     7.420   233.039     0.150
     8.346   253.838     0.150
     8.579   266.838     0.150
     8.557   267.438     0.150
     8.903   278.539     0.150
     0.671    22.214     0.150
     0.871    32.113     0.150
     0.871    16.214     0.150
     0.871    16.313     0.150
     0.871    28.014     0.150
     0.871    32.113     0.150
     2.108    39.014     0.150
     2.108    67.214     0.150
     2.209    40.214     0.150
     2.209    40.214     0.150
     2.209    65.813     0.150
     2.292    39.014     0.150
     2.292    42.014     0.150
     2.292    66.813     0.150
     2.292    71.714     0.150
     2.592    46.914     0.150
     2.592    75.014     0.150
     2.592    81.514     0.150
     2.592    43.613     0.150
     2.592    47.014     0.150
     2.592    75.113     0.150
     2.592    81.613     0.150
     3.451    55.214     0.150
     3.451    62.514     0.150
     3.451   107.914     0.150
     3.829    60.714     0.150
     3.829   117.414     0.150
     3.829    60.714     0.150
     3.829    71.014     0.150
     3.829   119.514     0.150
     4.389    69.414     0.150
     4.389    80.514     0.150
     4.389   136.813     0.150
     5.003    92.813     0.150
     5.003   154.514     0.150
     5.003    92.313     0.150
     5.003   157.113     0.150
     5.065    94.313     0.150
     5.065   160.414     0.150
     5.065    77.414     0.150
     5.065   156.214     0.150
     5.065    77.414     0.150
     5.065    94.313     0.150
     5.065   160.414     0.150
     6.258    91.514     0.150
     6.258   112.014     0.150
     6.258    91.514     0.150
     6.258   112.014     0.150
     6.258   194.514     0.150
     7.080   105.313     0.150
     7.080   221.113     0.150
     7.100   219.414     0.150
     7.371   230.813     0.150
     7.430   229.613     0.150
     7.430   133.514     0.150
     7.430   229.714     0.150
     7.795   242.014     0.150
     7.795   242.014     0.150
     9.834   308.014     0.150
     0.226     4.914     0.150
     0.226     4.914     0.150
     0.226     7.812     0.150
     1.350    25.211     0.150
     1.350    25.211     0.150
     1.350    42.812     0.150
     2.505    44.016     0.150
     2.505    40.914     0.150
     2.505    45.016     0.150
     2.505    71.516     0.150
     2.505    77.609     0.150
     2.499    42.016     0.150
     2.499    45.414     0.150
     2.499    72.812     0.150
     2.499    78.312     0.150
     2.598    49.516     0.150
     2.598    44.914     0.150
     2.598    47.609     0.150
     2.598    81.812     0.150
     2.789    50.609     0.150
     2.789    46.109     0.150
     2.789    50.609     0.150
     2.789    87.016     0.150
     3.596    57.711     0.150
     3.596    66.016     0.150
     3.596   100.414     0.150
     3.596   113.516     0.150
     3.938    71.211     0.150
     3.938    61.711     0.150
     3.938    71.211     0.150
     3.938   107.211     0.150
     3.938   122.711     0.150
     4.327    67.516     0.150
     4.327   116.312     0.150
     4.327    67.609     0.150
     4.327    78.914     0.150
     4.327   116.312     0.150
     4.327   135.016     0.150
     4.873    88.516     0.150
     4.873    74.914     0.150
     4.873    88.516     0.150
     4.873   152.109     0.150
     5.386    81.016     0.150
     5.386    98.312     0.150
     5.386   169.109     0.150
     5.556   172.312     0.150
     5.556   171.109     0.150
     5.556    84.312     0.150
     5.556   100.414     0.150
     5.556   146.609     0.150
     5.556   172.312     0.150
     6.394   200.211     0.150
     6.756   122.211     0.150
     6.756   122.812     0.150
     6.756   210.609     0.150
     6.756   100.812     0.150
     6.756   122.211     0.150
     6.756   210.711     0.150
     7.568   236.414     0.150
     7.798   140.914     0.150
     7.798   113.516     0.150
     7.798   142.516     0.150
     7.798   245.312     0.150
     7.798   113.609     0.150
     7.798   140.914     0.150
     7.798   242.211     0.150
     7.867   116.109     0.150
     7.867   246.016     0.150
     8.095   254.016     0.150
     8.280   260.711     0.150
     9.145   286.312     0.150
     9.849   306.609     0.150
    10.333   321.711     0.150
    10.844   338.211     0.150
    11.214   349.312     0.150
    11.390   323.016     0.150
    11.390   323.016     0.150
    11.390   354.516     0.150
    13.460   417.516     0.150
     0.318     6.918     0.150
     0.318     6.820     0.150
     1.254    40.418     0.150
     2.489    74.320     0.150
     2.489    79.621     0.150
     2.489    88.621     0.150
     2.489    46.320     0.150
     2.489    79.719     0.150
     2.454    44.219     0.150
     2.454    44.219     0.150
     2.684    53.320     0.150
     2.684    79.820     0.150
     2.684    49.320     0.150
     3.828   107.520     0.150
     3.828   123.621     0.150
     4.222    66.020     0.150
     4.222    66.020     0.150
     4.222   129.918     0.150
     4.776   150.219     0.150
     5.449    82.520     0.150
     5.449    82.520     0.150
     6.651    98.820     0.150
     6.651    98.820     0.150
     6.651   174.320     0.150
     6.651    98.820     0.150
     6.651   120.320     0.150
     6.651   206.320     0.150
     7.459   135.449     0.150
     7.459   235.840     0.150
     7.462   135.820     0.150
     7.706   141.918     0.150
     7.761   140.121     0.150
     7.761   141.520     0.150
     7.761   240.918     0.150
     8.039   146.621     0.150
     8.039   252.418     0.150
     8.069   202.121     0.150
     8.173   148.820     0.150
     9.039   226.320     0.150
    11.110   152.020     0.150
    11.292   357.777     0.150
    13.701   197.020     0.150
    13.701   201.020     0.150
    13.701   350.020     0.150
    14.090   206.520     0.150
    14.090     7.000     0.150
    14.090   215.520     0.150
    15.822   397.121     0.150
    16.337     3.500     0.150
    16.337     7.199     0.150
    17.484   430.320     0.150
    18.047   248.918     0.150
    19.507   475.418     0.150
    20.961   308.820     0.150
    20.961   702.820     0.150
    22.655     3.199     0.150
    22.655   546.520     0.150
    22.994    32.199     0.150
    22.994   346.520     0.150
    23.430   308.820     0.150
    23.930   315.020     0.150
    23.930   314.988     0.150
    24.586     3.500     0.150
    24.586     6.000     0.150
    24.586    39.000     0.150
    24.586   577.520     0.150
    25.632     5.199     0.150
    25.632   595.520     0.150
    30.063   365.770     0.150
    31.228     4.500     0.150
    31.228     6.699     0.150
    31.863   387.418     0.150
    31.863   461.121     0.150
    31.863   809.621     0.150
    31.863   825.418     0.150
    33.358     5.199     0.150
    33.358   720.520     0.150
    37.101   432.320     0.150
    37.134   432.121     0.150
    37.234   433.219     0.150
    39.474   449.918     0.150
    42.968   479.918     0.150
    43.137   485.719     0.150
    43.760   484.719     0.150
    44.066   530.441     0.150
    44.892   495.219     0.150
    47.315   669.520     0.150
    49.035   528.520     0.150
    49.381   529.621     0.150
    49.381     4.199     0.150
    49.411   529.020     0.150
    49.411     4.102     0.150
    54.394   566.121     0.150
    54.394     3.797     0.150
    55.348   578.219     0.150
    55.940   582.418     0.150
    55.940   582.418     0.150
    55.991   578.520     0.150
    56.369   585.320     0.150
    57.061   586.320     0.150
    57.061   586.320     0.150
    57.061   586.320     0.150
    57.061   586.320     0.150
    57.599   590.418     0.150
    57.599     4.203     0.150
    58.804   598.000     0.150
    60.559   614.219     0.150
    61.254   618.418     0.150
    62.827   628.918     0.150
    63.133   631.621     0.150
    63.134   631.219     0.150
    63.204   631.020     0.150
    63.216   631.020     0.150
    63.417   632.719     0.150
    63.655   634.219     0.150
    64.188   638.320     0.150
    64.274   638.820     0.150
    64.602   640.918     0.150
    64.763   642.121     0.150
    64.899   642.820     0.150
    65.007   643.520     0.150
    67.735   661.219     0.150
    68.825   663.691     0.150
    77.518   715.719     0.150
   136.626  1162.219     0.150
   146.392  1200.320     0.150
   149.530  1188.918     0.150
     0.304     6.414     0.150
     0.304     6.414     0.150
     1.256    23.012     0.150
     1.256    23.012     0.150
     1.256    23.414     0.150
     1.256    40.414     0.150
     2.445    70.812     0.150
     2.445    40.812     0.150
     2.445    44.012     0.150
     2.445    70.812     0.150
     2.445    75.711     0.150
     2.502    45.613     0.150
     2.502    73.211     0.150
     2.502    45.613     0.150
     2.502    79.012     0.150
     2.505    88.512     0.150
     2.505    42.012     0.150
     2.505    72.914     0.150
     2.505    42.012     0.150
     2.505    45.211     0.150
     2.505    73.012     0.150
     2.505    79.113     0.150
     2.505    88.512     0.150
     2.691    48.711     0.150
     2.691    48.711     0.150
     2.691    48.613     0.150
     3.502    56.613     0.150
     3.502    64.812     0.150
     3.502   110.512     0.150
     3.826   123.113     0.150
     3.843    60.312     0.150
     3.843    70.312     0.150
     3.843   120.914     0.150
     4.229    65.711     0.150
     4.229   129.812     0.150
     4.229    65.711     0.150
     4.229    77.113     0.150
     4.229   114.113     0.150
     4.229   132.312     0.150
     4.778   130.711     0.150
     4.778    72.812     0.150
     4.778    86.812     0.150
     4.778   130.711     0.150
     4.778   150.512     0.150
     5.306    79.613     0.150
     5.306    96.613     0.150
     5.306   166.414     0.150
     5.306    79.613     0.150
     5.306    96.613     0.150
     5.306   142.312     0.150
     5.306   167.914     0.150
     5.458   170.414     0.150
     5.458    82.012     0.150
     5.458    98.914     0.150
     5.458   144.012     0.150
     5.458   170.211     0.150
     6.658   122.113     0.150
     6.658    98.711     0.150
     6.658   122.113     0.150
     6.658   172.812     0.150
     6.658   208.211     0.150
     7.471   233.312     0.150
     7.769   240.414     0.150
     7.769   240.414     0.150
     7.997   248.711     0.150
     7.997   248.711     0.150
     8.183   256.512     0.150
     8.183   256.512     0.150
    10.234   317.312     0.150
    10.746   335.512     0.150
    11.115   343.113     0.150
    11.292   352.812     0.150
     0.303     6.289     0.150
     0.303     6.289     0.150
     0.303     6.789     0.150
     0.303     6.789     0.150
     0.303     6.789     0.150
     1.261    24.789     0.150
     1.261    40.191     0.150
     2.452    44.090     0.150
     2.452    44.090     0.150
     2.499    87.789     0.150
     2.499    73.191     0.150
     2.507    50.492     0.150
     3.507   110.492     0.150
     3.821    58.391     0.150
     3.848    63.391     0.150
     3.848   120.789     0.150
     4.233    68.289     0.150
     4.784   150.789     0.150
     5.462    84.992     0.150
     6.064   111.492     0.150
     6.662   123.391     0.150
     6.662   210.891     0.150
     0.513    10.073     0.150
     0.513    10.073     0.150
     0.513    17.073     0.150
     1.159    21.173     0.150
     1.159    24.073     0.150
     1.159    36.673     0.150
     1.159    40.073     0.150
     2.385    43.973     0.150
     2.385    74.973     0.150
     2.384    71.073     0.150
     2.384    40.773     0.150
     2.384    43.373     0.150
     2.384    71.073     0.150
     2.384    74.973     0.150
     2.473    44.673     0.150
     2.473    44.673     0.150
     2.535    42.473     0.150
     2.535    46.073     0.150
     2.535    72.073     0.150
     2.535    79.973     0.150
     3.397   107.573     0.150
     3.729    59.373     0.150
     3.729    67.273     0.150
     3.729   115.773     0.150
     4.076    64.073     0.150
     4.076    74.673     0.150
     4.076   128.073     0.150
     4.669   147.773     0.150
     5.096    92.373     0.150
     5.096   134.973     0.150
     5.096   159.373     0.150
     5.286   164.573     0.150
     5.286    80.573     0.150
     5.286    96.473     0.150
     5.286   166.073     0.150
     6.503   119.173     0.150
     6.503   172.873     0.150
     6.503    96.973     0.150
     6.503   119.173     0.150
     6.503   172.873     0.150
     6.503   203.873     0.150
     7.294   185.973     0.150
     7.294   227.073     0.150
     7.607   239.173     0.150
     7.607   239.173     0.150
     7.824   245.273     0.150
     7.824   245.273     0.150
     8.882   278.473     0.150
    10.083   315.673     0.150
    11.161   309.873     0.150
    11.161   309.873     0.150
    11.161   348.373     0.150
     0.320     6.682     0.150
     0.320     6.682     0.150
     1.259    23.382     0.150
     1.259    39.882     0.150
     2.462    41.782     0.150
     2.462    44.182     0.150
     2.462    71.082     0.150
     2.462    75.182     0.150
     2.481    73.382     0.150
     2.481    88.482     0.150
     2.481    42.082     0.150
     2.481    45.482     0.150
     2.481    73.382     0.150
     2.481    78.782     0.150
     2.481    88.482     0.150
     2.687    44.682     0.150
     2.687    49.182     0.150
     2.687    83.882     0.150
     3.505    64.182     0.150
     3.505   110.182     0.150
     3.845    60.782     0.150
     3.845    69.782     0.150
     3.845   119.782     0.150
     4.225    65.982     0.150
     4.225    77.482     0.150
     4.225   115.182     0.150
     4.225   132.382     0.150
     4.781    87.182     0.150
     4.781   149.682     0.150
     5.288    97.282     0.150
     5.288   166.482     0.150
     5.451    82.682     0.150
     5.451    99.082     0.150
     5.451   170.182     0.150
     5.568    97.582     0.150
     6.056   114.882     0.150
     6.654   120.482     0.150
     6.654   177.082     0.150
     6.654    99.382     0.150
     6.654   120.482     0.150
     6.654   177.082     0.150
     6.654   206.482     0.150
     7.703   203.182     0.150
     7.703   203.182     0.150
     7.703   239.382     0.150
     7.764   243.082     0.150
    10.231   317.782     0.150
    10.231   317.782     0.150
     0.343     7.150     0.150
     0.343     7.150     0.150
     1.236    24.750     0.150
     1.236    22.950     0.150
     1.236    24.750     0.150
     1.236    39.350     0.150
     2.449    40.450     0.150
     2.449    43.850     0.150
     2.449    75.150     0.150
     2.479    47.150     0.150
     2.479    47.150     0.150
     2.479    77.750     0.150
     2.661    48.650     0.150
     2.661    44.550     0.150
     2.661    48.750     0.150
     2.661    83.550     0.150
     3.482   109.050     0.150
     3.821    69.650     0.150
     3.821    60.450     0.150
     3.821    69.550     0.150
     3.821   118.650     0.150
     3.847   120.450     0.150
     4.200    65.450     0.150
     4.200    76.650     0.150
     4.200   130.750     0.150
     4.757    86.550     0.150
     4.757   147.850     0.150
     5.266    96.450     0.150
     5.266   165.550     0.150
     5.426    84.650     0.150
     5.426    84.650     0.150
     5.426    99.150     0.150
     5.426   169.550     0.150
     5.586   102.550     0.150
     5.586   172.750     0.150
     5.586    84.650     0.150
     5.586    84.650     0.150
     5.586   102.550     0.150
     5.586   144.250     0.150
     5.586   172.750     0.150
     6.629   207.350     0.150
     7.682   239.350     0.150
     7.738   241.450     0.150
     7.952   241.850     0.150
     8.094   244.850     0.150
     8.149   255.350     0.150
     2.445    44.051     0.150
     2.445    44.051     0.150
     2.482    88.351     0.150
     2.444    72.065     0.150
     0.359     7.127     0.150
     0.359    11.526     0.150
     1.223    25.127     0.150
     1.223    43.327     0.150
     1.223    23.127     0.150
     2.445    44.327     0.150
     2.445    44.327     0.150
     2.445    48.727     0.150
     2.465    46.526     0.150
     2.477    88.827     0.150
     2.477    45.427     0.150
     2.646    48.827     0.150
     2.646    83.427     0.150
     3.807   120.827     0.150
     3.860   102.728     0.150
     3.860    69.927     0.150
     3.860    70.026     0.150
     3.860   102.728     0.150
     3.860   119.228     0.150
     4.011    69.327     0.150
     4.110    64.627     0.150
     4.110    64.727     0.150
     4.110    74.526     0.150
     4.110   111.126     0.150
     4.110   128.228     0.150
     4.110   128.327     0.150
     4.184    66.026     0.150
     4.184    75.827     0.150
     4.511   123.827     0.150
     4.744    74.127     0.150
     4.744    87.427     0.150
     4.744   149.427     0.150
     5.250    97.427     0.150
     5.250   163.927     0.150
     5.409   168.526     0.150
     5.593    82.927     0.150
     5.593    98.827     0.150
     5.593   143.927     0.150
     5.593   143.927     0.150
     6.613   120.927     0.150
     7.421   135.228     0.150
     7.666   140.327     0.150
     7.666   112.026     0.150
     7.666   140.626     0.150
     7.666   238.526     0.150
     7.722   140.126     0.150
     7.969   241.728     0.150
     8.111   127.228     0.150
     8.111   246.126     0.150
     8.133   128.126     0.150
     8.133   147.728     0.150
     8.411   255.927     0.150
    11.253   166.026     0.150
    11.253   318.927     0.150
     0.274     6.086     0.150
     0.274     9.785     0.150
     0.274     6.086     0.150
     0.274     9.785     0.150
     1.277    24.887     0.150
     1.277    27.984     0.150
     1.277    23.184     0.150
     1.277    24.887     0.150
     1.277    27.984     0.150
     1.277    40.387     0.150
     1.277    42.887     0.150
     2.450    43.785     0.150
     2.450    43.785     0.150
     2.450    77.184     0.150
     2.525    50.586     0.150
     2.525    77.484     0.150
     2.525    41.785     0.150
     2.525    45.285     0.150
     2.525    50.586     0.150
     2.525    77.484     0.150
     2.517    73.887     0.150
     2.517    41.785     0.150
     2.517    45.086     0.150
     2.517    73.887     0.150
     2.517    78.387     0.150
     2.718    44.984     0.150
     2.718    48.785     0.150
     2.718    83.984     0.150
     3.523    63.484     0.150
     3.523    63.484     0.150
     3.523   109.086     0.150
     3.865    60.484     0.150
     3.865    69.086     0.150
     3.865   119.387     0.150
     3.805   108.184     0.150
     3.805    60.785     0.150
     3.805    68.684     0.150
     3.805   108.184     0.150
     3.805   117.285     0.150
     4.087    63.785     0.150
     4.087    73.086     0.150
     4.087   127.086     0.150
     4.255   116.086     0.150
     4.255    65.785     0.150
     4.255    76.887     0.150
     4.255   116.086     0.150
     4.255   131.785     0.150
     4.800   150.586     0.150
     4.800    73.586     0.150
     4.800    86.984     0.150
     4.800   149.586     0.150
     5.335   165.684     0.150
     5.335    81.684     0.150
     5.335    96.887     0.150
     5.335   166.285     0.150
     5.486   103.184     0.150
     5.486   103.184     0.150
     5.486   169.887     0.150
     5.572    96.785     0.150
     5.572    96.785     0.150
     5.572   170.285     0.150
     6.684   206.285     0.150
     6.684   206.285     0.150
     7.499   138.684     0.150
     7.499   232.785     0.150
     7.751   139.285     0.150
     7.751   241.984     0.150
     7.751   241.984     0.150
     7.796   148.887     0.150
     7.796   148.887     0.150
     7.796   242.285     0.150
     7.885   238.984     0.150
     8.026   241.586     0.150
     8.026   113.684     0.150
     8.026   243.887     0.150
     8.211   254.887     0.150
     8.326   253.684     0.150
    15.715   215.984     0.150
    30.880   371.285     0.150
     0.311    10.148     0.150
     1.257    25.047     0.150
     1.257    28.344     0.150
     1.257    23.445     0.150
     1.257    25.047     0.150
     1.257    28.344     0.150
     1.257    40.648     0.150
     1.257    43.648     0.150
     2.452    41.047     0.150
     2.452    44.047     0.150
     2.452    71.750     0.150
     2.452    75.250     0.150
     2.495    42.148     0.150
     2.495    42.148     0.150
     2.495    45.547     0.150
     2.495    78.945     0.150
     2.502    78.445     0.150
     2.502    42.148     0.150
     2.502    46.250     0.150
     2.502    78.445     0.150
     2.689    45.047     0.150
     2.689    49.945     0.150
     2.689    84.445     0.150
     3.503    67.445     0.150
     3.503    67.445     0.150
     3.503   109.047     0.150
     3.825    61.648     0.150
     3.825    69.148     0.150
     3.825   117.844     0.150
     3.844    60.750     0.150
     3.844    60.750     0.150
     3.844    69.547     0.150
     3.844   120.047     0.150
     4.092    63.945     0.150
     4.092    63.945     0.150
     4.092    74.047     0.150
     4.092   112.445     0.150
     4.092   126.250     0.150
     4.227   117.547     0.150
     4.227   129.648     0.150
     4.227    66.148     0.150
     4.227    77.547     0.150
     4.227   117.547     0.150
     4.227   132.547     0.150
     4.779   149.945     0.150
     4.779    87.250     0.150
     4.779   149.750     0.150
     5.298   167.648     0.150
     5.298    96.648     0.150
     5.298   166.250     0.150
     5.455    82.844     0.150
     5.455    99.547     0.150
     5.455   170.547     0.150
     5.576    99.648     0.150
     5.576    99.648     0.150
     5.576   170.148     0.150
     7.714   139.547     0.150
     7.714   139.547     0.150
     7.714   199.547     0.150
     7.714   239.844     0.150
     7.767   239.945     0.150
     7.920   242.250     0.150
     8.062   246.344     0.150
     0.330     6.711     0.150
     0.330     6.711     0.150
     2.484    89.711     0.150
     7.939   241.508     0.150
     8.080   245.805     0.150
     0.310     6.638     0.150
     2.048    33.638     0.150
     2.499    41.738     0.150
     2.499    77.738     0.150
     2.500    72.938     0.150
     2.500    42.138     0.150
     2.500    88.738     0.150
     2.500    42.138     0.150
     2.500    46.238     0.150
     2.500    78.738     0.150
     3.840    70.238     0.150
     3.840   119.738     0.150
     3.829   123.738     0.150
     3.829    62.338     0.150
     4.097    63.838     0.150
     4.776    91.938     0.150
     5.299   166.638     0.150
     5.299    79.238     0.150
     5.453   168.438     0.150
     5.581   173.838     0.150
     6.070    88.138     0.150
     6.070   186.037     0.150
     6.654   120.638     0.150
     6.654   206.537     0.150
     6.654    98.938     0.150
     6.654   120.738     0.150
     7.466   135.138     0.150
     7.470   107.148     0.150
     7.764   141.037     0.150
     7.764   242.938     0.150
     7.764   114.338     0.150
     7.764   140.638     0.150
     7.715   140.438     0.150
     7.715   240.037     0.150
     7.715   140.438     0.150
     7.992   145.138     0.150
     7.921   241.438     0.150
     8.043   146.738     0.150
     8.062   248.037     0.150
     9.042   164.238     0.150
     9.104   235.238     0.150
     9.746   176.738     0.150
    10.230   185.438     0.150
    10.230   265.838     0.150
    10.741   196.537     0.150
    10.741   273.938     0.150
    11.027   157.667     0.150
    11.112   160.037     0.150
    11.112   187.537     0.150
    11.112   285.838     0.150
    11.112   321.838     0.150
    11.289   208.238     0.150
    13.451   187.438     0.150
    13.451   420.238     0.150
    14.100   360.838     0.150
    15.417   214.037     0.150
    15.417   477.138     0.150
    15.749   216.037     0.150
    15.749   214.537     0.150
    15.749   486.338     0.150
    16.680   232.698     0.150
    18.053   459.838     0.150
    22.663     4.500     0.150
    22.663     7.000     0.150
    22.663    28.200     0.150
    22.663   545.838     0.150
    22.996     4.200     0.150
    22.996     7.000     0.150
    22.996    29.900     0.150
    24.283   311.838     0.150
    24.283   577.838     0.150
    24.283   577.838     0.150
    24.597     4.300     0.150
    24.597     6.500     0.150
    24.597    36.000     0.150
    24.597   368.638     0.150
    25.643     3.200     0.150
    31.857   801.438     0.150
    31.857   829.737     0.150
    31.857   383.787     0.150
    32.870   399.438     0.150
    32.870   395.398     0.150
    38.897   444.537     0.150
    39.873   455.138     0.150
    39.873   455.138     0.150
    40.427   457.978     0.150
    41.368   463.898     0.150
    42.849   478.297     0.150
    43.129   616.338     0.150
    43.262   479.838     0.150
    44.051   487.037     0.150
    44.051   487.037     0.150
    44.059   488.938     0.150
    44.059   488.938     0.150
    44.827   490.088     0.150
    47.310   505.338     0.150
    47.310   935.638     0.150
    48.877   525.238     0.150
    49.119   961.138     0.150
    49.119  1234.138     0.150
    49.401   528.738     0.150
    49.775   531.388     0.150
    52.472  1010.838     0.150
    53.583   563.018     0.150
    53.980   569.037     0.150
    54.616   574.138     0.150
    54.947   571.037     0.150
    55.252   572.618     0.150
    55.617   576.088     0.150
    55.931   578.237     0.150
    55.931   605.138     0.150
    55.982   577.838     0.150
    55.982     4.400     0.150
    55.982   577.838     0.150
    55.982     4.400     0.150
    55.982     6.400     0.150
    57.053   586.537     0.150
    57.053   586.537     0.150
    57.053   586.537     0.150
    57.421   589.237     0.150
    57.591   590.237     0.150
    57.702   591.338     0.150
    57.954   592.938     0.150
    57.954     3.900     0.150
    57.954   592.938     0.150
    57.954     3.900     0.150
    58.470   591.057     0.150
    59.116   601.438     0.150
    59.424   603.338     0.150
    59.498   602.967     0.150
    59.660   604.938     0.150
    59.692   605.237     0.150
    59.850   605.938     0.150
    59.904   606.438     0.150
    60.132   606.037     0.150
    60.398   607.938     0.150
    60.550   609.438     0.150
    61.199   613.537     0.150
    61.245   613.838     0.150
    62.483   621.438     0.150
    62.829   626.138     0.150
    63.117   627.438     0.150
    63.125   627.638     0.150
    63.125   626.138     0.150
    63.125   626.138     0.150
    63.195   626.237     0.150
    63.207   626.138     0.150
    63.339   627.638     0.150
    63.408   628.037     0.150
    63.518   629.818     0.150
    63.645   629.237     0.150
    63.747   630.838     0.150
    63.796   630.737     0.150
    64.180   633.737     0.150
    64.265   633.938     0.150
    64.364   634.338     0.150
    64.490   635.938     0.150
    64.546   635.638     0.150
    64.594   636.638     0.150
    64.755   637.138     0.150
    64.755   637.138     0.150
    64.866   637.737     0.150
    64.890   637.838     0.150
    64.998   638.737     0.150
    65.354   641.037     0.150
    65.459   642.338     0.150
    65.958   644.438     0.150
    65.958   644.438     0.150
    66.729   650.838     0.150
    67.726   656.438     0.150
    68.095   665.217     0.150
    68.186   659.438     0.150
    68.206   666.408     0.150
    68.983   671.757     0.150
    69.154   672.148     0.150
    70.316   678.578     0.150
    72.262   689.047     0.150
    72.598   693.037     0.150
    72.598   693.057     0.150
    72.798   692.537     0.150
    73.508   697.668     0.150
    73.544   698.698     0.150
    74.220   702.638     0.150
    74.220   702.638     0.150
    74.536   703.358     0.150
    74.757   701.477     0.150
    77.111   714.708     0.150
    77.111     4.570     0.150
    77.530   715.938     0.150
    80.065   730.537     0.150
    80.065   729.618     0.150
    81.308   737.138     0.150
    81.308   741.888     0.150
    82.325   741.537     0.150
    82.473   741.888     0.150
    83.282   747.128     0.150
    83.788   750.477     0.150
    85.031   755.007     0.150
    85.216   756.138     0.150
    86.275   761.598     0.150
    87.500   768.638     0.150
    88.471   772.628     0.150
   151.668  1210.037     0.150
   151.668  1197.838     0.150
   151.668  1210.037     0.150
   153.163  1217.037     0.150
   153.163  1206.138     0.150
   153.163  1217.037     0.150
   153.874  1207.338     0.150
     0.332     6.918     0.150
     0.332     6.918     0.150
     0.332     6.918     0.150
     0.332    11.219     0.150
     1.238    21.918     0.150
     2.444    50.617     0.150
     2.491    41.719     0.150
     2.491    45.316     0.150
     2.491    45.316     0.150
     2.491    74.418     0.150
     2.491    79.316     0.150
     3.824    60.219     0.150
     3.824    63.117     0.150
     3.845   123.520     0.150
     3.845    69.316     0.150
     4.205   129.219     0.150
     4.205    65.617     0.150
     5.432   100.418     0.150
     5.432   169.617     0.150
     5.432    82.117     0.150
     6.076    88.117     0.150
     6.076   186.219     0.150
     6.634   205.117     0.150
     6.634   122.418     0.150
     6.634   200.918     0.150
     6.634   209.918     0.150
     7.445   111.617     0.150
     7.445   135.020     0.150
     7.456   106.418     0.150
     7.456   135.020     0.150
     7.456   106.398     0.150
     7.456   135.020     0.150
     7.456   231.117     0.150
     7.744   140.418     0.150
     7.744   242.520     0.150
     7.744   140.719     0.150
     7.972   251.520     0.150
     7.943   240.816     0.150
     8.084   146.918     0.150
     8.084   114.957     0.150
     8.084   114.918     0.150
     8.084   244.418     0.150
     8.384   119.219     0.150
     8.384   254.316     0.150
     9.726   158.418     0.150
    10.211   200.520     0.150
    11.005   162.316     0.150
    11.143   164.316     0.150
    11.277   293.059     0.150
    11.277   162.699     0.150
    11.277   293.059     0.150
    11.277   356.949     0.150
    15.769   216.617     0.150
    26.772   338.977     0.150
     0.326     6.844     0.150
     0.326     6.844     0.150
     2.488    78.445     0.150
     7.936   240.539     0.150
     8.077   245.742     0.150
     8.378   254.641     0.150
     0.602    19.266     0.150
     2.167    38.062     0.150
     8.114   247.961     0.150
     8.261   251.664     0.150
     0.332    10.992     0.150
     2.483    46.792     0.150
     2.491    41.992     0.150
     2.491    73.592     0.150
     3.844   108.393     0.150
     5.278   167.192     0.150
     5.588   136.393     0.150
     5.588    82.992     0.150
     5.588   170.992     0.150
     6.635   120.792     0.150
     6.635   207.192     0.150
     6.635    99.192     0.150
     6.635   176.792     0.150
     7.445   135.292     0.150
     7.445   208.393     0.150
     7.455   107.862     0.150
     7.693   138.992     0.150
     7.693   238.992     0.150
     7.693   111.992     0.150
     7.693   140.192     0.150
     7.745   140.692     0.150
     7.745   241.192     0.150
     7.745   141.592     0.150
     7.942   113.492     0.150
     7.942   240.092     0.150
     8.157   147.893     0.150
     8.084   113.393     0.150
     8.084   197.893     0.150
     8.084   243.992     0.150
     9.022   174.393     0.150
    11.272   205.092     0.150
    11.272   315.292     0.150
    11.277   296.800     0.150
    26.773   340.232     0.150
    42.982   472.643     0.150
    54.407   562.976     0.150
    57.591   587.780     0.150
    74.063   690.565     0.150
    77.516   711.622     0.150
    81.112   733.092     0.150
     0.314     5.840     0.150
     0.314     6.742     0.150
     0.314     6.742     0.150
     0.314    10.941     0.150
     1.245    24.043     0.150
     2.504    73.141     0.150
     2.504    73.641     0.150
     2.504    78.543     0.150
     2.491    46.441     0.150
     2.491    79.043     0.150
     2.679    48.441     0.150
     3.491   113.141     0.150
     3.832    60.043     0.150
     3.993    72.543     0.150
     4.217    74.242     0.150
     4.217    65.242     0.150
     4.767   150.141     0.150
     4.767    81.840     0.150
     5.296   167.242     0.150
     5.296    97.441     0.150
     5.296   162.543     0.150
     5.296   167.242     0.150
     5.446   168.941     0.150
     5.590    99.941     0.150
     5.590   169.543     0.150
     6.078    88.742     0.150
     6.646   120.742     0.150
     7.117   102.242     0.150
     7.459   112.742     0.150
     7.459   135.340     0.150
     7.459   231.941     0.150
     7.483   161.543     0.150
     7.483   234.742     0.150
     7.711   140.043     0.150
     7.711   240.043     0.150
     7.711   140.141     0.150
     7.711   240.242     0.150
     7.757   140.441     0.150
     7.757   240.941     0.150
     7.757   122.543     0.150
     7.757   141.242     0.150
     7.757   241.840     0.150
     7.926   241.543     0.150
     8.067   247.742     0.150
     8.171   149.043     0.150
     8.171   255.043     0.150
     9.035   180.340     0.150
    10.223   187.340     0.150
    11.281   170.941     0.150
    11.281   314.840     0.150
     0.333     6.855     0.150
     0.333     6.855     0.150
     2.495    46.455     0.150
     2.495    78.455     0.150
     7.944   242.455     0.150
     8.086   245.555     0.150
     0.767    14.773     0.150
     0.767    14.773     0.150
     2.002    37.973     0.150
     2.002    37.973     0.150
     2.002    64.973     0.150
     0.765    14.719     0.150
     0.765    14.719     0.150
     0.765    14.719     0.150
     0.765    25.019     0.150
     1.286    23.818     0.150
     2.088    63.618     0.150
     2.088    39.019     0.150
     2.088    39.019     0.150
     2.088    39.019     0.150
     2.449    45.118     0.150
     2.719    49.019     0.150
     5.219    80.219     0.150
     6.474   118.118     0.150
     6.474   204.618     0.150
     7.284   224.519     0.150
     0.350    11.863     0.150
     0.359     7.207     0.150
     0.359     7.207     0.150
     0.359     7.207     0.150
     0.359    12.004     0.150
     2.311    69.305     0.150
     2.311    69.004     0.150
     2.311    39.906     0.150
     2.311    42.707     0.150
     2.311    73.004     0.150
     2.801    86.004     0.150
     3.030    94.707     0.150
     3.451    98.906     0.150
     3.878    92.207     0.150
     4.156   114.707     0.150
     5.153    77.105     0.150
     5.153   161.707     0.150
     5.477   108.504     0.150
     5.477   172.207     0.150
     6.997   127.805     0.150
     6.997   127.906     0.150
     6.997   220.707     0.150
     7.831   238.406     0.150
     7.872   143.105     0.150
     7.872   145.707     0.150
     7.872   249.004     0.150
    10.577   247.605     0.150
    11.463   152.406     0.150
    11.542   169.645     0.150
    11.542   367.223     0.150
    11.655   332.406     0.150
     1.283    24.688     0.150
     1.283    24.586     0.150
     1.283    26.289     0.150
     1.283    41.586     0.150
     1.613    30.188     0.150
     1.613    52.086     0.150
     1.613    30.289     0.150
     1.613    51.688     0.150
     2.166    39.492     0.150
     2.640    61.789     0.150
     2.631    92.289     0.150
     2.951    47.789     0.150
     2.951    53.586     0.150
     2.951    88.289     0.150
     3.249    66.391     0.150
     3.249    95.188     0.150
     3.249   107.188     0.150
     3.894   108.688     0.150
     4.460    80.289     0.150
     6.876   126.188     0.150
     6.876   218.188     0.150
     6.876   126.188     0.150
     0.342     6.797     0.150
     2.784    92.594     0.150
     3.463    51.094     0.150
     3.463    99.797     0.150
     4.204    80.695     0.150
     4.204    63.492     0.150
     5.141   161.195     0.150
     5.478   102.391     0.150
     5.478   171.891     0.150
     6.989   128.891     0.150
     6.989   128.492     0.150
     7.874   123.594     0.150
     7.874   247.891     0.150
     0.714    11.902     0.150
     0.714    11.902     0.150
     2.185    69.000     0.150
     2.590    45.402     0.150
     2.590    43.500     0.150
     3.116    82.402     0.150
     3.116    93.199     0.150
     3.437   105.602     0.150
     3.640    60.000     0.150
     3.640    64.602     0.150
     4.771    82.902     0.150
     4.771   146.699     0.150
     5.178    71.699     0.150
     5.178    78.500     0.150
     8.472   155.801     0.150
     8.472   239.102     0.150
     0.821    15.867     0.150
     0.821    26.664     0.150
     1.331    26.562     0.150
     2.019    35.969     0.150
     2.478    46.969     0.150
     2.478    46.867     0.150
     2.478    78.164     0.150
     2.534    49.266     0.150
     3.505    60.867     0.150
     3.904    68.266     0.150
     3.904   109.969     0.150
     3.816    63.867     0.150
     4.069    67.867     0.150
     4.069   124.867     0.150
     4.759    78.164     0.150
     4.759    73.867     0.150
     4.759   148.969     0.150
     4.845    79.867     0.150
     4.845    87.766     0.150
     4.845   152.867     0.150
     6.480   118.867     0.150
     6.480    97.664     0.150
     6.480   118.164     0.150
     6.480   203.164     0.150
     6.924    93.367     0.150
     6.924    93.359     0.150
     7.243   131.562     0.150
     7.243   106.664     0.150
     7.243   131.664     0.150
     7.243   225.664     0.150
     7.563   115.266     0.150
     7.563   137.266     0.150
     7.563   236.062     0.150
     8.919   161.664     0.150
     8.919   277.062     0.150
    10.064   181.766     0.150
    10.636   157.969     0.150
    16.282   225.766     0.150
    31.492   375.695     0.150
    44.161   492.969     0.150
    44.161   492.969     0.150
    55.615   572.562     0.150
    55.615   572.609     0.150
     0.818    15.781     0.150
     1.334    29.883     0.150
     1.334    45.180     0.150
     2.019    61.680     0.150
     2.482    46.883     0.150
     3.786   116.984     0.150
     3.900    68.680     0.150
     5.221    83.484     0.150
     7.247   131.484     0.150
     7.247   225.578     0.150
     0.685    13.316     0.150
     0.685    13.316     0.150
     0.685    16.516     0.150
     0.685    24.219     0.150
     0.685    22.316     0.150
     1.009    21.219     0.150
     1.009    36.418     0.150
     1.009    18.918     0.150
     2.351    43.117     0.150
     2.351    74.219     0.150
     2.404    43.516     0.150
     2.404    43.516     0.150
     2.404    45.316     0.150
     2.392    71.117     0.150
     2.392    41.016     0.150
     2.392    70.617     0.150
     3.892    70.816     0.150
     5.098   138.516     0.150
     0.679    13.290     0.150
     0.679    13.290     0.150
     0.679    13.290     0.150
     0.679    22.190     0.150
     1.010    36.290     0.150
     2.219    70.290     0.150
     2.355    42.990     0.150
     2.402    43.190     0.150
     2.396    70.990     0.150
     2.396    86.590     0.150
     2.396    43.890     0.150
     2.396    70.790     0.150
     2.396    75.790     0.150
     3.897    61.390     0.150
     4.504   141.490     0.150
     4.936   154.390     0.150
     5.731   178.990     0.150
     6.188   193.390     0.150
     7.356   230.190     0.150
     7.356   133.890     0.150
     7.356   229.490     0.150
     7.425   232.990     0.150
     0.695    14.375     0.150
     0.695    24.281     0.150
     0.695    14.375     0.150
     0.695    22.180     0.150
     0.695    24.281     0.150
     1.004    36.477     0.150
     1.004    18.977     0.150
     1.004    21.281     0.150
     1.004    32.680     0.150
     1.004    36.477     0.150
     2.209    38.781     0.150
     2.209    41.078     0.150
     2.209    70.375     0.150
     2.342    40.781     0.150
     2.342    43.180     0.150
     2.342    74.477     0.150
     2.404    43.477     0.150
     2.404    41.375     0.150
     2.404    43.477     0.150
     2.404    74.680     0.150
     2.390    86.680     0.150
     2.390    44.078     0.150
     2.390    41.281     0.150
     2.390    44.078     0.150
     2.390    76.180     0.150
     2.390    86.680     0.150
     3.227   100.875     0.150
     3.554    57.078     0.150
     3.554    64.281     0.150
     3.554   111.578     0.150
     3.884   138.477     0.150
     3.884    61.477     0.150
     3.884    71.078     0.150
     3.884   122.680     0.150
     3.884   138.477     0.150
     4.495   141.078     0.150
     5.089   160.375     0.150
     5.735   176.875     0.150
     7.340   229.375     0.150
     0.691    13.457     0.150
     0.691    13.457     0.150
     0.691    13.855     0.150
     1.007    20.555     0.150
     1.007    19.156     0.150
     1.007    20.555     0.150
     1.007    32.457     0.150
     2.213    41.254     0.150
     2.213    41.254     0.150
     2.213    70.055     0.150
     2.347    40.355     0.150
     2.347    43.055     0.150
     2.347    74.156     0.150
     2.407    45.555     0.150
     2.407    43.656     0.150
     2.407    74.656     0.150
     2.389    86.656     0.150
     2.389    41.254     0.150
     2.389    70.957     0.150
     2.389    75.855     0.150
     2.389    41.254     0.150
     2.389    44.055     0.150
     2.389    71.055     0.150
     2.389    75.855     0.150
     2.389    86.656     0.150
     3.231    74.656     0.150
     3.231    74.656     0.150
     3.231   101.555     0.150
     3.558    46.355     0.150
     3.558    56.754     0.150
     3.558    64.457     0.150
     3.558   111.656     0.150
     3.888    61.656     0.150
     3.888    61.754     0.150
     3.888    71.855     0.150
     3.888   122.855     0.150
     4.014    91.355     0.150
     4.499    82.156     0.150
     4.499   140.555     0.150
     4.923    89.254     0.150
     4.923   132.656     0.150
     4.923   153.355     0.150
     5.094    78.055     0.150
     5.094   161.355     0.150
     5.094    77.957     0.150
     5.094    92.855     0.150
     5.094   160.254     0.150
     5.935   159.957     0.150
     5.935    89.254     0.150
     5.935   108.555     0.150
     5.935   159.957     0.150
     5.935   186.855     0.150
     6.314   175.254     0.150
     6.314    94.754     0.150
     6.314   197.055     0.150
     6.314    94.754     0.150
     6.314   115.055     0.150
     6.314   175.254     0.150
     6.314   198.355     0.150
     6.556   119.656     0.150
     7.343   134.355     0.150
     7.343   199.457     0.150
     7.343   111.555     0.150
     7.343   132.957     0.150
     7.343   230.355     0.150
     7.343   107.457     0.150
     7.343   134.355     0.150
     7.343   199.457     0.150
     7.343   230.156     0.150
     7.416   146.254     0.150
     7.416   146.254     0.150
     7.416   231.656     0.150
     7.810   142.957     0.150
     7.810   244.855     0.150
     8.690   268.656     0.150
     9.895   178.555     0.150
     9.895   178.555     0.150
     9.895   306.754     0.150
    10.980   304.957     0.150
    10.980   304.957     0.150
    10.980   340.055     0.150
     0.429    14.223     0.150
     1.048    25.223     0.150
     1.048    39.023     0.150
     1.048    19.523     0.150
     1.048    22.125     0.150
     1.048    23.324     0.150
     1.048    25.223     0.150
     1.048    33.824     0.150
     1.048    39.023     0.150
     2.204    38.422     0.150
     2.204    40.125     0.150
     2.204    65.922     0.150
     2.204    69.023     0.150
     2.300    44.625     0.150
     2.300    42.324     0.150
     2.300    72.324     0.150
     2.527    45.125     0.150
     2.527    81.824     0.150
     2.527    43.324     0.150
     2.527    45.125     0.150
     2.527    46.523     0.150
     2.527    80.023     0.150
     2.696    53.523     0.150
     2.696    96.223     0.150
     2.696    45.223     0.150
     2.696    49.324     0.150
     2.696    53.523     0.150
     2.696    85.223     0.150
     2.696    96.223     0.150
     3.288   103.324     0.150
     3.635    59.223     0.150
     3.635    65.922     0.150
     3.635   113.922     0.150
     4.057    66.125     0.150
     4.057    64.023     0.150
     4.057    66.125     0.150
     4.057    73.922     0.150
     4.057   111.223     0.150
     4.057   127.223     0.150
     4.566    72.125     0.150
     4.566    83.422     0.150
     4.566   142.723     0.150
     5.274    96.523     0.150
     5.274   165.625     0.150
     5.312    81.922     0.150
     5.312    97.023     0.150
     5.312   167.125     0.150
     6.486    99.223     0.150
     6.486   121.125     0.150
     6.486    99.223     0.150
     6.486   121.125     0.150
     6.486   203.125     0.150
     7.605   238.125     0.150
     7.700   122.125     0.150
     7.700   143.723     0.150
     7.700   112.723     0.150
     7.700   122.125     0.150
     7.700   143.723     0.150
     7.700   241.523     0.150
     0.680    13.320     0.150
     0.680    13.320     0.150
     0.680    13.320     0.150
     2.217    38.117     0.150
     2.217    40.922     0.150
     2.217    38.117     0.150
     2.217    40.922     0.150
     2.217    69.617     0.150
     2.354    43.016     0.150
     2.354    40.117     0.150
     2.354    43.016     0.150
     2.354    73.719     0.150
     2.402    45.320     0.150
     2.402    74.117     0.150
     2.402    43.516     0.150
     2.402    74.117     0.150
     2.396    47.422     0.150
     2.396    86.422     0.150
     2.396    70.516     0.150
     2.396    75.617     0.150
     2.396    40.922     0.150
     2.396    43.820     0.150
     2.396    47.422     0.150
     2.396    75.617     0.150
     2.396    86.422     0.150
     3.235    59.422     0.150
     3.235   101.719     0.150
     3.562    56.820     0.150
     3.562    56.820     0.150
     3.562    64.422     0.150
     3.562   110.922     0.150
     3.895    61.320     0.150
     3.895    71.320     0.150
     3.895   122.617     0.150
     4.503    70.320     0.150
     4.503    82.922     0.150
     4.503   141.617     0.150
     4.935   154.617     0.150
     4.935    75.719     0.150
     4.935    89.719     0.150
     4.935   132.516     0.150
     4.935   153.117     0.150
     5.102    77.922     0.150
     5.102   160.016     0.150
     5.102    77.922     0.150
     5.102    93.320     0.150
     5.102   160.320     0.150
     6.321   115.320     0.150
     6.321   196.922     0.150
     6.321    94.516     0.150
     6.321   115.117     0.150
     6.321   196.922     0.150
     7.354   134.016     0.150
     7.354   132.320     0.150
     7.354   229.516     0.150
     7.354   107.219     0.150
     7.354   134.016     0.150
     7.354   191.016     0.150
     7.354   229.320     0.150
     7.424   109.320     0.150
     7.424   232.820     0.150
     9.407   172.320     0.150
     9.407   172.320     0.150
     9.407   294.820     0.150
     9.902   233.320     0.150
     9.902   233.320     0.150
     9.902   309.922     0.150
    10.787   309.422     0.150
    10.787   309.422     0.150
    10.985   305.820     0.150
    10.985   157.820     0.150
    10.985   305.820     0.150
    10.985   342.820     0.150
     0.365     7.211     0.150
     2.309    43.508     0.150
     2.813    93.609     0.150
     3.343    89.312     0.150
     3.436    65.609     0.150
     3.436   111.008     0.150
     3.710    70.109     0.150
     3.893   124.312     0.150
     4.141   151.414     0.150
     4.231    66.211     0.150
     4.586    71.414     0.150
     5.168    93.812     0.150
     5.787   184.508     0.150
     6.630   121.312     0.150
     6.630   235.711     0.150
     7.012   222.414     0.150
     7.790   141.109     0.150
     7.882   127.609     0.150
     7.882   143.609     0.150
     7.882   115.211     0.150
     7.882   143.609     0.150
     8.114   149.711     0.150
     8.497   155.609     0.150
    10.802   279.414     0.150
    15.697   215.109     0.150
    15.697   400.711     0.150
    24.247   310.914     0.150
    42.737   479.211     0.150
    44.052   489.609     0.150
     0.062     2.828     0.150
     0.062     4.422     0.150
     1.517    29.328     0.150
     1.517    50.828     0.150
     2.494    47.125     0.150
     2.769    45.828     0.150
     2.769    84.328     0.150
     3.532    59.227     0.150
     3.532   101.328     0.150
     3.606   115.922     0.150
     3.606    58.328     0.150
     3.606   115.625     0.150
     3.745    59.828     0.150
     4.098    77.125     0.150
     4.098    64.328     0.150
     4.535    70.523     0.150
     5.024   156.523     0.150
     5.787   106.125     0.150
     5.787   192.828     0.150
     5.787   106.828     0.150
     5.787   180.328     0.150
     6.622   121.227     0.150
     6.964   127.523     0.150
     7.696   233.523     0.150
     7.696   109.531     0.150
     7.749   114.828     0.150
     7.749   142.023     0.150
     7.749   112.625     0.150
     7.749   244.828     0.150
     7.805   113.727     0.150
     7.805   123.828     0.150
     7.805   141.828     0.150
     7.805   249.523     0.150
     8.085   148.023     0.150
     8.085   230.125     0.150
     8.085   117.625     0.150
     8.085   148.523     0.150
     8.520   155.922     0.150
     8.520   276.828     0.150
     9.365   264.727     0.150
    11.395   157.188     0.150
    11.395   299.266     0.150
    11.410   330.125     0.150
    11.410   286.125     0.150
    11.665   299.383     0.150
    11.665   168.625     0.150
    11.665   299.422     0.150
    15.401   211.422     0.150
    16.705   244.227     0.150
    16.705     3.602     0.150
    16.705     6.195     0.150
    16.705   254.523     0.150
    21.335     5.195     0.150
    21.335     9.297     0.150
    23.975   314.656     0.150
    24.126   315.492     0.150
    24.182   317.625     0.150
    25.929   330.125     0.150
    27.325   345.828     0.150
    27.366   345.008     0.150
    31.103   379.977     0.150
    33.232   398.062     0.150
    35.245   413.828     0.150
    44.512   494.227     0.150
    44.512   494.195     0.150
    44.682   499.805     0.150
    49.282   530.227     0.150
    49.282   530.203     0.150
    49.376   528.922     0.150
    57.544   590.523     0.150
     0.908    27.851     0.150
     1.522    32.950     0.150
     1.522    28.351     0.150
     1.522    48.351     0.150
     1.522    28.351     0.150
     1.522    29.450     0.150
     1.522    32.950     0.150
     1.522    48.450     0.150
     1.522    50.750     0.150
     2.490    44.650     0.150
     2.490    70.351     0.150
     2.490    76.450     0.150
     2.711    84.150     0.150
     2.711    45.150     0.150
     2.711    49.351     0.150
     2.711    77.650     0.150
     2.711    84.250     0.150
     2.773    53.851     0.150
     2.773    52.250     0.150
     2.773    53.851     0.150
     2.773    86.150     0.150
     3.013    49.650     0.150
     3.013    55.450     0.150
     3.013    94.051     0.150
     3.605    60.851     0.150
     3.605   111.551     0.150
     3.748   116.450     0.150
     4.024   124.150     0.150
     4.101    77.250     0.150
     4.101    64.551     0.150
     4.101    64.650     0.150
     4.101    77.250     0.150
     4.101   127.450     0.150
     4.542    70.450     0.150
     4.542    82.250     0.150
     4.542   141.551     0.150
     5.027   157.950     0.150
     5.027    91.851     0.150
     5.027   156.650     0.150
     5.683   177.851     0.150
     5.796    87.150     0.150
     5.796   180.650     0.150
     6.799   209.150     0.150
     6.971   217.150     0.150
     0.679    13.239     0.150
     0.679    21.939     0.150
     1.004    20.540     0.150
     1.004    19.040     0.150
     1.004    20.540     0.150
     1.004    32.239     0.150
     1.004    36.439     0.150
     1.477    38.939     0.150
     1.477    43.840     0.150
     2.214    40.840     0.150
     2.214    69.840     0.150
     2.351    43.040     0.150
     2.351    43.040     0.150
     2.351    43.040     0.150
     2.395    41.939     0.150
     2.395    43.439     0.150
     2.395    74.340     0.150
     2.403    47.739     0.150
     2.403    86.140     0.150
     2.403    70.540     0.150
     2.403    41.040     0.150
     2.403    43.840     0.150
     2.403    47.739     0.150
     2.403    75.739     0.150
     2.403    86.140     0.150
     3.231    58.739     0.150
     3.231   100.840     0.150
     3.558    56.640     0.150
     3.558    64.140     0.150
     3.558   111.140     0.150
     4.499    69.939     0.150
     4.499    82.540     0.150
     4.499   121.939     0.150
     4.499   141.140     0.150
     4.937    89.939     0.150
     4.937   153.640     0.150
     5.101    85.640     0.150
     5.101    77.540     0.150
     5.101    85.640     0.150
     5.101    92.939     0.150
     5.101   159.840     0.150
     5.941   184.939     0.150
     6.319   114.640     0.150
     6.319   197.239     0.150
     6.319    94.340     0.150
     6.319   114.840     0.150
     6.319   197.040     0.150
     7.357   166.640     0.150
     7.357   166.640     0.150
     7.357   215.340     0.150
     7.357   227.939     0.150
     7.422   197.040     0.150
     7.422   197.040     0.150
     7.422   231.840     0.150
     1.346    28.770     0.150
     2.150    59.770     0.150
     2.150    37.871     0.150
     2.150    65.270     0.150
     2.710    49.070     0.150
     2.710    49.070     0.150
     3.800   108.270     0.150
     3.885    62.070     0.150
     4.183    66.170     0.150
     4.827   152.371     0.150
     5.358   188.070     0.150
     6.203    95.871     0.150
     6.203   114.170     0.150
     6.603   121.070     0.150
     6.603   121.670     0.150
     7.107   105.121     0.150
     7.355   110.670     0.150
     7.355   133.570     0.150
     7.355   203.770     0.150
     7.444   233.570     0.150
     7.695   140.270     0.150
     7.695   240.871     0.150
    10.821   162.670     0.150
    11.290   288.471     0.150
    16.077   223.670     0.150
    19.086   594.945     0.150
    20.763   294.270     0.150
    20.763   297.070     0.150
    23.880   317.141     0.150
    23.968   315.971     0.150
    26.948   343.730     0.150
    28.134   354.730     0.150
    38.327   442.750     0.150
    47.498   520.281     0.150
    57.716   595.070     0.150
    70.241   675.240     0.150
    73.336   696.281     0.150
    73.852   697.041     0.150
    74.246   700.791     0.150
    80.760   727.070     0.150
    80.761   727.070     0.150
    81.549   740.711     0.150
    83.591   750.840     0.150
     0.589    10.914     0.150
     0.589    10.914     0.150
     0.589    18.814     0.150
     1.321    25.014     0.150
     1.321    26.814     0.150
     1.321    42.414     0.150
     1.321    42.713     0.150
     1.321    25.014     0.150
     1.321    26.814     0.150
     1.321    42.414     0.150
     2.188    39.414     0.150
     2.188    64.314     0.150
     2.188    37.113     0.150
     2.188    39.414     0.150
     2.188    67.713     0.150
     2.523    42.514     0.150
     2.523    45.514     0.150
     2.523    78.814     0.150
     2.633    44.713     0.150
     2.633    47.113     0.150
     2.633    44.713     0.150
     2.633    47.213     0.150
     2.633    81.713     0.150
     2.675    47.713     0.150
     2.675    82.613     0.150
     3.543   111.414     0.150
     3.814   108.014     0.150
     3.867   118.613     0.150
     3.867    60.414     0.150
     3.867    68.713     0.150
     3.867   105.213     0.150
     3.867   119.014     0.150
     3.946   106.914     0.150
     4.174    65.814     0.150
     4.174    65.814     0.150
     4.174    75.314     0.150
     4.174   113.613     0.150
     4.174   129.514     0.150
     4.809    72.314     0.150
     4.809    86.213     0.150
     4.809   148.914     0.150
     5.355    97.414     0.150
     5.355   167.113     0.150
     6.199   141.713     0.150
     6.199   194.014     0.150
     6.595   101.613     0.150
     6.595   120.314     0.150
     6.595   101.613     0.150
     6.595   120.314     0.150
     6.595   168.713     0.150
     6.595   207.213     0.150
     7.462   137.613     0.150
     7.462   232.414     0.150
     7.689   240.914     0.150
     0.607    11.758     0.150
     1.338    44.258     0.150
     2.164    82.461     0.150
     2.164    65.656     0.150
     2.536    48.258     0.150
     2.536    74.461     0.150
     2.536    79.461     0.150
     2.640    48.461     0.150
     2.698    48.859     0.150
     2.698    48.859     0.150
     3.804    57.055     0.150
     3.879   101.258     0.150
     4.181    76.055     0.150
     5.403    93.758     0.150
     6.601   120.758     0.150
     6.601   120.555     0.150
     6.601   206.555     0.150
     7.355   125.859     0.150
     7.355   203.555     0.150
     7.451   144.359     0.150
     7.694   211.461     0.150
     7.694   139.156     0.150
    10.643   284.961     0.150
    10.825   157.078     0.150
    10.825   277.781     0.150
    10.881   283.258     0.150
    16.067   220.055     0.150
    19.079   266.930     0.150
    19.079   266.930     0.150
    19.637   276.555     0.150
    23.873   312.469     0.150
    23.953   317.258     0.150
    23.953   317.227     0.150
    28.125   351.945     0.150
    32.071   395.055     0.150
    32.071   395.055     0.150
    44.050   489.359     0.150
    49.625   533.359     0.150
    55.243   577.555     0.150
    55.243   577.555     0.150
    57.871   593.961     0.150
    77.178   714.461     0.150
     0.605    11.812     0.150
     0.605    11.812     0.150
     0.605    18.512     0.150
     1.212    43.711     0.150
     1.342    24.812     0.150
     1.342    26.211     0.150
     1.342    43.512     0.150
     1.342    45.910     0.150
     2.163    64.812     0.150
     2.163    80.312     0.150
     2.163    65.113     0.150
     2.163    68.512     0.150
     2.163    38.312     0.150
     2.163    40.211     0.150
     2.163    64.812     0.150
     2.163    68.512     0.150
     2.163    80.312     0.150
     2.540    43.613     0.150
     2.540    46.910     0.150
     2.540    74.312     0.150
     2.540    79.910     0.150
     2.701    45.012     0.150
     2.701    49.113     0.150
     2.701    77.312     0.150
     2.701    84.312     0.150
     3.800    47.613     0.150
     3.884    60.211     0.150
     3.884    62.211     0.150
     3.884    70.012     0.150
     3.884   106.312     0.150
     3.884   121.711     0.150
     4.826   152.613     0.150
     4.826    75.512     0.150
     4.826    88.613     0.150
     4.826   129.711     0.150
     4.826   150.211     0.150
     6.207   192.410     0.150
     6.207   199.012     0.150
     6.207   192.410     0.150
     6.207   199.012     0.150
     6.606   120.812     0.150
     6.606   121.312     0.150
     6.606   206.910     0.150
     6.606    98.910     0.150
     6.606   120.812     0.150
     6.606   171.113     0.150
     6.606   206.812     0.150
     7.360   228.910     0.150
     7.454   130.410     0.150
     7.454   238.211     0.150
     7.454   110.512     0.150
     7.454   130.410     0.150
     7.454   233.312     0.150
     7.454   238.211     0.150
     7.699   239.812     0.150
     0.607    11.805     0.150
     0.607    11.805     0.150
     0.607    18.004     0.150
     0.607    11.805     0.150
     1.347    26.705     0.150
     1.347    44.305     0.150
     1.347    24.805     0.150
     2.158    64.805     0.150
     2.158    40.205     0.150
     2.158    65.104     0.150
     2.158    68.705     0.150
     2.544    46.904     0.150
     2.706    49.104     0.150
     2.706    49.104     0.150
     3.888    59.904     0.150
     3.888    69.104     0.150
     4.189    66.205     0.150
     4.830   152.004     0.150
     5.365    97.504     0.150
     5.365   167.705     0.150
     6.609   103.305     0.150
     6.609   121.604     0.150
     6.609   207.805     0.150
     7.362   133.205     0.150
     7.362   203.104     0.150
     7.454   135.305     0.150
     7.454   235.104     0.150
     7.702   139.904     0.150
     7.702   185.205     0.150
     7.950   147.004     0.150
     8.066   146.104     0.150
     8.066   259.305     0.150
    10.830   161.604     0.150
    10.873   283.805     0.150
    11.111   276.885     0.150
    44.057   491.004     0.150
    49.633   534.205     0.150
    57.879   595.268     0.150
    77.174   715.305     0.150
     0.648    12.828     0.150
     0.648    21.125     0.150
     1.012    20.727     0.150
     1.012    18.625     0.150
     1.012    20.727     0.150
     1.012    32.227     0.150
     1.012    36.125     0.150
     2.228    40.727     0.150
     2.228    70.125     0.150
     2.385    43.023     0.150
     2.385    74.023     0.150
     2.385    43.023     0.150
     2.385    74.023     0.150
     2.373    40.023     0.150
     2.373    42.922     0.150
     2.373    73.922     0.150
     2.421    86.922     0.150
     2.421    43.727     0.150
     2.421    40.922     0.150
     2.421    43.727     0.150
     2.421    75.523     0.150
     2.421    86.922     0.150
     3.572    56.523     0.150
     3.572    63.828     0.150
     3.572   110.625     0.150
     3.914    61.125     0.150
     3.914    71.023     0.150
     3.914   123.328     0.150
     4.513    81.523     0.150
     4.513   140.625     0.150
     4.969    90.828     0.150
     4.969   156.625     0.150
     5.125    92.922     0.150
     5.125   160.922     0.150
     6.341    91.922     0.150
     6.341    91.922     0.150
     6.341   198.828     0.150
     7.389   216.828     0.150
     7.389   229.727     0.150
     7.445    61.523     0.150
     7.445   232.328     0.150
     8.720   272.227     0.150
     9.921   308.227     0.150
     0.290     5.993     0.150
     0.290     9.594     0.150
     1.310    24.193     0.150
     2.465    88.493     0.150
     2.465    41.594     0.150
     2.502    73.993     0.150
     3.556    61.993     0.150
     3.773    61.193     0.150
     3.800    71.493     0.150
     3.896    74.293     0.150
     3.896    58.993     0.150
     4.039   109.993     0.150
     4.275   131.894     0.150
     5.499   171.293     0.150
     6.703   121.693     0.150
     6.703   122.094     0.150
     6.703   210.793     0.150
     7.734   258.394     0.150
     7.812   165.693     0.150
    11.163   286.193     0.150
    11.343   313.894     0.150
     0.825    32.190     0.150
     0.825    15.890     0.150
     0.825    26.890     0.150
     0.825    32.190     0.150
     0.838    16.290     0.150
     0.838    27.190     0.150
     2.022    37.290     0.150
     2.022    37.390     0.150
     2.022    64.690     0.150
     2.160    68.090     0.150
     2.160    37.890     0.150
     2.160    39.990     0.150
     2.160    68.090     0.150
     2.279    41.790     0.150
     2.279    71.290     0.150
     2.488    42.790     0.150
     2.488    45.490     0.150
     2.488    78.790     0.150
     3.367    65.090     0.150
     3.367    54.590     0.150
     3.367    65.090     0.150
     3.367   105.890     0.150
     3.701    59.290     0.150
     3.701    67.090     0.150
     3.701   116.690     0.150
     4.308    80.990     0.150
     4.308    80.990     0.150
     4.308   135.190     0.150
     4.810   150.490     0.150
     4.916    75.690     0.150
     4.916    90.090     0.150
     4.916   155.390     0.150
     5.908    86.790     0.150
     5.908   105.290     0.150
     5.908   151.990     0.150
     5.908   181.790     0.150
     6.128   190.690     0.150
     7.236   224.590     0.150
     0.595    19.489     0.150
     1.327    25.989     0.150
     1.327    43.589     0.150
     1.327    46.289     0.150
     2.180    38.089     0.150
     2.180    39.889     0.150
     2.180    69.089     0.150
     2.527    44.489     0.150
     2.527    46.389     0.150
     2.527    79.889     0.150
     2.636    44.689     0.150
     2.636    47.789     0.150
     2.636    82.789     0.150
     2.683    48.889     0.150
     2.683    50.989     0.150
     2.683    83.589     0.150
     3.786   104.989     0.150
     3.871    61.789     0.150
     3.871    69.589     0.150
     3.871   104.289     0.150
     3.871   120.589     0.150
     4.176    63.089     0.150
     4.176    64.289     0.150
     4.176    64.289     0.150
     4.176   113.389     0.150
     4.176   131.089     0.150
     4.813    74.789     0.150
     4.813    86.889     0.150
     4.813   149.789     0.150
     5.056   159.289     0.150
     5.356   167.889     0.150
     5.356    81.789     0.150
     5.356    97.389     0.150
     5.356   166.989     0.150
     6.200   195.089     0.150
     6.597   203.989     0.150
     6.597   120.289     0.150
     6.597   169.889     0.150
     6.597    99.189     0.150
     6.597   120.289     0.150
     6.597   169.889     0.150
     6.597   206.489     0.150
     7.354   230.189     0.150
     7.458   108.889     0.150
     7.458   232.889     0.150
     8.059   252.189     0.150
     0.385     7.766     0.150
     0.385    12.867     0.150
     2.434    41.469     0.150
     2.434    44.367     0.150
     2.434    77.070     0.150
     2.480    44.867     0.150
     2.480    77.172     0.150
     2.474    45.172     0.150
     2.474    77.969     0.150
     2.645    47.969     0.150
     2.645    44.469     0.150
     2.645    47.969     0.150
     2.645    83.070     0.150
     3.481    63.469     0.150
     3.481    63.469     0.150
     3.481   110.070     0.150
     3.756    49.367     0.150
     3.849    73.070     0.150
     3.818   117.172     0.150
     3.818    74.172     0.150
     3.818    60.766     0.150
     3.818    69.266     0.150
     3.818    74.172     0.150
     3.818   118.867     0.150
     4.184    65.672     0.150
     4.184    65.672     0.150
     4.184    75.570     0.150
     4.184   131.570     0.150
     4.755    74.172     0.150
     4.755    85.469     0.150
     4.755   148.070     0.150
     5.224   164.867     0.150
     5.403    82.266     0.150
     5.403    98.266     0.150
     5.403   169.867     0.150
     5.565    80.570     0.150
     5.565   140.367     0.150
     6.243    93.570     0.150
     6.243   112.867     0.150
     6.243   195.367     0.150
     6.613   120.070     0.150
     6.613   204.172     0.150
     6.613   120.172     0.150
     6.613    98.867     0.150
     6.613   120.172     0.150
     6.613   206.570     0.150
     7.413   134.469     0.150
     7.413   109.672     0.150
     7.413   134.469     0.150
     7.413   230.969     0.150
     7.441   232.367     0.150
     7.638   138.570     0.150
     7.638   112.070     0.150
     7.638   138.570     0.150
     7.638   196.367     0.150
     7.638   238.867     0.150
     7.720   114.070     0.150
     7.720   242.172     0.150
     8.996   279.969     0.150
    10.191   184.367     0.150
    10.191   184.367     0.150
    10.191   315.867     0.150
    10.960   283.469     0.150
    11.074   284.867     0.150
    11.259   349.969     0.150
     0.398     7.895     0.150
     0.398     7.895     0.150
     0.398     7.895     0.150
     2.421    41.492     0.150
     2.421    44.395     0.150
     2.421    76.793     0.150
     2.421    41.492     0.150
     2.421    44.395     0.150
     2.421    76.793     0.150
     2.488    44.992     0.150
     2.488    44.992     0.150
     2.488    44.992     0.150
     2.472    45.395     0.150
     2.472    78.094     0.150
     2.639    44.492     0.150
     2.639    48.094     0.150
     2.639    83.395     0.150
     3.480    61.793     0.150
     3.480   110.293     0.150
     3.480    63.293     0.150
     3.480   110.293     0.150
     3.851    72.992     0.150
     3.865    62.492     0.150
     3.816    58.992     0.150
     3.816    74.695     0.150
     3.816    60.992     0.150
     3.816    68.992     0.150
     3.816    74.695     0.150
     3.816   118.992     0.150
     4.179    73.992     0.150
     4.179    65.895     0.150
     4.179    65.895     0.150
     4.179    76.594     0.150
     4.179   131.895     0.150
     4.754    74.395     0.150
     4.754    85.992     0.150
     4.754    88.195     0.150
     4.754   148.094     0.150
     5.211   165.094     0.150
     5.396   169.895     0.150
     5.396    84.594     0.150
     5.396   169.992     0.150
     5.396    82.395     0.150
     5.396    84.594     0.150
     5.396    98.395     0.150
     5.396   169.992     0.150
     5.560    80.492     0.150
     6.236    93.895     0.150
     6.236   113.195     0.150
     6.236   195.793     0.150
     6.607   203.594     0.150
     6.607    98.793     0.150
     6.607   120.293     0.150
     6.607    98.793     0.150
     6.607   120.293     0.150
     6.607   206.594     0.150
     7.434   231.492     0.150
     7.625   138.594     0.150
     7.625   111.793     0.150
     7.625   138.594     0.150
     7.625   197.895     0.150
     7.625   237.492     0.150
     7.714   140.695     0.150
     7.714   114.395     0.150
     7.714   140.695     0.150
     7.714   241.895     0.150
     8.140   105.695     0.150
     8.116   146.895     0.150
     8.116   119.793     0.150
     8.116   146.895     0.150
     8.116   251.395     0.150
     8.990   280.594     0.150
     9.697   303.594     0.150
    10.186   315.895     0.150
    11.069   283.895     0.150
    11.256   181.992     0.150
    11.256   181.992     0.150
    11.256   350.195     0.150
     0.397     7.816     0.150
     0.397     7.816     0.150
     0.397     7.816     0.150
     1.231    22.918     0.150
     1.231    43.316     0.150
     2.427    44.418     0.150
     2.427    44.418     0.150
     2.427    77.117     0.150
     2.468    42.219     0.150
     2.481    45.020     0.150
     2.481    45.020     0.150
     3.475    63.316     0.150
     3.475    99.617     0.150
     3.475   110.020     0.150
     3.812    58.117     0.150
     3.855   109.219     0.150
     3.855    68.117     0.150
     4.176    66.020     0.150
     4.176    66.020     0.150
     4.176    66.020     0.150
     5.212   163.719     0.150
     5.394   169.020     0.150
     5.394    82.520     0.150
     6.604   120.316     0.150
     6.604   206.918     0.150
     7.382   107.219     0.150
     7.382   132.816     0.150
     7.382   189.219     0.150
     7.382   230.918     0.150
     7.404   134.117     0.150
     7.626   141.117     0.150
     7.626   239.316     0.150
     7.626   138.520     0.150
     7.711   138.816     0.150
     7.711   240.316     0.150
     7.711   240.219     0.150
     7.984   145.719     0.150
     8.140   247.520     0.150
    11.101   171.719     0.150
    11.101   284.418     0.150
    11.252   315.719     0.150
    15.842   218.340     0.150
    15.842   385.898     0.150
    15.842   219.316     0.150
    18.944   265.527     0.150
    18.944   265.793     0.150
    18.960   265.816     0.150
    43.806   489.137     0.150
    43.806   489.117     0.150
    43.806   489.145     0.150
     0.388     7.648     0.150
     0.388     7.648     0.150
     0.388     7.648     0.150
     0.388    12.750     0.150
     1.229    22.750     0.150
     1.229    24.945     0.150
     1.229    43.250     0.150
     2.438    73.047     0.150
     2.438    76.844     0.150
     2.438    41.047     0.150
     2.438    44.250     0.150
     2.438    73.047     0.150
     2.438    76.844     0.150
     2.474    44.844     0.150
     2.474    44.844     0.150
     2.474    71.750     0.150
     2.468    41.750     0.150
     2.468    45.250     0.150
     2.468    72.648     0.150
     2.468    77.547     0.150
     2.639    44.445     0.150
     2.639    44.445     0.150
     2.639    48.047     0.150
     2.639    77.047     0.150
     2.639    83.445     0.150
     3.474   108.445     0.150
     3.811    60.750     0.150
     3.811    68.344     0.150
     3.811   118.547     0.150
     4.178    65.250     0.150
     4.178    75.344     0.150
     4.178   130.250     0.150
     4.749    86.750     0.150
     4.749   148.148     0.150
     5.221   163.344     0.150
     5.221    78.148     0.150
     5.221    94.547     0.150
     5.221   138.945     0.150
     5.221   163.148     0.150
     5.398   169.047     0.150
     5.398   169.047     0.150
     5.398    82.148     0.150
     5.398    98.250     0.150
     5.398   143.648     0.150
     5.398   169.047     0.150
     6.238    93.945     0.150
     6.238   113.344     0.150
     6.238   196.547     0.150
     6.607   120.844     0.150
     6.607    99.047     0.150
     6.607   120.844     0.150
     6.607   207.750     0.150
     7.408   135.148     0.150
     7.408   135.148     0.150
     7.408   231.844     0.150
     7.436   134.945     0.150
     7.436   134.945     0.150
     7.436   233.844     0.150
     7.631   238.344     0.150
     7.635   138.945     0.150
     7.635   113.250     0.150
     7.635   138.945     0.150
     7.635   198.844     0.150
     7.635   238.445     0.150
     7.714   240.547     0.150
     7.987   248.047     0.150
    11.253   350.648     0.150
     0.551    10.844     0.150
     0.551    18.242     0.150
     2.132    63.945     0.150
     2.132    39.141     0.150
     2.132    39.141     0.150
     2.132    67.141     0.150
     2.701    78.844     0.150
     2.701    49.141     0.150
     2.701    85.141     0.150
     2.803    45.844     0.150
     2.803    50.539     0.150
     2.803    86.242     0.150
     3.530    59.039     0.150
     3.635    62.445     0.150
     3.635   104.344     0.150
     4.045    63.945     0.150
     4.045    73.039     0.150
     4.045    63.945     0.150
     4.045    73.039     0.150
     4.045   125.242     0.150
     4.987   156.344     0.150
     4.987    77.141     0.150
     4.987    90.539     0.150
     4.987   155.242     0.150
     5.526   174.742     0.150
     5.526    83.945     0.150
     5.526   100.039     0.150
     5.526   145.539     0.150
     5.526   173.344     0.150
     6.371    95.742     0.150
     6.371   165.242     0.150
     6.371   199.945     0.150
     6.772   123.445     0.150
     6.772   212.242     0.150
     6.772   101.344     0.150
     6.772   212.039     0.150
     7.522   135.742     0.150
     7.522   111.539     0.150
     7.522   135.742     0.150
     7.522   234.039     0.150
     7.577   138.141     0.150
     7.577   110.844     0.150
     7.577   138.141     0.150
     7.577   236.344     0.150
     7.733   240.242     0.150
     7.864   244.445     0.150
     8.121   120.539     0.150
     8.225   256.039     0.150
    10.354   321.539     0.150
    10.974   281.641     0.150
    11.244   289.539     0.150
    11.456   355.945     0.150
     0.558    10.969     0.150
     0.558    18.172     0.150
     0.558    18.172     0.150
     2.126    64.070     0.150
     2.126    37.375     0.150
     2.126    39.070     0.150
     2.126    66.969     0.150
     2.698    43.875     0.150
     2.698    49.570     0.150
     2.698    84.875     0.150
     2.805    86.469     0.150
     2.805    45.969     0.150
     2.805    50.773     0.150
     2.805    86.469     0.150
     3.533    55.172     0.150
     4.042    64.070     0.150
     4.042    73.273     0.150
     4.042   125.875     0.150
     4.984   155.875     0.150
     4.984    91.570     0.150
     4.984   155.773     0.150
     5.521   174.969     0.150
     5.521    84.070     0.150
     5.521   100.172     0.150
     5.521   145.570     0.150
     5.521   172.875     0.150
     6.366    95.875     0.150
     6.366   200.070     0.150
     6.767   122.773     0.150
     6.767   212.469     0.150
     6.767   124.469     0.150
     6.767   102.273     0.150
     6.767   124.469     0.150
     6.767   211.875     0.150
     7.517   135.969     0.150
     7.517   135.969     0.150
     7.517   234.773     0.150
     7.570   139.070     0.150
     7.570   111.070     0.150
     7.570   139.070     0.150
     7.570   236.570     0.150
     7.728   240.773     0.150
     8.053   252.070     0.150
     8.128   125.273     0.150
     8.128   150.273     0.150
    10.968   281.070     0.150
     1.194    21.281     0.150
     1.194    21.281     0.150
     1.194    38.281     0.150
     2.819    89.082     0.150
     2.819    45.883     0.150
     2.819    50.680     0.150
     2.819    89.082     0.150
     2.453    43.281     0.150
     2.503    43.781     0.150
     2.503    41.781     0.150
     2.669    51.883     0.150
     3.484    56.480     0.150
     3.484    62.180     0.150
     3.484   104.883     0.150
     3.484    60.680     0.150
     3.484   104.980     0.150
     3.025    79.281     0.150
     3.920   104.180     0.150
     3.920   104.180     0.150
     3.920   122.883     0.150
     4.136    73.980     0.150
     4.136    64.980     0.150
     4.136    73.980     0.150
     4.136   128.480     0.150
     4.893   151.980     0.150
     5.673    85.781     0.150
     5.673   176.883     0.150
     6.172   191.781     0.150
     6.547   203.680     0.150
     6.898   214.781     0.150
     6.741   115.980     0.150
     7.738   241.980     0.150
     8.102   250.480     0.150
     8.102   250.480     0.150
     9.124   285.582     0.150
    10.491   269.883     0.150
    10.491   269.883     0.150
    10.491   329.883     0.150
    12.186   320.781     0.150
    12.186   320.781     0.150
    12.186   380.781     0.150
    12.556   329.480     0.150
    12.556   329.480     0.150
    12.556   389.480     0.150
     1.210    22.891     0.150
     1.210    22.789     0.150
     1.210    39.688     0.150
     2.715    53.289     0.150
     2.913    47.488     0.150
     2.913    51.988     0.150
     2.913    90.590     0.150
     3.453    62.891     0.150
     3.453   112.289     0.150
     3.453    55.090     0.150
     3.453    62.891     0.150
     3.453   107.289     0.150
     3.453   112.289     0.150
     3.931    71.090     0.150
     3.931    71.090     0.150
     3.931   123.188     0.150
     4.161    66.789     0.150
     4.161    75.391     0.150
     4.161   134.090     0.150
     4.161    74.988     0.150
     4.161    66.789     0.150
     4.161    75.391     0.150
     4.161   129.789     0.150
     4.161   134.090     0.150
     4.721    67.590     0.150
     4.721    80.289     0.150
     4.721   142.090     0.150
     4.897   153.188     0.150
     5.254    82.289     0.150
     5.254    81.891     0.150
     5.254    82.289     0.150
     5.254    96.289     0.150
     5.254   164.391     0.150
     5.695    86.688     0.150
     5.695   104.391     0.150
     5.695   104.391     0.150
     5.695    86.688     0.150
     5.695   104.391     0.150
     5.695   179.090     0.150
     6.175   193.289     0.150
     6.612   207.289     0.150
     6.678   182.289     0.150
     6.930   127.090     0.150
     6.930   216.988     0.150
     7.769   244.789     0.150
     8.125   120.090     0.150
     8.125   148.988     0.150
     8.125   254.188     0.150
     8.967   279.188     0.150
     9.162   287.590     0.150
     9.240   290.688     0.150
     9.469   296.188     0.150
    10.519   269.391     0.150
    11.221   348.891     0.150
    11.697   303.391     0.150
    11.697   303.391     0.150
    11.697   362.891     0.150
    12.218   321.090     0.150
    12.218   191.789     0.150
    12.574   331.188     0.150
    12.724   358.289     0.150
    12.724   358.289     0.150
    12.724   397.488     0.150
     0.290     6.055     0.150
     0.290     6.055     0.150
     0.290    10.758     0.150
     1.302    24.156     0.150
     1.302    41.859     0.150
     2.472    46.156     0.150
     2.472    43.453     0.150
     2.472    41.953     0.150
     2.472    43.453     0.150
     2.472    45.258     0.150
     2.472    78.055     0.150
     2.493    41.758     0.150
     2.493    44.859     0.150
     2.493    72.156     0.150
     2.493    77.258     0.150
     2.547    43.156     0.150
     2.547    47.055     0.150
     2.547    73.859     0.150
     2.547    80.055     0.150
     2.730    45.555     0.150
     2.730    49.758     0.150
     2.730    78.359     0.150
     2.730    85.359     0.150
     3.548    64.656     0.150
     3.548   110.953     0.150
     3.780    50.258     0.150
     3.780    97.859     0.150
     3.888    62.055     0.150
     3.888    70.953     0.150
     3.888   105.953     0.150
     3.888   121.453     0.150
     4.269    66.859     0.150
     4.269   133.555     0.150
     4.269    66.859     0.150
     4.269    78.953     0.150
     4.269   115.156     0.150
     4.269   133.555     0.150
     4.824   149.953     0.150
     4.824    74.758     0.150
     4.824    88.055     0.150
     4.824   149.953     0.150
     5.320   166.156     0.150
     5.493   102.055     0.150
     5.493   172.555     0.150
     5.493    83.453     0.150
     5.493   148.758     0.150
     5.493    83.453     0.150
     5.493   100.359     0.150
     5.493   148.758     0.150
     5.493   172.156     0.150
     6.333   197.555     0.150
     6.697   100.156     0.150
     6.697   120.359     0.150
     6.697   207.953     0.150
     7.729   242.359     0.150
     7.807   115.555     0.150
     7.807   244.156     0.150
     8.032   250.258     0.150
     8.216   257.258     0.150
     9.084   281.453     0.150
     9.789   304.859     0.150
    10.275   320.555     0.150
    10.781   276.758     0.150
    11.156   287.859     0.150
    11.336   353.055     0.150
    13.410   416.656     0.150
     0.672    12.617     0.150
     0.672    21.812     0.150
     1.138    20.617     0.150
     1.138    35.211     0.150
     1.138    20.711     0.150
     1.138    20.711     0.150
     1.138    20.711     0.150
     1.138    22.914     0.150
     1.138    35.812     0.150
     1.779    38.211     0.150
     1.779    32.914     0.150
     1.779    38.211     0.150
     1.779    57.312     0.150
     1.874    57.914     0.150
     1.874    34.414     0.150
     1.874    34.414     0.150
     2.248    37.617     0.150
     2.248    40.617     0.150
     2.248    70.312     0.150
     2.805    51.312     0.150
     2.805    87.812     0.150
     3.118    51.016     0.150
     3.118    56.414     0.150
     3.118    98.016     0.150
     3.415    55.117     0.150
     3.415    62.211     0.150
     3.415   107.914     0.150
     4.061    73.117     0.150
     4.061   127.016     0.150
     4.539    69.211     0.150
     4.575   139.117     0.150
     4.537    75.414     0.150
     4.537    75.414     0.150
     4.537   141.914     0.150
     4.618    82.414     0.150
     4.618    71.211     0.150
     4.618    83.312     0.150
     4.618   144.414     0.150
     5.458   100.016     0.150
     5.458   171.414     0.150
     5.839   180.617     0.150
     5.839    88.016     0.150
     5.839    88.016     0.150
     5.839   106.812     0.150
     5.839   183.211     0.150
     6.095   187.812     0.150
     6.850   214.914     0.150
     6.940   105.117     0.150
     6.940   216.016     0.150
     6.967   126.516     0.150
     6.967   218.414     0.150
     6.967   127.117     0.150
     6.967   127.117     0.150
     6.967   218.312     0.150
     8.214   256.117     0.150
     9.421   293.516     0.150
    10.308   259.312     0.150
     0.737    15.391     0.150
     0.737    15.391     0.150
     0.737    17.293     0.150
     0.737    26.293     0.150
     0.737    30.391     0.150
     2.161    39.691     0.150
     2.161    47.191     0.150
     2.161    63.891     0.150
     2.161    68.191     0.150
     2.885    51.793     0.150
     3.099    53.992     0.150
     3.404    62.191     0.150
     5.196   159.391     0.150
     5.196    96.391     0.150
     5.628   175.191     0.150
     5.628   103.793     0.150
     6.462   119.191     0.150
     7.623   137.992     0.150
     7.623   113.992     0.150
     7.623   143.293     0.150
     8.716   128.492     0.150
     8.716   159.492     0.150
    24.776   320.293     0.150
    78.043   715.992     0.150
     0.288    12.145     0.150
     1.752    30.444     0.150
     1.752    54.645     0.150
     1.752    30.444     0.150
     1.752    31.944     0.150
     1.752    54.645     0.150
     2.666    41.744     0.150
     2.666    46.845     0.150
     2.666    80.444     0.150
     2.718    43.544     0.150
     2.718    48.645     0.150
     2.718    78.044     0.150
     2.718    43.544     0.150
     2.718    48.645     0.150
     2.718    78.044     0.150
     2.718    84.845     0.150
     3.242    58.645     0.150
     3.242    99.345     0.150
     3.242    58.845     0.150
     3.242   107.145     0.150
     3.242    58.845     0.150
     3.242   101.244     0.150
     3.242   107.145     0.150
     3.388    92.744     0.150
     3.976   124.645     0.150
     4.330    67.345     0.150
     4.330   132.145     0.150
     4.330    65.845     0.150
     4.330    80.444     0.150
     4.330   129.145     0.150
     4.330   135.145     0.150
     4.772    92.044     0.150
     4.772    72.244     0.150
     4.772    86.145     0.150
     4.772    92.044     0.150
     4.772   148.645     0.150
     5.255    94.645     0.150
     5.255   162.845     0.150
     5.346    75.044     0.150
     5.346   126.944     0.150
     5.346    75.044     0.150
     5.346   126.944     0.150
     5.346   161.345     0.150
     5.865   192.244     0.150
     5.865   184.345     0.150
     5.865   192.244     0.150
     6.022   108.944     0.150
     6.022   159.244     0.150
     6.022    88.444     0.150
     6.022   108.645     0.150
     6.022   159.244     0.150
     6.022   188.345     0.150
     6.857   213.444     0.150
     7.201   225.944     0.150
     8.038   250.044     0.150
     8.038   250.044     0.150
     8.268   258.244     0.150
     8.268   258.244     0.150
     8.272   151.345     0.150
     8.272   258.544     0.150
     8.272   151.345     0.150
     8.272   258.544     0.150
     8.753   136.645     0.150
     8.753   136.645     0.150
     8.753   272.744     0.150
    10.771   335.044     0.150
    11.646   301.244     0.150
    11.798   335.645     0.150
    11.798   335.645     0.150
    11.798   364.944     0.150
     1.085    21.316     0.150
     1.085    21.316     0.150
     1.085    21.316     0.150
     1.085    35.516     0.150
     1.085    35.416     0.150
     1.602    36.316     0.150
     1.602    29.616     0.150
     1.602    50.516     0.150
     1.689    31.116     0.150
     1.689    55.316     0.150
     1.689    31.216     0.150
     1.689    32.416     0.150
     1.689    32.416     0.150
     1.689    32.416     0.150
     1.689    56.516     0.150
     2.668    48.516     0.150
     2.668    54.016     0.150
     2.668    48.416     0.150
     2.668    83.416     0.150
     2.681    54.716     0.150
     3.716    75.516     0.150
     3.708   133.916     0.150
     3.811    52.016     0.150
     3.811    67.116     0.150
     4.002    62.716     0.150
     4.002    72.816     0.150
     4.002    81.516     0.150
     4.002    62.616     0.150
     4.002    72.816     0.150
     4.002   109.316     0.150
     4.002   124.516     0.150
     4.183    72.116     0.150
     4.183    65.316     0.150
     4.183    76.316     0.150
     4.183   131.216     0.150
     4.943   154.916     0.150
     4.943    80.516     0.150
     4.943    75.816     0.150
     4.943    90.716     0.150
     4.943   154.916     0.150
     5.273   165.816     0.150
     5.273    80.116     0.150
     5.273    84.016     0.150
     5.273    80.116     0.150
     5.273    94.916     0.150
     5.273   165.816     0.150
     6.121    95.716     0.150
     6.121    98.616     0.150
     6.121   112.116     0.150
     6.121   163.216     0.150
     6.572   205.216     0.150
     6.572   119.616     0.150
     6.572    97.816     0.150
     6.572   119.016     0.150
     6.572   205.216     0.150
     7.097   219.216     0.150
     7.097   111.016     0.150
     7.097   219.216     0.150
     7.097   104.116     0.150
     7.097   127.316     0.150
     7.097   219.216     0.150
     7.238   111.016     0.150
     7.238   131.516     0.150
     7.311   136.616     0.150
     7.431   209.616     0.150
     7.431   238.716     0.150
     7.635   115.416     0.150
     7.635   237.416     0.150
     7.784   203.116     0.150
     7.784   244.316     0.150
     7.839   245.816     0.150
     7.839   256.916     0.150
     7.927   120.316     0.150
     7.927   144.816     0.150
     7.927   247.716     0.150
     8.562   146.016     0.150
     8.562   270.416     0.150
    10.563   264.016     0.150
    11.052   285.116     0.150
    11.315   329.516     0.150
    13.448   373.516     0.150
    13.448   417.616     0.150
     0.360    11.203     0.150
     1.589    28.703     0.150
     1.589    51.109     0.150
     2.300    39.508     0.150
     2.300    42.203     0.150
     2.300    39.508     0.150
     2.300    42.109     0.150
     2.300    68.109     0.150
     2.300    72.508     0.150
     2.776    45.203     0.150
     2.776    49.805     0.150
     2.776    84.805     0.150
     2.980    49.008     0.150
     2.980    53.703     0.150
     2.980    54.008     0.150
     2.980    84.508     0.150
     2.980    92.906     0.150
     2.980    48.609     0.150
     2.980    53.406     0.150
     2.980    90.609     0.150
     3.497    56.406     0.150
     3.497    90.906     0.150
     3.834    58.109     0.150
     4.522    70.406     0.150
     4.522    80.906     0.150
     4.522   141.008     0.150
     5.108   160.703     0.150
     5.108    93.609     0.150
     5.108    78.508     0.150
     5.108    93.609     0.150
     5.108   160.703     0.150
     5.430   167.609     0.150
     5.430    98.008     0.150
     5.430   167.609     0.150
     5.722   177.906     0.150
     5.722    86.703     0.150
     5.722   103.109     0.150
     5.722    86.609     0.150
     5.722   103.109     0.150
     5.722   177.906     0.150
     6.564   119.609     0.150
     6.948   126.703     0.150
     6.948   103.406     0.150
     6.948   127.406     0.150
     6.948   183.609     0.150
     7.361   106.367     0.150
     7.762   244.109     0.150
     7.826   141.609     0.150
     7.826   244.805     0.150
     7.826   141.508     0.150
     7.826   212.805     0.150
     7.826   141.609     0.150
     7.826   244.805     0.150
     7.880   241.305     0.150
     7.942   139.203     0.150
     8.049   146.805     0.150
     8.049   118.203     0.150
     8.049   146.109     0.150
     8.049   212.203     0.150
     8.432   152.203     0.150
     9.395   170.703     0.150
     9.395   248.906     0.150
    11.211   280.703     0.150
    11.211   161.578     0.150
    11.211   280.680     0.150
    11.492   297.383     0.150
    11.607   207.203     0.150
    12.881   327.805     0.150
    13.277   186.109     0.150
    13.689   425.805     0.150
    14.913   376.906     0.150
    15.602   216.703     0.150
    15.602   394.109     0.150
    15.739   217.305     0.150
    15.739   217.273     0.150
    21.154     4.000     0.150
    21.154     7.500     0.150
    27.539   351.711     0.150
    30.391   376.625     0.150
    54.288   566.445     0.150
    80.977   739.305     0.150
     0.641    12.969     0.150
     0.641    12.969     0.150
     0.641    20.570     0.150
     0.641    15.367     0.150
     0.641    20.570     0.150
     1.557    27.969     0.150
     1.557    48.664     0.150
     1.557    31.969     0.150
     1.557    27.969     0.150
     1.557    48.664     0.150
     2.034    36.969     0.150
     2.034    64.469     0.150
     2.034    75.070     0.150
     2.034    34.570     0.150
     2.034    37.266     0.150
     2.034    64.469     0.150
     2.034    75.070     0.150
     2.751    52.570     0.150
     2.751    90.164     0.150
     2.841    50.867     0.150
     2.841    87.766     0.150
     2.841    96.766     0.150
     2.841    50.867     0.150
     2.841    87.766     0.150
     2.894    51.469     0.150
     2.894    88.766     0.150
     2.894    49.766     0.150
     2.894    51.469     0.150
     2.894    88.766     0.150
     3.489    91.367     0.150
     3.774    72.570     0.150
     3.774    66.867     0.150
     3.774    72.570     0.150
     3.774   118.266     0.150
     3.774    68.070     0.150
     3.774   118.164     0.150
     4.094    60.867     0.150
     4.094    68.164     0.150
     4.094   101.070     0.150
     4.380   134.469     0.150
     4.380    67.070     0.150
     4.380   119.164     0.150
     4.380    67.070     0.150
     4.380    78.070     0.150
     4.380   134.469     0.150
     5.037   157.570     0.150
     5.037    81.664     0.150
     5.037   102.070     0.150
     5.037   165.266     0.150
     5.037    76.867     0.150
     5.037    91.266     0.150
     5.037   157.570     0.150
     5.186    73.070     0.150
     5.652    81.570     0.150
     5.540   172.266     0.150
     5.540    87.867     0.150
     5.540   105.766     0.150
     5.540   155.367     0.150
     5.540   177.266     0.150
     5.540    98.969     0.150
     5.540   172.266     0.150
     6.386   116.469     0.150
     6.796   100.070     0.150
     6.796   110.164     0.150
     6.796   124.164     0.150
     6.796   170.070     0.150
     7.059   109.867     0.150
     7.534   135.664     0.150
     7.534   233.867     0.150
     7.534   118.469     0.150
     7.534   136.867     0.150
     7.534   212.469     0.150
     7.534   135.664     0.150
     7.534   233.867     0.150
     7.530   118.266     0.150
     7.530   136.070     0.150
     7.530   248.469     0.150
     7.738   139.570     0.150
     7.738   143.570     0.150
     7.883   142.664     0.150
     7.883   245.867     0.150
     7.883   122.664     0.150
     7.883   143.164     0.150
     7.883   114.867     0.150
     7.883   142.664     0.150
     7.883   245.867     0.150
     8.149   249.266     0.150
     8.068   122.070     0.150
     8.068   146.469     0.150
     8.068   229.266     0.150
     8.068   261.070     0.150
     8.122   255.766     0.150
     8.230   149.266     0.150
     8.230   230.367     0.150
     9.149   136.570     0.150
     9.149   171.164     0.150
     9.237   165.266     0.150
     9.867   147.367     0.150
     9.867   318.969     0.150
     9.867   307.164     0.150
     9.867   318.969     0.150
    10.686   148.867     0.150
    10.686   271.867     0.150
    10.821   149.469     0.150
    10.821   196.266     0.150
    10.821   195.367     0.150
    11.271   206.969     0.150
    11.271   331.867     0.150
    11.271   206.969     0.150
    11.271   331.867     0.150
    11.271   350.266     0.150
    11.493   170.766     0.150
    11.493   189.867     0.150
    11.493   243.867     0.150
    11.493   298.469     0.150
    11.493   327.664     0.150
    11.493   170.766     0.150
    11.493   189.867     0.150
    11.493   243.867     0.150
    11.493   298.469     0.150
    11.493   327.664     0.150
    11.493   356.867     0.150
    13.596   424.367     0.150
    13.596   433.570     0.150
    13.596   424.367     0.150
    13.596   433.570     0.150
    16.053   219.594     0.150
    16.053   396.320     0.150
    16.053   219.766     0.150
    16.083     7.000     0.150
    19.282   602.969     0.150
    19.856   277.469     0.150
    24.092   316.266     0.150
    24.163   318.539     0.150
    54.587   567.367     0.150
    54.587   567.414     0.150
    77.089   711.875     0.150
     5.723   176.804     0.150
     0.513     8.195     0.150
     0.513    15.395     0.150
     0.513    18.996     0.150
     0.628    21.395     0.150
     0.628    21.395     0.150
     2.847    46.395     0.150
     2.847    55.695     0.150
     2.847    64.098     0.150
     2.847    73.395     0.150
     2.847    88.496     0.150
     2.847    46.297     0.150
     2.847    51.598     0.150
     2.847    80.695     0.150
     2.847    88.496     0.150
     2.883    74.797     0.150
     2.883    46.598     0.150
     2.883    51.895     0.150
     2.883    88.598     0.150
     3.329    49.297     0.150
     3.329    56.496     0.150
     3.580    65.098     0.150
     3.580    71.195     0.150
     3.580    65.098     0.150
     3.580   111.797     0.150
     4.648    69.297     0.150
     4.648    81.098     0.150
     4.648    69.496     0.150
     4.648    74.598     0.150
     4.648    90.695     0.150
     4.648   117.395     0.150
     5.107   159.496     0.150
     5.107    75.695     0.150
     5.107   167.695     0.150
     5.568    95.797     0.150
     5.568   118.496     0.150
     6.180   196.496     0.150
     6.362    90.797     0.150
     6.362   115.895     0.150
     7.536   237.797     0.150
     7.990   222.195     0.150
     7.990   247.797     0.150
     8.657   294.496     0.150
     8.952   282.797     0.150
     9.939   225.598     0.150
     9.939   252.996     0.150
    10.636   336.195     0.150
    11.648   303.496     0.150
    11.648   377.496     0.150
    11.977   312.598     0.150
     1.239    41.335     0.150
     1.239    23.935     0.150
     1.239    23.935     0.150
     1.239    41.335     0.150
     1.610    29.835     0.150
     1.610    30.335     0.150
     1.610    50.835     0.150
     1.610    30.035     0.150
     1.610    51.335     0.150
     1.610    29.835     0.150
     1.610    30.335     0.150
     1.610    50.335     0.150
     1.610    50.835     0.150
     1.733    31.835     0.150
     1.733    54.535     0.150
     1.733    31.935     0.150
     1.733    54.635     0.150
     1.733    31.835     0.150
     1.733    54.535     0.150
     2.103    38.435     0.150
     2.103    38.435     0.150
     2.103    64.635     0.150
     2.094    36.635     0.150
     2.094    66.335     0.150
     2.635    50.535     0.150
     2.635    48.135     0.150
     2.635    50.535     0.150
     2.635    83.935     0.150
     2.682    84.935     0.150
     2.682    94.235     0.150
     2.682    49.935     0.150
     2.682    84.835     0.150
     2.952    52.835     0.150
     2.952    54.935     0.150
     2.952    52.835     0.150
     2.952    91.435     0.150
     3.274    53.435     0.150
     3.274    61.035     0.150
     3.894    62.635     0.150
     3.894    72.035     0.150
     3.894   121.335     0.150
     4.497    69.035     0.150
     4.704    86.035     0.150
     5.701   104.135     0.150
     5.701   177.735     0.150
     5.701   105.835     0.150
     5.701   179.435     0.150
     5.701    87.135     0.150
     5.701   104.135     0.150
     5.701   177.735     0.150
     6.270   194.035     0.150
     6.946   126.735     0.150
     8.791   159.835     0.150
     8.791   275.435     0.150
     8.791   129.435     0.150
     8.791   159.835     0.150
     8.791   275.435     0.150
     9.785   244.135     0.150
     0.469    15.082     0.150
     0.974    32.879     0.150
     1.521    27.680     0.150
     1.521    27.680     0.150
     1.521    47.180     0.150
     1.521    27.680     0.150
     1.521    47.980     0.150
     2.198    41.379     0.150
     2.198    70.781     0.150
     2.786    85.082     0.150
     2.786    44.879     0.150
     2.786    49.879     0.150
     2.786    79.082     0.150
     2.786    85.180     0.150
     2.743    51.281     0.150
     2.743    86.582     0.150
     2.871    52.379     0.150
     2.871    90.582     0.150
     3.584    56.082     0.150
     3.758    68.582     0.150
     3.758   119.680     0.150
     4.412    69.582     0.150
     4.412    81.281     0.150
     5.028    79.879     0.150
     5.028    79.781     0.150
     5.028   159.180     0.150
     5.598   177.879     0.150
     5.598    85.781     0.150
     5.598   175.082     0.150
     6.442   152.680     0.150
     7.672   139.281     0.150
     7.672   171.281     0.150
     7.672   139.281     0.150
     7.672   237.281     0.150
     8.030   111.082     0.150
     7.931   240.379     0.150
     8.302   152.180     0.150
     8.302   232.781     0.150
    10.884   152.379     0.150
    10.884   281.680     0.150
     0.340    10.961     0.150
     0.753    15.562     0.150
     0.753    26.262     0.150
     0.753    33.762     0.150
     1.666    30.160     0.150
     1.666    30.062     0.150
     1.666    52.062     0.150
     2.348    43.262     0.150
     2.348    74.461     0.150
     2.348    40.160     0.150
     2.348    43.262     0.150
     2.348    69.262     0.150
     2.348    73.762     0.150
     2.805    46.160     0.150
     2.805    50.762     0.150
     2.805    85.660     0.150
     3.417    57.863     0.150
     3.417    56.863     0.150
     3.417   107.660     0.150
     3.447    56.363     0.150
     3.447    83.762     0.150
     3.447    97.660     0.150
     3.912    71.363     0.150
     3.912    71.363     0.150
     3.912   122.062     0.150
     4.251   145.262     0.150
     4.251    65.660     0.150
     4.251    76.160     0.150
     4.251   113.363     0.150
     5.187   162.262     0.150
     5.187    80.863     0.150
     5.187    96.160     0.150
     5.187   162.262     0.150
     5.187    80.863     0.150
     5.187    95.961     0.150
     5.187   139.363     0.150
     5.187   162.262     0.150
     5.821   181.660     0.150
     5.821    97.262     0.150
     5.821    88.262     0.150
     5.821   105.562     0.150
     5.821   181.660     0.150
     7.042   127.762     0.150
     7.042   219.863     0.150
     7.042   127.961     0.150
     7.042   227.762     0.150
     7.042   104.762     0.150
     7.042   127.762     0.150
     7.042   219.863     0.150
     7.430   184.762     0.150
     7.861   143.961     0.150
     7.929   118.363     0.150
     7.929   144.562     0.150
     7.929   154.062     0.150
     7.929   253.160     0.150
     8.145   109.461     0.150
     8.145   148.762     0.150
     8.145   258.062     0.150
     8.409   180.961     0.150
     9.420   233.461     0.150
     9.490   236.762     0.150
    10.129   319.961     0.150
    11.506   208.762     0.150
    11.506   341.863     0.150
     0.324     6.461     0.150
     0.324    10.961     0.150
     0.324    10.961     0.150
     1.626    29.859     0.150
     1.626    55.461     0.150
     1.626    29.762     0.150
     1.626    51.160     0.150
     2.349    83.762     0.150
     2.349    39.559     0.150
     2.349    42.859     0.150
     2.349    69.160     0.150
     2.349    73.762     0.150
     2.776    45.461     0.150
     2.776    49.262     0.150
     2.776    84.961     0.150
     3.456    71.359     0.150
     3.456    99.859     0.150
     3.485    66.160     0.150
     3.485    83.660     0.150
     3.872    98.359     0.150
     3.872    72.160     0.150
     3.872   122.262     0.150
     4.211    64.262     0.150
     4.211    64.262     0.150
     4.211    74.961     0.150
     4.211   112.461     0.150
     5.148   162.262     0.150
     5.148    83.461     0.150
     5.148    94.262     0.150
     5.148   162.359     0.150
     5.148   172.160     0.150
     5.148    79.461     0.150
     5.148    94.359     0.150
     5.148   162.262     0.150
     5.502   153.559     0.150
     5.781   181.359     0.150
     5.781   107.961     0.150
     5.781    87.660     0.150
     5.781   105.461     0.150
     5.781   181.359     0.150
     7.001   127.059     0.150
     7.001   217.762     0.150
     7.001   113.660     0.150
     7.001   104.359     0.150
     7.001   127.059     0.150
     7.001   217.762     0.150
     7.421   163.262     0.150
     8.004   169.961     0.150
     8.105   257.359     0.150
     9.379   231.359     0.150
     9.450   236.961     0.150
    11.466   208.559     0.150
    11.466   215.559     0.150
    11.466   361.961     0.150
    11.654   186.262     0.150
    11.654   223.160     0.150
    11.654   332.762     0.150
     0.327     6.441     0.150
     0.327    11.041     0.150
     0.327    11.041     0.150
     0.796    23.740     0.150
     1.625    29.840     0.150
     1.625    29.740     0.150
     1.625    51.840     0.150
     2.344    40.240     0.150
     2.344    43.240     0.150
     2.344    80.941     0.150
     2.344    40.141     0.150
     2.344    43.141     0.150
     2.344    69.141     0.150
     2.344    73.941     0.150
     2.778    47.340     0.150
     2.778    85.441     0.150
     2.778    47.340     0.150
     2.778    51.541     0.150
     2.778    79.840     0.150
     2.778    85.441     0.150
     2.866    50.941     0.150
     2.866    50.941     0.150
     2.866    89.641     0.150
     3.458   100.340     0.150
     3.458    62.641     0.150
     3.458   111.041     0.150
     3.485    65.941     0.150
     3.871    76.340     0.150
     3.871    72.340     0.150
     3.871   123.441     0.150
     4.209    83.141     0.150
     4.209    65.340     0.150
     4.209    75.641     0.150
     4.209   112.740     0.150
     4.572   107.840     0.150
     4.572    81.340     0.150
     4.572   122.340     0.150
     4.572   142.541     0.150
     5.146   161.340     0.150
     5.146    98.441     0.150
     5.146   168.041     0.150
     5.146    81.141     0.150
     5.146    94.641     0.150
     5.146   161.340     0.150
     5.497   139.041     0.150
     5.497   170.541     0.150
     5.778   180.541     0.150
     5.778    96.641     0.150
     5.778   158.240     0.150
     5.778    87.340     0.150
     5.778   104.941     0.150
     5.778   180.541     0.150
     6.620   122.041     0.150
     6.620   209.441     0.150
     6.620   223.840     0.150
     6.999   127.541     0.150
     6.999   220.441     0.150
     6.999   128.941     0.150
     6.999   104.141     0.150
     6.999   127.541     0.150
     6.999   220.441     0.150
     7.818   136.141     0.150
     7.818   222.441     0.150
     7.818   250.340     0.150
     7.893   119.041     0.150
     7.893   143.340     0.150
     7.893   222.541     0.150
     7.893   250.941     0.150
     8.102   139.641     0.150
     8.102   147.340     0.150
     8.366   221.240     0.150
     8.366   264.240     0.150
     9.376   245.041     0.150
     9.376   234.041     0.150
     9.447   236.240     0.150
    11.065   347.141     0.150
    11.463   308.840     0.150
    11.463   344.840     0.150
    11.463   359.641     0.150
    11.651   330.041     0.150
     1.486    27.125     0.150
     1.486    46.719     0.150
     1.486    46.719     0.150
     2.760    44.820     0.150
     2.760    49.523     0.150
     2.760    78.023     0.150
     2.760    85.023     0.150
     3.722    68.320     0.150
     3.722   117.719     0.150
     4.051    62.422     0.150
     4.051   135.922     0.150
     4.051    62.422     0.150
     4.051    72.719     0.150
     4.051   109.625     0.150
     4.051   125.523     0.150
     5.288    77.320     0.150
     5.249   129.422     0.150
     6.405    93.719     0.150
     6.798   123.125     0.150
     6.798   209.719     0.150
     6.798   101.719     0.150
     6.798   101.719     0.150
     6.798   123.125     0.150
     6.798   209.719     0.150
     7.646   140.219     0.150
     0.463     7.791     0.150
     0.463    14.391     0.150
     0.463    14.391     0.150
     1.004    39.590     0.150
     2.212    65.490     0.150
     2.212    40.291     0.150
     2.212    38.291     0.150
     2.212    40.291     0.150
     2.212    65.490     0.150
     2.212    69.191     0.150
     2.757    84.891     0.150
     2.757    44.590     0.150
     2.757    49.490     0.150
     2.757    84.990     0.150
     3.618    60.791     0.150
     3.724    68.090     0.150
     3.724    67.990     0.150
     3.724   117.791     0.150
     4.053   123.791     0.150
     4.053   135.691     0.150
     4.053    62.590     0.150
     4.053    72.590     0.150
     4.053   108.990     0.150
     4.053   123.791     0.150
     4.380    79.191     0.150
     4.380   117.891     0.150
     4.380   135.590     0.150
     5.567   175.291     0.150
     5.567    92.990     0.150
     5.567   101.990     0.150
     5.567   175.291     0.150
     6.803   122.990     0.150
     6.803   209.891     0.150
     6.803   101.490     0.150
     6.803   124.990     0.150
     6.803   101.590     0.150
     6.803   122.990     0.150
     6.803   209.891     0.150
     7.654   140.391     0.150
     7.900   207.990     0.150
     0.540    10.582     0.150
     0.540    10.582     0.150
     2.190    37.283     0.150
     2.190    41.082     0.150
     2.190    41.082     0.150
     3.938    50.883     0.150
     5.369    78.582     0.150
     5.369   131.682     0.150
     2.654    52.383     0.150
     0.694    12.000     0.150
     0.694    22.203     0.150
     2.216    37.500     0.150
     2.262    41.703     0.150
     2.262    41.801     0.150
     2.262    45.102     0.150
     2.262    71.801     0.150
     2.262    74.703     0.150
     2.262    41.703     0.150
     2.262    71.703     0.150
     2.322    59.801     0.150
     2.430    44.301     0.150
     2.430    47.500     0.150
     2.430    42.301     0.150
     2.430    75.602     0.150
     2.541    43.602     0.150
     2.541    45.801     0.150
     2.541    78.402     0.150
     3.665    57.301     0.150
     3.665    62.102     0.150
     3.991    61.801     0.150
     3.991   101.602     0.150
     4.018   116.703     0.150
     4.018   130.203     0.150
     3.971   121.703     0.150
     3.971    66.102     0.150
     3.971   129.801     0.150
     3.971    72.000     0.150
     3.971   121.703     0.150
     4.195   139.301     0.150
     4.607    88.402     0.150
     4.607   144.500     0.150
     4.607   147.801     0.150
     4.607    70.801     0.150
     4.607    83.602     0.150
     4.607   144.402     0.150
     5.158    91.102     0.150
     5.158   159.301     0.150
     5.158    82.500     0.150
     5.158   161.500     0.150
     5.158    91.102     0.150
     5.158   159.301     0.150
     6.055   193.000     0.150
     6.393   193.801     0.150
     6.393   197.902     0.150
     7.199   239.301     0.150
     7.329   133.602     0.150
     7.329   205.500     0.150
     7.376   233.301     0.150
     7.490   232.602     0.150
     7.490   241.902     0.150
    10.445   250.402     0.150
    10.864   169.402     0.150
    10.864   196.602     0.150
     0.722    13.984     0.150
     0.722    23.184     0.150
     0.722    23.184     0.150
     2.256    59.086     0.150
     2.256    39.086     0.150
     2.256    41.785     0.150
     2.256    67.484     0.150
     2.302    42.586     0.150
     2.302    72.383     0.150
     2.405    43.883     0.150
     2.405    44.184     0.150
     2.405    78.383     0.150
     2.405    43.883     0.150
     2.405    75.484     0.150
     2.540    41.883     0.150
     2.540    45.785     0.150
     2.540    78.484     0.150
     3.645    63.086     0.150
     3.645   119.184     0.150
     3.645    63.086     0.150
     4.012    78.383     0.150
     3.946    61.586     0.150
     3.946    52.984     0.150
     3.946   102.684     0.150
     3.946    61.586     0.150
     3.946    71.785     0.150
     3.946   123.684     0.150
     4.041   100.684     0.150
     4.199   143.086     0.150
     4.587    69.785     0.150
     4.587    89.086     0.150
     4.889    73.984     0.150
     4.889    88.586     0.150
     4.889   129.383     0.150
     4.889   151.383     0.150
     5.131    77.883     0.150
     5.131    87.684     0.150
     5.131   142.883     0.150
     5.131   167.184     0.150
     5.131    77.883     0.150
     5.131    92.383     0.150
     5.131   159.984     0.150
     5.975   189.184     0.150
     6.066   111.785     0.150
     6.066   192.684     0.150
     6.368   175.086     0.150
     7.301   131.984     0.150
     7.301   226.785     0.150
     7.301   132.285     0.150
     7.301   138.086     0.150
     7.301   204.586     0.150
     7.301   226.883     0.150
     7.301   107.383     0.150
     7.301   131.984     0.150
     7.301   226.785     0.150
     7.349   133.984     0.150
     7.839   111.484     0.150
     7.839   123.184     0.150
     7.839   143.984     0.150
     9.950   162.184     0.150
     0.309     6.379     0.150
     0.309     6.379     0.150
     0.370     7.301     0.150
     0.370    11.901     0.150
     1.546    46.801     0.150
     1.546    28.601     0.150
     1.546    46.801     0.150
     2.288    42.401     0.150
     2.288    83.301     0.150
     2.288    42.301     0.150
     2.288    72.101     0.150
     2.753    50.501     0.150
     2.753    84.501     0.150
     2.780    52.101     0.150
     2.931    52.801     0.150
     2.931    91.401     0.150
     3.555   117.701     0.150
     3.790    71.401     0.150
     3.790   120.801     0.150
     4.124   126.401     0.150
     5.063   158.901     0.150
     5.063    97.201     0.150
     5.063    94.801     0.150
     5.063   158.901     0.150
     2.043   100.758     0.150
     2.459    48.957     0.150
     2.502    50.457     0.150
     2.502    81.656     0.150
     2.502    45.957     0.150
     2.502    78.355     0.150
     2.485    73.355     0.150
     2.485    69.457     0.150
     2.485    79.258     0.150
     2.485    42.355     0.150
     2.485    45.855     0.150
     2.485    73.355     0.150
     2.485    79.258     0.150
     2.687    49.156     0.150
     2.687    51.758     0.150
     2.687    86.656     0.150
     2.687    49.059     0.150
     2.687    84.656     0.150
     3.504    79.457     0.150
     3.825   109.355     0.150
     3.825    74.855     0.150
     3.825   117.156     0.150
     3.852    63.855     0.150
     3.844    63.656     0.150
     3.844    78.258     0.150
     3.844    60.957     0.150
     3.844    69.656     0.150
     3.844   104.156     0.150
     3.844   117.258     0.150
     4.225    68.758     0.150
     4.780    79.656     0.150
     4.780    95.059     0.150
     4.780   154.258     0.150
     4.780    74.656     0.150
     4.780    87.957     0.150
     4.780   149.457     0.150
     5.452   101.656     0.150
     5.452    85.559     0.150
     6.290   203.059     0.150
     6.654   121.156     0.150
     6.654   208.258     0.150
     6.654    99.656     0.150
     6.654   120.758     0.150
     6.654   124.559     0.150
     6.654   164.656     0.150
     6.654   191.258     0.150
     6.654   208.258     0.150
     6.654    99.656     0.150
     6.654   121.156     0.150
     6.654   208.258     0.150
     7.488   246.656     0.150
     7.706   140.457     0.150
     7.706   112.855     0.150
     7.706   140.156     0.150
     7.706   143.355     0.150
     7.706   112.758     0.150
     7.706   140.457     0.150
     8.175   130.258     0.150
    11.112   324.258     0.150
    11.112   283.457     0.150
    11.292   169.855     0.150
    11.292   200.059     0.150
    11.292   322.258     0.150
    11.292   339.957     0.150
     1.253    23.348     0.150
     1.253    25.148     0.150
     1.253    39.547     0.150
     2.446    40.148     0.150
     2.446    43.648     0.150
     2.446    74.848     0.150
     2.500    50.648     0.150
     2.500    42.047     0.150
     2.500    46.148     0.150
     2.500    73.348     0.150
     2.500    79.047     0.150
     3.840    60.547     0.150
     3.840   105.250     0.150
     4.010    66.449     0.150
     7.715   112.148     0.150
     7.715   137.949     0.150
     0.316    10.402     0.150
     1.253    23.402     0.150
     1.253    23.305     0.150
     1.253    40.004     0.150
     2.450    40.305     0.150
     2.450    43.805     0.150
     2.450    75.105     0.150
     2.498    78.305     0.150
     2.498    85.805     0.150
     2.498    45.703     0.150
     2.498    78.305     0.150
     2.494    42.203     0.150
     2.494    73.605     0.150
     2.494    79.402     0.150
     2.494    89.004     0.150
     2.494    42.203     0.150
     2.494    46.004     0.150
     2.494    79.305     0.150
     2.684    44.805     0.150
     2.684    48.902     0.150
     2.684    84.605     0.150
     3.499    63.605     0.150
     3.499   111.105     0.150
     3.830    61.004     0.150
     3.858    37.605     0.150
     3.839    63.605     0.150
     3.839    61.605     0.150
     3.839    70.402     0.150
     3.839   105.004     0.150
     3.839   118.305     0.150
     4.222    78.305     0.150
     4.222   130.703     0.150
     4.775    87.605     0.150
     4.775    92.203     0.150
     4.775    87.605     0.150
     4.775   147.203     0.150
     5.450    82.703     0.150
     5.450    85.203     0.150
     5.450    82.605     0.150
     5.450   100.504     0.150
     6.651    97.805     0.150
     6.651   207.605     0.150
     6.651   102.004     0.150
     6.651    97.805     0.150
     6.651   119.605     0.150
     6.651   207.605     0.150
     7.486   136.504     0.150
     7.761   141.504     0.150
     8.067   115.105     0.150
    10.738   165.805     0.150
    10.738   279.105     0.150
    11.109   322.305     0.150
     2.307    82.891     0.150
     2.750    91.791     0.150
     4.137    99.791     0.150
     1.550    30.234     0.150
     2.280    82.836     0.150
     2.760    94.135     0.150
     2.932    47.635     0.150
     4.128   122.436     0.150
     0.525    10.336     0.150
     1.011    37.535     0.150
     2.284    41.434     0.150
     2.284    41.434     0.150
     2.284    41.336     0.150
     2.441    48.934     0.150
     2.561    52.934     0.150
     2.561    47.035     0.150
     3.256    63.836     0.150
     3.595    60.336     0.150
     3.595    92.535     0.150
     3.595   122.035     0.150
     4.072    67.035     0.150
     4.072    69.836     0.150
     4.092    77.336     0.150
     4.531   118.535     0.150
     4.531    83.934     0.150
     5.213   172.434     0.150
     6.408   117.734     0.150
     6.408   120.836     0.150
     7.248   225.035     0.150
     7.456   136.734     0.150
     7.544   200.234     0.150
     7.544   245.637     0.150
     9.984   156.336     0.150
    10.864   340.734     0.150
    11.042   323.836     0.150
     1.875    61.012     0.150
     2.223    80.812     0.150
     2.223    40.312     0.150
     2.223    65.712     0.150
     2.223    69.512     0.150
     3.669    71.212     0.150
     3.998    61.012     0.150
     5.216   185.611     0.150
     5.513   174.512     0.150
     5.513   171.611     0.150
     6.748   122.012     0.150
     6.748   125.411     0.150
     7.616   233.512     0.150
     7.616   239.611     0.150
     7.729   242.411     0.150
     7.845   244.012     0.150
     8.100   253.312     0.150
     8.219   257.212     0.150
     8.219   267.312     0.150
    10.330   310.212     0.150
    11.217   328.012     0.150
    11.421   329.411     0.150
     0.460     9.852     0.150
     0.915    28.852     0.150
     1.065    37.047     0.150
     2.064    45.945     0.150
     2.064    63.445     0.150
     2.240    69.750     0.150
     2.859    94.250     0.150
     2.866    84.148     0.150
     2.866    94.648     0.150
     3.401    54.047     0.150
     3.401    61.547     0.150
     3.465    62.945     0.150
     3.465    66.352     0.150
     3.576    64.852     0.150
     4.479   132.750     0.150
     4.809    81.648     0.150
     5.115   171.750     0.150
     5.115   157.945     0.150
     6.270   101.945     0.150
     6.270   113.852     0.150
     6.270   175.250     0.150
     6.270   209.250     0.150
     6.270    92.750     0.150
     6.270   190.547     0.150
     7.227   103.547     0.150
     7.227   227.250     0.150
     7.539   105.547     0.150
     8.103   220.047     0.150
     8.103   262.547     0.150
     8.311   150.148     0.150
     8.311   199.547     0.150
     8.456   269.352     0.150
     8.848   306.547     0.150
     8.950   142.648     0.150
     8.950   162.148     0.150
    11.115   356.648     0.150
    11.547   371.352     0.150
    12.007   378.750     0.150
    12.224   251.445     0.150
    12.224   269.852     0.150
    12.224   373.945     0.150
     0.775    25.047     0.150
     1.151    24.344     0.150
     1.151    42.242     0.150
     2.242    52.242     0.150
     2.242    61.047     0.150
     2.552    52.344     0.150
     2.864    51.445     0.150
     2.959    54.945     0.150
     2.959    76.742     0.150
     3.188    56.445     0.150
     3.188    83.242     0.150
     3.365   108.648     0.150
     3.493    63.648     0.150
     3.493    77.148     0.150
     3.493   106.148     0.150
     4.481    87.344     0.150
     4.481   112.844     0.150
     4.481    81.547     0.150
     4.513    67.742     0.150
     4.513    71.945     0.150
     4.829    77.648     0.150
     4.829   112.844     0.150
     4.829    73.945     0.150
     4.829   147.547     0.150
     5.227    82.547     0.150
     6.105   112.547     0.150
     6.105   192.844     0.150
     6.442   105.742     0.150
     6.442   118.742     0.150
     6.442   208.445     0.150
     6.442    97.344     0.150
     6.442   199.148     0.150
     7.186   103.891     0.150
     7.186   104.047     0.150
     7.656   138.242     0.150
     7.656   139.945     0.150
     7.714   163.844     0.150
     8.481   128.648     0.150
     8.481   156.242     0.150
     8.763   284.242     0.150
     9.031   305.047     0.150
    10.039   231.844     0.150
    10.106   253.242     0.150
    10.603   263.398     0.150
    10.603   338.492     0.150
    10.746   202.242     0.150
    10.746   344.727     0.150
    11.234   343.648     0.150
    11.730   211.648     0.150
    11.730   387.344     0.150
    12.115   353.148     0.150
    12.115   381.242     0.150
    12.201   179.133     0.150
    12.288   208.148     0.150
    12.288   247.742     0.150
    12.288   335.742     0.150
    14.949   478.023     0.150
    32.079   401.945     0.150
    41.713   467.844     0.150
    44.175   490.242     0.150
    49.725   535.648     0.150
    49.725   535.047     0.150
     0.542    10.688     0.150
     0.542    17.484     0.150
     1.355    42.688     0.150
     2.205    40.984     0.150
     4.224    68.688     0.150
     5.115   166.484     0.150
     5.408   169.484     0.150
     7.517   136.688     0.150
     7.517   232.188     0.150
     0.632    13.672     0.150
     1.168    23.969     0.150
     2.275    39.770     0.150
     2.275    45.270     0.150
     2.275    68.070     0.150
     2.275    68.070     0.150
     2.369    43.570     0.150
     2.487    51.070     0.150
     2.547    79.070     0.150
     3.713    57.570     0.150
     3.964   113.469     0.150
     4.096    67.270     0.150
     4.187    98.469     0.150
     4.655    89.672     0.150
     6.452    98.672     0.150
     7.392   203.570     0.150
     7.440   141.570     0.150
     7.440   245.469     0.150
     7.930   128.770     0.150
     7.930   136.770     0.150
     7.930   144.172     0.150
    10.034   320.770     0.150
    10.507   329.969     0.150
     4.208    63.977     0.150
     1.379    30.215     0.150
     1.384    26.011     0.150
     2.522    44.811     0.150
     2.506    41.811     0.150
     2.506    73.311     0.150
     2.506    79.011     0.150
     3.700    63.110     0.150
     3.972   122.011     0.150
     4.906    89.211     0.150
     4.906   156.011     0.150
     0.735    14.287     0.150
     0.735    14.287     0.150
     0.735    30.887     0.150
     1.039    37.887     0.150
     1.039    19.587     0.150
     2.229    76.587     0.150
     2.322    69.587     0.150
     2.322    85.287     0.150
     2.465    60.887     0.150
     2.465    76.687     0.150
     2.343    43.187     0.150
     2.343    43.087     0.150
     3.250    57.387     0.150
     3.250    63.387     0.150
     3.572    71.287     0.150
     3.572    55.987     0.150
     4.108   130.487     0.150
     3.885    66.587     0.150
     4.132   116.487     0.150
     4.221   136.787     0.150
     4.515   142.787     0.150
     4.874    90.687     0.150
     4.874   155.987     0.150
     5.078   160.187     0.150
     5.921   186.587     0.150
     6.308   119.787     0.150
     6.308   197.487     0.150
     7.083   129.287     0.150
     7.083   221.187     0.150
     7.301   132.487     0.150
     7.301   228.587     0.150
     7.301   234.387     0.150
     7.291   132.587     0.150
     7.291   228.587     0.150
     7.407   134.487     0.150
     7.407   232.387     0.150
     7.666   240.087     0.150
     7.666   246.387     0.150
     7.735   242.587     0.150
     7.790   124.887     0.150
     7.790   141.487     0.150
     7.790   243.987     0.150
     7.790   254.287     0.150
     8.481   119.287     0.150
     8.286   260.787     0.150
     8.679   249.287     0.150
     8.754   247.187     0.150
     8.929   237.687     0.150
     9.390   164.187     0.150
     9.890   178.287     0.150
     9.890   283.787     0.150
     9.890   315.287     0.150
    10.778   196.087     0.150
    10.778   303.387     0.150
    10.984   172.787     0.150
    10.984   299.987     0.150
    16.149   222.987     0.150
     0.837    16.102     0.150
     0.837    16.199     0.150
     1.301    36.301     0.150
     1.463    91.902     0.150
     1.923    35.500     0.150
     1.923    37.000     0.150
     1.923    37.000     0.150
     1.923    64.102     0.150
     1.923    35.500     0.150
     1.923    37.000     0.150
     1.923    35.500     0.150
     2.609    88.301     0.150
     2.609    48.102     0.150
     2.655    48.902     0.150
     2.899    52.602     0.150
     2.899    47.199     0.150
     3.636   121.699     0.150
     3.636    59.000     0.150
     3.636    66.000     0.150
     3.720    64.102     0.150
     3.787    64.902     0.150
     3.787   107.699     0.150
     3.787   125.500     0.150
     3.804    65.199     0.150
     3.804   101.699     0.150
     3.945    74.301     0.150
     3.945   139.602     0.150
     3.945    63.301     0.150
     3.945    71.699     0.150
     3.945   123.699     0.150
     3.945    63.301     0.150
     4.187    76.402     0.150
     4.187    66.500     0.150
     4.543   117.199     0.150
     4.888    86.801     0.150
     4.888   160.602     0.150
     4.888   154.602     0.150
     5.323    90.699     0.150
     6.170    97.199     0.150
     6.170   199.199     0.150
     6.594    98.199     0.150
     6.594   204.199     0.150
     6.778    98.102     0.150
     6.874   126.402     0.150
     6.874   224.801     0.150
     6.874   239.000     0.150
     6.874   101.102     0.150
     6.874   219.531     0.150
     7.283   118.102     0.150
     7.283   132.801     0.150
     7.283   219.301     0.150
     7.283   232.199     0.150
     7.306   117.699     0.150
     7.306   132.699     0.150
     7.364   153.801     0.150
     7.509   117.199     0.150
     7.673   139.602     0.150
     7.673   242.699     0.150
     7.900   149.102     0.150
     7.979   267.000     0.150
     8.003   127.000     0.150
     8.003   146.301     0.150
     8.003   256.500     0.150
     8.400   254.824     0.150
     8.400   124.500     0.150
     8.400   217.301     0.150
     8.540   124.301     0.150
     8.540   225.602     0.150
     8.935   171.000     0.150
     8.935   273.402     0.150
     9.030   257.402     0.150
     9.189   227.801     0.150
     9.656   167.000     0.150
     9.656   308.500     0.150
     9.656   141.062     0.150
     9.656   298.520     0.150
    10.688   265.301     0.150
    10.688   337.477     0.150
    10.992   274.898     0.150
    11.073   288.602     0.150
    14.765   464.938     0.150
    16.044   404.102     0.150
    16.284   224.602     0.150
    16.284   224.641     0.150
    18.469   579.477     0.150
    19.737   274.832     0.150
    23.758   310.500     0.150
    23.991   317.711     0.150
    23.991   317.723     0.150
    24.157   319.973     0.150
    32.239   387.602     0.150
    32.239   700.801     0.150
    43.576   870.602     0.150
    44.271   491.461     0.150
    95.468   802.500     0.150
     0.503    15.477     0.150
     1.915    36.773     0.150
     2.212    81.875     0.150
     2.212    40.875     0.150
     2.212    65.977     0.150
     2.615    86.273     0.150
     2.615    48.078     0.150
     2.739    48.375     0.150
     2.704    44.273     0.150
     2.704    48.672     0.150
     3.632    66.477     0.150
     3.703    62.578     0.150
     3.703   103.875     0.150
     3.715    63.977     0.150
     3.959    66.875     0.150
     3.959    71.078     0.150
     4.293    75.375     0.150
     4.293   130.875     0.150
     4.900    80.375     0.150
     5.467    84.172     0.150
     5.467    99.672     0.150
     5.467   171.172     0.150
     6.310    82.078     0.150
     6.310   168.477     0.150
     6.703   113.078     0.150
     6.703   127.477     0.150
     6.703   213.375     0.150
     7.571   119.078     0.150
     7.571   252.172     0.150
     7.681    96.172     0.150
     7.681   250.672     0.150
     7.799  3762.773     0.150
     8.053   231.172     0.150
     8.172   260.672     0.150
     9.783   308.672     0.150
    11.173   320.773     0.150
    11.379   322.773     0.150
     1.132    23.094     0.150
     1.132    39.992     0.150
     2.263    68.992     0.150
     1.321    23.984     0.150
     1.321    40.781     0.150
     2.367    70.281     0.150
     0.280    11.018     0.150
     1.750    32.219     0.150
     1.750    32.119     0.150
     2.592    47.318     0.150
     3.002    44.219     0.150
     4.336   133.119     0.150
     5.265    96.219     0.150
     5.265   163.918     0.150
     5.794    93.619     0.150
     5.794   180.719     0.150
     5.987   186.518     0.150
     8.181   234.418     0.150
     1.302    40.594     0.150
     2.086    65.295     0.150
     3.114    48.795     0.150
     4.387   133.494     0.150
     4.673    70.195     0.150
     5.603   158.895     0.150
     7.508   231.395     0.150
     8.393   232.494     0.150
     1.304    29.553     0.150
     1.920    39.453     0.150
     2.300    76.854     0.150
     2.364    45.854     0.150
     3.688    62.152     0.150
     3.886    64.754     0.150
     3.886    66.152     0.150
     4.094   134.754     0.150
     5.002    81.354     0.150
     6.980   126.652     0.150
     7.357   134.254     0.150
     0.773    16.781     0.150
     0.773    19.180     0.150
     1.624    47.984     0.150
     2.045    63.984     0.150
     2.237    42.383     0.150
     2.540    68.484     0.150
     2.540    90.680     0.150
     3.059    82.984     0.150
     3.059   100.984     0.150
     3.390    88.680     0.150
     3.916   102.078     0.150
     4.279   119.883     0.150
     4.279   137.781     0.150
     4.276   119.383     0.150
     4.330    81.281     0.150
     4.330   145.680     0.150
     4.888   158.883     0.150
     4.970   129.883     0.150
     6.173   175.883     0.150
     6.433   203.984     0.150
     7.210   228.984     0.150
     7.210   245.578     0.150
     7.282   210.383     0.150
     7.282   233.281     0.150
     7.315   114.180     0.150
     7.315   227.383     0.150
     7.315   240.078     0.150
     7.322   224.781     0.150
     7.322   234.781     0.150
     7.509   186.484     0.150
     7.509   242.680     0.150
     7.560   243.578     0.150
     7.696   159.680     0.150
     7.696   188.180     0.150
     8.168   266.781     0.150
     8.168   268.484     0.150
     8.559   271.578     0.150
     8.559   279.680     0.150
     8.807   249.180     0.150
     8.807   270.781     0.150
     9.264   248.383     0.150
     9.751   180.383     0.150
     9.751   368.484     0.150
    10.257   329.078     0.150
    10.573   318.680     0.150
    10.573   336.281     0.150
    10.573   339.578     0.150
    10.634   188.984     0.150
    10.634   337.883     0.150
    10.823   153.781     0.150
    10.823   277.680     0.150
    14.300   441.383     0.150
    14.300   457.680     0.150
     0.149     3.445     0.150
     0.149     5.250     0.150
     1.371    46.844     0.150
     1.953    66.547     0.150
     2.570    44.945     0.150
     2.570    90.547     0.150
     2.570    43.250     0.150
     2.570    74.648     0.150
     3.719   103.844     0.150
     3.769   106.148     0.150
     3.978    73.547     0.150
     3.990   100.148     0.150
     3.990   122.945     0.150
     3.959    77.445     0.150
     3.959    61.344     0.150
     4.365   141.547     0.150
     4.891    76.344     0.150
     4.891   152.547     0.150
     5.603    93.547     0.150
     5.603   175.648     0.150
     6.035    93.047     0.150
     6.035   112.945     0.150
     6.035   189.547     0.150
     6.440   106.648     0.150
     6.440   200.844     0.150
     6.795   115.445     0.150
     6.795   126.844     0.150
     6.795   123.750     0.150
     6.795   210.445     0.150
     7.067   120.344     0.150
     7.067   229.750     0.150
     7.874   143.148     0.150
     7.874   220.047     0.150
     7.874   142.250     0.150
     7.909   210.750     0.150
     8.143   147.445     0.150
     8.331   130.344     0.150
     8.798   251.344     0.150
     9.188   261.344     0.150
    10.369   161.750     0.150
    10.369   338.344     0.150
    10.890   348.445     0.150
    11.248   319.750     0.150
    11.416   192.344     0.150
    11.416   305.547     0.150
    11.416   344.750     0.150
    11.416   361.250     0.150
    11.416   368.945     0.150
    13.481   418.250     0.150
    13.481   423.445     0.150
    13.657   362.047     0.150
    13.657   424.344     0.150
    13.657   430.547     0.150
    14.856   403.648     0.150
    18.435   251.500     0.150
    18.435   252.648     0.150
    21.129     6.805     0.150
    21.129     9.805     0.150
     0.156    13.680     0.150
     2.576    44.883     0.150
     2.610    46.883     0.150
     2.819    90.477     0.150
     3.600   116.078     0.150
     3.732    61.977     0.150
     3.782   111.578     0.150
     3.981    64.477     0.150
     3.981   104.781     0.150
     3.946    96.281     0.150
     3.946    99.781     0.150
     3.946   129.477     0.150
     4.354    71.977     0.150
     4.354   141.383     0.150
     4.878    73.781     0.150
     5.593    93.078     0.150
     5.593   150.180     0.150
     6.430   162.977     0.150
     6.430   205.281     0.150
     6.783   126.977     0.150
     7.056   230.078     0.150
     7.835   129.078     0.150
     7.835   249.977     0.150
     7.868   143.781     0.150
     7.868   206.477     0.150
     7.868   252.578     0.150
     7.898   172.781     0.150
     8.132   217.078     0.150
     8.132   251.781     0.150
     8.182   246.078     0.150
     8.320   126.180     0.150
     8.320   130.383     0.150
     8.320   267.078     0.150
    10.357   288.078     0.150
    11.236   276.477     0.150
    11.404   183.383     0.150
    11.404   304.977     0.150
    13.645   381.781     0.150
    14.843   472.883     0.150
     1.950    42.031     0.150
     1.950    59.934     0.150
     2.805    57.031     0.150
     4.078    79.633     0.150
     6.752   122.332     0.150
     6.752   214.633     0.150
     7.442   135.332     0.150
     7.442   208.832     0.150
     7.834   247.031     0.150
     2.164    67.992     0.150
     2.614    89.393     0.150
     3.085    76.893     0.150
     3.416    64.093     0.150
     3.624    92.793     0.150
     8.476   154.293     0.150
     0.718    14.531     0.150
     1.212    42.227     0.150
     1.379    25.430     0.150
     1.379    27.227     0.150
     1.379    45.930     0.150
     2.157    64.031     0.150
     2.176    39.531     0.150
     2.176    43.227     0.150
     2.176    65.930     0.150
     4.021    67.227     0.150
     4.282   110.430     0.150
     4.675    82.227     0.150
     4.675   114.125     0.150
     4.907    93.430     0.150
     5.195    92.031     0.150
     5.195    99.328     0.150
     6.440   120.531     0.150
     6.655   122.227     0.150
     7.068   130.227     0.150
     7.068   179.125     0.150
     7.313   134.031     0.150
     7.406   134.930     0.150
     7.406   190.031     0.150
     7.532   137.625     0.150
     7.897   144.828     0.150
     8.418   254.445     0.150
     9.516   291.398     0.150
    10.956   271.555     0.150
    10.956   337.281     0.150
    16.173   222.594     0.150
    16.173   389.844     0.150
    16.173   505.797     0.150
     1.120    20.416     0.150
     1.917    57.816     0.150
     1.917    64.316     0.150
     2.177    45.217     0.150
     2.177    65.517     0.150
     2.177    71.217     0.150
     2.177    81.416     0.150
     2.731    88.517     0.150
     4.272    80.116     0.150
     4.272    82.816     0.150
     4.323   141.717     0.150
     2.393    82.992     0.150
     2.370    84.180     0.150
     2.801    49.578     0.150
     2.920   102.078     0.150
     4.284    68.277     0.150
     4.262    80.480     0.150
     1.548    32.754     0.150
     2.340    85.055     0.150
     2.787    59.652     0.150
     2.949    98.254     0.150
     3.536   114.555     0.150
     3.558   116.055     0.150
     3.793    75.453     0.150
     3.793    97.953     0.150
     4.248   139.852     0.150
     5.068    97.754     0.150
     5.427   103.953     0.150
     5.696   105.555     0.150
     6.538   179.152     0.150
     6.917   128.055     0.150
     8.233   149.352     0.150
    11.571   187.152     0.150
     0.778    33.158     0.150
     0.935    20.359     0.150
     0.935    35.459     0.150
     2.129    43.258     0.150
     2.129    64.859     0.150
     2.403    88.258     0.150
     2.404    51.158     0.150
     3.149   112.658     0.150
     4.052    76.658     0.150
     4.204    68.959     0.150
     4.204   135.658     0.150
     7.229   185.959     0.150
     7.229   241.758     0.150
     7.323   132.959     0.150
     7.323   232.658     0.150
     7.538   137.758     0.150
     7.717   140.959     0.150
    10.828   162.682     0.150
    11.224   354.158     0.150
    16.150   224.479     0.150
    18.657   262.066     0.150
     1.054    37.314     0.150
     2.254    74.514     0.150
     2.669    77.523     0.150
     2.767    80.711     0.150
     3.192    52.711     0.150
     3.192    92.051     0.150
     3.192    92.051     0.150
     3.325    91.992     0.150
     3.441    93.902     0.150
     4.679   125.480     0.150
     0.927    35.102     0.150
     2.406    88.305     0.150
     3.942    61.500     0.150
     2.739    91.461     0.150
     3.739   126.461     0.150
     3.943    65.359     0.150
     5.422    81.660     0.150
     6.882   124.961     0.150
     4.520    69.281     0.150
     4.520    85.281     0.150
     0.758    14.016     0.150
     0.913    19.812     0.150
     0.913    34.215     0.150
     1.573    52.016     0.150
     2.255    73.016     0.150
     2.336    44.613     0.150
     2.413    45.715     0.150
     2.444    87.414     0.150
     3.796   126.312     0.150
     4.199    83.113     0.150
     4.199   146.312     0.150
     5.007   164.715     0.150
     0.331     7.742     0.150
     1.609    35.742     0.150
     1.803    32.941     0.150
     1.803    33.242     0.150
     1.803    36.842     0.150
     1.803    56.242     0.150
     1.803    62.842     0.150
     2.674    52.242     0.150
     3.055    55.541     0.150
     3.284    59.342     0.150
     3.284    52.242     0.150
     3.284    59.441     0.150
     4.031   129.242     0.150
     4.384    79.242     0.150
     4.384    82.143     0.150
     4.816   149.541     0.150
     4.816    73.242     0.150
     4.816    77.742     0.150
     4.816    90.842     0.150
     5.310   105.643     0.150
     5.814   183.143     0.150
     6.060    89.941     0.150
     6.060   115.242     0.150
     6.897   123.941     0.150
     6.897   130.342     0.150
     6.897   167.041     0.150
     7.246   108.242     0.150
     7.246   132.342     0.150
     7.246   227.342     0.150
     7.246   107.842     0.150
     7.246   131.342     0.150
     7.246   188.441     0.150
     7.458   226.711     0.150
     8.277   150.941     0.150
     8.277   282.441     0.150
     8.302   150.742     0.150
     8.362   150.541     0.150
     8.650   156.941     0.150
     8.712   158.143     0.150
     8.788   159.842     0.150
     9.253   232.842     0.150
     9.889   178.643     0.150
     9.889   341.842     0.150
    10.343   186.643     0.150
    10.818   196.143     0.150
    10.818   270.541     0.150
    10.987   268.643     0.150
    11.347   167.441     0.150
    11.347   205.041     0.150
    11.347   385.041     0.150
    11.694   173.941     0.150
    11.905   302.846     0.150
    12.096   166.941     0.150
    15.280   208.512     0.150
    15.280   368.861     0.150
    15.280   209.541     0.150
    15.270   482.604     0.150
    19.397   612.779     0.150
    24.962   319.941     0.150
    43.798   477.342     0.150
    47.591   506.041     0.150
    47.591   921.441     0.150
    47.591  1131.242     0.150
    47.591   506.082     0.150
    47.591   506.082     0.150
    47.591   506.082     0.150
    47.591   617.643     0.150
    47.591   662.992     0.150
    47.591   921.521     0.150
    47.591  1131.252     0.150
    47.591  1194.771     0.150
    47.653   520.941     0.150
    47.653   622.941     0.150
    47.770   522.643     0.150
    81.366   735.342     0.150
   149.214  1186.342     0.150
     1.632    30.531     0.150
     1.755    32.531     0.150
     2.072    65.930     0.150
     2.667    51.930     0.150
     2.667    86.830     0.150
     2.974    56.830     0.150
     3.917   124.930     0.150
     5.356   172.330     0.150
     5.723   181.031     0.150
     5.982   191.631     0.150
     7.246   231.430     0.150
     0.127     4.966     0.150
     1.456    27.166     0.150
     1.456    27.266     0.150
     2.393    48.366     0.150
     2.393    72.966     0.150
     2.393    77.166     0.150
     2.393    38.866     0.150
     2.393    72.566     0.150
     2.705    55.166     0.150
     2.705    44.066     0.150
     2.785    54.066     0.150
     2.785    95.566     0.150
     2.785    44.566     0.150
     2.959    63.066     0.150
     2.959    98.866     0.150
     2.959    47.766     0.150
     3.690    75.066     0.150
     3.839    75.866     0.150
     3.839   117.566     0.150
     4.028    83.066     0.150
     4.028   125.966     0.150
     4.484    73.066     0.150
     4.484    90.266     0.150
     4.484   121.866     0.150
     4.484    68.966     0.150
     4.484    81.366     0.150
     4.952    97.166     0.150
     4.952   153.266     0.150
     5.747   191.866     0.150
     5.747   180.066     0.150
     6.129   161.866     0.150
     6.129   193.466     0.150
     6.580    98.266     0.150
     6.580   101.566     0.150
     6.580   173.766     0.150
     6.580   222.266     0.150
     6.912   103.966     0.150
     6.912   124.466     0.150
     6.912   104.266     0.150
     6.912   127.166     0.150
     7.210   131.666     0.150
     7.210   192.366     0.150
     7.712   191.335     0.150
     7.712   232.485     0.150
     8.035   145.966     0.150
     8.035   156.866     0.150
     8.035   171.366     0.150
     8.035   144.266     0.150
     8.098   124.766     0.150
     8.098   146.466     0.150
     8.098   144.566     0.150
     8.287   150.066     0.150
     8.287   286.566     0.150
     8.484   152.966     0.150
     8.484   217.266     0.150
     8.484   284.266     0.150
     9.562   172.266     0.150
     9.562   328.166     0.150
    10.013   180.866     0.150
    10.479   189.866     0.150
    10.479   262.666     0.150
    10.479   339.566     0.150
    10.479   353.666     0.150
    11.269   277.791     0.150
    11.352   326.166     0.150
    11.352   175.566     0.150
    11.651   288.913     0.150
    15.361   210.385     0.150
    15.361   371.085     0.150
    15.361   483.185     0.150
    15.498   492.940     0.150
    15.498   218.466     0.150
    15.627   396.766     0.150
    17.060   237.666     0.150
    18.248   247.041     0.150
    18.248   438.966     0.150
    18.248   247.966     0.150
    22.745   299.866     0.150
    27.229   342.566     0.150
    32.879   392.766     0.150
    38.495   443.866     0.150
    43.568   482.566     0.150
    43.568   482.066     0.150
    47.309   521.466     0.150
    49.182   532.066     0.150
    49.293   530.196     0.150
    60.521   609.966     0.150
     2.294    41.695     0.150
     2.294    48.289     0.150
     2.294    66.695     0.150
     2.294    71.391     0.150
     2.801    49.391     0.150
     3.266    98.992     0.150
     3.544    63.992     0.150
     3.726    67.289     0.150
     3.726    73.992     0.150
     4.598    68.195     0.150
     4.598   140.094     0.150
     4.882    72.891     0.150
     4.882    80.391     0.150
     4.882    88.391     0.150
     5.267    95.695     0.150
     2.181    41.488     0.150
     2.181    80.689     0.150
     1.313    30.773     0.150
     2.612    50.672     0.150
     4.152    64.875     0.150
     5.330   102.273     0.150
     7.429   135.172     0.150
     1.062    33.984     0.150
     2.263    41.285     0.150
     2.263    71.484     0.150
     2.375    44.887     0.150
     2.375    78.184     0.150
     2.820    49.484     0.150
     3.510    64.387     0.150
     4.851    87.984     0.150
     4.423    70.828     0.150
     0.811    15.477     0.150
     0.811    15.477     0.150
     1.338    50.176     0.150
     2.020    62.574     0.150
     2.020    38.273     0.150
     2.020    60.977     0.150
     2.020    62.477     0.150
     2.488    48.773     0.150
     2.488    48.773     0.150
     2.546    46.875     0.150
     2.546    46.875     0.150
     2.546    80.176     0.150
     2.783    49.977     0.150
     3.515    63.176     0.150
     3.836   134.977     0.150
     3.893    62.074     0.150
     3.893    70.574     0.150
     3.826    61.273     0.150
     4.081    79.676     0.150
     4.081    65.074     0.150
     4.858   153.773     0.150
     4.858    89.574     0.150
     5.230   164.273     0.150
     5.230   164.676     0.150
     5.836   186.773     0.150
     6.492   119.773     0.150
     6.492   131.977     0.150
     6.492   204.773     0.150
     6.687   122.773     0.150
     6.687   209.773     0.150
     6.931   101.773     0.150
     7.255   201.074     0.150
     7.255   225.375     0.150
     7.271   134.477     0.150
     7.271   229.375     0.150
     7.425   135.176     0.150
     7.425   231.375     0.150
     7.576   138.477     0.150
     7.576   237.176     0.150
     7.576   138.773     0.150
     7.757   141.375     0.150
     7.757   241.875     0.150
     7.810   142.875     0.150
     7.810   244.477     0.150
     8.447   211.695     0.150
     8.447   121.156     0.150
     8.446   154.074     0.150
     8.840   160.676     0.150
     8.931   161.273     0.150
     8.931   278.875     0.150
     9.093   166.074     0.150
     9.559   179.477     0.150
    10.076   183.273     0.150
    10.510   191.875     0.150
    10.808   269.273     0.150
    10.808   156.574     0.150
    10.933   159.273     0.150
    10.970   199.375     0.150
    12.199   312.676     0.150
    12.280   175.977     0.150
    12.280   184.074     0.150
    12.280   187.074     0.150
    12.280   315.977     0.150
    12.280   320.074     0.150
    13.205   195.875     0.150
    13.205   336.676     0.150
    13.650   201.176     0.150
    13.650   205.773     0.150
    13.650   352.875     0.150
    13.650   367.773     0.150
    14.569   202.875     0.150
    16.272   224.242     0.150
    16.272   394.992     0.150
    16.272   517.895     0.150
    16.272   224.086     0.150
    16.272   225.977     0.150
    16.143   228.773     0.150
    17.677   247.773     0.150
    18.948   258.125     0.150
    18.776   267.574     0.150
    19.041   266.574     0.150
    19.514   272.074     0.150
    19.820   274.875     0.150
    20.590   286.375     0.150
    21.888     3.500     0.150
    22.067   296.773     0.150
    22.214     5.000     0.150
    22.214     8.098     0.150
    22.833     2.699     0.150
    22.833     4.500     0.150
    22.938     4.402     0.150
    23.074   307.645     0.150
    23.074   307.574     0.150
    23.074   561.875     0.150
    23.527   313.074     0.150
    23.527   562.977     0.150
    23.878   317.074     0.150
    23.933   741.426     0.150
    24.044   318.875     0.150
    24.055     2.402     0.150
    24.055     5.500     0.150
    24.055   578.676     0.150
    24.055   583.977     0.150
    25.362     3.598     0.150
    25.362     6.898     0.150
    27.122   344.977     0.150
    27.515   348.074     0.150
    27.722   348.676     0.150
    27.947   354.074     0.150
    27.970   351.773     0.150
    28.970   361.074     0.150
    29.049   363.176     0.150
    30.105   374.977     0.150
    30.204   372.773     0.150
    30.738   376.676     0.150
    30.738    11.199     0.150
    31.829     9.598     0.150
    32.115   389.773     0.150
    32.127   398.574     0.150
    32.728   396.875     0.150
    32.728   396.676     0.150
    32.891   402.875     0.150
    33.621   402.676     0.150
    33.747   403.574     0.150
    34.140   746.477     0.150
    35.197   416.789     0.150
    36.578   428.676     0.150
    36.489   429.875     0.150
    37.522   439.074     0.150
    37.522   792.375     0.150
    39.011   446.773     0.150
    39.540   455.676     0.150
    41.862   473.172     0.150
    42.258   476.594     0.150
    42.285   476.781     0.150
    42.718   480.363     0.150
    42.601   864.477     0.150
    42.970   482.375     0.150
    43.171   485.977     0.150
    43.456   863.977     0.150
    44.317   492.551     0.150
    44.586   491.875     0.150
    45.339   500.676     0.150
    45.591   498.477     0.150
    47.053   513.125     0.150
    47.662   518.273     0.150
    47.791   517.035     0.150
    47.791   517.035     0.150
    47.791   517.035     0.150
    47.791   674.977     0.150
    47.791  1209.047     0.150
    47.791   516.977     0.150
    47.791   628.875     0.150
    47.791   674.977     0.150
    47.791   933.773     0.150
    47.791  1143.875     0.150
    47.791  1208.977     0.150
    48.740     4.988     0.150
    49.331   695.477     0.150
    49.331  1171.074     0.150
    49.331  1252.977     0.150
    49.695   536.094     0.150
    49.847   536.375     0.150
    53.735   565.273     0.150
    54.673   575.977     0.150
    55.239   579.676     0.150
    55.239   579.676     0.150
    55.270   578.855     0.150
    55.270   578.875     0.150
    55.270   578.855     0.150
    55.270   579.375     0.150
    55.603   581.176     0.150
    55.617   581.375     0.150
    55.648   581.477     0.150
    55.712   580.375     0.150
    55.722   580.273     0.150
    55.726   581.773     0.150
    55.962   585.375     0.150
    56.006   584.176     0.150
    56.317   586.156     0.150
    56.317   586.074     0.150
    56.373   585.773     0.150
    56.373   707.875     0.150
    56.373   585.773     0.150
    56.784   588.977     0.150
    57.170   588.516     0.150
    57.728   596.477     0.150
    57.725   597.094     0.150
    57.741   596.871     0.150
    58.407   601.414     0.150
    58.492   602.102     0.150
    60.037   612.770     0.150
    60.068   613.309     0.150
    60.229   614.535     0.150
    60.282   613.234     0.150
    61.094   618.875     0.150
    62.642   626.074     0.150
    64.809   640.477     0.150
    66.285   651.773     0.150
    70.426   677.273     0.150
    70.426   677.352     0.150
    72.187   686.078     0.150
    73.073   693.477     0.150
    73.452   695.977     0.150
    74.041   698.082     0.150
    76.329   710.746     0.150
    76.999   714.477     0.150
    77.688   720.875     0.150
    80.485   734.988     0.150
    80.490   734.527     0.150
    81.353   737.414     0.150
    82.961   746.883     0.150
    83.361   749.102     0.150
    84.245   754.734     0.150
    85.782   760.094     0.150
     0.818    15.844     0.150
     1.341    26.445     0.150
     1.341    29.645     0.150
     1.341    42.547     0.150
     1.372    44.945     0.150
     2.015    36.547     0.150
     2.015    34.645     0.150
     2.489    50.047     0.150
     2.545    50.047     0.150
     3.516   121.445     0.150
     3.516    62.047     0.150
     3.836   133.445     0.150
     3.826    76.445     0.150
     3.826    69.746     0.150
     4.080   111.945     0.150
     4.853    96.746     0.150
     5.227   175.547     0.150
     5.834    94.246     0.150
     5.834   198.746     0.150
     6.491   100.945     0.150
     6.491   121.445     0.150
     6.491   205.445     0.150
     6.924   120.547     0.150
     7.249   243.047     0.150
     7.422   134.746     0.150
     7.574   137.246     0.150
     7.574   203.145     0.150
     7.574   235.547     0.150
     7.754   140.746     0.150
     8.133   204.746     0.150
     8.452   119.312     0.150
     8.452   141.215     0.150
     8.452   212.215     0.150
     8.838   280.746     0.150
     9.557   173.445     0.150
    10.507   190.844     0.150
    10.507   264.844     0.150
    10.804   340.996     0.150
    10.804   167.445     0.150
    10.928   345.375     0.150
    10.968   198.844     0.150
    10.968   309.246     0.150
    10.968   359.945     0.150
    11.200   183.344     0.150
    11.200   313.945     0.150
    14.869   225.547     0.150
    16.278   219.562     0.150
    16.278   392.164     0.150
    18.547   254.094     0.150
    18.547   582.695     0.150
    18.547   253.945     0.150
    18.954   258.121     0.150
    18.954   246.445     0.150
    19.043   260.465     0.150
    23.839   306.047     0.150
    23.878   313.945     0.150
    23.934   313.562     0.150
    30.809   374.246     0.150
    32.119   380.547     0.150
    43.172   473.750     0.150
    43.371   481.098     0.150
    47.795   504.496     0.150
    47.795   504.496     0.150
    47.795   504.496     0.150
    47.795   614.164     0.150
    47.795   656.434     0.150
    47.795   914.496     0.150
    47.795  1122.336     0.150
    47.795  1178.156     0.150
    47.795   504.445     0.150
    47.795   614.145     0.150
    47.795  1122.246     0.150
     5.238    97.223     0.150
     2.024    62.381     0.150
     2.500    48.581     0.150
     5.246    97.281     0.150
     2.786    68.422     0.150
     6.501   120.324     0.150
     7.280   193.625     0.150
     7.584   137.922     0.150
     1.330    28.758     0.150
     2.032    40.461     0.150
     2.094    58.664     0.150
     0.808    15.629     0.150
     1.337    28.529     0.150
     1.337    32.430     0.150
     1.337    49.229     0.150
     1.337    54.129     0.150
     1.337    25.029     0.150
     2.090    42.029     0.150
     2.090    61.729     0.150
     2.090    64.430     0.150
     2.090    39.229     0.150
     2.090    64.129     0.150
     2.024    40.129     0.150
     2.024    62.529     0.150
     2.024    38.229     0.150
     2.024    63.129     0.150
     2.488    48.930     0.150
     2.546    49.829     0.150
     2.781    77.129     0.150
     3.835    74.029     0.150
     3.892    62.430     0.150
     3.825    62.129     0.150
     3.825    69.829     0.150
     3.825   119.529     0.150
     4.082   115.529     0.150
     6.494   202.829     0.150
     6.688   208.930     0.150
     7.273   227.129     0.150
     7.273   234.129     0.150
     7.258   132.129     0.150
     7.258   202.329     0.150
     7.258   225.229     0.150
     7.258   230.029     0.150
     7.258   225.029     0.150
     7.427   135.229     0.150
     7.427   231.529     0.150
     7.577   204.829     0.150
     8.445   119.229     0.150
     9.561   173.930     0.150
    10.077   183.629     0.150
    10.810   280.680     0.150
    10.971   199.029     0.150
    10.971   170.129     0.150
    16.268   225.148     0.150
    18.541   584.930     0.150
    77.003   715.829     0.150
     1.344    51.668     0.150
     4.089   147.568     0.150
     2.085    61.651     0.150
     2.552    52.052     0.150
     3.832    77.251     0.150
     6.693   216.352     0.150
     0.820    15.941     0.150
     1.347    26.842     0.150
     1.347    25.441     0.150
     1.347    42.842     0.150
     2.088    37.541     0.150
     2.088    38.441     0.150
     2.009    36.541     0.150
     2.009    65.342     0.150
     2.550    50.941     0.150
     2.550    47.242     0.150
     2.550    79.941     0.150
     2.794    45.941     0.150
     2.794    50.842     0.150
     2.794    87.242     0.150
     3.830   134.141     0.150
     3.832    77.441     0.150
     3.832   120.141     0.150
     4.084    68.342     0.150
     4.084   133.441     0.150
     4.084    65.242     0.150
     4.449    85.842     0.150
     5.231    84.141     0.150
     5.231   175.041     0.150
     5.231    80.742     0.150
     5.827    93.342     0.150
     5.827   107.842     0.150
     5.827   157.141     0.150
     5.827   185.941     0.150
     6.495   202.141     0.150
     6.495    99.941     0.150
     6.495   121.441     0.150
     6.495   205.441     0.150
     6.688   208.641     0.150
     6.688   213.041     0.150
     7.250   122.441     0.150
     7.250   132.141     0.150
     7.250   202.041     0.150
     7.250   225.842     0.150
     7.250   131.842     0.150
     7.250   226.842     0.150
     7.273   226.541     0.150
     7.425   134.541     0.150
     7.425   237.842     0.150
     7.578   207.041     0.150
     7.578   235.141     0.150
     8.842   160.242     0.150
     9.095   165.141     0.150
     9.095   237.941     0.150
    10.797   269.842     0.150
    10.797   341.492     0.150
    10.930   346.641     0.150
    10.973   345.742     0.150
    16.280   225.461     0.150
    16.280   397.061     0.150
    16.280   519.410     0.150
    19.049   267.779     0.150
    23.845   319.441     0.150
    23.939   319.480     0.150
    44.173   493.541     0.150
     2.027    39.691     0.150
     2.558    49.391     0.150
     2.558    51.691     0.150
     5.245    90.591     0.150
     7.273   132.391     0.150
     7.441   135.191     0.150
     7.590   137.291     0.150
     1.318    46.250     0.150
     1.341    45.020     0.150
     1.367    45.120     0.150
     2.018    41.220     0.150
     2.018    73.820     0.150
     3.828    59.720     0.150
     2.018    67.875     0.150
     2.086    35.672     0.150
     2.551    44.875     0.150
     3.520   114.672     0.150
     3.831    64.578     0.150
     3.831   121.977     0.150
     4.441   142.477     0.150
     6.498    87.578     0.150
     7.258   232.875     0.150
     7.430   237.977     0.150
     7.581   245.375     0.150
     0.701    26.859     0.150
     0.701    13.160     0.150
     2.175    38.758     0.150
     2.175    66.859     0.150
     2.175    80.758     0.150
     2.175    40.758     0.150
     2.409    47.059     0.150
     2.409    76.160     0.150
     2.502    89.559     0.150
     3.432   120.359     0.150
     4.693    75.961     0.150
     4.693    95.559     0.150
     4.693   161.961     0.150
     4.926    92.461     0.150
     4.926   155.258     0.150
     5.217   163.758     0.150
     5.956   189.258     0.150
     6.446   219.359     0.150
     6.462   222.859     0.150
     6.462    97.160     0.150
     6.462   200.961     0.150
     6.677   227.559     0.150
     7.333   226.559     0.150
     7.428   243.961     0.150
     7.750   263.461     0.150
     7.919   123.961     0.150
     8.397   211.059     0.150
     8.823   159.859     0.150
     9.538   172.859     0.150
    10.935   167.660     0.150
    10.947   272.660     0.150
    10.947   346.859     0.150
    16.158   224.680     0.150
    16.158   393.004     0.150
    18.529   584.961     0.150
    18.794   454.234     0.150
    18.794   596.234     0.150
     0.142     5.285     0.150
     0.142     8.184     0.150
     0.142     5.184     0.150
     0.847    17.984     0.150
     0.847    29.785     0.150
     0.847    28.043     0.150
     0.847    28.043     0.150
     0.847    16.082     0.150
     0.847    28.082     0.150
     1.080    21.184     0.150
     2.556    43.684     0.150
     2.556    44.133     0.150
     2.556    78.922     0.150
     2.556    43.785     0.150
     2.537    51.785     0.150
     2.507    43.582     0.150
     2.507    53.082     0.150
     2.507    74.484     0.150
     3.247    97.562     0.150
     3.247    55.684     0.150
     3.080    97.562     0.150
     3.080    49.082     0.150
     3.080    86.285     0.150
     3.468    51.293     0.150
     3.468   103.195     0.150
     3.468    51.285     0.150
     3.468    90.184     0.150
     3.494    63.082     0.150
     3.961    63.285     0.150
     3.961    72.484     0.150
     3.961    63.984     0.150
     4.789   148.223     0.150
     5.126    80.285     0.150
     5.126    89.582     0.150
     5.126   100.383     0.150
     5.503    84.484     0.150
     5.840   178.785     0.150
     6.344   192.484     0.150
     6.266   195.582     0.150
     6.867   210.152     0.150
     6.699   101.184     0.150
     6.699   122.785     0.150
     7.024   213.945     0.150
     7.024   174.820     0.150
     7.024   213.488     0.150
     7.024   176.383     0.150
     7.929   144.082     0.150
     8.159   148.785     0.150
     8.620   156.582     0.150
     9.030   165.082     0.150
    10.346   257.582     0.150
    10.346   331.184     0.150
    12.398   391.383     0.150
    15.225   209.793     0.150
    15.225   485.176     0.150
    15.225   209.785     0.150
    17.058   538.859     0.150
    18.986   465.559     0.150
    20.173   270.434     0.150
    20.173   270.574     0.150
    20.173   270.582     0.150
    23.433   305.133     0.150
    28.356   353.684     0.150
    32.876   387.863     0.150
    41.949   468.203     0.150
    44.780   493.332     0.150
    47.927   516.125     0.150
    49.775   530.371     0.150
    74.796   697.082     0.150
     2.053    59.854     0.150
     2.444    84.154     0.150
     2.494    53.154     0.150
     2.494    87.955     0.150
     2.500    88.354     0.150
     3.835    63.654     0.150
     4.009   127.455     0.150
     4.770    77.055     0.150
     4.770   152.555     0.150
     5.448    91.354     0.150
     5.448   104.754     0.150
     5.448   191.055     0.150
     6.648   120.654     0.150
     6.648   128.055     0.150
     6.648   237.154     0.150
     6.674   238.754     0.150
     7.710   134.654     0.150
     8.172   147.654     0.150
     0.844    19.539     0.150
     2.074    41.539     0.150
     2.361    46.439     0.150
     2.405    49.939     0.150
     2.405    88.139     0.150
     3.095    83.139     0.150
     3.095   122.039     0.150
     3.417    65.839     0.150
     3.732    99.139     0.150
     4.054    93.439     0.150
     4.054   112.939     0.150
     4.358    82.439     0.150
     4.934   127.539     0.150
     6.162   110.139     0.150
     6.162   206.939     0.150
     6.396   233.839     0.150
     7.205   131.039     0.150
     7.205   236.539     0.150
     7.258   183.639     0.150
     7.258   251.439     0.150
     7.650   139.539     0.150
     7.650   146.039     0.150
     7.650   213.139     0.150
     7.650   256.739     0.150
     1.454    27.465     0.150
     1.454    29.465     0.150
     1.454    46.766     0.150
     2.705    70.367     0.150
     3.639    94.566     0.150
     4.022    76.266     0.150
     4.451   122.867     0.150
     6.525   118.066     0.150
     6.525   144.066     0.150
     6.914   125.664     0.150
     7.942   143.766     0.150
    11.500   305.465     0.150
     0.552    12.027     0.150
     0.798    15.926     0.150
     0.798    27.527     0.150
     1.454    44.426     0.150
     2.230    40.426     0.150
     2.230    69.629     0.150
     3.030    52.129     0.150
     2.981    46.328     0.150
     2.981    99.129     0.150
     3.740    67.828     0.150
     3.740    75.027     0.150
     5.264    95.727     0.150
     5.699   103.527     0.150
     6.527   118.926     0.150
     0.570    12.059     0.150
     0.570    20.961     0.150
     1.224    23.461     0.150
     1.224    23.570     0.150
     2.604    44.852     0.150
     2.604    74.309     0.150
     2.679    48.961     0.150
     3.380    60.961     0.150
     3.406    94.441     0.150
     4.178    76.059     0.150
     5.240   162.059     0.150
     5.449   171.090     0.150
     5.641    82.121     0.150
     5.706   102.859     0.150
     5.706   176.660     0.150
     6.154   111.961     0.150
     6.154   191.660     0.150
     6.957   126.559     0.150
     8.182   254.160     0.150
     0.930    20.192     0.150
     0.930    35.192     0.150
     2.122    40.593     0.150
     2.403    45.692     0.150
     2.403    48.192     0.150
     2.403    87.992     0.150
     0.368     7.141     0.150
     1.688    59.242     0.150
     2.294    42.742     0.150
     3.477    62.938     0.150
     4.190    80.539     0.150
     4.190    66.242     0.150
     4.310   118.836     0.150
     5.127    96.938     0.150
     5.127   130.039     0.150
     5.717   181.242     0.150
     6.967   213.336     0.150
     6.967   221.242     0.150
     7.838   143.141     0.150
     0.489    17.586     0.150
     1.248    40.465     0.150
     2.768    48.652     0.150
     2.768    85.395     0.150
     3.160    95.785     0.150
     4.382   135.273     0.150
     5.833   178.375     0.150
     6.113   187.113     0.150
     6.623   201.883     0.150
     6.770   206.715     0.150
     1.063    20.812     0.150
     1.203    23.211     0.150
     1.203    23.211     0.150
     1.203    23.211     0.150
     1.203    29.016     0.150
     1.203    23.211     0.150
     1.203    38.414     0.150
     1.710    32.516     0.150
     1.710    39.016     0.150
     1.710    54.914     0.150
     1.710    30.812     0.150
     2.385    43.414     0.150
     2.385    74.414     0.150
     2.385    43.312     0.150
     2.385    75.117     0.150
     2.840    46.211     0.150
     3.868    70.414     0.150
     3.661    65.812     0.150
     3.661    66.016     0.150
     3.661   113.211     0.150
     3.617    65.516     0.150
     4.267   129.117     0.150
     4.595    83.617     0.150
     4.852    90.117     0.150
     4.852   153.711     0.150
     4.908    88.914     0.150
     4.908    88.914     0.150
     4.908   152.516     0.150
     5.159    93.914     0.150
     5.159    77.711     0.150
     5.159   159.711     0.150
     5.143    83.312     0.150
     5.143    86.516     0.150
     5.143   160.117     0.150
     5.143    78.211     0.150
     5.143    93.211     0.150
     5.143   160.016     0.150
     5.573   102.414     0.150
     5.573   172.516     0.150
     5.850   106.016     0.150
     5.850   181.812     0.150
     6.336   114.516     0.150
     6.336   115.016     0.150
     6.336   198.812     0.150
     6.244    98.312     0.150
     6.244   101.312     0.150
     6.244   113.312     0.150
     6.244   193.414     0.150
     7.059   215.016     0.150
     6.877   214.312     0.150
     6.877    99.414     0.150
     7.092   112.812     0.150
     7.092   129.516     0.150
     7.092   221.617     0.150
     7.590   229.516     0.150
     7.402   195.914     0.150
     7.753   109.758     0.150
     7.753   189.680     0.150
     7.753   110.414     0.150
     7.753   236.117     0.150
     7.469   118.211     0.150
     7.469   136.312     0.150
     7.469   233.516     0.150
     7.540   119.211     0.150
     7.540   137.211     0.150
     7.540   235.414     0.150
     7.540   136.211     0.150
     7.540   235.711     0.150
     7.690   121.312     0.150
     7.690   139.211     0.150
     7.690   240.117     0.150
     7.889   143.117     0.150
     7.889   245.312     0.150
     8.394   152.312     0.150
     8.606   133.516     0.150
     8.606   142.016     0.150
     8.606   155.914     0.150
     8.606   156.312     0.150
     8.606   267.711     0.150
     8.752   135.312     0.150
     8.752   159.211     0.150
     9.463   170.117     0.150
    10.115   182.812     0.150
    10.115   312.312     0.150
    11.121   201.211     0.150
    11.452   165.023     0.150
    11.757   214.297     0.150
    12.021   304.711     0.150
    12.490   182.711     0.150
    12.490   185.711     0.150
    12.490   320.711     0.150
    12.836   191.914     0.150
    12.836   326.914     0.150
    13.054   182.273     0.150
    13.054   334.414     0.150
    14.195   449.953     0.150
    14.510   375.414     0.150
    16.034   219.016     0.150
    16.034   218.906     0.150
    16.034   384.859     0.150
    16.034   503.281     0.150
    16.034   219.812     0.150
    16.034   219.375     0.150
    16.247     7.000     0.150
    16.247   246.711     0.150
    16.247   413.914     0.150
    16.247   426.414     0.150
    16.314   228.016     0.150
    16.683   230.227     0.150
    16.835   425.117     0.150
    16.845   256.414     0.150
    16.845   427.914     0.150
    17.650   552.891     0.150
    18.754   582.414     0.150
    18.756   256.367     0.150
    18.756   261.367     0.150
    19.067   498.914     0.150
    19.102   267.711     0.150
    19.192   264.711     0.150
    19.447   267.016     0.150
    20.392   276.211     0.150
    20.619   278.617     0.150
    21.377     5.500     0.150
    21.891   291.312     0.150
    22.453   536.312     0.150
    22.834   311.211     0.150
    22.834     7.000     0.150
    22.834   605.414     0.150
    23.001   733.570     0.150
    23.167   307.117     0.150
    23.169   305.414     0.150
    23.143   308.117     0.150
    23.718   308.164     0.150
    23.868     6.203     0.150
    23.868   572.914     0.150
    25.123   324.812     0.150
    25.879     4.500     0.150
    25.879   601.414     0.150
    26.203     5.297     0.150
    26.203    12.000     0.150
    27.664   355.711     0.150
    28.201   354.016     0.150
    28.586   357.516     0.150
    28.791   357.617     0.150
    29.041   361.812     0.150
    29.439   365.211     0.150
    30.124   371.414     0.150
    30.657   375.211     0.150
    30.732   375.117     0.150
    31.164   383.914     0.150
    31.700   384.211     0.150
    31.867   700.711     0.150
    33.181   478.914     0.150
    33.181   559.617     0.150
    33.181   719.516     0.150
    33.181   841.617     0.150
    33.181   863.016     0.150
    33.191   403.414     0.150
    33.191     6.297     0.150
    33.191   734.414     0.150
    33.344   404.914     0.150
    33.344   398.414     0.150
    33.416   405.211     0.150
    33.811   402.312     0.150
    33.811   401.812     0.150
    34.237   409.312     0.150
    34.703   411.211     0.150
    34.768   415.711     0.150
    34.768     3.500     0.150
    34.768     6.500     0.150
    35.644   416.852     0.150
    35.523   417.711     0.150
    36.687   427.914     0.150
    37.567   435.312     0.150
    38.911   795.312     0.150
    38.911   960.711     0.150
    38.978   446.211     0.150
    40.470   460.414     0.150
    40.607   460.516     0.150
    40.807   462.617     0.150
    42.515   474.617     0.150
    42.790   480.703     0.150
    43.473   491.414     0.150
    44.221   488.617     0.150
    44.331   599.516     0.150
    44.331   888.812     0.150
    44.643   492.867     0.150
    44.774   492.516     0.150
    44.799   495.273     0.150
    44.799   492.812     0.150
    46.560   508.031     0.150
    46.493   506.617     0.150
    46.630   501.812     0.150
    46.630   908.516     0.150
    46.630  1121.414     0.150
    47.522   519.812     0.150
    47.585   524.914     0.150
    48.521   528.125     0.150
    48.621   524.812     0.150
    48.621   524.812     0.150
    48.621   687.312     0.150
    48.621   947.945     0.150
    48.621  1159.875     0.150
    48.621   524.812     0.150
    48.621   609.812     0.150
    48.621   637.914     0.150
    48.621   687.312     0.150
    48.621   947.914     0.150
    48.565   523.711     0.150
    50.073   541.023     0.150
    50.333   647.711     0.150
    50.333   706.516     0.150
    50.333   967.617     0.150
    50.333  1271.211     0.150
    50.480   537.117     0.150
    50.711   538.812     0.150
    50.711   546.164     0.150
    50.578   538.141     0.150
    50.590   537.812     0.150
    50.950   547.484     0.150
    50.950   541.312     0.150
    51.346   551.086     0.150
    51.966   554.961     0.150
    52.239   548.914     0.150
    52.439   559.531     0.150
    52.555   559.992     0.150
    52.784   559.008     0.150
    52.784   559.016     0.150
    53.375   565.914     0.150
    53.375  1774.914     0.150
    53.375   565.914     0.150
    53.434   565.797     0.150
    53.434  1778.914     0.150
    53.434   565.914     0.150
    53.434  1008.914     0.150
    53.506   567.633     0.150
    53.947   570.297     0.150
    54.622   569.312     0.150
    54.794   568.117     0.150
    54.757   576.117     0.150
    54.995   580.914     0.150
    55.019   573.211     0.150
    55.132   571.617     0.150
    55.132   575.844     0.150
    55.191   576.211     0.150
    55.239   578.039     0.150
    55.239   578.016     0.150
    55.371   579.742     0.150
    55.371   579.711     0.150
    55.433   579.852     0.150
    55.509   582.734     0.150
    55.829   580.758     0.150
    55.829   580.711     0.150
    55.839   577.117     0.150
    55.928   587.695     0.150
    56.072   586.914     0.150
    56.124   588.516     0.150
    56.213   586.914     0.150
    56.292   586.125     0.150
    56.303   582.516     0.150
    56.384   585.016     0.150
    56.430   584.117     0.150
    56.430   585.711     0.150
    56.430   585.711     0.150
    56.442   588.812     0.150
    56.442   588.812     0.150
    56.511   583.516     0.150
    56.511   589.617     0.150
    56.511   592.117     0.150
    56.521   589.211     0.150
    56.521   589.211     0.150
    56.526   589.312     0.150
    56.526   589.312     0.150
    56.551   587.047     0.150
    56.619   590.312     0.150
    56.810   584.414     0.150
    56.988   584.617     0.150
    56.988   592.273     0.150
    56.896   591.898     0.150
    57.041   594.289     0.150
    57.092   592.883     0.150
    57.092   592.992     0.150
    57.136   592.617     0.150
    57.136   595.609     0.150
    57.136  1060.914     0.150
    57.136  1275.914     0.150
    57.275   593.367     0.150
    57.189   589.812     0.150
    57.415   597.719     0.150
    57.441   597.703     0.150
    57.400   592.312     0.150
    57.437   599.117     0.150
    57.527   596.414     0.150
    57.527   596.414     0.150
    57.527   599.016     0.150
    57.586   600.211     0.150
    57.609   600.211     0.150
    57.702   600.031     0.150
    57.757   600.859     0.150
    57.561   596.711     0.150
    57.768   594.312     0.150
    58.045   602.906     0.150
    58.095   600.516     0.150
    58.113   600.414     0.150
    58.147   603.562     0.150
    58.205   601.047     0.150
    58.522   602.227     0.150
    58.526   603.211     0.150
    58.526   603.211     0.150
    58.526  1081.812     0.150
    58.549   599.789     0.150
    58.588   598.711     0.150
    58.588   604.211     0.150
    58.588   606.914     0.150
    58.588  1079.711     0.150
    58.654   604.430     0.150
    58.705   606.930     0.150
    58.760   605.016     0.150
    58.867   606.094     0.150
    59.783   614.148     0.150
    60.292   612.094     0.150
    60.649   620.617     0.150
    60.635   618.492     0.150
    60.860   614.797     0.150
    61.016   617.484     0.150
    61.071   617.898     0.150
    61.155   622.492     0.150
    61.347   624.578     0.150
    61.605   620.594     0.150
    61.959   618.945     0.150
    62.177   621.617     0.150
    63.044   632.617     0.150
    64.329   632.711     0.150
    65.742   651.312     0.150
    68.476   661.312     0.150
    69.310   666.844     0.150
    69.453   666.984     0.150
    69.780   669.852     0.150
    69.780   669.812     0.150
    71.914   689.531     0.150
    72.529   696.094     0.150
    72.797   688.016     0.150
    72.919   698.477     0.150
    73.196   700.758     0.150
    73.279   701.273     0.150
    73.339   701.273     0.150
    73.646   692.016     0.150
    73.767   703.367     0.150
    73.897   704.852     0.150
    74.054   705.695     0.150
    74.054  1567.555     0.150
    74.526   708.406     0.150
    74.697   709.305     0.150
    74.861   709.914     0.150
    74.981   711.172     0.150
    75.280   713.008     0.150
    75.429   713.484     0.150
    75.476   713.844     0.150
    75.844   715.664     0.150
    75.878   716.234     0.150
    75.989   714.453     0.150
    76.275   718.797     0.150
    76.568   720.461     0.150
    76.688   721.094     0.150
    76.775   721.492     0.150
    76.928   711.312     0.150
    76.995   723.211     0.150
    82.504   741.211     0.150
    83.395   746.516     0.150
    83.673   747.617     0.150
    85.107   754.312     0.150
    86.316   760.711     0.150
    86.366   761.117     0.150
    86.838   770.867     0.150
    89.583   778.961     0.150
   139.759  1340.789     0.150
   151.855  1192.812     0.150
   154.089  1205.539     0.150
     0.299     6.086     0.150
     0.299     6.086     0.150
     1.286    43.883     0.150
     1.286    45.383     0.150
     2.015    63.680     0.150
     2.479    41.680     0.150
     2.479    44.984     0.150
     2.478    88.180     0.150
     4.039    73.086     0.150
     4.039   125.680     0.150
     4.253    67.086     0.150
     4.807    90.180     0.150
     4.807   149.086     0.150
     5.478   172.180     0.150
     5.478    83.781     0.150
     5.478    99.984     0.150
     6.037   112.484     0.150
     6.037   189.383     0.150
     6.682   208.086     0.150
     7.171   106.086     0.150
     7.458   136.086     0.150
     7.724   139.680     0.150
     7.724   140.586     0.150
     8.045   242.828     0.150
     9.317   169.086     0.150
    11.317   357.883     0.150
    13.552   204.180     0.150
    15.749   216.500     0.150
    15.749   216.781     0.150
    18.508   252.180     0.150
    23.815   310.586     0.150
    23.962   324.781     0.150
    27.254   348.984     0.150
     0.365     8.059     0.150
     0.365    13.359     0.150
     1.539    27.461     0.150
     1.835    33.859     0.150
     1.835    57.160     0.150
     1.835    33.859     0.150
     1.835    57.262     0.150
     2.585    47.461     0.150
     2.585    51.262     0.150
     2.585    73.359     0.150
     2.810    44.359     0.150
     3.273    51.961     0.150
     3.273    58.461     0.150
     3.087    55.859     0.150
     3.087    55.859     0.150
     3.299    59.859     0.150
     3.299   103.461     0.150
     3.299   111.762     0.150
     4.207   108.660     0.150
     4.207   128.262     0.150
     4.070   126.059     0.150
     4.421   116.359     0.150
     4.421   137.160     0.150
     4.835    91.059     0.150
     4.835   150.160     0.150
     5.350   164.762     0.150
     5.728   179.359     0.150
     5.838   183.160     0.150
     6.067   189.160     0.150
     6.067   110.160     0.150
     6.067   189.059     0.150
     7.480   106.180     0.150
     7.480   181.641     0.150
     7.480   228.762     0.150
     7.264   130.762     0.150
     7.264   225.559     0.150
     7.264   106.762     0.150
     7.264   130.859     0.150
     7.264   225.262     0.150
     7.294   131.461     0.150
     7.365   133.660     0.150
     7.365   228.660     0.150
     7.701   118.160     0.150
     8.104   146.762     0.150
     8.236   149.859     0.150
     8.379   202.461     0.150
     8.303   257.762     0.150
     8.607   156.059     0.150
     9.715   176.262     0.150
    11.609   170.961     0.150
    11.718   173.660     0.150
    11.718   298.660     0.150
    15.346   208.402     0.150
    15.346   368.355     0.150
    17.644   241.535     0.150
    17.672   241.660     0.150
    18.552   252.059     0.150
    18.552   447.844     0.150
    19.458   272.359     0.150
    20.023   277.059     0.150
    24.309   321.461     0.150
    24.508   322.160     0.150
    24.508   325.859     0.150
    43.413   586.859     0.150
    43.913   489.059     0.150
    47.777   519.461     0.150
    49.499   533.859     0.150
     2.667    54.112     0.150
     2.667    93.812     0.150
     0.923    35.008     0.150
     2.438    47.008     0.150
     4.147    79.309     0.150
     4.866    77.207     0.150
     1.452    47.477     0.150
     1.452    26.875     0.150
     1.851    58.570     0.150
     2.437    72.375     0.150
     2.437    45.273     0.150
     2.878    92.172     0.150
     2.878    47.773     0.150
     4.131   146.875     0.150
     5.903   109.477     0.150
     5.903   184.773     0.150
     6.846   124.273     0.150
     6.846   212.570     0.150
     6.846   124.375     0.150
     6.941   126.273     0.150
     7.180   183.977     0.150
     7.831   143.070     0.150
     7.954   145.273     0.150
     8.357   152.672     0.150
     9.936   249.414     0.150
    10.998   338.719     0.150
    11.454   288.695     0.150
    15.681   216.695     0.150
    15.681   381.719     0.150
    15.681   217.570     0.150
    77.500   716.773     0.150
     0.224     4.648     0.150
     0.224     4.648     0.150
     4.126   150.547     0.150
     4.974    79.445     0.150
     1.454    27.344     0.150
     1.850    33.742     0.150
     1.850    68.742     0.150
     2.441    45.938     0.150
     2.441    45.938     0.150
     2.441    91.039     0.150
     2.606    46.844     0.150
     3.699    68.039     0.150
     4.041    64.039     0.150
     4.129   149.141     0.150
     4.420   138.438     0.150
     5.429   154.242     0.150
     5.641    87.141     0.150
     5.641   175.742     0.150
     6.849   104.844     0.150
     6.849   126.141     0.150
     6.849   212.742     0.150
     6.868   124.539     0.150
     6.944   126.141     0.150
     7.184    98.516     0.150
     7.184   222.062     0.150
     7.472   194.141     0.150
     7.472   272.844     0.150
     7.836   214.844     0.150
     7.957   145.438     0.150
     7.957   144.438     0.150
     7.905   111.953     0.150
     7.905   111.758     0.150
     7.905   111.344     0.150
     8.361   153.141     0.150
     8.413   218.938     0.150
     9.940   141.680     0.150
    11.309   169.742     0.150
    11.309   290.242     0.150
    11.458   293.945     0.150
    11.458   165.891     0.150
    15.188   463.023     0.150
    15.676   216.867     0.150
    15.676   217.359     0.150
    15.676   380.961     0.150
    15.676   217.539     0.150
    16.728   232.039     0.150
    16.728   231.992     0.150
    18.075   558.867     0.150
    18.571   253.664     0.150
    18.571   253.242     0.150
    18.571   253.133     0.150
    19.145   610.289     0.150
    19.809   267.617     0.150
    19.809   267.641     0.150
    20.279   273.180     0.150
    24.293   319.750     0.150
    27.407   347.359     0.150
    29.878   369.148     0.150
    29.939   371.344     0.150
    32.363   390.844     0.150
    32.933   396.141     0.150
    34.837   414.531     0.150
    42.812   478.914     0.150
    65.436   490.578     0.150
    49.523   531.812     0.150
    49.535   532.539     0.150
    81.104   734.156     0.150
   146.433  1177.961     0.150
     0.218     4.500     0.150
     1.454    28.195     0.150
     1.851    67.898     0.150
     2.601    80.297     0.150
     2.883    46.695     0.150
     2.883    52.500     0.150
     2.883    95.797     0.150
     3.629   130.602     0.150
     4.121   148.797     0.150
     4.422    69.102     0.150
     4.422   138.297     0.150
     5.644   175.195     0.150
     5.644   176.898     0.150
     5.909   109.500     0.150
     5.909   184.602     0.150
     6.484   118.297     0.150
     6.484   202.398     0.150
     6.851   125.000     0.150
     6.851   213.898     0.150
     6.851   125.297     0.150
     6.871   125.797     0.150
     6.947   126.797     0.150
     7.107   130.102     0.150
     7.481   269.898     0.150
     7.899   239.445     0.150
     7.899   113.000     0.150
     7.844   141.695     0.150
     7.844   143.898     0.150
     7.960   145.797     0.150
     7.960   145.500     0.150
     8.364   152.500     0.150
     8.845   161.102     0.150
     8.845   235.500     0.150
     9.942   305.789     0.150
    11.006   282.195     0.150
    11.006   341.570     0.150
    15.668   215.992     0.150
    15.668   381.445     0.150
    49.517   534.898     0.150
     0.219     4.703     0.150
     2.451    41.398     0.150
     2.451    45.805     0.150
     2.451    77.000     0.150
     3.636    58.305     0.150
     3.636   103.703     0.150
     4.033    67.000     0.150
     4.968    92.000     0.150
     5.637   103.805     0.150
     5.637   176.305     0.150
     5.915   109.203     0.150
     5.915   181.898     0.150
     6.843   124.398     0.150
     6.843   213.203     0.150
     6.843   102.398     0.150
     6.864   124.703     0.150
     7.193   106.195     0.150
     7.193   131.000     0.150
     7.480   109.898     0.150
     7.480   194.805     0.150
     7.674   139.602     0.150
     7.838   140.898     0.150
     7.838   142.398     0.150
     7.869   143.703     0.150
     7.952   145.602     0.150
     7.952   145.102     0.150
     8.357   151.398     0.150
     8.424   218.805     0.150
     8.837   160.500     0.150
    11.011   282.445     0.150
    11.182   158.602     0.150
    11.457   355.172     0.150
    11.482   163.898     0.150
    15.199   472.516     0.150
    15.671   213.234     0.150
    15.671   216.547     0.150
    15.671   381.172     0.150
    15.671   218.102     0.150
    18.560   253.180     0.150
    18.560   253.602     0.150
    18.560   250.445     0.150
    19.135   260.523     0.150
    24.285   318.750     0.150
    27.369   346.602     0.150
    34.829   411.945     0.150
    49.512   534.305     0.150
    73.054   693.594     0.150
     0.212     4.420     0.150
     0.212     7.119     0.150
     0.942    35.920     0.150
     1.461    27.020     0.150
     1.845    33.619     0.150
     2.604    43.020     0.150
     2.453    44.119     0.150
     2.453    50.920     0.150
     2.708    57.119     0.150
     2.708   103.319     0.150
     2.892    90.319     0.150
     4.049    65.520     0.150
     4.049   113.619     0.150
     4.049   126.319     0.150
     4.983   134.819     0.150
     5.445   170.119     0.150
     5.653   176.319     0.150
     5.653    85.720     0.150
     5.653   176.220     0.150
     5.905   184.720     0.150
     6.493   201.720     0.150
     6.493   239.920     0.150
     6.860   125.020     0.150
     6.860   214.720     0.150
     6.860   124.720     0.150
     6.860   213.619     0.150
     6.880   125.420     0.150
     6.880   214.420     0.150
     6.956   126.220     0.150
     6.956   131.319     0.150
     6.956   216.420     0.150
     7.116   129.020     0.150
     7.116   220.619     0.150
     7.890   112.714     0.150
     7.890   109.119     0.150
     7.890   224.520     0.150
     7.890   112.829     0.150
     7.486   117.649     0.150
     7.486   136.220     0.150
     7.486   232.420     0.150
     7.486   268.619     0.150
     7.691   239.720     0.150
     7.886   143.020     0.150
     7.886   245.020     0.150
     7.852   140.920     0.150
     7.852   114.619     0.150
     7.852   142.819     0.150
     7.852   243.819     0.150
     7.968   144.819     0.150
     7.968   145.020     0.150
     7.968   151.220     0.150
     7.968   247.920     0.150
     8.192   148.520     0.150
     8.192   254.619     0.150
     8.243   256.319     0.150
     8.308   151.020     0.150
     8.308   258.520     0.150
     8.374   152.819     0.150
     8.420   218.420     0.150
     8.854   160.119     0.150
     8.854   222.619     0.150
     9.951   301.737     0.150
     9.951   149.020     0.150
    10.941   154.720     0.150
    11.004   337.338     0.150
    11.198   166.789     0.150
    11.473   354.578     0.150
    11.473   171.510     0.150
    14.018   204.409     0.150
    15.660   217.199     0.150
    15.660   216.889     0.150
    15.660   217.220     0.150
    15.196   221.340     0.150
    15.196   471.420     0.150
    18.562   253.319     0.150
    18.562   253.149     0.150
    19.149   595.347     0.150
    19.149   265.779     0.150
    20.291   639.229     0.150
    20.291   278.520     0.150
    23.203     6.400     0.150
    24.301   320.510     0.150
    32.129   702.720     0.150
    32.129   807.420     0.150
    32.939   397.960     0.150
    32.939   397.739     0.150
    39.837   456.189     0.150
    43.860   489.520     0.150
    43.860   487.109     0.150
    53.564   561.939     0.150
    57.716   591.710     0.150
     2.884    54.287     0.150
     5.644    87.088     0.150
     0.190     3.938     0.150
     0.190     7.035     0.150
     1.443    28.438     0.150
     1.443    46.336     0.150
     1.443    49.137     0.150
     2.576    46.438     0.150
     4.031    63.738     0.150
     4.419    68.938     0.150
     5.451   169.535     0.150
     5.645    86.535     0.150
     6.848   102.637     0.150
     6.872   123.938     0.150
     6.872   213.035     0.150
     6.945   126.238     0.150
     7.509   233.535     0.150
     7.860   142.738     0.150
     4.435    68.441     0.150
     6.960   126.340     0.150
     1.456    29.141     0.150
     1.847    36.641     0.150
     2.434    85.742     0.150
     4.042   101.938     0.150
     6.849   124.438     0.150
     6.849   188.539     0.150
     6.944   125.844     0.150
     0.212     4.852     0.150
     0.212     4.852     0.150
     1.449    27.453     0.150
     1.449    31.953     0.150
     2.457    39.953     0.150
     2.457    86.953     0.150
     2.594    51.555     0.150
     2.881    59.453     0.150
     3.633    55.352     0.150
     4.037    77.055     0.150
     6.870   124.648     0.150
     1.469    27.066     0.150
     1.836    33.566     0.150
     1.836    36.270     0.150
     1.836    61.668     0.150
     2.447    41.469     0.150
     2.447    46.066     0.150
     2.447    77.066     0.150
     2.716    49.770     0.150
     2.899    93.066     0.150
     2.899    48.066     0.150
     3.613   102.566     0.150
     4.438    71.270     0.150
     5.447   171.168     0.150
     5.659   176.566     0.150
     5.897   109.066     0.150
     5.897   184.770     0.150
     6.867   125.770     0.150
     6.867   216.668     0.150
     6.867   125.168     0.150
     6.867   213.566     0.150
     6.867   226.668     0.150
     6.887   126.367     0.150
     6.962   126.867     0.150
     7.122   221.270     0.150
     7.195   130.844     0.150
     7.482   232.867     0.150
     7.887   237.785     0.150
     7.887   111.469     0.150
     7.887   225.566     0.150
     7.697   140.066     0.150
     7.854   143.566     0.150
     7.854   144.270     0.150
     7.854   216.168     0.150
     7.854   254.367     0.150
     7.891   143.566     0.150
     7.975   145.969     0.150
     7.975   119.270     0.150
     7.975   143.969     0.150
     7.975   247.770     0.150
     8.198   254.566     0.150
     8.379   152.469     0.150
     8.379   272.469     0.150
     8.412   219.469     0.150
     8.860   161.969     0.150
     9.957   255.859     0.150
     9.957   307.035     0.150
    10.996   338.938     0.150
    11.202   167.668     0.150
    11.477   294.270     0.150
    11.477   357.547     0.150
    13.738   200.867     0.150
    15.661   216.938     0.150
    15.661   490.887     0.150
    15.661   216.770     0.150
    16.881   435.469     0.150
    17.270   532.035     0.150
    18.056   556.691     0.150
    18.569   253.543     0.150
    18.569   457.543     0.150
    18.569   576.441     0.150
    19.158   597.617     0.150
    21.098   287.469     0.150
    27.418   350.168     0.150
    43.282   616.770     0.150
    77.512   716.668     0.150
     2.894    54.766     0.150
     0.219     4.594     0.150
     0.219     4.594     0.150
     0.219     4.594     0.150
     0.948    17.992     0.150
     0.948    30.492     0.150
     1.456    49.695     0.150
     1.849    33.695     0.150
     2.448    71.898     0.150
     2.448    76.992     0.150
     2.604    80.492     0.150
     2.702    45.398     0.150
     2.702    49.398     0.150
     2.702    85.297     0.150
     2.885    47.898     0.150
     2.885    52.594     0.150
     2.885    90.297     0.150
     3.626   129.492     0.150
     4.124    63.898     0.150
     4.124    75.492     0.150
     4.124   128.797     0.150
     4.124   148.594     0.150
     4.424    69.195     0.150
     4.424    79.992     0.150
     4.424   138.398     0.150
     4.978    90.398     0.150
     4.978    76.898     0.150
     4.978    90.398     0.150
     4.978   155.398     0.150
     5.437   170.398     0.150
     5.437   170.195     0.150
     5.646   176.297     0.150
     5.646   176.398     0.150
     5.906    91.195     0.150
     5.906   150.992     0.150
     5.906   188.695     0.150
     6.486   118.195     0.150
     6.486   202.492     0.150
     6.853   123.898     0.150
     6.853   210.398     0.150
     6.853   124.992     0.150
     6.853   214.195     0.150
     6.873   125.195     0.150
     6.873   214.195     0.150
     6.949   126.297     0.150
     6.949   216.398     0.150
     7.109   128.992     0.150
     7.109   221.195     0.150
     7.479   136.398     0.150
     7.479   110.195     0.150
     7.479   136.398     0.150
     7.479   191.898     0.150
     7.479   232.898     0.150
     7.479   272.898     0.150
     7.899   142.797     0.150
     7.899   246.297     0.150
     7.844   140.898     0.150
     7.844   242.492     0.150
     7.844   142.695     0.150
     7.878   143.594     0.150
     7.878   245.195     0.150
     7.962   144.195     0.150
     7.962   247.094     0.150
     7.962   145.492     0.150
     7.962   191.695     0.150
     8.184   149.094     0.150
     8.235   255.695     0.150
     8.366   152.695     0.150
     8.366   260.094     0.150
     8.847   161.297     0.150
     8.847   130.094     0.150
     8.847   161.297     0.150
     8.847   274.797     0.150
     9.487   249.992     0.150
     9.487   138.797     0.150
     9.487   172.797     0.150
     9.487   249.992     0.150
     9.944   303.289     0.150
    10.431   151.094     0.150
    10.431   189.695     0.150
    11.003   339.242     0.150
    10.934   159.492     0.150
    10.934   197.695     0.150
    11.190   160.844     0.150
    11.313   164.398     0.150
    11.313   183.195     0.150
    11.465   355.539     0.150
    11.492   166.297     0.150
    11.492   195.492     0.150
    11.492   314.297     0.150
    14.405   201.398     0.150
    15.193   470.719     0.150
    15.668   216.648     0.150
    15.668   216.711     0.150
    15.668   484.992     0.150
    18.566   253.742     0.150
    18.566   453.547     0.150
    18.566   252.617     0.150
    20.285   273.234     0.150
    21.086    10.000     0.150
    22.799   295.992     0.150
    22.799     5.203     0.150
    23.980   315.555     0.150
    24.178   315.945     0.150
    24.296   317.789     0.150
    27.882   351.086     0.150
    30.868   377.195     0.150
    31.058   379.977     0.150
    32.128   809.797     0.150
    32.935   397.227     0.150
    32.935   397.312     0.150
    47.533   518.695     0.150
    55.225   571.898     0.150
    58.684   595.922     0.150
     1.450    49.969     0.150
     1.446    27.598     0.150
     0.227     4.723     0.150
     1.451    27.121     0.150
     1.853    33.922     0.150
     2.442    44.723     0.150
     2.442    77.223     0.150
     2.442    86.322     0.150
     2.603    47.021     0.150
     2.878    90.521     0.150
     4.038    64.121     0.150
     4.038   141.723     0.150
     5.427   170.322     0.150
     5.638   176.021     0.150
     5.906    91.723     0.150
     5.906   102.521     0.150
     5.906   184.723     0.150
     6.478   201.922     0.150
     6.846   124.521     0.150
     6.846   213.121     0.150
     6.865   125.121     0.150
     6.865   232.422     0.150
     6.941   126.223     0.150
     7.834   141.322     0.150
     7.834   142.922     0.150
     7.834   244.521     0.150
     7.834   252.521     0.150
     7.870   245.223     0.150
     7.954   246.223     0.150
     8.176   255.422     0.150
     8.358   151.922     0.150
     8.358   261.223     0.150
    11.456   211.330     0.150
    81.105   735.922     0.150
     0.219     4.580     0.150
     0.219     7.379     0.150
     0.954    19.680     0.150
     0.954    34.080     0.150
     1.450    26.979     0.150
     1.450    31.279     0.150
     1.450    47.080     0.150
     1.450    49.680     0.150
     1.855    33.779     0.150
     2.449    45.979     0.150
     2.449    86.680     0.150
     2.599    88.779     0.150
     2.696    85.180     0.150
     2.880    52.779     0.150
     3.632   113.080     0.150
     4.037   126.379     0.150
     5.911   184.580     0.150
     7.479   113.979     0.150
     7.479   113.979     0.150
     7.479   112.680     0.150
     7.840   141.479     0.150
     7.840   143.379     0.150
     7.873   142.879     0.150
     7.903   115.270     0.150
     8.179   149.379     0.150
     8.361   152.580     0.150
     8.841   160.580     0.150
     9.481   171.979     0.150
    10.425   188.779     0.150
    11.007   281.646     0.150
    15.197   216.719     0.150
    15.670   217.520     0.150
    15.670   215.924     0.150
    15.670   380.498     0.150
    15.670   490.824     0.150
    18.563   252.555     0.150
    18.563   450.404     0.150
    18.563   584.955     0.150
    18.563   253.580     0.150
    18.563   253.379     0.150
    20.287   649.180     0.150
    24.127   763.014     0.150
    32.772   397.189     0.150
    32.929   396.430     0.150
    32.929   396.430     0.150
    34.833   413.289     0.150
    36.051   425.000     0.150
    43.859   487.260     0.150
    47.528   512.779     0.150
    56.098   577.680     0.150
    58.681   599.871     0.150
    68.628   665.660     0.150
     1.251    43.725     0.150
     0.369     7.322     0.150
     1.247    23.223     0.150
     1.247    39.422     0.150
     1.247    44.021     0.150
     2.439    71.623     0.150
     2.439    87.822     0.150
     2.482    44.822     0.150
     2.659    48.822     0.150
     3.837    69.322     0.150
     4.199    74.723     0.150
     5.240   164.521     0.150
     5.419   170.021     0.150
     6.258   196.021     0.150
     6.627   121.322     0.150
     6.627   206.123     0.150
     6.646   120.922     0.150
     6.646   207.623     0.150
     6.722   210.223     0.150
     7.456   231.822     0.150
     7.735   140.021     0.150
     7.735   240.123     0.150
     9.717   305.465     0.150
    15.816   218.516     0.150
     4.434    70.262     0.150
     2.431    68.976     0.150
     2.431    87.376     0.150
     2.614    89.376     0.150
     2.702    54.476     0.150
     5.640   105.976     0.150
     6.944   132.276     0.150
     0.372     7.277     0.150
     0.372     7.277     0.150
     0.372     7.277     0.150
     0.372    11.777     0.150
     1.245    23.176     0.150
     1.245    23.176     0.150
     1.245    23.176     0.150
     1.245    24.977     0.150
     1.245    39.078     0.150
     1.245    41.578     0.150
     2.052    36.277     0.150
     2.052    64.375     0.150
     2.052    74.477     0.150
     2.439    71.676     0.150
     2.439    41.477     0.150
     2.439    41.477     0.150
     2.439    44.777     0.150
     2.439    83.477     0.150
     2.485    42.078     0.150
     2.481    41.375     0.150
     2.481    76.375     0.150
     2.657    44.578     0.150
     2.657    44.578     0.150
     2.657    92.477     0.150
     3.828    60.777     0.150
     5.237   165.078     0.150
     5.416   168.777     0.150
     5.416    82.277     0.150
     5.416    91.375     0.150
     6.043   110.477     0.150
     6.043   190.277     0.150
     6.256   220.977     0.150
     6.625   119.977     0.150
     6.625   206.875     0.150
     6.625    98.676     0.150
     6.625   117.777     0.150
     7.401   107.676     0.150
     7.401   134.477     0.150
     7.401   266.676     0.150
     7.454   135.477     0.150
     7.651   139.375     0.150
     7.650   138.875     0.150
     7.650   215.777     0.150
     7.732   140.277     0.150
     7.732   113.676     0.150
     7.732   140.277     0.150
     7.955   144.375     0.150
     8.006   145.277     0.150
     8.071   146.777     0.150
     8.137   147.676     0.150
     8.115   210.977     0.150
     8.484   220.578     0.150
     8.617   156.477     0.150
     9.009   163.977     0.150
     9.074   165.375     0.150
     9.257   168.875     0.150
     9.257   231.078     0.150
     9.715   174.668     0.150
     9.715   138.008     0.150
     9.715   176.375     0.150
    10.203   141.477     0.150
    10.203   184.875     0.150
    10.203   265.875     0.150
    10.704   194.176     0.150
    10.704   269.477     0.150
    10.704   346.375     0.150
    10.973   155.418     0.150
    10.973   199.578     0.150
    10.973   387.875     0.150
    11.246   159.238     0.150
    11.270   187.375     0.150
    11.270   317.777     0.150
    13.648   206.777     0.150
    15.244   214.777     0.150
    15.656   231.078     0.150
    15.818   217.746     0.150
    16.531     5.801     0.150
    18.029   251.195     0.150
    18.298   573.551     0.150
    18.540   252.551     0.150
    18.540   455.152     0.150
    19.306   271.176     0.150
    19.937   633.652     0.150
    20.265   275.406     0.150
    20.377   511.977     0.150
    22.343   305.578     0.150
    22.601     8.500     0.150
    22.968     4.199     0.150
    23.372   307.977     0.150
    24.079   316.176     0.150
    24.233   317.375     0.150
    25.657     3.602     0.150
    25.657     7.500     0.150
    26.145   344.477     0.150
    27.662   348.176     0.150
    29.659   365.738     0.150
    30.151   370.277     0.150
    32.562   391.055     0.150
    32.725   392.586     0.150
    32.725   392.586     0.150
    36.243   424.148     0.150
    36.266   423.988     0.150
   160.829   426.977     0.150
    36.599   409.398     0.150
    44.452   430.047     0.150
    38.044   437.676     0.150
    46.181   447.055     0.150
    39.610   451.215     0.150
    41.747   460.121     0.150
    43.166   584.875     0.150
    43.166   615.176     0.150
    44.335   488.777     0.150
    45.847   502.008     0.150
    46.432   506.156     0.150
    47.477   516.055     0.150
    47.477   516.055     0.150
    47.477   673.016     0.150
    47.477  1141.867     0.150
    47.477  1204.648     0.150
    47.477   515.977     0.150
    47.477   627.777     0.150
    47.477   672.977     0.150
    47.477   931.777     0.150
    47.477  1204.578     0.150
    49.140   696.676     0.150
    49.140  1166.676     0.150
    49.140  1243.676     0.150
    49.422   529.875     0.150
    49.422   529.875     0.150
    49.491   529.508     0.150
    50.104   535.238     0.150
    54.227   566.938     0.150
    54.662   568.027     0.150
    55.074   571.816     0.150
    55.294   572.945     0.150
    55.383   575.477     0.150
    55.395   575.277     0.150
    56.028   581.676     0.150
    56.028   578.777     0.150
    56.028  1301.977     0.150
    56.450   581.617     0.150
    57.398   589.777     0.150
    57.465   590.176     0.150
    60.692   611.738     0.150
    62.204   621.398     0.150
    63.564   630.375     0.150
    68.835   664.547     0.150
    73.626   693.375     0.150
    73.626   693.336     0.150
    73.649   693.227     0.150
    73.652   693.738     0.150
   149.589  1189.648     0.150
   151.609  1193.016     0.150
     0.943    34.969     0.150
     5.436   155.066     0.150
     5.648    87.668     0.150
     6.857   104.469     0.150
     1.846    37.203     0.150
     2.443    87.902     0.150
     3.703   106.102     0.150
     6.873   125.102     0.150
     0.938    36.305     0.150
     2.455    87.906     0.150
     0.221     4.422     0.150
     0.221     7.324     0.150
     1.464    27.324     0.150
     1.841    33.523     0.150
     2.444    41.723     0.150
     2.444    76.922     0.150
     2.444    87.523     0.150
     2.611    80.422     0.150
     2.611    89.824     0.150
     2.892    52.125     0.150
     2.892    55.324     0.150
     4.051    67.523     0.150
     5.440   170.824     0.150
     5.440   170.824     0.150
     5.652   176.723     0.150
     5.652    85.824     0.150
     5.652   176.824     0.150
     5.898   188.023     0.150
     6.492   118.723     0.150
     6.492   172.324     0.150
     6.492   203.125     0.150
     6.860   214.023     0.150
     6.860   124.422     0.150
     6.860   212.723     0.150
     6.879   125.324     0.150
     6.879   181.723     0.150
     6.879   214.824     0.150
     6.955   117.723     0.150
     6.955   192.223     0.150
     6.955   217.324     0.150
     7.190   130.375     0.150
     7.477   135.922     0.150
     7.477   234.023     0.150
     7.477   267.324     0.150
     7.894   109.625     0.150
     7.690   238.922     0.150
     7.847   142.922     0.150
     7.847   244.922     0.150
     7.884   143.125     0.150
     7.884   244.523     0.150
     7.968   248.625     0.150
     8.241   256.723     0.150
     8.372   152.723     0.150
     9.951   303.215     0.150
    11.320   151.523     0.150
    15.668   216.055     0.150
    15.668   381.445     0.150
    15.668   216.617     0.150
    15.668   381.441     0.150
    15.668   216.023     0.150
    18.571   257.723     0.150
    18.571   452.199     0.150
    24.141   317.125     0.150
    24.141   317.125     0.150
    27.386   346.594     0.150
    43.281   615.922     0.150
    54.258   566.172     0.150
    66.076   655.074     0.150
    77.508   716.523     0.150
    81.108   737.523     0.150
    81.108   737.473     0.150
   146.439  1179.762     0.150
     0.215     4.379     0.150
     1.459    26.879     0.150
     1.459    46.879     0.150
     2.451    44.979     0.150
     2.451    76.979     0.150
     2.603    43.379     0.150
     2.603    80.379     0.150
     2.705    55.078     0.150
     2.705    85.379     0.150
     3.624   131.279     0.150
     3.704    94.178     0.150
     4.046    64.078     0.150
     4.046    73.979     0.150
     4.046   126.379     0.150
     5.650   176.578     0.150
     5.650   103.279     0.150
     6.857   124.779     0.150
     6.857   214.779     0.150
     6.857   102.379     0.150
     7.849   141.078     0.150
     7.849   143.279     0.150
     7.849   270.879     0.150
     7.883   143.279     0.150
     7.883   216.078     0.150
     8.188   149.678     0.150
     8.188   228.279     0.150
     8.851   160.578     0.150
     9.948   304.896     0.150
    11.004   339.221     0.150
    11.470   354.484     0.150
    15.663   217.748     0.150
    16.877   427.879     0.150
    23.982   312.979     0.150
     0.689    21.402     0.150
     1.131    21.402     0.150
     1.131    21.402     0.150
     1.131    22.902     0.150
     1.131    40.102     0.150
     1.131    21.402     0.150
     1.409    28.203     0.150
     2.266    40.000     0.150
     2.322    43.301     0.150
     2.322    73.801     0.150
     2.538    78.801     0.150
     3.666    66.402     0.150
     3.973    63.301     0.150
     3.973   125.000     0.150
     4.016   107.500     0.150
     4.016    63.402     0.150
     4.016   124.402     0.150
     5.161    95.500     0.150
     5.161   161.203     0.150
     6.396   198.801     0.150
     6.856   125.652     0.150
     7.334   134.402     0.150
     7.334   189.000     0.150
     7.334   228.000     0.150
     7.380   198.602     0.150
     7.696   140.402     0.150
     7.869   143.000     0.150
     8.419   220.145     0.150
     8.841   158.801     0.150
     8.841   275.500     0.150
     9.014   164.102     0.150
     9.014   247.902     0.150
    10.670   159.102     0.150
    10.946   200.562     0.150
    16.129   222.496     0.150
    18.703   264.000     0.150
    18.854   266.301     0.150
    19.265   270.500     0.150
    23.662   318.402     0.150
    23.740   318.301     0.150
    23.740   320.402     0.150
    31.992   392.801     0.150
    43.914   488.102     0.150
    77.221   717.078     0.150
    77.221   717.102     0.150
     0.660    12.383     0.150
     1.126    20.789     0.150
     1.126    20.984     0.150
     1.126    35.383     0.150
     2.292    42.289     0.150
     2.325    46.484     0.150
     4.009    63.789     0.150
     4.950   155.383     0.150
     5.177   161.484     0.150
     6.068   111.383     0.150
     6.019   162.789     0.150
     6.019   187.984     0.150
     6.408   199.984     0.150
     6.408   200.086     0.150
     6.405   116.984     0.150
     6.405   199.883     0.150
     6.493   202.586     0.150
     6.638   121.188     0.150
     6.638   207.086     0.150
     6.887   126.633     0.150
     7.173   108.023     0.150
     7.173   129.883     0.150
     7.173   223.383     0.150
     7.173   107.984     0.150
     7.217   131.484     0.150
     7.217   225.289     0.150
     7.363   134.688     0.150
     7.363   229.789     0.150
     7.363   228.789     0.150
     7.398   133.883     0.150
     7.398   229.484     0.150
     7.506   136.188     0.150
     7.506   233.984     0.150
     7.712   139.688     0.150
     7.712   215.484     0.150
     7.712   239.383     0.150
     7.764   141.086     0.150
     7.764   241.586     0.150
     7.834   142.586     0.150
     7.834   244.383     0.150
     7.887   143.484     0.150
     7.887   245.383     0.150
     7.887   274.289     0.150
     8.394   147.609     0.150
     8.394   213.578     0.150
     8.232   256.188     0.150
     8.406   211.586     0.150
     8.385   153.188     0.150
     8.385   222.883     0.150
     8.778   159.984     0.150
     8.854   161.188     0.150
     8.854   160.984     0.150
     8.854   275.789     0.150
     9.489   171.953     0.150
     9.489   293.352     0.150
     9.489   243.180     0.150
     9.489   172.688     0.150
     9.989   181.883     0.150
    10.464   155.484     0.150
    10.694   194.688     0.150
    10.694   377.586     0.150
    10.694   156.188     0.150
    10.877   197.586     0.150
    10.877   310.383     0.150
    10.877   161.188     0.150
    10.877   284.289     0.150
    11.066   273.852     0.150
    10.970   200.008     0.150
    10.970   282.242     0.150
    10.970   342.586     0.150
    11.083   313.586     0.150
    12.478   190.383     0.150
    13.629   347.586     0.150
    13.470   359.984     0.150
    14.997   223.586     0.150
    14.997   450.984     0.150
    15.145   215.484     0.150
    16.097   220.758     0.150
    16.097   222.977     0.150
    16.097   497.633     0.150
    15.995   412.688     0.150
    15.995   423.586     0.150
    16.265   421.383     0.150
    16.345   232.188     0.150
    17.738   246.688     0.150
    17.618   463.188     0.150
    18.676   254.484     0.150
    18.676   453.438     0.150
    18.676   253.719     0.150
    18.676   253.688     0.150
    18.851   262.242     0.150
    18.851   263.789     0.150
    19.036   266.383     0.150
    19.036   507.188     0.150
    19.775   275.086     0.150
    19.775   275.109     0.150
    19.937   635.859     0.150
    20.085   277.383     0.150
    20.118   508.984     0.150
    20.590   283.688     0.150
    22.065     4.195     0.150
    22.314   303.586     0.150
    22.314     9.602     0.150
    22.903   308.688     0.150
    22.903   308.758     0.150
    23.094   307.383     0.150
    23.654   313.289     0.150
    23.661   313.086     0.150
    23.746   314.188     0.150
    23.910   314.688     0.150
    25.386     3.195     0.150
    25.386     7.297     0.150
    25.386   592.688     0.150
    25.875     4.000     0.150
    26.987   347.055     0.150
    27.133   344.969     0.150
    27.478   347.789     0.150
    27.604   350.766     0.150
    27.824   354.742     0.150
    27.850   354.742     0.150
    28.920   364.289     0.150
    28.904   365.484     0.150
    28.904   365.562     0.150
    29.059   365.148     0.150
    30.674   376.883     0.150
    30.674   380.156     0.150
    31.979   385.688     0.150
    31.979   693.289     0.150
    32.576   392.188     0.150
    32.576   392.883     0.150
    33.472   404.164     0.150
    33.595   404.609     0.150
    35.964   423.484     0.150
    37.697   440.484     0.150
    37.838   439.883     0.150
    41.522   466.906     0.150
    42.343   859.188     0.150
    42.639   475.484     0.150
    42.905   477.688     0.150
    42.905   477.688     0.150
    43.055   478.883     0.150
    43.185   482.188     0.150
    44.034   484.484     0.150
    44.921   493.883     0.150
    45.378   495.383     0.150
    45.659   499.688     0.150
    47.282   520.742     0.150
    47.527   516.805     0.150
    47.527   516.805     0.150
    47.527   630.539     0.150
    47.527   674.766     0.150
    47.527   932.266     0.150
    47.527  1142.859     0.150
    47.527  1206.445     0.150
    47.527   516.789     0.150
    47.527   630.484     0.150
    47.527   674.688     0.150
    47.527   932.188     0.150
    47.527  1206.383     0.150
    49.101   692.086     0.150
    49.101  1165.586     0.150
    49.101  1243.383     0.150
    49.450   532.484     0.150
    51.627   548.086     0.150
    53.479   562.484     0.150
    53.505   566.188     0.150
    53.597   560.789     0.150
    53.843   565.688     0.150
    53.880   565.398     0.150
    54.027   567.984     0.150
    54.075   571.492     0.150
    54.075   571.484     0.150
    54.238   568.648     0.150
    54.410   566.484     0.150
    54.738   568.719     0.150
    54.660   578.523     0.150
    54.660   568.586     0.150
    54.660   568.586     0.150
    54.676   578.406     0.150
    54.676   568.688     0.150
    54.779   579.305     0.150
    54.976   574.445     0.150
    55.090   571.383     0.150
    55.039   573.688     0.150
    55.144   576.188     0.150
    55.144   572.086     0.150
    55.248   575.898     0.150
    55.337   578.789     0.150
    55.394   582.211     0.150
    55.372   573.984     0.150
    55.446   577.188     0.150
    55.446   573.984     0.150
    55.460   577.047     0.150
    55.460   576.984     0.150
    55.700   580.227     0.150
    55.743   578.555     0.150
    56.049   580.898     0.150
    56.051   586.484     0.150
    56.051   581.188     0.150
    56.105   583.586     0.150
    56.105   579.086     0.150
    56.105   780.086     0.150
    56.105  1045.086     0.150
    56.105  1411.086     0.150
    56.113   581.188     0.150
    56.113   581.180     0.150
    56.113   582.383     0.150
    56.254   582.383     0.150
    56.384   584.297     0.150
    56.472   584.594     0.150
    56.472   587.289     0.150
    56.520   586.664     0.150
    56.630   585.984     0.150
    57.177   589.398     0.150
    57.177   589.383     0.150
    57.462   590.789     0.150
    57.700   592.086     0.150
    57.700   593.234     0.150
    59.418   604.586     0.150
    59.418   604.539     0.150
    60.159   614.055     0.150
    60.931   614.188     0.150
    63.068   628.086     0.150
    62.912   627.789     0.150
    64.320   634.984     0.150
    83.815   659.633     0.150
    69.147   667.062     0.150
    70.202   673.539     0.150
    70.202   673.539     0.150
    73.538   694.648     0.150
    59.758   694.609     0.150
    73.905   697.766     0.150
    73.937   696.586     0.150
    32.211   700.023     0.150
    74.783   699.883     0.150
   108.657   708.883     0.150
    71.618   709.484     0.150
    77.458   715.289     0.150
    77.252   718.289     0.150
    81.170   738.188     0.150
    80.845   737.242     0.150
    81.653   740.086     0.150
    82.826   743.688     0.150
    83.635   748.789     0.150
    14.747   750.477     0.150
    85.384   759.383     0.150
    85.384   760.477     0.150
   149.821  1189.789     0.150
     1.129    40.457     0.150
     2.435    40.758     0.150
     1.402    28.648     0.150
     1.402    49.047     0.150
     2.284    68.949     0.150
     0.894    17.283     0.150
     0.894    17.283     0.150
     0.894    17.283     0.150
     0.894    28.184     0.150
     1.793    32.283     0.150
     1.682    31.482     0.150
     1.784    34.783     0.150
     1.784    41.283     0.150
     1.784    58.883     0.150
     1.784    33.184     0.150
     1.784    34.883     0.150
     1.784    59.084     0.150
     2.862    52.783     0.150
     3.094    49.084     0.150
     3.094    94.783     0.150
     4.162    65.184     0.150
     4.996   157.482     0.150
     5.104   160.283     0.150
     5.495    86.684     0.150
     5.508   173.684     0.150
     6.356   198.883     0.150
     6.735   210.283     0.150
     6.808   125.383     0.150
     6.808   105.482     0.150
     6.791   105.883     0.150
     6.791   123.982     0.150
     6.791   123.584     0.150
     6.791   210.584     0.150
     6.856   125.783     0.150
     7.366   226.084     0.150
     7.548   235.684     0.150
     7.680   239.383     0.150
     7.840   172.084     0.150
     7.864   143.982     0.150
     8.026   249.783     0.150
     8.292   206.652     0.150
     8.162   254.084     0.150
    11.124   163.582     0.150
    11.124   286.014     0.150
    14.592   451.158     0.150
    16.277   224.127     0.150
    16.277   393.727     0.150
    16.277   223.883     0.150
    19.199   260.684     0.150
    24.202   318.783     0.150
    76.835   711.227     0.150
     2.430    42.844     0.150
     1.120    23.495     0.150
     1.120    21.095     0.150
     2.218    69.794     0.150
     2.517    45.895     0.150
     3.661    71.195     0.150
     3.661    58.695     0.150
     3.975    66.895     0.150
     5.167    81.294     0.150
     6.072    88.995     0.150
     6.398    96.695     0.150
     6.398   198.995     0.150
     6.628   121.695     0.150
     7.167   130.294     0.150
     7.167   235.495     0.150
     7.353   206.395     0.150
     7.387   133.695     0.150
     7.496   136.995     0.150
     7.496   234.395     0.150
     7.702   140.794     0.150
     8.405   119.794     0.150
    11.068   274.546     0.150
    16.105   223.196     0.150
    16.105   391.888     0.150
    16.105   499.239     0.150
    16.105   223.095     0.150
    43.891   484.415     0.150
    47.526   516.325     0.150
    47.526   516.325     0.150
    47.526   672.285     0.150
    47.526  1208.955     0.150
    47.526   516.294     0.150
    47.526   624.995     0.150
    47.526   672.195     0.150
    47.526   932.495     0.150
    47.526  1136.095     0.150
    47.526  1208.895     0.150
     0.658    12.340     0.150
     0.658    12.242     0.150
     1.122    22.840     0.150
     1.122    26.242     0.150
     1.122    39.641     0.150
     1.122    43.242     0.150
     1.122    20.340     0.150
     1.122    35.242     0.150
     1.395    43.840     0.150
     2.212    71.543     0.150
     2.298    38.742     0.150
     2.298    41.340     0.150
     2.321    42.340     0.150
     2.321    42.340     0.150
     2.513    45.141     0.150
     2.440    46.941     0.150
     2.440    49.641     0.150
     2.440    43.840     0.150
     4.012    62.641     0.150
     3.982    62.441     0.150
     4.951   154.840     0.150
     5.175   161.141     0.150
     5.175   160.641     0.150
     6.018   187.340     0.150
     6.406   199.141     0.150
     6.406    95.840     0.150
     6.406   115.840     0.150
     6.406   198.441     0.150
     6.404   199.641     0.150
     6.492   118.141     0.150
     6.492   202.340     0.150
     6.637   207.043     0.150
     7.177   130.543     0.150
     7.177   222.840     0.150
     7.365   133.043     0.150
     7.365   228.242     0.150
     7.397   230.441     0.150
     7.504   233.543     0.150
     7.504   135.141     0.150
     7.504   232.340     0.150
     7.711   240.141     0.150
     7.763   240.641     0.150
     7.832   243.043     0.150
     7.886   143.441     0.150
     7.886   245.641     0.150
     8.393   119.441     0.150
     8.230   256.340     0.150
     9.488   145.961     0.150
    11.071   332.461     0.150
    10.970   164.516     0.150
    16.093   221.609     0.150
    18.554   571.992     0.150
    18.671   262.742     0.150
    18.847   265.391     0.150
    23.743   316.715     0.150
    47.522   513.832     0.150
    47.522   513.832     0.150
    47.522   672.961     0.150
    47.522  1202.480     0.150
    47.522   513.742     0.150
    47.522   624.141     0.150
    47.522   672.941     0.150
    47.522   928.340     0.150
    47.522  1138.340     0.150
    47.522  1202.441     0.150
     2.435    47.633     0.150
     3.638    95.934     0.150
     1.132    22.711     0.150
     1.390    28.516     0.150
     1.390    48.414     0.150
     2.204    67.609     0.150
     3.988    64.312     0.150
     5.180    80.711     0.150
     8.392   117.805     0.150
     1.118    23.445     0.150
     1.118    39.945     0.150
     2.294    68.742     0.150
     2.315    43.641     0.150
     0.663    12.883     0.150
     1.133    23.281     0.150
     1.133    43.281     0.150
     1.133    20.984     0.150
     1.391    44.383     0.150
     1.391    47.883     0.150
     2.283    39.383     0.150
     2.527    45.586     0.150
     3.674    58.586     0.150
     4.947   155.484     0.150
     5.179   161.180     0.150
     6.022   187.484     0.150
     6.411   200.086     0.150
     6.411   116.984     0.150
     6.411   200.484     0.150
     6.408   116.984     0.150
     6.408   200.086     0.150
     6.497   202.680     0.150
     6.641   206.383     0.150
     6.880   125.406     0.150
     7.165   222.984     0.150
     7.399   133.484     0.150
     7.399   230.484     0.150
     7.360   228.586     0.150
     7.509   234.086     0.150
     7.509   136.984     0.150
     7.509   234.180     0.150
     7.715   239.484     0.150
     7.766   241.484     0.150
     7.889   142.883     0.150
     7.889   245.883     0.150
     8.395   119.320     0.150
     8.395   147.250     0.150
     8.395   213.727     0.150
     8.395   253.430     0.150
     8.395   216.484     0.150
     8.234   255.383     0.150
     9.492   140.461     0.150
    10.693   158.477     0.150
    10.881   173.180     0.150
    10.881   286.781     0.150
    11.057   273.727     0.150
    10.969   162.133     0.150
    10.969   162.180     0.150
    13.913   204.883     0.150
    15.136   220.180     0.150
    15.136   220.180     0.150
    16.102   221.602     0.150
    16.102   221.602     0.150
    16.102   221.586     0.150
    17.735   246.055     0.150
    20.076   280.672     0.150
    20.076   280.680     0.150
    23.762   316.727     0.150
    23.751   316.180     0.150
    23.751   316.586     0.150
    23.915   316.484     0.150
    24.130   320.164     0.150
    24.130   320.180     0.150
    24.825   321.984     0.150
    27.140   346.234     0.150
    28.640   359.781     0.150
    30.680   376.984     0.150
    32.581   394.086     0.150
    34.461   409.586     0.150
    39.429   453.383     0.150
    43.900   487.883     0.150
    46.131   504.102     0.150
    57.541   589.883     0.150
    77.244   717.719     0.150
    77.244   718.086     0.150
    80.837   737.844     0.150
    80.837   737.844     0.150
    80.837   737.883     0.150
   146.070  1182.023     0.150
     1.140    23.492     0.150
     1.140    40.195     0.150
     1.140    43.891     0.150
     2.257    83.594     0.150
     2.330    76.391     0.150
     0.654    12.751     0.150
     1.111    25.251     0.150
     1.111    20.650     0.150
     1.399    48.951     0.150
     2.312    42.650     0.150
     2.499    45.351     0.150
     6.400   118.051     0.150
     6.400   200.150     0.150
     6.487   117.751     0.150
     8.392   217.251     0.150
     8.847   160.251     0.150
     8.847   275.451     0.150
    23.735   318.251     0.150
    47.508   514.190     0.150
    47.508   514.190     0.150
    47.508  1204.281     0.150
    47.508   514.150     0.150
    47.508   624.051     0.150
    47.508   927.951     0.150
    47.508  1138.750     0.150
    47.508  1204.250     0.150
     1.109    25.125     0.150
     1.413    49.328     0.150
     1.110    26.109     0.150
     1.414    49.305     0.150
     1.406    25.136     0.150
     1.406    48.936     0.150
     0.466     8.922     0.150
     0.466    15.223     0.150
     1.227    23.523     0.150
     1.227    24.723     0.150
     1.227    23.523     0.150
     1.596    29.223     0.150
     2.093    37.422     0.150
     2.093    39.422     0.150
     2.093    62.723     0.150
     2.093    66.723     0.150
     2.093    37.422     0.150
     2.093    62.723     0.150
     2.722    94.324     0.150
     2.722    44.824     0.150
     2.722    48.824     0.150
     2.938    54.324     0.150
     2.938    92.324     0.150
     3.275    61.922     0.150
     3.275    52.824     0.150
     3.275    59.723     0.150
     3.880    61.324     0.150
     3.880   105.125     0.150
     5.344   166.324     0.150
     5.704   177.023     0.150
     5.704    86.523     0.150
     5.704   147.523     0.150
     5.801   180.723     0.150
     5.970   148.422     0.150
     5.970   185.922     0.150
     6.755   122.223     0.150
     6.755   209.824     0.150
     6.814   211.625     0.150
     6.814   102.723     0.150
     6.814   174.125     0.150
     6.991   126.324     0.150
     6.980   126.824     0.150
     6.980   217.422     0.150
     6.980   101.625     0.150
     6.980   181.523     0.150
     8.950   230.312     0.150
     8.950   127.043     0.150
     8.950   230.316     0.150
     8.950   269.441     0.150
     8.950   127.023     0.150
     8.950   230.324     0.150
     8.909   132.824     0.150
    10.421   148.047     0.150
    10.421   321.543     0.150
    11.634   296.492     0.150
    11.634   360.668     0.150
    16.346   225.762     0.150
    16.346   224.516     0.150
    16.346   399.566     0.150
    16.346   225.723     0.150
    16.346   399.523     0.150
    19.981   273.984     0.150
    22.940   306.625     0.150
    23.016   305.812     0.150
    43.162   478.293     0.150
    74.921   699.832     0.150
    80.960   735.125     0.150
     1.139    27.055     0.150
     1.139    40.355     0.150
     1.139    43.652     0.150
     1.139    21.055     0.150
     1.391    25.953     0.150
     1.391    44.652     0.150
     2.201    38.453     0.150
     2.201    69.355     0.150
     2.275    39.355     0.150
     2.275    42.355     0.150
     2.334    45.953     0.150
     2.334    39.953     0.150
     2.334    42.953     0.150
     2.334    73.754     0.150
     3.355    54.652     0.150
     3.355   106.453     0.150
     3.678    58.652     0.150
     3.678   115.555     0.150
     4.002    63.652     0.150
     4.002    73.555     0.150
     4.002   125.254     0.150
     3.990    62.855     0.150
     3.990    65.555     0.150
     3.990    62.855     0.150
     3.990   125.453     0.150
     4.619    75.055     0.150
     4.619    88.254     0.150
     4.619    84.152     0.150
     4.619   124.652     0.150
     4.619   145.152     0.150
     4.943   155.855     0.150
     4.943    75.754     0.150
     4.943   155.855     0.150
     5.179    81.355     0.150
     5.179   162.754     0.150
     5.179    79.152     0.150
     5.179   136.652     0.150
     6.053    95.152     0.150
     6.053   113.453     0.150
     6.053   193.152     0.150
     6.022   111.055     0.150
     6.022   189.355     0.150
     6.412   201.254     0.150
     6.412    98.555     0.150
     6.412   118.453     0.150
     6.412   200.855     0.150
     6.408   200.453     0.150
     6.497   119.055     0.150
     6.497   203.453     0.150
     6.641   206.855     0.150
     6.872   126.008     0.150
     6.872   176.605     0.150
     7.157   130.453     0.150
     7.157   223.254     0.150
     7.157   104.055     0.150
     7.356   133.855     0.150
     7.356   228.953     0.150
     7.356   107.652     0.150
     7.356   189.152     0.150
     7.399   134.652     0.150
     7.399   230.055     0.150
     7.510   140.652     0.150
     7.510   233.652     0.150
     7.510   235.152     0.150
     7.767   141.855     0.150
     7.767   242.254     0.150
     7.767   116.055     0.150
     7.889   143.254     0.150
     7.889   246.652     0.150
     8.397   119.926     0.150
     8.397   120.363     0.150
     8.397   120.773     0.150
     8.397   149.398     0.150
     8.397   212.922     0.150
     8.397   120.152     0.150
     8.388   153.152     0.150
     8.388   262.055     0.150
     8.388   123.652     0.150
     8.781   160.055     0.150
     8.781   128.555     0.150
     8.781   274.152     0.150
     8.858   161.152     0.150
     8.858   161.152     0.150
     8.858   276.652     0.150
     9.032   165.055     0.150
     9.493   170.848     0.150
     9.493   238.695     0.150
     9.493   291.422     0.150
     9.493   137.684     0.150
     9.493   238.695     0.150
     9.493   172.754     0.150
     9.493   137.754     0.150
     9.994   184.855     0.150
     9.994   147.254     0.150
    10.466   190.254     0.150
    10.883   196.953     0.150
    10.967   199.332     0.150
    10.967   341.035     0.150
    10.967   159.355     0.150
    11.090   182.453     0.150
    11.090   160.453     0.150
    13.904   357.152     0.150
    14.724   203.055     0.150
    15.128   471.402     0.150
    15.128   216.855     0.150
    15.729   401.355     0.150
    16.108   219.992     0.150
    16.108   221.945     0.150
    16.108   493.223     0.150
    16.108   224.152     0.150
    16.332   234.754     0.150
    16.332   231.855     0.150
    17.734   543.621     0.150
    17.734   246.652     0.150
    17.734   243.934     0.150
    17.734   252.715     0.150
    18.553   575.754     0.150
    18.694   255.152     0.150
    18.694   454.527     0.150
    18.694   581.828     0.150
    18.694   254.535     0.150
    18.936   268.652     0.150
    19.039   266.773     0.150
    19.023   266.855     0.150
    19.759   274.164     0.150
    20.027   278.754     0.150
    20.068   274.953     0.150
    20.587   281.055     0.150
    20.976   283.355     0.150
    20.976   290.164     0.150
    20.976   283.355     0.150
    21.629   298.254     0.150
    21.629   318.055     0.150
    21.629   572.953     0.150
    21.863   577.152     0.150
    22.307     6.203     0.150
    22.471   709.406     0.150
    23.086   309.652     0.150
    23.099   309.855     0.150
    23.646   314.754     0.150
    23.918   314.953     0.150
    24.123   318.652     0.150
    25.320   601.152     0.150
    25.384     3.203     0.150
    25.384     7.500     0.150
    25.862     4.000     0.150
    26.995   345.266     0.150
    27.219   625.652     0.150
    27.485   349.242     0.150
    27.831   352.965     0.150
    27.858   353.016     0.150
    28.253   356.426     0.150
    28.843   361.773     0.150
    29.067   363.785     0.150
    29.480   369.453     0.150
    30.683   377.453     0.150
    31.994   387.754     0.150
    32.585   393.453     0.150
    32.585   393.254     0.150
    33.009   400.473     0.150
    33.481   402.465     0.150
    35.342   422.633     0.150
   161.126   427.453     0.150
    44.726   428.766     0.150
    44.726   429.453     0.150
    47.799   438.445     0.150
    37.818   446.555     0.150
    37.686   441.055     0.150
    37.686   787.254     0.150
    38.012   434.855     0.150
    37.844   441.254     0.150
    39.111   449.254     0.150
    39.431   452.855     0.150
    39.678   454.855     0.150
    64.547   456.754     0.150
    40.006   457.953     0.150
    40.347   460.754     0.150
    41.010   467.242     0.150
    41.419   468.152     0.150
    41.877   473.992     0.150
    42.359   480.152     0.150
    42.359   603.652     0.150
    42.359   854.055     0.150
    42.909   480.652     0.150
    43.189   482.953     0.150
    43.214   490.254     0.150
    43.214   871.953     0.150
    43.214   482.555     0.150
    43.410   484.652     0.150
    44.353   492.453     0.150
    65.928   493.883     0.150
    44.924   498.254     0.150
    45.357   498.152     0.150
    45.391   491.754     0.150
   119.298   508.355     0.150
    46.280   656.652     0.150
    47.296   520.254     0.150
    47.339   513.953     0.150
    47.460   514.355     0.150
    47.544   517.652     0.150
    47.544   517.652     0.150
    47.544   624.035     0.150
    47.544   677.293     0.150
    47.544   517.652     0.150
    47.544   603.355     0.150
    47.544   623.953     0.150
    47.544   677.254     0.150
    47.544   933.453     0.150
    48.832   533.094     0.150
    49.116   525.355     0.150
    49.116   691.953     0.150
    49.116   948.453     0.150
    49.116  1243.355     0.150
    49.454   531.754     0.150
    49.466   534.570     0.150
    49.466   534.555     0.150
    49.592   532.754     0.150
    49.592   532.754     0.150
    49.895   536.055     0.150
    50.298   543.812     0.150
    51.049   548.754     0.150
    51.644   550.953     0.150
    53.321   564.254     0.150
    53.495   563.453     0.150
    53.521   563.953     0.150
    53.859   567.953     0.150
    53.896   569.055     0.150
    53.896   565.887     0.150
    53.896   569.035     0.150
    54.042   568.555     0.150
    54.091   568.652     0.150
    54.254   569.254     0.150
    54.245   571.254     0.150
    54.313   571.355     0.150
    54.427   571.355     0.150
    54.620   577.020     0.150
    54.745   571.734     0.150
    54.745   571.754     0.150
    54.676   573.152     0.150
    54.692   573.754     0.150
    54.613   573.508     0.150
    54.609   575.953     0.150
    54.993   578.355     0.150
    54.993   574.773     0.150
    54.993   578.324     0.150
    55.032   574.422     0.150
    55.032   577.762     0.150
    55.062   576.855     0.150
    55.062   576.855     0.150
    55.107   574.855     0.150
    55.265   576.254     0.150
    55.354   578.953     0.150
    55.369   576.652     0.150
    55.372   578.254     0.150
    55.398   577.055     0.150
    55.387   577.023     0.150
    55.463   577.754     0.150
    55.473   577.055     0.150
    55.717   580.055     0.150
    55.542   580.055     0.150
    55.542   580.055     0.150
    55.760   583.152     0.150
    55.760   580.086     0.150
    55.760   583.113     0.150
    56.066   584.785     0.150
    56.066   588.695     0.150
    56.068   581.754     0.150
    56.122   581.094     0.150
    56.122   581.152     0.150
    56.122  1051.754     0.150
    56.122  1282.754     0.150
    56.130   582.855     0.150
    56.270   583.754     0.150
    56.365   587.855     0.150
    56.365   584.465     0.150
    56.365   587.809     0.150
    56.433   582.652     0.150
    56.236   587.355     0.150
    56.489   584.855     0.150
    56.502   589.055     0.150
    56.502   589.059     0.150
    56.537   588.855     0.150
    56.537   585.141     0.150
    56.537   588.895     0.150
    56.613   588.355     0.150
    56.646   586.055     0.150
    56.628   584.652     0.150
    56.916   589.152     0.150
    57.171   589.453     0.150
    57.376   590.453     0.150
    57.479   592.754     0.150
    57.549   591.754     0.150
    57.434   595.953     0.150
    57.600   597.152     0.150
    58.094   595.953     0.150
    58.043   595.754     0.150
    58.724   601.555     0.150
    59.441   609.133     0.150
    60.386   609.484     0.150
    60.458   615.504     0.150
    60.722   614.703     0.150
    60.770   613.062     0.150
    60.941   615.055     0.150
    63.074   628.754     0.150
    63.655   632.652     0.150
    64.688   639.152     0.150
    64.688   643.055     0.150
    70.347   676.652     0.150
    72.174   687.055     0.150
    74.787   702.152     0.150
    74.943   707.023     0.150
    71.624   710.855     0.150
    77.464   717.355     0.150
    77.229   716.266     0.150
    82.524   747.375     0.150
    82.835   745.855     0.150
    82.835   745.855     0.150
    83.644   750.355     0.150
    85.393   759.055     0.150
    85.640   761.355     0.150
   144.379   764.562     0.150
    87.183   770.277     0.150
    87.942   773.555     0.150
    88.817   775.855     0.150
    88.879   777.254     0.150
    89.467   779.754     0.150
    90.156   781.430     0.150
    95.068   808.152     0.150
   130.087  1149.953     0.150
   139.808  1171.676     0.150
   152.069  1199.254     0.150
     1.110    39.695     0.150
     1.124    22.824     0.150
     1.391    48.422     0.150
     2.325    43.023     0.150
     4.956   155.324     0.150
     4.956   166.121     0.150
     5.180   161.922     0.150
     6.022   187.922     0.150
     6.410   199.324     0.150
     6.408   199.422     0.150
     6.496   202.922     0.150
     6.642   207.621     0.150
     6.895    98.602     0.150
     6.895   122.371     0.150
     7.370   133.922     0.150
     7.370   230.223     0.150
    10.975   347.961     0.150
     1.122    22.902     0.150
     1.396    48.805     0.150
     7.364   134.102     0.150
     8.394   253.047     0.150
    10.969   347.312     0.150
     2.260    81.344     0.150
     7.324   133.141     0.150
     1.441    49.494     0.150
     2.295    38.094     0.150
     1.401    30.070     0.150
     2.300    88.070     0.150
     1.141    21.266     0.150
     1.141    21.266     0.150
     1.141    36.766     0.150
     1.387    31.266     0.150
     1.387    25.863     0.150
     1.387    44.465     0.150
     2.198    40.066     0.150
     2.276    39.465     0.150
     2.337    43.266     0.150
     2.337    74.066     0.150
     2.536    84.566     0.150
     2.536    42.164     0.150
     3.358    61.164     0.150
     3.358    93.266     0.150
     3.681    58.965     0.150
     3.681   115.164     0.150
     3.998    63.266     0.150
     3.998    72.766     0.150
     3.993    78.363     0.150
     3.993   124.766     0.150
     4.622    85.965     0.150
     4.622    72.266     0.150
     4.622   143.766     0.150
     4.947    76.066     0.150
     4.947   155.066     0.150
     5.183    79.766     0.150
     5.183   161.465     0.150
     6.026   110.566     0.150
     6.412   122.465     0.150
     6.416   117.465     0.150
     6.416    96.766     0.150
     6.416   200.266     0.150
     6.874   125.039     0.150
     7.159   103.863     0.150
     7.159   259.066     0.150
     7.159   103.766     0.150
     7.360   108.266     0.150
     7.360   229.566     0.150
     7.513   137.066     0.150
     7.513   136.766     0.150
     7.513   234.363     0.150
     7.893   144.066     0.150
     8.393   119.996     0.150
     8.393   120.734     0.150
     8.393   216.309     0.150
     8.393   120.766     0.150
     8.393   239.566     0.150
     8.389   220.766     0.150
     8.785   129.566     0.150
     8.785   273.566     0.150
     8.862   160.164     0.150
     8.862   275.766     0.150
    10.470   155.566     0.150
    10.886   322.363     0.150
    10.971   284.324     0.150
    11.093   310.266     0.150
    11.093   161.363     0.150
    12.408   183.363     0.150
    12.468   188.863     0.150
    16.104   222.055     0.150
    16.104   221.484     0.150
    16.104   222.965     0.150
    17.730   543.059     0.150
    18.693   255.266     0.150
    18.693   449.715     0.150
    18.693   254.703     0.150
    18.865   262.664     0.150
    19.760   273.543     0.150
    19.760   274.824     0.150
    20.069   276.766     0.150
    22.311   303.266     0.150
    22.311     4.699     0.150
    22.761   311.266     0.150
    23.083   307.465     0.150
    23.757   316.965     0.150
    23.770   742.766     0.150
    23.921   313.664     0.150
    27.148   345.684     0.150
    27.489   346.086     0.150
    31.996   389.684     0.150
    31.996   389.684     0.150
    32.404   392.816     0.150
    32.588   393.566     0.150
    32.588   393.965     0.150
    34.330   408.465     0.150
    34.467   409.863     0.150
   161.122   424.055     0.150
    44.722   426.746     0.150
    38.249   439.727     0.150
    39.435   451.266     0.150
    43.215   615.465     0.150
    43.215   862.566     0.150
    43.908   487.586     0.150
    49.462   953.664     0.150
    49.467   531.566     0.150
    53.897   565.320     0.150
    54.283   566.566     0.150
    54.742   570.844     0.150
    54.993   574.113     0.150
    55.265   576.074     0.150
    55.369   576.516     0.150
    55.463   576.965     0.150
    55.473   576.066     0.150
    55.717   579.504     0.150
    55.760   578.992     0.150
    56.066   580.625     0.150
    56.122   588.066     0.150
    56.122   580.465     0.150
    56.401   584.125     0.150
    56.615   585.176     0.150
    56.647   585.664     0.150
    57.479   592.465     0.150
    57.549   591.164     0.150
    57.833   594.164     0.150
    59.819   607.676     0.150
    60.770   611.465     0.150
    60.902   614.164     0.150
    60.944   614.164     0.150
    63.655   632.656     0.150
    65.884   647.266     0.150
    70.752   678.266     0.150
    59.774   693.816     0.150
    73.940   695.863     0.150
    74.783   701.566     0.150
    71.620   710.566     0.150
    77.238   717.965     0.150
    83.641   750.066     0.150
    85.390   758.066     0.150
     1.143    40.488     0.150
     1.381    48.086     0.150
     7.367   133.789     0.150
     1.129    22.906     0.150
     1.129    20.906     0.150
     1.129    35.703     0.150
     1.391    30.008     0.150
     1.391    48.906     0.150
     1.391    25.805     0.150
     1.391    44.508     0.150
     2.206    39.906     0.150
     2.291    40.008     0.150
     2.328    44.906     0.150
     2.328    42.906     0.150
     2.328    74.008     0.150
     2.521    42.203     0.150
     2.521    78.305     0.150
     3.672    58.406     0.150
     3.672   115.305     0.150
     3.987    63.203     0.150
     3.987   125.008     0.150
     4.006    63.805     0.150
     4.006   108.102     0.150
     4.613    71.906     0.150
     4.613   144.508     0.150
     5.180   161.805     0.150
     6.411    96.906     0.150
     6.642   121.406     0.150
     6.888   126.430     0.150
     7.173   130.602     0.150
     7.365   134.305     0.150
     7.365   132.906     0.150
     7.365   228.102     0.150
     7.401   135.305     0.150
     8.857   158.906     0.150
     8.857   273.102     0.150
    11.063   275.375     0.150
    16.095   222.297     0.150
    77.252   716.766     0.150
    77.252   716.805     0.150
     1.381    47.984     0.150
     3.998    75.984     0.150
     7.366   133.984     0.150
     1.099    40.281     0.150
     2.244    42.684     0.150
     2.244    73.883     0.150
     2.291    40.980     0.150
     2.291    70.781     0.150
     3.635    70.480     0.150
     0.689    12.305     0.150
     1.105    20.508     0.150
     1.425    49.105     0.150
     1.425    27.008     0.150
     1.425    45.605     0.150
     2.291    40.707     0.150
     2.291    70.207     0.150
     3.643    64.508     0.150
     3.643    72.508     0.150
     3.955    75.305     0.150
     3.955   110.707     0.150
     4.037   130.305     0.150
     4.037    64.305     0.150
     4.584    87.707     0.150
     4.584    72.406     0.150
     4.921   155.207     0.150
     5.146   165.305     0.150
     5.146    79.305     0.150
     7.334   134.508     0.150
     7.334   134.508     0.150
     7.367   133.508     0.150
     7.681   140.105     0.150
     7.856    97.305     0.150
     7.856   142.508     0.150
     8.425   218.707     0.150
    11.055   306.906     0.150
    16.121   222.125     0.150
    18.828   263.406     0.150
     1.098    39.911     0.150
     1.431    50.111     0.150
     3.636    56.911     0.150
     4.044    67.211     0.150
     1.153    41.062     0.150
     2.349    37.963     0.150
     5.193    79.062     0.150
     2.198    36.654     0.150
     0.705    13.479     0.150
     1.118    40.180     0.150
     1.118    20.880     0.150
     1.427    30.079     0.150
     1.427    49.779     0.150
     1.427    26.779     0.150
     1.427    45.979     0.150
     2.267    40.279     0.150
     2.307    40.479     0.150
     2.307    72.979     0.150
     2.532    42.380     0.150
     3.329    61.180     0.150
     3.329   104.579     0.150
     3.650    60.479     0.150
     3.650    58.680     0.150
     3.650    99.880     0.150
     3.956    62.979     0.150
     3.956   124.479     0.150
     4.591    71.779     0.150
     4.591   143.779     0.150
     5.143   161.979     0.150
     5.986   112.079     0.150
     6.372   117.180     0.150
     6.849   125.680     0.150
     7.134   100.999     0.150
     7.134   260.779     0.150
     7.134   104.180     0.150
     7.318   133.880     0.150
     7.318   109.380     0.150
     7.318   228.579     0.150
     7.361   134.479     0.150
     7.474   138.380     0.150
     7.474   137.680     0.150
     7.474   234.180     0.150
     7.851   143.479     0.150
     8.745   128.279     0.150
     8.745   271.880     0.150
     8.823   160.979     0.150
     8.823   273.979     0.150
     8.996   132.279     0.150
     8.996   280.680     0.150
     9.458   172.723     0.150
     9.458   171.279     0.150
     9.458   138.380     0.150
     9.960   184.579     0.150
     9.960   147.079     0.150
    10.430   192.180     0.150
    10.928   199.199     0.150
    10.928   158.579     0.150
    11.058   311.680     0.150
    11.058   162.180     0.150
    11.056   275.622     0.150
    13.438   197.779     0.150
    15.125   216.079     0.150
    15.950     9.200     0.150
    15.950   409.479     0.150
    16.141   223.960     0.150
    16.141   224.072     0.150
    16.222   415.479     0.150
    17.579   452.979     0.150
    18.703   255.229     0.150
    18.703   456.180     0.150
    18.703   254.659     0.150
    18.703   254.680     0.150
    18.840   261.979     0.150
    18.992   267.979     0.150
    19.742   273.279     0.150
    20.548   281.479     0.150
    22.021   302.279     0.150
    22.269   299.479     0.150
    22.269     4.500     0.150
    23.042     7.500     0.150
    23.129   308.880     0.150
    23.888   315.079     0.150
    27.127   345.640     0.150
    31.983   558.779     0.150
    32.557   393.380     0.150
    32.557   393.779     0.150
    34.434   410.279     0.150
    44.765   427.060     0.150
    39.399   451.779     0.150
    42.353   479.880     0.150
    43.907   490.779     0.150
    43.910   488.560     0.150
    44.343   491.079     0.150
    46.173   507.680     0.150
    47.540   518.229     0.150
    47.540   518.229     0.150
    47.540   673.829     0.150
    47.540  1143.399     0.150
    47.540  1206.140     0.150
    47.540   518.180     0.150
    47.540   629.180     0.150
    47.540   673.779     0.150
    47.540   932.180     0.150
    47.540  1206.079     0.150
    49.460   530.479     0.150
    49.598   534.779     0.150
    51.636   547.680     0.150
    53.891   566.830     0.150
    54.783   572.380     0.150
    54.989   573.880     0.150
    54.989   573.924     0.150
    55.028   575.566     0.150
    55.038   574.180     0.150
    55.105   573.479     0.150
    55.461   578.079     0.150
    55.756   580.742     0.150
    56.122   580.979     0.150
    56.122   583.180     0.150
    56.362   585.388     0.150
    56.534   587.618     0.150
    57.477   593.180     0.150
    57.548   592.279     0.150
    57.715   592.409     0.150
    57.715   592.479     0.150
    58.241   597.340     0.150
    59.817   606.399     0.150
    59.977   607.726     0.150
    60.768   613.380     0.150
    62.924   628.279     0.150
    80.580   690.550     0.150
    73.981   697.880     0.150
    74.826   702.779     0.150
   139.253   717.220     0.150
    77.502   718.880     0.150
    77.668   719.180     0.150
    80.809   735.609     0.150
    81.696   741.779     0.150
    82.871   747.079     0.150
    83.680   750.779     0.150
    85.429   759.079     0.150
    87.771   772.479     0.150
   146.035  1179.819     0.150
     3.650    69.133     0.150
     2.269    68.985     0.150
     1.090    39.660     0.150
     7.329   133.559     0.150
     7.361   134.215     0.150
     2.299    47.617     0.150
     2.267    83.130     0.150
     2.531    44.630     0.150
     5.136    88.130     0.150
     2.299    84.180     0.150
     1.122    40.692     0.150
     2.240    40.492     0.150
     2.240    42.792     0.150
     4.045   115.292     0.150
     4.584    68.492     0.150
     7.283   238.292     0.150
     1.152    37.527     0.150
     1.449    28.129     0.150
     2.198    43.727     0.150
     2.593    70.629     0.150
     3.966    62.459     0.150
     1.408    49.469     0.150
     1.118    23.750     0.150
     1.423    49.945     0.150
     2.229    73.547     0.150
     6.856    99.562     0.150
     7.325   133.047     0.150
     8.430   210.617     0.150
    10.934   274.328     0.150
    23.726   312.703     0.150
    27.126   342.062     0.150
     0.690    13.305     0.150
     0.690    22.211     0.150
     1.090    20.609     0.150
     2.249    41.211     0.150
     2.304    40.805     0.150
     2.304    40.711     0.150
     2.285    72.305     0.150
     2.497    47.211     0.150
     2.497    45.305     0.150
     2.497    77.805     0.150
     3.943   123.609     0.150
     4.050    72.711     0.150
     5.136    93.305     0.150
     5.979   158.805     0.150
     6.367   198.805     0.150
     1.436    49.883     0.150
     4.036    60.480     0.150
     5.134    88.480     0.150
     2.520    80.570     0.150
     3.636   117.969     0.150
     5.131   150.875     0.150
     1.102    23.000     0.150
     1.102    24.695     0.150
     1.431    50.000     0.150
     2.289    41.297     0.150
     2.294    41.500     0.150
     2.294    72.102     0.150
     3.638   117.695     0.150
     3.949    62.602     0.150
     5.139    80.000     0.150
     5.139   161.195     0.150
     5.982   190.797     0.150
     6.372   119.398     0.150
     7.849   143.000     0.150
     8.411   208.398     0.150
     8.432   115.398     0.150
     8.432   219.195     0.150
     9.453   289.617     0.150
    10.931   338.016     0.150
    16.127   222.695     0.150
    16.127   223.500     0.150
    18.591   585.500     0.150
    57.694   592.898     0.150
     1.111    40.281     0.150
     1.434    50.281     0.150
     3.949    59.375     0.150
     1.444    50.344     0.150
     1.108    20.697     0.150
     1.431    28.496     0.150
     1.431    50.098     0.150
     2.279    40.098     0.150
     2.279    72.598     0.150
     3.642    58.598     0.150
     3.642    66.297     0.150
     3.950    62.996     0.150
     3.950    72.598     0.150
     1.099    23.033     0.150
     1.099    39.632     0.150
     1.443    50.132     0.150
     7.311   133.132     0.150
     1.435    49.359     0.150
     1.400    49.277     0.150
     2.289    88.379     0.150
     0.700    13.458     0.150
     1.108    20.658     0.150
     1.431    49.958     0.150
     5.140    79.258     0.150
     6.079   194.558     0.150
     6.861   220.226     0.150
    10.929   160.976     0.150
    11.068   275.926     0.150
    49.435   528.533     0.150
    57.702   589.383     0.150
     1.440    29.664     0.150
     1.440    49.764     0.150
     1.102    39.168     0.150
     2.251    65.967     0.150
     2.288    71.768     0.150
     3.936    61.066     0.150
     3.936   102.066     0.150
     1.103    40.141     0.150
     1.439    50.441     0.150
     2.245    64.742     0.150
     2.245    74.141     0.150
     2.292    45.242     0.150
     3.943    75.242     0.150
     2.300    69.697     0.150
     2.300    84.898     0.150
     7.328   133.398     0.150
     0.700    22.338     0.150
     1.441    26.938     0.150
     1.441    45.938     0.150
     2.282    42.637     0.150
     2.297    69.338     0.150
     2.297    40.338     0.150
     2.396    41.438     0.150
     2.501    42.037     0.150
     2.501    77.738     0.150
     3.303    60.738     0.150
     3.626    58.338     0.150
     3.938    62.838     0.150
     4.054    64.238     0.150
     4.054    73.438     0.150
     4.567    71.938     0.150
     4.909   154.537     0.150
     5.129    78.938     0.150
     5.972   112.137     0.150
     6.098   112.738     0.150
     6.098    92.738     0.150
     6.098   112.738     0.150
     6.098   162.637     0.150
     6.098   194.137     0.150
     6.361   117.938     0.150
     6.361    96.338     0.150
     6.361   116.438     0.150
     6.361   198.738     0.150
     7.158   111.047     0.150
     7.158   104.637     0.150
     7.323   108.037     0.150
     7.323   189.238     0.150
     7.323   227.537     0.150
     7.323   108.037     0.150
     7.351   133.938     0.150
     7.459   137.037     0.150
     7.459   111.137     0.150
     7.840   125.738     0.150
     7.840   143.137     0.150
     8.421   209.938     0.150
     8.807   159.137     0.150
     8.807   273.938     0.150
     9.442   237.281     0.150
     9.442   288.006     0.150
    10.417   149.838     0.150
    10.831   311.338     0.150
    10.831   272.838     0.150
    10.924   337.465     0.150
    11.038   305.338     0.150
    11.038   160.238     0.150
    11.087   284.055     0.150
    12.215   179.238     0.150
    15.156   217.537     0.150
    16.128   224.438     0.150
    16.128   223.131     0.150
    16.128   500.006     0.150
    16.128   223.637     0.150
    18.673   254.688     0.150
    18.673   257.338     0.150
    18.812   587.389     0.150
    18.812   260.938     0.150
    23.866   314.537     0.150
    24.152   319.838     0.150
    34.274   407.637     0.150
    34.412   409.277     0.150
    37.792   438.037     0.150
    38.530   447.357     0.150
    39.657   453.137     0.150
    42.551   480.047     0.150
    43.177     5.801     0.150
    43.177   873.938     0.150
    43.177  1098.938     0.150
    43.879   487.148     0.150
    49.416   531.438     0.150
    77.241   718.488     0.150
     1.090    22.814     0.150
     1.090    39.215     0.150
     2.308    68.615     0.150
     2.308    81.516     0.150
     2.298    68.641     0.150
     0.217     4.652     0.150
     0.217     7.355     0.150
     1.452    49.652     0.150
     1.452    26.953     0.150
     1.452    46.355     0.150
     1.853    33.953     0.150
     2.451    72.254     0.150
     2.451    41.652     0.150
     2.451    76.855     0.150
     2.599    43.555     0.150
     2.599    46.855     0.150
     2.698    84.652     0.150
     3.630    65.855     0.150
     3.630    98.453     0.150
     4.039    77.254     0.150
     4.421    80.555     0.150
     5.643    87.652     0.150
     5.911    89.453     0.150
     5.911   106.953     0.150
     5.911   153.453     0.150
     5.911   186.453     0.150
     6.850   105.355     0.150
     7.194   130.953     0.150
     7.482   111.555     0.150
     7.843   142.555     0.150
     7.958   144.652     0.150
     7.900   112.566     0.150
     7.900   238.047     0.150
     7.900   111.555     0.150
     9.941   305.172     0.150
    11.463   355.973     0.150
    15.667   215.773     0.150
    18.562   451.480     0.150
    22.798   295.953     0.150
    22.798     7.402     0.150
    43.269   578.555     0.150
    73.879   694.137     0.150
     4.042    83.320     0.150
     7.326   187.117     0.150
     1.252    25.184     0.150
     1.252    43.785     0.150
     2.477    73.586     0.150
     6.637   120.984     0.150
     7.131   129.309     0.150
     7.670   139.285     0.150
     8.098   244.930     0.150
    11.263   347.824     0.150
    15.799   217.379     0.150
     1.378    47.406     0.150
     1.378    48.945     0.150
     2.352    43.745     0.150
     3.696    72.045     0.150
     4.947   156.345     0.150
     5.192   162.945     0.150
     6.035   187.845     0.150
     6.427   117.645     0.150
     6.427   200.545     0.150
     6.421   201.145     0.150
     6.511   203.245     0.150
     6.653   207.645     0.150
     6.861   126.159     0.150
     7.358   134.345     0.150
     7.358   229.945     0.150
     8.391   218.239     0.150
     1.443    32.465     0.150
     1.443    49.664     0.150
     6.472   222.664     0.150
     0.633    23.504     0.150
     0.633    32.705     0.150
     2.250    86.904     0.150
     2.509    47.604     0.150
     1.395    27.701     0.150
     1.395    48.701     0.150
     2.293    87.701     0.150
     7.172   130.901     0.150
     7.216   131.201     0.150
     7.363   134.201     0.150
     7.505   136.901     0.150
     7.886   144.101     0.150
     8.406   220.001     0.150
    10.969   201.609     0.150
    10.969   282.536     0.150
    11.066   275.995     0.150
    16.097   222.694     0.150
     1.120    22.578     0.150
     1.120    38.578     0.150
     2.286    48.777     0.150
     2.286    81.578     0.150
     7.161   129.578     0.150
     7.492   136.379     0.150
     7.873   124.078     0.150
     7.873   143.379     0.150
     8.403   220.379     0.150
    10.954   282.402     0.150
    15.141   470.391     0.150
    16.112   221.320     0.150
    18.568   262.203     0.150
    18.683   255.027     0.150
     1.111    26.391     0.150
     7.328   120.090     0.150
     7.328   207.992     0.150
     2.199    44.906     0.150
     4.100    77.207     0.150
     0.662    11.272     0.150
     0.662    19.872     0.150
     1.112    35.572     0.150
     2.312    42.772     0.150
     2.312    73.072     0.150
     2.505    45.472     0.150
     2.505    78.072     0.150
     3.332    60.672     0.150
     3.332   104.872     0.150
     3.656    59.372     0.150
     3.656   114.272     0.150
     4.021    69.772     0.150
     3.973    65.272     0.150
     5.168   161.472     0.150
     5.168    79.272     0.150
     5.168   161.272     0.150
     6.010   187.872     0.150
     6.397   116.772     0.150
     6.397   199.472     0.150
     6.397   198.572     0.150
     6.396   199.372     0.150
     6.396   204.972     0.150
     6.484   201.372     0.150
     6.629   206.172     0.150
     6.895    97.733     0.150
     6.895   175.105     0.150
     7.180   224.972     0.150
     7.361   134.272     0.150
     7.361   229.172     0.150
     7.361   109.272     0.150
     7.361   134.272     0.150
     7.361   191.472     0.150
     7.361   229.172     0.150
    10.964   153.078     0.150
    23.734   309.174     0.150
     1.091    39.219     0.150
     4.940   154.418     0.150
     6.102   111.816     0.150
     5.993   186.316     0.150
     6.379   199.020     0.150
     6.379   198.918     0.150
     6.466   117.617     0.150
     6.466   201.918     0.150
     6.613   206.117     0.150
     6.903   125.566     0.150
     7.191   224.520     0.150
     7.187   223.418     0.150
     8.411   117.910     0.150
     8.411   253.410     0.150
    16.096   221.961     0.150
     1.447    30.123     0.150
     1.447    50.423     0.150
     2.289    84.623     0.150
     1.441    49.656     0.150
     1.862    52.625     0.150
     1.862    58.914     0.150
     1.862    58.914     0.150
     2.443    86.758     0.150
     3.930    88.227     0.150
     3.930   121.805     0.150
     4.293    86.477     0.150
     4.293   117.484     0.150
     4.962   138.156     0.150
     6.836   128.453     0.150
     7.265   144.344     0.150
     7.265   218.422     0.150
     7.772   154.602     0.150
     7.772   236.133     0.150
     7.772   236.133     0.150
     7.916   157.258     0.150
     7.916   240.492     0.150
     7.916   240.492     0.150
     6.838   124.023     0.150
     0.688    13.285     0.150
     1.104    20.584     0.150
     1.425    28.785     0.150
     1.425    48.885     0.150
     2.293    40.285     0.150
     2.293    42.484     0.150
     2.293    72.686     0.150
     2.412    41.484     0.150
     2.412    44.285     0.150
     3.642    58.385     0.150
     3.642    66.084     0.150
     3.954    62.885     0.150
     4.921   151.686     0.150
     6.085   196.084     0.150
     6.377   198.785     0.150
     7.335   133.385     0.150
     7.335   132.484     0.150
     7.335   228.484     0.150
    10.938   339.307     0.150
     0.529    10.721     0.150
     0.529    10.721     0.150
     0.529    17.820     0.150
     0.948    36.420     0.150
     0.948    18.119     0.150
     0.948    30.420     0.150
     1.450    27.119     0.150
     1.450    46.221     0.150
     2.138    37.619     0.150
     2.138    39.119     0.150
     2.138    65.920     0.150
     2.200    38.721     0.150
     2.200    41.119     0.150
     2.200    70.020     0.150
     2.429    41.820     0.150
     2.429    44.820     0.150
     2.429    76.221     0.150
     2.723    93.420     0.150
     2.723    45.721     0.150
     2.723    49.920     0.150
     2.723    86.020     0.150
     3.188    58.820     0.150
     3.188   100.320     0.150
     3.535    57.420     0.150
     3.535    64.420     0.150
     3.535   110.420     0.150
     3.958    63.119     0.150
     3.958    72.020     0.150
     3.958   107.721     0.150
     3.958   123.520     0.150
     4.466    70.020     0.150
     4.466    81.920     0.150
     4.466   139.221     0.150
     5.215   162.920     0.150
     5.215    80.820     0.150
     5.215    95.420     0.150
     5.215   162.920     0.150
     5.204   163.221     0.150
     6.048   188.920     0.150
     6.391    98.820     0.150
     6.391   118.721     0.150
     6.391   200.820     0.150
     6.387   119.020     0.150
     6.387   198.820     0.150
     6.387    96.221     0.150
     6.387   198.820     0.150
     6.438   100.820     0.150
     6.438   109.721     0.150
     6.438   123.320     0.150
     6.438   200.520     0.150
     6.494    87.520     0.150
     6.494   119.020     0.150
     6.494   202.920     0.150
     7.312   133.727     0.150
     7.469   135.221     0.150
     7.469   232.520     0.150
     7.506   233.320     0.150
     7.506   112.320     0.150
     7.506   233.320     0.150
     7.596   137.721     0.150
     7.596   236.619     0.150
     7.596   137.721     0.150
     7.596   236.619     0.150
     7.632   139.420     0.150
     7.632   239.119     0.150
     7.632   111.820     0.150
     7.632   139.420     0.150
     7.632   239.119     0.150
     7.804   241.920     0.150
     8.235   118.414     0.150
     8.235   249.439     0.150
     8.235   118.189     0.150
     8.235   209.359     0.150
     8.235   118.020     0.150
     7.951   144.020     0.150
     7.951   247.920     0.150
     8.839   161.020     0.150
     8.839   276.920     0.150
     9.034   133.820     0.150
     9.486   172.088     0.150
     9.486   172.721     0.150
     9.958   165.920     0.150
     9.958   283.119     0.150
    10.834   307.619     0.150
    10.995   184.020     0.150
    10.995   305.520     0.150
    11.132   286.439     0.150
    11.132   286.439     0.150
    11.443   293.721     0.150
    13.906   201.221     0.150
    15.755   217.670     0.150
    15.755   218.113     0.150
    15.755   218.520     0.150
    16.726   238.221     0.150
    17.750   245.410     0.150
    18.245   249.670     0.150
    18.483   255.721     0.150
    20.521   281.420     0.150
    21.829   296.920     0.150
    22.561   307.119     0.150
    23.220   308.080     0.150
    23.554   748.096     0.150
    23.625   313.320     0.150
    23.625   313.100     0.150
    23.625   313.119     0.150
    23.786   314.221     0.150
    24.554   322.000     0.150
    25.521     7.201     0.150
    26.864   341.141     0.150
    26.861   344.619     0.150
    27.105   346.320     0.150
    27.509   348.619     0.150
    27.719   352.520     0.150
    27.752   352.820     0.150
    28.806   362.320     0.150
    28.789   362.520     0.150
    29.164   365.420     0.150
    31.643   386.920     0.150
    31.643   700.221     0.150
    31.643   808.320     0.150
    32.418   392.721     0.150
    34.438   407.520     0.150
    34.438   407.070     0.150
    34.805   412.270     0.150
    55.843   425.301     0.150
    44.588   430.750     0.150
    36.794   431.920     0.150
    37.570   431.920     0.150
    39.229   448.000     0.150
    45.877   448.980     0.150
    40.828   465.920     0.150
    40.616   461.920     0.150
    43.007   479.820     0.150
    43.108   482.119     0.150
    44.084   487.619     0.150
    45.237   498.939     0.150
    45.237   498.920     0.150
    47.139   515.010     0.150
    47.139   515.010     0.150
    47.139   668.301     0.150
    47.139  1197.301     0.150
    47.139   514.920     0.150
    47.139   624.320     0.150
    47.139   668.221     0.150
    47.139   928.520     0.150
    47.139  1197.221     0.150
    48.549   525.709     0.150
    48.793   691.420     0.150
    48.793  1235.119     0.150
    49.067   611.320     0.150
    49.067   528.340     0.150
    49.898   531.320     0.150
    52.796   559.260     0.150
    53.499   562.520     0.150
    53.967   569.561     0.150
    54.469   567.529     0.150
    54.316   567.311     0.150
    54.727   572.020     0.150
    54.959   576.520     0.150
    55.049   574.920     0.150
    55.700   582.070     0.150
    55.700    -0.650     0.150
    55.700   581.420     0.150
    55.843   581.391     0.150
    57.133   588.920     0.150
    57.302   591.561     0.150
    59.617   608.207     0.150
    59.975   613.225     0.150
    61.695   619.670     0.150
    64.623   641.430     0.150
    72.250   686.949     0.150
    73.264   693.920     0.150
    73.688   694.920     0.150
    74.585   701.920     0.150
    77.683   717.131     0.150
    77.683   721.520     0.150
    81.275   737.420     0.150
    83.321   748.520     0.150
    85.079   756.619     0.150
    87.512   770.420     0.150
    88.502   774.189     0.150
   139.433  1167.119     0.150
   146.471  1180.000     0.150
     0.546    10.514     0.150
     0.546    17.713     0.150
     0.933    36.113     0.150
     0.933    17.613     0.150
     0.933    30.113     0.150
     2.136    64.514     0.150
     2.136    37.314     0.150
     2.136    64.314     0.150
     2.412    41.613     0.150
     2.718    54.514     0.150
     3.521   115.213     0.150
     5.197    80.814     0.150
     6.396   121.514     0.150
     6.396   203.713     0.150
     7.300   118.670     0.150
     7.614   139.014     0.150
     8.254   215.732     0.150
     9.469   143.381     0.150
     9.469   298.656     0.150
    11.114   169.447     0.150
    11.114   359.412     0.150
    11.444   176.631     0.150
    11.444   306.082     0.150
    11.444   369.482     0.150
     2.140    65.008     0.150
     2.369    68.209     0.150
     2.427    10.908     0.150
     4.466    83.408     0.150
     0.543    10.494     0.150
     0.543    17.594     0.150
     2.132    64.693     0.150
     2.187    40.395     0.150
     2.187    40.494     0.150
     2.415    44.594     0.150
     2.724    93.795     0.150
     2.724    45.494     0.150
     2.724    49.895     0.150
     3.522    63.693     0.150
     3.522   110.193     0.150
     3.944    76.795     0.150
     5.192   163.594     0.150
     5.201   162.994     0.150
     5.201    95.193     0.150
     5.201   162.895     0.150
     6.373   116.693     0.150
     6.373   199.295     0.150
     6.373    96.193     0.150
     6.373   116.693     0.150
     6.373   198.795     0.150
     7.455   135.494     0.150
     7.493   233.693     0.150
     7.591   111.594     0.150
     7.621   139.895     0.150
     7.621   199.994     0.150
     7.938   144.295     0.150
     8.248   117.588     0.150
     8.248   213.295     0.150
     8.825   161.094     0.150
     8.825   274.193     0.150
     9.020   164.693     0.150
    10.821   308.795     0.150
    10.982   303.295     0.150
    11.448   351.162     0.150
    12.847   189.295     0.150
    12.847   195.295     0.150
    15.564   481.684     0.150
    15.764   217.736     0.150
    16.005   222.994     0.150
    16.005   397.094     0.150
    16.311   233.295     0.150
    18.244   249.920     0.150
    18.496   572.869     0.150
    20.745     4.400     0.150
    22.549   299.994     0.150
    22.549     8.100     0.150
    23.233   308.193     0.150
    23.543   746.707     0.150
    24.557   322.094     0.150
    26.854   344.744     0.150
    44.602   429.584     0.150
    36.781   429.994     0.150
    43.120   482.295     0.150
   109.561   486.984     0.150
    45.094   492.594     0.150
    45.094   639.193     0.150
    45.094   890.094     0.150
    45.250   499.094     0.150
    49.061   529.193     0.150
    89.628   651.613     0.150
    68.938   667.295     0.150
    64.279   692.314     0.150
    74.221   699.215     0.150
    81.271   738.193     0.150
   136.771  1160.244     0.150
     0.935    21.367     0.150
     0.935    36.570     0.150
     4.455    83.773     0.150
     6.369   122.367     0.150
     6.384   121.672     0.150
     5.199   162.812     0.150
     5.191   162.211     0.150
     6.032   188.008     0.150
     6.371   119.312     0.150
     6.401   121.406     0.150
     6.401   200.008     0.150
     7.308   133.969     0.150
     7.453   135.406     0.150
     7.592   138.008     0.150
     7.592   236.508     0.150
     7.620   121.711     0.150
     7.620   139.406     0.150
     7.620   237.711     0.150
     7.739   140.609     0.150
     7.936   144.312     0.150
     8.250   249.703     0.150
     0.551    12.326     0.150
     0.930    36.226     0.150
     7.601   137.426     0.150
     8.264   249.170     0.150
     0.941    36.033     0.150
     1.463    50.033     0.150
     4.984   159.635     0.150
     6.860   124.334     0.150
     1.101    39.523     0.150
     1.448    28.023     0.150
     1.448    50.930     0.150
     7.163   130.328     0.150
     2.298    69.117     0.150
     2.298    84.020     0.150
     2.399    40.418     0.150
     2.399    46.918     0.150
     6.875   221.047     0.150
     7.327   133.719     0.150
     8.435   255.062     0.150
    16.125   221.961     0.150
     0.737    13.826     0.150
     1.055    22.326     0.150
     1.055    38.526     0.150
     1.485    28.125     0.150
     1.485    47.625     0.150
     2.306    72.226     0.150
     2.482    77.726     0.150
     6.317   116.426     0.150
     6.402    92.926     0.150
    11.110   288.719     0.150
    11.110   354.319     0.150
    10.584   151.430     0.150
    10.584   324.367     0.150
    23.399   309.078     0.150
     1.098    22.006     0.150
     1.098    37.805     0.150
     1.318    46.006     0.150
     2.423    86.404     0.150
     0.995    36.070     0.150
     2.390    87.270     0.150
     4.263   136.344     0.150
     4.483   113.770     0.150
     5.918   184.570     0.150
     6.297   161.270     0.150
     6.297   195.668     0.150
    10.901   160.699     0.150
    10.901   345.191     0.150
    16.099   222.836     0.150
     1.081    21.776     0.150
     1.081    38.276     0.150
     1.081    20.376     0.150
     1.405    27.276     0.150
     1.405    27.376     0.150
     1.405    45.376     0.150
     2.239    40.576     0.150
     2.291    72.676     0.150
     2.358    70.576     0.150
     2.358    85.676     0.150
     2.358    40.876     0.150
     2.425    49.076     0.150
     2.425    41.376     0.150
     2.425    44.676     0.150
     2.456    44.576     0.150
     2.456    76.676     0.150
     3.308    60.076     0.150
     3.635    58.276     0.150
     3.966    62.776     0.150
     3.966   124.776     0.150
     5.169   161.676     0.150
     6.122    90.676     0.150
     8.470   210.776     0.150
    10.982   158.176     0.150
    16.053   223.344     0.150
    16.053   389.413     0.150
    16.053   223.276     0.150
    16.103   224.576     0.150
    18.611   253.476     0.150
    18.611   253.476     0.150
    23.717   314.176     0.150
    31.922   383.376     0.150
    31.922   690.176     0.150
    43.826   486.876     0.150
    49.377   528.476     0.150
     0.591    15.496     0.150
     0.889    31.297     0.150
     2.110    65.898     0.150
     2.110    35.996     0.150
     2.110    38.496     0.150
     2.110    65.898     0.150
     2.140    44.297     0.150
     2.140    75.898     0.150
     2.140    36.598     0.150
     2.367    47.195     0.150
     2.367    43.695     0.150
     2.727    44.398     0.150
     2.727    84.898     0.150
     3.131   105.695     0.150
     3.131    57.496     0.150
     3.477    66.898     0.150
     3.477    55.297     0.150
     3.896    60.996     0.150
     4.409    84.996     0.150
     4.409    67.898     0.150
     5.153    97.195     0.150
     5.153    77.695     0.150
     5.151    77.898     0.150
     6.325    93.797     0.150
     6.376   120.098     0.150
     6.432   121.195     0.150
     7.183   136.496     0.150
     7.407   138.195     0.150
     7.444   135.195     0.150
     7.444   109.098     0.150
     7.576   107.695     0.150
     7.576   107.695     0.150
     7.581   140.398     0.150
     7.742   145.496     0.150
     7.742   145.496     0.150
     7.889   147.098     0.150
     8.295   118.363     0.150
     8.337   151.797     0.150
     8.337   121.195     0.150
     8.726   162.398     0.150
     8.726   126.695     0.150
     8.777   158.797     0.150
     8.777   272.598     0.150
     8.828   225.598     0.150
     8.972   162.898     0.150
     8.972   130.398     0.150
     9.896   248.996     0.150
     9.896   142.398     0.150
    10.437   190.098     0.150
    10.773   182.797     0.150
    10.773   301.195     0.150
    10.935   306.398     0.150
    11.073   285.195     0.150
    11.073   158.098     0.150
    11.073   285.195     0.150
    11.469   297.914     0.150
    11.469   297.598     0.150
    13.896   201.695     0.150
    13.900   213.098     0.150
    15.416   227.195     0.150
    15.575   491.621     0.150
    15.575   219.785     0.150
    15.575   219.797     0.150
    15.798   217.059     0.150
    15.798   216.945     0.150
    15.798   216.988     0.150
    15.798   382.539     0.150
    15.798   216.898     0.150
    16.042   236.297     0.150
    16.276     3.801     0.150
    16.276   241.098     0.150
    16.276   425.598     0.150
    17.811   246.496     0.150
    18.241   438.945     0.150
    18.241   247.898     0.150
    18.574   257.695     0.150
    20.317   278.195     0.150
    20.477     3.699     0.150
    20.477     6.297     0.150
    20.515   280.098     0.150
    20.515   276.898     0.150
    20.699   281.195     0.150
    21.420   287.398     0.150
    21.770   292.695     0.150
    23.278   307.195     0.150
    23.278   308.797     0.150
    23.356     4.598     0.150
    23.566   310.598     0.150
    23.728   310.496     0.150
    24.569   320.898     0.150
    24.651     6.301     0.150
    24.651   587.797     0.150
    26.818   340.496     0.150
    28.670   359.195     0.150
    29.379   363.398     0.150
    30.490   373.398     0.150
    31.608   381.996     0.150
    32.362   389.098     0.150
    32.873   395.098     0.150
    55.793   422.047     0.150
    36.455   425.797     0.150
    36.733   425.047     0.150
    36.733   425.098     0.150
    37.561   426.898     0.150
    38.003   437.098     0.150
    38.003   790.398     0.150
    38.658   442.438     0.150
    38.658   442.488     0.150
    39.225   447.297     0.150
    39.876   452.797     0.150
    39.952   453.398     0.150
    40.563   460.898     0.150
    40.911   460.996     0.150
    41.427   465.398     0.150
    41.941   580.398     0.150
    42.796   853.598     0.150
    42.759   475.695     0.150
    43.066   478.496     0.150
    43.166   480.898     0.150
    43.290   480.496     0.150
    43.463   481.867     0.150
    43.463   481.797     0.150
    43.929   484.898     0.150
    44.813   493.598     0.150
    45.038   495.297     0.150
    45.059   490.996     0.150
    45.059  1084.098     0.150
    45.956   502.297     0.150
   118.995   506.887     0.150
    46.942   511.898     0.150
    47.116   511.078     0.150
    47.116   511.078     0.150
    47.116   665.016     0.150
    47.116  1191.797     0.150
    47.116   510.996     0.150
    47.116   621.398     0.150
    47.116   664.996     0.150
    47.116   922.898     0.150
    47.116  1191.797     0.150
    47.307   518.375     0.150
    47.307   932.008     0.150
    47.307  1205.508     0.150
    48.920   524.398     0.150
    49.039   525.797     0.150
    49.039   525.695     0.150
    49.051   525.797     0.150
    49.141   526.297     0.150
    49.837   532.797     0.150
    49.938   533.477     0.150
    49.938   533.535     0.150
    50.706   538.898     0.150
    52.771   555.398     0.150
    53.081   557.797     0.150
    53.122   558.297     0.150
    53.458   560.098     0.150
    53.474   560.098     0.150
    53.582   564.195     0.150
    53.637   561.996     0.150
    53.837   563.598     0.150
    54.000   565.598     0.150
    54.286   567.195     0.150
    82.155   567.238     0.150
    54.522   566.398     0.150
    54.565   569.098     0.150
    54.608   570.598     0.150
    54.631   570.488     0.150
    54.631   570.496     0.150
    54.671   568.348     0.150
    54.671   568.297     0.150
    54.687   569.898     0.150
    54.752   569.996     0.150
    54.848   570.297     0.150
    54.937   571.398     0.150
    55.001   572.398     0.150
    55.040   568.195     0.150
    55.040   571.297     0.150
    55.042   571.195     0.150
    55.292   573.637     0.150
    55.628   574.598     0.150
    55.698   575.898     0.150
    55.793   577.406     0.150
    55.793   575.875     0.150
    55.969   578.750     0.150
    55.969   578.797     0.150
    56.052   579.195     0.150
    56.231   579.996     0.150
    56.308   579.496     0.150
    56.754   583.695     0.150
    57.048   586.035     0.150
    57.113   586.297     0.150
    57.113   586.297     0.150
    57.281   586.926     0.150
    57.281   586.898     0.150
    57.281   642.195     0.150
    57.396   588.195     0.150
    57.762   591.496     0.150
    57.810    -0.379     0.150
    58.250   595.746     0.150
    58.349   596.637     0.150
    58.349   596.598     0.150
    58.383   594.297     0.150
    58.383   594.297     0.150
    58.385   595.453     0.150
    58.803     0.180     0.150
    58.803   598.996     0.150
    58.818   598.176     0.150
    58.989   598.695     0.150
    59.026   600.141     0.150
    59.039 76379.172     0.150
    59.039 76386.922     0.150
    59.039 76386.977     0.150
    59.039 76387.109     0.150
    59.383   601.602     0.150
    59.418   602.473     0.150
    59.542   603.531     0.150
    59.597   604.852     0.150
    59.819   603.398     0.150
    59.955   606.828     0.150
    60.097   605.641     0.150
    60.285   609.016     0.150
    60.285   608.996     0.150
    60.460   609.195     0.150
    60.850   612.195     0.150
    60.929   611.695     0.150
    61.714   615.398     0.150
    62.456   623.766     0.150
    62.504   623.695     0.150
    62.529   622.195     0.150
    63.458   629.195     0.150
    63.652   631.098     0.150
    63.896   632.098     0.150
    64.280   634.996     0.150
    64.446   634.797     0.150
    64.610   636.496     0.150
    66.063   647.098     0.150
    66.434   649.297     0.150
    67.067   654.797     0.150
    69.956   669.398     0.150
    70.634   676.695     0.150
    72.236   684.496     0.150
    73.741   693.098     0.150
    74.643   700.496     0.150
    75.182   702.598     0.150
    77.282   715.496     0.150
    77.660   715.438     0.150
    77.660   715.996     0.150
    80.901   734.496     0.150
    81.258   735.598     0.150
    82.386   742.695     0.150
    82.583   742.195     0.150
    83.368   746.898     0.150
    83.940   750.695     0.150
    85.127   754.898     0.150
    85.433   757.496     0.150
    85.449   756.746     0.150
    86.301   761.496     0.150
    87.569   765.977     0.150
    87.569   768.297     0.150
    87.595   767.398     0.150
    88.548   772.695     0.150
    90.596   780.527     0.150
    90.596   780.496     0.150
    91.124   785.238     0.150
   136.756  1160.695     0.150
   139.472  1167.098     0.150
   151.483  1192.195     0.150
   163.244  1252.598     0.150
    58.355   594.059     0.150
    33.496   546.887     0.150
    33.496   301.918     0.150
    18.241   248.008     0.150
    37.394   431.727     0.150
     0.954    18.785     0.150
     0.954    34.887     0.150
     1.900    41.684     0.150
     1.900    66.285     0.150
     1.900    33.684     0.150
     1.900    35.586     0.150
     1.900    60.684     0.150
     2.186    40.184     0.150
     2.186    45.484     0.150
     2.186    68.684     0.150
     2.186    37.586     0.150
     2.186    67.785     0.150
     2.964    59.387     0.150
     2.964    62.887     0.150
     3.392    59.285     0.150
     3.392    67.586     0.150
     3.392    61.586     0.150
     3.420    58.984     0.150
     3.420    67.984     0.150
     3.420    62.387     0.150
     3.420   105.684     0.150
     3.475    69.184     0.150
     3.475    63.984     0.150
     4.413    85.586     0.150
     4.735    77.684     0.150
     4.735    80.684     0.150
     4.735    91.785     0.150
     4.735    95.586     0.150
     4.735    73.285     0.150
     5.010    97.984     0.150
     5.010    76.785     0.150
     5.083   156.484     0.150
     5.583   102.684     0.150
     5.583   174.586     0.150
     6.144    94.586     0.150
     6.144    96.484     0.150
     6.144    94.586     0.150
     6.991   105.387     0.150
     6.991   127.086     0.150
     7.057   100.984     0.150
     7.057   100.984     0.150
     7.653   193.086     0.150
     7.714   107.484     0.150
     7.926   116.285     0.150
    14.444   457.035     0.150
    15.888   218.430     0.150
    15.888   224.684     0.150
    16.767   233.086     0.150
    19.286   265.086     0.150
    19.676   271.285     0.150
    19.912   271.984     0.150
    22.039   295.984     0.150
    42.637   476.887     0.150
    48.555   944.637     0.150
    48.555  1140.977     0.150
    48.555  1226.137     0.150
    50.037   533.887     0.150
    50.332   536.684     0.150
    56.038   580.484     0.150
    56.260   580.684     0.150
    58.509   596.887     0.150
    59.402   601.785     0.150
    61.362 64060.145     0.150
    61.362 64067.207     0.150
    61.362 64067.551     0.150
    61.362 64067.965     0.150
    76.957   711.727     0.150
    76.965   712.387     0.150
    80.575   732.586     0.150
     1.095    22.965     0.150
     2.287    69.863     0.150
     2.396    39.164     0.150
     2.396    41.965     0.150
     1.461    58.945     0.150
     2.680    92.746     0.150
     4.148    68.047     0.150
     8.274   118.664     0.150
     9.462   297.715     0.150
    10.470   148.547     0.150
    15.807   217.965     0.150
    23.614   317.895     0.150
     0.869    15.945     0.150
     0.869    33.945     0.150
     0.930    34.844     0.150
     2.352    48.750     0.150
     2.352    85.648     0.150
     0.868    34.070     0.150
     0.938    20.871     0.150
     0.938    35.371     0.150
     2.344    71.672     0.150
     2.344    85.973     0.150
     4.385    81.473     0.150
     0.866    33.965     0.150
     0.929    20.668     0.150
     0.929    35.266     0.150
     2.355    41.168     0.150
     2.355    85.867     0.150
     8.619   122.465     0.150
    10.219   147.066     0.150
    10.632   150.766     0.150
    10.743   196.777     0.150
    10.743   277.090     0.150
    11.201   278.969     0.150
    12.940   181.668     0.150
    16.243   224.250     0.150
    11.209   279.031     0.150
    16.257   225.070     0.150
     4.735   125.172     0.150
     4.735   145.273     0.150
     8.637   123.477     0.150
     8.637   122.039     0.150
    10.725   340.102     0.150
    16.256   224.570     0.150
     8.634   122.219     0.150
    16.262   224.242     0.150
     0.878    16.936     0.150
     0.913    17.736     0.150
     2.077    38.836     0.150
     2.399    40.535     0.150
     8.590   156.135     0.150
     8.632   261.076     0.150
    16.249   224.396     0.150
    16.249   224.553     0.150
    16.249   396.504     0.150
    18.625   255.436     0.150
    18.625   465.086     0.150
    20.096   639.836     0.150
    23.518   744.861     0.150
    26.947   345.406     0.150
    39.610   453.105     0.150
    57.580   591.719     0.150
     0.856    16.633     0.150
     2.104    39.533     0.150
     2.413    40.332     0.150
     3.128    60.033     0.150
     4.387    81.133     0.150
     6.172    93.033     0.150
     8.618   157.633     0.150
    10.481   156.033     0.150
    10.753   156.482     0.150
    11.196   279.275     0.150
    16.235   223.322     0.150
    16.235   224.141     0.150
    16.235   396.314     0.150
    18.633   455.922     0.150
    19.043   267.934     0.150
    23.543   748.768     0.150
    30.500   374.023     0.150
    43.507   485.371     0.150
    54.108   510.633     0.150
    59.110   601.105     0.150
    59.859   607.066     0.150
    60.271   609.990     0.150
    57.082   654.332     0.150
   139.353   718.543     0.150
     6.838   103.889     0.150
    11.189   278.006     0.150
    15.220   480.789     0.150
     9.237   140.695     0.150
    16.271   225.495     0.150
    18.806   591.077     0.150
     0.728    15.550     0.150
     1.051    21.550     0.150
     1.051    21.550     0.150
     2.445    45.449     0.150
     2.445    76.649     0.150
     3.042    96.850     0.150
     3.214    51.249     0.150
     3.214   101.850     0.150
     4.288   136.124     0.150
     5.878   182.749     0.150
     6.633   206.050     0.150
     6.705    95.949     0.150
     6.705   207.018     0.150
     7.907   248.749     0.150
    11.012   197.192     0.150
    11.012   334.442     0.150
    11.061   338.567     0.150
    12.384   182.060     0.150
    12.656   388.329     0.150
    14.589   202.192     0.150
    15.490   477.074     0.150
    16.250   225.109     0.150
    18.231   442.800     0.150
    20.914   653.800     0.150
    24.157   314.291     0.150
    24.781   775.534     0.150
    25.011   783.324     0.150
    25.168   333.449     0.150
    25.168   333.449     0.150
    25.168   333.449     0.150
    31.921   387.659     0.150
    36.936   435.850     0.150
    65.846   468.939     0.150
    43.692   484.430     0.150
    49.027     9.325     0.150
    53.271   566.749     0.150
    53.271   566.749     0.150
    53.271   566.749     0.150
    53.667   568.965     0.150
    53.819   569.960     0.150
    54.393   576.649     0.150
    54.393   576.649     0.150
    54.393   576.649     0.150
    54.393   575.344     0.150
    54.471   574.949     0.150
    54.471   568.649     0.150
    54.471   574.949     0.150
    54.471   568.649     0.150
    54.471   574.949     0.150
    54.914   578.649     0.150
    54.914   578.649     0.150
    54.914   578.649     0.150
    55.316   580.609     0.150
    55.335   580.449     0.150
    55.351   581.850     0.150
    55.351   581.850     0.150
    55.351   581.850     0.150
    55.351   580.501     0.150
    55.411   582.149     0.150
    55.411   582.149     0.150
    55.411   582.149     0.150
    55.411   581.831     0.150
    55.415   581.350     0.150
    55.784   585.050     0.150
    55.784   585.050     0.150
    55.784   585.050     0.150
    55.980   585.649     0.150
    56.005   587.749     0.150
    56.005   587.749     0.150
    56.005   587.749     0.150
    56.302   587.889     0.150
    56.379   588.850     0.150
    56.379   588.850     0.150
    56.379   588.850     0.150
    56.984   592.449     0.150
    57.424   587.350     0.150
    57.645   597.550     0.150
    57.645   597.550     0.150
    57.645   597.727     0.150
    57.980   599.850     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     2.425    39.820     0.150
     8.512   123.023     0.150
     8.709   127.820     0.150
    10.324   150.820     0.150
    10.324   150.422     0.150
    10.731   156.719     0.150
    16.142   394.820     0.150
    16.285   229.820     0.150
    17.835   250.820     0.150
    18.171   255.422     0.150
    18.186   255.820     0.150
    18.186   256.820     0.150
    18.687   258.820     0.150
    18.687   465.719     0.150
    19.288   266.219     0.150
    22.006   548.117     0.150
    22.759   303.219     0.150
    23.448   311.820     0.150
    23.448   568.820     0.150
    23.801   313.820     0.150
    23.801   570.820     0.150
    24.219   316.820     0.150
    28.630   358.820     0.150
    30.330   372.820     0.150
    30.330   373.320     0.150
    30.522   373.820     0.150
    30.544   374.820     0.150
    30.544   674.820     0.150
    31.754   384.922     0.150
    32.977   397.820     0.150
    34.287   409.617     0.150
    35.746   421.820     0.150
    35.746   421.523     0.150
    36.405   425.820     0.150
    36.489   427.820     0.150
    37.692   438.023     0.150
    37.884   437.820     0.150
    39.037   802.820     0.150
    39.277   449.922     0.150
    39.879   454.820     0.150
    40.324   458.523     0.150
    40.324   459.117     0.150
    40.324   551.820     0.150
    41.101   464.219     0.150
    41.453   465.820     0.150
    41.523   466.820     0.150
    41.523     4.000     0.150
    41.619   468.820     0.150
    41.619   570.820     0.150
    41.619   842.820     0.150
    42.081   471.617     0.150
    42.255   474.820     0.150
    42.239   473.820     0.150
    42.713   477.820     0.150
    42.865   477.117     0.150
    42.909   480.023     0.150
    43.022   479.820     0.150
    43.081   480.523     0.150
    43.103   480.820     0.150
    43.093   479.820     0.150
    43.093   866.820     0.150
    43.115   482.820     0.150
    43.196   484.023     0.150
    43.745   486.922     0.150
    44.348   488.922     0.150
    44.509   492.023     0.150
    44.527   491.219     0.150
    44.527   882.820     0.150
    44.933   495.422     0.150
    45.329   497.820     0.150
    45.542   500.523     0.150
    46.904   511.820     0.150
    47.537   515.820     0.150
    47.495   516.820     0.150
    47.543   516.023     0.150
    48.034   518.719     0.150
    48.275   522.820     0.150
    48.596   525.820     0.150
    48.604   525.820     0.150
    49.281   528.422     0.150
    49.298   531.820     0.150
    49.511   532.820     0.150
    49.793   535.617     0.150
    49.794   531.219     0.150
    52.096   550.820     0.150
    52.111   552.117     0.150
    52.342   552.820     0.150
    53.989   561.820     0.150
    54.004   564.820     0.150
    54.298   566.820     0.150
    54.566   568.820     0.150
    54.873   569.320     0.150
    54.882   571.617     0.150
    55.164   576.820     0.150
    55.455   578.117     0.150
    55.600   576.023     0.150
    55.960   580.523     0.150
    56.018   578.820     0.150
    56.018   635.820     0.150
    56.381   582.320     0.150
    56.654   584.820     0.150
    56.926   586.023     0.150
    57.091   587.320     0.150
    57.262   588.320     0.150
    57.262     4.500     0.150
    57.441   589.820     0.150
    57.988   593.820     0.150
    58.123   594.820     0.150
    58.605   596.820     0.150
    58.682   598.820     0.150
    58.730   597.719     0.150
    59.155   602.820     0.150
    59.155     7.000     0.150
    59.155   650.820     0.150
    59.313   603.117     0.150
    59.363   602.922     0.150
    59.414   602.820     0.150
    59.813   606.820     0.150
    60.262   609.023     0.150
    60.291   608.719     0.150
    60.291  1343.820     0.150
    60.331   609.320     0.150
    60.564   613.023     0.150
    60.596   611.320     0.150
    61.256   615.820     0.150
    61.293   615.820     0.150
    62.635   626.320     0.150
    62.875   626.023     0.150
    63.061   626.820     0.150
    63.167   628.422     0.150
    63.182   628.219     0.150
    63.280   628.219     0.150
    63.292   628.320     0.150
    63.730   630.922     0.150
    64.030   633.523     0.150
    64.102   634.117     0.150
    64.325   635.820     0.150
    64.620   637.820     0.150
    64.755   638.820     0.150
    64.963   639.617     0.150
    64.985   640.820     0.150
    65.022   640.422     0.150
    65.738   645.719     0.150
    66.000   647.422     0.150
    66.019   647.422     0.150
    66.054   647.820     0.150
    66.060   647.617     0.150
    66.319   649.820     0.150
    66.339   649.117     0.150
    68.616   664.219     0.150
    69.198   666.820     0.150
    69.230   668.320     0.150
    69.819   670.820     0.150
    70.249   674.320     0.150
    71.004   678.922     0.150
    71.066   678.219     0.150
    72.179   686.023     0.150
    73.144   692.820     0.150
    73.304   691.320     0.150
    73.453   693.820     0.150
    74.097   697.922     0.150
    74.150   698.117     0.150
    74.333   699.719     0.150
    74.422   700.820     0.150
    74.545   700.523     0.150
    75.213   702.820     0.150
    75.579   707.117     0.150
    76.566   713.820     0.150
    76.659   713.117     0.150
    78.304   721.820     0.150
    79.201   727.320     0.150
    79.240   726.820     0.150
    80.871   734.820     0.150
    81.762   739.820     0.150
    82.700   744.820     0.150
    83.905   750.820     0.150
    84.095   751.023     0.150
    86.400   762.219     0.150
    86.400     2.602     0.150
    87.948   770.820     0.150
    89.553   779.320     0.150
    90.201   781.820     0.150
    91.274   786.023     0.150
   146.109  1178.617     0.150
   146.404  1180.320     0.150
   146.404  1183.820     0.150
   151.026  1192.922     0.150
     2.190    38.422     0.150
     2.190    41.125     0.150
     2.641    43.219     0.150
     2.641    48.219     0.150
     8.954   133.820     0.150
    10.554   156.422     0.150
    16.293   230.422     0.150
    17.598   253.422     0.150
    17.598   451.422     0.150
    18.440   258.422     0.150
    23.028   307.422     0.150
    28.893   361.422     0.150
    30.595   377.422     0.150
    30.792   378.422     0.150
    36.007   424.422     0.150
    36.018   424.422     0.150
    37.711   436.422     0.150
    41.805   474.422     0.150
    42.467   476.422     0.150
    42.797   478.422     0.150
    42.923   484.125     0.150
    43.323   481.422     0.150
    44.002   490.125     0.150
    44.334   490.820     0.150
    44.420     4.500     0.150
    45.206   497.422     0.150
    48.222   520.922     0.150
    48.812   527.422     0.150
    49.462   530.125     0.150
    49.968   533.219     0.150
    50.391   537.422     0.150
    52.379   554.422     0.150
    54.519   570.422     0.150
    54.763   569.422     0.150
    55.106     2.000     0.150
    55.655   580.422     0.150
    56.167   583.422     0.150
    56.944   585.422     0.150
    57.652   591.922     0.150
    59.600   605.422     0.150
    66.208   649.422     0.150
    68.470   663.922     0.150
    69.071   667.523     0.150
    70.940   677.922     0.150
    74.257   699.422     0.150
    74.738   701.820     0.150
    78.124   720.422     0.150
    81.616   740.125     0.150
     0.500    10.227     0.150
     2.534    41.926     0.150
     2.534    44.926     0.150
     3.692    58.926     0.150
     3.692    67.527     0.150
     3.692   114.426     0.150
     4.634    71.625     0.150
     4.634    85.625     0.150
     5.017    78.324     0.150
     5.017    93.227     0.150
     5.017   159.125     0.150
     4.966    74.926     0.150
     4.966    88.926     0.150
     7.529   111.324     0.150
     7.529   138.824     0.150
     7.787   137.926     0.150
     8.877   128.926     0.150
     8.877   129.727     0.150
    10.487   152.926     0.150
    10.487   152.027     0.150
    13.465   191.125     0.150
    14.692   207.926     0.150
    14.692   208.027     0.150
    16.329   229.426     0.150
    17.670   242.426     0.150
    18.041   252.926     0.150
    18.041   253.426     0.150
    18.337   256.824     0.150
    18.567   459.926     0.150
    18.531   254.926     0.150
    18.531   255.027     0.150
    19.447   267.926     0.150
    20.124   276.926     0.150
    20.124   632.926     0.150
    22.330   300.926     0.150
    22.776   306.426     0.150
    22.926   304.926     0.150
    22.926   305.324     0.150
    23.100   308.426     0.150
    25.883   335.926     0.150
    28.791   359.926     0.150
    28.801   360.727     0.150
    30.079   425.926     0.150
    30.385   372.926     0.150
    30.385     6.000     0.150
    30.385   430.926     0.150
    30.385   551.926     0.150
    30.682   375.926     0.150
    30.682     6.000     0.150
    30.682   376.227     0.150
    30.682     5.699     0.150
    30.682   432.426     0.150
    30.897   379.227     0.150
    31.891   385.926     0.150
    31.891   386.426     0.150
    31.891   458.926     0.150
    34.457   408.926     0.150
    35.497   417.926     0.150
    35.497   418.527     0.150
    36.865     3.801     0.150
    37.629   435.527     0.150
    39.448   451.926     0.150
    40.193   457.227     0.150
    40.029   456.926     0.150
    40.398   457.926     0.150
    40.961   463.125     0.150
    41.705   468.926     0.150
    42.148   472.625     0.150
    42.359   473.926     0.150
    42.891   478.727     0.150
    43.123   480.227     0.150
    43.214   481.727     0.150
    44.606   491.926     0.150
    45.026   495.926     0.150
    47.652   516.926     0.150
    48.122   519.227     0.150
    48.397   525.324     0.150
    48.996   525.945     0.150
    48.758   526.926     0.150
    49.255   528.164     0.150
    49.363   528.727     0.150
    49.709   531.637     0.150
    49.871   531.824     0.150
    54.116   565.926     0.150
    54.116     4.301     0.150
    54.618   569.926     0.150
    54.723   568.824     0.150
    54.693   569.926     0.150
    54.768   568.926     0.150
    54.998   572.125     0.150
    55.104   572.426     0.150
    56.063   579.527     0.150
    56.118   579.625     0.150
    56.486   583.426     0.150
    57.190   587.426     0.150
    57.546   590.824     0.150
    57.829   592.227     0.150
    58.020   592.926     0.150
    58.241   595.227     0.150
    60.381   609.426     0.150
    60.693   611.824     0.150
    60.989   610.426     0.150
    61.353   616.027     0.150
    61.390   615.926     0.150
    63.276   628.625     0.150
    63.487   630.027     0.150
    63.558   630.324     0.150
    64.665   637.926     0.150
    66.223   647.926     0.150
    70.864   677.926     0.150
    71.007   682.426     0.150
    72.151   684.926     0.150
    73.010   691.926     0.150
    73.509   693.426     0.150
    73.957   696.926     0.150
    74.288   698.926     0.150
    75.073   702.926     0.150
    77.253   713.926     0.150
    77.606   718.426     0.150
    77.823   718.926     0.150
    80.419   733.426     0.150
    81.638   739.227     0.150
    83.750   750.324     0.150
    83.800   750.426     0.150
    87.831   772.426     0.150
   143.791  1172.926     0.150
     0.503     9.984     0.150
     0.503    15.883     0.150
     2.550    42.078     0.150
     2.550    45.180     0.150
     2.550    78.578     0.150
     2.321    39.180     0.150
     4.742    72.984     0.150
     4.742    87.781     0.150
     4.742   147.883     0.150
     5.112    75.281     0.150
     5.112    91.281     0.150
    10.628   155.383     0.150
    14.809   210.281     0.150
    15.943   391.281     0.150
    18.386   258.281     0.150
    18.531   458.281     0.150
    19.527   269.281     0.150
    19.527   269.383     0.150
    77.328   715.680     0.150
     0.557    17.922     0.150
     1.225    23.023     0.150
     2.287    38.621     0.150
     2.287    41.723     0.150
     2.287    71.820     0.150
     2.287    73.023     0.150
     2.409    44.320     0.150
     2.566    42.223     0.150
     2.566    46.223     0.150
     2.566    73.723     0.150
     2.566    79.723     0.150
     2.659    49.121     0.150
     2.659    84.422     0.150
     3.781    60.121     0.150
     3.781    68.121     0.150
     3.781   101.121     0.150
     3.781   117.621     0.150
     4.722    86.621     0.150
     4.722   147.023     0.150
     5.061    91.723     0.150
     5.061   157.820     0.150
     5.119    79.723     0.150
     5.119    95.922     0.150
     5.119   164.922     0.150
     5.948    89.223     0.150
     5.948   106.723     0.150
     5.948   183.219     0.150
     0.483    16.180     0.150
     0.759    14.680     0.150
     0.914    17.680     0.150
     0.914    28.680     0.150
     1.863    33.477     0.150
     1.863    34.180     0.150
     1.863    59.680     0.150
     2.088    36.180     0.150
     2.088    38.180     0.150
     2.088    65.680     0.150
     2.129    37.281     0.150
     2.129    39.281     0.150
     2.129    67.680     0.150
     2.209    41.180     0.150
     2.209    69.680     0.150
     2.335    42.578     0.150
     2.335    73.477     0.150
     2.341    41.180     0.150
     2.341    43.383     0.150
     2.341    75.078     0.150
     2.395    40.680     0.150
     2.395    43.680     0.150
     2.395    76.883     0.150
     2.444    41.180     0.150
     2.444    45.180     0.150
     2.444    78.180     0.150
     3.133    57.680     0.150
     3.133    89.680     0.150
     3.133    98.781     0.150
     3.459    55.680     0.150
     3.459    62.180     0.150
     3.459   107.680     0.150
     4.401    70.180     0.150
     4.401    81.680     0.150
     4.401   118.680     0.150
     4.401   138.180     0.150
     4.534    82.680     0.150
     4.534   140.680     0.150
     4.818    87.680     0.150
     4.818   130.883     0.150
     4.818   153.680     0.150
     4.870    73.883     0.150
     4.870    87.680     0.150
     4.870   130.680     0.150
     4.870   151.680     0.150
     5.635   102.383     0.150
     5.635   144.680     0.150
     5.635   174.680     0.150
     7.293   106.883     0.150
     7.293   134.180     0.150
     7.293   188.180     0.150
     7.293   229.180     0.150
     7.594   236.680     0.150
     0.712    14.066     0.150
     0.712    23.168     0.150
     1.383    25.867     0.150
     1.383    44.168     0.150
     2.345    39.668     0.150
     2.345    42.367     0.150
     2.345    74.668     0.150
     2.236    40.168     0.150
     2.574    44.168     0.150
     2.574    47.668     0.150
     2.574    80.969     0.150
     2.613    44.867     0.150
     2.613    47.867     0.150
     2.613    48.867     0.150
     2.613    82.168     0.150
     2.680    44.270     0.150
     2.692    49.066     0.150
     2.692    85.566     0.150
     2.820    47.566     0.150
     2.820    52.668     0.150
     2.820    90.168     0.150
     2.879    49.168     0.150
     2.879    52.770     0.150
     2.879    90.867     0.150
     3.160    51.168     0.150
     3.160    56.770     0.150
     3.160    98.969     0.150
     3.616    66.367     0.150
     3.616   112.168     0.150
     3.945    62.867     0.150
     3.945    64.270     0.150
     3.945    72.168     0.150
     3.945   123.168     0.150
     4.886    89.168     0.150
     4.886   153.168     0.150
     5.019    78.969     0.150
     5.019    92.867     0.150
     5.019   132.168     0.150
     5.177    78.566     0.150
     5.279    83.469     0.150
     5.279   143.367     0.150
     5.279   170.867     0.150
     5.461    83.469     0.150
     5.461    99.668     0.150
     5.461   143.668     0.150
     5.461   171.168     0.150
     6.112    91.668     0.150
     6.112   113.770     0.150
     6.112   159.867     0.150
     6.112   192.668     0.150
     7.579   111.168     0.150
     7.579   193.168     0.150
     7.579   237.770     0.150
     7.792   115.168     0.150
     7.792   143.168     0.150
     7.792   202.168     0.150
     7.792   243.566     0.150
     8.048   250.867     0.150
     8.142   118.066     0.150
     8.142   207.168     0.150
     9.140   286.168     0.150
     9.776   305.469     0.150
    10.276   151.367     0.150
    10.276   318.168     0.150
    10.748   157.168     0.150
    10.748   157.668     0.150
    11.164   164.168     0.150
    11.367   165.168     0.150
    11.367   354.566     0.150
    15.928   391.668     0.150
    18.276   255.168     0.150
    18.577   260.168     0.150
    18.577   260.469     0.150
    36.974   433.770     0.150
    42.665   480.168     0.150
    48.610   525.168     0.150
    48.610   525.367     0.150
    57.671   593.469     0.150
     0.535    17.562     0.150
     0.669    13.562     0.150
     0.669    22.562     0.150
     1.380    25.562     0.150
     1.380    43.363     0.150
     2.197    37.963     0.150
     2.197    40.463     0.150
     2.197    64.762     0.150
     2.197    69.963     0.150
     2.337    41.562     0.150
     2.337    43.062     0.150
     2.337    74.562     0.150
     2.559    45.062     0.150
     2.559    47.062     0.150
     2.559    81.062     0.150
     2.701    45.062     0.150
     2.701    48.562     0.150
     2.701    77.762     0.150
     2.701    83.463     0.150
     2.683    48.262     0.150
     2.683    84.662     0.150
     2.814    52.062     0.150
     2.814    89.262     0.150
     2.869    49.062     0.150
     2.869    52.562     0.150
     2.869    85.062     0.150
     2.869    91.162     0.150
     3.131    50.762     0.150
     3.131    56.562     0.150
     3.131    83.762     0.150
     3.131    97.963     0.150
     3.607    66.062     0.150
     3.607   113.762     0.150
     3.933    70.562     0.150
     3.933   107.762     0.150
     3.933   122.762     0.150
     4.874   132.363     0.150
     4.874   151.562     0.150
     5.007   136.562     0.150
     5.007   155.863     0.150
     5.132    93.562     0.150
     5.132   138.762     0.150
     5.432    82.463     0.150
     5.432    99.062     0.150
     5.432   143.062     0.150
     5.432   170.562     0.150
     6.090   157.562     0.150
     6.090   189.363     0.150
     7.533   139.062     0.150
     7.533   193.062     0.150
     7.533   236.762     0.150
     7.765   242.562     0.150
     0.538    17.762     0.150
     0.596    11.262     0.150
     0.596    19.062     0.150
     1.197    22.961     0.150
     1.455    27.660     0.150
     1.455    47.762     0.150
     1.645    30.863     0.150
     1.645    52.762     0.150
     1.708    31.562     0.150
     1.708    53.863     0.150
     1.972    35.461     0.150
     1.972    61.262     0.150
     2.179    36.461     0.150
     2.179    39.461     0.150
     2.179    67.461     0.150
     2.249    39.262     0.150
     2.249    41.262     0.150
     2.249    65.461     0.150
     2.249    70.762     0.150
     2.600    43.863     0.150
     2.600    47.660     0.150
     2.600    82.160     0.150
     3.028    50.160     0.150
     3.028    54.262     0.150
     3.028    94.660     0.150
     3.971    63.262     0.150
     3.971    72.262     0.150
     3.971   108.062     0.150
     3.971   124.262     0.150
     4.512    69.062     0.150
     4.512    81.262     0.150
     4.512   140.762     0.150
     4.547    70.961     0.150
     4.547    83.363     0.150
     4.547   141.660     0.150
     6.945   101.660     0.150
     6.945   128.262     0.150
     6.945   217.762     0.150
     0.387    13.898     0.150
     0.776    15.102     0.150
     0.776    24.898     0.150
     1.040    19.695     0.150
     1.040    32.898     0.150
     1.972    35.000     0.150
     1.972    37.000     0.150
     1.972    63.602     0.150
     2.233    37.398     0.150
     2.233    40.398     0.150
     2.233    70.102     0.150
     2.288    41.102     0.150
     2.298    42.102     0.150
     2.298    72.102     0.150
     2.430    43.898     0.150
     2.430    75.195     0.150
     2.482    41.195     0.150
     2.482    45.102     0.150
     2.482    76.898     0.150
     2.748    45.898     0.150
     2.748    49.898     0.150
     2.748    85.898     0.150
     3.325    53.602     0.150
     3.325    59.602     0.150
     3.325   103.500     0.150
     3.558    57.195     0.150
     3.558    64.297     0.150
     3.558   111.898     0.150
     4.500    80.898     0.150
     4.500   139.898     0.150
     4.631    84.898     0.150
     4.631   143.898     0.150
     4.834    75.102     0.150
     4.834    88.898     0.150
     4.834   151.898     0.150
     5.049    77.797     0.150
     5.049    92.000     0.150
     5.049   157.695     0.150
     5.695   103.297     0.150
     5.695   179.898     0.150
     0.614    12.391     0.150
     1.953    33.492     0.150
     1.953    59.094     0.150
     2.633    41.695     0.150
     2.633    47.391     0.150
     3.073    48.594     0.150
     3.073    54.594     0.150
     3.073    83.594     0.150
     4.491    67.992     0.150
     5.400    81.695     0.150
     5.400   140.594     0.150
     6.222    91.594     0.150
     6.222   193.594     0.150
     9.873   142.594     0.150
     9.873   142.797     0.150
    11.558   166.594     0.150
    11.844   169.594     0.150
    14.260   200.094     0.150
    14.260   206.594     0.150
    14.260   382.594     0.150
    14.473   208.094     0.150
    15.483   216.594     0.150
    15.483   397.594     0.150
    15.906   224.594     0.150
    16.668   230.594     0.150
    16.668   230.891     0.150
    17.244   243.391     0.150
    17.487   244.094     0.150
    17.487   438.594     0.150
    17.775   248.594     0.150
    17.921   249.797     0.150
    18.623   257.594     0.150
    18.623   267.594     0.150
    18.623   466.594     0.150
    18.892   467.594     0.150
    19.938   271.594     0.150
    19.938   272.195     0.150
    20.175   275.594     0.150
    20.175   285.594     0.150
    20.597   280.594     0.150
    20.597   280.891     0.150
    20.802   280.594     0.150
    20.802   509.594     0.150
    21.254   286.492     0.150
    21.607   292.594     0.150
    21.607   292.891     0.150
    21.662   290.594     0.150
    21.662   291.094     0.150
    21.740   293.594     0.150
    21.740   293.992     0.150
    21.852   294.695     0.150
    21.876   292.391     0.150
    22.886   302.594     0.150
    22.886   552.594     0.150
    23.586   311.391     0.150
    23.586   578.594     0.150
    23.634   307.594     0.150
    23.634   308.297     0.150
    23.735   312.094     0.150
    23.735   564.594     0.150
    23.735   576.594     0.150
    23.771   310.594     0.150
    23.771   311.297     0.150
    24.207   314.594     0.150
    24.207   314.695     0.150
    24.324   315.594     0.150
    24.324   316.391     0.150
    24.342   317.797     0.150
    24.372   314.594     0.150
    24.372   314.891     0.150
    24.549   317.594     0.150
    24.549   575.594     0.150
    24.733   319.594     0.150
    24.733   320.195     0.150
    24.746   320.594     0.150
    24.746   320.992     0.150
    25.270   323.594     0.150
    25.373   327.094     0.150
    25.410   325.594     0.150
    25.410   325.695     0.150
    25.556   326.594     0.150
    25.618   327.594     0.150
    25.618   327.695     0.150
    25.836   329.594     0.150
    26.376   334.594     0.150
    26.376    12.000     0.150
    26.376   624.594     0.150
    26.376   859.594     0.150
    27.057   342.094     0.150
    27.057     9.000     0.150
    28.499   355.391     0.150
    29.166   359.594     0.150
    29.166   650.594     0.150
    29.166   544.594     0.150
    29.195    11.000     0.150
    29.195   648.594     0.150
    29.578   364.594     0.150
    29.578   653.594     0.150
    29.588   364.594     0.150
    29.588   653.594     0.150
    30.769   373.594     0.150
    30.769   675.594     0.150
    30.769   374.297     0.150
    30.769   439.594     0.150
    31.253   378.594     0.150
    31.253   676.594     0.150
    31.253   378.992     0.150
    31.973   384.594     0.150
    31.973     6.000     0.150
    32.141   388.594     0.150
    32.141     9.000     0.150
    32.456   388.891     0.150
    32.892   393.594     0.150
    32.892    11.000     0.150
    33.763   401.594     0.150
    33.911   403.594     0.150
    33.911   727.594     0.150
    34.285   406.094     0.150
    34.285     9.500     0.150
    34.535   407.594     0.150
    35.156   412.594     0.150
    35.156   743.594     0.150
    35.156  1021.594     0.150
    36.265   422.797     0.150
    36.265   763.594     0.150
    36.265   511.594     0.150
    36.265  1041.594     0.150
    36.735   426.594     0.150
    36.735   770.594     0.150
    36.735   510.992     0.150
    36.735   563.594     0.150
    36.735   908.594     0.150
    37.357   431.594     0.150
    37.357   779.797     0.150
    37.357   431.797     0.150
    37.357   521.297     0.150
    37.411   432.594     0.150
    37.411   780.594     0.150
    37.519   431.594     0.150
    37.519    12.602     0.150
    37.519   775.594     0.150
    37.519   432.391     0.150
    37.519    11.805     0.150
    37.506   434.195     0.150
    37.869   437.195     0.150
    37.963   437.992     0.150
    38.004   438.797     0.150
    38.102   439.492     0.150
    38.518    10.000     0.150
    38.959   444.391     0.150
    38.918   445.594     0.150
    39.753   450.594     0.150
    39.876   450.695     0.150
    40.811   460.594     0.150
    40.811   461.094     0.150
    40.957   460.891     0.150
    40.965   461.594     0.150
    41.287   464.594     0.150
    41.550   465.594     0.150
    41.575   465.891     0.150
    41.655   466.594     0.150
    41.954   470.594     0.150
    42.716   474.594     0.150
    42.716   475.297     0.150
    42.772   476.594     0.150
    42.909   477.594     0.150
    42.909     8.000     0.150
    43.101   478.594     0.150
    43.101     9.000     0.150
    43.101    12.000     0.150
    43.101   588.594     0.150
    43.156   478.297     0.150
    43.474   483.594     0.150
    43.474   871.094     0.150
    43.474   484.094     0.150
    43.607   483.391     0.150
    43.607     7.203     0.150
    43.607   873.594     0.150
    43.960   485.594     0.150
    44.125   486.094     0.150
    43.999   489.594     0.150
    44.074   488.094     0.150
    44.074   882.594     0.150
    46.323   508.594     0.150
    46.388   503.594     0.150
    46.388   908.594     0.150
    46.388   618.594     0.150
    46.761   507.594     0.150
    46.761     7.500     0.150
    46.761   914.594     0.150
    47.065   511.797     0.150
    47.284   628.594     0.150
    47.345   512.594     0.150
    47.703   513.492     0.150
    47.890   515.594     0.150
    48.032   518.797     0.150
    48.032     6.594     0.150
    48.032   935.797     0.150
    48.038   518.594     0.150
    48.038     6.797     0.150
    48.038   935.797     0.150
    48.007   517.594     0.150
    48.068   516.797     0.150
    48.806   524.992     0.150
    48.806   947.594     0.150
    49.083   524.391     0.150
    49.313   528.594     0.150
    49.599   956.594     0.150
    49.858   533.594     0.150
    49.898   533.195     0.150
    49.898   611.594     0.150
    49.898   962.594     0.150
    50.503   538.594     0.150
    51.051   541.594     0.150
    51.555   543.492     0.150
    52.130   550.594     0.150
    52.130   995.594     0.150
    52.195     5.000     0.150
    52.104   550.797     0.150
    52.803   553.594     0.150
    52.803     7.500     0.150
    52.994   556.094     0.150
    52.921   555.594     0.150
    52.999   555.594     0.150
    53.240   556.594     0.150
    53.240  1138.594     0.150
    53.372   558.594     0.150
    53.855   563.594     0.150
    53.767   561.594     0.150
    53.911   561.492     0.150
    53.911     7.000     0.150
    53.911    12.305     0.150
    53.935   565.094     0.150
    53.958     7.203     0.150
    53.958     6.703     0.150
    54.006   563.594     0.150
    54.006  1141.594     0.150
    54.223   564.594     0.150
    54.433   567.891     0.150
    54.433     4.805     0.150
    54.651   568.594     0.150
    54.652   568.594     0.150
    54.652     6.500     0.150
    54.640   567.992     0.150
    54.839   567.594     0.150
    54.949   572.594     0.150
    55.240   693.594     0.150
    55.548   574.195     0.150
    55.588   574.594     0.150
    55.768   574.297     0.150
    55.768    10.297     0.150
    55.804   574.695     0.150
    55.804     5.898     0.150
    55.804     6.195     0.150
    56.193   578.594     0.150
    56.213   578.094     0.150
    56.213     6.500     0.150
    56.213   711.094     0.150
    56.260     8.000     0.150
    56.260     7.398     0.150
    56.314   580.094     0.150
    56.314     6.398     0.150
    56.537   582.594     0.150
    56.537     5.000     0.150
    56.542   580.094     0.150
    56.635   582.594     0.150
    56.635     6.000     0.150
    56.747   582.594     0.150
    56.815   582.094     0.150
    56.815    12.000     0.150
    56.818   583.594     0.150
    56.870   582.594     0.150
    56.870     6.000     0.150
    57.014   584.594     0.150
    57.028   583.594     0.150
    57.028   584.094     0.150
    57.275   586.391     0.150
    57.275     6.703     0.150
    57.275   719.594     0.150
    57.549   588.094     0.150
    57.620   588.094     0.150
    57.720   589.594     0.150
    57.779   589.492     0.150
    57.779     7.305     0.150
    57.819   591.594     0.150
    57.835   592.094     0.150
    57.892   590.594     0.150
    57.892     6.297     0.150
    58.138   593.594     0.150
    58.124   592.594     0.150
    58.124     6.000     0.150
    58.237   592.594     0.150
    58.371   593.594     0.150
    58.502   596.391     0.150
    58.674   595.594     0.150
    58.674   595.992     0.150
    58.669   595.594     0.150
    58.684   596.297     0.150
    58.758   597.594     0.150
    58.758     5.000     0.150
    58.788   598.492     0.150
    58.808   595.992     0.150
    58.992   598.594     0.150
    59.040   597.594     0.150
    59.040     8.500     0.150
    59.100   598.391     0.150
    59.316   601.992     0.150
    59.393   601.797     0.150
    59.432   601.094     0.150
    59.424   602.094     0.150
    59.444     5.797     0.150
    59.489   601.594     0.150
    59.524   602.391     0.150
    59.594   602.891     0.150
    59.601   603.094     0.150
    59.610   603.797     0.150
    59.755   602.797     0.150
    59.756   604.992     0.150
    59.756     6.805     0.150
    59.757   602.695     0.150
    59.788   603.391     0.150
    59.906   603.695     0.150
    59.906   603.695     0.150
    59.980   604.297     0.150
    59.980     6.695     0.150
    60.103   606.695     0.150
    60.115   606.297     0.150
    60.277   604.594     0.150
    60.320   606.391     0.150
    60.351   606.555     0.150
    60.405   606.992     0.150
    60.417   607.594     0.150
    60.417   606.992     0.150
    60.502   607.383     0.150
    60.508   608.992     0.150
    60.519   607.094     0.150
    60.557   607.891     0.150
    60.619   609.492     0.150
    60.675   609.797     0.150
    60.664   610.297     0.150
    60.864   609.594     0.150
    60.946   611.297     0.150
    61.006   610.891     0.150
    61.012   610.672     0.150
    61.035   611.297     0.150
    61.041   611.094     0.150
    61.065   612.492     0.150
    61.134   613.195     0.150
    61.338   615.594     0.150
    61.394   613.492     0.150
    61.430   618.391     0.150
    61.533   614.094     0.150
    61.604   615.391     0.150
    61.796   616.094     0.150
    61.841   616.695     0.150
    62.013   618.695     0.150
    62.031   620.195     0.150
    62.168   620.594     0.150
    62.210   620.094     0.150
    62.245   622.594     0.150
    62.349   619.133     0.150
    62.354   619.992     0.150
    62.355   620.594     0.150
    62.407   620.891     0.150
    62.415   622.195     0.150
    62.465   621.195     0.150
    62.507   621.094     0.150
    62.524   621.594     0.150
    62.565   621.695     0.150
    62.597   620.992     0.150
    62.757   624.391     0.150
    62.789   622.391     0.150
    62.830   624.055     0.150
    62.857   624.094     0.150
    62.873   623.695     0.150
    62.902   623.594     0.150
    62.917   622.891     0.150
    62.934   623.297     0.150
    62.950   624.891     0.150
    63.019   624.664     0.150
    63.035   623.844     0.150
    63.045   626.094     0.150
    63.101   626.594     0.150
    63.124   624.695     0.150
    63.186   625.195     0.150
    63.207   626.594     0.150
    63.227   625.891     0.150
    63.348   627.492     0.150
    63.367   626.297     0.150
    63.355   629.391     0.150
    63.366   629.195     0.150
    63.411   627.594     0.150
    63.412   627.742     0.150
    63.429   626.414     0.150
    63.488   627.023     0.150
    63.502   629.094     0.150
    63.538   626.594     0.150
    63.572   627.594     0.150
    63.555   629.594     0.150
    63.574   627.094     0.150
    63.593   628.594     0.150
    63.599   629.391     0.150
    63.625   627.945     0.150
    63.628   629.797     0.150
    63.735   628.797     0.150
    63.734   627.531     0.150
    63.757   628.156     0.150
    63.804   629.484     0.150
    63.959   630.695     0.150
    64.034   632.797     0.150
    64.029   631.094     0.150
    64.037   630.992     0.150
    64.322   632.695     0.150
    64.511   634.492     0.150
    64.599   634.992     0.150
    64.635   634.797     0.150
    64.802   636.594     0.150
    64.843   636.492     0.150
    64.968   637.594     0.150
    65.042   639.594     0.150
    65.128   638.391     0.150
    65.243   639.695     0.150
    65.102   639.297     0.150
    65.727   642.695     0.150
    65.779   642.891     0.150
    67.508   653.492     0.150
    68.022   658.297     0.150
    68.806   660.594     0.150
    68.905   664.391     0.150
    70.746   674.594     0.150
    70.944   675.695     0.150
    71.876   681.594     0.150
    72.270   683.891     0.150
    72.666   686.797     0.150
    72.693   687.297     0.150
    73.794   693.492     0.150
    73.845   693.695     0.150
    73.865   693.891     0.150
    73.978   693.594     0.150
    74.165   694.297     0.150
    74.237   696.695     0.150
    74.314   696.094     0.150
    74.333   695.195     0.150
    74.309   696.594     0.150
    74.470   695.594     0.150
    74.617   698.594     0.150
    75.704   703.594     0.150
    76.352   707.891     0.150
    76.352   707.797     0.150
    76.457   708.594     0.150
    76.614   710.594     0.150
    76.934   711.594     0.150
    77.780   715.391     0.150
    77.804   716.594     0.150
    78.164   718.594     0.150
    78.095   716.594     0.150
    78.095   724.594     0.150
    78.285   714.594     0.150
    78.834   721.594     0.150
    79.201   724.594     0.150
    79.605   724.797     0.150
    79.605    10.797     0.150
    80.391   730.797     0.150
    80.548   730.391     0.150
    81.763   736.594     0.150
    82.542   741.094     0.150
    82.543   741.797     0.150
    82.568   740.992     0.150
    82.727   741.594     0.150
    82.876   743.391     0.150
    84.534   751.094     0.150
    85.069   752.992     0.150
    86.370   760.594     0.150
    86.370     9.000     0.150
    86.771   765.094     0.150
    87.296   764.594     0.150
    87.707   766.594     0.150
    87.986   766.594     0.150
    88.278   768.594     0.150
    88.616   772.695     0.150
    88.675   770.594     0.150
    89.083   772.594     0.150
    89.186   774.594     0.150
    90.012   776.594     0.150
    91.011   782.594     0.150
    91.830   786.297     0.150
    91.830     7.094     0.150
    94.839   800.492     0.150
   131.364  1148.594     0.150
   147.246  1179.094     0.150
   152.395  1183.195     0.150
   152.395  1192.797     0.150
     0.562    11.148     0.150
     0.562    18.047     0.150
     1.130    22.547     0.150
     1.130    36.848     0.150
     1.137    22.547     0.150
     1.137    36.848     0.150
     1.929    33.246     0.150
     1.929    35.246     0.150
     1.929    60.148     0.150
     2.379    41.148     0.150
     2.379    44.547     0.150
     2.379    74.348     0.150
     2.676    44.348     0.150
     2.676    49.648     0.150
     2.676    77.547     0.150
     2.676    85.148     0.150
     3.113    50.348     0.150
     3.113    56.348     0.150
     3.113    96.848     0.150
     3.282    61.047     0.150
     3.282   103.047     0.150
     3.647    58.047     0.150
     3.647    66.848     0.150
     3.647   101.047     0.150
     4.169    65.246     0.150
     4.169    75.047     0.150
     4.169   129.848     0.150
     4.557    70.945     0.150
     4.557   120.848     0.150
     4.557   142.547     0.150
     5.473    83.547     0.150
     5.473    98.848     0.150
     5.473   142.547     0.150
     5.473   170.547     0.150
     5.612   102.348     0.150
     5.612   147.348     0.150
     5.612   175.848     0.150
     6.070   186.246     0.150
     6.588   205.148     0.150
     6.588   207.246     0.150
     7.723   240.148     0.150
     7.920   140.047     0.150
     7.920   199.047     0.150
     8.045   252.445     0.150
     8.054   252.047     0.150
     9.038   279.547     0.150
     0.296     6.672     0.150
     0.296     6.375     0.150
     1.275    23.672     0.150
     1.276    23.773     0.150
     1.276    39.672     0.150
     1.993    33.172     0.150
     1.993    34.172     0.150
     2.027    34.172     0.150
     2.027    62.875     0.150
     2.465    39.672     0.150
     2.465    40.375     0.150
     2.465    43.969     0.150
     2.465    74.273     0.150
     2.492    41.672     0.150
     2.492    45.172     0.150
     2.492    78.273     0.150
     2.708    44.875     0.150
     2.708    49.773     0.150
     2.708    86.172     0.150
     3.522    56.172     0.150
     3.522    64.172     0.150
     3.522   108.672     0.150
     3.806    60.570     0.150
     3.806    67.672     0.150
     3.862    59.672     0.150
     3.862    60.273     0.150
     3.862    69.672     0.150
     3.862   119.172     0.150
     3.862    60.570     0.150
     3.862   119.375     0.150
     4.246    65.672     0.150
     4.246    77.070     0.150
     4.246   132.375     0.150
     4.798    73.672     0.150
     4.798    86.375     0.150
     4.798    88.672     0.150
     4.798   149.672     0.150
     4.798   152.172     0.150
     5.313    79.672     0.150
     5.313    97.070     0.150
     5.313    79.875     0.150
     5.313    95.172     0.150
     5.313   140.172     0.150
     5.313   166.672     0.150
     5.474    82.773     0.150
     5.474   100.172     0.150
     5.474   172.672     0.150
     5.561    84.172     0.150
     6.051    90.469     0.150
     6.675    99.070     0.150
     6.675   208.672     0.150
     7.087   103.469     0.150
     7.087   180.875     0.150
     7.087   217.969     0.150
     7.728   111.773     0.150
     7.728   196.070     0.150
     7.786   114.672     0.150
     7.786   199.172     0.150
     7.786   138.672     0.150
     8.064   120.672     0.150
     9.126   133.875     0.150
     9.126   133.672     0.150
     9.768   142.172     0.150
     9.768   172.375     0.150
     9.768   306.172     0.150
    10.252   147.672     0.150
    10.252   318.172     0.150
    10.706   151.375     0.150
    10.706   267.273     0.150
    10.706   331.273     0.150
    10.762   155.672     0.150
    10.762   155.875     0.150
    11.134   160.672     0.150
    11.134   345.375     0.150
    11.312   162.172     0.150
    11.312   351.672     0.150
    12.147   301.969     0.150
    13.438   421.570     0.150
    13.705   194.070     0.150
    14.183   347.570     0.150
    14.183   443.570     0.150
    14.089   202.469     0.150
    14.624   455.672     0.150
    15.269   478.672     0.150
    15.275   377.172     0.150
    15.267   215.672     0.150
    15.267   220.672     0.150
    15.267   400.672     0.150
    15.401   482.969     0.150
    16.365   226.570     0.150
    16.365   513.172     0.150
    16.356   230.672     0.150
    16.356   237.672     0.150
    16.663   237.172     0.150
    16.663   414.672     0.150
    16.877   237.672     0.150
    17.915   250.672     0.150
    17.915   452.672     0.150
    18.033   252.672     0.150
    19.304   267.969     0.150
    19.950   273.672     0.150
    19.950   274.570     0.150
    20.148   274.672     0.150
    20.451   279.570     0.150
    20.521   277.672     0.150
    20.521   277.773     0.150
    20.985   284.672     0.150
    20.985   520.672     0.150
    21.710   295.672     0.150
    21.776   292.672     0.150
    21.776   293.570     0.150
    22.677   303.672     0.150
    23.018   307.273     0.150
    23.447   310.672     0.150
    23.450   310.773     0.150
    23.493   306.672     0.150
    23.493   307.375     0.150
    23.570   310.672     0.150
    23.570   310.773     0.150
    23.900   313.469     0.150
    23.962   313.773     0.150
    24.083   314.875     0.150
    24.250   317.469     0.150
    24.270   315.672     0.150
    24.381   315.773     0.150
    24.599   322.273     0.150
    24.862   323.672     0.150
    25.004   323.469     0.150
    25.195   324.672     0.150
    25.643   330.672     0.150
    25.697   331.875     0.150
    26.220   335.172     0.150
    27.003   341.773     0.150
    27.591   349.469     0.150
    27.591   633.469     0.150
    29.115   363.672     0.150
    30.054   369.070     0.150
    30.054   666.672     0.150
    30.667   375.469     0.150
    30.667   676.672     0.150
    30.667   796.672     0.150
    30.679   377.672     0.150
    30.679   671.672     0.150
    31.247   381.672     0.150
    31.247     7.203     0.150
    31.247   688.672     0.150
    31.247   702.672     0.150
    31.247   797.672     0.150
    31.678   382.672     0.150
    31.678   695.672     0.150
    31.876   384.969     0.150
    31.876     4.703     0.150
    31.876   456.672     0.150
    31.876   550.672     0.150
    31.876   696.672     0.150
    31.876   821.672     0.150
    32.249   388.672     0.150
    32.249     3.000     0.150
    32.249     7.000     0.150
    32.888   398.070     0.150
    33.379   399.672     0.150
    33.379   473.672     0.150
    33.379   719.672     0.150
    33.695   404.672     0.150
    34.419   407.672     0.150
    34.419   408.570     0.150
    36.197   422.672     0.150
    36.197   423.273     0.150
    36.368   426.352     0.150
    36.659   429.289     0.150
    36.742   429.914     0.150
    36.932   431.250     0.150
    37.025   432.492     0.150
    37.126   433.234     0.150
    37.159   433.273     0.150
    37.186   432.695     0.150
    37.222   434.453     0.150
    37.259   434.531     0.150
    37.786   438.672     0.150
    37.791   438.828     0.150
    37.976   437.672     0.150
    37.976   786.672     0.150
    38.053   440.273     0.150
    38.053   790.672     0.150
    38.986   447.672     0.150
    39.857   454.172     0.150
    40.042   456.672     0.150
    40.042   824.672     0.150
    40.212   455.672     0.150
    40.212   559.672     0.150
    40.378   458.375     0.150
    40.635   460.344     0.150
    41.790   470.773     0.150
    41.790   470.672     0.150
    41.956   468.969     0.150
    41.956     5.500     0.150
    41.956   572.969     0.150
    42.289   472.672     0.150
    42.289     6.000     0.150
    42.289   576.672     0.150
    42.289   586.672     0.150
    42.289   852.672     0.150
    42.289   858.672     0.150
    42.289  1042.672     0.150
    42.289  1072.672     0.150
    42.435   474.172     0.150
    42.554   476.281     0.150
    43.040   480.266     0.150
    43.073   480.453     0.150
    43.013   481.672     0.150
    43.013   582.672     0.150
    43.013   869.672     0.150
    43.013  1054.672     0.150
    43.013  1080.672     0.150
    43.086   479.672     0.150
    43.086     5.000     0.150
    43.086   580.672     0.150
    43.086   866.672     0.150
    43.086  1071.672     0.150
    43.146   480.773     0.150
    43.146   587.773     0.150
    43.146   591.672     0.150
    43.146   864.672     0.150
    43.146  1056.672     0.150
    43.146  1076.672     0.150
    43.093   483.172     0.150
    43.275   480.570     0.150
    43.578   486.172     0.150
    43.578   882.672     0.150
    43.722   485.273     0.150
    44.042   487.570     0.150
    44.069   486.672     0.150
    44.286   489.125     0.150
    44.439   489.875     0.150
    44.439     4.695     0.150
    44.828   494.969     0.150
    44.870   494.672     0.150
    44.889   892.672     0.150
    45.309   498.055     0.150
    45.453   604.672     0.150
    45.453  1094.672     0.150
    46.145   506.672     0.150
    46.450   507.672     0.150
    46.918   511.320     0.150
    47.129   511.172     0.150
    47.081   513.672     0.150
    47.081     3.000     0.150
    47.330   515.469     0.150
    47.330   600.469     0.150
    47.330   931.469     0.150
    47.452   514.672     0.150
    47.494   514.672     0.150
    47.494   628.672     0.150
    47.494   923.672     0.150
    47.647   517.773     0.150
    47.776     5.203     0.150
    47.776   601.672     0.150
    47.776   937.672     0.150
    47.781   513.469     0.150
    47.781     5.203     0.150
    47.781   601.672     0.150
    47.781   937.672     0.150
    47.971   517.672     0.150
    47.971     5.797     0.150
    47.971   932.672     0.150
    49.059   528.469     0.150
    49.059   956.672     0.150
    49.139   528.672     0.150
    49.139   955.672     0.150
    49.201   526.773     0.150
    49.413   528.570     0.150
    49.498   529.234     0.150
    49.466   528.672     0.150
    49.466   644.672     0.150
    49.534   532.672     0.150
    49.534     5.602     0.150
    50.252   539.672     0.150
    50.979   539.883     0.150
    51.040   979.672     0.150
    51.798   549.672     0.150
    52.180     5.000     0.150
    52.180   668.672     0.150
    52.180   992.672     0.150
    52.180  1137.672     0.150
    52.301   552.859     0.150
    52.376   551.672     0.150
    52.383   550.672     0.150
    52.383   672.672     0.150
    52.383   996.672     0.150
    52.427   554.672     0.150
    52.906   555.672     0.150
    52.906  1008.672     0.150
    52.923   557.672     0.150
    53.176   560.672     0.150
    53.529   560.375     0.150
    53.823   563.672     0.150
    53.965   563.375     0.150
    53.965     4.594     0.150
    53.997   564.672     0.150
    54.024   563.375     0.150
    54.024     4.594     0.150
    54.030   563.969     0.150
    54.030   633.172     0.150
    54.030   691.672     0.150
    54.030  1017.672     0.150
    54.030  1026.672     0.150
    54.082   566.672     0.150
    54.257     3.000     0.150
    54.324   566.672     0.150
    54.531   568.672     0.150
    54.634   570.172     0.150
    54.646   569.672     0.150
    54.758   570.672     0.150
    54.962     4.500     0.150
    54.996   571.273     0.150
    55.369   572.672     0.150
    55.451   572.672     0.150
    55.786   578.672     0.150
    55.946   577.875     0.150
    55.946     5.000     0.150
    55.996   577.969     0.150
    55.915   580.672     0.150
    56.027   578.672     0.150
    56.212   580.672     0.150
    56.357   581.672     0.150
    56.357     4.000     0.150
    56.375   580.969     0.150
    56.375     4.500     0.150
    56.375   710.672     0.150
    56.413   581.469     0.150
    56.622   583.875     0.150
    56.630   582.672     0.150
    56.653   583.375     0.150
    56.653     5.000     0.150
    56.653   714.773     0.150
    56.940   584.672     0.150
    57.067   586.172     0.150
    57.067     4.797     0.150
    57.067  1068.672     0.150
    57.360   587.672     0.150
    57.436   589.172     0.150
    57.436     4.500     0.150
    57.504   589.672     0.150
    57.606   589.969     0.150
    57.606     4.703     0.150
    57.717   591.172     0.150
    57.717     5.000     0.150
    57.770   591.672     0.150
    57.875   591.672     0.150
    57.968   592.570     0.150
    57.968     4.500     0.150
    58.035   593.469     0.150
    58.032   593.148     0.150
    58.083   592.672     0.150
    58.124   592.672     0.150
    58.238   594.375     0.150
    58.393   592.672     0.150
    58.393  1080.672     0.150
    58.471   596.070     0.150
    58.558   596.273     0.150
    58.611   595.609     0.150
    58.633   600.375     0.150
    58.655   597.070     0.150
    58.655     4.602     0.150
    58.638   596.672     0.150
    58.708   596.672     0.150
    58.737   596.672     0.150
    58.826   599.375     0.150
    58.819   599.172     0.150
    58.839   599.672     0.150
    58.909   598.773     0.150
    58.932   602.875     0.150
    58.962   597.672     0.150
    59.015   600.773     0.150
    59.065   600.492     0.150
    59.132   601.469     0.150
    59.132   726.375     0.150
    59.145   601.070     0.150
    59.145     4.703     0.150
    59.192   599.672     0.150
    59.192     6.102     0.150
    59.178   601.172     0.150
    59.260   605.172     0.150
    59.219   602.570     0.150
    59.241   601.672     0.150
    59.288   601.062     0.150
    59.288     5.039     0.150
    59.255   602.273     0.150
    59.307   602.969     0.150
    59.366   602.562     0.150
    59.402   603.070     0.150
    59.402     4.898     0.150
    59.407   602.516     0.150
    59.398   602.672     0.150
    59.433   602.672     0.150
    59.433     4.398     0.150
    59.433  1092.672     0.150
    59.442   602.672     0.150
    59.442     5.000     0.150
    59.429   603.773     0.150
    59.475   602.992     0.150
    59.517   604.469     0.150
    59.530   604.375     0.150
    59.680   607.875     0.150
    59.675   604.773     0.150
    59.649   605.375     0.150
    59.657   605.070     0.150
    59.707   605.172     0.150
    59.707   736.172     0.150
    59.717   605.672     0.150
    59.717     3.398     0.150
    59.729   605.875     0.150
    59.740   605.875     0.150
    59.764   605.562     0.150
    59.785   605.969     0.150
    59.831   603.672     0.150
    59.865   605.969     0.150
    59.919   606.570     0.150
    59.919   739.570     0.150
    59.936   605.594     0.150
    59.993   606.672     0.150
    59.993     4.000     0.150
    60.017   609.062     0.150
    60.015   606.273     0.150
    60.026   606.172     0.150
    60.006   607.570     0.150
    60.073   608.172     0.150
    60.137   607.172     0.150
    60.236   608.273     0.150
    60.275   609.273     0.150
    60.382   608.195     0.150
    60.390   610.555     0.150
    60.375   610.273     0.150
    60.412   609.469     0.150
    60.412     4.000     0.150
    60.533   610.375     0.150
    60.520   609.672     0.150
    60.564   610.070     0.150
    60.546   611.570     0.150
    60.637   612.172     0.150
    60.671   609.570     0.150
    60.703   610.961     0.150
    60.769   611.469     0.150
    60.786   612.375     0.150
    60.796   612.672     0.150
    60.868   612.273     0.150
    60.940   614.375     0.150
    60.993   612.672     0.150
    61.073   613.469     0.150
    61.126   614.172     0.150
    61.160   615.875     0.150
    61.221   614.273     0.150
    61.224   614.305     0.150
    61.236   614.781     0.150
    61.237   615.375     0.150
    61.259   614.570     0.150
    61.255   615.672     0.150
    61.297   614.672     0.150
    61.355   615.469     0.150
    61.483   618.070     0.150
    61.582   621.672     0.150
    61.574   618.273     0.150
    61.753   618.672     0.150
    61.778   618.375     0.150
    61.775   619.773     0.150
    61.866   619.430     0.150
    61.968   621.375     0.150
    62.195   621.773     0.150
    62.398   623.070     0.150
    62.600   623.969     0.150
    62.591   622.672     0.150
    62.649   624.672     0.150
    62.798   622.875     0.150
    62.805   624.672     0.150
    62.831   624.773     0.150
    63.014   627.195     0.150
    63.020   625.969     0.150
    63.034   626.773     0.150
    63.131   628.172     0.150
    63.138   626.969     0.150
    63.139   628.375     0.150
    63.179   628.703     0.150
    63.207   626.969     0.150
    63.219   627.070     0.150
    63.215   627.422     0.150
    63.299   628.172     0.150
    63.353   628.375     0.150
    63.421   628.773     0.150
    63.466   627.969     0.150
    63.530   630.398     0.150
    63.590   629.383     0.150
    63.585   631.570     0.150
    63.617   631.773     0.150
    63.658   629.969     0.150
    63.654   630.570     0.150
    63.596   633.273     0.150
    63.800   629.570     0.150
    63.810   631.375     0.150
    63.903   630.625     0.150
    63.927   631.219     0.150
    64.024   632.672     0.150
    64.044   633.070     0.150
    64.089   633.969     0.150
    64.102   633.773     0.150
    64.197   634.570     0.150
    64.194   634.422     0.150
    64.206   633.969     0.150
    64.278   634.672     0.150
    64.285   635.570     0.150
    64.502   636.969     0.150
    64.570   636.375     0.150
    64.609   636.570     0.150
    64.769   638.070     0.150
    64.764   639.969     0.150
    64.903   638.773     0.150
    64.930   640.594     0.150
    64.930     5.680     0.150
    64.975   639.672     0.150
    65.013   639.570     0.150
    65.249   642.859     0.150
    65.379   642.562     0.150
    65.367   641.969     0.150
    65.427   643.578     0.150
    65.473   643.273     0.150
    65.532   643.492     0.150
    65.568   643.812     0.150
    65.840   645.742     0.150
    65.853   644.883     0.150
    65.852   646.633     0.150
    65.971   646.375     0.150
    66.016   646.570     0.150
    66.122   648.125     0.150
    66.960   653.211     0.150
    66.960     5.555     0.150
    67.341   656.148     0.150
    67.536   656.969     0.150
    67.740   657.172     0.150
    67.872   662.672     0.150
    67.872     6.500     0.150
    67.872     9.000     0.150
    67.872   805.672     0.150
    67.872   809.672     0.150
    68.150   660.969     0.150
    68.150     5.500     0.150
    68.150   687.875     0.150
    69.341   666.672     0.150
    69.484   670.078     0.150
    69.484     6.000     0.150
    70.130   673.695     0.150
    70.538   675.523     0.150
    70.538     6.398     0.150
    70.555   676.531     0.150
    71.265   680.562     0.150
    71.826   683.125     0.150
    71.826     6.000     0.150
    72.181   686.062     0.150
    72.375   686.844     0.150
    72.533  1253.672     0.150
    72.611   688.781     0.150
    73.022   690.789     0.150
    73.521   694.094     0.150
    73.555   694.648     0.150
    73.555     5.961     0.150
    73.573   692.750     0.150
    73.573     5.516     0.150
    73.575   694.219     0.150
    73.575     5.055     0.150
    73.938   698.703     0.150
    74.233   698.570     0.150
    74.426   699.469     0.150
    74.426     6.055     0.150
    74.441   700.109     0.150
    74.441     5.781     0.150
    74.361   697.672     0.150
    74.549   701.609     0.150
    74.735   701.164     0.150
    74.735     5.930     0.150
    74.754   700.875     0.150
    75.124   702.859     0.150
    75.439   705.062     0.150
    75.486   705.922     0.150
    76.152   709.414     0.150
    76.152     5.867     0.150
    76.170   708.062     0.150
    76.362   710.148     0.150
    76.362     6.281     0.150
    76.664   710.859     0.150
    76.664     5.133     0.150
    76.811   713.469     0.150
    76.811     5.820     0.150
    77.182   714.992     0.150
    77.261   715.414     0.150
    77.261     5.555     0.150
    77.261   715.703     0.150
    77.324   716.320     0.150
    77.395   715.172     0.150
    77.525   715.672     0.150
    77.527   715.469     0.150
    77.844   718.172     0.150
    77.969   719.719     0.150
    78.456   721.281     0.150
    78.626   721.828     0.150
    79.047   725.078     0.150
    80.089   731.094     0.150
    81.122   735.070     0.150
    81.122   917.375     0.150
    81.122  1368.570     0.150
    81.296   737.523     0.150
    81.296     5.688     0.150
    82.034   740.242     0.150
    82.135   739.781     0.150
    82.704   743.383     0.150
    82.704     5.078     0.150
    83.451   748.172     0.150
    85.441   758.070     0.150
    85.541   756.672     0.150
    86.914   764.172     0.150
    87.225   765.172     0.150
    87.839   769.289     0.150
    87.962   769.898     0.150
    87.986   770.102     0.150
    87.986     5.102     0.150
    87.890   769.070     0.150
    88.288   770.672     0.150
    88.346   773.375     0.150
    88.461   772.578     0.150
    88.461     5.062     0.150
    88.372   773.773     0.150
    88.592   773.375     0.150
    89.223   775.773     0.150
    90.427   781.172     0.150
   137.708  1165.109     0.150
   139.413  1164.070     0.150
   140.680  1170.672     0.150
   145.474  1179.672     0.150
   146.466  1179.273     0.150
   148.003  1185.969     0.150
   151.681  1188.672     0.150
   154.631  1192.875     0.150
     0.324     6.719     0.150
     0.324    11.320     0.150
     1.244    22.820     0.150
     1.244    39.922     0.150
     1.245    22.820     0.150
     1.245    24.117     0.150
     1.245    39.922     0.150
     2.023    36.320     0.150
     2.023    62.320     0.150
     2.447    40.719     0.150
     2.447    43.320     0.150
     2.447    74.922     0.150
     2.493    42.023     0.150
     2.493    45.320     0.150
     2.493    79.117     0.150
     2.675    49.117     0.150
     2.675    83.523     0.150
     3.831    60.320     0.150
     3.831    69.117     0.150
     3.831   120.023     0.150
     4.214    65.922     0.150
     4.214    77.320     0.150
     4.214   132.320     0.150
     4.767    86.117     0.150
     4.767   149.117     0.150
     5.285    96.719     0.150
     5.285   164.617     0.150
     5.441    82.320     0.150
     5.441    99.320     0.150
     5.441   171.117     0.150
     7.701   239.719     0.150
     0.317     6.461     0.150
     1.251    23.367     0.150
     1.251    38.961     0.150
     1.253    23.367     0.150
     1.253    38.961     0.150
     2.451    41.461     0.150
     2.451    44.164     0.150
     2.451    74.867     0.150
     2.492    41.961     0.150
     2.492    45.367     0.150
     2.492    79.164     0.150
     2.573    47.961     0.150
     2.573    81.961     0.150
     2.684    45.664     0.150
     2.684    49.664     0.150
     2.684    84.461     0.150
     3.839    60.961     0.150
     3.839    70.961     0.150
     3.839   121.164     0.150
     4.222    66.164     0.150
     4.222    77.164     0.150
     4.222   130.664     0.150
     4.775    72.367     0.150
     4.775    86.867     0.150
     4.775   149.164     0.150
     5.292    96.961     0.150
     5.292   166.164     0.150
     5.449    82.766     0.150
     5.449   100.164     0.150
     5.449   142.867     0.150
     5.449   171.461     0.150
     0.318     6.422     0.150
     0.318    10.125     0.150
     1.254    23.523     0.150
     1.254    40.023     0.150
     2.014    36.922     0.150
     2.014    62.922     0.150
     2.453    41.422     0.150
     2.453    44.219     0.150
     2.453    70.320     0.150
     2.453    75.125     0.150
     2.490    41.922     0.150
     2.490    45.719     0.150
     2.490    79.125     0.150
     2.574    48.320     0.150
     2.574    74.625     0.150
     2.574    81.719     0.150
     2.684    49.320     0.150
     2.684    84.422     0.150
     3.840    60.625     0.150
     3.840    71.023     0.150
     3.840   120.422     0.150
     4.222    77.023     0.150
     4.222   113.219     0.150
     4.222   132.422     0.150
     4.776    74.625     0.150
     4.776    85.625     0.150
     4.776   149.422     0.150
     5.291   166.320     0.150
     5.449   100.219     0.150
     5.449   171.719     0.150
     0.281     6.182     0.150
     0.281     9.982     0.150
     1.284    23.682     0.150
     1.284    40.082     0.150
     1.285    23.682     0.150
     1.285    25.482     0.150
     1.285    40.082     0.150
     1.985    36.082     0.150
     2.466    39.982     0.150
     2.466    43.582     0.150
     2.466    75.281     0.150
     2.499    41.383     0.150
     2.499    44.883     0.150
     2.499    78.482     0.150
     2.721    50.582     0.150
     2.721    84.482     0.150
     3.873    69.582     0.150
     3.873   121.182     0.150
     4.259    77.383     0.150
     4.259   133.182     0.150
     4.808    87.482     0.150
     4.808   149.682     0.150
     5.328    80.883     0.150
     5.328   166.883     0.150
     5.487   100.682     0.150
     5.487   144.582     0.150
     5.487   172.182     0.150
     0.323     6.867     0.150
     1.251    23.066     0.150
     1.251    39.566     0.150
     1.252    23.066     0.150
     1.252    39.566     0.150
     2.015    34.367     0.150
     2.015    35.668     0.150
     2.015    61.668     0.150
     2.456    40.270     0.150
     2.456    43.367     0.150
     2.456    74.270     0.150
     2.486    41.270     0.150
     2.486    44.969     0.150
     2.486    78.770     0.150
     2.572    42.969     0.150
     2.572    47.469     0.150
     2.572    72.469     0.150
     2.572    81.066     0.150
     2.681    45.066     0.150
     2.681    48.770     0.150
     2.681    83.270     0.150
     3.838    59.469     0.150
     3.838    69.668     0.150
     3.838   101.668     0.150
     3.838   120.066     0.150
     4.219    65.668     0.150
     4.219    76.270     0.150
     4.219   132.566     0.150
     4.774    73.969     0.150
     4.774    86.168     0.150
     4.774    88.270     0.150
     4.774   149.367     0.150
     5.286    82.168     0.150
     5.286    96.367     0.150
     5.286   140.367     0.150
     5.286   164.969     0.150
     5.446    82.770     0.150
     5.446    98.969     0.150
     5.446   170.969     0.150
     6.648    99.867     0.150
     6.648   120.969     0.150
     6.648   206.270     0.150
     7.701   112.969     0.150
     7.701   240.168     0.150
     7.758   115.270     0.150
     7.758   239.969     0.150
     8.036   250.168     0.150
     9.098   283.168     0.150
     0.284     6.309     0.150
     0.284     9.909     0.150
     1.268    23.409     0.150
     1.268    39.508     0.150
     1.270    23.409     0.150
     1.270    24.208     0.150
     1.270    39.508     0.150
     2.002    34.208     0.150
     2.002    35.409     0.150
     2.002    61.708     0.150
     2.448    41.108     0.150
     2.448    43.508     0.150
     2.448    75.909     0.150
     2.513    41.708     0.150
     2.513    46.508     0.150
     2.513    78.708     0.150
     2.590    47.309     0.150
     2.590    81.809     0.150
     2.708    49.309     0.150
     2.708    84.008     0.150
     3.516   109.409     0.150
     3.857    69.708     0.150
     3.857   102.708     0.150
     3.857   121.108     0.150
     4.246    65.708     0.150
     4.246    78.708     0.150
     4.246   133.108     0.150
     4.792    87.008     0.150
     4.792   149.008     0.150
     5.325   167.809     0.150
     0.310     6.588     0.150
     0.310    10.188     0.150
     1.256    23.287     0.150
     1.256    39.287     0.150
     1.258    23.287     0.150
     1.258    39.287     0.150
     2.011    35.988     0.150
     2.011    62.188     0.150
     2.453    41.287     0.150
     2.453    44.188     0.150
     2.453    70.688     0.150
     2.453    75.287     0.150
     2.494    41.988     0.150
     2.494    45.188     0.150
     2.494    78.988     0.150
     2.578    47.688     0.150
     2.578    81.688     0.150
     2.690    43.988     0.150
     2.690    48.787     0.150
     2.690    83.988     0.150
     3.504   109.188     0.150
     3.844    59.988     0.150
     3.844    69.488     0.150
     3.844   121.088     0.150
     4.228    65.688     0.150
     4.228    77.188     0.150
     4.228   113.688     0.150
     4.228   132.287     0.150
     4.780    86.988     0.150
     4.780   129.787     0.150
     4.780   148.988     0.150
     5.298   165.287     0.150
     5.456    81.988     0.150
     5.456    99.988     0.150
     5.456   171.688     0.150
     5.576   168.688     0.150
     0.320     6.672     0.150
     0.320    10.773     0.150
     1.247    23.172     0.150
     1.247    40.070     0.150
     1.248    23.172     0.150
     1.248    40.070     0.150
     2.020    36.773     0.150
     2.020    62.570     0.150
     2.448    40.672     0.150
     2.448    43.875     0.150
     2.448    74.672     0.150
     2.494    41.375     0.150
     2.494    45.570     0.150
     2.494    78.172     0.150
     2.568    47.977     0.150
     2.568    81.875     0.150
     2.679    44.375     0.150
     2.679    48.875     0.150
     2.679    73.672     0.150
     2.679    83.977     0.150
     3.835    60.172     0.150
     3.835    69.375     0.150
     3.835   104.570     0.150
     3.835   120.273     0.150
     4.217    65.172     0.150
     4.217    76.875     0.150
     4.217   131.875     0.150
     4.770   148.570     0.150
     5.290   165.570     0.150
     5.445    81.977     0.150
     5.445    99.273     0.150
     5.445   169.570     0.150
     6.646   206.672     0.150
     0.308     6.017     0.150
     1.270    24.316     0.150
     1.270    41.017     0.150
     1.271    24.316     0.150
     1.271    41.017     0.150
     1.997    36.217     0.150
     1.997    37.217     0.150
     1.997    63.217     0.150
     2.468    40.816     0.150
     2.468    44.816     0.150
     2.468    76.717     0.150
     2.483    45.517     0.150
     2.483    78.117     0.150
     2.591    48.117     0.150
     2.591    82.017     0.150
     2.700    45.417     0.150
     2.700    49.316     0.150
     2.700    85.117     0.150
     3.517   109.417     0.150
     3.857    70.217     0.150
     3.857   120.517     0.150
     4.239    77.717     0.150
     4.239   132.417     0.150
     4.793    88.517     0.150
     4.793   126.417     0.150
     4.793   150.017     0.150
     5.301    96.517     0.150
     5.301   167.417     0.150
     5.465   100.917     0.150
     5.465   171.017     0.150
     6.668   209.017     0.150
     7.715   240.517     0.150
     7.777   241.017     0.150
     0.309     6.268     0.150
     0.309    10.467     0.150
     1.264    24.068     0.150
     1.264    40.367     0.150
     1.265    24.068     0.150
     1.265    40.367     0.150
     2.002    35.068     0.150
     2.002    62.268     0.150
     2.461    40.268     0.150
     2.461    44.367     0.150
     2.461    75.467     0.150
     2.488    41.367     0.150
     2.488    45.668     0.150
     2.488    79.467     0.150
     2.586    48.068     0.150
     2.586    81.867     0.150
     2.696    44.168     0.150
     2.696    50.268     0.150
     2.696    76.568     0.150
     2.696    84.668     0.150
     3.511   109.467     0.150
     3.852    69.467     0.150
     3.852   119.568     0.150
     4.234    66.268     0.150
     4.234    77.367     0.150
     4.234   133.068     0.150
     4.787    87.668     0.150
     4.787   149.768     0.150
     5.300   165.768     0.150
     5.461   100.168     0.150
     5.461   171.367     0.150
     6.663   207.367     0.150
     7.715   240.367     0.150
     7.773   241.068     0.150
     0.613    11.426     0.150
     0.613    19.824     0.150
     0.620    19.824     0.150
     1.209    23.426     0.150
     1.209    24.426     0.150
     1.209    38.824     0.150
     1.209    42.125     0.150
     1.792    34.023     0.150
     1.792    56.125     0.150
     1.792    56.824     0.150
     1.811    32.625     0.150
     1.811    34.227     0.150
     1.811    57.625     0.150
     2.207    36.824     0.150
     2.207    40.023     0.150
     2.207    68.324     0.150
     2.574    46.625     0.150
     2.574    74.625     0.150
     2.574    81.625     0.150
     3.036    50.125     0.150
     3.036    55.227     0.150
     3.334    54.426     0.150
     3.334    61.625     0.150
     3.334   104.824     0.150
     3.979    62.926     0.150
     3.979    72.625     0.150
     3.979   107.727     0.150
     3.979   124.926     0.150
     4.489    71.125     0.150
     4.489    82.625     0.150
     4.489   121.125     0.150
     4.489   142.824     0.150
     4.540    70.523     0.150
     4.540   142.523     0.150
     6.922   217.227     0.150
     0.280     6.117     0.150
     1.281    24.016     0.150
     1.989    34.516     0.150
     2.461    39.516     0.150
     2.461    39.914     0.150
     2.461    39.715     0.150
     2.504    41.715     0.150
     2.504    45.516     0.150
     2.504    79.516     0.150
     2.719    45.516     0.150
     3.528    56.516     0.150
     3.528    64.516     0.150
     3.528   110.516     0.150
     3.869    60.516     0.150
     3.869    61.016     0.150
     3.869    69.516     0.150
     3.869   119.516     0.150
     3.869   121.016     0.150
     4.256    66.617     0.150
     4.804    73.516     0.150
     4.804    74.215     0.150
     4.804    88.516     0.150
     4.804   151.016     0.150
     4.804    74.016     0.150
     4.804   151.516     0.150
     5.329    79.516     0.150
     5.329    80.117     0.150
     5.329   142.414     0.150
     5.329   154.215     0.150
     5.329   168.215     0.150
     5.486    83.414     0.150
     5.486    97.715     0.150
     5.486   172.516     0.150
     5.562    84.117     0.150
     6.053    91.016     0.150
     6.053   155.914     0.150
     6.053   189.516     0.150
     6.686    99.215     0.150
     6.686   209.516     0.150
     7.744   113.516     0.150
     7.744   198.016     0.150
     7.744   241.016     0.150
     7.796   114.516     0.150
     7.796   114.414     0.150
     7.796   139.516     0.150
     7.796   242.516     0.150
     8.076   118.516     0.150
     8.076   250.516     0.150
     9.136   132.016     0.150
     9.136   230.516     0.150
     9.136   131.914     0.150
     9.136   233.516     0.150
     9.136   284.715     0.150
     9.778   141.516     0.150
     9.778   306.117     0.150
    10.262   147.516     0.150
    10.262   260.016     0.150
    10.262   321.016     0.150
    10.773   155.516     0.150
    11.143   161.516     0.150
    11.143   160.016     0.150
    11.143   345.516     0.150
    11.320   162.516     0.150
    13.718   344.516     0.150
    14.099   200.316     0.150
    14.099   438.516     0.150
    15.281   216.715     0.150
    15.281   226.516     0.150
    16.373   231.516     0.150
    16.679   237.016     0.150
    16.893   238.516     0.150
    17.930   252.516     0.150
    18.035   252.266     0.150
    18.035   252.516     0.150
    19.320   268.516     0.150
    19.954   272.516     0.150
    19.954   273.316     0.150
    20.152   275.516     0.150
    20.152   497.516     0.150
    20.467   280.316     0.150
    20.467   508.516     0.150
    20.526   280.516     0.150
    20.526   281.215     0.150
    21.000   285.516     0.150
    21.000   512.516     0.150
    21.591   291.516     0.150
    21.591   522.414     0.150
    21.591   291.715     0.150
    21.716   291.316     0.150
    21.779   293.516     0.150
    21.779   293.617     0.150
    22.693   304.316     0.150
    23.027   307.715     0.150
    23.440   564.516     0.150
    23.500   308.516     0.150
    23.500   309.016     0.150
    23.466   312.016     0.150
    23.577   310.516     0.150
    23.577   311.117     0.150
    23.911   314.516     0.150
    23.911   314.715     0.150
    24.092   315.516     0.150
    24.092   315.715     0.150
    24.279   316.207     0.150
    24.279   316.516     0.150
    24.279   574.516     0.150
    24.297   318.516     0.150
    24.391   318.516     0.150
    24.391   319.316     0.150
    24.615   322.316     0.150
    24.872   321.516     0.150
    25.012   323.516     0.150
    25.116   323.516     0.150
    25.116   324.414     0.150
    25.206   325.516     0.150
    25.330   327.516     0.150
    25.467   326.516     0.150
    25.467   327.016     0.150
    25.658   331.016     0.150
    27.256   345.516     0.150
    27.256   624.516     0.150
    27.607   349.914     0.150
    29.122   363.516     0.150
    30.040   368.715     0.150
    30.040   426.516     0.150
    30.040   550.516     0.150
    30.040   664.516     0.150
    30.040   770.516     0.150
    30.665   375.516     0.150
    30.884   379.004     0.150
    30.884     3.562     0.150
    30.884     6.043     0.150
    31.264   382.516     0.150
    31.264   690.516     0.150
    31.884   385.047     0.150
    31.873   385.336     0.150
    31.873     3.559     0.150
    31.873     4.969     0.150
    31.873   458.016     0.150
    31.873   696.516     0.150
    31.873   804.516     0.150
    31.873   386.016     0.150
    31.873     4.500     0.150
    32.257   391.516     0.150
    32.257   552.516     0.150
    32.257   704.516     0.150
    32.257   777.516     0.150
    32.902   399.215     0.150
    32.902   777.516     0.150
    33.395   472.516     0.150
    33.395   721.516     0.150
    33.395   734.516     0.150
    33.712   403.316     0.150
    33.712   726.516     0.150
    36.329   426.016     0.150
    36.329   512.516     0.150
    36.329   777.715     0.150
    36.381   427.145     0.150
    36.672   429.867     0.150
    36.755   430.484     0.150
    36.946   431.887     0.150
    37.039   433.145     0.150
    37.138   428.566     0.150
    37.138   430.117     0.150
    37.139   433.965     0.150
    37.172   433.965     0.150
    37.200   433.344     0.150
    37.255   430.914     0.150
    37.255   771.117     0.150
    37.255   430.574     0.150
    37.235   434.965     0.150
    37.272   435.207     0.150
    37.798   439.387     0.150
    37.803   439.664     0.150
    37.962   441.516     0.150
    38.069   440.516     0.150
    38.069   534.516     0.150
    38.293   440.516     0.150
    38.897     3.719     0.150
    39.001   449.215     0.150
    39.842   454.164     0.150
    39.842   454.316     0.150
    40.196   457.715     0.150
    40.262   457.316     0.150
    40.227   455.516     0.150
    40.227   562.516     0.150
    40.227   816.516     0.150
    40.282   458.516     0.150
    40.426   458.195     0.150
    40.394   459.516     0.150
    40.394     3.891     0.150
    40.421   461.516     0.150
    40.620   460.246     0.150
    41.061   463.004     0.150
    41.061     3.891     0.150
    41.366   465.426     0.150
    41.366     3.410     0.150
    41.776   470.355     0.150
    41.880   468.516     0.150
    42.284   472.516     0.150
    42.284   573.516     0.150
    42.284   854.516     0.150
    42.539   476.516     0.150
    42.539     3.969     0.150
    42.539   476.246     0.150
    42.539   476.414     0.150
    43.026   481.027     0.150
    43.058   480.855     0.150
    43.017   483.516     0.150
    43.079   480.516     0.150
    43.079   590.016     0.150
    43.079   865.516     0.150
    43.079  1074.516     0.150
    43.141   480.516     0.150
    43.141   866.516     0.150
    43.141   480.004     0.150
    43.141   588.516     0.150
    43.109   483.816     0.150
    43.159   483.145     0.150
    43.159     3.723     0.150
    43.159   483.016     0.150
    43.267   481.117     0.150
    43.583   487.316     0.150
    43.831   485.766     0.150
    44.028   487.504     0.150
    44.055   486.715     0.150
    44.814   494.816     0.150
    44.826   491.926     0.150
    44.826     6.680     0.150
    44.881   494.617     0.150
    44.881   610.516     0.150
    44.881   892.516     0.150
    45.067   496.688     0.150
    45.067   495.914     0.150
    45.294   498.297     0.150
    45.716   502.516     0.150
    45.994   508.016     0.150
    46.465   509.516     0.150
    46.698   508.027     0.150
    46.698     6.566     0.150
    46.760   511.316     0.150
    46.904   510.516     0.150
    46.904   511.316     0.150
    47.080   512.516     0.150
    47.080   624.516     0.150
    47.080   926.516     0.150
    47.329   515.746     0.150
    47.329     3.559     0.150
    47.329     5.551     0.150
    47.329   625.016     0.150
    47.329   932.414     0.150
    47.329   516.016     0.150
    47.329     5.398     0.150
    47.446   514.516     0.150
    47.446   624.516     0.150
    47.494   515.516     0.150
    47.494   609.516     0.150
    47.494   626.516     0.150
    47.494   926.516     0.150
    47.657   514.617     0.150
    47.657   515.414     0.150
    47.963   518.316     0.150
    47.963     4.598     0.150
    47.963   628.516     0.150
    47.963   934.516     0.150
    48.450   527.016     0.150
    48.748   529.516     0.150
    48.899   530.754     0.150
    48.899     4.141     0.150
    48.899     5.961     0.150
    48.899   530.895     0.150
    49.072   528.516     0.150
    49.072   611.016     0.150
    49.072   644.516     0.150
    49.072   958.516     0.150
    49.072  1120.516     0.150
    49.072  1156.516     0.150
    49.137   530.516     0.150
    49.137   608.516     0.150
    49.137   640.516     0.150
    49.137   955.516     0.150
    49.137  1113.516     0.150
    49.403   529.016     0.150
    49.488   530.254     0.150
    49.488     6.652     0.150
    49.464   531.516     0.150
    49.464   648.516     0.150
    49.536   533.516     0.150
    49.823   534.516     0.150
    49.969   534.617     0.150
    50.264   540.516     0.150
    50.502   540.516     0.150
    50.966   541.367     0.150
    50.966     6.707     0.150
    50.970   541.395     0.150
    50.970   540.914     0.150
    51.037   542.516     0.150
    51.037   664.516     0.150
    51.037   981.516     0.150
    51.162   544.516     0.150
    51.220   547.414     0.150
    51.502   546.004     0.150
    51.502     6.070     0.150
    51.771   547.625     0.150
    51.771     5.941     0.150
    51.803   544.066     0.150
    51.834     5.879     0.150
    51.800   550.617     0.150
    51.955     5.359     0.150
    51.956  1215.516     0.150
    51.950   550.316     0.150
    52.176   625.516     0.150
    52.176   673.516     0.150
    52.176   996.516     0.150
    52.286   553.324     0.150
    52.221   552.516     0.150
    52.378   550.516     0.150
    52.378     4.000     0.150
    52.378   622.516     0.150
    52.378   670.516     0.150
    52.378   996.516     0.150
    52.378  1216.516     0.150
    52.897   557.215     0.150
    52.897   680.516     0.150
    52.897  1008.516     0.150
    52.936   558.016     0.150
    53.172   559.016     0.150
    53.292   561.016     0.150
    53.377   560.516     0.150
    53.545   562.516     0.150
    53.608   563.715     0.150
    53.745   564.117     0.150
    53.791   565.016     0.150
    53.819   563.516     0.150
    53.867   564.914     0.150
    53.958   563.914     0.150
    53.958  1020.816     0.150
    53.993   564.016     0.150
    54.018   563.816     0.150
    54.018     8.598     0.150
    54.018  1020.816     0.150
    54.025   564.516     0.150
    54.025   693.516     0.150
    54.025  1017.516     0.150
    54.025  1029.516     0.150
    54.078   566.516     0.150
    54.241   565.516     0.150
    54.241  1019.516     0.150
    54.289   568.516     0.150
    54.298   566.016     0.150
    54.318   567.516     0.150
    54.525   569.414     0.150
    54.613   570.215     0.150
    54.630   570.516     0.150
    54.642   568.516     0.150
    54.647   571.516     0.150
    54.752   570.516     0.150
    54.894   570.516     0.150
    54.926   570.316     0.150
    54.946   572.516     0.150
    54.956     3.898     0.150
    54.956  1034.516     0.150
    55.005   572.637     0.150
    54.991   571.715     0.150
    54.991   635.516     0.150
    54.991  1034.516     0.150
    54.989   571.617     0.150
    54.989  1029.516     0.150
    55.060   573.016     0.150
    55.237   575.516     0.150
    55.261   573.586     0.150
    55.256   572.516     0.150
    55.348   574.664     0.150
    55.326   573.016     0.150
    55.399   575.926     0.150
    55.399     3.719     0.150
    55.399     6.199     0.150
    53.310   562.117     0.150
    55.447   574.516     0.150
    55.536   575.945     0.150
    55.527   575.516     0.150
    55.657   575.316     0.150
    55.742   579.016     0.150
    55.781   579.516     0.150
    55.939   578.016     0.150
    55.939     4.801     0.150
    55.939   636.516     0.150
    55.939  1049.516     0.150
    55.989   577.914     0.150
    55.989  1047.516     0.150
    55.989  1168.516     0.150
    56.021   579.285     0.150
    56.091   580.914     0.150
    56.160   583.117     0.150
    56.241   582.715     0.150
    56.280   581.516     0.150
    56.350     4.000     0.150
    56.355   582.914     0.150
    56.368   581.715     0.150
    56.368     4.102     0.150
    56.368   581.824     0.150
    56.341   581.016     0.150
    56.341  1052.516     0.150
    56.396   580.516     0.150
    56.396  1056.516     0.150
    56.408   583.016     0.150
    56.408     4.699     0.150
    56.581   581.516     0.150
    56.622   583.266     0.150
    56.626   582.516     0.150
    56.646   584.215     0.150
    56.742   584.715     0.150
    56.933   586.316     0.150
    57.059   586.414     0.150
    57.059   640.516     0.150
    57.059  1065.516     0.150
    57.211   588.516     0.150
    57.271   588.516     0.150
    57.271     4.000     0.150
    57.271   587.926     0.150
    57.357   589.715     0.150
    57.383   591.516     0.150
    57.429   589.816     0.150
    57.429     4.500     0.150
    57.429  1068.516     0.150
    57.508   589.715     0.150
    57.508   590.016     0.150
    57.543   589.516     0.150
    57.580   589.074     0.150
    57.599   590.316     0.150
    57.692   589.516     0.150
    57.710   591.617     0.150
    57.710   591.445     0.150
    57.767   590.516     0.150
    57.770   590.516     0.150
    57.824   591.617     0.150
    57.867   591.914     0.150
    57.867     4.602     0.150
    57.866   592.094     0.150
    57.934   592.574     0.150
    57.947   593.016     0.150
    57.961   592.715     0.150
    57.961     1.602     0.150
    57.961     5.102     0.150
    57.961  1070.414     0.150
    57.961  1295.316     0.150
    57.973   592.844     0.150
    57.995   593.074     0.150
    57.997   593.016     0.150
    58.020   593.188     0.150
    58.029   593.316     0.150
    58.029   593.715     0.150
    58.080   592.516     0.150
    58.120   592.516     0.150
    58.090   594.516     0.150
    58.108   593.797     0.150
    58.117   593.555     0.150
    58.197   594.316     0.150
    58.229   594.645     0.150
    58.253   595.117     0.150
    58.237   597.316     0.150
    58.264   594.816     0.150
    58.310   595.215     0.150
    58.345   595.516     0.150
    58.384   595.727     0.150
    58.390   595.516     0.150
    58.390   727.516     0.150
    58.390  1080.516     0.150
    58.441   596.125     0.150
    58.470   596.414     0.150
    58.544   596.695     0.150
    58.550   596.117     0.150
    58.550   648.516     0.150
    58.550   721.816     0.150
    58.550  1030.516     0.150
    58.550  1082.516     0.150
    58.601   595.516     0.150
    58.629   598.016     0.150
    58.629   596.645     0.150
    58.648   597.414     0.150
    58.648   726.316     0.150
    58.648   597.305     0.150
    58.705   598.414     0.150
    58.733   596.516     0.150
    58.819   599.617     0.150
    58.819   599.516     0.150
    58.839   600.016     0.150
    58.903   599.215     0.150
    58.957   599.516     0.150
    59.016   601.316     0.150
    59.061   600.414     0.150
    59.138   601.414     0.150
    59.138   601.055     0.150
    59.184   600.516     0.150
    59.184     5.102     0.150
    59.183   600.504     0.150
    59.175   602.617     0.150
    59.250   601.016     0.150
    59.250   731.516     0.150
    59.239   601.516     0.150
    59.255   602.617     0.150
    59.279   601.406     0.150
    59.279     4.848     0.150
    59.279   651.188     0.150
    59.308   603.414     0.150
    59.352   603.145     0.150
    59.398   603.516     0.150
    59.426   602.516     0.150
    59.426   647.516     0.150
    59.426   734.516     0.150
    59.426  1094.516     0.150
    59.426  1106.516     0.150
    59.438   603.016     0.150
    59.438   645.516     0.150
    59.438   731.516     0.150
    59.438  1090.516     0.150
    59.429   604.117     0.150
    59.472   603.645     0.150
    59.504   604.105     0.150
    59.521   604.516     0.150
    59.517   604.715     0.150
    59.531   604.715     0.150
    59.537   604.516     0.150
    59.537  1094.516     0.150
    59.656   604.977     0.150
    59.668   605.117     0.150
    59.650   605.715     0.150
    59.657   605.414     0.150
    59.700   605.715     0.150
    59.710   604.316     0.150
    59.710   654.516     0.150
    59.703   605.516     0.150
    59.745   605.516     0.150
    59.745   653.516     0.150
    59.745  1097.516     0.150
    59.744   604.816     0.150
    59.738   604.516     0.150
    59.738  1100.516     0.150
    59.730   606.016     0.150
    59.741   606.016     0.150
    59.859   605.816     0.150
    59.866   602.516     0.150
    59.891   606.117     0.150
    59.912   606.914     0.150
    59.936   606.445     0.150
    59.984   606.938     0.150
    59.984   606.406     0.150
    60.009   606.426     0.150
    60.009   607.715     0.150
    60.020   606.516     0.150
    60.020   740.516     0.150
    60.020  1100.516     0.150
    60.020  1344.516     0.150
    60.007   607.914     0.150
    60.070   606.625     0.150
    60.077   606.707     0.150
    60.073   608.516     0.150
    60.111   607.207     0.150
    60.133   608.715     0.150
    60.153   608.516     0.150
    60.204   607.855     0.150
    60.227   607.914     0.150
    60.227     4.613     0.150
    60.227  1103.414     0.150
    60.379   609.016     0.150
    60.378   609.117     0.150
    60.375   610.516     0.150
    60.408     6.500     0.150
    60.425   609.227     0.150
    60.452   609.004     0.150
    60.479   609.574     0.150
    60.525   609.914     0.150
    60.556   610.414     0.150
    60.556   610.215     0.150
    60.547   611.715     0.150
    60.567   611.316     0.150
    60.593   611.215     0.150
    60.592   610.316     0.150
    60.592   610.516     0.150
    60.657   610.617     0.150
    60.667   610.617     0.150
    60.695   611.195     0.150
    60.710   613.016     0.150
    60.721   614.516     0.150
    60.767   612.414     0.150
    60.761   611.516     0.150
    60.761   611.664     0.150
    60.779   612.516     0.150
    60.779   613.016     0.150
    60.803   611.215     0.150
    60.792   613.016     0.150
    60.818   611.414     0.150
    60.860   612.617     0.150
    60.941   614.516     0.150
    60.981   614.117     0.150
    60.983   614.117     0.150
    61.065   613.715     0.150
    61.119   614.715     0.150
    61.119   615.215     0.150
    61.175   615.117     0.150
    61.161   616.016     0.150
    61.213   614.715     0.150
    61.217   614.816     0.150
    61.217   614.414     0.150
    61.228   615.145     0.150
    61.229   615.914     0.150
    61.229   616.117     0.150
    61.251   614.715     0.150
    61.251   614.516     0.150
    61.251   615.516     0.150
    61.291   615.617     0.150
    61.293   613.414     0.150
    61.348   615.914     0.150
    61.378   615.605     0.150
    61.383   616.617     0.150
    61.419   618.516     0.150
    61.428   616.516     0.150
    61.484   618.316     0.150
    61.587   617.414     0.150
    61.592   617.414     0.150
    61.574   618.516     0.150
    61.688   617.215     0.150
    61.771   619.016     0.150
    61.776   620.016     0.150
    61.976   621.316     0.150
    61.969   621.617     0.150
    62.000   620.914     0.150
    62.006   621.016     0.150
    62.130   621.117     0.150
    62.188   622.316     0.150
    62.188   621.617     0.150
    62.259   622.715     0.150
    62.289   622.816     0.150
    62.282   623.016     0.150
    62.282   622.617     0.150
    62.286   622.617     0.150
    62.360   623.016     0.150
    62.391   623.516     0.150
    62.391   623.715     0.150
    62.468   623.016     0.150
    62.604   624.914     0.150
    62.612   624.816     0.150
    62.643   625.516     0.150
    62.643  1135.516     0.150
    62.693   625.316     0.150
    62.795   624.414     0.150
    62.801   624.516     0.150
    62.823   624.914     0.150
    62.823   624.715     0.150
    62.839   626.816     0.150
    62.839   626.254     0.150
    62.920   626.617     0.150
    62.932   625.816     0.150
    62.998   626.914     0.150
    63.007   627.906     0.150
    63.012   626.117     0.150
    63.012   626.016     0.150
    63.124   628.316     0.150
    63.130   627.117     0.150
    63.130   627.715     0.150
    63.132   628.516     0.150
    63.132   628.414     0.150
    63.172   627.406     0.150
    63.172   628.914     0.150
    63.198   627.117     0.150
    63.198   626.914     0.150
    63.210   627.215     0.150
    63.210   627.016     0.150
    63.192   629.617     0.150
    63.208   628.137     0.150
    63.278   630.316     0.150
    63.290   628.414     0.150
    63.345   628.414     0.150
    63.413   628.816     0.150
    63.413   628.715     0.150
    63.409   630.117     0.150
    63.515   630.516     0.150
    63.515   630.914     0.150
    63.526   630.816     0.150
    63.583   629.875     0.150
    63.580   631.617     0.150
    63.587   631.117     0.150
    63.659   632.574     0.150
    63.613   631.914     0.150
    63.607   632.516     0.150
    63.629   631.215     0.150
    63.649   630.117     0.150
    63.649   629.914     0.150
    63.647   630.746     0.150
    63.651   632.316     0.150
    63.692   632.316     0.150
    63.692  1150.516     0.150
    63.692  1400.516     0.150
    63.747   632.215     0.150
    63.793   631.117     0.150
    63.801   631.516     0.150
    63.801   633.117     0.150
    63.835   635.016     0.150
    63.835  1151.516     0.150
    63.896   631.938     0.150
    63.920   631.117     0.150
    63.958   633.266     0.150
    64.015   632.715     0.150
    64.082   634.016     0.150
    64.098   634.414     0.150
    64.111   633.914     0.150
    64.142   634.414     0.150
    64.189   634.617     0.150
    64.187   634.414     0.150
    64.187   634.516     0.150
    64.198   634.617     0.150
    64.247   635.938     0.150
    64.212   634.016     0.150
    64.299   634.375     0.150
    64.299     3.219     0.150
    64.270   634.816     0.150
    64.278   634.516     0.150
    64.316   635.516     0.150
    64.410   636.117     0.150
    64.487   637.516     0.150
    64.487   637.816     0.150
    64.505   636.816     0.150
    64.561   636.414     0.150
    64.570   638.215     0.150
    64.570     3.500     0.150
    64.603   636.516     0.150
    64.603   637.316     0.150
    64.694   639.707     0.150
    64.748   638.215     0.150
    64.762   638.016     0.150
    64.762   638.414     0.150
    64.774   639.516     0.150
    64.915   640.215     0.150
    64.894   638.914     0.150
    64.894   638.715     0.150
    64.968   639.414     0.150
    65.030   640.117     0.150
    65.052   640.715     0.150
    65.234   642.516     0.150
    65.234   642.715     0.150
    65.364   642.746     0.150
    65.359   642.016     0.150
    65.359   641.914     0.150
    65.412   643.785     0.150
    65.465   643.414     0.150
    65.465   643.215     0.150
    65.553   644.074     0.150
    65.825   646.266     0.150
    65.837   646.516     0.150
    65.837   646.914     0.150
    65.838   645.844     0.150
    65.838     4.133     0.150
    65.848   646.836     0.150
    65.963   646.516     0.150
    66.008   646.715     0.150
    66.008   646.414     0.150
    66.107   648.324     0.150
    66.310   649.207     0.150
    66.362   649.816     0.150
    66.808   653.664     0.150
    66.808     3.391     0.150
    66.894   653.645     0.150
    66.937   652.676     0.150
    67.041   654.477     0.150
    67.189   655.617     0.150
    67.192   655.016     0.150
    67.326   656.375     0.150
    67.329   656.188     0.150
    67.424   656.715     0.150
    67.521   657.406     0.150
    67.732   657.414     0.150
    67.732   657.117     0.150
    67.869   659.895     0.150
    67.864   659.414     0.150
    67.864     5.000     0.150
    67.864   685.016     0.150
    67.864   810.016     0.150
    67.864  1214.516     0.150
    67.864  1859.816     0.150
    68.080   661.688     0.150
    69.106   668.516     0.150
    69.106   668.715     0.150
    69.180   663.055     0.150
    69.505   669.617     0.150
    69.505  2355.914     0.150
    69.550   668.516     0.150
    69.550  1212.516     0.150
    70.043   674.996     0.150
    70.115   673.516     0.150
    70.115   673.617     0.150
    70.126   674.426     0.150
    70.099   672.836     0.150
    70.099     4.219     0.150
    70.524   675.938     0.150
    70.524     3.809     0.150
    70.547   671.516     0.150
    70.935   679.195     0.150
    71.316   682.016     0.150
    71.811   683.047     0.150
    71.924   685.125     0.150
    72.096   685.016     0.150
    72.166   686.516     0.150
    72.361   687.477     0.150
    72.287   687.535     0.150
    72.525   687.516     0.150
    72.525     3.559     0.150
    72.525   687.156     0.150
    72.677   689.016     0.150
    72.955   691.016     0.150
    73.007   690.516     0.150
    73.007   691.215     0.150
    73.083   691.516     0.150
    73.083   692.016     0.150
    73.162   690.855     0.150
    73.434   690.516     0.150
    73.541   694.516     0.150
    73.541   694.816     0.150
    73.561   694.504     0.150
    73.561     3.312     0.150
    73.708   694.516     0.150
    73.708   695.016     0.150
    73.730   695.926     0.150
    74.411   699.516     0.150
    74.369   698.516     0.150
    74.438   699.777     0.150
    74.454   700.945     0.150
    74.509   701.066     0.150
    74.509     3.641     0.150
    74.462   700.516     0.150
    74.596   701.277     0.150
    74.720   701.164     0.150
    74.904   702.016     0.150
    75.019   703.516     0.150
    75.019  1282.516     0.150
    75.389   705.516     0.150
    75.424   705.117     0.150
    75.472   705.516     0.150
    75.472   706.016     0.150
    75.927   705.516     0.150
    75.927   882.516     0.150
    75.927  1297.516     0.150
    75.973   709.016     0.150
    76.137   708.516     0.150
    76.137   709.215     0.150
    76.155   708.656     0.150
    76.164   710.047     0.150
    76.347   709.516     0.150
    76.347   710.414     0.150
    76.374   709.816     0.150
    76.648   712.004     0.150
    76.592   713.516     0.150
    76.796   712.516     0.150
    76.796   713.117     0.150
    77.167   715.105     0.150
    77.245   715.426     0.150
    77.245   716.316     0.150
    77.245   715.586     0.150
    77.245     3.641     0.150
    77.254   715.215     0.150
    77.308   716.145     0.150
    77.330   715.516     0.150
    77.539   716.016     0.150
    77.532   716.215     0.150
    77.547   715.914     0.150
    77.653   717.676     0.150
    77.653     4.141     0.150
    77.954   719.855     0.150
    78.006   719.516     0.150
    78.006   720.316     0.150
    78.276   718.688     0.150
    78.276     4.219     0.150
    78.259   719.516     0.150
    78.441   721.586     0.150
    78.958   724.906     0.150
    78.958     4.219     0.150
    78.939   723.516     0.150
    79.033   725.516     0.150
    79.033   725.617     0.150
    79.121   724.984     0.150
    79.191   723.414     0.150
    79.359   724.516     0.150
    79.484   725.516     0.150
    79.829   730.527     0.150
    79.829     3.637     0.150
    80.075   731.516     0.150
    80.069   730.664     0.150
    80.069     3.980     0.150
    80.069     5.961     0.150
    80.250   730.355     0.150
    80.250     3.969     0.150
    80.802   733.945     0.150
    80.802     3.891     0.150
    80.871   734.688     0.150
    80.871     3.887     0.150
    80.871   735.414     0.150
    81.136   735.617     0.150
    81.136  1347.117     0.150
    81.281   737.555     0.150
    81.816   739.516     0.150
    82.119   740.555     0.150
    82.256   741.715     0.150
    82.278   742.914     0.150
    82.445   742.117     0.150
    82.445     3.719     0.150
    82.688   743.676     0.150
    82.688   742.516     0.150
    82.742   745.316     0.150
    82.863   744.457     0.150
    82.863     4.219     0.150
    82.843   744.516     0.150
    82.971   744.516     0.150
    83.368   749.617     0.150
    83.435   747.914     0.150
    83.460   749.516     0.150
    83.569   747.516     0.150
    83.569   748.117     0.150
    83.759   750.105     0.150
    83.759   754.074     0.150
    83.769   749.617     0.150
    83.993   750.914     0.150
    84.692   753.516     0.150
    84.692   754.414     0.150
    85.035   755.516     0.150
    85.035   755.816     0.150
    85.278   757.066     0.150
    85.278     3.969     0.150
    85.556   759.516     0.150
    86.061   761.617     0.150
    86.248   761.516     0.150
    86.248     3.891     0.150
    86.211   764.516     0.150
    86.671   763.594     0.150
    86.671     3.891     0.150
    86.775   765.516     0.150
    86.884   765.715     0.150
    86.930   763.914     0.150
    87.159   766.926     0.150
    87.159     3.891     0.150
    87.159   766.496     0.150
    87.444   767.117     0.150
    87.514   767.516     0.150
    87.823   769.516     0.150
    87.823   770.016     0.150
    87.946   769.516     0.150
    87.946   769.816     0.150
    87.969   769.516     0.150
    87.969   770.215     0.150
    88.050   772.715     0.150
    88.304   771.715     0.150
    88.445   773.336     0.150
    89.126   775.516     0.150
    89.126   776.215     0.150
    89.239   775.516     0.150
    89.239     4.469     0.150
    89.409   779.754     0.150
    89.409     4.062     0.150
    90.440   781.816     0.150
    94.335   802.016     0.150
    95.327   805.316     0.150
    99.435   822.957     0.150
   105.435   850.176     0.150
   105.435   853.895     0.150
   110.952  1154.516     0.150
   111.814  1112.457     0.150
   121.754  1134.516     0.150
   122.762  1137.715     0.150
   122.762  1142.516     0.150
   124.318  1138.516     0.150
   124.318  1244.516     0.150
   130.476  1150.516     0.150
   137.538  1162.516     0.150
   137.538  1163.016     0.150
   137.695  1165.426     0.150
   139.676  1171.215     0.150
   140.664  1171.516     0.150
   141.901  1169.414     0.150
   143.287  1170.914     0.150
   144.616  1176.215     0.150
   146.489  1183.715     0.150
   146.481  1179.754     0.150
   146.481  1184.727     0.150
   146.481  1178.914     0.150
   146.658  1180.816     0.150
   146.658  1185.914     0.150
   147.987  1183.715     0.150
   149.505  1185.145     0.150
   149.505  1189.117     0.150
   151.508  1197.516     0.150
   151.665  1189.016     0.150
   152.321  1194.617     0.150
   153.499  1190.516     0.150
   154.271  1192.516     0.150
   154.386  1194.516     0.150
   154.615  1192.617     0.150
   154.789  1193.516     0.150
   155.730  1194.016     0.150
   155.755  1195.016     0.150
   157.664  1196.816     0.150
   158.066  1196.516     0.150
   158.066  1452.516     0.150
     0.286     6.219     0.150
     0.286    10.020     0.150
     1.279    23.617     0.150
     1.279    40.418     0.150
     1.280    23.617     0.150
     1.280    40.418     0.150
     1.990    35.918     0.150
     1.990    61.418     0.150
     2.463    39.418     0.150
     2.463    43.418     0.150
     2.463    75.617     0.150
     2.499    41.418     0.150
     2.499    45.418     0.150
     2.499    78.418     0.150
     2.715    44.418     0.150
     2.715    49.617     0.150
     2.715    84.816     0.150
     3.526   111.418     0.150
     3.867    61.219     0.150
     3.867    70.617     0.150
     3.867   122.219     0.150
     4.253    66.020     0.150
     4.253    77.418     0.150
     4.253   133.219     0.150
     4.803    72.020     0.150
     4.803    87.418     0.150
     4.803   150.117     0.150
     5.323    96.617     0.150
     5.323   166.617     0.150
     5.482    83.020     0.150
     5.482   100.617     0.150
     5.482   172.418     0.150
     6.682   210.418     0.150
     7.738   112.418     0.150
     7.738   136.418     0.150
     7.738   242.617     0.150
     0.303     6.922     0.150
     0.303    10.625     0.150
     0.853    16.422     0.150
     0.853    28.625     0.150
     2.032    34.125     0.150
     2.032    36.125     0.150
     2.032    62.125     0.150
     2.422    38.023     0.150
     2.422    42.328     0.150
     2.422    74.523     0.150
     2.560    43.125     0.150
     2.560    46.922     0.150
     2.560    81.125     0.150
     2.526    41.328     0.150
     2.526    45.922     0.150
     2.526    72.023     0.150
     2.526    79.125     0.150
     2.680    48.922     0.150
     2.680    84.625     0.150
     3.485    63.125     0.150
     3.485   100.125     0.150
     3.485   108.125     0.150
     3.827    60.125     0.150
     3.827    69.227     0.150
     3.827   101.125     0.150
     3.827   118.922     0.150
     4.217    77.625     0.150
     4.217   133.227     0.150
     4.762    73.625     0.150
     4.762    87.328     0.150
     4.762   149.625     0.150
     5.309    79.125     0.150
     5.309    82.023     0.150
     5.309    96.125     0.150
     5.309   138.422     0.150
     5.309   154.422     0.150
     5.309   166.125     0.150
     5.450    82.523     0.150
     5.450    99.125     0.150
     5.450   158.328     0.150
     5.450   170.625     0.150
     5.604    84.727     0.150
     5.604   102.523     0.150
     5.604   177.422     0.150
     6.647    98.922     0.150
     6.647   207.523     0.150
     7.758   243.125     0.150
     7.726   141.922     0.150
     7.726   196.328     0.150
     7.726   241.727     0.150
     8.039   235.125     0.150
     8.039   251.125     0.150
     9.097   283.227     0.150
     9.740   302.422     0.150
    10.737   335.125     0.150
     0.313     7.289     0.150
     0.313    11.195     0.150
     2.040    34.789     0.150
     2.040    35.789     0.150
     2.040    61.992     0.150
     2.418    38.992     0.150
     2.418    42.492     0.150
     2.418    72.492     0.150
     2.524    41.391     0.150
     2.524    44.992     0.150
     2.524    71.289     0.150
     2.524    79.492     0.150
     2.551    46.094     0.150
     2.551    80.289     0.150
     2.670    43.492     0.150
     2.670    47.992     0.150
     2.670    82.492     0.150
     3.476   107.992     0.150
     3.818    59.195     0.150
     3.818    67.992     0.150
     3.818   100.992     0.150
     3.818   118.789     0.150
     4.207    65.195     0.150
     4.207    76.891     0.150
     4.207   131.789     0.150
     4.753    73.195     0.150
     4.753    85.289     0.150
     4.753   126.992     0.150
     4.753   148.094     0.150
     5.299    95.195     0.150
     5.299   139.492     0.150
     5.299   165.594     0.150
     5.439    81.992     0.150
     5.439    98.992     0.150
     5.439   142.992     0.150
     5.439   170.789     0.150
     5.610   171.594     0.150
     6.636   207.789     0.150
     7.716   239.492     0.150
     7.748   240.992     0.150
     9.087   283.992     0.150
     0.319    10.754     0.150
     0.826    15.754     0.150
     0.826    27.754     0.150
     1.271    23.953     0.150
     1.271    40.555     0.150
     1.272    23.953     0.150
     1.272    25.254     0.150
     1.272    40.555     0.150
     1.994    36.754     0.150
     1.994    62.254     0.150
     2.477    45.254     0.150
     2.477    76.055     0.150
     2.469    45.754     0.150
     2.469    79.754     0.150
     2.592    48.953     0.150
     3.857    61.754     0.150
     3.857    71.055     0.150
     3.857   105.754     0.150
     3.857   122.453     0.150
     4.235    66.754     0.150
     4.235    77.754     0.150
     4.235   133.754     0.150
     0.297     6.055     0.150
     0.297    10.055     0.150
     1.314    23.953     0.150
     1.314    41.555     0.150
     1.315    23.953     0.150
     1.315    41.555     0.150
     1.952    35.352     0.150
     1.952    60.758     0.150
     2.512    45.555     0.150
     2.512    77.555     0.150
     2.454    44.555     0.150
     2.454    78.055     0.150
     2.635    48.852     0.150
     2.635    76.055     0.150
     2.635    83.852     0.150
     2.738    46.156     0.150
     2.738    50.453     0.150
     2.738    85.758     0.150
     3.900    62.156     0.150
     3.900    71.156     0.150
     3.900   122.055     0.150
     4.277    67.555     0.150
     4.277    78.156     0.150
     4.277   134.055     0.150
     4.836    74.453     0.150
     4.836    87.656     0.150
     4.836   150.156     0.150
     5.316    97.258     0.150
     5.316   167.555     0.150
     5.499    83.656     0.150
     5.499   100.055     0.150
     5.499   172.656     0.150
     5.515    99.758     0.150
     5.515   173.055     0.150
     6.004   110.656     0.150
     6.004   189.953     0.150
     0.207     4.511     0.150
     0.940    18.311     0.150
     1.367    25.711     0.150
     1.367    43.410     0.150
     1.368    25.711     0.150
     1.368    43.410     0.150
     1.909    34.311     0.150
     1.909    59.311     0.150
     2.512    41.511     0.150
     2.512    44.610     0.150
     2.512    75.910     0.150
     2.505    42.311     0.150
     2.505    46.110     0.150
     2.505    73.110     0.150
     2.505    78.511     0.150
     2.688    45.011     0.150
     2.688    49.910     0.150
     2.688    85.110     0.150
     2.810    46.511     0.150
     2.810    51.110     0.150
     2.810    77.610     0.150
     2.810    88.110     0.150
     3.956    62.511     0.150
     3.956    71.910     0.150
     3.956   108.610     0.150
     3.956   123.011     0.150
     4.348    68.211     0.150
     4.348    80.110     0.150
     4.348   116.711     0.150
     4.348   136.110     0.150
     4.891    75.511     0.150
     4.891    87.811     0.150
     4.891   126.811     0.150
     4.891   152.410     0.150
     5.407    81.910     0.150
     5.407    98.110     0.150
     5.407   140.910     0.150
     5.407   170.511     0.150
     5.577    84.910     0.150
     5.577   102.011     0.150
     5.577   145.211     0.150
     5.577   173.311     0.150
     6.777   101.311     0.150
     6.777   121.511     0.150
     6.777   211.011     0.150
     7.819   115.311     0.150
     7.819   144.011     0.150
     7.819   203.811     0.150
     7.819   244.711     0.150
     7.888   116.211     0.150
     7.888   246.610     0.150
     8.167   256.311     0.150
     9.227   169.811     0.150
     9.227   236.011     0.150
     9.227   288.110     0.150
     9.870   307.110     0.150
    10.353   320.511     0.150
    10.865   338.711     0.150
    11.234   349.711     0.150
    11.409   165.410     0.150
    11.409   354.511     0.150
     0.295     6.051     0.150
     0.295    10.949     0.150
     0.856    17.051     0.150
     0.856    28.750     0.150
     1.259    23.350     0.150
     1.259    25.350     0.150
     1.259    40.150     0.150
     1.259    42.650     0.150
     2.012    36.250     0.150
     2.012    62.250     0.150
     2.040    62.150     0.150
     2.442    40.750     0.150
     2.442    43.750     0.150
     2.442    70.250     0.150
     2.442    75.150     0.150
     2.513    45.850     0.150
     2.513    71.350     0.150
     2.513    79.350     0.150
     2.696    48.449     0.150
     2.696    84.551     0.150
     3.222    58.250     0.150
     3.222    99.250     0.150
     3.846   119.850     0.150
     4.234   132.449     0.150
     5.315   168.350     0.150
     5.584   173.051     0.150
     0.611    12.039     0.150
     0.611    18.938     0.150
     0.611    19.938     0.150
     0.584    11.938     0.150
     0.584    19.639     0.150
     1.337    25.039     0.150
     1.337    26.539     0.150
     1.337    42.139     0.150
     2.161    37.539     0.150
     2.161    40.238     0.150
     2.161    69.639     0.150
     2.633    48.938     0.150
     2.633    83.139     0.150
     2.638    44.139     0.150
     2.638    48.539     0.150
     2.638    82.938     0.150
     2.699    43.238     0.150
     2.699    48.839     0.150
     2.699    50.139     0.150
     2.699    52.139     0.150
     2.699    82.339     0.150
     3.555   111.139     0.150
     3.878    61.339     0.150
     3.878    70.039     0.150
     3.878    72.438     0.150
     3.878   121.139     0.150
     4.178    76.238     0.150
     4.178   132.139     0.150
     4.820   150.339     0.150
     5.355    81.238     0.150
     5.355    98.139     0.150
     5.355   169.139     0.150
     6.599   208.139     0.150
     7.447   232.139     0.150
     7.692   240.139     0.150
     0.266     5.414     0.150
     0.266     8.414     0.150
     0.880    17.312     0.150
     0.880    29.211     0.150
     1.327    25.211     0.150
     1.327    42.211     0.150
     1.329    25.211     0.150
     1.329    42.211     0.150
     2.507    41.008     0.150
     2.507    44.914     0.150
     2.507    77.312     0.150
     2.475    45.211     0.150
     2.475    78.211     0.150
     2.649    44.211     0.150
     2.649    49.109     0.150
     2.649    84.414     0.150
     2.759    46.008     0.150
     2.759    50.414     0.150
     2.759    87.211     0.150
     3.915    61.414     0.150
     3.915    71.008     0.150
     3.915   123.008     0.150
     4.298    77.211     0.150
     4.298   134.711     0.150
     4.851    88.609     0.150
     4.851   150.211     0.150
     5.346    83.109     0.150
     5.346    98.008     0.150
     5.346   167.609     0.150
     5.523   100.711     0.150
     5.523   173.414     0.150
     5.515    86.711     0.150
     5.515   101.609     0.150
     5.515   147.508     0.150
     5.515   172.211     0.150
     6.727   123.812     0.150
     6.727   211.609     0.150
     7.759   114.609     0.150
     7.759   198.609     0.150
     7.759   242.609     0.150
     7.836   243.711     0.150
    10.304   322.211     0.150
     0.552    10.742     0.150
     0.552    17.441     0.150
     0.561    10.742     0.150
     0.561    17.441     0.150
     0.580    11.141     0.150
     0.580    19.441     0.150
     1.256    24.242     0.150
     1.256    40.441     0.150
     1.742    33.441     0.150
     1.742    56.441     0.150
     1.731    32.840     0.150
     1.731    55.441     0.150
     2.157    36.441     0.150
     2.157    38.641     0.150
     2.157    66.941     0.150
     2.633    44.840     0.150
     2.633    48.840     0.150
     2.633    76.441     0.150
     2.633    84.141     0.150
     3.273    53.742     0.150
     3.273   103.641     0.150
     3.911    64.441     0.150
     3.911   123.141     0.150
     4.470    72.242     0.150
     4.470   140.441     0.150
     6.904   101.242     0.150
     6.904   217.941     0.150
     0.708    13.906     0.150
     0.708    23.105     0.150
     2.247    37.906     0.150
     2.247    40.805     0.150
     2.247    70.605     0.150
     2.300    39.105     0.150
     2.300    41.707     0.150
     2.300    72.105     0.150
     2.341    38.605     0.150
     2.341    41.707     0.150
     2.341    72.707     0.150
     2.449    40.605     0.150
     2.449    44.605     0.150
     2.449    78.105     0.150
     3.171    58.605     0.150
     3.171    99.605     0.150
     3.500    55.906     0.150
     3.500    64.707     0.150
     3.500   109.004     0.150
     3.841    60.605     0.150
     3.841    69.906     0.150
     3.841    71.707     0.150
     3.841   120.004     0.150
     4.440   138.605     0.150
     4.919    73.707     0.150
     4.919    88.605     0.150
     4.919   132.605     0.150
     4.919   153.004     0.150
     6.268   182.207     0.150
     6.268   197.207     0.150
     7.341   106.707     0.150
     7.341   135.406     0.150
     7.341   230.105     0.150
     7.373   232.105     0.150
     8.716   269.605     0.150
     0.324     7.682     0.150
     1.468    27.981     0.150
     1.722    30.981     0.150
     2.551    41.981     0.150
     2.551    45.881     0.150
     2.551    78.381     0.150
     2.866    45.581     0.150
     2.866    50.682     0.150
     2.866    78.182     0.150
     2.866    86.682     0.150
     3.011    48.881     0.150
     3.011    52.381     0.150
     3.011    55.281     0.150
     3.011    95.281     0.150
     3.233    58.981     0.150
     3.233    87.281     0.150
     3.233   100.381     0.150
     3.953    75.081     0.150
     3.953   104.481     0.150
     3.953   127.381     0.150
     4.284    77.881     0.150
     4.284   132.581     0.150
     4.755    86.881     0.150
     4.755   127.081     0.150
     4.755   149.981     0.150
     5.202    94.781     0.150
     5.933    87.881     0.150
     5.933   105.381     0.150
     5.933   153.581     0.150
     5.933   171.981     0.150
     6.023    89.881     0.150
     6.023   106.682     0.150
     6.023   110.381     0.150
     6.023   156.781     0.150
     6.023   188.581     0.150
     7.183   131.881     0.150
     8.347   122.881     0.150
     8.347   260.682     0.150
     8.611   269.781     0.150
     9.635   244.581     0.150
     9.635   298.682     0.150
    11.305   350.981     0.150
    11.618   167.281     0.150
    11.755   291.781     0.150
    11.755   365.981     0.150
    16.960   242.781     0.150
    17.221   245.781     0.150
    17.221   542.781     0.150
    17.956   249.281     0.150
    19.896   625.781     0.150
    21.593   291.781     0.150
    21.593   678.781     0.150
    23.509   312.381     0.150
    24.056   316.081     0.150
    41.833   468.781     0.150
    41.941   470.472     0.150
    42.330   473.581     0.150
    43.111   478.781     0.150
    43.607   482.981     0.150
    43.919   488.781     0.150
    44.250   488.682     0.150
    44.736   491.981     0.150
    47.470   514.281     0.150
    47.792   515.781     0.150
    49.000   525.781     0.150
    49.191   526.581     0.150
    49.304   527.581     0.150
    55.869   576.781     0.150
    55.869     8.000     0.150
    56.937   583.781     0.150
    57.330   587.281     0.150
    57.330     9.000     0.150
    57.503   588.881     0.150
    57.503     7.900     0.150
    57.503   588.682     0.150
    57.503   644.581     0.150
    58.360   592.781     0.150
    61.084   611.281     0.150
    62.676   621.981     0.150
    62.676   622.682     0.150
    62.867   623.781     0.150
    62.982   624.781     0.150
    63.014   625.081     0.150
    63.007   625.281     0.150
    63.029   625.182     0.150
    63.201   626.182     0.150
    63.464   628.182     0.150
    64.405   633.981     0.150
    65.574   643.581     0.150
    68.264   658.781     0.150
    72.110   683.881     0.150
    72.559   685.481     0.150
    73.811   693.751     0.150
    75.537   703.551     0.150
    76.641   709.661     0.150
    76.707   711.451     0.150
    77.950   717.081     0.150
    77.958   716.881     0.150
    80.679   733.481     0.150
    81.555   736.581     0.150
    82.833   744.682     0.150
    83.155   744.491     0.150
    86.750   764.281     0.150
    87.942   768.182     0.150
    90.818   782.182     0.150
    91.172   784.381     0.150
     0.510    10.039     0.150
     0.510    16.039     0.150
     1.353    25.539     0.150
     1.353    43.039     0.150
     1.352    25.539     0.150
     1.352    43.039     0.150
     2.233    38.539     0.150
     2.233    41.539     0.150
     2.233    71.539     0.150
     2.665    43.836     0.150
     2.665    48.539     0.150
     2.665    74.641     0.150
     2.665    81.742     0.150
     2.659    48.938     0.150
     2.659    84.039     0.150
     2.692    45.539     0.150
     2.692    49.641     0.150
     2.692    78.539     0.150
     2.692    84.539     0.150
     3.911    62.141     0.150
     3.911    70.641     0.150
     3.911   106.641     0.150
     3.911   122.141     0.150
     4.234    79.039     0.150
     4.234   114.539     0.150
     4.234   133.539     0.150
     4.852    88.539     0.150
     4.852   129.539     0.150
     4.852   151.539     0.150
     5.423   169.742     0.150
     5.406    98.438     0.150
     5.406   169.836     0.150
     5.877   187.742     0.150
     0.550    10.891     0.150
     0.550    18.688     0.150
     0.758    14.688     0.150
     0.758    23.688     0.150
     0.846    28.188     0.150
     2.153    40.484     0.150
     2.153    69.484     0.150
     2.252    39.688     0.150
     2.252    41.086     0.150
     2.252    68.188     0.150
     2.252    70.984     0.150
     2.223    41.188     0.150
     2.223    70.188     0.150
     2.429    76.086     0.150
     2.528    43.984     0.150
     2.528    46.484     0.150
     2.528    79.688     0.150
     3.409    57.188     0.150
     3.409    62.188     0.150
     4.897   155.688     0.150
     5.896   107.188     0.150
     5.896   184.688     0.150
     7.573   234.289     0.150
     0.664    12.984     0.150
     0.664    21.188     0.150
     1.073    20.188     0.150
     1.073    34.188     0.150
     1.075    20.188     0.150
     1.075    34.188     0.150
     2.218    38.984     0.150
     2.218    68.281     0.150
     2.372    43.984     0.150
     2.372    75.188     0.150
     2.464    40.188     0.150
     2.464    44.188     0.150
     2.464    76.586     0.150
     2.341    39.984     0.150
     2.341    42.984     0.150
     2.341    68.984     0.150
     2.341    74.188     0.150
     2.403    40.383     0.150
     2.403    44.188     0.150
     2.403    76.188     0.150
     3.295    60.984     0.150
     3.295   104.984     0.150
     3.621    58.188     0.150
     3.621    65.484     0.150
     3.621    97.781     0.150
     3.621   113.484     0.150
     3.945    62.586     0.150
     3.945    73.188     0.150
     4.054   125.781     0.150
     4.209    65.688     0.150
     4.209    77.484     0.150
     4.209   131.688     0.150
     4.562    70.781     0.150
     4.562    82.781     0.150
     4.562   122.781     0.150
     4.562   141.781     0.150
     4.945    75.586     0.150
     4.945    90.281     0.150
     5.144    78.781     0.150
     5.144    91.883     0.150
     5.666   101.984     0.150
     7.362   107.984     0.150
     7.362   186.781     0.150
     7.470   109.984     0.150
    18.327   253.281     0.150
    18.327   580.883     0.150
    18.814   262.484     0.150
    43.839   487.086     0.150
    49.301   530.188     0.150
    54.738   569.883     0.150
    57.646   591.883     0.150
    62.903   627.781     0.150
     0.764    14.816     0.150
     0.764    25.418     0.150
     0.913    17.918     0.150
     0.913    29.117     0.150
     0.915    17.918     0.150
     0.915    29.117     0.150
     2.210    38.418     0.150
     2.210    70.516     0.150
     2.251    69.516     0.150
     2.339    41.418     0.150
     2.339    71.016     0.150
     2.439    41.516     0.150
     2.439    44.516     0.150
     2.439    71.516     0.150
     2.439    77.516     0.150
     3.133    57.617     0.150
     3.133    97.617     0.150
     3.459    55.516     0.150
     3.459    64.516     0.150
     3.459    94.816     0.150
     3.459   109.617     0.150
     3.792    59.719     0.150
     3.792    69.516     0.150
     3.792   117.719     0.150
     4.400    69.418     0.150
     4.400    80.117     0.150
     4.400   121.719     0.150
     4.400   137.719     0.150
     4.865    74.816     0.150
     4.865    88.719     0.150
     4.865   152.117     0.150
     5.002    76.016     0.150
     5.002    90.918     0.150
     5.002   134.816     0.150
     5.002   157.816     0.150
     6.218    92.516     0.150
     6.218   113.219     0.150
     6.218   193.719     0.150
     7.288   227.516     0.150
     7.322   228.418     0.150
     7.591   237.617     0.150
     8.666   270.117     0.150
     9.305   290.719     0.150
     9.799   285.617     0.150
     9.799   304.418     0.150
    10.290   320.816     0.150
    10.684   307.117     0.150
    10.684   331.918     0.150
     0.811    26.426     0.150
     0.859    16.125     0.150
     0.859    27.023     0.150
     0.862    16.125     0.150
     0.862    27.023     0.150
     2.194    37.426     0.150
     2.194    40.223     0.150
     2.194    66.723     0.150
     2.304    37.426     0.150
     2.304    40.723     0.150
     2.304    66.125     0.150
     2.304    70.824     0.150
     2.467    40.625     0.150
     2.467    70.824     0.150
     2.467    76.625     0.150
     3.402    54.426     0.150
     3.402    61.223     0.150
     3.402    93.426     0.150
     3.402   107.523     0.150
     3.735    58.723     0.150
     3.735    67.926     0.150
     3.735    98.523     0.150
     3.735   117.125     0.150
     4.092    64.523     0.150
     4.092    76.223     0.150
     4.092   109.625     0.150
     4.092   127.125     0.150
     4.343    66.723     0.150
     4.343    80.023     0.150
     4.829    71.926     0.150
     4.829    87.125     0.150
     4.829   129.223     0.150
     4.829   141.324     0.150
     4.829   150.125     0.150
     4.948    75.723     0.150
     4.948   130.824     0.150
     5.874   105.023     0.150
     6.162    92.324     0.150
     6.162   159.426     0.150
     6.324   114.723     0.150
     7.253   105.625     0.150
     7.253   214.223     0.150
     7.266   187.324     0.150
     8.610   270.125     0.150
     9.249   290.523     0.150
     9.742   302.625     0.150
    10.236   320.824     0.150
    10.627   329.523     0.150
    10.824   335.125     0.150
    43.456   484.125     0.150
    43.695   484.625     0.150
     0.887    17.227     0.150
     0.887    28.625     0.150
     2.124    37.125     0.150
     2.124    39.328     0.150
     2.124    67.328     0.150
     2.139    39.727     0.150
     2.139    62.727     0.150
     2.139    66.625     0.150
     2.333    38.625     0.150
     2.333    41.930     0.150
     2.333    66.031     0.150
     2.333    71.625     0.150
     2.430    41.430     0.150
     2.430    44.727     0.150
     2.430    69.727     0.150
     2.430    76.031     0.150
     3.365    55.031     0.150
     3.365    62.328     0.150
     3.365    92.328     0.150
     3.365   105.930     0.150
     3.680    58.828     0.150
     3.680    68.227     0.150
     3.680   115.031     0.150
     4.307    79.625     0.150
     4.307   115.328     0.150
     4.307   134.125     0.150
     4.747    85.727     0.150
     4.747   125.727     0.150
     4.747   148.328     0.150
     4.883    88.930     0.150
     4.883   131.430     0.150
     4.883   153.930     0.150
     6.105   189.930     0.150
     7.171   184.625     0.150
     0.928    18.008     0.150
     2.111    39.008     0.150
     2.111    38.703     0.150
     2.111    61.406     0.150
     2.351    38.508     0.150
     2.351    43.305     0.150
     2.351    66.805     0.150
     2.351    72.703     0.150
     2.409    41.109     0.150
     2.409    44.203     0.150
     2.409    70.406     0.150
     2.409    76.805     0.150
     3.348    91.109     0.150
     3.652    68.008     0.150
     3.652   116.203     0.150
     4.290    78.406     0.150
     4.290   113.906     0.150
     4.290   133.008     0.150
     4.702   129.406     0.150
     4.702   149.109     0.150
     4.849   129.703     0.150
     4.849   153.008     0.150
     7.127   221.008     0.150
     0.661    12.871     0.150
     0.991    18.672     0.150
     0.991    31.271     0.150
     2.297    39.271     0.150
     2.297    42.871     0.150
     2.297    68.672     0.150
     2.368    39.871     0.150
     2.368    42.871     0.150
     2.368    74.672     0.150
     2.353    40.172     0.150
     2.353    43.271     0.150
     2.353    70.072     0.150
     2.353    74.871     0.150
     2.434    44.572     0.150
     3.222    52.771     0.150
     3.222    58.771     0.150
     3.222   100.771     0.150
     3.551    56.771     0.150
     3.551    63.871     0.150
     3.551    97.271     0.150
     3.551   111.971     0.150
     3.894    71.672     0.150
     3.894   107.271     0.150
     3.894   123.971     0.150
     4.116    66.172     0.150
     4.492    69.771     0.150
     4.492    80.871     0.150
     4.492   121.271     0.150
     4.492   139.871     0.150
     4.959    75.672     0.150
     4.959    89.971     0.150
     4.959   154.871     0.150
     5.107    78.072     0.150
     5.107    93.871     0.150
     6.321    94.672     0.150
     6.321   165.871     0.150
     6.321   186.771     0.150
     6.321   199.572     0.150
     7.426   136.471     0.150
     7.426   233.572     0.150
     7.380   109.072     0.150
     7.697   239.771     0.150
     8.417   215.771     0.150
     9.409   291.572     0.150
     9.901   284.871     0.150
     9.901   308.971     0.150
    10.674   157.971     0.150
    10.674   334.271     0.150
    10.786   157.871     0.150
    10.786   157.271     0.150
    10.786   337.271     0.150
    11.217   161.971     0.150
    18.236   457.471     0.150
    18.732   260.271     0.150
    19.287   265.771     0.150
    20.005   275.771     0.150
    20.614   284.271     0.150
    37.094   433.701     0.150
    37.196   433.842     0.150
    37.305   435.002     0.150
    37.608   437.701     0.150
    37.754   438.221     0.150
    39.521   450.771     0.150
    43.259   482.771     0.150
    43.312   483.672     0.150
    43.744   486.271     0.150
    47.137   515.172     0.150
    49.432   530.471     0.150
    49.432   531.072     0.150
    49.537   530.971     0.150
    54.719   572.072     0.150
    57.382   591.471     0.150
    57.550   591.172     0.150
    57.927   593.771     0.150
    60.532   611.271     0.150
    62.808   625.771     0.150
    63.096   629.271     0.150
    63.115   628.371     0.150
    63.208   628.072     0.150
    63.217   628.271     0.150
    63.327   629.271     0.150
    63.658   631.871     0.150
    64.383   636.271     0.150
    64.893   639.771     0.150
    73.539   695.061     0.150
    73.539   694.271     0.150
    74.449   700.271     0.150
    74.793   703.271     0.150
    77.455   718.271     0.150
    77.546   718.781     0.150
    77.688   720.271     0.150
    80.959   737.271     0.150
    90.725   785.072     0.150
     0.562    11.215     0.150
     0.562    18.215     0.150
     1.415    26.914     0.150
     1.415    45.914     0.150
     2.155    37.016     0.150
     2.155    39.117     0.150
     2.155    69.016     0.150
     2.730    45.117     0.150
     2.730    84.516     0.150
     2.717    44.117     0.150
     2.717    49.215     0.150
     2.717    76.117     0.150
     2.717    85.617     0.150
     2.745    43.816     0.150
     2.745    48.516     0.150
     2.745    53.516     0.150
     2.745    83.316     0.150
     3.640    66.016     0.150
     3.640   115.016     0.150
     3.964    62.016     0.150
     3.964    71.816     0.150
     3.964    74.016     0.150
     3.964   124.016     0.150
     4.271    66.016     0.150
     4.271    77.117     0.150
     4.271   134.516     0.150
     4.425    67.816     0.150
     4.906    75.016     0.150
     4.906    89.816     0.150
     4.906   130.516     0.150
     4.906   152.316     0.150
     5.126    94.516     0.150
     5.126    76.715     0.150
     5.126   161.016     0.150
     5.449    82.316     0.150
     5.449   100.016     0.150
     5.449   144.516     0.150
     5.449   171.516     0.150
     6.692    99.016     0.150
     6.692   123.016     0.150
     7.524   112.117     0.150
     7.524   236.816     0.150
     7.785   114.016     0.150
     7.785   138.215     0.150
     7.785   242.215     0.150
     8.034   150.016     0.150
     8.034   252.016     0.150
     8.184   117.016     0.150
     9.135   284.016     0.150
     9.769   302.516     0.150
    10.274   149.816     0.150
    10.274   319.816     0.150
    10.734   155.016     0.150
    10.734   274.117     0.150
    10.734   334.016     0.150
    10.909   159.117     0.150
    10.834   156.715     0.150
    11.164   161.215     0.150
    11.164   347.117     0.150
    11.375   163.016     0.150
    11.375   355.316     0.150
    18.607   260.016     0.150
    18.528   255.914     0.150
    20.423   279.215     0.150
    37.514   436.594     0.150
    37.636   437.477     0.150
    37.938   439.695     0.150
    37.894   438.117     0.150
    43.101   483.215     0.150
    44.081   487.914     0.150
    47.556   516.617     0.150
    57.910   592.715     0.150
     0.385     7.812     0.150
     0.385    12.112     0.150
     1.675    29.912     0.150
     1.675    31.312     0.150
     1.675    51.912     0.150
     2.297    41.912     0.150
     2.297    72.712     0.150
     2.838    51.112     0.150
     2.838    80.912     0.150
     2.838    86.712     0.150
     3.069    56.112     0.150
     3.069    95.812     0.150
     3.920   122.412     0.150
     4.257    67.012     0.150
     4.257    76.912     0.150
     4.257   133.912     0.150
     5.195    95.112     0.150
     5.195   162.412     0.150
     5.169    94.612     0.150
     5.169   136.612     0.150
     5.501   158.112     0.150
     5.501   173.912     0.150
     5.810   182.412     0.150
     7.036   221.112     0.150
     7.893   245.112     0.150
     8.137   255.912     0.150
     9.484   292.412     0.150
    10.617   332.112     0.150
    11.097   346.912     0.150
     0.578    11.367     0.150
     0.578    18.664     0.150
     1.302    24.062     0.150
     1.302    40.961     0.150
     2.210    37.961     0.150
     2.210    40.664     0.150
     2.210    64.961     0.150
     2.210    71.266     0.150
     2.652    43.367     0.150
     2.652    48.367     0.150
     2.652    75.367     0.150
     2.652    82.164     0.150
     2.621    43.664     0.150
     2.621    47.961     0.150
     2.621    82.367     0.150
     3.850    61.062     0.150
     3.850    69.367     0.150
     3.850   105.367     0.150
     3.850   120.164     0.150
     4.162    65.367     0.150
     4.162    75.461     0.150
     4.162   112.164     0.150
     4.162   130.164     0.150
     4.792    74.164     0.150
     4.792    86.664     0.150
     4.792   149.664     0.150
     5.062    77.664     0.150
     5.062    91.961     0.150
     5.062   134.867     0.150
     5.062   157.664     0.150
     5.346    80.367     0.150
     5.346    96.164     0.150
     5.346   166.961     0.150
     6.584    99.461     0.150
     6.584   119.961     0.150
     6.584   206.164     0.150
     7.466   138.062     0.150
     7.466   235.766     0.150
     7.679   239.867     0.150
     0.383     7.605     0.150
     0.383    12.207     0.150
     1.684    30.605     0.150
     1.684    52.605     0.150
     1.685    30.906     0.150
     1.685    53.805     0.150
     2.304    39.605     0.150
     2.304    42.305     0.150
     2.304    68.305     0.150
     2.304    72.207     0.150
     2.842    46.707     0.150
     2.842    51.207     0.150
     2.842    86.906     0.150
     2.842    46.605     0.150
     2.842    50.906     0.150
     2.842    78.906     0.150
     2.842    86.605     0.150
     3.081    50.605     0.150
     3.081    56.004     0.150
     3.081    84.906     0.150
     3.081    95.906     0.150
     4.267    67.207     0.150
     4.267    77.605     0.150
     4.267   116.004     0.150
     4.267   134.004     0.150
     4.267    67.004     0.150
     4.267   116.305     0.150
     4.267   133.605     0.150
     4.622    71.707     0.150
     4.622    84.605     0.150
     4.622   124.504     0.150
     4.622   146.906     0.150
     5.205    80.707     0.150
     5.205    96.305     0.150
     5.205   164.105     0.150
     5.205    80.605     0.150
     5.205    94.605     0.150
     5.164    79.605     0.150
     5.164    94.504     0.150
     5.164   135.105     0.150
     5.164   162.504     0.150
     5.514   100.406     0.150
     5.514   173.207     0.150
     5.667    86.805     0.150
     5.667   104.105     0.150
     5.667   148.906     0.150
     5.667   180.004     0.150
     5.823    87.605     0.150
     5.823   105.105     0.150
     5.823   152.605     0.150
     5.823   182.605     0.150
     7.049   104.105     0.150
     7.049   127.207     0.150
     7.049   181.605     0.150
     7.049   218.605     0.150
     0.584    11.482     0.150
     0.584    18.582     0.150
     1.275    23.582     0.150
     1.275    40.082     0.150
     2.225    41.082     0.150
     2.225    70.582     0.150
     2.575    46.781     0.150
     2.575    81.582     0.150
     2.629    43.281     0.150
     2.629    47.781     0.150
     2.629    80.781     0.150
     2.595    47.582     0.150
     2.595    81.582     0.150
     3.498   109.582     0.150
     3.823    69.582     0.150
     3.823   120.383     0.150
     4.136    74.582     0.150
     4.136   130.082     0.150
     5.048   160.582     0.150
     5.322   168.082     0.150
     0.551    10.641     0.150
     0.551    18.240     0.150
     2.272    41.641     0.150
     2.272    71.141     0.150
     2.415    44.240     0.150
     2.415    76.141     0.150
     2.564    44.240     0.150
     2.564    46.840     0.150
     2.564    76.041     0.150
     2.564    82.240     0.150
     3.570    58.340     0.150
     3.570    66.541     0.150
     3.570    97.840     0.150
     3.953    63.240     0.150
     3.953    73.740     0.150
     3.953   106.840     0.150
     3.953   124.041     0.150
     4.507   140.840     0.150
     5.099    94.240     0.150
     5.099   160.541     0.150
     5.187    80.240     0.150
     5.187    94.840     0.150
     5.187   162.541     0.150
     5.802    88.141     0.150
     5.802   104.939     0.150
     5.802   151.340     0.150
     5.802   181.439     0.150
     6.275   198.939     0.150
     7.430   232.340     0.150
     7.915   247.340     0.150
     0.322     6.765     0.150
     0.322    11.365     0.150
     1.747    55.165     0.150
     2.597    43.265     0.150
     2.597    46.365     0.150
     2.597    73.565     0.150
     2.825    45.765     0.150
     2.825    51.265     0.150
     2.825    79.965     0.150
     2.825    87.465     0.150
     3.252    52.265     0.150
     3.252    58.665     0.150
     3.252    89.765     0.150
     3.252   100.665     0.150
     4.314    77.265     0.150
     4.314   133.565     0.150
     4.777    73.665     0.150
     4.777    85.765     0.150
     4.777   127.065     0.150
     4.777   148.265     0.150
     5.234    95.665     0.150
     5.426   137.865     0.150
     5.426   169.065     0.150
     5.968   186.365     0.150
     6.039   106.765     0.150
     6.872   215.965     0.150
     8.054   249.265     0.150
     8.058   249.265     0.150
     8.338   260.765     0.150
     0.492     9.645     0.150
     0.492    15.746     0.150
     0.492     9.848     0.150
     1.498    27.848     0.150
     1.498    47.246     0.150
     1.497    27.848     0.150
     1.497    46.246     0.150
     2.183    37.848     0.150
     2.183    40.746     0.150
     2.183    69.445     0.150
     2.183    37.246     0.150
     2.183    40.246     0.150
     2.183    64.047     0.150
     2.183    68.445     0.150
     2.728    44.145     0.150
     2.728    48.945     0.150
     2.728    85.848     0.150
     2.778    45.445     0.150
     2.778    49.945     0.150
     2.778    77.645     0.150
     2.778    84.348     0.150
     2.838    46.445     0.150
     2.838    51.246     0.150
     2.838    89.047     0.150
     3.731   115.645     0.150
     4.059    64.047     0.150
     4.059    73.246     0.150
     4.059   127.445     0.150
     4.059    63.746     0.150
     4.059    73.047     0.150
     4.059   127.047     0.150
     4.379    68.348     0.150
     4.379    79.445     0.150
     4.379   137.645     0.150
     5.000    76.848     0.150
     5.000    91.047     0.150
     5.000   131.246     0.150
     5.000   155.848     0.150
     5.239   163.246     0.150
     5.562   175.348     0.150
     6.801   211.746     0.150
     7.635   239.145     0.150
     7.774   241.246     0.150
     7.897   116.848     0.150
     7.897   244.246     0.150
    10.384   324.047     0.150
     0.790    26.102     0.150
     0.790    15.602     0.150
     0.790    25.902     0.150
     2.226    38.602     0.150
     2.380    40.303     0.150
     2.380    43.303     0.150
     2.380    74.402     0.150
     2.380    39.902     0.150
     2.380    40.803     0.150
     2.380    43.102     0.150
     2.858    46.902     0.150
     2.858    81.902     0.150
     2.858    87.902     0.150
     3.254    51.502     0.150
     3.254    90.102     0.150
     3.254   100.303     0.150
     3.254    89.303     0.150
     3.472    56.502     0.150
     3.472    64.602     0.150
     3.472   110.102     0.150
     3.639    58.102     0.150
     3.639   112.602     0.150
     3.639    66.602     0.150
     4.471    82.602     0.150
     4.471    70.102     0.150
     4.471    81.303     0.150
     4.471   138.303     0.150
     4.756    72.502     0.150
     4.756   123.102     0.150
     4.756   146.602     0.150
     4.813    74.703     0.150
     4.813   148.902     0.150
     4.813    74.602     0.150
     4.813    87.602     0.150
     4.813   151.102     0.150
     5.180    79.203     0.150
     5.180    93.502     0.150
     5.180   138.602     0.150
     5.180   162.002     0.150
     5.295    79.602     0.150
     5.295    96.203     0.150
     5.295   139.102     0.150
     5.295   166.102     0.150
     5.748    87.502     0.150
     5.748   104.602     0.150
     5.748   178.402     0.150
     5.748   105.102     0.150
     5.748   179.803     0.150
     5.977    89.402     0.150
     5.977   185.902     0.150
     6.375    95.303     0.150
     6.375   117.002     0.150
     6.375   164.602     0.150
     6.375   198.602     0.150
     7.311   105.803     0.150
     7.542   108.740     0.150
     7.542   192.391     0.150
     7.542   236.191     0.150
     7.606   111.703     0.150
     7.606   195.902     0.150
     7.606   237.002     0.150
     8.344   121.703     0.150
     8.344   212.102     0.150
     8.344   258.402     0.150
     8.586   268.303     0.150
     8.706   127.303     0.150
     8.706   271.803     0.150
     8.961   281.102     0.150
     9.078   283.902     0.150
     9.579   299.102     0.150
     9.978   252.102     0.150
     9.978   311.703     0.150
    10.053   314.303     0.150
    10.483   150.203     0.150
    10.690   155.902     0.150
    10.690   331.902     0.150
    11.186   160.902     0.150
    11.186   283.002     0.150
    11.186   346.203     0.150
    11.661   168.803     0.150
    12.072   175.303     0.150
    12.072   375.703     0.150
    12.260   176.102     0.150
    12.260   382.902     0.150
    16.538   230.902     0.150
    16.925   240.902     0.150
    16.948   237.963     0.150
    19.211   265.652     0.150
    20.120   276.803     0.150
    20.120   280.953     0.150
    20.427   278.703     0.150
    20.427   501.203     0.150
    20.663   281.902     0.150
    21.241   287.902     0.150
    21.743   292.902     0.150
    23.728   312.303     0.150
    23.922   316.402     0.150
    23.951   315.902     0.150
    23.951   567.902     0.150
    23.951   619.402     0.150
    28.136   353.203     0.150
    31.036   379.082     0.150
    31.456   382.602     0.150
    31.828   386.902     0.150
    32.661   392.002     0.150
    37.730   435.002     0.150
    37.728   435.385     0.150
    37.728     4.475     0.150
    39.141   448.312     0.150
    39.867   454.070     0.150
    41.839   470.082     0.150
    42.103   471.473     0.150
    42.236   473.453     0.150
    42.236     4.600     0.150
    43.808   485.102     0.150
    44.306   489.477     0.150
    45.402   499.863     0.150
    45.437   498.703     0.150
    46.794   508.152     0.150
    48.168   521.768     0.150
    48.173   521.902     0.150
    48.351   522.902     0.150
    48.351     4.000     0.150
    49.867   532.539     0.150
    50.120   533.982     0.150
    53.809   561.697     0.150
    58.042   593.402     0.150
    58.216   595.402     0.150
    63.700   631.002     0.150
    63.717   630.102     0.150
    64.150   634.402     0.150
    64.698   638.832     0.150
    64.886   639.812     0.150
    65.173   641.873     0.150
    67.627   657.293     0.150
    67.648   658.502     0.150
    68.606   662.328     0.150
    68.852   665.502     0.150
    69.024   665.863     0.150
    69.601   670.271     0.150
    69.666   670.312     0.150
    70.055   672.502     0.150
    70.189   673.232     0.150
    72.806   689.053     0.150
    72.893   690.113     0.150
    72.965   688.432     0.150
    73.271   692.578     0.150
    73.271     4.350     0.150
    73.724   694.863     0.150
    74.769   699.703     0.150
    74.769     5.100     0.150
    77.018   713.893     0.150
    77.204   714.893     0.150
    77.426   715.311     0.150
    77.426     4.525     0.150
    81.039   735.252     0.150
    81.039     3.900     0.150
    81.039   735.203     0.150
    81.289   736.432     0.150
    83.172   746.062     0.150
    86.693   764.477     0.150
    86.693     5.301     0.150
    90.257   781.102     0.150
    90.257     4.352     0.150
    91.849   788.529     0.150
     1.019    33.177     0.150
     1.193    22.877     0.150
     2.539    46.677     0.150
     2.539    74.677     0.150
     2.663    43.877     0.150
     2.663    49.177     0.150
     2.663    76.776     0.150
     2.663    83.377     0.150
     2.895    47.077     0.150
     2.895    53.077     0.150
     2.895    83.776     0.150
     2.895    91.677     0.150
     3.272   104.677     0.150
     3.444    52.677     0.150
     3.444    61.276     0.150
     3.444    93.577     0.150
     3.444   106.677     0.150
     4.143    64.677     0.150
     4.143   129.577     0.150
     4.722    86.477     0.150
     4.722   123.377     0.150
     4.722   147.677     0.150
     5.315   166.877     0.150
     5.677   103.776     0.150
     5.677   178.377     0.150
     6.591   208.977     0.150
     0.658    12.961     0.150
     0.658    21.758     0.150
     0.902    17.555     0.150
     0.902    29.156     0.150
     1.879    35.055     0.150
     1.879    59.758     0.150
     2.102    36.055     0.150
     2.102    37.859     0.150
     2.102    64.656     0.150
     2.057    35.656     0.150
     2.057    38.461     0.150
     2.057    65.055     0.150
     2.661    44.055     0.150
     2.661    48.758     0.150
     2.661    85.055     0.150
     2.891    90.758     0.150
     3.223    52.156     0.150
     3.223    59.258     0.150
     3.223   101.758     0.150
     3.593    56.859     0.150
     3.593    65.656     0.150
     3.593   112.961     0.150
     4.162    77.461     0.150
     4.162   128.859     0.150
     4.832   151.656     0.150
     4.825   153.461     0.150
     6.022   186.758     0.150
    10.118   312.461     0.150
     0.695    22.816     0.150
     1.183    22.719     0.150
     1.183    38.816     0.150
     2.171    37.816     0.150
     2.171    40.617     0.150
     2.171    69.918     0.150
     2.426    42.418     0.150
     2.426    74.617     0.150
     2.567    44.316     0.150
     2.567    79.617     0.150
     2.568    44.418     0.150
     2.568    46.918     0.150
     2.568    80.016     0.150
     2.526    44.117     0.150
     2.526    77.316     0.150
     2.859    47.816     0.150
     2.859    51.617     0.150
     2.859    83.516     0.150
     2.859    90.516     0.150
     3.406    54.117     0.150
     3.406    58.816     0.150
     3.406    93.617     0.150
     3.406   102.918     0.150
     3.406   104.918     0.150
     3.662    57.418     0.150
     3.662    99.516     0.150
     3.662    67.516     0.150
     3.662   113.719     0.150
     3.919    70.617     0.150
     3.919    73.219     0.150
     3.919   105.617     0.150
     3.919   124.219     0.150
     4.343    79.617     0.150
     4.343   138.117     0.150
     4.343    68.516     0.150
     4.343   116.816     0.150
     4.811   151.816     0.150
     5.144    78.316     0.150
     5.144    94.016     0.150
     5.144   137.617     0.150
     5.144   161.219     0.150
     5.459    83.316     0.150
     5.459    98.816     0.150
     5.459   143.617     0.150
     5.459   170.617     0.150
     5.931   157.117     0.150
     5.931   180.617     0.150
     6.051   109.719     0.150
     6.051   190.918     0.150
     6.084    93.117     0.150
     6.084   112.219     0.150
     6.084   191.719     0.150
     6.612   120.516     0.150
     6.612   205.617     0.150
     7.258   184.117     0.150
     7.875   246.418     0.150
     8.381   260.117     0.150
     8.370   258.918     0.150
     8.960   277.816     0.150
     9.289   290.016     0.150
    10.224   320.516     0.150
    11.888   369.719     0.150
     0.560    10.872     0.150
     0.560    17.972     0.150
     0.567    10.772     0.150
     1.212    25.572     0.150
     1.212    23.272     0.150
     1.212    39.572     0.150
     2.153    37.972     0.150
     2.153    67.172     0.150
     2.153    39.272     0.150
     2.153    66.972     0.150
     2.687    49.272     0.150
     2.687    85.372     0.150
     2.687    84.372     0.150
     2.627    45.072     0.150
     2.627    83.272     0.150
     2.627    44.872     0.150
     2.627    47.972     0.150
     2.627    84.372     0.150
     3.002    49.772     0.150
     3.002    55.272     0.150
     3.002    94.272     0.150
     3.002    49.572     0.150
     3.002    55.472     0.150
     3.313    54.272     0.150
     3.313    60.772     0.150
     3.313   103.672     0.150
     3.313    61.072     0.150
     3.313    92.472     0.150
     3.313   103.972     0.150
     3.945    63.872     0.150
     3.945    73.572     0.150
     3.945   124.272     0.150
     3.945    63.272     0.150
     3.945    72.272     0.150
     3.945   123.272     0.150
     4.529    70.772     0.150
     4.529    81.972     0.150
     4.529   140.672     0.150
     4.529    82.672     0.150
     4.529   122.672     0.150
     4.529   141.272     0.150
     4.510    70.572     0.150
     4.510    82.272     0.150
     4.510    69.172     0.150
     4.510    80.872     0.150
     4.510   120.572     0.150
     4.510   142.972     0.150
     4.685    74.372     0.150
     4.685   127.172     0.150
     5.740    88.072     0.150
     5.740   177.972     0.150
     6.538   205.472     0.150
     6.542   205.472     0.150
     6.844   104.772     0.150
     6.844   104.472     0.150
     6.844   212.772     0.150
     6.944   104.672     0.150
     6.944   180.172     0.150
     6.944   218.972     0.150
     7.255   227.572     0.150
     8.120   254.272     0.150
     8.827   275.872     0.150
     9.320   288.772     0.150
     9.817   306.672     0.150
    10.206   316.272     0.150
    10.407   152.572     0.150
    10.407   321.972     0.150
     0.659    12.566     0.150
     0.659    21.465     0.150
     0.901    17.164     0.150
     0.901    18.465     0.150
     0.901    29.266     0.150
     2.058    34.965     0.150
     2.058    37.965     0.150
     2.058    64.266     0.150
     2.102    35.766     0.150
     2.102    37.363     0.150
     2.102    64.164     0.150
     2.102    37.965     0.150
     2.102    64.863     0.150
     2.661    43.363     0.150
     2.661    48.164     0.150
     2.661    83.566     0.150
     2.661    47.965     0.150
     2.661    84.066     0.150
     2.892    90.965     0.150
     3.225    51.363     0.150
     3.225    58.164     0.150
     3.225    90.066     0.150
     3.225   100.566     0.150
     3.225    51.465     0.150
     3.225    58.465     0.150
     3.225   101.766     0.150
     3.595    56.363     0.150
     3.595    65.164     0.150
     3.595    98.465     0.150
     3.595   111.363     0.150
     3.595   113.066     0.150
     4.164    63.566     0.150
     4.164    75.664     0.150
     4.164   130.566     0.150
     4.164    75.266     0.150
     4.164   130.465     0.150
     4.833    73.164     0.150
     4.833    88.363     0.150
     4.826    87.965     0.150
     4.826   124.465     0.150
     6.024    89.066     0.150
     0.267     6.266     0.150
     0.267     9.867     0.150
     0.267    11.062     0.150
     2.522    41.164     0.150
     2.522    45.461     0.150
     2.522    79.867     0.150
     2.749    43.164     0.150
     2.749    74.961     0.150
     2.749    82.867     0.150
     2.968    93.664     0.150
     3.169    50.961     0.150
     3.169    57.867     0.150
     3.169   100.461     0.150
     3.958   104.266     0.150
     3.958   123.664     0.150
     4.304    77.062     0.150
     4.304   113.664     0.150
     4.304   134.266     0.150
     4.706    71.562     0.150
     4.706    85.461     0.150
     4.706   124.664     0.150
     4.706   148.062     0.150
     5.250    76.867     0.150
     5.250    92.961     0.150
     5.250   134.062     0.150
     5.250   161.062     0.150
     5.236   162.461     0.150
     5.705   180.766     0.150
     5.934   108.664     0.150
     5.934   187.367     0.150
     0.727    14.074     0.150
     0.727    23.773     0.150
     1.004    19.473     0.150
     1.004    21.176     0.150
     1.004    32.574     0.150
     1.884    34.973     0.150
     1.884    59.875     0.150
     2.000    37.074     0.150
     2.000    62.973     0.150
     2.255    40.574     0.150
     2.255    69.473     0.150
     2.504    42.074     0.150
     2.504    45.973     0.150
     2.504    79.773     0.150
     3.227    58.574     0.150
     3.227   101.375     0.150
     3.542    56.375     0.150
     3.542    65.676     0.150
     3.542   111.676     0.150
     4.169   130.176     0.150
     4.351    80.176     0.150
     4.351   136.375     0.150
     4.545   142.273     0.150
     4.750    86.574     0.150
     4.750   148.973     0.150
     7.087   223.473     0.150
     0.694    13.414     0.150
     0.694    22.914     0.150
     1.712    31.312     0.150
     1.712    54.711     0.150
     1.964    35.312     0.150
     1.964    37.008     0.150
     1.964    62.812     0.150
     2.907    90.914     0.150
     2.990    49.914     0.150
     2.990    54.711     0.150
     2.990    82.914     0.150
     2.990    93.711     0.150
     3.028    49.008     0.150
     3.028    54.609     0.150
     3.028    83.414     0.150
     3.028    93.508     0.150
     4.249    77.211     0.150
     4.249   115.812     0.150
     4.249   133.312     0.150
     4.527    83.508     0.150
     4.527   122.914     0.150
     4.527   143.109     0.150
     5.035   158.711     0.150
     5.192   162.609     0.150
     5.233    95.211     0.150
     5.233   163.508     0.150
     5.678   178.414     0.150
     7.609   238.711     0.150
     1.256    40.117     0.150
     1.256    24.320     0.150
     1.256    39.922     0.150
     1.561    30.117     0.150
     1.561    31.117     0.150
     2.346    40.922     0.150
     2.346    43.320     0.150
     2.823    52.422     0.150
     2.823    88.117     0.150
     2.915    48.023     0.150
     2.915    91.422     0.150
     2.915    90.922     0.150
     2.956    87.320     0.150
     3.506   111.617     0.150
     3.527    56.922     0.150
     3.527    64.117     0.150
     3.527    96.117     0.150
     3.527   110.023     0.150
     3.677    58.117     0.150
     3.677    66.023     0.150
     3.677   113.219     0.150
     4.025    66.117     0.150
     4.025   108.617     0.150
     4.388    68.820     0.150
     4.388   116.219     0.150
     4.388   137.820     0.150
     4.533    70.820     0.150
     4.533    82.922     0.150
     4.533   120.320     0.150
     4.533   142.719     0.150
     4.839    75.422     0.150
     4.839    89.523     0.150
     4.839   151.922     0.150
     4.853    75.219     0.150
     4.853    89.820     0.150
     4.853   129.219     0.150
     4.853   155.219     0.150
     5.046    78.219     0.150
     5.046    92.719     0.150
     5.046   133.922     0.150
     5.046   159.320     0.150
     5.414    83.320     0.150
     5.414    98.523     0.150
     5.414   169.922     0.150
     5.782    89.617     0.150
     5.782    88.117     0.150
     5.782   105.617     0.150
     5.782   181.523     0.150
     6.127    92.523     0.150
     6.127   112.117     0.150
     6.127   192.922     0.150
     6.474   171.719     0.150
     6.725   174.023     0.150
     7.434   110.523     0.150
     7.434   136.617     0.150
     7.434   192.023     0.150
     7.434   232.922     0.150
     7.725   114.023     0.150
     7.725   141.523     0.150
     7.725   241.820     0.150
     7.754   113.219     0.150
     7.754   195.820     0.150
     7.919   117.820     0.150
     7.919   119.078     0.150
     8.079   120.523     0.150
     8.079   148.023     0.150
     8.079   251.719     0.150
     8.492   124.922     0.150
     8.628   127.219     0.150
     8.628   268.922     0.150
     8.684   271.820     0.150
     8.761   128.617     0.150
     8.761   273.422     0.150
     8.956   130.617     0.150
     8.956   227.219     0.150
     9.741   144.719     0.150
     9.741   304.922     0.150
     9.856   308.422     0.150
     9.915   144.117     0.150
    11.012   341.320     0.150
    11.376   167.422     0.150
    11.376   354.422     0.150
    11.914   371.922     0.150
    12.178   176.023     0.150
    12.178   378.820     0.150
    16.152   513.305     0.150
    16.196   227.219     0.150
    16.196   227.461     0.150
    76.618   711.758     0.150
    80.229   731.719     0.150
     0.719    13.992     0.150
     0.719    23.391     0.150
     1.117    20.891     0.150
     1.117    35.789     0.150
     1.117    35.391     0.150
     2.259    39.891     0.150
     2.259    41.688     0.150
     2.259    65.891     0.150
     2.259    70.188     0.150
     2.259    66.289     0.150
     2.302    43.086     0.150
     2.302    72.688     0.150
     2.406    41.391     0.150
     2.406    43.992     0.150
     2.406    75.688     0.150
     2.406    43.586     0.150
     2.406    75.992     0.150
     2.538    41.391     0.150
     2.538    45.992     0.150
     2.538    78.891     0.150
     2.538    41.688     0.150
     2.538    45.586     0.150
     2.538    78.586     0.150
     3.324   103.891     0.150
     3.645    58.492     0.150
     3.645    65.789     0.150
     3.645   113.391     0.150
     3.645    57.188     0.150
     3.645    65.391     0.150
     3.645    98.086     0.150
     3.645   110.891     0.150
     3.934   122.492     0.150
     3.947    62.586     0.150
     3.947    71.688     0.150
     3.947   108.586     0.150
     3.947   123.789     0.150
     3.947   107.289     0.150
     4.587    72.086     0.150
     4.587    83.289     0.150
     4.587   123.391     0.150
     4.587   144.086     0.150
     4.891    75.492     0.150
     4.891    89.586     0.150
     4.891   132.086     0.150
     4.891   153.289     0.150
     4.891    87.992     0.150
     5.132    94.891     0.150
     5.132   161.891     0.150
     5.132    92.492     0.150
     6.369    96.289     0.150
     6.369   164.289     0.150
     6.369   199.492     0.150
     7.134   185.492     0.150
     7.134   221.492     0.150
     7.173   222.891     0.150
     7.304   108.289     0.150
     7.304   189.188     0.150
     7.304   228.391     0.150
     7.304   107.289     0.150
     7.304   131.289     0.150
     7.464   111.391     0.150
     7.464   232.688     0.150
     7.667   238.789     0.150
     7.840   245.891     0.150
     9.448   295.492     0.150
     9.951   307.992     0.150
    10.419   323.188     0.150
     0.340     6.910     0.150
     0.340    11.910     0.150
     1.637    29.707     0.150
     1.637    52.207     0.150
     2.335    40.008     0.150
     2.335    42.410     0.150
     2.335    73.309     0.150
     2.792    46.809     0.150
     2.792    50.008     0.150
     2.792    78.809     0.150
     2.792    85.910     0.150
     2.878    46.309     0.150
     2.878    52.109     0.150
     2.878    82.008     0.150
     2.878    90.508     0.150
     3.041    50.008     0.150
     3.041    54.609     0.150
     3.041    95.008     0.150
     3.354    61.609     0.150
     3.354    92.508     0.150
     3.354   103.609     0.150
     3.446    62.410     0.150
     3.446   105.410     0.150
     3.729    59.109     0.150
     3.729    67.207     0.150
     3.729   102.508     0.150
     3.729   116.508     0.150
     3.883    62.910     0.150
     3.883    71.109     0.150
     3.883   105.109     0.150
     3.883   120.707     0.150
     4.140    74.207     0.150
     4.140   122.109     0.150
     4.221    64.707     0.150
     4.221    75.609     0.150
     4.221   132.207     0.150
     4.280    78.207     0.150
     4.280   129.207     0.150
     4.582    71.309     0.150
     4.582    83.109     0.150
     4.582   124.207     0.150
     4.582   144.207     0.150
     5.158    79.809     0.150
     5.158    94.508     0.150
     5.158   161.207     0.150
     5.215    79.707     0.150
     5.215    93.809     0.150
     5.215   164.508     0.150
     5.500   173.109     0.150
     5.717    86.207     0.150
     5.717   105.410     0.150
     5.717   149.508     0.150
     5.717   180.410     0.150
     5.787   104.508     0.150
     5.787   152.207     0.150
     5.787   181.309     0.150
     6.757   101.609     0.150
     6.757   202.309     0.150
     7.009   220.508     0.150
     7.663   111.008     0.150
     7.663   195.410     0.150
     7.791   241.008     0.150
     7.827   244.809     0.150
     7.895   116.410     0.150
     7.895   245.410     0.150
     8.112   252.008     0.150
     8.498   265.207     0.150
     0.360     7.119     0.150
     0.360    12.219     0.150
     0.360    12.020     0.150
     1.642    30.020     0.150
     1.642    52.719     0.150
     1.642    29.619     0.150
     1.642    51.319     0.150
     2.313    40.319     0.150
     2.313    42.619     0.150
     2.313    73.619     0.150
     2.313    39.819     0.150
     2.313    42.819     0.150
     2.313    68.520     0.150
     2.313    72.619     0.150
     2.806    47.020     0.150
     2.806    51.020     0.150
     2.806    79.319     0.150
     2.806    86.119     0.150
     2.806    50.020     0.150
     2.806    85.919     0.150
     2.881    52.819     0.150
     2.881    91.419     0.150
     3.039    50.319     0.150
     3.039    55.119     0.150
     3.039    84.719     0.150
     3.039    95.319     0.150
     3.039    95.919     0.150
     3.350    61.719     0.150
     3.350   105.520     0.150
     3.350    59.719     0.150
     3.350   101.719     0.150
     3.442    56.319     0.150
     3.442    61.619     0.150
     3.442   107.419     0.150
     3.717    58.719     0.150
     3.717    67.520     0.150
     3.717   117.219     0.150
     3.887    71.919     0.150
     3.887   122.619     0.150
     4.146    66.319     0.150
     4.146   124.619     0.150
     4.224    66.520     0.150
     4.224    75.919     0.150
     4.224   132.020     0.150
     4.224    66.020     0.150
     4.224    77.119     0.150
     4.224   132.719     0.150
     4.580    71.520     0.150
     4.580    82.520     0.150
     4.580   144.219     0.150
     4.580    71.419     0.150
     4.580    82.319     0.150
     4.580   122.719     0.150
     5.162    78.819     0.150
     5.162    93.719     0.150
     5.162   135.020     0.150
     5.162   161.619     0.150
     5.162    78.419     0.150
     5.203    79.219     0.150
     5.203    95.020     0.150
     5.203   163.719     0.150
     5.485   173.819     0.150
     5.703    86.419     0.150
     5.703   149.219     0.150
     5.703   180.419     0.150
     5.782    87.719     0.150
     5.782   104.719     0.150
     5.782   179.819     0.150
     6.761   101.020     0.150
     6.761   203.020     0.150
     7.006   104.719     0.150
     7.006   179.919     0.150
     7.006   219.819     0.150
     7.880   116.419     0.150
     7.880   200.919     0.150
     7.880   116.719     0.150
     8.492   266.619     0.150
     9.382   291.020     0.150
    10.587   330.020     0.150
    11.069   346.119     0.150
    11.472   358.819     0.150
    11.664   362.219     0.150
    24.313   320.919     0.150
    49.498   530.520     0.150
    49.498   642.719     0.150
     0.933    18.238     0.150
     0.933    30.039     0.150
     0.933    29.838     0.150
     2.396    40.639     0.150
     2.396    69.738     0.150
     2.396    40.338     0.150
     2.396    43.438     0.150
     2.396    73.338     0.150
     2.530    41.938     0.150
     2.530    46.438     0.150
     2.530    72.738     0.150
     2.530    79.938     0.150
     2.704    49.838     0.150
     3.219    59.639     0.150
     3.219    99.938     0.150
     3.345    52.838     0.150
     3.345    59.539     0.150
     3.345   101.639     0.150
     3.356   100.738     0.150
     3.831    60.639     0.150
     4.639    83.039     0.150
     4.639   140.238     0.150
     4.695    72.238     0.150
     4.695    85.238     0.150
     4.984    91.238     0.150
     4.984   155.738     0.150
     5.372    81.838     0.150
     5.372   166.639     0.150
     5.372    81.338     0.150
     5.372    97.039     0.150
     5.372   142.039     0.150
     5.915   108.139     0.150
     5.915   184.838     0.150
     5.966   179.539     0.150
     6.192   195.438     0.150
     6.577   205.338     0.150
     6.942   121.838     0.150
     6.942   209.838     0.150
     7.420   233.039     0.150
     8.579   266.838     0.150
     8.557   267.438     0.150
     8.903   278.539     0.150
     0.671    13.014     0.150
     0.671    22.214     0.150
     0.871    16.313     0.150
     0.871    28.014     0.150
     0.871    27.414     0.150
     2.108    39.014     0.150
     2.108    67.214     0.150
     2.209    37.514     0.150
     2.209    40.214     0.150
     2.209    69.113     0.150
     2.209    37.914     0.150
     2.209    39.914     0.150
     2.209    67.613     0.150
     2.292    39.014     0.150
     2.292    42.014     0.150
     2.292    66.813     0.150
     2.292    71.714     0.150
     2.292    42.214     0.150
     2.292    71.613     0.150
     2.592    43.613     0.150
     2.592    47.014     0.150
     2.592    75.113     0.150
     2.592    81.613     0.150
     2.592    43.813     0.150
     3.451    55.214     0.150
     3.451    62.514     0.150
     3.451   107.914     0.150
     3.829    60.714     0.150
     3.829    71.014     0.150
     3.829   119.514     0.150
     3.829    71.313     0.150
     3.829   104.214     0.150
     4.389    69.414     0.150
     4.389    80.514     0.150
     4.389   136.813     0.150
     5.003    92.313     0.150
     5.003   157.113     0.150
     5.065    77.414     0.150
     5.065    91.613     0.150
     6.258   194.514     0.150
     6.362   200.914     0.150
     7.080   105.313     0.150
     7.080   221.113     0.150
     7.100   219.414     0.150
     7.371   230.813     0.150
     7.430   133.514     0.150
     7.430   229.714     0.150
     7.430   132.414     0.150
     9.834   308.014     0.150
     0.226     4.914     0.150
     0.226     7.812     0.150
     0.226     4.812     0.150
     0.226     7.711     0.150
     1.350    25.211     0.150
     1.350    42.812     0.150
     1.350    43.211     0.150
     2.505    40.914     0.150
     2.505    45.016     0.150
     2.505    71.516     0.150
     2.505    77.609     0.150
     2.505    75.516     0.150
     2.499    42.016     0.150
     2.499    45.414     0.150
     2.499    72.812     0.150
     2.499    78.312     0.150
     2.499    45.711     0.150
     2.499    72.609     0.150
     2.499    78.711     0.150
     2.598    44.914     0.150
     2.598    47.609     0.150
     2.598    81.812     0.150
     2.598    82.109     0.150
     2.789    46.109     0.150
     2.789    50.609     0.150
     2.789    87.016     0.150
     2.789    87.414     0.150
     3.596    57.711     0.150
     3.596    66.016     0.150
     3.596   100.414     0.150
     3.596   113.516     0.150
     3.596    66.414     0.150
     3.596   112.711     0.150
     3.733    59.516     0.150
     3.733   117.109     0.150
     3.733    60.711     0.150
     3.733    67.812     0.150
     3.733   104.711     0.150
     3.733   115.914     0.150
     3.938    61.711     0.150
     3.938    71.211     0.150
     3.938   107.211     0.150
     3.938   122.711     0.150
     3.938    61.914     0.150
     3.938   106.516     0.150
     3.938   122.914     0.150
     4.025    71.414     0.150
     4.025   125.609     0.150
     4.327    67.609     0.150
     4.327    78.914     0.150
     4.327   116.312     0.150
     4.327   135.016     0.150
     4.327    78.312     0.150
     4.327   134.711     0.150
     4.873    74.914     0.150
     4.873    88.516     0.150
     4.873   152.109     0.150
     4.873    75.516     0.150
     4.873   152.211     0.150
     5.386    81.016     0.150
     5.386    98.312     0.150
     5.386   169.109     0.150
     5.556    84.312     0.150
     5.556   100.414     0.150
     5.556   146.609     0.150
     5.556    83.312     0.150
     5.556    99.414     0.150
     6.394   200.211     0.150
     6.756   100.812     0.150
     6.756   210.711     0.150
     6.756   101.109     0.150
     7.568   236.414     0.150
     7.798   113.609     0.150
     7.798   242.211     0.150
     7.867   116.109     0.150
     7.867   246.016     0.150
     8.095   254.016     0.150
     8.280   260.711     0.150
     9.145   286.312     0.150
     9.849   306.609     0.150
    10.333   321.711     0.150
    10.844   338.211     0.150
    11.214   349.312     0.150
    11.390   354.516     0.150
     0.318     6.621     0.150
     0.318    10.918     0.150
     0.318    10.719     0.150
     1.254    23.418     0.150
     1.254    23.520     0.150
     1.254    40.719     0.150
     2.489    42.418     0.150
     2.489    45.918     0.150
     2.454    40.719     0.150
     2.454    44.219     0.150
     2.454    71.418     0.150
     2.454    75.418     0.150
     2.454    40.418     0.150
     2.454    43.621     0.150
     2.454    74.719     0.150
     2.499    42.020     0.150
     2.499    45.719     0.150
     2.499    70.820     0.150
     2.499    78.621     0.150
     2.684    44.621     0.150
     2.684    49.320     0.150
     2.684    84.418     0.150
     2.684    84.219     0.150
     3.500    55.820     0.150
     3.500    64.020     0.150
     3.500   110.820     0.150
     3.500    64.121     0.150
     3.500   110.520     0.150
     3.840    60.621     0.150
     3.840    69.918     0.150
     3.840   105.621     0.150
     3.840   120.020     0.150
     3.840    60.820     0.150
     3.840    70.121     0.150
     3.840   120.320     0.150
     3.828    60.520     0.150
     3.828    69.520     0.150
     3.828   119.219     0.150
     3.828    61.121     0.150
     3.828    71.520     0.150
     4.092    63.918     0.150
     4.092    74.918     0.150
     4.092   112.320     0.150
     4.092   128.219     0.150
     4.222    66.020     0.150
     4.222    77.719     0.150
     4.222   115.121     0.150
     4.222   132.418     0.150
     4.222    77.320     0.150
     4.776    73.621     0.150
     4.776    86.820     0.150
     4.776   150.121     0.150
     4.776    88.121     0.150
     5.291    79.621     0.150
     5.291    96.719     0.150
     5.291   140.320     0.150
     5.291   166.418     0.150
     5.449    82.520     0.150
     5.449    99.820     0.150
     5.449   144.520     0.150
     5.449   170.719     0.150
     6.064    91.121     0.150
     6.064   110.121     0.150
     6.064   155.418     0.150
     6.064   188.121     0.150
     6.651    98.820     0.150
     6.651   120.820     0.150
     6.651   207.820     0.150
     7.459   107.590     0.150
     7.462   109.820     0.150
     7.462   189.219     0.150
     7.462   233.719     0.150
     7.486   111.320     0.150
     7.486   231.520     0.150
     7.706   111.719     0.150
     7.761   114.418     0.150
     7.761   199.418     0.150
     7.761   240.820     0.150
     8.039   252.320     0.150
     8.039   147.820     0.150
     8.069   118.020     0.150
     8.069   115.461     0.150
     8.069   203.488     0.150
     8.173   118.918     0.150
     8.173   256.121     0.150
     9.039   281.621     0.150
     9.102   282.520     0.150
     9.744   304.121     0.150
    10.228   317.320     0.150
    10.737   335.020     0.150
    11.133   161.320     0.150
    11.292   161.918     0.150
    11.292   286.098     0.150
    14.090   203.520     0.150
    14.090   200.371     0.150
    15.822   223.418     0.150
    16.337   236.320     0.150
    16.337   420.320     0.150
    16.337   427.520     0.150
    16.337   523.320     0.150
    16.647   238.520     0.150
    16.670   236.441     0.150
    16.856   238.320     0.150
    17.484   242.320     0.150
    17.484   244.969     0.150
    19.507   267.418     0.150
    19.962   274.621     0.150
    20.318   278.750     0.150
    20.961   285.320     0.150
    20.961   289.520     0.150
    20.961   292.320     0.150
    20.961   517.320     0.150
    20.961   523.520     0.150
    20.961   550.520     0.150
    20.961   662.020     0.150
    22.655   303.820     0.150
    22.655   588.020     0.150
    22.994   306.320     0.150
    22.994   551.520     0.150
    23.469   312.121     0.150
    23.469   310.551     0.150
    23.784   313.199     0.150
    23.930   314.996     0.150
    24.586   322.020     0.150
    25.632   331.320     0.150
    27.196   344.203     0.150
    27.238   344.508     0.150
    30.433   374.898     0.150
    30.473   375.191     0.150
    30.595   376.398     0.150
    30.821   379.070     0.150
    30.855   378.488     0.150
    31.228   381.320     0.150
    31.232   381.930     0.150
    31.347   380.598     0.150
    31.863   452.520     0.150
    31.863   555.520     0.150
    31.863   700.418     0.150
    31.863  1014.820     0.150
    31.863   385.621     0.150
    33.358   401.320     0.150
    33.358   471.820     0.150
    33.358   841.520     0.150
    36.290   424.820     0.150
    37.001   431.320     0.150
    37.197   433.520     0.150
    37.564   435.125     0.150
    37.567   437.199     0.150
    37.766   437.621     0.150
    37.834   439.418     0.150
    37.834   785.520     0.150
    39.474   449.871     0.150
    39.880   454.941     0.150
    40.697   461.969     0.150
    40.697   557.219     0.150
    40.900   462.020     0.150
    42.968   479.871     0.150
    43.337   484.750     0.150
    43.760   484.668     0.150
    44.066   488.199     0.150
    44.062   487.520     0.150
    44.235   489.691     0.150
    44.892   495.195     0.150
    46.003   504.840     0.150
    46.377   507.520     0.150
    47.315   515.719     0.150
    47.315   628.820     0.150
    47.315   929.820     0.150
    47.315   515.840     0.150
    49.035   528.520     0.150
    49.381   529.645     0.150
    49.381     4.148     0.150
    49.411   529.219     0.150
    49.411   529.008     0.150
    49.411     4.137     0.150
    49.663   533.879     0.150
    50.046   535.949     0.150
    53.104   558.508     0.150
    53.588   563.398     0.150
    54.394   566.164     0.150
    54.394     3.750     0.150
    55.057   573.168     0.150
    55.057     4.000     0.150
    55.260   573.129     0.150
    55.348   574.520     0.150
    55.991   578.520     0.150
    57.437   589.551     0.150
    57.430   589.121     0.150
    57.430     3.797     0.150
    57.599   590.406     0.150
    57.599     4.203     0.150
    60.077   609.914     0.150
    60.460   610.547     0.150
    60.836   612.789     0.150
    60.815   612.594     0.150
    60.815     4.535     0.150
    61.207   618.219     0.150
    61.355   619.719     0.150
    62.135   622.207     0.150
    62.138   622.703     0.150
    62.299   624.453     0.150
    62.333   624.281     0.150
    62.529   625.484     0.150
    62.721   626.469     0.150
    62.917   627.871     0.150
    63.126   631.621     0.150
    63.527   634.770     0.150
    63.755   635.621     0.150
    64.336   634.820     0.150
    64.374   639.219     0.150
    64.498   640.520     0.150
    64.875   642.621     0.150
    64.953   641.219     0.150
    65.380   643.984     0.150
    65.472   646.719     0.150
    65.855   647.281     0.150
    66.080   649.457     0.150
    66.738   655.020     0.150
    66.831   654.082     0.150
    68.195   665.121     0.150
    68.318   662.211     0.150
    68.825   663.695     0.150
    68.946   665.871     0.150
    70.004   672.430     0.150
    70.301   674.809     0.150
    70.424   674.980     0.150
    70.753   677.621     0.150
    70.909   678.500     0.150
    72.272   685.832     0.150
    73.200   691.570     0.150
    73.200     4.488     0.150
    73.601   694.738     0.150
    74.048   697.746     0.150
    74.450   699.809     0.150
    74.722   700.230     0.150
    76.175   710.219     0.150
    77.347   716.719     0.150
    77.510   715.551     0.150
    77.518   715.730     0.150
    77.520   715.520     0.150
    77.719   718.309     0.150
    77.791   718.578     0.150
    77.897   719.391     0.150
    79.043   725.270     0.150
    81.114   735.520     0.150
    83.796   750.328     0.150
    84.651   754.840     0.150
   136.626  1162.219     0.150
   136.626  1161.410     0.150
   145.646  1180.578     0.150
   145.646  1180.199     0.150
   146.392  1179.121     0.150
   149.530  1188.895     0.150
   149.530  1189.328     0.150
   151.660  1187.379     0.150
   151.660  1193.070     0.150
   153.155  1200.219     0.150
   153.460  1201.020     0.150
   153.867  1201.418     0.150
     0.304     6.414     0.150
     0.304    10.414     0.150
     1.256    23.012     0.150
     1.256    23.414     0.150
     1.256    40.414     0.150
     1.256    40.113     0.150
     2.445    40.812     0.150
     2.445    44.012     0.150
     2.445    75.711     0.150
     2.445    39.812     0.150
     2.445    43.211     0.150
     2.445    74.414     0.150
     2.502    45.613     0.150
     2.502    79.012     0.150
     2.502    41.414     0.150
     2.502    79.113     0.150
     2.505    42.012     0.150
     2.505    45.211     0.150
     2.505    73.012     0.150
     2.505    79.113     0.150
     2.505    45.914     0.150
     2.505    78.512     0.150
     2.691    44.414     0.150
     2.691    48.711     0.150
     2.691    84.113     0.150
     2.691    83.613     0.150
     3.502    56.613     0.150
     3.502    64.812     0.150
     3.502   110.512     0.150
     3.502    63.211     0.150
     3.502   110.211     0.150
     3.826    60.211     0.150
     3.826    70.711     0.150
     3.826   105.012     0.150
     3.826   119.914     0.150
     3.826    70.512     0.150
     3.843    60.312     0.150
     3.843    70.312     0.150
     3.843   120.914     0.150
     3.843    60.211     0.150
     3.843    69.613     0.150
     3.843   105.312     0.150
     3.843   119.414     0.150
     4.097    63.312     0.150
     4.097   125.812     0.150
     4.229    65.711     0.150
     4.229    77.113     0.150
     4.229   114.113     0.150
     4.229   132.312     0.150
     4.229    76.113     0.150
     4.229   113.211     0.150
     4.778    72.812     0.150
     4.778    86.812     0.150
     4.778   150.512     0.150
     4.778    73.914     0.150
     4.778    86.613     0.150
     4.778   148.914     0.150
     5.306    79.613     0.150
     5.306    96.613     0.150
     5.306   142.312     0.150
     5.306   167.914     0.150
     5.306   142.512     0.150
     5.458    82.012     0.150
     5.458    98.914     0.150
     5.458   144.012     0.150
     5.458   170.211     0.150
     5.458    98.113     0.150
     5.582   101.613     0.150
     5.582   173.211     0.150
     6.071   112.914     0.150
     6.071   193.711     0.150
     6.658    98.711     0.150
     6.658   172.812     0.150
     6.658   208.211     0.150
     7.471   233.312     0.150
    10.234   317.312     0.150
    10.746   335.512     0.150
    11.115   343.113     0.150
    11.292   352.812     0.150
     0.303     6.289     0.150
     0.303    10.191     0.150
     0.303     6.391     0.150
     0.303     9.992     0.150
     1.261    23.090     0.150
     1.261    40.289     0.150
     1.261    42.992     0.150
     1.261    24.090     0.150
     2.452    40.891     0.150
     2.452    44.090     0.150
     2.452    68.891     0.150
     2.452    75.289     0.150
     2.452    43.391     0.150
     2.452    74.691     0.150
     2.499    41.789     0.150
     2.499    45.191     0.150
     2.499    73.191     0.150
     2.499    78.992     0.150
     2.499    41.891     0.150
     2.499    45.789     0.150
     2.499    78.492     0.150
     2.507    41.691     0.150
     2.507    45.492     0.150
     2.507    78.391     0.150
     2.695    44.492     0.150
     2.695    48.891     0.150
     2.695    84.492     0.150
     2.695    49.090     0.150
     2.695    84.191     0.150
     3.507    64.191     0.150
     3.507    98.191     0.150
     3.507   110.492     0.150
     3.507    63.789     0.150
     3.821    61.191     0.150
     3.821    68.789     0.150
     3.821   116.992     0.150
     3.821    69.391     0.150
     3.821   104.391     0.150
     3.821   116.691     0.150
     3.848    60.789     0.150
     3.848    70.289     0.150
     3.848   120.789     0.150
     3.848    60.391     0.150
     3.848    69.691     0.150
     4.091    63.891     0.150
     4.091    74.090     0.150
     4.091   126.090     0.150
     4.233    65.891     0.150
     4.233    78.492     0.150
     4.233   113.789     0.150
     4.233   131.891     0.150
     4.784    74.492     0.150
     4.784    87.789     0.150
     4.784   150.992     0.150
     4.784    87.492     0.150
     5.306    96.691     0.150
     5.306   165.691     0.150
     5.462    99.992     0.150
     5.462   145.891     0.150
     5.462   170.691     0.150
     5.575   170.992     0.150
     6.064   189.789     0.150
     6.662    99.590     0.150
     7.474   233.191     0.150
     7.498   235.992     0.150
     7.773   241.391     0.150
     8.001   249.590     0.150
     8.186   256.789     0.150
     9.051   280.789     0.150
     9.755   302.289     0.150
    10.239   318.992     0.150
    10.750   336.492     0.150
    11.120   346.289     0.150
    11.298   349.391     0.150
     0.513    10.073     0.150
     0.513    17.073     0.150
     0.513    10.173     0.150
     1.159    21.173     0.150
     1.159    24.073     0.150
     1.159    36.673     0.150
     1.159    40.073     0.150
     1.159    21.073     0.150
     1.159    37.173     0.150
     2.385    43.973     0.150
     2.385    74.973     0.150
     2.384    40.773     0.150
     2.384    43.373     0.150
     2.384    74.973     0.150
     2.384    43.873     0.150
     2.384    75.873     0.150
     2.473    41.473     0.150
     2.473    44.673     0.150
     2.473    71.373     0.150
     2.473    76.873     0.150
     2.473    44.173     0.150
     2.473    76.473     0.150
     2.535    42.473     0.150
     2.535    46.073     0.150
     2.535    72.073     0.150
     2.535    79.973     0.150
     3.397   107.573     0.150
     3.729    59.373     0.150
     3.729    67.273     0.150
     3.729   115.773     0.150
     3.939    72.173     0.150
     3.939   124.273     0.150
     4.076    64.073     0.150
     4.076    74.673     0.150
     4.076   128.073     0.150
     4.126   127.673     0.150
     4.669   147.773     0.150
     5.096    92.373     0.150
     5.096   134.973     0.150
     5.096   159.373     0.150
     5.286    80.573     0.150
     5.286    96.473     0.150
     5.286   166.073     0.150
     5.286    95.573     0.150
     5.606   100.873     0.150
     5.606   146.573     0.150
     5.606   173.873     0.150
     6.503    96.973     0.150
     6.503   203.873     0.150
     7.294   185.973     0.150
     7.294   227.073     0.150
     8.882   278.473     0.150
    10.083   315.673     0.150
    11.161   348.373     0.150
     0.320     6.682     0.150
     0.320    10.582     0.150
     1.259    23.382     0.150
     1.259    39.882     0.150
     2.462    41.782     0.150
     2.462    44.182     0.150
     2.462    71.082     0.150
     2.462    75.182     0.150
     2.481    42.082     0.150
     2.481    45.482     0.150
     2.481    78.782     0.150
     2.687    44.682     0.150
     2.687    49.182     0.150
     2.687    83.882     0.150
     3.505    64.182     0.150
     3.505   110.182     0.150
     3.823    67.682     0.150
     3.823   101.082     0.150
     3.823   117.282     0.150
     3.845    60.782     0.150
     3.845    69.782     0.150
     3.845   119.782     0.150
     4.084    72.382     0.150
     4.084   125.882     0.150
     4.225    65.982     0.150
     4.225    77.482     0.150
     4.225   115.182     0.150
     4.225   132.382     0.150
     4.781    87.182     0.150
     4.781   149.682     0.150
     5.288    97.282     0.150
     5.288   166.482     0.150
     5.451    82.682     0.150
     5.451    99.082     0.150
     5.451   170.182     0.150
     5.568   144.282     0.150
     5.568   169.582     0.150
     6.056   190.682     0.150
     6.654    99.382     0.150
     6.654   206.482     0.150
     7.703   239.382     0.150
     7.764   243.082     0.150
     0.343     7.150     0.150
     0.343    11.450     0.150
     1.236    22.950     0.150
     1.236    39.350     0.150
     1.236    23.050     0.150
     1.236    39.050     0.150
     2.063    36.150     0.150
     2.063    37.350     0.150
     2.063    64.950     0.150
     2.449    40.450     0.150
     2.449    43.850     0.150
     2.449    75.150     0.150
     2.449    39.850     0.150
     2.449    43.450     0.150
     2.449    74.850     0.150
     2.479    77.750     0.150
     2.481    41.050     0.150
     2.481    44.950     0.150
     2.481    72.550     0.150
     2.481    78.050     0.150
     2.661    44.550     0.150
     2.661    48.750     0.150
     2.661    83.550     0.150
     2.661    84.050     0.150
     3.482   109.050     0.150
     3.821    60.450     0.150
     3.821    69.550     0.150
     3.821   118.650     0.150
     3.821    60.150     0.150
     3.821   105.250     0.150
     3.821   120.250     0.150
     3.847   120.450     0.150
     3.847    67.850     0.150
     3.847   120.650     0.150
     3.871    60.850     0.150
     3.871   118.450     0.150
     4.011    72.450     0.150
     4.011   122.550     0.150
     4.200    65.450     0.150
     4.200    76.650     0.150
     4.200   130.750     0.150
     4.495    77.750     0.150
     4.495   138.350     0.150
     4.757    86.550     0.150
     4.757   147.850     0.150
     5.266    96.450     0.150
     5.266   165.550     0.150
     5.426    99.150     0.150
     5.426   169.550     0.150
     5.586    84.650     0.150
     5.586   144.250     0.150
     6.071   193.650     0.150
     6.629   207.350     0.150
     7.682   239.350     0.150
     7.738   241.450     0.150
     8.149   255.350     0.150
     0.348     6.950     0.150
     0.348    11.351     0.150
     1.229    23.351     0.150
     1.229    24.950     0.150
     1.229    39.450     0.150
     2.069    37.650     0.150
     2.069    64.751     0.150
     2.445    44.051     0.150
     2.445    75.650     0.150
     2.473    78.150     0.150
     2.482    42.450     0.150
     2.482    45.351     0.150
     2.482    79.251     0.150
     2.655    48.551     0.150
     2.655    83.051     0.150
     3.853   120.150     0.150
     4.008    72.751     0.150
     4.008   124.551     0.150
     4.107    74.650     0.150
     4.107   128.551     0.150
     4.107    73.950     0.150
     4.107   127.051     0.150
     4.193    66.051     0.150
     4.193    76.751     0.150
     4.193   131.351     0.150
     5.591   174.251     0.150
     7.958   245.150     0.150
     8.099   248.351     0.150
     0.395     7.965     0.150
     0.395    12.865     0.150
     1.216    22.766     0.150
     1.216    38.465     0.150
     2.081    37.665     0.150
     2.081    64.665     0.150
     2.462    44.165     0.150
     2.462    69.465     0.150
     2.462    76.065     0.150
     2.454    77.165     0.150
     2.444    41.465     0.150
     2.444    44.665     0.150
     2.444    77.766     0.150
     2.626    44.365     0.150
     2.626    48.266     0.150
     2.626    75.865     0.150
     2.626    81.865     0.150
     3.797    68.965     0.150
     3.797   101.865     0.150
     3.797   117.865     0.150
     3.869   118.766     0.150
     4.037   124.465     0.150
     4.102   128.465     0.150
     4.166    65.465     0.150
     4.166    76.266     0.150
     4.166   111.965     0.150
     4.166   130.065     0.150
     4.735   147.965     0.150
     5.214   162.365     0.150
     8.001   246.465     0.150
     0.359     7.127     0.150
     0.359    11.427     0.150
     1.223    23.227     0.150
     1.223    39.526     0.150
     1.223    39.327     0.150
     2.076    36.526     0.150
     2.076    38.227     0.150
     2.076    65.227     0.150
     2.445    44.327     0.150
     2.445    75.827     0.150
     2.445    41.026     0.150
     2.445    44.127     0.150
     2.465    77.627     0.150
     2.477    42.127     0.150
     2.477    45.327     0.150
     2.477    78.327     0.150
     2.477    42.327     0.150
     2.477    73.026     0.150
     2.477    78.727     0.150
     2.646    44.727     0.150
     2.646    48.827     0.150
     2.646    77.127     0.150
     2.646    83.427     0.150
     3.468    63.827     0.150
     3.468   109.327     0.150
     3.807    60.827     0.150
     3.807    69.627     0.150
     3.807   104.126     0.150
     3.807   119.728     0.150
     3.807    59.427     0.150
     3.807    69.327     0.150
     3.807   103.927     0.150
     3.860    70.026     0.150
     3.860   119.228     0.150
     3.860    63.127     0.150
     3.860    70.327     0.150
     3.860   119.526     0.150
     3.860    62.427     0.150
     3.860   119.827     0.150
     4.011   122.427     0.150
     4.110    64.727     0.150
     4.110    74.526     0.150
     4.110   111.126     0.150
     4.110   128.327     0.150
     4.110    74.127     0.150
     4.110   112.228     0.150
     4.184    65.927     0.150
     4.184    75.827     0.150
     4.184   111.327     0.150
     4.184   131.626     0.150
     4.511   137.526     0.150
     4.744    74.227     0.150
     4.744    87.427     0.150
     4.744   148.126     0.150
     5.250    79.427     0.150
     5.250    95.927     0.150
     5.250   164.228     0.150
     5.250    82.026     0.150
     5.409    82.526     0.150
     5.409    98.827     0.150
     5.409   143.228     0.150
     5.409   168.526     0.150
     5.409    82.627     0.150
     5.409    98.126     0.150
     5.593    82.927     0.150
     5.593    98.827     0.150
     5.593   143.927     0.150
     5.593   174.427     0.150
     6.078    91.626     0.150
     6.078   111.228     0.150
     6.078   158.228     0.150
     6.078   191.626     0.150
     6.613   169.927     0.150
     6.613   206.327     0.150
     7.421   110.026     0.150
     7.421   232.728     0.150
     7.446   230.327     0.150
     7.666   111.927     0.150
     7.666   238.626     0.150
     7.722   114.728     0.150
     7.722   240.728     0.150
     7.722   114.327     0.150
     7.948   248.427     0.150
     8.111   208.927     0.150
     8.133   119.827     0.150
     8.133   254.827     0.150
     9.000   279.728     0.150
     9.705   301.126     0.150
    10.190   316.427     0.150
    10.697   333.728     0.150
    11.072   343.026     0.150
    11.253   349.626     0.150
     0.274     6.086     0.150
     0.274     9.785     0.150
     1.277    23.184     0.150
     1.277    40.387     0.150
     1.277    42.887     0.150
     1.277    22.984     0.150
     1.277    40.285     0.150
     2.027    35.184     0.150
     2.027    63.484     0.150
     2.450    40.887     0.150
     2.450    43.785     0.150
     2.450    74.984     0.150
     2.450    40.086     0.150
     2.450    43.484     0.150
     2.450    69.785     0.150
     2.525    41.785     0.150
     2.525    45.285     0.150
     2.525    45.484     0.150
     2.517    41.785     0.150
     2.517    45.086     0.150
     2.517    78.387     0.150
     2.517    41.887     0.150
     2.517    45.387     0.150
     2.517    78.887     0.150
     2.718    44.984     0.150
     2.718    48.785     0.150
     2.718    83.984     0.150
     2.718    48.684     0.150
     2.718    84.387     0.150
     3.523    63.484     0.150
     3.523   109.086     0.150
     3.523   109.984     0.150
     3.865    60.484     0.150
     3.865    69.086     0.150
     3.865   119.387     0.150
     3.865    60.086     0.150
     3.865    69.586     0.150
     3.865   119.586     0.150
     3.805    60.785     0.150
     3.805    68.684     0.150
     3.805   117.285     0.150
     3.805    61.387     0.150
     3.805    68.887     0.150
     3.805   111.984     0.150
     3.805    67.387     0.150
     3.805   117.086     0.150
     3.992    62.184     0.150
     3.992    72.887     0.150
     3.992   120.785     0.150
     4.087    63.785     0.150
     4.087    73.086     0.150
     4.087   127.086     0.150
     4.087    63.984     0.150
     4.087    73.785     0.150
     4.087   125.684     0.150
     4.255    65.785     0.150
     4.255    76.887     0.150
     4.255   131.785     0.150
     4.435    77.086     0.150
     4.435   136.484     0.150
     4.800    73.586     0.150
     4.800    86.984     0.150
     4.800   149.586     0.150
     4.800    73.984     0.150
     4.800    87.184     0.150
     5.335    81.684     0.150
     5.335    96.887     0.150
     5.335   166.285     0.150
     5.335    80.086     0.150
     5.335    95.684     0.150
     5.486   169.887     0.150
     5.572    96.785     0.150
     5.572   170.285     0.150
     7.499   138.684     0.150
     7.499   232.785     0.150
     7.751   241.984     0.150
     7.751   112.387     0.150
     7.751   197.387     0.150
     7.796   242.285     0.150
     7.885   112.887     0.150
     8.026   114.285     0.150
     8.026   201.785     0.150
     8.211   254.887     0.150
     8.211   240.484     0.150
     8.326   118.785     0.150
     0.311     6.344     0.150
     0.311    10.148     0.150
     0.311     6.445     0.150
     0.311    10.047     0.150
     1.257    23.445     0.150
     1.257    40.648     0.150
     1.257    43.648     0.150
     1.257    23.047     0.150
     1.257    39.945     0.150
     2.044    35.445     0.150
     2.044    35.945     0.150
     2.044    63.750     0.150
     2.452    41.047     0.150
     2.452    44.047     0.150
     2.452    71.750     0.150
     2.452    75.250     0.150
     2.452    40.250     0.150
     2.452    43.750     0.150
     2.452    74.945     0.150
     2.495    42.148     0.150
     2.495    45.547     0.150
     2.495    78.945     0.150
     2.495    45.844     0.150
     2.495    72.750     0.150
     2.495    78.844     0.150
     2.502    42.148     0.150
     2.502    46.250     0.150
     2.502    78.445     0.150
     2.502    46.148     0.150
     2.689    45.047     0.150
     2.689    49.945     0.150
     2.689    84.445     0.150
     2.689    49.250     0.150
     2.689    84.547     0.150
     3.503   109.047     0.150
     3.503    63.844     0.150
     3.503   110.547     0.150
     3.825    61.648     0.150
     3.825    69.148     0.150
     3.825   117.844     0.150
     3.825    61.047     0.150
     3.825    69.047     0.150
     3.825   117.945     0.150
     3.825    60.945     0.150
     3.825    68.945     0.150
     3.844    60.750     0.150
     3.844    69.547     0.150
     3.844   120.047     0.150
     3.844    70.250     0.150
     3.844   119.945     0.150
     4.005    62.344     0.150
     4.005    73.148     0.150
     4.005   122.750     0.150
     4.092    63.945     0.150
     4.092    74.047     0.150
     4.092   112.445     0.150
     4.092   126.250     0.150
     4.092    73.344     0.150
     4.092   125.750     0.150
     4.227    66.148     0.150
     4.227    77.547     0.150
     4.227   132.547     0.150
     4.227    66.047     0.150
     4.227    76.445     0.150
     4.227   113.648     0.150
     4.466    69.148     0.150
     4.466    81.148     0.150
     4.466   137.344     0.150
     4.779    87.250     0.150
     4.779   149.750     0.150
     4.779    74.844     0.150
     4.779    86.047     0.150
     5.298    96.648     0.150
     5.298   166.250     0.150
     5.298    80.844     0.150
     5.298    96.547     0.150
     5.455    82.844     0.150
     5.455    99.547     0.150
     5.455   170.547     0.150
     5.576    99.648     0.150
     5.576   170.148     0.150
     7.714   199.547     0.150
     7.714   239.844     0.150
     7.714   112.750     0.150
     7.714   199.445     0.150
     7.767   239.945     0.150
     7.920   115.148     0.150
     8.362   256.344     0.150
     0.330     6.711     0.150
     0.330    10.805     0.150
     1.246    23.008     0.150
     1.246    25.305     0.150
     1.246    40.211     0.150
     1.246    43.109     0.150
     2.053    37.305     0.150
     2.053    64.305     0.150
     2.454    44.109     0.150
     2.454    75.109     0.150
     2.491    45.711     0.150
     2.491    78.008     0.150
     2.484    42.109     0.150
     2.484    45.406     0.150
     2.484    79.211     0.150
     2.674    44.305     0.150
     2.674    49.008     0.150
     2.674    83.711     0.150
     3.493   109.609     0.150
     3.832    60.305     0.150
     3.832   120.609     0.150
     3.836    69.305     0.150
     3.836   118.109     0.150
     4.011    65.211     0.150
     4.011    72.805     0.150
     4.011   124.406     0.150
     4.095    75.211     0.150
     4.095   129.305     0.150
     4.213   131.711     0.150
     4.482   135.711     0.150
     5.579   173.008     0.150
     0.310     6.738     0.150
     0.310    11.037     0.150
     0.310    10.738     0.150
     1.253    23.037     0.150
     1.253    39.037     0.150
     1.253    23.238     0.150
     1.253    39.638     0.150
     2.048    35.938     0.150
     2.048    64.338     0.150
     2.447    39.738     0.150
     2.447    43.438     0.150
     2.447    74.438     0.150
     2.447    40.438     0.150
     2.447    44.338     0.150
     2.447    75.338     0.150
     2.499    41.638     0.150
     2.499    45.537     0.150
     2.499    77.838     0.150
     2.499    45.738     0.150
     2.500    42.138     0.150
     2.500    46.238     0.150
     2.500    78.838     0.150
     2.500    45.738     0.150
     2.500    72.537     0.150
     2.500    78.638     0.150
     2.687    48.838     0.150
     2.687    83.838     0.150
     2.687    44.537     0.150
     2.687    49.037     0.150
     2.687    84.037     0.150
     3.499    56.037     0.150
     3.499   110.638     0.150
     3.499    56.138     0.150
     3.499    64.138     0.150
     3.499   110.138     0.150
     3.840    60.838     0.150
     3.840    70.238     0.150
     3.840   119.638     0.150
     3.840    60.638     0.150
     3.829    60.537     0.150
     3.829    71.238     0.150
     3.829    70.138     0.150
     3.829   118.037     0.150
     3.829    58.838     0.150
     3.829    68.338     0.150
     3.829   118.738     0.150
     4.000    62.238     0.150
     4.225    65.638     0.150
     4.225    77.838     0.150
     4.225   131.938     0.150
     4.225    65.838     0.150
     4.225    77.238     0.150
     4.225   131.338     0.150
     4.097    63.838     0.150
     4.097    74.238     0.150
     4.097   111.838     0.150
     4.097   128.037     0.150
     4.097    74.438     0.150
     4.097   126.638     0.150
     4.468    68.037     0.150
     4.468    81.537     0.150
     4.468   138.537     0.150
     4.776    87.738     0.150
     4.776   147.938     0.150
     4.776    73.738     0.150
     4.776    86.738     0.150
     4.776   148.138     0.150
     5.299    79.338     0.150
     5.299    96.638     0.150
     5.299    96.537     0.150
     5.299   142.738     0.150
     5.299   164.738     0.150
     5.453    82.438     0.150
     5.453    99.338     0.150
     5.453    82.238     0.150
     5.453    99.037     0.150
     5.453   145.138     0.150
     5.453   168.938     0.150
     5.581    81.338     0.150
     6.070   108.037     0.150
     6.292   196.438     0.150
     6.654    99.037     0.150
     6.654   206.238     0.150
     7.466   109.738     0.150
     7.466   231.438     0.150
     7.490   110.238     0.150
     7.490   137.638     0.150
     7.490   236.037     0.150
     7.470   107.138     0.150
     7.764   114.438     0.150
     7.764   201.238     0.150
     7.764   241.238     0.150
     7.715   112.037     0.150
     7.715   111.838     0.150
     7.715   240.138     0.150
     7.992   117.838     0.150
     7.992   248.638     0.150
     7.921   113.238     0.150
     8.043   252.037     0.150
     8.062   114.738     0.150
     8.062   205.338     0.150
     8.062   115.108     0.150
     8.659   270.338     0.150
     9.042   131.438     0.150
     9.042   131.738     0.150
     9.042   280.238     0.150
     9.104   132.838     0.150
     9.104   284.838     0.150
     9.746   140.238     0.150
     9.746   139.677     0.150
     9.746   140.838     0.150
     9.746   302.338     0.150
    10.230   147.537     0.150
    10.230   149.338     0.150
    10.230   317.537     0.150
    10.741   155.537     0.150
    10.741   155.838     0.150
    11.027   157.738     0.150
    11.112   160.037     0.150
    11.289   162.037     0.150
    11.289   162.238     0.150
    11.289   350.838     0.150
    11.141   157.537     0.150
    14.100   200.438     0.150
    14.100   520.438     0.150
    14.100   733.338     0.150
    14.100   738.838     0.150
    14.100   953.237     0.150
    14.100   199.698     0.150
    14.642   207.338     0.150
    14.642   458.938     0.150
    14.604   206.438     0.150
    15.271   218.738     0.150
    15.749   385.938     0.150
    16.201   229.838     0.150
    16.351   230.838     0.150
    16.680   232.738     0.150
    17.482   244.338     0.150
    17.482   242.128     0.150
    18.053   254.838     0.150
    18.256   250.738     0.150
    18.256   449.537     0.150
    18.966   263.638     0.150
    19.504   267.138     0.150
    20.031   274.177     0.150
    20.328   274.968     0.150
    20.448   279.037     0.150
    22.663   303.537     0.150
    22.663   552.537     0.150
    22.663   586.938     0.150
    22.996   306.838     0.150
    22.996   552.438     0.150
    22.996   559.338     0.150
    23.440   310.438     0.150
    23.440   746.737     0.150
    23.469   312.138     0.150
    23.469   563.138     0.150
    24.283   315.938     0.150
    24.492   317.838     0.150
    24.492   319.578     0.150
    24.597   321.438     0.150
    24.597   581.838     0.150
    24.597   590.838     0.150
    25.643   330.537     0.150
    25.643   599.438     0.150
    25.643   605.237     0.150
    26.215   336.338     0.150
    27.027   342.988     0.150
    30.063   371.088     0.150
    30.433   374.508     0.150
    30.473   374.797     0.150
    30.594   376.128     0.150
    30.649   375.838     0.150
    30.649   675.838     0.150
    30.657   375.838     0.150
    30.821   379.018     0.150
    30.855   378.258     0.150
    30.855   374.537     0.150
    30.855   376.698     0.150
    31.121   380.868     0.150
    31.231   381.588     0.150
    31.436   380.938     0.150
    31.857   385.238     0.150
    31.857   450.438     0.150
    31.857   550.738     0.150
    31.857   698.237     0.150
    31.857  1015.338     0.150
    32.870   395.438     0.150
    36.640   428.438     0.150
    37.006   431.638     0.150
    37.106   432.838     0.150
    37.139   432.738     0.150
    37.239   433.738     0.150
    37.771   438.738     0.150
    37.824   436.338     0.150
    37.824   518.938     0.150
    38.261   443.338     0.150
    40.021   454.838     0.150
    40.427   457.978     0.150
    40.427     4.570     0.150
    41.368   463.898     0.150
    42.273   471.638     0.150
    42.273   851.638     0.150
    42.566   474.238     0.150
    42.566   477.238     0.150
    42.849   478.338     0.150
    43.129   480.638     0.150
    43.129     3.100     0.150
    43.129   865.138     0.150
    43.129   480.018     0.150
    43.262   479.838     0.150
    43.180   482.037     0.150
    43.331   483.848     0.150
    44.051   487.037     0.150
    44.228   490.037     0.150
    44.304   490.338     0.150
    44.827   490.088     0.150
    45.334   497.138     0.150
    45.997   504.688     0.150
    46.371   507.838     0.150
    46.371     4.000     0.150
    47.310   515.738     0.150
    47.755   518.638     0.150
    48.474   522.838     0.150
    48.474   949.838     0.150
    48.877   527.458     0.150
    49.040   528.338     0.150
    49.119   528.738     0.150
    49.119     2.800     0.150
    49.119   606.037     0.150
    49.119   639.237     0.150
    49.119  1116.638     0.150
    49.401   528.738     0.150
    49.654   530.738     0.150
    49.775   531.338     0.150
    50.035   534.297     0.150
    50.035     4.140     0.150
    50.761   543.037     0.150
    50.860   543.258     0.150
    51.021   542.838     0.150
    52.162   550.838     0.150
    52.162     4.000     0.150
    52.367   552.438     0.150
    52.472   556.838     0.150
    52.787   553.667     0.150
    53.097   558.238     0.150
    53.583   563.037     0.150
    53.794   564.047     0.150
    53.801   563.338     0.150
    53.805   563.338     0.150
    53.949   563.438     0.150
    54.187   565.638     0.150
    54.261   566.838     0.150
    54.321   567.738     0.150
    54.595   570.378     0.150
    54.751   571.767     0.150
    54.912   572.698     0.150
    54.947     3.600     0.150
    54.981   571.338     0.150
    54.981     3.300     0.150
    54.981   571.708     0.150
    55.124   573.678     0.150
    55.237   574.818     0.150
    55.252   572.638     0.150
    55.339   574.537     0.150
    55.351   574.237     0.150
    55.351     4.600     0.150
    55.560   576.057     0.150
    55.617   576.138     0.150
    55.617   576.938     0.150
    55.636   577.257     0.150
    55.654   576.938     0.150
    55.699   578.198     0.150
    55.931   578.237     0.150
    55.937   578.438     0.150
    55.937     3.800     0.150
    55.982   577.838     0.150
    55.982     4.400     0.150
    56.070   580.737     0.150
    56.254   581.638     0.150
    56.360   581.438     0.150
    56.360     4.400     0.150
    56.638   583.928     0.150
    56.637   584.737     0.150
    57.035   585.338     0.150
    57.041   587.158     0.150
    57.053   586.537     0.150
    57.135   587.888     0.150
    57.421   589.237     0.150
    57.421     3.100     0.150
    57.591   590.237     0.150
    57.702   591.338     0.150
    57.885   592.178     0.150
    57.890   592.139     0.150
    57.954   592.938     0.150
    57.954     3.900     0.150
    57.954   592.938     0.150
    57.954     3.900     0.150
    58.047   594.138     0.150
    58.065   593.838     0.150
    58.106   592.838     0.150
    58.086   593.037     0.150
    58.086   593.477     0.150
    58.124   594.037     0.150
    58.620   596.838     0.150
    58.699   598.217     0.150
    58.799   598.698     0.150
    58.818   599.838     0.150
    58.915   600.338     0.150
    58.994   601.138     0.150
    59.044   601.037     0.150
    59.116   601.438     0.150
    59.130   601.537     0.150
    59.178   600.934     0.150
    59.258   602.737     0.150
    59.304   601.287     0.150
    59.417   602.757     0.150
    59.424     4.500     0.150
    59.469   603.217     0.150
    59.469     4.060     0.150
    59.498   602.938     0.150
    59.521   603.098     0.150
    59.521     4.490     0.150
    59.572   604.938     0.150
    59.622   605.638     0.150
    59.660   604.938     0.150
    59.692   605.237     0.150
    59.699   604.568     0.150
    59.700   604.297     0.150
    59.715   605.737     0.150
    59.850   605.938     0.150
    59.904   606.438     0.150
    59.978   607.737     0.150
    60.132   606.037     0.150
    60.187   609.438     0.150
    60.197   608.037     0.150
    60.398   607.938     0.150
    60.402   610.138     0.150
    60.525   611.638     0.150
    60.550   609.438     0.150
    61.079   615.237     0.150
    61.090   615.237     0.150
    61.199   613.537     0.150
    61.207   613.338     0.150
    61.211   616.338     0.150
    61.245   613.838     0.150
    61.346   614.838     0.150
    61.358   617.037     0.150
    61.462   618.138     0.150
    61.806   620.237     0.150
    61.924   621.338     0.150
    62.023   621.938     0.150
    62.023   621.068     0.150
    62.483   621.438     0.150
    62.512   623.338     0.150
    62.565   624.318     0.150
    62.603   624.908     0.150
    62.669   625.568     0.150
    62.696   625.188     0.150
    62.706   624.828     0.150
    62.734   625.267     0.150
    62.737   625.568     0.150
    62.811   625.267     0.150
    62.829   626.138     0.150
    62.849   625.568     0.150
    63.000   627.138     0.150
    63.117   627.438     0.150
    63.125   627.638     0.150
    63.164   627.737     0.150
    63.195   626.237     0.150
    63.200   627.537     0.150
    63.207   626.138     0.150
    63.285   627.338     0.150
    63.339   627.638     0.150
    63.379   629.237     0.150
    63.408   628.037     0.150
    63.451   628.208     0.150
    63.518   629.838     0.150
    63.575   629.338     0.150
    63.580   630.638     0.150
    63.639   629.338     0.150
    63.645   629.237     0.150
    63.747   630.838     0.150
    63.785   630.138     0.150
    63.796   630.737     0.150
    63.824   631.818     0.150
    63.870   631.807     0.150
    63.889   631.037     0.150
    63.912   631.638     0.150
    63.950   632.247     0.150
    63.953   632.537     0.150
    64.080   632.537     0.150
    64.180   633.737     0.150
    64.265   633.938     0.150
    64.364   634.338     0.150
    64.490   635.938     0.150
    64.546   635.638     0.150
    64.594   636.638     0.150
    64.852   638.237     0.150
    64.866   637.737     0.150
    64.890   637.838     0.150
    65.354   641.037     0.150
    65.459   642.338     0.150
    65.463   641.737     0.150
    65.869   646.047     0.150
    65.869     4.350     0.150
    66.729   650.838     0.150
    67.211   658.448     0.150
    67.726   656.438     0.150
    68.186   659.438     0.150
    68.166   661.338     0.150
    68.273   664.608     0.150
    68.310   661.698     0.150
    68.310     4.800     0.150
    68.859   669.158     0.150
    68.779   664.918     0.150
    68.779     4.170     0.150
    68.938   665.578     0.150
    69.571   673.297     0.150
    69.538   668.578     0.150
    70.238   676.598     0.150
    70.144   673.338     0.150
    70.267   673.438     0.150
    70.427   675.388     0.150
    70.893   681.178     0.150
    71.428   680.737     0.150
    71.428     4.200     0.150
    71.493   684.517     0.150
    71.639   685.507     0.150
    71.841   685.638     0.150
    71.933   684.608     0.150
    72.039   684.918     0.150
    72.100   685.428     0.150
    72.100   685.737     0.150
    72.122   685.618     0.150
    72.241   685.138     0.150
    72.241     4.700     0.150
    72.262   684.938     0.150
    72.262     4.570     0.150
    72.187   686.378     0.150
    72.787   693.017     0.150
    73.038   690.838     0.150
    73.192   690.507     0.150
    73.192     4.710     0.150
    73.594   694.618     0.150
    73.594     4.520     0.150
    73.809   699.108     0.150
    74.085   697.638     0.150
    74.207   700.527     0.150
    74.535   700.007     0.150
    74.770   698.838     0.150
    74.757   701.438     0.150
    74.951   705.777     0.150
    74.907   702.178     0.150
    74.907     4.300     0.150
    75.164   703.237     0.150
    75.113   703.458     0.150
    75.435   707.578     0.150
    75.776   706.888     0.150
    76.164   709.578     0.150
    76.168   709.537     0.150
    76.379   709.938     0.150
    77.111   714.737     0.150
    77.111     4.500     0.150
    77.339   716.118     0.150
    77.511   715.318     0.150
    77.521   715.037     0.150
    77.521   715.418     0.150
    77.711   718.047     0.150
    77.784   718.868     0.150
    77.784     4.700     0.150
    77.833   718.737     0.150
    77.889   719.338     0.150
    78.195   720.708     0.150
    79.035   724.708     0.150
    79.035     4.570     0.150
    79.187   725.358     0.150
    80.065   730.537     0.150
    80.065   729.638     0.150
    80.236   730.368     0.150
    80.825   733.578     0.150
    81.308   737.138     0.150
    81.308   741.938     0.150
    81.834   740.958     0.150
    81.879   739.017     0.150
    81.879     3.760     0.150
    81.984   741.428     0.150
    82.166   740.307     0.150
    82.325   741.537     0.150
    82.473   741.938     0.150
    82.831   745.358     0.150
    83.282   747.138     0.150
    83.788   750.438     0.150
    83.894   750.348     0.150
    84.507   753.338     0.150
    84.644   754.267     0.150
    84.797   754.507     0.150
    85.005   755.727     0.150
    85.031   755.037     0.150
    85.153   755.918     0.150
    85.153     4.530     0.150
    85.216   756.138     0.150
    85.306   756.638     0.150
    86.275   761.638     0.150
    86.301   761.467     0.150
    87.500   768.638     0.150
    87.887   769.037     0.150
    88.193   770.818     0.150
    88.471   772.638     0.150
   145.636  1179.767     0.150
   151.668  1197.838     0.150
   151.668  1192.537     0.150
   153.163  1206.138     0.150
   153.163  1199.638     0.150
   153.468  1200.237     0.150
   153.874  1207.338     0.150
   153.874  1200.737     0.150
     0.332     6.918     0.150
     0.332    11.219     0.150
     1.238    38.816     0.150
     1.238    22.816     0.150
     1.238    39.520     0.150
     1.238    42.020     0.150
     2.062    35.719     0.150
     2.062    64.316     0.150
     2.444    43.418     0.150
     2.444    74.418     0.150
     2.444    40.316     0.150
     2.444    43.719     0.150
     2.444    75.020     0.150
     2.482    45.418     0.150
     2.482    77.316     0.150
     2.482    42.316     0.150
     2.482    45.117     0.150
     2.482    77.520     0.150
     2.491    41.816     0.150
     2.491    45.719     0.150
     2.491    79.316     0.150
     2.491    45.316     0.150
     2.667    48.816     0.150
     2.667    83.520     0.150
     2.667    44.020     0.150
     2.667    48.520     0.150
     2.667    83.219     0.150
     3.484    63.719     0.150
     3.484   109.020     0.150
     3.484    55.816     0.150
     3.484    63.617     0.150
     3.484   109.816     0.150
     3.824    60.316     0.150
     3.824    70.117     0.150
     3.824   120.219     0.150
     3.824    69.520     0.150
     3.824   119.316     0.150
     3.845    61.520     0.150
     3.845    69.219     0.150
     3.845    62.020     0.150
     3.845    68.918     0.150
     3.845   119.816     0.150
     3.845   117.617     0.150
     4.002    62.816     0.150
     4.002    72.617     0.150
     4.002   123.117     0.150
     4.205    65.520     0.150
     4.205    75.020     0.150
     4.205    65.418     0.150
     4.205    76.117     0.150
     4.205   131.117     0.150
     4.105    64.020     0.150
     4.105    73.617     0.150
     4.105   127.816     0.150
     4.105    63.617     0.150
     4.105    73.816     0.150
     4.105   125.918     0.150
     4.488    69.219     0.150
     4.488    80.918     0.150
     4.488   138.020     0.150
     4.760    74.219     0.150
     4.760    87.316     0.150
     4.760   150.316     0.150
     5.277    96.316     0.150
     5.277   138.719     0.150
     5.277   163.617     0.150
     5.277    80.316     0.150
     5.277    96.020     0.150
     5.277   165.219     0.150
     5.432    82.020     0.150
     5.432    99.219     0.150
     5.432   145.117     0.150
     5.432   170.219     0.150
     5.589    98.418     0.150
     5.589   172.617     0.150
     6.076   108.117     0.150
     6.634    98.816     0.150
     6.634   118.918     0.150
     6.634    98.918     0.150
     7.445   217.219     0.150
     7.445   232.020     0.150
     7.693   112.316     0.150
     7.693   141.117     0.150
     7.693   241.816     0.150
     7.744   114.219     0.150
     7.744   241.816     0.150
     7.943   113.520     0.150
     8.084   115.617     0.150
     8.084   207.117     0.150
     9.022   282.918     0.150
    10.211   319.617     0.150
    10.720   335.816     0.150
    11.277   162.699     0.150
    11.277   356.953     0.150
    24.581   323.020     0.150
    26.772   339.020     0.150
    40.684   462.520     0.150
    42.983   479.918     0.150
    43.753   484.543     0.150
    44.905   495.145     0.150
    49.371   528.867     0.150
    54.407   566.465     0.150
    55.044   570.770     0.150
     0.326     6.844     0.150
     0.326    10.945     0.150
     1.247    22.742     0.150
     1.247    39.242     0.150
     2.053    36.844     0.150
     2.053    64.141     0.150
     2.451    40.445     0.150
     2.451    44.039     0.150
     2.451    70.344     0.150
     2.451    75.344     0.150
     2.491    42.039     0.150
     2.491    45.641     0.150
     2.491    77.844     0.150
     2.488    41.641     0.150
     2.488    45.242     0.150
     2.488    78.445     0.150
     2.488    41.344     0.150
     2.488    45.445     0.150
     2.676    44.242     0.150
     2.676    48.344     0.150
     2.676    83.242     0.150
     3.493   109.844     0.150
     3.835    68.945     0.150
     3.835   119.141     0.150
     3.835    69.141     0.150
     3.835   118.242     0.150
     3.833    59.141     0.150
     3.833    70.141     0.150
     3.833   119.945     0.150
     4.008    61.945     0.150
     4.008    72.445     0.150
     4.008   124.141     0.150
     4.096    73.945     0.150
     4.096   128.242     0.150
     4.096    73.039     0.150
     4.096   126.539     0.150
     4.214    65.141     0.150
     4.214    76.242     0.150
     4.214   112.242     0.150
     4.214   131.742     0.150
     4.480   136.141     0.150
     4.769   150.445     0.150
     5.283   165.945     0.150
     5.441    98.242     0.150
     5.441   169.742     0.150
     5.581    84.945     0.150
     5.581   100.844     0.150
     5.581   171.242     0.150
     7.936   113.539     0.150
     0.602    11.664     0.150
     0.602    19.266     0.150
     1.339    24.766     0.150
     1.339    43.367     0.150
     2.000    36.664     0.150
     2.000    63.164     0.150
     2.167    38.062     0.150
     2.167    40.664     0.150
     2.167    64.562     0.150
     2.167    68.562     0.150
     2.167    40.562     0.150
     2.167    68.867     0.150
     2.643    44.867     0.150
     2.643    48.766     0.150
     2.643    83.664     0.150
     2.696    48.961     0.150
     2.696    76.961     0.150
     2.696    83.664     0.150
     3.802   119.664     0.150
     3.802    68.961     0.150
     3.802   119.266     0.150
     3.881    62.062     0.150
     3.881    71.164     0.150
     3.881   105.461     0.150
     3.881   121.562     0.150
     3.927   123.766     0.150
     3.927    62.961     0.150
     3.927    72.961     0.150
     3.927   125.062     0.150
     4.184    65.961     0.150
     4.184    76.664     0.150
     4.184   113.562     0.150
     4.184   131.367     0.150
     4.577   139.461     0.150
     4.823   152.062     0.150
     5.055   158.961     0.150
     0.332     6.792     0.150
     0.332    10.992     0.150
     0.332     6.893     0.150
     1.238    23.092     0.150
     1.238    39.292     0.150
     1.238    23.292     0.150
     1.238    39.992     0.150
     2.062    36.992     0.150
     2.062    64.492     0.150
     2.483    77.192     0.150
     2.483    41.292     0.150
     2.483    45.592     0.150
     2.483    77.393     0.150
     2.444    39.992     0.150
     2.444    43.792     0.150
     2.444    74.893     0.150
     2.444    40.492     0.150
     2.444    43.992     0.150
     2.444    75.092     0.150
     2.491    41.893     0.150
     2.491    45.992     0.150
     2.491    78.393     0.150
     2.668    44.492     0.150
     2.668    48.992     0.150
     2.668    83.592     0.150
     3.484    64.592     0.150
     3.484   109.992     0.150
     3.824    60.692     0.150
     3.824    68.492     0.150
     3.824    60.992     0.150
     3.824    69.592     0.150
     3.824   119.592     0.150
     3.844    61.692     0.150
     3.844    69.393     0.150
     3.844   118.592     0.150
     4.003    72.492     0.150
     4.003   123.092     0.150
     4.206    65.992     0.150
     4.206    76.592     0.150
     4.206   130.893     0.150
     4.104    64.192     0.150
     4.104    72.492     0.150
     4.104   125.992     0.150
     4.104    73.792     0.150
     4.104   126.292     0.150
     4.488    81.692     0.150
     4.488   138.992     0.150
     4.760    75.192     0.150
     4.760    87.192     0.150
     4.760   148.992     0.150
     5.278    78.893     0.150
     5.278    96.492     0.150
     5.278    79.393     0.150
     5.278    97.592     0.150
     5.278   166.893     0.150
     5.433    82.092     0.150
     5.433    83.092     0.150
     5.433    99.292     0.150
     5.433   141.792     0.150
     5.433   169.692     0.150
     5.588    82.992     0.150
     5.588   170.992     0.150
     6.635    99.192     0.150
     6.635   120.893     0.150
     6.635   205.893     0.150
     7.128   105.492     0.150
     7.128   219.492     0.150
     7.445   109.692     0.150
     7.445   232.192     0.150
     7.470   235.292     0.150
     7.455   107.893     0.150
     7.693   111.992     0.150
     7.693   240.192     0.150
     7.745   114.292     0.150
     7.745   116.292     0.150
     7.745   242.692     0.150
     7.972   248.992     0.150
     8.157   119.393     0.150
     8.157   208.092     0.150
     8.157   253.992     0.150
     9.022   131.692     0.150
     9.022   282.893     0.150
     9.727   141.692     0.150
    10.212   317.992     0.150
    11.006   159.292     0.150
    11.272   164.492     0.150
    11.272   350.992     0.150
    11.277   161.682     0.150
    11.277   352.912     0.150
    26.773   340.192     0.150
    27.183   346.379     0.150
    43.754   484.792     0.150
    49.194   527.662     0.150
    49.372   528.233     0.150
    49.406   528.136     0.150
    55.045   570.686     0.150
     0.314    10.941     0.150
     0.314     6.742     0.150
     1.245    22.840     0.150
     1.245    38.742     0.150
     1.245    22.941     0.150
     1.245    39.742     0.150
     2.057    36.043     0.150
     2.057    64.242     0.150
     2.439    42.941     0.150
     2.439    74.043     0.150
     2.439    40.141     0.150
     2.439    43.543     0.150
     2.439    74.441     0.150
     2.504    41.941     0.150
     2.504    45.941     0.150
     2.504    78.543     0.150
     2.504    41.441     0.150
     2.504    46.043     0.150
     2.491    41.242     0.150
     2.491    45.340     0.150
     2.491    77.742     0.150
     2.679    48.441     0.150
     2.679    83.840     0.150
     2.679    44.141     0.150
     2.679    83.141     0.150
     3.491    64.340     0.150
     3.491   110.641     0.150
     3.491    64.742     0.150
     3.491   110.242     0.150
     3.837    61.141     0.150
     3.837    70.840     0.150
     3.837   102.043     0.150
     3.837   115.242     0.150
     3.837    68.340     0.150
     3.837   117.840     0.150
     3.867    68.141     0.150
     3.867   118.941     0.150
     3.832    60.141     0.150
     3.832    69.141     0.150
     3.832   104.641     0.150
     3.832   118.840     0.150
     3.832    70.242     0.150
     3.832   103.242     0.150
     3.832   119.742     0.150
     3.993   122.941     0.150
     4.105    63.941     0.150
     4.105    74.242     0.150
     4.105   110.242     0.150
     4.105   125.641     0.150
     4.105    73.941     0.150
     4.105   125.840     0.150
     4.217    65.340     0.150
     4.217   110.043     0.150
     4.217    76.543     0.150
     4.217   130.441     0.150
     4.767    87.742     0.150
     4.767    86.641     0.150
     4.767   147.941     0.150
     5.296    97.941     0.150
     5.446    98.941     0.150
     5.446    81.840     0.150
     5.446    98.840     0.150
     5.446   142.543     0.150
     5.446   169.043     0.150
     5.590    99.941     0.150
     5.590   169.543     0.150
     6.078   108.543     0.150
     6.078   186.543     0.150
     6.646    99.340     0.150
     6.646   206.340     0.150
     7.117   218.543     0.150
     7.459   187.742     0.150
     7.711   111.941     0.150
     7.926   113.941     0.150
     9.035   282.742     0.150
     9.739   302.742     0.150
    10.223   319.742     0.150
    11.281   350.543     0.150
     0.333     6.855     0.150
     0.333    10.955     0.150
     1.234    23.055     0.150
     1.234    39.156     0.150
     2.066    37.055     0.150
     2.066    64.455     0.150
     2.440    41.455     0.150
     2.440    43.955     0.150
     2.440    74.955     0.150
     2.495    41.955     0.150
     2.495    46.355     0.150
     2.495    78.555     0.150
     2.495    42.756     0.150
     2.664    43.955     0.150
     2.664    48.555     0.150
     2.664    83.555     0.150
     3.820    59.756     0.150
     3.820   119.256     0.150
     3.848   118.256     0.150
     3.875    61.855     0.150
     3.875    70.756     0.150
     3.875   119.455     0.150
     3.999   124.055     0.150
     4.109   128.455     0.150
     4.202    65.555     0.150
     4.202    76.355     0.150
     4.202   112.756     0.150
     4.202   130.955     0.150
     4.491   136.055     0.150
     7.132   218.555     0.150
     0.767    14.773     0.150
     0.767    24.973     0.150
     0.767    24.672     0.150
     1.411    26.375     0.150
     1.411    27.672     0.150
     1.411    44.875     0.150
     1.411    48.273     0.150
     2.002    37.973     0.150
     2.637    48.773     0.150
     2.637    82.773     0.150
     2.829    51.375     0.150
     2.829    88.375     0.150
     3.747    68.672     0.150
     3.747   116.074     0.150
     3.801   117.273     0.150
     3.851   121.672     0.150
     3.851   121.875     0.150
     3.912    70.973     0.150
     3.912   122.172     0.150
     4.172    66.375     0.150
     4.172    77.172     0.150
     4.172   115.273     0.150
     4.172   131.273     0.150
     4.456   139.273     0.150
     4.643   143.875     0.150
     4.855   152.473     0.150
     5.321   165.473     0.150
     7.216   221.375     0.150
     8.366   256.273     0.150
     8.674   268.074     0.150
     0.765    14.818     0.150
     0.765    25.118     0.150
     1.286    23.719     0.150
     1.286    40.419     0.150
     1.286    25.719     0.150
     1.286    40.719     0.150
     1.286    44.118     0.150
     2.088    36.818     0.150
     2.088    39.019     0.150
     2.088    66.719     0.150
     2.088    37.019     0.150
     2.088    66.919     0.150
     2.449    41.919     0.150
     2.449    45.118     0.150
     2.449    76.818     0.150
     2.449    42.219     0.150
     2.449    77.818     0.150
     2.522    45.818     0.150
     2.522    80.519     0.150
     2.522    43.019     0.150
     2.522    46.118     0.150
     2.522    79.919     0.150
     2.719    48.919     0.150
     2.719    77.419     0.150
     2.719    83.919     0.150
     2.719    84.318     0.150
     3.789    60.019     0.150
     3.789    69.318     0.150
     3.789   118.719     0.150
     3.789    60.818     0.150
     3.789    68.019     0.150
     3.789   118.919     0.150
     3.977   124.618     0.150
     4.059    73.318     0.150
     4.059   126.919     0.150
     4.059    64.419     0.150
     4.059    73.919     0.150
     4.059   128.318     0.150
     4.732    86.618     0.150
     4.732   149.419     0.150
     4.883    86.519     0.150
     4.883   151.919     0.150
     4.883    88.219     0.150
     4.883   153.419     0.150
     5.219    80.219     0.150
     5.219    95.019     0.150
     5.219    94.719     0.150
     5.219   163.919     0.150
     6.474    97.219     0.150
     0.350     6.965     0.150
     0.350    11.863     0.150
     1.630    29.965     0.150
     1.630    52.066     0.150
     2.320    40.363     0.150
     2.320    42.566     0.150
     2.320    73.766     0.150
     2.320    39.766     0.150
     2.320    42.863     0.150
     2.320    68.266     0.150
     2.320    73.164     0.150
     2.794    50.164     0.150
     2.794    85.566     0.150
     2.869    89.664     0.150
     3.029    50.266     0.150
     3.029    54.766     0.150
     3.029    95.164     0.150
     3.454   107.266     0.150
     3.454    62.164     0.150
     3.454   106.566     0.150
     3.729   116.965     0.150
     3.729    67.766     0.150
     3.729   115.863     0.150
     4.155    74.164     0.150
     4.155   126.965     0.150
     4.213   131.164     0.150
     4.570    71.164     0.150
     4.570    84.066     0.150
     4.570   143.465     0.150
     5.215   163.465     0.150
     6.771   208.266     0.150
     7.681   235.363     0.150
     7.828   240.164     0.150
     0.359     7.207     0.150
     0.359    12.004     0.150
     1.633    30.004     0.150
     1.633    52.207     0.150
     1.633    29.707     0.150
     1.633    51.707     0.150
     2.311    40.105     0.150
     2.311    42.504     0.150
     2.311    72.707     0.150
     2.311    39.906     0.150
     2.311    42.707     0.150
     2.311    73.004     0.150
     2.311    68.707     0.150
     2.801    46.105     0.150
     2.801    50.305     0.150
     2.801    85.906     0.150
     2.801    45.906     0.150
     2.801    49.906     0.150
     2.872    52.305     0.150
     2.872    90.207     0.150
     3.030    49.707     0.150
     3.030    54.906     0.150
     3.030    94.707     0.150
     3.030    54.805     0.150
     3.451    55.105     0.150
     3.451    62.207     0.150
     3.451   107.004     0.150
     3.451    56.504     0.150
     3.451    63.004     0.150
     3.451   107.105     0.150
     3.451    56.105     0.150
     3.451   106.605     0.150
     3.723    58.906     0.150
     3.723   103.305     0.150
     3.723   116.707     0.150
     3.723    59.406     0.150
     3.723    67.406     0.150
     3.723   103.504     0.150
     3.723   114.906     0.150
     3.878   122.707     0.150
     3.878    71.605     0.150
     3.878   123.305     0.150
     4.156    65.406     0.150
     4.156   127.504     0.150
     4.215    66.305     0.150
     4.215    76.504     0.150
     4.215   131.707     0.150
     4.215    66.105     0.150
     4.215    76.906     0.150
     4.215   114.805     0.150
     4.215   130.906     0.150
     4.571    70.906     0.150
     4.571    82.707     0.150
     4.571   142.207     0.150
     4.571    71.406     0.150
     4.571    83.207     0.150
     4.571   141.906     0.150
     5.153    93.906     0.150
     5.153   161.004     0.150
     5.153    92.707     0.150
     5.153   135.105     0.150
     5.209    92.105     0.150
     5.209   159.906     0.150
     5.477   173.207     0.150
     5.477    99.707     0.150
     5.772    87.707     0.150
     5.772   105.105     0.150
     5.772   181.605     0.150
     6.770   101.707     0.150
     6.770   208.207     0.150
     6.997   105.105     0.150
     6.997   220.406     0.150
     6.997   104.305     0.150
     7.684   235.605     0.150
     7.831   113.305     0.150
     7.831   138.805     0.150
     7.872   116.004     0.150
     7.872   245.305     0.150
     7.872   115.504     0.150
     8.099   253.707     0.150
     9.372   294.105     0.150
    10.577   331.004     0.150
    11.655   363.406     0.150
    24.167   316.406     0.150
    24.304   320.781     0.150
    31.230   381.004     0.150
    42.748   477.605     0.150
     0.556    10.289     0.150
     0.556    17.391     0.150
     0.556    10.586     0.150
     0.556    17.789     0.150
     1.283    41.492     0.150
     1.283    44.391     0.150
     1.613    31.086     0.150
     1.708    31.992     0.150
     1.708    54.688     0.150
     2.166    67.289     0.150
     2.640    48.586     0.150
     2.640    83.789     0.150
     2.640    48.891     0.150
     2.640    83.289     0.150
     2.631    44.992     0.150
     2.631    48.188     0.150
     2.631    83.391     0.150
     2.951    53.492     0.150
     2.951    83.391     0.150
     2.951    91.586     0.150
     2.951    49.391     0.150
     2.951    92.789     0.150
     3.249    53.688     0.150
     3.249    60.289     0.150
     3.249    90.086     0.150
     3.249   102.492     0.150
     3.894   122.289     0.150
     4.460    70.492     0.150
     4.460   139.586     0.150
     4.442    81.492     0.150
     4.442   139.586     0.150
     4.793   150.992     0.150
     5.675   177.086     0.150
     6.252   112.492     0.150
     6.252   162.289     0.150
     6.778   212.086     0.150
     6.876   101.992     0.150
     6.876   177.586     0.150
     6.876   215.891     0.150
     9.256   288.688     0.150
     0.342     6.797     0.150
     0.342    11.695     0.150
     0.342    11.594     0.150
     1.621    29.695     0.150
     1.621    50.695     0.150
     1.621    29.492     0.150
     2.326    40.797     0.150
     2.326    42.297     0.150
     2.326    72.594     0.150
     2.784    50.297     0.150
     2.784    85.992     0.150
     2.784    45.594     0.150
     2.784    49.492     0.150
     2.784    83.797     0.150
     3.021    49.695     0.150
     3.021    54.695     0.150
     3.021    85.492     0.150
     3.021    94.492     0.150
     3.021    54.492     0.150
     3.021    93.594     0.150
     3.463    56.195     0.150
     3.463    62.992     0.150
     3.463    95.391     0.150
     3.463   107.297     0.150
     3.463    62.094     0.150
     3.739    59.195     0.150
     3.739    67.695     0.150
     3.739   103.195     0.150
     3.739   116.992     0.150
     3.866    69.492     0.150
     3.866   118.891     0.150
     3.866    72.891     0.150
     3.866   122.891     0.150
     4.204    66.297     0.150
     4.204    75.695     0.150
     4.204   113.094     0.150
     4.204   130.594     0.150
     4.204    75.297     0.150
     4.204   132.391     0.150
     4.562    70.992     0.150
     4.562    82.695     0.150
     4.562   143.297     0.150
     4.562    71.094     0.150
     4.562    82.195     0.150
     4.562   142.992     0.150
     5.141    78.797     0.150
     5.141    93.195     0.150
     5.141   160.195     0.150
     5.141    79.695     0.150
     5.141    93.297     0.150
     5.141   135.391     0.150
     5.225    77.492     0.150
     5.225    93.297     0.150
     5.225   137.094     0.150
     5.478   100.094     0.150
     5.478   171.594     0.150
     5.766    87.094     0.150
     5.766   103.891     0.150
     5.766   154.695     0.150
     5.766   180.891     0.150
     6.989   104.195     0.150
     6.989   179.594     0.150
     6.989   217.094     0.150
     6.989   104.594     0.150
     7.874   115.797     0.150
     7.874   246.797     0.150
     7.874   145.391     0.150
     8.091   250.695     0.150
     0.714    13.902     0.150
     0.714    22.902     0.150
     0.714    23.301     0.150
     2.185    38.301     0.150
     2.185    40.102     0.150
     2.185    68.199     0.150
     2.185    38.000     0.150
     2.185    40.000     0.150
     2.859    51.602     0.150
     2.859    88.500     0.150
     2.590    43.500     0.150
     2.590    48.102     0.150
     2.590    81.402     0.150
     2.590    47.902     0.150
     2.590    75.000     0.150
     2.590    81.199     0.150
     2.929    49.500     0.150
     2.929    53.699     0.150
     2.929    88.000     0.150
     2.929    91.699     0.150
     3.116    51.199     0.150
     3.116    55.301     0.150
     3.116    59.102     0.150
     3.437    63.301     0.150
     3.640   113.801     0.150
     4.771    72.902     0.150
     4.771    72.801     0.150
     4.771    86.102     0.150
     4.771   127.602     0.150
     4.771   148.199     0.150
     5.178    93.000     0.150
     5.178   139.801     0.150
     5.178   162.602     0.150
     5.178    80.402     0.150
     5.178    93.301     0.150
     5.700   177.000     0.150
     6.091   113.500     0.150
     6.091   191.102     0.150
     6.400    95.699     0.150
     6.400   114.602     0.150
     6.400   201.402     0.150
     8.472   125.602     0.150
     8.472   265.000     0.150
    11.184   345.301     0.150
     0.821    15.867     0.150
     0.821    26.664     0.150
     1.331    24.969     0.150
     1.331    42.367     0.150
     1.331    45.469     0.150
     1.331    24.766     0.150
     1.331    42.266     0.150
     2.019    37.562     0.150
     2.019    64.562     0.150
     2.019    37.867     0.150
     2.019    64.766     0.150
     2.478    41.562     0.150
     2.478    45.664     0.150
     2.478    78.164     0.150
     2.478    72.062     0.150
     2.534    46.469     0.150
     2.534    79.367     0.150
     2.534    45.766     0.150
     2.534    78.969     0.150
     2.781    45.469     0.150
     2.781    50.266     0.150
     2.781    86.766     0.150
     2.781    44.766     0.150
     2.781    49.766     0.150
     2.781    85.664     0.150
     3.505    57.367     0.150
     3.505    63.562     0.150
     3.505   110.766     0.150
     3.790    60.469     0.150
     3.790   117.062     0.150
     3.904    61.766     0.150
     3.904   115.766     0.150
     3.816    60.867     0.150
     3.816    68.664     0.150
     3.816   103.164     0.150
     3.816   118.469     0.150
     3.816    60.766     0.150
     3.816    69.766     0.150
     3.816   104.766     0.150
     3.816   118.164     0.150
     4.069    64.367     0.150
     4.069    73.969     0.150
     4.069   127.164     0.150
     4.069    73.867     0.150
     4.759    73.867     0.150
     4.759    85.562     0.150
     4.759   148.969     0.150
     4.759    87.664     0.150
     4.759   127.164     0.150
     4.845    74.766     0.150
     4.845    87.766     0.150
     4.845   151.766     0.150
     5.403    79.766     0.150
     5.403    96.469     0.150
     5.403   137.164     0.150
     5.403   165.367     0.150
     6.480    97.664     0.150
     6.480   116.969     0.150
     6.480   201.664     0.150
     7.243   106.664     0.150
     7.243   225.766     0.150
     7.563   111.766     0.150
     7.563   236.164     0.150
     7.563   111.664     0.150
     7.798   244.766     0.150
     8.460   123.664     0.150
     8.828   275.062     0.150
     9.547   138.266     0.150
     9.547   295.766     0.150
     9.547   138.469     0.150
    10.064   146.062     0.150
    10.064   311.664     0.150
    10.497   324.766     0.150
    10.497   150.867     0.150
    10.636   152.766     0.150
    10.811   153.969     0.150
    10.920   157.688     0.150
    10.920   339.344     0.150
    10.958   339.469     0.150
    23.829   315.055     0.150
    23.868   316.164     0.150
    24.047   319.367     0.150
    25.094   328.469     0.150
    43.379   485.266     0.150
    76.994   713.922     0.150
     0.818    15.781     0.150
     0.818    26.781     0.150
     0.818    26.578     0.150
     1.334    24.781     0.150
     1.334    42.484     0.150
     1.334    24.578     0.150
     1.334    42.281     0.150
     2.019    37.680     0.150
     2.019    64.883     0.150
     2.019    36.078     0.150
     2.019    37.781     0.150
     2.019    64.984     0.150
     2.482    45.680     0.150
     2.482    78.883     0.150
     2.482    78.578     0.150
     2.538    46.383     0.150
     2.538    79.883     0.150
     2.538    46.180     0.150
     2.538    79.484     0.150
     2.782    45.781     0.150
     2.782    50.383     0.150
     2.782    86.781     0.150
     2.782    49.484     0.150
     2.782    85.578     0.150
     3.509    64.078     0.150
     3.509   110.984     0.150
     3.509    63.281     0.150
     3.509   110.578     0.150
     3.786    60.281     0.150
     3.819    60.984     0.150
     3.819    68.578     0.150
     3.819   118.383     0.150
     3.819    59.680     0.150
     3.819    69.078     0.150
     3.819   104.680     0.150
     3.819   118.781     0.150
     3.900    61.680     0.150
     3.900   109.883     0.150
     4.073    64.281     0.150
     4.073    73.883     0.150
     4.073   127.680     0.150
     4.073    64.383     0.150
     4.073    74.383     0.150
     4.073   126.078     0.150
     4.762    73.984     0.150
     4.762    85.484     0.150
     4.762   148.383     0.150
     4.762    87.781     0.150
     4.762   148.984     0.150
     4.850    87.180     0.150
     4.850   150.578     0.150
     4.850    89.180     0.150
     4.850   149.883     0.150
     5.221    79.984     0.150
     5.221    94.578     0.150
     5.221   163.180     0.150
     5.400    80.281     0.150
     5.400    96.383     0.150
     5.400   140.781     0.150
     5.400   164.883     0.150
     7.247   106.484     0.150
     7.247   225.484     0.150
     7.568   112.078     0.150
     7.568   235.883     0.150
    10.501   266.578     0.150
     0.685    13.316     0.150
     0.685    22.316     0.150
     0.685    13.418     0.150
     1.009    18.918     0.150
     1.009    32.617     0.150
     1.009    32.516     0.150
     2.216    40.816     0.150
     2.216    70.418     0.150
     2.216    41.016     0.150
     2.216    70.117     0.150
     2.351    43.117     0.150
     2.351    74.316     0.150
     2.404    43.516     0.150
     2.404    74.516     0.150
     2.404    73.918     0.150
     2.392    40.918     0.150
     2.392    43.816     0.150
     2.392    76.219     0.150
     2.392    44.016     0.150
     2.392    75.516     0.150
     3.560    56.617     0.150
     3.560    64.219     0.150
     3.560   111.117     0.150
     3.560    64.117     0.150
     3.560    98.418     0.150
     3.560   111.219     0.150
     3.892    61.418     0.150
     3.892    70.816     0.150
     3.892   107.418     0.150
     3.892   123.316     0.150
     3.892    61.617     0.150
     3.892   120.617     0.150
     4.113    74.418     0.150
     4.113   126.418     0.150
     4.501    82.617     0.150
     4.501   141.316     0.150
     4.929   131.418     0.150
     4.929   154.316     0.150
     5.098    77.918     0.150
     5.098    93.418     0.150
     5.098   159.719     0.150
     5.731   101.316     0.150
     5.731   177.117     0.150
     6.188   110.918     0.150
     6.188   192.117     0.150
     6.318   196.617     0.150
     7.349   107.617     0.150
     7.349   187.418     0.150
     7.349   229.719     0.150
     7.420   233.418     0.150
     0.679    13.290     0.150
     0.679    22.190     0.150
     1.010    18.990     0.150
     1.010    20.590     0.150
     1.010    32.590     0.150
     1.010    18.690     0.150
     1.010    32.090     0.150
     2.219    37.790     0.150
     2.219    40.690     0.150
     2.219    70.290     0.150
     2.219    41.090     0.150
     2.355    39.790     0.150
     2.355    42.990     0.150
     2.355    74.090     0.150
     2.355    74.190     0.150
     2.402    39.890     0.150
     2.402    43.290     0.150
     2.402    74.390     0.150
     2.402    40.290     0.150
     2.402    73.790     0.150
     2.396    39.690     0.150
     2.396    43.890     0.150
     2.396    75.890     0.150
     2.396    40.990     0.150
     3.236    60.790     0.150
     3.236   102.590     0.150
     3.236    59.090     0.150
     3.236   101.390     0.150
     3.563    56.990     0.150
     3.563    64.190     0.150
     3.563   111.490     0.150
     3.563    55.790     0.150
     3.563    63.790     0.150
     3.563    97.990     0.150
     3.563   110.490     0.150
     3.897    61.390     0.150
     3.897    70.890     0.150
     3.897   123.190     0.150
     3.897    70.190     0.150
     3.897   104.990     0.150
     4.109    65.690     0.150
     4.109    73.890     0.150
     4.109   127.590     0.150
     6.188   112.290     0.150
     7.356   107.290     0.150
     7.356   189.390     0.150
     0.695    13.375     0.150
     0.695    22.180     0.150
     0.695    13.680     0.150
     0.695    22.375     0.150
     1.004    18.977     0.150
     1.004    21.281     0.150
     1.004    32.680     0.150
     1.004    18.875     0.150
     1.004    32.578     0.150
     2.209    38.781     0.150
     2.209    41.078     0.150
     2.209    70.375     0.150
     2.209    41.180     0.150
     2.209    64.180     0.150
     2.209    69.680     0.150
     2.342    40.781     0.150
     2.342    43.180     0.150
     2.342    74.477     0.150
     2.404    41.375     0.150
     2.404    43.477     0.150
     2.404    74.680     0.150
     2.404    40.078     0.150
     2.404    74.180     0.150
     2.390    41.281     0.150
     2.390    44.078     0.150
     2.390    76.180     0.150
     2.390    40.977     0.150
     2.390    70.477     0.150
     2.390    75.781     0.150
     3.227   100.875     0.150
     3.554    57.078     0.150
     3.554    64.281     0.150
     3.554   111.578     0.150
     3.884    61.477     0.150
     3.884    71.078     0.150
     3.884   122.680     0.150
     4.495   141.078     0.150
     5.089   160.375     0.150
     5.735   176.875     0.150
     7.340   229.375     0.150
     0.691    13.457     0.150
     0.691    22.254     0.150
     0.691    22.457     0.150
     1.007    19.156     0.150
     1.007    32.457     0.150
     1.007    19.055     0.150
     1.007    32.656     0.150
     2.213    41.254     0.150
     2.213    70.055     0.150
     2.213    70.457     0.150
     2.347    40.355     0.150
     2.347    43.055     0.150
     2.347    74.156     0.150
     2.407    43.656     0.150
     2.407    74.656     0.150
     2.407    74.055     0.150
     2.389    41.254     0.150
     2.389    44.055     0.150
     2.389    71.055     0.150
     2.389    75.855     0.150
     2.389    44.254     0.150
     3.231   101.555     0.150
     3.231    60.156     0.150
     3.231   102.254     0.150
     3.558    56.754     0.150
     3.558    64.457     0.150
     3.558   111.656     0.150
     3.558   111.055     0.150
     3.888    61.754     0.150
     3.888    71.855     0.150
     3.888   122.855     0.150
     3.888    70.656     0.150
     3.888   121.457     0.150
     4.014   121.957     0.150
     4.115    73.457     0.150
     4.499    82.156     0.150
     4.499   140.555     0.150
     4.499    83.457     0.150
     4.923    89.254     0.150
     4.923   132.656     0.150
     4.923   153.355     0.150
     5.094    77.957     0.150
     5.094    92.855     0.150
     5.094   160.254     0.150
     5.094    93.457     0.150
     5.935    89.254     0.150
     5.935   108.555     0.150
     5.935   186.855     0.150
     6.314    94.754     0.150
     6.314   115.055     0.150
     6.314   198.355     0.150
     6.314   114.855     0.150
     6.556   204.855     0.150
     7.343   107.457     0.150
     7.343   230.156     0.150
     7.416   231.656     0.150
     7.810   142.957     0.150
     7.810   244.855     0.150
     8.690   268.656     0.150
     9.895   306.754     0.150
    10.980   340.055     0.150
     0.429     8.422     0.150
     0.429    14.223     0.150
     1.048    19.523     0.150
     1.048    22.125     0.150
     1.048    23.324     0.150
     1.048    33.824     0.150
     2.204    38.422     0.150
     2.204    40.125     0.150
     2.204    65.922     0.150
     2.204    69.023     0.150
     2.204    37.723     0.150
     2.204    65.324     0.150
     2.300    42.324     0.150
     2.300    72.324     0.150
     2.300    71.922     0.150
     2.527    43.324     0.150
     2.527    46.523     0.150
     2.527    80.023     0.150
     2.527    46.324     0.150
     2.696    45.223     0.150
     2.696    49.324     0.150
     2.696    85.223     0.150
     3.288   103.324     0.150
     3.288    61.723     0.150
     3.288   105.723     0.150
     3.635    59.223     0.150
     3.635    65.922     0.150
     3.635   113.922     0.150
     3.635    65.324     0.150
     3.635   100.125     0.150
     3.635   113.324     0.150
     4.057    64.023     0.150
     4.057    73.922     0.150
     4.057   111.223     0.150
     4.057   127.223     0.150
     4.566    72.125     0.150
     4.566    83.422     0.150
     4.566   142.723     0.150
     4.566    70.922     0.150
     4.566    83.523     0.150
     4.566   124.125     0.150
     4.566   143.523     0.150
     5.274    96.523     0.150
     5.274   165.625     0.150
     5.312    81.922     0.150
     5.312    97.023     0.150
     5.312   167.125     0.150
     6.486   203.125     0.150
     7.605   238.125     0.150
     7.700   112.723     0.150
     7.700   241.523     0.150
     0.680    13.320     0.150
     0.680    21.922     0.150
     0.680    22.117     0.150
     2.217    38.117     0.150
     2.217    40.922     0.150
     2.217    69.617     0.150
     2.217    69.922     0.150
     2.354    40.117     0.150
     2.354    43.016     0.150
     2.354    73.719     0.150
     2.354    74.117     0.150
     2.402    43.516     0.150
     2.402    74.117     0.150
     2.396    40.922     0.150
     2.396    43.820     0.150
     2.396    75.617     0.150
     2.396    43.922     0.150
     3.235    59.422     0.150
     3.235   101.719     0.150
     3.235    58.922     0.150
     3.235   102.219     0.150
     3.562    56.820     0.150
     3.562    64.422     0.150
     3.562   110.922     0.150
     3.562    64.117     0.150
     3.562    98.016     0.150
     3.562   110.719     0.150
     3.895    61.320     0.150
     3.895    71.320     0.150
     3.895   122.617     0.150
     3.895    61.516     0.150
     3.895    70.219     0.150
     3.895   120.117     0.150
     4.009    67.719     0.150
     4.110    73.922     0.150
     4.110   127.016     0.150
     4.503    70.320     0.150
     4.503    82.922     0.150
     4.503   141.617     0.150
     4.503    70.016     0.150
     4.503    81.016     0.150
     4.503   121.719     0.150
     4.503   140.617     0.150
     4.935    75.719     0.150
     4.935    89.719     0.150
     4.935   132.516     0.150
     4.935   153.117     0.150
     4.935    89.617     0.150
     5.102    77.922     0.150
     5.102    93.320     0.150
     5.102   160.320     0.150
     5.102    93.016     0.150
     5.731    86.719     0.150
     5.731   177.219     0.150
     6.321    94.516     0.150
     6.321   115.117     0.150
     6.321   196.922     0.150
     6.321    94.617     0.150
     7.354   107.219     0.150
     7.354   191.016     0.150
     7.354   229.320     0.150
     7.354   107.320     0.150
     7.424   109.320     0.150
     7.424   232.820     0.150
     9.407   294.820     0.150
     9.902   309.922     0.150
    10.787   275.617     0.150
    10.787   335.617     0.150
    10.985   157.820     0.150
    10.985   342.820     0.150
     0.365     7.211     0.150
     0.365    12.211     0.150
     0.365    12.109     0.150
     1.648    30.211     0.150
     1.648    53.312     0.150
     1.648    30.008     0.150
     1.648    52.914     0.150
     1.650    30.109     0.150
     1.650    52.109     0.150
     2.309    39.711     0.150
     2.309    42.312     0.150
     2.309    72.312     0.150
     2.309    72.414     0.150
     2.813    46.109     0.150
     2.813    50.414     0.150
     2.813    53.711     0.150
     2.813    86.312     0.150
     2.813    45.812     0.150
     2.813    50.609     0.150
     2.813    85.914     0.150
     2.887    47.609     0.150
     2.887    52.609     0.150
     2.887    90.008     0.150
     2.887    52.312     0.150
     3.045    49.812     0.150
     3.045    54.914     0.150
     3.045    85.508     0.150
     3.045    95.508     0.150
     3.045    55.109     0.150
     3.045    95.312     0.150
     3.343    54.312     0.150
     3.436    54.609     0.150
     3.436    57.312     0.150
     3.436    98.812     0.150
     3.436   106.312     0.150
     3.436    56.812     0.150
     3.436    63.508     0.150
     3.436    98.211     0.150
     3.436   104.508     0.150
     3.710    58.914     0.150
     3.710    66.914     0.150
     3.710   101.914     0.150
     3.710   115.812     0.150
     3.893    62.109     0.150
     3.893    71.312     0.150
     3.893   122.414     0.150
     3.893    71.812     0.150
     4.141    64.609     0.150
     4.141    74.312     0.150
     4.141   112.414     0.150
     4.141   129.109     0.150
     4.231    66.211     0.150
     4.231    76.211     0.150
     4.231   132.812     0.150
     4.231    77.109     0.150
     4.231   115.008     0.150
     4.231   131.609     0.150
     4.586    71.414     0.150
     4.586    83.508     0.150
     4.586   144.211     0.150
     4.586    83.312     0.150
     4.586   142.312     0.150
     5.168    79.812     0.150
     5.168    93.812     0.150
     5.168   162.312     0.150
     5.168    79.414     0.150
     5.168   160.008     0.150
     5.488   100.711     0.150
     5.488   172.414     0.150
     5.787    87.711     0.150
     5.787   104.812     0.150
     5.787   181.312     0.150
     5.787    87.812     0.150
     5.787   105.312     0.150
     6.630    99.414     0.150
     6.630   208.211     0.150
     6.755   101.008     0.150
     6.755   175.508     0.150
     6.755   207.312     0.150
     7.012   104.414     0.150
     7.386   107.914     0.150
     7.790   115.109     0.150
     7.790   242.711     0.150
     7.827   244.414     0.150
     7.882   115.211     0.150
     7.882   247.211     0.150
     7.819   115.008     0.150
     7.819   197.914     0.150
     8.114   118.711     0.150
     8.497   124.914     0.150
     8.497   266.008     0.150
    10.097   315.711     0.150
    10.097   148.008     0.150
    10.802   155.008     0.150
    11.273   162.711     0.150
    11.478   357.508     0.150
    11.478   165.812     0.150
    11.554   166.250     0.150
    11.554   363.914     0.150
    11.670   168.312     0.150
    11.670   362.609     0.150
    24.319   320.086     0.150
    24.319   320.812     0.150
    42.737   479.211     0.150
    44.052   489.562     0.150
     0.062     4.328     0.150
     0.062     2.727     0.150
     0.909    17.125     0.150
     0.909    28.922     0.150
     1.517    28.328     0.150
     1.517    48.523     0.150
     1.517    28.125     0.150
     1.517    48.422     0.150
     2.494    41.828     0.150
     2.494    44.523     0.150
     2.494    71.328     0.150
     2.494    76.523     0.150
     2.494    75.828     0.150
     2.698    45.023     0.150
     2.698    48.625     0.150
     2.698    76.422     0.150
     2.698    83.625     0.150
     2.698    44.828     0.150
     2.698    49.328     0.150
     2.698    77.328     0.150
     2.698    83.727     0.150
     2.769    45.922     0.150
     2.769    51.125     0.150
     2.769    78.922     0.150
     2.769    86.828     0.150
     2.769    51.023     0.150
     2.769    79.727     0.150
     3.005    49.328     0.150
     3.005    55.328     0.150
     3.005    85.727     0.150
     3.005    94.328     0.150
     3.005    55.023     0.150
     3.005    93.922     0.150
     3.606    58.328     0.150
     3.606    66.625     0.150
     3.606    99.023     0.150
     3.606   110.727     0.150
     3.745    59.922     0.150
     3.745    68.227     0.150
     3.745   102.828     0.150
     3.745   116.727     0.150
     3.745    68.422     0.150
     3.745   117.523     0.150
     4.141    65.023     0.150
     4.141    75.625     0.150
     4.141   110.828     0.150
     4.141   128.227     0.150
     4.098    64.422     0.150
     4.098   127.227     0.150
     4.098    73.125     0.150
     4.098   109.625     0.150
     4.535    70.523     0.150
     4.535    83.523     0.150
     4.535   122.828     0.150
     4.535   141.727     0.150
     4.535    83.328     0.150
     4.535   141.523     0.150
     5.024    77.523     0.150
     5.024    92.227     0.150
     5.024   156.922     0.150
     5.024    78.328     0.150
     5.024    92.727     0.150
     5.670    87.227     0.150
     5.670   103.328     0.150
     5.670   177.727     0.150
     5.787    87.125     0.150
     5.787   153.422     0.150
     5.787   180.328     0.150
     5.787    87.023     0.150
     6.622    98.922     0.150
     6.622   207.227     0.150
     6.964   217.523     0.150
     7.696   110.523     0.150
     7.696   193.422     0.150
     7.696   194.898     0.150
     7.749   200.625     0.150
     7.749   242.328     0.150
     7.749   112.625     0.150
     7.805   241.922     0.150
     8.085   117.625     0.150
     8.085   252.422     0.150
     8.327   261.523     0.150
     8.377   260.828     0.150
     8.520   124.422     0.150
     8.520   248.523     0.150
     8.520   266.625     0.150
     9.365   292.023     0.150
     9.416   291.922     0.150
    10.063   148.125     0.150
    10.063   255.422     0.150
    10.534   327.328     0.150
    11.073   346.422     0.150
    11.073   161.922     0.150
    11.073   282.328     0.150
    11.165   160.125     0.150
    11.395   164.227     0.150
    11.410   353.828     0.150
    11.410   164.328     0.150
    11.665   168.586     0.150
    11.665   364.422     0.150
    21.335   289.828     0.150
    23.975   314.625     0.150
    24.126   315.523     0.150
    24.182   317.648     0.150
    27.325   345.836     0.150
    27.366   345.023     0.150
    28.100   351.164     0.150
    31.103   380.023     0.150
    33.232   398.023     0.150
    35.245   413.797     0.150
    35.245   413.797     0.150
    40.812   460.727     0.150
    43.177   479.328     0.150
    43.670   483.750     0.150
    43.670   484.828     0.150
    44.512   494.203     0.150
    47.408   515.328     0.150
    49.282   530.211     0.150
    49.376   528.875     0.150
    57.544   590.562     0.150
    72.821   689.422     0.150
    73.223   692.945     0.150
    73.675   695.672     0.150
    92.874   793.148     0.150
     0.075     2.750     0.150
     0.075     4.450     0.150
     0.908    16.950     0.150
     1.522    28.351     0.150
     1.522    29.450     0.150
     1.522    48.450     0.150
     1.522    50.750     0.150
     2.490    44.650     0.150
     2.490    70.351     0.150
     2.490    76.450     0.150
     2.711    45.150     0.150
     2.711    49.351     0.150
     2.711    77.650     0.150
     2.711    84.250     0.150
     2.711    44.950     0.150
     2.711    49.250     0.150
     2.711    76.851     0.150
     2.773    86.150     0.150
     3.013    49.650     0.150
     3.013    55.450     0.150
     3.013    94.051     0.150
     3.013    55.950     0.150
     3.013    93.950     0.150
     3.605   111.551     0.150
     3.605    66.851     0.150
     3.605   100.650     0.150
     3.748   116.450     0.150
     3.748    68.150     0.150
     3.748   117.551     0.150
     4.024   124.150     0.150
     4.101    64.650     0.150
     4.101   127.450     0.150
     4.101    74.950     0.150
     4.101   111.950     0.150
     4.101   127.551     0.150
     4.542    70.450     0.150
     4.542    82.250     0.150
     4.542   141.551     0.150
     5.027    91.851     0.150
     5.027   156.650     0.150
     5.027    92.150     0.150
     5.683   177.851     0.150
     5.796    87.150     0.150
     5.796   180.650     0.150
     6.799   209.150     0.150
     6.971   217.150     0.150
     0.679    13.239     0.150
     0.679    21.939     0.150
     0.679    13.340     0.150
     0.679    22.340     0.150
     1.004    19.040     0.150
     1.004    32.239     0.150
     1.004    36.439     0.150
     1.004    18.840     0.150
     1.004    32.340     0.150
     1.477    27.239     0.150
     2.214    40.840     0.150
     2.214    69.840     0.150
     2.351    40.040     0.150
     2.351    43.040     0.150
     2.351    73.439     0.150
     2.351    73.939     0.150
     2.395    43.439     0.150
     2.395    74.340     0.150
     2.395    74.040     0.150
     2.403    41.040     0.150
     2.403    43.840     0.150
     2.403    75.739     0.150
     2.403    40.739     0.150
     2.403    44.239     0.150
     2.403    75.540     0.150
     3.231    58.739     0.150
     3.231   100.840     0.150
     3.231    60.040     0.150
     3.231   102.739     0.150
     3.558    56.640     0.150
     3.558    64.140     0.150
     3.558   111.140     0.150
     3.558    55.640     0.150
     3.558    63.840     0.150
     3.558    97.840     0.150
     3.558   110.239     0.150
     4.261   133.939     0.150
     4.499    69.939     0.150
     4.499    82.540     0.150
     4.499   121.939     0.150
     4.499   141.140     0.150
     4.937    89.939     0.150
     4.937   153.640     0.150
     5.101    77.540     0.150
     5.101    92.939     0.150
     5.101   159.840     0.150
     5.941   184.939     0.150
     6.319    94.340     0.150
     6.319   114.840     0.150
     6.319   197.040     0.150
     6.319    94.640     0.150
     7.357   215.340     0.150
     7.357   227.939     0.150
     7.422   231.840     0.150
     0.618    11.871     0.150
     0.618    19.770     0.150
     0.618    12.070     0.150
     0.618    20.170     0.150
     1.217    23.070     0.150
     1.217    39.471     0.150
     1.346    24.871     0.150
     1.346    43.270     0.150
     1.346    24.770     0.150
     1.346    43.770     0.150
     2.150    37.971     0.150
     2.150    39.871     0.150
     2.150    67.971     0.150
     2.150    40.471     0.150
     2.541    42.971     0.150
     2.541    46.570     0.150
     2.541    80.070     0.150
     2.541    43.871     0.150
     2.541    46.871     0.150
     2.541    79.170     0.150
     2.710    44.971     0.150
     2.710    49.070     0.150
     2.710    83.270     0.150
     2.710    44.471     0.150
     2.710    48.770     0.150
     2.710    82.770     0.150
     3.563    65.670     0.150
     3.563    99.871     0.150
     3.563   111.971     0.150
     3.563    66.570     0.150
     3.563   112.770     0.150
     3.800    68.471     0.150
     3.800   107.070     0.150
     3.800   118.070     0.150
     3.800    61.471     0.150
     3.800    69.471     0.150
     3.918    62.070     0.150
     3.918    72.070     0.150
     3.918   108.070     0.150
     3.918   122.770     0.150
     3.885    61.971     0.150
     3.885    71.070     0.150
     3.885   106.570     0.150
     3.885   121.070     0.150
     3.885   106.770     0.150
     3.885   120.670     0.150
     4.183    66.170     0.150
     4.183    76.971     0.150
     4.183   131.270     0.150
     4.183    77.770     0.150
     4.183   132.471     0.150
     4.827    75.471     0.150
     4.827    87.570     0.150
     4.827   149.371     0.150
     4.827    89.670     0.150
     5.043    77.270     0.150
     5.043    92.070     0.150
     5.043   135.270     0.150
     5.043   157.371     0.150
     5.043    91.471     0.150
     5.043   156.971     0.150
     5.394    79.770     0.150
     5.394    95.971     0.150
     5.394   165.170     0.150
     5.358    98.170     0.150
     5.358   157.170     0.150
     5.358   168.670     0.150
     6.203   161.770     0.150
     6.203   194.971     0.150
     6.603   100.570     0.150
     6.603   169.971     0.150
     6.603   206.770     0.150
     6.603    99.570     0.150
     7.107   105.170     0.150
     7.178   107.871     0.150
     7.178   187.371     0.150
     7.178   220.170     0.150
     7.355   228.871     0.150
     7.444   109.770     0.150
     7.444   134.170     0.150
     7.695   142.170     0.150
     7.695   241.770     0.150
     7.695   114.270     0.150
     7.891   246.270     0.150
     7.943   146.270     0.150
     8.271   120.170     0.150
     8.271   211.871     0.150
    10.869   155.270     0.150
    10.821   156.820     0.150
    11.102   160.490     0.150
    11.102   350.330     0.150
    11.290   165.371     0.150
    11.290   350.670     0.150
    16.034   233.670     0.150
    19.086   265.020     0.150
    19.645   271.270     0.150
    20.763   284.070     0.150
    23.443   310.570     0.150
    23.880   317.170     0.150
    23.968   315.971     0.150
    23.957   318.320     0.150
    24.240   319.070     0.150
    24.699   323.871     0.150
    24.699   576.471     0.150
    25.281   330.971     0.150
    26.948   343.770     0.150
    27.352   347.619     0.150
    28.134   354.770     0.150
    30.887   379.471     0.150
    38.327   442.770     0.150
    43.395   484.871     0.150
    44.063   489.691     0.150
    47.498   520.270     0.150
    49.636   532.820     0.150
    55.253   576.871     0.150
    57.884   594.332     0.150
    70.241   675.270     0.150
    73.336   696.270     0.150
    73.438   694.711     0.150
    73.438   694.670     0.150
    73.852   697.070     0.150
    74.246   700.795     0.150
    77.165   715.180     0.150
    77.578   719.100     0.150
    77.951   721.590     0.150
    81.549   740.670     0.150
    83.089   748.971     0.150
    83.591   750.871     0.150
     0.589    18.814     0.150
     1.218    22.014     0.150
     1.218    37.814     0.150
     1.321    23.514     0.150
     2.188    37.113     0.150
     2.188    39.414     0.150
     2.188    67.713     0.150
     2.188    36.914     0.150
     2.188    67.514     0.150
     2.523    42.514     0.150
     2.523    45.514     0.150
     2.523    78.814     0.150
     2.633    47.213     0.150
     2.633    81.713     0.150
     2.633    81.914     0.150
     2.675    47.713     0.150
     2.675    82.613     0.150
     2.675    43.113     0.150
     2.675    47.514     0.150
     2.675    80.814     0.150
     3.543   111.414     0.150
     3.814   116.713     0.150
     3.867    60.414     0.150
     3.867    68.713     0.150
     3.867   105.213     0.150
     3.867   119.014     0.150
     3.867    68.014     0.150
     3.867   104.014     0.150
     3.946   122.514     0.150
     4.174    75.314     0.150
     4.174   113.613     0.150
     4.174   129.514     0.150
     4.174    65.014     0.150
     4.174    75.514     0.150
     4.174   130.113     0.150
     4.809    72.314     0.150
     4.809    86.213     0.150
     4.809   148.914     0.150
     5.355    97.414     0.150
     5.355   167.113     0.150
     5.422    78.814     0.150
     5.422    93.514     0.150
     5.422   138.014     0.150
     5.422   164.113     0.150
     6.199   194.014     0.150
     6.595   168.713     0.150
     6.595   207.213     0.150
     7.462   137.613     0.150
     7.462   232.414     0.150
     7.689   240.914     0.150
     0.607    11.758     0.150
     0.607    20.055     0.150
     0.607    18.859     0.150
     1.216    22.961     0.150
     1.216    39.758     0.150
     1.338    24.758     0.150
     1.338    24.656     0.150
     1.338    43.656     0.150
     2.164    37.961     0.150
     2.164    40.359     0.150
     2.164    68.555     0.150
     2.164    38.258     0.150
     2.164    40.961     0.150
     2.536    44.156     0.150
     2.536    46.758     0.150
     2.536    74.461     0.150
     2.536    79.555     0.150
     2.640    44.859     0.150
     2.640    48.555     0.150
     2.640    83.555     0.150
     2.640    83.359     0.150
     2.698    44.656     0.150
     2.698    48.859     0.150
     2.698    83.961     0.150
     2.698    44.156     0.150
     2.698    48.758     0.150
     2.698    83.859     0.150
     3.557    65.258     0.150
     3.557    99.656     0.150
     3.557   112.258     0.150
     3.557    65.555     0.150
     3.557   112.656     0.150
     3.804    61.555     0.150
     3.804    68.258     0.150
     3.804   107.055     0.150
     3.804   117.859     0.150
     3.804    69.359     0.150
     3.804   104.656     0.150
     3.879    62.055     0.150
     3.879    69.961     0.150
     3.879   121.055     0.150
     3.927    62.359     0.150
     3.927    71.758     0.150
     3.927   108.555     0.150
     3.927   121.461     0.150
     4.181    65.961     0.150
     4.181    76.055     0.150
     4.181   113.258     0.150
     4.181   130.359     0.150
     4.181    66.156     0.150
     4.181   113.461     0.150
     4.181   129.656     0.150
     4.821    76.156     0.150
     4.821    88.258     0.150
     4.821   130.758     0.150
     4.821   151.156     0.150
     4.821    76.656     0.150
     4.821    89.359     0.150
     4.821   130.461     0.150
     4.821   150.859     0.150
     5.358    97.555     0.150
     5.358   168.656     0.150
     5.403   167.555     0.150
     6.202    93.461     0.150
     6.202   112.555     0.150
     6.202   162.055     0.150
     6.202   193.258     0.150
     6.601   170.055     0.150
     6.601   207.258     0.150
     6.601    99.555     0.150
     7.355   228.055     0.150
     7.451   219.859     0.150
     7.451   232.555     0.150
     7.694   113.555     0.150
     7.694   240.055     0.150
     7.694   113.656     0.150
     7.694   199.461     0.150
     8.266   120.555     0.150
     8.266   210.758     0.150
     8.963   277.961     0.150
    10.184   318.555     0.150
    10.643   155.359     0.150
    10.825   157.055     0.150
    10.825   277.758     0.150
    10.881   155.461     0.150
    11.106   160.602     0.150
    11.106   280.734     0.150
    11.106   346.781     0.150
    23.873   312.461     0.150
    23.953   317.234     0.150
    24.252   319.859     0.150
    27.343   348.523     0.150
    28.125   351.961     0.150
    41.238   463.789     0.150
    43.383   485.258     0.150
    44.050   489.305     0.150
    49.625   533.383     0.150
    57.871   593.992     0.150
    73.432   693.258     0.150
    77.178   714.469     0.150
    80.774   734.211     0.150
     0.605    11.812     0.150
     0.605    20.113     0.150
     0.605    11.711     0.150
     1.212    22.812     0.150
     1.212    25.113     0.150
     1.212    38.910     0.150
     1.342    24.812     0.150
     1.342    26.211     0.150
     1.342    43.512     0.150
     1.342    45.910     0.150
     1.342    24.711     0.150
     1.342    42.012     0.150
     2.163    38.312     0.150
     2.163    40.211     0.150
     2.163    68.512     0.150
     2.163    38.211     0.150
     2.163    40.613     0.150
     2.540    43.613     0.150
     2.540    46.910     0.150
     2.540    74.312     0.150
     2.540    79.910     0.150
     2.540    44.312     0.150
     2.540    46.711     0.150
     2.540    78.812     0.150
     2.701    45.012     0.150
     2.701    49.113     0.150
     2.701    77.312     0.150
     2.701    84.312     0.150
     3.800    61.211     0.150
     3.800    68.812     0.150
     3.800   102.812     0.150
     3.800   107.012     0.150
     3.800   116.613     0.150
     3.800   116.410     0.150
     3.884    62.211     0.150
     3.884    70.012     0.150
     3.884   106.312     0.150
     3.884   121.711     0.150
     3.884    69.711     0.150
     3.884   105.410     0.150
     3.884   119.812     0.150
     3.923    62.312     0.150
     3.923    70.812     0.150
     3.923   107.512     0.150
     3.923   123.211     0.150
     4.185    66.312     0.150
     4.185    76.711     0.150
     4.185   130.711     0.150
     4.577   141.512     0.150
     4.826    75.512     0.150
     4.826    88.613     0.150
     4.826   129.711     0.150
     4.826   150.211     0.150
     4.826    75.613     0.150
     4.826    89.410     0.150
     5.399    79.711     0.150
     5.399    95.812     0.150
     5.399   138.812     0.150
     5.399   165.711     0.150
     6.606    98.910     0.150
     6.606   171.113     0.150
     6.606   206.812     0.150
     6.606    99.613     0.150
     7.360   228.910     0.150
     7.454   110.512     0.150
     7.454   233.312     0.150
     7.699   239.812     0.150
     0.607    11.805     0.150
     0.607    19.805     0.150
     0.607    18.904     0.150
     1.347    24.805     0.150
     1.347    45.705     0.150
     1.347    43.004     0.150
     2.158    38.004     0.150
     2.158    40.205     0.150
     2.158    68.805     0.150
     2.158    37.805     0.150
     2.544    43.104     0.150
     2.544    46.904     0.150
     2.544    74.104     0.150
     2.544    80.504     0.150
     2.706    44.805     0.150
     2.706    49.104     0.150
     2.706    76.404     0.150
     2.706    84.404     0.150
     3.565    67.305     0.150
     3.565   113.104     0.150
     3.888    62.305     0.150
     3.888    69.904     0.150
     3.888   106.504     0.150
     3.888   121.504     0.150
     3.888   104.205     0.150
     3.918    72.805     0.150
     3.918   123.205     0.150
     4.189    66.205     0.150
     4.189    76.504     0.150
     4.189   114.305     0.150
     4.189   131.805     0.150
     4.189    75.705     0.150
     4.575    84.004     0.150
     4.575   142.404     0.150
     4.830    75.205     0.150
     4.830    88.904     0.150
     4.830   128.205     0.150
     4.830   151.205     0.150
     4.830    75.604     0.150
     4.830    89.305     0.150
     5.365    82.004     0.150
     5.365    97.404     0.150
     5.365   140.504     0.150
     5.365   168.504     0.150
     5.365    82.404     0.150
     6.210    94.404     0.150
     6.210   113.305     0.150
     6.210   162.004     0.150
     6.210   195.205     0.150
     6.609    99.205     0.150
     6.609   120.504     0.150
     6.609   170.004     0.150
     6.609   207.805     0.150
     6.609    99.805     0.150
     6.609   170.205     0.150
     7.362   229.904     0.150
     7.454   109.604     0.150
     7.454   137.604     0.150
     7.454   193.705     0.150
     7.454   233.904     0.150
     7.702   115.504     0.150
     7.702   200.104     0.150
     7.702   241.305     0.150
     8.066   206.604     0.150
     8.066   253.205     0.150
     8.261   121.205     0.150
     8.261   148.004     0.150
     8.261   210.205     0.150
    10.873   157.104     0.150
    11.111   160.344     0.150
    11.111   348.805     0.150
    44.057   490.955     0.150
    49.633   534.154     0.150
    73.428   695.066     0.150
    77.174   715.312     0.150
     0.648    12.828     0.150
     0.648    21.125     0.150
     1.012    18.625     0.150
     1.012    32.227     0.150
     1.012    36.125     0.150
     1.012    18.523     0.150
     1.012    31.922     0.150
     1.454    27.422     0.150
     1.454    47.023     0.150
     2.228    40.727     0.150
     2.228    70.125     0.150
     2.385    43.023     0.150
     2.385    74.023     0.150
     2.373    40.023     0.150
     2.373    42.922     0.150
     2.373    73.922     0.150
     2.421    40.922     0.150
     2.421    43.727     0.150
     2.421    75.523     0.150
     2.421    40.422     0.150
     2.421    70.125     0.150
     2.421    75.227     0.150
     3.243    58.328     0.150
     3.243   101.422     0.150
     3.572    56.523     0.150
     3.572    63.828     0.150
     3.572   110.625     0.150
     3.572    55.227     0.150
     3.572    63.625     0.150
     3.572    97.727     0.150
     3.572   110.422     0.150
     3.914    61.125     0.150
     3.914    71.023     0.150
     3.914   123.328     0.150
     4.098    62.727     0.150
     4.098    73.328     0.150
     4.098   126.828     0.150
     4.513    81.523     0.150
     4.513   140.625     0.150
     4.969    90.828     0.150
     4.969   156.625     0.150
     5.125    92.922     0.150
     5.125   160.922     0.150
     6.341   198.828     0.150
     7.424   229.922     0.150
     7.389   216.828     0.150
     7.389   229.727     0.150
     7.445   232.328     0.150
     8.720   272.227     0.150
     9.921   308.227     0.150
     0.290     5.894     0.150
     0.290     9.693     0.150
     1.097    20.793     0.150
     1.097    35.493     0.150
     1.310    24.193     0.150
     1.310    26.094     0.150
     1.310    41.594     0.150
     1.310    44.594     0.150
     1.310    40.894     0.150
     2.465    41.594     0.150
     2.465    44.793     0.150
     2.465    78.394     0.150
     2.465    45.394     0.150
     2.465    72.594     0.150
     2.465    78.094     0.150
     2.502    42.894     0.150
     2.502    45.293     0.150
     2.502    77.693     0.150
     2.502    42.594     0.150
     2.502    44.993     0.150
     2.502    71.693     0.150
     2.502    77.094     0.150
     2.554    46.894     0.150
     2.554    80.894     0.150
     2.736    45.693     0.150
     2.736    49.894     0.150
     2.736    86.293     0.150
     2.736    49.493     0.150
     2.736    85.793     0.150
     3.556    65.493     0.150
     3.556   112.193     0.150
     3.556    64.293     0.150
     3.556   112.993     0.150
     3.773    61.193     0.150
     3.773    67.193     0.150
     3.773   104.394     0.150
     3.773   116.293     0.150
     3.773    70.193     0.150
     3.773   104.193     0.150
     3.773   115.394     0.150
     3.800    60.293     0.150
     3.800   105.793     0.150
     3.800   116.394     0.150
     3.896    61.793     0.150
     3.896    70.493     0.150
     3.896   122.394     0.150
     3.896    69.293     0.150
     3.896   106.094     0.150
     3.896   121.394     0.150
     4.039   123.993     0.150
     4.275    66.993     0.150
     4.275    77.094     0.150
     4.275   134.193     0.150
     4.275    67.293     0.150
     4.275    78.094     0.150
     4.275   116.094     0.150
     4.422   118.293     0.150
     4.422   133.493     0.150
     4.422   136.693     0.150
     4.832    87.693     0.150
     4.832   151.394     0.150
     5.321   168.094     0.150
     5.499    83.594     0.150
     5.499   100.094     0.150
     5.499   172.493     0.150
     5.499    99.594     0.150
     6.703   100.493     0.150
     6.703   209.493     0.150
     6.703   100.293     0.150
     7.059   105.394     0.150
     7.059   185.193     0.150
     7.059   217.094     0.150
     7.452   233.094     0.150
     7.734   113.293     0.150
     7.734   243.594     0.150
     7.734   112.493     0.150
     7.812   245.094     0.150
     9.090   283.693     0.150
     9.795   304.593     0.150
    10.281   319.593     0.150
    11.343   353.093     0.150
     0.825    15.890     0.150
     0.825    26.890     0.150
     0.838    16.290     0.150
     0.838    27.190     0.150
     0.838    16.190     0.150
     0.838    26.790     0.150
     1.667    31.290     0.150
     1.667    52.690     0.150
     2.022    37.390     0.150
     2.022    64.690     0.150
     2.022    37.290     0.150
     2.022    59.190     0.150
     2.022    64.090     0.150
     2.160    37.890     0.150
     2.160    39.990     0.150
     2.160    68.090     0.150
     2.160    39.890     0.150
     2.279    41.790     0.150
     2.279    71.290     0.150
     2.279    38.690     0.150
     2.279    41.290     0.150
     2.279    70.990     0.150
     2.488    42.790     0.150
     2.488    45.490     0.150
     2.488    78.790     0.150
     2.488    45.690     0.150
     2.488    72.790     0.150
     2.488    78.890     0.150
     3.367    54.590     0.150
     3.367   105.890     0.150
     3.701    59.290     0.150
     3.701    67.090     0.150
     3.701   116.690     0.150
     4.308   135.190     0.150
     4.810   150.490     0.150
     4.916    75.690     0.150
     4.916    90.090     0.150
     4.916   155.390     0.150
     5.908    86.790     0.150
     5.908   105.290     0.150
     5.908   151.990     0.150
     5.908   181.790     0.150
     6.128   190.690     0.150
     7.236   224.590     0.150
     0.595    11.589     0.150
     0.595    19.489     0.150
     1.217    38.789     0.150
     1.327    24.489     0.150
     2.180    38.089     0.150
     2.180    39.889     0.150
     2.180    69.089     0.150
     2.527    73.689     0.150
     2.527    78.589     0.150
     2.527    46.389     0.150
     2.527    79.889     0.150
     2.636    47.689     0.150
     2.636    82.389     0.150
     2.636    44.689     0.150
     2.636    47.789     0.150
     2.636    82.789     0.150
     2.683    43.889     0.150
     2.683    48.389     0.150
     2.683    82.489     0.150
     2.683    48.889     0.150
     2.683    50.989     0.150
     2.683    83.589     0.150
     3.786   116.689     0.150
     3.871    61.689     0.150
     3.871    69.489     0.150
     3.871   105.489     0.150
     3.871   120.089     0.150
     3.871    61.789     0.150
     3.871    69.589     0.150
     3.871   104.289     0.150
     3.871   120.589     0.150
     4.176    74.589     0.150
     4.176   129.889     0.150
     4.176   113.389     0.150
     4.176   131.089     0.150
     4.813    74.989     0.150
     4.813    88.789     0.150
     4.813    74.789     0.150
     4.813    86.889     0.150
     4.813   149.789     0.150
     5.056   159.289     0.150
     5.356    97.789     0.150
     5.356    81.789     0.150
     5.356    97.389     0.150
     5.356   166.989     0.150
     6.200   195.089     0.150
     6.597    97.489     0.150
     6.597   118.489     0.150
     6.597   169.789     0.150
     6.597    99.189     0.150
     6.597   206.489     0.150
     7.354   230.189     0.150
     7.458   108.889     0.150
     7.458   232.889     0.150
     8.059   252.189     0.150
     0.385     7.672     0.150
     0.385    12.172     0.150
     0.385    12.867     0.150
     1.184    22.367     0.150
     1.184    37.867     0.150
     2.434    41.367     0.150
     2.434    44.469     0.150
     2.434    71.070     0.150
     2.434    76.172     0.150
     2.434    41.469     0.150
     2.434    44.367     0.150
     2.434    77.070     0.150
     2.480    42.469     0.150
     2.480    44.672     0.150
     2.480    76.766     0.150
     2.480    44.867     0.150
     2.480    77.172     0.150
     2.474    41.867     0.150
     2.474    44.969     0.150
     2.474    72.672     0.150
     2.474    77.266     0.150
     2.474    45.172     0.150
     2.474    77.969     0.150
     2.645    43.469     0.150
     2.645    47.969     0.150
     2.645    75.969     0.150
     2.645    82.266     0.150
     2.645    44.469     0.150
     2.645    83.070     0.150
     3.481    63.469     0.150
     3.481   110.172     0.150
     3.481   110.070     0.150
     3.849   119.672     0.150
     3.849    70.070     0.150
     3.849   118.367     0.150
     3.818    59.672     0.150
     3.818    68.672     0.150
     3.818   103.766     0.150
     3.818    60.766     0.150
     3.818    69.266     0.150
     3.818   118.867     0.150
     4.082    73.969     0.150
     4.082   126.266     0.150
     4.184    65.766     0.150
     4.184    75.266     0.150
     4.184    75.570     0.150
     4.184   131.570     0.150
     4.755    74.070     0.150
     4.755    87.266     0.150
     4.755   148.172     0.150
     4.755    74.172     0.150
     4.755    85.469     0.150
     4.755   148.070     0.150
     5.224   164.867     0.150
     5.403    82.266     0.150
     5.403    98.266     0.150
     5.403   169.867     0.150
     5.565    96.172     0.150
     5.565   170.266     0.150
     6.047   110.070     0.150
     6.047   187.672     0.150
     6.243    93.570     0.150
     6.243   112.867     0.150
     6.243   195.367     0.150
     6.613    98.969     0.150
     6.613    98.867     0.150
     6.613   206.570     0.150
     7.392   230.969     0.150
     7.413   109.672     0.150
     7.413   230.969     0.150
     7.441   232.367     0.150
     7.638   112.070     0.150
     7.638   196.367     0.150
     7.638   238.867     0.150
     7.720   114.070     0.150
     7.720   242.172     0.150
     8.996   279.969     0.150
    10.191   315.867     0.150
    11.074   344.867     0.150
    11.259   349.969     0.150
     0.398     7.895     0.150
     0.398    13.094     0.150
     0.398    12.793     0.150
     2.421    41.395     0.150
     2.421    44.395     0.150
     2.421    71.293     0.150
     2.421    76.793     0.150
     2.488    42.195     0.150
     2.488    44.895     0.150
     2.488    71.695     0.150
     2.488    76.992     0.150
     2.488    77.195     0.150
     2.472    44.992     0.150
     2.472    77.594     0.150
     2.472    45.395     0.150
     2.472    78.094     0.150
     2.639    43.992     0.150
     2.639    47.992     0.150
     2.639    75.895     0.150
     2.639    82.094     0.150
     2.639    44.492     0.150
     2.639    48.094     0.150
     2.639    83.395     0.150
     3.480   110.195     0.150
     3.480    63.293     0.150
     3.851   116.094     0.150
     3.851    70.395     0.150
     3.851   103.195     0.150
     3.851   118.492     0.150
     3.865    71.293     0.150
     3.865   106.293     0.150
     3.865   119.492     0.150
     3.816    68.395     0.150
     3.816   104.293     0.150
     3.816   117.992     0.150
     3.816    60.992     0.150
     3.816    68.992     0.150
     3.816   118.992     0.150
     4.179    65.895     0.150
     4.179    76.594     0.150
     4.179   131.895     0.150
     4.525    81.492     0.150
     4.525   120.695     0.150
     4.525   141.293     0.150
     4.754    74.293     0.150
     4.754    87.492     0.150
     4.754   148.492     0.150
     4.754    74.395     0.150
     4.754    85.992     0.150
     4.754    88.195     0.150
     4.754   148.094     0.150
     5.211   165.094     0.150
     5.396    82.293     0.150
     5.396    98.293     0.150
     5.396    82.395     0.150
     5.396    98.395     0.150
     5.560    97.094     0.150
     5.560   143.992     0.150
     5.560   170.594     0.150
     6.041   107.594     0.150
     6.041   157.895     0.150
     6.041   186.695     0.150
     6.236    93.895     0.150
     6.236   113.195     0.150
     6.236   195.793     0.150
     6.607    98.695     0.150
     6.607   119.293     0.150
     6.607   206.594     0.150
     7.377   230.094     0.150
     7.434   231.492     0.150
     7.625   111.793     0.150
     7.625   197.895     0.150
     7.625   237.492     0.150
     7.714   114.395     0.150
     7.714   241.895     0.150
     8.116   119.793     0.150
     8.116   251.395     0.150
     8.990   280.594     0.150
     9.697   303.594     0.150
    10.186   315.895     0.150
    11.069   343.895     0.150
    11.256   350.195     0.150
     0.397     7.816     0.150
     0.397    12.816     0.150
     0.397    12.918     0.150
     1.231    22.918     0.150
     1.231    39.020     0.150
     1.231    25.219     0.150
     1.231    39.316     0.150
     1.192    22.520     0.150
     1.192    38.020     0.150
     2.427    44.617     0.150
     2.427    71.617     0.150
     2.427    77.020     0.150
     2.427    41.520     0.150
     2.427    44.418     0.150
     2.468    42.219     0.150
     2.468    45.316     0.150
     2.468    77.219     0.150
     2.468    45.617     0.150
     2.468    72.816     0.150
     2.468    78.418     0.150
     2.481    41.117     0.150
     2.481    44.816     0.150
     2.481    77.117     0.150
     2.481    41.918     0.150
     2.481    45.020     0.150
     2.481    71.816     0.150
     2.481    77.520     0.150
     2.636    43.918     0.150
     2.636    47.918     0.150
     2.636    76.316     0.150
     2.636    83.020     0.150
     2.636    44.617     0.150
     2.636    48.219     0.150
     2.636    83.418     0.150
     3.475    63.316     0.150
     3.475   110.117     0.150
     3.475    56.316     0.150
     3.812   103.617     0.150
     3.812   117.918     0.150
     3.812    60.918     0.150
     3.812    68.918     0.150
     3.812   119.020     0.150
     3.761    60.719     0.150
     3.761   104.020     0.150
     3.855    61.316     0.150
     3.855    69.219     0.150
     3.855   119.719     0.150
     3.855   118.617     0.150
     3.870    62.020     0.150
     3.870    70.020     0.150
     3.870   105.219     0.150
     3.870   119.719     0.150
     4.176    66.117     0.150
     4.176    75.520     0.150
     4.176   112.520     0.150
     4.176    76.719     0.150
     4.176   131.719     0.150
     4.749    74.418     0.150
     4.749    87.617     0.150
     4.749   148.617     0.150
     4.749    73.918     0.150
     4.749    86.117     0.150
     4.749   129.020     0.150
     4.749   148.316     0.150
     5.212    95.117     0.150
     5.212    79.316     0.150
     5.212    94.719     0.150
     5.212   138.617     0.150
     5.212   163.617     0.150
     5.394    82.617     0.150
     5.394    98.316     0.150
     5.394    98.520     0.150
     5.394   169.520     0.150
     6.234    93.918     0.150
     6.234   113.520     0.150
     6.234   196.219     0.150
     6.604    98.816     0.150
     6.604   118.918     0.150
     6.604   204.418     0.150
     7.382   107.188     0.150
     7.382   132.840     0.150
     7.382   189.188     0.150
     7.382   230.957     0.150
     7.404   109.719     0.150
     7.404   233.020     0.150
     7.432   110.117     0.150
     7.432   136.520     0.150
     7.432   233.520     0.150
     7.626   111.816     0.150
     7.626   194.918     0.150
     7.626   111.918     0.150
     7.626   197.816     0.150
     7.626   238.117     0.150
     7.627   236.816     0.150
     7.711   113.816     0.150
     7.984   248.719     0.150
     8.140   118.719     0.150
     8.140   207.719     0.150
     8.987   132.918     0.150
     8.987   279.816     0.150
     9.694   141.418     0.150
     9.694   302.418     0.150
    10.183   315.816     0.150
    10.682   155.617     0.150
    10.682   272.816     0.150
    10.682   331.020     0.150
    11.222   163.598     0.150
    11.222   352.797     0.150
    11.252   162.816     0.150
    11.252   351.020     0.150
    24.570   322.520     0.150
     0.388     7.648     0.150
     0.388    12.844     0.150
     1.190    22.445     0.150
     1.190    37.844     0.150
     1.229    22.750     0.150
     1.229    38.547     0.150
     1.229    38.750     0.150
     2.438    41.344     0.150
     2.438    44.547     0.150
     2.438    71.445     0.150
     2.438    76.750     0.150
     2.438    41.047     0.150
     2.438    44.250     0.150
     2.474    41.344     0.150
     2.474    44.445     0.150
     2.474    71.750     0.150
     2.474    76.945     0.150
     2.474    41.945     0.150
     2.474    44.844     0.150
     2.474    77.148     0.150
     2.468    41.945     0.150
     2.468    44.844     0.150
     2.468    76.750     0.150
     2.468    41.750     0.150
     2.468    45.250     0.150
     2.468    72.648     0.150
     2.468    77.547     0.150
     2.639    44.445     0.150
     2.639    47.445     0.150
     2.639    75.648     0.150
     2.639    82.445     0.150
     2.639    48.047     0.150
     2.639    77.047     0.150
     2.639    83.445     0.150
     3.474   108.445     0.150
     3.762    60.047     0.150
     3.762   104.047     0.150
     3.811    60.750     0.150
     3.811    68.344     0.150
     3.811   118.547     0.150
     3.856    68.945     0.150
     3.856   117.648     0.150
     3.856    62.648     0.150
     3.856    71.047     0.150
     3.856   121.547     0.150
     3.872    70.250     0.150
     3.872   106.148     0.150
     3.872   118.945     0.150
     4.178    65.945     0.150
     4.178    76.648     0.150
     4.178   131.648     0.150
     4.178    65.250     0.150
     4.178    75.344     0.150
     4.178   130.250     0.150
     4.749    74.750     0.150
     4.749    87.844     0.150
     4.749   148.648     0.150
     4.749    86.750     0.150
     4.749   148.148     0.150
     5.221    95.250     0.150
     5.221    78.148     0.150
     5.221    94.547     0.150
     5.221   138.945     0.150
     5.221   163.148     0.150
     5.398    82.445     0.150
     5.398    98.445     0.150
     5.398    82.148     0.150
     5.398    98.250     0.150
     5.398   143.648     0.150
     6.238    93.945     0.150
     6.238   113.344     0.150
     6.238   196.547     0.150
     6.607    99.047     0.150
     6.607   207.750     0.150
     7.394   232.047     0.150
     7.408   231.844     0.150
     7.436   233.844     0.150
     7.631   238.344     0.150
     7.635   113.250     0.150
     7.635   198.844     0.150
     7.635   238.445     0.150
     7.714   240.547     0.150
     7.987   248.047     0.150
    10.686   270.750     0.150
    10.686   330.750     0.150
    11.253   350.648     0.150
     0.551    10.844     0.150
     0.551    18.141     0.150
     0.551    18.242     0.150
     1.052    19.641     0.150
     1.052    33.945     0.150
     2.132    37.039     0.150
     2.132    39.141     0.150
     2.132    67.039     0.150
     2.132    67.141     0.150
     2.701    49.445     0.150
     2.701    83.641     0.150
     2.701    49.141     0.150
     2.701    85.141     0.150
     2.803    45.141     0.150
     2.803    50.141     0.150
     2.803    78.844     0.150
     2.803    86.039     0.150
     2.803    45.844     0.150
     2.803    50.539     0.150
     2.803    86.242     0.150
     3.530    97.539     0.150
     3.783    59.945     0.150
     3.783    68.641     0.150
     3.783   117.945     0.150
     4.045    63.945     0.150
     4.045    72.945     0.150
     4.045   125.242     0.150
     4.987    76.742     0.150
     4.987    91.445     0.150
     4.987    77.141     0.150
     4.987    90.539     0.150
     4.987   155.242     0.150
     5.526    99.844     0.150
     5.526    83.945     0.150
     5.526   100.039     0.150
     5.526   145.539     0.150
     5.526   173.344     0.150
     6.371    95.742     0.150
     6.371   165.242     0.150
     6.371   199.945     0.150
     6.772   101.445     0.150
     6.772   175.445     0.150
     6.772   101.344     0.150
     6.772   212.039     0.150
     7.522   111.539     0.150
     7.522   234.039     0.150
     7.577   110.844     0.150
     7.577   236.344     0.150
     7.733   240.242     0.150
     7.864   244.445     0.150
     8.121   144.742     0.150
     8.121   206.641     0.150
     8.225   256.039     0.150
    10.354   321.539     0.150
    11.244   349.539     0.150
    11.456   355.945     0.150
     0.558    10.875     0.150
     0.558    18.172     0.150
     1.058    20.070     0.150
     1.058    34.273     0.150
     2.126    36.875     0.150
     2.126    39.172     0.150
     2.126    67.172     0.150
     2.126    37.375     0.150
     2.126    39.070     0.150
     2.126    66.969     0.150
     2.698    48.570     0.150
     2.698    84.070     0.150
     2.698    43.875     0.150
     2.698    49.570     0.150
     2.698    84.875     0.150
     2.805    45.375     0.150
     2.805    50.375     0.150
     2.805    86.375     0.150
     2.805    45.969     0.150
     2.805    50.773     0.150
     3.533    97.375     0.150
     3.638    65.969     0.150
     3.638   111.070     0.150
     3.783    60.273     0.150
     3.783    68.969     0.150
     3.783   102.969     0.150
     3.783   118.070     0.150
     4.042    63.875     0.150
     4.042    73.070     0.150
     4.042   108.172     0.150
     4.042    64.070     0.150
     4.042    73.273     0.150
     4.042   125.875     0.150
     4.984    76.969     0.150
     4.984    91.375     0.150
     4.984   132.273     0.150
     4.984    91.570     0.150
     4.984   155.773     0.150
     5.521    99.969     0.150
     5.521    84.070     0.150
     5.521   100.172     0.150
     5.521   145.570     0.150
     5.521   172.875     0.150
     6.366    95.875     0.150
     6.366   200.070     0.150
     6.767   100.469     0.150
     6.767   102.273     0.150
     6.767   211.875     0.150
     7.517   234.773     0.150
     7.570   111.070     0.150
     7.570   236.570     0.150
     7.728   240.773     0.150
     8.053   252.070     0.150
     8.128   206.570     0.150
     0.374     7.281     0.150
     0.374    13.781     0.150
     1.194    38.281     0.150
     2.667    44.480     0.150
     2.667    76.383     0.150
     2.819    45.883     0.150
     2.819    50.680     0.150
     2.819    89.082     0.150
     2.819    51.480     0.150
     2.503    41.781     0.150
     2.503    74.180     0.150
     2.669    43.582     0.150
     2.669    46.781     0.150
     2.669    81.980     0.150
     3.484    60.680     0.150
     3.484   104.980     0.150
     3.484    93.383     0.150
     3.025    49.582     0.150
     3.025    87.883     0.150
     3.203    51.082     0.150
     3.203    57.383     0.150
     3.203    89.582     0.150
     3.203    99.680     0.150
     3.920   122.883     0.150
     4.136    64.980     0.150
     4.136   128.480     0.150
     4.136    73.781     0.150
     4.893   151.980     0.150
     5.673    85.781     0.150
     5.673   176.883     0.150
     5.673   101.582     0.150
     6.172   191.781     0.150
     5.661   168.680     0.150
     6.547   203.680     0.150
     6.898   214.781     0.150
     7.738   241.980     0.150
     8.936   278.883     0.150
     9.124   285.582     0.150
     9.613   241.383     0.150
     9.613   301.383     0.150
     0.450     8.789     0.150
     0.450    15.590     0.150
     1.210    22.789     0.150
     1.210    39.688     0.150
     1.210    39.488     0.150
     2.486    42.289     0.150
     2.486    73.289     0.150
     2.529    43.289     0.150
     2.529    45.891     0.150
     2.529    75.188     0.150
     2.529    77.789     0.150
     2.529    43.188     0.150
     2.529    74.391     0.150
     2.715    44.789     0.150
     2.715    48.789     0.150
     2.715    83.289     0.150
     2.913    47.488     0.150
     2.913    51.988     0.150
     2.913    90.590     0.150
     2.913    52.188     0.150
     2.913    82.188     0.150
     2.990    47.391     0.150
     2.990    51.090     0.150
     2.990    82.289     0.150
     2.990    89.590     0.150
     3.273    52.590     0.150
     3.273    58.488     0.150
     3.273    90.789     0.150
     3.273   100.488     0.150
     3.453    55.090     0.150
     3.453   107.289     0.150
     3.453    54.891     0.150
     3.453   106.391     0.150
     3.931   123.188     0.150
     4.161   129.789     0.150
     4.721   120.891     0.150
     4.897   153.188     0.150
     5.254    96.289     0.150
     5.254   164.391     0.150
     5.254   139.188     0.150
     5.695   179.090     0.150
     5.641    84.188     0.150
     5.641   149.090     0.150
     5.641   170.891     0.150
     6.175   193.289     0.150
     6.612   207.289     0.150
     6.678   117.488     0.150
     6.930   127.090     0.150
     6.930   216.988     0.150
     7.769   244.789     0.150
     8.125   120.090     0.150
     8.125   148.988     0.150
     8.125   254.188     0.150
     8.967   279.188     0.150
     9.162   287.590     0.150
     9.240   290.688     0.150
     9.469   296.188     0.150
     9.651   242.789     0.150
     9.651   302.789     0.150
    10.519   329.391     0.150
    11.221   348.891     0.150
    11.697   362.891     0.150
    12.218   381.090     0.150
    12.574   391.188     0.150
    12.724   397.488     0.150
     0.290     5.859     0.150
     0.290     9.555     0.150
     0.290     6.055     0.150
     0.290     9.656     0.150
     1.104    21.055     0.150
     1.104    35.453     0.150
     1.302    24.055     0.150
     1.302    41.359     0.150
     1.302    24.156     0.150
     1.302    41.859     0.150
     2.472    42.359     0.150
     2.472    72.656     0.150
     2.472    77.953     0.150
     2.472    41.953     0.150
     2.472    45.258     0.150
     2.472    78.055     0.150
     2.493    40.953     0.150
     2.493    44.555     0.150
     2.493    76.258     0.150
     2.493    41.758     0.150
     2.493    44.859     0.150
     2.493    72.156     0.150
     2.493    77.258     0.150
     2.547    43.156     0.150
     2.547    47.055     0.150
     2.547    73.859     0.150
     2.547    80.055     0.150
     2.730    45.555     0.150
     2.730    49.758     0.150
     2.730    78.359     0.150
     2.730    85.359     0.150
     3.548    65.758     0.150
     3.548   112.359     0.150
     3.548    64.656     0.150
     3.548   110.953     0.150
     3.780    70.055     0.150
     3.780   116.258     0.150
     3.780    66.859     0.150
     3.780   102.859     0.150
     3.780   116.453     0.150
     3.808    60.359     0.150
     3.808    68.453     0.150
     3.808   103.258     0.150
     3.808   117.055     0.150
     3.888    60.359     0.150
     3.888    69.555     0.150
     3.888   105.258     0.150
     3.888    62.055     0.150
     3.888    70.953     0.150
     3.888   105.953     0.150
     3.888   121.453     0.150
     4.269    66.953     0.150
     4.269    79.258     0.150
     4.269   133.555     0.150
     4.269    78.953     0.150
     4.269   115.156     0.150
     4.427    67.953     0.150
     4.427    79.453     0.150
     4.427   135.656     0.150
     4.824    73.758     0.150
     4.824    87.359     0.150
     4.824   149.953     0.150
     4.824    74.758     0.150
     4.824    88.055     0.150
     5.320   166.156     0.150
     5.533    81.758     0.150
     5.533    96.359     0.150
     5.533   140.359     0.150
     5.533   167.656     0.150
     5.493    83.359     0.150
     5.493   100.359     0.150
     5.493   172.156     0.150
     6.333   197.555     0.150
     6.697   100.156     0.150
     6.697   120.359     0.150
     6.697   207.953     0.150
     7.065   217.953     0.150
     7.457   232.055     0.150
     7.729   242.359     0.150
     7.807   115.555     0.150
     7.807   244.156     0.150
     8.032   250.258     0.150
     8.216   257.258     0.150
     9.084   281.453     0.150
     9.789   304.859     0.150
    10.275   320.555     0.150
    10.781   336.758     0.150
    11.156   347.859     0.150
    11.336   353.055     0.150
     0.672    12.312     0.150
     0.672    21.711     0.150
     0.672    12.617     0.150
     0.672    21.812     0.150
     1.138    39.617     0.150
     1.779    32.711     0.150
     1.779    33.516     0.150
     1.779    55.617     0.150
     1.779    56.812     0.150
     1.779    32.914     0.150
     1.779    57.312     0.150
     1.874    34.117     0.150
     1.874    34.414     0.150
     1.874    59.312     0.150
     2.248    40.312     0.150
     2.248    70.016     0.150
     2.248    37.617     0.150
     2.248    40.617     0.150
     2.248    70.312     0.150
     2.805    51.016     0.150
     2.805    89.711     0.150
     2.805    51.312     0.150
     2.805    87.812     0.150
     3.118    51.117     0.150
     3.118    57.117     0.150
     3.118    87.617     0.150
     3.118    96.312     0.150
     3.118    51.016     0.150
     3.118    56.414     0.150
     3.118    98.016     0.150
     3.415    55.312     0.150
     3.415    62.016     0.150
     3.415   106.914     0.150
     3.415    55.117     0.150
     3.415    62.211     0.150
     3.415   107.914     0.150
     4.061    73.117     0.150
     4.061   127.016     0.150
     4.539    81.516     0.150
     4.539   140.016     0.150
     4.575    81.414     0.150
     4.575    83.016     0.150
     4.575   121.211     0.150
     4.575   142.312     0.150
     4.537   141.914     0.150
     4.633    72.117     0.150
     4.633    85.211     0.150
     4.633   145.117     0.150
     4.618    71.516     0.150
     4.618   144.617     0.150
     4.618    71.211     0.150
     4.618    83.312     0.150
     4.618   144.414     0.150
     5.458   100.016     0.150
     5.458   171.414     0.150
     5.839    88.016     0.150
     5.839   105.617     0.150
     5.839   106.812     0.150
     5.839   183.211     0.150
     6.850   214.914     0.150
     6.940   105.117     0.150
     6.940   216.016     0.150
     6.967   101.812     0.150
     6.967   218.312     0.150
     7.127   221.516     0.150
     8.214   256.117     0.150
     9.421   293.516     0.150
    10.207   257.812     0.150
    10.308   319.312     0.150
     2.161    36.492     0.150
     2.885    53.094     0.150
     2.885    89.891     0.150
     2.885    45.191     0.150
     2.885    79.094     0.150
     2.885    88.891     0.150
     3.099    48.594     0.150
     3.099    92.492     0.150
     3.099    48.492     0.150
     3.099    85.391     0.150
     3.099    92.391     0.150
     3.267    50.594     0.150
     3.267    58.594     0.150
     3.267   100.891     0.150
     3.404   107.094     0.150
     3.480    51.293     0.150
     3.480    60.094     0.150
     3.480    91.992     0.150
     3.480   102.992     0.150
     3.673    57.094     0.150
     3.673    67.191     0.150
     3.673   115.492     0.150
     3.759    57.691     0.150
     3.759    67.293     0.150
     3.759   100.492     0.150
     3.759   116.594     0.150
     4.352    77.992     0.150
     4.352   134.793     0.150
     4.714    71.293     0.150
     4.714    82.691     0.150
     4.714   146.594     0.150
     5.226   159.492     0.150
     5.196    92.992     0.150
     5.196    77.992     0.150
     5.196   162.594     0.150
     5.628    85.793     0.150
     5.628    84.891     0.150
     5.628   174.793     0.150
     6.462    95.594     0.150
     6.462   202.492     0.150
     7.294   228.992     0.150
     7.623   237.594     0.150
     8.128   254.594     0.150
     8.716   273.891     0.150
     8.713   272.691     0.150
     8.748   272.391     0.150
     9.197   287.992     0.150
    10.031   311.691     0.150
    11.186   348.094     0.150
    12.056   374.293     0.150
    12.187   378.691     0.150
    12.338   387.383     0.150
    19.619   266.867     0.150
    24.776   320.266     0.150
    78.043   716.027     0.150
     0.288     7.044     0.150
     0.288    12.044     0.150
     0.288     7.145     0.150
     0.288    12.145     0.150
     1.752    30.345     0.150
     1.752    53.145     0.150
     1.752    31.944     0.150
     2.666    41.244     0.150
     2.666    46.444     0.150
     2.666    80.744     0.150
     2.666    41.744     0.150
     2.666    46.845     0.150
     2.666    80.444     0.150
     2.718    43.544     0.150
     2.718    48.645     0.150
     2.718    76.944     0.150
     2.718    84.744     0.150
     2.718    84.845     0.150
     3.319    60.345     0.150
     3.242    51.044     0.150
     3.242    89.145     0.150
     3.242   101.244     0.150
     3.388    52.845     0.150
     3.388    62.044     0.150
     3.388    92.744     0.150
     3.388   105.145     0.150
     3.388    52.444     0.150
     3.388   102.544     0.150
     3.488    61.944     0.150
     3.488   107.544     0.150
     3.862    59.444     0.150
     3.862    67.544     0.150
     3.862   104.444     0.150
     3.862   119.145     0.150
     3.976   124.645     0.150
     4.330    78.544     0.150
     4.330    65.845     0.150
     4.330    80.444     0.150
     4.330   129.145     0.150
     4.330   135.145     0.150
     4.772    72.345     0.150
     4.772   147.744     0.150
     4.772    72.244     0.150
     4.772    86.145     0.150
     4.772   148.645     0.150
     5.255    94.645     0.150
     5.255   162.845     0.150
     5.346   161.345     0.150
     5.865   184.345     0.150
     6.022    88.744     0.150
     6.022    88.444     0.150
     6.022   108.645     0.150
     6.022   188.345     0.150
     6.857   213.444     0.150
     7.201   225.944     0.150
     8.753   272.744     0.150
    10.771   335.044     0.150
    11.646   361.244     0.150
    11.798   364.944     0.150
     1.085    21.016     0.150
     1.085    35.416     0.150
     1.602    29.616     0.150
     1.602    50.516     0.150
     1.602    29.116     0.150
     1.602    30.116     0.150
     1.602    49.616     0.150
     1.602    51.116     0.150
     1.689    32.016     0.150
     1.689    54.916     0.150
     2.668    48.416     0.150
     2.668    83.416     0.150
     2.668    44.416     0.150
     2.668    84.116     0.150
     2.681    49.116     0.150
     2.681    49.416     0.150
     2.681    75.416     0.150
     2.681    84.416     0.150
     3.098    95.716     0.150
     3.683    67.316     0.150
     3.683   114.416     0.150
     3.703    58.516     0.150
     3.703    66.516     0.150
     3.703   114.716     0.150
     3.716    67.216     0.150
     3.716   117.416     0.150
     3.708    67.116     0.150
     3.708   118.216     0.150
     3.708    67.316     0.150
     3.708   100.516     0.150
     3.708   117.816     0.150
     3.811   104.816     0.150
     3.811   116.916     0.150
     3.811    69.716     0.150
     3.811   105.416     0.150
     3.811   118.416     0.150
     4.002    62.616     0.150
     4.002    72.816     0.150
     4.002   109.316     0.150
     4.002   124.516     0.150
     4.002    74.616     0.150
     4.002   106.616     0.150
     4.002   126.116     0.150
     4.183    65.316     0.150
     4.183    76.316     0.150
     4.183   131.216     0.150
     4.183    65.216     0.150
     4.183    77.316     0.150
     4.183   112.016     0.150
     4.183   132.016     0.150
     4.943    75.816     0.150
     4.943    90.716     0.150
     4.943    75.516     0.150
     4.943    90.916     0.150
     4.943   155.816     0.150
     5.273    80.116     0.150
     5.273    94.916     0.150
     5.273    95.916     0.150
     5.273   140.616     0.150
     5.273   166.316     0.150
     5.584   176.016     0.150
     6.121    91.716     0.150
     6.121   191.916     0.150
     6.572    97.816     0.150
     6.572   119.016     0.150
     6.572    97.416     0.150
     6.572   170.716     0.150
     6.572   205.316     0.150
     7.097   104.116     0.150
     7.097   127.316     0.150
     7.097   104.616     0.150
     7.097   221.916     0.150
     7.238   226.116     0.150
     7.311   230.716     0.150
     7.431   233.116     0.150
     7.635   194.916     0.150
     7.927   201.316     0.150
     8.997   282.016     0.150
    10.152   292.016     0.150
    10.152   314.816     0.150
    10.563   270.816     0.150
    11.315   353.216     0.150
     0.360     7.109     0.150
     0.360    11.203     0.150
     0.360     7.305     0.150
     0.360    12.109     0.150
     1.589    28.703     0.150
     1.589    51.109     0.150
     1.589    29.008     0.150
     1.589    30.406     0.150
     1.589    52.203     0.150
     2.300    39.508     0.150
     2.300    42.109     0.150
     2.300    68.109     0.150
     2.300    72.508     0.150
     2.300    67.109     0.150
     2.300    72.609     0.150
     2.776    45.203     0.150
     2.776    49.805     0.150
     2.776    84.805     0.150
     2.776    45.305     0.150
     2.776    49.906     0.150
     2.776    77.906     0.150
     2.776    85.008     0.150
     2.826    51.008     0.150
     2.826    89.703     0.150
     2.980    48.609     0.150
     2.980    53.406     0.150
     2.980    90.609     0.150
     2.980    49.008     0.150
     2.980    53.703     0.150
     2.980    54.008     0.150
     2.980    84.508     0.150
     2.980    92.906     0.150
     3.403    55.305     0.150
     3.403    94.203     0.150
     3.497    56.406     0.150
     3.497    65.008     0.150
     3.497   104.109     0.150
     3.497    63.203     0.150
     3.497   107.703     0.150
     3.514    56.109     0.150
     3.514    63.609     0.150
     3.514    98.805     0.150
     3.514   109.203     0.150
     3.753    59.805     0.150
     3.753    68.203     0.150
     3.753   103.406     0.150
     3.753   117.609     0.150
     3.834    69.305     0.150
     3.834    69.203     0.150
     3.834   121.508     0.150
     4.170    65.508     0.150
     4.170    76.609     0.150
     4.170   110.508     0.150
     4.170   131.203     0.150
     4.522    70.406     0.150
     4.522    80.906     0.150
     4.522   141.008     0.150
     4.522    70.305     0.150
     4.522    81.203     0.150
     4.522   121.609     0.150
     4.522   141.906     0.150
     5.108    78.508     0.150
     5.108    93.609     0.150
     5.108    78.406     0.150
     5.108   160.203     0.150
     5.430    98.008     0.150
     5.430   170.406     0.150
     5.722    86.609     0.150
     5.722   103.109     0.150
     5.722   178.109     0.150
     6.564    98.305     0.150
     6.564   206.703     0.150
     6.948   103.406     0.150
     6.948   219.203     0.150
     7.361   106.406     0.150
     7.361   229.508     0.150
     7.725   114.008     0.150
     7.725   138.305     0.150
     7.725   242.805     0.150
     7.762   244.109     0.150
     7.826   114.305     0.150
     7.826   244.203     0.150
     7.880   113.406     0.150
     7.880   202.703     0.150
     7.880   113.180     0.150
     7.942   249.508     0.150
     8.049   118.109     0.150
     8.049   251.008     0.150
     8.258   259.008     0.150
     8.310   261.203     0.150
     8.432   123.703     0.150
     8.432   214.508     0.150
     8.432   264.508     0.150
     9.322   289.508     0.150
     9.395   292.406     0.150
     9.395   291.008     0.150
    10.032   312.406     0.150
    10.528   328.609     0.150
    10.829   153.906     0.150
    11.009   160.305     0.150
    11.009   343.008     0.150
    11.211   161.609     0.150
    11.211   352.508     0.150
    11.414   165.805     0.150
    11.414   356.406     0.150
    11.492   165.688     0.150
    11.607   167.203     0.150
    11.607   360.305     0.150
    12.881   182.203     0.150
    14.252   201.906     0.150
    14.252   356.703     0.150
    14.913   211.508     0.150
    15.739   385.430     0.150
    18.011   250.109     0.150
    19.297   267.648     0.150
    19.297   267.953     0.150
    19.851   273.305     0.150
    19.851   497.609     0.150
    20.137   278.406     0.150
    20.137   274.805     0.150
    21.154   287.906     0.150
    24.126   318.859     0.150
    24.308   317.109     0.150
    24.308   570.109     0.150
    24.221   318.859     0.150
    24.258   319.305     0.150
    30.391   376.609     0.150
    31.184   381.406     0.150
    35.478   418.008     0.150
    35.478   418.008     0.150
    47.654   519.305     0.150
    54.288   566.453     0.150
    73.051   691.203     0.150
    80.977   735.008     0.150
     0.641    20.570     0.150
     0.641    12.664     0.150
     0.641    21.164     0.150
     1.557    27.969     0.150
     1.557    48.664     0.150
     1.557    27.867     0.150
     1.557    48.867     0.150
     2.034    36.969     0.150
     2.034    64.469     0.150
     2.034    34.570     0.150
     2.034    37.266     0.150
     2.751    49.469     0.150
     2.751    85.766     0.150
     2.841    50.867     0.150
     2.841    87.766     0.150
     2.841    45.867     0.150
     2.841    51.070     0.150
     2.841    88.164     0.150
     2.894    51.469     0.150
     2.894    88.766     0.150
     2.894    45.664     0.150
     2.894    51.766     0.150
     2.894    88.867     0.150
     3.489    55.164     0.150
     3.562    55.570     0.150
     3.562    63.070     0.150
     3.562   110.969     0.150
     3.598    56.070     0.150
     3.598    96.367     0.150
     3.598   108.664     0.150
     3.598    56.664     0.150
     3.598    63.266     0.150
     3.598   110.766     0.150
     3.709    58.164     0.150
     3.709    66.766     0.150
     3.709   100.266     0.150
     3.709   115.867     0.150
     3.774    68.070     0.150
     3.774   118.164     0.150
     3.774    66.867     0.150
     3.774   118.266     0.150
     4.094   107.570     0.150
     4.094    63.266     0.150
     4.094    73.664     0.150
     4.094   127.070     0.150
     4.380    67.070     0.150
     4.380    78.070     0.150
     4.380    79.266     0.150
     4.380   136.766     0.150
     5.037    76.867     0.150
     5.037    91.266     0.150
     5.037    76.969     0.150
     5.037    91.367     0.150
     5.037   157.469     0.150
     5.186    89.469     0.150
     5.186   156.367     0.150
     5.147    90.570     0.150
     5.147   133.664     0.150
     5.147    93.266     0.150
     5.147   161.164     0.150
     5.652    99.969     0.150
     5.652   175.367     0.150
     5.540    98.969     0.150
     5.540    82.766     0.150
     5.540   100.570     0.150
     5.540   172.867     0.150
     6.386    94.469     0.150
     6.386   201.266     0.150
     6.796   100.164     0.150
     6.796   212.969     0.150
     7.534   109.570     0.150
     7.534   236.070     0.150
     7.530   110.070     0.150
     7.530   220.664     0.150
     7.530   234.867     0.150
     7.582   139.367     0.150
     7.582   238.969     0.150
     7.738   241.664     0.150
     7.883   114.867     0.150
     7.883   114.969     0.150
     7.883   246.969     0.150
     8.149   116.773     0.150
     8.149   207.023     0.150
     8.149   140.969     0.150
     8.068   251.570     0.150
     8.122   255.766     0.150
     8.230   119.766     0.150
     8.230   256.969     0.150
     9.149   286.867     0.150
     9.237   286.570     0.150
     9.867   307.164     0.150
    10.821   275.070     0.150
    10.821   337.766     0.150
    10.821   334.469     0.150
    10.953   158.266     0.150
    11.239   160.609     0.150
    11.239   352.945     0.150
    11.271   350.266     0.150
    11.493   356.867     0.150
    12.763   178.469     0.150
    12.763   318.469     0.150
    16.083   231.367     0.150
    16.083   522.469     0.150
    16.083   734.469     0.150
    16.083   736.570     0.150
    18.231   249.867     0.150
    19.282   266.625     0.150
    19.870   272.766     0.150
    24.092   316.289     0.150
    24.092   317.109     0.150
    24.163   318.539     0.150
    24.187   317.109     0.150
    27.561   347.969     0.150
    27.604   347.969     0.150
    32.826   395.484     0.150
    54.587   567.406     0.150
    77.089   711.867     0.150
     0.369     7.504     0.150
     0.369    12.904     0.150
     0.848    15.804     0.150
     0.848    27.604     0.150
     2.291    39.604     0.150
     2.291    42.404     0.150
     2.291    72.504     0.150
     2.785    45.004     0.150
     2.785    50.004     0.150
     2.785    76.804     0.150
     2.785    84.804     0.150
     3.508    55.304     0.150
     3.508    64.104     0.150
     3.508    94.904     0.150
     3.508   109.004     0.150
     3.746    68.904     0.150
     3.746   104.504     0.150
     3.746   117.004     0.150
     4.174    65.704     0.150
     4.174    75.504     0.150
     4.174   129.504     0.150
     4.524    70.404     0.150
     4.524    81.604     0.150
     4.524   140.704     0.150
     5.113   159.604     0.150
     5.231    78.404     0.150
     5.231    93.904     0.150
     5.231   135.604     0.150
     5.231   160.304     0.150
     5.427   170.204     0.150
     5.723    85.604     0.150
     5.723   104.204     0.150
     5.723   148.504     0.150
     5.726   102.504     0.150
     5.726   177.304     0.150
     0.628    12.496     0.150
     0.628    21.395     0.150
     0.628    12.297     0.150
     2.847    46.297     0.150
     2.847    51.598     0.150
     2.847    80.695     0.150
     2.847    88.496     0.150
     2.847    51.098     0.150
     2.883    46.598     0.150
     2.883    51.895     0.150
     2.883    88.598     0.150
     2.883    46.895     0.150
     2.883    50.996     0.150
     2.883    88.797     0.150
     3.116    50.297     0.150
     3.116    56.195     0.150
     3.116    86.797     0.150
     3.116    93.797     0.150
     3.116    50.598     0.150
     3.116    83.895     0.150
     3.116    94.195     0.150
     3.257    51.996     0.150
     3.257    56.996     0.150
     3.257    59.195     0.150
     3.257    87.996     0.150
     3.257    99.598     0.150
     3.329    59.598     0.150
     3.329   104.996     0.150
     3.580   111.797     0.150
     3.580    65.297     0.150
     3.580   112.297     0.150
     3.710    59.195     0.150
     3.710    66.996     0.150
     3.710   100.297     0.150
     3.710   102.797     0.150
     3.710   114.996     0.150
     4.290   135.996     0.150
     4.648    83.395     0.150
     4.648   145.098     0.150
     5.107    94.598     0.150
     5.107    92.297     0.150
     5.107   159.797     0.150
     5.568   173.996     0.150
     6.362   200.496     0.150
     8.580   252.098     0.150
     8.580   268.195     0.150
     8.657   270.598     0.150
     9.988   253.297     0.150
     9.988   309.695     0.150
    10.636   329.797     0.150
    11.104   344.797     0.150
    11.942   374.598     0.150
     0.504     9.535     0.150
     0.504     9.635     0.150
     0.504    16.435     0.150
     0.504    14.935     0.150
     1.239    23.935     0.150
     1.239    25.635     0.150
     1.239    40.635     0.150
     2.103    38.535     0.150
     2.103    66.135     0.150
     2.103    36.835     0.150
     2.103    38.435     0.150
     2.094    38.535     0.150
     2.635    83.935     0.150
     2.635    83.635     0.150
     2.682    49.935     0.150
     2.682    84.835     0.150
     2.682    45.335     0.150
     2.682    49.735     0.150
     2.952    91.435     0.150
     2.952    48.835     0.150
     2.952    92.435     0.150
     3.274    92.735     0.150
     3.274   102.935     0.150
     3.274   103.035     0.150
     3.894    62.635     0.150
     3.894    72.035     0.150
     3.894   121.335     0.150
     3.894    63.935     0.150
     3.894    72.135     0.150
     3.894   122.335     0.150
     4.497    82.135     0.150
     4.497   140.535     0.150
     4.511    81.635     0.150
     4.511   141.635     0.150
     4.704    72.735     0.150
     4.704   125.635     0.150
     4.704   146.335     0.150
     4.731    87.535     0.150
     4.731   147.435     0.150
     4.731    86.935     0.150
     4.731   146.435     0.150
     5.701    87.135     0.150
     6.270   113.435     0.150
     6.697   209.335     0.150
     6.808   211.935     0.150
     6.946   104.735     0.150
     6.946   181.735     0.150
     6.946   217.435     0.150
     8.085   252.435     0.150
     8.150   255.235     0.150
     8.791   129.435     0.150
     8.791   275.135     0.150
     9.280   290.435     0.150
    10.363   321.435     0.150
     0.469     9.180     0.150
     0.469    15.082     0.150
     0.469     9.281     0.150
     0.469    14.879     0.150
     0.974    18.281     0.150
     0.974    30.980     0.150
     1.521    47.980     0.150
     2.198    41.379     0.150
     2.198    70.781     0.150
     2.786    44.879     0.150
     2.786    49.879     0.150
     2.786    79.082     0.150
     2.786    85.180     0.150
     2.743    51.281     0.150
     2.743    86.582     0.150
     2.743    45.879     0.150
     2.743    50.379     0.150
     2.743    86.281     0.150
     2.871    52.379     0.150
     2.871    90.582     0.150
     2.871    49.180     0.150
     2.871    52.680     0.150
     2.871    90.082     0.150
     3.584    59.480     0.150
     3.584   105.082     0.150
     3.584    64.879     0.150
     3.584   111.781     0.150
     3.578    57.980     0.150
     3.578    65.781     0.150
     3.578   111.980     0.150
     3.758    68.582     0.150
     3.758   119.680     0.150
     4.087    64.980     0.150
     4.087    74.680     0.150
     4.087   127.082     0.150
     4.412    69.582     0.150
     4.412    81.281     0.150
     4.412    80.379     0.150
     4.412   138.180     0.150
     4.412   137.180     0.150
     5.028    79.781     0.150
     5.028   159.180     0.150
     5.028    92.281     0.150
     5.028   157.379     0.150
     5.277    93.582     0.150
     5.277    97.879     0.150
     5.277   154.781     0.150
     5.277   166.980     0.150
     5.598    85.781     0.150
     5.598    86.281     0.150
     5.598   102.180     0.150
     5.598   101.379     0.150
     6.442   202.680     0.150
     6.835   214.082     0.150
     7.672   239.680     0.150
     8.030   141.781     0.150
     7.931   247.180     0.150
     8.132   255.480     0.150
     8.302   261.980     0.150
    10.417   325.180     0.150
    11.510   358.480     0.150
     0.340     6.762     0.150
     0.340    10.961     0.150
     0.340     6.863     0.150
     0.340    11.461     0.150
     1.666    30.062     0.150
     1.666    52.062     0.150
     1.666    32.062     0.150
     1.666    52.363     0.150
     1.666    54.461     0.150
     2.348    40.160     0.150
     2.348    43.262     0.150
     2.348    69.262     0.150
     2.348    73.762     0.150
     2.348    40.660     0.150
     2.805    46.160     0.150
     2.805    50.762     0.150
     2.805    85.660     0.150
     2.805    46.262     0.150
     2.805    50.160     0.150
     2.805    79.762     0.150
     2.805    86.062     0.150
     3.417   100.660     0.150
     3.417    62.363     0.150
     3.417    99.363     0.150
     3.447    61.961     0.150
     3.447   106.762     0.150
     3.912    71.363     0.150
     3.912   122.062     0.150
     3.912   121.961     0.150
     4.251    65.660     0.150
     4.251    76.160     0.150
     4.251   113.363     0.150
     4.251    67.062     0.150
     4.251    76.461     0.150
     4.251   132.461     0.150
     4.615    71.461     0.150
     4.615    82.961     0.150
     4.615   124.863     0.150
     4.615   143.863     0.150
     5.187    80.863     0.150
     5.187    95.961     0.150
     5.187   139.363     0.150
     5.187    93.762     0.150
     5.534   172.961     0.150
     5.821    88.262     0.150
     5.821   105.562     0.150
     5.821    88.562     0.150
     5.821   105.262     0.150
     5.821   181.863     0.150
     7.042   104.762     0.150
     7.042   105.863     0.150
     7.042   219.762     0.150
     7.430   231.660     0.150
     7.861   246.961     0.150
     7.929   248.863     0.150
     8.044   251.863     0.150
     8.145   236.961     0.150
     8.145   254.863     0.150
     8.409   263.262     0.150
    10.129   314.961     0.150
    10.622   331.961     0.150
    11.109   346.863     0.150
    11.506   356.660     0.150
    11.694   364.262     0.150
     0.324     6.461     0.150
     0.324    10.961     0.150
     0.794    15.160     0.150
     0.794    25.859     0.150
     1.626    29.762     0.150
     1.626    51.160     0.150
     1.626    31.660     0.150
     1.626    51.859     0.150
     2.349    39.559     0.150
     2.349    42.859     0.150
     2.349    69.160     0.150
     2.349    73.762     0.150
     2.349    40.059     0.150
     2.349    42.961     0.150
     2.349    74.160     0.150
     2.776    45.461     0.150
     2.776    49.262     0.150
     2.776    84.961     0.150
     2.776    49.859     0.150
     2.776    53.961     0.150
     2.776    79.262     0.150
     2.776    85.559     0.150
     3.456    56.660     0.150
     3.456    63.559     0.150
     3.456   106.059     0.150
     3.456    57.262     0.150
     3.456    62.059     0.150
     3.456   107.859     0.150
     3.485    55.660     0.150
     3.485    61.660     0.150
     3.485    96.961     0.150
     3.485   106.359     0.150
     3.744   103.859     0.150
     3.744   115.961     0.150
     3.872    72.160     0.150
     3.872   122.262     0.150
     3.872    69.461     0.150
     3.872   120.359     0.150
     4.211    74.961     0.150
     4.211   112.461     0.150
     4.211    66.859     0.150
     4.211    76.359     0.150
     4.211   132.059     0.150
     4.574    82.762     0.150
     4.574   124.160     0.150
     4.574   143.762     0.150
     5.148    79.461     0.150
     5.148    94.359     0.150
     5.502   172.762     0.150
     5.781    87.660     0.150
     5.781   105.461     0.150
     5.781   105.160     0.150
     5.781   181.461     0.150
     7.001   104.359     0.150
     7.001   104.859     0.150
     7.001   127.961     0.150
     7.001   219.059     0.150
     7.421   232.961     0.150
     7.821   233.160     0.150
     7.821   246.859     0.150
     7.898   115.660     0.150
     7.898   117.859     0.150
     7.898   144.961     0.150
     7.898   248.762     0.150
     8.004   251.160     0.150
     8.105   118.762     0.150
     8.105   254.160     0.150
    10.088   313.660     0.150
    10.581   329.160     0.150
    11.069   345.559     0.150
    11.466   358.660     0.150
    11.654   360.461     0.150
     0.327     6.541     0.150
     0.327    11.041     0.150
     0.796    15.141     0.150
     1.625    29.740     0.150
     1.625    51.840     0.150
     1.625    32.041     0.150
     1.625    52.541     0.150
     2.344    40.141     0.150
     2.344    43.141     0.150
     2.344    69.141     0.150
     2.344    73.941     0.150
     2.344    74.541     0.150
     2.778    51.541     0.150
     2.778    79.840     0.150
     2.778    85.441     0.150
     2.866    89.641     0.150
     2.866    52.541     0.150
     2.866    89.840     0.150
     3.458    57.441     0.150
     3.458    62.541     0.150
     3.458   107.240     0.150
     3.458    56.541     0.150
     3.458   107.441     0.150
     3.485    55.840     0.150
     3.485    61.041     0.150
     3.485   106.441     0.150
     3.743    67.240     0.150
     3.743   103.740     0.150
     3.743   116.641     0.150
     3.871    72.340     0.150
     3.871   123.441     0.150
     3.871    70.941     0.150
     3.871   122.541     0.150
     4.209    65.340     0.150
     4.209    75.641     0.150
     4.209   112.740     0.150
     4.209    66.441     0.150
     4.209    75.941     0.150
     4.209   132.340     0.150
     4.572    81.340     0.150
     4.572   122.340     0.150
     4.572   142.541     0.150
     4.572    71.141     0.150
     4.572    83.740     0.150
     4.572   143.840     0.150
     5.146    81.141     0.150
     5.146    94.641     0.150
     5.146    80.041     0.150
     5.146    93.740     0.150
     5.146   161.041     0.150
     5.778    87.340     0.150
     5.778   104.941     0.150
     5.778    87.441     0.150
     5.778   105.141     0.150
     5.778   180.941     0.150
     6.620    99.340     0.150
     6.999   104.141     0.150
     6.999   105.041     0.150
     6.999   203.141     0.150
     6.999   220.941     0.150
     7.818   245.340     0.150
     7.893   115.240     0.150
     7.893   247.141     0.150
     8.001   251.740     0.150
     8.102   254.840     0.150
    10.085   314.941     0.150
    10.578   331.240     0.150
    11.065   343.740     0.150
    11.651   360.441     0.150
     0.472     9.219     0.150
     0.472    15.219     0.150
     1.010    19.125     0.150
     1.010    33.023     0.150
     1.486    27.125     0.150
     1.486    46.719     0.150
     1.486    28.719     0.150
     1.486    49.820     0.150
     2.204    38.820     0.150
     2.204    40.422     0.150
     2.204    64.422     0.150
     2.204    69.219     0.150
     2.760    44.820     0.150
     2.760    49.523     0.150
     2.760    78.023     0.150
     2.760    85.023     0.150
     2.760    49.820     0.150
     2.760    52.219     0.150
     2.760    85.219     0.150
     3.614    57.719     0.150
     3.614    64.219     0.150
     3.614   111.625     0.150
     3.621    58.523     0.150
     3.621    98.922     0.150
     3.621    58.125     0.150
     3.621    65.422     0.150
     3.621   112.523     0.150
     3.722    68.320     0.150
     3.722   117.719     0.150
     3.722    68.023     0.150
     3.722   116.523     0.150
     3.806    60.820     0.150
     3.806    68.523     0.150
     3.806   118.023     0.150
     4.051    72.719     0.150
     4.051   109.625     0.150
     4.051   125.523     0.150
     4.051    64.219     0.150
     4.051    73.023     0.150
     4.051   109.422     0.150
     4.051   126.023     0.150
     4.328    78.625     0.150
     4.328   135.023     0.150
     4.375    68.625     0.150
     4.375    80.820     0.150
     4.375   136.719     0.150
     4.991    77.320     0.150
     4.991    92.023     0.150
     4.991   133.320     0.150
     4.991   156.625     0.150
     5.288   134.422     0.150
     5.288   161.719     0.150
     5.249   163.625     0.150
     5.249   167.023     0.150
     5.562    84.820     0.150
     5.562   101.023     0.150
     5.562   146.922     0.150
     5.562   173.922     0.150
     5.766   178.719     0.150
     6.405    96.125     0.150
     6.405   166.922     0.150
     6.405   201.219     0.150
     6.798   101.719     0.150
     6.798   177.422     0.150
     6.798   211.125     0.150
     7.646   113.523     0.150
     7.646   238.719     0.150
     9.243   290.023     0.150
    10.380   322.125     0.150
     0.463     9.090     0.150
     0.463    15.090     0.150
     1.004    18.990     0.150
     1.004    32.691     0.150
     2.212    38.291     0.150
     2.212    40.291     0.150
     2.212    69.191     0.150
     2.212    38.490     0.150
     2.212    68.990     0.150
     2.757    44.590     0.150
     2.757    49.490     0.150
     2.757    84.990     0.150
     2.757    45.090     0.150
     2.757    49.691     0.150
     3.612    57.391     0.150
     3.612    64.090     0.150
     3.612   111.990     0.150
     3.618   112.090     0.150
     3.618    58.391     0.150
     3.618    65.590     0.150
     3.618   112.590     0.150
     3.724    67.990     0.150
     3.724   117.791     0.150
     3.724   100.990     0.150
     3.724   116.791     0.150
     4.053    62.590     0.150
     4.053    72.590     0.150
     4.053   108.990     0.150
     4.053    64.191     0.150
     4.053    73.090     0.150
     4.053   125.590     0.150
     4.323   135.490     0.150
     4.380    79.191     0.150
     4.380   117.891     0.150
     4.380   135.590     0.150
     4.380    68.791     0.150
     4.380    81.990     0.150
     4.380   136.191     0.150
     4.994    76.891     0.150
     4.994    91.891     0.150
     4.994   132.391     0.150
     4.994   155.490     0.150
     5.289    77.391     0.150
     5.289    92.891     0.150
     5.567   101.990     0.150
     5.567    84.691     0.150
     5.567   101.391     0.150
     5.567   173.590     0.150
     5.768   178.990     0.150
     6.411   166.791     0.150
     6.411   201.191     0.150
     6.803   101.590     0.150
     6.803   177.291     0.150
     6.803   213.191     0.150
     7.608   238.490     0.150
     7.654   112.791     0.150
     7.654   238.490     0.150
     7.900   114.990     0.150
     7.900   245.590     0.150
     9.884   306.791     0.150
     0.540    10.582     0.150
     0.540    17.283     0.150
     1.138    21.582     0.150
     1.138    24.383     0.150
     1.138    36.182     0.150
     1.384    25.883     0.150
     1.384    44.082     0.150
     1.939    60.783     0.150
     2.190    41.082     0.150
     2.190    70.783     0.150
     2.708    44.383     0.150
     2.708    49.283     0.150
     2.708    77.082     0.150
     2.708    83.783     0.150
     2.710    45.682     0.150
     2.710    50.082     0.150
     2.710    78.283     0.150
     2.710    85.682     0.150
     3.938   107.482     0.150
     3.938   122.883     0.150
     4.251   116.783     0.150
     4.251   133.682     0.150
     5.369   164.383     0.150
     0.399     7.836     0.150
     0.399    12.641     0.150
     0.908    17.438     0.150
     0.908    28.938     0.150
     1.748    32.539     0.150
     1.748    55.641     0.150
     2.260    39.734     0.150
     2.260    41.438     0.150
     2.260    66.641     0.150
     2.260    71.836     0.150
     2.772    45.938     0.150
     2.772    49.938     0.150
     2.772    77.641     0.150
     2.772    85.641     0.150
     2.926    49.234     0.150
     2.926    53.836     0.150
     2.926    92.641     0.150
     3.541    57.438     0.150
     3.541    64.234     0.150
     3.541    98.039     0.150
     3.541   108.641     0.150
     3.549    56.938     0.150
     3.549    64.938     0.150
     3.549   109.836     0.150
     3.769    59.539     0.150
     3.769    68.438     0.150
     3.769   101.836     0.150
     3.769   117.039     0.150
     4.269    65.734     0.150
     4.269    76.641     0.150
     4.269   130.641     0.150
     0.592    11.582     0.150
     0.592    18.680     0.150
     1.114    21.180     0.150
     1.114    35.582     0.150
     2.113    37.383     0.150
     2.113    39.383     0.150
     2.113    67.281     0.150
     2.654    48.582     0.150
     2.654    83.480     0.150
     2.755    46.281     0.150
     2.755    50.281     0.150
     2.755    79.180     0.150
     2.755    86.680     0.150
     2.790    45.680     0.150
     2.790    50.281     0.150
     2.790    79.180     0.150
     2.790    85.582     0.150
     3.660    57.883     0.150
     3.660    66.480     0.150
     3.660   113.180     0.150
     3.997    63.180     0.150
     3.997    73.281     0.150
     3.997    73.781     0.150
     3.997   124.180     0.150
     4.295    67.383     0.150
     4.295    79.082     0.150
     4.295   115.781     0.150
     4.295   134.883     0.150
     5.121   160.180     0.150
     5.467    84.082     0.150
     5.467   100.180     0.150
     5.467   143.883     0.150
     5.467   171.281     0.150
     0.694    22.203     0.150
     0.694    13.602     0.150
     0.694    22.500     0.150
     1.412    26.500     0.150
     1.412    28.602     0.150
     1.412    44.402     0.150
     2.216    39.602     0.150
     2.216    69.402     0.150
     2.262    71.703     0.150
     2.262    39.902     0.150
     2.322    73.301     0.150
     2.430    42.301     0.150
     2.430    75.602     0.150
     2.430    76.703     0.150
     2.541    43.602     0.150
     2.541    45.801     0.150
     2.541    78.402     0.150
     2.541    43.500     0.150
     2.541    46.000     0.150
     2.541    78.801     0.150
     3.343    59.801     0.150
     3.343   104.902     0.150
     3.665    65.902     0.150
     3.665   114.500     0.150
     3.991    71.102     0.150
     3.991   111.000     0.150
     3.991   123.500     0.150
     4.018    64.402     0.150
     4.018    71.102     0.150
     4.018   124.000     0.150
     3.971    72.000     0.150
     3.971    62.703     0.150
     3.971    72.102     0.150
     3.971   123.902     0.150
     4.129    74.801     0.150
     4.129   113.703     0.150
     4.129   129.203     0.150
     4.195    76.203     0.150
     4.195   113.801     0.150
     4.195   130.301     0.150
     4.607    70.801     0.150
     4.607    83.602     0.150
     4.607   144.402     0.150
     4.607    84.703     0.150
     4.772   147.203     0.150
     4.917   155.301     0.150
     5.158    78.902     0.150
     5.158    93.602     0.150
     5.602   172.801     0.150
     6.001   189.500     0.150
     6.055   110.902     0.150
     7.199   228.000     0.150
     7.329   108.500     0.150
     7.329   229.902     0.150
     8.761   276.000     0.150
     8.838   272.902     0.150
     9.473   297.602     0.150
    10.445   267.203     0.150
    10.445   328.203     0.150
    10.864   337.902     0.150
     0.722    13.984     0.150
     0.722    23.184     0.150
     2.239    40.484     0.150
     2.239    70.383     0.150
     2.256    39.086     0.150
     2.256    41.785     0.150
     2.256    67.484     0.150
     2.256    39.984     0.150
     2.256    42.086     0.150
     2.256    72.383     0.150
     2.256    71.684     0.150
     2.302    42.586     0.150
     2.302    72.383     0.150
     2.302    42.785     0.150
     2.302    73.285     0.150
     2.405    75.484     0.150
     2.405    76.086     0.150
     2.540    41.883     0.150
     2.540    45.785     0.150
     2.540    78.484     0.150
     2.540    45.984     0.150
     2.540    78.984     0.150
     3.324   105.586     0.150
     3.645    58.285     0.150
     3.645    65.984     0.150
     3.645    99.785     0.150
     3.645   114.184     0.150
     3.645   110.285     0.150
     4.012   110.984     0.150
     4.012   122.484     0.150
     3.946    71.785     0.150
     3.946   123.684     0.150
     3.946    72.285     0.150
     3.946   124.484     0.150
     4.041    64.586     0.150
     4.041   124.684     0.150
     4.199    77.383     0.150
     4.199   132.484     0.150
     4.587    83.984     0.150
     4.587   124.383     0.150
     4.587   144.785     0.150
     4.800    74.383     0.150
     4.800    85.785     0.150
     4.800   147.883     0.150
     4.889    73.984     0.150
     4.889    88.586     0.150
     4.889   129.383     0.150
     4.889   151.383     0.150
     4.889   154.684     0.150
     5.131    92.383     0.150
     5.131   159.984     0.150
     5.131    93.684     0.150
     5.131   162.086     0.150
     5.615    98.785     0.150
     5.615   144.285     0.150
     5.615   172.184     0.150
     5.975   173.684     0.150
     6.368   199.484     0.150
     7.301   107.383     0.150
     7.301   108.586     0.150
     7.349   231.285     0.150
     7.464   234.086     0.150
     7.839   247.184     0.150
     8.734   272.785     0.150
     8.813   273.883     0.150
     9.950   309.484     0.150
    10.418   266.184     0.150
    11.050   342.785     0.150
     0.309     6.379     0.150
     0.309    10.281     0.150
     1.147    21.582     0.150
     1.147    36.582     0.150
     1.257    23.379     0.150
     1.257    40.180     0.150
     2.045    36.980     0.150
     2.045    64.281     0.150
     2.450    43.980     0.150
     2.450    69.781     0.150
     2.450    75.582     0.150
     2.502    41.879     0.150
     2.502    45.980     0.150
     2.502    78.879     0.150
     2.498    42.281     0.150
     2.498    45.480     0.150
     2.498    72.082     0.150
     2.498    79.281     0.150
     2.689    44.680     0.150
     2.689    48.980     0.150
     2.689    84.480     0.150
     3.843    60.582     0.150
     3.843    69.480     0.150
     3.843   106.281     0.150
     3.843   120.082     0.150
     4.227    65.680     0.150
     4.227   115.082     0.150
     4.227   132.582     0.150
     0.370     7.301     0.150
     0.370    11.901     0.150
     0.370    12.001     0.150
     1.546    28.601     0.150
     1.546    28.701     0.150
     1.546    30.201     0.150
     1.546    48.701     0.150
     1.751    32.101     0.150
     1.751    55.701     0.150
     2.288    42.301     0.150
     2.288    72.101     0.150
     2.288    39.701     0.150
     2.288    68.001     0.150
     2.288    72.601     0.150
     2.753    50.501     0.150
     2.753    84.501     0.150
     2.753    45.601     0.150
     2.753    49.801     0.150
     2.753    79.001     0.150
     2.753    84.701     0.150
     2.780    47.601     0.150
     2.780    87.601     0.150
     2.931    52.801     0.150
     2.931    91.401     0.150
     2.931    48.701     0.150
     2.931    53.301     0.150
     2.931    84.201     0.150
     2.931    92.201     0.150
     3.542    59.201     0.150
     3.542    99.101     0.150
     3.542    57.301     0.150
     3.542    64.801     0.150
     3.542    98.101     0.150
     3.542   112.001     0.150
     3.555    56.601     0.150
     3.555    63.801     0.150
     3.555    97.501     0.150
     3.555   109.401     0.150
     3.784    60.101     0.150
     3.784    70.001     0.150
     3.784   104.101     0.150
     3.784   119.901     0.150
     3.790    71.401     0.150
     3.790   120.801     0.150
     4.124    65.601     0.150
     4.124    75.701     0.150
     4.124   129.701     0.150
     4.258    66.501     0.150
     4.258    77.601     0.150
     4.258   115.201     0.150
     4.258   132.301     0.150
     4.287   131.401     0.150
     4.472    70.101     0.150
     4.472    82.601     0.150
     4.472   120.801     0.150
     4.472   139.501     0.150
     5.063    94.801     0.150
     5.063    78.701     0.150
     5.063   158.501     0.150
     5.671    86.001     0.150
     5.671   103.501     0.150
     5.671   177.001     0.150
     5.760    87.001     0.150
     5.760   104.901     0.150
     5.760   151.301     0.150
     5.760   180.901     0.150
     6.514   203.501     0.150
     7.779   243.301     0.150
     7.998   249.001     0.150
     8.380   263.101     0.150
     0.318     6.559     0.150
     0.318    10.355     0.150
     1.148    21.758     0.150
     1.148    36.656     0.150
     2.043    37.457     0.150
     2.043    64.059     0.150
     2.459    40.258     0.150
     2.459    43.855     0.150
     2.459    42.059     0.150
     2.459    44.457     0.150
     2.459    71.559     0.150
     2.459    75.758     0.150
     2.502    45.957     0.150
     2.502    78.355     0.150
     2.502    46.059     0.150
     2.502    79.156     0.150
     2.485    42.355     0.150
     2.485    45.855     0.150
     2.485    79.258     0.150
     2.485    42.457     0.150
     2.485    45.656     0.150
     2.687    49.059     0.150
     2.687    84.656     0.150
     2.687    44.855     0.150
     2.687    84.758     0.150
     3.504    63.957     0.150
     3.504   110.855     0.150
     3.825    60.957     0.150
     3.825    69.656     0.150
     3.825   117.059     0.150
     3.825    62.656     0.150
     3.825    67.758     0.150
     3.852    60.559     0.150
     3.852    68.258     0.150
     3.852   106.559     0.150
     3.852   118.156     0.150
     3.844    60.957     0.150
     3.844    69.656     0.150
     3.844   104.156     0.150
     3.844   117.258     0.150
     3.844    61.156     0.150
     3.844    69.457     0.150
     3.844   119.355     0.150
     4.225    66.156     0.150
     4.225    76.758     0.150
     4.225   132.758     0.150
     4.780    74.656     0.150
     4.780    87.957     0.150
     4.780   149.457     0.150
     4.780    75.059     0.150
     4.780    86.059     0.150
     4.780   149.656     0.150
     5.291   167.656     0.150
     5.452    82.559     0.150
     5.452    99.059     0.150
     5.452   144.559     0.150
     5.452   170.957     0.150
     6.290   162.656     0.150
     6.290   196.656     0.150
     6.654    99.656     0.150
     7.488   233.059     0.150
     7.706   112.758     0.150
     7.706   196.156     0.150
     7.706   242.656     0.150
     7.706   239.656     0.150
     7.764   244.258     0.150
     8.041   250.457     0.150
     8.175   121.957     0.150
     8.175   257.156     0.150
     9.041   280.957     0.150
    10.739   274.855     0.150
    11.292   350.957     0.150
     0.310     6.449     0.150
     0.310    10.250     0.150
     1.151    21.648     0.150
     1.151    36.547     0.150
     1.253    23.250     0.150
     1.253    39.547     0.150
     1.253    39.250     0.150
     2.049    36.250     0.150
     2.049    37.250     0.150
     2.049    64.250     0.150
     2.446    40.148     0.150
     2.446    43.648     0.150
     2.446    74.848     0.150
     2.446    41.148     0.150
     2.446    44.148     0.150
     2.446    70.648     0.150
     2.446    75.348     0.150
     2.500    42.047     0.150
     2.500    46.148     0.150
     2.500    73.348     0.150
     2.500    79.047     0.150
     2.500    42.348     0.150
     2.500    45.750     0.150
     2.500    79.148     0.150
     2.498    42.648     0.150
     2.498    46.047     0.150
     2.498    71.750     0.150
     2.498    78.148     0.150
     2.686    44.750     0.150
     2.686    49.047     0.150
     2.686    84.547     0.150
     3.499    65.348     0.150
     3.499   110.348     0.150
     3.829    69.949     0.150
     3.829   118.648     0.150
     3.829    69.848     0.150
     3.829   118.848     0.150
     3.859    60.348     0.150
     3.859    68.250     0.150
     3.859   103.750     0.150
     3.859   118.047     0.150
     3.840    60.547     0.150
     3.840   105.250     0.150
     3.840    60.848     0.150
     3.840    69.449     0.150
     3.840   120.148     0.150
     3.840    69.848     0.150
     3.840   119.148     0.150
     4.010    62.648     0.150
     4.010    72.949     0.150
     4.010   109.949     0.150
     4.010   125.250     0.150
     4.224    66.148     0.150
     4.224   114.250     0.150
     4.224   131.648     0.150
     4.775    73.648     0.150
     4.775    87.750     0.150
     4.775   149.648     0.150
     6.653    99.547     0.150
     6.653   172.250     0.150
     6.653   206.148     0.150
     7.715   112.148     0.150
     7.715   137.949     0.150
     7.715   112.848     0.150
     7.715   240.750     0.150
     7.715   242.250     0.150
     7.764   242.047     0.150
    10.230   318.047     0.150
     0.316     6.402     0.150
     0.316    10.402     0.150
     0.316     6.504     0.150
     0.316    10.504     0.150
     1.152    21.703     0.150
     1.152    36.504     0.150
     1.253    23.305     0.150
     1.253    40.004     0.150
     1.253    40.305     0.150
     2.048    36.004     0.150
     2.048    37.305     0.150
     2.048    64.004     0.150
     2.450    40.305     0.150
     2.450    43.805     0.150
     2.450    75.105     0.150
     2.450    40.703     0.150
     2.450    44.305     0.150
     2.450    75.305     0.150
     2.498    45.703     0.150
     2.498    78.305     0.150
     2.498    41.703     0.150
     2.498    45.902     0.150
     2.494    42.203     0.150
     2.494    46.004     0.150
     2.494    79.305     0.150
     2.494    45.605     0.150
     2.684    44.805     0.150
     2.684    48.902     0.150
     2.684    84.605     0.150
     2.684    44.703     0.150
     2.684    49.203     0.150
     2.684    84.504     0.150
     3.499    63.605     0.150
     3.499   111.105     0.150
     3.499    63.805     0.150
     3.499    97.203     0.150
     3.499   110.504     0.150
     3.830    61.004     0.150
     3.830   114.703     0.150
     3.830    68.703     0.150
     3.830   103.203     0.150
     3.830   117.402     0.150
     3.858    60.703     0.150
     3.858   118.004     0.150
     3.839    61.605     0.150
     3.839    70.402     0.150
     3.839   105.004     0.150
     3.839   118.305     0.150
     3.839    60.805     0.150
     3.839    69.805     0.150
     3.839   103.402     0.150
     3.839   119.805     0.150
     4.016    63.305     0.150
     4.016    72.902     0.150
     4.016   109.004     0.150
     4.016   125.203     0.150
     4.095    64.402     0.150
     4.095    74.402     0.150
     4.095   110.902     0.150
     4.095   126.605     0.150
     4.222    78.305     0.150
     4.222   130.703     0.150
     4.222    66.305     0.150
     4.222    77.402     0.150
     4.222   114.402     0.150
     4.222   132.105     0.150
     4.471    68.504     0.150
     4.471   119.105     0.150
     4.471   138.105     0.150
     4.775    87.605     0.150
     4.775   147.203     0.150
     4.775    74.805     0.150
     4.775   126.402     0.150
     4.775   149.203     0.150
     5.293   165.902     0.150
     5.450    82.605     0.150
     5.450   100.402     0.150
     5.450   143.504     0.150
     5.450   170.605     0.150
     5.450   170.305     0.150
     6.288    95.703     0.150
     6.288   161.402     0.150
     6.288   195.402     0.150
     6.651   119.605     0.150
     6.651    99.504     0.150
     6.651   120.902     0.150
     6.651   171.504     0.150
     6.651   207.402     0.150
     7.486   233.203     0.150
     7.761   115.305     0.150
     7.761   199.203     0.150
     7.761   243.305     0.150
     8.067   143.004     0.150
     8.067   204.203     0.150
     8.040   251.605     0.150
     8.174   207.902     0.150
     8.174   254.703     0.150
     9.101   283.305     0.150
     9.743   303.004     0.150
     9.743   304.402     0.150
    10.228   318.004     0.150
    11.109   345.402     0.150
     0.351     7.090     0.150
     0.351    11.691     0.150
     0.881    16.791     0.150
     0.881    28.291     0.150
     1.557    28.590     0.150
     1.557    29.990     0.150
     1.557    49.490     0.150
     1.740    31.891     0.150
     1.740    55.090     0.150
     2.307    39.391     0.150
     2.307    41.990     0.150
     2.307    67.391     0.150
     2.307    72.391     0.150
     2.750    44.791     0.150
     2.750    49.590     0.150
     2.750    76.590     0.150
     2.750    84.691     0.150
     2.794    51.490     0.150
     2.794    77.990     0.150
     2.794    87.791     0.150
     2.948    48.590     0.150
     2.948    53.691     0.150
     2.948    82.490     0.150
     2.948    92.090     0.150
     4.137    74.990     0.150
     4.137   128.990     0.150
     4.490    69.791     0.150
     4.490    82.490     0.150
     4.490   120.090     0.150
     4.490   140.791     0.150
     5.075    76.891     0.150
     5.075   158.090     0.150
     5.267   136.791     0.150
     5.267   162.291     0.150
     5.691   177.691     0.150
     0.378     7.436     0.150
     0.378    12.035     0.150
     0.899    17.135     0.150
     0.899    28.535     0.150
     1.550    29.035     0.150
     1.550    49.336     0.150
     1.748    32.336     0.150
     1.748    55.635     0.150
     2.280    40.035     0.150
     2.280    42.336     0.150
     2.280    72.135     0.150
     2.760    47.035     0.150
     2.760    50.035     0.150
     2.760    77.635     0.150
     2.760    84.734     0.150
     2.784    46.936     0.150
     2.784    78.436     0.150
     2.784    88.035     0.150
     2.932    53.836     0.150
     2.932    83.734     0.150
     2.932    92.135     0.150
     4.128   128.836     0.150
     4.473    69.436     0.150
     4.473    81.035     0.150
     4.473   120.836     0.150
     4.473   140.436     0.150
     5.262   162.035     0.150
     0.525    10.336     0.150
     0.525    16.934     0.150
     0.525    16.434     0.150
     1.011    19.035     0.150
     1.011    23.934     0.150
     1.011    32.336     0.150
     1.011    18.934     0.150
     1.398    26.434     0.150
     1.398    44.336     0.150
     1.398    48.137     0.150
     2.287    40.637     0.150
     2.287    41.535     0.150
     2.287    71.637     0.150
     2.284    41.434     0.150
     2.284    68.234     0.150
     2.284    71.637     0.150
     2.284    40.434     0.150
     2.284    70.535     0.150
     2.441    41.934     0.150
     2.441    44.934     0.150
     2.441    77.336     0.150
     2.561    43.637     0.150
     2.561    47.035     0.150
     2.561    73.637     0.150
     2.561    81.336     0.150
     2.561    43.535     0.150
     2.561    80.035     0.150
     3.256    59.336     0.150
     3.256   104.434     0.150
     3.595    57.035     0.150
     3.595    65.035     0.150
     3.595   111.637     0.150
     3.595    66.934     0.150
     3.595    99.535     0.150
     3.595   110.734     0.150
     3.978    63.137     0.150
     3.978    73.137     0.150
     3.978   124.934     0.150
     4.072    74.234     0.150
     4.072   115.035     0.150
     4.072   127.035     0.150
     4.072   124.234     0.150
     4.092    64.637     0.150
     4.092    73.637     0.150
     4.092   113.234     0.150
     4.092   125.734     0.150
     4.092   129.734     0.150
     4.531    83.934     0.150
     4.531   142.336     0.150
     4.531    71.934     0.150
     4.531   141.934     0.150
     5.120   161.836     0.150
     5.213    79.836     0.150
     5.213    95.535     0.150
     5.213   137.836     0.150
     5.213   163.836     0.150
     6.408    97.637     0.150
     6.408   167.535     0.150
     6.408   200.836     0.150
     7.456   234.137     0.150
     7.520   234.934     0.150
     7.544   237.637     0.150
     8.799   276.336     0.150
     9.984   311.535     0.150
    11.042   344.734     0.150
     0.472     9.512     0.150
     0.472    15.712     0.150
     0.472     9.411     0.150
     0.472    15.611     0.150
     1.057    19.812     0.150
     1.057    33.712     0.150
     1.434    26.212     0.150
     1.434    45.111     0.150
     1.434    26.111     0.150
     1.434    44.512     0.150
     1.875    33.812     0.150
     1.875    59.312     0.150
     2.223    40.312     0.150
     2.223    69.611     0.150
     2.223    37.712     0.150
     2.654    48.411     0.150
     2.654    83.212     0.150
     2.654    48.212     0.150
     2.654    83.012     0.150
     2.718    42.312     0.150
     2.718    49.111     0.150
     2.718    84.312     0.150
     2.718    48.712     0.150
     2.718    83.812     0.150
     2.783    45.911     0.150
     2.783    50.512     0.150
     2.783    86.911     0.150
     2.783    50.012     0.150
     2.783    83.812     0.150
     3.666    57.512     0.150
     3.666    64.712     0.150
     3.666    66.512     0.150
     3.666   101.111     0.150
     3.666   112.712     0.150
     3.673    67.111     0.150
     3.673   112.212     0.150
     3.669   116.312     0.150
     3.855    60.512     0.150
     3.855   105.712     0.150
     3.855   119.312     0.150
     3.998    62.911     0.150
     3.998    71.611     0.150
     3.998   123.411     0.150
     3.998    71.111     0.150
     3.998   107.911     0.150
     3.998   123.111     0.150
     4.295    77.111     0.150
     4.295   133.712     0.150
     4.324    67.111     0.150
     4.324    78.012     0.150
     4.324   136.111     0.150
     4.324    67.411     0.150
     4.324    78.611     0.150
     4.324   117.411     0.150
     4.324   134.812     0.150
     5.216   164.411     0.150
     5.513   100.411     0.150
     5.513   171.911     0.150
     5.513    83.212     0.150
     5.513    98.611     0.150
     6.748   172.411     0.150
     6.748   208.812     0.150
     9.829   307.111     0.150
    10.330   320.512     0.150
    10.800   338.611     0.150
    11.217   351.012     0.150
    11.421   356.111     0.150
     0.460    15.750     0.150
     0.915    17.750     0.150
     0.915    29.352     0.150
     0.915    17.852     0.150
     1.065    20.445     0.150
     1.065    35.352     0.150
     2.064    35.648     0.150
     2.064    38.750     0.150
     2.064    66.945     0.150
     2.064    36.148     0.150
     2.064    38.648     0.150
     2.064    66.648     0.150
     2.240    37.945     0.150
     2.240    40.945     0.150
     2.240    40.648     0.150
     2.240    67.648     0.150
     2.859    46.148     0.150
     2.859    50.945     0.150
     2.859    88.852     0.150
     2.866    46.750     0.150
     2.866    52.352     0.150
     2.866    89.148     0.150
     2.866    47.945     0.150
     2.866    52.148     0.150
     3.112    50.445     0.150
     3.112    56.047     0.150
     3.112    86.148     0.150
     3.112    98.547     0.150
     3.401    54.047     0.150
     3.401    60.648     0.150
     3.401    92.352     0.150
     3.401   104.648     0.150
     3.401   103.148     0.150
     3.465    54.445     0.150
     3.465   109.250     0.150
     3.465    62.648     0.150
     3.465   108.352     0.150
     3.576    56.445     0.150
     3.576   111.648     0.150
     3.576    64.648     0.150
     3.576   108.445     0.150
     4.479   139.148     0.150
     4.479    80.547     0.150
     4.479   138.547     0.150
     4.809    73.547     0.150
     4.809    86.750     0.150
     4.809   150.750     0.150
     4.809    72.945     0.150
     4.809    86.547     0.150
     4.809   128.547     0.150
     4.809   148.945     0.150
     4.844    88.047     0.150
     4.844   150.148     0.150
     5.115    78.047     0.150
     5.115    93.445     0.150
     5.115   160.852     0.150
     5.115    77.852     0.150
     5.115    92.352     0.150
     5.115   135.750     0.150
     5.750    87.047     0.150
     5.750   104.250     0.150
     5.750   179.750     0.150
     5.754   180.547     0.150
     6.270   194.945     0.150
     6.270   113.047     0.150
     7.531   137.852     0.150
     7.531   236.648     0.150
     8.103   120.547     0.150
     8.103   253.445     0.150
     8.103   117.352     0.150
     8.311   260.148     0.150
     8.456   266.047     0.150
     8.617   270.148     0.150
     8.848   274.852     0.150
     8.950   261.445     0.150
     8.950   279.047     0.150
     9.881   248.945     0.150
    11.115   347.945     0.150
    11.547   360.352     0.150
    12.007   373.445     0.150
    12.224   382.945     0.150
     0.775    15.148     0.150
     0.775    25.047     0.150
     0.775    15.047     0.150
     1.151    22.344     0.150
     1.151    38.242     0.150
     2.242    39.445     0.150
     2.242    41.344     0.150
     2.242    70.242     0.150
     2.242    41.242     0.150
     2.242    68.945     0.150
     2.552    43.344     0.150
     2.552    47.047     0.150
     2.552    81.742     0.150
     2.552    46.945     0.150
     2.552    74.344     0.150
     2.552    80.445     0.150
     2.864    48.742     0.150
     2.864    88.148     0.150
     2.959    49.148     0.150
     2.959    93.148     0.150
     3.188    52.242     0.150
     3.188    96.844     0.150
     3.188    51.047     0.150
     3.188    57.242     0.150
     3.188    87.945     0.150
     3.188    96.648     0.150
     3.365    55.742     0.150
     3.365    61.742     0.150
     3.365   105.242     0.150
     3.493    56.445     0.150
     3.493   109.648     0.150
     3.493    63.344     0.150
     4.481    81.547     0.150
     4.481   139.844     0.150
     4.481   140.148     0.150
     4.513   136.148     0.150
     4.829    75.242     0.150
     4.829    87.547     0.150
     4.829   151.148     0.150
     4.829    86.844     0.150
     4.829   127.844     0.150
     5.227    80.547     0.150
     5.227    94.445     0.150
     5.227   140.445     0.150
     5.227   162.945     0.150
     5.227    80.742     0.150
     5.227    94.648     0.150
     5.227   161.945     0.150
     5.760    90.445     0.150
     5.760   103.945     0.150
     5.760   178.547     0.150
     6.105   111.844     0.150
     6.105   193.047     0.150
     6.442    97.344     0.150
     6.442   203.344     0.150
     6.442   118.047     0.150
     7.186   184.555     0.150
     7.186   219.633     0.150
     7.186   127.742     0.150
     7.186   182.844     0.150
     7.186   219.242     0.150
     7.656   115.047     0.150
     7.656   238.547     0.150
     7.656   114.242     0.150
     7.714   200.445     0.150
     7.714   242.242     0.150
     7.714   113.742     0.150
     8.481   124.445     0.150
     8.481   251.648     0.150
     8.481   265.148     0.150
     8.763   163.844     0.150
     8.763   272.648     0.150
     9.031   284.742     0.150
    10.039   253.742     0.150
    10.603   154.398     0.150
    10.746   336.742     0.150
    10.746   155.148     0.150
    11.234   351.742     0.150
    11.730   367.445     0.150
    11.916   172.547     0.150
    12.115   374.445     0.150
    12.201   384.469     0.150
    12.288   383.648     0.150
    12.288   179.344     0.150
    14.804   209.742     0.150
    17.288   243.219     0.150
    17.288   540.344     0.150
    19.863   273.695     0.150
    24.716   325.242     0.150
    24.813   325.273     0.150
    44.175   490.273     0.150
    49.725   535.062     0.150
    53.662   564.391     0.150
    81.208   738.188     0.150
     0.542    10.688     0.150
     0.542    17.484     0.150
     1.163    21.984     0.150
     1.163    37.188     0.150
     1.355    25.188     0.150
     1.355    42.688     0.150
     1.355    25.086     0.150
     1.967    35.789     0.150
     1.967    62.383     0.150
     2.205    38.383     0.150
     2.205    40.984     0.150
     2.205    70.383     0.150
     2.205    38.484     0.150
     2.205    70.586     0.150
     2.565    47.383     0.150
     2.565    80.984     0.150
     2.565    46.883     0.150
     2.565    80.188     0.150
     2.683    43.883     0.150
     2.683    48.789     0.150
     2.683    82.789     0.150
     2.683    43.484     0.150
     2.683    48.688     0.150
     2.683    82.188     0.150
     2.683    45.289     0.150
     2.683    49.086     0.150
     2.683    84.188     0.150
     3.583    65.086     0.150
     3.583    98.383     0.150
     3.583   112.688     0.150
     3.751    59.188     0.150
     3.751   101.688     0.150
     3.751   116.086     0.150
     3.768    68.484     0.150
     3.768   102.688     0.150
     3.768   116.984     0.150
     3.909    61.789     0.150
     3.909    70.383     0.150
     3.909   120.883     0.150
     3.918    61.984     0.150
     3.918   106.688     0.150
     3.918   122.484     0.150
     4.224    66.984     0.150
     4.224    77.586     0.150
     4.224   132.484     0.150
     4.224    78.883     0.150
     4.224   116.688     0.150
     4.224   132.586     0.150
     4.850    74.586     0.150
     4.850    89.383     0.150
     4.850   130.188     0.150
     4.850   151.586     0.150
     5.115    77.586     0.150
     5.115   136.883     0.150
     5.115   161.086     0.150
     5.408    82.383     0.150
     5.408    97.984     0.150
     5.408   169.586     0.150
     5.408    98.586     0.150
     6.646    98.586     0.150
     6.646   170.789     0.150
     6.646   206.086     0.150
     7.517   110.883     0.150
     8.113   253.586     0.150
     0.632    12.270     0.150
     0.632    20.672     0.150
     1.168    21.672     0.150
     1.168    38.172     0.150
     1.168    40.871     0.150
     1.168    21.570     0.150
     1.168    37.871     0.150
     1.350    25.070     0.150
     1.350    26.969     0.150
     1.350    43.070     0.150
     2.275    41.570     0.150
     2.275    72.172     0.150
     2.275    38.969     0.150
     2.275    41.969     0.150
     2.275    72.469     0.150
     2.369    43.570     0.150
     2.369    74.871     0.150
     2.369    74.270     0.150
     2.487    42.570     0.150
     2.487    45.270     0.150
     2.487    78.270     0.150
     2.547    46.070     0.150
     2.547    79.070     0.150
     2.547    46.172     0.150
     3.389    61.371     0.150
     3.389   107.672     0.150
     3.389    62.270     0.150
     3.389   108.270     0.150
     3.713    59.270     0.150
     3.713    66.672     0.150
     3.713    99.969     0.150
     3.713   115.270     0.150
     3.713    66.570     0.150
     3.713   114.672     0.150
     3.945    61.570     0.150
     3.945    71.371     0.150
     3.945   107.672     0.150
     3.945   122.371     0.150
     3.964   110.070     0.150
     3.964   121.871     0.150
     4.029    63.371     0.150
     4.029    72.672     0.150
     4.029   126.371     0.150
     4.096    72.871     0.150
     4.096   111.570     0.150
     4.096   127.770     0.150
     4.187    75.871     0.150
     4.187   129.469     0.150
     4.655    70.672     0.150
     4.655    83.770     0.150
     4.655   146.570     0.150
     4.981   158.371     0.150
     5.220    94.969     0.150
     5.220   137.070     0.150
     5.220   163.270     0.150
     6.452    96.469     0.150
     6.452   117.469     0.150
     6.452   200.969     0.150
     7.392   109.172     0.150
     7.392   231.270     0.150
     7.440   136.070     0.150
     7.440   233.770     0.150
     7.550   234.570     0.150
     7.930   247.871     0.150
     9.534   295.270     0.150
    10.034   314.969     0.150
    10.507   327.172     0.150
    10.922   339.969     0.150
    11.128   345.270     0.150
     0.328     6.773     0.150
     0.328    10.773     0.150
     1.166    21.977     0.150
     1.166    36.977     0.150
     1.240    23.078     0.150
     1.240    25.375     0.150
     1.240    38.578     0.150
     1.240    42.875     0.150
     2.060    37.375     0.150
     2.060    64.273     0.150
     2.443    40.477     0.150
     2.443    43.875     0.150
     2.443    75.078     0.150
     2.485    45.477     0.150
     2.485    70.273     0.150
     2.485    78.375     0.150
     2.494    42.078     0.150
     2.494    45.578     0.150
     2.494    78.773     0.150
     3.826    60.375     0.150
     3.826    69.172     0.150
     3.826   103.273     0.150
     3.826   118.773     0.150
     3.842    59.578     0.150
     3.842    68.477     0.150
     3.842   117.672     0.150
     4.104    63.273     0.150
     4.104    73.773     0.150
     4.104   109.375     0.150
     4.104   126.375     0.150
     4.208    76.078     0.150
     4.208   113.078     0.150
     4.208   131.477     0.150
     4.484    80.172     0.150
     4.484   119.875     0.150
     4.484   138.578     0.150
     4.762    73.578     0.150
     4.762    85.773     0.150
     4.762   125.477     0.150
     4.762   147.172     0.150
     0.634    12.414     0.150
     0.634    20.316     0.150
     1.203    22.914     0.150
     1.203    37.914     0.150
     1.379    25.816     0.150
     1.379    44.816     0.150
     2.118    37.914     0.150
     2.118    40.016     0.150
     2.118    68.617     0.150
     2.746    45.016     0.150
     2.746    49.914     0.150
     2.746    84.617     0.150
     3.775    60.414     0.150
     3.775    68.016     0.150
     3.775   102.516     0.150
     3.775   117.117     0.150
     3.884    71.316     0.150
     3.884   105.215     0.150
     3.884   121.414     0.150
     3.914    61.617     0.150
     3.914    71.617     0.150
     3.914   122.516     0.150
     4.206    66.414     0.150
     4.206    77.414     0.150
     4.206   132.414     0.150
     4.569    69.715     0.150
     4.569    82.516     0.150
     4.569   121.914     0.150
     4.569   141.215     0.150
     4.856    89.316     0.150
     4.856   128.914     0.150
     4.856   150.816     0.150
     0.195     4.610     0.150
     0.195     7.411     0.150
     1.015    19.110     0.150
     1.015    32.110     0.150
     1.384    26.011     0.150
     1.384    44.110     0.150
     1.384    44.311     0.150
     2.522    40.911     0.150
     2.522    44.711     0.150
     2.522    71.110     0.150
     2.522    76.511     0.150
     2.522    77.411     0.150
     2.633    48.411     0.150
     2.633    75.511     0.150
     2.633    82.711     0.150
     2.506    41.811     0.150
     2.506    45.610     0.150
     2.506    70.511     0.150
     2.506    79.110     0.150
     2.506    45.911     0.150
     2.827    46.610     0.150
     2.827    51.411     0.150
     2.827    88.311     0.150
     2.827    51.311     0.150
     2.827    87.011     0.150
     3.629    66.411     0.150
     3.629   114.311     0.150
     3.700    59.311     0.150
     3.700    66.511     0.150
     3.700   114.811     0.150
     3.700   103.411     0.150
     3.740    58.811     0.150
     3.740    66.511     0.150
     3.740    99.711     0.150
     3.740   114.811     0.150
     3.972    61.911     0.150
     3.972    71.911     0.150
     3.972   124.511     0.150
     3.972    61.411     0.150
     3.972    71.211     0.150
     3.972   107.311     0.150
     4.003   107.711     0.150
     4.003   124.110     0.150
     4.364    67.311     0.150
     4.364    79.911     0.150
     4.364   116.011     0.150
     4.364   136.911     0.150
     4.906    89.211     0.150
     4.906   152.511     0.150
     5.594    84.711     0.150
     5.594   102.311     0.150
     5.594   145.911     0.150
     5.594   175.511     0.150
     6.794   173.411     0.150
     6.794   211.811     0.150
     7.831   244.411     0.150
     7.833   199.610     0.150
     7.833   245.911     0.150
     8.318   260.011     0.150
    11.250   349.711     0.150
     0.735    14.287     0.150
     0.735    23.387     0.150
     0.735    14.187     0.150
     0.735    23.787     0.150
     1.039    19.687     0.150
     1.039    22.087     0.150
     1.039    33.887     0.150
     1.039    32.587     0.150
     1.492    27.787     0.150
     1.492    30.587     0.150
     1.492    47.287     0.150
     1.492    50.587     0.150
     2.307    39.787     0.150
     2.307    42.187     0.150
     2.307    72.887     0.150
     2.229    41.387     0.150
     2.229    71.287     0.150
     2.229    41.287     0.150
     2.229    70.787     0.150
     2.322    40.187     0.150
     2.322    42.887     0.150
     2.322    73.487     0.150
     2.322    39.987     0.150
     2.322    68.687     0.150
     2.465    40.987     0.150
     2.465    44.787     0.150
     2.465    76.587     0.150
     2.465    41.087     0.150
     2.343    40.487     0.150
     2.343    74.387     0.150
     2.343    73.787     0.150
     3.250   103.087     0.150
     3.250    58.887     0.150
     3.572    57.187     0.150
     3.572    64.587     0.150
     3.572   111.887     0.150
     3.572    98.887     0.150
     4.108    73.887     0.150
     4.108    76.887     0.150
     4.108   127.087     0.150
     4.108    74.287     0.150
     3.885    61.887     0.150
     3.885    71.087     0.150
     3.885   123.187     0.150
     3.885    61.987     0.150
     3.885   106.687     0.150
     4.132    74.887     0.150
     4.132   128.387     0.150
     4.221    76.787     0.150
     4.221   115.487     0.150
     4.221   131.287     0.150
     4.515    71.487     0.150
     4.515    82.787     0.150
     4.515    83.787     0.150
     4.874    86.187     0.150
     4.874   132.087     0.150
     4.874    88.887     0.150
     4.874   131.387     0.150
     5.078    78.087     0.150
     5.078    92.787     0.150
     5.078    91.587     0.150
     6.308   114.987     0.150
     6.308    95.187     0.150
     7.291   107.087     0.150
     7.291   106.987     0.150
     7.790   115.187     0.150
     8.481   215.587     0.150
     8.679   271.787     0.150
     8.754   273.587     0.150
     8.929   279.787     0.150
     9.390   291.487     0.150
     9.390   139.187     0.150
     9.890   308.387     0.150
    10.366   323.787     0.150
    10.607   153.887     0.150
    10.778   336.387     0.150
    10.984   339.287     0.150
    18.138   251.087     0.150
    23.568   312.587     0.150
    27.091   343.987     0.150
     0.837    16.199     0.150
     0.837    27.000     0.150
     0.837    27.102     0.150
     1.301    24.500     0.150
     1.301    26.801     0.150
     1.301    41.699     0.150
     1.463    27.402     0.150
     1.463    47.199     0.150
     1.463    27.602     0.150
     1.463    45.801     0.150
     1.923    37.000     0.150
     1.923    60.102     0.150
     1.923    60.699     0.150
     1.987    35.102     0.150
     1.987    38.199     0.150
     1.987    61.801     0.150
     1.987    64.902     0.150
     2.609    44.602     0.150
     2.609    48.199     0.150
     2.609    83.301     0.150
     2.609    44.500     0.150
     2.609    82.602     0.150
     2.655    45.301     0.150
     2.655    49.000     0.150
     2.655    83.902     0.150
     2.655    83.199     0.150
     2.899    47.500     0.150
     2.899    52.699     0.150
     2.899    90.102     0.150
     2.899    47.199     0.150
     2.899    89.902     0.150
     3.636    59.000     0.150
     3.636    66.000     0.150
     3.636   114.000     0.150
     3.636   116.301     0.150
     3.720    59.902     0.150
     3.720    67.500     0.150
     3.720   103.402     0.150
     3.720   116.602     0.150
     3.787    61.102     0.150
     3.787   118.801     0.150
     3.787    60.902     0.150
     3.787   106.500     0.150
     3.804    61.801     0.150
     3.804    70.602     0.150
     3.804   119.102     0.150
     3.945    63.301     0.150
     3.945    71.699     0.150
     3.945   107.602     0.150
     3.945   123.602     0.150
     4.187    66.602     0.150
     4.187    76.500     0.150
     4.187   115.402     0.150
     4.187   131.199     0.150
     4.187    66.500     0.150
     4.187   130.699     0.150
     4.543    71.000     0.150
     4.543    83.500     0.150
     4.543   142.801     0.150
     4.895    89.602     0.150
     4.895   154.402     0.150
     4.888    75.699     0.150
     4.888   151.699     0.150
     4.888    76.199     0.150
     4.888    90.402     0.150
     5.323    81.902     0.150
     5.323    96.801     0.150
     5.323   166.699     0.150
     5.323    82.102     0.150
     5.323    97.500     0.150
     6.170    92.902     0.150
     6.170   193.902     0.150
     6.594   119.902     0.150
     6.594   170.402     0.150
     6.594   206.500     0.150
     6.594    98.801     0.150
     6.594   119.602     0.150
     6.778   211.801     0.150
     6.874   101.199     0.150
     6.874   213.801     0.150
     6.874   101.320     0.150
     7.283   107.402     0.150
     7.283   227.402     0.150
     7.283   108.102     0.150
     7.306   227.602     0.150
     7.364   231.602     0.150
     7.509   134.500     0.150
     7.509   233.801     0.150
     7.673   112.602     0.150
     7.673   239.602     0.150
     7.673   113.801     0.150
     7.900   247.801     0.150
     7.979   148.902     0.150
     7.979   248.801     0.150
     8.003   118.801     0.150
     8.003   250.500     0.150
     8.400   122.574     0.150
     8.400   214.672     0.150
     8.400   150.199     0.150
     8.540   267.602     0.150
     8.935   131.000     0.150
     8.935   280.301     0.150
     9.030   283.000     0.150
     9.189   134.199     0.150
     9.189   286.801     0.150
     9.656   140.344     0.150
     9.656   298.520     0.150
     9.656   140.102     0.150
     9.656   300.402     0.150
     9.656   141.102     0.150
    10.599   156.000     0.150
    10.704   155.199     0.150
    10.688   155.176     0.150
    10.979   160.191     0.150
    10.992   159.621     0.150
    10.992   274.902     0.150
    10.992   345.199     0.150
    10.992   159.617     0.150
    10.992   345.195     0.150
    11.073   161.301     0.150
    12.786   181.402     0.150
    16.044   225.402     0.150
    16.284   398.879     0.150
    18.469   259.152     0.150
    19.163   266.711     0.150
    19.164   264.812     0.150
    19.164   266.715     0.150
    19.164   264.902     0.150
    19.567   270.379     0.150
    19.706   273.820     0.150
    19.737   274.828     0.150
    19.737   625.328     0.150
    19.737   274.172     0.150
    19.737   274.801     0.150
    19.737   625.332     0.150
    19.751   270.801     0.150
    20.651   280.199     0.150
    21.402   288.000     0.150
    22.852   308.262     0.150
    22.854   308.258     0.150
    23.960   316.402     0.150
    23.960   317.551     0.150
    23.991   317.699     0.150
    23.991   317.402     0.150
    23.991   317.402     0.150
    23.991   317.699     0.150
    24.000   317.320     0.150
    24.054   317.930     0.150
    24.157   320.000     0.150
    24.823   322.902     0.150
    24.823   353.801     0.150
    27.469   348.891     0.150
    27.512   348.699     0.150
    30.923   377.500     0.150
    35.044   415.340     0.150
    38.149   441.430     0.150
    43.322   484.449     0.150
    43.576   482.902     0.150
    44.271   491.500     0.150
    44.271   491.457     0.150
    45.716   501.500     0.150
    45.716   905.301     0.150
    47.633   517.500     0.150
    48.095   518.902     0.150
    49.816   534.711     0.150
    54.837   571.723     0.150
    55.395   577.180     0.150
    55.395   577.180     0.150
    73.587   695.898     0.150
    76.930   714.410     0.150
    76.930   714.410     0.150
    80.527   734.098     0.150
     0.503     9.977     0.150
     0.503    16.375     0.150
     0.503     9.875     0.150
     1.104    20.977     0.150
     1.104    35.578     0.150
     1.399    25.875     0.150
     1.399    44.273     0.150
     1.399    25.773     0.150
     1.399    44.078     0.150
     1.915    34.875     0.150
     1.915    60.773     0.150
     2.212    38.672     0.150
     2.212    40.875     0.150
     2.212    70.375     0.150
     2.212    38.078     0.150
     2.212    69.672     0.150
     2.615    42.672     0.150
     2.615    48.078     0.150
     2.615    82.375     0.150
     2.615    43.375     0.150
     2.615    81.172     0.150
     2.739    45.977     0.150
     2.739    50.172     0.150
     2.739    86.375     0.150
     2.739    46.078     0.150
     2.739    85.875     0.150
     2.704    44.273     0.150
     2.704    48.672     0.150
     2.704    83.672     0.150
     2.704    83.375     0.150
     3.632    58.773     0.150
     3.632    66.477     0.150
     3.632   115.172     0.150
     3.632   115.273     0.150
     3.703    58.578     0.150
     3.703    66.773     0.150
     3.703   114.375     0.150
     3.715    66.172     0.150
     3.715   103.078     0.150
     3.715   110.773     0.150
     3.715   113.977     0.150
     3.715   107.375     0.150
     3.881    71.078     0.150
     3.881   121.375     0.150
     3.959    62.773     0.150
     3.959    71.172     0.150
     3.959   123.375     0.150
     3.959    61.273     0.150
     3.959   107.273     0.150
     3.959   121.977     0.150
     4.280    67.273     0.150
     4.280    77.578     0.150
     4.280   135.172     0.150
     4.293    67.273     0.150
     4.900    74.672     0.150
     4.900    89.172     0.150
     4.900   132.672     0.150
     4.900   153.375     0.150
     4.900    76.875     0.150
     4.900    91.078     0.150
     4.900   152.172     0.150
     5.170   162.273     0.150
     5.467    99.672     0.150
     5.467   143.273     0.150
     5.467   171.773     0.150
     5.467    83.172     0.150
     5.467   143.172     0.150
     6.310    94.375     0.150
     6.310   196.977     0.150
     6.703   209.477     0.150
     6.928   176.078     0.150
     6.928   217.477     0.150
     7.508   234.875     0.150
     7.571   110.875     0.150
     7.571   135.273     0.150
     7.571   237.875     0.150
     7.681   241.477     0.150
     7.799   242.875     0.150
     8.053   252.273     0.150
     8.124   240.578     0.150
     8.124   253.773     0.150
     8.172   237.672     0.150
     8.172   255.672     0.150
     9.070   281.375     0.150
     9.321   288.773     0.150
     9.783   302.875     0.150
    10.285   319.477     0.150
    10.753   336.672     0.150
    10.946   340.273     0.150
    11.173   348.578     0.150
    11.379   355.672     0.150
     0.692    13.492     0.150
     0.692    22.195     0.150
     1.132    21.594     0.150
     1.132    36.492     0.150
     1.410    26.793     0.150
     1.410    44.695     0.150
     2.215    39.094     0.150
     2.215    41.195     0.150
     2.215    69.895     0.150
     2.263    40.293     0.150
     2.263    42.695     0.150
     2.263    73.195     0.150
     2.323    43.492     0.150
     2.323    74.293     0.150
     2.431    43.195     0.150
     2.431    44.992     0.150
     2.431    77.195     0.150
     2.541    42.793     0.150
     2.541    46.094     0.150
     2.541    78.895     0.150
     3.666    58.695     0.150
     3.666    66.695     0.150
     3.666   100.094     0.150
     3.666   114.594     0.150
     4.129    65.395     0.150
     4.129    74.793     0.150
     4.129   111.395     0.150
     4.129   129.594     0.150
     0.549    10.781     0.150
     0.549    17.684     0.150
     1.143    21.582     0.150
     1.143    36.383     0.150
     1.143    40.281     0.150
     2.165    38.984     0.150
     2.165    67.684     0.150
     2.363    43.781     0.150
     2.363    74.582     0.150
     2.367    40.383     0.150
     2.367    43.883     0.150
     2.367    75.582     0.150
     2.476    45.082     0.150
     2.476    76.082     0.150
     2.507    43.184     0.150
     2.507    46.184     0.150
     2.507    79.383     0.150
     3.708    58.484     0.150
     3.708    67.383     0.150
     3.708   102.883     0.150
     3.708   115.383     0.150
     4.049    64.082     0.150
     4.049    74.184     0.150
     4.049   111.984     0.150
     4.049   126.484     0.150
     4.648    84.984     0.150
     4.648   145.883     0.150
     0.280     6.619     0.150
     0.280    11.018     0.150
     0.280     6.518     0.150
     0.659    12.518     0.150
     0.659    21.219     0.150
     1.750    31.119     0.150
     1.750    54.518     0.150
     1.750    54.018     0.150
     2.592    43.119     0.150
     2.592    47.318     0.150
     2.592    82.018     0.150
     2.592    81.518     0.150
     2.737    43.418     0.150
     2.737    47.418     0.150
     2.737    82.619     0.150
     2.737    47.719     0.150
     2.737    82.918     0.150
     3.002    54.119     0.150
     3.002    94.619     0.150
     3.217    51.418     0.150
     3.217    58.619     0.150
     3.217   100.518     0.150
     3.780    67.219     0.150
     3.780   103.119     0.150
     3.780   117.219     0.150
     3.986   124.518     0.150
     4.752    72.318     0.150
     4.752   125.418     0.150
     4.752   148.818     0.150
     5.265    96.219     0.150
     5.265   162.318     0.150
     5.794   104.518     0.150
     5.794   148.719     0.150
     5.987   186.818     0.150
     5.987   109.418     0.150
     8.181   255.918     0.150
     8.712   271.719     0.150
    11.798   364.018     0.150
     0.326     6.494     0.150
     0.326    11.195     0.150
     0.618    12.295     0.150
     0.618    20.695     0.150
     1.302    23.195     0.150
     1.302    25.494     0.150
     2.086    35.695     0.150
     2.086    37.994     0.150
     2.567    42.395     0.150
     2.567    46.594     0.150
     2.567    80.494     0.150
     3.038    47.994     0.150
     3.038    53.395     0.150
     3.038    83.594     0.150
     3.038    91.895     0.150
     3.114    54.494     0.150
     3.501   107.695     0.150
     3.620    61.494     0.150
     3.620   107.094     0.150
     3.541    56.295     0.150
     3.541    63.895     0.150
     3.541   110.195     0.150
     4.387    67.295     0.150
     4.387    77.895     0.150
     4.387   114.994     0.150
     4.673    83.795     0.150
     4.673   124.195     0.150
     4.673   144.594     0.150
     5.079    77.695     0.150
     5.079    91.295     0.150
     5.079   132.395     0.150
     5.079   158.494     0.150
     5.603    83.895     0.150
     5.603   100.094     0.150
     5.603   174.494     0.150
     8.393   263.195     0.150
     8.618   268.295     0.150
     9.019   280.695     0.150
    11.084   342.695     0.150
     1.078    20.652     0.150
     1.078    34.354     0.150
     1.304    24.553     0.150
     1.304    42.152     0.150
     1.632    30.652     0.150
     1.632    51.053     0.150
     1.632    54.254     0.150
     1.920    34.553     0.150
     1.920    35.953     0.150
     1.920    60.953     0.150
     2.300    39.854     0.150
     2.300    43.053     0.150
     2.300    73.254     0.150
     2.367    40.453     0.150
     2.367    44.053     0.150
     2.367    69.354     0.150
     2.367    75.553     0.150
     2.364    41.053     0.150
     2.364    44.053     0.150
     2.364    69.854     0.150
     2.364    75.053     0.150
     2.841    51.854     0.150
     2.841    53.652     0.150
     2.841    54.854     0.150
     2.841    79.953     0.150
     2.841    87.953     0.150
     3.393    55.754     0.150
     3.393    61.953     0.150
     3.393   106.254     0.150
     3.688    59.354     0.150
     3.688    66.854     0.150
     3.688   101.652     0.150
     3.688   114.953     0.150
     3.886    62.254     0.150
     3.886    71.754     0.150
     3.886   106.652     0.150
     3.886   122.354     0.150
     4.094    63.652     0.150
     4.094    74.053     0.150
     4.094   110.354     0.150
     4.094   127.453     0.150
     4.543    70.254     0.150
     4.543    81.053     0.150
     4.543   141.953     0.150
     4.629   145.053     0.150
     5.002    77.354     0.150
     5.002    89.652     0.150
     5.002    91.453     0.150
     5.002   132.652     0.150
     5.002   157.152     0.150
     5.481    99.553     0.150
     5.481   172.453     0.150
     6.285    94.854     0.150
     6.285   114.453     0.150
     6.285   164.354     0.150
     6.285   196.652     0.150
     6.454    97.553     0.150
     6.454   168.754     0.150
     6.454   201.953     0.150
     6.975   103.854     0.150
     6.975   127.053     0.150
     6.975   217.152     0.150
     6.980   104.453     0.150
     6.980   216.453     0.150
     7.180   224.053     0.150
     7.357   188.553     0.150
     7.357   229.152     0.150
     7.675   196.854     0.150
     7.675   239.854     0.150
     0.773    15.078     0.150
     0.773    25.484     0.150
     0.827    15.578     0.150
     0.827    26.578     0.150
     1.624    29.578     0.150
     1.624    31.484     0.150
     1.624    51.383     0.150
     2.045    38.078     0.150
     2.045    65.781     0.150
     2.237    39.383     0.150
     2.237    40.578     0.150
     2.237    68.078     0.150
     2.237    70.680     0.150
     2.205    38.578     0.150
     2.205    40.281     0.150
     2.205    69.078     0.150
     2.484    42.484     0.150
     2.484    44.883     0.150
     2.484    77.883     0.150
     2.540    43.383     0.150
     2.540    46.484     0.150
     2.540    80.680     0.150
     3.059    49.578     0.150
     3.059    55.578     0.150
     3.059    97.078     0.150
     3.390    55.180     0.150
     3.390    61.383     0.150
     3.390   106.680     0.150
     3.745    59.883     0.150
     3.745    69.180     0.150
     3.745   118.484     0.150
     3.916    61.578     0.150
     3.916    70.680     0.150
     3.916   116.984     0.150
     3.916   121.984     0.150
     4.279    67.883     0.150
     4.279    76.484     0.150
     4.279   133.883     0.150
     4.276    66.484     0.150
     4.276    76.281     0.150
     4.276   132.281     0.150
     4.330    68.781     0.150
     4.330   135.180     0.150
     4.888   154.484     0.150
     4.970    76.281     0.150
     4.970    90.578     0.150
     4.970   156.484     0.150
     5.808   182.383     0.150
     6.173    94.484     0.150
     6.173   112.078     0.150
     6.173   161.078     0.150
     6.173   193.578     0.150
     6.433   165.883     0.150
     6.433   201.883     0.150
     7.210   223.781     0.150
     7.282   226.680     0.150
     7.315   107.281     0.150
     7.315   133.578     0.150
     7.315   186.781     0.150
     7.315   230.484     0.150
     7.322   228.883     0.150
     7.509   234.484     0.150
     7.560   236.883     0.150
     7.623   235.281     0.150
     7.696   238.281     0.150
     8.168   255.078     0.150
     8.559   266.484     0.150
     8.807   272.984     0.150
     9.264   287.984     0.150
     9.751   301.984     0.150
    10.257   318.383     0.150
    10.573   330.984     0.150
    10.634   330.781     0.150
    10.823   335.281     0.150
    12.907   399.578     0.150
     0.149     3.445     0.150
     0.149     5.344     0.150
     1.371    25.547     0.150
     1.371    27.047     0.150
     1.371    43.750     0.150
     1.371    25.844     0.150
     1.371    42.750     0.150
     1.953    35.945     0.150
     1.953    61.945     0.150
     2.570    43.344     0.150
     2.570    48.047     0.150
     2.570    81.344     0.150
     2.570    47.344     0.150
     2.570    80.547     0.150
     2.474    41.445     0.150
     2.474    44.344     0.150
     2.474    71.844     0.150
     2.474    76.344     0.150
     2.474    40.945     0.150
     2.474    44.445     0.150
     2.474    75.945     0.150
     2.622    45.344     0.150
     2.622    48.445     0.150
     2.622    82.344     0.150
     2.830    47.047     0.150
     2.830    51.750     0.150
     2.830    88.648     0.150
     2.830    46.945     0.150
     2.830    51.648     0.150
     2.830    88.344     0.150
     3.719    59.648     0.150
     3.719    68.445     0.150
     3.719   115.945     0.150
     3.769   116.547     0.150
     3.613    57.445     0.150
     3.613    66.945     0.150
     3.613   114.250     0.150
     3.978    62.547     0.150
     3.978   125.250     0.150
     3.990    62.344     0.150
     3.990    72.445     0.150
     3.959    61.445     0.150
     3.959    72.148     0.150
     3.959   124.344     0.150
     3.959    71.344     0.150
     3.959   107.648     0.150
     3.959   122.648     0.150
     4.365    68.250     0.150
     4.365    80.148     0.150
     4.365   137.148     0.150
     4.365    68.445     0.150
     4.365    80.250     0.150
     4.365   136.750     0.150
     4.891    76.344     0.150
     4.891    89.750     0.150
     4.891   152.547     0.150
     4.891    89.547     0.150
     4.891   132.344     0.150
     5.603    84.445     0.150
     5.603   101.945     0.150
     5.603   149.844     0.150
     5.603    84.945     0.150
     5.603   101.750     0.150
     6.035   157.547     0.150
     6.795   102.844     0.150
     6.795   178.547     0.150
     6.795   212.547     0.150
     6.795   102.344     0.150
     7.067   127.250     0.150
     7.067   221.250     0.150
     7.901   198.008     0.150
     7.901   240.305     0.150
     7.874   114.547     0.150
     7.874   248.250     0.150
     7.874   114.648     0.150
     7.909   248.047     0.150
     8.143   149.344     0.150
     8.143   254.344     0.150
     8.193   255.750     0.150
     8.331   122.250     0.150
     8.331   148.445     0.150
     8.331   244.148     0.150
     8.331   261.547     0.150
     8.798   275.250     0.150
     9.188   286.344     0.150
     9.435   277.047     0.150
     9.435   293.445     0.150
     9.890   307.164     0.150
     9.890   143.445     0.150
    10.369   153.344     0.150
    10.369   322.445     0.150
    10.890   340.250     0.150
    11.248   350.844     0.150
    11.416   166.445     0.150
    11.416   354.648     0.150
    11.460   165.164     0.150
    11.460   359.430     0.150
    14.856   460.844     0.150
    15.603   219.344     0.150
    19.037   263.188     0.150
    21.129   287.945     0.150
    23.876   315.047     0.150
    27.303   344.648     0.150
    42.799   479.250     0.150
    43.728   484.945     0.150
    43.728   485.250     0.150
    49.388   529.023     0.150
     0.156     3.383     0.150
     0.156     5.477     0.150
     1.358    25.477     0.150
     1.358    27.883     0.150
     1.358    42.977     0.150
     1.358    45.281     0.150
     1.966    35.883     0.150
     1.966    61.883     0.150
     1.966    63.578     0.150
     2.462    41.578     0.150
     2.462    44.383     0.150
     2.462    72.180     0.150
     2.462    76.281     0.150
     2.576    43.383     0.150
     2.576    48.180     0.150
     2.576    81.281     0.150
     2.610    81.883     0.150
     2.610    83.281     0.150
     2.819    46.977     0.150
     2.819    47.883     0.150
     2.819    51.180     0.150
     3.600    56.281     0.150
     3.600    65.883     0.150
     3.600   113.383     0.150
     3.732    58.078     0.150
     3.732    67.477     0.150
     3.732   103.781     0.150
     3.732   116.383     0.150
     3.782   115.883     0.150
     3.981    62.477     0.150
     3.981    72.680     0.150
     3.981   124.781     0.150
     3.946    62.281     0.150
     3.946    71.180     0.150
     3.946   124.281     0.150
     4.354    68.180     0.150
     4.354    79.781     0.150
     4.354   136.680     0.150
     4.878    88.680     0.150
     4.878   152.883     0.150
     5.593    84.781     0.150
     5.593   103.477     0.150
     5.593   174.477     0.150
     6.430   200.883     0.150
     6.783   172.680     0.150
     6.783   211.680     0.150
     7.056   128.781     0.150
     7.056   221.281     0.150
     7.835   245.281     0.150
     7.868   114.578     0.150
     7.868   247.680     0.150
     7.898   144.883     0.150
     7.898   248.078     0.150
     8.182   255.180     0.150
     8.245   211.180     0.150
     8.245   256.477     0.150
     8.320   260.977     0.150
     8.787   274.781     0.150
     9.177   284.781     0.150
    10.357   321.281     0.150
    11.236   349.383     0.150
    11.404   354.977     0.150
    13.645   423.781     0.150
    14.843   460.383     0.150
     0.738    14.434     0.150
     0.738    24.133     0.150
     1.132    21.230     0.150
     1.132    35.531     0.150
     1.563    28.730     0.150
     1.563    29.531     0.150
     1.563    49.730     0.150
     1.831    32.730     0.150
     1.831    56.730     0.150
     1.950    34.434     0.150
     1.950    36.230     0.150
     1.950    62.332     0.150
     2.738    45.230     0.150
     2.738    50.332     0.150
     2.738    86.031     0.150
     2.805    46.730     0.150
     2.805    51.531     0.150
     2.805    87.633     0.150
     2.940    47.031     0.150
     2.940    53.031     0.150
     2.940    90.332     0.150
     3.580   111.230     0.150
     3.633    56.934     0.150
     3.633    65.230     0.150
     3.633    97.832     0.150
     3.633   111.934     0.150
     3.763   103.031     0.150
     3.763   118.031     0.150
     4.078    63.934     0.150
     4.078    74.633     0.150
     4.078   109.633     0.150
     4.078   127.434     0.150
     4.341    67.730     0.150
     4.341    79.332     0.150
     4.341   117.230     0.150
     4.341   135.633     0.150
     4.489    68.133     0.150
     4.489    80.133     0.150
     4.489   118.832     0.150
     4.489   137.934     0.150
     4.549    69.633     0.150
     4.549    81.133     0.150
     4.549   120.934     0.150
     4.549   140.934     0.150
     5.021    77.230     0.150
     5.021    92.133     0.150
     5.021   131.934     0.150
     5.021   156.934     0.150
     5.486    83.332     0.150
     5.486    99.934     0.150
     5.486   144.633     0.150
     5.486   171.031     0.150
     6.333   197.531     0.150
     6.752   101.434     0.150
     6.752   174.332     0.150
     6.752   209.434     0.150
     7.442   191.133     0.150
     7.442   231.434     0.150
     7.528   234.832     0.150
     7.834   243.934     0.150
     8.169   254.730     0.150
     0.275     5.192     0.150
     0.275     9.393     0.150
     0.692    13.593     0.150
     0.692    22.492     0.150
     1.254    23.492     0.150
     1.254    25.393     0.150
     1.254    40.692     0.150
     2.164    38.192     0.150
     2.164    39.593     0.150
     2.614    44.093     0.150
     2.614    47.692     0.150
     2.614    76.093     0.150
     2.614    82.492     0.150
     2.955    47.992     0.150
     2.955    53.293     0.150
     2.955    54.692     0.150
     2.955    82.692     0.150
     2.955    91.492     0.150
     3.060    94.593     0.150
     3.085    48.893     0.150
     3.085    54.893     0.150
     3.085    94.093     0.150
     3.416    62.093     0.150
     3.416   106.692     0.150
     3.534   106.393     0.150
     3.624    58.492     0.150
     3.624    64.992     0.150
     3.624    65.893     0.150
     3.624   112.793     0.150
     4.407    79.093     0.150
     4.407   135.393     0.150
     4.399    68.692     0.150
     4.399    70.593     0.150
     4.399    79.293     0.150
     4.399   117.593     0.150
     4.399   136.492     0.150
     4.749    84.893     0.150
     4.749   126.793     0.150
     4.749   142.893     0.150
     4.749   147.793     0.150
     5.162    79.692     0.150
     5.162    93.593     0.150
     5.162   161.293     0.150
     5.678    86.793     0.150
     5.678   101.593     0.150
     5.678   175.793     0.150
     6.387    96.393     0.150
     6.387   115.893     0.150
     6.387   167.393     0.150
     6.387   199.192     0.150
     7.591   236.793     0.150
     8.476   125.093     0.150
     8.476   217.192     0.150
     8.476   264.692     0.150
     8.702   270.093     0.150
     9.105   282.692     0.150
     0.718    22.625     0.150
     0.718    23.625     0.150
     1.212    23.227     0.150
     1.212    38.930     0.150
     1.379    43.625     0.150
     2.157    38.727     0.150
     2.157    39.828     0.150
     2.157    68.625     0.150
     2.176    38.828     0.150
     2.176    41.125     0.150
     2.176    70.125     0.150
     2.390    41.430     0.150
     2.390    44.625     0.150
     2.390    76.125     0.150
     2.481    42.828     0.150
     2.481    46.031     0.150
     2.481    78.930     0.150
     3.414    55.727     0.150
     3.414    62.531     0.150
     3.414    95.430     0.150
     3.414   107.930     0.150
     3.732    60.125     0.150
     3.732    67.828     0.150
     3.732   116.930     0.150
     3.924    62.828     0.150
     3.924    71.531     0.150
     3.924   106.328     0.150
     3.924   122.031     0.150
     4.021    64.227     0.150
     4.021    72.625     0.150
     4.021    74.031     0.150
     4.021   109.031     0.150
     4.021   126.930     0.150
     4.282    67.031     0.150
     4.282    77.930     0.150
     4.282    79.430     0.150
     4.282   133.828     0.150
     4.675    73.531     0.150
     4.675    84.727     0.150
     4.675    87.625     0.150
     4.675   146.125     0.150
     4.907    89.531     0.150
     4.907   131.930     0.150
     4.907   154.125     0.150
     5.195    80.031     0.150
     5.195    95.125     0.150
     5.195   137.727     0.150
     5.195   162.430     0.150
     5.520   172.625     0.150
     6.040    91.031     0.150
     6.040   109.828     0.150
     6.040   157.625     0.150
     6.040   188.625     0.150
     6.440    97.531     0.150
     6.440   117.531     0.150
     6.440   167.227     0.150
     6.440   201.125     0.150
     6.655   100.828     0.150
     6.655   172.125     0.150
     6.655   208.531     0.150
     7.068   105.625     0.150
     7.068   221.031     0.150
     7.237   226.430     0.150
     7.313   108.531     0.150
     7.313   190.227     0.150
     7.313   229.227     0.150
     7.406   111.031     0.150
     7.406   231.531     0.150
     7.532   112.930     0.150
     7.532   193.828     0.150
     7.532   222.125     0.150
     7.532   234.125     0.150
     7.728   240.125     0.150
     7.780   242.828     0.150
     7.853   245.328     0.150
     7.897   118.328     0.150
     7.897   203.031     0.150
     7.897   246.328     0.150
     8.408   261.727     0.150
     8.418   123.844     0.150
     8.418   212.844     0.150
     8.801   274.930     0.150
     9.053   281.828     0.150
     9.516   296.227     0.150
    10.951   159.008     0.150
    10.951   342.445     0.150
    10.956   159.625     0.150
    18.930   264.406     0.150
    23.800   315.375     0.150
    23.830   315.984     0.150
    43.331   484.875     0.150
     0.541    10.717     0.150
     0.541    17.416     0.150
     1.120    35.116     0.150
     1.407    26.416     0.150
     1.407    44.416     0.150
     1.917    35.316     0.150
     1.917    60.217     0.150
     2.177    38.616     0.150
     2.177    41.017     0.150
     2.177    70.116     0.150
     2.616    43.616     0.150
     2.616    48.416     0.150
     2.616    75.717     0.150
     2.616    82.717     0.150
     2.728    44.616     0.150
     2.728    49.316     0.150
     2.728    50.717     0.150
     2.728    76.416     0.150
     2.728    84.017     0.150
     2.731    46.017     0.150
     2.731    50.316     0.150
     2.731    77.217     0.150
     2.731    86.116     0.150
     3.634   113.717     0.150
     3.699    58.116     0.150
     3.699    67.116     0.150
     3.699   101.316     0.150
     3.699   114.816     0.150
     3.960    71.916     0.150
     3.960   123.616     0.150
     4.272    67.217     0.150
     4.272    78.116     0.150
     4.272   134.316     0.150
     4.323    79.116     0.150
     4.323   135.116     0.150
     4.901    88.717     0.150
     4.901   129.416     0.150
     4.901   152.116     0.150
     5.141   161.217     0.150
     5.453    82.916     0.150
     5.453    99.116     0.150
     5.453   142.916     0.150
     5.453   170.616     0.150
     6.297   115.017     0.150
     6.297   196.717     0.150
     7.540   235.616     0.150
     7.664   238.816     0.150
     0.310     6.391     0.150
     0.310    10.891     0.150
     0.733    13.695     0.150
     0.733    23.789     0.150
     1.633    30.391     0.150
     1.633    52.195     0.150
     1.674    30.391     0.150
     1.674    53.094     0.150
     2.393    41.094     0.150
     2.393    43.891     0.150
     2.393    70.094     0.150
     2.393    75.391     0.150
     2.788    46.789     0.150
     2.788    51.195     0.150
     2.788    85.992     0.150
     2.920    52.891     0.150
     2.920    91.391     0.150
     3.095    50.094     0.150
     3.095    55.789     0.150
     3.095    96.289     0.150
     3.920    71.891     0.150
     3.920   123.289     0.150
     4.266   131.195     0.150
     4.635    72.391     0.150
     4.635    84.195     0.150
     4.635   144.789     0.150
     5.197   161.992     0.150
     5.214    79.492     0.150
     5.214   161.289     0.150
     5.847   106.594     0.150
     5.847   182.695     0.150
     6.689   208.594     0.150
     7.063   221.289     0.150
     8.073   251.492     0.150
     8.562   267.992     0.150
     0.327     6.480     0.150
     0.327    10.980     0.150
     1.628    30.879     0.150
     1.628    52.180     0.150
     1.676    30.879     0.150
     1.676    53.680     0.150
     2.370    41.277     0.150
     2.370    44.078     0.150
     2.370    75.379     0.150
     2.801    85.777     0.150
     2.920    52.777     0.150
     2.920    92.078     0.150
     3.091    51.680     0.150
     3.091    56.078     0.150
     3.091    96.777     0.150
     3.922   121.582     0.150
     4.284    77.480     0.150
     4.284   132.777     0.150
     4.262    67.578     0.150
     4.262    76.879     0.150
     4.262   133.582     0.150
     4.631    72.578     0.150
     4.631    83.777     0.150
     4.631   144.980     0.150
     5.198    80.277     0.150
     5.198    94.578     0.150
     5.198   162.582     0.150
     5.560   174.777     0.150
     5.840    89.078     0.150
     5.840   106.480     0.150
     5.840   154.480     0.150
     5.840   183.082     0.150
     6.682   209.777     0.150
     7.059   220.277     0.150
     7.303   227.777     0.150
     8.064   253.379     0.150
     8.163   255.480     0.150
     8.554   267.379     0.150
     0.318     6.352     0.150
     0.318    10.352     0.150
     1.548    28.754     0.150
     1.548    30.254     0.150
     1.548    49.055     0.150
     1.548    50.152     0.150
     1.750    32.254     0.150
     1.750    32.555     0.150
     1.750    56.055     0.150
     2.340    40.652     0.150
     2.340    43.152     0.150
     2.340    69.055     0.150
     2.340    73.754     0.150
     2.726    45.254     0.150
     2.726    48.953     0.150
     2.726    76.254     0.150
     2.726    83.652     0.150
     2.787    46.652     0.150
     2.787    51.055     0.150
     2.787    79.254     0.150
     2.787    88.254     0.150
     2.949    49.852     0.150
     2.949    53.754     0.150
     2.949    83.152     0.150
     2.949    91.953     0.150
     3.536    56.152     0.150
     3.536    64.152     0.150
     3.536    97.453     0.150
     3.536   110.754     0.150
     3.558    56.754     0.150
     3.558    63.555     0.150
     3.558    65.152     0.150
     3.558    97.453     0.150
     3.558   109.453     0.150
     3.793    59.152     0.150
     3.793    69.152     0.150
     3.793    70.852     0.150
     3.793   102.754     0.150
     3.793   119.055     0.150
     4.131    65.555     0.150
     4.131    74.953     0.150
     4.131   111.152     0.150
     4.131   129.555     0.150
     4.248    77.254     0.150
     4.248   114.953     0.150
     4.248   131.555     0.150
     4.490    70.352     0.150
     4.490    81.453     0.150
     4.490   120.652     0.150
     4.490   139.754     0.150
     5.068    78.152     0.150
     5.068    92.152     0.150
     5.068   133.754     0.150
     5.068   158.953     0.150
     5.427    98.852     0.150
     5.427   170.453     0.150
     5.696    86.555     0.150
     5.696   103.254     0.150
     5.696   150.055     0.150
     5.696   178.453     0.150
     6.538   119.152     0.150
     6.538   204.453     0.150
     6.917   124.852     0.150
     6.917   179.754     0.150
     6.917   215.453     0.150
     7.827   116.453     0.150
     7.827   143.254     0.150
     7.827   201.953     0.150
     7.827   244.953     0.150
     7.920   247.852     0.150
     8.020   250.152     0.150
     8.233   211.754     0.150
     8.233   256.254     0.150
     8.409   214.555     0.150
     8.409   262.152     0.150
     9.544   297.852     0.150
    10.003   310.352     0.150
    10.497   325.453     0.150
    10.984   342.453     0.150
    11.571   167.352     0.150
    11.571   290.652     0.150
    11.571   360.055     0.150
     0.778    15.158     0.150
     0.778    25.059     0.150
     0.935    17.758     0.150
     0.935    30.158     0.150
     2.129    37.359     0.150
     2.129    39.959     0.150
     2.129    68.158     0.150
     2.255    39.559     0.150
     2.255    41.758     0.150
     2.255    67.459     0.150
     2.255    71.359     0.150
     2.374    39.959     0.150
     2.374    43.158     0.150
     2.374    69.258     0.150
     2.374    73.758     0.150
     2.403    42.059     0.150
     2.403    44.258     0.150
     2.403    70.758     0.150
     2.403    75.359     0.150
     2.404    42.059     0.150
     2.404    44.158     0.150
     2.404    69.859     0.150
     2.404    75.258     0.150
     3.149    50.359     0.150
     3.149    57.658     0.150
     3.149    88.158     0.150
     3.149    98.459     0.150
     3.473    56.158     0.150
     3.473    62.859     0.150
     3.473    95.359     0.150
     3.473   108.658     0.150
     3.796    60.959     0.150
     3.796    69.959     0.150
     3.796   104.559     0.150
     3.796   119.459     0.150
     4.052    62.859     0.150
     4.052    73.258     0.150
     4.052   125.658     0.150
     4.185    65.859     0.150
     4.185    76.459     0.150
     4.185   113.658     0.150
     4.185   130.459     0.150
     4.204    65.158     0.150
     4.204    76.059     0.150
     4.204   112.658     0.150
     4.204   130.959     0.150
     4.415    69.359     0.150
     4.415    80.658     0.150
     4.415   117.158     0.150
     4.415   138.359     0.150
     4.843    88.758     0.150
     4.843   129.658     0.150
     4.843   151.758     0.150
     5.000    77.359     0.150
     5.000    90.959     0.150
     5.000   133.758     0.150
     5.000   156.258     0.150
     5.841   153.459     0.150
     5.841   182.758     0.150
     6.222    94.359     0.150
     6.222   112.758     0.150
     6.222   162.059     0.150
     6.222   194.258     0.150
     7.229   225.859     0.150
     7.265   227.158     0.150
     7.323   109.359     0.150
     7.323   188.959     0.150
     7.323   227.959     0.150
     7.538   112.559     0.150
     7.538   235.459     0.150
     7.717   115.459     0.150
     7.717   197.859     0.150
     7.717   240.559     0.150
     8.847   275.359     0.150
     9.307   290.359     0.150
    10.288   320.758     0.150
    10.828   341.404     0.150
    11.224   163.908     0.150
    23.551   313.152     0.150
     0.603    11.914     0.150
     0.603    19.615     0.150
     1.054    19.615     0.150
     1.054    33.814     0.150
     2.254    40.014     0.150
     2.254    69.914     0.150
     2.275    41.914     0.150
     2.275    72.115     0.150
     2.407    43.514     0.150
     2.407    74.215     0.150
     2.413    41.414     0.150
     2.413    44.314     0.150
     2.413    69.314     0.150
     2.413    76.414     0.150
     2.423    41.914     0.150
     2.423    44.314     0.150
     2.423    75.914     0.150
     3.619    56.814     0.150
     3.619    65.115     0.150
     3.619   113.014     0.150
     3.964    62.615     0.150
     3.964    71.914     0.150
     3.964   123.514     0.150
     4.047   125.014     0.150
     4.050    71.615     0.150
     4.050   125.014     0.150
     4.047    72.715     0.150
     4.047   125.615     0.150
     4.559    82.314     0.150
     4.559   142.514     0.150
     0.309     6.335     0.150
     0.309    10.235     0.150
     0.890    16.835     0.150
     0.890    28.435     0.150
     1.534    28.535     0.150
     1.534    49.435     0.150
     1.764    32.335     0.150
     1.764    55.135     0.150
     2.349    40.135     0.150
     2.349    43.535     0.150
     2.349    74.036     0.150
     2.712    44.335     0.150
     2.712    48.935     0.150
     2.712    51.036     0.150
     2.712    77.335     0.150
     2.712    83.735     0.150
     2.937    53.835     0.150
     2.937    92.435     0.150
     3.550    56.835     0.150
     3.550    64.135     0.150
     3.550   110.036     0.150
     3.572    57.135     0.150
     3.572    64.135     0.150
     3.572   109.536     0.150
     4.117    63.835     0.150
     4.117    74.635     0.150
     4.117   128.235     0.150
     4.478    69.635     0.150
     4.478    81.635     0.150
     4.478   139.335     0.150
     0.330     6.574     0.150
     0.330    10.477     0.150
     0.872    16.875     0.150
     0.872    27.777     0.150
     1.557    28.977     0.150
     1.557    49.875     0.150
     1.740    32.477     0.150
     1.740    55.074     0.150
     2.328    39.977     0.150
     2.328    42.477     0.150
     2.328    74.074     0.150
     2.739    45.074     0.150
     2.739    48.977     0.150
     2.739    84.375     0.150
     2.955    49.477     0.150
     2.955    53.875     0.150
     2.955    93.074     0.150
     3.527    56.375     0.150
     3.527    63.477     0.150
     3.527    97.676     0.150
     3.527   108.277     0.150
     3.547    56.574     0.150
     3.547    63.375     0.150
     3.547    97.477     0.150
     3.547   108.574     0.150
     4.139    65.074     0.150
     4.139    74.477     0.150
     4.139   130.477     0.150
     4.496    70.375     0.150
     4.496    82.074     0.150
     4.496   141.074     0.150
     0.137     3.312     0.150
     0.137     5.121     0.150
     0.964    18.312     0.150
     0.964    32.012     0.150
     2.534    46.172     0.150
     2.534    79.094     0.150
     2.669    44.441     0.150
     2.669    48.062     0.150
     2.669    77.523     0.150
     2.669    83.074     0.150
     2.767    46.344     0.150
     2.767    50.391     0.150
     2.767    80.711     0.150
     2.767    86.891     0.150
     3.192    52.711     0.150
     3.192    58.691     0.150
     3.192    92.051     0.150
     3.192   101.512     0.150
     3.325    52.691     0.150
     3.325    58.684     0.150
     3.325    91.992     0.150
     3.325   101.551     0.150
     3.441    53.832     0.150
     3.441    60.094     0.150
     3.441    93.902     0.150
     3.441   103.980     0.150
     4.679    71.691     0.150
     4.679    83.453     0.150
     4.679   125.480     0.150
     4.679   144.480     0.150
     0.786    15.203     0.150
     0.786    25.508     0.150
     0.927    17.602     0.150
     0.927    30.203     0.150
     1.584    29.703     0.150
     1.584    50.406     0.150
     2.245    39.508     0.150
     2.245    41.602     0.150
     2.245    70.602     0.150
     2.369    43.203     0.150
     2.369    73.602     0.150
     2.413    40.602     0.150
     2.413    44.008     0.150
     2.413    76.008     0.150
     2.406    42.305     0.150
     2.406    44.602     0.150
     2.406    71.008     0.150
     2.406    77.406     0.150
     3.464    56.406     0.150
     3.464    63.906     0.150
     3.464   109.008     0.150
     4.050    63.602     0.150
     4.050    73.102     0.150
     4.050   126.305     0.150
     4.194    66.203     0.150
     4.194    76.602     0.150
     4.194   112.805     0.150
     4.194   130.805     0.150
     0.599    11.699     0.150
     0.599    19.098     0.150
     1.163    22.000     0.150
     1.163    37.000     0.150
     1.400    26.098     0.150
     1.400    27.898     0.150
     1.400    45.098     0.150
     1.400    47.898     0.150
     1.940    35.297     0.150
     1.940    61.598     0.150
     2.133    37.797     0.150
     2.133    40.297     0.150
     2.133    68.699     0.150
     2.598    48.000     0.150
     2.598    82.297     0.150
     2.701    45.598     0.150
     2.701    49.699     0.150
     2.701    85.098     0.150
     2.749    49.797     0.150
     2.749    84.797     0.150
     3.715    59.297     0.150
     3.715    67.598     0.150
     3.715   115.598     0.150
     3.742    68.797     0.150
     3.742   117.699     0.150
     3.942    71.297     0.150
     3.942   123.199     0.150
     4.357   136.199     0.150
     4.884   151.797     0.150
     0.583    11.461     0.150
     0.583    18.758     0.150
     1.154    21.859     0.150
     1.154    36.660     0.150
     1.398    26.059     0.150
     1.398    27.258     0.150
     1.398    44.859     0.150
     1.398    47.559     0.150
     2.147    37.660     0.150
     2.147    40.359     0.150
     2.147    68.660     0.150
     2.599    47.758     0.150
     2.599    81.758     0.150
     2.739    44.758     0.150
     2.739    49.859     0.150
     2.739    84.859     0.150
     2.705    45.461     0.150
     2.705    49.660     0.150
     2.705    78.461     0.150
     2.705    85.059     0.150
     3.714    59.059     0.150
     3.714    65.859     0.150
     3.714    68.160     0.150
     3.714   100.961     0.150
     3.714   115.461     0.150
     3.739    60.160     0.150
     3.739   101.359     0.150
     3.739   116.258     0.150
     3.943    62.359     0.150
     3.943    71.258     0.150
     3.943   106.961     0.150
     3.943   123.160     0.150
     4.246    66.859     0.150
     4.246    78.758     0.150
     4.246   133.758     0.150
     4.344    67.059     0.150
     4.344    79.059     0.150
     4.344   116.258     0.150
     4.344   134.258     0.150
     4.885    75.758     0.150
     4.885    88.961     0.150
     4.885   152.359     0.150
     5.099   161.160     0.150
     5.422    99.258     0.150
     5.422   143.859     0.150
     5.422   169.359     0.150
     6.266    95.258     0.150
     6.266   195.559     0.150
     6.666    99.758     0.150
     6.666   122.660     0.150
     6.666   208.559     0.150
     6.882   102.559     0.150
     6.882   214.059     0.150
     7.497   112.359     0.150
     7.497   234.758     0.150
     7.631   238.758     0.150
     7.759   242.359     0.150
     8.634   269.758     0.150
     0.535    10.477     0.150
     0.535    17.383     0.150
     1.000    19.180     0.150
     1.000    32.281     0.150
     1.409    26.477     0.150
     1.409    45.078     0.150
     2.242    41.781     0.150
     2.242    71.680     0.150
     2.276    39.281     0.150
     2.276    41.781     0.150
     2.276    70.883     0.150
     2.431    41.977     0.150
     2.431    44.883     0.150
     2.431    77.078     0.150
     2.566    44.078     0.150
     2.566    47.180     0.150
     2.566    81.383     0.150
     3.584    58.180     0.150
     3.584   112.281     0.150
     3.899    61.883     0.150
     3.899    70.977     0.150
     3.899   120.781     0.150
     3.968    63.281     0.150
     3.968    73.578     0.150
     3.968   108.883     0.150
     3.968   125.180     0.150
     4.083   126.180     0.150
     4.103    65.383     0.150
     4.103    74.781     0.150
     4.103   127.281     0.150
     4.520   141.477     0.150
     5.203    95.180     0.150
     5.203   163.180     0.150
     0.758    23.812     0.150
     0.913    16.914     0.150
     0.913    29.016     0.150
     1.573    28.715     0.150
     1.573    48.715     0.150
     2.117    36.215     0.150
     2.117    38.914     0.150
     2.117    62.715     0.150
     2.117    67.312     0.150
     2.255    38.812     0.150
     2.255    41.016     0.150
     2.255    41.812     0.150
     2.255    65.812     0.150
     2.255    70.516     0.150
     2.336    42.016     0.150
     2.336    67.516     0.150
     2.336    72.715     0.150
     2.413    42.414     0.150
     2.413    69.016     0.150
     2.413    74.715     0.150
     2.444    41.516     0.150
     2.444    44.215     0.150
     2.444    71.215     0.150
     2.444    76.414     0.150
     3.135    50.312     0.150
     3.135    57.113     0.150
     3.135    87.312     0.150
     3.135    98.414     0.150
     3.461    55.414     0.150
     3.461    63.312     0.150
     3.461    95.414     0.150
     3.461   108.312     0.150
     3.796    59.914     0.150
     3.796    69.414     0.150
     3.796   103.016     0.150
     3.796   118.414     0.150
     4.011    62.516     0.150
     4.011    72.715     0.150
     4.011   107.215     0.150
     4.011   124.414     0.150
     4.199    65.613     0.150
     4.199    74.914     0.150
     4.199   111.414     0.150
     4.199   129.113     0.150
     4.211    64.516     0.150
     4.211    75.516     0.150
     4.211   111.715     0.150
     4.211   129.312     0.150
     4.403    79.414     0.150
     4.403   116.613     0.150
     4.403   136.016     0.150
     4.872   152.414     0.150
     5.007    76.312     0.150
     5.007    90.613     0.150
     5.007   132.715     0.150
     5.007   155.016     0.150
     5.847   181.914     0.150
     6.470   167.613     0.150
     6.470   201.414     0.150
     7.239   226.016     0.150
     7.295   228.215     0.150
    10.688   332.812     0.150
     0.331     7.441     0.150
     0.331    12.441     0.150
     0.331    12.842     0.150
     0.635    12.041     0.150
     0.635    12.541     0.150
     0.635    20.441     0.150
     1.609    28.643     0.150
     1.609    30.342     0.150
     1.609    49.643     0.150
     1.803    55.041     0.150
     1.803    31.541     0.150
     2.674    42.842     0.150
     2.674    48.041     0.150
     2.674    76.441     0.150
     2.674    84.541     0.150
     2.674    43.041     0.150
     2.674    47.842     0.150
     2.674    84.643     0.150
     2.733    49.041     0.150
     2.733    82.842     0.150
     2.733    43.541     0.150
     2.733    48.742     0.150
     2.733    76.242     0.150
     2.733    83.643     0.150
     3.055    49.143     0.150
     3.055    54.742     0.150
     3.055    85.342     0.150
     3.055    96.242     0.150
     3.284    52.242     0.150
     3.284   101.842     0.150
     3.284    90.342     0.150
     3.284   102.541     0.150
     3.326    52.541     0.150
     3.326    58.242     0.150
     3.326    90.143     0.150
     3.326   102.242     0.150
     4.031    73.143     0.150
     4.031   108.842     0.150
     4.031   126.143     0.150
     4.115    63.643     0.150
     4.115    74.342     0.150
     4.115   109.941     0.150
     4.115   127.242     0.150
     4.384    67.041     0.150
     4.384   136.041     0.150
     4.816    73.242     0.150
     4.816    86.842     0.150
     4.816    87.742     0.150
     4.816   125.342     0.150
     4.816   151.143     0.150
     5.310    80.342     0.150
     5.310    94.842     0.150
     5.310   138.143     0.150
     5.310   165.041     0.150
     5.814    86.742     0.150
     5.814   149.143     0.150
     5.874   183.842     0.150
     6.060    89.941     0.150
     6.060   190.541     0.150
     6.060   109.541     0.150
     6.060   157.643     0.150
     6.060   188.742     0.150
     6.897   102.041     0.150
     6.897   214.842     0.150
     7.246   226.643     0.150
     7.458   106.061     0.150
     7.458   187.262     0.150
     7.523   233.941     0.150
     7.784   199.643     0.150
     7.784   243.842     0.150
     8.277   121.143     0.150
     8.277   209.742     0.150
     8.277   257.541     0.150
     8.302   122.541     0.150
     8.302   258.643     0.150
     8.362   122.742     0.150
     8.362   212.242     0.150
     8.362   259.541     0.150
     8.600   267.242     0.150
     8.650   268.941     0.150
     8.712   271.342     0.150
     8.788   128.842     0.150
     8.788   221.643     0.150
     8.788   273.643     0.150
     9.253   288.742     0.150
     9.643   300.041     0.150
     9.889   250.242     0.150
     9.889   306.342     0.150
    10.343   320.643     0.150
    10.818   335.242     0.150
    10.987   156.541     0.150
    10.987   156.643     0.150
    11.347   285.143     0.150
    11.347   353.143     0.150
    11.630   167.441     0.150
    11.630   361.941     0.150
    11.905   169.266     0.150
    11.905   375.803     0.150
    17.645   244.492     0.150
    17.645   547.916     0.150
    17.645   244.941     0.150
    19.397   264.666     0.150
    19.397   266.441     0.150
    20.491   277.170     0.150
    22.383   297.203     0.150
    23.888   311.342     0.150
    24.252   316.842     0.150
    24.349   316.867     0.150
    24.468   318.191     0.150
    24.468   318.441     0.150
    37.362   430.205     0.150
    38.774   442.541     0.150
    38.774   442.643     0.150
    42.365   472.559     0.150
    43.819   483.748     0.150
    44.246   489.842     0.150
    47.653   513.242     0.150
    47.653   604.342     0.150
    49.213   525.893     0.150
    49.404   527.143     0.150
    49.404   527.439     0.150
    49.575   528.609     0.150
    53.832   560.564     0.150
    55.373   573.100     0.150
    72.323   684.217     0.150
    72.609   685.791     0.150
    73.438   692.143     0.150
    77.760   715.242     0.150
    77.760   714.842     0.150
    80.722   731.541     0.150
    81.366   735.320     0.150
   149.214  1186.316     0.150
   150.577  1189.439     0.150
     1.219    23.430     0.150
     1.219    24.930     0.150
     1.219    39.631     0.150
     1.632    31.531     0.150
     1.632    52.930     0.150
     1.755    55.531     0.150
     1.755    57.930     0.150
     2.072    37.730     0.150
     2.113    37.631     0.150
     2.113    38.730     0.150
     2.113    66.230     0.150
     2.667    45.131     0.150
     2.667    48.830     0.150
     2.667    85.230     0.150
     2.908    52.930     0.150
     2.908    91.930     0.150
     2.974    49.230     0.150
     2.974    54.031     0.150
     2.974    93.031     0.150
     3.296    53.830     0.150
     3.296    60.330     0.150
     3.296    92.031     0.150
     3.296   104.131     0.150
     3.869   120.830     0.150
     3.917    62.730     0.150
     3.917    71.930     0.150
     3.917   106.031     0.150
     3.917   123.031     0.150
     4.518    70.330     0.150
     4.518    82.730     0.150
     4.518   141.631     0.150
     4.524    70.930     0.150
     4.524    82.430     0.150
     4.524   141.631     0.150
     4.708    85.230     0.150
     4.708   147.131     0.150
     5.356   167.531     0.150
     5.723    87.930     0.150
     5.723   103.730     0.150
     5.723   178.930     0.150
     5.982   186.531     0.150
     6.958   217.531     0.150
     7.058   220.730     0.150
     7.246   226.531     0.150
     7.716   241.031     0.150
     8.107   252.531     0.150
     8.355   259.230     0.150
     9.302   289.430     0.150
     0.127     4.966     0.150
     0.127     7.966     0.150
     0.127     8.066     0.150
     1.456    46.366     0.150
     1.456    45.366     0.150
     1.964    33.966     0.150
     1.964    34.966     0.150
     1.964    60.066     0.150
     2.393    38.866     0.150
     2.393    42.366     0.150
     2.393    68.266     0.150
     2.393    42.466     0.150
     2.705    44.066     0.150
     2.705    49.766     0.150
     2.705    77.266     0.150
     2.705    84.766     0.150
     2.705    48.366     0.150
     2.705    83.866     0.150
     2.785    44.566     0.150
     2.785    50.266     0.150
     2.785    52.566     0.150
     2.785    86.566     0.150
     2.785    85.966     0.150
     2.959    47.766     0.150
     2.959    54.266     0.150
     2.959    83.466     0.150
     2.959    92.666     0.150
     2.959    54.066     0.150
     2.959    92.466     0.150
     3.673    57.266     0.150
     3.673    66.866     0.150
     3.673    99.366     0.150
     3.673   115.466     0.150
     3.673    66.966     0.150
     3.673   115.766     0.150
     3.690    57.466     0.150
     3.690    65.866     0.150
     3.690    99.866     0.150
     3.690   112.366     0.150
     3.839    58.566     0.150
     3.839    68.066     0.150
     3.839    69.666     0.150
     3.839   101.166     0.150
     4.028    62.466     0.150
     4.028    73.366     0.150
     4.028   108.066     0.150
     4.028   125.966     0.150
     4.028    62.566     0.150
     4.028    71.866     0.150
     4.028   106.166     0.150
     4.484    68.866     0.150
     4.484    81.366     0.150
     4.484   117.966     0.150
     4.484   140.066     0.150
     4.484   139.366     0.150
     4.952    75.066     0.150
     4.952    89.466     0.150
     4.952   128.966     0.150
     4.952   153.266     0.150
     4.952    76.166     0.150
     4.952    89.566     0.150
     5.679    86.166     0.150
     5.679   102.566     0.150
     5.679   149.166     0.150
     5.679   178.266     0.150
     5.747   104.466     0.150
     5.747   149.266     0.150
     5.747   179.466     0.150
     5.747    85.366     0.150
     5.747   104.166     0.150
     6.129    90.966     0.150
     6.129   109.366     0.150
     6.580   119.766     0.150
     6.580   205.266     0.150
     6.912   215.866     0.150
     7.210   225.766     0.150
     7.712   111.266     0.150
     7.712   109.466     0.150
     7.777   198.966     0.150
     7.777   242.166     0.150
     7.819   113.166     0.150
     8.035   118.166     0.150
     8.035   205.666     0.150
     8.035   250.166     0.150
     8.098   118.866     0.150
     8.098   204.066     0.150
     8.098   252.866     0.150
     8.098   116.566     0.150
     8.098   204.466     0.150
     8.287   207.866     0.150
     8.287   258.666     0.150
     8.336   260.066     0.150
     8.484   123.966     0.150
     8.484   264.566     0.150
     9.318   290.566     0.150
     9.562   240.066     0.150
     9.562   297.066     0.150
    10.013   311.366     0.150
    10.479   324.366     0.150
    11.031   343.566     0.150
    11.269   160.241     0.150
    11.269   351.491     0.150
    11.269   159.766     0.150
    11.352   352.966     0.150
    11.384   162.866     0.150
    11.651   165.966     0.150
    11.651   367.186     0.150
    13.754   195.066     0.150
    15.361   212.776     0.150
    15.361   213.766     0.150
    15.498   218.416     0.150
    15.627   227.166     0.150
    17.060   237.666     0.150
    17.950   248.866     0.150
    17.950   559.016     0.150
    17.950   248.066     0.150
    18.085   249.466     0.150
    18.248   570.266     0.150
    18.248   247.926     0.150
    19.035   260.766     0.150
    19.035   262.216     0.150
    19.620   267.466     0.150
    22.745   299.866     0.150
    22.745   301.416     0.150
    22.745   300.166     0.150
    23.888   313.366     0.150
    23.985   313.404     0.150
    23.985   753.891     0.150
    24.108   315.426     0.150
    24.108   315.266     0.150
    24.108   315.941     0.150
    24.108   315.746     0.150
    24.237   316.366     0.150
    27.229   342.530     0.150
    32.879   392.746     0.150
    34.801   409.146     0.150
    38.495   443.766     0.150
    39.222   446.947     0.150
    41.791   469.626     0.150
    42.792   475.816     0.150
    43.435   481.796     0.150
    43.567   482.256     0.150
    43.568   482.546     0.150
    43.568   481.891     0.150
    43.568   482.046     0.150
    44.264   486.836     0.150
    46.148   504.516     0.150
    46.698   505.436     0.150
    47.309   513.766     0.150
    48.961   526.096     0.150
    48.996   526.646     0.150
    49.149   527.116     0.150
    49.162   528.396     0.150
    49.182   525.716     0.150
    49.272   526.712     0.150
    49.336   529.796     0.150
    54.001   563.139     0.150
    60.521   609.986     0.150
    62.553   622.596     0.150
    73.689   693.491     0.150
    77.853   715.834     0.150
     0.103     3.289     0.150
     0.103     5.992     0.150
     0.836    16.195     0.150
     0.836    27.391     0.150
     1.074    19.891     0.150
     1.074    21.289     0.150
     1.074    34.289     0.150
     2.294    38.891     0.150
     2.490    40.789     0.150
     2.490    41.594     0.150
     2.490    45.195     0.150
     2.490    72.094     0.150
     2.490    78.594     0.150
     2.801    45.195     0.150
     2.801    51.695     0.150
     2.801    84.891     0.150
     3.266    50.594     0.150
     3.266    57.492     0.150
     3.544   111.391     0.150
     3.726    58.992     0.150
     3.726   115.891     0.150
     4.536   141.789     0.150
     4.882   151.492     0.150
     5.267    79.891     0.150
     5.267   164.195     0.150
     0.603    11.689     0.150
     0.603    19.389     0.150
     1.230    23.088     0.150
     1.230    39.488     0.150
     1.316    24.289     0.150
     1.316    42.088     0.150
     2.021    35.189     0.150
     2.021    36.988     0.150
     2.021    63.588     0.150
     2.181    38.088     0.150
     2.181    40.189     0.150
     2.181    69.389     0.150
     2.515    46.289     0.150
     2.515    79.289     0.150
     2.623    44.189     0.150
     2.623    47.789     0.150
     2.623    82.789     0.150
     2.677    44.088     0.150
     2.677    48.689     0.150
     2.677    82.789     0.150
     3.798    69.088     0.150
     3.798   119.289     0.150
     3.823    69.789     0.150
     3.823   119.889     0.150
     3.859    60.988     0.150
     3.859    70.588     0.150
     3.859   105.689     0.150
     3.859   120.389     0.150
     4.163    65.389     0.150
     4.163    76.588     0.150
     4.163   112.289     0.150
     4.163   131.588     0.150
     4.296    67.088     0.150
     4.296    78.588     0.150
     4.296   134.689     0.150
     5.044   158.389     0.150
     5.343    81.389     0.150
     5.343    97.088     0.150
     5.343   140.588     0.150
     5.343   167.088     0.150
     6.187   192.789     0.150
     7.384   230.189     0.150
     7.447   232.588     0.150
     7.678   239.389     0.150
     8.555   266.088     0.150
    10.167   315.789     0.150
    11.056   343.189     0.150
    11.268   350.588     0.150
     0.621    12.172     0.150
     0.621    19.973     0.150
     1.244    23.574     0.150
     1.244    26.273     0.150
     1.244    39.875     0.150
     1.244    44.074     0.150
     1.313    24.172     0.150
     1.313    41.875     0.150
     2.030    36.273     0.150
     2.030    37.172     0.150
     2.030    64.172     0.150
     2.169    37.672     0.150
     2.169    40.375     0.150
     2.169    69.574     0.150
     2.509    46.473     0.150
     2.509    78.574     0.150
     2.612    43.574     0.150
     2.612    47.672     0.150
     2.612    82.473     0.150
     2.682    43.574     0.150
     2.682    48.473     0.150
     2.682    82.375     0.150
     3.530    65.973     0.150
     3.530   110.574     0.150
     3.832    62.074     0.150
     3.832    70.375     0.150
     3.832   104.672     0.150
     3.832   120.875     0.150
     3.852    60.672     0.150
     3.852    70.172     0.150
     3.852   119.773     0.150
     4.152    76.574     0.150
     4.152   112.574     0.150
     4.152   130.074     0.150
     4.305    78.273     0.150
     4.305   133.172     0.150
     5.027   159.375     0.150
     5.330    81.074     0.150
     5.330    98.172     0.150
     5.330   167.375     0.150
     6.174   113.473     0.150
     6.174   193.773     0.150
     6.573    98.473     0.150
     6.573   120.375     0.150
     6.573   170.074     0.150
     6.573   205.375     0.150
     6.790   212.473     0.150
     7.429   110.375     0.150
     7.429   231.973     0.150
     7.666   239.574     0.150
     8.935   279.375     0.150
     0.175     4.086     0.150
     0.175     6.684     0.150
     0.828    16.184     0.150
     0.828    27.184     0.150
     1.062    19.586     0.150
     2.263    38.586     0.150
     2.263    65.984     0.150
     2.375    40.785     0.150
     2.820    45.387     0.150
     2.820    85.484     0.150
     2.880    46.086     0.150
     2.880    51.586     0.150
     2.880    88.887     0.150
     3.290    50.984     0.150
     3.290    58.184     0.150
     3.290    99.184     0.150
     3.510   109.984     0.150
     3.674    58.484     0.150
     3.674    67.387     0.150
     3.674   115.684     0.150
     4.509   140.586     0.150
     4.851    74.285     0.150
     4.851   150.785     0.150
     5.215    79.887     0.150
     5.215    95.387     0.150
     5.215   163.785     0.150
     0.795    15.430     0.150
     0.795    25.727     0.150
     1.331    24.828     0.150
     1.331    26.527     0.150
     1.331    42.227     0.150
     1.331    46.027     0.150
     1.360    25.727     0.150
     1.360    43.328     0.150
     2.036    36.527     0.150
     2.036    38.328     0.150
     2.036    66.227     0.150
     2.485    46.129     0.150
     2.485    78.828     0.150
     2.547    43.828     0.150
     2.547    46.828     0.150
     2.547    79.430     0.150
     2.770    50.227     0.150
     2.770    86.129     0.150
     3.823    70.129     0.150
     3.823   119.727     0.150
     3.837    61.227     0.150
     3.837    70.227     0.150
     3.837   107.328     0.150
     3.837   120.227     0.150
     3.891    71.430     0.150
     3.891   121.930     0.150
     4.083    65.027     0.150
     4.083    75.027     0.150
     4.083   127.727     0.150
     4.423    68.828     0.150
     4.423    81.328     0.150
     4.423   119.930     0.150
     4.423   137.727     0.150
     4.871   153.430     0.150
     5.235    81.727     0.150
     5.235    95.930     0.150
     5.235   142.227     0.150
     5.235   164.227     0.150
     0.811    25.875     0.150
     0.811    26.074     0.150
     1.368    25.676     0.150
     1.368    28.574     0.150
     1.368    43.676     0.150
     1.338    24.875     0.150
     1.338    26.773     0.150
     1.338    42.676     0.150
     1.338    24.977     0.150
     1.338    42.273     0.150
     2.091    37.375     0.150
     2.091    66.273     0.150
     2.091    37.676     0.150
     2.091    39.875     0.150
     2.091    63.977     0.150
     2.091    66.477     0.150
     2.020    36.574     0.150
     2.020    38.176     0.150
     2.020    64.574     0.150
     2.020    37.176     0.150
     2.488    42.773     0.150
     2.488    46.176     0.150
     2.488    79.074     0.150
     2.488    44.074     0.150
     2.488    74.574     0.150
     2.488    78.875     0.150
     2.546    43.676     0.150
     2.546    73.273     0.150
     2.546    80.176     0.150
     2.783    45.574     0.150
     2.783    50.273     0.150
     2.783    80.375     0.150
     2.783    86.477     0.150
     2.783    54.375     0.150
     2.783    86.977     0.150
     3.515    56.875     0.150
     3.515    64.875     0.150
     3.515   111.574     0.150
     3.515   110.977     0.150
     3.836    61.176     0.150
     3.836    69.977     0.150
     3.836   107.676     0.150
     3.836   119.273     0.150
     3.893    62.074     0.150
     3.893    70.574     0.150
     3.893   104.875     0.150
     3.893   120.676     0.150
     3.893   108.176     0.150
     3.893   120.375     0.150
     3.826    61.273     0.150
     3.826    70.176     0.150
     3.826   119.977     0.150
     3.826    69.977     0.150
     3.826   118.875     0.150
     4.081    64.977     0.150
     4.081    75.375     0.150
     4.081   110.477     0.150
     4.081   129.074     0.150
     4.081    75.176     0.150
     4.081   111.676     0.150
     4.081   126.773     0.150
     4.438    68.875     0.150
     4.438    81.477     0.150
     4.438   119.574     0.150
     4.438   138.574     0.150
     4.858    75.176     0.150
     4.858    89.574     0.150
     4.858    74.977     0.150
     4.858   133.176     0.150
     4.858   153.176     0.150
     5.230    80.676     0.150
     5.230    95.676     0.150
     5.230   139.574     0.150
     5.230    80.477     0.150
     5.836    89.074     0.150
     5.836   107.676     0.150
     5.836   154.375     0.150
     6.492    97.773     0.150
     6.492   168.977     0.150
     6.687   173.875     0.150
     6.931   101.754     0.150
     7.255   187.273     0.150
     7.271   110.375     0.150
     7.425   110.977     0.150
     7.576   112.074     0.150
     7.576   195.773     0.150
     7.576   112.375     0.150
     7.757   116.273     0.150
     8.138   120.273     0.150
     8.447   121.793     0.150
     8.447   257.242     0.150
     8.447   122.273     0.150
     8.447   218.773     0.150
     8.446   125.977     0.150
     8.446   264.875     0.150
     8.840   130.176     0.150
     8.840   274.875     0.150
     8.931   278.676     0.150
     8.931   131.375     0.150
     9.093   133.773     0.150
     9.093   284.375     0.150
     9.559   140.875     0.150
     9.559   298.273     0.150
    10.076   147.875     0.150
    10.076   312.977     0.150
    10.510   154.676     0.150
    10.510   327.875     0.150
    10.510   154.273     0.150
    10.808   156.648     0.150
    10.808   338.699     0.150
    10.649   155.297     0.150
    10.649   157.477     0.150
    10.933   158.535     0.150
    10.933   344.996     0.150
    10.933   159.266     0.150
    10.970   161.574     0.150
    10.970   341.074     0.150
    10.970   161.875     0.150
    11.201   163.875     0.150
    11.201   346.773     0.150
    11.940   172.875     0.150
    12.199   175.074     0.150
    12.280   178.676     0.150
    13.205   188.977     0.150
    13.650   197.773     0.150
    13.650   195.664     0.150
    14.743   211.074     0.150
    14.874   216.625     0.150
    14.874   213.977     0.150
    14.874   212.625     0.150
    14.874   468.926     0.150
    14.874   215.336     0.150
    15.766   226.773     0.150
    15.840   231.773     0.150
    16.120   227.773     0.150
    16.120   234.773     0.150
    16.143   228.766     0.150
    17.377   246.176     0.150
    17.677   247.742     0.150
    17.677   551.742     0.150
    17.677   249.227     0.150
    17.830   250.574     0.150
    17.830   448.074     0.150
    18.543   258.250     0.150
    18.543   579.000     0.150
    18.543   257.477     0.150
    18.776   283.074     0.150
    18.844   263.977     0.150
    19.041   266.375     0.150
    19.041   266.301     0.150
    19.041   600.422     0.150
    19.041   266.586     0.150
    19.408   270.273     0.150
    19.514   272.086     0.150
    19.691   272.926     0.150
    19.693   272.914     0.150
    19.820   274.324     0.150
    19.820   626.293     0.150
    19.820   274.906     0.150
    19.907   275.676     0.150
    20.590   282.074     0.150
    20.590   509.676     0.150
    20.730   285.664     0.150
    20.730   284.773     0.150
    21.502   293.266     0.150
    21.888   299.273     0.150
    21.888   319.676     0.150
    21.888   570.977     0.150
    22.067   296.797     0.150
    22.214   301.477     0.150
    22.214   543.273     0.150
    22.965   306.676     0.150
    22.965   306.355     0.150
    22.965   307.066     0.150
    22.833   310.074     0.150
    22.938   306.773     0.150
    22.938   556.074     0.150
    23.074   561.914     0.150
    23.527   313.164     0.150
    23.510   313.465     0.150
    23.870   315.027     0.150
    23.838   316.137     0.150
    23.838   316.977     0.150
    23.878   316.875     0.150
    23.878   317.477     0.150
    23.878   316.023     0.150
    23.878   754.887     0.150
    23.878   317.023     0.150
    23.933   316.984     0.150
    24.044   318.914     0.150
    24.055   321.773     0.150
    24.055   538.176     0.150
    24.874   324.934     0.150
    24.874   324.477     0.150
    24.658   322.574     0.150
    25.101   326.977     0.150
    25.101   595.574     0.150
    25.362   332.977     0.150
    25.681   336.773     0.150
    26.515   341.746     0.150
    27.122   345.004     0.150
    27.110   348.875     0.150
    27.110   628.773     0.150
    27.344   347.449     0.150
    27.387   349.246     0.150
    27.387   348.574     0.150
    27.515   348.156     0.150
    27.722   348.746     0.150
    27.947   354.086     0.150
    27.970   351.785     0.150
    28.970   361.137     0.150
    29.049   363.246     0.150
    30.011   374.434     0.150
    30.105   374.977     0.150
    30.204   372.844     0.150
    30.396   377.613     0.150
    30.545   379.297     0.150
    30.738   682.676     0.150
    30.810   381.305     0.150
    30.810   381.547     0.150
    30.810   380.977     0.150
    30.905   379.773     0.150
    31.193   384.516     0.150
    31.829   390.977     0.150
    31.829   702.273     0.150
    31.829   808.773     0.150
    32.115   389.836     0.150
    32.115   453.273     0.150
    32.115   703.676     0.150
    32.115   813.273     0.150
    32.728   396.863     0.150
    32.728   397.047     0.150
    32.728   396.645     0.150
    33.621   402.766     0.150
    33.747   403.656     0.150
    34.140   411.477     0.150
    34.140   486.074     0.150
    34.140   738.477     0.150
    34.919   415.484     0.150
    34.919   415.625     0.150
    35.197   416.773     0.150
    35.636   420.977     0.150
    36.157   424.996     0.150
    36.018   426.676     0.150
    36.578   428.676     0.150
    36.578   429.344     0.150
    36.330   430.176     0.150
    36.409   430.176     0.150
    36.489   429.887     0.150
    36.996   431.504     0.150
    36.996   432.383     0.150
    36.845   431.375     0.150
    36.917   435.477     0.150
    37.793   438.480     0.150
    37.522   521.676     0.150
    39.011   446.773     0.150
    39.766   455.941     0.150
    39.773   456.125     0.150
    39.540   455.637     0.150
    39.845   456.895     0.150
    39.887   456.684     0.150
    39.932   456.449     0.150
    40.074   458.469     0.150
    40.085   458.699     0.150
    40.112   458.621     0.150
    40.292   459.555     0.150
    40.356   460.285     0.150
    40.356   460.664     0.150
    40.415   457.105     0.150
    40.243   460.023     0.150
    40.243   583.227     0.150
    40.243   461.977     0.150
    40.595   462.438     0.150
    40.639   463.234     0.150
    40.720   463.578     0.150
    40.794   464.324     0.150
    40.794   464.207     0.150
    40.877   464.105     0.150
    40.877   464.730     0.150
    40.993   466.016     0.150
    40.994   466.039     0.150
    41.077   467.008     0.150
    41.110   467.824     0.150
    41.174   467.258     0.150
    41.207   467.578     0.150
    41.213   468.230     0.150
    41.338   468.555     0.150
    41.338   468.270     0.150
    41.377   469.039     0.150
    41.483   470.281     0.150
    41.542   470.445     0.150
    41.542   470.727     0.150
    41.620   471.145     0.150
    41.848   473.395     0.150
    41.848   472.996     0.150
    41.862   473.137     0.150
    41.876   473.406     0.150
    41.876   473.020     0.150
    41.892   473.574     0.150
    41.916   473.875     0.150
    41.978   474.168     0.150
    42.066   473.910     0.150
    42.093   474.223     0.150
    42.163   476.336     0.150
    42.211   476.059     0.150
    42.258   476.645     0.150
    42.275   476.328     0.150
    42.286   476.844     0.150
    42.286   476.410     0.150
    42.285   476.824     0.150
    42.299   476.836     0.150
    42.337   477.461     0.150
    42.413   477.555     0.150
    42.413   478.098     0.150
    42.419   477.566     0.150
    42.482   478.449     0.150
    42.510   477.770     0.150
    42.578   479.211     0.150
    42.594   479.035     0.150
    42.616   479.766     0.150
    42.701   479.996     0.150
    42.701   479.766     0.150
    42.718   480.324     0.150
    42.601   477.773     0.150
    42.601   578.074     0.150
    42.787   480.953     0.150
    42.909   482.062     0.150
    42.967   481.953     0.150
    42.967   482.203     0.150
    42.970   482.355     0.150
    42.970   482.105     0.150
    42.976   482.371     0.150
    43.039   483.312     0.150
    43.075   483.027     0.150
    43.109   483.523     0.150
    43.117   482.945     0.150
    43.208   484.664     0.150
    43.208   484.465     0.150
    43.242   484.254     0.150
    43.284   484.242     0.150
    43.297   484.875     0.150
    43.297   484.523     0.150
    43.358   484.484     0.150
    43.358   485.359     0.150
    43.366   485.164     0.150
    43.366   485.074     0.150
    43.366   485.375     0.150
    43.396   485.945     0.150
    43.171   485.148     0.150
    43.171   485.934     0.150
    43.171   487.074     0.150
    43.171   487.047     0.150
    43.520   485.945     0.150
    43.557   486.188     0.150
    43.456   485.977     0.150
    43.456   588.676     0.150
    43.679   487.531     0.150
    43.732   487.535     0.150
    43.826   488.594     0.150
    43.832   488.488     0.150
    43.885   489.559     0.150
    43.891   489.316     0.150
    43.913   488.777     0.150
    43.964   490.145     0.150
    43.971   489.918     0.150
    43.986   489.426     0.150
    44.143   490.578     0.150
    44.231   491.531     0.150
    44.280   492.336     0.150
    44.162   490.500     0.150
    44.162   490.176     0.150
    44.162   490.375     0.150
    44.317   492.477     0.150
    44.332   491.223     0.150
    44.406   493.395     0.150
    44.435   493.379     0.150
    44.505   493.848     0.150
    44.608   495.051     0.150
    44.614   493.461     0.150
    44.640   494.234     0.150
    44.675   494.527     0.150
    44.701   494.152     0.150
    44.802   495.309     0.150
    44.846   495.559     0.150
    44.854   495.230     0.150
    44.868   497.035     0.150
    44.868   496.176     0.150
    44.978   496.754     0.150
    44.944   496.922     0.150
    44.952   496.867     0.150
    44.971   496.547     0.150
    45.188   497.422     0.150
    45.231   499.191     0.150
    45.311   500.695     0.150
    45.311   500.062     0.150
    45.339   500.637     0.150
    45.339   499.730     0.150
    45.373   500.445     0.150
    45.417   500.496     0.150
    45.421   500.746     0.150
    45.440   501.148     0.150
    45.478   502.125     0.150
    45.478   501.398     0.150
    45.675   503.168     0.150
    45.692   503.441     0.150
    45.710   504.164     0.150
    45.591   899.676     0.150
    45.858   505.148     0.150
    45.861   504.688     0.150
    46.089   507.195     0.150
    46.128   507.656     0.150
    46.184   507.797     0.150
    46.184   508.258     0.150
    46.197   507.555     0.150
    46.199   507.211     0.150
    46.358   508.227     0.150
    46.374   509.320     0.150
    46.624   511.426     0.150
    46.624   511.035     0.150
    46.850   511.836     0.150
    46.864   512.523     0.150
    46.946   512.363     0.150
    46.896   512.137     0.150
    47.053   513.094     0.150
    47.124   515.098     0.150
    47.418   516.809     0.150
    47.512   518.652     0.150
    47.662   518.297     0.150
    47.508   521.336     0.150
    47.508   520.074     0.150
    47.508   935.477     0.150
    47.756   520.430     0.150
    47.549   518.773     0.150
    47.549   518.977     0.150
    47.824   520.832     0.150
    47.671   520.875     0.150
    47.791   628.887     0.150
    47.791   933.785     0.150
    47.791  1143.926     0.150
    47.791   605.676     0.150
    47.791  1109.977     0.150
    48.090   521.855     0.150
    47.986   524.176     0.150
    47.969   523.273     0.150
    48.231   524.191     0.150
    48.286   522.988     0.150
    48.444   525.062     0.150
    48.723   526.777     0.150
    48.821   528.074     0.150
    48.907   528.133     0.150
    48.740   530.445     0.150
    48.740   644.516     0.150
    49.190   530.723     0.150
    49.206   530.926     0.150
    49.294   531.855     0.150
    49.336   533.164     0.150
    49.336   531.906     0.150
    49.331   531.375     0.150
    49.331   647.477     0.150
    49.331   958.375     0.150
    49.616   533.574     0.150
    49.616   534.023     0.150
    49.737   534.875     0.150
    49.695   534.477     0.150
    49.695   535.996     0.150
    49.695   535.375     0.150
    49.695   534.676     0.150
    49.893   535.684     0.150
    49.847   535.273     0.150
    50.486   539.848     0.150
    50.579   540.797     0.150
    50.944   542.852     0.150
    51.264   546.465     0.150
    51.264   545.914     0.150
    51.414   547.352     0.150
    51.709   548.812     0.150
    51.883   550.473     0.150
    52.100   550.730     0.150
    52.381   553.582     0.150
    52.671   555.695     0.150
    52.675   555.703     0.150
    52.706   556.641     0.150
    52.704   559.477     0.150
    52.704  1003.477     0.150
    53.544   562.266     0.150
    53.565   562.238     0.150
    53.754   563.555     0.150
    53.722   565.785     0.150
    53.735   565.234     0.150
    54.083   566.570     0.150
    54.052   566.215     0.150
    54.152   567.156     0.150
    54.223   567.684     0.150
    54.241   567.699     0.150
    54.273   567.645     0.150
    54.587   570.598     0.150
    54.713   570.969     0.150
    54.856   571.574     0.150
    55.270   576.773     0.150
    55.356   578.477     0.150
    55.506   580.875     0.150
    55.603   581.176     0.150
    55.648   581.477     0.150
    55.712   580.375     0.150
    55.722   580.273     0.150
    55.726   581.773     0.150
    55.800   582.176     0.150
    56.006   584.176     0.150
    56.247   587.074     0.150
    56.373  1061.875     0.150
    56.378   586.875     0.150
    56.510   588.875     0.150
    56.612   589.574     0.150
    56.649   589.176     0.150
    56.784   588.977     0.150
    56.923   587.227     0.150
    57.728   596.477     0.150
    57.799   595.074     0.150
    57.799   595.273     0.150
    57.799   594.574     0.150
    57.966   595.754     0.150
    57.966   595.000     0.150
    57.966   597.094     0.150
    59.062   604.719     0.150
    59.404   607.652     0.150
    59.485   607.773     0.150
    60.641   615.137     0.150
    61.094   618.836     0.150
    62.642   626.023     0.150
    62.660   627.266     0.150
    64.809   640.465     0.150
    65.451   646.215     0.150
    66.285   651.766     0.150
    66.285   650.715     0.150
    68.590   665.523     0.150
    68.590   665.844     0.150
    68.835   666.633     0.150
    69.065   669.934     0.150
    69.109   670.066     0.150
    69.370   670.387     0.150
    69.354   668.398     0.150
    69.431   671.566     0.150
    69.963   674.734     0.150
    70.001   674.395     0.150
    70.001   674.523     0.150
    70.001   674.238     0.150
    70.324   677.176     0.150
    70.340   674.773     0.150
    70.426   677.227     0.150
    70.648   679.547     0.150
    70.717   680.094     0.150
    70.808   680.375     0.150
    71.071   680.039     0.150
    71.174   681.664     0.150
    71.314   682.328     0.150
    71.590   684.625     0.150
    71.590   683.730     0.150
    71.746   683.980     0.150
    71.835   685.824     0.150
    72.187   686.102     0.150
    72.361   689.625     0.150
    72.527   691.363     0.150
    72.582   688.641     0.150
    72.676   690.047     0.150
    73.006   693.953     0.150
    73.073   693.496     0.150
    73.423   694.102     0.150
    73.423   693.637     0.150
    73.452   695.945     0.150
    73.515   696.875     0.150
    73.623   696.227     0.150
    73.623   695.730     0.150
    73.623   696.074     0.150
    73.623   695.070     0.150
    73.623   695.727     0.150
    74.013   699.496     0.150
    74.041   698.176     0.150
    74.041   697.832     0.150
    74.420   701.676     0.150
    74.666   701.434     0.150
    74.666   701.664     0.150
    74.696   700.816     0.150
    74.852   703.508     0.150
    74.914   702.820     0.150
    75.004   703.227     0.150
    75.091   703.824     0.150
    75.506   707.465     0.150
    75.601   708.836     0.150
    75.651   707.676     0.150
    75.754   707.336     0.150
    75.763   707.469     0.150
    75.763   707.766     0.150
    76.033   710.152     0.150
    76.204   711.453     0.150
    76.247   711.992     0.150
    76.244   710.637     0.150
    76.329   710.746     0.150
    76.329   710.906     0.150
    76.380   711.738     0.150
    76.424   712.121     0.150
    76.446   712.898     0.150
    76.558   712.895     0.150
    76.571   714.844     0.150
    76.689   714.297     0.150
    76.775   714.230     0.150
    76.810   714.605     0.150
    76.921   715.004     0.150
    76.995   716.797     0.150
    76.835   713.926     0.150
    77.104   716.113     0.150
    77.129   717.086     0.150
    76.992   714.766     0.150
    76.992   716.074     0.150
    77.243   717.172     0.150
    76.999   714.500     0.150
    76.999   715.086     0.150
    77.001   714.945     0.150
    77.293   718.727     0.150
    77.412   717.801     0.150
    77.541   719.023     0.150
    77.539   718.172     0.150
    77.550   719.176     0.150
    77.550   719.359     0.150
    77.550   719.496     0.150
    77.594   719.379     0.150
    77.647   719.758     0.150
    77.688   720.906     0.150
    77.737   720.336     0.150
    77.833   721.234     0.150
    77.955   720.652     0.150
    78.040   721.840     0.150
    78.064   721.621     0.150
    78.143   721.215     0.150
    78.334   723.473     0.150
    78.343   723.820     0.150
    78.459   723.559     0.150
    78.469   723.910     0.150
    78.500   723.637     0.150
    78.609   725.609     0.150
    78.631   726.172     0.150
    78.843   725.258     0.150
    78.997   727.625     0.150
    79.015   727.863     0.150
    79.051   728.352     0.150
    79.086   728.164     0.150
    79.196   728.520     0.150
    79.362   729.438     0.150
    79.369   729.398     0.150
    79.382   730.094     0.150
    79.470   729.551     0.150
    79.546   730.645     0.150
    79.546   730.750     0.150
    79.629   730.992     0.150
    79.710   731.445     0.150
    80.013   733.234     0.150
    80.207   731.668     0.150
    80.348   734.957     0.150
    80.365   733.785     0.150
    80.365   734.273     0.150
    80.375   734.586     0.150
    80.477   735.141     0.150
    80.490   734.527     0.150
    80.511   735.984     0.150
    80.594   734.375     0.150
    80.936   737.805     0.150
    80.949   736.582     0.150
    81.138   738.246     0.150
    81.372   738.094     0.150
    81.428   738.059     0.150
    81.733   742.047     0.150
    81.733   741.375     0.150
    81.733   742.199     0.150
    82.014   741.418     0.150
    82.222   742.648     0.150
    82.392   743.066     0.150
    82.646   745.551     0.150
    82.638   744.227     0.150
    82.690   745.207     0.150
    82.793   746.000     0.150
    82.842   746.273     0.150
    82.961   746.926     0.150
    83.026   748.746     0.150
    83.107   747.156     0.150
    83.276   748.445     0.150
    83.361   749.102     0.150
    83.496   750.605     0.150
    83.496   750.168     0.150
    83.730   751.344     0.150
    83.782   751.035     0.150
    83.785   751.883     0.150
    83.934   752.098     0.150
    83.979   752.180     0.150
    84.040   752.344     0.150
    84.245   754.727     0.150
    84.411   754.746     0.150
    84.841   755.445     0.150
    84.887   756.496     0.150
    85.066   758.645     0.150
    85.733   759.422     0.150
    85.906   760.520     0.150
    85.983   761.172     0.150
    86.765   764.555     0.150
    87.196   767.238     0.150
    87.808   771.676     0.150
    93.134   796.312     0.150
   143.244  1177.555     0.150
   149.562  1191.012     0.150
   150.060  1192.375     0.150
   151.238  1193.910     0.150
   152.742  1197.660     0.150
   153.050  1200.070     0.150
   153.448  1197.754     0.150
     0.818    15.844     0.150
     0.818    26.547     0.150
     1.341    25.246     0.150
     1.341    42.645     0.150
     1.341    46.246     0.150
     1.341    25.145     0.150
     1.372    25.844     0.150
     1.372    28.145     0.150
     1.372    47.746     0.150
     2.015    38.145     0.150
     2.015    65.344     0.150
     2.093    36.344     0.150
     2.093    38.047     0.150
     2.093    66.047     0.150
     2.093    37.844     0.150
     2.093    39.547     0.150
     2.093    67.047     0.150
     2.489    43.047     0.150
     2.489    46.246     0.150
     2.489    78.645     0.150
     2.489    46.445     0.150
     2.489    78.047     0.150
     2.545    43.844     0.150
     2.545    46.945     0.150
     2.545    73.844     0.150
     2.545    79.746     0.150
     2.545    46.844     0.150
     2.545    80.047     0.150
     2.788    45.746     0.150
     2.788    50.547     0.150
     2.788    79.344     0.150
     2.788    86.645     0.150
     2.788    50.047     0.150
     3.516    56.246     0.150
     3.516    63.945     0.150
     3.516    96.746     0.150
     3.516   110.344     0.150
     3.516   111.445     0.150
     3.836    60.945     0.150
     3.836    69.445     0.150
     3.836    70.246     0.150
     3.836   105.344     0.150
     3.836   119.145     0.150
     3.826    61.344     0.150
     3.826    69.746     0.150
     3.826   104.246     0.150
     3.826   120.145     0.150
     3.826    61.445     0.150
     3.826   105.344     0.150
     3.826   118.945     0.150
     3.894    62.246     0.150
     3.894    70.246     0.150
     3.894   107.945     0.150
     3.894   120.547     0.150
     3.894    62.047     0.150
     3.894    70.145     0.150
     3.894   107.844     0.150
     3.894   120.445     0.150
     4.080    65.047     0.150
     4.080    74.547     0.150
     4.080   111.945     0.150
     4.080   127.746     0.150
     4.080    64.844     0.150
     4.080    73.844     0.150
     4.080   127.445     0.150
     4.444    69.047     0.150
     4.444    81.246     0.150
     4.444   119.246     0.150
     4.444   139.246     0.150
     4.853    87.945     0.150
     4.853   152.645     0.150
     4.853    75.445     0.150
     4.853   152.445     0.150
     5.227    80.547     0.150
     5.227    95.246     0.150
     5.227   138.445     0.150
     5.227   163.047     0.150
     5.227    80.445     0.150
     6.491    97.746     0.150
     6.491   117.746     0.150
     6.491   168.746     0.150
     6.491   202.445     0.150
     6.684   100.445     0.150
     6.684   121.746     0.150
     6.684   173.645     0.150
     6.684   209.145     0.150
     7.249   108.844     0.150
     7.249   187.645     0.150
     7.249   226.047     0.150
     7.269   227.047     0.150
     7.422   231.145     0.150
     7.574   112.445     0.150
     7.574   235.047     0.150
     7.574   135.945     0.150
     7.574   196.945     0.150
     7.754   241.746     0.150
     7.808   243.746     0.150
     8.133   120.445     0.150
     8.133   150.746     0.150
     8.133   254.145     0.150
     8.444   263.145     0.150
     8.452   256.766     0.150
     8.452   149.344     0.150
     8.838   129.844     0.150
     8.838   224.547     0.150
     8.838   257.047     0.150
     8.838   275.645     0.150
     9.091   284.344     0.150
     9.557   297.445     0.150
    10.074   312.844     0.150
    10.507   326.945     0.150
    10.804   154.195     0.150
    10.804   269.496     0.150
    10.928   156.234     0.150
    10.968   340.246     0.150
    11.200   163.547     0.150
    11.200   348.645     0.150
    17.680   246.645     0.150
    17.827   258.246     0.150
    23.878   313.926     0.150
    24.878   321.746     0.150
    44.167   487.844     0.150
    54.862   570.273     0.150
    76.992   713.562     0.150
     0.797    15.375     0.150
     0.797    25.676     0.150
     1.329    24.875     0.150
     1.329    42.074     0.150
     1.329    46.176     0.150
     1.363    25.477     0.150
     1.363    43.277     0.150
     2.036    36.477     0.150
     2.036    38.074     0.150
     2.036    64.676     0.150
     2.092    36.977     0.150
     2.092    39.074     0.150
     2.092    66.074     0.150
     2.482    78.176     0.150
     2.544    46.676     0.150
     2.544    79.477     0.150
     2.769    50.176     0.150
     2.769    53.074     0.150
     2.769    85.977     0.150
     3.821   119.477     0.150
     3.839    60.977     0.150
     3.839    70.074     0.150
     3.839   120.176     0.150
     4.080    64.676     0.150
     4.080    74.477     0.150
     4.080   127.875     0.150
     4.423    80.574     0.150
     4.423   137.676     0.150
     5.232    95.375     0.150
     5.232   163.574     0.150
     0.804    15.555     0.150
     0.804    26.055     0.150
     1.329    24.855     0.150
     1.329    26.555     0.150
     1.329    42.254     0.150
     1.329    46.152     0.150
     1.369    25.652     0.150
     1.369    43.355     0.150
     2.031    36.855     0.150
     2.031    38.055     0.150
     2.031    65.055     0.150
     2.096    37.355     0.150
     2.096    38.953     0.150
     2.096    66.555     0.150
     2.481    78.652     0.150
     2.541    46.652     0.150
     2.541    79.953     0.150
     2.772    50.254     0.150
     2.772    86.254     0.150
     3.507   109.555     0.150
     3.819    60.953     0.150
     3.819    69.152     0.150
     3.819   119.254     0.150
     3.842    60.855     0.150
     3.842    70.355     0.150
     3.842   120.152     0.150
     4.076    64.652     0.150
     4.076    74.555     0.150
     4.076   127.355     0.150
     5.227    80.254     0.150
     5.227    95.254     0.150
     5.227   163.254     0.150
     0.787    15.082     0.150
     0.787    25.484     0.150
     1.345    25.281     0.150
     1.345    42.883     0.150
     1.344    24.883     0.150
     1.344    26.383     0.150
     1.344    42.281     0.150
     1.344    45.781     0.150
     2.032    36.082     0.150
     2.032    37.883     0.150
     2.032    64.484     0.150
     2.073    37.082     0.150
     2.073    38.281     0.150
     2.073    65.484     0.150
     2.500    46.484     0.150
     2.500    79.582     0.150
     2.563    43.383     0.150
     2.563    46.781     0.150
     2.563    80.383     0.150
     2.779    50.484     0.150
     2.779    79.383     0.150
     2.779    86.383     0.150
     3.526   110.984     0.150
     3.821    60.781     0.150
     3.821    69.781     0.150
     3.821   119.582     0.150
     3.838    60.984     0.150
     3.838    70.184     0.150
     3.838   119.781     0.150
     4.099    64.781     0.150
     4.099    74.883     0.150
     4.099   127.781     0.150
     4.429   137.984     0.150
     4.883   152.684     0.150
     5.250    80.383     0.150
     5.250    95.984     0.150
     5.250   164.184     0.150
     0.799    15.324     0.150
     0.799    26.023     0.150
     1.339    25.023     0.150
     1.339    26.422     0.150
     1.339    42.324     0.150
     1.339    46.422     0.150
     2.028    36.824     0.150
     2.028    38.023     0.150
     2.028    64.723     0.150
     2.085    38.223     0.150
     2.085    66.125     0.150
     2.492    46.223     0.150
     2.492    78.922     0.150
     2.552    43.625     0.150
     2.552    46.824     0.150
     2.552    80.523     0.150
     2.779    50.723     0.150
     2.779    86.523     0.150
     3.830    61.023     0.150
     3.830    70.023     0.150
     3.830   104.523     0.150
     3.830   119.523     0.150
     3.831    61.023     0.150
     3.831    70.023     0.150
     3.831   107.422     0.150
     3.831   119.824     0.150
     3.886    62.023     0.150
     3.886    71.422     0.150
     3.886   121.523     0.150
     4.087    64.922     0.150
     4.087    74.625     0.150
     4.087   127.625     0.150
     4.432    68.922     0.150
     4.432    82.023     0.150
     4.432   118.723     0.150
     4.432   137.824     0.150
     4.870   152.523     0.150
     5.238    80.523     0.150
     5.238   163.625     0.150
     6.695   208.324     0.150
     0.793    15.328     0.150
     0.793    25.531     0.150
     1.348    24.930     0.150
     1.348    26.734     0.150
     1.348    42.633     0.150
     2.026    36.234     0.150
     2.026    37.930     0.150
     2.026    64.828     0.150
     2.073    36.328     0.150
     2.073    37.828     0.150
     2.073    65.430     0.150
     2.503    46.234     0.150
     2.503    78.930     0.150
     2.564    43.633     0.150
     2.564    47.031     0.150
     2.564    80.328     0.150
     2.784    50.430     0.150
     2.784    86.531     0.150
     3.819    60.828     0.150
     3.819    69.828     0.150
     3.819   119.531     0.150
     3.841    61.430     0.150
     3.841   119.633     0.150
     3.874    70.930     0.150
     3.874   121.328     0.150
     4.099    64.930     0.150
     4.099    74.828     0.150
     4.099   128.031     0.150
     4.435    68.734     0.150
     4.435    80.734     0.150
     4.435   119.633     0.150
     4.435   137.828     0.150
     4.880   153.328     0.150
     5.250    81.133     0.150
     5.250    95.734     0.150
     5.250   163.531     0.150
     6.707   209.234     0.150
     0.797    15.381     0.150
     0.797    25.781     0.150
     1.346    24.981     0.150
     1.346    42.481     0.150
     1.346    46.281     0.150
     2.024    38.081     0.150
     2.024    64.781     0.150
     2.077    38.381     0.150
     2.077    65.281     0.150
     2.500    79.381     0.150
     2.560    43.581     0.150
     2.560    46.981     0.150
     2.560    80.682     0.150
     2.785    50.781     0.150
     2.785    78.781     0.150
     2.785    86.781     0.150
     3.823    60.981     0.150
     3.823    69.981     0.150
     3.823   119.682     0.150
     3.838    61.381     0.150
     3.838    70.081     0.150
     3.838   120.182     0.150
     4.095    64.981     0.150
     4.095   128.182     0.150
     4.437   138.081     0.150
     5.246   163.881     0.150
     6.508    98.081     0.150
     6.508   202.881     0.150
     6.703   208.682     0.150
     7.271   227.381     0.150
     0.806    15.625     0.150
     0.806    26.125     0.150
     1.344    25.125     0.150
     1.344    26.723     0.150
     1.344    42.523     0.150
     1.360    25.523     0.150
     1.360    42.922     0.150
     2.020    36.223     0.150
     2.020    38.125     0.150
     2.020    65.125     0.150
     2.083    37.125     0.150
     2.083    38.723     0.150
     2.083    65.723     0.150
     2.495    45.723     0.150
     2.495    78.824     0.150
     2.553    47.023     0.150
     2.553    80.625     0.150
     2.786    50.523     0.150
     2.786    87.023     0.150
     3.521   110.523     0.150
     3.833    61.422     0.150
     3.833    69.922     0.150
     3.833   119.023     0.150
     3.885    61.922     0.150
     3.885    70.523     0.150
     3.885   105.023     0.150
     3.885   120.223     0.150
     4.089    64.824     0.150
     4.089    74.723     0.150
     4.089   128.023     0.150
     4.439    68.922     0.150
     4.439    81.125     0.150
     4.439   119.125     0.150
     4.439   138.625     0.150
     4.866   152.023     0.150
     5.238    80.523     0.150
     5.238    94.824     0.150
     5.238   137.723     0.150
     5.238   164.125     0.150
     6.501    98.125     0.150
     6.501   118.824     0.150
     6.501   202.523     0.150
     6.695   209.023     0.150
     7.262   108.824     0.150
     7.262   226.223     0.150
     7.280   226.922     0.150
     7.584   113.422     0.150
     7.584   236.125     0.150
     8.454   263.824     0.150
     8.849   275.922     0.150
     9.102   282.723     0.150
    10.084   313.324     0.150
    10.518   326.324     0.150
     0.802    15.562     0.150
     0.802    25.961     0.150
     1.330    24.859     0.150
     1.330    26.664     0.150
     1.330    42.461     0.150
     1.330    46.062     0.150
     1.367    25.859     0.150
     1.367    28.062     0.150
     1.367    43.859     0.150
     2.032    36.961     0.150
     2.032    38.562     0.150
     2.032    66.562     0.150
     2.094    37.461     0.150
     2.094    39.664     0.150
     2.094    66.258     0.150
     2.542    46.859     0.150
     2.542    79.461     0.150
     2.772    50.461     0.150
     2.772    86.461     0.150
     3.508   109.562     0.150
     3.820    61.664     0.150
     3.820    69.359     0.150
     3.820   119.859     0.150
     3.841    61.359     0.150
     3.841    70.359     0.150
     3.841   104.664     0.150
     3.841   120.562     0.150
     3.896   121.859     0.150
     4.078    65.062     0.150
     4.078    74.359     0.150
     4.078   128.164     0.150
     4.427    80.164     0.150
     4.427   138.062     0.150
     4.863   152.664     0.150
     6.490    98.461     0.150
     6.490   118.461     0.150
     6.490   202.758     0.150
     6.686   209.359     0.150
     7.261   108.258     0.150
     7.261   133.258     0.150
     7.261   226.961     0.150
     7.425   231.664     0.150
     7.574   236.758     0.150
     8.839   275.664     0.150
    10.073   313.164     0.150
    10.509   328.062     0.150
    10.967   340.562     0.150
    11.197   348.359     0.150
     0.808    15.629     0.150
     0.808    26.029     0.150
     0.808    26.229     0.150
     1.366    25.729     0.150
     1.366    28.129     0.150
     1.366    43.529     0.150
     1.337    25.029     0.150
     1.337    26.729     0.150
     1.337    42.529     0.150
     1.337    43.029     0.150
     2.090    37.430     0.150
     2.090    39.229     0.150
     2.090    67.129     0.150
     2.090    37.729     0.150
     2.090    66.930     0.150
     2.024    36.829     0.150
     2.024    38.229     0.150
     2.024    65.329     0.150
     2.024    36.930     0.150
     2.024    60.529     0.150
     2.488    42.729     0.150
     2.488    46.029     0.150
     2.488    78.729     0.150
     2.546    44.129     0.150
     2.546    46.729     0.150
     2.546    72.430     0.150
     2.546    79.829     0.150
     2.546    46.930     0.150
     2.546    80.629     0.150
     2.781    46.029     0.150
     2.781    50.430     0.150
     2.781    85.930     0.150
     2.781    50.329     0.150
     2.781    86.430     0.150
     3.514    65.029     0.150
     3.514   111.129     0.150
     3.835    61.029     0.150
     3.835    68.229     0.150
     3.835   119.029     0.150
     3.892    62.529     0.150
     3.892    70.229     0.150
     3.892   109.729     0.150
     3.892   122.129     0.150
     3.892    70.129     0.150
     3.892   120.329     0.150
     3.825    62.129     0.150
     3.825    69.829     0.150
     3.825   105.629     0.150
     3.825   119.430     0.150
     4.082    65.129     0.150
     4.082    74.729     0.150
     4.082   110.029     0.150
     4.082   128.129     0.150
     4.082    65.329     0.150
     4.082    74.229     0.150
     4.082   128.529     0.150
     4.435    69.029     0.150
     4.435    81.029     0.150
     4.435   119.229     0.150
     4.435   138.329     0.150
     4.861    88.129     0.150
     4.861   129.430     0.150
     4.861   151.829     0.150
     5.231    80.629     0.150
     5.231    94.930     0.150
     5.231   140.229     0.150
     5.231   163.529     0.150
     6.688   171.529     0.150
     7.258   107.930     0.150
     7.258   106.029     0.150
     7.258   129.829     0.150
     7.577   113.229     0.150
     7.577   237.329     0.150
     8.445   257.048     0.150
     8.447   263.430     0.150
     9.095   283.729     0.150
     9.561   297.829     0.150
    10.077   314.529     0.150
    10.511   327.129     0.150
    10.810   157.904     0.150
    10.971   281.229     0.150
    10.971   340.729     0.150
    10.935   158.149     0.150
    10.935   346.409     0.150
    14.877   469.204     0.150
    19.041   266.271     0.150
    22.965   307.904     0.150
    23.838   318.629     0.150
    23.879   318.104     0.150
    23.933   318.629     0.150
    43.363   485.779     0.150
    44.159   492.305     0.150
    45.336   501.529     0.150
    54.853   572.029     0.150
     0.804    15.568     0.150
     0.804    26.068     0.150
     1.344    25.068     0.150
     1.344    26.869     0.150
     1.344    42.770     0.150
     1.344    45.369     0.150
     1.359    25.568     0.150
     1.359    27.668     0.150
     1.359    43.270     0.150
     1.359    45.969     0.150
     2.021    36.369     0.150
     2.021    38.168     0.150
     2.021    64.469     0.150
     2.083    37.969     0.150
     2.083    65.969     0.150
     2.495    46.068     0.150
     2.495    79.369     0.150
     2.554    43.770     0.150
     2.554    46.869     0.150
     2.554    80.369     0.150
     2.785    50.568     0.150
     2.785    86.469     0.150
     3.828    60.969     0.150
     3.828    69.668     0.150
     3.828   119.869     0.150
     3.884    61.869     0.150
     3.884    70.869     0.150
     3.884   121.568     0.150
     4.089    65.068     0.150
     4.089    74.168     0.150
     4.089   128.068     0.150
     0.810    15.751     0.150
     0.810    26.151     0.150
     1.344    25.352     0.150
     1.344    27.052     0.150
     1.344    42.951     0.150
     1.344    46.651     0.150
     1.363    25.651     0.150
     1.363    43.052     0.150
     2.017    36.451     0.150
     2.017    38.251     0.150
     2.017    64.852     0.150
     2.085    37.651     0.150
     2.085    38.951     0.150
     2.085    66.151     0.150
     2.495    45.651     0.150
     2.495    72.552     0.150
     2.495    78.251     0.150
     2.552    43.951     0.150
     2.552    47.151     0.150
     2.552    74.352     0.150
     2.552    80.552     0.150
     2.788    46.751     0.150
     2.788    50.751     0.150
     2.788    79.852     0.150
     2.788    86.751     0.150
     3.521   111.251     0.150
     3.829    60.552     0.150
     3.829    69.552     0.150
     3.829   107.052     0.150
     3.829   119.352     0.150
     3.832    61.751     0.150
     3.832    69.552     0.150
     3.832   104.651     0.150
     3.832   119.751     0.150
     3.886    61.852     0.150
     3.886    70.852     0.150
     3.886   106.352     0.150
     3.886   120.951     0.150
     4.087    65.251     0.150
     4.087    74.552     0.150
     4.087   111.651     0.150
     4.087   128.352     0.150
     4.442    80.552     0.150
     4.442   119.651     0.150
     4.442   138.052     0.150
     4.862   152.751     0.150
     5.236    80.852     0.150
     5.236    95.151     0.150
     5.236   138.552     0.150
     5.236   163.451     0.150
     6.693   208.552     0.150
     7.431   231.751     0.150
     7.582   195.052     0.150
     7.582   236.552     0.150
     8.452   263.352     0.150
     9.099   283.352     0.150
     0.820    15.941     0.150
     0.820    26.342     0.150
     0.820    26.541     0.150
     1.369    25.842     0.150
     1.369    44.041     0.150
     1.369    48.141     0.150
     1.347    25.441     0.150
     1.347    42.842     0.150
     1.347    46.141     0.150
     2.088    37.541     0.150
     2.088    38.441     0.150
     2.088    63.742     0.150
     2.088    66.842     0.150
     2.088    66.141     0.150
     2.009    36.541     0.150
     2.009    38.242     0.150
     2.009    65.342     0.150
     2.009    38.041     0.150
     2.494    43.541     0.150
     2.494    46.541     0.150
     2.494    72.641     0.150
     2.494    78.742     0.150
     2.550    44.242     0.150
     2.550    47.242     0.150
     2.550    73.842     0.150
     2.550    80.041     0.150
     2.794    45.941     0.150
     2.794    50.842     0.150
     2.794    78.742     0.150
     2.794    87.242     0.150
     3.521    65.242     0.150
     3.521    97.141     0.150
     3.521   110.742     0.150
     3.521    66.041     0.150
     3.521   111.541     0.150
     3.830    61.141     0.150
     3.830    69.742     0.150
     3.830   104.941     0.150
     3.830   118.941     0.150
     3.889    62.242     0.150
     3.889    69.541     0.150
     3.889   105.441     0.150
     3.889   110.441     0.150
     3.889   120.441     0.150
     3.832    61.742     0.150
     3.832    70.742     0.150
     3.832   105.441     0.150
     3.832   120.141     0.150
     3.832    61.641     0.150
     3.832    69.742     0.150
     3.832   103.242     0.150
     4.084    65.242     0.150
     4.084    75.041     0.150
     4.084   111.541     0.150
     4.084   128.141     0.150
     4.084    75.441     0.150
     4.084   127.541     0.150
     4.449    68.941     0.150
     4.449    81.342     0.150
     4.449   119.441     0.150
     4.449   139.141     0.150
     4.854    86.242     0.150
     4.854    89.641     0.150
     4.854   130.842     0.150
     4.854   152.842     0.150
     5.231    80.842     0.150
     5.231    95.141     0.150
     5.231   139.641     0.150
     5.231   162.742     0.150
     5.231    95.242     0.150
     5.231   162.641     0.150
     6.495    98.242     0.150
     6.495   118.441     0.150
     6.495   168.842     0.150
     7.250   109.141     0.150
     7.250   109.242     0.150
     7.425   221.742     0.150
     7.425   231.041     0.150
     7.578   113.641     0.150
     7.578   136.742     0.150
     8.451   257.361     0.150
     8.448   264.441     0.150
     8.842   275.141     0.150
     9.095   282.842     0.150
     9.561   296.141     0.150
    10.079   313.242     0.150
    10.797   158.166     0.150
    10.973   339.441     0.150
    11.205   349.141     0.150
    54.862   571.309     0.150
     1.352    25.291     0.150
     1.352    27.191     0.150
     1.352    43.091     0.150
     1.343    24.991     0.150
     1.343    26.391     0.150
     1.343    42.391     0.150
     1.343    45.291     0.150
     2.027    36.191     0.150
     2.027    37.991     0.150
     2.027    64.691     0.150
     2.078    36.891     0.150
     2.078    38.691     0.150
     2.078    61.791     0.150
     2.078    65.891     0.150
     2.497    42.591     0.150
     2.497    45.991     0.150
     2.497    73.191     0.150
     2.497    78.791     0.150
     2.558    43.991     0.150
     2.558    46.791     0.150
     2.558    74.091     0.150
     2.558    79.691     0.150
     2.781    45.491     0.150
     2.781    50.191     0.150
     2.781    54.791     0.150
     2.781    77.891     0.150
     2.781    86.591     0.150
     3.523    64.391     0.150
     3.523   110.291     0.150
     3.825    60.591     0.150
     3.825    68.791     0.150
     3.825   104.391     0.150
     3.825   118.791     0.150
     3.835    61.191     0.150
     3.835    70.591     0.150
     3.835   105.091     0.150
     3.835   119.791     0.150
     3.880    61.791     0.150
     3.880    70.391     0.150
     3.880   104.291     0.150
     3.880   120.691     0.150
     4.094    64.791     0.150
     4.094    74.591     0.150
     4.094   110.691     0.150
     4.094   127.991     0.150
     4.433    68.691     0.150
     4.433    80.691     0.150
     4.433   118.991     0.150
     4.433   138.191     0.150
     4.876   153.591     0.150
     5.245    81.291     0.150
     5.245    95.891     0.150
     5.245   139.091     0.150
     5.245   163.891     0.150
     6.506    97.491     0.150
     6.506   118.591     0.150
     6.506   169.391     0.150
     6.506   202.891     0.150
     6.702   209.391     0.150
     7.273   108.591     0.150
     7.273   186.991     0.150
     7.273   226.391     0.150
     7.441   195.991     0.150
     7.441   231.491     0.150
     7.590   112.291     0.150
     7.590   236.691     0.150
     8.461   263.591     0.150
     9.108   283.391     0.150
     0.785    15.047     0.150
     0.785    25.445     0.150
     1.318    24.750     0.150
     1.318    26.445     0.150
     1.318    41.352     0.150
     1.361    25.750     0.150
     1.361    43.250     0.150
     2.052    36.547     0.150
     2.052    38.352     0.150
     2.052    65.547     0.150
     2.096    37.250     0.150
     2.096    38.945     0.150
     2.096    66.547     0.150
     2.540    47.250     0.150
     2.540    79.945     0.150
     2.755    50.750     0.150
     2.755    86.148     0.150
     3.813    60.852     0.150
     3.813    69.445     0.150
     3.813   119.047     0.150
     4.076    64.945     0.150
     4.076   127.250     0.150
     4.408    81.648     0.150
     4.408   137.047     0.150
     4.875   152.750     0.150
     5.230    95.445     0.150
     5.230   163.250     0.150
     6.688   208.352     0.150
     7.274   226.352     0.150
     0.812    15.820     0.150
     0.812    26.220     0.150
     1.341    25.320     0.150
     1.341    27.020     0.150
     1.341    42.820     0.150
     1.367    25.820     0.150
     1.367    27.420     0.150
     1.367    43.620     0.150
     2.018    36.020     0.150
     2.018    38.520     0.150
     2.018    65.220     0.150
     2.089    37.720     0.150
     2.089    39.520     0.150
     2.089    66.620     0.150
     2.548    44.020     0.150
     2.548    47.020     0.150
     2.548    80.420     0.150
     2.786    45.220     0.150
     2.786    50.720     0.150
     2.786    86.420     0.150
     3.828    69.520     0.150
     3.828   119.820     0.150
     4.083    65.320     0.150
     4.083    74.420     0.150
     4.083   128.420     0.150
     4.441   137.420     0.150
     0.810    15.672     0.150
     0.810    26.477     0.150
     1.344    25.172     0.150
     1.344    26.875     0.150
     1.344    42.875     0.150
     1.344    46.672     0.150
     1.363    25.773     0.150
     1.363    43.477     0.150
     2.018    36.672     0.150
     2.018    38.375     0.150
     2.018    65.078     0.150
     2.086    37.875     0.150
     2.086    65.672     0.150
     2.494    46.172     0.150
     2.494    79.578     0.150
     2.551    43.875     0.150
     2.551    46.875     0.150
     2.551    80.773     0.150
     2.787    46.477     0.150
     2.787    50.578     0.150
     2.787    86.977     0.150
     3.520    63.875     0.150
     3.520   109.672     0.150
     3.831    61.477     0.150
     3.831    69.172     0.150
     3.831   119.875     0.150
     3.887    62.078     0.150
     3.887    70.078     0.150
     3.887   121.773     0.150
     4.087    65.172     0.150
     4.087    74.273     0.150
     4.087   111.578     0.150
     4.087   127.977     0.150
     4.441    69.172     0.150
     4.441    80.672     0.150
     4.441   118.977     0.150
     4.441   138.172     0.150
     4.774    74.977     0.150
     4.774    85.477     0.150
     4.774   148.477     0.150
     4.862   130.477     0.150
     4.862   153.578     0.150
     5.235    80.773     0.150
     5.235    95.172     0.150
     5.235   164.172     0.150
     6.498    98.477     0.150
     6.498   168.773     0.150
     6.498   202.875     0.150
     6.692   208.273     0.150
     7.258   186.977     0.150
     7.258   226.875     0.150
     7.430   231.977     0.150
     7.581   235.273     0.150
     7.816   243.875     0.150
    10.515   326.773     0.150
    10.975   341.578     0.150
    11.207   348.875     0.150
     0.701    13.559     0.150
     0.701    22.359     0.150
     0.701    22.961     0.150
     1.228    22.859     0.150
     1.228    25.059     0.150
     1.228    27.160     0.150
     1.228    39.059     0.150
     1.228    42.961     0.150
     1.228    22.961     0.150
     1.228    39.961     0.150
     2.175    40.758     0.150
     2.175    69.660     0.150
     2.175    38.559     0.150
     2.175    63.859     0.150
     2.175    69.059     0.150
     2.137    37.961     0.150
     2.137    39.660     0.150
     2.137    66.758     0.150
     2.137    68.559     0.150
     2.409    41.359     0.150
     2.409    44.758     0.150
     2.409    76.258     0.150
     2.409    44.559     0.150
     2.502    42.961     0.150
     2.502    46.059     0.150
     2.502    73.160     0.150
     2.502    78.758     0.150
     2.638    43.859     0.150
     2.638    47.859     0.150
     2.638    81.859     0.150
     2.638    47.660     0.150
     2.638    82.160     0.150
     3.432    63.160     0.150
     3.432    95.758     0.150
     3.432   107.961     0.150
     3.432    63.059     0.150
     3.432   109.160     0.150
     3.751    59.660     0.150
     3.751    67.961     0.150
     3.751   102.859     0.150
     3.751   117.359     0.150
     4.042    64.359     0.150
     4.042    74.059     0.150
     4.042   109.059     0.150
     4.042   127.160     0.150
     4.042    64.258     0.150
     4.042    73.059     0.150
     4.042   126.059     0.150
     3.939    62.660     0.150
     3.939    71.758     0.150
     3.939   106.059     0.150
     3.939   122.359     0.150
     4.285    66.859     0.150
     4.285    77.961     0.150
     4.285   115.660     0.150
     4.285   132.559     0.150
     4.693    72.961     0.150
     4.693    86.461     0.150
     4.693   147.160     0.150
     4.926   132.461     0.150
     4.926   155.758     0.150
     4.926    77.961     0.150
     5.217    80.461     0.150
     5.217    94.859     0.150
     5.217   137.961     0.150
     5.217   163.660     0.150
     5.217    80.258     0.150
     5.217    94.660     0.150
     6.062   189.758     0.150
     5.956    91.059     0.150
     5.956   109.461     0.150
     5.956   155.461     0.150
     6.446    96.660     0.150
     6.446   118.461     0.150
     6.446   201.961     0.150
     6.462    97.160     0.150
     6.462   117.660     0.150
     6.462   167.258     0.150
     6.462   200.961     0.150
     6.462   117.461     0.150
     6.542   119.559     0.150
     6.542   169.059     0.150
     6.542   203.559     0.150
     6.677   209.059     0.150
     7.333   108.160     0.150
     7.333   134.859     0.150
     7.333   187.758     0.150
     7.333   229.559     0.150
     7.333   107.859     0.150
     7.333   131.859     0.150
     7.428   230.961     0.150
     7.554   111.961     0.150
     7.554   193.859     0.150
     7.554   235.059     0.150
     7.554   139.258     0.150
     7.750   241.359     0.150
     7.802   243.359     0.150
     7.919   117.559     0.150
     7.919   202.859     0.150
     7.919   247.160     0.150
     8.429   263.359     0.150
     8.397   120.660     0.150
     8.397   149.660     0.150
     8.397   122.602     0.150
     8.397   214.254     0.150
     8.397   257.652     0.150
     8.823   129.758     0.150
     8.823   223.359     0.150
     8.823   274.461     0.150
     9.074   281.758     0.150
     9.538   297.059     0.150
    10.045   295.258     0.150
    10.045   311.258     0.150
    10.972   158.621     0.150
    10.972   345.359     0.150
    10.947   159.559     0.150
    10.947   158.785     0.150
    16.158   225.559     0.150
    18.529   258.461     0.150
    18.794   257.559     0.150
    18.794   257.711     0.150
    18.947   264.234     0.150
    18.947   597.148     0.150
    23.753   315.559     0.150
    23.820   315.461     0.150
    23.820   315.734     0.150
    23.848   315.582     0.150
    27.237   346.434     0.150
    43.310   485.008     0.150
    44.011   487.461     0.150
    44.011   489.121     0.150
    49.472   531.129     0.150
    49.557   531.660     0.150
    49.557   532.910     0.150
    49.694   533.504     0.150
    57.820   595.086     0.150
    77.149   714.258     0.150
    77.149   715.008     0.150
     0.246     5.195     0.150
     0.246     8.312     0.150
     0.847    16.082     0.150
     1.080    21.082     0.150
     1.080    35.383     0.150
     1.080    20.902     0.150
     1.080    34.973     0.150
     1.080    35.184     0.150
     2.556    47.082     0.150
     2.556    79.785     0.150
     2.556    78.922     0.150
     2.556    79.582     0.150
     2.537    43.484     0.150
     2.537    46.785     0.150
     2.537    80.082     0.150
     2.537    46.684     0.150
     2.507    42.582     0.150
     2.507    46.484     0.150
     2.507    80.383     0.150
     2.507    42.383     0.150
     2.507    73.184     0.150
     3.247    55.715     0.150
     3.247    97.562     0.150
     3.080    49.094     0.150
     3.080    56.113     0.150
     3.080    86.262     0.150
     3.080    97.562     0.150
     3.468    58.965     0.150
     3.468    90.195     0.150
     3.468   103.195     0.150
     3.494    55.285     0.150
     3.494    94.984     0.150
     3.494   108.785     0.150
     3.494    54.984     0.150
     3.494   106.383     0.150
     3.961   123.785     0.150
     4.789    84.953     0.150
     4.789   148.223     0.150
     4.780   149.684     0.150
     5.126    93.684     0.150
     5.126   135.184     0.150
     5.126   160.383     0.150
     5.503   100.984     0.150
     5.503   143.883     0.150
     5.503   172.484     0.150
     5.840   103.004     0.150
     5.840   178.785     0.150
     6.058   189.582     0.150
     6.344   110.895     0.150
     6.344   192.484     0.150
     6.867   120.672     0.150
     6.867   210.152     0.150
     6.699   208.883     0.150
     7.024   103.824     0.150
     7.024   123.305     0.150
     7.024   213.945     0.150
     7.024   103.926     0.150
     7.024   101.184     0.150
     7.542   236.383     0.150
     7.674   239.883     0.150
     7.929   247.582     0.150
     7.927   117.383     0.150
     7.927   145.383     0.150
     7.927   248.082     0.150
     8.017   250.184     0.150
     8.159   254.582     0.150
     8.620   125.883     0.150
     8.620   268.484     0.150
     8.908   277.883     0.150
     9.030   281.984     0.150
     9.232   288.684     0.150
     9.356   291.285     0.150
     9.399   293.484     0.150
     9.909   309.184     0.150
    10.302   320.184     0.150
    10.346   150.184     0.150
    10.552   328.383     0.150
    11.013   342.285     0.150
    12.398   176.363     0.150
    15.225   372.051     0.150
    17.016   238.055     0.150
    18.986   260.184     0.150
    20.082   271.203     0.150
    25.025   325.184     0.150
    25.122   325.180     0.150
    28.356   353.668     0.150
    37.707   434.883     0.150
    41.212   464.164     0.150
    41.949   471.223     0.150
    43.620   484.672     0.150
    44.419   490.062     0.150
    45.358   497.953     0.150
    46.311   504.875     0.150
    53.558   559.910     0.150
     0.315     6.455     0.150
     0.315    10.354     0.150
     1.156    21.854     0.150
     1.156    36.455     0.150
     1.248    23.555     0.150
     1.248    39.854     0.150
     2.053    35.854     0.150
     2.053    38.055     0.150
     2.053    64.354     0.150
     2.444    41.055     0.150
     2.444    44.254     0.150
     2.444    69.254     0.150
     2.444    75.455     0.150
     2.494    41.955     0.150
     2.494    45.955     0.150
     2.494    78.654     0.150
     2.500    42.455     0.150
     2.500    45.654     0.150
     2.500    79.555     0.150
     2.681    49.254     0.150
     2.681    77.154     0.150
     2.681    84.254     0.150
     3.494    63.654     0.150
     3.494   109.455     0.150
     3.834    60.455     0.150
     3.834    69.455     0.150
     3.834   104.154     0.150
     3.834   119.254     0.150
     3.835    60.754     0.150
     3.835    69.955     0.150
     3.835   120.154     0.150
     4.009    62.654     0.150
     4.009    72.354     0.150
     4.009   107.254     0.150
     4.009   124.354     0.150
     4.219    66.254     0.150
     4.219    77.555     0.150
     4.219   113.654     0.150
     4.219   132.654     0.150
     4.770    73.654     0.150
     4.770    86.854     0.150
     4.770   127.254     0.150
     4.770   148.654     0.150
     5.294   166.854     0.150
     5.448    82.654     0.150
     5.448    99.654     0.150
     5.448   142.455     0.150
     5.448   170.654     0.150
     6.648    99.354     0.150
     6.648   171.955     0.150
     6.648   206.354     0.150
     6.674    99.955     0.150
     6.674   122.154     0.150
     6.674   171.754     0.150
     6.674   208.754     0.150
     6.746   175.754     0.150
     6.746   210.654     0.150
     6.911   125.854     0.150
     6.911   177.455     0.150
     6.911   215.354     0.150
     7.686   239.555     0.150
     7.710   112.055     0.150
     7.710   198.154     0.150
     7.710   239.854     0.150
     7.987   249.154     0.150
     8.101   252.455     0.150
     8.172   120.555     0.150
     8.172   208.955     0.150
     8.172   254.354     0.150
     9.037   281.654     0.150
     9.284   288.555     0.150
    10.225   317.955     0.150
     0.844    16.339     0.150
     0.844    27.139     0.150
     0.893    17.239     0.150
     0.893    28.739     0.150
     1.640    51.739     0.150
     2.074    37.339     0.150
     2.074    39.139     0.150
     2.074    61.239     0.150
     2.074    65.939     0.150
     2.191    38.539     0.150
     2.191    40.339     0.150
     2.191    64.739     0.150
     2.191    68.439     0.150
     2.361    43.039     0.150
     2.361    72.839     0.150
     2.405    41.539     0.150
     2.405    44.239     0.150
     2.405    70.839     0.150
     2.405    76.339     0.150
     2.463    42.739     0.150
     2.463    45.039     0.150
     2.463    71.439     0.150
     2.463    76.939     0.150
     3.095    56.639     0.150
     3.095    87.239     0.150
     3.095    97.639     0.150
     3.417    55.539     0.150
     3.417    62.739     0.150
     3.417    95.039     0.150
     3.417   107.039     0.150
     3.732    60.039     0.150
     3.732    67.739     0.150
     3.732   117.039     0.150
     4.054    62.939     0.150
     4.054    73.639     0.150
     4.054   125.939     0.150
     4.263    67.139     0.150
     4.263    77.339     0.150
     4.263   113.439     0.150
     4.263   132.139     0.150
     4.358    67.839     0.150
     4.358    79.439     0.150
     4.358   116.239     0.150
     4.358   136.339     0.150
     4.782    74.239     0.150
     4.782    85.539     0.150
     4.782   128.739     0.150
     4.782   150.539     0.150
     4.934    76.439     0.150
     4.934    90.439     0.150
     4.934   154.339     0.150
     5.775   104.939     0.150
     5.775   179.739     0.150
     6.157    93.239     0.150
     6.157   112.639     0.150
     6.157   161.239     0.150
     6.157   192.539     0.150
     6.162    93.339     0.150
     6.162   112.039     0.150
     6.162   161.339     0.150
     6.162   193.139     0.150
     6.245   114.039     0.150
     6.245   195.339     0.150
     6.396   165.239     0.150
     6.396   199.939     0.150
     7.162   130.839     0.150
     7.162   185.839     0.150
     7.162   223.739     0.150
     7.205   105.039     0.150
     7.205   187.739     0.150
     7.205   224.439     0.150
     7.258   108.739     0.150
     7.258   225.239     0.150
     7.471   233.339     0.150
     7.650   114.939     0.150
     7.650   238.539     0.150
     8.781   222.639     0.150
     8.781   273.839     0.150
     9.241   288.739     0.150
     0.093     3.164     0.150
     0.093     4.867     0.150
     0.944    17.664     0.150
     0.944    29.965     0.150
     1.878    34.367     0.150
     1.878    58.664     0.150
     1.878    59.867     0.150
     2.528    41.766     0.150
     2.528    45.066     0.150
     2.528    49.965     0.150
     2.528    70.664     0.150
     2.528    77.566     0.150
     2.571    42.965     0.150
     2.571    46.766     0.150
     2.571    73.965     0.150
     2.571    80.965     0.150
     2.705    44.566     0.150
     2.705    49.965     0.150
     2.705    85.164     0.150
     2.915    47.965     0.150
     2.915    53.566     0.150
     2.915    82.164     0.150
     2.915    91.266     0.150
     3.639    58.465     0.150
     3.639    65.066     0.150
     3.639    67.965     0.150
     3.639   112.066     0.150
     3.695    58.367     0.150
     3.695    67.465     0.150
     3.695   116.066     0.150
     4.022    62.965     0.150
     4.022    72.965     0.150
     4.022   109.566     0.150
     4.022   125.766     0.150
     4.042    63.266     0.150
     4.042    72.566     0.150
     4.042   107.664     0.150
     4.042   125.965     0.150
     4.451    69.367     0.150
     4.451    81.664     0.150
     4.451   139.766     0.150
     5.688    85.867     0.150
     5.688   103.465     0.150
     5.688   149.766     0.150
     5.688   177.766     0.150
     6.525   203.965     0.150
     6.880   101.867     0.150
     6.880   123.867     0.150
     6.880   177.367     0.150
     6.880   213.965     0.150
     6.914   102.766     0.150
     6.914   179.367     0.150
     6.914   215.566     0.150
     6.982   216.867     0.150
     7.152   222.965     0.150
     7.929   247.566     0.150
     7.942   117.965     0.150
     7.942   204.066     0.150
     7.942   248.066     0.150
     7.994   249.664     0.150
     8.415   262.566     0.150
    10.454   325.266     0.150
    11.333   351.066     0.150
    11.500   357.066     0.150
     0.552    10.828     0.150
     0.552    18.926     0.150
     1.454    25.227     0.150
     2.230    37.227     0.150
     3.030    46.828     0.150
     3.030    81.828     0.150
     3.030    88.629     0.150
     2.953    46.629     0.150
     2.953    52.426     0.150
     2.953    91.227     0.150
     2.981    52.727     0.150
     2.981    55.328     0.150
     2.981    93.027     0.150
     3.474   108.426     0.150
     3.740    58.527     0.150
     3.740   117.527     0.150
     4.165    73.926     0.150
     4.165   127.926     0.150
     4.785    73.027     0.150
     4.785   149.828     0.150
     5.264    79.129     0.150
     5.264   138.129     0.150
     5.264   165.027     0.150
     5.699   178.527     0.150
     6.527   203.727     0.150
     7.691   240.129     0.150
     7.750   242.129     0.150
     8.760   274.629     0.150
     8.777   274.027     0.150
     8.815   275.828     0.150
     0.606    12.031     0.150
     0.606    20.230     0.150
     1.166    22.160     0.150
     1.166    38.859     0.150
     1.166    21.648     0.150
     1.166    38.230     0.150
     1.224    39.859     0.150
     1.224    39.672     0.150
     2.604    43.359     0.150
     2.604    46.461     0.150
     2.604    79.660     0.150
     2.604    42.949     0.150
     2.604    74.309     0.150
     2.604    79.469     0.150
     2.679    44.762     0.150
     2.679    76.559     0.150
     2.679    83.461     0.150
     2.969    51.512     0.150
     2.969    87.531     0.150
     3.057    49.160     0.150
     3.057    55.461     0.150
     3.057    86.160     0.150
     3.057    96.359     0.150
     3.057    55.238     0.150
     3.057    96.570     0.150
     3.380    53.359     0.150
     3.380    93.859     0.150
     3.380   105.160     0.150
     3.406    53.422     0.150
     3.406    60.961     0.150
     3.406    94.441     0.150
     3.406   106.770     0.150
     3.925   122.461     0.150
     4.178    65.359     0.150
     4.178   130.160     0.150
     4.505    68.961     0.150
     4.505    81.262     0.150
     4.505   139.961     0.150
     5.240    93.660     0.150
     5.641    98.051     0.150
     5.641   170.629     0.150
     5.706    86.660     0.150
     6.696   209.359     0.150
     6.957   216.859     0.150
     7.793   243.762     0.150
     8.135   253.059     0.150
     8.420   263.660     0.150
     9.075   284.461     0.150
     9.198   286.059     0.150
     9.685   302.359     0.150
     0.786    15.192     0.150
     0.786    25.692     0.150
     0.930    17.593     0.150
     0.930    30.093     0.150
     1.583    29.393     0.150
     1.583    50.293     0.150
     2.122    68.093     0.150
     2.247    39.293     0.150
     2.247    41.393     0.150
     2.247    70.893     0.150
     2.373    39.992     0.150
     2.373    43.293     0.150
     2.373    74.293     0.150
     2.411    41.992     0.150
     2.411    43.692     0.150
     2.411    70.893     0.150
     2.411    75.492     0.150
     2.403    41.893     0.150
     2.403    44.593     0.150
     2.403    76.492     0.150
     3.466    56.093     0.150
     3.466    63.492     0.150
     3.466   108.793     0.150
     3.788    60.692     0.150
     3.788    68.893     0.150
     3.788   104.692     0.150
     3.788   119.192     0.150
     4.211   129.593     0.150
     4.407    69.492     0.150
     4.407    80.293     0.150
     4.407   137.692     0.150
     4.836   151.492     0.150
     4.992    77.093     0.150
     4.992    90.393     0.150
     4.992   156.093     0.150
     5.833   182.492     0.150
     6.214    94.093     0.150
     6.214   112.893     0.150
     6.214   194.692     0.150
     6.220   194.692     0.150
     6.455   201.992     0.150
     7.221   225.992     0.150
     7.257   108.293     0.150
     7.257   132.992     0.150
     7.257   187.192     0.150
     7.257   227.692     0.150
     7.315   228.793     0.150
     7.709   240.293     0.150
     8.197   255.992     0.150
     9.795   304.992     0.150
    10.681   331.593     0.150
    10.883   338.692     0.150
     0.368     7.141     0.150
     0.368    12.039     0.150
     0.368    11.938     0.150
     0.831    15.641     0.150
     0.831    26.539     0.150
     1.609    29.641     0.150
     1.609    32.242     0.150
     1.609    51.039     0.150
     1.688    32.141     0.150
     1.688    54.836     0.150
     1.688    32.039     0.150
     1.688    54.641     0.150
     2.294    39.938     0.150
     2.294    42.742     0.150
     2.294    72.641     0.150
     2.294    39.641     0.150
     2.294    72.336     0.150
     2.793    46.039     0.150
     2.793    50.836     0.150
     2.793    86.336     0.150
     2.793    45.539     0.150
     2.793    50.336     0.150
     2.793    85.641     0.150
     2.846    53.141     0.150
     2.846    90.039     0.150
     3.000    49.641     0.150
     3.000    55.641     0.150
     3.000    94.641     0.150
     3.000    54.242     0.150
     3.000    93.641     0.150
     3.477    56.938     0.150
     3.477    62.938     0.150
     3.477    64.039     0.150
     3.477   102.641     0.150
     3.477   108.641     0.150
     3.477    54.938     0.150
     3.477    95.141     0.150
     3.477   106.938     0.150
     3.853    70.641     0.150
     3.853   121.039     0.150
     4.190    66.242     0.150
     4.190    76.539     0.150
     4.190   130.742     0.150
     4.190    77.242     0.150
     4.190   112.438     0.150
     4.190   130.539     0.150
     4.310    78.641     0.150
     4.310   134.141     0.150
     4.310    67.438     0.150
     4.310    79.938     0.150
     4.310   116.242     0.150
     4.310   133.539     0.150
     4.541    70.742     0.150
     4.541    82.242     0.150
     4.541   141.336     0.150
     5.127    92.938     0.150
     5.127   160.539     0.150
     5.442   170.742     0.150
     5.717    87.836     0.150
     5.717   105.141     0.150
     5.717   150.539     0.150
     5.740   104.039     0.150
     5.740   179.242     0.150
     6.583   204.539     0.150
     6.967   216.836     0.150
     7.838   116.742     0.150
     7.838   245.836     0.150
     7.960   247.641     0.150
     8.450   263.742     0.150
    18.740   256.461     0.150
    19.316   268.477     0.150
    24.145   319.336     0.150
    24.241   319.367     0.150
    24.278   319.664     0.150
     0.489     9.844     0.150
     0.489    17.586     0.150
     1.034    19.824     0.150
     1.034    32.773     0.150
     1.248    23.496     0.150
     1.248    40.465     0.150
     2.768    85.395     0.150
     2.995    51.223     0.150
     2.995    89.824     0.150
     3.160    54.523     0.150
     3.160    95.785     0.150
     4.382    77.875     0.150
     4.382   135.273     0.150
     5.833   103.004     0.150
     5.833   178.375     0.150
     6.113   107.355     0.150
     6.113   187.113     0.150
     6.623   116.215     0.150
     6.623   201.883     0.150
     6.770   119.293     0.150
     6.770   206.715     0.150
     1.063    20.812     0.150
     1.063    34.711     0.150
     1.063    34.812     0.150
     1.203    38.414     0.150
     1.710    30.812     0.150
     1.710    53.211     0.150
     2.385    40.016     0.150
     2.385    40.117     0.150
     2.840    46.211     0.150
     2.840    52.617     0.150
     2.840    88.516     0.150
     2.840    51.914     0.150
     2.840    88.414     0.150
     3.868    59.711     0.150
     3.868    70.414     0.150
     3.868   104.211     0.150
     3.868   120.312     0.150
     3.868    59.016     0.150
     3.868   120.414     0.150
     3.569    56.711     0.150
     3.569   111.711     0.150
     3.661    56.711     0.150
     3.661   113.211     0.150
     3.661    57.016     0.150
     3.617    57.117     0.150
     3.617   112.016     0.150
     3.617    57.312     0.150
     3.617    66.117     0.150
     3.617   112.914     0.150
     4.267    64.617     0.150
     4.267    75.117     0.150
     4.595    71.211     0.150
     4.595   143.117     0.150
     4.852    74.812     0.150
     4.852   127.516     0.150
     4.908    75.211     0.150
     4.908   152.211     0.150
     4.908    75.312     0.150
     5.159    77.711     0.150
     5.159   160.016     0.150
     5.159    92.812     0.150
     5.270    92.016     0.150
     5.270    94.914     0.150
     5.270   165.812     0.150
     5.143    78.211     0.150
     5.573    83.812     0.150
     5.850    88.211     0.150
     6.336    93.914     0.150
     6.336   194.711     0.150
     6.336    94.016     0.150
     6.336   164.711     0.150
     6.244    92.914     0.150
     7.059   102.117     0.150
     7.059   177.016     0.150
     6.877    99.406     0.150
     7.092   105.211     0.150
     7.590   109.016     0.150
     7.590   190.812     0.150
     7.402   108.211     0.150
     7.753   110.484     0.150
     7.753   234.633     0.150
     7.753   194.312     0.150
     7.753   111.125     0.150
     7.540   110.812     0.150
     7.540   110.711     0.150
     7.690   112.914     0.150
     7.889   114.711     0.150
     8.394   122.617     0.150
     8.394   262.711     0.150
     8.606   125.312     0.150
     8.606   268.516     0.150
     8.606   125.211     0.150
     8.752   127.414     0.150
     8.752   272.016     0.150
     8.808   275.211     0.150
     8.894   130.312     0.150
     8.894   278.016     0.150
     8.891   129.617     0.150
     8.891   277.016     0.150
     9.277   288.516     0.150
     9.463   137.117     0.150
     9.463   293.617     0.150
     9.859   142.711     0.150
     9.859   305.711     0.150
     9.968   308.312     0.150
     9.968   146.117     0.150
     9.968   251.117     0.150
    10.587   154.117     0.150
    10.587   328.312     0.150
    11.190   160.617     0.150
    11.121   161.711     0.150
    11.121   345.914     0.150
    11.413   163.914     0.150
    11.452   164.016     0.150
    11.452   165.016     0.150
    11.452   355.914     0.150
    11.452   165.211     0.150
    11.503   167.016     0.150
    11.503   355.617     0.150
    11.503   165.711     0.150
    11.757   167.820     0.150
    11.757   168.477     0.150
    11.757   366.258     0.150
    12.021   173.016     0.150
    12.021   373.414     0.150
    12.021   172.914     0.150
    12.272   175.711     0.150
    12.272   379.711     0.150
    12.490   176.914     0.150
    12.836   181.711     0.150
    13.054   185.711     0.150
    13.486   191.312     0.150
    14.195   201.086     0.150
    14.510   206.914     0.150
    15.121   214.914     0.150
    15.377   218.516     0.150
    16.247   232.914     0.150
    16.247   420.211     0.150
    16.291   228.414     0.150
    16.291   414.914     0.150
    16.314   227.992     0.150
    16.683   232.008     0.150
    16.683   516.086     0.150
    16.683   231.812     0.150
    16.683   232.977     0.150
    16.835   237.516     0.150
    16.845   237.414     0.150
    17.271   241.914     0.150
    17.271   431.211     0.150
    17.650   243.914     0.150
    17.650   244.617     0.150
    18.754   260.367     0.150
    18.754   471.812     0.150
    19.067   264.414     0.150
    19.067   481.211     0.150
    19.102   479.414     0.150
    19.102   501.711     0.150
    19.192   264.664     0.150
    19.192   266.375     0.150
    19.385   266.742     0.150
    19.447   268.617     0.150
    19.447   488.086     0.150
    19.447   611.516     0.150
    19.447   266.961     0.150
    20.015   274.211     0.150
    20.015   294.711     0.150
    20.015   498.211     0.150
    20.110   273.273     0.150
    20.110   272.812     0.150
    20.110   274.789     0.150
    20.110   499.117     0.150
    20.110   634.047     0.150
    20.392   276.172     0.150
    20.392   278.773     0.150
    20.619   278.625     0.150
    20.657   277.945     0.150
    20.657   279.312     0.150
    21.377   288.414     0.150
    21.377   523.914     0.150
    21.891   291.273     0.150
    21.891   291.914     0.150
    21.891   293.562     0.150
    21.891   534.711     0.150
    22.453   298.672     0.150
    22.453   299.914     0.150
    22.453   300.477     0.150
    22.183   298.414     0.150
    22.183   325.414     0.150
    22.183   544.414     0.150
    22.183   579.914     0.150
    22.996   304.164     0.150
    22.996   305.312     0.150
    22.834   555.414     0.150
    23.001   307.016     0.150
    23.001   556.711     0.150
    23.163   307.727     0.150
    23.167   307.070     0.150
    23.167   306.820     0.150
    23.169   305.422     0.150
    23.169   306.766     0.150
    23.169   558.289     0.150
    23.143   308.203     0.150
    23.361   311.914     0.150
    23.361   566.711     0.150
    23.718   311.312     0.150
    24.131   314.258     0.150
    24.131   315.617     0.150
    23.833   313.344     0.150
    24.129   316.727     0.150
    23.868   315.211     0.150
    24.085   315.414     0.150
    24.085   573.414     0.150
    24.085   584.414     0.150
    24.228   315.992     0.150
    24.228   317.117     0.150
    24.386   317.344     0.150
    24.386   319.461     0.150
    24.916   322.367     0.150
    24.916   323.711     0.150
    24.916   590.117     0.150
    24.916   324.703     0.150
    24.957   325.617     0.150
    24.957   324.258     0.150
    24.957   324.789     0.150
    24.957   589.039     0.150
    25.011   323.688     0.150
    25.011   590.086     0.150
    25.042   325.211     0.150
    25.042   591.914     0.150
    25.123   324.781     0.150
    25.879   332.914     0.150
    25.879   659.914     0.150
    26.203   336.914     0.150
    26.203   611.414     0.150
    26.884   340.703     0.150
    27.664   633.414     0.150
    27.664   641.711     0.150
    28.201   354.102     0.150
    28.387   353.961     0.150
    28.387   641.414     0.150
    28.415   354.812     0.150
    28.378   355.414     0.150
    28.378   641.711     0.150
    28.586   357.531     0.150
    28.791   357.672     0.150
    29.041   361.836     0.150
    29.439   365.242     0.150
    30.124   371.422     0.150
    30.657   375.258     0.150
    30.732   375.156     0.150
    31.284   381.367     0.150
    31.589   381.414     0.150
    31.589   687.711     0.150
    31.700   384.164     0.150
    31.867   386.414     0.150
    31.889   386.703     0.150
    31.889   386.914     0.150
    33.181   396.094     0.150
    33.181   396.914     0.150
    33.181   466.312     0.150
    33.344   398.438     0.150
    33.416   720.914     0.150
    33.811   402.305     0.150
    33.811   401.766     0.150
    34.423   405.586     0.150
    34.520   407.336     0.150
    34.520   407.508     0.150
    34.237   409.406     0.150
    34.703   411.242     0.150
    35.077   411.781     0.150
    34.768   495.414     0.150
    34.768   744.414     0.150
    34.768   749.414     0.150
    35.219   413.156     0.150
    35.372   413.414     0.150
    35.401   414.469     0.150
    35.455   415.297     0.150
    35.514   416.266     0.150
    35.792   417.797     0.150
    35.848   419.023     0.150
    35.848   418.180     0.150
    35.523   417.695     0.150
    36.152   420.633     0.150
    36.189   420.898     0.150
    35.962   420.797     0.150
    35.962   420.742     0.150
    36.232   421.562     0.150
    36.232   421.445     0.150
    36.393   422.445     0.150
    36.502   424.352     0.150
    36.502   423.328     0.150
    36.646   425.875     0.150
    36.646   424.227     0.150
    36.646   425.305     0.150
    36.646   424.938     0.150
    36.698   425.773     0.150
    36.698   424.594     0.150
    36.524   425.312     0.150
    36.861   427.039     0.150
    36.957   428.117     0.150
    36.957   427.156     0.150
    37.001   427.617     0.150
    37.007   426.969     0.150
    36.682   427.961     0.150
    36.687   427.953     0.150
    36.739   428.070     0.150
    36.753   428.641     0.150
    37.170   428.656     0.150
    37.181   427.742     0.150
    37.211   428.844     0.150
    37.252   429.266     0.150
    37.281   430.039     0.150
    37.377   430.242     0.150
    37.446   431.594     0.150
    37.478   431.477     0.150
    37.663   433.812     0.150
    37.663   433.438     0.150
    37.744   434.109     0.150
    37.753   435.062     0.150
    37.753   433.680     0.150
    37.775   434.977     0.150
    37.775   434.820     0.150
    37.800   433.914     0.150
    37.833   433.922     0.150
    37.567   435.336     0.150
    37.567   436.922     0.150
    37.934   434.031     0.150
    37.650   436.047     0.150
    37.813   437.914     0.150
    37.813   792.914     0.150
    38.245   436.766     0.150
    38.269   439.812     0.150
    38.269   438.492     0.150
    38.290   438.781     0.150
    38.325   439.812     0.150
    38.372   439.617     0.150
    38.387   438.930     0.150
    38.447   440.469     0.150
    38.401   442.211     0.150
    38.401   440.328     0.150
    38.401   440.812     0.150
    38.603   441.859     0.150
    38.635   442.422     0.150
    38.802   443.539     0.150
    38.814   443.594     0.150
    38.830   444.078     0.150
    38.883   444.305     0.150
    39.018   445.320     0.150
    38.911   442.914     0.150
    39.089   446.391     0.150
    39.044   448.133     0.150
    39.209   446.258     0.150
    39.229   446.984     0.150
    38.978   446.188     0.150
    39.401   448.875     0.150
    39.408   448.977     0.150
    39.414   448.891     0.150
    39.413   448.422     0.150
    39.440   448.656     0.150
    39.454   449.500     0.150
    39.457   449.164     0.150
    39.474   449.641     0.150
    39.583   450.297     0.150
    39.700   450.133     0.150
    39.708   450.531     0.150
    39.718   451.797     0.150
    39.718   451.156     0.150
    39.730   449.875     0.150
    39.743   451.141     0.150
    39.861   451.680     0.150
    39.896   452.273     0.150
    39.914   452.914     0.150
    39.941   452.734     0.150
    39.977   453.195     0.150
    39.989   452.422     0.150
    39.814   451.711     0.150
    39.814   578.016     0.150
    40.019   453.836     0.150
    40.082   454.227     0.150
    40.207   455.867     0.150
    40.207   455.656     0.150
    40.331   457.305     0.150
    40.338   456.656     0.150
    40.349   457.148     0.150
    40.383   457.188     0.150
    40.382   457.625     0.150
    40.420   458.875     0.150
    40.456   458.414     0.150
    40.473   458.430     0.150
    40.519   458.844     0.150
    40.528   458.102     0.150
    40.464   458.914     0.150
    40.612   458.359     0.150
    40.621   458.898     0.150
    40.499   459.961     0.150
    40.499   457.734     0.150
    40.782   461.039     0.150
    40.830   461.445     0.150
    40.623   460.711     0.150
    40.470   460.406     0.150
    40.607   460.547     0.150
    41.020   462.102     0.150
    41.028   463.141     0.150
    41.069   462.797     0.150
    41.092   462.852     0.150
    41.137   462.984     0.150
    41.148   463.008     0.150
    41.148   463.555     0.150
    41.155   464.148     0.150
    41.174   463.914     0.150
    40.807   462.383     0.150
    40.807   462.641     0.150
    40.807   462.117     0.150
    40.807   558.242     0.150
    41.262   464.648     0.150
    41.319   463.281     0.150
    41.399   465.141     0.150
    41.425   466.578     0.150
    41.466   464.570     0.150
    41.478   466.383     0.150
    41.488   466.531     0.150
    41.505   466.367     0.150
    41.522   466.781     0.150
    41.555   467.242     0.150
    41.555   467.016     0.150
    41.581   467.539     0.150
    41.462   467.656     0.150
    41.728   468.609     0.150
    41.752   468.016     0.150
    41.752   468.336     0.150
    41.823   469.039     0.150
    41.875   469.797     0.150
    41.938   470.320     0.150
    41.946   469.914     0.150
    41.955   471.234     0.150
    41.983   469.961     0.150
    41.987   470.320     0.150
    42.051   470.625     0.150
    42.064   471.766     0.150
    42.075   471.531     0.150
    41.997   471.242     0.150
    42.169   472.375     0.150
    42.194   471.953     0.150
    42.217   471.672     0.150
    42.268   473.211     0.150
    42.268   473.016     0.150
    42.268   472.781     0.150
    42.268   473.875     0.150
    42.280   473.445     0.150
    42.334   474.188     0.150
    42.395   473.648     0.150
    42.408   473.656     0.150
    42.411   473.891     0.150
    42.447   473.719     0.150
    42.465   474.664     0.150
    42.468   472.844     0.150
    42.481   474.711     0.150
    42.379   474.383     0.150
    42.490   473.648     0.150
    42.382   474.422     0.150
    42.515   474.562     0.150
    42.515   475.164     0.150
    42.514   474.227     0.150
    42.650   475.156     0.150
    42.667   475.773     0.150
    42.667   476.023     0.150
    42.667   476.766     0.150
    42.686   476.086     0.150
    42.687   476.414     0.150
    42.718   476.977     0.150
    42.763   476.469     0.150
    42.830   476.586     0.150
    42.843   476.297     0.150
    42.852   477.422     0.150
    42.852   477.227     0.150
    42.843   476.883     0.150
    42.790   480.617     0.150
    42.987   478.492     0.150
    42.989   478.000     0.150
    43.117   479.727     0.150
    43.117   479.328     0.150
    43.156   479.273     0.150
    43.158   478.844     0.150
    43.173   479.305     0.150
    43.164   477.898     0.150
    43.194   478.633     0.150
    43.249   482.492     0.150
    43.293   481.438     0.150
    43.330   482.812     0.150
    43.356   482.273     0.150
    43.403   481.945     0.150
    43.457   483.438     0.150
    43.468   482.422     0.150
    43.468   483.062     0.150
    43.623   484.016     0.150
    43.622   484.000     0.150
    43.635   485.461     0.150
    43.647   484.812     0.150
    43.646   484.273     0.150
    43.473   482.211     0.150
    43.473   585.312     0.150
    43.473   871.812     0.150
    43.672   484.234     0.150
    43.731   485.070     0.150
    43.808   485.148     0.150
    43.852   485.445     0.150
    43.852   486.320     0.150
    43.860   485.664     0.150
    43.984   488.617     0.150
    43.989   487.461     0.150
    43.996   486.047     0.150
    43.996   486.531     0.150
    44.040   487.719     0.150
    44.094   487.820     0.150
    44.096   487.445     0.150
    44.118   487.688     0.150
    44.177   487.172     0.150
    44.157   487.273     0.150
    44.157   488.039     0.150
    44.221   488.656     0.150
    44.221   488.953     0.150
    44.231   488.859     0.150
    44.330   491.266     0.150
    44.390   490.297     0.150
    44.412   490.156     0.150
    44.418   490.234     0.150
    44.432   490.125     0.150
    44.492   491.539     0.150
    44.275   489.016     0.150
    44.331   489.508     0.150
    44.331   489.312     0.150
    44.331  1084.414     0.150
    44.535   491.375     0.150
    44.566   492.430     0.150
    44.572   490.438     0.150
    44.572   491.578     0.150
    44.484   491.414     0.150
    44.633   493.367     0.150
    44.643   492.789     0.150
    44.655   493.500     0.150
    44.688   492.914     0.150
    44.774   492.531     0.150
    44.774   494.016     0.150
    44.793   493.984     0.150
    44.496   491.891     0.150
    44.837   494.273     0.150
    44.799   492.812     0.150
    44.889   493.961     0.150
    44.821   493.422     0.150
    44.963   495.297     0.150
    44.767   492.812     0.150
    44.882   493.555     0.150
    44.884   493.414     0.150
    44.884   493.938     0.150
    44.884   889.586     0.150
    44.884   494.211     0.150
    44.893   493.758     0.150
    45.076   496.180     0.150
    45.219   497.445     0.150
    45.277   497.641     0.150
    45.311   497.773     0.150
    45.391   499.117     0.150
    45.417   497.523     0.150
    45.462   499.109     0.150
    45.483   499.383     0.150
    45.485   499.766     0.150
    45.498   499.125     0.150
    45.614   499.625     0.150
    45.614   500.805     0.150
    45.689   499.336     0.150
    45.689   499.977     0.150
    45.520   499.016     0.150
    45.789   501.438     0.150
    45.789   502.422     0.150
    45.833   502.750     0.150
    45.617   500.312     0.150
    45.914   503.789     0.150
    45.929   502.836     0.150
    45.812   500.961     0.150
    45.848   502.125     0.150
    45.867   500.172     0.150
    46.058   503.062     0.150
    46.118   502.875     0.150
    46.118   504.523     0.150
    46.181   504.250     0.150
    46.189   506.297     0.150
    46.173   502.875     0.150
    46.173   505.141     0.150
    46.370   506.664     0.150
    46.309   505.984     0.150
    46.463   507.867     0.150
    46.498   508.102     0.150
    46.524   507.750     0.150
    46.560   506.312     0.150
    46.567   505.727     0.150
    46.493   506.562     0.150
    46.493   506.758     0.150
    46.742   510.117     0.150
    46.832   509.633     0.150
    46.834   510.828     0.150
    46.630   614.414     0.150
    47.012   512.398     0.150
    47.068   513.086     0.150
    47.169   513.555     0.150
    47.302   514.469     0.150
    47.377   515.125     0.150
    47.555   516.289     0.150
    47.563   516.586     0.150
    47.739   518.047     0.150
    47.746   516.820     0.150
    47.991   519.820     0.150
    48.112   520.711     0.150
    48.213   522.164     0.150
    47.999   518.211     0.150
    48.471   524.086     0.150
    48.500   522.438     0.150
    48.500   524.055     0.150
    48.600   524.617     0.150
    48.628   524.422     0.150
    48.364   521.516     0.150
    48.651   525.391     0.150
    48.470   523.617     0.150
    48.470   942.617     0.150
    48.521   523.781     0.150
    48.521   523.516     0.150
    48.521   607.617     0.150
    48.521   946.117     0.150
    48.521   525.070     0.150
    48.621   524.812     0.150
    48.621   609.852     0.150
    48.621   637.953     0.150
    48.638   523.281     0.150
    48.565   523.617     0.150
    48.685   525.211     0.150
    48.805   525.781     0.150
    49.040   528.289     0.150
    48.867   525.211     0.150
    48.889   525.711     0.150
    49.182   528.836     0.150
    49.075   526.758     0.150
    49.240   529.516     0.150
    49.078   525.211     0.150
    49.078   947.711     0.150
    49.365   529.133     0.150
    49.365   530.484     0.150
    49.279   528.062     0.150
    49.543   531.383     0.150
    49.587   531.055     0.150
    49.587   530.664     0.150
    49.587   533.656     0.150
    49.814   532.523     0.150
    49.863   533.172     0.150
    49.641   532.727     0.150
    49.641   613.320     0.150
    49.641   962.555     0.150
    50.235   537.078     0.150
    50.069   534.367     0.150
    50.073   535.531     0.150
    50.073   535.688     0.150
    50.073   536.516     0.150
    50.287   535.648     0.150
    50.294   535.391     0.150
    50.333   534.711     0.150
    50.333  1182.516     0.150
    50.449   537.906     0.150
    50.581   539.414     0.150
    50.480   537.117     0.150
    50.480   537.039     0.150
    50.356   536.711     0.150
    50.536   538.484     0.150
    50.717   540.836     0.150
    50.592   537.953     0.150
    50.711   538.836     0.150
    50.578   538.234     0.150
    50.578   655.516     0.150
    50.578   538.711     0.150
    50.578   539.211     0.150
    50.590   537.812     0.150
    50.590   539.672     0.150
    50.664   537.016     0.150
    50.664   971.711     0.150
    50.974   543.086     0.150
    51.126   544.141     0.150
    51.000   541.586     0.150
    50.950   540.961     0.150
    50.950   541.312     0.150
    50.819   541.945     0.150
    50.819   543.477     0.150
    51.305   544.031     0.150
    51.381   545.406     0.150
    51.686   547.656     0.150
    51.819   549.117     0.150
    51.708   547.477     0.150
    51.967   549.820     0.150
    52.015   548.906     0.150
    52.015   549.508     0.150
    51.966   548.695     0.150
    52.020   549.836     0.150
    52.239   993.914     0.150
    52.239  1212.711     0.150
    52.447   552.492     0.150
    52.860   556.812     0.150
    52.866   556.547     0.150
    52.682   554.438     0.150
    52.837   555.773     0.150
    53.029   558.328     0.150
    52.977   557.523     0.150
    53.439   560.383     0.150
    53.488   561.297     0.150
    53.532   561.164     0.150
    53.434   555.914     0.150
    53.434  1008.914     0.150
    53.884   564.477     0.150
    53.971   565.508     0.150
    54.156   565.867     0.150
    54.337   564.586     0.150
    54.337   563.992     0.150
    54.337   565.812     0.150
    54.267   566.320     0.150
    54.260   566.375     0.150
    54.643   569.516     0.150
    54.609   568.188     0.150
    54.622   568.570     0.150
    54.622   569.297     0.150
    54.794   568.133     0.150
    54.987   575.102     0.150
    54.852   570.172     0.150
    55.019   573.242     0.150
    55.132   571.594     0.150
    55.191   576.195     0.150
    55.390   575.945     0.150
    55.410   578.578     0.150
    55.468   577.320     0.150
    55.469   577.570     0.150
    55.501   575.016     0.150
    55.720   578.883     0.150
    55.938   577.031     0.150
    55.751   580.586     0.150
    55.839   577.141     0.150
    55.839   580.297     0.150
    55.928   581.094     0.150
    56.283   581.906     0.150
    56.267   580.914     0.150
    56.267   580.562     0.150
    56.267   579.094     0.150
    56.267   580.914     0.150
    56.303   582.555     0.150
    56.384   585.008     0.150
    56.430   581.688     0.150
    56.511   583.516     0.150
    56.810   584.438     0.150
    56.810   588.281     0.150
    56.988   584.633     0.150
    57.070   589.617     0.150
    57.136  1060.914     0.150
    57.136   715.914     0.150
    57.189   586.062     0.150
    57.189   589.414     0.150
    57.189   589.805     0.150
    57.257   589.500     0.150
    57.400   592.281     0.150
    57.431   591.953     0.150
    57.461   591.414     0.150
    57.768   594.352     0.150
    57.780   592.508     0.150
    57.954   593.680     0.150
    58.040   597.219     0.150
    58.356   597.516     0.150
    58.526  1081.812     0.150
    58.559   600.609     0.150
    58.588   598.711     0.150
    58.588  1079.711     0.150
    58.760   598.586     0.150
    59.229   603.461     0.150
    59.299   603.422     0.150
    59.291   601.297     0.150
    59.649   603.812     0.150
    59.649   603.617     0.150
    59.687   606.008     0.150
    59.886   609.492     0.150
    59.920   607.516     0.150
    60.008   606.305     0.150
    60.226   612.016     0.150
    60.300   610.750     0.150
    60.387   611.320     0.150
    60.519   612.125     0.150
    60.828   614.242     0.150
    60.904   616.094     0.150
    61.043   615.828     0.150
    61.305   614.891     0.150
    61.305   617.781     0.150
    61.428   618.227     0.150
    61.563   619.062     0.150
    61.941   619.711     0.150
    62.177   621.633     0.150
    64.071   630.031     0.150
    64.329   632.734     0.150
    64.134   632.461     0.150
    64.137   632.750     0.150
    65.742   643.641     0.150
    68.476   661.273     0.150
    69.261   666.688     0.150
    69.893   669.039     0.150
    70.053   670.781     0.150
    70.625   675.023     0.150
    71.245   679.164     0.150
    71.612   680.906     0.150
    71.914   683.070     0.150
    72.797   688.023     0.150
    72.978   688.164     0.150
    72.978   688.711     0.150
    73.388   691.703     0.150
    73.390   691.242     0.150
    73.390   692.438     0.150
    73.657   692.602     0.150
    73.657   694.539     0.150
    73.646   691.984     0.150
    74.093   695.758     0.150
    74.861  1281.016     0.150
    75.114   699.961     0.150
    75.835   704.656     0.150
    75.856   703.555     0.150
    76.335   707.391     0.150
    76.582   708.711     0.150
    76.928   711.273     0.150
    76.747   710.391     0.150
    76.747   710.562     0.150
    76.747   711.414     0.150
    76.782   711.258     0.150
    77.310   711.422     0.150
    79.670   726.961     0.150
    80.187   728.734     0.150
    80.360   730.953     0.150
    80.360   731.312     0.150
    81.706   738.609     0.150
    82.054   738.703     0.150
    82.423   740.906     0.150
    82.504   741.188     0.150
    83.395   746.461     0.150
    83.673   747.586     0.150
    85.107   754.320     0.150
    85.546   757.031     0.150
    86.316   760.742     0.150
    86.366   761.133     0.150
    87.145   765.367     0.150
    87.146   765.516     0.150
    87.146   765.688     0.150
    86.840   764.914     0.150
    87.297   765.617     0.150
    87.254  1752.414     0.150
    94.060   798.891     0.150
   135.897  1159.812     0.150
   137.651   992.516     0.150
   139.759  1167.711     0.150
   143.425  1172.125     0.150
   144.265  1173.688     0.150
   145.886  1178.031     0.150
   145.886  1178.930     0.150
   150.160  1186.977     0.150
   150.160  1189.336     0.150
   150.184  1189.938     0.150
   151.855  1192.844     0.150
   151.871  1193.367     0.150
   151.871  1192.156     0.150
   153.396  1201.523     0.150
   153.713  1206.320     0.150
     0.299     5.984     0.150
     0.299     9.781     0.150
     0.299     6.086     0.150
     0.299     9.586     0.150
     1.286    24.180     0.150
     1.286    26.281     0.150
     1.286    40.984     0.150
     2.015    37.281     0.150
     2.015    63.680     0.150
     2.015    36.586     0.150
     2.015    37.180     0.150
     2.479    41.680     0.150
     2.479    44.984     0.150
     2.479    76.586     0.150
     2.479    71.180     0.150
     2.479    77.180     0.150
     2.478    42.484     0.150
     2.478    45.180     0.150
     2.478    78.680     0.150
     2.478    42.281     0.150
     2.478    45.484     0.150
     2.478    73.281     0.150
     2.478    78.883     0.150
     2.530    46.781     0.150
     2.530    79.680     0.150
     2.714    45.781     0.150
     2.714    49.883     0.150
     2.714    85.383     0.150
     2.714    45.883     0.150
     2.714    50.086     0.150
     2.714    85.883     0.150
     3.531   110.680     0.150
     3.797    68.281     0.150
     3.797   116.680     0.150
     3.797    60.883     0.150
     3.797    69.383     0.150
     3.797   103.180     0.150
     3.797   118.781     0.150
     3.872    61.680     0.150
     3.872    69.984     0.150
     3.872   103.680     0.150
     3.872   120.086     0.150
     3.872    61.781     0.150
     3.872    70.586     0.150
     3.872   105.680     0.150
     3.872   121.180     0.150
     4.039    63.281     0.150
     4.039    73.180     0.150
     4.039   125.680     0.150
     4.039    62.883     0.150
     4.039   108.180     0.150
     4.253    67.086     0.150
     4.253    76.984     0.150
     4.253   113.281     0.150
     4.253   132.984     0.150
     4.253    77.086     0.150
     4.253   115.883     0.150
     4.253   133.484     0.150
     4.807    73.984     0.150
     4.807    87.086     0.150
     5.310   166.680     0.150
     5.478    83.781     0.150
     5.478    99.984     0.150
     5.478   171.781     0.150
     6.037    91.680     0.150
     6.317    95.383     0.150
     6.317   115.281     0.150
     6.317   197.281     0.150
     6.682   100.281     0.150
     6.682   121.586     0.150
     6.682   100.180     0.150
     6.682   121.883     0.150
     6.682   172.781     0.150
     6.682   209.086     0.150
     6.705   100.781     0.150
     6.705   121.484     0.150
     6.705   208.383     0.150
     6.779   101.883     0.150
     6.779   123.883     0.150
     6.779   211.781     0.150
     6.942   216.984     0.150
     7.171   224.609     0.150
     7.458   134.086     0.150
     7.458   233.086     0.150
     7.515   234.883     0.150
     7.715   240.180     0.150
     7.724   112.984     0.150
     7.724   113.180     0.150
     7.724   241.484     0.150
     7.791   115.586     0.150
     7.791   242.586     0.150
     8.017   250.383     0.150
     8.068   251.984     0.150
     8.045   115.883     0.150
     8.045   205.180     0.150
     8.133   252.781     0.150
     8.534   265.883     0.150
     9.069   282.484     0.150
     9.132   284.883     0.150
     9.317   288.984     0.150
     9.774   303.383     0.150
    10.259   318.781     0.150
    10.766   334.680     0.150
    11.044   157.781     0.150
    11.044   344.086     0.150
    11.140   162.586     0.150
    11.140   345.180     0.150
    11.110   161.984     0.150
    11.320   164.281     0.150
    11.320   285.586     0.150
    11.320   350.883     0.150
    11.317   163.625     0.150
    18.232   256.883     0.150
    19.480   278.680     0.150
    23.962   315.680     0.150
    43.779   485.102     0.150
     0.365     8.059     0.150
     0.365    13.359     0.150
     1.539    27.461     0.150
     1.539    47.660     0.150
     1.539    47.859     0.150
     1.835    32.262     0.150
     2.585    42.859     0.150
     2.585    47.461     0.150
     2.585    73.359     0.150
     2.585    82.262     0.150
     2.585    42.961     0.150
     2.585    81.559     0.150
     2.810    44.359     0.150
     2.810    49.262     0.150
     2.810    84.660     0.150
     2.810    49.160     0.150
     2.810    84.461     0.150
     3.273    51.961     0.150
     3.273    58.461     0.150
     3.273    88.262     0.150
     3.273    99.559     0.150
     3.273    89.359     0.150
     3.273   100.762     0.150
     3.087    96.262     0.150
     3.087    50.359     0.150
     3.087    85.059     0.150
     3.087    96.961     0.150
     3.299   103.559     0.150
     3.299    52.559     0.150
     3.299    60.359     0.150
     4.207    64.461     0.150
     4.207    74.559     0.150
     4.421    68.359     0.150
     4.421    79.762     0.150
     4.421   116.359     0.150
     4.421   137.160     0.150
     4.421    68.160     0.150
     4.421    79.262     0.150
     4.835    73.762     0.150
     4.835    86.559     0.150
     4.835   126.059     0.150
     4.835   150.059     0.150
     4.835    73.559     0.150
     4.835    87.461     0.150
     4.835   126.262     0.150
     5.350    81.262     0.150
     5.350    95.859     0.150
     5.350   139.660     0.150
     5.728    85.961     0.150
     5.728   148.160     0.150
     6.067    90.660     0.150
     6.067   110.262     0.150
     6.067    90.559     0.150
     6.906   215.859     0.150
     7.480   223.805     0.150
     7.480   108.762     0.150
     7.480   132.559     0.150
     7.480   190.160     0.150
     7.264   106.859     0.150
     7.294   106.961     0.150
     7.294   226.961     0.150
     7.412   106.859     0.150
     7.412   192.711     0.150
     7.412   230.934     0.150
     7.531   234.160     0.150
     7.701   196.559     0.150
     7.701   240.359     0.150
     8.104   252.262     0.150
     8.236   119.262     0.150
     8.236   210.359     0.150
     8.236   119.059     0.150
     8.236   256.859     0.150
     8.379   121.461     0.150
     8.377   122.859     0.150
     8.377   260.559     0.150
     8.607   268.262     0.150
     8.657   269.859     0.150
     9.265   288.262     0.150
     9.656   300.859     0.150
     9.715   301.859     0.150
     9.903   307.660     0.150
    10.359   151.359     0.150
    10.359   322.160     0.150
    10.895   157.461     0.150
    10.839   335.359     0.150
    11.609   360.762     0.150
    11.718   169.461     0.150
    11.718   363.059     0.150
    11.883   171.961     0.150
    11.883   296.859     0.150
    11.883   367.961     0.150
    11.886   168.750     0.150
    11.886   372.102     0.150
    15.346   476.277     0.150
    15.346   214.660     0.150
    15.175   473.879     0.150
    16.871   233.203     0.150
    16.871   520.180     0.150
    17.644   547.762     0.150
    17.644   246.059     0.150
    18.552   578.559     0.150
    18.552   255.160     0.150
    19.458   264.582     0.150
    20.398   274.910     0.150
    23.910   314.262     0.150
    24.146   314.637     0.150
    24.159   316.762     0.150
    24.405   318.527     0.150
    24.508   319.133     0.150
    27.654   347.410     0.150
    32.327   388.059     0.150
    37.111   433.059     0.150
    37.454   430.676     0.150
    37.930   438.762     0.150
    42.392   472.621     0.150
    42.392   475.461     0.150
    43.413   484.262     0.150
    43.913   484.984     0.150
    49.308   526.879     0.150
    49.499   528.309     0.150
    53.877   561.477     0.150
    72.417   684.684     0.150
    77.669   714.930     0.150
    81.276   735.273     0.150
     0.520    10.112     0.150
     0.520    16.913     0.150
     1.221    23.413     0.150
     1.221    24.913     0.150
     1.221    39.312     0.150
     1.631    30.513     0.150
     1.631    52.413     0.150
     1.753    32.513     0.150
     1.753    55.413     0.150
     2.114    37.312     0.150
     2.114    38.513     0.150
     2.114    65.812     0.150
     2.656    48.312     0.150
     2.656    83.513     0.150
     2.667    45.112     0.150
     2.667    49.312     0.150
     2.667    85.212     0.150
     2.909    48.013     0.150
     2.909    52.913     0.150
     2.909    91.413     0.150
     2.973    49.013     0.150
     2.973    54.212     0.150
     2.973    93.612     0.150
     3.294    53.712     0.150
     3.294    60.312     0.150
     3.294    90.812     0.150
     3.294   104.112     0.150
     3.914    62.413     0.150
     3.914    71.612     0.150
     3.914   123.013     0.150
     4.516    70.212     0.150
     4.516    81.812     0.150
     4.516   141.112     0.150
     4.521   142.013     0.150
     5.354   167.612     0.150
     5.721    86.712     0.150
     5.721   103.413     0.150
     5.721   150.513     0.150
     5.721   178.312     0.150
     5.815   106.212     0.150
     5.815   182.112     0.150
     0.923    17.809     0.150
     0.923    29.906     0.150
     0.947    18.207     0.150
     0.947    30.707     0.150
     1.705    31.707     0.150
     1.705    55.309     0.150
     2.060    66.309     0.150
     2.142    39.809     0.150
     2.142    68.105     0.150
     2.321    41.008     0.150
     2.321    43.105     0.150
     2.321    69.809     0.150
     2.321    74.605     0.150
     2.438    44.605     0.150
     2.438    75.809     0.150
     2.496    43.707     0.150
     2.496    46.406     0.150
     2.496    79.605     0.150
     3.087    96.309     0.150
     3.400    54.605     0.150
     3.400    62.309     0.150
     3.400   107.406     0.150
     3.683    60.105     0.150
     3.683    68.105     0.150
     3.683   116.605     0.150
     4.147    64.906     0.150
     4.147    75.707     0.150
     4.147   130.207     0.150
     4.299    68.309     0.150
     4.299    78.105     0.150
     4.299   135.309     0.150
     4.669   147.105     0.150
     4.866    89.707     0.150
     4.866   153.105     0.150
     7.090   105.406     0.150
     7.090   221.508     0.150
     0.231     4.672     0.150
     0.231     8.070     0.150
     0.231     4.773     0.150
     0.231     7.570     0.150
     0.953    18.172     0.150
     0.953    30.773     0.150
     1.452    26.875     0.150
     1.452    28.477     0.150
     1.452    46.977     0.150
     1.851    33.672     0.150
     1.851    58.570     0.150
     1.851    33.773     0.150
     2.437    41.172     0.150
     2.437    45.273     0.150
     2.437    76.977     0.150
     2.437    41.570     0.150
     2.437    76.875     0.150
     2.607    43.375     0.150
     2.607    46.875     0.150
     2.607    80.273     0.150
     2.607    43.172     0.150
     2.607    46.977     0.150
     2.607    80.570     0.150
     2.698    49.672     0.150
     2.698    85.477     0.150
     2.698    49.477     0.150
     2.698    85.375     0.150
     2.878    47.773     0.150
     2.878    53.477     0.150
     2.878    52.375     0.150
     2.878    90.477     0.150
     3.630    58.273     0.150
     3.630    65.477     0.150
     3.630   100.070     0.150
     3.630   113.070     0.150
     3.697    68.273     0.150
     3.697   116.773     0.150
     4.039    64.070     0.150
     4.039    73.570     0.150
     4.039   109.172     0.150
     4.039    63.875     0.150
     4.039    74.172     0.150
     4.039   126.273     0.150
     4.131    64.672     0.150
     4.131    75.375     0.150
     4.131   128.570     0.150
     4.417    69.070     0.150
     4.417    80.477     0.150
     4.417   138.172     0.150
     4.974    77.375     0.150
     4.974    90.875     0.150
     4.974   155.273     0.150
     5.425   170.977     0.150
     5.637    86.070     0.150
     5.637   102.875     0.150
     5.637   176.477     0.150
     5.903    89.477     0.150
     6.477    97.070     0.150
     6.477   118.672     0.150
     6.477   168.375     0.150
     6.477   202.875     0.150
     6.846   102.477     0.150
     6.846   102.977     0.150
     6.846   213.570     0.150
     6.865   102.273     0.150
     6.865   125.477     0.150
     6.865   214.273     0.150
     6.941   103.570     0.150
     6.941   217.070     0.150
     7.100   221.977     0.150
     7.180   105.117     0.150
     7.180   225.992     0.150
     7.675   239.070     0.150
     7.831   116.273     0.150
     7.831   200.875     0.150
     7.831   244.977     0.150
     7.869   244.875     0.150
     7.954   118.773     0.150
     7.954   204.375     0.150
     7.954   247.570     0.150
     7.910   114.180     0.150
     7.910   199.367     0.150
     7.910   236.719     0.150
     8.176   255.773     0.150
     8.227   256.477     0.150
     8.357   123.070     0.150
     8.357   213.570     0.150
     8.357   260.672     0.150
     8.839   274.875     0.150
     9.936   143.695     0.150
     9.936   305.391     0.150
     9.936   144.977     0.150
    10.998   157.516     0.150
    10.998   274.969     0.150
    10.998   159.172     0.150
    11.454   165.281     0.150
    11.454   357.703     0.150
    13.718   193.773     0.150
    15.185   472.789     0.150
    15.681   486.891     0.150
    18.079   250.148     0.150
    18.079   562.969     0.150
    19.144   264.125     0.150
    23.978   316.070     0.150
    24.074   316.117     0.150
    24.129   317.570     0.150
    24.129   316.523     0.150
    24.129   319.773     0.150
    27.379   346.523     0.150
    42.817   478.359     0.150
    43.870   486.594     0.150
    49.525   532.875     0.150
    54.273   567.484     0.150
    55.227   574.898     0.150
    77.500   716.766     0.150
     0.224     4.648     0.150
     0.224     7.344     0.150
     0.952    17.945     0.150
     0.952    30.445     0.150
     1.452    26.945     0.150
     1.452    28.344     0.150
     1.452    45.945     0.150
     1.452    47.844     0.150
     1.852    33.945     0.150
     1.852    58.844     0.150
     2.444    41.547     0.150
     2.444    45.250     0.150
     2.444    76.945     0.150
     2.603    43.844     0.150
     2.603    47.047     0.150
     2.603    80.250     0.150
     2.698    44.445     0.150
     2.698    49.750     0.150
     2.698    84.945     0.150
     2.880    47.945     0.150
     2.880    52.547     0.150
     2.880    90.344     0.150
     3.630    58.047     0.150
     3.630    65.750     0.150
     3.630    99.250     0.150
     3.630   112.945     0.150
     3.697    67.750     0.150
     3.697   116.148     0.150
     4.039    63.648     0.150
     4.039    73.547     0.150
     4.039   125.945     0.150
     4.126    64.648     0.150
     4.126    75.750     0.150
     4.126   111.250     0.150
     4.126   129.148     0.150
     4.419    69.250     0.150
     4.419    80.047     0.150
     4.419   138.344     0.150
     4.974    91.047     0.150
     4.974   155.547     0.150
     5.430   170.344     0.150
     5.640    86.047     0.150
     5.640   102.750     0.150
     5.640   148.344     0.150
     5.640   175.945     0.150
     6.480    97.648     0.150
     6.480   118.445     0.150
     6.480   202.547     0.150
     6.848   102.750     0.150
     6.848   125.250     0.150
     6.848   213.750     0.150
     6.868   103.945     0.150
     6.868   125.344     0.150
     6.868   214.344     0.150
     6.944   126.844     0.150
     6.944   216.945     0.150
     7.103   221.648     0.150
     0.227     4.539     0.150
     0.227     4.641     0.150
     0.227     7.438     0.150
     0.951    17.938     0.150
     0.951    30.438     0.150
     1.454    27.344     0.150
     1.454    46.141     0.150
     1.454    28.641     0.150
     1.454    46.938     0.150
     1.454    49.344     0.150
     1.850    33.742     0.150
     1.850    58.539     0.150
     1.850    58.641     0.150
     2.441    76.844     0.150
     2.441    41.438     0.150
     2.441    77.039     0.150
     2.606    46.844     0.150
     2.606    80.344     0.150
     2.606    43.242     0.150
     2.606    74.242     0.150
     2.606    80.242     0.150
     2.700    45.641     0.150
     2.700    49.641     0.150
     2.700    84.844     0.150
     2.881    52.438     0.150
     2.881    90.039     0.150
     2.881    47.938     0.150
     2.881    52.539     0.150
     2.881    90.844     0.150
     3.628    58.242     0.150
     3.628    65.938     0.150
     3.628    99.344     0.150
     3.628   112.938     0.150
     3.699    68.039     0.150
     3.699   116.242     0.150
     3.699   116.641     0.150
     4.041    64.039     0.150
     4.041    73.438     0.150
     4.041   108.742     0.150
     4.041   126.438     0.150
     4.041    73.141     0.150
     4.041   126.141     0.150
     4.129    64.641     0.150
     4.129    75.539     0.150
     4.129   111.844     0.150
     4.129   128.344     0.150
     4.420    69.844     0.150
     4.420    80.438     0.150
     4.420   120.844     0.150
     4.420   138.438     0.150
     4.420    69.438     0.150
     4.420    80.938     0.150
     4.420   118.539     0.150
     4.975    77.742     0.150
     4.975    90.641     0.150
     4.975   155.539     0.150
     5.429    99.344     0.150
     5.429   170.344     0.150
     5.641   103.141     0.150
     5.641    86.344     0.150
     5.641   102.641     0.150
     5.641   147.938     0.150
     5.641   176.539     0.150
     6.481    97.344     0.150
     6.481   118.242     0.150
     6.481   168.242     0.150
     6.481   203.141     0.150
     6.849   102.938     0.150
     6.849   124.844     0.150
     6.849   177.141     0.150
     6.849   212.844     0.150
     6.868   103.438     0.150
     6.868   178.141     0.150
     6.868   214.742     0.150
     6.944   103.641     0.150
     6.944   179.938     0.150
     6.944   216.742     0.150
     7.104   183.344     0.150
     7.104   222.242     0.150
     7.472   109.844     0.150
     7.472   109.344     0.150
     7.472   234.344     0.150
     7.679   239.844     0.150
     7.836   139.539     0.150
     7.836   143.742     0.150
     7.836   245.641     0.150
     7.873   245.938     0.150
     7.957   119.141     0.150
     7.957   207.344     0.150
     7.957   118.141     0.150
     7.957   203.039     0.150
     7.957   247.742     0.150
     7.905   200.336     0.150
     7.905   236.188     0.150
     7.905   200.844     0.150
     8.179   255.039     0.150
     8.230   257.141     0.150
     8.296   257.844     0.150
     8.361   123.344     0.150
     8.361   260.641     0.150
     8.413   122.938     0.150
     8.842   275.141     0.150
     9.299   289.141     0.150
     9.482   294.344     0.150
     9.940   310.906     0.150
     9.940   142.344     0.150
    10.929   157.539     0.150
    11.000   156.406     0.150
    11.000   158.641     0.150
    11.183   160.742     0.150
    11.183   160.367     0.150
    11.458   165.914     0.150
    11.458   358.641     0.150
    11.489   165.742     0.150
    12.331   177.938     0.150
    13.721   195.344     0.150
    17.287   240.656     0.150
    17.287   243.141     0.150
    18.075   250.266     0.150
    18.075   252.539     0.150
    19.145   264.914     0.150
    19.145   265.469     0.150
    19.145   266.641     0.150
    19.145   262.328     0.150
    19.649   269.641     0.150
    21.079   287.742     0.150
    22.711   304.039     0.150
    23.979   315.539     0.150
    23.979   315.992     0.150
    24.075   317.594     0.150
    24.131   317.242     0.150
    24.131   315.719     0.150
    24.131   318.047     0.150
    24.131   319.641     0.150
    24.131   318.578     0.150
    24.293   319.742     0.150
    27.379   348.578     0.150
    27.407   347.344     0.150
    29.878   369.141     0.150
    29.939   371.367     0.150
    31.056   381.484     0.150
    31.056   377.539     0.150
    31.056   377.141     0.150
    32.363   390.883     0.150
    32.933   396.141     0.150
    34.837   414.539     0.150
    34.953   413.422     0.150
    34.953   412.930     0.150
    40.419   459.414     0.150
    40.533   461.930     0.150
    40.607   461.680     0.150
    41.043   465.602     0.150
    42.025   473.523     0.150
    42.812   477.133     0.150
    42.812   478.938     0.150
    43.867   487.500     0.150
    43.867   489.344     0.150
    43.867   487.211     0.150
    44.578   494.797     0.150
    45.642   502.453     0.150
    47.489   516.539     0.150
    48.778   527.078     0.150
    49.293   530.688     0.150
    49.523   531.719     0.150
    49.523   533.141     0.150
    49.523   531.844     0.150
    49.535   532.500     0.150
    49.499   531.984     0.150
    53.554   562.500     0.150
    53.568   562.422     0.150
    54.268   566.023     0.150
    54.268   568.141     0.150
    57.551   590.039     0.150
    57.721   593.016     0.150
    59.655   604.234     0.150
    77.504   715.789     0.150
    77.504   716.742     0.150
    82.917   746.391     0.150
    83.785   749.812     0.150
     0.218     4.500     0.150
     0.218     7.195     0.150
     0.950    18.000     0.150
     0.950    30.398     0.150
     1.454    27.000     0.150
     1.454    45.195     0.150
     1.454    26.898     0.150
     1.454    46.398     0.150
     1.454    49.398     0.150
     1.851    33.500     0.150
     1.851    58.195     0.150
     1.851    33.602     0.150
     1.851    58.500     0.150
     2.450    40.898     0.150
     2.450    44.602     0.150
     2.450    71.102     0.150
     2.450    77.000     0.150
     2.450    41.398     0.150
     2.450    45.398     0.150
     2.450    72.102     0.150
     2.450    77.602     0.150
     2.601    46.602     0.150
     2.601    80.297     0.150
     2.601    43.000     0.150
     2.601    46.898     0.150
     2.601    74.398     0.150
     2.700    49.398     0.150
     2.700    85.195     0.150
     2.883    52.500     0.150
     2.883    89.398     0.150
     2.883    90.695     0.150
     3.629    58.102     0.150
     3.629    65.797     0.150
     3.629    98.398     0.150
     3.629   112.602     0.150
     3.699    67.297     0.150
     3.699   114.602     0.150
     3.699    59.898     0.150
     3.699    68.297     0.150
     3.699   116.398     0.150
     4.041    64.195     0.150
     4.041    72.898     0.150
     4.041   108.297     0.150
     4.041   124.898     0.150
     4.041    63.797     0.150
     4.041    73.797     0.150
     4.041   126.297     0.150
     4.121    64.398     0.150
     4.121    75.102     0.150
     4.121   128.398     0.150
     4.422    69.195     0.150
     4.422    80.398     0.150
     4.422   138.297     0.150
     4.422    80.898     0.150
     4.422   119.297     0.150
     4.975    77.195     0.150
     4.975    90.297     0.150
     4.975   155.500     0.150
     5.436    99.797     0.150
     5.436   171.398     0.150
     5.644    85.797     0.150
     5.644   103.195     0.150
     5.644    85.500     0.150
     5.644   103.297     0.150
     5.644   147.500     0.150
     5.909    89.102     0.150
     6.484    96.695     0.150
     6.484   168.297     0.150
     6.851   102.898     0.150
     6.851   102.297     0.150
     6.851   177.195     0.150
     6.851   214.102     0.150
     6.871   102.500     0.150
     6.871   177.695     0.150
     6.871   214.695     0.150
     6.947   104.602     0.150
     6.947   216.602     0.150
     7.107   105.500     0.150
     7.107   183.602     0.150
     7.107   222.102     0.150
     7.193   104.688     0.150
     7.193   189.742     0.150
     7.193   228.016     0.150
     7.481   234.695     0.150
     7.899   114.945     0.150
     7.899   198.492     0.150
     7.899   200.102     0.150
     7.844   114.297     0.150
     7.844   116.898     0.150
     7.844   202.000     0.150
     7.844   245.797     0.150
     7.877   245.195     0.150
     7.960   119.398     0.150
     7.960   117.195     0.150
     7.960   203.898     0.150
     7.960   248.602     0.150
     8.183   255.102     0.150
     8.234   257.000     0.150
     8.364   124.000     0.150
     8.364   214.000     0.150
     8.364   261.000     0.150
     8.700   271.195     0.150
     8.845   129.297     0.150
     8.845   276.102     0.150
     9.942   145.000     0.150
    10.932   160.398     0.150
    11.006   158.742     0.150
    11.189   162.297     0.150
    11.311   166.195     0.150
    11.464   165.227     0.150
    11.464   291.047     0.150
    11.464   357.305     0.150
    11.490   166.602     0.150
    17.285   537.742     0.150
    17.285   244.695     0.150
    18.071   251.672     0.150
    18.071   563.398     0.150
    18.071   253.695     0.150
    19.143   264.586     0.150
    19.143   267.102     0.150
    19.649   271.797     0.150
    20.288   278.180     0.150
    23.977   318.000     0.150
    24.073   316.555     0.150
    24.131   315.500     0.150
    24.131   317.273     0.150
    24.179   319.398     0.150
    24.330   319.500     0.150
    27.376   347.633     0.150
    31.056   380.602     0.150
    42.806   478.938     0.150
    43.859   486.445     0.150
    43.859   489.398     0.150
    47.485   518.398     0.150
    47.650   519.602     0.150
    49.285   530.109     0.150
    49.517   530.836     0.150
    54.261   565.383     0.150
    57.714   593.023     0.150
    60.313   609.195     0.150
    72.369   687.570     0.150
    77.513   716.648     0.150
    77.513   716.398     0.150
   146.441  1180.242     0.150
     0.219     4.703     0.150
     0.219     7.398     0.150
     0.219     7.500     0.150
     0.958    18.102     0.150
     0.958    30.898     0.150
     1.446    27.102     0.150
     1.446    45.602     0.150
     1.446    27.305     0.150
     1.446    46.805     0.150
     1.859    33.898     0.150
     1.859    58.703     0.150
     1.859    33.703     0.150
     1.859    59.102     0.150
     2.451    41.398     0.150
     2.451    45.000     0.150
     2.451    77.000     0.150
     2.451    45.305     0.150
     2.595    46.703     0.150
     2.595    79.703     0.150
     2.595    43.102     0.150
     2.595    46.805     0.150
     2.595    80.000     0.150
     2.692    45.102     0.150
     2.692    49.703     0.150
     2.692    84.898     0.150
     2.876    47.703     0.150
     2.876    52.805     0.150
     2.876    90.203     0.150
     2.876    47.805     0.150
     2.876    53.000     0.150
     2.876    90.500     0.150
     3.691    68.000     0.150
     3.691   116.500     0.150
     3.636    58.305     0.150
     3.636    64.398     0.150
     3.636   111.305     0.150
     3.636    65.898     0.150
     3.636   113.703     0.150
     4.033    63.703     0.150
     4.033    72.703     0.150
     4.033   109.102     0.150
     4.033   125.102     0.150
     4.033    64.000     0.150
     4.033    73.805     0.150
     4.033   125.898     0.150
     4.117    64.703     0.150
     4.117    75.000     0.150
     4.117   127.805     0.150
     4.415    69.102     0.150
     4.415    80.305     0.150
     4.415   136.805     0.150
     4.415    69.000     0.150
     4.415    80.703     0.150
     4.415   138.102     0.150
     4.968    77.398     0.150
     4.968    90.898     0.150
     4.968   155.203     0.150
     5.431   170.500     0.150
     5.637    85.602     0.150
     5.637    85.500     0.150
     5.637   102.898     0.150
     5.637   176.500     0.150
     5.915    89.203     0.150
     6.476    97.703     0.150
     6.476   117.703     0.150
     6.476   202.703     0.150
     6.843   102.398     0.150
     6.843   125.398     0.150
     6.843   213.602     0.150
     6.864   103.602     0.150
     6.864   214.203     0.150
     7.100   105.602     0.150
     7.100   129.398     0.150
     7.100   221.398     0.150
     7.193   226.102     0.150
     7.480   109.898     0.150
     7.480   233.398     0.150
     7.674   240.500     0.150
     7.838   114.102     0.150
     7.838   114.898     0.150
     7.838   245.500     0.150
     7.869   245.102     0.150
     7.952   118.805     0.150
     7.952   118.102     0.150
     7.952   248.805     0.150
     7.906   115.523     0.150
     7.906   200.492     0.150
     7.906   239.844     0.150
     7.906   114.703     0.150
     7.906   204.102     0.150
     7.906   115.211     0.150
     8.175   255.000     0.150
     8.291   257.898     0.150
     8.357   123.102     0.150
     8.357   260.898     0.150
     8.424   122.500     0.150
     8.837   130.305     0.150
     8.837   275.703     0.150
     9.934   306.148     0.150
     9.934   142.305     0.150
     9.934   142.062     0.150
    11.011   158.094     0.150
    11.011   341.844     0.150
    11.303   163.898     0.150
    11.457   165.453     0.150
    11.457   289.828     0.150
    11.457   163.375     0.150
    18.078   252.305     0.150
    18.078   563.930     0.150
    18.078   251.898     0.150
    19.135   264.484     0.150
    19.135   261.875     0.150
    19.641   267.602     0.150
    19.820   272.125     0.150
    20.289   277.000     0.150
    21.078   289.000     0.150
    23.970   316.602     0.150
    23.970   314.641     0.150
    24.066   316.602     0.150
    24.123   315.305     0.150
    24.123   317.211     0.150
    24.123   316.820     0.150
    24.285   318.805     0.150
    27.369   346.602     0.150
    31.048   379.000     0.150
    34.829   411.898     0.150
    34.943   411.781     0.150
    34.943   411.781     0.150
    35.870   420.719     0.150
    37.072   429.148     0.150
    39.275   448.352     0.150
    42.025   472.969     0.150
    42.813   479.305     0.150
    43.856   486.875     0.150
    43.856   487.305     0.150
    47.478   515.805     0.150
    49.282   528.828     0.150
    49.512   531.023     0.150
    54.266   567.406     0.150
    57.710   592.094     0.150
    72.366   687.562     0.150
    77.513   716.367     0.150
     0.212     4.420     0.150
     0.212     7.119     0.150
     0.942    17.920     0.150
     0.942    30.220     0.150
     1.461    26.920     0.150
     1.461    44.920     0.150
     1.461    45.920     0.150
     1.845    33.520     0.150
     1.845    58.119     0.150
     1.845    34.020     0.150
     1.845    58.420     0.150
     2.604    42.920     0.150
     2.604    46.720     0.150
     2.604    80.119     0.150
     2.604    46.619     0.150
     2.604    80.220     0.150
     2.453    75.920     0.150
     2.453    41.420     0.150
     2.453    44.420     0.150
     2.453    76.819     0.150
     2.708    45.319     0.150
     2.708    49.319     0.150
     2.708    76.720     0.150
     2.708    84.520     0.150
     2.892    48.319     0.150
     2.892    52.720     0.150
     2.892    90.319     0.150
     2.892    47.819     0.150
     2.892    52.420     0.150
     3.621    65.920     0.150
     3.621   111.520     0.150
     3.621    56.520     0.150
     3.621    65.420     0.150
     3.621    98.020     0.150
     3.621   111.819     0.150
     3.707    67.119     0.150
     3.707   114.819     0.150
     4.122    64.420     0.150
     4.122    75.619     0.150
     4.122   128.819     0.150
     4.122    64.319     0.150
     4.122    75.020     0.150
     4.122   128.520     0.150
     4.049    74.420     0.150
     4.049   109.119     0.150
     4.049   126.319     0.150
     4.049    63.819     0.150
     4.049    73.319     0.150
     4.431    69.220     0.150
     4.431    80.119     0.150
     4.431   118.020     0.150
     4.431   137.920     0.150
     4.983    77.319     0.150
     4.983    90.520     0.150
     4.983   155.420     0.150
     5.445    98.420     0.150
     5.653    85.819     0.150
     5.653   103.220     0.150
     5.653   103.020     0.150
     5.653   148.020     0.150
     5.905    89.420     0.150
     5.905   107.920     0.150
     6.493    97.420     0.150
     6.493   118.020     0.150
     6.493   168.520     0.150
     6.860   102.619     0.150
     6.860   102.720     0.150
     6.860   177.319     0.150
     6.880   102.920     0.150
     6.880   178.020     0.150
     6.956   104.319     0.150
     6.956   180.020     0.150
     7.116   183.520     0.150
     7.199   105.237     0.150
     7.199   225.737     0.150
     7.890   200.788     0.150
     7.890   234.464     0.150
     7.890   199.819     0.150
     7.486   108.619     0.150
     7.486   191.920     0.150
     7.886   117.319     0.150
     7.886   202.920     0.150
     7.852   114.520     0.150
     7.852   202.819     0.150
     7.968   117.819     0.150
     7.968   118.319     0.150
     7.968   203.619     0.150
     8.374   213.619     0.150
     8.374   260.420     0.150
     8.420   122.720     0.150
     8.854   130.020     0.150
     8.854   274.819     0.150
     9.245   285.720     0.150
     9.951   143.537     0.150
    11.004   158.312     0.150
    11.004   158.520     0.150
    11.198   161.220     0.150
    11.319   165.520     0.150
    11.498   165.619     0.150
    11.473   165.640     0.150
    15.660   382.014     0.150
    15.196   217.036     0.150
    16.169   230.420     0.150
    16.453   238.220     0.150
    17.276   237.964     0.150
    17.276   535.589     0.150
    17.276   242.119     0.150
    17.276   241.050     0.150
    18.062   248.119     0.150
    18.062   560.994     0.150
    18.062   252.119     0.150
    18.562   254.994     0.150
    19.149   265.779     0.150
    19.149   265.220     0.150
    19.149   265.819     0.150
    20.291   278.475     0.150
    21.094   287.420     0.150
    22.704   304.395     0.150
    23.203   311.319     0.150
    23.424   314.449     0.150
    23.984   314.720     0.150
    23.984   315.989     0.150
    24.080   317.744     0.150
    24.320   316.720     0.150
    24.139   315.619     0.150
    24.139   317.619     0.150
    24.139   319.020     0.150
    24.139   318.170     0.150
    24.301   320.520     0.150
    27.381   347.994     0.150
    27.409   344.220     0.150
    29.500   368.300     0.150
    31.063   377.420     0.150
    31.063   382.069     0.150
    32.129   388.119     0.150
    32.129   449.819     0.150
    32.129   388.710     0.150
    32.939   397.920     0.150
    32.939   397.720     0.150
    34.955   413.579     0.150
    34.955   413.810     0.150
    37.057   431.369     0.150
    37.464   434.029     0.150
    37.806   437.130     0.150
    39.837   456.220     0.150
    40.403   459.050     0.150
    40.517   457.689     0.150
    42.010   470.670     0.150
    42.797   479.319     0.150
    42.797   477.229     0.150
    42.968   478.560     0.150
    43.860   487.170     0.150
    44.258   488.960     0.150
    46.447   506.890     0.150
    46.959   510.600     0.150
    47.489   515.619     0.150
    49.285   530.055     0.150
    49.490   530.029     0.150
    49.520   530.877     0.150
    49.520   532.720     0.150
    53.551   561.729     0.150
    53.564   561.920     0.150
    54.252   565.619     0.150
    54.252   567.720     0.150
    55.226   574.064     0.150
    57.716   591.369     0.150
    57.716   591.720     0.150
    59.176   602.125     0.150
    59.245   602.358     0.150
    59.254   601.976     0.150
    59.470   603.815     0.150
    59.784   606.505     0.150
    59.857   606.731     0.150
    72.370   687.944     0.150
    73.039   691.920     0.150
    73.869   696.319     0.150
    77.517   716.711     0.150
    81.117   736.251     0.150
   149.503  1189.595     0.150
     0.223     4.588     0.150
     0.223     7.188     0.150
     0.948    17.887     0.150
     0.948    30.787     0.150
     1.456    27.188     0.150
     1.456    46.986     0.150
     1.848    33.887     0.150
     1.848    58.787     0.150
     2.444    41.688     0.150
     2.444    45.188     0.150
     2.444    76.986     0.150
     2.606    43.486     0.150
     2.606    46.986     0.150
     2.606    80.588     0.150
     2.702    49.787     0.150
     2.702    85.688     0.150
     2.884    48.088     0.150
     2.884    53.088     0.150
     2.884    90.688     0.150
     3.626    56.986     0.150
     3.626    66.088     0.150
     3.626    99.986     0.150
     3.626   113.387     0.150
     4.043    64.188     0.150
     4.043    73.588     0.150
     4.043   126.387     0.150
     4.127    74.486     0.150
     4.127   128.387     0.150
     4.424    69.188     0.150
     4.424    81.088     0.150
     4.424   138.986     0.150
     4.978    76.287     0.150
     4.978    90.787     0.150
     4.978   155.588     0.150
     5.644   103.188     0.150
     5.644   176.387     0.150
     6.852   103.387     0.150
     6.852   125.088     0.150
     6.852   213.486     0.150
     6.872   104.287     0.150
     6.872   125.486     0.150
     6.872   215.287     0.150
     6.948   217.387     0.150
     7.475   233.188     0.150
     7.841   244.387     0.150
     0.957    17.137     0.150
     0.957    30.438     0.150
     1.443    26.438     0.150
     1.866    33.035     0.150
     1.866    33.637     0.150
     1.866    58.336     0.150
     2.480    41.035     0.150
     2.480    44.738     0.150
     2.480    71.535     0.150
     2.480    76.438     0.150
     2.576    42.535     0.150
     2.576    79.836     0.150
     2.691    49.438     0.150
     2.691    84.738     0.150
     2.881    46.637     0.150
     2.881    52.137     0.150
     2.881    90.238     0.150
     3.640    57.238     0.150
     3.640    65.137     0.150
     3.640   112.637     0.150
     3.688   115.938     0.150
     4.031    73.336     0.150
     4.031   125.535     0.150
     4.093    63.438     0.150
     4.093    74.438     0.150
     4.093   127.836     0.150
     4.419    80.035     0.150
     4.419   138.035     0.150
     4.965    76.836     0.150
     4.965    90.535     0.150
     4.965   155.035     0.150
     5.645   102.836     0.150
     5.645   176.336     0.150
     6.848   124.637     0.150
     6.848   213.137     0.150
     6.872   103.035     0.150
     6.945   217.035     0.150
     7.860   115.836     0.150
     7.860   245.137     0.150
     0.210     4.340     0.150
     0.210     7.141     0.150
     0.938    17.840     0.150
     0.938    30.242     0.150
     1.464    26.941     0.150
     1.464    28.742     0.150
     1.464    46.840     0.150
     1.464    49.141     0.150
     1.842    33.441     0.150
     1.842    33.941     0.150
     1.842    58.441     0.150
     2.455    41.340     0.150
     2.455    44.941     0.150
     2.455    71.941     0.150
     2.455    77.441     0.150
     2.605    42.742     0.150
     2.605    46.742     0.150
     2.605    74.441     0.150
     2.605    80.641     0.150
     2.711    50.543     0.150
     2.711    85.543     0.150
     2.896    47.742     0.150
     2.896    52.641     0.150
     2.896    90.641     0.150
     3.618    56.641     0.150
     3.618    65.340     0.150
     3.618   112.840     0.150
     3.710    68.242     0.150
     3.710   116.043     0.150
     4.052    64.141     0.150
     4.052    74.141     0.150
     4.052   126.242     0.150
     4.122    64.840     0.150
     4.122    75.641     0.150
     4.122   128.441     0.150
     4.435    80.141     0.150
     4.435   138.141     0.150
     4.986    91.340     0.150
     4.986   155.742     0.150
     5.449   171.043     0.150
     5.657    85.742     0.150
     5.657   103.543     0.150
     5.657   176.742     0.150
     6.864   103.043     0.150
     6.864   125.242     0.150
     6.864   214.441     0.150
     6.884   103.941     0.150
     6.884   125.941     0.150
     6.884   214.340     0.150
     6.960   104.742     0.150
     6.960   217.641     0.150
     7.489   234.141     0.150
     7.856   117.141     0.150
     7.856   143.742     0.150
     7.856   245.543     0.150
     0.233     4.742     0.150
     0.233     7.641     0.150
     0.950    30.641     0.150
     1.456    27.242     0.150
     1.456    46.938     0.150
     1.847    32.938     0.150
     1.847    34.039     0.150
     1.847    59.039     0.150
     2.434    41.844     0.150
     2.434    45.039     0.150
     2.434    71.742     0.150
     2.434    76.938     0.150
     2.611    43.141     0.150
     2.611    47.141     0.150
     2.611    74.844     0.150
     2.611    80.742     0.150
     2.701    44.641     0.150
     2.701    50.344     0.150
     2.701    78.539     0.150
     2.701    85.438     0.150
     2.881    47.844     0.150
     2.881    53.039     0.150
     2.881    82.539     0.150
     2.881    90.844     0.150
     3.627    58.242     0.150
     3.627    66.539     0.150
     3.627   113.844     0.150
     3.702    59.742     0.150
     3.702    68.641     0.150
     3.702   116.844     0.150
     4.042    63.938     0.150
     4.042    73.938     0.150
     4.042   127.242     0.150
     4.135   127.641     0.150
     4.420    69.641     0.150
     4.420    80.742     0.150
     4.420   120.242     0.150
     4.420   138.539     0.150
     5.425   170.344     0.150
     5.640   103.039     0.150
     5.640   176.242     0.150
     6.480   116.938     0.150
     6.480   168.539     0.150
     6.480   201.539     0.150
     6.849   213.539     0.150
     6.867   103.242     0.150
     6.867   124.938     0.150
     6.867   177.242     0.150
     6.867   213.938     0.150
     6.944   176.641     0.150
     6.944   216.438     0.150
     7.465   232.844     0.150
     0.212     4.852     0.150
     0.212     7.750     0.150
     0.953    17.953     0.150
     0.953    30.555     0.150
     1.449    47.250     0.150
     1.856    34.250     0.150
     1.856    58.453     0.150
     2.457    44.852     0.150
     2.457    71.250     0.150
     2.457    77.250     0.150
     2.594    46.555     0.150
     2.594    71.648     0.150
     2.594    80.250     0.150
     2.696    44.250     0.150
     2.696    49.852     0.150
     2.696    85.453     0.150
     2.881    47.148     0.150
     2.881    53.055     0.150
     2.881    79.250     0.150
     2.881    90.953     0.150
     3.633    65.352     0.150
     3.633    96.750     0.150
     3.633   112.352     0.150
     3.695   115.648     0.150
     4.037    62.453     0.150
     4.037    73.555     0.150
     4.037   126.852     0.150
     4.114    64.453     0.150
     4.114    74.648     0.150
     4.114   127.852     0.150
     4.420    68.453     0.150
     4.420    80.148     0.150
     4.420   117.555     0.150
     4.420   138.750     0.150
     4.971    76.555     0.150
     4.971    90.352     0.150
     4.971   130.555     0.150
     4.971   155.555     0.150
     5.643   176.555     0.150
     6.482   118.352     0.150
     6.482   202.953     0.150
     6.849   213.453     0.150
     6.870   177.250     0.150
     6.870   214.352     0.150
     6.945   216.250     0.150
     7.487   233.555     0.150
     0.216     4.270     0.150
     0.216     7.066     0.150
     0.216     4.469     0.150
     0.216     7.168     0.150
     0.934    17.770     0.150
     0.934    30.566     0.150
     1.469    27.066     0.150
     1.469    48.367     0.150
     1.469    47.168     0.150
     1.469    49.867     0.150
     1.836    33.469     0.150
     1.836    57.770     0.150
     1.836    58.668     0.150
     2.447    41.469     0.150
     2.447    45.066     0.150
     2.447    76.969     0.150
     2.447    45.367     0.150
     2.613    43.168     0.150
     2.613    46.867     0.150
     2.613    81.066     0.150
     2.613    43.668     0.150
     2.613    46.969     0.150
     2.613    80.270     0.150
     2.716    49.770     0.150
     2.716    85.668     0.150
     2.716    45.969     0.150
     2.716    85.867     0.150
     2.899    47.969     0.150
     2.899    53.770     0.150
     2.899    52.867     0.150
     2.899    90.867     0.150
     3.613    58.270     0.150
     3.613    65.668     0.150
     3.613   112.168     0.150
     3.613    58.168     0.150
     3.613    65.770     0.150
     3.613   113.066     0.150
     3.715    67.668     0.150
     3.715   116.168     0.150
     4.130    64.668     0.150
     4.130    75.770     0.150
     4.130   128.969     0.150
     4.057    74.168     0.150
     4.057   128.367     0.150
     4.057    64.367     0.150
     4.057    74.367     0.150
     4.057   126.867     0.150
     4.438    82.066     0.150
     4.438   139.867     0.150
     4.438    69.367     0.150
     4.438    80.867     0.150
     4.438   138.867     0.150
     4.991    77.566     0.150
     4.991    90.168     0.150
     4.991   156.566     0.150
     5.659    86.270     0.150
     5.659   103.270     0.150
     5.659   146.668     0.150
     5.897    89.066     0.150
     5.897   153.969     0.150
     6.499    98.867     0.150
     6.499   118.469     0.150
     6.499   168.770     0.150
     6.499   203.270     0.150
     6.867   103.066     0.150
     6.867   103.270     0.150
     6.887   104.270     0.150
     6.887   215.066     0.150
     6.962   105.066     0.150
 