#!/bin/bash
gmt begin chara1.31_rdp_0373 pdf,ps
proj=-JX18/12
reg=-R1/44/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0373'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     5.371
     2.000     4.951
     3.000     4.537
     4.000     4.127
     5.000     3.722
     6.000     3.326
     7.000     2.941
     8.000     2.572
     9.000     2.227
    10.000     1.886
    11.000     1.510
    12.000     1.149
    13.000     0.824
    14.000     0.599
    15.000     0.615
    16.000     0.826
    17.000     1.143
    18.000     1.443
    19.000     1.494
    20.000     1.586
    21.000     1.711
    22.000     1.868
    23.000     2.051
    24.000     2.253
    25.000     2.469
    26.000     2.696
    27.000     2.932
    28.000     3.174
    29.000     3.421
    30.000     3.671
    31.000     3.925
    32.000     4.181
    33.000     4.439
    34.000     4.710
    35.000     4.977
    36.000     5.178
    37.000     5.381
    38.000     5.535
    39.000     5.735
    40.000     5.935
    41.000     6.136
    42.000     6.337
    43.000     6.538
    44.000     6.739
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     8.949
     2.000     8.191
     3.000     7.436
     4.000     6.681
     5.000     5.925
     6.000     5.170
     7.000     4.414
     8.000     3.659
     9.000     3.359
    10.000     2.943
    11.000     2.259
    12.000     1.662
    13.000     1.338
    14.000     1.016
    15.000     0.737
    16.000     1.147
    17.000     1.829
    18.000     2.356
    19.000     2.227
    20.000     2.044
    21.000     1.883
    22.000     2.004
    23.000     2.484
    24.000     2.962
    25.000     3.440
    26.000     3.919
    27.000     4.398
    28.000     4.875
    29.000     5.352
    30.000     5.829
    31.000     6.305
    32.000     6.782
    33.000     7.257
    34.000     7.752
    35.000     8.238
    36.000     8.601
    37.000     8.967
    38.000     9.244
    39.000     9.603
    40.000     9.961
    41.000    10.319
    42.000    10.677
    43.000    11.035
    44.000    11.392
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    14.000     4.756 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    14.000     2.656
    14.000     4.656
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    14.000     4.656
    24.000     4.656
    24.000     2.656
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    14.000     4.656
    10.000     4.656
    10.000     2.656
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    14.000     0.000
    14.000     2.656
EOF
gmt plot $proj $reg -Wthick,red << EOF
    10.000     2.656
    24.000     2.656
EOF
gmt plot $proj $reg -Wthick,red << EOF
    10.000     0.000
    10.000     2.656
EOF
gmt plot $proj $reg -Wthick,red << EOF
    24.000     0.000
    24.000     2.656
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20250906.0314.46
     2.000    10.560 Depth of minimum misfit =  14 km on  3 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
