#!/bin/bash
gmt begin chara1.31_rdp_0359 pdf,ps
proj=-JX18/12
reg=-R1/36/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0359'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.669
     2.000     3.230
     3.000     2.794
     4.000     2.361
     5.000     1.934
     6.000     1.517
     7.000     1.120
     8.000     0.753
     9.000     0.434
    10.000     0.342
    11.000     0.539
    12.000     0.598
    13.000     0.545
    14.000     0.620
    15.000     0.791
    16.000     1.051
    17.000     1.340
    18.000     1.645
    19.000     1.956
    20.000     2.268
    21.000     2.549
    22.000     2.820
    23.000     3.101
    24.000     3.380
    25.000     3.661
    26.000     3.942
    27.000     4.253
    28.000     4.534
    29.000     4.821
    30.000     5.110
    31.000     5.393
    32.000     5.673
    33.000     5.957
    34.000     6.240
    35.000     6.519
    36.000     6.746
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    14.922
     2.000    13.087
     3.000    11.253
     4.000     9.419
     5.000     7.585
     6.000     5.751
     7.000     4.224
     8.000     2.724
     9.000     1.393
    10.000     1.119
    11.000     2.060
    12.000     2.246
    13.000     1.841
    14.000     1.833
    15.000     2.544
    16.000     3.707
    17.000     4.973
    18.000     6.339
    19.000     7.706
    20.000     9.048
    21.000    10.243
    22.000    11.385
    23.000    12.568
    24.000    13.738
    25.000    14.911
    26.000    16.085
    27.000    17.362
    28.000    18.533
    29.000    19.732
    30.000    20.929
    31.000    22.101
    32.000    23.263
    33.000    24.438
    34.000    25.609
    35.000    26.762
    36.000    27.694
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    19.000     4.859 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    19.000     2.759
    19.000     4.759
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    19.000     4.759
    23.000     4.759
    23.000     2.759
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    19.000     4.759
    15.000     4.759
    15.000     2.759
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    10.000     0.000
    10.000     2.759
EOF
gmt plot $proj $reg -Wthick,red << EOF
     7.000     2.759
    16.000     2.759
EOF
gmt plot $proj $reg -Wthick,red << EOF
     7.000     0.000
     7.000     2.759
EOF
gmt plot $proj $reg -Wthick,red << EOF
    16.000     0.000
    16.000     2.759
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20240524.1358.51
     2.000    10.560 Depth of minimum misfit =  10 km on 17 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
