#!/bin/bash
gmt begin chara1.31_rdp_0344 pdf,ps
proj=-JX18/12
reg=-R1/35/0/11
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0344'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     2.652
     2.000     2.212
     3.000     1.773
     4.000     1.334
     5.000     0.894
     6.000     0.455
     7.000     0.016
     8.000     0.423
     9.000     0.501
    10.000     0.177
    11.000     0.146
    12.000     0.470
    13.000     0.793
    14.000     1.109
    15.000     1.432
    16.000     1.766
    17.000     2.090
    18.000     2.400
    19.000     2.701
    20.000     3.016
    21.000     3.326
    22.000     3.595
    23.000     3.863
    24.000     4.133
    25.000     4.401
    26.000     4.670
    27.000     4.934
    28.000     5.202
    29.000     5.470
    30.000     5.738
    31.000     6.006
    32.000     6.274
    33.000     6.585
    34.000     6.859
    35.000     7.130
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     3.750
     2.000     3.129
     3.000     2.507
     4.000     1.886
     5.000     1.265
     6.000     0.644
     7.000     0.023
     8.000     0.598
     9.000     0.708
    10.000     0.250
    11.000     0.207
    12.000     0.664
    13.000     1.122
    14.000     1.569
    15.000     2.026
    16.000     2.497
    17.000     2.955
    18.000     3.393
    19.000     3.820
    20.000     4.265
    21.000     4.704
    22.000     5.084
    23.000     5.463
    24.000     5.845
    25.000     6.225
    26.000     6.605
    27.000     6.978
    28.000     7.357
    29.000     7.736
    30.000     8.115
    31.000     8.494
    32.000     8.873
    33.000     9.313
    34.000     9.700
    35.000    10.083
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     5.000     3.763 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     5.000     1.663
     5.000     3.663
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     5.000     3.663
     9.000     3.663
     9.000     1.663
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     5.000     3.663
     1.000     3.663
     1.000     1.663
EOF
gmt plot $proj $reg -Wthicker,red << EOF
     7.000     0.000
     7.000     1.663
EOF
gmt plot $proj $reg -Wthick,red << EOF
     4.000     1.663
    15.000     1.663
EOF
gmt plot $proj $reg -Wthick,red << EOF
     4.000     0.000
     4.000     1.663
EOF
gmt plot $proj $reg -Wthick,red << EOF
    15.000     0.000
    15.000     1.663
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    10.340 Event 20220903.0436.19
     2.000     9.680 Depth of minimum misfit =   7 km on  2 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     8.800 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     8.360 z statistic for depth uncertainty range in red
EOF
gmt end
