#!/bin/bash
gmt begin chara1.31_rdp_0324 pdf,ps
proj=-JX18/12
reg=-R1/39/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0324'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.533
     2.000     3.145
     3.000     2.772
     4.000     2.420
     5.000     2.097
     6.000     1.821
     7.000     1.490
     8.000     1.184
     9.000     0.930
    10.000     0.783
    11.000     0.801
    12.000     0.977
    13.000     1.244
    14.000     1.560
    15.000     1.703
    16.000     1.864
    17.000     2.096
    18.000     2.331
    19.000     2.583
    20.000     2.848
    21.000     3.012
    22.000     3.258
    23.000     3.509
    24.000     3.762
    25.000     4.020
    26.000     4.281
    27.000     4.546
    28.000     4.811
    29.000     5.077
    30.000     5.345
    31.000     5.615
    32.000     5.885
    33.000     6.054
    34.000     6.324
    35.000     6.603
    36.000     6.807
    37.000     7.019
    38.000     7.227
    39.000     7.439
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     4.524
     2.000     3.909
     3.000     3.297
     4.000     2.685
     5.000     2.121
     6.000     2.121
     7.000     1.608
     8.000     1.284
     9.000     1.196
    10.000     1.107
    11.000     1.018
    12.000     1.023
    13.000     1.547
    14.000     2.074
    15.000     2.121
    16.000     2.121
    17.000     2.121
    18.000     2.523
    19.000     2.975
    20.000     3.425
    21.000     3.694
    22.000     4.090
    23.000     4.487
    24.000     4.879
    25.000     5.275
    26.000     5.670
    27.000     6.069
    28.000     6.464
    29.000     6.860
    30.000     7.255
    31.000     7.652
    32.000     8.047
    33.000     8.295
    34.000     8.688
    35.000     9.094
    36.000     9.390
    37.000     9.697
    38.000     9.998
    39.000    10.304
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     5.000     4.847 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     5.000     2.747
     5.000     4.747
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     5.000     4.747
     9.000     4.747
     9.000     2.747
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     5.000     4.747
     1.000     4.747
     1.000     2.747
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    10.000     0.000
    10.000     2.747
EOF
gmt plot $proj $reg -Wthick,red << EOF
     3.000     2.747
    19.000     2.747
EOF
gmt plot $proj $reg -Wthick,red << EOF
     3.000     0.000
     3.000     2.747
EOF
gmt plot $proj $reg -Wthick,red << EOF
    19.000     0.000
    19.000     2.747
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20211126.0617.20
     2.000    10.560 Depth of minimum misfit =  10 km on  2 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
