#!/bin/bash
gmt begin chara1.31_rdp_0285 pdf,ps
proj=-JX18/12
reg=-R1/34/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0285'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     2.408
     2.000     2.010
     3.000     1.633
     4.000     1.292
     5.000     1.022
     6.000     0.679
     7.000     0.404
     8.000     0.389
     9.000     0.653
    10.000     0.939
    11.000     1.082
    12.000     1.286
    13.000     1.529
    14.000     1.791
    15.000     2.071
    16.000     2.364
    17.000     2.659
    18.000     2.958
    19.000     3.259
    20.000     3.562
    21.000     3.828
    22.000     4.094
    23.000     4.333
    24.000     4.605
    25.000     4.878
    26.000     5.152
    27.000     5.428
    28.000     5.703
    29.000     5.978
    30.000     6.253
    31.000     6.529
    32.000     6.805
    33.000     7.080
    34.000     7.356
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     3.158
     2.000     2.542
     3.000     1.926
     4.000     1.311
     5.000     1.260
     6.000     0.732
     7.000     0.533
     8.000     0.446
     9.000     0.852
    10.000     1.273
    11.000     1.273
    12.000     1.299
    13.000     1.747
    14.000     2.190
    15.000     2.637
    16.000     3.091
    17.000     3.538
    18.000     3.984
    19.000     4.430
    20.000     4.875
    21.000     5.262
    22.000     5.647
    23.000     5.994
    24.000     6.386
    25.000     6.780
    26.000     7.174
    27.000     7.571
    28.000     7.964
    29.000     8.358
    30.000     8.752
    31.000     9.146
    32.000     9.539
    33.000     9.932
    34.000    10.325
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     8.000     4.186 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     8.000     2.086
     8.000     4.086
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     8.000     4.086
    12.000     4.086
    12.000     2.086
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     8.000     4.086
     4.000     4.086
     4.000     2.086
EOF
gmt plot $proj $reg -Wthicker,red << EOF
     8.000     0.000
     8.000     2.086
EOF
gmt plot $proj $reg -Wthick,red << EOF
     2.000     2.086
    14.000     2.086
EOF
gmt plot $proj $reg -Wthick,red << EOF
     2.000     0.000
     2.000     2.086
EOF
gmt plot $proj $reg -Wthick,red << EOF
    14.000     0.000
    14.000     2.086
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20210923.1705.26
     2.000    10.560 Depth of minimum misfit =   8 km on  2 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
