#!/bin/bash
gmt begin chara1.31_rdp_0278 pdf,ps
proj=-JX18/12
reg=-R1/32/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0278'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     2.034
     2.000     1.602
     3.000     1.174
     4.000     0.757
     5.000     0.388
     6.000     0.233
     7.000     0.332
     8.000     0.302
     9.000     0.331
    10.000     0.575
    11.000     0.868
    12.000     1.176
    13.000     1.479
    14.000     1.789
    15.000     2.113
    16.000     2.431
    17.000     2.749
    18.000     3.064
    19.000     3.379
    20.000     3.693
    21.000     3.967
    22.000     4.241
    23.000     4.514
    24.000     4.784
    25.000     5.075
    26.000     5.331
    27.000     5.603
    28.000     5.875
    29.000     6.149
    30.000     6.427
    31.000     6.672
    32.000     6.947
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     4.504
     2.000     3.526
     3.000     2.549
     4.000     1.571
     5.000     0.756
     6.000     0.498
     7.000     0.642
     8.000     0.513
     9.000     0.670
    10.000     1.143
    11.000     1.850
    12.000     2.566
    13.000     3.257
    14.000     3.960
    15.000     4.691
    16.000     5.408
    17.000     6.121
    18.000     6.828
    19.000     7.535
    20.000     8.240
    21.000     8.854
    22.000     9.466
    23.000    10.078
    24.000    10.684
    25.000    11.334
    26.000    11.906
    27.000    12.515
    28.000    13.125
    29.000    13.739
    30.000    14.359
    31.000    14.900
    32.000    15.516
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     4.000     4.238 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     4.000     2.138
     4.000     4.138
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     4.000     4.138
     8.000     4.138
     8.000     2.138
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     4.000     4.138
     1.000     4.138
     1.000     2.138
EOF
gmt plot $proj $reg -Wthicker,red << EOF
     6.000     0.000
     6.000     2.138
EOF
gmt plot $proj $reg -Wthick,red << EOF
     3.000     2.138
    12.000     2.138
EOF
gmt plot $proj $reg -Wthick,red << EOF
     3.000     0.000
     3.000     2.138
EOF
gmt plot $proj $reg -Wthick,red << EOF
    12.000     0.000
    12.000     2.138
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20210922.1701.27
     2.000    10.560 Depth of minimum misfit =   6 km on  5 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
