#!/bin/bash
gmt begin chara1.31_rdp_0260 pdf,ps
proj=-JX18/12
reg=-R1/41/0/11
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0260'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     4.230
     2.000     3.789
     3.000     3.348
     4.000     2.908
     5.000     2.467
     6.000     2.026
     7.000     1.585
     8.000     1.144
     9.000     0.703
    10.000     0.263
    11.000     0.178
    12.000     0.619
    13.000     0.640
    14.000     0.321
    15.000     0.002
    16.000     0.330
    17.000     0.653
    18.000     0.975
    19.000     1.297
    20.000     1.619
    21.000     1.901
    22.000     2.181
    23.000     2.462
    24.000     2.742
    25.000     3.022
    26.000     3.296
    27.000     3.589
    28.000     3.876
    29.000     4.162
    30.000     4.449
    31.000     4.736
    32.000     5.022
    33.000     5.308
    34.000     5.594
    35.000     5.884
    36.000     6.104
    37.000     6.108
    38.000     6.337
    39.000     6.548
    40.000     6.760
    41.000     6.972
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     4.230
     2.000     3.789
     3.000     3.348
     4.000     2.908
     5.000     2.467
     6.000     2.026
     7.000     1.585
     8.000     1.144
     9.000     0.703
    10.000     0.263
    11.000     0.178
    12.000     0.619
    13.000     0.640
    14.000     0.321
    15.000     0.002
    16.000     0.330
    17.000     0.653
    18.000     0.975
    19.000     1.297
    20.000     1.619
    21.000     1.901
    22.000     2.181
    23.000     2.462
    24.000     2.742
    25.000     3.022
    26.000     3.296
    27.000     3.589
    28.000     3.876
    29.000     4.162
    30.000     4.449
    31.000     4.736
    32.000     5.022
    33.000     5.308
    34.000     5.594
    35.000     5.884
    36.000     6.104
    37.000     6.108
    38.000     6.337
    39.000     6.548
    40.000     6.760
    41.000     6.972
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     8.000     3.742 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     8.000     1.642
     8.000     3.642
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     8.000     3.642
    12.000     3.642
    12.000     1.642
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     8.000     3.642
     4.000     3.642
     4.000     1.642
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    15.000     0.000
    15.000     1.642
EOF
gmt plot $proj $reg -Wthick,red << EOF
     6.000     1.642
    21.000     1.642
EOF
gmt plot $proj $reg -Wthick,red << EOF
     6.000     0.000
     6.000     1.642
EOF
gmt plot $proj $reg -Wthick,red << EOF
    21.000     0.000
    21.000     1.642
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    10.340 Event 20210815.2326.55
     2.000     9.680 Depth of minimum misfit =  15 km on  1 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     8.800 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     8.360 z statistic for depth uncertainty range in red
EOF
gmt end
