#!/bin/bash
gmt begin chara1.31_rdp_0253 pdf,ps
proj=-JX18/12
reg=-R1/36/0/11
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0253'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     2.420
     2.000     1.982
     3.000     1.544
     4.000     1.105
     5.000     0.667
     6.000     0.228
     7.000     0.210
     8.000     0.649
     9.000     0.335
    10.000     0.021
    11.000     0.293
    12.000     0.607
    13.000     0.921
    14.000     1.234
    15.000     1.548
    16.000     1.864
    17.000     2.178
    18.000     2.510
    19.000     2.822
    20.000     3.135
    21.000     3.406
    22.000     3.678
    23.000     3.949
    24.000     4.221
    25.000     4.492
    26.000     4.764
    27.000     5.036
    28.000     5.308
    29.000     5.581
    30.000     5.884
    31.000     6.153
    32.000     6.422
    33.000     6.692
    34.000     6.962
    35.000     7.230
    36.000     7.431
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     2.420
     2.000     1.982
     3.000     1.544
     4.000     1.105
     5.000     0.667
     6.000     0.228
     7.000     0.210
     8.000     0.649
     9.000     0.335
    10.000     0.021
    11.000     0.293
    12.000     0.607
    13.000     0.921
    14.000     1.234
    15.000     1.548
    16.000     1.864
    17.000     2.178
    18.000     2.510
    19.000     2.822
    20.000     3.135
    21.000     3.406
    22.000     3.678
    23.000     3.949
    24.000     4.221
    25.000     4.492
    26.000     4.764
    27.000     5.036
    28.000     5.308
    29.000     5.581
    30.000     5.884
    31.000     6.153
    32.000     6.422
    33.000     6.692
    34.000     6.962
    35.000     7.230
    36.000     7.431
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    12.000     3.761 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    12.000     1.661
    12.000     3.661
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    12.000     3.661
    16.000     3.661
    16.000     1.661
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    12.000     3.661
     8.000     3.661
     8.000     1.661
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    10.000     0.000
    10.000     1.661
EOF
gmt plot $proj $reg -Wthick,red << EOF
     2.000     1.661
    16.000     1.661
EOF
gmt plot $proj $reg -Wthick,red << EOF
     2.000     0.000
     2.000     1.661
EOF
gmt plot $proj $reg -Wthick,red << EOF
    16.000     0.000
    16.000     1.661
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    10.340 Event 20210511.1222.30
     2.000     9.680 Depth of minimum misfit =  10 km on  1 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     8.800 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     8.360 z statistic for depth uncertainty range in red
EOF
gmt end
