#!/bin/bash
gmt begin chara1.31_rdp_0198 pdf,ps
proj=-JX18/12
reg=-R1/41/0/11
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0198'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.805
     2.000     3.367
     3.000     2.928
     4.000     2.489
     5.000     2.051
     6.000     1.612
     7.000     1.173
     8.000     0.734
     9.000     0.296
    10.000     0.143
    11.000     0.582
    12.000     0.800
    13.000     0.483
    14.000     0.167
    15.000     0.149
    16.000     0.512
    17.000     0.829
    18.000     1.147
    19.000     1.465
    20.000     1.782
    21.000     2.060
    22.000     2.336
    23.000     2.614
    24.000     2.890
    25.000     3.168
    26.000     3.445
    27.000     3.724
    28.000     4.002
    29.000     4.218
    30.000     4.499
    31.000     4.781
    32.000     5.062
    33.000     5.343
    34.000     5.625
    35.000     5.912
    36.000     6.126
    37.000     6.345
    38.000     6.561
    39.000     6.779
    40.000     6.793
    41.000     7.004
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     3.805
     2.000     3.367
     3.000     2.928
     4.000     2.489
     5.000     2.051
     6.000     1.612
     7.000     1.173
     8.000     0.734
     9.000     0.296
    10.000     0.143
    11.000     0.582
    12.000     0.800
    13.000     0.483
    14.000     0.167
    15.000     0.149
    16.000     0.512
    17.000     0.829
    18.000     1.147
    19.000     1.465
    20.000     1.782
    21.000     2.060
    22.000     2.336
    23.000     2.614
    24.000     2.890
    25.000     3.168
    26.000     3.445
    27.000     3.724
    28.000     4.002
    29.000     4.218
    30.000     4.499
    31.000     4.781
    32.000     5.062
    33.000     5.343
    34.000     5.625
    35.000     5.912
    36.000     6.126
    37.000     6.345
    38.000     6.561
    39.000     6.779
    40.000     6.793
    41.000     7.004
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     0.000     3.883 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     0.000     1.783
     0.000     3.783
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     0.000     3.783
     4.000     3.783
     4.000     1.783
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    10.000     0.000
    10.000     1.783
EOF
gmt plot $proj $reg -Wthick,red << EOF
     5.000     1.783
    21.000     1.783
EOF
gmt plot $proj $reg -Wthick,red << EOF
     5.000     0.000
     5.000     1.783
EOF
gmt plot $proj $reg -Wthick,red << EOF
    21.000     0.000
    21.000     1.783
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    10.340 Event 20170403.1253.39
     2.000     9.680 Depth of minimum misfit =  10 km on  1 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     8.800 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     8.360 z statistic for depth uncertainty range in red
EOF
gmt end
