#!/bin/bash
gmt begin chara1.31_rdp_0082 pdf,ps
proj=-JX18/12
reg=-R1/34/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0082'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.324
     2.000     2.886
     3.000     2.448
     4.000     2.015
     5.000     1.587
     6.000     1.172
     7.000     0.783
     8.000     0.431
     9.000     0.278
    10.000     0.416
    11.000     0.532
    12.000     0.487
    13.000     0.594
    14.000     0.823
    15.000     1.097
    16.000     1.384
    17.000     1.686
    18.000     2.006
    19.000     2.323
    20.000     2.641
    21.000     2.914
    22.000     3.194
    23.000     3.479
    24.000     3.776
    25.000     4.068
    26.000     4.343
    27.000     4.615
    28.000     4.896
    29.000     5.188
    30.000     5.473
    31.000     5.756
    32.000     6.042
    33.000     6.317
    34.000     6.593
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    18.585
     2.000    16.070
     3.000    13.553
     4.000    11.037
     5.000     8.519
     6.000     6.094
     7.000     4.022
     8.000     2.098
     9.000     1.266
    10.000     2.168
    11.000     2.701
    12.000     2.191
    13.000     2.308
    14.000     3.769
    15.000     5.579
    16.000     7.346
    17.000     9.149
    18.000    11.008
    19.000    12.840
    20.000    14.679
    21.000    16.253
    22.000    17.863
    23.000    19.489
    24.000    21.191
    25.000    22.851
    26.000    24.421
    27.000    25.970
    28.000    27.573
    29.000    29.232
    30.000    30.850
    31.000    32.457
    32.000    34.081
    33.000    35.644
    34.000    37.209
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    17.000     5.006 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    17.000     2.906
    17.000     4.906
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    17.000     4.906
    21.000     4.906
    21.000     2.906
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    17.000     4.906
    13.000     4.906
    13.000     2.906
EOF
gmt plot $proj $reg -Wthicker,red << EOF
     9.000     0.000
     9.000     2.906
EOF
gmt plot $proj $reg -Wthick,red << EOF
     7.000     2.906
    14.000     2.906
EOF
gmt plot $proj $reg -Wthick,red << EOF
     7.000     0.000
     7.000     2.906
EOF
gmt plot $proj $reg -Wthick,red << EOF
    14.000     0.000
    14.000     2.906
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20050102.0024.38
     2.000    10.560 Depth of minimum misfit =   9 km on 32 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
