#!/bin/bash
gmt begin chara1.31_rdp_0070 pdf,ps
proj=-JX18/12
reg=-R1/35/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0070'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.286
     2.000     2.845
     3.000     2.404
     4.000     1.964
     5.000     1.526
     6.000     1.092
     7.000     0.669
     8.000     0.309
     9.000     0.352
    10.000     0.495
    11.000     0.385
    12.000     0.238
    13.000     0.415
    14.000     0.702
    15.000     1.010
    16.000     1.309
    17.000     1.621
    18.000     1.936
    19.000     2.251
    20.000     2.568
    21.000     2.864
    22.000     3.139
    23.000     3.414
    24.000     3.691
    25.000     4.006
    26.000     4.281
    27.000     4.585
    28.000     4.857
    29.000     5.128
    30.000     5.400
    31.000     5.672
    32.000     5.972
    33.000     6.263
    34.000     6.533
    35.000     6.842
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     9.265
     2.000     8.013
     3.000     6.760
     4.000     5.507
     5.000     4.253
     6.000     3.000
     7.000     1.747
     8.000     0.749
     9.000     0.836
    10.000     1.321
    11.000     0.904
    12.000     0.538
    13.000     0.987
    14.000     1.873
    15.000     2.779
    16.000     3.640
    17.000     4.536
    18.000     5.433
    19.000     6.331
    20.000     7.232
    21.000     8.073
    22.000     8.854
    23.000     9.635
    24.000    10.420
    25.000    11.307
    26.000    12.086
    27.000    12.954
    28.000    13.722
    29.000    14.490
    30.000    15.260
    31.000    16.029
    32.000    16.878
    33.000    17.703
    34.000    18.466
    35.000    19.341
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    13.000     4.278 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    13.000     2.178
    13.000     4.178
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    13.000     4.178
    17.000     4.178
    17.000     2.178
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    13.000     4.178
     9.000     4.178
     9.000     2.178
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    12.000     0.000
    12.000     2.178
EOF
gmt plot $proj $reg -Wthick,red << EOF
     6.000     2.178
    15.000     2.178
EOF
gmt plot $proj $reg -Wthick,red << EOF
     6.000     0.000
     6.000     2.178
EOF
gmt plot $proj $reg -Wthick,red << EOF
    15.000     0.000
    15.000     2.178
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20040628.1422.45
     2.000    10.560 Depth of minimum misfit =  12 km on  8 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
