#!/bin/bash
gmt begin chara1.31_rdp_0054 pdf,ps
proj=-JX18/12
reg=-R1/36/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0054'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.380
     2.000     2.938
     3.000     2.498
     4.000     2.059
     5.000     1.625
     6.000     1.199
     7.000     0.796
     8.000     0.477
     9.000     0.389
    10.000     0.426
    11.000     0.409
    12.000     0.428
    13.000     0.480
    14.000     0.688
    15.000     0.962
    16.000     1.249
    17.000     1.562
    18.000     1.894
    19.000     2.233
    20.000     2.532
    21.000     2.816
    22.000     3.092
    23.000     3.377
    24.000     3.660
    25.000     3.945
    26.000     4.230
    27.000     4.519
    28.000     4.796
    29.000     5.072
    30.000     5.358
    31.000     5.644
    32.000     5.930
    33.000     6.216
    34.000     6.502
    35.000     6.792
    36.000     7.009
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    10.061
     2.000     8.723
     3.000     7.385
     4.000     6.047
     5.000     4.709
     6.000     3.371
     7.000     2.033
     8.000     1.105
     9.000     1.055
    10.000     1.083
    11.000     1.064
    12.000     1.105
    13.000     1.253
    14.000     1.657
    15.000     2.575
    16.000     3.521
    17.000     4.527
    18.000     5.549
    19.000     6.572
    20.000     7.487
    21.000     8.350
    22.000     9.161
    23.000    10.023
    24.000    10.881
    25.000    11.741
    26.000    12.601
    27.000    13.473
    28.000    14.308
    29.000    15.135
    30.000    15.996
    31.000    16.857
    32.000    17.717
    33.000    18.577
    34.000    19.438
    35.000    20.311
    36.000    20.963
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    15.000     4.795 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    15.000     2.695
    15.000     4.695
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    15.000     4.695
    19.000     4.695
    19.000     2.695
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    15.000     4.695
    11.000     4.695
    11.000     2.695
EOF
gmt plot $proj $reg -Wthicker,red << EOF
     9.000     0.000
     9.000     2.695
EOF
gmt plot $proj $reg -Wthick,red << EOF
     6.000     2.695
    16.000     2.695
EOF
gmt plot $proj $reg -Wthick,red << EOF
     6.000     0.000
     6.000     2.695
EOF
gmt plot $proj $reg -Wthick,red << EOF
    16.000     0.000
    16.000     2.695
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 20010331.0644.47
     2.000    10.560 Depth of minimum misfit =   9 km on  9 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
