#!/bin/bash
gmt begin chara1.31_rdp_0037 pdf,ps
proj=-JX18/12
reg=-R1/51/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0037'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     7.110
     2.000     6.669
     3.000     6.229
     4.000     5.790
     5.000     5.350
     6.000     4.911
     7.000     4.472
     8.000     4.034
     9.000     3.597
    10.000     3.160
    11.000     2.726
    12.000     2.293
    13.000     1.865
    14.000     1.444
    15.000     1.053
    16.000     0.696
    17.000     0.497
    18.000     0.629
    19.000     0.965
    20.000     0.877
    21.000     0.807
    22.000     0.860
    23.000     0.706
    24.000     0.543
    25.000     0.496
    26.000     0.592
    27.000     0.777
    28.000     1.004
    29.000     1.224
    30.000     1.483
    31.000     1.747
    32.000     2.034
    33.000     2.304
    34.000     2.576
    35.000     2.847
    36.000     3.054
    37.000     3.260
    38.000     3.467
    39.000     3.674
    40.000     3.881
    41.000     4.088
    42.000     4.296
    43.000     4.551
    44.000     4.769
    45.000     4.986
    46.000     5.206
    47.000     5.423
    48.000     5.641
    49.000     5.859
    50.000     6.079
    51.000     6.297
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    12.285
     2.000    11.519
     3.000    10.755
     4.000     9.991
     5.000     9.227
     6.000     8.463
     7.000     7.699
     8.000     6.935
     9.000     6.171
    10.000     5.406
    11.000     4.642
    12.000     3.878
    13.000     3.114
    14.000     2.350
    15.000     1.609
    16.000     0.848
    17.000     0.775
    18.000     1.029
    19.000     1.436
    20.000     1.479
    21.000     1.380
    22.000     1.284
    23.000     0.873
    24.000     0.671
    25.000     0.831
    26.000     0.991
    27.000     1.147
    28.000     1.515
    29.000     1.950
    30.000     2.430
    31.000     2.908
    32.000     3.418
    33.000     3.898
    34.000     4.379
    35.000     4.856
    36.000     5.220
    37.000     5.582
    38.000     5.944
    39.000     6.306
    40.000     6.668
    41.000     7.029
    42.000     7.392
    43.000     7.836
    44.000     8.216
    45.000     8.594
    46.000     8.976
    47.000     9.354
    48.000     9.733
    49.000    10.113
    50.000    10.494
    51.000    10.873
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    24.000     4.571 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    24.000     2.471
    24.000     4.471
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    24.000     4.471
    28.000     4.471
    28.000     2.471
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    24.000     4.471
    20.000     4.471
    20.000     2.471
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    25.000     0.000
    25.000     2.471
EOF
gmt plot $proj $reg -Wthick,red << EOF
    13.000     2.471
    31.000     2.471
EOF
gmt plot $proj $reg -Wthick,red << EOF
    13.000     0.000
    13.000     2.471
EOF
gmt plot $proj $reg -Wthick,red << EOF
    31.000     0.000
    31.000     2.471
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 19951206.0257.25
     2.000    10.560 Depth of minimum misfit =  25 km on  3 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
