#!/bin/bash
gmt begin chara1.31_rdp_0025 pdf,ps
proj=-JX18/12
reg=-R1/34/0/15
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0025'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.801
     2.000     3.380
     3.000     2.966
     4.000     2.575
     5.000     2.192
     6.000     1.842
     7.000     1.516
     8.000     1.248
     9.000     1.055
    10.000     0.878
    11.000     0.716
    12.000     0.670
    13.000     0.744
    14.000     0.922
    15.000     1.152
    16.000     1.396
    17.000     1.655
    18.000     1.915
    19.000     2.189
    20.000     2.477
    21.000     2.738
    22.000     3.002
    23.000     3.263
    24.000     3.544
    25.000     3.809
    26.000     4.080
    27.000     4.356
    28.000     4.632
    29.000     4.909
    30.000     5.181
    31.000     5.454
    32.000     5.740
    33.000     6.022
    34.000     6.303
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    30.595
     2.000    26.855
     3.000    23.158
     4.000    19.554
     5.000    15.972
     6.000    12.570
     7.000     9.171
     8.000     6.864
     9.000     6.295
    10.000     5.081
    11.000     3.904
    12.000     3.997
    13.000     5.008
    14.000     6.458
    15.000     8.445
    16.000    10.462
    17.000    12.447
    18.000    14.292
    19.000    16.441
    20.000    18.862
    21.000    21.199
    22.000    23.592
    23.000    25.881
    24.000    28.328
    25.000    30.610
    26.000    32.961
    27.000    35.354
    28.000    37.778
    29.000    40.169
    30.000    42.522
    31.000    44.860
    32.000    47.318
    33.000    49.738
    34.000    52.139
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    15.000     7.737 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    15.000     5.637
    15.000     7.637
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    15.000     7.637
    19.000     7.637
    19.000     5.637
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    15.000     7.637
    11.000     7.637
    11.000     5.637
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    12.000     0.000
    12.000     5.637
EOF
gmt plot $proj $reg -Wthick,red << EOF
     9.000     5.637
    14.000     5.637
EOF
gmt plot $proj $reg -Wthick,red << EOF
     9.000     0.000
     9.000     5.637
EOF
gmt plot $proj $reg -Wthick,red << EOF
    14.000     0.000
    14.000     5.637
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    14.100 Event 19940821.1556.00
     2.000    13.200 Depth of minimum misfit =  12 km on 71 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    12.000 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000    11.400 z statistic for depth uncertainty range in red
EOF
gmt end
