#!/bin/bash
gmt begin chara1.31_rdp_0013 pdf,ps
proj=-JX18/12
reg=-R1/37/0/15
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0013'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     4.453
     2.000     4.022
     3.000     3.594
     4.000     3.169
     5.000     2.751
     6.000     2.343
     7.000     1.950
     8.000     1.569
     9.000     1.222
    10.000     0.943
    11.000     0.787
    12.000     0.729
    13.000     0.685
    14.000     0.724
    15.000     0.764
    16.000     0.873
    17.000     1.039
    18.000     1.269
    19.000     1.519
    20.000     1.788
    21.000     2.037
    22.000     2.291
    23.000     2.561
    24.000     2.820
    25.000     3.084
    26.000     3.350
    27.000     3.625
    28.000     3.903
    29.000     4.182
    30.000     4.454
    31.000     4.744
    32.000     5.021
    33.000     5.311
    34.000     5.589
    35.000     5.866
    36.000     6.072
    37.000     6.288
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    33.608
     2.000    30.172
     3.000    26.733
     4.000    23.293
     5.000    19.853
     6.000    16.445
     7.000    13.375
     8.000    10.090
     9.000     7.114
    10.000     5.001
    11.000     4.442
    12.000     4.232
    13.000     4.116
    14.000     4.347
    15.000     4.521
    16.000     5.270
    17.000     6.287
    18.000     8.052
    19.000    10.124
    20.000    12.403
    21.000    14.451
    22.000    16.487
    23.000    18.641
    24.000    20.729
    25.000    22.833
    26.000    24.928
    27.000    27.069
    28.000    29.250
    29.000    31.484
    30.000    33.646
    31.000    35.932
    32.000    38.126
    33.000    40.413
    34.000    42.611
    35.000    44.802
    36.000    46.422
    37.000    48.127
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    17.000     7.856 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    17.000     5.756
    17.000     7.756
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    17.000     7.756
    21.000     7.756
    21.000     5.756
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    17.000     7.756
    13.000     7.756
    13.000     5.756
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    13.000     0.000
    13.000     5.756
EOF
gmt plot $proj $reg -Wthick,red << EOF
     9.000     5.756
    17.000     5.756
EOF
gmt plot $proj $reg -Wthick,red << EOF
     9.000     0.000
     9.000     5.756
EOF
gmt plot $proj $reg -Wthick,red << EOF
    17.000     0.000
    17.000     5.756
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    14.100 Event 19940426.1859.28
     2.000    13.200 Depth of minimum misfit =  13 km on 60 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    12.000 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000    11.400 z statistic for depth uncertainty range in red
EOF
gmt end
