#!/bin/bash
gmt begin chara1.31_rdp_0011 pdf,ps
proj=-JX18/12
reg=-R1/44/0/18
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0011'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     7.399
     2.000     6.982
     3.000     6.568
     4.000     6.148
     5.000     5.712
     6.000     5.286
     7.000     4.815
     8.000     4.424
     9.000     4.050
    10.000     3.693
    11.000     3.355
    12.000     3.039
    13.000     2.736
    14.000     2.478
    15.000     2.250
    16.000     2.030
    17.000     1.814
    18.000     1.617
    19.000     1.439
    20.000     1.320
    21.000     1.272
    22.000     1.285
    23.000     1.361
    24.000     1.474
    25.000     1.622
    26.000     1.801
    27.000     1.999
    28.000     2.202
    29.000     2.423
    30.000     2.651
    31.000     2.879
    32.000     3.103
    33.000     3.316
    34.000     3.515
    35.000     3.729
    36.000     3.896
    37.000     4.066
    38.000     4.242
    39.000     4.420
    40.000     4.596
    41.000     4.777
    42.000     4.958
    43.000     5.135
    44.000     5.325
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    48.922
     2.000    45.878
     3.000    42.838
     4.000    39.734
     5.000    36.470
     6.000    33.158
     7.000    29.504
     8.000    26.384
     9.000    23.331
    10.000    20.405
    11.000    17.860
    12.000    15.222
    13.000    12.984
    14.000    11.537
    15.000    10.743
    16.000    10.051
    17.000     8.970
    18.000     8.024
    19.000     7.122
    20.000     6.856
    21.000     7.049
    22.000     7.364
    23.000     8.072
    24.000     8.815
    25.000     9.624
    26.000    10.588
    27.000    11.664
    28.000    12.974
    29.000    14.435
    30.000    16.041
    31.000    17.578
    32.000    19.092
    33.000    20.478
    34.000    21.772
    35.000    23.058
    36.000    24.022
    37.000    24.973
    38.000    25.996
    39.000    27.055
    40.000    28.154
    41.000    29.320
    42.000    30.526
    43.000    31.808
    44.000    33.150
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    30.000    10.789 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    30.000     8.689
    30.000    10.689
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    30.000    10.689
    34.000    10.689
    34.000     8.689
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    30.000    10.689
    26.000    10.689
    26.000     8.689
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    21.000     0.000
    21.000     8.689
EOF
gmt plot $proj $reg -Wthick,red << EOF
    17.000     8.689
    24.000     8.689
EOF
gmt plot $proj $reg -Wthick,red << EOF
    17.000     0.000
    17.000     8.689
EOF
gmt plot $proj $reg -Wthick,red << EOF
    24.000     0.000
    24.000     8.689
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    16.920 Event 19891025.2029.03
     2.000    15.840 Depth of minimum misfit =  21 km on 48 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    14.400 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000    13.680 z statistic for depth uncertainty range in red
EOF
gmt end
