#!/bin/bash
gmt begin chara1.31_rdp_0007 pdf,ps
proj=-JX18/12
reg=-R15/90/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0007'
gmt plot $proj $reg -Wthick,black << EOF
    15.000     9.468
    16.000     9.035
    17.000     8.601
    18.000     8.167
    19.000     7.734
    20.000     7.305
    21.000     6.922
    22.000     6.541
    23.000     6.160
    24.000     5.781
    25.000     5.372
    26.000     4.994
    27.000     4.618
    28.000     4.241
    29.000     3.865
    30.000     3.489
    31.000     3.114
    32.000     2.740
    33.000     2.367
    34.000     1.995
    35.000     1.627
    36.000     1.337
    37.000     1.053
    38.000     0.782
    39.000     0.545
    40.000     0.406
    41.000     0.479
    42.000     0.699
    43.000     0.969
    44.000     1.258
    45.000     1.555
    46.000     1.856
    47.000     2.160
    48.000     2.465
    49.000     2.703
    50.000     2.743
    51.000     2.806
    52.000     2.884
    53.000     2.698
    54.000     2.478
    55.000     2.290
    56.000     2.103
    57.000     1.917
    58.000     1.731
    59.000     1.547
    60.000     1.363
    61.000     1.157
    62.000     0.982
    63.000     0.814
    64.000     0.630
    65.000     0.507
    66.000     0.423
    67.000     0.446
    68.000     0.547
    69.000     0.676
    70.000     0.821
    71.000     0.000
    72.000     0.000
    73.000     0.000
    74.000     0.000
    75.000     0.000
    76.000     0.000
    77.000     0.000
    78.000     0.000
    79.000     0.000
    80.000     0.000
    81.000     0.000
    82.000     0.000
    83.000     0.000
    84.000     0.000
    85.000     0.000
    86.000     0.000
    87.000     0.000
    88.000     0.000
    89.000     0.000
    90.000     0.000
EOF
gmt plot $proj $reg -Wthin,red << EOF
    15.000    13.378
    16.000    12.765
    17.000    12.151
    18.000    11.537
    19.000    10.923
    20.000    10.316
    21.000     9.773
    22.000     9.233
    23.000     8.694
    24.000     8.155
    25.000     7.576
    26.000     7.040
    27.000     6.506
    28.000     5.971
    29.000     5.436
    30.000     4.902
    31.000     4.367
    32.000     3.833
    33.000     3.299
    34.000     2.765
    35.000     2.231
    36.000     1.804
    37.000     1.377
    38.000     0.949
    39.000     0.566
    40.000     0.566
    41.000     0.566
    42.000     0.810
    43.000     1.248
    44.000     1.687
    45.000     2.125
    46.000     2.563
    47.000     3.001
    48.000     3.439
    49.000     3.792
    50.000     3.877
    51.000     3.962
    52.000     4.039
    53.000     3.773
    54.000     3.458
    55.000     3.189
    56.000     2.920
    57.000     2.651
    58.000     2.382
    59.000     2.113
    60.000     1.843
    61.000     1.535
    62.000     1.268
    63.000     1.002
    64.000     0.688
    65.000     0.566
    66.000     0.566
    67.000     0.566
    68.000     0.566
    69.000     0.770
    70.000     1.014
    71.000     0.000
    72.000     0.000
    73.000     0.000
    74.000     0.000
    75.000     0.000
    76.000     0.000
    77.000     0.000
    78.000     0.000
    79.000     0.000
    80.000     0.000
    81.000     0.000
    82.000     0.000
    83.000     0.000
    84.000     0.000
    85.000     0.000
    86.000     0.000
    87.000     0.000
    88.000     0.000
    89.000     0.000
    90.000     0.000
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     3.000     4.306 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     3.000     2.206
     3.000     4.206
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     3.000     4.206
     7.000     4.206
     7.000     2.206
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     3.000     4.206
    15.000     4.206
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    40.000     0.000
    40.000     2.206
EOF
gmt plot $proj $reg -Wthick,red << EOF
    35.000     2.206
    70.000     2.206
EOF
gmt plot $proj $reg -Wthick,red << EOF
    35.000     0.000
    35.000     2.206
EOF
gmt plot $proj $reg -Wthick,red << EOF
    70.000     0.000
    70.000     2.206
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
    16.000    11.280 Event 19840619.1322.12
    16.000    10.560 Depth of minimum misfit =  40 km on  2 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
    16.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    16.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
