#!/bin/bash
gmt begin chara1.31_rdp_0003 pdf,ps
proj=-JX18/12
reg=-R1/39/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0003'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     4.252
     2.000     3.806
     3.000     3.389
     4.000     2.975
     5.000     2.569
     6.000     2.172
     7.000     1.793
     8.000     1.452
     9.000     1.147
    10.000     0.836
    11.000     0.471
    12.000     0.209
    13.000     0.410
    14.000     0.790
    15.000     0.962
    16.000     1.003
    17.000     1.130
    18.000     1.319
    19.000     1.548
    20.000     1.801
    21.000     2.038
    22.000     2.274
    23.000     2.522
    24.000     2.773
    25.000     3.028
    26.000     3.260
    27.000     3.517
    28.000     3.777
    29.000     4.038
    30.000     4.318
    31.000     4.583
    32.000     4.821
    33.000     5.087
    34.000     5.354
    35.000     5.628
    36.000     5.826
    37.000     5.976
    38.000     6.175
    39.000     6.331
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     9.277
     2.000     8.259
     3.000     7.292
     4.000     6.324
     5.000     5.356
     6.000     4.388
     7.000     3.420
     8.000     2.698
     9.000     2.286
    10.000     1.735
    11.000     0.907
    12.000     0.380
    13.000     0.836
    14.000     1.740
    15.000     2.104
    16.000     1.977
    17.000     1.847
    18.000     1.992
    19.000     2.684
    20.000     3.377
    21.000     3.984
    22.000     4.569
    23.000     5.177
    24.000     5.782
    25.000     6.390
    26.000     6.907
    27.000     7.510
    28.000     8.114
    29.000     8.719
    30.000     9.370
    31.000     9.977
    32.000    10.511
    33.000    11.120
    34.000    11.728
    35.000    12.354
    36.000    12.802
    37.000    13.163
    38.000    13.615
    39.000    13.953
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    14.000     4.120 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    14.000     2.020
    14.000     4.020
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    14.000     4.020
    18.000     4.020
    18.000     2.020
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    14.000     4.020
    10.000     4.020
    10.000     2.020
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    12.000     0.000
    12.000     2.020
EOF
gmt plot $proj $reg -Wthick,red << EOF
     9.000     2.020
    19.000     2.020
EOF
gmt plot $proj $reg -Wthick,red << EOF
     9.000     0.000
     9.000     2.020
EOF
gmt plot $proj $reg -Wthick,red << EOF
    19.000     0.000
    19.000     2.020
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 19810117.1123.31
     2.000    10.560 Depth of minimum misfit =  12 km on  5 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
