#!/bin/bash
gmt begin chara1.31_rdp_0002 pdf,ps
proj=-JX18/12
reg=-R1/35/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0002'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     2.385
     2.000     2.026
     3.000     1.705
     4.000     1.399
     5.000     1.087
     6.000     0.836
     7.000     0.714
     8.000     0.784
     9.000     1.006
    10.000     1.306
    11.000     1.498
    12.000     1.681
    13.000     1.899
    14.000     2.141
    15.000     2.397
    16.000     2.673
    17.000     2.956
    18.000     3.198
    19.000     3.491
    20.000     3.788
    21.000     4.050
    22.000     4.314
    23.000     4.579
    24.000     4.846
    25.000     5.113
    26.000     5.380
    27.000     5.652
    28.000     5.924
    29.000     6.195
    30.000     6.467
    31.000     6.740
    32.000     7.022
    33.000     7.227
    34.000     7.502
    35.000     7.782
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     2.866
     2.000     2.244
     3.000     1.784
     4.000     1.524
     5.000     1.177
     6.000     1.092
     7.000     1.007
     8.000     0.922
     9.000     1.150
    10.000     1.686
    11.000     1.837
    12.000     1.843
    13.000     1.948
    14.000     2.395
    15.000     2.821
    16.000     3.280
    17.000     3.733
    18.000     4.134
    19.000     4.583
    20.000     5.033
    21.000     5.425
    22.000     5.817
    23.000     6.209
    24.000     6.600
    25.000     6.992
    26.000     7.381
    27.000     7.776
    28.000     8.169
    29.000     8.561
    30.000     8.953
    31.000     9.345
    32.000     9.748
    33.000    10.019
    34.000    10.416
    35.000    10.819
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
     7.000     4.747 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
     7.000     2.647
     7.000     4.647
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     7.000     4.647
    15.000     4.647
    15.000     2.647
EOF
gmt plot $proj $reg -Wthick,blue << EOF
     7.000     4.647
     1.000     4.647
     1.000     2.647
EOF
gmt plot $proj $reg -Wthicker,red << EOF
     7.000     0.000
     7.000     2.647
EOF
gmt plot $proj $reg -Wthick,red << EOF
     1.000     2.647
    15.000     2.647
EOF
gmt plot $proj $reg -Wthick,red << EOF
     1.000     0.000
     1.000     2.647
EOF
gmt plot $proj $reg -Wthick,red << EOF
    15.000     0.000
    15.000     2.647
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    11.280 Event 19750206.2126.38
     2.000    10.560 Depth of minimum misfit =   7 km on  2 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
