#!/bin/bash
gmt begin chara1.31_rdp_0001 pdf,ps
proj=-JX18/12
reg=-R1/37/0/13
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases chara1.31 Event 0001'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     3.743
     2.000     3.349
     3.000     2.970
     4.000     2.610
     5.000     2.280
     6.000     1.951
     7.000     1.656
     8.000     1.423
     9.000     1.284
    10.000     1.186
    11.000     1.096
    12.000     1.075
    13.000     1.165
    14.000     1.348
    15.000     1.588
    16.000     1.863
    17.000     2.152
    18.000     2.376
    19.000     2.624
    20.000     2.863
    21.000     3.079
    22.000     3.326
    23.000     3.582
    24.000     3.837
    25.000     4.096
    26.000     4.358
    27.000     4.626
    28.000     4.857
    29.000     5.124
    30.000     5.393
    31.000     5.664
    32.000     5.937
    33.000     6.261
    34.000     6.532
    35.000     6.800
    36.000     6.992
    37.000     7.229
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000     6.772
     2.000     5.887
     3.000     5.005
     4.000     4.123
     5.000     3.606
     6.000     2.813
     7.000     2.227
     8.000     1.881
     9.000     1.984
    10.000     2.079
    11.000     1.822
    12.000     1.591
    13.000     1.664
    14.000     1.927
    15.000     2.487
    16.000     3.195
    17.000     3.854
    18.000     4.178
    19.000     4.548
    20.000     4.825
    21.000     5.180
    22.000     5.753
    23.000     6.335
    24.000     6.903
    25.000     7.469
    26.000     8.035
    27.000     8.605
    28.000     9.099
    29.000     9.663
    30.000    10.228
    31.000    10.794
    32.000    11.361
    33.000    12.031
    34.000    12.592
    35.000    13.147
    36.000    13.540
    37.000    14.011
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    12.000     5.331 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    12.000     3.231
    12.000     5.231
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    12.000     5.231
    17.000     5.231
    17.000     3.231
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    12.000     5.231
     5.000     5.231
     5.000     3.231
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    12.000     0.000
    12.000     3.231
EOF
gmt plot $proj $reg -Wthick,red << EOF
     5.000     3.231
    17.000     3.231
EOF
gmt plot $proj $reg -Wthick,red << EOF
     5.000     0.000
     5.000     3.231
EOF
gmt plot $proj $reg -Wthick,red << EOF
    17.000     0.000
    17.000     3.231
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    12.220 Event 19740621.2056.46
     2.000    11.440 Depth of minimum misfit =  12 km on  4 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    10.400 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000     9.880 z statistic for depth uncertainty range in red
EOF
gmt end
