#!/bin/bash
gmt begin chara1.31_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-45/45/-45/45
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation chara1.31'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.285     9.285
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.377    13.103
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.377    13.103 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.037    13.915
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.037    13.915 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.705    19.490
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.705    19.490 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.177    41.545
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.177    41.545 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.090     5.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.234     2.226
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.104    10.465
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.104    10.465 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.589     4.615
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.469     1.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.886     2.435
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.654     9.353
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.654     9.353 11
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.362     1.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.354     7.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.801     2.991
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.084     4.834
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.636     5.034
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.235     4.493
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.100     5.661
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.476     4.827
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.922     3.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.078     3.759
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.339     1.594
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.370     3.522
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.077     4.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.194     3.547
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.616     5.875
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.912     7.137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.915     3.413
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.630     7.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.755     7.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.409     7.248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.840     4.321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.879     4.521
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.996     6.154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.783     5.569
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     3.870
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.783     3.549
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.783     3.549 37
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.451     5.907
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.004     3.221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.657    12.545
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.657    12.545 40
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.546     4.027
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.284     4.120
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.152     0.342
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.088     5.053
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.516    10.516
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.516    10.516 45
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.059    -8.347
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -15.059    -8.347 46
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.119     7.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.871     4.631
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.131     5.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.195     5.620
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.445     5.244
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.148     3.735
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.838     3.942
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.636    -0.661
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.087     8.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.369     5.110
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.048     3.397
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.421     6.715
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.869     2.842
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.966    15.908
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.966    15.908 60
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.960     6.835
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.918     3.173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.623     1.740
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.729     2.925
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.264     2.977
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.200     7.577
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.182     6.960
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.261     1.649
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.647     3.269
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.217    -6.202
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.856     5.403
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.162     4.637
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.122     3.259
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.613     4.683
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.877     8.314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.498     4.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.816     2.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.744     2.903
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.726    -5.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.350     3.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.322     6.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.954     3.987
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.954     3.987 82
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.823    -3.211
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.823    -3.211 83
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.138     3.503
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.562     3.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.752    -4.548
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.752    -4.548 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.342     3.845
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.119     3.413
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.530     4.709
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.958     1.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.789     4.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.808     6.950
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.197     4.801
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.557     3.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.465    22.501
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.465    22.501 95
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.028     1.442
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     1.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.621     4.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.492     3.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.441     5.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.383     2.383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.693     4.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.491     2.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.574    -5.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.913     2.731
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.139     3.560
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.327     1.967
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.538     1.131
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.029     1.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.067    -3.721
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.981     2.850
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.407    -2.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.104     2.969
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.753     4.966
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.018     1.033
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.839     2.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.491     3.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.070     3.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.808    -2.619
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.756     2.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.335     2.999
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.965     2.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -42.258   -13.730
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -42.258   -13.730 123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.319    -3.587
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.680     2.300
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.501     2.823
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.707    -5.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.401    11.582
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.401    11.582 128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.921     4.755
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.752     0.780
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.798     0.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.445     0.837
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.655     4.835
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.793     4.080
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.026     9.759
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.026     9.759 135
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.603    -6.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.012   -13.761
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.012   -13.761 137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.763     7.932
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.763     7.932 138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.941     2.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.365     1.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.284     4.056
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.835     5.329
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.157     4.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.239     6.502
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.787     4.356
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.210     3.999
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.570     5.426
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.861     6.489
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.278     1.636
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.793     4.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.672     1.583
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.721     2.892
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.362     6.153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.210     4.530
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.255    -0.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.171     3.261
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.286     1.473
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.051    -4.832
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.104     1.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.573     5.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.639     0.372
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.639     0.372 161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.385    19.115
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.385    19.115 162
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.827    -2.609
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.954    -8.244
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.954    -8.244 164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.921     3.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.657     3.378
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.399    11.069
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.399    11.069 167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.976    12.889
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.976    12.889 168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.188     1.791
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.840     4.323
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.315     1.281
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.315     1.281 171
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.590     5.310
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.847     2.124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.095     8.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.900    -1.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.378     4.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.458     5.086
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.064     7.572
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.211     4.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.315     0.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.277     1.634
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.936     3.266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.923     3.616
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.363    10.405
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.363    10.405 184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.515     3.663
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.503     4.099
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.688     5.601
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.104     4.121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.654     2.149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.403     2.089
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.179     2.557
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.963     3.691
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.308     9.258
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.308     9.258 193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.694     3.266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.441     6.300
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.796    17.653
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.796    17.653 196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.451     4.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.657    13.640
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.657    13.640 198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.697    -3.020
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.770     2.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.555     1.935
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.232     2.646
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.513     1.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.519     3.280
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.186     2.657
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.378     2.384
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.699     3.967
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.111    12.653
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.111    12.653 208
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.272     2.218
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.450     2.841
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.514     8.175
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.514     8.175 211
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.713     2.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.539     1.881
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.651     4.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.136     3.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.728    -4.711
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.063    19.626
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.063    19.626 217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.515     4.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.666     3.425
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.726     3.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.440    12.996
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.440    12.996 221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.560     7.877
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.048     3.911
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.613    -2.885
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.671    12.008
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.671    12.008 225
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.914    17.774
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.914    17.774 226
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.399    -0.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.771    17.983
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.771    17.983 228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.690     2.769
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.600     2.597
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.277    -7.447
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.469     2.544
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.946   -10.011
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.946   -10.011 233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.370     3.414
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.415    -9.712
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.415    -9.712 235
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.227    30.705
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.227    30.705 236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.002     3.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.926     1.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.878     4.129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.324     4.631
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.518     4.542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.030    15.040
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.030    15.040 242
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.195     3.729
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.878     3.746
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.878     3.746 244
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.461     3.751
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.423     3.731
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.579     9.200
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.579     9.200 247
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.434    -3.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.936     2.880
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.739     3.609
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.096     2.737
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.791     4.996
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.488    -6.041
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.415     4.739
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.407     4.646
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.274     5.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.484    13.577
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.484    13.577 257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.142    -3.354
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.358     0.235
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.308    19.962
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.308    19.962 260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.241     3.442
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.254     5.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.638     8.055
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.638     8.055 263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.416     3.390
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.683    -6.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.336    15.538
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.336    15.538 266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.992     5.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.683    -6.027
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.671     3.807
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.482    26.106
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.482    26.106 270
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.656     3.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.596     4.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.697   -12.236
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.697   -12.236 273
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.140     2.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.035     3.384
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.067     3.722
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.768    20.654
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.768    20.654 277
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.350    16.234
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.350    16.234 278
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     3.381
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.051    10.481
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.051    10.481 280
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.084    -6.841
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.379     2.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.346     3.958
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.146     4.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.110     3.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.926     2.689
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.597    -1.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.257     2.938
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.764     1.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.080    -3.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.058     3.335
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.594     3.748
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.674     3.824
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.165     4.713
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.937     2.318
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.328     2.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.703     3.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.383     3.122
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.016     3.127
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     3.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.209     2.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.459     2.359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.112     1.062
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.669     5.137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.564     5.362
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.929     3.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.119    -9.057
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.119    -9.057 307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.012    -5.739
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.813     2.362
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     4.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.920    -5.986
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.839     4.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.362     2.575
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.716   -10.238
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.716   -10.238 314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.181     3.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.873     1.961
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.071     4.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.022     4.428
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.086   -10.091
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.086   -10.091 319
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.039     2.216
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.866     2.256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     4.294
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.344     3.277
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.485    -5.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.854     2.011
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.926     2.850
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.454    -6.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.289     4.134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.733    -1.515
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.973     4.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.017    16.438
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.017    16.438 331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.194     4.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.130     3.712
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.959    -9.917
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.959    -9.917 334
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.166    -6.848
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.056     3.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.550     7.973
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.316    19.100
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.316    19.100 338
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.931    24.552
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.931    24.552 339
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.620     2.687
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.760     5.406
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.478     4.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.700    -9.416
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.700    -9.416 343
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.985    21.166
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.985    21.166 344
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.573   -10.939
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.573   -10.939 345
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     5.673
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.779     1.657
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.185     5.296
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.983    11.134
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.983    11.134 349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.072    -8.920
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.072    -8.920 350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.413     5.905
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.115     3.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.771    -2.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.067    -5.090
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.326    -0.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.294     2.795
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.549     9.691
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.549     9.691 357
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.086     0.598
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.633     8.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.121     2.350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.843     2.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.194     5.554
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.275     3.502
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.449     5.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.970    10.357
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.970    10.357 365
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.273     0.394
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.273     0.394 366
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.664     8.860
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.664     8.860 367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.249     7.249
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.249     7.249 368
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.054     3.062
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.239     5.829
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.097    14.920
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.097    14.920 371
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.612     3.621
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.537   -11.819
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.537   -11.819 373
EOF
gmt plot $proj $reg -SE -Gred << EOF
     0.465     3.855     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -43.000    43.000 Author: all ( 373 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -43.000   -43.000 Average =   3.9 km at   6.9 deg; median =    4.6 km
EOF
gmt end
