#!/bin/bash
gmt begin chara1.31_dcal pdf,ps
proj=-JM16.0c+
reg=-R113.0/123.7/53.9/59.5
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration chara1.31'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
   117.380    55.870
   117.747    56.325
>
   118.269    56.900
   117.928    56.434
>
   118.269    56.900
   117.928    56.434
>
   118.269    56.900
   117.898    56.384
>
   117.380    55.870
   117.324    56.350
>
   118.269    56.900
   117.324    56.350
>
   115.702    56.504
   117.324    56.350
>
   115.702    56.504
   117.324    56.350
>
   117.380    55.870
   118.190    56.417
>
   117.380    55.870
   118.190    56.417
>
   118.269    56.900
   118.175    56.368
>
   117.380    55.870
   118.175    56.368
>
   117.380    55.870
   118.175    56.368
>
   117.380    55.870
   116.574    56.159
>
   115.702    56.504
   116.574    56.159
>
   115.702    56.504
   116.574    56.159
>
   117.380    55.870
   117.514    56.248
>
   118.269    56.900
   117.514    56.248
>
   118.269    56.900
   117.514    56.248
>
   118.269    56.900
   118.844    57.426
>
   118.269    56.900
   117.364    57.166
>
   118.269    56.900
   117.364    57.166
>
   118.269    56.900
   117.991    56.648
>
   118.269    56.900
   117.991    56.648
>
   118.269    56.900
   117.937    56.633
>
   118.269    56.900
   117.937    56.633
>
   118.269    56.900
   117.951    56.637
>
   118.269    56.900
   117.953    56.635
>
   118.269    56.900
   117.953    56.635
>
   118.269    56.900
   118.006    56.660
>
   118.269    56.900
   118.006    56.660
>
   118.269    56.900
   117.951    56.629
>
   118.269    56.900
   117.976    56.667
>
   118.269    56.900
   117.976    56.667
>
   118.269    56.900
   117.959    56.641
>
   118.269    56.900
   117.959    56.641
>
   118.269    56.900
   117.943    56.636
>
   118.269    56.900
   117.943    56.636
>
   118.269    56.900
   117.984    56.636
>
   118.269    56.900
   117.974    56.638
>
   118.269    56.900
   117.974    56.638
>
   115.703    56.491
   116.591    56.130
>
   115.703    56.491
   116.591    56.130
>
   115.702    56.504
   116.591    56.130
>
   118.269    56.900
   117.999    56.663
>
   118.269    56.900
   117.997    56.657
>
   118.269    56.900
   117.997    56.657
>
   118.269    56.900
   117.921    56.666
>
   118.269    56.900
   117.921    56.666
>
   117.380    55.870
   117.921    56.666
>
   117.380    55.870
   117.921    56.666
>
   118.269    56.900
   117.906    56.659
>
   118.269    56.900
   117.906    56.659
>
   118.269    56.900
   117.988    56.621
>
   117.380    55.870
   117.988    56.621
>
   117.380    55.870
   117.988    56.621
>
   118.269    56.900
   118.066    56.626
>
   118.269    56.900
   118.066    56.626
>
   118.269    56.900
   118.147    56.705
>
   117.380    55.870
   118.147    56.705
>
   118.269    56.900
   117.957    56.661
>
   118.269    56.900
   117.957    56.661
>
   117.380    55.870
   117.957    56.661
>
   117.380    55.870
   117.957    56.661
>
   118.269    56.900
   118.084    56.299
>
   118.269    56.900
   118.084    56.299
>
   118.269    56.900
   118.084    56.299
>
   117.380    55.870
   118.084    56.299
>
   117.380    55.870
   118.084    56.299
>
   118.269    56.900
   118.086    56.655
>
   118.269    56.900
   118.086    56.655
>
   117.380    55.870
   118.086    56.655
>
   117.380    55.870
   118.086    56.655
>
   115.703    56.491
   116.468    56.140
>
   115.703    56.491
   116.468    56.140
>
   115.702    56.504
   116.468    56.140
>
   115.702    56.504
   116.468    56.140
>
   117.380    55.870
   116.468    56.140
>
   117.380    55.870
   116.468    56.140
>
   118.269    56.900
   117.391    56.385
>
   118.269    56.900
   117.391    56.385
>
   118.269    56.900
   118.577    57.177
>
   118.269    56.900
   118.132    56.397
>
   118.269    56.900
   118.132    56.397
>
   117.380    55.870
   117.221    56.411
>
   117.380    55.870
   117.221    56.411
>
   118.269    56.900
   117.221    56.411
>
   118.269    56.900
   117.221    56.411
>
   115.703    56.491
   117.221    56.411
>
   118.269    56.900
   117.616    56.344
>
   118.269    56.900
   117.616    56.344
>
   118.269    56.900
   117.324    56.344
>
   118.269    56.900
   117.324    56.344
>
   115.703    56.491
   117.324    56.344
>
   115.703    56.491
   117.324    56.344
>
   115.702    56.504
   117.324    56.344
>
   115.702    56.504
   117.324    56.344
>
   118.269    56.900
   117.223    56.333
>
   115.703    56.491
   117.223    56.333
>
   115.703    56.491
   117.223    56.333
>
   115.702    56.504
   117.223    56.333
>
   115.702    56.504
   117.223    56.333
>
   118.269    56.900
   117.168    56.257
>
   118.269    56.900
   117.168    56.257
>
   118.269    56.900
   117.141    56.215
>
   118.269    56.900
   117.480    56.404
>
   115.703    56.491
   117.480    56.404
>
   115.703    56.491
   117.480    56.404
>
   118.269    56.900
   118.235    56.339
>
   118.269    56.900
   118.235    56.339
>
   118.269    56.900
   118.721    56.607
>
   118.269    56.900
   118.721    56.607
>
   118.269    56.900
   118.030    56.338
>
   118.269    56.900
   118.030    56.338
>
   118.269    56.900
   118.737    56.617
>
   118.269    56.900
   118.737    56.617
>
   118.269    56.900
   117.981    56.340
>
   118.269    56.900
   117.981    56.340
>
   118.269    56.900
   117.479    56.563
>
   118.269    56.900
   117.479    56.563
>
   118.269    56.900
   118.649    57.147
>
   118.269    56.900
   118.649    57.147
>
   118.269    56.900
   118.396    56.415
>
   118.269    56.900
   118.396    56.415
>
   118.269    56.900
   118.396    56.415
>
   118.269    56.900
   119.695    56.795
>
   118.269    56.900
   119.695    56.795
>
   118.269    56.900
   119.695    56.795
>
   115.703    56.491
   116.882    56.424
>
   115.703    56.491
   116.882    56.424
>
   118.269    56.900
   116.882    56.424
>
   118.269    56.900
   116.882    56.424
>
   121.592    56.562
   120.336    56.580
>
   115.703    56.491
   116.525    56.170
>
   115.703    56.491
   116.525    56.170
>
   115.702    56.504
   116.525    56.170
>
   115.703    56.491
   116.884    56.425
>
   115.703    56.491
   116.884    56.425
>
   118.269    56.900
   116.884    56.425
>
   118.269    56.900
   116.884    56.425
>
   118.269    56.900
   116.884    56.425
>
   118.269    56.900
   118.746    56.847
>
   118.269    56.900
   118.746    56.847
>
   118.269    56.900
   118.746    56.847
>
   115.703    56.491
   116.922    56.229
>
   115.703    56.491
   116.922    56.229
>
   118.269    56.900
   118.753    56.261
>
   118.269    56.900
   118.753    56.261
>
   118.269    56.900
   117.668    56.264
>
   118.269    56.900
   117.668    56.264
>
   118.269    56.900
   118.650    56.633
>
   118.269    56.900
   118.650    56.633
>
   118.269    56.900
   118.660    56.612
>
   118.269    56.900
   118.660    56.612
>
   118.269    56.900
   118.660    56.612
>
   118.269    56.900
   119.970    56.948
>
   118.269    56.900
   119.970    56.948
>
   118.269    56.900
   119.970    56.948
>
   118.269    56.900
   117.274    56.515
>
   118.269    56.900
   117.274    56.515
>
   115.703    56.491
   117.274    56.515
>
   115.703    56.491
   117.274    56.515
>
   115.703    56.491
   117.274    56.515
>
   118.269    56.900
   118.117    56.690
>
   118.269    56.900
   118.117    56.690
>
   118.269    56.900
   118.117    56.690
>
   118.269    56.900
   118.117    56.690
>
   118.269    56.900
   117.954    56.634
>
   118.269    56.900
   117.954    56.634
>
   118.269    56.900
   117.954    56.634
>
   118.269    56.900
   117.954    56.652
>
   118.269    56.900
   117.954    56.652
>
   118.269    56.900
   117.965    56.648
>
   118.269    56.900
   117.965    56.648
>
   118.269    56.900
   117.965    56.648
>
   118.269    56.900
   117.965    56.648
>
   118.269    56.900
   117.792    56.461
>
   118.269    56.900
   117.792    56.461
>
   118.269    56.900
   117.792    56.461
>
   118.269    56.900
   117.964    56.628
>
   118.269    56.900
   117.964    56.628
>
   118.269    56.900
   117.923    56.616
>
   118.269    56.900
   117.923    56.616
>
   118.269    56.900
   117.912    56.614
>
   118.269    56.900
   117.912    56.614
>
   118.269    56.900
   117.893    56.564
>
   118.269    56.900
   117.893    56.564
>
   118.269    56.900
   117.901    56.604
>
   118.269    56.900
   117.901    56.604
>
   118.269    56.900
   117.988    56.675
>
   118.269    56.900
   117.988    56.675
>
   118.269    56.900
   117.958    56.642
>
   118.269    56.900
   117.958    56.642
>
   118.269    56.900
   117.958    56.642
>
   118.269    56.900
   117.958    56.642
>
   118.269    56.900
   117.942    56.624
>
   118.269    56.900
   117.942    56.624
>
   118.269    56.900
   117.951    56.645
>
   118.269    56.900
   117.951    56.645
>
   118.269    56.900
   117.951    56.645
>
   118.269    56.900
   117.925    56.628
>
   118.269    56.900
   117.925    56.628
>
   118.269    56.900
   117.941    56.629
>
   118.269    56.900
   117.941    56.629
>
   118.269    56.900
   118.089    56.308
>
   118.269    56.900
   118.089    56.308
>
   118.269    56.900
   117.926    56.628
>
   118.269    56.900
   117.926    56.628
>
   118.269    56.900
   117.926    56.628
>
   118.269    56.900
   117.935    56.646
>
   118.269    56.900
   117.935    56.646
>
   118.269    56.900
   117.918    56.629
>
   118.269    56.900
   117.918    56.629
>
   118.269    56.900
   118.155    56.138
>
   118.269    56.900
   118.155    56.138
>
   118.269    56.900
   118.155    56.138
>
   118.269    56.900
   117.935    56.160
>
   118.269    56.900
   117.935    56.160
>
   118.269    56.900
   118.638    56.615
>
   118.269    56.900
   118.638    56.615
>
   118.269    56.900
   118.645    56.608
>
   118.269    56.900
   118.645    56.608
>
   115.703    56.491
   116.439    56.117
>
   115.703    56.491
   116.439    56.117
>
   115.703    56.491
   116.439    56.117
>
   115.703    56.491
   116.439    56.117
>
   118.269    56.900
   118.621    56.618
>
   118.269    56.900
   118.621    56.618
>
   118.269    56.900
   118.621    56.618
>
   118.269    56.900
   119.560    56.998
>
   118.269    56.900
   119.560    56.998
>
   118.269    56.900
   119.560    56.998
>
   118.269    56.900
   117.984    56.096
>
   118.269    56.900
   117.984    56.096
>
   118.269    56.900
   117.990    56.098
>
   118.269    56.900
   117.990    56.098
>
   118.269    56.900
   117.990    56.098
>
   118.269    56.900
   117.504    56.362
>
   118.269    56.900
   117.504    56.362
>
   118.269    56.900
   117.504    56.362
>
   118.269    56.900
   117.508    56.369
>
   118.269    56.900
   117.508    56.369
>
   118.269    56.900
   117.493    56.355
>
   118.269    56.900
   117.493    56.355
>
   118.269    56.900
   117.493    56.355
>
   118.269    56.900
   117.493    56.355
>
   118.269    56.900
   117.500    56.356
>
   118.269    56.900
   117.500    56.356
>
   118.269    56.900
   117.500    56.356
>
   118.269    56.900
   117.543    56.742
>
   118.269    56.900
   117.543    56.742
>
   118.269    56.900
   117.506    56.368
>
   118.269    56.900
   117.506    56.368
>
   118.269    56.900
   117.506    56.368
>
   118.269    56.900
   118.672    56.610
>
   118.269    56.900
   118.672    56.610
>
   118.269    56.900
   118.672    56.610
>
   118.269    56.900
   118.323    56.954
>
   118.269    56.900
   118.323    56.954
>
   119.979    56.921
   118.323    56.954
>
   119.979    56.921
   118.323    56.954
>
   118.269    56.900
   118.325    56.968
>
   118.269    56.900
   118.325    56.968
>
   119.979    56.921
   118.325    56.968
>
   118.269    56.900
   117.498    56.372
>
   118.269    56.900
   117.498    56.372
>
   118.269    56.900
   117.498    56.372
>
   118.269    56.900
   117.498    56.372
>
   118.269    56.900
   118.097    56.291
>
   118.269    56.900
   118.097    56.291
>
   118.269    56.900
   118.097    56.291
>
   118.269    56.900
   118.097    56.291
>
   118.269    56.900
   118.061    56.324
>
   118.269    56.900
   118.086    56.303
>
   118.269    56.900
   118.086    56.303
>
   118.269    56.900
   118.086    56.303
>
   118.269    56.900
   118.094    56.305
>
   118.269    56.900
   118.094    56.305
>
   118.269    56.900
   118.094    56.305
>
   118.269    56.900
   118.102    56.301
>
   118.269    56.900
   118.102    56.301
>
   118.269    56.900
   118.102    56.301
>
   118.269    56.900
   117.518    56.403
>
   118.269    56.900
   117.518    56.403
>
   118.269    56.900
   118.055    56.636
>
   118.269    56.900
   118.055    56.636
>
   115.703    56.491
   117.160    56.331
>
   115.703    56.491
   117.160    56.331
>
   118.269    56.900
   117.160    56.331
>
   118.269    56.900
   117.160    56.331
>
   118.269    56.900
   117.160    56.331
>
   118.269    56.900
   117.160    56.331
>
   118.269    56.900
   118.070    56.317
>
   118.269    56.900
   118.070    56.317
>
   118.269    56.900
   117.930    56.564
>
   118.269    56.900
   117.930    56.564
>
   118.269    56.900
   117.930    56.564
>
   118.269    56.900
   117.930    56.549
>
   118.269    56.900
   117.930    56.549
>
   118.269    56.900
   117.930    56.549
>
   118.269    56.900
   117.922    56.553
>
   118.269    56.900
   117.922    56.553
>
   118.269    56.900
   117.922    56.553
>
   118.269    56.900
   117.918    56.565
>
   118.269    56.900
   117.918    56.565
>
   118.269    56.900
   118.378    56.353
>
   118.269    56.900
   118.378    56.353
>
   118.269    56.900
   118.378    56.353
>
   118.269    56.900
   118.374    56.346
>
   118.269    56.900
   118.374    56.346
>
   119.979    56.921
   120.371    57.228
>
   119.979    56.921
   120.371    57.228
>
   119.979    56.921
   120.348    57.322
>
   119.979    56.921
   120.348    57.322
>
   118.269    56.900
   118.040    56.639
>
   118.269    56.900
   118.040    56.639
>
   118.269    56.900
   118.040    56.639
>
   118.269    56.900
   118.040    56.639
>
   115.703    56.491
   116.736    56.145
>
   115.703    56.491
   116.736    56.145
>
   115.703    56.491
   116.736    56.145
>
   115.703    56.491
   116.736    56.145
>
   118.269    56.900
   118.722    57.046
>
   118.269    56.900
   118.722    57.046
>
   118.269    56.900
   118.722    57.046
>
   118.269    56.900
   118.722    57.046
>
   118.269    56.900
   118.567    56.580
>
   118.269    56.900
   118.567    56.580
>
   118.269    56.900
   118.567    56.580
>
   118.269    56.900
   118.567    56.580
>
   118.269    56.900
   118.475    56.271
>
   118.269    56.900
   118.475    56.271
>
   118.269    56.900
   118.475    56.271
>
   118.269    56.900
   118.577    56.573
>
   118.269    56.900
   118.577    56.573
>
   119.979    56.921
   118.577    56.573
>
   119.979    56.921
   118.577    56.573
>
   118.269    56.900
   119.240    57.236
>
   118.269    56.900
   119.240    57.236
>
   118.269    56.900
   119.240    57.236
>
   115.703    56.491
   116.433    56.193
>
   115.703    56.491
   116.433    56.193
>
   115.703    56.491
   116.433    56.193
>
   115.703    56.491
   116.433    56.193
>
   118.269    56.900
   118.443    56.442
>
   118.269    56.900
   118.443    56.442
>
   118.269    56.900
   118.443    56.442
>
   118.269    56.900
   118.443    56.442
>
   119.979    56.921
   118.443    56.442
>
   119.979    56.921
   118.443    56.442
>
   118.269    56.900
   118.698    56.656
>
   118.269    56.900
   118.698    56.656
>
   118.269    56.900
   118.698    56.656
>
   118.269    56.900
   118.698    56.656
>
   118.269    56.900
   118.628    56.644
>
   118.269    56.900
   118.628    56.644
>
   119.979    56.921
   118.628    56.644
>
   119.979    56.921
   118.628    56.644
>
   118.269    56.900
   118.627    56.639
>
   118.269    56.900
   118.627    56.639
>
   119.979    56.921
   118.627    56.639
>
   118.269    56.900
   118.378    56.433
>
   118.269    56.900
   118.378    56.433
>
   118.269    56.900
   118.382    56.442
>
   118.269    56.900
   118.382    56.442
>
   118.269    56.900
   118.184    56.364
>
   118.269    56.900
   118.184    56.364
>
   118.269    56.900
   118.500    56.522
>
   118.269    56.900
   118.500    56.522
>
   119.979    56.921
   118.500    56.522
>
   119.979    56.921
   118.500    56.522
>
   118.269    56.900
   118.297    56.310
>
   118.269    56.900
   118.297    56.310
>
   118.269    56.900
   117.703    56.282
>
   118.269    56.900
   117.703    56.282
>
   118.269    56.900
   117.703    56.282
>
   118.269    56.900
   117.669    56.261
>
   118.269    56.900
   117.669    56.261
>
   118.269    56.900
   117.956    56.644
>
   118.269    56.900
   117.956    56.644
>
   118.269    56.900
   118.491    56.551
>
   118.269    56.900
   118.491    56.551
>
   118.269    56.900
   118.491    56.551
>
   118.269    56.900
   117.961    56.632
>
   118.269    56.900
   117.961    56.632
>
   118.269    56.900
   117.949    56.645
>
   118.269    56.900
   117.949    56.645
>
   118.269    56.900
   117.950    56.638
>
   118.269    56.900
   117.950    56.638
>
   118.269    56.900
   117.950    56.638
>
   118.269    56.900
   117.950    56.638
>
   118.269    56.900
   118.509    56.576
>
   118.269    56.900
   118.509    56.576
>
   119.979    56.921
   118.509    56.576
>
   119.979    56.921
   118.509    56.576
>
   118.269    56.900
   118.498    56.544
>
   118.269    56.900
   118.498    56.544
>
   119.979    56.921
   118.498    56.544
>
   119.979    56.921
   118.498    56.544
>
   118.269    56.900
   117.521    56.575
>
   118.269    56.900
   117.521    56.575
>
   118.269    56.900
   117.521    56.575
>
   118.269    56.900
   118.284    56.429
>
   118.269    56.900
   118.284    56.429
>
   118.269    56.900
   118.284    56.429
>
   118.269    56.900
   118.284    56.429
>
   119.979    56.921
   119.742    56.481
>
   118.269    56.900
   119.742    56.481
>
   118.269    56.900
   119.742    56.481
>
   118.269    56.900
   119.742    56.481
>
   118.269    56.900
   119.678    56.966
>
   118.269    56.900
   119.678    56.966
>
   118.269    56.900
   119.678    56.966
>
   118.269    56.900
   118.132    56.365
>
   118.269    56.900
   118.132    56.365
>
   118.269    56.900
   117.784    56.329
>
   118.269    56.900
   117.784    56.329
>
   118.269    56.900
   117.928    56.632
>
   118.269    56.900
   117.928    56.632
>
   118.269    56.900
   118.151    56.271
>
   118.269    56.900
   118.151    56.271
>
   118.269    56.900
   118.174    56.713
>
   118.269    56.900
   118.174    56.713
>
   118.269    56.900
   117.536    56.288
>
   118.269    56.900
   117.536    56.288
>
   118.269    56.900
   117.536    56.288
>
   118.269    56.900
   117.536    56.288
>
   118.269    56.900
   118.214    56.066
>
   118.269    56.900
   118.214    56.066
>
   118.269    56.900
   118.214    56.066
>
   118.269    56.900
   118.218    56.399
>
   118.269    56.900
   118.218    56.399
>
   118.269    56.900
   118.218    56.399
>
   118.269    56.900
   117.705    56.284
>
   118.269    56.900
   117.705    56.284
>
   118.269    56.900
   117.759    56.430
>
   118.269    56.900
   117.759    56.430
>
   118.269    56.900
   118.778    56.923
>
   118.269    56.900
   118.778    56.923
>
   118.269    56.900
   118.778    56.923
>
   119.979    56.921
   118.778    56.923
>
   119.979    56.921
   118.778    56.923
>
   119.979    56.921
   119.390    56.965
>
   119.979    56.921
   119.390    56.965
>
   118.269    56.900
   119.390    56.965
>
   118.269    56.900
   119.390    56.965
>
   118.269    56.900
   117.187    56.411
>
   118.269    56.900
   117.187    56.411
>
   115.703    56.491
   117.187    56.411
>
   115.703    56.491
   117.187    56.411
>
   118.269    56.900
   118.131    56.772
>
   118.269    56.900
   118.131    56.772
>
   118.269    56.900
   118.108    56.772
>
   118.269    56.900
   118.108    56.772
>
   118.269    56.900
   118.450    56.171
>
   118.269    56.900
   118.450    56.171
>
   119.979    56.921
   119.512    57.020
>
   119.979    56.921
   119.512    57.020
>
   118.269    56.900
   119.512    57.020
>
   118.269    56.900
   119.512    57.020
>
   118.269    56.900
   117.829    56.226
>
   118.269    56.900
   117.829    56.226
>
   118.269    56.900
   118.224    56.361
>
   118.269    56.900
   118.224    56.361
>
   118.269    56.900
   118.706    56.704
>
   118.269    56.900
   118.706    56.704
>
   119.979    56.921
   118.706    56.704
>
   119.979    56.921
   118.706    56.704
>
   118.269    56.900
   118.713    56.682
>
   118.269    56.900
   118.713    56.682
>
   118.269    56.900
   118.490    56.606
>
   118.269    56.900
   118.490    56.606
>
   118.269    56.900
   117.354    56.310
>
   118.269    56.900
   117.354    56.310
>
   115.703    56.491
   117.354    56.310
>
   115.703    56.491
   117.354    56.310
>
   118.269    56.900
   117.599    56.425
>
   118.269    56.900
   117.599    56.425
>
   118.269    56.900
   118.465    56.611
>
   118.269    56.900
   118.465    56.611
>
   119.979    56.921
   118.465    56.611
>
   119.979    56.921
   118.465    56.611
>
   118.269    56.900
   118.509    56.598
>
   118.269    56.900
   118.509    56.598
>
   119.979    56.921
   118.509    56.598
>
   119.979    56.921
   118.509    56.598
>
   119.789    56.921
   120.032    56.952
>
   119.789    56.921
   120.032    56.952
>
   121.654    56.592
   120.032    56.952
>
   121.654    56.592
   120.032    56.952
>
   118.269    56.900
   117.338    56.307
>
   118.269    56.900
   117.338    56.307
>
   115.703    56.491
   117.338    56.307
>
   115.703    56.491
   117.338    56.307
>
   118.269    56.900
   118.199    56.303
>
   118.269    56.900
   118.199    56.303
>
   118.269    56.900
   118.199    56.320
>
   118.269    56.900
   118.199    56.320
>
   118.269    56.900
   117.502    56.573
>
   118.269    56.900
   117.502    56.573
>
   115.703    56.491
   117.502    56.573
>
   115.703    56.491
   117.502    56.573
>
   118.269    56.900
   117.327    56.351
>
   115.703    56.491
   117.327    56.351
>
   115.703    56.491
   117.327    56.351
>
   118.269    56.900
   118.834    57.017
>
   118.269    56.900
   118.834    57.017
>
   118.269    56.900
   118.834    57.017
>
   119.979    56.921
   118.834    57.017
>
   119.979    56.921
   118.834    57.017
>
   119.979    56.921
   118.834    57.017
>
   118.269    56.900
   118.168    57.014
>
   118.269    56.900
   118.168    57.014
>
   118.269    56.900
   118.168    57.014
>
   119.979    56.921
   119.793    56.907
>
   119.979    56.921
   119.793    56.907
>
   118.269    56.900
   119.793    56.907
>
   118.269    56.900
   119.793    56.907
>
   118.269    56.900
   118.049    56.311
>
   118.269    56.900
   118.049    56.311
>
   118.269    56.900
   118.038    56.294
>
   118.269    56.900
   118.038    56.294
>
   119.979    56.921
   119.765    56.792
>
   119.979    56.921
   119.765    56.792
>
   118.269    56.900
   119.765    56.792
>
   118.269    56.900
   119.765    56.792
>
   118.269    56.900
   117.997    56.121
>
   118.269    56.900
   117.997    56.121
>
   118.269    56.900
   118.001    56.104
>
   118.269    56.900
   118.001    56.104
>
   118.269    56.900
   118.002    56.098
>
   118.269    56.900
   118.002    56.098
>
   118.269    56.900
   117.992    56.120
>
   118.269    56.900
   117.992    56.120
>
   118.269    56.900
   117.989    56.113
>
   118.269    56.900
   117.989    56.113
>
   118.269    56.900
   118.024    56.126
>
   118.269    56.900
   118.024    56.126
>
   118.269    56.900
   118.008    56.116
>
   118.269    56.900
   118.008    56.116
>
   118.269    56.900
   118.028    56.121
>
   118.269    56.900
   118.028    56.121
>
   118.269    56.900
   118.023    56.116
>
   118.269    56.900
   118.023    56.116
>
   118.269    56.900
   118.014    56.109
>
   118.269    56.900
   118.014    56.109
>
   118.269    56.900
   117.991    56.114
>
   118.269    56.900
   117.991    56.114
>
   118.269    56.900
   118.001    56.108
>
   118.269    56.900
   118.001    56.108
>
   118.269    56.900
   118.001    56.108
>
   118.269    56.900
   118.014    56.110
>
   118.269    56.900
   118.014    56.110
>
   118.269    56.900
   118.013    56.104
>
   118.269    56.900
   118.013    56.104
>
   118.269    56.900
   118.012    56.095
>
   118.269    56.900
   118.012    56.095
>
   118.269    56.900
   118.012    56.095
>
   118.269    56.900
   117.979    56.133
>
   118.269    56.900
   117.979    56.133
>
   118.269    56.900
   118.006    56.103
>
   118.269    56.900
   118.006    56.103
>
   118.269    56.900
   118.012    56.105
>
   118.269    56.900
   118.012    56.105
>
   118.269    56.900
   117.862    56.238
>
   118.269    56.900
   117.862    56.238
>
   118.269    56.900
   117.862    56.238
>
   119.789    56.921
   120.239    56.920
>
   119.789    56.921
   120.239    56.920
>
   121.654    56.592
   120.239    56.920
>
   118.269    56.900
   117.941    56.642
>
   118.269    56.900
   117.941    56.642
>
   118.269    56.900
   117.259    56.269
>
   118.269    56.900
   117.259    56.269
>
   115.703    56.491
   117.259    56.269
>
   115.703    56.491
   117.259    56.269
>
   118.269    56.900
   118.272    56.807
>
   118.269    56.900
   118.272    56.807
>
   119.979    56.921
   118.272    56.807
>
   119.979    56.921
   118.272    56.807
>
   119.979    56.921
   119.430    57.383
>
   119.979    56.921
   119.430    57.383
>
   119.789    56.921
   120.257    57.469
>
   119.789    56.921
   120.257    57.469
>
   118.269    56.900
   117.343    56.305
>
   118.269    56.900
   117.343    56.305
>
   115.703    56.491
   117.343    56.305
>
   115.703    56.491
   117.343    56.305
>
   118.269    56.900
   118.604    56.582
>
   118.269    56.900
   118.604    56.582
>
   118.269    56.900
   118.604    56.582
>
   119.979    56.921
   118.604    56.582
>
   119.979    56.921
   118.604    56.582
>
   119.789    56.921
   119.925    57.403
>
   119.789    56.921
   119.925    57.403
>
   118.269    56.900
   118.011    56.638
>
   118.269    56.900
   118.011    56.638
>
   118.269    56.900
   118.011    56.638
>
   118.269    56.900
   118.011    56.638
>
   118.269    56.900
   118.931    56.938
>
   118.269    56.900
   118.931    56.938
>
   115.703    56.491
   116.471    56.195
>
   115.703    56.491
   116.471    56.195
>
   115.703    56.491
   117.239    56.147
>
   115.703    56.491
   117.239    56.147
>
   118.269    56.900
   117.239    56.147
>
   118.269    56.900
   117.239    56.147
>
   118.269    56.900
   118.308    56.670
>
   118.269    56.900
   118.308    56.670
>
   118.269    56.900
   118.308    56.670
>
   118.269    56.900
   118.308    56.670
>
   119.979    56.921
   118.308    56.670
>
   119.979    56.921
   118.308    56.670
>
   118.269    56.900
   118.306    56.677
>
   118.269    56.900
   118.306    56.677
>
   119.979    56.921
   118.306    56.677
>
   119.979    56.921
   118.306    56.677
>
   118.269    56.900
   118.310    56.675
>
   118.269    56.900
   118.310    56.675
>
   118.269    56.900
   118.310    56.675
>
   119.979    56.921
   118.310    56.675
>
   119.979    56.921
   118.310    56.675
>
   118.269    56.900
   118.308    56.684
>
   118.269    56.900
   118.308    56.684
>
   119.979    56.921
   118.308    56.684
>
   119.979    56.921
   118.308    56.684
>
   118.269    56.900
   118.294    56.682
>
   118.269    56.900
   118.294    56.682
>
   118.269    56.900
   118.294    56.682
>
   119.979    56.921
   118.294    56.682
>
   119.979    56.921
   118.294    56.682
>
   118.269    56.900
   118.320    56.690
>
   118.269    56.900
   118.320    56.690
>
   119.979    56.921
   118.320    56.690
>
   119.979    56.921
   118.320    56.690
>
   118.269    56.900
   118.313    56.679
>
   118.269    56.900
   118.313    56.679
>
   119.979    56.921
   118.313    56.679
>
   119.979    56.921
   118.313    56.679
>
   119.979    56.921
   118.282    56.710
>
   119.979    56.921
   118.282    56.710
>
   118.269    56.900
   118.325    56.693
>
   118.269    56.900
   118.325    56.693
>
   119.979    56.921
   118.325    56.693
>
   119.979    56.921
   118.325    56.693
>
   118.269    56.900
   118.314    56.668
>
   118.269    56.900
   118.314    56.668
>
   119.979    56.921
   118.314    56.668
>
   118.269    56.900
   118.299    56.689
>
   118.269    56.900
   118.299    56.689
>
   119.979    56.921
   118.299    56.689
>
   119.979    56.921
   118.299    56.689
>
   118.269    56.900
   118.335    56.687
>
   118.269    56.900
   118.335    56.687
>
   118.269    56.900
   118.335    56.687
>
   118.269    56.900
   118.335    56.687
>
   119.979    56.921
   118.335    56.687
>
   119.979    56.921
   118.335    56.687
>
   118.269    56.900
   118.326    56.687
>
   118.269    56.900
   118.326    56.687
>
   119.979    56.921
   118.326    56.687
>
   119.979    56.921
   118.326    56.687
>
   118.269    56.900
   118.312    56.683
>
   118.269    56.900
   118.312    56.683
>
   119.979    56.921
   118.312    56.683
>
   119.979    56.921
   118.312    56.683
>
   118.269    56.900
   118.303    56.676
>
   118.269    56.900
   118.303    56.676
>
   119.979    56.921
   118.303    56.676
>
   119.979    56.921
   118.303    56.676
>
   118.269    56.900
   118.290    56.697
>
   118.269    56.900
   118.290    56.697
>
   119.979    56.921
   118.290    56.697
>
   119.979    56.921
   118.290    56.697
>
   118.269    56.900
   118.304    56.674
>
   118.269    56.900
   118.304    56.674
>
   118.269    56.900
   118.304    56.674
>
   119.979    56.921
   118.304    56.674
>
   119.979    56.921
   118.304    56.674
>
   118.269    56.900
   118.302    56.682
>
   118.269    56.900
   118.302    56.682
>
   119.979    56.921
   118.302    56.682
>
   119.979    56.921
   118.302    56.682
>
   118.269    56.900
   117.955    56.584
>
   118.269    56.900
   117.955    56.584
>
   118.269    56.900
   117.950    56.576
>
   118.269    56.900
   117.950    56.576
>
   118.269    56.900
   117.950    56.576
>
   118.269    56.900
   118.322    56.695
>
   118.269    56.900
   118.322    56.695
>
   119.979    56.921
   118.322    56.695
>
   119.979    56.921
   118.322    56.695
>
   118.269    56.900
   118.318    56.665
>
   118.269    56.900
   118.318    56.665
>
   119.979    56.921
   118.318    56.665
>
   119.979    56.921
   118.318    56.665
>
   118.269    56.900
   117.946    56.575
>
   118.269    56.900
   117.946    56.575
>
   118.269    56.900
   118.323    56.678
>
   118.269    56.900
   118.323    56.678
>
   119.979    56.921
   118.323    56.678
>
   119.979    56.921
   118.323    56.678
>
   119.979    56.921
   118.323    56.678
>
   118.269    56.900
   118.317    56.678
>
   118.269    56.900
   118.317    56.678
>
   119.979    56.921
   118.317    56.678
>
   119.979    56.921
   118.317    56.678
>
   118.269    56.900
   118.325    56.693
>
   118.269    56.900
   118.325    56.693
>
   119.979    56.921
   118.325    56.693
>
   119.979    56.921
   118.325    56.693
>
   118.269    56.900
   118.326    56.682
>
   118.269    56.900
   118.326    56.682
>
   119.979    56.921
   118.326    56.682
>
   119.979    56.921
   118.326    56.682
>
   118.269    56.900
   118.316    56.687
>
   118.269    56.900
   118.316    56.687
>
   118.269    56.900
   118.316    56.687
>
   118.269    56.900
   117.704    56.287
>
   118.269    56.900
   117.704    56.287
>
   118.269    56.900
   117.704    56.287
>
   118.269    56.900
   117.705    56.320
>
   118.269    56.900
   117.705    56.320
>
   118.269    56.900
   117.705    56.320
>
   118.269    56.900
   117.704    56.299
>
   118.269    56.900
   117.704    56.299
>
   118.269    56.900
   117.700    56.307
>
   118.269    56.900
   117.700    56.307
>
   118.269    56.900
   118.601    56.028
>
   118.269    56.900
   118.601    56.028
>
   118.269    56.900
   117.693    56.300
>
   118.269    56.900
   117.693    56.300
>
   118.269    56.900
   117.692    56.313
>
   118.269    56.900
   117.692    56.313
>
   118.269    56.900
   117.692    56.313
>
   118.269    56.900
   117.692    56.313
>
   118.269    56.900
   117.699    56.324
>
   118.269    56.900
   117.699    56.324
>
   118.269    56.900
   118.294    56.664
>
   118.269    56.900
   118.294    56.664
>
   119.979    56.921
   118.294    56.664
>
   119.979    56.921
   118.294    56.664
>
   118.269    56.900
   117.715    56.318
>
   118.269    56.900
   117.715    56.318
>
   118.269    56.900
   117.689    56.316
>
   118.269    56.900
   117.689    56.316
>
   118.269    56.900
   117.716    56.313
>
   118.269    56.900
   117.716    56.313
>
   118.269    56.900
   117.716    56.313
>
   118.269    56.900
   117.719    56.282
>
   118.269    56.900
   117.719    56.282
>
   118.269    56.900
   117.689    56.292
>
   118.269    56.900
   117.689    56.292
>
   118.269    56.900
   117.681    56.334
>
   118.269    56.900
   117.681    56.334
>
   118.269    56.900
   117.681    56.334
>
   118.269    56.900
   117.672    56.313
>
   118.269    56.900
   117.672    56.313
>
   118.269    56.900
   117.673    56.310
>
   118.269    56.900
   117.673    56.310
>
   118.269    56.900
   117.703    56.297
>
   118.269    56.900
   117.703    56.297
>
   115.703    56.491
   116.405    56.237
>
   115.703    56.491
   116.405    56.237
>
   118.269    56.900
   117.724    56.306
>
   118.269    56.900
   117.724    56.306
>
   118.269    56.900
   117.724    56.306
>
   118.269    56.900
   117.724    56.306
>
   118.269    56.900
   117.670    56.300
>
   118.269    56.900
   117.670    56.300
>
   118.269    56.900
   117.704    56.328
>
   118.269    56.900
   117.704    56.328
>
   118.269    56.900
   117.699    56.323
>
   118.269    56.900
   117.699    56.323
>
   118.269    56.900
   117.697    56.278
>
   118.269    56.900
   117.697    56.278
>
   118.269    56.900
   117.635    56.294
>
   118.269    56.900
   117.635    56.294
>
   118.269    56.900
   117.688    56.323
>
   118.269    56.900
   117.688    56.323
>
   118.269    56.900
   117.729    56.309
>
   118.269    56.900
   117.729    56.309
>
   118.269    56.900
   117.729    56.309
>
   118.269    56.900
   117.729    56.309
>
   118.269    56.900
   117.735    56.316
>
   118.269    56.900
   117.735    56.316
>
   118.269    56.900
   117.711    56.320
>
   118.269    56.900
   117.711    56.320
>
   118.269    56.900
   117.711    56.320
>
   118.269    56.900
   117.711    56.320
>
   118.269    56.900
   117.736    56.314
>
   118.269    56.900
   117.736    56.314
>
   118.269    56.900
   117.648    56.295
>
   118.269    56.900
   117.648    56.295
>
   118.269    56.900
   117.661    56.301
>
   118.269    56.900
   117.661    56.301
>
   118.269    56.900
   117.661    56.301
>
   118.269    56.900
   117.649    56.300
>
   118.269    56.900
   117.649    56.300
>
   118.269    56.900
   117.751    56.306
>
   118.269    56.900
   117.751    56.306
>
   118.269    56.900
   117.730    56.306
>
   118.269    56.900
   117.730    56.306
>
   118.269    56.900
   117.733    56.318
>
   118.269    56.900
   117.733    56.318
>
   118.269    56.900
   117.677    56.278
>
   118.269    56.900
   117.677    56.278
>
   118.269    56.900
   117.677    56.278
>
   118.269    56.900
   117.674    56.296
>
   118.269    56.900
   117.674    56.296
>
   118.269    56.900
   117.688    56.284
>
   118.269    56.900
   117.688    56.284
>
   118.269    56.900
   117.634    56.302
>
   118.269    56.900
   117.634    56.302
>
   118.269    56.900
   117.724    56.312
>
   118.269    56.900
   117.724    56.312
>
   118.269    56.900
   117.660    56.312
>
   118.269    56.900
   117.660    56.312
>
   118.269    56.900
   117.667    56.273
>
   118.269    56.900
   117.667    56.273
>
   118.269    56.900
   117.633    56.299
>
   118.269    56.900
   117.633    56.299
>
   118.269    56.900
   117.668    56.240
>
   118.269    56.900
   117.668    56.240
>
   118.269    56.900
   117.707    56.204
>
   118.269    56.900
   117.707    56.204
>
   118.269    56.900
   117.688    56.292
>
   118.269    56.900
   117.688    56.292
>
   118.269    56.900
   117.695    56.301
>
   118.269    56.900
   117.695    56.301
>
   118.269    56.900
   117.679    56.285
>
   118.269    56.900
   117.679    56.285
>
   118.269    56.900
   117.636    56.306
>
   118.269    56.900
   117.636    56.306
>
   118.269    56.900
   117.677    56.259
>
   118.269    56.900
   117.677    56.259
>
   118.269    56.900
   117.650    56.279
>
   118.269    56.900
   117.650    56.279
>
   118.269    56.900
   117.653    56.295
>
   118.269    56.900
   117.653    56.295
>
   118.269    56.900
   117.653    56.295
>
   118.269    56.900
   117.653    56.295
>
   118.269    56.900
   117.664    56.277
>
   118.269    56.900
   117.664    56.277
>
   118.269    56.900
   117.644    56.277
>
   118.269    56.900
   117.644    56.277
>
   118.269    56.900
   117.661    56.286
>
   118.269    56.900
   117.661    56.286
>
   118.269    56.900
   117.661    56.286
>
   118.269    56.900
   117.661    56.286
>
   118.269    56.900
   117.643    56.279
>
   118.269    56.900
   117.643    56.279
>
   118.269    56.900
   117.656    56.282
>
   118.269    56.900
   117.656    56.282
>
   118.269    56.900
   117.699    56.314
>
   118.269    56.900
   117.699    56.314
>
   118.269    56.900
   117.637    56.280
>
   118.269    56.900
   117.637    56.280
>
   118.269    56.900
   117.661    56.287
>
   118.269    56.900
   117.661    56.287
>
   118.269    56.900
   117.661    56.287
>
   118.269    56.900
   117.649    56.280
>
   118.269    56.900
   117.649    56.280
>
   118.269    56.900
   117.644    56.270
>
   118.269    56.900
   117.644    56.270
>
   118.269    56.900
   117.650    56.281
>
   118.269    56.900
   117.650    56.281
>
   118.269    56.900
   117.635    56.301
>
   118.269    56.900
   117.635    56.301
>
   118.269    56.900
   117.631    56.297
>
   118.269    56.900
   117.631    56.297
>
   118.269    56.900
   117.631    56.297
>
   118.269    56.900
   117.636    56.312
>
   118.269    56.900
   117.636    56.312
>
   118.269    56.900
   117.675    56.314
>
   118.269    56.900
   117.675    56.314
>
   118.269    56.900
   118.304    56.684
>
   118.269    56.900
   118.304    56.684
>
   119.979    56.921
   118.304    56.684
>
   119.979    56.921
   118.304    56.684
>
   118.269    56.900
   117.655    56.293
>
   118.269    56.900
   117.655    56.293
>
   118.269    56.900
   117.957    56.592
>
   118.269    56.900
   117.957    56.592
>
   118.269    56.900
   117.735    56.322
>
   118.269    56.900
   117.735    56.322
>
   118.269    56.900
   117.756    56.299
>
   118.269    56.900
   117.756    56.299
>
   118.269    56.900
   118.290    56.677
>
   118.269    56.900
   118.290    56.677
>
   118.269    56.900
   117.832    56.317
>
   118.269    56.900
   117.832    56.317
>
   118.269    56.900
   117.704    56.320
>
   118.269    56.900
   117.704    56.320
>
   118.269    56.900
   117.690    56.306
>
   118.269    56.900
   117.690    56.306
>
   118.269    56.900
   117.669    56.291
>
   118.269    56.900
   117.669    56.291
>
   118.269    56.900
   117.682    56.325
>
   118.269    56.900
   117.682    56.325
>
   118.269    56.900
   117.644    56.328
>
   118.269    56.900
   117.644    56.328
>
   118.269    56.900
   117.630    56.286
>
   118.269    56.900
   117.630    56.286
>
   118.269    56.900
   118.287    56.672
>
   118.269    56.900
   118.287    56.672
>
   119.979    56.921
   118.287    56.672
>
   119.979    56.921
   118.287    56.672
>
   118.269    56.900
   118.292    56.669
>
   118.269    56.900
   118.292    56.669
>
   119.979    56.921
   118.292    56.669
>
   119.979    56.921
   118.292    56.669
>
   118.269    56.900
   117.659    56.302
>
   118.269    56.900
   117.659    56.302
>
   118.269    56.900
   117.659    56.302
>
   118.269    56.900
   117.369    56.713
>
   115.703    56.491
   117.369    56.713
>
   115.703    56.491
   117.369    56.713
>
   115.703    56.491
   117.369    56.713
>
   118.269    56.900
   117.347    56.699
>
   118.269    56.900
   117.347    56.699
>
   115.703    56.491
   117.347    56.699
>
   115.703    56.491
   117.347    56.699
>
   115.703    56.491
   117.347    56.699
>
   118.269    56.900
   117.369    56.709
>
   118.269    56.900
   117.369    56.709
>
   115.703    56.491
   117.369    56.709
>
   115.703    56.491
   117.369    56.709
>
   118.269    56.900
   117.347    56.706
>
   118.269    56.900
   117.347    56.706
>
   115.703    56.491
   117.347    56.706
>
   115.703    56.491
   117.347    56.706
>
   115.703    56.491
   117.347    56.706
>
   115.703    56.491
   117.347    56.706
>
   118.269    56.900
   117.357    56.682
>
   118.269    56.900
   117.357    56.682
>
   115.703    56.491
   117.357    56.682
>
   115.703    56.491
   117.357    56.682
>
   118.269    56.900
   117.342    56.706
>
   118.269    56.900
   117.342    56.706
>
   115.703    56.491
   117.342    56.706
>
   115.703    56.491
   117.342    56.706
>
   118.269    56.900
   117.347    56.685
>
   118.269    56.900
   117.347    56.685
>
   115.703    56.491
   117.347    56.685
>
   115.703    56.491
   117.347    56.685
>
   115.703    56.491
   117.347    56.685
>
   118.269    56.900
   118.323    56.687
>
   118.269    56.900
   118.323    56.687
>
   119.979    56.921
   118.323    56.687
>
   119.979    56.921
   118.323    56.687
>
   118.269    56.900
   117.642    56.270
>
   118.269    56.900
   117.642    56.270
>
   118.269    56.900
   117.636    56.300
>
   118.269    56.900
   117.636    56.300
>
   118.269    56.900
   117.560    56.277
>
   115.703    56.491
   117.140    56.089
>
   115.703    56.491
   117.140    56.089
>
   118.269    56.900
   118.075    56.595
>
   118.269    56.900
   118.075    56.595
>
   118.269    56.900
   117.475    56.347
>
   118.269    56.900
   117.475    56.347
>
   115.703    56.491
   117.475    56.347
>
   115.703    56.491
   117.475    56.347
>
   115.703    56.491
   117.475    56.347
>
   118.269    56.900
   117.638    56.373
>
   118.269    56.900
   117.638    56.373
>
   118.269    56.900
   117.638    56.373
>
   118.269    56.900
   117.638    56.373
>
   118.269    56.900
   117.272    56.682
>
   118.269    56.900
   117.272    56.682
>
   118.269    56.900
   117.272    56.682
>
   118.269    56.900
   117.272    56.682
>
   115.703    56.491
   117.272    56.682
>
   115.703    56.491
   117.272    56.682
>
   115.703    56.491
   117.272    56.682
>
   115.703    56.491
   117.272    56.682
>
   115.703    56.491
   117.272    56.682
>
   118.269    56.900
   119.623    56.310
>
   118.269    56.900
   119.623    56.310
>
   118.269    56.900
   119.623    56.310
>
   118.269    56.900
   117.366    56.660
>
   118.269    56.900
   117.366    56.660
>
   118.269    56.900
   117.300    56.219
>
   118.269    56.900
   117.300    56.219
>
   115.703    56.491
   117.300    56.219
>
   115.703    56.491
   117.300    56.219
>
   115.703    56.491
   117.300    56.219
>
   118.269    56.900
   117.313    56.214
>
   118.269    56.900
   117.313    56.214
>
   115.703    56.491
   117.313    56.214
>
   115.703    56.491
   117.313    56.214
>
   118.269    56.900
   117.300    56.222
>
   118.269    56.900
   117.300    56.222
>
   115.703    56.491
   117.300    56.222
>
   115.703    56.491
   117.300    56.222
>
   115.703    56.491
   117.271    56.211
>
   115.703    56.491
   117.271    56.211
>
   118.269    56.900
   117.271    56.211
>
   118.269    56.900
   117.271    56.211
>
   118.269    56.900
   117.273    56.212
>
   118.269    56.900
   117.273    56.212
>
   115.703    56.491
   117.273    56.212
>
   115.703    56.491
   117.273    56.212
>
   118.269    56.900
   117.296    56.203
>
   118.269    56.900
   117.296    56.203
>
   115.703    56.491
   117.296    56.203
>
   115.703    56.491
   117.296    56.203
>
   118.269    56.900
   117.269    56.220
>
   118.269    56.900
   117.269    56.220
>
   115.703    56.491
   117.269    56.220
>
   115.703    56.491
   117.269    56.220
>
   118.269    56.900
   117.316    56.228
>
   118.269    56.900
   117.316    56.228
>
   115.703    56.491
   117.316    56.228
>
   115.703    56.491
   117.316    56.228
>
   118.269    56.900
   117.327    56.224
>
   118.269    56.900
   117.327    56.224
>
   115.703    56.491
   117.327    56.224
>
   115.703    56.491
   117.327    56.224
>
   115.703    56.491
   117.313    56.192
>
   115.703    56.491
   117.313    56.192
>
   119.979    56.921
   119.664    57.627
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
   117.380    55.870     0.300
   118.269    56.900     0.300
   115.702    56.504     0.300
   115.703    56.491     0.300
   121.592    56.562     0.300
   119.979    56.921     0.300
   119.789    56.921     0.300
   121.654    56.592     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   117.446    56.292     0.200
>
   117.926    56.280     0.200
>
   117.747    56.325     0.200
>
   117.928    56.434     0.200
>
   117.898    56.384     0.200
>
   117.324    56.350     0.200
>
   118.190    56.417     0.200
>
   118.175    56.368     0.200
>
   116.574    56.159     0.200
>
   117.514    56.248     0.200
>
   118.844    57.426     0.200
>
   117.364    57.166     0.200
>
   117.991    56.648     0.200
>
   117.937    56.633     0.200
>
   117.951    56.637     0.200
>
   117.953    56.635     0.200
>
   118.006    56.660     0.200
>
   117.951    56.629     0.200
>
   117.976    56.667     0.200
>
   117.959    56.641     0.200
>
   117.943    56.636     0.200
>
   117.984    56.636     0.200
>
   117.974    56.638     0.200
>
   116.591    56.130     0.200
>
   117.999    56.663     0.200
>
   117.997    56.657     0.200
>
   117.921    56.666     0.200
>
   117.906    56.659     0.200
>
   117.988    56.621     0.200
>
   118.066    56.626     0.200
>
   118.147    56.705     0.200
>
   117.957    56.661     0.200
>
   118.084    56.299     0.200
>
   118.086    56.655     0.200
>
   116.468    56.140     0.200
>
   117.391    56.385     0.200
>
   118.577    57.177     0.200
>
   118.132    56.397     0.200
>
   117.221    56.411     0.200
>
   117.616    56.344     0.200
>
   117.324    56.344     0.200
>
   117.223    56.333     0.200
>
   117.168    56.257     0.200
>
   117.141    56.215     0.200
>
   117.480    56.404     0.200
>
   118.235    56.339     0.200
>
   118.721    56.607     0.200
>
   118.030    56.338     0.200
>
   118.737    56.617     0.200
>
   117.981    56.340     0.200
>
   117.479    56.563     0.200
>
   118.649    57.147     0.200
>
   118.396    56.415     0.200
>
   119.695    56.795     0.200
>
   120.324    57.305     0.200
>
   116.882    56.424     0.200
>
   120.336    56.580     0.200
>
   116.525    56.170     0.200
>
   116.884    56.425     0.200
>
   118.746    56.847     0.200
>
   116.922    56.229     0.200
>
   118.753    56.261     0.200
>
   119.804    55.979     0.200
>
   117.668    56.264     0.200
>
   118.650    56.633     0.200
>
   118.660    56.612     0.200
>
   119.970    56.948     0.200
>
   117.274    56.515     0.200
>
   118.117    56.690     0.200
>
   117.954    56.634     0.200
>
   117.954    56.652     0.200
>
   117.965    56.648     0.200
>
   117.792    56.461     0.200
>
   117.964    56.628     0.200
>
   117.923    56.616     0.200
>
   117.912    56.614     0.200
>
   117.893    56.564     0.200
>
   117.901    56.604     0.200
>
   117.988    56.675     0.200
>
   117.958    56.642     0.200
>
   117.942    56.624     0.200
>
   117.951    56.645     0.200
>
   117.925    56.628     0.200
>
   117.941    56.629     0.200
>
   118.089    56.308     0.200
>
   117.926    56.628     0.200
>
   117.935    56.646     0.200
>
   117.918    56.629     0.200
>
   118.155    56.138     0.200
>
   117.935    56.160     0.200
>
   118.638    56.615     0.200
>
   118.645    56.608     0.200
>
   116.439    56.117     0.200
>
   118.621    56.618     0.200
>
   119.560    56.998     0.200
>
   117.984    56.096     0.200
>
   117.990    56.098     0.200
>
   117.504    56.362     0.200
>
   117.508    56.369     0.200
>
   117.493    56.355     0.200
>
   117.500    56.356     0.200
>
   117.543    56.742     0.200
>
   117.506    56.368     0.200
>
   118.672    56.610     0.200
>
   118.323    56.954     0.200
>
   118.325    56.968     0.200
>
   117.498    56.372     0.200
>
   118.097    56.291     0.200
>
   118.061    56.324     0.200
>
   118.086    56.303     0.200
>
   118.094    56.305     0.200
>
   118.102    56.301     0.200
>
   117.518    56.403     0.200
>
   118.055    56.636     0.200
>
   117.160    56.331     0.200
>
   118.070    56.317     0.200
>
   117.930    56.564     0.200
>
   117.930    56.549     0.200
>
   117.922    56.553     0.200
>
   117.918    56.565     0.200
>
   118.378    56.353     0.200
>
   118.374    56.346     0.200
>
   120.371    57.228     0.200
>
   120.348    57.322     0.200
>
   118.040    56.639     0.200
>
   116.736    56.145     0.200
>
   119.300    57.374     0.200
>
   118.722    57.046     0.200
>
   118.299    55.817     0.200
>
   118.567    56.580     0.200
>
   118.475    56.271     0.200
>
   118.577    56.573     0.200
>
   119.240    57.236     0.200
>
   116.433    56.193     0.200
>
   118.443    56.442     0.200
>
   118.698    56.656     0.200
>
   118.628    56.644     0.200
>
   118.627    56.639     0.200
>
   118.378    56.433     0.200
>
   118.382    56.442     0.200
>
   118.184    56.364     0.200
>
   118.500    56.522     0.200
>
   118.297    56.310     0.200
>
   117.703    56.282     0.200
>
   117.669    56.261     0.200
>
   117.956    56.644     0.200
>
   118.491    56.551     0.200
>
   117.961    56.632     0.200
>
   117.949    56.645     0.200
>
   117.950    56.638     0.200
>
   118.509    56.576     0.200
>
   118.498    56.544     0.200
>
   117.521    56.575     0.200
>
   118.284    56.429     0.200
>
   119.742    56.481     0.200
>
   119.678    56.966     0.200
>
   118.132    56.365     0.200
>
   117.784    56.329     0.200
>
   117.928    56.632     0.200
>
   118.151    56.271     0.200
>
   118.174    56.713     0.200
>
   117.536    56.288     0.200
>
   118.214    56.066     0.200
>
   118.218    56.399     0.200
>
   117.705    56.284     0.200
>
   117.759    56.430     0.200
>
   118.778    56.923     0.200
>
   119.390    56.965     0.200
>
   117.747    55.864     0.200
>
   117.187    56.411     0.200
>
   118.131    56.772     0.200
>
   118.108    56.772     0.200
>
   118.450    56.171     0.200
>
   119.512    57.020     0.200
>
   117.829    56.226     0.200
>
   118.224    56.361     0.200
>
   118.706    56.704     0.200
>
   118.713    56.682     0.200
>
   118.490    56.606     0.200
>
   117.354    56.310     0.200
>
   117.599    56.425     0.200
>
   118.465    56.611     0.200
>
   118.509    56.598     0.200
>
   120.032    56.952     0.200
>
   117.338    56.307     0.200
>
   118.199    56.303     0.200
>
   118.199    56.320     0.200
>
   117.502    56.573     0.200
>
   117.327    56.351     0.200
>
   118.834    57.017     0.200
>
   116.473    56.197     0.200
>
   118.168    57.014     0.200
>
   119.793    56.907     0.200
>
   118.049    56.311     0.200
>
   118.038    56.294     0.200
>
   119.765    56.792     0.200
>
   117.997    56.121     0.200
>
   118.001    56.104     0.200
>
   118.002    56.098     0.200
>
   117.992    56.120     0.200
>
   117.989    56.113     0.200
>
   118.024    56.126     0.200
>
   118.008    56.116     0.200
>
   118.028    56.121     0.200
>
   118.023    56.116     0.200
>
   118.014    56.109     0.200
>
   117.991    56.114     0.200
>
   118.001    56.108     0.200
>
   118.014    56.110     0.200
>
   118.013    56.104     0.200
>
   118.012    56.095     0.200
>
   118.018    56.119     0.200
>
   117.979    56.133     0.200
>
   118.006    56.103     0.200
>
   118.012    56.105     0.200
>
   117.862    56.238     0.200
>
   120.239    56.920     0.200
>
   117.941    56.642     0.200
>
   117.259    56.269     0.200
>
   118.272    56.807     0.200
>
   119.430    57.383     0.200
>
   120.257    57.469     0.200
>
   117.343    56.305     0.200
>
   118.604    56.582     0.200
>
   119.925    57.403     0.200
>
   119.935    56.130     0.200
>
   118.011    56.638     0.200
>
   118.931    56.938     0.200
>
   116.471    56.195     0.200
>
   117.239    56.147     0.200
>
   118.308    56.670     0.200
>
   118.306    56.677     0.200
>
   118.310    56.675     0.200
>
   118.308    56.684     0.200
>
   118.294    56.682     0.200
>
   118.320    56.690     0.200
>
   118.313    56.679     0.200
>
   118.282    56.710     0.200
>
   118.325    56.693     0.200
>
   118.314    56.668     0.200
>
   118.299    56.689     0.200
>
   118.335    56.687     0.200
>
   118.326    56.687     0.200
>
   118.312    56.683     0.200
>
   118.303    56.676     0.200
>
   118.290    56.697     0.200
>
   118.304    56.674     0.200
>
   118.302    56.682     0.200
>
   117.955    56.584     0.200
>
   117.950    56.576     0.200
>
   118.322    56.695     0.200
>
   118.318    56.665     0.200
>
   117.946    56.575     0.200
>
   118.323    56.678     0.200
>
   118.317    56.678     0.200
>
   118.325    56.693     0.200
>
   118.326    56.682     0.200
>
   118.316    56.687     0.200
>
   117.704    56.287     0.200
>
   117.705    56.320     0.200
>
   117.704    56.299     0.200
>
   117.700    56.307     0.200
>
   118.601    56.028     0.200
>
   117.693    56.300     0.200
>
   117.692    56.313     0.200
>
   117.699    56.324     0.200
>
   118.294    56.664     0.200
>
   117.715    56.318     0.200
>
   117.689    56.316     0.200
>
   117.716    56.313     0.200
>
   117.719    56.282     0.200
>
   117.689    56.292     0.200
>
   117.681    56.334     0.200
>
   117.672    56.313     0.200
>
   117.673    56.310     0.200
>
   117.703    56.297     0.200
>
   116.405    56.237     0.200
>
   117.724    56.306     0.200
>
   117.670    56.300     0.200
>
   117.704    56.328     0.200
>
   117.699    56.323     0.200
>
   117.697    56.278     0.200
>
   117.635    56.294     0.200
>
   117.688    56.323     0.200
>
   117.729    56.309     0.200
>
   117.735    56.316     0.200
>
   117.711    56.320     0.200
>
   117.736    56.314     0.200
>
   117.648    56.295     0.200
>
   117.661    56.301     0.200
>
   117.649    56.300     0.200
>
   117.751    56.306     0.200
>
   117.730    56.306     0.200
>
   117.733    56.318     0.200
>
   117.677    56.278     0.200
>
   117.674    56.296     0.200
>
   117.688    56.284     0.200
>
   117.634    56.302     0.200
>
   117.724    56.312     0.200
>
   117.660    56.312     0.200
>
   117.667    56.273     0.200
>
   117.633    56.299     0.200
>
   117.668    56.240     0.200
>
   117.707    56.204     0.200
>
   117.688    56.292     0.200
>
   117.695    56.301     0.200
>
   117.679    56.285     0.200
>
   117.636    56.306     0.200
>
   117.677    56.259     0.200
>
   117.650    56.279     0.200
>
   117.653    56.295     0.200
>
   117.664    56.277     0.200
>
   117.644    56.277     0.200
>
   117.661    56.286     0.200
>
   117.643    56.279     0.200
>
   117.656    56.282     0.200
>
   117.699    56.314     0.200
>
   117.637    56.280     0.200
>
   117.661    56.287     0.200
>
   117.649    56.280     0.200
>
   117.644    56.270     0.200
>
   117.650    56.281     0.200
>
   117.635    56.301     0.200
>
   117.631    56.297     0.200
>
   117.636    56.312     0.200
>
   117.675    56.314     0.200
>
   118.304    56.684     0.200
>
   117.655    56.293     0.200
>
   117.957    56.592     0.200
>
   117.735    56.322     0.200
>
   117.756    56.299     0.200
>
   118.290    56.677     0.200
>
   117.832    56.317     0.200
>
   117.704    56.320     0.200
>
   117.690    56.306     0.200
>
   117.669    56.291     0.200
>
   118.464    56.449     0.200
>
   117.682    56.325     0.200
>
   117.644    56.328     0.200
>
   117.630    56.286     0.200
>
   118.287    56.672     0.200
>
   118.292    56.669     0.200
>
   117.659    56.302     0.200
>
   117.369    56.713     0.200
>
   117.347    56.699     0.200
>
   117.369    56.709     0.200
>
   117.347    56.706     0.200
>
   117.357    56.682     0.200
>
   117.342    56.706     0.200
>
   117.347    56.685     0.200
>
   118.323    56.687     0.200
>
   117.642    56.270     0.200
>
   117.636    56.300     0.200
>
   117.560    56.277     0.200
>
   117.140    56.089     0.200
>
   118.075    56.595     0.200
>
   117.475    56.347     0.200
>
   117.638    56.373     0.200
>
   117.272    56.682     0.200
>
   119.623    56.310     0.200
>
   117.637    56.285     0.200
>
   117.366    56.660     0.200
>
   117.300    56.219     0.200
>
   117.313    56.214     0.200
>
   117.300    56.222     0.200
>
   117.271    56.211     0.200
>
   117.273    56.212     0.200
>
   117.296    56.203     0.200
>
   117.269    56.220     0.200
>
   117.316    56.228     0.200
>
   117.327    56.224     0.200
>
   117.313    56.192     0.200
>
   119.664    57.627     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   118.001    56.471     0.000   222.000   222.000
   118.001    56.471     0.000   444.000   444.000
EOF
gmt end
