#!/bin/bash
gmt begin chara1.31_base pdf,ps
proj=-JM16.0c+
reg=-R116.3/120.5/55.7/57.7
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map chara1.31'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   117.446    56.292 1
   117.926    56.280 2
   117.747    56.325 3
   117.928    56.434 4
   117.898    56.384 5
   117.324    56.350 6
   118.190    56.417 7
   118.175    56.368 8
   116.574    56.159 9
   117.514    56.248 10
   118.844    57.426 11
   117.364    57.166 12
   117.991    56.648 13
   117.937    56.633 14
   117.951    56.637 15
   117.953    56.635 16
   118.006    56.660 17
   117.951    56.629 18
   117.976    56.667 19
   117.959    56.641 20
   117.943    56.636 21
   117.984    56.636 22
   117.974    56.638 23
   116.591    56.130 24
   117.999    56.663 25
   117.997    56.657 26
   117.921    56.666 27
   117.906    56.659 28
   117.988    56.621 29
   118.066    56.626 30
   118.147    56.705 31
   117.957    56.661 32
   118.084    56.299 33
   118.086    56.655 34
   116.468    56.140 35
   117.391    56.385 36
   118.577    57.177 37
   118.132    56.397 38
   117.221    56.411 39
   117.616    56.344 40
   117.324    56.344 41
   117.223    56.333 42
   117.168    56.257 43
   117.141    56.215 44
   117.480    56.404 45
   118.235    56.339 46
   118.721    56.607 47
   118.030    56.338 48
   118.737    56.617 49
   117.981    56.340 50
   117.479    56.563 51
   118.649    57.147 52
   118.396    56.415 53
   119.695    56.795 54
   120.324    57.305 55
   116.882    56.424 56
   120.336    56.580 57
   116.525    56.170 58
   116.884    56.425 59
   118.746    56.847 60
   116.922    56.229 61
   118.753    56.261 62
   119.804    55.979 63
   117.668    56.264 64
   118.650    56.633 65
   118.660    56.612 66
   119.970    56.948 67
   117.274    56.515 68
   118.117    56.690 69
   117.954    56.634 70
   117.954    56.652 71
   117.965    56.648 72
   117.792    56.461 73
   117.964    56.628 74
   117.923    56.616 75
   117.912    56.614 76
   117.893    56.564 77
   117.901    56.604 78
   117.988    56.675 79
   117.958    56.642 80
   117.942    56.624 81
   117.951    56.645 82
   117.925    56.628 83
   117.941    56.629 84
   118.089    56.308 85
   117.926    56.628 86
   117.935    56.646 87
   117.918    56.629 88
   118.155    56.138 89
   117.935    56.160 90
   118.638    56.615 91
   118.645    56.608 92
   116.439    56.117 93
   118.621    56.618 94
   119.560    56.998 95
   117.984    56.096 96
   117.990    56.098 97
   117.504    56.362 98
   117.508    56.369 99
   117.493    56.355 100
   117.500    56.356 101
   117.543    56.742 102
   117.506    56.368 103
   118.672    56.610 104
   118.323    56.954 105
   118.325    56.968 106
   117.498    56.372 107
   118.097    56.291 108
   118.061    56.324 109
   118.086    56.303 110
   118.094    56.305 111
   118.102    56.301 112
   117.518    56.403 113
   118.055    56.636 114
   117.160    56.331 115
   118.070    56.317 116
   117.930    56.564 117
   117.930    56.549 118
   117.922    56.553 119
   117.918    56.565 120
   118.378    56.353 121
   118.374    56.346 122
   120.371    57.228 123
   120.348    57.322 124
   118.040    56.639 125
   116.736    56.145 126
   119.300    57.374 127
   118.722    57.046 128
   118.299    55.817 129
   118.567    56.580 130
   118.475    56.271 131
   118.577    56.573 132
   119.240    57.236 133
   116.433    56.193 134
   118.443    56.442 135
   118.698    56.656 136
   118.628    56.644 137
   118.627    56.639 138
   118.378    56.433 139
   118.382    56.442 140
   118.184    56.364 141
   118.500    56.522 142
   118.297    56.310 143
   117.703    56.282 144
   117.669    56.261 145
   117.956    56.644 146
   118.491    56.551 147
   117.961    56.632 148
   117.949    56.645 149
   117.950    56.638 150
   118.509    56.576 151
   118.498    56.544 152
   117.521    56.575 153
   118.284    56.429 154
   119.742    56.481 155
   119.678    56.966 156
   118.132    56.365 157
   117.784    56.329 158
   117.928    56.632 159
   118.151    56.271 160
   118.174    56.713 161
   117.536    56.288 162
   118.214    56.066 163
   118.218    56.399 164
   117.705    56.284 165
   117.759    56.430 166
   118.778    56.923 167
   119.390    56.965 168
   117.747    55.864 169
   117.187    56.411 170
   118.131    56.772 171
   118.108    56.772 172
   118.450    56.171 173
   119.512    57.020 174
   117.829    56.226 175
   118.224    56.361 176
   118.706    56.704 177
   118.713    56.682 178
   118.490    56.606 179
   117.354    56.310 180
   117.599    56.425 181
   118.465    56.611 182
   118.509    56.598 183
   120.032    56.952 184
   117.338    56.307 185
   118.199    56.303 186
   118.199    56.320 187
   117.502    56.573 188
   117.327    56.351 189
   118.834    57.017 190
   116.473    56.197 191
   118.168    57.014 192
   119.793    56.907 193
   118.049    56.311 194
   118.038    56.294 195
   119.765    56.792 196
   117.997    56.121 197
   118.001    56.104 198
   118.002    56.098 199
   117.992    56.120 200
   117.989    56.113 201
   118.024    56.126 202
   118.008    56.116 203
   118.028    56.121 204
   118.023    56.116 205
   118.014    56.109 206
   117.991    56.114 207
   118.001    56.108 208
   118.014    56.110 209
   118.013    56.104 210
   118.012    56.095 211
   118.018    56.119 212
   117.979    56.133 213
   118.006    56.103 214
   118.012    56.105 215
   117.862    56.238 216
   120.239    56.920 217
   117.941    56.642 218
   117.259    56.269 219
   118.272    56.807 220
   119.430    57.383 221
   120.257    57.469 222
   117.343    56.305 223
   118.604    56.582 224
   119.925    57.403 225
   119.935    56.130 226
   118.011    56.638 227
   118.931    56.938 228
   116.471    56.195 229
   117.239    56.147 230
   118.308    56.670 231
   118.306    56.677 232
   118.310    56.675 233
   118.308    56.684 234
   118.294    56.682 235
   118.320    56.690 236
   118.313    56.679 237
   118.282    56.710 238
   118.325    56.693 239
   118.314    56.668 240
   118.299    56.689 241
   118.335    56.687 242
   118.326    56.687 243
   118.312    56.683 244
   118.303    56.676 245
   118.290    56.697 246
   118.304    56.674 247
   118.302    56.682 248
   117.955    56.584 249
   117.950    56.576 250
   118.322    56.695 251
   118.318    56.665 252
   117.946    56.575 253
   118.323    56.678 254
   118.317    56.678 255
   118.325    56.693 256
   118.326    56.682 257
   118.316    56.687 258
   117.704    56.287 259
   117.705    56.320 260
   117.704    56.299 261
   117.700    56.307 262
   118.601    56.028 263
   117.693    56.300 264
   117.692    56.313 265
   117.699    56.324 266
   118.294    56.664 267
   117.715    56.318 268
   117.689    56.316 269
   117.716    56.313 270
   117.719    56.282 271
   117.689    56.292 272
   117.681    56.334 273
   117.672    56.313 274
   117.673    56.310 275
   117.703    56.297 276
   116.405    56.237 277
   117.724    56.306 278
   117.670    56.300 279
   117.704    56.328 280
   117.699    56.323 281
   117.697    56.278 282
   117.635    56.294 283
   117.688    56.323 284
   117.729    56.309 285
   117.735    56.316 286
   117.711    56.320 287
   117.736    56.314 288
   117.648    56.295 289
   117.661    56.301 290
   117.649    56.300 291
   117.751    56.306 292
   117.730    56.306 293
   117.733    56.318 294
   117.677    56.278 295
   117.674    56.296 296
   117.688    56.284 297
   117.634    56.302 298
   117.724    56.312 299
   117.660    56.312 300
   117.667    56.273 301
   117.633    56.299 302
   117.668    56.240 303
   117.707    56.204 304
   117.688    56.292 305
   117.695    56.301 306
   117.679    56.285 307
   117.636    56.306 308
   117.677    56.259 309
   117.650    56.279 310
   117.653    56.295 311
   117.664    56.277 312
   117.644    56.277 313
   117.661    56.286 314
   117.643    56.279 315
   117.656    56.282 316
   117.699    56.314 317
   117.637    56.280 318
   117.661    56.287 319
   117.649    56.280 320
   117.644    56.270 321
   117.650    56.281 322
   117.635    56.301 323
   117.631    56.297 324
   117.636    56.312 325
   117.675    56.314 326
   118.304    56.684 327
   117.655    56.293 328
   117.957    56.592 329
   117.735    56.322 330
   117.756    56.299 331
   118.290    56.677 332
   117.832    56.317 333
   117.704    56.320 334
   117.690    56.306 335
   117.669    56.291 336
   118.464    56.449 337
   117.682    56.325 338
   117.644    56.328 339
   117.630    56.286 340
   118.287    56.672 341
   118.292    56.669 342
   117.659    56.302 343
   117.369    56.713 344
   117.347    56.699 345
   117.369    56.709 346
   117.347    56.706 347
   117.357    56.682 348
   117.342    56.706 349
   117.347    56.685 350
   118.323    56.687 351
   117.642    56.270 352
   117.636    56.300 353
   117.560    56.277 354
   117.140    56.089 355
   118.075    56.595 356
   117.475    56.347 357
   117.638    56.373 358
   117.272    56.682 359
   119.623    56.310 360
   117.637    56.285 361
   117.366    56.660 362
   117.300    56.219 363
   117.313    56.214 364
   117.300    56.222 365
   117.271    56.211 366
   117.273    56.212 367
   117.296    56.203 368
   117.269    56.220 369
   117.316    56.228 370
   117.327    56.224 371
   117.313    56.192 372
   119.664    57.627 373
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   117.469    56.409
   117.446    56.292
>
   118.070    56.405
   117.926    56.280
>
   117.720    56.500
   117.747    56.325
>
   117.968    56.807
   117.928    56.434
>
   117.900    56.430
   117.898    56.384
>
   117.320    56.370
   117.324    56.350
>
   118.106    56.511
   118.190    56.417
>
   118.200    56.410
   118.175    56.368
>
   116.550    56.170
   116.574    56.159
>
   117.500    56.270
   117.514    56.248
>
   118.854    57.510
   118.844    57.426
>
   117.370    57.180
   117.364    57.166
>
   118.013    56.717
   117.991    56.648
>
   117.950    56.660
   117.937    56.633
>
   117.950    56.680
   117.951    56.637
>
   117.980    56.680
   117.953    56.635
>
   118.010    56.700
   118.006    56.660
>
   117.970    56.680
   117.951    56.629
>
   118.000    56.710
   117.976    56.667
>
   117.990    56.670
   117.959    56.641
>
   117.960    56.670
   117.943    56.636
>
   117.990    56.650
   117.984    56.636
>
   117.980    56.670
   117.974    56.638
>
   116.590    56.170
   116.591    56.130
>
   118.051    56.695
   117.999    56.663
>
   118.040    56.710
   117.997    56.657
>
   117.890    56.730
   117.921    56.666
>
   117.920    56.690
   117.906    56.659
>
   118.030    56.690
   117.988    56.621
>
   118.020    56.690
   118.066    56.626
>
   118.170    56.770
   118.147    56.705
>
   117.970    56.700
   117.957    56.661
>
   118.070    56.340
   118.084    56.299
>
   118.020    56.710
   118.086    56.655
>
   116.480    56.190
   116.468    56.140
>
   117.390    56.420
   117.391    56.385
>
   118.722    57.208
   118.577    57.177
>
   118.060    56.450
   118.132    56.397
>
   117.270    56.440
   117.221    56.411
>
   117.625    56.457
   117.616    56.344
>
   117.300    56.380
   117.324    56.344
>
   117.260    56.370
   117.223    56.333
>
   117.170    56.260
   117.168    56.257
>
   117.140    56.260
   117.141    56.215
>
   117.309    56.498
   117.480    56.404
>
   117.993    56.264
   118.235    56.339
>
   118.670    56.670
   118.721    56.607
>
   118.000    56.380
   118.030    56.338
>
   118.670    56.670
   118.737    56.617
>
   118.000    56.390
   117.981    56.340
>
   117.440    56.610
   117.479    56.563
>
   118.580    57.180
   118.649    57.147
>
   118.410    56.450
   118.396    56.415
>
   119.669    56.789
   119.695    56.795
>
   120.290    57.380
   120.324    57.305
>
   116.860    56.470
   116.882    56.424
>
   120.270    56.610
   120.336    56.580
>
   116.470    56.230
   116.525    56.170
>
   116.870    56.450
   116.884    56.425
>
   118.810    56.990
   118.746    56.847
>
   116.890    56.290
   116.922    56.229
>
   118.690    56.290
   118.753    56.261
>
   119.779    55.995
   119.804    55.979
>
   117.680    56.290
   117.668    56.264
>
   118.670    56.660
   118.650    56.633
>
   118.640    56.680
   118.660    56.612
>
   119.900    57.010
   119.970    56.948
>
   117.270    56.530
   117.274    56.515
>
   118.160    56.720
   118.117    56.690
>
   117.950    56.578
   117.954    56.634
>
   117.940    56.700
   117.954    56.652
>
   118.000    56.690
   117.965    56.648
>
   117.810    56.490
   117.792    56.461
>
   117.990    56.670
   117.964    56.628
>
   117.860    56.690
   117.923    56.616
>
   117.920    56.650
   117.912    56.614
>
   117.880    56.590
   117.893    56.564
>
   117.930    56.630
   117.901    56.604
>
   117.911    56.627
   117.988    56.675
>
   117.980    56.670
   117.958    56.642
>
   117.920    56.680
   117.942    56.624
>
   117.805    56.681
   117.951    56.645
>
   117.782    56.598
   117.925    56.628
>
   117.960    56.660
   117.941    56.629
>
   118.080    56.340
   118.089    56.308
>
   117.767    56.587
   117.926    56.628
>
   117.990    56.680
   117.935    56.646
>
   117.920    56.660
   117.918    56.629
>
   118.130    56.180
   118.155    56.138
>
   117.950    56.170
   117.935    56.160
>
   118.650    56.660
   118.638    56.615
>
   118.690    56.670
   118.645    56.608
>
   116.420    56.160
   116.439    56.117
>
   118.630    56.650
   118.621    56.618
>
   119.750    57.200
   119.560    56.998
>
   118.064    56.109
   117.984    56.096
>
   117.990    56.110
   117.990    56.098
>
   117.530    56.400
   117.504    56.362
>
   117.500    56.400
   117.508    56.369
>
   117.500    56.400
   117.493    56.355
>
   117.462    56.378
   117.500    56.356
>
   117.570    56.780
   117.543    56.742
>
   117.530    56.390
   117.506    56.368
>
   118.629    56.559
   118.672    56.610
>
   118.354    56.978
   118.323    56.954
>
   118.360    57.000
   118.325    56.968
>
   117.520    56.390
   117.498    56.372
>
   118.170    56.301
   118.097    56.291
>
   118.110    56.340
   118.061    56.324
>
   118.103    56.270
   118.086    56.303
>
   118.110    56.330
   118.094    56.305
>
   117.966    56.280
   118.102    56.301
>
   117.520    56.430
   117.518    56.403
>
   118.100    56.680
   118.055    56.636
>
   117.160    56.340
   117.160    56.331
>
   118.100    56.340
   118.070    56.317
>
   117.970    56.600
   117.930    56.564
>
   117.980    56.580
   117.930    56.549
>
   117.877    56.530
   117.922    56.553
>
   117.930    56.590
   117.918    56.565
>
   118.400    56.380
   118.378    56.353
>
   118.390    56.370
   118.374    56.346
>
   119.670    57.110
   120.371    57.228
>
   120.260    57.290
   120.348    57.322
>
   118.100    56.660
   118.040    56.639
>
   116.760    56.170
   116.736    56.145
>
   119.329    57.321
   119.300    57.374
>
   118.810    57.150
   118.722    57.046
>
   118.330    55.860
   118.299    55.817
>
   118.596    56.587
   118.567    56.580
>
   118.601    56.279
   118.475    56.271
>
   118.570    56.580
   118.577    56.573
>
   119.350    57.280
   119.240    57.236
>
   116.420    56.230
   116.433    56.193
>
   118.460    56.530
   118.443    56.442
>
   118.757    56.601
   118.698    56.656
>
   118.515    56.520
   118.628    56.644
>
   118.720    56.710
   118.627    56.639
>
   118.410    56.460
   118.378    56.433
>
   118.420    56.460
   118.382    56.442
>
   118.180    56.400
   118.184    56.364
>
   118.530    56.570
   118.500    56.522
>
   118.300    56.350
   118.297    56.310
>
   117.740    56.340
   117.703    56.282
>
   117.730    56.300
   117.669    56.261
>
   117.960    56.680
   117.956    56.644
>
   118.500    56.600
   118.491    56.551
>
   117.990    56.690
   117.961    56.632
>
   117.970    56.660
   117.949    56.645
>
   117.980    56.680
   117.950    56.638
>
   118.520    56.590
   118.509    56.576
>
   118.510    56.570
   118.498    56.544
>
   117.560    56.630
   117.521    56.575
>
   118.320    56.470
   118.284    56.429
>
   119.592    56.476
   119.742    56.481
>
   119.676    56.995
   119.678    56.966
>
   118.137    56.378
   118.132    56.365
>
   117.751    56.286
   117.784    56.329
>
   117.930    56.650
   117.928    56.632
>
   118.160    56.320
   118.151    56.271
>
   118.000    56.717
   118.174    56.713
>
   117.753    56.459
   117.536    56.288
>
   118.185    56.043
   118.214    56.066
>
   118.138    56.325
   118.218    56.399
>
   117.690    56.320
   117.705    56.284
>
   117.770    56.460
   117.759    56.430
>
   118.867    57.022
   118.778    56.923
>
   119.440    57.080
   119.390    56.965
>
   117.750    55.880
   117.747    55.864
>
   117.200    56.450
   117.187    56.411
>
   118.430    56.785
   118.131    56.772
>
   118.150    56.820
   118.108    56.772
>
   118.480    56.190
   118.450    56.171
>
   119.530    57.100
   119.512    57.020
>
   117.815    56.213
   117.829    56.226
>
   118.230    56.400
   118.224    56.361
>
   118.730    56.750
   118.706    56.704
>
   118.730    56.750
   118.713    56.682
>
   118.510    56.650
   118.490    56.606
>
   117.333    56.316
   117.354    56.310
>
   117.620    56.440
   117.599    56.425
>
   118.480    56.640
   118.465    56.611
>
   118.540    56.630
   118.509    56.598
>
   120.038    57.045
   120.032    56.952
>
   117.330    56.340
   117.338    56.307
>
   118.190    56.340
   118.199    56.303
>
   118.210    56.370
   118.199    56.320
>
   117.520    56.610
   117.502    56.573
>
   117.370    56.370
   117.327    56.351
>
   118.794    57.035
   118.834    57.017
>
   116.470    56.220
   116.473    56.197
>
   118.136    57.048
   118.168    57.014
>
   119.830    56.990
   119.793    56.907
>
   118.060    56.340
   118.049    56.311
>
   118.030    56.350
   118.038    56.294
>
   119.810    56.950
   119.765    56.792
>
   117.990    56.160
   117.997    56.121
>
   118.174    56.226
   118.001    56.104
>
   118.013    56.070
   118.002    56.098
>
   117.980    56.140
   117.992    56.120
>
   117.980    56.130
   117.989    56.113
>
   118.020    56.150
   118.024    56.126
>
   118.000    56.130
   118.008    56.116
>
   118.020    56.150
   118.028    56.121
>
   118.020    56.140
   118.023    56.116
>
   118.020    56.130
   118.014    56.109
>
   117.980    56.150
   117.991    56.114
>
   118.067    56.222
   118.001    56.108
>
   118.010    56.130
   118.014    56.110
>
   118.020    56.130
   118.013    56.104
>
   118.100    56.168
   118.012    56.095
>
   118.030    56.140
   118.018    56.119
>
   117.970    56.150
   117.979    56.133
>
   117.980    56.140
   118.006    56.103
>
   118.010    56.140
   118.012    56.105
>
   117.754    56.195
   117.862    56.238
>
   120.271    57.096
   120.239    56.920
>
   117.950    56.680
   117.941    56.642
>
   117.270    56.300
   117.259    56.269
>
   118.300    56.840
   118.272    56.807
>
   119.570    57.500
   119.430    57.383
>
   120.300    57.540
   120.257    57.469
>
   117.360    56.340
   117.343    56.305
>
   118.614    56.556
   118.604    56.582
>
   119.988    57.511
   119.925    57.403
>
   120.140    56.291
   119.935    56.130
>
   117.971    56.637
   118.011    56.638
>
   119.077    57.098
   118.931    56.938
>
   116.460    56.220
   116.471    56.195
>
   117.230    56.170
   117.239    56.147
>
   118.344    56.603
   118.308    56.670
>
   118.330    56.700
   118.306    56.677
>
   118.277    56.585
   118.310    56.675
>
   118.379    56.715
   118.308    56.684
>
   118.123    56.595
   118.294    56.682
>
   118.370    56.965
   118.320    56.690
>
   118.330    56.710
   118.313    56.679
>
   118.330    56.720
   118.282    56.710
>
   118.340    56.730
   118.325    56.693
>
   118.320    56.710
   118.314    56.668
>
   118.340    56.730
   118.299    56.689
>
   118.402    56.822
   118.335    56.687
>
   118.330    56.720
   118.326    56.687
>
   118.490    56.716
   118.312    56.683
>
   118.310    56.710
   118.303    56.676
>
   118.330    56.730
   118.290    56.697
>
   118.444    56.757
   118.304    56.674
>
   118.278    56.654
   118.302    56.682
>
   117.970    56.610
   117.955    56.584
>
   118.076    56.608
   117.950    56.576
>
   118.320    56.720
   118.322    56.695
>
   118.330    56.710
   118.318    56.665
>
   117.889    56.520
   117.946    56.575
>
   118.330    56.720
   118.323    56.678
>
   118.310    56.720
   118.317    56.678
>
   118.320    56.740
   118.325    56.693
>
   118.464    56.804
   118.326    56.682
>
   118.249    56.657
   118.316    56.687
>
   117.650    56.289
   117.704    56.287
>
   117.854    56.499
   117.705    56.320
>
   117.700    56.330
   117.704    56.299
>
   117.680    56.360
   117.700    56.307
>
   118.740    56.100
   118.601    56.028
>
   117.700    56.330
   117.693    56.300
>
   117.633    56.250
   117.692    56.313
>
   117.848    56.464
   117.699    56.324
>
   118.310    56.710
   118.294    56.664
>
   117.758    56.263
   117.715    56.318
>
   117.700    56.350
   117.689    56.316
>
   117.854    56.547
   117.716    56.313
>
   117.730    56.310
   117.719    56.282
>
   117.680    56.330
   117.689    56.292
>
   117.606    56.224
   117.681    56.334
>
   117.690    56.340
   117.672    56.313
>
   117.690    56.340
   117.673    56.310
>
   117.720    56.330
   117.703    56.297
>
   116.482    56.422
   116.405    56.237
>
   117.796    56.451
   117.724    56.306
>
   117.670    56.330
   117.670    56.300
>
   117.801    56.422
   117.704    56.328
>
   117.682    56.261
   117.699    56.323
>
   117.720    56.300
   117.697    56.278
>
   117.640    56.330
   117.635    56.294
>
   117.690    56.360
   117.688    56.323
>
   117.730    56.337
   117.729    56.309
>
   117.750    56.340
   117.735    56.316
>
   117.701    56.306
   117.711    56.320
>
   117.740    56.340
   117.736    56.314
>
   117.660    56.310
   117.648    56.295
>
   117.727    56.273
   117.661    56.301
>
   117.650    56.330
   117.649    56.300
>
   117.760    56.340
   117.751    56.306
>
   117.740    56.340
   117.730    56.306
>
   117.730    56.360
   117.733    56.318
>
   117.662    56.299
   117.677    56.278
>
   117.680    56.320
   117.674    56.296
>
   117.700    56.320
   117.688    56.284
>
   117.640    56.330
   117.634    56.302
>
   117.740    56.340
   117.724    56.312
>
   117.660    56.340
   117.660    56.312
>
   117.670    56.300
   117.667    56.273
>
   117.640    56.320
   117.633    56.299
>
   117.670    56.250
   117.668    56.240
>
   117.680    56.250
   117.707    56.204
>
   117.680    56.340
   117.688    56.292
>
   117.710    56.330
   117.695    56.301
>
   117.627    56.204
   117.679    56.285
>
   117.653    56.255
   117.636    56.306
>
   117.690    56.280
   117.677    56.259
>
   117.650    56.320
   117.650    56.279
>
   117.606    56.241
   117.653    56.295
>
   117.650    56.320
   117.664    56.277
>
   117.650    56.300
   117.644    56.277
>
   117.648    56.195
   117.661    56.286
>
   117.640    56.310
   117.643    56.279
>
   117.670    56.300
   117.656    56.282
>
   117.700    56.350
   117.699    56.314
>
   117.620    56.320
   117.637    56.280
>
   117.514    56.197
   117.661    56.287
>
   117.650    56.300
   117.649    56.280
>
   117.630    56.290
   117.644    56.270
>
   117.650    56.320
   117.650    56.281
>
   117.640    56.330
   117.635    56.301
>
   117.511    56.249
   117.631    56.297
>
   117.650    56.330
   117.636    56.312
>
   117.690    56.340
   117.675    56.314
>
   118.297    56.626
   118.304    56.684
>
   117.660    56.330
   117.655    56.293
>
   118.002    56.579
   117.957    56.592
>
   117.750    56.360
   117.735    56.322
>
   117.888    56.446
   117.756    56.299
>
   118.310    56.720
   118.290    56.677
>
   117.830    56.350
   117.832    56.317
>
   117.609    56.230
   117.704    56.320
>
   117.591    56.245
   117.690    56.306
>
   117.670    56.320
   117.669    56.291
>
   118.490    56.520
   118.464    56.449
>
   117.832    56.496
   117.682    56.325
>
   117.819    56.549
   117.644    56.328
>
   117.640    56.310
   117.630    56.286
>
   118.300    56.720
   118.287    56.672
>
   118.300    56.710
   118.292    56.669
>
   117.614    56.217
   117.659    56.302
>
   117.512    56.904
   117.369    56.713
>
   117.242    56.600
   117.347    56.699
>
   117.370    56.760
   117.369    56.709
>
   117.441    56.721
   117.347    56.706
>
   117.360    56.730
   117.357    56.682
>
   117.293    56.806
   117.342    56.706
>
   117.298    56.604
   117.347    56.685
>
   118.330    56.740
   118.323    56.687
>
   117.640    56.300
   117.642    56.270
>
   117.648    56.282
   117.636    56.300
>
   117.462    56.232
   117.560    56.277
>
   117.177    56.080
   117.140    56.089
>
   118.080    56.620
   118.075    56.595
>
   117.661    56.434
   117.475    56.347
>
   117.604    56.379
   117.638    56.373
>
   117.314    56.759
   117.272    56.682
>
   119.524    56.331
   119.623    56.310
>
   117.650    56.310
   117.637    56.285
>
   117.370    56.710
   117.366    56.660
>
   117.320    56.250
   117.300    56.219
>
   117.320    56.260
   117.313    56.214
>
   117.252    56.315
   117.300    56.222
>
   117.090    56.215
   117.271    56.211
>
   117.541    56.291
   117.273    56.212
>
   117.413    56.268
   117.296    56.203
>
   117.252    56.247
   117.269    56.220
>
   117.296    56.280
   117.316    56.228
>
   117.294    56.358
   117.327    56.224
>
   117.339    56.224
   117.313    56.192
>
   119.590    57.520
   119.664    57.627
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   117.445    56.291
   117.446    56.292
>
   117.928    56.278
   117.926    56.280
>
   117.747    56.326
   117.747    56.325
>
   117.928    56.434
   117.928    56.434
>
   117.898    56.384
   117.898    56.384
>
   117.324    56.349
   117.324    56.350
>
   118.188    56.417
   118.190    56.417
>
   118.175    56.369
   118.175    56.368
>
   116.573    56.158
   116.574    56.159
>
   117.514    56.249
   117.514    56.248
>
   118.843    57.426
   118.844    57.426
>
   117.363    57.166
   117.364    57.166
>
   117.990    56.648
   117.991    56.648
>
   117.937    56.633
   117.937    56.633
>
   117.950    56.637
   117.951    56.637
>
   117.953    56.635
   117.953    56.635
>
   118.006    56.660
   118.006    56.660
>
   117.951    56.630
   117.951    56.629
>
   117.976    56.666
   117.976    56.667
>
   117.959    56.641
   117.959    56.641
>
   117.943    56.636
   117.943    56.636
>
   117.985    56.636
   117.984    56.636
>
   117.974    56.638
   117.974    56.638
>
   116.590    56.132
   116.591    56.130
>
   117.998    56.664
   117.999    56.663
>
   117.997    56.657
   117.997    56.657
>
   117.923    56.666
   117.921    56.666
>
   117.905    56.660
   117.906    56.659
>
   117.988    56.621
   117.988    56.621
>
   118.065    56.626
   118.066    56.626
>
   118.146    56.706
   118.147    56.705
>
   117.956    56.662
   117.957    56.661
>
   118.084    56.300
   118.084    56.299
>
   118.084    56.656
   118.086    56.655
>
   116.467    56.140
   116.468    56.140
>
   117.391    56.385
   117.391    56.385
>
   118.575    57.178
   118.577    57.177
>
   118.132    56.397
   118.132    56.397
>
   117.221    56.412
   117.221    56.411
>
   117.616    56.345
   117.616    56.344
>
   117.324    56.344
   117.324    56.344
>
   117.222    56.333
   117.223    56.333
>
   117.167    56.257
   117.168    56.257
>
   117.140    56.215
   117.141    56.215
>
   117.480    56.404
   117.480    56.404
>
   118.234    56.340
   118.235    56.339
>
   118.720    56.608
   118.721    56.607
>
   118.030    56.338
   118.030    56.338
>
   118.738    56.617
   118.737    56.617
>
   117.980    56.340
   117.981    56.340
>
   117.478    56.564
   117.479    56.563
>
   118.649    57.147
   118.649    57.147
>
   118.396    56.414
   118.396    56.415
>
   119.695    56.794
   119.695    56.795
>
   120.322    57.305
   120.324    57.305
>
   116.885    56.425
   116.882    56.424
>
   120.335    56.579
   120.336    56.580
>
   116.526    56.171
   116.525    56.170
>
   116.884    56.424
   116.884    56.425
>
   118.747    56.847
   118.746    56.847
>
   116.921    56.229
   116.922    56.229
>
   118.753    56.261
   118.753    56.261
>
   119.805    55.980
   119.804    55.979
>
   117.668    56.264
   117.668    56.264
>
   118.653    56.633
   118.650    56.633
>
   118.659    56.612
   118.660    56.612
>
   119.968    56.950
   119.970    56.948
>
   117.274    56.516
   117.274    56.515
>
   118.117    56.691
   118.117    56.690
>
   117.954    56.634
   117.954    56.634
>
   117.960    56.645
   117.954    56.652
>
   117.964    56.649
   117.965    56.648
>
   117.792    56.461
   117.792    56.461
>
   117.964    56.628
   117.964    56.628
>
   117.923    56.616
   117.923    56.616
>
   117.911    56.614
   117.912    56.614
>
   117.893    56.564
   117.893    56.564
>
   117.901    56.604
   117.901    56.604
>
   117.988    56.675
   117.988    56.675
>
   117.958    56.642
   117.958    56.642
>
   117.942    56.624
   117.942    56.624
>
   117.950    56.645
   117.951    56.645
>
   117.925    56.627
   117.925    56.628
>
   117.941    56.628
   117.941    56.629
>
   118.089    56.308
   118.089    56.308
>
   117.926    56.628
   117.926    56.628
>
   117.935    56.646
   117.935    56.646
>
   117.912    56.637
   117.918    56.629
>
   118.155    56.138
   118.155    56.138
>
   117.935    56.159
   117.935    56.160
>
   118.638    56.615
   118.638    56.615
>
   118.645    56.608
   118.645    56.608
>
   116.440    56.118
   116.439    56.117
>
   118.620    56.618
   118.621    56.618
>
   119.560    56.997
   119.560    56.998
>
   117.984    56.096
   117.984    56.096
>
   117.991    56.098
   117.990    56.098
>
   117.504    56.362
   117.504    56.362
>
   117.508    56.368
   117.508    56.369
>
   117.493    56.355
   117.493    56.355
>
   117.500    56.356
   117.500    56.356
>
   117.543    56.742
   117.543    56.742
>
   117.506    56.368
   117.506    56.368
>
   118.672    56.611
   118.672    56.610
>
   118.322    56.955
   118.323    56.954
>
   118.323    56.967
   118.325    56.968
>
   117.499    56.372
   117.498    56.372
>
   118.098    56.291
   118.097    56.291
>
   118.061    56.324
   118.061    56.324
>
   118.086    56.303
   118.086    56.303
>
   118.094    56.304
   118.094    56.305
>
   118.102    56.301
   118.102    56.301
>
   117.518    56.404
   117.518    56.403
>
   118.054    56.636
   118.055    56.636
>
   117.160    56.331
   117.160    56.331
>
   118.070    56.317
   118.070    56.317
>
   117.930    56.564
   117.930    56.564
>
   117.930    56.550
   117.930    56.549
>
   117.921    56.554
   117.922    56.553
>
   117.918    56.565
   117.918    56.565
>
   118.377    56.353
   118.378    56.353
>
   118.374    56.347
   118.374    56.346
>
   120.372    57.229
   120.371    57.228
>
   120.346    57.322
   120.348    57.322
>
   118.040    56.639
   118.040    56.639
>
   116.739    56.146
   116.736    56.145
>
   119.299    57.373
   119.300    57.374
>
   118.721    57.047
   118.722    57.046
>
   118.299    55.817
   118.299    55.817
>
   118.567    56.581
   118.567    56.580
>
   118.474    56.271
   118.475    56.271
>
   118.576    56.572
   118.577    56.573
>
   119.240    57.237
   119.240    57.236
>
   116.433    56.192
   116.433    56.193
>
   118.442    56.443
   118.443    56.442
>
   118.698    56.656
   118.698    56.656
>
   118.629    56.645
   118.628    56.644
>
   118.627    56.639
   118.627    56.639
>
   118.378    56.434
   118.378    56.433
>
   118.381    56.443
   118.382    56.442
>
   118.184    56.363
   118.184    56.364
>
   118.501    56.523
   118.500    56.522
>
   118.297    56.310
   118.297    56.310
>
   117.704    56.282
   117.703    56.282
>
   117.669    56.261
   117.669    56.261
>
   117.956    56.644
   117.956    56.644
>
   118.491    56.551
   118.491    56.551
>
   117.961    56.632
   117.961    56.632
>
   117.949    56.645
   117.949    56.645
>
   117.950    56.638
   117.950    56.638
>
   118.509    56.576
   118.509    56.576
>
   118.499    56.544
   118.498    56.544
>
   117.521    56.576
   117.521    56.575
>
   118.284    56.430
   118.284    56.429
>
   119.742    56.480
   119.742    56.481
>
   119.676    56.970
   119.678    56.966
>
   118.132    56.365
   118.132    56.365
>
   117.784    56.330
   117.784    56.329
>
   117.928    56.632
   117.928    56.632
>
   118.151    56.271
   118.151    56.271
>
   118.173    56.713
   118.174    56.713
>
   117.536    56.288
   117.536    56.288
>
   118.214    56.066
   118.214    56.066
>
   118.218    56.399
   118.218    56.399
>
   117.705    56.284
   117.705    56.284
>
   117.759    56.430
   117.759    56.430
>
   118.777    56.924
   118.778    56.923
>
   119.391    56.965
   119.390    56.965
>
   117.748    55.865
   117.747    55.864
>
   117.186    56.412
   117.187    56.411
>
   118.131    56.772
   118.131    56.772
>
   118.109    56.772
   118.108    56.772
>
   118.450    56.171
   118.450    56.171
>
   119.513    57.021
   119.512    57.020
>
   117.829    56.226
   117.829    56.226
>
   118.224    56.361
   118.224    56.361
>
   118.705    56.704
   118.706    56.704
>
   118.713    56.682
   118.713    56.682
>
   118.490    56.607
   118.490    56.606
>
   117.354    56.311
   117.354    56.310
>
   117.599    56.425
   117.599    56.425
>
   118.464    56.610
   118.465    56.611
>
   118.510    56.598
   118.509    56.598
>
   120.032    56.953
   120.032    56.952
>
   117.338    56.307
   117.338    56.307
>
   118.199    56.303
   118.199    56.303
>
   118.199    56.320
   118.199    56.320
>
   117.502    56.571
   117.502    56.573
>
   117.327    56.351
   117.327    56.351
>
   118.834    57.015
   118.834    57.017
>
   116.475    56.198
   116.473    56.197
>
   118.169    57.012
   118.168    57.014
>
   119.793    56.906
   119.793    56.907
>
   118.049    56.311
   118.049    56.311
>
   118.038    56.294
   118.038    56.294
>
   119.765    56.792
   119.765    56.792
>
   117.996    56.121
   117.997    56.121
>
   118.001    56.104
   118.001    56.104
>
   118.003    56.097
   118.002    56.098
>
   117.992    56.120
   117.992    56.120
>
   117.989    56.113
   117.989    56.113
>
   118.024    56.126
   118.024    56.126
>
   118.008    56.116
   118.008    56.116
>
   118.028    56.121
   118.028    56.121
>
   118.023    56.116
   118.023    56.116
>
   118.014    56.109
   118.014    56.109
>
   117.991    56.114
   117.991    56.114
>
   118.001    56.108
   118.001    56.108
>
   118.013    56.109
   118.014    56.110
>
   118.013    56.104
   118.013    56.104
>
   118.012    56.095
   118.012    56.095
>
   118.018    56.119
   118.018    56.119
>
   117.979    56.133
   117.979    56.133
>
   118.010    56.099
   118.006    56.103
>
   118.011    56.104
   118.012    56.105
>
   117.862    56.238
   117.862    56.238
>
   120.240    56.920
   120.239    56.920
>
   117.940    56.644
   117.941    56.642
>
   117.258    56.270
   117.259    56.269
>
   118.268    56.819
   118.272    56.807
>
   119.430    57.384
   119.430    57.383
>
   120.258    57.469
   120.257    57.469
>
   117.343    56.305
   117.343    56.305
>
   118.604    56.582
   118.604    56.582
>
   119.925    57.404
   119.925    57.403
>
   119.935    56.130
   119.935    56.130
>
   118.010    56.638
   118.011    56.638
>
   118.928    56.936
   118.931    56.938
>
   116.471    56.195
   116.471    56.195
>
   117.239    56.147
   117.239    56.147
>
   118.308    56.669
   118.308    56.670
>
   118.306    56.677
   118.306    56.677
>
   118.310    56.675
   118.310    56.675
>
   118.308    56.684
   118.308    56.684
>
   118.294    56.682
   118.294    56.682
>
   118.321    56.690
   118.320    56.690
>
   118.313    56.679
   118.313    56.679
>
   118.283    56.712
   118.282    56.710
>
   118.326    56.693
   118.325    56.693
>
   118.315    56.668
   118.314    56.668
>
   118.299    56.690
   118.299    56.689
>
   118.336    56.687
   118.335    56.687
>
   118.326    56.687
   118.326    56.687
>
   118.313    56.683
   118.312    56.683
>
   118.302    56.676
   118.303    56.676
>
   118.291    56.697
   118.290    56.697
>
   118.304    56.675
   118.304    56.674
>
   118.301    56.682
   118.302    56.682
>
   117.955    56.584
   117.955    56.584
>
   117.950    56.576
   117.950    56.576
>
   118.321    56.695
   118.322    56.695
>
   118.318    56.665
   118.318    56.665
>
   117.947    56.574
   117.946    56.575
>
   118.323    56.678
   118.323    56.678
>
   118.316    56.679
   118.317    56.678
>
   118.324    56.693
   118.325    56.693
>
   118.326    56.683
   118.326    56.682
>
   118.316    56.688
   118.316    56.687
>
   117.705    56.287
   117.704    56.287
>
   117.706    56.320
   117.705    56.320
>
   117.703    56.299
   117.704    56.299
>
   117.700    56.307
   117.700    56.307
>
   118.601    56.027
   118.601    56.028
>
   117.694    56.300
   117.693    56.300
>
   117.692    56.313
   117.692    56.313
>
   117.699    56.325
   117.699    56.324
>
   118.294    56.664
   118.294    56.664
>
   117.715    56.318
   117.715    56.318
>
   117.689    56.316
   117.689    56.316
>
   117.716    56.314
   117.716    56.313
>
   117.719    56.283
   117.719    56.282
>
   117.689    56.292
   117.689    56.292
>
   117.682    56.334
   117.681    56.334
>
   117.672    56.313
   117.672    56.313
>
   117.673    56.310
   117.673    56.310
>
   117.702    56.297
   117.703    56.297
>
   116.404    56.237
   116.405    56.237
>
   117.724    56.306
   117.724    56.306
>
   117.670    56.300
   117.670    56.300
>
   117.704    56.328
   117.704    56.328
>
   117.700    56.323
   117.699    56.323
>
   117.698    56.278
   117.697    56.278
>
   117.634    56.295
   117.635    56.294
>
   117.688    56.323
   117.688    56.323
>
   117.729    56.309
   117.729    56.309
>
   117.736    56.316
   117.735    56.316
>
   117.711    56.321
   117.711    56.320
>
   117.736    56.314
   117.736    56.314
>
   117.647    56.295
   117.648    56.295
>
   117.661    56.301
   117.661    56.301
>
   117.648    56.300
   117.649    56.300
>
   117.751    56.307
   117.751    56.306
>
   117.730    56.305
   117.730    56.306
>
   117.733    56.318
   117.733    56.318
>
   117.675    56.278
   117.677    56.278
>
   117.674    56.296
   117.674    56.296
>
   117.688    56.284
   117.688    56.284
>
   117.634    56.302
   117.634    56.302
>
   117.724    56.312
   117.724    56.312
>
   117.660    56.312
   117.660    56.312
>
   117.666    56.273
   117.667    56.273
>
   117.633    56.299
   117.633    56.299
>
   117.669    56.241
   117.668    56.240
>
   117.706    56.205
   117.707    56.204
>
   117.688    56.292
   117.688    56.292
>
   117.695    56.301
   117.695    56.301
>
   117.679    56.285
   117.679    56.285
>
   117.636    56.306
   117.636    56.306
>
   117.677    56.259
   117.677    56.259
>
   117.650    56.279
   117.650    56.279
>
   117.653    56.295
   117.653    56.295
>
   117.663    56.277
   117.664    56.277
>
   117.644    56.277
   117.644    56.277
>
   117.661    56.287
   117.661    56.286
>
   117.642    56.279
   117.643    56.279
>
   117.656    56.283
   117.656    56.282
>
   117.699    56.313
   117.699    56.314
>
   117.636    56.280
   117.637    56.280
>
   117.661    56.288
   117.661    56.287
>
   117.649    56.280
   117.649    56.280
>
   117.643    56.270
   117.644    56.270
>
   117.650    56.282
   117.650    56.281
>
   117.635    56.300
   117.635    56.301
>
   117.631    56.297
   117.631    56.297
>
   117.636    56.312
   117.636    56.312
>
   117.675    56.315
   117.675    56.314
>
   118.304    56.684
   118.304    56.684
>
   117.655    56.293
   117.655    56.293
>
   117.957    56.593
   117.957    56.592
>
   117.735    56.322
   117.735    56.322
>
   117.756    56.299
   117.756    56.299
>
   118.290    56.677
   118.290    56.677
>
   117.832    56.317
   117.832    56.317
>
   117.703    56.320
   117.704    56.320
>
   117.690    56.306
   117.690    56.306
>
   117.669    56.291
   117.669    56.291
>
   118.463    56.448
   118.464    56.449
>
   117.682    56.325
   117.682    56.325
>
   117.645    56.328
   117.644    56.328
>
   117.630    56.286
   117.630    56.286
>
   118.286    56.672
   118.287    56.672
>
   118.292    56.669
   118.292    56.669
>
   117.659    56.302
   117.659    56.302
>
   117.368    56.713
   117.369    56.713
>
   117.347    56.699
   117.347    56.699
>
   117.369    56.709
   117.369    56.709
>
   117.347    56.706
   117.347    56.706
>
   117.356    56.683
   117.357    56.682
>
   117.342    56.705
   117.342    56.706
>
   117.348    56.685
   117.347    56.685
>
   118.323    56.687
   118.323    56.687
>
   117.642    56.270
   117.642    56.270
>
   117.636    56.300
   117.636    56.300
>
   117.560    56.278
   117.560    56.277
>
   117.140    56.089
   117.140    56.089
>
   118.075    56.595
   118.075    56.595
>
   117.475    56.347
   117.475    56.347
>
   117.638    56.373
   117.638    56.373
>
   117.271    56.682
   117.272    56.682
>
   119.623    56.310
   119.623    56.310
>
   117.637    56.285
   117.637    56.285
>
   117.366    56.661
   117.366    56.660
>
   117.300    56.219
   117.300    56.219
>
   117.313    56.214
   117.313    56.214
>
   117.300    56.222
   117.300    56.222
>
   117.272    56.210
   117.271    56.211
>
   117.271    56.213
   117.273    56.212
>
   117.297    56.202
   117.296    56.203
>
   117.269    56.220
   117.269    56.220
>
   117.316    56.227
   117.316    56.228
>
   117.327    56.223
   117.327    56.224
>
   117.311    56.193
   117.313    56.192
>
   119.667    57.628
   119.664    57.627
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   117.446    56.292    69.875     2.685     3.581
   117.926    56.280   -36.076     4.510     6.722
   117.747    56.325    60.475     2.226     3.254
   117.928    56.434    42.758     3.679     7.265
   117.898    56.384   -55.148     2.786     3.488
   117.324    56.350    66.377     1.712     2.752
   118.190    56.417    65.236     2.663     3.777
   118.175    56.368   -81.507     1.989     2.172
   116.574    56.159    77.997     2.166     3.157
   117.514    56.248    55.271     1.204     2.240
   118.844    57.426    14.235     1.410     1.635
   117.364    57.166   -87.755     1.949     5.618
   117.991    56.648    55.131     0.956     1.419
   117.937    56.633    59.022     1.589     2.794
   117.951    56.637    57.532     2.241     4.109
   117.953    56.635    60.925     1.732     3.009
   118.006    56.660    55.344     1.923     3.269
   117.951    56.629    63.873     1.946     3.547
   117.976    56.667    65.515     1.892     3.790
   117.959    56.641    63.812     1.626     2.906
   117.943    56.636    62.466     1.800     3.339
   117.984    56.636    63.022     1.728     3.189
   117.974    56.638    59.414     1.827     3.338
   116.591    56.130    68.195     2.128     3.626
   117.999    56.663    63.701     1.023     1.333
   117.997    56.657    58.162     2.072     3.581
   117.921    56.666    57.297     1.845     3.414
   117.906    56.659    63.998     2.021     3.672
   117.988    56.621    80.316     3.259     4.450
   118.066    56.626    57.057     1.716     2.865
   118.147    56.705    54.635     1.685     2.856
   117.957    56.661    49.789     1.810     2.884
   118.084    56.299    34.184     2.315     3.830
   118.086    56.655    43.340     1.977     3.518
   116.468    56.140    86.293     2.692     3.902
   117.391    56.385    57.803     2.177     4.099
   118.577    57.177    42.395     2.544     3.534
   118.132    56.397    45.394     2.030     2.744
   117.221    56.411    59.541     2.785     3.951
   117.616    56.344    65.107     1.745     2.886
   117.324    56.344    64.375     2.054     3.868
   117.223    56.333    77.715     3.261     4.275
   117.168    56.257    60.381     1.974     3.605
   117.141    56.215    55.357     3.737     5.461
   117.480    56.404    61.409     2.022     4.287
   118.235    56.339    30.379     2.099     3.181
   118.721    56.607   -21.425     3.662     5.387
   118.030    56.338    35.453     2.060     3.196
   118.737    56.617   -32.348     2.431     3.661
   117.981    56.340    47.102     2.678     4.123
   117.479    56.563    58.462     2.273     4.637
   118.649    57.147   -64.585     5.150     7.735
   118.396    56.415    17.478     1.704     2.177
   119.695    56.795   -89.956     1.797     2.701
   120.324    57.305    22.240     0.333     3.798
   116.882    56.424    70.053     2.242     5.697
   120.336    56.580   -83.287     2.441     4.819
   116.525    56.170    70.314     1.982     3.443
   116.884    56.425    76.024     1.808     3.223
   118.746    56.847   -53.323     3.729     6.869
   116.922    56.229    67.434     2.036     4.313
   118.753    56.261    -4.481     2.827     4.146
   119.804    55.979   -44.098     2.863     3.207
   117.668    56.264    55.986     1.715     2.747
   118.650    56.633   -48.436     2.144     2.628
   118.660    56.612   -46.357     1.720     2.321
   119.970    56.948    76.024     2.590     3.962
   117.274    56.515    68.455     1.537     3.086
   118.117    56.690    48.069     1.207     2.051
   117.954    56.634    58.115     1.228     2.126
   117.954    56.652    65.482     1.571     2.548
   117.965    56.648    54.936     1.321     2.336
   117.792    56.461    54.898     1.414     2.379
   117.964    56.628    52.976     1.811     3.173
   117.923    56.616    65.504     1.531     2.508
   117.912    56.614    61.991     1.454     2.156
   117.893    56.564    57.198     1.630     2.731
   117.901    56.604    64.767     1.179     1.918
   117.988    56.675    71.932     1.871     2.752
   117.958    56.642    59.504     1.044     1.746
   117.942    56.624    64.678     1.600     2.473
   117.951    56.645    59.454     1.049     1.865
   117.925    56.628    65.782     1.319     2.114
   117.941    56.629    66.127     1.475     2.063
   118.089    56.308    17.811     2.105     2.273
   117.926    56.628    58.834     1.284     2.524
   117.935    56.646    69.288     1.538     2.863
   117.918    56.629    62.942     2.046     3.453
   118.155    56.138    55.991     1.992     2.451
   117.935    56.160    49.582     1.767     2.351
   118.638    56.615   -38.065     1.482     2.142
   118.645    56.608   -61.162     1.635     1.963
   116.439    56.117   -87.031     2.650     3.490
   118.621    56.618   -24.392     2.189     2.613
   119.560    56.998   -74.960     3.810     7.122
   117.984    56.096    64.173     1.549     1.910
   117.990    56.098    55.753     1.702     2.077
   117.504    56.362    61.422     1.138     2.075
   117.508    56.369    67.303     1.687     3.073
   117.493    56.355    61.933     1.258     2.423
   117.500    56.356    62.116     1.264     2.278
   117.543    56.742    72.853     1.463     3.875
   117.506    56.368    59.566     1.220     2.321
   118.672    56.610   -79.662     1.631     1.929
   118.323    56.954    83.276     1.369     2.830
   118.325    56.968    85.889     1.982     4.435
   117.498    56.372    59.458     1.251     2.248
   118.097    56.291    55.340     1.246     1.840
   118.061    56.324    77.211     2.246     3.616
   118.086    56.303    59.921     1.406     2.021
   118.094    56.305    59.845     1.414     1.909
   118.102    56.301    39.329     1.659     2.480
   117.518    56.403    66.101     1.521     2.748
   118.055    56.636    67.197     1.190     1.995
   117.160    56.331    64.695     1.323     2.532
   118.070    56.317    48.942     1.712     2.764
   117.930    56.564    61.437     1.116     1.855
   117.930    56.549    55.906     1.230     2.204
   117.922    56.553    62.863     1.007     1.694
   117.918    56.565    66.422     1.338     2.379
   118.378    56.353    51.422     1.560     1.949
   118.374    56.346    57.994     1.682     1.920
   120.371    57.228   -85.617     4.235     6.847
   120.348    57.322    86.626     2.076     3.910
   118.040    56.639    59.618     1.078     1.905
   116.736    56.145    80.443     2.978     3.725
   119.300    57.374    86.927     3.016     6.769
   118.722    57.046   -82.673     2.906     5.764
   118.299    55.817    57.543     2.008     3.193
   118.567    56.580   -32.934     1.387     1.632
   118.475    56.271    66.504     1.739     1.972
   118.577    56.573   -75.249     2.085     2.724
   119.240    57.236   -84.320     2.544     5.117
   116.433    56.193    80.770     1.933     3.605
   118.443    56.442    53.777     1.907     2.609
   118.698    56.656   -24.504     1.896     2.977
   118.628    56.644   -81.284     1.696     2.283
   118.627    56.639   -88.412     1.863     2.641
   118.378    56.433    70.478     1.560     2.009
   118.382    56.442    62.085     1.998     2.421
   118.184    56.364    66.643     1.892     2.497
   118.500    56.522   -59.084     1.997     2.715
   118.297    56.310    53.608     1.237     1.737
   117.703    56.282    64.124     1.919     3.463
   117.669    56.261    67.953     1.641     2.273
   117.956    56.644    65.895     1.327     2.435
   118.491    56.551   -35.665     1.918     2.032
   117.961    56.632    66.766     1.408     2.601
   117.949    56.645    72.143     1.208     1.957
   117.950    56.638    62.585     1.021     2.035
   118.509    56.576    79.446     1.588     2.046
   118.498    56.544    84.611     2.011     2.471
   117.521    56.575    70.234     1.670     3.941
   118.284    56.429    57.445     1.644     2.364
   119.742    56.481   -67.200     2.462     3.234
   119.678    56.966   -76.183     2.364     4.516
   118.132    56.365    66.332     1.259     1.918
   117.784    56.329    66.845     1.398     2.300
   117.928    56.632    70.937     1.695     3.039
   118.151    56.271    66.553     2.208     2.721
   118.174    56.713    67.452     1.524     2.504
   117.536    56.288    63.797     1.184     2.289
   118.214    56.066    56.898     1.283     1.929
   118.218    56.399    56.945     1.318     1.975
   117.705    56.284    70.113     1.806     2.956
   117.759    56.430    60.312     1.732     3.023
   118.778    56.923   -88.949     2.258     5.994
   119.390    56.965   -86.535     2.284     6.461
   117.747    55.864    59.800     1.472     2.532
   117.187    56.411    68.611     1.469     3.117
   118.131    56.772    63.762     1.690     2.491
   118.108    56.772    64.128     1.613     3.475
   118.450    56.171    58.796     1.428     1.978
   119.512    57.020   -83.907     1.955     6.300
   117.829    56.226    64.949     1.479     2.305
   118.224    56.361    48.851     1.772     2.412
   118.706    56.704   -88.606     1.806     2.859
   118.713    56.682   -36.953     2.134     2.759
   118.490    56.606    65.435     1.636     1.739
   117.354    56.310    66.846     1.150     2.183
   117.599    56.425    65.778     1.699     2.972
   118.465    56.611   -83.118     1.682     2.177
   118.509    56.598   -85.254     2.051     2.654
   120.032    56.952   -79.702     3.152     5.672
   117.338    56.307    76.392     2.164     3.341
   118.199    56.303    72.241     1.485     1.984
   118.199    56.320    61.774     1.428     2.183
   117.502    56.573    71.301     1.170     2.913
   117.327    56.351    77.033     1.576     3.248
   118.834    57.017    87.012     1.656     3.593
   116.473    56.197    64.991     1.595     3.592
   118.168    57.014    87.522     1.827     2.913
   119.793    56.907   -87.013     2.559     5.802
   118.049    56.311    61.647     1.268     1.974
   118.038    56.294    60.364     1.547     2.599
   119.765    56.792    75.708     2.469     6.269
   117.997    56.121    66.101     1.401     2.063
   118.001    56.104    75.985     1.047     1.610
   118.002    56.098    68.328     1.073     1.789
   117.992    56.120    66.482     1.401     1.909
   117.989    56.113    67.883     1.189     1.682
   118.024    56.126    66.721     1.449     2.099
   118.008    56.116    64.338     1.581     2.041
   118.028    56.121    62.762     1.391     1.770
   118.023    56.116    60.988     1.620     2.107
   118.014    56.109    59.925     1.144     1.794
   117.991    56.114    63.363     1.140     1.691
   118.001    56.108    65.047     1.350     2.058
   118.014    56.110    68.121     1.440     1.990
   118.013    56.104    64.480     1.252     1.934
   118.012    56.095    62.226     1.307     1.938
   118.018    56.119    76.927     1.273     2.454
   117.979    56.133    55.974     1.866     2.583
   118.006    56.103    64.748     2.331     3.231
   118.012    56.105    60.660     1.278     2.043
   117.862    56.238    57.657     1.188     1.842
   120.239    56.920    80.174     1.716     2.991
   117.941    56.642    64.652     0.981     2.116
   117.259    56.269    64.251     1.248     2.646
   118.272    56.807    75.778     1.559     2.608
   119.430    57.383   -70.981     2.799     6.658
   120.257    57.469   -78.001     2.793     4.702
   117.343    56.305    65.834     0.996     2.226
   118.604    56.582    87.519     1.453     1.928
   119.925    57.403    54.683     2.100     3.266
   119.935    56.130    68.488     1.191     1.943
   118.011    56.638    50.492     0.871     1.429
   118.931    56.938    88.447     2.396     3.289
   116.471    56.195    71.400     1.920     4.313
   117.239    56.147    69.838     2.231     3.743
   118.308    56.670    50.457     1.053     1.450
   118.306    56.677    64.830     0.959     1.459
   118.310    56.675    53.944     1.125     1.718
   118.308    56.684    69.198     1.227     1.663
   118.294    56.682    65.189     1.184     1.668
   118.320    56.690    78.552     1.386     1.843
   118.313    56.679    66.734     1.359     1.904
   118.282    56.710    82.391     2.342     5.428
   118.325    56.693    68.751     1.320     1.811
   118.314    56.668    46.663     1.646     2.104
   118.299    56.689    70.479     1.455     2.117
   118.335    56.687    56.891     1.217     1.473
   118.326    56.687    64.830     1.354     1.953
   118.312    56.683    83.485     1.259     1.636
   118.303    56.676    65.446     1.041     1.540
   118.290    56.697    71.945     1.470     2.095
   118.304    56.674    70.067     1.203     1.692
   118.302    56.682    63.736     1.143     1.617
   117.955    56.584    66.537     1.053     2.042
   117.950    56.576    66.402     0.966     1.523
   118.322    56.695    78.771     1.470     1.955
   118.318    56.665    64.335     1.245     1.835
   117.946    56.575    64.394     0.903     1.464
   118.323    56.678    68.149     1.116     1.555
   118.317    56.678    70.745     1.443     2.014
   118.325    56.693    72.970     1.648     2.282
   118.326    56.682    71.779     1.271     1.615
   118.316    56.687    28.627     1.391     1.758
   117.704    56.287    58.023     0.978     1.657
   117.705    56.320    66.359     1.076     1.665
   117.704    56.299    65.603     1.301     2.390
   117.700    56.307    64.792     1.334     2.523
   118.601    56.028    58.036     1.866     2.823
   117.693    56.300    65.386     1.027     1.953
   117.692    56.313    59.927     1.011     1.824
   117.699    56.324    77.261     1.619     2.615
   118.294    56.664    65.024     1.495     2.207
   117.715    56.318    61.501     1.312     2.092
   117.689    56.316    64.171     1.288     2.330
   117.716    56.313    69.855     1.224     1.966
   117.719    56.282    63.964     1.625     2.742
   117.689    56.292    64.136     0.977     1.843
   117.681    56.334    63.447     1.041     2.335
   117.672    56.313    63.045     1.112     2.030
   117.673    56.310    65.138     1.184     2.125
   117.703    56.297    63.536     1.732     3.141
   116.405    56.237   -89.606     1.839     2.846
   117.724    56.306    55.690     0.946     1.396
   117.670    56.300    68.514     1.550     2.318
   117.704    56.328    67.144     1.142     2.036
   117.699    56.323    63.576     1.130     1.984
   117.697    56.278    65.703     0.913     1.762
   117.635    56.294    66.153     1.084     2.180
   117.688    56.323    66.010     1.297     2.516
   117.729    56.309    58.738     0.865     1.363
   117.735    56.316    64.331     1.158     2.067
   117.711    56.320    56.657     1.033     1.749
   117.736    56.314    62.806     0.965     1.739
   117.648    56.295    65.437     1.420     3.053
   117.661    56.301    64.516     0.972     1.727
   117.649    56.300    65.440     1.301     2.538
   117.751    56.306    64.890     1.328     2.489
   117.730    56.306    67.372     1.198     2.127
   117.733    56.318    65.474     1.185     2.029
   117.677    56.278    64.640     1.051     1.570
   117.674    56.296    55.764     1.645     2.831
   117.688    56.284    57.356     1.103     1.886
   117.634    56.302    57.149     1.514     2.451
   117.724    56.312    63.119     0.984     1.644
   117.660    56.312    64.112     1.250     2.188
   117.667    56.273    65.242     1.043     1.880
   117.633    56.299    67.449     1.190     2.244
   117.668    56.240    63.250     1.937     4.483
   117.707    56.204    56.539     2.443     4.076
   117.688    56.292    64.884     1.793     2.903
   117.695    56.301    63.539     1.348     2.327
   117.679    56.285    60.324     1.326     2.358
   117.636    56.306    69.527     1.098     2.029
   117.677    56.259    66.971     1.344     2.367
   117.650    56.279    65.957     1.383     2.643
   117.653    56.295    60.322     1.122     1.992
   117.664    56.277    64.278     1.542     2.915
   117.644    56.277    65.663     1.132     2.066
   117.661    56.286    58.701     1.090     1.819
   117.643    56.279    62.703     1.318     2.279
   117.656    56.282    65.572     1.160     2.144
   117.699    56.314    67.074     1.424     2.592
   117.637    56.280    64.744     1.377     2.482
   117.661    56.287    64.058     1.570     2.458
   117.649    56.280    64.679     1.443     2.679
   117.644    56.270    70.632     1.556     2.579
   117.650    56.281    65.787     1.355     2.603
   117.635    56.301    62.613     0.926     1.755
   117.631    56.297    61.329     1.018     1.687
   117.636    56.312    65.048     1.193     2.271
   117.675    56.314    66.012     1.025     2.003
   118.304    56.684    84.285     1.356     1.830
   117.655    56.293    65.721     1.007     1.889
   117.957    56.592    56.846     1.251     1.981
   117.735    56.322    66.700     1.184     2.090
   117.756    56.299    61.895     1.395     2.361
   118.290    56.677    40.504     1.780     2.510
   117.832    56.317    64.504     1.367     2.528
   117.704    56.320    63.535     0.947     1.709
   117.690    56.306    58.112     0.998     1.721
   117.669    56.291    66.673     1.003     1.902
   118.464    56.449   -74.437     2.379     4.527
   117.682    56.325    63.698     1.677     2.334
   117.644    56.328    66.088     1.404     3.549
   117.630    56.286    67.025     1.178     2.215
   118.287    56.672    68.112     1.336     1.973
   118.292    56.669    63.321     1.535     2.245
   117.659    56.302    61.966     1.137     1.925
   117.369    56.713    76.239     0.968     1.889
   117.347    56.699    74.715     1.118     2.866
   117.369    56.709    73.832     0.975     3.050
   117.347    56.706    71.572     1.250     2.406
   117.357    56.682    73.801     0.875     2.603
   117.342    56.706    74.265     0.950     2.589
   117.347    56.685    74.398     1.167     3.104
   118.323    56.687    67.562     1.582     2.328
   117.642    56.270    62.224     1.330     2.373
   117.636    56.300    60.326     1.238     2.204
   117.560    56.277    76.831     2.147     3.710
   117.140    56.089    74.056     1.626     2.436
   118.075    56.595    67.355     1.004     1.727
   117.475    56.347    69.061     1.217     2.255
   117.638    56.373    60.139     0.975     1.700
   117.272    56.682    70.703     0.830     1.638
   119.623    56.310   -83.108     2.107     2.958
   117.637    56.285    79.150     1.236     3.025
   117.366    56.660    76.595     1.392     3.211
   117.300    56.219    68.643     1.039     2.187
   117.313    56.214    69.985     1.984     3.969
   117.300    56.222    70.755     1.416     2.623
   117.271    56.211    62.907     2.019     3.895
   117.273    56.212    55.894     2.286     3.848
   117.296    56.203    63.227     1.693     3.214
   117.269    56.220    65.364     1.263     2.037
   117.316    56.228    69.054     1.226     2.214
   117.327    56.224    57.508     2.193     3.625
   117.313    56.192    79.463     2.161     3.915
   119.664    57.627    -2.658     2.718     3.467
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
   116.400    55.771    74.517     1.835     1.993
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
   116.422    55.771   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
   116.400    55.771     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
   116.400    55.771     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
   116.400    55.726   5 km
EOF
gmt end
