#!/bin/bash
gmt begin chamoli16.22_tt8_rdp_summary pdf,ps
proj=-JX18/12
reg=-R25/102/0/19
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1+l'Time Difference (s)' -BWeSn+t'Relative Depth Phase Summary chamoli16.22'
gmt plot $proj $reg -Wthick,green << EOF
    25.000     3.035
    26.000     3.039
    27.000     3.044
    28.000     3.051
    29.000     3.055
    30.000     3.058
    31.000     3.061
    32.000     3.064
    33.000     3.068
    34.000     3.073
    35.000     3.079
    36.000     3.084
    37.000     3.090
    38.000     3.095
    39.000     3.101
    40.000     3.107
    41.000     3.113
    42.000     3.119
    43.000     3.125
    44.000     3.131
    45.000     3.136
    46.000     3.142
    47.000     3.148
    48.000     3.154
    49.000     3.160
    50.000     3.165
    51.000     3.171
    52.000     3.177
    53.000     3.182
    54.000     3.188
    55.000     3.193
    56.000     3.198
    57.000     3.204
    58.000     3.209
    59.000     3.214
    60.000     3.219
    61.000     3.224
    62.000     3.229
    63.000     3.234
    64.000     3.239
    65.000     3.243
    66.000     3.248
    67.000     3.253
    68.000     3.257
    69.000     3.262
    70.000     3.266
    71.000     3.271
    72.000     3.275
    73.000     3.279
    74.000     3.284
    75.000     3.288
    76.000     3.292
    77.000     3.296
    78.000     3.300
    79.000     3.304
    80.000     3.308
    81.000     3.312
    82.000     3.316
    83.000     3.320
    84.000     3.324
    85.000     3.328
    86.000     3.331
    87.000     3.335
    88.000     3.341
    89.000     3.343
    90.000     3.344
    91.000     3.345
    92.000     3.346
    93.000     3.347
    94.000     3.348
    95.000     3.349
    96.000     3.350
    97.000     3.351
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     3.351  10
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000     6.068
    26.000     6.076
    27.000     6.086
    28.000     6.100
    29.000     6.109
    30.000     6.115
    31.000     6.121
    32.000     6.127
    33.000     6.135
    34.000     6.145
    35.000     6.156
    36.000     6.167
    37.000     6.178
    38.000     6.189
    39.000     6.201
    40.000     6.213
    41.000     6.225
    42.000     6.236
    43.000     6.248
    44.000     6.260
    45.000     6.272
    46.000     6.284
    47.000     6.295
    48.000     6.307
    49.000     6.318
    50.000     6.330
    51.000     6.341
    52.000     6.352
    53.000     6.363
    54.000     6.374
    55.000     6.385
    56.000     6.396
    57.000     6.406
    58.000     6.417
    59.000     6.427
    60.000     6.437
    61.000     6.447
    62.000     6.457
    63.000     6.467
    64.000     6.476
    65.000     6.486
    66.000     6.495
    67.000     6.504
    68.000     6.513
    69.000     6.523
    70.000     6.531
    71.000     6.540
    72.000     6.549
    73.000     6.558
    74.000     6.566
    75.000     6.575
    76.000     6.583
    77.000     6.591
    78.000     6.599
    79.000     6.607
    80.000     6.615
    81.000     6.623
    82.000     6.631
    83.000     6.639
    84.000     6.647
    85.000     6.655
    86.000     6.662
    87.000     6.669
    88.000     6.681
    89.000     6.685
    90.000     6.688
    91.000     6.690
    92.000     6.692
    93.000     6.693
    94.000     6.695
    95.000     6.697
    96.000     6.699
    97.000     6.701
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     6.701  20
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000     8.669
    26.000     8.682
    27.000     8.698
    28.000     8.721
    29.000     8.735
    30.000     8.744
    31.000     8.753
    32.000     8.763
    33.000     8.776
    34.000     8.792
    35.000     8.809
    36.000     8.827
    37.000     8.844
    38.000     8.862
    39.000     8.880
    40.000     8.899
    41.000     8.918
    42.000     8.936
    43.000     8.955
    44.000     8.974
    45.000     8.992
    46.000     9.011
    47.000     9.030
    48.000     9.048
    49.000     9.066
    50.000     9.084
    51.000     9.102
    52.000     9.120
    53.000     9.136
    54.000     9.154
    55.000     9.171
    56.000     9.188
    57.000     9.204
    58.000     9.221
    59.000     9.237
    60.000     9.253
    61.000     9.269
    62.000     9.285
    63.000     9.300
    64.000     9.315
    65.000     9.330
    66.000     9.344
    67.000     9.359
    68.000     9.373
    69.000     9.387
    70.000     9.401
    71.000     9.415
    72.000     9.429
    73.000     9.443
    74.000     9.456
    75.000     9.470
    76.000     9.483
    77.000     9.495
    78.000     9.508
    79.000     9.520
    80.000     9.533
    81.000     9.546
    82.000     9.558
    83.000     9.570
    84.000     9.582
    85.000     9.595
    86.000     9.607
    87.000     9.618
    88.000     9.636
    89.000     9.643
    90.000     9.647
    91.000     9.651
    92.000     9.654
    93.000     9.656
    94.000     9.658
    95.000     9.661
    96.000     9.664
    97.000     9.668
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     9.668  30
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    10.902
    26.000    10.921
    27.000    10.944
    28.000    10.976
    29.000    10.996
    30.000    11.010
    31.000    11.023
    32.000    11.037
    33.000    11.055
    34.000    11.079
    35.000    11.104
    36.000    11.129
    37.000    11.154
    38.000    11.180
    39.000    11.206
    40.000    11.233
    41.000    11.260
    42.000    11.286
    43.000    11.313
    44.000    11.340
    45.000    11.366
    46.000    11.393
    47.000    11.419
    48.000    11.446
    49.000    11.471
    50.000    11.497
    51.000    11.523
    52.000    11.548
    53.000    11.572
    54.000    11.596
    55.000    11.621
    56.000    11.645
    57.000    11.669
    58.000    11.692
    59.000    11.715
    60.000    11.738
    61.000    11.761
    62.000    11.783
    63.000    11.805
    64.000    11.826
    65.000    11.847
    66.000    11.868
    67.000    11.888
    68.000    11.909
    69.000    11.929
    70.000    11.949
    71.000    11.968
    72.000    11.988
    73.000    12.007
    74.000    12.026
    75.000    12.046
    76.000    12.064
    77.000    12.082
    78.000    12.100
    79.000    12.117
    80.000    12.135
    81.000    12.153
    82.000    12.171
    83.000    12.188
    84.000    12.205
    85.000    12.223
    86.000    12.239
    87.000    12.255
    88.000    12.280
    89.000    12.290
    90.000    12.297
    91.000    12.302
    92.000    12.305
    93.000    12.308
    94.000    12.311
    95.000    12.315
    96.000    12.320
    97.000    12.325
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    12.325  40
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000     4.289
    26.000     4.292
    27.000     4.296
    28.000     4.302
    29.000     4.305
    30.000     4.307
    31.000     4.310
    32.000     4.312
    33.000     4.315
    34.000     4.319
    35.000     4.323
    36.000     4.328
    37.000     4.332
    38.000     4.336
    39.000     4.341
    40.000     4.345
    41.000     4.350
    42.000     4.354
    43.000     4.359
    44.000     4.364
    45.000     4.368
    46.000     4.373
    47.000     4.377
    48.000     4.382
    49.000     4.387
    50.000     4.391
    51.000     4.395
    52.000     4.400
    53.000     4.404
    54.000     4.408
    55.000     4.412
    56.000     4.417
    57.000     4.421
    58.000     4.425
    59.000     4.429
    60.000     4.433
    61.000     4.437
    62.000     4.441
    63.000     4.445
    64.000     4.448
    65.000     4.452
    66.000     4.456
    67.000     4.459
    68.000     4.463
    69.000     4.466
    70.000     4.470
    71.000     4.473
    72.000     4.477
    73.000     4.480
    74.000     4.484
    75.000     4.487
    76.000     4.490
    77.000     4.493
    78.000     4.497
    79.000     4.500
    80.000     4.503
    81.000     4.506
    82.000     4.509
    83.000     4.512
    84.000     4.515
    85.000     4.518
    86.000     4.521
    87.000     4.524
    88.000     4.529
    89.000     4.531
    90.000     4.532
    91.000     4.533
    92.000     4.533
    93.000     4.534
    94.000     4.534
    95.000     4.535
    96.000     4.536
    97.000     4.537
    98.000     4.538
    99.000     4.539
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000     4.539  10
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000     8.577
    26.000     8.583
    27.000     8.591
    28.000     8.602
    29.000     8.609
    30.000     8.614
    31.000     8.618
    32.000     8.623
    33.000     8.629
    34.000     8.637
    35.000     8.646
    36.000     8.654
    37.000     8.663
    38.000     8.672
    39.000     8.681
    40.000     8.690
    41.000     8.699
    42.000     8.708
    43.000     8.717
    44.000     8.726
    45.000     8.736
    46.000     8.745
    47.000     8.754
    48.000     8.763
    49.000     8.772
    50.000     8.781
    51.000     8.790
    52.000     8.799
    53.000     8.807
    54.000     8.815
    55.000     8.824
    56.000     8.832
    57.000     8.841
    58.000     8.849
    59.000     8.857
    60.000     8.865
    61.000     8.873
    62.000     8.881
    63.000     8.888
    64.000     8.896
    65.000     8.903
    66.000     8.911
    67.000     8.918
    68.000     8.925
    69.000     8.932
    70.000     8.939
    71.000     8.946
    72.000     8.953
    73.000     8.960
    74.000     8.967
    75.000     8.973
    76.000     8.980
    77.000     8.986
    78.000     8.993
    79.000     8.999
    80.000     9.005
    81.000     9.012
    82.000     9.018
    83.000     9.024
    84.000     9.030
    85.000     9.037
    86.000     9.042
    87.000     9.048
    88.000     9.057
    89.000     9.061
    90.000     9.063
    91.000     9.065
    92.000     9.066
    93.000     9.067
    94.000     9.068
    95.000     9.070
    96.000     9.071
    97.000     9.073
    98.000     9.075
    99.000     9.077
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000     9.077  20
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    12.342
    26.000    12.352
    27.000    12.365
    28.000    12.382
    29.000    12.392
    30.000    12.400
    31.000    12.407
    32.000    12.414
    33.000    12.424
    34.000    12.437
    35.000    12.450
    36.000    12.464
    37.000    12.477
    38.000    12.491
    39.000    12.505
    40.000    12.520
    41.000    12.534
    42.000    12.549
    43.000    12.563
    44.000    12.578
    45.000    12.592
    46.000    12.607
    47.000    12.621
    48.000    12.635
    49.000    12.649
    50.000    12.664
    51.000    12.678
    52.000    12.691
    53.000    12.704
    54.000    12.718
    55.000    12.731
    56.000    12.744
    57.000    12.757
    58.000    12.770
    59.000    12.783
    60.000    12.795
    61.000    12.808
    62.000    12.820
    63.000    12.832
    64.000    12.844
    65.000    12.855
    66.000    12.867
    67.000    12.878
    68.000    12.889
    69.000    12.901
    70.000    12.912
    71.000    12.923
    72.000    12.933
    73.000    12.944
    74.000    12.955
    75.000    12.965
    76.000    12.976
    77.000    12.986
    78.000    12.996
    79.000    13.005
    80.000    13.015
    81.000    13.025
    82.000    13.035
    83.000    13.045
    84.000    13.054
    85.000    13.064
    86.000    13.073
    87.000    13.082
    88.000    13.096
    89.000    13.102
    90.000    13.105
    91.000    13.108
    92.000    13.110
    93.000    13.112
    94.000    13.114
    95.000    13.116
    96.000    13.119
    97.000    13.122
    98.000    13.125
    99.000    13.128
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    13.128  30
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    15.728
    26.000    15.743
    27.000    15.760
    28.000    15.785
    29.000    15.800
    30.000    15.810
    31.000    15.820
    32.000    15.831
    33.000    15.845
    34.000    15.863
    35.000    15.882
    36.000    15.901
    37.000    15.921
    38.000    15.940
    39.000    15.961
    40.000    15.981
    41.000    16.002
    42.000    16.022
    43.000    16.043
    44.000    16.063
    45.000    16.084
    46.000    16.104
    47.000    16.125
    48.000    16.145
    49.000    16.165
    50.000    16.185
    51.000    16.205
    52.000    16.224
    53.000    16.242
    54.000    16.261
    55.000    16.280
    56.000    16.299
    57.000    16.317
    58.000    16.335
    59.000    16.353
    60.000    16.371
    61.000    16.389
    62.000    16.406
    63.000    16.423
    64.000    16.439
    65.000    16.456
    66.000    16.472
    67.000    16.488
    68.000    16.504
    69.000    16.519
    70.000    16.535
    71.000    16.550
    72.000    16.565
    73.000    16.581
    74.000    16.596
    75.000    16.611
    76.000    16.625
    77.000    16.639
    78.000    16.653
    79.000    16.667
    80.000    16.681
    81.000    16.695
    82.000    16.709
    83.000    16.722
    84.000    16.735
    85.000    16.750
    86.000    16.762
    87.000    16.775
    88.000    16.795
    89.000    16.802
    90.000    16.807
    91.000    16.811
    92.000    16.814
    93.000    16.816
    94.000    16.819
    95.000    16.822
    96.000    16.826
    97.000    16.830
    98.000    16.834
    99.000    16.839
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    16.839  40
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.704     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.454     6.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.127     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.102     5.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.598     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.215     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.845     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.773     3.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.820     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.270     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.449     3.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.563     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.299     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.843     3.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.856     3.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.897     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.689     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.301     3.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.078     5.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.409     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.504     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    46.408     9.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.481    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.979     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.884     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.477     9.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.526     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.767     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.773     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.344     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.704     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.173     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.840     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    91.691    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.341     3.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.523     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.553     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.304     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.383     5.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.689     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.680     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.476     5.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.084     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.761     7.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.671     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.204     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.270     6.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.667    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.667     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.555     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.802     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.859     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.506     9.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.613     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.613     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.560     8.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.979     8.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.770     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    57.310     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.722    12.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.093     7.406     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.443     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.639     5.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.773     5.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.217     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.669     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.180     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    46.755    10.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.767     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.094     8.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.559    18.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.469     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.475     9.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.458     9.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.458     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.255    11.195     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.412     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.287     8.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.199     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.339     8.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.378     8.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.104     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.499     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.873     8.273     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.260     6.367     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.233     5.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.732     3.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    46.732     7.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.302     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.460     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.090     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.516     4.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.874     5.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.568     7.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.109     3.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.109     7.031     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.582     6.617     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.734     4.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.734     8.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.945     4.141     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.785     3.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.785     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.248     3.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.740     3.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.006     3.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    91.247     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    92.204     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    92.216     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    93.128     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.410     7.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.103     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.628     4.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.703    10.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.729    12.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.058    11.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.884    12.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.722    15.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.119    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.353    14.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    86.521    15.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.354     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.734     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.166     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.562     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.727     4.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.507     5.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.191     5.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.351     4.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.145     3.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.619     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.673     5.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.738     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.001     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.038     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.364     5.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.477     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.565     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.492     4.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.492     8.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.840     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    46.580    12.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.600    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.366    12.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.582    11.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.751    12.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    86.887    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.882     8.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.438     6.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.935     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.023     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.304     5.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.121     6.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.914     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.774     8.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.774     8.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.509     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.117     8.125     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.112     8.336     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.120     7.742     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.609     6.438     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.718     5.906     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.782     9.438     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.014     4.656     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.349     4.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.479     6.727     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.434     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.562     9.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.062     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.707     4.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.860     8.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.984     5.266     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.570     3.195     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.904     4.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.394     4.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.454     4.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.465     4.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.876     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.476     5.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.367     4.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.219     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.842     3.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    61.469     4.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.679     3.195     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.801     3.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.361     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.565     3.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.977     3.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.300     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.411     4.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.943     4.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.835    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.078    11.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.078    11.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.862     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.122     9.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.600    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.668    10.961     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.934    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.284    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.379    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.817     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.883     4.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.234     4.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.715     4.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.794     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.012     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.529     6.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.218     5.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.063     5.930     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.276     6.953     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.223     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.870     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.248     6.601     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.059     3.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.059     4.521     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.058     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.082    10.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.300     8.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.073    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.643     8.141     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.713     7.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.743     7.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.342     4.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    40.150    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.163    10.758     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.980     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.332     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.527     6.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.173    10.086     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.413    10.586     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.614     1.348     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.103     2.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.246     8.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.083     3.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.882     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.950     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.219     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.219     8.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.542     5.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.163    15.195     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.449    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.642    15.406     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.456    15.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.561    15.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.610    15.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.674    15.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.298    12.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.936    16.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.087     5.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.194     6.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.601     5.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.423     9.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.113     6.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.113     8.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.251     4.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.774     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.967     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.782     4.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.886     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.935     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.625     3.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.123     4.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.285     5.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.979     4.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.923     7.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    43.252     9.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.415     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.101     4.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.989     9.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.091     9.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.132     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.937     1.719     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.879     4.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.853     8.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    40.053    11.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.109    12.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.159    13.062     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.996     9.469     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.080     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.080     9.332     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.713     9.031     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.210     9.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.648     5.496     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.823     5.324     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.081     5.246     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.867     5.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.038     5.336     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.500     3.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.779     3.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.779     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.157     2.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.256     5.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.978     4.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.583     3.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.931     7.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.196     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.252     4.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.789     8.340     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.234    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.223    11.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.376     7.939     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    61.197    10.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.034    12.000     0.200
EOF
# Legend
gmt text $proj $reg -F+f12p,Helvetica,green+a0.+jBL << EOF
    26.000    17.860 Green for pP-P
EOF
gmt text $proj $reg -F+f12p,Helvetica,red+a0.+jBL << EOF
    26.000    16.720 Red for sP-P
EOF
gmt end
