#!/bin/bash
gmt begin chamoli16.22_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases chamoli16.22'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     3.477
     1.500    -0.364
     2.000    -4.204
     2.500    -8.045
     3.000   -11.885
     3.500   -15.726
     4.000   -19.569
     4.500   -23.414
     5.000   -27.260
     5.500   -31.109
     6.000   -34.960
     6.500   -38.812
     7.000   -42.668
     7.500   -46.526
     8.000   -50.388
     8.500   -54.252
     9.000   -58.120
     9.500   -61.993
    10.000   -65.868
    10.500   -69.748
    11.000   -73.633
    11.500   -77.521
    12.000   -81.416
    12.500   -85.315
    13.000   -89.219
    13.500   -93.129
    14.000   -97.045
    14.500  -100.967
    15.000  -104.895
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -86.219 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.489
     1.000     0.483
     1.500    -0.769
     2.000    -2.224
     2.500    -3.679
     3.000    -5.137
     3.500    -6.595
     4.000    -8.055
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -11.055 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.581    -2.566     0.200
     5.110     0.584     0.200
     5.110     4.983     0.200
    21.597    23.111     0.200
     5.561    -5.149     0.200
     3.178    -1.681     0.200
     8.121     2.403     0.200
     2.696    -2.473     0.200
     4.336    -2.447     0.200
     4.327    -1.916     0.200
     3.090    -2.643     0.200
     3.207    -2.769     0.200
     5.602    -5.691     0.200
     2.950    -1.402     0.200
     3.309     0.561     0.200
     3.300     1.241     0.200
     2.861    -3.144     0.200
     3.145     1.843     0.200
     2.776     2.765     0.200
     2.537    -1.706     0.200
     2.748    -1.395     0.200
     2.610    -2.571     0.200
     2.823    -2.333     0.200
     3.022    -2.636     0.200
     3.175    -2.902     0.200
     2.525    -0.770     0.200
     2.718    -1.402     0.200
     3.497    -1.584     0.200
     2.948    -3.277     0.200
     2.996    -2.084     0.200
     2.627     0.165     0.200
     2.560     0.198     0.200
     2.569     0.722     0.200
     3.136     1.268     0.200
     2.913    -3.192     0.200
     2.525    -2.021     0.200
     2.707    -1.592     0.200
     2.707    -1.893     0.200
     2.546    -2.418     0.200
     2.766    -1.155     0.200
     2.766    -1.756     0.200
     2.935    -1.232     0.200
     4.520    -1.668     0.200
     2.765    -1.794     0.200
     2.712    -1.279     0.200
     2.498    -1.773     0.200
     2.564     0.125     0.200
     2.690     0.136     0.200
     2.561    -2.443     0.200
     2.755    -1.096     0.200
     2.982     1.235     0.200
     2.744     0.025     0.200
     2.968    -0.218     0.200
     2.952    -1.690     0.200
     5.730    -6.996     0.200
     2.605    -1.048     0.200
     2.857    -1.032     0.200
     3.355     0.044     0.200
     2.947    -3.112     0.200
     2.558    -2.255     0.200
     2.775     0.739     0.200
     2.764    -1.725     0.200
     2.730    -2.970     0.200
     2.896     0.228     0.200
     3.145    -2.164     0.200
     2.769    -3.257     0.200
     2.969    -2.108     0.200
     3.103    -0.642     0.200
     6.759    -7.814     0.200
     2.651    -0.796     0.200
     2.835    -0.661     0.200
     3.077     0.652     0.200
     3.522    -0.808     0.200
     3.450    -2.875     0.200
     3.485     1.917     0.200
     3.883    -2.092     0.200
     4.134     0.132     0.200
     7.264    -2.103     0.200
     2.531    -0.252     0.200
     2.635    -1.952     0.200
     3.537     0.729     0.200
     3.678    -3.339     0.200
     5.032    -2.688     0.200
     3.524    -0.140     0.200
     3.927    -2.933     0.200
     4.503    -3.771     0.200
     4.897    -5.068     0.200
     3.007     1.909     0.200
     2.885    -2.236     0.200
     2.828    -1.430     0.200
     3.028    -2.619     0.200
     3.028    -2.340     0.200
     2.576    -1.194     0.200
     3.547    -2.872     0.200
     3.892    -0.611     0.200
     3.548    -2.311     0.200
     4.040    -3.024     0.200
     2.943    -0.313     0.200
     2.577    -3.098     0.200
     3.510    -2.975     0.200
     3.567    -1.730     0.200
     3.721    -3.348     0.200
     6.310    -7.099     0.200
     3.909     1.786     0.200
     2.745    -0.963     0.200
     2.703     0.246     0.200
     2.819    -1.863     0.200
     3.014     1.849     0.200
     3.844    -4.623     0.200
     3.374    -0.411     0.200
     2.716    -0.154     0.200
     2.716     0.065     0.200
     3.472     3.382     0.200
     3.275     1.385     0.200
     3.383    -1.094     0.200
     3.777    -4.388     0.200
     5.950    -7.439     0.200
     2.715    -2.897     0.200
     3.387     1.450     0.200
     2.668    -0.580     0.200
     3.048     1.357     0.200
     2.620    -1.662     0.200
     2.546    -1.431     0.200
     2.518     0.938     0.200
     3.635    -1.222     0.200
     2.738    -1.780     0.200
     3.282    -0.211     0.200
     5.876    -6.244     0.200
     2.517    -1.948     0.200
     3.165     0.300     0.200
     3.343    -1.800     0.200
     2.511    -1.888     0.200
     2.883    -1.441     0.200
     2.848    -0.939     0.200
     3.304    -1.800     0.200
     2.622     0.204     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     7.414   -48.674     0.200
    10.567   -68.625     0.200
    12.457   -90.552     0.200
    13.032   -90.770     0.200
    16.878  -126.685     0.200
    21.488  -147.809     0.200
     3.380   -17.096     0.200
     6.965   -37.754     0.200
     9.153   -61.116     0.200
     9.820   -63.247     0.200
    10.951   -70.095     0.200
    12.090   -84.193     0.200
    12.285   -87.391     0.200
    12.945   -87.317     0.200
    14.893  -109.059     0.200
    21.126  -141.660     0.200
     1.072     1.294     0.200
     2.581    -9.566     0.200
     7.612   -50.027     0.200
    13.095   -97.836     0.200
     2.799    -9.650     0.200
     5.535   -30.381     0.200
     8.268   -50.010     0.200
    10.128   -62.980     0.200
    11.494   -78.271     0.200
    12.258   -84.494     0.200
    13.165   -92.244     0.200
    14.116  -102.377     0.200
     2.669    -8.919     0.200
     6.146   -37.152     0.200
     3.032   -14.535     0.200
    11.910   -79.474     0.200
    12.878   -89.668     0.200
    14.398  -104.850     0.200
    14.565  -104.538     0.200
    18.538  -127.087     0.200
    10.020   -67.376     0.200
    12.154   -82.003     0.200
    12.536   -94.427     0.200
    12.806   -90.982     0.200
     3.163   -12.298     0.200
     4.600   -22.455     0.200
     4.646   -23.901     0.200
     4.851   -26.022     0.200
     5.078   -28.908     0.200
     9.092   -58.556     0.200
    11.797   -78.292     0.200
    12.083   -80.676     0.200
    12.867   -93.222     0.200
    12.888   -92.184     0.200
    12.888   -88.184     0.200
    13.464   -93.450     0.200
     6.484   -36.874     0.200
     6.524   -39.861     0.200
     6.444   -33.520     0.200
     6.733   -39.079     0.200
    13.401   -98.552     0.200
     2.843   -13.889     0.200
     8.026   -54.386     0.200
    11.305   -82.356     0.200
    12.585   -93.929     0.200
    13.278   -93.888     0.200
    13.730   -99.507     0.200
     0.959     2.282     0.200
     9.955   -64.398     0.200
    12.281   -86.936     0.200
    12.913   -88.164     0.200
     4.684   -25.734     0.200
     8.339   -51.692     0.200
     8.572   -54.701     0.200
    10.070   -70.162     0.200
    10.108   -69.767     0.200
    10.386   -69.492     0.200
    10.680   -73.898     0.200
    12.152   -75.472     0.200
    12.136   -74.963     0.200
    12.412   -87.905     0.200
    12.421   -87.999     0.200
    13.069   -93.253     0.200
    13.136   -88.362     0.200
    13.622   -99.785     0.200
    14.163  -102.918     0.200
    19.368  -141.929     0.200
    20.762  -141.104     0.200
     5.667   -31.452     0.200
     7.031   -41.093     0.200
    12.214   -83.387     0.200
    13.024   -90.566     0.200
     5.640   -30.046     0.200
     7.006   -39.716     0.200
    12.243   -85.748     0.200
    13.018   -94.811     0.200
    13.883  -101.724     0.200
    14.738  -102.334     0.200
     3.105   -10.849     0.200
     5.110   -27.416     0.200
     6.184   -36.060     0.200
     6.353   -34.829     0.200
     8.272   -50.637     0.200
     8.677   -53.489     0.200
     9.269   -54.744     0.200
     9.687   -64.512     0.200
    10.817   -69.836     0.200
    10.982   -72.571     0.200
    11.875   -79.367     0.200
    12.407   -88.923     0.200
    12.952   -89.005     0.200
    13.803  -101.696     0.200
    16.468  -120.476     0.200
     2.530   -10.150     0.200
     5.695   -31.953     0.200
     7.046   -43.080     0.200
    13.083   -96.477     0.200
     2.500    -7.568     0.200
     8.903   -56.569     0.200
    10.353   -63.528     0.200
    12.194   -83.885     0.200
    12.853   -93.771     0.200
    12.910   -88.585     0.200
    13.008   -94.681     0.200
    13.228   -96.654     0.200
    13.888  -102.473     0.200
     2.609    -9.746     0.200
     6.337   -37.933     0.200
     7.625   -47.751     0.200
     8.326   -52.981     0.200
    11.074   -72.007     0.200
    11.651   -79.882     0.200
    11.799   -80.388     0.200
     2.940   -13.872     0.200
     8.347   -53.489     0.200
    12.301   -84.429     0.200
    12.280   -91.168     0.200
    12.508   -88.281     0.200
    12.921   -89.493     0.200
    13.103   -89.248     0.200
    13.565   -95.412     0.200
    20.695  -142.910     0.200
     6.575   -38.716     0.200
     6.982   -40.589     0.200
    10.301   -63.622     0.200
    11.820   -77.965     0.200
    12.533   -79.562     0.200
    12.517   -79.053     0.200
    13.043   -91.748     0.200
    13.109   -88.844     0.200
    18.315  -132.873     0.200
     2.509    -7.175     0.200
     5.298   -30.085     0.200
     6.504   -38.298     0.200
    10.185   -66.002     0.200
    13.350   -97.614     0.200
     6.506   -39.493     0.200
    10.842   -72.928     0.200
    11.262   -76.255     0.200
    11.670   -80.184     0.200
    12.489   -81.153     0.200
    12.473   -80.644     0.200
    12.984   -93.844     0.200
    12.997   -91.062     0.200
    14.046  -103.520     0.200
    14.823   -96.638     0.200
     2.445    -9.165     0.200
     5.264   -28.009     0.200
     6.485   -35.742     0.200
     6.889   -40.521     0.200
     2.457    -7.925     0.200
     5.593   -30.245     0.200
    13.234   -94.947     0.200
    13.995  -101.097     0.200
    15.825  -114.089     0.200
     6.315   -37.573     0.200
     7.130   -43.610     0.200
    11.868   -80.810     0.200
     2.571   -11.826     0.200
     5.658   -33.197     0.200
     5.799   -32.554     0.200
     9.204   -62.607     0.200
    12.988   -95.547     0.200
    13.193   -96.040     0.200
     3.178   -15.181     0.200
    10.320   -66.084     0.200
    13.772   -91.538     0.200
    15.008   -94.692     0.200
    20.211  -134.638     0.200
     3.684   -12.848     0.200
     3.789   -15.672     0.200
     3.902   -16.053     0.200
     7.224   -46.177     0.200
     8.544   -56.206     0.200
    11.900   -81.878     0.200
    12.805   -92.098     0.200
     1.908    -3.483     0.200
     3.352   -11.470     0.200
     3.444   -13.383     0.200
     3.567   -13.673     0.200
     4.068   -18.342     0.200
     4.486   -21.021     0.200
     4.696   -23.518     0.200
     5.329   -27.370     0.200
     5.887   -33.121     0.200
     5.928   -33.527     0.200
     5.966   -29.532     0.200
     6.137   -33.592     0.200
     6.341   -36.384     0.200
     7.506   -48.728     0.200
     7.364   -43.999     0.200
     8.018   -48.059     0.200
     8.045   -49.599     0.200
    12.371   -88.151     0.200
    12.186   -84.290     0.200
    12.984   -92.289     0.200
     5.966   -33.071     0.200
     5.966   -29.821     0.200
     5.966   -30.251     0.200
     5.966   -31.837     0.200
     2.609    -9.477     0.200
     3.342   -14.190     0.200
     3.556   -15.798     0.200
     4.078   -20.953     0.200
     4.498   -23.280     0.200
     4.706   -25.393     0.200
     5.141   -28.920     0.200
     5.340   -29.475     0.200
     5.898   -34.879     0.200
     5.940   -35.196     0.200
     6.148   -36.418     0.200
     6.353   -37.954     0.200
     7.499   -48.702     0.200
     7.375   -46.647     0.200
     8.030   -50.320     0.200
     8.058   -50.979     0.200
     9.313   -59.985     0.200
    12.198   -87.942     0.200
    12.974   -92.818     0.200
    13.125   -96.823     0.200
    14.010  -101.901     0.200
     2.240    -4.900     0.200
     3.602   -14.367     0.200
     5.052   -25.953     0.200
     5.693   -30.112     0.200
     6.251   -36.456     0.200
     6.293   -34.925     0.200
     7.728   -48.918     0.200
    13.250   -95.110     0.200
    13.556   -99.134     0.200
     1.137     0.568     0.200
     2.575    -8.710     0.200
     3.565   -17.405     0.200
     5.029   -29.349     0.200
     5.743   -33.040     0.200
     6.079   -32.981     0.200
     7.396   -49.219     0.200
     7.396   -47.492     0.200
     9.101   -52.168     0.200
     9.208   -54.519     0.200
     9.258   -55.645     0.200
     9.322   -55.234     0.200
     9.338   -54.875     0.200
    10.006   -60.450     0.200
    10.730   -69.031     0.200
    12.087   -86.029     0.200
    12.259   -89.491     0.200
    12.931   -87.790     0.200
    13.188   -95.134     0.200
    14.884   -97.694     0.200
    15.742  -115.512     0.200
    17.595  -120.638     0.200
     3.613   -17.300     0.200
     3.729   -13.952     0.200
     7.325   -46.999     0.200
     3.511   -11.970     0.200
     6.123   -32.571     0.200
     8.475   -50.203     0.200
     8.559   -48.967     0.200
     9.189   -51.974     0.200
     9.197   -53.770     0.200
     9.213   -53.748     0.200
     9.263   -55.110     0.200
     9.291   -56.526     0.200
     9.326   -55.560     0.200
     9.341   -56.798     0.200
     9.524   -60.157     0.200
    11.208   -75.319     0.200
    12.826   -92.606     0.200
    13.853  -101.107     0.200
    14.949   -98.147     0.200
     1.135     2.493     0.200
     2.945    -9.804     0.200
     3.709   -13.103     0.200
    12.074   -84.769     0.200
    12.838   -90.519     0.200
    12.941   -92.758     0.200
     2.972   -10.634     0.200
     3.709   -13.502     0.200
     6.108   -32.368     0.200
     6.916   -40.966     0.200
     8.574   -47.537     0.200
     9.205   -53.789     0.200
     9.271   -54.470     0.200
     9.301   -52.941     0.200
     9.335   -54.934     0.200
     9.350   -55.287     0.200
     9.502   -60.761     0.200
    12.951   -93.094     0.200
     6.108   -32.782     0.200
     6.108   -32.782     0.200
     6.108   -32.782     0.200
     6.108   -33.649     0.200
     1.184     0.602     0.200
     3.544   -14.018     0.200
     3.091    -9.366     0.200
     3.575   -13.190     0.200
     1.153     0.804     0.200
     2.542    -6.543     0.200
     3.173   -11.040     0.200
     3.527   -12.761     0.200
    12.041   -88.651     0.200
     8.537   -49.967     0.200
     8.552   -51.084     0.200
     1.164     0.965     0.200
     1.137     2.722     0.200
     3.500   -12.187     0.200
     3.632   -13.867     0.200
     0.996     1.352     0.200
     1.147     0.625     0.200
     1.149     1.270     0.200
     3.624   -15.967     0.200
     3.654   -14.140     0.200
     3.739   -14.433     0.200
    12.045   -85.114     0.200
     1.104     0.910     0.200
     6.139   -33.096     0.200
     7.327   -47.563     0.200
     6.139   -33.463     0.200
     1.103     1.585     0.200
     1.354    -0.263     0.200
     3.449   -15.392     0.200
     3.479   -13.136     0.200
    13.113   -95.519     0.200
     1.301     0.110     0.200
     5.828   -31.000     0.200
     5.971   -32.835     0.200
     9.300   -58.524     0.200
     9.338   -56.114     0.200
     9.320   -58.486     0.200
    12.182   -86.010     0.200
    12.979   -94.283     0.200
     5.971   -32.538     0.200
     5.971   -31.350     0.200
     1.121     1.714     0.200
     1.174     2.041     0.200
     3.626   -12.170     0.200
     3.710   -13.054     0.200
     3.493   -11.869     0.200
     3.595   -15.496     0.200
     6.110   -32.707     0.200
     8.541   -48.299     0.200
     8.565   -49.807     0.200
     8.580   -51.453     0.200
     6.110   -32.613     0.200
     6.110   -33.504     0.200
     6.110   -33.668     0.200
     3.614   -16.202     0.200
     3.645   -13.668     0.200
     3.731   -13.208     0.200
     7.353   -52.226     0.200
    12.855   -91.640     0.200
    12.948   -94.562     0.200
    12.958   -94.890     0.200
    13.882   -99.189     0.200
     1.109     2.407     0.200
     2.635    -7.975     0.200
     3.540   -11.677     0.200
     0.960     2.911     0.200
     3.560   -12.505     0.200
     1.123     1.568     0.200
     1.061     2.537     0.200
     1.154     1.890     0.200
     2.478    -6.372     0.200
     3.497   -12.197     0.200
     1.262     0.452     0.200
     2.531    -6.754     0.200
     3.626   -12.961     0.200
    12.869   -91.988     0.200
    12.997   -95.034     0.200
     5.849   -30.249     0.200
     9.255   -54.690     0.200
     9.323   -57.739     0.200
     9.356   -54.029     0.200
     9.388   -55.827     0.200
     9.403   -56.835     0.200
     9.428   -60.594     0.200
    12.869   -92.989     0.200
     1.114     1.210     0.200
     3.583   -14.255     0.200
     3.485   -13.436     0.200
     3.698   -14.513     0.200
     7.340   -47.139     0.200
    12.835   -91.337     0.200
    12.941   -93.706     0.200
     3.931   -17.952     0.200
     4.560   -21.856     0.200
     5.212   -28.580     0.200
     6.019   -34.436     0.200
     6.591   -38.932     0.200
     7.165   -43.601     0.200
     7.906   -49.381     0.200
     8.570   -50.662     0.200
     9.347   -57.936     0.200
     9.361   -57.078     0.200
    12.835   -91.236     0.200
    12.952   -94.045     0.200
    13.864  -101.950     0.200
     1.128     2.528     0.200
     1.194     0.442     0.200
     1.188     0.453     0.200
     3.746   -14.229     0.200
     7.380   -47.855     0.200
    12.969   -95.608     0.200
     6.963   -42.209     0.200
     7.380   -47.855     0.200
     8.420   -46.450     0.200
     8.494   -47.701     0.200
     8.509   -49.548     0.200
     9.208   -55.269     0.200
     9.238   -54.309     0.200
     9.287   -57.510     0.200
    12.025   -83.681     0.200
    12.979   -95.930     0.200
     1.034     1.842     0.200
     1.154     0.723     0.200
     2.976   -14.729     0.200
     3.739   -16.915     0.200
    11.226   -73.185     0.200
    12.840   -94.067     0.200
    13.866  -103.305     0.200
     3.522   -13.942     0.200
     3.623   -15.938     0.200
     3.739   -16.415     0.200
     4.967   -29.847     0.200
     5.171   -27.872     0.200
     5.954   -33.533     0.200
     6.549   -38.550     0.200
     7.337   -48.696     0.200
     7.864   -48.992     0.200
     8.423   -46.757     0.200
     8.550   -47.949     0.200
     9.179   -54.883     0.200
     9.308   -54.812     0.200
     9.323   -55.380     0.200
     9.521   -63.220     0.200
     9.885   -67.839     0.200
     9.998   -62.044     0.200
    10.754   -69.310     0.200
    12.840   -94.091     0.200
    13.118   -96.236     0.200
    13.866  -101.788     0.200
     1.202     0.956     0.200
     1.188     1.190     0.200
     2.689   -10.394     0.200
     3.618   -14.944     0.200
     2.625    -6.036     0.200
     3.559   -10.945     0.200
     3.019   -13.136     0.200
     3.953   -18.192     0.200
     4.375   -20.113     0.200
     5.818   -32.738     0.200
     6.590   -39.031     0.200
     7.253   -45.792     0.200
     0.975     1.689     0.200
     1.464     1.044     0.200
     3.866   -18.226     0.200
     3.764   -14.545     0.200
     5.141   -28.186     0.200
     5.742   -32.049     0.200
     5.949   -34.300     0.200
     6.163   -34.316     0.200
     6.518   -38.283     0.200
     7.176   -42.773     0.200
     6.163   -33.929     0.200
     6.163   -33.929     0.200
     6.163   -32.601     0.200
     6.163   -35.371     0.200
     6.163   -33.027     0.200
     1.144     2.146     0.200
     2.964    -9.365     0.200
     1.137     3.209     0.200
     1.185     2.175     0.200
     2.628    -7.052     0.200
     1.143     1.538     0.200
     1.211     2.689     0.200
     6.056   -32.583     0.200
     6.056   -32.583     0.200
     6.056   -32.583     0.200
     6.056   -32.583     0.200
     2.688    -8.303     0.200
     3.595   -15.875     0.200
     3.716   -13.802     0.200
     3.917   -17.160     0.200
     5.184   -28.080     0.200
     5.784   -31.266     0.200
     7.219   -42.107     0.200
     7.875   -48.249     0.200
     1.181     1.814     0.200
     1.067     0.662     0.200
     2.730   -10.592     0.200
     3.715   -15.799     0.200
     7.367   -48.613     0.200
    11.240   -77.331     0.200
    12.867   -94.848     0.200
    13.894  -100.580     0.200
     3.498   -13.644     0.200
     3.597   -17.179     0.200
     6.110   -34.017     0.200
     6.114   -32.725     0.200
     7.367   -48.918     0.200
     9.247   -54.484     0.200
     9.311   -56.602     0.200
    10.226   -62.400     0.200
    11.240   -77.331     0.200
    12.061   -85.879     0.200
    12.974   -94.322     0.200
    13.151   -93.846     0.200
    13.894  -100.579     0.200
    21.198  -146.533     0.200
     6.114   -34.241     0.200
     6.114   -34.147     0.200
     1.070     0.991     0.200
     1.149     0.611     0.200
     1.188     0.388     0.200
     2.635    -7.680     0.200
     2.859   -11.310     0.200
     3.596   -17.151     0.200
     3.317   -14.114     0.200
     7.370   -47.964     0.200
    12.869   -92.624     0.200
    13.897  -102.780     0.200
     3.497   -14.120     0.200
     3.713   -15.079     0.200
     5.001   -28.695     0.200
     6.113   -32.865     0.200
     7.370   -47.159     0.200
     7.182   -42.737     0.200
     9.171   -53.858     0.200
     9.180   -54.786     0.200
     9.197   -54.633     0.200
     9.247   -57.513     0.200
     9.277   -57.113     0.200
     9.311   -57.905     0.200
     9.326   -57.685     0.200
     9.485   -60.841     0.200
    12.869   -92.625     0.200
    13.154   -94.347     0.200
     6.113   -33.669     0.200
     6.113   -33.943     0.200
     1.141     1.251     0.200
     1.143     1.896     0.200
     0.942     3.349     0.200
     1.220     1.213     0.200
     3.680   -16.359     0.200
     7.348   -50.669     0.200
     1.061     1.549     0.200
     2.755   -10.276     0.200
     3.738   -16.435     0.200
     5.747   -30.652     0.200
     7.369   -48.899     0.200
     8.767   -57.449     0.200
    11.257   -74.890     0.200
    12.036   -85.489     0.200
    12.873   -95.213     0.200
    13.899  -101.317     0.200
     2.755    -9.776     0.200
     3.072   -11.588     0.200
     3.072   -12.186     0.200
     3.003   -10.151     0.200
     3.522   -13.684     0.200
     4.323   -21.842     0.200
     4.475   -19.318     0.200
     4.998   -28.367     0.200
     5.167   -28.549     0.200
     5.747   -30.654     0.200
     5.723   -34.367     0.200
     5.768   -32.923     0.200
     5.974   -35.215     0.200
     5.963   -34.868     0.200
     6.187   -34.763     0.200
     6.133   -34.756     0.200
     6.544   -39.129     0.200
     7.369   -50.341     0.200
     7.207   -43.411     0.200
     7.860   -50.207     0.200
     8.384   -46.847     0.200
     8.397   -47.264     0.200
     8.490   -47.201     0.200
     8.525   -47.885     0.200
     8.767   -57.467     0.200
     9.069   -52.321     0.200
     9.148   -54.736     0.200
     9.157   -53.744     0.200
     9.223   -54.326     0.200
     9.253   -53.126     0.200
     9.287   -55.626     0.200
     9.302   -55.333     0.200
     9.499   -61.564     0.200
    11.198   -75.761     0.200
    11.257   -74.890     0.200
    12.971   -94.123     0.200
    13.140   -95.049     0.200
    13.899  -102.546     0.200
     3.580   -14.393     0.200
     3.301   -11.856     0.200
     3.697   -14.416     0.200
     7.374   -50.536     0.200
    12.871   -95.980     0.200
    13.165   -96.069     0.200
     3.292   -11.561     0.200
     3.481   -13.660     0.200
     4.364   -20.516     0.200
     4.435   -17.791     0.200
     5.208   -29.366     0.200
     5.764   -33.341     0.200
     5.922   -31.825     0.200
     6.016   -36.011     0.200
     6.092   -33.138     0.200
     6.585   -37.692     0.200
     7.166   -42.077     0.200
     7.901   -50.706     0.200
     9.104   -54.862     0.200
     9.183   -55.422     0.200
     9.260   -58.240     0.200
     9.291   -54.563     0.200
     9.339   -58.102     0.200
     9.474   -61.026     0.200
    10.239   -62.796     0.200
    12.871   -93.172     0.200
    12.984   -94.786     0.200
    13.165   -96.069     0.200
     0.852     2.013     0.200
     1.164     0.614     0.200
     1.130     1.373     0.200
     7.382   -48.414     0.200
     1.131     3.244     0.200
     1.190     0.677     0.200
     5.715   -31.322     0.200
     7.358   -48.938     0.200
     1.121     2.864     0.200
     1.170     1.306     0.200
     1.140     0.594     0.200
     1.140     1.797     0.200
     1.187     0.491     0.200
     1.144     3.225     0.200
     1.038     1.265     0.200
     1.214     0.219     0.200
     1.063     1.064     0.200
     1.129     1.313     0.200
     1.145     1.392     0.200
     1.191     0.432     0.200
     1.034     1.166     0.200
     1.244     1.284     0.200
     1.119     0.948     0.200
     0.969     0.790     0.200
     1.160     0.518     0.200
     2.374   -12.654     0.200
     2.496    -7.128     0.200
     2.771    -9.622     0.200
     3.651   -16.424     0.200
     3.766   -14.461     0.200
     4.549   -23.288     0.200
     4.745   -20.518     0.200
     7.305   -48.305     0.200
     8.726   -56.498     0.200
    12.811   -91.208     0.200
     2.771   -10.923     0.200
     3.548   -14.377     0.200
     5.954   -34.196     0.200
     6.528   -39.153     0.200
     7.305   -48.454     0.200
     7.182   -45.603     0.200
     7.231   -43.922     0.200
     8.675   -58.602     0.200
     9.168   -54.801     0.200
     9.168   -53.727     0.200
     9.176   -54.712     0.200
     9.192   -54.008     0.200
     9.240   -56.692     0.200
     9.240   -56.567     0.200
     9.304   -55.992     0.200
     9.304   -56.227     0.200
     9.318   -56.315     0.200
     9.318   -55.210     0.200
     9.557   -63.064     0.200
     9.852   -65.914     0.200
    12.811   -92.267     0.200
    13.082   -97.384     0.200
    13.025   -84.977     0.200
    13.837  -102.270     0.200
     1.058     0.829     0.200
     1.173     0.905     0.200
     3.612   -14.216     0.200
     0.948     3.148     0.200
     1.118     1.062     0.200
     3.672   -15.817     0.200
     7.343   -47.974     0.200
     1.148     0.525     0.200
     2.690    -8.767     0.200
     2.734    -9.638     0.200
     4.698   -19.405     0.200
     5.725   -31.969     0.200
     7.358   -49.099     0.200
    12.859   -94.459     0.200
    13.886  -102.240     0.200
     3.503   -13.433     0.200
     3.603   -14.088     0.200
     3.720   -16.596     0.200
     4.343   -20.886     0.200
     4.539   -22.085     0.200
     4.457   -21.265     0.200
     4.989   -28.144     0.200
     5.188   -29.460     0.200
     5.725   -31.970     0.200
     5.743   -33.864     0.200
     5.789   -33.458     0.200
     5.995   -34.501     0.200
     6.209   -38.126     0.200
     6.565   -39.027     0.200
     7.358   -49.688     0.200
     7.222   -45.774     0.200
     7.881   -51.248     0.200
     8.389   -49.180     0.200
     8.422   -46.992     0.200
     8.454   -50.401     0.200
     8.535   -48.150     0.200
     8.550   -49.009     0.200
     8.611   -52.721     0.200
     8.950   -52.509     0.200
     9.094   -56.437     0.200
     9.199   -54.049     0.200
     9.248   -53.984     0.200
     9.278   -54.890     0.200
     9.312   -55.361     0.200
     9.327   -55.627     0.200
     9.496   -62.019     0.200
     9.906   -67.235     0.200
    12.221   -88.383     0.200
    13.886  -103.590     0.200
     1.141     1.268     0.200
     1.133     0.845     0.200
     1.182     1.108     0.200
     1.105     1.690     0.200
     1.141     1.051     0.200
     1.129     0.552     0.200
     1.177     1.028     0.200
     1.145     1.271     0.200
     1.138     1.382     0.200
     1.186     0.671     0.200
     3.595   -13.890     0.200
     1.039     1.734     0.200
     1.101     1.044     0.200
     1.170     1.087     0.200
     3.632   -15.064     0.200
     1.504     0.994     0.200
     3.532   -14.307     0.200
     4.314   -21.825     0.200
     4.510   -23.149     0.200
     5.760   -32.004     0.200
     6.148   -31.877     0.200
     6.537   -39.821     0.200
     6.148   -33.881     0.200
     6.148   -33.881     0.200
     6.148   -35.467     0.200
     1.133     1.243     0.200
     3.595   -12.525     0.200
     3.644   -15.220     0.200
     5.738   -31.894     0.200
     1.156     2.211     0.200
     5.733   -31.751     0.200
     1.163     2.313     0.200
     1.164     2.466     0.200
     2.677    -8.983     0.200
     5.707   -32.078     0.200
    12.020   -83.270     0.200
    12.821   -91.956     0.200
     1.527    -1.840     0.200
     5.707   -32.080     0.200
     5.953   -35.838     0.200
     5.975   -33.520     0.200
     6.170   -37.560     0.200
     6.165   -30.884     0.200
     6.526   -39.300     0.200
     7.181   -46.508     0.200
     7.232   -43.160     0.200
     9.551   -62.994     0.200
    12.176   -86.190     0.200
    12.821   -91.637     0.200
    12.821   -91.957     0.200
    12.915   -94.636     0.200
     6.165   -34.509     0.200
     6.165   -34.509     0.200
     1.136     1.564     0.200
     5.706   -30.145     0.200
     3.604   -14.487     0.200
     5.514   -34.721     0.200
     5.706   -30.147     0.200
     5.935   -32.760     0.200
     6.119   -31.445     0.200
     6.927   -40.621     0.200
    12.838   -92.911     0.200
     1.160     2.211     0.200
     5.697   -31.817     0.200
     1.424     3.894     0.200
     2.581    -8.774     0.200
    13.595   -99.930     0.200
    13.757  -101.068     0.200
     3.949   -17.162     0.200
     4.142   -17.888     0.200
     6.759   -40.314     0.200
     7.153   -49.231     0.200
    12.639   -89.649     0.200
     1.213     4.097     0.200
     2.308    -9.823     0.200
     2.564    -8.400     0.200
     2.915    -9.084     0.200
     2.965    -8.835     0.200
     3.334   -11.544     0.200
     3.580   -13.163     0.200
     3.922   -18.486     0.200
     5.465   -29.152     0.200
     5.661   -30.406     0.200
     6.065   -32.911     0.200
     6.308   -37.613     0.200
     6.865   -40.984     0.200
     6.908   -41.010     0.200
     7.116   -43.429     0.200
     7.754   -53.997     0.200
     7.680   -46.772     0.200
     8.343   -52.861     0.200
     8.709   -53.728     0.200
     8.999   -56.958     0.200
     9.025   -58.111     0.200
     1.262     3.181     0.200
     2.651    -7.916     0.200
     4.783   -20.422     0.200
     7.400   -46.621     0.200
     1.135     3.560     0.200
     1.488     1.781     0.200
     2.382    -5.645     0.200
     2.468    -5.903     0.200
     2.828    -9.310     0.200
     2.828    -7.380     0.200
     4.932   -22.731     0.200
     6.388   -34.516     0.200
     6.943   -39.886     0.200
     6.989   -40.794     0.200
     7.195   -42.755     0.200
     7.764   -47.164     0.200
     7.692   -48.459     0.200
    12.948   -91.495     0.200
    14.036  -101.596     0.200
     1.070     3.478     0.200
     2.530    -8.823     0.200
     2.612    -9.405     0.200
     4.843   -23.250     0.200
     4.848   -24.791     0.200
     5.610   -30.866     0.200
     5.810   -31.390     0.200
     6.453   -37.530     0.200
     7.011   -42.748     0.200
     7.053   -43.685     0.200
     7.261   -46.673     0.200
     7.822   -49.089     0.200
     7.848   -56.017     0.200
     8.488   -56.808     0.200
     8.585   -55.441     0.200
     9.165   -62.246     0.200
    13.305   -96.374     0.200
     1.164     3.327     0.200
     1.500     0.963     0.200
     2.565   -11.603     0.200
     2.565    -8.603     0.200
     2.484    -6.545     0.200
     4.605   -23.504     0.200
     4.810   -25.023     0.200
     5.448   -30.889     0.200
     6.048   -36.283     0.200
     6.256   -37.533     0.200
     6.820   -41.713     0.200
     7.510   -52.473     0.200
     7.483   -47.399     0.200
     8.138   -52.390     0.200
     8.865   -62.931     0.200
    12.307   -88.944     0.200
    12.966   -93.811     0.200
     3.191    -9.968     0.200
     3.165   -12.645     0.200
     3.402   -11.851     0.200
     4.036   -17.937     0.200
     4.591   -22.554     0.200
     4.637   -23.006     0.200
     4.843   -24.021     0.200
     5.061   -25.640     0.200
     5.416   -28.388     0.200
     6.237   -35.505     0.200
     6.723   -40.795     0.200
     7.200   -46.345     0.200
     7.264   -40.527     0.200
     8.338   -49.111     0.200
     9.199   -57.610     0.200
    10.312   -65.204     0.200
    12.380   -88.457     0.200
    12.558   -90.903     0.200
    12.863   -91.570     0.200
     1.220     3.604     0.200
     2.793    -9.310     0.200
     3.342   -14.494     0.200
     3.684   -14.260     0.200
     3.875   -15.003     0.200
     4.266   -16.000     0.200
     4.530   -22.170     0.200
     5.083   -26.508     0.200
     5.133   -26.585     0.200
     5.336   -28.931     0.200
     5.560   -29.733     0.200
     5.920   -33.641     0.200
     6.564   -39.037     0.200
     7.161   -46.777     0.200
     7.226   -43.928     0.200
     7.272   -44.498     0.200
    11.413   -80.753     0.200
    11.996   -85.058     0.200
    12.635   -90.197     0.200
    12.641   -90.479     0.200
    16.817  -117.071     0.200
     1.239     6.098     0.200
     1.469     1.655     0.200
     2.394    -6.899     0.200
     3.153   -13.589     0.200
     3.537   -17.380     0.200
     3.620   -12.787     0.200
     5.032   -24.032     0.200
    16.165  -112.423     0.200
     2.277    -6.511     0.200
     3.253   -14.145     0.200
     3.409   -15.932     0.200
     3.551   -17.540     0.200
     4.635   -24.579     0.200
     6.327   -39.933     0.200
     6.783   -42.835     0.200
     7.279   -49.097     0.200
     8.125   -49.388     0.200
     8.373   -51.562     0.200
     9.126   -53.865     0.200
     3.240   -11.380     0.200
     4.220   -21.324     0.200
     4.515   -21.407     0.200
     5.070   -25.685     0.200
     5.117   -26.493     0.200
     5.322   -28.581     0.200
     5.542   -29.648     0.200
     5.897   -32.196     0.200
     6.549   -38.788     0.200
     6.597   -37.898     0.200
     6.886   -41.818     0.200
     7.205   -46.171     0.200
     7.210   -43.223     0.200
    11.393   -79.742     0.200
    13.799  -101.411     0.200
    14.999   -98.152     0.200
     1.083     1.853     0.200
     1.867    -5.085     0.200
     2.885   -10.306     0.200
     3.310   -16.217     0.200
     4.781   -28.104     0.200
     7.265   -48.951     0.200
    13.745   -98.986     0.200
     1.118     0.169     0.200
     2.627   -12.471     0.200
     2.798    -9.834     0.200
     2.828   -12.040     0.200
     3.028   -10.380     0.200
     3.459   -14.594     0.200
     4.465   -22.025     0.200
     5.307   -29.434     0.200
     5.793   -32.307     0.200
     5.865   -34.426     0.200
     5.907   -33.633     0.200
     5.983   -33.064     0.200
     6.115   -35.539     0.200
     6.319   -36.418     0.200
     6.678   -40.279     0.200
     7.404   -48.869     0.200
     7.499   -51.242     0.200
     7.499   -49.782     0.200
     7.997   -50.589     0.200
     8.783   -57.912     0.200
     9.330   -60.446     0.200
    10.048   -67.226     0.200
    12.165   -88.808     0.200
    13.039   -90.661     0.200
    13.119   -96.071     0.200
    13.119   -93.071     0.200
    14.014  -102.536     0.200
    14.341  -105.709     0.200
    15.589  -114.622     0.200
    16.356  -117.118     0.200
     1.055     1.424     0.200
     2.975   -10.162     0.200
     3.403   -12.723     0.200
     4.510   -22.100     0.200
     4.713   -23.254     0.200
     5.353   -30.233     0.200
     5.737   -33.103     0.200
     5.910   -33.694     0.200
     5.953   -34.857     0.200
     6.161   -34.832     0.200
     6.368   -36.615     0.200
     6.726   -39.860     0.200
     7.019   -39.827     0.200
     7.388   -45.441     0.200
     8.044   -50.431     0.200
     8.784   -60.304     0.200
    12.215   -89.750     0.200
    12.940   -91.739     0.200
    13.098   -95.752     0.200
     2.906    -9.146     0.200
     3.183   -11.482     0.200
     4.158   -17.177     0.200
     7.116   -43.715     0.200
     7.519   -48.652     0.200
    11.095   -76.055     0.200
     3.352   -15.289     0.200
     4.053   -16.726     0.200
     4.595   -22.282     0.200
     4.717   -27.137     0.200
     5.162   -26.777     0.200
     5.181   -28.181     0.200
     5.401   -29.535     0.200
     5.928   -34.150     0.200
     6.510   -36.996     0.200
     7.830   -54.323     0.200
     7.803   -45.484     0.200
     9.031   -54.239     0.200
    11.384   -82.907     0.200
    11.438   -78.864     0.200
    13.165   -96.661     0.200
    13.282   -98.068     0.200
    14.374   -92.882     0.200
    15.929  -113.637     0.200
    16.171  -116.117     0.200
     2.531    -9.894     0.200
     2.943    -9.731     0.200
     3.305   -15.409     0.200
     3.358   -12.678     0.200
     3.836   -16.638     0.200
     7.492   -48.730     0.200
    14.233  -100.704     0.200
    14.233  -100.728     0.200
    16.347  -116.055     0.200
     1.375    -1.687     0.200
     2.846   -14.086     0.200
     2.884   -10.720     0.200
     3.626   -18.275     0.200
    14.247  -103.832     0.200
    16.265  -116.773     0.200
     3.177   -11.273     0.200
     3.797   -15.022     0.200
     4.387   -20.834     0.200
     4.556   -23.236     0.200
     4.950   -24.270     0.200
     4.983   -25.407     0.200
     5.195   -27.052     0.200
     5.386   -29.499     0.200
     7.503   -47.586     0.200
     7.984   -48.843     0.200
     8.292   -55.910     0.200
     8.963   -57.580     0.200
     9.378   -60.038     0.200
    12.812   -93.914     0.200
    12.931   -93.960     0.200
    13.127   -94.167     0.200
    14.109  -102.404     0.200
    15.005  -110.259     0.200
    16.537  -119.644     0.200
     3.082   -12.581     0.200
     6.857   -44.642     0.200
     7.577   -51.783     0.200
    10.928   -75.508     0.200
    11.656   -82.268     0.200
    12.225   -89.645     0.200
    13.482   -98.395     0.200
    15.663  -113.834     0.200
     3.228   -13.647     0.200
     3.187   -12.853     0.200
     3.475   -16.093     0.200
     3.837   -16.868     0.200
     4.390   -21.876     0.200
     4.441   -22.297     0.200
     4.651   -23.270     0.200
     4.605   -25.015     0.200
     4.643   -23.813     0.200
     4.643   -23.513     0.200
     4.873   -25.693     0.200
     4.873   -25.491     0.200
     5.225   -28.554     0.200
     7.088   -46.203     0.200
     7.488   -50.958     0.200
     7.659   -52.387     0.200
     7.659   -50.217     0.200
     7.659   -49.067     0.200
     7.659   -48.678     0.200
     8.327   -47.724     0.200
     8.544   -54.664     0.200
     9.074   -57.062     0.200
    10.726   -77.847     0.200
    12.399   -88.885     0.200
    12.772   -93.709     0.200
    13.720  -100.861     0.200
    15.137   -98.355     0.200
    15.511  -112.724     0.200
     1.352     4.707     0.200
     1.614     0.086     0.200
     1.614     0.989     0.200
     2.613    -7.308     0.200
     3.571   -15.715     0.200
     3.571   -14.355     0.200
     3.571   -14.066     0.200
     2.467    -7.760     0.200
     2.489    -6.124     0.200
     3.661   -16.433     0.200
     5.426   -27.669     0.200
     5.550   -32.815     0.200
     6.071   -34.722     0.200
     6.301   -34.789     0.200
     6.628   -38.980     0.200
     6.671   -39.238     0.200
     6.879   -41.121     0.200
     7.085   -42.838     0.200
     7.678   -50.104     0.200
     9.308   -63.872     0.200
    13.753   -99.899     0.200
    16.149  -116.171     0.200
    16.149  -116.439     0.200
     2.819   -10.363     0.200
     2.990   -10.842     0.200
     3.362   -15.114     0.200
     3.858   -16.599     0.200
     4.283   -17.769     0.200
     4.510   -22.570     0.200
     4.401   -19.830     0.200
     5.064   -26.320     0.200
     5.113   -26.373     0.200
     5.316   -28.733     0.200
     5.539   -29.888     0.200
     5.893   -33.118     0.200
     5.945   -36.253     0.200
     9.649   -58.288     0.200
    11.391   -81.099     0.200
    12.009   -85.698     0.200
     1.029     0.019     0.200
     2.519    -9.734     0.200
     2.921   -10.732     0.200
     3.351   -15.019     0.200
     3.566   -17.229     0.200
     3.844   -20.903     0.200
     4.692   -25.926     0.200
     5.052   -30.015     0.200
     5.340   -30.062     0.200
     5.685   -32.412     0.200
     5.941   -34.314     0.200
     6.717   -40.295     0.200
     9.383   -66.907     0.200
    11.181   -80.080     0.200
    12.733   -92.867     0.200
    12.880   -96.674     0.200
    13.258   -99.179     0.200
    14.375  -107.729     0.200
    16.442  -122.316     0.200
    19.040  -136.656     0.200
    21.292  -147.346     0.200
     0.879     4.796     0.200
     2.042    -6.681     0.200
     3.232   -16.278     0.200
     4.162   -19.280     0.200
     4.916   -24.665     0.200
     4.947   -25.242     0.200
     5.708   -31.384     0.200
     7.540   -51.062     0.200
     8.122   -55.441     0.200
     9.326   -59.180     0.200
     9.326   -58.180     0.200
     9.872   -64.289     0.200
    11.186   -80.940     0.200
    11.910   -86.329     0.200
    12.359   -91.509     0.200
    12.820   -93.741     0.200
    12.957   -93.059     0.200
    14.662   -94.107     0.200
    16.514  -117.520     0.200
     2.056    -4.911     0.200
     2.926    -9.850     0.200
     2.926    -9.366     0.200
     3.419   -15.549     0.200
     3.762   -14.885     0.200
     4.074   -23.444     0.200
     4.342   -20.073     0.200
     4.906   -23.442     0.200
     4.936   -25.300     0.200
     5.141   -29.191     0.200
     5.150   -25.779     0.200
     5.336   -28.580     0.200
     5.697   -30.621     0.200
     7.548   -51.215     0.200
     8.116   -53.862     0.200
     8.761   -48.970     0.200
     9.312   -59.325     0.200
    12.366   -88.533     0.200
    13.178   -93.984     0.200
    16.509  -118.995     0.200
     2.855   -11.050     0.200
     3.018   -14.140     0.200
     3.169   -13.834     0.200
     3.314   -14.974     0.200
     3.694   -15.104     0.200
     4.238   -20.862     0.200
     4.356   -21.404     0.200
     4.448   -21.928     0.200
     4.907   -25.580     0.200
     4.960   -26.041     0.200
     5.162   -27.538     0.200
     5.391   -28.922     0.200
     5.744   -32.196     0.200
     5.957   -36.088     0.200
     6.725   -42.450     0.200
     7.087   -46.706     0.200
     7.952   -51.160     0.200
     8.030   -47.454     0.200
     8.297   -44.270     0.200
     9.606   -64.687     0.200
    11.911   -85.508     0.200
    12.530   -91.625     0.200
    12.713   -91.904     0.200
    13.692  -101.426     0.200
     2.617    -9.236     0.200
     3.188   -15.807     0.200
     3.220   -14.312     0.200
     3.361   -13.286     0.200
     4.570   -27.197     0.200
     4.906   -27.144     0.200
     7.192   -49.539     0.200
     7.300   -44.153     0.200
     8.379   -55.336     0.200
     9.166   -55.987     0.200
    10.873   -77.910     0.200
     2.885   -11.382     0.200
     3.356   -17.385     0.200
     3.706   -15.125     0.200
     4.268   -24.849     0.200
     4.361   -20.993     0.200
     4.435   -24.437     0.200
     4.914   -25.514     0.200
     4.964   -26.409     0.200
     5.167   -27.546     0.200
     5.393   -30.001     0.200
     5.746   -32.306     0.200
     5.992   -38.571     0.200
     6.767   -42.044     0.200
     7.131   -47.631     0.200
     7.750   -46.535     0.200
     7.974   -50.561     0.200
     8.340   -43.891     0.200
    13.454   -90.203     0.200
     2.444    -8.913     0.200
     2.659    -9.298     0.200
     2.890   -10.386     0.200
     3.191   -15.363     0.200
     3.755   -19.364     0.200
     0.958     2.096     0.200
     2.412    -9.146     0.200
     2.628    -9.289     0.200
     2.857   -11.063     0.200
     4.278   -20.782     0.200
     5.451   -31.886     0.200
     5.624   -29.066     0.200
     6.879   -41.631     0.200
     7.073   -42.879     0.200
     7.295   -44.416     0.200
     7.652   -47.658     0.200
     8.557   -53.544     0.200
     8.771   -55.931     0.200
     9.422   -68.246     0.200
     9.817   -71.740     0.200
    10.243   -73.269     0.200
    10.820   -77.888     0.200
    11.209   -72.877     0.200
    12.974   -95.442     0.200
    13.453   -97.126     0.200
    13.629   -99.730     0.200
    14.057  -102.989     0.200
    14.880   -98.982     0.200
    16.148  -117.806     0.200
    16.148  -117.865     0.200
    16.148  -114.575     0.200
    21.919  -151.914     0.200
     1.121     1.429     0.200
     1.504     1.238     0.200
     2.621    -7.716     0.200
     2.852    -8.032     0.200
     5.413   -31.202     0.200
     5.977   -32.504     0.200
     1.255     1.262     0.200
     3.497   -13.834     0.200
     3.848   -16.918     0.200
    16.388  -113.866     0.200
     2.754    -8.581     0.200
     3.259   -12.528     0.200
     3.302   -16.310     0.200
     3.580   -13.768     0.200
     3.881   -16.397     0.200
     4.135   -19.760     0.200
     4.543   -23.072     0.200
     5.095   -27.765     0.200
     5.336   -29.114     0.200
     5.348   -29.415     0.200
     5.576   -31.824     0.200
     5.929   -34.419     0.200
     6.575   -40.012     0.200
     7.123   -47.453     0.200
     7.239   -45.148     0.200
     7.288   -46.414     0.200
     8.321   -45.520     0.200
    12.608   -89.936     0.200
     2.716    -8.255     0.200
     2.844   -11.045     0.200
     3.015   -13.357     0.200
     3.176   -13.527     0.200
     3.670   -19.872     0.200
     3.849   -17.711     0.200
     4.225   -22.307     0.200
     4.498   -22.960     0.200
     5.052   -28.229     0.200
     5.100   -28.948     0.200
     5.292   -29.030     0.200
     5.304   -30.230     0.200
     5.525   -31.719     0.200
     5.880   -34.564     0.200
     5.970   -36.742     0.200
     6.532   -39.336     0.200
     7.196   -46.653     0.200
     7.192   -44.581     0.200
     7.236   -44.957     0.200
     7.880   -46.168     0.200
    12.667   -88.936     0.200
     2.871   -10.176     0.200
     3.460   -15.696     0.200
     4.506   -23.772     0.200
     5.262   -25.766     0.200
     6.406   -37.829     0.200
     6.785   -42.558     0.200
     7.080   -42.213     0.200
     7.432   -48.157     0.200
     7.998   -50.024     0.200
     8.099   -53.197     0.200
     9.397   -59.561     0.200
    10.488   -65.449     0.200
    11.801   -83.737     0.200
    12.750   -92.500     0.200
    12.855   -91.790     0.200
    13.058   -95.110     0.200
    13.474   -87.849     0.200
    14.769   -97.657     0.200
    15.055  -108.084     0.200
    16.607  -117.299     0.200
    16.607  -117.388     0.200
    18.400  -127.763     0.200
     1.159     6.748     0.200
     1.564     0.555     0.200
     3.571   -17.893     0.200
     3.754   -18.213     0.200
    11.992   -77.241     0.200
    16.095  -113.502     0.200
     3.206   -10.281     0.200
     3.405   -12.200     0.200
     4.052   -18.193     0.200
     4.605   -22.241     0.200
     4.858   -23.356     0.200
     5.436   -29.185     0.200
     6.085   -34.456     0.200
     8.327   -52.112     0.200
     8.361   -43.808     0.200
    12.795   -89.771     0.200
     2.646    -7.890     0.200
     2.627    -7.861     0.200
     2.983   -11.469     0.200
     3.228   -14.210     0.200
     3.228   -12.210     0.200
     3.474   -14.686     0.200
     3.779   -16.439     0.200
     3.796   -16.816     0.200
     3.970   -17.254     0.200
     4.290   -20.491     0.200
     4.664   -24.859     0.200
     5.193   -27.602     0.200
     5.247   -28.623     0.200
     5.435   -30.087     0.200
     5.448   -29.885     0.200
     5.680   -32.153     0.200
     6.032   -35.216     0.200
     6.674   -39.670     0.200
     6.808   -42.598     0.200
     7.340   -45.178     0.200
     7.394   -46.275     0.200
     7.750   -47.663     0.200
     8.264   -43.656     0.200
    12.583   -90.878     0.200
    13.337   -91.557     0.200
    15.061  -110.044     0.200
    15.061  -109.462     0.200
    16.874  -121.515     0.200
    16.874  -121.122     0.200
    20.627  -138.475     0.200
     4.251   -22.892     0.200
     7.156   -47.766     0.200
     7.788   -49.939     0.200
     8.237   -49.976     0.200
     9.314   -57.287     0.200
     2.724    -8.237     0.200
     3.156   -12.716     0.200
     3.359   -15.023     0.200
     3.652   -18.041     0.200
     3.836   -16.636     0.200
     3.908   -17.910     0.200
     4.208   -23.534     0.200
     5.042   -26.675     0.200
     5.091   -26.634     0.200
     5.283   -28.293     0.200
     5.295   -27.794     0.200
     5.295   -28.693     0.200
     5.872   -32.389     0.200
     6.522   -37.996     0.200
     7.167   -47.493     0.200
     7.184   -43.775     0.200
     7.230   -44.126     0.200
     7.891   -46.976     0.200
     8.101   -53.948     0.200
     8.369   -45.638     0.200
    11.371   -81.281     0.200
    12.617   -93.300     0.200
    13.347   -92.082     0.200
    16.821  -118.245     0.200
     1.278    -0.224     0.200
     1.924    -6.130     0.200
     2.127    -9.062     0.200
     2.348    -9.089     0.200
     3.113   -15.394     0.200
     6.466   -38.419     0.200
    10.430   -67.001     0.200
    11.516   -78.724     0.200
    12.657   -86.103     0.200
    12.861   -92.552     0.200
    12.862   -91.679     0.200
    12.876   -91.722     0.200
    12.999   -87.620     0.200
    13.748  -100.253     0.200
    15.349  -113.275     0.200
    16.565  -121.556     0.200
     0.912     0.499     0.200
     2.080    -7.658     0.200
     2.591    -9.863     0.200
     3.038   -13.189     0.200
     3.611   -18.579     0.200
     5.428   -29.784     0.200
     5.504   -29.192     0.200
     6.070   -34.956     0.200
     6.715   -41.971     0.200
     7.272   -45.554     0.200
     7.314   -46.262     0.200
     7.510   -46.876     0.200
     7.522   -47.076     0.200
     7.959   -53.373     0.200
     8.083   -52.747     0.200
     8.120   -50.927     0.200
     8.750   -58.182     0.200
     9.425   -64.582     0.200
     9.460   -59.889     0.200
    10.582   -74.185     0.200
    11.873   -79.200     0.200
    12.030   -84.257     0.200
    12.152   -85.438     0.200
    13.220   -97.449     0.200
    14.783   -95.030     0.200
    15.900  -115.344     0.200
    22.174  -153.142     0.200
     3.475   -12.712     0.200
     4.126   -18.871     0.200
     4.270   -18.557     0.200
     4.729   -23.193     0.200
     4.920   -25.727     0.200
     4.932   -25.424     0.200
     5.159   -26.912     0.200
     6.159   -35.029     0.200
     6.822   -39.939     0.200
     6.872   -40.407     0.200
     8.339   -46.934     0.200
     9.321   -61.336     0.200
     9.321   -57.430     0.200
    10.309   -73.167     0.200
    12.597   -94.530     0.200
    13.281   -99.305     0.200
    13.765  -103.681     0.200
    14.396  -107.722     0.200
    15.123  -113.343     0.200
    15.423  -112.543     0.200
    16.973  -120.086     0.200
    18.553  -129.495     0.200
    20.582  -140.130     0.200
     1.477     2.212     0.200
     3.018   -10.863     0.200
     3.073   -11.873     0.200
     3.390   -14.376     0.200
     3.485   -12.667     0.200
     4.140   -17.519     0.200
     4.259   -17.863     0.200
     4.400   -21.972     0.200
     4.655   -21.761     0.200
     4.692   -21.828     0.200
     4.946   -24.367     0.200
     5.174   -25.695     0.200
     6.173   -34.566     0.200
     6.836   -39.696     0.200
     6.887   -40.004     0.200
     8.323   -44.325     0.200
    10.310   -68.024     0.200
    16.983  -119.967     0.200
     3.270   -15.545     0.200
     3.404   -17.030     0.200
     3.464   -14.371     0.200
     3.849   -20.670     0.200
     4.117   -21.964     0.200
     4.281   -22.348     0.200
     4.422   -25.419     0.200
     4.669   -25.981     0.200
     4.720   -26.687     0.200
     6.150   -39.516     0.200
     6.813   -43.740     0.200
     7.108   -49.415     0.200
     8.332   -47.185     0.200
     9.315   -60.564     0.200
    15.098  -100.768     0.200
    20.581  -143.200     0.200
     1.367     1.167     0.200
     2.437    -8.883     0.200
     2.526    -8.581     0.200
     3.217   -15.843     0.200
     3.557   -16.289     0.200
     3.898   -20.890     0.200
     4.022   -17.304     0.200
     4.869   -25.755     0.200
     5.661   -30.976     0.200
     5.674   -31.776     0.200
     6.901   -41.061     0.200
     7.109   -47.421     0.200
     7.566   -46.159     0.200
     7.618   -45.505     0.200
    16.794  -123.262     0.200
     0.958     1.714     0.200
     2.497    -9.906     0.200
     2.905   -10.599     0.200
     3.326   -14.034     0.200
     3.810   -18.416     0.200
     4.156   -18.035     0.200
     4.786   -23.885     0.200
     5.434   -29.629     0.200
     5.989   -34.447     0.200
     6.035   -34.377     0.200
     6.228   -35.817     0.200
     7.468   -46.226     0.200
     8.126   -51.177     0.200
     8.160   -51.646     0.200
    12.627   -87.060     0.200
    16.407  -117.571     0.200
     3.109   -12.937     0.200
     3.133   -11.214     0.200
     3.397   -14.583     0.200
     3.523   -14.815     0.200
     3.523   -13.815     0.200
     3.785   -16.706     0.200
     4.045   -19.557     0.200
     4.337   -20.797     0.200
     4.393   -21.966     0.200
     4.389   -22.244     0.200
     4.630   -23.577     0.200
     4.612   -22.318     0.200
     5.818   -33.839     0.200
     6.482   -40.001     0.200
     6.537   -39.328     0.200
     7.071   -46.918     0.200
     7.434   -49.160     0.200
    10.578   -73.645     0.200
    10.676   -76.094     0.200
    10.852   -76.335     0.200
    10.923   -78.251     0.200
    11.518   -80.630     0.200
    12.129   -89.818     0.200
    12.367   -90.757     0.200
    12.369   -91.467     0.200
    12.394   -90.534     0.200
    12.760   -93.602     0.200
    13.495   -88.506     0.200
    13.517   -89.372     0.200
    13.786   -90.696     0.200
    13.884   -95.925     0.200
    13.909   -90.560     0.200
    15.164  -106.086     0.200
    15.159  -101.447     0.200
    15.494  -114.454     0.200
    20.025  -135.614     0.200
     2.903    -9.221     0.200
     3.151   -12.353     0.200
     4.033   -20.146     0.200
     4.012   -18.562     0.200
     4.156   -17.997     0.200
     4.584   -24.651     0.200
     4.951   -25.706     0.200
     5.151   -27.264     0.200
     5.353   -28.868     0.200
     7.512   -48.760     0.200
     7.794   -48.349     0.200
     8.115   -54.836     0.200
     9.344   -58.158     0.200
     9.344   -58.557     0.200
    11.194   -79.616     0.200
    11.432   -79.530     0.200
    11.471   -79.494     0.200
    12.201   -85.978     0.200
    12.655   -92.600     0.200
    12.757   -93.075     0.200
    12.930   -94.314     0.200
    12.931   -94.552     0.200
    13.036   -95.622     0.200
    13.140   -95.812     0.200
    13.026   -87.190     0.200
    13.195   -87.322     0.200
    13.195   -90.993     0.200
    13.341   -85.172     0.200
    13.716   -99.381     0.200
    13.717   -95.122     0.200
    14.390  -103.448     0.200
    16.489  -120.145     0.200
    16.538  -115.882     0.200
    18.319  -127.265     0.200
    20.346  -135.556     0.200
    20.433  -137.008     0.200
     3.223   -12.383     0.200
     3.586   -14.997     0.200
     1.112     0.496     0.200
     2.613   -11.398     0.200
     2.868   -10.507     0.200
     3.200   -11.011     0.200
     3.597   -16.219     0.200
     4.036   -19.136     0.200
     4.664   -24.240     0.200
     5.300   -29.287     0.200
     5.858   -33.767     0.200
     5.900   -34.095     0.200
     6.095   -35.191     0.200
     7.071   -41.721     0.200
     7.335   -45.598     0.200
     7.480   -51.935     0.200
     9.535   -60.725     0.200
    10.284   -65.196     0.200
    11.612   -82.943     0.200
    12.659   -86.405     0.200
    12.659   -88.015     0.200
    12.676   -93.885     0.200
    12.692   -89.520     0.200
    12.748   -87.978     0.200
    12.815   -82.813     0.200
    13.100   -95.856     0.200
    13.415   -99.099     0.200
    13.940  -104.581     0.200
    14.357  -102.743     0.200
    14.357  -102.292     0.200
    16.353  -119.361     0.200
    16.357  -119.599     0.200
    16.375  -116.672     0.200
    16.375  -120.479     0.200
    16.375  -118.979     0.200
    16.375  -118.979     0.200
    18.946  -132.583     0.200
    21.008  -142.638     0.200
     1.154     2.263     0.200
     3.184   -13.118     0.200
     3.362   -13.034     0.200
     5.584   -32.175     0.200
     6.612   -41.713     0.200
     0.961     1.941     0.200
     5.009   -26.778     0.200
     5.639   -31.851     0.200
     6.086   -32.421     0.200
     7.082   -43.110     0.200
     7.660   -47.606     0.200
     7.737   -50.260     0.200
     7.922   -51.013     0.200
     8.322   -54.317     0.200
     8.730   -55.139     0.200
     8.978   -58.107     0.200
     9.005   -58.066     0.200
     9.840   -68.702     0.200
     9.821   -61.163     0.200
    11.991   -84.604     0.200
    12.028   -81.876     0.200
    12.168   -80.822     0.200
    12.200   -80.295     0.200
    12.371   -83.033     0.200
    12.384   -82.772     0.200
    13.495   -92.684     0.200
    13.497   -96.490     0.200
    13.970  -102.205     0.200
    13.998  -101.941     0.200
    14.383  -104.548     0.200
    14.815  -106.019     0.200
    15.456  -106.538     0.200
    16.071  -111.588     0.200
    16.102  -112.436     0.200
    16.102  -113.835     0.200
    16.102  -113.834     0.200
    17.996  -120.642     0.200
    19.484  -132.338     0.200
    19.473  -135.372     0.200
     1.115     1.815     0.200
     2.755    -9.284     0.200
     3.180   -15.064     0.200
     3.203   -12.009     0.200
     3.380   -13.290     0.200
     3.474   -14.807     0.200
     4.013   -19.665     0.200
     4.370   -23.325     0.200
     4.569   -24.383     0.200
     4.562   -24.452     0.200
     4.614   -25.435     0.200
     4.807   -26.350     0.200
     5.038   -28.072     0.200
     6.047   -36.761     0.200
     6.707   -41.358     0.200
     7.198   -47.850     0.200
     8.428   -48.977     0.200
    10.329   -70.896     0.200
    12.365   -88.158     0.200
    12.551   -93.224     0.200
    12.664   -88.631     0.200
    12.864   -94.293     0.200
    16.934  -122.325     0.200
    20.009  -134.242     0.200
    20.204  -135.722     0.200
    20.442  -138.756     0.200
     1.076     1.390     0.200
     2.430   -10.021     0.200
     4.882   -27.338     0.200
     5.146   -29.425     0.200
     5.512   -31.210     0.200
     6.719   -40.558     0.200
     6.763   -41.157     0.200
     7.674   -52.507     0.200
     8.854   -58.838     0.200
     8.883   -58.452     0.200
     9.715   -68.560     0.200
     9.929   -63.478     0.200
    10.884   -78.347     0.200
    11.024   -71.055     0.200
    11.093   -72.506     0.200
    11.798   -86.594     0.200
    12.125   -82.123     0.200
    12.125   -83.013     0.200
    12.219   -88.931     0.200
    12.438   -86.206     0.200
    12.438   -85.671     0.200
    12.490   -88.104     0.200
    12.983   -95.140     0.200
    13.023   -91.173     0.200
    13.023   -96.201     0.200
    13.704  -100.087     0.200
    16.158  -114.623     0.200
    16.158  -113.111     0.200
    16.158  -113.114     0.200
    16.158  -114.169     0.200
     0.957     0.724     0.200
     5.005   -27.063     0.200
     5.635   -32.141     0.200
     7.081   -43.766     0.200
     7.093   -43.864     0.200
     7.659   -48.499     0.200
     7.907   -52.270     0.200
     8.321   -54.075     0.200
     8.549   -54.193     0.200
     8.745   -59.337     0.200
     8.977   -58.782     0.200
     9.834   -62.447     0.200
    10.336   -68.444     0.200
    12.132   -83.281     0.200
    12.225   -82.865     0.200
    12.389   -83.526     0.200
    13.146   -96.864     0.200
    16.120  -116.340     0.200
    16.120  -116.339     0.200
     0.802     1.533     0.200
     2.459    -8.845     0.200
     2.606    -8.737     0.200
     3.276   -17.284     0.200
     3.735   -19.543     0.200
     4.397   -21.773     0.200
     5.026   -25.127     0.200
     6.469   -37.457     0.200
     6.481   -37.559     0.200
     6.700   -38.289     0.200
     7.049   -43.342     0.200
     7.709   -49.063     0.200
     7.941   -51.197     0.200
    16.314  -116.297     0.200
     1.005     1.914     0.200
     2.590    -7.953     0.200
     2.886    -9.623     0.200
     3.740   -16.481     0.200
     3.794   -16.625     0.200
     4.258   -20.127     0.200
     4.637   -23.437     0.200
     5.195   -27.326     0.200
     5.237   -27.446     0.200
     5.432   -28.842     0.200
     5.445   -29.241     0.200
     5.652   -30.118     0.200
     6.010   -33.749     0.200
     6.672   -40.249     0.200
     7.327   -44.418     0.200
     7.359   -43.628     0.200
     4.113   -21.114     0.200
     7.589   -51.836     0.200
     8.128   -53.785     0.200
    11.120   -77.159     0.200
    11.498   -80.238     0.200
    11.541   -81.760     0.200
    12.243   -87.470     0.200
    12.729   -93.585     0.200
    12.475   -76.516     0.200
    13.000   -91.682     0.200
    13.092   -94.401     0.200
    13.547   -95.850     0.200
    13.781  -102.134     0.200
    14.265  -104.684     0.200
    14.453  -103.753     0.200
     3.297   -10.844     0.200
     3.818   -16.774     0.200
     3.812   -15.372     0.200
     4.249   -20.029     0.200
     4.447   -21.105     0.200
     5.094   -26.900     0.200
     5.649   -31.012     0.200
     5.695   -31.857     0.200
     5.888   -32.391     0.200
     5.901   -32.884     0.200
     6.115   -35.365     0.200
     6.471   -37.868     0.200
     7.128   -43.794     0.200
     7.345   -48.855     0.200
     7.787   -48.665     0.200
     7.823   -48.220     0.200
     8.695   -60.031     0.200
     9.556   -66.452     0.200
    10.138   -65.309     0.200
    12.861   -93.731     0.200
    12.861   -93.379     0.200
    16.532  -115.533     0.200
    21.135  -144.014     0.200
     0.949     2.750     0.200
     0.949     2.523     0.200
     2.472    -7.680     0.200
     4.141   -20.646     0.200
     4.771   -24.809     0.200
     5.423   -29.768     0.200
     6.024   -35.034     0.200
     6.217   -36.153     0.200
     6.800   -41.336     0.200
     7.404   -47.630     0.200
     7.404   -48.997     0.200
     7.457   -46.556     0.200
     8.116   -50.845     0.200
     8.152   -50.977     0.200
     8.896   -57.921     0.200
     8.998   -61.302     0.200
    16.437  -119.208     0.200
     6.901   -42.449     0.200
     7.179   -47.737     0.200
     8.233   -54.603     0.200
    13.250   -87.443     0.200
    16.775  -119.277     0.200
     2.831   -11.072     0.200
     3.165   -14.860     0.200
     3.238   -14.186     0.200
     4.082   -20.827     0.200
     4.639   -25.281     0.200
     4.877   -26.925     0.200
     4.889   -27.222     0.200
     5.459   -31.287     0.200
     6.117   -37.831     0.200
     6.813   -42.715     0.200
     9.221   -58.334     0.200
    10.753   -72.143     0.200
    10.954   -79.641     0.200
    20.042  -138.253     0.200
    20.256  -136.060     0.200
     2.409    -7.627     0.200
     8.692   -59.493     0.200
    16.123  -116.484     0.200
     1.416    -0.416     0.200
     1.507    -0.742     0.200
     2.906    -9.445     0.200
     3.321   -12.929     0.200
     3.800   -18.054     0.200
     4.206   -19.159     0.200
     4.638   -23.158     0.200
     4.836   -24.408     0.200
     4.836   -24.209     0.200
     4.836   -24.107     0.200
     5.116   -31.777     0.200
     5.483   -29.815     0.200
     5.773   -36.458     0.200
     6.039   -34.146     0.200
     6.083   -35.359     0.200
     6.083   -34.660     0.200
     6.083   -34.261     0.200
     6.277   -36.108     0.200
     6.290   -36.406     0.200
     6.501   -37.889     0.200
     6.858   -40.714     0.200
     7.425   -49.746     0.200
     7.457   -50.009     0.200
     7.517   -46.019     0.200
     8.175   -50.955     0.200
     8.175   -50.756     0.200
     8.207   -51.394     0.200
     9.067   -60.097     0.200
    10.009   -68.601     0.200
    12.348   -87.434     0.200
    12.469   -79.767     0.200
    12.586   -82.186     0.200
    12.586   -83.366     0.200
    12.666   -80.838     0.200
    12.675   -89.960     0.200
    12.904   -93.833     0.200
    13.266   -93.542     0.200
    13.469   -85.992     0.200
    13.702   -98.324     0.200
    14.216  -101.651     0.200
    14.347  -101.946     0.200
    14.875   -98.370     0.200
    15.021  -109.838     0.200
    16.686  -109.912     0.200
    18.049  -125.391     0.200
    19.098  -131.633     0.200
    19.638  -131.899     0.200
    19.645  -132.034     0.200
    19.933  -129.976     0.200
    20.197  -135.247     0.200
    20.465  -136.041     0.200
    20.587  -138.003     0.200
    20.691  -142.990     0.200
    20.798  -144.677     0.200
    20.892  -143.820     0.200
    21.000  -145.792     0.200
    21.019  -143.974     0.200
    21.038  -142.769     0.200
    21.103  -147.567     0.200
    21.216  -148.432     0.200
    21.199  -146.315     0.200
    21.252  -147.959     0.200
    21.265  -147.702     0.200
    21.446  -149.832     0.200
    21.590  -152.177     0.200
    22.149  -155.172     0.200
     1.411    -0.254     0.200
     2.548    -8.334     0.200
     2.548    -7.053     0.200
     3.441   -11.798     0.200
     5.708   -32.847     0.200
     7.453   -48.274     0.200
    12.565   -83.558     0.200
     1.214     1.113     0.200
     1.180     0.999     0.200
     1.358     0.239     0.200
     3.971   -17.411     0.200
     1.032     0.889     0.200
     1.178     1.584     0.200
     1.383     0.890     0.200
     1.116     1.161     0.200
     1.144     1.166     0.200
     1.226     1.366     0.200
     1.272     0.905     0.200
     1.307     0.989     0.200
     1.309     0.609     0.200
     1.373     0.765     0.200
     0.984     1.736     0.200
     1.139     1.048     0.200
     1.156     1.009     0.200
     1.208     0.975     0.200
     1.277     1.146     0.200
     1.140     1.551     0.200
     1.154     0.907     0.200
     1.261     0.772     0.200
     1.308     1.002     0.200
     1.390     0.614     0.200
     1.427     1.122     0.200
     1.441     1.682     0.200
     1.469     1.169     0.200
     1.536     0.331     0.200
     0.976     1.666     0.200
     1.419    -0.338     0.200
     1.511    -0.867     0.200
     2.549    -6.739     0.200
     2.960    -9.940     0.200
     3.855   -18.598     0.200
     4.198   -20.934     0.200
     4.623   -24.208     0.200
     4.826   -24.460     0.200
     5.466   -30.037     0.200
     5.709   -30.113     0.200
     6.023   -34.702     0.200
     6.066   -34.457     0.200
     6.273   -36.137     0.200
     6.838   -40.444     0.200
     7.503   -49.917     0.200
     7.501   -46.648     0.200
     8.156   -50.628     0.200
     8.186   -51.252     0.200
     8.870   -59.280     0.200
     8.870   -58.503     0.200
     9.070   -61.786     0.200
     9.266   -63.409     0.200
    10.055   -66.486     0.200
    12.559   -83.134     0.200
    12.648   -89.223     0.200
    13.234   -93.862     0.200
    14.077  -101.225     0.200
    14.188  -102.698     0.200
    16.337  -114.646     0.200
    18.021  -122.238     0.200
    21.156  -144.202     0.200
     1.432     0.968     0.200
     1.584     1.573     0.200
     1.226     1.520     0.200
     1.260     1.766     0.200
     1.082     1.824     0.200
     1.121     1.090     0.200
     1.233     1.165     0.200
     1.347     0.203     0.200
     1.393     0.523     0.200
     1.429     0.372     0.200
     1.419     0.615     0.200
     1.495     0.923     0.200
     2.505    -6.666     0.200
     2.914    -9.295     0.200
     3.457   -13.092     0.200
     5.448   -28.244     0.200
     5.666   -30.337     0.200
     6.255   -34.636     0.200
     6.466   -36.317     0.200
     6.823   -39.540     0.200
     7.482   -45.245     0.200
     8.173   -51.024     0.200
    10.002   -67.156     0.200
    10.002   -66.347     0.200
    12.608   -84.758     0.200
    16.391  -116.735     0.200
     1.076     1.541     0.200
     1.104     1.148     0.200
     1.109     1.347     0.200
     1.223     1.560     0.200
     1.331     0.901     0.200
     1.357     0.680     0.200
     1.414     0.854     0.200
     1.413     1.079     0.200
     1.480     0.589     0.200
     2.485    -6.801     0.200
     3.314   -12.812     0.200
     0.922     1.469     0.200
     1.070     0.834     0.200
     1.158     1.372     0.200
     1.218     1.327     0.200
     1.244     1.581     0.200
     1.249     1.628     0.200
     1.295     0.851     0.200
     1.492    -0.359     0.200
     1.097     1.078     0.200
     1.120     0.804     0.200
     1.325     0.716     0.200
     1.058     1.458     0.200
     1.195     1.314     0.200
     1.383     0.788     0.200
     1.006     1.376     0.200
     0.936     1.903     0.200
     1.110     1.646     0.200
     1.094     1.274     0.200
     1.099     1.253     0.200
     1.177     0.835     0.200
     1.212     1.457     0.200
     1.232     0.646     0.200
     1.322     0.845     0.200
     1.370     0.733     0.200
     1.405     0.686     0.200
     1.402     1.391     0.200
     1.471     0.385     0.200
     1.148     1.346     0.200
     1.309     1.255     0.200
     0.991     1.527     0.200
     1.013     1.244     0.200
     1.099     1.169     0.200
     1.113     1.827     0.200
     1.267     0.907     0.200
     1.287     0.989     0.200
     1.288     1.088     0.200
     1.338     0.915     0.200
     1.407     0.338     0.200
     0.944     0.963     0.200
     1.003     0.937     0.200
     1.073     1.305     0.200
     1.194     1.035     0.200
     1.206     1.365     0.200
     1.405     0.646     0.200
     1.071     1.093     0.200
     1.120     0.645     0.200
     1.210     0.625     0.200
     0.878     1.183     0.200
     1.321     1.578     0.200
     1.470     1.481     0.200
     2.499    -9.471     0.200
     2.585   -10.149     0.200
     4.980   -26.210     0.200
     5.310   -32.932     0.200
     5.624   -34.013     0.200
     5.823   -32.936     0.200
     6.618   -39.139     0.200
     6.630   -39.038     0.200
     6.835   -40.235     0.200
     7.194   -43.199     0.200
     7.617   -50.307     0.200
     7.858   -49.849     0.200
     8.539   -54.455     0.200
     9.000   -61.060     0.200
     9.137   -63.094     0.200
    10.171   -71.225     0.200
    10.171   -69.014     0.200
    12.307   -83.178     0.200
     3.134   -11.688     0.200
     5.418   -27.574     0.200
    16.199  -115.751     0.200
     1.379     1.184     0.200
     1.447     0.842     0.200
     1.179     1.545     0.200
     1.239     0.588     0.200
     1.275     1.013     0.200
     1.358     0.772     0.200
     1.519     0.446     0.200
     1.560     1.072     0.200
     1.334     1.393     0.200
     1.327     0.715     0.200
     1.544     1.115     0.200
     3.673   -12.742     0.200
     4.187   -16.825     0.200
     1.354     1.085     0.200
     1.421     0.983     0.200
     1.065     0.814     0.200
     1.112     1.301     0.200
     1.151     0.686     0.200
     1.230     0.656     0.200
     1.327     1.216     0.200
     1.344     0.482     0.200
     1.383     0.952     0.200
     1.424     0.596     0.200
     1.357     0.650     0.200
     1.355     0.739     0.200
     1.444     0.776     0.200
     1.461     0.304     0.200
     1.567     0.569     0.200
     1.610     0.577     0.200
     1.204     0.888     0.200
     1.211     0.936     0.200
     1.388     0.559     0.200
     1.116     1.179     0.200
     1.165     1.747     0.200
     1.217     1.030     0.200
     1.300     0.382     0.200
     1.365     0.902     0.200
     1.439     0.768     0.200
     1.561     0.546     0.200
     1.321     2.553     0.200
     2.390    -5.480     0.200
     3.010    -8.194     0.200
     3.191   -11.304     0.200
     3.745   -13.216     0.200
     1.216     0.738     0.200
     1.300     0.943     0.200
     1.079     1.116     0.200
     1.188     0.774     0.200
     1.243     0.289     0.200
     1.252     1.584     0.200
     1.274     1.106     0.200
     1.337     0.979     0.200
     1.497     1.447     0.200
     1.193    -0.059     0.200
     1.462    -0.845     0.200
     1.386     0.149     0.200
     1.457     0.195     0.200
     1.381     0.469     0.200
     1.513     0.991     0.200
     1.553     1.432     0.200
     1.565     1.060     0.200
     1.449     0.395     0.200
     1.519     0.709     0.200
     1.419     0.916     0.200
     1.539     0.361     0.200
     1.548     0.290     0.200
     1.664     0.890     0.200
     1.670     0.547     0.200
     0.868     1.344     0.200
     0.896     0.604     0.200
     1.130    -0.160     0.200
     1.247     0.961     0.200
     1.419     0.438     0.200
     1.490     1.483     0.200
     1.100     2.077     0.200
     1.134     1.595     0.200
     1.230     0.831     0.200
     1.348     2.237     0.200
     1.414     1.977     0.200
     1.493     1.223     0.200
     1.617     0.786     0.200
     0.973     1.535     0.200
     1.008     1.241     0.200
     1.264     1.426     0.200
     1.194     0.960     0.200
     1.215     1.099     0.200
     1.353    -0.048     0.200
     1.429     0.393     0.200
     1.329     0.932     0.200
     1.584     0.101     0.200
     1.651     0.237     0.200
     1.085     1.777     0.200
     1.093     1.333     0.200
     1.258     1.675     0.200
     1.264     0.362     0.200
     1.326     0.795     0.200
     1.094     0.548     0.200
     1.144     0.875     0.200
     1.239     0.632     0.200
     1.241     1.042     0.200
     1.272     0.058     0.200
     1.273     0.946     0.200
     1.354     0.361     0.200
     1.488    -0.972     0.200
     0.908     3.116     0.200
     3.127   -11.156     0.200
     7.666   -50.123     0.200
     0.793     0.921     0.200
     0.804     1.573     0.200
     0.862     0.706     0.200
     0.914     0.577     0.200
     1.132    -0.250     0.200
     1.152    -0.654     0.200
     1.285    -0.191     0.200
     1.263    -1.308     0.200
     1.305     0.504     0.200
     1.358     0.465     0.200
     1.558    -0.573     0.200
     1.551     0.178     0.200
     1.135     2.117     0.200
     1.277     1.581     0.200
     0.915     1.071     0.200
     1.034     0.588     0.200
     1.169     0.061     0.200
     1.363     0.439     0.200
     1.377     0.372     0.200
     1.438    -0.218     0.200
     1.496     0.220     0.200
     1.576    -0.281     0.200
     1.159     1.130     0.200
     1.305     1.251     0.200
     1.388     0.555     0.200
     1.453    -0.075     0.200
     1.150    -0.160     0.200
     1.235    -1.065     0.200
     1.418    -0.812     0.200
     1.115     1.139     0.200
     1.164     0.849     0.200
     1.168     1.264     0.200
     1.277     1.334     0.200
     1.360     0.943     0.200
     1.397     1.230     0.200
     1.400     1.034     0.200
     1.420     0.984     0.200
     1.440     0.846     0.200
     1.507     0.770     0.200
     1.141     0.654     0.200
     1.462    -0.166     0.200
     1.512    -0.241     0.200
     1.043     1.402     0.200
     1.134     1.376     0.200
     1.190     0.872     0.200
     1.213     0.784     0.200
     1.239     0.832     0.200
     1.322     0.677     0.200
     1.329     0.450     0.200
     1.386     0.608     0.200
     1.411     0.213     0.200
     1.437     0.317     0.200
     1.475     0.337     0.200
     1.137     1.718     0.200
     1.218     0.931     0.200
     1.307     0.540     0.200
     1.377     0.643     0.200
     1.098     1.172     0.200
     1.141     0.894     0.200
     1.126     0.839     0.200
     1.269     1.044     0.200
     1.320     0.245     0.200
     1.353    -0.370     0.200
     1.448    -0.102     0.200
     1.085     0.944     0.200
     1.442     0.426     0.200
     1.509    -0.116     0.200
     1.163     0.784     0.200
     1.201     0.548     0.200
     1.236     0.715     0.200
     1.332     0.146     0.200
     1.491     0.138     0.200
     1.310     0.479     0.200
     1.337     0.198     0.200
     1.458     0.345     0.200
     1.530     0.577     0.200
     1.200     3.684     0.200
     2.395    -5.892     0.200
     2.344    -5.509     0.200
     2.464    -6.658     0.200
     3.634   -15.131     0.200
     5.441   -27.503     0.200
     6.165   -34.911     0.200
     1.241     0.833     0.200
     1.307     0.519     0.200
     1.342     0.544     0.200
     1.425     0.119     0.200
     1.587    -0.133     0.200
     1.327     0.913     0.200
     1.353     0.625     0.200
     1.327     0.580     0.200
     1.345     0.463     0.200
     1.493     0.939     0.200
     1.530     0.274     0.200
     1.227     1.018     0.200
     1.465     0.988     0.200
     1.517     1.605     0.200
     1.602     1.000     0.200
     1.633     0.335     0.200
     1.287     1.202     0.200
     0.954     0.859     0.200
     1.118    -0.025     0.200
     1.340     1.942     0.200
     1.372     1.630     0.200
     1.412     1.442     0.200
     1.444     2.011     0.200
     1.593     2.027     0.200
     1.601     2.041     0.200
     1.725     2.151     0.200
     1.586     1.461     0.200
     2.474    -8.421     0.200
     2.545    -5.157     0.200
     2.712    -8.254     0.200
     2.888    -9.312     0.200
     3.056   -10.434     0.200
     3.735   -15.908     0.200
     1.424     1.361     0.200
     1.542     0.287     0.200
     1.570    -0.510     0.200
     0.978     5.511     0.200
     1.157     4.968     0.200
     2.667    -7.207     0.200
     3.148    -9.224     0.200
     1.275     0.862     0.200
     0.856     2.008     0.200
     0.978     1.499     0.200
     0.975     0.886     0.200
     0.998     1.261     0.200
     1.024     0.860     0.200
     1.020     1.286     0.200
     1.092     1.049     0.200
     1.083     0.824     0.200
     1.104     1.600     0.200
     1.160     0.940     0.200
     1.276     0.787     0.200
     1.378     0.381     0.200
     1.385     0.199     0.200
     1.004     1.238     0.200
     1.062     1.051     0.200
     1.064     2.500     0.200
     1.141     0.151     0.200
     1.127     0.863     0.200
     1.180     1.851     0.200
     1.194     0.726     0.200
     1.202     1.999     0.200
     1.284     0.475     0.200
     1.312     1.439     0.200
     1.335     1.679     0.200
     1.372    -0.144     0.200
     1.368     1.362     0.200
     1.433     0.943     0.200
     1.286     3.931     0.200
     1.325    -0.742     0.200
     1.416    -0.665     0.200
     4.121   -19.749     0.200
     4.244   -17.199     0.200
     4.750   -23.913     0.200
     4.750   -23.710     0.200
     5.045   -26.687     0.200
     5.403   -30.298     0.200
     5.958   -33.290     0.200
     6.004   -35.060     0.200
     6.004   -34.763     0.200
     6.004   -34.661     0.200
     6.197   -36.175     0.200
     6.424   -37.579     0.200
     6.781   -40.277     0.200
     7.437   -45.788     0.200
     8.096   -50.576     0.200
    12.673   -83.306     0.200
     1.292     0.869     0.200
     1.320     0.290     0.200
     1.394     0.223     0.200
     1.537    -0.402     0.200
     1.005     0.969     0.200
     1.085     0.747     0.200
     1.242     0.570     0.200
     1.318     0.706     0.200
     1.466     0.547     0.200
     1.131     0.842     0.200
     1.173     1.466     0.200
     1.462     0.657     0.200
     1.531     0.731     0.200
     1.590     0.752     0.200
     1.672    -0.511     0.200
     1.719     0.411     0.200
     1.656     2.290     0.200
     2.327    -4.689     0.200
     3.095    -8.296     0.200
     0.919     2.287     0.200
     1.054     1.182     0.200
     1.307     0.766     0.200
     1.487     0.507     0.200
     1.514     0.794     0.200
     1.228     2.512     0.200
     1.606    -0.236     0.200
     2.203    -4.578     0.200
     2.284    -4.932     0.200
     2.613    -6.725     0.200
     2.785    -8.177     0.200
     3.095   -10.918     0.200
     5.370   -26.431     0.200
     1.029     1.400     0.200
     1.204     1.005     0.200
     1.427     1.173     0.200
     1.214     1.560     0.200
     1.330     1.428     0.200
     1.375     1.667     0.200
     1.478     1.680     0.200
     1.347     1.243     0.200
     1.450     0.809     0.200
     1.495     0.811     0.200
     1.580     0.300     0.200
     1.646    -0.043     0.200
     1.671     0.207     0.200
     1.419     0.221     0.200
     1.516    -0.794     0.200
     1.540     1.099     0.200
     1.568    -0.116     0.200
     0.909     1.515     0.200
     0.988     1.206     0.200
     1.142     1.180     0.200
     1.189     0.449     0.200
     1.225     0.942     0.200
     1.309     0.323     0.200
     1.355    -0.316     0.200
     1.024     1.387     0.200
     1.104     1.369     0.200
     1.142     2.248     0.200
     1.166     1.218     0.200
     1.160     0.925     0.200
     1.239     1.171     0.200
     1.250     1.054     0.200
     1.286     1.832     0.200
     1.298     0.560     0.200
     1.335     1.496     0.200
     0.893     2.883     0.200
     1.083     1.280     0.200
     1.141     1.882     0.200
     1.196     1.164     0.200
     1.212     0.590     0.200
     1.252     1.170     0.200
     1.313     0.807     0.200
     1.446     1.369     0.200
     1.453     0.482     0.200
     1.529     0.179     0.200
     1.295     0.973     0.200
     1.535     0.692     0.200
     1.596     0.485     0.200
     0.921     1.824     0.200
     1.107     1.669     0.200
     1.219     1.168     0.200
     1.412     0.490     0.200
     1.420    -0.315     0.200
     1.091     0.675     0.200
     1.184     0.640     0.200
     1.444     1.296     0.200
     1.341     0.625     0.200
     1.463     0.923     0.200
     1.488     0.088     0.200
     1.604     0.752     0.200
     1.162     1.495     0.200
     1.254     0.807     0.200
     1.345     0.504     0.200
     1.418     1.179     0.200
     1.421     0.743     0.200
     1.454     0.047     0.200
     1.532     0.769     0.200
     0.921     0.714     0.200
     0.977     0.369     0.200
     1.020     0.073     0.200
     1.249    -0.306     0.200
     1.219     1.737     0.200
     1.491     1.044     0.200
     1.514     1.627     0.200
     0.826     1.763     0.200
     0.947     1.026     0.200
     0.991     1.121     0.200
     1.044     0.746     0.200
     1.070     0.267     0.200
     1.075     0.949     0.200
     1.118     0.714     0.200
     1.139     1.150     0.200
     1.216     0.671     0.200
     1.246     0.795     0.200
     1.336     0.821     0.200
     1.454     0.453     0.200
     1.450     0.407     0.200
     1.325     1.928     0.200
     3.339   -12.840     0.200
     3.791   -15.371     0.200
     1.189     1.692     0.200
     1.440     0.898     0.200
     1.560     0.467     0.200
     1.587     0.747     0.200
     1.449     1.373     0.200
     1.507     0.864     0.200
     0.925     1.528     0.200
     1.128     1.096     0.200
     1.146     1.297     0.200
     1.196     0.597     0.200
     1.217     1.190     0.200
     1.229     1.385     0.200
     1.365     0.935     0.200
     1.433     0.681     0.200
     1.403    -0.552     0.200
     2.531    -8.889     0.200
     3.409   -12.730     0.200
     3.484   -12.832     0.200
     1.098     0.773     0.200
     1.288     1.833     0.200
     1.451     0.287     0.200
     1.493    -0.350     0.200
     1.298     0.986     0.200
     1.379     1.141     0.200
     1.418     1.411     0.200
     1.515     0.727     0.200
     1.573     0.814     0.200
     1.603     0.747     0.200
     0.974     1.479     0.200
     1.060     1.370     0.200
     1.083     0.809     0.200
     1.090     1.665     0.200
     1.249     1.559     0.200
     1.294    -0.375     0.200
     1.414     0.653     0.200
     2.966   -10.324     0.200
     2.977   -10.051     0.200
     3.403   -12.964     0.200
     3.525   -14.529     0.200
     4.129   -19.067     0.200
     4.370   -21.927     0.200
     4.464   -21.018     0.200
     4.758   -27.811     0.200
     4.925   -26.397     0.200
     4.973   -26.819     0.200
     5.164   -28.298     0.200
     5.177   -28.698     0.200
     5.398   -27.705     0.200
     5.915   -36.202     0.200
     6.147   -35.885     0.200
     6.404   -38.505     0.200
     6.376   -38.454     0.200
     6.847   -43.155     0.200
     7.065   -43.152     0.200
     7.182   -46.769     0.200
     7.905   -52.322     0.200
     8.002   -50.903     0.200
     8.036   -52.900     0.200
     8.738   -57.716     0.200
     8.391   -46.766     0.200
     9.701   -63.838     0.200
    10.920   -76.060     0.200
    11.250   -77.913     0.200
    12.806   -91.016     0.200
    16.839  -119.152     0.200
     1.257     1.404     0.200
     1.337     2.000     0.200
     1.065     1.226     0.200
     1.081     2.002     0.200
     1.136     1.580     0.200
     1.207     1.841     0.200
     1.080     2.023     0.200
     1.271     2.013     0.200
     1.287     0.416     0.200
     1.295     2.731     0.200
     1.313     0.718     0.200
     1.380     1.252     0.200
     2.588    -6.620     0.200
     3.068    -9.442     0.200
     3.359   -11.813     0.200
     3.524   -14.669     0.200
     3.582   -14.026     0.200
     1.154     0.995     0.200
     1.205     0.718     0.200
     1.219     0.859     0.200
     1.257     0.719     0.200
     1.297     1.058     0.200
     0.882     1.636     0.200
     1.045     0.704     0.200
     1.055     0.762     0.200
     1.110     0.566     0.200
     1.180     0.248     0.200
     1.416     0.594     0.200
     1.509     0.281     0.200
     1.072     1.136     0.200
     1.227     0.582     0.200
     1.264     0.880     0.200
     1.305     0.638     0.200
     1.372     0.346     0.200
     1.214     1.596     0.200
     1.254     0.701     0.200
     1.268     0.654     0.200
     1.308     0.570     0.200
     1.433     1.051     0.200
     1.507     0.260     0.200
     1.530     0.807     0.200
     1.533    -0.163     0.200
     1.197     0.689     0.200
     1.260     0.535     0.200
     1.294     1.085     0.200
     1.343     0.962     0.200
     1.452     1.035     0.200
     1.527     0.879     0.200
     1.533    -0.091     0.200
     1.535     0.556     0.200
     3.923   -17.009     0.200
     4.860   -24.877     0.200
     1.038     1.514     0.200
     1.116     0.835     0.200
     1.152     0.568     0.200
     1.237     0.828     0.200
     1.309    -0.640     0.200
     1.346     0.258     0.200
     1.413     0.503     0.200
     1.028     1.442     0.200
     1.106     1.776     0.200
     1.141     1.506     0.200
     1.160     0.400     0.200
     1.171     0.511     0.200
     1.175     1.331     0.200
     1.245     0.927     0.200
     1.296     1.073     0.200
     1.299    -0.113     0.200
     1.336    -0.029     0.200
     1.331     1.388     0.200
     1.403     0.591     0.200
     0.829     1.862     0.200
     0.957     0.606     0.200
     1.008     1.388     0.200
     1.046     1.153     0.200
     1.052     0.313     0.200
     1.042     0.518     0.200
     1.122     0.187     0.200
     1.184    -0.468     0.200
     1.222     0.987     0.200
     1.223    -0.527     0.200
     1.231    -0.401     0.200
     1.289     0.450     0.200
     1.309    -0.375     0.200
     1.301     0.759     0.200
     1.319     0.520     0.200
     1.358     0.053     0.200
     1.373     0.001     0.200
     1.451     3.065     0.200
     4.110   -18.652     0.200
     4.402   -21.850     0.200
     5.803   -33.749     0.200
     5.845   -34.780     0.200
     6.040   -34.573     0.200
     6.053   -35.375     0.200
     6.259   -38.401     0.200
     6.617   -40.451     0.200
     7.280   -46.080     0.200
     7.935   -51.546     0.200
     7.964   -51.461     0.200
    12.696   -87.153     0.200
    12.696   -88.286     0.200
    16.393  -116.767     0.200
     0.843     1.652     0.200
     0.958     1.073     0.200
     1.050     1.387     0.200
     1.050     0.741     0.200
     1.048     0.784     0.200
     1.135     0.511     0.200
     1.182    -0.178     0.200
     1.227     0.281     0.200
     1.232     0.700     0.200
     1.219     0.444     0.200
     1.292     0.473     0.200
     1.312    -0.022     0.200
     1.331     0.304     0.200
     1.362    -0.016     0.200
     1.382    -0.244     0.200
     0.961     1.294     0.200
     1.052     2.117     0.200
     1.053     0.842     0.200
     1.052     1.235     0.200
     1.190     0.359     0.200
     1.141     0.904     0.200
     1.232    -0.066     0.200
     1.219     1.624     0.200
     1.235     0.104     0.200
     1.297     0.036     0.200
     1.316     1.230     0.200
     1.336     1.353     0.200
     1.366     0.241     0.200
     1.384     0.679     0.200
     1.256     0.540     0.200
     1.362     0.245     0.200
     1.016     1.042     0.200
     1.025     0.956     0.200
     1.034     1.090     0.200
     1.118     1.126     0.200
     1.137     0.456     0.200
     1.201     1.189     0.200
     1.220     0.764     0.200
     1.281     0.682     0.200
     1.274     1.109     0.200
     1.307     0.882     0.200
     1.355     1.223     0.200
     1.423     0.420     0.200
     1.330    -0.194     0.200
     1.335     1.473     0.200
     1.382     0.999     0.200
     1.248     0.693     0.200
     1.471     0.504     0.200
     1.380     0.198     0.200
     1.411     0.794     0.200
     1.623     1.298     0.200
     1.627     1.836     0.200
     1.095     0.887     0.200
     1.275    -0.297     0.200
     1.296     1.055     0.200
     1.375     0.900     0.200
     1.576     0.618     0.200
     1.613     0.482     0.200
     1.642     0.468     0.200
     1.223     5.030     0.200
     2.717    -7.651     0.200
     3.157    -9.938     0.200
     3.789   -16.092     0.200
     3.880   -16.444     0.200
     4.249   -19.384     0.200
     4.774   -24.240     0.200
     5.034   -23.354     0.200
     7.687   -47.853     0.200
     9.782   -63.465     0.200
    13.967   -90.904     0.200
    16.871  -120.389     0.200
     1.589     0.238     0.200
     1.207     1.320     0.200
     1.422     0.715     0.200
     1.591     0.749     0.200
     1.212     1.094     0.200
     1.310     1.338     0.200
     1.087     1.183     0.200
     1.234     1.121     0.200
     1.238     1.012     0.200
     1.310     0.343     0.200
     1.238     1.762     0.200
     1.234     1.730     0.200
     1.319     0.905     0.200
     1.396     1.158     0.200
     1.451     0.786     0.200
     1.601     0.885     0.200
     0.973     2.711     0.200
     1.014     1.841     0.200
     1.121     0.063     0.200
     1.218     5.292     0.200
     3.803   -13.217     0.200
     1.621     0.807     0.200
     1.627    -0.033     0.200
     2.943    -9.107     0.200
     1.364     0.630     0.200
     1.403    -0.107     0.200
     1.311     1.252     0.200
     1.608     0.951     0.200
     3.694   -16.483     0.200
     3.913   -15.255     0.200
     4.356   -20.300     0.200
     4.789   -27.100     0.200
     1.211     1.450     0.200
     2.079    -5.308     0.200
     3.789   -15.044     0.200
     4.249   -17.663     0.200
     1.210     1.002     0.200
     1.308     0.985     0.200
     1.440     0.934     0.200
     1.456     0.819     0.200
     1.589     1.107     0.200
     1.625     1.160     0.200
     1.655     0.756     0.200
     3.802   -14.187     0.200
     1.097     0.998     0.200
     1.175     0.453     0.200
     1.248     0.232     0.200
     1.289     0.008     0.200
     1.394    -0.108     0.200
     1.317     1.284     0.200
     1.352     1.071     0.200
     1.393     1.452     0.200
     1.550     1.295     0.200
     1.564     1.187     0.200
     1.091     1.485     0.200
     1.199     0.945     0.200
     1.192     1.448     0.200
     1.246     0.781     0.200
     1.281     0.927     0.200
     1.346     0.595     0.200
     1.060     1.764     0.200
     1.124     1.150     0.200
     1.184     0.647     0.200
     1.188     0.684     0.200
     1.245     0.693     0.200
     1.254     0.778     0.200
     1.288     0.620     0.200
     1.295     0.502     0.200
     1.354     0.103     0.200
     3.538   -13.501     0.200
     1.055     1.380     0.200
     1.093     1.354     0.200
     1.122     1.266     0.200
     1.248     0.975     0.200
     1.283     0.884     0.200
     1.349     0.605     0.200
     1.314     1.080     0.200
     1.361     1.025     0.200
     1.431     1.286     0.200
     1.480     1.018     0.200
     1.512     0.947     0.200
     1.004     0.704     0.200
     1.104    -0.104     0.200
     1.207    -0.629     0.200
     1.214     0.113     0.200
     1.299    -0.640     0.200
     1.342     0.322     0.200
     1.374     1.333     0.200
     1.395     1.060     0.200
     1.404     0.761     0.200
     1.451     1.331     0.200
     1.504     1.265     0.200
     1.538     1.347     0.200
     1.533     1.326     0.200
     1.576     1.199     0.200
     1.589     1.112     0.200
     1.303     1.081     0.200
     1.382     0.965     0.200
     1.433     1.034     0.200
     1.450     1.046     0.200
     1.582     1.095     0.200
     1.620     1.137     0.200
     1.430     0.323     0.200
     3.795   -15.329     0.200
     1.371     1.705     0.200
     1.511     0.806     0.200
     1.339     1.216     0.200
     1.366     1.008     0.200
     1.378     1.219     0.200
     1.403     1.066     0.200
     1.461     1.101     0.200
     1.500     1.383     0.200
     1.537     1.125     0.200
     1.549     1.572     0.200
     1.348     0.304     0.200
     1.458    -0.859     0.200
     1.455     0.327     0.200
     1.466     0.259     0.200
     1.475     0.229     0.200
     1.498    -0.250     0.200
     1.591    -0.137     0.200
     1.279     0.820     0.200
     1.194     0.752     0.200
     1.316     0.286     0.200
     1.341    -0.112     0.200
     1.259     0.757     0.200
     1.285     0.661     0.200
     1.481     0.052     0.200
     0.819     1.883     0.200
     0.995     1.280     0.200
     1.139    -0.368     0.200
     1.172     0.495     0.200
     1.202    -0.813     0.200
     1.257     0.468     0.200
     1.330    -1.333     0.200
     1.342    -0.706     0.200
     1.066     1.080     0.200
     1.133     0.927     0.200
     1.151     1.115     0.200
     1.202     0.604     0.200
     1.393     1.220     0.200
     1.393     1.149     0.200
     1.484     0.699     0.200
     1.202     0.937     0.200
     1.299     1.195     0.200
     1.377     1.110     0.200
     1.432     1.076     0.200
     1.447     0.926     0.200
     1.582     0.722     0.200
     1.616     0.870     0.200
     1.223     0.520     0.200
     1.446     0.188     0.200
     1.544    -0.660     0.200
     1.574     0.114     0.200
     1.567     0.242     0.200
     1.586     0.118     0.200
     1.381     0.632     0.200
     1.134     1.019     0.200
     1.131     1.083     0.200
     1.249     1.077     0.200
     1.262     0.756     0.200
     1.276     0.841     0.200
     1.307     0.878     0.200
     1.316     0.767     0.200
     1.310     1.173     0.200
     1.374     0.810     0.200
     1.386     0.773     0.200
     1.443     0.583     0.200
     1.262     1.006     0.200
     1.249     1.467     0.200
     1.276     1.037     0.200
     1.307     0.597     0.200
     1.316     1.025     0.200
     1.386     0.624     0.200
     1.443     0.450     0.200
     1.303     1.521     0.200
     3.058   -10.496     0.200
     3.481   -13.045     0.200
     3.498   -13.681     0.200
     1.078     1.251     0.200
     1.199     0.953     0.200
     1.265     0.449     0.200
     1.255     1.275     0.200
     1.274     0.443     0.200
     1.318     0.801     0.200
     1.323     0.244     0.200
     1.328     0.898     0.200
     1.387     0.413     0.200
     1.101     0.979     0.200
     1.111     0.905     0.200
     1.279     0.641     0.200
     1.388     0.802     0.200
     1.406     0.339     0.200
     1.205     0.383     0.200
     1.170     1.005     0.200
     1.212     0.977     0.200
     1.308     0.555     0.200
     1.339     0.739     0.200
     1.385     0.647     0.200
     1.498     0.230     0.200
     1.584     0.322     0.200
     1.283     0.711     0.200
     1.304     0.458     0.200
     1.304     0.674     0.200
     1.536     0.122     0.200
     1.282     1.099     0.200
     1.595     0.206     0.200
     1.216     0.902     0.200
     1.037     0.800     0.200
     1.134     0.903     0.200
     1.169     0.182     0.200
     1.214     1.250     0.200
     1.227     0.013     0.200
     1.275     0.496     0.200
     1.296    -0.349     0.200
     1.299     0.496     0.200
     1.341     0.104     0.200
     1.349     0.110     0.200
     1.459     0.469     0.200
     1.486     0.542     0.200
     1.127     0.639     0.200
     1.135     1.138     0.200
     1.163     1.416     0.200
     1.216     0.862     0.200
     1.264     1.155     0.200
     1.316     0.974     0.200
     1.348     0.521     0.200
     1.414     0.640     0.200
     1.239     0.215     0.200
     1.326     0.615     0.200
     1.342     0.420     0.200
     1.348     0.680     0.200
     1.464    -0.022     0.200
     1.685    -2.526     0.200
     1.527     1.731     0.200
     3.209   -12.748     0.200
     3.224   -11.957     0.200
     4.847   -24.415     0.200
     5.036   -26.098     0.200
     5.692   -30.502     0.200
     6.247   -34.984     0.200
     6.293   -35.470     0.200
     6.486   -37.079     0.200
     6.499   -37.682     0.200
     6.713   -38.884     0.200
     7.726   -46.789     0.200
     1.188     1.950     0.200
     1.080     1.600     0.200
     1.111     1.640     0.200
     1.126     1.080     0.200
     1.193     1.406     0.200
     1.385     1.141     0.200
     1.070     1.494     0.200
     1.086     1.654     0.200
     1.110     1.418     0.200
     1.228     1.369     0.200
     1.412     1.053     0.200
     1.055     1.239     0.200
     0.920     2.381     0.200
     0.951     1.137     0.200
     1.031     1.213     0.200
     1.049     1.351     0.200
     1.112     1.845     0.200
     1.150     1.125     0.200
     1.165     1.200     0.200
     1.203     1.599     0.200
     1.216     1.484     0.200
     1.209     1.302     0.200
     1.221     1.312     0.200
     1.235     1.975     0.200
     1.238     1.805     0.200
     1.407     1.069     0.200
     1.433     0.336     0.200
     1.426     1.012     0.200
     1.441     0.945     0.200
     1.417     0.756     0.200
     1.481    -0.268     0.200
     1.187     1.208     0.200
     1.260     0.996     0.200
     1.426     0.735     0.200
     1.433     0.598     0.200
     1.441     0.507     0.200
     1.481    -0.128     0.200
     1.420     1.115     0.200
     2.323    -7.332     0.200
     5.015   -28.744     0.200
     5.833   -32.966     0.200
     6.500   -39.509     0.200
     1.243     1.163     0.200
     1.310     1.493     0.200
     1.350     1.062     0.200
     1.416     0.940     0.200
     1.349     0.957     0.200
     1.441     0.719     0.200
     1.460     0.268     0.200
     1.487     0.595     0.200
     1.601     0.677     0.200
     3.809   -15.985     0.200
     1.177     0.843     0.200
     1.206     0.339     0.200
     1.354     0.432     0.200
     1.355     0.203     0.200
     1.431     0.239     0.200
     1.589    -0.525     0.200
     1.457     0.174     0.200
     1.107     0.573     0.200
     1.122     0.861     0.200
     1.150     1.336     0.200
     1.228     0.323     0.200
     1.243     1.853     0.200
     1.296     1.036     0.200
     1.332     0.899     0.200
     1.332     0.805     0.200
     1.398     0.559     0.200
     1.287     1.072     0.200
     1.242     1.744     0.200
     1.329     1.056     0.200
     1.367     1.258     0.200
     1.378     2.018     0.200
     1.392     1.704     0.200
     1.530     1.601     0.200
     1.559     1.824     0.200
     1.593     1.272     0.200
     2.672    -7.552     0.200
     2.787    -9.154     0.200
     3.442   -14.663     0.200
     3.743   -12.775     0.200
     4.745   -21.309     0.200
     1.444     1.473     0.200
     1.654     1.828     0.200
     1.089     1.113     0.200
     1.128     0.752     0.200
     1.255     1.149     0.200
     1.300     1.105     0.200
     1.327     0.664     0.200
     1.353     0.654     0.200
     1.359     0.696     0.200
     1.385     0.212     0.200
     1.422     0.884     0.200
     1.491     0.650     0.200
     1.571     0.447     0.200
     1.570     0.473     0.200
     0.811     1.303     0.200
     0.836     1.390     0.200
     0.958     1.066     0.200
     0.994     0.701     0.200
     1.014     0.612     0.200
     1.074     0.534     0.200
     1.081     0.684     0.200
     1.101     1.038     0.200
     1.127     1.229     0.200
     1.260     0.463     0.200
     1.276     0.392     0.200
     1.296    -0.099     0.200
     1.316    -0.074     0.200
     1.330    -0.123     0.200
     1.346     0.286     0.200
     1.385    -0.336     0.200
     1.416     0.402     0.200
     1.518     0.617     0.200
     0.918     1.441     0.200
     0.964     1.217     0.200
     1.027     0.990     0.200
     1.039     1.065     0.200
     1.214     0.609     0.200
     1.267     1.000     0.200
     1.293     0.678     0.200
     1.336     0.834     0.200
     1.371     0.583     0.200
     1.133     1.046     0.200
     1.400     0.871     0.200
     1.503     0.993     0.200
     1.339     1.321     0.200
     1.366     1.162     0.200
     1.368     1.444     0.200
     1.501     0.908     0.200
     1.519     0.638     0.200
     1.515     2.061     0.200
     1.544     1.324     0.200
     1.637     0.741     0.200
     1.684     0.783     0.200
     1.734     0.268     0.200
     0.808     0.769     0.200
     1.038     0.663     0.200
     1.078     0.090     0.200
     1.108    -0.974     0.200
     1.139    -0.764     0.200
     1.282    -1.144     0.200
     1.561     0.135     0.200
     1.598    -0.520     0.200
     1.606     0.240     0.200
     1.237     0.438     0.200
     1.265     0.427     0.200
     1.365     0.411     0.200
     1.367     0.172     0.200
     1.491     0.040     0.200
     1.581    -0.019     0.200
     1.219     0.820     0.200
     1.230     1.139     0.200
     1.297     0.572     0.200
     1.309     0.482     0.200
     1.308     0.885     0.200
     1.452     0.487     0.200
     1.455     0.512     0.200
     1.477     0.334     0.200
     1.504     0.630     0.200
     1.056     1.136     0.200
     1.236     0.831     0.200
     1.308     0.629     0.200
     1.313     1.028     0.200
     1.317     0.673     0.200
     1.461     1.163     0.200
     1.462    -0.011     0.200
     1.128     1.198     0.200
     1.130     1.012     0.200
     1.217     0.910     0.200
     1.273     1.110     0.200
     1.322     0.430     0.200
     1.422     0.137     0.200
     0.988     1.302     0.200
     1.075     1.865     0.200
     1.247     2.019     0.200
     1.076     1.792     0.200
     1.278     0.571     0.200
     1.288    -0.161     0.200
     1.358     0.395     0.200
     1.379    -0.285     0.200
     1.455     0.382     0.200
     1.109     1.687     0.200
     1.406     1.126     0.200
     1.363     0.866     0.200
     1.434     0.692     0.200
     1.554     0.117     0.200
     1.239     0.723     0.200
     1.395     1.486     0.200
     1.489     1.136     0.200
     1.115     1.218     0.200
     1.271     1.917     0.200
     1.319     0.535     0.200
     1.382     0.953     0.200
     1.276     1.028     0.200
     1.339     1.355     0.200
     1.386     1.583     0.200
     1.448     0.704     0.200
     1.517     1.340     0.200
     1.184     1.876     0.200
     1.380    -0.258     0.200
     1.411     0.516     0.200
     1.471     0.397     0.200
     1.407    -0.180     0.200
     0.889     1.335     0.200
     0.893     1.491     0.200
     0.895     1.472     0.200
     0.971     2.101     0.200
     1.009     1.233     0.200
     1.018     1.651     0.200
     1.094     0.875     0.200
     1.113     0.925     0.200
     1.155     0.902     0.200
     1.157     1.701     0.200
     1.213     1.991     0.200
     1.239     0.958     0.200
     1.283     1.095     0.200
     1.345     0.986     0.200
     1.354     1.320     0.200
     1.147     0.371     0.200
     1.359     0.342     0.200
     1.281     1.190     0.200
     1.301     1.908     0.200
     1.574     0.643     0.200
     1.018     4.602     0.200
     1.289     1.358     0.200
     1.324     1.305     0.200
     1.390     0.674     0.200
     1.417     1.114     0.200
     0.850     1.504     0.200
     0.959     1.137     0.200
     0.986     1.208     0.200
     1.012     0.219     0.200
     1.014     0.464     0.200
     1.029     0.653     0.200
     1.064     1.633     0.200
     1.081     0.722     0.200
     1.150     0.652     0.200
     1.187     0.314     0.200
     1.308     0.756     0.200
     1.422     1.238     0.200
     1.215     1.674     0.200
     1.233     1.830     0.200
     1.294     2.157     0.200
     1.311     1.748     0.200
     1.311     1.627     0.200
     1.451     2.017     0.200
     1.458     1.957     0.200
     1.501     1.781     0.200
     1.588     0.739     0.200
     1.630     1.527     0.200
     1.263     0.862     0.200
     1.263     1.542     0.200
     1.339     0.238     0.200
     1.340     0.301     0.200
     1.492     0.394     0.200
     1.488     0.437     0.200
     1.520    -0.163     0.200
     1.547     0.477     0.200
     1.630    -0.104     0.200
     1.237     0.264     0.200
     1.270     0.188     0.200
     1.266     1.277     0.200
     1.342    -0.154     0.200
     1.345     0.256     0.200
     1.349    -0.010     0.200
     1.490     0.025     0.200
     1.553    -0.572     0.200
     1.142     1.131     0.200
     1.160     0.657     0.200
     1.219     1.395     0.200
     1.224     0.214     0.200
     1.375     0.474     0.200
     1.439     0.052     0.200
     1.513    -0.325     0.200
     1.546    -0.165     0.200
     1.033     1.273     0.200
     1.034     1.818     0.200
     1.110     1.239     0.200
     1.139     0.652     0.200
     1.150     1.147     0.200
     1.229     0.278     0.200
     1.254     0.147     0.200
     1.284     0.728     0.200
     1.304    -0.016     0.200
     1.337     0.371     0.200
     1.344     0.956     0.200
     1.403     0.385     0.200
     1.228     0.852     0.200
     1.410     0.636     0.200
     1.459     1.126     0.200
     1.506     0.802     0.200
     1.561     0.780     0.200
     1.624     0.335     0.200
     1.089     0.930     0.200
     1.175     0.812     0.200
     1.185     0.430     0.200
     1.239     0.444     0.200
     1.262     1.463     0.200
     1.282     0.189     0.200
     1.320     0.472     0.200
     1.386     0.888     0.200
     1.170     0.539     0.200
     1.249     0.319     0.200
     1.255     0.486     0.200
     1.291    -0.074     0.200
     1.329     0.228     0.200
     1.395    -0.595     0.200
     1.045     1.337     0.200
     1.518     0.125     0.200
     1.000     1.845     0.200
     1.069     1.169     0.200
     1.120     1.268     0.200
     1.268     0.429     0.200
     1.486     0.834     0.200
     0.984     1.934     0.200
     1.229    -0.022     0.200
     1.288     0.881     0.200
     1.305     1.561     0.200
     1.357     0.801     0.200
     1.016     1.164     0.200
     1.087     1.581     0.200
     1.155     1.148     0.200
     1.019     0.841     0.200
     1.163    -0.103     0.200
     1.168     0.633     0.200
     1.228     0.541     0.200
     1.297     0.324     0.200
     1.351     0.936     0.200
     1.429     0.221     0.200
     0.976     1.698     0.200
     0.999     1.806     0.200
     1.163     0.960     0.200
     1.163     0.143     0.200
     1.171     0.624     0.200
     1.229     0.299     0.200
     0.984     0.654     0.200
     1.018     1.043     0.200
     1.164    -0.017     0.200
     1.169     0.487     0.200
     1.211    -0.624     0.200
     1.228     0.229     0.200
     1.263     0.158     0.200
     1.426     0.548     0.200
     1.503     0.172     0.200
     1.533    -0.265     0.200
     1.389     0.606     0.200
     1.474     0.599     0.200
     1.471     0.509     0.200
     1.509     0.160     0.200
     1.531     0.167     0.200
     1.558     0.360     0.200
     1.652     0.603     0.200
     1.307     3.988     0.200
     3.698   -15.845     0.200
     3.698   -14.845     0.200
     4.545   -21.978     0.200
     5.097   -25.273     0.200
     5.097   -26.072     0.200
     5.148   -26.805     0.200
     5.148   -27.205     0.200
     5.338   -27.522     0.200
     5.338   -27.321     0.200
     5.578   -28.428     0.200
     5.578   -31.629     0.200
     6.578   -38.319     0.200
     7.241   -42.356     0.200
     7.241   -44.056     0.200
     7.291   -43.818     0.200
     7.291   -45.018     0.200
     1.103     0.659     0.200
     1.353    -0.034     0.200
     1.392     1.002     0.200
     1.560     0.702     0.200
     0.882     1.335     0.200
     0.945     1.056     0.200
     1.018     1.079     0.200
     1.067     0.617     0.200
     1.171     1.222     0.200
     1.223     0.412     0.200
     1.472     0.912     0.200
     1.499     0.502     0.200
     1.374     0.956     0.200
     2.637    -9.796     0.200
     3.229   -13.384     0.200
     5.010   -26.343     0.200
     5.204   -26.386     0.200
     5.258   -30.482     0.200
     5.854   -33.104     0.200
     6.190   -39.182     0.200
     6.410   -37.922     0.200
     6.455   -39.343     0.200
     6.649   -39.193     0.200
     6.871   -42.049     0.200
     7.889   -49.604     0.200
     8.272   -55.514     0.200
     8.577   -56.527     0.200
     0.809     2.665     0.200
     0.919     2.502     0.200
     0.995     4.287     0.200
     1.182     0.037     0.200
     1.179     3.695     0.200
     2.084    -6.745     0.200
     2.155    -8.504     0.200
     2.261    -9.076     0.200
     2.274   -10.508     0.200
     2.325    -8.396     0.200
     2.799   -13.678     0.200
     4.835   -29.421     0.200
     5.065   -28.573     0.200
     5.576   -32.903     0.200
     5.728   -34.238     0.200
     6.423   -40.769     0.200
     6.971   -43.425     0.200
     7.028   -45.840     0.200
     7.214   -46.655     0.200
     7.227   -46.455     0.200
     7.461   -49.565     0.200
     7.814   -51.645     0.200
     8.453   -56.619     0.200
     1.140     0.819     0.200
     1.169     1.044     0.200
     1.183     1.399     0.200
     1.201     1.103     0.200
     1.567     0.646     0.200
     0.914     2.154     0.200
     1.059     1.717     0.200
     1.173     1.184     0.200
     1.205     1.260     0.200
     1.243     0.972     0.200
     1.264     1.392     0.200
     1.398     1.705     0.200
     1.406     0.810     0.200
     1.481     1.695     0.200
     0.961     1.038     0.200
     0.986     1.318     0.200
     1.001     0.892     0.200
     1.050     1.276     0.200
     1.085     0.886     0.200
     1.120     1.248     0.200
     1.177     1.489     0.200
     1.186     1.317     0.200
     1.264     1.038     0.200
     1.278     0.740     0.200
     1.316     1.242     0.200
     1.382     0.511     0.200
     1.361    -1.177     0.200
     1.339    -1.101     0.200
     2.698    -8.848     0.200
     4.060   -21.302     0.200
     4.690   -25.358     0.200
     5.030   -28.681     0.200
     5.341   -32.295     0.200
     6.719   -42.569     0.200
     7.375   -46.886     0.200
     7.385   -48.723     0.200
     8.034   -53.470     0.200
     8.070   -54.513     0.200
     9.150   -58.541     0.200
    12.710   -85.581     0.200
    12.710   -88.620     0.200
    12.826   -88.767     0.200
    13.557   -97.424     0.200
    16.464  -119.983     0.200
     1.175     0.674     0.200
     1.232     0.462     0.200
     1.313     1.087     0.200
     1.379     0.600     0.200
     1.297     0.737     0.200
     1.078     1.176     0.200
     1.308     0.855     0.200
     1.531     0.920     0.200
     1.080     1.035     0.200
     1.228     0.873     0.200
     1.265     1.070     0.200
     1.273     0.812     0.200
     1.309     0.565     0.200
     1.375     0.775     0.200
     1.264     0.152     0.200
     1.355     0.013     0.200
     3.059    -9.960     0.200
     0.987     0.875     0.200
     1.171     0.088     0.200
     1.214     1.029     0.200
     1.271    -0.170     0.200
     1.322    -0.921     0.200
     1.355    -0.464     0.200
     1.535     0.760     0.200
     1.326     1.482     0.200
     1.368     0.004     0.200
     1.348     0.944     0.200
     1.465     1.037     0.200
     1.610     0.624     0.200
     1.528     1.642     0.200
     3.215   -13.662     0.200
     1.242     1.408     0.200
     1.219     1.055     0.200
     1.261     1.339     0.200
     1.267     1.418     0.200
     1.598     3.785     0.200
     1.349     0.420     0.200
     1.382     1.371     0.200
     1.303     0.581     0.200
     1.389     1.788     0.200
     1.407     0.487     0.200
     1.412     1.412     0.200
     1.529     0.997     0.200
     1.570     0.335     0.200
     1.598    -0.453     0.200
     1.466     0.763     0.200
     2.648    -9.396     0.200
     3.211   -13.952     0.200
     1.308     0.581     0.200
     1.392     0.540     0.200
     1.411     0.462     0.200
     1.416     0.700     0.200
     1.533     0.954     0.200
     1.602    -0.185     0.200
     3.786   -14.843     0.200
     4.474   -21.605     0.200
     4.914   -24.741     0.200
     5.104   -25.783     0.200
     5.758   -33.518     0.200
     6.314   -36.515     0.200
     6.360   -37.782     0.200
     6.553   -38.303     0.200
     6.565   -38.500     0.200
     6.778   -41.750     0.200
     7.135   -42.768     0.200
     7.793   -48.807     0.200
     8.451   -53.886     0.200
     8.485   -54.865     0.200
    12.430   -85.002     0.200
    12.649   -87.332     0.200
     1.053     1.308     0.200
     1.250     1.491     0.200
     1.255     1.185     0.200
     1.294     0.413     0.200
     1.327     0.224     0.200
     1.472    -0.301     0.200
     1.585     0.518     0.200
     1.281     1.044     0.200
     1.293     0.889     0.200
     1.360     0.358     0.200
     1.370     0.485     0.200
     1.374     0.416     0.200
     1.406     0.518     0.200
     1.517     0.210     0.200
     1.541    -0.197     0.200
     1.567     0.880     0.200
     1.229     0.589     0.200
     1.545     1.641     0.200
     2.634    -7.400     0.200
     3.027   -10.770     0.200
     2.972    -9.105     0.200
     3.085   -11.670     0.200
     3.392   -12.141     0.200
     3.598   -13.662     0.200
     3.844   -17.370     0.200
     4.070   -17.685     0.200
     4.237   -18.114     0.200
     4.792   -23.522     0.200
     4.839   -24.094     0.200
     5.032   -24.600     0.200
     5.044   -25.601     0.200
     5.006   -22.377     0.200
     6.125   -36.302     0.200
     7.203   -47.792     0.200
     7.723   -49.730     0.200
     7.986   -54.887     0.200
     7.986   -51.645     0.200
     8.420   -48.236     0.200
    10.829   -74.190     0.200
    11.049   -77.581     0.200
    13.816  -100.289     0.200
     0.896     4.406     0.200
     1.240     1.636     0.200
     1.227     4.404     0.200
     1.451     2.324     0.200
     2.317    -6.840     0.200
     2.582    -8.140     0.200
     2.606    -8.592     0.200
     3.378   -12.640     0.200
     4.979   -26.565     0.200
     6.938   -41.375     0.200
     8.469   -52.887     0.200
    12.048   -82.709     0.200
    12.048   -79.850     0.200
    16.152  -117.598     0.200
     2.893   -14.163     0.200
     2.890   -11.231     0.200
     3.006   -10.767     0.200
     3.016   -11.986     0.200
     3.073   -12.105     0.200
     3.174   -14.370     0.200
     3.174   -14.151     0.200
     3.314   -13.818     0.200
     3.407   -15.660     0.200
     3.521   -17.660     0.200
     3.828   -19.383     0.200
     4.171   -23.580     0.200
     4.330   -21.177     0.200
     4.697   -27.574     0.200
     4.724   -27.913     0.200
     4.666   -24.224     0.200
     4.774   -25.102     0.200
     4.774   -27.792     0.200
     4.740   -26.787     0.200
     4.965   -29.036     0.200
     4.977   -30.236     0.200
     5.203   -32.381     0.200
     5.556   -34.783     0.200
     5.881   -37.805     0.200
     6.099   -37.383     0.200
     6.099   -36.533     0.200
     6.867   -45.037     0.200
     6.915   -45.571     0.200
     7.668   -51.195     0.200
     7.960   -54.186     0.200
     7.949   -52.983     0.200
     9.637   -67.552     0.200
     9.637   -65.722     0.200
    10.054   -64.857     0.200
    10.735   -76.659     0.200
    11.056   -78.247     0.200
    12.968   -90.723     0.200
    13.578   -92.544     0.200
    13.578   -96.433     0.200
    15.075  -103.429     0.200
    16.947  -120.588     0.200
     1.166     5.224     0.200
     1.446     4.680     0.200
     1.470     5.973     0.200
     1.651     1.817     0.200
     1.627     2.605     0.200
     2.495    -5.085     0.200
     2.574    -6.366     0.200
     1.489    -1.159     0.200
     2.661   -11.508     0.200
     2.951   -12.064     0.200
     2.833   -10.220     0.200
     3.000   -13.267     0.200
     3.247   -12.623     0.200
     3.276   -14.311     0.200
     3.774   -20.313     0.200
     4.001   -17.159     0.200
     4.223   -22.281     0.200
     4.440   -22.747     0.200
     4.519   -23.770     0.200
     7.232   -47.691     0.200
     1.408    -0.477     0.200
     2.585   -13.066     0.200
     3.813   -15.746     0.200
     5.066   -32.027     0.200
     7.246   -49.130     0.200
     7.871   -51.117     0.200
     8.055   -50.986     0.200
    10.143   -69.848     0.200
     1.220     4.194     0.200
     1.501     3.563     0.200
     1.901    -5.519     0.200
     2.423    -6.755     0.200
     2.434    -9.604     0.200
     2.600    -8.545     0.200
     3.155   -10.662     0.200
     3.622   -14.911     0.200
     5.330   -27.243     0.200
     6.002   -33.011     0.200
     6.604   -37.477     0.200
     7.556   -48.541     0.200
     8.707   -52.139     0.200
    12.282   -84.997     0.200
    12.565   -85.648     0.200
    13.873   -96.843     0.200
    16.243  -114.781     0.200
    16.271  -117.435     0.200
     3.022   -10.306     0.200
     3.022   -11.006     0.200
     3.431   -14.004     0.200
     3.464   -14.225     0.200
     3.464   -14.625     0.200
     3.651   -14.246     0.200
     3.651   -15.746     0.200
     4.311   -21.960     0.200
     4.311   -21.160     0.200
     4.863   -25.150     0.200
     4.914   -26.632     0.200
     4.914   -26.493     0.200
     4.914   -26.792     0.200
     5.104   -27.601     0.200
     5.104   -28.101     0.200
     5.117   -28.000     0.200
     5.345   -28.853     0.200
     5.345   -31.353     0.200
     7.008   -42.044     0.200
     7.008   -42.544     0.200
     7.059   -42.561     0.200
     7.059   -46.461     0.200
    11.014   -74.441     0.200
     1.431     1.422     0.200
     2.844    -7.814     0.200
     3.090   -10.034     0.200
     3.523   -13.261     0.200
     3.718   -13.846     0.200
     4.026   -16.289     0.200
     4.369   -19.571     0.200
     4.541   -21.685     0.200
     4.923   -22.619     0.200
     5.163   -26.335     0.200
     5.399   -26.810     0.200
     7.110   -40.774     0.200
     7.159   -47.752     0.200
     7.992   -49.782     0.200
     1.446    -3.152     0.200
     2.488   -10.756     0.200
     4.151   -22.351     0.200
     4.781   -27.612     0.200
     5.433   -32.787     0.200
     5.988   -35.183     0.200
     6.034   -37.251     0.200
     6.227   -37.869     0.200
     6.454   -39.658     0.200
     6.811   -42.361     0.200
     8.162   -54.099     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.128    -4.096     0.200
     2.799    -3.650     0.200
     1.183    -0.813     0.200
     2.669    -4.919     0.200
     1.993    -2.613     0.200
     3.645    -7.069     0.200
     2.311    -5.307     0.200
     0.777    -0.466     0.200
     2.533    -3.844     0.200
     1.819    -2.338     0.200
     2.843    -5.088     0.200
     1.337    -0.991     0.200
     2.478    -1.371     0.200
     2.503    -7.295     0.200
     2.475    -6.096     0.200
     3.814    -8.446     0.200
     5.110   -12.814     0.200
     2.530    -4.451     0.200
     2.536    -2.834     0.200
     1.027     0.508     0.200
     1.252    -0.814     0.200
     1.477    -1.463     0.200
     2.144    -4.855     0.200
     2.940    -4.575     0.200
     2.940    -4.872     0.200
     3.866   -11.442     0.200
     2.135    -0.955     0.200
     2.474    -3.187     0.200
     0.770     1.054     0.200
     5.627   -14.510     0.200
     0.738     0.439     0.200
     2.068    -2.406     0.200
     2.475    -6.195     0.200
     0.704    -0.485     0.200
     2.042    -1.393     0.200
     2.445    -3.665     0.200
     0.534     0.394     0.200
     2.276    -2.845     0.200
     0.934     0.033     0.200
     2.533    -5.449     0.200
     2.906    -3.785     0.200
     1.103     0.040     0.200
     1.670    -0.946     0.200
     2.623    -5.140     0.200
     2.606    -3.409     0.200
     3.025    -3.906     0.200
     2.593    -4.862     0.200
     3.013    -4.262     0.200
     3.435    -6.132     0.200
     0.830    -0.903     0.200
     2.019    -1.915     0.200
     1.006     0.483     0.200
     1.136    -0.053     0.200
     2.490    -5.481     0.200
     2.529    -4.155     0.200
     1.026    -0.079     0.200
     2.016     0.565     0.200
     2.491    -5.212     0.200
     2.533    -5.335     0.200
     1.095    -0.574     0.200
     1.228    -0.287     0.200
     2.532    -6.141     0.200
     2.599    -4.261     0.200
     2.729    -4.391     0.200
     2.953    -5.087     0.200
     3.445    -8.578     0.200
     1.149    -0.376     0.200
     2.048    -0.385     0.200
     2.609    -4.145     0.200
     2.049    -0.397     0.200
     1.020    -0.157     0.200
     1.188    -0.105     0.200
     2.037    -0.816     0.200
     2.540    -5.140     0.200
     2.582    -4.085     0.200
     2.715    -5.807     0.200
     2.848    -3.504     0.200
     5.750   -14.520     0.200
     2.045    -1.114     0.200
     2.857    -6.378     0.200
     3.339    -4.148     0.200
     2.045    -1.126     0.200
     2.620    -5.382     0.200
     2.999    -6.912     0.200
     1.024     0.749     0.200
     2.015    -2.121     0.200
     2.945    -4.590     0.200
     2.016    -2.133     0.200
     1.006     1.106     0.200
     1.167    -0.109     0.200
     1.156    -1.782     0.200
     2.042    -2.867     0.200
     2.559    -4.741     0.200
     2.692    -3.456     0.200
     2.745    -4.134     0.200
     2.979    -4.354     0.200
     5.727   -12.675     0.200
     1.118     0.622     0.200
     2.043    -2.879     0.200
     1.226    -0.310     0.200
     2.091    -1.732     0.200
     2.384    -1.332     0.200
     2.701    -5.078     0.200
     2.827    -5.658     0.200
     3.055    -6.280     0.200
     1.122    -0.000     0.200
     1.187     0.236     0.200
     2.561    -4.840     0.200
     2.388    -1.734     0.200
     2.694    -3.535     0.200
     3.180    -7.454     0.200
     1.034    -1.752     0.200
     1.988     0.159     0.200
     2.436    -2.062     0.200
     2.503    -5.168     0.200
     2.630    -4.190     0.200
     2.856    -5.376     0.200
     2.640    -3.733     0.200
     3.056    -7.915     0.200
     2.928    -4.145     0.200
     3.184    -3.827     0.200
     1.036    -1.102     0.200
     1.187    -0.393     0.200
     2.482    -4.358     0.200
     2.658    -3.246     0.200
     2.945    -4.847     0.200
     3.102    -7.294     0.200
     1.864     0.408     0.200
     1.037    -1.058     0.200
     1.148    -0.199     0.200
     2.484    -5.448     0.200
     2.612    -6.530     0.200
     2.679    -4.645     0.200
     2.741    -6.594     0.200
     3.130    -7.944     0.200
     1.068     0.509     0.200
     0.995     0.153     0.200
     2.595    -4.732     0.200
     2.663    -4.405     0.200
     2.727    -5.944     0.200
     2.986    -5.738     0.200
     1.114     0.090     0.200
     2.983    -4.050     0.200
     3.012    -6.577     0.200
     0.198     0.332     0.200
     1.107    -0.600     0.200
     2.547    -4.485     0.200
     1.153    -0.460     0.200
     1.007    -0.193     0.200
     1.098     0.446     0.200
     2.064    -1.572     0.200
     2.756    -4.505     0.200
     1.146    -0.449     0.200
     1.192     0.878     0.200
     1.248     0.306     0.200
     1.169     1.129     0.200
     2.011    -1.086     0.200
     2.759    -3.778     0.200
     1.879     0.691     0.200
     2.012    -1.098     0.200
     1.047     0.004     0.200
     1.093     0.623     0.200
     1.194     0.216     0.200
     2.652    -3.012     0.200
     2.719    -4.015     0.200
     2.079    -1.227     0.200
     2.379    -1.860     0.200
     2.586    -5.311     0.200
     2.781    -6.258     0.200
     2.780    -5.474     0.200
     2.973    -5.576     0.200
     3.646    -6.104     0.200
     1.003    -1.316     0.200
     1.001    -0.604     0.200
     1.118    -0.327     0.200
     2.028    -1.879     0.200
     2.917    -4.077     0.200
     1.024    -1.228     0.200
     1.066    -0.387     0.200
     1.147    -1.211     0.200
     2.027    -0.004     0.200
     2.694    -5.165     0.200
     2.952    -3.340     0.200
     0.276    -0.801     0.200
     1.089    -2.393     0.200
     1.985    -0.474     0.200
     2.607    -3.190     0.200
     2.741    -4.438     0.200
     3.029    -4.743     0.200
     0.573    -0.508     0.200
     0.869    -0.209     0.200
     0.976     0.394     0.200
     1.114    -0.199     0.200
     1.211     0.021     0.200
     2.043    -0.662     0.200
     2.576    -4.374     0.200
     2.621    -4.492     0.200
     2.754    -3.219     0.200
     2.816    -3.367     0.200
     3.041    -4.520     0.200
     1.154    -0.099     0.200
     2.043    -0.674     0.200
     0.086     2.024     0.200
     0.241    -1.161     0.200
     0.292     0.267     0.200
     0.324     0.179     0.200
     1.002     0.586     0.200
     1.070    -0.212     0.200
     1.120     0.627     0.200
     1.173    -0.041     0.200
     2.056    -1.039     0.200
     2.590    -3.960     0.200
     0.042     3.157     0.200
     0.216     0.498     0.200
     0.221     1.246     0.200
     0.292     0.051     0.200
     0.828     1.007     0.200
     1.023    -0.919     0.200
     1.149    -0.662     0.200
     2.028    -2.333     0.200
     2.563    -6.804     0.200
     2.858    -7.040     0.200
     2.028    -2.345     0.200
     2.633    -3.100     0.200
     0.056     2.575     0.200
     0.063     3.038     0.200
     0.223     0.658     0.200
     0.219     0.482     0.200
     0.219     0.661     0.200
     0.292     0.077     0.200
     1.025    -0.709     0.200
     2.027    -1.428     0.200
     2.565    -6.484     0.200
     2.729    -5.685     0.200
     2.028    -1.439     0.200
     2.956    -4.472     0.200
     0.049     2.722     0.200
     0.065     1.295     0.200
     0.048     3.361     0.200
     0.070     2.628     0.200
     0.213     0.480     0.200
     0.217     0.838     0.200
     0.286     0.157     0.200
     0.816     0.262     0.200
     2.692    -3.721     0.200
     0.058     1.116     0.200
     0.126     1.627     0.200
     0.249     0.430     0.200
     0.249    -0.613     0.200
     0.366    -0.051     0.200
     0.894     0.034     0.200
     1.060    -0.316     0.200
     1.114     0.064     0.200
     2.111    -0.830     0.200
     2.411    -1.854     0.200
     0.077     2.450     0.200
     0.050     3.050     0.200
     0.088     1.258     0.200
     0.187     2.019     0.200
     0.230     0.839     0.200
     0.234     0.850     0.200
     0.852     0.552     0.200
     1.001     0.807     0.200
     1.173    -1.330     0.200
     1.169    -0.292     0.200
     2.877    -6.136     0.200
     2.053    -2.032     0.200
     2.579    -4.690     0.200
     0.048     3.135     0.200
     0.055     2.314     0.200
     0.215     0.969     0.200
     0.216     1.266     0.200
     0.207     1.781     0.200
     0.816     0.427     0.200
     1.040    -2.037     0.200
     1.078    -0.581     0.200
     1.154    -1.779     0.200
     1.136    -0.117     0.200
     2.560    -5.969     0.200
     2.694    -5.596     0.200
     2.852    -7.607     0.200
     2.755    -6.053     0.200
     2.012    -0.984     0.200
     5.729   -15.801     0.200
     0.049     3.146     0.200
     0.082     2.455     0.200
     0.184     2.291     0.200
     0.236     1.094     0.200
     0.232     0.786     0.200
     0.292    -0.011     0.200
     0.294     0.473     0.200
     0.577    -0.038     0.200
     0.857    -0.157     0.200
     0.995     0.791     0.200
     2.714    -4.530     0.200
     0.088     2.073     0.200
     0.009     3.541     0.200
     0.037     3.459     0.200
     0.246     0.946     0.200
     0.243     0.459     0.200
     0.294     0.355     0.200
     0.301     0.143     0.200
     0.300     0.176     0.200
     0.862     0.235     0.200
     0.051     2.492     0.200
     0.063     2.413     0.200
     0.076     2.377     0.200
     0.221     0.303     0.200
     0.226     0.417     0.200
     0.248     0.928     0.200
     0.262     0.390     0.200
     0.522    -0.361     0.200
     0.811     0.495     0.200
     0.802     1.006     0.200
     1.052    -1.690     0.200
     1.089    -0.168     0.200
     2.562    -4.518     0.200
     2.758    -3.931     0.200
     2.925    -7.026     0.200
     0.023     3.920     0.200
     0.041     3.765     0.200
     0.255    -0.015     0.200
     0.257     0.635     0.200
     0.319    -0.136     0.200
     0.605    -0.353     0.200
     0.885     0.158     0.200
     1.096    -1.728     0.200
     0.999     0.382     0.200
     0.037     3.244     0.200
     0.060     2.816     0.200
     0.082     2.684     0.200
     0.207     0.659     0.200
     0.202     0.746     0.200
     0.251    -0.355     0.200
     0.218     1.887     0.200
     0.530    -0.207     0.200
     0.810     0.670     0.200
     0.804     0.357     0.200
     1.033    -2.564     0.200
     1.063    -1.475     0.200
     2.681    -3.864     0.200
     2.742    -5.807     0.200
     0.048     2.873     0.200
     0.050     2.279     0.200
     0.070     2.680     0.200
     0.220     0.473     0.200
     0.206     2.174     0.200
     0.254     0.619     0.200
     0.264     0.440     0.200
     0.820     1.395     0.200
     0.074     2.035     0.200
     0.023     3.078     0.200
     0.050     2.568     0.200
     0.229    -0.399     0.200
     0.187     1.347     0.200
     0.290     0.413     0.200
     0.568    -0.306     0.200
     0.688    -1.096     0.200
     0.849    -0.567     0.200
     1.172    -0.050     0.200
     2.578    -5.614     0.200
     0.044     3.142     0.200
     0.104     2.059     0.200
     0.052     1.756     0.200
     0.074     2.739     0.200
     0.208    -0.197     0.200
     0.213     0.693     0.200
     0.259     0.361     0.200
     0.211     1.944     0.200
     0.259     0.354     0.200
     0.813     1.059     0.200
     0.819     1.073     0.200
     1.027    -0.938     0.200
     0.130     1.004     0.200
     0.158     0.789     0.200
     0.107     1.691     0.200
     0.185     0.062     0.200
     0.185     0.335     0.200
     0.174     0.986     0.200
     0.177     1.317     0.200
     0.235     0.534     0.200
     0.286     0.990     0.200
     0.417    -0.223     0.200
     0.707     1.803     0.200
     0.138     0.771     0.200
     0.096     1.958     0.200
     0.114     0.836     0.200
     0.161     0.537     0.200
     0.187     0.089     0.200
     0.163     0.978     0.200
     0.170     1.130     0.200
     0.217    -0.192     0.200
     0.283     1.150     0.200
     0.424    -0.261     0.200
     0.567     1.229     0.200
     0.712     1.632     0.200
     0.137     2.183     0.200
     0.196     0.622     0.200
     0.137     1.966     0.200
     0.241     1.169     0.200
     0.268     0.115     0.200
     0.268     0.514     0.200
     0.214     1.628     0.200
     0.293    -0.446     0.200
     0.304     0.726     0.200
     0.301     0.365     0.200
     0.317     1.569     0.200
     0.480    -0.059     0.200
     0.644     0.817     0.200
     0.781     1.921     0.200
     0.051     2.566     0.200
     0.111     1.542     0.200
     0.047     2.591     0.200
     0.191     0.129     0.200
     0.220     0.534     0.200
     0.265    -0.218     0.200
     0.204     1.625     0.200
     0.287     0.074     0.200
     0.662     1.198     0.200
     0.817     2.042     0.200
     1.028    -0.948     0.200
     1.069     0.544     0.200
     0.097     1.938     0.200
     0.137     0.770     0.200
     0.172     1.282     0.200
     0.216    -0.453     0.200
     0.225    -0.123     0.200
     0.284     1.078     0.200
     1.251    -0.488     0.200
     1.901    -1.088     0.200
     2.513    -3.477     0.200
     0.046     2.785     0.200
     0.103     1.892     0.200
     0.050     3.457     0.200
     0.208    -0.355     0.200
     0.213     1.117     0.200
     0.258     0.262     0.200
     0.210     1.631     0.200
     0.540     0.019     0.200
     0.659     0.006     0.200
     0.815     0.926     0.200
     0.820     0.639     0.200
     0.934     1.033     0.200
     0.060     1.719     0.200
     0.084     2.761     0.200
     0.127     1.914     0.200
     0.202     1.979     0.200
     0.231     0.504     0.200
     0.655    -0.380     0.200
     1.051    -1.875     0.200
     0.034     3.125     0.200
     0.033     3.209     0.200
     0.039     3.469     0.200
     0.092     2.205     0.200
     0.099     2.172     0.200
     0.063     2.768     0.200
     0.200     0.718     0.200
     0.246     0.785     0.200
     0.249     0.506     0.200
     0.221     1.803     0.200
     0.647     0.154     0.200
     1.035    -1.283     0.200
     0.019     3.125     0.200
     0.090     1.807     0.200
     0.148     0.544     0.200
     0.153     1.227     0.200
     0.137     0.932     0.200
     0.153    -0.121     0.200
     0.163     0.580     0.200
     0.203     0.448     0.200
     0.204     0.277     0.200
     0.213     0.276     0.200
     0.291     0.971     0.200
     0.422    -0.439     0.200
     1.283    -0.455     0.200
     2.502    -4.080     0.200
     2.636    -4.843     0.200
     2.901    -3.634     0.200
     0.020     2.882     0.200
     0.080     1.295     0.200
     0.086     1.828     0.200
     0.139     0.860     0.200
     0.150     1.073     0.200
     0.146     0.452     0.200
     0.163     0.458     0.200
     0.199    -0.210     0.200
     0.269     0.168     0.200
     0.292     1.144     0.200
     0.422    -0.538     0.200
     0.822     0.579     0.200
     0.057     2.603     0.200
     0.055     2.123     0.200
     0.057     1.972     0.200
     0.127     1.312     0.200
     0.201    -0.164     0.200
     0.232     0.155     0.200
     0.200     0.855     0.200
     0.280     0.208     0.200
     0.818    -0.213     0.200
     0.061     1.710     0.200
     0.035     2.217     0.200
     0.113     1.354     0.200
     0.113     1.555     0.200
     0.060     2.440     0.200
     0.181    -0.392     0.200
     0.220    -0.442     0.200
     0.224     0.129     0.200
     0.224     0.329     0.200
     0.261     0.369     0.200
     0.272     0.223     0.200
     0.272     0.422     0.200
     0.395     0.115     0.200
     0.674     0.958     0.200
     0.830     1.279     0.200
     0.104     1.657     0.200
     0.121     1.204     0.200
     0.158     1.204     0.200
     0.185     0.893     0.200
     0.190     1.372     0.200
     0.230     0.162     0.200
     0.249     0.219     0.200
     0.409    -0.146     0.200
     0.561    -1.082     0.200
     0.079     1.825     0.200
     0.148    -0.375     0.200
     0.191     0.687     0.200
     0.246     0.031     0.200
     0.266     0.301     0.200
     0.282     0.078     0.200
     0.261     0.354     0.200
     0.230     1.748     0.200
     0.652     1.153     0.200
     0.814     0.760     0.200
     0.033     2.599     0.200
     0.034     1.970     0.200
     0.055     2.639     0.200
     0.122     1.662     0.200
     0.227     0.054     0.200
     0.232     0.533     0.200
     0.191     2.094     0.200
     0.255     0.682     0.200
     0.279    -0.025     0.200
     0.267     0.412     0.200
     0.299     0.116     0.200
     0.551    -0.423     0.200
     0.675    -0.735     0.200
     0.829     1.027     0.200
     1.139     0.356     0.200
     0.060     1.788     0.200
     0.032     2.567     0.200
     0.036     2.263     0.200
     0.056     2.811     0.200
     0.110     1.978     0.200
     0.120     1.782     0.200
     0.189    -0.752     0.200
     0.193     1.569     0.200
     0.230     0.204     0.200
     0.254     0.636     0.200
     0.266     0.446     0.200
     0.298     0.448     0.200
     0.551    -0.711     0.200
     0.835     1.535     0.200
     0.044     2.517     0.200
     0.082     1.414     0.200
     0.111     2.131     0.200
     0.183    -0.308     0.200
     0.241     1.892     0.200
     0.303     0.396     0.200
     0.305     0.435     0.200
     0.836    -0.407     0.200
     2.067    -1.632     0.200
     2.530    -5.790     0.200
     2.597    -4.731     0.200
     2.836    -7.807     0.200
     2.068    -1.644     0.200
     2.916    -7.818     0.200
     0.020     3.114     0.200
     0.048     2.133     0.200
     0.057     1.759     0.200
     0.089     1.867     0.200
     0.083     2.233     0.200
     0.112     1.782     0.200
     0.196    -0.234     0.200
     0.200     0.343     0.200
     0.253    -0.124     0.200
     0.221     1.612     0.200
     0.265     0.359     0.200
     0.819     0.434     0.200
     0.017     3.543     0.200
     0.034     2.901     0.200
     0.111     1.694     0.200
     0.267     0.723     0.200
     0.198     1.502     0.200
     0.277     0.293     0.200
     0.280     0.338     0.200
     0.304     0.051     0.200
     0.560    -0.214     0.200
     0.677    -0.396     0.200
     0.839     1.481     0.200
     0.833     0.704     0.200
     1.009     0.076     0.200
     2.042    -1.662     0.200
     2.567    -4.306     0.200
     2.700    -4.522     0.200
     0.113     1.493     0.200
     0.133     1.511     0.200
     0.226     0.176     0.200
     0.194     1.355     0.200
     0.283    -0.079     0.200
     0.291     0.416     0.200
     0.289     0.008     0.200
     0.844     0.143     0.200
     0.997    -0.228     0.200
     1.053     0.564     0.200
     1.112    -2.113     0.200
     2.354    -1.381     0.200
     2.572    -3.376     0.200
     0.015     3.572     0.200
     0.049     2.489     0.200
     0.096     1.517     0.200
     0.203     0.201     0.200
     0.207    -0.047     0.200
     0.262     0.642     0.200
     0.261     0.279     0.200
     0.270     0.239     0.200
     0.213     0.813     0.200
     0.292     0.068     0.200
     0.822     0.706     0.200
     0.019     2.997     0.200
     0.032     2.487     0.200
     0.113     1.343     0.200
     0.179    -0.081     0.200
     0.221     0.191     0.200
     0.225     0.264     0.200
     0.196     1.103     0.200
     0.277     0.221     0.200
     0.278     0.555     0.200
     0.304    -0.049     0.200
     0.678     0.095     0.200
     0.840     1.474     0.200
     0.047     2.261     0.200
     0.066     1.563     0.200
     0.105     1.492     0.200
     0.180     0.294     0.200
     0.204     0.388     0.200
     0.209     0.153     0.200
     0.230     0.737     0.200
     0.240     0.295     0.200
     0.268    -0.205     0.200
     0.220     1.301     0.200
     0.043     2.958     0.200
     0.088     2.353     0.200
     0.063     2.210     0.200
     0.177     0.457     0.200
     0.203     0.395     0.200
     0.208     0.237     0.200
     0.234     0.545     0.200
     0.243     0.412     0.200
     0.250     0.905     0.200
     0.270     0.225     0.200
     0.219     1.480     0.200
     0.052     0.905     0.200
     0.029     1.933     0.200
     0.043     1.479     0.200
     0.066     1.942     0.200
     0.106     1.377     0.200
     0.111     1.140     0.200
     0.216    -0.192     0.200
     0.220    -0.066     0.200
     0.203     0.326     0.200
     0.251    -0.024     0.200
     0.262    -0.112     0.200
     0.268     1.064     0.200
     0.291    -0.453     0.200
     0.051     2.070     0.200
     0.055     1.949     0.200
     0.127     1.582     0.200
     0.077     2.491     0.200
     0.119    -0.086     0.200
     0.181     1.290     0.200
     0.239     0.489     0.200
     0.193     1.566     0.200
     0.311    -0.656     0.200
     0.327     0.354     0.200
     0.355    -0.017     0.200
     1.065    -1.072     0.200
     2.403    -1.970     0.200
     2.583    -4.699     0.200
     2.716    -5.391     0.200
     0.021     3.349     0.200
     0.045     2.479     0.200
     0.064     2.222     0.200
     0.103     1.947     0.200
     0.052     2.974     0.200
     0.052     3.366     0.200
     0.111     2.059     0.200
     0.208     1.729     0.200
     0.291     0.279     0.200
     0.391     0.211     0.200
     1.017    -1.434     0.200
     1.058     0.443     0.200
     1.130    -0.905     0.200
     1.130    -0.803     0.200
     1.178    -0.322     0.200
     2.031    -0.374     0.200
     2.332    -1.412     0.200
     2.557    -7.048     0.200
     2.626    -7.236     0.200
     2.958    -7.742     0.200
     2.334    -1.460     0.200
     2.821    -7.336     0.200
     0.050     1.972     0.200
     0.051     2.239     0.200
     0.032     2.218     0.200
     0.046     1.794     0.200
     0.103     1.614     0.200
     0.067     2.443     0.200
     0.111     1.598     0.200
     0.216    -0.694     0.200
     0.213     1.233     0.200
     0.220     0.157     0.200
     0.204     1.739     0.200
     0.259     0.545     0.200
     0.266     0.101     0.200
     0.288     0.114     0.200
     0.382     0.194     0.200
     0.062     1.699     0.200
     0.062     2.594     0.200
     0.017     3.441     0.200
     0.035     2.660     0.200
     0.062     2.639     0.200
     0.110     1.805     0.200
     0.199     1.846     0.200
     0.213     0.994     0.200
     0.222     0.329     0.200
     0.275     0.444     0.200
     0.274     0.842     0.200
     0.302     0.155     0.200
     0.399     0.169     0.200
     0.051     2.804     0.200
     0.050     1.391     0.200
     0.026     3.257     0.200
     0.046     2.425     0.200
     0.069     2.493     0.200
     0.106     1.819     0.200
     0.216     0.491     0.200
     0.208     1.672     0.200
     0.207     1.857     0.200
     0.262     0.490     0.200
     0.264     0.346     0.200
     0.289     0.206     0.200
     1.183    -0.318     0.200
     0.023     3.021     0.200
     0.031     3.580     0.200
     0.061     2.909     0.200
     0.070     2.026     0.200
     0.112     1.910     0.200
     0.087     1.406     0.200
     0.102     2.220     0.200
     0.208     0.366     0.200
     0.204     1.294     0.200
     0.189    -0.757     0.200
     0.201    -0.130     0.200
     0.207     0.897     0.200
     0.216     0.697     0.200
     0.237     0.222     0.200
     0.248     0.698     0.200
     0.232     1.683     0.200
     0.342     0.121     0.200
     1.083    -1.315     0.200
     0.011     3.658     0.200
     0.076     2.568     0.200
     0.078     2.304     0.200
     0.037     3.007     0.200
     0.106     1.814     0.200
     0.066     2.894     0.200
     0.220     1.213     0.200
     0.217    -0.495     0.200
     0.209     1.129     0.200
     0.281     0.641     0.200
     0.295     0.349     0.200
     0.316     0.256     0.200
     0.420     0.258     0.200
     0.059     1.687     0.200
     0.059     2.290     0.200
     0.019     3.854     0.200
     0.039     2.925     0.200
     0.116     1.760     0.200
     0.064     2.539     0.200
     0.108     1.845     0.200
     0.175    -0.515     0.200
     0.215    -1.075     0.200
     0.211     1.403     0.200
     0.202     1.854     0.200
     0.272     0.438     0.200
     0.298     0.100     0.200
     0.396     0.196     0.200
     0.037     2.938     0.200
     0.035     1.353     0.200
     0.059     0.709     0.200
     0.095     1.808     0.200
     0.100     1.516     0.200
     0.081     2.106     0.200
     0.207     0.291     0.200
     0.218     1.813     0.200
     0.252     0.481     0.200
     0.276     0.120     0.200
     0.050     2.105     0.200
     0.015     2.811     0.200
     0.109     1.800     0.200
     0.160     1.330     0.200
     0.159     1.754     0.200
     0.251     1.570     0.200
     0.262    -0.003     0.200
     0.300     0.175     0.200
     0.315     0.209     0.200
     0.433    -0.121     0.200
     0.032     3.130     0.200
     0.044     2.899     0.200
     0.099     2.090     0.200
     0.033     3.106     0.200
     0.066     2.676     0.200
     0.090     2.198     0.200
     0.160    -0.512     0.200
     0.195     0.262     0.200
     0.244     0.822     0.200
     0.253     0.437     0.200
     0.246     0.382     0.200
     0.046     1.845     0.200
     0.061     1.673     0.200
     0.029     2.209     0.200
     0.103     1.788     0.200
     0.050     1.124     0.200
     0.175    -1.169     0.200
     0.213     0.438     0.200
     0.208    -0.979     0.200
     0.258    -0.247     0.200
     0.249     0.166     0.200
     0.053     1.876     0.200
     0.056     2.373     0.200
     0.073     1.545     0.200
     0.104     1.938     0.200
     0.042     1.716     0.200
     0.063     2.395     0.200
     0.220    -0.623     0.200
     0.225     0.416     0.200
     0.249     0.223     0.200
     0.260     0.135     0.200
     0.054     1.167     0.200
     0.054     2.457     0.200
     0.024     3.195     0.200
     0.042     1.533     0.200
     0.066     2.381     0.200
     0.108     1.532     0.200
     0.219     0.311     0.200
     0.203     1.632     0.200
     0.255     0.488     0.200
     0.265     0.263     0.200
     0.293     0.096     0.200
     0.084     2.405     0.200
     0.120    -0.084     0.200
     0.128     2.174     0.200
     0.155     0.302     0.200
     0.162     1.010     0.200
     0.136     2.027     0.200
     0.142     0.314     0.200
     0.154     1.553     0.200
     0.193     0.571     0.200
     0.210     1.374     0.200
     0.264     0.336     0.200
     0.217     1.601     0.200
     0.298     0.767     0.200
     0.295     0.036     0.200
     0.287    -1.177     0.200
     0.285     0.549     0.200
     1.182    -1.679     0.200
     2.597    -4.585     0.200
     0.050     2.778     0.200
     0.075     1.786     0.200
     0.062     1.799     0.200
     0.067     1.541     0.200
     0.079     2.548     0.200
     0.126     1.784     0.200
     0.220     0.803     0.200
     0.222    -0.269     0.200
     0.228     0.361     0.200
     0.208     1.815     0.200
     0.270     0.285     0.200
     0.353     0.252     0.200
     0.020     3.306     0.200
     0.104     1.550     0.200
     0.066     1.761     0.200
     0.044     2.353     0.200
     0.053     2.756     0.200
     0.069     2.358     0.200
     0.215     0.435     0.200
     0.207     1.695     0.200
     0.267     0.273     0.200
     0.293     0.062     0.200
     1.058    -0.070     0.200
     0.047     1.584     0.200
     0.047     2.980     0.200
     0.049     1.707     0.200
     0.072     2.397     0.200
     0.105     1.808     0.200
     0.210    -0.597     0.200
     0.215     0.468     0.200
     0.209     1.742     0.200
     0.249     0.371     0.200
     0.259     0.364     0.200
     0.286     0.113     0.200
     0.383     0.214     0.200
     1.064    -0.074     0.200
     2.024    -2.593     0.200
     2.557    -3.984     0.200
     0.014     1.831     0.200
     0.059     1.713     0.200
     0.057     2.285     0.200
     0.068     2.268     0.200
     0.103     1.415     0.200
     0.211    -0.529     0.200
     0.215    -0.002     0.200
     0.205     0.828     0.200
     0.264    -0.051     0.200
     0.273    -0.431     0.200
     1.171    -0.154     0.200
     0.029     2.466     0.200
     0.035     2.584     0.200
     0.069     0.518     0.200
     0.087     1.847     0.200
     0.108     1.282     0.200
     0.225     0.346     0.200
     0.205    -0.401     0.200
     0.211    -0.082     0.200
     0.205     1.087     0.200
     0.354    -0.615     0.200
     0.009     3.080     0.200
     0.041     2.264     0.200
     0.077     0.420     0.200
     0.073     2.010     0.200
     0.103     1.334     0.200
     0.070     2.416     0.200
     0.205     1.451     0.200
     0.214    -0.309     0.200
     0.216     0.162     0.200
     0.204     1.702     0.200
     0.286     0.467     0.200
     0.294    -0.042     0.200
     0.314    -0.179     0.200
     1.151     0.189     0.200
     2.059    -1.309     0.200
     2.562    -5.266     0.200
     2.695    -4.473     0.200
     2.762    -3.579     0.200
     2.059    -1.321     0.200
     2.950    -3.557     0.200
     0.009     2.037     0.200
     0.010     3.347     0.200
     0.060     1.229     0.200
     0.087     1.275     0.200
     0.088     0.831     0.200
     0.109     1.549     0.200
     0.180    -0.304     0.200
     0.186     0.055     0.200
     0.182     1.156     0.200
     0.222     0.266     0.200
     0.227     0.292     0.200
     0.247    -0.259     0.200
     0.244     0.766     0.200
     0.331    -0.585     0.200
     0.036     3.125     0.200
     0.038     1.545     0.200
     0.030     2.088     0.200
     0.062     1.188     0.200
     0.090     1.760     0.200
     0.086     2.078     0.200
     0.191     1.887     0.200
     0.194    -0.610     0.200
     0.199     0.437     0.200
     0.224     1.450     0.200
     0.248     0.580     0.200
     0.255     0.366     0.200
     0.277    -0.019     0.200
     0.357    -0.867     0.200
     1.134     0.404     0.200
     2.020    -2.090     0.200
     2.541    -3.609     0.200
     2.674    -4.830     0.200
     0.029     1.179     0.200
     0.062     2.042     0.200
     0.035     0.894     0.200
     0.078     1.040     0.200
     0.057     2.102     0.200
     0.112     1.563     0.200
     0.118     1.091     0.200
     0.186    -0.656     0.200
     0.194     0.770     0.200
     0.220     1.028     0.200
     0.228     0.079     0.200
     0.257     0.295     0.200
     0.268     0.000     0.200
     0.299    -0.302     0.200
     0.050     0.589     0.200
     0.050     1.751     0.200
     0.065     1.125     0.200
     0.025     0.986     0.200
     0.046     1.418     0.200
     0.107     1.684     0.200
     0.105     1.333     0.200
     0.070     2.136     0.200
     0.175    -0.624     0.200
     0.211    -1.005     0.200
     0.207     0.859     0.200
     0.215    -0.156     0.200
     0.253     0.459     0.200
     0.207     0.978     0.200
     0.263     0.126     0.200
     0.264     0.809     0.200
     0.289    -0.195     0.200
     0.049     1.367     0.200
     0.030     2.686     0.200
     0.142    -0.306     0.200
     0.144     1.082     0.200
     0.158    -0.305     0.200
     0.184     1.210     0.200
     0.119     1.503     0.200
     0.188     1.164     0.200
     0.243    -0.758     0.200
     0.291     0.484     0.200
     0.302    -0.015     0.200
     0.317    -0.145     0.200
     0.337     0.090     0.200
     0.378    -0.468     0.200
     0.076     2.307     0.200
     0.076     2.162     0.200
     0.054     2.500     0.200
     0.086     1.296     0.200
     0.133     1.655     0.200
     0.117     1.442     0.200
     0.117     1.661     0.200
     0.190     1.784     0.200
     0.278     0.166     0.200
     0.278     0.465     0.200
     0.289     0.457     0.200
     0.316     0.098     0.200
     0.412     0.154     0.200
     0.048     2.843     0.200
     0.063     1.114     0.200
     0.158    -0.001     0.200
     0.159     1.363     0.200
     0.114     2.577     0.200
     0.172     1.378     0.200
     0.202     1.219     0.200
     0.198     1.412     0.200
     0.312     0.528     0.200
     0.336     0.285     0.200
     0.356     0.148     0.200
     0.395     0.251     0.200
     0.465     0.446     0.200
     0.055     1.465     0.200
     0.036     3.036     0.200
     0.149     0.792     0.200
     0.151     0.915     0.200
     0.165    -0.003     0.200
     0.191     1.414     0.200
     0.194     1.215     0.200
     0.114     1.439     0.200
     0.248    -0.406     0.200
     0.297     1.309     0.200
     0.308    -0.118     0.200
     0.323     0.260     0.200
     0.343    -0.050     0.200
     0.365     0.905     0.200
     0.076     2.824     0.200
     0.116     2.101     0.200
     0.115     1.998     0.200
     0.091     1.365     0.200
     0.124     2.213     0.200
     0.226     0.785     0.200
     0.198     1.465     0.200
     0.252     0.337     0.200
     0.313     0.234     0.200
     0.300     0.431     0.200
     0.049     1.518     0.200
     0.049     2.102     0.200
     0.026     2.431     0.200
     0.047     1.657     0.200
     0.106     1.748     0.200
     0.105     1.243     0.200
     0.071     1.911     0.200
     0.175    -0.590     0.200
     0.210    -0.198     0.200
     0.207     0.410     0.200
     0.214    -0.339     0.200
     0.208     0.958     0.200
     0.252    -0.025     0.200
     0.048     2.516     0.200
     0.029     2.237     0.200
     0.048     1.717     0.200
     0.103     1.730     0.200
     0.071     2.317     0.200
     0.106     1.133     0.200
     0.177    -0.548     0.200
     0.210    -0.614     0.200
     0.215     0.331     0.200
     0.207     1.232     0.200
     0.249     0.148     0.200
     0.259     0.202     0.200
     0.208     0.931     0.200
     0.262     0.995     0.200
     0.018     2.987     0.200
     0.074     1.904     0.200
     0.079     1.434     0.200
     0.092     1.638     0.200
     0.055     1.416     0.200
     0.083     2.101     0.200
     0.144     1.234     0.200
     0.148    -0.262     0.200
     0.203    -1.494     0.200
     0.205     0.434     0.200
     0.216     1.085     0.200
     0.291     0.388     0.200
     0.014     3.040     0.200
     0.066     1.202     0.200
     0.124    -0.058     0.200
     0.149     0.534     0.200
     0.135    -0.286     0.200
     0.153     0.253     0.200
     0.165     0.066     0.200
     0.143     1.026     0.200
     0.211    -0.201     0.200
     0.225    -0.472     0.200
     0.229    -0.361     0.200
     0.022     1.696     0.200
     0.040     1.923     0.200
     0.091     1.325     0.200
     0.091     1.336     0.200
     0.110     1.413     0.200
     0.152     1.694     0.200
     0.212     1.491     0.200
     0.224    -0.188     0.200
     0.222    -0.819     0.200
     0.199     1.305     0.200
     0.289     1.060     0.200
     0.299     0.139     0.200
     0.307    -0.223     0.200
     0.328    -0.083     0.200
     2.073    -0.993     0.200
     2.570    -5.559     0.200
     0.057     2.531     0.200
     0.048     2.225     0.200
     0.065     0.975     0.200
     0.083     2.355     0.200
     0.107     1.165     0.200
     0.182    -0.665     0.200
     0.205     1.097     0.200
     0.211     0.026     0.200
     0.219     1.012     0.200
     0.229     0.147     0.200
     0.250     0.670     0.200
     0.239     0.053     0.200
     0.268    -0.404     0.200
     0.356    -0.932     0.200
     1.125     0.185     0.200
     2.549    -3.937     0.200
     0.058     0.816     0.200
     0.099     0.811     0.200
     0.167     0.149     0.200
     0.111     1.633     0.200
     0.192     1.134     0.200
     0.197     1.111     0.200
     0.251    -1.260     0.200
     0.311     0.599     0.200
     0.324    -0.075     0.200
     0.345    -0.294     0.200
     0.387    -0.009     0.200
     0.046     2.799     0.200
     0.022     2.302     0.200
     0.055     3.051     0.200
     0.110     1.527     0.200
     0.104     0.701     0.200
     0.120     1.902     0.200
     0.193     0.671     0.200
     0.200     0.454     0.200
     0.198     0.219     0.200
     0.197     0.575     0.200
     0.230     0.025     0.200
     0.226     0.630     0.200
     0.249     1.606     0.200
     0.036     1.981     0.200
     0.063     2.231     0.200
     0.108     1.398     0.200
     0.175     0.176     0.200
     0.211     2.034     0.200
     0.220     0.345     0.200
     0.200     1.378     0.200
     0.276     0.170     0.200
     0.383    -1.425     0.200
     2.042    -0.990     0.200
     2.565    -5.577     0.200
     2.744    -5.252     0.200
     0.046     2.582     0.200
     0.050     1.361     0.200
     0.073     2.230     0.200
     0.185     0.287     0.200
     0.212     0.355     0.200
     0.208    -0.450     0.200
     0.205     1.400     0.200
     0.210     1.587     0.200
     0.259     0.237     0.200
     0.250     0.861     0.200
     0.285     0.016     0.200
     0.369    -1.547     0.200
     0.385    -0.010     0.200
     2.555    -4.344     0.200
     0.007     3.573     0.200
     0.037     1.615     0.200
     0.065     2.617     0.200
     0.069     3.215     0.200
     0.075     1.917     0.200
     0.105     1.371     0.200
     0.166     1.031     0.200
     0.208     1.695     0.200
     0.202     1.886     0.200
     0.215    -1.016     0.200
     0.218     0.879     0.200
     0.275     0.675     0.200
     0.284     0.338     0.200
     0.307     0.125     0.200
     0.410     0.218     0.200
     1.113     0.009     0.200
     2.563    -2.971     0.200
     0.062     0.018     0.200
     0.078    -0.009     0.200
     0.224     1.286     0.200
     0.310    -0.042     0.200
     0.291    -0.162     0.200
     0.296    -0.213     0.200
     0.427     0.051     0.200
     1.090     0.323     0.200
     2.544    -3.779     0.200
     0.026     2.655     0.200
     0.019     2.567     0.200
     0.055     2.268     0.200
     0.055     2.667     0.200
     0.082     1.274     0.200
     0.081     2.097     0.200
     0.089     1.938     0.200
     0.167     0.481     0.200
     0.189     1.740     0.200
     0.220     1.284     0.200
     0.285     0.345     0.200
     0.295     0.233     0.200
     0.321    -0.090     0.200
     1.108     0.148     0.200
     0.033     2.381     0.200
     0.030     3.501     0.200
     0.036     2.360     0.200
     0.070     2.689     0.200
     0.095     2.227     0.200
     0.156     0.552     0.200
     0.191     0.563     0.200
     0.245     1.002     0.200
     0.232     1.829     0.200
     0.270     0.104     0.200
     0.056     2.104     0.200
     0.061     2.588     0.200
     0.026     2.396     0.200
     0.069     2.628     0.200
     0.098     1.713     0.200
     0.137    -0.083     0.200
     0.137     1.271     0.200
     0.148     0.828     0.200
     0.183     0.112     0.200
     0.176     0.449     0.200
     0.186     0.080     0.200
     0.234     1.056     0.200
     0.275     0.256     0.200
     0.291    -0.407     0.200
     0.361     0.082     0.200
     0.020     1.736     0.200
     0.059     2.136     0.200
     0.059     2.088     0.200
     0.038     0.649     0.200
     0.063     2.348     0.200
     0.176    -0.090     0.200
     0.180     0.060     0.200
     0.172     1.063     0.200
     0.211     0.550     0.200
     0.201     1.582     0.200
     0.216    -0.699     0.200
     0.220     0.525     0.200
     0.261     0.454     0.200
     0.298    -0.049     0.200
     0.036     2.727     0.200
     0.084     2.605     0.200
     0.089     1.664     0.200
     0.101     2.418     0.200
     0.117     2.241     0.200
     0.185     1.329     0.200
     0.192    -0.113     0.200
     0.194     0.822     0.200
     0.265     0.630     0.200
     0.232     2.166     0.200
     0.302     0.923     0.200
     0.315     0.407     0.200
     0.375     0.013     0.200
     1.203    -0.867     0.200
     2.375    -2.200     0.200
     2.539    -5.209     0.200
     2.671    -3.906     0.200
     2.845    -5.103     0.200
     2.376    -2.248     0.200
     2.925    -4.442     0.200
     0.044     2.822     0.200
     0.031     2.121     0.200
     0.053     0.826     0.200
     0.075     2.446     0.200
     0.177     0.960     0.200
     0.174    -0.382     0.200
     0.187    -0.028     0.200
     0.177     1.385     0.200
     0.207    -0.454     0.200
     0.204     0.432     0.200
     0.247     0.648     0.200
     0.212     1.590     0.200
     0.258     1.219     0.200
     0.282     0.323     0.200
     0.366    -1.207     0.200
     0.363    -0.169     0.200
     0.037     2.417     0.200
     0.071     1.952     0.200
     0.080     2.322     0.200
     0.085     1.300     0.200
     0.105     2.032     0.200
     0.127     0.668     0.200
     0.125     2.237     0.200
     0.116     1.617     0.200
     0.179     1.027     0.200
     0.187    -0.212     0.200
     0.188     0.380     0.200
     0.259     0.489     0.200
     0.236     1.647     0.200
     0.299     0.510     0.200
     0.310    -0.051     0.200
     0.369    -0.156     0.200
     2.065    -0.746     0.200
     2.534    -5.617     0.200
     0.028     3.280     0.200
     0.050     2.006     0.200
     0.068     0.923     0.200
     0.087     2.268     0.200
     0.168     1.198     0.200
     0.181    -0.252     0.200
     0.203    -0.458     0.200
     0.203     0.038     0.200
     0.209     0.376     0.200
     0.202     1.073     0.200
     0.190     1.499     0.200
     0.248     0.887     0.200
     0.265     0.288     0.200
     1.159     0.233     0.200
     2.002    -2.969     0.200
     2.546    -4.726     0.200
     2.680    -5.456     0.200
     0.028     2.459     0.200
     0.032     3.246     0.200
     0.054     2.324     0.200
     0.049     2.099     0.200
     0.068     1.891     0.200
     0.087     1.987     0.200
     0.167     1.250     0.200
     0.180    -0.398     0.200
     0.208     0.261     0.200
     0.202     1.136     0.200
     0.208     0.061     0.200
     0.189     1.182     0.200
     0.201     0.177     0.200
     0.189     1.284     0.200
     0.265     0.139     0.200
     0.350    -0.050     0.200
     0.075     2.332     0.200
     0.013     3.260     0.200
     0.076     1.674     0.200
     0.078     0.803     0.200
     0.049     2.712     0.200
     0.078     2.287     0.200
     0.154    -0.049     0.200
     0.142     1.832     0.200
     0.147     1.403     0.200
     0.198     1.294     0.200
     0.210     0.413     0.200
     0.313    -0.010     0.200
     0.313     0.427     0.200
     0.065     2.597     0.200
     0.049     3.661     0.200
     0.108     1.713     0.200
     0.114     2.339     0.200
     0.095     1.723     0.200
     0.184     1.739     0.200
     0.247     1.194     0.200
     0.255     0.270     0.200
     0.248     1.627     0.200
     0.251     1.894     0.200
     0.285     1.821     0.200
     0.291     0.356     0.200
     0.323     0.502     0.200
     0.325    -0.715     0.200
     0.423     0.347     0.200
     0.041     3.052     0.200
     0.044     2.062     0.200
     0.083     1.853     0.200
     0.026     2.954     0.200
     0.063     2.256     0.200
     0.165     1.270     0.200
     0.090     2.249     0.200
     0.190     0.159     0.200
     0.194     0.642     0.200
     0.185     1.700     0.200
     0.194     0.411     0.200
     0.157     1.213     0.200
     0.168     2.227     0.200
     0.247     0.745     0.200
     0.281     0.103     0.200
     1.173    -3.615     0.200
     2.538    -3.873     0.200
     2.606    -3.958     0.200
     3.503    -8.083     0.200
     0.023     2.504     0.200
     0.046     1.579     0.200
     0.072     0.957     0.200
     0.094     1.278     0.200
     0.094     1.606     0.200
     0.169     0.083     0.200
     0.179     0.548     0.200
     0.198    -0.087     0.200
     0.192    -0.256     0.200
     0.263    -0.204     0.200
     0.084     0.605     0.200
     0.171    -1.199     0.200
     0.187    -0.159     0.200
     0.230     0.686     0.200
     1.144    -0.284     0.200
     2.529    -3.686     0.200
     0.567     1.056     0.200
     3.062    -5.991     0.200
     0.688     0.633     0.200
     1.632     0.604     0.200
     1.861    -0.654     0.200
     2.470    -4.966     0.200
     2.381    -2.929     0.200
     1.168    -0.325     0.200
     2.134    -3.447     0.200
     2.429    -1.194     0.200
     3.036    -5.295     0.200
     3.408    -7.831     0.200
     0.842    -0.355     0.200
     1.538    -1.109     0.200
     1.788    -0.337     0.200
     2.280    -2.817     0.200
     2.362    -3.831     0.200
     0.773     0.194     0.200
     0.825     0.248     0.200
     1.715    -1.972     0.200
     2.374    -6.257     0.200
     2.459    -3.867     0.200
     0.997     0.602     0.200
     1.786    -1.179     0.200
     0.697     0.015     0.200
     1.760     0.608     0.200
     1.949    -1.191     0.200
     3.517    -4.156     0.200
     0.626     0.901     0.200
     0.609    -0.340     0.200
     0.950    -0.127     0.200
     2.187    -3.392     0.200
     2.181    -3.562     0.200
     2.265    -4.114     0.200
     0.610     1.625     0.200
     1.168    -0.489     0.200
     1.746     0.477     0.200
     1.950    -1.079     0.200
     2.175    -2.129     0.200
     2.672    -3.689     0.200
     2.699    -3.682     0.200
     2.840    -7.094     0.200
     3.173    -6.667     0.200
     0.486     1.189     0.200
     0.677     1.726     0.200
     2.312    -6.385     0.200
     2.513    -5.757     0.200
     2.414    -3.443     0.200
     0.209     2.127     0.200
     2.245    -4.254     0.200
     2.214    -2.190     0.200
     2.444    -2.557     0.200
     2.627    -5.171     0.200
     0.269     0.476     0.200
     1.311    -1.600     0.200
     2.012    -3.328     0.200
     2.181    -3.235     0.200
     2.572    -6.070     0.200
     2.741    -6.683     0.200
     2.774    -6.206     0.200
     3.001    -9.178     0.200
     3.507    -5.020     0.200
     0.766    -1.281     0.200
     2.030    -2.517     0.200
     3.694    -8.625     0.200
     4.400    -7.866     0.200
     4.536   -11.071     0.200
     0.677    -0.504     0.200
     1.207    -0.289     0.200
     0.388     0.587     0.200
     0.388     1.235     0.200
     0.956     0.628     0.200
     2.085    -0.660     0.200
     1.472    -2.451     0.200
     2.157    -2.362     0.200
     2.884    -7.310     0.200
     3.510    -9.545     0.200
     3.994   -10.913     0.200
     0.736     0.256     0.200
     1.991    -1.670     0.200
     0.465     0.433     0.200
     2.387    -5.788     0.200
     2.795    -6.173     0.200
     0.608     1.472     0.200
     1.759    -0.892     0.200
     2.072    -1.836     0.200
     2.157    -2.114     0.200
     2.398    -5.055     0.200
     2.613    -4.800     0.200
     1.724    -0.905     0.200
     1.866     0.399     0.200
     1.994    -2.273     0.200
     2.081    -3.034     0.200
     2.582    -6.301     0.200
     0.521    -1.528     0.200
     1.246    -1.245     0.200
     2.137    -1.534     0.200
     2.711    -3.903     0.200
     1.881    -2.483     0.200
     2.151    -4.309     0.200
     0.786     0.634     0.200
     1.765    -1.773     0.200
     1.874    -2.708     0.200
     1.988    -0.933     0.200
     2.307    -3.499     0.200
     0.525     1.636     0.200
     2.254    -4.006     0.200
     1.879    -2.403     0.200
     2.288    -4.169     0.200
     0.675     0.851     0.200
     1.282    -0.509     0.200
     2.290    -3.221     0.200
     0.627     0.874     0.200
     0.605     1.679     0.200
     1.179    -1.654     0.200
     1.652    -0.261     0.200
     0.577     0.125     0.200
     0.643    -0.419     0.200
     1.303    -0.574     0.200
     2.297    -3.459     0.200
     0.327     1.211     0.200
     1.350    -1.680     0.200
     2.521    -3.980     0.200
     2.533    -3.170     0.200
     3.490    -4.880     0.200
     0.653     1.041     0.200
     2.142    -0.732     0.200
     0.687     0.851     0.200
     2.212    -4.387     0.200
     0.676     0.037     0.200
     2.269    -2.146     0.200
     2.442    -1.930     0.200
     0.391    -0.446     0.200
     2.185    -2.878     0.200
     0.575    -1.350     0.200
     0.649     0.823     0.200
     1.087    -0.994     0.200
     1.857    -0.308     0.200
     2.290    -4.545     0.200
     0.476     1.168     0.200
     2.103    -4.120     0.200
     0.503     1.130     0.200
     0.606     0.167     0.200
     1.761    -1.168     0.200
     1.761    -0.199     0.200
     2.826    -6.436     0.200
     4.015    -7.618     0.200
     0.241     1.557     0.200
     1.913    -3.093     0.200
     1.924    -4.130     0.200
     1.812    -4.078     0.200
     2.044    -5.176     0.200
     2.583    -6.262     0.200
     0.602     0.460     0.200
     2.107    -3.514     0.200
     2.107    -0.967     0.200
     4.683   -11.611     0.200
     2.091    -1.027     0.200
     2.115    -5.798     0.200
     3.096    -6.060     0.200
     3.096    -5.920     0.200
     0.851    -0.498     0.200
     2.435    -5.134     0.200
     2.506    -6.341     0.200
     0.769    -0.107     0.200
     2.025    -3.397     0.200
     0.718     1.883     0.200
     0.839     1.020     0.200
     1.750    -0.272     0.200
     1.979    -0.990     0.200
     2.497    -5.828     0.200
     2.565    -6.784     0.200
     0.210     1.453     0.200
     2.632    -5.815     0.200
     0.887    -0.622     0.200
     0.943     0.400     0.200
     1.199    -0.684     0.200
     1.623    -1.311     0.200
     1.812    -1.716     0.200
     2.047    -2.648     0.200
     0.604    -1.489     0.200
     0.673     0.739     0.200
     0.969     1.391     0.200
     1.650     0.788     0.200
     2.110    -1.360     0.200
     2.200    -1.634     0.200
     2.212    -4.623     0.200
     3.355    -7.367     0.200
     2.238    -3.512     0.200
     0.641     0.988     0.200
     2.237    -4.176     0.200
     0.655     0.777     0.200
     2.115    -4.263     0.200
     2.439    -6.820     0.200
     2.719    -6.447     0.200
     0.325     0.236     0.200
     2.953    -5.595     0.200
     2.976    -7.143     0.200
     0.484    -0.091     0.200
     1.681    -0.621     0.200
     0.924    -0.677     0.200
     2.081    -3.435     0.200
     3.284    -4.709     0.200
     1.232    -0.475     0.200
     2.472    -3.743     0.200
     0.606    -0.310     0.200
     0.707     0.644     0.200
     1.620    -0.424     0.200
     2.183    -4.800     0.200
     0.655    -0.162     0.200
     0.804     0.313     0.200
     2.329    -3.888     0.200
     2.442    -4.046     0.200
     2.494    -6.746     0.200
     2.494    -5.195     0.200
     0.979    -0.205     0.200
     1.504    -1.631     0.200
     2.471    -3.086     0.200
     0.219     1.108     0.200
     0.240     0.808     0.200
     0.317     0.854     0.200
     0.338     0.753     0.200
     0.377     0.794     0.200
     0.576     0.693     0.200
     0.689     0.376     0.200
     0.689     1.197     0.200
     0.889     1.120     0.200
     1.032     1.088     0.200
     0.235     2.056     0.200
     0.261     1.565     0.200
     0.291     1.203     0.200
     0.363     1.290     0.200
     0.112     2.240     0.200
     0.248     1.549     0.200
     0.392     1.402     0.200
     0.419     0.903     0.200
     0.468     0.934     0.200
     0.495     1.161     0.200
     0.494     0.849     0.200
     0.596     0.773     0.200
     0.609     1.239     0.200
     0.630     1.062     0.200
     0.669     0.941     0.200
     0.804     1.008     0.200
     0.833     1.119     0.200
     0.832     1.148     0.200
     0.945     1.120     0.200
     1.035     0.597     0.200
     0.468    -0.422     0.200
     1.826    -0.190     0.200
     0.103     2.663     0.200
     0.117     2.317     0.200
     0.396     0.984     0.200
     0.420     1.279     0.200
     0.474     0.979     0.200
     0.494     0.961     0.200
     0.495     0.810     0.200
     0.599     0.878     0.200
     0.614     1.282     0.200
     0.635     1.515     0.200
     0.670     0.650     0.200
     0.205     1.156     0.200
     0.205     1.237     0.200
     0.280     0.980     0.200
     0.330     0.833     0.200
     0.329     1.009     0.200
     0.384     1.062     0.200
     0.513     1.112     0.200
     0.539     0.544     0.200
     0.554     0.828     0.200
     0.582     0.781     0.200
     0.653     1.213     0.200
     0.161     1.229     0.200
     0.181     1.171     0.200
     0.305     0.748     0.200
     0.401     0.986     0.200
     0.636     0.657     0.200
     0.651     0.744     0.200
     0.783     1.198     0.200
     0.114     1.466     0.200
     0.180     0.928     0.200
     0.199     0.665     0.200
     0.266     0.844     0.200
     0.492     0.839     0.200
     0.554     0.612     0.200
     0.702     0.609     0.200
     0.715     0.519     0.200
     0.949     0.820     0.200
     1.001     0.996     0.200
     0.998     1.157     0.200
     1.122    -0.486     0.200
     0.071     2.747     0.200
     0.235     0.471     0.200
     0.325     0.571     0.200
     0.404     0.646     0.200
     0.470     1.131     0.200
     0.611     0.965     0.200
     0.676     0.598     0.200
     0.827     0.702     0.200
     0.863     0.606     0.200
     1.087    -0.712     0.200
     1.098     0.614     0.200
     0.248     0.055     0.200
     0.266     0.791     0.200
     0.358    -0.215     0.200
     0.465     0.795     0.200
     0.717     0.694     0.200
     0.864     0.958     0.200
     0.879     0.247     0.200
     1.285    -0.122     0.200
     0.976     1.538     0.200
     1.419    -0.916     0.200
     1.511    -2.258     0.200
     1.766    -0.707     0.200
     2.042    -0.311     0.200
     2.105    -0.669     0.200
     2.465    -2.923     0.200
     2.517    -4.416     0.200
     2.626    -5.598     0.200
     2.626    -3.372     0.200
     3.434    -8.795     0.200
     0.052     1.219     0.200
     0.200     0.457     0.200
     0.340    -0.313     0.200
     0.339    -0.214     0.200
     0.377     0.076     0.200
     0.766     0.720     0.200
     1.197     1.067     0.200
     1.223     1.201     0.200
     1.224     0.914     0.200
     1.290     0.192     0.200
     0.206     0.588     0.200
     0.224     0.727     0.200
     0.268     0.569     0.200
     0.307     0.500     0.200
     0.329     0.787     0.200
     0.366     0.386     0.200
     0.560     0.586     0.200
     0.639     0.693     0.200
     0.700     0.661     0.200
     0.904     0.679     0.200
     0.164     0.721     0.200
     0.180     0.512     0.200
     0.209     0.230     0.200
     0.356     0.391     0.200
     0.441     0.811     0.200
     0.623     0.909     0.200
     0.692     0.676     0.200
     1.018     0.530     0.200
     1.022     1.274     0.200
     0.287     1.118     0.200
     0.336     0.837     0.200
     0.361     0.591     0.200
     0.362     0.977     0.200
     0.409     1.163     0.200
     0.461     1.176     0.200
     0.575     0.996     0.200
     0.600     0.832     0.200
     0.624     1.009     0.200
     0.623     0.937     0.200
     0.673     0.807     0.200
     0.763     1.020     0.200
     0.780     1.258     0.200
     0.817     1.157     0.200
     0.197     0.269     0.200
     0.150     1.989     0.200
     0.231     0.931     0.200
     0.308    -0.024     0.200
     0.440     0.893     0.200
     0.676     0.568     0.200
     0.830     0.425     0.200
     0.824     0.571     0.200
     1.113     0.683     0.200
     0.955     0.511     0.200
     1.384    -1.234     0.200
     1.475    -2.512     0.200
     1.777    -0.230     0.200
     2.477    -4.217     0.200
     2.943    -7.050     0.200
     0.176     0.662     0.200
     0.159     1.489     0.200
     0.220     0.959     0.200
     0.288     0.500     0.200
     0.660     0.625     0.200
     0.810     0.545     0.200
     0.809     0.931     0.200
     1.214     0.022     0.200
     0.378    -0.887     0.200
     1.371    -1.940     0.200
     1.780    -0.193     0.200
     0.192     1.543     0.200
     0.207     1.889     0.200
     0.350     1.021     0.200
     0.351     0.923     0.200
     0.430     0.765     0.200
     0.463     1.342     0.200
     0.543     0.741     0.200
     0.546     0.771     0.200
     0.624     0.561     0.200
     0.649     0.691     0.200
     0.693     0.834     0.200
     0.747     0.156     0.200
     0.753     0.406     0.200
     0.764     1.234     0.200
     0.415     0.456     0.200
     0.420    -0.059     0.200
     0.457     0.811     0.200
     0.556     0.728     0.200
     0.581     0.564     0.200
     0.631     0.976     0.200
     0.737     0.565     0.200
     1.079     0.784     0.200
     0.309     0.492     0.200
     0.317     0.149     0.200
     0.328     0.869     0.200
     0.355     0.466     0.200
     0.408     0.387     0.200
     0.478     0.591     0.200
     0.538    -0.030     0.200
     0.578     0.486     0.200
     0.677     0.712     0.200
     0.775     0.160     0.200
     0.773     0.716     0.200
     0.106     2.256     0.200
     0.163     2.014     0.200
     0.259     1.039     0.200
     0.337     1.081     0.200
     0.352     1.139     0.200
     0.540     0.947     0.200
     0.598     1.427     0.200
     0.625     1.185     0.200
     0.652     1.301     0.200
     0.136     1.494     0.200
     0.246     1.562     0.200
     0.286     1.205     0.200
     0.374     1.042     0.200
     0.397     0.904     0.200
     0.461     0.787     0.200
     0.490     0.772     0.200
     0.531     0.961     0.200
     0.536     0.782     0.200
     0.640     0.783     0.200
     0.639     0.771     0.200
     0.666     1.490     0.200
     0.712     0.262     0.200
     0.711     0.571     0.200
     0.858     0.538     0.200
     0.205     0.640     0.200
     0.197     1.281     0.200
     0.404     0.889     0.200
     0.402     0.434     0.200
     0.410     0.568     0.200
     0.474     0.769     0.200
     0.570     0.929     0.200
     0.672     0.464     0.200
     0.697     0.742     0.200
     0.727     1.057     0.200
     0.774     0.726     0.200
     0.882    -0.640     0.200
     0.931     0.777     0.200
     0.295     0.435     0.200
     0.299     0.215     0.200
     0.348     0.370     0.200
     0.368     0.295     0.200
     0.395     0.407     0.200
     0.471     0.683     0.200
     0.500     0.610     0.200
     0.541     0.126     0.200
     0.575     0.516     0.200
     0.575     0.250     0.200
     0.666     0.463     0.200
     0.730     0.788     0.200
     0.758     1.243     0.200
     0.774     0.340     0.200
     0.831     1.146     0.200
     0.917     0.872     0.200
     1.099     1.246     0.200
     0.285     0.808     0.200
     0.290     1.089     0.200
     0.331     0.579     0.200
     0.355     0.622     0.200
     0.374     0.926     0.200
     0.453     0.764     0.200
     0.478     0.731     0.200
     0.524     0.380     0.200
     0.555     0.448     0.200
     0.557     0.581     0.200
     0.585     0.384     0.200
     0.645     0.781     0.200
     0.643     0.812     0.200
     0.709     0.744     0.200
     0.737     0.994     0.200
     0.785     0.496     0.200
     0.836    -0.118     0.200
     0.810     1.222     0.200
     0.932     1.352     0.200
     1.109     0.933     0.200
     0.277     0.905     0.200
     0.285     1.218     0.200
     0.327     0.802     0.200
     0.347     0.496     0.200
     0.367     1.117     0.200
     0.449     0.865     0.200
     0.471     1.000     0.200
     0.517     0.685     0.200
     0.548     0.591     0.200
     0.585     1.085     0.200
     0.639     0.445     0.200
     0.700     0.504     0.200
     0.729     0.931     0.200
     0.827     0.098     0.200
     0.178     0.781     0.200
     0.169     1.660     0.200
     0.281     0.672     0.200
     0.438     0.303     0.200
     0.652     0.877     0.200
     0.804     0.525     0.200
     0.800     0.406     0.200
     1.043     1.066     0.200
     1.208     0.188     0.200
     0.078     2.682     0.200
     0.161     1.245     0.200
     0.251     1.158     0.200
     0.299     0.956     0.200
     0.317     0.927     0.200
     0.458     0.757     0.200
     0.473     0.866     0.200
     0.517     1.697     0.200
     0.526     0.627     0.200
     0.555     0.598     0.200
     0.569     1.226     0.200
     0.689     0.753     0.200
     0.148     2.380     0.200
     0.290     0.581     0.200
     0.295     0.775     0.200
     0.290     0.874     0.200
     0.579     0.138     0.200
     0.596     0.411     0.200
     0.739     0.137     0.200
     0.745     0.165     0.200
     0.787     0.793     0.200
     1.005     0.201     0.200
     0.235     1.829     0.200
     0.295     1.553     0.200
     0.301     0.923     0.200
     0.419     1.717     0.200
     0.444     1.310     0.200
     0.479     0.687     0.200
     0.541     0.782     0.200
     0.611     0.846     0.200
     0.652     0.697     0.200
     0.670     0.855     0.200
     0.707     1.001     0.200
     0.758     1.475     0.200
     0.772     0.977     0.200
     0.809     0.724     0.200
     0.939    -0.219     0.200
     0.942     0.732     0.200
     0.125     1.538     0.200
     0.222     1.382     0.200
     0.287     1.060     0.200
     0.291     1.048     0.200
     0.308     0.712     0.200
     0.322     1.000     0.200
     0.353     1.219     0.200
     0.426     1.360     0.200
     0.624     0.457     0.200
     0.664     0.685     0.200
     0.713     0.755     0.200
     0.801     0.786     0.200
     0.192     1.627     0.200
     0.236     1.689     0.200
     0.285     1.230     0.200
     0.311     1.543     0.200
     0.347     1.007     0.200
     0.357     0.998     0.200
     0.362     1.185     0.200
     0.503     0.864     0.200
     0.518     0.896     0.200
     0.595     0.865     0.200
     0.606     0.832     0.200
     0.680     1.065     0.200
     0.706     0.809     0.200
     0.076     2.884     0.200
     0.197     0.656     0.200
     0.333     0.125     0.200
     0.401     0.608     0.200
     0.452     0.570     0.200
     0.543     0.940     0.200
     0.550     0.512     0.200
     0.607     1.204     0.200
     0.812     0.623     0.200
     0.811     1.202     0.200
     0.822     0.691     0.200
     0.930     1.075     0.200
     1.071     0.302     0.200
     1.095     0.475     0.200
     1.142     0.022     0.200
     0.291     1.992     0.200
     0.320     1.757     0.200
     0.383     1.144     0.200
     0.397     1.487     0.200
     0.443     1.338     0.200
     0.495     1.939     0.200
     0.520     1.544     0.200
     0.543     0.967     0.200
     0.538     0.518     0.200
     0.547     1.472     0.200
     0.605     0.769     0.200
     0.700     1.089     0.200
     0.715     0.815     0.200
     0.733     0.936     0.200
     0.772     1.060     0.200
     0.805     0.699     0.200
     0.871     0.189     0.200
     0.114     1.342     0.200
     0.152     1.384     0.200
     0.222     0.822     0.200
     0.326     1.202     0.200
     0.339     0.585     0.200
     0.377     1.073     0.200
     0.527     1.189     0.200
     0.612     0.979     0.200
     0.644     1.142     0.200
     0.753     0.649     0.200
     1.115     0.667     0.200
     0.775     1.095     0.200
     0.864     0.728     0.200
     1.760    -4.130     0.200
     1.850    -3.819     0.200
     2.247    -2.599     0.200
     2.560    -7.933     0.200
     2.563    -4.102     0.200
     3.077    -8.223     0.200
     3.077    -7.652     0.200
     0.580     0.854     0.200
     0.991     1.004     0.200
     2.180    -2.675     0.200
     2.214    -4.475     0.200
     2.685    -6.278     0.200
     0.183     0.271     0.200
     0.267     0.295     0.200
     0.284     0.280     0.200
     0.318     0.092     0.200
     0.357    -0.038     0.200
     0.635     0.142     0.200
     0.779     0.684     0.200
     0.783     0.272     0.200
     0.820     0.207     0.200
     0.856     0.373     0.200
     0.894     0.365     0.200
     0.891     0.846     0.200
     0.936     0.947     0.200
     1.042     0.511     0.200
     1.031     0.724     0.200
     1.055     0.692     0.200
     1.155     0.946     0.200
     0.115     2.130     0.200
     0.216     0.589     0.200
     0.235     1.415     0.200
     0.252     1.237     0.200
     0.393     0.593     0.200
     0.421     0.568     0.200
     0.472     0.680     0.200
     0.599     0.371     0.200
     0.613     0.499     0.200
     0.634     1.043     0.200
     0.671     0.654     0.200
     0.670     1.324     0.200
     0.685     0.877     0.200
     0.882     0.567     0.200
     0.949     1.240     0.200
     1.008     0.588     0.200
     1.597     0.550     0.200
     1.656    -1.490     0.200
     1.687    -0.590     0.200
     0.180     0.956     0.200
     0.309    -0.041     0.200
     0.282     0.968     0.200
     0.321     0.357     0.200
     0.322     0.580     0.200
     0.335     0.510     0.200
     0.380     1.276     0.200
     0.422     0.415     0.200
     0.488    -0.257     0.200
     0.473     0.560     0.200
     0.489     0.940     0.200
     0.572     0.962     0.200
     0.665     0.612     0.200
     0.912     0.593     0.200
     1.051     0.317     0.200
     1.219     0.544     0.200
     1.241     0.798     0.200
     0.219     0.866     0.200
     0.300     0.896     0.200
     0.368    -0.067     0.200
     0.364     0.201     0.200
     0.442     0.888     0.200
     0.539     0.372     0.200
     0.584     0.654     0.200
     0.737     0.107     0.200
     0.813     0.203     0.200
     0.963     1.082     0.200
     1.063     0.415     0.200
     1.666     0.175     0.200
     1.753     0.186     0.200
     1.770     0.174     0.200
     0.792    -1.107     0.200
     1.930    -1.264     0.200
     2.489    -2.839     0.200
     2.714    -2.918     0.200
     0.154     1.009     0.200
     0.192     0.527     0.200
     0.247     0.477     0.200
     0.325     0.231     0.200
     0.684     0.950     0.200
     0.702    -0.052     0.200
     0.745     0.242     0.200
     0.749    -0.103     0.200
     0.745     0.680     0.200
     0.803     0.255     0.200
     0.834    -0.098     0.200
     0.899     0.281     0.200
     0.998     0.153     0.200
     1.037     1.068     0.200
     0.147     1.636     0.200
     0.155     1.805     0.200
     0.228     0.642     0.200
     0.402     0.374     0.200
     0.502     0.671     0.200
     0.593     0.549     0.200
     0.660     1.318     0.200
     0.681    -0.079     0.200
     0.740     0.494     0.200
     0.772     0.391     0.200
     0.784     0.548     0.200
     0.799     0.086     0.200
     0.807     0.626     0.200
     0.882     0.941     0.200
     0.937     1.191     0.200
     1.044     0.124     0.200
     1.201    -0.561     0.200
     0.072     1.042     0.200
     0.233     0.807     0.200
     0.277     0.117     0.200
     0.351     0.063     0.200
     0.372     0.765     0.200
     0.396     0.657     0.200
     0.418     0.889     0.200
     0.455    -0.105     0.200
     0.470    -0.146     0.200
     0.539     0.422     0.200
     0.545     1.362     0.200
     0.686     0.446     0.200
     0.736     1.499     0.200
     0.870     0.396     0.200
     0.977     0.487     0.200
     1.212    -0.110     0.200
     0.090     2.272     0.200
     0.194     1.018     0.200
     0.290     0.846     0.200
     0.301     1.285     0.200
     0.329     0.777     0.200
     0.458     0.317     0.200
     0.511     1.082     0.200
     0.679     0.629     0.200
     0.692     0.324     0.200
     0.697     0.564     0.200
     0.698     0.991     0.200
     0.723     1.323     0.200
     0.854     1.274     0.200
     0.974     1.003     0.200
     0.105     1.330     0.200
     0.176     0.834     0.200
     0.320     0.800     0.200
     0.450     0.748     0.200
     0.493     0.637     0.200
     0.679     0.450     0.200
     0.688     0.411     0.200
     0.700     0.219     0.200
     0.717     0.349     0.200
     0.835     1.079     0.200
     0.160     1.391     0.200
     0.269     0.480     0.200
     0.255     1.370     0.200
     0.369     0.068     0.200
     0.430     0.843     0.200
     0.467     0.311     0.200
     0.469     1.248     0.200
     0.467     1.302     0.200
     0.476     1.464     0.200
     0.705    -0.222     0.200
     0.997     0.324     0.200
     1.214     0.166     0.200
     1.955    -0.669     0.200
     0.117     0.682     0.200
     0.162     0.816     0.200
     0.182     0.459     0.200
     0.334     0.389     0.200
     0.444     0.055     0.200
     0.479     0.632     0.200
     0.668     0.542     0.200
     0.665     0.906     0.200
     0.686     0.198     0.200
     0.694     1.160     0.200
     0.701    -0.279     0.200
     0.711     0.107     0.200
     0.751     0.329     0.200
     0.821     0.761     0.200
     0.998     1.397     0.200
     0.173     0.914     0.200
     0.309    -0.483     0.200
     0.288     0.574     0.200
     0.309     0.912     0.200
     0.314     0.289     0.200
     0.377     1.148     0.200
     0.404     0.202     0.200
     0.458     0.513     0.200
     0.479    -0.228     0.200
     0.489     0.777     0.200
     0.559     0.657     0.200
     0.648    -0.033     0.200
     0.688     0.638     0.200
     0.658     1.139     0.200
     0.707     0.436     0.200
     0.813     0.266     0.200
     0.827     0.289     0.200
     0.870     0.106     0.200
     0.895     0.004     0.200
     1.038     1.134     0.200
     1.087     0.538     0.200
     1.177    -0.347     0.200
     1.211     0.702     0.200
     1.234     0.509     0.200
     1.678     0.380     0.200
     1.693     0.302     0.200
     1.737    -0.091     0.200
     1.820    -0.464     0.200
     1.873     0.002     0.200
     1.896     0.000     0.200
     0.860     1.858     0.200
     1.896    -2.300     0.200
     2.055    -2.654     0.200
     2.020     0.382     0.200
     2.450    -5.233     0.200
     2.501    -3.141     0.200
     0.157     1.700     0.200
     0.179     1.199     0.200
     0.269     1.752     0.200
     0.338     0.340     0.200
     0.338     0.777     0.200
     0.546     0.982     0.200
     0.686     0.898     0.200
     0.694     1.053     0.200
     0.699     1.105     0.200
     0.707     0.036     0.200
     0.707     1.552     0.200
     0.746     0.905     0.200
     0.753     0.356     0.200
     0.790     0.262     0.200
     0.817     0.471     0.200
     0.101     1.557     0.200
     0.234     1.216     0.200
     0.221     0.803     0.200
     0.523     0.347     0.200
     0.530     0.680     0.200
     0.535     0.878     0.200
     0.559     0.587     0.200
     0.587     0.737     0.200
     0.730     0.809     0.200
     0.739     0.577     0.200
     0.755     0.603     0.200
     0.768     0.056     0.200
     0.801     0.236     0.200
     0.856     1.061     0.200
     0.910     0.625     0.200
     0.905     0.531     0.200
     1.057     0.848     0.200
     1.140     0.402     0.200
     1.166     0.305     0.200
     0.117     2.958     0.200
     0.179     2.954     0.200
     0.256     1.979     0.200
     0.310     1.096     0.200
     0.338     1.287     0.200
     0.390     0.984     0.200
     0.424     1.271     0.200
     0.413     1.885     0.200
     0.460     0.884     0.200
     0.584     0.505     0.200
     0.869     0.390     0.200
     0.881     0.189     0.200
     1.062    -0.170     0.200
     1.606    -1.206     0.200
     1.997    -2.166     0.200
     2.035    -2.506     0.200
     2.206    -3.353     0.200
     0.170     1.360     0.200
     0.275     0.561     0.200
     0.262     1.125     0.200
     0.359     0.178     0.200
     0.437     0.070     0.200
     0.461    -0.254     0.200
     0.470     0.474     0.200
     0.478     0.652     0.200
     0.537    -0.735     0.200
     0.537    -0.156     0.200
     0.687     0.904     0.200
     0.956     0.259     0.200
     1.051     0.485     0.200
     1.214    -0.087     0.200
     1.790    -0.732     0.200
     1.952    -1.190     0.200
     2.045    -1.497     0.200
     2.114    -1.851     0.200
     0.207     0.018     0.200
     0.234     1.090     0.200
     0.323     0.571     0.200
     0.381     0.654     0.200
     0.441     0.832     0.200
     0.534     0.230     0.200
     0.541     0.934     0.200
     0.693     0.622     0.200
     0.797     0.718     0.200
     0.821     0.118     0.200
     0.847     1.433     0.200
     1.006     0.134     0.200
     1.014     0.051     0.200
     1.067    -0.341     0.200
     1.052     1.613     0.200
     0.033     2.405     0.200
     0.154     1.593     0.200
     0.320     0.155     0.200
     0.370    -0.256     0.200
     0.387     0.265     0.200
     0.476     1.303     0.200
     0.763    -0.544     0.200
     0.974    -0.537     0.200
     1.089     1.185     0.200
     1.119     0.037     0.200
     1.277     0.408     0.200
     1.715     0.011     0.200
     1.909    -0.632     0.200
     1.966    -0.692     0.200
     2.117    -1.044     0.200
     0.172     1.451     0.200
     0.279     0.296     0.200
     0.300     0.672     0.200
     0.295     1.123     0.200
     0.339     1.010     0.200
     0.382     1.426     0.200
     0.461    -0.372     0.200
     0.440     0.833     0.200
     0.499     0.810     0.200
     0.546     0.833     0.200
     0.625     0.784     0.200
     0.666    -0.524     0.200
     0.671    -0.295     0.200
     0.656     1.537     0.200
     0.709     1.073     0.200
     0.821     0.302     0.200
     0.816     0.784     0.200
     0.866     0.390     0.200
     0.869     0.056     0.200
     1.013     1.076     0.200
     1.070    -0.241     0.200
     1.156    -0.063     0.200
     1.217     0.240     0.200
     1.862     0.343     0.200
     0.095     5.790     0.200
     0.211     4.454     0.200
     0.286     3.312     0.200
     0.331     3.416     0.200
     0.349     2.768     0.200
     0.368     2.970     0.200
     0.510     1.711     0.200
     0.526     0.877     0.200
     0.539     1.737     0.200
     0.533     2.079     0.200
     0.587     2.293     0.200
     0.628     1.460     0.200
     0.618     1.657     0.200
     0.674     1.086     0.200
     0.690     0.874     0.200
     0.759     0.181     0.200
     1.216    -0.395     0.200
     1.455    -0.767     0.200
     1.516    -0.847     0.200
     1.542    -0.725     0.200
     1.926    -2.512     0.200
     0.157     0.468     0.200
     0.158     1.311     0.200
     0.237     1.060     0.200
     0.297     0.389     0.200
     0.364    -0.187     0.200
     0.361     0.106     0.200
     0.456     0.426     0.200
     0.494    -0.233     0.200
     0.467     0.590     0.200
     0.488     1.003     0.200
     0.711     1.125     0.200
     0.734    -0.074     0.200
     1.079    -0.139     0.200
     1.091     1.405     0.200
     1.135     0.724     0.200
     1.343     0.198     0.200
     0.096     1.071     0.200
     0.113     1.449     0.200
     0.258     0.891     0.200
     0.327     0.465     0.200
     0.413     0.130     0.200
     0.412     1.643     0.200
     0.420     1.014     0.200
     0.438     1.056     0.200
     0.480     0.094     0.200
     0.526     1.208     0.200
     0.671     1.250     0.200
     0.738     0.086     0.200
     1.035     1.105     0.200
     0.037     3.250     0.200
     0.280     0.564     0.200
     0.390     1.053     0.200
     0.422     0.578     0.200
     0.560     0.982     0.200
     0.584     0.001     0.200
     0.826     1.599     0.200
     0.872     1.166     0.200
     0.917     0.709     0.200
     0.966     0.239     0.200
     0.970     0.972     0.200
     0.187     0.919     0.200
     0.226     0.742     0.200
     0.256     0.240     0.200
     0.333     0.682     0.200
     0.401     0.670     0.200
     0.501     0.583     0.200
     0.554     0.660     0.200
     0.704     0.513     0.200
     0.826    -0.252     0.200
     0.832     0.710     0.200
     0.851     0.822     0.200
     0.861    -0.024     0.200
     0.876     0.363     0.200
     0.893     1.370     0.200
     0.971     1.163     0.200
     1.094     0.903     0.200
     1.111     0.688     0.200
     1.136     0.603     0.200
     1.259    -0.647     0.200
     0.037     2.308     0.200
     0.214     0.987     0.200
     0.537     0.912     0.200
     0.691     0.146     0.200
     0.813    -0.013     0.200
     0.834     0.365     0.200
     0.910     0.031     0.200
     0.968     0.684     0.200
     1.040     0.400     0.200
     1.179     0.434     0.200
     1.730     0.398     0.200
     1.794    -0.201     0.200
     1.808    -0.010     0.200
     1.956    -0.915     0.200
     1.995    -1.035     0.200
     2.165    -1.531     0.200
     2.201    -1.483     0.200
     0.098     0.319     0.200
     0.250    -0.103     0.200
     0.410     0.195     0.200
     0.454    -0.711     0.200
     0.447     0.610     0.200
     0.449     1.465     0.200
     0.547     1.834     0.200
     0.664     0.097     0.200
     1.067     0.226     0.200
     1.103    -0.216     0.200
     1.206    -0.411     0.200
     1.384     0.150     0.200
     1.461     0.392     0.200
     1.779     0.321     0.200
     1.783     0.213     0.200
     1.788    -0.018     0.200
     1.800     0.339     0.200
     1.852    -0.135     0.200
     2.056    -0.260     0.200
     0.203     0.452     0.200
     0.318     0.486     0.200
     0.318     0.355     0.200
     0.412    -0.087     0.200
     0.505    -0.510     0.200
     0.589     0.862     0.200
     0.610    -0.245     0.200
     0.730     0.924     0.200
     0.739     0.049     0.200
     0.788     0.056     0.200
     0.825     1.935     0.200
     0.911     0.935     0.200
     0.971     0.157     0.200
     0.997     0.812     0.200
     0.098     2.267     0.200
     0.077     3.565     0.200
     0.159     1.019     0.200
     0.351     0.507     0.200
     0.300     1.335     0.200
     0.349     2.116     0.200
     0.428     0.972     0.200
     0.461     1.165     0.200
     0.480     1.619     0.200
     0.490     0.784     0.200
     0.569     0.176     0.200
     0.611    -0.234     0.200
     0.747     0.577     0.200
     0.879    -0.610     0.200
     1.076    -0.247     0.200
     1.604    -1.342     0.200
     1.633    -0.915     0.200
     1.941    -1.910     0.200
     1.961    -2.145     0.200
     2.024    -1.947     0.200
     2.121    -2.787     0.200
     2.226    -2.549     0.200
     2.284    -2.698     0.200
     0.594     1.315     0.200
     2.098    -0.927     0.200
     2.295    -5.249     0.200
     2.372    -5.192     0.200
     2.430    -5.822     0.200
     0.057     5.875     0.200
     0.155     4.102     0.200
     0.221     3.728     0.200
     0.287     2.639     0.200
     0.318     2.574     0.200
     0.339     2.118     0.200
     0.418     2.044     0.200
     0.471     1.407     0.200
     0.545     1.411     0.200
     0.619     0.470     0.200
     0.623     1.060     0.200
     0.638     1.079     0.200
     0.698     1.137     0.200
     0.707     0.450     0.200
     0.783    -0.679     0.200
     0.794    -0.290     0.200
     1.366    -0.802     0.200
     1.402    -1.012     0.200
     1.477    -0.975     0.200
     1.716    -2.081     0.200
     1.774    -2.390     0.200
     1.809    -2.152     0.200
     2.078    -4.410     0.200
     0.241     1.918     0.200
     0.277     2.340     0.200
     0.349     1.125     0.200
     0.345     1.452     0.200
     0.422     0.577     0.200
     0.404     1.611     0.200
     0.482     1.347     0.200
     0.577    -0.243     0.200
     0.550     1.104     0.200
     0.853     0.128     0.200
     1.829    -2.334     0.200
     0.327     0.169     0.200
     0.333     0.532     0.200
     0.317     0.474     0.200
     0.334     0.817     0.200
     0.363     1.641     0.200
     0.426     0.609     0.200
     0.471     1.029     0.200
     0.506    -0.618     0.200
     0.471     1.395     0.200
     0.566     0.188     0.200
     1.648    -0.393     0.200
     0.247    -0.739     0.200
     0.266     0.862     0.200
     0.308     0.118     0.200
     0.322     1.235     0.200
     0.424     0.358     0.200
     0.460     1.038     0.200
     0.486    -0.207     0.200
     0.793     0.764     0.200
     0.871    -0.245     0.200
     1.338    -0.145     0.200
     0.081     1.790     0.200
     0.106     1.497     0.200
     0.181     1.915     0.200
     0.269     1.383     0.200
     0.294     0.195     0.200
     0.301     0.416     0.200
     0.369     0.671     0.200
     0.432     0.772     0.200
     0.594     0.454     0.200
     0.663     0.343     0.200
     0.137     2.826     0.200
     0.117     3.551     0.200
     0.249     1.664     0.200
     0.357     1.491     0.200
     0.379     0.544     0.200
     0.423     1.744     0.200
     0.465     0.997     0.200
     0.508     1.565     0.200
     0.643     1.257     0.200
     0.659     0.565     0.200
     0.681     0.581     0.200
     0.727     0.585     0.200
     0.864    -0.178     0.200
     0.881     0.330     0.200
     1.221    -1.172     0.200
     0.106     1.218     0.200
     0.092     1.681     0.200
     0.137     2.159     0.200
     0.317     0.276     0.200
     0.392     0.229     0.200
     0.386     1.003     0.200
     0.459     0.492     0.200
     0.459     0.836     0.200
     0.514     1.498     0.200
     1.217     0.287     0.200
     1.903    -1.314     0.200
     1.966    -1.367     0.200
     2.229    -2.040     0.200
     0.173     0.902     0.200
     0.193     0.911     0.200
     0.186     0.541     0.200
     0.360    -0.070     0.200
     0.636     1.329     0.200
     0.662     0.714     0.200
     0.704     0.485     0.200
     0.775     0.355     0.200
     0.782    -0.093     0.200
     0.046     3.879     0.200
     0.112     3.194     0.200
     0.111     3.537     0.200
     0.104     3.751     0.200
     0.247     1.252     0.200
     0.244     1.392     0.200
     0.309     0.965     0.200
     0.455     0.343     0.200
     0.474     0.674     0.200
     0.561    -0.341     0.200
     0.577    -0.022     0.200
     0.905     0.214     0.200
     0.941    -0.063     0.200
     1.767    -1.846     0.200
     1.843    -2.604     0.200
     0.170     0.196     0.200
     0.154     1.152     0.200
     0.184     0.644     0.200
     0.299     0.519     0.200
     0.385     0.092     0.200
     0.396     0.599     0.200
     0.445     0.621     0.200
     0.512     0.961     0.200
     0.535     0.124     0.200
     0.623     0.646     0.200
     0.756     0.582     0.200
     0.849     0.581     0.200
     0.919     0.680     0.200
     0.955     0.947     0.200
     1.030     0.880     0.200
     1.094     0.809     0.200
     0.179     0.094     0.200
     0.141     1.507     0.200
     0.180     0.789     0.200
     0.287     0.225     0.200
     0.303     0.744     0.200
     0.399     0.705     0.200
     0.406     0.534     0.200
     0.526     0.282     0.200
     0.549     0.227     0.200
     0.636     0.300     0.200
     0.739     0.741     0.200
     0.787     0.376     0.200
     0.854     0.528     0.200
     0.952     1.093     0.200
     1.043     0.818     0.200
     1.049     0.883     0.200
     1.107     0.933     0.200
     0.106     1.700     0.200
     0.157     1.820     0.200
     0.233     1.114     0.200
     0.276     1.392     0.200
     0.333     0.988     0.200
     0.331     1.403     0.200
     0.379     1.188     0.200
     0.522     0.969     0.200
     0.579     1.454     0.200
     0.610     1.122     0.200
     0.152     0.847     0.200
     0.224    -0.002     0.200
     0.238    -0.080     0.200
     0.328    -0.159     0.200
     0.411     0.402     0.200
     0.460     0.748     0.200
     0.485     0.082     0.200
     0.651     0.636     0.200
     0.664     0.686     0.200
     0.688     0.076     0.200
     0.699     0.764     0.200
     0.737     1.183     0.200
     0.759     0.185     0.200
     0.791     0.859     0.200
     0.836     0.159     0.200
     0.845     0.337     0.200
     0.849     0.421     0.200
     0.836     0.876     0.200
     0.916     0.532     0.200
     0.930     0.749     0.200
     0.950    -0.441     0.200
     1.085     0.793     0.200
     1.098     0.985     0.200
     1.116     0.911     0.200
     1.128     0.956     0.200
     1.122     1.110     0.200
     1.209     0.507     0.200
     1.254    -0.168     0.200
     1.237     0.906     0.200
     0.084     2.004     0.200
     0.101     2.606     0.200
     0.173     2.060     0.200
     0.407     1.450     0.200
     0.445     0.584     0.200
     0.457     0.919     0.200
     0.509     0.454     0.200
     0.528     0.047     0.200
     0.527     1.378     0.200
     1.009     0.201     0.200
     1.079     0.409     0.200
     1.729    -0.699     0.200
     1.878    -1.610     0.200
     2.031    -1.597     0.200
     2.129    -2.064     0.200
     2.135    -1.973     0.200
     0.147     1.529     0.200
     0.156     1.111     0.200
     0.183     1.278     0.200
     0.204     1.318     0.200
     0.309     0.982     0.200
     0.369     1.185     0.200
     0.378     1.422     0.200
     0.415     0.561     0.200
     0.553     0.945     0.200
     0.615     0.747     0.200
     0.626     0.913     0.200
     0.074     1.248     0.200
     0.138     1.226     0.200
     0.150     0.758     0.200
     0.171     0.268     0.200
     0.308     0.652     0.200
     0.326     0.533     0.200
     0.367     0.601     0.200
     0.374     0.603     0.200
     0.450     0.621     0.200
     0.457     0.593     0.200
     0.546     0.853     0.200
     0.570     0.744     0.200
     0.896     0.723     0.200
     0.085     0.908     0.200
     0.142     0.915     0.200
     0.154     0.511     0.200
     0.157     0.913     0.200
     0.327     0.322     0.200
     0.341     0.706     0.200
     0.349     0.503     0.200
     0.389    -0.026     0.200
     0.390     0.676     0.200
     0.410     0.446     0.200
     0.461     0.501     0.200
     0.486     0.815     0.200
     0.530     0.397     0.200
     0.582     0.695     0.200
     0.606     0.510     0.200
     0.645     0.672     0.200
     0.113     0.813     0.200
     0.161     1.123     0.200
     0.242     0.360     0.200
     0.267     0.169     0.200
     0.370     0.755     0.200
     0.393     0.575     0.200
     0.443     0.309     0.200
     0.437     0.534     0.200
     0.560     0.821     0.200
     0.646     0.331     0.200
     0.636     0.962     0.200
     0.657     0.529     0.200
     0.710     1.044     0.200
     0.733     0.589     0.200
     0.745     0.439     0.200
     0.726     1.153     0.200
     0.787     0.436     0.200
     0.791     0.282     0.200
     0.806     0.062     0.200
     0.801     1.184     0.200
     0.853     1.177     0.200
     0.910     0.631     0.200
     1.052     1.070     0.200
     1.118     0.844     0.200
     1.122     0.925     0.200
     1.184    -0.323     0.200
     0.187     0.768     0.200
     0.251     1.094     0.200
     0.268     0.776     0.200
     0.303     0.351     0.200
     0.329     0.440     0.200
     0.451     0.278     0.200
     0.538     0.602     0.200
     0.576     0.941     0.200
     0.636     0.273     0.200
     0.779     0.460     0.200
     0.826     0.359     0.200
     0.828     0.359     0.200
     0.837     0.256     0.200
     0.845     0.829     0.200
     0.910     0.624     0.200
     1.050     0.770     0.200
     0.163     1.053     0.200
     0.243     1.065     0.200
     0.263     0.866     0.200
     0.328     0.707     0.200
     0.333     0.865     0.200
     0.359     0.622     0.200
     0.388     0.814     0.200
     0.402     0.750     0.200
     0.445     0.860     0.200
     0.494    -0.495     0.200
     0.553     0.885     0.200
     0.577     0.708     0.200
     0.596     0.495     0.200
     0.704     0.803     0.200
     0.778     0.926     0.200
     0.864     0.946     0.200
     1.007     1.147     0.200
     1.794    -1.041     0.200
     0.093     2.111     0.200
     0.088     2.061     0.200
     0.175     1.554     0.200
     0.256     1.339     0.200
     0.288     0.677     0.200
     0.358     0.951     0.200
     0.425     0.690     0.200
     0.491     0.735     0.200
     0.565     0.429     0.200
     0.579     1.078     0.200
     0.585     1.041     0.200
     0.626     0.755     0.200
     0.654     0.979     0.200
     0.755    -0.307     0.200
     0.737     0.396     0.200
     0.758     0.284     0.200
     0.913     0.013     0.200
     0.923     0.540     0.200
     1.079     0.684     0.200
     1.776    -0.298     0.200
     1.855    -1.169     0.200
     0.201     1.383     0.200
     0.311     1.156     0.200
     0.315     1.257     0.200
     0.320     1.108     0.200
     0.345     1.072     0.200
     0.384     0.955     0.200
     0.415     0.012     0.200
     0.399     0.995     0.200
     0.436     0.758     0.200
     0.475     1.103     0.200
     0.505     0.705     0.200
     0.551     0.369     0.200
     0.586     0.797     0.200
     0.668     0.766     0.200
     0.764     0.847     0.200
     0.783     1.004     0.200
     1.711    -1.714     0.200
     0.105     2.268     0.200
     0.147     1.790     0.200
     0.173     1.532     0.200
     0.216     1.708     0.200
     0.230     1.180     0.200
     0.332     1.208     0.200
     0.378     0.887     0.200
     0.416     0.966     0.200
     0.453     0.793     0.200
     0.460     0.729     0.200
     0.453     1.181     0.200
     0.554     0.947     0.200
     0.584     1.207     0.200
     0.597     1.203     0.200
     0.657     1.121     0.200
     0.701     0.793     0.200
     0.712     1.276     0.200
     0.786     0.784     0.200
     0.807     0.847     0.200
     1.012     0.807     0.200
     1.748    -0.824     0.200
     1.824    -1.171     0.200
     2.042    -1.417     0.200
     2.157    -1.995     0.200
     0.112     1.023     0.200
     0.216     0.494     0.200
     0.247     0.520     0.200
     0.289     0.545     0.200
     0.313     0.731     0.200
     0.324     0.730     0.200
     0.343     0.663     0.200
     0.422    -0.231     0.200
     0.422     0.653     0.200
     0.428     0.753     0.200
     0.641     0.681     0.200
     0.677     0.782     0.200
     0.060     0.952     0.200
     0.228     0.474     0.200
     0.255     1.296     0.200
     0.346    -0.192     0.200
     0.357     0.106     0.200
     0.385     0.419     0.200
     0.392     0.904     0.200
     0.370    -0.647     0.200
     0.430    -0.301     0.200
     0.581    -0.333     0.200
     0.539     1.752     0.200
     0.586     1.386     0.200
     0.609     1.300     0.200
     0.792     0.084     0.200
     0.794    -0.168     0.200
     0.849     0.193     0.200
     0.926     0.520     0.200
     0.949     0.275     0.200
     0.941     0.804     0.200
     0.974     0.150     0.200
     0.980     0.016     0.200
     1.098     0.454     0.200
     1.190     0.298     0.200
     1.264     0.252     0.200
     1.655     0.295     0.200
     1.674     0.098     0.200
     1.667     0.025     0.200
     1.727    -0.401     0.200
     1.767    -0.564     0.200
     1.789    -0.217     0.200
     1.831    -0.522     0.200
     1.925    -0.704     0.200
     1.933    -0.732     0.200
     1.989    -0.787     0.200
     1.992    -0.886     0.200
     2.058     0.110     0.200
     1.999    -0.677     0.200
     2.062    -2.048     0.200
     2.089    -0.861     0.200
     2.782    -5.137     0.200
     3.134    -7.474     0.200
     0.061     1.684     0.200
     0.112     1.354     0.200
     0.207     1.107     0.200
     0.279     1.100     0.200
     0.273     0.870     0.200
     0.328     0.434     0.200
     0.379     0.764     0.200
     0.456     0.830     0.200
     0.484     0.069     0.200
     0.559     0.555     0.200
     0.612     0.699     0.200
     0.644     0.407     0.200
     0.648     0.732     0.200
     0.683     0.536     0.200
     0.732    -0.265     0.200
     0.733     0.158     0.200
     0.738     0.286     0.200
     0.769     0.952     0.200
     0.804     0.637     0.200
     0.873     0.618     0.200
     0.900     0.653     0.200
     0.924     0.488     0.200
     1.072     1.049     0.200
     1.102     0.802     0.200
     1.724    -0.593     0.200
     1.828    -0.533     0.200
     2.134    -1.347     0.200
     0.177     0.753     0.200
     0.233     0.909     0.200
     0.354     0.437     0.200
     0.363     0.078     0.200
     0.355     1.110     0.200
     0.398     0.803     0.200
     0.444    -0.471     0.200
     0.470     0.797     0.200
     0.598    -0.383     0.200
     0.572     0.921     0.200
     0.941     0.250     0.200
     0.962     0.083     0.200
     1.282     0.280     0.200
     1.690     0.324     0.200
     1.848    -0.081     0.200
     0.140     1.209     0.200
     0.142     1.595     0.200
     0.169     1.221     0.200
     0.202     0.533     0.200
     0.328     0.227     0.200
     0.353    -0.113     0.200
     0.367     0.108     0.200
     0.372     0.339     0.200
     0.381     0.137     0.200
     0.398     0.566     0.200
     0.432     0.523     0.200
     0.447     0.336     0.200
     0.451     0.998     0.200
     0.504     0.071     0.200
     0.503     0.775     0.200
     0.520     1.120     0.200
     0.534     0.558     0.200
     0.636     0.252     0.200
     0.643     0.583     0.200
     0.699    -0.504     0.200
     0.681     0.786     0.200
     0.693     0.677     0.200
     0.763     0.900     0.200
     0.925     0.266     0.200
     1.658     0.650     0.200
     1.861    -0.294     0.200
     0.150     1.021     0.200
     0.144     1.427     0.200
     0.176     0.175     0.200
     0.259     0.728     0.200
     0.275     1.015     0.200
     0.379     0.555     0.200
     0.374     0.458     0.200
     0.446     0.432     0.200
     0.455     0.466     0.200
     0.500     0.811     0.200
     0.611    -1.143     0.200
     0.616     0.498     0.200
     0.631    -0.028     0.200
     0.628     0.124     0.200
     0.637     0.847     0.200
     0.683     0.494     0.200
     0.702     1.028     0.200
     0.818     0.143     0.200
     0.861     0.404     0.200
     0.935     0.919     0.200
     0.963     0.634     0.200
     0.981     0.137     0.200
     1.914     0.403     0.200
     2.013    -0.200     0.200
     2.124    -0.417     0.200
     0.226     0.869     0.200
     0.229     1.264     0.200
     0.254     0.881     0.200
     0.367     1.254     0.200
     0.432     0.641     0.200
     0.507     0.249     0.200
     0.509     1.051     0.200
     0.611     0.572     0.200
     0.677    -0.135     0.200
     0.682     0.693     0.200
     0.683     1.271     0.200
     0.845     1.181     0.200
     1.019     0.201     0.200
     1.047     0.898     0.200
     0.124     3.577     0.200
     0.134     3.660     0.200
     0.155     3.735     0.200
     0.269     2.824     0.200
     0.318     1.694     0.200
     0.496     0.989     0.200
     0.544     0.799     0.200
     0.532     1.587     0.200
     0.556     1.625     0.200
     0.618     0.561     0.200
     0.672     0.938     0.200
     0.764     1.113     0.200
     0.808     0.495     0.200
     0.875     0.312     0.200
     0.157     0.119     0.200
     0.273     0.369     0.200
     0.284     0.388     0.200
     0.322    -0.148     0.200
     0.344     0.022     0.200
     0.360     0.653     0.200
     0.420    -0.064     0.200
     0.443     1.283     0.200
     0.464     0.577     0.200
     0.507     0.728     0.200
     0.543     0.627     0.200
     0.588     0.796     0.200
     0.637     1.187     0.200
     0.722     1.098     0.200
     0.795     1.007     0.200
     0.795     1.109     0.200
     0.790     0.513     0.200
     1.801     0.611     0.200
     0.095     0.328     0.200
     0.101     0.731     0.200
     0.319     0.652     0.200
     0.464     0.515     0.200
     0.467    -0.137     0.200
     0.655    -0.344     0.200
     1.026     0.232     0.200
     1.106     0.442     0.200
     1.212    -0.632     0.200
     1.306    -0.199     0.200
     1.840    -2.139     0.200
     1.885    -0.472     0.200
     1.897    -0.572     0.200
     1.908    -0.559     0.200
     2.023    -1.629     0.200
     2.061    -0.621     0.200
     2.159    -1.946     0.200
     2.165    -1.851     0.200
     2.224    -2.071     0.200
     1.973    -0.552     0.200
     2.149    -2.563     0.200
     2.161    -1.813     0.200
     0.056     1.860     0.200
     0.180     0.578     0.200
     0.198     1.193     0.200
     0.310     0.733     0.200
     0.413     0.281     0.200
     0.412     0.058     0.200
     0.486    -0.001     0.200
     0.554     0.357     0.200
     0.578     0.124     0.200
     0.626     1.008     0.200
     1.000     1.280     0.200
     1.064     0.670     0.200
     2.000    -1.111     0.200
     0.162    -0.062     0.200
     0.195     0.205     0.200
     0.199     0.402     0.200
     0.303    -0.192     0.200
     0.318     0.244     0.200
     0.313     0.237     0.200
     0.345    -0.226     0.200
     0.974     0.953     0.200
     0.059     0.007     0.200
     0.205     0.552     0.200
     0.268     0.798     0.200
     0.271     0.349     0.200
     0.271     0.890     0.200
     0.281     0.387     0.200
     0.325     0.682     0.200
     0.369     0.325     0.200
     0.381     0.889     0.200
     0.467    -0.762     0.200
     0.453     0.326     0.200
     0.546     0.335     0.200
     0.592     0.246     0.200
     0.624     0.819     0.200
     0.626     0.617     0.200
     0.625     0.341     0.200
     0.080     2.581     0.200
     0.116     2.285     0.200
     0.191     1.577     0.200
     0.189     1.795     0.200
     0.241     1.972     0.200
     0.302     1.403     0.200
     0.350     0.725     0.200
     0.492     0.580     0.200
     0.499     0.495     0.200
     0.563     0.645     0.200
     0.679     0.287     0.200
     0.739     0.562     0.200
     0.762     0.563     0.200
     0.752     0.816     0.200
     0.861     0.767     0.200
     0.887     0.875     0.200
     0.969    -0.072     0.200
     0.937     0.206     0.200
     1.047     0.123     0.200
     1.077    -0.109     0.200
     0.177     1.294     0.200
     0.159     1.435     0.200
     0.203     1.712     0.200
     0.243     0.794     0.200
     0.362    -0.220     0.200
     0.341     0.449     0.200
     0.406     0.071     0.200
     0.444     1.038     0.200
     0.464     0.531     0.200
     0.635     1.086     0.200
     0.653    -0.024     0.200
     0.689     0.145     0.200
     0.710     0.961     0.200
     0.754     0.217     0.200
     0.758     0.083     0.200
     0.774     1.741     0.200
     0.785     1.443     0.200
     0.818     0.753     0.200
     0.869     0.746     0.200
     0.929     0.853     0.200
     0.988     0.594     0.200
     1.116     0.209     0.200
     1.169    -1.146     0.200
     2.436    -4.087     0.200
     2.472    -3.668     0.200
     2.534    -4.476     0.200
     2.878    -6.984     0.200
     0.128     0.330     0.200
     0.208    -0.067     0.200
     0.327     0.011     0.200
     0.385    -0.094     0.200
     0.469     0.818     0.200
     0.503    -0.281     0.200
     0.475     0.949     0.200
     0.603     0.494     0.200
     0.655    -0.325     0.200
     0.770     0.746     0.200
     1.112    -0.324     0.200
     1.140    -0.110     0.200
     1.177     0.431     0.200
     1.652    -0.118     0.200
     1.682    -0.255     0.200
     1.808    -0.647     0.200
     1.863    -1.257     0.200
     1.933    -1.787     0.200
     1.984    -1.522     0.200
     2.005    -1.269     0.200
     2.011    -1.786     0.200
     2.025    -1.496     0.200
     2.077    -1.267     0.200
     2.167    -1.714     0.200
     2.274    -2.096     0.200
     2.272    -1.956     0.200
     2.331    -2.500     0.200
     0.110     2.178     0.200
     0.189     1.665     0.200
     0.235     1.168     0.200
     0.357     1.224     0.200
     0.391     1.179     0.200
     0.419     1.358     0.200
     0.465     0.493     0.200
     0.579     1.507     0.200
     0.638     1.146     0.200
     0.660     0.292     0.200
     0.661     0.974     0.200
     0.751     1.097     0.200
     0.762     0.963     0.200
     0.947     0.075     0.200
     1.967    -1.340     0.200
     0.122     1.576     0.200
     0.118     1.212     0.200
     0.195     1.211     0.200
     0.394     0.864     0.200
     0.398     0.518     0.200
     0.409     0.487     0.200
     0.424     0.644     0.200
     0.451     1.176     0.200
     0.585     0.865     0.200
     0.586     0.685     0.200
     0.638     1.003     0.200
     0.708     0.867     0.200
     0.106     1.275     0.200
     0.112     1.474     0.200
     0.117     0.699     0.200
     0.157     0.711     0.200
     0.271    -0.008     0.200
     0.359     0.493     0.200
     0.363     0.818     0.200
     0.399     0.076     0.200
     0.421     0.219     0.200
     0.477    -0.068     0.200
     0.591    -0.416     0.200
     0.644     0.519     0.200
     0.688     0.164     0.200
     0.703     0.936     0.200
     0.731     0.370     0.200
     0.746     0.184     0.200
     0.796     0.276     0.200
     0.811    -0.042     0.200
     1.391    -0.002     0.200
     0.161     1.704     0.200
     0.290     0.918     0.200
     0.305     1.344     0.200
     0.302     0.818     0.200
     0.310     0.808     0.200
     0.362     0.873     0.200
     0.436    -0.517     0.200
     0.433     0.959     0.200
     0.449     0.459     0.200
     0.464     0.619     0.200
     0.556     0.394     0.200
     0.606    -0.094     0.200
     0.628     0.823     0.200
     0.698     0.612     0.200
     0.723     0.263     0.200
     0.796     0.754     0.200
     0.836    -0.371     0.200
     0.841     0.138     0.200
     1.739     0.349     0.200
     0.051    -0.037     0.200
     0.282    -0.035     0.200
     0.294     1.596     0.200
     0.389    -0.120     0.200
     0.409    -0.277     0.200
     0.506     1.437     0.200
     0.537     1.161     0.200
     0.606     0.412     0.200
     0.683    -0.094     0.200
     0.723     0.090     0.200
     0.862    -0.540     0.200
     0.877     0.630     0.200
     0.929    -0.173     0.200
     0.950     0.284     0.200
     1.030     0.899     0.200
     1.015     0.841     0.200
     1.044     0.131     0.200
     1.141     0.199     0.200
     1.259     0.896     0.200
     1.375     0.049     0.200
     1.405     0.439     0.200
     1.733     0.792     0.200
     1.749     0.485     0.200
     1.816     0.358     0.200
     1.995    -0.104     0.200
     1.998    -0.825     0.200
     2.056    -0.462     0.200
     0.780    -1.019     0.200
     1.120     0.960     0.200
     1.984    -0.816     0.200
     2.067    -2.243     0.200
     2.312    -3.197     0.200
     2.372    -2.120     0.200
     2.527    -4.059     0.200
     0.108     1.977     0.200
     0.226     0.976     0.200
     0.357     0.984     0.200
     0.392     1.077     0.200
     0.459     0.514     0.200
     0.545     0.935     0.200
     0.603     0.783     0.200
     0.629     1.113     0.200
     0.650     0.778     0.200
     0.719     0.832     0.200
     0.919     1.017     0.200
     0.982     0.951     0.200
     1.001     0.885     0.200
     0.658     2.567     0.200
     2.013    -1.735     0.200
     2.111    -1.024     0.200
     2.340    -3.937     0.200
     2.392    -4.372     0.200
     2.397    -4.461     0.200
     2.555    -4.798     0.200
     0.147     1.153     0.200
     0.136     1.148     0.200
     0.229     0.951     0.200
     0.356     0.628     0.200
     0.377     1.181     0.200
     0.432     0.439     0.200
     0.541     0.976     0.200
     0.602     1.183     0.200
     0.620     0.980     0.200
     0.625     0.845     0.200
     0.693     0.468     0.200
     0.730     0.587     0.200
     0.210     0.297     0.200
     0.302     0.436     0.200
     0.313     0.521     0.200
     0.336     0.865     0.200
     0.360     0.109     0.200
     0.399    -0.626     0.200
     0.381     0.205     0.200
     0.422    -0.120     0.200
     0.461     0.777     0.200
     0.484     0.852     0.200
     0.510     0.025     0.200
     0.516     0.252     0.200
     0.532     0.549     0.200
     0.571     0.345     0.200
     0.591     0.789     0.200
     0.681     0.664     0.200
     0.681     0.684     0.200
     0.747     0.630     0.200
     0.768     0.462     0.200
     0.775     0.657     0.200
     0.840     0.666     0.200
     0.854     0.268     0.200
     0.848     0.344     0.200
     0.950     0.929     0.200
     1.026     0.254     0.200
     1.074     0.342     0.200
     1.094     1.147     0.200
     1.696     0.992     0.200
     1.801     0.538     0.200
     0.168     0.616     0.200
     0.294     0.029     0.200
     0.451     0.555     0.200
     0.512     0.383     0.200
     0.515     0.389     0.200
     0.538    -0.055     0.200
     0.663    -0.056     0.200
     0.730    -0.159     0.200
     0.732     0.345     0.200
     0.787     1.004     0.200
     0.808     0.238     0.200
     0.801     0.402     0.200
     0.816     0.238     0.200
     0.807     0.321     0.200
     0.116     0.892     0.200
     0.204     0.711     0.200
     0.267     0.546     0.200
     0.311     0.116     0.200
     0.328    -0.367     0.200
     0.342     0.234     0.200
     0.532     0.017     0.200
     0.584     0.666     0.200
     0.714     0.013     0.200
     0.708     0.723     0.200
     0.735    -0.025     0.200
     0.767     0.016     0.200
     0.855     0.023     0.200
     0.915     0.097     0.200
     0.918     0.463     0.200
     0.942     0.189     0.200
     1.050     0.492     0.200
     1.066     0.342     0.200
     1.168     0.566     0.200
     1.289     0.649     0.200
     1.421    -0.577     0.200
     1.734     0.150     0.200
     0.145     1.576     0.200
     0.189     0.699     0.200
     0.288     0.392     0.200
     0.292     0.437     0.200
     0.317     0.258     0.200
     0.310     0.473     0.200
     0.396     0.560     0.200
     0.440    -0.590     0.200
     0.458    -0.680     0.200
     0.463     0.491     0.200
     0.510     0.412     0.200
     0.575     0.395     0.200
     0.568     0.740     0.200
     0.645     0.461     0.200
     0.667    -0.612     0.200
     0.674    -0.303     0.200
     0.730     1.138     0.200
     0.727     0.828     0.200
     0.781    -0.680     0.200
     0.799     0.086     0.200
     0.809     0.506     0.200
     0.836    -0.472     0.200
     0.882    -0.196     0.200
     1.021    -0.226     0.200
     1.020     0.054     0.200
     1.190    -0.243     0.200
     1.213     0.529     0.200
     1.528    -0.930     0.200
     1.656    -0.257     0.200
     1.716    -0.640     0.200
     1.875    -0.566     0.200
     0.136     2.017     0.200
     0.168     1.959     0.200
     0.149     1.456     0.200
     0.261     1.699     0.200
     0.358     1.379     0.200
     0.373     1.584     0.200
     0.446     1.279     0.200
     0.449     0.507     0.200
     0.440     1.144     0.200
     0.484     0.311     0.200
     0.564     0.848     0.200
     0.617    -0.248     0.200
     0.612     0.291     0.200
     0.621     0.870     0.200
     0.684    -0.185     0.200
     0.681     0.802     0.200
     0.777    -0.275     0.200
     0.784     0.205     0.200
     0.805     0.809     0.200
     0.849    -0.463     0.200
     0.891    -0.207     0.200
     0.921     1.030     0.200
     0.959     0.801     0.200
     0.989     0.178     0.200
     1.010    -0.571     0.200
     1.136    -0.102     0.200
     1.582    -0.502     0.200
     1.609    -0.900     0.200
     1.638    -0.119     0.200
     1.787    -1.380     0.200
     1.798    -0.621     0.200
     1.922    -2.594     0.200
     1.995    -1.744     0.200
     2.019    -1.278     0.200
     2.131    -2.553     0.200
     0.481    -0.365     0.200
     0.699     0.501     0.200
     0.113     1.422     0.200
     0.140     1.400     0.200
     0.172     1.411     0.200
     0.218     1.133     0.200
     0.240     0.539     0.200
     0.305     0.818     0.200
     0.333    -0.280     0.200
     0.373     0.239     0.200
     0.438    -0.347     0.200
     0.476    -0.419     0.200
     0.474     0.308     0.200
     0.473     0.024     0.200
     0.487     0.788     0.200
     0.579     0.207     0.200
     0.609     0.085     0.200
     0.659    -0.049     0.200
     0.690     0.169     0.200
     0.721    -0.058     0.200
     0.727     0.211     0.200
     0.744     0.753     0.200
     0.744     0.439     0.200
     0.776     0.202     0.200
     0.816     1.650     0.200
     0.840     1.071     0.200
     0.906     0.407     0.200
     0.960     0.442     0.200
     0.973     1.078     0.200
     1.026     0.015     0.200
     1.143    -0.386     0.200
     1.151     0.533     0.200
     1.333    -0.343     0.200
     0.109     2.269     0.200
     0.177     1.297     0.200
     0.207     1.133     0.200
     0.305     0.788     0.200
     0.315     0.473     0.200
     0.316     0.444     0.200
     0.364     0.478     0.200
     0.434     1.294     0.200
     0.439     0.105     0.200
     0.434     1.091     0.200
     0.515     0.318     0.200
     0.561     0.906     0.200
     0.584     0.140     0.200
     0.584     0.033     0.200
     0.586     0.471     0.200
     0.670     0.117     0.200
     0.711     0.447     0.200
     0.736    -0.424     0.200
     0.719     0.043     0.200
     0.763     0.264     0.200
     0.769    -0.588     0.200
     0.813     0.506     0.200
     0.847     1.544     0.200
     0.942     0.537     0.200
     1.074     0.371     0.200
     1.077     0.810     0.200
     1.074     0.309     0.200
     0.134     0.869     0.200
     0.132     0.929     0.200
     0.183     0.421     0.200
     0.255     0.679     0.200
     0.340     0.908     0.200
     0.328     0.601     0.200
     0.415     0.178     0.200
     0.420     0.332     0.200
     0.454     0.621     0.200
     0.465     0.146     0.200
     0.585     1.143     0.200
     0.588     0.378     0.200
     0.661    -0.539     0.200
     0.658     0.358     0.200
     0.746     0.245     0.200
     0.866     0.090     0.200
     0.884     1.247     0.200
     0.903     0.527     0.200
     0.927     0.465     0.200
     0.982     0.466     0.200
     0.986     0.459     0.200
     1.121     0.168     0.200
     1.162    -0.379     0.200
     1.196     0.826     0.200
     1.770     0.438     0.200
     1.789     0.241     0.200
     1.913     0.740     0.200
     2.005    -0.483     0.200
     2.122    -0.588     0.200
     0.148     1.770     0.200
     0.207     0.659     0.200
     0.270     0.814     0.200
     0.296     1.042     0.200
     0.317     0.326     0.200
     0.329     0.391     0.200
     0.408    -0.264     0.200
     0.431    -0.192     0.200
     0.451     0.751     0.200
     0.571     0.625     0.200
     0.582     0.721     0.200
     0.602     0.703     0.200
     0.670     0.365     0.200
     0.723     0.343     0.200
     0.730     0.483     0.200
     0.807     0.714     0.200
     0.799     0.691     0.200
     0.851     0.423     0.200
     0.925    -0.274     0.200
     1.086    -0.213     0.200
     1.104     0.805     0.200
     1.168     0.185     0.200
     0.155     1.962     0.200
     0.249     1.439     0.200
     0.263     1.003     0.200
     0.318     1.700     0.200
     0.350     1.933     0.200
     0.393     1.227     0.200
     0.440     0.814     0.200
     0.490     0.055     0.200
     0.502     0.342     0.200
     0.578     0.177     0.200
     0.593     0.073     0.200
     0.659     0.342     0.200
     0.685     0.157     0.200
     0.700     0.877     0.200
     0.699     0.732     0.200
     0.773     1.023     0.200
     0.778     0.998     0.200
     0.787    -0.574     0.200
     0.850    -0.047     0.200
     0.860     0.562     0.200
     0.883     0.362     0.200
     0.915     0.029     0.200
     1.028    -0.221     0.200
     1.668    -2.321     0.200
     1.893    -0.117     0.200
     0.040     1.160     0.200
     0.165     0.547     0.200
     0.175     0.989     0.200
     0.248     0.885     0.200
     0.311     0.950     0.200
     0.347    -0.068     0.200
     0.376     0.516     0.200
     0.499    -0.123     0.200
     0.471     0.424     0.200
     0.484     0.522     0.200
     0.505     0.243     0.200
     0.595     0.614     0.200
     0.710    -0.254     0.200
     0.732    -0.940     0.200
     0.724     0.627     0.200
     0.795    -0.331     0.200
     0.942     0.075     0.200
     0.995     0.105     0.200
     1.031    -0.194     0.200
     1.065    -1.232     0.200
     1.124     0.929     0.200
     1.135    -0.222     0.200
     1.252    -0.122     0.200
     1.274    -0.708     0.200
     1.778    -0.927     0.200
     1.985    -0.176     0.200
     2.075    -1.895     0.200
     2.086    -1.461     0.200
     2.146    -1.575     0.200
     0.660     1.114     0.200
     2.065    -2.634     0.200
     2.150    -3.755     0.200
     2.245    -3.917     0.200
     0.139     1.364     0.200
     0.128     1.640     0.200
     0.265     0.718     0.200
     0.306     0.750     0.200
     0.371     0.039     0.200
     0.371     0.678     0.200
     0.370     0.687     0.200
     0.528     0.493     0.200
     0.664     0.222     0.200
     0.679     0.326     0.200
     0.679    -0.252     0.200
     0.841     0.299     0.200
     0.942     0.945     0.200
     1.008     1.259     0.200
     1.010     0.371     0.200
     1.042     0.195     0.200
     0.092     0.866     0.200
     0.317    -0.564     0.200
     0.295     0.733     0.200
     0.491     0.514     0.200
     0.526     0.178     0.200
     0.504     0.970     0.200
     0.528     0.700     0.200
     0.634     1.510     0.200
     0.688     1.475     0.200
     0.719     2.285     0.200
     0.724     1.495     0.200
     0.919     0.195     0.200
     1.031     0.056     0.200
     1.063     0.093     0.200
     1.198     0.476     0.200
     1.335    -0.065     0.200
     1.711     0.500     0.200
     0.184     3.226     0.200
     0.235     2.139     0.200
     0.261     2.186     0.200
     0.384     2.412     0.200
     0.413     1.493     0.200
     0.488     1.160     0.200
     0.484     1.453     0.200
     0.555     0.271     0.200
     0.524     1.543     0.200
     0.580     0.594     0.200
     0.570     1.769     0.200
     0.727     0.070     0.200
     0.742     0.641     0.200
     0.740     1.220     0.200
     0.814     0.609     0.200
     0.936    -0.215     0.200
     1.504    -0.198     0.200
     1.543    -1.367     0.200
     1.721    -1.006     0.200
     1.733    -1.462     0.200
     1.940    -1.688     0.200
     1.954    -2.038     0.200
     0.212     0.421     0.200
     0.385     0.348     0.200
     0.395     0.556     0.200
     0.411     1.227     0.200
     0.460    -0.146     0.200
     0.480     0.988     0.200
     0.525    -0.180     0.200
     0.548     0.363     0.200
     0.548     1.123     0.200
     0.551     0.615     0.200
     0.650     0.484     0.200
     0.697     0.195     0.200
     0.738    -0.052     0.200
     0.812     0.785     0.200
     0.880     0.561     0.200
     0.915    -0.109     0.200
     0.892     1.242     0.200
     0.946     0.669     0.200
     1.693     0.902     0.200
     1.702     0.399     0.200
     1.814     0.759     0.200
     1.910    -0.261     0.200
     1.925     0.702     0.200
     0.173     1.538     0.200
     0.195     1.865     0.200
     0.234     1.497     0.200
     0.268     1.935     0.200
     0.349     0.967     0.200
     0.427     1.573     0.200
     0.481     1.321     0.200
     0.500     0.776     0.200
     0.524     0.901     0.200
     0.689     0.966     0.200
     0.719     0.972     0.200
     0.735     1.577     0.200
     0.757     0.639     0.200
     0.839     1.052     0.200
     0.987     0.164     0.200
     1.025     0.379     0.200
     0.211     1.888     0.200
     1.100    -0.521     0.200
     2.163    -2.540     0.200
     0.121     1.056     0.200
     0.145     1.335     0.200
     0.240    -0.164     0.200
     0.344     0.192     0.200
     0.367     1.795     0.200
     0.430    -0.298     0.200
     0.409     1.510     0.200
     0.489     0.370     0.200
     0.541     0.928     0.200
     0.578     0.759     0.200
     0.752     0.113     0.200
     0.831    -0.263     0.200
     1.038     0.208     0.200
     1.042     1.127     0.200
     1.177     0.202     0.200
     1.224     0.112     0.200
     1.328    -0.057     0.200
     1.861    -0.797     0.200
     1.908    -0.430     0.200
     1.921    -1.047     0.200
     2.005    -0.885     0.200
     2.183    -1.378     0.200
     2.233    -1.701     0.200
     2.242    -1.440     0.200
     0.085     0.860     0.200
     0.218     1.005     0.200
     0.254     0.971     0.200
     0.274     0.439     0.200
     0.337     0.248     0.200
     0.350     0.239     0.200
     0.366     0.440     0.200
     0.517    -0.542     0.200
     0.514     0.077     0.200
     0.542     0.960     0.200
     0.615    -0.075     0.200
     0.626     0.853     0.200
     0.667     0.541     0.200
     0.681     0.869     0.200
     0.785    -0.184     0.200
     0.855     1.101     0.200
     0.887     1.014     0.200
     1.206     0.955     0.200
     1.701     1.524     0.200
     1.916     0.206     0.200
     0.099     2.159     0.200
     0.101     2.200     0.200
     0.166     1.469     0.200
     0.266     0.553     0.200
     0.271     1.039     0.200
     0.297     0.837     0.200
     0.341     0.617     0.200
     0.428     0.840     0.200
     0.521     0.234     0.200
     0.545     0.527     0.200
     0.722     0.733     0.200
     0.764     0.900     0.200
     0.766     1.045     0.200
     0.796     0.857     0.200
     0.831     0.853     0.200
     0.936     0.244     0.200
     1.023     0.969     0.200
     0.263     0.769     0.200
     1.309    -1.910     0.200
     0.060     2.449     0.200
     0.123     1.834     0.200
     0.203     2.195     0.200
     0.304     0.537     0.200
     0.304     0.711     0.200
     0.388     1.255     0.200
     0.453     0.705     0.200
     0.510     0.613     0.200
     0.584    -0.061     0.200
     0.591     0.398     0.200
     0.615     0.874     0.200
     0.657     0.828     0.200
     0.684     1.061     0.200
     0.790     0.235     0.200
     0.917    -0.211     0.200
     0.926     0.508     0.200
     1.041     0.569     0.200
     1.117     0.575     0.200
     1.127     0.418     0.200
     1.749    -0.906     0.200
     2.160    -1.654     0.200
     0.185     0.228     0.200
     0.266     0.189     0.200
     0.280     0.233     0.200
     0.267     0.017     0.200
     0.348     0.425     0.200
     0.461    -0.149     0.200
     0.441     0.788     0.200
     0.527     0.231     0.200
     0.535     0.753     0.200
     0.743    -0.455     0.200
     0.763     0.116     0.200
     0.870    -0.536     0.200
     0.911     0.140     0.200
     0.998     0.592     0.200
     0.067     2.871     0.200
     0.107     1.937     0.200
     0.209     1.886     0.200
     0.339     0.892     0.200
     0.373     0.976     0.200
     0.456     0.558     0.200
     0.472     0.386     0.200
     0.547     0.551     0.200
     0.552     0.988     0.200
     0.609     0.973     0.200
     0.643     1.351     0.200
     0.680     1.017     0.200
     0.726     0.754     0.200
     0.761     1.268     0.200
     0.864     0.219     0.200
     0.857     1.151     0.200
     0.878     0.864     0.200
     0.888     0.409     0.200
     0.914    -0.043     0.200
     1.115     0.069     0.200
     1.743    -0.872     0.200
     1.817    -1.314     0.200
     1.898    -0.928     0.200
     2.021    -0.928     0.200
     2.101    -1.156     0.200
     2.122    -0.838     0.200
     0.558     1.019     0.200
     1.882    -0.151     0.200
     2.954    -5.751     0.200
     0.092     1.078     0.200
     0.178     0.732     0.200
     0.242     0.633     0.200
     0.265     0.609     0.200
     0.361     0.579     0.200
     0.404     1.126     0.200
     0.551     0.775     0.200
     0.608     0.603     0.200
     0.638     1.282     0.200
     0.930     1.398     0.200
     1.705     0.424     0.200
     0.097     2.537     0.200
     0.203     1.474     0.200
     0.224     1.170     0.200
     0.329     0.693     0.200
     0.340     0.626     0.200
     0.332     1.042     0.200
     0.465    -0.163     0.200
     0.451     0.871     0.200
     0.793     0.778     0.200
     0.061     1.779     0.200
     0.110     1.062     0.200
     0.131     0.915     0.200
     0.224     0.124     0.200
     0.231     0.111     0.200
     0.284     0.915     0.200
     0.279     1.320     0.200
     0.366     0.285     0.200
     0.443    -0.326     0.200
     0.535     0.084     0.200
     0.527     0.749     0.200
     0.523     1.374     0.200
     0.958     0.940     0.200
     0.988     0.714     0.200
     0.276    -0.209     0.200
     1.263    -1.615     0.200
     1.898    -0.660     0.200
     2.527    -6.004     0.200
     2.727    -5.072     0.200
     0.208     1.212     0.200
     0.242     0.457     0.200
     0.328     0.822     0.200
     0.351     0.657     0.200
     0.351     0.141     0.200
     0.379     0.676     0.200
     0.469     0.346     0.200
     0.469    -0.054     0.200
     0.595     0.023     0.200
     0.710     0.803     0.200
     0.746     0.069     0.200
     0.790     0.174     0.200
     0.790     0.830     0.200
     0.890     1.044     0.200
     0.903     0.677     0.200
     1.081     0.885     0.200
     1.100     0.788     0.200
     0.073     1.710     0.200
     0.091     1.706     0.200
     0.150     0.320     0.200
     0.217     0.491     0.200
     0.228    -0.059     0.200
     0.270     0.028     0.200
     0.265     0.532     0.200
     0.494    -0.429     0.200
     0.538     0.812     0.200
     0.544    -0.436     0.200
     0.658     0.256     0.200
     1.061     0.607     0.200
     0.064     2.376     0.200
     0.095     1.969     0.200
     0.145     0.791     0.200
     0.213     1.182     0.200
     0.218     0.619     0.200
     0.268     1.107     0.200
     0.426    -0.070     0.200
     0.488     0.270     0.200
     0.526     0.716     0.200
     0.528     0.291     0.200
     0.528    -0.087     0.200
     0.547     0.096     0.200
     0.628    -0.047     0.200
     0.648     0.234     0.200
     0.691     0.152     0.200
     0.693     0.161     0.200
     0.722     0.446     0.200
     0.753     0.562     0.200
     0.753     0.684     0.200
     0.804     0.534     0.200
     1.065     0.677     0.200
     1.096     0.747     0.200
     0.137     1.862     0.200
     0.134     2.151     0.200
     0.179     1.564     0.200
     0.246     1.671     0.200
     0.249     0.916     0.200
     0.280     0.972     0.200
     0.363     1.007     0.200
     0.356     0.756     0.200
     0.383     1.533     0.200
     0.513     0.268     0.200
     0.518     1.473     0.200
     0.534     0.641     0.200
     0.567     0.418     0.200
     0.601     0.257     0.200
     0.650     0.119     0.200
     0.666     0.299     0.200
     0.722     0.840     0.200
     0.741     0.491     0.200
     0.762     0.450     0.200
     0.787     0.821     0.200
     0.801     0.437     0.200
     0.872     0.351     0.200
     0.868     0.791     0.200
     0.956     0.300     0.200
     0.063     2.750     0.200
     0.102     2.118     0.200
     0.138     1.307     0.200
     0.223     1.163     0.200
     0.222     0.664     0.200
     0.276     1.009     0.200
     0.278     0.776     0.200
     0.358    -0.072     0.200
     0.435     0.591     0.200
     0.497    -0.028     0.200
     0.532     1.114     0.200
     0.529     0.716     0.200
     0.637     0.231     0.200
     0.654    -0.159     0.200
     0.665     0.899     0.200
     0.700     0.197     0.200
     0.701     0.614     0.200
     0.762    -0.033     0.200
     0.753     0.617     0.200
     0.812     0.258     0.200
     1.138    -0.131     0.200
     0.163     0.998     0.200
     0.190     0.547     0.200
     0.329     1.004     0.200
     0.382     0.777     0.200
     0.431     0.997     0.200
     0.423     0.579     0.200
     0.458     0.194     0.200
     0.488     0.586     0.200
     0.554     0.665     0.200
     0.587     0.439     0.200
     0.662     0.173     0.200
     0.680     0.353     0.200
     0.683     0.702     0.200
     0.707     0.041     0.200
     0.744    -0.056     0.200
     0.753     0.727     0.200
     0.775     0.943     0.200
     0.849     0.337     0.200
     0.857     0.485     0.200
     0.871     0.553     0.200
     0.933     0.576     0.200
     0.943     0.668     0.200
     0.959     0.927     0.200
     0.969     1.578     0.200
     0.997     0.008     0.200
     1.114     0.751     0.200
     1.173     0.437     0.200
     1.749     0.399     0.200
     1.749    -0.649     0.200
     1.957    -1.206     0.200
     1.976    -0.572     0.200
     2.083    -1.277     0.200
     0.135     0.961     0.200
     0.134     1.209     0.200
     0.181     0.885     0.200
     0.216     0.677     0.200
     0.257     1.020     0.200
     0.341     0.534     0.200
     0.331     0.680     0.200
     0.416     0.582     0.200
     0.420     0.491     0.200
     0.455     0.551     0.200
     0.601    -0.397     0.200
     0.661    -0.217     0.200
     0.746     0.355     0.200
     0.751     0.099     0.200
     0.770     0.522     0.200
     0.813     0.348     0.200
     0.901     1.309     0.200
     0.928     0.721     0.200
     0.974     1.305     0.200
     0.983     0.763     0.200
     0.984     0.801     0.200
     1.121     0.144     0.200
     1.162     0.334     0.200
     1.787    -0.502     0.200
     1.978    -0.201     0.200
     2.004    -0.690     0.200
     2.120    -1.433     0.200
     0.020     3.889     0.200
     0.096     2.122     0.200
     0.148     1.476     0.200
     0.188     1.274     0.200
     0.238     0.617     0.200
     0.475    -0.037     0.200
     0.481     0.448     0.200
     0.497     0.095     0.200
     0.504     1.006     0.200
     0.620     0.680     0.200
     0.680     0.431     0.200
     0.703     0.752     0.200
     0.736     0.787     0.200
     0.765     0.337     0.200
     0.796     1.160     0.200
     0.021     3.830     0.200
     0.106     1.984     0.200
     0.138     1.799     0.200
     0.188     1.148     0.200
     0.229     0.812     0.200
     0.380     0.259     0.200
     0.448    -0.153     0.200
     0.482     0.050     0.200
     0.491     0.304     0.200
     0.487     0.561     0.200
     0.504     0.954     0.200
     0.621     0.638     0.200
     0.625     0.401     0.200
     0.672     0.290     0.200
     0.676     1.285     0.200
     0.696     0.052     0.200
     0.709     0.338     0.200
     0.709     1.061     0.200
     0.726     0.389     0.200
     0.731     0.599     0.200
     0.759     0.677     0.200
     0.793     0.664     0.200
     0.826     0.116     0.200
     0.856     1.289     0.200
     0.912     0.467     0.200
     0.972     0.436     0.200
     0.995     0.769     0.200
     1.154    -0.217     0.200
     0.134     2.940     0.200
     0.174     2.388     0.200
     0.207     1.978     0.200
     0.299     1.131     0.200
     0.337     0.867     0.200
     0.386     1.233     0.200
     0.486     0.300     0.200
     0.556     1.375     0.200
     0.583     0.268     0.200
     0.625     1.294     0.200
     0.644     1.130     0.200
     0.695     0.392     0.200
     0.706     0.789     0.200
     0.724     0.387     0.200
     0.729     0.204     0.200
     0.743     0.659     0.200
     0.768     0.607     0.200
     0.834     0.295     0.200
     0.839     0.735     0.200
     0.828     0.795     0.200
     0.858     0.777     0.200
     0.915     0.644     0.200
     1.172    -1.209     0.200
     2.702    -4.094     0.200
     0.147     2.741     0.200
     0.188     1.882     0.200
     0.216     1.800     0.200
     0.313     0.286     0.200
     0.352     0.419     0.200
     0.397     0.482     0.200
     0.498     0.936     0.200
     0.562     0.605     0.200
     0.598     0.210     0.200
     0.636     0.052     0.200
     0.659     0.421     0.200
     0.700     0.803     0.200
     0.712     0.892     0.200
     0.736     0.999     0.200
     0.744     0.412     0.200
     0.744     1.012     0.200
     0.783     0.483     0.200
     0.837     0.389     0.200
     0.853     0.092     0.200
     0.870     0.752     0.200
     0.877     0.764     0.200
     0.930     0.888     0.200
     0.157     2.444     0.200
     0.196     2.050     0.200
     0.196     2.171     0.200
     0.219     1.960     0.200
     0.323     0.647     0.200
     0.360     0.592     0.200
     0.405     0.646     0.200
     0.507     0.478     0.200
     0.568     1.142     0.200
     0.607    -0.390     0.200
     0.641     0.888     0.200
     0.668     1.228     0.200
     0.706     0.919     0.200
     0.719     1.171     0.200
     0.745     0.536     0.200
     0.747     0.904     0.200
     0.792     0.696     0.200
     0.850     0.913     0.200
     0.841     0.398     0.200
     0.876     0.353     0.200
     0.940     0.599     0.200
     0.062     2.407     0.200
     0.094     1.942     0.200
     0.147     0.683     0.200
     0.209     1.099     0.200
     0.214     0.662     0.200
     0.286     0.654     0.200
     0.346     0.444     0.200
     0.422     0.749     0.200
     0.484    -0.796     0.200
     0.521     0.513     0.200
     0.526    -0.419     0.200
     0.544     0.380     0.200
     0.623     0.069     0.200
     0.644     0.203     0.200
     0.651    -0.118     0.200
     0.689    -0.055     0.200
     0.691     0.070     0.200
     0.716    -0.328     0.200
     0.748     0.833     0.200
     0.741     0.896     0.200
     0.773     0.308     0.200
     0.867     1.658     0.200
     1.064     0.786     0.200
     1.095     0.794     0.200
     0.094     2.372     0.200
     0.107     1.902     0.200
     0.155     1.762     0.200
     0.262     0.177     0.200
     0.258     0.960     0.200
     0.287     1.033     0.200
     0.417     0.258     0.200
     0.499     0.624     0.200
     0.525     0.615     0.200
     0.560    -0.001     0.200
     0.578     0.286     0.200
     0.609     0.093     0.200
     0.649     0.424     0.200
     0.694     0.443     0.200
     0.697    -0.157     0.200
     0.729     1.117     0.200
     0.728     0.060     0.200
     0.737     0.722     0.200
     0.756    -0.238     0.200
     0.791     0.862     0.200
     0.825     0.693     0.200
     0.821     0.672     0.200
     0.842     0.915     0.200
     0.924     0.400     0.200
     0.941     0.766     0.200
     0.976     0.899     0.200
     1.201    -0.481     0.200
     0.185     1.130     0.200
     0.267     0.334     0.200
     0.303    -0.060     0.200
     0.469     0.048     0.200
     0.594     0.948     0.200
     0.676     0.181     0.200
     0.696     0.429     0.200
     0.852     0.440     0.200
     0.973     0.240     0.200
     0.994     0.409     0.200
     1.617    -0.470     0.200
     0.100     2.253     0.200
     0.115     1.366     0.200
     0.151     1.587     0.200
     0.258     0.975     0.200
     0.317     0.390     0.200
     0.568     0.745     0.200
     0.591     0.106     0.200
     0.636     1.214     0.200
     0.854    -0.084     0.200
     0.960     0.541     0.200
     1.105     0.701     0.200
     1.757    -0.572     0.200
     0.035     2.207     0.200
     0.245     1.031     0.200
     0.367    -0.470     0.200
     0.401     0.017     0.200
     0.453     0.446     0.200
     0.671     0.694     0.200
     0.683     1.330     0.200
     0.705     0.635     0.200
     0.970     0.446     0.200
     1.082     0.635     0.200
     1.114     0.508     0.200
     0.138     1.233     0.200
     0.170     1.226     0.200
     0.191     0.944     0.200
     0.282     0.827     0.200
     0.293     1.269     0.200
     0.398     0.823     0.200
     0.451     0.568     0.200
     0.467     0.745     0.200
     0.522     0.419     0.200
     0.652     0.887     0.200
     0.661     0.768     0.200
     0.725     1.081     0.200
     0.107     1.484     0.200
     0.126     1.052     0.200
     0.146     1.139     0.200
     0.153     1.064     0.200
     0.300     0.287     0.200
     0.313     0.481     0.200
     0.324     0.050     0.200
     0.515     0.436     0.200
     0.527    -0.337     0.200
     0.540     0.343     0.200
     0.621     0.252     0.200
     0.160     0.199     0.200
     0.290     0.609     0.200
     0.297     0.250     0.200
     0.301     0.171     0.200
     0.316     0.418     0.200
     0.352     0.577     0.200
     0.424     0.556     0.200
     0.460     0.550     0.200
     0.618    -0.034     0.200
     0.719     0.833     0.200
     0.737     0.221     0.200
     0.818     0.614     0.200
     1.831     0.539     0.200
     1.851     0.656     0.200
     0.088     1.195     0.200
     0.177     0.932     0.200
     0.223     0.896     0.200
     0.230     0.733     0.200
     0.295     0.719     0.200
     0.335     0.769     0.200
     0.368     0.389     0.200
     0.368     0.668     0.200
     0.489     0.488     0.200
     0.585     0.767     0.200
     0.594     0.364     0.200
     0.030     3.258     0.200
     0.096     2.237     0.200
     0.151     1.717     0.200
     0.195     1.487     0.200
     0.250     1.111     0.200
     0.248     1.196     0.200
     0.328     0.847     0.200
     0.478     0.972     0.200
     0.516     1.378     0.200
     0.990     0.531     0.200
     0.065     1.458     0.200
     0.201     0.337     0.200
     0.261     0.933     0.200
     0.277     0.599     0.200
     0.278     0.641     0.200
     0.279     0.566     0.200
     0.331     0.371     0.200
     0.375     0.414     0.200
     0.389     0.395     0.200
     0.502     0.160     0.200
     0.553    -0.131     0.200
     0.596     0.275     0.200
     0.618     0.283     0.200
     0.630     0.443     0.200
     0.702    -0.056     0.200
     0.707    -0.172     0.200
     0.732    -0.603     0.200
     0.703     0.277     0.200
     0.767     0.277     0.200
     0.778     0.223     0.200
     0.825     0.743     0.200
     0.827     0.147     0.200
     0.827     0.725     0.200
     0.855    -0.076     0.200
     0.962     0.976     0.200
     0.996     0.783     0.200
     1.003    -0.300     0.200
     1.197     0.560     0.200
     1.974    -0.627     0.200
     2.658    -5.781     0.200
     2.710    -5.866     0.200
     0.054     1.564     0.200
     0.206     0.810     0.200
     0.271     1.129     0.200
     0.266     0.732     0.200
     0.267     0.732     0.200
     0.282     0.462     0.200
     0.322     0.558     0.200
     0.364     0.820     0.200
     0.377     0.733     0.200
     0.541     0.781     0.200
     0.588     0.755     0.200
     0.620     0.427     0.200
     0.631    -0.100     0.200
     0.693     0.497     0.200
     0.717     0.519     0.200
     0.779     0.510     0.200
     0.835     0.024     0.200
     0.839     0.140     0.200
     0.973     1.461     0.200
     1.210     0.412     0.200
     0.059     1.540     0.200
     0.203     0.748     0.200
     0.266     0.591     0.200
     0.279     0.334     0.200
     0.272     0.762     0.200
     0.273     0.590     0.200
     0.327     0.548     0.200
     0.369     0.168     0.200
     0.369     0.799     0.200
     0.383     0.905     0.200
     0.507    -0.092     0.200
     0.547     0.299     0.200
     0.592     0.748     0.200
     0.624     0.714     0.200
     0.624    -0.051     0.200
     0.625     0.967     0.200
     0.698     0.438     0.200
     0.731    -0.639     0.200
     0.830     0.332     0.200
     1.858    -0.346     0.200
     0.045     1.723     0.200
     0.200     0.722     0.200
     0.259     0.749     0.200
     0.265     0.801     0.200
     0.270     0.856     0.200
     0.276     0.674     0.200
     0.326     0.321     0.200
     0.355     0.214     0.200
     0.372     0.892     0.200
     0.513     0.317     0.200
     0.533     0.656     0.200
     0.578     0.484     0.200
     0.683     0.503     0.200
     0.874    -0.093     0.200
     0.974     0.561     0.200
     0.067     1.864     0.200
     0.133     0.620     0.200
     0.191     1.054     0.200
     0.205     0.457     0.200
     0.205     1.105     0.200
     0.317     0.591     0.200
     0.409     0.571     0.200
     0.423     0.497     0.200
     0.483     0.508     0.200
     0.498     0.633     0.200
     0.563     0.663     0.200
     0.586     0.977     0.200
     0.635     0.653     0.200
     1.055     0.843     0.200
     1.867     0.393     0.200
     0.060     1.466     0.200
     0.202     0.564     0.200
     0.265     0.855     0.200
     0.278     0.459     0.200
     0.273     0.644     0.200
     0.274     0.371     0.200
     0.328     0.920     0.200
     0.369     0.789     0.200
     0.384     0.912     0.200
     0.592     0.582     0.200
     0.623     0.663     0.200
     0.772    -0.146     0.200
     0.828    -0.140     0.200
     1.044     1.306     0.200
     0.051     1.535     0.200
     0.204     0.551     0.200
     0.264     0.783     0.200
     0.271     0.898     0.200
     0.266     0.493     0.200
     0.280     0.502     0.200
     0.323     0.345     0.200
     0.361     0.653     0.200
     0.375     0.795     0.200
     0.513     0.466     0.200
     0.538     0.308     0.200
     0.584     0.218     0.200
     0.616     0.212     0.200
     0.632     0.791     0.200
     0.717     0.775     0.200
     0.781     0.516     0.200
     0.785     0.552     0.200
     0.820     0.958     0.200
     0.834    -0.214     0.200
     0.841     0.674     0.200
     0.974     0.502     0.200
     1.049     1.295     0.200
     1.211    -0.013     0.200
     1.866    -0.126     0.200
     0.039     1.851     0.200
     0.187     0.964     0.200
     0.252     0.945     0.200
     0.263     0.658     0.200
     0.264     0.881     0.200
     0.268     0.552     0.200
     0.346     0.866     0.200
     0.372     0.885     0.200
     0.527     1.121     0.200
     0.565     0.686     0.200
     0.600    -0.071     0.200
     0.051     1.697     0.200
     0.206     0.739     0.200
     0.264     0.904     0.200
     0.273     1.080     0.200
     0.264     0.713     0.200
     0.282     0.490     0.200
     0.321     0.715     0.200
     0.361     0.670     0.200
     0.374     0.914     0.200
     0.515     0.492     0.200
     0.538     0.234     0.200
     0.586     0.257     0.200
     0.617     0.757     0.200
     0.633     0.197     0.200
     0.633     0.594     0.200
     0.690     0.704     0.200
     0.719     0.595     0.200
     0.787     0.277     0.200
     0.782     1.642     0.200
     0.836     0.936     0.200
     1.011     0.875     0.200
     1.051     0.779     0.200
     0.072     2.292     0.200
     0.103     1.591     0.200
     0.182     1.674     0.200
     0.230     1.399     0.200
     0.245     0.909     0.200
     0.338     0.955     0.200
     0.425     0.626     0.200
     0.449     0.970     0.200
     0.523     0.883     0.200
     0.575     0.789     0.200
     0.607     1.157     0.200
     0.646     1.422     0.200
     0.983     0.704     0.200
     1.098     0.217     0.200
     0.072     2.085     0.200
     0.338     0.584     0.200
     0.425     0.309     0.200
     0.537     0.525     0.200
     0.646     1.531     0.200
     1.098    -0.009     0.200
     0.043     1.747     0.200
     0.209     0.824     0.200
     0.255     0.778     0.200
     0.256     0.501     0.200
     0.280     0.412     0.200
     0.286     0.471     0.200
     0.316     0.769     0.200
     0.353     0.655     0.200
     0.365     0.904     0.200
     0.522     0.021     0.200
     0.529     0.023     0.200
     0.579     0.592     0.200
     0.609     0.526     0.200
     0.642     0.063     0.200
     0.642     0.280     0.200
     0.682     0.486     0.200
     0.696     0.206     0.200
     0.729    -0.275     0.200
     0.726     0.606     0.200
     0.791    -0.165     0.200
     0.792     0.566     0.200
     0.819     0.984     0.200
     0.843     0.433     0.200
     0.851     0.401     0.200
     0.880     0.954     0.200
     0.983     0.794     0.200
     1.022     0.257     0.200
     1.021     0.311     0.200
     1.057     0.287     0.200
     1.221     0.449     0.200
     1.636     0.721     0.200
     1.667     0.343     0.200
     1.876     0.230     0.200
     1.998    -0.521     0.200
     0.045     2.232     0.200
     0.198     1.081     0.200
     0.259     1.145     0.200
     0.269     1.136     0.200
     0.265     0.852     0.200
     0.275     0.929     0.200
     0.327     1.409     0.200
     0.355     1.013     0.200
     0.373     1.121     0.200
     0.577     1.630     0.200
     0.633     0.660     0.200
     0.683     1.191     0.200
     0.784     0.768     0.200
     0.842     0.923     0.200
     0.198     1.611     0.200
     0.327     0.929     0.200
     0.355     0.903     0.200
     0.373     0.791     0.200
     0.533     0.983     0.200
     0.577     1.230     0.200
     0.683     0.811     0.200
     0.055     3.717     0.200
     0.218     2.080     0.200
     0.274     1.732     0.200
     0.278     1.836     0.200
     0.385     1.472     0.200
     0.466     0.424     0.200
     0.466     1.174     0.200
     0.557     0.982     0.200
     0.620     1.596     0.200
     0.654     1.337     0.200
     0.063     1.493     0.200
     0.195     0.600     0.200
     0.257     0.737     0.200
     0.271     0.104     0.200
     0.276     0.793     0.200
     0.372     0.799     0.200
     0.390     0.645     0.200
     0.459    -0.287     0.200
     0.447     0.150     0.200
     0.498     0.048     0.200
     0.595     0.431     0.200
     0.617     0.795     0.200
     0.618     0.639     0.200
     0.626     0.694     0.200
     0.767     0.661     0.200
     1.850    -0.178     0.200
     0.049     1.585     0.200
     0.199     0.424     0.200
     0.268     0.661     0.200
     0.262     0.548     0.200
     0.275     0.135     0.200
     0.359     0.649     0.200
     0.376     0.553     0.200
     0.451    -0.062     0.200
     0.473    -0.067     0.200
     0.608     0.321     0.200
     0.614     0.561     0.200
     0.631     0.307     0.200
     0.632     0.395     0.200
     0.781     0.382     0.200
     1.045     0.716     0.200
     1.655     0.607     0.200
     0.530    -1.295     0.200
     0.628     0.184     0.200
     0.083     1.111     0.200
     0.180     0.326     0.200
     0.231     0.267     0.200
     0.257     0.503     0.200
     0.310     0.569     0.200
     0.292     0.666     0.200
     0.361     0.382     0.200
     0.539    -0.831     0.200
     0.585     0.018     0.200
     0.605     0.144     0.200
     0.629     1.245     0.200
     0.750    -0.250     0.200
     0.895    -0.178     0.200
     0.900     0.164     0.200
     1.295     0.195     0.200
     0.901    -0.660     0.200
     0.838    -0.714     0.200
     2.437    -3.699     0.200
     3.131    -5.990     0.200
     0.089     1.831     0.200
     0.089     1.963     0.200
     0.161     0.730     0.200
     0.236     0.465     0.200
     0.256     0.559     0.200
     0.295     0.820     0.200
     0.321    -0.148     0.200
     0.511     0.238     0.200
     0.514    -0.144     0.200
     0.591     0.744     0.200
     0.665    -0.203     0.200
     0.785     0.765     0.200
     1.181     0.494     0.200
     0.111     0.830     0.200
     0.262     0.354     0.200
     0.263     0.789     0.200
     0.284     0.372     0.200
     0.304     0.608     0.200
     0.608     0.242     0.200
     0.658     0.444     0.200
     0.671     0.286     0.200
     0.808     0.102     0.200
     0.818     0.146     0.200
     0.961     1.039     0.200
     0.023     4.013     0.200
     0.138     1.836     0.200
     0.191     1.189     0.200
     0.231     0.986     0.200
     0.308     0.906     0.200
     0.318     0.626     0.200
     0.484     0.008     0.200
     0.489     0.465     0.200
     0.585     0.106     0.200
     0.727     0.234     0.200
     0.732     0.365     0.200
     0.748     0.623     0.200
     0.761     0.811     0.200
     0.795     0.423     0.200
     0.211     0.661     0.200
     0.297     0.868     0.200
     0.410     0.345     0.200
     0.412     0.658     0.200
     0.447     0.664     0.200
     0.468     0.738     0.200
     0.486     0.664     0.200
     0.701     0.587     0.200
     0.749     0.354     0.200
     0.737     0.913     0.200
     2.157    -0.872     0.200
     0.061     1.338     0.200
     0.206     0.460     0.200
     0.273     0.494     0.200
     0.282     0.285     0.200
     0.371     0.662     0.200
     0.382     0.666     0.200
     0.466    -0.381     0.200
     0.452     0.122     0.200
     0.597     0.168     0.200
     0.604     0.699     0.200
     0.625     0.110     0.200
     0.833     0.236     0.200
     1.107     0.554     0.200
     0.048     2.083     0.200
     0.199     0.892     0.200
     0.262     1.097     0.200
     0.269     1.044     0.200
     0.276     0.651     0.200
     0.358     0.567     0.200
     0.375     0.889     0.200
     0.440     0.010     0.200
     0.452     0.632     0.200
     0.474    -0.255     0.200
     0.511     0.350     0.200
     0.600     0.686     0.200
     0.609     0.961     0.200
     0.631     0.754     0.200
     0.633     0.578     0.200
     0.686     0.304     0.200
     0.691     0.678     0.200
     0.202     0.998     0.200
     0.262     0.629     0.200
     0.278     0.630     0.200
     0.279     0.696     0.200
     0.330     0.670     0.200
     0.375     0.710     0.200
     0.389     1.013     0.200
     0.459    -0.384     0.200
     0.452     0.526     0.200
     0.617     0.429     0.200
     0.618     0.711     0.200
     0.631     0.364     0.200
     0.703     0.451     0.200
     0.766     0.765     0.200
     0.780     0.950     0.200
     0.827     0.386     0.200
     0.828     0.110     0.200
     0.546    -0.704     0.200
     0.199     0.791     0.200
     0.262     1.247     0.200
     0.274     0.902     0.200
     0.275     0.691     0.200
     0.370     0.669     0.200
     0.446     0.689     0.200
     0.451     0.353     0.200
     0.621     0.726     0.200
     0.621     0.667     0.200
     0.698     0.876     0.200
     0.778     0.276     0.200
     0.823     0.902     0.200
     0.213     0.621     0.200
     0.277     0.239     0.200
     0.289     0.481     0.200
     0.375     0.138     0.200
     0.383     0.583     0.200
     0.466     0.184     0.200
     0.460     0.087     0.200
     0.512     0.113     0.200
     0.592     0.329     0.200
     0.602     0.675     0.200
     0.622     0.330     0.200
     0.625     0.153     0.200
     0.705     1.051     0.200
     0.771     0.205     0.200
     0.833     0.419     0.200
     0.836     1.261     0.200
     0.052     2.625     0.200
     0.128     1.966     0.200
     0.168     1.384     0.200
     0.202     0.761     0.200
     0.302    -0.668     0.200
     0.326     0.783     0.200
     0.406     0.372     0.200
     0.554    -0.146     0.200
     0.551     0.352     0.200
     0.601     0.273     0.200
     0.690    -0.558     0.200
     0.697     0.029     0.200
     0.797    -0.392     0.200
     0.205     0.173     0.200
     0.271     0.485     0.200
     0.266     0.463     0.200
     0.267     0.752     0.200
     0.281     0.301     0.200
     0.323     0.471     0.200
     0.363     0.830     0.200
     0.376     0.631     0.200
     0.447     0.276     0.200
     0.472    -0.295     0.200
     0.457    -0.113     0.200
     0.458     0.070     0.200
     0.512     0.298     0.200
     0.540     0.230     0.200
     0.587     0.552     0.200
     0.603    -0.164     0.200
     0.604     0.703     0.200
     0.599     0.762     0.200
     0.619     0.813     0.200
     0.631     0.222     0.200
     0.630     0.666     0.200
     0.692     0.995     0.200
     0.698     0.400     0.200
     0.730    -0.075     0.200
     0.779    -0.138     0.200
     0.785     1.274     0.200
     0.823     1.013     0.200
     0.834     0.250     0.200
     1.009     0.845     0.200
     1.013     0.643     0.200
     1.049     0.755     0.200
     1.111     0.817     0.200
     1.154     0.942     0.200
     1.834     0.113     0.200
     1.864     0.298     0.200
     1.987    -0.367     0.200
     0.533    -1.157     0.200
     0.631    -0.189     0.200
     0.623    -0.499     0.200
     0.036     3.720     0.200
     0.127     1.666     0.200
     0.202     1.122     0.200
     0.230     0.937     0.200
     0.253     1.000     0.200
     0.299     1.096     0.200
     0.304     0.907     0.200
     0.375     0.272     0.200
     0.447     0.197     0.200
     0.496     0.417     0.200
     0.497     0.567     0.200
     0.502     0.583     0.200
     0.516     0.764     0.200
     0.635     0.237     0.200
     0.711     0.803     0.200
     0.720     0.864     0.200
     0.723     0.011     0.200
     0.743     0.407     0.200
     0.802     0.872     0.200
     0.988     0.219     0.200
     1.009     0.521     0.200
     0.061     0.219     0.200
     0.142    -0.154     0.200
     0.227     0.320     0.200
     0.369     0.575     0.200
     0.374     0.691     0.200
     0.390     0.159     0.200
     0.395    -0.008     0.200
     0.420     0.186     0.200
     0.525    -0.204     0.200
     0.533     0.853     0.200
     0.537     0.380     0.200
     0.562    -0.174     0.200
     0.572     0.475     0.200
     0.802     1.448     0.200
     0.921     0.890     0.200
     0.972     0.567     0.200
     0.063     2.691     0.200
     0.091     1.826     0.200
     0.177     1.201     0.200
     0.186     0.797     0.200
     0.252     1.202     0.200
     0.323     0.380     0.200
     0.309     1.034     0.200
     0.393     0.602     0.200
     0.448     0.128     0.200
     0.488     0.539     0.200
     0.506     0.741     0.200
     0.516     0.689     0.200
     0.527    -0.211     0.200
     0.587     0.249     0.200
     0.613     0.217     0.200
     0.620     0.541     0.200
     0.669     0.612     0.200
     0.675     0.938     0.200
     0.682     0.158     0.200
     0.690     0.462     0.200
     0.692     0.350     0.200
     0.713     0.888     0.200
     0.736     0.978     0.200
     0.764     0.826     0.200
     0.975     0.383     0.200
     1.052     0.752     0.200
     0.055     2.675     0.200
     0.099     1.268     0.200
     0.180     0.897     0.200
     0.180     0.876     0.200
     0.260     0.795     0.200
     0.316     0.350     0.200
     0.330    -0.000     0.200
     0.449     0.697     0.200
     0.484     0.712     0.200
     0.498     0.528     0.200
     0.535     0.582     0.200
     0.587     0.950     0.200
     0.608     0.390     0.200
     0.623     0.103     0.200
     0.676     0.746     0.200
     0.680     0.604     0.200
     0.683     0.946     0.200
     0.684     0.368     0.200
     0.695    -0.114     0.200
     0.715     0.571     0.200
     0.727     0.426     0.200
     0.762     0.740     0.200
     0.775     1.412     0.200
     0.852     1.271     0.200
     0.865     1.445     0.200
     0.944     1.047     0.200
     0.961     1.060     0.200
     0.982     1.053     0.200
     0.983     1.131     0.200
     0.986     1.174     0.200
     1.103     0.579     0.200
     1.100     0.904     0.200
     1.206     0.093     0.200
     0.315     0.085     0.200
     1.245    -0.601     0.200
     1.335    -1.416     0.200
     0.060     2.579     0.200
     0.092     1.788     0.200
     0.180     0.814     0.200
     0.187     0.739     0.200
     0.255     1.258     0.200
     0.308     1.210     0.200
     0.397     0.094     0.200
     0.451     0.795     0.200
     0.490     1.205     0.200
     0.506     0.292     0.200
     0.590     0.547     0.200
     0.615     0.567     0.200
     0.623     0.677     0.200
     0.672     0.316     0.200
     0.678     0.800     0.200
     0.685     0.280     0.200
     0.692     0.580     0.200
     0.717     0.670     0.200
     0.735     0.645     0.200
     0.767     0.832     0.200
     0.860     1.125     0.200
     0.978     0.273     0.200
     0.976     0.677     0.200
     0.994     0.790     0.200
     0.105     0.580     0.200
     0.090     0.873     0.200
     0.216     0.668     0.200
     0.260     0.683     0.200
     0.293     0.277     0.200
     0.348     0.571     0.200
     0.335     1.073     0.200
     0.369     0.460     0.200
     0.362     1.018     0.200
     0.375     0.125     0.200
     0.383    -0.188     0.200
     0.498     0.808     0.200
     0.516     0.630     0.200
     0.554     0.310     0.200
     0.561     0.312     0.200
     0.596     0.326     0.200
     0.613     0.502     0.200
     0.648     1.151     0.200
     0.834     0.902     0.200
     0.882     0.670     0.200
     0.931     0.726     0.200
     0.090     3.350     0.200
     0.170     1.864     0.200
     0.188     2.101     0.200
     0.262     1.694     0.200
     0.310     0.827     0.200
     0.323     0.999     0.200
     0.330     1.338     0.200
     0.323     1.178     0.200
     0.385     2.160     0.200
     0.442     0.165     0.200
     0.434     0.985     0.200
     0.534     0.820     0.200
     0.610     0.336     0.200
     0.582     1.696     0.200
     0.639     0.198     0.200
     0.674     0.566     0.200
     0.734     0.344     0.200
     0.767     0.713     0.200
     0.792    -0.165     0.200
     0.810     0.062     0.200
     0.834    -0.062     0.200
     0.897     0.675     0.200
     0.970    -0.104     0.200
     0.972     0.372     0.200
     1.002    -0.152     0.200
     1.042    -0.580     0.200
     1.685    -1.631     0.200
     1.739    -1.302     0.200
     1.731    -1.863     0.200
     1.789    -1.532     0.200
     1.832    -1.489     0.200
     1.907    -2.355     0.200
     1.930    -2.150     0.200
     1.958    -1.547     0.200
     0.119     0.400     0.200
     0.228     0.210     0.200
     0.210     1.198     0.200
     0.247     0.270     0.200
     0.272     0.460     0.200
     0.389     0.747     0.200
     0.384     0.591     0.200
     0.476     0.153     0.200
     0.527     0.646     0.200
     0.545     0.809     0.200
     0.529     1.243     0.200
     0.551     0.248     0.200
     0.661     0.411     0.200
     0.657     0.726     0.200
     0.703     0.895     0.200
     0.719     0.694     0.200
     0.846     0.092     0.200
     0.828     1.754     0.200
     0.971    -0.091     0.200
     1.031     1.013     0.200
     1.088    -0.709     0.200
     0.207     0.209     0.200
     0.268     0.299     0.200
     0.283     0.187     0.200
     0.272     0.529     0.200
     0.274     0.729     0.200
     0.324     0.549     0.200
     0.371     0.699     0.200
     0.383     0.797     0.200
     0.466    -0.300     0.200
     0.452     0.032     0.200
     0.453     0.453     0.200
     0.459     0.864     0.200
     0.509     0.337     0.200
     0.548     0.771     0.200
     0.596     0.834     0.200
     0.602     0.362     0.200
     0.595     0.767     0.200
     0.604     0.434     0.200
     0.623     0.079     0.200
     0.625     0.337     0.200
     0.627     0.619     0.200
     0.704     0.391     0.200
     0.700     0.849     0.200
     0.714     0.319     0.200
     0.735    -0.269     0.200
     0.772     0.795     0.200
     0.785     0.897     0.200
     0.832     0.413     0.200
     0.833     0.428     0.200
     0.829     0.660     0.200
     0.969     0.853     0.200
     1.002     1.045     0.200
     1.010     0.687     0.200
     1.047     0.803     0.200
     1.107     0.386     0.200
     1.148     0.821     0.200
     1.204     0.862     0.200
     1.649     0.705     0.200
     1.829     0.294     0.200
     1.859     0.630     0.200
     1.980    -0.265     0.200
     0.541    -0.571     0.200
     0.639    -0.121     0.200
     0.615    -0.189     0.200
     2.068     0.577     0.200
     0.061     0.430     0.200
     0.174     0.846     0.200
     0.196    -0.091     0.200
     0.241     0.667     0.200
     0.320    -0.329     0.200
     0.353     0.554     0.200
     0.389     0.731     0.200
     0.429    -0.410     0.200
     0.428     0.498     0.200
     0.480    -0.396     0.200
     0.490    -0.213     0.200
     0.487     0.819     0.200
     0.512     0.083     0.200
     0.633     0.876     0.200
     0.705     0.264     0.200
     0.716     0.761     0.200
     0.721     0.832     0.200
     0.786     0.837     0.200
     0.959     0.321     0.200
     1.037     0.870     0.200
     1.105    -0.127     0.200
     1.153     1.107     0.200
     1.182     0.793     0.200
     1.776     0.163     0.200
     1.835     0.119     0.200
     0.050     0.293     0.200
     0.239     0.310     0.200
     0.247     1.030     0.200
     0.294     0.919     0.200
     0.354     0.332     0.200
     0.394     0.642     0.200
     0.386     0.689     0.200
     0.458     1.132     0.200
     0.539     0.567     0.200
     0.592     0.470     0.200
     0.805     0.858     0.200
     0.835     0.628     0.200
     0.908     0.798     0.200
     0.959     1.016     0.200
     1.304     0.838     0.200
     0.099     2.237     0.200
     0.236     0.679     0.200
     0.241     0.685     0.200
     0.236     1.145     0.200
     0.334     0.527     0.200
     0.389    -0.394     0.200
     0.376     0.496     0.200
     0.370     0.520     0.200
     0.445     0.098     0.200
     0.451     0.459     0.200
     0.513     1.007     0.200
     0.528     0.386     0.200
     0.598    -0.194     0.200
     0.582     1.349     0.200
     0.740    -0.279     0.200
     0.715     1.223     0.200
     0.755    -0.197     0.200
     0.743     0.523     0.200
     0.771     0.300     0.200
     0.780    -0.089     0.200
     0.756     0.751     0.200
     0.795    -0.223     0.200
     0.784     0.974     0.200
     0.825     0.216     0.200
     0.953     0.344     0.200
     0.951     0.501     0.200
     1.086     0.236     0.200
     1.120     0.492     0.200
     1.144    -0.024     0.200
     1.604    -0.260     0.200
     1.646     0.166     0.200
     1.730    -0.427     0.200
     1.744    -0.423     0.200
     1.805    -0.731     0.200
     0.135     0.539     0.200
     0.212     0.169     0.200
     0.295     0.695     0.200
     0.296     0.522     0.200
     0.320     1.128     0.200
     0.354    -0.112     0.200
     0.372    -0.345     0.200
     0.427     0.753     0.200
     0.547    -0.300     0.200
     0.594     0.239     0.200
     0.636    -0.211     0.200
     0.612     1.210     0.200
     0.863     0.580     0.200
     0.912     0.243     0.200
     0.943     0.485     0.200
     0.953     0.403     0.200
     1.096     1.080     0.200
     1.104     0.580     0.200
     1.154     0.373     0.200
     1.745     0.071     0.200
     1.804    -0.312     0.200
     1.888    -0.347     0.200
     1.902    -0.212     0.200
     1.963    -0.770     0.200
     0.081     2.200     0.200
     0.184     0.861     0.200
     0.231     0.805     0.200
     0.251     0.686     0.200
     0.262     1.453     0.200
     0.361     0.157     0.200
     0.425    -0.596     0.200
     0.406     0.693     0.200
     0.491     0.364     0.200
     0.552     0.900     0.200
     0.591     1.569     0.200
     0.644    -0.247     0.200
     0.634    -0.196     0.200
     0.641     0.688     0.200
     0.657    -0.086     0.200
     0.796    -0.300     0.200
     0.926     0.065     0.200
     0.943     0.833     0.200
     0.987     0.138     0.200
     1.112     0.383     0.200
     1.129    -0.207     0.200
     1.273     0.198     0.200
     1.634    -1.243     0.200
     1.675    -0.153     0.200
     1.791    -0.109     0.200
     1.838    -0.879     0.200
     1.929    -0.819     0.200
     1.939    -1.637     0.200
     1.989    -0.844     0.200
     1.999    -1.380     0.200
     0.099     1.697     0.200
     0.175     1.279     0.200
     0.246     0.568     0.200
     0.241     1.014     0.200
     0.309     0.801     0.200
     0.307     0.669     0.200
     0.349     0.435     0.200
     0.378    -0.039     0.200
     0.373     1.104     0.200
     0.494     0.909     0.200
     0.592    -0.331     0.200
     0.587     0.500     0.200
     0.604     0.278     0.200
     0.584     1.003     0.200
     0.639     1.578     0.200
     0.646     1.265     0.200
     0.740    -0.408     0.200
     0.873     0.011     0.200
     0.897     0.014     0.200
     0.896    -0.132     0.200
     0.922     0.346     0.200
     0.931     0.349     0.200
     1.073     0.419     0.200
     1.138     0.620     0.200
     1.217    -0.046     0.200
     1.621    -0.168     0.200
     1.736    -0.228     0.200
     1.781    -0.531     0.200
     1.873    -1.267     0.200
     1.942    -1.126     0.200
     0.040     3.894     0.200
     0.223     1.982     0.200
     0.297     0.932     0.200
     0.306     2.428     0.200
     0.397     1.275     0.200
     0.435     1.203     0.200
     0.502     0.675     0.200
     0.486     2.795     0.200
     0.542     1.948     0.200
     0.630     0.324     0.200
     0.611     1.501     0.200
     0.753     0.472     0.200
     0.787     0.014     0.200
     0.824    -0.408     0.200
     0.837     0.979     0.200
     0.896    -0.378     0.200
     0.900    -0.193     0.200
     0.961    -0.408     0.200
     1.084    -0.713     0.200
     1.602    -1.043     0.200
     1.646    -0.959     0.200
     1.712    -1.334     0.200
     1.763    -1.472     0.200
     1.818    -1.865     0.200
     1.825    -1.655     0.200
     0.112     2.290     0.200
     0.144     1.561     0.200
     0.177     1.537     0.200
     0.238     0.729     0.200
     0.254     0.710     0.200
     0.255     1.046     0.200
     0.367     0.751     0.200
     0.401     1.599     0.200
     0.478     0.378     0.200
     0.539     0.818     0.200
     0.552     0.594     0.200
     0.606     1.347     0.200
     0.621     0.311     0.200
     0.636     0.111     0.200
     0.661    -0.203     0.200
     0.701     0.923     0.200
     0.716     1.540     0.200
     0.743     0.846     0.200
     0.755     1.164     0.200
     0.772     0.840     0.200
     0.792     0.633     0.200
     0.787     0.623     0.200
     0.805     1.029     0.200
     0.865     0.821     0.200
     0.891     0.793     0.200
     0.907     1.186     0.200
     0.935     0.547     0.200
     0.983     0.830     0.200
     1.029    -0.482     0.200
     1.079     0.625     0.200
     0.196     0.249     0.200
     0.261     0.413     0.200
     0.272     0.379     0.200
     0.271     0.566     0.200
     0.276     0.781     0.200
     0.332     0.603     0.200
     0.366     0.873     0.200
     0.384     0.792     0.200
     0.442     0.286     0.200
     0.448     0.428     0.200
     0.465    -0.209     0.200
     0.449     0.454     0.200
     0.503     0.292     0.200
     0.545     0.567     0.200
     0.587     0.586     0.200
     0.601     0.669     0.200
     0.622     0.409     0.200
     0.624     0.769     0.200
     0.621     0.658     0.200
     0.693     0.597     0.200
     0.724    -0.493     0.200
     0.694     0.768     0.200
     0.707     0.444     0.200
     0.773     0.408     0.200
     0.818     0.745     0.200
     0.824     0.736     0.200
     0.964     0.602     0.200
     1.003     0.644     0.200
     1.002     0.960     0.200
     1.039     0.780     0.200
     1.102     0.871     0.200
     1.146     0.888     0.200
     1.825    -0.092     0.200
     1.856    -0.068     0.200
     1.979    -0.258     0.200
     0.142     1.210     0.200
     0.127     1.558     0.200
     0.281     0.127     0.200
     0.255     0.924     0.200
     0.346    -0.237     0.200
     0.360     0.593     0.200
     0.339     1.030     0.200
     0.506     0.887     0.200
     0.557    -0.090     0.200
     0.563    -0.024     0.200
     0.574     0.039     0.200
     0.602     0.594     0.200
     0.611     1.409     0.200
     0.665     1.272     0.200
     0.704     0.073     0.200
     0.706    -0.046     0.200
     0.672     1.582     0.200
     0.790    -0.183     0.200
     0.797     0.007     0.200
     0.841     0.345     0.200
     0.865     0.194     0.200
     0.853     0.706     0.200
     0.870     0.336     0.200
     0.886    -0.165     0.200
     0.895     0.209     0.200
     1.039     0.785     0.200
     1.103     0.152     0.200
     1.181     0.221     0.200
     1.249     0.144     0.200
     1.639    -0.076     0.200
     1.690    -0.277     0.200
     1.701    -0.309     0.200
     1.746    -0.231     0.200
     1.837    -0.763     0.200
     1.847    -1.081     0.200
     1.907    -0.957     0.200
     0.870    -0.685     0.200
     1.827    -1.770     0.200
     1.911    -3.226     0.200
     2.483    -4.423     0.200
     0.118     0.870     0.200
     0.217     0.655     0.200
     0.327     0.361     0.200
     0.347     0.238     0.200
     0.346     0.717     0.200
     0.364     0.675     0.200
     0.595     0.322     0.200
     0.698     0.371     0.200
     0.783     0.173     0.200
     1.046     0.342     0.200
     1.059     0.396     0.200
     1.653    -0.002     0.200
     0.170     0.870     0.200
     0.199     0.487     0.200
     0.223     0.981     0.200
     0.299     0.499     0.200
     0.351     0.212     0.200
     0.364     0.480     0.200
     0.461     0.301     0.200
     0.553     0.077     0.200
     0.579     0.558     0.200
     0.612     0.670     0.200
     0.630     0.401     0.200
     0.638     0.242     0.200
     0.655     0.740     0.200
     0.770     0.528     0.200
     0.770     0.321     0.200
     0.779     0.424     0.200
     0.770     0.761     0.200
     0.788     0.295     0.200
     0.788     0.705     0.200
     0.803     0.789     0.200
     0.837     0.254     0.200
     0.860     0.611     0.200
     0.853     0.445     0.200
     0.870     0.828     0.200
     0.943     0.488     0.200
     0.959     1.016     0.200
     0.981     0.745     0.200
     0.996     0.808     0.200
     1.011     0.819     0.200
     1.041     0.928     0.200
     1.050     0.744     0.200
     1.085     1.036     0.200
     1.248    -0.208     0.200
     0.170     0.753     0.200
     0.199     0.347     0.200
     0.364     0.597     0.200
     0.612     0.841     0.200
     0.630     0.128     0.200
     0.638     0.406     0.200
     0.655     0.600     0.200
     0.770     0.193     0.200
     0.770     0.110     0.200
     0.779     0.658     0.200
     0.788     0.170     0.200
     0.770     1.050     0.200
     0.788     0.494     0.200
     0.837     0.136     0.200
     0.860     0.330     0.200
     0.853     0.859     0.200
     0.870     1.422     0.200
     0.943     0.113     0.200
     0.959     0.758     0.200
     1.011     1.030     0.200
     1.050     0.557     0.200
     1.041     1.030     0.200
     1.085     0.865     0.200
     1.134     0.917     0.200
     1.248    -0.043     0.200
     0.212     1.187     0.200
     0.763     0.037     0.200
     1.308    -1.215     0.200
     1.404    -1.084     0.200
     0.135     1.072     0.200
     0.134     1.752     0.200
     0.213     1.305     0.200
     0.289     0.548     0.200
     0.302     0.558     0.200
     0.312     0.908     0.200
     0.398     0.379     0.200
     0.489     0.456     0.200
     0.570     0.312     0.200
     0.578     0.454     0.200
     0.579     0.781     0.200
     0.596     0.333     0.200
     0.613     0.492     0.200
     0.713     0.434     0.200
     0.720     0.356     0.200
     0.725     0.217     0.200
     0.727     0.315     0.200
     0.733     0.461     0.200
     0.773     0.600     0.200
     0.787     0.805     0.200
     0.782     0.721     0.200
     0.810     0.430     0.200
     0.853     1.047     0.200
     0.892     0.686     0.200
     0.925     0.742     0.200
     0.969     0.577     0.200
     0.968     0.795     0.200
     0.988     0.478     0.200
     0.991     0.676     0.200
     0.996     0.983     0.200
     1.078     0.917     0.200
     1.090     0.942     0.200
     1.184    -0.602     0.200
     1.248     0.342     0.200
     0.331     0.749     0.200
     0.320     0.873     0.200
     0.341     0.752     0.200
     0.358     0.750     0.200
     0.417    -0.253     0.200
     0.409     0.647     0.200
     0.419     0.924     0.200
     0.459     0.998     0.200
     0.482     0.862     0.200
     0.527     0.850     0.200
     0.535     0.431     0.200
     0.616     0.719     0.200
     0.686     0.563     0.200
     0.687     0.970     0.200
     0.692     0.773     0.200
     0.744     0.419     0.200
     0.763     0.636     0.200
     0.787     1.116     0.200
     0.860     1.019     0.200
     0.868     0.711     0.200
     0.894     0.150     0.200
     0.868     0.638     0.200
     0.880     0.585     0.200
     0.917     0.880     0.200
     0.972     0.896     0.200
     0.994     0.840     0.200
     1.113     0.785     0.200
     1.595     0.419     0.200
     1.816    -0.332     0.200
     1.920    -0.657     0.200
     0.162     0.931     0.200
     0.230     1.122     0.200
     0.293     0.471     0.200
     0.306     1.427     0.200
     0.353     0.663     0.200
     0.379     0.428     0.200
     0.479     0.832     0.200
     0.588     0.482     0.200
     0.590     0.487     0.200
     0.578     1.046     0.200
     0.818     0.601     0.200
     0.857     0.526     0.200
     0.921     0.297     0.200
     1.043     0.659     0.200
     1.131     0.686     0.200
     0.108     1.508     0.200
     0.133     1.393     0.200
     0.229     0.949     0.200
     0.232     1.235     0.200
     0.343     0.852     0.200
     0.391     0.682     0.200
     0.466     0.203     0.200
     0.470     0.541     0.200
     0.460     0.689     0.200
     0.568     0.627     0.200
     0.594     0.973     0.200
     0.610     0.922     0.200
     0.641     0.384     0.200
     0.667     0.772     0.200
     0.711     0.295     0.200
     0.789     0.993     0.200
     0.797     0.592     0.200
     0.806     0.873     0.200
     0.813     0.622     0.200
     0.852     0.008     0.200
     0.920     0.648     0.200
     0.939     0.867     0.200
     0.979     0.857     0.200
     1.033     1.073     0.200
     1.166     0.659     0.200
     1.612     0.225     0.200
     1.815    -0.403     0.200
     0.111     1.185     0.200
     0.135     1.627     0.200
     0.279     0.878     0.200
     0.317     0.161     0.200
     0.398     0.326     0.200
     0.480     0.154     0.200
     0.481     0.308     0.200
     0.521     0.274     0.200
     0.664     0.366     0.200
     0.733     0.098     0.200
     0.745     0.479     0.200
     0.783     0.297     0.200
     0.993     0.223     0.200
     1.153     0.525     0.200
     1.202     0.589     0.200
     1.829    -0.898     0.200
     2.283    -1.908     0.200
     2.400    -2.432     0.200
     0.021     2.648     0.200
     0.173     1.201     0.200
     0.172     0.899     0.200
     0.271     0.846     0.200
     0.349     0.635     0.200
     0.447     0.787     0.200
     0.501     0.683     0.200
     0.517     0.592     0.200
     0.539     0.360     0.200
     0.552     0.378     0.200
     0.572     0.607     0.200
     0.219     0.746     0.200
     0.228     0.589     0.200
     0.281     0.633     0.200
     0.309     0.521     0.200
     0.342     0.849     0.200
     0.361     0.658     0.200
     0.385     0.463     0.200
     0.393     0.448     0.200
     0.524    -0.220     0.200
     0.528     0.044     0.200
     0.561     0.090     0.200
     0.642     0.561     0.200
     0.653     0.662     0.200
     0.691     0.295     0.200
     0.703     0.338     0.200
     0.726     0.715     0.200
     0.886     1.118     0.200
     0.927     0.723     0.200
     1.052     0.802     0.200
     1.105     0.833     0.200
     1.144     0.794     0.200
     1.192     0.633     0.200
     1.926     0.041     0.200
     0.153     1.630     0.200
     0.156     2.398     0.200
     0.177     1.684     0.200
     0.204     1.092     0.200
     0.327     0.943     0.200
     0.422     0.464     0.200
     0.452     0.731     0.200
     0.449     0.969     0.200
     0.469     0.273     0.200
     0.475     0.606     0.200
     0.546     0.494     0.200
     0.601     0.742     0.200
     0.606     0.197     0.200
     0.613     1.387     0.200
     0.662     1.023     0.200
     0.688     0.433     0.200
     0.688     0.907     0.200
     0.731     0.546     0.200
     0.792     0.818     0.200
     0.874    -0.828     0.200
     0.864    -0.052     0.200
     0.874     0.567     0.200
     0.943     0.359     0.200
     0.071     0.850     0.200
     0.144    -0.219     0.200
     0.141     1.073     0.200
     0.449     1.486     0.200
     0.481     0.227     0.200
     0.466     0.956     0.200
     0.451     0.910     0.200
     0.691     0.709     0.200
     0.735    -0.117     0.200
     1.235     0.140     0.200
     1.412     0.062     0.200
     1.811    -0.320     0.200
     1.980    -0.168     0.200
     2.075    -1.086     0.200
     0.017     4.017     0.200
     0.161     0.811     0.200
     0.223     0.832     0.200
     0.221     1.078     0.200
     0.322     1.067     0.200
     0.386     0.125     0.200
     0.445     0.093     0.200
     0.450     0.733     0.200
     0.449     0.616     0.200
     0.469     0.458     0.200
     0.585     0.640     0.200
     0.601     0.108     0.200
     0.639     0.534     0.200
     0.662    -0.252     0.200
     0.678    -0.070     0.200
     0.666     0.844     0.200
     0.719     0.800     0.200
     0.741     0.574     0.200
     0.734     0.679     0.200
     0.745     0.970     0.200
     0.743     0.291     0.200
     0.763     1.089     0.200
     0.818     0.311     0.200
     0.936     1.054     0.200
     1.046     0.455     0.200
     0.116     1.458     0.200
     0.172     1.941     0.200
     0.256     0.750     0.200
     0.275     0.268     0.200
     0.316     0.148     0.200
     0.365     0.578     0.200
     0.433     0.842     0.200
     0.467     0.732     0.200
     0.443     0.663     0.200
     0.479    -0.524     0.200
     0.516     0.227     0.200
     0.624     0.200     0.200
     0.630     0.457     0.200
     0.660    -0.515     0.200
     0.662     0.925     0.200
     0.685     0.276     0.200
     0.703     0.422     0.200
     0.702     0.134     0.200
     0.682     1.389     0.200
     0.790     0.719     0.200
     0.858     0.335     0.200
     0.879     0.427     0.200
     0.867     1.355     0.200
     0.913     1.425     0.200
     0.981    -0.094     0.200
     1.005     0.664     0.200
     1.024     0.489     0.200
     1.364    -0.952     0.200
     1.608    -0.173     0.200
     1.627    -0.683     0.200
     1.689    -0.806     0.200
     0.621     0.053     0.200
     1.598    -1.519     0.200
     2.392    -5.695     0.200
     2.454    -5.580     0.200
     2.474    -4.667     0.200
     2.714    -5.967     0.200
     0.169     0.499     0.200
     0.223     0.009     0.200
     0.308    -0.272     0.200
     0.469     0.237     0.200
     0.463     0.213     0.200
     0.589    -0.138     0.200
     0.607     0.211     0.200
     0.609     0.554     0.200
     0.643     0.982     0.200
     0.676     0.396     0.200
     0.717    -0.324     0.200
     0.778     0.543     0.200
     0.160    -0.178     0.200
     0.209    -0.465     0.200
     0.228     0.536     0.200
     0.322    -0.171     0.200
     0.311     1.403     0.200
     0.345     0.458     0.200
     0.333     0.873     0.200
     0.374     0.202     0.200
     0.448     0.824     0.200
     0.483    -0.594     0.200
     0.576     0.308     0.200
     0.586     1.095     0.200
     0.635     0.036     0.200
     0.695     0.654     0.200
     0.704     0.695     0.200
     0.874    -0.071     0.200
     0.886     1.616     0.200
     0.927     0.310     0.200
     0.174     0.327     0.200
     0.190     1.014     0.200
     0.264     0.151     0.200
     0.357     0.311     0.200
     0.362     0.288     0.200
     0.425    -0.303     0.200
     0.447     0.638     0.200
     0.485     1.023     0.200
     0.602     0.272     0.200
     0.645     1.089     0.200
     0.773     0.305     0.200
     0.779     0.281     0.200
     0.780     0.715     0.200
     0.786     0.665     0.200
     0.792     0.161     0.200
     0.786     0.868     0.200
     0.827     0.583     0.200
     0.929     0.963     0.200
     1.024     0.820     0.200
     1.191    -0.489     0.200
     0.226     0.587     0.200
     0.278    -0.103     0.200
     0.387     0.125     0.200
     0.392     1.268     0.200
     0.407     0.789     0.200
     0.499    -0.231     0.200
     0.571     0.441     0.200
     0.604     0.390     0.200
     0.658     0.328     0.200
     0.665     0.781     0.200
     0.745     1.126     0.200
     0.773     0.515     0.200
     0.775    -0.406     0.200
     0.790     0.986     0.200
     0.796     0.427     0.200
     0.801     0.909     0.200
     0.807     0.682     0.200
     0.820     0.535     0.200
     1.044     0.726     0.200
     1.111     0.437     0.200
     1.202    -0.042     0.200
     0.054     2.360     0.200
     0.123     1.458     0.200
     0.217     1.445     0.200
     0.226     0.297     0.200
     0.244     1.156     0.200
     0.244     1.433     0.200
     0.313     1.413     0.200
     0.362     0.946     0.200
     0.386     1.601     0.200
     0.395     0.932     0.200
     0.466    -0.212     0.200
     0.626     0.911     0.200
     0.657     0.484     0.200
     0.676     0.622     0.200
     0.681     0.867     0.200
     0.749     0.944     0.200
     0.794     1.065     0.200
     0.796     0.769     0.200
     0.117     2.734     0.200
     0.144     2.268     0.200
     0.156     2.055     0.200
     0.164     1.963     0.200
     0.268     2.071     0.200
     0.342     1.446     0.200
     0.385     0.956     0.200
     0.450     0.693     0.200
     0.500     0.564     0.200
     0.550     0.487     0.200
     0.565     0.736     0.200
     0.591     1.098     0.200
     0.635     0.835     0.200
     0.650     0.565     0.200
     0.654     0.540     0.200
     0.659     0.524     0.200
     0.656     1.393     0.200
     0.704     0.420     0.200
     0.717     1.119     0.200
     0.727     0.517     0.200
     0.724     0.963     0.200
     0.735     0.815     0.200
     0.776     1.485     0.200
     0.798     0.643     0.200
     0.825     0.507     0.200
     0.875     0.581     0.200
     0.960     0.604     0.200
     1.224    -1.194     0.200
     1.784    -1.254     0.200
     1.949    -2.522     0.200
     0.252     1.120     0.200
     0.348     0.292     0.200
     0.449     0.017     0.200
     0.424     1.261     0.200
     0.468    -0.129     0.200
     0.480     0.025     0.200
     0.679     0.225     0.200
     0.679     0.209     0.200
     0.759     0.350     0.200
     0.812     0.095     0.200
     0.910     0.319     0.200
     0.953    -0.311     0.200
     1.032    -0.144     0.200
     1.126     0.313     0.200
     1.187     0.837     0.200
     1.246     0.007     0.200
     1.260     0.305     0.200
     1.298    -0.317     0.200
     1.298     0.258     0.200
     1.765    -0.042     0.200
     1.799    -0.461     0.200
     1.969    -0.576     0.200
     2.025    -1.595     0.200
     2.136    -1.038     0.200
     2.151    -1.444     0.200
     2.264    -1.611     0.200
     2.274    -1.774     0.200
     2.385    -2.584     0.200
     2.390    -2.288     0.200
     2.441    -2.803     0.200
     0.233     0.228     0.200
     0.252     1.268     0.200
     0.348    -0.052     0.200
     0.468     0.032     0.200
     0.480     0.126     0.200
     0.679     0.346     0.200
     0.679     0.381     0.200
     0.678    -0.445     0.200
     1.246     0.289     0.200
     1.298    -0.344     0.200
     1.298    -0.469     0.200
     1.969    -0.435     0.200
     2.025    -1.716     0.200
     2.151    -1.283     0.200
     2.274    -1.575     0.200
     2.385    -2.143     0.200
     2.390    -2.128     0.200
     2.441    -2.362     0.200
     0.453    -1.043     0.200
     1.415    -1.029     0.200
     0.148     0.783     0.200
     0.249     0.280     0.200
     0.234     0.673     0.200
     0.313    -0.112     0.200
     0.320     0.278     0.200
     0.396    -0.333     0.200
     0.467     0.014     0.200
     0.484     0.051     0.200
     0.494     0.119     0.200
     0.511    -0.268     0.200
     0.520     0.503     0.200
     0.598    -0.180     0.200
     0.636     0.487     0.200
     0.645    -0.256     0.200
     0.649    -0.044     0.200
     0.684     1.486     0.200
     0.694     0.715     0.200
     0.741    -0.068     0.200
     0.745     0.140     0.200
     0.764     0.375     0.200
     0.756     0.593     0.200
     0.779    -0.036     0.200
     0.811     0.252     0.200
     0.868     0.596     0.200
     0.910     0.215     0.200
     0.977     0.718     0.200
     0.996     1.301     0.200
     1.029     0.903     0.200
     1.038     1.192     0.200
     1.172    -0.222     0.200
     1.149     1.044     0.200
     1.161     0.732     0.200
     1.270     0.357     0.200
     0.248     0.923     0.200
     0.252     0.753     0.200
     0.297     0.547     0.200
     0.339     0.558     0.200
     0.373     0.643     0.200
     0.370     0.602     0.200
     0.495    -0.164     0.200
     0.501     0.277     0.200
     0.540     0.124     0.200
     0.548     0.295     0.200
     0.572     0.171     0.200
     0.574     0.312     0.200
     0.570     0.669     0.200
     0.663     0.516     0.200
     0.657     0.535     0.200
     0.673     0.500     0.200
     0.746     0.945     0.200
     0.780     0.361     0.200
     0.823    -0.198     0.200
     0.868     0.953     0.200
     0.870     0.893     0.200
     0.905     0.372     0.200
     1.016     0.886     0.200
     1.026     0.791     0.200
     1.082     0.615     0.200
     1.123     0.720     0.200
     1.166     0.575     0.200
     1.188     0.757     0.200
     1.666     0.589     0.200
     1.676     0.022     0.200
     1.897    -0.649     0.200
     2.010    -0.248     0.200
     0.565    -1.001     0.200
     0.667     0.605     0.200
     0.055     2.606     0.200
     0.217     1.412     0.200
     0.256     0.444     0.200
     0.220     1.479     0.200
     0.297     0.497     0.200
     0.404     0.798     0.200
     0.440     0.482     0.200
     0.436     0.502     0.200
     0.558     0.360     0.200
     0.641     0.605     0.200
     0.683     0.206     0.200
     0.909     0.438     0.200
     1.105     0.354     0.200
     1.727    -0.428     0.200
     2.102    -1.837     0.200
     2.178    -2.056     0.200
     2.296    -2.317     0.200
     0.287     0.911     0.200
     0.300     0.077     0.200
     0.306     0.300     0.200
     0.359     0.202     0.200
     0.359     0.209     0.200
     0.435     0.799     0.200
     0.464     0.190     0.200
     0.512    -0.101     0.200
     0.523     0.344     0.200
     0.529     0.424     0.200
     0.723     0.786     0.200
     0.797     0.818     0.200
     0.836     0.472     0.200
     1.081     0.908     0.200
     0.148     1.309     0.200
     0.239     1.401     0.200
     0.394     0.841     0.200
     0.422     0.500     0.200
     0.504     0.367     0.200
     0.544     0.968     0.200
     0.562     0.785     0.200
     0.605     0.419     0.200
     0.629     0.429     0.200
     0.737     0.232     0.200
     0.793     0.573     0.200
     0.975     0.617     0.200
     1.250     0.420     0.200
     0.113     1.621     0.200
     0.137     1.174     0.200
     0.177     0.814     0.200
     0.242     0.738     0.200
     0.328     0.374     0.200
     0.374    -0.081     0.200
     0.480    -0.154     0.200
     0.479     0.458     0.200
     0.492     0.563     0.200
     0.579     0.515     0.200
     0.614     0.463     0.200
     0.610     0.494     0.200
     0.662     1.052     0.200
     0.668     0.830     0.200
     0.693     0.895     0.200
     0.703     1.045     0.200
     0.721     0.752     0.200
     0.727    -0.027     0.200
     0.738     0.504     0.200
     0.748     0.595     0.200
     0.749     0.529     0.200
     0.781     0.582     0.200
     0.821     0.540     0.200
     0.846     0.538     0.200
     0.965     0.299     0.200
     1.021     0.718     0.200
     1.025     0.890     0.200
     1.103     0.785     0.200
     1.140     0.884     0.200
     1.164     0.588     0.200
     0.688     0.980     0.200
     0.608    -0.130     0.200
     0.163     0.434     0.200
     0.206     0.857     0.200
     0.236     0.219     0.200
     0.316     0.465     0.200
     0.332     0.499     0.200
     0.384     0.318     0.200
     0.393    -0.383     0.200
     0.404     0.405     0.200
     0.435    -0.408     0.200
     0.439     0.899     0.200
     0.447     0.091     0.200
     0.567     0.882     0.200
     0.574     0.445     0.200
     0.590     0.500     0.200
     0.652    -0.054     0.200
     0.653     0.225     0.200
     0.665     0.354     0.200
     0.725     0.744     0.200
     0.722     0.361     0.200
     0.729     0.972     0.200
     0.771     0.474     0.200
     0.813     1.421     0.200
     0.813     0.166     0.200
     0.908     0.952     0.200
     0.950     0.259     0.200
     0.952     1.314     0.200
     0.987     0.993     0.200
     1.148     0.251     0.200
     1.720     1.624     0.200
     1.769     0.718     0.200
     1.800     0.216     0.200
     1.924     0.993     0.200
     0.582    -0.647     0.200
     0.677    -0.481     0.200
     2.532    -3.638     0.200
     2.852    -5.725     0.200
     0.211    -0.078     0.200
     0.244     0.029     0.200
     0.293     0.910     0.200
     0.326     0.091     0.200
     0.363     0.846     0.200
     0.391     0.008     0.200
     0.433     0.716     0.200
     0.588     0.063     0.200
     0.602     0.039     0.200
     0.661     0.180     0.200
     0.702     0.777     0.200
     0.718     0.327     0.200
     0.887     0.530     0.200
     0.879     1.550     0.200
     0.888     0.706     0.200
     0.946     0.948     0.200
     1.016     0.954     0.200
     1.179     1.094     0.200
     0.341     0.731     0.200
     0.371     0.786     0.200
     0.361     0.988     0.200
     0.415     0.612     0.200
     0.407     0.994     0.200
     0.463     0.548     0.200
     0.484     0.885     0.200
     0.501     0.254     0.200
     0.512     0.679     0.200
     0.529     1.032     0.200
     0.582     0.478     0.200
     0.648     0.311     0.200
     0.679     1.373     0.200
     0.667     0.792     0.200
     0.678     0.734     0.200
     0.711     0.244     0.200
     0.758     0.653     0.200
     0.763     0.092     0.200
     0.830     0.797     0.200
     0.845     0.132     0.200
     0.843     0.676     0.200
     0.905     1.067     0.200
     0.942     0.889     0.200
     0.961     1.379     0.200
     1.065     0.909     0.200
     1.084     0.208     0.200
     1.692     0.196     0.200
     1.779    -0.610     0.200
     1.796    -0.260     0.200
     1.903    -0.567     0.200
     0.146     2.829     0.200
     0.159     2.672     0.200
     0.180     2.030     0.200
     0.192     2.506     0.200
     0.325     1.159     0.200
     0.330     1.030     0.200
     0.406     0.884     0.200
     0.501     0.643     0.200
     0.580     0.906     0.200
     0.589     0.598     0.200
     0.601     0.996     0.200
     0.620     1.663     0.200
     0.636     0.368     0.200
     0.721     0.446     0.200
     0.730     0.334     0.200
     0.733     0.190     0.200
     0.702     1.453     0.200
     0.738     1.074     0.200
     0.758     0.555     0.200
     0.772     0.662     0.200
     0.782     0.681     0.200
     0.875     0.840     0.200
     0.914     0.522     0.200
     0.959     0.358     0.200
     0.992     0.012     0.200
     0.986     0.160     0.200
     0.184     0.930     0.200
     0.244     0.480     0.200
     0.256     1.118     0.200
     0.302     0.268     0.200
     0.291     1.292     0.200
     0.372     0.298     0.200
     0.394     0.666     0.200
     0.406     0.523     0.200
     0.424     0.248     0.200
     0.485    -0.439     0.200
     0.493    -0.639     0.200
     0.519    -0.331     0.200
     0.642     0.194     0.200
     0.635    -0.090     0.200
     0.687     0.101     0.200
     0.721     0.763     0.200
     0.829     0.274     0.200
     0.860     0.597     0.200
     0.850     1.076     0.200
     0.962     0.373     0.200
     1.031     0.494     0.200
     1.147     0.455     0.200
     0.099     2.878     0.200
     0.156     2.167     0.200
     0.185     1.699     0.200
     0.206     1.665     0.200
     0.312     0.641     0.200
     0.355     1.242     0.200
     0.357     0.696     0.200
     0.529     0.894     0.200
     0.549     0.246     0.200
     0.615     0.559     0.200
     0.622     0.873     0.200
     0.670     0.484     0.200
     0.679     1.281     0.200
     0.690     0.592     0.200
     0.741     0.314     0.200
     0.805     0.835     0.200
     0.811     1.172     0.200
     0.824     0.518     0.200
     0.845     1.159     0.200
     0.882     0.559     0.200
     0.888     1.076     0.200
     0.940     0.594     0.200
     0.176     0.876     0.200
     0.242     0.821     0.200
     0.251     1.458     0.200
     0.296     0.965     0.200
     0.286     1.343     0.200
     0.382     0.639     0.200
     0.391     1.002     0.200
     0.402     0.738     0.200
     0.438     0.179     0.200
     0.484     0.911     0.200
     0.480     0.870     0.200
     0.633     0.732     0.200
     0.633     0.733     0.200
     0.644     1.135     0.200
     0.650     0.697     0.200
     0.676     0.400     0.200
     0.674     0.286     0.200
     0.734     0.641     0.200
     0.789    -0.017     0.200
     0.797     0.971     0.200
     0.816     0.711     0.200
     0.834     0.776     0.200
     0.851     0.735     0.200
     0.923     0.760     0.200
     0.967     1.010     0.200
     0.974     0.748     0.200
     1.035     0.989     0.200
     1.043     1.079     0.200
     1.610     0.547     0.200
     0.079     0.735     0.200
     0.182     1.200     0.200
     0.265     0.283     0.200
     0.304     0.284     0.200
     0.337     0.644     0.200
     0.399     0.768     0.200
     0.497     0.416     0.200
     0.528     0.314     0.200
     0.582     0.957     0.200
     0.683     0.654     0.200
     0.742     0.432     0.200
     0.749     0.932     0.200
     0.795     0.575     0.200
     1.007     1.226     0.200
     1.237     1.066     0.200
     1.255     0.722     0.200
     1.289     1.037     0.200
     1.839     0.489     0.200
     1.911    -0.300     0.200
     1.924     0.227     0.200
     1.962    -0.307     0.200
     1.985    -0.078     0.200
     2.008     0.495     0.200
     2.101    -0.621     0.200
     2.178    -0.052     0.200
     2.302    -0.814     0.200
     2.395    -1.108     0.200
     0.081     6.333     0.200
     0.140     3.872     0.200
     0.212     3.364     0.200
     0.290     2.503     0.200
     0.334     2.022     0.200
     0.344     1.637     0.200
     0.310     2.103     0.200
     0.311     2.517     0.200
     0.399     1.225     0.200
     0.438     1.260     0.200
     0.476     1.277     0.200
     0.558     1.100     0.200
     0.616     1.142     0.200
     0.639     0.329     0.200
     0.754     0.320     0.200
     0.860     0.148     0.200
     0.894    -0.096     0.200
     0.964    -0.510     0.200
     0.972    -0.421     0.200
     1.018    -0.744     0.200
     1.334    -1.147     0.200
     1.367    -0.560     0.200
     1.408    -0.263     0.200
     1.540    -1.456     0.200
     1.632    -1.570     0.200
     1.675    -2.253     0.200
     1.830    -2.531     0.200
     2.018    -3.108     0.200
     2.059    -3.685     0.200
     2.063    -3.723     0.200
     2.067    -3.118     0.200
     2.263    -4.178     0.200
     2.286    -4.327     0.200
     1.680    -0.109     0.200
     0.062     1.341     0.200
     0.116     0.997     0.200
     0.178     0.138     0.200
     0.197     0.422     0.200
     0.185     1.034     0.200
     0.233     1.054     0.200
     0.322     1.220     0.200
     0.353     1.069     0.200
     0.369    -0.094     0.200
     0.381     1.067     0.200
     0.433     0.418     0.200
     0.436     1.135     0.200
     0.481     0.363     0.200
     0.505     0.053     0.200
     0.513     1.353     0.200
     0.533     1.223     0.200
     0.608     0.225     0.200
     0.631    -0.054     0.200
     0.677     0.245     0.200
     0.701     0.088     0.200
     0.701     0.144     0.200
     0.681     1.236     0.200
     0.761     0.260     0.200
     0.849     0.403     0.200
     0.874     0.235     0.200
     0.886     0.320     0.200
     0.939     0.469     0.200
     0.969     0.881     0.200
     1.082     0.439     0.200
     1.180     0.555     0.200
     1.705    -0.269     0.200
     1.794    -0.457     0.200
     1.810    -0.434     0.200
     1.847    -0.583     0.200
     2.216    -1.703     0.200
     0.076     2.272     0.200
     0.187     0.410     0.200
     0.225     0.065     0.200
     0.245     1.658     0.200
     0.373     0.081     0.200
     0.363     1.361     0.200
     0.444     0.277     0.200
     0.522     0.152     0.200
     0.528     0.578     0.200
     0.564     0.315     0.200
     0.605    -0.238     0.200
     0.662     0.289     0.200
     0.707    -0.012     0.200
     0.933     0.192     0.200
     0.958     0.393     0.200
     0.994     0.195     0.200
     1.031     0.515     0.200
     1.248     0.318     0.200
     2.039    -1.537     0.200
     2.053    -1.284     0.200
     2.063    -1.650     0.200
     2.117    -1.696     0.200
     2.179    -1.579     0.200
     2.321    -2.310     0.200
     0.628     0.941     0.200
     0.120     1.523     0.200
     0.159     1.393     0.200
     0.215     0.685     0.200
     0.241     0.509     0.200
     0.330     1.100     0.200
     0.360     0.720     0.200
     0.388     0.982     0.200
     0.448     0.375     0.200
     0.547     0.843     0.200
     0.606     1.039     0.200
     0.709     0.712     0.200
     0.722     0.394     0.200
     0.746     0.751     0.200
     0.936     0.553     0.200
     0.990     0.610     0.200
     0.984     0.718     0.200
     1.007     1.109     0.200
     1.045     0.686     0.200
     1.080     0.660     0.200
     1.190     0.522     0.200
     1.630    -0.230     0.200
     1.677    -0.332     0.200
     1.787    -0.454     0.200
     1.839    -0.461     0.200
     1.869    -0.758     0.200
     1.904    -0.587     0.200
     1.930    -0.991     0.200
     1.955    -0.271     0.200
     2.042    -1.180     0.200
     2.104    -0.875     0.200
     2.120    -1.374     0.200
     2.243    -1.922     0.200
     2.340    -2.019     0.200
     2.453    -3.006     0.200
     0.111     1.678     0.200
     0.173     1.954     0.200
     0.226     0.935     0.200
     0.242     0.854     0.200
     0.371     0.754     0.200
     0.402     1.201     0.200
     0.559     0.928     0.200
     0.618     1.102     0.200
     0.641     1.044     0.200
     0.652     0.296     0.200
     0.721     0.696     0.200
     0.987     1.291     0.200
     1.877    -0.746     0.200
     1.964    -0.856     0.200
     2.348    -2.436     0.200
     2.461    -2.909     0.200
     0.349     0.984     0.200
     0.395    -0.032     0.200
     0.458     0.146     0.200
     0.484     0.592     0.200
     0.487     0.012     0.200
     0.598     0.457     0.200
     0.617    -0.279     0.200
     0.648     0.602     0.200
     0.676     0.630     0.200
     0.680     0.174     0.200
     0.693     0.861     0.200
     0.724     0.478     0.200
     0.743     0.673     0.200
     0.750     0.946     0.200
     0.778     0.159     0.200
     0.798     1.603     0.200
     0.830     0.295     0.200
     0.883     0.610     0.200
     0.943     0.560     0.200
     1.051     0.580     0.200
     0.086     3.181     0.200
     0.095     2.507     0.200
     0.093     2.467     0.200
     0.179     1.927     0.200
     0.254     1.430     0.200
     0.269     0.944     0.200
     0.265     1.522     0.200
     0.345     1.216     0.200
     0.410     1.293     0.200
     0.446     0.745     0.200
     0.481     0.853     0.200
     0.094     2.433     0.200
     0.086     2.913     0.200
     0.096     2.227     0.200
     0.177     1.682     0.200
     0.256     1.064     0.200
     0.267     0.987     0.200
     0.267     1.278     0.200
     0.407     1.224     0.200
     0.444     0.826     0.200
     0.479     0.879     0.200
     0.817     1.730     0.200
     0.979     0.439     0.200
     0.223     1.223     0.200
     0.310     0.993     0.200
     0.337     1.292     0.200
     0.343     1.160     0.200
     0.350     1.016     0.200
     0.426    -0.299     0.200
     0.414     1.040     0.200
     0.474     1.656     0.200
     0.522     0.336     0.200
     0.552     0.261     0.200
     0.644     0.196     0.200
     0.692     0.481     0.200
     0.752    -0.063     0.200
     0.778     0.250     0.200
     0.782     0.434     0.200
     0.855     1.663     0.200
     0.874     0.262     0.200
     1.120    -0.143     0.200
     1.155    -0.114     0.200
     1.826    -0.421     0.200
     0.107     1.134     0.200
     0.246     0.664     0.200
     0.264     0.863     0.200
     0.278     1.114     0.200
     0.290     1.019     0.200
     0.326     1.187     0.200
     0.354     0.632     0.200
     0.367     0.778     0.200
     0.399     0.769     0.200
     0.491    -0.252     0.200
     0.529     0.383     0.200
     0.560     0.483     0.200
     0.658     0.833     0.200
     0.668    -0.054     0.200
     0.852     0.547     0.200
     0.097     0.995     0.200
     0.134     0.346     0.200
     0.121     0.833     0.200
     0.210     1.930     0.200
     0.306     0.665     0.200
     0.412     0.419     0.200
     0.401     0.808     0.200
     0.447     0.781     0.200
     0.425     1.653     0.200
     0.469    -0.216     0.200
     0.709     0.356     0.200
     0.742     0.018     0.200
     1.031     0.391     0.200
     0.130     0.196     0.200
     0.101     0.775     0.200
     0.123     0.631     0.200
     0.233     0.266     0.200
     0.214     1.591     0.200
     0.303     0.303     0.200
     0.363     0.235     0.200
     0.386     0.390     0.200
     0.465     0.138     0.200
     0.587    -0.122     0.200
     0.731    -0.271     0.200
     0.109    -0.089     0.200
     0.098     0.705     0.200
     0.186     0.764     0.200
     0.266     0.607     0.200
     0.319     0.362     0.200
     0.284     1.469     0.200
     0.323     0.355     0.200
     0.352     0.234     0.200
     0.441    -0.350     0.200
     0.430     0.537     0.200
     0.456     0.521     0.200
     0.478     0.250     0.200
     0.515    -0.938     0.200
     0.490     1.701     0.200
     0.504     0.861     0.200
     0.586     1.000     0.200
     0.666    -0.761     0.200
     0.702     0.298     0.200
     0.737    -0.201     0.200
     0.937     0.255     0.200
     0.974    -0.252     0.200
     1.007    -0.499     0.200
     1.012    -0.315     0.200
     1.036     0.411     0.200
     1.079    -0.029     0.200
     1.193    -0.092     0.200
     1.217     0.873     0.200
     1.408     0.451     0.200
     1.758     0.416     0.200
     1.768    -0.222     0.200
     1.824     0.318     0.200
     1.884     0.042     0.200
     1.930    -0.085     0.200
     2.022    -0.351     0.200
     2.032    -1.157     0.200
     2.081    -0.883     0.200
     2.091    -0.500     0.200
     0.106     0.312     0.200
     0.102     0.616     0.200
     0.190     0.822     0.200
     0.314     0.337     0.200
     0.289     1.361     0.200
     0.322     0.484     0.200
     0.349    -0.127     0.200
     0.436     0.017     0.200
     0.429     0.716     0.200
     0.479     0.522     0.200
     0.509    -0.492     0.200
     0.495     1.519     0.200
     0.510     0.803     0.200
     0.660    -0.198     0.200
     2.017    -0.487     0.200
     0.104     1.726     0.200
     0.235     0.974     0.200
     0.251     0.748     0.200
     0.285     0.903     0.200
     0.263     0.983     0.200
     0.318     0.850     0.200
     0.368     0.187     0.200
     0.351     1.366     0.200
     0.369     0.619     0.200
     0.388     0.358     0.200
     0.438     0.951     0.200
     0.510    -0.544     0.200
     0.518    -0.437     0.200
     0.485     0.817     0.200
     0.563    -0.200     0.200
     0.578    -0.434     0.200
     0.580    -0.055     0.200
     0.588     0.933     0.200
     0.642     1.254     0.200
     0.792     0.129     0.200
     0.807     0.433     0.200
     0.848     0.810     0.200
     0.872    -0.090     0.200
     0.887    -0.329     0.200
     1.195     0.167     0.200
     1.760    -0.075     0.200
     0.187     0.814     0.200
     0.303     0.805     0.200
     0.345     0.773     0.200
     0.369     0.647     0.200
     0.403     0.792     0.200
     0.428     1.018     0.200
     0.479     0.454     0.200
     0.514     0.946     0.200
     0.574     0.190     0.200
     0.594    -0.001     0.200
     0.634     0.535     0.200
     0.698     0.268     0.200
     0.721     0.817     0.200
     0.739     0.287     0.200
     0.813     0.669     0.200
     0.821     0.471     0.200
     0.843     0.672     0.200
     0.881     1.056     0.200
     0.904     0.331     0.200
     0.969     1.272     0.200
     1.008     0.450     0.200
     1.124     0.790     0.200
     1.195     0.656     0.200
     1.758     0.848     0.200
     0.105     2.115     0.200
     0.113     1.693     0.200
     0.254     1.081     0.200
     0.335     1.448     0.200
     0.338     0.454     0.200
     0.359    -0.016     0.200
     0.378     0.713     0.200
     0.477    -0.202     0.200
     0.482     0.213     0.200
     0.528     0.106     0.200
     0.574     0.270     0.200
     0.591     0.434     0.200
     0.612     0.484     0.200
     0.630    -0.031     0.200
     0.710     0.104     0.200
     0.749     0.265     0.200
     0.835     0.753     0.200
     0.923     0.633     0.200
     1.066     0.493     0.200
     0.011     4.474     0.200
     0.093     2.127     0.200
     0.159     1.623     0.200
     0.172     1.328     0.200
     0.220     0.767     0.200
     0.326     1.009     0.200
     0.343     0.726     0.200
     0.457     0.366     0.200
     0.458     0.020     0.200
     0.464     0.677     0.200
     0.489     0.843     0.200
     0.489     0.608     0.200
     0.604     0.118     0.200
     0.600     0.064     0.200
     0.620    -0.167     0.200
     0.654     1.694     0.200
     0.677    -0.140     0.200
     0.672     0.198     0.200
     0.685    -0.165     0.200
     0.748     0.345     0.200
     0.758     0.647     0.200
     0.756     0.761     0.200
     0.783    -0.268     0.200
     0.804     0.994     0.200
     0.837     0.077     0.200
     1.048     0.222     0.200
     0.165     0.779     0.200
     0.220     0.470     0.200
     0.275     0.715     0.200
     0.270     1.025     0.200
     0.283     0.209     0.200
     0.379    -0.100     0.200
     0.441    -0.013     0.200
     0.538     0.675     0.200
     0.570     0.531     0.200
     0.621    -0.138     0.200
     0.694     0.112     0.200
     0.697    -0.433     0.200
     0.715    -0.072     0.200
     0.812     0.648     0.200
     0.830     0.124     0.200
     0.842     0.866     0.200
     0.861     0.066     0.200
     0.854     0.288     0.200
     0.865    -0.123     0.200
     0.898     0.318     0.200
     0.914     0.396     0.200
     0.960     1.072     0.200
     0.995     0.779     0.200
     1.017     0.683     0.200
     0.687     1.073     0.200
     0.150     2.138     0.200
     0.287     1.659     0.200
     0.297     1.509     0.200
     0.293     1.465     0.200
     0.308     1.740     0.200
     0.344     1.448     0.200
     0.360     1.381     0.200
     0.420     1.465     0.200
     0.532     0.870     0.200
     0.534     0.621     0.200
     0.614     1.364     0.200
     0.660     0.380     0.200
     0.710     0.831     0.200
     0.784     0.892     0.200
     0.830     0.070     0.200
     0.843     0.442     0.200
     0.687     0.337     0.200
     0.150     1.824     0.200
     0.287     1.167     0.200
     0.308     1.505     0.200
     0.298     0.786     0.200
     0.345     1.227     0.200
     0.360     0.921     0.200
     0.447    -0.578     0.200
     0.457     0.098     0.200
     0.451     0.454     0.200
     0.532     0.395     0.200
     0.533     0.194     0.200
     0.527     0.276     0.200
     0.549     0.401     0.200
     0.589     1.328     0.200
     0.615     1.076     0.200
     0.610     0.772     0.200
     0.659     0.300     0.200
     0.710     0.674     0.200
     0.784     0.834     0.200
     0.800     0.192     0.200
     0.830    -0.202     0.200
     0.817     0.541     0.200
     0.820     1.623     0.200
     0.843     0.697     0.200
     0.871     0.278     0.200
     0.966     0.915     0.200
     0.984     0.899     0.200
     1.047    -0.016     0.200
     1.090     0.377     0.200
     1.141     0.492     0.200
     1.850    -0.497     0.200
     1.960    -0.273     0.200
     0.546    -0.034     0.200
     0.609    -0.586     0.200
     0.710     0.403     0.200
     0.097     2.742     0.200
     0.152     2.652     0.200
     0.204     1.698     0.200
     0.215     1.402     0.200
     0.264     1.094     0.200
     0.321     0.929     0.200
     0.348     0.695     0.200
     0.427     1.449     0.200
     0.414     0.559     0.200
     0.481     0.999     0.200
     0.544     0.283     0.200
     0.620     1.578     0.200
     0.637     1.408     0.200
     0.632     0.722     0.200
     0.666     0.582     0.200
     0.667     0.642     0.200
     0.669     0.395     0.200
     0.694     0.690     0.200
     0.768     0.747     0.200
     0.792     0.500     0.200
     0.812     0.783     0.200
     0.818     1.155     0.200
     0.854     0.587     0.200
     0.879     0.934     0.200
     0.939     0.636     0.200
     1.104    -0.326     0.200
     1.856    -0.594     0.200
     0.083     2.608     0.200
     0.166     1.551     0.200
     0.248     0.844     0.200
     0.255     1.344     0.200
     0.249     1.466     0.200
     0.332     0.682     0.200
     0.378     0.420     0.200
     0.418     0.746     0.200
     0.441    -0.410     0.200
     0.420     1.246     0.200
     0.491     1.117     0.200
     0.543     1.371     0.200
     0.592     0.166     0.200
     0.576     1.418     0.200
     0.622     1.607     0.200
     0.674     0.832     0.200
     0.882     0.044     0.200
     0.904    -0.282     0.200
     0.959     0.986     0.200
     0.605     1.777     0.200
     0.137     1.488     0.200
     0.133     1.084     0.200
     0.202     0.359     0.200
     0.245     0.800     0.200
     0.309     1.046     0.200
     0.337     0.707     0.200
     0.365     0.382     0.200
     0.524     0.556     0.200
     0.584     1.229     0.200
     0.625     0.127     0.200
     0.692     0.870     0.200
     0.853     0.329     0.200
     0.088     1.515     0.200
     0.158     0.626     0.200
     0.174     0.667     0.200
     0.182     1.316     0.200
     0.210     1.122     0.200
     0.298     0.863     0.200
     0.361     0.847     0.200
     0.435     0.244     0.200
     0.424     0.235     0.200
     0.453     0.412     0.200
     0.524    -0.091     0.200
     0.551     0.937     0.200
     0.608     0.466     0.200
     0.647    -0.752     0.200
     0.624     0.835     0.200
     0.732     0.896     0.200
     0.949     1.163     0.200
     1.011     0.481     0.200
     1.030     0.303     0.200
     1.659     0.916     0.200
     0.006     4.637     0.200
     0.150     2.331     0.200
     0.179     1.409     0.200
     0.192     1.415     0.200
     0.221     1.484     0.200
     0.266     1.660     0.200
     0.275     1.054     0.200
     0.349     0.890     0.200
     0.457     0.570     0.200
     0.473     0.326     0.200
     0.542     1.065     0.200
     0.607     0.797     0.200
     0.716     0.010     0.200
     1.204    -0.308     0.200
     0.120     1.439     0.200
     0.129     1.005     0.200
     0.179     0.862     0.200
     0.250     0.504     0.200
     0.296     1.018     0.200
     0.323     0.521     0.200
     0.476    -0.094     0.200
     0.484     0.125     0.200
     0.492     1.131     0.200
     0.571     0.169     0.200
     0.610     0.531     0.200
     0.612     0.105     0.200
     0.656     0.682     0.200
     0.673     0.985     0.200
     0.700     0.919     0.200
     0.709     0.810     0.200
     0.713     0.534     0.200
     0.719    -0.115     0.200
     0.743     0.745     0.200
     0.779     1.617     0.200
     0.826     1.043     0.200
     0.101     1.089     0.200
     0.165     0.246     0.200
     0.175     0.312     0.200
     0.206     0.197     0.200
     0.285     0.671     0.200
     0.493     0.100     0.200
     0.491     0.192     0.200
     0.528    -0.057     0.200
     0.623     0.196     0.200
     0.736     0.581     0.200
     0.104     2.745     0.200
     0.144     2.450     0.200
     0.213     1.760     0.200
     0.211     2.347     0.200
     0.294     1.381     0.200
     0.349     2.061     0.200
     0.377     1.181     0.200
     0.394     0.725     0.200
     0.488     0.535     0.200
     0.486     1.496     0.200
     0.500     0.718     0.200
     0.521     0.942     0.200
     0.542     0.572     0.200
     0.568     0.571     0.200
     0.573     0.459     0.200
     0.641     0.360     0.200
     0.637     0.612     0.200
     0.711     1.205     0.200
     0.724     0.615     0.200
     0.755     0.582     0.200
     0.764     0.809     0.200
     0.776     0.377     0.200
     0.840     0.649     0.200
     0.862     0.677     0.200
     0.121     0.857     0.200
     0.151     1.185     0.200
     0.214     0.456     0.200
     0.247     0.593     0.200
     0.324     0.447     0.200
     0.348     0.332     0.200
     0.380     0.692     0.200
     0.447     0.020     0.200
     0.536     0.445     0.200
     0.595     0.831     0.200
     0.637     0.624     0.200
     0.745     0.508     0.200
     0.867     1.069     0.200
     0.936     1.258     0.200
     0.969     0.850     0.200
     0.997     1.465     0.200
     1.188     0.817     0.200
     1.862     0.561     0.200
     1.906     0.145     0.200
     2.122    -0.832     0.200
     2.246    -0.307     0.200
     2.341    -1.332     0.200
     2.455    -2.239     0.200
     0.081     2.041     0.200
     0.206     0.363     0.200
     0.224     0.356     0.200
     0.218     1.031     0.200
     0.275     1.036     0.200
     0.422     0.969     0.200
     0.459     0.885     0.200
     0.492     0.713     0.200
     0.512     0.081     0.200
     0.632     0.176     0.200
     0.671     0.197     0.200
     0.843     1.166     0.200
     0.931     0.197     0.200
     0.082     1.529     0.200
     0.202     1.614     0.200
     0.258     1.031     0.200
     0.264     0.778     0.200
     0.374     0.628     0.200
     0.387     0.905     0.200
     0.429     1.059     0.200
     0.490     0.247     0.200
     0.577     0.629     0.200
     0.634     0.547     0.200
     0.664     1.190     0.200
     0.684     0.572     0.200
     0.752     0.555     0.200
     0.765     0.074     0.200
     0.787     0.890     0.200
     0.915     0.755     0.200
     0.956     0.788     0.200
     1.020     0.704     0.200
     1.088     0.736     0.200
     1.114     0.710     0.200
     1.232     0.010     0.200
     1.346    -0.055     0.200
     1.907    -0.796     0.200
     1.939    -0.214     0.200
     1.994    -0.465     0.200
     0.079     2.663     0.200
     0.209     1.710     0.200
     0.263     1.292     0.200
     0.265     1.081     0.200
     0.395     0.625     0.200
     0.437     1.343     0.200
     0.584     1.032     0.200
     0.641     1.387     0.200
     0.672     1.144     0.200
     0.758     0.799     0.200
     0.979    -0.515     0.200
     1.094     0.647     0.200
     1.998    -1.311     0.200
     2.381    -3.370     0.200
     0.150     1.591     0.200
     0.153     1.352     0.200
     0.153     1.984     0.200
     0.203     0.890     0.200
     0.294     0.767     0.200
     0.376     0.632     0.200
     0.376     1.079     0.200
     0.394     0.588     0.200
     0.575     0.303     0.200
     0.571     0.822     0.200
     0.634     1.526     0.200
     0.646     0.308     0.200
     0.636     1.049     0.200
     0.671     0.996     0.200
     0.688     0.515     0.200
     0.855     0.041     0.200
     0.897     1.322     0.200
     0.914     0.219     0.200
     0.956     0.562     0.200
     0.997     0.922     0.200
     1.817    -0.562     0.200
     2.023    -1.315     0.200
     2.256    -2.546     0.200
     0.399     0.146     0.200
     1.813     0.528     0.200
     0.012     4.075     0.200
     0.114     1.782     0.200
     0.158     1.306     0.200
     0.233     0.969     0.200
     0.310     1.172     0.200
     0.347     0.760     0.200
     0.375     0.146     0.200
     0.460     0.225     0.200
     0.468     0.603     0.200
     0.461     0.066     0.200
     0.473     0.753     0.200
     0.591     0.328     0.200
     0.600     0.618     0.200
     0.655     0.896     0.200
     0.679     0.531     0.200
     0.685     1.123     0.200
     0.723     0.627     0.200
     0.731     0.419     0.200
     0.737     0.945     0.200
     0.731     0.940     0.200
     0.764     0.892     0.200
     0.802     1.393     0.200
     0.824     0.293     0.200
     0.826     0.501     0.200
     0.895     0.637     0.200
     0.974     0.225     0.200
     1.015     0.845     0.200
     1.141    -0.189     0.200
     0.133     0.992     0.200
     0.116     1.356     0.200
     0.184    -0.132     0.200
     0.237     1.183     0.200
     0.269     0.462     0.200
     0.279     0.724     0.200
     0.285     1.364     0.200
     0.315     1.192     0.200
     0.410     0.711     0.200
     0.432     0.827     0.200
     0.484     0.210     0.200
     0.494    -0.116     0.200
     0.515    -0.295     0.200
     0.565    -0.113     0.200
     0.574    -0.110     0.200
     0.569     0.650     0.200
     0.752     1.301     0.200
     1.065    -0.033     0.200
     1.651    -0.232     0.200
     1.676     0.406     0.200
     0.034     3.667     0.200
     0.122     1.560     0.200
     0.194     1.277     0.200
     0.258     0.631     0.200
     0.291     1.474     0.200
     0.308     0.390     0.200
     0.365     0.736     0.200
     0.567     0.268     0.200
     0.621     0.294     0.200
     0.627     0.499     0.200
     0.661     0.511     0.200
     0.688     1.048     0.200
     0.709    -0.088     0.200
     0.710    -0.035     0.200
     0.715     0.247     0.200
     0.713     0.491     0.200
     0.723     1.231     0.200
     0.841     1.018     0.200
     0.865     0.454     0.200
     0.986     0.212     0.200
     1.004     0.278     0.200
     0.030     3.992     0.200
     0.113     2.075     0.200
     0.195     1.446     0.200
     0.250     1.236     0.200
     0.300     1.333     0.200
     0.311     0.531     0.200
     0.374     0.644     0.200
     0.444     0.605     0.200
     0.492     0.340     0.200
     0.496     0.551     0.200
     0.576     0.503     0.200
     0.627     0.462     0.200
     0.628     0.510     0.200
     0.685     0.766     0.200
     0.712     0.740     0.200
     0.706     0.931     0.200
     0.719     0.282     0.200
     0.724     0.377     0.200
     0.719     0.211     0.200
     0.796     0.725     0.200
     0.837     1.293     0.200
     1.019     0.405     0.200
     0.127     1.166     0.200
     0.200     0.949     0.200
     0.262     1.517     0.200
     0.273     2.051     0.200
     0.318     1.002     0.200
     0.388     0.925     0.200
     0.401     0.839     0.200
     0.412     0.348     0.200
     0.432     0.853     0.200
     0.629     0.298     0.200
     0.634     0.615     0.200
     0.645     1.100     0.200
     0.657     0.758     0.200
     0.732     0.950     0.200
     0.837     0.211     0.200
     0.874     1.018     0.200
     0.912     1.161     0.200
     0.919     0.449     0.200
     1.151     0.227     0.200
     1.623    -0.169     0.200
     0.100     0.183     0.200
     0.185     0.451     0.200
     0.263     0.944     0.200
     0.276     1.045     0.200
     0.306     0.782     0.200
     0.369     1.172     0.200
     0.408     0.406     0.200
     0.427     0.591     0.200
     0.454    -0.250     0.200
     0.456     0.000     0.200
     0.462     0.578     0.200
     0.531    -0.128     0.200
     0.598    -0.028     0.200
     0.638    -0.309     0.200
     0.665     0.421     0.200
     0.688     0.059     0.200
     0.674     0.391     0.200
     0.691     0.627     0.200
     0.759     0.603     0.200
     0.782     0.505     0.200
     0.809     0.271     0.200
     0.919     1.161     0.200
     0.935     1.214     0.200
     0.955     0.646     0.200
     0.948     0.886     0.200
     1.020     0.323     0.200
     1.041    -0.039     0.200
     1.075     0.266     0.200
     1.080     0.242     0.200
     1.591     0.942     0.200
     0.164     1.253     0.200
     0.179     2.029     0.200
     0.210     1.464     0.200
     0.285     1.048     0.200
     0.341     0.828     0.200
     0.361     0.720     0.200
     0.388     1.216     0.200
     0.629     0.302     0.200
     0.706     0.318     0.200
     0.732     0.459     0.200
     0.772     0.093     0.200
     0.084     2.407     0.200
     0.194     1.399     0.200
     0.233     1.606     0.200
     0.274     1.152     0.200
     0.309     0.785     0.200
     0.347     0.976     0.200
     0.367     0.181     0.200
     0.362     0.561     0.200
     0.488     0.911     0.200
     0.497     0.706     0.200
     0.503     0.181     0.200
     0.547    -0.017     0.200
     0.556     0.886     0.200
     0.612    -0.119     0.200
     0.745     0.607     0.200
     0.760     0.845     0.200
     0.820     0.757     0.200
     0.850     0.852     0.200
     1.040     0.316     0.200
     0.135     2.409     0.200
     0.212     1.834     0.200
     0.263     0.774     0.200
     0.343     1.348     0.200
     0.362     0.735     0.200
     0.414     0.221     0.200
     0.499     1.253     0.200
     0.636     0.978     0.200
     0.650     0.668     0.200
     0.677     0.159     0.200
     0.689     0.514     0.200
     0.680     0.206     0.200
     0.815     0.418     0.200
     0.882     0.275     0.200
     0.894     0.262     0.200
     0.983     0.578     0.200
     0.161     1.536     0.200
     0.194     1.758     0.200
     0.255     0.471     0.200
     0.338     0.965     0.200
     0.405     0.703     0.200
     0.623     1.170     0.200
     0.634     0.403     0.200
     0.656     0.547     0.200
     0.675     0.508     0.200
     0.688     0.720     0.200
     0.145     2.289     0.200
     0.202     2.240     0.200
     0.233     2.189     0.200
     0.255     1.465     0.200
     0.352     1.036     0.200
     0.406     0.586     0.200
     0.498     1.162     0.200
     0.558     0.507     0.200
     0.636     1.334     0.200
     0.649     0.555     0.200
     0.683     0.983     0.200
     0.708     0.335     0.200
     0.775    -0.349     0.200
     0.807     0.266     0.200
     0.897     0.219     0.200
     0.986     0.111     0.200
     0.135     2.239     0.200
     0.211     1.916     0.200
     0.237     2.092     0.200
     0.262     0.942     0.200
     0.343     1.426     0.200
     0.361     0.622     0.200
     0.413     0.710     0.200
     0.450     0.837     0.200
     0.500     1.213     0.200
     0.637     0.747     0.200
     0.651     0.439     0.200
     0.681     0.840     0.200
     0.717    -0.175     0.200
     0.716     0.679     0.200
     0.881     0.450     0.200
     0.901     0.156     0.200
     0.895     0.468     0.200
     0.161     0.970     0.200
     0.176     0.845     0.200
     0.188     1.549     0.200
     0.281     1.167     0.200
     0.313     0.863     0.200
     0.357     0.191     0.200
     0.413     1.005     0.200
     0.396     1.203     0.200
     0.433     0.596     0.200
     0.532     0.731     0.200
     0.573     0.111     0.200
     0.648    -0.386     0.200
     0.654     0.556     0.200
     0.653     0.389     0.200
     0.726     1.197     0.200
     0.754     0.083     0.200
     0.818     0.012     0.200
     0.937     0.911     0.200
     1.085     0.594     0.200
     1.196     0.084     0.200
     1.243    -0.337     0.200
     1.593     0.307     0.200
     1.743    -0.192     0.200
     1.749    -1.141     0.200
     1.872    -0.109     0.200
     1.972    -1.476     0.200
     2.082    -2.199     0.200
     0.098     0.813     0.200
     0.195     0.319     0.200
     0.229    -0.183     0.200
     0.247     0.083     0.200
     0.295    -0.022     0.200
     0.315     0.681     0.200
     0.362     0.306     0.200
     0.358     0.037     0.200
     0.372     0.255     0.200
     0.511    -0.218     0.200
     0.542    -0.981     0.200
     0.512     0.173     0.200
     0.517    -0.082     0.200
     0.539    -0.461     0.200
     0.601     0.055     0.200
     0.608     0.094     0.200
     0.618     0.028     0.200
     0.632    -0.238     0.200
     0.696    -0.134     0.200
     0.692     0.241     0.200
     0.759    -0.131     0.200
     0.840     0.061     0.200
     0.879     0.575     0.200
     0.879     0.875     0.200
     0.912     0.096     0.200
     0.924    -0.320     0.200
     0.927    -0.161     0.200
     1.060     1.235     0.200
     1.105     0.031     0.200
     1.142     0.779     0.200
     1.199     0.553     0.200
     1.231     0.232     0.200
     1.706     0.421     0.200
     1.725    -0.230     0.200
     1.849     0.141     0.200
     1.915    -0.088     0.200
     1.941    -0.716     0.200
     2.057    -0.196     0.200
     0.507    -0.490     0.200
     0.650     0.966     0.200
     0.080     2.448     0.200
     0.222     2.120     0.200
     0.263     1.319     0.200
     0.271     1.181     0.200
     0.409     1.417     0.200
     0.450     1.019     0.200
     0.599     0.621     0.200
     0.656     1.398     0.200
     0.686     1.301     0.200
     0.114     0.520     0.200
     0.198     0.720     0.200
     0.219    -0.155     0.200
     0.309     0.150     0.200
     0.321     0.441     0.200
     0.370     0.860     0.200
     0.373     0.606     0.200
     0.385     0.276     0.200
     0.541    -0.489     0.200
     0.523     0.087     0.200
     0.542     0.101     0.200
     0.608    -0.028     0.200
     0.623    -0.342     0.200
     0.624     0.123     0.200
     0.632     0.495     0.200
     0.706     0.067     0.200
     0.837     0.187     0.200
     0.935    -0.102     0.200
     1.152     0.737     0.200
     1.204     0.489     0.200
     1.233     0.324     0.200
     1.709     0.521     0.200
     1.942    -0.555     0.200
     2.057    -0.297     0.200
     0.179     1.307     0.200
     0.231     1.378     0.200
     0.336     0.198     0.200
     0.349     0.884     0.200
     0.364     1.082     0.200
     0.397     0.580     0.200
     0.407     1.528     0.200
     0.413     0.888     0.200
     0.440     1.253     0.200
     0.447     1.084     0.200
     0.511     0.212     0.200
     0.534     0.642     0.200
     0.546     0.540     0.200
     0.620     1.334     0.200
     0.639     0.444     0.200
     0.637     1.254     0.200
     0.660     0.077     0.200
     0.687     0.996     0.200
     0.751    -0.003     0.200
     0.769     0.066     0.200
     0.773     1.143     0.200
     0.809     0.676     0.200
     0.843     0.426     0.200
     0.835     0.815     0.200
     0.861     0.902     0.200
     0.946     0.568     0.200
     1.585    -0.251     0.200
     1.605     0.155     0.200
     1.769    -0.646     0.200
     0.879    -0.380     0.200
     1.770    -3.104     0.200
     2.138    -2.985     0.200
     2.427    -4.526     0.200
     2.510    -5.563     0.200
     2.671    -6.555     0.200
     0.102     0.826     0.200
     0.205     0.546     0.200
     0.295     0.510     0.200
     0.326     0.440     0.200
     0.357     0.948     0.200
     0.369     0.696     0.200
     0.532    -0.398     0.200
     0.524     0.732     0.200
     0.618     0.490     0.200
     0.629     0.797     0.200
     0.693     0.094     0.200
     0.703     0.810     0.200
     0.922     0.682     0.200
     0.347     1.346     0.200
     1.685    -2.111     0.200
     1.709    -2.700     0.200
     1.896    -2.864     0.200
     2.141    -6.142     0.200
     2.266    -5.259     0.200
     2.115    -2.202     0.200
     2.592    -6.765     0.200
     0.151     0.844     0.200
     0.223     0.057     0.200
     0.235     1.370     0.200
     0.326     1.096     0.200
     0.349     0.187     0.200
     0.407     0.379     0.200
     0.484     0.942     0.200
     0.523     0.291     0.200
     0.581     0.599     0.200
     0.625     0.741     0.200
     0.677     0.024     0.200
     1.011     1.108     0.200
     0.032     2.527     0.200
     0.165     1.053     0.200
     0.175     0.780     0.200
     0.203     1.306     0.200
     0.369     0.920     0.200
     0.367     0.206     0.200
     0.482     0.199     0.200
     0.510    -0.171     0.200
     0.581     0.414     0.200
     0.571     0.714     0.200
     0.590     0.138     0.200
     0.599    -0.119     0.200
     0.643     0.463     0.200
     0.638     0.332     0.200
     0.665     0.411     0.200
     0.711    -0.413     0.200
     0.708     1.392     0.200
     0.728     1.244     0.200
     0.725     0.150     0.200
     0.787     0.125     0.200
     0.848     0.701     0.200
     0.865     0.999     0.200
     0.864     0.544     0.200
     0.927     0.738     0.200
     1.011     0.270     0.200
     1.201     0.214     0.200
     1.188    -1.131     0.200
     1.736     0.363     0.200
     1.967     0.030     0.200
     2.317    -1.377     0.200
     2.633    -3.294     0.200
     2.738    -6.251     0.200
     0.175     0.869     0.200
     0.275     0.098     0.200
     0.311    -0.247     0.200
     0.341     0.030     0.200
     0.347     0.414     0.200
     0.447     0.735     0.200
     0.439     0.360     0.200
     0.501     0.504     0.200
     0.545    -0.345     0.200
     0.556     0.667     0.200
     0.661     0.170     0.200
     0.683     1.267     0.200
     0.720    -0.852     0.200
     0.740    -0.551     0.200
     1.038     0.660     0.200
     1.723     0.790     0.200
     0.122     1.681     0.200
     0.203     0.657     0.200
     0.257     1.047     0.200
     0.312     0.885     0.200
     0.317     0.876     0.200
     0.394     0.536     0.200
     0.426     0.987     0.200
     0.452     1.040     0.200
     0.586     0.252     0.200
     0.604     0.062     0.200
     0.624     0.912     0.200
     0.665     0.338     0.200
     0.713     0.576     0.200
     0.717     0.948     0.200
     0.721     1.026     0.200
     0.800     0.187     0.200
     0.809     0.844     0.200
     0.867     0.563     0.200
     0.903     0.849     0.200
     0.928     1.329     0.200
     0.991     0.867     0.200
     1.085    -0.492     0.200
     0.035     3.776     0.200
     0.127     1.630     0.200
     0.193     1.120     0.200
     0.287     1.105     0.200
     0.308     0.874     0.200
     0.361     0.677     0.200
     0.431     0.799     0.200
     0.505     1.526     0.200
     0.500     0.913     0.200
     0.499     0.031     0.200
     0.563     1.003     0.200
     0.618    -0.146     0.200
     0.625     0.936     0.200
     0.657     0.345     0.200
     0.688     1.802     0.200
     0.683     1.134     0.200
     0.706     0.524     0.200
     0.706     0.350     0.200
     0.711     0.642     0.200
     0.715     0.641     0.200
     0.748     0.208     0.200
     0.770     0.551     0.200
     0.789     0.668     0.200
     0.796     0.404     0.200
     0.841     1.391     0.200
     0.846     0.987     0.200
     0.931     0.463     0.200
     1.136    -0.282     0.200
     1.269    -0.917     0.200
     1.361    -1.417     0.200
     2.301    -3.302     0.200
     2.497    -5.903     0.200
     0.034     3.365     0.200
     0.130     1.134     0.200
     0.187     0.357     0.200
     0.284     0.990     0.200
     0.312     0.758     0.200
     0.356    -0.087     0.200
     0.425     0.067     0.200
     0.474     1.018     0.200
     0.496     0.284     0.200
     0.498     1.293     0.200
     0.560     0.019     0.200
     0.610     0.647     0.200
     0.619     0.882     0.200
     0.651    -0.418     0.200
     0.684     0.506     0.200
     0.698     0.350     0.200
     0.702     0.474     0.200
     0.707     0.592     0.200
     0.714    -0.133     0.200
     0.741     0.736     0.200
     0.767    -0.333     0.200
     0.794    -0.072     0.200
     0.837     1.265     0.200
     1.000     1.207     0.200
     1.050     0.996     0.200
     1.083     0.915     0.200
     1.130    -0.311     0.200
     0.136     0.707     0.200
     0.231     0.372     0.200
     0.203     0.892     0.200
     0.286     0.678     0.200
     0.302     0.512     0.200
     0.311     1.269     0.200
     0.372     0.177     0.200
     0.414     1.091     0.200
     0.441     0.555     0.200
     0.463     1.123     0.200
     0.537     0.307     0.200
     0.545     0.576     0.200
     0.565     0.017     0.200
     0.606     1.377     0.200
     0.653     0.093     0.200
     0.634     1.221     0.200
     0.880     0.436     0.200
     0.930     0.603     0.200
     0.971     0.573     0.200
     0.037     3.240     0.200
     0.136     1.175     0.200
     0.185     0.655     0.200
     0.279     0.746     0.200
     0.420     0.490     0.200
     0.495     0.547     0.200
     0.555     0.511     0.200
     0.616     0.357     0.200
     0.645     0.217     0.200
     0.703     0.602     0.200
     0.716     1.038     0.200
     0.777     1.339     0.200
     0.837     1.394     0.200
     0.997     1.133     0.200
     0.135     0.309     0.200
     0.199     0.527     0.200
     0.210     0.244     0.200
     0.290     0.174     0.200
     0.340     0.465     0.200
     0.340     0.856     0.200
     0.488     0.825     0.200
     0.564     0.608     0.200
     0.681    -0.356     0.200
     0.906     0.341     0.200
     0.037     3.997     0.200
     0.134     1.545     0.200
     0.185     1.480     0.200
     0.266     0.866     0.200
     0.313     0.988     0.200
     0.352     0.529     0.200
     0.421     0.886     0.200
     0.496     0.186     0.200
     0.498    -0.057     0.200
     0.607     0.864     0.200
     0.646    -0.522     0.200
     0.684     0.886     0.200
     0.695     0.509     0.200
     0.698     0.188     0.200
     0.715     0.516     0.200
     0.722     0.233     0.200
     0.768    -0.258     0.200
     0.779     0.560     0.200
     0.792     0.603     0.200
     0.838     1.075     0.200
     0.849    -0.108     0.200
     0.857    -0.072     0.200
     1.126    -0.758     0.200
     1.116     0.340     0.200
     1.176     0.023     0.200
     1.879    -0.524     0.200
     2.183    -0.821     0.200
     0.722     0.346     0.200
     0.192     2.173     0.200
     0.253     1.522     0.200
     0.290     1.312     0.200
     0.419     1.146     0.200
     0.415     1.255     0.200
     0.527     0.879     0.200
     0.718     0.706     0.200
     0.736     0.915     0.200
     0.809     1.145     0.200
     0.884    -0.074     0.200
     0.901     0.308     0.200
     0.925     0.253     0.200
     0.020     5.116     0.200
     0.101     2.994     0.200
     0.152     2.558     0.200
     0.215     1.964     0.200
     0.470     0.846     0.200
     0.584     1.163     0.200
     0.604     0.143     0.200
     0.636     1.588     0.200
     0.667     0.930     0.200
     0.680     0.351     0.200
     0.740     0.746     0.200
     0.745     0.056     0.200
     0.787     0.742     0.200
     0.113     1.598     0.200
     0.175     1.259     0.200
     0.257     0.298     0.200
     0.278     0.063     0.200
     0.316     0.306     0.200
     0.366     0.555     0.200
     0.420     0.579     0.200
     0.418     0.383     0.200
     0.438     0.997     0.200
     0.447     0.566     0.200
     0.472     0.733     0.200
     0.522     0.031     0.200
     0.500     0.631     0.200
     0.555     1.170     0.200
     0.581     1.100     0.200
     0.662    -0.205     0.200
     0.668     0.990     0.200
     0.688    -0.476     0.200
     0.686     0.969     0.200
     0.708    -0.277     0.200
     0.708     0.173     0.200
     0.795     0.299     0.200
     0.861    -0.169     0.200
     0.840     0.770     0.200
     0.914     1.185     0.200
     1.007     0.653     0.200
     1.136    -0.243     0.200
     1.242    -0.017     0.200
     1.629    -0.337     0.200
     1.692    -0.547     0.200
     0.360     0.200     0.200
     0.745     1.940     0.200
     1.040    -1.557     0.200
     0.139     1.818     0.200
     0.143     1.423     0.200
     0.227     1.000     0.200
     0.293     0.797     0.200
     0.307     0.295     0.200
     0.623     0.827     0.200
     0.734    -0.133     0.200
     0.753     0.796     0.200
     0.782     1.182     0.200
     0.803     0.990     0.200
     0.018     3.866     0.200
     0.122     0.937     0.200
     0.166     1.498     0.200
     0.246     0.566     0.200
     0.428    -0.163     0.200
     0.479     1.419     0.200
     0.599    -0.282     0.200
     0.649    -0.374     0.200
     0.683    -0.069     0.200
     0.692     0.670     0.200
     0.712     0.622     0.200
     0.698     0.437     0.200
     0.814     1.246     0.200
     0.114     0.538     0.200
     0.165     0.659     0.200
     0.186    -0.005     0.200
     0.261     0.931     0.200
     0.272    -0.059     0.200
     0.346     1.118     0.200
     0.347     0.203     0.200
     0.377     0.146     0.200
     0.587     0.287     0.200
     0.599    -0.267     0.200
     0.637     0.494     0.200
     0.651     0.306     0.200
     0.728     0.747     0.200
     0.795     1.050     0.200
     0.830    -0.058     0.200
     1.099     0.249     0.200
     1.201     0.267     0.200
     1.313    -1.626     0.200
     3.136    -4.020     0.200
     0.134     1.317     0.200
     0.316     0.580     0.200
     0.317     0.737     0.200
     0.332     0.163     0.200
     0.421     0.399     0.200
     0.492     0.534     0.200
     0.525    -0.144     0.200
     0.513     0.565     0.200
     0.614     0.232     0.200
     0.616     0.136     0.200
     0.792    -0.296     0.200
     0.789    -0.438     0.200
     0.773     0.116     0.200
     0.803     0.561     0.200
     0.828     0.187     0.200
     0.946    -0.132     0.200
     0.946     0.402     0.200
     1.046     0.699     0.200
     1.819     0.005     0.200
     1.934    -0.780     0.200
     0.610    -0.584     0.200
     2.545    -4.130     0.200
     0.145     1.342     0.200
     0.166     0.791     0.200
     0.267    -0.008     0.200
     0.315    -0.394     0.200
     0.340    -0.118     0.200
     0.307     0.719     0.200
     0.380    -0.219     0.200
     0.384     0.443     0.200
     0.372     0.274     0.200
     0.422     0.847     0.200
     0.507     0.520     0.200
     0.529    -0.142     0.200
     0.545    -0.709     0.200
     0.523     0.492     0.200
     0.540    -0.092     0.200
     0.520     0.411     0.200
     0.647     1.066     0.200
     0.660     0.809     0.200
     0.681    -0.472     0.200
     0.683     0.813     0.200
     0.740    -0.077     0.200
     0.749    -0.199     0.200
     0.753    -0.661     0.200
     0.786     1.307     0.200
     0.826     0.284     0.200
     0.825     1.113     0.200
     0.852     1.095     0.200
     0.917     0.108     0.200
     0.932     0.366     0.200
     1.044    -0.461     0.200
     1.070    -0.064     0.200
     1.090    -0.072     0.200
     1.181    -0.282     0.200
     1.674    -0.390     0.200
     1.693    -0.519     0.200
     1.725     0.220     0.200
     1.755    -0.449     0.200
     0.300     0.767     0.200
     0.675     0.602     0.200
     0.715     1.851     0.200
     0.981    -1.538     0.200
     1.664     0.189     0.200
     1.751    -1.872     0.200
     0.146     1.130     0.200
     0.168     0.775     0.200
     0.270     0.061     0.200
     0.318    -0.279     0.200
     0.304     0.942     0.200
     0.344    -0.148     0.200
     0.383    -0.261     0.200
     0.384     0.511     0.200
     0.368     0.278     0.200
     0.424     0.994     0.200
     0.510     0.615     0.200
     0.524     0.427     0.200
     0.549    -0.750     0.200
     0.517     0.340     0.200
     0.647     0.786     0.200
     0.662     0.654     0.200
     0.685    -0.568     0.200
     0.687     0.579     0.200
     0.743    -0.198     0.200
     0.753    -0.238     0.200
     0.757    -0.706     0.200
     0.784     0.762     0.200
     0.830     0.181     0.200
     0.824     1.190     0.200
     0.850     1.200     0.200
     0.921     0.136     0.200
     0.936     0.240     0.200
     0.946     0.144     0.200
     1.049    -0.181     0.200
     1.074    -0.201     0.200
     1.094     0.161     0.200
     1.186    -0.581     0.200
     1.204     0.598     0.200
     1.678    -0.394     0.200
     1.697    -0.537     0.200
     1.728     0.053     0.200
     1.759    -0.562     0.200
     0.677     0.335     0.200
     1.755    -1.184     0.200
     2.111    -2.491     0.200
     2.484    -3.171     0.200
     0.075     2.126     0.200
     0.098     1.724     0.200
     0.237     1.396     0.200
     0.262     1.249     0.200
     0.421     0.472     0.200
     0.466     0.674     0.200
     0.539     0.345     0.200
     0.554     0.858     0.200
     0.575     0.687     0.200
     0.613     0.534     0.200
     0.611     1.009     0.200
     0.646     1.002     0.200
     0.734    -0.905     0.200
     0.796    -0.228     0.200
     0.873     0.415     0.200
     1.000    -0.019     0.200
     1.104     0.124     0.200
     1.115     0.042     0.200
     1.138     0.530     0.200
     1.665     0.155     0.200
     0.422    -0.363     0.200
     1.694    -0.139     0.200
     0.054     1.762     0.200
     0.280     0.991     0.200
     0.295     0.329     0.200
     0.387     1.014     0.200
     0.377     1.035     0.200
     0.513     0.097     0.200
     0.568     0.758     0.200
     0.622     0.785     0.200
     0.661     0.436     0.200
     0.772     1.342     0.200
     0.775     0.776     0.200
     0.964     1.234     0.200
     1.003    -0.378     0.200
     1.055     0.539     0.200
     1.107     0.438     0.200
     1.169     0.516     0.200
     1.255     0.220     0.200
     1.934    -1.097     0.200
     0.038     3.804     0.200
     0.112     1.832     0.200
     0.133     1.471     0.200
     0.190     1.367     0.200
     0.207     1.273     0.200
     0.266     0.849     0.200
     0.281     1.119     0.200
     0.309     0.396     0.200
     0.354     0.248     0.200
     0.474     0.565     0.200
     0.501     1.136     0.200
     0.501    -0.073     0.200
     0.611     0.041     0.200
     0.622     0.191     0.200
     0.650     0.569     0.200
     0.688     0.628     0.200
     0.700     0.087     0.200
     0.700     0.135     0.200
     0.704     0.065     0.200
     0.741     1.092     0.200
     0.783     0.129     0.200
     0.875     0.218     0.200
     1.002     0.476     0.200
     0.207     0.747     0.200
     0.201     1.072     0.200
     0.218     0.980     0.200
     0.249     0.750     0.200
     0.299     0.647     0.200
     0.333     0.072     0.200
     0.356     0.481     0.200
     0.415     0.308     0.200
     0.444    -0.341     0.200
     0.725     0.264     0.200
     1.811     0.197     0.200
     0.302     0.595     0.200
     1.994    -3.793     0.200
     2.076    -2.197     0.200
     2.234    -5.452     0.200
     2.161    -3.765     0.200
     2.200    -5.003     0.200
     2.343    -4.157     0.200
     2.396    -6.167     0.200
     2.482    -6.867     0.200
     2.490    -6.065     0.200
     2.568    -6.325     0.200
     0.451     2.086     0.200
     1.523    -1.063     0.200
     1.877    -2.045     0.200
     2.466    -5.748     0.200
     0.039     0.959     0.200
     0.972     0.965     0.200
     1.948    -0.872     0.200
     1.897     0.966     0.200
     2.031    -1.575     0.200
     2.052    -0.971     0.200
     2.092    -1.133     0.200
     2.341    -3.324     0.200
     2.362    -2.284     0.200
     2.401    -3.543     0.200
     2.415    -3.479     0.200
     2.555    -4.074     0.200
     2.780    -3.609     0.200
     2.868    -4.978     0.200
     3.128    -4.959     0.200
     0.607     1.285     0.200
     0.763    -1.365     0.200
     0.751     0.109     0.200
     1.666    -0.388     0.200
     1.885    -1.977     0.200
     2.911    -5.854     0.200
     0.715    -0.512     0.200
     2.642    -6.726     0.200
     2.835    -5.719     0.200
     2.771    -7.003     0.200
     2.778    -3.729     0.200
     3.319    -8.851     0.200
     0.596     0.365     0.200
     1.912    -2.922     0.200
     2.045    -4.239     0.200
     2.104    -3.095     0.200
     2.363    -3.405     0.200
     2.451    -6.198     0.200
     2.698    -7.522     0.200
     2.801    -6.064     0.200
     0.863    -0.401     0.200
     2.886    -5.897     0.200
     3.055    -7.318     0.200
     3.190    -7.411     0.200
     3.205    -6.777     0.200
     0.436    -0.375     0.200
     0.787    -0.581     0.200
     1.878     0.610     0.200
     0.381     1.157     0.200
     1.355    -2.762     0.200
     1.955    -1.927     0.200
     2.440    -6.774     0.200
     2.467    -5.556     0.200
     2.529    -6.322     0.200
     2.965    -4.546     0.200
     3.478    -9.911     0.200
EOF
gmt end
