#!/bin/bash
gmt begin chamoli16.22_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional chamoli16.22'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.541
    15.000    42.262
    15.500    41.981
    16.000    41.697
    16.500    41.407
    17.000    41.111
    17.500    40.806
    18.000    40.491
    18.500    40.164
    19.000    39.822
    19.500    39.464
    20.000    39.086
    20.500    38.687
    21.000    38.265
    21.500    37.817
    22.000    37.341
    22.500    36.835
    23.000    36.297
    23.500    35.727
    24.000    34.507
    24.500    33.235
    25.000    31.954
    25.500    30.662
    26.000    29.359
    26.500    28.044
    27.000    26.717
    27.500    25.374
    28.000    24.011
    28.500    22.632
    29.000    21.242
    29.500    19.843
    30.000    18.437
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.011 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     8.916
     1.500     9.859
     2.000    10.803
     2.500    11.746
     3.000    12.690
     3.500    13.633
     4.000    14.574
     4.500    15.514
     5.000    16.454
     5.500    17.393
     6.000    18.330
     6.500    19.267
     7.000    20.202
     7.500    21.134
     8.000    22.066
     8.500    22.995
     9.000    23.922
     9.500    24.848
    10.000    25.771
    10.500    26.691
    11.000    27.609
    11.500    28.525
    12.000    29.437
    12.500    30.347
    13.000    31.254
    13.500    32.157
    14.000    33.058
    14.500    33.955
    15.000    34.848
    15.500    35.737
    16.000    36.623
    16.500    37.505
    17.000    38.383
    17.500    39.668
    18.000    40.015
    18.500    40.303
    19.000    40.534
    19.500    40.706
    20.000    40.820
    20.500    40.876
    21.000    40.871
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    28.254 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.694
     1.000     7.099
     1.500    10.025
     2.000    12.716
     2.500    15.407
     3.000    18.097
     3.500    20.787
     4.000    23.475
     4.500    26.162
     5.000    28.848
     5.500    31.533
     6.000    34.215
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.848 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    23.507
     1.500    29.681
     2.000    35.856
     2.500    42.030
     3.000    48.205
     3.500    54.379
     4.000    60.551
     4.500    66.721
     5.000    72.890
     5.500    79.056
     6.000    85.220
     6.500    91.383
     7.000    97.542
     7.500   103.699
     8.000   109.852
     8.500   116.003
     9.000   122.150
     9.500   128.292
    10.000   134.432
    10.500   140.567
    11.000   146.697
    11.500   152.824
    12.000   158.944
    12.500   165.060
    13.000   171.171
    13.500   177.276
    14.000   183.375
    14.500   189.468
    15.000   195.555
    15.500   201.635
    16.000   207.709
    16.500   213.776
    17.000   219.835
    17.500   234.428
    18.000   240.700
    18.500   246.959
    19.000   253.205
    19.500   259.438
    20.000   265.656
    20.500   271.861
    21.000   278.050
    21.500   284.224
    22.000   290.383
    22.500   296.526
    23.000   302.652
    23.500   308.762
    24.000   314.855
    24.500   320.930
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    58.551 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.504
     1.000    20.513
     1.500    29.276
     2.000    37.836
     2.500    46.396
     3.000    54.953
     3.500    63.510
     4.000    72.065
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    61.510 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    19.980   259.189     0.150
    20.120   254.548     0.150
    20.428   261.960     0.150
    29.483   314.280     0.150
    19.690    53.268     0.150
    20.384   265.166     0.150
    20.629   266.312     0.150
    27.414    69.127     0.150
    27.414   383.127     0.150
    28.332    81.413     0.150
    28.332   312.413     0.150
    29.718   325.239     0.150
    23.254   283.309     0.150
    28.212   310.454     0.150
    20.445   259.978     0.150
    20.590   263.290     0.150
    21.713   275.179     0.150
    23.450   284.910     0.150
    23.614   288.993     0.150
    24.528   290.328     0.150
    26.310   302.528     0.150
    27.803   300.613     0.150
    28.351   665.716     0.150
    28.354   312.179     0.150
    29.341  -338.806     0.150
    29.341   310.561     0.150
    29.341   312.163     0.150
    29.539   311.850     0.150
    29.662   312.411     0.150
    19.754   275.732     0.150
    20.176   257.811     0.150
    20.389   265.331     0.150
    20.528   263.203     0.150
    23.736   696.262     0.150
    23.873   289.870     0.150
    19.783   278.496     0.150
    20.482   261.237     0.150
    20.482    54.441     0.150
    24.756   464.763     0.150
    24.995   291.674     0.150
    13.902   359.937     0.150
    13.069   363.027     0.150
    13.069   574.527     0.150
    14.163   357.765     0.150
    14.163   787.765     0.150
    19.596    43.859     0.150
    19.596   257.859     0.150
    20.451   264.386     0.150
    20.762    62.756     0.150
    22.040   276.834     0.150
    22.043   275.801     0.150
    22.567   279.195     0.150
    23.641   321.152     0.150
    25.481   292.678     0.150
    25.481   457.280     0.150
    26.937   227.693     0.150
    27.093  -308.764     0.150
    27.485   306.298     0.150
    28.284   306.968     0.150
    28.443  -322.935     0.150
    28.443   308.111     0.150
    28.443    70.611     0.150
    28.443   214.111     0.150
    28.552   311.849     0.150
    28.552    77.849     0.150
    29.571   402.957     0.150
    18.703   249.844     0.150
    23.381   299.257     0.150
    26.469  -300.398     0.150
    10.749    38.080     0.150
    20.192   264.081     0.150
    20.651   268.727     0.150
    20.651   292.727     0.150
    21.438   270.541     0.150
    21.557   272.155     0.150
    22.199   302.663     0.150
    23.137   286.720     0.150
    24.820   292.079     0.150
    25.521   295.899     0.150
    25.613   295.817     0.150
    25.613   303.817     0.150
    26.282   294.014     0.150
    26.823   304.702     0.150
    27.089   223.595     0.150
    27.089   306.595     0.150
    27.672   308.297     0.150
    28.018   311.758     0.150
    28.287  -322.007     0.150
    28.467    83.512     0.150
    28.467   313.512     0.150
    28.467   393.512     0.150
    28.983    73.490     0.150
    29.040   310.824     0.150
    29.199  -332.756     0.150
    29.199    78.971     0.150
    29.199   313.971     0.150
    29.199   321.971     0.150
    29.339  -333.788     0.150
    29.339   313.134     0.150
    29.378  -334.239     0.150
    29.378    75.886     0.150
    29.824   305.685     0.150
    14.823   216.765     0.150
    19.253    53.071     0.150
    19.628   255.687     0.150
    19.709   260.553     0.150
    21.701   490.910     0.150
    10.320    31.619     0.150
    10.320    36.619     0.150
    20.014   259.490     0.150
    20.222   507.957     0.150
    20.211   259.187     0.150
    20.444    48.471     0.150
    20.444    51.971     0.150
    20.444   263.471     0.150
    20.444   276.471     0.150
    21.968   278.685     0.150
    24.360   290.773     0.150
    25.004    66.250     0.150
    26.642   302.138     0.150
    27.122   306.535     0.150
    27.393   305.368     0.150
    27.496   302.169     0.150
    28.354  -323.896     0.150
    29.127   311.138     0.150
     9.451    31.819     0.150
     9.451    35.819     0.150
     9.451   403.819     0.150
     9.451   612.819     0.150
     9.451   615.819     0.150
     9.451   825.819     0.150
    12.891   367.888     0.150
    21.200    63.717     0.150
    21.200   267.717     0.150
    21.200   282.717     0.150
    21.339   286.586     0.150
    21.339   299.086     0.150
    21.339   502.086     0.150
    21.339    62.086     0.150
    21.339   286.484     0.150
    21.956   275.452     0.150
    23.330   286.861     0.150
    24.307   289.451     0.150
    24.307   697.451     0.150
    26.007   299.616     0.150
    28.004   309.315     0.150
    28.248    72.460     0.150
    28.248   211.460     0.150
    28.225   307.727     0.150
    28.438  -325.075     0.150
    28.438    67.245     0.150
    28.438   395.245     0.150
    29.435   408.614     0.150
    29.791    71.457     0.150
    29.791   323.457     0.150
    14.949   217.785     0.150
    21.883   276.342     0.150
    24.597   295.196     0.150
    21.368   281.936     0.150
    24.282   291.226     0.150
    24.588   294.662     0.150
    26.812   227.406     0.150
    29.860  -340.268     0.150
    14.908   344.375     0.150
    14.908   558.274     0.150
    21.391   281.911     0.150
    24.556   295.389     0.150
    18.970    47.457     0.150
    24.558   294.463     0.150
    14.964    50.277     0.150
    24.622   291.067     0.150
    21.386   281.740     0.150
    19.689    44.871     0.150
     9.251    36.235     0.150
     9.251    41.235     0.150
    21.253   272.168     0.150
    12.947   363.877     0.150
    18.686    44.760     0.150
    18.686    47.459     0.150
    20.692    43.757     0.150
    20.692    47.956     0.150
    20.692   265.555     0.150
    20.713   288.564     0.150
    20.792    47.791     0.150
    20.792    51.791     0.150
    20.792   277.791     0.150
    20.792   295.791     0.150
     9.330    32.929     0.150
     9.330    38.229     0.150
    21.004   270.488     0.150
    23.414   285.567     0.150
    24.352   290.618     0.150
    24.413   294.610     0.150
    18.995    45.285     0.150
    14.374   209.227     0.150
    26.255   678.747     0.150
    20.410    46.495     0.150
    20.410    50.296     0.150
    24.496   251.437     0.150
    26.791   229.217     0.150
    14.817   218.033     0.150
    14.896   345.688     0.150
    14.896   771.288     0.150
    19.040   302.723     0.150
    20.200   255.922     0.150
    21.089   297.610     0.150
    21.292   265.942     0.150
    21.292   299.442     0.150
    21.459   266.194     0.150
    21.459   286.494     0.150
    21.459   304.594     0.150
    23.418   285.720     0.150
    23.418   287.902     0.150
    23.753   285.946     0.150
    24.496   287.949     0.150
    24.496   336.051     0.150
    27.058   224.699     0.150
    29.710   419.811     0.150
    18.291    48.411     0.150
    18.291    54.004     0.150
    18.291   250.207     0.150
    20.094    59.961     0.150
    20.094   286.664     0.150
    20.408    51.796     0.150
    20.408   265.499     0.150
    20.416    58.201     0.150
    23.389   297.914     0.150
    26.504   231.119     0.150
    27.293   226.257     0.150
    27.293   377.358     0.150
    27.293   449.257     0.150
    20.394    55.274     0.150
    20.394    60.274     0.150
    27.279   224.026     0.150
    27.279   302.924     0.150
    27.279   317.924     0.150
    27.279   442.823     0.150
    16.932   537.595     0.150
    25.006   297.667     0.150
    26.949   227.972     0.150
    27.342  -314.651     0.150
    27.858   309.789     0.150
    20.434    46.800     0.150
    20.434    50.300     0.150
    18.664    45.835     0.150
    18.664    49.335     0.150
    14.880   216.966     0.150
    19.517   256.061     0.150
    19.517   513.858     0.150
    19.517   733.959     0.150
    21.867   272.031     0.150
    21.867   308.031     0.150
    21.919   272.321     0.150
    22.350   275.790     0.150
    22.350   491.790     0.150
    22.948   285.395     0.150
    24.165   288.517     0.150
    25.280   246.601     0.150
    25.280   293.202     0.150
    25.280   354.304     0.150
    25.280   461.304     0.150
    26.005   240.448     0.150
    26.005   294.643     0.150
    26.005   454.346     0.150
    26.005   458.245     0.150
    27.203   302.863     0.150
    27.203   375.363     0.150
    27.319   224.437     0.150
    27.319   443.085     0.150
    27.925   309.639     0.150
    27.925   390.834     0.150
    28.594    75.125     0.150
    28.594   213.024     0.150
    28.594   306.922     0.150
    28.594   430.625     0.150
    28.594   434.922     0.150
    28.594   662.625     0.150
    28.991   205.994     0.150
    14.769   215.171     0.150
    20.178    57.055     0.150
    20.178   262.856     0.150
    20.474   261.296     0.150
    20.474   292.796     0.150
    20.509   262.793     0.150
    20.509   292.891     0.150
    20.578   290.085     0.150
    20.578   505.636     0.150
    23.457   263.682     0.150
    23.457   332.784     0.150
    23.457   481.584     0.150
    24.468   290.084     0.150
    24.683    62.783     0.150
    24.683   294.783     0.150
    26.617   232.164     0.150
    27.400    74.168     0.150
    27.400   226.070     0.150
    27.400   304.969     0.150
    27.400   381.570     0.150
    27.400   443.871     0.150
    28.966   314.689     0.150
    28.966   320.189     0.150
    29.283   311.799     0.150
    29.954   317.262     0.150
    15.139   215.631     0.150
    20.627    46.983     0.150
    20.627    50.784     0.150
    20.627   263.585     0.150
    20.627   294.483     0.150
    27.879    76.254     0.150
    27.879   222.554     0.150
    27.879   307.654     0.150
    27.879   317.455     0.150
    27.879   386.754     0.150
    27.879   440.754     0.150
    27.879   670.853     0.150
    16.821   539.384     0.150
    20.596   267.763     0.150
    20.596   503.506     0.150
    20.684   288.984     0.150
    20.684   503.136     0.150
    20.685   266.767     0.150
    20.685   502.466     0.150
    22.652   282.911     0.150
    24.040   472.368     0.150
    14.783   214.766     0.150
    14.783   347.567     0.150
    14.783   556.567     0.150
    14.783   561.766     0.150
    14.783   774.766     0.150
    19.483   250.513     0.150
    19.657   256.683     0.150
    19.657   272.683     0.150
    22.174   314.007     0.150
    22.507   280.482     0.150
    22.518   278.686     0.150
    25.637   292.096     0.150
    25.637   358.596     0.150
    28.588    69.856     0.150
    28.588   307.356     0.150
    28.748    74.086     0.150
    28.748   309.786     0.150
    10.309    30.820     0.150
    10.309    35.625     0.150
    15.090    44.128     0.150
    15.090   345.026     0.150
    16.973   538.851     0.150
    16.973   538.851     0.150
    18.553   247.819     0.150
    20.153   262.445     0.150
    20.153   291.945     0.150
    20.320   292.339     0.150
    20.320   278.402     0.150
    20.355   291.634     0.150
    20.582    58.430     0.150
    20.792   266.079     0.150
    20.792   286.673     0.150
    20.881   265.051     0.150
    20.881   285.653     0.150
    22.467   283.620     0.150
    23.361   296.199     0.150
    23.361   327.996     0.150
    24.285   291.331     0.150
    24.285   469.714     0.150
    24.290   291.290     0.150
    24.294   252.774     0.150
    24.294   295.696     0.150
    24.294   470.462     0.150
    26.847   228.244     0.150
    26.847   228.244     0.150
    26.858   228.583     0.150
    27.528    69.182     0.150
    27.528   304.479     0.150
    27.528   316.877     0.150
    28.789   310.661     0.150
    10.310    31.289     0.150
    10.310   608.689     0.150
    20.172   292.897     0.150
    20.172   510.497     0.150
    20.333   292.577     0.150
    20.603    44.375     0.150
    20.603    47.175     0.150
    26.865   228.352     0.150
    27.548   307.125     0.150
    27.548   313.326     0.150
    10.321    33.987     0.150
    15.098    42.341     0.150
    15.098    47.341     0.150
    15.098   212.435     0.150
    15.098   345.037     0.150
    16.983   536.531     0.150
    18.554   248.699     0.150
    18.554   261.097     0.150
    20.149   260.897     0.150
    20.149   289.397     0.150
    20.149   506.991     0.150
    20.310   289.411     0.150
    20.310   505.106     0.150
    20.332   260.155     0.150
    20.332   272.952     0.150
    20.581   260.746     0.150
    20.581   289.645     0.150
    20.803   262.875     0.150
    20.803   500.110     0.150
    20.891   261.824     0.150
    20.891   499.074     0.150
    23.355   261.270     0.150
    23.355   282.567     0.150
    23.355   326.668     0.150
    23.355   474.168     0.150
    24.305   250.788     0.150
    24.305   468.577     0.150
    26.851   226.398     0.150
    27.528   302.275     0.150
    27.528   375.572     0.150
    28.463   211.966     0.150
    10.578    29.643     0.150
    15.159   219.587     0.150
    15.159   340.688     0.150
    17.133   792.375     0.150
    18.425   248.169     0.150
    18.425   253.270     0.150
    18.425   523.872     0.150
    18.425   742.469     0.150
    19.893    59.840     0.150
    19.893   268.640     0.150
    19.893   285.242     0.150
    19.978   252.686     0.150
    19.978   509.803     0.150
    19.978   762.854     0.150
    20.025    60.495     0.150
    20.025   258.495     0.150
    20.025   287.198     0.150
    20.389    59.551     0.150
    20.389   254.953     0.150
    20.713   268.037     0.150
    20.809   265.097     0.150
    20.991   266.703     0.150
    20.991   284.652     0.150
    20.991   749.953     0.150
    21.078   265.708     0.150
    21.078   283.610     0.150
    21.078   748.938     0.150
    21.372    39.629     0.150
    21.601    39.675     0.150
    21.807    40.009     0.150
    22.216    39.996     0.150
    22.571    39.058     0.150
    23.064   266.734     0.150
    23.064   282.734     0.150
    23.064   326.632     0.150
    23.064   483.132     0.150
    24.275   289.402     0.150
    24.543   293.908     0.150
    25.212   298.467     0.150
    26.794   229.123     0.150
    27.377    74.409     0.150
    27.377   302.609     0.150
    27.377   315.007     0.150
    27.447   300.985     0.150
    27.791   308.474     0.150
    28.460   310.666     0.150
    28.460   316.365     0.150
    29.011   309.340     0.150
    29.850    73.139     0.150
    29.850   312.338     0.150
    14.689   212.709     0.150
    18.319    48.158     0.150
    18.319    52.752     0.150
    18.319   252.354     0.150
    19.928   259.518     0.150
    20.430   260.313     0.150
    20.433    50.072     0.150
    20.433    54.479     0.150
    20.433    60.572     0.150
    20.433   291.479     0.150
    24.398    65.113     0.150
    24.398   295.011     0.150
    24.614   291.586     0.150
    21.202    63.394     0.150
    23.745   286.155     0.150
    24.353   254.025     0.150
    24.353   289.125     0.150
    24.353   341.224     0.150
    24.353   470.724     0.150
    24.432   294.000     0.150
    25.225    69.644     0.150
    25.225   292.045     0.150
    27.990   309.579     0.150
    29.686    74.981     0.150
    29.686   314.881     0.150
    29.686   402.381     0.150
     8.730    27.918     0.150
    19.484   267.125     0.150
    19.633   257.434     0.150
    19.726   256.395     0.150
    21.851   277.705     0.150
    21.851   310.502     0.150
    21.893    65.407     0.150
    21.893   310.009     0.150
    22.346    65.020     0.150
    22.488   271.666     0.150
    22.488   486.174     0.150
    22.916   284.312     0.150
    24.120   292.025     0.150
    25.271   292.791     0.150
    25.271   352.588     0.150
    25.271   461.986     0.150
    27.279   225.216     0.150
    27.279   225.216     0.150
    28.954   209.679     0.150
    28.954    70.000     0.150
    10.329    33.701     0.150
    18.422    49.763     0.150
    20.009   260.739     0.150
    20.204    45.264     0.150
    20.204    50.964     0.150
    20.204    59.464     0.150
    20.204   258.764     0.150
    20.204   286.964     0.150
    20.442    46.190     0.150
    20.442    50.190     0.150
    20.442    58.491     0.150
    20.442   259.491     0.150
    20.442   289.690     0.150
    19.436    47.711     0.150
    19.436    52.211     0.150
    22.233   274.866     0.150
    22.233   316.565     0.150
    23.034   282.201     0.150
    25.165   290.154     0.150
    25.165   305.654     0.150
    29.063    70.459     0.150
    29.063   309.756     0.150
    29.063   395.959     0.150
     8.745    25.538     0.150
    19.499    42.445     0.150
    19.499    44.945     0.150
    21.906   277.858     0.150
    21.906   308.159     0.150
    25.277    68.814     0.150
    25.277   292.314     0.150
    27.296   223.415     0.150
    27.296   223.419     0.150
    28.968    69.044     0.150
    28.968   313.341     0.150
    28.968   392.341     0.150
     9.556    26.850     0.150
    10.138    38.360     0.150
    21.135    59.220     0.150
    21.135   270.025     0.150
    21.135   300.220     0.150
    21.227   271.348     0.150
    21.293   498.131     0.150
    23.017   281.511     0.150
    24.202   290.324     0.150
    27.957   223.512     0.150
    29.649    72.766     0.150
    29.649   320.571     0.150
    29.719   315.357     0.150
    29.904    73.195     0.150
    29.904   317.390     0.150
    29.904   404.593     0.150
    16.870   536.617     0.150
    18.994    46.705     0.150
    20.042   266.882     0.150
    20.256    57.876     0.150
    20.256   256.076     0.150
    20.284   291.106     0.150
    20.284   504.356     0.150
    20.455   272.963     0.150
    20.702   263.172     0.150
    23.268   282.736     0.150
    24.378   285.976     0.150
    26.197   299.745     0.150
    26.710   228.238     0.150
    27.325    71.587     0.150
    27.325   222.986     0.150
    28.850    70.593     0.150
    29.272   312.662     0.150
    29.373   308.385     0.150
    18.049    54.343     0.150
    19.098   257.105     0.150
    19.274   258.647     0.150
    19.508   258.165     0.150
    20.303   259.939     0.150
    20.303   290.439     0.150
    20.303   727.338     0.150
    21.199   271.390     0.150
    21.375   272.529     0.150
    21.375   499.928     0.150
    21.590   273.125     0.150
    21.682   277.167     0.150
    21.682   493.366     0.150
    21.709   281.071     0.150
    21.856   281.484     0.150
    22.170   284.685     0.150
    23.366   286.642     0.150
    24.039   291.880     0.150
    24.548   288.803     0.150
    24.548   694.705     0.150
    25.194   296.109     0.150
    25.414   298.787     0.150
    25.407   292.484     0.150
    25.407   302.484     0.150
    25.526   295.012     0.150
    25.565   297.183     0.150
    26.118   306.251     0.150
    26.229   300.591     0.150
    27.456    71.863     0.150
    27.989    67.752     0.150
    27.989   304.854     0.150
    28.147   386.597     0.150
    28.335   437.515     0.150
    28.394   308.621     0.150
    29.260    73.911     0.150
    29.260   206.610     0.150
    29.260   315.809     0.150
     9.248    26.904     0.150
    18.021    55.625     0.150
    18.021   244.722     0.150
    18.021   263.023     0.150
    20.269   263.787     0.150
    20.269   729.189     0.150
    21.156   270.243     0.150
    21.325   273.563     0.150
    21.668   279.573     0.150
    21.668   493.783     0.150
    23.285   289.498     0.150
    23.285   476.814     0.150
    26.897    71.943     0.150
    26.897   306.044     0.150
    26.897   308.443     0.150
    26.897   371.743     0.150
    27.027   228.244     0.150
    29.570   316.048     0.150
     9.298    34.644     0.150
     9.298    37.644     0.150
    26.929    72.381     0.150
     9.000    24.913     0.150
    10.101    31.637     0.150
    18.625    48.360     0.150
    27.256  -312.485     0.150
    20.973    46.580     0.150
    20.973    52.180     0.150
    26.598    74.839     0.150
    19.049    45.609     0.150
    29.583  -341.335     0.150
    20.603    46.607     0.150
    20.603   264.408     0.150
    26.848   227.933     0.150
    26.848   227.023     0.150
    19.840   261.094     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    20.120    37.548     0.200
    20.428    36.960     0.200
    21.855    36.297     0.200
    23.664    33.197     0.200
    24.242    32.449     0.200
    25.278    31.361     0.200
    29.483    20.280     0.200
    29.681    16.968     0.200
    19.690    37.268     0.200
    19.716    38.964     0.200
    20.567    40.036     0.200
    20.629    38.312     0.200
    22.260    38.277     0.200
    24.616    32.784     0.200
    27.414    28.127     0.200
    29.718    20.239     0.200
    29.727    20.136     0.200
    29.888    20.258     0.200
    20.289    36.493     0.200
    23.145    33.164     0.200
    28.479    19.913     0.200
    29.319    19.114     0.200
    20.603    38.646     0.200
    21.374    39.651     0.200
    29.915    18.982     0.200
    18.869    37.493     0.200
    20.312    38.153     0.200
    23.254    34.509     0.200
    28.212    23.454     0.200
    28.374    22.561     0.200
    29.886    18.918     0.200
    18.262    39.957     0.200
    19.837    39.368     0.200
    20.358    37.892     0.200
    20.445    38.978     0.200
    20.442    38.009     0.200
    20.590    38.290     0.200
    21.279    38.242     0.200
    21.641    39.019     0.200
    21.713    37.179     0.200
    23.450    33.910     0.200
    24.110    33.701     0.200
    24.528    32.328     0.200
    24.699    33.131     0.200
    24.885    31.157     0.200
    25.459    28.469     0.200
    26.310    30.528     0.200
    26.501    29.299     0.200
    26.651    28.657     0.200
    26.867    29.029     0.200
    27.803    24.511     0.200
    28.351    21.716     0.200
    28.354    23.883     0.200
    29.172    21.130     0.200
    29.183    21.002     0.200
    29.341    19.764     0.200
    29.341    18.960     0.200
    29.539    19.850     0.200
    29.662    18.911     0.200
    15.018    40.510     0.200
    19.926    38.234     0.200
    19.926    37.933     0.200
    20.174    36.834     0.200
    20.131    38.331     0.200
    20.176    35.811     0.200
    20.528    36.703     0.200
    20.943    36.666     0.200
    23.152    33.587     0.200
    23.736    32.861     0.200
    23.873    32.370     0.200
    24.298    31.712     0.200
    24.363    32.954     0.200
    25.034    29.121     0.200
    26.505    27.952     0.200
    26.629    27.804     0.200
    28.345    22.484     0.200
    28.345    23.285     0.200
    18.432    37.072     0.200
    18.769    38.334     0.200
    19.051    39.842     0.200
    20.030    36.913     0.200
    20.030    38.714     0.200
    20.032    38.598     0.200
    20.232    38.259     0.200
    20.252    39.029     0.200
    20.252    39.228     0.200
    20.482    36.339     0.200
    20.482    37.237     0.200
    21.047    37.251     0.200
    21.246    37.023     0.200
    21.552    36.057     0.200
    22.889    37.551     0.200
    23.706    33.416     0.200
    23.865    34.360     0.200
    24.320    32.555     0.200
    24.375    31.906     0.200
    24.756    32.661     0.200
    24.995    30.373     0.200
    26.208    28.520     0.200
    26.512    27.969     0.200
    26.512    28.368     0.200
    26.644    27.930     0.200
    27.405    26.554     0.200
    27.510    24.528     0.200
    20.401    37.448     0.200
    21.410    35.377     0.200
    24.720    30.141     0.200
    26.495    27.834     0.200
    19.094    39.548     0.200
    21.160    38.639     0.200
    14.163    40.765     0.200
    16.294    40.892     0.200
    19.368    37.120     0.200
    19.596    38.258     0.200
    20.451    37.386     0.200
    22.040    36.631     0.200
    22.043    36.301     0.200
    22.511    35.141     0.200
    22.567    34.695     0.200
    22.943    34.301     0.200
    23.083    35.673     0.200
    23.523    33.532     0.200
    23.641    34.152     0.200
    24.867    31.355     0.200
    24.898    31.492     0.200
    25.362    29.777     0.200
    25.471    26.796     0.200
    25.481    29.678     0.200
    26.149    26.888     0.200
    26.620    26.786     0.200
    26.940    26.659     0.200
    26.937    26.091     0.200
    27.051    26.867     0.200
    27.093    26.674     0.200
    27.196    25.671     0.200
    27.485    24.298     0.200
    28.284    22.968     0.200
    28.424    21.334     0.200
    28.443    22.111     0.200
    28.494    23.324     0.200
    28.552    21.849     0.200
    28.614    24.123     0.200
    28.653    23.671     0.200
    28.682    21.829     0.200
    28.765    21.062     0.200
    29.029    19.575     0.200
    29.159    21.757     0.200
    29.383    19.643     0.200
    29.571    21.754     0.200
    14.916    43.732     0.200
    16.881    41.801     0.200
    21.330    37.686     0.200
    21.330    37.787     0.200
    21.308    39.135     0.200
    21.469    37.763     0.200
    24.291    32.725     0.200
    24.435    33.643     0.200
    25.327    30.233     0.200
    14.738    42.969     0.200
    14.934    43.279     0.200
    21.136    39.307     0.200
    21.356    37.833     0.200
    21.356    37.736     0.200
    21.500    37.951     0.200
    24.318    31.965     0.200
    24.468    33.822     0.200
    25.360    30.209     0.200
    18.481    38.893     0.200
    19.777    37.773     0.200
    20.095    39.566     0.200
    20.515    39.158     0.200
    22.467    38.174     0.200
    23.313    35.714     0.200
    24.436    33.404     0.200
    24.808    33.061     0.200
    26.261    30.710     0.200
    27.457    27.541     0.200
    27.567    25.868     0.200
    14.870    44.235     0.200
    16.939    41.489     0.200
    21.115    38.456     0.200
    21.376    37.808     0.200
    21.305    38.138     0.200
    21.498    38.388     0.200
    24.458    33.440     0.200
    25.330    30.560     0.200
    14.926    43.087     0.200
    21.301    38.588     0.200
    21.451    37.832     0.200
    22.319    37.207     0.200
    24.158    34.744     0.200
    24.419    33.292     0.200
    25.318    31.113     0.200
    26.898    27.765     0.200
    18.049    41.324     0.200
    23.965    35.077     0.200
    25.003    32.070     0.200
    15.308    40.968     0.200
    18.703    36.141     0.200
    20.025    38.122     0.200
    20.213    37.329     0.200
    20.335    37.004     0.200
    20.748    35.976     0.200
    20.748    36.679     0.200
    20.695    37.103     0.200
    21.023    36.767     0.200
    23.381    34.257     0.200
    23.632    34.126     0.200
    23.991    32.335     0.200
    24.553    31.570     0.200
    24.589    31.651     0.200
    26.469    27.711     0.200
    26.945    25.666     0.200
    27.666    25.047     0.200
    27.751    23.259     0.200
    14.028    41.023     0.200
    19.224    38.980     0.200
    19.664    39.045     0.200
    20.651    38.727     0.200
    21.438    37.338     0.200
    21.557    37.951     0.200
    21.557    38.272     0.200
    21.784    37.005     0.200
    21.784    37.137     0.200
    21.877    36.919     0.200
    21.877    37.162     0.200
    22.714    36.651     0.200
    22.798    35.675     0.200
    23.134    35.749     0.200
    23.137    35.517     0.200
    23.646    35.774     0.200
    23.773    36.292     0.200
    23.956    35.762     0.200
    24.034    35.456     0.200
    24.039    35.900     0.200
    24.148    33.914     0.200
    24.638    36.204     0.200
    24.745    29.957     0.200
    24.820    32.478     0.200
    25.255    31.998     0.200
    25.347    33.931     0.200
    25.613    29.614     0.200
    25.828    31.917     0.200
    26.094    29.004     0.200
    26.282    30.014     0.200
    26.343    29.305     0.200
    26.482    28.484     0.200
    26.560    28.671     0.200
    26.823    27.702     0.200
    27.089    27.595     0.200
    27.238    26.353     0.200
    27.654    26.005     0.200
    28.018    24.758     0.200
    28.287    24.017     0.200
    28.467    23.309     0.200
    28.566    22.065     0.200
    28.983    22.490     0.200
    29.005    23.233     0.200
    29.199    21.471     0.200
    29.325    21.003     0.200
    29.325    20.753     0.200
    29.333    21.405     0.200
    29.339    21.736     0.200
    29.378    21.284     0.200
    29.824    19.685     0.200
    14.081    42.543     0.200
    21.572    37.719     0.200
    21.855    37.114     0.200
    14.046    38.828     0.200
    14.823    40.464     0.200
    19.253    38.270     0.200
    21.597    36.707     0.200
    21.854    35.217     0.200
    22.867    34.385     0.200
    23.084    34.364     0.200
    24.218    33.124     0.200
    24.880    31.003     0.200
    25.659    28.307     0.200
    26.558    26.821     0.200
    26.826    26.390     0.200
    27.120    25.255     0.200
    28.318    22.679     0.200
    14.858    43.870     0.200
    19.217    39.798     0.200
    19.709    39.354     0.200
    21.405    38.558     0.200
    21.538    38.213     0.200
    21.728    36.696     0.200
    24.779    31.592     0.200
    25.588    29.941     0.200
    26.580    28.376     0.200
    26.580    29.274     0.200
    26.838    28.056     0.200
    27.079    28.046     0.200
    28.549    24.394     0.200
    14.955    44.091     0.200
    20.163    39.112     0.200
    23.175    35.958     0.200
    24.296    33.381     0.200
    26.130    30.483     0.200
    19.035    36.030     0.200
    21.165    35.165     0.200
    21.487    36.515     0.200
    21.324    35.311     0.200
    21.579    35.336     0.200
    21.701    34.910     0.200
    23.294    31.827     0.200
    23.624    31.777     0.200
    24.529    30.916     0.200
    24.348    30.019     0.200
    25.363    27.184     0.200
    26.491    26.009     0.200
    29.526    17.295     0.200
    15.008    43.510     0.200
    18.422    37.569     0.200
    20.008    38.855     0.200
    20.014    38.690     0.200
    20.444    38.772     0.200
    21.968    37.685     0.200
    22.969    36.002     0.200
    23.228    34.977     0.200
    24.220    32.699     0.200
    24.360    31.773     0.200
    24.341    32.993     0.200
    25.004    30.449     0.200
    26.197    29.734     0.200
    26.642    28.538     0.200
    27.053    27.086     0.200
    27.122    29.535     0.200
    27.393    26.368     0.200
    27.496    25.169     0.200
    28.354    23.153     0.200
    29.127    20.638     0.200
    29.416    21.268     0.200
    29.425    21.655     0.200
    21.166    38.833     0.200
    21.533    38.816     0.200
    23.671    35.961     0.200
    18.958    40.101     0.200
    21.036    36.250     0.200
    21.222    38.087     0.200
    21.544    37.528     0.200
    23.677    34.034     0.200
    24.386    34.264     0.200
    25.248    30.396     0.200
    21.476    37.779     0.200
    21.895    38.484     0.200
    23.589    35.221     0.200
    25.526    31.314     0.200
    27.491    26.921     0.200
    14.884    42.425     0.200
    18.894    38.630     0.200
    18.966    37.789     0.200
    20.241    37.504     0.200
    20.771    38.722     0.200
    20.980    37.077     0.200
    21.206    36.703     0.200
    21.206    37.578     0.200
    21.206    36.469     0.200
    21.200    37.217     0.200
    21.339    38.086     0.200
    21.339    36.961     0.200
    21.956    36.796     0.200
    23.330    34.861     0.200
    23.535    33.461     0.200
    23.535    34.242     0.200
    23.789    34.004     0.200
    24.307    33.748     0.200
    24.524    30.924     0.200
    25.212    29.893     0.200
    25.212    29.612     0.200
    26.007    29.616     0.200
    25.960    28.406     0.200
    26.551    27.474     0.200
    26.771    26.704     0.200
    26.806    27.793     0.200
    27.421    26.711     0.200
    27.408    25.421     0.200
    27.408    26.085     0.200
    27.778    24.350     0.200
    27.778    24.600     0.200
    28.004    24.815     0.200
    28.225    23.024     0.200
    28.438    22.448     0.200
    29.520    21.617     0.200
    29.435    20.114     0.200
    29.837    17.417     0.200
    29.791    18.957     0.200
    21.883    38.717     0.200
    14.949    42.785     0.200
    18.933    39.291     0.200
    19.003    38.980     0.200
    20.985    38.344     0.200
    21.223    38.069     0.200
    21.324    38.892     0.200
    21.324    38.994     0.200
    21.883    38.107     0.200
    23.861    34.486     0.200
    24.299    34.668     0.200
    24.597    31.696     0.200
    25.228    31.129     0.200
    26.612    29.581     0.200
    26.828    27.154     0.200
    27.447    26.935     0.200
    28.037    25.046     0.200
    29.861    18.770     0.200
    29.861    18.668     0.200
    14.936    44.154     0.200
    18.914    39.731     0.200
    19.001    39.714     0.200
    20.994    38.964     0.200
    21.226    39.251     0.200
    21.338    39.450     0.200
    24.311    34.747     0.200
    24.579    31.920     0.200
    25.233    31.487     0.200
    26.819    28.480     0.200
    27.453    27.118     0.200
    29.839    19.947     0.200
    29.839    19.611     0.200
    29.839    19.549     0.200
    21.338    38.606     0.200
    21.338    38.606     0.200
    27.453    26.032     0.200
    27.453    25.618     0.200
    27.453    26.118     0.200
    25.233    32.050     0.200
    25.233    31.987     0.200
    21.307    38.094     0.200
    14.796    42.982     0.200
    21.020    37.854     0.200
    25.233    31.190     0.200
    27.358    25.722     0.200
    27.358    25.698     0.200
    23.852    34.806     0.200
    23.852    35.774     0.200
    18.973    40.454     0.200
    21.196    38.515     0.200
    23.835    34.322     0.200
    23.835    34.249     0.200
    14.906    43.521     0.200
    21.259    37.878     0.200
    25.274    30.522     0.200
    14.940    44.172     0.200
    21.410    38.474     0.200
    21.410    37.658     0.200
    21.410    37.939     0.200
    21.358    38.470     0.200
    23.811    34.537     0.200
    29.840    19.778     0.200
    14.935    44.308     0.200
    18.945    37.015     0.200
    18.984    38.557     0.200
    20.967    38.214     0.200
    21.204    37.650     0.200
    21.308    37.939     0.200
    21.368    37.835     0.200
    21.893    36.926     0.200
    23.851    33.055     0.200
    24.282    33.726     0.200
    24.588    31.162     0.200
    25.209    30.708     0.200
    26.596    28.324     0.200
    26.812    27.000     0.200
    26.821    27.104     0.200
    27.442    26.207     0.200
    27.821    24.531     0.200
    28.019    24.923     0.200
    28.277    24.615     0.200
    28.232    23.133     0.200
    29.504    20.285     0.200
    29.860    18.419     0.200
    29.860    18.927     0.200
    29.860    18.333     0.200
    21.368    37.413     0.200
    21.308    37.768     0.200
    21.204    37.470     0.200
    21.204    37.627     0.200
    21.204    37.236     0.200
    27.442    25.019     0.200
    27.442    24.605     0.200
    27.442    25.105     0.200
    25.209    30.887     0.200
    25.209    30.958     0.200
    23.851    34.391     0.200
    23.851    34.539     0.200
    23.851    34.039     0.200
    21.341    39.520     0.200
    18.923    38.125     0.200
    18.972    38.952     0.200
    20.970    37.636     0.200
    21.198    37.866     0.200
    21.320    37.754     0.200
    21.391    38.895     0.200
    23.820    33.080     0.200
    24.291    34.080     0.200
    24.556    31.389     0.200
    25.207    30.789     0.200
    26.572    28.565     0.200
    26.810    27.877     0.200
    26.789    27.321     0.200
    27.797    23.948     0.200
    28.008    24.704     0.200
    28.225    23.565     0.200
    29.471    20.525     0.200
    29.827    19.570     0.200
    29.827    18.570     0.200
    21.391    37.606     0.200
    21.391    37.606     0.200
    21.198    37.764     0.200
    21.198    37.764     0.200
    21.198    37.530     0.200
    25.207    31.211     0.200
    23.820    34.510     0.200
    23.820    34.659     0.200
    20.969    37.729     0.200
    21.197    38.466     0.200
    21.392    38.093     0.200
    23.817    33.721     0.200
    24.291    33.964     0.200
    25.206    30.980     0.200
    26.808    27.982     0.200
    21.392    37.452     0.200
    21.392    37.687     0.200
    21.392    37.726     0.200
    21.197    37.740     0.200
    21.197    37.896     0.200
    21.197    37.552     0.200
    25.206    31.371     0.200
    25.206    31.207     0.200
    25.206    31.207     0.200
    23.817    34.776     0.200
    23.817    34.776     0.200
    23.817    34.776     0.200
    23.817    34.776     0.200
    18.947    37.947     0.200
    18.954    38.866     0.200
    20.946    37.420     0.200
    21.177    37.919     0.200
    21.294    38.748     0.200
    21.367    38.057     0.200
    24.266    33.872     0.200
    24.558    31.463     0.200
    25.184    30.654     0.200
    26.563    29.167     0.200
    26.791    27.802     0.200
    26.779    27.045     0.200
    27.788    25.671     0.200
    21.367    37.369     0.200
    25.184    31.115     0.200
    18.977    39.329     0.200
    20.982    39.334     0.200
    21.207    37.807     0.200
    21.335    38.015     0.200
    21.408    38.267     0.200
    25.217    30.611     0.200
    26.816    26.146     0.200
    21.513    38.868     0.200
    18.997    38.614     0.200
    20.963    37.867     0.200
    21.209    37.893     0.200
    21.294    37.802     0.200
    21.344    37.826     0.200
    23.885    33.669     0.200
    24.622    31.867     0.200
    25.211    30.697     0.200
    26.622    28.326     0.200
    26.831    26.585     0.200
    26.836    27.228     0.200
    27.462    25.995     0.200
    29.540    19.971     0.200
    29.896    18.818     0.200
    21.209    37.182     0.200
    21.209    37.182     0.200
    21.209    37.182     0.200
    27.462    24.593     0.200
    27.462    24.593     0.200
    27.462    25.073     0.200
    23.885    33.970     0.200
    14.916    42.243     0.200
    18.977    39.557     0.200
    20.971    38.286     0.200
    21.202    37.592     0.200
    21.318    38.629     0.200
    21.386    37.588     0.200
    23.829    34.037     0.200
    24.290    33.944     0.200
    25.209    30.424     0.200
    26.580    28.634     0.200
    26.815    28.390     0.200
    26.797    27.496     0.200
    27.805    25.832     0.200
    29.836    18.831     0.200
    29.836    18.550     0.200
    29.836    18.542     0.200
    21.386    37.549     0.200
    27.429    25.210     0.200
    27.429    25.210     0.200
    27.429    25.210     0.200
    27.429    25.210     0.200
    25.209    31.045     0.200
    23.829    35.065     0.200
    23.829    34.592     0.200
    23.843    33.836     0.200
    21.202    37.355     0.200
    21.343    36.954     0.200
    27.453    26.605     0.200
    27.453    25.507     0.200
    21.387    37.576     0.200
    14.802    44.595     0.200
    22.209    37.257     0.200
    22.173    35.283     0.200
    22.768    35.739     0.200
    22.946    35.154     0.200
    26.294    26.683     0.200
    27.782    25.281     0.200
    28.578    21.364     0.200
    24.129    33.140     0.200
    14.825    43.327     0.200
    21.899    36.771     0.200
    22.509    38.304     0.200
    23.414    35.846     0.200
    25.991    28.827     0.200
    23.800    36.105     0.200
    22.584    36.695     0.200
    16.367    41.390     0.200
    21.960    37.913     0.200
    21.967    36.040     0.200
    22.656    35.457     0.200
    23.330    35.255     0.200
    26.070    27.150     0.200
    19.026    39.367     0.200
    21.305    37.069     0.200
    21.651    37.460     0.200
    23.657    34.694     0.200
    25.338    30.999     0.200
    26.115    28.567     0.200
    27.413    27.005     0.200
    15.010    44.328     0.200
    19.776    39.404     0.200
    20.236    40.061     0.200
    20.225    39.434     0.200
    20.847    38.345     0.200
    21.253    38.168     0.200
    24.372    33.770     0.200
    24.341    34.610     0.200
    25.003    31.416     0.200
    26.648    28.519     0.200
    27.128    28.305     0.200
    20.724    38.882     0.200
    20.675    38.273     0.200
    24.127    34.569     0.200
    24.787    31.967     0.200
    25.456    29.945     0.200
    16.865    40.851     0.200
    20.797    37.259     0.200
    22.560    37.132     0.200
    24.157    32.428     0.200
    24.518    32.258     0.200
    27.040    27.489     0.200
    14.999    44.085     0.200
    18.686    38.860     0.200
    20.440    38.797     0.200
    20.641    36.937     0.200
    20.692    38.856     0.200
    20.713    37.742     0.200
    20.792    38.791     0.200
    22.696    35.563     0.200
    23.694    35.825     0.200
    24.246    33.064     0.200
    24.246    33.474     0.200
    24.559    31.920     0.200
    24.745    31.960     0.200
    25.418    30.637     0.200
    26.489    30.801     0.200
    26.576    28.488     0.200
    27.286    26.971     0.200
    27.773    24.824     0.200
    15.837    42.677     0.200
    18.935    38.839     0.200
    20.125    37.199     0.200
    20.125    37.449     0.200
    21.004    37.688     0.200
    21.194    36.479     0.200
    21.329    35.894     0.200
    21.396    36.917     0.200
    21.511    36.875     0.200
    22.647    35.512     0.200
    22.958    35.091     0.200
    23.361    35.390     0.200
    23.414    35.067     0.200
    23.595    33.959     0.200
    23.932    33.250     0.200
    23.932    33.519     0.200
    24.352    33.619     0.200
    25.218    30.009     0.200
    25.732    29.519     0.200
    25.985    28.508     0.200
    26.472    27.978     0.200
    26.699    27.228     0.200
    26.781    27.571     0.200
    27.350    26.058     0.200
    27.584    24.521     0.200
    27.584    25.681     0.200
    27.606    24.550     0.200
    27.606    25.800     0.200
    27.787    23.776     0.200
    27.703    25.112     0.200
    27.951    22.919     0.200
    27.951    24.020     0.200
    29.613    19.662     0.200
    29.670    18.465     0.200
    29.670    17.864     0.200
    29.906    20.308     0.200
    27.350    24.807     0.200
    14.836    42.125     0.200
    20.141    38.789     0.200
    21.257    37.397     0.200
    21.555    37.613     0.200
    22.961    35.474     0.200
    23.364    36.288     0.200
    23.417    36.688     0.200
    23.595    35.904     0.200
    23.595    35.049     0.200
    26.749    26.802     0.200
    27.405    26.447     0.200
    20.562    38.255     0.200
    23.833    34.783     0.200
    23.914    35.592     0.200
    24.122    33.619     0.200
    16.183    42.524     0.200
    20.348    38.513     0.200
    20.796    38.284     0.200
    20.796    38.979     0.200
    23.088    36.653     0.200
    23.481    34.051     0.200
    23.487    35.756     0.200
    23.555    36.149     0.200
    23.765    35.043     0.200
    24.058    34.888     0.200
    24.258    33.173     0.200
    26.130    29.639     0.200
    21.680    36.774     0.200
    21.680    37.243     0.200
    23.288    35.585     0.200
    23.341    34.761     0.200
    23.341    36.546     0.200
    23.673    35.358     0.200
    23.862    34.778     0.200
    23.862    34.418     0.200
    16.265    38.411     0.200
    23.264    33.774     0.200
    23.835    34.365     0.200
    16.537    39.401     0.200
    20.148    39.506     0.200
    20.377    38.735     0.200
    20.435    38.126     0.200
    20.435    37.958     0.200
    20.595    37.945     0.200
    21.720    36.660     0.200
    23.851    35.372     0.200
    23.851    34.399     0.200
    23.905    36.156     0.200
    24.112    32.655     0.200
    24.409    32.744     0.200
    24.451    33.406     0.200
    24.613    33.102     0.200
    24.810    32.401     0.200
    26.255    29.747     0.200
    21.157    37.584     0.200
    21.157    37.401     0.200
    21.157    37.131     0.200
    24.149    34.136     0.200
    24.559    33.076     0.200
    24.816    32.575     0.200
    24.816    31.997     0.200
    25.177    31.689     0.200
    25.083    32.759     0.200
    27.062    28.380     0.200
    20.031    39.018     0.200
    20.410    38.495     0.200
    24.387    33.665     0.200
    24.496    33.000     0.200
    24.496    33.062     0.200
    24.551    32.461     0.200
    24.899    31.851     0.200
    25.053    31.706     0.200
    25.177    29.664     0.200
    26.612    28.808     0.200
    26.728    28.158     0.200
    26.791    28.643     0.200
    27.180    26.985     0.200
    27.779    22.593     0.200
    29.043    21.245     0.200
    23.473    36.930     0.200
    27.295    28.028     0.200
    19.356    40.156     0.200
    19.807    38.905     0.200
    19.807    38.577     0.200
    21.661    38.161     0.200
    21.734    38.209     0.200
    22.135    36.427     0.200
    22.502    36.957     0.200
    22.898    36.833     0.200
    22.898    36.857     0.200
    22.950    36.877     0.200
    23.092    36.960     0.200
    25.066    31.819     0.200
    26.641    29.061     0.200
    26.857    27.326     0.200
    27.200    27.820     0.200
    20.670    37.905     0.200
    20.670    37.756     0.200
    24.022    33.724     0.200
    24.076    32.817     0.200
    24.511    33.948     0.200
    24.586    32.657     0.200
    26.228    27.993     0.200
    26.919    28.888     0.200
    19.040    36.422     0.200
    20.200    35.449     0.200
    21.089    37.010     0.200
    21.292    36.240     0.200
    21.459    34.293     0.200
    23.015    32.651     0.200
    23.418    33.054     0.200
    23.418    33.302     0.200
    23.753    31.610     0.200
    23.767    32.117     0.200
    24.178    32.469     0.200
    24.424    31.893     0.200
    24.496    30.449     0.200
    25.312    28.029     0.200
    25.470    28.604     0.200
    25.470    28.606     0.200
    25.763    27.971     0.200
    26.069    26.431     0.200
    26.577    25.871     0.200
    26.806    24.401     0.200
    26.885    25.969     0.200
    27.058    24.940     0.200
    27.234    23.908     0.200
    27.344    23.086     0.200
    27.458    24.586     0.200
    27.458    23.896     0.200
    27.515    23.246     0.200
    27.719    22.257     0.200
    29.325    18.247     0.200
    29.583    18.092     0.200
    29.710    17.110     0.200
    20.419    37.170     0.200
    20.419    36.155     0.200
    20.361    36.546     0.200
    20.416    37.802     0.200
    23.223    36.647     0.200
    23.434    34.398     0.200
    23.389    34.008     0.200
    23.814    32.831     0.200
    23.845    33.090     0.200
    23.845    33.778     0.200
    23.900    34.046     0.200
    24.109    32.519     0.200
    24.109    32.254     0.200
    24.374    31.714     0.200
    24.464    31.870     0.200
    24.590    31.398     0.200
    24.774    33.549     0.200
    25.073    30.247     0.200
    26.096    26.527     0.200
    26.181    26.848     0.200
    26.368    27.445     0.200
    26.504    28.259     0.200
    26.898    25.468     0.200
    27.153    24.785     0.200
    27.402    24.480     0.200
    20.080    38.737     0.200
    20.416    37.216     0.200
    23.214    34.469     0.200
    23.809    33.818     0.200
    23.809    34.318     0.200
    23.846    34.750     0.200
    23.901    33.651     0.200
    24.109    33.213     0.200
    24.586    31.558     0.200
    25.059    31.179     0.200
    26.186    28.682     0.200
    26.186    28.682     0.200
    26.492    29.030     0.200
    26.886    25.614     0.200
    27.279    26.823     0.200
    18.700    38.456     0.200
    20.334    37.482     0.200
    20.366    38.812     0.200
    20.765    38.259     0.200
    20.808    36.874     0.200
    20.808    37.554     0.200
    23.589    35.603     0.200
    23.769    33.392     0.200
    24.178    33.817     0.200
    24.178    33.216     0.200
    24.232    33.598     0.200
    24.238    34.333     0.200
    24.430    33.384     0.200
    24.697    32.369     0.200
    24.681    32.479     0.200
    24.741    32.261     0.200
    25.006    31.067     0.200
    26.398    28.019     0.200
    26.398    28.019     0.200
    26.822    28.068     0.200
    26.949    28.592     0.200
    27.342    26.906     0.200
    27.858    25.988     0.200
    15.020    41.482     0.200
    18.418    37.329     0.200
    24.239    31.552     0.200
    24.317    31.172     0.200
    24.372    30.846     0.200
    24.581    30.902     0.200
    25.023    28.842     0.200
    26.642    25.826     0.200
    26.642    25.831     0.200
    26.733    27.190     0.200
    29.111    18.539     0.200
    16.889    41.185     0.200
    20.385    37.602     0.200
    24.141    32.855     0.200
    24.195    32.771     0.200
    24.704    32.335     0.200
    26.371    28.248     0.200
    26.371    28.248     0.200
    26.908    28.167     0.200
    27.302    27.261     0.200
    24.562    33.507     0.200
    24.562    33.503     0.200
    27.330    26.677     0.200
    14.880    40.966     0.200
    19.517    38.358     0.200
    19.771    37.875     0.200
    19.771    36.812     0.200
    19.771    37.390     0.200
    21.867    36.632     0.200
    21.919    37.024     0.200
    22.263    35.505     0.200
    22.263    35.076     0.200
    22.350    35.790     0.200
    22.477    35.394     0.200
    22.422    35.278     0.200
    22.816    34.755     0.200
    22.816    35.161     0.200
    22.816    34.825     0.200
    22.867    34.564     0.200
    22.867    35.463     0.200
    22.948    35.317     0.200
    22.948    35.020     0.200
    23.273    33.724     0.200
    23.619    34.181     0.200
    23.643    35.652     0.200
    24.165    32.017     0.200
    24.664    32.490     0.200
    24.664    32.490     0.200
    25.280    32.101     0.200
    26.005    27.846     0.200
    26.386    28.408     0.200
    26.701    26.225     0.200
    26.650    28.467     0.200
    26.663    28.189     0.200
    26.849    27.085     0.200
    26.953    26.385     0.200
    27.110    24.445     0.200
    27.319    25.663     0.200
    27.397    25.098     0.200
    27.925    24.819     0.200
    27.925    23.936     0.200
    28.594    22.625     0.200
    28.645    21.709     0.200
    28.645    24.030     0.200
    28.664    21.509     0.200
    28.991    20.291     0.200
    28.991    20.494     0.200
    19.735    38.928     0.200
    22.754    36.886     0.200
    23.473    35.333     0.200
    24.569    34.436     0.200
    24.569    34.436     0.200
    27.373    27.551     0.200
    16.388    42.402     0.200
    20.139    37.909     0.200
    21.606    38.084     0.200
    23.349    35.249     0.200
    23.727    33.438     0.200
    27.042    27.697     0.200
    20.734    37.935     0.200
    20.704    37.643     0.200
    20.704    36.061     0.200
    24.044    33.873     0.200
    24.174    33.356     0.200
    24.512    34.158     0.200
    26.230    29.528     0.200
    26.230    29.528     0.200
    26.982    28.031     0.200
    20.694    38.586     0.200
    20.656    36.799     0.200
    24.013    33.700     0.200
    24.114    33.928     0.200
    24.510    33.829     0.200
    26.227    28.550     0.200
    26.227    28.550     0.200
    26.894    28.662     0.200
    14.769    42.171     0.200
    18.400    41.397     0.200
    19.910    38.481     0.200
    20.178    37.856     0.200
    20.361    37.614     0.200
    20.361    38.016     0.200
    20.361    38.524     0.200
    20.502    37.566     0.200
    20.502    36.965     0.200
    20.502    37.426     0.200
    20.502    37.199     0.200
    20.474    37.995     0.200
    20.509    38.793     0.200
    20.578    38.917     0.200
    20.578    38.737     0.200
    21.388    40.225     0.200
    21.388    37.932     0.200
    21.624    40.227     0.200
    21.842    38.411     0.200
    21.983    41.022     0.200
    22.110    40.444     0.200
    22.316    39.546     0.200
    22.460    40.450     0.200
    22.842    37.261     0.200
    23.234    34.390     0.200
    23.911    33.472     0.200
    23.922    33.704     0.200
    23.922    33.376     0.200
    23.966    34.546     0.200
    23.966    33.347     0.200
    23.966    34.277     0.200
    23.966    32.984     0.200
    24.497    32.773     0.200
    24.683    30.982     0.200
    25.156    30.776     0.200
    26.214    27.387     0.200
    26.203    27.941     0.200
    26.481    29.093     0.200
    26.617    27.902     0.200
    27.011    29.107     0.200
    27.011    29.791     0.200
    27.131    27.612     0.200
    27.400    26.769     0.200
    28.238    23.723     0.200
    28.521    22.892     0.200
    28.697    22.576     0.200
    28.966    22.689     0.200
    29.954    20.660     0.200
    19.613    40.034     0.200
    22.562    36.531     0.200
    22.740    37.198     0.200
    23.437    36.752     0.200
    27.315    27.556     0.200
    20.247    39.283     0.200
    20.810    38.516     0.200
    24.326    33.907     0.200
    24.290    33.866     0.200
    26.624    28.670     0.200
    26.807    29.504     0.200
    15.139    45.131     0.200
    18.877    38.510     0.200
    20.623    37.339     0.200
    20.623    37.159     0.200
    20.712    37.082     0.200
    20.829    38.522     0.200
    20.829    37.833     0.200
    20.986    38.399     0.200
    23.622    34.572     0.200
    23.622    35.057     0.200
    23.868    35.158     0.200
    24.028    33.889     0.200
    24.028    34.003     0.200
    24.082    34.746     0.200
    24.201    33.577     0.200
    24.201    32.677     0.200
    24.461    33.631     0.200
    24.461    34.006     0.200
    24.937    30.983     0.200
    25.604    30.090     0.200
    26.178    28.813     0.200
    26.178    28.575     0.200
    27.068    26.677     0.200
    20.750    36.643     0.200
    20.839    36.154     0.200
    24.243    32.408     0.200
    24.243    32.437     0.200
    24.254    31.816     0.200
    24.822    31.408     0.200
    26.539    26.919     0.200
    26.811    26.665     0.200
    15.037    42.984     0.200
    18.705    38.480     0.200
    20.103    38.261     0.200
    20.471    37.966     0.200
    20.475    37.922     0.200
    20.596    37.232     0.200
    20.684    37.136     0.200
    20.677    38.460     0.200
    20.685    36.165     0.200
    20.801    38.415     0.200
    20.867    38.340     0.200
    21.168    38.034     0.200
    22.333    37.432     0.200
    22.652    35.411     0.200
    22.824    40.105     0.200
    23.016    38.470     0.200
    23.364    35.707     0.200
    23.503    37.279     0.200
    24.040    33.615     0.200
    24.094    33.184     0.200
    24.144    32.850     0.200
    24.144    33.409     0.200
    24.532    32.697     0.200
    24.749    31.839     0.200
    24.894    31.548     0.200
    26.249    28.637     0.200
    26.505    27.749     0.200
    26.610    28.328     0.200
    26.774    26.406     0.200
    26.919    27.897     0.200
    27.805    25.577     0.200
    20.266    36.636     0.200
    20.266    36.914     0.200
    20.359    37.869     0.200
    20.359    37.330     0.200
    22.141    36.277     0.200
    23.405    34.411     0.200
    23.456    34.457     0.200
    23.484    35.744     0.200
    23.484    34.967     0.200
    24.060    32.135     0.200
    25.199    30.470     0.200
    25.199    30.587     0.200
    27.702    25.107     0.200
    16.076    42.605     0.200
    16.185    39.921     0.200
    19.388    37.093     0.200
    19.483    38.214     0.200
    19.657    38.683     0.200
    20.433    38.422     0.200
    20.697    38.021     0.200
    20.976    36.979     0.200
    21.691    37.487     0.200
    22.139    35.221     0.200
    22.174    36.507     0.200
    22.457    34.411     0.200
    22.457    34.925     0.200
    22.507    34.822     0.200
    22.507    35.122     0.200
    22.518    34.798     0.200
    22.518    35.446     0.200
    22.734    35.977     0.200
    22.917    34.235     0.200
    22.952    34.423     0.200
    23.260    34.484     0.200
    23.260    33.656     0.200
    23.260    34.933     0.200
    24.234    32.398     0.200
    25.637    28.396     0.200
    26.204    30.948     0.200
    26.260    26.129     0.200
    26.923    24.786     0.200
    27.345    25.757     0.200
    28.588    21.156     0.200
    28.588    20.906     0.200
    28.748    20.786     0.200
    17.803    41.557     0.200
    18.553    37.319     0.200
    18.686    37.492     0.200
    18.742    38.707     0.200
    18.772    38.668     0.200
    20.108    37.774     0.200
    20.111    37.628     0.200
    20.153    37.546     0.200
    20.320    37.535     0.200
    20.320    37.542     0.200
    20.320    37.394     0.200
    20.339    37.768     0.200
    20.355    36.829     0.200
    20.582    37.235     0.200
    20.792    36.134     0.200
    20.881    36.449     0.200
    20.881    36.254     0.200
    21.468    36.400     0.200
    21.970    36.041     0.200
    22.403    36.309     0.200
    22.465    39.667     0.200
    22.467    36.659     0.200
    23.000    35.311     0.200
    23.143    36.542     0.200
    23.361    34.996     0.200
    23.460    33.046     0.200
    24.152    33.976     0.200
    24.285    31.370     0.200
    24.285    31.870     0.200
    24.285    32.019     0.200
    24.290    31.821     0.200
    24.294    32.102     0.200
    24.348    31.982     0.200
    24.348    32.787     0.200
    24.348    32.162     0.200
    24.499    31.717     0.200
    24.515    33.186     0.200
    24.781    33.429     0.200
    24.779    32.537     0.200
    24.854    31.527     0.200
    25.050    29.192     0.200
    25.070    30.467     0.200
    25.128    30.656     0.200
    25.345    32.945     0.200
    25.327    30.869     0.200
    25.366    29.948     0.200
    26.572    26.940     0.200
    26.610    27.889     0.200
    26.748    27.184     0.200
    26.847    27.416     0.200
    26.847    27.416     0.200
    26.858    27.364     0.200
    27.215    25.627     0.200
    27.528    24.877     0.200
    27.790    24.461     0.200
    28.166    22.602     0.200
    28.405    22.842     0.200
    28.789    20.661     0.200
    29.266    20.690     0.200
    15.104    43.645     0.200
    16.983    41.219     0.200
    16.983    41.400     0.200
    18.573    39.467     0.200
    19.556    40.193     0.200
    20.120    38.707     0.200
    20.124    39.163     0.200
    20.150    39.203     0.200
    20.172    38.798     0.200
    20.333    38.877     0.200
    20.333    39.028     0.200
    20.357    39.248     0.200
    20.799    37.556     0.200
    20.887    37.052     0.200
    21.983    38.673     0.200
    22.551    39.540     0.200
    22.795    37.436     0.200
    23.013    36.452     0.200
    23.153    37.909     0.200
    23.475    38.060     0.200
    23.512    36.353     0.200
    24.136    36.245     0.200
    24.190    35.012     0.200
    24.297    32.954     0.200
    24.295    33.231     0.200
    24.351    34.532     0.200
    24.351    35.231     0.200
    24.522    35.034     0.200
    24.520    32.463     0.200
    24.558    34.122     0.200
    24.765    34.649     0.200
    24.851    32.798     0.200
    24.851    32.888     0.200
    25.060    30.762     0.200
    25.083    31.886     0.200
    25.350    30.888     0.200
    25.356    34.009     0.200
    26.044    29.679     0.200
    26.568    27.909     0.200
    26.568    28.058     0.200
    26.765    28.366     0.200
    26.865    28.592     0.200
    27.548    26.026     0.200
    27.806    27.209     0.200
    28.412    24.039     0.200
    18.554    34.402     0.200
    19.533    36.483     0.200
    20.098    35.891     0.200
    20.098    35.290     0.200
    20.098    36.259     0.200
    20.101    35.847     0.200
    20.149    35.897     0.200
    20.173    36.183     0.200
    20.310    35.786     0.200
    20.310    36.012     0.200
    20.332    36.257     0.200
    20.581    35.941     0.200
    20.794    35.860     0.200
    20.803    33.930     0.200
    20.891    34.628     0.200
    21.960    34.353     0.200
    22.262    35.590     0.200
    22.322    37.865     0.200
    22.456    35.313     0.200
    22.454    35.497     0.200
    22.529    34.612     0.200
    22.771    34.236     0.200
    22.990    33.633     0.200
    22.986    35.230     0.200
    23.193    33.925     0.200
    23.355    31.371     0.200
    23.468    35.253     0.200
    23.749    33.561     0.200
    23.753    33.018     0.200
    23.946    33.089     0.200
    23.951    34.144     0.200
    24.295    29.647     0.200
    24.295    29.983     0.200
    24.295    30.202     0.200
    24.305    29.952     0.200
    24.360    30.253     0.200
    24.360    30.050     0.200
    24.360    29.519     0.200
    24.535    30.905     0.200
    24.497    29.150     0.200
    24.524    30.815     0.200
    24.789    31.544     0.200
    25.060    28.876     0.200
    25.061    28.169     0.200
    25.124    28.360     0.200
    25.335    30.275     0.200
    25.374    28.487     0.200
    26.067    27.171     0.200
    26.222    27.464     0.200
    26.332    26.038     0.200
    26.584    25.098     0.200
    26.617    26.214     0.200
    26.753    25.017     0.200
    26.851    25.820     0.200
    26.970    25.488     0.200
    27.556    23.955     0.200
    27.528    23.369     0.200
    27.605    22.276     0.200
    27.741    23.196     0.200
    27.796    23.017     0.200
    27.796    22.751     0.200
    27.796    22.556     0.200
    28.252    21.585     0.200
    28.463    20.872     0.200
    29.262    18.039     0.200
    29.888    17.220     0.200
    19.428    39.738     0.200
    20.514    37.998     0.200
    20.604    38.034     0.200
    21.055    36.280     0.200
    22.734    35.784     0.200
    23.881    34.414     0.200
    24.126    34.063     0.200
    25.983    30.083     0.200
    25.983    29.614     0.200
    27.127    28.083     0.200
    18.851    39.285     0.200
    21.633    37.091     0.200
    23.354    35.415     0.200
    27.079    27.881     0.200
    15.159    42.188     0.200
    18.425    37.270     0.200
    19.643    36.664     0.200
    19.765    38.735     0.200
    19.765    37.864     0.200
    19.893    38.441     0.200
    20.012    37.242     0.200
    20.025    39.097     0.200
    20.091    37.834     0.200
    20.389    38.153     0.200
    20.713    37.287     0.200
    20.991    36.828     0.200
    21.132    39.378     0.200
    21.078    37.110     0.200
    21.127    37.446     0.200
    21.628    37.701     0.200
    21.860    37.889     0.200
    21.949    37.739     0.200
    21.949    37.634     0.200
    22.124    37.108     0.200
    22.285    36.095     0.200
    22.285    37.509     0.200
    22.285    36.412     0.200
    22.308    37.397     0.200
    22.310    39.333     0.200
    22.407    38.389     0.200
    22.515    39.017     0.200
    22.658    36.776     0.200
    22.765    38.343     0.200
    22.803    35.988     0.200
    22.898    38.303     0.200
    23.064    33.933     0.200
    23.163    38.198     0.200
    23.460    34.017     0.200
    23.835    35.037     0.200
    24.130    32.694     0.200
    24.203    34.247     0.200
    24.275    32.105     0.200
    24.434    32.040     0.200
    24.434    32.251     0.200
    24.543    31.373     0.200
    24.543    32.385     0.200
    24.598    32.232     0.200
    24.598    31.470     0.200
    24.598    32.364     0.200
    24.729    31.405     0.200
    24.810    29.559     0.200
    24.866    31.608     0.200
    25.129    30.439     0.200
    25.099    30.282     0.200
    25.165    31.019     0.200
    25.165    31.632     0.200
    25.212    29.869     0.200
    26.147    29.362     0.200
    26.181    29.664     0.200
    26.650    28.481     0.200
    26.627    28.261     0.200
    26.738    27.058     0.200
    26.794    27.963     0.200
    26.806    27.062     0.200
    26.882    26.683     0.200
    27.115    26.688     0.200
    27.240    27.401     0.200
    27.183    26.370     0.200
    27.183    26.855     0.200
    27.377    26.007     0.200
    27.474    26.471     0.200
    27.447    25.786     0.200
    27.696    23.384     0.200
    27.791    24.677     0.200
    27.933    24.845     0.200
    28.074    24.171     0.200
    28.460    22.267     0.200
    28.460    22.270     0.200
    28.724    22.381     0.200
    29.011    21.137     0.200
    29.157    21.225     0.200
    29.850    16.338     0.200
    14.689    44.013     0.200
    18.958    38.171     0.200
    19.928    39.425     0.200
    20.346    38.299     0.200
    20.353    38.069     0.200
    20.564    38.600     0.200
    20.441    37.236     0.200
    20.441    37.087     0.200
    21.040    41.405     0.200
    21.683    38.090     0.200
    21.688    38.336     0.200
    21.684    41.068     0.200
    22.207    38.785     0.200
    22.173    40.984     0.200
    22.662    39.700     0.200
    22.885    39.460     0.200
    23.435    37.453     0.200
    23.451    34.598     0.200
    23.852    34.208     0.200
    23.852    34.083     0.200
    23.863    33.769     0.200
    23.863    34.566     0.200
    23.918    35.115     0.200
    23.918    34.389     0.200
    24.424    34.104     0.200
    24.398    32.808     0.200
    24.473    33.801     0.200
    24.473    33.020     0.200
    24.614    31.782     0.200
    24.984    33.878     0.200
    25.094    31.390     0.200
    25.676    30.695     0.200
    26.123    28.782     0.200
    26.191    28.716     0.200
    26.397    27.881     0.200
    26.533    29.352     0.200
    26.927    27.897     0.200
    26.927    27.389     0.200
    19.566    37.836     0.200
    22.684    36.973     0.200
    24.515    33.032     0.200
    14.813    41.358     0.200
    18.946    38.815     0.200
    20.053    37.953     0.200
    20.053    38.914     0.200
    20.144    37.940     0.200
    20.144    37.690     0.200
    21.008    38.056     0.200
    21.188    38.427     0.200
    21.202    38.795     0.200
    21.288    38.886     0.200
    21.288    37.086     0.200
    21.394    38.647     0.200
    21.503    38.032     0.200
    21.537    37.319     0.200
    21.984    40.368     0.200
    23.150    36.858     0.200
    23.201    35.337     0.200
    23.201    37.968     0.200
    23.201    36.497     0.200
    23.379    35.460     0.200
    23.379    34.723     0.200
    23.713    34.124     0.200
    23.713    33.893     0.200
    23.717    33.844     0.200
    23.745    35.169     0.200
    23.745    35.040     0.200
    23.831    36.714     0.200
    24.185    34.785     0.200
    24.353    33.525     0.200
    24.432    31.901     0.200
    25.225    30.644     0.200
    25.462    30.004     0.200
    25.462    30.301     0.200
    25.988    29.495     0.200
    26.716    27.050     0.200
    26.965    27.859     0.200
    26.965    27.859     0.200
    26.976    27.723     0.200
    27.365    26.868     0.200
    27.365    24.378     0.200
    27.990    24.579     0.200
    29.686    19.410     0.200
    29.686    19.180     0.200
    20.866    38.530     0.200
    14.835    41.870     0.200
    19.089    39.876     0.200
    19.484    39.328     0.200
    19.473    38.276     0.200
    19.633    38.411     0.200
    19.726    37.294     0.200
    19.726    39.364     0.200
    20.382    38.927     0.200
    21.851    37.401     0.200
    21.893    38.009     0.200
    22.274    36.261     0.200
    22.274    35.558     0.200
    22.274    36.980     0.200
    22.278    36.217     0.200
    22.346    36.723     0.200
    22.488    36.627     0.200
    22.488    36.565     0.200
    22.522    36.319     0.200
    22.775    36.218     0.200
    22.826    36.723     0.200
    22.826    35.723     0.200
    22.826    37.090     0.200
    22.970    36.536     0.200
    22.916    36.226     0.200
    22.916    35.969     0.200
    23.174    36.956     0.200
    23.440    35.053     0.200
    23.444    34.506     0.200
    23.444    34.756     0.200
    23.444    34.905     0.200
    23.448    34.708     0.200
    23.628    33.959     0.200
    23.686    36.283     0.200
    24.120    34.025     0.200
    24.632    33.743     0.200
    24.632    33.095     0.200
    24.705    32.594     0.200
    25.271    31.986     0.200
    25.300    31.755     0.200
    25.330    30.394     0.200
    26.346    28.644     0.200
    26.611    28.246     0.200
    26.831    27.910     0.200
    26.910    27.060     0.200
    26.977    26.081     0.200
    26.982    25.417     0.200
    27.279    27.591     0.200
    27.279    27.591     0.200
    27.290    26.748     0.200
    27.497    24.608     0.200
    27.522    24.516     0.200
    27.686    24.903     0.200
    27.686    25.724     0.200
    27.882    24.914     0.200
    27.882    25.016     0.200
    27.931    23.449     0.200
    28.562    24.074     0.200
    28.627    23.130     0.200
    28.634    23.008     0.200
    28.634    22.539     0.200
    28.954    21.890     0.200
    28.954    22.101     0.200
    28.954    21.164     0.200
    29.716    20.610     0.200
    29.750    19.434     0.200
    29.984    20.380     0.200
    15.013    42.039     0.200
    16.931    38.842     0.200
    19.999    37.796     0.200
    20.009    36.239     0.200
    20.213    37.208     0.200
    20.247    37.896     0.200
    20.271    37.516     0.200
    20.772    36.237     0.200
    20.859    36.083     0.200
    21.328    37.148     0.200
    22.096    37.187     0.200
    22.894    35.155     0.200
    22.894    36.665     0.200
    23.222    34.744     0.200
    24.071    34.132     0.200
    24.241    31.531     0.200
    24.241    31.877     0.200
    24.241    31.582     0.200
    24.302    31.344     0.200
    24.302    32.047     0.200
    24.356    31.966     0.200
    24.356    31.406     0.200
    24.435    33.087     0.200
    24.907    31.181     0.200
    24.907    31.251     0.200
    26.624    26.718     0.200
    26.733    27.392     0.200
    26.744    26.942     0.200
    27.123    23.714     0.200
    27.691    24.193     0.200
    14.855    42.472     0.200
    17.932    41.157     0.200
    19.162    37.876     0.200
    19.707    37.571     0.200
    19.800    37.618     0.200
    19.800    36.489     0.200
    19.800    37.458     0.200
    19.980    38.252     0.200
    21.823    35.850     0.200
    22.149    35.559     0.200
    22.149    36.848     0.200
    22.153    36.804     0.200
    22.362    35.377     0.200
    22.362    36.107     0.200
    22.397    35.245     0.200
    22.921    34.604     0.200
    22.921    35.335     0.200
    23.034    34.791     0.200
    23.504    33.736     0.200
    23.501    33.399     0.200
    23.501    33.872     0.200
    23.501    33.399     0.200
    23.505    33.823     0.200
    23.602    33.959     0.200
    23.602    33.791     0.200
    24.181    32.227     0.200
    24.578    33.397     0.200
    25.043    29.993     0.200
    25.043    31.376     0.200
    25.165    31.154     0.200
    25.902    28.043     0.200
    27.262    26.176     0.200
    27.262    26.176     0.200
    27.273    23.842     0.200
    27.668    22.374     0.200
    27.668    23.835     0.200
    29.063    19.459     0.200
    14.854    41.950     0.200
    19.650    37.149     0.200
    19.650    37.607     0.200
    19.744    35.736     0.200
    19.744    36.509     0.200
    19.744    37.216     0.200
    19.744    37.388     0.200
    20.371    37.424     0.200
    21.860    35.695     0.200
    21.906    36.459     0.200
    22.272    34.795     0.200
    22.272    35.577     0.200
    22.276    35.431     0.200
    22.350    34.970     0.200
    22.350    35.451     0.200
    22.486    34.625     0.200
    22.486    35.336     0.200
    22.520    34.556     0.200
    22.664    36.905     0.200
    22.790    34.965     0.200
    22.790    35.234     0.200
    22.790    35.047     0.200
    22.841    33.656     0.200
    22.841    35.336     0.200
    22.841    35.438     0.200
    22.927    34.782     0.200
    22.927    34.438     0.200
    22.927    33.829     0.200
    23.463    32.887     0.200
    23.463    32.887     0.200
    23.463    34.087     0.200
    23.627    32.765     0.200
    24.138    32.112     0.200
    24.135    33.346     0.200
    24.320    31.780     0.200
    24.643    31.006     0.200
    24.643    31.932     0.200
    25.166    28.605     0.200
    25.166    30.202     0.200
    25.277    31.013     0.200
    25.993    26.954     0.200
    25.993    27.102     0.200
    26.840    25.059     0.200
    26.928    24.845     0.200
    27.296    25.747     0.200
    27.296    25.747     0.200
    27.307    23.554     0.200
    28.968    20.044     0.200
    21.874    36.083     0.200
    23.187    33.825     0.200
    23.656    32.868     0.200
    25.173    30.437     0.200
    20.033    39.732     0.200
    21.611    38.109     0.200
    23.335    36.232     0.200
    23.712    33.658     0.200
    25.385    31.142     0.200
    19.645    37.671     0.200
    20.377    38.355     0.200
    23.935    35.305     0.200
    26.037    29.844     0.200
    26.794    29.792     0.200
    20.296    38.803     0.200
    20.384    37.476     0.200
    23.232    35.550     0.200
    23.785    33.646     0.200
    23.785    35.224     0.200
    23.819    35.320     0.200
    26.450    30.454     0.200
    18.925    39.011     0.200
    19.191    39.262     0.200
    19.191    39.043     0.200
    19.905    39.594     0.200
    20.013    37.318     0.200
    20.232    38.406     0.200
    20.239    37.757     0.200
    20.323    37.403     0.200
    20.714    37.241     0.200
    20.890    38.583     0.200
    21.079    37.270     0.200
    21.079    36.976     0.200
    21.083    36.929     0.200
    21.102    37.707     0.200
    21.135    39.220     0.200
    21.214    37.405     0.200
    21.227    38.348     0.200
    21.227    37.450     0.200
    21.282    39.608     0.200
    21.288    39.189     0.200
    21.293    39.358     0.200
    21.293    37.459     0.200
    21.293    38.732     0.200
    21.300    38.511     0.200
    21.310    39.435     0.200
    21.320    37.170     0.200
    21.328    39.065     0.200
    21.337    38.918     0.200
    21.355    38.757     0.200
    21.371    37.568     0.200
    21.776    38.527     0.200
    22.332    36.748     0.200
    22.407    37.483     0.200
    22.436    37.146     0.200
    22.793    37.041     0.200
    22.941    37.243     0.200
    23.017    37.050     0.200
    23.017    35.753     0.200
    23.175    37.514     0.200
    23.513    37.171     0.200
    23.583    35.644     0.200
    23.636    35.032     0.200
    23.636    34.860     0.200
    23.715    34.733     0.200
    23.867    33.688     0.200
    23.867    34.696     0.200
    23.969    34.288     0.200
    24.114    35.087     0.200
    24.202    34.527     0.200
    24.764    32.897     0.200
    25.136    31.629     0.200
    25.136    31.527     0.200
    25.151    32.320     0.200
    25.480    33.831     0.200
    25.516    32.200     0.200
    25.686    30.834     0.200
    26.524    28.436     0.200
    26.777    27.583     0.200
    26.999    28.739     0.200
    27.397    26.344     0.200
    27.397    26.094     0.200
    27.788    23.782     0.200
    27.957    25.215     0.200
    28.184    22.466     0.200
    28.177    23.543     0.200
    28.691    22.436     0.200
    28.718    22.434     0.200
    29.011    21.704     0.200
    29.021    21.587     0.200
    29.124    21.191     0.200
    29.545    20.281     0.200
    29.649    18.766     0.200
    29.719    17.154     0.200
    29.747    17.463     0.200
    29.830    20.179     0.200
    29.830    17.960     0.200
    29.904    19.382     0.200
    29.904    18.945     0.200
    29.988    19.409     0.200
    20.091    38.731     0.200
    20.183    37.702     0.200
    21.408    37.104     0.200
    21.621    36.086     0.200
    23.383    35.695     0.200
    23.435    35.847     0.200
    23.695    35.327     0.200
    23.695    35.186     0.200
    23.777    35.526     0.200
    23.777    35.088     0.200
    25.412    31.281     0.200
    27.103    27.582     0.200
    27.103    26.981     0.200
    20.531    38.501     0.200
    20.829    38.706     0.200
    24.101    34.065     0.200
    26.127    29.347     0.200
    26.963    28.047     0.200
    14.966    42.018     0.200
    16.070    37.533     0.200
    16.870    38.195     0.200
    17.784    39.840     0.200
    18.417    35.436     0.200
    18.994    37.807     0.200
    19.322    34.583     0.200
    19.828    38.195     0.200
    20.042    36.281     0.200
    20.069    35.087     0.200
    20.201    36.527     0.200
    20.256    36.876     0.200
    20.284    37.306     0.200
    20.284    36.806     0.200
    20.379    36.464     0.200
    20.404    37.351     0.200
    20.455    36.463     0.200
    20.683    36.491     0.200
    20.702    36.047     0.200
    20.702    35.473     0.200
    20.790    36.300     0.200
    20.790    35.847     0.200
    20.870    36.758     0.200
    21.235    35.237     0.200
    21.246    39.457     0.200
    21.452    34.115     0.200
    21.484    37.999     0.200
    21.776    37.583     0.200
    21.878    38.263     0.200
    22.056    35.926     0.200
    22.148    36.432     0.200
    22.148    37.471     0.200
    22.216    37.214     0.200
    22.357    36.883     0.200
    22.432    38.502     0.200
    22.562    34.540     0.200
    22.562    34.411     0.200
    22.562    35.107     0.200
    22.671    35.285     0.200
    22.738    36.989     0.200
    22.831    37.070     0.200
    23.080    33.517     0.200
    23.268    33.236     0.200
    23.319    34.706     0.200
    23.751    34.391     0.200
    23.828    35.455     0.200
    24.179    31.738     0.200
    24.179    31.773     0.200
    24.226    30.753     0.200
    24.226    31.651     0.200
    24.281    30.845     0.200
    24.281    32.427     0.200
    24.281    31.915     0.200
    24.687    32.869     0.200
    24.827    30.735     0.200
    24.827    29.364     0.200
    25.018    29.401     0.200
    25.018    30.409     0.200
    26.197    26.944     0.200
    26.479    27.064     0.200
    26.521    27.620     0.200
    26.544    25.797     0.200
    26.614    26.285     0.200
    26.710    26.457     0.200
    27.102    23.821     0.200
    27.102    26.110     0.200
    27.102    24.794     0.200
    27.325    24.786     0.200
    27.394    24.579     0.200
    27.754    23.886     0.200
    27.847    24.165     0.200
    28.320    20.478     0.200
    28.850    19.492     0.200
    29.154    19.346     0.200
    29.272    19.260     0.200
    29.373    16.487     0.200
    19.627    38.081     0.200
    22.631    36.143     0.200
    22.734    36.433     0.200
    23.465    35.762     0.200
    24.542    33.856     0.200
    27.384    26.053     0.200
    14.278    41.449     0.200
    14.875    43.584     0.200
    16.686    40.721     0.200
    18.049    40.742     0.200
    18.801    38.362     0.200
    18.801    38.069     0.200
    19.098    38.703     0.200
    19.975    38.942     0.200
    20.028    37.847     0.200
    20.113    38.364     0.200
    20.120    36.778     0.200
    20.303    38.740     0.200
    20.798    38.718     0.200
    21.000    37.825     0.200
    21.019    38.343     0.200
    21.019    39.301     0.200
    21.038    40.467     0.200
    21.103    40.142     0.200
    21.103    40.755     0.200
    21.216    40.480     0.200
    21.216    41.206     0.200
    21.199    37.191     0.200
    21.252    40.064     0.200
    21.265    39.199     0.200
    21.265    39.511     0.200
    21.375    38.229     0.200
    21.446    39.427     0.200
    21.446    40.130     0.200
    21.469    36.327     0.200
    21.590    39.128     0.200
    21.590    40.081     0.200
    21.590    37.226     0.200
    21.682    36.956     0.200
    21.682    36.413     0.200
    21.682    36.335     0.200
    21.682    36.108     0.200
    21.682    36.546     0.200
    21.709    39.075     0.200
    21.709    40.161     0.200
    21.778    36.557     0.200
    21.856    39.933     0.200
    21.856    40.062     0.200
    22.149    38.743     0.200
    22.170    37.825     0.200
    22.170    39.040     0.200
    22.635    35.168     0.200
    22.690    37.053     0.200
    22.690    38.162     0.200
    23.234    36.010     0.200
    23.314    35.029     0.200
    23.366    34.904     0.200
    23.366    35.092     0.200
    23.623    34.359     0.200
    23.720    33.194     0.200
    23.720    34.061     0.200
    24.039    33.821     0.200
    24.039    35.872     0.200
    24.548    32.603     0.200
    25.151    29.965     0.200
    25.194    32.586     0.200
    25.340    30.985     0.200
    25.414    32.767     0.200
    25.407    30.484     0.200
    25.526    30.520     0.200
    25.565    31.624     0.200
    26.076    29.576     0.200
    26.118    30.490     0.200
    26.135    29.082     0.200
    26.179    29.070     0.200
    26.229    29.720     0.200
    26.572    28.080     0.200
    26.812    26.985     0.200
    26.917    27.839     0.200
    26.950    26.876     0.200
    27.082    27.757     0.200
    27.082    27.534     0.200
    27.456    25.765     0.200
    27.483    26.219     0.200
    27.483    26.348     0.200
    27.787    24.499     0.200
    28.147    24.699     0.200
    28.302    23.594     0.200
    28.328    23.391     0.200
    28.335    23.714     0.200
    28.394    22.719     0.200
    28.469    22.646     0.200
    28.654    21.688     0.200
    28.735    22.237     0.200
    29.242    20.829     0.200
    29.260    20.211     0.200
    29.440    21.282     0.200
    29.440    21.063     0.200
    29.440    21.684     0.200
    29.440    21.423     0.200
    29.591    19.622     0.200
    29.591    19.294     0.200
    29.591    19.954     0.200
    21.661    37.294     0.200
    23.291    36.322     0.200
    14.824    43.835     0.200
    17.452    40.760     0.200
    18.816    39.510     0.200
    18.816    38.197     0.200
    18.816    39.990     0.200
    18.894    39.904     0.200
    19.045    39.578     0.200
    19.686    38.695     0.200
    19.694    39.790     0.200
    19.945    39.199     0.200
    19.990    38.826     0.200
    20.081    38.606     0.200
    20.081    38.778     0.200
    20.269    39.388     0.200
    21.044    41.293     0.200
    21.065    40.054     0.200
    21.086    40.864     0.200
    21.156    38.544     0.200
    21.261    40.354     0.200
    21.302    40.600     0.200
    21.395    41.032     0.200
    21.325    38.961     0.200
    21.490    40.633     0.200
    21.454    37.413     0.200
    21.454    38.265     0.200
    21.454    37.999     0.200
    21.558    38.150     0.200
    21.634    40.889     0.200
    21.668    38.405     0.200
    21.668    38.264     0.200
    21.668    36.342     0.200
    21.755    40.203     0.200
    21.758    37.069     0.200
    21.901    40.772     0.200
    22.200    38.833     0.200
    23.270    35.937     0.200
    23.270    36.367     0.200
    23.285    35.896     0.200
    23.285    35.588     0.200
    23.337    35.442     0.200
    23.337    36.001     0.200
    23.337    35.681     0.200
    23.611    35.593     0.200
    23.611    35.132     0.200
    23.676    34.457     0.200
    23.676    34.156     0.200
    23.676    34.726     0.200
    23.676    34.305     0.200
    24.069    34.159     0.200
    24.493    35.692     0.200
    24.512    33.779     0.200
    25.132    32.937     0.200
    25.235    32.612     0.200
    25.328    31.453     0.200
    25.375    32.287     0.200
    25.359    31.288     0.200
    25.567    32.214     0.200
    25.705    31.163     0.200
    26.065    32.050     0.200
    26.152    31.132     0.200
    26.136    30.423     0.200
    26.280    30.231     0.200
    26.519    29.453     0.200
    26.758    27.066     0.200
    26.968    28.227     0.200
    26.897    27.845     0.200
    27.027    27.404     0.200
    27.027    27.244     0.200
    27.429    25.437     0.200
    27.429    27.140     0.200
    27.796    26.053     0.200
    27.800    25.704     0.200
    28.314    24.306     0.200
    28.342    24.576     0.200
    28.286    24.424     0.200
    28.343    24.964     0.200
    28.752    23.989     0.200
    29.219    21.947     0.200
    29.455    21.385     0.200
    29.484    17.556     0.200
    29.570    20.087     0.200
    29.570    20.447     0.200
    20.043    38.103     0.200
    21.648    37.501     0.200
    23.335    35.371     0.200
    23.730    33.966     0.200
    26.929    27.182     0.200
    27.071    26.643     0.200
    19.811    37.076     0.200
    19.904    36.713     0.200
    19.904    37.630     0.200
    20.598    36.670     0.200
    21.553    36.419     0.200
    22.025    35.411     0.200
    23.044    34.878     0.200
    23.096    34.720     0.200
    23.096    35.579     0.200
    23.296    34.911     0.200
    23.296    35.149     0.200
    23.551    33.491     0.200
    23.551    33.839     0.200
    23.551    33.534     0.200
    25.613    29.440     0.200
    27.112    25.668     0.200
    19.733    39.313     0.200
    22.432    38.004     0.200
    22.875    36.289     0.200
    23.006    35.979     0.200
    23.006    35.388     0.200
    23.542    34.754     0.200
    23.542    35.489     0.200
    20.106    38.286     0.200
    21.600    35.948     0.200
    23.400    34.615     0.200
    23.789    33.338     0.200
    25.432    30.176     0.200
    20.266    38.051     0.200
    23.622    34.968     0.200
    23.896    32.975     0.200
    20.354    37.420     0.200
    20.567    38.183     0.200
    20.567    37.683     0.200
    20.630    37.632     0.200
    20.704    38.300     0.200
    20.719    37.231     0.200
    20.719    36.152     0.200
    22.621    36.972     0.200
    22.621    35.821     0.200
    23.012    35.307     0.200
    23.797    34.618     0.200
    24.097    33.900     0.200
    24.158    32.204     0.200
    24.158    33.319     0.200
    24.620    32.111     0.200
    24.620    31.861     0.200
    26.419    26.300     0.200
    26.862    29.188     0.200
    27.256    25.428     0.200
    20.079    37.436     0.200
    21.448    37.702     0.200
    23.414    34.805     0.200
    23.730    33.779     0.200
    25.509    29.717     0.200
    15.133    44.438     0.200
    16.860    40.393     0.200
    17.271    43.891     0.200
    18.857    39.075     0.200
    20.614    39.473     0.200
    20.622    37.956     0.200
    20.622    38.773     0.200
    20.607    38.757     0.200
    20.607    39.257     0.200
    20.607    38.967     0.200
    20.712    37.956     0.200
    20.712    37.727     0.200
    20.712    38.626     0.200
    20.833    39.873     0.200
    20.842    39.410     0.200
    20.818    38.394     0.200
    23.855    35.447     0.200
    24.030    34.387     0.200
    24.030    35.258     0.200
    24.065    34.072     0.200
    24.198    34.324     0.200
    24.467    34.915     0.200
    24.925    32.069     0.200
    25.591    31.618     0.200
    26.184    29.281     0.200
    27.059    28.457     0.200
    27.454    27.456     0.200
    27.454    27.816     0.200
    27.867    25.228     0.200
    29.789    20.803     0.200
    20.868    39.410     0.200
    24.200    34.617     0.200
    16.964    41.557     0.200
    20.781    38.595     0.200
    24.277    33.999     0.200
    20.613    39.119     0.200
    20.736    40.656     0.200
    24.173    34.129     0.200
    26.228    29.369     0.200
    26.982    29.349     0.200
    19.861    37.261     0.200
    23.079    34.941     0.200
    23.610    34.272     0.200
    19.953    37.010     0.200
    20.048    36.743     0.200
    22.597    34.974     0.200
    23.032    32.645     0.200
    23.032    32.645     0.200
    23.807    32.968     0.200
    27.711    23.166     0.200
    18.507    38.650     0.200
    18.638    38.720     0.200
    20.129    38.308     0.200
    20.177    38.441     0.200
    20.220    37.382     0.200
    20.211    39.343     0.200
    21.103    36.443     0.200
    21.173    38.552     0.200
    21.326    36.389     0.200
    21.326    36.749     0.200
    21.465    38.218     0.200
    21.539    37.052     0.200
    21.539    36.912     0.200
    21.539    38.252     0.200
    21.557    38.043     0.200
    21.575    37.336     0.200
    21.639    36.866     0.200
    22.493    35.178     0.200
    23.435    34.876     0.200
    23.435    34.802     0.200
    23.765    34.328     0.200
    23.765    33.808     0.200
    23.802    33.943     0.200
    23.802    33.143     0.200
    23.870    36.170     0.200
    24.322    35.074     0.200
    24.354    32.650     0.200
    25.328    30.531     0.200
    25.482    30.444     0.200
    26.828    26.824     0.200
    27.080    27.508     0.200
    27.080    26.008     0.200
    27.088    26.594     0.200
    27.480    24.355     0.200
    27.480    26.315     0.200
    27.480    26.525     0.200
    27.601    24.305     0.200
    28.259    23.932     0.200
    29.583    19.376     0.200
    29.583    21.276     0.200
    29.583    21.386     0.200
    29.583    20.276     0.200
    29.752    18.125     0.200
    29.752    17.955     0.200
    29.752    18.606     0.200
    19.936    38.168     0.200
    21.956    36.695     0.200
    23.407    35.866     0.200
    23.672    33.900     0.200
    14.999    43.856     0.200
    20.223    38.370     0.200
    20.436    38.783     0.200
    20.436    38.861     0.200
    20.436    39.509     0.200
    20.537    38.629     0.200
    20.451    38.838     0.200
    20.593    40.081     0.200
    20.668    38.660     0.200
    20.756    37.700     0.200
    21.389    37.364     0.200
    22.766    38.896     0.200
    23.268    35.489     0.200
    24.160    34.950     0.200
    24.195    34.413     0.200
    24.172    33.521     0.200
    24.172    34.115     0.200
    24.172    33.880     0.200
    24.718    31.769     0.200
    24.718    33.090     0.200
    25.174    31.694     0.200
    26.797    28.066     0.200
    27.190    26.675     0.200
    19.632    38.170     0.200
    19.671    37.110     0.200
    19.765    37.381     0.200
    19.765    37.971     0.200
    19.765    37.710     0.200
    19.998    37.788     0.200
    21.842    37.500     0.200
    21.975    37.218     0.200
    22.322    35.143     0.200
    22.322    35.779     0.200
    22.410    35.138     0.200
    22.534    36.136     0.200
    22.534    35.499     0.200
    22.530    35.105     0.200
    22.632    35.055     0.200
    22.829    35.292     0.200
    22.909    35.355     0.200
    22.909    35.117     0.200
    22.909    35.015     0.200
    23.494    34.004     0.200
    23.494    34.793     0.200
    23.494    34.114     0.200
    24.866    33.452     0.200
    26.908    26.121     0.200
    27.357    25.787     0.200
    27.764    23.516     0.200
    15.075    41.923     0.200
    16.803    41.759     0.200
    17.465    38.583     0.200
    18.558    37.679     0.200
    19.348    36.957     0.200
    20.153    37.491     0.200
    20.157    37.415     0.200
    20.366    37.427     0.200
    20.377    36.147     0.200
    20.461    37.364     0.200
    20.499    37.721     0.200
    20.761    35.818     0.200
    20.761    35.125     0.200
    20.849    35.878     0.200
    20.849    35.539     0.200
    21.321    35.816     0.200
    21.378    37.571     0.200
    22.698    37.956     0.200
    22.698    37.764     0.200
    23.046    35.097     0.200
    23.190    35.183     0.200
    23.190    34.724     0.200
    24.256    31.729     0.200
    24.256    31.479     0.200
    24.260    31.273     0.200
    24.260    31.582     0.200
    24.260    31.932     0.200
    24.368    33.578     0.200
    24.525    31.042     0.200
    24.810    31.111     0.200
    24.810    30.672     0.200
    24.985    31.877     0.200
    25.159    29.841     0.200
    26.276    28.208     0.200
    26.743    26.759     0.200
    26.848    26.617     0.200
    26.848    25.372     0.200
    26.856    24.838     0.200
    26.859    24.806     0.200
    27.240    25.862     0.200
    27.240    24.081     0.200
    27.240    23.942     0.200
    27.240    26.161     0.200
    27.542    24.726     0.200
    27.783    22.515     0.200
    27.783    22.365     0.200
    27.783    24.715     0.200
    28.773    20.662     0.200
    29.296    19.860     0.200
    19.835    40.550     0.200
    19.928    39.921     0.200
    23.008    38.292     0.200
    23.173    37.223     0.200
    23.173    36.994     0.200
    23.618    35.396     0.200
    23.618    36.632     0.200
    24.582    36.407     0.200
    20.533    39.686     0.200
    20.494    36.927     0.200
    20.773    36.765     0.200
    24.049    32.108     0.200
    26.874    27.059     0.200
    14.632    43.205     0.200
    19.296    38.767     0.200
    19.840    37.786     0.200
    19.840    38.695     0.200
    19.933    37.920     0.200
    21.630    36.784     0.200
    21.986    36.113     0.200
    22.199    35.802     0.200
    22.199    34.872     0.200
    22.217    35.793     0.200
    23.024    35.570     0.200
    23.024    35.570     0.200
    23.207    35.954     0.200
    23.207    35.725     0.200
    23.614    34.193     0.200
    23.614    33.683     0.200
    25.003    29.961     0.200
    24.923    31.787     0.200
    24.923    32.011     0.200
    27.281    25.876     0.200
    27.289    26.902     0.200
    27.292    26.663     0.200
    28.656    23.118     0.200
    28.922    22.339     0.200
    29.256    19.291     0.200
    29.256    20.447     0.200
    15.105    42.619     0.200
    20.502    38.135     0.200
    20.502    36.616     0.200
    20.523    38.497     0.200
    20.616    37.113     0.200
    20.726    38.525     0.200
    20.730    37.177     0.200
    20.819    35.952     0.200
    23.318    34.881     0.200
    24.254    32.731     0.200
    24.254    31.986     0.200
    24.713    30.298     0.200
    24.713    31.728     0.200
    26.925    27.505     0.200
    20.651    38.504     0.200
    24.115    35.450     0.200
    24.180    34.201     0.200
    20.089    36.507     0.200
    23.687    32.932     0.200
    23.776    33.153     0.200
    23.776    31.946     0.200
    27.108    26.400     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     3.117    11.978     0.200
     5.520    16.934     0.200
     7.414    17.829     0.200
     8.749    22.247     0.200
    11.720    26.076     0.200
    12.457    27.971     0.200
    12.610    30.186     0.200
    13.502    31.787     0.200
    19.980    39.189     0.200
     3.380    13.002     0.200
     6.965    22.863     0.200
     9.153    24.227     0.200
     9.820    26.448     0.200
    10.608    25.053     0.200
    12.090    28.461     0.200
    12.285    31.680     0.200
    12.284    31.694     0.200
    12.682    30.047     0.200
    12.852    34.064     0.200
    12.983    32.535     0.200
    12.945    32.976     0.200
    13.312    30.695     0.200
    13.760    34.465     0.200
    13.982    33.873     0.200
    14.893    33.246     0.200
    15.091    32.931     0.200
    16.692    33.246     0.200
    20.384    41.166     0.200
    21.126    40.502     0.200
     2.581    11.138     0.200
     5.359    17.226     0.200
     7.612    16.434     0.200
    10.646    24.323     0.200
    11.620    26.657     0.200
    13.000    26.557     0.200
    13.095    26.448     0.200
    12.759    33.362     0.200
     1.655     8.773     0.200
     2.799    12.920     0.200
     5.035    17.332     0.200
     6.080    20.536     0.200
    10.128    27.891     0.200
    10.218    27.349     0.200
    11.259    27.800     0.200
    11.494    27.953     0.200
    12.495    29.267     0.200
    12.735    27.572     0.200
    12.473    30.526     0.200
    12.829    28.873     0.200
    12.944    29.033     0.200
    13.165    33.452     0.200
    14.116    32.359     0.200
    16.625    32.575     0.200
    17.063    39.965     0.200
    19.496    40.564     0.200
     2.669    11.742     0.200
     4.453    15.717     0.200
     6.146    16.960     0.200
     6.051    20.070     0.200
     7.654    19.366     0.200
     9.593    25.242     0.200
    10.757    25.054     0.200
    11.660    28.622     0.200
    12.097    27.517     0.200
    13.000    28.983     0.200
    12.825    32.019     0.200
    13.114    27.653     0.200
    13.494    30.219     0.200
    16.978    35.052     0.200
    17.487    36.613     0.200
     3.032    12.589     0.200
     3.645    15.435     0.200
    10.346    29.830     0.200
    10.559    26.243     0.200
    11.149    26.466     0.200
    11.757    29.470     0.200
    11.910    29.683     0.200
    12.170    26.940     0.200
    12.655    27.889     0.200
    12.659    27.346     0.200
    12.878    27.883     0.200
    12.785    30.162     0.200
    13.021    28.620     0.200
    13.428    31.869     0.200
    13.412    32.055     0.200
    13.577    32.125     0.200
    14.398    31.544     0.200
    14.565    30.597     0.200
    16.562    32.186     0.200
    16.946    31.815     0.200
    18.825    40.380     0.200
    20.020    39.941     0.200
     3.236    13.005     0.200
     9.110    27.647     0.200
    10.378    27.153     0.200
    10.896    26.609     0.200
    10.896    26.509     0.200
    10.816    25.043     0.200
    11.848    27.702     0.200
    12.154    28.433     0.200
    12.536    27.771     0.200
    13.111    28.258     0.200
    13.111    28.659     0.200
    13.046    29.020     0.200
    13.645    32.029     0.200
    13.629    32.913     0.200
    13.829    34.878     0.200
    13.829    35.679     0.200
    14.891    32.493     0.200
    14.891    32.893     0.200
    16.451    31.685     0.200
    18.587    39.353     0.200
    20.389    39.331     0.200
     3.163    13.057     0.200
     4.600    16.286     0.200
     4.646    16.254     0.200
     4.851    16.553     0.200
     5.078    15.907     0.200
     5.595    21.068     0.200
     7.069    19.973     0.200
     7.250    22.055     0.200
     8.071    22.375     0.200
     8.385    22.711     0.200
     8.696    23.491     0.200
     9.092    25.062     0.200
     9.204    26.851     0.200
     9.706    23.104     0.200
    10.921    26.723     0.200
    11.797    27.999     0.200
    12.083    29.354     0.200
    12.565    26.732     0.200
    12.720    29.924     0.200
    12.720    30.424     0.200
    12.867    29.008     0.200
    12.888    28.964     0.200
    13.464    30.239     0.200
    13.828    28.991     0.200
    14.613    31.834     0.200
    14.613    32.334     0.200
    15.008    34.821     0.200
    16.477    31.386     0.200
    19.783    39.496     0.200
     2.533    11.701     0.200
     5.248    17.916     0.200
     6.212    20.476     0.200
     6.484    21.099     0.200
     6.524    20.726     0.200
     6.444    21.162     0.200
     6.522    22.057     0.200
     6.733    21.586     0.200
     6.872    22.570     0.200
     7.312    23.330     0.200
    13.401    29.374     0.200
    14.118    31.004     0.200
    17.230    33.691     0.200
     1.819     9.898     0.200
     2.843    10.852     0.200
     8.026    20.368     0.200
     9.651    22.997     0.200
     9.586    26.662     0.200
    11.305    25.593     0.200
    12.549    27.586     0.200
    12.585    26.156     0.200
    12.746    27.980     0.200
    12.878    27.247     0.200
    13.278    29.072     0.200
    13.730    28.000     0.200
    16.482    29.878     0.200
    19.800    38.961     0.200
     0.959     7.988     0.200
     2.478    13.762     0.200
     9.955    24.503     0.200
    10.431    29.652     0.200
    12.281    29.857     0.200
    12.863    32.067     0.200
    12.913    30.484     0.200
    13.902    30.937     0.200
    16.901    33.938     0.200
     2.434    12.041     0.200
     2.503    11.838     0.200
     4.684    16.087     0.200
     7.081    20.315     0.200
     7.124    20.517     0.200
     7.253    20.701     0.200
     7.331    20.890     0.200
     8.339    23.335     0.200
     8.572    25.006     0.200
     9.591    24.118     0.200
     9.615    25.844     0.200
     9.790    24.897     0.200
    10.070    24.534     0.200
    10.108    24.090     0.200
    10.108    24.691     0.200
    10.386    24.239     0.200
    10.643    26.145     0.200
    10.680    26.415     0.200
    10.794    27.085     0.200
    12.032    32.635     0.200
    12.188    30.410     0.200
    12.152    30.232     0.200
    12.136    30.419     0.200
    12.412    28.601     0.200
    13.029    29.095     0.200
    13.069    30.527     0.200
    13.622    28.573     0.200
    14.154    30.869     0.200
    14.163    29.765     0.200
    14.185    31.512     0.200
    14.827    33.510     0.200
    16.619    37.895     0.200
    17.414    32.829     0.200
    17.589    37.787     0.200
    17.771    35.656     0.200
    17.771    36.453     0.200
    19.466    39.875     0.200
    20.762    38.756     0.200
     4.301    18.611     0.200
     5.667    19.264     0.200
     5.785    18.688     0.200
     7.031    20.846     0.200
     7.087    21.896     0.200
     7.828    23.748     0.200
     8.926    22.634     0.200
     9.393    27.188     0.200
    12.214    28.763     0.200
     4.276    18.961     0.200
     5.142    18.352     0.200
     5.640    19.535     0.200
     6.746    20.240     0.200
     7.006    20.605     0.200
     7.059    21.883     0.200
     7.797    22.969     0.200
     8.945    22.969     0.200
     9.389    27.293     0.200
     9.930    26.476     0.200
    12.243    28.482     0.200
    12.845    32.153     0.200
    12.899    30.832     0.200
    13.018    30.440     0.200
    13.096    32.431     0.200
    13.883    32.347     0.200
    14.738    32.367     0.200
     3.105    14.838     0.200
     5.110    17.437     0.200
     5.539    20.933     0.200
     6.184    20.201     0.200
     6.353    20.927     0.200
     7.007    21.301     0.200
     8.011    23.485     0.200
     8.272    23.940     0.200
     8.633    23.819     0.200
     8.677    25.310     0.200
     9.029    25.500     0.200
     9.269    27.203     0.200
     9.687    25.521     0.200
    10.277    28.633     0.200
    10.817    30.333     0.200
    10.982    27.008     0.200
    11.875    33.989     0.200
    12.407    29.785     0.200
    12.559    29.303     0.200
    12.839    31.346     0.200
    12.952    30.422     0.200
    13.803    29.783     0.200
    15.027    37.701     0.200
    16.468    34.385     0.200
    20.088    40.138     0.200
     2.530    12.536     0.200
     5.389    18.372     0.200
     5.695    17.110     0.200
     5.750    19.565     0.200
     5.946    19.778     0.200
     5.990    19.364     0.200
     5.909    20.304     0.200
     6.197    19.552     0.200
     6.407    20.397     0.200
     6.733    21.688     0.200
     6.984    21.962     0.200
     7.046    23.844     0.200
     7.376    23.792     0.200
     7.389    23.231     0.200
     7.797    24.478     0.200
    12.254    28.860     0.200
    12.910    30.607     0.200
    13.083    29.583     0.200
    19.041    40.852     0.200
     1.252     8.659     0.200
     2.500    13.298     0.200
     5.323    18.343     0.200
     5.879    19.665     0.200
     5.925    19.324     0.200
     5.981    20.167     0.200
     6.130    19.326     0.200
     6.345    20.022     0.200
     6.794    20.876     0.200
     7.053    20.959     0.200
     8.903    24.766     0.200
    10.353    28.846     0.200
    12.194    28.363     0.200
    12.853    27.674     0.200
    12.910    31.006     0.200
    13.008    29.866     0.200
    13.228    31.299     0.200
    13.888    31.598     0.200
    16.865    34.848     0.200
    17.490    39.561     0.200
    19.055    40.701     0.200
    20.201    40.922     0.200
    13.008    32.895     0.200
     1.477     9.117     0.200
     2.609    12.007     0.200
     4.764    16.958     0.200
     5.315    17.907     0.200
     5.367    17.932     0.200
     5.569    18.058     0.200
     5.798    18.930     0.200
     5.754    21.799     0.200
     6.337    21.197     0.200
     6.558    21.821     0.200
     7.625    22.971     0.200
     7.662    22.540     0.200
     7.963    22.217     0.200
     8.326    23.787     0.200
     8.358    24.210     0.200
     9.912    29.278     0.200
    11.651    27.485     0.200
    11.799    28.253     0.200
    11.799    31.353     0.200
    12.693    32.820     0.200
    19.867    41.100     0.200
    20.741    41.101     0.200
     2.144    11.089     0.200
     2.940    11.508     0.200
     4.060    14.791     0.200
     4.605    15.889     0.200
     4.666    15.697     0.200
     4.863    16.503     0.200
     5.110    17.323     0.200
     7.027    19.313     0.200
     7.284    21.211     0.200
     8.052    21.639     0.200
     8.347    21.904     0.200
     8.369    22.439     0.200
     9.355    26.138     0.200
     9.707    25.826     0.200
    10.963    25.174     0.200
    12.160    28.101     0.200
    12.301    30.855     0.200
    12.280    25.801     0.200
    12.508    28.145     0.200
    12.508    29.348     0.200
    12.566    28.470     0.200
    12.729    28.567     0.200
    12.729    28.168     0.200
    12.753    29.281     0.200
    13.103    32.200     0.200
    13.565    29.802     0.200
    13.966    35.129     0.200
    14.750    31.977     0.200
    16.188    32.193     0.200
    19.498    38.571     0.200
     5.357    18.715     0.200
     5.501    20.426     0.200
     5.797    19.475     0.200
     6.331    20.849     0.200
     6.354    19.976     0.200
     6.397    20.276     0.200
     6.575    21.092     0.200
     6.596    18.347     0.200
     6.604    20.653     0.200
     6.811    21.635     0.200
     6.982    22.752     0.200
     7.413    23.920     0.200
     9.006    25.326     0.200
     9.039    26.243     0.200
     9.228    21.633     0.200
    10.136    25.945     0.200
    10.301    27.213     0.200
    10.749    28.885     0.200
    10.765    26.595     0.200
    10.891    30.235     0.200
    11.330    27.506     0.200
    11.330    28.006     0.200
    11.432    25.317     0.200
    11.820    29.788     0.200
    12.506    32.777     0.200
    12.533    32.969     0.200
    12.517    33.157     0.200
    12.579    32.930     0.200
    12.657    28.622     0.200
    12.969    29.374     0.200
    12.969    29.584     0.200
    13.109    30.739     0.200
    13.280    29.047     0.200
    14.028    31.023     0.200
    14.832    35.236     0.200
    14.832    35.400     0.200
    17.020    38.107     0.200
    18.101    33.488     0.200
    18.315    38.985     0.200
    20.192    40.081     0.200
     2.509    12.384     0.200
     5.298    17.337     0.200
     5.427    19.735     0.200
     5.867    19.799     0.200
     6.266    19.944     0.200
     6.425    21.190     0.200
     6.466    19.804     0.200
     6.504    21.170     0.200
     6.679    18.928     0.200
     6.675    20.973     0.200
     6.878    21.396     0.200
     7.359    23.389     0.200
     9.309    21.226     0.200
    13.350    28.278     0.200
    13.699    30.000     0.200
    14.081    32.543     0.200
     2.475    11.370     0.200
     5.291    17.101     0.200
     5.432    18.663     0.200
     5.866    17.891     0.200
     6.263    18.861     0.200
     6.423    19.390     0.200
     6.466    18.690     0.200
     6.506    19.223     0.200
     6.662    16.506     0.200
     6.674    19.867     0.200
     6.916    20.141     0.200
     6.880    18.960     0.200
     7.349    22.180     0.200
     8.987    24.864     0.200
     9.286    18.984     0.200
    10.164    24.629     0.200
    10.170    25.565     0.200
    10.699    25.888     0.200
    10.699    26.388     0.200
    10.809    29.610     0.200
    10.842    28.628     0.200
    11.262    28.321     0.200
    11.670    30.562     0.200
    12.455    31.402     0.200
    12.455    32.203     0.200
    12.489    31.001     0.200
    12.984    32.225     0.200
    12.984    27.424     0.200
    12.997    32.071     0.200
    12.997    29.271     0.200
    13.318    27.329     0.200
    14.046    28.828     0.200
    14.823    34.665     0.200
    16.951    33.929     0.200
    19.628    38.687     0.200
     2.042    12.315     0.200
     2.445    11.312     0.200
     5.264    17.621     0.200
     5.561    17.946     0.200
     5.413    19.480     0.200
     5.888    19.334     0.200
     6.238    20.152     0.200
     6.444    20.840     0.200
     6.488    20.327     0.200
     6.485    20.264     0.200
     6.695    20.712     0.200
     6.904    21.482     0.200
     6.889    20.759     0.200
     7.320    22.520     0.200
    12.749    29.062     0.200
    13.303    28.104     0.200
    14.022    33.206     0.200
     2.457    12.786     0.200
     2.187    15.034     0.200
     5.593    19.286     0.200
     5.741    19.439     0.200
     5.560    20.878     0.200
     6.297    21.048     0.200
     6.342    20.592     0.200
     6.548    21.299     0.200
     6.384    20.863     0.200
     6.757    21.301     0.200
     6.633    21.356     0.200
     7.031    22.105     0.200
     7.459    25.108     0.200
     9.094    27.830     0.200
    10.708    29.392     0.200
    10.826    28.414     0.200
    12.604    29.472     0.200
    12.939    33.559     0.200
    12.562    33.964     0.200
    13.234    28.622     0.200
    13.995    29.431     0.200
    14.858    36.170     0.200
    15.825    31.883     0.200
    20.412    40.055     0.200
     2.276    12.452     0.200
     3.243    14.071     0.200
     6.315    19.920     0.200
     7.130    21.206     0.200
     7.297    22.057     0.200
     8.128    23.560     0.200
     8.378    24.638     0.200
     9.157    25.350     0.200
    11.868    30.614     0.200
    12.402    29.282     0.200
    12.606    27.803     0.200
    12.930    30.023     0.200
    13.888    31.843     0.200
    16.520    32.631     0.200
    18.354    41.220     0.200
    18.823    40.746     0.200
    19.954    41.349     0.200
     2.571     9.664     0.200
     5.658    17.134     0.200
     5.799    17.394     0.200
     6.633    18.361     0.200
     6.872    18.265     0.200
     7.283    18.969     0.200
     7.712    21.164     0.200
     9.204    24.553     0.200
    12.355    25.982     0.200
    12.355    26.482     0.200
    12.988    26.597     0.200
    13.031    27.093     0.200
    12.672    30.281     0.200
    13.193    25.707     0.200
    14.793    35.035     0.200
    17.044    30.563     0.200
    20.381    38.813     0.200
     5.799    16.226     0.200
     5.799    16.226     0.200
     5.799    15.158     0.200
     5.799    15.138     0.200
     3.178    13.367     0.200
     7.273    23.477     0.200
     7.278    21.220     0.200
     8.718    24.313     0.200
     9.185    27.863     0.200
    11.817    30.139     0.200
    12.558    26.998     0.200
    12.868    28.378     0.200
    13.665    32.080     0.200
    15.008    35.510     0.200
    16.470    32.843     0.200
    20.222    39.255     0.200
    20.211    39.187     0.200
     2.533    12.280     0.200
     2.508    15.961     0.200
     2.906    14.923     0.200
     3.684    17.343     0.200
     3.789    16.818     0.200
     3.902    18.000     0.200
     6.091    21.052     0.200
     6.296    21.756     0.200
     6.301    21.205     0.200
     7.224    20.727     0.200
     7.093    22.955     0.200
     7.365    23.191     0.200
     7.718    23.967     0.200
     8.121    25.264     0.200
     8.544    23.128     0.200
    11.900    28.969     0.200
    12.805    29.396     0.200
    18.981    40.324     0.200
    19.270    42.750     0.200
    12.805    32.833     0.200
    12.805    32.388     0.200
     6.301    19.712     0.200
     2.623    12.393     0.200
     2.992    14.022     0.200
     3.245    14.816     0.200
     3.352    16.179     0.200
     3.444    15.606     0.200
     3.567    15.874     0.200
     4.068    16.063     0.200
     4.336    17.401     0.200
     4.486    17.202     0.200
     4.696    18.899     0.200
     5.329    19.913     0.200
     5.825    18.522     0.200
     5.887    20.719     0.200
     5.928    20.759     0.200
     5.962    20.827     0.200
     5.966    20.872     0.200
     6.137    21.326     0.200
     6.341    21.502     0.200
     6.802    22.227     0.200
     7.041    23.229     0.200
     7.506    20.687     0.200
     7.364    23.222     0.200
     7.876    25.082     0.200
     8.018    24.407     0.200
     8.045    24.371     0.200
     8.423    28.053     0.200
     8.427    28.269     0.200
     8.438    28.287     0.200
     8.543    28.316     0.200
     8.516    27.993     0.200
     8.530    28.198     0.200
     8.535    28.130     0.200
     8.560    28.525     0.200
     8.567    28.522     0.200
     8.550    28.314     0.200
     8.575    28.802     0.200
    10.302    30.375     0.200
    12.186    28.791     0.200
    14.019    32.813     0.200
     5.966    19.240     0.200
     5.966    19.240     0.200
     5.966    18.341     0.200
     5.966    17.779     0.200
     5.966    18.798     0.200
     1.679     9.150     0.200
     2.609    11.489     0.200
     2.828    13.842     0.200
     3.000    13.036     0.200
     3.255    13.621     0.200
     3.342    14.745     0.200
     3.435    13.462     0.200
     3.556    14.938     0.200
     4.078    14.705     0.200
     4.327    14.749     0.200
     4.498    16.107     0.200
     4.706    17.219     0.200
     5.340    18.593     0.200
     5.775    17.852     0.200
     5.898    19.738     0.200
     5.940    19.554     0.200
     5.951    20.291     0.200
     5.956    19.736     0.200
     6.148    20.167     0.200
     6.353    20.092     0.200
     6.789    20.513     0.200
     7.030    20.600     0.200
     7.499    19.343     0.200
     7.375    21.961     0.200
     7.863    22.587     0.200
     8.030    23.204     0.200
     8.058    23.118     0.200
     8.356    26.785     0.200
     8.401    27.431     0.200
     8.962    26.618     0.200
     8.976    26.112     0.200
     9.014    26.747     0.200
     9.073    26.799     0.200
     9.152    25.714     0.200
     9.232    26.206     0.200
     9.251    25.816     0.200
     9.313    26.058     0.200
    10.317    28.445     0.200
    12.198    27.389     0.200
    12.364    26.959     0.200
    12.974    28.740     0.200
    12.974    29.830     0.200
    13.125    28.072     0.200
    14.010    30.762     0.200
    14.010    32.750     0.200
     5.956    18.041     0.200
     5.956    18.041     0.200
     5.956    17.427     0.200
     2.240    12.366     0.200
     2.475    13.417     0.200
     2.928    13.530     0.200
     2.991    15.692     0.200
     3.090    14.447     0.200
     3.207    16.075     0.200
     3.330    14.371     0.200
     3.602    15.092     0.200
     4.423    16.076     0.200
     5.052    19.299     0.200
     5.461    18.973     0.200
     5.602    20.523     0.200
     5.607    20.169     0.200
     5.693    19.889     0.200
     6.251    21.187     0.200
     6.293    21.151     0.200
     6.435    21.105     0.200
     6.501    21.504     0.200
     6.678    21.469     0.200
     6.707    21.439     0.200
     7.065    22.379     0.200
     7.728    22.481     0.200
     8.384    24.254     0.200
     8.599    28.153     0.200
     8.650    27.775     0.200
     8.689    28.555     0.200
     8.712    28.261     0.200
     8.785    28.239     0.200
     8.844    28.867     0.200
     8.860    28.595     0.200
     8.868    28.916     0.200
     8.868    29.146     0.200
     8.873    29.417     0.200
     8.955    29.134     0.200
    10.648    32.636     0.200
    13.250    29.280     0.200
    14.029    32.186     0.200
     1.544     7.820     0.200
     2.575    11.865     0.200
     2.704    12.765     0.200
     2.862    12.075     0.200
     2.968    12.479     0.200
     2.950    11.689     0.200
     3.126    12.864     0.200
     3.280    15.237     0.200
     3.468    14.851     0.200
     3.684    15.924     0.200
     4.460    16.064     0.200
     4.575    15.463     0.200
     5.029    15.179     0.200
     5.220    16.858     0.200
     5.743    16.799     0.200
     5.776    17.829     0.200
     5.821    17.808     0.200
     5.914    20.895     0.200
     6.027    17.922     0.200
     6.079    20.779     0.200
     6.083    19.623     0.200
     6.238    18.712     0.200
     6.901    21.181     0.200
     7.154    21.633     0.200
     7.396    18.798     0.200
     7.541    22.721     0.200
     7.912    22.027     0.200
     7.957    24.152     0.200
     8.289    27.115     0.200
     8.343    27.132     0.200
     8.385    27.373     0.200
     8.407    27.519     0.200
     8.410    26.756     0.200
     8.423    26.910     0.200
     8.419    27.474     0.200
     8.454    27.371     0.200
     8.463    27.819     0.200
     8.479    27.367     0.200
     8.514    27.088     0.200
     8.518    26.116     0.200
     8.521    27.282     0.200
     8.525    26.696     0.200
     8.538    26.275     0.200
     8.538    26.466     0.200
     8.544    26.924     0.200
     8.543    27.703     0.200
     8.553    27.219     0.200
     8.563    26.315     0.200
     8.616    27.329     0.200
     8.688    26.579     0.200
     8.914    26.711     0.200
     8.957    26.621     0.200
     8.966    25.724     0.200
     9.101    26.459     0.200
     9.181    26.558     0.200
     9.190    26.349     0.200
     9.258    26.544     0.200
     9.290    29.833     0.200
     9.322    26.527     0.200
     9.338    26.382     0.200
     9.451    26.116     0.200
    10.006    27.490     0.200
    10.241    27.603     0.200
    10.241    27.205     0.200
    10.730    26.099     0.200
    10.678    28.985     0.200
    11.249    28.643     0.200
    11.253    27.409     0.200
    12.087    27.965     0.200
    12.259    26.055     0.200
    12.891    29.778     0.200
    12.763    31.172     0.200
    12.763    30.766     0.200
    12.957    30.910     0.200
    13.006    26.536     0.200
    12.931    32.215     0.200
    12.919    32.356     0.200
    13.920    30.645     0.200
    13.920    32.411     0.200
    14.884    34.925     0.200
    14.884    34.714     0.200
    15.742    30.804     0.200
    17.595    37.786     0.200
     2.490    11.889     0.200
     2.828    13.739     0.200
     2.736    13.314     0.200
     3.328    16.406     0.200
     3.729    16.730     0.200
     5.697    16.761     0.200
     7.325    21.074     0.200
    11.208    30.122     0.200
    13.853    31.851     0.200
    12.826    31.106     0.200
     3.511    15.865     0.200
     5.939    21.930     0.200
     6.123    22.079     0.200
     6.128    20.832     0.200
     6.933    22.334     0.200
     7.195    22.483     0.200
     7.325    20.855     0.200
     7.566    23.949     0.200
     7.977    24.947     0.200
     8.317    27.874     0.200
     8.371    27.875     0.200
     8.412    27.977     0.200
     8.426    28.720     0.200
     8.428    28.063     0.200
     8.442    27.993     0.200
     8.445    27.986     0.200
     8.475    27.905     0.200
     8.480    28.807     0.200
     8.501    27.963     0.200
     8.530    28.030     0.200
     8.533    27.538     0.200
     8.537    28.030     0.200
     8.552    26.919     0.200
     8.553    27.683     0.200
     8.544    28.029     0.200
     8.555    26.893     0.200
     8.547    28.032     0.200
     8.559    27.232     0.200
     8.569    27.908     0.200
     8.576    27.307     0.200
     8.567    28.067     0.200
     8.628    27.323     0.200
     8.700    27.209     0.200
     8.750    27.149     0.200
     8.925    27.299     0.200
     8.966    27.330     0.200
     8.975    27.225     0.200
     9.110    27.140     0.200
     9.189    27.016     0.200
     9.197    26.900     0.200
     9.213    26.564     0.200
     9.263    27.014     0.200
     9.291    30.644     0.200
     9.326    27.013     0.200
     9.341    26.977     0.200
     9.524    26.601     0.200
    10.017    27.747     0.200
    10.688    28.872     0.200
    11.208    28.802     0.200
    12.826    31.105     0.200
    12.933    29.815     0.200
    13.853    31.485     0.200
    14.949    35.285     0.200
    17.630    39.503     0.200
     6.128    19.246     0.200
     6.128    19.246     0.200
     6.128    19.246     0.200
     6.128    19.246     0.200
     6.128    19.246     0.200
     6.128    20.011     0.200
     3.309    16.242     0.200
     3.709    17.181     0.200
    12.074    29.063     0.200
    12.838    31.636     0.200
     3.300    16.345     0.200
     3.492    16.509     0.200
     3.709    17.079     0.200
     6.104    20.436     0.200
     7.962    26.542     0.200
     8.319    28.232     0.200
     8.373    27.855     0.200
     8.414    28.015     0.200
     8.430    29.097     0.200
     8.433    28.446     0.200
     8.447    28.295     0.200
     8.479    28.233     0.200
     8.485    29.188     0.200
     8.504    28.364     0.200
     8.539    27.947     0.200
     8.536    28.640     0.200
     8.558    27.669     0.200
     8.540    28.359     0.200
     8.561    27.488     0.200
     8.559    28.275     0.200
     8.548    28.358     0.200
     8.551    28.319     0.200
     8.565    28.088     0.200
     8.574    28.509     0.200
     8.582    27.522     0.200
     8.570    28.367     0.200
     8.635    27.653     0.200
     8.706    27.444     0.200
     8.756    27.484     0.200
     8.932    27.335     0.200
     8.974    27.597     0.200
     8.983    26.798     0.200
     9.117    27.490     0.200
     9.196    27.287     0.200
     9.205    26.799     0.200
     9.222    27.234     0.200
     9.271    27.257     0.200
     9.301    31.312     0.200
     9.335    27.285     0.200
     9.350    26.630     0.200
     9.502    27.069     0.200
    10.023    28.526     0.200
    10.695    28.923     0.200
    14.936    36.654     0.200
    17.612    40.932     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
     6.108    19.422     0.200
    14.936    37.396     0.200
     2.599    12.801     0.200
     2.729    13.280     0.200
     2.953    13.668     0.200
     3.064    15.374     0.200
     3.575    16.414     0.200
     2.962    12.981     0.200
     3.657    15.874     0.200
    12.041    28.529     0.200
     3.333    15.247     0.200
     8.301    27.817     0.200
     8.396    27.587     0.200
     8.409    28.499     0.200
     8.412    27.819     0.200
     8.429    27.596     0.200
     8.426    27.734     0.200
     8.458    27.613     0.200
     8.464    28.463     0.200
     8.484    27.616     0.200
     8.521    27.734     0.200
     8.514    27.991     0.200
     8.516    27.500     0.200
     8.531    27.723     0.200
     8.537    27.645     0.200
     8.535    26.374     0.200
     8.539    26.480     0.200
     8.550    27.046     0.200
     8.542    27.685     0.200
     8.552    27.869     0.200
     8.733    26.878     0.200
     8.908    26.981     0.200
     8.959    27.298     0.200
     9.093    26.174     0.200
     9.172    26.723     0.200
     9.196    26.303     0.200
     9.246    25.714     0.200
     1.137    11.497     0.200
     2.582     9.633     0.200
     3.002    14.330     0.200
     3.125    15.800     0.200
     3.632    16.881     0.200
     2.976    13.977     0.200
     3.624    13.812     0.200
     3.654    16.057     0.200
     3.739    17.066     0.200
    12.045    28.642     0.200
     2.045    12.837     0.200
     3.002    13.672     0.200
     3.522    15.894     0.200
     6.139    21.768     0.200
     6.139    19.534     0.200
     6.139    18.971     0.200
     6.139    18.971     0.200
     6.139    18.971     0.200
     6.139    19.346     0.200
     6.139    18.409     0.200
     6.139    17.674     0.200
     1.354    10.356     0.200
     2.620    12.587     0.200
     3.449    13.699     0.200
     3.479    16.053     0.200
     3.572    16.474     0.200
     1.301    10.072     0.200
     1.912    12.849     0.200
     3.022    14.688     0.200
     2.844    12.970     0.200
     3.175    17.302     0.200
     3.357    15.479     0.200
     5.828    20.741     0.200
     5.966    21.731     0.200
     5.971    20.769     0.200
     7.046    23.535     0.200
     8.287    27.796     0.200
     8.342    27.619     0.200
     8.423    27.524     0.200
     8.387    27.514     0.200
     8.427    27.815     0.200
     8.438    27.265     0.200
     8.423    27.697     0.200
     8.481    28.797     0.200
     8.491    27.447     0.200
     8.542    27.999     0.200
     8.535    28.601     0.200
     8.566    27.090     0.200
     8.560    28.640     0.200
     8.517    27.454     0.200
     8.567    28.223     0.200
     8.530    27.720     0.200
     8.536    27.653     0.200
     8.591    26.799     0.200
     8.550    27.695     0.200
     8.645    28.029     0.200
     8.768    26.557     0.200
     8.946    27.687     0.200
     8.990    27.649     0.200
     8.998    26.907     0.200
     9.136    26.429     0.200
     9.216    26.527     0.200
     9.247    26.808     0.200
     9.300    26.658     0.200
     9.338    30.872     0.200
     9.382    27.642     0.200
     9.320    26.394     0.200
    10.037    28.488     0.200
    12.182    28.994     0.200
    18.946    41.562     0.200
     5.971    18.667     0.200
     5.971    18.667     0.200
     5.971    17.628     0.200
     5.971    17.769     0.200
     1.174    10.062     0.200
     2.946    14.178     0.200
     3.595    14.709     0.200
     3.626    17.453     0.200
     3.710    17.670     0.200
     2.973    13.873     0.200
     3.493    16.796     0.200
     5.922    21.857     0.200
     6.105    22.722     0.200
     6.110    21.763     0.200
     7.177    23.515     0.200
     7.960    26.664     0.200
     8.379    28.221     0.200
     8.420    28.632     0.200
     8.436    29.198     0.200
     8.439    28.462     0.200
     8.453    28.489     0.200
     8.485    28.302     0.200
     8.491    29.229     0.200
     8.511    28.002     0.200
     8.541    28.643     0.200
     8.544    28.858     0.200
     8.565    28.544     0.200
     8.567    27.032     0.200
     8.570    28.264     0.200
     8.576    28.393     0.200
     8.580    28.536     0.200
     6.110    19.599     0.200
     6.110    19.544     0.200
     6.110    20.036     0.200
     1.156     8.380     0.200
     2.559    12.012     0.200
     2.979    13.112     0.200
     2.969    13.623     0.200
     3.614    14.594     0.200
     3.645    17.339     0.200
     3.731    17.130     0.200
     5.727    21.039     0.200
     7.353    17.061     0.200
     1.118     8.723     0.200
     1.495     9.022     0.200
     1.830    11.511     0.200
     2.043    14.036     0.200
     2.809    12.958     0.200
     3.079    13.995     0.200
     2.996    13.316     0.200
     3.515    16.357     0.200
     9.506    28.238     0.200
    10.216    29.951     0.200
    12.215    26.321     0.200
    12.047    28.290     0.200
    12.855    27.852     0.200
    13.882    28.870     0.200
     2.635     9.800     0.200
     2.701    13.026     0.200
     2.768    14.251     0.200
     2.827    13.961     0.200
     2.561    12.464     0.200
     2.627    11.193     0.200
     2.751    11.747     0.200
     2.980    13.073     0.200
     3.180    15.744     0.200
     3.560    16.807     0.200
     2.436    13.740     0.200
     2.503    11.965     0.200
     2.630    12.484     0.200
     2.856    11.839     0.200
     2.531    12.937     0.200
     2.598    11.654     0.200
     2.665    12.871     0.200
     2.730    12.111     0.200
     2.952    12.519     0.200
     3.509    18.020     0.200
     3.626    16.660     0.200
     5.698    16.471     0.200
     1.600    10.112     0.200
     1.935    12.134     0.200
     2.913    14.390     0.200
     2.928    13.902     0.200
     3.184    14.398     0.200
     3.409    16.587     0.200
     4.406    16.753     0.200
     5.025    15.327     0.200
     5.849    19.910     0.200
     6.021    21.910     0.200
     6.025    20.857     0.200
     6.838    22.174     0.200
     7.094    22.988     0.200
     7.892    25.075     0.200
     8.346    28.032     0.200
     8.400    27.778     0.200
     8.443    27.385     0.200
     8.468    28.700     0.200
     8.471    27.961     0.200
     8.484    27.869     0.200
     8.478    27.683     0.200
     8.524    28.815     0.200
     8.540    27.568     0.200
     8.581    28.550     0.200
     8.576    28.480     0.200
     8.601    25.188     0.200
     8.600    27.942     0.200
     8.606    27.997     0.200
     8.615    28.533     0.200
     8.626    26.563     0.200
     8.602    27.169     0.200
     8.680    27.899     0.200
     8.978    27.139     0.200
     9.021    26.723     0.200
     9.029    27.086     0.200
     9.165    26.721     0.200
     9.245    26.107     0.200
     9.255    26.144     0.200
     9.262    26.996     0.200
     9.323    25.852     0.200
     9.403    26.612     0.200
     9.428    24.748     0.200
    10.307    30.684     0.200
    12.150    29.175     0.200
    12.250    28.513     0.200
    12.869    28.785     0.200
    13.008    27.166     0.200
    13.902    31.737     0.200
    19.018    41.035     0.200
     6.025    19.778     0.200
     6.025    18.775     0.200
     6.025    18.775     0.200
     6.025    18.642     0.200
     6.025    18.157     0.200
     1.187     9.375     0.200
     2.482    11.757     0.200
     2.658    12.501     0.200
     2.720    13.785     0.200
     2.945    12.150     0.200
     3.583    15.312     0.200
     3.485    14.859     0.200
     3.698    16.466     0.200
     7.340    19.871     0.200
    12.835    31.742     0.200
     1.526    10.236     0.200
     2.310    14.869     0.200
     2.837    13.722     0.200
     3.112    14.190     0.200
     3.481    16.596     0.200
     3.931    15.574     0.200
     4.367    16.978     0.200
     4.560    17.157     0.200
     4.481    17.235     0.200
     4.973    15.486     0.200
     5.212    18.093     0.200
     5.767    20.400     0.200
     5.814    19.193     0.200
     6.019    20.740     0.200
     5.912    20.835     0.200
     6.235    20.567     0.200
     6.093    21.616     0.200
     6.098    20.762     0.200
     6.591    21.205     0.200
     6.904    23.150     0.200
     7.247    21.556     0.200
     7.165    22.910     0.200
     7.906    23.900     0.200
     7.951    25.741     0.200
     8.329    27.490     0.200
     8.383    27.574     0.200
     8.441    28.530     0.200
     8.444    27.824     0.200
     8.424    27.618     0.200
     8.457    27.724     0.200
     8.458    27.619     0.200
     8.496    28.558     0.200
     8.489    27.644     0.200
     8.515    27.650     0.200
     8.550    26.951     0.200
     8.546    27.766     0.200
     8.572    26.914     0.200
     8.570    27.655     0.200
     8.550    27.742     0.200
     8.576    28.244     0.200
     8.558    27.747     0.200
     8.562    27.782     0.200
     8.585    27.870     0.200
     8.580    27.726     0.200
     8.768    27.221     0.200
     8.943    27.367     0.200
     8.994    26.916     0.200
     9.129    26.744     0.200
     9.217    26.592     0.200
     9.225    26.785     0.200
     9.233    26.573     0.200
     9.283    26.701     0.200
     9.312    30.689     0.200
     9.347    26.701     0.200
     9.361    26.671     0.200
     9.498    26.682     0.200
    10.258    29.808     0.200
    12.085    28.493     0.200
    12.952    29.877     0.200
    13.864    32.736     0.200
    12.952    32.709     0.200
     6.098    17.895     0.200
     6.098    18.899     0.200
     6.098    18.899     0.200
     6.098    18.899     0.200
     2.612    10.795     0.200
     2.679    13.017     0.200
     2.741    11.299     0.200
     2.966    10.865     0.200
     3.103    15.067     0.200
     3.613    16.114     0.200
     2.595    13.237     0.200
     2.986    12.671     0.200
     3.627    13.289     0.200
     3.746    16.801     0.200
    12.969    28.165     0.200
     1.114     8.410     0.200
     3.012    12.362     0.200
     3.530    16.219     0.200
     6.141    20.851     0.200
     6.146    20.399     0.200
     6.963    22.258     0.200
     7.216    23.005     0.200
     7.601    23.709     0.200
     8.017    24.761     0.200
     8.254    27.412     0.200
     8.307    27.493     0.200
     8.348    27.521     0.200
     8.365    27.927     0.200
     8.368    27.514     0.200
     8.381    27.512     0.200
     8.382    27.546     0.200
     8.413    27.447     0.200
     8.420    28.556     0.200
     8.439    27.523     0.200
     8.470    27.788     0.200
     8.474    27.172     0.200
     8.474    27.619     0.200
     8.482    27.615     0.200
     8.493    27.045     0.200
     8.485    27.576     0.200
     8.494    27.227     0.200
     8.496    27.103     0.200
     8.500    27.399     0.200
     8.504    27.491     0.200
     8.518    27.427     0.200
     8.570    27.201     0.200
     9.132    25.519     0.200
     9.142    26.154     0.200
     9.158    26.297     0.200
     9.208    25.825     0.200
     9.238    30.451     0.200
     9.287    25.351     0.200
     9.496    28.000     0.200
    10.186    29.943     0.200
    12.025    28.182     0.200
    12.979    28.047     0.200
     6.146    19.129     0.200
     6.146    19.164     0.200
     6.146    19.004     0.200
     6.146    19.004     0.200
     6.146    18.817     0.200
     6.146    18.930     0.200
     6.146    19.055     0.200
     6.146    17.313     0.200
     2.547    13.133     0.200
     2.679    12.333     0.200
     2.749    12.520     0.200
     2.966    12.382     0.200
     2.976    10.875     0.200
     3.623    13.826     0.200
     3.739    14.971     0.200
     7.337    19.806     0.200
     9.885    23.645     0.200
    11.226    28.727     0.200
    12.840    28.762     0.200
    12.931    28.195     0.200
    13.118    29.516     0.200
    13.866    30.852     0.200
     1.486     8.765     0.200
     1.823    11.050     0.200
     2.799    13.025     0.200
     3.002    10.569     0.200
     3.072    13.943     0.200
     3.522    15.704     0.200
     4.520    14.859     0.200
     4.520    16.699     0.200
     4.967    15.139     0.200
     5.171    18.103     0.200
     5.726    18.400     0.200
     5.772    18.638     0.200
     5.954    20.722     0.200
     5.978    19.343     0.200
     6.134    20.725     0.200
     6.138    19.672     0.200
     6.193    19.366     0.200
     6.549    20.453     0.200
     6.946    21.140     0.200
     7.206    21.610     0.200
     7.337    19.915     0.200
     7.580    23.342     0.200
     7.864    22.427     0.200
     7.993    24.126     0.200
     7.822    25.360     0.200
     8.393    26.917     0.200
     8.426    26.926     0.200
     8.461    28.153     0.200
     8.511    27.546     0.200
     8.514    26.359     0.200
     8.518    27.048     0.200
     8.533    24.591     0.200
     8.525    26.891     0.200
     8.534    26.676     0.200
     8.529    27.074     0.200
     8.537    26.096     0.200
     8.540    26.443     0.200
     8.550    27.151     0.200
     8.548    26.851     0.200
     8.557    26.548     0.200
     8.567    24.143     0.200
     8.610    26.588     0.200
     8.681    26.559     0.200
     8.731    26.413     0.200
     8.906    26.203     0.200
     8.948    26.538     0.200
     8.957    26.527     0.200
     8.492    28.122     0.200
     9.091    26.355     0.200
     9.170    26.872     0.200
     9.179    25.529     0.200
     9.195    25.833     0.200
     9.244    26.297     0.200
     9.308    26.272     0.200
     9.323    25.439     0.200
     9.521    25.989     0.200
     9.885    24.473     0.200
     9.998    27.511     0.200
    10.669    28.620     0.200
    11.226    28.742     0.200
    12.199    27.238     0.200
    12.043    28.062     0.200
    12.390    30.008     0.200
    12.840    30.590     0.200
    12.942    28.074     0.200
    12.999    34.398     0.200
    13.118    29.516     0.200
    12.988    33.026     0.200
    13.866    30.485     0.200
    13.866    32.055     0.200
    14.935    36.808     0.200
    17.642    37.715     0.200
    12.942    32.277     0.200
    12.942    32.277     0.200
    12.942    32.277     0.200
    12.942    32.605     0.200
     6.138    19.664     0.200
     6.138    18.539     0.200
     6.138    18.539     0.200
     6.138    18.539     0.200
     6.138    18.539     0.200
     6.138    18.539     0.200
     6.138    18.539     0.200
     6.138    18.539     0.200
     6.138    17.985     0.200
     6.138    17.805     0.200
    14.935    36.300     0.200
     2.756    13.197     0.200
     3.618    14.836     0.200
     3.739    16.828     0.200
     6.139    20.293     0.200
     6.139    18.660     0.200
     6.139    17.629     0.200
     6.139    17.473     0.200
     6.139    19.121     0.200
     6.139    19.121     0.200
     6.139    20.379     0.200
     6.139    18.785     0.200
     6.139    18.918     0.200
     2.625    12.042     0.200
     2.692    14.262     0.200
     2.759    13.481     0.200
     3.130    14.297     0.200
     3.465    17.735     0.200
     3.953    15.411     0.200
     4.375    17.013     0.200
     4.581    18.324     0.200
     5.218    19.513     0.200
     5.775    21.147     0.200
     5.818    20.651     0.200
     6.025    21.589     0.200
     6.233    20.832     0.200
     6.590    22.076     0.200
     7.253    21.964     0.200
     2.719    12.941     0.200
     2.777    14.257     0.200
     3.006    14.194     0.200
     3.003    14.624     0.200
     2.079    13.410     0.200
     2.379    14.401     0.200
     2.586    12.488     0.200
     2.781    13.383     0.200
     3.046    14.333     0.200
     3.029    14.316     0.200
     3.548    16.267     0.200
     3.866    14.508     0.200
     3.764    16.744     0.200
     4.297    16.151     0.200
     4.495    17.248     0.200
     5.141    17.668     0.200
     5.697    19.784     0.200
     5.742    18.973     0.200
     5.949    20.010     0.200
     6.162    20.070     0.200
     6.163    21.139     0.200
     7.176    20.744     0.200
     7.834    22.923     0.200
    12.959    28.442     0.200
    12.959    32.004     0.200
     6.163    19.006     0.200
     6.163    19.678     0.200
     1.144     9.558     0.200
     2.564    13.484     0.200
     2.917    14.359     0.200
     3.730    15.976     0.200
     1.137     9.380     0.200
     1.185    10.417     0.200
     2.694    14.305     0.200
     1.211    11.136     0.200
     2.607    13.535     0.200
     2.741    13.471     0.200
     3.536    15.498     0.200
     6.056    19.427     0.200
     6.056    18.529     0.200
     6.056    17.966     0.200
     6.056    19.202     0.200
     6.056    19.202     0.200
     6.056    19.202     0.200
     6.056    19.579     0.200
     1.114     8.290     0.200
     2.754    13.950     0.200
     2.838    13.318     0.200
     3.094    14.534     0.200
     3.012    13.938     0.200
     3.501    16.741     0.200
     3.716    16.529     0.200
     3.917    15.515     0.200
     4.340    17.173     0.200
     4.545    17.424     0.200
     7.219    21.461     0.200
     0.860     7.105     0.200
     1.120     9.067     0.200
     1.181     8.862     0.200
     2.563    11.539     0.200
     2.630    10.966     0.200
     2.858    11.500     0.200
     2.757    12.274     0.200
     3.715    15.604     0.200
     7.367    19.727     0.200
    11.240    28.553     0.200
    12.867    30.414     0.200
    13.894    31.781     0.200
     2.828    13.206     0.200
     2.954    13.880     0.200
     3.095    14.018     0.200
     3.309    15.339     0.200
     3.498    15.527     0.200
     4.347    16.730     0.200
     4.544    16.609     0.200
     4.998    15.623     0.200
     5.192    18.055     0.200
     5.533    14.877     0.200
     5.747    18.875     0.200
     5.793    19.039     0.200
     5.999    18.995     0.200
     6.110    21.357     0.200
     6.114    19.945     0.200
     6.212    19.529     0.200
     6.569    20.664     0.200
     6.927    21.907     0.200
     7.183    22.226     0.200
     7.367    19.578     0.200
     7.226    21.233     0.200
     7.564    23.976     0.200
     7.884    22.895     0.200
     7.820    25.487     0.200
     7.979    24.637     0.200
     8.385    27.065     0.200
     8.419    27.004     0.200
     8.419    27.093     0.200
     8.451    26.803     0.200
     8.509    27.342     0.200
     8.512    26.903     0.200
     8.511    27.094     0.200
     8.532    25.856     0.200
     8.520    27.035     0.200
     8.532    26.162     0.200
     8.535    26.364     0.200
     8.523    26.955     0.200
     8.538    26.318     0.200
     8.557    26.293     0.200
     8.542    26.999     0.200
     8.566    26.647     0.200
     8.609    26.476     0.200
     8.787    23.083     0.200
     8.681    26.391     0.200
     8.731    26.298     0.200
     8.907    26.381     0.200
     8.949    26.351     0.200
     8.957    26.342     0.200
     9.093    26.171     0.200
     9.181    26.008     0.200
     9.197    26.103     0.200
     9.247    26.045     0.200
     9.326    25.882     0.200
     9.998    27.737     0.200
    10.226    28.019     0.200
    11.240    28.553     0.200
    12.061    27.202     0.200
    12.867    30.414     0.200
    12.867    31.679     0.200
    12.974    28.047     0.200
    13.151    29.874     0.200
    13.894    30.328     0.200
    14.908    35.180     0.200
    12.974    32.555     0.200
    12.974    32.555     0.200
    12.974    32.555     0.200
    12.974    32.617     0.200
     6.114    17.546     0.200
     6.114    17.007     0.200
     6.114    18.593     0.200
     6.114    17.999     0.200
     1.070     7.893     0.200
     1.149     8.324     0.200
     1.188     8.975     0.200
     2.565    11.399     0.200
     2.859    12.466     0.200
     3.317    14.125     0.200
     3.713    16.502     0.200
     5.734    17.926     0.200
     7.370    19.868     0.200
    11.242    28.235     0.200
    12.869    30.150     0.200
    12.937    28.857     0.200
    13.897    30.594     0.200
     2.028    12.174     0.200
     2.565    10.899     0.200
     2.829    13.366     0.200
     2.956    14.339     0.200
     3.097    14.027     0.200
     3.308    14.234     0.200
     3.497    15.424     0.200
     4.348    16.835     0.200
     4.546    16.617     0.200
     5.001    15.474     0.200
     5.193    17.786     0.200
     5.536    15.233     0.200
     5.734    17.925     0.200
     5.748    18.652     0.200
     5.794    18.857     0.200
     6.000    18.968     0.200
     6.213    20.434     0.200
     6.108    21.849     0.200
     6.113    20.741     0.200
     6.569    20.912     0.200
     6.927    22.002     0.200
     7.227    21.268     0.200
     7.182    23.122     0.200
     7.564    24.365     0.200
     7.885    22.775     0.200
     7.979    24.524     0.200
     8.289    26.936     0.200
     8.342    27.214     0.200
     8.384    27.472     0.200
     8.402    28.442     0.200
     8.405    27.720     0.200
     8.418    27.610     0.200
     8.418    27.327     0.200
     8.450    27.590     0.200
     8.457    28.421     0.200
     8.476    27.145     0.200
     8.511    26.929     0.200
     8.508    27.697     0.200
     8.510    27.422     0.200
     8.531    26.140     0.200
     8.534    26.571     0.200
     8.531    27.252     0.200
     8.519    27.362     0.200
     8.522    27.336     0.200
     8.537    27.384     0.200
     8.547    27.651     0.200
     8.556    26.225     0.200
     8.540    27.326     0.200
     8.608    27.041     0.200
     8.789    23.140     0.200
     8.680    26.877     0.200
     8.730    26.863     0.200
     8.906    26.382     0.200
     8.948    26.524     0.200
     8.957    26.875     0.200
     9.092    26.742     0.200
     9.171    26.390     0.200
     9.180    26.172     0.200
     9.197    26.369     0.200
     9.247    26.270     0.200
     9.277    30.593     0.200
     9.311    26.592     0.200
     9.326    26.592     0.200
     9.485    26.145     0.200
     9.918    23.797     0.200
     9.997    27.887     0.200
    10.225    28.303     0.200
    11.242    28.235     0.200
    12.869    30.150     0.200
    12.977    28.398     0.200
    13.154    30.033     0.200
    13.897    30.517     0.200
    14.905    34.890     0.200
    18.970    40.457     0.200
    12.977    32.570     0.200
    12.977    32.570     0.200
    12.977    32.570     0.200
    12.977    32.570     0.200
     0.942     8.145     0.200
     1.114     8.380     0.200
     1.220     9.147     0.200
     3.228    14.920     0.200
     7.348    21.177     0.200
     1.061     7.891     0.200
     1.169     8.718     0.200
     2.579    12.461     0.200
     2.712    13.410     0.200
     2.877    12.285     0.200
     2.755    12.905     0.200
     2.977    14.513     0.200
     3.620    16.010     0.200
     3.738    15.434     0.200
     5.747    19.969     0.200
     7.369    19.790     0.200
     8.767    23.170     0.200
    11.257    29.105     0.200
    12.036    28.394     0.200
    12.873    29.848     0.200
    13.140    29.912     0.200
    13.899    30.512     0.200
     2.053    12.094     0.200
     2.353    14.090     0.200
     2.807    13.224     0.200
     2.755    13.303     0.200
     2.968    14.821     0.200
     3.072    13.943     0.200
     3.003    14.205     0.200
     3.333    16.159     0.200
     3.522    15.355     0.200
     4.323    16.707     0.200
     4.521    16.554     0.200
     4.475    18.326     0.200
     4.998    15.733     0.200
     5.167    17.811     0.200
     5.747    19.969     0.200
     5.723    18.587     0.200
     5.768    18.840     0.200
     5.974    19.633     0.200
     5.963    19.569     0.200
     6.187    20.688     0.200
     6.133    21.086     0.200
     6.137    20.555     0.200
     6.544    20.745     0.200
     6.952    21.321     0.200
     7.207    21.948     0.200
     7.860    23.407     0.200
     8.270    27.451     0.200
     8.324    27.373     0.200
     8.365    26.935     0.200
     8.381    28.043     0.200
     8.384    27.306     0.200
     8.397    27.463     0.200
     8.398    27.043     0.200
     8.429    27.406     0.200
     8.436    28.126     0.200
     8.455    27.427     0.200
     8.486    27.788     0.200
     8.490    26.458     0.200
     8.509    26.186     0.200
     8.490    27.081     0.200
     8.512    26.440     0.200
     8.510    27.403     0.200
     8.498    27.534     0.200
     8.502    26.995     0.200
     8.516    27.470     0.200
     8.525    27.587     0.200
     8.534    26.601     0.200
     8.520    27.571     0.200
     8.586    26.762     0.200
     8.767    23.057     0.200
     8.658    26.654     0.200
     8.708    26.660     0.200
     8.883    26.724     0.200
     8.925    27.235     0.200
     8.934    26.632     0.200
     9.069    25.849     0.200
     9.148    26.423     0.200
     9.157    26.317     0.200
     9.223    26.447     0.200
     9.253    30.940     0.200
     9.287    26.508     0.200
     9.302    27.165     0.200
     9.499    26.900     0.200
     9.975    28.213     0.200
    10.201    29.213     0.200
    11.257    29.105     0.200
    11.257    29.944     0.200
    12.231    27.823     0.200
    12.873    29.828     0.200
    12.873    32.438     0.200
    12.971    28.684     0.200
    13.140    29.912     0.200
    13.140    30.674     0.200
    13.140    30.963     0.200
    13.899    30.852     0.200
    14.902    34.748     0.200
    12.971    32.071     0.200
    12.971    33.157     0.200
    12.971    32.548     0.200
    12.971    32.864     0.200
    12.971    32.583     0.200
    12.971    32.583     0.200
    12.971    32.208     0.200
     6.137    18.801     0.200
     6.137    18.188     0.200
     6.137    18.165     0.200
     6.137    18.762     0.200
     6.137    17.770     0.200
     1.136     8.235     0.200
     1.202     9.769     0.200
     2.560    11.915     0.200
     2.694    13.358     0.200
     2.852    13.013     0.200
     3.580    16.315     0.200
     3.697    15.644     0.200
    12.077    28.850     0.200
    12.871    31.591     0.200
     2.845    13.277     0.200
     2.962    14.221     0.200
     3.112    13.971     0.200
     3.292    15.376     0.200
     3.481    15.368     0.200
     4.364    16.794     0.200
     4.435    19.038     0.200
     4.561    17.030     0.200
     5.007    15.367     0.200
     5.208    17.940     0.200
     5.729    16.941     0.200
     5.729    18.961     0.200
     5.764    19.814     0.200
     5.810    18.867     0.200
     5.922    19.788     0.200
     6.016    20.001     0.200
     6.092    20.893     0.200
     6.097    20.441     0.200
     6.229    20.214     0.200
     6.911    21.541     0.200
     7.166    22.463     0.200
     7.243    21.118     0.200
     7.374    19.659     0.200
     7.901    23.656     0.200
     8.298    27.197     0.200
     8.352    27.022     0.200
     8.393    27.112     0.200
     8.413    28.141     0.200
     8.416    27.582     0.200
     8.429    27.463     0.200
     8.427    27.204     0.200
     8.461    27.335     0.200
     8.468    28.218     0.200
     8.486    27.414     0.200
     8.519    27.797     0.200
     8.523    26.776     0.200
     8.520    27.227     0.200
     8.529    27.498     0.200
     8.532    27.455     0.200
     8.542    26.345     0.200
     8.543    27.088     0.200
     8.546    26.362     0.200
     8.549    27.169     0.200
     8.550    27.206     0.200
     8.558    27.399     0.200
     8.567    26.616     0.200
     8.620    26.016     0.200
     8.692    26.715     0.200
     8.804    23.225     0.200
     8.742    26.579     0.200
     8.918    26.375     0.200
     8.960    26.308     0.200
     8.969    26.397     0.200
     9.104    26.548     0.200
     9.183    26.386     0.200
     9.193    25.963     0.200
     9.260    26.417     0.200
     9.291    30.161     0.200
     9.324    26.402     0.200
     9.339    26.377     0.200
     9.474    26.433     0.200
    10.009    28.079     0.200
    10.239    27.901     0.200
    12.237    26.989     0.200
    12.871    31.591     0.200
    12.871    31.161     0.200
    12.984    28.775     0.200
    14.904    35.363     0.200
    12.984    32.408     0.200
    12.984    32.251     0.200
    12.984    32.607     0.200
    12.984    32.673     0.200
    12.984    32.388     0.200
    12.984    32.490     0.200
    12.984    31.525     0.200
     6.097    20.070     0.200
     6.097    18.781     0.200
     6.097    18.109     0.200
     6.097    17.949     0.200
     6.097    18.984     0.200
     6.097    18.805     0.200
     6.097    18.566     0.200
     6.097    18.566     0.200
     6.097    18.566     0.200
     6.097    18.566     0.200
     6.097    18.566     0.200
     6.097    18.566     0.200
     6.097    18.898     0.200
     0.852     7.070     0.200
     1.164     9.625     0.200
     1.178     8.257     0.200
     3.001    13.485     0.200
     0.975     7.826     0.200
     1.130     8.305     0.200
     3.568    16.349     0.200
     0.880     6.945     0.200
     0.999     7.650     0.200
     1.131     9.109     0.200
     1.190     9.220     0.200
     2.547    12.383     0.200
     2.614    12.606     0.200
     1.141     8.688     0.200
     1.121     9.415     0.200
     1.172     8.922     0.200
     1.140    10.420     0.200
     1.140     9.021     0.200
     1.187    10.672     0.200
     1.144     9.042     0.200
     1.292    11.105     0.200
     0.815     6.743     0.200
     1.138    10.577     0.200
     1.092     7.951     0.200
     1.166    10.313     0.200
     1.214     9.546     0.200
     1.129     8.225     0.200
     1.145     8.134     0.200
     1.191     9.296     0.200
     1.034     7.970     0.200
     1.283     9.753     0.200
     2.445    11.898     0.200
     2.502    13.033     0.200
     2.636    12.964     0.200
     1.903    12.522     0.200
     2.901    13.773     0.200
     2.857    13.891     0.200
     3.594    14.087     0.200
     0.830     7.399     0.200
     0.949     7.504     0.200
     0.829     6.883     0.200
     1.139     9.870     0.200
     1.189     9.883     0.200
     0.835     7.002     0.200
     0.836     7.398     0.200
     0.969     7.180     0.200
     1.120     8.139     0.200
     1.160     8.563     0.200
     1.198     8.426     0.200
     2.496    11.672     0.200
     2.530    11.383     0.200
     2.597    13.294     0.200
     2.836    10.908     0.200
     3.651    14.903     0.200
     3.766    15.963     0.200
     5.698    17.145     0.200
     7.305    19.508     0.200
     8.726    23.719     0.200
    12.811    29.322     0.200
    12.883    29.563     0.200
    12.907    27.783     0.200
    13.082    29.403     0.200
    13.837    30.422     0.200
     1.075     7.559     0.200
     1.458     9.159     0.200
     2.530    11.883     0.200
     2.769    13.144     0.200
     2.771    12.573     0.200
     2.916    12.682     0.200
     3.046    13.992     0.200
     3.548    14.696     0.200
     4.302    16.628     0.200
     4.493    16.645     0.200
     4.549    16.823     0.200
     5.148    17.662     0.200
     5.698    18.094     0.200
     5.702    18.417     0.200
     5.750    18.418     0.200
     5.972    19.411     0.200
     5.954    18.748     0.200
     6.160    19.914     0.200
     6.172    19.706     0.200
     6.528    20.516     0.200
     6.968    20.095     0.200
     7.182    21.026     0.200
     7.231    20.918     0.200
     7.599    21.831     0.200
     7.842    23.064     0.200
     8.307    27.288     0.200
     8.360    27.086     0.200
     8.400    27.100     0.200
     8.410    27.864     0.200
     8.410    27.121     0.200
     8.412    27.236     0.200
     8.427    27.341     0.200
     8.433    27.337     0.200
     8.460    27.255     0.200
     8.464    27.994     0.200
     8.486    27.285     0.200
     8.675    23.665     0.200
     8.515    26.159     0.200
     8.515    25.998     0.200
     8.513    27.750     0.200
     8.513    27.227     0.200
     8.534    26.033     0.200
     8.534    25.002     0.200
     8.524    27.232     0.200
     8.538    26.090     0.200
     8.538    25.934     0.200
     8.536    26.358     0.200
     8.536    26.112     0.200
     8.531    27.349     0.200
     8.533    27.306     0.200
     8.542    26.467     0.200
     8.542    26.221     0.200
     8.552    27.444     0.200
     8.552    26.850     0.200
     8.558    26.477     0.200
     8.553    27.406     0.200
     8.609    26.013     0.200
     8.609    25.787     0.200
     8.681    26.557     0.200
     8.731    26.381     0.200
     8.905    26.473     0.200
     8.905    25.368     0.200
     8.946    26.489     0.200
     8.946    25.493     0.200
     8.956    26.398     0.200
     8.956    26.007     0.200
     9.090    25.999     0.200
     9.090    25.101     0.200
     9.168    25.878     0.200
     9.168    24.839     0.200
     9.176    25.886     0.200
     9.192    25.898     0.200
     9.240    25.875     0.200
     9.240    25.281     0.200
     9.267    30.460     0.200
     9.304    26.244     0.200
     9.318    26.227     0.200
     9.318    25.071     0.200
     9.557    26.770     0.200
     9.852    23.851     0.200
     9.997    27.491     0.200
     9.997    26.979     0.200
    10.209    28.769     0.200
    10.668    28.380     0.200
    10.668    27.848     0.200
    12.022    28.104     0.200
    12.167    26.921     0.200
    12.811    29.400     0.200
    12.883    30.063     0.200
    13.082    29.403     0.200
    13.025    31.908     0.200
    13.837    30.446     0.200
    13.837    30.954     0.200
    14.964    35.277     0.200
    12.907    32.462     0.200
    12.907    32.814     0.200
    12.907    32.853     0.200
    12.907    31.732     0.200
    12.907    31.732     0.200
    12.907    32.173     0.200
     1.173     8.891     0.200
     3.612    15.727     0.200
     0.964     7.396     0.200
     1.053     7.848     0.200
     1.112     9.165     0.200
     0.822     6.959     0.200
     0.948     8.338     0.200
     1.118     8.151     0.200
     2.583    13.047     0.200
     2.716    14.004     0.200
     3.672    15.340     0.200
     1.148     8.818     0.200
     1.185     8.186     0.200
     2.557    12.673     0.200
     2.690    13.120     0.200
     2.734    13.115     0.200
     4.499    16.314     0.200
     5.725    18.278     0.200
     7.358    19.443     0.200
     9.906    24.408     0.200
    12.859    30.226     0.200
    13.886    30.896     0.200
     2.821    13.054     0.200
     2.947    13.621     0.200
     2.984    14.193     0.200
     3.090    13.912     0.200
     3.503    16.032     0.200
     3.603    15.273     0.200
     4.343    16.724     0.200
     4.539    17.333     0.200
     4.457    18.005     0.200
     4.989    15.791     0.200
     5.188    18.329     0.200
     5.725    19.348     0.200
     5.743    18.605     0.200
     5.789    19.109     0.200
     5.940    18.692     0.200
     5.995    19.949     0.200
     6.115    20.260     0.200
     6.119    20.140     0.200
     6.209    20.210     0.200
     6.565    20.811     0.200
     6.931    19.933     0.200
     7.222    21.004     0.200
     7.188    21.133     0.200
     7.567    22.211     0.200
     7.881    23.561     0.200
     8.294    27.352     0.200
     8.348    27.273     0.200
     8.389    27.103     0.200
     8.406    27.915     0.200
     8.409    27.503     0.200
     8.422    27.344     0.200
     8.423    27.382     0.200
     8.454    27.182     0.200
     8.461    28.111     0.200
     8.480    27.325     0.200
     8.515    26.895     0.200
     8.511    27.667     0.200
     8.534    26.502     0.200
     8.515    27.419     0.200
     8.537    26.716     0.200
     8.535    27.040     0.200
     8.523    27.406     0.200
     8.541    27.055     0.200
     8.527    27.366     0.200
     8.550    27.575     0.200
     8.559    26.846     0.200
     8.545    27.423     0.200
     8.780    23.610     0.200
     8.611    25.874     0.200
     8.683    26.782     0.200
     8.733    26.373     0.200
     8.908    25.848     0.200
     8.950    27.718     0.200
     9.094    25.645     0.200
     9.173    25.285     0.200
     9.182    25.921     0.200
     9.199    25.729     0.200
     9.248    25.961     0.200
     9.278    30.651     0.200
     9.312    26.085     0.200
     9.327    26.328     0.200
     9.496    26.693     0.200
    10.000    28.762     0.200
    10.225    28.686     0.200
    12.221    27.399     0.200
    12.058    28.302     0.200
    12.859    30.956     0.200
    12.859    30.327     0.200
    12.965    28.716     0.200
    13.143    29.840     0.200
    12.964    34.730     0.200
    13.886    30.897     0.200
    14.916    34.442     0.200
    17.626    38.320     0.200
    12.965    32.431     0.200
    12.965    32.431     0.200
     6.119    18.226     0.200
     6.119    18.198     0.200
     6.119    18.652     0.200
     6.119    18.480     0.200
     6.119    18.402     0.200
     6.119    18.593     0.200
     6.119    18.593     0.200
     6.119    18.593     0.200
     1.141    10.027     0.200
     1.135     9.530     0.200
     1.176    10.325     0.200
     1.221    10.506     0.200
     1.133     9.542     0.200
     1.182     9.476     0.200
     1.105     8.828     0.200
     1.260    11.324     0.200
     1.311    10.431     0.200
     1.129     9.368     0.200
     1.064     7.972     0.200
     1.145     8.700     0.200
     1.138     8.579     0.200
     1.186     9.522     0.200
     2.690    13.169     0.200
     3.595    16.110     0.200
     1.171     8.807     0.200
     1.205    10.027     0.200
     1.170     9.114     0.200
     2.562    13.058     0.200
     2.695    13.509     0.200
     3.632    15.079     0.200
     4.528    17.119     0.200
     2.059    12.928     0.200
     2.362    14.093     0.200
     2.792    13.184     0.200
     3.532    14.843     0.200
     3.749    16.015     0.200
     4.510    17.609     0.200
     5.159    17.833     0.200
     5.714    18.833     0.200
     5.760    18.916     0.200
     5.966    19.837     0.200
     6.181    19.434     0.200
     6.148    20.821     0.200
     7.194    21.274     0.200
     6.148    18.099     0.200
     6.148    20.474     0.200
     6.148    18.903     0.200
     6.148    17.872     0.200
     6.148    18.966     0.200
     1.133     8.730     0.200
     1.134     9.115     0.200
     2.541    13.292     0.200
     2.674    13.738     0.200
     3.595    16.490     0.200
     1.134    10.443     0.200
     1.182     9.908     0.200
     2.570    11.916     0.200
     3.644    14.777     0.200
     5.738    18.196     0.200
     1.156     9.363     0.200
     2.565    11.796     0.200
     5.733    20.635     0.200
     1.136     9.880     0.200
     2.555    12.327     0.200
     1.164     9.790     0.200
     2.544    13.185     0.200
     2.677    13.638     0.200
     2.671    13.102     0.200
     2.845    13.777     0.200
     5.707    19.218     0.200
    12.020    28.999     0.200
    12.821    29.700     0.200
    13.846    32.196     0.200
     1.798    11.186     0.200
     2.771    12.873     0.200
     2.925    14.144     0.200
     4.301    15.761     0.200
     4.493    15.943     0.200
     4.745    19.407     0.200
     5.146    18.238     0.200
     5.470    13.942     0.200
     5.701    19.208     0.200
     5.707    19.217     0.200
     5.748    18.355     0.200
     5.953    19.862     0.200
     5.975    20.154     0.200
     6.170    19.731     0.200
     6.160    20.787     0.200
     6.165    19.719     0.200
     6.969    21.344     0.200
     7.181    20.261     0.200
     7.232    23.687     0.200
     7.840    22.177     0.200
     8.012    23.680     0.200
     8.298    27.740     0.200
     8.352    27.174     0.200
     8.392    27.253     0.200
     8.402    27.751     0.200
     8.405    27.284     0.200
     8.419    27.210     0.200
     8.452    27.039     0.200
     8.457    28.138     0.200
     8.478    27.233     0.200
     8.506    27.995     0.200
     8.523    27.311     0.200
     8.526    27.334     0.200
     8.545    27.353     0.200
     9.551    26.714     0.200
    10.204    30.500     0.200
    12.821    28.161     0.200
    12.821    29.700     0.200
    12.915    28.557     0.200
    13.846    32.196     0.200
    12.915    32.506     0.200
     6.165    18.680     0.200
     6.165    18.680     0.200
     6.165    18.680     0.200
     6.165    18.680     0.200
     1.160    10.663     0.200
     1.122    10.386     0.200
     2.680    13.214     0.200
     5.714    20.971     0.200
     1.136     8.313     0.200
     2.538    12.954     0.200
     2.671    13.401     0.200
     5.706    19.840     0.200
     1.136     8.813     0.200
     3.604    15.105     0.200
     4.345    16.710     0.200
     4.539    16.631     0.200
     5.190    18.421     0.200
     5.706    20.550     0.200
     5.745    20.015     0.200
     5.935    19.110     0.200
     5.997    20.324     0.200
     6.115    20.705     0.200
     6.119    20.352     0.200
     6.212    20.558     0.200
     6.569    20.902     0.200
     6.927    22.128     0.200
     7.187    22.495     0.200
     8.425    27.580     0.200
     8.438    27.077     0.200
     2.529    12.964     0.200
     5.697    22.792     0.200
     2.581    10.919     0.200
     3.027    14.108     0.200
     3.062    13.716     0.200
     2.964    10.948     0.200
     3.145    13.833     0.200
     3.402    14.584     0.200
     4.355    16.119     0.200
     4.449    15.713     0.200
     4.651    16.271     0.200
     4.555    17.475     0.200
     5.396    18.068     0.200
     5.627    18.367     0.200
     5.901    19.190     0.200
     6.098    19.873     0.200
     6.744    20.912     0.200
     7.302    22.147     0.200
     7.344    21.337     0.200
     7.552    22.047     0.200
     7.754    21.807     0.200
     7.955    19.897     0.200
     8.113    22.994     0.200
     8.415    24.434     0.200
     8.779    23.843     0.200
     9.433    25.170     0.200
     9.456    24.747     0.200
    10.498    24.031     0.200
    11.381    29.742     0.200
    13.136    32.631     0.200
    13.595    29.381     0.200
    13.757    29.990     0.200
    14.239    28.697     0.200
    14.802    37.294     0.200
    16.076    37.427     0.200
    19.689    39.271     0.200
     2.656    12.026     0.200
     2.769    11.207     0.200
     3.949    14.937     0.200
     4.142    16.282     0.200
     4.989    14.800     0.200
     5.137    17.073     0.200
     6.754    21.002     0.200
     6.759    20.285     0.200
     7.555    21.659     0.200
     7.825    23.502     0.200
     8.571    24.994     0.200
    10.005    23.768     0.200
    11.990    26.101     0.200
    12.639    28.520     0.200
    12.751    31.215     0.200
    12.751    27.865     0.200
     1.213    11.185     0.200
     1.861    11.619     0.200
     2.191    13.763     0.200
     2.470    11.010     0.200
     2.564    11.212     0.200
     2.381    13.154     0.200
     2.625    13.736     0.200
     2.915    14.213     0.200
     2.965    14.568     0.200
     3.922    15.475     0.200
     4.213    16.016     0.200
     4.993    19.071     0.200
     5.465    19.624     0.200
     5.661    20.257     0.200
     5.823    19.576     0.200
     6.065    20.562     0.200
     6.308    20.720     0.200
     6.908    21.539     0.200
     7.116    22.037     0.200
     7.754    23.243     0.200
     7.680    23.073     0.200
     8.343    23.273     0.200
     8.709    27.706     0.200
     9.025    25.135     0.200
    10.305    26.073     0.200
    13.034    28.735     0.200
    13.516    29.604     0.200
    14.117    32.787     0.200
     2.134    12.292     0.200
     2.835    14.605     0.200
     3.077    15.285     0.200
     3.408    16.426     0.200
     7.400    20.821     0.200
    12.985    29.157     0.200
     1.488    11.131     0.200
     1.538     8.801     0.200
     1.788    10.482     0.200
     2.362    13.085     0.200
     2.382    12.058     0.200
     2.535    13.663     0.200
     2.828    14.197     0.200
     3.345    14.315     0.200
     3.522    15.745     0.200
     4.932    19.149     0.200
     5.543    20.167     0.200
     5.729    20.259     0.200
     6.388    21.369     0.200
     6.943    22.432     0.200
     6.989    22.632     0.200
     7.195    22.491     0.200
     7.764    23.968     0.200
     7.692    22.120     0.200
     8.422    24.327     0.200
     9.080    25.883     0.200
     9.112    25.948     0.200
    12.948    31.087     0.200
    13.253    30.188     0.200
    13.467    30.189     0.200
    14.036    31.350     0.200
     2.047    10.505     0.200
     2.530    11.361     0.200
     2.977    13.512     0.200
     3.242    12.959     0.200
     3.430    13.864     0.200
     4.731    15.377     0.200
     4.843    16.765     0.200
     4.848    17.463     0.200
     5.610    19.386     0.200
     5.810    19.020     0.200
     5.685    17.648     0.200
     5.918    17.933     0.200
     6.453    20.534     0.200
     6.353    18.853     0.200
     7.011    21.182     0.200
     7.053    20.837     0.200
     7.261    21.764     0.200
     7.822    22.673     0.200
     7.848    22.004     0.200
     8.488    22.261     0.200
     8.585    25.209     0.200
     9.142    24.386     0.200
     9.165    24.321     0.200
    10.397    25.991     0.200
    11.331    30.958     0.200
    11.975    32.492     0.200
    13.064    28.111     0.200
    13.098    30.543     0.200
    13.305    31.123     0.200
    13.623    29.908     0.200
    14.188    32.822     0.200
    14.784    33.857     0.200
     1.500    12.199     0.200
     1.786    12.469     0.200
     2.125    13.974     0.200
     2.214    12.507     0.200
     2.073    14.811     0.200
     2.381    13.245     0.200
     2.531    12.779     0.200
     2.565    12.269     0.200
     2.484    13.511     0.200
     2.727    13.566     0.200
     2.720    13.456     0.200
     2.975    14.605     0.200
     3.051    15.590     0.200
     3.392    14.041     0.200
     3.450    15.934     0.200
     4.224    16.902     0.200
     4.605    16.855     0.200
     4.810    18.142     0.200
     5.448    19.196     0.200
     5.725    19.155     0.200
     6.006    20.491     0.200
     6.048    20.619     0.200
     6.256    20.771     0.200
     6.820    21.891     0.200
     7.510    20.930     0.200
     7.483    22.190     0.200
     8.138    24.025     0.200
     8.167    23.431     0.200
     8.865    24.742     0.200
     9.251    28.235     0.200
    10.422    29.580     0.200
    12.307    28.572     0.200
    12.966    30.140     0.200
    13.155    28.681     0.200
     1.425    10.461     0.200
     3.191    15.453     0.200
     3.165    13.756     0.200
     3.321    15.292     0.200
     3.402    15.393     0.200
     3.389    16.412     0.200
     3.462    15.799     0.200
     3.485    17.124     0.200
     4.036    16.797     0.200
     4.134    16.946     0.200
     4.591    17.513     0.200
     4.637    17.777     0.200
     4.465    18.094     0.200
     4.701    13.427     0.200
     4.765    14.587     0.200
     4.650    19.128     0.200
     4.843    17.779     0.200
     4.740    17.776     0.200
     5.061    18.533     0.200
     5.416    19.492     0.200
     6.070    20.055     0.200
     6.237    20.378     0.200
     6.723    22.232     0.200
     6.729    22.262     0.200
     6.772    21.966     0.200
     7.200    19.605     0.200
     7.077    22.109     0.200
     7.259    23.178     0.200
     7.264    23.224     0.200
     7.713    22.558     0.200
     8.079    23.908     0.200
     8.338    24.894     0.200
     9.199    28.844     0.200
    10.312    30.351     0.200
    10.913    27.343     0.200
    11.997    28.345     0.200
    12.558    28.640     0.200
    12.863    28.581     0.200
    13.824    32.871     0.200
     2.995    15.486     0.200
     3.342    13.739     0.200
     3.619    16.222     0.200
     3.684    15.840     0.200
     3.875    16.114     0.200
     3.975    16.850     0.200
     4.266    17.450     0.200
     4.530    17.164     0.200
     4.384    15.280     0.200
     5.083    17.811     0.200
     5.133    17.933     0.200
     5.336    18.161     0.200
     5.560    18.446     0.200
     5.920    19.351     0.200
     6.564    20.339     0.200
     6.779    21.526     0.200
     6.783    21.551     0.200
     7.161    18.921     0.200
     7.226    22.205     0.200
     7.272    22.665     0.200
     7.582    23.054     0.200
     7.851    24.220     0.200
     9.688    25.178     0.200
     9.675    29.128     0.200
    10.015    29.559     0.200
    11.413    27.344     0.200
    11.996    28.571     0.200
    12.641    28.716     0.200
    13.551    34.625     0.200
    16.817    37.932     0.200
     1.239    11.318     0.200
     2.181    13.324     0.200
     2.219    13.084     0.200
     2.265    13.048     0.200
     2.394    12.044     0.200
     2.531    15.441     0.200
     3.153    13.324     0.200
     3.537    13.378     0.200
     3.620    16.728     0.200
     5.032    19.444     0.200
     2.277    10.394     0.200
     3.094    13.969     0.200
     3.253    12.506     0.200
     3.409    12.802     0.200
     3.551    14.014     0.200
     3.524    15.642     0.200
     4.635    16.002     0.200
     4.503    16.418     0.200
     6.327    18.363     0.200
     6.783    19.382     0.200
     7.279    17.989     0.200
     7.128    21.177     0.200
     7.291    22.781     0.200
     8.125    23.349     0.200
     8.373    24.150     0.200
     9.126    26.591     0.200
    10.865    26.674     0.200
    12.624    26.647     0.200
    12.947    30.877     0.200
    20.201    39.119     0.200
     1.168     9.402     0.200
     2.840    12.288     0.200
     3.240    14.419     0.200
     3.667    13.200     0.200
     3.670    15.798     0.200
     3.868    15.789     0.200
     3.987    16.906     0.200
     4.220    14.999     0.200
     4.272    18.575     0.200
     4.515    16.835     0.200
     5.001    17.070     0.200
     5.070    17.665     0.200
     5.117    17.809     0.200
     5.322    17.821     0.200
     5.542    18.656     0.200
     5.897    19.615     0.200
     6.549    20.197     0.200
     6.597    20.242     0.200
     6.787    21.725     0.200
     6.886    21.003     0.200
     7.205    19.763     0.200
     7.210    21.890     0.200
     7.599    22.854     0.200
     9.641    28.425     0.200
    11.393    27.468     0.200
    12.039    26.929     0.200
    12.661    28.474     0.200
    12.680    27.454     0.200
    12.680    27.954     0.200
    12.810    27.937     0.200
    12.810    29.187     0.200
    12.933    29.687     0.200
    13.799    30.291     0.200
    14.999    36.585     0.200
    16.778    35.574     0.200
     1.083     9.554     0.200
     1.164     7.815     0.200
     1.867     9.610     0.200
     1.915    10.617     0.200
     2.312    11.575     0.200
     2.456    12.930     0.200
     2.555    11.302     0.200
     2.885    11.696     0.200
     3.310    12.890     0.200
     4.781    15.415     0.200
    13.745    32.249     0.200
    16.646    36.012     0.200
    16.646    35.515     0.200
     2.627    10.150     0.200
     2.798    13.327     0.200
     2.828    13.324     0.200
     3.028    13.727     0.200
     3.193    14.550     0.200
     3.459    14.040     0.200
     3.589    15.128     0.200
     4.047    14.485     0.200
     4.465    16.004     0.200
     4.674    15.860     0.200
     5.307    17.272     0.200
     5.793    19.671     0.200
     5.865    18.058     0.200
     5.907    18.377     0.200
     5.846    18.589     0.200
     5.983    19.782     0.200
     6.115    18.545     0.200
     6.319    19.860     0.200
     6.678    20.378     0.200
     6.823    19.585     0.200
     7.063    19.885     0.200
     7.404    20.219     0.200
     7.342    20.522     0.200
     7.499    18.927     0.200
     7.471    22.319     0.200
     7.897    22.754     0.200
     7.997    22.486     0.200
     8.783    21.711     0.200
     9.330    25.929     0.200
    10.048    25.043     0.200
    10.284    27.299     0.200
    10.284    28.099     0.200
    10.894    28.876     0.200
    11.793    29.094     0.200
    11.905    33.862     0.200
    11.935    30.321     0.200
    12.165    27.348     0.200
    12.363    27.031     0.200
    12.251    30.352     0.200
    12.385    31.058     0.200
    12.553    32.431     0.200
    12.641    31.172     0.200
    12.674    33.143     0.200
    12.981    28.323     0.200
    13.039    30.598     0.200
    12.851    32.772     0.200
    13.119    27.707     0.200
    13.235    33.842     0.200
    14.014    32.164     0.200
    14.341    31.903     0.200
    14.341    31.853     0.200
    14.795    36.154     0.200
    15.589    34.468     0.200
    16.356    36.177     0.200
    16.356    36.160     0.200
    16.356    37.830     0.200
     1.055     8.152     0.200
     1.684     9.813     0.200
     2.012    10.177     0.200
     2.642    12.529     0.200
     2.572    11.446     0.200
     2.785    12.859     0.200
     2.741    13.828     0.200
     3.001    14.136     0.200
     2.975    14.796     0.200
     3.403    14.806     0.200
     3.427    15.468     0.200
     3.547    16.070     0.200
     4.510    17.332     0.200
     4.713    17.854     0.200
     5.353    18.490     0.200
     5.737    19.990     0.200
     5.910    19.488     0.200
     5.792    19.572     0.200
     5.953    19.386     0.200
     5.942    20.120     0.200
     6.161    19.964     0.200
     6.368    20.041     0.200
     6.726    21.068     0.200
     6.773    20.426     0.200
     7.019    20.754     0.200
     7.388    21.640     0.200
     7.417    22.399     0.200
     7.468    22.514     0.200
     8.044    23.486     0.200
     8.784    22.147     0.200
    10.344    29.531     0.200
    10.628    25.934     0.200
    12.215    27.414     0.200
    12.333    27.536     0.200
    12.940    30.450     0.200
    13.098    29.105     0.200
    14.329    32.690     0.200
    16.382    37.110     0.200
    16.382    36.434     0.200
    18.995    39.785     0.200
    16.382    37.770     0.200
     2.030    11.034     0.200
     2.906    13.667     0.200
     3.183    13.474     0.200
     4.158    16.098     0.200
     4.400    18.268     0.200
     4.536    15.886     0.200
     5.127    18.283     0.200
     7.116    21.209     0.200
     7.519    20.734     0.200
     9.339    27.702     0.200
    11.095    29.032     0.200
    12.937    28.637     0.200
    16.532    37.555     0.200
    20.562    41.435     0.200
     1.109     9.021     0.200
     2.926    13.920     0.200
     3.352    13.351     0.200
     3.537    13.019     0.200
     3.548    16.844     0.200
     3.769    15.585     0.200
     4.053    16.565     0.200
     4.173    18.273     0.200
     4.321    17.746     0.200
     4.595    16.951     0.200
     5.162    18.123     0.200
     5.181    18.103     0.200
     5.401    18.839     0.200
     5.486    18.445     0.200
     5.928    19.688     0.200
     6.510    20.345     0.200
     6.678    21.831     0.200
     7.622    22.221     0.200
     7.830    22.589     0.200
     7.803    23.808     0.200
     8.646    25.869     0.200
     8.746    25.203     0.200
     9.072    24.384     0.200
     9.410    27.752     0.200
     9.410    26.979     0.200
     9.031    27.873     0.200
    11.564    29.015     0.200
    13.165    31.332     0.200
    13.434    33.197     0.200
    14.374    35.829     0.200
    14.684    33.030     0.200
    15.929    36.064     0.200
    16.171    35.471     0.200
    16.183    35.743     0.200
     2.736    13.626     0.200
     2.943    13.555     0.200
     3.305    13.783     0.200
     3.358    14.141     0.200
     3.836    14.455     0.200
     5.691    15.939     0.200
    14.233    34.260     0.200
    14.233    33.150     0.200
    16.347    38.428     0.200
    16.347    37.702     0.200
     1.375     7.856     0.200
     1.472     8.329     0.200
     1.883    13.880     0.200
     2.157    15.036     0.200
    14.247    31.694     0.200
    16.265    35.665     0.200
    20.030    38.594     0.200
     1.991    11.104     0.200
     3.083    14.452     0.200
     3.148    15.305     0.200
     3.177    12.663     0.200
     3.351    13.478     0.200
     3.386    13.905     0.200
     3.515    13.778     0.200
     3.567    16.415     0.200
     3.550    15.908     0.200
     3.657    14.555     0.200
     3.721    14.959     0.200
     3.797    15.328     0.200
     4.006    15.159     0.200
     4.123    16.823     0.200
     4.368    15.964     0.200
     4.387    16.841     0.200
     4.503    17.491     0.200
     4.556    16.223     0.200
     4.950    17.776     0.200
     4.983    17.690     0.200
     5.135    14.007     0.200
     5.195    18.411     0.200
     5.386    18.481     0.200
     6.310    19.296     0.200
     6.786    20.550     0.200
     6.893    21.992     0.200
     7.503    20.550     0.200
     7.761    21.666     0.200
     7.984    23.069     0.200
     8.292    22.673     0.200
     8.411    23.378     0.200
     8.832    24.664     0.200
     8.713    27.789     0.200
     9.378    27.999     0.200
    11.227    26.218     0.200
    12.325    30.002     0.200
    12.372    31.195     0.200
    12.452    33.108     0.200
    12.812    29.315     0.200
    12.797    31.442     0.200
    12.931    28.038     0.200
    12.968    31.716     0.200
    13.072    32.115     0.200
    13.127    32.343     0.200
    13.160    34.557     0.200
    13.180    31.569     0.200
    14.109    31.092     0.200
    15.005    33.127     0.200
    15.005    33.127     0.200
    16.537    34.238     0.200
     2.939    12.103     0.200
     3.082    13.105     0.200
     6.857    19.741     0.200
    12.225    28.229     0.200
    15.663    34.895     0.200
    17.250    37.765     0.200
    20.191    40.419     0.200
     2.745    12.372     0.200
     3.228    13.006     0.200
     3.187    14.681     0.200
     3.373    14.341     0.200
     3.475    13.656     0.200
     3.394    13.671     0.200
     3.458    15.113     0.200
     3.837    15.592     0.200
     4.022    15.217     0.200
     4.493    13.241     0.200
     4.390    16.748     0.200
     4.651    13.894     0.200
     4.605    16.783     0.200
     4.643    16.688     0.200
     4.873    17.709     0.200
     4.953    17.369     0.200
     5.225    18.299     0.200
     6.258    18.148     0.200
     7.088    19.704     0.200
     7.488    20.798     0.200
     7.469    22.204     0.200
     7.659    20.373     0.200
     7.659    21.094     0.200
     8.273    22.627     0.200
     8.327    27.773     0.200
     8.544    24.067     0.200
     8.887    24.663     0.200
     9.084    23.794     0.200
     9.074    27.585     0.200
     9.074    26.983     0.200
     9.273    25.256     0.200
    10.726    25.999     0.200
    11.068    26.509     0.200
    11.868    27.175     0.200
    12.174    28.232     0.200
    12.399    28.474     0.200
    12.772    29.121     0.200
    12.951    28.085     0.200
    13.720    30.858     0.200
    13.835    33.415     0.200
    13.835    32.056     0.200
    15.511    36.967     0.200
    17.098    37.844     0.200
    17.562    36.974     0.200
     1.352    11.184     0.200
     2.398    11.477     0.200
     2.613    13.144     0.200
     2.745    14.525     0.200
     3.571    14.183     0.200
    11.112    31.029     0.200
    12.146    33.849     0.200
     1.449    13.030     0.200
     1.994    11.671     0.200
     2.081    11.655     0.200
     2.467    11.154     0.200
     2.489    12.925     0.200
     2.489    13.034     0.200
     2.582    13.053     0.200
     2.832    14.391     0.200
     3.661    14.108     0.200
     3.661    14.459     0.200
     5.092    17.421     0.200
     5.227    19.743     0.200
     5.426    20.019     0.200
     5.550    17.840     0.200
     6.059    20.034     0.200
     6.071    20.590     0.200
     6.301    20.814     0.200
     6.628    21.289     0.200
     6.671    21.389     0.200
     6.716    22.569     0.200
     6.879    21.965     0.200
     7.085    22.066     0.200
     7.154    23.651     0.200
     7.678    22.446     0.200
    10.739    29.624     0.200
    10.951    28.861     0.200
    10.995    31.630     0.200
    10.995    30.670     0.200
    12.156    32.253     0.200
    12.156    31.923     0.200
    13.412    31.421     0.200
    13.753    34.161     0.200
    16.149    36.842     0.200
    16.149    36.731     0.200
     2.703    12.936     0.200
     2.990    14.893     0.200
     3.014    16.019     0.200
     3.362    13.852     0.200
     3.645    12.248     0.200
     3.858    15.473     0.200
     4.200    15.373     0.200
     4.283    19.014     0.200
     4.510    16.863     0.200
     4.401    16.931     0.200
     4.976    17.926     0.200
     5.064    17.903     0.200
     5.113    18.331     0.200
     5.316    18.552     0.200
     5.539    19.756     0.200
     5.893    20.122     0.200
     8.109    23.965     0.200
     9.649    28.430     0.200
    12.780    31.847     0.200
    12.904    30.400     0.200
    13.328    36.221     0.200
    15.095    35.619     0.200
    16.808    39.037     0.200
    16.808    40.166     0.200
     1.329     7.330     0.200
     1.369     6.447     0.200
     1.881     8.890     0.200
     2.152     7.551     0.200
     2.151    10.128     0.200
     2.181    11.275     0.200
     2.519     9.724     0.200
     2.690    11.040     0.200
     2.720    11.090     0.200
     2.921    11.888     0.200
     3.160    12.244     0.200
     3.351    11.865     0.200
     3.450    12.863     0.200
     3.566    12.805     0.200
     3.844    12.234     0.200
     4.303    16.903     0.200
     4.692    14.562     0.200
     5.160    16.407     0.200
     5.340    16.104     0.200
     5.685    18.135     0.200
     5.793    16.521     0.200
     5.896    17.817     0.200
     5.941    17.888     0.200
     5.961    17.155     0.200
     6.147    18.082     0.200
     6.360    18.504     0.200
     6.717    19.439     0.200
     6.780    18.403     0.200
     7.035    18.629     0.200
     7.407    17.776     0.200
     7.419    18.444     0.200
     7.837    21.968     0.200
     8.928    21.870     0.200
     9.383    21.428     0.200
    10.357    27.555     0.200
    10.357    26.754     0.200
    11.181    25.472     0.200
    11.965    31.628     0.200
    11.990    28.894     0.200
    12.272    25.107     0.200
    12.302    28.588     0.200
    12.431    28.809     0.200
    12.608    30.549     0.200
    12.733    33.323     0.200
    12.733    31.023     0.200
    12.733    32.134     0.200
    12.850    31.158     0.200
    12.899    29.971     0.200
    12.880    27.163     0.200
    12.978    31.265     0.200
    13.039    25.462     0.200
    13.258    28.108     0.200
    13.289    32.600     0.200
    14.375    29.825     0.200
    14.375    30.268     0.200
    16.442    34.298     0.200
    16.442    34.519     0.200
     3.188    14.857     0.200
     3.232    11.451     0.200
     3.770    14.665     0.200
     4.162    14.090     0.200
     4.402    15.291     0.200
     4.352    15.772     0.200
     4.916    16.899     0.200
     4.947    16.837     0.200
     5.141    16.169     0.200
     5.160    17.147     0.200
     5.347    17.466     0.200
     5.708    18.449     0.200
     6.364    17.400     0.200
     6.928    19.609     0.200
     7.540    18.918     0.200
     8.122    21.085     0.200
     8.300    20.799     0.200
     8.456    21.186     0.200
     8.879    22.746     0.200
     8.752    29.826     0.200
     9.326    27.226     0.200
     9.326    26.929     0.200
     9.872    26.454     0.200
    11.316    28.607     0.200
    11.910    28.149     0.200
    12.367    29.822     0.200
    12.359    28.437     0.200
    12.450    29.394     0.200
    12.797    30.858     0.200
    12.970    30.914     0.200
    12.957    26.961     0.200
    13.070    33.949     0.200
    13.155    32.386     0.200
    13.155    32.144     0.200
    13.179    30.707     0.200
    13.179    29.551     0.200
    13.304    30.011     0.200
    13.325    32.162     0.200
    13.419    32.210     0.200
    13.441    31.351     0.200
    13.759    33.194     0.200
    14.662    36.564     0.200
    15.014    30.353     0.200
    16.514    34.247     0.200
    16.514    34.474     0.200
    18.291    37.809     0.200
    20.094    39.664     0.200
    20.408    39.702     0.200
     2.056     9.878     0.200
     2.926    11.788     0.200
     2.926    12.226     0.200
     3.245    12.899     0.200
     3.200    13.932     0.200
     3.419    14.013     0.200
     3.455    13.230     0.200
     3.622    15.007     0.200
     3.777    14.262     0.200
     3.762    15.666     0.200
     4.074    13.920     0.200
     4.342    16.805     0.200
     4.412    16.282     0.200
     4.624    15.229     0.200
     4.906    17.523     0.200
     4.936    17.772     0.200
     5.150    18.673     0.200
     5.336    18.706     0.200
     5.697    19.585     0.200
     6.377    18.354     0.200
     6.377    19.783     0.200
     7.139    21.190     0.200
     7.548    20.040     0.200
     8.116    22.248     0.200
     8.761    28.737     0.200
     9.312    28.200     0.200
     9.312    27.802     0.200
     9.874    25.340     0.200
    11.175    27.366     0.200
    11.328    27.576     0.200
    12.366    27.959     0.200
    12.820    29.564     0.200
    12.962    28.508     0.200
    13.178    28.981     0.200
    16.509    34.659     0.200
    20.350    40.784     0.200
    20.403    41.464     0.200
     2.390    12.628     0.200
     2.307    14.147     0.200
     2.855    13.556     0.200
     2.905    14.185     0.200
     2.857    14.598     0.200
     3.074    14.801     0.200
     3.169    14.433     0.200
     3.314    14.585     0.200
     3.174    16.250     0.200
     3.694    15.481     0.200
     4.238    16.076     0.200
     4.153    17.620     0.200
     4.356    16.750     0.200
     4.448    16.173     0.200
     4.907    17.416     0.200
     4.960    17.804     0.200
     5.162    17.949     0.200
     5.391    18.568     0.200
     5.744    19.654     0.200
     5.957    19.688     0.200
     6.725    21.217     0.200
     6.743    21.800     0.200
     7.087    20.219     0.200
     6.960    22.667     0.200
     7.754    22.998     0.200
     7.952    22.008     0.200
     8.030    23.880     0.200
     8.759    24.766     0.200
     9.606    25.018     0.200
    12.530    29.357     0.200
    13.489    33.674     0.200
    15.263    33.541     0.200
    16.910    36.754     0.200
    16.932    36.598     0.200
    20.361    40.567     0.200
     2.617    12.990     0.200
     3.188    12.057     0.200
     3.220    13.767     0.200
     3.286    12.485     0.200
     3.342    12.311     0.200
     3.361    13.840     0.200
     3.361    13.440     0.200
     3.481    12.831     0.200
     3.995    14.842     0.200
     3.995    14.142     0.200
     4.570    13.562     0.200
     4.551    15.758     0.200
     4.551    15.559     0.200
     4.597    15.321     0.200
     4.597    15.521     0.200
     4.802    15.824     0.200
     4.802    15.324     0.200
     5.021    16.570     0.200
     5.021    16.170     0.200
     5.376    17.431     0.200
     6.254    17.262     0.200
     6.702    19.408     0.200
     7.192    18.221     0.200
     7.116    20.220     0.200
     7.300    20.571     0.200
     8.120    21.809     0.200
     8.379    23.087     0.200
     8.743    22.838     0.200
     9.138    23.724     0.200
     9.166    26.602     0.200
     9.166    25.702     0.200
     9.690    23.071     0.200
    10.873    25.877     0.200
    11.110    24.618     0.200
    12.541    26.415     0.200
    13.818    29.106     0.200
    13.652    32.142     0.200
    13.652    32.332     0.200
    16.945    35.392     0.200
    16.945    36.017     0.200
     1.879    10.225     0.200
     2.885    13.635     0.200
     3.050    13.504     0.200
     3.203    13.665     0.200
     3.706    15.402     0.200
     4.268    14.356     0.200
     4.361    16.456     0.200
     4.553    16.711     0.200
     4.914    17.406     0.200
     4.964    17.619     0.200
     5.167    17.750     0.200
     5.393    18.815     0.200
     5.746    19.491     0.200
     5.992    19.584     0.200
     6.767    22.502     0.200
     6.948    22.162     0.200
     7.131    20.322     0.200
     7.750    23.303     0.200
     7.974    22.203     0.200
     8.020    24.249     0.200
     8.369    24.682     0.200
     8.340    29.496     0.200
     9.650    25.530     0.200
     9.529    28.441     0.200
     9.529    28.281     0.200
    11.955    26.890     0.200
    12.573    28.419     0.200
    13.454    31.605     0.200
    16.889    37.404     0.200
    18.664    41.835     0.200
     1.282     8.925     0.200
     2.444    12.041     0.200
     2.659    13.290     0.200
     2.890    13.370     0.200
     3.191    13.929     0.200
     3.559    14.198     0.200
    11.677    31.523     0.200
    16.097    35.966     0.200
     0.958     7.323     0.200
     1.243     9.816     0.200
     1.652     9.639     0.200
     2.181    10.771     0.200
     2.265     9.687     0.200
     2.412     9.170     0.200
     2.628    11.804     0.200
     2.531    11.788     0.200
     2.636    13.351     0.200
     2.857    13.267     0.200
     3.173    13.358     0.200
     4.877    17.405     0.200
     5.030    18.222     0.200
     5.434    18.207     0.200
     5.451    18.643     0.200
     5.624    18.890     0.200
     5.847    18.583     0.200
     6.098    18.758     0.200
     6.278    19.956     0.200
     6.414    17.966     0.200
     6.834    20.368     0.200
     6.879    20.648     0.200
     7.073    20.581     0.200
     7.085    20.738     0.200
     7.295    21.397     0.200
     7.579    19.738     0.200
     7.652    22.416     0.200
     8.313    22.711     0.200
     8.557    24.018     0.200
     8.771    26.257     0.200
     8.970    24.244     0.200
     9.000    24.090     0.200
     9.422    22.981     0.200
     9.817    24.086     0.200
    10.243    24.789     0.200
    10.820    27.503     0.200
    11.209    29.117     0.200
    11.209    28.922     0.200
    12.551    28.141     0.200
    12.954    30.041     0.200
    12.974    29.527     0.200
    13.140    29.975     0.200
    13.453    29.329     0.200
    13.629    31.027     0.200
    13.629    30.566     0.200
    13.932    30.962     0.200
    14.057    31.776     0.200
    14.880    34.169     0.200
    15.892    33.639     0.200
    16.148    34.818     0.200
    16.148    34.874     0.200
    16.148    34.273     0.200
    19.183    39.454     0.200
     1.121    11.279     0.200
     1.504    12.152     0.200
     1.528     9.926     0.200
     2.101    11.448     0.200
     2.222    13.045     0.200
     2.297    12.755     0.200
     2.406    11.885     0.200
     2.518    13.970     0.200
     2.621    13.572     0.200
     2.852    13.661     0.200
     4.911    19.751     0.200
     5.413    18.556     0.200
     5.977    21.212     0.200
    16.131    36.384     0.200
     1.255    10.299     0.200
     1.821    13.631     0.200
     2.115    14.950     0.200
     2.521    15.910     0.200
     3.379    15.693     0.200
     3.497    15.016     0.200
     3.848    14.579     0.200
    10.402    29.431     0.200
    12.360    31.437     0.200
    12.624    32.618     0.200
    16.388    38.883     0.200
     2.646    13.062     0.200
     2.670    13.122     0.200
     2.754    14.088     0.200
     3.085    13.505     0.200
     3.259    14.945     0.200
     3.302    12.919     0.200
     3.580    16.623     0.200
     3.881    17.041     0.200
     4.135    14.572     0.200
     4.543    17.019     0.200
     5.095    17.977     0.200
     5.336    18.563     0.200
     5.348    18.213     0.200
     5.576    19.360     0.200
     5.929    19.738     0.200
     6.575    20.597     0.200
     7.123    19.596     0.200
     7.239    22.148     0.200
     7.288    22.573     0.200
     8.321    28.879     0.200
    10.035    25.421     0.200
    12.608    28.598     0.200
    12.960    31.999     0.200
    13.111    32.170     0.200
    16.850    39.594     0.200
    16.850    39.062     0.200
     2.844    13.425     0.200
     3.015    13.660     0.200
     3.025    13.815     0.200
     3.176    13.605     0.200
     3.670    13.316     0.200
     3.849    16.093     0.200
     4.498    17.231     0.200
     4.778    16.858     0.200
     5.052    18.059     0.200
     5.100    18.402     0.200
     5.292    18.663     0.200
     5.304    18.216     0.200
     5.525    19.642     0.200
     5.880    19.902     0.200
     5.970    18.983     0.200
     6.532    20.291     0.200
     6.805    23.396     0.200
     7.196    20.016     0.200
     7.192    22.483     0.200
     7.236    22.675     0.200
     7.880    24.161     0.200
     9.722    24.855     0.200
     9.628    27.157     0.200
    10.010    26.605     0.200
    10.339    27.836     0.200
    12.667    28.290     0.200
    12.935    32.167     0.200
    13.090    32.822     0.200
    16.792    39.531     0.200
    16.792    37.770     0.200
     1.973    10.000     0.200
     2.212    12.473     0.200
     2.871    12.506     0.200
     3.057    14.316     0.200
     3.126    12.047     0.200
     3.157    14.789     0.200
     3.147    14.798     0.200
     3.460    14.633     0.200
     3.531    15.420     0.200
     3.768    14.855     0.200
     3.768    15.656     0.200
     4.371    16.823     0.200
     4.506    15.295     0.200
     4.932    17.674     0.200
     4.968    17.656     0.200
     5.006    17.103     0.200
     5.166    18.540     0.200
     5.179    18.092     0.200
     5.376    18.288     0.200
     5.376    19.487     0.200
     6.406    19.673     0.200
     6.785    19.846     0.200
     7.056    21.985     0.200
     7.080    21.703     0.200
     7.432    21.257     0.200
     7.767    21.989     0.200
     8.642    29.362     0.200
     9.397    27.164     0.200
     9.950    25.484     0.200
    10.466    26.463     0.200
    11.203    26.790     0.200
    11.220    27.584     0.200
    11.801    29.590     0.200
    12.254    28.535     0.200
    12.433    31.680     0.200
    12.511    30.062     0.200
    12.511    30.632     0.200
    12.750    30.492     0.200
    12.855    31.231     0.200
    12.855    30.910     0.200
    12.860    28.949     0.200
    13.023    30.289     0.200
    13.058    30.747     0.200
    13.131    35.648     0.200
    13.220    32.641     0.200
    13.238    31.274     0.200
    13.218    31.270     0.200
    13.474    33.790     0.200
    13.474    32.821     0.200
    13.502    36.219     0.200
    13.819    34.638     0.200
    14.769    35.171     0.200
    16.607    35.991     0.200
    16.607    34.729     0.200
    20.474    40.995     0.200
    20.564    40.888     0.200
     1.159    11.458     0.200
     3.754    16.534     0.200
    11.992    30.627     0.200
    16.095    36.482     0.200
     2.778    14.023     0.200
     3.105    13.608     0.200
     3.206    15.229     0.200
     3.405    16.403     0.200
     4.052    16.163     0.200
     4.340    18.700     0.200
     4.605    17.898     0.200
     4.654    17.629     0.200
     4.845    19.095     0.200
     4.858    17.855     0.200
     5.083    18.927     0.200
     5.436    19.404     0.200
     6.085    20.126     0.200
     6.747    21.706     0.200
     6.795    22.144     0.200
     7.252    23.616     0.200
     7.700    20.832     0.200
     8.060    24.680     0.200
     8.327    25.374     0.200
    16.980    40.018     0.200
     2.646    13.118     0.200
     2.858    13.985     0.200
     3.228    13.355     0.200
     3.474    14.610     0.200
     3.779    13.969     0.200
     3.796    15.609     0.200
     3.970    15.769     0.200
     4.290    14.938     0.200
     4.664    15.568     0.200
     5.193    17.604     0.200
     5.247    17.672     0.200
     5.435    17.877     0.200
     5.448    17.929     0.200
     5.680    18.717     0.200
     6.032    19.508     0.200
     6.684    21.800     0.200
     6.674    20.114     0.200
     6.808    20.843     0.200
     7.340    21.744     0.200
     7.394    22.418     0.200
     7.750    23.663     0.200
     8.448    22.000     0.200
     8.264    27.981     0.200
     9.606    24.442     0.200
     9.819    27.714     0.200
    10.012    23.662     0.200
    10.204    27.356     0.200
    12.583    28.159     0.200
    12.659    29.273     0.200
    13.324    32.430     0.200
    13.337    34.392     0.200
    13.337    34.831     0.200
    13.543    35.007     0.200
    15.061    33.523     0.200
    15.061    33.324     0.200
    15.139    39.429     0.200
    16.874    39.241     0.200
    16.874    39.644     0.200
    16.874    38.134     0.200
    16.874    36.759     0.200
    18.877    42.809     0.200
    20.618    39.446     0.200
    20.627    39.784     0.200
     3.383    15.670     0.200
     4.251    18.666     0.200
     4.724    15.020     0.200
     7.156    18.546     0.200
     7.162    21.270     0.200
     8.237    22.520     0.200
    12.543    26.270     0.200
    15.388    33.544     0.200
    16.931    36.730     0.200
    16.931    36.701     0.200
     2.724    13.480     0.200
     2.826    13.179     0.200
     3.036    15.739     0.200
     3.156    12.796     0.200
     3.359    12.966     0.200
     3.643    15.751     0.200
     3.652    13.351     0.200
     3.836    15.699     0.200
     3.908    16.632     0.200
     4.015    17.807     0.200
     4.208    14.660     0.200
     4.305    17.929     0.200
     4.489    16.881     0.200
     5.042    17.622     0.200
     5.091    17.746     0.200
     5.283    17.915     0.200
     5.295    17.971     0.200
     5.295    17.768     0.200
     5.518    18.465     0.200
     5.872    19.735     0.200
     5.950    17.732     0.200
     6.522    19.848     0.200
     6.619    19.226     0.200
     6.818    21.897     0.200
     7.167    20.083     0.200
     7.184    21.426     0.200
     7.230    21.893     0.200
     7.891    23.379     0.200
     8.101    22.183     0.200
     8.369    29.425     0.200
     9.633    28.352     0.200
    10.036    24.940     0.200
    11.371    28.470     0.200
    12.617    28.766     0.200
    12.638    26.684     0.200
    12.775    30.079     0.200
    13.348    33.194     0.200
    13.347    31.900     0.200
    13.347    32.743     0.200
    13.573    34.567     0.200
    13.763    29.750     0.200
    15.116    33.367     0.200
    15.116    33.465     0.200
    16.821    37.860     0.200
    16.821    36.810     0.200
    19.905    39.370     0.200
     1.363     7.656     0.200
     1.924     7.645     0.200
     1.812     8.815     0.200
     2.044    10.461     0.200
     2.127    10.124     0.200
     2.348    11.338     0.200
     2.715    12.171     0.200
     3.113    12.353     0.200
     5.106    17.280     0.200
     5.271    17.850     0.200
     5.433    18.261     0.200
     5.981    19.262     0.200
     6.136    19.262     0.200
     6.466    19.203     0.200
     6.525    19.722     0.200
     6.587    20.292     0.200
     6.770    20.353     0.200
     6.783    20.104     0.200
     7.028    20.342     0.200
     7.378    21.460     0.200
     8.007    21.815     0.200
     8.680    23.467     0.200
     8.743    23.425     0.200
     8.900    24.865     0.200
    10.430    28.683     0.200
    11.128    29.671     0.200
    11.516    27.486     0.200
    12.657    34.235     0.200
    12.657    33.321     0.200
    12.657    32.891     0.200
    12.750    33.737     0.200
    12.861    29.329     0.200
    12.862    28.457     0.200
    12.832    33.031     0.200
    12.999    31.409     0.200
    14.193    31.912     0.200
    14.193    31.448     0.200
    16.717    34.995     0.200
    16.717    35.683     0.200
    16.717    35.573     0.200
    18.465    39.641     0.200
     1.251    11.281     0.200
     2.080    10.005     0.200
     2.591    11.040     0.200
     2.715    13.790     0.200
     3.038    13.694     0.200
     3.611    13.569     0.200
     4.483    15.263     0.200
     4.583    16.897     0.200
     5.428    17.135     0.200
     6.070    19.136     0.200
     6.715    19.821     0.200
     7.272    20.812     0.200
     7.314    20.730     0.200
     7.510    21.443     0.200
     7.522    21.395     0.200
     7.723    21.248     0.200
     7.959    21.864     0.200
     8.083    22.353     0.200
     8.120    22.518     0.200
     8.418    22.043     0.200
     8.750    22.972     0.200
     9.403    24.345     0.200
     9.425    23.893     0.200
     9.460    26.687     0.200
    10.267    23.718     0.200
    10.582    25.282     0.200
    11.035    29.817     0.200
    11.306    29.750     0.200
    11.387    29.039     0.200
    11.647    30.662     0.200
    11.706    29.113     0.200
    11.706    30.270     0.200
    11.706    30.500     0.200
    11.815    32.225     0.200
    11.873    31.120     0.200
    11.874    29.908     0.200
    12.030    28.394     0.200
    12.152    31.267     0.200
    13.149    31.028     0.200
    13.220    29.805     0.200
    13.220    30.004     0.200
    13.757    30.676     0.200
    13.759    29.716     0.200
    13.848    32.800     0.200
    14.662    30.909     0.200
    14.783    37.766     0.200
    15.620    36.217     0.200
    15.900    36.748     0.200
    15.921    36.979     0.200
    15.921    35.280     0.200
    16.167    35.066     0.200
    16.210    34.812     0.200
    16.735    35.453     0.200
    17.482    37.824     0.200
    19.033    39.527     0.200
     3.087    12.988     0.200
     3.399    14.763     0.200
     3.475    13.882     0.200
     4.126    15.074     0.200
     4.270    15.840     0.200
     4.679    15.521     0.200
     4.666    15.381     0.200
     4.729    16.137     0.200
     4.920    16.119     0.200
     4.932    16.370     0.200
     5.159    16.921     0.200
     6.159    18.447     0.200
     6.114    18.482     0.200
     6.822    19.915     0.200
     6.872    20.134     0.200
     6.976    20.821     0.200
     7.115    18.623     0.200
     7.181    20.428     0.200
     7.759    19.806     0.200
     7.985    21.849     0.200
     8.254    23.001     0.200
     9.321    26.456     0.200
     9.321    26.354     0.200
    10.309    25.125     0.200
    10.309    23.422     0.200
    10.713    27.105     0.200
    11.012    25.717     0.200
    10.998    25.084     0.200
    11.043    24.062     0.200
    11.774    26.078     0.200
    12.243    26.056     0.200
    12.368    27.725     0.200
    12.499    26.902     0.200
    12.501    27.508     0.200
    12.597    29.281     0.200
    12.769    28.779     0.200
    13.281    28.907     0.200
    13.602    32.793     0.200
    13.618    33.807     0.200
    13.765    28.367     0.200
    13.852    33.974     0.200
    13.953    29.893     0.200
    14.396    28.980     0.200
    15.090    36.628     0.200
    15.123    30.734     0.200
    15.423    33.644     0.200
    16.051    33.329     0.200
    16.950    36.564     0.200
    16.973    37.249     0.200
    16.973    34.828     0.200
    16.973    36.851     0.200
    16.973    36.101     0.200
    18.202    36.780     0.200
    18.553    40.819     0.200
    18.754    40.379     0.200
    19.740    39.964     0.200
     2.889    12.290     0.200
     3.018    12.588     0.200
     3.073    14.457     0.200
     3.115    13.672     0.200
     3.242    13.636     0.200
     3.387    16.286     0.200
     3.390    13.871     0.200
     3.485    14.638     0.200
     4.140    15.798     0.200
     4.259    16.802     0.200
     4.400    15.476     0.200
     4.655    19.483     0.200
     4.692    16.553     0.200
     4.743    16.757     0.200
     4.933    16.941     0.200
     4.946    16.994     0.200
     5.174    17.932     0.200
     6.173    19.073     0.200
     6.836    20.731     0.200
     6.887    21.139     0.200
     7.170    21.440     0.200
     7.971    22.689     0.200
     8.242    24.322     0.200
     8.323    28.958     0.200
     9.340    26.517     0.200
     9.340    27.717     0.200
    10.310    25.589     0.200
    10.988    26.227     0.200
    11.032    24.894     0.200
    11.027    26.126     0.200
    11.772    26.975     0.200
    12.230    27.290     0.200
    12.488    27.419     0.200
    12.490    27.550     0.200
    12.490    28.090     0.200
    12.591    29.683     0.200
    12.752    30.407     0.200
    13.271    29.236     0.200
    13.605    33.838     0.200
    13.755    29.922     0.200
    13.944    31.793     0.200
    14.386    30.457     0.200
    15.111    32.349     0.200
    15.421    34.649     0.200
    16.043    36.022     0.200
    16.983    38.470     0.200
    18.498    41.604     0.200
    18.738    42.200     0.200
    20.003    40.335     0.200
    20.172    41.897     0.200
    20.360    40.424     0.200
    20.603    40.576     0.200
    20.817    40.073     0.200
     2.115     9.887     0.200
     2.910     9.076     0.200
     3.040    11.353     0.200
     3.096    11.040     0.200
     3.096    11.150     0.200
     3.195    11.321     0.200
     3.270    12.366     0.200
     3.404    11.998     0.200
     3.409    13.043     0.200
     3.464    12.508     0.200
     3.849    11.205     0.200
     4.117    13.491     0.200
     4.281    12.911     0.200
     4.422    12.731     0.200
     4.669    14.238     0.200
     4.720    14.451     0.200
     4.676    15.255     0.200
     4.910    14.631     0.200
     4.923    14.585     0.200
     5.150    15.526     0.200
     6.150    16.764     0.200
     6.813    18.323     0.200
     6.863    18.440     0.200
     6.984    17.523     0.200
     7.108    17.241     0.200
     7.747    18.638     0.200
     8.264    20.178     0.200
     8.332    26.105     0.200
     9.315    24.019     0.200
    10.988    24.027     0.200
    11.034    22.490     0.200
    11.003    24.423     0.200
    11.762    23.355     0.200
    11.913    25.801     0.200
    12.235    24.981     0.200
    12.489    25.404     0.200
    12.491    24.557     0.200
    12.586    26.331     0.200
    12.762    26.993     0.200
    13.614    30.158     0.200
    13.755    26.810     0.200
    13.777    31.050     0.200
    13.942    28.122     0.200
    13.864    32.539     0.200
    14.386    27.978     0.200
    15.114    28.949     0.200
    15.098    34.841     0.200
    16.041    32.120     0.200
    16.983    32.883     0.200
    18.752    37.268     0.200
    18.762    38.705     0.200
    19.729    36.983     0.200
    20.026    37.557     0.200
     2.437    11.951     0.200
     2.526    14.013     0.200
     2.728    12.397     0.200
     2.668    13.457     0.200
     3.217    12.404     0.200
     3.557    14.953     0.200
     3.898    14.250     0.200
     4.022    16.255     0.200
     3.957    17.819     0.200
     4.195    15.931     0.200
     4.869    17.571     0.200
     5.419    18.451     0.200
     5.473    18.521     0.200
     5.661    18.623     0.200
     5.674    18.775     0.200
     5.905    20.479     0.200
     6.460    21.405     0.200
     6.901    20.960     0.200
     7.109    19.807     0.200
     7.241    21.892     0.200
     7.566    22.593     0.200
     7.524    23.286     0.200
     7.618    23.387     0.200
    10.020    29.225     0.200
    11.199    26.785     0.200
    11.079    31.619     0.200
    11.758    29.133     0.200
    12.233    30.404     0.200
    12.291    28.182     0.200
    12.664    28.691     0.200
    12.666    27.681     0.200
    12.666    28.181     0.200
    12.660    30.250     0.200
    12.926    29.680     0.200
    13.168    35.228     0.200
    13.490    30.427     0.200
    13.381    33.810     0.200
    13.954    31.498     0.200
    14.196    32.056     0.200
    14.590    32.432     0.200
    15.240    33.635     0.200
    16.284    37.888     0.200
    16.794    37.940     0.200
    16.794    36.675     0.200
     2.497    10.381     0.200
     2.490    14.360     0.200
     2.661    13.419     0.200
     2.700    13.726     0.200
     2.905    14.300     0.200
     2.959    15.702     0.200
     3.326    14.168     0.200
     3.810    14.281     0.200
     4.156    15.315     0.200
     4.786    17.871     0.200
     5.434    19.107     0.200
     5.989    20.021     0.200
     6.035    20.094     0.200
     6.228    20.934     0.200
     6.453    20.616     0.200
     6.687    21.978     0.200
     7.468    22.263     0.200
     8.126    23.786     0.200
     8.160    23.495     0.200
    12.627    32.332     0.200
    16.407    39.144     0.200
     2.506    12.151     0.200
     3.109    11.482     0.200
     3.133    13.835     0.200
     3.254    10.817     0.200
     3.397    12.970     0.200
     3.397    13.970     0.200
     3.437    13.310     0.200
     3.437    14.310     0.200
     3.427    14.886     0.200
     3.485    13.742     0.200
     3.523    13.626     0.200
     3.523    14.626     0.200
     3.742    16.229     0.200
     3.785    14.917     0.200
     3.849    14.796     0.200
     4.045    14.520     0.200
     4.337    15.878     0.200
     4.393    15.026     0.200
     4.389    15.969     0.200
     4.578    16.062     0.200
     4.630    16.515     0.200
     4.612    17.287     0.200
     4.823    17.012     0.200
     5.128    17.247     0.200
     5.818    18.396     0.200
     6.482    19.944     0.200
     6.537    19.705     0.200
     7.071    18.614     0.200
     7.311    20.376     0.200
     7.434    20.431     0.200
     7.523    21.895     0.200
     8.325    22.447     0.200
     8.597    22.665     0.200
     9.036    26.741     0.200
     9.036    26.541     0.200
     9.112    24.014     0.200
    10.676    25.451     0.200
    10.852    26.252     0.200
    10.923    24.296     0.200
    11.055    27.777     0.200
    11.518    25.819     0.200
    11.907    28.241     0.200
    12.129    27.197     0.200
    12.163    26.228     0.200
    12.367    26.328     0.200
    12.369    25.950     0.200
    12.369    27.329     0.200
    12.394    26.140     0.200
    12.760    28.530     0.200
    13.495    32.983     0.200
    13.517    32.349     0.200
    13.621    28.088     0.200
    13.664    31.839     0.200
    13.785    28.771     0.200
    13.786    33.668     0.200
    13.854    34.010     0.200
    13.854    33.151     0.200
    13.884    31.909     0.200
    13.884    32.565     0.200
    13.884    32.163     0.200
    13.909    33.649     0.200
    14.029    33.573     0.200
    14.126    33.550     0.200
    14.249    28.519     0.200
    15.010    29.645     0.200
    15.159    35.087     0.200
    15.494    30.436     0.200
    15.720    33.940     0.200
    15.887    32.189     0.200
    17.110    36.293     0.200
    17.132    36.761     0.200
    17.133    37.852     0.200
    17.133    37.250     0.200
    17.133    37.852     0.200
    18.031    37.825     0.200
    18.425    40.969     0.200
    19.201    39.316     0.200
    19.397    39.129     0.200
    19.765    39.333     0.200
    19.769    39.191     0.200
    19.978    39.354     0.200
    19.978    38.904     0.200
    20.462    38.801     0.200
    20.772    40.707     0.200
    20.809    39.573     0.200
     2.903    14.434     0.200
     3.151    13.666     0.200
     3.116    14.336     0.200
     3.415    15.598     0.200
     3.688    14.582     0.200
     3.768    15.756     0.200
     3.821    17.138     0.200
     4.033    14.246     0.200
     4.012    16.407     0.200
     4.156    16.239     0.200
     4.356    16.106     0.200
     4.584    15.629     0.200
     4.919    17.537     0.200
     4.951    16.959     0.200
     5.151    18.119     0.200
     5.353    17.760     0.200
     6.820    19.947     0.200
     6.925    21.526     0.200
     7.512    20.367     0.200
     7.794    21.672     0.200
     8.115    21.690     0.200
     8.016    22.490     0.200
     9.344    27.492     0.200
     9.344    27.094     0.200
    10.486    27.164     0.200
    11.211    29.587     0.200
    11.432    26.842     0.200
    11.471    25.752     0.200
    12.201    29.246     0.200
    12.655    27.265     0.200
    12.801    29.665     0.200
    12.757    28.800     0.200
    12.930    29.062     0.200
    12.931    28.824     0.200
    13.036    28.662     0.200
    13.140    27.388     0.200
    13.140    30.294     0.200
    13.026    31.442     0.200
    13.026    29.918     0.200
    13.172    33.896     0.200
    13.172    32.474     0.200
    13.184    33.582     0.200
    13.195    32.322     0.200
    13.195    32.673     0.200
    13.195    33.454     0.200
    13.341    34.046     0.200
    13.716    30.216     0.200
    13.717    31.416     0.200
    14.198    30.752     0.200
    14.390    31.510     0.200
    14.830    31.077     0.200
    14.689    36.607     0.200
    15.924    35.429     0.200
    16.489    37.631     0.200
    16.538    36.566     0.200
    18.319    40.158     0.200
    19.762    39.812     0.200
    19.998    40.956     0.200
    20.346    39.799     0.200
    20.350    39.653     0.200
    20.430    39.914     0.200
    20.433    40.479     0.200
    20.631    40.465     0.200
    20.648    40.566     0.200
     2.481    12.737     0.200
     2.497    12.382     0.200
     3.223    12.198     0.200
     3.586    13.838     0.200
     4.753    16.128     0.200
     4.882    16.316     0.200
     5.713    18.824     0.200
     5.953    19.113     0.200
    16.055    36.750     0.200
     1.112     8.579     0.200
     1.368     8.856     0.200
     2.632    13.705     0.200
     2.868    12.946     0.200
     3.200    14.079     0.200
     3.445    14.318     0.200
     3.938    14.041     0.200
     4.036    15.014     0.200
     4.664    16.987     0.200
     5.300    18.070     0.200
     5.858    19.561     0.200
     5.849    19.260     0.200
     5.900    19.772     0.200
     5.992    20.291     0.200
     6.095    19.792     0.200
     6.313    20.544     0.200
     6.828    20.535     0.200
     7.071    20.905     0.200
     7.335    22.020     0.200
     7.480    19.279     0.200
     8.920    22.315     0.200
     9.348    23.135     0.200
     9.535    24.953     0.200
    10.284    29.701     0.200
    10.284    29.301     0.200
    11.612    25.577     0.200
    11.649    25.941     0.200
    12.159    29.523     0.200
    12.659    30.807     0.200
    12.659    31.731     0.200
    12.659    31.958     0.200
    12.676    28.409     0.200
    12.692    33.272     0.200
    12.692    32.403     0.200
    12.748    28.129     0.200
    12.815    30.870     0.200
    12.868    32.450     0.200
    12.963    29.154     0.200
    13.099    28.670     0.200
    13.100    30.541     0.200
    13.100    28.701     0.200
    13.098    30.704     0.200
    13.415    28.799     0.200
    13.940    30.572     0.200
    14.357    32.174     0.200
    14.357    32.176     0.200
    14.397    31.653     0.200
    14.658    31.847     0.200
    14.813    37.358     0.200
    15.034    32.179     0.200
    16.353    37.061     0.200
    16.357    35.133     0.200
    16.375    36.511     0.200
    16.375    36.320     0.200
    16.375    36.099     0.200
    16.375    36.095     0.200
    16.375    36.500     0.200
    18.946    42.415     0.200
    18.982    40.076     0.200
    19.818    40.693     0.200
     1.154     8.775     0.200
     2.426    12.926     0.200
     3.184    13.418     0.200
     5.584    18.334     0.200
     6.199    21.000     0.200
     6.612    19.728     0.200
     6.850    20.902     0.200
     7.218    21.402     0.200
    17.234    39.736     0.200
     1.650    10.444     0.200
     2.110    13.098     0.200
     2.200    12.124     0.200
     2.285    10.732     0.200
     2.458    12.819     0.200
     2.620    13.321     0.200
     4.878    17.775     0.200
     5.009    17.751     0.200
     5.444    18.972     0.200
     5.639    19.297     0.200
     5.843    19.714     0.200
     6.086    20.080     0.200
     6.287    21.126     0.200
     6.888    21.623     0.200
     7.082    22.147     0.200
     7.660    23.409     0.200
     7.737    22.078     0.200
     7.922    24.299     0.200
     8.322    23.379     0.200
     8.547    24.551     0.200
     8.730    23.824     0.200
     8.978    25.022     0.200
     9.005    25.113     0.200
     9.840    25.214     0.200
     9.821    27.540     0.200
     9.821    27.891     0.200
    10.859    29.326     0.200
    11.200    29.698     0.200
    11.200    29.799     0.200
    11.346    31.299     0.200
    11.369    32.176     0.200
    11.631    31.491     0.200
    11.727    32.000     0.200
    11.961    32.619     0.200
    12.028    32.496     0.200
    12.028    31.059     0.200
    12.028    32.137     0.200
    12.028    32.801     0.200
    12.097    27.534     0.200
    12.116    31.950     0.200
    12.168    29.621     0.200
    12.175    29.594     0.200
    12.193    33.707     0.200
    12.200    30.082     0.200
    12.208    32.729     0.200
    12.208    29.784     0.200
    12.207    32.431     0.200
    12.290    30.038     0.200
    12.328    32.681     0.200
    12.371    31.702     0.200
    12.371    32.132     0.200
    12.384    31.048     0.200
    12.634    32.922     0.200
    12.935    28.914     0.200
    12.962    31.821     0.200
    13.020    31.532     0.200
    12.989    31.481     0.200
    13.145    31.626     0.200
    13.122    31.917     0.200
    13.495    29.356     0.200
    13.497    29.992     0.200
    13.497    29.484     0.200
    13.593    32.317     0.200
    13.593    32.067     0.200
    13.998    31.255     0.200
    14.383    31.185     0.200
    14.815    32.854     0.200
    14.835    35.972     0.200
    15.138    34.844     0.200
    15.456    32.494     0.200
    16.071    35.919     0.200
    16.071    35.348     0.200
    16.080    35.130     0.200
    16.102    36.174     0.200
    16.102    35.620     0.200
    16.102    36.057     0.200
    16.102    36.065     0.200
    16.102    35.792     0.200
    17.200    37.522     0.200
    17.996    38.592     0.200
     2.755    12.396     0.200
     3.168    13.368     0.200
     3.180    13.633     0.200
     3.203    13.909     0.200
     3.380    13.804     0.200
     3.474    13.677     0.200
     4.013    14.612     0.200
     4.370    15.840     0.200
     4.569    15.828     0.200
     4.562    14.646     0.200
     4.614    15.493     0.200
     4.807    16.241     0.200
     5.038    16.446     0.200
     5.393    17.607     0.200
     6.047    17.971     0.200
     6.707    19.676     0.200
     6.750    20.077     0.200
     7.099    19.595     0.200
     7.198    18.235     0.200
     7.282    20.461     0.200
     7.692    19.994     0.200
     8.102    21.891     0.200
     8.361    22.977     0.200
     8.428    25.443     0.200
     9.179    25.925     0.200
     9.653    22.415     0.200
    10.329    24.701     0.200
    10.474    24.696     0.200
    10.822    27.895     0.200
    10.890    25.175     0.200
    10.890    25.345     0.200
    11.042    23.725     0.200
    11.098    23.867     0.200
    11.246    25.881     0.200
    12.549    26.446     0.200
    12.551    26.277     0.200
    12.551    26.556     0.200
    12.614    26.235     0.200
    12.664    31.754     0.200
    12.864    29.302     0.200
    13.341    29.709     0.200
    13.636    32.853     0.200
    13.636    32.410     0.200
    13.810    28.354     0.200
    13.987    28.964     0.200
    15.013    37.539     0.200
    15.181    30.090     0.200
    15.464    33.979     0.200
    15.464    34.251     0.200
    16.088    32.352     0.200
    16.911    35.736     0.200
    16.934    37.268     0.200
    16.934    37.803     0.200
    16.934    37.268     0.200
    20.003    39.011     0.200
    20.009    39.539     0.200
    20.213    38.259     0.200
    20.204    38.764     0.200
    20.442    39.190     0.200
     1.076     7.324     0.200
     2.430    10.660     0.200
     4.882    16.249     0.200
     4.995    17.335     0.200
     5.141    18.524     0.200
     5.146    18.172     0.200
     5.318    17.759     0.200
     5.512    17.596     0.200
     5.965    19.416     0.200
     6.162    19.507     0.200
     6.212    19.132     0.200
     6.719    20.719     0.200
     6.763    20.403     0.200
     6.957    20.334     0.200
     6.970    20.789     0.200
     7.178    20.959     0.200
     7.536    22.081     0.200
     7.674    21.142     0.200
     8.197    21.964     0.200
     8.673    24.815     0.200
     8.824    25.543     0.200
     8.854    24.001     0.200
     8.883    24.262     0.200
     9.715    23.954     0.200
     9.929    29.536     0.200
    10.690    27.788     0.200
    10.884    27.453     0.200
    11.024    28.368     0.200
    11.093    28.873     0.200
    11.253    29.078     0.200
    11.440    30.165     0.200
    11.564    28.119     0.200
    11.728    28.978     0.200
    11.798    27.091     0.200
    11.828    31.257     0.200
    12.055    32.618     0.200
    12.125    30.645     0.200
    12.125    30.227     0.200
    12.125    30.524     0.200
    12.207    30.595     0.200
    12.207    30.771     0.200
    12.219    30.536     0.200
    12.289    31.613     0.200
    12.290    32.725     0.200
    12.307    32.865     0.200
    12.438    30.860     0.200
    12.490    29.876     0.200
    12.983    29.097     0.200
    13.023    30.847     0.200
    13.023    29.425     0.200
    13.338    31.086     0.200
    13.421    29.405     0.200
    13.421    30.316     0.200
    13.704    31.366     0.200
    13.704    31.811     0.200
    13.704    31.663     0.200
    13.864    31.639     0.200
    13.912    32.056     0.200
    13.925    32.762     0.200
    14.505    32.217     0.200
    14.770    35.784     0.200
    14.855    35.972     0.200
    14.876    33.114     0.200
    15.020    34.435     0.200
    15.489    34.692     0.200
    15.663    34.755     0.200
    16.136    35.642     0.200
    16.158    35.025     0.200
    16.158    35.767     0.200
    16.158    35.259     0.200
    16.158    35.263     0.200
    16.158    35.880     0.200
    16.158    35.658     0.200
    18.121    38.571     0.200
    18.121    37.719     0.200
    19.436    39.711     0.200
     2.439    12.033     0.200
     4.875    15.904     0.200
     5.005    16.189     0.200
     5.018    17.631     0.200
     5.442    17.686     0.200
     5.635    17.932     0.200
     5.842    17.820     0.200
     6.088    18.446     0.200
     6.842    20.045     0.200
     6.886    20.331     0.200
     7.081    20.664     0.200
     7.093    20.716     0.200
     7.301    20.896     0.200
     7.659    21.813     0.200
     7.907    22.168     0.200
     8.321    22.091     0.200
     8.549    22.091     0.200
     8.745    22.136     0.200
     8.977    23.731     0.200
     9.834    26.821     0.200
     9.834    26.129     0.200
    10.336    25.438     0.200
    10.616    28.081     0.200
    10.760    26.491     0.200
    10.918    27.642     0.200
    11.206    28.303     0.200
    11.190    27.552     0.200
    11.362    29.532     0.200
    11.507    27.935     0.200
    11.646    29.990     0.200
    11.741    30.534     0.200
    11.976    30.950     0.200
    12.044    28.167     0.200
    12.044    30.417     0.200
    12.044    30.061     0.200
    12.044    31.050     0.200
    12.132    31.956     0.200
    12.132    31.370     0.200
    12.132    30.116     0.200
    12.208    30.024     0.200
    12.225    31.342     0.200
    12.222    31.173     0.200
    12.343    30.969     0.200
    12.389    30.502     0.200
    12.389    30.022     0.200
    12.398    29.430     0.200
    12.398    29.914     0.200
    12.649    30.821     0.200
    13.146    28.375     0.200
    13.146    28.816     0.200
    13.480    29.188     0.200
    13.606    30.372     0.200
    13.606    31.040     0.200
    13.606    30.813     0.200
    13.606    30.231     0.200
    14.854    34.251     0.200
    14.854    34.790     0.200
    16.089    33.585     0.200
    16.089    33.398     0.200
    16.089    33.734     0.200
    16.099    34.585     0.200
    16.120    34.293     0.200
    16.120    34.817     0.200
    16.120    34.821     0.200
    16.120    34.473     0.200
    16.120    34.817     0.200
    17.851    37.872     0.200
    17.998    37.308     0.200
    17.998    36.944     0.200
    19.077    39.457     0.200
    19.499    38.746     0.200
    19.959    38.380     0.200
     2.459     9.906     0.200
     2.606    11.217     0.200
     2.668    12.121     0.200
     2.882    11.317     0.200
     3.276    11.981     0.200
     3.735    13.167     0.200
     4.397    14.691     0.200
     4.830    17.135     0.200
     5.026    16.946     0.200
     5.470    19.372     0.200
     5.627    19.432     0.200
     6.230    19.692     0.200
     6.275    19.376     0.200
     6.469    19.713     0.200
     6.481    19.863     0.200
     6.449    20.040     0.200
     6.691    19.719     0.200
     6.700    21.209     0.200
     7.049    20.945     0.200
     7.536    19.770     0.200
     7.709    21.039     0.200
     8.366    23.175     0.200
    12.453    29.642     0.200
    16.314    32.987     0.200
     1.005     8.051     0.200
     2.546    13.058     0.200
     2.976    15.666     0.200
     3.491    16.521     0.200
    12.610    32.219     0.200
    16.373    37.146     0.200
     1.681    11.198     0.200
     2.590    13.985     0.200
     3.740    15.253     0.200
     3.794    15.975     0.200
     4.258    17.163     0.200
     4.637    17.441     0.200
     5.195    18.129     0.200
     5.237    18.243     0.200
     5.432    18.762     0.200
     5.445    18.616     0.200
     5.652    19.994     0.200
     6.010    19.923     0.200
     6.672    20.392     0.200
     7.058    19.852     0.200
     7.327    22.146     0.200
     7.359    23.374     0.200
    13.124    33.792     0.200
    16.611    37.018     0.200
     2.081    12.184     0.200
     2.940    13.433     0.200
     3.284    15.075     0.200
     4.113    15.773     0.200
     4.031    15.914     0.200
     7.175    21.603     0.200
     6.943    21.279     0.200
     6.948    21.118     0.200
     7.589    21.555     0.200
     7.826    22.570     0.200
     8.128    22.950     0.200
     8.037    22.408     0.200
     8.803    29.714     0.200
    10.509    27.317     0.200
    11.120    28.579     0.200
    11.498    27.008     0.200
    11.541    25.924     0.200
    11.549    32.414     0.200
    12.243    30.973     0.200
    12.042    31.373     0.200
    12.729    28.152     0.200
    12.475    31.963     0.200
    12.506    32.041     0.200
    12.998    29.096     0.200
    13.000    28.698     0.200
    13.092    30.409     0.200
    13.157    33.412     0.200
    13.157    33.166     0.200
    13.547    30.086     0.200
    13.781    30.258     0.200
    14.265    30.505     0.200
    14.453    29.628     0.200
    15.000    35.715     0.200
    15.000    35.715     0.200
    15.618    30.545     0.200
    16.473    37.598     0.200
    20.546    39.852     0.200
     2.599    13.644     0.200
     2.828    12.175     0.200
     3.297    15.122     0.200
     3.818    15.410     0.200
     3.812    16.279     0.200
     4.249    16.982     0.200
     4.447    16.868     0.200
     5.094    17.424     0.200
     5.649    18.745     0.200
     5.695    18.908     0.200
     5.766    19.681     0.200
     5.888    19.050     0.200
     5.901    18.809     0.200
     6.115    19.509     0.200
     6.212    20.776     0.200
     6.471    20.850     0.200
     7.025    21.286     0.200
     7.128    21.079     0.200
     7.281    21.498     0.200
     7.345    19.051     0.200
     7.787    23.098     0.200
     7.823    22.973     0.200
     8.695    23.894     0.200
     9.742    26.485     0.200
    10.138    28.758     0.200
    10.138    27.453     0.200
    11.282    30.096     0.200
    11.542    26.350     0.200
    11.964    28.351     0.200
    12.123    33.067     0.200
    12.478    31.508     0.200
    12.615    32.363     0.200
    12.682    30.688     0.200
    12.746    30.471     0.200
    12.751    30.571     0.200
    12.778    32.355     0.200
    12.827    30.110     0.200
    12.861    29.160     0.200
    12.868    32.497     0.200
    12.868    32.301     0.200
    12.868    32.028     0.200
    12.894    35.318     0.200
    12.904    31.599     0.200
    12.934    28.029     0.200
    12.934    27.380     0.200
    13.023    31.557     0.200
    13.075    30.913     0.200
    13.080    34.054     0.200
    13.148    32.568     0.200
    13.460    35.136     0.200
    13.725    31.647     0.200
    13.715    32.169     0.200
    13.985    33.017     0.200
    14.085    32.912     0.200
    14.420    34.578     0.200
    14.578    33.051     0.200
    14.578    32.950     0.200
    14.620    34.002     0.200
    14.789    32.299     0.200
    14.915    36.516     0.200
    14.915    36.117     0.200
    15.099    36.877     0.200
    15.246    35.388     0.200
    16.516    35.525     0.200
    16.532    36.337     0.200
    16.532    36.111     0.200
    16.532    35.869     0.200
    16.532    35.744     0.200
    17.543    38.386     0.200
    20.211    40.003     0.200
     2.472    11.498     0.200
     3.302    14.996     0.200
     4.141    15.804     0.200
     4.578    17.309     0.200
     4.771    17.854     0.200
     5.423    18.647     0.200
     5.707    19.527     0.200
     5.978    20.371     0.200
     5.882    20.884     0.200
     5.887    20.035     0.200
     6.024    20.535     0.200
     6.217    20.477     0.200
     6.230    20.729     0.200
     6.800    21.570     0.200
     6.696    21.790     0.200
     6.954    20.779     0.200
     7.404    20.707     0.200
     7.404    20.871     0.200
     7.457    22.709     0.200
     8.116    24.318     0.200
     8.152    24.206     0.200
     8.896    25.571     0.200
     8.998    24.381     0.200
     9.345    24.374     0.200
     9.413    26.881     0.200
    10.442    27.277     0.200
    10.771    29.514     0.200
    11.138    28.986     0.200
    11.241    29.509     0.200
    11.547    30.130     0.200
    11.688    30.533     0.200
    11.697    31.633     0.200
    12.293    28.577     0.200
    12.222    33.109     0.200
    12.655    32.657     0.200
    12.655    32.133     0.200
    13.051    30.833     0.200
    14.323    33.778     0.200
    14.323    33.582     0.200
    16.417    37.646     0.200
    16.437    38.510     0.200
    16.437    37.026     0.200
    16.437    39.409     0.200
     1.620    11.518     0.200
     2.579    13.263     0.200
     3.282    14.746     0.200
     3.282    16.527     0.200
     4.280    17.115     0.200
     5.876    19.454     0.200
     6.675    20.436     0.200
     6.901    19.295     0.200
     7.179    20.830     0.200
     7.478    21.365     0.200
     7.746    23.028     0.200
     8.233    22.814     0.200
    13.250    33.437     0.200
    16.775    36.032     0.200
     2.634    11.901     0.200
     2.694    11.475     0.200
     2.831    11.831     0.200
     3.137    13.104     0.200
     3.165    11.534     0.200
     3.165    12.233     0.200
     3.238    13.178     0.200
     3.227    10.733     0.200
     3.323    10.879     0.200
     3.455    12.752     0.200
     3.467    13.314     0.200
     3.839    15.595     0.200
     3.977    12.965     0.200
     4.082    14.434     0.200
     4.548    14.096     0.200
     4.639    15.533     0.200
     4.761    13.771     0.200
     4.808    13.848     0.200
     4.877    15.557     0.200
     4.889    15.610     0.200
     5.103    16.212     0.200
     5.459    17.260     0.200
     6.117    17.688     0.200
     6.247    18.596     0.200
     6.813    19.257     0.200
     7.037    19.045     0.200
     7.209    20.635     0.200
     7.214    20.672     0.200
     7.242    17.137     0.200
     7.562    21.168     0.200
     7.771    20.273     0.200
     7.921    20.436     0.200
     8.036    21.487     0.200
     8.036    21.788     0.200
     8.290    23.331     0.200
     8.661    21.725     0.200
     9.003    22.287     0.200
     9.221    25.302     0.200
     9.230    23.249     0.200
     9.745    23.325     0.200
    10.731    26.125     0.200
    10.753    26.125     0.200
    10.954    23.531     0.200
    10.954    24.582     0.200
    10.954    25.074     0.200
    11.304    25.917     0.200
    11.923    28.992     0.200
    11.929    27.718     0.200
    11.910    28.263     0.200
    11.958    28.749     0.200
    12.032    28.604     0.200
    12.310    27.989     0.200
    12.343    29.730     0.200
    12.724    28.829     0.200
    12.852    28.911     0.200
    12.840    27.814     0.200
    12.900    27.344     0.200
    13.192    30.111     0.200
    13.207    30.268     0.200
    13.224    30.741     0.200
    13.224    30.640     0.200
    13.372    31.489     0.200
    13.477    31.316     0.200
    13.600    30.127     0.200
    13.559    31.654     0.200
    13.559    28.768     0.200
    13.559    34.240     0.200
    13.569    30.995     0.200
    13.864    28.948     0.200
    14.276    32.580     0.200
    14.310    31.288     0.200
    14.826    33.663     0.200
    14.966    35.319     0.200
    15.385    33.841     0.200
    15.385    33.790     0.200
    16.867    34.855     0.200
    16.870    36.472     0.200
    16.870    36.043     0.200
    17.789    37.586     0.200
    18.417    39.139     0.200
    20.042    38.382     0.200
    20.201    39.457     0.200
    20.284    37.653     0.200
    20.657    38.392     0.200
     2.329    12.629     0.200
     2.411    12.609     0.200
     2.409    12.628     0.200
     2.856    13.139     0.200
     4.879    18.701     0.200
     5.691    19.029     0.200
     5.945    20.368     0.200
     8.692    23.808     0.200
    11.985    32.842     0.200
    16.123    35.982     0.200
    18.942    40.770     0.200
     2.494    12.558     0.200
     2.906    13.648     0.200
     3.321    14.149     0.200
     3.423    15.982     0.200
     3.800    14.320     0.200
     4.160    18.869     0.200
     4.206    15.393     0.200
     4.638    16.749     0.200
     4.836    17.347     0.200
     4.836    17.550     0.200
     4.836    18.147     0.200
     5.116    15.848     0.200
     5.483    18.597     0.200
     5.654    19.036     0.200
     5.656    18.571     0.200
     5.773    17.515     0.200
     5.818    20.084     0.200
     5.823    19.519     0.200
     6.039    19.209     0.200
     6.083    19.387     0.200
     6.083    19.489     0.200
     6.083    19.688     0.200
     6.277    19.023     0.200
     6.290    19.579     0.200
     6.501    19.916     0.200
     6.639    19.998     0.200
     6.858    20.746     0.200
     6.892    21.654     0.200
     7.425    20.463     0.200
     7.457    19.957     0.200
     7.517    21.954     0.200
     8.175    23.083     0.200
     8.175    23.282     0.200
     8.207    23.201     0.200
     8.950    25.586     0.200
     9.067    23.800     0.200
     9.276    23.031     0.200
    10.009    25.440     0.200
    10.480    27.782     0.200
    10.480    28.892     0.200
    11.066    26.925     0.200
    11.135    26.294     0.200
    11.477    27.354     0.200
    11.867    30.753     0.200
    12.193    31.175     0.200
    12.318    31.686     0.200
    12.348    27.578     0.200
    12.348    28.597     0.200
    12.348    27.839     0.200
    12.469    31.363     0.200
    12.502    32.033     0.200
    12.545    31.674     0.200
    12.559    31.767     0.200
    12.577    31.483     0.200
    12.586    32.023     0.200
    12.586    31.324     0.200
    12.586    31.902     0.200
    12.631    31.812     0.200
    12.666    31.843     0.200
    12.784    31.153     0.200
    12.788    32.178     0.200
    12.868    31.977     0.200
    12.872    32.345     0.200
    12.904    29.585     0.200
    13.111    27.313     0.200
    13.183    32.300     0.200
    13.266    31.889     0.200
    13.331    33.043     0.200
    13.371    33.248     0.200
    13.469    33.460     0.200
    13.647    32.364     0.200
    13.702    31.876     0.200
    13.849    32.974     0.200
    14.252    32.192     0.200
    14.252    32.051     0.200
    14.347    33.483     0.200
    14.410    33.767     0.200
    14.875    35.283     0.200
    14.973    34.791     0.200
    16.360    34.650     0.200
    16.381    35.227     0.200
    16.381    38.114     0.200
    16.381    35.051     0.200
    16.381    34.805     0.200
    17.426    38.793     0.200
    17.470    36.799     0.200
    18.049    38.140     0.200
    18.853    41.882     0.200
    19.274    41.713     0.200
    19.508    39.778     0.200
    19.638    40.390     0.200
    19.638    40.582     0.200
    19.645    40.492     0.200
    19.933    41.537     0.200
    20.197    40.875     0.200
    20.465    41.020     0.200
    20.587    40.288     0.200
    20.594    39.987     0.200
    20.594    40.835     0.200
    20.691    40.106     0.200
    20.691    40.305     0.200
    20.892    41.177     0.200
    20.896    40.650     0.200
    21.000    38.931     0.200
    21.000    40.786     0.200
     3.441    16.039     0.200
    12.565    32.799     0.200
    16.342    38.407     0.200
    19.996    40.266     0.200
     1.214     8.774     0.200
     0.944     7.215     0.200
     0.955     7.124     0.200
     1.180     8.057     0.200
     3.971    16.516     0.200
     1.237     9.100     0.200
     1.178     8.869     0.200
     1.383     9.550     0.200
     1.116     8.090     0.200
     1.226     8.955     0.200
     1.272     9.000     0.200
     1.307     9.408     0.200
     1.373     9.912     0.200
     1.098     8.506     0.200
     1.139     8.882     0.200
     1.156     8.772     0.200
     1.208     9.044     0.200
     1.277     9.726     0.200
     1.140     8.896     0.200
     1.154     8.427     0.200
     1.285     8.923     0.200
     1.261     8.857     0.200
     1.308     9.973     0.200
     1.390    10.052     0.200
     1.428    10.821     0.200
     1.427    10.546     0.200
     0.976     8.187     0.200
     1.419    10.235     0.200
     2.549    12.911     0.200
     2.960    14.193     0.200
     3.376    14.350     0.200
     3.719    15.315     0.200
     3.855    14.722     0.200
     4.198    15.745     0.200
     4.623    17.382     0.200
     4.826    17.609     0.200
     5.466    18.741     0.200
     5.709    19.506     0.200
     5.834    20.020     0.200
     5.834    21.091     0.200
     6.023    20.538     0.200
     6.066    19.841     0.200
     6.261    19.764     0.200
     6.273    19.719     0.200
     6.480    21.106     0.200
     6.838    21.725     0.200
     7.503    20.144     0.200
     7.501    22.293     0.200
     8.105    22.269     0.200
     8.156    24.245     0.200
     8.186    23.904     0.200
     8.870    23.678     0.200
     9.070    23.916     0.200
     9.266    24.922     0.200
     9.369    25.989     0.200
     9.369    26.594     0.200
     9.752    24.841     0.200
    10.055    25.404     0.200
    10.442    28.325     0.200
    10.442    29.067     0.200
    11.086    29.604     0.200
    11.150    30.506     0.200
    11.141    29.757     0.200
    11.605    29.774     0.200
    11.784    28.894     0.200
    11.856    31.441     0.200
    11.857    32.382     0.200
    12.166    31.346     0.200
    12.294    32.582     0.200
    12.294    30.762     0.200
    12.326    28.764     0.200
    12.326    29.186     0.200
    12.326    28.635     0.200
    12.326    29.002     0.200
    12.432    31.902     0.200
    12.474    32.775     0.200
    12.506    31.698     0.200
    12.518    32.288     0.200
    12.519    32.213     0.200
    12.540    31.644     0.200
    12.559    32.570     0.200
    12.559    32.172     0.200
    12.559    33.031     0.200
    12.559    32.289     0.200
    12.601    33.588     0.200
    12.601    33.076     0.200
    12.632    31.770     0.200
    12.648    29.301     0.200
    12.691    32.606     0.200
    12.750    31.933     0.200
    12.750    31.831     0.200
    12.690    32.343     0.200
    12.762    33.071     0.200
    12.830    32.344     0.200
    12.844    33.015     0.200
    12.955    28.748     0.200
    13.152    30.135     0.200
    13.155    33.422     0.200
    13.234    32.004     0.200
    13.242    31.255     0.200
    13.303    33.758     0.200
    13.337    32.759     0.200
    13.436    33.351     0.200
    13.611    33.787     0.200
    13.746    34.058     0.200
    14.105    31.348     0.200
    14.077    31.919     0.200
    14.188    32.630     0.200
    14.234    33.022     0.200
    14.234    32.921     0.200
    14.234    33.163     0.200
    14.226    36.107     0.200
    14.324    33.436     0.200
    14.372    34.867     0.200
    14.739    39.176     0.200
    14.796    35.124     0.200
    14.824    36.238     0.200
    14.944    35.926     0.200
    16.316    35.729     0.200
    16.337    36.658     0.200
    16.337    36.178     0.200
    16.337    36.057     0.200
    16.337    36.252     0.200
    16.733    39.583     0.200
    17.380    39.707     0.200
    17.495    37.640     0.200
    18.021    39.426     0.200
    18.356    39.314     0.200
    19.045    42.578     0.200
    19.318    42.867     0.200
    19.558    41.369     0.200
    19.686    41.422     0.200
    19.981    41.928     0.200
    20.064    40.278     0.200
    20.245    41.236     0.200
    20.514    41.048     0.200
    20.634    41.298     0.200
    20.842    42.242     0.200
     1.432    10.175     0.200
     1.493    11.251     0.200
     1.260     9.556     0.200
     1.006     7.621     0.200
     1.145     8.342     0.200
     1.233     9.436     0.200
     1.347     9.715     0.200
     1.393    10.307     0.200
     1.429    10.660     0.200
     1.419    10.865     0.200
     1.384     9.352     0.200
     2.477    13.478     0.200
     2.505    12.448     0.200
     2.943    15.310     0.200
     2.914    14.021     0.200
     3.333    13.461     0.200
     3.457    15.781     0.200
     3.815    14.003     0.200
     4.172    14.562     0.200
     4.195    18.638     0.200
     4.604    17.225     0.200
     4.801    18.418     0.200
     5.448    19.374     0.200
     5.666    19.521     0.200
     6.004    19.884     0.200
     6.048    20.461     0.200
     6.255    20.852     0.200
     6.466    20.193     0.200
     6.823    21.524     0.200
     7.482    22.226     0.200
     8.173    23.575     0.200
    12.608    33.157     0.200
    16.391    38.159     0.200
    18.836    40.683     0.200
     1.214     8.626     0.200
     1.223     9.065     0.200
     1.331     9.486     0.200
     1.380    10.209     0.200
     1.414    10.352     0.200
     1.413    10.032     0.200
     1.480    10.505     0.200
     1.371     9.428     0.200
     1.239     8.910     0.200
     2.953    14.878     0.200
     3.314    13.887     0.200
     1.070     7.652     0.200
     1.079     8.413     0.200
     1.158     8.793     0.200
     1.218     9.684     0.200
     1.244     9.224     0.200
     1.249     9.132     0.200
     1.297     9.690     0.200
     1.295     9.433     0.200
     1.325     9.561     0.200
     1.058     7.946     0.200
     1.195     9.178     0.200
     1.110     8.767     0.200
     1.043     7.960     0.200
     1.094     8.333     0.200
     1.099     8.635     0.200
     1.177     9.019     0.200
     1.212     9.023     0.200
     1.232     9.470     0.200
     1.322     9.742     0.200
     1.370    10.043     0.200
     1.405    10.291     0.200
     1.402    10.040     0.200
     1.471    10.680     0.200
     1.148     8.494     0.200
     1.099     8.529     0.200
     1.113     8.681     0.200
     1.213     9.075     0.200
     1.267     9.409     0.200
     1.287     9.845     0.200
     1.288     9.634     0.200
     1.338     9.563     0.200
     1.407    10.147     0.200
     1.073     8.449     0.200
     0.930     7.598     0.200
     1.071     7.880     0.200
     1.095     8.180     0.200
     1.142     8.422     0.200
     1.210     8.837     0.200
     0.772     6.531     0.200
     0.805     6.376     0.200
     0.871     7.106     0.200
     0.878     7.001     0.200
     1.321    10.147     0.200
     0.864     6.539     0.200
     1.760     9.146     0.200
     1.850     9.340     0.200
     2.560    11.762     0.200
     2.930    12.658     0.200
     3.305    13.034     0.200
     4.553    16.217     0.200
     4.980    17.034     0.200
     5.182    17.177     0.200
     5.310    15.337     0.200
     5.477    17.959     0.200
     5.477    19.369     0.200
     5.624    18.297     0.200
     5.823    18.395     0.200
     6.251    17.287     0.200
     6.380    19.987     0.200
     6.423    19.096     0.200
     6.618    20.215     0.200
     6.630    20.169     0.200
     6.835    20.079     0.200
     7.194    21.196     0.200
     7.617    19.182     0.200
     7.858    21.545     0.200
     8.513    23.101     0.200
     8.539    23.391     0.200
     8.933    26.034     0.200
     9.012    23.362     0.200
     9.137    22.399     0.200
    10.171    25.585     0.200
    10.267    28.421     0.200
    10.374    26.285     0.200
    10.730    26.051     0.200
    10.730    26.972     0.200
    10.942    26.009     0.200
    10.942    30.189     0.200
    11.102    28.201     0.200
    11.135    26.888     0.200
    11.223    27.552     0.200
    11.288    27.305     0.200
    11.288    28.566     0.200
    11.893    28.313     0.200
    11.893    30.895     0.200
    12.274    30.374     0.200
    12.307    29.291     0.200
    12.307    31.865     0.200
    12.307    31.670     0.200
    12.356    28.576     0.200
    12.395    32.402     0.200
    12.680    27.563     0.200
    13.939    31.604     0.200
    13.939    32.034     0.200
    13.939    31.573     0.200
    16.184    35.921     0.200
    16.184    36.093     0.200
    16.209    35.380     0.200
    16.209    35.252     0.200
    16.209    34.916     0.200
    16.209    35.072     0.200
     2.214    11.304     0.200
     3.134    13.791     0.200
     5.082    18.417     0.200
     8.601    23.643     0.200
    10.843    30.258     0.200
    10.881    27.629     0.200
    10.997    29.251     0.200
    11.747    31.908     0.200
    13.688    33.165     0.200
    13.688    32.295     0.200
    16.169    36.326     0.200
    16.199    38.839     0.200
    16.199    39.325     0.200
    18.051    37.633     0.200
     1.179     9.082     0.200
     1.275     9.436     0.200
     1.063     8.001     0.200
     1.334     9.664     0.200
     1.396    10.041     0.200
     3.673    15.792     0.200
     4.187    16.451     0.200
     1.354    10.063     0.200
     1.421    10.602     0.200
     1.065     7.995     0.200
     1.112     8.499     0.200
     1.201     8.629     0.200
     1.151     8.713     0.200
     1.327     9.708     0.200
     1.383     9.685     0.200
     1.424    10.205     0.200
     1.355     9.699     0.200
     1.461    10.510     0.200
     1.204     8.395     0.200
     1.211     8.699     0.200
     1.214     8.553     0.200
     1.388     9.711     0.200
     1.300    10.008     0.200
     1.348     9.584     0.200
     1.439    10.600     0.200
     1.321     9.672     0.200
     1.896     9.975     0.200
     3.191    16.251     0.200
     1.000     7.619     0.200
     1.216     8.690     0.200
     1.257     8.758     0.200
     1.300     9.338     0.200
     1.143     8.552     0.200
     1.166     8.717     0.200
     1.188     9.320     0.200
     1.243     9.783     0.200
     1.252     9.415     0.200
     1.274     9.304     0.200
     1.337     9.654     0.200
     1.062     7.396     0.200
     1.193     7.938     0.200
     1.214     8.650     0.200
     1.381     9.919     0.200
     1.449     9.794     0.200
     1.519     9.779     0.200
     1.419    10.001     0.200
     0.618     5.980     0.200
     0.690     5.680     0.200
     0.868     6.111     0.200
     0.896     7.205     0.200
     1.419    10.330     0.200
     1.490    10.801     0.200
     1.348     9.278     0.200
     1.493    10.334     0.200
     0.898     7.309     0.200
     1.094     8.402     0.200
     1.111     8.577     0.200
     1.136     8.714     0.200
     1.215     9.471     0.200
     1.429    10.479     0.200
     1.329     9.324     0.200
     1.461    10.268     0.200
     1.584    11.250     0.200
     0.997     9.171     0.200
     1.085     8.682     0.200
     1.258    10.152     0.200
     1.264     9.187     0.200
     1.334    10.287     0.200
     1.094     8.623     0.200
     1.144     8.370     0.200
     1.239     8.561     0.200
     1.272     9.128     0.200
     1.273     9.090     0.200
     1.354     9.099     0.200
     0.908     7.306     0.200
     2.295    11.687     0.200
     0.638     5.544     0.200
     0.685     6.135     0.200
     0.793     6.102     0.200
     0.862     6.303     0.200
     1.132     7.534     0.200
     1.305     9.589     0.200
     1.338     9.340     0.200
     1.358    10.151     0.200
     1.135     9.018     0.200
     0.727     6.194     0.200
     0.915     6.967     0.200
     1.034     7.956     0.200
     1.169     8.199     0.200
     1.221     8.906     0.200
     1.077     8.312     0.200
     1.159     8.806     0.200
     1.305    10.537     0.200
     1.388    10.156     0.200
     1.453    10.054     0.200
     0.941     6.959     0.200
     1.150     8.477     0.200
     1.235     8.561     0.200
     1.277     9.131     0.200
     1.209     8.984     0.200
     1.237     9.028     0.200
     1.360    10.122     0.200
     1.397     9.778     0.200
     1.400    10.626     0.200
     1.420    10.520     0.200
     1.440    10.249     0.200
     1.507    11.043     0.200
     1.134     8.620     0.200
     1.213     8.733     0.200
     1.239     9.005     0.200
     1.386    10.151     0.200
     1.411    10.259     0.200
     1.437    10.080     0.200
     1.475    11.093     0.200
     0.910     7.370     0.200
     1.137     8.984     0.200
     1.218     8.882     0.200
     1.307     9.385     0.200
     1.377     9.551     0.200
     1.141     8.414     0.200
     1.189     8.735     0.200
     1.126     8.557     0.200
     1.269     8.944     0.200
     1.320     9.265     0.200
     1.353     9.946     0.200
     1.085     7.884     0.200
     1.163     8.526     0.200
     1.201     8.782     0.200
     1.236     8.769     0.200
     1.332     8.991     0.200
     1.310     9.472     0.200
     1.337     9.389     0.200
     1.458    10.477     0.200
     1.631    11.598     0.200
     2.058    14.791     0.200
     1.999    12.840     0.200
     2.395    15.798     0.200
     3.134    15.927     0.200
     1.241     8.900     0.200
     1.307     9.372     0.200
     1.327     9.256     0.200
     1.327     9.732     0.200
     1.345     9.725     0.200
     1.227     9.361     0.200
     1.304     9.988     0.200
     1.465    11.044     0.200
     1.517    11.544     0.200
     1.019     8.307     0.200
     1.047     7.907     0.200
     1.287     9.556     0.200
     0.954     6.684     0.200
     1.118     7.313     0.200
     1.340     9.777     0.200
     1.372    10.280     0.200
     1.412    10.773     0.200
     1.444    10.570     0.200
     1.601    11.576     0.200
     1.586    12.002     0.200
     2.545    13.996     0.200
     2.712    14.678     0.200
     2.772    14.675     0.200
     2.888    14.882     0.200
     3.542    16.640     0.200
     3.735    16.885     0.200
     4.248    16.970     0.200
     1.106     8.457     0.200
     1.175     8.725     0.200
     1.212     9.165     0.200
     1.306     9.436     0.200
     1.424    10.579     0.200
     0.978    11.231     0.200
     1.216     9.227     0.200
     1.472    10.757     0.200
     0.861     6.936     0.200
     0.856     6.938     0.200
     0.969     7.626     0.200
     0.937     7.342     0.200
     0.975     7.577     0.200
     0.978     8.123     0.200
     0.998     7.525     0.200
     1.020     9.129     0.200
     1.024     7.899     0.200
     1.047     8.490     0.200
     1.077     8.546     0.200
     1.083     9.749     0.200
     1.092     7.988     0.200
     1.104     9.696     0.200
     1.160     8.914     0.200
     1.173     8.534     0.200
     1.276     9.737     0.200
     1.378    10.192     0.200
     1.385    10.230     0.200
     1.116     8.362     0.200
     1.141     8.479     0.200
     1.127     8.774     0.200
     1.194     8.852     0.200
     1.202     8.939     0.200
     1.284     9.406     0.200
     1.312    10.490     0.200
     1.335     8.941     0.200
     1.372    10.063     0.200
     1.368     9.843     0.200
     1.325     8.696     0.200
     1.416     9.258     0.200
     2.996    15.368     0.200
     4.121    14.787     0.200
     4.244    18.704     0.200
     4.750    18.337     0.200
     4.750    18.439     0.200
     5.403    18.919     0.200
     5.958    20.043     0.200
     6.004    20.204     0.200
     6.004    20.306     0.200
     6.197    20.453     0.200
     6.424    20.701     0.200
     6.781    21.439     0.200
     8.096    23.893     0.200
    12.673    29.790     0.200
    16.450    38.102     0.200
     1.112     8.467     0.200
     1.394    10.221     0.200
     1.242     9.007     0.200
     1.318     9.232     0.200
     1.326     9.482     0.200
     1.391     9.873     0.200
     1.086     8.010     0.200
     1.131     8.237     0.200
     1.173     9.677     0.200
     1.531    11.056     0.200
     1.590    11.659     0.200
     1.020     9.027     0.200
     3.095    14.428     0.200
     1.054     7.873     0.200
     1.201     8.874     0.200
     1.307     9.640     0.200
     0.906     8.254     0.200
     1.228    10.227     0.200
     2.203    12.488     0.200
     2.397    13.118     0.200
     2.613    13.520     0.200
     3.095    14.792     0.200
     1.029     8.274     0.200
     1.174     8.975     0.200
     1.204     9.309     0.200
     1.427     9.936     0.200
     1.375    10.154     0.200
     1.478    10.447     0.200
     1.376     9.900     0.200
     1.450    10.349     0.200
     1.495    11.082     0.200
     1.213     8.991     0.200
     1.327     9.939     0.200
     0.891     7.376     0.200
     0.909     7.626     0.200
     0.921     8.182     0.200
     0.959     7.683     0.200
     0.988     8.440     0.200
     0.989     7.351     0.200
     1.010     7.637     0.200
     1.136     8.828     0.200
     1.142     8.453     0.200
     1.189     8.282     0.200
     1.309     9.594     0.200
     1.355    11.028     0.200
     0.973     8.388     0.200
     1.024     8.605     0.200
     1.142    10.105     0.200
     1.151     8.409     0.200
     1.160     8.721     0.200
     1.298     9.297     0.200
     1.335     9.548     0.200
     0.847     8.046     0.200
     0.942     7.911     0.200
     1.074     8.452     0.200
     1.083     8.760     0.200
     1.141     8.848     0.200
     1.196     9.154     0.200
     1.212     9.351     0.200
     1.313     9.987     0.200
     1.196     8.789     0.200
     1.295     9.557     0.200
     0.921     7.898     0.200
     1.086     8.198     0.200
     1.107     8.432     0.200
     1.104     8.593     0.200
     1.168     9.063     0.200
     1.412     9.496     0.200
     0.778     7.079     0.200
     0.883     7.230     0.200
     1.028     8.892     0.200
     1.274     9.171     0.200
     1.341     9.542     0.200
     1.463     9.986     0.200
     1.488    11.099     0.200
     1.079     8.452     0.200
     1.162     8.438     0.200
     1.254     9.036     0.200
     1.345    10.152     0.200
     1.421    10.623     0.200
     1.454    10.381     0.200
     0.921     6.696     0.200
     0.977     7.160     0.200
     1.020     7.188     0.200
     1.249     8.363     0.200
     1.219     9.519     0.200
     1.491    11.645     0.200
     1.514    11.077     0.200
     0.991     7.601     0.200
     1.044     7.764     0.200
     1.070     8.120     0.200
     1.075     7.622     0.200
     1.118     7.676     0.200
     1.139     7.931     0.200
     1.216     8.648     0.200
     1.246     9.023     0.200
     1.336     9.476     0.200
     1.325    10.274     0.200
     2.163    13.611     0.200
     3.339    15.219     0.200
     3.791    16.178     0.200
    16.561    35.688     0.200
     1.189     8.787     0.200
     1.440    10.489     0.200
     1.449    10.512     0.200
     1.507    10.913     0.200
     0.936     7.346     0.200
     1.049     8.069     0.200
     1.128     8.492     0.200
     1.146     8.647     0.200
     1.211     8.710     0.200
     1.196     9.233     0.200
     1.217     9.421     0.200
     1.229     9.404     0.200
     1.291     9.472     0.200
     1.324     9.833     0.200
     1.365    10.180     0.200
     1.309     8.669     0.200
     1.403    10.259     0.200
     2.531    12.290     0.200
     2.581    10.867     0.200
     3.409    15.349     0.200
     1.041     7.965     0.200
     1.098     8.557     0.200
     1.117     8.833     0.200
     1.127     8.509     0.200
     1.288     9.650     0.200
     1.298     9.684     0.200
     1.379     9.948     0.200
     1.418    10.465     0.200
     1.515    10.562     0.200
     0.974     8.130     0.200
     1.060     8.415     0.200
     1.083     9.807     0.200
     1.090     9.241     0.200
     1.115     8.477     0.200
     1.249    10.023     0.200
     1.294     8.718     0.200
     2.844    13.787     0.200
     2.919    12.768     0.200
     2.977    13.750     0.200
     3.525    15.676     0.200
     3.740    13.981     0.200
     4.129    14.351     0.200
     4.370    16.711     0.200
     4.464    17.480     0.200
     4.758    16.042     0.200
     4.925    17.642     0.200
     4.912    19.414     0.200
     4.973    18.182     0.200
     5.164    17.944     0.200
     5.177    17.997     0.200
     5.398    18.817     0.200
     5.915    17.741     0.200
     6.147    17.701     0.200
     6.147    21.331     0.200
     6.404    20.174     0.200
     6.847    20.403     0.200
     7.065    22.062     0.200
     7.182    18.681     0.200
     7.905    22.825     0.200
     8.002    22.015     0.200
     8.036    23.312     0.200
     8.391    28.782     0.200
     9.515    24.971     0.200
     9.515    28.931     0.200
     9.701    24.528     0.200
    10.467    27.206     0.200
    10.467    26.436     0.200
    10.920    28.200     0.200
    11.250    27.335     0.200
    11.250    27.925     0.200
    11.289    28.358     0.200
    11.855    28.938     0.200
    11.855    29.989     0.200
    12.112    29.600     0.200
    12.112    29.200     0.200
    12.534    31.972     0.200
    12.548    29.056     0.200
    12.548    28.737     0.200
    12.548    29.436     0.200
    12.717    31.712     0.200
    12.745    30.211     0.200
    12.806    29.451     0.200
    12.919    32.189     0.200
    12.919    30.278     0.200
    13.411    32.731     0.200
    13.411    33.004     0.200
    13.411    31.114     0.200
    13.517    31.014     0.200
    13.786    30.785     0.200
    15.020    36.533     0.200
    15.196    33.098     0.200
    15.196    33.198     0.200
    16.831    36.852     0.200
    16.831    37.613     0.200
    16.839    38.133     0.200
    16.839    37.565     0.200
    18.625    41.360     0.200
    20.562    39.475     0.200
    20.567    40.136     0.200
     1.257     9.341     0.200
     1.337     9.120     0.200
     1.065     8.270     0.200
     1.081     8.425     0.200
     1.136     8.928     0.200
     1.207     8.933     0.200
     0.988     8.463     0.200
     1.080     8.569     0.200
     1.271     9.583     0.200
     1.287    10.508     0.200
     1.295     9.767     0.200
     1.313     9.926     0.200
     1.380     9.724     0.200
     3.068    15.044     0.200
     3.359    14.240     0.200
     3.524    14.751     0.200
     3.582    15.684     0.200
     1.154     8.491     0.200
     1.205     8.821     0.200
     1.257     9.796     0.200
     1.297     9.027     0.200
     1.045     7.787     0.200
     1.055     7.997     0.200
     1.110     8.745     0.200
     1.180     8.966     0.200
     1.072     7.781     0.200
     1.227     8.618     0.200
     1.264     8.794     0.200
     1.305     9.081     0.200
     1.173     9.018     0.200
     1.214     9.429     0.200
     1.254     8.933     0.200
     1.268     9.472     0.200
     1.308    10.046     0.200
     1.433    11.061     0.200
     1.197     9.440     0.200
     1.260     9.567     0.200
     1.294     9.132     0.200
     1.343    10.463     0.200
     2.730    13.510     0.200
     3.923    16.062     0.200
     4.860    17.747     0.200
     1.309     9.473     0.200
     1.346     9.108     0.200
     0.972     7.500     0.200
     1.154     8.538     0.200
     1.106     8.457     0.200
     1.141     8.564     0.200
     1.160     8.557     0.200
     1.171     8.863     0.200
     1.175     8.887     0.200
     1.245     9.068     0.200
     1.299     9.276     0.200
     1.336     9.841     0.200
     1.331     9.768     0.200
     1.403    10.451     0.200
     0.834     6.653     0.200
     0.829     6.914     0.200
     0.858     6.741     0.200
     0.915     7.042     0.200
     1.042     7.482     0.200
     1.122     7.898     0.200
     1.172     8.001     0.200
     1.222     8.361     0.200
     1.223     8.503     0.200
     1.231     8.180     0.200
     1.289     9.194     0.200
     1.301     9.203     0.200
     1.319     9.415     0.200
     1.358     9.596     0.200
     2.686    10.097     0.200
     4.110    17.200     0.200
     6.259    20.366     0.200
     8.869    22.676     0.200
    12.696    31.883     0.200
    12.696    32.461     0.200
    14.401    31.209     0.200
    16.393    35.669     0.200
    21.028    38.757     0.200
     0.843     6.826     0.200
     0.930     7.331     0.200
     1.050     7.978     0.200
     1.135     8.183     0.200
     1.227     9.146     0.200
     1.232     8.568     0.200
     1.292     9.049     0.200
     1.312     9.428     0.200
     1.362     9.408     0.200
     1.382     9.442     0.200
     0.850     6.976     0.200
     0.940     7.800     0.200
     1.052     8.551     0.200
     1.052     8.196     0.200
     1.232     9.543     0.200
     1.219     9.358     0.200
     1.235     9.497     0.200
     1.316    10.069     0.200
     1.384    10.168     0.200
     1.256     9.626     0.200
     1.362     9.871     0.200
     0.941     7.322     0.200
     1.118     8.561     0.200
     1.201     8.579     0.200
     1.220     9.564     0.200
     1.274     9.825     0.200
     1.281     9.988     0.200
     1.307     9.500     0.200
     1.355     9.963     0.200
     1.330     9.261     0.200
     1.335     9.851     0.200
     1.452    10.559     0.200
     1.105     8.106     0.200
     1.164     8.920     0.200
     1.382     9.751     0.200
     1.471    10.304     0.200
     1.095     8.601     0.200
     1.197     8.789     0.200
     1.296    10.188     0.200
     1.375     9.939     0.200
     1.223    12.483     0.200
     2.582    14.693     0.200
     2.658    15.276     0.200
     2.710    15.704     0.200
     3.286    12.583     0.200
     3.789    17.746     0.200
     3.880    17.334     0.200
     4.249    17.673     0.200
     4.774    19.272     0.200
     6.698    21.890     0.200
     6.698    22.010     0.200
     9.782    27.278     0.200
    10.135    28.958     0.200
    10.214    28.370     0.200
    11.184    29.347     0.200
    11.184    29.067     0.200
    11.522    27.822     0.200
    11.542    30.761     0.200
    11.820    31.744     0.200
    11.828    30.737     0.200
    11.979    30.439     0.200
    12.294    32.075     0.200
    12.294    32.545     0.200
    12.511    33.236     0.200
    12.511    33.056     0.200
    12.465    30.629     0.200
    12.465    30.358     0.200
    12.599    30.055     0.200
    12.652    31.116     0.200
    12.855    33.118     0.200
    12.830    31.135     0.200
    12.939    33.194     0.200
    13.231    36.682     0.200
    13.303    32.859     0.200
    13.327    33.211     0.200
    13.327    35.547     0.200
    13.327    33.767     0.200
    13.327    32.465     0.200
    13.327    33.427     0.200
    13.339    35.507     0.200
    13.390    32.756     0.200
    13.454    34.024     0.200
    13.546    36.358     0.200
    13.602    35.638     0.200
    13.916    36.182     0.200
    13.967    35.948     0.200
    14.407    35.546     0.200
    14.416    34.660     0.200
    15.065    33.826     0.200
    16.860    37.173     0.200
    16.871    37.401     0.200
    16.871    37.751     0.200
    19.583    41.111     0.200
     1.210    10.002     0.200
     0.830     7.909     0.200
     0.974     8.633     0.200
     1.044     8.057     0.200
     0.974     7.748     0.200
     1.049     8.192     0.200
     1.211    10.090     0.200
     1.422     9.994     0.200
     1.098     8.964     0.200
     1.234     8.996     0.200
     1.310     9.231     0.200
     1.098     8.816     0.200
     1.234     9.367     0.200
     1.396    10.189     0.200
     1.451    10.416     0.200
     0.784     7.231     0.200
     0.973     8.480     0.200
     1.014     8.802     0.200
     1.121     7.577     0.200
     1.140     8.314     0.200
     1.379    10.285     0.200
     1.426    10.561     0.200
     1.045     8.093     0.200
     1.154     8.436     0.200
     1.210     9.596     0.200
     1.392    10.375     0.200
     1.440    10.888     0.200
     1.455    10.836     0.200
     3.803    16.745     0.200
     4.264    18.780     0.200
     1.295     9.248     0.200
     1.239    12.681     0.200
     1.940    10.474     0.200
     2.943    15.155     0.200
     1.364     9.799     0.200
     1.028     8.101     0.200
     1.403     9.361     0.200
     1.251     9.019     0.200
     1.311     9.292     0.200
     1.350     9.365     0.200
     3.913    17.152     0.200
     1.450    10.749     0.200
     1.154     8.798     0.200
     1.101     8.545     0.200
     1.197     8.911     0.200
     1.443    10.748     0.200
     3.286    12.932     0.200
     3.789    17.748     0.200
     4.249    17.268     0.200
     1.102     8.301     0.200
     1.153     9.084     0.200
     1.145     9.244     0.200
     1.327     9.719     0.200
     1.248     8.469     0.200
     1.289     9.325     0.200
     1.317     9.514     0.200
     1.550    11.301     0.200
     1.199     8.599     0.200
     1.192     8.302     0.200
     1.246     8.951     0.200
     1.346     9.447     0.200
     1.060     7.975     0.200
     1.184     8.685     0.200
     1.206     9.129     0.200
     1.254     8.841     0.200
     1.288     9.593     0.200
     1.354     9.883     0.200
     1.245     9.760     0.200
     1.335     9.272     0.200
     1.366    13.087     0.200
     3.538    17.270     0.200
     1.283     9.201     0.200
     1.349     9.017     0.200
     1.314     9.241     0.200
     1.431    10.640     0.200
     1.480    10.481     0.200
     1.512    11.015     0.200
     0.970     7.577     0.200
     0.972     7.549     0.200
     1.042     7.633     0.200
     1.104     7.922     0.200
     1.207     8.323     0.200
     1.214     8.923     0.200
     1.299     9.048     0.200
     1.342     9.155     0.200
     1.374     9.916     0.200
     1.395    10.509     0.200
     1.404    10.069     0.200
     1.451    10.536     0.200
     1.504    10.892     0.200
     1.533    11.129     0.200
     1.107     8.298     0.200
     1.204     8.689     0.200
     1.382     9.913     0.200
     1.433    10.602     0.200
     1.450    10.377     0.200
     1.430    11.509     0.200
     3.795    17.717     0.200
     1.511    11.252     0.200
     1.304     9.524     0.200
     1.339     9.751     0.200
     1.366    10.065     0.200
     1.378     9.840     0.200
     1.461    10.243     0.200
     1.500    10.599     0.200
     1.537    10.833     0.200
     1.549    10.740     0.200
     1.144     8.261     0.200
     1.348     9.663     0.200
     1.458    10.138     0.200
     1.455     9.798     0.200
     1.466    10.662     0.200
     1.273     9.429     0.200
     1.341     9.683     0.200
     1.217     9.041     0.200
     1.259     8.865     0.200
     1.285     9.151     0.200
     0.995     7.562     0.200
     1.084     7.593     0.200
     1.139     7.803     0.200
     1.202     8.555     0.200
     1.257     9.232     0.200
     1.330     8.749     0.200
     1.342     9.354     0.200
     1.066     7.915     0.200
     1.079     7.879     0.200
     1.133     8.277     0.200
     1.151     8.226     0.200
     1.202     8.839     0.200
     1.393    10.054     0.200
     1.202     8.762     0.200
     1.432    10.437     0.200
     1.447    10.524     0.200
     1.181     8.416     0.200
     1.223     8.616     0.200
     1.249     9.157     0.200
     1.446    10.056     0.200
     2.990    15.228     0.200
     1.381     9.728     0.200
     1.085     8.198     0.200
     1.131     8.280     0.200
     1.249     9.249     0.200
     1.262     8.959     0.200
     1.276     9.049     0.200
     1.307     9.518     0.200
     1.316     9.356     0.200
     1.310     9.896     0.200
     1.374     9.905     0.200
     1.386    10.017     0.200
     1.443    10.206     0.200
     1.085     8.448     0.200
     1.134     8.348     0.200
     1.262     9.349     0.200
     1.307     9.736     0.200
     1.316     9.239     0.200
     1.374    10.109     0.200
     1.443    10.667     0.200
     1.303     9.882     0.200
     1.404    10.415     0.200
     3.058    15.513     0.200
     1.078     8.233     0.200
     1.199     8.651     0.200
     1.248     8.870     0.200
     1.265     9.287     0.200
     1.255     9.405     0.200
     1.274     9.268     0.200
     1.318     9.099     0.200
     1.323     9.033     0.200
     1.328     9.503     0.200
     1.387     9.961     0.200
     1.113     8.088     0.200
     1.111     8.115     0.200
     1.166     8.919     0.200
     1.212     8.670     0.200
     1.247     9.151     0.200
     1.308     9.450     0.200
     1.339     9.525     0.200
     1.385    10.092     0.200
     1.202     8.842     0.200
     1.283     9.224     0.200
     1.282     9.873     0.200
     0.943     7.224     0.200
     1.037     7.760     0.200
     1.134     8.600     0.200
     1.214     8.577     0.200
     1.227     9.032     0.200
     1.275     9.311     0.200
     1.296     9.571     0.200
     1.299     8.851     0.200
     1.341     9.287     0.200
     1.349     9.559     0.200
     1.235     9.556     0.200
     1.412    10.460     0.200
     1.459    10.237     0.200
     1.486    10.843     0.200
     1.127     8.527     0.200
     1.135     8.331     0.200
     1.163     8.866     0.200
     1.216     8.562     0.200
     1.264     9.430     0.200
     1.316     9.456     0.200
     1.348     9.899     0.200
     1.414    10.447     0.200
     0.867     7.366     0.200
     1.239     9.877     0.200
     1.326     9.471     0.200
     1.364     9.378     0.200
     1.342     9.172     0.200
     1.348    10.074     0.200
     1.527    10.934     0.200
     2.392    12.851     0.200
     2.454    13.046     0.200
     2.714    14.800     0.200
     3.209    14.300     0.200
     3.185    16.075     0.200
     3.224    15.956     0.200
     4.847    18.265     0.200
     5.036    18.562     0.200
     5.692    19.107     0.200
     6.247    19.931     0.200
     6.293    20.485     0.200
     6.486    20.537     0.200
     6.499    20.390     0.200
     6.713    21.385     0.200
     7.726    22.664     0.200
     1.188     9.013     0.200
     0.929     7.519     0.200
     1.080     8.482     0.200
     1.111     8.380     0.200
     1.126     8.794     0.200
     1.193     9.065     0.200
     1.385    10.302     0.200
     1.044     7.943     0.200
     1.070     8.030     0.200
     1.111     8.369     0.200
     1.110     8.443     0.200
     1.228     8.988     0.200
     1.412    10.848     0.200
     1.055     8.419     0.200
     0.920     7.572     0.200
     0.951     7.670     0.200
     1.031     7.514     0.200
     1.049     7.892     0.200
     1.112     8.482     0.200
     1.150     8.512     0.200
     1.165     8.599     0.200
     1.171     9.355     0.200
     1.203     9.021     0.200
     1.209     8.840     0.200
     1.221     8.877     0.200
     1.235     9.301     0.200
     1.238     9.470     0.200
     0.960     8.324     0.200
     1.246     9.445     0.200
     1.298     9.216     0.200
     1.433    10.000     0.200
     1.441    10.708     0.200
     1.481    10.993     0.200
     1.246     9.265     0.200
     1.441    10.298     0.200
     1.420    11.348     0.200
     2.332    11.479     0.200
     2.379    10.352     0.200
     2.459    10.115     0.200
     2.428    10.790     0.200
     3.061    13.324     0.200
     5.015    17.740     0.200
     5.310    18.453     0.200
     5.655    19.161     0.200
     5.833    20.276     0.200
     6.500    20.395     0.200
     1.243     9.007     0.200
     1.350     9.672     0.200
     1.416    10.095     0.200
     1.123     8.327     0.200
     1.188     8.629     0.200
     1.441    10.592     0.200
     1.460    10.804     0.200
     1.487    10.665     0.200
     3.809    16.786     0.200
     1.105     8.150     0.200
     1.177     8.681     0.200
     1.206     9.008     0.200
     1.354     9.714     0.200
     1.355     9.499     0.200
     1.431     9.525     0.200
     1.396     9.834     0.200
     1.457    10.171     0.200
     1.107     9.057     0.200
     1.250     9.386     0.200
     1.296     9.371     0.200
     1.378     9.546     0.200
     1.148     8.717     0.200
     1.242     9.171     0.200
     1.367    11.384     0.200
     1.378    10.499     0.200
     1.392    10.699     0.200
     1.530    11.486     0.200
     2.613    14.255     0.200
     2.672    14.234     0.200
     3.442    15.255     0.200
     3.743    18.442     0.200
     4.745    20.471     0.200
    16.872    37.220     0.200
     1.179     9.144     0.200
     1.089     8.030     0.200
     1.128     8.499     0.200
     1.255     9.331     0.200
     1.327     9.893     0.200
     1.353     9.651     0.200
     1.359     9.599     0.200
     1.422    10.203     0.200
     0.811     7.011     0.200
     0.914     7.035     0.200
     0.911     6.681     0.200
     0.958     7.635     0.200
     1.014     7.533     0.200
     1.074     7.337     0.200
     1.081     8.112     0.200
     1.101     7.725     0.200
     1.127     8.326     0.200
     1.260     8.497     0.200
     1.276     8.639     0.200
     1.296     8.838     0.200
     1.330     8.878     0.200
     1.346     9.765     0.200
     1.416    10.028     0.200
     1.027     7.942     0.200
     1.214     9.132     0.200
     1.267     8.907     0.200
     1.336     9.244     0.200
     1.371     9.234     0.200
     1.133     8.211     0.200
     1.400     9.969     0.200
     1.255     9.374     0.200
     1.289     9.619     0.200
     1.339     9.801     0.200
     1.368    10.253     0.200
     1.366     9.938     0.200
     1.501    10.724     0.200
     1.519    11.182     0.200
     1.515    11.705     0.200
     1.544    11.405     0.200
     0.972     7.053     0.200
     1.018     7.290     0.200
     1.038     7.214     0.200
     1.078     7.356     0.200
     1.108     7.130     0.200
     1.139     7.705     0.200
     1.370     9.530     0.200
     1.265     8.879     0.200
     1.365     9.841     0.200
     1.450    10.521     0.200
     1.190     8.718     0.200
     1.219     8.777     0.200
     1.230     8.937     0.200
     1.297     9.554     0.200
     1.309     9.722     0.200
     1.308     9.569     0.200
     1.452    10.417     0.200
     1.455    10.351     0.200
     1.477    10.357     0.200
     1.308     9.618     0.200
     1.313     9.665     0.200
     1.317    10.123     0.200
     1.130     8.535     0.200
     1.217     9.378     0.200
     1.273    10.041     0.200
     1.322     9.685     0.200
     1.422    10.784     0.200
     0.988     7.470     0.200
     1.278     9.986     0.200
     1.108     8.524     0.200
     1.120     8.672     0.200
     1.155     8.870     0.200
     1.288     9.871     0.200
     1.358     9.391     0.200
     1.379     9.949     0.200
     1.363    10.058     0.200
     1.554    11.455     0.200
     1.124     8.304     0.200
     1.115     8.540     0.200
     1.271     9.789     0.200
     1.048     8.460     0.200
     1.044     8.266     0.200
     1.125     8.964     0.200
     1.319     9.494     0.200
     1.354    10.749     0.200
     1.382    11.246     0.200
     1.081     8.357     0.200
     1.229     8.784     0.200
     1.266     9.597     0.200
     1.324     9.637     0.200
     1.276     9.010     0.200
     1.339     9.438     0.200
     1.448    10.583     0.200
     0.843     6.858     0.200
     0.966     7.962     0.200
     1.047     8.429     0.200
     1.090     8.472     0.200
     1.141     9.081     0.200
     1.184     9.091     0.200
     1.304     9.942     0.200
     1.380     9.811     0.200
     1.411    10.118     0.200
     1.147     9.723     0.200
     0.879     7.199     0.200
     0.895     7.666     0.200
     0.893     7.165     0.200
     0.939     7.360     0.200
     0.971     7.208     0.200
     1.009     7.592     0.200
     1.000     7.802     0.200
     1.018     7.743     0.200
     1.104     8.050     0.200
     1.094     8.529     0.200
     1.155     9.355     0.200
     1.157     8.384     0.200
     1.213     9.597     0.200
     1.239     9.290     0.200
     1.283     9.577     0.200
     1.345    10.129     0.200
     1.354    10.463     0.200
     1.129     8.877     0.200
     1.212     8.968     0.200
     1.291     8.854     0.200
     1.359     9.266     0.200
     1.281     9.683     0.200
     1.301    10.098     0.200
     1.488    11.004     0.200
     1.157     8.645     0.200
     1.175     8.808     0.200
     1.204     8.257     0.200
     1.018     9.109     0.200
     1.095     8.525     0.200
     1.289    10.104     0.200
     1.324    10.008     0.200
     1.390     9.816     0.200
     1.231     9.082     0.200
     1.417    10.398     0.200
     1.510    10.151     0.200
     0.764     6.511     0.200
     0.850     6.879     0.200
     0.959     7.680     0.200
     0.970     7.464     0.200
     1.012     7.993     0.200
     1.014     7.641     0.200
     1.029     8.095     0.200
     1.064     8.242     0.200
     1.081     8.215     0.200
     1.150     8.308     0.200
     1.187     9.298     0.200
     1.308     9.850     0.200
     1.083     8.986     0.200
     1.188     9.134     0.200
     1.215     9.332     0.200
     1.233    10.128     0.200
     1.294    10.385     0.200
     1.311    10.358     0.200
     1.311    10.776     0.200
     1.451    10.953     0.200
     1.458    11.722     0.200
     1.474    11.078     0.200
     1.501    11.550     0.200
     1.588    11.286     0.200
     1.114     8.573     0.200
     1.232     8.933     0.200
     1.263    10.008     0.200
     1.263     9.594     0.200
     1.340     9.711     0.200
     1.339     9.823     0.200
     1.346     9.867     0.200
     1.488    10.801     0.200
     1.492    10.459     0.200
     1.237     8.941     0.200
     1.270     9.097     0.200
     1.266     9.187     0.200
     1.345     9.592     0.200
     1.342     9.883     0.200
     1.349     9.476     0.200
     1.142     8.844     0.200
     1.160     8.722     0.200
     1.219     9.517     0.200
     1.224     8.684     0.200
     1.375     9.678     0.200
     1.439    10.416     0.200
     0.974     7.454     0.200
     1.015     8.034     0.200
     1.139     8.738     0.200
     1.229     9.008     0.200
     1.304     9.476     0.200
     1.410    10.092     0.200
     1.452    10.352     0.200
     1.459    10.429     0.200
     1.506    10.902     0.200
     1.175     8.626     0.200
     1.185     8.558     0.200
     1.239     9.180     0.200
     1.262     9.134     0.200
     1.282     8.892     0.200
     1.386    10.208     0.200
     0.837     6.821     0.200
     1.291     9.387     0.200
     1.395     9.931     0.200
     0.837     6.880     0.200
     0.912     7.472     0.200
     0.935     7.844     0.200
     1.075     8.426     0.200
     1.120     8.525     0.200
     1.182     8.520     0.200
     1.268     9.674     0.200
     0.984     7.585     0.200
     1.229     9.104     0.200
     1.288    10.004     0.200
     1.357     9.494     0.200
     0.850     6.937     0.200
     1.016     8.275     0.200
     1.087     8.669     0.200
     1.155     8.782     0.200
     1.163     8.783     0.200
     1.168     8.313     0.200
     1.212     9.177     0.200
     1.228     9.448     0.200
     1.297     9.877     0.200
     1.351    10.061     0.200
     0.999     7.540     0.200
     1.163     8.482     0.200
     0.986     7.496     0.200
     1.171     8.215     0.200
     1.229     8.509     0.200
     0.984     7.754     0.200
     1.018     7.369     0.200
     1.169     8.758     0.200
     1.211     8.173     0.200
     1.228     9.195     0.200
     1.243     9.178     0.200
     1.263     9.419     0.200
     1.426    10.362     0.200
     1.142     8.767     0.200
     1.199     9.015     0.200
     1.231     9.066     0.200
     1.474    10.820     0.200
     1.509    11.120     0.200
     1.531    10.604     0.200
     1.307    12.287     0.200
     3.698    16.735     0.200
     3.698    16.634     0.200
     4.545    17.756     0.200
     5.097    18.815     0.200
     5.097    19.417     0.200
     5.148    19.714     0.200
     5.338    20.101     0.200
     5.338    19.800     0.200
     5.578    20.801     0.200
     5.578    19.900     0.200
     6.578    21.134     0.200
     6.578    21.433     0.200
     7.241    23.288     0.200
     7.241    22.489     0.200
     7.291    23.414     0.200
     7.291    21.914     0.200
    16.849    39.948     0.200
     1.103     8.053     0.200
     1.353    10.236     0.200
     1.152     8.942     0.200
     1.233     9.165     0.200
     0.861     6.975     0.200
     1.018     7.690     0.200
     1.171     8.632     0.200
     1.223     8.787     0.200
     2.637    11.495     0.200
     3.055    14.520     0.200
     3.229    12.695     0.200
     5.010    17.606     0.200
     5.204    18.047     0.200
     5.258    16.418     0.200
     5.854    19.152     0.200
     6.190    17.329     0.200
     6.410    19.969     0.200
     6.455    19.743     0.200
     6.649    20.082     0.200
     6.871    19.686     0.200
     7.889    21.813     0.200
     8.272    21.900     0.200
     8.577    22.574     0.200
    16.267    35.754     0.200
     0.809     6.910     0.200
     0.919     8.742     0.200
     0.995     9.193     0.200
     1.182     7.970     0.200
     2.274    10.139     0.200
     2.652    14.479     0.200
     2.799    11.337     0.200
     5.576    18.076     0.200
     5.728    18.595     0.200
     6.423    19.186     0.200
     7.028    20.427     0.200
     7.214    20.549     0.200
     7.227    20.703     0.200
     7.461    20.374     0.200
     7.814    21.558     0.200
     8.453    21.996     0.200
     8.439    21.928     0.200
    10.869    27.016     0.200
    11.053    28.871     0.200
    11.373    27.866     0.200
    13.762    31.665     0.200
    13.762    31.517     0.200
    16.432    36.418     0.200
    16.466    35.331     0.200
     1.116     8.896     0.200
     1.169     8.391     0.200
     1.183     8.723     0.200
     1.201     9.060     0.200
     1.201     9.547     0.200
     0.903     7.654     0.200
     1.085     8.173     0.200
     1.059     8.646     0.200
     1.205     9.512     0.200
     1.398    10.463     0.200
     0.841     6.782     0.200
     1.050     8.113     0.200
     1.085     8.225     0.200
     1.177     8.865     0.200
     1.186     9.114     0.200
     1.264     9.525     0.200
     1.278     9.773     0.200
     1.316     9.996     0.200
     1.382    10.542     0.200
     1.015     8.128     0.200
     2.698    13.184     0.200
     3.329    14.515     0.200
     4.060    15.026     0.200
     4.101    15.388     0.200
     4.305    18.940     0.200
     4.647    16.526     0.200
     5.030    16.217     0.200
     5.341    18.783     0.200
     5.664    19.146     0.200
     5.896    19.804     0.200
     5.942    19.665     0.200
     5.968    19.413     0.200
     5.968    19.753     0.200
     6.135    19.512     0.200
     6.148    19.465     0.200
     6.362    20.565     0.200
     6.719    21.004     0.200
     7.375    21.141     0.200
     7.385    20.041     0.200
     7.772    21.736     0.200
     8.034    23.453     0.200
     8.070    23.432     0.200
     8.316    22.381     0.200
     8.814    24.995     0.200
     8.921    23.144     0.200
     9.150    25.931     0.200
     9.495    25.692     0.200
     9.495    25.972     0.200
    10.367    29.522     0.200
    10.643    28.599     0.200
    11.160    27.613     0.200
    11.236    29.271     0.200
    11.284    28.996     0.200
    11.284    30.716     0.200
    11.438    29.889     0.200
    11.758    28.831     0.200
    11.756    28.940     0.200
    11.938    28.534     0.200
    11.998    30.593     0.200
    12.544    29.562     0.200
    12.625    32.469     0.200
    12.710    31.127     0.200
    12.710    30.883     0.200
    12.710    31.793     0.200
    12.710    31.403     0.200
    12.710    33.783     0.200
    12.750    33.457     0.200
    12.826    31.066     0.200
    12.826    30.745     0.200
    12.842    31.845     0.200
    12.857    30.186     0.200
    12.915    32.692     0.200
    12.994    31.806     0.200
    13.018    29.091     0.200
    13.018    28.971     0.200
    13.557    31.124     0.200
    13.893    30.710     0.200
    13.970    31.478     0.200
    13.961    30.417     0.200
    14.087    32.534     0.200
    14.211    32.803     0.200
    14.227    35.185     0.200
    14.388    31.450     0.200
    14.388    32.075     0.200
    14.388    31.890     0.200
    15.042    35.068     0.200
    16.445    36.684     0.200
    16.442    37.931     0.200
    16.444    36.456     0.200
    16.444    38.116     0.200
    16.444    38.506     0.200
    16.464    37.281     0.200
    16.464    37.565     0.200
    16.464    38.681     0.200
    16.464    36.956     0.200
    16.464    37.311     0.200
    16.464    38.681     0.200
    18.638    40.400     0.200
    18.761    40.263     0.200
    19.049    40.509     0.200
     1.313     9.456     0.200
     1.308     9.262     0.200
     1.531    10.875     0.200
     0.952     7.801     0.200
     1.080     8.346     0.200
     1.126     7.981     0.200
     1.176     8.223     0.200
     1.228     9.780     0.200
     1.265     9.289     0.200
     1.273     8.692     0.200
     1.375     9.741     0.200
     3.059    15.112     0.200
     0.718     6.221     0.200
     0.762     6.593     0.200
     0.884     6.980     0.200
     0.901     7.202     0.200
     0.987     7.269     0.200
     1.171     8.564     0.200
     1.214     9.383     0.200
     1.271     9.293     0.200
     1.322     9.599     0.200
     1.355     9.229     0.200
     0.914     7.575     0.200
     1.136     8.371     0.200
     1.326    10.806     0.200
     1.368     9.505     0.200
     1.348     9.619     0.200
     1.465    10.265     0.200
     3.215    14.392     0.200
     1.219     9.009     0.200
     1.261     8.915     0.200
     1.267     9.146     0.200
     1.181     8.691     0.200
     1.303     9.875     0.200
     1.389    10.545     0.200
     1.407    10.341     0.200
     1.412    10.415     0.200
     1.466    10.871     0.200
     2.648    14.144     0.200
     3.211    12.913     0.200
     1.204     8.798     0.200
     1.308    10.006     0.200
     1.392    10.836     0.200
     1.411    10.407     0.200
     1.416    10.132     0.200
     1.755    11.580     0.200
     2.484    16.100     0.200
     3.214    14.350     0.200
     3.786    18.052     0.200
     3.890    18.928     0.200
     4.474    17.708     0.200
     4.914    18.384     0.200
     5.104    19.159     0.200
     5.758    19.721     0.200
     6.314    21.047     0.200
     6.360    20.806     0.200
     6.553    21.255     0.200
     6.565    21.702     0.200
     6.778    22.021     0.200
     7.135    22.551     0.200
     7.793    23.284     0.200
     8.451    24.599     0.200
     8.485    24.295     0.200
    12.430    30.204     0.200
    12.430    31.141     0.200
    12.649    31.769     0.200
    14.056    32.265     0.200
    16.330    38.354     0.200
    16.330    36.214     0.200
     0.774     6.740     0.200
     0.873     7.245     0.200
     1.053     8.151     0.200
     1.115     8.227     0.200
     1.138     8.919     0.200
     1.250     9.229     0.200
     1.255     9.692     0.200
     1.294     9.350     0.200
     1.327     9.808     0.200
     1.055     8.085     0.200
     1.107     8.929     0.200
     1.169     9.258     0.200
     1.255    10.008     0.200
     1.281    10.139     0.200
     1.293    10.177     0.200
     1.360    10.229     0.200
     1.370    10.192     0.200
     1.374    10.304     0.200
     1.406    10.624     0.200
     1.229     9.135     0.200
     3.027    14.127     0.200
     2.972    14.819     0.200
     3.072    14.540     0.200
     3.085    14.433     0.200
     3.189    13.663     0.200
     3.392    15.614     0.200
     3.560    16.589     0.200
     3.598    15.807     0.200
     3.844    14.567     0.200
     4.070    16.732     0.200
     4.237    16.951     0.200
     4.792    17.775     0.200
     4.839    17.781     0.200
     5.032    18.079     0.200
     5.044    18.338     0.200
     5.006    20.184     0.200
     6.125    20.444     0.200
     7.203    20.148     0.200
     7.065    22.097     0.200
     7.723    23.509     0.200
     7.893    22.453     0.200
     7.986    23.525     0.200
     8.420    28.530     0.200
     9.715    24.806     0.200
    10.599    29.642     0.200
    10.829    28.515     0.200
    11.049    26.798     0.200
    11.906    30.985     0.200
    12.612    28.713     0.200
    12.726    30.314     0.200
    12.802    29.286     0.200
    13.115    31.685     0.200
    12.981    31.734     0.200
    13.342    32.988     0.200
    13.482    35.856     0.200
    13.482    35.630     0.200
    13.816    30.868     0.200
    15.285    37.557     0.200
    15.285    34.893     0.200
    16.858    39.437     0.200
    16.858    37.843     0.200
    17.537    37.365     0.200
    19.364    40.519     0.200
    19.829    41.381     0.200
     0.896     9.217     0.200
     1.240     8.415     0.200
     2.482    11.573     0.200
     2.582    13.624     0.200
     2.606    11.691     0.200
     2.842    14.172     0.200
     3.149    14.289     0.200
     3.267    13.945     0.200
     3.378    14.722     0.200
     4.979    18.123     0.200
     8.469    26.137     0.200
     8.499    23.453     0.200
     8.499    24.422     0.200
     9.996    25.416     0.200
    10.053    27.571     0.200
    10.278    26.827     0.200
    10.778    28.451     0.200
    10.900    26.956     0.200
    10.900    27.788     0.200
    11.203    29.257     0.200
    11.834    30.943     0.200
    12.001    29.077     0.200
    12.048    31.046     0.200
    12.048    30.546     0.200
    12.048    31.277     0.200
    12.048    30.785     0.200
    12.048    29.566     0.200
    12.414    30.288     0.200
    13.597    30.451     0.200
    13.597    31.705     0.200
    13.597    30.561     0.200
    14.903    38.152     0.200
    16.152    33.852     0.200
    16.152    35.274     0.200
    16.152    34.946     0.200
    16.152    34.684     0.200
    16.152    37.474     0.200
    17.856    36.000     0.200
    19.551    41.611     0.200
     2.539    11.001     0.200
     2.466    12.201     0.200
     2.893    12.086     0.200
     2.890    11.986     0.200
     3.006    12.222     0.200
     3.016    11.825     0.200
     3.059    13.663     0.200
     3.073    11.813     0.200
     3.174    11.883     0.200
     3.127    14.849     0.200
     3.325    13.341     0.200
     3.314    13.146     0.200
     3.319    13.200     0.200
     3.407    12.393     0.200
     3.353    14.624     0.200
     3.521    13.460     0.200
     3.828    12.469     0.200
     4.171    14.670     0.200
     4.330    15.549     0.200
     4.697    13.771     0.200
     4.724    15.414     0.200
     4.666    17.681     0.200
     4.774    15.933     0.200
     4.774    15.534     0.200
     4.740    15.387     0.200
     4.965    16.108     0.200
     4.977    16.060     0.200
     5.100    17.855     0.200
     5.203    16.532     0.200
     5.556    18.107     0.200
     5.881    16.314     0.200
     5.955    17.620     0.200
     5.955    18.001     0.200
     6.099    18.351     0.200
     6.867    20.210     0.200
     6.915    20.245     0.200
     7.668    21.556     0.200
     7.960    21.999     0.200
     8.349    26.539     0.200
     8.856    21.420     0.200
     9.355    27.170     0.200
     9.637    23.577     0.200
    10.054    30.319     0.200
    10.667    26.109     0.200
    10.667    25.558     0.200
    10.735    26.361     0.200
    11.056    25.028     0.200
    11.056    25.428     0.200
    11.448    26.339     0.200
    12.673    28.752     0.200
    12.818    27.837     0.200
    12.839    27.230     0.200
    12.968    31.126     0.200
    12.897    28.847     0.200
    13.266    29.834     0.200
    13.280    29.967     0.200
    13.493    32.286     0.200
    13.435    30.022     0.200
    13.435    29.205     0.200
    13.518    30.492     0.200
    13.578    30.456     0.200
    13.578    31.568     0.200
    13.578    30.988     0.200
    13.578    31.728     0.200
    13.578    32.388     0.200
    13.578    31.988     0.200
    13.640    30.067     0.200
    13.622    30.477     0.200
    13.746    29.017     0.200
    13.870    31.703     0.200
    14.347    32.612     0.200
    14.874    32.989     0.200
    15.171    33.808     0.200
    15.380    32.174     0.200
    15.380    30.867     0.200
    15.380    32.326     0.200
    15.605    32.535     0.200
    16.941    35.610     0.200
    16.947    37.739     0.200
    16.947    36.480     0.200
    16.947    36.779     0.200
    16.947    35.921     0.200
    16.947    34.919     0.200
    16.947    36.378     0.200
    17.465    38.154     0.200
    17.878    37.315     0.200
    19.742    38.458     0.200
    20.183    39.507     0.200
    20.366    38.777     0.200
    20.384    38.267     0.200
    20.603    38.908     0.200
     1.166     9.417     0.200
     2.574    10.687     0.200
     2.780    14.559     0.200
     3.128    15.195     0.200
     6.656    22.336     0.200
     8.783    24.528     0.200
    10.827    29.556     0.200
    10.952    29.707     0.200
    11.058    29.642     0.200
    11.164    30.301     0.200
    12.563    33.052     0.200
    13.845    34.351     0.200
    13.845    34.771     0.200
    16.275    39.069     0.200
    16.275    39.719     0.200
     2.661    11.789     0.200
     2.951    13.712     0.200
     3.276    14.271     0.200
     3.774    15.832     0.200
     4.001    15.541     0.200
     2.585    11.641     0.200
     2.642    14.202     0.200
     2.778    15.794     0.200
     2.947    14.436     0.200
     3.304    13.282     0.200
     3.345    15.328     0.200
     3.729    15.017     0.200
     3.932    14.658     0.200
     3.813    16.837     0.200
     3.923    17.524     0.200
     4.574    15.859     0.200
     4.718    19.466     0.200
     5.129    16.577     0.200
     5.176    16.742     0.200
     5.368    17.287     0.200
     5.381    17.344     0.200
     5.598    18.114     0.200
     7.268    21.527     0.200
     7.307    21.961     0.200
     7.246    19.713     0.200
     7.871    22.093     0.200
     8.055    23.264     0.200
     8.443    28.435     0.200
    10.143    25.767     0.200
    16.726    38.202     0.200
     1.220     9.895     0.200
     2.104    12.004     0.200
     2.363    13.017     0.200
     2.408    11.110     0.200
     2.423    12.808     0.200
     2.451    12.919     0.200
     2.577    12.609     0.200
     2.801    13.572     0.200
     3.155    14.618     0.200
     3.622    15.697     0.200
     4.094    17.304     0.200
     5.157    17.476     0.200
     5.314    19.312     0.200
     5.314    19.453     0.200
     5.330    19.798     0.200
     5.462    19.380     0.200
     6.002    19.016     0.200
     6.557    20.141     0.200
     6.604    20.098     0.200
     6.797    20.747     0.200
     6.809    20.500     0.200
     7.023    20.511     0.200
     7.556    21.689     0.200
     7.759    22.483     0.200
     7.759    21.954     0.200
     8.730    24.490     0.200
     8.707    26.357     0.200
     8.834    24.960     0.200
    10.262    27.766     0.200
    10.532    29.413     0.200
    10.974    30.093     0.200
    10.959    31.032     0.200
    11.099    28.477     0.200
    11.396    30.218     0.200
    11.449    29.069     0.200
    11.885    31.331     0.200
    12.212    30.551     0.200
    12.210    33.286     0.200
    12.283    29.126     0.200
    12.282    31.937     0.200
    12.282    30.881     0.200
    12.282    32.057     0.200
    12.282    28.824     0.200
    12.282    33.697     0.200
    12.282    31.837     0.200
    12.357    33.513     0.200
    12.467    32.614     0.200
    12.565    31.686     0.200
    12.565    30.308     0.200
    12.578    32.214     0.200
    12.870    28.768     0.200
    13.286    29.752     0.200
    13.873    32.491     0.200
    13.873    32.345     0.200
    14.632    36.105     0.200
    14.922    37.521     0.200
    16.243    35.264     0.200
    16.243    36.353     0.200
    16.271    36.338     0.200
    16.271    35.757     0.200
    16.271    35.021     0.200
    19.396    39.211     0.200
     1.411    10.414     0.200
     2.886    12.274     0.200
     2.894    12.258     0.200
     2.938    12.389     0.200
     2.949     8.839     0.200
     2.951    12.279     0.200
     3.022    13.728     0.200
     3.022    13.928     0.200
     3.055    12.541     0.200
     3.190    12.624     0.200
     3.205    13.649     0.200
     3.464    14.567     0.200
     3.651    15.287     0.200
     3.710    12.249     0.200
     4.311    15.788     0.200
     4.411    19.103     0.200
     4.863    16.749     0.200
     4.863    17.149     0.200
     4.914    16.325     0.200
     4.914    16.545     0.200
     4.914    16.744     0.200
     5.104    17.033     0.200
     5.104    17.133     0.200
     5.117    17.085     0.200
     5.345    17.315     0.200
     5.345    17.515     0.200
     5.991    20.085     0.200
     7.008    21.318     0.200
     7.008    21.418     0.200
     7.059    20.923     0.200
     7.059    21.223     0.200
     7.854    22.840     0.200
    10.530    27.807     0.200
    11.014    28.828     0.200
    11.728    26.434     0.200
    11.956    31.169     0.200
    12.716    29.265     0.200
    12.815    30.161     0.200
    13.406    30.753     0.200
    13.511    34.044     0.200
    13.511    32.605     0.200
    13.613    29.332     0.200
    13.732    30.849     0.200
    15.105    35.419     0.200
    16.929    36.081     0.200
    16.936    37.557     0.200
    17.599    39.322     0.200
     2.844    15.915     0.200
     3.090    15.263     0.200
     3.155    16.979     0.200
     3.523    16.110     0.200
     3.718    16.933     0.200
     4.026    18.922     0.200
     4.369    17.240     0.200
     4.541    18.868     0.200
     4.923    18.580     0.200
     4.972    18.007     0.200
     5.163    18.576     0.200
     5.399    19.925     0.200
     7.110    23.347     0.200
     7.159    19.805     0.200
     7.992    23.200     0.200
    13.429    36.210     0.200
    16.861    37.537     0.200
     2.488    11.047     0.200
     4.151    14.197     0.200
     4.781    17.149     0.200
     5.433    17.837     0.200
     5.988    19.260     0.200
     6.034    18.499     0.200
     6.034    19.519     0.200
     6.227    20.166     0.200
     6.454    19.220     0.200
     6.811    19.959     0.200
     7.194    21.073     0.200
     8.162    23.289     0.200
    11.627    27.612     0.200
    11.870    28.062     0.200
    12.789    31.047     0.200
    14.317    31.347     0.200
    16.437    37.127     0.200
    16.437    36.727     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     4.997    33.055     0.200
     2.843    19.852     0.200
     5.610    39.280     0.200
     5.849    39.492     0.200
     5.920    40.258     0.200
     3.572    24.715     0.200
     3.181    21.445     0.200
     2.940    20.008     0.200
     3.178    21.966     0.200
     2.606    18.288     0.200
     2.593    17.780     0.200
     2.972    22.783     0.200
     2.848    19.034     0.200
     2.603    17.327     0.200
     2.729    18.063     0.200
     4.521    33.144     0.200
     2.610    17.701     0.200
     2.591    18.322     0.200
     2.719    19.039     0.200
     2.745    18.843     0.200
     3.136    22.579     0.200
     2.766    18.241     0.200
     7.380    49.393     0.200
     2.780    19.220     0.200
     2.973    20.172     0.200
     3.866    26.945     0.200
     4.541    35.674     0.200
     2.952    22.796     0.200
     2.762    18.734     0.200
     3.356    23.614     0.200
     2.730    18.709     0.200
     4.901    39.837     0.200
     2.769    18.707     0.200
     2.769    21.707     0.200
     4.738    32.729     0.200
     2.565    18.769     0.200
     3.165    24.256     0.200
     3.153    22.527     0.200
     3.678    25.579     0.200
     3.253    22.506     0.200
     3.322    22.604     0.200
     3.476    23.780     0.200
     2.840    20.788     0.200
     3.001    21.737     0.200
     3.507    24.672     0.200
     3.212    23.138     0.200
     3.694    24.393     0.200
     2.822    19.835     0.200
     3.148    21.305     0.200
     2.939    22.103     0.200
     3.082    23.464     0.200
     3.207    24.767     0.200
     3.228    22.705     0.200
     6.553    47.021     0.200
     2.711    18.188     0.200
     3.362    23.592     0.200
     3.706    26.402     0.200
     3.490    24.280     0.200
     3.374    22.560     0.200
     2.844    22.425     0.200
     3.865    27.538     0.200
     3.776    26.137     0.200
     3.048    21.416     0.200
     3.821    26.138     0.200
     3.405    24.724     0.200
     3.236    22.135     0.200
     3.291    22.652     0.200
     2.738    18.070     0.200
     3.080    20.867     0.200
     2.548    17.235     0.200
     2.583    17.595     0.200
     2.883    19.429     0.200
     3.249    24.195     0.200
     3.566    27.180     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     2.514    14.703     0.200
     4.349    25.512     0.200
     2.799    16.420     0.200
     1.183     7.883     0.200
     2.669    14.542     0.200
     2.669    16.542     0.200
     1.993    12.310     0.200
     0.777     5.597     0.200
     1.337     8.581     0.200
     1.015     6.960     0.200
     1.275     8.528     0.200
     2.501    13.614     0.200
     0.982     6.703     0.200
     1.294     7.959     0.200
     2.475    13.376     0.200
     0.426     3.197     0.200
     2.145    13.331     0.200
     3.814    20.760     0.200
     1.006     7.222     0.200
     2.536    14.366     0.200
     1.027     7.481     0.200
     0.677     4.651     0.200
     0.762     4.338     0.200
     1.727    10.573     0.200
     2.135    12.607     0.200
     2.474    13.860     0.200
     0.770     5.479     0.200
     0.738     5.131     0.200
     2.068    13.015     0.200
     0.704     4.825     0.200
     0.534     3.186     0.200
     0.934     6.836     0.200
     1.103     7.130     0.200
     1.670    10.950     0.200
     1.993    12.984     0.200
     2.193    14.608     0.200
     2.623    16.393     0.200
     3.025    17.795     0.200
     1.895    13.128     0.200
     2.003    11.729     0.200
     2.181    13.788     0.200
     3.013    16.584     0.200
     0.830     4.718     0.200
     1.633    10.644     0.200
     2.019    12.389     0.200
     2.352    13.663     0.200
     1.137     6.346     0.200
     2.301    15.268     0.200
     2.645    14.648     0.200
     4.661    24.022     0.200
     1.006     7.619     0.200
     1.136     7.990     0.200
     2.033    14.517     0.200
     2.338    14.958     0.200
     2.529    13.757     0.200
     2.595    15.061     0.200
     2.721    15.985     0.200
     2.948    16.334     0.200
     2.339    14.940     0.200
     1.026     6.865     0.200
     1.135     9.220     0.200
     2.016    13.938     0.200
     2.319    16.100     0.200
     2.491    13.991     0.200
     2.533    15.260     0.200
     2.600    15.523     0.200
     2.727    15.636     0.200
     2.016    13.934     0.200
     2.321    16.083     0.200
     2.533    14.901     0.200
     2.924    16.343     0.200
     1.095     6.856     0.200
     1.184     9.316     0.200
     1.228     9.508     0.200
     1.971    14.130     0.200
     2.272    14.515     0.200
     2.532    14.581     0.200
     3.091    16.556     0.200
     3.445    18.428     0.200
     1.149     9.841     0.200
     1.153     7.595     0.200
     2.048    14.643     0.200
     2.542    14.879     0.200
     2.609    15.105     0.200
     2.734    14.435     0.200
     3.145    15.842     0.200
     5.710    33.906     0.200
     2.049    14.639     0.200
     1.020     6.770     0.200
     1.164     7.680     0.200
     1.188    10.196     0.200
     2.649    14.857     0.200
     2.776    15.369     0.200
     3.150    16.509     0.200
     0.996     7.763     0.200
     1.147     8.015     0.200
     1.149     8.791     0.200
     2.045    12.842     0.200
     2.349    15.186     0.200
     2.499    14.642     0.200
     2.537    14.101     0.200
     2.857    15.357     0.200
     2.956    17.203     0.200
     3.171    16.701     0.200
     3.339    17.735     0.200
     1.104     8.320     0.200
     2.351    15.169     0.200
     1.103     7.283     0.200
     1.911    12.853     0.200
     2.555    15.443     0.200
     2.687    15.002     0.200
     2.823    15.212     0.200
     2.716    14.466     0.200
     3.042    15.661     0.200
     2.999    16.158     0.200
     3.186    17.177     0.200
     1.024     7.984     0.200
     1.121     8.678     0.200
     2.015    13.246     0.200
     2.320    16.192     0.200
     2.484    16.681     0.200
     2.525    14.801     0.200
     2.828    16.262     0.200
     2.945    17.398     0.200
     3.142    17.100     0.200
     2.016    13.242     0.200
     2.321    16.175     0.200
     1.006     7.519     0.200
     1.167     7.759     0.200
     2.042    14.040     0.200
     2.625    15.637     0.200
     2.692    14.461     0.200
     2.752    15.361     0.200
     2.854    15.068     0.200
     3.162    16.976     0.200
     0.982     8.470     0.200
     1.226     8.244     0.200
     2.091    14.148     0.200
     2.384    14.625     0.200
     2.555    14.234     0.200
     3.055    15.902     0.200
     3.171    16.042     0.200
     3.193    16.782     0.200
     0.960     8.235     0.200
     1.122     7.466     0.200
     1.187     8.006     0.200
     2.084    13.531     0.200
     2.694    14.420     0.200
     2.560    13.978     0.200
     1.034     6.932     0.200
     1.123     9.066     0.200
     1.061     8.791     0.200
     1.988    12.976     0.200
     2.303    14.798     0.200
     2.478    13.758     0.200
     1.219     7.742     0.200
     1.262     9.738     0.200
     2.192    14.989     0.200
     2.410    13.845     0.200
     2.640    17.156     0.200
     3.056    16.803     0.200
     3.410    17.679     0.200
     1.036     7.100     0.200
     1.114     7.523     0.200
     2.308    14.887     0.200
     2.525    14.556     0.200
     2.592    14.279     0.200
     3.102    15.829     0.200
     3.130    16.999     0.200
     1.143     7.982     0.200
     1.037     6.731     0.200
     1.148     7.787     0.200
     1.128     9.119     0.200
     1.194     9.351     0.200
     2.311    14.410     0.200
     2.546    15.073     0.200
     2.484    13.798     0.200
     3.130    16.753     0.200
     1.068     6.813     0.200
     1.168     7.588     0.200
     0.995     7.243     0.200
     1.188     8.150     0.200
     2.064    13.431     0.200
     2.361    14.658     0.200
     2.663    15.539     0.200
     2.661    16.462     0.200
     2.787    17.592     0.200
     5.763    32.264     0.200
     2.064    13.426     0.200
     2.363    14.640     0.200
     2.766    17.842     0.200
     2.983    17.101     0.200
     0.198     0.997     0.200
     1.034     7.132     0.200
     0.997     7.240     0.200
     1.107     6.781     0.200
     1.154     7.634     0.200
     1.153     7.142     0.200
     2.046    13.720     0.200
     2.350    14.479     0.200
     2.613    14.108     0.200
     2.739    14.639     0.200
     2.351    13.461     0.200
     2.935    15.953     0.200
     4.717    24.548     0.200
     0.275     1.652     0.200
     1.007     7.867     0.200
     1.098     8.391     0.200
     1.202     8.831     0.200
     1.188     9.789     0.200
     2.064    12.771     0.200
     2.358    15.050     0.200
     2.689    15.474     0.200
     2.816    14.993     0.200
     3.043    17.746     0.200
     1.068     6.677     0.200
     1.146     7.307     0.200
     1.192     7.460     0.200
     1.248    10.109     0.200
     1.169     8.637     0.200
     2.301    15.720     0.200
     2.822    16.543     0.200
     3.046    17.129     0.200
     1.879    12.620     0.200
     2.303    15.702     0.200
     3.019    16.940     0.200
     1.047     7.935     0.200
     0.975     8.113     0.200
     1.093     7.913     0.200
     1.194     6.734     0.200
     2.652    14.114     0.200
     1.464     9.874     0.200
     1.796    12.377     0.200
     1.003     5.809     0.200
     1.001     7.561     0.200
     1.104     7.721     0.200
     1.118     5.561     0.200
     2.028    12.740     0.200
     2.337    16.034     0.200
     2.498    15.257     0.200
     2.690    16.015     0.200
     1.024     6.703     0.200
     1.066     7.961     0.200
     1.147     6.068     0.200
     2.027    13.596     0.200
     2.561    14.860     0.200
     2.755    17.095     0.200
     2.982    17.955     0.200
     0.276     1.570     0.200
     1.089     6.456     0.200
     1.143     7.627     0.200
     1.985    13.293     0.200
     2.674    15.254     0.200
     2.806    15.721     0.200
     3.029    15.919     0.200
     0.573     4.212     0.200
     0.859     6.318     0.200
     0.869     5.951     0.200
     0.976     6.950     0.200
     1.030     7.542     0.200
     2.043    13.254     0.200
     2.335    14.542     0.200
     2.621    14.007     0.200
     2.688    15.530     0.200
     2.816    16.034     0.200
     3.041    16.401     0.200
     4.691    25.847     0.200
     2.043    13.250     0.200
     2.337    14.524     0.200
     0.086     1.648     0.200
     0.241     0.511     0.200
     0.245     1.751     0.200
     0.292     2.209     0.200
     0.324     2.192     0.200
     0.577     4.162     0.200
     1.002     7.371     0.200
     1.070     7.764     0.200
     2.056    14.146     0.200
     0.042     1.576     0.200
     0.216     1.880     0.200
     0.268     2.076     0.200
     0.546     3.830     0.200
     0.822     4.865     0.200
     0.828     6.089     0.200
     1.023     6.544     0.200
     1.067     7.541     0.200
     1.149     7.845     0.200
     2.028    12.287     0.200
     2.328    14.491     0.200
     2.633    13.981     0.200
     2.697    14.485     0.200
     2.730    14.694     0.200
     1.512     9.776     0.200
     1.846    12.020     0.200
     2.028    12.283     0.200
     2.329    14.473     0.200
     2.730    15.093     0.200
     6.037    35.498     0.200
     0.054     1.999     0.200
     0.063     2.209     0.200
     0.223     1.825     0.200
     0.219     1.901     0.200
     0.219     2.003     0.200
     0.262     2.298     0.200
     0.292     2.185     0.200
     1.025     6.331     0.200
     1.139     6.843     0.200
     2.027    12.178     0.200
     2.327    14.581     0.200
     2.635    14.090     0.200
     2.729    14.586     0.200
     3.143    16.652     0.200
     1.513     9.580     0.200
     1.847    12.170     0.200
     2.328    14.563     0.200
     0.049     1.893     0.200
     0.065     1.854     0.200
     0.070     1.958     0.200
     0.213     1.785     0.200
     0.217     1.722     0.200
     0.262     2.162     0.200
     0.257     2.194     0.200
     0.286     2.112     0.200
     0.540     4.611     0.200
     0.816     5.599     0.200
     0.822     5.729     0.200
     1.141     6.304     0.200
     1.143     7.783     0.200
     2.692    16.201     0.200
     0.058     1.021     0.200
     0.077     1.712     0.200
     0.126     1.659     0.200
     0.249     1.808     0.200
     0.249     1.209     0.200
     0.344     2.571     0.200
     0.346     2.459     0.200
     0.366     2.556     0.200
     0.626     4.526     0.200
     0.897     6.371     0.200
     0.894     6.548     0.200
     1.060     6.816     0.200
     2.111    13.452     0.200
     2.411    14.445     0.200
     2.725    15.281     0.200
     0.077     1.831     0.200
     0.050     2.006     0.200
     0.088     1.025     0.200
     0.187     2.358     0.200
     0.224     1.443     0.200
     0.230     2.292     0.200
     0.234     1.970     0.200
     0.288     1.939     0.200
     0.293     2.388     0.200
     0.288     2.323     0.200
     0.571     4.637     0.200
     0.846     5.680     0.200
     0.852     5.614     0.200
     0.966     6.533     0.200
     1.001     7.262     0.200
     1.173     7.565     0.200
     1.490     9.310     0.200
     1.822    11.230     0.200
     0.048     2.176     0.200
     0.055     1.523     0.200
     0.072     2.109     0.200
     0.215     2.281     0.200
     0.216     1.808     0.200
     0.207     2.510     0.200
     0.262     1.983     0.200
     0.255     2.424     0.200
     0.531     4.200     0.200
     0.809     5.355     0.200
     0.816     5.271     0.200
     1.040     6.141     0.200
     1.078     7.608     0.200
     2.311    14.525     0.200
     2.714    14.727     0.200
     1.529     9.748     0.200
     1.863    12.290     0.200
     2.012    12.314     0.200
     2.312    14.507     0.200
     2.714    15.126     0.200
     2.952    14.841     0.200
     0.049     2.069     0.200
     0.082     1.787     0.200
     0.184     2.528     0.200
     0.236     1.948     0.200
     0.232     2.283     0.200
     0.292     2.096     0.200
     0.298     2.276     0.200
     0.294     2.297     0.200
     0.577     4.272     0.200
     0.857     5.507     0.200
     0.971     6.923     0.200
     2.648    14.411     0.200
     2.714    16.334     0.200
     0.088     1.850     0.200
     0.009     1.832     0.200
     0.037     2.288     0.200
     0.243     2.165     0.200
     0.246     1.901     0.200
     0.294     2.493     0.200
     0.301     2.431     0.200
     0.300     2.693     0.200
     0.578     4.702     0.200
     0.855     6.717     0.200
     0.862     5.995     0.200
     0.051     1.973     0.200
     0.063     1.782     0.200
     0.076     1.906     0.200
     0.221     1.558     0.200
     0.226     1.811     0.200
     0.248     2.400     0.200
     0.262     1.888     0.200
     0.522     4.100     0.200
     0.811     5.234     0.200
     0.802     5.580     0.200
     0.921     5.449     0.200
     1.052     6.104     0.200
     1.089     7.308     0.200
     2.562    13.797     0.200
     2.629    15.019     0.200
     2.983    15.888     0.200
     0.023     2.490     0.200
     0.143     2.109     0.200
     0.041     2.251     0.200
     0.255     2.123     0.200
     0.319     2.494     0.200
     0.326     3.199     0.200
     0.605     4.757     0.200
     0.885     5.884     0.200
     1.096     5.525     0.200
     0.037     2.119     0.200
     0.060     1.487     0.200
     0.082     1.981     0.200
     0.202     1.622     0.200
     0.207     1.838     0.200
     0.251     1.927     0.200
     0.218     2.458     0.200
     0.530     3.918     0.200
     0.810     5.402     0.200
     0.804     5.221     0.200
     1.033     6.282     0.200
     1.063     7.526     0.200
     2.315    14.589     0.200
     2.681    14.827     0.200
     2.742    15.112     0.200
     0.048     1.946     0.200
     0.050     1.387     0.200
     0.070     1.881     0.200
     0.220     1.834     0.200
     0.206     2.295     0.200
     0.254     2.088     0.200
     0.260     2.118     0.200
     0.264     1.720     0.200
     0.537     4.030     0.200
     0.820     5.326     0.200
     0.814     5.552     0.200
     0.074     1.501     0.200
     0.023     1.008     0.200
     0.050     1.673     0.200
     0.229     1.032     0.200
     0.187     2.031     0.200
     0.290     2.217     0.200
     0.568     4.071     0.200
     0.843     6.257     0.200
     0.849     5.189     0.200
     2.049    13.682     0.200
     0.044     2.085     0.200
     0.104     1.882     0.200
     0.052     0.903     0.200
     0.074     2.024     0.200
     0.208     1.434     0.200
     0.213     1.864     0.200
     0.259     2.298     0.200
     0.211     2.527     0.200
     0.259     2.046     0.200
     0.538     4.040     0.200
     0.657     5.400     0.200
     0.819     5.665     0.200
     0.813     5.587     0.200
     1.027     6.408     0.200
     2.021    14.234     0.200
     0.130     1.660     0.200
     0.158     1.713     0.200
     0.107     2.003     0.200
     0.185     1.723     0.200
     0.174     2.114     0.200
     0.177     1.993     0.200
     0.235     1.904     0.200
     0.286     2.790     0.200
     0.417     3.387     0.200
     0.564     3.986     0.200
     0.707     4.962     0.200
     0.720     4.657     0.200
     0.138     1.548     0.200
     0.096     1.874     0.200
     0.114     2.112     0.200
     0.161     1.512     0.200
     0.187     1.594     0.200
     0.163     1.969     0.200
     0.170     1.879     0.200
     0.217     1.405     0.200
     0.283     2.699     0.200
     0.424     3.487     0.200
     0.567     3.826     0.200
     0.712     5.384     0.200
     0.724     4.340     0.200
     0.137     2.171     0.200
     0.196     1.937     0.200
     0.137     2.147     0.200
     0.241     2.504     0.200
     0.215     2.245     0.200
     0.268     2.128     0.200
     0.214     2.572     0.200
     0.293     1.010     0.200
     0.304     2.568     0.200
     0.301     2.391     0.200
     0.317     2.918     0.200
     0.480     3.810     0.200
     0.644     5.106     0.200
     0.781     6.305     0.200
     0.798     5.806     0.200
     0.051     1.802     0.200
     0.111     1.621     0.200
     0.047     1.703     0.200
     0.191     1.462     0.200
     0.220     1.703     0.200
     0.265     1.598     0.200
     0.204     2.208     0.200
     0.287     2.145     0.200
     0.662     4.716     0.200
     0.824     5.686     0.200
     0.817     6.159     0.200
     0.936     5.517     0.200
     1.028     6.200     0.200
     1.069     7.379     0.200
     0.097     1.763     0.200
     0.137     1.410     0.200
     0.172     1.748     0.200
     0.216     1.160     0.200
     0.225     1.570     0.200
     0.284     2.600     0.200
     1.038     6.863     0.200
     1.251     8.577     0.200
     1.901    11.993     0.200
     0.046     1.969     0.200
     0.103     1.848     0.200
     0.050     1.962     0.200
     0.208     0.717     0.200
     0.213     1.804     0.200
     0.258     2.167     0.200
     0.260     2.611     0.200
     0.210     2.601     0.200
     0.540     4.342     0.200
     0.659     4.957     0.200
     0.820     6.073     0.200
     0.934     6.996     0.200
     0.055     2.077     0.200
     0.060     1.519     0.200
     0.084     2.252     0.200
     0.127     2.026     0.200
     0.202     2.487     0.200
     0.225     1.093     0.200
     0.231     2.116     0.200
     0.252     2.376     0.200
     0.525     4.087     0.200
     0.655     4.830     0.200
     0.815     5.710     0.200
     0.925     6.179     0.200
     1.051     6.740     0.200
     0.033     2.316     0.200
     0.034     2.073     0.200
     0.039     2.246     0.200
     0.092     1.931     0.200
     0.063     1.567     0.200
     0.200     1.564     0.200
     0.246     2.241     0.200
     0.249     1.993     0.200
     0.249     2.298     0.200
     0.221     2.464     0.200
     0.373     3.044     0.200
     0.528     3.736     0.200
     0.647     4.604     0.200
     0.802     5.040     0.200
     0.808     5.471     0.200
     1.035     6.174     0.200
     1.063     7.565     0.200
     2.502    13.401     0.200
     2.679    14.140     0.200
     0.019     2.105     0.200
     0.090     1.715     0.200
     0.148     1.505     0.200
     0.153     1.744     0.200
     0.137     1.697     0.200
     0.153     1.694     0.200
     0.163     1.323     0.200
     0.203     1.359     0.200
     0.204     1.605     0.200
     0.213     1.588     0.200
     0.291     2.555     0.200
     0.422     3.110     0.200
     0.559     3.963     0.200
     0.706     4.247     0.200
     0.717     4.616     0.200
     0.823     5.130     0.200
     1.118     7.042     0.200
     1.903    12.526     0.200
     4.574    24.856     0.200
     0.020     1.943     0.200
     0.080     1.355     0.200
     0.086     1.614     0.200
     0.139     1.527     0.200
     0.152     1.371     0.200
     0.150     1.544     0.200
     0.146     1.186     0.200
     0.163     1.191     0.200
     0.199     1.168     0.200
     0.269     2.275     0.200
     0.292     2.504     0.200
     0.422     3.167     0.200
     0.557     3.789     0.200
     0.705     6.066     0.200
     0.716     4.842     0.200
     0.822     6.299     0.200
     0.057     1.826     0.200
     0.055     1.324     0.200
     0.057     1.205     0.200
     0.127     1.721     0.200
     0.201     1.617     0.200
     0.243     1.956     0.200
     0.232     1.679     0.200
     0.200     2.291     0.200
     0.280     2.007     0.200
     0.529     4.044     0.200
     0.658     5.091     0.200
     0.818     6.420     0.200
     0.928     7.237     0.200
     0.061     1.323     0.200
     0.035     1.422     0.200
     0.113     1.685     0.200
     0.060     1.815     0.200
     0.181     1.225     0.200
     0.220     0.765     0.200
     0.224     1.858     0.200
     0.261     2.180     0.200
     0.272     2.192     0.200
     0.276     2.359     0.200
     0.300     2.163     0.200
     0.555     3.859     0.200
     0.674     5.213     0.200
     0.836     6.080     0.200
     0.104     1.832     0.200
     0.121     1.673     0.200
     0.158     1.870     0.200
     0.185     1.776     0.200
     0.190     2.189     0.200
     0.230     2.276     0.200
     0.249     1.882     0.200
     0.291     2.773     0.200
     0.409     2.943     0.200
     0.561     3.913     0.200
     0.717     4.348     0.200
     0.817     5.434     0.200
     0.079     1.656     0.200
     0.148     0.597     0.200
     0.191     1.604     0.200
     0.246     2.207     0.200
     0.282     2.293     0.200
     0.266     2.196     0.200
     0.261     2.072     0.200
     0.230     2.354     0.200
     0.543     3.686     0.200
     0.652     5.216     0.200
     0.811     6.364     0.200
     0.814     5.323     0.200
     0.932     7.055     0.200
     0.033     1.668     0.200
     0.062     0.540     0.200
     0.034     1.158     0.200
     0.055     1.813     0.200
     0.111     1.800     0.200
     0.122     1.607     0.200
     0.227     1.407     0.200
     0.232     1.725     0.200
     0.191     2.146     0.200
     0.255     2.127     0.200
     0.267     2.180     0.200
     0.275     2.349     0.200
     0.279     1.807     0.200
     0.299     2.209     0.200
     0.551     3.623     0.200
     0.675     4.784     0.200
     0.836     5.803     0.200
     0.060     1.291     0.200
     0.032     1.614     0.200
     0.036     1.077     0.200
     0.056     1.785     0.200
     0.110     1.844     0.200
     0.120     1.714     0.200
     0.189     0.535     0.200
     0.193     2.129     0.200
     0.230     1.618     0.200
     0.254     2.136     0.200
     0.266     2.192     0.200
     0.551     3.817     0.200
     0.674     5.382     0.200
     0.044     1.895     0.200
     0.122     0.986     0.200
     0.082     0.951     0.200
     0.090     0.861     0.200
     0.183     1.265     0.200
     0.157     2.064     0.200
     0.258     2.397     0.200
     0.303     2.497     0.200
     0.312     2.481     0.200
     0.577     3.668     0.200
     0.673     5.299     0.200
     0.836     5.345     0.200
     0.998     6.170     0.200
     1.075     7.360     0.200
     2.067    11.779     0.200
     2.374    14.302     0.200
     3.364    17.650     0.200
     1.799    11.226     0.200
     2.068    11.775     0.200
     2.376    14.284     0.200
     0.020     1.919     0.200
     0.048     1.299     0.200
     0.057     0.995     0.200
     0.089     1.626     0.200
     0.083     1.710     0.200
     0.112     1.804     0.200
     0.158     0.309     0.200
     0.196     1.164     0.200
     0.200     1.617     0.200
     0.221     2.361     0.200
     0.259     2.144     0.200
     0.265     2.105     0.200
     0.545     3.796     0.200
     0.657     5.188     0.200
     0.819     6.345     0.200
     0.017     2.379     0.200
     0.034     1.680     0.200
     0.111     1.833     0.200
     0.219     1.519     0.200
     0.267     2.412     0.200
     0.198     2.297     0.200
     0.277     2.392     0.200
     0.280     2.702     0.200
     0.304     2.492     0.200
     0.560     3.743     0.200
     0.677     4.920     0.200
     0.839     5.784     0.200
     0.833     5.649     0.200
     0.953     6.700     0.200
     1.009     7.181     0.200
     1.058     7.273     0.200
     2.042    14.242     0.200
     2.342    15.240     0.200
     2.700    14.563     0.200
     0.113     1.635     0.200
     0.133     1.988     0.200
     0.175     0.851     0.200
     0.226     1.787     0.200
     0.194     2.209     0.200
     0.283     2.341     0.200
     0.291     2.497     0.200
     0.279     2.175     0.200
     0.289     2.196     0.200
     0.571     4.480     0.200
     0.687     5.128     0.200
     0.844     6.796     0.200
     0.849     6.239     0.200
     0.997     7.527     0.200
     2.572    15.134     0.200
     0.015     2.372     0.200
     0.116     1.722     0.200
     0.049     1.473     0.200
     0.096     1.650     0.200
     0.163     1.389     0.200
     0.203     1.173     0.200
     0.207     1.737     0.200
     0.262     2.167     0.200
     0.261     2.253     0.200
     0.269     2.201     0.200
     0.270     2.185     0.200
     0.292     2.325     0.200
     0.550     3.873     0.200
     0.664     5.044     0.200
     0.826     5.655     0.200
     0.942     7.306     0.200
     0.019     1.879     0.200
     0.032     1.229     0.200
     0.113     1.602     0.200
     0.179     1.260     0.200
     0.221     1.520     0.200
     0.225     1.788     0.200
     0.196     2.256     0.200
     0.277     2.190     0.200
     0.304     2.330     0.200
     0.678     5.434     0.200
     0.840     5.799     0.200
     0.047     1.697     0.200
     0.066     0.977     0.200
     0.105     1.676     0.200
     0.180     1.144     0.200
     0.204     1.366     0.200
     0.209     1.630     0.200
     0.230     2.007     0.200
     0.240     2.055     0.200
     0.268     2.076     0.200
     0.220     2.280     0.200
     0.043     2.320     0.200
     0.088     1.929     0.200
     0.063     1.582     0.200
     0.177     1.255     0.200
     0.203     1.356     0.200
     0.208     1.564     0.200
     0.234     2.082     0.200
     0.243     2.157     0.200
     0.270     2.178     0.200
     0.219     2.313     0.200
     0.052     0.445     0.200
     0.029     1.014     0.200
     0.043     0.745     0.200
     0.066     1.415     0.200
     0.106     1.523     0.200
     0.111     1.269     0.200
     0.181     0.188     0.200
     0.216     1.031     0.200
     0.220     1.439     0.200
     0.203     1.975     0.200
     0.251     1.990     0.200
     0.262     2.084     0.200
     0.291     2.088     0.200
     0.051     1.597     0.200
     0.055     1.451     0.200
     0.127     1.788     0.200
     0.077     1.816     0.200
     0.170     0.963     0.200
     0.119     0.803     0.200
     0.181     1.959     0.200
     0.238     0.719     0.200
     0.239     1.976     0.200
     0.193     2.266     0.200
     0.311     1.569     0.200
     0.327     2.486     0.200
     0.336     2.632     0.200
     0.355     2.619     0.200
     1.024     7.397     0.200
     1.065     6.264     0.200
     2.403    14.757     0.200
     0.021     2.270     0.200
     0.045     1.487     0.200
     0.064     2.013     0.200
     0.103     1.812     0.200
     0.052     1.930     0.200
     0.052     1.908     0.200
     0.172     1.006     0.200
     0.111     2.224     0.200
     0.264     1.932     0.200
     0.266     2.232     0.200
     0.291     2.295     0.200
     0.391     3.077     0.200
     1.017     6.803     0.200
     1.058     7.331     0.200
     1.130     6.728     0.200
     1.178     7.969     0.200
     2.031    13.311     0.200
     2.332    13.948     0.200
     2.332    14.300     0.200
     2.626    13.867     0.200
     1.130     6.829     0.200
     1.506     9.335     0.200
     1.841    11.527     0.200
     2.032    13.307     0.200
     2.334    13.931     0.200
     0.050     1.465     0.200
     0.051     1.844     0.200
     0.032     1.365     0.200
     0.046     1.010     0.200
     0.103     1.805     0.200
     0.067     1.813     0.200
     0.183     0.413     0.200
     0.216     0.525     0.200
     0.213     2.018     0.200
     0.220     1.779     0.200
     0.204     2.246     0.200
     0.259     2.104     0.200
     0.266     2.986     0.200
     0.288     2.202     0.200
     0.382     2.616     0.200
     0.062     1.450     0.200
     0.062     1.804     0.200
     0.017     2.082     0.200
     0.035     1.669     0.200
     0.062     1.903     0.200
     0.110     1.752     0.200
     0.199     2.348     0.200
     0.213     2.102     0.200
     0.222     1.837     0.200
     0.275     2.217     0.200
     0.302     2.368     0.200
     0.399     3.260     0.200
     0.050     0.893     0.200
     0.051     1.910     0.200
     0.026     2.174     0.200
     0.046     1.443     0.200
     0.107     1.879     0.200
     0.069     1.880     0.200
     0.106     1.739     0.200
     0.176     0.421     0.200
     0.216     1.785     0.200
     0.212     0.008     0.200
     0.208     2.096     0.200
     0.207     2.394     0.200
     0.262     2.236     0.200
     0.264     2.641     0.200
     0.289     2.281     0.200
     0.387     2.991     0.200
     0.023     1.982     0.200
     0.031     2.183     0.200
     0.061     1.793     0.200
     0.070     1.931     0.200
     0.112     1.719     0.200
     0.087     1.444     0.200
     0.102     1.880     0.200
     0.208     1.669     0.200
     0.189     1.289     0.200
     0.201     0.901     0.200
     0.207     2.016     0.200
     0.216     1.986     0.200
     0.237     1.729     0.200
     0.248     1.923     0.200
     0.232     2.422     0.200
     0.342     2.614     0.200
     1.066     5.706     0.200
     1.083     7.655     0.200
     0.011     2.166     0.200
     0.076     1.928     0.200
     0.078     2.077     0.200
     0.037     1.855     0.200
     0.106     1.891     0.200
     0.066     2.110     0.200
     0.166     0.854     0.200
     0.220     1.940     0.200
     0.217     0.754     0.200
     0.209     2.130     0.200
     0.295     2.492     0.200
     0.316     2.557     0.200
     0.420     3.281     0.200
     0.059     1.362     0.200
     0.059     1.832     0.200
     0.019     2.329     0.200
     0.039     1.800     0.200
     0.116     1.834     0.200
     0.064     1.877     0.200
     0.108     1.788     0.200
     0.175     0.999     0.200
     0.219     1.839     0.200
     0.202     2.309     0.200
     0.272     2.268     0.200
     0.298     2.421     0.200
     0.396     3.285     0.200
     0.037     1.768     0.200
     0.035     1.462     0.200
     0.059     1.089     0.200
     0.095     1.614     0.200
     0.100     1.523     0.200
     0.081     1.648     0.200
     0.173     0.459     0.200
     0.207     1.529     0.200
     0.218     2.194     0.200
     0.250     1.936     0.200
     0.276     2.075     0.200
     0.050     1.511     0.200
     0.015     1.419     0.200
     0.109     1.454     0.200
     0.148     1.458     0.200
     0.160     1.685     0.200
     0.205     0.210     0.200
     0.159     1.780     0.200
     0.251     1.843     0.200
     0.262     1.691     0.200
     0.300     2.201     0.200
     0.315     2.240     0.200
     0.433     2.969     0.200
     0.032     2.178     0.200
     0.044     2.037     0.200
     0.099     1.913     0.200
     0.033     2.169     0.200
     0.090     1.903     0.200
     0.160     0.689     0.200
     0.195     1.714     0.200
     0.253     2.157     0.200
     0.246     2.168     0.200
     0.273     2.266     0.200
     0.046     1.541     0.200
     0.061     1.401     0.200
     0.029     1.283     0.200
     0.103     1.605     0.200
     0.050     0.530     0.200
     0.175     0.782     0.200
     0.213     1.612     0.200
     0.208     0.189     0.200
     0.258     2.010     0.200
     0.249     2.065     0.200
     0.053     1.442     0.200
     0.056     1.826     0.200
     0.073     2.008     0.200
     0.104     1.830     0.200
     0.042     0.965     0.200
     0.063     1.839     0.200
     0.220     0.789     0.200
     0.225     1.703     0.200
     0.249     2.162     0.200
     0.260     2.144     0.200
     0.291     2.284     0.200
     0.054     0.741     0.200
     0.054     1.746     0.200
     0.024     2.082     0.200
     0.042     0.876     0.200
     0.066     1.759     0.200
     0.108     1.602     0.200
     0.219     1.666     0.200
     0.203     2.264     0.200
     0.255     2.100     0.200
     0.265     2.129     0.200
     0.293     2.418     0.200
     0.390     3.059     0.200
     0.084     1.958     0.200
     0.120     0.824     0.200
     0.128     2.039     0.200
     0.155     2.163     0.200
     0.162     1.641     0.200
     0.136     1.902     0.200
     0.142     1.166     0.200
     0.154     1.632     0.200
     0.193     1.741     0.200
     0.210     1.977     0.200
     0.264     1.919     0.200
     0.217     2.372     0.200
     0.295     2.131     0.200
     0.298     2.494     0.200
     0.287     1.376     0.200
     0.285     2.240     0.200
     1.141     7.909     0.200
     1.935    12.141     0.200
     0.050     2.014     0.200
     0.075     2.039     0.200
     0.062     1.440     0.200
     0.067     0.883     0.200
     0.079     1.929     0.200
     0.126     1.771     0.200
     0.220     1.991     0.200
     0.222     1.074     0.200
     0.228     1.786     0.200
     0.208     2.297     0.200
     0.270     2.060     0.200
     0.353     2.814     0.200
     0.020     2.110     0.200
     0.104     1.632     0.200
     0.066     2.078     0.200
     0.044     1.333     0.200
     0.053     1.793     0.200
     0.069     1.740     0.200
     0.215     1.658     0.200
     0.207     2.204     0.200
     0.267     2.126     0.200
     0.293     2.148     0.200
     0.393     3.034     0.200
     1.058     7.560     0.200
     2.333    15.815     0.200
     0.047     1.858     0.200
     0.049     0.988     0.200
     0.072     1.844     0.200
     0.105     1.708     0.200
     0.210     1.108     0.200
     0.215     1.727     0.200
     0.209     2.271     0.200
     0.249     2.065     0.200
     0.259     2.073     0.200
     0.286     2.046     0.200
     0.383     2.893     0.200
     2.024    11.942     0.200
     2.324    14.536     0.200
     2.557    13.724     0.200
     0.014     0.410     0.200
     0.059     0.490     0.200
     0.057     1.685     0.200
     0.068     1.616     0.200
     0.103     1.480     0.200
     0.215     1.514     0.200
     0.211     0.708     0.200
     0.205     2.030     0.200
     0.264     2.073     0.200
     0.273     2.177     0.200
     0.298     2.277     0.200
     0.029     0.753     0.200
     0.035     1.864     0.200
     0.052     2.287     0.200
     0.069     1.191     0.200
     0.087     1.590     0.200
     0.108     1.548     0.200
     0.225     1.893     0.200
     0.235     1.889     0.200
     0.205     2.198     0.200
     0.205     0.703     0.200
     0.211     1.496     0.200
     0.354     2.468     0.200
     0.009     1.460     0.200
     0.041     1.381     0.200
     0.077    -0.039     0.200
     0.073     1.814     0.200
     0.103     1.633     0.200
     0.070     1.875     0.200
     0.205     2.064     0.200
     0.214     1.269     0.200
     0.216     1.706     0.200
     0.286     2.339     0.200
     0.294     2.353     0.200
     0.314     2.381     0.200
     0.390     2.414     0.200
     1.039     7.078     0.200
     1.151     8.035     0.200
     2.059    12.932     0.200
     2.361    14.110     0.200
     1.504    10.612     0.200
     1.813    11.598     0.200
     0.009     0.211     0.200
     0.010     2.076     0.200
     0.060     0.820     0.200
     0.087     1.423     0.200
     0.088     0.888     0.200
     0.109     1.500     0.200
     0.180     0.809     0.200
     0.182     1.794     0.200
     0.186     1.263     0.200
     0.222     1.846     0.200
     0.227     1.777     0.200
     0.247     1.714     0.200
     0.244     2.303     0.200
     0.331     2.049     0.200
     0.036     1.991     0.200
     0.038     0.405     0.200
     0.030     0.994     0.200
     0.062     1.226     0.200
     0.090     1.670     0.200
     0.086     1.769     0.200
     0.191     1.717     0.200
     0.194     0.881     0.200
     0.199     1.558     0.200
     0.224     2.395     0.200
     0.248     2.091     0.200
     0.255     2.063     0.200
     0.277     2.040     0.200
     0.357     2.282     0.200
     1.051     7.178     0.200
     2.020    12.373     0.200
     2.323    15.143     0.200
     0.029     0.160     0.200
     0.062     1.485     0.200
     0.035     0.092     0.200
     0.078     1.094     0.200
     0.057     1.584     0.200
     0.112     1.467     0.200
     0.118     1.306     0.200
     0.186     0.325     0.200
     0.194     1.932     0.200
     0.220     1.933     0.200
     0.228     1.498     0.200
     0.257     1.915     0.200
     0.268     1.877     0.200
     0.299     2.173     0.200
     0.050    -0.408     0.200
     0.050     1.647     0.200
     0.065     1.421     0.200
     0.046     0.639     0.200
     0.107     1.572     0.200
     0.105     1.481     0.200
     0.070     1.561     0.200
     0.175     0.383     0.200
     0.211     0.716     0.200
     0.207     1.758     0.200
     0.215     1.614     0.200
     0.207     2.086     0.200
     0.253     1.901     0.200
     0.263     2.007     0.200
     0.264     3.095     0.200
     0.030     1.764     0.200
     0.090     0.153     0.200
     0.142     0.043     0.200
     0.144     1.582     0.200
     0.158     1.360     0.200
     0.184     1.851     0.200
     0.188     1.732     0.200
     0.119     1.656     0.200
     0.243     0.614     0.200
     0.291     2.309     0.200
     0.302     2.141     0.200
     0.317     2.508     0.200
     0.337     2.598     0.200
     0.378     2.823     0.200
     0.025     1.426     0.200
     0.018     1.506     0.200
     0.076     1.698     0.200
     0.076     1.772     0.200
     0.054     1.874     0.200
     0.086     1.517     0.200
     0.133     1.795     0.200
     0.117     1.693     0.200
     0.190     2.221     0.200
     0.220     1.952     0.200
     0.278     2.265     0.200
     0.289     2.266     0.200
     0.412     3.120     0.200
     0.048     2.034     0.200
     0.158     1.270     0.200
     0.159     1.897     0.200
     0.114     2.198     0.200
     0.172     1.814     0.200
     0.202     2.184     0.200
     0.198     2.116     0.200
     0.300     2.821     0.200
     0.312     2.571     0.200
     0.336     2.771     0.200
     0.356     2.876     0.200
     0.465     3.608     0.200
     0.055     0.972     0.200
     0.036     1.939     0.200
     0.096     0.293     0.200
     0.149     1.279     0.200
     0.151     1.744     0.200
     0.165     1.797     0.200
     0.191     2.123     0.200
     0.194     1.938     0.200
     0.114     1.964     0.200
     0.248     0.570     0.200
     0.297     2.755     0.200
     0.308     2.354     0.200
     0.323     2.699     0.200
     0.343     2.612     0.200
     0.365     3.462     0.200
     0.385     2.908     0.200
     0.116     2.212     0.200
     0.115     1.800     0.200
     0.091     1.182     0.200
     0.124     2.134     0.200
     0.226     2.257     0.200
     0.198     2.219     0.200
     0.252     2.294     0.200
     0.313     2.683     0.200
     0.300     2.429     0.200
     0.049     0.390     0.200
     0.049     1.654     0.200
     0.026     1.051     0.200
     0.047     1.104     0.200
     0.106     1.643     0.200
     0.105     1.467     0.200
     0.071     1.509     0.200
     0.175     0.415     0.200
     0.210     1.007     0.200
     0.207     1.547     0.200
     0.214     1.564     0.200
     0.208     2.066     0.200
     0.252     1.960     0.200
     0.288     2.168     0.200
     0.048     1.784     0.200
     0.029     0.915     0.200
     0.048     0.989     0.200
     0.103     1.701     0.200
     0.071     1.665     0.200
     0.106     1.622     0.200
     0.177     0.492     0.200
     0.210     0.901     0.200
     0.215     1.648     0.200
     0.207     1.635     0.200
     0.249     2.137     0.200
     0.259     1.933     0.200
     0.208     2.143     0.200
     0.018     1.637     0.200
     0.074     1.544     0.200
     0.079     0.919     0.200
     0.092     1.574     0.200
     0.055     0.809     0.200
     0.083     1.612     0.200
     0.144     1.622     0.200
     0.148     0.713     0.200
     0.203    -0.027     0.200
     0.205     1.618     0.200
     0.216     2.330     0.200
     0.297     2.419     0.200
     0.291     2.387     0.200
     0.066     0.118     0.200
     0.124     0.734     0.200
     0.149     1.623     0.200
     0.135     0.713     0.200
     0.153     1.412     0.200
     0.165     1.405     0.200
     0.143     1.573     0.200
     0.211     1.430     0.200
     0.225     1.662     0.200
     0.229     1.467     0.200
     0.227     1.480     0.200
     0.022     0.445     0.200
     0.040     1.034     0.200
     0.091     2.146     0.200
     0.091     0.550     0.200
     0.110     1.630     0.200
     0.152     1.888     0.200
     0.164     0.288     0.200
     0.212     1.734     0.200
     0.224     1.725     0.200
     0.222     1.020     0.200
     0.199     2.117     0.200
     0.289     2.339     0.200
     0.299     2.402     0.200
     0.307     2.391     0.200
     0.328     2.472     0.200
     0.401     2.023     0.200
     2.073    13.520     0.200
     0.057     1.181     0.200
     0.048     1.189     0.200
     0.065     0.587     0.200
     0.083     1.811     0.200
     0.107     1.707     0.200
     0.182     0.729     0.200
     0.205     1.457     0.200
     0.211     1.660     0.200
     0.219     2.152     0.200
     0.229     1.998     0.200
     0.250     2.432     0.200
     0.239     2.034     0.200
     0.268     1.955     0.200
     0.356     1.698     0.200
     1.125     8.921     0.200
     0.058     0.275     0.200
     0.099     0.595     0.200
     0.167     2.498     0.200
     0.111     1.776     0.200
     0.192     1.807     0.200
     0.197     1.751     0.200
     0.251     0.269     0.200
     0.300     1.954     0.200
     0.311     2.151     0.200
     0.324     2.495     0.200
     0.345     2.666     0.200
     0.387     2.807     0.200
     0.046     1.973     0.200
     0.022     1.046     0.200
     0.055     2.159     0.200
     0.110     1.603     0.200
     0.104     1.089     0.200
     0.120     1.905     0.200
     0.193     1.887     0.200
     0.200     1.728     0.200
     0.198     1.721     0.200
     0.197     1.511     0.200
     0.226     1.913     0.200
     0.249     2.249     0.200
     0.036     0.907     0.200
     0.063     1.745     0.200
     0.108     1.581     0.200
     0.175     0.683     0.200
     0.211     2.013     0.200
     0.220     1.664     0.200
     0.200     2.202     0.200
     0.276     2.103     0.200
     0.383     2.253     0.200
     1.122     7.627     0.200
     1.159     8.205     0.200
     2.042    12.902     0.200
     2.342    14.498     0.200
     0.046     1.004     0.200
     0.050     0.658     0.200
     0.073     1.706     0.200
     0.185     0.986     0.200
     0.212     1.652     0.200
     0.205     1.751     0.200
     0.208     1.214     0.200
     0.210     2.174     0.200
     0.259     1.998     0.200
     0.250     2.014     0.200
     0.285     2.090     0.200
     0.369     2.338     0.200
     0.385     2.794     0.200
     0.007     2.011     0.200
     0.037     0.659     0.200
     0.065     1.947     0.200
     0.069     1.990     0.200
     0.075     0.917     0.200
     0.166     1.355     0.200
     0.208     2.363     0.200
     0.202     2.433     0.200
     0.215     0.785     0.200
     0.218     1.957     0.200
     0.275     2.272     0.200
     0.284     2.287     0.200
     0.307     2.293     0.200
     0.410     3.082     0.200
     1.113     7.302     0.200
     2.563    14.875     0.200
     2.696    15.325     0.200
     0.224     2.148     0.200
     0.291     2.067     0.200
     0.296     2.111     0.200
     0.427     2.960     0.200
     1.090     7.157     0.200
     2.365    14.780     0.200
     0.019     1.245     0.200
     0.026     1.968     0.200
     0.055     1.840     0.200
     0.082     1.209     0.200
     0.081     1.680     0.200
     0.089     2.225     0.200
     0.167     1.320     0.200
     0.189     2.246     0.200
     0.220     1.695     0.200
     0.231     1.834     0.200
     0.285     2.245     0.200
     0.295     2.281     0.200
     0.321     2.508     0.200
     0.419     3.348     0.200
     1.108     6.338     0.200
     0.033     1.433     0.200
     0.030     2.076     0.200
     0.036     1.489     0.200
     0.070     1.994     0.200
     0.095     1.746     0.200
     0.156     1.186     0.200
     0.191     1.606     0.200
     0.245     2.012     0.200
     0.232     2.492     0.200
     0.270     2.236     0.200
     0.056     1.759     0.200
     0.061     1.912     0.200
     0.026     1.321     0.200
     0.098     1.710     0.200
     0.137     0.920     0.200
     0.137     1.859     0.200
     0.148     1.295     0.200
     0.183     1.385     0.200
     0.176     1.471     0.200
     0.186     1.428     0.200
     0.248     1.379     0.200
     0.234     2.215     0.200
     0.275     2.266     0.200
     0.291     2.360     0.200
     0.020     0.526     0.200
     0.059     1.265     0.200
     0.059     1.067     0.200
     0.063     1.515     0.200
     0.176     1.694     0.200
     0.172     1.654     0.200
     0.180     1.158     0.200
     0.201     2.049     0.200
     0.211     1.786     0.200
     0.216     0.732     0.200
     0.261     1.987     0.200
     0.298     2.063     0.200
     0.084     2.000     0.200
     0.036     1.654     0.200
     0.089     1.543     0.200
     0.101     2.017     0.200
     0.131     0.997     0.200
     0.117     2.109     0.200
     0.185     2.089     0.200
     0.192     0.934     0.200
     0.194     1.839     0.200
     0.265     2.186     0.200
     0.232     2.735     0.200
     0.302     2.487     0.200
     0.315     2.475     0.200
     0.375     2.758     0.200
     1.203     7.235     0.200
     2.375    14.564     0.200
     2.772    17.425     0.200
     1.527     9.753     0.200
     2.376    14.547     0.200
     3.650    19.284     0.200
     0.044     1.796     0.200
     0.031     1.037     0.200
     0.075     1.663     0.200
     0.177     1.796     0.200
     0.174     0.610     0.200
     0.177     1.884     0.200
     0.187     1.214     0.200
     0.207     0.785     0.200
     0.204     1.515     0.200
     0.247     1.736     0.200
     0.212     2.134     0.200
     0.258     3.135     0.200
     0.282     1.821     0.200
     0.366     2.624     0.200
     0.363     2.511     0.200
     0.037     1.267     0.200
     0.071     1.374     0.200
     0.080     1.725     0.200
     0.085     0.912     0.200
     0.105     1.637     0.200
     0.127     0.717     0.200
     0.125     0.743     0.200
     0.116     1.752     0.200
     0.179     1.817     0.200
     0.175     1.157     0.200
     0.188     1.531     0.200
     0.187     0.627     0.200
     0.259     2.179     0.200
     0.236     2.275     0.200
     0.299     2.207     0.200
     0.310     2.162     0.200
     0.369     2.454     0.200
     1.198     7.726     0.200
     2.065    13.609     0.200
     0.028     1.953     0.200
     0.050     1.403     0.200
     0.068     0.989     0.200
     0.087     1.739     0.200
     0.168     1.827     0.200
     0.181     0.623     0.200
     0.203     0.714     0.200
     0.209     1.668     0.200
     0.202     1.624     0.200
     0.190     1.981     0.200
     0.248     2.096     0.200
     0.265     1.921     0.200
     0.350     2.425     0.200
     0.353     2.363     0.200
     1.159     7.455     0.200
     2.002    12.125     0.200
     2.302    14.114     0.200
     2.546    13.772     0.200
     0.028     1.324     0.200
     0.032     1.681     0.200
     0.054     1.415     0.200
     0.049     1.280     0.200
     0.068     1.154     0.200
     0.104     1.525     0.200
     0.087     1.565     0.200
     0.167     1.689     0.200
     0.180     0.953     0.200
     0.208     1.554     0.200
     0.202     1.689     0.200
     0.208     1.453     0.200
     0.189     1.881     0.200
     0.201     1.704     0.200
     0.265     2.024     0.200
     0.350     2.265     0.200
     0.013     1.722     0.200
     0.075     1.623     0.200
     0.076     1.191     0.200
     0.078     0.966     0.200
     0.049     1.800     0.200
     0.078     1.763     0.200
     0.154     0.780     0.200
     0.142     1.979     0.200
     0.147     1.355     0.200
     0.198     1.262     0.200
     0.210     1.668     0.200
     0.313     2.237     0.200
     0.108     1.580     0.200
     0.065     1.789     0.200
     0.049     2.505     0.200
     0.114     2.155     0.200
     0.095     1.431     0.200
     0.184     2.234     0.200
     0.247     2.466     0.200
     0.251     2.416     0.200
     0.248     2.681     0.200
     0.255     1.370     0.200
     0.285     2.521     0.200
     0.291     2.479     0.200
     0.323     2.608     0.200
     0.325     1.547     0.200
     0.423     3.160     0.200
     0.041     2.087     0.200
     0.044     1.350     0.200
     0.083     1.790     0.200
     0.026     1.668     0.200
     0.063     1.628     0.200
     0.165     1.975     0.200
     0.090     1.807     0.200
     0.153     0.529     0.200
     0.190     1.255     0.200
     0.194     1.538     0.200
     0.194     1.657     0.200
     0.185     1.907     0.200
     0.168     1.601     0.200
     0.247     2.187     0.200
     0.281     2.283     0.200
     0.357     2.196     0.200
     1.173     7.378     0.200
     2.331    15.170     0.200
     2.606    14.149     0.200
     2.332    15.152     0.200
     2.927    17.406     0.200
     2.983    16.156     0.200
     3.503    18.585     0.200
     7.339    41.919     0.200
     0.023     1.171     0.200
     0.024     1.949     0.200
     0.046     0.905     0.200
     0.072     0.701     0.200
     0.094     1.381     0.200
     0.094     1.470     0.200
     0.169     0.970     0.200
     0.179     1.572     0.200
     0.192     0.999     0.200
     0.198     1.346     0.200
     0.011     1.345     0.200
     0.084     0.492     0.200
     0.171    -0.022     0.200
     0.187     0.790     0.200
     0.230     1.791     0.200
     1.160     7.941     0.200
     1.144     6.126     0.200
     0.567     4.418     0.200
     0.916     4.943     0.200
     0.779     7.245     0.200
     1.756    11.048     0.200
     1.943    13.360     0.200
     2.055    12.051     0.200
     0.535     4.779     0.200
     2.820    15.110     0.200
     4.359    23.051     0.200
     0.688     4.909     0.200
     0.944     6.314     0.200
     1.632    12.292     0.200
     2.308    14.903     0.200
     1.071     6.700     0.200
     1.168     7.566     0.200
     1.262     8.163     0.200
     2.429    15.451     0.200
     2.651    14.656     0.200
     3.036    17.058     0.200
     5.493    32.093     0.200
     0.617     4.352     0.200
     1.135     9.502     0.200
     2.197    12.808     0.200
     2.280    13.647     0.200
     2.468    14.820     0.200
     0.773     5.975     0.200
     0.825     5.767     0.200
     1.070     9.508     0.200
     1.715    10.377     0.200
     2.374    14.290     0.200
     2.612    15.910     0.200
     0.997     7.567     0.200
     0.442     2.940     0.200
     0.697     4.367     0.200
     1.273     8.644     0.200
     1.760    11.658     0.200
     1.949    12.350     0.200
     0.626     4.136     0.200
     1.718    12.578     0.200
     2.625    14.198     0.200
     2.686    14.954     0.200
     2.793    14.638     0.200
     4.978    29.641     0.200
     0.609     3.467     0.200
     0.950     6.894     0.200
     1.469    11.656     0.200
     2.187    13.431     0.200
     2.839    16.350     0.200
     0.610     4.345     0.200
     2.599    15.640     0.200
     3.803    23.620     0.200
     4.737    28.681     0.200
     0.547     3.547     0.200
     0.845     5.568     0.200
     1.746    12.052     0.200
     1.950    13.576     0.200
     2.175    14.844     0.200
     2.672    14.452     0.200
     2.806    15.774     0.200
     3.012    16.722     0.200
     3.007    15.938     0.200
     3.052    18.199     0.200
     3.173    18.476     0.200
     0.486     3.825     0.200
     0.677     5.603     0.200
     0.850     5.277     0.200
     0.850     5.757     0.200
     1.164     5.815     0.200
     1.969    11.921     0.200
     2.513    13.573     0.200
     0.209     2.353     0.200
     1.118     6.962     0.200
     1.929    12.028     0.200
     2.245    12.314     0.200
     2.444    14.236     0.200
     2.627    14.350     0.200
     0.269     2.229     0.200
     1.311     7.462     0.200
     2.181    14.525     0.200
     2.576    14.400     0.200
     0.860     5.287     0.200
     2.762    15.809     0.200
     3.385    19.871     0.200
     3.548    19.854     0.200
     0.677     3.895     0.200
     1.109     8.021     0.200
     1.207     9.588     0.200
     1.995    12.682     0.200
     2.763    15.700     0.200
     3.006    15.889     0.200
     3.117    15.867     0.200
     0.388     2.881     0.200
     0.956     6.404     0.200
     2.085    13.694     0.200
     2.451    16.646     0.200
     0.257     2.469     0.200
     0.853     6.286     0.200
     1.602    10.796     0.200
     2.869    18.485     0.200
     0.196     1.607     0.200
     0.177     1.831     0.200
     2.180    14.458     0.200
     0.465     3.347     0.200
     2.387    13.920     0.200
     2.795    15.004     0.200
     0.608     3.860     0.200
     0.668     4.421     0.200
     1.614    11.137     0.200
     1.759    13.538     0.200
     2.072    12.674     0.200
     2.157    12.789     0.200
     2.332    14.752     0.200
     0.685     4.352     0.200
     1.724    11.249     0.200
     1.866    13.970     0.200
     2.219    12.934     0.200
     2.582    15.193     0.200
     2.719    15.214     0.200
     0.521     2.912     0.200
     0.624     4.711     0.200
     1.246     7.652     0.200
     1.743    11.257     0.200
     2.137    15.096     0.200
     2.819    15.598     0.200
     2.042    11.228     0.200
     3.610    20.242     0.200
     0.885     5.946     0.200
     0.368     2.290     0.200
     1.003     5.881     0.200
     1.634    11.515     0.200
     1.765    11.886     0.200
     1.874    13.022     0.200
     1.988    12.287     0.200
     0.525     4.644     0.200
     2.254    13.122     0.200
     0.408     2.187     0.200
     0.510     4.502     0.200
     2.288    13.718     0.200
     0.675     4.579     0.200
     0.627     4.789     0.200
     0.605     5.734     0.200
     1.179     7.073     0.200
     0.577     4.495     0.200
     0.643     3.658     0.200
     1.303     8.887     0.200
     0.327     2.667     0.200
     1.350     8.369     0.200
     0.653     4.454     0.200
     0.530     2.632     0.200
     0.658     4.990     0.200
     2.142    14.836     0.200
     0.783     5.892     0.200
     0.676     4.586     0.200
     1.564    12.061     0.200
     2.269    15.103     0.200
     2.353    13.915     0.200
     2.442    16.983     0.200
     2.185    13.146     0.200
     4.735    25.584     0.200
     0.552     4.862     0.200
     0.575     3.954     0.200
     0.649     6.026     0.200
     0.957     6.258     0.200
     1.087     7.237     0.200
     1.585    12.340     0.200
     1.857    12.243     0.200
     2.290    13.403     0.200
     2.627    14.432     0.200
     2.819    14.681     0.200
     2.893    15.835     0.200
     2.983    14.973     0.200
     3.145    19.435     0.200
     3.275    18.584     0.200
     0.476     2.498     0.200
     2.103    13.055     0.200
     3.777    23.270     0.200
     1.761    12.091     0.200
     1.761    13.610     0.200
     3.428    17.963     0.200
     0.241     2.298     0.200
     1.278     7.382     0.200
     1.649    10.314     0.200
     1.913    11.233     0.200
     2.583    13.137     0.200
     0.602     4.432     0.200
     0.811     5.819     0.200
     0.912     6.122     0.200
     1.679    11.259     0.200
     2.631    14.275     0.200
     2.107    11.848     0.200
     3.790    21.599     0.200
     1.477     9.950     0.200
     2.091    12.540     0.200
     0.427     3.952     0.200
     0.851     6.456     0.200
     0.956     5.465     0.200
     1.367    10.515     0.200
     2.345    13.447     0.200
     0.958     7.701     0.200
     1.789    12.459     0.200
     2.435    13.416     0.200
     2.025    13.352     0.200
     0.718     6.270     0.200
     0.839     6.640     0.200
     1.313     8.299     0.200
     1.565    12.459     0.200
     1.750    10.773     0.200
     1.979    12.496     0.200
     2.080    12.918     0.200
     0.210     2.409     0.200
     1.273     6.766     0.200
     1.933    12.280     0.200
     2.221    14.098     0.200
     2.238    12.961     0.200
     0.887     6.167     0.200
     0.943     7.323     0.200
     1.199     8.142     0.200
     1.623    10.859     0.200
     1.812    11.589     0.200
     2.047    12.060     0.200
     2.725    14.437     0.200
     0.604     3.658     0.200
     0.673     5.894     0.200
     0.720     4.242     0.200
     0.969     7.025     0.200
     0.961     7.675     0.200
     1.335     8.842     0.200
     2.212    13.685     0.200
     1.115     7.369     0.200
     2.238    12.347     0.200
     0.641     4.362     0.200
     2.237    13.064     0.200
     0.655     4.685     0.200
     0.957     6.474     0.200
     1.183     6.718     0.200
     1.504     8.840     0.200
     1.591    10.490     0.200
     2.115    12.188     0.200
     0.802     5.926     0.200
     1.553    10.770     0.200
     2.719    14.390     0.200
     0.325     2.446     0.200
     1.819    12.519     0.200
     2.518    16.378     0.200
     0.484     3.471     0.200
     2.886    16.178     0.200
     0.924     7.425     0.200
     3.635    23.382     0.200
     1.232     9.589     0.200
     2.126    13.390     0.200
     2.126    14.484     0.200
     0.949     8.531     0.200
     0.949     8.344     0.200
     1.346     7.718     0.200
     1.797    12.618     0.200
     2.472    14.780     0.200
     0.606     3.761     0.200
     0.707     5.479     0.200
     0.562     4.572     0.200
     2.183    11.657     0.200
     0.655     4.276     0.200
     0.804     5.301     0.200
     1.496    11.132     0.200
     1.982    12.724     0.200
     1.416    10.183     0.200
     1.507    10.774     0.200
     1.742    12.128     0.200
     2.442    14.216     0.200
     2.494    13.769     0.200
     0.979     7.177     0.200
     1.411    10.431     0.200
     1.504    10.873     0.200
     1.773    11.844     0.200
     2.471    13.940     0.200
     2.548    14.984     0.200
     0.219     1.896     0.200
     0.240     2.086     0.200
     0.317     2.466     0.200
     0.338     2.576     0.200
     0.377     2.674     0.200
     0.576     4.077     0.200
     0.689     4.873     0.200
     0.689     5.217     0.200
     0.889     6.848     0.200
     1.032     7.466     0.200
     0.235     2.567     0.200
     0.261     2.786     0.200
     0.291     2.645     0.200
     0.363     3.133     0.200
     0.385     3.182     0.200
     0.480     3.631     0.200
     0.485     3.822     0.200
     0.618     4.762     0.200
     0.626     4.922     0.200
     0.631     5.085     0.200
     0.639     5.352     0.200
     0.648     4.910     0.200
     0.811     6.079     0.200
     0.889     6.840     0.200
     0.904     6.681     0.200
     0.104     2.027     0.200
     0.112     2.039     0.200
     0.248     2.526     0.200
     0.392     3.435     0.200
     0.419     3.377     0.200
     0.468     3.357     0.200
     0.495     3.934     0.200
     0.494     3.792     0.200
     0.596     4.659     0.200
     0.609     4.729     0.200
     0.630     4.636     0.200
     0.669     4.844     0.200
     0.804     5.890     0.200
     0.833     6.068     0.200
     0.832     6.328     0.200
     0.945     7.074     0.200
     1.035     7.423     0.200
     0.468     2.796     0.200
     0.570     5.389     0.200
     1.826    13.179     0.200
     2.790    16.031     0.200
     0.103     2.222     0.200
     0.117     2.145     0.200
     0.253     2.644     0.200
     0.420     3.620     0.200
     0.474     3.436     0.200
     0.494     4.153     0.200
     0.495     4.119     0.200
     0.599     4.541     0.200
     0.614     4.822     0.200
     0.635     5.211     0.200
     0.670     5.118     0.200
     1.032     7.165     0.200
     0.205     1.936     0.200
     0.205     2.061     0.200
     0.280     2.292     0.200
     0.330     2.797     0.200
     0.329     2.897     0.200
     0.384     3.108     0.200
     0.513     3.939     0.200
     0.539     4.224     0.200
     0.554     4.173     0.200
     0.582     4.281     0.200
     0.653     4.809     0.200
     0.685     5.007     0.200
     0.712     5.280     0.200
     0.726     5.437     0.200
     0.839     5.727     0.200
     1.062     7.819     0.200
     0.161     1.883     0.200
     0.181     2.050     0.200
     0.242     2.213     0.200
     0.305     2.381     0.200
     0.306     2.288     0.200
     0.351     2.846     0.200
     0.401     3.238     0.200
     0.424     3.451     0.200
     0.460     3.568     0.200
     0.636     4.708     0.200
     0.651     5.033     0.200
     0.783     6.256     0.200
     0.853     6.845     0.200
     0.114     1.717     0.200
     0.180     1.941     0.200
     0.199     1.820     0.200
     0.266     2.535     0.200
     0.492     3.768     0.200
     0.554     3.994     0.200
     0.702     4.918     0.200
     0.715     5.014     0.200
     0.949     7.117     0.200
     1.001     7.222     0.200
     0.998     7.211     0.200
     1.122     7.277     0.200
     1.144     8.009     0.200
     0.071     2.233     0.200
     0.235     2.145     0.200
     0.325     2.582     0.200
     0.404     3.579     0.200
     0.470     3.848     0.200
     0.611     4.629     0.200
     0.647     4.736     0.200
     0.676     4.755     0.200
     0.827     6.040     0.200
     0.863     6.297     0.200
     0.882     6.562     0.200
     0.984     7.345     0.200
     1.087     7.293     0.200
     0.248     2.070     0.200
     0.266     2.636     0.200
     0.358     2.766     0.200
     0.465     3.587     0.200
     0.717     5.155     0.200
     0.864     5.991     0.200
     0.879     6.080     0.200
     1.101     7.811     0.200
     1.536    11.080     0.200
     1.419    10.505     0.200
     1.511    10.665     0.200
     2.042    13.361     0.200
     2.105    13.848     0.200
     2.465    14.753     0.200
     2.517    13.902     0.200
     2.626    15.474     0.200
     2.918    15.995     0.200
     0.052     0.903     0.200
     0.200     1.439     0.200
     0.340     2.437     0.200
     0.339     2.216     0.200
     0.377     2.664     0.200
     0.766     5.900     0.200
     0.915     6.869     0.200
     1.197     8.152     0.200
     1.223     8.210     0.200
     1.224     8.595     0.200
     1.290     8.711     0.200
     1.584    11.706     0.200
     0.206     1.723     0.200
     0.224     1.723     0.200
     0.268     2.178     0.200
     0.307     2.151     0.200
     0.329     2.704     0.200
     0.366     2.828     0.200
     0.531     3.802     0.200
     0.560     3.911     0.200
     0.639     4.760     0.200
     0.700     5.029     0.200
     0.904     6.628     0.200
     1.226     8.751     0.200
     0.164     1.536     0.200
     0.180     1.498     0.200
     0.209     1.753     0.200
     0.356     2.545     0.200
     0.441     3.518     0.200
     0.623     4.886     0.200
     0.686     5.057     0.200
     0.692     5.163     0.200
     0.720     4.651     0.200
     0.872     6.811     0.200
     1.018     7.312     0.200
     1.022     7.521     0.200
     0.287     2.629     0.200
     0.336     2.810     0.200
     0.361     2.751     0.200
     0.362     2.914     0.200
     0.409     3.301     0.200
     0.461     3.618     0.200
     0.575     4.437     0.200
     0.600     4.274     0.200
     0.624     4.715     0.200
     0.623     4.701     0.200
     0.673     4.727     0.200
     0.763     5.644     0.200
     0.780     5.752     0.200
     0.817     5.960     0.200
     0.853     6.352     0.200
     0.881     6.574     0.200
     0.947     6.926     0.200
     0.197     1.665     0.200
     0.150     2.255     0.200
     0.231     2.275     0.200
     0.308     2.226     0.200
     0.440     3.440     0.200
     0.676     4.540     0.200
     0.830     6.133     0.200
     0.824     5.655     0.200
     1.121     7.944     0.200
     1.234     8.063     0.200
     1.495    10.821     0.200
     1.475    10.125     0.200
     1.777    11.915     0.200
     0.176     1.652     0.200
     0.159     1.893     0.200
     0.220     2.097     0.200
     0.288     2.086     0.200
     0.429     3.016     0.200
     0.660     4.565     0.200
     0.810     5.476     0.200
     0.809     5.787     0.200
     1.076     7.801     0.200
     1.104     7.999     0.200
     1.109     7.733     0.200
     0.378     2.827     0.200
     1.780    11.426     0.200
     0.192     2.295     0.200
     0.207     2.657     0.200
     0.350     3.387     0.200
     0.351     3.205     0.200
     0.430     3.517     0.200
     0.624     5.061     0.200
     0.649     5.335     0.200
     0.693     5.363     0.200
     0.747     5.038     0.200
     0.415     3.221     0.200
     0.420     3.013     0.200
     0.457     3.721     0.200
     0.556     3.968     0.200
     0.581     4.385     0.200
     0.631     4.328     0.200
     0.737     5.529     0.200
     0.841     5.855     0.200
     0.309     2.411     0.200
     0.317     2.223     0.200
     0.328     2.364     0.200
     0.355     2.695     0.200
     0.408     3.071     0.200
     0.478     3.585     0.200
     0.578     4.467     0.200
     0.677     4.719     0.200
     0.773     6.089     0.200
     0.106     2.067     0.200
     0.163     2.343     0.200
     0.259     2.616     0.200
     0.337     3.182     0.200
     0.352     2.911     0.200
     0.540     4.326     0.200
     0.598     4.930     0.200
     0.625     4.710     0.200
     0.652     5.290     0.200
     0.881     6.371     0.200
     0.136     1.879     0.200
     0.246     2.407     0.200
     0.286     2.570     0.200
     0.397     3.201     0.200
     0.461     3.432     0.200
     0.531     4.265     0.200
     0.536     4.517     0.200
     0.640     4.830     0.200
     0.639     4.960     0.200
     0.666     5.283     0.200
     0.711     5.654     0.200
     0.858     6.230     0.200
     0.205     1.998     0.200
     0.404     3.282     0.200
     0.402     3.189     0.200
     0.410     3.021     0.200
     0.474     3.524     0.200
     0.570     4.299     0.200
     0.672     5.065     0.200
     0.697     5.477     0.200
     0.727     5.211     0.200
     0.931     6.924     0.200
     1.006     7.230     0.200
     0.295     2.216     0.200
     0.299     2.171     0.200
     0.368     2.510     0.200
     0.395     2.989     0.200
     0.471     3.474     0.200
     0.500     3.842     0.200
     0.575     4.272     0.200
     0.575     3.748     0.200
     0.666     4.928     0.200
     0.774     5.483     0.200
     0.831     6.426     0.200
     0.285     2.332     0.200
     0.290     2.422     0.200
     0.331     2.795     0.200
     0.355     2.781     0.200
     0.374     3.055     0.200
     0.453     3.610     0.200
     0.478     3.764     0.200
     0.524     3.632     0.200
     0.555     4.169     0.200
     0.557     4.085     0.200
     0.585     4.247     0.200
     0.645     4.828     0.200
     0.643     4.839     0.200
     0.709     5.398     0.200
     0.737     5.383     0.200
     0.785     5.664     0.200
     0.836     5.952     0.200
     0.809     6.074     0.200
     0.810     6.106     0.200
     0.932     7.056     0.200
     1.109     8.082     0.200
     0.277     2.470     0.200
     0.285     2.563     0.200
     0.327     2.837     0.200
     0.347     2.805     0.200
     0.367     3.230     0.200
     0.449     3.734     0.200
     0.471     3.965     0.200
     0.517     3.735     0.200
     0.585     4.271     0.200
     0.639     4.646     0.200
     0.700     5.521     0.200
     0.729     5.564     0.200
     0.827     5.570     0.200
     0.178     1.751     0.200
     0.169     2.104     0.200
     0.281     2.130     0.200
     0.438     3.061     0.200
     0.652     4.537     0.200
     0.792     5.508     0.200
     0.804     5.590     0.200
     0.800     5.521     0.200
     1.208     7.858     0.200
     0.047     1.603     0.200
     0.078     2.069     0.200
     0.161     1.868     0.200
     0.251     2.340     0.200
     0.299     2.655     0.200
     0.317     2.632     0.200
     0.458     3.987     0.200
     0.473     3.837     0.200
     0.517     4.368     0.200
     0.569     4.566     0.200
     0.148     2.276     0.200
     0.290     2.379     0.200
     0.295     2.503     0.200
     0.290     2.677     0.200
     0.579     4.576     0.200
     0.596     4.638     0.200
     0.739     5.212     0.200
     0.745     5.343     0.200
     1.013     7.105     0.200
     0.235     3.142     0.200
     0.295     2.902     0.200
     0.301     2.870     0.200
     0.419     3.508     0.200
     0.444     3.538     0.200
     0.479     3.839     0.200
     0.541     3.745     0.200
     0.611     5.269     0.200
     0.670     5.389     0.200
     0.758     5.936     0.200
     0.809     5.568     0.200
     0.942     6.827     0.200
     0.125     1.867     0.200
     0.222     2.171     0.200
     0.287     2.300     0.200
     0.291     2.617     0.200
     0.308     2.710     0.200
     0.322     2.855     0.200
     0.346     2.725     0.200
     0.353     3.025     0.200
     0.426     3.479     0.200
     0.713     5.080     0.200
     0.801     6.077     0.200
     0.841     6.519     0.200
     0.192     2.226     0.200
     0.236     2.698     0.200
     0.285     2.585     0.200
     0.311     2.906     0.200
     0.347     3.203     0.200
     0.362     3.139     0.200
     0.503     4.363     0.200
     0.606     4.994     0.200
     0.680     5.657     0.200
     0.076     2.297     0.200
     0.197     2.056     0.200
     0.333     2.771     0.200
     0.401     3.182     0.200
     0.452     3.759     0.200
     0.543     4.121     0.200
     0.550     4.170     0.200
     0.607     4.589     0.200
     0.662     4.818     0.200
     0.812     6.145     0.200
     0.811     6.068     0.200
     0.822     6.193     0.200
     0.291     3.187     0.200
     0.320     3.303     0.200
     0.383     3.581     0.200
     0.397     3.552     0.200
     0.443     4.011     0.200
     0.520     4.814     0.200
     0.543     4.149     0.200
     0.538     4.262     0.200
     0.547     4.741     0.200
     0.605     5.036     0.200
     0.700     5.255     0.200
     0.715     5.760     0.200
     0.733     5.486     0.200
     0.114     1.764     0.200
     0.152     2.041     0.200
     0.222     2.019     0.200
     0.326     2.864     0.200
     0.339     2.803     0.200
     0.377     3.111     0.200
     0.527     4.260     0.200
     0.612     4.943     0.200
     0.711     5.196     0.200
     0.871     6.523     0.200
     0.775     5.790     0.200
     2.114    14.078     0.200
     2.499    13.435     0.200
     2.563    13.341     0.200
     2.563    14.358     0.200
     3.077    14.896     0.200
     0.580     4.606     0.200
     0.991     6.689     0.200
     1.689    12.395     0.200
     2.180    13.308     0.200
     2.685    14.459     0.200
     0.183     1.318     0.200
     0.267     1.996     0.200
     0.284     2.142     0.200
     0.318     2.430     0.200
     0.357     2.265     0.200
     0.779     5.371     0.200
     0.783     5.185     0.200
     0.891     6.947     0.200
     0.936     6.868     0.200
     1.042     7.612     0.200
     1.055     8.080     0.200
     0.115     1.507     0.200
     0.235     2.238     0.200
     0.252     2.220     0.200
     0.421     3.110     0.200
     0.472     3.930     0.200
     0.497     3.720     0.200
     0.496     4.097     0.200
     0.599     4.429     0.200
     0.613     5.076     0.200
     0.634     4.974     0.200
     0.671     4.907     0.200
     0.882     6.268     0.200
     0.942     6.384     0.200
     1.008     7.242     0.200
     1.239     8.209     0.200
     1.519    10.392     0.200
     1.597    10.958     0.200
     1.687    12.072     0.200
     0.180     1.854     0.200
     0.309     2.240     0.200
     0.282     2.483     0.200
     0.321     2.431     0.200
     0.322     2.421     0.200
     0.335     2.533     0.200
     0.380     3.219     0.200
     0.422     3.241     0.200
     0.488     3.267     0.200
     0.473     3.518     0.200
     0.489     3.846     0.200
     0.572     4.347     0.200
     0.912     6.382     0.200
     1.051     7.510     0.200
     1.219     8.648     0.200
     1.560    11.192     0.200
     0.219     1.756     0.200
     0.300     2.557     0.200
     0.368     2.567     0.200
     0.364     2.854     0.200
     0.442     3.480     0.200
     0.503     4.053     0.200
     0.539     3.957     0.200
     0.584     4.250     0.200
     0.737     5.201     0.200
     0.813     5.916     0.200
     1.544    10.987     0.200
     1.666    11.875     0.200
     0.792     5.245     0.200
     1.542    10.666     0.200
     1.930    13.112     0.200
     2.714    15.032     0.200
     0.154     1.931     0.200
     0.192     2.138     0.200
     0.247     2.348     0.200
     0.325     2.838     0.200
     0.325     2.393     0.200
     0.684     5.278     0.200
     0.702     5.630     0.200
     0.745     5.100     0.200
     0.749     5.522     0.200
     0.803     6.049     0.200
     0.834     6.436     0.200
     0.899     6.529     0.200
     0.965     7.054     0.200
     0.998     7.551     0.200
     1.037     7.058     0.200
     0.147     2.146     0.200
     0.155     2.187     0.200
     0.228     2.135     0.200
     0.402     3.314     0.200
     0.408     2.888     0.200
     0.448     3.207     0.200
     0.502     3.705     0.200
     0.593     4.985     0.200
     0.660     5.165     0.200
     0.681     5.219     0.200
     0.740     5.930     0.200
     0.772     5.893     0.200
     0.784     6.121     0.200
     0.799     5.693     0.200
     0.807     6.261     0.200
     0.817     6.305     0.200
     0.882     6.934     0.200
     0.937     7.022     0.200
     1.044     7.390     0.200
     0.072     1.336     0.200
     0.233     2.301     0.200
     0.277     2.171     0.200
     0.351     2.969     0.200
     0.372     3.016     0.200
     0.396     3.295     0.200
     0.418     3.538     0.200
     0.455     3.403     0.200
     0.470     3.315     0.200
     0.539     3.777     0.200
     0.545     4.067     0.200
     0.603     4.506     0.200
     0.686     4.858     0.200
     0.736     5.896     0.200
     0.765     5.567     0.200
     0.777     5.797     0.200
     0.870     5.998     0.200
     0.919     7.242     0.200
     0.977     6.420     0.200
     1.212     7.821     0.200
     1.610    11.463     0.200
     0.090     2.145     0.200
     0.194     1.935     0.200
     0.290     2.815     0.200
     0.301     2.775     0.200
     0.458     3.474     0.200
     0.511     4.114     0.200
     0.679     4.405     0.200
     0.697     4.998     0.200
     0.723     5.610     0.200
     0.105     1.896     0.200
     0.176     2.030     0.200
     0.278     2.733     0.200
     0.320     2.674     0.200
     0.450     3.544     0.200
     0.493     3.866     0.200
     0.679     4.794     0.200
     0.700     5.211     0.200
     0.717     5.192     0.200
     0.835     5.788     0.200
     0.160     1.931     0.200
     0.269     2.123     0.200
     0.255     2.915     0.200
     0.430     3.454     0.200
     0.469     4.069     0.200
     0.467     4.058     0.200
     0.476     4.096     0.200
     0.705     4.611     0.200
     0.997     6.986     0.200
     1.796    11.972     0.200
     1.955    13.124     0.200
     0.117     1.202     0.200
     0.162     1.684     0.200
     0.182     1.458     0.200
     0.270     2.415     0.200
     0.334     2.082     0.200
     0.444     3.284     0.200
     0.479     3.685     0.200
     0.665     5.313     0.200
     0.686     4.491     0.200
     0.694     5.357     0.200
     0.701     4.860     0.200
     0.711     5.373     0.200
     0.751     4.695     0.200
     0.821     5.993     0.200
     0.998     7.708     0.200
     1.217     8.530     0.200
     0.173     1.862     0.200
     0.309     2.100     0.200
     0.305     2.441     0.200
     0.288     2.639     0.200
     0.309     2.680     0.200
     0.314     2.778     0.200
     0.377     3.157     0.200
     0.404     3.296     0.200
     0.458     3.655     0.200
     0.479     3.007     0.200
     0.489     4.206     0.200
     0.559     4.292     0.200
     0.648     5.279     0.200
     0.678     4.626     0.200
     0.688     4.742     0.200
     0.658     5.042     0.200
     0.707     5.428     0.200
     0.800     5.401     0.200
     0.813     5.676     0.200
     0.827     5.768     0.200
     0.870     6.062     0.200
     0.895     6.370     0.200
     1.038     6.884     0.200
     1.087     7.623     0.200
     1.177     7.966     0.200
     1.211     8.215     0.200
     1.234     8.316     0.200
     1.678    11.711     0.200
     1.693    11.603     0.200
     1.737    12.402     0.200
     1.820    12.923     0.200
     1.835    12.470     0.200
     1.873    12.551     0.200
     1.896    12.843     0.200
     0.649     5.538     0.200
     0.816     5.403     0.200
     0.860     6.280     0.200
     2.055    14.692     0.200
     2.020    14.031     0.200
     2.450    14.638     0.200
     2.501    14.926     0.200
     3.010    15.932     0.200
     0.120     1.780     0.200
     0.157     2.354     0.200
     0.179     2.091     0.200
     0.269     3.139     0.200
     0.475     4.518     0.200
     0.546     4.398     0.200
     0.694     5.157     0.200
     0.699     5.204     0.200
     0.707     4.948     0.200
     0.753     5.402     0.200
     0.817     5.802     0.200
     0.963     6.737     0.200
     0.101     1.609     0.200
     0.221     2.110     0.200
     0.523     3.764     0.200
     0.530     4.114     0.200
     0.535     4.129     0.200
     0.559     4.012     0.200
     0.587     5.013     0.200
     0.730     6.171     0.200
     0.755     5.671     0.200
     0.801     6.422     0.200
     0.856     6.273     0.200
     0.905     6.979     0.200
     1.057     7.575     0.200
     1.079     7.777     0.200
     1.497    10.177     0.200
     0.117     2.495     0.200
     0.179     3.093     0.200
     0.256     3.028     0.200
     0.338     3.683     0.200
     0.390     4.184     0.200
     0.424     3.844     0.200
     0.413     4.159     0.200
     0.869     5.935     0.200
     0.881     5.977     0.200
     1.462     9.456     0.200
     2.035    12.224     0.200
     0.170     1.963     0.200
     0.275     2.468     0.200
     0.262     2.812     0.200
     0.359     2.983     0.200
     0.437     3.509     0.200
     0.461     3.584     0.200
     0.470     4.047     0.200
     0.478     3.699     0.200
     0.477     3.886     0.200
     0.484     4.138     0.200
     0.537     4.168     0.200
     0.701     4.803     0.200
     0.687     5.544     0.200
     0.956     7.421     0.200
     0.995     6.898     0.200
     1.051     7.757     0.200
     1.790    11.540     0.200
     2.045    12.836     0.200
     0.207     1.285     0.200
     0.234     2.150     0.200
     0.323     2.727     0.200
     0.381     3.144     0.200
     0.441     3.632     0.200
     0.523     3.753     0.200
     0.534     3.727     0.200
     0.541     4.012     0.200
     0.693     5.071     0.200
     0.797     5.548     0.200
     0.821     5.977     0.200
     0.847     6.429     0.200
     0.923     7.052     0.200
     1.006     6.864     0.200
     1.565    11.598     0.200
     0.033     1.754     0.200
     0.154     1.893     0.200
     0.320     1.990     0.200
     0.370     2.763     0.200
     0.387     2.763     0.200
     0.476     3.686     0.200
     0.461     3.716     0.200
     0.763     4.750     0.200
     1.089     7.768     0.200
     1.119     7.969     0.200
     1.277     8.888     0.200
     1.715    11.927     0.200
     1.842    12.556     0.200
     1.909    12.643     0.200
     1.966    12.781     0.200
     2.117    13.571     0.200
     0.172     1.641     0.200
     0.279     1.852     0.200
     0.300     2.447     0.200
     0.295     1.847     0.200
     0.339     2.556     0.200
     0.382     2.824     0.200
     0.440     3.466     0.200
     0.499     3.835     0.200
     0.546     4.487     0.200
     0.625     4.180     0.200
     0.666     4.261     0.200
     0.656     5.089     0.200
     0.709     5.771     0.200
     0.821     5.291     0.200
     0.816     6.082     0.200
     0.866     6.041     0.200
     0.869     6.211     0.200
     1.013     7.582     0.200
     1.070     7.163     0.200
     1.156     8.571     0.200
     1.217     8.554     0.200
     1.539    11.045     0.200
     1.548    11.132     0.200
     1.606    11.823     0.200
     1.664    11.638     0.200
     1.670    11.855     0.200
     1.816    12.756     0.200
     1.862    12.706     0.200
     0.095     4.260     0.200
     0.211     3.910     0.200
     0.286     3.296     0.200
     0.349     3.860     0.200
     0.368     3.780     0.200
     0.510     4.672     0.200
     0.526     4.353     0.200
     0.539     4.230     0.200
     0.533     4.608     0.200
     0.587     4.688     0.200
     0.628     5.148     0.200
     0.674     5.333     0.200
     1.130     8.195     0.200
     1.216     8.473     0.200
     1.455     9.080     0.200
     1.516     9.780     0.200
     1.542    10.071     0.200
     1.691    10.894     0.200
     1.926    11.836     0.200
     0.157     1.391     0.200
     0.158     1.924     0.200
     0.237     2.535     0.200
     0.297     2.370     0.200
     0.364     2.684     0.200
     0.361     2.915     0.200
     0.456     3.451     0.200
     0.494     3.518     0.200
     0.467     3.632     0.200
     0.488     3.450     0.200
     0.711     4.510     0.200
     0.734     4.843     0.200
     1.079     7.373     0.200
     1.091     7.945     0.200
     1.813    12.634     0.200
     1.822    12.701     0.200
     1.938    13.249     0.200
     0.096     1.418     0.200
     0.113     1.457     0.200
     0.142     0.957     0.200
     0.212     2.727     0.200
     0.258     2.117     0.200
     0.327     2.319     0.200
     0.420     2.675     0.200
     0.431     3.823     0.200
     0.438     3.055     0.200
     0.480     3.140     0.200
     0.671     4.653     0.200
     0.738     4.977     0.200
     1.035     7.270     0.200
     1.100     7.844     0.200
     1.134     7.797     0.200
     1.617    11.220     0.200
     1.813    12.129     0.200
     1.821    12.629     0.200
     1.833    12.258     0.200
     1.884    12.435     0.200
     2.088    14.199     0.200
     0.037     2.393     0.200
     0.280     2.591     0.200
     0.390     3.528     0.200
     0.422     3.941     0.200
     0.551     4.185     0.200
     0.560     3.845     0.200
     0.584     4.651     0.200
     0.665     4.526     0.200
     0.825     5.991     0.200
     0.826     5.631     0.200
     0.872     6.644     0.200
     0.917     6.683     0.200
     0.973     6.930     0.200
     1.008     7.067     0.200
     1.264     8.446     0.200
     1.579    10.573     0.200
     0.187     2.033     0.200
     0.226     2.222     0.200
     0.256     2.120     0.200
     0.333     2.764     0.200
     0.401     2.716     0.200
     0.501     3.777     0.200
     0.554     3.799     0.200
     0.680     4.729     0.200
     0.704     5.357     0.200
     0.826     5.940     0.200
     0.832     6.631     0.200
     0.851     6.575     0.200
     0.861     6.081     0.200
     0.876     6.532     0.200
     0.893     6.271     0.200
     0.037     1.380     0.200
     0.214     1.930     0.200
     0.537     3.829     0.200
     0.591     4.261     0.200
     0.691     5.039     0.200
     0.813     6.144     0.200
     0.834     6.070     0.200
     0.910     6.566     0.200
     0.968     7.040     0.200
     1.040     7.520     0.200
     1.179     8.404     0.200
     1.730    12.161     0.200
     1.794    12.106     0.200
     1.808    12.702     0.200
     1.956    13.187     0.200
     1.995    13.031     0.200
     2.165    14.379     0.200
     2.201    14.259     0.200
     0.098     0.703     0.200
     0.144     1.775     0.200
     0.250     1.896     0.200
     0.314     2.302     0.200
     0.410     3.209     0.200
     0.451     3.633     0.200
     0.447     3.291     0.200
     0.449     3.545     0.200
     0.547     3.583     0.200
     0.664     5.061     0.200
     1.067     7.919     0.200
     1.206     8.400     0.200
     1.384     9.476     0.200
     1.651    12.117     0.200
     1.779    12.261     0.200
     1.783    12.901     0.200
     1.800    12.187     0.200
     1.852    13.055     0.200
     1.915    13.590     0.200
     2.056    13.869     0.200
     0.151     2.266     0.200
     0.203     2.122     0.200
     0.318     2.620     0.200
     0.314     2.831     0.200
     0.318     2.658     0.200
     0.412     3.583     0.200
     0.505     3.215     0.200
     0.589     4.729     0.200
     0.610     4.073     0.200
     0.730     5.443     0.200
     0.739     5.561     0.200
     0.788     5.747     0.200
     0.783     5.136     0.200
     0.825     6.136     0.200
     0.850     5.204     0.200
     0.911     7.190     0.200
     0.098     2.211     0.200
     0.077     2.713     0.200
     0.159     1.953     0.200
     0.351     3.045     0.200
     0.300     3.367     0.200
     0.349     3.077     0.200
     0.428     3.218     0.200
     0.461     3.726     0.200
     0.480     3.963     0.200
     0.498     3.823     0.200
     0.490     4.257     0.200
     0.569     4.390     0.200
     0.611     4.478     0.200
     0.724     5.061     0.200
     0.747     6.054     0.200
     0.879     5.996     0.200
     1.550    10.751     0.200
     1.604    10.886     0.200
     1.633    11.142     0.200
     1.817    11.959     0.200
     1.961    12.164     0.200
     1.975    12.252     0.200
     2.024    13.140     0.200
     2.090    13.407     0.200
     2.284    14.567     0.200
     0.594     4.856     0.200
     2.098    14.625     0.200
     0.057     3.856     0.200
     0.155     3.532     0.200
     0.221     3.811     0.200
     0.287     3.496     0.200
     0.318     3.887     0.200
     0.339     3.543     0.200
     0.418     4.231     0.200
     0.471     4.342     0.200
     0.545     4.966     0.200
     0.619     5.312     0.200
     0.623     4.975     0.200
     0.707     5.581     0.200
     0.804     5.622     0.200
     1.285     8.800     0.200
     1.716    10.371     0.200
     1.809    11.386     0.200
     0.194     2.466     0.200
     0.241     2.893     0.200
     0.277     3.310     0.200
     0.349     3.508     0.200
     0.345     3.766     0.200
     0.422     3.810     0.200
     0.404     4.060     0.200
     0.482     4.603     0.200
     0.577     4.137     0.200
     0.550     4.732     0.200
     0.327     2.753     0.200
     0.333     2.870     0.200
     0.334     3.025     0.200
     0.363     3.460     0.200
     0.426     4.087     0.200
     0.471     3.744     0.200
     0.506     3.253     0.200
     0.471     3.912     0.200
     0.566     4.102     0.200
     1.648    11.008     0.200
     0.083     1.534     0.200
     0.247     2.144     0.200
     0.266     2.599     0.200
     0.308     2.642     0.200
     0.322     3.038     0.200
     0.384     2.932     0.200
     0.424     3.432     0.200
     0.486     4.018     0.200
     0.612     4.598     0.200
     0.793     5.706     0.200
     0.871     6.511     0.200
     1.558    11.170     0.200
     1.551    10.135     0.200
     0.081     1.653     0.200
     0.106     1.937     0.200
     0.181     2.501     0.200
     0.269     2.628     0.200
     0.369     3.149     0.200
     0.432     3.445     0.200
     0.594     4.421     0.200
     0.663     5.323     0.200
     0.137     2.735     0.200
     0.117     3.124     0.200
     0.249     3.034     0.200
     0.357     3.147     0.200
     0.379     3.332     0.200
     0.423     3.715     0.200
     0.508     4.592     0.200
     0.643     5.037     0.200
     0.659     5.467     0.200
     0.681     5.019     0.200
     0.881     6.403     0.200
     0.895     6.196     0.200
     0.986     6.803     0.200
     1.377     9.925     0.200
     1.438    10.065     0.200
     0.106     1.599     0.200
     0.092     1.853     0.200
     0.137     2.295     0.200
     0.317     2.718     0.200
     0.392     3.181     0.200
     0.386     3.234     0.200
     0.459     3.397     0.200
     0.533     3.978     0.200
     0.514     4.250     0.200
     0.663     4.372     0.200
     1.496    10.261     0.200
     1.547    10.911     0.200
     1.576    11.009     0.200
     1.903    12.085     0.200
     1.966    13.294     0.200
     2.229    13.991     0.200
     0.193     2.333     0.200
     0.186     1.785     0.200
     0.360     3.098     0.200
     0.662     5.456     0.200
     0.704     5.091     0.200
     0.779     4.892     0.200
     0.775     4.982     0.200
     0.782     5.817     0.200
     0.783     5.990     0.200
     0.046     3.127     0.200
     0.112     2.937     0.200
     0.111     3.184     0.200
     0.104     3.290     0.200
     0.247     3.139     0.200
     0.244     3.035     0.200
     0.309     3.546     0.200
     0.366     3.743     0.200
     0.455     4.393     0.200
     0.446     4.552     0.200
     0.474     4.411     0.200
     0.561     4.745     0.200
     0.577     4.485     0.200
     0.913     5.703     0.200
     1.666    10.328     0.200
     1.726    10.343     0.200
     1.767    11.278     0.200
     1.843    11.906     0.200
     0.170     1.318     0.200
     0.154     1.719     0.200
     0.184     1.801     0.200
     0.299     2.155     0.200
     0.385     3.057     0.200
     0.396     2.896     0.200
     0.445     3.604     0.200
     0.512     4.073     0.200
     0.535     3.896     0.200
     0.544     4.366     0.200
     0.623     4.528     0.200
     0.756     5.543     0.200
     0.849     6.112     0.200
     0.919     6.637     0.200
     0.955     6.945     0.200
     1.094     7.922     0.200
     1.115     8.019     0.200
     0.179     1.355     0.200
     0.141     1.534     0.200
     0.180     1.603     0.200
     0.287     1.787     0.200
     0.303     2.313     0.200
     0.399     3.379     0.200
     0.406     3.324     0.200
     0.526     3.683     0.200
     0.549     3.725     0.200
     0.535     4.040     0.200
     0.636     4.453     0.200
     0.739     5.419     0.200
     0.787     5.661     0.200
     0.854     6.138     0.200
     0.952     7.132     0.200
     1.043     7.432     0.200
     1.049     7.544     0.200
     1.107     8.076     0.200
     0.106     2.119     0.200
     0.157     2.119     0.200
     0.233     2.786     0.200
     0.276     2.993     0.200
     0.333     3.095     0.200
     0.331     3.446     0.200
     0.379     3.678     0.200
     0.522     4.635     0.200
     0.579     4.913     0.200
     0.610     5.168     0.200
     0.152     1.739     0.200
     0.224     1.512     0.200
     0.238     2.026     0.200
     0.328     2.324     0.200
     0.370     2.825     0.200
     0.411     3.100     0.200
     0.460     3.544     0.200
     0.485     3.581     0.200
     0.559     4.210     0.200
     0.651     4.699     0.200
     0.664     4.931     0.200
     0.688     4.746     0.200
     0.699     5.405     0.200
     0.737     5.623     0.200
     0.759     5.483     0.200
     0.791     5.865     0.200
     0.836     5.877     0.200
     0.845     6.442     0.200
     0.849     6.326     0.200
     0.836     6.382     0.200
     0.916     6.574     0.200
     0.950     7.250     0.200
     1.085     7.750     0.200
     1.081     7.647     0.200
     1.098     8.176     0.200
     1.116     7.990     0.200
     1.128     8.153     0.200
     1.122     8.185     0.200
     1.168     8.579     0.200
     1.254     8.163     0.200
     0.084     1.906     0.200
     0.101     2.207     0.200
     0.173     2.267     0.200
     0.395     3.645     0.200
     0.407     3.846     0.200
     0.445     3.665     0.200
     0.457     3.815     0.200
     0.509     3.545     0.200
     0.528     4.058     0.200
     0.527     4.410     0.200
     0.627     4.515     0.200
     0.785     5.349     0.200
     1.009     7.097     0.200
     1.462    10.048     0.200
     1.512    10.290     0.200
     1.810    11.177     0.200
     2.031    12.524     0.200
     0.147     2.287     0.200
     0.156     1.895     0.200
     0.183     2.254     0.200
     0.204     2.436     0.200
     0.309     2.920     0.200
     0.369     3.154     0.200
     0.378     3.446     0.200
     0.553     4.755     0.200
     0.615     5.128     0.200
     0.626     5.134     0.200
     0.074     1.472     0.200
     0.138     1.666     0.200
     0.150     1.741     0.200
     0.171     1.478     0.200
     0.308     2.560     0.200
     0.326     2.407     0.200
     0.413     3.052     0.200
     0.450     3.478     0.200
     0.457     3.404     0.200
     0.546     4.171     0.200
     0.546     4.476     0.200
     0.570     4.325     0.200
     0.896     6.927     0.200
     0.085     1.438     0.200
     0.142     1.607     0.200
     0.154     1.551     0.200
     0.327     2.643     0.200
     0.341     2.784     0.200
     0.349     2.714     0.200
     0.389     2.615     0.200
     0.410     3.423     0.200
     0.461     3.414     0.200
     0.486     3.832     0.200
     0.530     3.954     0.200
     0.582     4.464     0.200
     0.606     4.424     0.200
     0.645     4.823     0.200
     0.161     1.867     0.200
     0.242     2.153     0.200
     0.267     2.266     0.200
     0.370     2.976     0.200
     0.393     3.469     0.200
     0.443     3.107     0.200
     0.437     3.286     0.200
     0.485     3.322     0.200
     0.560     4.402     0.200
     0.584     4.530     0.200
     0.600     4.340     0.200
     0.646     4.668     0.200
     0.636     4.923     0.200
     0.657     4.671     0.200
     0.710     5.369     0.200
     0.733     5.271     0.200
     0.745     5.265     0.200
     0.726     5.550     0.200
     0.787     5.571     0.200
     0.791     5.489     0.200
     0.806     6.018     0.200
     0.801     6.324     0.200
     0.853     6.300     0.200
     0.910     6.460     0.200
     0.923     7.252     0.200
     1.043     7.869     0.200
     1.052     7.755     0.200
     1.104     7.847     0.200
     1.118     7.968     0.200
     1.122     8.173     0.200
     1.184     7.868     0.200
     0.187     1.898     0.200
     0.251     2.435     0.200
     0.268     2.372     0.200
     0.303     2.545     0.200
     0.329     2.659     0.200
     0.451     3.128     0.200
     0.538     3.591     0.200
     0.576     4.345     0.200
     0.636     4.453     0.200
     0.779     5.557     0.200
     0.826     6.071     0.200
     0.837     5.953     0.200
     1.050     7.641     0.200
     0.163     1.879     0.200
     0.243     2.262     0.200
     0.263     2.534     0.200
     0.328     2.879     0.200
     0.333     2.994     0.200
     0.359     3.100     0.200
     0.388     3.013     0.200
     0.402     3.178     0.200
     0.445     3.910     0.200
     0.494     3.269     0.200
     0.553     4.096     0.200
     0.577     4.326     0.200
     0.596     4.439     0.200
     0.631     4.678     0.200
     0.664     4.801     0.200
     0.704     5.201     0.200
     0.778     5.802     0.200
     0.864     6.296     0.200
     1.007     7.379     0.200
     1.098     7.853     0.200
     1.794    12.691     0.200
     0.093     1.944     0.200
     0.088     1.756     0.200
     0.175     2.278     0.200
     0.256     2.440     0.200
     0.288     2.487     0.200
     0.358     2.842     0.200
     0.425     3.454     0.200
     0.491     3.979     0.200
     0.579     4.817     0.200
     0.585     4.431     0.200
     0.636     5.124     0.200
     0.654     5.127     0.200
     0.755     5.410     0.200
     0.913     6.474     0.200
     0.923     6.744     0.200
     1.079     7.780     0.200
     1.448    10.055     0.200
     1.776    12.173     0.200
     1.855    11.782     0.200
     0.201     2.539     0.200
     0.311     2.799     0.200
     0.315     2.734     0.200
     0.345     2.880     0.200
     0.384     3.490     0.200
     0.415     3.002     0.200
     0.399     3.680     0.200
     0.436     3.260     0.200
     0.475     3.921     0.200
     0.505     4.193     0.200
     0.586     4.373     0.200
     0.668     4.983     0.200
     0.764     5.633     0.200
     0.783     5.789     0.200
     1.442    10.127     0.200
     1.509    10.393     0.200
     0.105     1.996     0.200
     0.147     2.269     0.200
     0.173     2.057     0.200
     0.216     2.583     0.200
     0.230     2.620     0.200
     0.332     3.029     0.200
     0.378     3.088     0.200
     0.416     3.354     0.200
     0.453     3.820     0.200
     0.460     4.004     0.200
     0.453     3.773     0.200
     0.554     4.237     0.200
     0.584     4.758     0.200
     0.597     4.521     0.200
     0.657     5.027     0.200
     0.701     5.160     0.200
     0.712     5.463     0.200
     0.786     5.718     0.200
     1.012     7.384     0.200
     1.748    11.467     0.200
     1.824    11.436     0.200
     2.042    12.816     0.200
     0.112     1.365     0.200
     0.216     1.990     0.200
     0.247     2.510     0.200
     0.289     2.489     0.200
     0.313     2.359     0.200
     0.324     2.496     0.200
     0.343     2.768     0.200
     0.422     3.092     0.200
     0.422     3.160     0.200
     0.428     3.301     0.200
     0.641     4.797     0.200
     0.677     4.983     0.200
     0.060     1.071     0.200
     0.194     2.088     0.200
     0.228     2.250     0.200
     0.255     2.305     0.200
     0.346     2.818     0.200
     0.357     3.204     0.200
     0.385     3.006     0.200
     0.392     3.163     0.200
     0.370     3.373     0.200
     0.430     3.140     0.200
     0.469     3.738     0.200
     0.581     4.398     0.200
     0.539     4.500     0.200
     0.586     4.567     0.200
     0.609     4.893     0.200
     0.792     5.335     0.200
     0.794     5.412     0.200
     0.849     5.762     0.200
     0.926     6.488     0.200
     0.949     6.705     0.200
     0.941     7.053     0.200
     0.974     6.509     0.200
     0.980     6.554     0.200
     1.098     7.860     0.200
     1.190     8.207     0.200
     1.264     8.439     0.200
     1.530    11.081     0.200
     1.655    11.482     0.200
     1.662    11.398     0.200
     1.674    11.089     0.200
     1.667    11.323     0.200
     1.727    11.775     0.200
     1.767    12.123     0.200
     1.789    11.903     0.200
     1.831    12.210     0.200
     1.925    12.548     0.200
     1.933    12.627     0.200
     1.989    12.999     0.200
     1.992    13.134     0.200
     0.573     5.394     0.200
     2.464    17.627     0.200
     0.061     1.516     0.200
     0.112     1.904     0.200
     0.207     2.235     0.200
     0.279     2.517     0.200
     0.273     2.619     0.200
     0.328     2.773     0.200
     0.379     3.188     0.200
     0.456     3.503     0.200
     0.484     3.823     0.200
     0.559     4.008     0.200
     0.612     4.731     0.200
     0.644     5.277     0.200
     0.648     4.750     0.200
     0.683     5.647     0.200
     0.732     5.006     0.200
     0.733     5.034     0.200
     0.769     5.769     0.200
     1.587    10.641     0.200
     2.134    13.548     0.200
     0.177     1.901     0.200
     0.233     2.177     0.200
     0.354     2.881     0.200
     0.363     2.589     0.200
     0.355     3.003     0.200
     0.398     3.328     0.200
     0.444     3.231     0.200
     0.470     3.362     0.200
     0.598     4.476     0.200
     0.572     4.685     0.200
     0.941     7.195     0.200
     0.962     6.852     0.200
     1.282     8.710     0.200
     1.353     9.284     0.200
     1.690    11.508     0.200
     1.848    12.594     0.200
     0.140     1.650     0.200
     0.142     1.807     0.200
     0.169     1.765     0.200
     0.202     1.845     0.200
     0.328     2.506     0.200
     0.353     2.445     0.200
     0.367     2.907     0.200
     0.372     3.210     0.200
     0.381     2.883     0.200
     0.398     2.927     0.200
     0.432     3.192     0.200
     0.447     3.460     0.200
     0.451     4.077     0.200
     0.504     3.426     0.200
     0.503     3.873     0.200
     0.520     4.045     0.200
     0.534     3.771     0.200
     0.636     4.960     0.200
     0.643     4.743     0.200
     0.699     5.103     0.200
     0.681     5.055     0.200
     0.693     5.560     0.200
     0.714     5.098     0.200
     0.763     5.710     0.200
     0.925     7.200     0.200
     1.025     7.759     0.200
     1.493    10.892     0.200
     1.530    10.851     0.200
     1.658    11.888     0.200
     1.735    11.931     0.200
     1.861    12.609     0.200
     0.150     1.474     0.200
     0.144     1.066     0.200
     0.176     1.185     0.200
     0.259     2.145     0.200
     0.275     2.473     0.200
     0.379     2.879     0.200
     0.374     2.860     0.200
     0.446     3.178     0.200
     0.455     3.599     0.200
     0.447     3.170     0.200
     0.500     3.503     0.200
     0.611     3.828     0.200
     0.616     4.442     0.200
     0.631     4.274     0.200
     0.628     4.752     0.200
     0.637     5.399     0.200
     0.683     4.807     0.200
     0.702     5.358     0.200
     0.779     5.468     0.200
     0.818     6.442     0.200
     0.861     6.588     0.200
     0.935     6.944     0.200
     0.963     7.117     0.200
     0.981     6.825     0.200
     1.126     8.028     0.200
     1.602    11.534     0.200
     1.633    12.154     0.200
     1.782    12.696     0.200
     1.914    13.653     0.200
     1.991    13.911     0.200
     2.013    13.783     0.200
     2.124    14.067     0.200
     0.092     1.585     0.200
     0.226     1.975     0.200
     0.229     2.419     0.200
     0.254     2.198     0.200
     0.367     2.995     0.200
     0.432     3.474     0.200
     0.507     4.101     0.200
     0.509     3.831     0.200
     0.611     4.232     0.200
     0.677     4.565     0.200
     0.682     5.174     0.200
     0.683     5.141     0.200
     0.845     6.016     0.200
     0.124     3.053     0.200
     0.134     2.947     0.200
     0.155     3.493     0.200
     0.269     3.668     0.200
     0.291     3.186     0.200
     0.318     3.338     0.200
     0.496     4.027     0.200
     0.544     4.257     0.200
     0.532     4.528     0.200
     0.556     4.771     0.200
     0.618     4.572     0.200
     0.672     5.099     0.200
     0.764     5.737     0.200
     0.808     5.430     0.200
     0.875     5.972     0.200
     0.157     0.976     0.200
     0.273     1.913     0.200
     0.284     1.664     0.200
     0.322     2.492     0.200
     0.344     2.234     0.200
     0.360     2.195     0.200
     0.420     2.599     0.200
     0.443     2.978     0.200
     0.464     3.381     0.200
     0.507     3.604     0.200
     0.543     3.773     0.200
     0.563     4.559     0.200
     0.588     4.410     0.200
     0.637     4.805     0.200
     0.722     5.452     0.200
     0.795     5.508     0.200
     0.795     6.051     0.200
     0.790     5.455     0.200
     0.820     6.436     0.200
     0.921     6.952     0.200
     1.065     7.162     0.200
     1.725    13.062     0.200
     0.095     1.251     0.200
     0.101     1.165     0.200
     0.319     2.821     0.200
     0.437     2.861     0.200
     0.464     3.820     0.200
     0.467     3.252     0.200
     0.534     4.349     0.200
     0.655     4.886     0.200
     0.815     5.720     0.200
     1.026     7.545     0.200
     1.035     7.495     0.200
     1.542    11.110     0.200
     1.759    11.934     0.200
     1.840    11.579     0.200
     1.897    13.097     0.200
     1.908    12.358     0.200
     1.961    13.087     0.200
     2.023    13.068     0.200
     2.224    14.795     0.200
     1.973    14.412     0.200
     2.149    14.461     0.200
     2.161    14.861     0.200
     2.667    15.105     0.200
     3.148    17.156     0.200
     0.056     1.766     0.200
     0.137     1.530     0.200
     0.180     2.255     0.200
     0.198     2.450     0.200
     0.310     3.121     0.200
     0.413     3.347     0.200
     0.412     3.205     0.200
     0.486     3.559     0.200
     0.554     4.876     0.200
     0.563     4.245     0.200
     0.578     4.945     0.200
     0.626     4.870     0.200
     1.000     7.388     0.200
     1.064     7.253     0.200
     2.000    13.610     0.200
     0.162     1.543     0.200
     0.195     1.481     0.200
     0.199     2.019     0.200
     0.318     2.947     0.200
     0.313     2.953     0.200
     0.345     3.033     0.200
     0.532     3.753     0.200
     0.574     4.140     0.200
     0.672     5.262     0.200
     0.663     4.737     0.200
     0.691     5.184     0.200
     0.851     5.805     0.200
     0.904     6.448     0.200
     0.974     7.472     0.200
     0.205     1.602     0.200
     0.268     2.358     0.200
     0.271     2.286     0.200
     0.271     2.204     0.200
     0.281     2.046     0.200
     0.325     2.310     0.200
     0.369     3.041     0.200
     0.381     3.060     0.200
     0.467     2.941     0.200
     0.453     3.555     0.200
     0.546     4.180     0.200
     0.592     4.463     0.200
     0.624     4.674     0.200
     0.626     4.420     0.200
     0.625     4.578     0.200
     0.697     5.175     0.200
     0.834     5.917     0.200
     1.620    11.711     0.200
     1.982    13.866     0.200
     0.080     2.545     0.200
     0.116     2.360     0.200
     0.191     2.307     0.200
     0.189     2.582     0.200
     0.241     3.051     0.200
     0.302     3.004     0.200
     0.350     3.528     0.200
     0.355     2.904     0.200
     0.492     4.307     0.200
     0.499     4.132     0.200
     0.563     4.268     0.200
     0.679     5.128     0.200
     0.739     5.424     0.200
     0.762     6.137     0.200
     0.752     5.643     0.200
     0.769     5.614     0.200
     0.775     5.988     0.200
     0.809     6.163     0.200
     0.887     6.307     0.200
     0.177     2.056     0.200
     0.159     2.095     0.200
     0.203     2.591     0.200
     0.243     2.229     0.200
     0.362     2.795     0.200
     0.341     2.992     0.200
     0.406     2.899     0.200
     0.444     3.775     0.200
     0.464     3.206     0.200
     0.614     4.046     0.200
     0.633     4.767     0.200
     0.635     5.493     0.200
     0.653     4.954     0.200
     0.689     4.773     0.200
     0.710     5.665     0.200
     0.762     5.107     0.200
     0.758     5.260     0.200
     0.785     5.930     0.200
     0.774     5.776     0.200
     0.785     6.303     0.200
     0.818     6.575     0.200
     0.869     6.707     0.200
     0.929     6.835     0.200
     1.004     7.232     0.200
     1.169     7.119     0.200
     1.433    10.095     0.200
     0.031     1.572     0.200
     0.128     1.377     0.200
     0.208     1.748     0.200
     0.327     2.664     0.200
     0.250     2.663     0.200
     0.323     3.015     0.200
     0.385     3.075     0.200
     0.469     3.672     0.200
     0.503     3.992     0.200
     0.475     4.152     0.200
     0.603     4.609     0.200
     0.655     4.922     0.200
     0.776     5.626     0.200
     0.770     6.334     0.200
     0.927     6.557     0.200
     0.928     6.456     0.200
     1.177     8.308     0.200
     1.652    11.505     0.200
     1.808    12.232     0.200
     1.863    12.455     0.200
     1.933    12.313     0.200
     2.005    13.063     0.200
     2.011    13.173     0.200
     2.025    12.736     0.200
     2.167    13.853     0.200
     2.274    14.319     0.200
     2.272    14.515     0.200
     2.331    15.147     0.200
     0.110     2.055     0.200
     0.189     2.838     0.200
     0.235     2.765     0.200
     0.357     3.394     0.200
     0.391     3.053     0.200
     0.419     3.865     0.200
     0.579     4.713     0.200
     0.638     5.126     0.200
     0.660     5.567     0.200
     0.661     5.213     0.200
     0.762     5.655     0.200
     1.005     7.053     0.200
     1.967    12.594     0.200
     0.118     2.133     0.200
     0.195     2.730     0.200
     0.394     3.233     0.200
     0.398     3.195     0.200
     0.409     2.614     0.200
     0.424     3.166     0.200
     0.451     3.670     0.200
     0.585     4.287     0.200
     0.586     4.252     0.200
     0.638     4.808     0.200
     0.708     5.492     0.200
     0.106     1.324     0.200
     0.112     1.461     0.200
     0.117     1.184     0.200
     0.157     1.431     0.200
     0.271     1.943     0.200
     0.359     2.550     0.200
     0.363     2.614     0.200
     0.399     2.911     0.200
     0.421     3.121     0.200
     0.477     3.103     0.200
     0.591     4.394     0.200
     0.644     4.506     0.200
     0.688     4.904     0.200
     0.703     5.398     0.200
     0.731     5.246     0.200
     0.746     5.100     0.200
     0.796     5.641     0.200
     0.811     5.904     0.200
     0.161     1.940     0.200
     0.290     2.392     0.200
     0.305     2.562     0.200
     0.302     2.526     0.200
     0.310     2.617     0.200
     0.362     3.021     0.200
     0.436     3.076     0.200
     0.433     3.589     0.200
     0.449     3.421     0.200
     0.464     3.784     0.200
     0.556     4.251     0.200
     0.628     4.581     0.200
     0.698     5.340     0.200
     0.723     5.653     0.200
     0.737     5.103     0.200
     0.796     5.996     0.200
     0.836     6.270     0.200
     0.807     6.056     0.200
     0.841     6.418     0.200
     0.866     6.009     0.200
     1.462    10.773     0.200
     1.739    11.924     0.200
     0.051     0.321     0.200
     0.160     1.652     0.200
     0.196     1.663     0.200
     0.173     1.802     0.200
     0.282     2.044     0.200
     0.294     2.659     0.200
     0.360     2.729     0.200
     0.389     2.831     0.200
     0.409     3.165     0.200
     0.414     3.321     0.200
     0.458     3.465     0.200
     0.511     3.431     0.200
     0.506     4.057     0.200
     0.537     4.288     0.200
     0.606     4.608     0.200
     0.651     4.243     0.200
     0.683     5.065     0.200
     0.723     5.056     0.200
     0.862     5.784     0.200
     0.871     5.896     0.200
     0.877     5.960     0.200
     0.929     6.647     0.200
     0.950     6.732     0.200
     0.954     6.720     0.200
     1.030     7.322     0.200
     1.015     7.351     0.200
     1.044     7.407     0.200
     1.044     7.157     0.200
     1.141     8.232     0.200
     1.171     8.814     0.200
     1.259     8.801     0.200
     1.375     9.584     0.200
     1.405     9.765     0.200
     1.672    11.334     0.200
     1.719    12.251     0.200
     1.733    12.313     0.200
     1.749    11.914     0.200
     1.796    13.229     0.200
     1.893    13.286     0.200
     1.995    13.758     0.200
     1.998    13.522     0.200
     2.056    13.990     0.200
     0.780     5.825     0.200
     1.120     8.442     0.200
     1.822    14.166     0.200
     1.984    13.070     0.200
     2.067    13.247     0.200
     2.327    15.415     0.200
     2.312    14.128     0.200
     2.527    15.691     0.200
     0.108     1.736     0.200
     0.165     1.989     0.200
     0.226     2.071     0.200
     0.357     2.658     0.200
     0.392     3.044     0.200
     0.459     3.243     0.200
     0.545     4.199     0.200
     0.603     4.837     0.200
     0.629     4.961     0.200
     0.650     4.870     0.200
     0.719     5.646     0.200
     1.001     7.501     0.200
     1.514    10.756     0.200
     0.658     5.968     0.200
     1.606    12.894     0.200
     1.818    12.933     0.200
     2.013    13.951     0.200
     2.111    13.834     0.200
     2.284    13.462     0.200
     2.555    14.192     0.200
     2.785    14.935     0.200
     0.147     1.910     0.200
     0.136     1.660     0.200
     0.199     2.055     0.200
     0.229     2.439     0.200
     0.356     2.937     0.200
     0.377     3.452     0.200
     0.432     3.331     0.200
     0.541     4.493     0.200
     0.602     4.748     0.200
     0.620     5.054     0.200
     0.625     4.749     0.200
     0.693     5.222     0.200
     0.730     5.244     0.200
     0.974     7.450     0.200
     0.210     1.648     0.200
     0.302     2.361     0.200
     0.313     2.375     0.200
     0.336     2.545     0.200
     0.360     2.639     0.200
     0.399     2.473     0.200
     0.381     2.828     0.200
     0.422     3.062     0.200
     0.461     3.464     0.200
     0.484     3.676     0.200
     0.510     3.684     0.200
     0.516     4.059     0.200
     0.532     4.018     0.200
     0.571     4.201     0.200
     0.681     4.869     0.200
     0.681     4.904     0.200
     0.747     5.548     0.200
     0.768     5.313     0.200
     0.775     5.683     0.200
     0.854     6.130     0.200
     0.848     6.449     0.200
     1.026     7.568     0.200
     1.074     7.919     0.200
     1.801    12.439     0.200
     0.071     1.129     0.200
     0.168     1.512     0.200
     0.294     2.185     0.200
     0.383     3.132     0.200
     0.451     3.357     0.200
     0.512     3.966     0.200
     0.515     3.626     0.200
     0.538     3.557     0.200
     0.730     5.050     0.200
     0.732     5.054     0.200
     0.787     5.954     0.200
     0.808     5.617     0.200
     0.801     5.524     0.200
     0.816     6.176     0.200
     0.807     5.462     0.200
     0.116     1.107     0.200
     0.204     1.848     0.200
     0.267     1.757     0.200
     0.311     2.237     0.200
     0.328     2.055     0.200
     0.342     2.378     0.200
     0.360     2.974     0.200
     0.462     3.461     0.200
     0.524     3.488     0.200
     0.532     3.851     0.200
     0.584     4.472     0.200
     0.652     4.632     0.200
     0.684     5.130     0.200
     0.714     5.397     0.200
     0.682     5.269     0.200
     0.708     5.465     0.200
     0.735     5.170     0.200
     0.767     5.771     0.200
     0.855     6.359     0.200
     0.842     7.091     0.200
     0.915     6.371     0.200
     0.918     6.072     0.200
     0.942     6.849     0.200
     1.050     7.552     0.200
     1.066     7.831     0.200
     1.168     8.389     0.200
     1.347     9.347     0.200
     1.421     9.481     0.200
     1.580    11.120     0.200
     1.646    11.792     0.200
     1.671    11.392     0.200
     1.734    11.879     0.200
     0.145     2.048     0.200
     0.189     2.107     0.200
     0.288     2.418     0.200
     0.292     2.522     0.200
     0.317     2.782     0.200
     0.310     2.692     0.200
     0.396     3.229     0.200
     0.440     3.154     0.200
     0.458     3.087     0.200
     0.463     3.886     0.200
     0.507     3.446     0.200
     0.510     4.194     0.200
     0.575     4.259     0.200
     0.568     4.702     0.200
     0.667     4.683     0.200
     0.674     4.744     0.200
     0.730     6.240     0.200
     0.727     5.326     0.200
     0.781     5.835     0.200
     0.799     5.710     0.200
     0.809     6.092     0.200
     0.836     5.582     0.200
     0.882     6.331     0.200
     1.021     7.301     0.200
     1.020     7.222     0.200
     1.065     7.593     0.200
     1.190     8.275     0.200
     1.528    10.733     0.200
     1.516    10.718     0.200
     1.540    10.727     0.200
     1.568    10.980     0.200
     1.601    11.499     0.200
     1.656    11.206     0.200
     1.716    11.720     0.200
     1.875    12.795     0.200
     0.136     2.297     0.200
     0.168     2.439     0.200
     0.149     2.259     0.200
     0.261     2.801     0.200
     0.358     3.440     0.200
     0.373     3.563     0.200
     0.446     4.004     0.200
     0.449     4.048     0.200
     0.440     3.584     0.200
     0.484     3.699     0.200
     0.564     4.857     0.200
     0.617     4.303     0.200
     0.612     5.165     0.200
     0.621     5.218     0.200
     0.684     5.427     0.200
     0.681     5.094     0.200
     0.685     5.568     0.200
     0.759     5.833     0.200
     0.777     6.168     0.200
     0.784     5.603     0.200
     0.805     5.681     0.200
     0.849     6.720     0.200
     1.557    10.563     0.200
     1.609    10.700     0.200
     1.787    11.514     0.200
     1.798    12.198     0.200
     1.995    13.111     0.200
     2.019    12.353     0.200
     2.131    13.830     0.200
     0.481     3.156     0.200
     0.584     5.622     0.200
     0.011     2.440     0.200
     0.113     1.691     0.200
     0.140     1.785     0.200
     0.172     2.140     0.200
     0.218     2.103     0.200
     0.240     2.320     0.200
     0.305     2.658     0.200
     0.333     2.129     0.200
     0.373     2.867     0.200
     0.438     2.794     0.200
     0.476     3.631     0.200
     0.474     3.722     0.200
     0.473     4.017     0.200
     0.487     3.925     0.200
     0.579     4.192     0.200
     0.609     4.555     0.200
     0.659     4.739     0.200
     0.692     4.472     0.200
     0.690     4.874     0.200
     0.721     4.674     0.200
     0.727     5.216     0.200
     0.744     5.289     0.200
     0.744     5.991     0.200
     0.776     5.790     0.200
     0.816     6.566     0.200
     0.840     6.145     0.200
     0.906     6.262     0.200
     0.960     7.287     0.200
     1.000     7.508     0.200
     1.026     7.762     0.200
     1.143     8.142     0.200
     1.250     8.431     0.200
     0.109     2.490     0.200
     0.177     2.378     0.200
     0.207     1.581     0.200
     0.305     2.856     0.200
     0.316     2.257     0.200
     0.364     3.200     0.200
     0.434     3.732     0.200
     0.439     3.181     0.200
     0.434     3.699     0.200
     0.515     3.881     0.200
     0.561     4.097     0.200
     0.584     4.430     0.200
     0.584     4.634     0.200
     0.586     4.367     0.200
     0.670     5.311     0.200
     0.711     5.353     0.200
     0.736     5.667     0.200
     0.719     5.227     0.200
     0.763     5.616     0.200
     0.813     6.037     0.200
     0.869     5.880     0.200
     0.893     6.383     0.200
     1.039     7.581     0.200
     1.074     7.467     0.200
     1.446    10.514     0.200
     1.529    10.917     0.200
     0.134     1.386     0.200
     0.132     1.695     0.200
     0.183     1.501     0.200
     0.255     2.302     0.200
     0.340     2.730     0.200
     0.328     2.604     0.200
     0.415     3.067     0.200
     0.420     3.134     0.200
     0.454     3.558     0.200
     0.465     3.210     0.200
     0.585     4.585     0.200
     0.588     4.636     0.200
     0.661     4.515     0.200
     0.658     5.039     0.200
     0.746     5.610     0.200
     0.770     5.395     0.200
     0.866     6.131     0.200
     0.927     6.929     0.200
     0.982     7.089     0.200
     0.986     6.635     0.200
     1.121     8.201     0.200
     1.162     8.069     0.200
     1.535    11.146     0.200
     1.596    11.435     0.200
     1.789    12.531     0.200
     1.913    13.641     0.200
     2.005    13.473     0.200
     0.148     2.337     0.200
     0.207     1.898     0.200
     0.270     2.256     0.200
     0.296     2.727     0.200
     0.329     2.700     0.200
     0.408     3.248     0.200
     0.431     2.626     0.200
     0.451     3.689     0.200
     0.571     4.298     0.200
     0.582     4.344     0.200
     0.602     4.247     0.200
     0.670     5.042     0.200
     0.723     5.363     0.200
     0.807     5.494     0.200
     0.799     6.291     0.200
     0.851     5.792     0.200
     0.925     6.934     0.200
     0.155     2.309     0.200
     0.249     2.632     0.200
     0.263     2.750     0.200
     0.318     3.162     0.200
     0.350     3.543     0.200
     0.393     3.598     0.200
     0.387     3.272     0.200
     0.440     4.105     0.200
     0.490     3.767     0.200
     0.578     4.022     0.200
     0.593     4.223     0.200
     0.659     4.738     0.200
     0.685     5.704     0.200
     0.700     5.922     0.200
     0.699     5.915     0.200
     0.773     5.934     0.200
     0.787     5.839     0.200
     0.850     6.597     0.200
     0.860     6.069     0.200
     0.915     6.990     0.200
     1.091     6.937     0.200
     1.668    10.893     0.200
     1.893    13.020     0.200
     0.040     1.092     0.200
     0.165     1.698     0.200
     0.175     1.965     0.200
     0.248     2.531     0.200
     0.311     2.791     0.200
     0.347     2.694     0.200
     0.376     3.096     0.200
     0.499     4.008     0.200
     0.471     3.747     0.200
     0.484     3.838     0.200
     0.505     4.112     0.200
     0.595     5.124     0.200
     0.710     4.992     0.200
     0.732     4.983     0.200
     0.783     5.540     0.200
     0.795     6.047     0.200
     0.933     6.454     0.200
     0.942     6.420     0.200
     0.995     6.237     0.200
     1.031     7.284     0.200
     1.065     7.591     0.200
     1.070     7.650     0.200
     1.087     8.000     0.200
     1.124     7.582     0.200
     1.135     7.659     0.200
     1.252     8.855     0.200
     1.604    11.176     0.200
     1.778    12.467     0.200
     1.985    13.644     0.200
     2.075    14.128     0.200
     2.086    13.833     0.200
     2.146    13.953     0.200
     0.660     6.534     0.200
     2.065    13.013     0.200
     2.245    13.329     0.200
     0.139     1.634     0.200
     0.128     1.865     0.200
     0.306     2.653     0.200
     0.371     2.800     0.200
     0.370     2.841     0.200
     0.528     3.235     0.200
     0.664     4.988     0.200
     0.679     5.153     0.200
     0.679     5.429     0.200
     0.841     6.695     0.200
     0.942     6.688     0.200
     1.008     7.307     0.200
     1.010     7.373     0.200
     1.042     7.335     0.200
     0.317     1.872     0.200
     0.295     2.472     0.200
     0.491     3.276     0.200
     0.526     3.786     0.200
     0.504     3.858     0.200
     0.528     3.523     0.200
     0.634     5.083     0.200
     0.688     5.006     0.200
     0.719     5.728     0.200
     0.724     5.720     0.200
     0.919     6.050     0.200
     1.031     7.600     0.200
     1.063     7.500     0.200
     1.198     8.582     0.200
     1.335     9.034     0.200
     1.532    10.699     0.200
     1.653    11.511     0.200
     1.711    11.898     0.200
     0.235     3.119     0.200
     0.261     3.031     0.200
     0.384     3.495     0.200
     0.413     4.118     0.200
     0.442     4.462     0.200
     0.488     4.592     0.200
     0.484     4.051     0.200
     0.555     3.926     0.200
     0.524     4.502     0.200
     0.570     4.561     0.200
     0.727     5.356     0.200
     0.742     5.543     0.200
     0.740     5.507     0.200
     0.814     5.747     0.200
     0.936     6.233     0.200
     1.504     9.568     0.200
     1.543    10.119     0.200
     1.721    10.672     0.200
     1.733    10.771     0.200
     1.940    12.031     0.200
     1.954    11.782     0.200
     0.212     1.670     0.200
     0.271     2.298     0.200
     0.385     2.535     0.200
     0.395     2.748     0.200
     0.411     3.665     0.200
     0.460     3.425     0.200
     0.525     3.139     0.200
     0.548     4.519     0.200
     0.548     4.238     0.200
     0.551     3.744     0.200
     0.650     4.574     0.200
     0.697     4.693     0.200
     0.738     5.388     0.200
     0.812     6.427     0.200
     0.880     6.182     0.200
     0.915     6.106     0.200
     0.892     6.726     0.200
     0.946     6.840     0.200
     1.693    11.973     0.200
     1.702    11.696     0.200
     1.814    12.811     0.200
     1.910    12.763     0.200
     1.925    12.673     0.200
     0.128     1.717     0.200
     0.173     2.231     0.200
     0.195     2.180     0.200
     0.234     2.428     0.200
     0.268     2.438     0.200
     0.349     2.775     0.200
     0.427     3.847     0.200
     0.481     4.084     0.200
     0.500     3.858     0.200
     0.524     4.076     0.200
     0.689     5.473     0.200
     0.719     5.505     0.200
     0.735     5.293     0.200
     0.826     6.315     0.200
     0.839     6.159     0.200
     0.947     6.969     0.200
     0.987     7.111     0.200
     0.999     6.930     0.200
     1.025     7.316     0.200
     1.454    10.370     0.200
     1.450    10.200     0.200
     0.211     2.676     0.200
     1.100     7.438     0.200
     0.121     1.673     0.200
     0.145     2.003     0.200
     0.240     1.519     0.200
     0.344     2.432     0.200
     0.367     3.159     0.200
     0.430     3.188     0.200
     0.409     3.580     0.200
     0.489     3.685     0.200
     0.541     4.020     0.200
     0.578     3.690     0.200
     0.831     5.680     0.200
     1.038     7.272     0.200
     1.042     7.218     0.200
     1.177     8.044     0.200
     1.224     8.342     0.200
     1.328     9.177     0.200
     1.560    10.797     0.200
     1.587    11.310     0.200
     1.707    12.015     0.200
     1.861    12.213     0.200
     1.897    12.963     0.200
     1.908    12.890     0.200
     1.921    12.840     0.200
     1.977    13.117     0.200
     2.005    13.298     0.200
     2.037    13.533     0.200
     2.183    13.824     0.200
     2.233    14.634     0.200
     2.242    14.425     0.200
     0.218     1.444     0.200
     0.254     1.877     0.200
     0.274     1.920     0.200
     0.337     2.847     0.200
     0.350     2.285     0.200
     0.366     2.762     0.200
     0.517     3.159     0.200
     0.514     3.175     0.200
     0.542     4.036     0.200
     0.626     4.225     0.200
     0.667     5.039     0.200
     0.681     5.034     0.200
     0.785     4.544     0.200
     0.855     6.655     0.200
     0.887     6.682     0.200
     1.206     8.520     0.200
     1.701    11.898     0.200
     1.916    13.221     0.200
     0.099     2.084     0.200
     0.101     2.168     0.200
     0.166     2.140     0.200
     0.266     2.365     0.200
     0.271     2.762     0.200
     0.297     2.428     0.200
     0.341     2.900     0.200
     0.428     3.150     0.200
     0.521     4.387     0.200
     0.545     4.449     0.200
     0.640     5.159     0.200
     0.705     5.308     0.200
     0.722     5.585     0.200
     0.739     5.317     0.200
     0.764     5.250     0.200
     0.766     4.893     0.200
     0.796     5.837     0.200
     0.835     5.226     0.200
     0.831     5.643     0.200
     0.835     6.438     0.200
     0.925     6.404     0.200
     0.984     6.841     0.200
     1.023     7.469     0.200
     1.025     7.286     0.200
     0.263     2.873     0.200
     0.716     7.473     0.200
     3.035    16.629     0.200
     0.060     1.867     0.200
     0.123     1.993     0.200
     0.203     2.628     0.200
     0.304     2.405     0.200
     0.388     3.303     0.200
     0.453     3.285     0.200
     0.510     3.709     0.200
     0.584     4.159     0.200
     0.615     4.490     0.200
     0.657     5.452     0.200
     0.684     5.249     0.200
     0.790     5.533     0.200
     0.917     7.189     0.200
     0.926     6.894     0.200
     1.451    10.248     0.200
     1.493    10.613     0.200
     1.749    11.952     0.200
     2.056    13.920     0.200
     2.160    13.689     0.200
     0.185     1.373     0.200
     0.266     1.929     0.200
     0.280     2.081     0.200
     0.267     2.043     0.200
     0.348     2.606     0.200
     0.461     2.957     0.200
     0.441     3.381     0.200
     0.527     3.814     0.200
     0.535     4.023     0.200
     0.743     5.733     0.200
     0.763     5.319     0.200
     0.870     5.883     0.200
     0.911     6.833     0.200
     0.998     7.185     0.200
     1.573    11.097     0.200
     1.603    11.349     0.200
     0.067     2.198     0.200
     0.107     1.832     0.200
     0.209     2.496     0.200
     0.339     3.175     0.200
     0.373     3.065     0.200
     0.456     3.175     0.200
     0.472     3.656     0.200
     0.547     3.682     0.200
     0.552     4.152     0.200
     0.609     4.404     0.200
     0.643     5.413     0.200
     0.680     5.447     0.200
     0.726     5.498     0.200
     0.761     5.675     0.200
     0.864     6.575     0.200
     0.857     6.697     0.200
     0.878     6.730     0.200
     0.888     6.714     0.200
     0.914     6.989     0.200
     1.456    10.277     0.200
     1.712    11.725     0.200
     1.743    12.181     0.200
     1.898    12.571     0.200
     2.101    14.389     0.200
     2.122    13.864     0.200
     2.232    14.080     0.200
     0.558     5.146     0.200
     0.778     5.723     0.200
     1.882    13.354     0.200
     2.954    16.029     0.200
     0.092     1.505     0.200
     0.178     2.036     0.200
     0.242     2.165     0.200
     0.265     2.336     0.200
     0.361     2.864     0.200
     0.404     3.277     0.200
     0.551     4.326     0.200
     0.608     4.800     0.200
     0.638     4.943     0.200
     0.930     6.821     0.200
     1.705    11.716     0.200
     0.097     2.488     0.200
     0.203     2.312     0.200
     0.224     2.148     0.200
     0.329     2.847     0.200
     0.340     2.964     0.200
     0.332     2.812     0.200
     0.465     3.464     0.200
     0.451     3.662     0.200
     0.793     5.781     0.200
     0.752     5.348     0.200
     0.061     1.565     0.200
     0.110     1.269     0.200
     0.131     1.424     0.200
     0.224     1.630     0.200
     0.231     1.699     0.200
     0.284     1.930     0.200
     0.279     2.801     0.200
     0.366     2.390     0.200
     0.443     2.804     0.200
     0.535     3.586     0.200
     0.527     3.763     0.200
     0.523     3.681     0.200
     0.958     7.013     0.200
     0.276     1.803     0.200
     1.263     7.715     0.200
     1.355     8.796     0.200
     1.898    12.453     0.200
     2.527    15.153     0.200
     2.588    15.023     0.200
     2.727    16.014     0.200
     0.208     2.000     0.200
     0.242     1.905     0.200
     0.328     2.797     0.200
     0.351     2.518     0.200
     0.351     2.828     0.200
     0.379     2.948     0.200
     0.469     3.324     0.200
     0.469     3.254     0.200
     0.710     5.155     0.200
     0.746     5.519     0.200
     0.790     5.201     0.200
     0.790     6.251     0.200
     0.790     6.000     0.200
     0.890     6.839     0.200
     1.081     7.744     0.200
     1.100     7.775     0.200
     0.073     1.545     0.200
     0.091     1.591     0.200
     0.150     1.241     0.200
     0.217     1.800     0.200
     0.228     1.692     0.200
     0.270     2.361     0.200
     0.265     2.121     0.200
     0.494     3.334     0.200
     0.538     3.812     0.200
     0.544     3.898     0.200
     1.061     7.479     0.200
     0.064     2.042     0.200
     0.095     1.979     0.200
     0.145     1.746     0.200
     0.213     2.256     0.200
     0.218     2.129     0.200
     0.268     2.683     0.200
     0.488     3.731     0.200
     0.526     4.145     0.200
     0.547     4.175     0.200
     0.628     4.568     0.200
     0.648     4.282     0.200
     0.691     5.100     0.200
     0.693     4.785     0.200
     0.722     5.322     0.200
     0.753     5.343     0.200
     0.753     5.282     0.200
     0.804     5.623     0.200
     1.065     7.677     0.200
     0.137     2.233     0.200
     0.134     2.379     0.200
     0.179     2.884     0.200
     0.246     2.670     0.200
     0.249     2.601     0.200
     0.280     2.635     0.200
     0.363     3.216     0.200
     0.356     3.172     0.200
     0.383     3.513     0.200
     0.394     3.023     0.200
     0.513     3.899     0.200
     0.518     4.380     0.200
     0.534     4.281     0.200
     0.567     4.115     0.200
     0.601     4.678     0.200
     0.650     4.671     0.200
     0.666     4.818     0.200
     0.722     5.798     0.200
     0.741     4.825     0.200
     0.762     5.627     0.200
     0.787     5.713     0.200
     0.801     6.410     0.200
     0.872     6.443     0.200
     0.868     6.824     0.200
     0.956     6.793     0.200
     1.509    10.869     0.200
     0.063     2.355     0.200
     0.102     2.192     0.200
     0.138     2.112     0.200
     0.223     2.420     0.200
     0.222     2.432     0.200
     0.276     2.747     0.200
     0.278     2.187     0.200
     0.435     3.422     0.200
     0.497     4.021     0.200
     0.532     4.266     0.200
     0.529     4.180     0.200
     0.637     4.713     0.200
     0.654     4.974     0.200
     0.665     4.731     0.200
     0.753     5.607     0.200
     1.138     7.529     0.200
     0.163     1.759     0.200
     0.190     1.736     0.200
     0.329     2.787     0.200
     0.382     2.918     0.200
     0.431     3.328     0.200
     0.423     3.294     0.200
     0.458     3.348     0.200
     0.488     3.518     0.200
     0.554     3.962     0.200
     0.587     4.238     0.200
     0.662     4.773     0.200
     0.680     5.131     0.200
     0.683     5.225     0.200
     0.707     5.215     0.200
     0.744     5.262     0.200
     0.753     5.703     0.200
     0.775     5.795     0.200
     0.849     6.170     0.200
     0.857     6.542     0.200
     0.871     6.320     0.200
     0.888     6.375     0.200
     0.933     6.459     0.200
     0.943     7.085     0.200
     0.959     7.327     0.200
     0.997     7.197     0.200
     1.114     7.828     0.200
     1.507    10.512     0.200
     1.530    11.170     0.200
     1.533    10.642     0.200
     1.668    11.600     0.200
     1.749    12.625     0.200
     1.749    12.288     0.200
     1.957    13.227     0.200
     1.976    12.868     0.200
     2.083    13.271     0.200
     0.135     1.491     0.200
     0.134     1.781     0.200
     0.181     1.665     0.200
     0.216     2.123     0.200
     0.257     2.463     0.200
     0.341     2.859     0.200
     0.331     2.810     0.200
     0.416     3.282     0.200
     0.420     3.338     0.200
     0.455     3.539     0.200
     0.661     4.878     0.200
     0.746     5.711     0.200
     0.751     5.162     0.200
     0.769     5.698     0.200
     0.770     5.533     0.200
     0.813     5.885     0.200
     0.866     5.992     0.200
     0.887     5.958     0.200
     0.901     6.231     0.200
     0.928     6.904     0.200
     0.974     6.487     0.200
     0.983     6.985     0.200
     0.984     6.697     0.200
     1.121     8.199     0.200
     1.533    11.317     0.200
     1.535    11.174     0.200
     1.571    11.219     0.200
     1.769    12.693     0.200
     1.787    12.322     0.200
     1.978    13.842     0.200
     2.004    13.884     0.200
     2.120    14.345     0.200
     0.020     2.600     0.200
     0.096     2.093     0.200
     0.148     1.916     0.200
     0.188     2.151     0.200
     0.238     2.165     0.200
     0.475     3.309     0.200
     0.481     3.881     0.200
     0.497     3.740     0.200
     0.504     4.175     0.200
     0.620     4.529     0.200
     0.680     4.715     0.200
     0.703     5.158     0.200
     0.736     5.488     0.200
     0.765     4.666     0.200
     1.116     7.822     0.200
     0.021     2.459     0.200
     0.106     1.901     0.200
     0.138     1.906     0.200
     0.188     2.076     0.200
     0.229     2.056     0.200
     0.380     2.828     0.200
     0.448     3.314     0.200
     0.482     3.693     0.200
     0.491     3.455     0.200
     0.487     3.764     0.200
     0.504     3.895     0.200
     0.584     4.233     0.200
     0.621     4.436     0.200
     0.625     4.404     0.200
     0.672     4.798     0.200
     0.676     5.294     0.200
     0.696     5.478     0.200
     0.709     5.456     0.200
     0.709     5.605     0.200
     0.726     4.789     0.200
     0.731     5.177     0.200
     0.759     5.594     0.200
     0.793     5.974     0.200
     0.817     5.857     0.200
     0.826     6.315     0.200
     0.856     6.066     0.200
     0.912     6.889     0.200
     0.995     7.229     0.200
     1.028     7.201     0.200
     0.134     2.656     0.200
     0.174     2.911     0.200
     0.207     2.855     0.200
     0.299     2.918     0.200
     0.337     3.142     0.200
     0.386     3.197     0.200
     0.486     3.688     0.200
     0.556     4.154     0.200
     0.583     4.378     0.200
     0.625     4.761     0.200
     0.644     5.312     0.200
     0.706     4.778     0.200
     0.724     5.387     0.200
     0.729     5.327     0.200
     0.731     5.424     0.200
     0.768     5.884     0.200
     0.839     5.118     0.200
     0.828     6.133     0.200
     0.939     6.763     0.200
     1.373     9.637     0.200
     2.702    16.046     0.200
     0.147     2.740     0.200
     0.188     2.805     0.200
     0.216     2.737     0.200
     0.313     3.020     0.200
     0.352     2.940     0.200
     0.397     3.215     0.200
     0.498     4.511     0.200
     0.562     4.108     0.200
     0.598     4.002     0.200
     0.636     4.901     0.200
     0.659     5.323     0.200
     0.700     4.928     0.200
     0.712     5.073     0.200
     0.736     5.776     0.200
     0.744     5.615     0.200
     0.783     5.577     0.200
     0.853     6.599     0.200
     0.870     6.670     0.200
     0.946     6.994     0.200
     0.958     6.693     0.200
     1.048     7.301     0.200
     0.157     2.494     0.200
     0.196     2.786     0.200
     0.219     2.815     0.200
     0.323     2.606     0.200
     0.360     2.881     0.200
     0.405     2.508     0.200
     0.568     4.345     0.200
     0.607     4.254     0.200
     0.641     4.746     0.200
     0.668     4.896     0.200
     0.706     4.782     0.200
     0.719     5.214     0.200
     0.745     5.349     0.200
     0.841     6.054     0.200
     0.876     6.634     0.200
     0.961     6.642     0.200
     0.062     1.915     0.200
     0.094     1.837     0.200
     0.147     1.571     0.200
     0.209     2.227     0.200
     0.214     2.074     0.200
     0.286     2.338     0.200
     0.346     2.018     0.200
     0.422     3.004     0.200
     0.484     3.467     0.200
     0.521     4.108     0.200
     0.526     3.912     0.200
     0.544     4.415     0.200
     0.623     4.624     0.200
     0.644     4.399     0.200
     0.651     4.097     0.200
     0.689     5.082     0.200
     0.691     5.004     0.200
     0.716     5.692     0.200
     0.748     4.737     0.200
     0.741     5.297     0.200
     0.867     6.844     0.200
     0.094     2.376     0.200
     0.107     2.191     0.200
     0.155     2.338     0.200
     0.262     2.467     0.200
     0.258     2.695     0.200
     0.287     2.737     0.200
     0.417     3.458     0.200
     0.499     3.807     0.200
     0.525     4.353     0.200
     0.560     4.188     0.200
     0.578     4.701     0.200
     0.609     4.755     0.200
     0.649     5.000     0.200
     0.694     5.148     0.200
     0.697     4.944     0.200
     0.729     5.066     0.200
     0.728     5.636     0.200
     0.737     5.861     0.200
     0.753     5.395     0.200
     0.756     5.528     0.200
     0.791     5.901     0.200
     0.825     5.047     0.200
     0.821     5.535     0.200
     0.842     6.350     0.200
     0.867     6.698     0.200
     1.034     7.293     0.200
     1.137     7.837     0.200
     0.185     2.073     0.200
     0.267     2.407     0.200
     0.303     2.613     0.200
     0.469     3.622     0.200
     0.696     5.981     0.200
     0.865     5.582     0.200
     0.852     6.276     0.200
     0.973     6.913     0.200
     0.994     7.046     0.200
     1.617    10.883     0.200
     0.100     2.049     0.200
     0.115     1.644     0.200
     0.151     2.076     0.200
     0.258     2.673     0.200
     0.317     2.746     0.200
     0.568     4.231     0.200
     0.591     4.480     0.200
     0.612     4.801     0.200
     0.636     4.559     0.200
     0.854     6.577     0.200
     0.960     6.928     0.200
     1.757    11.899     0.200
     0.035     1.564     0.200
     0.245     2.292     0.200
     0.367     2.454     0.200
     0.401     3.094     0.200
     0.453     3.436     0.200
     0.671     5.263     0.200
     0.683     5.964     0.200
     0.705     5.123     0.200
     0.859     5.634     0.200
     0.970     6.773     0.200
     1.082     7.601     0.200
     1.505    10.874     0.200
     0.138     1.631     0.200
     0.170     1.881     0.200
     0.191     1.773     0.200
     0.282     2.461     0.200
     0.293     2.498     0.200
     0.398     3.028     0.200
     0.451     3.595     0.200
     0.467     3.790     0.200
     0.522     3.527     0.200
     0.652     5.087     0.200
     0.661     5.264     0.200
     0.725     5.607     0.200
     0.107     1.394     0.200
     0.126     1.323     0.200
     0.146     1.766     0.200
     0.153     1.702     0.200
     0.300     2.020     0.200
     0.313     2.860     0.200
     0.324     2.341     0.200
     0.515     3.395     0.200
     0.540     3.430     0.200
     0.621     4.149     0.200
     0.160     1.128     0.200
     0.290     2.039     0.200
     0.297     2.093     0.200
     0.301     2.784     0.200
     0.316     2.480     0.200
     0.352     2.733     0.200
     0.424     3.209     0.200
     0.460     3.457     0.200
     0.618     4.576     0.200
     0.697     5.124     0.200
     0.719     5.333     0.200
     0.737     5.899     0.200
     1.053     7.237     0.200
     0.088     1.416     0.200
     0.177     1.910     0.200
     0.223     2.212     0.200
     0.230     1.952     0.200
     0.295     2.812     0.200
     0.335     2.947     0.200
     0.368     3.240     0.200
     0.368     2.697     0.200
     0.489     3.720     0.200
     0.585     4.415     0.200
     0.594     4.552     0.200
     0.030     2.100     0.200
     0.096     2.095     0.200
     0.151     2.294     0.200
     0.195     2.197     0.200
     0.250     2.563     0.200
     0.248     2.696     0.200
     0.328     2.725     0.200
     0.478     4.159     0.200
     0.507     3.921     0.200
     0.516     3.997     0.200
     0.065     1.391     0.200
     0.201     1.903     0.200
     0.261     2.436     0.200
     0.277     2.347     0.200
     0.278     2.583     0.200
     0.279     2.424     0.200
     0.331     2.518     0.200
     0.375     3.328     0.200
     0.389     3.389     0.200
     0.502     3.576     0.200
     0.553     4.129     0.200
     0.596     4.824     0.200
     0.618     4.443     0.200
     0.630     4.789     0.200
     0.702     5.340     0.200
     0.707     4.872     0.200
     0.732     4.994     0.200
     0.703     5.290     0.200
     0.767     5.823     0.200
     0.778     5.105     0.200
     0.825     5.764     0.200
     0.827     5.673     0.200
     0.827     6.763     0.200
     0.855     6.437     0.200
     0.996     7.495     0.200
     1.003     6.679     0.200
     1.576    11.643     0.200
     1.613    11.717     0.200
     1.642    11.924     0.200
     1.974    13.593     0.200
     0.054     1.348     0.200
     0.206     1.905     0.200
     0.271     2.463     0.200
     0.266     2.549     0.200
     0.267     2.406     0.200
     0.282     2.365     0.200
     0.322     2.610     0.200
     0.364     3.231     0.200
     0.377     3.254     0.200
     0.541     4.096     0.200
     0.588     4.665     0.200
     0.620     5.154     0.200
     0.631     4.710     0.200
     0.693     5.443     0.200
     0.717     4.977     0.200
     0.779     6.166     0.200
     0.835     6.139     0.200
     0.839     6.016     0.200
     0.973     6.789     0.200
     0.059     1.437     0.200
     0.203     1.898     0.200
     0.266     2.436     0.200
     0.279     2.359     0.200
     0.272     2.503     0.200
     0.273     2.636     0.200
     0.327     2.488     0.200
     0.369     3.241     0.200
     0.383     2.693     0.200
     0.547     4.310     0.200
     0.592     4.703     0.200
     0.624     4.724     0.200
     0.624     4.569     0.200
     0.625     5.120     0.200
     0.698     5.680     0.200
     0.773     6.040     0.200
     1.858    12.754     0.200
     0.045     1.402     0.200
     0.200     1.859     0.200
     0.259     2.694     0.200
     0.265     2.413     0.200
     0.270     2.422     0.200
     0.276     2.311     0.200
     0.326     2.464     0.200
     0.355     3.195     0.200
     0.372     3.459     0.200
     0.513     3.853     0.200
     0.533     4.185     0.200
     0.578     4.415     0.200
     0.683     5.130     0.200
     0.067     1.586     0.200
     0.133     1.560     0.200
     0.191     2.097     0.200
     0.205     1.650     0.200
     0.205     2.074     0.200
     0.317     2.860     0.200
     0.409     3.106     0.200
     0.423     3.007     0.200
     0.483     3.923     0.200
     0.498     3.794     0.200
     0.563     4.293     0.200
     0.586     4.875     0.200
     1.055     7.643     0.200
     0.060     1.229     0.200
     0.202     1.667     0.200
     0.265     2.287     0.200
     0.278     2.089     0.200
     0.273     2.463     0.200
     0.274     2.378     0.200
     0.328     2.517     0.200
     0.369     3.056     0.200
     0.384     2.837     0.200
     0.592     4.450     0.200
     0.623     4.520     0.200
     0.772     6.222     0.200
     0.051     1.263     0.200
     0.204     1.835     0.200
     0.264     2.421     0.200
     0.271     2.421     0.200
     0.266     2.224     0.200
     0.280     2.303     0.200
     0.323     2.535     0.200
     0.361     3.217     0.200
     0.375     3.091     0.200
     0.513     3.561     0.200
     0.538     4.167     0.200
     0.584     4.703     0.200
     0.616     5.001     0.200
     0.632     4.804     0.200
     0.717     4.742     0.200
     0.781     5.737     0.200
     0.785     5.184     0.200
     0.820     5.949     0.200
     0.841     6.244     0.200
     1.591    11.179     0.200
     1.866    12.911     0.200
     0.039     1.442     0.200
     0.187     1.802     0.200
     0.252     2.248     0.200
     0.263     2.210     0.200
     0.264     2.266     0.200
     0.268     2.323     0.200
     0.346     2.889     0.200
     0.336     2.573     0.200
     0.372     3.204     0.200
     0.527     4.258     0.200
     0.565     3.831     0.200
     0.051     1.426     0.200
     0.206     1.993     0.200
     0.264     2.495     0.200
     0.273     2.548     0.200
     0.264     2.485     0.200
     0.282     2.500     0.200
     0.321     2.527     0.200
     0.361     3.294     0.200
     0.374     3.184     0.200
     0.515     3.729     0.200
     0.538     4.229     0.200
     0.586     4.869     0.200
     0.617     4.954     0.200
     0.633     4.651     0.200
     0.633     4.794     0.200
     0.690     5.424     0.200
     0.719     4.983     0.200
     0.787     4.886     0.200
     0.782     5.921     0.200
     1.011     7.236     0.200
     0.072     1.899     0.200
     0.103     1.823     0.200
     0.182     2.291     0.200
     0.230     2.398     0.200
     0.245     2.232     0.200
     0.338     2.921     0.200
     0.425     3.191     0.200
     0.449     3.459     0.200
     0.523     4.326     0.200
     0.575     4.369     0.200
     0.607     5.130     0.200
     0.607     4.829     0.200
     0.043     1.269     0.200
     0.209     1.799     0.200
     0.255     2.340     0.200
     0.256     2.257     0.200
     0.280     2.393     0.200
     0.286     2.282     0.200
     0.316     2.380     0.200
     0.353     3.154     0.200
     0.365     3.063     0.200
     0.522     3.772     0.200
     0.529     4.012     0.200
     0.579     4.459     0.200
     0.609     4.701     0.200
     0.642     4.641     0.200
     0.642     4.461     0.200
     0.682     5.217     0.200
     0.696     5.491     0.200
     0.726     4.906     0.200
     0.791     5.681     0.200
     0.792     5.367     0.200
     0.819     6.085     0.200
     0.843     6.402     0.200
     0.851     6.369     0.200
     1.022     7.547     0.200
     1.021     7.472     0.200
     1.636    11.475     0.200
     1.667    11.684     0.200
     1.876    13.096     0.200
     1.998    13.314     0.200
     0.045     1.898     0.200
     0.198     2.672     0.200
     0.259     2.417     0.200
     0.265     2.548     0.200
     0.275     2.450     0.200
     0.327     2.879     0.200
     0.355     3.037     0.200
     0.373     3.083     0.200
     0.633     4.545     0.200
     0.683     5.328     0.200
     0.784     5.951     0.200
     0.842     6.226     0.200
     0.259     2.837     0.200
     0.327     3.179     0.200
     0.355     3.537     0.200
     0.355     3.797     0.200
     0.373     3.283     0.200
     0.533     4.553     0.200
     0.577     5.150     0.200
     0.055     2.666     0.200
     0.218     2.619     0.200
     0.274     2.853     0.200
     0.278     3.054     0.200
     0.385     3.499     0.200
     0.466     4.186     0.200
     0.557     4.338     0.200
     0.620     5.094     0.200
     0.654     5.184     0.200
     0.063     1.314     0.200
     0.195     2.017     0.200
     0.271     2.410     0.200
     0.276     2.431     0.200
     0.372     3.054     0.200
     0.390     3.089     0.200
     0.459     3.122     0.200
     0.447     3.508     0.200
     0.498     3.758     0.200
     0.595     4.325     0.200
     0.617     4.913     0.200
     0.618     4.703     0.200
     0.626     4.668     0.200
     0.695     5.338     0.200
     0.767     5.622     0.200
     0.825     6.062     0.200
     1.850    12.376     0.200
     0.049     1.263     0.200
     0.199     1.888     0.200
     0.268     2.482     0.200
     0.262     2.453     0.200
     0.275     2.606     0.200
     0.359     3.065     0.200
     0.376     2.793     0.200
     0.451     3.387     0.200
     0.473     3.370     0.200
     0.510     3.712     0.200
     0.608     4.423     0.200
     0.614     4.820     0.200
     0.631     4.680     0.200
     0.632     4.817     0.200
     0.781     5.790     0.200
     0.781     5.642     0.200
     0.840     6.203     0.200
     1.864    12.497     0.200
     0.530     3.466     0.200
     0.628     4.723     0.200
     2.079    15.400     0.200
     0.083     1.297     0.200
     0.180     1.626     0.200
     0.231     2.019     0.200
     0.257     2.126     0.200
     0.310     2.457     0.200
     0.292     2.480     0.200
     0.361     3.018     0.200
     0.539     3.576     0.200
     0.585     4.280     0.200
     0.605     4.300     0.200
     0.568     4.164     0.200
     0.629     5.351     0.200
     0.750     5.362     0.200
     0.895     6.659     0.200
     0.912     6.480     0.200
     0.900     6.679     0.200
     1.061     7.884     0.200
     1.224     8.696     0.200
     1.892    12.973     0.200
     0.901     6.140     0.200
     0.838     6.038     0.200
     2.437    14.183     0.200
     0.089     1.777     0.200
     0.089     1.880     0.200
     0.161     1.776     0.200
     0.236     2.267     0.200
     0.256     2.112     0.200
     0.295     2.490     0.200
     0.321     2.526     0.200
     0.367     2.855     0.200
     0.511     3.916     0.200
     0.514     3.918     0.200
     0.665     5.011     0.200
     0.785     5.693     0.200
     0.802     5.845     0.200
     0.881     6.783     0.200
     1.181     8.306     0.200
     0.111     1.613     0.200
     0.262     1.988     0.200
     0.263     2.295     0.200
     0.284     2.464     0.200
     0.304     2.664     0.200
     0.562     4.194     0.200
     0.608     4.418     0.200
     0.658     4.720     0.200
     0.646     5.167     0.200
     0.671     4.854     0.200
     0.808     5.463     0.200
     0.818     5.767     0.200
     0.961     6.804     0.200
     0.981     7.270     0.200
     1.146     8.265     0.200
     0.023     2.536     0.200
     0.138     2.037     0.200
     0.191     2.181     0.200
     0.231     2.288     0.200
     0.308     2.824     0.200
     0.318     2.679     0.200
     0.484     3.753     0.200
     0.489     4.004     0.200
     0.585     4.075     0.200
     0.732     5.325     0.200
     0.795     5.685     0.200
     1.161     8.114     0.200
     0.211     1.789     0.200
     0.297     2.568     0.200
     0.410     3.051     0.200
     0.412     3.178     0.200
     0.447     3.412     0.200
     0.468     3.562     0.200
     0.486     3.506     0.200
     0.616     4.398     0.200
     0.654     4.652     0.200
     0.663     4.842     0.200
     0.701     5.079     0.200
     0.786     5.348     0.200
     0.992     7.424     0.200
     1.575    11.194     0.200
     1.608    11.434     0.200
     0.632     5.404     0.200
     0.672     5.428     0.200
     2.157    13.816     0.200
     0.061     1.284     0.200
     0.206     1.947     0.200
     0.268     2.587     0.200
     0.273     2.313     0.200
     0.282     2.406     0.200
     0.371     3.234     0.200
     0.382     3.076     0.200
     0.466     3.132     0.200
     0.452     3.444     0.200
     0.458     3.585     0.200
     0.597     4.389     0.200
     0.624     4.772     0.200
     0.625     4.547     0.200
     0.833     6.037     0.200
     1.047     7.313     0.200
     1.107     8.020     0.200
     1.149     8.224     0.200
     1.859    13.075     0.200
     0.048     1.657     0.200
     0.199     2.093     0.200
     0.262     2.706     0.200
     0.269     2.682     0.200
     0.276     2.553     0.200
     0.358     3.423     0.200
     0.375     3.143     0.200
     0.440     3.587     0.200
     0.452     3.397     0.200
     0.474     2.996     0.200
     0.511     3.708     0.200
     0.609     4.397     0.200
     0.631     4.749     0.200
     0.633     4.498     0.200
     0.686     5.343     0.200
     0.691     5.485     0.200
     0.781     5.907     0.200
     0.782     5.772     0.200
     0.815     6.206     0.200
     0.840     6.349     0.200
     1.865    12.996     0.200
     0.202     1.669     0.200
     0.262     2.596     0.200
     0.278     2.353     0.200
     0.279     2.279     0.200
     0.330     2.596     0.200
     0.375     2.924     0.200
     0.389     3.156     0.200
     0.459     2.966     0.200
     0.452     3.768     0.200
     0.454     3.264     0.200
     0.502     3.201     0.200
     0.617     4.639     0.200
     0.618     4.636     0.200
     0.631     4.452     0.200
     0.703     5.426     0.200
     0.766     5.555     0.200
     0.780     5.847     0.200
     0.827     5.805     0.200
     1.852    12.914     0.200
     0.546     3.720     0.200
     2.063    15.701     0.200
     0.199     2.005     0.200
     0.262     2.322     0.200
     0.274     2.405     0.200
     0.275     2.484     0.200
     0.370     3.479     0.200
     0.386     3.175     0.200
     0.446     3.268     0.200
     0.463     3.258     0.200
     0.451     3.565     0.200
     0.625     4.618     0.200
     0.621     4.669     0.200
     0.621     4.579     0.200
     0.698     5.426     0.200
     0.778     5.830     0.200
     0.213     1.816     0.200
     0.277     2.509     0.200
     0.289     2.487     0.200
     0.375     3.248     0.200
     0.383     3.411     0.200
     0.466     3.579     0.200
     0.460     3.217     0.200
     0.512     3.580     0.200
     0.592     4.519     0.200
     0.602     4.427     0.200
     0.622     4.689     0.200
     0.625     4.630     0.200
     0.632     4.568     0.200
     0.705     5.385     0.200
     0.771     5.767     0.200
     0.790     5.957     0.200
     0.833     5.992     0.200
     0.836     6.717     0.200
     0.052     1.834     0.200
     0.128     1.943     0.200
     0.168     1.982     0.200
     0.202     2.019     0.200
     0.239     1.959     0.200
     0.302     2.170     0.200
     0.326     2.581     0.200
     0.406     3.269     0.200
     0.554     4.424     0.200
     0.551     3.842     0.200
     0.631     4.502     0.200
     0.690     5.852     0.200
     0.697     5.383     0.200
     0.797     6.206     0.200
     0.839     5.676     0.200
     0.919     7.047     0.200
     0.271     2.511     0.200
     0.266     2.382     0.200
     0.267     2.214     0.200
     0.281     2.326     0.200
     0.323     2.491     0.200
     0.363     3.074     0.200
     0.376     3.045     0.200
     0.447     3.461     0.200
     0.472     3.357     0.200
     0.457     3.343     0.200
     0.458     3.518     0.200
     0.512     3.263     0.200
     0.540     4.093     0.200
     0.587     4.383     0.200
     0.603     4.538     0.200
     0.604     4.693     0.200
     0.599     4.213     0.200
     0.619     4.666     0.200
     0.631     4.508     0.200
     0.692     5.238     0.200
     0.698     4.959     0.200
     0.717     4.930     0.200
     0.779     6.044     0.200
     0.785     6.178     0.200
     0.834     5.939     0.200
     0.839     6.051     0.200
     1.009     7.437     0.200
     1.013     6.868     0.200
     1.049     7.641     0.200
     1.111     7.916     0.200
     1.154     8.400     0.200
     1.625    11.328     0.200
     1.834    12.381     0.200
     0.533     3.440     0.200
     0.631     4.639     0.200
     2.076    15.705     0.200
     2.595    15.858     0.200
     0.036     2.355     0.200
     0.127     2.016     0.200
     0.202     2.172     0.200
     0.230     2.429     0.200
     0.253     2.533     0.200
     0.299     2.701     0.200
     0.304     2.447     0.200
     0.375     3.453     0.200
     0.447     2.755     0.200
     0.496     3.826     0.200
     0.502     3.934     0.200
     0.516     3.976     0.200
     0.720     5.159     0.200
     0.723     5.189     0.200
     0.743     5.514     0.200
     0.802     5.464     0.200
     0.061     0.241     0.200
     0.142     0.848     0.200
     0.369     2.452     0.200
     0.374     2.735     0.200
     0.395     2.832     0.200
     0.420     2.324     0.200
     0.533     3.998     0.200
     0.562     4.223     0.200
     0.572     3.710     0.200
     0.802     6.211     0.200
     0.972     7.045     0.200
     0.063     2.147     0.200
     0.091     1.930     0.200
     0.177     2.030     0.200
     0.186     2.012     0.200
     0.252     2.755     0.200
     0.292     2.580     0.200
     0.323     2.829     0.200
     0.309     2.659     0.200
     0.393     2.633     0.200
     0.448     3.331     0.200
     0.488     4.008     0.200
     0.506     3.779     0.200
     0.527     4.084     0.200
     0.587     4.466     0.200
     0.613     4.420     0.200
     0.620     4.438     0.200
     0.669     4.736     0.200
     0.675     4.789     0.200
     0.682     5.240     0.200
     0.690     4.829     0.200
     0.713     5.273     0.200
     0.736     5.380     0.200
     0.055     2.012     0.200
     0.099     1.654     0.200
     0.180     1.824     0.200
     0.180     1.882     0.200
     0.260     2.436     0.200
     0.284     2.492     0.200
     0.316     2.403     0.200
     0.330     2.490     0.200
     0.398     2.233     0.200
     0.449     3.164     0.200
     0.484     3.732     0.200
     0.498     3.783     0.200
     0.508     3.780     0.200
     0.535     3.802     0.200
     0.587     4.050     0.200
     0.608     4.385     0.200
     0.623     4.162     0.200
     0.676     4.362     0.200
     0.680     4.602     0.200
     0.683     4.729     0.200
     0.684     4.916     0.200
     0.695     4.851     0.200
     0.715     5.039     0.200
     0.727     5.386     0.200
     0.762     5.531     0.200
     0.775     5.795     0.200
     0.852     6.138     0.200
     0.865     6.382     0.200
     0.929     7.247     0.200
     0.944     7.252     0.200
     0.983     7.227     0.200
     0.315     2.491     0.200
     1.891    13.368     0.200
     0.060     2.033     0.200
     0.092     1.838     0.200
     0.180     1.883     0.200
     0.187     1.836     0.200
     0.255     2.469     0.200
     0.290     2.433     0.200
     0.308     2.644     0.200
     0.397     2.466     0.200
     0.451     3.210     0.200
     0.490     3.941     0.200
     0.506     3.467     0.200
     0.590     4.351     0.200
     0.615     4.323     0.200
     0.623     4.494     0.200
     0.672     4.707     0.200
     0.678     4.852     0.200
     0.685     5.096     0.200
     0.692     5.565     0.200
     0.717     5.190     0.200
     0.767     5.527     0.200
     0.976     7.459     0.200
     1.122     7.999     0.200
     0.090     0.953     0.200
     0.105     0.872     0.200
     0.216     1.849     0.200
     0.260     2.522     0.200
     0.293     2.185     0.200
     0.348     2.745     0.200
     0.335     2.432     0.200
     0.369     2.455     0.200
     0.362     2.479     0.200
     0.375     2.986     0.200
     0.383     2.404     0.200
     0.498     3.659     0.200
     0.516     3.758     0.200
     0.554     3.879     0.200
     0.561     3.312     0.200
     0.613     3.899     0.200
     0.834     6.435     0.200
     0.882     5.762     0.200
     0.931     6.626     0.200
     1.361     9.305     0.200
     0.090     2.757     0.200
     0.170     2.639     0.200
     0.188     2.662     0.200
     0.262     2.932     0.200
     0.310     2.928     0.200
     0.323     3.287     0.200
     0.330     3.201     0.200
     0.323     3.354     0.200
     0.385     3.986     0.200
     0.442     3.148     0.200
     0.409     3.815     0.200
     0.434     4.187     0.200
     0.534     4.273     0.200
     0.610     4.634     0.200
     0.582     4.629     0.200
     0.639     4.642     0.200
     0.674     5.109     0.200
     0.734     6.094     0.200
     0.767     5.788     0.200
     0.792     5.402     0.200
     0.810     5.841     0.200
     0.834     5.885     0.200
     0.897     6.352     0.200
     1.004     7.116     0.200
     1.518    10.547     0.200
     1.574    10.673     0.200
     1.727    11.043     0.200
     1.739    11.111     0.200
     1.789    11.443     0.200
     1.907    11.945     0.200
     1.930    11.654     0.200
     1.958    11.951     0.200
     0.119     0.638     0.200
     0.228     1.388     0.200
     0.210     1.983     0.200
     0.247     1.736     0.200
     0.272     1.668     0.200
     0.389     2.529     0.200
     0.384     2.623     0.200
     0.476     3.151     0.200
     0.527     3.772     0.200
     0.545     4.027     0.200
     0.551     3.605     0.200
     0.661     4.493     0.200
     0.703     4.951     0.200
     0.719     4.770     0.200
     0.846     5.777     0.200
     0.828     6.335     0.200
     0.971     6.839     0.200
     1.589    11.460     0.200
     0.207     1.808     0.200
     0.268     2.406     0.200
     0.283     2.232     0.200
     0.272     2.332     0.200
     0.274     2.454     0.200
     0.324     2.516     0.200
     0.371     3.136     0.200
     0.383     3.151     0.200
     0.466     3.253     0.200
     0.452     3.399     0.200
     0.453     3.310     0.200
     0.459     3.337     0.200
     0.509     3.705     0.200
     0.548     4.181     0.200
     0.596     4.201     0.200
     0.602     4.459     0.200
     0.595     4.628     0.200
     0.623     4.453     0.200
     0.625     4.350     0.200
     0.627     4.658     0.200
     0.704     4.939     0.200
     0.700     5.206     0.200
     0.714     4.858     0.200
     0.735     5.005     0.200
     0.772     5.540     0.200
     0.785     5.956     0.200
     0.832     6.051     0.200
     0.833     5.903     0.200
     0.829     5.907     0.200
     0.969     7.012     0.200
     1.002     7.058     0.200
     1.010     7.169     0.200
     1.582    11.572     0.200
     1.620    11.605     0.200
     1.649    11.689     0.200
     1.829    12.385     0.200
     1.859    12.862     0.200
     1.980    13.372     0.200
     0.541     3.684     0.200
     0.639     4.757     0.200
     0.615     4.472     0.200
     2.068    15.614     0.200
     2.589    15.513     0.200
     0.061     0.790     0.200
     0.174     1.885     0.200
     0.196     1.390     0.200
     0.241     2.316     0.200
     0.320     2.358     0.200
     0.429     2.685     0.200
     0.480     3.293     0.200
     0.490     3.524     0.200
     0.487     3.351     0.200
     0.512     3.559     0.200
     0.716     5.000     0.200
     0.757     4.672     0.200
     1.037     7.298     0.200
     1.105     7.601     0.200
     1.153     8.162     0.200
     1.182     8.434     0.200
     1.573    10.680     0.200
     1.673    12.058     0.200
     1.772    12.459     0.200
     1.776    12.162     0.200
     1.835    12.585     0.200
     0.050     0.398     0.200
     0.129     1.006     0.200
     0.247     2.240     0.200
     0.277     2.043     0.200
     0.294     2.339     0.200
     0.354     2.759     0.200
     0.374     2.338     0.200
     0.394     2.275     0.200
     0.458     3.470     0.200
     0.592     3.751     0.200
     0.805     5.598     0.200
     0.835     5.788     0.200
     0.908     5.984     0.200
     0.959     6.286     0.200
     0.099     2.105     0.200
     0.236     2.273     0.200
     0.241     2.220     0.200
     0.236     2.287     0.200
     0.334     2.838     0.200
     0.389     2.732     0.200
     0.376     2.982     0.200
     0.370     3.124     0.200
     0.378     3.074     0.200
     0.445     3.239     0.200
     0.451     3.627     0.200
     0.513     3.702     0.200
     0.528     3.773     0.200
     0.594     4.512     0.200
     0.598     4.328     0.200
     0.582     4.946     0.200
     0.740     4.986     0.200
     0.715     5.663     0.200
     0.755     5.606     0.200
     0.743     5.800     0.200
     0.756     6.429     0.200
     0.795     5.332     0.200
     0.784     6.378     0.200
     0.825     6.032     0.200
     0.953     6.355     0.200
     0.951     6.409     0.200
     0.996     6.816     0.200
     1.086     7.714     0.200
     1.120     7.620     0.200
     1.475    10.194     0.200
     1.533    10.512     0.200
     1.591    10.686     0.200
     1.604    10.438     0.200
     1.646    11.099     0.200
     1.730    11.774     0.200
     1.744    12.070     0.200
     1.805    11.882     0.200
     0.135     1.416     0.200
     0.212     1.846     0.200
     0.220     2.185     0.200
     0.296     2.470     0.200
     0.320     2.833     0.200
     0.354     2.130     0.200
     0.372     2.636     0.200
     0.427     3.697     0.200
     0.547     3.542     0.200
     0.594     4.150     0.200
     0.636     4.197     0.200
     0.612     4.780     0.200
     0.863     5.939     0.200
     0.912     6.229     0.200
     0.943     6.412     0.200
     1.690    11.769     0.200
     1.902    12.630     0.200
     0.081     1.901     0.200
     0.184     1.722     0.200
     0.231     2.097     0.200
     0.251     2.381     0.200
     0.262     2.294     0.200
     0.361     2.776     0.200
     0.406     3.514     0.200
     0.491     3.820     0.200
     0.552     4.212     0.200
     0.591     4.918     0.200
     0.634     4.990     0.200
     0.641     5.194     0.200
     0.657     4.728     0.200
     0.926     5.940     0.200
     0.943     6.560     0.200
     0.944     6.513     0.200
     0.987     6.735     0.200
     1.112     7.950     0.200
     1.129     7.089     0.200
     1.316     8.826     0.200
     1.634    10.926     0.200
     1.653    11.379     0.200
     1.665    11.084     0.200
     1.675    10.901     0.200
     1.731    11.737     0.200
     1.791    12.212     0.200
     1.838    12.056     0.200
     1.929    12.549     0.200
     1.939    12.948     0.200
     0.099     1.892     0.200
     0.175     2.170     0.200
     0.246     2.552     0.200
     0.241     2.332     0.200
     0.309     2.208     0.200
     0.307     3.021     0.200
     0.349     3.142     0.200
     0.378     2.973     0.200
     0.373     3.189     0.200
     0.592     4.392     0.200
     0.587     4.124     0.200
     0.604     4.026     0.200
     0.584     4.779     0.200
     0.639     4.994     0.200
     0.646     5.926     0.200
     0.740     4.724     0.200
     0.873     5.908     0.200
     0.896     5.929     0.200
     1.138     8.083     0.200
     1.621    10.833     0.200
     1.675    11.373     0.200
     1.736    11.335     0.200
     1.781    12.551     0.200
     1.883    12.719     0.200
     1.942    12.711     0.200
     0.040     2.595     0.200
     0.223     2.904     0.200
     0.297     2.745     0.200
     0.306     3.422     0.200
     0.397     3.322     0.200
     0.435     3.613     0.200
     0.505     3.682     0.200
     0.502     3.775     0.200
     0.486     4.530     0.200
     0.630     4.058     0.200
     0.598     4.780     0.200
     0.611     5.117     0.200
     0.753     5.512     0.200
     0.787     5.615     0.200
     0.837     5.839     0.200
     0.896     6.492     0.200
     0.900     5.865     0.200
     1.630    10.999     0.200
     1.646    10.418     0.200
     1.712    10.560     0.200
     1.763    11.386     0.200
     1.774    11.260     0.200
     1.818    11.659     0.200
     1.825    11.840     0.200
     0.112     2.174     0.200
     0.144     2.012     0.200
     0.177     2.691     0.200
     0.238     2.308     0.200
     0.254     2.334     0.200
     0.255     2.618     0.200
     0.367     2.849     0.200
     0.401     3.331     0.200
     0.478     3.696     0.200
     0.508     3.523     0.200
     0.539     4.259     0.200
     0.552     4.029     0.200
     0.606     4.251     0.200
     0.621     4.653     0.200
     0.636     4.656     0.200
     0.661     4.524     0.200
     0.743     5.380     0.200
     0.772     5.429     0.200
     0.792     6.061     0.200
     0.787     5.287     0.200
     0.805     5.946     0.200
     0.865     6.210     0.200
     1.029     7.285     0.200
     1.484    10.362     0.200
     0.196     1.437     0.200
     0.261     2.178     0.200
     0.272     2.227     0.200
     0.271     2.468     0.200
     0.276     2.308     0.200
     0.332     2.488     0.200
     0.366     3.017     0.200
     0.384     3.197     0.200
     0.442     3.358     0.200
     0.448     3.237     0.200
     0.465     3.295     0.200
     0.449     3.448     0.200
     0.503     3.647     0.200
     0.545     4.187     0.200
     0.593     4.384     0.200
     0.587     4.660     0.200
     0.601     4.424     0.200
     0.622     4.502     0.200
     0.624     4.547     0.200
     0.621     4.597     0.200
     0.693     5.056     0.200
     0.694     5.155     0.200
     0.707     5.120     0.200
     0.773     5.591     0.200
     0.818     6.179     0.200
     0.824     5.951     0.200
     0.964     6.752     0.200
     1.003     7.457     0.200
     1.002     7.381     0.200
     1.039     7.871     0.200
     1.102     7.869     0.200
     1.146     8.287     0.200
     1.616    11.799     0.200
     1.825    12.313     0.200
     1.856    12.599     0.200
     1.979    13.173     0.200
     0.142     1.854     0.200
     0.127     1.950     0.200
     0.281     2.214     0.200
     0.255     2.527     0.200
     0.276     2.500     0.200
     0.346     2.576     0.200
     0.360     3.113     0.200
     0.339     3.141     0.200
     0.358     2.969     0.200
     0.405     3.350     0.200
     0.506     3.717     0.200
     0.557     3.918     0.200
     0.563     3.941     0.200
     0.574     3.916     0.200
     0.602     4.815     0.200
     0.611     4.934     0.200
     0.665     5.383     0.200
     0.704     4.893     0.200
     0.706     5.373     0.200
     0.672     5.363     0.200
     0.790     5.628     0.200
     0.797     5.493     0.200
     0.841     5.848     0.200
     0.865     6.068     0.200
     0.853     6.667     0.200
     0.870     6.009     0.200
     0.886     6.110     0.200
     0.895     6.064     0.200
     1.039     7.339     0.200
     1.103     8.016     0.200
     1.574    10.945     0.200
     1.587    10.976     0.200
     1.586    11.136     0.200
     1.639    11.310     0.200
     1.690    11.564     0.200
     1.701    11.604     0.200
     1.746    11.979     0.200
     1.837    12.096     0.200
     1.847    11.737     0.200
     1.907    12.101     0.200
     0.855     5.773     0.200
     0.870     6.330     0.200
     1.827    11.717     0.200
     1.911    11.475     0.200
     2.483    13.826     0.200
     0.118     1.471     0.200
     0.217     2.027     0.200
     0.327     2.573     0.200
     0.347     2.403     0.200
     0.346     2.938     0.200
     0.364     2.804     0.200
     0.698     4.790     0.200
     0.783     5.603     0.200
     1.046     7.337     0.200
     1.059     7.102     0.200
     1.653    11.212     0.200
     0.170     2.065     0.200
     0.199     2.021     0.200
     0.223     2.325     0.200
     0.299     2.834     0.200
     0.351     2.488     0.200
     0.364     2.477     0.200
     0.461     3.365     0.200
     0.553     3.847     0.200
     0.579     4.563     0.200
     0.612     4.692     0.200
     0.638     4.606     0.200
     0.655     4.730     0.200
     0.770     5.478     0.200
     0.770     5.692     0.200
     0.779     5.178     0.200
     0.770     5.690     0.200
     0.788     5.517     0.200
     0.788     5.483     0.200
     0.803     6.338     0.200
     0.837     5.596     0.200
     0.860     6.310     0.200
     0.853     6.329     0.200
     0.870     6.144     0.200
     0.943     6.749     0.200
     0.959     6.750     0.200
     0.981     6.914     0.200
     0.996     7.483     0.200
     1.011     7.105     0.200
     1.041     7.325     0.200
     1.050     7.663     0.200
     1.134     7.872     0.200
     1.248     8.559     0.200
     0.351     2.652     0.200
     0.364     2.867     0.200
     0.461     3.201     0.200
     0.579     4.711     0.200
     0.655     4.831     0.200
     0.770     5.611     0.200
     0.779     5.326     0.200
     0.837     5.955     0.200
     0.870     6.777     0.200
     0.959     7.070     0.200
     0.981     7.062     0.200
     1.011     7.519     0.200
     1.041     7.754     0.200
     1.050     7.795     0.200
     1.248     8.450     0.200
     0.212     2.365     0.200
     0.763     5.645     0.200
     1.308     8.162     0.200
     0.135     1.716     0.200
     0.134     2.074     0.200
     0.213     2.145     0.200
     0.289     2.303     0.200
     0.302     2.077     0.200
     0.312     2.544     0.200
     0.398     2.758     0.200
     0.489     3.292     0.200
     0.578     3.706     0.200
     0.579     4.418     0.200
     0.596     4.456     0.200
     0.613     4.522     0.200
     0.713     5.204     0.200
     0.720     5.009     0.200
     0.725     4.794     0.200
     0.727     4.912     0.200
     0.733     5.441     0.200
     0.773     5.584     0.200
     0.787     5.809     0.200
     0.782     5.682     0.200
     0.810     5.518     0.200
     0.853     6.384     0.200
     0.892     6.575     0.200
     0.925     6.857     0.200
     0.969     7.086     0.200
     0.968     7.262     0.200
     0.991     7.181     0.200
     0.996     7.369     0.200
     1.078     7.809     0.200
     1.090     7.939     0.200
     1.184     8.141     0.200
     0.331     2.749     0.200
     0.320     2.847     0.200
     0.341     2.885     0.200
     0.358     2.699     0.200
     0.417     2.797     0.200
     0.409     3.212     0.200
     0.419     3.504     0.200
     0.459     3.688     0.200
     0.482     3.708     0.200
     0.527     4.118     0.200
     0.535     3.847     0.200
     0.575     4.170     0.200
     0.616     4.745     0.200
     0.686     5.152     0.200
     0.687     4.841     0.200
     0.692     5.358     0.200
     0.763     5.888     0.200
     0.787     5.819     0.200
     0.860     6.375     0.200
     0.868     6.217     0.200
     0.894     6.119     0.200
     0.868     6.289     0.200
     0.880     6.338     0.200
     0.917     6.678     0.200
     1.101     7.930     0.200
     1.595    10.716     0.200
     1.816    12.028     0.200
     0.093     1.661     0.200
     0.230     2.376     0.200
     0.252     2.570     0.200
     0.293     2.506     0.200
     0.306     3.033     0.200
     0.353     2.912     0.200
     0.379     2.951     0.200
     0.479     3.806     0.200
     0.588     4.298     0.200
     0.590     4.470     0.200
     0.578     4.524     0.200
     1.205     8.261     0.200
     0.108     1.770     0.200
     0.133     1.487     0.200
     0.229     2.149     0.200
     0.232     2.148     0.200
     0.343     2.920     0.200
     0.391     2.966     0.200
     0.466     3.577     0.200
     0.470     3.520     0.200
     0.460     4.027     0.200
     0.568     4.454     0.200
     0.594     4.484     0.200
     0.610     4.764     0.200
     0.641     4.490     0.200
     0.667     5.133     0.200
     0.711     5.156     0.200
     0.813     5.976     0.200
     0.939     7.025     0.200
     0.979     7.318     0.200
     1.033     7.391     0.200
     2.048    13.204     0.200
     0.111     1.625     0.200
     0.135     2.061     0.200
     0.279     2.668     0.200
     0.317     2.575     0.200
     0.398     3.088     0.200
     0.480     3.590     0.200
     0.521     3.796     0.200
     0.664     4.793     0.200
     0.733     4.973     0.200
     0.745     5.485     0.200
     0.783     5.515     0.200
     1.153     8.219     0.200
     1.829    12.446     0.200
     2.283    14.461     0.200
     0.021     1.771     0.200
     0.173     1.908     0.200
     0.172     1.793     0.200
     0.271     2.569     0.200
     0.349     2.874     0.200
     0.447     3.352     0.200
     0.501     4.115     0.200
     0.517     4.192     0.200
     0.539     4.790     0.200
     0.552     4.192     0.200
     0.572     4.611     0.200
     1.595    11.290     0.200
     0.219     2.048     0.200
     0.228     1.821     0.200
     0.281     2.260     0.200
     0.309     2.302     0.200
     0.342     3.093     0.200
     0.361     2.674     0.200
     0.385     3.010     0.200
     0.393     3.123     0.200
     0.524     3.518     0.200
     0.538     3.779     0.200
     0.561     3.969     0.200
     0.642     4.821     0.200
     0.653     4.946     0.200
     0.691     4.857     0.200
     0.703     5.061     0.200
     0.726     5.714     0.200
     0.886     6.442     0.200
     0.927     6.512     0.200
     1.052     7.734     0.200
     1.105     8.081     0.200
     1.144     8.410     0.200
     1.192     8.546     0.200
     1.216     8.676     0.200
     1.926    13.178     0.200
     0.153     2.316     0.200
     0.156     2.530     0.200
     0.177     2.422     0.200
     0.204     2.440     0.200
     0.422     3.593     0.200
     0.452     3.961     0.200
     0.449     3.895     0.200
     0.469     3.281     0.200
     0.475     4.030     0.200
     0.546     3.731     0.200
     0.601     4.981     0.200
     0.606     4.677     0.200
     0.613     5.171     0.200
     0.662     4.889     0.200
     0.688     5.871     0.200
     0.688     5.548     0.200
     0.731     5.654     0.200
     0.792     6.144     0.200
     0.874     6.133     0.200
     0.864     6.382     0.200
     0.874     6.190     0.200
     1.169     7.804     0.200
     0.071     1.085     0.200
     0.144     0.869     0.200
     0.141     1.707     0.200
     0.449     3.473     0.200
     0.481     3.743     0.200
     0.466     3.703     0.200
     0.451     3.603     0.200
     0.569     3.934     0.200
     0.691     5.286     0.200
     0.735     4.926     0.200
     1.263     8.982     0.200
     1.765    12.064     0.200
     1.811    12.892     0.200
     1.980    13.453     0.200
     2.075    13.192     0.200
     2.082    13.565     0.200
     0.017     2.487     0.200
     0.161     1.732     0.200
     0.223     2.312     0.200
     0.221     2.362     0.200
     0.322     2.867     0.200
     0.357     2.909     0.200
     0.386     2.663     0.200
     0.445     3.368     0.200
     0.450     3.609     0.200
     0.449     3.283     0.200
     0.469     3.829     0.200
     0.585     4.428     0.200
     0.601     4.820     0.200
     0.595     4.228     0.200
     0.639     5.310     0.200
     0.662     4.533     0.200
     0.678     4.662     0.200
     0.666     5.080     0.200
     0.719     5.420     0.200
     0.741     5.291     0.200
     0.734     5.080     0.200
     0.745     5.122     0.200
     0.743     5.268     0.200
     0.763     6.101     0.200
     0.818     6.718     0.200
     0.802     6.020     0.200
     0.883     6.886     0.200
     0.936     6.556     0.200
     1.046     7.668     0.200
     0.116     1.673     0.200
     0.256     2.105     0.200
     0.275     2.246     0.200
     0.316     2.588     0.200
     0.365     3.154     0.200
     0.433     3.587     0.200
     0.422     3.372     0.200
     0.465     3.209     0.200
     0.467     3.720     0.200
     0.443     3.833     0.200
     0.479     3.539     0.200
     0.516     3.609     0.200
     0.501     3.507     0.200
     0.580     4.649     0.200
     0.624     4.378     0.200
     0.617     4.495     0.200
     0.630     4.550     0.200
     0.660     4.532     0.200
     0.662     4.861     0.200
     0.685     4.740     0.200
     0.703     4.643     0.200
     0.702     4.896     0.200
     0.682     5.455     0.200
     0.790     5.637     0.200
     0.858     5.992     0.200
     0.838     6.600     0.200
     0.876     6.204     0.200
     0.879     6.067     0.200
     0.913     6.849     0.200
     0.981     6.835     0.200
     1.005     6.765     0.200
     1.024     7.335     0.200
     1.464    10.433     0.200
     1.533    10.893     0.200
     1.608    11.341     0.200
     1.627    10.921     0.200
     1.689    11.862     0.200
     0.359     4.255     0.200
     0.621     4.237     0.200
     1.598    10.925     0.200
     1.685    10.731     0.200
     0.087     0.985     0.200
     0.135     1.436     0.200
     0.172     1.181     0.200
     0.169     1.120     0.200
     0.223     1.933     0.200
     0.308     1.964     0.200
     0.405     3.664     0.200
     0.469     3.735     0.200
     0.463     3.581     0.200
     0.495     4.711     0.200
     0.589     3.731     0.200
     0.607     3.960     0.200
     0.609     5.127     0.200
     0.643     4.512     0.200
     0.676     4.523     0.200
     0.717     5.681     0.200
     0.778     5.753     0.200
     0.160     1.189     0.200
     0.209     1.190     0.200
     0.228     2.024     0.200
     0.322     2.466     0.200
     0.311     1.838     0.200
     0.345     2.717     0.200
     0.333     2.453     0.200
     0.374     2.605     0.200
     0.448     3.330     0.200
     0.483     3.506     0.200
     0.635     5.015     0.200
     0.695     5.603     0.200
     0.704     5.366     0.200
     0.874     5.786     0.200
     0.865     6.189     0.200
     0.886     6.967     0.200
     0.927     6.635     0.200
     0.043     2.042     0.200
     0.174     1.631     0.200
     0.190     1.648     0.200
     0.264     1.779     0.200
     0.357     2.839     0.200
     0.362     2.640     0.200
     0.425     2.589     0.200
     0.447     3.779     0.200
     0.485     3.826     0.200
     0.602     3.813     0.200
     0.632     4.624     0.200
     0.645     4.985     0.200
     0.773     5.623     0.200
     0.779     5.710     0.200
     0.780     5.558     0.200
     0.792     5.743     0.200
     0.786     5.986     0.200
     0.827     6.522     0.200
     1.024     7.316     0.200
     1.191     7.757     0.200
     0.076     1.875     0.200
     0.226     1.734     0.200
     0.278     1.884     0.200
     0.387     3.111     0.200
     0.392     3.415     0.200
     0.407     3.184     0.200
     0.499     3.656     0.200
     0.571     4.318     0.200
     0.604     4.798     0.200
     0.658     4.808     0.200
     0.665     5.204     0.200
     0.745     5.541     0.200
     0.773     5.369     0.200
     0.775     5.721     0.200
     0.790     5.515     0.200
     0.796     6.429     0.200
     0.807     6.099     0.200
     0.820     5.915     0.200
     1.086     7.881     0.200
     1.202     8.329     0.200
     0.054     1.777     0.200
     0.123     1.186     0.200
     0.217     2.375     0.200
     0.226     2.074     0.200
     0.244     2.056     0.200
     0.244     2.057     0.200
     0.313     2.894     0.200
     0.362     3.002     0.200
     0.386     3.170     0.200
     0.395     3.287     0.200
     0.466     3.465     0.200
     0.626     4.683     0.200
     0.657     4.970     0.200
     0.676     5.214     0.200
     0.681     5.219     0.200
     0.749     5.601     0.200
     0.794     5.950     0.200
     0.796     5.787     0.200
     1.457    10.127     0.200
     0.117     2.379     0.200
     0.144     2.233     0.200
     0.156     2.278     0.200
     0.164     2.398     0.200
     0.342     3.292     0.200
     0.385     3.349     0.200
     0.450     3.831     0.200
     0.500     3.905     0.200
     0.550     3.889     0.200
     0.591     4.857     0.200
     0.650     5.187     0.200
     0.654     4.928     0.200
     0.656     5.292     0.200
     0.704     4.632     0.200
     0.717     5.162     0.200
     0.727     5.553     0.200
     0.724     5.226     0.200
     0.735     5.257     0.200
     0.825     6.211     0.200
     1.407     9.958     0.200
     1.224     6.978     0.200
     1.784    12.893     0.200
     1.949    12.133     0.200
     0.252     2.646     0.200
     0.348     2.892     0.200
     0.449     3.337     0.200
     0.424     3.696     0.200
     0.468     3.474     0.200
     0.480     3.523     0.200
     0.679     5.104     0.200
     0.678     5.094     0.200
     0.759     5.400     0.200
     0.812     6.161     0.200
     0.910     6.264     0.200
     0.953     6.608     0.200
     1.032     7.331     0.200
     1.126     8.064     0.200
     1.187     8.223     0.200
     1.260     8.864     0.200
     1.298     8.667     0.200
     1.655    11.266     0.200
     1.700    11.543     0.200
     1.765    12.019     0.200
     1.799    12.250     0.200
     1.969    13.029     0.200
     2.025    13.241     0.200
     2.132    13.775     0.200
     2.274    14.469     0.200
     0.233     2.009     0.200
     0.953     6.920     0.200
     1.187     8.520     0.200
     1.298     9.026     0.200
     1.655    11.777     0.200
     1.700    11.723     0.200
     1.765    11.909     0.200
     2.151    13.629     0.200
     2.264    14.496     0.200
     2.441    15.401     0.200
     0.453     3.289     0.200
     1.415     9.460     0.200
     3.343    21.402     0.200
     0.249     2.080     0.200
     0.234     2.144     0.200
     0.320     2.324     0.200
     0.396     2.687     0.200
     0.484     4.176     0.200
     0.494     4.086     0.200
     0.520     3.672     0.200
     0.598     4.116     0.200
     0.636     4.080     0.200
     0.645     4.496     0.200
     0.684     5.672     0.200
     0.741     5.418     0.200
     0.745     5.139     0.200
     0.811     5.594     0.200
     1.038     7.525     0.200
     1.161     8.519     0.200
     0.248     2.310     0.200
     0.252     2.145     0.200
     0.297     2.620     0.200
     0.339     2.679     0.200
     0.373     3.144     0.200
     0.370     3.045     0.200
     0.495     2.995     0.200
     0.501     3.725     0.200
     0.540     4.110     0.200
     0.548     4.085     0.200
     0.572     3.757     0.200
     0.574     4.298     0.200
     0.570     4.060     0.200
     0.663     4.790     0.200
     0.657     5.079     0.200
     0.673     5.081     0.200
     0.746     5.541     0.200
     0.780     5.567     0.200
     0.823     5.882     0.200
     0.868     6.414     0.200
     0.870     6.267     0.200
     0.905     6.368     0.200
     1.016     7.458     0.200
     1.026     7.348     0.200
     1.082     7.639     0.200
     1.166     8.426     0.200
     1.666    11.361     0.200
     1.676    11.257     0.200
     1.897    12.461     0.200
     2.010    12.885     0.200
     0.565     3.405     0.200
     0.667     5.266     0.200
     2.067    14.843     0.200
     2.621    16.651     0.200
     0.055     2.007     0.200
     0.217     2.512     0.200
     0.240     2.689     0.200
     0.256     2.278     0.200
     0.220     2.771     0.200
     0.297     2.750     0.200
     0.404     3.226     0.200
     0.440     3.570     0.200
     0.436     3.434     0.200
     0.558     4.172     0.200
     0.641     4.698     0.200
     0.683     4.869     0.200
     0.909     6.918     0.200
     1.589    10.437     0.200
     1.603    10.989     0.200
     1.686    11.382     0.200
     1.727    11.343     0.200
     2.102    12.907     0.200
     2.178    13.767     0.200
     2.296    14.186     0.200
     2.316    14.346     0.200
     0.287     2.279     0.200
     0.300     2.236     0.200
     0.306     2.575     0.200
     0.359     3.143     0.200
     0.359     2.885     0.200
     0.435     3.489     0.200
     0.464     3.689     0.200
     0.512     3.578     0.200
     0.523     3.963     0.200
     0.529     3.971     0.200
     0.554     4.533     0.200
     0.723     5.334     0.200
     0.797     5.657     0.200
     0.836     5.583     0.200
     0.148     1.840     0.200
     0.239     2.537     0.200
     0.394     3.506     0.200
     0.544     4.323     0.200
     0.562     4.719     0.200
     0.629     5.210     0.200
     0.793     6.267     0.200
     0.943     6.707     0.200
     1.150     7.840     0.200
     0.113     1.726     0.200
     0.177     1.719     0.200
     0.242     2.119     0.200
     0.328     2.435     0.200
     0.480     3.331     0.200
     0.479     3.603     0.200
     0.478     3.682     0.200
     0.492     3.561     0.200
     0.579     3.939     0.200
     0.614     4.456     0.200
     0.610     4.080     0.200
     0.662     4.743     0.200
     0.668     4.904     0.200
     0.703     5.442     0.200
     0.749     5.897     0.200
     0.781     5.973     0.200
     0.821     6.149     0.200
     1.025     7.322     0.200
     1.103     7.862     0.200
     0.324     1.991     0.200
     0.688     4.745     0.200
     1.287     8.820     0.200
     0.608     4.543     0.200
     0.163     1.391     0.200
     0.206     1.921     0.200
     0.236     1.756     0.200
     0.316     2.768     0.200
     0.332     2.727     0.200
     0.384     2.802     0.200
     0.393     2.855     0.200
     0.404     3.296     0.200
     0.435     2.948     0.200
     0.447     3.143     0.200
     0.545     3.938     0.200
     0.567     4.026     0.200
     0.590     4.459     0.200
     0.652     4.508     0.200
     0.653     4.814     0.200
     0.665     5.225     0.200
     0.725     5.247     0.200
     0.722     5.189     0.200
     0.729     5.186     0.200
     0.771     5.391     0.200
     0.777     5.625     0.200
     0.950     7.329     0.200
     0.952     6.471     0.200
     0.987     7.738     0.200
     1.559    11.980     0.200
     1.593    11.449     0.200
     1.769    12.582     0.200
     1.800    12.862     0.200
     1.924    13.285     0.200
     0.582     4.373     0.200
     0.677     4.519     0.200
     2.532    15.404     0.200
     2.787    16.294     0.200
     2.852    16.668     0.200
     0.211     1.480     0.200
     0.244     1.838     0.200
     0.293     2.670     0.200
     0.326     2.014     0.200
     0.363     2.657     0.200
     0.391     2.881     0.200
     0.433     2.990     0.200
     0.521     3.625     0.200
     0.515     3.635     0.200
     0.602     4.414     0.200
     0.669     4.673     0.200
     0.702     4.938     0.200
     0.718     5.067     0.200
     0.887     7.064     0.200
     0.888     6.573     0.200
     0.204     2.219     0.200
     0.293     2.820     0.200
     0.303     2.873     0.200
     0.341     2.997     0.200
     0.371     3.246     0.200
     0.361     3.074     0.200
     0.415     3.229     0.200
     0.407     3.425     0.200
     0.463     3.802     0.200
     0.484     3.811     0.200
     0.501     3.565     0.200
     0.512     4.135     0.200
     0.529     4.164     0.200
     0.582     4.650     0.200
     0.648     4.875     0.200
     0.679     4.896     0.200
     0.667     4.838     0.200
     0.678     4.889     0.200
     0.711     4.710     0.200
     0.758     5.484     0.200
     0.763     5.318     0.200
     0.770     5.943     0.200
     0.830     6.210     0.200
     0.845     5.795     0.200
     0.843     6.358     0.200
     0.905     6.584     0.200
     0.942     6.386     0.200
     0.961     7.103     0.200
     1.065     7.695     0.200
     1.084     7.510     0.200
     1.491    10.328     0.200
     1.570    11.146     0.200
     1.692    11.965     0.200
     1.796    12.065     0.200
     1.903    12.934     0.200
     0.146     2.741     0.200
     0.159     2.780     0.200
     0.180     2.702     0.200
     0.192     3.065     0.200
     0.325     3.037     0.200
     0.330     3.197     0.200
     0.406     3.443     0.200
     0.580     4.588     0.200
     0.589     4.337     0.200
     0.601     4.748     0.200
     0.620     5.027     0.200
     0.636     5.093     0.200
     0.721     5.000     0.200
     0.730     5.559     0.200
     0.733     5.509     0.200
     0.738     5.277     0.200
     0.758     5.858     0.200
     0.772     5.271     0.200
     0.782     5.948     0.200
     0.875     6.138     0.200
     0.986     6.659     0.200
     0.992     6.753     0.200
     0.184     1.769     0.200
     0.244     1.956     0.200
     0.302     2.166     0.200
     0.372     2.475     0.200
     0.394     2.596     0.200
     0.406     2.988     0.200
     0.424     2.984     0.200
     0.485     3.591     0.200
     0.519     3.783     0.200
     0.642     4.565     0.200
     0.860     5.743     0.200
     0.099     2.392     0.200
     0.156     2.568     0.200
     0.185     2.430     0.200
     0.206     2.552     0.200
     0.312     2.955     0.200
     0.355     2.994     0.200
     0.357     3.174     0.200
     0.529     4.021     0.200
     0.549     4.034     0.200
     0.615     4.896     0.200
     0.615     4.973     0.200
     0.622     4.862     0.200
     0.670     4.633     0.200
     0.679     4.915     0.200
     0.690     5.160     0.200
     0.695     5.014     0.200
     0.741     5.207     0.200
     0.805     5.633     0.200
     0.811     6.118     0.200
     0.824     6.324     0.200
     0.845     6.201     0.200
     0.882     6.403     0.200
     0.888     6.470     0.200
     0.918     6.822     0.200
     0.940     6.815     0.200
     0.964     7.215     0.200
     0.176     1.777     0.200
     0.242     2.335     0.200
     0.251     2.354     0.200
     0.296     2.293     0.200
     0.286     2.729     0.200
     0.382     2.968     0.200
     0.391     3.152     0.200
     0.402     3.011     0.200
     0.438     3.545     0.200
     0.484     3.489     0.200
     0.480     3.878     0.200
     0.516     3.710     0.200
     0.621     4.774     0.200
     0.633     4.483     0.200
     0.644     4.384     0.200
     0.676     4.658     0.200
     0.674     4.833     0.200
     0.734     5.513     0.200
     0.797     5.679     0.200
     0.816     5.881     0.200
     0.834     6.239     0.200
     0.851     6.119     0.200
     0.923     6.930     0.200
     0.974     7.193     0.200
     1.035     7.477     0.200
     1.043     7.729     0.200
     1.503    10.457     0.200
     0.079     0.960     0.200
     0.182     1.839     0.200
     0.265     1.924     0.200
     0.304     2.202     0.200
     0.337     2.476     0.200
     0.358     2.951     0.200
     0.399     3.040     0.200
     0.528     3.984     0.200
     0.582     4.294     0.200
     0.683     4.662     0.200
     0.742     5.271     0.200
     0.749     5.206     0.200
     0.795     5.473     0.200
     1.046     7.898     0.200
     1.083     8.642     0.200
     1.237     8.972     0.200
     1.637    11.573     0.200
     1.684    12.108     0.200
     1.734    12.900     0.200
     1.839    13.108     0.200
     1.911    13.018     0.200
     1.924    13.888     0.200
     1.962    13.879     0.200
     1.985    13.404     0.200
     2.008    14.109     0.200
     2.101    14.649     0.200
     2.178    14.496     0.200
     2.302    15.340     0.200
     2.395    15.593     0.200
     0.081     4.301     0.200
     0.140     4.168     0.200
     0.212     3.557     0.200
     0.290     3.686     0.200
     0.334     3.779     0.200
     0.344     3.661     0.200
     0.310     4.103     0.200
     0.311     3.944     0.200
     0.399     3.801     0.200
     0.438     3.970     0.200
     0.476     4.385     0.200
     0.497     4.423     0.200
     0.558     4.985     0.200
     0.616     4.824     0.200
     0.639     4.798     0.200
     0.754     5.066     0.200
     0.860     6.116     0.200
     0.894     6.171     0.200
     0.964     6.353     0.200
     1.216     8.421     0.200
     1.282     8.553     0.200
     1.334     9.216     0.200
     1.367     9.472     0.200
     1.408     9.260     0.200
     1.540     9.634     0.200
     1.632    10.327     0.200
     1.675     9.895     0.200
     1.830    10.710     0.200
     2.018    12.357     0.200
     2.059    12.516     0.200
     2.063    13.180     0.200
     2.067    12.818     0.200
     2.164    13.290     0.200
     2.236    13.400     0.200
     2.263    13.728     0.200
     2.286    14.072     0.200
     1.680    11.400     0.200
     0.062     1.592     0.200
     0.116     1.494     0.200
     0.131     1.717     0.200
     0.178     1.514     0.200
     0.197     1.892     0.200
     0.185     2.112     0.200
     0.233     2.305     0.200
     0.322     2.820     0.200
     0.353     2.859     0.200
     0.369     2.731     0.200
     0.381     3.394     0.200
     0.433     3.281     0.200
     0.436     3.546     0.200
     0.481     3.634     0.200
     0.505     3.695     0.200
     0.513     4.270     0.200
     0.533     4.457     0.200
     0.607     3.954     0.200
     0.608     4.138     0.200
     0.631     4.481     0.200
     0.677     4.907     0.200
     0.701     4.590     0.200
     0.701     4.761     0.200
     0.681     5.361     0.200
     0.849     5.867     0.200
     0.886     6.426     0.200
     0.939     6.277     0.200
     0.969     6.923     0.200
     1.180     8.125     0.200
     1.561    11.154     0.200
     1.598    10.939     0.200
     1.610    11.248     0.200
     1.606    10.831     0.200
     1.705    11.405     0.200
     1.794    12.069     0.200
     1.810    12.361     0.200
     1.847    11.927     0.200
     2.216    14.127     0.200
     0.076     2.053     0.200
     0.187     1.822     0.200
     0.225     2.027     0.200
     0.245     2.832     0.200
     0.373     3.049     0.200
     0.363     2.979     0.200
     0.444     3.634     0.200
     0.522     4.300     0.200
     0.528     4.162     0.200
     0.541     3.910     0.200
     0.564     4.015     0.200
     0.605     4.058     0.200
     0.707     5.056     0.200
     0.958     6.900     0.200
     0.994     7.087     0.200
     1.031     7.524     0.200
     1.248     8.637     0.200
     1.491    10.630     0.200
     1.581    11.082     0.200
     1.698    11.351     0.200
     2.053    13.276     0.200
     2.063    13.218     0.200
     2.117    13.629     0.200
     2.321    14.354     0.200
     0.628     4.792     0.200
     0.120     1.652     0.200
     0.159     1.945     0.200
     0.215     1.884     0.200
     0.241     2.193     0.200
     0.330     2.664     0.200
     0.360     2.750     0.200
     0.388     3.091     0.200
     0.448     3.347     0.200
     0.547     4.274     0.200
     0.606     4.784     0.200
     0.709     4.820     0.200
     0.722     5.118     0.200
     0.746     5.331     0.200
     0.936     6.732     0.200
     0.984     7.178     0.200
     0.990     7.028     0.200
     1.045     7.826     0.200
     1.504    10.704     0.200
     1.589    11.068     0.200
     1.630    11.162     0.200
     1.787    12.276     0.200
     1.869    12.730     0.200
     1.930    12.676     0.200
     1.955    12.911     0.200
     2.042    13.143     0.200
     2.104    13.676     0.200
     2.120    13.640     0.200
     2.243    14.506     0.200
     2.340    14.579     0.200
     0.111     1.752     0.200
     0.173     2.265     0.200
     0.226     2.093     0.200
     0.242     2.252     0.200
     0.371     2.713     0.200
     0.402     3.181     0.200
     0.559     4.270     0.200
     0.618     4.944     0.200
     0.641     4.768     0.200
     0.652     4.794     0.200
     1.056     7.554     0.200
     1.201     8.357     0.200
     1.462     9.955     0.200
     1.877    12.935     0.200
     0.349     3.094     0.200
     0.395     3.183     0.200
     0.458     3.908     0.200
     0.484     3.939     0.200
     0.487     3.915     0.200
     0.598     4.445     0.200
     0.602     4.438     0.200
     0.617     4.427     0.200
     0.648     5.004     0.200
     0.676     4.912     0.200
     0.680     5.217     0.200
     0.693     5.001     0.200
     0.724     5.879     0.200
     0.743     5.267     0.200
     0.750     5.157     0.200
     0.778     4.962     0.200
     0.798     6.526     0.200
     0.799     6.102     0.200
     0.830     6.107     0.200
     0.883     6.825     0.200
     0.943     6.774     0.200
     1.023     7.145     0.200
     0.086     2.588     0.200
     0.095     2.463     0.200
     0.093     2.235     0.200
     0.179     2.585     0.200
     0.254     2.527     0.200
     0.269     2.551     0.200
     0.265     2.567     0.200
     0.410     3.651     0.200
     0.446     4.057     0.200
     0.481     4.335     0.200
     0.094     2.334     0.200
     0.086     2.461     0.200
     0.096     2.055     0.200
     0.177     2.494     0.200
     0.256     2.504     0.200
     0.267     2.447     0.200
     0.267     2.595     0.200
     0.407     3.577     0.200
     0.444     3.796     0.200
     0.479     4.020     0.200
     0.817     6.618     0.200
     0.979     6.557     0.200
     1.076     7.486     0.200
     0.223     2.433     0.200
     0.310     2.955     0.200
     0.337     3.151     0.200
     0.343     3.157     0.200
     0.350     2.708     0.200
     0.426     3.214     0.200
     0.414     3.737     0.200
     0.474     4.044     0.200
     0.522     4.289     0.200
     0.552     4.264     0.200
     0.578     4.460     0.200
     0.644     4.782     0.200
     0.692     5.452     0.200
     0.680     4.763     0.200
     0.752     5.300     0.200
     0.778     5.465     0.200
     0.793     5.927     0.200
     0.782     5.988     0.200
     0.874     6.366     0.200
     0.887     6.425     0.200
     1.455    10.569     0.200
     1.826    12.491     0.200
     1.929    13.123     0.200
     0.107     1.612     0.200
     0.246     2.510     0.200
     0.264     2.327     0.200
     0.278     2.593     0.200
     0.290     2.766     0.200
     0.326     3.083     0.200
     0.354     3.076     0.200
     0.399     3.223     0.200
     0.491     3.280     0.200
     0.529     3.724     0.200
     0.560     4.366     0.200
     0.658     5.117     0.200
     0.097     1.446     0.200
     0.134     1.290     0.200
     0.121     1.557     0.200
     0.210     2.563     0.200
     0.306     2.506     0.200
     0.412     2.891     0.200
     0.401     3.257     0.200
     0.447     3.666     0.200
     0.425     3.624     0.200
     0.469     3.905     0.200
     0.709     5.011     0.200
     0.742     5.122     0.200
     0.130     1.164     0.200
     0.101     1.181     0.200
     0.123     1.265     0.200
     0.233     1.959     0.200
     0.214     2.319     0.200
     0.303     2.368     0.200
     0.363     2.855     0.200
     0.386     2.859     0.200
     0.465     3.938     0.200
     0.587     4.057     0.200
     0.731     5.219     0.200
     0.109     0.751     0.200
     0.098     1.223     0.200
     0.186     1.717     0.200
     0.266     2.044     0.200
     0.319     2.425     0.200
     0.284     2.619     0.200
     0.323     2.475     0.200
     0.352     2.682     0.200
     0.441     3.561     0.200
     0.430     3.205     0.200
     0.456     3.517     0.200
     0.478     3.575     0.200
     0.515     3.468     0.200
     0.490     3.739     0.200
     0.504     3.769     0.200
     0.586     4.562     0.200
     0.666     4.400     0.200
     0.678     4.507     0.200
     0.702     5.130     0.200
     0.736     5.032     0.200
     0.737     5.326     0.200
     0.974     6.988     0.200
     1.007     6.949     0.200
     1.012     7.403     0.200
     1.030     7.123     0.200
     1.036     7.168     0.200
     1.193     9.025     0.200
     1.217     8.826     0.200
     1.768    12.418     0.200
     1.884    13.173     0.200
     1.930    13.528     0.200
     2.022    14.016     0.200
     2.032    13.761     0.200
     2.081    14.147     0.200
     0.106     1.029     0.200
     0.102     1.376     0.200
     0.190     1.848     0.200
     0.314     2.680     0.200
     0.289     2.866     0.200
     0.322     2.629     0.200
     0.349     2.979     0.200
     0.429     3.383     0.200
     0.509     3.738     0.200
     0.495     3.870     0.200
     0.510     3.783     0.200
     0.660     4.286     0.200
     0.104     1.983     0.200
     0.235     2.448     0.200
     0.251     2.415     0.200
     0.285     2.597     0.200
     0.318     2.889     0.200
     0.368     3.027     0.200
     0.351     3.155     0.200
     0.369     3.229     0.200
     0.388     3.151     0.200
     0.438     3.823     0.200
     0.518     3.915     0.200
     0.485     3.947     0.200
     0.563     4.132     0.200
     0.578     4.225     0.200
     0.580     4.171     0.200
     0.588     4.479     0.200
     0.642     5.013     0.200
     0.651     5.329     0.200
     0.792     5.945     0.200
     1.605    10.649     0.200
     1.656    11.763     0.200
     1.760    11.676     0.200
     0.187     1.914     0.200
     0.303     2.720     0.200
     0.345     2.890     0.200
     0.369     3.199     0.200
     0.403     3.218     0.200
     0.428     3.511     0.200
     0.479     3.836     0.200
     0.514     3.426     0.200
     0.574     4.265     0.200
     0.634     4.627     0.200
     0.698     5.095     0.200
     0.721     5.283     0.200
     0.739     5.627     0.200
     0.773     5.276     0.200
     0.813     5.837     0.200
     0.904     6.524     0.200
     1.008     7.147     0.200
     1.489    10.855     0.200
     1.758    12.195     0.200
     0.105     2.020     0.200
     0.113     2.023     0.200
     0.254     2.127     0.200
     0.335     2.888     0.200
     0.359     3.015     0.200
     0.378     2.899     0.200
     0.477     3.626     0.200
     0.528     4.183     0.200
     0.574     3.608     0.200
     0.591     4.475     0.200
     0.612     4.797     0.200
     0.630     4.845     0.200
     0.710     4.459     0.200
     0.749     5.237     0.200
     0.835     5.856     0.200
     0.011     2.705     0.200
     0.093     1.950     0.200
     0.159     2.149     0.200
     0.172     2.092     0.200
     0.220     2.193     0.200
     0.326     2.943     0.200
     0.343     2.765     0.200
     0.457     3.355     0.200
     0.458     3.577     0.200
     0.464     4.261     0.200
     0.489     3.747     0.200
     0.489     3.845     0.200
     0.604     4.638     0.200
     0.600     3.893     0.200
     0.620     4.770     0.200
     0.654     5.466     0.200
     0.677     4.798     0.200
     0.672     4.819     0.200
     0.685     5.173     0.200
     0.748     5.433     0.200
     0.758     5.455     0.200
     0.756     6.015     0.200
     0.783     5.622     0.200
     0.804     6.285     0.200
     0.837     5.813     0.200
     0.888     6.486     0.200
     0.165     1.866     0.200
     0.220     2.161     0.200
     0.275     2.584     0.200
     0.270     2.861     0.200
     0.283     2.419     0.200
     0.379     2.983     0.200
     0.441     3.478     0.200
     0.538     4.301     0.200
     0.570     4.360     0.200
     0.589     4.708     0.200
     0.621     4.706     0.200
     0.694     4.946     0.200
     0.697     5.248     0.200
     0.715     5.565     0.200
     0.745     5.607     0.200
     0.804     5.859     0.200
     0.812     6.034     0.200
     0.814     6.011     0.200
     0.830     5.904     0.200
     0.829     6.262     0.200
     0.842     6.367     0.200
     0.861     5.676     0.200
     0.854     6.114     0.200
     0.865     6.268     0.200
     0.898     6.081     0.200
     0.914     6.931     0.200
     0.946     6.809     0.200
     0.960     6.491     0.200
     0.951     7.248     0.200
     0.995     6.890     0.200
     1.017     7.424     0.200
     1.016     7.002     0.200
     1.076     7.309     0.200
     0.150     2.339     0.200
     0.287     3.010     0.200
     0.297     3.146     0.200
     0.293     2.891     0.200
     0.308     3.136     0.200
     0.344     3.418     0.200
     0.360     3.376     0.200
     0.420     3.689     0.200
     0.451     3.961     0.200
     0.532     4.375     0.200
     0.534     3.795     0.200
     0.614     4.884     0.200
     0.710     5.681     0.200
     0.784     5.714     0.200
     0.830     6.465     0.200
     0.687     5.117     0.200
     0.150     2.025     0.200
     0.287     2.665     0.200
     0.308     2.848     0.200
     0.298     2.869     0.200
     0.345     3.211     0.200
     0.360     3.062     0.200
     0.447     3.127     0.200
     0.457     3.488     0.200
     0.451     3.846     0.200
     0.532     3.944     0.200
     0.533     3.789     0.200
     0.527     3.493     0.200
     0.549     4.181     0.200
     0.615     4.560     0.200
     0.610     4.524     0.200
     0.659     5.438     0.200
     0.710     5.644     0.200
     0.743     5.027     0.200
     0.739     5.615     0.200
     0.784     5.746     0.200
     0.800     5.993     0.200
     0.830     6.240     0.200
     0.817     6.314     0.200
     0.820     5.622     0.200
     0.843     6.058     0.200
     0.871     5.817     0.200
     0.984     7.254     0.200
     1.471    10.695     0.200
     1.850    12.620     0.200
     1.960    12.835     0.200
     0.546     3.886     0.200
     0.609     3.902     0.200
     0.710     5.203     0.200
     1.407     8.477     0.200
     0.097     2.430     0.200
     0.152     2.774     0.200
     0.204     2.786     0.200
     0.215     2.580     0.200
     0.264     2.963     0.200
     0.321     3.104     0.200
     0.348     3.070     0.200
     0.427     3.520     0.200
     0.414     3.728     0.200
     0.481     4.043     0.200
     0.544     4.136     0.200
     0.620     4.937     0.200
     0.637     4.966     0.200
     0.632     4.921     0.200
     0.666     4.442     0.200
     0.667     4.848     0.200
     0.667     4.988     0.200
     0.669     4.647     0.200
     0.694     4.867     0.200
     0.694     5.124     0.200
     0.768     5.562     0.200
     0.792     5.518     0.200
     0.812     5.851     0.200
     0.803     6.511     0.200
     0.818     5.899     0.200
     0.854     6.565     0.200
     0.859     5.994     0.200
     0.889     6.551     0.200
     0.883     6.397     0.200
     0.981     7.099     0.200
     1.856    12.313     0.200
     0.083     2.105     0.200
     0.166     2.207     0.200
     0.248     2.056     0.200
     0.255     2.436     0.200
     0.249     2.570     0.200
     0.297     2.614     0.200
     0.332     2.908     0.200
     0.378     2.885     0.200
     0.418     3.256     0.200
     0.420     3.374     0.200
     0.491     3.746     0.200
     0.543     4.499     0.200
     0.592     3.986     0.200
     0.603     4.108     0.200
     0.576     4.924     0.200
     0.622     5.328     0.200
     0.649     4.231     0.200
     0.674     5.229     0.200
     0.882     6.516     0.200
     0.904     6.221     0.200
     0.959     7.188     0.200
     0.960     7.300     0.200
     1.005     7.332     0.200
     1.147     7.750     0.200
     1.692    11.292     0.200
     1.749    11.855     0.200
     1.808    12.254     0.200
     1.947    12.355     0.200
     0.605     4.597     0.200
     0.137     1.823     0.200
     0.133     1.460     0.200
     0.202     1.659     0.200
     0.245     2.185     0.200
     0.309     2.504     0.200
     0.337     2.430     0.200
     0.365     2.858     0.200
     0.524     3.970     0.200
     0.584     4.451     0.200
     0.625     4.573     0.200
     0.692     5.664     0.200
     0.853     6.576     0.200
     1.027     7.702     0.200
     1.176     8.463     0.200
     0.088     1.359     0.200
     0.158     1.311     0.200
     0.182     1.848     0.200
     0.210     1.952     0.200
     0.298     2.413     0.200
     0.361     2.777     0.200
     0.435     3.004     0.200
     0.424     2.768     0.200
     0.551     4.158     0.200
     0.624     4.654     0.200
     1.011     7.505     0.200
     1.017     7.528     0.200
     1.659    12.201     0.200
     0.006     2.744     0.200
     0.150     2.348     0.200
     0.179     2.067     0.200
     0.192     2.223     0.200
     0.221     2.291     0.200
     0.266     2.243     0.200
     0.275     2.080     0.200
     0.349     2.587     0.200
     0.473     3.577     0.200
     0.607     4.719     0.200
     1.011     7.060     0.200
     0.120     1.623     0.200
     0.129     1.726     0.200
     0.179     1.691     0.200
     0.250     2.004     0.200
     0.296     2.714     0.200
     0.323     2.478     0.200
     0.476     3.011     0.200
     0.484     3.156     0.200
     0.492     3.417     0.200
     0.571     4.038     0.200
     0.610     4.298     0.200
     0.612     3.993     0.200
     0.656     4.475     0.200
     0.673     5.672     0.200
     0.700     5.224     0.200
     0.709     5.743     0.200
     0.713     5.555     0.200
     0.719     4.682     0.200
     0.743     4.808     0.200
     0.779     5.749     0.200
     0.826     6.043     0.200
     0.101     1.211     0.200
     0.165     1.420     0.200
     0.175     1.378     0.200
     0.206     1.661     0.200
     0.285     2.308     0.200
     0.493     3.261     0.200
     0.528     3.592     0.200
     0.623     4.051     0.200
     0.736     5.533     0.200
     0.907     6.669     0.200
     0.104     2.561     0.200
     0.144     2.718     0.200
     0.213     2.771     0.200
     0.211     3.057     0.200
     0.294     3.199     0.200
     0.349     3.479     0.200
     0.377     3.645     0.200
     0.394     3.562     0.200
     0.488     4.114     0.200
     0.486     4.061     0.200
     0.500     4.107     0.200
     0.521     4.440     0.200
     0.542     4.225     0.200
     0.568     4.900     0.200
     0.573     4.612     0.200
     0.641     5.072     0.200
     0.637     5.048     0.200
     0.711     5.852     0.200
     0.724     5.380     0.200
     0.742     5.575     0.200
     0.755     5.749     0.200
     0.776     5.931     0.200
     0.840     6.279     0.200
     0.862     6.382     0.200
     0.121     1.236     0.200
     0.151     1.737     0.200
     0.214     1.657     0.200
     0.247     2.047     0.200
     0.324     2.486     0.200
     0.348     2.341     0.200
     0.380     2.723     0.200
     0.447     2.919     0.200
     0.536     3.844     0.200
     0.595     4.052     0.200
     0.637     4.654     0.200
     0.705     5.023     0.200
     0.745     5.221     0.200
     0.867     6.397     0.200
     0.940     6.180     0.200
     0.936     6.536     0.200
     0.969     6.890     0.200
     0.997     7.981     0.200
     0.988     6.918     0.200
     0.989     7.236     0.200
     1.041     8.258     0.200
     1.630    12.157     0.200
     1.679    11.829     0.200
     1.787    13.093     0.200
     1.862    12.166     0.200
     1.870    12.854     0.200
     1.906    13.141     0.200
     1.955    14.036     0.200
     2.045    14.172     0.200
     2.104    14.364     0.200
     2.122    14.816     0.200
     2.341    15.139     0.200
     2.455    15.788     0.200
     0.081     1.784     0.200
     0.206     1.912     0.200
     0.224     1.853     0.200
     0.218     2.106     0.200
     0.275     2.511     0.200
     0.422     3.081     0.200
     0.459     3.994     0.200
     0.582     4.032     0.200
     0.671     4.773     0.200
     0.843     6.253     0.200
     0.931     6.539     0.200
     0.082     1.357     0.200
     0.202     2.190     0.200
     0.258     2.244     0.200
     0.264     2.127     0.200
     0.374     2.865     0.200
     0.387     2.674     0.200
     0.429     3.410     0.200
     0.490     3.198     0.200
     0.577     4.102     0.200
     0.634     4.486     0.200
     0.664     4.773     0.200
     0.684     4.905     0.200
     0.752     5.485     0.200
     0.765     5.685     0.200
     0.787     5.654     0.200
     0.915     7.023     0.200
     1.020     7.383     0.200
     1.031     7.643     0.200
     1.520    10.756     0.200
     1.547    10.902     0.200
     1.630    11.347     0.200
     1.826    12.407     0.200
     1.907    12.532     0.200
     1.994    13.301     0.200
     0.079     1.859     0.200
     0.263     2.392     0.200
     0.265     2.363     0.200
     0.395     2.838     0.200
     0.437     3.523     0.200
     0.584     4.274     0.200
     0.641     4.943     0.200
     0.672     5.006     0.200
     1.490    10.339     0.200
     1.998    13.363     0.200
     0.150     2.122     0.200
     0.153     1.945     0.200
     0.153     2.500     0.200
     0.203     2.025     0.200
     0.294     2.714     0.200
     0.376     2.766     0.200
     0.376     3.215     0.200
     0.394     3.095     0.200
     0.575     4.269     0.200
     0.571     4.487     0.200
     0.634     5.412     0.200
     0.646     4.926     0.200
     0.636     4.908     0.200
     0.671     4.774     0.200
     0.688     4.959     0.200
     0.854     5.637     0.200
     0.855     5.860     0.200
     0.894     5.979     0.200
     0.897     6.688     0.200
     0.914     6.944     0.200
     0.956     7.236     0.200
     1.513    10.696     0.200
     1.546    11.095     0.200
     1.817    12.464     0.200
     2.023    13.137     0.200
     2.256    14.485     0.200
     0.399     2.704     0.200
     1.813    13.526     0.200
     0.012     2.741     0.200
     0.114     2.235     0.200
     0.158     2.185     0.200
     0.233     2.713     0.200
     0.310     3.165     0.200
     0.347     3.105     0.200
     0.375     3.235     0.200
     0.460     3.808     0.200
     0.468     3.764     0.200
     0.461     3.563     0.200
     0.473     3.983     0.200
     0.583     4.359     0.200
     0.591     4.581     0.200
     0.600     4.419     0.200
     0.655     4.908     0.200
     0.680     4.453     0.200
     0.679     5.096     0.200
     0.685     5.741     0.200
     0.723     5.255     0.200
     0.731     5.519     0.200
     0.737     5.035     0.200
     0.731     5.624     0.200
     0.764     5.637     0.200
     0.802     6.350     0.200
     0.814     6.214     0.200
     0.824     5.694     0.200
     0.826     6.405     0.200
     0.947     6.889     0.200
     1.034     7.418     0.200
     1.033     7.296     0.200
     1.141     7.544     0.200
     0.133     1.556     0.200
     0.116     1.604     0.200
     0.184     1.458     0.200
     0.237     2.173     0.200
     0.269     2.442     0.200
     0.279     2.289     0.200
     0.285     2.512     0.200
     0.315     2.588     0.200
     0.410     3.209     0.200
     0.432     3.321     0.200
     0.484     3.606     0.200
     0.494     3.525     0.200
     0.515     3.232     0.200
     0.565     4.143     0.200
     0.574     3.776     0.200
     0.569     3.897     0.200
     0.690     5.138     0.200
     1.065     6.988     0.200
     1.624    11.428     0.200
     1.651    11.625     0.200
     1.676    11.848     0.200
     0.034     2.596     0.200
     0.122     1.954     0.200
     0.194     2.293     0.200
     0.258     2.476     0.200
     0.291     2.953     0.200
     0.308     2.600     0.200
     0.365     3.304     0.200
     0.498     3.824     0.200
     0.567     4.433     0.200
     0.621     4.845     0.200
     0.627     4.355     0.200
     0.688     5.391     0.200
     0.709     5.524     0.200
     0.710     5.104     0.200
     0.715     5.375     0.200
     0.723     5.300     0.200
     0.841     6.621     0.200
     0.865     6.242     0.200
     0.030     2.776     0.200
     0.113     2.267     0.200
     0.195     2.547     0.200
     0.250     2.740     0.200
     0.300     3.032     0.200
     0.311     2.554     0.200
     0.374     3.323     0.200
     0.444     3.785     0.200
     0.492     3.938     0.200
     0.496     4.123     0.200
     0.576     4.460     0.200
     0.627     4.264     0.200
     0.628     4.283     0.200
     0.685     5.574     0.200
     0.712     5.148     0.200
     0.706     5.371     0.200
     0.719     5.475     0.200
     0.724     5.444     0.200
     0.719     5.650     0.200
     0.796     6.190     0.200
     1.019     7.185     0.200
     0.127     1.766     0.200
     0.200     2.147     0.200
     0.262     2.746     0.200
     0.273     3.222     0.200
     0.318     2.803     0.200
     0.388     3.260     0.200
     0.401     3.548     0.200
     0.412     3.419     0.200
     0.432     3.404     0.200
     0.486     3.878     0.200
     0.629     4.613     0.200
     0.634     4.274     0.200
     0.645     4.875     0.200
     0.657     4.523     0.200
     0.732     5.237     0.200
     0.874     6.327     0.200
     0.919     6.883     0.200
     1.518    10.417     0.200
     1.623    11.193     0.200
     0.100     1.085     0.200
     0.185     1.970     0.200
     0.263     2.802     0.200
     0.276     2.801     0.200
     0.306     2.900     0.200
     0.369     3.409     0.200
     0.408     3.533     0.200
     0.427     3.681     0.200
     0.454     3.841     0.200
     0.456     3.858     0.200
     0.462     3.497     0.200
     0.531     3.864     0.200
     0.598     4.900     0.200
     0.638     4.987     0.200
     0.650     4.571     0.200
     0.665     4.874     0.200
     0.688     5.381     0.200
     0.674     4.888     0.200
     0.691     5.089     0.200
     0.759     5.918     0.200
     0.782     6.053     0.200
     0.790     5.707     0.200
     0.809     5.433     0.200
     0.816     5.822     0.200
     0.919     7.156     0.200
     0.948     7.088     0.200
     1.000     7.228     0.200
     1.041     7.357     0.200
     1.080     7.877     0.200
     1.069     7.861     0.200
     1.486     9.905     0.200
     1.591    11.702     0.200
     0.164     2.168     0.200
     0.179     2.617     0.200
     0.210     2.208     0.200
     0.285     2.452     0.200
     0.341     2.980     0.200
     0.361     3.267     0.200
     0.388     2.870     0.200
     0.629     4.851     0.200
     0.706     4.965     0.200
     0.732     5.107     0.200
     0.772     5.295     0.200
     0.084     2.365     0.200
     0.194     2.526     0.200
     0.233     2.812     0.200
     0.274     2.796     0.200
     0.309     3.005     0.200
     0.347     3.412     0.200
     0.367     2.936     0.200
     0.362     3.452     0.200
     0.488     3.968     0.200
     0.497     4.339     0.200
     0.503     4.146     0.200
     0.547     4.134     0.200
     0.556     4.280     0.200
     0.612     4.896     0.200
     0.745     5.625     0.200
     0.760     5.284     0.200
     1.040     6.836     0.200
     0.135     2.535     0.200
     0.212     2.799     0.200
     0.263     2.698     0.200
     0.343     3.285     0.200
     0.362     3.243     0.200
     0.414     3.224     0.200
     0.499     4.226     0.200
     0.636     5.041     0.200
     0.650     5.176     0.200
     0.677     5.293     0.200
     0.689     5.101     0.200
     0.680     4.958     0.200
     0.815     5.566     0.200
     0.882     6.706     0.200
     0.894     6.547     0.200
     0.983     7.179     0.200
     1.019     7.342     0.200
     1.429    10.310     0.200
     0.161     2.415     0.200
     0.255     2.875     0.200
     0.338     2.576     0.200
     0.405     3.252     0.200
     0.623     4.675     0.200
     0.634     4.837     0.200
     0.656     5.304     0.200
     0.675     4.813     0.200
     0.145     2.653     0.200
     0.202     3.060     0.200
     0.233     3.012     0.200
     0.255     2.957     0.200
     0.352     3.405     0.200
     0.406     3.609     0.200
     0.498     4.090     0.200
     0.558     4.545     0.200
     0.636     5.193     0.200
     0.649     5.315     0.200
     0.683     4.886     0.200
     0.708     5.341     0.200
     0.775     5.485     0.200
     0.807     6.047     0.200
     0.897     6.331     0.200
     0.135     2.714     0.200
     0.211     3.076     0.200
     0.237     2.837     0.200
     0.262     2.905     0.200
     0.343     3.214     0.200
     0.361     3.316     0.200
     0.413     3.562     0.200
     0.450     3.571     0.200
     0.500     3.503     0.200
     0.637     5.157     0.200
     0.651     5.072     0.200
     0.681     5.203     0.200
     0.717     5.620     0.200
     0.716     5.421     0.200
     0.881     6.682     0.200
     0.901     6.810     0.200
     0.895     6.070     0.200
     0.161     2.029     0.200
     0.176     1.744     0.200
     0.188     2.175     0.200
     0.281     2.702     0.200
     0.313     2.577     0.200
     0.357     3.050     0.200
     0.413     3.457     0.200
     0.396     3.376     0.200
     0.433     3.580     0.200
     0.532     3.706     0.200
     0.573     4.528     0.200
     0.648     4.500     0.200
     0.654     4.803     0.200
     0.653     5.060     0.200
     0.726     5.545     0.200
     0.754     5.798     0.200
     0.818     6.677     0.200
     0.858     6.591     0.200
     0.937     6.707     0.200
     0.979     7.143     0.200
     1.196     7.784     0.200
     1.503    10.800     0.200
     1.533    10.364     0.200
     1.593    11.209     0.200
     1.743    11.696     0.200
     1.749    12.385     0.200
     1.872    12.247     0.200
     1.972    12.647     0.200
     0.098     1.373     0.200
     0.195     1.944     0.200
     0.229     1.779     0.200
     0.247     2.485     0.200
     0.295     2.661     0.200
     0.315     2.789     0.200
     0.362     3.139     0.200
     0.358     3.304     0.200
     0.372     3.189     0.200
     0.511     3.857     0.200
     0.542     3.487     0.200
     0.512     3.850     0.200
     0.517     3.539     0.200
     0.539     4.026     0.200
     0.601     4.710     0.200
     0.608     4.954     0.200
     0.618     5.084     0.200
     0.632     4.682     0.200
     0.696     5.205     0.200
     0.692     5.534     0.200
     0.759     5.493     0.200
     0.808     5.832     0.200
     0.840     5.884     0.200
     0.879     6.593     0.200
     0.879     6.716     0.200
     0.912     6.457     0.200
     0.927     6.701     0.200
     0.924     6.668     0.200
     1.068     7.861     0.200
     1.105     8.298     0.200
     1.558    11.549     0.200
     1.652    11.876     0.200
     1.706    12.322     0.200
     1.915    12.735     0.200
     1.941    13.360     0.200
     2.057    13.835     0.200
     0.507     3.373     0.200
     0.650     4.645     0.200
     0.609     5.156     0.200
     0.080     2.100     0.200
     0.222     2.702     0.200
     0.263     2.637     0.200
     0.271     2.655     0.200
     0.409     3.177     0.200
     0.450     3.754     0.200
     0.599     4.689     0.200
     0.656     5.068     0.200
     0.686     5.635     0.200
     0.114     1.237     0.200
     0.198     2.055     0.200
     0.219     1.930     0.200
     0.261     2.339     0.200
     0.309     2.610     0.200
     0.321     2.686     0.200
     0.370     3.231     0.200
     0.373     3.157     0.200
     0.385     3.077     0.200
     0.541     3.663     0.200
     0.523     3.741     0.200
     0.528     3.902     0.200
     0.542     3.792     0.200
     0.608     4.460     0.200
     0.623     4.349     0.200
     0.624     4.720     0.200
     0.632     4.960     0.200
     0.706     5.460     0.200
     0.837     6.132     0.200
     0.935     6.814     0.200
     1.204     8.717     0.200
     1.560    11.542     0.200
     1.709    12.394     0.200
     1.942    13.172     0.200
     2.057    13.489     0.200
     0.231     2.786     0.200
     0.336     2.602     0.200
     0.349     3.303     0.200
     0.364     3.643     0.200
     0.397     3.538     0.200
     0.407     3.653     0.200
     0.413     3.619     0.200
     0.440     4.069     0.200
     0.447     4.025     0.200
     0.511     4.367     0.200
     0.534     4.319     0.200
     0.546     4.241     0.200
     0.620     5.058     0.200
     0.639     4.919     0.200
     0.637     5.371     0.200
     0.687     5.649     0.200
     0.751     5.448     0.200
     0.769     5.325     0.200
     0.773     5.863     0.200
     0.809     6.025     0.200
     0.843     6.089     0.200
     0.835     5.978     0.200
     0.882     6.557     0.200
     0.946     7.066     0.200
     0.945     6.845     0.200
     1.499    10.672     0.200
     1.585    11.095     0.200
     1.605    11.061     0.200
     1.769    11.845     0.200
     0.879     6.437     0.200
     1.374     8.977     0.200
     1.594    10.546     0.200
     1.667    12.161     0.200
     1.770    10.010     0.200
     2.427    12.892     0.200
     0.102     1.178     0.200
     0.205     1.904     0.200
     0.295     2.147     0.200
     0.326     3.002     0.200
     0.357     2.940     0.200
     0.369     3.136     0.200
     0.532     3.398     0.200
     0.524     3.904     0.200
     0.618     4.620     0.200
     0.629     4.627     0.200
     0.693     5.165     0.200
     0.703     5.606     0.200
     0.922     6.975     0.200
     0.347     3.347     0.200
     1.505    11.425     0.200
     1.685    10.322     0.200
     1.896    11.342     0.200
     2.119    11.972     0.200
     2.084    12.094     0.200
     2.141    12.749     0.200
     2.155    12.426     0.200
     2.115    13.910     0.200
     2.261    12.452     0.200
     2.296    14.014     0.200
     0.151     1.350     0.200
     0.223     1.824     0.200
     0.235     2.476     0.200
     0.326     2.668     0.200
     0.349     2.886     0.200
     0.407     3.055     0.200
     0.484     3.504     0.200
     0.523     3.848     0.200
     0.677     5.332     0.200
     1.232     8.644     0.200
     1.011     7.262     0.200
     0.032     1.868     0.200
     0.165     1.966     0.200
     0.175     1.808     0.200
     0.203     2.209     0.200
     0.272     2.468     0.200
     0.369     3.221     0.200
     0.367     3.002     0.200
     0.482     3.602     0.200
     0.510     3.845     0.200
     0.581     4.522     0.200
     0.571     4.242     0.200
     0.590     4.971     0.200
     0.599     4.100     0.200
     0.643     4.939     0.200
     0.638     4.714     0.200
     0.665     4.990     0.200
     0.711     4.810     0.200
     0.708     5.323     0.200
     0.728     5.429     0.200
     0.725     5.415     0.200
     0.787     6.018     0.200
     0.848     6.720     0.200
     0.864     6.568     0.200
     0.927     6.651     0.200
     1.011     7.329     0.200
     1.140     8.150     0.200
     1.188     8.257     0.200
     1.736    12.344     0.200
     1.946    12.824     0.200
     2.317    15.743     0.200
     2.738    16.314     0.200
     0.175     1.590     0.200
     0.277     2.081     0.200
     0.311     1.895     0.200
     0.341     2.389     0.200
     0.347     2.797     0.200
     0.501     3.309     0.200
     0.545     3.657     0.200
     0.556     4.275     0.200
     0.661     4.874     0.200
     0.740     5.387     0.200
     1.038     7.396     0.200
     0.122     1.454     0.200
     0.203     1.613     0.200
     0.257     2.199     0.200
     0.312     2.513     0.200
     0.317     2.638     0.200
     0.394     3.014     0.200
     0.426     3.135     0.200
     0.452     3.157     0.200
     0.586     3.782     0.200
     0.604     4.027     0.200
     0.665     4.502     0.200
     0.713     5.074     0.200
     0.717     5.291     0.200
     0.721     5.349     0.200
     0.809     5.995     0.200
     0.807     6.018     0.200
     0.867     6.070     0.200
     0.914     6.720     0.200
     0.932     6.956     0.200
     0.991     7.156     0.200
     1.085     7.204     0.200
     1.481    11.015     0.200
     0.035     2.446     0.200
     0.127     2.324     0.200
     0.193     2.067     0.200
     0.287     2.655     0.200
     0.308     2.699     0.200
     0.361     2.891     0.200
     0.431     3.397     0.200
     0.481     3.668     0.200
     0.500     3.980     0.200
     0.505     4.229     0.200
     0.499     3.853     0.200
     0.563     4.326     0.200
     0.618     4.554     0.200
     0.625     4.692     0.200
     0.657     4.704     0.200
     0.688     6.128     0.200
     0.683     5.068     0.200
     0.706     5.669     0.200
     0.706     5.385     0.200
     0.711     5.167     0.200
     0.715     5.608     0.200
     0.748     5.415     0.200
     0.770     6.094     0.200
     0.789     6.382     0.200
     0.796     5.680     0.200
     0.846     6.306     0.200
     0.931     6.807     0.200
     0.961     6.920     0.200
     0.986     7.081     0.200
     1.001     6.626     0.200
     1.136     7.553     0.200
     1.120     7.650     0.200
     1.269     8.017     0.200
     1.361     9.120     0.200
     1.339     9.320     0.200
     1.878    12.151     0.200
     1.980    12.759     0.200
     2.116    14.643     0.200
     2.129    12.950     0.200
     2.181    13.422     0.200
     2.301    15.327     0.200
     2.497    12.947     0.200
     2.570    14.546     0.200
     0.034     2.084     0.200
     0.130     1.631     0.200
     0.187     1.771     0.200
     0.284     2.513     0.200
     0.312     2.326     0.200
     0.474     3.225     0.200
     0.496     3.741     0.200
     0.610     4.742     0.200
     0.619     4.179     0.200
     0.651     4.264     0.200
     0.702     5.118     0.200
     0.707     5.218     0.200
     0.741     5.188     0.200
     0.136     1.471     0.200
     0.231     1.899     0.200
     0.203     2.197     0.200
     0.286     2.308     0.200
     0.302     2.248     0.200
     0.311     2.503     0.200
     0.372     2.503     0.200
     0.414     3.272     0.200
     0.441     3.187     0.200
     0.463     3.801     0.200
     0.537     3.780     0.200
     0.545     4.169     0.200
     0.565     3.668     0.200
     0.606     4.704     0.200
     0.653     4.709     0.200
     0.634     4.816     0.200
     0.880     6.115     0.200
     0.930     6.602     0.200
     1.297     8.927     0.200
     0.037     2.026     0.200
     0.136     1.621     0.200
     0.185     1.800     0.200
     0.279     2.594     0.200
     0.420     3.095     0.200
     0.495     3.695     0.200
     0.555     4.017     0.200
     0.616     3.964     0.200
     0.645     4.500     0.200
     0.703     4.794     0.200
     0.716     5.478     0.200
     0.777     6.045     0.200
     0.837     6.261     0.200
     0.997     7.324     0.200
     1.078     7.797     0.200
     0.135     1.232     0.200
     0.199     1.595     0.200
     0.290     2.473     0.200
     0.340     2.718     0.200
     0.488     3.704     0.200
     0.564     4.062     0.200
     0.681     4.336     0.200
     0.906     6.262     0.200
     0.037     2.722     0.200
     0.134     1.513     0.200
     0.185     2.359     0.200
     0.266     2.602     0.200
     0.313     2.971     0.200
     0.352     3.022     0.200
     0.421     3.458     0.200
     0.496     3.645     0.200
     0.498     3.598     0.200
     0.607     4.483     0.200
     0.646     4.996     0.200
     0.684     6.109     0.200
     0.695     5.314     0.200
     0.698     5.537     0.200
     0.715     5.596     0.200
     0.722     5.438     0.200
     0.737     5.285     0.200
     0.768     6.004     0.200
     0.779     6.398     0.200
     0.792     5.489     0.200
     0.838     6.695     0.200
     0.857     6.202     0.200
     1.116     7.668     0.200
     1.264     9.109     0.200
     1.879    12.971     0.200
     0.722     5.784     0.200
     0.192     2.659     0.200
     0.253     2.855     0.200
     0.290     3.064     0.200
     0.419     3.854     0.200
     0.415     3.698     0.200
     0.527     4.148     0.200
     0.585     4.433     0.200
     0.736     5.940     0.200
     0.809     6.019     0.200
     0.925     6.846     0.200
     0.020     3.111     0.200
     0.101     2.420     0.200
     0.152     2.483     0.200
     0.215     2.639     0.200
     0.444     3.805     0.200
     0.470     4.197     0.200
     0.584     4.909     0.200
     0.604     4.178     0.200
     0.636     5.320     0.200
     0.667     4.878     0.200
     0.740     5.151     0.200
     0.745     5.456     0.200
     0.787     6.011     0.200
     1.535    11.122     0.200
     0.113     1.752     0.200
     0.175     1.964     0.200
     0.257     2.230     0.200
     0.278     2.039     0.200
     0.316     2.571     0.200
     0.366     2.953     0.200
     0.420     3.490     0.200
     0.418     3.099     0.200
     0.438     3.334     0.200
     0.447     3.238     0.200
     0.472     3.588     0.200
     0.522     3.860     0.200
     0.500     3.988     0.200
     0.555     4.743     0.200
     0.581     4.503     0.200
     0.628     4.116     0.200
     0.662     4.752     0.200
     0.668     4.769     0.200
     0.688     4.866     0.200
     0.686     5.894     0.200
     0.708     4.725     0.200
     0.708     4.822     0.200
     0.795     5.750     0.200
     0.861     6.068     0.200
     0.840     6.574     0.200
     1.007     7.141     0.200
     1.629    11.298     0.200
     0.360     3.623     0.200
     0.745     6.956     0.200
     1.040     7.703     0.200
     1.528    11.007     0.200
     0.139     2.189     0.200
     0.143     2.155     0.200
     0.227     2.262     0.200
     0.293     2.747     0.200
     0.307     2.678     0.200
     0.623     4.862     0.200
     0.734     5.227     0.200
     0.753     5.127     0.200
     0.782     5.635     0.200
     0.803     5.689     0.200
     0.018     2.129     0.200
     0.122     1.541     0.200
     0.166     1.907     0.200
     0.246     2.227     0.200
     0.428     3.074     0.200
     0.479     3.748     0.200
     0.599     4.625     0.200
     0.649     4.923     0.200
     0.683     4.851     0.200
     0.712     5.049     0.200
     0.698     5.456     0.200
     0.814     6.001     0.200
     1.097     7.947     0.200
     0.114     1.237     0.200
     0.165     1.833     0.200
     0.186     1.589     0.200
     0.261     2.367     0.200
     0.272     2.258     0.200
     0.346     2.864     0.200
     0.347     2.875     0.200
     0.377     3.062     0.200
     0.438     3.345     0.200
     0.526     3.835     0.200
     0.538     4.083     0.200
     0.587     4.559     0.200
     0.599     4.664     0.200
     0.614     4.375     0.200
     0.637     4.739     0.200
     0.651     4.925     0.200
     0.728     5.249     0.200
     0.795     6.243     0.200
     0.830     6.234     0.200
     0.881     6.527     0.200
     1.099     8.163     0.200
     1.170     8.203     0.200
     1.201     8.598     0.200
     1.598    13.127     0.200
     1.846    13.280     0.200
     0.134     1.749     0.200
     0.316     2.913     0.200
     0.317     2.880     0.200
     0.332     2.860     0.200
     0.421     3.390     0.200
     0.492     3.636     0.200
     0.525     3.881     0.200
     0.513     4.000     0.200
     0.614     4.735     0.200
     0.616     4.604     0.200
     0.700     5.603     0.200
     0.792     5.825     0.200
     0.789     5.895     0.200
     0.773     5.801     0.200
     0.828     6.010     0.200
     0.946     7.135     0.200
     1.046     7.480     0.200
     0.610     4.197     0.200
     2.006    14.377     0.200
     0.145     2.061     0.200
     0.166     1.896     0.200
     0.267     2.193     0.200
     0.315     2.477     0.200
     0.340     2.552     0.200
     0.307     2.602     0.200
     0.380     2.943     0.200
     0.384     3.250     0.200
     0.372     2.991     0.200
     0.422     3.673     0.200
     0.435     3.351     0.200
     0.507     3.823     0.200
     0.529     3.806     0.200
     0.545     3.496     0.200
     0.523     4.152     0.200
     0.540     4.165     0.200
     0.520     4.011     0.200
     0.647     5.047     0.200
     0.636     4.792     0.200
     0.660     5.054     0.200
     0.681     4.779     0.200
     0.685     4.734     0.200
     0.683     4.788     0.200
     0.726     4.972     0.200
     0.740     5.104     0.200
     0.749     4.995     0.200
     0.753     5.032     0.200
     0.786     5.826     0.200
     0.826     5.985     0.200
     0.825     6.591     0.200
     0.852     6.091     0.200
     0.917     6.485     0.200
     0.932     6.414     0.200
     1.044     7.459     0.200
     1.070     7.975     0.200
     1.090     8.067     0.200
     1.529    11.270     0.200
     1.570    11.613     0.200
     1.598    11.534     0.200
     1.674    12.033     0.200
     1.693    11.551     0.200
     1.725    11.418     0.200
     1.755    12.279     0.200
     0.300     2.753     0.200
     0.675     4.677     0.200
     0.981     6.798     0.200
     1.664    11.414     0.200
     1.751    11.220     0.200
     0.146     2.120     0.200
     0.168     1.909     0.200
     0.270     2.335     0.200
     0.318     2.494     0.200
     0.304     2.832     0.200
     0.344     2.511     0.200
     0.383     2.990     0.200
     0.384     3.421     0.200
     0.368     2.913     0.200
     0.424     3.687     0.200
     0.432     3.417     0.200
     0.510     3.926     0.200
     0.533     3.697     0.200
     0.524     4.336     0.200
     0.549     3.715     0.200
     0.543     4.103     0.200
     0.517     4.097     0.200
     0.633     4.945     0.200
     0.647     4.973     0.200
     0.662     5.024     0.200
     0.685     4.666     0.200
     0.687     4.784     0.200
     0.687     5.144     0.200
     0.730     4.785     0.200
     0.743     5.122     0.200
     0.753     5.025     0.200
     0.757     4.874     0.200
     0.784     5.988     0.200
     0.830     6.153     0.200
     0.824     6.696     0.200
     0.850     6.109     0.200
     0.921     6.474     0.200
     0.936     6.318     0.200
     0.946     6.507     0.200
     1.049     7.566     0.200
     1.074     7.990     0.200
     1.094     8.107     0.200
     1.186     8.517     0.200
     1.533    10.947     0.200
     1.574    11.478     0.200
     1.602    11.556     0.200
     1.678    11.989     0.200
     1.697    11.590     0.200
     1.728    11.809     0.200
     1.759    12.317     0.200
     0.677     4.643     0.200
     2.111    14.901     0.200
     0.075     2.100     0.200
     0.098     1.667     0.200
     0.237     2.548     0.200
     0.262     2.317     0.200
     0.421     3.172     0.200
     0.466     3.362     0.200
     0.539     4.165     0.200
     0.554     4.104     0.200
     0.575     4.170     0.200
     0.613     4.715     0.200
     0.611     5.079     0.200
     0.646     4.955     0.200
     0.796     5.770     0.200
     1.000     7.539     0.200
     1.104     7.958     0.200
     1.472     9.521     0.200
     1.585    10.689     0.200
     1.665    11.561     0.200
     0.422     2.598     0.200
     1.694    12.686     0.200
     0.054     1.350     0.200
     0.280     2.454     0.200
     0.295     2.388     0.200
     0.387     3.255     0.200
     0.377     2.966     0.200
     0.513     3.437     0.200
     0.568     3.980     0.200
     0.622     4.535     0.200
     0.661     5.026     0.200
     0.772     6.149     0.200
     0.775     5.754     0.200
     0.964     7.188     0.200
     1.517    10.113     0.200
     1.541    10.545     0.200
     1.741    11.933     0.200
     1.934    13.317     0.200
     2.517    16.356     0.200
     0.038     2.649     0.200
     0.112     2.123     0.200
     0.133     2.234     0.200
     0.190     2.376     0.200
     0.207     2.363     0.200
     0.266     2.617     0.200
     0.281     2.850     0.200
     0.309     2.652     0.200
     0.354     3.107     0.200
     0.474     3.713     0.200
     0.501     4.134     0.200
     0.501     3.766     0.200
     0.611     4.953     0.200
     0.622     4.658     0.200
     0.650     4.574     0.200
     0.688     5.010     0.200
     0.700     5.361     0.200
     0.700     5.202     0.200
     0.741     5.431     0.200
     0.783     6.023     0.200
     0.841     6.127     0.200
     0.875     6.035     0.200
     1.002     7.208     0.200
     0.207     1.995     0.200
     0.201     1.883     0.200
     0.218     2.281     0.200
     0.249     2.228     0.200
     0.299     2.478     0.200
     0.333     2.259     0.200
     0.356     2.267     0.200
     0.415     2.611     0.200
     0.444     3.427     0.200
     0.725     4.742     0.200
     0.442     2.485     0.200
     1.545    11.994     0.200
     1.811    12.906     0.200
     2.019    13.114     0.200
     2.634    14.224     0.200
     0.302     2.586     0.200
     1.451     9.640     0.200
     1.526    10.992     0.200
     1.591    11.886     0.200
     1.956    12.474     0.200
     1.985    12.249     0.200
     1.994    12.180     0.200
     2.076    13.362     0.200
     2.234    13.407     0.200
     2.161    12.935     0.200
     2.317    12.154     0.200
     2.343    13.497     0.200
     2.396    13.274     0.200
     2.490    13.001     0.200
     2.568    14.343     0.200
     0.451     2.725     0.200
     1.523     9.920     0.200
     1.877    10.985     0.200
     0.039     0.698     0.200
     0.972     6.345     0.200
     1.651    13.010     0.200
     1.627    13.446     0.200
     1.948    13.103     0.200
     1.867    14.421     0.200
     2.031    12.515     0.200
     2.052    14.362     0.200
     2.341    13.765     0.200
     2.362    15.968     0.200
     2.401    15.148     0.200
     2.446    15.049     0.200
     2.555    15.772     0.200
     2.868    16.282     0.200
     2.848    17.094     0.200
     0.607     5.364     0.200
     0.763     4.256     0.200
     0.751     6.249     0.200
     1.489     9.610     0.200
     1.666    11.302     0.200
     1.885    11.924     0.200
     2.911    16.648     0.200
     0.715     4.559     0.200
     1.408    10.032     0.200
     2.835    14.826     0.200
     3.010    16.766     0.200
     0.596     5.164     0.200
     1.901    11.785     0.200
     2.434    14.276     0.200
     2.600    16.457     0.200
     2.698    15.678     0.200
     0.458     5.146     0.200
     0.436     2.692     0.200
     0.537     5.110     0.200
     0.787     5.523     0.200
     1.431    11.276     0.200
     1.878    13.776     0.200
     1.355     8.314     0.200
     1.446     8.761     0.200
     1.955    12.751     0.200
     2.440    13.168     0.200
     2.467    14.130     0.200
     2.529    14.130     0.200
     2.965    17.817     0.200
     3.478    18.466     0.200
     4.032    20.404     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     7.414    99.829     0.200
    10.567   143.033     0.200
    12.457   158.971     0.200
    13.032   170.264     0.200
    16.878   211.383     0.200
    21.488   282.589     0.200
     3.380    50.604     0.200
     6.965   101.761     0.200
     9.153   122.227     0.200
     9.820   133.448     0.200
    10.951   149.250     0.200
    12.090   157.961     0.200
    12.285   158.680     0.200
    12.945   171.976     0.200
    14.893   189.246     0.200
    21.126   281.502     0.200
     1.072    22.757     0.200
     2.581    42.138     0.200
     7.612   102.434     0.200
    13.095   164.448     0.200
     2.799    46.420     0.200
     5.535    80.491     0.200
     8.268   115.600     0.200
    10.128   139.891     0.200
    11.494   151.953     0.200
    12.258   161.036     0.200
    13.165   171.452     0.200
    14.116   180.359     0.200
     2.669    44.542     0.200
     6.146    85.960     0.200
     3.032    46.190     0.200
    11.910   159.082     0.200
    12.878   168.282     0.200
    14.398   183.544     0.200
    14.565   187.199     0.200
    18.538   244.231     0.200
    10.020   133.329     0.200
    12.154   161.433     0.200
    12.536   156.670     0.200
    12.806   165.520     0.200
     3.163    51.057     0.200
     4.600    69.684     0.200
     4.646    69.152     0.200
     4.851    71.151     0.200
     5.078    72.806     0.200
     9.092   123.562     0.200
    11.797   157.999     0.200
    12.083   161.354     0.200
    12.867   164.508     0.200
    12.888   165.964     0.200
    12.888   169.964     0.200
    13.464   176.239     0.200
     6.484    92.998     0.200
     6.524    90.824     0.200
     6.444    95.560     0.200
     6.733    95.789     0.200
    13.401   169.874     0.200
     2.843    43.052     0.200
     8.026   106.368     0.200
    11.305   144.093     0.200
    12.585   158.156     0.200
    13.278   172.072     0.200
    13.730   175.500     0.200
     0.959    21.488     0.200
     9.955   135.003     0.200
    12.281   159.057     0.200
    12.913   170.484     0.200
     4.684    68.087     0.200
     8.339   115.335     0.200
     8.572   117.006     0.200
    10.070   131.534     0.200
    10.108   132.691     0.200
    10.386   138.543     0.200
    10.680   140.016     0.200
    12.152   167.935     0.200
    12.136   168.122     0.200
    12.412   160.702     0.200
    12.421   160.796     0.200
    13.069   168.527     0.200
    13.136   174.751     0.200
    13.622   173.073     0.200
    14.163   180.765     0.200
    19.368   246.019     0.200
    20.762   274.756     0.200
     5.667    82.065     0.200
     7.031    99.746     0.200
    12.214   161.263     0.200
    13.024   170.310     0.200
     5.640    82.933     0.200
     7.006   100.605     0.200
    12.243   159.482     0.200
    13.018   165.940     0.200
    13.883   176.347     0.200
    14.738   192.867     0.200
     3.105    51.338     0.200
     5.110    74.937     0.200
     6.184    87.803     0.200
     6.353    92.427     0.200
     8.272   115.041     0.200
     8.677   120.310     0.200
     9.269   130.906     0.200
     9.687   129.521     0.200
    10.817   146.833     0.200
    10.982   147.406     0.200
    11.875   158.489     0.200
    12.407   159.582     0.200
    12.952   170.422     0.200
    13.803   174.783     0.200
    16.468   209.385     0.200
     2.530    40.536     0.200
     5.695    82.110     0.200
     7.046    98.043     0.200
    13.083   165.583     0.200
     2.500    42.498     0.200
     8.903   121.766     0.200
    10.353   143.846     0.200
    12.194   160.363     0.200
    12.853   163.674     0.200
    12.910   170.006     0.200
    13.008   165.867     0.200
    13.228   168.299     0.200
    13.888   175.698     0.200
     2.609    42.507     0.200
     6.337    88.998     0.200
     7.625   104.971     0.200
     8.326   113.787     0.200
    11.074   149.813     0.200
    11.651   153.485     0.200
    11.799   155.952     0.200
     2.940    45.008     0.200
     8.347   113.700     0.200
    12.301   161.957     0.200
    12.280   154.801     0.200
    12.508   162.247     0.200
    12.921   169.319     0.200
    13.103   173.200     0.200
    13.565   176.302     0.200
    20.695   271.603     0.200
     6.575    92.991     0.200
     6.982    99.252     0.200
    10.301   142.713     0.200
    11.820   158.788     0.200
    12.533   171.469     0.200
    12.517   171.657     0.200
    13.043   169.510     0.200
    13.109   173.739     0.200
    18.315   233.985     0.200
     2.509    43.085     0.200
     5.298    76.038     0.200
     6.504    91.970     0.200
    10.185   138.006     0.200
    13.350   169.778     0.200
     6.506    90.823     0.200
    10.842   144.228     0.200
    11.262   149.321     0.200
    11.670   153.562     0.200
    12.489   169.001     0.200
    12.473   169.189     0.200
    12.984   166.225     0.200
    12.997   169.271     0.200
    14.046   177.828     0.200
    14.823   200.265     0.200
     2.445    39.812     0.200
     5.264    77.421     0.200
     6.485    94.162     0.200
     6.889    97.458     0.200
     2.457    41.286     0.200
     5.593    81.786     0.200
    13.234   170.122     0.200
    13.995   179.232     0.200
    15.825   202.883     0.200
     6.315    88.920     0.200
     7.130    99.206     0.200
    11.868   156.911     0.200
     2.571    39.664     0.200
     5.658    80.134     0.200
     5.799    83.593     0.200
     9.204   121.752     0.200
    12.988   164.597     0.200
    13.193   168.207     0.200
     3.178    48.466     0.200
    10.320   140.619     0.200
    13.772   184.324     0.200
    15.008   205.910     0.200
    20.211   270.187     0.200
     3.684    60.944     0.200
     3.789    60.220     0.200
     3.902    62.102     0.200
     7.224    98.527     0.200
     8.544   114.929     0.200
    11.900   156.469     0.200
    12.805   164.396     0.200
     1.908    34.734     0.200
     3.352    55.679     0.200
     3.444    55.606     0.200
     3.567    57.773     0.200
     4.068    63.145     0.200
     4.486    68.842     0.200
     4.696    70.539     0.200
     5.329    79.370     0.200
     5.887    84.798     0.200
     5.928    85.216     0.200
     5.966    89.974     0.200
     6.137    89.326     0.200
     6.341    90.623     0.200
     7.506   101.616     0.200
     7.364   103.503     0.200
     8.018   112.548     0.200
     8.045   111.551     0.200
    12.371   159.634     0.200
    12.186   159.791     0.200
    12.984   167.784     0.200
     5.966    86.435     0.200
     5.966    89.685     0.200
     5.966    89.255     0.200
     5.966    87.669     0.200
     2.609    42.790     0.200
     3.342    52.745     0.200
     3.556    55.438     0.200
     4.078    60.725     0.200
     4.498    66.806     0.200
     4.706    68.859     0.200
     5.141    74.050     0.200
     5.340    77.491     0.200
     5.898    83.262     0.200
     5.940    83.777     0.200
     6.148    86.726     0.200
     6.353    89.295     0.200
     7.499   101.495     0.200
     7.375   101.082     0.200
     8.030   110.521     0.200
     8.058   110.419     0.200
     9.313   126.558     0.200
    12.198   156.389     0.200
    12.974   167.061     0.200
    13.125   166.072     0.200
    14.010   178.711     0.200
     2.240    39.963     0.200
     3.602    57.791     0.200
     5.052    75.236     0.200
     5.693    83.928     0.200
     6.251    88.746     0.200
     6.293    91.131     0.200
     7.728   105.883     0.200
    13.250   170.280     0.200
    13.556   172.399     0.200
     1.137    23.346     0.200
     2.575    42.865     0.200
     3.565    54.009     0.200
     5.029    71.382     0.200
     5.743    81.994     0.200
     6.079    88.779     0.200
     7.396    98.923     0.200
     7.396   100.650     0.200
     9.101   130.131     0.200
     9.208   129.908     0.200
     9.258   129.794     0.200
     9.322   131.496     0.200
     9.338   132.156     0.200
    10.006   139.966     0.200
    10.730   145.895     0.200
    12.087   156.066     0.200
    12.259   156.055     0.200
    12.931   171.215     0.200
    13.188   169.014     0.200
    14.884   200.425     0.200
    15.742   199.804     0.200
    17.595   231.786     0.200
     3.613    55.075     0.200
     3.729    60.730     0.200
     7.325    99.730     0.200
     3.511    58.365     0.200
     6.123    90.079     0.200
     8.475   119.546     0.200
     8.559   122.474     0.200
     9.189   132.079     0.200
     9.197   130.455     0.200
     9.213   130.799     0.200
     9.263   130.421     0.200
     9.291   129.574     0.200
     9.326   131.247     0.200
     9.341   130.298     0.200
     9.524   130.601     0.200
    11.208   149.169     0.200
    12.826   164.293     0.200
    13.853   176.367     0.200
    14.949   201.285     0.200
     1.135    25.220     0.200
     2.945    49.191     0.200
     3.709    61.181     0.200
    12.074   157.063     0.200
    12.838   166.636     0.200
    12.941   166.443     0.200
     2.972    48.885     0.200
     3.709    60.783     0.200
     6.108    89.977     0.200
     6.916    97.553     0.200
     8.574   124.205     0.200
     9.205   130.596     0.200
     9.271   131.234     0.200
     9.301   133.352     0.200
     9.335   132.050     0.200
     9.350   131.990     0.200
     9.502   129.569     0.200
    12.951   166.320     0.200
     6.108    89.563     0.200
     6.108    89.563     0.200
     6.108    89.563     0.200
     6.108    88.695     0.200
     1.184    24.316     0.200
     3.544    56.974     0.200
     3.091    52.556     0.200
     3.575    58.414     0.200
     1.153    23.892     0.200
     2.542    44.379     0.200
     3.173    52.517     0.200
     3.527    57.886     0.200
    12.041   152.529     0.200
     8.537   121.020     0.200
     8.552   120.213     0.200
     1.164    24.282     0.200
     1.137    25.497     0.200
     3.500    57.920     0.200
     3.632    58.881     0.200
     0.996    21.295     0.200
     1.147    23.609     0.200
     1.149    24.291     0.200
     3.624    56.617     0.200
     3.654    59.057     0.200
     3.739    60.464     0.200
    12.045   156.142     0.200
     1.104    23.023     0.200
     6.139    89.862     0.200
     7.327    99.197     0.200
     6.139    89.495     0.200
     1.103    23.681     0.200
     1.354    26.856     0.200
     3.449    53.699     0.200
     3.479    56.553     0.200
    13.113   167.130     0.200
     1.301    26.174     0.200
     5.828    85.741     0.200
     5.971    86.769     0.200
     9.300   127.752     0.200
     9.338   130.935     0.200
     9.320   128.190     0.200
    12.182   157.994     0.200
    12.979   165.689     0.200
     5.971    87.066     0.200
     5.971    88.253     0.200
     1.121    24.178     0.200
     1.174    25.562     0.200
     3.626    60.453     0.200
     3.710    61.263     0.200
     3.493    58.101     0.200
     3.595    56.514     0.200
     6.110    89.669     0.200
     8.541   122.784     0.200
     8.565   121.740     0.200
     8.580   120.403     0.200
     6.110    89.763     0.200
     6.110    88.872     0.200
     6.110    88.708     0.200
     3.614    56.194     0.200
     3.645    59.339     0.200
     3.731    61.530     0.200
     7.353    95.061     0.200
    12.855   165.852     0.200
    12.948   164.777     0.200
    12.958   164.656     0.200
    13.882   178.870     0.200
     1.109    24.612     0.200
     2.635    44.800     0.200
     3.540    59.234     0.200
     0.960    22.135     0.200
     3.560    58.807     0.200
     1.123    24.066     0.200
     1.061    23.791     0.200
     1.154    25.006     0.200
     2.478    43.258     0.200
     3.497    57.858     0.200
     1.262    25.738     0.200
     2.531    43.937     0.200
     3.626    59.660     0.200
    12.869   165.785     0.200
    12.997   165.296     0.200
     5.849    86.910     0.200
     9.255   130.687     0.200
     9.323   129.003     0.200
     9.356   133.368     0.200
     9.388   132.206     0.200
     9.403   131.502     0.200
     9.428   128.248     0.200
    12.869   164.785     0.200
     1.114    23.523     0.200
     3.583    57.511     0.200
     3.485    56.359     0.200
     3.698    59.564     0.200
     7.340    99.871     0.200
    12.835   165.742     0.200
    12.941   165.502     0.200
     3.931    60.781     0.200
     4.560    69.485     0.200
     5.212    75.824     0.200
     6.019    86.130     0.200
     6.591    93.091     0.200
     7.165    99.910     0.200
     7.906   108.978     0.200
     8.570   120.991     0.200
     9.347   129.279     0.200
     9.361   130.429     0.200
    12.835   165.844     0.200
    12.952   165.377     0.200
    13.864   175.736     0.200
     1.128    25.119     0.200
     1.194    24.351     0.200
     1.188    24.252     0.200
     3.746    60.801     0.200
     7.380    99.963     0.200
    12.969   164.165     0.200
     6.963    97.258     0.200
     7.380    99.963     0.200
     8.420   122.201     0.200
     8.494   122.426     0.200
     8.509   120.887     0.200
     9.208   129.165     0.200
     9.238   130.733     0.200
     9.287   128.503     0.200
    12.025   157.182     0.200
    12.979   164.047     0.200
     1.034    22.547     0.200
     1.154    23.838     0.200
     2.976    44.875     0.200
     3.739    57.971     0.200
    11.226   151.672     0.200
    12.840   163.113     0.200
    13.866   174.438     0.200
     3.522    56.602     0.200
     3.623    56.623     0.200
     3.739    58.471     0.200
     4.967    69.639     0.200
     5.171    75.697     0.200
     5.954    85.722     0.200
     6.549    92.632     0.200
     7.337    98.267     0.200
     7.864   108.529     0.200
     8.423   121.964     0.200
     8.550   123.308     0.200
     9.179   128.974     0.200
     9.308   131.631     0.200
     9.323   131.353     0.200
     9.521   127.489     0.200
     9.885   130.153     0.200
     9.998   138.215     0.200
    10.754   146.099     0.200
    12.840   163.089     0.200
    13.118   166.516     0.200
    13.866   175.954     0.200
     1.202    25.034     0.200
     1.188    24.992     0.200
     2.689    43.474     0.200
     3.618    57.532     0.200
     2.625    46.542     0.200
     3.559    60.342     0.200
     3.019    47.341     0.200
     3.953    60.991     0.200
     4.375    67.513     0.200
     5.818    83.792     0.200
     6.590    92.976     0.200
     7.253    99.484     0.200
     0.975    21.226     0.200
     1.464    30.366     0.200
     3.866    59.219     0.200
     3.764    60.845     0.200
     5.141    74.797     0.200
     5.742    82.973     0.200
     5.949    84.850     0.200
     6.163    89.139     0.200
     6.518    92.279     0.200
     7.176   100.963     0.200
     6.163    89.525     0.200
     6.163    89.525     0.200
     6.163    90.853     0.200
     6.163    88.084     0.200
     6.163    90.428     0.200
     1.144    25.058     0.200
     2.964    50.011     0.200
     1.137    25.982     0.200
     1.185    25.917     0.200
     2.628    45.583     0.200
     1.143    24.427     0.200
     1.211    26.936     0.200
     6.056    88.724     0.200
     6.056    88.724     0.200
     6.056    88.724     0.200
     6.056    88.724     0.200
     2.688    45.530     0.200
     3.595    56.137     0.200
     3.716    60.629     0.200
     3.917    61.295     0.200
     5.184    75.750     0.200
     5.784    84.586     0.200
     7.219   102.483     0.200
     7.875   109.484     0.200
     1.181    25.464     0.200
     1.067    22.033     0.200
     2.730    44.093     0.200
     3.715    58.604     0.200
     7.367    98.953     0.200
    11.240   147.811     0.200
    12.867   162.875     0.200
    13.894   177.726     0.200
     3.498    56.426     0.200
     3.597    54.872     0.200
     6.110    88.357     0.200
     6.114    89.742     0.200
     7.367    98.649     0.200
     9.247   130.740     0.200
     9.311   129.906     0.200
    10.226   142.418     0.200
    11.240   147.811     0.200
    12.061   155.702     0.200
    12.974   165.547     0.200
    13.151   169.577     0.200
    13.894   177.727     0.200
    21.198   278.069     0.200
     6.114    88.226     0.200
     6.114    88.320     0.200
     1.070    22.416     0.200
     1.149    23.629     0.200
     1.188    24.178     0.200
     2.635    45.090     0.200
     2.859    45.966     0.200
     3.596    54.873     0.200
     3.317    52.328     0.200
     7.370    99.657     0.200
    12.869   165.150     0.200
    13.897   175.579     0.200
     3.497    55.924     0.200
     3.713    59.299     0.200
     5.001    71.474     0.200
     6.113    89.577     0.200
     7.370   100.461     0.200
     7.182   101.122     0.200
     9.171   129.835     0.200
     9.180   129.094     0.200
     9.197   129.579     0.200
     9.247   127.700     0.200
     9.277   128.711     0.200
     9.311   128.592     0.200
     9.326   129.107     0.200
     9.485   129.145     0.200
    12.869   165.150     0.200
    13.154   169.126     0.200
     6.113    88.772     0.200
     6.113    88.498     0.200
     1.141    24.101     0.200
     1.143    24.783     0.200
     0.942    22.208     0.200
     1.220    25.647     0.200
     3.680    57.346     0.200
     7.348    96.513     0.200
     1.061    22.801     0.200
     2.755    44.905     0.200
     3.738    58.434     0.200
     5.747    84.458     0.200
     7.369    98.700     0.200
     8.767   118.146     0.200
    11.257   150.593     0.200
    12.036   155.594     0.200
    12.873   162.630     0.200
    13.899   177.082     0.200
     2.755    45.405     0.200
     3.072    49.943     0.200
     3.072    49.346     0.200
     3.003    50.006     0.200
     3.522    56.855     0.200
     4.323    64.746     0.200
     4.475    70.326     0.200
     4.998    71.733     0.200
     5.167    74.952     0.200
     5.747    84.457     0.200
     5.723    80.266     0.200
     5.768    82.617     0.200
     5.974    84.454     0.200
     5.963    84.569     0.200
     6.187    89.169     0.200
     6.133    88.086     0.200
     6.544    91.948     0.200
     7.369    97.259     0.200
     7.207   100.948     0.200
     7.860   107.227     0.200
     8.384   121.080     0.200
     8.397   120.936     0.200
     8.490   122.862     0.200
     8.525   122.872     0.200
     8.767   118.128     0.200
     9.069   129.330     0.200
     9.148   128.497     0.200
     9.157   129.672     0.200
     9.223   130.415     0.200
     9.253   132.217     0.200
     9.287   130.399     0.200
     9.302   130.985     0.200
     9.499   128.701     0.200
    11.198   148.542     0.200
    11.257   150.593     0.200
    12.971   165.684     0.200
    13.140   168.142     0.200
    13.899   175.852     0.200
     3.580    57.315     0.200
     3.301    54.268     0.200
     3.697    59.644     0.200
     7.374    97.167     0.200
    12.871   161.822     0.200
    13.165   167.634     0.200
     3.292    54.376     0.200
     3.481    56.067     0.200
     4.364    66.896     0.200
     4.435    71.038     0.200
     5.208    74.959     0.200
     5.764    82.115     0.200
     5.922    86.788     0.200
     6.016    84.481     0.200
     6.092    88.893     0.200
     6.585    94.212     0.200
     7.166   101.463     0.200
     7.901   107.555     0.200
     9.104   127.493     0.200
     9.183   128.519     0.200
     9.260   127.230     0.200
     9.291   131.528     0.200
     9.339   128.951     0.200
     9.474   128.734     0.200
    10.239   142.299     0.200
    12.871   164.630     0.200
    12.984   165.275     0.200
    13.165   167.634     0.200
     0.852    19.070     0.200
     1.164    23.926     0.200
     1.130    24.008     0.200
     7.382    99.451     0.200
     1.131    25.906     0.200
     1.190    24.517     0.200
     5.715    83.160     0.200
     7.358    98.444     0.200
     1.121    25.317     0.200
     1.170    24.743     0.200
     1.140    23.420     0.200
     1.140    24.623     0.200
     1.187    24.265     0.200
     1.144    26.143     0.200
     1.038    22.062     0.200
     1.214    24.546     0.200
     1.063    22.354     0.200
     1.129    23.924     0.200
     1.145    24.333     0.200
     1.191    24.296     0.200
     1.034    21.868     0.200
     1.244    26.209     0.200
     1.119    23.366     0.200
     0.969    20.192     0.200
     1.160    23.762     0.200
     2.374    34.900     0.200
     2.496    42.875     0.200
     2.771    45.874     0.200
     3.651    56.700     0.200
     3.766    60.963     0.200
     4.549    67.823     0.200
     4.745    74.529     0.200
     7.305    98.015     0.200
     8.726   118.289     0.200
    12.811   165.400     0.200
     2.771    44.573     0.200
     3.548    56.696     0.200
     5.954    85.068     0.200
     6.528    91.598     0.200
     7.305    97.867     0.200
     7.182    98.245     0.200
     7.231   100.918     0.200
     8.675   115.165     0.200
     9.168   128.839     0.200
     9.168   129.913     0.200
     9.176   129.089     0.200
     9.192   130.105     0.200
     9.240   128.394     0.200
     9.240   128.519     0.200
     9.304   130.365     0.200
     9.304   130.130     0.200
     9.318   130.325     0.200
     9.318   131.430     0.200
     9.557   128.371     0.200
     9.852   131.429     0.200
    12.811   164.341     0.200
    13.082   164.642     0.200
    13.025   175.908     0.200
    13.837   174.875     0.200
     1.058    22.030     0.200
     1.173    24.391     0.200
     3.612    58.125     0.200
     0.948    22.146     0.200
     1.118    23.452     0.200
     3.672    57.739     0.200
     7.343    99.110     0.200
     1.148    23.518     0.200
     2.690    45.120     0.200
     2.734    45.115     0.200
     4.698    74.692     0.200
     5.725    82.712     0.200
     7.358    98.291     0.200
    12.859   163.097     0.200
    13.886   175.896     0.200
     3.503    56.735     0.200
     3.603    58.074     0.200
     3.720    57.908     0.200
     4.343    66.103     0.200
     4.539    68.833     0.200
     4.457    68.005     0.200
     4.989    71.791     0.200
     5.188    74.446     0.200
     5.725    82.711     0.200
     5.743    81.167     0.200
     5.789    82.492     0.200
     5.995    85.570     0.200
     6.209    86.233     0.200
     6.565    92.472     0.200
     7.358    97.701     0.200
     7.222    98.883     0.200
     7.881   106.600     0.200
     8.389   118.853     0.200
     8.422   121.708     0.200
     8.454   118.940     0.200
     8.535   122.801     0.200
     8.550   122.251     0.200
     8.611   119.761     0.200
     8.950   126.765     0.200
     9.094   125.719     0.200
     9.199   130.202     0.200
     9.248   131.262     0.200
     9.278   130.956     0.200
     9.312   131.167     0.200
     9.327   131.196     0.200
     9.496   128.193     0.200
     9.906   131.190     0.200
    12.221   156.399     0.200
    13.886   174.545     0.200
     1.141    24.125     0.200
     1.133    23.542     0.200
     1.182    24.777     0.200
     1.105    23.828     0.200
     1.141    23.909     0.200
     1.129    23.168     0.200
     1.177    24.607     0.200
     1.145    24.200     0.200
     1.138    24.177     0.200
     1.186    24.420     0.200
     3.595    58.110     0.200
     1.039    22.539     0.200
     1.101    23.107     0.200
     1.170    24.512     0.200
     3.632    57.680     0.200
     1.504    31.112     0.200
     3.532    56.441     0.200
     4.314    64.592     0.200
     4.510    67.188     0.200
     5.760    83.377     0.200
     6.148    91.271     0.200
     6.537    91.116     0.200
     6.148    89.267     0.200
     6.148    89.267     0.200
     6.148    87.681     0.200
     1.133    23.930     0.200
     3.595    59.490     0.200
     3.644    57.777     0.200
     5.738    83.036     0.200
     1.156    25.363     0.200
     5.733    83.080     0.200
     1.163    25.615     0.200
     1.164    25.790     0.200
     2.677    44.638     0.200
     5.707    82.229     0.200
    12.020   157.499     0.200
    12.821   164.841     0.200
     1.527    28.753     0.200
     5.707    82.229     0.200
     5.953    83.405     0.200
     5.975    86.154     0.200
     6.170    86.032     0.200
     6.165    92.594     0.200
     6.526    91.418     0.200
     7.181    97.320     0.200
     7.232   101.687     0.200
     9.551   128.315     0.200
    12.176   157.688     0.200
    12.821   165.161     0.200
    12.821   164.840     0.200
    12.915   164.057     0.200
     6.165    88.969     0.200
     6.165    88.969     0.200
     1.136    24.313     0.200
     5.706    84.141     0.200
     3.604    57.705     0.200
     5.514    75.720     0.200
     5.706    84.140     0.200
     5.935    86.110     0.200
     6.119    91.127     0.200
     6.927    98.128     0.200
    12.838   164.242     0.200
     1.160    25.441     0.200
     5.697    82.292     0.200
     1.424    32.418     0.200
     2.581    42.919     0.200
    13.595   172.381     0.200
    13.757   174.490     0.200
     3.949    61.937     0.200
     4.142    65.082     0.200
     6.759    95.060     0.200
     7.153    94.039     0.200
    12.639   163.520     0.200
     1.213    28.385     0.200
     2.308    36.403     0.200
     2.564    42.962     0.200
     2.915    49.312     0.200
     2.965    50.548     0.200
     3.334    55.232     0.200
     3.580    58.552     0.200
     3.922    60.074     0.200
     5.465    80.304     0.200
     5.661    82.976     0.200
     6.065    88.562     0.200
     6.308    88.739     0.200
     6.865    96.522     0.200
     6.908    97.359     0.200
     7.116    99.097     0.200
     7.754   101.323     0.200
     7.680   107.053     0.200
     8.343   114.251     0.200
     8.709   120.706     0.200
     8.999   123.284     0.200
     9.025   122.657     0.200
     1.262    28.463     0.200
     2.651    45.185     0.200
     4.783    75.378     0.200
     7.400   101.591     0.200
     1.135    26.301     0.200
     1.488    31.580     0.200
     2.382    42.058     0.200
     2.468    43.531     0.200
     2.828    47.338     0.200
     2.828    49.267     0.200
     4.932    76.050     0.200
     6.388    93.428     0.200
     6.943    99.172     0.200
     6.989    99.192     0.200
     7.195   101.352     0.200
     7.764   108.347     0.200
     7.692   105.620     0.200
    12.948   167.856     0.200
    14.036   179.549     0.200
     1.070    24.906     0.200
     2.530    41.861     0.200
     2.612    42.910     0.200
     4.843    73.765     0.200
     4.848    72.314     0.200
     5.610    81.511     0.200
     5.810    84.981     0.200
     6.453    91.729     0.200
     7.011    97.682     0.200
     7.053    97.579     0.200
     7.261    98.764     0.200
     7.822   107.595     0.200
     7.848   101.184     0.200
     8.488   113.214     0.200
     8.585   116.506     0.200
     9.165   121.337     0.200
    13.305   170.123     0.200
     1.164    26.632     0.200
     1.500    31.000     0.200
     2.565    39.769     0.200
     2.565    42.769     0.200
     2.484    43.210     0.200
     4.605    68.738     0.200
     4.810    71.326     0.200
     5.448    78.239     0.200
     6.048    84.858     0.200
     6.256    87.771     0.200
     6.820    94.891     0.200
     7.510    97.950     0.200
     7.483   102.491     0.200
     8.138   110.622     0.200
     8.865   114.640     0.200
    12.307   157.572     0.200
    12.966   165.890     0.200
     3.191    53.953     0.200
     3.165    50.756     0.200
     3.402    56.293     0.200
     4.036    62.899     0.200
     4.591    69.414     0.200
     4.637    69.879     0.200
     4.843    72.980     0.200
     5.061    75.733     0.200
     5.416    80.092     0.200
     6.237    89.427     0.200
     6.723    93.861     0.200
     7.200    97.865     0.200
     7.264   104.974     0.200
     8.338   117.894     0.200
     9.199   126.645     0.200
    10.312   141.351     0.200
    12.380   159.519     0.200
    12.558   160.640     0.200
    12.863   166.081     0.200
     1.220    28.043     0.200
     2.793    46.638     0.200
     3.342    52.450     0.200
     3.684    59.536     0.200
     3.875    62.614     0.200
     4.266    69.450     0.200
     4.530    68.570     0.200
     5.083    75.311     0.200
     5.133    76.230     0.200
     5.336    77.958     0.200
     5.560    81.641     0.200
     5.920    84.937     0.200
     6.564    92.433     0.200
     7.161    96.648     0.200
     7.226   100.807     0.200
     7.272   101.165     0.200
    11.413   147.844     0.200
    11.996   155.219     0.200
    12.635   162.884     0.200
    12.641   162.716     0.200
    16.817   219.776     0.200
     1.239    30.916     0.200
     1.469    31.074     0.200
     2.394    41.044     0.200
     3.153    49.574     0.200
     3.537    53.468     0.200
     3.620    59.728     0.200
     5.032    76.768     0.200
    16.165   211.360     0.200
     2.277    39.094     0.200
     3.253    51.006     0.200
     3.409    52.352     0.200
     3.551    53.585     0.200
     4.635    68.263     0.200
     6.327    86.804     0.200
     6.783    93.034     0.200
     7.279    96.700     0.200
     8.125   113.349     0.200
     8.373   116.150     0.200
     9.126   128.919     0.200
     3.240    53.519     0.200
     4.220    63.208     0.200
     4.515    69.036     0.200
     5.070    75.864     0.200
     5.117    76.010     0.200
     5.322    78.020     0.200
     5.542    81.356     0.200
     5.897    85.916     0.200
     6.549    92.398     0.200
     6.597    94.242     0.200
     6.886    96.103     0.200
     7.205    98.153     0.200
     7.210   101.191     0.200
    11.393   148.468     0.200
    13.799   174.991     0.200
    14.999   202.287     0.200
     1.083    23.554     0.200
     1.867    32.310     0.200
     2.885    47.486     0.200
     3.310    50.080     0.200
     4.781    67.655     0.200
     7.265    96.565     0.200
    13.745   176.321     0.200
     1.118    22.561     0.200
     2.627    40.150     0.200
     2.798    46.207     0.200
     2.828    44.605     0.200
     3.028    50.277     0.200
     3.459    54.691     0.200
     4.465    67.404     0.200
     5.307    76.871     0.200
     5.793    83.731     0.200
     5.865    83.058     0.200
     5.907    84.677     0.200
     5.983    86.782     0.200
     6.115    86.945     0.200
     6.319    90.160     0.200
     6.678    93.477     0.200
     7.404    99.439     0.200
     7.499    98.958     0.200
     7.499   100.418     0.200
     7.997   109.585     0.200
     8.783   118.011     0.200
     9.330   126.429     0.200
    10.048   134.043     0.200
    12.165   154.848     0.200
    13.039   170.518     0.200
    13.119   166.707     0.200
    13.119   169.707     0.200
    14.014   178.164     0.200
    14.341   181.534     0.200
    15.589   197.619     0.200
    16.356   210.499     0.200
     1.055    22.550     0.200
     2.975    49.436     0.200
     3.403    55.439     0.200
     4.510    68.231     0.200
     4.713    71.155     0.200
     5.353    76.990     0.200
     5.737    81.810     0.200
     5.910    84.688     0.200
     5.953    84.386     0.200
     6.161    88.566     0.200
     6.368    90.943     0.200
     6.726    94.865     0.200
     7.019   100.754     0.200
     7.388   102.543     0.200
     8.044   110.689     0.200
     8.784   115.647     0.200
    12.215   154.914     0.200
    12.940   167.450     0.200
    13.098   166.605     0.200
     2.906    49.058     0.200
     3.183    52.270     0.200
     4.158    66.098     0.200
     7.116    98.826     0.200
     7.519   101.945     0.200
    11.095   146.173     0.200
     3.352    51.851     0.200
     4.053    64.463     0.200
     4.595    69.748     0.200
     4.717    67.344     0.200
     5.162    76.623     0.200
     5.181    75.603     0.200
     5.401    78.644     0.200
     5.928    84.586     0.200
     6.510    93.392     0.200
     7.830   102.519     0.200
     7.803   110.808     0.200
     9.031   126.654     0.200
    11.384   145.116     0.200
    11.438   150.238     0.200
    13.165   167.035     0.200
    13.282   167.969     0.200
    14.374   195.024     0.200
    15.929   205.431     0.200
    16.171   207.791     0.200
     2.531    40.807     0.200
     2.943    49.215     0.200
     3.305    50.783     0.200
     3.358    54.582     0.200
     3.836    60.193     0.200
     7.492   101.329     0.200
    14.233   184.377     0.200
    14.233   184.354     0.200
    16.347   211.378     0.200
     1.375    25.856     0.200
     2.846    42.927     0.200
     2.884    47.047     0.200
     3.626    54.363     0.200
    14.247   181.532     0.200
    16.265   209.019     0.200
     3.177    52.362     0.200
     3.797    61.028     0.200
     4.387    67.040     0.200
     4.556    68.012     0.200
     4.950    74.873     0.200
     4.983    74.393     0.200
     5.195    77.009     0.200
     5.386    78.383     0.200
     7.503   102.698     0.200
     7.984   111.069     0.200
     8.292   110.173     0.200
     8.963   121.956     0.200
     9.378   127.799     0.200
    12.812   162.718     0.200
    12.931   165.038     0.200
    13.127   168.773     0.200
    14.109   180.190     0.200
    15.005   190.295     0.200
    16.537   211.589     0.200
     3.082    49.146     0.200
     6.857    92.712     0.200
     7.577    99.978     0.200
    10.928   143.373     0.200
    11.656   151.196     0.200
    12.225   155.229     0.200
    13.482   171.658     0.200
    15.663   199.899     0.200
     3.228    51.006     0.200
     3.187    50.982     0.200
     3.475    53.517     0.200
     3.837    59.993     0.200
     4.390    66.047     0.200
     4.441    66.651     0.200
     4.651    69.894     0.200
     4.605    67.223     0.200
     4.643    69.188     0.200
     4.643    69.489     0.200
     4.873    71.909     0.200
     4.873    72.110     0.200
     5.225    76.100     0.200
     7.088    95.774     0.200
     7.488    99.028     0.200
     7.659   101.023     0.200
     7.659   103.193     0.200
     7.659   104.344     0.200
     7.659   104.732     0.200
     8.327   119.073     0.200
     8.544   116.468     0.200
     9.074   124.684     0.200
    10.726   136.999     0.200
    12.399   159.474     0.200
    12.772   162.121     0.200
    13.720   173.958     0.200
    15.137   204.831     0.200
    15.511   197.967     0.200
     1.352    31.786     0.200
     1.614    32.415     0.200
     1.614    33.317     0.200
     2.613    45.035     0.200
     3.571    55.804     0.200
     3.571    57.163     0.200
     3.571    57.452     0.200
     2.467    41.654     0.200
     2.489    43.734     0.200
     3.661    56.898     0.200
     5.426    81.019     0.200
     5.550    78.360     0.200
     6.071    86.889     0.200
     6.301    91.414     0.200
     6.628    93.789     0.200
     6.671    94.389     0.200
     6.879    96.666     0.200
     7.085    99.066     0.200
     7.678   103.696     0.200
     9.308   122.575     0.200
    13.753   175.572     0.200
    16.149   207.300     0.200
    16.149   207.031     0.200
     2.819    46.098     0.200
     2.990    49.043     0.200
     3.362    52.223     0.200
     3.858    60.673     0.200
     4.283    68.014     0.200
     4.510    67.764     0.200
     4.401    68.330     0.200
     5.064    75.102     0.200
     5.113    76.030     0.200
     5.316    77.753     0.200
     5.539    81.055     0.200
     5.893    84.921     0.200
     5.945    82.819     0.200
     9.649   134.981     0.200
    11.391   147.062     0.200
    12.009   154.847     0.200
     1.029    20.620     0.200
     2.519    40.724     0.200
     2.921    47.769     0.200
     3.351    52.105     0.200
     3.566    54.204     0.200
     3.844    56.093     0.200
     4.692    68.062     0.200
     5.052    71.170     0.200
     5.340    76.902     0.200
     5.685    81.465     0.200
     5.941    84.689     0.200
     6.717    94.240     0.200
     9.383   121.028     0.200
    11.181   143.873     0.200
    12.733   162.165     0.200
    12.880   161.313     0.200
    13.258   166.388     0.200
    14.375   180.200     0.200
    16.442   207.019     0.200
    19.040   244.723     0.200
    21.292   279.141     0.200
     0.879    22.405     0.200
     2.042    34.228     0.200
     3.232    48.451     0.200
     4.162    64.090     0.200
     4.916    73.797     0.200
     4.947    73.837     0.200
     5.708    82.949     0.200
     7.540    99.957     0.200
     8.122   107.241     0.200
     9.326   127.624     0.200
     9.326   128.624     0.200
     9.872   133.454     0.200
    11.186   143.120     0.200
    11.910   152.219     0.200
    12.359   156.038     0.200
    12.820   163.036     0.200
    12.957   166.461     0.200
    14.662   199.564     0.200
    16.514   213.247     0.200
     2.056    36.276     0.200
     2.926    48.749     0.200
     2.926    49.233     0.200
     3.419    52.935     0.200
     3.762    60.471     0.200
     4.074    58.154     0.200
     4.342    66.899     0.200
     4.906    74.820     0.200
     4.936    73.568     0.200
     5.141    73.780     0.200
     5.150    77.376     0.200
     5.336    78.299     0.200
     5.697    83.492     0.200
     7.548    99.970     0.200
     8.116   108.701     0.200
     8.761   126.510     0.200
     9.312   127.200     0.200
    12.366   159.163     0.200
    13.178   169.981     0.200
    16.509   211.682     0.200
     2.855    46.136     0.200
     3.018    46.313     0.200
     3.169    49.642     0.200
     3.314    51.416     0.200
     3.694    58.881     0.200
     4.238    64.028     0.200
     4.356    65.850     0.200
     4.448    67.173     0.200
     4.907    72.716     0.200
     4.960    73.304     0.200
     5.162    75.850     0.200
     5.391    79.068     0.200
     5.744    82.855     0.200
     5.957    83.229     0.200
     6.725    92.248     0.200
     7.087    95.249     0.200
     7.952   108.117     0.200
     8.030   113.380     0.200
     8.297   121.913     0.200
     9.606   127.729     0.200
    11.911   153.079     0.200
    12.530   159.357     0.200
    12.713   162.730     0.200
    13.692   172.834     0.200
     2.617    43.190     0.200
     3.188    48.057     0.200
     3.220    50.187     0.200
     3.361    54.040     0.200
     4.570    64.342     0.200
     4.906    71.116     0.200
     7.192    94.522     0.200
     7.300   102.071     0.200
     8.379   112.488     0.200
     9.166   127.602     0.200
    10.873   139.877     0.200
     2.885    46.414     0.200
     3.356    49.840     0.200
     3.706    59.101     0.200
     4.268    60.647     0.200
     4.361    66.356     0.200
     4.435    64.393     0.200
     4.914    72.906     0.200
     4.964    73.020     0.200
     5.167    75.949     0.200
     5.393    78.016     0.200
     5.746    82.790     0.200
     5.992    81.445     0.200
     6.767    93.492     0.200
     7.131    95.200     0.200
     7.750   108.703     0.200
     7.974   109.155     0.200
     8.340   123.166     0.200
    13.454   179.275     0.200
     2.444    40.041     0.200
     2.659    43.969     0.200
     2.890    47.510     0.200
     3.191    48.546     0.200
     3.755    55.850     0.200
     0.958    21.292     0.200
     2.412    39.170     0.200
     2.628    43.343     0.200
     2.857    46.165     0.200
     4.278    64.900     0.200
     5.451    77.300     0.200
     5.624    83.585     0.200
     6.879    96.148     0.200
     7.073    98.784     0.200
     7.295   101.693     0.200
     7.652   105.619     0.200
     8.557   117.861     0.200
     8.771   119.757     0.200
     9.422   120.481     0.200
     9.817   124.891     0.200
    10.243   131.891     0.200
    10.820   138.839     0.200
    11.209   151.632     0.200
    12.974   164.434     0.200
    13.453   172.329     0.200
    13.629   173.261     0.200
    14.057   178.572     0.200
    14.880   199.067     0.200
    16.148   205.639     0.200
    16.148   205.578     0.200
    16.148   208.867     0.200
    21.919   287.126     0.200
     1.121    23.880     0.200
     1.504    31.355     0.200
     2.621    44.783     0.200
     2.852    49.102     0.200
     5.413    77.216     0.200
     5.977    87.212     0.200
     1.255    26.408     0.200
     3.497    56.215     0.200
     3.848    60.162     0.200
    16.388   214.383     0.200
     2.754    46.588     0.200
     3.259    52.754     0.200
     3.302    49.822     0.200
     3.580    57.940     0.200
     3.881    61.338     0.200
     4.135    63.072     0.200
     4.543    67.917     0.200
     5.095    74.278     0.200
     5.336    77.762     0.200
     5.348    77.713     0.200
     5.576    79.860     0.200
     5.929    84.340     0.200
     6.575    91.694     0.200
     7.123    95.217     0.200
     7.239    99.852     0.200
     7.288    99.573     0.200
     8.321   121.141     0.200
    12.608   162.598     0.200
     2.716    46.155     0.200
     2.844    45.925     0.200
     3.015    47.038     0.200
     3.176    50.086     0.200
     3.670    53.644     0.200
     3.849    59.393     0.200
     4.225    62.322     0.200
     4.498    67.129     0.200
     5.052    72.962     0.200
     5.100    73.203     0.200
     5.292    76.964     0.200
     5.304    76.016     0.200
     5.525    78.943     0.200
     5.880    83.202     0.200
     5.970    82.843     0.200
     6.532    91.494     0.200
     7.196    97.488     0.200
     7.192    99.483     0.200
     7.236    99.976     0.200
     7.880   111.661     0.200
    12.667   164.790     0.200
     2.871    47.338     0.200
     3.460    53.602     0.200
     4.506    66.482     0.200
     5.262    79.624     0.200
     6.406    90.474     0.200
     6.785    93.346     0.200
     7.080    99.602     0.200
     7.432   100.706     0.200
     7.998   110.185     0.200
     8.099   109.017     0.200
     9.397   128.664     0.200
    10.488   144.622     0.200
    11.801   152.637     0.200
    12.750   162.890     0.200
    12.855   165.692     0.200
    13.058   166.434     0.200
    13.474   182.028     0.200
    14.769   198.171     0.200
    15.055   193.473     0.200
    16.607   215.330     0.200
    16.607   215.241     0.200
    18.400   240.796     0.200
     1.159    29.958     0.200
     1.564    31.874     0.200
     3.571    53.642     0.200
     3.754    56.975     0.200
    11.992   162.959     0.200
    16.095   208.884     0.200
     3.206    53.932     0.200
     3.405    56.004     0.200
     4.052    62.960     0.200
     4.605    70.000     0.200
     4.858    73.948     0.200
     5.436    79.701     0.200
     6.085    87.431     0.200
     8.327   114.671     0.200
     8.361   123.667     0.200
    12.795   166.521     0.200
     2.646    45.118     0.200
     2.627    44.762     0.200
     2.983    48.274     0.200
     3.228    50.456     0.200
     3.228    52.456     0.200
     3.474    54.899     0.200
     3.779    59.258     0.200
     3.796    59.208     0.200
     3.970    62.269     0.200
     4.290    65.438     0.200
     4.664    68.568     0.200
     5.193    76.405     0.200
     5.247    76.471     0.200
     5.435    78.775     0.200
     5.448    79.230     0.200
     5.680    81.617     0.200
     6.032    85.607     0.200
     6.674    94.014     0.200
     6.808    93.765     0.200
     7.340   101.843     0.200
     7.394   101.819     0.200
     7.750   107.563     0.200
     8.264   121.872     0.200
    12.583   161.159     0.200
    13.337   175.581     0.200
    15.061   191.622     0.200
    15.061   192.204     0.200
    16.874   216.470     0.200
    16.874   216.863     0.200
    20.627   274.685     0.200
     4.251    62.246     0.200
     7.156    95.576     0.200
     7.788   106.048     0.200
     8.237   115.020     0.200
     9.314   129.269     0.200
     2.724    46.332     0.200
     3.156    50.496     0.200
     3.359    52.255     0.200
     3.652    55.101     0.200
     3.836    60.199     0.200
     3.908    60.374     0.200
     4.208    60.750     0.200
     5.042    74.321     0.200
     5.091    75.348     0.200
     5.283    77.516     0.200
     5.295    78.268     0.200
     5.295    77.369     0.200
     5.872    85.235     0.200
     6.522    92.649     0.200
     7.167    96.064     0.200
     7.184   100.125     0.200
     7.230   100.689     0.200
     7.891   111.078     0.200
     8.101   108.316     0.200
     8.369   121.984     0.200
    11.371   146.470     0.200
    12.617   159.414     0.200
    13.347   175.267     0.200
    16.821   218.685     0.200
     1.278    25.382     0.200
     1.924    32.414     0.200
     2.127    33.534     0.200
     2.348    37.947     0.200
     3.113    46.962     0.200
     6.466    91.101     0.200
    10.430   141.914     0.200
    11.516   151.943     0.200
    12.657   167.422     0.200
    12.861   165.048     0.200
    12.862   165.957     0.200
    12.876   166.176     0.200
    12.999   172.753     0.200
    13.748   175.114     0.200
    15.349   194.161     0.200
    16.565   210.234     0.200
     0.912    18.773     0.200
     2.080    34.005     0.200
     2.591    42.040     0.200
     3.038    47.664     0.200
     3.611    53.749     0.200
     5.428    78.936     0.200
     5.504    81.049     0.200
     6.070    86.636     0.200
     6.715    92.521     0.200
     7.272   100.110     0.200
     7.314   100.230     0.200
     7.510   103.542     0.200
     7.522   103.595     0.200
     7.959   106.053     0.200
     8.083   109.152     0.200
     8.120   111.718     0.200
     8.750   117.072     0.200
     9.425   124.194     0.200
     9.460   129.585     0.200
    10.582   137.782     0.200
    11.873   158.620     0.200
    12.030   156.695     0.200
    12.152   157.966     0.200
    13.220   167.344     0.200
    14.783   201.067     0.200
    15.900   203.129     0.200
    22.174   291.007     0.200
     3.475    56.882     0.200
     4.126    63.777     0.200
     4.270    66.973     0.200
     4.729    71.536     0.200
     4.920    72.814     0.200
     4.932    73.370     0.200
     5.159    76.421     0.200
     6.159    88.346     0.200
     6.822    96.712     0.200
     6.872    97.236     0.200
     8.339   120.087     0.200
     9.321   125.354     0.200
     9.321   129.261     0.200
    10.309   133.320     0.200
    12.597   157.789     0.200
    13.281   166.704     0.200
    13.765   172.024     0.200
    14.396   180.621     0.200
    15.123   189.570     0.200
    15.423   196.370     0.200
    16.973   219.890     0.200
    18.553   242.115     0.200
    20.582   272.133     0.200
     1.477    31.800     0.200
     3.018    49.588     0.200
     3.073    49.678     0.200
     3.390    53.520     0.200
     3.485    57.138     0.200
     4.140    65.399     0.200
     4.259    67.452     0.200
     4.400    66.167     0.200
     4.655    71.483     0.200
     4.692    72.153     0.200
     4.946    74.693     0.200
     5.174    77.932     0.200
     6.173    89.073     0.200
     6.836    97.231     0.200
     6.887    97.939     0.200
     8.323   122.388     0.200
    10.310   138.489     0.200
    16.983   220.197     0.200
     3.270    49.960     0.200
     3.404    51.146     0.200
     3.464    55.008     0.200
     3.849    56.416     0.200
     4.117    60.491     0.200
     4.281    63.395     0.200
     4.422    63.153     0.200
     4.669    67.542     0.200
     4.720    67.850     0.200
     6.150    83.663     0.200
     6.813    92.721     0.200
     7.108    92.952     0.200
     8.332   119.699     0.200
     9.315   126.019     0.200
    15.098   201.638     0.200
    20.581   269.043     0.200
     1.367    28.554     0.200
     2.437    39.931     0.200
     2.526    42.013     0.200
     3.217    48.584     0.200
     3.557    54.953     0.200
     3.898    57.190     0.200
     4.022    63.255     0.200
     4.869    71.770     0.200
     5.661    82.422     0.200
     5.674    81.875     0.200
     6.901    97.160     0.200
     7.109    94.977     0.200
     7.566   105.393     0.200
     7.618   107.087     0.200
    16.794   213.131     0.200
     0.958    20.900     0.200
     2.497    40.102     0.200
     2.905    47.581     0.200
     3.326    52.578     0.200
     3.810    57.890     0.200
     4.156    65.215     0.200
     4.786    71.970     0.200
     5.434    79.207     0.200
     5.989    85.521     0.200
     6.035    86.495     0.200
     6.228    88.934     0.200
     7.468   103.363     0.200
     8.126   111.587     0.200
     8.160   111.793     0.200
    12.627   165.856     0.200
    16.407   211.062     0.200
     3.109    49.333     0.200
     3.133    51.535     0.200
     3.397    53.459     0.200
     3.523    55.743     0.200
     3.523    56.743     0.200
     3.785    59.117     0.200
     4.045    61.461     0.200
     4.337    66.077     0.200
     4.393    66.026     0.200
     4.389    65.672     0.200
     4.630    69.155     0.200
     4.612    70.068     0.200
     5.818    82.697     0.200
     6.482    89.842     0.200
     6.537    91.608     0.200
     7.071    94.715     0.200
     7.434    99.740     0.200
    10.578   138.241     0.200
    10.676   137.752     0.200
    10.852   141.030     0.200
    10.923   140.546     0.200
    11.518   150.077     0.200
    12.129   153.126     0.200
    12.367   156.957     0.200
    12.369   156.278     0.200
    12.394   157.722     0.200
    12.760   161.984     0.200
    13.495   181.803     0.200
    13.517   181.376     0.200
    13.786   185.445     0.200
    13.884   182.175     0.200
    13.909   188.047     0.200
    15.164   197.642     0.200
    15.159   202.188     0.200
    15.494   195.897     0.200
    20.025   265.495     0.200
     2.903    48.927     0.200
     3.151    50.760     0.200
     4.033    60.637     0.200
     4.012    61.798     0.200
     4.156    65.239     0.200
     4.584    67.168     0.200
     4.951    73.459     0.200
     5.151    75.916     0.200
     5.353    78.361     0.200
     7.512   101.703     0.200
     7.794   107.773     0.200
     8.115   107.705     0.200
     9.344   128.992     0.200
     9.344   128.594     0.200
    11.194   144.600     0.200
    11.432   149.459     0.200
    11.471   150.268     0.200
    12.201   158.410     0.200
    12.655   160.874     0.200
    12.757   162.456     0.200
    12.930   164.671     0.200
    12.931   164.465     0.200
    13.036   165.498     0.200
    13.140   167.388     0.200
    13.026   173.731     0.200
    13.195   176.970     0.200
    13.195   173.298     0.200
    13.341   182.046     0.200
    13.716   175.349     0.200
    13.717   179.627     0.200
    14.390   184.791     0.200
    16.489   210.124     0.200
    16.538   215.371     0.200
    18.319   239.658     0.200
    20.346   271.970     0.200
    20.433   272.275     0.200
     3.223    52.178     0.200
     3.586    56.838     0.200
     1.112    22.778     0.200
     2.613    40.931     0.200
     2.868    46.946     0.200
     3.200    53.079     0.200
     3.597    55.838     0.200
     4.036    61.715     0.200
     4.664    69.187     0.200
     5.300    76.871     0.200
     5.858    83.561     0.200
     5.900    84.072     0.200
     6.095    86.891     0.200
     7.071    99.905     0.200
     7.335   101.321     0.200
     7.480    97.889     0.200
     9.535   130.252     0.200
    10.284   140.801     0.200
    11.612   149.647     0.200
    12.659   167.157     0.200
    12.659   165.547     0.200
    12.676   160.018     0.200
    12.692   164.703     0.200
    12.748   167.369     0.200
    12.815   173.870     0.200
    13.100   166.541     0.200
    13.415   169.599     0.200
    13.940   174.633     0.200
    14.357   184.825     0.200
    14.357   185.276     0.200
    16.353   208.190     0.200
    16.357   208.033     0.200
    16.375   211.326     0.200
    16.375   207.519     0.200
    16.375   209.019     0.200
    16.375   209.019     0.200
    18.946   246.915     0.200
    21.008   278.155     0.200
     1.154    25.374     0.200
     3.184    50.649     0.200
     3.362    54.299     0.200
     5.584    79.674     0.200
     6.612    90.728     0.200
     0.961    21.191     0.200
     5.009    73.548     0.200
     5.639    81.094     0.200
     6.086    89.478     0.200
     7.082    98.748     0.200
     7.660   105.816     0.200
     7.737   104.710     0.200
     7.922   107.666     0.200
     8.322   112.379     0.200
     8.730   119.723     0.200
     8.978   121.725     0.200
     9.005   122.308     0.200
     9.840   128.394     0.200
     9.821   135.548     0.200
    11.991   155.584     0.200
    12.028   159.051     0.200
    12.168   162.895     0.200
    12.200   164.066     0.200
    12.371   164.757     0.200
    12.384   165.282     0.200
    13.495   177.622     0.200
    13.497   173.851     0.200
    13.970   177.607     0.200
    13.998   178.435     0.200
    14.383   183.552     0.200
    14.815   190.721     0.200
    15.456   203.049     0.200
    16.071   210.317     0.200
    16.102   210.089     0.200
    16.102   208.690     0.200
    16.102   208.690     0.200
    17.996   239.811     0.200
    19.484   257.922     0.200
    19.473   254.682     0.200
     1.115    24.138     0.200
     2.755    45.896     0.200
     3.180    48.633     0.200
     3.203    52.139     0.200
     3.380    54.404     0.200
     3.474    54.787     0.200
     4.013    60.714     0.200
     4.370    64.199     0.200
     4.569    67.127     0.200
     4.562    66.925     0.200
     4.614    66.993     0.200
     4.807    69.942     0.200
     5.038    72.847     0.200
     6.047    84.370     0.200
     6.707    92.977     0.200
     7.198    96.325     0.200
     8.428   119.831     0.200
    10.329   136.001     0.200
    12.365   159.520     0.200
    12.551   158.168     0.200
    12.664   165.033     0.200
    12.864   163.372     0.200
    16.934   216.858     0.200
    20.009   266.539     0.200
    20.204   268.964     0.200
    20.442   270.690     0.200
     1.076    22.945     0.200
     2.430    38.660     0.200
     4.882    70.449     0.200
     5.146    73.644     0.200
     5.512    79.197     0.200
     6.719    94.016     0.200
     6.763    94.301     0.200
     7.674   101.200     0.200
     8.854   118.501     0.200
     8.883   119.466     0.200
     9.715   126.025     0.200
     9.929   135.391     0.200
    10.884   139.652     0.200
    11.024   149.766     0.200
    11.093   149.693     0.200
    11.798   149.720     0.200
    12.125   160.743     0.200
    12.125   159.852     0.200
    12.219   155.817     0.200
    12.438   162.934     0.200
    12.438   163.469     0.200
    12.490   162.068     0.200
    12.983   164.917     0.200
    13.023   169.675     0.200
    13.023   164.648     0.200
    13.704   174.413     0.200
    16.158   209.025     0.200
    16.158   210.536     0.200
    16.158   210.533     0.200
    16.158   209.478     0.200
     0.957    19.896     0.200
     5.005    73.189     0.200
     5.635    80.733     0.200
     7.081    98.062     0.200
     7.093    98.216     0.200
     7.659   104.914     0.200
     7.907   106.098     0.200
     8.321   112.591     0.200
     8.549   117.040     0.200
     8.745   115.835     0.200
     8.977   121.032     0.200
     9.834   134.532     0.200
    10.336   138.578     0.200
    12.132   159.721     0.200
    12.225   161.995     0.200
    12.389   164.620     0.200
    13.146   166.445     0.200
    16.120   206.551     0.200
    16.120   206.551     0.200
     0.802    17.590     0.200
     2.459    40.406     0.200
     2.606    43.467     0.200
     3.276    48.332     0.200
     3.735    55.261     0.200
     4.397    66.292     0.200
     5.026    75.547     0.200
     6.469    92.112     0.200
     6.481    92.261     0.200
     6.700    95.913     0.200
     7.049    97.843     0.200
     7.709   105.343     0.200
     7.941   107.860     0.200
    16.314   210.479     0.200
     1.005    22.035     0.200
     2.590    43.915     0.200
     2.886    48.178     0.200
     3.740    58.423     0.200
     3.794    59.375     0.200
     4.258    65.163     0.200
     4.637    69.441     0.200
     5.195    76.729     0.200
     5.237    77.443     0.200
     5.432    79.962     0.200
     5.445    79.816     0.200
     5.652    83.094     0.200
     6.010    86.623     0.200
     6.672    93.392     0.200
     7.327   102.346     0.200
     7.359   103.774     0.200
     4.113    61.273     0.200
     7.589   100.176     0.200
     8.128   109.013     0.200
    11.120   145.579     0.200
    11.498   150.070     0.200
    11.541   149.396     0.200
    12.243   157.762     0.200
    12.729   161.383     0.200
    12.475   173.366     0.200
    13.000   168.698     0.200
    13.092   167.830     0.200
    13.547   175.504     0.200
    13.781   173.899     0.200
    14.265   181.036     0.200
    14.453   185.738     0.200
     3.297    55.200     0.200
     3.818    59.706     0.200
     3.812    60.983     0.200
     4.249    65.083     0.200
     4.447    67.970     0.200
     5.094    75.127     0.200
     5.649    82.143     0.200
     5.695    82.212     0.200
     5.888    85.550     0.200
     5.901    85.309     0.200
     6.115    87.111     0.200
     6.471    91.748     0.200
     7.128    98.985     0.200
     7.345    98.262     0.200
     7.787   107.302     0.200
     7.823   108.473     0.200
     8.695   114.121     0.200
     9.556   124.952     0.200
    10.138   137.758     0.200
    12.861   163.879     0.200
    12.861   164.230     0.200
    16.532   215.603     0.200
    21.135   279.322     0.200
     0.949    21.750     0.200
     0.949    21.524     0.200
     2.472    41.842     0.200
     4.141    62.304     0.200
     4.771    70.753     0.200
     5.423    78.850     0.200
     6.024    85.629     0.200
     6.217    88.376     0.200
     6.800    94.874     0.200
     7.404   100.668     0.200
     7.404    99.301     0.200
     7.457   102.811     0.200
     8.116   111.717     0.200
     8.152   112.300     0.200
     8.896   120.258     0.200
     8.998   118.920     0.200
    16.437   210.034     0.200
     6.901    95.775     0.200
     7.179    96.053     0.200
     8.233   110.314     0.200
    13.250   177.964     0.200
    16.775   216.735     0.200
     2.831    45.631     0.200
     3.165    48.534     0.200
     3.238    50.678     0.200
     4.082    60.934     0.200
     4.639    67.634     0.200
     4.877    70.756     0.200
     4.889    70.711     0.200
     5.459    78.061     0.200
     6.117    84.688     0.200
     6.813    93.757     0.200
     9.221   126.361     0.200
    10.753   143.234     0.200
    10.954   139.773     0.200
    20.042   263.183     0.200
    20.256   269.677     0.200
     2.409    40.628     0.200
     8.692   114.605     0.200
    16.123   206.466     0.200
     1.416    27.945     0.200
     1.507    29.442     0.200
     2.906    48.758     0.200
     3.321    53.599     0.200
     3.800    58.062     0.200
     4.206    65.092     0.200
     4.638    69.749     0.200
     4.836    72.448     0.200
     4.836    72.647     0.200
     4.836    72.749     0.200
     5.116    70.695     0.200
     5.483    80.000     0.200
     5.773    79.183     0.200
     6.039    86.807     0.200
     6.083    86.489     0.200
     6.083    87.188     0.200
     6.083    87.586     0.200
     6.277    89.624     0.200
     6.290    89.579     0.200
     6.501    92.318     0.200
     6.858    96.649     0.200
     7.425    98.971     0.200
     7.457    99.355     0.200
     7.517   104.551     0.200
     8.175   112.782     0.200
     8.175   112.981     0.200
     8.207   112.998     0.200
     9.067   121.523     0.200
    10.009   131.889     0.200
    12.348   159.898     0.200
    12.469   169.992     0.200
    12.586   169.906     0.200
    12.586   168.726     0.200
    12.666   172.871     0.200
    12.675   163.914     0.200
    12.904   164.643     0.200
    13.266   172.170     0.200
    13.469   183.788     0.200
    13.702   176.126     0.200
    14.216   183.103     0.200
    14.347   185.421     0.200
    14.875   199.584     0.200
    15.021   191.040     0.200
    16.686   224.307     0.200
    18.049   236.140     0.200
    19.098   250.902     0.200
    19.638   261.445     0.200
    19.645   261.457     0.200
    19.933   269.284     0.200
    20.197   269.300     0.200
    20.465   273.868     0.200
    20.587   274.355     0.200
    20.691   271.445     0.200
    20.798   271.905     0.200
    20.892   274.650     0.200
    21.000   274.829     0.200
    21.019   277.039     0.200
    21.038   278.623     0.200
    21.103   275.126     0.200
    21.216   276.531     0.200
    21.199   278.292     0.200
    21.252   277.717     0.200
    21.265   278.246     0.200
    21.446   279.728     0.200
    21.590   280.269     0.200
    22.149   288.481     0.200
     1.411    28.010     0.200
     2.548    42.702     0.200
     2.548    43.984     0.200
     3.441    57.125     0.200
     5.708    81.487     0.200
     7.453   101.013     0.200
    12.565   168.127     0.200
     1.214    25.423     0.200
     1.180    24.628     0.200
     1.358    27.438     0.200
     3.971    62.137     0.200
     1.032    21.564     0.200
     1.178    25.181     0.200
     1.383    28.589     0.200
     1.116    23.520     0.200
     1.144    24.080     0.200
     1.226    25.916     0.200
     1.272    26.383     0.200
     1.307    27.174     0.200
     1.309    26.836     0.200
     1.373    28.271     0.200
     0.984    21.446     0.200
     1.139    23.858     0.200
     1.156    24.155     0.200
     1.208    25.169     0.200
     1.277    26.718     0.200
     1.140    24.384     0.200
     1.154    24.029     0.200
     1.261    26.025     0.200
     1.308    27.203     0.200
     1.390    28.450     0.200
     1.427    29.706     0.200
     1.441    30.544     0.200
     1.469    30.589     0.200
     1.536    31.088     0.200
     0.976    21.218     0.200
     1.419    28.075     0.200
     1.511    29.403     0.200
     2.549    44.321     0.200
     2.960    49.353     0.200
     3.855    58.613     0.200
     4.198    63.143     0.200
     4.623    68.382     0.200
     4.826    72.207     0.200
     5.466    79.444     0.200
     5.709    84.236     0.200
     6.023    85.941     0.200
     6.066    87.041     0.200
     6.273    89.520     0.200
     6.838    96.526     0.200
     7.503   100.374     0.200
     7.501   103.594     0.200
     8.156   112.745     0.200
     8.186   112.705     0.200
     8.870   118.381     0.200
     8.870   119.158     0.200
     9.070   119.877     0.200
     9.266   122.192     0.200
    10.055   134.923     0.200
    12.559   168.414     0.200
    12.648   164.109     0.200
    13.234   171.223     0.200
    14.077   180.740     0.200
    14.188   181.493     0.200
    16.337   212.580     0.200
    18.021   238.722     0.200
    21.156   279.544     0.200
     1.432    29.644     0.200
     1.584    33.307     0.200
     1.226    26.071     0.200
     1.260    27.001     0.200
     1.082    23.487     0.200
     1.121    23.546     0.200
     1.233    25.854     0.200
     1.347    27.188     0.200
     1.393    28.417     0.200
     1.429    29.000     0.200
     1.419    29.045     0.200
     1.495    30.871     0.200
     2.505    43.506     0.200
     2.914    49.072     0.200
     3.457    56.160     0.200
     5.448    80.874     0.200
     5.666    83.162     0.200
     6.255    90.652     0.200
     6.466    93.193     0.200
     6.823    97.125     0.200
     7.482   104.629     0.200
     8.173   112.673     0.200
    10.002   133.179     0.200
    10.002   133.987     0.200
    12.608   167.782     0.200
    16.391   211.569     0.200
     1.076    23.090     0.200
     1.104    23.261     0.200
     1.109    23.561     0.200
     1.223    26.054     0.200
     1.331    27.556     0.200
     1.357    27.865     0.200
     1.414    29.180     0.200
     1.413    29.371     0.200
     1.480    30.228     0.200
     2.485    42.980     0.200
     3.314    53.570     0.200
     0.922    19.936     0.200
     1.070    22.269     0.200
     1.158    24.570     0.200
     1.218    25.724     0.200
     1.244    26.493     0.200
     1.249    26.644     0.200
     1.295    26.792     0.200
     1.492    29.526     0.200
     1.097    23.045     0.200
     1.120    23.236     0.200
     1.325    27.256     0.200
     1.058    22.656     0.200
     1.195    25.257     0.200
     1.383    28.488     0.200
     1.006    21.531     0.200
     0.936    20.646     0.200
     1.110    23.876     0.200
     1.094    23.176     0.200
     1.099    23.268     0.200
     1.177    24.402     0.200
     1.212    25.742     0.200
     1.232    25.330     0.200
     1.322    27.328     0.200
     1.370    28.175     0.200
     1.405    28.830     0.200
     1.402    29.469     0.200
     1.471    29.844     0.200
     1.148    24.334     0.200
     1.309    27.472     0.200
     0.991    21.369     0.200
     1.013    21.527     0.200
     1.099    23.177     0.200
     1.113    24.111     0.200
     1.267    26.284     0.200
     1.287    26.759     0.200
     1.288    26.884     0.200
     1.338    27.719     0.200
     1.407    28.514     0.200
     0.944    19.868     0.200
     1.003    21.029     0.200
     1.073    22.801     0.200
     1.194    24.945     0.200
     1.206    25.530     0.200
     1.405    28.785     0.200
     1.071    22.552     0.200
     1.120    23.088     0.200
     1.210    24.868     0.200
     0.878    18.763     0.200
     1.321    28.037     0.200
     1.470    30.929     0.200
     2.499    40.583     0.200
     2.585    41.630     0.200
     4.980    73.534     0.200
     5.310    73.434     0.200
     5.624    78.629     0.200
     5.823    83.696     0.200
     6.618    93.418     0.200
     6.630    93.771     0.200
     6.835    96.677     0.200
     7.194   100.895     0.200
     7.617   102.252     0.200
     7.858   107.545     0.200
     8.539   116.590     0.200
     9.000   119.214     0.200
     9.137   119.919     0.200
    10.171   132.495     0.200
    10.171   134.706     0.200
    12.307   163.338     0.200
     3.134    51.091     0.200
     5.418    80.955     0.200
    16.199   208.725     0.200
     1.379    28.811     0.200
     1.447    29.835     0.200
     1.179    25.152     0.200
     1.239    25.412     0.200
     1.275    26.561     0.200
     1.358    27.968     0.200
     1.519    30.869     0.200
     1.560    32.321     0.200
     1.334    28.115     0.200
     1.327    27.302     0.200
     1.544    32.037     0.200
     3.673    60.823     0.200
     4.187    67.041     0.200
     1.354    28.211     0.200
     1.421    29.437     0.200
     1.065    22.156     0.200
     1.112    23.581     0.200
     1.151    23.732     0.200
     1.230    25.296     0.200
     1.327    27.790     0.200
     1.344    27.412     0.200
     1.383    28.646     0.200
     1.424    29.115     0.200
     1.357    27.829     0.200
     1.355    27.886     0.200
     1.444    29.692     0.200
     1.461    29.573     0.200
     1.567    31.961     0.200
     1.610    32.822     0.200
     1.204    24.997     0.200
     1.211    25.199     0.200
     1.388    28.362     0.200
     1.116    23.527     0.200
     1.165    25.088     0.200
     1.217    25.397     0.200
     1.300    26.422     0.200
     1.365    28.252     0.200
     1.439    29.600     0.200
     1.561    31.814     0.200
     1.321    29.008     0.200
     2.390    42.391     0.200
     3.010    52.103     0.200
     3.191    52.602     0.200
     3.745    61.791     0.200
     1.216    25.092     0.200
     1.300    26.979     0.200
     1.079    22.738     0.200
     1.188    24.570     0.200
     1.243    25.181     0.200
     1.252    26.657     0.200
     1.274    26.632     0.200
     1.337    27.755     0.200
     1.497    31.427     0.200
     1.193    23.841     0.200
     1.462    28.448     0.200
     1.386    27.903     0.200
     1.457    29.379     0.200
     1.381    28.123     0.200
     1.513    31.301     0.200
     1.553    32.535     0.200
     1.565    32.403     0.200
     1.449    29.423     0.200
     1.519    31.138     0.200
     1.419    29.341     0.200
     1.539    31.185     0.200
     1.548    31.293     0.200
     1.664    34.216     0.200
     1.670    33.996     0.200
     0.868    18.722     0.200
     0.896    18.545     0.200
     1.130    22.465     0.200
     1.247    25.929     0.200
     1.419    28.862     0.200
     1.490    31.325     0.200
     1.100    24.114     0.200
     1.134    24.317     0.200
     1.230    25.474     0.200
     1.348    29.228     0.200
     1.414    30.302     0.200
     1.493    31.135     0.200
     1.617    33.181     0.200
     0.973    21.031     0.200
     1.008    21.434     0.200
     1.264    26.735     0.200
     1.194    24.873     0.200
     1.215    25.432     0.200
     1.353    27.044     0.200
     1.429    29.018     0.200
     1.329    27.555     0.200
     1.584    31.828     0.200
     1.651    33.304     0.200
     1.085    23.503     0.200
     1.093    23.225     0.200
     1.258    26.871     0.200
     1.264    25.687     0.200
     1.326    27.362     0.200
     1.094    22.452     0.200
     1.144    23.780     0.200
     1.239    25.441     0.200
     1.241    25.907     0.200
     1.272    25.539     0.200
     1.273    26.441     0.200
     1.354    27.489     0.200
     1.488    28.831     0.200
     0.908    21.306     0.200
     3.127    51.481     0.200
     7.666   103.418     0.200
     0.793    16.797     0.200
     0.804    17.669     0.200
     0.862    17.967     0.200
     0.914    18.877     0.200
     1.132    22.433     0.200
     1.152    22.422     0.200
     1.285    25.550     0.200
     1.263    23.998     0.200
     1.305    26.640     0.200
     1.358    27.674     0.200
     1.558    30.639     0.200
     1.551    31.244     0.200
     1.135    24.854     0.200
     1.277    27.150     0.200
     0.915    19.408     0.200
     1.034    21.296     0.200
     1.169    23.478     0.200
     1.363    27.737     0.200
     1.377    27.946     0.200
     1.438    28.594     0.200
     1.496    30.183     0.200
     1.576    31.282     0.200
     1.159    24.353     0.200
     1.305    27.389     0.200
     1.388    28.352     0.200
     1.453    29.038     0.200
     1.150    22.876     0.200
     1.235    23.663     0.200
     1.418    27.597     0.200
     1.115    23.472     0.200
     1.164    24.170     0.200
     1.168    24.659     0.200
     1.277    26.921     0.200
     1.360    28.192     0.200
     1.397    29.208     0.200
     1.400    29.085     0.200
     1.420    29.421     0.200
     1.440    29.698     0.200
     1.507    30.953     0.200
     1.141    23.511     0.200
     1.462    29.118     0.200
     1.512    30.048     0.200
     1.043    22.291     0.200
     1.134    24.100     0.200
     1.190    24.698     0.200
     1.213    25.083     0.200
     1.239    25.644     0.200
     1.322    27.148     0.200
     1.329    27.064     0.200
     1.386    28.360     0.200
     1.411    28.468     0.200
     1.437    29.100     0.200
     1.475    29.872     0.200
     1.137    24.494     0.200
     1.218    25.324     0.200
     1.307    26.715     0.200
     1.377    28.231     0.200
     1.098    23.174     0.200
     1.141    23.757     0.200
     1.126    23.387     0.200
     1.269    26.463     0.200
     1.320    26.675     0.200
     1.353    26.726     0.200
     1.448    28.904     0.200
     1.085    22.685     0.200
     1.442    29.319     0.200
     1.509    30.104     0.200
     1.163    24.085     0.200
     1.201    24.610     0.200
     1.236    25.469     0.200
     1.332    26.831     0.200
     1.491    29.995     0.200
     1.310    26.712     0.200
     1.337    26.969     0.200
     1.458    29.557     0.200
     1.530    31.222     0.200
     1.200    27.722     0.200
     2.395    42.077     0.200
     2.344    41.448     0.200
     2.464    42.705     0.200
     3.634    57.651     0.200
     5.441    81.473     0.200
     6.165    88.565     0.200
     1.241    25.697     0.200
     1.307    26.700     0.200
     1.342    27.429     0.200
     1.425    28.670     0.200
     1.587    31.660     0.200
     1.327    27.486     0.200
     1.353    27.733     0.200
     1.327    27.161     0.200
     1.345    27.405     0.200
     1.493    30.853     0.200
     1.530    30.929     0.200
     1.227    25.595     0.200
     1.465    30.333     0.200
     1.517    31.981     0.200
     1.602    33.097     0.200
     1.633    33.044     0.200
     1.287    26.985     0.200
     0.954    19.973     0.200
     1.118    22.368     0.200
     1.340    28.788     0.200
     1.372    29.120     0.200
     1.412    29.723     0.200
     1.444    30.929     0.200
     1.593    33.931     0.200
     1.601    34.107     0.200
     1.725    36.694     0.200
     1.586    33.224     0.200
     2.474    41.130     0.200
     2.545    45.824     0.200
     2.712    46.069     0.200
     2.888    48.543     0.200
     3.056    50.775     0.200
     3.735    58.897     0.200
     1.424    29.888     0.200
     1.542    31.180     0.200
     1.570    30.944     0.200
     0.978    25.110     0.200
     1.157    28.133     0.200
     2.667    46.214     0.200
     3.148    53.826     0.200
     1.275    26.401     0.200
     0.856    19.157     0.200
     0.978    21.092     0.200
     0.975    20.413     0.200
     0.998    21.251     0.200
     1.024    21.375     0.200
     1.020    21.715     0.200
     1.092    22.926     0.200
     1.083    22.522     0.200
     1.104    23.711     0.200
     1.160    24.179     0.200
     1.276    26.354     0.200
     1.378    27.982     0.200
     1.385    27.949     0.200
     1.004    21.357     0.200
     1.062    22.314     0.200
     1.064    23.815     0.200
     1.141    22.995     0.200
     1.127    23.430     0.200
     1.180    25.482     0.200
     1.194    24.633     0.200
     1.202    26.080     0.200
     1.284    26.195     0.200
     1.312    27.725     0.200
     1.335    28.410     0.200
     1.372    27.344     0.200
     1.368    28.757     0.200
     1.433    29.650     0.200
     1.286    29.688     0.200
     1.325    25.806     0.200
     1.416    27.695     0.200
     4.121    62.787     0.200
     4.244    67.813     0.200
     4.750    71.236     0.200
     4.750    71.439     0.200
     5.045    74.366     0.200
     5.403    77.919     0.200
     5.958    86.043     0.200
     6.004    85.204     0.200
     6.004    85.501     0.200
     6.004    85.603     0.200
     6.197    87.953     0.200
     6.424    91.099     0.200
     6.781    95.541     0.200
     7.437   103.178     0.200
     8.096   111.589     0.200
    12.673   170.540     0.200
     1.292    26.740     0.200
     1.320    26.734     0.200
     1.394    28.151     0.200
     1.537    30.379     0.200
     1.005    21.100     0.200
     1.085    22.484     0.200
     1.242    25.445     0.200
     1.318    27.099     0.200
     1.466    29.919     0.200
     1.131    23.487     0.200
     1.173    24.967     0.200
     1.462    29.933     0.200
     1.531    31.403     0.200
     1.590    32.600     0.200
     1.672    32.975     0.200
     1.719    34.844     0.200
     1.656    35.459     0.200
     2.327    41.927     0.200
     3.095    53.690     0.200
     0.919    20.689     0.200
     1.054    22.291     0.200
     1.307    26.941     0.200
     1.487    30.294     0.200
     1.514    31.115     0.200
     1.228    27.117     0.200
     1.606    31.926     0.200
     2.203    39.539     0.200
     2.284    40.825     0.200
     2.613    45.610     0.200
     2.785    47.615     0.200
     3.095    51.081     0.200
     5.370    81.134     0.200
     1.029    22.009     0.200
     1.204    25.121     0.200
     1.427    29.764     0.200
     1.214    25.883     0.200
     1.330    28.076     0.200
     1.375    29.200     0.200
     1.478    31.283     0.200
     1.347    28.230     0.200
     1.450    29.857     0.200
     1.495    30.746     0.200
     1.580    31.940     0.200
     1.646    32.925     0.200
     1.671    33.673     0.200
     1.419    28.637     0.200
     1.516    29.578     0.200
     1.540    31.937     0.200
     1.568    31.300     0.200
     0.909    19.723     0.200
     0.988    20.987     0.200
     1.142    24.062     0.200
     1.189    24.255     0.200
     1.225    25.478     0.200
     1.309    26.551     0.200
     1.355    26.829     0.200
     1.024    21.895     0.200
     1.104    23.487     0.200
     1.142    25.125     0.200
     1.166    24.568     0.200
     1.160    24.151     0.200
     1.239    25.998     0.200
     1.250    26.101     0.200
     1.286    27.581     0.200
     1.298    26.557     0.200
     1.335    28.228     0.200
     0.893    20.770     0.200
     1.083    22.979     0.200
     1.141    24.738     0.200
     1.196    25.123     0.200
     1.212    24.862     0.200
     1.252    26.251     0.200
     1.313    27.097     0.200
     1.446    30.342     0.200
     1.453    29.594     0.200
     1.529    30.808     0.200
     1.295    26.916     0.200
     1.535    31.443     0.200
     1.596    32.443     0.200
     0.921    20.278     0.200
     1.107    23.841     0.200
     1.219    25.584     0.200
     1.412    28.766     0.200
     1.420    28.122     0.200
     1.091    22.519     0.200
     1.184    24.357     0.200
     1.444    30.229     0.200
     1.341    27.479     0.200
     1.463    30.220     0.200
     1.488    29.888     0.200
     1.604    32.887     0.200
     1.162    24.778     0.200
     1.254    25.914     0.200
     1.345    27.453     0.200
     1.418    29.591     0.200
     1.421    29.201     0.200
     1.454    29.174     0.200
     1.532    31.449     0.200
     0.921    19.164     0.200
     0.977    19.941     0.200
     1.020    20.508     0.200
     1.249    24.703     0.200
     1.219    26.148     0.200
     1.491    30.919     0.200
     1.514    31.948     0.200
     0.826    18.307     0.200
     0.947    19.985     0.200
     0.991    20.968     0.200
     1.044    21.654     0.200
     1.070    21.690     0.200
     1.075    22.489     0.200
     1.118    23.113     0.200
     1.139    23.970     0.200
     1.216    25.023     0.200
     1.246    25.750     0.200
     1.336    27.586     0.200
     1.454    29.573     0.200
     1.450    29.457     0.200
     1.325    28.477     0.200
     3.339    54.031     0.200
     3.791    60.568     0.200
     1.189    25.517     0.200
     1.440    29.749     0.200
     1.560    31.707     0.200
     1.587    32.530     0.200
     1.449    30.391     0.200
     1.507    31.042     0.200
     0.925    20.064     0.200
     1.128    23.691     0.200
     1.146    24.256     0.200
     1.196    24.561     0.200
     1.217    25.569     0.200
     1.229    26.001     0.200
     1.365    28.282     0.200
     1.433    29.388     0.200
     1.403    27.552     0.200
     2.531    41.802     0.200
     3.409    55.552     0.200
     3.484    56.954     0.200
     1.098    22.757     0.200
     1.288    27.640     0.200
     1.451    29.358     0.200
     1.493    29.553     0.200
     1.298    26.994     0.200
     1.379    28.758     0.200
     1.418    29.805     0.200
     1.515    31.082     0.200
     1.573    32.327     0.200
     1.603    32.859     0.200
     0.974    20.980     0.200
     1.060    22.596     0.200
     1.083    22.497     0.200
     1.090    23.500     0.200
     1.249    26.583     0.200
     1.294    25.549     0.200
     1.414    28.966     0.200
     2.966    49.094     0.200
     2.977    49.580     0.200
     3.403    55.199     0.200
     3.525    56.076     0.200
     4.129    63.630     0.200
     4.370    65.611     0.200
     4.464    68.390     0.200
     4.758    67.482     0.200
     4.925    72.242     0.200
     4.973    72.782     0.200
     5.164    75.144     0.200
     5.177    74.997     0.200
     5.398    80.417     0.200
     5.915    82.281     0.200
     6.147    87.232     0.200
     6.404    89.774     0.200
     6.376    89.255     0.200
     6.847    93.983     0.200
     7.065    98.362     0.200
     7.182    97.081     0.200
     7.905   106.025     0.200
     8.002   109.384     0.200
     8.036   108.062     0.200
     8.738   117.314     0.200
     8.391   121.302     0.200
     9.701   130.479     0.200
    10.920   142.660     0.200
    11.250   147.425     0.200
    12.806   165.481     0.200
    16.839   218.127     0.200
     1.257    26.591     0.200
     1.337    28.780     0.200
     1.065    22.552     0.200
     1.081    23.652     0.200
     1.136    24.326     0.200
     1.207    26.011     0.200
     1.080    23.649     0.200
     1.271    27.474     0.200
     1.287    26.198     0.200
     1.295    28.668     0.200
     1.313    27.017     0.200
     1.380    28.894     0.200
     2.588    45.224     0.200
     3.068    52.013     0.200
     3.359    55.468     0.200
     3.524    55.921     0.200
     3.582    57.725     0.200
     1.154    24.100     0.200
     1.205    24.860     0.200
     1.219    25.280     0.200
     1.257    25.897     0.200
     1.297    27.046     0.200
     0.882    19.311     0.200
     1.045    21.639     0.200
     1.055    21.887     0.200
     1.110    22.807     0.200
     1.180    23.880     0.200
     1.416    28.954     0.200
     1.509    30.502     0.200
     1.072    22.611     0.200
     1.227    25.168     0.200
     1.264    26.194     0.200
     1.305    26.781     0.200
     1.372    27.830     0.200
     1.214    25.921     0.200
     1.254    25.824     0.200
     1.268    26.058     0.200
     1.308    26.773     0.200
     1.433    29.749     0.200
     1.507    30.450     0.200
     1.530    31.451     0.200
     1.533    30.541     0.200
     1.197    24.659     0.200
     1.260    25.763     0.200
     1.294    27.007     0.200
     1.343    27.870     0.200
     1.452    30.113     0.200
     1.527    31.458     0.200
     1.533    30.622     0.200
     1.535    31.299     0.200
     3.923    61.570     0.200
     4.860    72.465     0.200
     1.038    22.300     0.200
     1.116    23.193     0.200
     1.152    23.650     0.200
     1.237    25.599     0.200
     1.309    25.582     0.200
     1.346    27.225     0.200
     1.413    28.797     0.200
     1.028    22.029     0.200
     1.106    23.934     0.200
     1.141    24.353     0.200
     1.160    23.635     0.200
     1.171    23.957     0.200
     1.175    24.871     0.200
     1.245    25.872     0.200
     1.296    27.022     0.200
     1.299    25.909     0.200
     1.336    26.740     0.200
     1.331    28.041     0.200
     1.403    28.686     0.200
     0.829    18.476     0.200
     0.957    19.769     0.200
     1.008    21.579     0.200
     1.046    22.100     0.200
     1.052    21.381     0.200
     1.042    21.380     0.200
     1.122    22.668     0.200
     1.184    23.248     0.200
     1.222    25.470     0.200
     1.223    23.972     0.200
     1.231    24.258     0.200
     1.289    26.265     0.200
     1.309    25.847     0.200
     1.301    26.820     0.200
     1.319    26.935     0.200
     1.358    27.256     0.200
     1.373    27.508     0.200
     1.451    32.136     0.200
     4.110    63.672     0.200
     4.402    66.331     0.200
     5.803    82.486     0.200
     5.845    82.294     0.200
     6.040    86.415     0.200
     6.053    85.866     0.200
     6.259    86.963     0.200
     6.617    92.085     0.200
     7.280    99.745     0.200
     7.935   107.399     0.200
     7.964   108.062     0.200
    12.696   167.157     0.200
    12.696   166.024     0.200
    16.393   211.595     0.200
     0.843    18.537     0.200
     0.958    20.252     0.200
     1.050    22.426     0.200
     1.050    21.778     0.200
     1.048    21.769     0.200
     1.135    23.241     0.200
     1.182    23.494     0.200
     1.227    24.857     0.200
     1.232    25.377     0.200
     1.219    24.860     0.200
     1.292    26.349     0.200
     1.312    26.249     0.200
     1.331    26.956     0.200
     1.362    27.256     0.200
     1.382    27.431     0.200
     0.961    20.540     0.200
     1.052    23.183     0.200
     1.053    21.941     0.200
     1.052    22.313     0.200
     1.190    24.190     0.200
     1.141    23.754     0.200
     1.232    24.621     0.200
     1.219    26.045     0.200
     1.235    24.849     0.200
     1.297    26.006     0.200
     1.316    27.588     0.200
     1.336    28.115     0.200
     1.366    27.609     0.200
     1.384    28.410     0.200
     1.256    25.693     0.200
     1.362    27.532     0.200
     1.016    21.393     0.200
     1.025    21.487     0.200
     1.034    21.800     0.200
     1.118    23.522     0.200
     1.137    23.236     0.200
     1.201    25.238     0.200
     1.220    25.200     0.200
     1.281    26.340     0.200
     1.274    26.618     0.200
     1.307    27.070     0.200
     1.355    28.366     0.200
     1.423    28.922     0.200
     1.330    26.441     0.200
     1.335    28.211     0.200
     1.382    28.673     0.200
     1.248    25.700     0.200
     1.471    29.964     0.200
     1.380    27.835     0.200
     1.411    29.051     0.200
     1.623    33.798     0.200
     1.627    34.426     0.200
     1.095    22.812     0.200
     1.275    25.239     0.200
     1.296    27.008     0.200
     1.375    28.449     0.200
     1.576    32.193     0.200
     1.613    32.787     0.200
     1.642    33.364     0.200
     1.223    29.533     0.200
     2.717    46.778     0.200
     3.157    53.303     0.200
     3.789    59.795     0.200
     3.880    61.264     0.200
     4.249    65.723     0.200
     4.774    71.392     0.200
     5.034    77.474     0.200
     7.687   106.114     0.200
     9.782   132.478     0.200
    13.967   188.848     0.200
    16.871   217.544     0.200
     1.589    32.065     0.200
     1.207    25.489     0.200
     1.422    29.193     0.200
     1.591    32.617     0.200
     1.212    25.376     0.200
     1.310    27.579     0.200
     1.087    22.963     0.200
     1.234    25.847     0.200
     1.238    25.812     0.200
     1.310    26.590     0.200
     1.238    26.562     0.200
     1.234    26.457     0.200
     1.319    27.316     0.200
     1.396    29.127     0.200
     1.451    29.854     0.200
     1.601    32.951     0.200
     0.973    22.201     0.200
     1.014    22.152     0.200
     1.121    22.526     0.200
     1.218    29.696     0.200
     3.803    62.956     0.200
     1.621    33.268     0.200
     1.627    32.558     0.200
     2.943    49.842     0.200
     1.364    27.947     0.200
     1.403    28.001     0.200
     1.311    27.503     0.200
     1.608    33.153     0.200
     3.694    57.508     0.200
     3.913    63.121     0.200
     4.356    66.951     0.200
     4.789    68.833     0.200
     1.211    25.707     0.200
     2.079    36.343     0.200
     3.789    60.842     0.200
     4.249    67.440     0.200
     1.210    25.234     0.200
     1.308    27.177     0.200
     1.440    29.770     0.200
     1.456    29.974     0.200
     1.589    32.938     0.200
     1.625    33.703     0.200
     1.655    33.905     0.200
     3.802    61.957     0.200
     1.097    22.961     0.200
     1.175    23.992     0.200
     1.248    25.239     0.200
     1.289    25.825     0.200
     1.394    27.824     0.200
     1.317    27.662     0.200
     1.352    28.154     0.200
     1.393    29.356     0.200
     1.550    32.344     0.200
     1.564    32.506     0.200
     1.091    23.343     0.200
     1.199    24.959     0.200
     1.192    25.334     0.200
     1.246    25.732     0.200
     1.281    26.576     0.200
     1.346    27.564     0.200
     1.060    22.994     0.200
     1.124    23.667     0.200
     1.184    24.365     0.200
     1.188    24.475     0.200
     1.245    25.621     0.200
     1.254    25.892     0.200
     1.288    26.421     0.200
     1.295    26.434     0.200
     1.354    27.223     0.200
     3.538    57.372     0.200
     1.055    22.505     0.200
     1.093    23.255     0.200
     1.122    23.741     0.200
     1.248    25.979     0.200
     1.283    26.592     0.200
     1.349    27.635     0.200
     1.314    27.390     0.200
     1.361    28.285     0.200
     1.431    29.949     0.200
     1.480    30.672     0.200
     1.512    31.233     0.200
     1.004    20.819     0.200
     1.104    22.008     0.200
     1.207    23.542     0.200
     1.214    24.423     0.200
     1.299    25.384     0.200
     1.342    27.210     0.200
     1.374    28.846     0.200
     1.395    29.009     0.200
     1.404    28.882     0.200
     1.451    30.388     0.200
     1.504    31.392     0.200
     1.538    32.148     0.200
     1.533    32.039     0.200
     1.576    32.770     0.200
     1.589    32.940     0.200
     1.303    27.173     0.200
     1.382    28.656     0.200
     1.433    29.742     0.200
     1.450    30.088     0.200
     1.582    32.791     0.200
     1.620    33.581     0.200
     1.430    28.963     0.200
     3.795    60.678     0.200
     1.371    29.167     0.200
     1.511    31.080     0.200
     1.339    28.032     0.200
     1.366    28.366     0.200
     1.378    28.828     0.200
     1.403    29.177     0.200
     1.461    30.372     0.200
     1.500    31.431     0.200
     1.537    31.903     0.200
     1.549    32.599     0.200
     1.348    27.312     0.200
     1.458    28.349     0.200
     1.455    29.477     0.200
     1.466    29.615     0.200
     1.475    29.772     0.200
     1.498    29.763     0.200
     1.591    31.725     0.200
     1.279    26.430     0.200
     1.194    24.678     0.200
     1.316    26.639     0.200
     1.341    26.753     0.200
     1.259    25.976     0.200
     1.285    26.401     0.200
     1.481    29.723     0.200
     0.819    18.282     0.200
     0.995    21.214     0.200
     1.139    22.451     0.200
     1.172    23.976     0.200
     1.202    23.255     0.200
     1.257    25.654     0.200
     1.330    25.299     0.200
     1.342    26.175     0.200
     1.066    22.435     0.200
     1.133    23.617     0.200
     1.151    24.166     0.200
     1.202    24.679     0.200
     1.393    29.127     0.200
     1.393    29.044     0.200
     1.484    30.432     0.200
     1.202    25.012     0.200
     1.299    27.210     0.200
     1.377    28.689     0.200
     1.432    29.758     0.200
     1.447    29.915     0.200
     1.582    32.412     0.200
     1.616    33.236     0.200
     1.223    25.022     0.200
     1.446    29.150     0.200
     1.544    30.269     0.200
     1.574    31.640     0.200
     1.567    31.633     0.200
     1.586    31.878     0.200
     1.381    28.286     0.200
     1.134    23.739     0.200
     1.131    23.733     0.200
     1.249    26.100     0.200
     1.262    26.037     0.200
     1.276    26.409     0.200
     1.307    27.049     0.200
     1.316    27.122     0.200
     1.310    27.419     0.200
     1.374    28.327     0.200
     1.386    28.540     0.200
     1.443    29.488     0.200
     1.262    26.287     0.200
     1.249    26.491     0.200
     1.276    26.604     0.200
     1.307    26.768     0.200
     1.316    27.379     0.200
     1.386    28.392     0.200
     1.443    29.355     0.200
     1.303    27.617     0.200
     3.058    50.748     0.200
     3.481    56.681     0.200
     3.498    56.392     0.200
     1.078    22.842     0.200
     1.199    24.964     0.200
     1.265    25.795     0.200
     1.255    26.420     0.200
     1.274    25.956     0.200
     1.318    27.208     0.200
     1.323    26.736     0.200
     1.328    27.496     0.200
     1.387    28.196     0.200
     1.101    23.023     0.200
     1.111    23.154     0.200
     1.279    26.266     0.200
     1.388    28.601     0.200
     1.406    28.495     0.200
     1.205    24.527     0.200
     1.170    24.430     0.200
     1.212    25.260     0.200
     1.308    26.761     0.200
     1.339    27.555     0.200
     1.385    28.393     0.200
     1.498    30.236     0.200
     1.584    32.046     0.200
     1.283    26.407     0.200
     1.304    26.578     0.200
     1.304    26.784     0.200
     1.536    30.897     0.200
     1.282    26.780     0.200
     1.595    32.157     0.200
     1.216    25.266     0.200
     1.037    21.580     0.200
     1.134    23.608     0.200
     1.169    23.601     0.200
     1.214    25.569     0.200
     1.227    24.583     0.200
     1.275    26.030     0.200
     1.296    25.618     0.200
     1.299    26.511     0.200
     1.341    26.966     0.200
     1.349    27.122     0.200
     1.459    29.698     0.200
     1.486    30.312     0.200
     1.127    23.207     0.200
     1.135    23.871     0.200
     1.163    24.706     0.200
     1.216    25.222     0.200
     1.264    26.480     0.200
     1.316    27.336     0.200
     1.348    27.530     0.200
     1.414    28.957     0.200
     1.239    25.038     0.200
     1.326    27.182     0.200
     1.342    27.293     0.200
     1.348    27.672     0.200
     1.464    29.304     0.200
     1.685    31.231     0.200
     1.527    32.324     0.200
     3.209    51.530     0.200
     3.224    52.616     0.200
     4.847    72.668     0.200
     5.036    74.766     0.200
     5.692    83.506     0.200
     6.247    90.134     0.200
     6.293    90.587     0.200
     6.486    92.838     0.200
     6.499    92.488     0.200
     6.713    95.585     0.200
     7.726   107.965     0.200
     1.188    25.755     0.200
     1.080    23.222     0.200
     1.111    23.900     0.200
     1.126    23.625     0.200
     1.193    25.306     0.200
     1.385    28.892     0.200
     1.070    22.917     0.200
     1.086    23.400     0.200
     1.110    23.654     0.200
     1.228    25.969     0.200
     1.412    29.340     0.200
     1.055    22.364     0.200
     0.920    20.815     0.200
     0.951    20.194     0.200
     1.031    21.865     0.200
     1.049    22.361     0.200
     1.112    24.122     0.200
     1.150    24.168     0.200
     1.165    24.536     0.200
     1.203    25.700     0.200
     1.216    25.831     0.200
     1.209    25.512     0.200
     1.221    25.767     0.200
     1.235    26.708     0.200
     1.238    26.610     0.200
     1.407    29.247     0.200
     1.433    29.039     0.200
     1.426    29.584     0.200
     1.441    29.806     0.200
     1.417    29.132     0.200
     1.481    29.391     0.200
     1.187    24.981     0.200
     1.260    26.243     0.200
     1.426    29.306     0.200
     1.433    29.300     0.200
     1.441    29.368     0.200
     1.481    29.532     0.200
     1.420    29.548     0.200
     2.323    39.189     0.200
     5.015    71.701     0.200
     5.833    83.877     0.200
     6.500    90.692     0.200
     1.243    26.058     0.200
     1.310    27.735     0.200
     1.350    28.094     0.200
     1.416    29.306     0.200
     1.349    27.981     0.200
     1.441    29.592     0.200
     1.460    29.515     0.200
     1.487    30.376     0.200
     1.601    32.741     0.200
     3.809    60.318     0.200
     1.177    24.420     0.200
     1.206    24.489     0.200
     1.354    27.554     0.200
     1.355    27.351     0.200
     1.431    28.904     0.200
     1.589    31.296     0.200
     1.457    29.366     0.200
     1.107    22.747     0.200
     1.122    23.326     0.200
     1.150    24.380     0.200
     1.228    24.929     0.200
     1.243    26.751     0.200
     1.296    27.004     0.200
     1.332    27.580     0.200
     1.332    27.476     0.200
     1.398    28.560     0.200
     1.287    26.859     0.200
     1.242    26.630     0.200
     1.329    27.666     0.200
     1.367    28.644     0.200
     1.378    29.618     0.200
     1.392    29.579     0.200
     1.530    32.245     0.200
     1.559    33.061     0.200
     1.593    33.179     0.200
     2.672    45.974     0.200
     2.787    46.673     0.200
     3.442    54.274     0.200
     3.743    62.192     0.200
     4.745    73.741     0.200
     1.444    30.398     0.200
     1.654    34.964     0.200
     1.089    22.920     0.200
     1.128    23.349     0.200
     1.255    26.282     0.200
     1.300    27.138     0.200
     1.327    27.253     0.200
     1.353    27.761     0.200
     1.359    27.909     0.200
     1.385    27.959     0.200
     1.422    29.362     0.200
     1.491    30.508     0.200
     1.571    31.912     0.200
     1.570    31.916     0.200
     0.811    17.540     0.200
     0.836    18.129     0.200
     0.958    20.264     0.200
     0.994    20.603     0.200
     1.014    20.931     0.200
     1.074    22.046     0.200
     1.081    22.342     0.200
     1.101    23.085     0.200
     1.127    23.807     0.200
     1.260    25.698     0.200
     1.276    25.949     0.200
     1.296    25.858     0.200
     1.316    26.290     0.200
     1.330    26.519     0.200
     1.346    27.243     0.200
     1.385    27.413     0.200
     1.416    28.758     0.200
     1.518    31.017     0.200
     0.918    19.822     0.200
     0.964    20.520     0.200
     1.027    21.551     0.200
     1.039    21.885     0.200
     1.214    24.921     0.200
     1.267    26.383     0.200
     1.293    26.576     0.200
     1.336    27.596     0.200
     1.371    28.046     0.200
     1.133    23.734     0.200
     1.400    28.922     0.200
     1.503    31.090     0.200
     1.339    28.145     0.200
     1.366    28.516     0.200
     1.368    28.847     0.200
     1.501    30.974     0.200
     1.519    31.072     0.200
     1.515    32.416     0.200
     1.544    32.248     0.200
     1.637    33.534     0.200
     1.684    34.522     0.200
     1.734    35.009     0.200
     0.808    16.958     0.200
     1.038    21.456     0.200
     1.078    21.684     0.200
     1.108    21.223     0.200
     1.139    22.041     0.200
     1.282    24.537     0.200
     1.561    31.396     0.200
     1.598    31.486     0.200
     1.606    32.417     0.200
     1.237    25.206     0.200
     1.265    25.758     0.200
     1.365    27.743     0.200
     1.367    27.559     0.200
     1.491    29.900     0.200
     1.581    31.640     0.200
     1.219    25.245     0.200
     1.230    25.773     0.200
     1.297    26.546     0.200
     1.309    26.706     0.200
     1.308    27.076     0.200
     1.452    29.566     0.200
     1.455    29.664     0.200
     1.477    29.919     0.200
     1.504    30.759     0.200
     1.056    22.294     0.200
     1.236    25.594     0.200
     1.308    26.828     0.200
     1.313    27.335     0.200
     1.317    27.052     0.200
     1.461    30.436     0.200
     1.462    29.265     0.200
     1.128    23.790     0.200
     1.130    23.653     0.200
     1.217    25.284     0.200
     1.273    26.611     0.200
     1.322    26.904     0.200
     1.422    28.612     0.200
     0.988    21.099     0.200
     1.075    23.399     0.200
     1.247    27.000     0.200
     1.076    23.338     0.200
     1.278    26.173     0.200
     1.288    25.645     0.200
     1.358    27.602     0.200
     1.379    27.332     0.200
     1.455    29.522     0.200
     1.109    23.891     0.200
     1.406    29.290     0.200
     1.363    28.175     0.200
     1.434    29.419     0.200
     1.554    31.236     0.200
     1.239    25.541     0.200
     1.395    29.425     0.200
     1.489    30.965     0.200
     1.115    23.560     0.200
     1.271    27.382     0.200
     1.319    26.947     0.200
     1.382    28.636     0.200
     1.276    26.596     0.200
     1.339    28.172     0.200
     1.386    29.347     0.200
     1.448    29.700     0.200
     1.517    31.731     0.200
     1.184    25.601     0.200
     1.380    27.381     0.200
     1.411    28.778     0.200
     1.471    29.865     0.200
     1.407    27.997     0.200
     0.889    19.149     0.200
     0.893    19.384     0.200
     0.895    19.397     0.200
     0.971    21.548     0.200
     1.009    21.444     0.200
     1.018    22.052     0.200
     1.094    22.790     0.200
     1.113    23.226     0.200
     1.155    24.027     0.200
     1.157    24.876     0.200
     1.213    26.296     0.200
     1.239    25.778     0.200
     1.283    26.788     0.200
     1.345    27.930     0.200
     1.354    28.451     0.200
     1.147    23.340     0.200
     1.359    27.562     0.200
     1.281    26.851     0.200
     1.301    27.969     0.200
     1.574    32.175     0.200
     1.018    24.984     0.200
     1.289    27.166     0.200
     1.324    27.828     0.200
     1.390    28.519     0.200
     1.417    29.495     0.200
     0.850    18.527     0.200
     0.959    20.352     0.200
     0.986    20.965     0.200
     1.012    20.493     0.200
     1.014    20.766     0.200
     1.029    21.260     0.200
     1.064    22.953     0.200
     1.081    22.371     0.200
     1.150    23.683     0.200
     1.187    24.087     0.200
     1.308    26.960     0.200
     1.422    29.729     0.200
     1.215    26.012     0.200
     1.233    26.518     0.200
     1.294    28.073     0.200
     1.311    28.006     0.200
     1.311    27.877     0.200
     1.451    31.074     0.200
     1.458    31.171     0.200
     1.501    31.839     0.200
     1.588    32.536     0.200
     1.630    34.184     0.200
     1.263    26.164     0.200
     1.263    26.844     0.200
     1.339    27.065     0.200
     1.340    27.133     0.200
     1.492    30.287     0.200
     1.488    30.239     0.200
     1.520    30.279     0.200
     1.547    31.472     0.200
     1.630    32.542     0.200
     1.237    25.051     0.200
     1.270    25.617     0.200
     1.266    26.637     0.200
     1.342    26.723     0.200
     1.345    27.203     0.200
     1.349    27.017     0.200
     1.490    29.879     0.200
     1.553    30.543     0.200
     1.142    24.004     0.200
     1.160    23.892     0.200
     1.219    25.807     0.200
     1.224    24.734     0.200
     1.375    28.008     0.200
     1.439    28.876     0.200
     1.513    29.976     0.200
     1.546    30.805     0.200
     1.033    21.956     0.200
     1.034    22.529     0.200
     1.110    23.472     0.200
     1.139    23.458     0.200
     1.150    24.190     0.200
     1.229    24.887     0.200
     1.254    25.256     0.200
     1.284    26.450     0.200
     1.304    26.106     0.200
     1.337    27.152     0.200
     1.344    27.886     0.200
     1.403    28.478     0.200
     1.228    25.457     0.200
     1.410    28.873     0.200
     1.459    30.359     0.200
     1.506    30.972     0.200
     1.561    32.041     0.200
     1.624    32.869     0.200
     1.089    22.744     0.200
     1.175    24.357     0.200
     1.185    24.159     0.200
     1.239    25.270     0.200
     1.262    26.743     0.200
     1.282    25.865     0.200
     1.320    26.904     0.200
     1.386    28.650     0.200
     1.170    23.970     0.200
     1.249    25.328     0.200
     1.255    25.629     0.200
     1.291    25.778     0.200
     1.329    26.842     0.200
     1.395    27.349     0.200
     1.045    22.259     0.200
     1.518    30.538     0.200
     1.000    21.876     0.200
     1.069    22.588     0.200
     1.120    23.693     0.200
     1.268    25.835     0.200
     1.486    30.604     0.200
     0.984    21.634     0.200
     1.229    24.604     0.200
     1.288    26.674     0.200
     1.305    27.701     0.200
     1.357    27.984     0.200
     1.016    21.517     0.200
     1.087    23.356     0.200
     1.155    24.290     0.200
     1.019    21.252     0.200
     1.163    23.193     0.200
     1.168    24.031     0.200
     1.228    25.128     0.200
     1.297    26.307     0.200
     1.351    27.991     0.200
     1.429    28.841     0.200
     0.976    21.254     0.200
     0.999    21.810     0.200
     1.163    24.256     0.200
     1.163    23.446     0.200
     1.171    24.082     0.200
     1.229    24.915     0.200
     0.984    20.373     0.200
     1.018    21.439     0.200
     1.164    23.297     0.200
     1.169    23.906     0.200
     1.211    23.624     0.200
     1.228    24.835     0.200
     1.263    25.466     0.200
     1.426    29.105     0.200
     1.503    30.269     0.200
     1.533    30.434     0.200
     1.389    28.433     0.200
     1.474    30.130     0.200
     1.471    29.964     0.200
     1.509    30.380     0.200
     1.531    30.842     0.200
     1.558    31.559     0.200
     1.652    33.696     0.200
     1.307    30.159     0.200
     3.698    58.235     0.200
     3.698    59.235     0.200
     4.545    69.057     0.200
     5.097    76.815     0.200
     5.097    76.017     0.200
     5.148    76.316     0.200
     5.148    75.915     0.200
     5.338    79.400     0.200
     5.338    79.601     0.200
     5.578    83.301     0.200
     5.578    80.100     0.200
     6.578    93.433     0.200
     7.241   102.688     0.200
     7.241   100.989     0.200
     7.291   102.213     0.200
     7.291   101.014     0.200
     1.103    22.748     0.200
     1.353    27.064     0.200
     1.392    28.885     0.200
     1.560    31.953     0.200
     0.882    18.998     0.200
     0.945    19.994     0.200
     1.018    21.463     0.200
     1.067    21.994     0.200
     1.171    24.675     0.200
     1.223    24.908     0.200
     1.472    30.386     0.200
     1.499    30.531     0.200
     1.374    28.485     0.200
     2.637    43.018     0.200
     3.229    51.289     0.200
     5.010    74.004     0.200
     5.204    77.843     0.200
     5.258    74.840     0.200
     5.854    84.152     0.200
     6.190    84.797     0.200
     6.410    90.469     0.200
     6.455    89.946     0.200
     6.649    93.980     0.200
     6.871    95.585     0.200
     7.889   108.407     0.200
     8.272   110.166     0.200
     8.577   115.277     0.200
     0.809    18.871     0.200
     0.919    20.902     0.200
     0.995    24.213     0.200
     1.182    23.710     0.200
     1.179    27.312     0.200
     2.084    34.994     0.200
     2.155    34.656     0.200
     2.261    36.202     0.200
     2.274    35.049     0.200
     2.325    38.184     0.200
     2.799    42.387     0.200
     4.835    67.432     0.200
     5.065    72.876     0.200
     5.576    78.775     0.200
     5.728    80.495     0.200
     6.423    87.885     0.200
     6.971    96.196     0.200
     7.028    94.927     0.200
     7.214    97.850     0.200
     7.227    98.303     0.200
     7.461    99.874     0.200
     7.814   104.859     0.200
     8.453   112.695     0.200
     1.140    23.660     0.200
     1.169    24.449     0.200
     1.183    25.092     0.200
     1.201    25.160     0.200
     1.567    32.026     0.200
     0.914    20.470     0.200
     1.059    22.935     0.200
     1.173    24.689     0.200
     1.205    25.403     0.200
     1.243    25.879     0.200
     1.264    26.720     0.200
     1.398    29.713     0.200
     1.406    28.974     0.200
     1.481    31.358     0.200
     0.961    20.280     0.200
     0.986    21.071     0.200
     1.001    20.946     0.200
     1.050    22.313     0.200
     1.085    22.625     0.200
     1.120    23.680     0.200
     1.177    25.065     0.200
     1.186    25.064     0.200
     1.264    26.365     0.200
     1.278    26.343     0.200
     1.316    27.596     0.200
     1.382    28.192     0.200
     1.361    26.080     0.200
     1.339    25.710     0.200
     2.698    45.194     0.200
     4.060    60.026     0.200
     4.690    68.580     0.200
     5.030    72.076     0.200
     5.341    74.683     0.200
     6.719    92.004     0.200
     7.375   100.841     0.200
     7.385    99.191     0.200
     8.034   107.453     0.200
     8.070   107.132     0.200
     9.150   124.731     0.200
    12.710   169.002     0.200
    12.710   165.963     0.200
    12.826   168.129     0.200
    13.557   174.124     0.200
    16.464   209.781     0.200
     1.175    24.205     0.200
     1.232    25.131     0.200
     1.313    27.378     0.200
     1.379    28.215     0.200
     1.297    26.708     0.200
     1.078    22.778     0.200
     1.308    27.051     0.200
     1.531    31.586     0.200
     1.080    22.659     0.200
     1.228    25.467     0.200
     1.265    26.414     0.200
     1.273    26.309     0.200
     1.309    26.786     0.200
     1.375    28.319     0.200
     1.264    25.469     0.200
     1.355    27.155     0.200
     3.059    51.315     0.200
     0.987    20.640     0.200
     1.171    23.535     0.200
     1.214    25.353     0.200
     1.271    25.281     0.200
     1.322    25.567     0.200
     1.355    26.671     0.200
     1.535    31.512     0.200
     1.326    28.044     0.200
     1.368    27.411     0.200
     1.348    27.947     0.200
     1.465    30.378     0.200
     1.610    32.867     0.200
     1.528    32.249     0.200
     3.215    50.732     0.200
     1.242    26.292     0.200
     1.219    25.478     0.200
     1.261    26.607     0.200
     1.267    26.806     0.200
     1.598    35.795     0.200
     1.349    27.440     0.200
     1.382    29.048     0.200
     1.303    26.688     0.200
     1.389    29.615     0.200
     1.407    28.677     0.200
     1.412    29.704     0.200
     1.529    31.629     0.200
     1.570    31.785     0.200
     1.598    31.550     0.200
     1.466    30.136     0.200
     2.648    43.644     0.200
     3.211    50.374     0.200
     1.308    26.772     0.200
     1.392    28.430     0.200
     1.411    28.727     0.200
     1.416    29.062     0.200
     1.533    31.658     0.200
     1.602    31.900     0.200
     3.786    60.990     0.200
     4.474    68.013     0.200
     4.914    73.681     0.200
     5.104    76.456     0.200
     5.758    81.823     0.200
     6.314    89.946     0.200
     6.360    89.603     0.200
     6.553    92.950     0.200
     6.565    93.006     0.200
     6.778    94.021     0.200
     7.135   100.153     0.200
     7.793   107.284     0.200
     8.451   115.396     0.200
     8.485   115.099     0.200
    12.430   163.977     0.200
    12.649   166.027     0.200
     1.053    22.409     0.200
     1.250    26.534     0.200
     1.255    26.333     0.200
     1.294    26.335     0.200
     1.327    26.808     0.200
     1.472    29.177     0.200
     1.585    32.268     0.200
     1.281    26.698     0.200
     1.293    26.786     0.200
     1.360    27.608     0.200
     1.370    27.920     0.200
     1.374    27.933     0.200
     1.406    28.685     0.200
     1.517    30.593     0.200
     1.541    30.664     0.200
     1.567    32.268     0.200
     1.229    25.204     0.200
     1.545    32.587     0.200
     2.634    45.357     0.200
     3.027    49.862     0.200
     2.972    50.420     0.200
     3.085    50.113     0.200
     3.392    55.809     0.200
     3.598    58.408     0.200
     3.844    59.630     0.200
     4.070    63.833     0.200
     4.237    66.756     0.200
     4.792    72.471     0.200
     4.839    72.828     0.200
     5.032    76.181     0.200
     5.044    75.432     0.200
     5.006    77.903     0.200
     6.125    86.381     0.200
     7.203    96.476     0.200
     7.723   104.969     0.200
     7.986   105.080     0.200
     7.986   108.322     0.200
     8.420   120.413     0.200
    10.829   142.718     0.200
    11.049   143.735     0.200
    13.816   176.447     0.200
     0.896    22.357     0.200
     1.240    26.474     0.200
     1.227    28.977     0.200
     1.451    31.390     0.200
     2.317    39.572     0.200
     2.582    43.574     0.200
     2.606    43.609     0.200
     3.378    55.023     0.200
     4.979    73.162     0.200
     6.938    97.590     0.200
     8.469   116.738     0.200
    12.048   158.609     0.200
    12.048   161.468     0.200
    16.152   205.923     0.200
     2.893    43.785     0.200
     2.890    46.646     0.200
     3.006    49.433     0.200
     3.016    48.434     0.200
     3.073    49.452     0.200
     3.174    49.213     0.200
     3.174    49.432     0.200
     3.314    52.556     0.200
     3.407    52.592     0.200
     3.521    52.860     0.200
     3.828    57.299     0.200
     4.171    59.969     0.200
     4.330    65.549     0.200
     4.697    66.511     0.200
     4.724    66.715     0.200
     4.666    69.242     0.200
     4.774    70.523     0.200
     4.774    67.833     0.200
     4.740    68.146     0.200
     4.965    70.409     0.200
     4.977    69.461     0.200
     5.203    71.830     0.200
     5.556    76.507     0.200
     5.881    79.994     0.200
     6.099    84.781     0.200
     6.099    85.631     0.200
     6.867    92.509     0.200
     6.915    92.944     0.200
     7.668   102.405     0.200
     7.960   105.261     0.200
     7.949   106.227     0.200
     9.637   125.487     0.200
     9.637   127.317     0.200
    10.054   136.520     0.200
    10.735   138.361     0.200
    11.056   143.198     0.200
    12.968   169.016     0.200
    13.578   179.431     0.200
    13.578   175.542     0.200
    15.075   198.522     0.200
    16.947   218.855     0.200
     1.166    28.577     0.200
     1.446    33.634     0.200
     1.470    35.411     0.200
     1.651    34.879     0.200
     1.627    35.196     0.200
     2.495    44.894     0.200
     2.574    45.187     0.200
     1.489    28.669     0.200
     2.661    41.799     0.200
     2.951    47.042     0.200
     2.833    46.532     0.200
     3.000    46.814     0.200
     3.247    52.408     0.200
     3.276    51.301     0.200
     3.774    55.284     0.200
     4.001    62.990     0.200
     4.223    62.312     0.200
     4.440    66.178     0.200
     4.519    66.736     0.200
     7.232    97.175     0.200
     1.408    27.720     0.200
     2.585    38.712     0.200
     3.813    60.638     0.200
     5.066    69.453     0.200
     7.246    96.014     0.200
     7.871   106.542     0.200
     8.055   110.362     0.200
    10.143   133.325     0.200
     1.220    28.634     0.200
     1.501    33.628     0.200
     1.901    32.566     0.200
     2.423    41.778     0.200
     2.434    39.156     0.200
     2.600    43.526     0.200
     3.155    52.529     0.200
     3.622    57.636     0.200
     5.330    79.508     0.200
     6.002    87.217     0.200
     6.604    94.798     0.200
     7.556   102.800     0.200
     8.707   122.257     0.200
    12.282   161.006     0.200
    12.565   166.021     0.200
    13.873   181.035     0.200
    16.243   210.574     0.200
    16.271   208.474     0.200
     3.022    50.228     0.200
     3.022    49.528     0.200
     3.431    54.724     0.200
     3.464    55.167     0.200
     3.464    54.767     0.200
     3.651    58.887     0.200
     3.651    57.387     0.200
     4.311    64.388     0.200
     4.311    65.188     0.200
     4.863    72.249     0.200
     4.914    71.805     0.200
     4.914    71.944     0.200
     4.914    71.645     0.200
     5.104    74.633     0.200
     5.104    74.133     0.200
     5.117    74.486     0.200
     5.345    78.215     0.200
     5.345    75.715     0.200
     7.008    98.318     0.200
     7.008    97.818     0.200
     7.059    98.823     0.200
     7.059    94.923     0.200
    11.014   146.178     0.200
     1.431    30.086     0.200
     2.844    49.155     0.200
     3.090    51.864     0.200
     3.523    57.310     0.200
     3.718    60.633     0.200
     4.026    64.353     0.200
     4.369    67.940     0.200
     4.541    69.279     0.200
     4.923    75.980     0.200
     5.163    77.076     0.200
     5.399    81.324     0.200
     7.110   101.648     0.200
     7.159    95.636     0.200
     7.992   110.299     0.200
     1.446    25.802     0.200
     2.488    39.077     0.200
     4.151    60.797     0.200
     4.781    68.149     0.200
     5.433    76.038     0.200
     5.988    84.760     0.200
     6.034    83.619     0.200
     6.227    86.867     0.200
     6.454    89.620     0.200
     6.811    94.059     0.200
     8.162   109.389     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.581    49.138     0.200
     5.110   102.937     0.200
     5.110   107.335     0.200
    21.597   455.707     0.200
     5.561   106.247     0.200
     3.178    61.966     0.200
     8.121   165.065     0.200
     2.696    51.534     0.200
     4.336    84.401     0.200
     4.327    84.749     0.200
     3.090    59.244     0.200
     3.207    61.473     0.200
     5.602   106.523     0.200
     2.950    57.689     0.200
     3.309    66.843     0.200
     3.300    67.345     0.200
     2.861    54.160     0.200
     3.145    64.842     0.200
     2.776    58.369     0.200
     2.537    49.101     0.200
     2.748    53.639     0.200
     2.610    49.701     0.200
     2.823    54.212     0.200
     3.022    57.891     0.200
     3.175    60.701     0.200
     2.525    49.801     0.200
     2.718    53.044     0.200
     3.497    68.458     0.200
     2.948    55.771     0.200
     2.996    57.916     0.200
     2.627    52.793     0.200
     2.560    51.478     0.200
     2.569    52.188     0.200
     3.136    64.079     0.200
     2.913    55.150     0.200
     2.525    48.556     0.200
     2.707    52.631     0.200
     2.707    52.330     0.200
     2.546    48.573     0.200
     2.766    54.241     0.200
     2.766    53.639     0.200
     2.935    57.554     0.200
     4.520    88.859     0.200
     2.765    53.591     0.200
     2.712    53.032     0.200
     2.498    48.257     0.200
     2.564    51.484     0.200
     2.690    54.015     0.200
     2.561    48.860     0.200
     2.755    54.095     0.200
     2.982    60.955     0.200
     2.744    54.977     0.200
     2.968    59.223     0.200
     2.952    57.443     0.200
     5.730   107.778     0.200
     2.605    51.131     0.200
     2.857    56.191     0.200
     3.355    67.250     0.200
     2.947    55.922     0.200
     2.558    48.989     0.200
     2.775    56.322     0.200
     2.764    53.628     0.200
     2.730    51.709     0.200
     2.896    58.239     0.200
     3.145    60.833     0.200
     2.769    52.207     0.200
     2.969    57.369     0.200
     3.103    61.511     0.200
     6.759   127.560     0.200
     2.651    52.305     0.200
     2.835    56.115     0.200
     3.077    62.285     0.200
     3.522    69.745     0.200
     3.450    66.235     0.200
     3.485    71.723     0.200
     3.883    75.683     0.200
     4.134    82.946     0.200
     7.264   143.397     0.200
     2.531    50.441     0.200
     2.635    50.827     0.200
     3.537    71.577     0.200
     3.678    70.322     0.200
     5.032    98.112     0.200
     3.524    70.443     0.200
     3.927    75.733     0.200
     4.503    86.418     0.200
     4.897    93.017     0.200
     3.007    62.139     0.200
     2.885    55.556     0.200
     2.828    55.215     0.200
     3.028    58.038     0.200
     3.028    58.317     0.200
     2.576    50.400     0.200
     3.547    68.171     0.200
     3.892    77.356     0.200
     3.548    68.753     0.200
     4.040    77.894     0.200
     2.943    58.633     0.200
     2.577    48.527     0.200
     3.510    67.338     0.200
     3.567    69.712     0.200
     3.721    71.177     0.200
     6.310   119.296     0.200
     3.909    80.082     0.200
     2.745    54.025     0.200
     2.703    54.395     0.200
     2.819    54.598     0.200
     3.014    62.220     0.200
     3.844    72.373     0.200
     3.374    67.162     0.200
     2.716    54.256     0.200
     2.716    54.475     0.200
     3.472    72.927     0.200
     3.275    66.983     0.200
     3.383    66.670     0.200
     3.777    71.270     0.200
     5.950   111.732     0.200
     2.715    51.492     0.200
     3.387    69.286     0.200
     2.668    52.857     0.200
     3.048    62.416     0.200
     2.620    50.821     0.200
     2.546    49.558     0.200
     2.518    51.378     0.200
     3.635    71.585     0.200
     2.738    53.070     0.200
     3.282    65.527     0.200
     5.876   111.454     0.200
     2.517    48.472     0.200
     3.165    63.696     0.200
     3.343    65.160     0.200
     2.511    48.407     0.200
     2.883    56.310     0.200
     2.848    56.113     0.200
     3.304    64.380     0.200
     2.622    52.732     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.128    38.521     0.200
     2.799    52.420     0.200
     1.183    22.883     0.200
     2.669    48.542     0.200
     1.993    37.310     0.200
     3.645    65.935     0.200
     2.311    40.991     0.200
     0.777    15.097     0.200
     2.533    46.900     0.200
     1.819    34.099     0.200
     2.843    51.852     0.200
     1.337    25.781     0.200
     2.478    48.262     0.200
     2.503    42.838     0.200
     2.475    43.477     0.200
     3.814    67.955     0.200
     5.110    89.539     0.200
     2.530    46.235     0.200
     2.536    47.968     0.200
     1.027    21.082     0.200
     1.252    24.259     0.200
     1.477    28.117     0.200
     2.144    38.089     0.200
     2.940    54.305     0.200
     2.940    54.008     0.200
     3.866    65.993     0.200
     2.135    41.810     0.200
     2.474    46.360     0.200
     0.770    16.479     0.200
     5.627    98.200     0.200
     0.738    15.230     0.200
     2.068    39.015     0.200
     2.475    43.370     0.200
     0.704    13.626     0.200
     2.042    39.514     0.200
     2.445    45.312     0.200
     0.534    11.084     0.200
     2.276    42.748     0.200
     0.934    18.739     0.200
     2.533    45.280     0.200
     2.906    54.423     0.200
     1.103    22.130     0.200
     1.670    32.508     0.200
     2.623    47.393     0.200
     2.606    48.788     0.200
     3.025    56.693     0.200
     2.593    47.081     0.200
     3.013    56.084     0.200
     3.435    62.662     0.200
     0.830    15.718     0.200
     2.019    38.530     0.200
     1.006    20.634     0.200
     1.136    22.693     0.200
     2.490    44.389     0.200
     2.529    46.492     0.200
     1.026    20.482     0.200
     2.016    40.938     0.200
     2.491    44.686     0.200
     2.533    45.401     0.200
     1.095    21.356     0.200
     1.228    24.305     0.200
     2.532    44.581     0.200
     2.599    47.801     0.200
     2.729    50.280     0.200
     2.953    54.067     0.200
     3.445    60.428     0.200
     1.149    22.638     0.200
     2.048    40.643     0.200
     2.609    48.105     0.200
     2.049    40.639     0.200
     1.020    20.270     0.200
     1.188    23.696     0.200
     2.037    39.991     0.200
     2.540    45.730     0.200
     2.582    47.633     0.200
     2.715    48.579     0.200
     2.848    53.534     0.200
     5.750   100.659     0.200
     2.045    39.842     0.200
     2.857    50.857     0.200
     3.339    62.735     0.200
     2.045    39.837     0.200
     2.620    47.087     0.200
     2.999    53.158     0.200
     1.024    21.265     0.200
     2.015    38.246     0.200
     2.945    54.398     0.200
     2.016    38.242     0.200
     1.006    21.249     0.200
     1.167    23.259     0.200
     1.156    21.380     0.200
     2.042    38.040     0.200
     2.559    46.512     0.200
     2.692    50.461     0.200
     2.745    50.843     0.200
     2.979    55.312     0.200
     5.727   102.039     0.200
     1.118    23.023     0.200
     2.043    38.036     0.200
     1.226    24.244     0.200
     2.091    40.148     0.200
     2.384    46.424     0.200
     2.701    49.026     0.200
     2.827    50.961     0.200
     3.055    54.902     0.200
     1.122    22.466     0.200
     1.187    24.006     0.200
     2.561    46.464     0.200
     2.388    46.091     0.200
     2.694    50.420     0.200
     3.180    56.244     0.200
     1.034    18.951     0.200
     1.988    39.976     0.200
     2.436    46.740     0.200
     2.503    44.965     0.200
     2.630    48.484     0.200
     2.856    51.839     0.200
     2.640    49.156     0.200
     3.056    53.303     0.200
     2.928    54.501     0.200
     3.184    59.958     0.200
     1.036    19.658     0.200
     1.187    23.375     0.200
     2.482    45.358     0.200
     2.658    50.001     0.200
     2.945    54.150     0.200
     3.102    54.829     0.200
     1.864    37.753     0.200
     1.037    19.712     0.200
     1.148    22.787     0.200
     2.484    44.298     0.200
     2.612    45.795     0.200
     2.679    49.017     0.200
     2.741    48.299     0.200
     3.130    54.753     0.200
     1.068    21.903     0.200
     0.995    20.083     0.200
     2.595    47.237     0.200
     2.663    48.937     0.200
     2.727    48.686     0.200
     2.986    54.069     0.200
     1.114    22.410     0.200
     2.983    55.702     0.200
     3.012    53.760     0.200
     0.198     4.293     0.200
     1.107    21.578     0.200
     2.547    46.523     0.200
     1.153    22.642     0.200
     1.007    19.976     0.200
     1.098    22.437     0.200
     2.064    39.771     0.200
     2.756    50.697     0.200
     1.146    22.497     0.200
     1.192    24.761     0.200
     1.248    25.308     0.200
     1.169    24.537     0.200
     2.011    39.203     0.200
     2.759    51.481     0.200
     1.879    38.322     0.200
     2.012    39.198     0.200
     1.047    20.966     0.200
     1.093    22.515     0.200
     1.194    24.132     0.200
     2.652    50.114     0.200
     2.719    50.441     0.200
     2.079    40.410     0.200
     2.379    45.799     0.200
     2.586    46.488     0.200
     2.781    49.449     0.200
     2.780    50.220     0.200
     2.973    53.973     0.200
     3.646    66.922     0.200
     1.003    18.777     0.200
     1.001    19.452     0.200
     1.118    22.061     0.200
     2.028    38.740     0.200
     2.917    54.359     0.200
     1.024    19.274     0.200
     1.066    20.961     0.200
     1.147    21.763     0.200
     2.027    40.596     0.200
     2.694    48.805     0.200
     2.952    55.796     0.200
     0.276     4.730     0.200
     1.089    19.416     0.200
     1.985    39.293     0.200
     2.607    49.035     0.200
     2.741    50.471     0.200
     3.029    55.919     0.200
     0.573    10.962     0.200
     0.869    17.201     0.200
     0.976    19.950     0.200
     1.114    22.120     0.200
     1.211    24.268     0.200
     2.043    40.254     0.200
     2.576    47.228     0.200
     2.621    48.007     0.200
     2.754    51.950     0.200
     2.816    53.034     0.200
     3.041    56.401     0.200
     1.154    23.023     0.200
     2.043    40.250     0.200
     0.086     3.742     0.200
     0.241     3.675     0.200
     0.292     6.116     0.200
     0.324     6.661     0.200
     1.002    20.652     0.200
     1.070    21.217     0.200
     1.120    23.067     0.200
     1.173    23.453     0.200
     2.056    40.146     0.200
     2.590    47.916     0.200
     0.042     4.006     0.200
     0.216     4.833     0.200
     0.221     5.672     0.200
     0.292     5.893     0.200
     0.828    17.589     0.200
     1.023    19.575     0.200
     1.149    22.345     0.200
     2.028    38.287     0.200
     2.563    44.539     0.200
     2.858    50.203     0.200
     2.028    38.283     0.200
     2.633    49.630     0.200
     0.056     3.688     0.200
     0.063     4.302     0.200
     0.223     5.129     0.200
     0.219     4.862     0.200
     0.219     5.042     0.200
     0.292     5.928     0.200
     1.025    19.815     0.200
     2.027    39.178     0.200
     2.565    44.899     0.200
     2.729    48.984     0.200
     2.028    39.174     0.200
     2.956    54.737     0.200
     0.049     3.697     0.200
     0.065     2.604     0.200
     0.048     4.327     0.200
     0.070     4.028     0.200
     0.213     4.738     0.200
     0.217     5.191     0.200
     0.286     5.878     0.200
     0.816    16.599     0.200
     2.692    50.201     0.200
     0.058     2.287     0.200
     0.126     4.143     0.200
     0.249     5.426     0.200
     0.249     4.365     0.200
     0.366     7.282     0.200
     0.894    17.946     0.200
     1.060    20.918     0.200
     1.114    22.380     0.200
     2.111    41.452     0.200
     2.411    46.445     0.200
     0.077     3.987     0.200
     0.050     4.045     0.200
     0.088     3.025     0.200
     0.187     5.756     0.200
     0.230     5.448     0.200
     0.234     5.528     0.200
     0.852    17.614     0.200
     1.001    20.860     0.200
     1.173    22.166     0.200
     1.169    23.116     0.200
     2.877    51.484     0.200
     2.053    39.094     0.200
     2.579    46.961     0.200
     0.048     4.094     0.200
     0.055     3.414     0.200
     0.215     5.281     0.200
     0.216     5.598     0.200
     0.207     5.920     0.200
     0.816    16.771     0.200
     1.040    18.801     0.200
     1.078    21.018     0.200
     1.154    21.329     0.200
     1.136    22.637     0.200
     2.560    45.313     0.200
     2.694    48.358     0.200
     2.852    49.513     0.200
     2.755    49.137     0.200
     2.012    39.314     0.200
     5.729    98.941     0.200
     0.049     4.120     0.200
     0.082     4.100     0.200
     0.184     5.985     0.200
     0.236     5.816     0.200
     0.232     5.443     0.200
     0.292     5.846     0.200
     0.294     6.359     0.200
     0.577    11.522     0.200
     0.857    17.007     0.200
     0.995    20.730     0.200
     2.714    49.834     0.200
     0.088     3.826     0.200
     0.009     3.722     0.200
     0.037     4.198     0.200
     0.246     5.882     0.200
     0.243     5.325     0.200
     0.294     6.235     0.200
     0.301     6.181     0.200
     0.300     6.193     0.200
     0.862    17.495     0.200
     0.051     3.504     0.200
     0.063     3.672     0.200
     0.076     3.906     0.200
     0.221     4.722     0.200
     0.226     4.952     0.200
     0.248     5.900     0.200
     0.262     5.638     0.200
     0.522    10.100     0.200
     0.811    16.734     0.200
     0.802    17.080     0.200
     1.052    19.385     0.200
     1.089    21.644     0.200
     2.562    46.797     0.200
     2.758    51.308     0.200
     2.925    51.561     0.200
     0.023     4.380     0.200
     0.041     4.595     0.200
     0.255     5.084     0.200
     0.257     5.782     0.200
     0.319     6.244     0.200
     0.605    11.757     0.200
     0.885    17.884     0.200
     1.096    20.220     0.200
     0.999    20.400     0.200
     0.037     3.978     0.200
     0.060     4.018     0.200
     0.082     4.325     0.200
     0.207     4.799     0.200
     0.202     4.787     0.200
     0.251     4.677     0.200
     0.218     6.263     0.200
     0.530    10.418     0.200
     0.810    16.902     0.200
     0.804    16.471     0.200
     1.033    18.125     0.200
     1.063    19.815     0.200
     2.681    49.827     0.200
     2.742    49.112     0.200
     0.048     3.837     0.200
     0.050     3.277     0.200
     0.070     4.077     0.200
     0.220     4.873     0.200
     0.206     6.295     0.200
     0.254     5.698     0.200
     0.264     5.720     0.200
     0.820    17.826     0.200
     0.074     3.521     0.200
     0.023     3.540     0.200
     0.050     3.571     0.200
     0.229     4.192     0.200
     0.187     5.102     0.200
     0.290     6.217     0.200
     0.568    11.071     0.200
     0.688    12.676     0.200
     0.849    16.439     0.200
     1.172    23.422     0.200
     2.578    46.016     0.200
     0.044     4.015     0.200
     0.104     4.140     0.200
     0.052     2.794     0.200
     0.074     4.227     0.200
     0.208     3.965     0.200
     0.213     4.950     0.200
     0.259     5.548     0.200
     0.211     6.175     0.200
     0.259     5.546     0.200
     0.813    17.337     0.200
     0.819    17.470     0.200
     1.027    19.642     0.200
     0.130     3.613     0.200
     0.158     3.963     0.200
     0.107     3.831     0.200
     0.185     3.769     0.200
     0.185     4.043     0.200
     0.174     4.465     0.200
     0.177     4.868     0.200
     0.235     5.232     0.200
     0.286     6.728     0.200
     0.417     8.137     0.200
     0.707    15.962     0.200
     0.138     3.532     0.200
     0.096     3.890     0.200
     0.114     3.112     0.200
     0.161     3.762     0.200
     0.187     3.844     0.200
     0.163     4.250     0.200
     0.170     4.543     0.200
     0.217     4.155     0.200
     0.283     6.816     0.200
     0.424     8.237     0.200
     0.567    12.576     0.200
     0.712    15.884     0.200
     0.137     4.921     0.200
     0.196     4.538     0.200
     0.137     4.717     0.200
     0.241     6.004     0.200
     0.268     5.487     0.200
     0.268     5.886     0.200
     0.214     5.916     0.200
     0.293     5.424     0.200
     0.304     6.818     0.200
     0.301     6.399     0.200
     0.317     7.918     0.200
     0.480     9.560     0.200
     0.644    13.708     0.200
     0.781    17.555     0.200
     0.051     3.583     0.200
     0.111     3.762     0.200
     0.047     3.523     0.200
     0.191     3.962     0.200
     0.220     4.933     0.200
     0.265     5.098     0.200
     0.204     5.720     0.200
     0.287     5.825     0.200
     0.662    14.466     0.200
     0.817    18.409     0.200
     1.028    19.641     0.200
     1.069    21.957     0.200
     0.097     3.873     0.200
     0.137     3.512     0.200
     0.172     4.717     0.200
     0.216     3.871     0.200
     0.225     4.390     0.200
     0.284     6.772     0.200
     1.251    24.577     0.200
     1.901    36.993     0.200
     2.513    46.855     0.200
     0.046     3.711     0.200
     0.103     3.949     0.200
     0.050     4.462     0.200
     0.208     3.818     0.200
     0.213     5.382     0.200
     0.258     5.433     0.200
     0.210     5.843     0.200
     0.540    10.842     0.200
     0.659    13.207     0.200
     0.815    17.243     0.200
     0.820    17.073     0.200
     0.934    19.746     0.200
     0.060     2.920     0.200
     0.084     4.453     0.200
     0.127     4.458     0.200
     0.202     6.035     0.200
     0.231     5.126     0.200
     0.655    12.730     0.200
     1.051    19.181     0.200
     0.034     3.804     0.200
     0.033     3.867     0.200
     0.039     4.246     0.200
     0.092     4.040     0.200
     0.099     4.146     0.200
     0.063     4.021     0.200
     0.200     4.724     0.200
     0.246     5.721     0.200
     0.249     5.493     0.200
     0.221     6.222     0.200
     0.647    13.104     0.200
     1.035    19.444     0.200
     0.019     3.515     0.200
     0.090     3.617     0.200
     0.148     3.505     0.200
     0.153     4.295     0.200
     0.137     3.685     0.200
     0.153     2.944     0.200
     0.163     3.854     0.200
     0.203     4.519     0.200
     0.204     4.355     0.200
     0.213     4.537     0.200
     0.291     6.797     0.200
     0.422     8.008     0.200
     1.283    25.253     0.200
     2.502    46.033     0.200
     2.636    47.964     0.200
     2.901    54.476     0.200
     0.020     3.282     0.200
     0.080     2.905     0.200
     0.086     3.544     0.200
     0.139     3.637     0.200
     0.150     4.075     0.200
     0.146     3.385     0.200
     0.163     3.723     0.200
     0.199     3.785     0.200
     0.269     5.556     0.200
     0.292     6.997     0.200
     0.422     7.917     0.200
     0.822    17.049     0.200
     0.057     3.736     0.200
     0.055     3.224     0.200
     0.057     3.105     0.200
     0.127     3.860     0.200
     0.201     3.867     0.200
     0.232     4.799     0.200
     0.200     4.861     0.200
     0.280     5.817     0.200
     0.818    16.170     0.200
     0.061     2.925     0.200
     0.035     2.922     0.200
     0.113     3.614     0.200
     0.113     3.816     0.200
     0.060     3.636     0.200
     0.181     3.225     0.200
     0.220     3.964     0.200
     0.224     4.618     0.200
     0.224     4.817     0.200
     0.261     5.591     0.200
     0.272     5.663     0.200
     0.272     5.862     0.200
     0.395     8.024     0.200
     0.674    14.463     0.200
     0.830    17.899     0.200
     0.104     3.735     0.200
     0.121     3.630     0.200
     0.158     4.370     0.200
     0.185     4.596     0.200
     0.190     5.177     0.200
     0.230     4.776     0.200
     0.249     5.202     0.200
     0.409     8.044     0.200
     0.561    10.163     0.200
     0.079     3.406     0.200
     0.148     2.597     0.200
     0.191     4.504     0.200
     0.246     4.957     0.200
     0.266     5.625     0.200
     0.282     5.733     0.200
     0.261     5.582     0.200
     0.230     6.354     0.200
     0.652    14.216     0.200
     0.814    17.073     0.200
     0.033     3.269     0.200
     0.034     2.658     0.200
     0.055     3.731     0.200
     0.122     4.100     0.200
     0.227     4.606     0.200
     0.232     5.175     0.200
     0.191     5.927     0.200
     0.255     5.780     0.200
     0.279     5.557     0.200
     0.267     5.762     0.200
     0.299     6.107     0.200
     0.551    10.623     0.200
     0.675    12.784     0.200
     0.829    17.633     0.200
     1.139    23.167     0.200
     0.060     2.991     0.200
     0.032     3.216     0.200
     0.036     2.975     0.200
     0.056     3.937     0.200
     0.110     4.191     0.200
     0.120     4.183     0.200
     0.189     3.035     0.200
     0.193     5.437     0.200
     0.230     4.809     0.200
     0.254     5.726     0.200
     0.266     5.782     0.200
     0.298     6.415     0.200
     0.551    10.317     0.200
     0.835    18.252     0.200
     0.044     3.395     0.200
     0.082     3.053     0.200
     0.111     4.346     0.200
     0.183     3.367     0.200
     0.241     6.721     0.200
     0.303     6.469     0.200
     0.305     6.545     0.200
     0.836    16.345     0.200
     2.067    39.779     0.200
     2.530    44.883     0.200
     2.597    47.294     0.200
     2.836    49.005     0.200
     2.068    39.775     0.200
     2.916    50.581     0.200
     0.020     3.521     0.200
     0.048     3.096     0.200
     0.057     2.894     0.200
     0.089     3.649     0.200
     0.083     3.897     0.200
     0.112     4.023     0.200
     0.196     3.695     0.200
     0.200     4.352     0.200
     0.253     4.950     0.200
     0.221     6.033     0.200
     0.265     5.676     0.200
     0.819    16.845     0.200
     0.017     3.879     0.200
     0.034     3.578     0.200
     0.111     3.911     0.200
     0.267     6.064     0.200
     0.198     5.465     0.200
     0.277     5.842     0.200
     0.280     5.952     0.200
     0.304     6.133     0.200
     0.560    10.993     0.200
     0.677    13.170     0.200
     0.839    18.284     0.200
     0.833    17.399     0.200
     1.009    20.282     0.200
     2.042    39.242     0.200
     2.567    47.115     0.200
     2.700    49.563     0.200
     0.113     3.756     0.200
     0.133     4.180     0.200
     0.226     4.705     0.200
     0.194     5.240     0.200
     0.283     5.591     0.200
     0.291     6.247     0.200
     0.289     5.793     0.200
     0.844    17.046     0.200
     0.997    19.746     0.200
     1.053    21.649     0.200
     1.112    20.165     0.200
     2.354    45.773     0.200
     2.572    48.134     0.200
     0.015     3.872     0.200
     0.049     3.473     0.200
     0.096     3.431     0.200
     0.203     4.275     0.200
     0.207     4.105     0.200
     0.262     5.894     0.200
     0.261     5.503     0.200
     0.270     5.646     0.200
     0.213     5.088     0.200
     0.292     5.919     0.200
     0.822    17.162     0.200
     0.019     3.379     0.200
     0.032     3.127     0.200
     0.113     3.609     0.200
     0.179     3.510     0.200
     0.221     4.622     0.200
     0.225     4.772     0.200
     0.196     5.022     0.200
     0.277     5.768     0.200
     0.278     6.113     0.200
     0.304     6.049     0.200
     0.678    13.684     0.200
     0.840    18.299     0.200
     0.047     3.197     0.200
     0.066     2.876     0.200
     0.105     3.590     0.200
     0.180     3.894     0.200
     0.204     4.467     0.200
     0.209     4.341     0.200
     0.230     5.351     0.200
     0.240     5.095     0.200
     0.268     5.162     0.200
     0.220     5.702     0.200
     0.043     3.820     0.200
     0.088     4.109     0.200
     0.063     3.481     0.200
     0.177     4.005     0.200
     0.203     4.456     0.200
     0.208     4.404     0.200
     0.234     5.232     0.200
     0.243     5.278     0.200
     0.250     5.907     0.200
     0.270     5.638     0.200
     0.219     5.873     0.200
     0.052     1.945     0.200
     0.029     2.514     0.200
     0.043     2.346     0.200
     0.066     3.255     0.200
     0.106     3.503     0.200
     0.111     3.359     0.200
     0.216     4.133     0.200
     0.220     4.350     0.200
     0.203     4.385     0.200
     0.251     5.009     0.200
     0.262     5.134     0.200
     0.268     6.426     0.200
     0.291     5.369     0.200
     0.051     3.097     0.200
     0.055     3.052     0.200
     0.127     4.132     0.200
     0.077     4.034     0.200
     0.119     2.303     0.200
     0.181     4.920     0.200
     0.239     5.277     0.200
     0.193     5.426     0.200
     0.311     5.569     0.200
     0.327     6.908     0.200
     0.355     7.100     0.200
     1.065    20.264     0.200
     2.403    46.156     0.200
     2.583    47.047     0.200
     2.716    49.004     0.200
     0.021     3.770     0.200
     0.045     3.386     0.200
     0.064     3.513     0.200
     0.103     4.012     0.200
     0.052     4.012     0.200
     0.052     4.408     0.200
     0.111     4.275     0.200
     0.208     5.891     0.200
     0.291     6.115     0.200
     0.391     8.050     0.200
     1.017    18.944     0.200
     1.058    21.632     0.200
     1.130    21.728     0.200
     1.130    21.829     0.200
     1.178    23.270     0.200
     2.031    40.311     0.200
     2.332    45.300     0.200
     2.557    44.173     0.200
     2.626    45.367     0.200
     2.958    51.500     0.200
     2.334    45.282     0.200
     2.821    49.171     0.200
     0.050     2.965     0.200
     0.051     3.265     0.200
     0.032     2.865     0.200
     0.046     2.709     0.200
     0.103     3.672     0.200
     0.067     3.782     0.200
     0.111     3.832     0.200
     0.216     3.627     0.200
     0.213     5.499     0.200
     0.220     4.572     0.200
     0.204     5.816     0.200
     0.259     5.725     0.200
     0.266     5.435     0.200
     0.288     5.882     0.200
     0.382     7.846     0.200
     0.062     2.950     0.200
     0.062     3.843     0.200
     0.017     3.782     0.200
     0.035     3.368     0.200
     0.062     3.872     0.200
     0.110     4.002     0.200
     0.199     5.836     0.200
     0.213     5.251     0.200
     0.222     4.766     0.200
     0.275     5.959     0.200
     0.274     6.332     0.200
     0.302     6.200     0.200
     0.399     8.170     0.200
     0.051     3.816     0.200
     0.050     2.393     0.200
     0.026     3.776     0.200
     0.046     3.341     0.200
     0.069     3.880     0.200
     0.106     3.942     0.200
     0.216     4.816     0.200
     0.208     5.838     0.200
     0.207     5.995     0.200
     0.262     5.744     0.200
     0.264     5.641     0.200
     0.289     6.000     0.200
     1.183    23.375     0.200
     0.023     3.482     0.200
     0.031     4.191     0.200
     0.061     4.122     0.200
     0.070     3.431     0.200
     0.112     4.149     0.200
     0.087     3.139     0.200
     0.102     4.263     0.200
     0.208     4.528     0.200
     0.204     5.388     0.200
     0.189     3.039     0.200
     0.201     3.901     0.200
     0.207     5.039     0.200
     0.216     5.025     0.200
     0.237     4.979     0.200
     0.248     5.658     0.200
     0.232     6.336     0.200
     0.342     6.965     0.200
     1.083    20.382     0.200
     0.011     3.869     0.200
     0.076     4.100     0.200
     0.078     3.874     0.200
     0.037     3.753     0.200
     0.106     3.946     0.200
     0.066     4.220     0.200
     0.220     5.620     0.200
     0.217     3.856     0.200
     0.209     5.318     0.200
     0.281     6.263     0.200
     0.295     6.250     0.200
     0.316     6.596     0.200
     0.420     8.680     0.200
     0.059     2.862     0.200
     0.059     3.464     0.200
     0.019     4.228     0.200
     0.039     3.698     0.200
     0.116     4.084     0.200
     0.064     3.822     0.200
     0.108     4.006     0.200
     0.175     2.999     0.200
     0.215     3.237     0.200
     0.211     5.621     0.200
     0.202     5.895     0.200
     0.272     5.877     0.200
     0.298     6.069     0.200
     0.396     8.128     0.200
     0.037     3.688     0.200
     0.035     2.062     0.200
     0.059     1.888     0.200
     0.095     3.714     0.200
     0.100     3.511     0.200
     0.081     3.728     0.200
     0.207     4.439     0.200
     0.218     6.174     0.200
     0.252     5.532     0.200
     0.276     5.646     0.200
     0.050     3.112     0.200
     0.015     3.118     0.200
     0.109     3.985     0.200
     0.160     4.525     0.200
     0.159     4.940     0.200
     0.251     6.593     0.200
     0.262     5.241     0.200
     0.300     6.193     0.200
     0.315     6.521     0.200
     0.433     8.547     0.200
     0.032     3.777     0.200
     0.044     3.787     0.200
     0.099     4.083     0.200
     0.033     3.768     0.200
     0.066     3.989     0.200
     0.090     4.003     0.200
     0.160     2.689     0.200
     0.195     4.175     0.200
     0.244     5.708     0.200
     0.253     5.497     0.200
     0.246     5.319     0.200
     0.046     2.767     0.200
     0.061     2.901     0.200
     0.029     2.783     0.200
     0.103     3.847     0.200
     0.050     2.132     0.200
     0.175     2.329     0.200
     0.213     4.698     0.200
     0.208     3.189     0.200
     0.258     4.924     0.200
     0.249     5.151     0.200
     0.053     2.942     0.200
     0.056     3.490     0.200
     0.073     3.008     0.200
     0.104     4.026     0.200
     0.042     2.567     0.200
     0.063     3.651     0.200
     0.220     3.789     0.200
     0.225     4.922     0.200
     0.249     5.201     0.200
     0.260     5.347     0.200
     0.054     2.241     0.200
     0.054     3.543     0.200
     0.024     3.684     0.200
     0.042     2.376     0.200
     0.066     3.700     0.200
     0.108     3.704     0.200
     0.219     4.693     0.200
     0.203     5.705     0.200
     0.255     5.600     0.200
     0.265     5.579     0.200
     0.293     5.961     0.200
     0.084     4.087     0.200
     0.120     2.324     0.200
     0.128     4.742     0.200
     0.155     3.413     0.200
     0.162     4.262     0.200
     0.136     4.750     0.200
     0.142     3.166     0.200
     0.154     4.632     0.200
     0.193     4.428     0.200
     0.210     5.578     0.200
     0.264     5.618     0.200
     0.217     5.938     0.200
     0.298     6.744     0.200
     0.295     5.952     0.200
     0.287     4.575     0.200
     0.285     6.259     0.200
     1.182    22.000     0.200
     2.597    47.424     0.200
     0.050     3.772     0.200
     0.075     3.289     0.200
     0.062     3.042     0.200
     0.067     2.883     0.200
     0.079     4.132     0.200
     0.126     4.310     0.200
     0.220     5.202     0.200
     0.222     4.176     0.200
     0.228     4.926     0.200
     0.208     5.985     0.200
     0.270     5.693     0.200
     0.353     7.330     0.200
     0.020     3.710     0.200
     0.104     3.632     0.200
     0.066     3.078     0.200
     0.044     3.232     0.200
     0.053     3.823     0.200
     0.069     3.740     0.200
     0.215     4.738     0.200
     0.207     5.833     0.200
     0.267     5.626     0.200
     0.293     5.928     0.200
     1.058    21.120     0.200
     0.047     2.516     0.200
     0.047     3.928     0.200
     0.049     2.687     0.200
     0.072     3.832     0.200
     0.105     3.919     0.200
     0.210     3.608     0.200
     0.215     4.766     0.200
     0.209     5.923     0.200
     0.249     5.354     0.200
     0.259     5.542     0.200
     0.286     5.835     0.200
     0.383     7.893     0.200
     1.064    21.234     0.200
     2.024    37.942     0.200
     2.557    47.224     0.200
     0.014     2.113     0.200
     0.059     2.889     0.200
     0.057     3.435     0.200
     0.068     3.624     0.200
     0.103     3.488     0.200
     0.211     3.708     0.200
     0.215     4.311     0.200
     0.205     4.940     0.200
     0.264     5.241     0.200
     0.273     5.044     0.200
     1.171    23.307     0.200
     0.029     3.050     0.200
     0.035     3.286     0.200
     0.069     1.894     0.200
     0.087     3.583     0.200
     0.108     3.439     0.200
     0.225     4.861     0.200
     0.205     3.703     0.200
     0.211     4.136     0.200
     0.205     5.198     0.200
     0.354     6.468     0.200
     0.009     3.257     0.200
     0.041     3.085     0.200
     0.077     1.961     0.200
     0.073     3.482     0.200
     0.103     3.391     0.200
     0.070     3.817     0.200
     0.205     5.564     0.200
     0.214     3.968     0.200
     0.216     4.495     0.200
     0.204     5.795     0.200
     0.286     6.187     0.200
     0.294     5.842     0.200
     0.314     6.119     0.200
     1.151    23.234     0.200
     2.059    39.932     0.200
     2.562    46.058     0.200
     2.695    49.509     0.200
     2.762    51.734     0.200
     2.059    39.928     0.200
     2.950    55.533     0.200
     0.009     2.211     0.200
     0.010     3.552     0.200
     0.060     2.422     0.200
     0.087     3.017     0.200
     0.088     2.591     0.200
     0.109     3.735     0.200
     0.180     3.309     0.200
     0.186     3.787     0.200
     0.182     4.794     0.200
     0.222     4.714     0.200
     0.227     4.832     0.200
     0.247     4.698     0.200
     0.244     5.663     0.200
     0.331     6.049     0.200
     0.036     3.841     0.200
     0.038     2.305     0.200
     0.030     2.695     0.200
     0.062     2.426     0.200
     0.090     3.559     0.200
     0.086     3.809     0.200
     0.191     5.717     0.200
     0.194     3.281     0.200
     0.199     4.418     0.200
     0.224     5.935     0.200
     0.248     5.551     0.200
     0.255     5.473     0.200
     0.277     5.520     0.200
     0.357     6.282     0.200
     1.134    23.115     0.200
     2.020    38.373     0.200
     2.541    47.292     0.200
     2.674    48.738     0.200
     0.029     1.760     0.200
     0.062     3.285     0.200
     0.035     1.592     0.200
     0.078     2.594     0.200
     0.057     3.244     0.200
     0.112     3.816     0.200
     0.118     3.447     0.200
     0.186     3.075     0.200
     0.194     4.661     0.200
     0.220     5.433     0.200
     0.228     4.647     0.200
     0.257     5.434     0.200
     0.268     5.377     0.200
     0.299     5.682     0.200
     0.050     1.592     0.200
     0.050     2.760     0.200
     0.065     2.421     0.200
     0.025     1.486     0.200
     0.046     2.338     0.200
     0.107     3.833     0.200
     0.105     3.438     0.200
     0.070     3.534     0.200
     0.175     2.883     0.200
     0.211     3.216     0.200
     0.207     5.008     0.200
     0.215     4.153     0.200
     0.253     5.530     0.200
     0.207     5.129     0.200
     0.263     5.390     0.200
     0.264     6.095     0.200
     0.289     5.600     0.200
     0.049     2.339     0.200
     0.030     3.279     0.200
     0.142     2.543     0.200
     0.144     3.972     0.200
     0.158     2.860     0.200
     0.184     4.898     0.200
     0.119     3.890     0.200
     0.188     4.936     0.200
     0.243     4.114     0.200
     0.291     6.309     0.200
     0.302     6.032     0.200
     0.317     6.211     0.200
     0.337     6.841     0.200
     0.378     7.104     0.200
     0.076     3.831     0.200
     0.076     3.676     0.200
     0.054     3.574     0.200
     0.086     3.017     0.200
     0.133     4.324     0.200
     0.117     3.785     0.200
     0.117     4.004     0.200
     0.190     5.591     0.200
     0.278     5.736     0.200
     0.278     6.034     0.200
     0.289     6.246     0.200
     0.316     6.424     0.200
     0.412     8.409     0.200
     0.048     3.811     0.200
     0.063     2.380     0.200
     0.158     3.169     0.200
     0.159     4.557     0.200
     0.114     4.858     0.200
     0.172     4.814     0.200
     0.202     5.274     0.200
     0.198     5.377     0.200
     0.312     6.770     0.200
     0.336     7.021     0.200
     0.356     7.274     0.200
     0.395     8.171     0.200
     0.465     9.761     0.200
     0.055     2.573     0.200
     0.036     3.759     0.200
     0.149     3.779     0.200
     0.151     3.943     0.200
     0.165     3.297     0.200
     0.191     5.232     0.200
     0.194     5.110     0.200
     0.114     3.714     0.200
     0.248     4.570     0.200
     0.297     7.255     0.200
     0.308     6.053     0.200
     0.323     6.730     0.200
     0.343     6.823     0.200
     0.365     8.212     0.200
     0.076     4.351     0.200
     0.116     4.433     0.200
     0.115     4.300     0.200
     0.091     3.182     0.200
     0.124     4.695     0.200
     0.226     5.305     0.200
     0.198     5.430     0.200
     0.252     5.394     0.200
     0.313     6.494     0.200
     0.300     6.439     0.200
     0.049     2.491     0.200
     0.049     3.084     0.200
     0.026     2.953     0.200
     0.047     2.604     0.200
     0.106     3.869     0.200
     0.105     3.338     0.200
     0.071     3.330     0.200
     0.175     2.915     0.200
     0.210     4.007     0.200
     0.207     4.547     0.200
     0.214     3.955     0.200
     0.208     5.129     0.200
     0.252     5.018     0.200
     0.048     3.476     0.200
     0.029     2.818     0.200
     0.048     2.688     0.200
     0.103     3.799     0.200
     0.071     3.743     0.200
     0.106     3.250     0.200
     0.177     2.992     0.200
     0.210     3.600     0.200
     0.215     4.636     0.200
     0.207     5.385     0.200
     0.249     5.137     0.200
     0.259     5.386     0.200
     0.208     5.104     0.200
     0.262     6.246     0.200
     0.018     3.341     0.200
     0.074     3.384     0.200
     0.079     3.021     0.200
     0.092     3.476     0.200
     0.055     2.508     0.200
     0.083     3.772     0.200
     0.144     4.122     0.200
     0.148     2.713     0.200
     0.203     2.575     0.200
     0.205     4.548     0.200
     0.216     5.420     0.200
     0.291     6.219     0.200
     0.014     3.321     0.200
     0.066     2.518     0.200
     0.124     2.433     0.200
     0.149     3.524     0.200
     0.135     2.412     0.200
     0.153     3.313     0.200
     0.165     3.376     0.200
     0.143     3.894     0.200
     0.211     4.029     0.200
     0.225     4.031     0.200
     0.229     4.217     0.200
     0.022     2.145     0.200
     0.040     2.734     0.200
     0.091     3.146     0.200
     0.091     3.150     0.200
     0.110     3.620     0.200
     0.152     4.748     0.200
     0.212     5.734     0.200
     0.224     4.295     0.200
     0.222     3.620     0.200
     0.199     5.287     0.200
     0.289     6.839     0.200
     0.299     6.121     0.200
     0.307     5.931     0.200
     0.328     6.482     0.200
     2.073    40.520     0.200
     2.570    45.916     0.200
     0.057     3.681     0.200
     0.048     3.189     0.200
     0.065     2.287     0.200
     0.083     4.022     0.200
     0.107     3.304     0.200
     0.182     2.979     0.200
     0.205     5.207     0.200
     0.211     4.250     0.200
     0.219     5.390     0.200
     0.229     4.736     0.200
     0.250     5.682     0.200
     0.239     4.835     0.200
     0.268     4.963     0.200
     0.356     6.198     0.200
     1.125    22.721     0.200
     2.549    47.110     0.200
     0.058     1.974     0.200
     0.099     2.794     0.200
     0.167     3.498     0.200
     0.111     3.854     0.200
     0.192     4.986     0.200
     0.197     5.059     0.200
     0.251     3.769     0.200
     0.311     6.823     0.200
     0.324     6.417     0.200
     0.345     6.608     0.200
     0.387     7.737     0.200
     0.046     3.731     0.200
     0.022     2.745     0.200
     0.055     4.159     0.200
     0.110     3.724     0.200
     0.104     2.788     0.200
     0.120     4.304     0.200
     0.193     4.547     0.200
     0.200     4.467     0.200
     0.198     4.190     0.200
     0.197     4.511     0.200
     0.230     4.625     0.200
     0.226     5.163     0.200
     0.249     6.597     0.200
     0.036     2.704     0.200
     0.063     3.487     0.200
     0.108     3.565     0.200
     0.175     3.683     0.200
     0.211     6.263     0.200
     0.220     4.757     0.200
     0.200     5.390     0.200
     0.276     5.705     0.200
     0.383     6.253     0.200
     2.042    39.902     0.200
     2.565    45.796     0.200
     2.744    49.706     0.200
     0.046     3.504     0.200
     0.050     2.359     0.200
     0.073     3.697     0.200
     0.185     3.986     0.200
     0.212     4.611     0.200
     0.208     3.714     0.200
     0.205     5.501     0.200
     0.210     5.803     0.200
     0.259     5.427     0.200
     0.250     5.865     0.200
     0.285     5.731     0.200
     0.369     5.838     0.200
     0.385     7.692     0.200
     2.555    46.827     0.200
     0.007     3.711     0.200
     0.037     2.358     0.200
     0.065     3.928     0.200
     0.069     4.590     0.200
     0.075     3.417     0.200
     0.105     3.475     0.200
     0.166     4.355     0.200
     0.208     5.863     0.200
     0.202     5.933     0.200
     0.215     3.285     0.200
     0.218     5.246     0.200
     0.275     6.182     0.200
     0.284     6.027     0.200
     0.307     6.283     0.200
     0.410     8.422     0.200
     1.113    22.302     0.200
     2.563    48.375     0.200
     0.062     1.257     0.200
     0.078     1.563     0.200
     0.224     5.768     0.200
     0.310     6.164     0.200
     0.291     5.676     0.200
     0.296     5.722     0.200
     0.427     8.598     0.200
     1.090    22.157     0.200
     2.544    47.185     0.200
     0.026     3.167     0.200
     0.019     2.944     0.200
     0.055     3.360     0.200
     0.055     3.758     0.200
     0.082     2.912     0.200
     0.081     3.719     0.200
     0.089     3.725     0.200
     0.167     3.820     0.200
     0.189     5.535     0.200
     0.220     5.695     0.200
     0.285     6.046     0.200
     0.295     6.148     0.200
     0.321     6.340     0.200
     1.108    22.338     0.200
     0.033     3.033     0.200
     0.030     4.096     0.200
     0.036     3.088     0.200
     0.070     4.094     0.200
     0.095     4.126     0.200
     0.156     3.686     0.200
     0.191     4.385     0.200
     0.245     5.912     0.200
     0.232     6.482     0.200
     0.270     5.505     0.200
     0.056     3.228     0.200
     0.061     3.811     0.200
     0.026     2.918     0.200
     0.069     4.016     0.200
     0.098     3.671     0.200
     0.137     2.670     0.200
     0.137     4.007     0.200
     0.148     3.795     0.200
     0.183     3.783     0.200
     0.176     3.971     0.200
     0.186     3.811     0.200
     0.234     5.742     0.200
     0.275     5.759     0.200
     0.291     5.418     0.200
     0.361     7.311     0.200
     0.020     2.128     0.200
     0.059     3.316     0.200
     0.059     3.267     0.200
     0.038     1.411     0.200
     0.063     3.617     0.200
     0.176     3.444     0.200
     0.180     3.658     0.200
     0.172     4.513     0.200
     0.211     4.786     0.200
     0.201     5.608     0.200
     0.216     3.630     0.200
     0.220     4.935     0.200
     0.261     5.686     0.200
     0.298     5.923     0.200
     0.036     3.455     0.200
     0.084     4.281     0.200
     0.089     3.441     0.200
     0.101     4.447     0.200
     0.117     4.589     0.200
     0.185     5.031     0.200
     0.192     3.735     0.200
     0.194     4.699     0.200
     0.265     5.936     0.200
     0.232     6.805     0.200
     0.302     6.979     0.200
     0.315     6.725     0.200
     0.375     7.528     0.200
     1.203    23.235     0.200
     2.375    45.365     0.200
     2.539    45.647     0.200
     2.671    49.602     0.200
     2.845    51.879     0.200
     2.376    45.348     0.200
     2.925    54.144     0.200
     0.044     3.695     0.200
     0.031     2.736     0.200
     0.053     1.881     0.200
     0.075     3.956     0.200
     0.177     4.507     0.200
     0.174     3.110     0.200
     0.187     3.714     0.200
     0.177     4.923     0.200
     0.207     3.683     0.200
     0.204     4.515     0.200
     0.247     5.587     0.200
     0.212     5.845     0.200
     0.258     6.385     0.200
     0.282     5.973     0.200
     0.366     6.124     0.200
     0.363     7.100     0.200
     0.037     3.166     0.200
     0.071     3.374     0.200
     0.080     3.920     0.200
     0.085     3.006     0.200
     0.105     4.130     0.200
     0.127     3.217     0.200
     0.125     4.743     0.200
     0.116     3.947     0.200
     0.179     4.614     0.200
     0.187     3.526     0.200
     0.188     4.148     0.200
     0.259     5.679     0.200
     0.236     6.377     0.200
     0.299     6.496     0.200
     0.310     6.162     0.200
     0.369     7.244     0.200
     2.065    40.609     0.200
     2.534    45.134     0.200
     0.028     3.851     0.200
     0.050     3.004     0.200
     0.068     2.290     0.200
     0.087     4.009     0.200
     0.168     4.558     0.200
     0.181     3.373     0.200
     0.203     3.613     0.200
     0.203     4.111     0.200
     0.209     4.559     0.200
     0.202     5.124     0.200
     0.190     5.301     0.200
     0.248     5.846     0.200
     0.265     5.600     0.200
     1.159    23.455     0.200
     2.002    37.125     0.200
     2.546    46.272     0.200
     2.680    48.214     0.200
     0.028     3.023     0.200
     0.032     3.880     0.200
     0.054     3.415     0.200
     0.049     3.080     0.200
     0.068     3.256     0.200
     0.087     3.733     0.200
     0.167     4.600     0.200
     0.180     3.203     0.200
     0.208     4.425     0.200
     0.202     5.189     0.200
     0.208     4.226     0.200
     0.189     4.959     0.200
     0.201     4.204     0.200
     0.189     5.061     0.200
     0.265     5.454     0.200
     0.350     6.964     0.200
     0.075     3.830     0.200
     0.013     3.523     0.200
     0.076     3.191     0.200
     0.078     2.364     0.200
     0.049     3.699     0.200
     0.078     3.853     0.200
     0.154     3.030     0.200
     0.142     4.671     0.200
     0.147     4.355     0.200
     0.198     5.262     0.200
     0.210     4.609     0.200
     0.313     6.268     0.200
     0.313     6.705     0.200
     0.065     3.889     0.200
     0.049     4.635     0.200
     0.108     3.880     0.200
     0.114     4.615     0.200
     0.095     3.631     0.200
     0.184     5.425     0.200
     0.247     6.147     0.200
     0.255     5.370     0.200
     0.248     6.590     0.200
     0.251     6.916     0.200
     0.285     7.521     0.200
     0.291     6.179     0.200
     0.323     6.978     0.200
     0.325     5.797     0.200
     0.423     8.829     0.200
     0.041     3.876     0.200
     0.044     2.949     0.200
     0.083     3.511     0.200
     0.026     3.467     0.200
     0.063     3.526     0.200
     0.165     4.585     0.200
     0.090     4.048     0.200
     0.190     3.955     0.200
     0.194     4.519     0.200
     0.185     5.407     0.200
     0.194     4.288     0.200
     0.157     4.349     0.200
     0.168     5.601     0.200
     0.247     5.687     0.200
     0.281     5.722     0.200
     1.173    19.878     0.200
     2.538    46.954     0.200
     2.606    48.249     0.200
     3.503    62.085     0.200
     0.023     2.972     0.200
     0.046     2.504     0.200
     0.072     2.402     0.200
     0.094     3.152     0.200
     0.094     3.481     0.200
     0.169     3.470     0.200
     0.179     4.140     0.200
     0.198     3.875     0.200
     0.192     3.598     0.200
     0.263     5.057     0.200
     0.084     2.292     0.200
     0.171     2.228     0.200
     0.187     3.591     0.200
     0.230     5.291     0.200
     1.144    22.626     0.200
     2.529    46.964     0.200
     0.567    12.418     0.200
     3.062    55.336     0.200
     0.688    14.409     0.200
     1.632    33.292     0.200
     1.861    36.619     0.200
     2.470    44.510     0.200
     2.381    44.754     0.200
     1.168    23.066     0.200
     2.134    39.292     0.200
     2.429    47.451     0.200
     3.036    55.508     0.200
     3.408    60.426     0.200
     0.842    16.520     0.200
     1.538    29.701     0.200
     1.788    35.482     0.200
     2.280    42.846     0.200
     2.362    43.484     0.200
     0.773    15.671     0.200
     0.825    16.767     0.200
     1.715    32.377     0.200
     2.374    41.290     0.200
     2.459    45.393     0.200
     0.997    20.567     0.200
     1.786    34.590     0.200
     0.697    13.967     0.200
     1.760    35.857     0.200
     1.949    37.850     0.200
     3.517    66.298     0.200
     0.626    13.433     0.200
     0.609    11.865     0.200
     0.950    18.894     0.200
     2.187    40.419     0.200
     2.181    40.125     0.200
     2.265    41.247     0.200
     0.610    13.845     0.200
     1.168    22.902     0.200
     1.746    35.453     0.200
     1.950    37.976     0.200
     2.175    41.444     0.200
     2.672    49.823     0.200
     2.699    50.381     0.200
     2.840    49.788     0.200
     3.173    56.896     0.200
     0.486    10.925     0.200
     0.677    15.293     0.200
     2.312    39.925     0.200
     2.513    44.573     0.200
     2.414    44.920     0.200
     0.209     6.323     0.200
     2.245    40.704     0.200
     2.214    42.165     0.200
     2.444    46.396     0.200
     2.627    47.449     0.200
     0.269     5.870     0.200
     1.311    24.661     0.200
     2.012    36.978     0.200
     2.181    40.455     0.200
     2.572    45.446     0.200
     2.741    48.214     0.200
     2.774    49.353     0.200
     3.001    50.937     0.200
     3.507    65.230     0.200
     0.766    14.071     0.200
     2.030    38.135     0.200
     3.694    65.362     0.200
     4.400    80.268     0.200
     4.536    79.784     0.200
     0.677    13.059     0.200
     1.207    23.885     0.200
     0.388     8.354     0.200
     0.388     9.002     0.200
     0.956    19.787     0.200
     2.085    41.104     0.200
     1.472    27.029     0.200
     2.157    40.836     0.200
     2.884    50.457     0.200
     3.510    60.768     0.200
     3.994    69.091     0.200
     0.736    14.997     0.200
     1.991    38.205     0.200
     0.465     9.747     0.200
     2.387    42.019     0.200
     2.795    49.814     0.200
     0.608    13.661     0.200
     1.759    34.335     0.200
     2.072    39.674     0.200
     2.157    41.090     0.200
     2.398    42.977     0.200
     2.613    47.543     0.200
     1.724    33.619     0.200
     1.866    37.770     0.200
     1.994    37.671     0.200
     2.081    38.655     0.200
     2.582    45.413     0.200
     0.521     8.912     0.200
     1.246    23.713     0.200
     2.137    41.268     0.200
     2.711    50.397     0.200
     1.881    35.198     0.200
     2.151    38.779     0.200
     0.786    16.386     0.200
     1.765    33.585     0.200
     1.874    34.821     0.200
     1.988    38.886     0.200
     2.307    42.705     0.200
     0.525    12.144     0.200
     2.254    41.141     0.200
     1.879    35.225     0.200
     2.288    41.659     0.200
     0.675    14.380     0.200
     1.282    25.163     0.200
     2.290    42.642     0.200
     0.627    13.438     0.200
     0.605    13.789     0.200
     1.179    21.955     0.200
     1.652    32.835     0.200
     0.577    11.686     0.200
     0.643    12.458     0.200
     1.303    25.520     0.200
     2.297    42.552     0.200
     0.327     7.769     0.200
     1.350    25.369     0.200
     2.521    46.512     0.200
     2.533    47.568     0.200
     3.490    65.023     0.200
     0.653    14.114     0.200
     2.142    42.164     0.200
     0.687    14.612     0.200
     2.212    39.922     0.200
     0.676    13.586     0.200
     2.269    43.302     0.200
     2.442    46.983     0.200
     0.391     7.383     0.200
     2.185    40.880     0.200
     0.575    10.163     0.200
     0.649    13.826     0.200
     1.087    20.778     0.200
     1.857    36.884     0.200
     2.290    41.333     0.200
     0.476    10.698     0.200
     2.103    38.007     0.200
     0.503    11.197     0.200
     0.606    12.296     0.200
     1.761    34.110     0.200
     1.761    35.079     0.200
     2.826    50.179     0.200
     4.015    72.807     0.200
     0.241     6.388     0.200
     1.913    35.233     0.200
     1.924    34.414     0.200
     1.812    32.217     0.200
     2.044    35.762     0.200
     2.583    45.477     0.200
     0.602    12.522     0.200
     2.107    38.691     0.200
     2.107    41.238     0.200
     4.683    82.182     0.200
     2.091    40.850     0.200
     2.115    36.567     0.200
     3.096    55.954     0.200
     3.096    56.095     0.200
     0.851    16.555     0.200
     2.435    43.639     0.200
     2.506    43.851     0.200
     0.769    15.303     0.200
     2.025    37.165     0.200
     0.718    16.270     0.200
     0.839    17.823     0.200
     1.750    34.773     0.200
     1.979    38.648     0.200
     2.497    44.183     0.200
     2.565    44.596     0.200
     0.210     5.659     0.200
     2.632    46.904     0.200
     0.887    17.147     0.200
     0.943    19.293     0.200
     1.199    23.342     0.200
     1.623    31.199     0.200
     1.812    34.589     0.200
     2.047    38.359     0.200
     0.604    10.603     0.200
     0.673    14.222     0.200
     0.969    20.791     0.200
     1.650    33.843     0.200
     2.110    40.911     0.200
     2.200    42.429     0.200
     2.212    39.685     0.200
     3.355    59.842     0.200
     2.238    41.316     0.200
     0.641    13.830     0.200
     2.237    40.634     0.200
     0.655    13.888     0.200
     2.115    38.110     0.200
     2.439    42.033     0.200
     2.719    48.022     0.200
     0.325     6.751     0.200
     2.953    53.549     0.200
     2.976    52.471     0.200
     0.484     9.611     0.200
     1.681    33.048     0.200
     0.924    17.823     0.200
     2.081    38.254     0.200
     3.284    61.075     0.200
     1.232    24.206     0.200
     2.472    45.780     0.200
     0.606    11.820     0.200
     0.707    14.799     0.200
     1.620    32.029     0.200
     2.183    38.919     0.200
     0.655    12.948     0.200
     0.804    16.410     0.200
     2.329    42.754     0.200
     2.442    44.876     0.200
     2.494    43.218     0.200
     2.494    44.769     0.200
     0.979    19.404     0.200
     1.504    28.490     0.200
     2.471    46.416     0.200
     0.219     5.497     0.200
     0.240     5.609     0.200
     0.317     7.201     0.200
     0.338     7.514     0.200
     0.377     8.354     0.200
     0.576    12.226     0.200
     0.689    14.178     0.200
     0.689    14.998     0.200
     0.889    18.934     0.200
     1.032    21.755     0.200
     0.235     6.755     0.200
     0.261     6.786     0.200
     0.291     7.028     0.200
     0.363     8.571     0.200
     0.112     4.480     0.200
     0.248     6.526     0.200
     0.392     9.264     0.200
     0.419     9.295     0.200
     0.468    10.318     0.200
     0.495    11.083     0.200
     0.494    10.753     0.200
     0.596    12.709     0.200
     0.609    13.436     0.200
     0.630    13.675     0.200
     0.669    14.344     0.200
     0.804    17.113     0.200
     0.833    17.798     0.200
     0.832    17.809     0.200
     0.945    20.054     0.200
     1.035    21.333     0.200
     0.468     8.945     0.200
     1.826    36.378     0.200
     0.103     4.722     0.200
     0.117     4.669     0.200
     0.396     8.912     0.200
     0.420     9.682     0.200
     0.474    10.475     0.200
     0.494    10.864     0.200
     0.495    10.729     0.200
     0.599    12.877     0.200
     0.614    13.588     0.200
     0.635    14.227     0.200
     0.670    14.071     0.200
     0.205     5.256     0.200
     0.205     5.343     0.200
     0.280     6.593     0.200
     0.330     7.437     0.200
     0.329     7.596     0.200
     0.384     8.761     0.200
     0.513    11.388     0.200
     0.539    11.342     0.200
     0.554    11.915     0.200
     0.582    12.441     0.200
     0.653    14.286     0.200
     0.161     4.461     0.200
     0.181     4.800     0.200
     0.305     6.865     0.200
     0.401     9.012     0.200
     0.636    13.388     0.200
     0.651    13.775     0.200
     0.783    16.889     0.200
     0.114     3.748     0.200
     0.180     4.542     0.200
     0.199     4.648     0.200
     0.266     6.175     0.200
     0.492    10.690     0.200
     0.554    11.712     0.200
     0.702    14.668     0.200
     0.715    14.842     0.200
     0.949    19.835     0.200
     1.001    21.050     0.200
     0.998    21.149     0.200
     1.122    21.996     0.200
     0.071     4.171     0.200
     0.235     5.184     0.200
     0.325     7.082     0.200
     0.404     8.743     0.200
     0.470    10.551     0.200
     0.611    13.200     0.200
     0.676    14.146     0.200
     0.827    17.274     0.200
     0.863    17.890     0.200
     1.087    21.058     0.200
     1.098    22.608     0.200
     0.248     5.031     0.200
     0.266     6.116     0.200
     0.358     6.965     0.200
     0.465    10.099     0.200
     0.717    15.065     0.200
     0.864    18.272     0.200
     0.879    17.857     0.200
     1.285    25.615     0.200
     0.976    21.089     0.200
     1.419    27.497     0.200
     1.511    28.012     0.200
     1.766    34.675     0.200
     2.042    40.584     0.200
     2.105    41.489     0.200
     2.465    46.452     0.200
     2.517    46.003     0.200
     2.626    46.997     0.200
     2.626    49.224     0.200
     3.434    59.985     0.200
     0.052     2.270     0.200
     0.200     4.463     0.200
     0.340     6.499     0.200
     0.339     6.576     0.200
     0.377     7.625     0.200
     0.766    16.072     0.200
     1.197    25.050     0.200
     1.223    25.702     0.200
     1.224    25.423     0.200
     1.290    26.031     0.200
     0.206     4.723     0.200
     0.224     5.204     0.200
     0.268     5.936     0.200
     0.307     6.651     0.200
     0.329     7.376     0.200
     0.366     7.707     0.200
     0.560    11.794     0.200
     0.639    13.502     0.200
     0.700    14.690     0.200
     0.904    18.796     0.200
     0.164     3.997     0.200
     0.180     4.123     0.200
     0.209     4.409     0.200
     0.356     7.529     0.200
     0.441     9.643     0.200
     0.623    13.386     0.200
     0.692    14.530     0.200
     1.018    20.913     0.200
     1.022    21.755     0.200
     0.287     6.864     0.200
     0.336     7.560     0.200
     0.361     7.829     0.200
     0.362     8.219     0.200
     0.409     9.363     0.200
     0.461    10.399     0.200
     0.575    12.515     0.200
     0.600    12.860     0.200
     0.624    13.512     0.200
     0.623    13.412     0.200
     0.673    14.282     0.200
     0.763    16.300     0.200
     0.780    16.877     0.200
     0.817    17.531     0.200
     0.197     4.224     0.200
     0.150     4.997     0.200
     0.231     5.556     0.200
     0.308     6.144     0.200
     0.440     9.698     0.200
     0.676    14.110     0.200
     0.830    17.051     0.200
     0.824    17.073     0.200
     1.113    22.979     0.200
     0.955    19.642     0.200
     1.384    26.481     0.200
     1.475    27.035     0.200
     1.777    35.356     0.200
     2.477    45.400     0.200
     2.943    51.908     0.200
     0.176     4.183     0.200
     0.159     4.670     0.200
     0.220     5.366     0.200
     0.288     6.266     0.200
     0.660    13.855     0.200
     0.810    16.777     0.200
     0.809    17.127     0.200
     1.214    24.337     0.200
     0.378     6.678     0.200
     1.371    25.518     0.200
     1.780    35.454     0.200
     0.192     5.381     0.200
     0.207     6.032     0.200
     0.350     8.027     0.200
     0.351     7.947     0.200
     0.430     9.385     0.200
     0.463    10.614     0.200
     0.543    11.626     0.200
     0.546    11.702     0.200
     0.624    13.061     0.200
     0.649    13.686     0.200
     0.693    14.707     0.200
     0.747    15.108     0.200
     0.753    15.497     0.200
     0.764    16.547     0.200
     0.415     8.760     0.200
     0.420     8.360     0.200
     0.457     9.971     0.200
     0.556    11.866     0.200
     0.581    12.205     0.200
     0.631    13.621     0.200
     0.737    15.326     0.200
     1.079    22.401     0.200
     0.309     6.680     0.200
     0.317     6.504     0.200
     0.328     7.446     0.200
     0.355     7.574     0.200
     0.408     8.552     0.200
     0.478    10.174     0.200
     0.538    10.753     0.200
     0.578    12.068     0.200
     0.677    14.282     0.200
     0.775    15.683     0.200
     0.773    16.191     0.200
     0.106     4.380     0.200
     0.163     5.288     0.200
     0.259     6.217     0.200
     0.337     7.822     0.200
     0.352     8.184     0.200
     0.540    11.772     0.200
     0.598    13.414     0.200
     0.625    13.710     0.200
     0.652    14.360     0.200
     0.136     4.219     0.200
     0.246     6.487     0.200
     0.286     6.931     0.200
     0.374     8.539     0.200
     0.397     8.860     0.200
     0.461    10.012     0.200
     0.490    10.594     0.200
     0.531    11.605     0.200
     0.536    11.526     0.200
     0.640    13.599     0.200
     0.639    13.569     0.200
     0.666    14.833     0.200
     0.712    14.513     0.200
     0.711    14.804     0.200
     0.858    17.730     0.200
     0.205     4.748     0.200
     0.197     5.230     0.200
     0.404     8.973     0.200
     0.402     8.490     0.200
     0.410     8.771     0.200
     0.474    10.255     0.200
     0.570    12.350     0.200
     0.672    13.916     0.200
     0.697    14.707     0.200
     0.727    15.613     0.200
     0.774    16.229     0.200
     0.882    17.022     0.200
     0.931    19.432     0.200
     0.295     6.341     0.200
     0.299     6.210     0.200
     0.348     7.343     0.200
     0.368     7.666     0.200
     0.395     8.310     0.200
     0.471    10.114     0.200
     0.500    10.616     0.200
     0.541    10.956     0.200
     0.575    12.037     0.200
     0.575    11.771     0.200
     0.666    13.795     0.200
     0.730    15.400     0.200
     0.758    16.422     0.200
     0.774    15.843     0.200
     0.831    17.793     0.200
     0.917    19.242     0.200
     1.099    23.260     0.200
     0.285     6.520     0.200
     0.290     6.902     0.200
     0.331     7.213     0.200
     0.355     7.742     0.200
     0.374     8.415     0.200
     0.453     9.841     0.200
     0.478    10.315     0.200
     0.524    10.882     0.200
     0.555    11.568     0.200
     0.557    11.745     0.200
     0.585    12.095     0.200
     0.645    13.707     0.200
     0.643    13.686     0.200
     0.709    14.937     0.200
     0.737    15.750     0.200
     0.785    16.226     0.200
     0.836    16.624     0.200
     0.810    17.446     0.200
     0.932    20.029     0.200
     1.109    23.152     0.200
     0.277     6.447     0.200
     0.285     6.923     0.200
     0.327     7.357     0.200
     0.347     7.454     0.200
     0.367     8.460     0.200
     0.449     9.851     0.200
     0.471    10.426     0.200
     0.517    11.036     0.200
     0.548    11.571     0.200
     0.585    12.802     0.200
     0.639    13.235     0.200
     0.700    14.521     0.200
     0.729    15.525     0.200
     0.827    16.660     0.200
     0.178     4.345     0.200
     0.169     5.049     0.200
     0.281     6.309     0.200
     0.438     9.076     0.200
     0.652    13.928     0.200
     0.804    16.622     0.200
     0.800    16.420     0.200
     1.043    21.960     0.200
     1.208    24.381     0.200
     0.078     4.241     0.200
     0.161     4.469     0.200
     0.251     6.180     0.200
     0.299     6.952     0.200
     0.317     7.284     0.200
     0.458     9.937     0.200
     0.473    10.337     0.200
     0.517    12.048     0.200
     0.526    11.167     0.200
     0.555    11.705     0.200
     0.569    12.625     0.200
     0.689    14.556     0.200
     0.148     5.339     0.200
     0.290     6.394     0.200
     0.295     6.683     0.200
     0.290     6.685     0.200
     0.579    11.740     0.200
     0.596    12.349     0.200
     0.739    14.939     0.200
     0.745    15.077     0.200
     0.787    16.558     0.200
     1.005    20.328     0.200
     0.235     6.533     0.200
     0.295     7.461     0.200
     0.301     6.952     0.200
     0.419    10.117     0.200
     0.444    10.210     0.200
     0.479    10.289     0.200
     0.541    11.612     0.200
     0.611    13.089     0.200
     0.652    13.750     0.200
     0.670    14.268     0.200
     0.707    15.155     0.200
     0.758    16.663     0.200
     0.772    16.438     0.200
     0.809    16.920     0.200
     0.939    18.594     0.200
     0.942    19.608     0.200
     0.125     4.031     0.200
     0.222     5.835     0.200
     0.287     6.808     0.200
     0.291     6.867     0.200
     0.308     6.882     0.200
     0.322     7.457     0.200
     0.353     8.283     0.200
     0.426     9.885     0.200
     0.624    12.949     0.200
     0.664    13.975     0.200
     0.713    15.033     0.200
     0.801    16.827     0.200
     0.192     5.476     0.200
     0.236     6.417     0.200
     0.285     6.944     0.200
     0.311     7.765     0.200
     0.347     7.953     0.200
     0.357     8.142     0.200
     0.362     8.428     0.200
     0.503    10.941     0.200
     0.518    11.279     0.200
     0.595    12.778     0.200
     0.606    12.978     0.200
     0.680    14.688     0.200
     0.706    14.949     0.200
     0.076     4.399     0.200
     0.197     4.610     0.200
     0.333     6.794     0.200
     0.401     8.635     0.200
     0.452     9.619     0.200
     0.543    11.808     0.200
     0.550    11.537     0.200
     0.607    13.362     0.200
     0.812    16.895     0.200
     0.811    17.443     0.200
     0.822    17.147     0.200
     0.930    19.707     0.200
     1.071    21.747     0.200
     1.095    22.399     0.200
     1.142    22.898     0.200
     0.291     7.826     0.200
     0.320     8.162     0.200
     0.383     8.822     0.200
     0.397     9.441     0.200
     0.443    10.220     0.200
     0.495    11.863     0.200
     0.520    11.964     0.200
     0.543    11.841     0.200
     0.538    11.303     0.200
     0.547    12.430     0.200
     0.605    12.886     0.200
     0.700    15.114     0.200
     0.715    15.139     0.200
     0.733    15.626     0.200
     0.772    16.531     0.200
     0.805    16.815     0.200
     0.871    17.626     0.200
     0.114     3.624     0.200
     0.152     4.424     0.200
     0.222     5.269     0.200
     0.326     7.724     0.200
     0.339     7.373     0.200
     0.377     8.634     0.200
     0.527    11.752     0.200
     0.612    13.239     0.200
     0.644    14.035     0.200
     0.753    15.730     0.200
     1.115    23.007     0.200
     0.775    16.622     0.200
     0.864    18.027     0.200
     1.760    31.127     0.200
     1.850    33.230     0.200
     2.247    42.400     0.200
     2.560    43.344     0.200
     2.563    47.230     0.200
     3.077    53.416     0.200
     3.077    53.986     0.200
     0.580    12.476     0.200
     0.991    20.859     0.200
     2.180    40.988     0.200
     2.214    39.864     0.200
     2.685    47.509     0.200
     0.183     3.935     0.200
     0.267     5.652     0.200
     0.284     5.963     0.200
     0.318     6.461     0.200
     0.357     7.109     0.200
     0.635    12.862     0.200
     0.779    16.285     0.200
     0.783    15.951     0.200
     0.820    16.638     0.200
     0.856    17.513     0.200
     0.894    18.276     0.200
     0.891    18.690     0.200
     0.936    19.704     0.200
     1.042    21.385     0.200
     1.031    21.380     0.200
     1.055    21.822     0.200
     1.155    24.083     0.200
     0.115     4.437     0.200
     0.216     4.906     0.200
     0.235     6.129     0.200
     0.252     6.290     0.200
     0.393     8.467     0.200
     0.421     9.001     0.200
     0.472    10.133     0.200
     0.599    12.374     0.200
     0.613    12.772     0.200
     0.634    13.732     0.200
     0.671    14.102     0.200
     0.670    14.739     0.200
     0.685    14.599     0.200
     0.882    18.237     0.200
     0.949    20.247     0.200
     1.008    20.781     0.200
     1.597    32.536     0.200
     1.656    31.686     0.200
     1.687    33.197     0.200
     0.180     4.565     0.200
     0.309     6.151     0.200
     0.282     6.623     0.200
     0.321     6.791     0.200
     0.322     7.031     0.200
     0.335     7.212     0.200
     0.380     8.879     0.200
     0.422     8.858     0.200
     0.488     9.509     0.200
     0.473    10.037     0.200
     0.489    10.732     0.200
     0.572    12.429     0.200
     0.665    13.936     0.200
     0.912    18.851     0.200
     1.051    21.373     0.200
     1.219    24.969     0.200
     1.241    25.662     0.200
     0.219     5.256     0.200
     0.300     6.897     0.200
     0.368     7.307     0.200
     0.364     7.494     0.200
     0.442     9.750     0.200
     0.539    11.178     0.200
     0.584    12.349     0.200
     0.737    14.871     0.200
     0.813    16.486     0.200
     0.963    20.361     0.200
     1.063    21.701     0.200
     1.666    33.555     0.200
     1.753    35.297     0.200
     1.770    35.627     0.200
     0.792    14.766     0.200
     1.930    37.392     0.200
     2.489    47.023     0.200
     2.714    51.442     0.200
     0.154     4.103     0.200
     0.192     4.380     0.200
     0.247     5.418     0.200
     0.325     6.744     0.200
     0.684    14.646     0.200
     0.702    14.005     0.200
     0.745    15.155     0.200
     0.749    14.905     0.200
     0.745    15.598     0.200
     0.803    16.330     0.200
     0.834    16.600     0.200
     0.899    18.294     0.200
     0.998    20.153     0.200
     1.037    21.847     0.200
     0.147     4.583     0.200
     0.155     4.917     0.200
     0.228     5.217     0.200
     0.402     8.416     0.200
     0.502    10.725     0.200
     0.593    12.422     0.200
     0.660    14.544     0.200
     0.681    13.571     0.200
     0.740    15.309     0.200
     0.772    15.854     0.200
     0.784    16.258     0.200
     0.799    16.100     0.200
     0.807    16.792     0.200
     0.882    18.614     0.200
     0.937    19.952     0.200
     1.044    21.030     0.200
     1.201    23.488     0.200
     0.072     2.476     0.200
     0.233     5.480     0.200
     0.277     5.656     0.200
     0.351     7.102     0.200
     0.372     8.219     0.200
     0.396     8.584     0.200
     0.418     9.257     0.200
     0.455     9.005     0.200
     0.470     9.276     0.200
     0.539    11.223     0.200
     0.545    12.270     0.200
     0.686    14.179     0.200
     0.736    16.240     0.200
     0.870    17.818     0.200
     0.977    20.053     0.200
     1.212    24.173     0.200
     0.090     4.067     0.200
     0.194     4.911     0.200
     0.290     6.662     0.200
     0.301     7.322     0.200
     0.329     7.365     0.200
     0.458     9.493     0.200
     0.511    11.325     0.200
     0.679    14.234     0.200
     0.692    14.190     0.200
     0.697    14.526     0.200
     0.698    14.974     0.200
     0.723    15.810     0.200
     0.854    18.376     0.200
     0.974    20.508     0.200
     0.105     3.439     0.200
     0.176     4.362     0.200
     0.320     7.206     0.200
     0.450     9.763     0.200
     0.493    10.507     0.200
     0.679    14.044     0.200
     0.688    14.195     0.200
     0.700    14.231     0.200
     0.717    14.703     0.200
     0.835    17.808     0.200
     0.160     4.601     0.200
     0.269     5.863     0.200
     0.255     6.476     0.200
     0.369     7.463     0.200
     0.430     9.454     0.200
     0.467     9.655     0.200
     0.469    10.640     0.200
     0.467    10.659     0.200
     0.476    10.997     0.200
     0.705    13.902     0.200
     0.997    20.295     0.200
     1.214    24.483     0.200
     1.955    38.493     0.200
     0.117     3.030     0.200
     0.162     4.067     0.200
     0.182     4.098     0.200
     0.334     7.074     0.200
     0.444     8.940     0.200
     0.479    10.224     0.200
     0.668    13.923     0.200
     0.665    14.234     0.200
     0.686    13.944     0.200
     0.694    15.068     0.200
     0.701    13.759     0.200
     0.711    14.350     0.200
     0.751    15.375     0.200
     0.821    17.212     0.200
     0.998    21.395     0.200
     0.173     4.369     0.200
     0.309     5.701     0.200
     0.288     6.342     0.200
     0.309     7.094     0.200
     0.314     6.583     0.200
     0.377     8.696     0.200
     0.404     8.303     0.200
     0.458     9.687     0.200
     0.479     9.374     0.200
     0.489    10.573     0.200
     0.559    11.862     0.200
     0.648    12.951     0.200
     0.688    14.422     0.200
     0.658    14.315     0.200
     0.707    14.600     0.200
     0.813    16.551     0.200
     0.827    16.846     0.200
     0.870    17.539     0.200
     0.895    17.940     0.200
     1.038    21.916     0.200
     1.087    22.303     0.200
     1.177    23.231     0.200
     1.211    24.965     0.200
     1.234    25.230     0.200
     1.678    33.984     0.200
     1.693    34.212     0.200
     1.737    34.699     0.200
     1.820    35.993     0.200
     1.873    37.527     0.200
     1.896    37.976     0.200
     0.860    19.077     0.200
     1.896    35.678     0.200
     2.055    38.505     0.200
     2.020    40.851     0.200
     2.450    43.849     0.200
     2.501    46.949     0.200
     0.157     4.854     0.200
     0.179     4.783     0.200
     0.269     7.146     0.200
     0.338     7.100     0.200
     0.338     7.558     0.200
     0.546    11.918     0.200
     0.686    14.629     0.200
     0.694    14.957     0.200
     0.699    15.103     0.200
     0.707    14.198     0.200
     0.707    15.716     0.200
     0.746    15.851     0.200
     0.753    15.441     0.200
     0.790    16.083     0.200
     0.817    16.841     0.200
     0.101     3.589     0.200
     0.234     5.897     0.200
     0.221     5.220     0.200
     0.523    10.815     0.200
     0.530    11.305     0.200
     0.535    11.598     0.200
     0.559    11.782     0.200
     0.587    12.494     0.200
     0.730    15.440     0.200
     0.739    15.387     0.200
     0.755    15.730     0.200
     0.768    15.430     0.200
     0.801    16.286     0.200
     0.856    18.211     0.200
     0.910    18.855     0.200
     0.905    18.663     0.200
     1.057    22.013     0.200
     1.140    23.246     0.200
     1.166    23.659     0.200
     0.117     5.292     0.200
     0.179     6.542     0.200
     0.256     7.107     0.200
     0.310     7.305     0.200
     0.338     8.066     0.200
     0.390     8.794     0.200
     0.424     9.766     0.200
     0.413    10.167     0.200
     0.460    10.090     0.200
     0.584    12.201     0.200
     0.869    17.806     0.200
     0.881    17.828     0.200
     1.062    21.095     0.200
     1.606    30.957     0.200
     1.997    37.830     0.200
     2.035    38.255     0.200
     2.206    40.831     0.200
     0.170     4.763     0.200
     0.275     6.066     0.200
     0.262     6.382     0.200
     0.359     7.374     0.200
     0.437     8.817     0.200
     0.461     8.982     0.200
     0.470     9.894     0.200
     0.478    10.219     0.200
     0.537    10.020     0.200
     0.537    10.598     0.200
     0.687    14.673     0.200
     0.956    19.402     0.200
     1.051    21.538     0.200
     1.214    24.228     0.200
     1.790    35.130     0.200
     1.952    37.913     0.200
     2.045    39.468     0.200
     2.114    40.488     0.200
     0.207     4.168     0.200
     0.234     5.767     0.200
     0.323     7.047     0.200
     0.381     8.292     0.200
     0.441     9.671     0.200
     0.534    10.930     0.200
     0.541    11.762     0.200
     0.693    14.500     0.200
     0.797    16.673     0.200
     0.821    16.570     0.200
     0.847    18.397     0.200
     1.006    20.294     0.200
     1.014    20.367     0.200
     1.067    21.032     0.200
     1.052    22.684     0.200
     0.033     3.062     0.200
     0.154     4.686     0.200
     0.320     6.568     0.200
     0.370     7.150     0.200
     0.387     8.013     0.200
     0.476    10.846     0.200
     0.763    14.742     0.200
     0.974    18.965     0.200
     1.089    22.998     0.200
     1.119    22.450     0.200
     1.277    25.978     0.200
     1.715    34.356     0.200
     1.909    37.600     0.200
     1.966    38.691     0.200
     2.117    41.361     0.200
     0.172     4.891     0.200
     0.279     5.880     0.200
     0.300     6.690     0.200
     0.295     7.038     0.200
     0.339     7.806     0.200
     0.382     9.082     0.200
     0.461     8.865     0.200
     0.440     9.654     0.200
     0.499    10.796     0.200
     0.546    11.776     0.200
     0.625    13.301     0.200
     0.666    12.819     0.200
     0.671    13.143     0.200
     0.656    14.679     0.200
     0.709    15.271     0.200
     0.821    16.752     0.200
     0.816    17.129     0.200
     0.866    17.744     0.200
     0.869    17.469     0.200
     1.013    21.364     0.200
     1.070    21.182     0.200
     1.156    23.094     0.200
     1.217    24.613     0.200
     1.862    37.636     0.200
     0.095     7.690     0.200
     0.211     8.670     0.200
     0.286     9.046     0.200
     0.331    10.038     0.200
     0.349     9.749     0.200
     0.368    10.348     0.200
     0.510    11.932     0.200
     0.526    11.404     0.200
     0.539    12.529     0.200
     0.533    12.756     0.200
     0.587    14.048     0.200
     0.628    14.039     0.200
     0.618    14.029     0.200
     0.674    14.583     0.200
     0.690    14.702     0.200
     0.759    15.374     0.200
     1.216    23.952     0.200
     1.455    28.371     0.200
     1.516    29.510     0.200
     1.542    30.163     0.200
     1.926    36.056     0.200
     0.157     3.618     0.200
     0.158     4.471     0.200
     0.237     5.801     0.200
     0.297     6.338     0.200
     0.364     7.114     0.200
     0.361     7.345     0.200
     0.456     9.561     0.200
     0.494     9.659     0.200
     0.467     9.937     0.200
     0.488    10.770     0.200
     0.711    15.362     0.200
     0.734    14.624     0.200
     1.079    21.467     0.200
     1.091    23.249     0.200
     1.135    23.458     0.200
     1.343    27.100     0.200
     0.096     2.988     0.200
     0.113     3.707     0.200
     0.258     6.054     0.200
     0.327     7.011     0.200
     0.413     8.403     0.200
     0.412     9.902     0.200
     0.420     9.437     0.200
     0.438     9.825     0.200
     0.480     9.710     0.200
     0.526    11.744     0.200
     0.671    14.692     0.200
     0.738    14.876     0.200
     1.035    21.828     0.200
     0.037     3.983     0.200
     0.280     6.173     0.200
     0.390     8.868     0.200
     0.422     9.039     0.200
     0.560    12.197     0.200
     0.584    11.702     0.200
     0.826    18.143     0.200
     0.872    18.632     0.200
     0.917    19.066     0.200
     0.966    19.594     0.200
     0.970    20.407     0.200
     0.187     4.658     0.200
     0.226     5.269     0.200
     0.256     5.370     0.200
     0.333     7.350     0.200
     0.401     8.708     0.200
     0.501    10.621     0.200
     0.554    11.759     0.200
     0.704    14.623     0.200
     0.826    16.291     0.200
     0.832    17.381     0.200
     0.851    17.871     0.200
     0.861    17.214     0.200
     0.876    17.915     0.200
     0.893    19.248     0.200
     0.971    20.613     0.200
     1.094    22.808     0.200
     1.111    22.936     0.200
     1.136    23.354     0.200
     1.259    24.572     0.200
     0.037     3.040     0.200
     0.214     5.270     0.200
     0.537    11.668     0.200
     0.691    13.991     0.200
     0.813    16.263     0.200
     0.834    17.060     0.200
     0.910    18.257     0.200
     0.968    20.071     0.200
     1.040    21.231     0.200
     1.179    24.054     0.200
     1.730    35.042     0.200
     1.794    35.725     0.200
     1.808    36.212     0.200
     1.956    38.267     0.200
     1.995    38.931     0.200
     2.165    41.838     0.200
     2.201    42.608     0.200
     0.098     2.289     0.200
     0.250     4.903     0.200
     0.410     8.404     0.200
     0.454     8.377     0.200
     0.447     9.564     0.200
     0.449    10.452     0.200
     0.547    12.794     0.200
     0.664    13.389     0.200
     1.067    21.591     0.200
     1.103    21.883     0.200
     1.206    23.736     0.200
     1.384    27.882     0.200
     1.461    29.659     0.200
     1.779    35.956     0.200
     1.783    35.917     0.200
     1.788    35.787     0.200
     1.800    36.383     0.200
     1.852    36.954     0.200
     2.056    40.931     0.200
     0.203     4.520     0.200
     0.318     6.858     0.200
     0.318     6.728     0.200
     0.412     8.165     0.200
     0.505     9.614     0.200
     0.589    12.659     0.200
     0.610    11.972     0.200
     0.730    15.544     0.200
     0.739    14.842     0.200
     0.788    15.837     0.200
     0.825    18.456     0.200
     0.911    19.182     0.200
     0.971    19.596     0.200
     0.997    20.773     0.200
     0.098     4.231     0.200
     0.077     5.113     0.200
     0.159     4.213     0.200
     0.351     7.545     0.200
     0.300     7.337     0.200
     0.349     9.097     0.200
     0.428     9.548     0.200
     0.461    10.396     0.200
     0.480    11.233     0.200
     0.490    10.597     0.200
     0.569    11.580     0.200
     0.611    11.998     0.200
     0.747    15.544     0.200
     0.879    16.996     0.200
     1.076    21.313     0.200
     1.604    30.786     0.200
     1.633    31.802     0.200
     1.941    36.965     0.200
     1.961    37.144     0.200
     2.024    38.600     0.200
     2.121    39.688     0.200
     2.226    42.043     0.200
     2.284    43.057     0.200
     0.594    13.206     0.200
     2.098    41.105     0.200
     2.295    40.727     0.200
     2.372    42.322     0.200
     2.430    42.842     0.200
     0.057     7.020     0.200
     0.155     7.212     0.200
     0.221     8.155     0.200
     0.287     8.386     0.200
     0.318     8.950     0.200
     0.339     8.910     0.200
     0.418    10.418     0.200
     0.471    10.850     0.200
     0.545    12.317     0.200
     0.619    12.874     0.200
     0.623    13.546     0.200
     0.638    13.864     0.200
     0.698    15.124     0.200
     0.707    14.605     0.200
     0.783    14.999     0.200
     0.794    15.606     0.200
     1.366    26.564     0.200
     1.402    27.069     0.200
     1.477    28.613     0.200
     1.716    32.293     0.200
     1.774    33.147     0.200
     1.809    34.074     0.200
     2.078    37.207     0.200
     0.241     6.741     0.200
     0.277     7.889     0.200
     0.349     8.117     0.200
     0.345     8.364     0.200
     0.422     9.021     0.200
     0.404     9.701     0.200
     0.482    11.005     0.200
     0.577    11.316     0.200
     0.550    12.123     0.200
     0.853    17.223     0.200
     1.829    34.298     0.200
     0.327     6.723     0.200
     0.333     7.210     0.200
     0.317     6.822     0.200
     0.334     7.505     0.200
     0.363     8.920     0.200
     0.426     9.147     0.200
     0.471    10.464     0.200
     0.506     9.523     0.200
     0.471    10.832     0.200
     0.566    11.532     0.200
     1.648    32.618     0.200
     0.247     4.210     0.200
     0.266     6.197     0.200
     0.308     6.283     0.200
     0.322     7.687     0.200
     0.424     8.842     0.200
     0.460    10.255     0.200
     0.486     9.537     0.200
     0.793    16.643     0.200
     0.871    17.202     0.200
     1.338    26.660     0.200
     0.081     3.418     0.200
     0.106     3.617     0.200
     0.181     5.548     0.200
     0.269     6.769     0.200
     0.294     6.074     0.200
     0.301     6.447     0.200
     0.369     8.071     0.200
     0.432     9.421     0.200
     0.594    12.350     0.200
     0.663    13.627     0.200
     0.137     5.565     0.200
     0.117     5.896     0.200
     0.249     6.653     0.200
     0.357     8.637     0.200
     0.379     8.131     0.200
     0.423    10.215     0.200
     0.465    10.313     0.200
     0.508    11.742     0.200
     0.643    14.137     0.200
     0.659    13.768     0.200
     0.681    14.230     0.200
     0.727    15.153     0.200
     0.864    17.128     0.200
     0.881    17.973     0.200
     1.221    23.277     0.200
     0.106     3.341     0.200
     0.092     3.517     0.200
     0.137     4.912     0.200
     0.317     6.632     0.200
     0.392     8.071     0.200
     0.386     8.741     0.200
     0.459     9.689     0.200
     0.459    10.038     0.200
     0.514    11.797     0.200
     1.217    24.659     0.200
     1.903    36.796     0.200
     1.966    38.021     0.200
     2.229    42.601     0.200
     0.173     4.360     0.200
     0.193     4.778     0.200
     0.186     4.262     0.200
     0.360     7.137     0.200
     0.636    14.064     0.200
     0.662    13.971     0.200
     0.704    14.583     0.200
     0.775    15.873     0.200
     0.782    15.575     0.200
     0.046     4.807     0.200
     0.112     5.429     0.200
     0.111     5.762     0.200
     0.104     5.841     0.200
     0.247     6.209     0.200
     0.244     6.273     0.200
     0.309     7.148     0.200
     0.455     9.463     0.200
     0.474    10.161     0.200
     0.561    10.905     0.200
     0.577    11.536     0.200
     0.905    18.346     0.200
     0.941    18.780     0.200
     1.767    33.547     0.200
     1.843    34.305     0.200
     0.170     3.592     0.200
     0.154     4.235     0.200
     0.184     4.324     0.200
     0.299     6.515     0.200
     0.385     7.799     0.200
     0.396     8.528     0.200
     0.445     9.534     0.200
     0.512    11.214     0.200
     0.535    10.841     0.200
     0.623    13.122     0.200
     0.756    15.715     0.200
     0.849    17.580     0.200
     0.919    19.083     0.200
     0.955    20.070     0.200
     1.030    21.511     0.200
     1.094    22.719     0.200
     0.179     3.683     0.200
     0.141     4.331     0.200
     0.180     4.392     0.200
     0.287     5.967     0.200
     0.303     6.805     0.200
     0.399     8.691     0.200
     0.406     8.667     0.200
     0.526    10.816     0.200
     0.549    11.225     0.200
     0.636    13.039     0.200
     0.739    15.536     0.200
     0.787    16.137     0.200
     0.854    17.630     0.200
     0.952    20.163     0.200
     1.043    21.705     0.200
     1.049    21.887     0.200
     1.107    23.115     0.200
     0.106     3.815     0.200
     0.157     4.955     0.200
     0.233     5.786     0.200
     0.276     6.915     0.200
     0.333     7.650     0.200
     0.331     8.039     0.200
     0.379     8.780     0.200
     0.522    11.424     0.200
     0.579    13.054     0.200
     0.610    13.332     0.200
     0.152     3.899     0.200
     0.224     4.490     0.200
     0.238     4.696     0.200
     0.328     6.404     0.200
     0.411     8.639     0.200
     0.460     9.954     0.200
     0.485     9.792     0.200
     0.651    13.680     0.200
     0.664    13.982     0.200
     0.688    13.865     0.200
     0.699    14.775     0.200
     0.737    15.953     0.200
     0.759    15.383     0.200
     0.791    16.705     0.200
     0.836    16.897     0.200
     0.845    17.272     0.200
     0.849    17.416     0.200
     0.836    17.622     0.200
     0.916    18.885     0.200
     0.930    19.382     0.200
     0.950    18.590     0.200
     1.085    22.519     0.200
     1.098    22.976     0.200
     1.116    23.271     0.200
     1.128    23.553     0.200
     1.122    23.584     0.200
     1.209    24.714     0.200
     1.254    24.952     0.200
     1.237    25.676     0.200
     0.084     3.695     0.200
     0.101     4.637     0.200
     0.173     5.517     0.200
     0.407     9.612     0.200
     0.445     9.500     0.200
     0.457    10.073     0.200
     0.509    10.647     0.200
     0.528    10.621     0.200
     0.527    11.925     0.200
     1.009    20.402     0.200
     1.079    22.029     0.200
     1.729    33.927     0.200
     1.878    36.006     0.200
     2.031    39.086     0.200
     2.129    40.588     0.200
     2.135    40.794     0.200
     0.147     4.475     0.200
     0.156     4.227     0.200
     0.183     4.945     0.200
     0.204     5.397     0.200
     0.309     7.181     0.200
     0.369     8.576     0.200
     0.378     8.985     0.200
     0.415     8.870     0.200
     0.553    12.013     0.200
     0.615    13.058     0.200
     0.626    13.455     0.200
     0.074     2.730     0.200
     0.138     3.986     0.200
     0.150     3.764     0.200
     0.171     3.697     0.200
     0.308     6.825     0.200
     0.326     7.063     0.200
     0.367     7.957     0.200
     0.374     8.091     0.200
     0.450     9.642     0.200
     0.457     9.755     0.200
     0.546    11.796     0.200
     0.570    12.161     0.200
     0.896    18.669     0.200
     0.085     2.610     0.200
     0.142     3.755     0.200
     0.154     3.602     0.200
     0.157     4.066     0.200
     0.327     6.862     0.200
     0.341     7.546     0.200
     0.349     7.503     0.200
     0.389     7.775     0.200
     0.390     8.490     0.200
     0.410     8.665     0.200
     0.461     9.734     0.200
     0.486    10.543     0.200
     0.530    11.016     0.200
     0.582    12.363     0.200
     0.606    12.642     0.200
     0.645    13.593     0.200
     0.113     3.086     0.200
     0.161     4.338     0.200
     0.242     5.212     0.200
     0.267     5.516     0.200
     0.370     8.158     0.200
     0.393     8.438     0.200
     0.443     9.187     0.200
     0.437     9.295     0.200
     0.560    12.042     0.200
     0.646    13.277     0.200
     0.636    13.692     0.200
     0.657    13.691     0.200
     0.710    15.258     0.200
     0.733    15.280     0.200
     0.745    15.365     0.200
     0.726    15.690     0.200
     0.787    16.190     0.200
     0.791    16.127     0.200
     0.806    16.198     0.200
     0.801    17.225     0.200
     0.853    18.271     0.200
     0.910    18.860     0.200
     1.052    22.136     0.200
     1.118    23.228     0.200
     1.122    23.403     0.200
     1.184    23.400     0.200
     0.187     4.520     0.200
     0.251     6.124     0.200
     0.268     6.153     0.200
     0.303     6.426     0.200
     0.329     7.040     0.200
     0.451     9.317     0.200
     0.538    11.370     0.200
     0.576    12.474     0.200
     0.636    13.012     0.200
     0.779    16.057     0.200
     0.826    16.911     0.200
     0.828    16.942     0.200
     0.837    17.011     0.200
     0.845    17.760     0.200
     0.910    18.860     0.200
     1.050    21.801     0.200
     0.163     4.317     0.200
     0.243     5.926     0.200
     0.263     6.144     0.200
     0.328     7.270     0.200
     0.333     7.540     0.200
     0.359     7.811     0.200
     0.388     8.583     0.200
     0.402     8.811     0.200
     0.445     9.770     0.200
     0.494     9.409     0.200
     0.553    11.971     0.200
     0.577    12.256     0.200
     0.596    12.439     0.200
     0.704    14.912     0.200
     0.778    16.513     0.200
     0.864    18.257     0.200
     1.007    21.308     0.200
     1.794    34.902     0.200
     0.093     3.964     0.200
     0.088     3.826     0.200
     0.175     5.067     0.200
     0.256     6.460     0.200
     0.288     6.438     0.200
     0.358     8.112     0.200
     0.425     9.204     0.200
     0.491    10.578     0.200
     0.565    11.748     0.200
     0.579    12.676     0.200
     0.585    12.751     0.200
     0.626    13.290     0.200
     0.654    14.087     0.200
     0.755    14.820     0.200
     0.737    15.155     0.200
     0.758    15.474     0.200
     0.913    18.293     0.200
     0.923    19.024     0.200
     1.079    22.300     0.200
     1.776    35.283     0.200
     1.855    35.992     0.200
     0.201     5.418     0.200
     0.311     7.388     0.200
     0.315     7.566     0.200
     0.320     7.524     0.200
     0.345     7.989     0.200
     0.384     8.650     0.200
     0.415     8.315     0.200
     0.399     8.980     0.200
     0.436     9.498     0.200
     0.475    10.612     0.200
     0.505    10.826     0.200
     0.551    11.408     0.200
     0.586    12.533     0.200
     0.668    14.151     0.200
     0.764    16.153     0.200
     0.783    16.692     0.200
     1.711    32.561     0.200
     0.105     4.367     0.200
     0.147     4.741     0.200
     0.173     4.987     0.200
     0.216     6.044     0.200
     0.230     5.781     0.200
     0.332     7.849     0.200
     0.378     8.459     0.200
     0.416     9.303     0.200
     0.453     9.871     0.200
     0.460     9.941     0.200
     0.453    10.253     0.200
     0.554    12.038     0.200
     0.584    12.899     0.200
     0.597    13.162     0.200
     0.657    14.277     0.200
     0.701    14.832     0.200
     0.712    15.533     0.200
     0.786    16.527     0.200
     0.807    17.012     0.200
     1.012    21.072     0.200
     1.748    34.197     0.200
     1.824    35.358     0.200
     2.042    39.488     0.200
     2.157    41.203     0.200
     0.112     3.267     0.200
     0.216     4.822     0.200
     0.247     5.463     0.200
     0.289     6.337     0.200
     0.313     7.000     0.200
     0.324     7.227     0.200
     0.343     7.538     0.200
     0.422     8.213     0.200
     0.422     9.101     0.200
     0.428     9.321     0.200
     0.641    13.527     0.200
     0.677    14.342     0.200
     0.060     2.161     0.200
     0.228     5.049     0.200
     0.255     6.395     0.200
     0.346     6.738     0.200
     0.357     7.265     0.200
     0.385     8.125     0.200
     0.392     8.753     0.200
     0.370     6.773     0.200
     0.430     8.309     0.200
     0.581    11.299     0.200
     0.539    12.541     0.200
     0.586    13.125     0.200
     0.609    13.492     0.200
     0.792    15.945     0.200
     0.794    15.732     0.200
     0.849    17.192     0.200
     0.926    19.068     0.200
     0.949    19.276     0.200
     0.941    19.654     0.200
     0.974    19.659     0.200
     0.980    19.654     0.200
     1.098    22.450     0.200
     1.190    24.136     0.200
     1.264    25.579     0.200
     1.655    33.443     0.200
     1.674    33.630     0.200
     1.667    33.413     0.200
     1.727    34.185     0.200
     1.767    34.832     0.200
     1.789    35.624     0.200
     1.831    36.150     0.200
     1.925    37.858     0.200
     1.933    37.986     0.200
     1.989    39.060     0.200
     1.992    39.023     0.200
     2.058    41.330     0.200
     1.999    39.359     0.200
     2.062    39.247     0.200
     2.089    40.972     0.200
     2.782    50.595     0.200
     3.134    55.308     0.200
     0.061     2.903     0.200
     0.112     3.604     0.200
     0.207     5.262     0.200
     0.279     6.689     0.200
     0.273     6.338     0.200
     0.328     7.012     0.200
     0.379     8.360     0.200
     0.456     9.963     0.200
     0.484     9.772     0.200
     0.559    11.758     0.200
     0.612    12.961     0.200
     0.644    13.308     0.200
     0.648    13.719     0.200
     0.683    14.209     0.200
     0.732    14.388     0.200
     0.733    14.835     0.200
     0.738    15.077     0.200
     0.769    16.359     0.200
     0.804    16.742     0.200
     0.873    18.100     0.200
     0.900    18.688     0.200
     0.924    18.988     0.200
     1.072    22.528     0.200
     1.102    22.869     0.200
     1.724    33.930     0.200
     1.828    36.077     0.200
     2.134    41.399     0.200
     0.177     4.303     0.200
     0.233     5.580     0.200
     0.354     7.521     0.200
     0.363     7.339     0.200
     0.355     8.225     0.200
     0.398     8.769     0.200
     0.444     8.419     0.200
     0.470    10.213     0.200
     0.598    11.586     0.200
     0.572    12.376     0.200
     0.941    19.105     0.200
     0.962    19.352     0.200
     1.282    25.953     0.200
     1.690    34.176     0.200
     1.848    36.934     0.200
     0.140     4.009     0.200
     0.142     4.447     0.200
     0.169     4.601     0.200
     0.202     4.580     0.200
     0.328     6.787     0.200
     0.353     6.953     0.200
     0.367     7.454     0.200
     0.372     7.796     0.200
     0.381     7.766     0.200
     0.398     8.536     0.200
     0.432     9.177     0.200
     0.447     9.281     0.200
     0.451    10.038     0.200
     0.504    10.161     0.200
     0.503    10.849     0.200
     0.520    11.529     0.200
     0.534    11.263     0.200
     0.636    12.992     0.200
     0.643    13.454     0.200
     0.699    13.493     0.200
     0.681    14.422     0.200
     0.693    14.560     0.200
     0.763    16.187     0.200
     0.925    18.802     0.200
     1.658    33.856     0.200
     1.861    36.984     0.200
     0.150     4.029     0.200
     0.144     4.316     0.200
     0.176     3.693     0.200
     0.259     5.910     0.200
     0.275     6.520     0.200
     0.379     8.137     0.200
     0.374     7.953     0.200
     0.446     9.365     0.200
     0.455     9.575     0.200
     0.500    10.823     0.200
     0.611    11.086     0.200
     0.616    12.840     0.200
     0.631    12.602     0.200
     0.628    12.713     0.200
     0.637    13.610     0.200
     0.683    14.182     0.200
     0.702    15.084     0.200
     0.818    16.535     0.200
     0.861    17.658     0.200
     0.935    19.655     0.200
     0.963    19.930     0.200
     0.981    19.786     0.200
     1.914    38.731     0.200
     2.013    40.119     0.200
     2.124    42.122     0.200
     0.226     5.404     0.200
     0.229     5.841     0.200
     0.254     5.972     0.200
     0.367     8.597     0.200
     0.432     9.294     0.200
     0.507    10.414     0.200
     0.509    11.237     0.200
     0.611    12.818     0.200
     0.677    13.417     0.200
     0.682    14.354     0.200
     0.683    14.961     0.200
     0.845    18.102     0.200
     1.019    20.619     0.200
     1.047    21.868     0.200
     0.124     6.061     0.200
     0.134     6.338     0.200
     0.155     6.845     0.200
     0.269     8.207     0.200
     0.318     8.073     0.200
     0.496    10.933     0.200
     0.544    11.702     0.200
     0.532    12.239     0.200
     0.556    12.771     0.200
     0.618    12.947     0.200
     0.672    14.404     0.200
     0.764    16.409     0.200
     0.808    16.680     0.200
     0.875    17.832     0.200
     0.157     3.265     0.200
     0.273     5.835     0.200
     0.284     6.081     0.200
     0.322     6.301     0.200
     0.344     6.914     0.200
     0.360     7.867     0.200
     0.420     8.349     0.200
     0.443    10.158     0.200
     0.464     9.873     0.200
     0.507    10.881     0.200
     0.543    11.503     0.200
     0.588    12.582     0.200
     0.637    13.946     0.200
     0.722    15.562     0.200
     0.795    16.937     0.200
     0.795    17.032     0.200
     0.790    16.346     0.200
     1.801    36.688     0.200
     0.095     2.230     0.200
     0.101     2.745     0.200
     0.319     7.051     0.200
     0.464     9.800     0.200
     0.467     9.212     0.200
     0.655    12.775     0.200
     1.026    20.784     0.200
     1.106    22.587     0.200
     1.212    23.645     0.200
     1.306    25.965     0.200
     1.840    34.710     0.200
     1.885    37.289     0.200
     1.897    37.416     0.200
     1.908    37.648     0.200
     2.023    38.897     0.200
     2.061    40.665     0.200
     2.159    41.308     0.200
     2.165    41.520     0.200
     2.224    42.475     0.200
     1.973    38.972     0.200
     2.149    40.481     0.200
     2.161    41.471     0.200
     0.056     2.985     0.200
     0.180     4.177     0.200
     0.198     5.168     0.200
     0.310     6.934     0.200
     0.413     8.550     0.200
     0.412     8.315     0.200
     0.486     9.739     0.200
     0.554    11.446     0.200
     0.578    11.710     0.200
     0.626    13.541     0.200
     1.000    21.318     0.200
     1.064    21.972     0.200
     2.000    38.954     0.200
     0.162     3.176     0.200
     0.195     4.114     0.200
     0.199     4.379     0.200
     0.303     5.868     0.200
     0.318     6.611     0.200
     0.313     6.500     0.200
     0.345     6.690     0.200
     0.974    20.457     0.200
     0.059     1.185     0.200
     0.205     4.653     0.200
     0.268     6.158     0.200
     0.271     5.786     0.200
     0.271     6.325     0.200
     0.281     6.014     0.200
     0.325     7.189     0.200
     0.369     7.709     0.200
     0.381     8.529     0.200
     0.467     8.593     0.200
     0.453     9.403     0.200
     0.546    11.270     0.200
     0.592    12.103     0.200
     0.624    13.326     0.200
     0.626    13.151     0.200
     0.625    12.859     0.200
     0.080     4.193     0.200
     0.116     4.603     0.200
     0.191     5.393     0.200
     0.189     5.582     0.200
     0.241     6.793     0.200
     0.302     7.457     0.200
     0.350     7.731     0.200
     0.492    10.432     0.200
     0.499    10.499     0.200
     0.563    11.932     0.200
     0.679    13.878     0.200
     0.739    15.362     0.200
     0.762    15.816     0.200
     0.752    15.885     0.200
     0.861    18.014     0.200
     0.887    18.651     0.200
     0.969    19.329     0.200
     0.937    18.982     0.200
     1.047    21.099     0.200
     1.077    21.468     0.200
     0.177     4.845     0.200
     0.159     4.611     0.200
     0.203     5.779     0.200
     0.243     5.658     0.200
     0.362     7.037     0.200
     0.341     7.274     0.200
     0.406     8.196     0.200
     0.444     9.939     0.200
     0.464     9.831     0.200
     0.635    13.797     0.200
     0.653    13.048     0.200
     0.689    13.945     0.200
     0.710    15.173     0.200
     0.754    15.314     0.200
     0.758    15.260     0.200
     0.774    17.252     0.200
     0.785    17.162     0.200
     0.818    17.145     0.200
     0.869    18.144     0.200
     0.929    19.453     0.200
     0.988    20.389     0.200
     1.116    22.557     0.200
     1.169    22.276     0.200
     2.436    44.710     0.200
     2.472    45.852     0.200
     2.534    46.280     0.200
     2.878    50.653     0.200
     0.128     2.901     0.200
     0.208     4.092     0.200
     0.327     6.555     0.200
     0.385     7.622     0.200
     0.469    10.204     0.200
     0.503     9.789     0.200
     0.475    10.464     0.200
     0.603    12.577     0.200
     0.655    12.789     0.200
     0.770    16.170     0.200
     1.112    21.952     0.200
     1.140    22.717     0.200
     1.177    24.012     0.200
     1.652    32.966     0.200
     1.682    33.434     0.200
     1.808    35.575     0.200
     1.863    36.057     0.200
     1.933    36.938     0.200
     1.984    38.210     0.200
     2.005    38.891     0.200
     2.011    38.493     0.200
     2.025    39.064     0.200
     2.077    40.328     0.200
     2.167    41.689     0.200
     2.274    43.444     0.200
     2.272    43.555     0.200
     2.331    44.194     0.200
     0.110     4.391     0.200
     0.189     5.455     0.200
     0.235     5.875     0.200
     0.357     8.379     0.200
     0.391     9.014     0.200
     0.419     9.756     0.200
     0.465     9.803     0.200
     0.579    13.103     0.200
     0.638    13.923     0.200
     0.660    13.520     0.200
     0.661    14.205     0.200
     0.751    16.131     0.200
     0.762    16.225     0.200
     0.947    19.048     0.200
     1.967    38.055     0.200
     0.122     4.011     0.200
     0.118     3.586     0.200
     0.195     5.120     0.200
     0.394     8.764     0.200
     0.398     8.484     0.200
     0.409     8.685     0.200
     0.424     9.127     0.200
     0.451    10.217     0.200
     0.585    12.576     0.200
     0.586    12.416     0.200
     0.638    13.776     0.200
     0.708    15.054     0.200
     0.106     3.402     0.200
     0.112     3.727     0.200
     0.117     3.051     0.200
     0.157     3.845     0.200
     0.271     5.427     0.200
     0.359     7.675     0.200
     0.363     8.091     0.200
     0.399     8.060     0.200
     0.421     8.660     0.200
     0.477     9.478     0.200
     0.591    11.418     0.200
     0.644    13.420     0.200
     0.688    13.951     0.200
     0.703    15.015     0.200
     0.731    15.020     0.200
     0.746    15.124     0.200
     0.796    16.219     0.200
     0.811    16.201     0.200
     1.391    27.865     0.200
     0.161     4.930     0.200
     0.290     6.732     0.200
     0.305     7.451     0.200
     0.302     6.866     0.200
     0.310     7.027     0.200
     0.362     8.131     0.200
     0.436     8.226     0.200
     0.433     9.629     0.200
     0.449     9.451     0.200
     0.464     9.914     0.200
     0.556    11.531     0.200
     0.606    12.040     0.200
     0.628    13.401     0.200
     0.698    14.600     0.200
     0.723    14.743     0.200
     0.796    16.706     0.200
     0.836    16.380     0.200
     0.841    16.978     0.200
     1.739    35.184     0.200
     0.051     0.981     0.200
     0.282     5.615     0.200
     0.294     7.491     0.200
     0.389     7.679     0.200
     0.409     7.908     0.200
     0.506    11.577     0.200
     0.537    11.917     0.200
     0.606    12.557     0.200
     0.683    13.585     0.200
     0.723    14.576     0.200
     0.862    16.726     0.200
     0.877    18.198     0.200
     0.929    18.428     0.200
     0.950    19.322     0.200
     1.030    21.533     0.200
     1.015    21.171     0.200
     1.044    21.048     0.200
     1.141    23.045     0.200
     1.259    26.118     0.200
     1.375    27.595     0.200
     1.405    28.573     0.200
     1.733    35.501     0.200
     1.749    35.516     0.200
     1.816    36.738     0.200
     1.995    39.848     0.200
     1.998    39.190     0.200
     2.056    40.721     0.200
     0.780    14.602     0.200
     1.120    23.399     0.200
     1.984    38.922     0.200
     2.067    39.149     0.200
     2.312    43.120     0.200
     2.372    45.385     0.200
     2.527    46.562     0.200
     0.108     4.146     0.200
     0.226     5.508     0.200
     0.357     8.127     0.200
     0.392     8.934     0.200
     0.459     9.712     0.200
     0.545    11.851     0.200
     0.603    12.869     0.200
     0.629    13.711     0.200
     0.650    13.807     0.200
     0.719    15.224     0.200
     0.919    19.419     0.200
     0.982    20.626     0.200
     1.001    20.930     0.200
     0.658    15.757     0.200
     2.013    38.584     0.200
     2.111    41.252     0.200
     2.340    42.929     0.200
     2.392    43.532     0.200
     2.397    43.556     0.200
     2.555    46.384     0.200
     0.147     4.097     0.200
     0.136     3.863     0.200
     0.229     5.533     0.200
     0.356     7.749     0.200
     0.377     8.733     0.200
     0.432     9.096     0.200
     0.541    11.822     0.200
     0.602    13.241     0.200
     0.620    13.398     0.200
     0.625    13.358     0.200
     0.693    14.355     0.200
     0.730    15.213     0.200
     0.210     4.508     0.200
     0.302     6.494     0.200
     0.313     6.797     0.200
     0.336     7.587     0.200
     0.360     7.326     0.200
     0.399     7.372     0.200
     0.381     7.836     0.200
     0.422     8.343     0.200
     0.461    10.011     0.200
     0.484    10.539     0.200
     0.510    10.235     0.200
     0.516    10.590     0.200
     0.532    11.198     0.200
     0.571    11.779     0.200
     0.591    12.632     0.200
     0.681    14.311     0.200
     0.681    14.326     0.200
     0.747    15.587     0.200
     0.768    15.841     0.200
     0.775    16.172     0.200
     0.840    17.483     0.200
     0.854    17.369     0.200
     0.848    17.328     0.200
     0.950    19.950     0.200
     1.026    20.807     0.200
     1.074    21.856     0.200
     1.094    23.056     0.200
     1.696    34.955     0.200
     1.801    36.607     0.200
     0.168     3.988     0.200
     0.294     5.920     0.200
     0.451     9.583     0.200
     0.512    10.646     0.200
     0.515    10.712     0.200
     0.538    10.721     0.200
     0.663    13.234     0.200
     0.730    14.464     0.200
     0.732    15.015     0.200
     0.787    16.759     0.200
     0.808    16.422     0.200
     0.801    16.438     0.200
     0.816    16.590     0.200
     0.807    16.477     0.200
     0.116     3.216     0.200
     0.204     4.793     0.200
     0.267     5.898     0.200
     0.311     6.347     0.200
     0.328     6.203     0.200
     0.342     7.081     0.200
     0.532    10.679     0.200
     0.584    12.354     0.200
     0.714    14.311     0.200
     0.708    14.903     0.200
     0.735    14.701     0.200
     0.767    15.388     0.200
     0.855    17.148     0.200
     0.915    18.434     0.200
     0.918    18.845     0.200
     0.942    19.060     0.200
     1.050    21.521     0.200
     1.066    21.698     0.200
     1.168    23.967     0.200
     1.289    26.471     0.200
     1.421    27.896     0.200
     1.734    34.887     0.200
     0.145     4.488     0.200
     0.189     4.487     0.200
     0.288     6.168     0.200
     0.292     6.292     0.200
     0.317     6.612     0.200
     0.310     6.672     0.200
     0.396     8.499     0.200
     0.440     8.214     0.200
     0.458     8.497     0.200
     0.463     9.756     0.200
     0.510    10.624     0.200
     0.575    11.920     0.200
     0.568    12.122     0.200
     0.645    13.384     0.200
     0.667    12.743     0.200
     0.674    13.204     0.200
     0.730    15.750     0.200
     0.727    15.396     0.200
     0.781    14.955     0.200
     0.799    16.090     0.200
     0.809    16.712     0.200
     0.836    16.282     0.200
     0.882    17.471     0.200
     1.021    20.221     0.200
     1.020    20.482     0.200
     1.190    23.595     0.200
     1.213    24.821     0.200
     1.528    29.673     0.200
     1.656    32.916     0.200
     1.716    33.730     0.200
     1.875    36.986     0.200
     0.136     4.739     0.200
     0.168     5.329     0.200
     0.149     4.431     0.200
     0.261     6.922     0.200
     0.358     8.542     0.200
     0.373     9.052     0.200
     0.446    10.203     0.200
     0.449     9.497     0.200
     0.440     9.951     0.200
     0.484    10.000     0.200
     0.564    12.150     0.200
     0.617    12.111     0.200
     0.612    12.544     0.200
     0.621    13.308     0.200
     0.684    13.524     0.200
     0.681    14.446     0.200
     0.777    15.286     0.200
     0.784    15.912     0.200
     0.805    16.931     0.200
     0.849    16.537     0.200
     0.891    17.638     0.200
     0.921    19.483     0.200
     0.959    20.011     0.200
     0.989    19.991     0.200
     1.010    19.656     0.200
     1.136    22.648     0.200
     1.582    31.184     0.200
     1.609    31.321     0.200
     1.638    32.682     0.200
     1.787    34.405     0.200
     1.798    35.398     0.200
     1.922    35.898     0.200
     1.995    38.220     0.200
     2.019    39.162     0.200
     2.131    40.139     0.200
     0.481     9.277     0.200
     0.699    14.505     0.200
     0.113     3.691     0.200
     0.140     4.195     0.200
     0.172     4.850     0.200
     0.218     5.493     0.200
     0.240     5.350     0.200
     0.305     6.919     0.200
     0.333     6.388     0.200
     0.373     7.717     0.200
     0.438     8.423     0.200
     0.476     9.111     0.200
     0.474     9.802     0.200
     0.473     9.508     0.200
     0.487    10.534     0.200
     0.579    11.812     0.200
     0.609    12.285     0.200
     0.659    13.159     0.200
     0.690    13.984     0.200
     0.721    14.375     0.200
     0.727    14.777     0.200
     0.744    15.658     0.200
     0.744    15.341     0.200
     0.776    15.740     0.200
     0.816    17.986     0.200
     0.840    17.905     0.200
     0.906    18.552     0.200
     0.960    19.676     0.200
     0.973    20.567     0.200
     1.026    20.562     0.200
     1.143    22.512     0.200
     1.151    23.590     0.200
     1.333    26.351     0.200
     0.109     4.451     0.200
     0.177     4.839     0.200
     0.207     5.272     0.200
     0.305     6.895     0.200
     0.315     6.784     0.200
     0.316     6.768     0.200
     0.364     7.778     0.200
     0.434     9.982     0.200
     0.439     8.899     0.200
     0.434     9.781     0.200
     0.515    10.639     0.200
     0.561    12.144     0.200
     0.584    11.832     0.200
     0.584    11.736     0.200
     0.586    12.218     0.200
     0.670    13.542     0.200
     0.711    14.692     0.200
     0.736    14.327     0.200
     0.719    14.438     0.200
     0.763    15.553     0.200
     0.769    14.810     0.200
     0.813    16.787     0.200
     0.847    18.515     0.200
     0.942    19.403     0.200
     1.074    21.882     0.200
     1.077    22.376     0.200
     1.074    21.827     0.200
     0.134     3.558     0.200
     0.132     3.570     0.200
     0.183     4.079     0.200
     0.255     5.779     0.200
     0.340     7.714     0.200
     0.328     7.167     0.200
     0.415     8.497     0.200
     0.420     8.751     0.200
     0.454     9.706     0.200
     0.465     9.453     0.200
     0.585    12.851     0.200
     0.588    12.159     0.200
     0.661    12.710     0.200
     0.658    13.539     0.200
     0.746    15.181     0.200
     0.866    17.444     0.200
     0.884    18.951     0.200
     0.903    18.617     0.200
     0.927    19.038     0.200
     0.982    20.144     0.200
     0.986    20.206     0.200
     1.121    22.631     0.200
     1.162    22.889     0.200
     1.196    24.789     0.200
     1.770    35.886     0.200
     1.789    36.070     0.200
     1.913    39.063     0.200
     2.005    39.684     0.200
     2.122    41.906     0.200
     0.148     4.727     0.200
     0.207     4.798     0.200
     0.270     6.226     0.200
     0.296     6.967     0.200
     0.317     6.666     0.200
     0.329     6.980     0.200
     0.408     7.908     0.200
     0.431     8.447     0.200
     0.451     9.779     0.200
     0.571    12.058     0.200
     0.582    12.384     0.200
     0.602    12.757     0.200
     0.670    13.782     0.200
     0.723    14.823     0.200
     0.730    15.115     0.200
     0.807    16.874     0.200
     0.799    16.701     0.200
     0.851    17.462     0.200
     0.925    18.254     0.200
     1.086    21.537     0.200
     1.104    22.923     0.200
     1.168    23.573     0.200
     0.155     5.059     0.200
     0.249     6.421     0.200
     0.263     6.281     0.200
     0.318     8.073     0.200
     0.350     8.953     0.200
     0.393     9.098     0.200
     0.440     9.617     0.200
     0.490     9.868     0.200
     0.502    10.396     0.200
     0.578    11.752     0.200
     0.593    11.953     0.200
     0.659    13.551     0.200
     0.685    13.872     0.200
     0.700    14.890     0.200
     0.699    14.736     0.200
     0.773    16.504     0.200
     0.778    16.579     0.200
     0.787    15.190     0.200
     0.850    16.976     0.200
     0.860    17.788     0.200
     0.883    18.050     0.200
     0.915    18.350     0.200
     1.028    20.380     0.200
     1.668    31.096     0.200
     1.893    37.789     0.200
     0.040     1.967     0.200
     0.165     3.854     0.200
     0.175     4.496     0.200
     0.248     5.860     0.200
     0.311     7.182     0.200
     0.347     6.881     0.200
     0.376     8.049     0.200
     0.499     9.867     0.200
     0.471     9.856     0.200
     0.484    10.213     0.200
     0.505    10.362     0.200
     0.595    12.523     0.200
     0.710    13.960     0.200
     0.732    13.718     0.200
     0.724    15.139     0.200
     0.795    15.586     0.200
     0.942    18.944     0.200
     0.995    20.026     0.200
     1.031    20.464     0.200
     1.065    20.107     0.200
     1.124    23.449     0.200
     1.135    22.502     0.200
     1.252    24.948     0.200
     1.274    24.811     0.200
     1.778    34.678     0.200
     1.985    39.589     0.200
     2.075    39.667     0.200
     2.086    40.326     0.200
     2.146    41.414     0.200
     0.660    14.331     0.200
     2.065    38.724     0.200
     2.150    39.308     0.200
     2.245    41.056     0.200
     0.139     4.144     0.200
     0.128     4.195     0.200
     0.265     6.029     0.200
     0.306     6.881     0.200
     0.371     7.480     0.200
     0.371     8.118     0.200
     0.370     8.091     0.200
     0.528    11.065     0.200
     0.664    13.518     0.200
     0.679    13.922     0.200
     0.679    13.349     0.200
     0.841    17.135     0.200
     0.942    19.818     0.200
     1.008    21.457     0.200
     1.010    20.592     0.200
     1.042    21.065     0.200
     0.092     2.703     0.200
     0.317     5.790     0.200
     0.295     6.640     0.200
     0.491    10.358     0.200
     0.526    10.708     0.200
     0.504    11.057     0.200
     0.528    11.273     0.200
     0.634    14.212     0.200
     0.688    15.248     0.200
     0.719    16.677     0.200
     0.724    15.989     0.200
     0.919    18.601     0.200
     1.031    20.709     0.200
     1.063    21.379     0.200
     1.198    24.472     0.200
     1.335    26.675     0.200
     1.711    34.769     0.200
     0.184     6.914     0.200
     0.235     6.849     0.200
     0.261     7.410     0.200
     0.384    10.097     0.200
     0.413     9.759     0.200
     0.488    10.932     0.200
     0.484    11.141     0.200
     0.555    11.387     0.200
     0.524    12.033     0.200
     0.580    12.207     0.200
     0.570    13.190     0.200
     0.727    14.638     0.200
     0.742    15.504     0.200
     0.740    16.046     0.200
     0.814    16.907     0.200
     0.936    18.526     0.200
     1.504    29.936     0.200
     1.543    29.537     0.200
     1.721    33.461     0.200
     1.733    33.244     0.200
     1.940    37.172     0.200
     1.954    37.095     0.200
     0.212     4.662     0.200
     0.385     8.066     0.200
     0.395     8.478     0.200
     0.411     9.458     0.200
     0.460     9.066     0.200
     0.480    10.602     0.200
     0.525    10.330     0.200
     0.548    11.339     0.200
     0.548    12.098     0.200
     0.551    11.647     0.200
     0.650    13.511     0.200
     0.697    14.150     0.200
     0.738    14.736     0.200
     0.812    17.048     0.200
     0.880    18.190     0.200
     0.915    18.215     0.200
     0.892    19.105     0.200
     0.946    19.622     0.200
     1.693    34.820     0.200
     1.702    34.497     0.200
     1.814    37.100     0.200
     1.910    37.993     0.200
     1.925    39.251     0.200
     0.173     5.004     0.200
     0.195     5.766     0.200
     0.234     6.178     0.200
     0.268     7.297     0.200
     0.349     7.963     0.200
     0.427    10.136     0.200
     0.481    10.951     0.200
     0.500    10.795     0.200
     0.524    11.404     0.200
     0.689    14.770     0.200
     0.719    15.365     0.200
     0.735    16.308     0.200
     0.757    15.800     0.200
     0.839    17.862     0.200
     0.987    19.939     0.200
     1.025    20.902     0.200
     0.211     6.105     0.200
     1.100    21.509     0.200
     2.163    40.783     0.200
     0.121     3.483     0.200
     0.145     4.243     0.200
     0.240     4.639     0.200
     0.344     7.083     0.200
     0.367     9.139     0.200
     0.430     8.318     0.200
     0.409     9.710     0.200
     0.489    10.175     0.200
     0.541    11.770     0.200
     0.578    12.340     0.200
     0.752    15.186     0.200
     0.831    16.380     0.200
     1.038    21.002     0.200
     1.042    21.998     0.200
     1.177    23.774     0.200
     1.224    24.632     0.200
     1.328    26.547     0.200
     1.861    36.473     0.200
     1.908    37.790     0.200
     1.921    37.430     0.200
     2.005    39.278     0.200
     2.183    42.344     0.200
     2.233    43.034     0.200
     2.242    43.465     0.200
     0.085     2.558     0.200
     0.218     5.366     0.200
     0.254     6.049     0.200
     0.274     5.927     0.200
     0.337     6.995     0.200
     0.350     7.258     0.200
     0.366     7.774     0.200
     0.517     9.819     0.200
     0.514    10.363     0.200
     0.542    11.826     0.200
     0.615    12.247     0.200
     0.626    13.385     0.200
     0.667    13.903     0.200
     0.681    14.515     0.200
     0.785    15.544     0.200
     0.855    18.233     0.200
     0.887    18.784     0.200
     1.206    25.118     0.200
     1.701    35.590     0.200
     1.916    38.592     0.200
     0.099     4.134     0.200
     0.101     4.219     0.200
     0.166     4.789     0.200
     0.266     5.873     0.200
     0.271     6.469     0.200
     0.297     6.787     0.200
     0.341     7.439     0.200
     0.428     9.412     0.200
     0.521    10.680     0.200
     0.545    11.437     0.200
     0.722    15.203     0.200
     0.764    16.199     0.200
     0.766    16.393     0.200
     0.796    16.798     0.200
     0.831    17.490     0.200
     0.936    18.986     0.200
     1.023    21.457     0.200
     0.263     6.041     0.200
     1.309    24.310     0.200
     0.060     3.647     0.200
     0.123     4.293     0.200
     0.203     6.258     0.200
     0.304     6.633     0.200
     0.304     6.805     0.200
     0.388     9.033     0.200
     0.453     9.785     0.200
     0.510    10.819     0.200
     0.584    11.639     0.200
     0.591    12.238     0.200
     0.615    13.190     0.200
     0.657    13.982     0.200
     0.684    14.769     0.200
     0.790    16.063     0.200
     0.917    18.149     0.200
     0.926    19.064     0.200
     1.041    21.425     0.200
     1.117    22.943     0.200
     1.127    22.999     0.200
     1.749    34.132     0.200
     2.160    41.609     0.200
     0.185     3.943     0.200
     0.266     5.509     0.200
     0.280     5.841     0.200
     0.267     5.363     0.200
     0.348     7.396     0.200
     0.461     9.087     0.200
     0.441     9.621     0.200
     0.527    10.794     0.200
     0.535    11.472     0.200
     0.743    14.433     0.200
     0.763    15.389     0.200
     0.870    16.893     0.200
     0.911    18.393     0.200
     0.998    20.575     0.200
     0.067     4.218     0.200
     0.107     4.082     0.200
     0.209     6.067     0.200
     0.339     7.684     0.200
     0.373     8.455     0.200
     0.456     9.685     0.200
     0.472     9.836     0.200
     0.547    11.502     0.200
     0.552    12.042     0.200
     0.609    13.174     0.200
     0.643    14.223     0.200
     0.680    14.637     0.200
     0.726    15.298     0.200
     0.761    16.505     0.200
     0.864    17.515     0.200
     0.857    18.307     0.200
     0.878    18.460     0.200
     0.888    18.204     0.200
     0.914    18.259     0.200
     1.115    22.407     0.200
     1.743    34.041     0.200
     1.817    35.085     0.200
     1.898    37.091     0.200
     2.021    39.543     0.200
     2.101    40.919     0.200
     2.122    41.674     0.200
     0.558    12.186     0.200
     1.882    37.554     0.200
     2.954    53.419     0.200
     0.092     2.927     0.200
     0.178     4.298     0.200
     0.242     5.485     0.200
     0.265     5.926     0.200
     0.361     7.818     0.200
     0.404     9.219     0.200
     0.551    11.807     0.200
     0.608    12.780     0.200
     0.638    14.052     0.200
     0.930    20.028     0.200
     1.705    34.575     0.200
     0.097     4.488     0.200
     0.203     5.538     0.200
     0.224     5.664     0.200
     0.329     7.285     0.200
     0.340     7.433     0.200
     0.332     7.695     0.200
     0.465     9.151     0.200
     0.451     9.912     0.200
     0.793    16.656     0.200
     0.061     3.005     0.200
     0.110     3.259     0.200
     0.131     3.533     0.200
     0.224     4.601     0.200
     0.231     4.728     0.200
     0.284     6.611     0.200
     0.279     6.911     0.200
     0.366     7.611     0.200
     0.443     8.554     0.200
     0.535    10.797     0.200
     0.527    11.313     0.200
     0.523    11.841     0.200
     0.958    20.123     0.200
     0.988    20.513     0.200
     0.276     5.312     0.200
     1.263    23.674     0.200
     1.898    37.352     0.200
     2.527    44.604     0.200
     2.727    49.553     0.200
     0.208     5.383     0.200
     0.242     5.307     0.200
     0.328     7.386     0.200
     0.351     7.679     0.200
     0.351     7.180     0.200
     0.379     8.268     0.200
     0.469     9.746     0.200
     0.469     9.332     0.200
     0.595    11.933     0.200
     0.710    15.026     0.200
     0.746    15.007     0.200
     0.790    16.001     0.200
     0.790    16.660     0.200
     0.890    18.866     0.200
     0.903    18.763     0.200
     1.081    22.537     0.200
     1.100    22.818     0.200
     0.073     3.174     0.200
     0.091     3.521     0.200
     0.150     3.319     0.200
     0.217     4.843     0.200
     0.228     4.500     0.200
     0.270     5.443     0.200
     0.265     5.848     0.200
     0.494     9.463     0.200
     0.538    11.581     0.200
     0.544    10.460     0.200
     0.658    13.445     0.200
     1.061    21.850     0.200
     0.064     3.651     0.200
     0.095     3.869     0.200
     0.145     3.695     0.200
     0.213     5.456     0.200
     0.218     4.977     0.200
     0.268     6.484     0.200
     0.426     8.457     0.200
     0.488    10.044     0.200
     0.526    11.242     0.200
     0.528    10.859     0.200
     0.528    10.480     0.200
     0.547    11.046     0.200
     0.628    12.529     0.200
     0.648    13.219     0.200
     0.691    13.999     0.200
     0.693    14.047     0.200
     0.722    14.904     0.200
     0.753    15.636     0.200
     0.753    15.762     0.200
     0.804    16.642     0.200
     1.065    22.009     0.200
     1.096    22.699     0.200
     0.137     4.600     0.200
     0.134     4.840     0.200
     0.179     5.142     0.200
     0.246     6.608     0.200
     0.249     5.906     0.200
     0.280     6.573     0.200
     0.363     8.279     0.200
     0.356     7.890     0.200
     0.383     9.208     0.200
     0.513    10.539     0.200
     0.518    11.857     0.200
     0.534    11.343     0.200
     0.567    11.779     0.200
     0.601    12.288     0.200
     0.650    13.140     0.200
     0.666    13.631     0.200
     0.722    15.306     0.200
     0.741    15.341     0.200
     0.762    15.705     0.200
     0.787    16.588     0.200
     0.801    16.481     0.200
     0.872    17.826     0.200
     0.868    18.176     0.200
     0.956    19.441     0.200
     0.063     4.015     0.200
     0.102     4.162     0.200
     0.138     4.072     0.200
     0.223     5.630     0.200
     0.222     5.112     0.200
     0.276     6.547     0.200
     0.278     6.347     0.200
     0.358     7.090     0.200
     0.435     9.312     0.200
     0.497     9.931     0.200
     0.532    11.766     0.200
     0.529    11.310     0.200
     0.637    12.983     0.200
     0.654    12.934     0.200
     0.665    14.221     0.200
     0.700    14.215     0.200
     0.701    14.659     0.200
     0.762    15.230     0.200
     0.753    15.697     0.200
     0.812    16.525     0.200
     1.138    22.669     0.200
     0.163     4.267     0.200
     0.190     4.353     0.200
     0.329     7.592     0.200
     0.382     8.426     0.200
     0.431     9.633     0.200
     0.423     9.059     0.200
     0.458     9.372     0.200
     0.488    10.370     0.200
     0.554    11.766     0.200
     0.587    12.207     0.200
     0.662    13.437     0.200
     0.680    13.967     0.200
     0.683    14.381     0.200
     0.707    14.207     0.200
     0.744    14.848     0.200
     0.753    15.813     0.200
     0.775    16.474     0.200
     0.849    17.342     0.200
     0.857    17.644     0.200
     0.871    18.000     0.200
     0.933    19.272     0.200
     0.943    19.562     0.200
     0.959    20.131     0.200
     0.969    20.978     0.200
     0.997    19.971     0.200
     1.114    23.063     0.200
     1.173    23.939     0.200
     1.749    35.437     0.200
     1.749    34.390     0.200
     1.957    38.001     0.200
     1.976    39.009     0.200
     2.083    40.443     0.200
     0.135     3.671     0.200
     0.134     3.891     0.200
     0.181     4.517     0.200
     0.216     4.998     0.200
     0.257     6.166     0.200
     0.341     7.359     0.200
     0.331     7.310     0.200
     0.416     8.922     0.200
     0.420     8.908     0.200
     0.455     9.656     0.200
     0.601    11.647     0.200
     0.661    13.026     0.200
     0.746    15.305     0.200
     0.751    15.147     0.200
     0.770    15.939     0.200
     0.813    16.635     0.200
     0.901    19.364     0.200
     0.928    19.310     0.200
     0.974    20.823     0.200
     0.983    20.446     0.200
     0.984    20.510     0.200
     1.121    22.598     0.200
     1.162    23.606     0.200
     1.787    35.298     0.200
     1.978    39.412     0.200
     2.004    39.455     0.200
     2.120    41.032     0.200
     0.020     4.280     0.200
     0.096     4.054     0.200
     0.148     4.436     0.200
     0.188     5.030     0.200
     0.238     5.376     0.200
     0.475     9.469     0.200
     0.481    10.092     0.200
     0.497    10.049     0.200
     0.504    11.105     0.200
     0.620    13.107     0.200
     0.680    14.047     0.200
     0.703    14.829     0.200
     0.736    15.531     0.200
     0.765    15.666     0.200
     0.796    17.095     0.200
     0.021     4.248     0.200
     0.106     4.112     0.200
     0.138     4.562     0.200
     0.188     4.920     0.200
     0.229     5.408     0.200
     0.380     7.875     0.200
     0.448     8.829     0.200
     0.482     9.709     0.200
     0.491    10.143     0.200
     0.487    10.311     0.200
     0.504    11.044     0.200
     0.621    13.084     0.200
     0.625    12.928     0.200
     0.672    13.751     0.200
     0.676    14.833     0.200
     0.696    13.994     0.200
     0.709    14.534     0.200
     0.709    15.269     0.200
     0.726    14.938     0.200
     0.731    15.247     0.200
     0.759    15.883     0.200
     0.793    16.544     0.200
     0.826    16.659     0.200
     0.856    18.433     0.200
     0.912    18.733     0.200
     0.972    19.906     0.200
     0.995    20.690     0.200
     1.154    22.889     0.200
     0.134     5.616     0.200
     0.174     5.880     0.200
     0.207     6.116     0.200
     0.299     7.118     0.200
     0.337     7.615     0.200
     0.386     8.974     0.200
     0.486    10.028     0.200
     0.556    12.502     0.200
     0.583    11.949     0.200
     0.625    13.812     0.200
     0.644    14.023     0.200
     0.695    14.307     0.200
     0.706    14.927     0.200
     0.724    14.887     0.200
     0.729    14.808     0.200
     0.743    15.543     0.200
     0.768    15.986     0.200
     0.834    17.001     0.200
     0.839    17.548     0.200
     0.828    17.383     0.200
     0.858    17.963     0.200
     0.915    18.963     0.200
     1.172    22.275     0.200
     2.702    50.019     0.200
     0.147     5.689     0.200
     0.188     5.656     0.200
     0.216     6.120     0.200
     0.313     6.560     0.200
     0.352     7.467     0.200
     0.397     8.426     0.200
     0.498    10.901     0.200
     0.562    11.858     0.200
     0.598    12.181     0.200
     0.636    12.792     0.200
     0.659    13.624     0.200
     0.700    14.818     0.200
     0.712    15.162     0.200
     0.736    15.745     0.200
     0.744    15.314     0.200
     0.744    15.913     0.200
     0.783    16.167     0.200
     0.837    17.161     0.200
     0.853    17.181     0.200
     0.870    18.181     0.200
     0.877    18.336     0.200
     0.930    19.515     0.200
     0.157     5.584     0.200
     0.196     5.978     0.200
     0.196     6.099     0.200
     0.219     6.354     0.200
     0.323     7.117     0.200
     0.360     7.810     0.200
     0.405     8.758     0.200
     0.507    10.624     0.200
     0.568    12.524     0.200
     0.607    11.778     0.200
     0.641    13.727     0.200
     0.668    14.615     0.200
     0.706    15.051     0.200
     0.719    15.573     0.200
     0.745    15.466     0.200
     0.747    15.873     0.200
     0.792    16.556     0.200
     0.850    17.937     0.200
     0.841    17.241     0.200
     0.876    17.896     0.200
     0.940    19.421     0.200
     0.062     3.653     0.200
     0.094     3.818     0.200
     0.147     3.618     0.200
     0.209     5.289     0.200
     0.214     4.945     0.200
     0.286     6.389     0.200
     0.346     7.366     0.200
     0.422     9.203     0.200
     0.484     8.889     0.200
     0.521    10.955     0.200
     0.526    10.119     0.200
     0.544    11.286     0.200
     0.623    12.554     0.200
     0.644    13.109     0.200
     0.651    12.929     0.200
     0.689    13.742     0.200
     0.691    13.914     0.200
     0.716    14.020     0.200
     0.748    15.819     0.200
     0.741    15.746     0.200
     0.773    15.784     0.200
     0.867    19.023     0.200
     1.064    22.088     0.200
     1.095    22.736     0.200
     0.094     4.247     0.200
     0.107     4.042     0.200
     0.155     4.869     0.200
     0.262     5.416     0.200
     0.258     6.129     0.200
     0.287     6.788     0.200
     0.417     8.618     0.200
     0.499    10.616     0.200
     0.525    11.131     0.200
     0.560    11.208     0.200
     0.578    11.869     0.200
     0.609    12.286     0.200
     0.649    13.430     0.200
     0.694    14.348     0.200
     0.697    13.804     0.200
     0.729    15.727     0.200
     0.728    14.636     0.200
     0.737    15.475     0.200
     0.756    14.899     0.200
     0.791    16.701     0.200
     0.825    17.226     0.200
     0.821    17.118     0.200
     0.842    17.787     0.200
     0.924    18.906     0.200
     0.941    19.623     0.200
     0.976    20.454     0.200
     1.201    23.567     0.200
     0.185     4.833     0.200
     0.267     5.677     0.200
     0.303     6.011     0.200
     0.469     9.433     0.200
     0.594    12.841     0.200
     0.676    13.715     0.200
     0.696    14.362     0.200
     0.852    17.506     0.200
     0.973    19.733     0.200
     0.994    20.326     0.200
     1.617    31.912     0.200
     0.100     4.260     0.200
     0.115     3.667     0.200
     0.151     4.608     0.200
     0.258     6.149     0.200
     0.317     6.739     0.200
     0.568    12.122     0.200
     0.591    11.941     0.200
     0.636    13.958     0.200
     0.854    17.014     0.200
     0.960    19.772     0.200
     1.105    22.832     0.200
     1.757    34.626     0.200
     0.035     2.915     0.200
     0.245     5.933     0.200
     0.367     6.884     0.200
     0.401     8.043     0.200
     0.453     9.514     0.200
     0.671    14.142     0.200
     0.683    15.003     0.200
     0.705    14.752     0.200
     0.970    19.871     0.200
     1.082    22.305     0.200
     1.114    22.813     0.200
     0.138     3.998     0.200
     0.170     4.623     0.200
     0.191     4.766     0.200
     0.282     6.485     0.200
     0.293     7.146     0.200
     0.398     8.793     0.200
     0.451     9.603     0.200
     0.467    10.103     0.200
     0.522    10.871     0.200
     0.652    13.946     0.200
     0.661    14.006     0.200
     0.725    15.607     0.200
     0.107     3.637     0.200
     0.126     3.581     0.200
     0.146     4.063     0.200
     0.153     4.124     0.200
     0.300     6.301     0.200
     0.313     6.742     0.200
     0.324     6.544     0.200
     0.515    10.754     0.200
     0.527    10.218     0.200
     0.540    11.149     0.200
     0.621    12.696     0.200
     0.160     3.399     0.200
     0.290     6.418     0.200
     0.297     6.204     0.200
     0.301     6.194     0.200
     0.316     6.740     0.200
     0.352     7.632     0.200
     0.424     9.039     0.200
     0.460     9.758     0.200
     0.618    12.336     0.200
     0.719    15.233     0.200
     0.737    14.989     0.200
     0.818    17.004     0.200
     1.831    37.208     0.200
     1.851    37.725     0.200
     0.088     2.963     0.200
     0.177     4.480     0.200
     0.223     5.360     0.200
     0.230     5.334     0.200
     0.295     6.633     0.200
     0.335     7.471     0.200
     0.368     7.755     0.200
     0.368     8.041     0.200
     0.489    10.274     0.200
     0.585    12.485     0.200
     0.594    12.263     0.200
     0.030     3.850     0.200
     0.096     4.165     0.200
     0.151     4.739     0.200
     0.195     5.400     0.200
     0.250     6.125     0.200
     0.248     6.157     0.200
     0.328     7.420     0.200
     0.478    10.542     0.200
     0.516    11.708     0.200
     0.990    20.361     0.200
     0.065     2.760     0.200
     0.201     4.363     0.200
     0.261     6.156     0.200
     0.277     6.147     0.200
     0.278     6.213     0.200
     0.279     6.154     0.200
     0.331     6.998     0.200
     0.375     7.918     0.200
     0.389     8.189     0.200
     0.502    10.206     0.200
     0.553    10.939     0.200
     0.596    12.214     0.200
     0.618    12.653     0.200
     0.630    13.059     0.200
     0.702    14.000     0.200
     0.707    13.982     0.200
     0.732    14.064     0.200
     0.703    14.350     0.200
     0.767    15.633     0.200
     0.778    15.815     0.200
     0.825    17.264     0.200
     0.827    16.703     0.200
     0.827    17.283     0.200
     0.855    17.057     0.200
     0.962    20.243     0.200
     0.996    20.735     0.200
     1.003    19.799     0.200
     1.197    24.539     0.200
     1.974    38.913     0.200
     2.658    47.466     0.200
     2.710    48.414     0.200
     0.054     2.647     0.200
     0.206     4.935     0.200
     0.271     6.563     0.200
     0.266     6.069     0.200
     0.267     6.075     0.200
     0.282     6.115     0.200
     0.322     7.010     0.200
     0.364     8.111     0.200
     0.377     8.274     0.200
     0.541    11.616     0.200
     0.588    12.535     0.200
     0.620    12.844     0.200
     0.631    12.530     0.200
     0.693    14.373     0.200
     0.717    14.887     0.200
     0.779    16.116     0.200
     0.835    16.739     0.200
     0.839    16.947     0.200
     0.973    20.959     0.200
     1.210    24.642     0.200
     0.059     2.728     0.200
     0.203     4.818     0.200
     0.266     5.917     0.200
     0.279     5.929     0.200
     0.272     6.214     0.200
     0.273     6.056     0.200
     0.327     7.089     0.200
     0.369     7.562     0.200
     0.369     8.193     0.200
     0.383     8.572     0.200
     0.507    10.064     0.200
     0.547    11.249     0.200
     0.592    12.603     0.200
     0.624    13.210     0.200
     0.624    12.454     0.200
     0.625    13.479     0.200
     0.698    14.409     0.200
     0.731    14.012     0.200
     0.830    16.948     0.200
     1.858    36.875     0.200
     0.045     2.629     0.200
     0.200     4.718     0.200
     0.259     5.928     0.200
     0.265     6.100     0.200
     0.270     6.273     0.200
     0.276     6.202     0.200
     0.326     6.846     0.200
     0.355     7.320     0.200
     0.372     8.350     0.200
     0.513    10.587     0.200
     0.533    11.334     0.200
     0.578    12.055     0.200
     0.683    14.185     0.200
     0.874    17.416     0.200
     0.974    20.071     0.200
     0.067     3.204     0.200
     0.133     3.279     0.200
     0.191     4.870     0.200
     0.205     4.571     0.200
     0.205     5.215     0.200
     0.317     6.946     0.200
     0.409     8.770     0.200
     0.423     8.960     0.200
     0.483    10.188     0.200
     0.498    10.614     0.200
     0.563    11.934     0.200
     0.586    12.710     0.200
     0.635    13.371     0.200
     1.055    21.971     0.200
     1.867    37.790     0.200
     0.060     2.659     0.200
     0.202     4.608     0.200
     0.265     6.156     0.200
     0.278     6.028     0.200
     0.273     6.104     0.200
     0.274     5.858     0.200
     0.328     7.488     0.200
     0.369     8.185     0.200
     0.384     8.597     0.200
     0.592    12.431     0.200
     0.623    13.149     0.200
     0.772    15.322     0.200
     0.828    16.450     0.200
     1.044    22.207     0.200
     0.051     2.552     0.200
     0.204     4.636     0.200
     0.264     6.062     0.200
     0.271     6.331     0.200
     0.266     5.814     0.200
     0.280     6.116     0.200
     0.323     6.816     0.200
     0.361     7.877     0.200
     0.375     8.302     0.200
     0.513    10.740     0.200
     0.538    11.085     0.200
     0.584    11.925     0.200
     0.616    12.560     0.200
     0.632    13.457     0.200
     0.717    15.144     0.200
     0.781    16.167     0.200
     0.785    16.274     0.200
     0.820    17.391     0.200
     0.834    16.493     0.200
     0.841    17.513     0.200
     0.974    20.010     0.200
     1.049    22.306     0.200
     1.211    24.250     0.200
     1.866    37.243     0.200
     0.039     2.641     0.200
     0.187     4.704     0.200
     0.252     5.998     0.200
     0.263     5.929     0.200
     0.264     6.176     0.200
     0.268     5.917     0.200
     0.346     7.788     0.200
     0.372     8.345     0.200
     0.527    11.668     0.200
     0.565    11.999     0.200
     0.600    11.942     0.200
     0.051     2.723     0.200
     0.206     4.868     0.200
     0.264     6.182     0.200
     0.273     6.548     0.200
     0.264     6.009     0.200
     0.282     6.149     0.200
     0.321     7.145     0.200
     0.361     7.903     0.200
     0.374     8.403     0.200
     0.515    10.799     0.200
     0.538    11.010     0.200
     0.586    11.986     0.200
     0.617    13.118     0.200
     0.633    12.877     0.200
     0.633    13.271     0.200
     0.690    14.525     0.200
     0.719    14.999     0.200
     0.787    16.042     0.200
     0.782    17.304     0.200
     0.836    17.681     0.200
     1.011    21.134     0.200
     1.051    21.829     0.200
     0.072     3.739     0.200
     0.103     3.651     0.200
     0.182     5.318     0.200
     0.230     6.007     0.200
     0.245     5.822     0.200
     0.338     7.722     0.200
     0.425     9.141     0.200
     0.449     9.971     0.200
     0.523    11.365     0.200
     0.575    12.311     0.200
     0.607    13.317     0.200
     0.646    14.370     0.200
     0.983    20.392     0.200
     1.098    22.203     0.200
     0.072     3.532     0.200
     0.338     7.351     0.200
     0.425     8.824     0.200
     0.537    11.278     0.200
     0.646    14.479     0.200
     1.098    21.976     0.200
     0.043     2.613     0.200
     0.209     5.018     0.200
     0.255     5.879     0.200
     0.256     5.624     0.200
     0.280     6.026     0.200
     0.286     6.196     0.200
     0.316     7.091     0.200
     0.353     7.725     0.200
     0.365     8.211     0.200
     0.522    10.483     0.200
     0.529    10.622     0.200
     0.579    12.194     0.200
     0.609    12.732     0.200
     0.642    12.922     0.200
     0.642    13.140     0.200
     0.682    14.154     0.200
     0.696    14.140     0.200
     0.729    14.318     0.200
     0.726    15.156     0.200
     0.791    15.681     0.200
     0.792    16.429     0.200
     0.819    17.398     0.200
     0.843    17.308     0.200
     0.851    17.440     0.200
     0.880    18.576     0.200
     0.983    20.492     0.200
     1.022    20.719     0.200
     1.021    20.753     0.200
     1.057    21.461     0.200
     1.221    24.911     0.200
     1.636    33.482     0.200
     1.667    33.723     0.200
     1.876    37.799     0.200
     1.998    39.502     0.200
     0.045     3.138     0.200
     0.198     5.052     0.200
     0.259     6.327     0.200
     0.269     6.532     0.200
     0.265     6.168     0.200
     0.275     6.430     0.200
     0.327     7.959     0.200
     0.355     8.117     0.200
     0.373     8.593     0.200
     0.577    13.191     0.200
     0.633    13.345     0.200
     0.683    14.868     0.200
     0.784    16.481     0.200
     0.842    17.795     0.200
     0.198     5.582     0.200
     0.327     7.479     0.200
     0.355     8.007     0.200
     0.373     8.263     0.200
     0.533    11.663     0.200
     0.577    12.791     0.200
     0.683    14.488     0.200
     0.055     4.826     0.200
     0.218     6.449     0.200
     0.274     7.224     0.200
     0.278     7.394     0.200
     0.385     9.188     0.200
     0.466     9.756     0.200
     0.466    10.506     0.200
     0.557    12.147     0.200
     0.620    14.023     0.200
     0.654    14.446     0.200
     0.063     2.751     0.200
     0.195     4.501     0.200
     0.257     5.879     0.200
     0.271     5.528     0.200
     0.276     6.329     0.200
     0.372     8.242     0.200
     0.390     8.457     0.200
     0.459     8.903     0.200
     0.447     9.094     0.200
     0.498    10.024     0.200
     0.595    12.356     0.200
     0.617    13.147     0.200
     0.618    13.016     0.200
     0.626    13.238     0.200
     0.767    16.020     0.200
     1.850    36.884     0.200
     0.049     2.568     0.200
     0.199     4.411     0.200
     0.268     6.029     0.200
     0.262     5.805     0.200
     0.275     5.653     0.200
     0.359     7.831     0.200
     0.376     8.082     0.200
     0.451     8.981     0.200
     0.473     9.409     0.200
     0.608    12.509     0.200
     0.614    12.859     0.200
     0.631    12.938     0.200
     0.632    13.059     0.200
     0.781    16.016     0.200
     1.045    21.648     0.200
     1.655    33.766     0.200
     0.530     9.317     0.200
     0.628    12.754     0.200
     0.083     2.773     0.200
     0.180     3.931     0.200
     0.231     4.902     0.200
     0.257     5.650     0.200
     0.310     6.785     0.200
     0.292     6.519     0.200
     0.361     7.604     0.200
     0.539     9.967     0.200
     0.585    11.740     0.200
     0.605    12.261     0.200
     0.629    13.851     0.200
     0.750    14.776     0.200
     0.895    17.745     0.200
     0.900    18.187     0.200
     1.295    26.131     0.200
     0.901    17.390     0.200
     0.838    16.077     0.200
     2.437    45.105     0.200
     3.131    56.726     0.200
     0.089     3.621     0.200
     0.089     3.739     0.200
     0.161     3.956     0.200
     0.236     5.196     0.200
     0.256     5.690     0.200
     0.295     6.724     0.200
     0.321     6.284     0.200
     0.511    10.479     0.200
     0.514    10.161     0.200
     0.591    12.590     0.200
     0.665    13.120     0.200
     0.785    16.498     0.200
     1.181    24.158     0.200
     0.111     3.063     0.200
     0.262     5.597     0.200
     0.263     6.056     0.200
     0.284     6.053     0.200
     0.304     6.703     0.200
     0.608    12.425     0.200
     0.658    13.630     0.200
     0.671    13.725     0.200
     0.808    16.291     0.200
     0.818    16.529     0.200
     0.961    20.296     0.200
     0.023     4.477     0.200
     0.138     4.598     0.200
     0.191     5.011     0.200
     0.231     5.618     0.200
     0.308     7.074     0.200
     0.318     6.990     0.200
     0.484     9.694     0.200
     0.489    10.254     0.200
     0.585    11.815     0.200
     0.727    14.800     0.200
     0.732    15.026     0.200
     0.748    15.601     0.200
     0.761    16.062     0.200
     0.795    16.354     0.200
     0.211     4.879     0.200
     0.297     6.818     0.200
     0.410     8.559     0.200
     0.412     8.908     0.200
     0.447     9.611     0.200
     0.468    10.112     0.200
     0.486    10.409     0.200
     0.701    14.638     0.200
     0.749    15.362     0.200
     0.737    15.681     0.200
     2.157    42.327     0.200
     0.061     2.553     0.200
     0.206     4.587     0.200
     0.273     5.965     0.200
     0.282     5.937     0.200
     0.371     8.085     0.200
     0.382     8.326     0.200
     0.466     8.953     0.200
     0.452     9.175     0.200
     0.597    12.119     0.200
     0.604    12.788     0.200
     0.625    12.629     0.200
     0.833    16.927     0.200
     1.107    22.731     0.200
     0.048     3.047     0.200
     0.199     4.882     0.200
     0.262     6.335     0.200
     0.269     6.424     0.200
     0.276     6.171     0.200
     0.358     7.732     0.200
     0.375     8.401     0.200
     0.440     8.818     0.200
     0.452     9.679     0.200
     0.474     9.239     0.200
     0.511    10.579     0.200
     0.600    12.700     0.200
     0.609    13.166     0.200
     0.631    13.401     0.200
     0.633    13.260     0.200
     0.686    14.043     0.200
     0.691    14.516     0.200
     0.202     5.052     0.200
     0.262     5.869     0.200
     0.278     6.205     0.200
     0.279     6.279     0.200
     0.330     7.276     0.200
     0.375     8.229     0.200
     0.389     8.804     0.200
     0.459     8.818     0.200
     0.452     9.573     0.200
     0.617    12.795     0.200
     0.618    13.097     0.200
     0.631    12.998     0.200
     0.703    14.536     0.200
     0.766    16.118     0.200
     0.780    16.566     0.200
     0.827    16.946     0.200
     0.828    16.696     0.200
     0.546    10.236     0.200
     0.199     4.779     0.200
     0.262     6.486     0.200
     0.274     6.389     0.200
     0.275     6.203     0.200
     0.370     8.080     0.200
     0.446     9.628     0.200
     0.451     9.386     0.200
     0.621    13.161     0.200
     0.621    13.110     0.200
     0.698    14.855     0.200
     0.778    15.854     0.200
     0.823    17.377     0.200
     0.213     4.886     0.200
     0.277     5.782     0.200
     0.289     6.269     0.200
     0.375     7.658     0.200
     0.383     8.251     0.200
     0.466     9.509     0.200
     0.460     9.295     0.200
     0.512    10.361     0.200
     0.592    12.191     0.200
     0.602    12.728     0.200
     0.622    12.791     0.200
     0.625    12.681     0.200
     0.705    15.166     0.200
     0.771    15.657     0.200
     0.833    17.113     0.200
     0.836    17.998     0.200
     0.052     3.664     0.200
     0.128     4.535     0.200
     0.168     4.744     0.200
     0.202     4.798     0.200
     0.302     5.372     0.200
     0.326     7.322     0.200
     0.406     8.509     0.200
     0.554    10.953     0.200
     0.551    11.383     0.200
     0.601    12.314     0.200
     0.690    13.272     0.200
     0.697    13.994     0.200
     0.797    15.577     0.200
     0.205     4.279     0.200
     0.271     5.910     0.200
     0.266     5.788     0.200
     0.267     6.097     0.200
     0.281     5.936     0.200
     0.323     6.936     0.200
     0.363     8.105     0.200
     0.376     8.170     0.200
     0.447     9.234     0.200
     0.472     9.162     0.200
     0.457     9.046     0.200
     0.458     9.237     0.200
     0.512    10.560     0.200
     0.540    11.054     0.200
     0.587    12.312     0.200
     0.603    11.905     0.200
     0.604    12.802     0.200
     0.599    12.760     0.200
     0.619    13.213     0.200
     0.631    12.852     0.200
     0.630    13.292     0.200
     0.692    14.855     0.200
     0.698    14.389     0.200
     0.730    14.550     0.200
     0.779    15.474     0.200
     0.785    17.006     0.200
     0.823    17.492     0.200
     0.834    16.955     0.200
     1.009    21.054     0.200
     1.013    20.930     0.200
     1.049    21.766     0.200
     1.111    23.072     0.200
     1.154    24.056     0.200
     1.834    36.842     0.200
     1.864    37.641     0.200
     1.987    39.425     0.200
     0.533     9.526     0.200
     0.631    12.459     0.200
     0.623    11.980     0.200
     0.036     4.445     0.200
     0.127     4.207     0.200
     0.202     5.164     0.200
     0.230     5.538     0.200
     0.253     6.072     0.200
     0.299     7.080     0.200
     0.304     6.998     0.200
     0.375     7.781     0.200
     0.447     9.146     0.200
     0.496    10.357     0.200
     0.497    10.531     0.200
     0.502    10.645     0.200
     0.516    11.097     0.200
     0.635    12.952     0.200
     0.711    15.036     0.200
     0.720    15.280     0.200
     0.723    14.497     0.200
     0.743    15.295     0.200
     0.802    16.944     0.200
     0.988    20.001     0.200
     1.009    20.740     0.200
     0.061     1.441     0.200
     0.142     2.688     0.200
     0.227     4.859     0.200
     0.369     7.959     0.200
     0.374     8.172     0.200
     0.390     7.972     0.200
     0.395     7.903     0.200
     0.420     8.594     0.200
     0.525    10.313     0.200
     0.533    11.537     0.200
     0.537    11.143     0.200
     0.562    11.082     0.200
     0.572    11.928     0.200
     0.802    17.519     0.200
     0.921    19.330     0.200
     0.972    20.026     0.200
     0.063     3.947     0.200
     0.091     3.641     0.200
     0.177     4.737     0.200
     0.186     4.531     0.200
     0.252     6.255     0.200
     0.323     6.848     0.200
     0.309     7.230     0.200
     0.393     8.473     0.200
     0.448     9.100     0.200
     0.488    10.321     0.200
     0.506    10.869     0.200
     0.516    11.025     0.200
     0.527    10.353     0.200
     0.587    12.013     0.200
     0.613    12.502     0.200
     0.620    12.950     0.200
     0.669    14.018     0.200
     0.675    14.461     0.200
     0.682    13.818     0.200
     0.690    14.279     0.200
     0.692    14.205     0.200
     0.713    15.176     0.200
     0.736    15.720     0.200
     0.764    16.130     0.200
     0.975    19.916     0.200
     1.052    21.822     0.200
     0.055     3.774     0.200
     0.099     3.256     0.200
     0.180     4.504     0.200
     0.180     4.484     0.200
     0.260     6.007     0.200
     0.316     6.672     0.200
     0.330     6.600     0.200
     0.449     9.688     0.200
     0.484    10.411     0.200
     0.498    10.501     0.200
     0.535    11.294     0.200
     0.587    12.710     0.200
     0.608    12.576     0.200
     0.623    12.584     0.200
     0.676    14.292     0.200
     0.680    14.219     0.200
     0.683    14.619     0.200
     0.684    14.076     0.200
     0.695    13.812     0.200
     0.715    14.891     0.200
     0.727    14.996     0.200
     0.762    16.007     0.200
     0.775    16.943     0.200
     0.852    18.345     0.200
     0.865    18.765     0.200
     0.944    19.951     0.200
     0.961    20.308     0.200
     0.982    20.723     0.200
     0.983    20.828     0.200
     0.986    20.933     0.200
     1.103    22.666     0.200
     1.100    22.932     0.200
     1.206    24.250     0.200
     0.315     6.389     0.200
     1.245    24.330     0.200
     1.335    25.331     0.200
     0.060     3.783     0.200
     0.092     3.635     0.200
     0.180     4.422     0.200
     0.187     4.493     0.200
     0.255     6.367     0.200
     0.308     7.386     0.200
     0.397     8.037     0.200
     0.451     9.835     0.200
     0.490    11.027     0.200
     0.506    10.420     0.200
     0.590    12.375     0.200
     0.615    12.885     0.200
     0.623    13.158     0.200
     0.672    13.785     0.200
     0.678    14.383     0.200
     0.685    13.994     0.200
     0.692    14.440     0.200
     0.717    15.026     0.200
     0.735    15.358     0.200
     0.767    16.192     0.200
     0.860    18.343     0.200
     0.978    19.856     0.200
     0.976    20.217     0.200
     0.994    20.703     0.200
     0.105     2.684     0.200
     0.090     2.683     0.200
     0.216     4.990     0.200
     0.260     5.881     0.200
     0.293     6.154     0.200
     0.348     7.546     0.200
     0.335     7.780     0.200
     0.369     7.845     0.200
     0.362     8.261     0.200
     0.375     7.646     0.200
     0.383     7.493     0.200
     0.498    10.780     0.200
     0.516    10.961     0.200
     0.554    11.399     0.200
     0.561    11.550     0.200
     0.596    12.264     0.200
     0.613    12.790     0.200
     0.648    14.127     0.200
     0.834    17.607     0.200
     0.882    18.329     0.200
     0.931    19.369     0.200
     0.090     5.148     0.200
     0.170     5.272     0.200
     0.188     5.873     0.200
     0.262     6.932     0.200
     0.310     7.038     0.200
     0.323     7.466     0.200
     0.330     7.951     0.200
     0.323     7.651     0.200
     0.385     9.868     0.200
     0.442     9.015     0.200
     0.434     9.687     0.200
     0.534    11.507     0.200
     0.610    12.564     0.200
     0.582    13.355     0.200
     0.639    13.002     0.200
     0.674    14.070     0.200
     0.734    15.039     0.200
     0.767    16.069     0.200
     0.792    15.691     0.200
     0.810    16.278     0.200
     0.834    16.642     0.200
     0.897    18.642     0.200
     0.970    19.327     0.200
     0.972    19.838     0.200
     1.002    19.927     0.200
     1.042    20.297     0.200
     1.685    32.118     0.200
     1.739    33.533     0.200
     1.731    32.803     0.200
     1.789    34.302     0.200
     1.832    35.201     0.200
     1.907    35.835     0.200
     1.930    36.513     0.200
     1.958    37.678     0.200
     0.119     2.779     0.200
     0.228     4.787     0.200
     0.210     5.405     0.200
     0.247     5.209     0.200
     0.272     5.911     0.200
     0.389     8.548     0.200
     0.384     8.284     0.200
     0.476     9.682     0.200
     0.527    11.209     0.200
     0.545    11.718     0.200
     0.529    11.846     0.200
     0.551    11.285     0.200
     0.661    13.645     0.200
     0.657    13.887     0.200
     0.703    14.978     0.200
     0.719    15.102     0.200
     0.846    17.027     0.200
     0.828    18.335     0.200
     0.971    19.367     0.200
     1.031    21.664     0.200
     1.088    21.087     0.200
     0.207     4.347     0.200
     0.268     5.663     0.200
     0.283     5.849     0.200
     0.272     5.980     0.200
     0.274     6.212     0.200
     0.324     7.039     0.200
     0.371     8.136     0.200
     0.383     8.463     0.200
     0.466     9.027     0.200
     0.452     9.095     0.200
     0.453     9.521     0.200
     0.459    10.048     0.200
     0.509    10.525     0.200
     0.548    11.751     0.200
     0.596    12.771     0.200
     0.602    12.420     0.200
     0.595    12.683     0.200
     0.604    12.526     0.200
     0.623    12.563     0.200
     0.625    12.850     0.200
     0.627    13.181     0.200
     0.704    14.494     0.200
     0.700    14.870     0.200
     0.714    14.616     0.200
     0.735    14.459     0.200
     0.772    16.267     0.200
     0.785    16.620     0.200
     0.832    17.074     0.200
     0.833    17.114     0.200
     0.829    17.259     0.200
     0.969    20.262     0.200
     1.002    21.113     0.200
     1.010    20.927     0.200
     1.047    21.779     0.200
     1.107    22.563     0.200
     1.148    23.824     0.200
     1.204    24.970     0.200
     1.649    33.728     0.200
     1.829    36.924     0.200
     1.859    37.862     0.200
     1.980    39.404     0.200
     0.541    10.270     0.200
     0.639    12.686     0.200
     0.615    12.128     0.200
     2.068    42.004     0.200
     0.061     1.649     0.200
     0.174     4.322     0.200
     0.196     3.839     0.200
     0.241     5.495     0.200
     0.320     6.089     0.200
     0.353     7.633     0.200
     0.389     8.515     0.200
     0.429     8.177     0.200
     0.428     9.079     0.200
     0.480     9.211     0.200
     0.490     9.594     0.200
     0.487    10.582     0.200
     0.512    10.348     0.200
     0.633    13.552     0.200
     0.705    14.391     0.200
     0.716    15.109     0.200
     0.721    15.281     0.200
     0.786    16.583     0.200
     0.959    19.528     0.200
     1.037    21.638     0.200
     1.105    22.012     0.200
     1.153    24.209     0.200
     1.182    24.473     0.200
     1.776    35.740     0.200
     1.835    36.874     0.200
     0.050     1.300     0.200
     0.239     5.097     0.200
     0.247     5.982     0.200
     0.294     6.800     0.200
     0.354     7.431     0.200
     0.394     8.525     0.200
     0.386     8.421     0.200
     0.458    10.309     0.200
     0.539    11.365     0.200
     0.592    12.322     0.200
     0.805    16.989     0.200
     0.835    17.358     0.200
     0.908    18.976     0.200
     0.959    20.223     0.200
     1.304    26.965     0.200
     0.099     4.230     0.200
     0.236     5.413     0.200
     0.241     5.509     0.200
     0.236     5.881     0.200
     0.334     7.213     0.200
     0.389     7.388     0.200
     0.376     8.036     0.200
     0.370     7.937     0.200
     0.445     9.020     0.200
     0.451     9.494     0.200
     0.513    11.280     0.200
     0.528    10.953     0.200
     0.598    11.781     0.200
     0.582    13.000     0.200
     0.740    14.548     0.200
     0.715    15.546     0.200
     0.755    14.934     0.200
     0.743    15.402     0.200
     0.771    15.734     0.200
     0.780    15.537     0.200
     0.756    15.890     0.200
     0.795    15.699     0.200
     0.784    16.683     0.200
     0.825    16.735     0.200
     0.953    19.433     0.200
     0.951    19.550     0.200
     1.086    21.995     0.200
     1.120    22.933     0.200
     1.144    22.886     0.200
     1.604    31.868     0.200
     1.646    33.130     0.200
     1.730    34.235     0.200
     1.744    34.508     0.200
     1.805    35.421     0.200
     0.135     3.244     0.200
     0.212     4.416     0.200
     0.295     6.604     0.200
     0.296     6.447     0.200
     0.320     7.544     0.200
     0.354     6.973     0.200
     0.372     7.105     0.200
     0.427     9.306     0.200
     0.547    10.651     0.200
     0.594    12.143     0.200
     0.636    12.525     0.200
     0.612    13.468     0.200
     0.863    17.861     0.200
     0.912    18.502     0.200
     0.943    19.381     0.200
     0.953    19.489     0.200
     1.096    23.041     0.200
     1.104    22.694     0.200
     1.154    23.492     0.200
     1.745    35.015     0.200
     1.804    35.817     0.200
     1.888    37.463     0.200
     1.902    37.888     0.200
     1.963    38.551     0.200
     0.081     3.831     0.200
     0.184     4.543     0.200
     0.231     5.425     0.200
     0.251     5.717     0.200
     0.262     6.701     0.200
     0.361     7.393     0.200
     0.425     7.921     0.200
     0.406     8.835     0.200
     0.491    10.195     0.200
     0.552    11.962     0.200
     0.591    13.402     0.200
     0.644    12.645     0.200
     0.634    12.506     0.200
     0.641    13.522     0.200
     0.657    13.079     0.200
     0.796    15.642     0.200
     0.926    18.619     0.200
     0.943    19.717     0.200
     0.987    19.915     0.200
     1.112    22.661     0.200
     1.129    22.409     0.200
     1.273    25.703     0.200
     1.634    31.481     0.200
     1.675    33.393     0.200
     1.791    35.759     0.200
     1.838    35.939     0.200
     1.929    37.822     0.200
     1.939    37.206     0.200
     1.989    38.988     0.200
     1.999    38.662     0.200
     0.099     3.683     0.200
     0.175     4.779     0.200
     0.246     5.491     0.200
     0.241     5.832     0.200
     0.309     6.999     0.200
     0.307     6.810     0.200
     0.349     7.433     0.200
     0.378     7.523     0.200
     0.373     8.570     0.200
     0.494    10.811     0.200
     0.592    11.523     0.200
     0.587    12.265     0.200
     0.604    12.385     0.200
     0.584    12.709     0.200
     0.639    14.374     0.200
     0.646    14.195     0.200
     0.740    14.413     0.200
     0.873    17.488     0.200
     0.897    17.975     0.200
     0.896    17.820     0.200
     0.922    18.818     0.200
     0.931    18.989     0.200
     1.073    21.909     0.200
     1.138    23.423     0.200
     1.217    24.322     0.200
     1.621    32.301     0.200
     1.736    34.554     0.200
     1.781    35.151     0.200
     1.873    36.257     0.200
     1.942    37.781     0.200
     0.040     4.704     0.200
     0.223     6.451     0.200
     0.297     6.874     0.200
     0.306     8.563     0.200
     0.397     9.232     0.200
     0.435     9.914     0.200
     0.502    10.736     0.200
     0.486    12.538     0.200
     0.542    12.797     0.200
     0.630    12.937     0.200
     0.611    13.738     0.200
     0.753    15.551     0.200
     0.787    15.787     0.200
     0.824    16.098     0.200
     0.837    17.742     0.200
     0.896    17.563     0.200
     0.900    17.833     0.200
     0.961    18.848     0.200
     1.084    20.991     0.200
     1.602    31.049     0.200
     1.646    32.008     0.200
     1.712    32.951     0.200
     1.763    33.835     0.200
     1.818    34.550     0.200
     1.825    34.898     0.200
     0.112     4.524     0.200
     0.144     4.452     0.200
     0.177     5.081     0.200
     0.238     5.498     0.200
     0.254     5.794     0.200
     0.255     6.158     0.200
     0.367     8.109     0.200
     0.401     9.641     0.200
     0.478     9.956     0.200
     0.539    11.609     0.200
     0.552    11.659     0.200
     0.606    13.491     0.200
     0.621    12.743     0.200
     0.636    12.846     0.200
     0.661    13.034     0.200
     0.701    14.959     0.200
     0.716    15.887     0.200
     0.743    15.720     0.200
     0.755    16.286     0.200
     0.772    16.299     0.200
     0.792    16.501     0.200
     0.787    16.377     0.200
     0.805    17.146     0.200
     0.865    18.150     0.200
     0.891    18.645     0.200
     0.907    19.358     0.200
     0.935    19.268     0.200
     0.983    20.529     0.200
     1.029    20.135     0.200
     1.079    22.229     0.200
     0.196     4.179     0.200
     0.261     5.646     0.200
     0.272     5.836     0.200
     0.271     5.984     0.200
     0.276     6.300     0.200
     0.332     7.261     0.200
     0.366     8.205     0.200
     0.384     8.486     0.200
     0.442     9.139     0.200
     0.448     9.409     0.200
     0.465     9.100     0.200
     0.449     9.448     0.200
     0.503    10.365     0.200
     0.545    11.484     0.200
     0.587    12.339     0.200
     0.601    12.706     0.200
     0.622    12.877     0.200
     0.624    13.266     0.200
     0.621    13.097     0.200
     0.693    14.486     0.200
     0.724    14.016     0.200
     0.694    14.662     0.200
     0.707    14.612     0.200
     0.773    15.888     0.200
     0.818    17.132     0.200
     0.824    17.247     0.200
     0.964    19.908     0.200
     1.003    20.738     0.200
     1.002    21.037     0.200
     1.039    21.598     0.200
     1.102    22.939     0.200
     1.146    23.834     0.200
     1.825    36.461     0.200
     1.856    37.107     0.200
     1.979    39.376     0.200
     0.142     4.049     0.200
     0.127     4.098     0.200
     0.281     5.753     0.200
     0.255     6.027     0.200
     0.346     6.685     0.200
     0.360     7.801     0.200
     0.339     7.828     0.200
     0.506    11.014     0.200
     0.557    11.074     0.200
     0.563    11.246     0.200
     0.574    11.541     0.200
     0.602    12.658     0.200
     0.611    13.645     0.200
     0.665    14.587     0.200
     0.704    14.175     0.200
     0.706    14.091     0.200
     0.672    15.051     0.200
     0.790    15.635     0.200
     0.797    15.962     0.200
     0.841    17.192     0.200
     0.865    17.522     0.200
     0.853    17.784     0.200
     0.870    17.766     0.200
     0.886    17.587     0.200
     0.895    18.134     0.200
     1.039    21.589     0.200
     1.103    22.235     0.200
     1.181    23.885     0.200
     1.249    25.164     0.200
     1.639    32.755     0.200
     1.690    33.564     0.200
     1.701    33.760     0.200
     1.746    34.736     0.200
     1.837    36.041     0.200
     1.847    35.909     0.200
     1.907    37.234     0.200
     0.870    16.744     0.200
     1.827    34.826     0.200
     1.911    35.061     0.200
     2.483    45.302     0.200
     0.118     3.240     0.200
     0.217     5.000     0.200
     0.327     6.913     0.200
     0.347     7.184     0.200
     0.346     7.656     0.200
     0.364     7.964     0.200
     0.595    12.250     0.200
     0.698    14.361     0.200
     0.783    15.853     0.200
     1.046    21.286     0.200
     1.059    21.609     0.200
     1.653    33.103     0.200
     0.170     4.284     0.200
     0.199     4.474     0.200
     0.223     5.450     0.200
     0.299     6.483     0.200
     0.351     7.246     0.200
     0.364     7.774     0.200
     0.461     9.544     0.200
     0.553    11.160     0.200
     0.579    12.157     0.200
     0.612    12.918     0.200
     0.630    13.012     0.200
     0.638    13.028     0.200
     0.655    13.862     0.200
     0.770    15.947     0.200
     0.770    15.747     0.200
     0.779    16.022     0.200
     0.770    16.190     0.200
     0.788    16.088     0.200
     0.788    16.491     0.200
     0.803    16.877     0.200
     0.837    17.025     0.200
     0.860    17.833     0.200
     0.853    17.540     0.200
     0.870    18.254     0.200
     0.943    19.382     0.200
     0.959    20.218     0.200
     0.981    20.390     0.200
     0.996    20.764     0.200
     1.011    21.074     0.200
     1.041    21.785     0.200
     1.050    21.772     0.200
     1.085    22.768     0.200
     1.248    24.793     0.200
     0.170     4.167     0.200
     0.199     4.334     0.200
     0.364     7.891     0.200
     0.612    13.090     0.200
     0.630    12.739     0.200
     0.638    13.192     0.200
     0.655    13.722     0.200
     0.770    15.611     0.200
     0.770    15.536     0.200
     0.779    16.256     0.200
     0.788    15.963     0.200
     0.770    16.479     0.200
     0.788    16.280     0.200
     0.837    16.908     0.200
     0.860    17.552     0.200
     0.853    17.954     0.200
     0.870    18.847     0.200
     0.943    19.007     0.200
     0.959    19.961     0.200
     1.011    21.285     0.200
     1.050    21.585     0.200
     1.041    21.887     0.200
     1.085    22.596     0.200
     1.134    23.638     0.200
     1.248    24.957     0.200
     0.212     5.428     0.200
     0.763    15.317     0.200
     1.308    24.990     0.200
     1.404    27.047     0.200
     0.135     3.771     0.200
     0.134     4.441     0.200
     0.213     5.575     0.200
     0.289     6.343     0.200
     0.302     6.608     0.200
     0.312     7.161     0.200
     0.398     8.344     0.200
     0.489    10.253     0.200
     0.570    11.735     0.200
     0.578    12.034     0.200
     0.579    12.387     0.200
     0.596    12.276     0.200
     0.613    12.764     0.200
     0.713    14.712     0.200
     0.720    14.782     0.200
     0.725    14.731     0.200
     0.727    14.881     0.200
     0.733    15.152     0.200
     0.773    16.091     0.200
     0.787    16.567     0.200
     0.782    16.393     0.200
     0.810    16.651     0.200
     0.853    18.142     0.200
     0.892    18.552     0.200
     0.925    19.263     0.200
     0.969    19.993     0.200
     0.968    20.191     0.200
     0.988    20.272     0.200
     0.991    20.533     0.200
     0.996    20.932     0.200
     1.078    22.512     0.200
     1.090    22.783     0.200
     1.184    23.118     0.200
     1.248    25.346     0.200
     0.331     7.374     0.200
     0.320     7.277     0.200
     0.341     7.573     0.200
     0.358     7.918     0.200
     0.417     8.101     0.200
     0.409     8.837     0.200
     0.419     9.324     0.200
     0.459    10.196     0.200
     0.482    10.521     0.200
     0.527    11.415     0.200
     0.535    11.152     0.200
     0.616    13.050     0.200
     0.686    14.301     0.200
     0.687    14.732     0.200
     0.692    14.640     0.200
     0.744    15.329     0.200
     0.763    15.927     0.200
     0.787    16.874     0.200
     0.860    18.250     0.200
     0.868    18.092     0.200
     0.894    18.048     0.200
     0.868    18.016     0.200
     0.880    18.213     0.200
     0.917    19.240     0.200
     0.972    20.362     0.200
     0.994    20.746     0.200
     1.113    23.080     0.200
     1.595    32.365     0.200
     1.816    36.052     0.200
     1.920    37.793     0.200
     0.162     4.169     0.200
     0.230     5.720     0.200
     0.293     6.334     0.200
     0.306     7.565     0.200
     0.353     7.733     0.200
     0.379     8.021     0.200
     0.479    10.431     0.200
     0.588    12.267     0.200
     0.590    12.298     0.200
     0.578    12.617     0.200
     0.818    16.975     0.200
     0.857    17.693     0.200
     0.921    18.744     0.200
     1.043    21.548     0.200
     1.131    23.340     0.200
     0.108     3.669     0.200
     0.133     4.057     0.200
     0.229     5.530     0.200
     0.232     5.888     0.200
     0.343     7.731     0.200
     0.391     8.515     0.200
     0.466     9.545     0.200
     0.470     9.961     0.200
     0.460     9.908     0.200
     0.568    12.014     0.200
     0.594    12.875     0.200
     0.610    13.133     0.200
     0.641    13.220     0.200
     0.667    14.133     0.200
     0.711    14.527     0.200
     0.789    16.806     0.200
     0.797    16.558     0.200
     0.806    17.008     0.200
     0.813    16.915     0.200
     0.852    17.068     0.200
     0.920    19.073     0.200
     0.939    19.685     0.200
     0.979    20.459     0.200
     1.033    21.770     0.200
     1.166    24.019     0.200
     1.612    32.515     0.200
     1.815    35.955     0.200
     0.111     3.418     0.200
     0.135     4.331     0.200
     0.279     6.469     0.200
     0.317     6.516     0.200
     0.398     8.307     0.200
     0.480     9.774     0.200
     0.481     9.937     0.200
     0.521    10.714     0.200
     0.664    13.661     0.200
     0.733    14.781     0.200
     0.745    15.395     0.200
     0.783    15.987     0.200
     0.993    20.117     0.200
     1.153    23.621     0.200
     1.202    24.662     0.200
     1.829    35.735     0.200
     2.283    43.824     0.200
     2.400    45.640     0.200
     0.021     3.068     0.200
     0.173     4.658     0.200
     0.172     4.339     0.200
     0.271     6.280     0.200
     0.349     7.624     0.200
     0.447     9.743     0.200
     0.501    10.717     0.200
     0.517    10.950     0.200
     0.539    11.165     0.200
     0.552    11.434     0.200
     0.572    12.056     0.200
     0.219     5.130     0.200
     0.228     5.153     0.200
     0.281     6.268     0.200
     0.309     6.700     0.200
     0.342     7.695     0.200
     0.361     7.896     0.200
     0.385     8.170     0.200
     0.393     8.322     0.200
     0.524    10.276     0.200
     0.528    10.620     0.200
     0.561    11.320     0.200
     0.642    13.419     0.200
     0.653    13.735     0.200
     0.691    14.138     0.200
     0.703    14.413     0.200
     0.726    15.265     0.200
     0.886    18.864     0.200
     0.927    19.294     0.200
     1.052    21.875     0.200
     1.105    22.960     0.200
     1.144    23.711     0.200
     1.192    24.503     0.200
     1.926    38.615     0.200
     0.153     4.687     0.200
     0.156     5.518     0.200
     0.177     5.230     0.200
     0.204     5.171     0.200
     0.327     7.497     0.200
     0.422     8.913     0.200
     0.452     9.789     0.200
     0.449     9.953     0.200
     0.469     9.672     0.200
     0.475    10.128     0.200
     0.546    11.422     0.200
     0.601    12.782     0.200
     0.606    12.330     0.200
     0.613    13.671     0.200
     0.662    14.287     0.200
     0.688    14.211     0.200
     0.688    14.689     0.200
     0.731    15.193     0.200
     0.792    16.683     0.200
     0.874    16.684     0.200
     0.864    17.261     0.200
     0.874    18.069     0.200
     0.943    19.244     0.200
     0.071     2.273     0.200
     0.144     2.674     0.200
     0.141     3.895     0.200
     0.449    10.489     0.200
     0.481     9.853     0.200
     0.466    10.289     0.200
     0.451     9.946     0.200
     0.691    14.552     0.200
     0.735    14.613     0.200
     1.235    24.877     0.200
     1.412    28.343     0.200
     1.811    35.962     0.200
     1.980    39.484     0.200
     2.075    40.474     0.200
     0.017     4.357     0.200
     0.161     4.043     0.200
     0.223     5.301     0.200
     0.221     5.512     0.200
     0.322     7.517     0.200
     0.386     7.853     0.200
     0.445     8.998     0.200
     0.450     9.738     0.200
     0.449     9.614     0.200
     0.469     9.859     0.200
     0.585    12.358     0.200
     0.601    12.150     0.200
     0.639    13.330     0.200
     0.662    13.003     0.200
     0.678    13.512     0.200
     0.666    14.190     0.200
     0.719    15.210     0.200
     0.741    15.411     0.200
     0.734    15.380     0.200
     0.745    15.892     0.200
     0.743    15.168     0.200
     0.763    16.371     0.200
     0.818    16.698     0.200
     0.936    19.796     0.200
     1.046    21.408     0.200
     0.116     3.790     0.200
     0.172     5.377     0.200
     0.256     5.874     0.200
     0.275     5.785     0.200
     0.316     6.487     0.200
     0.365     7.884     0.200
     0.433     9.516     0.200
     0.467    10.083     0.200
     0.443     9.544     0.200
     0.479     9.070     0.200
     0.516    10.559     0.200
     0.624    12.699     0.200
     0.630    13.070     0.200
     0.660    12.712     0.200
     0.662    14.190     0.200
     0.685    13.990     0.200
     0.703    14.511     0.200
     0.702    14.197     0.200
     0.682    15.056     0.200
     0.790    16.535     0.200
     0.858    17.512     0.200
     0.879    18.040     0.200
     0.867    18.729     0.200
     0.913    19.720     0.200
     0.981    19.566     0.200
     1.005    20.785     0.200
     1.024    21.007     0.200
     1.364    26.378     0.200
     1.608    32.040     0.200
     1.627    31.909     0.200
     1.689    33.034     0.200
     0.621    12.487     0.200
     1.598    30.496     0.200
     2.392    42.223     0.200
     2.454    43.566     0.200
     2.474    44.882     0.200
     2.714    48.389     0.200
     0.169     3.890     0.200
     0.223     4.474     0.200
     0.308     5.894     0.200
     0.469     9.626     0.200
     0.463     9.491     0.200
     0.589    11.661     0.200
     0.607    12.371     0.200
     0.609    12.756     0.200
     0.643    13.861     0.200
     0.676    13.943     0.200
     0.717    14.032     0.200
     0.778    16.133     0.200
     0.160     3.025     0.200
     0.209     3.729     0.200
     0.228     5.094     0.200
     0.322     6.271     0.200
     0.311     7.635     0.200
     0.345     7.366     0.200
     0.333     7.539     0.200
     0.374     7.691     0.200
     0.448     9.806     0.200
     0.483     9.077     0.200
     0.576    11.847     0.200
     0.586    12.838     0.200
     0.635    12.749     0.200
     0.695    14.571     0.200
     0.704    14.803     0.200
     0.874    17.434     0.200
     0.886    19.358     0.200
     0.927    18.877     0.200
     0.174     3.810     0.200
     0.190     4.827     0.200
     0.264     5.439     0.200
     0.357     7.470     0.200
     0.362     7.530     0.200
     0.425     8.210     0.200
     0.447     9.599     0.200
     0.485    10.746     0.200
     0.602    12.333     0.200
     0.645    14.004     0.200
     0.773    15.782     0.200
     0.779    15.881     0.200
     0.780    16.337     0.200
     0.786    16.402     0.200
     0.792    16.032     0.200
     0.786    16.614     0.200
     0.827    17.141     0.200
     0.929    19.569     0.200
     1.024    21.336     0.200
     1.191    23.357     0.200
     0.226     5.113     0.200
     0.278     5.466     0.200
     0.387     7.880     0.200
     0.392     9.118     0.200
     0.407     8.934     0.200
     0.499     9.766     0.200
     0.571    11.876     0.200
     0.604    12.497     0.200
     0.658    13.511     0.200
     0.665    14.095     0.200
     0.745    16.041     0.200
     0.773    15.998     0.200
     0.775    15.124     0.200
     0.790    16.804     0.200
     0.796    16.371     0.200
     0.801    16.946     0.200
     0.807    16.838     0.200
     0.820    16.966     0.200
     1.044    21.642     0.200
     1.111    22.701     0.200
     1.202    24.040     0.200
     0.054     3.441     0.200
     0.123     3.928     0.200
     0.217     5.789     0.200
     0.226     4.824     0.200
     0.244     6.048     0.200
     0.244     6.323     0.200
     0.313     7.683     0.200
     0.362     8.197     0.200
     0.386     9.327     0.200
     0.395     8.834     0.200
     0.466     9.114     0.200
     0.626    13.456     0.200
     0.657    13.650     0.200
     0.676    14.159     0.200
     0.681    14.516     0.200
     0.749    15.937     0.200
     0.794    16.974     0.200
     0.796    16.717     0.200
     0.117     5.074     0.200
     0.144     5.154     0.200
     0.156     5.184     0.200
     0.164     5.249     0.200
     0.268     7.431     0.200
     0.342     8.292     0.200
     0.385     8.670     0.200
     0.450     9.698     0.200
     0.500    10.569     0.200
     0.550    11.498     0.200
     0.565    12.054     0.200
     0.591    12.943     0.200
     0.635    13.562     0.200
     0.650    13.586     0.200
     0.654    13.631     0.200
     0.659    13.724     0.200
     0.656    14.542     0.200
     0.704    14.515     0.200
     0.717    15.483     0.200
     0.727    15.069     0.200
     0.724    15.460     0.200
     0.735    15.539     0.200
     0.776    17.024     0.200
     0.798    16.636     0.200
     0.825    17.039     0.200
     0.875    18.099     0.200
     0.960    19.840     0.200
     1.224    23.329     0.200
     1.784    34.478     0.200
     1.949    36.524     0.200
     0.252     6.158     0.200
     0.348     7.263     0.200
     0.449     9.005     0.200
     0.424     9.747     0.200
     0.468     9.255     0.200
     0.480     9.633     0.200
     0.679    13.821     0.200
     0.679    13.815     0.200
     0.759    15.560     0.200
     0.812    16.352     0.200
     0.910    18.545     0.200
     0.953    18.779     0.200
     1.032    20.522     0.200
     1.126    22.865     0.200
     1.187    24.610     0.200
     1.246    24.956     0.200
     1.260    25.552     0.200
     1.298    25.678     0.200
     1.298    26.255     0.200
     1.765    35.320     0.200
     1.799    35.570     0.200
     1.969    38.857     0.200
     2.025    38.963     0.200
     2.136    41.740     0.200
     2.151    41.640     0.200
     2.264    43.746     0.200
     2.274    43.782     0.200
     2.385    45.182     0.200
     2.390    45.582     0.200
     2.441    46.081     0.200
     0.233     4.899     0.200
     0.252     6.307     0.200
     0.348     6.919     0.200
     0.468     9.415     0.200
     0.480     9.734     0.200
     0.679    13.942     0.200
     0.679    13.987     0.200
     0.678    13.145     0.200
     1.246    25.238     0.200
     1.298    25.654     0.200
     1.298    25.526     0.200
     1.969    38.998     0.200
     2.025    38.842     0.200
     2.151    41.801     0.200
     2.274    43.981     0.200
     2.385    45.623     0.200
     2.390    45.742     0.200
     2.441    46.523     0.200
     0.453     8.028     0.200
     1.415    27.312     0.200
     0.148     3.746     0.200
     0.249     5.259     0.200
     0.234     5.355     0.200
     0.313     6.159     0.200
     0.320     6.695     0.200
     0.396     7.605     0.200
     0.467     9.365     0.200
     0.484     9.738     0.200
     0.494    10.015     0.200
     0.511     9.969     0.200
     0.520    10.922     0.200
     0.598    11.796     0.200
     0.636    13.229     0.200
     0.645    12.664     0.200
     0.649    12.964     0.200
     0.684    15.196     0.200
     0.694    14.621     0.200
     0.741    14.782     0.200
     0.745    15.061     0.200
     0.764    15.678     0.200
     0.756    15.743     0.200
     0.779    15.569     0.200
     0.811    16.504     0.200
     0.868    17.976     0.200
     0.910    18.435     0.200
     0.977    20.296     0.200
     0.996    21.256     0.200
     1.029    21.520     0.200
     1.038    21.986     0.200
     1.172    23.248     0.200
     1.149    24.054     0.200
     1.161    23.991     0.200
     1.270    25.798     0.200
     0.248     5.888     0.200
     0.252     5.801     0.200
     0.297     6.495     0.200
     0.339     7.358     0.200
     0.373     8.105     0.200
     0.370     8.021     0.200
     0.495     9.753     0.200
     0.501    10.311     0.200
     0.540    10.931     0.200
     0.548    11.265     0.200
     0.572    11.624     0.200
     0.574    11.814     0.200
     0.570    12.084     0.200
     0.663    13.790     0.200
     0.657    13.688     0.200
     0.673    13.972     0.200
     0.746    15.893     0.200
     0.780    15.989     0.200
     0.823    16.296     0.200
     0.868    18.344     0.200
     0.870    18.322     0.200
     0.905    18.501     0.200
     1.016    21.232     0.200
     1.026    21.340     0.200
     1.082    22.287     0.200
     1.123    23.210     0.200
     1.166    23.926     0.200
     1.188    24.551     0.200
     1.666    33.962     0.200
     1.676    33.600     0.200
     1.897    37.352     0.200
     2.010    40.002     0.200
     0.565    10.319     0.200
     0.667    13.961     0.200
     0.055     3.706     0.200
     0.217     5.750     0.200
     0.256     5.571     0.200
     0.220     5.881     0.200
     0.297     6.450     0.200
     0.404     8.898     0.200
     0.440     9.300     0.200
     0.436     9.243     0.200
     0.558    11.543     0.200
     0.641    13.440     0.200
     0.683    13.881     0.200
     0.909    18.648     0.200
     1.105    22.478     0.200
     1.727    34.163     0.200
     2.102    40.266     0.200
     2.178    41.576     0.200
     2.296    43.666     0.200
     0.287     6.654     0.200
     0.300     6.095     0.200
     0.306     6.434     0.200
     0.359     7.385     0.200
     0.359     7.393     0.200
     0.435     9.520     0.200
     0.464     9.494     0.200
     0.512    10.157     0.200
     0.523    10.814     0.200
     0.529    11.026     0.200
     0.723    15.271     0.200
     0.797    16.774     0.200
     0.836    17.224     0.200
     1.081    22.563     0.200
     0.148     4.270     0.200
     0.239     6.187     0.200
     0.394     8.736     0.200
     0.422     8.945     0.200
     0.504    10.463     0.200
     0.544    11.873     0.200
     0.562    12.039     0.200
     0.605    12.542     0.200
     0.629    13.020     0.200
     0.737    14.995     0.200
     0.793    16.447     0.200
     0.975    20.147     0.200
     1.250    25.464     0.200
     0.113     3.874     0.200
     0.137     3.917     0.200
     0.177     4.367     0.200
     0.242     5.588     0.200
     0.328     6.935     0.200
     0.374     7.404     0.200
     0.480     9.456     0.200
     0.479    10.056     0.200
     0.492    10.421     0.200
     0.579    12.111     0.200
     0.614    12.753     0.200
     0.610    12.720     0.200
     0.662    14.313     0.200
     0.668    14.217     0.200
     0.693    14.783     0.200
     0.703    15.130     0.200
     0.721    15.185     0.200
     0.727    14.528     0.200
     0.738    15.291     0.200
     0.748    15.576     0.200
     0.749    15.522     0.200
     0.781    16.223     0.200
     0.821    16.978     0.200
     0.846    17.485     0.200
     0.965    19.633     0.200
     1.021    21.175     0.200
     1.025    21.431     0.200
     1.103    22.878     0.200
     1.140    23.714     0.200
     1.164    23.911     0.200
     0.688    14.760     0.200
     0.608    12.053     0.200
     0.163     3.692     0.200
     0.206     4.992     0.200
     0.236     4.945     0.200
     0.316     6.799     0.200
     0.332     7.147     0.200
     0.384     8.003     0.200
     0.393     7.486     0.200
     0.404     8.495     0.200
     0.435     8.297     0.200
     0.439     9.689     0.200
     0.447     9.044     0.200
     0.567    12.235     0.200
     0.574    11.948     0.200
     0.590    12.309     0.200
     0.652    13.008     0.200
     0.653    13.314     0.200
     0.665    13.665     0.200
     0.725    15.268     0.200
     0.722    14.830     0.200
     0.729    15.567     0.200
     0.771    15.920     0.200
     0.813    17.709     0.200
     0.813    16.457     0.200
     0.908    19.130     0.200
     0.950    19.278     0.200
     0.952    20.381     0.200
     0.987    20.768     0.200
     1.148    23.237     0.200
     1.720    36.071     0.200
     1.769    36.141     0.200
     1.800    36.272     0.200
     1.924    39.535     0.200
     0.582    11.002     0.200
     0.677    13.079     0.200
     2.532    47.073     0.200
     2.852    51.398     0.200
     0.211     4.140     0.200
     0.244     4.920     0.200
     0.293     6.780     0.200
     0.326     6.616     0.200
     0.363     8.126     0.200
     0.391     7.850     0.200
     0.433     9.381     0.200
     0.588    11.839     0.200
     0.602    12.094     0.200
     0.661    13.422     0.200
     0.702    14.836     0.200
     0.718    14.715     0.200
     0.887    18.302     0.200
     0.879    19.159     0.200
     0.888    18.495     0.200
     0.946    19.892     0.200
     1.016    21.301     0.200
     1.179    24.702     0.200
     0.341     7.557     0.200
     0.371     8.216     0.200
     0.361     8.215     0.200
     0.415     8.929     0.200
     0.407     9.145     0.200
     0.463     9.822     0.200
     0.484    10.571     0.200
     0.501    10.295     0.200
     0.512    10.925     0.200
     0.529    11.624     0.200
     0.582    12.140     0.200
     0.648    13.285     0.200
     0.679    14.965     0.200
     0.667    14.158     0.200
     0.678    14.320     0.200
     0.711    14.480     0.200
     0.758    15.844     0.200
     0.763    15.378     0.200
     0.830    17.420     0.200
     0.845    17.055     0.200
     0.843    17.559     0.200
     0.905    19.194     0.200
     0.942    19.766     0.200
     0.961    20.623     0.200
     1.065    22.244     0.200
     1.084    21.910     0.200
     1.692    34.095     0.200
     1.779    35.017     0.200
     1.796    35.715     0.200
     1.903    37.554     0.200
     0.146     5.762     0.200
     0.159     5.849     0.200
     0.180     5.632     0.200
     0.192     6.344     0.200
     0.325     7.668     0.200
     0.330     7.646     0.200
     0.406     9.014     0.200
     0.501    10.681     0.200
     0.580    12.529     0.200
     0.589    12.396     0.200
     0.601    13.030     0.200
     0.620    14.077     0.200
     0.636    13.115     0.200
     0.721    14.881     0.200
     0.730    14.959     0.200
     0.733    14.868     0.200
     0.702    15.509     0.200
     0.738    15.857     0.200
     0.758    15.729     0.200
     0.772    16.123     0.200
     0.782    16.339     0.200
     0.875    18.368     0.200
     0.914    18.826     0.200
     0.959    19.562     0.200
     0.992    19.883     0.200
     0.986    19.900     0.200
     0.184     4.619     0.200
     0.244     5.376     0.200
     0.256     6.255     0.200
     0.302     6.316     0.200
     0.291     7.122     0.200
     0.372     7.754     0.200
     0.394     8.566     0.200
     0.406     8.659     0.200
     0.424     8.734     0.200
     0.485     9.271     0.200
     0.493     9.236     0.200
     0.519    10.063     0.200
     0.642    13.056     0.200
     0.635    12.635     0.200
     0.687    13.868     0.200
     0.721    15.198     0.200
     0.829    16.870     0.200
     0.860    17.823     0.200
     0.850    18.094     0.200
     0.962    19.642     0.200
     1.031    21.153     0.200
     1.147    23.438     0.200
     0.099     4.860     0.200
     0.156     5.295     0.200
     0.185     5.399     0.200
     0.206     5.786     0.200
     0.312     6.900     0.200
     0.355     8.346     0.200
     0.357     7.838     0.200
     0.529    11.490     0.200
     0.549    11.237     0.200
     0.615    12.873     0.200
     0.622    13.339     0.200
     0.670    13.906     0.200
     0.679    14.876     0.200
     0.690    14.410     0.200
     0.741    15.152     0.200
     0.805    16.953     0.200
     0.811    17.423     0.200
     0.824    17.019     0.200
     0.845    18.084     0.200
     0.882    18.224     0.200
     0.888    18.868     0.200
     0.940    19.416     0.200
     0.176     4.410     0.200
     0.242     5.663     0.200
     0.251     6.495     0.200
     0.296     6.886     0.200
     0.286     7.065     0.200
     0.382     8.297     0.200
     0.391     8.840     0.200
     0.402     8.792     0.200
     0.438     8.952     0.200
     0.484    10.598     0.200
     0.480    10.480     0.200
     0.633    13.420     0.200
     0.633    13.420     0.200
     0.644    14.033     0.200
     0.650    13.718     0.200
     0.676    13.940     0.200
     0.674    13.794     0.200
     0.734    15.341     0.200
     0.789    15.780     0.200
     0.797    16.929     0.200
     0.816    17.045     0.200
     0.834    17.489     0.200
     0.851    17.775     0.200
     0.923    19.251     0.200
     0.967    20.379     0.200
     0.974    20.263     0.200
     1.035    21.719     0.200
     1.043    21.979     0.200
     1.610    32.797     0.200
     0.079     2.319     0.200
     0.182     4.855     0.200
     0.265     5.589     0.200
     0.304     6.374     0.200
     0.337     7.390     0.200
     0.399     8.758     0.200
     0.497    10.371     0.200
     0.528    10.882     0.200
     0.582    12.614     0.200
     0.683    14.334     0.200
     0.742    15.294     0.200
     0.749    15.932     0.200
     0.795    16.497     0.200
     1.007    21.402     0.200
     1.237    25.840     0.200
     1.255    25.866     0.200
     1.289    26.861     0.200
     1.839    37.326     0.200
     1.911    37.979     0.200
     1.924    38.755     0.200
     1.962    38.988     0.200
     1.985    39.685     0.200
     2.008    40.710     0.200
     2.101    41.469     0.200
     2.178    43.574     0.200
     2.302    45.293     0.200
     2.395    46.858     0.200
     0.081     7.949     0.200
     0.140     6.668     0.200
     0.212     7.611     0.200
     0.290     8.311     0.200
     0.334     8.717     0.200
     0.344     8.521     0.200
     0.310     8.322     0.200
     0.311     8.741     0.200
     0.399     9.223     0.200
     0.438    10.040     0.200
     0.476    10.807     0.200
     0.558    12.282     0.200
     0.616    13.472     0.200
     0.639    13.119     0.200
     0.754    15.426     0.200
     0.860    17.381     0.200
     0.894    17.820     0.200
     0.964    18.798     0.200
     0.972    19.053     0.200
     1.018    19.650     0.200
     1.334    25.583     0.200
     1.367    26.816     0.200
     1.408    27.932     0.200
     1.540    29.384     0.200
     1.632    31.109     0.200
     1.675    31.302     0.200
     1.830    34.132     0.200
     2.018    37.310     0.200
     2.059    37.547     0.200
     2.063    37.602     0.200
     2.067    38.279     0.200
     2.263    41.142     0.200
     2.286    41.462     0.200
     1.680    33.532     0.200
     0.062     2.577     0.200
     0.116     3.314     0.200
     0.178     3.694     0.200
     0.197     4.376     0.200
     0.185     4.730     0.200
     0.233     5.719     0.200
     0.322     7.671     0.200
     0.353     8.149     0.200
     0.369     7.301     0.200
     0.381     8.691     0.200
     0.433     9.094     0.200
     0.436     9.866     0.200
     0.481    10.002     0.200
     0.505    10.164     0.200
     0.513    11.630     0.200
     0.533    11.903     0.200
     0.608    12.404     0.200
     0.631    12.583     0.200
     0.677    13.813     0.200
     0.701    14.121     0.200
     0.701    14.191     0.200
     0.681    14.884     0.200
     0.761    15.512     0.200
     0.849    17.406     0.200
     0.874    17.749     0.200
     0.886    18.066     0.200
     0.939    19.277     0.200
     0.969    20.282     0.200
     1.082    22.109     0.200
     1.180    24.195     0.200
     1.705    33.873     0.200
     1.794    35.468     0.200
     1.810    35.822     0.200
     1.847    36.419     0.200
     2.216    42.678     0.200
     0.076     3.803     0.200
     0.187     4.162     0.200
     0.225     4.578     0.200
     0.245     6.574     0.200
     0.373     7.560     0.200
     0.363     8.631     0.200
     0.444     9.173     0.200
     0.522    10.600     0.200
     0.528    11.154     0.200
     0.564    11.613     0.200
     0.605    11.878     0.200
     0.662    13.556     0.200
     0.707    14.146     0.200
     0.933    18.878     0.200
     0.958    19.592     0.200
     0.994    20.106     0.200
     1.031    21.164     0.200
     1.248    25.325     0.200
     2.039    39.308     0.200
     2.053    39.838     0.200
     2.063    39.679     0.200
     2.117    40.711     0.200
     2.179    42.074     0.200
     2.321    44.175     0.200
     0.628    13.527     0.200
     0.120     3.917     0.200
     0.159     4.585     0.200
     0.215     5.001     0.200
     0.241     5.326     0.200
     0.330     7.711     0.200
     0.360     7.921     0.200
     0.388     8.763     0.200
     0.448     9.355     0.200
     0.547    11.797     0.200
     0.606    13.183     0.200
     0.709    14.914     0.200
     0.722    14.860     0.200
     0.746    15.698     0.200
     0.936    19.303     0.200
     0.990    20.434     0.200
     0.984    20.420     0.200
     1.007    21.270     0.200
     1.045    21.607     0.200
     1.080    22.294     0.200
     1.190    24.366     0.200
     1.630    32.412     0.200
     1.677    33.263     0.200
     1.787    35.331     0.200
     1.839    36.374     0.200
     1.869    36.675     0.200
     1.904    37.548     0.200
     1.930    37.660     0.200
     1.955    38.888     0.200
     2.042    39.714     0.200
     2.104    41.262     0.200
     2.120    41.093     0.200
     2.243    43.014     0.200
     2.340    44.844     0.200
     2.453    46.135     0.200
     0.111     3.892     0.200
     0.173     5.415     0.200
     0.226     5.463     0.200
     0.242     5.712     0.200
     0.371     8.183     0.200
     0.402     9.251     0.200
     0.559    12.120     0.200
     0.618    13.474     0.200
     0.641    13.888     0.200
     0.652    13.354     0.200
     0.721    15.131     0.200
     0.987    21.069     0.200
     1.877    36.855     0.200
     1.964    38.482     0.200
     2.348    44.592     0.200
     2.461    46.377     0.200
     0.349     7.969     0.200
     0.395     7.886     0.200
     0.458     9.315     0.200
     0.484    10.283     0.200
     0.487     9.759     0.200
     0.598    12.445     0.200
     0.617    12.075     0.200
     0.648    13.575     0.200
     0.676    14.162     0.200
     0.680    13.787     0.200
     0.693    14.751     0.200
     0.724    14.980     0.200
     0.743    15.556     0.200
     0.750    15.977     0.200
     0.778    15.751     0.200
     0.798    17.596     0.200
     0.830    16.912     0.200
     0.883    18.302     0.200
     0.943    19.439     0.200
     1.051    21.633     0.200
     0.086     4.908     0.200
     0.095     4.401     0.200
     0.093     4.337     0.200
     0.179     5.515     0.200
     0.254     6.527     0.200
     0.269     6.341     0.200
     0.265     6.825     0.200
     0.345     8.121     0.200
     0.410     9.502     0.200
     0.446     9.685     0.200
     0.481    10.495     0.200
     0.094     4.314     0.200
     0.086     4.629     0.200
     0.096     4.145     0.200
     0.177     5.232     0.200
     0.256     6.192     0.200
     0.267     6.334     0.200
     0.267     6.626     0.200
     0.407     9.386     0.200
     0.444     9.725     0.200
     0.479    10.473     0.200
     0.817    18.094     0.200
     0.979    20.046     0.200
     0.223     5.683     0.200
     0.310     7.212     0.200
     0.337     8.033     0.200
     0.343     8.024     0.200
     0.350     8.021     0.200
     0.426     8.237     0.200
     0.414     9.323     0.200
     0.474    11.154     0.200
     0.522    10.796     0.200
     0.552    11.326     0.200
     0.644    13.095     0.200
     0.692    14.335     0.200
     0.752    15.003     0.200
     0.778    15.824     0.200
     0.782    16.089     0.200
     0.855    18.793     0.200
     0.874    17.764     0.200
     1.120    22.290     0.200
     1.155    23.026     0.200
     1.826    36.148     0.200
     0.107     3.276     0.200
     0.246     5.595     0.200
     0.264     6.148     0.200
     0.278     6.679     0.200
     0.290     6.837     0.200
     0.326     7.708     0.200
     0.354     7.716     0.200
     0.367     8.126     0.200
     0.399     8.754     0.200
     0.491     9.593     0.200
     0.529    10.981     0.200
     0.560    11.694     0.200
     0.658    14.015     0.200
     0.668    13.333     0.200
     0.852    17.607     0.200
     0.097     2.946     0.200
     0.134     3.040     0.200
     0.121     3.264     0.200
     0.210     6.133     0.200
     0.306     6.803     0.200
     0.412     8.672     0.200
     0.401     8.847     0.200
     0.447     9.729     0.200
     0.425    10.163     0.200
     0.469     9.179     0.200
     0.709    14.550     0.200
     0.742    14.880     0.200
     1.031    21.040     0.200
     0.130     2.805     0.200
     0.101     2.791     0.200
     0.123     3.086     0.200
     0.233     4.928     0.200
     0.214     5.878     0.200
     0.303     6.376     0.200
     0.363     7.496     0.200
     0.386     8.121     0.200
     0.465     9.450     0.200
     0.587    11.635     0.200
     0.731    14.379     0.200
     0.109     2.095     0.200
     0.098     2.669     0.200
     0.186     4.482     0.200
     0.266     5.935     0.200
     0.319     6.753     0.200
     0.284     7.151     0.200
     0.323     6.834     0.200
     0.352     7.283     0.200
     0.441     8.475     0.200
     0.430     9.142     0.200
     0.456     9.650     0.200
     0.478     9.817     0.200
     0.515     9.374     0.200
     0.490    11.521     0.200
     0.504    10.965     0.200
     0.586    12.734     0.200
     0.666    12.579     0.200
     0.702    14.356     0.200
     0.737    14.553     0.200
     0.937    19.030     0.200
     0.974    19.253     0.200
     1.007    19.676     0.200
     1.012    19.965     0.200
     1.036    21.161     0.200
     1.079    21.586     0.200
     1.193    23.814     0.200
     1.217    25.240     0.200
     1.408    28.654     0.200
     1.758    35.636     0.200
     1.768    35.184     0.200
     1.824    36.854     0.200
     1.884    37.774     0.200
     1.930    38.567     0.200
     2.022    40.157     0.200
     2.032    39.534     0.200
     2.081    40.795     0.200
     2.091    41.385     0.200
     0.106     2.435     0.200
     0.102     2.665     0.200
     0.190     4.637     0.200
     0.314     6.625     0.200
     0.289     7.155     0.200
     0.322     6.926     0.200
     0.349     6.869     0.200
     0.436     8.754     0.200
     0.429     9.312     0.200
     0.479    10.114     0.200
     0.509     9.706     0.200
     0.495    11.424     0.200
     0.510    11.017     0.200
     0.660    13.028     0.200
     2.017    39.910     0.200
     0.104     3.813     0.200
     0.235     5.679     0.200
     0.251     5.786     0.200
     0.285     6.607     0.200
     0.263     6.245     0.200
     0.318     7.219     0.200
     0.368     7.556     0.200
     0.351     8.395     0.200
     0.369     8.000     0.200
     0.388     8.131     0.200
     0.438     9.733     0.200
     0.510     9.675     0.200
     0.518     9.937     0.200
     0.485    10.536     0.200
     0.563    11.073     0.200
     0.578    11.145     0.200
     0.580    11.562     0.200
     0.588    12.709     0.200
     0.642    14.122     0.200
     0.792    15.996     0.200
     0.807    16.606     0.200
     0.848    17.800     0.200
     0.872    17.368     0.200
     0.887    17.445     0.200
     1.195    24.097     0.200
     1.760    35.186     0.200
     0.187     4.555     0.200
     0.303     6.877     0.200
     0.345     7.679     0.200
     0.369     8.043     0.200
     0.403     8.866     0.200
     0.428     9.581     0.200
     0.479    10.055     0.200
     0.514    11.238     0.200
     0.574    11.695     0.200
     0.594    11.896     0.200
     0.634    13.244     0.200
     0.698    14.251     0.200
     0.721    15.268     0.200
     0.739    15.088     0.200
     0.813    16.946     0.200
     0.821    16.923     0.200
     0.843    17.554     0.200
     0.881    18.708     0.200
     0.904    18.446     0.200
     0.969    20.678     0.200
     1.008    20.647     0.200
     1.124    23.304     0.200
     1.195    24.588     0.200
     1.758    36.062     0.200
     0.105     4.219     0.200
     0.113     3.963     0.200
     0.254     6.177     0.200
     0.335     8.157     0.200
     0.338     7.222     0.200
     0.359     7.175     0.200
     0.378     8.278     0.200
     0.477     9.357     0.200
     0.482     9.857     0.200
     0.528    10.683     0.200
     0.574    11.768     0.200
     0.591    12.276     0.200
     0.612    12.736     0.200
     0.630    12.585     0.200
     0.710    14.328     0.200
     0.749    15.266     0.200
     0.835    17.487     0.200
     0.923    19.117     0.200
     1.066    21.845     0.200
     0.011     4.698     0.200
     0.093     3.996     0.200
     0.159     4.813     0.200
     0.172     4.764     0.200
     0.220     5.169     0.200
     0.326     7.529     0.200
     0.343     7.593     0.200
     0.457     9.519     0.200
     0.458     9.194     0.200
     0.464     9.964     0.200
     0.489    10.637     0.200
     0.489    10.408     0.200
     0.604    12.217     0.200
     0.600    12.088     0.200
     0.620    12.255     0.200
     0.654    14.786     0.200
     0.677    13.415     0.200
     0.672    13.663     0.200
     0.685    13.564     0.200
     0.748    15.331     0.200
     0.758    15.837     0.200
     0.756    15.914     0.200
     0.783    15.412     0.200
     0.804    17.105     0.200
     0.837    16.852     0.200
     1.048    21.210     0.200
     0.165     4.093     0.200
     0.220     4.872     0.200
     0.275     6.216     0.200
     0.270     6.439     0.200
     0.283     5.872     0.200
     0.379     7.491     0.200
     0.441     8.822     0.200
     0.538    11.449     0.200
     0.570    11.954     0.200
     0.621    12.300     0.200
     0.694    14.016     0.200
     0.697    13.529     0.200
     0.715    14.245     0.200
     0.812    16.909     0.200
     0.830    16.756     0.200
     0.842    17.734     0.200
     0.861    17.317     0.200
     0.854    17.403     0.200
     0.865    17.198     0.200
     0.898    18.308     0.200
     0.914    18.697     0.200
     0.960    20.303     0.200
     0.995    20.718     0.200
     1.017    21.049     0.200
     0.687    14.829     0.200
     0.150     5.136     0.200
     0.287     7.408     0.200
     0.297     7.466     0.200
     0.293     7.337     0.200
     0.308     7.917     0.200
     0.344     8.347     0.200
     0.360     8.594     0.200
     0.420     9.869     0.200
     0.532    11.531     0.200
     0.534    11.311     0.200
     0.614    13.673     0.200
     0.660    13.592     0.200
     0.710    15.056     0.200
     0.784    16.589     0.200
     0.830    16.691     0.200
     0.843    17.327     0.200
     0.687    14.097     0.200
     0.150     4.825     0.200
     0.287     6.915     0.200
     0.308     7.678     0.200
     0.298     6.749     0.200
     0.345     8.131     0.200
     0.360     8.132     0.200
     0.447     8.377     0.200
     0.457     9.258     0.200
     0.451     9.496     0.200
     0.532    11.054     0.200
     0.533    10.879     0.200
     0.527    10.833     0.200
     0.549    11.391     0.200
     0.589    13.116     0.200
     0.615    13.390     0.200
     0.610    12.994     0.200
     0.659    13.508     0.200
     0.710    14.904     0.200
     0.784    16.536     0.200
     0.800    16.224     0.200
     0.830    16.420     0.200
     0.817    16.914     0.200
     0.820    18.052     0.200
     0.843    17.578     0.200
     0.871    17.727     0.200
     0.966    20.262     0.200
     0.984    20.604     0.200
     1.047    20.949     0.200
     1.090    22.212     0.200
     1.141    23.341     0.200
     1.850    36.550     0.200
     1.960    38.995     0.200
     0.546    10.896     0.200
     0.609    11.622     0.200
     0.710    14.633     0.200
     0.097     4.692     0.200
     0.152     5.696     0.200
     0.204     5.786     0.200
     0.215     5.709     0.200
     0.264     6.373     0.200
     0.321     7.354     0.200
     0.348     7.660     0.200
     0.427     9.997     0.200
     0.414     8.849     0.200
     0.481    10.640     0.200
     0.544    11.187     0.200
     0.620    13.988     0.200
     0.637    14.165     0.200
     0.632    13.382     0.200
     0.666    13.930     0.200
     0.667    13.997     0.200
     0.669    13.800     0.200
     0.694    14.584     0.200
     0.768    16.121     0.200
     0.792    16.358     0.200
     0.812    17.050     0.200
     0.818    17.547     0.200
     0.854    17.686     0.200
     0.879    18.539     0.200
     0.939    19.442     0.200
     1.104    21.780     0.200
     1.856    36.582     0.200
     0.083     4.273     0.200
     0.166     4.875     0.200
     0.248     5.817     0.200
     0.255     6.456     0.200
     0.249     6.449     0.200
     0.332     7.337     0.200
     0.378     7.986     0.200
     0.418     9.116     0.200
     0.441     8.419     0.200
     0.420     9.655     0.200
     0.491    10.946     0.200
     0.543    12.241     0.200
     0.592    12.025     0.200
     0.576    12.952     0.200
     0.622    14.058     0.200
     0.674    14.331     0.200
     0.882    17.704     0.200
     0.904    17.830     0.200
     0.959    20.200     0.200
     0.605    13.886     0.200
     0.137     4.233     0.200
     0.133     3.749     0.200
     0.202     4.409     0.200
     0.245     5.705     0.200
     0.309     7.242     0.200
     0.337     7.458     0.200
     0.365     7.698     0.200
     0.524    11.048     0.200
     0.584    12.919     0.200
     0.625    12.640     0.200
     0.692    14.734     0.200
     0.853    17.416     0.200
     0.088     3.278     0.200
     0.158     3.791     0.200
     0.174     4.154     0.200
     0.182     4.968     0.200
     0.210     5.332     0.200
     0.298     6.823     0.200
     0.361     8.087     0.200
     0.435     8.965     0.200
     0.424     8.728     0.200
     0.453     9.481     0.200
     0.524    10.402     0.200
     0.551    11.968     0.200
     0.608    12.642     0.200
     0.647    12.212     0.200
     0.624    13.333     0.200
     0.732    15.555     0.200
     0.949    20.177     0.200
     1.011    20.735     0.200
     1.030    20.928     0.200
     1.659    34.152     0.200
     0.006     4.755     0.200
     0.150     5.340     0.200
     0.179     4.989     0.200
     0.192     5.262     0.200
     0.221     5.920     0.200
     0.266     6.981     0.200
     0.275     6.556     0.200
     0.349     7.888     0.200
     0.457     9.715     0.200
     0.473     9.808     0.200
     0.542    11.931     0.200
     0.607    12.958     0.200
     0.716    14.356     0.200
     1.204    23.804     0.200
     0.120     3.842     0.200
     0.129     3.594     0.200
     0.179     4.449     0.200
     0.250     5.512     0.200
     0.296     6.940     0.200
     0.323     6.994     0.200
     0.476     9.433     0.200
     0.484     9.820     0.200
     0.492    10.995     0.200
     0.571    11.608     0.200
     0.610    12.759     0.200
     0.612    12.360     0.200
     0.656    13.826     0.200
     0.673    14.461     0.200
     0.700    14.950     0.200
     0.709    15.009     0.200
     0.713    14.813     0.200
     0.719    14.283     0.200
     0.743    15.636     0.200
     0.779    17.226     0.200
     0.826    17.582     0.200
     0.101     3.114     0.200
     0.165     3.541     0.200
     0.175     3.820     0.200
     0.206     4.333     0.200
     0.285     6.378     0.200
     0.493     9.971     0.200
     0.491    10.023     0.200
     0.528    10.513     0.200
     0.623    12.672     0.200
     0.736    15.322     0.200
     0.104     4.826     0.200
     0.144     5.335     0.200
     0.213     6.029     0.200
     0.211     6.580     0.200
     0.294     7.261     0.200
     0.349     9.057     0.200
     0.377     8.723     0.200
     0.394     8.624     0.200
     0.488    10.302     0.200
     0.486    11.233     0.200
     0.500    10.739     0.200
     0.521    11.370     0.200
     0.542    11.436     0.200
     0.568    11.939     0.200
     0.573    11.932     0.200
     0.641    13.189     0.200
     0.637    13.376     0.200
     0.711    15.445     0.200
     0.724    15.115     0.200
     0.755    15.710     0.200
     0.764    16.104     0.200
     0.776    15.915     0.200
     0.840    17.482     0.200
     0.862    17.937     0.200
     0.121     3.275     0.200
     0.151     4.217     0.200
     0.214     4.739     0.200
     0.247     5.547     0.200
     0.324     6.928     0.200
     0.348     7.302     0.200
     0.380     8.294     0.200
     0.447     8.969     0.200
     0.536    11.172     0.200
     0.595    12.743     0.200
     0.637    13.393     0.200
     0.745    15.428     0.200
     0.867    18.429     0.200
     0.936    20.009     0.200
     0.969    20.269     0.200
     0.997    21.430     0.200
     1.188    24.623     0.200
     1.862    37.854     0.200
     1.906    38.321     0.200
     2.122    41.675     0.200
     2.246    44.675     0.200
     2.341    45.549     0.200
     2.455    46.941     0.200
     0.081     3.659     0.200
     0.206     4.497     0.200
     0.224     4.846     0.200
     0.218     5.395     0.200
     0.275     6.542     0.200
     0.422     9.425     0.200
     0.459    10.080     0.200
     0.492    10.575     0.200
     0.512    10.342     0.200
     0.632    12.835     0.200
     0.671    13.633     0.200
     0.843    18.042     0.200
     0.931    18.836     0.200
     0.082     3.169     0.200
     0.202     5.659     0.200
     0.258     6.190     0.200
     0.264     6.057     0.200
     0.374     8.115     0.200
     0.387     8.666     0.200
     0.429     9.660     0.200
     0.490    10.057     0.200
     0.577    12.187     0.200
     0.634    13.243     0.200
     0.664    14.492     0.200
     0.684    14.265     0.200
     0.752    15.626     0.200
     0.765    15.404     0.200
     0.787    16.662     0.200
     0.915    19.086     0.200
     0.956    19.932     0.200
     1.020    21.125     0.200
     1.088    22.529     0.200
     1.114    23.018     0.200
     1.232    24.691     0.200
     1.346    26.898     0.200
     1.907    37.392     0.200
     1.939    38.618     0.200
     1.994    39.473     0.200
     0.079     4.248     0.200
     0.209     5.901     0.200
     0.263     6.562     0.200
     0.265     6.383     0.200
     0.395     8.528     0.200
     0.437    10.094     0.200
     0.584    12.734     0.200
     0.641    14.223     0.200
     0.672    14.595     0.200
     0.758    15.991     0.200
     0.979    19.090     0.200
     1.094    22.563     0.200
     1.998    38.713     0.200
     2.381    44.318     0.200
     0.150     4.592     0.200
     0.153     4.416     0.200
     0.153     5.039     0.200
     0.203     4.965     0.200
     0.294     6.664     0.200
     0.376     8.156     0.200
     0.376     8.605     0.200
     0.394     8.474     0.200
     0.575    11.820     0.200
     0.571    12.258     0.200
     0.634    14.223     0.200
     0.646    13.256     0.200
     0.636    13.788     0.200
     0.671    14.445     0.200
     0.688    14.299     0.200
     0.855    17.170     0.200
     0.897    19.297     0.200
     0.914    18.524     0.200
     0.956    19.706     0.200
     0.997    20.887     0.200
     1.817    35.834     0.200
     2.023    39.196     0.200
     2.256    42.636     0.200
     0.399     8.135     0.200
     1.813    36.836     0.200
     0.012     4.321     0.200
     0.114     4.065     0.200
     0.158     4.465     0.200
     0.233     5.642     0.200
     0.310     7.386     0.200
     0.347     7.714     0.200
     0.375     7.664     0.200
     0.460     9.437     0.200
     0.468     9.975     0.200
     0.461     9.304     0.200
     0.473    10.233     0.200
     0.591    12.161     0.200
     0.600    12.628     0.200
     0.655    14.020     0.200
     0.679    14.125     0.200
     0.685    14.843     0.200
     0.723    15.114     0.200
     0.731    15.070     0.200
     0.737    15.705     0.200
     0.731    15.583     0.200
     0.764    16.198     0.200
     0.802    17.450     0.200
     0.824    16.805     0.200
     0.826    17.046     0.200
     0.895    18.562     0.200
     0.974    19.743     0.200
     1.015    21.185     0.200
     1.141    22.675     0.200
     0.133     3.665     0.200
     0.116     3.686     0.200
     0.184     3.548     0.200
     0.237     5.935     0.200
     0.269     5.852     0.200
     0.279     6.309     0.200
     0.285     7.063     0.200
     0.315     7.498     0.200
     0.410     8.920     0.200
     0.432     9.481     0.200
     0.484     9.903     0.200
     0.494     9.783     0.200
     0.515    10.021     0.200
     0.565    11.213     0.200
     0.574    11.397     0.200
     0.569    12.037     0.200
     0.752    16.372     0.200
     1.065    21.308     0.200
     1.651    32.836     0.200
     1.676    33.969     0.200
     0.034     4.346     0.200
     0.122     4.013     0.200
     0.194     5.172     0.200
     0.258     5.808     0.200
     0.291     7.293     0.200
     0.308     6.553     0.200
     0.365     8.046     0.200
     0.567    11.632     0.200
     0.621    12.736     0.200
     0.627    13.058     0.200
     0.661    13.756     0.200
     0.688    14.832     0.200
     0.709    14.106     0.200
     0.710    14.194     0.200
     0.715    14.562     0.200
     0.713    14.766     0.200
     0.723    15.722     0.200
     0.841    17.860     0.200
     0.865    17.773     0.200
     0.986    19.952     0.200
     1.004    20.393     0.200
     0.030     4.584     0.200
     0.113     4.345     0.200
     0.195     5.348     0.200
     0.250     6.248     0.200
     0.300     7.333     0.200
     0.311     6.754     0.200
     0.374     8.135     0.200
     0.444     9.503     0.200
     0.492    10.196     0.200
     0.496    10.483     0.200
     0.576    12.050     0.200
     0.627    13.014     0.200
     0.628    13.084     0.200
     0.685    14.491     0.200
     0.712    15.008     0.200
     0.706    15.071     0.200
     0.719    14.693     0.200
     0.724    14.874     0.200
     0.719    14.611     0.200
     0.796    16.671     0.200
     0.837    18.060     0.200
     1.019    20.818     0.200
     0.127     3.707     0.200
     0.200     4.948     0.200
     0.262     6.773     0.200
     0.273     7.515     0.200
     0.318     7.381     0.200
     0.388     8.698     0.200
     0.401     8.869     0.200
     0.412     8.599     0.200
     0.432     9.513     0.200
     0.629    12.903     0.200
     0.634    13.305     0.200
     0.645    14.027     0.200
     0.657    13.913     0.200
     0.732    15.608     0.200
     0.837    16.978     0.200
     0.874    18.526     0.200
     0.912    19.433     0.200
     0.919    18.860     0.200
     1.151    23.277     0.200
     1.623    32.345     0.200
     0.100     2.182     0.200
     0.185     4.157     0.200
     0.263     6.205     0.200
     0.276     6.582     0.200
     0.306     6.907     0.200
     0.369     8.569     0.200
     0.408     8.583     0.200
     0.427     9.150     0.200
     0.454     8.841     0.200
     0.456     9.135     0.200
     0.462     9.829     0.200
     0.531    10.517     0.200
     0.598    11.951     0.200
     0.638    12.479     0.200
     0.665    13.745     0.200
     0.688    13.834     0.200
     0.674    13.899     0.200
     0.691    14.460     0.200
     0.759    15.809     0.200
     0.782    16.170     0.200
     0.809    16.484     0.200
     0.919    19.566     0.200
     0.935    19.934     0.200
     0.955    19.766     0.200
     0.948    19.869     0.200
     1.020    20.748     0.200
     1.041    20.817     0.200
     1.075    21.808     0.200
     1.080    21.869     0.200
     1.591    32.811     0.200
     0.164     4.537     0.200
     0.179     5.607     0.200
     0.210     5.676     0.200
     0.285     6.762     0.200
     0.341     7.661     0.200
     0.361     7.956     0.200
     0.388     8.979     0.200
     0.629    12.902     0.200
     0.706    14.455     0.200
     0.732    15.126     0.200
     0.772    15.554     0.200
     0.084     4.087     0.200
     0.194     5.276     0.200
     0.233     6.280     0.200
     0.274     6.644     0.200
     0.309     6.966     0.200
     0.347     7.932     0.200
     0.367     7.525     0.200
     0.362     7.811     0.200
     0.488    10.687     0.200
     0.497    10.671     0.200
     0.503    10.255     0.200
     0.547    10.935     0.200
     0.556    12.018     0.200
     0.612    12.134     0.200
     0.745    15.524     0.200
     0.760    16.073     0.200
     0.820    17.183     0.200
     0.850    17.875     0.200
     1.040    21.153     0.200
     0.135     5.105     0.200
     0.212     6.081     0.200
     0.263     6.038     0.200
     0.343     8.214     0.200
     0.362     7.981     0.200
     0.414     8.513     0.200
     0.499    11.257     0.200
     0.636    13.721     0.200
     0.650    13.695     0.200
     0.677    13.722     0.200
     0.689    14.320     0.200
     0.680    13.829     0.200
     0.815    16.738     0.200
     0.882    17.936     0.200
     0.894    18.164     0.200
     0.983    20.277     0.200
     0.161     4.766     0.200
     0.194     5.643     0.200
     0.255     5.574     0.200
     0.338     7.728     0.200
     0.405     8.811     0.200
     0.623    13.648     0.200
     0.634    13.106     0.200
     0.656    13.695     0.200
     0.675    14.036     0.200
     0.688    14.492     0.200
     0.145     5.192     0.200
     0.202     6.294     0.200
     0.233     6.848     0.200
     0.255     6.582     0.200
     0.352     8.077     0.200
     0.406     8.726     0.200
     0.498    11.145     0.200
     0.558    11.693     0.200
     0.636    14.076     0.200
     0.649    13.557     0.200
     0.683    14.668     0.200
     0.708    14.513     0.200
     0.775    15.165     0.200
     0.807    16.438     0.200
     0.897    18.183     0.200
     0.986    19.856     0.200
     0.135     4.945     0.200
     0.211     6.147     0.200
     0.237     6.837     0.200
     0.262     6.187     0.200
     0.343     8.303     0.200
     0.361     7.857     0.200
     0.413     8.982     0.200
     0.450     9.850     0.200
     0.500    11.234     0.200
     0.637    13.507     0.200
     0.651    13.482     0.200
     0.681    14.483     0.200
     0.717    14.178     0.200
     0.716    15.011     0.200
     0.881    18.092     0.200
     0.901    18.199     0.200
     0.895    18.390     0.200
     0.161     4.193     0.200
     0.176     4.369     0.200
     0.188     5.324     0.200
     0.281     6.788     0.200
     0.313     7.140     0.200
     0.357     7.332     0.200
     0.413     9.285     0.200
     0.396     9.126     0.200
     0.433     9.268     0.200
     0.532    11.386     0.200
     0.573    11.582     0.200
     0.648    12.594     0.200
     0.654    13.646     0.200
     0.653    13.467     0.200
     0.726    15.748     0.200
     0.754    15.180     0.200
     0.818    16.403     0.200
     0.937    19.676     0.200
     1.085    22.319     0.200
     1.196    24.042     0.200
     1.243    24.553     0.200
     1.593    32.224     0.200
     1.743    34.711     0.200
     1.749    33.893     0.200
     1.872    37.388     0.200
     1.972    38.030     0.200
     2.082    39.511     0.200
     0.098     2.773     0.200
     0.195     4.216     0.200
     0.229     4.410     0.200
     0.247     5.026     0.200
     0.295     5.891     0.200
     0.315     6.990     0.200
     0.362     7.559     0.200
     0.358     7.215     0.200
     0.372     7.698     0.200
     0.511    10.027     0.200
     0.542     9.866     0.200
     0.512    10.430     0.200
     0.517    10.280     0.200
     0.539    10.335     0.200
     0.601    12.098     0.200
     0.608    12.264     0.200
     0.618    12.405     0.200
     0.632    12.420     0.200
     0.696    13.805     0.200
     0.692    14.095     0.200
     0.759    15.064     0.200
     0.840    16.884     0.200
     0.879    18.173     0.200
     0.879    18.486     0.200
     0.912    18.357     0.200
     0.924    18.178     0.200
     0.927    18.400     0.200
     1.060    22.466     0.200
     1.105    22.169     0.200
     1.142    23.657     0.200
     1.199    24.566     0.200
     1.231    24.896     0.200
     1.706    34.601     0.200
     1.725    34.317     0.200
     1.849    37.184     0.200
     1.915    38.274     0.200
     1.941    38.170     0.200
     2.057    41.015     0.200
     0.507     9.674     0.200
     0.650    13.995     0.200
     0.080     4.061     0.200
     0.222     6.561     0.200
     0.263     6.582     0.200
     0.271     6.600     0.200
     0.409     9.615     0.200
     0.450    10.036     0.200
     0.599    12.619     0.200
     0.656    14.529     0.200
     0.686    15.041     0.200
     0.114     2.807     0.200
     0.198     4.694     0.200
     0.219     4.240     0.200
     0.309     6.329     0.200
     0.321     6.866     0.200
     0.370     8.272     0.200
     0.373     8.077     0.200
     0.385     7.987     0.200
     0.541    10.353     0.200
     0.523    10.571     0.200
     0.542    10.962     0.200
     0.608    12.140     0.200
     0.623    12.139     0.200
     0.624    12.619     0.200
     0.632    13.161     0.200
     0.706    14.210     0.200
     0.837    16.952     0.200
     0.935    18.634     0.200
     1.152    23.802     0.200
     1.204    24.608     0.200
     1.233    25.014     0.200
     1.709    34.755     0.200
     1.942    38.352     0.200
     2.057    40.898     0.200
     0.179     4.889     0.200
     0.231     5.997     0.200
     0.336     6.935     0.200
     0.349     7.881     0.200
     0.364     8.366     0.200
     0.397     8.526     0.200
     0.407     9.673     0.200
     0.413     9.158     0.200
     0.440    10.058     0.200
     0.447    10.033     0.200
     0.511    10.445     0.200
     0.534    11.331     0.200
     0.546    11.483     0.200
     0.620    13.758     0.200
     0.639    13.248     0.200
     0.637    14.020     0.200
     0.660    13.295     0.200
     0.687    14.759     0.200
     0.751    15.030     0.200
     0.769    15.466     0.200
     0.773    16.632     0.200
     0.809    16.885     0.200
     0.843    17.316     0.200
     0.835    17.548     0.200
     0.861    18.143     0.200
     0.946    19.523     0.200
     1.585    31.493     0.200
     1.605    32.299     0.200
     1.769    34.786     0.200
     0.879    17.226     0.200
     1.770    32.346     0.200
     2.138    39.839     0.200
     2.427    44.080     0.200
     2.510    44.705     0.200
     2.671    46.941     0.200
     0.102     2.868     0.200
     0.205     4.654     0.200
     0.295     6.416     0.200
     0.326     6.972     0.200
     0.357     8.101     0.200
     0.369     8.096     0.200
     0.532    10.259     0.200
     0.524    11.225     0.200
     0.618    12.860     0.200
     0.629    13.397     0.200
     0.693    13.984     0.200
     0.703    14.887     0.200
     0.922    19.154     0.200
     0.347     8.306     0.200
     1.685    31.633     0.200
     1.709    31.536     0.200
     1.896    35.121     0.200
     2.141    36.739     0.200
     2.266    40.135     0.200
     2.115    40.160     0.200
     2.592    45.153     0.200
     0.151     3.860     0.200
     0.223     4.524     0.200
     0.235     6.076     0.200
     0.326     7.618     0.200
     0.349     7.176     0.200
     0.407     8.535     0.200
     0.484    10.645     0.200
     0.523    10.759     0.200
     0.581    12.243     0.200
     0.625    13.262     0.200
     0.677    13.592     0.200
     1.011    21.352     0.200
     0.032     3.159     0.200
     0.165     4.366     0.200
     0.175     4.278     0.200
     0.203     5.369     0.200
     0.369     8.311     0.200
     0.367     7.561     0.200
     0.482     9.852     0.200
     0.510    10.044     0.200
     0.581    12.042     0.200
     0.571    12.152     0.200
     0.590    11.959     0.200
     0.599    11.871     0.200
     0.643    13.349     0.200
     0.638    13.105     0.200
     0.665    13.740     0.200
     0.711    13.829     0.200
     0.708    15.573     0.200
     0.728    15.829     0.200
     0.725    14.675     0.200
     0.787    15.897     0.200
     0.848    17.688     0.200
     0.865    18.317     0.200
     0.864    17.859     0.200
     0.927    19.301     0.200
     1.011    20.519     0.200
     1.201    24.277     0.200
     1.188    22.658     0.200
     1.736    35.143     0.200
     1.967    39.425     0.200
     2.317    45.041     0.200
     2.633    49.441     0.200
     2.738    48.593     0.200
     0.175     4.368     0.200
     0.275     5.602     0.200
     0.311     5.973     0.200
     0.341     6.858     0.200
     0.347     7.367     0.200
     0.447     9.684     0.200
     0.439     9.154     0.200
     0.501    10.540     0.200
     0.545    10.575     0.200
     0.556    11.794     0.200
     0.661    13.406     0.200
     0.683    14.940     0.200
     0.720    13.560     0.200
     0.740    14.266     0.200
     1.038    21.447     0.200
     1.723    35.295     0.200
     0.122     4.134     0.200
     0.203     4.714     0.200
     0.257     6.191     0.200
     0.312     7.138     0.200
     0.317     7.223     0.200
     0.394     8.436     0.200
     0.426     9.510     0.200
     0.452    10.103     0.200
     0.586    11.985     0.200
     0.604    12.152     0.200
     0.624    13.407     0.200
     0.665    13.650     0.200
     0.713    14.863     0.200
     0.717    15.306     0.200
     0.721    15.458     0.200
     0.800    16.201     0.200
     0.809    17.050     0.200
     0.867    17.929     0.200
     0.903    18.928     0.200
     0.928    19.919     0.200
     0.991    20.726     0.200
     1.085    21.243     0.200
     0.035     4.486     0.200
     0.127     4.164     0.200
     0.193     4.987     0.200
     0.287     6.846     0.200
     0.308     7.039     0.200
     0.361     7.901     0.200
     0.431     9.437     0.200
     0.505    11.639     0.200
     0.500    10.920     0.200
     0.499    10.033     0.200
     0.563    12.286     0.200
     0.618    12.224     0.200
     0.625    13.462     0.200
     0.657    13.504     0.200
     0.688    15.588     0.200
     0.683    14.818     0.200
     0.706    14.669     0.200
     0.706    14.485     0.200
     0.711    14.877     0.200
     0.715    14.958     0.200
     0.748    15.185     0.200
     0.770    15.974     0.200
     0.789    16.472     0.200
     0.796    16.350     0.200
     0.841    18.242     0.200
     0.846    17.936     0.200
     0.931    19.107     0.200
     1.136    22.473     0.200
     1.269    24.507     0.200
     1.361    25.840     0.200
     2.301    42.787     0.200
     2.497    44.117     0.200
     0.034     4.053     0.200
     0.130     3.745     0.200
     0.187     4.103     0.200
     0.284     6.673     0.200
     0.312     7.017     0.200
     0.356     7.047     0.200
     0.425     8.589     0.200
     0.474    10.507     0.200
     0.496    10.209     0.200
     0.498    11.270     0.200
     0.560    11.232     0.200
     0.610    12.870     0.200
     0.619    13.280     0.200
     0.651    12.612     0.200
     0.684    14.203     0.200
     0.698    14.341     0.200
     0.702    14.540     0.200
     0.707    14.761     0.200
     0.714    14.163     0.200
     0.741    15.571     0.200
     0.767    15.037     0.200
     0.794    15.842     0.200
     0.837    18.039     0.200
     1.000    21.246     0.200
     1.050    22.023     0.200
     1.083    22.605     0.200
     1.130    22.332     0.200
     0.136     3.432     0.200
     0.231     4.989     0.200
     0.203     4.966     0.200
     0.286     6.398     0.200
     0.302     6.556     0.200
     0.311     7.492     0.200
     0.372     7.620     0.200
     0.414     9.373     0.200
     0.441     9.379     0.200
     0.463    10.402     0.200
     0.537    11.069     0.200
     0.545    11.489     0.200
     0.565    11.328     0.200
     0.606    13.517     0.200
     0.653    13.170     0.200
     0.634    13.926     0.200
     0.880    18.072     0.200
     0.930    19.235     0.200
     0.971    20.026     0.200
     0.037     3.987     0.200
     0.136     3.891     0.200
     0.185     4.351     0.200
     0.279     6.336     0.200
     0.420     8.896     0.200
     0.495    10.464     0.200
     0.555    11.626     0.200
     0.616    12.695     0.200
     0.645    13.129     0.200
     0.703    14.673     0.200
     0.716    15.377     0.200
     0.777    16.904     0.200
     0.837    18.163     0.200
     0.997    21.105     0.200
     0.135     3.021     0.200
     0.199     4.505     0.200
     0.210     4.451     0.200
     0.290     5.973     0.200
     0.340     7.268     0.200
     0.340     7.659     0.200
     0.488    10.605     0.200
     0.564    11.902     0.200
     0.681    13.285     0.200
     0.906    18.483     0.200
     0.037     4.730     0.200
     0.134     4.232     0.200
     0.185     5.195     0.200
     0.266     6.188     0.200
     0.313     7.260     0.200
     0.352     7.585     0.200
     0.421     9.325     0.200
     0.496    10.114     0.200
     0.498     9.926     0.200
     0.607    13.014     0.200
     0.646    12.425     0.200
     0.684    14.578     0.200
     0.695    14.439     0.200
     0.698    14.177     0.200
     0.715    14.846     0.200
     0.722    14.688     0.200
     0.768    15.129     0.200
     0.779    16.156     0.200
     0.792    16.458     0.200
     0.838    17.851     0.200
     0.849    16.897     0.200
     0.857    17.093     0.200
     1.126    21.801     0.200
     1.116    22.699     0.200
     1.176    23.575     0.200
     1.879    37.112     0.200
     2.183    42.901     0.200
     0.722    14.816     0.200
     0.192     6.010     0.200
     0.253     6.585     0.200
     0.290     7.115     0.200
     0.419     9.543     0.200
     0.415     9.557     0.200
     0.527    11.429     0.200
     0.718    15.080     0.200
     0.736    15.651     0.200
     0.809    17.359     0.200
     0.884    17.630     0.200
     0.901    18.352     0.200
     0.925    18.787     0.200
     0.020     5.521     0.200
     0.101     5.014     0.200
     0.152     5.604     0.200
     0.215     6.272     0.200
     0.470    10.256     0.200
     0.584    12.870     0.200
     0.604    12.248     0.200
     0.636    14.320     0.200
     0.667    14.288     0.200
     0.680    13.966     0.200
     0.740    15.573     0.200
     0.745    14.975     0.200
     0.787    16.511     0.200
     0.113     3.861     0.200
     0.175     4.773     0.200
     0.257     5.448     0.200
     0.278     5.641     0.200
     0.316     6.641     0.200
     0.366     7.883     0.200
     0.420     8.990     0.200
     0.418     8.748     0.200
     0.438     9.776     0.200
     0.447     9.511     0.200
     0.472    10.197     0.200
     0.522    10.482     0.200
     0.500    10.641     0.200
     0.555    12.290     0.200
     0.581    12.733     0.200
     0.662    13.060     0.200
     0.668    14.366     0.200
     0.688    13.296     0.200
     0.686    14.714     0.200
     0.708    13.913     0.200
     0.708    14.350     0.200
     0.795    16.230     0.200
     0.861    17.087     0.200
     0.840    17.598     0.200
     0.914    19.493     0.200
     1.007    20.820     0.200
     1.136    22.512     0.200
     1.242    24.863     0.200
     1.629    32.298     0.200
     1.692    33.339     0.200
     0.360     7.404     0.200
     0.745    16.866     0.200
     1.040    19.274     0.200
     0.139     4.603     0.200
     0.143     4.295     0.200
     0.227     5.551     0.200
     0.293     6.661     0.200
     0.307     6.452     0.200
     0.623    13.307     0.200
     0.734    14.563     0.200
     0.753    15.877     0.200
     0.782    16.854     0.200
     0.803    17.079     0.200
     0.018     4.229     0.200
     0.122     3.391     0.200
     0.166     4.817     0.200
     0.246     5.498     0.200
     0.428     8.414     0.200
     0.479    11.018     0.200
     0.599    11.725     0.200
     0.649    12.633     0.200
     0.683    13.611     0.200
     0.692    14.540     0.200
     0.712    14.889     0.200
     0.698    14.416     0.200
     0.814    17.551     0.200
     0.114     2.819     0.200
     0.165     3.962     0.200
     0.186     3.730     0.200
     0.261     6.168     0.200
     0.272     5.398     0.200
     0.346     8.056     0.200
     0.347     7.156     0.200
     0.377     7.691     0.200
     0.587    12.039     0.200
     0.599    11.734     0.200
     0.637    13.258     0.200
     0.651    13.355     0.200
     0.728    15.331     0.200
     0.795    16.965     0.200
     0.830    16.562     0.200
     1.099    22.261     0.200
     1.201    24.329     0.200
     1.313    24.681     0.200
     3.136    58.791     0.200
     0.134     3.999     0.200
     0.316     6.913     0.200
     0.317     7.091     0.200
     0.332     6.810     0.200
     0.421     8.830     0.200
     0.492    10.396     0.200
     0.525    10.381     0.200
     0.513    10.850     0.200
     0.614    12.535     0.200
     0.616    12.474     0.200
     0.792    15.575     0.200
     0.789    15.365     0.200
     0.773    15.601     0.200
     0.803    16.637     0.200
     0.828    16.770     0.200
     0.946    18.820     0.200
     0.946    19.345     0.200
     1.046    21.660     0.200
     1.819    36.449     0.200
     1.934    37.967     0.200
     0.610    11.628     0.200
     2.545    46.844     0.200
     0.145     4.241     0.200
     0.166     4.107     0.200
     0.267     5.333     0.200
     0.315     5.922     0.200
     0.340     6.685     0.200
     0.307     6.860     0.200
     0.380     7.388     0.200
     0.384     8.141     0.200
     0.372     7.733     0.200
     0.422     9.306     0.200
     0.507    10.667     0.200
     0.529    10.462     0.200
     0.545    10.199     0.200
     0.523    10.972     0.200
     0.540    10.727     0.200
     0.520    10.824     0.200
     0.647    14.032     0.200
     0.660    14.031     0.200
     0.681    13.169     0.200
     0.683    14.491     0.200
     0.740    14.736     0.200
     0.749    14.800     0.200
     0.753    14.423     0.200
     0.786    17.053     0.200
     0.826    16.829     0.200
     0.825    17.638     0.200
     0.852    18.169     0.200
     0.917    18.477     0.200
     0.932    19.031     0.200
     1.044    20.459     0.200
     1.070    21.366     0.200
     1.090    21.763     0.200
     1.181    23.379     0.200
     1.674    33.143     0.200
     1.693    33.387     0.200
     1.725    34.769     0.200
     1.755    34.701     0.200
     0.300     6.769     0.200
     0.675    14.122     0.200
     0.715    16.182     0.200
     0.981    18.118     0.200
     1.664    33.524     0.200
     1.751    33.204     0.200
     0.146     4.049     0.200
     0.168     4.136     0.200
     0.270     5.467     0.200
     0.318     6.087     0.200
     0.304     7.036     0.200
     0.344     6.738     0.200
     0.383     7.412     0.200
     0.384     8.210     0.200
     0.368     7.655     0.200
     0.424     9.484     0.200
     0.510    10.840     0.200
     0.524    10.914     0.200
     0.549    10.238     0.200
     0.517    10.699     0.200
     0.647    13.746     0.200
     0.662    13.915     0.200
     0.685    13.159     0.200
     0.687    14.331     0.200
     0.743    14.692     0.200
     0.753    14.845     0.200
     0.757    14.460     0.200
     0.784    16.472     0.200
     0.830    16.801     0.200
     0.824    17.696     0.200
     0.850    18.218     0.200
     0.921    18.591     0.200
     0.936    18.990     0.200
     0.946    19.093     0.200
     1.049    20.824     0.200
     1.074    21.311     0.200
     1.094    22.076     0.200
     1.186    23.165     0.200
     1.204    24.720     0.200
     1.678    33.215     0.200
     1.697    33.449     0.200
     1.728    34.668     0.200
     1.759    34.669     0.200
     0.677    13.901     0.200
     1.755    33.971     0.200
     2.111    39.784     0.200
     2.484    46.592     0.200
     0.075     3.631     0.200
     0.098     3.690     0.200
     0.237     6.142     0.200
     0.262     6.497     0.200
     0.421     8.906     0.200
     0.466    10.002     0.200
     0.539    11.150     0.200
     0.554    11.956     0.200
     0.575    12.209     0.200
     0.613    12.809     0.200
     0.611    13.250     0.200
     0.646    13.939     0.200
     0.734    13.790     0.200
     0.796    15.708     0.200
     0.873    17.909     0.200
     1.000    20.015     0.200
     1.104    22.240     0.200
     1.115    22.367     0.200
     1.138    23.317     0.200
     1.665    33.506     0.200
     0.422     8.091     0.200
     1.694    33.788     0.200
     0.054     2.850     0.200
     0.280     6.604     0.200
     0.295     6.247     0.200
     0.387     8.755     0.200
     0.377     8.585     0.200
     0.513    10.376     0.200
     0.568    12.130     0.200
     0.622    13.246     0.200
     0.661    13.667     0.200
     0.772    16.799     0.200
     0.775    16.295     0.200
     0.964    20.538     0.200
     1.003    19.718     0.200
     1.055    21.666     0.200
     1.107    22.609     0.200
     1.169    23.939     0.200
     1.255    25.359     0.200
     1.934    37.637     0.200
     0.038     4.569     0.200
     0.112     4.084     0.200
     0.133     4.134     0.200
     0.190     5.177     0.200
     0.207     5.414     0.200
     0.266     6.185     0.200
     0.281     6.740     0.200
     0.309     6.582     0.200
     0.354     7.335     0.200
     0.474    10.062     0.200
     0.501    11.164     0.200
     0.501     9.967     0.200
     0.611    12.283     0.200
     0.622    12.648     0.200
     0.650    13.584     0.200
     0.688    14.401     0.200
     0.700    14.101     0.200
     0.700    14.163     0.200
     0.704    14.175     0.200
     0.741    15.931     0.200
     0.783    15.822     0.200
     0.875    17.744     0.200
     1.002    20.538     0.200
     0.207     4.885     0.200
     0.201     5.094     0.200
     0.218     5.351     0.200
     0.249     5.728     0.200
     0.299     6.638     0.200
     0.333     6.747     0.200
     0.356     7.606     0.200
     0.415     8.611     0.200
     0.444     8.548     0.200
     0.725    14.781     0.200
     1.811    36.469     0.200
     0.302     6.649     0.200
     1.994    36.152     0.200
     2.076    39.393     0.200
     2.234    39.294     0.200
     2.161    39.524     0.200
     2.200    39.069     0.200
     2.343    42.766     0.200
     2.396    41.824     0.200
     2.482    42.842     0.200
     2.490    43.802     0.200
     2.568    45.120     0.200
     0.451    11.116     0.200
     1.523    29.449     0.200
     1.877    35.546     0.200
     2.466    43.642     0.200
     0.039     1.739     0.200
     0.972    20.425     0.200
     1.948    38.142     0.200
     1.897    38.959     0.200
     2.031    39.115     0.200
     2.052    40.121     0.200
     2.092    40.764     0.200
     2.341    43.564     0.200
     2.362    45.028     0.200
     2.401    44.539     0.200
     2.415    44.885     0.200
     2.555    47.111     0.200
     2.780    52.078     0.200
     2.868    52.472     0.200
     3.128    57.685     0.200
     0.607    13.444     0.200
     0.763    13.916     0.200
     0.751    15.159     0.200
     1.666    32.972     0.200
     1.885    35.773     0.200
     2.911    52.449     0.200
     0.715    13.801     0.200
     2.642    46.202     0.200
     2.835    51.065     0.200
     2.771    48.494     0.200
     2.778    51.923     0.200
     3.319    57.632     0.200
     0.596    12.294     0.200
     1.912    35.367     0.200
     2.045    36.727     0.200
     2.104    39.044     0.200
     2.363    43.928     0.200
     2.451    42.900     0.200
     2.698    46.519     0.200
     2.801    50.032     0.200
     0.863    16.879     0.200
     2.886    51.914     0.200
     3.055    53.881     0.200
     3.190    56.494     0.200
     3.205    57.410     0.200
     0.436     8.352     0.200
     0.787    15.182     0.200
     1.878    38.216     0.200
     0.381     8.786     0.200
     1.355    24.385     0.200
     1.955    37.241     0.200
     2.440    42.098     0.200
     2.467    43.860     0.200
     2.529    44.330     0.200
     2.965    54.847     0.200
     3.478    59.747     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.126    22.667     0.200
     2.718    44.158     0.200
     2.810    45.331     0.200
     3.029    50.245     0.200
     0.072     2.495     0.200
     2.593    44.322     0.200
     3.342    52.735     0.200
     4.715    69.420     0.200
     1.173    23.765     0.200
     4.675    68.344     0.200
     1.112    23.875     0.200
     2.695    45.115     0.200
     1.144    23.094     0.200
     0.215     5.095     0.200
     0.120     3.794     0.200
     0.048     3.550     0.200
     0.187     4.296     0.200
     1.123    24.950     0.200
     2.054    37.905     0.200
     0.205     4.637     0.200
     0.210     5.008     0.200
     2.853    45.712     0.200
     0.218     5.150     0.200
     0.188     4.802     0.200
     0.034     3.116     0.200
     0.217     5.199     0.200
     2.225    40.827     0.200
     0.223     4.979     0.200
     0.053     3.531     0.200
     0.206     4.892     0.200
     0.179     4.512     0.200
     0.102     4.206     0.200
     0.248     5.866     0.200
     0.117     4.035     0.200
     2.374    42.508     0.200
     0.031     3.632     0.200
     0.085     3.191     0.200
     0.063     4.008     0.200
     2.698    46.119     0.200
     0.085     3.541     0.200
     0.023     3.389     0.200
     0.091     3.494     0.200
     0.198     4.912     0.200
     0.196     4.341     0.200
     0.073     3.694     0.200
     1.166    24.626     0.200
     2.371    43.302     0.200
     0.059     3.016     0.200
     1.107    24.737     0.200
     2.662    45.552     0.200
     0.630    13.253     0.200
EOF
gmt end
