#!/bin/bash
gmt begin chamoli16.22_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance chamoli16.22'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.8  0.000
  0.8 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    17.875
     0.900    19.230
     1.000    20.586
     1.100    21.942
     1.200    23.297
     1.300    24.653
     1.400    26.009
     1.500    27.364
     1.600    28.720
     1.700    30.076
     1.800    31.431
     1.900    32.787
     2.000    34.143
     2.100    35.498
     2.200    36.854
     2.300    38.210
     2.400    39.566
     2.500    40.921
     2.600    42.277
     2.700    43.633
     2.800    44.988
     2.900    46.344
     3.000    47.700
     3.100    49.055
     3.200    50.411
     3.300    51.767
     3.400    53.122
     3.500    54.478
     3.600    55.833
     3.700    57.188
     3.800    58.543
     3.900    59.898
     4.000    61.254
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    53.833 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.671
     0.200     4.194
     0.300     5.918
     0.400     7.709
     0.500     9.529
     0.600    11.364
     0.700    13.209
     0.800    15.059
     0.900    16.912
     1.000    18.769
     1.100    20.627
     1.200    22.414
     1.300    24.120
     1.400    25.825
     1.500    27.530
     1.600    29.235
     1.700    30.940
     1.800    32.646
     1.900    34.351
     2.000    36.056
     2.100    37.761
     2.200    39.466
     2.300    41.172
     2.400    42.877
     2.500    44.582
     2.600    46.287
     2.700    47.992
     2.800    49.697
     2.900    51.402
     3.000    53.107
     3.100    54.812
     3.200    56.517
     3.300    58.222
     3.400    59.927
     3.500    61.632
     3.600    63.336
     3.700    65.041
     3.800    66.746
     3.900    68.450
     4.000    70.155
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    62.336 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.900    32.775
     1.000    35.177
     1.100    37.579
     1.200    39.981
     1.300    42.383
     1.400    44.785
     1.500    47.186
     1.600    49.588
     1.700    51.990
     1.800    54.392
     1.900    56.794
     2.000    59.196
     2.100    61.598
     2.200    64.000
     2.300    66.401
     2.400    68.803
     2.500    71.205
     2.600    73.607
     2.700    76.009
     2.800    78.411
     2.900    80.813
     3.000    83.215
     3.100    85.616
     3.200    88.018
     3.300    90.420
     3.400    92.822
     3.500    95.224
     3.600    97.626
     3.700   100.028
     3.800   102.429
     3.900   104.830
     4.000   107.231
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    95.626 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.579
     0.200     7.192
     0.300    10.147
     0.400    13.218
     0.500    16.339
     0.600    19.487
     0.700    22.649
     0.800    25.821
     0.900    29.000
     1.000    32.183
     1.100    35.265
     1.200    38.144
     1.300    41.023
     1.400    43.902
     1.500    46.781
     1.600    49.660
     1.700    52.539
     1.800    55.418
     1.900    58.297
     2.000    61.176
     2.100    64.055
     2.200    66.934
     2.300    69.813
     2.400    72.692
     2.500    75.571
     2.600    78.449
     2.700    81.328
     2.800    84.206
     2.900    87.085
     3.000    89.963
     3.100    92.841
     3.200    95.720
     3.300    98.598
     3.400   101.477
     3.500   104.355
     3.600   107.233
     3.700   110.111
     3.800   112.989
     3.900   115.867
     4.000   118.745
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   106.233 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    20.543
     1.000    21.899
     1.100    23.255
     1.200    24.610
     1.300    25.966
     1.400    27.322
     1.500    28.677
     1.600    30.033
     1.700    31.389
     1.800    32.744
     1.900    34.100
     2.000    35.456
     2.100    36.811
     2.200    38.167
     2.300    39.523
     2.400    40.878
     2.500    42.234
     2.600    43.590
     2.700    44.945
     2.800    46.301
     2.900    47.657
     3.000    49.012
     3.100    50.368
     3.200    51.724
     3.300    53.079
     3.400    54.435
     3.500    55.791
     3.600    57.146
     3.700    58.502
     3.800    59.856
     3.900    61.212
     4.000    62.567
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.869
     0.200     3.737
     0.300     5.606
     0.400     7.475
     0.500     9.344
     0.600    11.212
     0.700    13.081
     0.800    14.950
     0.900    16.819
     1.000    18.687
     1.100    20.556
     1.200    22.425
     1.300    24.294
     1.400    26.162
     1.500    28.031
     1.600    29.900
     1.700    31.718
     1.800    33.423
     1.900    35.129
     2.000    36.834
     2.100    38.539
     2.200    40.244
     2.300    41.949
     2.400    43.655
     2.500    45.360
     2.600    47.065
     2.700    48.770
     2.800    50.476
     2.900    52.181
     3.000    53.886
     3.100    55.591
     3.200    57.295
     3.300    59.000
     3.400    60.705
     3.500    62.410
     3.600    64.115
     3.700    65.820
     3.800    67.525
     3.900    69.229
     4.000    70.934
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    37.342
     1.100    39.744
     1.200    42.146
     1.300    44.548
     1.400    46.950
     1.500    49.351
     1.600    51.753
     1.700    54.155
     1.800    56.557
     1.900    58.959
     2.000    61.361
     2.100    63.763
     2.200    66.165
     2.300    68.566
     2.400    70.968
     2.500    73.370
     2.600    75.772
     2.700    78.174
     2.800    80.576
     2.900    82.978
     3.000    85.379
     3.100    87.781
     3.200    90.183
     3.300    92.585
     3.400    94.987
     3.500    97.389
     3.600    99.791
     3.700   102.193
     3.800   104.594
     3.900   106.995
     4.000   109.396
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.204
     0.200     6.409
     0.300     9.613
     0.400    12.817
     0.500    16.022
     0.600    19.226
     0.700    22.430
     0.800    25.635
     0.900    28.839
     1.000    32.043
     1.100    35.247
     1.200    38.452
     1.300    41.656
     1.400    44.860
     1.500    48.065
     1.600    51.092
     1.700    53.971
     1.800    56.850
     1.900    59.729
     2.000    62.608
     2.100    65.487
     2.200    68.366
     2.300    71.245
     2.400    74.124
     2.500    77.003
     2.600    79.882
     2.700    82.761
     2.800    85.640
     2.900    88.518
     3.000    91.396
     3.100    94.275
     3.200    97.153
     3.300   100.031
     3.400   102.910
     3.500   105.788
     3.600   108.667
     3.700   111.546
     3.800   114.423
     3.900   117.301
     4.000   120.179
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    12.955
     0.700    14.311
     0.800    15.667
     0.900    17.022
     1.000    18.378
     1.100    19.734
     1.200    21.090
     1.300    22.445
     1.400    23.801
     1.500    25.157
     1.600    26.512
     1.700    27.868
     1.800    29.224
     1.900    30.579
     2.000    31.935
     2.100    33.291
     2.200    34.646
     2.300    36.002
     2.400    37.358
     2.500    38.713
     2.600    40.069
     2.700    41.425
     2.800    42.780
     2.900    44.136
     3.000    45.492
     3.100    46.847
     3.200    48.203
     3.300    49.558
     3.400    50.913
     3.500    52.269
     3.600    53.624
     3.700    54.979
     3.800    56.334
     3.900    57.689
     4.000    59.045
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.655
     0.200     6.457
     0.300     7.606
     0.400     8.966
     0.500    10.454
     0.600    12.017
     0.700    13.627
     0.800    15.267
     0.900    16.925
     1.000    18.596
     1.100    20.274
     1.200    21.958
     1.300    23.646
     1.400    25.337
     1.500    27.031
     1.600    28.726
     1.700    30.422
     1.800    32.119
     1.900    33.817
     2.000    35.515
     2.100    37.214
     2.200    38.914
     2.300    40.614
     2.400    42.314
     2.500    44.014
     2.600    45.715
     2.700    47.416
     2.800    49.117
     2.900    50.818
     3.000    52.520
     3.100    54.221
     3.200    55.923
     3.300    57.624
     3.400    59.326
     3.500    61.028
     3.600    62.730
     3.700    64.431
     3.800    66.133
     3.900    67.835
     4.000    69.537
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    22.070
     0.700    24.472
     0.800    26.874
     0.900    29.276
     1.000    31.677
     1.100    34.079
     1.200    36.481
     1.300    38.883
     1.400    41.285
     1.500    43.687
     1.600    46.089
     1.700    48.490
     1.800    50.892
     1.900    53.294
     2.000    55.696
     2.100    58.098
     2.200    60.500
     2.300    62.902
     2.400    65.303
     2.500    67.705
     2.600    70.107
     2.700    72.509
     2.800    74.911
     2.900    77.313
     3.000    79.715
     3.100    82.116
     3.200    84.518
     3.300    86.920
     3.400    89.322
     3.500    91.723
     3.600    94.124
     3.700    96.525
     3.800    98.926
     3.900   101.327
     4.000   103.728
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     9.641
     0.200    11.006
     0.300    12.962
     0.400    15.276
     0.500    17.803
     0.600    20.456
     0.700    23.185
     0.800    25.962
     0.900    28.767
     1.000    31.591
     1.100    34.428
     1.200    37.273
     1.300    40.125
     1.400    42.981
     1.500    45.841
     1.600    48.703
     1.700    51.567
     1.800    54.432
     1.900    57.299
     2.000    60.168
     2.100    63.037
     2.200    65.906
     2.300    68.777
     2.400    71.647
     2.500    74.518
     2.600    77.390
     2.700    80.261
     2.800    83.133
     2.900    86.006
     3.000    88.878
     3.100    91.751
     3.200    94.624
     3.300    97.496
     3.400   100.369
     3.500   103.243
     3.600   106.116
     3.700   108.989
     3.800   111.862
     3.900   114.735
     4.000   117.608
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     3.117    48.350     0.200
     5.520    81.350     0.200
     7.414   104.350     0.200
     8.749   124.350     0.200
    11.720   162.850     0.200
    12.457   173.350     0.200
    12.610   177.350     0.200
    13.502   189.350     0.200
    19.980   272.350     0.200
     3.380    52.445     0.200
     6.965   104.148     0.200
     9.153   131.047     0.200
     9.820   141.047     0.200
    10.608   148.844     0.200
    12.090   169.547     0.200
    12.285   175.047     0.200
    12.284   175.047     0.200
    12.682   178.047     0.200
    12.852   184.047     0.200
    12.983   184.047     0.200
    12.945   184.047     0.200
    13.312   186.047     0.200
    13.760   195.047     0.200
    13.982   197.047     0.200
    14.893   207.047     0.200
    15.091   209.047     0.200
    16.692   228.047     0.200
    20.384   279.047     0.200
    21.126   287.047     0.200
     2.581    41.262     0.200
     5.359    79.762     0.200
     7.612   105.262     0.200
    10.646   148.562     0.200
    11.620   162.262     0.200
    13.000   178.262     0.200
    13.095   179.262     0.200
    12.759   182.262     0.200
     1.655    28.088     0.200
     2.799    45.588     0.200
     5.035    76.088     0.200
     6.080    91.488     0.200
    10.128   146.088     0.200
    10.218   146.588     0.200
    11.259   159.188     0.200
    11.494   162.088     0.200
    12.495   175.088     0.200
    12.735   176.188     0.200
    12.473   176.088     0.200
    12.829   178.588     0.200
    12.944   180.088     0.200
    13.165   187.088     0.200
    14.116   197.088     0.200
    16.625   226.588     0.200
    17.063   239.088     0.200
    19.496   268.088     0.200
     2.669    42.889     0.200
     4.453    67.689     0.200
     6.146    88.689     0.200
     6.051    90.689     0.200
     7.654   108.689     0.200
     9.593   137.189     0.200
    10.757   150.589     0.200
    11.660   164.689     0.200
    12.097   168.689     0.200
    13.000   180.689     0.200
    12.825   181.689     0.200
    13.114   180.689     0.200
    13.494   187.689     0.200
    16.978   233.189     0.200
    17.487   240.689     0.200
     3.032    47.969     0.200
     3.645    57.969     0.200
    10.346   150.570     0.200
    10.559   149.469     0.200
    11.149   156.570     0.200
    11.757   166.672     0.200
    11.910   168.672     0.200
    12.170   168.969     0.200
    12.655   175.570     0.200
    12.659   175.070     0.200
    12.878   178.172     0.200
    12.785   179.367     0.200
    13.021   180.570     0.200
    13.428   188.570     0.200
    13.412   188.570     0.200
    13.577   190.570     0.200
    14.398   199.570     0.200
    14.565   200.570     0.200
    16.562   225.469     0.200
    16.946   229.570     0.200
    18.825   260.070     0.200
    20.020   273.570     0.200
     3.236    50.766     0.200
     9.110   133.965     0.200
    10.378   148.266     0.200
    10.896   153.766     0.200
    10.896   153.666     0.200
    10.816   151.266     0.200
    11.848   165.965     0.200
    12.154   170.266     0.200
    12.536   174.066     0.200
    13.111   181.266     0.200
    13.111   181.666     0.200
    13.046   181.266     0.200
    13.645   191.266     0.200
    13.629   191.965     0.200
    13.829   196.266     0.200
    13.829   197.066     0.200
    14.891   206.266     0.200
    14.891   206.666     0.200
    16.451   223.666     0.200
    18.587   256.266     0.200
    20.389   277.266     0.200
     3.163    49.969     0.200
     4.600    69.969     0.200
     4.646    70.469     0.200
     4.851    73.168     0.200
     5.078    75.168     0.200
     5.595    86.367     0.200
     7.069   102.469     0.200
     7.250   106.668     0.200
     8.071   116.566     0.200
     8.385   120.566     0.200
     8.696   124.969     0.200
     9.092   131.168     0.200
     9.204   134.266     0.200
     9.706   136.367     0.200
    10.921   154.168     0.200
    11.797   165.668     0.200
    12.083   170.367     0.200
    12.565   173.367     0.200
    12.720   178.367     0.200
    12.720   178.867     0.200
    12.867   179.168     0.200
    12.888   179.367     0.200
    13.464   187.367     0.200
    13.828   190.367     0.200
    14.613   202.367     0.200
    14.613   202.867     0.200
    15.008   209.969     0.200
    16.477   223.668     0.200
    19.783   270.367     0.200
     2.533    41.266     0.200
     5.248    79.164     0.200
     6.212    92.965     0.200
     6.484    96.766     0.200
     6.524    96.867     0.200
     6.444    96.367     0.200
     6.522    98.164     0.200
     6.733   100.164     0.200
     6.872   102.766     0.200
     7.312   108.664     0.200
    13.401   185.766     0.200
    14.118   195.766     0.200
    17.230   234.766     0.200
     1.819    31.127     0.200
     2.843    44.027     0.200
     8.026   114.027     0.200
     9.651   135.627     0.200
     9.586   138.527     0.200
    11.305   157.527     0.200
    12.549   174.027     0.200
    12.585   173.027     0.200
    12.746   176.727     0.200
    12.878   177.527     0.200
    13.278   184.027     0.200
    13.730   188.227     0.200
    16.482   222.227     0.200
    19.800   270.027     0.200
     0.959    19.179     0.200
     2.478    42.679     0.200
     9.955   140.679     0.200
    10.431   151.379     0.200
    12.281   173.179     0.200
    12.863   182.179     0.200
    12.913   181.179     0.200
    13.902   193.179     0.200
    16.901   231.179     0.200
     2.434    40.445     0.200
     2.503    41.047     0.200
     4.684    70.750     0.200
     7.081   102.945     0.200
     7.124   103.648     0.200
     7.253   105.344     0.200
     7.331   106.445     0.200
     8.339   120.648     0.200
     8.572   125.047     0.200
     9.591   136.047     0.200
     9.615   138.047     0.200
     9.790   139.148     0.200
    10.070   142.047     0.200
    10.108   142.047     0.200
    10.108   142.648     0.200
    10.386   145.445     0.200
    10.643   150.344     0.200
    10.680   151.047     0.200
    10.794   153.047     0.200
    12.032   173.047     0.200
    12.188   172.648     0.200
    12.152   172.047     0.200
    12.136   172.047     0.200
    12.412   173.445     0.200
    13.029   181.148     0.200
    13.069   183.047     0.200
    13.622   187.547     0.200
    14.154   196.047     0.200
    14.163   195.047     0.200
    14.185   197.047     0.200
    14.827   206.547     0.200
    16.619   231.844     0.200
    17.414   236.047     0.200
    17.589   243.047     0.200
    17.771   243.047     0.200
    17.771   243.844     0.200
    19.466   267.047     0.200
    20.762   281.047     0.200
     4.301    68.803     0.200
     5.667    85.402     0.200
     5.785    86.203     0.200
     7.031   102.902     0.200
     7.087   104.603     0.200
     7.828   115.103     0.200
     8.926   126.803     0.200
     9.393   136.803     0.200
    12.214   171.303     0.200
     4.276    68.859     0.200
     5.142    78.359     0.200
     5.640    85.359     0.200
     6.746    98.961     0.200
     7.006   102.359     0.200
     7.059   104.258     0.200
     7.797   113.961     0.200
     8.945   127.359     0.200
     9.389   136.859     0.200
     9.930   142.359     0.200
    12.243   171.359     0.200
    12.845   182.059     0.200
    12.899   181.359     0.200
    13.018   182.359     0.200
    13.096   185.258     0.200
    13.883   194.359     0.200
    14.738   204.359     0.200
     3.105    51.070     0.200
     5.110    77.070     0.200
     5.539    85.570     0.200
     6.184    92.367     0.200
     6.353    95.070     0.200
     7.007   103.070     0.200
     8.011   116.969     0.200
     8.272   120.469     0.200
     8.633   124.570     0.200
     8.677   126.570     0.200
     9.029   130.867     0.200
     9.269   135.367     0.200
     9.687   138.570     0.200
    10.277   148.570     0.200
    10.817   156.570     0.200
    10.982   155.172     0.200
    11.875   172.570     0.200
    12.407   174.570     0.200
    12.559   175.867     0.200
    12.839   181.172     0.200
    12.952   181.570     0.200
    13.803   190.867     0.200
    15.027   213.070     0.200
    16.468   226.570     0.200
    20.088   274.570     0.200
     2.530    42.066     0.200
     5.389    81.266     0.200
     5.695    83.566     0.200
     5.750    86.664     0.200
     5.946    89.164     0.200
     5.990    89.266     0.200
     5.909    89.266     0.200
     6.197    91.867     0.200
     6.407    95.164     0.200
     6.733   100.266     0.200
     6.984   103.465     0.200
     7.046   106.066     0.200
     7.376   109.867     0.200
     7.389   109.465     0.200
     7.797   115.465     0.200
    12.254   171.867     0.200
    12.910   181.266     0.200
    13.083   182.266     0.200
    19.041   263.066     0.200
     1.252    23.268     0.200
     2.500    42.468     0.200
     5.323    80.468     0.200
     5.879    88.268     0.200
     5.925    88.468     0.200
     5.981    89.968     0.200
     6.130    90.868     0.200
     6.345    94.068     0.200
     6.794   100.168     0.200
     7.053   103.268     0.200
     8.903   128.668     0.200
    10.353   149.668     0.200
    12.194   170.668     0.200
    12.853   177.668     0.200
    12.910   181.668     0.200
    13.008   181.668     0.200
    13.228   185.668     0.200
    13.888   193.668     0.200
    16.865   231.668     0.200
    17.490   243.668     0.200
    19.055   263.068     0.200
    20.201   276.668     0.200
    13.008   184.696     0.200
     1.477    26.352     0.200
     2.609    42.451     0.200
     4.764    72.551     0.200
     5.315    79.932     0.200
     5.367    80.570     0.200
     5.569    83.051     0.200
     5.798    86.592     0.200
     5.754    88.951     0.200
     6.337    95.150     0.200
     6.558    98.352     0.200
     7.625   111.951     0.200
     7.662   111.951     0.200
     7.963   115.150     0.200
     8.326   120.951     0.200
     8.358   121.752     0.200
     9.912   144.951     0.200
    11.651   163.451     0.200
    11.799   165.951     0.200
    11.799   169.051     0.200
    12.693   180.951     0.200
    19.867   272.951     0.200
    20.741   283.150     0.200
     2.144    36.109     0.200
     2.940    45.812     0.200
     4.060    62.172     0.200
     4.605    69.633     0.200
     4.666    70.148     0.200
     4.863    73.250     0.200
     5.110    76.953     0.200
     7.027   101.312     0.200
     7.284   106.211     0.200
     8.052   115.609     0.200
     8.347   119.312     0.200
     8.369   120.109     0.200
     9.355   135.312     0.200
     9.707   139.109     0.200
    10.963   153.109     0.200
    12.160   170.008     0.200
    12.301   174.406     0.200
    12.280   169.109     0.200
    12.508   174.109     0.200
    12.508   175.312     0.200
    12.566   175.109     0.200
    12.729   177.109     0.200
    12.729   176.711     0.200
    12.753   178.109     0.200
    13.103   185.109     0.200
    13.565   188.109     0.200
    13.966   198.109     0.200
    14.750   204.109     0.200
    16.188   221.109     0.200
    19.498   266.109     0.200
     5.357    81.227     0.200
     5.501    84.625     0.200
     5.797    87.125     0.200
     6.331    94.727     0.200
     6.354    94.125     0.200
     6.397    94.930     0.200
     6.575    97.828     0.200
     6.596    95.328     0.200
     6.604    97.727     0.200
     6.811   101.125     0.200
     6.982   104.227     0.200
     7.413   110.430     0.200
     9.006   130.430     0.200
     9.039   131.727     0.200
     9.228   129.328     0.200
    10.136   144.227     0.200
    10.301   147.430     0.200
    10.749   154.328     0.200
    10.765   152.227     0.200
    10.891   157.328     0.200
    11.330   159.727     0.200
    11.330   160.227     0.200
    11.432   158.727     0.200
    11.820   167.727     0.200
    12.506   178.727     0.200
    12.533   179.227     0.200
    12.517   179.227     0.200
    12.579   179.727     0.200
    12.657   176.328     0.200
    12.969   180.727     0.200
    12.969   180.930     0.200
    13.109   183.727     0.200
    13.280   184.023     0.200
    14.028   194.727     0.200
    14.832   208.328     0.200
    14.832   208.492     0.200
    17.020   236.727     0.200
    18.101   244.727     0.200
    18.315   252.727     0.200
    20.192   275.727     0.200
     2.509    41.667     0.200
     5.298    79.167     0.200
     5.427    83.067     0.200
     5.867    88.268     0.200
     6.266    93.067     0.200
     6.425    96.167     0.200
     6.466    95.268     0.200
     6.504    97.067     0.200
     6.679    96.867     0.200
     6.675    98.867     0.200
     6.878   101.667     0.200
     7.359   109.268     0.200
     9.309   129.867     0.200
    13.350   184.067     0.200
    13.699   189.867     0.200
    14.081   196.867     0.200
     2.475    40.248     0.200
     5.291    78.848     0.200
     5.432    82.049     0.200
     5.866    86.348     0.200
     6.263    91.947     0.200
     6.423    94.348     0.200
     6.466    94.148     0.200
     6.506    95.148     0.200
     6.662    94.248     0.200
     6.674    97.748     0.200
     6.916   100.848     0.200
     6.880    99.248     0.200
     7.349   107.947     0.200
     8.987   129.748     0.200
     9.286   127.348     0.200
    10.164   143.248     0.200
    10.170   144.248     0.200
    10.699   150.748     0.200
    10.699   151.248     0.200
    10.809   155.748     0.200
    10.842   155.148     0.200
    11.262   159.748     0.200
    11.670   166.748     0.200
    12.455   176.748     0.200
    12.455   177.549     0.200
    12.489   176.748     0.200
    12.984   183.748     0.200
    12.984   178.947     0.200
    12.997   183.748     0.200
    12.997   180.947     0.200
    13.318   182.748     0.200
    14.046   192.748     0.200
    14.823   207.648     0.200
    16.951   231.748     0.200
    19.628   267.748     0.200
     2.042    36.148     0.200
     2.445    39.848     0.200
     5.264    79.047     0.200
     5.561    82.848     0.200
     5.413    82.648     0.200
     5.888    88.047     0.200
     6.238    92.949     0.200
     6.444    96.047     0.200
     6.488    96.047     0.200
     6.485    95.949     0.200
     6.695    98.848     0.200
     6.904   102.047     0.200
     6.889   101.148     0.200
     7.320   107.949     0.200
    12.749   177.848     0.200
    13.303   183.348     0.200
    14.022   196.848     0.200
     2.457    41.457     0.200
     2.187    40.559     0.200
     5.593    84.559     0.200
     5.741    86.438     0.200
     5.560    85.758     0.200
     6.297    94.539     0.200
     6.342    94.598     0.200
     6.548    97.719     0.200
     6.384    95.359     0.200
     6.757   100.160     0.200
     6.633    98.758     0.200
     7.031   104.160     0.200
     7.459   112.160     0.200
     9.094   133.957     0.200
    10.708   154.359     0.200
    10.826   154.758     0.200
    12.604   176.559     0.200
    12.939   184.559     0.200
    12.562   180.559     0.200
    13.234   183.059     0.200
    13.995   192.758     0.200
    14.858   209.559     0.200
    15.825   216.559     0.200
    20.412   278.258     0.200
     2.276    39.016     0.200
     3.243    51.914     0.200
     6.315    93.617     0.200
     7.130   104.414     0.200
     7.297   107.211     0.200
     8.128   118.414     0.200
     8.378   122.414     0.200
     9.157   132.211     0.200
    11.868   169.117     0.200
    12.402   174.016     0.200
    12.606   174.914     0.200
    12.930   180.914     0.200
    13.888   193.914     0.200
    16.520   225.414     0.200
    18.354   255.414     0.200
    18.823   260.414     0.200
    19.954   274.211     0.200
     2.571    39.664     0.200
     5.658    83.164     0.200
     5.799    85.064     0.200
     6.633    95.764     0.200
     6.872    98.465     0.200
     7.283   103.965     0.200
     7.712   111.164     0.200
     9.204   131.965     0.200
    12.355   170.164     0.200
    12.355   170.664     0.200
    12.988   178.164     0.200
    13.031   179.164     0.200
    12.672   178.164     0.200
    13.193   179.664     0.200
    14.793   207.664     0.200
    17.044   229.465     0.200
    20.381   276.664     0.200
     5.799    83.896     0.200
     5.799    83.896     0.200
     5.799    82.828     0.200
     5.799    82.809     0.200
     3.178    50.449     0.200
     7.273   108.350     0.200
     7.278   106.148     0.200
     8.718   126.049     0.200
     9.185   135.049     0.200
    11.817   168.049     0.200
    12.558   173.549     0.200
    12.868   178.549     0.200
    13.665   191.549     0.200
    15.008   210.648     0.200
    16.470   225.049     0.200
    20.222   275.248     0.200
    20.211   275.049     0.200
     2.533    41.836     0.200
     2.508    45.234     0.200
     2.906    48.836     0.200
     3.684    60.336     0.200
     3.789    61.035     0.200
     3.902    63.535     0.200
     6.091    92.137     0.200
     6.296    95.234     0.200
     6.301    94.734     0.200
     7.224   105.035     0.200
     7.093   105.734     0.200
     7.365   109.137     0.200
     7.718   114.035     0.200
     8.121   120.035     0.200
     8.544   122.836     0.200
    11.900   167.836     0.200
    12.805   178.836     0.200
    18.981   261.836     0.200
    19.270   267.637     0.200
    12.805   182.273     0.200
    12.805   181.828     0.200
     6.301    93.242     0.200
     2.623    43.000     0.200
     2.992    48.941     0.200
     3.245    52.680     0.200
     3.352    55.301     0.200
     3.444    55.801     0.200
     3.567    57.500     0.200
     4.068    63.539     0.200
     4.336    68.000     0.200
     4.486    69.559     0.200
     4.696    73.699     0.200
     5.329    82.102     0.200
     5.825    86.500     0.200
     5.887    89.422     0.200
     5.928    89.941     0.200
     5.962    90.398     0.200
     5.966    90.500     0.200
     6.137    92.941     0.200
     6.341    95.500     0.200
     6.802   101.602     0.200
     7.041   105.398     0.200
     7.506   108.281     0.200
     7.364   109.160     0.200
     7.876   117.000     0.200
     8.018   117.980     0.200
     8.045   118.262     0.200
     8.423   126.348     0.200
     8.427   126.609     0.200
     8.438   126.754     0.200
     8.543   128.008     0.200
     8.516   127.375     0.200
     8.530   127.738     0.200
     8.535   127.738     0.200
     8.560   128.426     0.200
     8.567   128.504     0.200
     8.550   128.090     0.200
     8.575   128.871     0.200
    10.302   150.602     0.200
    12.186   171.000     0.200
    14.019   196.410     0.200
     5.966    88.867     0.200
     5.966    88.867     0.200
     5.966    87.969     0.200
     5.966    87.406     0.200
     5.966    88.426     0.200
     1.679    28.742     0.200
     2.609    41.941     0.200
     2.828    46.844     0.200
     3.000    48.043     0.200
     3.255    51.602     0.200
     3.342    53.742     0.200
     3.435    53.543     0.200
     3.556    56.441     0.200
     4.078    62.293     0.200
     4.327    65.242     0.200
     4.498    68.594     0.200
     4.706    72.133     0.200
     5.340    80.914     0.200
     5.775    85.242     0.200
     5.898    88.570     0.200
     5.940    88.871     0.200
     5.951    89.742     0.200
     5.956    89.242     0.200
     6.148    91.914     0.200
     6.353    94.230     0.200
     6.789    99.742     0.200
     7.030   102.641     0.200
     7.499   106.852     0.200
     7.375   108.031     0.200
     7.863   114.344     0.200
     8.030   116.914     0.200
     8.058   117.152     0.200
     8.356   124.301     0.200
     8.401   125.477     0.200
     8.962   131.203     0.200
     8.976   130.867     0.200
     9.014   131.941     0.200
     9.073   132.676     0.200
     9.152   132.520     0.200
     9.232   133.945     0.200
     9.251   133.773     0.200
     9.313   134.742     0.200
    10.317   148.844     0.200
    12.198   169.742     0.200
    12.364   171.242     0.200
    12.974   180.152     0.200
    12.974   181.242     0.200
    13.125   181.242     0.200
    14.010   194.254     0.200
    14.010   196.242     0.200
     5.956    87.547     0.200
     5.956    87.547     0.200
     5.956    86.934     0.200
     2.240    38.504     0.200
     2.475    42.301     0.200
     2.928    47.703     0.200
     2.991    50.602     0.200
     3.090    50.504     0.200
     3.207    53.504     0.200
     3.330    53.230     0.200
     3.602    57.133     0.200
     4.423    67.691     0.200
     5.052    78.254     0.200
     5.461    82.703     0.200
     5.602    85.902     0.200
     5.607    85.602     0.200
     5.693    86.332     0.200
     6.251    94.133     0.200
     6.293    94.594     0.200
     6.435    96.203     0.200
     6.501    97.371     0.200
     6.678    99.402     0.200
     6.707    99.711     0.200
     7.065   104.832     0.200
     7.728   112.672     0.200
     8.384   122.094     0.200
     8.599   128.504     0.200
     8.650   128.719     0.200
     8.689   129.953     0.200
     8.712   129.930     0.200
     8.785   130.758     0.200
     8.844   132.078     0.200
     8.860   131.988     0.200
     8.868   132.410     0.200
     8.868   132.633     0.200
     8.873   132.965     0.200
     8.955   133.641     0.200
    10.648   156.902     0.200
    13.250   183.902     0.200
    14.029   195.902     0.200
     1.544    25.844     0.200
     2.575    41.914     0.200
     2.704    44.320     0.200
     2.862    45.469     0.200
     2.968    47.117     0.200
     2.950    46.117     0.200
     3.126    49.344     0.200
     3.280    53.516     0.200
     3.468    55.320     0.200
     3.684    58.914     0.200
     4.460    68.117     0.200
     4.575    68.859     0.200
     5.029    73.867     0.200
     5.220    77.773     0.200
     5.743    83.820     0.200
     5.776    85.234     0.200
     5.821    85.734     0.200
     5.914    89.914     0.200
     6.027    88.258     0.200
     6.079    91.719     0.200
     6.083    90.617     0.200
     6.238    91.516     0.200
     6.901   101.719     0.200
     7.154   105.117     0.200
     7.396   105.109     0.200
     7.541   110.719     0.200
     7.912   114.359     0.200
     7.957   117.016     0.200
     8.289   123.844     0.200
     8.343   124.492     0.200
     8.385   125.227     0.200
     8.407   125.625     0.200
     8.410   124.898     0.200
     8.423   125.203     0.200
     8.419   125.727     0.200
     8.454   126.031     0.200
     8.463   126.578     0.200
     8.479   126.320     0.200
     8.514   126.445     0.200
     8.518   125.523     0.200
     8.521   126.727     0.200
     8.525   126.188     0.200
     8.538   125.914     0.200
     8.538   126.102     0.200
     8.544   126.633     0.200
     8.543   127.398     0.200
     8.553   127.031     0.200
     8.563   126.250     0.200
     8.616   127.883     0.200
     8.688   127.969     0.200
     8.914   130.742     0.200
     8.957   131.148     0.200
     8.966   130.352     0.200
     9.101   132.672     0.200
     9.181   133.695     0.200
     9.190   133.602     0.200
     9.258   134.586     0.200
     9.290   138.250     0.200
     9.322   135.320     0.200
     9.338   135.352     0.200
     9.451   136.414     0.200
    10.006   144.258     0.200
    10.241   147.117     0.200
    10.241   146.719     0.200
    10.730   151.320     0.200
    10.678   153.594     0.200
    11.249   159.914     0.200
    11.253   158.734     0.200
    12.087   169.016     0.200
    12.259   169.117     0.200
    12.891   180.219     0.200
    12.763   180.117     0.200
    12.763   179.711     0.200
    12.957   182.117     0.200
    13.006   178.320     0.200
    12.931   183.117     0.200
    12.919   183.117     0.200
    13.920   193.094     0.200
    13.920   194.859     0.200
    14.884   208.617     0.200
    14.884   208.406     0.200
    15.742   214.516     0.200
    17.595   243.117     0.200
     2.490    40.945     0.200
     2.828    46.742     0.200
     2.736    45.242     0.200
     3.328    55.242     0.200
     3.729    60.242     0.200
     5.697    83.242     0.200
     7.325   106.562     0.200
    11.208   160.914     0.200
    13.853   193.516     0.200
    12.826   180.781     0.200
     3.511    56.844     0.200
     5.939    91.242     0.200
     6.123    93.539     0.200
     6.128    92.344     0.200
     6.933   103.242     0.200
     7.195   106.445     0.200
     7.325   106.344     0.200
     7.566   112.242     0.200
     7.977   118.039     0.200
     8.317   124.938     0.200
     8.371   125.562     0.200
     8.412   126.141     0.200
     8.426   127.047     0.200
     8.428   126.422     0.200
     8.442   126.516     0.200
     8.445   126.539     0.200
     8.475   126.805     0.200
     8.480   127.773     0.200
     8.501   127.164     0.200
     8.530   127.578     0.200
     8.533   127.117     0.200
     8.537   127.656     0.200
     8.552   126.719     0.200
     8.553   127.500     0.200
     8.544   127.742     0.200
     8.555   126.734     0.200
     8.547   127.781     0.200
     8.559   127.117     0.200
     8.569   127.906     0.200
     8.576   127.391     0.200
     8.567   128.039     0.200
     8.628   128.016     0.200
     8.700   128.734     0.200
     8.750   129.258     0.200
     8.925   131.453     0.200
     8.966   131.969     0.200
     8.975   131.969     0.200
     9.110   133.453     0.200
     9.189   134.250     0.200
     9.197   134.234     0.200
     9.213   134.086     0.200
     9.263   135.109     0.200
     9.291   139.070     0.200
     9.326   135.852     0.200
     9.341   135.984     0.200
     9.524   137.742     0.200
    10.017   144.641     0.200
    10.688   153.602     0.200
    11.208   159.594     0.200
    12.826   180.781     0.200
    12.933   180.742     0.200
    13.853   193.148     0.200
    14.949   209.742     0.200
    17.630   245.242     0.200
     6.128    90.758     0.200
     6.128    90.758     0.200
     6.128    90.758     0.200
     6.128    90.758     0.200
     6.128    90.758     0.200
     6.128    91.523     0.200
     3.309    54.859     0.200
     3.709    60.461     0.200
    12.074   169.961     0.200
    12.838   181.461     0.200
     3.300    54.859     0.200
     3.492    57.258     0.200
     3.709    60.359     0.200
     6.104    91.664     0.200
     7.962   119.461     0.200
     8.319   125.312     0.200
     8.373   125.562     0.200
     8.414   126.203     0.200
     8.430   127.477     0.200
     8.433   126.859     0.200
     8.447   126.867     0.200
     8.479   127.180     0.200
     8.485   128.211     0.200
     8.504   127.609     0.200
     8.539   127.594     0.200
     8.536   128.250     0.200
     8.558   127.539     0.200
     8.540   128.016     0.200
     8.561   127.398     0.200
     8.559   128.156     0.200
     8.548   128.109     0.200
     8.551   128.109     0.200
     8.565   128.039     0.200
     8.574   128.570     0.200
     8.582   127.680     0.200
     8.570   128.375     0.200
     8.635   128.422     0.200
     8.706   129.047     0.200
     8.756   129.672     0.200
     8.932   131.570     0.200
     8.974   132.320     0.200
     8.983   131.625     0.200
     9.117   133.891     0.200
     9.196   134.609     0.200
     9.205   134.227     0.200
     9.222   134.852     0.200
     9.271   135.453     0.200
     9.301   139.852     0.200
     9.335   136.227     0.200
     9.350   135.742     0.200
     9.502   137.961     0.200
    10.023   145.500     0.200
    10.695   153.734     0.200
    14.936   210.961     0.200
    17.612   246.461     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
     6.108    90.703     0.200
    14.936   211.703     0.200
     2.599    43.133     0.200
     2.729    45.133     0.200
     2.953    48.133     0.200
     3.064    51.133     0.200
     3.575    58.133     0.200
     2.962    47.547     0.200
     3.657    58.547     0.200
    12.041   169.047     0.200
     3.333    54.148     0.200
     8.301   124.695     0.200
     8.396   125.562     0.200
     8.409   126.633     0.200
     8.412   125.984     0.200
     8.429   125.961     0.200
     8.426   126.062     0.200
     8.458   126.320     0.200
     8.464   127.234     0.200
     8.484   126.625     0.200
     8.521   127.172     0.200
     8.514   127.344     0.200
     8.516   126.883     0.200
     8.531   127.281     0.200
     8.537   127.266     0.200
     8.535   125.977     0.200
     8.539   126.125     0.200
     8.550   126.828     0.200
     8.542   127.375     0.200
     8.552   127.672     0.200
     8.733   128.789     0.200
     8.908   130.938     0.200
     8.959   131.844     0.200
     9.093   132.289     0.200
     9.172   133.758     0.200
     9.196   133.625     0.200
     9.246   133.609     0.200
     1.137    24.766     0.200
     2.582    39.766     0.200
     3.002    49.367     0.200
     3.125    52.266     0.200
     3.632    59.266     0.200
     2.976    48.703     0.200
     3.624    56.102     0.200
     3.654    58.703     0.200
     3.739    60.703     0.200
    12.045   169.203     0.200
     2.045    36.703     0.200
     3.002    48.703     0.200
     3.522    57.000     0.200
     6.139    93.406     0.200
     6.139    91.172     0.200
     6.139    90.609     0.200
     6.139    90.609     0.200
     6.139    90.609     0.200
     6.139    90.984     0.200
     6.139    90.047     0.200
     6.139    89.312     0.200
     1.354    26.156     0.200
     2.620    43.156     0.200
     3.449    53.953     0.200
     3.479    56.656     0.200
     3.572    58.156     0.200
     1.301    25.258     0.200
     1.912    35.156     0.200
     3.022    49.953     0.200
     2.844    46.156     0.200
     3.175    54.359     0.200
     3.357    54.656     0.200
     5.828    88.758     0.200
     5.966    91.359     0.200
     5.971    90.453     0.200
     7.046   105.758     0.200
     8.287   124.500     0.200
     8.342   124.969     0.200
     8.423   125.820     0.200
     8.387   125.391     0.200
     8.427   126.156     0.200
     8.438   125.734     0.200
     8.423   125.992     0.200
     8.481   127.773     0.200
     8.491   126.539     0.200
     8.542   127.688     0.200
     8.535   128.203     0.200
     8.566   127.055     0.200
     8.560   128.539     0.200
     8.517   126.844     0.200
     8.567   128.203     0.200
     8.530   127.266     0.200
     8.536   127.266     0.200
     8.591   127.055     0.200
     8.550   127.477     0.200
     8.645   128.922     0.200
     8.768   128.883     0.200
     8.946   132.086     0.200
     8.990   132.562     0.200
     8.998   131.914     0.200
     9.136   133.047     0.200
     9.216   134.078     0.200
     9.247   134.719     0.200
     9.300   135.188     0.200
     9.338   139.852     0.200
     9.382   137.125     0.200
     9.320   135.156     0.200
    10.037   145.617     0.200
    12.182   171.156     0.200
    18.946   262.656     0.200
     5.971    88.352     0.200
     5.971    88.352     0.200
     5.971    87.312     0.200
     5.971    87.453     0.200
     1.174    23.766     0.200
     2.946    48.562     0.200
     3.595    56.664     0.200
     3.626    59.766     0.200
     3.710    60.969     0.200
     2.973    48.562     0.200
     3.493    57.562     0.200
     5.922    90.969     0.200
     6.105    93.969     0.200
     6.110    93.062     0.200
     7.177   107.266     0.200
     7.960   119.562     0.200
     8.379   126.008     0.200
     8.420   126.898     0.200
     8.436   127.648     0.200
     8.439   126.945     0.200
     8.453   127.133     0.200
     8.485   127.320     0.200
     8.491   128.320     0.200
     8.511   127.320     0.200
     8.541   128.320     0.200
     8.544   128.570     0.200
     8.565   128.492     0.200
     8.567   127.008     0.200
     8.570   128.281     0.200
     8.576   128.477     0.200
     8.580   128.664     0.200
     6.110    90.898     0.200
     6.110    90.844     0.200
     6.110    91.336     0.200
     1.156    21.874     0.200
     2.559    41.874     0.200
     2.979    47.874     0.200
     2.969    48.274     0.200
     3.614    56.774     0.200
     3.645    59.874     0.200
     3.731    60.674     0.200
     5.727    87.874     0.200
     7.353   102.874     0.200
     1.118    21.774     0.200
     1.495    26.464     0.200
     1.830    32.864     0.200
     2.043    37.874     0.200
     2.809    45.744     0.200
     3.079    49.924     0.200
     2.996    48.274     0.200
     3.515    57.374     0.200
     9.506   139.174     0.200
    10.216   149.174     0.200
    12.215   168.874     0.200
    12.047   168.874     0.200
    12.855   177.874     0.200
    13.882   190.874     0.200
     2.635    40.549     0.200
     2.701    44.549     0.200
     2.768    46.549     0.200
     2.827    46.949     0.200
     2.561    42.355     0.200
     2.627    41.855     0.200
     2.751    43.855     0.200
     2.980    47.855     0.200
     3.180    52.855     0.200
     3.560    58.355     0.200
     2.436    42.174     0.200
     2.503    41.174     0.200
     2.630    43.174     0.200
     2.856    45.174     0.200
     2.531    42.471     0.200
     2.598    41.971     0.200
     2.665    43.971     0.200
     2.730    43.971     0.200
     2.952    46.971     0.200
     3.509    58.971     0.200
     3.626    58.971     0.200
     5.698    82.971     0.200
     1.600    28.781     0.200
     1.935    34.721     0.200
     2.913    48.381     0.200
     2.928    48.070     0.200
     3.184    51.561     0.200
     3.409    56.371     0.200
     4.406    68.170     0.200
     5.025    73.971     0.200
     5.849    88.170     0.200
     6.021    92.170     0.200
     6.025    91.170     0.200
     6.838   101.971     0.200
     7.094   105.771     0.200
     7.892   117.170     0.200
     8.346   125.426     0.200
     8.400   125.807     0.200
     8.443   125.916     0.200
     8.468   127.520     0.200
     8.471   126.818     0.200
     8.484   126.873     0.200
     8.478   126.617     0.200
     8.524   128.293     0.200
     8.540   127.225     0.200
     8.581   128.688     0.200
     8.576   128.561     0.200
     8.601   125.561     0.200
     8.600   128.305     0.200
     8.606   128.434     0.200
     8.615   129.070     0.200
     8.626   127.234     0.200
     8.602   127.557     0.200
     8.680   129.191     0.200
     8.978   131.914     0.200
     9.021   131.996     0.200
     9.029   132.459     0.200
     9.165   133.682     0.200
     9.245   133.994     0.200
     9.255   134.150     0.200
     9.262   135.088     0.200
     9.323   134.652     0.200
     9.403   136.342     0.200
     9.428   134.771     0.200
    10.307   150.971     0.200
    12.150   170.971     0.200
    12.250   171.471     0.200
    12.869   178.971     0.200
    13.008   178.971     0.200
    13.902   193.971     0.200
    19.018   262.971     0.200
     6.025    90.092     0.200
     6.025    89.088     0.200
     6.025    89.088     0.200
     6.025    88.955     0.200
     6.025    88.471     0.200
     1.187    23.223     0.200
     2.482    40.723     0.200
     2.658    43.523     0.200
     2.720    45.523     0.200
     2.945    46.523     0.200
     3.583    57.125     0.200
     3.485    55.523     0.200
     3.698    59.625     0.200
     7.340   105.523     0.200
    12.835   181.523     0.200
     1.526    28.043     0.200
     2.310    41.824     0.200
     2.837    46.832     0.200
     3.112    50.512     0.200
     3.481    57.223     0.200
     3.931    61.445     0.200
     4.367    67.945     0.200
     4.560    70.375     0.200
     4.481    69.523     0.200
     4.973    73.523     0.200
     5.212    78.922     0.200
     5.767    87.703     0.200
     5.814    87.043     0.200
     6.019    90.984     0.200
     5.912    89.824     0.200
     6.235    93.332     0.200
     6.093    92.723     0.200
     6.098    91.922     0.200
     6.591    98.125     0.200
     6.904   103.723     0.200
     7.247   106.125     0.200
     7.165   106.523     0.200
     7.906   116.164     0.200
     7.951   118.523     0.200
     8.329   124.688     0.200
     8.383   125.398     0.200
     8.441   127.035     0.200
     8.444   126.363     0.200
     8.424   125.926     0.200
     8.457   126.422     0.200
     8.458   126.320     0.200
     8.496   127.707     0.200
     8.489   126.715     0.200
     8.515   127.020     0.200
     8.550   126.727     0.200
     8.546   127.504     0.200
     8.572   126.953     0.200
     8.570   127.664     0.200
     8.550   127.520     0.200
     8.576   128.324     0.200
     8.558   127.621     0.200
     8.562   127.695     0.200
     8.585   128.059     0.200
     8.580   127.855     0.200
     8.768   129.539     0.200
     8.943   131.734     0.200
     8.994   131.875     0.200
     9.129   133.277     0.200
     9.217   134.152     0.200
     9.225   134.438     0.200
     9.233   134.324     0.200
     9.283   135.031     0.200
     9.312   139.363     0.200
     9.347   135.777     0.200
     9.361   135.918     0.200
     9.498   137.523     0.200
    10.258   149.523     0.200
    12.085   169.523     0.200
    12.952   181.023     0.200
    13.864   194.523     0.200
    12.952   183.855     0.200
     6.098    89.055     0.200
     6.098    90.059     0.200
     6.098    90.059     0.200
     6.098    90.059     0.200
     2.612    41.281     0.200
     2.679    44.281     0.200
     2.741    43.281     0.200
     2.966    45.480     0.200
     3.103    51.281     0.200
     3.613    58.281     0.200
     2.595    43.516     0.200
     2.986    47.516     0.200
     3.627    55.617     0.200
     3.746    60.516     0.200
    12.969   179.516     0.200
     1.114    21.414     0.200
     3.012    47.516     0.200
     3.530    57.414     0.200
     6.141    92.516     0.200
     6.146    92.117     0.200
     6.963   103.516     0.200
     7.216   107.215     0.200
     7.601   112.414     0.200
     8.017   118.316     0.200
     8.254   123.730     0.200
     8.307   124.438     0.200
     8.348   124.945     0.200
     8.365   125.543     0.200
     8.368   125.164     0.200
     8.381   125.320     0.200
     8.382   125.363     0.200
     8.413   125.629     0.200
     8.420   126.816     0.200
     8.439   126.004     0.200
     8.470   126.637     0.200
     8.474   126.059     0.200
     8.474   126.512     0.200
     8.482   126.602     0.200
     8.493   126.156     0.200
     8.485   126.602     0.200
     8.494   126.348     0.200
     8.496   126.254     0.200
     8.500   126.590     0.200
     8.504   126.734     0.200
     8.518   126.828     0.200
     8.570   127.215     0.200
     9.132   132.094     0.200
     9.142   132.836     0.200
     9.158   133.172     0.200
     9.208   133.281     0.200
     9.238   138.262     0.200
     9.287   133.727     0.200
     9.496   138.816     0.200
    10.186   148.816     0.200
    12.025   168.516     0.200
    12.979   179.516     0.200
     6.146    90.848     0.200
     6.146    90.883     0.200
     6.146    90.723     0.200
     6.146    90.723     0.200
     6.146    90.535     0.200
     6.146    90.648     0.200
     6.146    90.773     0.200
     6.146    89.031     0.200
     2.547    42.852     0.200
     2.679    43.602     0.200
     2.749    44.602     0.200
     2.966    47.000     0.200
     2.976    45.602     0.200
     3.623    56.102     0.200
     3.739    58.602     0.200
     7.337   105.430     0.200
     9.885   139.000     0.200
    11.226   159.734     0.200
    12.840   178.602     0.200
    12.931   179.102     0.200
    13.118   182.602     0.200
    13.866   192.672     0.200
     1.486    26.109     0.200
     1.823    32.328     0.200
     2.799    45.695     0.200
     3.002    45.602     0.200
     3.072    49.789     0.200
     3.522    56.805     0.200
     4.520    67.602     0.200
     4.520    69.445     0.200
     4.967    73.102     0.200
     5.171    78.445     0.200
     5.726    85.219     0.200
     5.772    86.000     0.200
     5.954    90.203     0.200
     5.978    89.102     0.200
     6.134    92.305     0.200
     6.138    91.305     0.200
     6.193    91.641     0.200
     6.549    96.883     0.200
     6.946   102.203     0.200
     7.206   105.703     0.200
     7.337   105.539     0.200
     7.580   111.805     0.200
     7.864   114.203     0.200
     7.993   117.398     0.200
     7.822   116.641     0.200
     8.393   124.859     0.200
     8.426   125.258     0.200
     8.461   126.898     0.200
     8.511   126.875     0.200
     8.514   125.719     0.200
     8.518   126.453     0.200
     8.533   124.172     0.200
     8.525   126.383     0.200
     8.534   126.273     0.200
     8.529   126.602     0.200
     8.537   125.719     0.200
     8.540   126.109     0.200
     8.550   126.930     0.200
     8.548   126.602     0.200
     8.557   126.414     0.200
     8.567   124.125     0.200
     8.610   127.062     0.200
     8.681   127.867     0.200
     8.731   128.305     0.200
     8.906   130.141     0.200
     8.948   130.961     0.200
     8.957   131.055     0.200
     8.492   127.219     0.200
     9.091   132.453     0.200
     9.170   133.891     0.200
     9.179   132.648     0.200
     9.195   133.141     0.200
     9.244   134.180     0.200
     9.308   134.898     0.200
     9.323   134.234     0.200
     9.521   137.102     0.200
     9.885   139.828     0.200
     9.998   144.188     0.200
    10.669   153.133     0.200
    11.226   159.750     0.200
    12.199   169.602     0.200
    12.043   168.602     0.200
    12.390   174.602     0.200
    12.840   180.430     0.200
    12.942   179.102     0.200
    12.999   186.102     0.200
    13.118   182.602     0.200
    12.988   184.602     0.200
    13.866   192.305     0.200
    13.866   193.875     0.200
    14.935   211.102     0.200
    17.642   243.602     0.200
    12.942   183.305     0.200
    12.942   183.305     0.200
    12.942   183.305     0.200
    12.942   183.633     0.200
     6.138    91.297     0.200
     6.138    90.172     0.200
     6.138    90.172     0.200
     6.138    90.172     0.200
     6.138    90.172     0.200
     6.138    90.172     0.200
     6.138    90.172     0.200
     6.138    90.172     0.200
     6.138    89.617     0.200
     6.138    89.438     0.200
    14.935   210.594     0.200
     2.756    45.359     0.200
     3.618    57.062     0.200
     3.739    60.461     0.200
     6.139    91.930     0.200
     6.139    90.297     0.200
     6.139    89.266     0.200
     6.139    89.109     0.200
     6.139    90.758     0.200
     6.139    90.758     0.200
     6.139    92.016     0.200
     6.139    90.422     0.200
     6.139    90.555     0.200
     2.625    42.676     0.200
     2.692    45.676     0.200
     2.759    45.676     0.200
     3.130    50.826     0.200
     3.465    58.176     0.200
     3.953    61.545     0.200
     4.375    68.066     0.200
     4.581    71.785     0.200
     5.218    80.406     0.200
     5.775    88.545     0.200
     5.818    88.545     0.200
     6.025    91.906     0.200
     6.233    93.566     0.200
     6.590    98.986     0.200
     7.253   106.605     0.200
     2.719    44.668     0.200
     2.777    46.668     0.200
     3.006    49.270     0.200
     3.003    49.668     0.200
     2.079    37.668     0.200
     2.379    42.168     0.200
     2.586    42.668     0.200
     2.781    45.840     0.200
     3.046    49.879     0.200
     3.029    49.668     0.200
     3.548    57.668     0.200
     3.866    59.629     0.200
     3.764    60.668     0.200
     4.297    66.297     0.200
     4.495    69.707     0.200
     5.141    77.668     0.200
     5.697    86.270     0.200
     5.742    85.988     0.200
     5.949    89.430     0.200
     6.162    91.977     0.200
     6.163    93.066     0.200
     7.176   104.488     0.200
     7.834   114.348     0.200
    12.959   179.668     0.200
    12.959   183.230     0.200
     6.163    90.934     0.200
     6.163    91.605     0.200
     1.144    22.906     0.200
     2.564    43.406     0.200
     2.917    48.406     0.200
     3.730    59.508     0.200
     1.137    22.648     0.200
     1.185    24.250     0.200
     2.694    45.750     0.200
     1.211    25.263     0.200
     2.607    43.963     0.200
     2.741    45.463     0.200
     3.536    56.763     0.200
     6.056    90.104     0.200
     6.056    89.205     0.200
     6.056    88.643     0.200
     6.056    89.878     0.200
     6.056    89.878     0.200
     6.056    89.878     0.200
     6.056    90.256     0.200
     1.114    21.293     0.200
     2.754    46.094     0.200
     2.838    46.443     0.200
     3.094    50.645     0.200
     3.012    49.094     0.200
     3.501    57.594     0.200
     3.716    59.895     0.200
     3.917    61.225     0.200
     4.340    67.824     0.200
     4.545    70.463     0.200
     7.219   105.703     0.200
     0.860    17.141     0.200
     1.120    22.141     0.200
     1.181    22.641     0.200
     2.563    41.453     0.200
     2.630    41.656     0.200
     2.858    44.852     0.200
     2.757    44.453     0.200
     3.715    58.953     0.200
     7.367   105.703     0.200
    11.240   159.727     0.200
    12.867   180.570     0.200
    13.894   193.930     0.200
     2.828    46.203     0.200
     2.954    48.352     0.200
     3.095    50.141     0.200
     3.309    53.953     0.200
     3.498    56.352     0.200
     4.347    67.461     0.200
     4.544    69.641     0.200
     4.998    73.953     0.200
     5.192    78.641     0.200
     5.533    79.453     0.200
     5.747    85.945     0.200
     5.793    86.641     0.200
     5.999    89.000     0.200
     6.110    92.656     0.200
     6.114    91.297     0.200
     6.212    92.023     0.200
     6.569    97.320     0.200
     6.927   102.750     0.200
     7.183   106.055     0.200
     7.367   105.555     0.200
     7.226   105.562     0.200
     7.564   112.250     0.200
     7.884   114.906     0.200
     7.820   116.750     0.200
     7.979   117.750     0.200
     8.385   124.922     0.200
     8.419   125.258     0.200
     8.419   125.344     0.200
     8.451   125.430     0.200
     8.509   126.641     0.200
     8.512   126.242     0.200
     8.511   126.422     0.200
     8.532   125.422     0.200
     8.520   126.461     0.200
     8.532   125.734     0.200
     8.535   125.969     0.200
     8.523   126.422     0.200
     8.538   125.961     0.200
     8.557   126.148     0.200
     8.542   126.680     0.200
     8.566   126.617     0.200
     8.609   126.945     0.200
     8.787   125.625     0.200
     8.681   127.695     0.200
     8.731   128.188     0.200
     8.907   130.320     0.200
     8.949   130.781     0.200
     8.957   130.875     0.200
     9.093   132.281     0.200
     9.181   133.148     0.200
     9.197   133.438     0.200
     9.247   133.961     0.200
     9.326   134.719     0.200
     9.998   144.414     0.200
    10.226   147.352     0.200
    11.240   159.727     0.200
    12.061   167.953     0.200
    12.867   180.570     0.200
    12.867   181.836     0.200
    12.974   179.453     0.200
    13.151   183.352     0.200
    13.894   192.477     0.200
    14.908   209.156     0.200
    12.974   183.961     0.200
    12.974   183.961     0.200
    12.974   183.961     0.200
    12.974   184.023     0.200
     6.114    88.898     0.200
     6.114    88.359     0.200
     6.114    89.945     0.200
     6.114    89.352     0.200
     1.070    20.375     0.200
     1.149    21.734     0.200
     1.188    22.836     0.200
     2.565    41.336     0.200
     2.859    45.836     0.200
     3.317    52.836     0.200
     3.713    59.836     0.200
     5.734    84.836     0.200
     7.370   105.875     0.200
    11.242   159.430     0.200
    12.869   180.336     0.200
    12.937   179.836     0.200
    13.897   192.773     0.200
     2.028    35.836     0.200
     2.565    40.836     0.200
     2.829    46.383     0.200
     2.956    48.836     0.200
     3.097    50.164     0.200
     3.308    52.836     0.200
     3.497    56.234     0.200
     4.348    67.578     0.200
     4.546    69.664     0.200
     5.001    73.836     0.200
     5.193    78.383     0.200
     5.536    79.836     0.200
     5.734    84.836     0.200
     5.748    85.734     0.200
     5.794    86.469     0.200
     6.000    88.984     0.200
     6.213    92.938     0.200
     6.108    93.133     0.200
     6.113    92.078     0.200
     6.569    97.578     0.200
     6.927   102.836     0.200
     7.227   105.609     0.200
     7.182   106.938     0.200
     7.564   112.633     0.200
     7.885   114.797     0.200
     7.979   117.633     0.200
     8.289   123.664     0.200
     8.342   124.570     0.200
     8.384   125.312     0.200
     8.402   126.492     0.200
     8.405   125.805     0.200
     8.418   125.852     0.200
     8.418   125.562     0.200
     8.450   126.203     0.200
     8.457   127.117     0.200
     8.476   126.055     0.200
     8.511   126.258     0.200
     8.508   126.984     0.200
     8.510   126.734     0.200
     8.531   125.695     0.200
     8.534   126.164     0.200
     8.531   126.812     0.200
     8.519   126.773     0.200
     8.522   126.789     0.200
     8.537   127.016     0.200
     8.547   127.391     0.200
     8.556   126.070     0.200
     8.540   126.992     0.200
     8.608   127.500     0.200
     8.789   125.703     0.200
     8.680   128.172     0.200
     8.730   128.742     0.200
     8.906   130.312     0.200
     8.948   130.945     0.200
     8.957   131.398     0.200
     9.092   132.844     0.200
     9.171   133.414     0.200
     9.180   133.305     0.200
     9.197   133.695     0.200
     9.247   134.180     0.200
     9.277   138.859     0.200
     9.311   135.250     0.200
     9.326   135.422     0.200
     9.485   136.836     0.200
     9.918   139.539     0.200
     9.997   144.555     0.200
    10.225   147.633     0.200
    11.242   159.430     0.200
    12.869   180.336     0.200
    12.977   179.836     0.200
    13.154   183.539     0.200
    13.897   192.695     0.200
    14.905   208.836     0.200
    18.970   261.836     0.200
    12.977   184.008     0.200
    12.977   184.008     0.200
    12.977   184.008     0.200
    12.977   184.008     0.200
     0.942    19.133     0.200
     1.114    21.383     0.200
     1.220    23.383     0.200
     3.228    52.586     0.200
     7.348   106.930     0.200
     1.061    20.273     0.200
     1.169    22.355     0.200
     2.579    42.555     0.200
     2.712    45.055     0.200
     2.877    45.855     0.200
     2.755    45.055     0.200
     2.977    49.254     0.200
     3.620    58.254     0.200
     3.738    59.055     0.200
     5.747    87.035     0.200
     7.369   105.785     0.200
     8.767   125.477     0.200
    11.257   160.477     0.200
    12.036   168.855     0.200
    12.873   180.074     0.200
    13.140   183.254     0.200
    13.899   192.715     0.200
     2.053    36.055     0.200
     2.353    41.555     0.200
     2.807    45.977     0.200
     2.755    45.453     0.200
     2.968    49.453     0.200
     3.072    49.793     0.200
     3.003    49.254     0.200
     3.333    55.055     0.200
     3.522    56.453     0.200
     4.323    67.156     0.200
     4.521    69.316     0.200
     4.475    70.555     0.200
     4.998    74.055     0.200
     5.167    78.113     0.200
     5.747    87.035     0.200
     5.723    85.375     0.200
     5.768    86.156     0.200
     5.974    89.355     0.200
     5.963    89.156     0.200
     6.187    92.895     0.200
     6.133    92.656     0.200
     6.137    92.180     0.200
     6.544    97.113     0.200
     6.952   102.453     0.200
     7.207   106.055     0.200
     7.860   115.133     0.200
     8.270   123.961     0.200
     8.324   124.508     0.200
     8.365   124.551     0.200
     8.381   125.848     0.200
     8.384   125.145     0.200
     8.397   125.461     0.200
     8.398   125.051     0.200
     8.429   125.777     0.200
     8.436   126.574     0.200
     8.455   126.098     0.200
     8.486   126.824     0.200
     8.490   125.531     0.200
     8.509   125.484     0.200
     8.490   126.164     0.200
     8.512   125.777     0.200
     8.510   126.711     0.200
     8.498   126.711     0.200
     8.502   126.211     0.200
     8.516   126.848     0.200
     8.525   127.074     0.200
     8.534   126.188     0.200
     8.520   127.004     0.200
     8.586   126.961     0.200
     8.767   125.363     0.200
     8.658   127.688     0.200
     8.708   128.277     0.200
     8.883   130.391     0.200
     8.925   131.391     0.200
     8.934   130.891     0.200
     9.069   131.684     0.200
     9.148   133.180     0.200
     9.157   133.180     0.200
     9.223   134.082     0.200
     9.253   138.926     0.200
     9.287   134.891     0.200
     9.302   135.719     0.200
     9.499   137.754     0.200
     9.975   144.617     0.200
    10.201   148.254     0.200
    11.257   160.477     0.200
    11.257   161.316     0.200
    12.231   170.555     0.200
    12.873   180.055     0.200
    12.873   182.664     0.200
    12.971   180.055     0.200
    13.140   183.254     0.200
    13.140   184.016     0.200
    13.140   184.305     0.200
    13.899   193.055     0.200
    14.902   208.656     0.200
    12.971   183.441     0.200
    12.971   184.527     0.200
    12.971   183.918     0.200
    12.971   184.234     0.200
    12.971   183.953     0.200
    12.971   183.953     0.200
    12.971   183.578     0.200
     6.137    90.426     0.200
     6.137    89.812     0.200
     6.137    89.789     0.200
     6.137    90.387     0.200
     6.137    89.395     0.200
     1.136    21.492     0.200
     1.202    23.793     0.200
     2.560    41.793     0.200
     2.694    44.793     0.200
     2.852    46.293     0.200
     3.580    58.094     0.200
     3.697    58.793     0.200
    12.077   169.793     0.200
    12.871   181.793     0.200
     2.845    46.473     0.200
     2.962    48.793     0.200
     3.112    50.293     0.200
     3.292    53.793     0.200
     3.481    55.992     0.200
     4.364    67.723     0.200
     4.435    70.793     0.200
     4.561    70.262     0.200
     5.007    73.793     0.200
     5.208    78.723     0.200
     5.729    83.793     0.200
     5.729    85.812     0.200
     5.764    87.082     0.200
     5.810    86.664     0.200
     5.922    88.895     0.200
     6.016    90.203     0.200
     6.092    91.992     0.200
     6.097    91.594     0.200
     6.229    92.902     0.200
     6.911   102.191     0.200
     7.166   106.094     0.200
     7.243   105.645     0.200
     7.374   105.715     0.200
     7.901   115.863     0.200
     8.298   124.031     0.200
     8.352   124.484     0.200
     8.393   125.062     0.200
     8.413   126.316     0.200
     8.416   125.793     0.200
     8.429   125.828     0.200
     8.427   125.551     0.200
     8.461   126.070     0.200
     8.468   127.043     0.200
     8.486   126.445     0.200
     8.519   127.215     0.200
     8.523   126.238     0.200
     8.520   126.652     0.200
     8.529   127.027     0.200
     8.532   127.027     0.200
     8.542   126.035     0.200
     8.543   126.781     0.200
     8.546   126.090     0.200
     8.549   126.934     0.200
     8.550   126.988     0.200
     8.558   127.270     0.200
     8.567   126.598     0.200
     8.620   126.613     0.200
     8.692   128.148     0.200
     8.804   125.965     0.200
     8.742   128.598     0.200
     8.918   130.445     0.200
     8.960   130.871     0.200
     8.969   131.062     0.200
     9.104   132.793     0.200
     9.183   133.555     0.200
     9.193   133.242     0.200
     9.260   134.477     0.200
     9.291   138.582     0.200
     9.324   135.211     0.200
     9.339   135.359     0.200
     9.474   136.992     0.200
    10.009   144.887     0.200
    10.239   147.395     0.200
    12.237   169.793     0.200
    12.871   181.793     0.200
    12.871   181.363     0.200
    12.984   180.293     0.200
    14.904   209.293     0.200
    12.984   183.926     0.200
    12.984   183.770     0.200
    12.984   184.125     0.200
    12.984   184.191     0.200
    12.984   183.906     0.200
    12.984   184.008     0.200
    12.984   183.043     0.200
     6.097    91.223     0.200
     6.097    89.934     0.200
     6.097    89.262     0.200
     6.097    89.102     0.200
     6.097    90.137     0.200
     6.097    89.957     0.200
     6.097    89.719     0.200
     6.097    89.719     0.200
     6.097    89.719     0.200
     6.097    89.719     0.200
     6.097    89.719     0.200
     6.097    89.719     0.200
     6.097    90.051     0.200
     0.852    17.008     0.200
     1.164    23.207     0.200
     1.178    22.008     0.200
     3.001    48.508     0.200
     0.975    19.199     0.200
     1.130    21.492     0.200
     3.568    57.992     0.200
     0.880    17.211     0.200
     0.999    19.312     0.200
     1.131    22.312     0.200
     1.190    23.109     0.200
     2.547    42.109     0.200
     2.614    43.109     0.200
     1.141    22.000     0.200
     1.121    22.496     0.200
     1.172    22.598     0.200
     1.140    23.719     0.200
     1.140    22.320     0.200
     1.187    24.523     0.200
     1.144    22.395     0.200
     1.292    26.180     0.200
     0.815    16.250     0.200
     1.138    23.852     0.200
     1.092    20.689     0.200
     1.166    23.918     0.200
     1.214    23.719     0.200
     1.129    21.398     0.200
     1.145    21.500     0.200
     1.191    23.199     0.200
     1.034    20.031     0.200
     1.283    24.730     0.200
     2.445    40.430     0.200
     2.502    42.230     0.200
     2.636    43.730     0.200
     1.903    34.730     0.200
     2.901    47.629     0.200
     2.857    47.230     0.200
     3.594    56.031     0.200
     0.830    17.082     0.200
     0.949    18.582     0.200
     0.829    16.559     0.200
     1.139    23.160     0.200
     1.189    23.758     0.200
     0.835    16.742     0.200
     0.836    17.156     0.200
     0.969    18.484     0.200
     1.120    21.207     0.200
     1.160    22.105     0.200
     1.198    22.406     0.200
     2.496    40.805     0.200
     2.530    40.906     0.200
     2.597    43.605     0.200
     2.836    44.008     0.200
     3.651    57.508     0.200
     3.766    59.906     0.200
     5.698    83.637     0.200
     7.305   104.758     0.200
     8.726   125.555     0.200
    12.811   178.828     0.200
    12.883   179.906     0.200
    12.907   178.406     0.200
    13.082   182.066     0.200
    13.837   191.895     0.200
     1.075    20.105     0.200
     1.458    26.176     0.200
     2.530    41.406     0.200
     2.769    45.457     0.200
     2.771    44.906     0.200
     2.916    46.707     0.200
     3.046    49.535     0.200
     3.548    56.105     0.200
     4.302    66.836     0.200
     4.493    69.078     0.200
     4.549    69.906     0.200
     5.148    77.734     0.200
     5.698    84.586     0.200
     5.702    84.957     0.200
     5.750    85.516     0.200
     5.972    89.105     0.200
     5.954    88.234     0.200
     6.160    91.805     0.200
     6.172    91.734     0.200
     6.528    96.695     0.200
     6.968   101.406     0.200
     7.182   104.836     0.200
     7.231   105.305     0.200
     7.599   110.508     0.200
     7.842   114.578     0.200
     8.307   124.227     0.200
     8.360   124.645     0.200
     8.400   125.125     0.200
     8.410   126.008     0.200
     8.410   125.266     0.200
     8.412   125.410     0.200
     8.427   125.684     0.200
     8.433   125.746     0.200
     8.460   125.980     0.200
     8.464   126.770     0.200
     8.486   126.316     0.200
     8.675   124.906     0.200
     8.515   125.531     0.200
     8.515   125.371     0.200
     8.513   127.102     0.200
     8.513   126.578     0.200
     8.534   125.621     0.200
     8.534   124.590     0.200
     8.524   126.711     0.200
     8.538   125.723     0.200
     8.538   125.566     0.200
     8.536   125.973     0.200
     8.536   125.727     0.200
     8.531   126.902     0.200
     8.533   126.891     0.200
     8.542   126.148     0.200
     8.542   125.902     0.200
     8.552   127.242     0.200
     8.552   126.648     0.200
     8.558   126.344     0.200
     8.553   127.223     0.200
     8.609   126.484     0.200
     8.609   126.258     0.200
     8.681   127.859     0.200
     8.731   128.266     0.200
     8.905   130.398     0.200
     8.905   129.293     0.200
     8.946   130.895     0.200
     8.946   129.898     0.200
     8.956   130.910     0.200
     8.956   130.520     0.200
     9.090   132.074     0.200
     9.090   131.176     0.200
     9.168   132.871     0.200
     9.168   131.832     0.200
     9.176   132.973     0.200
     9.192   133.168     0.200
     9.240   133.711     0.200
     9.240   133.117     0.200
     9.267   138.609     0.200
     9.304   134.820     0.200
     9.318   134.969     0.200
     9.318   133.812     0.200
     9.557   138.305     0.200
     9.852   138.828     0.200
     9.997   144.156     0.200
     9.997   143.645     0.200
    10.209   147.906     0.200
    10.668   152.879     0.200
    10.668   152.348     0.200
    12.022   168.406     0.200
    12.167   168.906     0.200
    12.811   178.906     0.200
    12.883   180.406     0.200
    13.082   182.066     0.200
    13.025   183.906     0.200
    13.837   191.918     0.200
    13.837   192.426     0.200
    14.964   209.906     0.200
    12.907   183.086     0.200
    12.907   183.438     0.200
    12.907   183.477     0.200
    12.907   182.355     0.200
    12.907   182.355     0.200
    12.907   182.797     0.200
     1.173    22.574     0.200
     3.612    57.875     0.200
     0.964    18.645     0.200
     1.053    20.133     0.200
     1.112    22.145     0.200
     0.822    16.547     0.200
     0.948    19.406     0.200
     1.118    21.195     0.200
     2.583    43.195     0.200
     2.716    45.695     0.200
     3.672    58.195     0.200
     1.148    22.215     0.200
     1.185    22.016     0.200
     2.557    42.516     0.200
     2.690    44.516     0.200
     2.734    45.016     0.200
     4.499    68.816     0.200
     5.725    85.094     0.200
     7.358   105.316     0.200
     9.906   140.016     0.200
    12.859   180.285     0.200
    13.886   192.945     0.200
     2.821    45.977     0.200
     2.947    48.016     0.200
     2.984    49.016     0.200
     3.090    49.977     0.200
     3.503    56.914     0.200
     3.603    57.316     0.200
     4.343    67.406     0.200
     4.539    70.305     0.200
     4.457    70.016     0.200
     4.989    74.016     0.200
     5.188    78.867     0.200
     5.725    86.164     0.200
     5.743    85.625     0.200
     5.789    86.664     0.200
     5.940    88.016     0.200
     5.995    89.906     0.200
     6.115    91.617     0.200
     6.119    91.551     0.200
     6.209    92.664     0.200
     6.565    97.426     0.200
     6.931   100.816     0.200
     7.222   105.285     0.200
     7.188   105.016     0.200
     7.567   110.516     0.200
     7.881   115.527     0.200
     8.294   124.145     0.200
     8.348   124.691     0.200
     8.389   125.004     0.200
     8.406   126.012     0.200
     8.409   125.633     0.200
     8.422   125.633     0.200
     8.423   125.676     0.200
     8.454   125.844     0.200
     8.461   126.852     0.200
     8.480   126.285     0.200
     8.515   126.262     0.200
     8.511   126.996     0.200
     8.534   126.094     0.200
     8.515   126.789     0.200
     8.537   126.348     0.200
     8.535   126.641     0.200
     8.523   126.871     0.200
     8.541   126.727     0.200
     8.527   126.871     0.200
     8.550   127.355     0.200
     8.559   126.727     0.200
     8.545   127.145     0.200
     8.780   126.074     0.200
     8.611   126.367     0.200
     8.683   128.109     0.200
     8.733   128.285     0.200
     8.908   129.809     0.200
     8.950   132.168     0.200
     9.094   131.773     0.200
     9.173   132.336     0.200
     9.182   133.078     0.200
     9.199   133.078     0.200
     9.248   133.891     0.200
     9.278   138.930     0.200
     9.312   134.762     0.200
     9.327   135.176     0.200
     9.496   137.516     0.200
    10.000   145.461     0.200
    10.225   148.016     0.200
    12.221   170.016     0.200
    12.058   169.016     0.200
    12.859   181.016     0.200
    12.859   180.387     0.200
    12.965   180.016     0.200
    13.143   183.215     0.200
    12.964   186.016     0.200
    13.886   192.945     0.200
    14.916   208.516     0.200
    17.626   244.016     0.200
    12.965   183.730     0.200
    12.965   183.730     0.200
     6.119    89.637     0.200
     6.119    89.609     0.200
     6.119    90.062     0.200
     6.119    89.891     0.200
     6.119    89.812     0.200
     6.119    90.004     0.200
     6.119    90.004     0.200
     6.119    90.004     0.200
     1.141    23.344     0.200
     1.135    22.773     0.200
     1.176    24.047     0.200
     1.221    24.750     0.200
     1.133    22.766     0.200
     1.182    23.266     0.200
     1.105    21.727     0.200
     1.260    26.027     0.200
     1.311    25.727     0.200
     1.129    22.545     0.200
     1.064    20.387     0.200
     1.145    22.059     0.200
     1.138    21.859     0.200
     1.186    23.359     0.200
     2.690    44.559     0.200
     3.595    58.059     0.200
     1.171    22.477     0.200
     1.205    24.094     0.200
     1.170    22.762     0.200
     2.562    42.961     0.200
     2.695    44.961     0.200
     3.632    57.461     0.200
     4.528    69.961     0.200
     2.059    36.961     0.200
     2.362    41.660     0.200
     2.792    45.770     0.200
     3.532    56.062     0.200
     3.749    59.762     0.200
     4.510    70.242     0.200
     5.159    78.039     0.200
     5.714    85.520     0.200
     5.760    86.141     0.200
     5.966    89.461     0.200
     6.181    91.562     0.200
     6.148    92.570     0.200
     7.194   105.223     0.200
     6.148    89.848     0.200
     6.148    92.223     0.200
     6.148    90.652     0.200
     6.148    89.621     0.200
     6.148    90.715     0.200
     1.133    21.948     0.200
     1.134    22.348     0.200
     2.541    42.948     0.200
     2.674    44.948     0.200
     3.595    58.448     0.200
     1.134    23.676     0.200
     1.182    23.707     0.200
     2.570    41.907     0.200
     3.644    57.307     0.200
     5.738    85.157     0.200
     1.156    22.852     0.200
     2.565    41.727     0.200
     5.733    87.539     0.200
     1.136    23.141     0.200
     2.555    42.141     0.200
     1.164    23.379     0.200
     2.544    42.879     0.200
     2.677    44.879     0.200
     2.671    44.277     0.200
     2.845    46.977     0.200
     5.707    85.816     0.200
    12.020   169.277     0.200
    12.821   179.316     0.200
    13.846   193.777     0.200
     1.798    32.168     0.200
     2.771    45.207     0.200
     2.925    48.277     0.200
     4.301    65.957     0.200
     4.493    68.379     0.200
     4.745    74.777     0.200
     5.146    78.297     0.200
     5.470    77.777     0.200
     5.701    85.738     0.200
     5.707    85.816     0.200
     5.748    85.438     0.200
     5.953    89.336     0.200
     5.975    89.879     0.200
     6.170    91.738     0.200
     6.160    92.676     0.200
     6.165    91.660     0.200
     6.969   102.676     0.200
     7.181   104.059     0.200
     7.232   108.078     0.200
     7.840   113.676     0.200
     8.012   117.176     0.200
     8.298   124.582     0.200
     8.352   124.637     0.200
     8.392   125.184     0.200
     8.402   125.809     0.200
     8.405   125.371     0.200
     8.419   125.465     0.200
     8.452   125.676     0.200
     8.457   126.828     0.200
     8.478   126.176     0.200
     8.506   127.262     0.200
     8.523   126.773     0.200
     8.526   126.828     0.200
     8.545   127.078     0.200
     9.551   138.176     0.200
    10.204   149.578     0.200
    12.821   177.777     0.200
    12.821   179.316     0.200
    12.915   179.277     0.200
    13.846   193.777     0.200
    12.915   183.227     0.200
     6.165    90.621     0.200
     6.165    90.621     0.200
     6.165    90.621     0.200
     6.165    90.621     0.200
     1.160    24.203     0.200
     1.122    23.484     0.200
     2.680    44.484     0.200
     5.714    87.656     0.200
     1.136    21.566     0.200
     2.538    42.566     0.200
     2.671    44.566     0.200
     5.706    86.426     0.200
     1.136    22.066     0.200
     3.604    57.166     0.200
     4.345    67.416     0.200
     4.539    69.596     0.200
     5.190    78.986     0.200
     5.706    87.137     0.200
     5.745    87.057     0.200
     5.935    88.367     0.200
     5.997    90.307     0.200
     6.115    92.066     0.200
     6.119    91.766     0.200
     6.212    93.057     0.200
     6.569    97.557     0.200
     6.927   102.967     0.200
     7.187   106.367     0.200
     8.425   125.895     0.200
     8.438   125.553     0.200
     2.529    42.475     0.200
     5.697    89.275     0.200
     2.581    41.037     0.200
     3.027    49.438     0.200
     3.062    49.447     0.200
     2.964    45.537     0.200
     3.145    50.537     0.200
     3.402    54.287     0.200
     4.355    66.947     0.200
     4.449    67.637     0.200
     4.651    70.547     0.200
     4.555    70.637     0.200
     5.396    81.037     0.200
     5.627    84.037     0.200
     5.901    88.057     0.200
     6.098    91.037     0.200
     6.744    99.617     0.200
     7.302   107.357     0.200
     7.344   107.037     0.200
     7.552   110.178     0.200
     7.754   112.297     0.200
     7.955   112.727     0.200
     8.113   117.678     0.200
     8.415   122.637     0.200
     8.779   126.297     0.200
     9.433   135.258     0.200
     9.456   135.098     0.200
    10.498   146.537     0.200
    11.381   162.557     0.200
    13.136   185.928     0.200
    13.595   188.037     0.200
    13.757   190.537     0.200
    14.239   194.867     0.200
    14.802   210.037     0.200
    16.076   225.037     0.200
    19.689   269.037     0.200
     2.656    43.022     0.200
     2.769    43.522     0.200
     3.949    61.022     0.200
     4.142    64.623     0.200
     4.989    73.022     0.200
     5.137    77.022     0.200
     6.754    99.822     0.200
     6.759    99.157     0.200
     7.555   109.822     0.200
     7.825   114.822     0.200
     8.571   125.022     0.200
    10.005   140.522     0.200
    11.990   166.022     0.200
    12.639   176.022     0.200
    12.751   180.022     0.200
    12.751   176.672     0.200
     1.213    25.336     0.200
     1.861    33.336     0.200
     2.191    39.336     0.200
     2.470    39.836     0.200
     2.564    41.137     0.200
     2.381    40.936     0.200
     2.625    44.365     0.200
     2.915    48.236     0.200
     2.965    49.166     0.200
     3.922    61.246     0.200
     4.213    65.186     0.200
     4.993    77.336     0.200
     5.465    83.396     0.200
     5.661    86.316     0.200
     5.823    87.535     0.200
     6.065    91.336     0.200
     6.308    94.336     0.200
     6.908   102.156     0.200
     7.116   105.076     0.200
     7.754   113.736     0.200
     7.680   112.695     0.200
     8.343   120.637     0.200
     8.709   129.336     0.200
     9.025   130.455     0.200
    10.305   146.336     0.200
    13.034   180.836     0.200
    13.516   187.336     0.200
    14.117   197.535     0.200
     2.134    37.193     0.200
     2.835    47.693     0.200
     3.077    51.193     0.200
     3.408    56.193     0.200
     7.400   107.174     0.200
    12.985   180.693     0.200
     1.488    28.492     0.200
     1.538    26.752     0.200
     1.788    31.352     0.200
     2.362    40.652     0.200
     2.382    39.852     0.200
     2.535    43.252     0.200
     2.828    47.201     0.200
     3.345    53.352     0.200
     3.522    56.852     0.200
     4.932    76.701     0.200
     5.543    84.852     0.200
     5.729    87.111     0.200
     6.388    95.912     0.200
     6.943   103.451     0.200
     6.989   104.191     0.200
     7.195   106.451     0.200
     7.764   114.572     0.200
     7.692   111.891     0.200
     8.422   122.611     0.200
     9.080   131.852     0.200
     9.112   132.291     0.200
    12.948   182.191     0.200
    13.253   184.852     0.200
    13.467   187.352     0.200
    14.036   195.152     0.200
     2.047    34.391     0.200
     2.530    40.891     0.200
     2.977    48.258     0.200
     3.242    50.789     0.200
     3.430    53.891     0.200
     4.731    70.594     0.200
     4.843    73.289     0.200
     4.848    74.039     0.200
     5.610    84.859     0.200
     5.810    86.820     0.200
     5.685    83.992     0.200
     5.918    86.992     0.200
     6.453    95.844     0.200
     6.353    92.992     0.200
     7.011   103.000     0.200
     7.053   103.141     0.200
     7.261   106.500     0.200
     7.822   113.961     0.200
     7.848   113.594     0.200
     8.488   121.320     0.200
     8.585   125.391     0.200
     9.142   131.078     0.200
     9.165   131.281     0.200
    10.397   147.328     0.200
    11.331   163.188     0.200
    11.975   172.234     0.200
    13.064   180.562     0.200
    13.098   183.391     0.200
    13.305   186.391     0.200
    13.623   188.891     0.200
    14.188   198.391     0.200
    14.784   206.391     0.200
     1.500    29.699     0.200
     1.786    33.309     0.200
     2.125    38.777     0.200
     2.214    38.348     0.200
     2.073    39.000     0.200
     2.381    41.027     0.200
     2.531    42.320     0.200
     2.565    42.199     0.200
     2.484    42.500     0.200
     2.727    45.391     0.200
     2.720    45.199     0.200
     2.975    49.320     0.200
     3.051    51.199     0.200
     3.392    53.629     0.200
     3.450    56.199     0.200
     4.224    66.199     0.200
     4.605    70.598     0.200
     4.810    74.277     0.200
     5.448    82.777     0.200
     5.725    85.969     0.200
     6.006    90.578     0.200
     6.048    91.199     0.200
     6.256    93.777     0.200
     6.820   101.480     0.200
     7.510   108.570     0.200
     7.483   109.520     0.200
     8.138   119.000     0.200
     8.167   118.738     0.200
     8.865   128.199     0.200
     9.251   136.199     0.200
    10.422   151.199     0.200
    12.307   172.199     0.200
    12.966   181.449     0.200
    13.155   182.199     0.200
     1.425    27.096     0.200
     3.191    52.695     0.200
     3.165    50.695     0.200
     3.321    54.045     0.200
     3.402    55.096     0.200
     3.389    55.965     0.200
     3.462    56.195     0.200
     3.485    57.795     0.200
     4.036    63.895     0.200
     4.134    65.195     0.200
     4.591    71.096     0.200
     4.637    71.895     0.200
     4.465    70.195     0.200
     4.701    68.285     0.200
     4.765    70.195     0.200
     4.650    73.395     0.200
     4.843    74.295     0.200
     4.740    73.096     0.200
     5.061    77.596     0.200
     5.416    82.695     0.200
     6.070    90.895     0.200
     6.237    93.166     0.200
     6.723   100.686     0.200
     6.729   100.795     0.200
     6.772   100.996     0.200
     7.200   103.625     0.200
     7.077   104.695     0.200
     7.259   107.895     0.200
     7.264   107.996     0.200
     7.713   112.564     0.200
     8.079   118.195     0.200
     8.338   122.195     0.200
     9.199   136.195     0.200
    10.312   150.695     0.200
    10.913   154.695     0.200
    11.997   168.355     0.200
    12.558   175.195     0.200
    12.863   178.695     0.200
    13.824   194.195     0.200
     2.995    50.438     0.200
     3.342    52.742     0.200
     3.619    58.461     0.200
     3.684    58.836     0.200
     3.875    61.336     0.200
     3.975    63.234     0.200
     4.266    67.234     0.200
     4.530    70.031     0.200
     4.384    66.438     0.200
     5.083    77.133     0.200
     5.133    77.836     0.200
     5.336    80.438     0.200
     5.560    83.336     0.200
     5.920    88.438     0.200
     6.564    96.938     0.200
     6.779   100.633     0.200
     6.783   100.711     0.200
     7.161   102.484     0.200
     7.226   106.531     0.200
     7.272   107.531     0.200
     7.582   111.531     0.200
     7.851   115.836     0.200
     9.688   138.234     0.200
     9.675   142.031     0.200
    10.015   146.438     0.200
    11.413   160.531     0.200
    11.996   168.562     0.200
    12.641   176.234     0.200
    13.551   192.766     0.200
    16.817   234.188     0.200
     1.239    25.777     0.200
     2.181    38.777     0.200
     2.219    38.977     0.200
     2.265    39.477     0.200
     2.394    39.977     0.200
     2.531    44.977     0.200
     3.153    50.125     0.200
     3.537    54.656     0.200
     3.620    58.977     0.200
     5.032    78.172     0.200
     2.277    36.965     0.200
     3.094    50.074     0.200
     3.253    50.465     0.200
     3.409    52.586     0.200
     3.551    55.453     0.200
     3.524    56.766     0.200
     4.635    70.094     0.200
     4.503    68.965     0.200
     6.327    92.203     0.200
     6.783    98.543     0.200
     7.279   102.934     0.200
     7.128   104.363     0.200
     7.291   107.863     0.200
     8.125   118.164     0.200
     8.373   121.863     0.200
     9.126   133.086     0.200
    10.865   153.465     0.200
    12.624   173.965     0.200
    12.947   181.965     0.200
    20.201   274.863     0.200
     1.168    23.029     0.200
     2.840    45.430     0.200
     3.240    52.230     0.200
     3.667    55.990     0.200
     3.670    58.629     0.200
     3.868    60.930     0.200
     3.987    63.430     0.200
     4.220    64.250     0.200
     4.272    68.430     0.200
     4.515    69.529     0.200
     5.001    75.430     0.200
     5.070    76.830     0.200
     5.117    77.529     0.200
     5.322    79.930     0.200
     5.542    83.330     0.200
     5.897    88.430     0.200
     6.549    96.629     0.200
     6.597    97.230     0.200
     6.787   100.930     0.200
     6.886   101.359     0.200
     7.205   103.850     0.200
     7.210   106.029     0.200
     7.599   111.529     0.200
     9.641   140.930     0.200
    11.393   160.430     0.200
    12.039   167.430     0.200
    12.661   176.230     0.200
    12.680   175.430     0.200
    12.680   175.930     0.200
    12.810   177.430     0.200
    12.810   178.680     0.200
    12.933   180.619     0.200
    13.799   191.330     0.200
    14.999   211.629     0.200
    16.778   231.379     0.200
     1.083    22.197     0.200
     1.164    21.397     0.200
     1.867    31.397     0.200
     1.915    32.967     0.200
     2.312    38.557     0.200
     2.456    41.597     0.200
     2.555    41.117     0.200
     2.885    45.367     0.200
     3.310    51.517     0.200
     4.781    71.207     0.200
    13.745   192.650     0.200
    16.646   230.274     0.200
    16.646   229.777     0.200
     2.627    40.808     0.200
     2.798    45.978     0.200
     2.828    46.327     0.200
     3.028    49.067     0.200
     3.193    51.808     0.200
     3.459    54.407     0.200
     3.589    57.008     0.200
     4.047    61.708     0.200
     4.465    68.107     0.200
     4.674    70.407     0.200
     5.307    79.208     0.200
     5.793    87.277     0.200
     5.865    86.508     0.200
     5.907    87.308     0.200
     5.846    86.808     0.200
     5.983    89.607     0.200
     6.115    89.907     0.200
     6.319    93.607     0.200
     6.678    98.308     0.200
     6.823    99.208     0.200
     7.063   102.308     0.200
     7.404   106.628     0.200
     7.342   106.208     0.200
     7.499   106.438     0.200
     7.471   109.508     0.200
     7.897   114.907     0.200
     7.997   115.808     0.200
     8.783   124.208     0.200
     9.330   134.808     0.200
    10.048   142.308     0.200
    10.284   147.308     0.200
    10.284   148.107     0.200
    10.894   156.008     0.200
    11.793   166.718     0.200
    11.905   172.788     0.200
    11.935   169.598     0.200
    12.165   169.308     0.200
    12.363   171.308     0.200
    12.251   173.317     0.200
    12.385   175.588     0.200
    12.553   178.928     0.200
    12.641   178.697     0.200
    12.674   181.048     0.200
    12.981   179.808     0.200
    13.039   182.768     0.200
    12.851   182.737     0.200
    13.119   180.808     0.200
    13.235   188.298     0.200
    14.014   195.708     0.200
    14.341   199.258     0.200
    14.341   199.208     0.200
    14.795   208.808     0.200
    15.589   216.388     0.200
    16.356   227.056     0.200
    16.356   227.038     0.200
    16.356   228.708     0.200
     1.055    20.461     0.200
     1.684    29.461     0.200
     2.012    33.660     0.200
     2.642    43.359     0.200
     2.572    41.461     0.200
     2.785    45.359     0.200
     2.741    45.812     0.200
     3.001    49.160     0.200
     2.975    49.520     0.200
     3.403    54.520     0.200
     3.427    55.461     0.200
     3.547    57.461     0.200
     4.510    69.961     0.200
     4.713    72.859     0.200
     5.353    80.961     0.200
     5.737    86.941     0.200
     5.910    88.461     0.200
     5.792    87.160     0.200
     5.953    88.859     0.200
     5.942    89.461     0.200
     6.161    91.859     0.200
     6.368    94.359     0.200
     6.726    99.562     0.200
     6.773    99.461     0.200
     7.019   102.660     0.200
     7.388   107.859     0.200
     7.417   108.961     0.200
     7.468   109.660     0.200
     8.044   117.359     0.200
     8.784   124.660     0.200
    10.344   150.242     0.200
    10.628   149.961     0.200
    12.215   169.961     0.200
    12.333   171.461     0.200
    12.940   181.461     0.200
    13.098   181.961     0.200
    14.329   199.910     0.200
    16.382   228.285     0.200
    16.382   227.609     0.200
    18.995   261.461     0.200
    16.382   228.945     0.200
     2.030    34.719     0.200
     2.906    47.578     0.200
     3.183    50.617     0.200
     4.158    64.617     0.200
     4.400    69.617     0.200
     4.536    68.820     0.200
     5.127    78.117     0.200
     7.116   104.258     0.200
     7.519   108.477     0.200
     9.339   136.688     0.200
    11.095   158.508     0.200
    12.937   179.617     0.200
    16.532   230.484     0.200
    20.562   281.398     0.200
     1.109    21.969     0.200
     2.926    48.070     0.200
     3.352    52.469     0.200
     3.537    54.297     0.200
     3.548    58.250     0.200
     3.769    59.570     0.200
     4.053    63.867     0.200
     4.173    66.969     0.200
     4.321    68.172     0.200
     4.595    70.570     0.200
     5.162    78.367     0.200
     5.181    78.570     0.200
     5.401    81.867     0.200
     5.486    82.469     0.200
     5.928    88.867     0.200
     6.510    96.312     0.200
     6.678    99.766     0.200
     7.622   111.172     0.200
     7.830   113.969     0.200
     7.803   114.867     0.200
     8.646   126.766     0.200
     8.746   127.266     0.200
     9.072   130.250     0.200
     9.410   137.570     0.200
     9.410   136.797     0.200
     9.031   133.266     0.200
    11.564   163.969     0.200
    13.165   184.969     0.200
    13.434   189.969     0.200
    14.374   203.570     0.200
    14.684   204.391     0.200
    15.929   221.961     0.200
    16.171   224.188     0.200
    16.183   224.594     0.200
     2.736    45.559     0.200
     2.943    47.898     0.200
     3.305    52.348     0.200
     3.358    53.328     0.200
     3.836    59.219     0.200
     5.691    82.348     0.200
    14.233   200.355     0.200
    14.233   199.246     0.200
    16.347   229.199     0.200
    16.347   228.473     0.200
     1.375    23.904     0.200
     1.472    25.504     0.200
     1.883    35.854     0.200
     2.157    40.204     0.200
    14.247   197.954     0.200
    16.265   225.479     0.200
    20.030   272.344     0.200
     1.991    34.336     0.200
     3.083    50.426     0.200
     3.148    52.039     0.200
     3.177    49.738     0.200
     3.351    52.586     0.200
     3.386    53.418     0.200
     3.515    54.797     0.200
     3.567    58.039     0.200
     3.550    57.336     0.200
     3.657    57.227     0.200
     3.721    58.379     0.200
     3.797    59.637     0.200
     4.006    61.906     0.200
     4.123    64.938     0.200
     4.368    66.938     0.200
     4.387    68.039     0.200
     4.503    70.039     0.200
     4.556    69.387     0.200
     4.950    75.539     0.200
     4.983    75.836     0.200
     5.135    73.938     0.200
     5.195    79.039     0.200
     5.386    81.336     0.200
     6.310    92.938     0.200
     6.786    99.738     0.200
     6.893   102.438     0.200
     7.503   108.109     0.200
     7.761   112.238     0.200
     7.984   116.238     0.200
     8.292   119.438     0.200
     8.411   121.539     0.200
     8.832   127.738     0.200
     8.713   129.469     0.200
     9.378   137.438     0.200
    11.227   157.238     0.200
    12.325   173.836     0.200
    12.372   175.578     0.200
    12.452   178.426     0.200
    12.812   178.836     0.200
    12.797   180.789     0.200
    12.931   178.938     0.200
    12.968   183.047     0.200
    13.072   184.668     0.200
    13.127   185.539     0.200
    13.160   188.129     0.200
    13.180   185.379     0.200
    14.109   195.738     0.200
    15.005   208.238     0.200
    15.005   208.238     0.200
    16.537   227.223     0.200
     2.939    46.398     0.200
     3.082    49.068     0.200
     6.857    99.768     0.200
    12.225   170.898     0.200
    15.663   217.684     0.200
    17.250   239.074     0.200
    20.191   276.051     0.200
     2.745    44.404     0.200
     3.228    50.674     0.200
     3.187    51.873     0.200
     3.373    53.703     0.200
     3.475    54.213     0.200
     3.394    53.283     0.200
     3.458    55.463     0.200
     3.837    60.373     0.200
     4.022    62.154     0.200
     4.493    65.674     0.200
     4.390    67.975     0.200
     4.651    68.174     0.200
     4.605    70.523     0.200
     4.643    70.873     0.200
     4.873    74.574     0.200
     4.953    75.174     0.200
     5.225    79.273     0.200
     6.258    91.174     0.200
     7.088   102.424     0.200
     7.488   108.184     0.200
     7.469   109.373     0.200
     7.659   109.754     0.200
     7.659   110.475     0.200
     8.273   119.174     0.200
     8.327   124.953     0.200
     8.544   123.773     0.200
     8.887   128.373     0.200
     9.084   129.805     0.200
     9.074   133.475     0.200
     9.074   132.873     0.200
     9.273   133.475     0.200
    10.726   151.174     0.200
    11.068   155.674     0.200
    11.868   165.674     0.200
    12.174   170.305     0.200
    12.399   173.174     0.200
    12.772   178.174     0.200
    12.951   179.225     0.200
    13.720   190.975     0.200
    13.835   194.873     0.200
    13.835   193.514     0.200
    15.511   217.984     0.200
    17.098   237.373     0.200
    17.562   241.924     0.200
     1.352    26.961     0.200
     2.398    39.461     0.200
     2.613    43.641     0.200
     2.745    46.562     0.200
     3.571    55.852     0.200
    11.112   160.711     0.200
    12.146   175.590     0.200
     1.449    29.943     0.200
     1.994    34.943     0.200
     2.081    35.943     0.200
     2.467    39.943     0.200
     2.489    41.974     0.200
     2.489    42.083     0.200
     2.582    43.184     0.200
     2.832    47.443     0.200
     3.661    56.833     0.200
     3.661    57.184     0.200
     5.092    76.844     0.200
     5.227    80.743     0.200
     5.426    83.344     0.200
     5.550    82.613     0.200
     6.059    90.743     0.200
     6.071    91.443     0.200
     6.301    94.344     0.200
     6.628    98.644     0.200
     6.671    99.243     0.200
     6.716   100.943     0.200
     6.879   102.243     0.200
     7.085   104.743     0.200
     7.154   107.144     0.200
     7.678   112.054     0.200
    10.739   154.943     0.200
    10.951   156.663     0.200
    10.995   159.943     0.200
    10.995   158.983     0.200
    12.156   174.113     0.200
    12.156   173.783     0.200
    13.412   187.943     0.200
    13.753   194.657     0.200
    16.149   225.304     0.200
    16.149   225.193     0.200
     2.703    44.484     0.200
     2.990    49.783     0.200
     3.014    51.193     0.200
     3.362    53.084     0.200
     3.645    54.783     0.200
     3.858    60.494     0.200
     4.200    64.385     0.200
     4.283    68.994     0.200
     4.510    69.494     0.200
     4.401    68.295     0.200
     4.976    75.994     0.200
     5.064    76.994     0.200
     5.113    77.994     0.200
     5.316    80.594     0.200
     5.539    84.395     0.200
     5.893    88.895     0.200
     8.109   118.594     0.200
     9.649   141.033     0.200
    12.780   180.994     0.200
    12.904   180.994     0.200
    13.328   191.764     0.200
    15.095   211.777     0.200
    16.808   235.189     0.200
    16.808   236.318     0.200
     1.329    22.844     0.200
     1.369    22.424     0.200
     1.881    30.844     0.200
     2.152    32.662     0.200
     2.151    35.232     0.200
     2.181    36.723     0.200
     2.519    39.123     0.200
     2.690    42.434     0.200
     2.720    42.834     0.200
     2.921    45.973     0.200
     3.160    49.123     0.200
     3.351    50.973     0.200
     3.450    53.123     0.200
     3.566    54.424     0.200
     3.844    57.094     0.200
     4.303    67.123     0.200
     4.692    69.322     0.200
     5.160    76.623     0.200
     5.340    78.424     0.200
     5.685    84.482     0.200
     5.793    84.123     0.200
     5.896    86.623     0.200
     5.941    87.223     0.200
     5.961    86.723     0.200
     6.147    89.822     0.200
     6.360    92.723     0.200
     6.717    97.822     0.200
     6.780    97.523     0.200
     7.035   100.723     0.200
     7.407   104.213     0.200
     7.419   105.023     0.200
     7.837   113.424     0.200
     8.928   126.062     0.200
     9.383   130.924     0.200
    10.357   148.424     0.200
    10.357   147.623     0.200
    11.181   155.953     0.200
    11.965   171.264     0.200
    11.990   168.812     0.200
    12.272   168.322     0.200
    12.302   172.152     0.200
    12.431   173.883     0.200
    12.608   177.684     0.200
    12.733   181.912     0.200
    12.733   179.611     0.200
    12.733   180.723     0.200
    12.850   181.123     0.200
    12.899   180.504     0.200
    12.880   177.473     0.200
    12.978   182.713     0.200
    13.039   177.623     0.200
    13.258   182.834     0.200
    13.289   187.684     0.200
    14.375   197.580     0.200
    14.375   198.023     0.200
    16.442   226.178     0.200
    16.442   226.398     0.200
     3.188    52.062     0.200
     3.232    49.164     0.200
     3.770    58.664     0.200
     4.162    62.664     0.200
     4.402    66.664     0.200
     4.352    66.562     0.200
     4.916    74.266     0.200
     4.947    74.562     0.200
     5.141    76.164     0.200
     5.160    77.367     0.200
     5.347    79.867     0.200
     5.708    85.062     0.200
     6.364    91.664     0.200
     6.928   100.461     0.200
     7.540   106.906     0.200
     8.122   115.867     0.200
     8.300   117.664     0.200
     8.456   119.867     0.200
     8.879   126.367     0.200
     8.752   131.961     0.200
     9.326   136.062     0.200
     9.326   135.766     0.200
     9.872   141.664     0.200
    11.316   160.664     0.200
    11.910   167.133     0.200
    12.367   174.141     0.200
    12.359   172.664     0.200
    12.450   174.688     0.200
    12.797   180.203     0.200
    12.970   182.273     0.200
    12.957   178.164     0.200
    13.070   186.477     0.200
    13.155   185.906     0.200
    13.155   185.664     0.200
    13.179   184.508     0.200
    13.179   183.352     0.200
    13.304   185.273     0.200
    13.325   187.664     0.200
    13.419   188.805     0.200
    13.441   188.211     0.200
    13.759   193.758     0.200
    14.662   207.664     0.200
    15.014   205.562     0.200
    16.514   226.961     0.200
    16.514   227.188     0.200
    18.291   251.266     0.200
    20.094   274.164     0.200
    20.408   277.867     0.200
     2.056    33.875     0.200
     2.926    45.930     0.200
     2.926    46.367     0.200
     3.245    50.773     0.200
     3.200    51.273     0.200
     3.419    53.914     0.200
     3.455    53.547     0.200
     3.622    57.273     0.200
     3.777    58.344     0.200
     3.762    59.570     0.200
     4.074    61.461     0.200
     4.342    67.477     0.200
     4.412    67.773     0.200
     4.624    69.195     0.200
     4.906    74.773     0.200
     4.936    75.375     0.200
     5.150    78.773     0.200
     5.336    80.977     0.200
     5.697    86.070     0.200
     6.377    92.773     0.200
     6.377    94.203     0.200
     7.139   104.500     0.200
     7.548   108.125     0.200
     8.116   116.961     0.200
     8.761   130.977     0.200
     9.312   136.875     0.200
     9.312   136.477     0.200
     9.874   140.570     0.200
    11.175   157.773     0.200
    11.328   159.773     0.200
    12.366   172.273     0.200
    12.820   179.172     0.200
    12.962   179.773     0.200
    13.178   182.773     0.200
    16.509   227.320     0.200
    20.350   278.273     0.200
    20.403   279.570     0.200
     2.390    40.516     0.200
     2.307    41.066     0.200
     2.855    46.875     0.200
     2.905    48.086     0.200
     2.857    47.936     0.200
     3.074    50.676     0.200
     3.169    51.416     0.200
     3.314    53.266     0.200
     3.174    53.285     0.200
     3.694    58.586     0.200
     4.238    65.535     0.200
     4.153    66.086     0.200
     4.356    67.586     0.200
     4.448    68.086     0.200
     4.907    74.686     0.200
     4.960    75.686     0.200
     5.162    78.186     0.200
     5.391    81.486     0.200
     5.744    86.686     0.200
     5.957    89.205     0.200
     6.725    99.695     0.200
     6.743   100.486     0.200
     7.087   102.926     0.200
     6.960   103.887     0.200
     7.754   113.486     0.200
     7.952   114.807     0.200
     8.030   117.586     0.200
     8.759   126.986     0.200
     9.606   137.125     0.200
    12.530   175.586     0.200
    13.489   191.086     0.200
    15.263   211.660     0.200
    16.910   234.092     0.200
    16.932   234.189     0.200
    20.361   278.186     0.200
     2.617    43.535     0.200
     3.188    49.266     0.200
     3.220    51.346     0.200
     3.286    50.836     0.200
     3.342    51.315     0.200
     3.361    53.065     0.200
     3.361    52.666     0.200
     3.481    53.456     0.200
     3.995    61.466     0.200
     3.995    60.766     0.200
     4.570    66.896     0.200
     4.551    68.865     0.200
     4.551    68.666     0.200
     4.597    68.966     0.200
     4.597    69.166     0.200
     4.802    71.865     0.200
     4.802    71.365     0.200
     5.021    75.166     0.200
     5.021    74.766     0.200
     5.376    80.166     0.200
     6.254    90.246     0.200
     6.702    97.626     0.200
     7.192   102.155     0.200
     7.116   103.266     0.200
     7.300   105.766     0.200
     8.120   116.565     0.200
     8.379   120.865     0.200
     8.743   124.865     0.200
     9.138   130.365     0.200
     9.166   133.565     0.200
     9.166   132.666     0.200
     9.690   136.155     0.200
    10.873   152.766     0.200
    11.110   154.266     0.200
    12.541   172.766     0.200
    13.818   190.365     0.200
    13.652   191.466     0.200
    13.652   191.655     0.200
    16.945   233.141     0.200
    16.945   233.766     0.200
     1.879    32.148     0.200
     2.885    47.309     0.200
     3.050    49.098     0.200
     3.203    51.039     0.200
     3.706    58.648     0.200
     4.268    64.168     0.200
     4.361    67.348     0.200
     4.553    69.848     0.200
     4.914    74.748     0.200
     4.964    75.549     0.200
     5.167    78.049     0.200
     5.393    81.748     0.200
     5.746    86.549     0.200
     5.992    89.508     0.200
     6.767   101.469     0.200
     6.948   103.248     0.200
     7.131   103.539     0.200
     7.750   113.748     0.200
     7.974   115.258     0.200
     8.020   117.848     0.200
     8.369   122.348     0.200
     8.340   126.828     0.200
     9.650   138.148     0.200
     9.529   139.648     0.200
     9.529   139.488     0.200
    11.955   166.408     0.200
    12.573   175.148     0.200
    13.454   188.609     0.200
    16.889   234.498     0.200
    18.664   259.648     0.200
     1.282    23.883     0.200
     2.444    40.562     0.200
     2.659    44.324     0.200
     2.890    47.102     0.200
     3.191    51.164     0.200
     3.559    55.734     0.200
    11.677   167.793     0.200
    16.097   223.816     0.200
     0.958    18.508     0.200
     1.243    24.320     0.200
     1.652    28.922     0.200
     2.181    36.219     0.200
     2.265    36.117     0.200
     2.412    37.320     0.200
     2.628    42.469     0.200
     2.531    41.320     0.200
     2.636    44.117     0.200
     2.857    46.609     0.200
     3.173    50.383     0.200
     4.877    74.320     0.200
     5.030    76.922     0.200
     5.434    81.617     0.200
     5.451    82.258     0.200
     5.624    84.523     0.200
     5.847    86.820     0.200
     6.098    89.922     0.200
     6.278    93.219     0.200
     6.414    92.820     0.200
     6.834   100.117     0.200
     6.879   100.922     0.200
     7.073   103.117     0.200
     7.085   103.422     0.200
     7.295   106.523     0.200
     7.579   108.180     0.200
     7.652   111.719     0.200
     8.313   119.719     0.200
     8.557   123.883     0.200
     8.771   128.617     0.200
     8.970   128.922     0.200
     9.000   129.117     0.200
     9.422   132.938     0.200
     9.817   138.648     0.200
    10.243   144.320     0.200
    10.820   153.773     0.200
    11.209   159.922     0.200
    11.209   159.727     0.200
    12.551   174.609     0.200
    12.954   181.211     0.200
    12.974   180.938     0.200
    13.140   183.320     0.200
    13.453   186.320     0.200
    13.629   190.078     0.200
    13.629   189.617     0.200
    13.932   193.547     0.200
    14.057   195.820     0.200
    14.880   207.820     0.200
    15.892   219.094     0.200
    16.148   223.266     0.200
    16.148   223.320     0.200
    16.148   222.719     0.200
    19.183   263.320     0.200
     1.121    24.359     0.200
     1.504    29.699     0.200
     1.528    27.762     0.200
     2.101    35.961     0.200
     2.222    38.980     0.200
     2.297    39.562     0.200
     2.406    39.961     0.200
     2.518    43.359     0.200
     2.621    44.160     0.200
     2.852    46.949     0.200
     4.911    77.062     0.200
     5.413    81.723     0.200
     5.977    90.961     0.200
    16.131   224.637     0.200
     1.255    24.949     0.200
     1.821    34.879     0.200
     2.115    39.629     0.200
     2.521    45.328     0.200
     3.379    55.129     0.200
     3.497    55.828     0.200
     3.848    59.488     0.200
    10.402   150.820     0.200
    12.360   175.680     0.200
    12.624   179.938     0.200
    16.388   230.129     0.200
     2.646    43.941     0.200
     2.670    44.281     0.200
     2.754    46.230     0.200
     3.085    49.512     0.200
     3.259    52.980     0.200
     3.302    51.449     0.200
     3.580    58.402     0.200
     3.881    62.332     0.200
     4.135    62.832     0.200
     4.543    70.031     0.200
     5.095    77.430     0.200
     5.336    80.832     0.200
     5.348    80.629     0.200
     5.576    84.430     0.200
     5.929    88.930     0.200
     6.575    97.332     0.200
     7.123   102.719     0.200
     7.239   106.629     0.200
     7.288   107.629     0.200
     8.321   125.980     0.200
    10.035   142.531     0.200
    12.608   175.730     0.200
    12.960   183.242     0.200
    13.111   185.180     0.200
    16.850   236.230     0.200
    16.850   235.699     0.200
     2.844    46.617     0.200
     3.015    48.848     0.200
     3.025    49.117     0.200
     3.176    50.668     0.200
     3.670    56.148     0.200
     3.849    61.016     0.200
     4.498    69.719     0.200
     4.778    72.617     0.200
     5.052    77.016     0.200
     5.100    77.918     0.200
     5.292    80.418     0.200
     5.304    80.117     0.200
     5.525    84.117     0.200
     5.880    88.516     0.200
     5.970    88.656     0.200
     6.532    96.516     0.200
     6.805   102.816     0.200
     7.196   103.996     0.200
     7.192   106.418     0.200
     7.236   107.117     0.200
     7.880   116.117     0.200
     9.722   138.309     0.200
     9.628   139.516     0.200
    10.010   143.418     0.200
    10.339   148.496     0.200
    12.667   176.117     0.200
    12.935   183.117     0.200
    13.090   185.586     0.200
    16.792   235.488     0.200
    16.792   233.727     0.200
     1.973    33.027     0.200
     2.212    38.289     0.200
     2.871    46.016     0.200
     3.057    49.988     0.200
     3.126    48.527     0.200
     3.157    51.629     0.200
     3.147    51.527     0.200
     3.460    55.008     0.200
     3.531    56.629     0.200
     3.768    58.828     0.200
     3.768    59.629     0.200
     4.371    67.828     0.200
     4.506    67.879     0.200
     4.932    75.227     0.200
     4.968    75.629     0.200
     5.006    75.527     0.200
     5.166    78.828     0.200
     5.179    78.527     0.200
     5.376    81.027     0.200
     5.376    82.227     0.200
     6.406    94.426     0.200
     6.785    99.027     0.200
     7.056   104.328     0.200
     7.080   104.328     0.200
     7.432   107.988     0.200
     7.767   112.629     0.200
     8.642   130.219     0.200
     9.397   136.828     0.200
     9.950   141.598     0.200
    10.466   148.605     0.200
    11.203   157.527     0.200
    11.220   158.527     0.200
    11.801   167.309     0.200
    12.254   171.539     0.200
    12.433   176.777     0.200
    12.511   176.066     0.200
    12.511   176.637     0.200
    12.750   179.289     0.200
    12.855   181.246     0.200
    12.855   180.926     0.200
    12.860   179.027     0.200
    13.023   182.266     0.200
    13.058   183.129     0.200
    13.131   188.887     0.200
    13.220   186.918     0.200
    13.238   185.758     0.200
    13.218   185.527     0.200
    13.474   191.027     0.200
    13.474   190.059     0.200
    13.502   193.789     0.200
    13.819   195.906     0.200
    14.769   207.527     0.200
    16.607   229.789     0.200
    16.607   228.527     0.200
    20.474   279.926     0.200
    20.564   280.867     0.200
     1.159    24.980     0.200
     3.754    60.340     0.200
    11.992   170.574     0.200
    16.095   224.312     0.200
     2.778    46.445     0.200
     3.105    49.844     0.200
     3.206    52.641     0.200
     3.405    56.141     0.200
     4.052    63.445     0.200
     4.340    69.352     0.200
     4.605    71.641     0.200
     4.654    71.945     0.200
     4.845    75.641     0.200
     4.858    74.547     0.200
     5.083    78.242     0.200
     5.436    82.844     0.200
     6.085    91.141     0.200
     6.747   100.445     0.200
     6.795   101.445     0.200
     7.252   108.242     0.200
     7.700   110.688     0.200
     8.060   118.742     0.200
     8.327   122.547     0.200
    16.980   238.180     0.200
     2.646    44.002     0.200
     2.858    47.332     0.200
     3.228    51.031     0.200
     3.474    55.152     0.200
     3.779    58.072     0.200
     3.796    59.902     0.200
     3.970    62.102     0.200
     4.290    65.002     0.200
     4.664    70.002     0.200
     5.193    78.201     0.200
     5.247    78.902     0.200
     5.435    81.303     0.200
     5.448    81.502     0.200
     5.680    85.002     0.200
     6.032    89.902     0.200
     6.684    99.803     0.200
     6.674    98.002     0.200
     6.808   100.291     0.200
     7.340   107.402     0.200
     7.394   108.701     0.200
     7.750   114.102     0.200
     8.448   120.592     0.200
     8.264   124.422     0.200
     9.606   136.541     0.200
     9.819   142.303     0.200
    10.012   140.502     0.200
    10.204   146.432     0.200
    12.583   175.002     0.200
    12.659   177.002     0.200
    13.324   187.922     0.200
    13.337   190.033     0.200
    13.337   190.473     0.200
    13.543   193.053     0.200
    15.061   209.281     0.200
    15.061   209.082     0.200
    15.139   216.102     0.200
    16.874   236.160     0.200
    16.874   236.562     0.200
    16.874   235.053     0.200
    16.874   233.678     0.200
    18.877   263.102     0.200
    20.618   280.053     0.200
    20.627   280.502     0.200
     3.383    55.150     0.200
     4.251    68.270     0.200
     4.724    70.150     0.200
     7.156   102.061     0.200
     7.162   104.850     0.200
     8.237   118.650     0.200
    12.543   172.650     0.200
    15.388   213.121     0.200
    16.931   234.311     0.200
    16.931   234.281     0.200
     2.724    45.273     0.200
     2.826    46.164     0.200
     3.036    51.164     0.200
     3.156    49.625     0.200
     3.359    52.164     0.200
     3.643    58.266     0.200
     3.652    55.965     0.200
     3.836    60.465     0.200
     3.908    62.242     0.200
     4.015    64.664     0.200
     4.208    63.766     0.200
     4.305    68.164     0.200
     4.489    69.266     0.200
     5.042    76.465     0.200
     5.091    77.164     0.200
     5.283    79.562     0.200
     5.295    79.766     0.200
     5.295    79.562     0.200
     5.518    82.863     0.200
     5.872    88.266     0.200
     5.950    87.164     0.200
     6.522    95.965     0.200
     6.619    96.465     0.200
     6.818   101.465     0.200
     7.167   103.723     0.200
     7.184   105.266     0.200
     7.230   106.266     0.200
     7.891   115.465     0.200
     8.101   116.723     0.200
     8.369   127.086     0.200
     9.633   140.766     0.200
    10.036   142.062     0.200
    11.371   161.164     0.200
    12.617   176.004     0.200
    12.638   174.164     0.200
    12.775   179.164     0.200
    13.348   188.965     0.200
    13.347   187.664     0.200
    13.347   188.508     0.200
    13.573   192.965     0.200
    13.763   190.363     0.200
    15.116   209.766     0.200
    15.116   209.863     0.200
    16.821   234.164     0.200
    16.821   233.113     0.200
    19.905   271.664     0.200
     1.363    23.562     0.200
     1.924    30.102     0.200
     1.812    29.961     0.200
     2.044    34.312     0.200
     2.127    34.941     0.200
     2.348    38.742     0.200
     2.715    43.852     0.200
     3.113    48.684     0.200
     5.106    76.863     0.200
     5.271    79.363     0.200
     5.433    81.664     0.200
     5.981    89.062     0.200
     6.136    90.863     0.200
     6.466    94.664     0.200
     6.525    95.863     0.200
     6.587    97.164     0.200
     6.770    99.363     0.200
     6.783    99.262     0.200
     7.028   102.363     0.200
     7.378   107.562     0.200
     8.007   115.262     0.200
     8.680   124.762     0.200
     8.743   125.461     0.200
     8.900   128.723     0.200
    10.430   150.402     0.200
    11.128   159.531     0.200
    11.516   161.879     0.200
    12.657   181.945     0.200
    12.657   181.031     0.200
    12.657   180.602     0.200
    12.750   182.527     0.200
    12.861   179.414     0.200
    12.862   178.562     0.200
    12.832   182.781     0.200
    12.999   183.109     0.200
    14.193   197.539     0.200
    14.193   197.074     0.200
    16.717   230.086     0.200
    16.717   230.773     0.200
    16.717   230.664     0.200
    18.465   255.133     0.200
     1.251    25.879     0.200
     2.080    34.279     0.200
     2.591    41.279     0.200
     2.715    45.479     0.200
     3.038    49.148     0.200
     3.611    55.709     0.200
     4.483    67.580     0.200
     4.583    70.379     0.200
     5.428    80.479     0.200
     6.070    89.979     0.200
     6.715    98.180     0.200
     7.272   105.680     0.200
     7.314   106.080     0.200
     7.510   109.080     0.200
     7.522   109.180     0.200
     7.723   111.379     0.200
     7.959   114.750     0.200
     8.083   116.680     0.200
     8.120   117.279     0.200
     8.418   120.279     0.200
     8.750   125.080     0.200
     9.403   134.080     0.200
     9.425   133.879     0.200
     9.460   137.080     0.200
    10.267   143.529     0.200
    10.582   148.779     0.200
    11.035   158.590     0.200
    11.306   161.689     0.200
    11.387   161.930     0.200
    11.647   166.580     0.200
    11.706   165.723     0.200
    11.706   166.879     0.200
    11.706   167.109     0.200
    11.815   170.109     0.200
    11.873   169.680     0.200
    11.874   168.479     0.200
    12.030   168.779     0.200
    12.152   173.080     0.200
    13.149   184.479     0.200
    13.220   184.080     0.200
    13.220   184.279     0.200
    13.757   191.219     0.200
    13.759   190.279     0.200
    13.848   194.410     0.200
    14.662   202.010     0.200
    14.783   210.279     0.200
    15.620   218.500     0.200
    15.900   222.299     0.200
    15.921   222.779     0.200
    15.921   221.080     0.200
    16.167   223.740     0.200
    16.210   223.979     0.200
    16.735   230.750     0.200
    17.482   241.840     0.200
    19.033   261.639     0.200
     3.087    49.008     0.200
     3.399    54.430     0.200
     3.475    54.430     0.200
     4.126    63.227     0.200
     4.270    65.672     0.200
     4.679    70.125     0.200
     4.666    69.828     0.200
     4.729    71.328     0.200
     4.920    73.531     0.200
     4.932    73.930     0.200
     5.159    77.125     0.200
     6.159    90.328     0.200
     6.114    89.828     0.200
     6.822    99.531     0.200
     6.872   100.328     0.200
     6.976   102.227     0.200
     7.115   101.656     0.200
     7.181   104.227     0.200
     7.759   110.352     0.200
     7.985   115.031     0.200
     8.254   119.328     0.200
     9.321   135.227     0.200
     9.321   135.125     0.200
    10.309   145.430     0.200
    10.309   143.727     0.200
    10.713   152.125     0.200
    11.012   154.227     0.200
    10.998   153.430     0.200
    11.043   152.938     0.200
    11.774   163.477     0.200
    12.243   168.930     0.200
    12.368   172.055     0.200
    12.499   172.766     0.200
    12.501   173.391     0.200
    12.597   176.289     0.200
    12.769   177.789     0.200
    13.281   183.891     0.200
    13.602   191.531     0.200
    13.618   192.727     0.200
    13.765   189.000     0.200
    13.852   195.625     0.200
    13.953   192.719     0.200
    14.396   196.977     0.200
    15.090   212.727     0.200
    15.123   207.219     0.200
    15.423   213.625     0.200
    16.051   220.648     0.200
    16.950   234.375     0.200
    16.973   235.328     0.200
    16.973   232.906     0.200
    16.973   234.930     0.200
    16.973   234.180     0.200
    18.202   249.195     0.200
    18.553   257.328     0.200
    18.754   259.234     0.200
    19.740   270.328     0.200
     2.889    45.999     0.200
     3.018    47.809     0.200
     3.073    50.318     0.200
     3.115    50.019     0.200
     3.242    51.469     0.200
     3.387    55.809     0.200
     3.390    53.429     0.200
     3.485    55.309     0.200
     4.140    64.108     0.200
     4.259    66.509     0.200
     4.400    66.828     0.200
     4.655    73.809     0.200
     4.692    71.309     0.200
     4.743    72.108     0.200
     4.933    74.509     0.200
     4.946    74.709     0.200
     5.174    78.309     0.200
     6.173    91.108     0.200
     6.836   100.509     0.200
     6.887   101.509     0.200
     7.170   105.108     0.200
     7.971   115.709     0.200
     8.242   120.509     0.200
     8.323   126.089     0.200
     9.340   135.509     0.200
     9.340   136.709     0.200
    10.310   145.908     0.200
    10.988   154.459     0.200
    11.032   153.639     0.200
    11.027   154.809     0.200
    11.772   164.349     0.200
    12.230   170.009     0.200
    12.488   173.158     0.200
    12.490   173.309     0.200
    12.490   173.849     0.200
    12.591   176.618     0.200
    12.752   179.229     0.200
    13.271   184.108     0.200
    13.605   192.608     0.200
    13.755   190.438     0.200
    13.944   194.519     0.200
    14.386   198.339     0.200
    15.111   208.698     0.200
    15.421   214.608     0.200
    16.043   223.238     0.200
    16.983   236.658     0.200
    18.498   257.479     0.200
    18.738   260.868     0.200
    20.003   273.769     0.200
    20.172   277.309     0.200
    20.360   278.028     0.200
    20.603   281.009     0.200
    20.817   283.009     0.200
     2.115    34.570     0.200
     2.910    43.031     0.200
     3.040    46.828     0.200
     3.096    47.172     0.200
     3.096    47.281     0.200
     3.195    48.609     0.200
     3.270    50.531     0.200
     3.404    51.719     0.200
     3.409    52.828     0.200
     3.464    52.930     0.200
     3.849    56.117     0.200
     4.117    61.531     0.200
     4.281    62.867     0.200
     4.422    64.336     0.200
     4.669    68.727     0.200
     4.720    69.531     0.200
     4.676    69.828     0.200
     4.910    71.930     0.200
     4.923    72.031     0.200
     5.150    75.625     0.200
     6.150    88.531     0.200
     6.813    97.828     0.200
     6.863    98.531     0.200
     6.984    99.031     0.200
     7.108   100.188     0.200
     7.747   109.047     0.200
     8.264   116.625     0.200
     8.332   123.336     0.200
     9.315   132.727     0.200
    10.988   152.258     0.200
    11.034   151.258     0.200
    11.003   152.828     0.200
    11.762   160.617     0.200
    11.913   164.828     0.200
    12.235   167.758     0.200
    12.489   171.156     0.200
    12.491   170.328     0.200
    12.586   173.211     0.200
    12.762   175.930     0.200
    13.614   189.031     0.200
    13.755   187.328     0.200
    13.777   191.828     0.200
    13.942   190.828     0.200
    13.864   194.328     0.200
    14.386   195.859     0.200
    15.114   205.328     0.200
    15.098   211.031     0.200
    16.041   219.320     0.200
    16.983   231.078     0.200
    18.752   256.102     0.200
    18.762   257.656     0.200
    19.729   267.227     0.200
    20.026   271.258     0.200
     2.437    40.392     0.200
     2.526    43.491     0.200
     2.728    44.231     0.200
     2.668    44.591     0.200
     3.217    49.941     0.200
     3.557    56.461     0.200
     3.898    59.741     0.200
     4.022    63.191     0.200
     3.957    63.991     0.200
     4.195    64.892     0.200
     4.869    74.392     0.200
     5.419    81.691     0.200
     5.473    82.392     0.200
     5.661    84.691     0.200
     5.674    84.991     0.200
     5.905    89.392     0.200
     6.460    96.791     0.200
     6.901   101.491     0.200
     7.109   102.771     0.200
     7.241   106.392     0.200
     7.566   110.892     0.200
     7.524   111.091     0.200
     7.618   112.291     0.200
    10.020   146.161     0.200
    11.199   157.481     0.200
    11.079   160.906     0.200
    11.758   166.352     0.200
    12.233   173.161     0.200
    12.291   171.621     0.200
    12.664   176.481     0.200
    12.666   175.491     0.200
    12.666   175.991     0.200
    12.660   177.991     0.200
    12.926   180.531     0.200
    13.168   188.893     0.200
    13.490   187.852     0.200
    13.381   189.961     0.200
    13.954   194.341     0.200
    14.196   197.722     0.200
    14.590   202.701     0.200
    15.240   211.481     0.200
    16.284   227.921     0.200
    16.794   233.932     0.200
    16.794   232.666     0.200
     2.497    39.518     0.200
     2.490    43.418     0.200
     2.661    44.479     0.200
     2.700    45.238     0.200
     2.905    48.197     0.200
     2.959    50.238     0.200
     3.326    52.979     0.200
     3.810    58.738     0.200
     4.156    63.818     0.200
     4.786    73.719     0.200
     5.434    82.518     0.200
     5.989    89.918     0.200
     6.035    90.518     0.200
     6.228    93.617     0.200
     6.453    95.918     0.200
     6.687   100.018     0.200
     7.468   109.418     0.200
     8.126   118.617     0.200
     8.160   118.719     0.200
    12.627   179.688     0.200
    16.407   230.613     0.200
     2.506    41.395     0.200
     3.109    47.762     0.200
     3.133    50.395     0.200
     3.254    48.793     0.200
     3.397    52.613     0.200
     3.397    53.613     0.200
     3.437    53.422     0.200
     3.437    54.422     0.200
     3.427    54.883     0.200
     3.485    54.414     0.200
     3.523    54.734     0.200
     3.523    55.734     0.200
     3.742    59.895     0.200
     3.785    59.094     0.200
     3.849    59.715     0.200
     4.045    61.723     0.200
     4.337    66.492     0.200
     4.393    66.293     0.200
     4.389    67.191     0.200
     4.578    69.492     0.200
     4.630    70.543     0.200
     4.612    71.113     0.200
     4.823    73.293     0.200
     5.128    77.094     0.200
     5.818    86.293     0.200
     6.482    95.594     0.200
     6.537    95.992     0.200
     7.071   101.133     0.200
     7.311   105.691     0.200
     7.434   107.184     0.200
     7.523   109.691     0.200
     8.325   119.594     0.200
     8.597   122.992     0.200
     9.036   132.191     0.200
     9.036   131.992     0.200
     9.112   130.352     0.200
    10.676   150.043     0.200
    10.852   152.895     0.200
    10.923   151.773     0.200
    11.055   156.793     0.200
    11.518   160.234     0.200
    11.907   167.191     0.200
    12.129   168.742     0.200
    12.163   168.172     0.200
    12.367   170.652     0.200
    12.369   170.293     0.200
    12.369   171.672     0.200
    12.394   170.781     0.200
    12.760   177.441     0.200
    13.495   190.473     0.200
    13.517   190.094     0.200
    13.621   187.043     0.200
    13.664   191.293     0.200
    13.785   189.645     0.200
    13.786   194.555     0.200
    13.854   195.691     0.200
    13.854   194.832     0.200
    13.884   193.938     0.200
    13.884   194.594     0.200
    13.884   194.191     0.200
    13.909   195.973     0.200
    14.029   197.293     0.200
    14.126   198.395     0.200
    14.249   194.805     0.200
    15.010   204.812     0.200
    15.159   211.992     0.200
    15.494   211.254     0.200
    15.720   217.395     0.200
    15.887   217.594     0.200
    17.110   235.965     0.200
    17.132   236.691     0.200
    17.133   237.793     0.200
    17.133   237.191     0.200
    17.133   237.793     0.200
    18.031   248.242     0.200
    18.425   255.992     0.200
    19.201   263.395     0.200
    19.397   265.492     0.200
    19.765   269.992     0.200
    19.769   269.895     0.200
    19.978   272.492     0.200
    19.978   272.043     0.200
    20.462   277.594     0.200
    20.772   283.117     0.200
    20.809   282.418     0.200
     2.903    48.312     0.200
     3.151    50.438     0.200
     3.116    50.703     0.200
     3.415    55.445     0.200
     3.688    57.617     0.200
     3.768    59.734     0.200
     3.821    61.734     0.200
     4.033    61.312     0.200
     4.012    63.227     0.200
     4.156    64.734     0.200
     4.356    66.938     0.200
     4.584    69.125     0.200
     4.919    74.938     0.200
     4.951    74.734     0.200
     5.151    78.234     0.200
     5.353    80.234     0.200
     6.820    99.531     0.200
     6.925   102.336     0.200
     7.512   108.031     0.200
     7.794   112.633     0.200
     8.115   116.391     0.200
     8.016   116.031     0.200
     9.344   136.531     0.200
     9.344   136.133     0.200
    10.486   149.531     0.200
    11.211   160.422     0.200
    11.432   160.258     0.200
    11.471   159.617     0.200
    12.201   171.633     0.200
    12.655   174.945     0.200
    12.801   179.055     0.200
    12.757   177.680     0.200
    12.930   179.953     0.200
    12.931   179.734     0.200
    13.036   180.797     0.200
    13.140   180.734     0.200
    13.140   183.641     0.200
    13.026   183.461     0.200
    13.026   181.938     0.200
    13.172   187.617     0.200
    13.172   186.195     0.200
    13.184   187.438     0.200
    13.195   186.305     0.200
    13.195   186.656     0.200
    13.195   187.438     0.200
    13.341   189.734     0.200
    13.716   190.281     0.200
    13.717   191.492     0.200
    14.198   196.445     0.200
    14.390   199.445     0.200
    14.830   204.141     0.200
    14.689   208.031     0.200
    15.924   221.258     0.200
    16.489   230.055     0.200
    16.538   229.562     0.200
    18.319   253.938     0.200
    19.762   270.438     0.200
    19.998   274.336     0.200
    20.346   277.234     0.200
    20.350   277.133     0.200
    20.430   278.336     0.200
    20.433   278.938     0.200
    20.631   281.234     0.200
    20.648   281.531     0.200
     2.481    41.691     0.200
     2.497    41.520     0.200
     3.223    49.812     0.200
     3.586    55.691     0.200
     4.753    71.590     0.200
     4.882    73.293     0.200
     5.713    85.492     0.200
     5.953    88.590     0.200
    16.055   224.117     0.200
     1.112    21.561     0.200
     1.368    24.820     0.200
     2.632    44.420     0.200
     2.868    46.420     0.200
     3.200    51.420     0.200
     3.445    54.520     0.200
     3.938    60.000     0.200
     4.036    62.119     0.200
     4.664    71.420     0.200
     5.300    79.920     0.200
     5.858    87.920     0.200
     5.849    87.520     0.200
     5.900    88.619     0.200
     5.992    90.221     0.200
     6.095    90.920     0.200
     6.313    94.221     0.200
     6.828   100.221     0.200
     7.071   103.420     0.200
     7.335   107.619     0.200
     7.480   106.570     0.200
     8.920   126.410     0.200
     9.348   132.221     0.200
     9.535   136.221     0.200
    10.284   149.721     0.200
    10.284   149.320     0.200
    11.612   161.090     0.200
    11.649   161.881     0.200
    12.159   171.420     0.200
    12.659   178.539     0.200
    12.659   179.463     0.200
    12.659   179.689     0.200
    12.676   176.340     0.200
    12.692   181.389     0.200
    12.692   180.520     0.200
    12.748   176.900     0.200
    12.815   180.420     0.200
    12.868   182.619     0.200
    12.963   180.430     0.200
    13.099   181.529     0.200
    13.100   183.420     0.200
    13.100   181.580     0.200
    13.098   183.555     0.200
    13.415   185.350     0.200
    13.940   193.250     0.200
    14.357   199.719     0.200
    14.357   199.721     0.200
    14.397   199.660     0.200
    14.658   202.900     0.200
    14.813   210.221     0.200
    15.034   207.631     0.200
    16.353   227.900     0.200
    16.357   226.020     0.200
    16.375   227.611     0.200
    16.375   227.420     0.200
    16.375   227.199     0.200
    16.375   227.195     0.200
    16.375   227.600     0.200
    18.946   263.520     0.200
    18.982   261.596     0.200
    19.818   271.971     0.200
     1.154    22.240     0.200
     2.426    41.240     0.200
     3.184    50.570     0.200
     5.584    83.500     0.200
     6.199    93.340     0.200
     6.612    96.891     0.200
     6.850   100.840     0.200
     7.218   105.641     0.200
    17.234   240.861     0.200
     1.650    29.703     0.200
     2.110    37.727     0.200
     2.200    37.797     0.200
     2.285    37.398     0.200
     2.458    41.500     0.200
     2.620    43.898     0.200
     4.878    74.703     0.200
     5.009    76.203     0.200
     5.444    82.500     0.200
     5.639    85.102     0.200
     5.843    87.898     0.200
     6.086    91.102     0.200
     6.287    94.500     0.200
     6.888   102.000     0.200
     7.082   104.797     0.200
     7.660   112.797     0.200
     7.737   112.367     0.200
     7.922   116.750     0.200
     8.322   120.500     0.200
     8.547   124.297     0.200
     8.730   125.703     0.200
     8.978   129.797     0.200
     9.005   130.203     0.200
     9.840   140.047     0.200
     9.821   142.148     0.200
     9.821   142.500     0.200
    10.859   156.047     0.200
    11.200   160.398     0.200
    11.200   160.500     0.200
    11.346   163.711     0.200
    11.369   164.852     0.200
    11.631   167.219     0.200
    11.727   168.852     0.200
    11.961   172.203     0.200
    12.028   172.867     0.200
    12.028   171.430     0.200
    12.028   172.508     0.200
    12.028   173.172     0.200
    12.097   168.703     0.200
    12.116   173.344     0.200
    12.168   171.617     0.200
    12.175   171.672     0.200
    12.193   176.000     0.200
    12.200   172.453     0.200
    12.208   175.195     0.200
    12.208   172.250     0.200
    12.207   174.891     0.200
    12.290   173.461     0.200
    12.328   176.547     0.200
    12.371   176.070     0.200
    12.371   176.500     0.200
    12.384   175.570     0.200
    12.634   180.359     0.200
    12.935   179.867     0.200
    12.962   183.094     0.200
    13.020   183.477     0.200
    12.989   183.062     0.200
    13.145   185.031     0.200
    13.122   185.047     0.200
    13.495   186.844     0.200
    13.497   187.500     0.200
    13.497   186.992     0.200
    13.593   190.953     0.200
    13.593   190.703     0.200
    13.998   194.609     0.200
    14.383   199.039     0.200
    14.815   205.742     0.200
    14.835   209.102     0.200
    15.138   211.500     0.200
    15.456   212.867     0.200
    16.071   223.469     0.200
    16.071   222.898     0.200
    16.080   222.789     0.200
    16.102   224.086     0.200
    16.102   223.531     0.200
    16.102   223.969     0.200
    16.102   223.977     0.200
    16.102   223.703     0.200
    17.200   238.250     0.200
    17.996   248.602     0.200
     2.755    44.545     0.200
     3.168    50.344     0.200
     3.180    50.744     0.200
     3.203    51.283     0.200
     3.380    53.244     0.200
     3.474    54.225     0.200
     4.013    61.443     0.200
     4.370    66.834     0.200
     4.569    69.145     0.200
     4.562    67.885     0.200
     4.614    69.344     0.200
     4.807    72.344     0.200
     5.038    75.244     0.200
     5.393    80.545     0.200
     6.047    88.545     0.200
     6.707    97.943     0.200
     6.750    98.844     0.200
     7.099   102.443     0.200
     7.198   102.234     0.200
     7.282   105.443     0.200
     7.692   109.754     0.200
     8.102   116.443     0.200
     8.361   120.545     0.200
     8.428   123.795     0.200
     9.179   133.045     0.200
     9.653   135.064     0.200
    10.329   145.244     0.200
    10.474   146.934     0.200
    10.822   154.193     0.200
    10.890   152.264     0.200
    10.890   152.434     0.200
    11.042   152.584     0.200
    11.098   153.385     0.200
    11.246   157.125     0.200
    12.549   172.895     0.200
    12.551   172.744     0.200
    12.551   173.023     0.200
    12.614   173.443     0.200
    12.664   179.545     0.200
    12.864   179.424     0.200
    13.341   185.395     0.200
    13.636   191.988     0.200
    13.636   191.545     0.200
    13.810   189.514     0.200
    13.987   192.193     0.200
    15.013   212.744     0.200
    15.181   207.254     0.200
    15.464   214.443     0.200
    15.464   214.715     0.200
    16.088   220.094     0.200
    16.911   233.084     0.200
    16.934   234.885     0.200
    16.934   235.420     0.200
    16.934   234.885     0.200
    20.003   272.443     0.200
    20.009   273.045     0.200
    20.213   274.145     0.200
    20.204   274.545     0.200
    20.442   277.744     0.200
     1.076    19.883     0.200
     2.430    39.023     0.200
     4.882    73.223     0.200
     4.995    75.625     0.200
     5.141    78.523     0.200
     5.146    78.223     0.200
     5.318    79.824     0.200
     5.512    81.922     0.200
     5.965    89.023     0.200
     6.162    91.422     0.200
     6.212    91.625     0.200
     6.719    99.125     0.200
     6.763    99.324     0.200
     6.957   101.523     0.200
     6.970   102.125     0.200
     7.178   104.723     0.200
     7.536   110.023     0.200
     7.674   110.695     0.200
     8.197   117.625     0.200
     8.673   126.023     0.200
     8.824   128.523     0.200
     8.854   127.324     0.200
     8.883   127.922     0.200
     9.715   137.324     0.200
     9.929   145.402     0.200
    10.690   152.543     0.200
    10.884   154.465     0.200
    11.024   157.023     0.200
    11.093   158.332     0.200
    11.253   160.402     0.200
    11.440   163.672     0.200
    11.564   163.074     0.200
    11.728   165.844     0.200
    11.798   164.773     0.200
    11.828   169.293     0.200
    12.055   173.305     0.200
    12.125   172.145     0.200
    12.125   171.727     0.200
    12.125   172.023     0.200
    12.207   173.047     0.200
    12.207   173.223     0.200
    12.219   173.133     0.200
    12.289   175.023     0.200
    12.290   176.152     0.200
    12.307   176.492     0.200
    12.438   176.016     0.200
    12.490   175.633     0.200
    12.983   180.613     0.200
    13.023   182.824     0.200
    13.023   181.402     0.200
    13.338   186.734     0.200
    13.421   186.023     0.200
    13.421   186.934     0.200
    13.704   191.297     0.200
    13.704   191.742     0.200
    13.704   191.594     0.200
    13.864   193.434     0.200
    13.912   194.414     0.200
    13.925   195.262     0.200
    14.505   201.484     0.200
    14.770   208.145     0.200
    14.855   209.324     0.200
    14.876   206.715     0.200
    15.020   209.723     0.200
    15.489   215.453     0.200
    15.663   217.543     0.200
    16.136   223.953     0.200
    16.158   223.590     0.200
    16.158   224.332     0.200
    16.158   223.824     0.200
    16.158   223.828     0.200
    16.158   224.445     0.200
    16.158   224.223     0.200
    18.121   250.047     0.200
    18.121   249.195     0.200
    19.436   266.523     0.200
     2.439    40.496     0.200
     4.875    72.797     0.200
     5.005    74.598     0.200
     5.018    76.195     0.200
     5.442    81.195     0.200
     5.635    83.695     0.200
     5.842    85.996     0.200
     6.088    89.496     0.200
     6.842    99.895     0.200
     6.886   100.695     0.200
     7.081   103.297     0.200
     7.093   103.496     0.200
     7.301   106.098     0.200
     7.659   111.195     0.200
     7.907   114.438     0.200
     8.321   119.195     0.200
     8.549   121.855     0.200
     8.745   124.195     0.200
     8.977   128.496     0.200
     9.834   141.586     0.200
     9.834   140.895     0.200
    10.336   146.055     0.200
    10.616   151.965     0.200
    10.760   152.055     0.200
    10.918   155.055     0.200
    11.206   159.074     0.200
    11.190   158.145     0.200
    11.362   162.125     0.200
    11.507   162.227     0.200
    11.646   165.895     0.200
    11.741   167.555     0.200
    11.976   170.715     0.200
    12.044   168.715     0.200
    12.044   170.965     0.200
    12.044   170.609     0.200
    12.044   171.598     0.200
    12.132   173.535     0.200
    12.132   172.949     0.200
    12.132   171.695     0.200
    12.208   172.496     0.200
    12.225   174.004     0.200
    12.222   173.805     0.200
    12.343   175.016     0.200
    12.389   175.078     0.200
    12.389   174.598     0.200
    12.398   174.113     0.200
    12.398   174.598     0.200
    12.649   178.438     0.200
    13.146   181.785     0.200
    13.146   182.227     0.200
    13.480   186.496     0.200
    13.606   189.156     0.200
    13.606   189.824     0.200
    13.606   189.598     0.200
    13.606   189.016     0.200
    14.854   207.598     0.200
    14.854   208.137     0.200
    16.089   221.348     0.200
    16.089   221.160     0.200
    16.089   221.496     0.200
    16.099   222.457     0.200
    16.120   222.418     0.200
    16.120   222.941     0.200
    16.120   222.945     0.200
    16.120   222.598     0.200
    16.120   222.941     0.200
    17.851   246.195     0.200
    17.998   247.340     0.200
    17.998   246.977     0.200
    19.077   262.086     0.200
    19.499   266.297     0.200
    19.959   271.297     0.200
     2.459    38.602     0.200
     2.606    41.633     0.200
     2.668    43.258     0.200
     2.882    44.945     0.200
     3.276    50.211     0.200
     3.735    56.750     0.200
     4.397    66.000     0.200
     4.830    73.500     0.200
     5.026    75.602     0.200
     5.470    83.203     0.200
     5.627    85.102     0.200
     6.230    92.398     0.200
     6.275    92.602     0.200
     6.469    95.203     0.200
     6.481    95.500     0.200
     6.449    95.305     0.200
     6.691    97.805     0.200
     6.700    99.398     0.200
     7.049   103.203     0.200
     7.536   107.711     0.200
     7.709   111.000     0.200
     8.366   120.805     0.200
    12.453   174.969     0.200
    16.314   223.375     0.200
     1.005    19.773     0.200
     2.546    42.766     0.200
     2.976    50.398     0.200
     3.491    57.266     0.200
    12.610   179.383     0.200
    16.373   228.219     0.200
     1.681    30.814     0.200
     2.590    44.204     0.200
     3.740    58.895     0.200
     3.794    60.255     0.200
     4.258    66.854     0.200
     4.637    71.554     0.200
     5.195    78.755     0.200
     5.237    79.354     0.200
     5.432    82.155     0.200
     5.445    82.155     0.200
     5.652    85.954     0.200
     6.010    90.054     0.200
     6.672    98.255     0.200
     7.058   102.224     0.200
     7.327   107.655     0.200
     7.359   109.255     0.200
    13.124   186.947     0.200
    16.611   230.866     0.200
     2.081    36.473     0.200
     2.940    47.742     0.200
     3.284    53.402     0.200
     4.113    63.773     0.200
     4.031    62.961     0.200
     7.175   105.332     0.200
     6.943   102.301     0.200
     6.948   102.203     0.200
     7.589   110.121     0.200
     7.826   113.902     0.200
     8.128   117.801     0.200
     8.037   116.203     0.200
     8.803   132.441     0.200
    10.509   149.961     0.200
    11.120   158.352     0.200
    11.498   161.191     0.200
    11.541   160.602     0.200
    11.549   167.191     0.200
    12.243   173.852     0.200
    12.042   171.902     0.200
    12.729   176.703     0.200
    12.475   177.551     0.200
    12.506   177.980     0.200
    12.998   180.781     0.200
    13.000   180.402     0.200
    13.092   183.191     0.200
    13.157   186.949     0.200
    13.157   186.703     0.200
    13.547   188.184     0.200
    13.781   191.082     0.200
    14.265   196.973     0.200
    14.453   198.293     0.200
    15.000   210.762     0.200
    15.000   210.762     0.200
    15.618   212.812     0.200
    16.473   229.836     0.200
    20.546   279.625     0.200
     2.599    43.969     0.200
     2.828    45.172     0.200
     3.297    53.602     0.200
     3.818    59.969     0.200
     3.812    60.766     0.200
     4.249    66.570     0.200
     4.447    68.766     0.200
     5.094    76.867     0.200
     5.649    84.672     0.200
     5.695    85.367     0.200
     5.766    86.969     0.200
     5.888    87.766     0.200
     5.901    87.672     0.200
     6.115    90.867     0.200
     6.212    93.266     0.200
     6.471    96.367     0.200
     7.025   103.266     0.200
     7.128   104.266     0.200
     7.281   106.469     0.200
     7.345   104.766     0.200
     7.787   113.969     0.200
     7.823   114.266     0.200
     8.695   125.359     0.200
     9.742   140.172     0.200
    10.138   147.070     0.200
    10.138   145.766     0.200
    11.282   161.758     0.200
    11.542   161.039     0.200
    11.964   167.969     0.200
    12.123   174.539     0.200
    12.478   177.125     0.200
    12.615   179.586     0.200
    12.682   178.688     0.200
    12.746   179.219     0.200
    12.751   179.375     0.200
    12.778   181.469     0.200
    12.827   179.797     0.200
    12.861   179.250     0.200
    12.868   182.664     0.200
    12.868   182.469     0.200
    12.868   182.195     0.200
    12.894   185.797     0.200
    12.904   182.188     0.200
    12.934   178.969     0.200
    12.934   178.320     0.200
    13.023   183.539     0.200
    13.075   183.500     0.200
    13.080   186.695     0.200
    13.148   186.000     0.200
    13.460   192.219     0.200
    13.725   191.812     0.200
    13.715   192.227     0.200
    13.985   196.227     0.200
    14.085   197.281     0.200
    14.420   202.859     0.200
    14.578   203.172     0.200
    14.578   203.070     0.200
    14.620   204.617     0.200
    14.789   204.891     0.200
    14.915   210.570     0.200
    14.915   210.172     0.200
    15.099   213.078     0.200
    15.246   213.312     0.200
    16.516   228.266     0.200
    16.532   229.266     0.200
    16.532   229.039     0.200
    16.532   228.797     0.200
    16.532   228.672     0.200
    17.543   243.117     0.200
    20.211   275.867     0.200
     2.472    40.352     0.200
     3.302    53.531     0.200
     4.141    64.133     0.200
     4.578    70.734     0.200
     4.771    73.531     0.200
     5.423    81.930     0.200
     5.707    86.133     0.200
     5.978    90.133     0.200
     5.882    89.531     0.200
     5.887    88.734     0.200
     6.024    90.836     0.200
     6.217    93.031     0.200
     6.230    93.430     0.200
     6.800   100.930     0.200
     6.696    99.930     0.200
     6.954   101.930     0.200
     7.404   107.109     0.200
     7.404   107.273     0.200
     7.457   109.734     0.200
     8.116   119.031     0.200
     8.152   119.336     0.200
     8.896   129.383     0.200
     8.998   129.383     0.200
     9.345   133.430     0.200
     9.413   136.734     0.200
    10.442   149.133     0.200
    10.771   155.211     0.200
    11.138   158.961     0.200
    11.241   160.695     0.200
    11.547   164.883     0.200
    11.688   166.930     0.200
    11.697   168.133     0.200
    12.293   172.031     0.200
    12.222   175.734     0.200
    12.655   180.344     0.200
    12.655   179.820     0.200
    13.051   183.133     0.200
    14.323   200.930     0.200
    14.323   200.734     0.200
    16.417   229.234     0.200
    16.437   230.336     0.200
    16.437   228.852     0.200
    16.437   231.234     0.200
     1.620    30.426     0.200
     2.579    43.355     0.200
     3.282    53.047     0.200
     3.282    54.828     0.200
     4.280    67.059     0.200
     5.876    88.027     0.200
     6.675    98.328     0.200
     6.901    99.828     0.200
     7.179   104.605     0.200
     7.478   108.629     0.200
     7.746   113.426     0.200
     8.233   118.898     0.200
    13.250   188.070     0.200
    16.775   231.801     0.200
     2.634    42.641     0.200
     2.694    42.910     0.200
     2.831    44.867     0.200
     3.137    49.707     0.200
     3.165    48.469     0.200
     3.165    49.168     0.200
     3.238    50.969     0.200
     3.227    48.391     0.200
     3.323    49.660     0.200
     3.455    53.070     0.200
     3.467    53.777     0.200
     3.839    60.398     0.200
     3.977    59.379     0.200
     4.082    62.070     0.200
     4.548    67.168     0.200
     4.639    69.668     0.200
     4.761    69.328     0.200
     4.808    69.957     0.200
     4.877    72.469     0.200
     4.889    72.668     0.200
     5.103    75.770     0.200
     5.459    80.969     0.200
     6.117    89.070     0.200
     6.247    91.500     0.200
     6.813    98.770     0.200
     7.037   101.168     0.200
     7.209   104.770     0.200
     7.214   104.863     0.200
     7.242   101.648     0.200
     7.562   109.418     0.200
     7.771   110.957     0.200
     7.921   112.879     0.200
     8.036   115.270     0.200
     8.036   115.570     0.200
     8.290   120.070     0.200
     8.661   122.797     0.200
     9.003   127.348     0.200
     9.221   132.910     0.200
     9.230   130.969     0.200
     9.745   137.047     0.200
    10.731   151.359     0.200
    10.753   151.609     0.200
    10.954   151.367     0.200
    10.954   152.418     0.200
    10.954   152.910     0.200
    11.304   157.840     0.200
    11.923   168.129     0.200
    11.929   166.930     0.200
    11.910   167.250     0.200
    11.958   168.297     0.200
    12.032   169.020     0.200
    12.310   171.645     0.200
    12.343   173.777     0.200
    12.724   177.320     0.200
    12.852   178.898     0.200
    12.840   177.660     0.200
    12.900   177.891     0.200
    13.192   184.059     0.200
    13.207   184.391     0.200
    13.224   185.070     0.200
    13.224   184.969     0.200
    13.372   187.539     0.200
    13.477   188.598     0.200
    13.600   188.840     0.200
    13.559   189.887     0.200
    13.559   187.000     0.200
    13.559   192.473     0.200
    13.569   189.340     0.200
    13.864   190.738     0.200
    14.276   199.180     0.200
    14.310   198.289     0.200
    14.826   206.688     0.200
    14.966   209.969     0.200
    15.385   213.379     0.200
    15.385   213.328     0.200
    16.867   231.688     0.200
    16.870   233.348     0.200
    16.870   232.918     0.200
    17.789   245.188     0.200
    18.417   254.070     0.200
    20.042   272.270     0.200
    20.201   275.199     0.200
    20.284   274.367     0.200
    20.657   279.461     0.200
     2.329    39.805     0.200
     2.411    40.750     0.200
     2.409    40.742     0.200
     2.856    46.469     0.200
     4.879    75.641     0.200
     5.691    85.445     0.200
     5.945    89.742     0.200
     8.692   125.242     0.200
    11.985   172.711     0.200
    16.123   224.141     0.200
    18.942   261.820     0.200
     2.494    41.668     0.200
     2.906    47.559     0.200
     3.321    52.910     0.200
     3.423    55.930     0.200
     3.800    58.668     0.200
     4.160    67.418     0.200
     4.206    64.480     0.200
     4.638    70.879     0.200
     4.836    73.777     0.200
     4.836    73.980     0.200
     4.836    74.578     0.200
     5.116    75.551     0.200
     5.483    82.578     0.200
     5.654    85.020     0.200
     5.656    84.578     0.200
     5.773    84.891     0.200
     5.818    87.980     0.200
     5.823    87.469     0.200
     6.039    89.680     0.200
     6.083    90.379     0.200
     6.083    90.480     0.200
     6.083    90.680     0.200
     6.277    92.277     0.200
     6.290    92.980     0.200
     6.501    95.777     0.200
     6.639    97.480     0.200
     6.858   100.777     0.200
     6.892   102.078     0.200
     7.425   107.109     0.200
     7.457   106.980     0.200
     7.517   109.680     0.200
     8.175   118.480     0.200
     8.175   118.680     0.200
     8.207   118.980     0.200
     8.950   130.027     0.200
     9.067   129.617     0.200
     9.276   131.277     0.200
    10.009   142.250     0.200
    10.480   150.078     0.200
    10.480   151.188     0.200
    11.066   156.070     0.200
    11.135   156.238     0.200
    11.477   161.289     0.200
    11.867   169.238     0.200
    12.193   173.469     0.200
    12.318   175.438     0.200
    12.348   171.680     0.200
    12.348   172.699     0.200
    12.348   171.941     0.200
    12.469   176.879     0.200
    12.502   177.938     0.200
    12.545   178.078     0.200
    12.559   178.328     0.200
    12.577   178.258     0.200
    12.586   178.898     0.200
    12.586   178.199     0.200
    12.586   178.777     0.200
    12.631   179.219     0.200
    12.666   179.660     0.200
    12.784   180.348     0.200
    12.788   181.410     0.200
    12.868   182.148     0.200
    12.872   182.559     0.200
    12.904   180.180     0.200
    13.111   180.320     0.200
    13.183   186.141     0.200
    13.266   186.699     0.200
    13.331   188.617     0.200
    13.371   189.289     0.200
    13.469   190.641     0.200
    13.647   191.629     0.200
    13.702   191.777     0.200
    13.849   194.590     0.200
    14.252   198.508     0.200
    14.252   198.367     0.200
    14.347   200.910     0.200
    14.410   201.930     0.200
    14.875   208.879     0.200
    14.973   209.527     0.200
    16.360   225.570     0.200
    16.381   226.391     0.200
    16.381   229.277     0.200
    16.381   226.215     0.200
    16.381   225.969     0.200
    17.426   242.160     0.200
    17.470   240.680     0.200
    18.049   248.777     0.200
    18.853   261.898     0.200
    19.274   266.645     0.200
    19.508   267.438     0.200
    19.638   269.562     0.200
    19.638   269.754     0.200
    19.645   269.750     0.200
    19.933   274.156     0.200
    20.197   276.574     0.200
    20.465   279.844     0.200
    20.587   280.539     0.200
    20.594   280.320     0.200
    20.594   281.168     0.200
    20.691   281.566     0.200
    20.691   281.766     0.200
    20.892   284.988     0.200
    20.896   284.504     0.200
    21.000   283.996     0.200
    21.000   285.852     0.200
     3.441    56.195     0.200
    12.565   179.438     0.200
    16.342   229.117     0.200
    19.996   273.617     0.200
     1.214    22.938     0.200
     0.944    18.227     0.200
     0.955    18.266     0.200
     1.180    21.824     0.200
     3.971    62.863     0.200
     1.237    23.535     0.200
     1.178    22.617     0.200
     1.383    25.688     0.200
     1.116    21.117     0.200
     1.226    23.258     0.200
     1.272    23.844     0.200
     1.307    24.664     0.200
     1.373    25.938     0.200
     1.098    21.320     0.200
     1.139    22.172     0.200
     1.156    22.258     0.200
     1.208    23.141     0.200
     1.277    24.625     0.200
     1.140    22.199     0.200
     1.154    21.898     0.200
     1.285    23.918     0.200
     1.261    23.570     0.200
     1.308    25.238     0.200
     1.390    26.270     0.200
     1.428    27.480     0.200
     1.427    27.199     0.200
     0.976    19.578     0.200
     1.419    26.789     0.200
     2.549    42.660     0.200
     2.960    48.738     0.200
     3.376    53.750     0.200
     3.719    58.719     0.200
     3.855    59.707     0.200
     4.198    64.730     0.200
     4.623    71.328     0.200
     4.826    73.930     0.200
     5.466    82.527     0.200
     5.709    86.129     0.200
     5.834    88.098     0.200
     5.834    89.168     0.200
     6.023    90.828     0.200
     6.066    90.629     0.200
     6.261    92.828     0.200
     6.273    92.930     0.200
     6.480    96.730     0.200
     6.838   101.527     0.200
     7.503   107.707     0.200
     7.501   109.828     0.200
     8.105   116.859     0.200
     8.156   119.430     0.200
     8.186   119.430     0.200
     8.870   127.188     0.200
     9.070   129.758     0.200
     9.266   133.059     0.200
     9.369   135.320     0.200
     9.369   135.926     0.200
     9.752   138.648     0.200
    10.055   142.750     0.200
    10.442   150.188     0.200
    10.442   150.930     0.200
    11.086   158.980     0.200
    11.150   160.629     0.200
    11.141   159.770     0.200
    11.605   165.199     0.200
    11.784   166.410     0.200
    11.856   169.801     0.200
    11.857   170.758     0.200
    12.166   173.328     0.200
    12.294   176.051     0.200
    12.294   174.230     0.200
    12.326   172.609     0.200
    12.326   173.031     0.200
    12.326   172.480     0.200
    12.326   172.848     0.200
    12.432   176.980     0.200
    12.474   178.348     0.200
    12.506   177.648     0.200
    12.518   178.379     0.200
    12.519   178.309     0.200
    12.540   177.980     0.200
    12.559   179.129     0.200
    12.559   178.730     0.200
    12.559   179.590     0.200
    12.559   178.848     0.200
    12.601   180.641     0.200
    12.601   180.129     0.200
    12.632   179.188     0.200
    12.648   176.898     0.200
    12.691   180.707     0.200
    12.750   180.730     0.200
    12.750   180.629     0.200
    12.690   180.430     0.200
    12.762   182.008     0.200
    12.830   182.070     0.200
    12.844   182.898     0.200
    12.955   179.938     0.200
    13.152   183.617     0.200
    13.155   186.938     0.200
    13.234   186.449     0.200
    13.242   185.789     0.200
    13.303   189.000     0.200
    13.337   188.398     0.200
    13.436   190.148     0.200
    13.611   192.629     0.200
    13.746   194.469     0.200
    14.105   195.949     0.200
    14.077   196.199     0.200
    14.188   198.207     0.200
    14.234   199.129     0.200
    14.234   199.027     0.200
    14.234   199.270     0.200
    14.226   202.129     0.200
    14.324   200.598     0.200
    14.372   202.590     0.200
    14.739   211.180     0.200
    14.796   207.789     0.200
    14.824   209.230     0.200
    14.944   210.328     0.200
    16.316   226.141     0.200
    16.337   227.309     0.200
    16.337   226.828     0.200
    16.337   226.707     0.200
    16.337   226.902     0.200
    16.733   234.852     0.200
    17.380   242.527     0.200
    17.495   241.809     0.200
    18.021   249.730     0.200
    18.356   253.527     0.200
    19.045   264.828     0.200
    19.318   268.312     0.200
    19.558   269.609     0.200
    19.686   271.156     0.200
    19.981   275.102     0.200
    20.064   274.430     0.200
    20.245   277.496     0.200
    20.514   280.441     0.200
    20.634   282.098     0.200
    20.842   285.469     0.200
     1.432    26.883     0.200
     1.493    28.672     0.200
     1.260    24.258     0.200
     1.006    19.359     0.200
     1.145    21.703     0.200
     1.233    23.820     0.200
     1.347    25.438     0.200
     1.393    26.559     0.200
     1.429    27.340     0.200
     1.419    27.430     0.200
     1.384    25.500     0.200
     2.477    42.387     0.200
     2.505    41.680     0.200
     2.943    49.660     0.200
     2.914    48.027     0.200
     3.333    52.359     0.200
     3.457    56.129     0.200
     3.815    58.527     0.200
     4.172    63.250     0.200
     4.195    67.590     0.200
     4.604    70.949     0.200
     4.801    74.449     0.200
     5.448    82.949     0.200
     5.666    85.648     0.200
     6.004    89.949     0.200
     6.048    91.047     0.200
     6.255    93.848     0.200
     6.466    95.648     0.200
     6.823   101.148     0.200
     7.482   109.547     0.200
     8.173   118.949     0.200
    12.608   180.293     0.200
    16.391   229.438     0.200
    18.836   260.500     0.200
     1.214    22.793     0.200
     1.223    23.336     0.200
     1.331    25.016     0.200
     1.380    26.312     0.200
     1.414    26.855     0.200
     1.413    26.516     0.200
     1.480    27.773     0.200
     1.371    25.426     0.200
     1.239    23.375     0.200
     2.953    49.336     0.200
     3.314    52.562     0.200
     1.070    20.141     0.200
     1.079    21.008     0.200
     1.158    22.309     0.200
     1.218    23.898     0.200
     1.244    23.738     0.200
     1.249    23.707     0.200
     1.297    24.828     0.200
     1.295    24.547     0.200
     1.325    25.023     0.200
     1.058    20.297     0.200
     1.195    23.127     0.200
     1.110    21.719     0.200
     1.043    20.133     0.200
     1.094    21.094     0.200
     1.099    21.461     0.200
     1.177    22.750     0.200
     1.212    23.172     0.200
     1.232    23.852     0.200
     1.322    25.172     0.200
     1.370    26.031     0.200
     1.405    26.688     0.200
     1.402    26.398     0.200
     1.471    27.844     0.200
     1.148    21.887     0.200
     1.099    21.352     0.200
     1.113    21.664     0.200
     1.213    23.234     0.200
     1.267    24.195     0.200
     1.287    24.859     0.200
     1.288    24.664     0.200
     1.338    25.180     0.200
     1.407    26.562     0.200
     1.073    20.973     0.200
     0.930    18.453     0.200
     1.071    20.375     0.200
     1.095    20.953     0.200
     1.142    21.750     0.200
     1.210    22.961     0.200
     0.772    15.545     0.200
     0.805    15.766     0.200
     0.871    17.266     0.200
     0.878    17.244     0.200
     1.321    25.562     0.200
     0.864    16.617     0.200
     1.760    29.688     0.200
     1.850    30.926     0.200
     2.560    41.637     0.200
     2.930    46.848     0.200
     3.305    51.605     0.200
     4.553    69.348     0.200
     4.980    75.148     0.200
     5.182    77.648     0.200
     5.310    77.309     0.200
     5.477    81.875     0.200
     5.477    83.285     0.200
     5.624    83.926     0.200
     5.823    86.348     0.200
     6.251    90.238     0.200
     6.380    94.445     0.200
     6.423    94.047     0.200
     6.618    97.445     0.200
     6.630    97.547     0.200
     6.835    99.848     0.200
     7.194   105.148     0.200
     7.617   108.066     0.200
     7.858   113.246     0.200
     8.513   122.445     0.200
     8.539   123.047     0.200
     8.933   130.285     0.200
     9.012   128.527     0.200
     9.137   129.027     0.200
    10.171   144.277     0.200
    10.267   148.238     0.200
    10.374   147.348     0.200
    10.730   151.266     0.200
    10.730   152.188     0.200
    10.942   153.707     0.200
    10.942   157.887     0.200
    11.102   157.758     0.200
    11.135   156.828     0.200
    11.223   158.527     0.200
    11.288   159.035     0.200
    11.288   160.297     0.200
    11.893   167.105     0.200
    11.893   169.688     0.200
    12.274   173.605     0.200
    12.307   172.918     0.200
    12.307   175.492     0.200
    12.307   175.297     0.200
    12.356   172.766     0.200
    12.395   177.047     0.200
    12.680   175.535     0.200
    13.939   194.277     0.200
    13.939   194.707     0.200
    13.939   194.246     0.200
    16.184   224.785     0.200
    16.184   224.957     0.200
    16.209   224.535     0.200
    16.209   224.406     0.200
    16.209   224.070     0.200
    16.209   224.227     0.200
     2.214    37.137     0.200
     3.134    50.367     0.200
     5.082    77.727     0.200
     8.601   124.017     0.200
    10.843   156.797     0.200
    10.881   154.607     0.200
    10.997   157.587     0.200
    11.747   168.997     0.200
    13.688   192.907     0.200
    13.688   192.037     0.200
    16.169   225.017     0.200
    16.199   227.887     0.200
    16.199   228.373     0.200
    18.051   248.287     0.200
     1.179    22.836     0.200
     1.275    24.320     0.200
     1.063    20.403     0.200
     1.334    25.233     0.200
     1.396    26.333     0.200
     3.673    58.653     0.200
     4.187    65.313     0.200
     1.354    25.867     0.200
     1.421    27.180     0.200
     1.065    20.430     0.200
     1.112    21.480     0.200
     1.201    22.641     0.200
     1.151    22.141     0.200
     1.327    25.191     0.200
     1.383    25.820     0.200
     1.424    26.820     0.200
     1.355    25.516     0.200
     1.461    27.562     0.200
     1.204    22.441     0.200
     1.211    22.836     0.200
     1.214    22.721     0.200
     1.388    25.910     0.200
     1.300    25.180     0.200
     1.348    25.320     0.200
     1.439    27.398     0.200
     1.321    25.086     0.200
     1.896    32.102     0.200
     3.191    53.484     0.200
     1.000    19.289     0.200
     1.216    22.879     0.200
     1.257    23.430     0.200
     1.300    24.508     0.200
     1.143    21.887     0.200
     1.166    22.324     0.200
     1.188    23.184     0.200
     1.243    24.285     0.200
     1.252    24.023     0.200
     1.274    24.176     0.200
     1.337    25.254     0.200
     1.062    19.785     0.200
     1.193    21.863     0.200
     1.214    22.816     0.200
     1.381    26.031     0.200
     1.449    26.707     0.200
     1.519    27.508     0.200
     1.419    26.562     0.200
     0.618    13.188     0.200
     0.690    13.736     0.200
     0.868    16.236     0.200
     0.896    17.658     0.200
     1.419    26.891     0.200
     1.490    28.188     0.200
     1.348    25.004     0.200
     1.493    27.762     0.200
     0.898    17.789     0.200
     1.094    21.164     0.200
     1.111    21.539     0.200
     1.136    21.969     0.200
     1.215    23.648     0.200
     1.429    27.156     0.200
     1.329    24.836     0.200
     1.461    27.320     0.200
     1.584    29.734     0.200
     0.997    20.801     0.200
     1.085    21.340     0.200
     1.258    24.832     0.200
     1.264    23.941     0.200
     1.334    25.852     0.200
     1.094    21.385     0.200
     1.144    21.714     0.200
     1.239    23.014     0.200
     1.272    23.974     0.200
     1.273    23.944     0.200
     1.354    24.905     0.200
     0.908    17.905     0.200
     2.295    38.474     0.200
     0.638    12.992     0.200
     0.685    14.133     0.200
     0.793    15.352     0.200
     0.862    16.359     0.200
     1.132    20.750     0.200
     1.305    24.816     0.200
     1.338    24.957     0.200
     1.358    26.004     0.200
     1.135    22.266     0.200
     0.727    14.682     0.200
     0.915    17.650     0.200
     1.034    20.021     0.200
     1.169    21.842     0.200
     1.221    23.150     0.200
     1.077    20.883     0.200
     1.159    22.336     0.200
     1.305    25.766     0.200
     1.388    26.352     0.200
     1.453    27.016     0.200
     0.941    17.938     0.200
     1.150    21.898     0.200
     1.235    22.969     0.200
     1.277    24.039     0.200
     1.209    23.088     0.200
     1.237    23.459     0.200
     1.360    25.998     0.200
     1.397    26.078     0.200
     1.400    26.969     0.200
     1.420    27.088     0.200
     1.440    27.059     0.200
     1.507    28.629     0.200
     1.134    21.859     0.200
     1.213    22.891     0.200
     1.239    23.461     0.200
     1.386    26.320     0.200
     1.411    26.721     0.200
     1.437    26.850     0.200
     1.475    28.301     0.200
     0.910    17.994     0.200
     1.137    22.254     0.200
     1.218    23.094     0.200
     1.307    24.635     0.200
     1.377    25.625     0.200
     1.141    21.734     0.200
     1.189    22.609     0.200
     1.126    21.693     0.200
     1.269    23.754     0.200
     1.320    24.664     0.200
     1.353    25.733     0.200
     1.085    20.551     0.200
     1.163    22.102     0.200
     1.201    22.801     0.200
     1.236    23.191     0.200
     1.332    24.539     0.200
     1.310    24.756     0.200
     1.337    24.986     0.200
     1.458    27.496     0.200
     1.631    30.637     0.200
     2.058    38.807     0.200
     1.999    36.166     0.200
     2.395    43.746     0.200
     3.134    52.506     0.200
     1.241    23.387     0.200
     1.307    24.625     0.200
     1.327    24.738     0.200
     1.327    25.219     0.200
     1.345    25.422     0.200
     1.227    23.680     0.200
     1.304    25.203     0.200
     1.465    28.141     0.200
     1.517    29.242     0.200
     1.019    20.203     0.200
     1.047    20.125     0.200
     1.287    24.578     0.200
     0.954    17.820     0.200
     1.118    20.359     0.200
     1.340    25.418     0.200
     1.372    26.297     0.200
     1.412    27.250     0.200
     1.444    27.418     0.200
     1.601    30.258     0.200
     1.586    30.508     0.200
     2.545    43.699     0.200
     2.712    46.328     0.200
     2.772    47.020     0.200
     2.888    48.590     0.200
     3.542    57.980     0.200
     3.735    60.469     0.200
     4.248    66.547     0.200
     1.106    21.359     0.200
     1.175    22.439     0.200
     1.212    23.310     0.200
     1.306    24.680     0.200
     1.424    27.199     0.200
     0.978    22.649     0.200
     1.216    23.422     0.200
     1.472    27.934     0.200
     0.861    16.984     0.200
     0.856    16.930     0.200
     0.969    18.930     0.200
     0.937    18.281     0.200
     0.975    18.953     0.200
     0.978    19.539     0.200
     0.998    19.172     0.200
     1.020    21.031     0.200
     1.024    19.852     0.200
     1.047    20.711     0.200
     1.077    21.117     0.200
     1.083    22.391     0.200
     1.092    20.734     0.200
     1.104    22.578     0.200
     1.160    22.453     0.200
     1.173    22.219     0.200
     1.276    24.633     0.200
     1.378    26.273     0.200
     1.385    26.398     0.200
     1.116    21.383     0.200
     1.141    21.789     0.200
     1.127    21.922     0.200
     1.194    22.781     0.200
     1.202    22.969     0.200
     1.284    24.391     0.200
     1.312    25.805     0.200
     1.335    24.516     0.200
     1.372    26.078     0.200
     1.368    25.805     0.200
     1.325    24.164     0.200
     1.416    25.781     0.200
     2.996    50.328     0.200
     4.121    62.875     0.200
     4.244    68.234     0.200
     4.750    73.773     0.200
     4.750    73.875     0.200
     5.403    81.969     0.200
     5.958    89.570     0.200
     6.004    90.273     0.200
     6.004    90.375     0.200
     6.197    92.773     0.200
     6.424    95.672     0.200
     6.781   100.570     0.200
     8.096   118.375     0.200
    12.673   177.688     0.200
    16.450   230.070     0.200
     1.112    21.445     0.200
     1.394    26.492     0.200
     1.242    23.500     0.200
     1.318    24.609     0.200
     1.326    24.961     0.200
     1.391    26.109     0.200
     1.086    20.680     0.200
     1.131    21.430     0.200
     1.173    23.370     0.200
     1.531    28.926     0.200
     1.590    30.215     0.200
     1.020    20.926     0.200
     3.095    50.543     0.200
     1.054    20.172     0.200
     1.201    22.891     0.200
     1.307    24.891     0.200
     0.906    18.832     0.200
     1.228    24.562     0.200
     2.203    38.191     0.200
     2.397    41.094     0.200
     2.613    44.012     0.200
     3.095    50.914     0.200
     1.029    20.281     0.200
     1.174    22.680     0.200
     1.204    23.359     0.200
     1.427    26.594     0.200
     1.375    26.195     0.200
     1.478    27.695     0.200
     1.376    25.961     0.200
     1.450    27.273     0.200
     1.495    28.523     0.200
     1.213    23.144     0.200
     1.327    25.424     0.200
     0.891    17.773     0.200
     0.909    18.234     0.200
     0.921    18.934     0.200
     0.959    18.875     0.200
     0.988    19.965     0.200
     0.989    18.895     0.200
     1.010    19.422     0.200
     1.136    22.082     0.200
     1.142    21.785     0.200
     1.189    22.152     0.200
     1.309    24.875     0.200
     1.355    26.844     0.200
     0.973    19.743     0.200
     1.024    20.553     0.200
     1.142    23.434     0.200
     1.151    21.843     0.200
     1.160    22.253     0.200
     1.298    24.443     0.200
     1.335    25.123     0.200
     0.847    17.934     0.200
     0.942    18.902     0.200
     1.074    20.984     0.200
     1.083    21.402     0.200
     1.141    22.164     0.200
     1.196    23.113     0.200
     1.212    23.492     0.200
     1.313    25.305     0.200
     1.196    22.750     0.200
     1.295    24.672     0.200
     0.921    18.650     0.200
     1.086    20.870     0.200
     1.107    21.350     0.200
     1.104    21.480     0.200
     1.168    22.690     0.200
     1.412    25.970     0.200
     0.778    16.156     0.200
     0.883    17.535     0.200
     1.028    20.895     0.200
     1.274    24.039     0.200
     1.341    25.188     0.200
     1.463    27.055     0.200
     1.488    28.461     0.200
     1.079    21.039     0.200
     1.162    22.004     0.200
     1.254    23.664     0.200
     1.345    25.854     0.200
     1.421    27.203     0.200
     1.454    27.352     0.200
     0.921    17.445     0.200
     0.977    18.562     0.200
     1.020    19.094     0.200
     1.249    22.934     0.200
     1.219    23.742     0.200
     1.491    29.051     0.200
     1.514    28.742     0.200
     0.991    19.164     0.200
     1.044    19.945     0.200
     1.070    20.602     0.200
     1.075    20.172     0.200
     1.118    20.727     0.200
     1.139    21.227     0.200
     1.216    22.836     0.200
     1.246    23.562     0.200
     1.336    25.070     0.200
     1.325    25.742     0.200
     2.163    38.852     0.200
     3.339    54.180     0.200
     3.791    60.422     0.200
    16.561   228.961     0.200
     1.189    22.667     0.200
     1.440    27.297     0.200
     1.449    27.418     0.200
     1.507    28.496     0.200
     0.936    18.266     0.200
     1.049    20.316     0.200
     1.128    21.656     0.200
     1.146    22.023     0.200
     1.211    22.844     0.200
     1.196    23.195     0.200
     1.217    23.625     0.200
     1.229    23.746     0.200
     1.291    24.543     0.200
     1.324    25.285     0.200
     1.365    26.113     0.200
     1.309    23.945     0.200
     1.403    26.633     0.200
     2.531    41.824     0.200
     2.581    40.984     0.200
     3.409    55.133     0.200
     1.041    20.116     0.200
     1.098    21.366     0.200
     1.117    21.866     0.200
     1.127    21.666     0.200
     1.288    24.686     0.200
     1.298    24.838     0.200
     1.379    26.038     0.200
     1.418    27.008     0.200
     1.515    28.248     0.200
     0.974    19.492     0.200
     1.060    20.782     0.200
     1.083    22.442     0.200
     1.090    21.962     0.200
     1.115    21.492     0.200
     1.249    24.602     0.200
     1.294    23.822     0.200
     2.844    46.972     0.200
     2.919    46.832     0.200
     2.977    48.492     0.200
     3.525    56.812     0.200
     3.740    57.632     0.200
     4.129    62.532     0.200
     4.370    67.712     0.200
     4.464    69.572     0.200
     4.758    71.562     0.200
     4.925    75.112     0.200
     4.912    76.732     0.200
     4.973    76.212     0.200
     5.164    78.212     0.200
     5.177    78.412     0.200
     5.398    81.812     0.200
     5.915    86.772     0.200
     6.147    89.432     0.200
     6.147    93.062     0.200
     6.404    94.912     0.200
     6.847   100.302     0.200
     7.065   104.512     0.200
     7.182   102.492     0.200
     7.905   115.082     0.200
     8.002   115.402     0.200
     8.036   117.092     0.200
     8.391   126.702     0.200
     9.515   136.012     0.200
     9.515   139.972     0.200
     9.701   137.742     0.200
    10.467   149.352     0.200
    10.467   148.582     0.200
    10.920   155.632     0.200
    11.250   158.622     0.200
    11.250   159.212     0.200
    11.289   160.102     0.200
    11.855   167.292     0.200
    11.855   168.342     0.200
    12.112   170.942     0.200
    12.112   170.542     0.200
    12.534   178.242     0.200
    12.548   175.492     0.200
    12.548   175.172     0.200
    12.548   175.872     0.200
    12.717   180.122     0.200
    12.745   178.942     0.200
    12.806   178.892     0.200
    12.919   182.952     0.200
    12.919   181.042     0.200
    13.411   189.238     0.200
    13.411   189.512     0.200
    13.411   187.622     0.200
    13.517   188.752     0.200
    13.786   191.672     0.200
    15.020   211.812     0.200
    15.196   210.432     0.200
    15.196   210.532     0.200
    16.831   233.272     0.200
    16.831   234.032     0.200
    16.839   234.640     0.200
    16.839   234.072     0.200
    18.625   258.712     0.200
    20.562   279.437     0.200
    20.567   280.155     0.200
     1.257    24.016     0.200
     1.337    24.723     0.200
     1.065    20.695     0.200
     1.081    21.039     0.200
     1.136    22.180     0.200
     1.207    23.016     0.200
     0.988    19.998     0.200
     1.080    21.168     0.200
     1.271    24.418     0.200
     1.287    25.529     0.200
     1.295    24.879     0.200
     1.313    25.248     0.200
     1.380    25.828     0.200
     3.068    50.850     0.200
     3.359    53.439     0.200
     3.524    55.879     0.200
     3.582    57.488     0.200
     1.154    21.953     0.200
     1.205    22.887     0.200
     1.257    24.465     0.200
     1.297    24.168     0.200
     1.045    19.984     0.200
     1.055    20.305     0.200
     1.110    21.703     0.200
     1.180    22.734     0.200
     1.072    20.293     0.200
     1.227    22.943     0.200
     1.264    23.543     0.200
     1.305    24.313     0.200
     1.173    22.711     0.200
     1.214    23.602     0.200
     1.254    23.570     0.200
     1.268    24.273     0.200
     1.308    25.312     0.200
     1.433    27.781     0.200
     1.197    23.406     0.200
     1.260    24.266     0.200
     1.294    24.234     0.200
     1.343    26.141     0.200
     2.730    45.375     0.200
     3.923    61.844     0.200
     4.860    74.461     0.200
     1.309    24.750     0.200
     1.346    24.820     0.200
     0.972    18.844     0.200
     1.154    22.000     0.200
     1.106    21.367     0.200
     1.141    21.875     0.200
     1.160    22.094     0.200
     1.171    22.523     0.200
     1.175    22.602     0.200
     1.245    23.602     0.200
     1.299    24.438     0.200
     1.336    25.438     0.200
     1.331    25.297     0.200
     1.403    26.820     0.200
     0.834    16.387     0.200
     0.829    16.594     0.200
     0.858    16.754     0.200
     0.915    17.715     0.200
     1.042    19.637     0.200
     1.122    20.996     0.200
     1.172    21.684     0.200
     1.222    22.625     0.200
     1.223    22.777     0.200
     1.231    22.547     0.200
     1.289    24.234     0.200
     1.301    24.387     0.200
     1.319    24.805     0.200
     1.358    25.445     0.200
     2.686    41.445     0.200
     4.110    65.164     0.200
     6.259    93.406     0.200
     8.869   126.176     0.200
    12.696   180.051     0.200
    12.696   180.629     0.200
    14.401   199.266     0.200
    16.393   226.980     0.200
    21.028   284.156     0.200
     0.843    16.664     0.200
     0.930    18.184     0.200
     1.050    20.234     0.200
     1.135    21.426     0.200
     1.227    23.465     0.200
     1.232    22.945     0.200
     1.292    24.125     0.200
     1.312    24.734     0.200
     1.362    25.297     0.200
     1.382    25.566     0.200
     0.850    16.895     0.200
     0.940    18.766     0.200
     1.052    20.824     0.200
     1.052    20.477     0.200
     1.232    23.926     0.200
     1.219    23.586     0.200
     1.235    23.914     0.200
     1.316    25.426     0.200
     1.384    26.324     0.200
     1.256    24.281     0.200
     1.362    25.770     0.200
     0.941    18.309     0.200
     1.118    21.609     0.200
     1.201    22.590     0.200
     1.220    23.801     0.200
     1.274    24.688     0.200
     1.281    24.938     0.200
     1.307    24.758     0.200
     1.355    25.777     0.200
     1.330    24.779     0.200
     1.335    25.430     0.200
     1.452    27.500     0.200
     1.105    21.000     0.200
     1.164    22.500     0.200
     1.382    25.875     0.200
     1.471    27.469     0.200
     1.095    21.375     0.200
     1.197    22.759     0.200
     1.296    25.309     0.200
     1.375    25.989     0.200
     1.223    26.759     0.200
     2.582    44.829     0.200
     2.658    46.299     0.200
     2.710    47.329     0.200
     3.286    50.929     0.200
     3.789    61.959     0.200
     3.880    62.609     0.200
     4.249    67.259     0.200
     4.774    74.989     0.200
     6.698   100.059     0.200
     6.698   100.179     0.200
     9.782   141.439     0.200
    10.135   147.229     0.200
    10.214   147.569     0.200
    11.184   159.869     0.200
    11.184   159.589     0.200
    11.522   162.279     0.200
    11.542   165.459     0.200
    11.820   169.679     0.200
    11.828   168.769     0.200
    11.979   170.239     0.200
    12.294   175.549     0.200
    12.294   176.019     0.200
    12.511   179.239     0.200
    12.511   179.059     0.200
    12.465   176.089     0.200
    12.465   175.819     0.200
    12.599   177.089     0.200
    12.652   178.759     0.200
    12.855   183.139     0.200
    12.830   180.864     0.200
    12.939   184.189     0.200
    13.231   191.089     0.200
    13.303   188.100     0.200
    13.327   188.733     0.200
    13.327   191.069     0.200
    13.327   189.289     0.200
    13.327   187.987     0.200
    13.327   188.949     0.200
    13.339   191.169     0.200
    13.390   189.019     0.200
    13.454   191.029     0.200
    13.546   194.439     0.200
    13.602   194.369     0.200
    13.916   198.579     0.200
    13.967   198.939     0.200
    14.407   203.679     0.200
    14.416   202.899     0.200
    15.065   209.639     0.200
    16.860   233.929     0.200
    16.871   234.289     0.200
    16.871   234.639     0.200
    19.583   269.639     0.200
     1.210    24.119     0.200
     0.830    17.590     0.200
     0.974    20.000     0.200
     1.044    20.234     0.200
     0.974    19.113     0.200
     1.049    20.434     0.200
     1.211    24.227     0.200
     1.422    26.586     0.200
     1.098    21.773     0.200
     1.234    23.402     0.200
     1.310    24.523     0.200
     1.098    21.625     0.200
     1.234    23.773     0.200
     1.396    26.484     0.200
     1.451    27.352     0.200
     0.784    16.386     0.200
     0.973    19.836     0.200
     1.014    20.636     0.200
     1.121    20.664     0.200
     1.140    21.617     0.200
     1.379    26.375     0.200
     1.426    27.203     0.200
     1.045    20.289     0.200
     1.154    21.898     0.200
     1.210    23.719     0.200
     1.392    26.625     0.200
     1.440    27.695     0.200
     1.455    27.820     0.200
     3.803    61.125     0.200
     4.264    68.539     0.200
     1.295    24.359     0.200
     1.239    27.141     0.200
     1.940    33.117     0.200
     2.943    49.500     0.200
     1.364    25.715     0.200
     1.028    20.097     0.200
     1.403    25.737     0.200
     1.251    23.617     0.200
     1.311    24.586     0.200
     1.350    25.125     0.200
     3.913    62.816     0.200
     1.450    27.672     0.200
     1.154    22.270     0.200
     1.101    21.391     0.200
     1.197    22.883     0.200
     1.443    27.594     0.200
     3.286    51.281     0.200
     3.789    61.961     0.200
     4.249    66.852     0.200
     1.102    21.156     0.200
     1.153    22.541     0.200
     1.145    22.611     0.200
     1.327    25.211     0.200
     1.248    23.039     0.200
     1.289    24.367     0.200
     1.317    24.883     0.200
     1.550    29.391     0.200
     1.199    22.590     0.200
     1.192    22.219     0.200
     1.246    23.488     0.200
     1.346    25.160     0.200
     1.060    20.344     0.200
     1.184    22.504     0.200
     1.206    23.203     0.200
     1.254    23.473     0.200
     1.288    24.625     0.200
     1.354    25.684     0.200
     1.245    24.285     0.200
     1.335    24.855     0.200
     1.366    29.023     0.200
     3.538    58.562     0.200
     1.283    24.180     0.200
     1.349    24.766     0.200
     1.314    24.570     0.200
     1.431    27.340     0.200
     1.480    27.758     0.200
     1.512    28.660     0.200
     0.970    18.898     0.200
     0.972    18.891     0.200
     1.042    19.797     0.200
     1.104    20.805     0.200
     1.207    22.406     0.200
     1.214    23.086     0.200
     1.299    24.211     0.200
     1.342    24.820     0.200
     1.374    25.945     0.200
     1.395    26.793     0.200
     1.404    26.453     0.200
     1.451    27.465     0.200
     1.504    28.445     0.200
     1.533    29.023     0.200
     1.107    21.219     0.200
     1.204    22.734     0.200
     1.382    26.047     0.200
     1.433    27.328     0.200
     1.450    27.297     0.200
     1.430    28.195     0.200
     3.795    62.000     0.200
     1.511    28.891     0.200
     1.304    24.746     0.200
     1.339    25.375     0.200
     1.366    26.004     0.200
     1.378    25.926     0.200
     1.461    27.297     0.200
     1.500    28.105     0.200
     1.537    28.766     0.200
     1.549    28.816     0.200
     1.144    21.609     0.200
     1.348    25.398     0.200
     1.458    27.156     0.200
     1.455    26.781     0.200
     1.466    27.766     0.200
     1.273    24.289     0.200
     1.341    25.336     0.200
     1.217    23.238     0.200
     1.259    23.559     0.200
     1.285    24.148     0.200
     0.995    19.176     0.200
     1.084    20.238     0.200
     1.139    21.098     0.200
     1.202    22.578     0.200
     1.257    23.906     0.200
     1.330    24.266     0.200
     1.342    25.016     0.200
     1.066    20.356     0.200
     1.079    20.466     0.200
     1.133    21.496     0.200
     1.151    21.656     0.200
     1.202    22.866     0.200
     1.393    26.306     0.200
     1.202    22.789     0.200
     1.432    27.148     0.200
     1.447    27.414     0.200
     1.181    22.203     0.200
     1.223    22.891     0.200
     1.249    23.734     0.200
     1.446    26.930     0.200
     2.990    50.117     0.200
     1.381    25.840     0.200
     1.085    20.859     0.200
     1.131    21.477     0.200
     1.249    23.828     0.200
     1.262    23.688     0.200
     1.276    23.945     0.200
     1.307    24.766     0.200
     1.316    24.711     0.200
     1.310    25.188     0.200
     1.374    25.938     0.200
     1.386    26.195     0.200
     1.443    27.047     0.200
     1.085    21.109     0.200
     1.134    21.586     0.200
     1.262    24.078     0.200
     1.307    24.984     0.200
     1.316    24.594     0.200
     1.374    26.141     0.200
     1.443    27.508     0.200
     1.303    25.086     0.200
     1.404    26.805     0.200
     3.058    51.195     0.200
     1.078    20.812     0.200
     1.199    22.641     0.200
     1.248    23.438     0.200
     1.265    24.055     0.200
     1.255    24.055     0.200
     1.274    24.133     0.200
     1.318    24.484     0.200
     1.323    24.469     0.200
     1.328    25.000     0.200
     1.387    26.148     0.200
     1.113    21.078     0.200
     1.111    21.078     0.200
     1.166    22.529     0.200
     1.212    22.818     0.200
     1.247    23.709     0.200
     1.308    24.719     0.200
     1.339    25.148     0.200
     1.385    26.258     0.200
     1.202    22.867     0.200
     1.283    24.195     0.200
     1.282    24.836     0.200
     0.943    18.227     0.200
     1.037    19.867     0.200
     1.134    21.828     0.200
     1.214    22.746     0.200
     1.227    23.348     0.200
     1.275    24.188     0.200
     1.296    24.699     0.200
     1.299    24.008     0.200
     1.341    24.938     0.200
     1.349    25.297     0.200
     1.235    23.969     0.200
     1.412    26.938     0.200
     1.459    27.266     0.200
     1.486    28.188     0.200
     1.127    21.675     0.200
     1.135    21.575     0.200
     1.163    22.436     0.200
     1.216    22.755     0.200
     1.264    24.186     0.200
     1.316    24.815     0.200
     1.348    25.635     0.200
     1.414    26.945     0.200
     0.867    17.488     0.200
     1.239    24.340     0.200
     1.326    24.949     0.200
     1.364    25.301     0.200
     1.342    24.828     0.200
     1.348    25.801     0.200
     1.527    28.758     0.200
     2.392    40.770     0.200
     2.454    41.680     0.200
     2.714    46.469     0.200
     3.209    51.750     0.200
     3.185    53.250     0.200
     3.224    53.578     0.200
     4.847    74.828     0.200
     5.036    77.328     0.200
     5.692    85.531     0.200
     6.247    92.828     0.200
     6.293    93.930     0.200
     6.486    96.230     0.200
     6.499    96.230     0.200
     6.713    99.730     0.200
     7.726   112.828     0.200
     1.188    22.883     0.200
     0.929    18.359     0.200
     1.080    21.080     0.200
     1.111    21.350     0.200
     1.126    21.930     0.200
     1.193    22.990     0.200
     1.385    26.471     0.200
     1.044    20.129     0.200
     1.070    20.512     0.200
     1.111    21.340     0.200
     1.110    21.398     0.200
     1.228    23.320     0.200
     1.412    27.328     0.200
     1.055    20.727     0.200
     0.920    18.312     0.200
     0.951    18.773     0.200
     1.031    19.547     0.200
     1.049    20.133     0.200
     1.112    21.461     0.200
     1.150    21.938     0.200
     1.165    22.195     0.200
     1.171    23.016     0.200
     1.203    23.062     0.200
     1.209    22.945     0.200
     1.221    23.125     0.200
     1.235    23.711     0.200
     1.238    23.922     0.200
     0.960    19.531     0.200
     1.246    23.980     0.200
     1.298    24.363     0.200
     1.433    26.723     0.200
     1.441    27.523     0.200
     1.481    28.273     0.200
     1.246    23.801     0.200
     1.441    27.113     0.200
     1.420    27.914     0.200
     2.332    38.691     0.200
     2.379    38.113     0.200
     2.459    38.812     0.200
     2.428    39.121     0.200
     3.061    49.043     0.200
     5.015    76.262     0.200
     5.310    80.422     0.200
     5.655    85.152     0.200
     5.833    88.352     0.200
     6.500    96.254     0.200
     1.243    23.512     0.200
     1.350    25.422     0.200
     1.416    26.621     0.200
     1.123    21.430     0.200
     1.188    22.492     0.200
     1.441    27.414     0.200
     1.460    27.844     0.200
     1.487    28.016     0.200
     3.809    61.242     0.200
     1.105    21.039     0.200
     1.177    22.418     0.200
     1.206    23.078     0.200
     1.354    25.516     0.200
     1.355    25.316     0.200
     1.431    26.227     0.200
     1.396    26.125     0.200
     1.457    27.180     0.200
     1.107    21.976     0.200
     1.250    23.977     0.200
     1.296    24.500     0.200
     1.378    25.633     0.200
     1.148    22.109     0.200
     1.242    23.670     0.200
     1.367    27.340     0.200
     1.378    26.580     0.200
     1.392    26.939     0.200
     1.530    29.340     0.200
     2.613    44.750     0.200
     2.672    45.420     0.200
     3.442    55.420     0.200
     3.743    62.119     0.200
     4.745    75.850     0.200
    16.872   234.121     0.200
     1.179    22.898     0.200
     1.089    20.735     0.200
     1.128    21.665     0.200
     1.255    23.975     0.200
     1.327    25.385     0.200
     1.353    25.445     0.200
     1.359    25.455     0.200
     1.422    26.795     0.200
     0.811    16.471     0.200
     0.914    17.699     0.200
     0.911    17.311     0.200
     0.958    18.820     0.200
     1.014    19.371     0.200
     1.074    19.871     0.200
     1.081    20.730     0.200
     1.101    20.570     0.200
     1.127    21.480     0.200
     1.260    23.199     0.200
     1.276    23.529     0.200
     1.296    23.961     0.200
     1.330    24.400     0.200
     1.346    25.471     0.200
     1.416    26.549     0.200
     1.027    19.922     0.200
     1.214    23.297     0.200
     1.267    23.695     0.200
     1.336    24.836     0.200
     1.371    25.234     0.200
     1.133    21.430     0.200
     1.400    26.312     0.200
     1.255    24.023     0.200
     1.289    24.664     0.200
     1.339    25.430     0.200
     1.368    26.219     0.200
     1.366    25.875     0.200
     1.501    28.242     0.200
     1.519    28.914     0.200
     1.515    29.391     0.200
     1.544    29.422     0.200
     0.972    18.398     0.200
     1.018    19.172     0.200
     1.038    19.328     0.200
     1.078    19.938     0.200
     1.108    20.062     0.200
     1.139    20.992     0.200
     1.370    25.523     0.200
     1.265    23.637     0.200
     1.365    25.766     0.200
     1.450    27.445     0.200
     1.190    22.609     0.200
     1.219    23.008     0.200
     1.230    23.289     0.200
     1.297    24.688     0.200
     1.309    25.000     0.200
     1.308    24.828     0.200
     1.452    27.359     0.200
     1.455    27.336     0.200
     1.477    27.594     0.200
     1.308    24.882     0.200
     1.313    24.992     0.200
     1.317    25.492     0.200
     1.130    21.727     0.200
     1.217    23.578     0.200
     1.273    24.898     0.200
     1.322    25.109     0.200
     1.422    27.375     0.200
     0.988    19.004     0.200
     1.278    24.902     0.200
     1.108    21.453     0.200
     1.120    21.742     0.200
     1.155    22.352     0.200
     1.288    24.906     0.200
     1.358    25.242     0.200
     1.379    26.039     0.200
     1.363    25.969     0.200
     1.554    29.586     0.200
     1.124    21.422     0.200
     1.115    21.557     0.200
     1.271    24.625     0.200
     1.048    20.688     0.200
     1.044    20.445     0.200
     1.125    22.094     0.200
     1.319    24.883     0.200
     1.354    26.547     0.200
     1.382    27.375     0.200
     1.081    20.969     0.200
     1.229    23.125     0.200
     1.266    24.375     0.200
     1.324    25.094     0.200
     1.276    23.906     0.200
     1.339    25.062     0.200
     1.448    27.477     0.200
     0.843    16.695     0.200
     0.966    19.234     0.200
     1.047    20.644     0.200
     1.090    21.194     0.200
     1.141    22.394     0.200
     1.184    22.914     0.200
     1.304    25.154     0.200
     1.380    25.914     0.200
     1.411    26.584     0.200
     1.147    23.109     0.200
     0.879    17.457     0.200
     0.895    18.109     0.200
     0.893    17.590     0.200
     0.939    18.316     0.200
     0.971    18.539     0.200
     1.009    19.367     0.200
     1.000    19.469     0.200
     1.018    19.629     0.200
     1.104    20.930     0.200
     1.094    21.297     0.200
     1.155    22.828     0.200
     1.157    21.887     0.200
     1.213    23.758     0.200
     1.239    23.750     0.200
     1.283    24.547     0.200
     1.345    25.828     0.200
     1.354    26.270     0.200
     1.129    22.055     0.200
     1.212    23.113     0.200
     1.291    23.922     0.200
     1.359    25.125     0.200
     1.281    24.633     0.200
     1.301    25.281     0.200
     1.488    28.363     0.200
     1.157    22.146     0.200
     1.175    22.516     0.200
     1.204    22.305     0.200
     1.018    20.984     0.200
     1.095    21.305     0.200
     1.289    25.141     0.200
     1.324    25.461     0.200
     1.390    26.039     0.200
     1.231    23.453     0.200
     1.417    26.934     0.200
     1.510    27.773     0.200
     0.764    15.422     0.200
     0.850    16.797     0.200
     0.959    18.875     0.200
     0.970    18.789     0.200
     1.012    19.805     0.200
     1.014    19.469     0.200
     1.029    20.102     0.200
     1.064    20.664     0.200
     1.081    20.828     0.200
     1.150    21.727     0.200
     1.187    23.148     0.200
     1.308    25.117     0.200
     1.083    21.621     0.200
     1.188    23.004     0.200
     1.215    23.512     0.200
     1.233    24.512     0.200
     1.294    25.484     0.200
     1.311    25.652     0.200
     1.311    26.074     0.200
     1.451    27.883     0.200
     1.458    28.742     0.200
     1.474    28.281     0.200
     1.501    29.062     0.200
     1.588    29.812     0.200
     1.114    21.570     0.200
     1.232    23.312     0.200
     1.263    24.750     0.200
     1.263    24.336     0.200
     1.340    25.344     0.200
     1.339    25.453     0.200
     1.346    25.570     0.200
     1.488    28.164     0.200
     1.492    27.875     0.200
     1.237    23.382     0.200
     1.270    23.912     0.200
     1.266    23.962     0.200
     1.345    25.292     0.200
     1.342    25.542     0.200
     1.349    25.223     0.200
     1.142    22.170     0.200
     1.160    22.260     0.200
     1.219    23.740     0.200
     1.224    22.970     0.200
     1.375    25.720     0.200
     1.439    27.210     0.200
     0.974    18.826     0.200
     1.015    19.885     0.200
     1.139    22.025     0.200
     1.229    23.346     0.200
     1.304    24.695     0.200
     1.410    26.543     0.200
     1.452    27.293     0.200
     1.459    27.461     0.200
     1.506    28.480     0.200
     1.175    22.344     0.200
     1.185    22.383     0.200
     1.239    23.645     0.200
     1.262    23.863     0.200
     1.282    23.852     0.200
     1.386    26.383     0.200
     0.837    16.590     0.200
     1.291    24.449     0.200
     1.395    26.211     0.200
     0.837    16.648     0.200
     0.912    18.117     0.200
     0.935    18.750     0.200
     1.075    20.977     0.200
     1.120    21.590     0.200
     1.182    22.309     0.200
     1.268    24.477     0.200
     0.984    19.062     0.200
     1.229    23.451     0.200
     1.288    25.031     0.200
     1.357    25.332     0.200
     0.850    16.855     0.200
     1.016    20.133     0.200
     1.087    21.355     0.200
     1.155    22.266     0.200
     1.163    22.355     0.200
     1.168    21.945     0.200
     1.212    23.316     0.200
     1.228    23.773     0.200
     1.297    25.016     0.200
     1.351    25.824     0.200
     0.999    19.195     0.200
     1.163    22.055     0.200
     0.986    19.000     0.200
     1.171    21.883     0.200
     1.229    22.852     0.200
     0.984    19.242     0.200
     1.018    19.252     0.200
     1.169    22.402     0.200
     1.211    22.301     0.200
     1.228    23.531     0.200
     1.243    23.680     0.200
     1.263    24.164     0.200
     1.426    27.000     0.200
     1.142    22.096     0.200
     1.199    23.006     0.200
     1.231    23.436     0.200
     1.474    28.025     0.200
     1.509    28.727     0.200
     1.531    28.477     0.200
     1.307    27.535     0.200
     3.698    59.896     0.200
     3.698    59.795     0.200
     4.545    70.795     0.200
     5.097    78.295     0.200
     5.097    78.896     0.200
     5.148    79.795     0.200
     5.338    82.396     0.200
     5.338    82.096     0.200
     5.578    85.896     0.200
     5.578    84.996     0.200
     6.578    97.896     0.200
     6.578    98.195     0.200
     7.241   107.795     0.200
     7.241   106.996     0.200
     7.291   108.496     0.200
     7.291   106.996     0.200
    16.849   236.570     0.200
     1.103    20.922     0.200
     1.353    26.023     0.200
     1.152    22.380     0.200
     1.233    23.550     0.200
     0.861    17.020     0.200
     1.018    19.566     0.200
     1.171    22.297     0.200
     1.223    23.059     0.200
     2.637    42.266     0.200
     3.055    50.172     0.200
     3.229    50.375     0.200
     5.010    76.070     0.200
     5.204    78.773     0.200
     5.258    77.781     0.200
     5.854    87.469     0.200
     6.190    89.562     0.200
     6.410    94.773     0.200
     6.455    95.070     0.200
     6.649    97.672     0.200
     6.871    99.875     0.200
     7.889   113.875     0.200
     8.272   118.430     0.200
     8.577   122.672     0.200
    16.267   225.594     0.200
     0.809    16.352     0.200
     0.919    19.463     0.200
     0.995    20.803     0.200
     1.182    21.762     0.200
     2.274    36.682     0.200
     2.652    45.432     0.200
     2.799    44.002     0.200
     5.576    83.143     0.200
     5.728    85.441     0.200
     6.423    94.143     0.200
     7.028   102.441     0.200
     7.214   104.742     0.200
     7.227   105.043     0.200
     7.461   107.441     0.200
     7.814   112.742     0.200
     8.453   120.643     0.200
     8.439   120.412     0.200
    10.869   153.861     0.200
    11.053   157.861     0.200
    11.373   160.592     0.200
    13.762   192.271     0.200
    13.762   192.123     0.200
    16.432   228.182     0.200
    16.466   227.492     0.200
     1.116    21.916     0.200
     1.169    22.027     0.200
     1.183    22.527     0.200
     1.201    23.076     0.200
     1.201    23.566     0.200
     0.903    18.188     0.200
     1.085    20.836     0.200
     1.059    21.008     0.200
     1.205    23.578     0.200
     1.398    26.781     0.200
     0.841    16.600     0.200
     1.050    20.370     0.200
     1.085    20.890     0.200
     1.177    22.600     0.200
     1.186    22.950     0.200
     1.264    24.280     0.200
     1.278    24.690     0.200
     1.316    25.350     0.200
     1.382    26.670     0.200
     1.015    19.970     0.200
     2.698    44.670     0.200
     3.329    53.370     0.200
     4.060    62.410     0.200
     4.101    63.250     0.200
     4.305    69.180     0.200
     4.647    70.760     0.200
     5.030    74.920     0.200
     5.341    81.110     0.200
     5.664    85.240     0.200
     5.896    88.610     0.200
     5.942    89.010     0.200
     5.968    89.060     0.200
     5.968    89.400     0.200
     6.135    91.110     0.200
     6.148    91.210     0.200
     6.362    94.810     0.200
     6.719    99.410     0.200
     7.375   107.210     0.200
     7.385   106.220     0.200
     7.772   112.440     0.200
     8.034   117.210     0.200
     8.070   117.610     0.200
     8.316   119.430     0.200
     8.814   127.860     0.200
     8.921   127.250     0.200
     9.150   132.710     0.200
     9.495   136.500     0.200
     9.495   136.780     0.200
    10.367   150.510     0.200
    10.643   152.800     0.200
    11.160   157.850     0.200
    11.236   160.390     0.200
    11.284   160.680     0.200
    11.284   162.400     0.200
    11.438   163.370     0.200
    11.758   166.050     0.200
    11.756   166.130     0.200
    11.938   167.850     0.200
    11.998   170.610     0.200
    12.544   175.950     0.200
    12.625   179.800     0.200
    12.710   179.454     0.200
    12.710   179.210     0.200
    12.710   180.120     0.200
    12.710   179.730     0.200
    12.710   182.110     0.200
    12.750   182.250     0.200
    12.826   180.740     0.200
    12.826   180.419     0.200
    12.842   181.710     0.200
    12.857   180.230     0.200
    12.915   183.410     0.200
    12.994   183.450     0.200
    13.018   181.010     0.200
    13.018   180.890     0.200
    13.557   189.335     0.200
    13.893   192.840     0.200
    13.970   194.510     0.200
    13.961   193.340     0.200
    14.087   196.930     0.200
    14.211   198.640     0.200
    14.227   201.210     0.200
    14.388   199.360     0.200
    14.388   199.985     0.200
    14.388   199.800     0.200
    15.042   210.610     0.200
    16.445   228.600     0.200
    16.442   229.810     0.200
    16.444   228.360     0.200
    16.444   230.020     0.200
    16.444   230.410     0.200
    16.464   229.410     0.200
    16.464   229.694     0.200
    16.464   230.810     0.200
    16.464   229.085     0.200
    16.464   229.440     0.200
    16.464   230.810     0.200
    18.638   257.900     0.200
    18.761   259.200     0.200
    19.049   262.810     0.200
     1.313    24.773     0.200
     1.308    24.523     0.200
     1.531    28.742     0.200
     0.952    18.914     0.200
     1.080    20.945     0.200
     1.126    21.125     0.200
     1.176    21.945     0.200
     1.228    24.109     0.200
     1.265    24.055     0.200
     1.273    23.547     0.200
     1.375    25.789     0.200
     3.059    50.812     0.200
     0.718    14.596     0.200
     0.762    15.486     0.200
     0.884    17.295     0.200
     0.901    17.715     0.200
     0.987    18.785     0.200
     1.171    22.225     0.200
     1.214    23.555     0.200
     1.271    24.121     0.200
     1.322    25.031     0.200
     1.355    25.039     0.200
     0.914    18.242     0.200
     1.136    21.629     0.200
     1.326    26.281     0.200
     1.368    25.473     0.200
     1.348    25.352     0.200
     1.465    27.359     0.200
     3.215    51.910     0.200
     1.219    23.238     0.200
     1.261    23.637     0.200
     1.267    23.938     0.200
     1.181    22.477     0.200
     1.303    25.086     0.200
     1.389    26.758     0.200
     1.407    26.766     0.200
     1.412    26.898     0.200
     1.466    27.984     0.200
     2.648    45.047     0.200
     3.211    50.391     0.200
     1.204    22.852     0.200
     1.308    25.266     0.200
     1.392    27.086     0.200
     1.411    26.875     0.200
     1.416    26.656     0.200
     1.755    32.062     0.200
     2.484    45.094     0.200
     3.214    51.852     0.200
     3.786    62.234     0.200
     3.890    64.320     0.200
     4.474    69.922     0.200
     4.914    75.727     0.200
     5.104    78.727     0.200
     5.758    86.922     0.200
     6.314    94.727     0.200
     6.360    95.023     0.200
     6.553    97.727     0.200
     6.565    98.320     0.200
     6.778   101.125     0.200
     7.135   105.820     0.200
     7.793   114.227     0.200
     8.451   123.227     0.200
     8.485   123.320     0.200
    12.430   175.266     0.200
    12.430   176.203     0.200
    12.649   179.383     0.200
    14.056   196.297     0.200
    16.330   228.930     0.200
    16.330   226.789     0.200
     0.774    15.773     0.200
     0.873    17.438     0.200
     1.053    20.445     0.200
     1.115    21.234     0.200
     1.138    22.195     0.200
     1.250    23.820     0.200
     1.255    24.344     0.200
     1.294    24.453     0.200
     1.327    25.297     0.200
     1.055    20.395     0.200
     1.107    21.846     0.200
     1.169    22.904     0.200
     1.255    24.654     0.200
     1.281    25.086     0.200
     1.293    25.266     0.200
     1.360    26.105     0.200
     1.370    26.176     0.200
     1.374    26.336     0.200
     1.406    27.035     0.200
     1.229    23.477     0.200
     3.027    49.453     0.200
     2.972    49.500     0.200
     3.072    50.391     0.200
     3.085    50.430     0.200
     3.189    50.883     0.200
     3.392    55.203     0.200
     3.560    58.133     0.200
     3.598    57.797     0.200
     3.844    59.430     0.200
     4.070    64.227     0.200
     4.237    66.398     0.200
     4.792    73.703     0.200
     4.839    74.250     0.200
     5.032    76.797     0.200
     5.044    77.203     0.200
     5.006    78.609     0.200
     6.125    91.922     0.200
     7.203   104.203     0.200
     7.065   104.547     0.200
     7.723   113.641     0.200
     7.893   114.562     0.200
     7.986   116.727     0.200
     8.420   126.789     0.200
     9.715   138.180     0.200
    10.599   153.328     0.200
    10.829   154.891     0.200
    11.049   155.742     0.200
    11.906   169.930     0.200
    12.612   175.891     0.200
    12.726   178.828     0.200
    12.802   178.688     0.200
    13.115   184.742     0.200
    12.981   183.227     0.200
    13.342   188.688     0.200
    13.482   193.195     0.200
    13.482   192.969     0.200
    13.816   192.102     0.200
    15.285   215.938     0.200
    15.285   213.273     0.200
    16.858   236.164     0.200
    16.858   234.570     0.200
    17.537   242.023     0.200
    19.364   266.500     0.200
    19.829   272.781     0.200
     0.896    19.676     0.200
     1.240    22.887     0.200
     2.482    40.535     0.200
     2.582    43.754     0.200
     2.606    42.105     0.200
     2.842    47.336     0.200
     3.149    51.035     0.200
     3.267    52.066     0.200
     3.378    54.145     0.200
     4.979    76.227     0.200
     8.469   124.965     0.200
     8.499   122.637     0.200
     8.499   123.605     0.200
     9.996   142.066     0.200
    10.053   144.895     0.200
    10.278   146.766     0.200
    10.778   154.227     0.200
    10.900   154.164     0.200
    10.900   154.996     0.200
    11.203   159.996     0.200
    11.834   169.043     0.200
    12.001   169.125     0.200
    12.048   171.645     0.200
    12.048   171.145     0.200
    12.048   171.875     0.200
    12.048   171.383     0.200
    12.048   170.164     0.200
    12.414   175.156     0.200
    13.597   189.125     0.200
    13.597   190.379     0.200
    13.597   189.234     0.200
    14.903   212.066     0.200
    16.152   222.344     0.200
    16.152   223.766     0.200
    16.152   223.438     0.200
    16.152   223.176     0.200
    16.152   225.965     0.200
    17.856   244.379     0.200
    19.551   269.766     0.200
     2.539    40.627     0.200
     2.466    40.977     0.200
     2.893    45.848     0.200
     2.890    45.707     0.200
     3.006    47.297     0.200
     3.016    47.027     0.200
     3.059    49.357     0.200
     3.073    47.678     0.200
     3.174    48.928     0.200
     3.127    51.338     0.200
     3.325    52.146     0.200
     3.314    51.816     0.200
     3.319    51.928     0.200
     3.407    52.158     0.200
     3.353    53.758     0.200
     3.521    54.547     0.200
     3.828    57.146     0.200
     4.171    63.348     0.200
     4.330    66.078     0.200
     4.697    68.588     0.200
     4.724    70.547     0.200
     4.666    72.137     0.200
     4.774    71.646     0.200
     4.774    71.248     0.200
     4.740    70.697     0.200
     4.965    74.047     0.200
     4.977    74.146     0.200
     5.100    77.367     0.200
     5.203    77.248     0.200
     5.556    82.947     0.200
     5.881    84.947     0.200
     5.955    87.117     0.200
     5.955    87.498     0.200
     6.099    89.527     0.200
     6.867   100.348     0.200
     6.915   100.947     0.200
     7.668   111.047     0.200
     7.960   114.896     0.200
     8.349   123.977     0.200
     8.856   124.768     0.200
     9.355   136.348     0.200
     9.637   136.047     0.200
    10.054   147.646     0.200
    10.667   150.598     0.200
    10.667   150.047     0.200
    10.735   151.637     0.200
    11.056   154.047     0.200
    11.056   154.447     0.200
    11.448   159.938     0.200
    12.673   176.646     0.200
    12.818   177.418     0.200
    12.839   177.066     0.200
    12.968   182.457     0.200
    12.897   179.357     0.200
    13.266   184.646     0.200
    13.280   184.947     0.200
    13.493   189.748     0.200
    13.435   186.807     0.200
    13.435   185.990     0.200
    13.518   188.248     0.200
    13.578   188.916     0.200
    13.578   190.027     0.200
    13.578   189.447     0.200
    13.578   190.188     0.200
    13.578   190.848     0.200
    13.578   190.447     0.200
    13.640   189.248     0.200
    13.622   189.447     0.200
    13.746   189.428     0.200
    13.870   193.566     0.200
    14.347   200.047     0.200
    14.874   206.566     0.200
    15.171   210.848     0.200
    15.380   211.654     0.200
    15.380   210.348     0.200
    15.380   211.807     0.200
    15.605   214.646     0.200
    16.941   233.316     0.200
    16.947   235.508     0.200
    16.947   234.248     0.200
    16.947   234.547     0.200
    16.947   233.689     0.200
    16.947   232.688     0.200
    16.947   234.146     0.200
    17.465   241.967     0.200
    17.878   245.947     0.200
    19.742   268.848     0.200
    20.183   275.047     0.200
    20.366   276.447     0.200
    20.384   276.146     0.200
    20.603   279.348     0.200
     1.166    23.023     0.200
     2.574    40.723     0.200
     2.780    47.004     0.200
     3.128    51.693     0.200
     6.656   100.014     0.200
     8.783   127.023     0.200
    10.827   155.902     0.200
    10.952   157.514     0.200
    11.058   158.693     0.200
    11.164   160.584     0.200
    12.563   179.662     0.200
    13.845   195.924     0.200
    13.845   196.344     0.200
    16.275   229.002     0.200
    16.275   229.652     0.200
     2.661    42.848     0.200
     2.951    48.148     0.200
     3.276    52.498     0.200
     3.774    59.877     0.200
     4.001    62.238     0.200
     2.585    41.809     0.200
     2.642    45.039     0.200
     2.778    48.219     0.200
     2.947    48.828     0.200
     3.304    51.840     0.200
     3.345    54.367     0.200
     3.729    58.539     0.200
     3.932    60.539     0.200
     3.813    61.340     0.200
     3.923    63.309     0.200
     4.574    69.238     0.200
     4.718    74.527     0.200
     5.129    76.438     0.200
     5.176    77.141     0.200
     5.368    79.938     0.200
     5.381    80.141     0.200
     5.598    83.438     0.200
     7.268   106.340     0.200
     7.307   107.238     0.200
     7.246   104.277     0.200
     7.871   113.949     0.200
     8.055   117.270     0.200
     8.443   126.961     0.200
    10.143   144.141     0.200
    16.726   233.391     0.200
     1.220    24.135     0.200
     2.104    36.555     0.200
     2.363    40.595     0.200
     2.408    39.215     0.200
     2.423    41.084     0.200
     2.451    41.524     0.200
     2.577    42.685     0.200
     2.801    46.255     0.200
     3.155    51.435     0.200
     3.622    57.965     0.200
     4.094    65.084     0.200
     5.157    77.664     0.200
     5.314    81.324     0.200
     5.314    81.465     0.200
     5.330    81.994     0.200
     5.462    83.124     0.200
     6.002    89.064     0.200
     6.557    96.664     0.200
     6.604    97.164     0.200
     6.797   100.064     0.200
     6.809    99.965     0.200
     7.023   102.465     0.200
     7.556   109.864     0.200
     7.759   113.034     0.200
     7.759   112.505     0.200
     8.730   126.364     0.200
     8.707   127.965     0.200
     8.834   128.055     0.200
    10.262   147.524     0.200
    10.532   152.324     0.200
    10.974   158.164     0.200
    10.959   158.925     0.200
    11.099   158.005     0.200
    11.396   163.204     0.200
    11.449   162.675     0.200
    11.885   170.034     0.200
    12.212   173.064     0.200
    12.210   175.774     0.200
    12.283   172.465     0.200
    12.282   175.265     0.200
    12.282   174.208     0.200
    12.282   175.385     0.200
    12.282   172.151     0.200
    12.282   177.024     0.200
    12.282   175.164     0.200
    12.357   177.725     0.200
    12.467   178.104     0.200
    12.565   178.314     0.200
    12.565   176.937     0.200
    12.578   178.994     0.200
    12.870   178.965     0.200
    13.286   184.805     0.200
    13.873   194.390     0.200
    13.873   194.244     0.200
    14.632   206.864     0.200
    14.922   211.664     0.200
    16.243   224.824     0.200
    16.243   225.913     0.200
    16.271   226.221     0.200
    16.271   225.640     0.200
    16.271   224.904     0.200
    19.396   265.564     0.200
     1.411    26.876     0.200
     2.886    45.957     0.200
     2.894    46.026     0.200
     2.938    46.677     0.200
     2.949    43.257     0.200
     2.951    46.717     0.200
     3.022    48.997     0.200
     3.022    49.197     0.200
     3.055    48.197     0.200
     3.190    49.856     0.200
     3.205    51.046     0.200
     3.464    54.997     0.200
     3.651    57.896     0.200
     3.710    55.546     0.200
     4.311    66.096     0.200
     4.411    70.576     0.200
     4.863    73.497     0.200
     4.863    73.896     0.200
     4.914    73.677     0.200
     4.914    73.896     0.200
     4.914    74.096     0.200
     5.104    76.596     0.200
     5.104    76.697     0.200
     5.117    76.796     0.200
     5.345    79.697     0.200
     5.345    79.896     0.200
     5.991    89.997     0.200
     7.008   103.096     0.200
     7.008   103.197     0.200
     7.059   103.296     0.200
     7.059   103.596     0.200
     7.854   114.497     0.200
    10.530   150.697     0.200
    11.014   157.366     0.200
    11.728   163.296     0.200
    11.956   170.697     0.200
    12.716   177.667     0.200
    12.815   179.707     0.200
    13.406   187.197     0.200
    13.511   191.716     0.200
    13.511   190.276     0.200
    13.613   188.197     0.200
    13.732   191.096     0.200
    15.105   211.697     0.200
    16.929   233.636     0.200
    16.936   235.197     0.200
    17.599   244.707     0.200
     2.844    49.106     0.200
     3.090    51.326     0.200
     3.155    53.797     0.200
     3.523    57.227     0.200
     3.718    60.326     0.200
     4.026    65.906     0.200
     4.369    68.227     0.200
     4.541    71.866     0.200
     4.923    76.026     0.200
     4.972    76.026     0.200
     5.163    78.826     0.200
     5.399    82.927     0.200
     7.110   106.326     0.200
     7.159   103.347     0.200
     7.992   116.467     0.200
    13.429   192.921     0.200
    16.861   234.302     0.200
     2.488    40.081     0.200
     4.151    62.642     0.200
     4.781    72.941     0.200
     5.433    81.241     0.200
     5.988    89.142     0.200
     6.034    88.921     0.200
     6.034    89.941     0.200
     6.227    92.841     0.200
     6.454    94.541     0.200
     6.811    99.441     0.200
     7.194   105.021     0.200
     8.162   118.541     0.200
    11.627   163.301     0.200
    11.870   166.581     0.200
    12.789   180.291     0.200
    14.317   198.421     0.200
    16.437   228.941     0.200
    16.437   228.541     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     4.997    91.365     0.200
     2.843    53.027     0.200
     5.610   104.750     0.200
     5.849   107.750     0.200
     5.920   109.344     0.200
     3.572    66.402     0.200
     3.181    58.570     0.200
     2.940    54.312     0.200
     3.178    59.049     0.200
     2.606    48.699     0.200
     2.593    48.043     0.200
     2.972    57.461     0.200
     2.848    52.266     0.200
     2.603    47.703     0.200
     2.729    49.906     0.200
     4.521    85.906     0.200
     2.610    48.156     0.200
     2.591    48.562     0.200
     2.719    50.766     0.200
     2.745    50.874     0.200
     3.136    59.174     0.200
     2.766    50.516     0.200
     7.380   135.516     0.200
     2.780    51.668     0.200
     2.973    54.867     0.200
     3.866    72.066     0.200
     4.541    88.668     0.200
     2.952    57.250     0.200
     2.762    50.961     0.200
     3.356    62.777     0.200
     2.730    50.566     0.200
     4.901    97.037     0.200
     2.769    51.022     0.200
     2.769    54.022     0.200
     4.738    88.022     0.200
     2.565    48.699     0.200
     3.165    61.195     0.200
     3.153    59.328     0.200
     3.678    68.496     0.200
     3.253    60.465     0.200
     3.322    61.375     0.200
     3.476    64.344     0.200
     2.840    53.930     0.200
     3.001    56.762     0.200
     3.507    65.602     0.200
     3.212    60.617     0.200
     3.694    67.500     0.200
     2.822    52.770     0.200
     3.148    58.039     0.200
     2.939    56.398     0.200
     3.082    59.428     0.200
     3.207    62.188     0.200
     3.228    60.373     0.200
     6.553   123.494     0.200
     2.711    49.824     0.200
     3.362    62.824     0.200
     3.706    69.648     0.200
     3.490    65.008     0.200
     3.374    61.930     0.200
     2.844    55.617     0.200
     3.865    72.641     0.200
     3.776    70.209     0.200
     3.048    56.991     0.200
     3.821    70.734     0.200
     3.405    64.455     0.200
     3.236    59.895     0.200
     3.291    61.054     0.200
     2.738    50.027     0.200
     3.080    56.809     0.200
     2.548    46.969     0.200
     2.583    47.734     0.200
     2.883    53.076     0.200
     3.249    62.107     0.200
     3.566    68.800     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     2.514    44.047     0.200
     4.349    76.262     0.200
     2.799    49.088     0.200
     1.183    21.689     0.200
     2.669    45.689     0.200
     2.669    47.689     0.200
     1.993    35.570     0.200
     0.777    14.664     0.200
     1.337    24.179     0.200
     1.015    18.803     0.200
     1.275    23.402     0.200
     2.501    42.803     0.200
     0.982    18.160     0.200
     1.294    23.059     0.200
     2.475    42.258     0.200
     0.426     8.172     0.200
     2.145    38.367     0.200
     3.814    65.273     0.200
     1.006    18.965     0.200
     2.536    43.965     0.200
     1.027    19.468     0.200
     0.677    12.551     0.200
     0.762    13.227     0.200
     1.727    30.727     0.200
     2.135    37.523     0.200
     2.474    42.727     0.200
     0.770    14.467     0.200
     0.738    13.748     0.200
     2.068    37.148     0.200
     0.704    13.047     0.200
     0.534     9.414     0.200
     0.934    17.734     0.200
     1.103    20.000     0.200
     1.670    30.441     0.200
     1.993    36.238     0.200
     2.193    40.199     0.200
     2.623    47.000     0.200
     3.025    53.102     0.200
     1.895    35.242     0.200
     2.003    35.102     0.200
     2.181    39.242     0.200
     3.013    51.742     0.200
     0.830    14.402     0.200
     1.633    29.703     0.200
     2.019    35.953     0.200
     2.352    41.113     0.200
     1.137    19.617     0.200
     2.301    42.117     0.200
     2.645    45.516     0.200
     4.661    78.414     0.200
     1.006    19.359     0.200
     1.136    21.242     0.200
     2.033    38.242     0.200
     2.338    42.242     0.200
     2.529    43.266     0.200
     2.595    45.344     0.200
     2.721    47.742     0.200
     2.948    50.742     0.200
     2.339    42.242     0.200
     1.026    18.844     0.200
     1.135    22.461     0.200
     2.016    37.461     0.200
     2.319    43.164     0.200
     2.491    43.062     0.200
     2.533    44.820     0.200
     2.600    45.859     0.200
     2.727    47.461     0.200
     2.016    37.461     0.200
     2.321    43.164     0.200
     2.533    44.461     0.200
     2.924    50.461     0.200
     1.095    19.633     0.200
     1.184    23.133     0.200
     1.228    23.836     0.200
     1.971    37.133     0.200
     2.272    41.031     0.200
     2.532    44.133     0.200
     3.091    52.633     0.200
     3.445    58.633     0.200
     1.149    23.250     0.200
     1.153    21.047     0.200
     2.048    38.547     0.200
     2.542    44.547     0.200
     2.609    45.547     0.200
     2.734    46.344     0.200
     3.145    52.547     0.200
     5.710   100.547     0.200
     2.049    38.547     0.200
     1.020    18.672     0.200
     1.164    21.266     0.200
     1.188    24.062     0.200
     2.649    45.766     0.200
     2.776    47.766     0.200
     3.150    53.266     0.200
     0.996    19.383     0.200
     1.147    21.406     0.200
     1.149    22.203     0.200
     2.045    36.703     0.200
     2.349    42.602     0.200
     2.499    43.805     0.200
     2.537    43.703     0.200
     2.857    48.703     0.200
     2.956    51.703     0.200
     3.171    53.703     0.200
     3.339    56.703     0.200
     1.104    21.203     0.200
     2.351    42.602     0.200
     1.103    20.156     0.200
     1.911    35.156     0.200
     2.555    45.258     0.200
     2.687    46.359     0.200
     2.823    48.156     0.200
     2.716    46.156     0.200
     3.042    51.156     0.200
     2.999    51.156     0.200
     3.186    54.359     0.200
     1.024    19.938     0.200
     1.121    21.766     0.200
     2.015    36.766     0.200
     2.320    43.266     0.200
     2.484    45.664     0.200
     2.525    44.266     0.200
     2.828    49.266     0.200
     2.945    51.766     0.200
     3.142    53.766     0.200
     2.016    36.766     0.200
     2.321    43.266     0.200
     1.006    19.254     0.200
     1.167    21.374     0.200
     2.042    37.874     0.200
     2.625    46.274     0.200
     2.692    45.874     0.200
     2.752    47.474     0.200
     2.854    48.374     0.200
     3.162    53.874     0.200
     0.982    19.930     0.200
     1.226    22.549     0.200
     2.091    38.549     0.200
     2.384    42.449     0.200
     2.555    44.049     0.200
     3.055    51.549     0.200
     3.171    53.049     0.200
     3.193    54.049     0.200
     0.960    19.436     0.200
     1.122    20.555     0.200
     1.187    21.855     0.200
     2.084    37.855     0.200
     2.694    45.855     0.200
     2.560    43.855     0.200
     1.034    18.994     0.200
     1.123    22.174     0.200
     1.061    21.174     0.200
     1.988    36.174     0.200
     2.303    41.674     0.200
     2.478    42.674     0.200
     1.219    21.971     0.200
     1.262    24.471     0.200
     2.192    40.570     0.200
     2.410    41.971     0.200
     2.640    47.971     0.200
     3.056    52.471     0.200
     3.410    57.471     0.200
     1.036    19.195     0.200
     1.114    20.523     0.200
     2.308    41.824     0.200
     2.525    44.023     0.200
     2.592    44.523     0.200
     3.102    52.023     0.200
     3.130    53.523     0.200
     1.143    21.324     0.200
     1.037    18.832     0.200
     1.148    21.180     0.200
     1.128    22.281     0.200
     1.194    23.281     0.200
     2.311    41.383     0.200
     2.546    44.781     0.200
     2.484    42.781     0.200
     3.130    53.281     0.200
     1.068    19.277     0.200
     1.168    21.215     0.200
     0.995    18.855     0.200
     1.188    22.016     0.200
     2.064    37.516     0.200
     2.361    42.215     0.200
     2.663    46.617     0.200
     2.661    47.516     0.200
     2.787    50.117     0.200
     5.763    99.516     0.200
     2.064    37.516     0.200
     2.363    42.215     0.200
     2.766    50.117     0.200
     2.983    51.914     0.200
     0.198     3.305     0.200
     1.034    19.195     0.200
     0.997    18.875     0.200
     1.107    19.703     0.200
     1.154    21.102     0.200
     1.153    20.602     0.200
     2.046    37.602     0.200
     2.350    41.898     0.200
     2.613    44.602     0.200
     2.739    46.602     0.200
     2.351    40.898     0.200
     2.935    50.203     0.200
     4.717    79.602     0.200
     0.275     4.859     0.200
     1.007    19.617     0.200
     1.098    21.203     0.200
     1.202    22.859     0.200
     1.188    23.656     0.200
     2.064    36.859     0.200
     2.358    42.562     0.200
     2.689    46.859     0.200
     2.816    47.859     0.200
     3.043    53.258     0.200
     1.068    19.137     0.200
     1.146    20.676     0.200
     1.192    21.375     0.200
     1.248    24.676     0.200
     1.169    22.275     0.200
     2.301    42.576     0.200
     2.822    49.477     0.200
     3.046    52.676     0.200
     1.879    34.545     0.200
     2.303    42.576     0.200
     3.019    52.176     0.200
     1.047    20.148     0.200
     0.975    19.496     0.200
     1.093    20.668     0.200
     1.194    20.668     0.200
     2.652    45.066     0.200
     1.464    26.957     0.200
     1.796    33.340     0.200
     1.003    17.516     0.200
     1.001    19.246     0.200
     1.104    20.605     0.200
     1.118    18.605     0.200
     2.028    36.406     0.200
     2.337    43.305     0.200
     2.498    44.406     0.200
     2.690    47.406     0.200
     1.024    18.648     0.200
     1.066    20.398     0.200
     1.147    19.453     0.200
     2.027    37.250     0.200
     2.561    44.750     0.200
     2.755    49.250     0.200
     2.982    52.750     0.200
     0.276     4.793     0.200
     1.089    19.163     0.200
     1.143    20.963     0.200
     1.985    36.463     0.200
     2.674    46.463     0.200
     2.806    48.463     0.200
     3.029    51.263     0.200
     0.573    10.895     0.200
     0.859    16.344     0.200
     0.869    16.094     0.200
     0.976    18.344     0.200
     1.030    19.564     0.200
     2.043    37.094     0.200
     2.335    41.793     0.200
     2.621    44.594     0.200
     2.688    46.895     0.200
     2.816    48.895     0.200
     3.041    51.895     0.200
     4.691    80.594     0.200
     2.043    37.094     0.200
     2.337    41.793     0.200
     0.086     2.648     0.200
     0.241     3.328     0.200
     0.245     4.609     0.200
     0.292     5.617     0.200
     0.324     5.969     0.200
     0.577    10.891     0.200
     1.002    19.062     0.200
     1.070    20.250     0.200
     2.056    38.141     0.200
     0.042     2.070     0.200
     0.216     4.406     0.200
     0.268     5.203     0.200
     0.546    10.203     0.200
     0.822    14.453     0.200
     0.828    15.750     0.200
     1.023    18.484     0.200
     1.067    19.992     0.200
     1.149    21.250     0.200
     2.028    35.953     0.200
     2.328    41.656     0.200
     2.633    44.703     0.200
     2.697    45.953     0.200
     2.730    46.555     0.200
     1.512    27.422     0.200
     1.846    33.562     0.200
     2.028    35.953     0.200
     2.329    41.656     0.200
     2.730    46.953     0.200
     6.037   105.953     0.200
     0.054     2.625     0.200
     0.063     2.945     0.200
     0.223     4.430     0.200
     0.219     4.453     0.200
     0.219     4.555     0.200
     0.262     5.359     0.200
     0.292     5.594     0.200
     1.025    18.289     0.200
     1.139    20.133     0.200
     2.027    35.836     0.200
     2.327    41.734     0.200
     2.635    44.836     0.200
     2.729    46.438     0.200
     3.143    53.336     0.200
     1.513    27.242     0.200
     1.847    33.727     0.200
     2.328    41.734     0.200
     0.049     2.461     0.200
     0.065     2.617     0.200
     0.070     2.773     0.200
     0.213     4.266     0.200
     0.217     4.258     0.200
     0.262     5.219     0.200
     0.257     5.195     0.200
     0.286     5.445     0.200
     0.540    10.914     0.200
     0.816    15.117     0.200
     0.822    15.320     0.200
     1.141    19.617     0.200
     1.143    21.117     0.200
     2.692    47.617     0.200
     0.058     1.703     0.200
     0.077     2.609     0.200
     0.126     3.125     0.200
     0.249     4.719     0.200
     0.249     4.109     0.200
     0.344     6.586     0.200
     0.346     6.492     0.200
     0.366     6.828     0.200
     0.626    11.836     0.200
     0.897    16.836     0.200
     0.894    16.984     0.200
     1.060    19.188     0.200
     2.111    38.086     0.200
     2.411    42.586     0.200
     2.725    47.086     0.200
     0.077     2.727     0.200
     0.050     2.586     0.200
     0.088     2.055     0.200
     0.187     4.535     0.200
     0.224     4.055     0.200
     0.230     4.977     0.200
     0.234     4.695     0.200
     0.288     5.305     0.200
     0.293     5.805     0.200
     0.288     5.684     0.200
     0.571    11.305     0.200
     0.846    15.555     0.200
     0.852    15.555     0.200
     0.966    17.805     0.200
     1.001    18.945     0.200
     1.173    21.254     0.200
     1.490    26.695     0.200
     1.822    32.496     0.200
     0.048     2.734     0.200
     0.055     2.164     0.200
     0.072     2.953     0.200
     0.215     4.793     0.200
     0.216     4.332     0.200
     0.207     4.922     0.200
     0.262     5.043     0.200
     0.255     5.395     0.200
     0.531    10.395     0.200
     0.809    14.793     0.200
     0.816    14.793     0.200
     1.040    18.281     0.200
     1.078    20.191     0.200
     2.311    41.492     0.200
     2.714    46.395     0.200
     1.529    27.594     0.200
     1.863    34.031     0.200
     2.012    35.793     0.200
     2.312    41.492     0.200
     2.714    46.793     0.200
     2.952    49.293     0.200
     0.049     2.637     0.200
     0.082     2.746     0.200
     0.184     4.680     0.200
     0.236     4.699     0.200
     0.232     4.996     0.200
     0.292     5.508     0.200
     0.298     5.758     0.200
     0.294     5.727     0.200
     0.577    11.008     0.200
     0.857    15.508     0.200
     0.971    18.258     0.200
     2.648    45.309     0.200
     2.714    48.008     0.200
     0.088     2.871     0.200
     0.009     1.938     0.200
     0.037     2.719     0.200
     0.243     5.000     0.200
     0.246     4.777     0.200
     0.294     5.918     0.200
     0.301     5.949     0.200
     0.300     6.199     0.200
     0.578    11.449     0.200
     0.855    16.699     0.200
     0.862    16.051     0.200
     0.051     2.562     0.200
     0.063     2.516     0.200
     0.076     2.797     0.200
     0.221     4.133     0.200
     0.226     4.453     0.200
     0.248     5.297     0.200
     0.262     4.945     0.200
     0.522    10.195     0.200
     0.811    14.695     0.200
     0.802    14.945     0.200
     0.921    16.195     0.200
     1.052    18.383     0.200
     1.089    20.016     0.200
     2.562    43.695     0.200
     2.629    45.695     0.200
     2.983    50.695     0.200
     0.023     2.758     0.200
     0.143     3.781     0.200
     0.041     2.734     0.200
     0.255     5.094     0.200
     0.319     6.211     0.200
     0.326     7.008     0.200
     0.605    11.812     0.200
     0.885    16.211     0.200
     1.096    18.312     0.200
     0.037     2.547     0.200
     0.060     2.188     0.200
     0.082     2.938     0.200
     0.202     3.977     0.200
     0.207     4.250     0.200
     0.251     4.859     0.200
     0.218     5.008     0.200
     0.530    10.109     0.200
     0.810    14.859     0.200
     0.804    14.609     0.200
     1.033    18.336     0.200
     1.063    19.930     0.200
     2.315    41.609     0.200
     2.681    46.109     0.200
     2.742    47.109     0.200
     0.048     2.508     0.200
     0.050     1.969     0.200
     0.070     2.695     0.200
     0.220     4.398     0.200
     0.206     4.695     0.200
     0.254     5.047     0.200
     0.260     5.148     0.200
     0.264     4.797     0.200
     0.537    10.297     0.200
     0.820    14.898     0.200
     0.814    15.047     0.200
     0.074     2.367     0.200
     0.023     1.277     0.200
     0.050     2.258     0.200
     0.229     3.707     0.200
     0.187     4.219     0.200
     0.290     5.598     0.200
     0.568    10.699     0.200
     0.843    16.098     0.200
     0.849    15.098     0.200
     2.049    37.598     0.200
     0.044     2.594     0.200
     0.104     3.094     0.200
     0.052     1.508     0.200
     0.074     2.891     0.200
     0.208     3.859     0.200
     0.213     4.344     0.200
     0.259     5.320     0.200
     0.211     4.992     0.200
     0.259     5.070     0.200
     0.538    10.320     0.200
     0.657    13.070     0.200
     0.819    15.219     0.200
     0.813    15.070     0.200
     1.027    18.398     0.200
     2.021    37.820     0.200
     0.130     3.180     0.200
     0.158     3.562     0.200
     0.107     3.250     0.200
     0.185     3.883     0.200
     0.174     4.141     0.200
     0.177     4.062     0.200
     0.235     4.641     0.200
     0.286     6.133     0.200
     0.417     8.258     0.200
     0.564    10.562     0.200
     0.707    13.211     0.200
     0.720    13.062     0.200
     0.138     3.156     0.200
     0.096     3.000     0.200
     0.114     3.438     0.200
     0.161     3.391     0.200
     0.187     3.781     0.200
     0.163     3.875     0.200
     0.170     3.867     0.200
     0.217     3.938     0.200
     0.283     6.000     0.200
     0.424     8.438     0.200
     0.567    10.438     0.200
     0.712    13.688     0.200
     0.724    12.789     0.200
     0.137     3.766     0.200
     0.196     4.219     0.200
     0.137     3.750     0.200
     0.241     5.320     0.200
     0.215     4.758     0.200
     0.268     5.258     0.200
     0.214     5.070     0.200
     0.293     4.430     0.200
     0.304     6.117     0.200
     0.301     5.906     0.200
     0.317     6.617     0.200
     0.480     9.414     0.200
     0.644    12.617     0.200
     0.781    15.414     0.200
     0.798    15.117     0.200
     0.051     2.395     0.200
     0.111     2.914     0.200
     0.047     2.246     0.200
     0.191     3.695     0.200
     0.220     4.266     0.200
     0.265     4.695     0.200
     0.204     4.594     0.200
     0.287     5.496     0.200
     0.662    12.445     0.200
     0.824    15.297     0.200
     0.817    15.695     0.200
     0.936    16.445     0.200
     1.028    18.195     0.200
     1.069    19.855     0.200
     0.097     2.891     0.200
     0.137     3.008     0.200
     0.172     3.750     0.200
     0.216     3.680     0.200
     0.225     4.199     0.200
     0.284     5.918     0.200
     1.038    18.980     0.200
     1.251    23.180     0.200
     1.901    34.180     0.200
     0.046     2.508     0.200
     0.103     3.047     0.200
     0.050     2.547     0.200
     0.208     3.148     0.200
     0.213     4.289     0.200
     0.258     5.180     0.200
     0.260     5.648     0.200
     0.210     5.055     0.200
     0.540    10.648     0.200
     0.659    12.648     0.200
     0.820    15.648     0.200
     0.934    17.898     0.200
     0.055     2.719     0.200
     0.060     2.219     0.200
     0.084     3.238     0.200
     0.127     3.508     0.200
     0.202     4.850     0.200
     0.225     3.719     0.200
     0.231     4.809     0.200
     0.252     5.318     0.200
     0.525    10.219     0.200
     0.655    12.469     0.200
     0.815    15.219     0.200
     0.925    16.969     0.200
     1.051    19.008     0.200
     0.033     2.699     0.200
     0.034     2.469     0.200
     0.039     2.699     0.200
     0.092     3.000     0.200
     0.063     2.297     0.200
     0.200     3.898     0.200
     0.246     5.117     0.200
     0.249     4.898     0.200
     0.249     5.199     0.200
     0.221     5.039     0.200
     0.373     7.398     0.200
     0.528     9.898     0.200
     0.647    12.148     0.200
     0.802    14.398     0.200
     0.808    14.898     0.200
     1.035    18.250     0.200
     1.063    19.969     0.200
     2.502    42.598     0.200
     2.679    45.398     0.200
     0.019     2.332     0.200
     0.090     2.770     0.200
     0.148     3.230     0.200
     0.153     3.531     0.200
     0.137     3.301     0.200
     0.153     3.480     0.200
     0.163     3.230     0.200
     0.203     3.730     0.200
     0.204     3.980     0.200
     0.213     4.070     0.200
     0.291     5.949     0.200
     0.422     8.031     0.200
     0.559    10.480     0.200
     0.706    12.480     0.200
     0.717    12.980     0.200
     0.823    14.730     0.200
     1.118    20.090     0.200
     1.903    34.730     0.200
     4.574    78.230     0.200
     0.020     2.176     0.200
     0.080     2.293     0.200
     0.086     2.613     0.200
     0.139     3.145     0.200
     0.152     3.145     0.200
     0.150     3.293     0.200
     0.146     2.895     0.200
     0.163     3.094     0.200
     0.199     3.496     0.200
     0.269     5.414     0.200
     0.292     5.914     0.200
     0.422     8.094     0.200
     0.557    10.293     0.200
     0.705    14.293     0.200
     0.716    13.195     0.200
     0.822    15.895     0.200
     0.057     2.485     0.200
     0.055     1.965     0.200
     0.057     1.865     0.200
     0.127     3.206     0.200
     0.201     3.965     0.200
     0.243     4.795     0.200
     0.232     4.385     0.200
     0.200     4.625     0.200
     0.280     5.275     0.200
     0.529    10.215     0.200
     0.658    12.765     0.200
     0.818    15.965     0.200
     0.928    18.065     0.200
     0.061     2.031     0.200
     0.035     1.832     0.200
     0.113     3.002     0.200
     0.060     2.512     0.200
     0.181     3.332     0.200
     0.220     3.332     0.200
     0.224     4.473     0.200
     0.261     5.223     0.200
     0.272     5.361     0.200
     0.276     5.582     0.200
     0.300     5.662     0.200
     0.555    10.332     0.200
     0.674    13.082     0.200
     0.836    15.832     0.200
     0.104     3.043     0.200
     0.121     3.086     0.200
     0.158     3.715     0.200
     0.185     3.934     0.200
     0.190     4.406     0.200
     0.230     4.965     0.200
     0.249     4.785     0.200
     0.291     6.164     0.200
     0.409     7.715     0.200
     0.561    10.465     0.200
     0.717    12.715     0.200
     0.817    14.965     0.200
     0.079     2.578     0.200
     0.148     2.328     0.200
     0.191     3.828     0.200
     0.246     5.078     0.200
     0.282     5.588     0.200
     0.266     5.298     0.200
     0.261     5.118     0.200
     0.230     5.038     0.200
     0.543    10.028     0.200
     0.652    12.828     0.200
     0.811    15.828     0.200
     0.814    14.828     0.200
     0.932    17.928     0.200
     0.033     2.059     0.200
     0.062     1.258     0.200
     0.034     1.559     0.200
     0.055     2.449     0.200
     0.111     3.098     0.200
     0.122     3.027     0.200
     0.227     4.059     0.200
     0.232     4.430     0.200
     0.191     4.379     0.200
     0.255     5.098     0.200
     0.267     5.297     0.200
     0.275     5.559     0.200
     0.279     5.059     0.200
     0.299     5.699     0.200
     0.551    10.059     0.200
     0.675    12.660     0.200
     0.836    15.559     0.200
     0.060     1.992     0.200
     0.032     1.992     0.200
     0.036     1.492     0.200
     0.056     2.441     0.200
     0.110     3.133     0.200
     0.120     3.113     0.200
     0.189     2.742     0.200
     0.193     4.383     0.200
     0.230     4.301     0.200
     0.254     5.102     0.200
     0.266     5.301     0.200
     0.551    10.242     0.200
     0.674    13.242     0.200
     0.044     2.406     0.200
     0.122     2.406     0.200
     0.082     1.906     0.200
     0.090     1.906     0.200
     0.183     3.406     0.200
     0.157     3.895     0.200
     0.258     5.406     0.200
     0.303     6.035     0.200
     0.312     6.117     0.200
     0.577    10.406     0.200
     0.673    13.156     0.200
     0.836    15.105     0.200
     0.998    17.816     0.200
     1.075    19.906     0.200
     2.067    35.906     0.200
     2.374    42.008     0.200
     3.364    56.906     0.200
     1.799    32.215     0.200
     2.068    35.906     0.200
     2.376    42.008     0.200
     0.020     2.156     0.200
     0.048     1.859     0.200
     0.057     1.656     0.200
     0.089     2.664     0.200
     0.083     2.680     0.200
     0.112     3.109     0.200
     0.158     2.156     0.200
     0.196     3.453     0.200
     0.200     3.953     0.200
     0.221     4.938     0.200
     0.259     5.164     0.200
     0.265     5.203     0.200
     0.545    10.156     0.200
     0.657    12.859     0.200
     0.819    15.906     0.200
     0.017     2.574     0.200
     0.034     2.074     0.200
     0.111     3.125     0.200
     0.219     4.074     0.200
     0.267     5.523     0.200
     0.198     4.605     0.200
     0.277     5.625     0.200
     0.280     5.973     0.200
     0.304     6.035     0.200
     0.560    10.273     0.200
     0.677    12.824     0.200
     0.839    15.574     0.200
     0.833    15.375     0.200
     0.953    17.824     0.200
     1.009    18.953     0.200
     1.058    19.625     0.200
     2.042    38.074     0.200
     2.342    42.574     0.200
     2.700    46.074     0.200
     0.113     2.953     0.200
     0.133     3.543     0.200
     0.175     2.895     0.200
     0.226     4.426     0.200
     0.194     4.473     0.200
     0.283     5.645     0.200
     0.291     5.895     0.200
     0.279     5.426     0.200
     0.289     5.566     0.200
     0.571    11.145     0.200
     0.687    13.145     0.200
     0.844    16.645     0.200
     0.849    16.145     0.200
     0.997    19.164     0.200
     2.572    45.145     0.200
     0.015     2.547     0.200
     0.116     3.070     0.200
     0.049     2.047     0.200
     0.096     2.766     0.200
     0.163     3.297     0.200
     0.203     3.547     0.200
     0.207     4.156     0.200
     0.262     5.227     0.200
     0.261     5.297     0.200
     0.269     5.344     0.200
     0.270     5.336     0.200
     0.292     5.734     0.200
     0.550    10.297     0.200
     0.664    12.797     0.200
     0.826    15.297     0.200
     0.942    18.297     0.200
     0.019     2.102     0.200
     0.032     1.602     0.200
     0.113     2.922     0.200
     0.179     3.352     0.200
     0.221     4.102     0.200
     0.225     4.414     0.200
     0.196     4.539     0.200
     0.277     5.422     0.200
     0.304     5.883     0.200
     0.678    13.352     0.200
     0.840    15.602     0.200
     0.047     2.242     0.200
     0.066     1.742     0.200
     0.105     2.898     0.200
     0.180     3.242     0.200
     0.204     3.742     0.200
     0.209     4.070     0.200
     0.230     4.695     0.200
     0.240     4.852     0.200
     0.268     5.203     0.200
     0.220     4.844     0.200
     0.043     2.822     0.200
     0.088     2.952     0.200
     0.063     2.322     0.200
     0.177     3.322     0.200
     0.203     3.722     0.200
     0.208     3.992     0.200
     0.234     4.812     0.200
     0.243     4.992     0.200
     0.270     5.332     0.200
     0.219     4.872     0.200
     0.052     1.051     0.200
     0.029     1.352     0.200
     0.043     1.250     0.200
     0.066     2.180     0.200
     0.106     2.762     0.200
     0.111     2.562     0.200
     0.181     2.301     0.200
     0.216     3.551     0.200
     0.220     4.012     0.200
     0.203     4.340     0.200
     0.251     4.922     0.200
     0.262     5.141     0.200
     0.291     5.480     0.200
     0.051     2.195     0.200
     0.055     2.094     0.200
     0.127     3.273     0.200
     0.077     2.715     0.200
     0.170     2.945     0.200
     0.119     2.195     0.200
     0.181     4.074     0.200
     0.238     3.496     0.200
     0.239     4.766     0.200
     0.193     4.516     0.200
     0.311     5.195     0.200
     0.327     6.305     0.200
     0.336     6.555     0.200
     0.355     6.766     0.200
     1.024    19.344     0.200
     1.065    18.695     0.200
     2.403    42.797     0.200
     0.021     2.516     0.200
     0.045     2.016     0.200
     0.064     2.766     0.200
     0.103     3.016     0.200
     0.052     2.535     0.200
     0.052     2.516     0.200
     0.172     3.016     0.200
     0.111     3.516     0.200
     0.264     5.016     0.200
     0.266     5.336     0.200
     0.291     5.695     0.200
     0.391     7.645     0.200
     1.017    18.676     0.200
     1.058    19.676     0.200
     1.130    19.914     0.200
     1.178    21.715     0.200
     2.031    37.016     0.200
     2.332    41.164     0.200
     2.332    41.516     0.200
     2.626    44.516     0.200
     1.130    20.016     0.200
     1.506    26.914     0.200
     1.841    33.016     0.200
     2.032    37.016     0.200
     2.334    41.164     0.200
     0.050     2.043     0.200
     0.051     2.441     0.200
     0.032     1.742     0.200
     0.046     1.543     0.200
     0.103     3.004     0.200
     0.067     2.594     0.200
     0.183     2.543     0.200
     0.216     3.043     0.200
     0.213     4.504     0.200
     0.220     4.352     0.200
     0.204     4.621     0.200
     0.259     5.121     0.200
     0.266     6.094     0.200
     0.288     5.562     0.200
     0.382     7.074     0.200
     0.062     2.180     0.200
     0.062     2.531     0.200
     0.017     2.281     0.200
     0.035     2.082     0.200
     0.062     2.621     0.200
     0.110     3.031     0.200
     0.199     4.672     0.200
     0.213     4.582     0.200
     0.222     4.422     0.200
     0.275     5.430     0.200
     0.302     5.891     0.200
     0.399     7.922     0.200
     0.050     1.477     0.200
     0.051     2.500     0.200
     0.026     2.477     0.200
     0.046     1.977     0.200
     0.107     3.125     0.200
     0.069     2.688     0.200
     0.106     2.977     0.200
     0.176     2.477     0.200
     0.216     4.305     0.200
     0.212     2.477     0.200
     0.208     4.523     0.200
     0.207     4.805     0.200
     0.262     5.297     0.200
     0.264     5.727     0.200
     0.289     5.656     0.200
     0.387     7.508     0.200
     0.023     2.250     0.200
     0.031     2.539     0.200
     0.061     2.500     0.200
     0.070     2.750     0.200
     0.112     3.023     0.200
     0.087     2.453     0.200
     0.102     3.070     0.200
     0.208     4.094     0.200
     0.189     3.500     0.200
     0.201     3.250     0.200
     0.207     4.430     0.200
     0.216     4.508     0.200
     0.237     4.500     0.200
     0.248     4.812     0.200
     0.232     5.133     0.200
     0.342     6.602     0.200
     1.066    18.148     0.200
     1.083    20.297     0.200
     0.011     2.289     0.200
     0.076     2.820     0.200
     0.078     2.992     0.200
     0.037     2.289     0.200
     0.106     3.133     0.200
     0.066     2.883     0.200
     0.166     2.789     0.200
     0.220     4.508     0.200
     0.217     3.289     0.200
     0.209     4.570     0.200
     0.295     5.930     0.200
     0.316     6.250     0.200
     0.420     8.188     0.200
     0.059     2.047     0.200
     0.059     2.516     0.200
     0.019     2.547     0.200
     0.039     2.250     0.200
     0.116     3.188     0.200
     0.064     2.625     0.200
     0.108     3.047     0.200
     0.175     3.047     0.200
     0.219     4.398     0.200
     0.202     4.664     0.200
     0.272     5.438     0.200
     0.298     5.898     0.200
     0.396     7.906     0.200
     0.037     2.205     0.200
     0.035     1.875     0.200
     0.059     1.775     0.200
     0.095     2.725     0.200
     0.100     2.686     0.200
     0.081     2.594     0.200
     0.173     2.475     0.200
     0.207     3.945     0.200
     0.218     4.734     0.200
     0.250     4.855     0.200
     0.276     5.295     0.200
     0.050     2.098     0.200
     0.015     1.598     0.200
     0.109     2.727     0.200
     0.148     3.188     0.200
     0.160     3.547     0.200
     0.205     2.598     0.200
     0.159     3.637     0.200
     0.251     4.770     0.200
     0.262     4.746     0.200
     0.300     5.707     0.200
     0.315     5.918     0.200
     0.433     8.020     0.200
     0.032     2.555     0.200
     0.044     2.555     0.200
     0.099     3.074     0.200
     0.033     2.555     0.200
     0.090     2.955     0.200
     0.160     2.555     0.200
     0.195     3.994     0.200
     0.253     5.105     0.200
     0.246     5.045     0.200
     0.273     5.455     0.200
     0.046     2.078     0.200
     0.061     2.117     0.200
     0.029     1.617     0.200
     0.103     2.805     0.200
     0.050     1.117     0.200
     0.175     2.820     0.200
     0.213     4.094     0.200
     0.208     2.617     0.200
     0.258     5.023     0.200
     0.249     4.969     0.200
     0.053     2.062     0.200
     0.056     2.477     0.200
     0.073     2.859     0.200
     0.104     3.047     0.200
     0.042     1.461     0.200
     0.063     2.570     0.200
     0.220     3.359     0.200
     0.225     4.328     0.200
     0.249     5.062     0.200
     0.260     5.180     0.200
     0.291     5.680     0.200
     0.054     1.367     0.200
     0.054     2.379     0.200
     0.024     2.367     0.200
     0.042     1.367     0.200
     0.066     2.527     0.200
     0.108     2.867     0.200
     0.219     4.219     0.200
     0.203     4.637     0.200
     0.255     5.078     0.200
     0.265     5.227     0.200
     0.293     5.836     0.200
     0.390     7.605     0.200
     0.084     2.938     0.200
     0.120     2.227     0.200
     0.128     3.535     0.200
     0.155     3.977     0.200
     0.162     3.535     0.200
     0.136     3.488     0.200
     0.142     2.828     0.200
     0.154     3.426     0.200
     0.193     3.988     0.200
     0.210     4.426     0.200
     0.264     4.996     0.200
     0.217     4.898     0.200
     0.295     5.578     0.200
     0.298     5.977     0.200
     0.287     4.727     0.200
     0.285     5.566     0.200
     1.141    21.227     0.200
     1.935    34.727     0.200
     0.050     2.594     0.200
     0.075     2.914     0.200
     0.062     2.164     0.200
     0.067     1.664     0.200
     0.079     2.852     0.200
     0.126     3.242     0.200
     0.220     4.555     0.200
     0.222     3.664     0.200
     0.228     4.445     0.200
     0.208     4.727     0.200
     0.270     5.211     0.200
     0.353     6.938     0.200
     0.020     2.345     0.200
     0.104     2.845     0.200
     0.066     2.845     0.200
     0.044     1.845     0.200
     0.053     2.415     0.200
     0.069     2.545     0.200
     0.215     4.165     0.200
     0.207     4.615     0.200
     0.267     5.245     0.200
     0.293     5.565     0.200
     0.393     7.615     0.200
     1.058    19.905     0.200
     2.333    43.045     0.200
     0.047     2.410     0.200
     0.049     1.559     0.200
     0.072     2.680     0.200
     0.105     2.938     0.200
     0.210     3.559     0.200
     0.215     4.230     0.200
     0.209     4.707     0.200
     0.249     4.969     0.200
     0.259     5.090     0.200
     0.286     5.379     0.200
     0.383     7.367     0.200
     2.024    35.559     0.200
     2.324    41.660     0.200
     2.557    43.559     0.200
     0.014     0.574     0.200
     0.059     1.176     0.200
     0.057     2.355     0.200
     0.068     2.406     0.200
     0.103     2.688     0.200
     0.215     4.027     0.200
     0.211     3.176     0.200
     0.205     4.426     0.200
     0.264     5.156     0.200
     0.273     5.367     0.200
     0.298     5.754     0.200
     0.029     1.094     0.200
     0.035     2.273     0.200
     0.052     2.891     0.200
     0.069     1.992     0.200
     0.087     2.602     0.200
     0.108     2.805     0.200
     0.225     4.523     0.200
     0.235     4.633     0.200
     0.205     4.594     0.200
     0.205     3.094     0.200
     0.211     3.953     0.200
     0.354     6.594     0.200
     0.009     1.562     0.200
     0.041     1.859     0.200
     0.077     0.859     0.200
     0.073     2.672     0.200
     0.103     2.832     0.200
     0.070     2.691     0.200
     0.205     4.461     0.200
     0.214     3.762     0.200
     0.216     4.230     0.200
     0.286     5.672     0.200
     0.294     5.781     0.200
     0.314     6.051     0.200
     0.390     6.961     0.200
     1.039    19.199     0.200
     1.151    21.461     0.200
     2.059    36.961     0.200
     2.361    41.660     0.200
     1.504    28.160     0.200
     1.813    32.750     0.200
     0.009     0.312     0.200
     0.010     2.195     0.200
     0.060     1.516     0.200
     0.087     2.438     0.200
     0.088     1.914     0.200
     0.109     2.773     0.200
     0.180     2.914     0.200
     0.182     3.914     0.200
     0.186     3.438     0.200
     0.222     4.438     0.200
     0.227     4.422     0.200
     0.247     4.602     0.200
     0.244     5.156     0.200
     0.331     5.914     0.200
     0.036     2.408     0.200
     0.038     0.848     0.200
     0.030     1.348     0.200
     0.062     1.948     0.200
     0.090     2.718     0.200
     0.086     2.778     0.200
     0.191     3.948     0.200
     0.194     3.148     0.200
     0.199     3.878     0.200
     0.224     5.008     0.200
     0.248     4.988     0.200
     0.255     5.038     0.200
     0.277     5.268     0.200
     0.357     6.448     0.200
     1.051    19.448     0.200
     2.020    35.948     0.200
     2.323    42.248     0.200
     0.029     0.499     0.200
     0.062     2.209     0.200
     0.035     0.499     0.200
     0.078     1.999     0.200
     0.057     2.249     0.200
     0.112     2.779     0.200
     0.118     2.679     0.200
     0.186     2.499     0.200
     0.194     4.199     0.200
     0.220     4.499     0.200
     0.228     4.159     0.200
     0.257     4.909     0.200
     0.268     5.009     0.200
     0.299     5.659     0.200
     0.050     0.176     0.200
     0.050     2.234     0.200
     0.065     2.176     0.200
     0.046     1.176     0.200
     0.107     2.824     0.200
     0.105     2.707     0.200
     0.070     2.375     0.200
     0.175     2.426     0.200
     0.211     3.176     0.200
     0.207     4.176     0.200
     0.215     4.125     0.200
     0.207     4.504     0.200
     0.253     4.855     0.200
     0.263     5.074     0.200
     0.264     6.176     0.200
     0.030     2.109     0.200
     0.090     1.203     0.200
     0.142     1.703     0.200
     0.144     3.266     0.200
     0.158     3.203     0.200
     0.184     4.000     0.200
     0.188     3.930     0.200
     0.119     3.047     0.200
     0.243     3.453     0.200
     0.291     5.703     0.200
     0.302     5.664     0.200
     0.317     6.211     0.200
     0.337     6.531     0.200
     0.378     7.234     0.200
     0.025     1.719     0.200
     0.018     1.719     0.200
     0.076     2.580     0.200
     0.076     2.660     0.200
     0.054     2.500     0.200
     0.086     2.520     0.200
     0.133     3.350     0.200
     0.117     3.059     0.200
     0.190     4.439     0.200
     0.220     4.520     0.200
     0.278     5.510     0.200
     0.289     5.639     0.200
     0.412     7.930     0.200
     0.048     2.598     0.200
     0.158     3.117     0.200
     0.159     3.758     0.200
     0.114     3.527     0.200
     0.172     3.816     0.200
     0.202     4.547     0.200
     0.198     4.426     0.200
     0.300     6.316     0.200
     0.312     6.207     0.200
     0.336     6.695     0.200
     0.356     7.027     0.200
     0.465     9.035     0.200
     0.055     1.617     0.200
     0.036     2.359     0.200
     0.096     1.418     0.200
     0.149     3.020     0.200
     0.151     3.508     0.200
     0.165     3.719     0.200
     0.191     4.348     0.200
     0.194     4.207     0.200
     0.114     3.289     0.200
     0.248     3.469     0.200
     0.297     6.219     0.200
     0.308     5.949     0.200
     0.323     6.469     0.200
     0.343     6.617     0.200
     0.365     7.719     0.200
     0.385     7.398     0.200
     0.116     3.570     0.200
     0.115     3.141     0.200
     0.091     2.240     0.200
     0.124     3.580     0.200
     0.226     4.891     0.200
     0.198     4.529     0.200
     0.252     5.240     0.200
     0.313     6.330     0.200
     0.300     5.930     0.200
     0.049     0.957     0.200
     0.049     2.227     0.200
     0.026     1.355     0.200
     0.047     1.656     0.200
     0.106     2.879     0.200
     0.105     2.688     0.200
     0.071     2.336     0.200
     0.175     2.457     0.200
     0.210     3.457     0.200
     0.207     3.957     0.200
     0.214     4.066     0.200
     0.208     4.496     0.200
     0.252     4.898     0.200
     0.288     5.527     0.200
     0.048     2.344     0.200
     0.029     1.254     0.200
     0.048     1.555     0.200
     0.103     2.906     0.200
     0.071     2.496     0.200
     0.106     2.855     0.200
     0.177     2.555     0.200
     0.210     3.355     0.200
     0.215     4.156     0.200
     0.207     4.055     0.200
     0.249     5.043     0.200
     0.259     4.953     0.200
     0.208     4.574     0.200
     0.018     1.844     0.200
     0.074     2.406     0.200
     0.079     1.844     0.200
     0.092     2.645     0.200
     0.055     1.445     0.200
     0.083     2.586     0.200
     0.144     3.305     0.200
     0.148     2.445     0.200
     0.203     2.344     0.200
     0.205     4.016     0.200
     0.216     4.855     0.200
     0.297     5.887     0.200
     0.291     5.785     0.200
     0.066     0.885     0.200
     0.124     2.186     0.200
     0.149     3.365     0.200
     0.135     2.285     0.200
     0.153     3.195     0.200
     0.165     3.334     0.200
     0.143     3.244     0.200
     0.211     3.895     0.200
     0.225     4.285     0.200
     0.229     4.135     0.200
     0.227     4.135     0.200
     0.022     0.707     0.200
     0.040     1.506     0.200
     0.091     3.207     0.200
     0.091     1.606     0.200
     0.110     2.917     0.200
     0.152     3.667     0.200
     0.164     2.207     0.200
     0.212     4.207     0.200
     0.224     4.336     0.200
     0.222     3.606     0.200
     0.199     4.437     0.200
     0.289     5.707     0.200
     0.299     5.887     0.200
     0.307     5.977     0.200
     0.328     6.296     0.200
     0.401     6.707     0.200
     2.073    37.707     0.200
     0.057     1.852     0.200
     0.048     1.750     0.200
     0.065     1.352     0.200
     0.083     2.781     0.200
     0.107     2.953     0.200
     0.182     2.852     0.200
     0.205     3.852     0.200
     0.211     4.121     0.200
     0.219     4.703     0.200
     0.229     4.672     0.200
     0.250     5.352     0.200
     0.239     4.820     0.200
     0.268     5.082     0.200
     0.356     5.852     0.200
     1.125    22.051     0.200
     0.058     0.949     0.200
     0.099     1.750     0.200
     0.167     4.449     0.200
     0.111     3.070     0.200
     0.192     4.051     0.200
     0.197     4.051     0.200
     0.251     3.199     0.200
     0.300     5.449     0.200
     0.311     5.777     0.200
     0.324     6.277     0.200
     0.345     6.688     0.200
     0.387     7.320     0.200
     0.046     2.516     0.200
     0.022     1.305     0.200
     0.055     2.805     0.200
     0.110     2.883     0.200
     0.104     2.305     0.200
     0.120     3.305     0.200
     0.193     4.145     0.200
     0.200     4.066     0.200
     0.198     4.035     0.200
     0.197     3.805     0.200
     0.226     4.555     0.200
     0.249     5.156     0.200
     0.036     1.328     0.200
     0.063     2.477     0.200
     0.108     2.844     0.200
     0.175     2.727     0.200
     0.211     4.477     0.200
     0.220     4.234     0.200
     0.200     4.539     0.200
     0.276     5.328     0.200
     0.383     6.727     0.200
     1.122    20.727     0.200
     1.159    21.727     0.200
     2.042    36.727     0.200
     2.342    41.828     0.200
     0.046     1.541     0.200
     0.050     1.240     0.200
     0.073     2.561     0.200
     0.185     3.141     0.200
     0.212     4.131     0.200
     0.205     4.141     0.200
     0.208     3.641     0.200
     0.210     4.631     0.200
     0.259     5.021     0.200
     0.250     4.930     0.200
     0.285     5.420     0.200
     0.369     6.641     0.200
     0.385     7.281     0.200
     0.007     2.092     0.200
     0.037     1.092     0.200
     0.065     2.711     0.200
     0.069     2.791     0.200
     0.075     1.791     0.200
     0.166     3.291     0.200
     0.208     4.791     0.200
     0.202     4.791     0.200
     0.215     3.291     0.200
     0.218     4.502     0.200
     0.275     5.480     0.200
     0.284     5.602     0.200
     0.307     5.881     0.200
     0.410     7.861     0.200
     1.113    20.291     0.200
     2.563    44.791     0.200
     2.696    46.791     0.200
     0.224     4.760     0.200
     0.291     5.469     0.200
     0.296     5.568     0.200
     0.427     7.939     0.200
     1.090    19.879     0.200
     2.365    42.379     0.200
     0.019     1.465     0.200
     0.026     2.266     0.200
     0.055     2.477     0.200
     0.082     2.164     0.200
     0.081     2.625     0.200
     0.089     3.266     0.200
     0.167     3.266     0.200
     0.189     4.457     0.200
     0.220     4.266     0.200
     0.231     4.527     0.200
     0.285     5.566     0.200
     0.295     5.727     0.200
     0.321     6.254     0.200
     0.419     8.234     0.200
     1.108    19.266     0.200
     0.033     1.812     0.200
     0.030     2.423     0.200
     0.036     1.913     0.200
     0.070     2.812     0.200
     0.095     2.853     0.200
     0.156     3.013     0.200
     0.191     3.833     0.200
     0.245     4.873     0.200
     0.232     5.203     0.200
     0.270     5.383     0.200
     0.056     2.414     0.200
     0.061     2.625     0.200
     0.026     1.625     0.200
     0.098     2.852     0.200
     0.137     2.523     0.200
     0.137     3.453     0.200
     0.148     3.023     0.200
     0.183     3.523     0.200
     0.176     3.523     0.200
     0.186     3.602     0.200
     0.248     4.273     0.200
     0.234     4.945     0.200
     0.275     5.473     0.200
     0.291     5.754     0.200
     0.020     0.754     0.200
     0.059     1.953     0.200
     0.059     1.754     0.200
     0.063     2.254     0.200
     0.176     3.754     0.200
     0.172     3.664     0.200
     0.180     3.254     0.200
     0.201     4.395     0.200
     0.211     4.254     0.200
     0.216     3.254     0.200
     0.261     5.035     0.200
     0.298     5.543     0.200
     0.084     2.977     0.200
     0.036     2.078     0.200
     0.089     2.578     0.200
     0.101     3.199     0.200
     0.131     2.527     0.200
     0.117     3.477     0.200
     0.185     4.246     0.200
     0.192     3.176     0.200
     0.194     4.098     0.200
     0.265     5.277     0.200
     0.232     5.438     0.200
     0.302     6.016     0.200
     0.315     6.156     0.200
     0.375     7.137     0.200
     1.203    21.277     0.200
     2.375    42.277     0.200
     2.772    49.777     0.200
     1.527    27.578     0.200
     2.376    42.277     0.200
     3.650    61.879     0.200
     0.044     2.305     0.200
     0.031     1.395     0.200
     0.075     2.543     0.200
     0.177     3.863     0.200
     0.174     2.645     0.200
     0.177     3.945     0.200
     0.187     3.395     0.200
     0.207     3.195     0.200
     0.204     3.895     0.200
     0.247     4.613     0.200
     0.212     4.613     0.200
     0.258     6.145     0.200
     0.282     5.113     0.200
     0.366     6.895     0.200
     0.363     6.746     0.200
     0.037     1.703     0.200
     0.071     2.203     0.200
     0.080     2.656     0.200
     0.085     1.906     0.200
     0.105     2.859     0.200
     0.127     2.203     0.200
     0.125     2.203     0.200
     0.116     3.109     0.200
     0.179     3.906     0.200
     0.175     3.203     0.200
     0.188     3.727     0.200
     0.187     2.805     0.200
     0.259     5.203     0.200
     0.236     5.031     0.200
     0.299     5.695     0.200
     0.310     5.781     0.200
     0.369     6.766     0.200
     1.198    21.703     0.200
     2.065    37.703     0.200
     0.028     2.285     0.200
     0.050     1.984     0.200
     0.068     1.785     0.200
     0.087     2.754     0.200
     0.168     3.785     0.200
     0.181     2.734     0.200
     0.203     3.086     0.200
     0.209     4.105     0.200
     0.202     3.984     0.200
     0.190     4.195     0.200
     0.248     4.984     0.200
     0.265     5.016     0.200
     0.350     6.516     0.200
     0.353     6.484     0.200
     1.159    20.984     0.200
     2.002    35.484     0.200
     2.302    40.984     0.200
     2.546    43.484     0.200
     0.028     1.652     0.200
     0.032     2.051     0.200
     0.054     2.051     0.200
     0.049     1.852     0.200
     0.068     1.949     0.200
     0.104     2.742     0.200
     0.087     2.582     0.200
     0.167     3.641     0.200
     0.180     3.051     0.200
     0.208     3.980     0.200
     0.202     4.051     0.200
     0.208     3.879     0.200
     0.189     4.082     0.200
     0.201     4.051     0.200
     0.265     5.121     0.200
     0.350     6.352     0.200
     0.013     1.875     0.200
     0.075     2.496     0.200
     0.076     2.074     0.200
     0.078     1.875     0.200
     0.049     2.375     0.200
     0.078     2.676     0.200
     0.154     2.574     0.200
     0.142     3.633     0.200
     0.147     3.074     0.200
     0.198     3.574     0.200
     0.210     4.113     0.200
     0.313     5.895     0.200
     0.108     2.842     0.200
     0.065     2.542     0.200
     0.049     3.072     0.200
     0.114     3.481     0.200
     0.095     2.542     0.200
     0.184     4.382     0.200
     0.247     5.352     0.200
     0.251     5.342     0.200
     0.248     5.572     0.200
     0.255     4.342     0.200
     0.285     5.842     0.200
     0.291     5.872     0.200
     0.323     6.382     0.200
     0.325     5.342     0.200
     0.423     8.102     0.200
     0.041     2.566     0.200
     0.044     1.867     0.200
     0.083     2.756     0.200
     0.026     1.967     0.200
     0.063     2.367     0.200
     0.165     3.906     0.200
     0.090     2.855     0.200
     0.153     2.316     0.200
     0.190     3.467     0.200
     0.194     3.797     0.200
     0.194     3.916     0.200
     0.185     4.066     0.200
     0.168     3.566     0.200
     0.247     5.066     0.200
     0.281     5.557     0.200
     0.357     6.367     0.200
     1.173    21.066     0.200
     2.331    42.367     0.200
     2.606    44.566     0.200
     2.332    42.367     0.200
     2.927    51.566     0.200
     2.983    50.967     0.200
     3.503    59.467     0.200
     7.339   127.566     0.200
     0.023     1.443     0.200
     0.024     2.232     0.200
     0.046     1.443     0.200
     0.072     1.543     0.200
     0.094     2.473     0.200
     0.094     2.562     0.200
     0.169     2.943     0.200
     0.179     3.664     0.200
     0.192     3.244     0.200
     0.198     3.654     0.200
     0.011     1.475     0.200
     0.084     1.475     0.200
     0.171     1.975     0.200
     0.187     2.975     0.200
     0.230     4.475     0.200
     1.160    21.475     0.200
     1.144    19.475     0.200
     0.567    11.037     0.200
     0.916    15.637     0.200
     0.779    16.338     0.200
     1.756    31.537     0.200
     1.943    36.037     0.200
     2.055    36.037     0.200
     0.535    11.022     0.200
     2.820    48.022     0.200
     4.359    73.922     0.200
     0.688    12.936     0.200
     0.944    17.336     0.200
     1.632    31.336     0.200
     2.308    41.836     0.200
     1.071    19.193     0.200
     1.168    21.193     0.200
     1.262    22.894     0.200
     2.429    43.793     0.200
     2.651    45.594     0.200
     3.036    52.483     0.200
     5.493    96.193     0.200
     0.617    11.551     0.200
     1.135    22.752     0.200
     2.197    38.441     0.200
     2.280    40.252     0.200
     2.468    43.621     0.200
     0.773    14.992     0.200
     0.825    15.391     0.200
     1.070    21.992     0.200
     1.715    30.391     0.200
     2.374    41.992     0.200
     2.612    46.391     0.200
     0.997    19.199     0.200
     0.442     8.096     0.200
     0.697    12.496     0.200
     1.273    23.496     0.200
     1.760    32.195     0.200
     1.949    35.096     0.200
     0.626    11.438     0.200
     1.718    32.633     0.200
     2.625    44.836     0.200
     2.686    46.297     0.200
     2.793    47.234     0.200
     4.978    87.734     0.200
     0.609    10.578     0.200
     0.950    17.977     0.200
     1.469    28.797     0.200
     2.187    38.957     0.200
     2.839    49.477     0.200
     0.610    11.465     0.200
     2.599    45.965     0.200
     3.803    68.004     0.200
     4.737    83.965     0.200
     0.547     9.930     0.200
     0.845    15.430     0.200
     1.746    32.430     0.200
     1.950    36.330     0.200
     2.175    40.230     0.200
     2.672    45.629     0.200
     2.806    48.520     0.200
     3.012    51.869     0.200
     3.007    51.029     0.200
     3.052    53.811     0.200
     3.173    55.510     0.200
     0.486     9.497     0.200
     0.677    13.507     0.200
     0.850    15.197     0.200
     0.850    15.677     0.200
     1.164    19.397     0.200
     1.969    34.897     0.200
     2.513    42.897     0.200
     0.209     4.798     0.200
     1.118    20.008     0.200
     1.929    34.538     0.200
     2.245    38.508     0.200
     2.444    42.758     0.200
     2.627    45.008     0.200
     0.269     5.371     0.200
     1.311    22.762     0.200
     2.181    39.980     0.200
     2.576    44.461     0.200
     0.860    15.320     0.200
     2.762    48.039     0.200
     3.385    59.375     0.200
     3.548    61.258     0.200
     0.677    11.797     0.200
     1.109    20.969     0.200
     1.207    23.672     0.200
     1.995    35.969     0.200
     2.763    47.945     0.200
     3.006    50.969     0.200
     3.117    52.242     0.200
     0.388     7.406     0.200
     0.956    17.566     0.200
     2.085    38.027     0.200
     2.451    45.246     0.200
     0.257     5.464     0.200
     0.853    16.238     0.200
     1.602    29.488     0.200
     2.869    51.969     0.200
     0.196     3.898     0.200
     0.177     3.898     0.200
     2.180    39.898     0.200
     0.465     8.773     0.200
     2.387    41.773     0.200
     2.795    47.623     0.200
     0.608    10.961     0.200
     0.668    12.223     0.200
     1.614    29.973     0.200
     1.759    34.062     0.200
     2.072    36.859     0.200
     2.157    37.961     0.200
     2.332    41.961     0.200
     0.685    12.344     0.200
     1.724    31.363     0.200
     1.866    35.743     0.200
     2.219    38.833     0.200
     2.582    45.323     0.200
     2.719    46.943     0.200
     0.521     8.994     0.200
     0.624    11.994     0.200
     1.246    22.193     0.200
     1.743    31.594     0.200
     2.137    40.033     0.200
     2.819    48.494     0.200
     2.042    35.062     0.200
     3.610    62.367     0.200
     0.885    16.273     0.200
     0.368     6.586     0.200
     1.003    17.586     0.200
     1.634    30.586     0.200
     1.765    32.486     0.200
     1.874    34.887     0.200
     1.988    35.486     0.200
     0.525    10.766     0.200
     2.254    39.426     0.200
     0.408     6.949     0.200
     0.510    10.449     0.200
     2.288    40.418     0.200
     0.675    12.461     0.200
     0.627    12.109     0.200
     0.605    12.789     0.200
     1.179    20.828     0.200
     0.577    11.230     0.200
     0.643    11.160     0.200
     1.303    24.090     0.200
     0.327     6.488     0.200
     1.350    24.129     0.200
     0.653    12.070     0.200
     0.530     8.816     0.200
     0.658    12.668     0.200
     2.142    39.828     0.200
     0.783    15.027     0.200
     0.676    12.480     0.200
     1.564    30.309     0.200
     2.269    41.582     0.200
     2.353    41.379     0.200
     2.442    45.480     0.200
     2.185    38.641     0.200
     4.735    80.844     0.200
     0.552    11.303     0.200
     0.575    10.662     0.200
     0.649    13.602     0.200
     0.957    17.432     0.200
     1.087    19.922     0.200
     1.585    30.842     0.200
     1.857    33.912     0.200
     2.290    40.133     0.200
     2.627    45.092     0.200
     2.819    47.582     0.200
     2.893    49.602     0.200
     2.983    49.781     0.200
     3.145    56.133     0.200
     3.275    56.803     0.200
     0.476     8.051     0.200
     2.103    37.600     0.200
     3.777    67.350     0.200
     1.761    32.645     0.200
     1.761    34.164     0.200
     3.428    57.965     0.200
     0.241     5.113     0.200
     1.278    22.301     0.200
     1.649    29.562     0.200
     1.913    33.562     0.200
     2.583    43.281     0.200
     0.602    11.459     0.200
     0.811    15.279     0.200
     0.912    16.770     0.200
     1.679    30.850     0.200
     2.631    44.979     0.200
     2.107    36.438     0.200
     3.790    65.828     0.200
     1.477    27.188     0.200
     2.091    36.938     0.200
     0.427     8.930     0.200
     0.851    16.392     0.200
     0.956    16.621     0.200
     1.367    26.472     0.200
     2.345    40.812     0.200
     0.958    18.879     0.200
     1.789    33.338     0.200
     2.435    41.832     0.200
     2.025    36.984     0.200
     0.718    14.652     0.200
     0.839    16.430     0.200
     1.313    23.621     0.200
     1.565    30.723     0.200
     1.750    31.191     0.200
     1.979    35.590     0.200
     2.080    37.191     0.200
     0.210     4.859     0.200
     1.273    21.619     0.200
     1.933    34.840     0.200
     2.221    40.020     0.200
     2.238    39.080     0.200
     0.887    16.520     0.200
     0.943    18.330     0.200
     1.199    22.141     0.200
     1.623    29.801     0.200
     1.812    32.740     0.200
     2.047    35.951     0.200
     2.725    46.240     0.200
     0.604    10.703     0.200
     0.673    13.750     0.200
     0.720    12.641     0.200
     0.969    18.328     0.200
     0.961    18.891     0.200
     1.335    24.422     0.200
     2.212    39.500     0.200
     1.115    20.375     0.200
     2.238    38.465     0.200
     0.641    11.844     0.200
     2.237    39.172     0.200
     0.655    12.324     0.200
     0.957    17.645     0.200
     1.183    20.527     0.200
     1.504    26.395     0.200
     1.591    29.055     0.200
     2.115    36.875     0.200
     0.802    15.281     0.200
     1.553    28.898     0.200
     2.719    46.125     0.200
     0.325     6.242     0.200
     1.819    33.742     0.200
     2.518    45.766     0.200
     0.484     9.125     0.200
     2.886    49.854     0.200
     0.924    18.203     0.200
     3.635    65.801     0.200
     1.232    23.969     0.200
     2.126    38.195     0.200
     2.126    39.289     0.200
     0.949    19.602     0.200
     0.949    19.414     0.200
     1.346    23.430     0.200
     1.797    33.586     0.200
     2.472    43.633     0.200
     0.606    10.828     0.200
     0.707    13.727     0.200
     0.562    11.129     0.200
     2.183    37.129     0.200
     0.655    11.914     0.200
     0.804    14.680     0.200
     1.496    28.594     0.200
     1.982    35.859     0.200
     1.416    26.707     0.200
     1.507    28.359     0.200
     1.742    32.457     0.200
     2.442    42.719     0.200
     2.494    42.879     0.200
     0.979    18.602     0.200
     1.411    26.898     0.200
     1.504    28.422     0.200
     1.773    32.531     0.200
     2.471    42.781     0.200
     2.548    44.719     0.200
     0.219     4.453     0.200
     0.240     4.883     0.200
     0.317     6.164     0.200
     0.338     6.516     0.200
     0.377     7.078     0.200
     0.576    10.797     0.200
     0.689    12.914     0.200
     0.689    13.258     0.200
     0.889    17.227     0.200
     1.032    19.508     0.200
     0.235     5.305     0.200
     0.261     5.828     0.200
     0.291     6.039     0.200
     0.363     7.375     0.200
     0.385     7.672     0.200
     0.480     9.227     0.200
     0.485     9.484     0.200
     0.618    11.977     0.200
     0.626    12.227     0.200
     0.631    12.445     0.200
     0.639    12.812     0.200
     0.648    12.469     0.200
     0.811    15.547     0.200
     0.889    17.219     0.200
     0.904    17.227     0.200
     0.104     3.246     0.200
     0.112     3.344     0.200
     0.248     5.426     0.200
     0.392     8.016     0.200
     0.419     8.266     0.200
     0.468     8.824     0.200
     0.495     9.715     0.200
     0.494     9.562     0.200
     0.596    11.613     0.200
     0.609    11.836     0.200
     0.630    11.984     0.200
     0.669    12.652     0.200
     0.804    15.273     0.200
     0.833    15.785     0.200
     0.832    16.035     0.200
     0.945    18.105     0.200
     1.035    19.504     0.200
     0.468     8.254     0.200
     0.570    12.043     0.200
     1.826    34.484     0.200
     2.790    48.586     0.200
     0.103     3.422     0.200
     0.117     3.516     0.200
     0.253     5.602     0.200
     0.420     8.516     0.200
     0.474     8.969     0.200
     0.494     9.922     0.200
     0.495     9.898     0.200
     0.599    11.531     0.200
     0.614    11.992     0.200
     0.635    12.617     0.200
     0.670    12.938     0.200
     1.032    19.211     0.200
     0.205     4.324     0.200
     0.205     4.453     0.200
     0.280     5.562     0.200
     0.330     6.645     0.200
     0.329     6.734     0.200
     0.384     7.594     0.200
     0.513     9.926     0.200
     0.539    10.516     0.200
     0.554    10.633     0.200
     0.582    11.074     0.200
     0.653    12.426     0.200
     0.685    13.004     0.200
     0.712    13.586     0.200
     0.726    13.914     0.200
     0.839    15.516     0.200
     1.062    20.215     0.200
     0.161     3.766     0.200
     0.181     4.164     0.200
     0.242     5.031     0.200
     0.305     5.945     0.200
     0.306     5.859     0.200
     0.351     6.945     0.200
     0.401     7.914     0.200
     0.424     8.398     0.200
     0.460     8.938     0.200
     0.636    12.125     0.200
     0.651    12.625     0.200
     0.783    15.398     0.200
     0.853    16.797     0.200
     0.114     3.047     0.200
     0.180     4.047     0.200
     0.199     4.141     0.200
     0.266     5.641     0.200
     0.492     9.508     0.200
     0.554    10.461     0.200
     0.702    13.109     0.200
     0.715    13.359     0.200
     0.949    18.195     0.200
     1.001    18.906     0.200
     0.998    18.859     0.200
     1.122    20.375     0.200
     1.144    21.359     0.200
     0.071     3.062     0.200
     0.235     4.891     0.200
     0.325     6.375     0.200
     0.404     8.297     0.200
     0.470     9.336     0.200
     0.611    11.758     0.200
     0.647    12.281     0.200
     0.676    12.648     0.200
     0.827    15.695     0.200
     0.863    16.367     0.200
     0.882    16.852     0.200
     0.984    18.828     0.200
     1.087    19.977     0.200
     0.248     4.969     0.200
     0.266     5.738     0.200
     0.358     6.949     0.200
     0.465     9.008     0.200
     0.717    13.527     0.200
     0.864    16.078     0.200
     0.879    16.340     0.200
     1.101    20.660     0.200
     1.536    29.000     0.200
     1.419    27.059     0.200
     1.511    28.301     0.200
     2.042    37.188     0.200
     2.105    38.410     0.200
     2.465    43.520     0.200
     2.517    43.277     0.200
     2.626    46.117     0.200
     2.918    50.051     0.200
     0.052     1.516     0.200
     0.200     3.773     0.200
     0.340     6.406     0.200
     0.339     6.172     0.200
     0.377     7.062     0.200
     0.766    14.844     0.200
     0.915    17.547     0.200
     1.197    22.125     0.200
     1.223    22.484     0.200
     1.224    22.875     0.200
     1.290    23.766     0.200
     1.584    30.195     0.200
     0.206     4.133     0.200
     0.224     4.332     0.200
     0.268     5.305     0.200
     0.307     5.734     0.200
     0.329     6.543     0.200
     0.366     7.094     0.200
     0.531    10.004     0.200
     0.560    10.441     0.200
     0.639    12.223     0.200
     0.700    13.203     0.200
     0.904    17.184     0.200
     1.226    23.055     0.200
     0.164     3.445     0.200
     0.180     3.602     0.200
     0.209     4.188     0.200
     0.356     6.703     0.200
     0.441     8.664     0.200
     0.623    12.156     0.200
     0.686    13.062     0.200
     0.692    13.234     0.200
     0.720    13.055     0.200
     0.872    16.984     0.200
     1.018    19.188     0.200
     1.022    19.453     0.200
     0.287     5.977     0.200
     0.336     6.727     0.200
     0.361     6.969     0.200
     0.362     7.133     0.200
     0.409     8.078     0.200
     0.461     8.992     0.200
     0.575    11.148     0.200
     0.600    11.281     0.200
     0.624    12.000     0.200
     0.623    11.969     0.200
     0.673    12.578     0.200
     0.763    14.547     0.200
     0.780    14.852     0.200
     0.817    15.500     0.200
     0.853    16.312     0.200
     0.881    16.852     0.200
     0.947    17.977     0.200
     0.197     3.969     0.200
     0.150     4.008     0.200
     0.231     4.969     0.200
     0.308     5.820     0.200
     0.440     8.570     0.200
     0.676    12.430     0.200
     0.830    15.820     0.200
     0.824    15.270     0.200
     1.121    21.027     0.200
     1.234    22.469     0.200
     1.495    28.270     0.200
     1.475    27.340     0.200
     1.777    32.648     0.200
     0.176     3.703     0.200
     0.159     3.746     0.200
     0.220     4.664     0.200
     0.288     5.445     0.200
     0.429     8.023     0.200
     0.660    12.273     0.200
     0.810    14.934     0.200
     0.809    15.223     0.200
     1.076    20.355     0.200
     1.104    20.883     0.200
     1.109    20.676     0.200
     0.378     7.234     0.200
     1.780    32.195     0.200
     0.192     4.531     0.200
     0.207     5.070     0.200
     0.350     7.469     0.200
     0.351     7.297     0.200
     0.430     8.539     0.200
     0.624    12.344     0.200
     0.649    12.906     0.200
     0.693    13.445     0.200
     0.747    13.750     0.200
     0.415     8.059     0.200
     0.420     7.918     0.200
     0.457     9.059     0.200
     0.556    10.457     0.200
     0.581    11.168     0.200
     0.631    11.695     0.200
     0.737    14.129     0.200
     0.841    15.668     0.200
     0.309     6.016     0.200
     0.317     5.926     0.200
     0.328     6.195     0.200
     0.355     6.836     0.200
     0.408     7.828     0.200
     0.478     9.168     0.200
     0.578    11.215     0.200
     0.677    12.625     0.200
     0.773    15.105     0.200
     0.106     3.305     0.200
     0.163     4.250     0.200
     0.259     5.633     0.200
     0.337     7.109     0.200
     0.352     7.016     0.200
     0.540    10.633     0.200
     0.598    11.914     0.200
     0.625    12.008     0.200
     0.652    12.898     0.200
     0.881    16.648     0.200
     0.136     3.467     0.200
     0.246     5.276     0.200
     0.286     5.906     0.200
     0.397     7.837     0.200
     0.461     8.807     0.200
     0.531    10.467     0.200
     0.536    10.776     0.200
     0.640    12.297     0.200
     0.639    12.417     0.200
     0.666    13.057     0.200
     0.711    13.946     0.200
     0.858    16.246     0.200
     0.205     4.391     0.200
     0.404     7.992     0.200
     0.402     7.883     0.200
     0.410     7.801     0.200
     0.474     9.051     0.200
     0.570    10.953     0.200
     0.672    12.902     0.200
     0.697    13.613     0.200
     0.727    13.691     0.200
     0.931    17.793     0.200
     1.006    18.973     0.200
     0.295     5.656     0.200
     0.299     5.664     0.200
     0.368     6.805     0.200
     0.395     7.594     0.200
     0.471     8.969     0.200
     0.500     9.672     0.200
     0.575    10.984     0.200
     0.575    10.461     0.200
     0.666    12.695     0.200
     0.774    14.516     0.200
     0.831    16.125     0.200
     0.285     5.660     0.200
     0.290     5.809     0.200
     0.331     6.660     0.200
     0.355     6.930     0.200
     0.374     7.418     0.200
     0.453     8.898     0.200
     0.478     9.348     0.200
     0.524     9.750     0.200
     0.555    10.648     0.200
     0.557    10.590     0.200
     0.585    11.070     0.200
     0.645    12.359     0.200
     0.643    12.340     0.200
     0.709    13.668     0.200
     0.737    13.980     0.200
     0.785    14.828     0.200
     0.836    15.707     0.200
     0.809    15.520     0.200
     0.810    15.559     0.200
     0.932    17.938     0.200
     1.109    21.027     0.200
     0.277     5.699     0.200
     0.285     5.887     0.200
     0.327     6.656     0.200
     0.347     6.859     0.200
     0.367     7.508     0.200
     0.449     8.969     0.200
     0.471     9.457     0.200
     0.517     9.766     0.200
     0.585    11.098     0.200
     0.639    12.098     0.200
     0.700    13.688     0.200
     0.729    14.066     0.200
     0.827    15.219     0.200
     0.178     3.828     0.200
     0.169     4.078     0.200
     0.281     5.414     0.200
     0.438     8.172     0.200
     0.652    12.141     0.200
     0.792    14.750     0.200
     0.804    14.969     0.200
     0.800    14.852     0.200
     1.208    21.953     0.200
     0.047     2.156     0.200
     0.078     2.977     0.200
     0.161     3.746     0.200
     0.251     5.266     0.200
     0.299     6.148     0.200
     0.317     6.336     0.200
     0.458     9.336     0.200
     0.473     9.355     0.200
     0.517    10.398     0.200
     0.569    11.207     0.200
     0.148     4.000     0.200
     0.290     5.766     0.200
     0.295     5.945     0.200
     0.290     6.062     0.200
     0.579    11.336     0.200
     0.596    11.594     0.200
     0.739    13.836     0.200
     0.745    14.031     0.200
     1.013    18.922     0.200
     0.235     5.883     0.200
     0.295     6.344     0.200
     0.301     6.383     0.200
     0.419     8.402     0.200
     0.444     8.723     0.200
     0.479     9.434     0.200
     0.541    10.055     0.200
     0.611    12.402     0.200
     0.670    13.203     0.200
     0.758    14.785     0.200
     0.809    15.004     0.200
     0.942    17.824     0.200
     0.125     3.320     0.200
     0.222     4.766     0.200
     0.287     5.648     0.200
     0.291     6.008     0.200
     0.308     6.305     0.200
     0.322     6.617     0.200
     0.346     6.766     0.200
     0.353     7.141     0.200
     0.426     8.445     0.200
     0.713    13.398     0.200
     0.801    15.422     0.200
     0.841    16.336     0.200
     0.192     4.469     0.200
     0.236     5.453     0.200
     0.285     5.914     0.200
     0.311     6.531     0.200
     0.347     7.250     0.200
     0.362     7.359     0.200
     0.503    10.234     0.200
     0.606    12.070     0.200
     0.680    13.594     0.200
     0.076     3.180     0.200
     0.197     4.359     0.200
     0.333     6.656     0.200
     0.401     7.859     0.200
     0.452     9.031     0.200
     0.543    10.453     0.200
     0.550    10.594     0.200
     0.607    11.672     0.200
     0.662    12.539     0.200
     0.812    15.625     0.200
     0.811    15.531     0.200
     0.822    15.781     0.200
     0.291     6.586     0.200
     0.320     7.035     0.200
     0.383     8.055     0.200
     0.397     8.186     0.200
     0.443     9.186     0.200
     0.520    10.885     0.200
     0.543    10.484     0.200
     0.538    10.545     0.200
     0.547    11.125     0.200
     0.605    12.096     0.200
     0.700    13.426     0.200
     0.715    14.105     0.200
     0.733    14.045     0.200
     0.114     3.094     0.200
     0.152     3.812     0.200
     0.222     4.609     0.200
     0.326     6.664     0.200
     0.339     6.758     0.200
     0.377     7.516     0.200
     0.527    10.414     0.200
     0.612    12.086     0.200
     0.711    13.492     0.200
     0.871    16.688     0.200
     0.775    14.836     0.200
     2.114    38.746     0.200
     2.499    42.598     0.200
     2.563    43.246     0.200
     2.563    44.266     0.200
     3.077    50.809     0.200
     0.580    11.377     0.200
     0.991    18.257     0.200
     1.689    32.107     0.200
     2.180    38.747     0.200
     2.685    45.797     0.200
     0.183     3.453     0.200
     0.267     5.117     0.200
     0.284     5.453     0.200
     0.318     6.141     0.200
     0.357     6.430     0.200
     0.779    14.461     0.200
     0.783    14.320     0.200
     0.891    17.344     0.200
     0.936    17.797     0.200
     1.042    19.773     0.200
     1.055    20.391     0.200
     0.115     2.852     0.200
     0.235     4.984     0.200
     0.252     5.164     0.200
     0.421     8.023     0.200
     0.472     9.438     0.200
     0.497     9.516     0.200
     0.496     9.891     0.200
     0.599    11.422     0.200
     0.613    12.227     0.200
     0.634    12.367     0.200
     0.671    12.742     0.200
     0.882    16.562     0.200
     0.942    17.375     0.200
     1.008    19.008     0.200
     1.239    22.672     0.200
     1.519    28.117     0.200
     1.597    29.594     0.200
     1.687    31.758     0.200
     0.180     3.957     0.200
     0.309     5.848     0.200
     0.282     5.777     0.200
     0.321     6.180     0.200
     0.322     6.180     0.200
     0.335     6.438     0.200
     0.380     7.648     0.200
     0.422     8.160     0.200
     0.488     8.957     0.200
     0.473     9.039     0.200
     0.489     9.551     0.200
     0.572    11.027     0.200
     0.912    17.020     0.200
     1.051    19.777     0.200
     1.219    22.879     0.200
     1.560    29.398     0.200
     0.219     4.313     0.200
     0.300     6.054     0.200
     0.368     6.863     0.200
     0.364     7.104     0.200
     0.442     8.644     0.200
     0.503     9.924     0.200
     0.539    10.253     0.200
     0.584    11.063     0.200
     0.737    13.804     0.200
     0.813    15.403     0.200
     1.544    29.003     0.200
     1.666    31.323     0.200
     0.792    14.493     0.200
     1.542    28.663     0.200
     1.930    35.634     0.200
     2.714    46.703     0.200
     0.154     3.734     0.200
     0.192     4.383     0.200
     0.247     5.227     0.200
     0.325     6.633     0.200
     0.325     6.188     0.200
     0.684    13.258     0.200
     0.702    13.820     0.200
     0.745    13.789     0.200
     0.749    14.266     0.200
     0.803    15.414     0.200
     0.834    16.164     0.200
     0.899    17.023     0.200
     0.965    18.320     0.200
     0.998    19.203     0.200
     1.037    19.164     0.200
     0.147     3.863     0.200
     0.155     4.000     0.200
     0.228     4.801     0.200
     0.402     8.000     0.200
     0.408     7.652     0.200
     0.448     8.430     0.200
     0.502     9.562     0.200
     0.593    11.902     0.200
     0.660    12.871     0.200
     0.681    13.172     0.200
     0.740    14.562     0.200
     0.772    14.902     0.200
     0.784    15.273     0.200
     0.799    15.023     0.200
     0.807    15.680     0.200
     0.817    15.840     0.200
     0.882    17.230     0.200
     0.937    17.953     0.200
     1.044    19.570     0.200
     0.072     2.172     0.200
     0.233     5.023     0.200
     0.277     5.398     0.200
     0.351     7.070     0.200
     0.372     7.359     0.200
     0.396     7.914     0.200
     0.418     8.414     0.200
     0.455     8.711     0.200
     0.470     8.805     0.200
     0.539    10.070     0.200
     0.545    10.422     0.200
     0.603    11.539     0.200
     0.686    12.859     0.200
     0.736    14.484     0.200
     0.765    14.500     0.200
     0.777    14.859     0.200
     0.870    16.148     0.200
     0.919    17.969     0.200
     0.977    17.820     0.200
     1.212    21.969     0.200
     1.610    30.250     0.200
     0.090     3.191     0.200
     0.194     4.203     0.200
     0.290     6.203     0.200
     0.301     6.293     0.200
     0.458     8.820     0.200
     0.511    10.082     0.200
     0.679    12.332     0.200
     0.697    13.133     0.200
     0.723    14.051     0.200
     0.105     3.125     0.200
     0.176     4.086     0.200
     0.278     5.977     0.200
     0.320     6.406     0.200
     0.450     8.797     0.200
     0.493     9.617     0.200
     0.679    12.715     0.200
     0.700    13.375     0.200
     0.717    13.555     0.200
     0.835    15.535     0.200
     0.160     3.801     0.200
     0.269     5.260     0.200
     0.255     5.891     0.200
     0.430     8.471     0.200
     0.469     9.541     0.200
     0.467     9.510     0.200
     0.476     9.650     0.200
     0.705    12.840     0.200
     0.997    18.621     0.200
     1.796    32.930     0.200
     1.955    35.941     0.200
     0.117     2.570     0.200
     0.162     3.578     0.200
     0.182     3.578     0.200
     0.270     5.562     0.200
     0.334     5.977     0.200
     0.444     8.461     0.200
     0.479     9.273     0.200
     0.665    13.078     0.200
     0.686    12.500     0.200
     0.694    13.461     0.200
     0.701    13.039     0.200
     0.711    13.672     0.200
     0.751    13.461     0.200
     0.821    15.578     0.200
     0.998    19.359     0.200
     1.217    22.727     0.200
     0.173     3.875     0.200
     0.309     5.703     0.200
     0.305     6.000     0.200
     0.288     6.000     0.200
     0.309     6.281     0.200
     0.314     6.445     0.200
     0.377     7.555     0.200
     0.404     8.016     0.200
     0.458     9.000     0.200
     0.479     8.602     0.200
     0.489     9.914     0.200
     0.559    10.820     0.200
     0.648    12.844     0.200
     0.678    12.539     0.200
     0.688    12.773     0.200
     0.658    12.719     0.200
     0.707    13.680     0.200
     0.800    14.734     0.200
     0.813    15.164     0.200
     0.827    15.414     0.200
     0.870    16.219     0.200
     0.895    16.820     0.200
     1.038    18.992     0.200
     1.087    20.305     0.200
     1.177    21.703     0.200
     1.211    22.352     0.200
     1.234    22.719     0.200
     1.678    31.289     0.200
     1.693    31.359     0.200
     1.737    32.672     0.200
     1.820    34.164     0.200
     1.835    33.883     0.200
     1.873    34.414     0.200
     1.896    34.969     0.200
     0.649    13.109     0.200
     0.816    14.922     0.200
     0.860    16.312     0.200
     2.055    38.672     0.200
     2.020    37.609     0.200
     2.450    43.234     0.200
     2.501    44.109     0.200
     3.010    51.062     0.200
     0.120     3.180     0.200
     0.157     4.191     0.200
     0.179     4.180     0.200
     0.269     6.281     0.200
     0.475    10.059     0.200
     0.546    10.770     0.200
     0.694    13.258     0.200
     0.699    13.359     0.200
     0.707    13.199     0.200
     0.753    14.191     0.200
     0.817    15.340     0.200
     0.963    17.980     0.200
     0.101     2.793     0.200
     0.221     4.684     0.200
     0.523     9.863     0.200
     0.530    10.305     0.200
     0.535    10.375     0.200
     0.559    10.535     0.200
     0.587    11.863     0.200
     0.730    14.695     0.200
     0.755    14.484     0.200
     0.801    15.773     0.200
     0.856    16.266     0.200
     0.905    17.543     0.200
     1.057    19.906     0.200
     1.079    20.375     0.200
     1.497    27.645     0.200
     0.117     3.855     0.200
     0.179     5.184     0.200
     0.256     6.016     0.200
     0.338     7.633     0.200
     0.390     8.734     0.200
     0.424     8.793     0.200
     0.413     8.984     0.200
     0.869    16.082     0.200
     0.881    16.254     0.200
     1.462    26.523     0.200
     2.035    35.973     0.200
     0.170     3.945     0.200
     0.275     5.676     0.200
     0.262     5.875     0.200
     0.359     7.176     0.200
     0.437     8.605     0.200
     0.461     8.965     0.200
     0.470     9.535     0.200
     0.478     9.273     0.200
     0.477     9.453     0.200
     0.484     9.785     0.200
     0.537    10.434     0.200
     0.701    12.984     0.200
     0.687    13.566     0.200
     0.956    18.574     0.200
     0.995    18.516     0.200
     1.051    20.023     0.200
     1.790    32.434     0.200
     2.045    36.703     0.200
     0.207     3.703     0.200
     0.234     4.875     0.200
     0.323     6.500     0.200
     0.381     7.594     0.200
     0.441     8.781     0.200
     0.523     9.852     0.200
     0.534     9.961     0.200
     0.541    10.320     0.200
     0.693    13.156     0.200
     0.797    14.844     0.200
     0.821    15.562     0.200
     0.847    16.312     0.200
     0.923    17.820     0.200
     1.006    18.609     0.200
     1.565    29.859     0.200
     0.033     2.137     0.200
     0.154     3.695     0.200
     0.320     5.727     0.200
     0.370     7.078     0.200
     0.387     7.277     0.200
     0.476     9.246     0.200
     0.461     9.098     0.200
     0.763    13.656     0.200
     1.089    20.477     0.200
     1.119    21.027     0.200
     1.277    23.785     0.200
     1.715    31.938     0.200
     1.842    34.055     0.200
     1.909    34.918     0.200
     1.966    35.727     0.200
     2.117    38.277     0.200
     0.172     3.645     0.200
     0.279     5.105     0.200
     0.300     5.953     0.200
     0.295     5.293     0.200
     0.339     6.516     0.200
     0.382     7.285     0.200
     0.440     8.605     0.200
     0.499     9.652     0.200
     0.546    10.863     0.200
     0.625    11.473     0.200
     0.666    12.035     0.200
     0.656    12.746     0.200
     0.709    14.043     0.200
     0.821    14.875     0.200
     0.816    15.605     0.200
     0.866    16.152     0.200
     0.869    16.355     0.200
     1.013    19.402     0.200
     1.070    19.645     0.200
     1.156    22.062     0.200
     1.217    22.754     0.200
     1.539    29.004     0.200
     1.548    29.195     0.200
     1.606    30.562     0.200
     1.664    31.055     0.200
     1.670    31.344     0.200
     1.816    33.953     0.200
     1.862    34.434     0.200
     0.095     5.367     0.200
     0.211     6.367     0.200
     0.286     6.637     0.200
     0.349     7.928     0.200
     0.368     8.078     0.200
     0.510    10.627     0.200
     0.526    10.486     0.200
     0.539    10.518     0.200
     0.533    10.828     0.200
     0.587    11.537     0.200
     0.628    12.477     0.200
     0.674    13.197     0.200
     1.130    21.377     0.200
     1.216    22.658     0.200
     1.455    26.057     0.200
     1.516    27.467     0.200
     1.542    28.066     0.200
     1.691    30.627     0.200
     1.926    34.307     0.200
     0.157     3.227     0.200
     0.158     3.766     0.200
     0.237     5.297     0.200
     0.297     5.836     0.200
     0.364     6.938     0.200
     0.361     7.133     0.200
     0.456     8.773     0.200
     0.494     9.281     0.200
     0.467     9.078     0.200
     0.488     9.141     0.200
     0.711    12.805     0.200
     0.734    13.406     0.200
     1.079    19.961     0.200
     1.091    20.672     0.200
     1.813    33.797     0.200
     1.822    33.961     0.200
     1.938    35.867     0.200
     0.096     2.535     0.200
     0.113     2.773     0.200
     0.142     2.613     0.200
     0.212     5.203     0.200
     0.258     5.125     0.200
     0.327     6.133     0.200
     0.420     7.582     0.200
     0.431     8.855     0.200
     0.438     8.164     0.200
     0.480     8.742     0.200
     0.671    12.484     0.200
     0.738    13.594     0.200
     1.035    19.344     0.200
     1.100    20.684     0.200
     1.134    21.035     0.200
     1.617    30.094     0.200
     1.813    33.293     0.200
     1.821    33.875     0.200
     1.833    33.652     0.200
     1.884    34.422     0.200
     2.088    38.562     0.200
     0.037     2.820     0.200
     0.280     5.859     0.200
     0.390     8.082     0.200
     0.422     8.871     0.200
     0.551    10.621     0.200
     0.560    10.379     0.200
     0.584    11.469     0.200
     0.665    12.281     0.200
     0.825    15.621     0.200
     0.826    15.270     0.200
     0.872    16.820     0.200
     0.917    17.379     0.200
     0.973    18.289     0.200
     1.008    18.832     0.200
     1.264    23.191     0.200
     1.579    29.000     0.200
     0.187     4.211     0.200
     0.226     4.859     0.200
     0.256     5.109     0.200
     0.333     6.648     0.200
     0.401     7.398     0.200
     0.501     9.625     0.200
     0.554    10.266     0.200
     0.680    12.664     0.200
     0.704    13.578     0.200
     0.826    15.578     0.200
     0.832    16.344     0.200
     0.851    16.508     0.200
     0.861    16.125     0.200
     0.876    16.758     0.200
     0.893    16.688     0.200
     0.037     1.807     0.200
     0.214     4.426     0.200
     0.537    10.096     0.200
     0.591    11.156     0.200
     0.691    13.105     0.200
     0.813    15.627     0.200
     0.834    15.797     0.200
     0.910    17.186     0.200
     0.968    18.336     0.200
     1.040    19.656     0.200
     1.179    22.166     0.200
     1.730    32.346     0.200
     1.794    33.037     0.200
     1.808    33.807     0.200
     1.956    36.016     0.200
     1.995    36.316     0.200
     2.165    39.646     0.200
     2.201    39.947     0.200
     0.098     1.852     0.200
     0.144     3.453     0.200
     0.250     4.812     0.200
     0.314     5.969     0.200
     0.410     7.992     0.200
     0.451     8.898     0.200
     0.447     8.508     0.200
     0.449     8.781     0.200
     0.547     9.969     0.200
     0.664    12.805     0.200
     1.067    20.367     0.200
     1.206    22.469     0.200
     1.384    25.633     0.200
     1.651    31.383     0.200
     1.779    33.023     0.200
     1.783    33.703     0.200
     1.800    33.188     0.200
     1.852    34.664     0.200
     1.915    35.938     0.200
     2.056    37.867     0.200
     0.151     4.023     0.200
     0.203     4.492     0.200
     0.318     6.332     0.200
     0.314     6.500     0.200
     0.318     6.371     0.200
     0.412     8.391     0.200
     0.505     9.113     0.200
     0.589    11.602     0.200
     0.610    11.191     0.200
     0.730    13.961     0.200
     0.739    14.180     0.200
     0.788    14.941     0.200
     0.783    14.273     0.200
     0.825    15.762     0.200
     0.850    15.121     0.200
     0.911    17.820     0.200
     0.098     3.354     0.200
     0.077     3.615     0.200
     0.159     3.814     0.200
     0.351     7.145     0.200
     0.300     6.865     0.200
     0.349     7.145     0.200
     0.428     8.214     0.200
     0.461     9.104     0.200
     0.480     9.564     0.200
     0.498     9.635     0.200
     0.490     9.974     0.200
     0.569    11.034     0.200
     0.611    11.604     0.200
     0.724    13.514     0.200
     0.747    14.774     0.200
     0.879    16.254     0.200
     1.550    28.834     0.200
     1.604    29.604     0.200
     1.633    30.204     0.200
     1.817    33.165     0.200
     1.961    35.054     0.200
     1.975    35.294     0.200
     2.024    36.764     0.200
     2.090    37.794     0.200
     2.284    41.224     0.200
     0.594    11.784     0.200
     2.098    39.115     0.200
     0.057     4.523     0.200
     0.155     5.344     0.200
     0.221     6.391     0.200
     0.287     6.844     0.200
     0.318     7.602     0.200
     0.339     7.500     0.200
     0.418     9.109     0.200
     0.471     9.844     0.200
     0.545    11.320     0.200
     0.619    12.539     0.200
     0.623    12.250     0.200
     0.707    13.828     0.200
     0.804    15.000     0.200
     1.285    23.797     0.200
     1.716    30.398     0.200
     1.809    32.492     0.200
     0.194     4.730     0.200
     0.241     5.703     0.200
     0.277     6.543     0.200
     0.349     7.582     0.200
     0.345     7.793     0.200
     0.422     8.730     0.200
     0.404     8.773     0.200
     0.482    10.230     0.200
     0.577    10.871     0.200
     0.550    11.152     0.200
     0.327     6.571     0.200
     0.333     6.761     0.200
     0.334     6.921     0.200
     0.363     7.701     0.200
     0.426     9.061     0.200
     0.471     9.241     0.200
     0.506     9.161     0.200
     0.471     9.411     0.200
     0.566    10.711     0.200
     1.648    30.241     0.200
     0.083     2.504     0.200
     0.247     5.027     0.200
     0.266     5.707     0.200
     0.308     6.234     0.200
     0.322     6.797     0.200
     0.384     7.414     0.200
     0.424     8.375     0.200
     0.486     9.695     0.200
     0.612    11.734     0.200
     0.793    14.957     0.200
     0.871    16.676     0.200
     1.558    29.355     0.200
     1.551    28.234     0.200
     0.081     2.602     0.200
     0.106     3.172     0.200
     0.181     4.617     0.200
     0.269     5.766     0.200
     0.369     7.461     0.200
     0.432     8.484     0.200
     0.594    11.352     0.200
     0.663    13.062     0.200
     0.137     4.330     0.200
     0.117     4.490     0.200
     0.249     5.941     0.200
     0.357     7.311     0.200
     0.379     7.752     0.200
     0.423     8.650     0.200
     0.508    10.521     0.200
     0.643    12.541     0.200
     0.659    13.160     0.200
     0.681    12.971     0.200
     0.881    16.682     0.200
     0.895    16.641     0.200
     0.986    18.311     0.200
     1.377    25.990     0.200
     1.438    26.852     0.200
     0.106     2.836     0.200
     0.092     2.922     0.200
     0.137     3.898     0.200
     0.317     6.422     0.200
     0.392     7.750     0.200
     0.386     7.742     0.200
     0.459     8.758     0.200
     0.533    10.195     0.200
     0.514    10.250     0.200
     0.663    12.109     0.200
     1.496    27.719     0.200
     1.547    28.969     0.200
     1.576    29.398     0.200
     1.903    34.289     0.200
     1.966    36.242     0.200
     2.229    40.000     0.200
     0.193     4.586     0.200
     0.186     3.953     0.200
     0.360     7.297     0.200
     0.662    13.180     0.200
     0.704    13.305     0.200
     0.779    13.984     0.200
     0.775    14.023     0.200
     0.782    14.945     0.200
     0.783    15.133     0.200
     0.046     3.668     0.200
     0.112     4.238     0.200
     0.111     4.480     0.200
     0.104     4.508     0.200
     0.247     6.027     0.200
     0.244     5.879     0.200
     0.309     7.148     0.200
     0.366     8.020     0.200
     0.455     9.707     0.200
     0.446     9.758     0.200
     0.474     9.938     0.200
     0.561    11.297     0.200
     0.577    11.219     0.200
     0.913    16.359     0.200
     1.666    29.770     0.200
     1.726    30.480     0.200
     1.767    31.898     0.200
     1.843    33.410     0.200
     0.170     3.297     0.200
     0.154     3.516     0.200
     0.184     3.945     0.200
     0.299     5.648     0.200
     0.385     7.547     0.200
     0.396     7.516     0.200
     0.445     8.797     0.200
     0.512    10.047     0.200
     0.535    10.141     0.200
     0.544    10.711     0.200
     0.623    11.797     0.200
     0.756    14.359     0.200
     0.849    16.016     0.200
     0.919    17.359     0.200
     0.955    18.086     0.200
     1.094    20.688     0.200
     1.115    21.031     0.200
     0.179     3.445     0.200
     0.141     3.180     0.200
     0.180     3.703     0.200
     0.287     5.133     0.200
     0.303     5.844     0.200
     0.399     8.031     0.200
     0.406     8.062     0.200
     0.526     9.820     0.200
     0.549    10.133     0.200
     0.535    10.281     0.200
     0.636    11.875     0.200
     0.739    14.039     0.200
     0.787    14.844     0.200
     0.854    16.102     0.200
     0.952    18.242     0.200
     1.043    19.602     0.200
     1.049    19.781     0.200
     1.107    21.000     0.200
     0.106     3.352     0.200
     0.157     3.945     0.200
     0.233     5.508     0.200
     0.276     6.211     0.200
     0.333     6.977     0.200
     0.331     7.312     0.200
     0.379     8.102     0.200
     0.522    10.727     0.200
     0.579    11.672     0.200
     0.610    12.281     0.200
     0.152     3.518     0.200
     0.224     4.129     0.200
     0.238     4.809     0.200
     0.328     6.148     0.200
     0.370     7.139     0.200
     0.411     7.898     0.200
     0.460     8.908     0.200
     0.485     9.238     0.200
     0.559    10.729     0.200
     0.651    12.299     0.200
     0.664    12.678     0.200
     0.688    12.779     0.200
     0.699    13.568     0.200
     0.737    14.229     0.200
     0.759    14.338     0.200
     0.791    15.098     0.200
     0.836    15.629     0.200
     0.845    16.309     0.200
     0.849    16.229     0.200
     0.836    16.139     0.200
     0.916    17.268     0.200
     0.950    18.338     0.200
     1.085    20.408     0.200
     1.081    20.258     0.200
     1.098    20.988     0.200
     1.116    21.018     0.200
     1.128    21.318     0.200
     1.122    21.279     0.200
     1.168    22.209     0.200
     1.254    22.799     0.200
     0.084     2.891     0.200
     0.101     3.391     0.200
     0.173     4.281     0.200
     0.395     8.250     0.200
     0.407     8.602     0.200
     0.445     8.859     0.200
     0.457     9.148     0.200
     0.509     9.484     0.200
     0.528    10.219     0.200
     0.527    10.555     0.200
     0.627    11.828     0.200
     0.785    14.508     0.200
     1.009    18.867     0.200
     1.462    27.109     0.200
     1.512    27.938     0.200
     1.810    32.305     0.200
     2.031    36.227     0.200
     0.147     4.004     0.200
     0.156     3.711     0.200
     0.183     4.391     0.200
     0.204     4.812     0.200
     0.309     6.531     0.200
     0.369     7.461     0.200
     0.378     7.852     0.200
     0.553    11.203     0.200
     0.615    12.301     0.200
     0.626    12.441     0.200
     0.074     2.336     0.200
     0.138     3.273     0.200
     0.150     3.492     0.200
     0.171     3.477     0.200
     0.308     6.156     0.200
     0.326     6.211     0.200
     0.413     7.867     0.200
     0.450     8.734     0.200
     0.457     8.742     0.200
     0.546    10.547     0.200
     0.546    10.852     0.200
     0.570    10.977     0.200
     0.896    17.383     0.200
     0.085     2.430     0.200
     0.142     3.262     0.200
     0.154     3.352     0.200
     0.327     6.453     0.200
     0.341     6.770     0.200
     0.349     6.793     0.200
     0.389     7.160     0.200
     0.410     8.211     0.200
     0.461     8.793     0.200
     0.486     9.500     0.200
     0.530    10.141     0.200
     0.582    11.262     0.200
     0.606    11.492     0.200
     0.645    12.352     0.200
     0.161     3.740     0.200
     0.242     4.980     0.200
     0.267     5.381     0.200
     0.370     7.289     0.200
     0.393     8.051     0.200
     0.443     8.279     0.200
     0.437     8.391     0.200
     0.485     8.980     0.200
     0.560    10.939     0.200
     0.584    11.350     0.200
     0.600    11.340     0.200
     0.646    12.211     0.200
     0.636    12.340     0.200
     0.657    12.340     0.200
     0.710    13.650     0.200
     0.733    13.830     0.200
     0.745    13.961     0.200
     0.726    14.020     0.200
     0.787    14.750     0.200
     0.791    14.721     0.200
     0.806    15.420     0.200
     0.801    15.670     0.200
     0.853    16.260     0.200
     0.910    17.080     0.200
     0.923    18.020     0.200
     1.043    20.039     0.200
     1.052    20.029     0.200
     1.104    20.730     0.200
     1.118    21.010     0.200
     1.122    21.270     0.200
     1.184    21.689     0.200
     0.187     4.084     0.200
     0.251     5.365     0.200
     0.268     5.504     0.200
     0.303     6.084     0.200
     0.329     6.504     0.200
     0.451     8.395     0.200
     0.538     9.865     0.200
     0.576    11.064     0.200
     0.636    11.875     0.200
     0.779    14.645     0.200
     0.826    15.715     0.200
     0.837    15.715     0.200
     1.050    19.895     0.200
     0.163     3.781     0.200
     0.243     5.094     0.200
     0.263     5.609     0.200
     0.328     6.703     0.200
     0.333     6.883     0.200
     0.359     7.289     0.200
     0.388     7.539     0.200
     0.402     7.875     0.200
     0.445     9.102     0.200
     0.494     9.039     0.200
     0.553    10.555     0.200
     0.577    11.055     0.200
     0.596    11.398     0.200
     0.631    12.039     0.200
     0.664    12.555     0.200
     0.704    13.422     0.200
     0.778    14.883     0.200
     0.864    16.383     0.200
     1.007    19.125     0.200
     1.098    20.672     0.200
     1.794    33.633     0.200
     0.093     3.023     0.200
     0.088     2.784     0.200
     0.175     4.324     0.200
     0.256     5.424     0.200
     0.288     5.844     0.200
     0.358     7.014     0.200
     0.425     8.414     0.200
     0.491     9.714     0.200
     0.579    11.574     0.200
     0.585    11.254     0.200
     0.636    12.544     0.200
     0.654    12.764     0.200
     0.755    14.224     0.200
     0.913    17.124     0.200
     0.923    17.514     0.200
     1.079    20.374     0.200
     1.448    26.954     0.200
     1.776    32.903     0.200
     1.855    33.434     0.200
     0.201     4.891     0.200
     0.311     6.430     0.200
     0.315     6.410     0.200
     0.345     6.910     0.200
     0.384     7.973     0.200
     0.415     7.840     0.200
     0.399     8.332     0.200
     0.436     8.352     0.200
     0.475     9.461     0.200
     0.505    10.090     0.200
     0.586    11.211     0.200
     0.668    12.781     0.200
     0.764    14.551     0.200
     0.783    14.930     0.200
     1.442    26.961     0.200
     1.509    28.000     0.200
     0.105     3.219     0.200
     0.147     3.988     0.200
     0.173     4.070     0.200
     0.216     5.109     0.200
     0.230     5.301     0.200
     0.332     6.898     0.200
     0.378     7.500     0.200
     0.416     8.211     0.200
     0.453     9.109     0.200
     0.460     9.371     0.200
     0.453     9.059     0.200
     0.554    10.699     0.200
     0.584    11.570     0.200
     0.597    11.488     0.200
     0.657    12.691     0.200
     0.701    13.340     0.200
     0.712    13.770     0.200
     0.786    14.891     0.200
     1.012    19.191     0.200
     1.748    31.871     0.200
     1.824    32.719     0.200
     2.042    36.648     0.200
     0.112     2.672     0.200
     0.216     4.512     0.200
     0.247     5.391     0.200
     0.289     5.863     0.200
     0.313     6.012     0.200
     0.324     6.281     0.200
     0.343     6.773     0.200
     0.422     8.012     0.200
     0.422     8.082     0.200
     0.428     8.293     0.200
     0.641    12.281     0.200
     0.677    12.883     0.200
     0.060     1.775     0.200
     0.194     4.355     0.200
     0.228     4.916     0.200
     0.255     5.275     0.200
     0.346     6.855     0.200
     0.357     7.375     0.200
     0.385     7.496     0.200
     0.392     7.736     0.200
     0.370     7.695     0.200
     0.430     8.156     0.200
     0.469     9.215     0.200
     0.581    11.176     0.200
     0.539    10.785     0.200
     0.586    11.406     0.200
     0.609    11.996     0.200
     0.792    14.576     0.200
     0.794    14.676     0.200
     0.849    15.666     0.200
     0.926    17.295     0.200
     0.949    17.775     0.200
     0.941    18.035     0.200
     0.974    17.875     0.200
     0.980    17.996     0.200
     1.098    20.676     0.200
     1.190    22.096     0.200
     1.264    23.195     0.200
     1.530    28.936     0.200
     1.655    30.795     0.200
     1.662    30.795     0.200
     1.674    30.625     0.200
     1.667    30.775     0.200
     1.727    31.926     0.200
     1.767    32.746     0.200
     1.789    32.785     0.200
     1.831    33.576     0.200
     1.925    35.016     0.200
     1.933    35.186     0.200
     1.989    36.215     0.200
     1.992    36.387     0.200
     0.573    12.086     0.200
     2.464    46.387     0.200
     0.061     2.227     0.200
     0.112     3.215     0.200
     0.207     4.656     0.200
     0.279     5.773     0.200
     0.273     5.805     0.200
     0.328     6.605     0.200
     0.379     7.613     0.200
     0.456     8.824     0.200
     0.484     9.477     0.200
     0.559    10.535     0.200
     0.612    11.875     0.200
     0.644    12.793     0.200
     0.648    12.316     0.200
     0.683    13.613     0.200
     0.732    13.543     0.200
     0.733    13.586     0.200
     0.769    14.746     0.200
     1.587    29.164     0.200
     2.134    38.453     0.200
     0.177     3.969     0.200
     0.233     4.898     0.200
     0.354     7.008     0.200
     0.363     6.820     0.200
     0.355     7.148     0.200
     0.398     7.969     0.200
     0.444     8.410     0.200
     0.470     8.848     0.200
     0.598    11.449     0.200
     0.572    11.359     0.200
     0.941    18.180     0.200
     0.962    18.078     0.200
     1.282    23.668     0.200
     1.353    25.078     0.200
     1.690    31.230     0.200
     1.848    34.160     0.200
     0.140     3.281     0.200
     0.142     3.469     0.200
     0.169     3.734     0.200
     0.202     4.203     0.200
     0.328     6.328     0.200
     0.353     6.562     0.200
     0.367     7.188     0.200
     0.372     7.555     0.200
     0.381     7.328     0.200
     0.398     7.570     0.200
     0.432     8.234     0.200
     0.447     8.672     0.200
     0.451     9.344     0.200
     0.504     9.305     0.200
     0.503     9.742     0.200
     0.520    10.109     0.200
     0.534    10.008     0.200
     0.636    12.383     0.200
     0.643    12.242     0.200
     0.699    13.258     0.200
     0.681    13.000     0.200
     0.693    13.648     0.200
     0.714    13.430     0.200
     0.763    14.617     0.200
     0.925    18.000     0.200
     1.025    19.719     0.200
     1.493    28.320     0.200
     1.530    28.711     0.200
     1.658    31.234     0.200
     1.735    32.180     0.200
     1.861    34.328     0.200
     0.150     3.227     0.200
     0.144     2.750     0.200
     0.176     3.234     0.200
     0.259     5.164     0.200
     0.275     5.680     0.200
     0.379     7.297     0.200
     0.374     7.227     0.200
     0.446     8.383     0.200
     0.455     8.906     0.200
     0.447     8.383     0.200
     0.500     9.336     0.200
     0.611    10.953     0.200
     0.616    11.633     0.200
     0.631    11.633     0.200
     0.628    12.086     0.200
     0.637    12.836     0.200
     0.683    12.781     0.200
     0.702    13.547     0.200
     0.779    14.555     0.200
     0.818    15.992     0.200
     0.861    16.641     0.200
     0.935    17.859     0.200
     0.963    18.359     0.200
     0.981    18.273     0.200
     1.126    21.172     0.200
     1.602    30.234     0.200
     1.633    31.211     0.200
     1.782    33.492     0.200
     1.914    35.984     0.200
     1.991    37.141     0.200
     2.013    37.273     0.200
     2.124    38.852     0.200
     0.092     2.664     0.200
     0.226     4.617     0.200
     0.229     5.086     0.200
     0.254     5.164     0.200
     0.367     7.273     0.200
     0.432     8.516     0.200
     0.507    10.023     0.200
     0.509     9.766     0.200
     0.611    11.367     0.200
     0.677    12.461     0.200
     0.682    13.133     0.200
     0.683    13.117     0.200
     0.845    15.875     0.200
     0.124     4.500     0.200
     0.134     4.508     0.200
     0.155     5.305     0.200
     0.269     6.805     0.200
     0.291     6.578     0.200
     0.318     7.055     0.200
     0.496     9.820     0.200
     0.544    10.609     0.200
     0.532    10.734     0.200
     0.556    11.266     0.200
     0.618    11.789     0.200
     0.672    12.945     0.200
     0.764    14.648     0.200
     0.808    14.859     0.200
     0.875    16.180     0.200
     0.157     2.809     0.200
     0.273     5.098     0.200
     0.284     4.980     0.200
     0.322     6.250     0.200
     0.344     6.250     0.200
     0.360     6.398     0.200
     0.420     7.500     0.200
     0.443     8.148     0.200
     0.464     8.797     0.200
     0.507     9.520     0.200
     0.543    10.109     0.200
     0.563    11.129     0.200
     0.588    11.277     0.200
     0.637    12.238     0.200
     0.722    13.879     0.200
     0.795    14.789     0.200
     0.795    15.328     0.200
     0.790    14.680     0.200
     0.820    16.008     0.200
     0.921    17.699     0.200
     1.065    19.590     0.200
     1.725    33.188     0.200
     0.095     2.359     0.200
     0.101     2.339     0.200
     0.319     6.549     0.200
     0.437     7.959     0.200
     0.464     9.229     0.200
     0.467     8.699     0.200
     0.534    10.579     0.200
     0.655    12.529     0.200
     0.815    15.229     0.200
     1.026    19.520     0.200
     1.035    19.579     0.200
     1.542    29.109     0.200
     1.759    32.459     0.200
     1.840    33.049     0.200
     1.897    35.229     0.200
     1.908    34.619     0.200
     1.961    35.970     0.200
     2.023    36.680     0.200
     2.224    40.749     0.200
     1.973    37.439     0.200
     2.149    39.539     0.200
     2.161    40.079     0.200
     2.667    46.229     0.200
     3.148    53.890     0.200
     0.056     2.422     0.200
     0.137     3.125     0.200
     0.180     4.352     0.200
     0.198     4.766     0.200
     0.310     6.734     0.200
     0.413     8.164     0.200
     0.412     8.016     0.200
     0.486     9.234     0.200
     0.554    11.336     0.200
     0.563    10.820     0.200
     0.578    11.695     0.200
     0.626    12.172     0.200
     1.000    19.062     0.200
     1.064    19.664     0.200
     2.000    36.953     0.200
     0.162     3.430     0.200
     0.195     3.758     0.200
     0.199     4.336     0.200
     0.318     6.656     0.200
     0.313     6.602     0.200
     0.345     7.062     0.200
     0.532     9.961     0.200
     0.574    10.836     0.200
     0.672    13.102     0.200
     0.663    12.469     0.200
     0.691    13.250     0.200
     0.851    15.742     0.200
     0.904    17.000     0.200
     0.974    18.836     0.200
     0.205     3.992     0.200
     0.268     5.480     0.200
     0.271     5.453     0.200
     0.271     5.371     0.200
     0.281     5.324     0.200
     0.325     6.102     0.200
     0.369     7.344     0.200
     0.381     7.512     0.200
     0.467     8.391     0.200
     0.453     8.844     0.200
     0.546    10.551     0.200
     0.592    11.371     0.200
     0.624    11.961     0.200
     0.626    11.723     0.200
     0.625    11.871     0.200
     0.697    13.312     0.200
     0.834    15.652     0.200
     1.620    30.621     0.200
     1.982    36.992     0.200
     0.080     3.484     0.200
     0.116     3.711     0.200
     0.191     4.531     0.200
     0.189     4.789     0.200
     0.241     5.859     0.200
     0.302     6.531     0.200
     0.350     7.609     0.200
     0.355     7.047     0.200
     0.492    10.047     0.200
     0.499     9.961     0.200
     0.563    10.844     0.200
     0.679    13.047     0.200
     0.739    14.047     0.200
     0.762    15.023     0.200
     0.752    14.422     0.200
     0.769    14.594     0.200
     0.775    15.031     0.200
     0.809    15.609     0.200
     0.887    16.664     0.200
     0.177     4.125     0.200
     0.159     3.945     0.200
     0.203     4.961     0.200
     0.243     5.062     0.200
     0.362     7.023     0.200
     0.341     6.969     0.200
     0.406     7.633     0.200
     0.444     8.961     0.200
     0.464     8.625     0.200
     0.614    11.211     0.200
     0.633    12.148     0.200
     0.635    12.898     0.200
     0.653    12.570     0.200
     0.689    12.812     0.200
     0.710    13.945     0.200
     0.762    14.000     0.200
     0.758    14.102     0.200
     0.785    15.094     0.200
     0.774    14.812     0.200
     0.785    15.461     0.200
     0.818    16.125     0.200
     0.869    16.844     0.200
     0.929    17.672     0.200
     1.004    18.953     0.200
     1.169    20.766     0.200
     1.433    26.820     0.200
     0.031     1.938     0.200
     0.128     2.875     0.200
     0.208     4.172     0.200
     0.327     6.477     0.200
     0.250     5.578     0.200
     0.323     6.781     0.200
     0.385     7.570     0.200
     0.469     9.141     0.200
     0.503     9.859     0.200
     0.475     9.695     0.200
     0.603    11.648     0.200
     0.655    12.562     0.200
     0.776    14.680     0.200
     0.770    15.320     0.200
     0.927    17.375     0.200
     0.928    17.289     0.200
     1.177    22.047     0.200
     1.652    30.781     0.200
     1.808    33.336     0.200
     1.863    34.195     0.200
     1.933    34.875     0.200
     2.005    36.461     0.200
     2.011    36.641     0.200
     2.025    36.367     0.200
     2.167    39.141     0.200
     2.274    40.852     0.200
     2.272    41.031     0.200
     2.331    42.352     0.200
     0.110     3.344     0.200
     0.189     5.047     0.200
     0.235     5.508     0.200
     0.357     7.562     0.200
     0.391     7.617     0.200
     0.419     8.758     0.200
     0.579    11.469     0.200
     0.638    12.570     0.200
     0.660    13.273     0.200
     0.661    12.922     0.200
     0.762    14.547     0.200
     1.005    18.781     0.200
     1.967    35.547     0.200
     0.118     3.516     0.200
     0.195     5.008     0.200
     0.394     7.836     0.200
     0.398     7.836     0.200
     0.409     7.391     0.200
     0.424     8.109     0.200
     0.451     8.938     0.200
     0.585    11.109     0.200
     0.586    11.086     0.200
     0.638    12.250     0.200
     0.708    13.758     0.200
     0.106     2.562     0.200
     0.112     2.773     0.200
     0.117     2.555     0.200
     0.157     3.258     0.200
     0.271     5.109     0.200
     0.359     6.734     0.200
     0.363     6.852     0.200
     0.399     7.562     0.200
     0.421     8.039     0.200
     0.477     8.664     0.200
     0.591    11.289     0.200
     0.644    12.023     0.200
     0.688    12.938     0.200
     0.703    13.602     0.200
     0.731    13.781     0.200
     0.746    13.805     0.200
     0.796    14.930     0.200
     0.811    15.367     0.200
     0.161     3.820     0.200
     0.290     5.780     0.200
     0.305     6.120     0.200
     0.302     6.050     0.200
     0.310     6.240     0.200
     0.362     7.250     0.200
     0.436     8.170     0.200
     0.433     8.640     0.200
     0.449     8.660     0.200
     0.464     9.200     0.200
     0.556    10.740     0.200
     0.628    11.910     0.200
     0.698    13.490     0.200
     0.723    14.090     0.200
     0.737    13.700     0.200
     0.796    15.290     0.200
     0.836    16.030     0.200
     0.807    15.470     0.200
     0.841    16.230     0.200
     0.866    16.120     0.200
     1.462    27.830     0.200
     1.739    32.220     0.200
     0.051     0.914     0.200
     0.160     3.523     0.200
     0.196     3.945     0.200
     0.173     3.824     0.200
     0.282     5.336     0.200
     0.294     6.094     0.200
     0.360     6.926     0.200
     0.389     7.375     0.200
     0.409     7.934     0.200
     0.414     8.156     0.200
     0.458     8.812     0.200
     0.511     9.395     0.200
     0.506     9.965     0.200
     0.537    10.555     0.200
     0.606    11.684     0.200
     0.651    11.836     0.200
     0.683    13.035     0.200
     0.723    13.496     0.200
     0.862    15.844     0.200
     0.871    16.062     0.200
     0.877    16.195     0.200
     0.929    17.484     0.200
     0.950    17.824     0.200
     0.954    17.855     0.200
     1.030    19.344     0.200
     1.015    19.195     0.200
     1.044    19.594     0.200
     1.044    19.336     0.200
     1.141    21.543     0.200
     1.171    22.484     0.200
     1.259    23.496     0.200
     1.375    25.633     0.200
     1.405    26.156     0.200
     1.672    30.844     0.200
     1.719    32.312     0.200
     1.733    32.535     0.200
     1.749    32.324     0.200
     1.796    34.184     0.200
     1.893    35.375     0.200
     1.995    37.035     0.200
     1.998    36.836     0.200
     2.056    37.984     0.200
     0.780    14.926     0.200
     1.120    21.516     0.200
     1.822    35.426     0.200
     1.984    36.223     0.200
     2.067    37.363     0.200
     2.327    42.574     0.200
     2.312    41.113     0.200
     2.527    45.184     0.200
     0.108     3.000     0.200
     0.165     3.910     0.200
     0.226     4.711     0.200
     0.357     6.820     0.200
     0.392     7.621     0.200
     0.459     8.602     0.200
     0.545    10.559     0.200
     0.603    11.879     0.200
     0.629    12.301     0.200
     0.650    12.461     0.200
     0.719    14.031     0.200
     1.001    19.180     0.200
     1.514    28.422     0.200
     0.658    13.652     0.200
     1.606    31.633     0.200
     1.818    34.152     0.200
     2.013    37.441     0.200
     2.111    38.465     0.200
     2.284    40.121     0.200
     2.555    44.012     0.200
     2.785    47.441     0.200
     0.147     3.625     0.200
     0.136     3.242     0.200
     0.199     4.383     0.200
     0.229     5.109     0.200
     0.356     7.086     0.200
     0.377     7.852     0.200
     0.432     8.375     0.200
     0.541    10.812     0.200
     0.602    11.773     0.200
     0.620    12.289     0.200
     0.625    12.039     0.200
     0.693    13.312     0.200
     0.730    13.766     0.200
     0.974    18.812     0.200
     0.210     4.102     0.200
     0.302     5.891     0.200
     0.313     6.031     0.200
     0.336     6.461     0.200
     0.360     6.844     0.200
     0.399     7.133     0.200
     0.381     7.273     0.200
     0.422     7.992     0.200
     0.461     8.844     0.200
     0.484     9.320     0.200
     0.510     9.633     0.200
     0.516    10.082     0.200
     0.532    10.223     0.200
     0.571    10.863     0.200
     0.681    12.820     0.200
     0.681    12.852     0.200
     0.747    14.262     0.200
     0.768    14.273     0.200
     0.775    14.723     0.200
     0.854    16.094     0.200
     0.848    16.344     0.200
     1.026    19.543     0.200
     1.074    20.453     0.200
     1.801    33.453     0.200
     0.071     1.953     0.200
     0.168     3.477     0.200
     0.294     5.617     0.200
     0.383     7.602     0.200
     0.451     8.617     0.200
     0.512     9.945     0.200
     0.515     9.641     0.200
     0.538     9.836     0.200
     0.730    13.570     0.200
     0.732    13.602     0.200
     0.787    15.133     0.200
     0.808    15.047     0.200
     0.801    14.867     0.200
     0.816    15.703     0.200
     0.807    14.875     0.200
     0.116     2.461     0.200
     0.204     4.227     0.200
     0.267     4.875     0.200
     0.311     5.867     0.200
     0.328     5.883     0.200
     0.342     6.367     0.200
     0.360     7.172     0.200
     0.462     8.852     0.200
     0.524     9.602     0.200
     0.532    10.062     0.200
     0.584    11.281     0.200
     0.652    12.242     0.200
     0.684    13.117     0.200
     0.714    13.727     0.200
     0.682    13.227     0.200
     0.708    13.727     0.200
     0.735    13.750     0.200
     0.767    14.727     0.200
     0.855    16.336     0.200
     0.842    16.922     0.200
     0.915    17.055     0.200
     0.918    16.781     0.200
     0.942    17.844     0.200
     1.050    19.805     0.200
     1.066    20.273     0.200
     1.168    22.023     0.200
     1.347    25.070     0.200
     1.421    26.070     0.200
     1.580    29.555     0.200
     1.646    31.000     0.200
     1.671    30.891     0.200
     1.734    32.117     0.200
     0.145     3.744     0.200
     0.189     4.314     0.200
     0.288     5.784     0.200
     0.292     5.934     0.200
     0.317     6.484     0.200
     0.310     6.304     0.200
     0.396     7.854     0.200
     0.440     8.284     0.200
     0.458     8.434     0.200
     0.463     9.284     0.200
     0.507     9.364     0.200
     0.510    10.144     0.200
     0.575    10.974     0.200
     0.568    11.334     0.200
     0.667    12.464     0.200
     0.674    12.614     0.200
     0.730    14.754     0.200
     0.727    13.814     0.200
     0.781    14.944     0.200
     0.799    15.034     0.200
     0.809    15.534     0.200
     0.836    15.344     0.200
     0.882    16.624     0.200
     1.021    19.214     0.200
     1.020    19.124     0.200
     1.065    20.024     0.200
     1.190    22.164     0.200
     1.528    28.564     0.200
     1.516    28.414     0.200
     1.540    28.694     0.200
     1.568    29.284     0.200
     1.601    30.184     0.200
     1.656    30.534     0.200
     1.716    31.744     0.200
     1.875    34.674     0.200
     0.136     3.883     0.200
     0.168     4.402     0.200
     0.149     3.992     0.200
     0.261     5.844     0.200
     0.358     7.613     0.200
     0.373     7.914     0.200
     0.446     9.203     0.200
     0.449     9.285     0.200
     0.440     8.715     0.200
     0.484     9.344     0.200
     0.564    11.441     0.200
     0.617    11.504     0.200
     0.612    12.305     0.200
     0.621    12.465     0.200
     0.684    13.414     0.200
     0.681    13.043     0.200
     0.685    13.562     0.200
     0.759    14.691     0.200
     0.777    15.234     0.200
     0.784    14.754     0.200
     0.805    15.074     0.200
     0.849    16.625     0.200
     1.557    28.734     0.200
     1.609    29.473     0.200
     1.787    32.363     0.200
     1.798    33.184     0.200
     1.995    36.395     0.200
     2.019    35.914     0.200
     2.131    38.703     0.200
     0.481     8.773     0.200
     0.584    12.441     0.200
     0.011     2.563     0.200
     0.113     3.014     0.200
     0.140     3.413     0.200
     0.172     4.144     0.200
     0.218     4.644     0.200
     0.240     5.123     0.200
     0.305     6.213     0.200
     0.333     6.014     0.200
     0.373     7.224     0.200
     0.438     7.903     0.200
     0.476     9.184     0.200
     0.474     9.253     0.200
     0.473     9.543     0.200
     0.487     9.604     0.200
     0.579    10.953     0.200
     0.609    11.663     0.200
     0.659    12.434     0.200
     0.692    12.543     0.200
     0.690    12.923     0.200
     0.721    13.083     0.200
     0.727    13.703     0.200
     0.744    13.974     0.200
     0.744    14.673     0.200
     0.776    14.843     0.200
     0.816    16.083     0.200
     0.840    15.953     0.200
     0.906    16.833     0.200
     0.960    18.493     0.200
     1.000    19.173     0.200
     1.026    19.733     0.200
     1.143    21.483     0.200
     1.250    23.023     0.200
     0.109     3.762     0.200
     0.177     4.441     0.200
     0.207     3.992     0.200
     0.305     6.414     0.200
     0.316     5.941     0.200
     0.364     7.453     0.200
     0.434     8.793     0.200
     0.439     8.305     0.200
     0.434     8.762     0.200
     0.515     9.895     0.200
     0.561    10.645     0.200
     0.584    11.242     0.200
     0.584    11.453     0.200
     0.586    11.211     0.200
     0.670    13.133     0.200
     0.711    13.652     0.200
     0.736    14.262     0.200
     0.719    13.613     0.200
     0.763    14.523     0.200
     0.813    15.523     0.200
     0.869    16.023     0.200
     0.893    16.805     0.200
     1.039    19.711     0.200
     1.074    20.004     0.200
     1.446    27.395     0.200
     1.529    28.762     0.200
     0.134     2.953     0.200
     0.132     3.234     0.200
     0.183     3.633     0.200
     0.255     5.273     0.200
     0.340     6.695     0.200
     0.328     6.430     0.200
     0.415     7.914     0.200
     0.420     8.039     0.200
     0.454     8.852     0.200
     0.465     8.633     0.200
     0.585    11.406     0.200
     0.588    11.500     0.200
     0.661    12.234     0.200
     0.658    12.719     0.200
     0.746    14.312     0.200
     0.770    14.383     0.200
     0.866    16.242     0.200
     0.927    17.750     0.200
     0.982    18.555     0.200
     0.986    18.141     0.200
     1.121    21.289     0.200
     1.162    21.625     0.200
     1.535    29.062     0.200
     1.596    30.055     0.200
     1.789    33.406     0.200
     1.913    35.969     0.200
     2.005    36.875     0.200
     0.148     4.060     0.200
     0.207     4.310     0.200
     0.270     5.410     0.200
     0.296     6.180     0.200
     0.329     6.540     0.200
     0.408     8.010     0.200
     0.431     7.660     0.200
     0.451     8.950     0.200
     0.571    10.960     0.200
     0.582    11.140     0.200
     0.602    11.270     0.200
     0.670    12.860     0.200
     0.723    13.800     0.200
     0.807    14.910     0.200
     0.799    15.620     0.200
     0.851    15.720     0.200
     0.925    17.730     0.200
     0.155     4.113     0.200
     0.249     5.535     0.200
     0.263     5.824     0.200
     0.318     6.875     0.200
     0.350     7.633     0.200
     0.393     8.184     0.200
     0.387     7.793     0.200
     0.440     9.234     0.200
     0.490     9.484     0.200
     0.578    10.766     0.200
     0.593    11.145     0.200
     0.659    12.434     0.200
     0.685    13.695     0.200
     0.700    14.086     0.200
     0.699    14.074     0.200
     0.773    14.953     0.200
     0.787    15.023     0.200
     0.850    16.516     0.200
     0.860    16.105     0.200
     0.915    17.664     0.200
     1.091    19.664     0.200
     1.668    30.363     0.200
     1.893    35.105     0.200
     0.040     1.562     0.200
     0.165     3.625     0.200
     0.175     4.008     0.200
     0.248     5.430     0.200
     0.311     6.422     0.200
     0.347     6.742     0.200
     0.376     7.484     0.200
     0.499     9.828     0.200
     0.471     9.242     0.200
     0.484     9.484     0.200
     0.505    10.008     0.200
     0.595    12.062     0.200
     0.710    13.273     0.200
     0.732    13.523     0.200
     0.783    14.680     0.200
     0.795    15.320     0.200
     0.933    17.344     0.200
     0.942    17.414     0.200
     0.995    17.844     0.200
     1.031    19.320     0.200
     1.065    20.023     0.200
     1.070    20.133     0.200
     1.087    20.680     0.200
     1.124    20.703     0.200
     1.135    20.898     0.200
     1.252    23.461     0.200
     1.604    29.898     0.200
     1.778    33.211     0.200
     1.985    36.812     0.200
     2.075    38.344     0.200
     2.086    38.180     0.200
     2.146    39.000     0.200
     0.660    14.234     0.200
     2.065    37.109     0.200
     2.245    39.531     0.200
     0.139     3.254     0.200
     0.128     3.354     0.200
     0.306     6.225     0.200
     0.371     7.135     0.200
     0.370     7.154     0.200
     0.528     9.395     0.200
     0.664    12.734     0.200
     0.679    13.074     0.200
     0.679    13.354     0.200
     0.841    16.504     0.200
     0.942    17.684     0.200
     1.008    19.074     0.200
     1.010    19.154     0.200
     1.042    19.494     0.200
     0.317     5.574     0.200
     0.295     5.914     0.200
     0.491     9.012     0.200
     0.526     9.922     0.200
     0.504     9.734     0.200
     0.528     9.684     0.200
     0.634    12.484     0.200
     0.688    13.031     0.200
     0.719    14.113     0.200
     0.724    14.164     0.200
     0.919    16.773     0.200
     1.031    19.633     0.200
     1.063    19.902     0.200
     1.198    22.562     0.200
     1.335    24.613     0.200
     1.532    28.574     0.200
     1.653    30.801     0.200
     1.711    31.863     0.200
     0.235     5.863     0.200
     0.261     6.074     0.200
     0.384     7.973     0.200
     0.413     8.934     0.200
     0.442     9.625     0.200
     0.488    10.285     0.200
     0.484     9.695     0.200
     0.555    10.402     0.200
     0.524    10.613     0.200
     0.570    11.215     0.200
     0.727    13.844     0.200
     0.742    14.203     0.200
     0.740    14.145     0.200
     0.814    15.242     0.200
     0.936    17.152     0.200
     1.504    27.125     0.200
     1.543    28.125     0.200
     1.721    30.754     0.200
     1.733    30.992     0.200
     1.940    34.672     0.200
     1.954    34.582     0.200
     0.212     4.141     0.200
     0.271     5.461     0.200
     0.385     7.031     0.200
     0.395     7.363     0.200
     0.411     8.461     0.200
     0.460     8.793     0.200
     0.525     9.262     0.200
     0.548    10.914     0.200
     0.548    10.633     0.200
     0.551    10.172     0.200
     0.650    12.164     0.200
     0.697    12.824     0.200
     0.738    14.004     0.200
     0.812    15.902     0.200
     0.880    16.453     0.200
     0.915    16.781     0.200
     0.892    17.133     0.200
     0.946    17.883     0.200
     1.693    31.734     0.200
     1.702    31.562     0.200
     1.814    33.984     0.200
     1.910    35.051     0.200
     1.925    35.133     0.200
     0.128     3.211     0.200
     0.173     4.250     0.200
     0.195     4.453     0.200
     0.234     5.156     0.200
     0.268     5.562     0.200
     0.349     6.852     0.200
     0.427     8.836     0.200
     0.481     9.695     0.200
     0.500     9.695     0.200
     0.524    10.195     0.200
     0.689    13.516     0.200
     0.719    13.891     0.200
     0.735    13.875     0.200
     0.826    15.953     0.200
     0.839    15.953     0.200
     0.947    18.016     0.200
     0.987    18.633     0.200
     0.999    18.594     0.200
     1.025    19.273     0.200
     1.454    27.336     0.200
     1.450    27.125     0.200
     0.211     5.133     0.200
     1.100    20.273     0.200
     0.121     3.087     0.200
     0.145     3.697     0.200
     0.240     4.317     0.200
     0.344     6.447     0.200
     0.367     7.437     0.200
     0.430     8.207     0.200
     0.409     8.357     0.200
     0.489     9.397     0.200
     0.541    10.337     0.200
     0.578    10.437     0.200
     0.831    15.377     0.200
     1.038    19.387     0.200
     1.042    19.377     0.200
     1.177    21.777     0.200
     1.224    22.627     0.200
     1.328    24.677     0.200
     1.560    28.997     0.200
     1.587    29.827     0.200
     1.707    31.937     0.200
     1.861    33.927     0.200
     1.897    35.097     0.200
     1.908    35.157     0.200
     1.921    35.257     0.200
     1.977    36.187     0.200
     2.005    36.697     0.200
     2.037    37.307     0.200
     2.183    39.297     0.200
     2.233    40.697     0.200
     2.242    40.587     0.200
     0.218     3.984     0.200
     0.254     4.836     0.200
     0.274     5.117     0.200
     0.337     6.777     0.200
     0.350     6.375     0.200
     0.366     7.035     0.200
     0.517     9.195     0.200
     0.514     9.168     0.200
     0.542    10.367     0.200
     0.626    11.527     0.200
     0.667    12.824     0.200
     0.681    12.984     0.200
     0.785    13.707     0.200
     0.855    16.637     0.200
     0.887    17.035     0.200
     1.206    22.598     0.200
     1.701    31.746     0.200
     1.916    35.586     0.200
     0.099     3.234     0.200
     0.101     3.344     0.200
     0.166     4.074     0.200
     0.266     5.465     0.200
     0.271     5.926     0.200
     0.297     5.895     0.200
     0.341     6.875     0.200
     0.428     8.145     0.200
     0.521    10.473     0.200
     0.545    10.805     0.200
     0.640    12.625     0.200
     0.705    13.535     0.200
     0.722    14.016     0.200
     0.739    13.945     0.200
     0.764    14.164     0.200
     0.766    13.836     0.200
     0.796    15.125     0.200
     0.835    14.965     0.200
     0.831    15.336     0.200
     0.835    16.184     0.200
     0.925    17.203     0.200
     0.984    18.324     0.200
     1.023    19.406     0.200
     1.025    19.246     0.200
     0.263     5.945     0.200
     0.716    15.824     0.200
     3.035    52.043     0.200
     0.060     2.565     0.200
     0.123     3.426     0.200
     0.203     4.996     0.200
     0.304     5.956     0.200
     0.388     7.835     0.200
     0.453     8.576     0.200
     0.510     9.656     0.200
     0.584    10.976     0.200
     0.615    11.666     0.200
     0.657    13.116     0.200
     0.684    13.235     0.200
     0.790    14.755     0.200
     0.917    17.886     0.200
     0.926    17.706     0.200
     1.451    27.186     0.200
     1.493    28.036     0.200
     1.749    32.366     0.200
     2.056    37.916     0.200
     2.160    38.896     0.200
     0.185     3.538     0.200
     0.266     5.028     0.200
     0.280     5.348     0.200
     0.267     5.158     0.200
     0.348     6.668     0.200
     0.461     8.338     0.200
     0.441     8.528     0.200
     0.527     9.968     0.200
     0.535    10.268     0.200
     0.743    14.408     0.200
     0.763    14.218     0.200
     0.870    16.038     0.200
     0.911    17.468     0.200
     0.998    18.828     0.200
     1.573    29.458     0.200
     1.603    30.058     0.200
     0.067     2.982     0.200
     0.107     3.082     0.200
     0.209     4.932     0.200
     0.339     7.132     0.200
     0.373     7.422     0.200
     0.456     8.492     0.200
     0.472     9.162     0.200
     0.547    10.062     0.200
     0.552    10.592     0.200
     0.609    11.512     0.200
     0.643    12.912     0.200
     0.680    13.382     0.200
     0.726    13.972     0.200
     0.761    14.552     0.200
     0.864    16.652     0.200
     0.857    16.692     0.200
     0.878    16.982     0.200
     0.888    17.082     0.200
     0.914    17.652     0.200
     1.456    27.272     0.200
     1.712    31.702     0.200
     1.743    32.522     0.200
     1.898    34.722     0.200
     2.101    38.902     0.200
     2.122    38.632     0.200
     2.232    40.122     0.200
     0.558    11.652     0.200
     0.778    14.802     0.200
     1.882    35.322     0.200
     2.954    50.502     0.200
     0.092     2.582     0.200
     0.178     4.113     0.200
     0.242     4.992     0.200
     0.265     5.434     0.200
     0.361     7.082     0.200
     0.404     7.992     0.200
     0.551    10.754     0.200
     0.608    11.895     0.200
     0.638    12.383     0.200
     0.930    17.676     0.200
     1.705    31.613     0.200
     0.097     3.625     0.200
     0.203     4.680     0.200
     0.224     4.766     0.200
     0.329     6.688     0.200
     0.340     6.930     0.200
     0.332     6.688     0.200
     0.465     8.891     0.200
     0.451     8.930     0.200
     0.793    15.031     0.200
     0.752    14.125     0.200
     0.061     2.279     0.200
     0.110     2.549     0.200
     0.131     2.949     0.200
     0.224     4.238     0.200
     0.231     4.389     0.200
     0.284     5.248     0.200
     0.279     6.059     0.200
     0.366     6.658     0.200
     0.443     7.979     0.200
     0.535     9.828     0.200
     0.527     9.918     0.200
     0.523     9.779     0.200
     0.958    18.189     0.200
     0.276     5.020     0.200
     1.263    22.449     0.200
     1.355    24.609     0.200
     1.898    34.600     0.200
     2.527    44.639     0.200
     2.588    45.229     0.200
     2.727    47.840     0.200
     0.208     4.430     0.200
     0.242     4.730     0.200
     0.328     6.621     0.200
     0.351     6.609     0.200
     0.351     6.930     0.200
     0.379     7.371     0.200
     0.469     8.801     0.200
     0.469     8.723     0.200
     0.710    13.441     0.200
     0.746    14.223     0.200
     0.790    14.422     0.200
     0.790    15.473     0.200
     0.790    15.223     0.200
     0.890    17.223     0.200
     1.081    20.359     0.200
     1.100    20.609     0.200
     0.073     2.398     0.200
     0.091     2.648     0.200
     0.150     2.988     0.200
     0.217     4.336     0.200
     0.228     4.348     0.200
     0.270     5.516     0.200
     0.265     5.219     0.200
     0.494     9.098     0.200
     0.538    10.086     0.200
     0.544    10.246     0.200
     1.061    19.855     0.200
     0.064     2.785     0.200
     0.095     3.086     0.200
     0.145     3.438     0.200
     0.213     4.746     0.200
     0.218     4.668     0.200
     0.268     5.816     0.200
     0.488     9.426     0.200
     0.526    10.277     0.200
     0.547    10.555     0.200
     0.628    11.895     0.200
     0.648    11.848     0.200
     0.691    13.168     0.200
     0.693    12.875     0.200
     0.722    13.746     0.200
     0.753    14.125     0.200
     0.753    14.066     0.200
     0.804    15.008     0.200
     1.065    20.105     0.200
     0.137     3.828     0.200
     0.134     3.945     0.200
     0.179     4.969     0.200
     0.246     5.547     0.200
     0.249     5.508     0.200
     0.280     5.898     0.200
     0.363     7.453     0.200
     0.356     7.328     0.200
     0.383     7.984     0.200
     0.394     7.617     0.200
     0.513     9.883     0.200
     0.518    10.430     0.200
     0.534    10.516     0.200
     0.567    10.734     0.200
     0.601    11.688     0.200
     0.650    12.258     0.200
     0.666    12.586     0.200
     0.722    14.227     0.200
     0.741    13.477     0.200
     0.762    14.516     0.200
     0.787    14.898     0.200
     0.801    15.758     0.200
     0.872    16.625     0.200
     0.868    16.953     0.200
     0.956    17.945     0.200
     1.509    28.477     0.200
     0.063     3.093     0.200
     0.102     3.383     0.200
     0.138     3.723     0.200
     0.223     5.023     0.200
     0.222     5.023     0.200
     0.276     5.973     0.200
     0.278     5.433     0.200
     0.435     8.503     0.200
     0.497     9.823     0.200
     0.532    10.473     0.200
     0.529    10.353     0.200
     0.637    12.143     0.200
     0.654    12.603     0.200
     0.665    12.493     0.200
     0.753    14.393     0.200
     1.138    20.813     0.200
     0.163     3.664     0.200
     0.190     3.953     0.200
     0.329     6.625     0.200
     0.382     7.375     0.200
     0.431     8.359     0.200
     0.423     8.234     0.200
     0.458     8.695     0.200
     0.488     9.219     0.200
     0.554    10.430     0.200
     0.587    11.094     0.200
     0.662    12.500     0.200
     0.680    13.062     0.200
     0.683    13.195     0.200
     0.707    13.469     0.200
     0.744    13.945     0.200
     0.753    14.492     0.200
     0.775    14.844     0.200
     0.849    16.078     0.200
     0.857    16.539     0.200
     0.871    16.484     0.200
     0.888    16.742     0.200
     0.933    17.352     0.200
     0.943    18.094     0.200
     0.959    18.516     0.200
     0.997    18.828     0.200
     1.114    20.828     0.200
     1.507    28.102     0.200
     1.530    29.023     0.200
     1.533    28.531     0.200
     1.668    31.062     0.200
     1.749    33.039     0.200
     1.749    32.703     0.200
     1.957    36.070     0.200
     1.976    35.930     0.200
     2.083    37.578     0.200
     0.135     3.070     0.200
     0.134     3.344     0.200
     0.181     3.781     0.200
     0.216     4.641     0.200
     0.257     5.461     0.200
     0.341     6.836     0.200
     0.331     6.672     0.200
     0.416     8.141     0.200
     0.420     8.242     0.200
     0.455     8.844     0.200
     0.661    12.594     0.200
     0.746    14.422     0.200
     0.751    13.930     0.200
     0.769    14.672     0.200
     0.770    14.516     0.200
     0.813    15.375     0.200
     0.866    16.102     0.200
     0.887    16.305     0.200
     0.901    16.750     0.200
     0.928    17.734     0.200
     0.974    17.859     0.200
     0.983    18.453     0.200
     0.984    18.180     0.200
     1.121    21.281     0.200
     1.533    29.211     0.200
     1.535    29.086     0.200
     1.571    29.555     0.200
     1.769    33.336     0.200
     1.787    33.180     0.200
     1.978    36.922     0.200
     2.004    37.273     0.200
     2.120    39.086     0.200
     0.020     2.828     0.200
     0.096     3.219     0.200
     0.148     3.641     0.200
     0.188     4.340     0.200
     0.238     4.938     0.200
     0.475     8.848     0.200
     0.481     9.500     0.200
     0.497     9.539     0.200
     0.504    10.059     0.200
     0.620    11.770     0.200
     0.680    12.648     0.200
     0.703    13.359     0.200
     0.736    14.078     0.200
     0.765    13.598     0.200
     1.116    20.848     0.200
     0.021     2.703     0.200
     0.106     3.141     0.200
     0.138     3.516     0.200
     0.188     4.273     0.200
     0.229     4.734     0.200
     0.380     7.266     0.200
     0.448     8.547     0.200
     0.482     9.320     0.200
     0.491     9.188     0.200
     0.487     9.445     0.200
     0.504     9.773     0.200
     0.584    11.047     0.200
     0.621    11.688     0.200
     0.625    11.703     0.200
     0.672    12.641     0.200
     0.676    13.188     0.200
     0.696    13.602     0.200
     0.709    13.727     0.200
     0.709    13.883     0.200
     0.726    13.266     0.200
     0.731    13.711     0.200
     0.759    14.453     0.200
     0.793    15.227     0.200
     0.817    15.391     0.200
     0.826    15.953     0.200
     0.856    16.055     0.200
     0.912    17.531     0.200
     0.995    18.836     0.200
     1.028    19.195     0.200
     0.134     4.215     0.200
     0.174     4.945     0.200
     0.207     5.266     0.200
     0.299     6.406     0.200
     0.337     7.074     0.200
     0.386     7.707     0.200
     0.486     9.355     0.200
     0.556    10.637     0.200
     0.583    11.184     0.200
     0.625    12.055     0.200
     0.644    12.824     0.200
     0.706    13.016     0.200
     0.724    13.836     0.200
     0.729    13.836     0.200
     0.731    13.957     0.200
     0.768    14.844     0.200
     0.839    14.914     0.200
     0.828    15.797     0.200
     0.939    17.727     0.200
     1.373    25.664     0.200
     2.702    47.574     0.200
     0.147     4.457     0.200
     0.188     5.004     0.200
     0.216     5.254     0.200
     0.313     6.676     0.200
     0.352     7.047     0.200
     0.397     7.844     0.200
     0.498    10.316     0.200
     0.562    10.664     0.200
     0.598    10.977     0.200
     0.636    12.324     0.200
     0.659    13.016     0.200
     0.700    13.094     0.200
     0.712    13.387     0.200
     0.736    14.367     0.200
     0.744    14.297     0.200
     0.783    14.715     0.200
     0.853    16.555     0.200
     0.870    16.824     0.200
     0.946    18.035     0.200
     0.958    17.867     0.200
     1.048    19.527     0.200
     0.157     4.324     0.200
     0.196     5.074     0.200
     0.219     5.375     0.200
     0.323     6.375     0.200
     0.360     7.086     0.200
     0.405     7.234     0.200
     0.568    10.977     0.200
     0.607    11.344     0.200
     0.641    12.227     0.200
     0.668    12.695     0.200
     0.706    13.016     0.200
     0.719    13.605     0.200
     0.745    14.047     0.200
     0.841    15.867     0.200
     0.876    16.855     0.200
     0.961    17.855     0.200
     0.062     2.641     0.200
     0.094     2.930     0.200
     0.147     3.281     0.200
     0.209     4.668     0.200
     0.214     4.570     0.200
     0.286     5.680     0.200
     0.346     6.051     0.200
     0.422     7.930     0.200
     0.484     9.109     0.200
     0.521    10.191     0.200
     0.526    10.051     0.200
     0.544    10.770     0.200
     0.623    11.898     0.200
     0.644    11.918     0.200
     0.651    11.699     0.200
     0.689    13.121     0.200
     0.691    13.070     0.200
     0.716    14.051     0.200
     0.748    13.469     0.200
     0.741    13.949     0.200
     0.867    16.961     0.200
     0.094     3.469     0.200
     0.107     3.438     0.200
     0.155     4.148     0.200
     0.262     5.520     0.200
     0.258     5.707     0.200
     0.287     6.090     0.200
     0.417     8.328     0.200
     0.499     9.629     0.200
     0.525    10.480     0.200
     0.560    10.719     0.200
     0.578    11.449     0.200
     0.609    11.859     0.200
     0.649    12.578     0.200
     0.694    13.250     0.200
     0.697    13.078     0.200
     0.729    13.578     0.200
     0.728    14.129     0.200
     0.737    14.457     0.200
     0.753    14.188     0.200
     0.756    14.348     0.200
     0.791    15.129     0.200
     0.825    14.680     0.200
     0.821    15.117     0.200
     0.842    16.180     0.200
     0.867    16.820     0.200
     1.034    19.359     0.200
     1.137    21.109     0.200
     0.185     4.230     0.200
     0.267     5.520     0.200
     0.303     6.150     0.200
     0.469     9.090     0.200
     0.696    14.100     0.200
     0.865    15.680     0.200
     0.852    16.219     0.200
     0.973    18.270     0.200
     0.994    18.650     0.200
     1.617    29.750     0.200
     0.100     3.219     0.200
     0.115     2.984     0.200
     0.151     3.836     0.200
     0.258     5.688     0.200
     0.317     6.445     0.200
     0.568    10.859     0.200
     0.591    11.375     0.200
     0.612    11.938     0.200
     0.636    11.984     0.200
     0.854    16.539     0.200
     0.960    18.133     0.200
     1.757    32.406     0.200
     0.035     1.977     0.200
     0.245     5.148     0.200
     0.367     6.738     0.200
     0.401     7.770     0.200
     0.453     8.719     0.200
     0.671    13.098     0.200
     0.683    13.930     0.200
     0.705    13.348     0.200
     0.859    15.660     0.200
     0.970    18.090     0.200
     1.082    20.227     0.200
     1.505    28.438     0.200
     0.138     3.242     0.200
     0.170     3.859     0.200
     0.191     4.000     0.200
     0.282     5.758     0.200
     0.293     5.922     0.200
     0.398     7.672     0.200
     0.451     8.859     0.200
     0.467     9.242     0.200
     0.522     9.617     0.200
     0.652    12.695     0.200
     0.661    12.977     0.200
     0.725    14.070     0.200
     0.107     2.648     0.200
     0.126     2.797     0.200
     0.146     3.469     0.200
     0.153     3.484     0.200
     0.300     5.523     0.200
     0.313     6.508     0.200
     0.324     6.125     0.200
     0.515     9.406     0.200
     0.540     9.727     0.200
     0.621    11.398     0.200
     0.160     2.992     0.200
     0.290     5.424     0.200
     0.297     5.562     0.200
     0.301     6.293     0.200
     0.316     6.164     0.200
     0.352     6.844     0.200
     0.424     8.152     0.200
     0.460     8.822     0.200
     0.618    11.783     0.200
     0.697    13.254     0.200
     0.719    13.723     0.200
     0.737    14.504     0.200
     1.053    19.523     0.200
     0.088     2.445     0.200
     0.177     3.977     0.200
     0.223     4.812     0.200
     0.230     4.633     0.200
     0.295     6.258     0.200
     0.335     6.852     0.200
     0.368     7.531     0.200
     0.368     6.992     0.200
     0.489     9.422     0.200
     0.585    11.242     0.200
     0.594    11.484     0.200
     0.030     2.445     0.200
     0.096     3.219     0.200
     0.151     4.055     0.200
     0.195     4.477     0.200
     0.250     5.484     0.200
     0.248     5.586     0.200
     0.328     6.555     0.200
     0.478     9.734     0.200
     0.507     9.836     0.200
     0.516    10.016     0.200
     0.065     2.149     0.200
     0.201     4.249     0.200
     0.261     5.479     0.200
     0.277     5.579     0.200
     0.278     5.829     0.200
     0.279     5.679     0.200
     0.331     6.379     0.200
     0.375     7.699     0.200
     0.389     7.929     0.200
     0.502     9.429     0.200
     0.553    10.579     0.200
     0.596    11.779     0.200
     0.618    11.649     0.200
     0.630    12.139     0.200
     0.702    13.529     0.200
     0.707    13.119     0.200
     0.732    13.539     0.200
     0.703    13.489     0.200
     0.767    14.769     0.200
     0.778    14.189     0.200
     0.825    15.389     0.200
     0.827    15.319     0.200
     0.827    16.409     0.200
     0.855    16.419     0.200
     0.996    19.119     0.200
     1.003    18.389     0.200
     1.576    30.039     0.200
     1.613    30.539     0.200
     1.642    31.089     0.200
     1.974    36.629     0.200
     0.054     1.979     0.200
     0.206     4.309     0.200
     0.271     5.628     0.200
     0.266     5.659     0.200
     0.267     5.519     0.200
     0.282     5.659     0.200
     0.322     6.369     0.200
     0.364     7.479     0.200
     0.377     7.648     0.200
     0.541    10.409     0.200
     0.588    11.528     0.200
     0.620    12.389     0.200
     0.631    12.068     0.200
     0.693    13.528     0.200
     0.717    13.349     0.200
     0.779    15.259     0.200
     0.835    15.878     0.200
     0.839    15.809     0.200
     0.973    18.148     0.200
     0.059     2.129     0.200
     0.203     4.270     0.200
     0.266     5.539     0.200
     0.279     5.619     0.200
     0.272     5.680     0.200
     0.273     5.820     0.200
     0.327     6.299     0.200
     0.369     7.549     0.200
     0.383     7.160     0.200
     0.547    10.689     0.200
     0.592    11.609     0.200
     0.624    12.010     0.200
     0.624    11.850     0.200
     0.625    12.410     0.200
     0.698    13.820     0.200
     0.773    15.061     0.200
     1.858    34.439     0.200
     0.045     1.930     0.200
     0.200     4.188     0.200
     0.259     5.711     0.200
     0.265     5.500     0.200
     0.270     5.578     0.200
     0.276     5.531     0.200
     0.326     6.266     0.200
     0.355     7.336     0.200
     0.372     7.805     0.200
     0.513     9.836     0.200
     0.533    10.406     0.200
     0.578    11.156     0.200
     0.683    13.102     0.200
     0.067     2.367     0.200
     0.133     3.109     0.200
     0.191     4.320     0.200
     0.205     4.047     0.200
     0.205     4.469     0.200
     0.317     6.562     0.200
     0.409     7.883     0.200
     0.423     7.938     0.200
     0.483     9.562     0.200
     0.498     9.609     0.200
     0.563    10.859     0.200
     0.586    11.711     0.200
     1.055    19.953     0.200
     0.060     1.924     0.200
     0.202     4.023     0.200
     0.265     5.375     0.200
     0.278     5.334     0.200
     0.273     5.645     0.200
     0.274     5.574     0.200
     0.328     6.344     0.200
     0.369     7.365     0.200
     0.384     7.314     0.200
     0.592    11.354     0.200
     0.623    11.795     0.200
     0.772    15.234     0.200
     0.051     1.855     0.200
     0.204     4.215     0.200
     0.264     5.496     0.200
     0.271     5.586     0.200
     0.266     5.324     0.200
     0.280     5.574     0.200
     0.323     6.305     0.200
     0.361     7.426     0.200
     0.375     7.465     0.200
     0.513     9.547     0.200
     0.538    10.445     0.200
     0.584    11.523     0.200
     0.616    12.195     0.200
     0.632    12.184     0.200
     0.717    13.113     0.200
     0.781    14.855     0.200
     0.785    14.344     0.200
     0.820    15.523     0.200
     0.841    16.055     0.200
     1.591    29.746     0.200
     1.866    34.684     0.200
     0.039     1.902     0.200
     0.187     3.980     0.200
     0.252     5.191     0.200
     0.263     5.281     0.200
     0.264     5.352     0.200
     0.268     5.449     0.200
     0.346     6.922     0.200
     0.336     6.500     0.200
     0.372     7.551     0.200
     0.527    10.402     0.200
     0.565    10.422     0.200
     0.051     2.023     0.200
     0.206     4.398     0.200
     0.264     5.570     0.200
     0.273     5.734     0.200
     0.264     5.570     0.200
     0.282     5.797     0.200
     0.321     6.273     0.200
     0.361     7.508     0.200
     0.374     7.547     0.200
     0.515     9.734     0.200
     0.538    10.508     0.200
     0.586    11.703     0.200
     0.617    12.156     0.200
     0.633    12.039     0.200
     0.633    12.180     0.200
     0.690    13.477     0.200
     0.719    13.375     0.200
     0.787    14.070     0.200
     0.782    15.047     0.200
     1.011    19.039     0.200
     0.072     2.742     0.200
     0.103     3.023     0.200
     0.182     4.414     0.200
     0.230     5.082     0.200
     0.245     5.094     0.200
     0.338     6.863     0.200
     0.425     8.152     0.200
     0.449     8.703     0.200
     0.523    10.434     0.200
     0.575    11.082     0.200
     0.607    12.215     0.200
     0.607    11.914     0.200
     0.043     1.773     0.200
     0.209     4.242     0.200
     0.255     5.312     0.200
     0.256     5.242     0.200
     0.280     5.664     0.200
     0.286     5.617     0.200
     0.316     6.062     0.200
     0.353     7.273     0.200
     0.365     7.320     0.200
     0.522     9.867     0.200
     0.529    10.188     0.200
     0.579    11.219     0.200
     0.609    11.812     0.200
     0.642    12.133     0.200
     0.642    11.953     0.200
     0.682    13.180     0.200
     0.696    13.609     0.200
     0.726    13.383     0.200
     0.791    14.914     0.200
     0.792    14.609     0.200
     0.819    15.648     0.200
     0.843    16.234     0.200
     0.851    16.297     0.200
     1.022    19.469     0.200
     1.021    19.383     0.200
     1.636    30.562     0.200
     1.667    31.133     0.200
     1.876    34.984     0.200
     1.998    36.633     0.200
     0.045     2.426     0.200
     0.198     4.986     0.200
     0.259     5.436     0.200
     0.265     5.646     0.200
     0.275     5.656     0.200
     0.327     6.696     0.200
     0.355     7.176     0.200
     0.373     7.436     0.200
     0.633    11.936     0.200
     0.683    13.296     0.200
     0.784    15.106     0.200
     0.842    16.056     0.200
     0.259     5.856     0.200
     0.327     6.996     0.200
     0.355     7.676     0.200
     0.355     7.936     0.200
     0.373     7.636     0.200
     0.533    10.776     0.200
     0.577    11.886     0.200
     0.055     3.312     0.200
     0.218     5.164     0.200
     0.274     6.053     0.200
     0.278     6.293     0.200
     0.385     7.994     0.200
     0.466     9.623     0.200
     0.557    10.844     0.200
     0.620    12.334     0.200
     0.654    12.822     0.200
     0.063     2.047     0.200
     0.195     4.289     0.200
     0.271     5.570     0.200
     0.276     5.656     0.200
     0.372     7.391     0.200
     0.390     7.641     0.200
     0.459     8.477     0.200
     0.447     8.719     0.200
     0.498     9.570     0.200
     0.595    11.273     0.200
     0.617    12.109     0.200
     0.618    11.914     0.200
     0.626    11.977     0.200
     0.695    13.453     0.200
     0.767    14.570     0.200
     0.825    15.695     0.200
     1.850    33.969     0.200
     0.049     1.836     0.200
     0.199     4.211     0.200
     0.268     5.609     0.200
     0.262     5.516     0.200
     0.275     5.820     0.200
     0.359     7.250     0.200
     0.376     7.180     0.200
     0.451     8.656     0.200
     0.473     8.891     0.200
     0.510     9.664     0.200
     0.608    11.523     0.200
     0.614    11.984     0.200
     0.631    12.039     0.200
     0.632    12.195     0.200
     0.781    14.898     0.200
     0.781    14.758     0.200
     0.840    16.000     0.200
     1.864    34.250     0.200
     0.530     9.648     0.200
     0.628    12.047     0.200
     2.079    39.656     0.200
     0.083     2.266     0.200
     0.180     3.727     0.200
     0.231     4.719     0.200
     0.257     5.125     0.200
     0.310     6.078     0.200
     0.292     5.891     0.200
     0.361     7.227     0.200
     0.539     9.867     0.200
     0.585    11.109     0.200
     0.605    11.359     0.200
     0.568    10.797     0.200
     0.629    12.695     0.200
     0.750    14.117     0.200
     0.895    17.102     0.200
     0.912    17.117     0.200
     0.900    17.180     0.200
     1.061    20.266     0.200
     1.224    22.977     0.200
     1.892    35.047     0.200
     0.901    16.656     0.200
     0.838    15.820     0.200
     2.437    42.617     0.200
     0.089     2.820     0.200
     0.089     2.914     0.200
     0.161     3.656     0.200
     0.236     5.023     0.200
     0.256     5.102     0.200
     0.295     5.930     0.200
     0.321     6.273     0.200
     0.367     7.133     0.200
     0.511     9.883     0.200
     0.514     9.922     0.200
     0.665    12.773     0.200
     0.785    14.859     0.200
     0.802    15.203     0.200
     0.881    17.062     0.200
     1.181    22.094     0.200
     0.111     2.914     0.200
     0.262     5.043     0.200
     0.263     5.363     0.200
     0.284     5.773     0.200
     0.304     6.215     0.200
     0.562    10.754     0.200
     0.608    11.516     0.200
     0.658    12.402     0.200
     0.646    12.703     0.200
     0.671    12.684     0.200
     0.808    14.895     0.200
     0.818    15.312     0.200
     0.961    18.023     0.200
     0.981    18.715     0.200
     1.146    21.633     0.200
     0.023     2.807     0.200
     0.138     3.646     0.200
     0.191     4.407     0.200
     0.231     4.987     0.200
     0.308     6.417     0.200
     0.318     6.387     0.200
     0.484     9.396     0.200
     0.489     9.707     0.200
     0.585    10.896     0.200
     0.732    13.867     0.200
     0.795    14.967     0.200
     1.161    21.667     0.200
     0.211     4.246     0.200
     0.297     6.035     0.200
     0.410     7.836     0.200
     0.412     7.984     0.200
     0.447     8.625     0.200
     0.468     9.023     0.200
     0.486     9.184     0.200
     0.616    11.586     0.200
     0.654    12.285     0.200
     0.663    12.574     0.200
     0.701    13.266     0.200
     0.786    14.523     0.200
     0.992    18.996     0.200
     1.575    29.574     0.200
     1.608    30.195     0.200
     0.632    12.773     0.200
     0.672    13.266     0.200
     2.157    38.984     0.200
     0.061     1.992     0.200
     0.206     4.352     0.200
     0.268     5.711     0.200
     0.273     5.500     0.200
     0.282     5.699     0.200
     0.371     7.559     0.200
     0.382     7.539     0.200
     0.466     8.570     0.200
     0.452     8.719     0.200
     0.458     8.930     0.200
     0.597    11.352     0.200
     0.624    12.051     0.200
     0.625    11.840     0.200
     0.833    15.762     0.200
     1.047    19.531     0.200
     1.107    20.941     0.200
     1.149    21.629     0.200
     1.859    34.770     0.200
     0.048     2.219     0.200
     0.199     4.418     0.200
     0.262     5.758     0.200
     0.269     5.816     0.200
     0.276     5.770     0.200
     0.358     7.598     0.200
     0.375     7.520     0.200
     0.440     8.719     0.200
     0.452     8.668     0.200
     0.474     8.527     0.200
     0.511     9.668     0.200
     0.609    11.508     0.200
     0.631    12.117     0.200
     0.633    11.887     0.200
     0.686    13.348     0.200
     0.691    13.547     0.200
     0.781    15.020     0.200
     0.782    14.898     0.200
     0.815    15.719     0.200
     0.840    16.156     0.200
     1.865    34.758     0.200
     0.202     4.031     0.200
     0.262     5.648     0.200
     0.278     5.602     0.200
     0.279     5.531     0.200
     0.330     6.445     0.200
     0.375     7.305     0.200
     0.389     7.695     0.200
     0.459     8.328     0.200
     0.452     9.039     0.200
     0.454     8.562     0.200
     0.502     9.062     0.200
     0.617    11.844     0.200
     0.618    11.852     0.200
     0.631    11.812     0.200
     0.703    13.633     0.200
     0.766    14.500     0.200
     0.780    14.945     0.200
     0.827    15.453     0.200
     1.852    34.531     0.200
     0.546    10.094     0.200
     2.063    39.773     0.200
     0.199     4.328     0.200
     0.262     5.375     0.200
     0.274     5.602     0.200
     0.275     5.695     0.200
     0.370     7.797     0.200
     0.386     7.680     0.200
     0.446     8.477     0.200
     0.463     8.656     0.200
     0.451     8.828     0.200
     0.625    11.914     0.200
     0.621    11.914     0.200
     0.621    11.828     0.200
     0.698    13.570     0.200
     0.778    14.906     0.200
     0.213     4.301     0.200
     0.277     5.738     0.200
     0.289     5.859     0.200
     0.375     7.629     0.200
     0.383     7.879     0.200
     0.466     9.012     0.200
     0.460     8.582     0.200
     0.512     9.551     0.200
     0.592    11.430     0.200
     0.602    11.449     0.200
     0.622    11.949     0.200
     0.625    11.930     0.200
     0.632    11.941     0.200
     0.705    13.609     0.200
     0.771    14.770     0.200
     0.790    15.180     0.200
     0.833    15.719     0.200
     0.836    16.469     0.200
     0.052     2.439     0.200
     0.128     3.439     0.200
     0.168     3.939     0.200
     0.202     4.371     0.200
     0.239     4.750     0.200
     0.302     5.689     0.200
     0.326     6.391     0.200
     0.406     8.010     0.200
     0.554    10.891     0.200
     0.551    10.270     0.200
     0.631    11.861     0.200
     0.690    13.910     0.200
     0.697    13.520     0.200
     0.797    15.510     0.200
     0.839    15.461     0.200
     0.919    17.770     0.200
     0.271     5.672     0.200
     0.266     5.484     0.200
     0.267     5.328     0.200
     0.281     5.609     0.200
     0.323     6.258     0.200
     0.363     7.312     0.200
     0.376     7.438     0.200
     0.447     8.680     0.200
     0.472     8.867     0.200
     0.457     8.680     0.200
     0.458     8.859     0.200
     0.512     9.242     0.200
     0.540    10.398     0.200
     0.587    11.234     0.200
     0.603    11.570     0.200
     0.604    11.742     0.200
     0.599    11.203     0.200
     0.619    11.891     0.200
     0.631    11.867     0.200
     0.692    13.312     0.200
     0.698    13.109     0.200
     0.717    13.297     0.200
     0.779    15.141     0.200
     0.785    15.344     0.200
     0.834    15.672     0.200
     0.839    15.844     0.200
     1.009    19.211     0.200
     1.013    18.688     0.200
     1.049    19.883     0.200
     1.111    20.883     0.200
     1.154    21.867     0.200
     1.625    30.289     0.200
     1.834    33.781     0.200
     0.533     9.664     0.200
     0.631    12.008     0.200
     2.076    39.930     0.200
     2.595    46.141     0.200
     0.036     2.777     0.200
     0.127     3.496     0.200
     0.202     4.527     0.200
     0.230     5.109     0.200
     0.253     5.488     0.200
     0.299     6.188     0.200
     0.304     5.996     0.200
     0.375     7.828     0.200
     0.447     7.969     0.200
     0.496     9.617     0.200
     0.502     9.797     0.200
     0.516     9.996     0.200
     0.720    13.559     0.200
     0.723    13.629     0.200
     0.743    14.188     0.200
     0.802    14.828     0.200
     0.061     0.953     0.200
     0.142     2.504     0.200
     0.369     6.754     0.200
     0.374     7.094     0.200
     0.395     7.441     0.200
     0.420     7.223     0.200
     0.533    10.223     0.200
     0.562    10.781     0.200
     0.572    10.383     0.200
     0.802    15.574     0.200
     0.972    18.383     0.200
     0.063     2.879     0.200
     0.091     2.988     0.200
     0.177     4.090     0.200
     0.186     4.188     0.200
     0.252     5.699     0.200
     0.292     5.988     0.200
     0.323     6.598     0.200
     0.309     6.270     0.200
     0.393     7.219     0.200
     0.448     8.559     0.200
     0.488     9.707     0.200
     0.506     9.680     0.200
     0.527    10.238     0.200
     0.587    11.320     0.200
     0.613    11.578     0.200
     0.620    11.668     0.200
     0.669    12.547     0.200
     0.675    12.668     0.200
     0.682    13.199     0.200
     0.690    12.879     0.200
     0.713    13.598     0.200
     0.736    13.969     0.200
     0.055     2.652     0.200
     0.099     2.812     0.200
     0.180     3.926     0.200
     0.180     3.984     0.200
     0.260     5.473     0.200
     0.284     5.805     0.200
     0.316     6.086     0.200
     0.330     6.336     0.200
     0.398     6.875     0.200
     0.449     8.402     0.200
     0.484     9.383     0.200
     0.498     9.594     0.200
     0.508     9.703     0.200
     0.535    10.043     0.200
     0.587    10.902     0.200
     0.608    11.484     0.200
     0.623    11.434     0.200
     0.676    12.254     0.200
     0.680    12.535     0.200
     0.683    12.695     0.200
     0.684    12.902     0.200
     0.695    12.965     0.200
     0.715    13.383     0.200
     0.727    13.875     0.200
     0.762    14.426     0.200
     0.775    14.844     0.200
     0.852    16.086     0.200
     0.865    16.473     0.200
     0.929    18.094     0.200
     0.944    18.266     0.200
     0.983    18.703     0.200
     0.315     6.164     0.200
     1.891    35.434     0.200
     0.060     2.734     0.200
     0.092     2.914     0.200
     0.180     3.984     0.200
     0.187     4.023     0.200
     0.255     5.445     0.200
     0.290     5.812     0.200
     0.308     6.242     0.200
     0.397     7.094     0.200
     0.451     8.477     0.200
     0.490     9.664     0.200
     0.506     9.367     0.200
     0.590    11.242     0.200
     0.615    11.500     0.200
     0.623    11.766     0.200
     0.672    12.555     0.200
     0.678    12.766     0.200
     0.685    13.086     0.200
     0.692    13.641     0.200
     0.717    13.555     0.200
     0.767    14.477     0.200
     0.976    18.844     0.200
     1.122    21.094     0.200
     0.090     2.008     0.200
     0.105     2.098     0.200
     0.216     4.367     0.200
     0.260     5.551     0.200
     0.293     5.609     0.200
     0.348     6.809     0.200
     0.335     6.340     0.200
     0.369     6.758     0.200
     0.362     6.699     0.200
     0.375     7.367     0.200
     0.383     6.879     0.200
     0.498     9.469     0.200
     0.516     9.777     0.200
     0.554    10.340     0.200
     0.561     9.859     0.200
     0.613    11.059     0.200
     0.834    16.168     0.200
     0.882    16.051     0.200
     0.931    17.488     0.200
     1.361    25.188     0.200
     0.090     3.805     0.200
     0.170     4.625     0.200
     0.188     4.859     0.200
     0.262     5.984     0.200
     0.310     6.547     0.200
     0.323     7.055     0.200
     0.330     7.055     0.200
     0.323     7.125     0.200
     0.385     8.477     0.200
     0.442     8.305     0.200
     0.409     8.586     0.200
     0.434     9.258     0.200
     0.534    10.500     0.200
     0.610    11.758     0.200
     0.582    11.422     0.200
     0.639    12.102     0.200
     0.674    12.977     0.200
     0.734    14.656     0.200
     0.767    14.734     0.200
     0.792    14.641     0.200
     0.810    15.289     0.200
     0.834    15.617     0.200
     0.897    16.820     0.200
     1.004    18.836     0.200
     1.518    28.266     0.200
     1.574    29.047     0.200
     1.727    31.195     0.200
     1.739    31.406     0.200
     1.789    32.320     0.200
     1.907    34.195     0.200
     1.930    34.180     0.200
     1.958    34.805     0.200
     0.119     2.023     0.200
     0.228     4.055     0.200
     0.210     4.434     0.200
     0.247     4.613     0.200
     0.272     4.844     0.200
     0.389     7.074     0.200
     0.384     7.105     0.200
     0.476     8.703     0.200
     0.527     9.926     0.200
     0.545    10.383     0.200
     0.551    10.035     0.200
     0.661    12.203     0.200
     0.703    13.156     0.200
     0.719    13.164     0.200
     0.846    15.645     0.200
     0.828    15.996     0.200
     0.971    18.176     0.200
     1.589    30.004     0.200
     0.207     4.219     0.200
     0.268     5.531     0.200
     0.283     5.531     0.200
     0.272     5.508     0.200
     0.274     5.648     0.200
     0.324     6.297     0.200
     0.371     7.469     0.200
     0.383     7.617     0.200
     0.466     8.688     0.200
     0.452     8.680     0.200
     0.453     8.594     0.200
     0.459     8.688     0.200
     0.509     9.641     0.200
     0.548    10.578     0.200
     0.596    11.156     0.200
     0.602    11.484     0.200
     0.595    11.570     0.200
     0.623    11.727     0.200
     0.625    11.641     0.200
     0.627    11.977     0.200
     0.704    13.156     0.200
     0.700    13.375     0.200
     0.714    13.188     0.200
     0.735    13.586     0.200
     0.772    14.555     0.200
     0.785    15.117     0.200
     0.832    15.758     0.200
     0.833    15.625     0.200
     0.829    15.578     0.200
     0.969    18.320     0.200
     1.002    18.750     0.200
     1.010    18.961     0.200
     1.582    30.039     0.200
     1.620    30.508     0.200
     1.649    30.930     0.200
     1.829    33.727     0.200
     1.859    34.555     0.200
     1.980    36.484     0.200
     0.541    10.000     0.200
     0.639    12.219     0.200
     0.615    11.648     0.200
     2.068    39.750     0.200
     2.589    45.727     0.200
     0.061     1.500     0.200
     0.174     3.910     0.200
     0.196     3.680     0.200
     0.241     5.129     0.200
     0.320     6.098     0.200
     0.429     7.688     0.200
     0.480     8.891     0.200
     0.490     9.238     0.200
     0.487     9.039     0.200
     0.512     9.539     0.200
     0.716    13.359     0.200
     0.757    13.508     0.200
     1.037    19.398     0.200
     1.105    20.500     0.200
     1.153    21.621     0.200
     1.182    22.230     0.200
     1.573    29.039     0.200
     1.673    31.578     0.200
     1.772    33.141     0.200
     1.776    32.891     0.200
     1.835    34.000     0.200
     0.050     0.984     0.200
     0.129     2.516     0.200
     0.247     5.125     0.200
     0.277     5.277     0.200
     0.294     5.766     0.200
     0.354     6.895     0.200
     0.374     6.707     0.200
     0.394     6.867     0.200
     0.458     8.816     0.200
     0.592    10.656     0.200
     0.805    14.996     0.200
     0.835    15.535     0.200
     0.908    16.574     0.200
     0.959    17.477     0.200
     0.099     3.266     0.200
     0.236     5.031     0.200
     0.241     5.031     0.200
     0.236     5.047     0.200
     0.334     6.734     0.200
     0.389     7.266     0.200
     0.376     7.375     0.200
     0.370     7.445     0.200
     0.378     7.484     0.200
     0.445     8.438     0.200
     0.451     8.891     0.200
     0.513     9.688     0.200
     0.528     9.930     0.200
     0.594    11.445     0.200
     0.598    11.305     0.200
     0.582    11.734     0.200
     0.740    13.625     0.200
     0.715    14.008     0.200
     0.755    14.422     0.200
     0.743    14.469     0.200
     0.756    15.250     0.200
     0.795    14.609     0.200
     0.784    15.531     0.200
     0.825    15.656     0.200
     0.953    17.477     0.200
     0.951    17.508     0.200
     0.996    18.445     0.200
     1.086    20.391     0.200
     1.120    20.695     0.200
     1.475    27.406     0.200
     1.533    28.398     0.200
     1.591    29.250     0.200
     1.604    29.156     0.200
     1.646    30.305     0.200
     1.730    31.969     0.200
     1.744    32.422     0.200
     1.805    32.945     0.200
     0.135     2.992     0.200
     0.212     4.320     0.200
     0.220     4.758     0.200
     0.296     5.922     0.200
     0.320     6.570     0.200
     0.354     6.258     0.200
     0.372     6.977     0.200
     0.427     8.680     0.200
     0.547     9.922     0.200
     0.594    11.086     0.200
     0.636    11.617     0.200
     0.612    11.922     0.200
     0.863    16.008     0.200
     0.912    16.867     0.200
     0.943    17.422     0.200
     1.690    31.492     0.200
     1.902    34.828     0.200
     0.081     2.852     0.200
     0.184     3.867     0.200
     0.231     4.789     0.200
     0.251     5.312     0.200
     0.262     5.352     0.200
     0.361     6.992     0.200
     0.406     8.258     0.200
     0.491     9.547     0.200
     0.552    10.656     0.200
     0.591    11.812     0.200
     0.634    12.391     0.200
     0.641    12.672     0.200
     0.657    12.398     0.200
     0.926    16.750     0.200
     0.943    17.562     0.200
     0.944    17.531     0.200
     0.987    18.258     0.200
     1.112    20.930     0.200
     1.129    20.266     0.200
     1.316    24.180     0.200
     1.634    29.992     0.200
     1.653    30.672     0.200
     1.665    30.516     0.200
     1.675    30.445     0.200
     1.731    31.938     0.200
     1.791    33.109     0.200
     1.838    33.508     0.200
     1.929    35.062     0.200
     1.939    35.578     0.200
     0.099     3.049     0.200
     0.175     4.209     0.200
     0.246     5.420     0.200
     0.241     5.139     0.200
     0.309     5.818     0.200
     0.307     6.600     0.200
     0.349     7.219     0.200
     0.378     7.379     0.200
     0.373     7.539     0.200
     0.592    11.299     0.200
     0.587    10.979     0.200
     0.604    11.080     0.200
     0.584    11.600     0.200
     0.639    12.449     0.200
     0.646    13.459     0.200
     0.740    13.359     0.200
     0.873    16.090     0.200
     0.896    16.389     0.200
     1.138    21.369     0.200
     1.621    29.750     0.200
     1.675    30.920     0.200
     1.736    31.600     0.200
     1.781    33.340     0.200
     1.883    34.689     0.200
     1.942    35.379     0.200
     0.040     3.066     0.200
     0.223     5.508     0.200
     0.297     6.207     0.200
     0.306     6.996     0.200
     0.397     7.957     0.200
     0.435     8.688     0.200
     0.505     9.578     0.200
     0.502     9.637     0.200
     0.486    10.207     0.200
     0.630    11.406     0.200
     0.598    11.758     0.200
     0.611    12.246     0.200
     0.753    14.297     0.200
     0.787    14.805     0.200
     0.837    15.605     0.200
     0.896    16.945     0.200
     0.900    16.367     0.200
     1.630    30.016     0.200
     1.646    29.625     0.200
     1.712    30.535     0.200
     1.763    31.957     0.200
     1.774    31.965     0.200
     1.818    32.875     0.200
     1.825    33.137     0.200
     0.112     3.476     0.200
     0.144     3.696     0.200
     0.177     4.756     0.200
     0.238     5.086     0.200
     0.254     5.296     0.200
     0.255     5.596     0.200
     0.367     7.136     0.200
     0.401     8.016     0.200
     0.478     9.276     0.200
     0.508     9.456     0.200
     0.539    10.546     0.200
     0.552    10.476     0.200
     0.606    11.326     0.200
     0.621    11.896     0.200
     0.636    12.076     0.200
     0.661    12.236     0.200
     0.743    14.046     0.200
     0.772    14.436     0.200
     0.792    15.306     0.200
     0.787    14.466     0.200
     0.805    15.336     0.200
     0.865    16.306     0.200
     1.029    19.296     0.200
     1.484    27.686     0.200
     0.196     3.727     0.200
     0.261     5.227     0.200
     0.272     5.406     0.200
     0.271     5.625     0.200
     0.276     5.523     0.200
     0.332     6.367     0.200
     0.366     7.289     0.200
     0.384     7.680     0.200
     0.442     8.516     0.200
     0.448     8.469     0.200
     0.465     8.719     0.200
     0.449     8.688     0.200
     0.503     9.516     0.200
     0.545    10.547     0.200
     0.593    11.305     0.200
     0.587    11.508     0.200
     0.601    11.438     0.200
     0.622    11.766     0.200
     0.624    11.828     0.200
     0.621    11.844     0.200
     0.693    13.148     0.200
     0.694    13.250     0.200
     0.707    13.375     0.200
     0.773    14.609     0.200
     0.818    15.727     0.200
     0.824    15.570     0.200
     0.964    18.000     0.200
     1.003    19.164     0.200
     1.002    19.078     0.200
     1.039    20.000     0.200
     1.102    20.727     0.200
     1.146    21.656     0.200
     1.616    30.656     0.200
     1.825    33.609     0.200
     1.856    34.258     0.200
     1.979    36.266     0.200
     0.142     3.508     0.200
     0.127     3.430     0.200
     0.281     5.492     0.200
     0.255     5.500     0.200
     0.276     5.719     0.200
     0.346     6.609     0.200
     0.360     7.312     0.200
     0.339     7.102     0.200
     0.358     7.141     0.200
     0.405     8.078     0.200
     0.506     9.617     0.200
     0.557    10.422     0.200
     0.563    10.508     0.200
     0.574    10.617     0.200
     0.602    11.844     0.200
     0.611    12.062     0.200
     0.665    13.141     0.200
     0.704    13.109     0.200
     0.706    13.609     0.200
     0.672    13.211     0.200
     0.790    14.844     0.200
     0.797    14.789     0.200
     0.841    15.664     0.200
     0.865    16.164     0.200
     0.853    16.617     0.200
     0.870    16.164     0.200
     0.886    16.453     0.200
     0.895    16.508     0.200
     1.039    19.461     0.200
     1.103    20.883     0.200
     1.574    29.312     0.200
     1.587    29.500     0.200
     1.586    29.641     0.200
     1.639    30.438     0.200
     1.690    31.281     0.200
     1.701    31.453     0.200
     1.746    32.352     0.200
     1.837    33.539     0.200
     1.847    33.289     0.200
     1.907    34.352     0.200
     0.855    15.750     0.200
     0.870    16.484     0.200
     1.827    33.039     0.200
     1.911    33.781     0.200
     2.483    42.797     0.200
     0.118     2.852     0.200
     0.217     4.559     0.200
     0.327     6.391     0.200
     0.347     6.449     0.200
     0.346     6.980     0.200
     0.364     7.051     0.200
     0.698    12.941     0.200
     0.783    14.738     0.200
     1.046    19.539     0.200
     1.059    19.461     0.200
     1.653    30.500     0.200
     0.170     4.055     0.200
     0.199     4.344     0.200
     0.223     4.930     0.200
     0.299     6.320     0.200
     0.351     6.586     0.200
     0.364     6.727     0.200
     0.461     8.750     0.200
     0.553    10.305     0.200
     0.579    11.320     0.200
     0.612    11.828     0.200
     0.638    12.055     0.200
     0.655    12.375     0.200
     0.770    14.461     0.200
     0.770    14.680     0.200
     0.779    14.266     0.200
     0.770    14.680     0.200
     0.788    14.719     0.200
     0.788    14.680     0.200
     0.803    15.711     0.200
     0.837    15.367     0.200
     0.860    16.344     0.200
     0.853    16.289     0.200
     0.870    16.297     0.200
     0.943    17.758     0.200
     0.959    17.938     0.200
     0.981    18.359     0.200
     0.996    19.109     0.200
     1.011    18.906     0.200
     1.041    19.477     0.200
     1.050    19.914     0.200
     1.134    21.109     0.200
     1.248    23.125     0.200
     0.351     6.750     0.200
     0.364     7.117     0.200
     0.461     8.586     0.200
     0.579    11.469     0.200
     0.655    12.477     0.200
     0.770    14.594     0.200
     0.779    14.414     0.200
     0.837    15.727     0.200
     0.870    16.930     0.200
     0.959    18.258     0.200
     0.981    18.508     0.200
     1.011    19.320     0.200
     1.041    19.906     0.200
     1.050    20.047     0.200
     1.248    23.016     0.200
     0.212     4.836     0.200
     0.763    14.547     0.200
     1.308    23.430     0.200
     0.135     3.289     0.200
     0.134     3.641     0.200
     0.213     4.633     0.200
     0.289     5.680     0.200
     0.302     5.602     0.200
     0.312     6.188     0.200
     0.398     7.398     0.200
     0.489     9.000     0.200
     0.578    10.453     0.200
     0.579    11.180     0.200
     0.596    11.414     0.200
     0.613    11.672     0.200
     0.713    13.523     0.200
     0.720    13.414     0.200
     0.725    13.250     0.200
     0.727    13.398     0.200
     0.733    14.000     0.200
     0.773    14.609     0.200
     0.787    14.992     0.200
     0.782    14.812     0.200
     0.810    14.969     0.200
     0.853    16.344     0.200
     0.892    16.984     0.200
     0.925    17.648     0.200
     0.969    18.398     0.200
     0.968    18.562     0.200
     0.991    18.750     0.200
     0.996    18.992     0.200
     1.078    20.391     0.200
     1.090    20.664     0.200
     1.184    21.961     0.200
     0.331     6.609     0.200
     0.320     6.578     0.200
     0.341     6.859     0.200
     0.358     6.875     0.200
     0.417     7.664     0.200
     0.409     7.984     0.200
     0.419     8.398     0.200
     0.459     9.047     0.200
     0.482     9.336     0.200
     0.527    10.273     0.200
     0.535    10.094     0.200
     0.575    10.875     0.200
     0.616    11.930     0.200
     0.686    13.156     0.200
     0.687    12.859     0.200
     0.692    13.438     0.200
     0.763    14.797     0.200
     0.787    15.000     0.200
     0.860    16.414     0.200
     0.868    16.344     0.200
     0.894    16.547     0.200
     0.868    16.414     0.200
     0.880    16.609     0.200
     0.917    17.375     0.200
     1.101    20.773     0.200
     1.595    29.328     0.200
     1.816    33.227     0.200
     0.093     2.750     0.200
     0.230     5.055     0.200
     0.252     5.516     0.200
     0.293     5.922     0.200
     0.306     6.609     0.200
     0.353     7.031     0.200
     0.379     7.375     0.200
     0.479     9.398     0.200
     0.588    11.164     0.200
     0.590    11.352     0.200
     0.578    11.266     0.200
     1.205    22.328     0.200
     0.108     3.029     0.200
     0.133     3.039     0.200
     0.229     4.818     0.200
     0.232     4.859     0.200
     0.343     6.928     0.200
     0.391     7.529     0.200
     0.466     9.020     0.200
     0.470     9.008     0.200
     0.460     9.398     0.200
     0.568    11.088     0.200
     0.594    11.418     0.200
     0.610    11.879     0.200
     0.641    11.969     0.200
     0.667    12.918     0.200
     0.711    13.449     0.200
     0.813    15.469     0.200
     0.939    17.988     0.200
     0.979    18.738     0.200
     1.033    19.449     0.200
     2.048    37.109     0.200
     0.111     2.926     0.200
     0.135     3.637     0.200
     0.279     5.926     0.200
     0.317     6.277     0.200
     0.398     7.738     0.200
     0.480     9.195     0.200
     0.521     9.879     0.200
     0.664    12.539     0.200
     0.733    13.527     0.200
     0.745    14.176     0.200
     0.783    14.656     0.200
     1.153    21.676     0.200
     1.829    33.789     0.200
     2.283    41.105     0.200
     0.021     2.016     0.200
     0.173     3.922     0.200
     0.172     3.797     0.200
     0.271     5.734     0.200
     0.349     6.945     0.200
     0.447     8.570     0.200
     0.501     9.961     0.200
     0.517    10.227     0.200
     0.539    11.086     0.200
     0.552    10.633     0.200
     0.572    11.281     0.200
     1.595    29.906     0.200
     0.219     4.602     0.200
     0.228     4.480     0.200
     0.281     5.543     0.200
     0.309     5.902     0.200
     0.342     7.082     0.200
     0.361     6.891     0.200
     0.385     7.500     0.200
     0.393     7.711     0.200
     0.524     9.633     0.200
     0.538    10.062     0.200
     0.561    10.512     0.200
     0.642    12.312     0.200
     0.653    12.562     0.200
     0.691    12.922     0.200
     0.703    13.262     0.200
     0.726    14.191     0.200
     0.886    16.781     0.200
     0.927    17.332     0.200
     1.052    20.012     0.200
     1.105    20.973     0.200
     1.144    21.762     0.200
     1.192    22.453     0.200
     1.216    22.871     0.200
     1.926    35.652     0.200
     0.153     4.098     0.200
     0.156     4.348     0.200
     0.177     4.488     0.200
     0.204     4.816     0.200
     0.422     8.516     0.200
     0.452     9.238     0.200
     0.449     9.129     0.200
     0.469     8.758     0.200
     0.475     9.578     0.200
     0.546    10.098     0.200
     0.601    11.996     0.200
     0.606    11.746     0.200
     0.613    12.328     0.200
     0.662    12.617     0.200
     0.688    13.898     0.200
     0.688    13.578     0.200
     0.731    14.188     0.200
     0.792    15.387     0.200
     0.874    16.336     0.200
     0.864    16.469     0.200
     0.874    16.387     0.200
     1.169    21.449     0.200
     0.071     1.914     0.200
     0.144     2.555     0.200
     0.141     3.352     0.200
     0.449     8.719     0.200
     0.481     9.352     0.200
     0.466     9.141     0.200
     0.451     8.867     0.200
     0.569    10.578     0.200
     0.691    13.352     0.200
     0.735    13.508     0.200
     1.263    23.719     0.200
     1.765    32.656     0.200
     1.811    34.031     0.200
     1.980    36.555     0.200
     2.075    37.406     0.200
     2.082    37.867     0.200
     0.017     2.686     0.200
     0.161     3.615     0.200
     0.223     4.916     0.200
     0.221     4.945     0.200
     0.322     6.625     0.200
     0.357     7.075     0.200
     0.386     7.166     0.200
     0.445     8.556     0.200
     0.450     8.855     0.200
     0.449     8.525     0.200
     0.469     9.306     0.200
     0.585    11.255     0.200
     0.601    11.835     0.200
     0.595    11.166     0.200
     0.639    12.766     0.200
     0.662    12.255     0.200
     0.678    12.575     0.200
     0.666    12.855     0.200
     0.719    13.815     0.200
     0.741    13.936     0.200
     0.734    13.646     0.200
     0.745    13.815     0.200
     0.743    13.936     0.200
     0.763    15.005     0.200
     0.818    16.266     0.200
     0.802    15.375     0.200
     0.883    17.186     0.200
     0.936    17.476     0.200
     1.046    19.875     0.200
     0.116     3.031     0.200
     0.256     5.090     0.200
     0.275     5.461     0.200
     0.316     6.281     0.200
     0.365     7.410     0.200
     0.433     8.641     0.200
     0.422     8.301     0.200
     0.465     8.641     0.200
     0.467     9.168     0.200
     0.443     9.008     0.200
     0.479     9.129     0.200
     0.516     9.629     0.200
     0.501     9.352     0.200
     0.580    11.418     0.200
     0.624    11.660     0.200
     0.617    11.699     0.200
     0.630    11.898     0.200
     0.660    12.238     0.200
     0.662    12.590     0.200
     0.685    12.730     0.200
     0.703    12.852     0.200
     0.702    13.090     0.200
     0.682    13.418     0.200
     0.790    14.852     0.200
     0.858    16.000     0.200
     0.838    16.379     0.200
     0.876    16.430     0.200
     0.879    16.328     0.200
     0.913    17.508     0.200
     0.981    18.289     0.200
     1.005    18.488     0.200
     1.024    19.289     0.200
     1.464    27.520     0.200
     1.533    28.781     0.200
     1.608    30.109     0.200
     1.627    29.910     0.200
     1.689    31.578     0.200
     0.359     8.441     0.200
     0.621    11.480     0.200
     1.598    29.578     0.200
     1.685    30.398     0.200
     0.087     1.996     0.200
     0.135     3.006     0.200
     0.172     3.186     0.200
     0.169     3.096     0.200
     0.223     4.535     0.200
     0.308     5.557     0.200
     0.405     8.387     0.200
     0.469     9.205     0.200
     0.463     8.986     0.200
     0.495    10.486     0.200
     0.589    10.605     0.200
     0.607    11.045     0.200
     0.609    12.236     0.200
     0.643    12.016     0.200
     0.676    12.416     0.200
     0.717    14.045     0.200
     0.778    14.836     0.200
     0.160     3.055     0.200
     0.209     3.633     0.200
     0.228     4.680     0.200
     0.322     6.219     0.200
     0.311     5.469     0.200
     0.345     6.742     0.200
     0.333     6.336     0.200
     0.374     6.969     0.200
     0.448     8.562     0.200
     0.483     9.141     0.200
     0.635    12.422     0.200
     0.695    13.711     0.200
     0.704    13.586     0.200
     0.874    15.984     0.200
     0.865    16.281     0.200
     0.886    17.305     0.200
     0.927    17.453     0.200
     0.043     2.539     0.200
     0.174     3.660     0.200
     0.190     3.869     0.200
     0.264     4.859     0.200
     0.357     7.010     0.200
     0.362     6.859     0.200
     0.425     7.549     0.200
     0.447     9.000     0.200
     0.485     9.490     0.200
     0.602    10.840     0.200
     0.632    12.000     0.200
     0.645    12.510     0.200
     0.773    14.641     0.200
     0.779    14.799     0.200
     0.780    14.660     0.200
     0.792    14.990     0.200
     0.786    15.160     0.200
     0.827    16.170     0.200
     1.024    19.270     0.200
     1.191    21.650     0.200
     0.076     2.762     0.200
     0.226     4.371     0.200
     0.278     5.129     0.200
     0.387     7.629     0.200
     0.392     7.988     0.200
     0.407     7.930     0.200
     0.499     9.480     0.200
     0.571    10.980     0.200
     0.604    11.852     0.200
     0.658    12.488     0.200
     0.665    12.961     0.200
     0.745    14.230     0.200
     0.773    14.391     0.200
     0.775    14.770     0.200
     0.790    14.730     0.200
     0.796    15.719     0.200
     0.807    15.512     0.200
     0.820    15.488     0.200
     1.086    20.551     0.200
     1.202    22.359     0.200
     0.054     2.406     0.200
     0.123     2.625     0.200
     0.217     4.906     0.200
     0.226     4.711     0.200
     0.244     4.906     0.200
     0.244     4.906     0.200
     0.313     6.547     0.200
     0.362     7.227     0.200
     0.386     7.672     0.200
     0.395     7.891     0.200
     0.466     8.898     0.200
     0.626    11.992     0.200
     0.657    12.641     0.200
     0.676    13.102     0.200
     0.681    13.172     0.200
     0.749    14.336     0.200
     0.794    15.219     0.200
     0.796    15.078     0.200
     1.457    27.125     0.200
     0.117     3.742     0.200
     0.144     3.914     0.200
     0.156     4.102     0.200
     0.164     4.312     0.200
     0.342     7.281     0.200
     0.385     7.844     0.200
     0.450     9.078     0.200
     0.500     9.734     0.200
     0.550    10.305     0.200
     0.591    11.758     0.200
     0.650    12.773     0.200
     0.654    12.555     0.200
     0.656    12.953     0.200
     0.704    12.844     0.200
     0.717    13.531     0.200
     0.727    14.031     0.200
     0.724    13.672     0.200
     0.735    13.836     0.200
     0.825    15.844     0.200
     1.407    26.375     0.200
     1.224    21.266     0.200
     1.784    33.711     0.200
     1.949    34.883     0.200
     0.252     5.582     0.200
     0.348     6.953     0.200
     0.449     8.574     0.200
     0.424     8.641     0.200
     0.468     8.941     0.200
     0.480     9.121     0.200
     0.679    13.031     0.200
     0.678    13.012     0.200
     0.759    14.262     0.200
     0.812    15.633     0.200
     0.910    16.883     0.200
     0.953    17.730     0.200
     1.032    19.371     0.200
     1.126    21.203     0.200
     1.187    22.074     0.200
     1.260    23.574     0.200
     1.298    23.812     0.200
     1.655    30.582     0.200
     1.700    31.383     0.200
     1.765    32.621     0.200
     1.799    33.242     0.200
     1.969    36.004     0.200
     2.025    36.871     0.200
     2.132    38.652     0.200
     2.274    41.012     0.200
     0.233     4.730     0.200
     0.953    18.043     0.200
     1.187    22.371     0.200
     1.298    24.172     0.200
     1.655    31.094     0.200
     1.700    31.562     0.200
     1.765    32.512     0.200
     2.151    38.730     0.200
     2.264    40.922     0.200
     2.441    43.883     0.200
     0.453     8.574     0.200
     1.415    25.973     0.200
     3.343    60.414     0.200
     0.249     4.980     0.200
     0.234     4.871     0.200
     0.320     6.062     0.200
     0.396     7.312     0.200
     0.484     9.820     0.200
     0.494     9.852     0.200
     0.520     9.742     0.200
     0.598    11.094     0.200
     0.636    11.504     0.200
     0.645    12.023     0.200
     0.684    13.660     0.200
     0.741    14.070     0.200
     0.745    13.832     0.200
     0.811    15.062     0.200
     1.038    19.641     0.200
     1.161    22.070     0.200
     0.248     5.203     0.200
     0.252     5.086     0.200
     0.297     6.086     0.200
     0.339     6.641     0.200
     0.373     7.492     0.200
     0.370     7.367     0.200
     0.495     8.773     0.200
     0.501     9.570     0.200
     0.540    10.406     0.200
     0.548    10.477     0.200
     0.572    10.430     0.200
     0.574    11.000     0.200
     0.570    10.711     0.200
     0.663    12.523     0.200
     0.657    12.742     0.200
     0.673    12.930     0.200
     0.746    14.250     0.200
     0.780    14.672     0.200
     0.823    15.492     0.200
     0.868    16.547     0.200
     0.870    16.422     0.200
     0.905    16.930     0.200
     1.016    19.312     0.200
     1.026    19.320     0.200
     1.082    20.266     0.200
     1.166    22.031     0.200
     1.666    30.805     0.200
     1.676    30.820     0.200
     1.897    34.602     0.200
     2.010    36.336     0.200
     0.565    10.000     0.200
     0.667    13.047     0.200
     2.067    38.961     0.200
     2.621    47.234     0.200
     0.055     2.648     0.200
     0.217     5.039     0.200
     0.240     5.488     0.200
     0.256     5.266     0.200
     0.220     5.336     0.200
     0.297     6.219     0.200
     0.404     7.945     0.200
     0.440     8.707     0.200
     0.436     8.527     0.200
     0.558    10.688     0.200
     0.641    12.176     0.200
     0.683    12.836     0.200
     0.909    17.527     0.200
     1.589    28.977     0.200
     1.603    29.695     0.200
     1.686    31.059     0.200
     1.727    31.496     0.200
     2.102    37.438     0.200
     2.178    39.188     0.200
     2.296    40.977     0.200
     2.316    41.379     0.200
     0.287     5.625     0.200
     0.300     5.742     0.200
     0.306     6.148     0.200
     0.359     7.328     0.200
     0.359     7.070     0.200
     0.435     8.570     0.200
     0.464     9.109     0.200
     0.512     9.555     0.200
     0.523    10.062     0.200
     0.529    10.148     0.200
     0.554    10.992     0.200
     0.723    13.773     0.200
     0.797    14.953     0.200
     0.836    15.344     0.200
     0.148     3.566     0.200
     0.239     5.326     0.200
     0.394     8.105     0.200
     0.544    10.676     0.200
     0.562    11.276     0.200
     0.629    12.546     0.200
     0.793    15.516     0.200
     0.943    17.716     0.200
     1.150    21.266     0.200
     0.113     3.039     0.200
     0.177     3.789     0.200
     0.242     4.945     0.200
     0.328     6.258     0.200
     0.480     8.930     0.200
     0.479     9.195     0.200
     0.478     9.258     0.200
     0.492     9.305     0.200
     0.579    10.695     0.200
     0.614    11.617     0.200
     0.610    11.203     0.200
     0.662    12.469     0.200
     0.668    12.703     0.200
     0.703    13.648     0.200
     0.749    14.633     0.200
     0.781    15.086     0.200
     0.821    15.727     0.200
     1.025    19.289     0.200
     1.103    20.734     0.200
     0.324     5.773     0.200
     0.688    12.773     0.200
     1.287    23.844     0.200
     0.608    11.641     0.200
     0.163     3.289     0.200
     0.206     4.330     0.200
     0.236     4.510     0.200
     0.316     6.459     0.200
     0.332     6.600     0.200
     0.384     7.279     0.200
     0.393     7.439     0.200
     0.404     8.010     0.200
     0.435     8.020     0.200
     0.447     8.359     0.200
     0.545    10.301     0.200
     0.567    10.641     0.200
     0.590    11.340     0.200
     0.652    12.119     0.200
     0.653    12.439     0.200
     0.665    12.980     0.200
     0.725    13.709     0.200
     0.722    13.619     0.200
     0.729    13.689     0.200
     0.771    14.391     0.200
     0.777    14.689     0.200
     0.950    18.410     0.200
     0.952    17.580     0.200
     0.987    19.260     0.200
     1.559    30.180     0.200
     1.593    30.039     0.200
     1.769    33.221     0.200
     1.800    33.869     0.200
     1.924    35.740     0.200
     0.582    11.160     0.200
     0.677    12.420     0.200
     2.532    44.949     0.200
     2.787    48.820     0.200
     2.852    49.949     0.200
     0.211     3.938     0.200
     0.244     4.688     0.200
     0.293     6.090     0.200
     0.326     5.816     0.200
     0.363     6.898     0.200
     0.391     7.449     0.200
     0.433     8.039     0.200
     0.521     9.699     0.200
     0.515     9.648     0.200
     0.602    11.438     0.200
     0.669    12.477     0.200
     0.702    13.129     0.200
     0.718    13.449     0.200
     0.887    17.418     0.200
     0.888    16.938     0.200
     0.204     4.605     0.200
     0.293     6.235     0.200
     0.303     6.415     0.200
     0.341     6.975     0.200
     0.371     7.575     0.200
     0.361     7.285     0.200
     0.415     8.075     0.200
     0.407     8.175     0.200
     0.463     9.205     0.200
     0.484     9.455     0.200
     0.501     9.415     0.200
     0.512    10.105     0.200
     0.529    10.335     0.200
     0.582    11.445     0.200
     0.648    12.435     0.200
     0.679    12.815     0.200
     0.667    12.625     0.200
     0.678    12.805     0.200
     0.711    13.005     0.200
     0.758    14.335     0.200
     0.763    14.225     0.200
     0.770    14.925     0.200
     0.830    15.895     0.200
     0.845    15.655     0.200
     0.843    16.195     0.200
     0.905    17.145     0.200
     0.942    17.385     0.200
     0.961    18.315     0.200
     1.065    20.125     0.200
     1.084    20.155     0.200
     1.491    27.725     0.200
     1.570    29.465     0.200
     1.692    31.715     0.200
     1.796    33.025     0.200
     1.903    35.145     0.200
     0.146     4.449     0.200
     0.159     4.631     0.200
     0.180     4.801     0.200
     0.192     5.301     0.200
     0.325     6.830     0.200
     0.330     7.051     0.200
     0.406     8.180     0.200
     0.580    11.359     0.200
     0.589    11.211     0.200
     0.601    11.760     0.200
     0.620    12.260     0.200
     0.636    12.520     0.200
     0.721    13.410     0.200
     0.730    14.080     0.200
     0.733    14.061     0.200
     0.738    13.891     0.200
     0.758    14.699     0.200
     0.772    14.279     0.200
     0.782    15.070     0.200
     0.875    16.350     0.200
     0.986    18.160     0.200
     0.992    18.330     0.200
     0.184     3.919     0.200
     0.244     4.809     0.200
     0.302     5.689     0.200
     0.372     6.819     0.200
     0.394     7.199     0.200
     0.406     7.729     0.200
     0.424     7.929     0.200
     0.485     9.249     0.200
     0.519     9.839     0.200
     0.642    12.059     0.200
     0.860    15.779     0.200
     0.099     3.547     0.200
     0.156     4.391     0.200
     0.185     4.586     0.200
     0.206     4.953     0.200
     0.312     6.602     0.200
     0.355     7.133     0.200
     0.357     7.336     0.200
     0.529    10.195     0.200
     0.549    10.438     0.200
     0.615    12.070     0.200
     0.615    12.156     0.200
     0.622    12.125     0.200
     0.670    12.453     0.200
     0.679    12.836     0.200
     0.690    13.211     0.200
     0.695    13.125     0.200
     0.741    13.852     0.200
     0.805    15.023     0.200
     0.811    15.586     0.200
     0.824    15.938     0.200
     0.845    16.062     0.200
     0.882    16.695     0.200
     0.888    16.836     0.200
     0.918    17.531     0.200
     0.940    17.781     0.200
     0.964    18.461     0.200
     0.176     3.836     0.200
     0.242     5.156     0.200
     0.251     5.289     0.200
     0.296     5.742     0.200
     0.286     6.062     0.200
     0.382     7.430     0.200
     0.391     7.719     0.200
     0.402     7.703     0.200
     0.438     8.656     0.200
     0.484     9.133     0.200
     0.480     9.477     0.200
     0.516     9.734     0.200
     0.621    12.016     0.200
     0.633    11.875     0.200
     0.644    11.898     0.200
     0.676    12.547     0.200
     0.674    12.703     0.200
     0.734    14.078     0.200
     0.797    14.977     0.200
     0.816    15.398     0.200
     0.834    15.977     0.200
     0.851    16.047     0.200
     0.923    17.703     0.200
     0.974    18.562     0.200
     1.035    19.555     0.200
     1.043    19.906     0.200
     1.503    27.992     0.200
     0.079     1.883     0.200
     0.182     3.969     0.200
     0.265     5.016     0.200
     0.304     5.750     0.200
     0.337     6.406     0.200
     0.358     7.125     0.200
     0.399     7.695     0.200
     0.528    10.141     0.200
     0.582    11.086     0.200
     0.683    12.633     0.200
     0.742    13.930     0.200
     0.749    13.945     0.200
     0.795    14.750     0.200
     1.046    20.109     0.200
     1.083    21.281     0.200
     1.237    23.406     0.200
     1.637    30.680     0.200
     1.684    31.766     0.200
     1.734    33.141     0.200
     1.839    34.570     0.200
     1.911    35.320     0.200
     1.924    36.336     0.200
     1.962    36.773     0.200
     1.985    36.570     0.200
     2.008    37.539     0.200
     2.101    39.172     0.200
     2.178    39.914     0.200
     2.302    42.203     0.200
     2.395    43.539     0.200
     0.081     5.242     0.200
     0.140     5.797     0.200
     0.212     6.031     0.200
     0.290     7.070     0.200
     0.334     7.680     0.200
     0.344     7.672     0.200
     0.310     7.727     0.200
     0.311     7.570     0.200
     0.399     8.461     0.200
     0.438     9.086     0.200
     0.476     9.938     0.200
     0.497    10.219     0.200
     0.558    11.500     0.200
     0.616    12.008     0.200
     0.639    12.250     0.200
     0.754    13.867     0.200
     0.860    16.156     0.200
     0.894    16.609     0.200
     0.964    17.602     0.200
     1.216    22.609     0.200
     1.282    23.516     0.200
     1.334    24.789     0.200
     1.367    25.422     0.200
     1.408    25.688     0.200
     1.540    27.602     0.200
     1.632    29.367     0.200
     1.675    29.445     0.200
     1.830    32.070     0.200
     2.018    35.906     0.200
     2.059    36.539     0.200
     2.063    37.258     0.200
     2.067    36.938     0.200
     2.164    38.547     0.200
     2.236    39.492     0.200
     2.263    40.133     0.200
     2.286    40.750     0.200
     1.680    31.000     0.200
     0.062     2.312     0.200
     0.116     2.844     0.200
     0.131     3.250     0.200
     0.178     3.586     0.200
     0.197     4.195     0.200
     0.185     4.266     0.200
     0.233     5.023     0.200
     0.322     6.578     0.200
     0.353     6.984     0.200
     0.369     7.039     0.200
     0.381     7.836     0.200
     0.433     8.336     0.200
     0.436     8.633     0.200
     0.481     9.250     0.200
     0.505     9.586     0.200
     0.513    10.258     0.200
     0.533    10.680     0.200
     0.607    11.039     0.200
     0.608    11.234     0.200
     0.631    11.844     0.200
     0.677    12.812     0.200
     0.701    12.766     0.200
     0.701    12.945     0.200
     0.681    13.312     0.200
     0.849    15.773     0.200
     0.886    16.766     0.200
     0.939    17.234     0.200
     0.969    18.227     0.200
     1.180    21.898     0.200
     1.561    29.367     0.200
     1.598    29.586     0.200
     1.610    30.039     0.200
     1.606    29.578     0.200
     1.705    31.297     0.200
     1.794    33.000     0.200
     1.810    33.484     0.200
     1.847    33.484     0.200
     2.216    39.984     0.200
     0.076     2.945     0.200
     0.187     4.008     0.200
     0.225     4.656     0.200
     0.245     5.695     0.200
     0.373     7.406     0.200
     0.363     7.215     0.200
     0.444     8.816     0.200
     0.522    10.387     0.200
     0.528    10.324     0.200
     0.541    10.227     0.200
     0.564    10.598     0.200
     0.605    11.117     0.200
     0.707    13.305     0.200
     0.958    18.086     0.200
     0.994    18.688     0.200
     1.031    19.555     0.200
     1.248    23.207     0.200
     1.491    28.027     0.200
     1.581    29.527     0.200
     1.698    31.168     0.200
     2.053    37.234     0.200
     2.063    37.297     0.200
     2.117    38.336     0.200
     2.321    41.438     0.200
     0.628    12.125     0.200
     0.120     3.047     0.200
     0.159     3.805     0.200
     0.215     4.398     0.200
     0.241     5.000     0.200
     0.330     6.516     0.200
     0.360     6.945     0.200
     0.388     7.625     0.200
     0.448     8.578     0.200
     0.547    10.656     0.200
     0.606    11.859     0.200
     0.709    13.094     0.200
     0.722    13.547     0.200
     0.746    14.039     0.200
     0.936    17.656     0.200
     0.984    18.656     0.200
     0.990    18.578     0.200
     1.045    20.016     0.200
     1.504    28.258     0.200
     1.589    29.609     0.200
     1.630    30.180     0.200
     1.787    33.125     0.200
     1.869    34.539     0.200
     1.930    35.195     0.200
     1.955    35.727     0.200
     2.042    36.969     0.200
     2.104    38.227     0.200
     2.120    38.383     0.200
     2.243    40.688     0.200
     2.340    41.883     0.200
     0.111     3.042     0.200
     0.173     4.282     0.200
     0.226     4.732     0.200
     0.242     5.082     0.200
     0.371     7.042     0.200
     0.402     7.872     0.200
     0.559    10.792     0.200
     0.618    12.152     0.200
     0.641    12.252     0.200
     0.652    12.402     0.200
     1.056    19.882     0.200
     1.201    22.372     0.200
     1.462    27.012     0.200
     1.877    34.842     0.200
     0.349     7.164     0.200
     0.395     7.797     0.200
     0.458     9.250     0.200
     0.484     9.586     0.200
     0.487     9.594     0.200
     0.598    11.430     0.200
     0.602    11.469     0.200
     0.617    11.625     0.200
     0.648    12.562     0.200
     0.676    12.797     0.200
     0.680    13.148     0.200
     0.693    13.094     0.200
     0.724    14.328     0.200
     0.743    13.938     0.200
     0.750    13.914     0.200
     0.778    14.047     0.200
     0.798    15.844     0.200
     0.799    15.430     0.200
     0.830    15.789     0.200
     0.883    17.133     0.200
     0.943    17.773     0.200
     1.023    19.078     0.200
     0.086     3.594     0.200
     0.095     3.566     0.200
     0.093     3.324     0.200
     0.179     4.676     0.200
     0.254     5.496     0.200
     0.269     5.695     0.200
     0.265     5.656     0.200
     0.410     8.434     0.200
     0.446     9.266     0.200
     0.481     9.953     0.200
     0.094     3.430     0.200
     0.086     3.461     0.200
     0.096     3.172     0.200
     0.177     4.562     0.200
     0.256     5.492     0.200
     0.267     5.562     0.200
     0.267     5.711     0.200
     0.407     8.332     0.200
     0.444     8.980     0.200
     0.479     9.609     0.200
     0.817    16.152     0.200
     0.979    17.980     0.200
     1.076    20.039     0.200
     0.223     5.031     0.200
     0.310     6.578     0.200
     0.337     7.078     0.200
     0.343     7.156     0.200
     0.350     6.789     0.200
     0.426     8.188     0.200
     0.414     8.562     0.200
     0.474     9.578     0.200
     0.522    10.383     0.200
     0.552    10.711     0.200
     0.578    11.211     0.200
     0.644    12.297     0.200
     0.692    13.523     0.200
     0.680    12.703     0.200
     0.752    14.078     0.200
     0.778    14.539     0.200
     0.793    15.180     0.200
     0.782    15.109     0.200
     0.874    16.562     0.200
     0.887    16.781     0.200
     1.455    27.547     0.200
     1.826    33.797     0.200
     1.929    35.633     0.200
     0.107     2.859     0.200
     0.246     5.383     0.200
     0.264     5.406     0.200
     0.278     5.836     0.200
     0.290     6.156     0.200
     0.326     6.883     0.200
     0.354     7.203     0.200
     0.399     7.875     0.200
     0.491     9.016     0.200
     0.529     9.898     0.200
     0.560    10.898     0.200
     0.658    12.797     0.200
     0.097     2.582     0.200
     0.134     2.859     0.200
     0.121     2.973     0.200
     0.210     5.012     0.200
     0.306     6.082     0.200
     0.412     7.699     0.200
     0.401     7.941     0.200
     0.447     8.879     0.200
     0.425     8.582     0.200
     0.469     9.379     0.200
     0.709    13.281     0.200
     0.742    13.781     0.200
     0.130     2.684     0.200
     0.101     2.355     0.200
     0.123     2.695     0.200
     0.233     4.676     0.200
     0.214     4.816     0.200
     0.303     5.906     0.200
     0.363     7.086     0.200
     0.386     7.363     0.200
     0.465     9.363     0.200
     0.587    10.906     0.200
     0.731    13.754     0.200
     0.109     2.023     0.200
     0.098     2.367     0.200
     0.186     3.883     0.200
     0.266     5.148     0.200
     0.319     6.148     0.200
     0.284     5.930     0.200
     0.323     6.250     0.200
     0.352     6.789     0.200
     0.441     8.703     0.200
     0.430     8.219     0.200
     0.456     8.836     0.200
     0.478     9.148     0.200
     0.515     9.477     0.200
     0.490     9.461     0.200
     0.504     9.656     0.200
     0.586    11.398     0.200
     0.666    12.172     0.200
     0.678    12.422     0.200
     0.702    13.320     0.200
     0.736    13.617     0.200
     0.737    13.922     0.200
     0.974    18.352     0.200
     1.007    18.703     0.200
     1.012    19.219     0.200
     1.030    19.141     0.200
     1.036    19.258     0.200
     1.193    22.953     0.200
     1.217    23.023     0.200
     1.768    33.047     0.200
     1.884    35.156     0.200
     1.930    36.047     0.200
     2.022    37.617     0.200
     2.032    37.469     0.200
     2.081    38.430     0.200
     0.106     2.266     0.200
     0.102     2.570     0.200
     0.190     4.070     0.200
     0.314     6.344     0.200
     0.289     6.242     0.200
     0.322     6.383     0.200
     0.349     7.055     0.200
     0.429     8.391     0.200
     0.509     9.680     0.200
     0.495     9.641     0.200
     0.510     9.734     0.200
     0.660    11.992     0.200
     0.104     3.199     0.200
     0.235     5.189     0.200
     0.251     5.350     0.200
     0.285     5.920     0.200
     0.318     6.600     0.200
     0.368     7.320     0.200
     0.351     7.250     0.200
     0.369     7.529     0.200
     0.388     7.680     0.200
     0.438     8.939     0.200
     0.518     9.959     0.200
     0.485     9.609     0.200
     0.563    10.699     0.200
     0.578    10.971     0.200
     0.580    10.939     0.200
     0.588    11.340     0.200
     0.642    12.510     0.200
     0.651    12.930     0.200
     0.792    15.189     0.200
     1.605    29.379     0.200
     1.656    31.090     0.200
     1.760    32.221     0.200
     0.187     4.094     0.200
     0.303     6.258     0.200
     0.345     6.914     0.200
     0.369     7.508     0.200
     0.403     7.922     0.200
     0.428     8.500     0.200
     0.479     9.430     0.200
     0.514     9.422     0.200
     0.574    10.969     0.200
     0.634    12.031     0.200
     0.698    13.242     0.200
     0.721    13.703     0.200
     0.739    14.250     0.200
     0.773    14.297     0.200
     0.813    15.320     0.200
     0.904    17.078     0.200
     1.008    18.914     0.200
     1.489    28.234     0.200
     1.758    32.711     0.200
     0.105     3.246     0.200
     0.113     3.346     0.200
     0.254     5.096     0.200
     0.335     6.797     0.200
     0.359     7.205     0.200
     0.378     7.307     0.200
     0.477     9.195     0.200
     0.528    10.346     0.200
     0.574    10.307     0.200
     0.591    11.375     0.200
     0.612    11.936     0.200
     0.630    12.195     0.200
     0.710    12.746     0.200
     0.749    13.977     0.200
     0.835    15.605     0.200
     0.011     2.836     0.200
     0.093     3.039     0.200
     0.159     4.008     0.200
     0.172     4.094     0.200
     0.220     4.758     0.200
     0.326     6.742     0.200
     0.343     6.766     0.200
     0.457     8.688     0.200
     0.458     8.922     0.200
     0.464     9.672     0.200
     0.489     9.453     0.200
     0.489     9.555     0.200
     0.604    11.688     0.200
     0.600    10.898     0.200
     0.620    12.008     0.200
     0.654    13.094     0.200
     0.677    12.695     0.200
     0.672    12.664     0.200
     0.685    13.172     0.200
     0.748    14.164     0.200
     0.758    14.305     0.200
     0.756    14.844     0.200
     0.783    14.758     0.200
     0.804    15.672     0.200
     0.837    15.586     0.200
     0.888    16.852     0.200
     0.165     3.797     0.200
     0.220     4.727     0.200
     0.275     5.789     0.200
     0.270     6.016     0.200
     0.283     5.719     0.200
     0.379     7.406     0.200
     0.441     8.625     0.200
     0.538    10.578     0.200
     0.570    11.016     0.200
     0.589    11.578     0.200
     0.621    11.953     0.200
     0.694    13.047     0.200
     0.697    13.383     0.200
     0.715    13.906     0.200
     0.745    14.305     0.200
     0.804    15.242     0.200
     0.812    15.508     0.200
     0.814    15.508     0.200
     0.830    15.594     0.200
     0.829    15.938     0.200
     0.842    16.195     0.200
     0.861    15.727     0.200
     0.854    16.086     0.200
     0.865    16.359     0.200
     0.898    16.562     0.200
     0.914    17.594     0.200
     0.946    17.844     0.200
     0.960    17.695     0.200
     0.951    18.344     0.200
     0.995    18.508     0.200
     1.017    19.289     0.200
     1.016    18.859     0.200
     1.076    19.867     0.200
     0.150     4.086     0.200
     0.287     6.359     0.200
     0.297     6.617     0.200
     0.293     6.312     0.200
     0.308     6.734     0.200
     0.344     7.438     0.200
     0.360     7.578     0.200
     0.420     8.586     0.200
     0.451     9.227     0.200
     0.532    10.586     0.200
     0.534    10.023     0.200
     0.614    12.055     0.200
     0.710    13.969     0.200
     0.784    14.859     0.200
     0.830    16.148     0.200
     0.687    13.134     0.200
     0.150     3.774     0.200
     0.287     6.014     0.200
     0.308     6.444     0.200
     0.298     6.344     0.200
     0.345     7.234     0.200
     0.360     7.264     0.200
     0.447     8.344     0.200
     0.457     8.824     0.200
     0.451     9.114     0.200
     0.532    10.154     0.200
     0.533    10.014     0.200
     0.527     9.644     0.200
     0.549    10.584     0.200
     0.615    11.734     0.200
     0.610    11.644     0.200
     0.659    13.134     0.200
     0.710    13.934     0.200
     0.743    13.694     0.200
     0.739    14.234     0.200
     0.784    14.894     0.200
     0.800    15.334     0.200
     0.830    15.924     0.200
     0.817    15.854     0.200
     0.820    15.194     0.200
     0.843    15.894     0.200
     0.871    15.984     0.200
     0.984    18.734     0.200
     1.471    27.864     0.200
     1.850    34.204     0.200
     1.960    35.714     0.200
     0.546    10.254     0.200
     0.609    11.014     0.200
     0.710    13.494     0.200
     1.407    24.894     0.200
     0.097     3.566     0.200
     0.152     4.547     0.200
     0.204     5.168     0.200
     0.215     5.090     0.200
     0.264     6.039     0.200
     0.321     6.848     0.200
     0.348     7.129     0.200
     0.427     8.500     0.200
     0.414     8.559     0.200
     0.481     9.660     0.200
     0.544    10.488     0.200
     0.620    12.168     0.200
     0.637    12.398     0.200
     0.632    12.297     0.200
     0.666    12.219     0.200
     0.667    12.629     0.200
     0.667    12.777     0.200
     0.669    12.457     0.200
     0.694    12.969     0.200
     0.694    13.219     0.200
     0.768    14.520     0.200
     0.792    14.758     0.200
     0.812    15.328     0.200
     0.803    15.879     0.200
     0.818    15.449     0.200
     0.854    16.527     0.200
     0.859    16.020     0.200
     0.889    16.930     0.200
     0.883    16.699     0.200
     0.981    18.547     0.200
     1.856    33.973     0.200
     0.083     3.074     0.200
     0.166     4.145     0.200
     0.248     4.953     0.200
     0.255     5.414     0.200
     0.249     5.473     0.200
     0.297     6.082     0.200
     0.332     6.785     0.200
     0.378     7.293     0.200
     0.418     8.133     0.200
     0.420     8.273     0.200
     0.491     9.473     0.200
     0.543    10.832     0.200
     0.592    10.895     0.200
     0.603    11.145     0.200
     0.576    11.645     0.200
     0.622    12.582     0.200
     0.649    11.805     0.200
     0.674    13.094     0.200
     0.882    16.805     0.200
     0.904    16.773     0.200
     0.959    18.383     0.200
     0.960    18.504     0.200
     1.005    19.062     0.200
     1.147    21.133     0.200
     1.692    31.035     0.200
     1.749    32.262     0.200
     1.808    33.352     0.200
     1.947    35.074     0.200
     0.605    11.652     0.200
     0.137     3.422     0.200
     0.133     3.012     0.200
     0.202     4.020     0.200
     0.245     5.043     0.200
     0.309     6.113     0.200
     0.337     6.363     0.200
     0.365     7.121     0.200
     0.524    10.082     0.200
     0.584    11.262     0.200
     0.625    11.863     0.200
     0.692    13.742     0.200
     0.853    16.531     0.200
     1.027    19.691     0.200
     1.176    22.191     0.200
     0.088     2.386     0.200
     0.158     3.155     0.200
     0.182     3.976     0.200
     0.210     4.405     0.200
     0.298     5.886     0.200
     0.361     6.995     0.200
     0.435     8.085     0.200
     0.424     7.716     0.200
     0.551    10.585     0.200
     0.624    11.936     0.200
     1.011    19.306     0.200
     1.017    19.396     0.200
     1.659    31.565     0.200
     0.006     2.812     0.200
     0.150     4.102     0.200
     0.179     4.152     0.200
     0.192     4.465     0.200
     0.221     4.875     0.200
     0.266     5.344     0.200
     0.275     5.285     0.200
     0.349     6.664     0.200
     0.473     9.102     0.200
     0.607    11.805     0.200
     1.011    18.863     0.200
     0.120     3.023     0.200
     0.129     3.234     0.200
     0.179     3.781     0.200
     0.250     4.922     0.200
     0.296     6.164     0.200
     0.323     6.250     0.200
     0.476     8.562     0.200
     0.484     8.805     0.200
     0.492     9.164     0.200
     0.571    10.703     0.200
     0.610    11.422     0.200
     0.612    11.133     0.200
     0.656    12.133     0.200
     0.673    13.523     0.200
     0.700    13.398     0.200
     0.709    14.016     0.200
     0.713    13.875     0.200
     0.719    13.070     0.200
     0.743    13.484     0.200
     0.779    14.844     0.200
     0.826    15.680     0.200
     0.101     2.391     0.200
     0.165     3.340     0.200
     0.175     3.422     0.200
     0.206     4.070     0.200
     0.285     5.633     0.200
     0.493     9.012     0.200
     0.528     9.750     0.200
     0.623    11.320     0.200
     0.736    14.121     0.200
     0.907    17.250     0.200
     0.104     3.773     0.200
     0.144     4.398     0.200
     0.213     5.258     0.200
     0.211     5.523     0.200
     0.294     6.625     0.200
     0.349     7.555     0.200
     0.377     8.039     0.200
     0.394     8.164     0.200
     0.488     9.805     0.200
     0.486     9.734     0.200
     0.500     9.945     0.200
     0.521    10.516     0.200
     0.542    10.555     0.200
     0.568    11.523     0.200
     0.573    11.297     0.200
     0.641    12.547     0.200
     0.637    12.484     0.200
     0.711    14.148     0.200
     0.724    13.828     0.200
     0.742    14.234     0.200
     0.755    14.562     0.200
     0.776    14.984     0.200
     0.840    16.086     0.200
     0.862    16.438     0.200
     0.121     2.645     0.200
     0.151     3.504     0.200
     0.214     4.152     0.200
     0.247     4.934     0.200
     0.324     6.262     0.200
     0.348     6.402     0.200
     0.380     7.152     0.200
     0.447     8.133     0.200
     0.536    10.094     0.200
     0.595    10.992     0.200
     0.637    12.094     0.200
     0.705    13.254     0.200
     0.745    13.914     0.200
     0.867    16.512     0.200
     0.940    17.152     0.200
     0.936    17.461     0.200
     0.969    18.203     0.200
     0.997    19.613     0.200
     0.988    18.453     0.200
     0.989    18.773     0.200
     1.041    20.402     0.200
     1.630    31.184     0.200
     1.679    31.422     0.200
     1.787    33.941     0.200
     1.862    33.895     0.200
     1.870    34.672     0.200
     1.906    35.383     0.200
     1.955    36.852     0.200
     2.045    38.031     0.200
     2.104    38.914     0.200
     2.122    39.582     0.200
     2.341    42.453     0.200
     2.455    44.441     0.200
     0.081     2.727     0.200
     0.206     4.320     0.200
     0.224     4.469     0.200
     0.218     4.648     0.200
     0.275     5.719     0.200
     0.422     8.008     0.200
     0.459     9.352     0.200
     0.582    10.828     0.200
     0.671    12.602     0.200
     0.843    16.086     0.200
     0.931    17.398     0.200
     0.082     2.312     0.200
     0.202     4.547     0.200
     0.258     5.250     0.200
     0.264     5.203     0.200
     0.374     7.227     0.200
     0.387     7.195     0.200
     0.429     8.422     0.200
     0.490     8.914     0.200
     0.577    10.836     0.200
     0.634    11.883     0.200
     0.664    12.523     0.200
     0.684    12.883     0.200
     0.752    14.266     0.200
     0.765    14.617     0.200
     0.787    14.844     0.200
     0.915    17.703     0.200
     1.020    19.281     0.200
     1.031    19.672     0.200
     1.520    28.492     0.200
     1.547    28.961     0.200
     1.630    30.367     0.200
     1.826    33.711     0.200
     1.907    34.781     0.200
     1.994    36.570     0.200
     0.079     2.782     0.200
     0.263     5.462     0.200
     0.265     5.452     0.200
     0.395     7.442     0.200
     0.437     8.622     0.200
     0.584    11.093     0.200
     0.641    12.422     0.200
     0.672    12.843     0.200
     1.490    27.732     0.200
     1.998    36.683     0.200
     0.150     3.870     0.200
     0.153     3.729     0.200
     0.153     4.280     0.200
     0.203     4.399     0.200
     0.294     6.149     0.200
     0.376     7.149     0.200
     0.376     7.600     0.200
     0.394     7.689     0.200
     0.575    10.979     0.200
     0.571    11.149     0.200
     0.634    12.810     0.200
     0.646    12.470     0.200
     0.636    12.330     0.200
     0.671    12.609     0.200
     0.688    12.990     0.200
     0.854    15.600     0.200
     0.855    15.840     0.200
     0.894    16.410     0.200
     0.897    17.160     0.200
     0.914    17.609     0.200
     0.956    18.390     0.200
     1.513    28.350     0.200
     1.546    29.140     0.200
     1.817    33.670     0.200
     2.023    36.740     0.200
     2.256    40.810     0.200
     0.399     7.359     0.200
     1.813    34.680     0.200
     0.012     2.885     0.200
     0.114     3.564     0.200
     0.158     4.025     0.200
     0.233     5.436     0.200
     0.310     6.785     0.200
     0.347     7.156     0.200
     0.375     7.615     0.200
     0.460     9.176     0.200
     0.468     9.225     0.200
     0.461     8.945     0.200
     0.473     9.506     0.200
     0.583    11.166     0.200
     0.591    11.475     0.200
     0.600    11.416     0.200
     0.655    12.555     0.200
     0.680    12.385     0.200
     0.679    13.016     0.200
     0.685    13.734     0.200
     0.723    13.695     0.200
     0.731    14.055     0.200
     0.737    13.635     0.200
     0.731    14.156     0.200
     0.764    14.555     0.200
     0.802    15.705     0.200
     0.814    15.715     0.200
     0.824    15.314     0.200
     0.826    16.045     0.200
     0.947    17.936     0.200
     1.034    19.484     0.200
     1.033    19.346     0.200
     1.141    20.865     0.200
     0.133     3.113     0.200
     0.116     2.961     0.200
     0.184     3.602     0.200
     0.237     4.941     0.200
     0.269     5.582     0.200
     0.279     5.543     0.200
     0.285     5.832     0.200
     0.315     6.262     0.200
     0.410     7.992     0.200
     0.432     8.363     0.200
     0.484     9.254     0.200
     0.494     9.293     0.200
     0.515     9.242     0.200
     0.565    10.742     0.200
     0.574    10.480     0.200
     0.569    10.531     0.200
     0.690    13.191     0.200
     1.065    19.422     0.200
     1.624    30.383     0.200
     1.651    30.891     0.200
     1.676    31.402     0.200
     0.034     2.992     0.200
     0.122     3.383     0.200
     0.194     4.562     0.200
     0.258     5.492     0.200
     0.291     6.344     0.200
     0.308     6.191     0.200
     0.365     7.562     0.200
     0.498     9.633     0.200
     0.567    11.055     0.200
     0.621    12.094     0.200
     0.627    11.672     0.200
     0.688    13.422     0.200
     0.709    13.793     0.200
     0.710    13.395     0.200
     0.715    13.715     0.200
     0.723    13.742     0.200
     0.841    16.434     0.200
     0.865    16.332     0.200
     0.030     3.121     0.200
     0.113     3.590     0.200
     0.195     4.820     0.200
     0.250     5.660     0.200
     0.300     6.527     0.200
     0.311     6.180     0.200
     0.374     7.688     0.200
     0.444     8.969     0.200
     0.492     9.680     0.200
     0.496     9.910     0.200
     0.576    11.188     0.200
     0.627    11.578     0.200
     0.628    11.609     0.200
     0.685    13.570     0.200
     0.712    13.461     0.200
     0.706    13.609     0.200
     0.719    13.871     0.200
     0.724    13.891     0.200
     0.719    14.039     0.200
     0.796    15.480     0.200
     1.019    19.078     0.200
     0.127     3.246     0.200
     0.200     4.477     0.200
     0.262     5.809     0.200
     0.273     6.406     0.200
     0.318     6.520     0.200
     0.388     7.789     0.200
     0.401     8.227     0.200
     0.412     8.227     0.200
     0.432     8.449     0.200
     0.486     9.547     0.200
     0.629    11.957     0.200
     0.634    11.668     0.200
     0.645    12.406     0.200
     0.657    12.188     0.200
     0.732    13.777     0.200
     0.874    16.527     0.200
     0.919    17.609     0.200
     1.518    28.137     0.200
     1.623    30.137     0.200
     0.100     2.250     0.200
     0.185     4.129     0.200
     0.263     5.867     0.200
     0.276     6.027     0.200
     0.306     6.469     0.200
     0.369     7.719     0.200
     0.408     8.297     0.200
     0.427     8.668     0.200
     0.454     9.137     0.200
     0.456     9.180     0.200
     0.462     8.887     0.200
     0.531    10.066     0.200
     0.598    11.879     0.200
     0.638    12.438     0.200
     0.650    12.156     0.200
     0.665    12.637     0.200
     0.688    13.406     0.200
     0.674    12.758     0.200
     0.691    13.148     0.200
     0.759    14.777     0.200
     0.782    15.180     0.200
     0.790    14.930     0.200
     0.809    14.879     0.200
     0.816    15.348     0.200
     0.919    17.879     0.200
     0.948    18.148     0.200
     1.000    18.898     0.200
     1.041    19.508     0.200
     1.080    20.477     0.200
     1.069    20.340     0.200
     1.486    27.250     0.200
     1.591    30.270     0.200
     0.164     4.082     0.200
     0.179     4.701     0.200
     0.210     4.662     0.200
     0.285     5.781     0.200
     0.341     6.961     0.200
     0.361     7.482     0.200
     0.388     7.393     0.200
     0.629    12.191     0.200
     0.706    13.201     0.200
     0.732    13.652     0.200
     0.772    14.303     0.200
     0.084     3.344     0.200
     0.194     4.785     0.200
     0.233     5.535     0.200
     0.274     5.996     0.200
     0.309     6.605     0.200
     0.347     7.465     0.200
     0.367     7.215     0.200
     0.362     7.676     0.200
     0.488     9.664     0.200
     0.497    10.145     0.200
     0.503    10.016     0.200
     0.547    10.516     0.200
     0.556    10.766     0.200
     0.612    12.035     0.200
     0.745    14.316     0.200
     0.760    14.156     0.200
     1.040    18.977     0.200
     0.135     4.105     0.200
     0.212     5.273     0.200
     0.263     5.766     0.200
     0.343     7.285     0.200
     0.362     7.465     0.200
     0.414     8.055     0.200
     0.499    10.055     0.200
     0.636    12.465     0.200
     0.650    12.766     0.200
     0.677    13.195     0.200
     0.689    13.145     0.200
     0.680    12.895     0.200
     0.815    15.074     0.200
     0.882    16.996     0.200
     0.894    16.977     0.200
     0.983    18.656     0.200
     1.019    19.234     0.200
     1.429    26.984     0.200
     0.161     4.297     0.200
     0.255     5.848     0.200
     0.338     6.516     0.200
     0.405     7.977     0.200
     0.623    11.945     0.200
     0.634    12.238     0.200
     0.656    12.965     0.200
     0.675    12.695     0.200
     0.145     4.344     0.200
     0.202     5.422     0.200
     0.233     5.727     0.200
     0.255     5.938     0.200
     0.352     7.508     0.200
     0.406     8.352     0.200
     0.498     9.906     0.200
     0.558    11.062     0.200
     0.636    12.617     0.200
     0.649    12.891     0.200
     0.683    12.859     0.200
     0.708    13.602     0.200
     0.775    14.523     0.200
     0.807    15.469     0.200
     0.897    16.797     0.200
     0.135     4.291     0.200
     0.211     5.541     0.200
     0.237     5.602     0.200
     0.262     5.961     0.200
     0.343     7.221     0.200
     0.361     7.531     0.200
     0.413     8.381     0.200
     0.450     8.822     0.200
     0.500     9.342     0.200
     0.637    12.592     0.200
     0.651    12.672     0.200
     0.681    13.152     0.200
     0.717    13.982     0.200
     0.716    13.771     0.200
     0.881    16.961     0.200
     0.901    17.322     0.200
     0.895    16.512     0.200
     0.161     3.906     0.200
     0.176     3.797     0.200
     0.188     4.375     0.200
     0.281     5.977     0.200
     0.313     6.234     0.200
     0.357     7.211     0.200
     0.413     8.281     0.200
     0.396     7.992     0.200
     0.433     8.633     0.200
     0.532     9.914     0.200
     0.573    11.211     0.200
     0.648    12.062     0.200
     0.654    12.430     0.200
     0.653    12.680     0.200
     0.726    14.023     0.200
     0.754    14.594     0.200
     0.818    16.227     0.200
     0.858    16.609     0.200
     0.937    17.641     0.200
     0.979    18.570     0.200
     1.196    21.742     0.200
     1.503    28.336     0.200
     1.533    28.250     0.200
     1.593    29.805     0.200
     1.743    32.031     0.200
     1.749    32.797     0.200
     1.872    34.094     0.200
     1.972    35.664     0.200
     0.098     2.516     0.200
     0.195     4.215     0.200
     0.229     4.455     0.200
     0.247     5.365     0.200
     0.295     6.105     0.200
     0.315     6.465     0.200
     0.362     7.365     0.200
     0.358     7.486     0.200
     0.372     7.525     0.200
     0.511     9.826     0.200
     0.542     9.807     0.200
     0.512     9.826     0.200
     0.517     9.576     0.200
     0.539    10.316     0.200
     0.601    11.727     0.200
     0.608    12.045     0.200
     0.618    12.295     0.200
     0.632    12.057     0.200
     0.696    13.326     0.200
     0.692    13.605     0.200
     0.759    14.346     0.200
     0.808    15.256     0.200
     0.840    15.686     0.200
     0.879    16.846     0.200
     0.879    16.977     0.200
     0.912    17.096     0.200
     0.927    17.516     0.200
     0.924    17.445     0.200
     1.068    20.326     0.200
     1.105    21.195     0.200
     1.558    29.727     0.200
     1.652    31.156     0.200
     1.706    32.236     0.200
     1.915    35.086     0.200
     1.941    36.016     0.200
     2.057    37.846     0.200
     0.507     9.295     0.200
     0.650    12.236     0.200
     0.609    12.266     0.200
     0.080     3.039     0.200
     0.222     5.289     0.200
     0.263     5.703     0.200
     0.271     5.812     0.200
     0.409     7.953     0.200
     0.450     9.008     0.200
     0.599    11.680     0.200
     0.656    12.719     0.200
     0.686    13.641     0.200
     0.114     2.569     0.200
     0.198     4.370     0.200
     0.219     4.490     0.200
     0.261     5.380     0.200
     0.309     6.210     0.200
     0.321     6.430     0.200
     0.370     7.550     0.200
     0.373     7.510     0.200
     0.385     7.569     0.200
     0.541     9.979     0.200
     0.523     9.850     0.200
     0.528    10.069     0.200
     0.542    10.120     0.200
     0.608    11.550     0.200
     0.623    11.620     0.200
     0.624    12.000     0.200
     0.632    12.340     0.200
     0.706    13.700     0.200
     0.837    15.899     0.200
     0.935    17.729     0.200
     1.204    22.770     0.200
     1.560    29.750     0.200
     1.709    32.340     0.200
     1.942    35.840     0.200
     2.057    37.490     0.200
     0.231     5.477     0.200
     0.336     6.527     0.200
     0.349     7.379     0.200
     0.364     7.887     0.200
     0.397     8.168     0.200
     0.407     8.398     0.200
     0.413     8.438     0.200
     0.440     9.199     0.200
     0.447     9.238     0.200
     0.511    10.328     0.200
     0.534    10.547     0.200
     0.546    10.617     0.200
     0.620    12.297     0.200
     0.639    12.379     0.200
     0.637    12.809     0.200
     0.687    13.668     0.200
     0.751    14.207     0.200
     0.769    14.297     0.200
     0.773    14.887     0.200
     0.809    15.469     0.200
     0.843    15.930     0.200
     0.835    15.727     0.200
     0.882    16.848     0.200
     0.946    18.109     0.200
     0.945    17.879     0.200
     1.499    28.168     0.200
     1.585    29.590     0.200
     1.605    29.789     0.200
     1.769    32.488     0.200
     0.879    16.695     0.200
     1.374    25.016     0.200
     1.594    29.148     0.200
     1.667    31.609     0.200
     1.770    30.664     0.200
     2.427    41.211     0.200
     0.102     2.367     0.200
     0.205     4.298     0.200
     0.295     5.588     0.200
     0.326     6.808     0.200
     0.357     7.107     0.200
     0.369     7.447     0.200
     0.532     9.607     0.200
     0.524    10.018     0.200
     0.618    11.827     0.200
     0.629    11.968     0.200
     0.693    13.258     0.200
     0.703    13.808     0.200
     0.922    17.737     0.200
     0.347     7.402     0.200
     1.505    28.992     0.200
     1.685    29.982     0.200
     1.896    33.473     0.200
     2.119    36.703     0.200
     2.084    36.412     0.200
     2.141    37.732     0.200
     2.155    37.572     0.200
     2.115    38.592     0.200
     2.261    38.832     0.200
     2.296    40.812     0.200
     0.151     3.107     0.200
     0.223     4.427     0.200
     0.235     5.217     0.200
     0.326     6.467     0.200
     0.349     6.957     0.200
     0.407     7.807     0.200
     0.484     9.157     0.200
     0.523     9.947     0.200
     0.677    13.237     0.200
     1.232    23.017     0.200
     1.011    19.057     0.200
     0.032     2.236     0.200
     0.165     3.896     0.200
     0.175     3.846     0.200
     0.203     4.576     0.200
     0.272     5.637     0.200
     0.369     7.527     0.200
     0.367     7.287     0.200
     0.482     9.227     0.200
     0.510     9.797     0.200
     0.581    11.297     0.200
     0.571    10.906     0.200
     0.590    11.857     0.200
     0.599    11.086     0.200
     0.643    12.447     0.200
     0.638    12.156     0.200
     0.665    12.756     0.200
     0.711    13.107     0.200
     0.708    13.586     0.200
     0.728    13.926     0.200
     0.725    13.877     0.200
     0.787    15.207     0.200
     0.848    16.617     0.200
     0.864    16.656     0.200
     0.927    17.467     0.200
     1.011    19.127     0.200
     1.140    21.457     0.200
     1.188    22.117     0.200
     1.736    32.607     0.200
     1.946    35.537     0.200
     2.317    42.787     0.200
     2.738    48.268     0.200
     0.175     3.629     0.200
     0.277     5.316     0.200
     0.311     5.520     0.200
     0.341     6.367     0.200
     0.347     6.848     0.200
     0.501     9.156     0.200
     0.545    10.020     0.200
     0.556    10.758     0.200
     0.661    12.586     0.200
     0.740    14.020     0.200
     1.038    19.508     0.200
     0.122     2.883     0.200
     0.203     3.977     0.200
     0.257     5.195     0.200
     0.312     6.156     0.200
     0.317     6.336     0.200
     0.394     7.617     0.200
     0.426     8.102     0.200
     0.452     8.438     0.200
     0.586    10.617     0.200
     0.604    11.070     0.200
     0.665    12.258     0.200
     0.713    13.398     0.200
     0.717    13.656     0.200
     0.721    13.758     0.200
     0.809    15.438     0.200
     0.807    15.438     0.200
     0.867    16.188     0.200
     0.914    17.391     0.200
     0.932    17.828     0.200
     0.991    18.727     0.200
     1.085    19.867     0.200
     1.481    28.297     0.200
     0.035     2.860     0.200
     0.127     3.800     0.200
     0.193     4.320     0.200
     0.287     6.000     0.200
     0.308     6.290     0.200
     0.361     7.100     0.200
     0.431     8.430     0.200
     0.481     9.280     0.200
     0.500     9.810     0.200
     0.505    10.120     0.200
     0.499     9.680     0.200
     0.563    10.900     0.200
     0.618    11.760     0.200
     0.625    11.990     0.200
     0.657    12.370     0.200
     0.688    14.160     0.200
     0.683    13.040     0.200
     0.706    13.910     0.200
     0.706    13.620     0.200
     0.711    13.460     0.200
     0.715    13.950     0.200
     0.748    14.140     0.200
     0.770    15.080     0.200
     0.789    15.590     0.200
     0.796    14.970     0.200
     0.846    16.180     0.200
     0.931    17.670     0.200
     0.961    18.130     0.200
     0.986    18.590     0.200
     1.001    18.310     0.200
     1.136    20.810     0.200
     1.120    20.720     0.200
     1.269    22.830     0.200
     1.361    25.000     0.200
     1.339    24.940     0.200
     1.878    34.070     0.200
     1.980    35.860     0.200
     2.116    39.340     0.200
     2.129    37.790     0.200
     2.181    38.870     0.200
     2.301    42.180     0.200
     2.497    42.090     0.200
     2.570    44.540     0.200
     0.034     2.484     0.200
     0.130     3.152     0.200
     0.187     3.953     0.200
     0.284     5.824     0.200
     0.312     5.973     0.200
     0.474     8.754     0.200
     0.496     9.523     0.200
     0.610    11.863     0.200
     0.619    11.402     0.200
     0.651    11.855     0.200
     0.702    13.312     0.200
     0.707    13.473     0.200
     0.741    13.832     0.200
     0.136     3.059     0.200
     0.231     4.590     0.200
     0.203     4.570     0.200
     0.286     5.641     0.200
     0.302     5.770     0.200
     0.311     6.129     0.200
     0.372     6.840     0.200
     0.414     8.098     0.200
     0.441     8.328     0.200
     0.463     9.207     0.200
     0.537    10.051     0.200
     0.545    10.527     0.200
     0.565    10.258     0.200
     0.606    11.777     0.200
     0.653    12.328     0.200
     0.634    12.219     0.200
     0.880    16.391     0.200
     0.930    17.457     0.200
     1.297    24.059     0.200
     0.037     2.461     0.200
     0.136     3.203     0.200
     0.185     3.953     0.200
     0.279     5.852     0.200
     0.420     7.992     0.200
     0.495     9.473     0.200
     0.555    10.492     0.200
     0.616    11.152     0.200
     0.645    12.023     0.200
     0.703    12.992     0.200
     0.716    13.832     0.200
     0.777    15.113     0.200
     0.837    16.031     0.200
     0.997    18.961     0.200
     1.078    20.383     0.200
     0.135     2.812     0.200
     0.199     3.912     0.200
     0.290     5.852     0.200
     0.340     6.682     0.200
     0.488     9.402     0.200
     0.564    10.643     0.200
     0.681    12.283     0.200
     0.906    16.832     0.200
     0.037     3.148     0.200
     0.134     3.078     0.200
     0.185     4.523     0.200
     0.266     5.703     0.200
     0.313     6.625     0.200
     0.352     7.133     0.200
     0.421     8.375     0.200
     0.496     9.430     0.200
     0.498     9.414     0.200
     0.607    11.562     0.200
     0.646    12.539     0.200
     0.684    14.086     0.200
     0.695    13.430     0.200
     0.698    13.688     0.200
     0.715    13.945     0.200
     0.722    13.859     0.200
     0.737    13.883     0.200
     0.768    14.969     0.200
     0.779    15.484     0.200
     0.792    14.727     0.200
     0.838    16.469     0.200
     0.857    16.203     0.200
     1.116    20.695     0.200
     1.264    23.859     0.200
     1.879    34.898     0.200
     0.722    14.215     0.200
     0.192     4.895     0.200
     0.253     5.805     0.200
     0.290     6.445     0.200
     0.419     8.746     0.200
     0.415     8.535     0.200
     0.527    10.295     0.200
     0.585    11.256     0.200
     0.736    14.525     0.200
     0.809    15.465     0.200
     0.925    17.645     0.200
     0.020     3.348     0.200
     0.101     3.598     0.200
     0.152     4.258     0.200
     0.215     5.148     0.200
     0.444     8.988     0.200
     0.470     9.680     0.200
     0.584    11.730     0.200
     0.604    11.230     0.200
     0.636    12.738     0.200
     0.667    12.660     0.200
     0.740    13.789     0.200
     0.745    14.148     0.200
     0.787    15.199     0.200
     1.535    29.039     0.200
     0.113     3.070     0.200
     0.175     4.012     0.200
     0.257     5.230     0.200
     0.278     5.289     0.200
     0.316     6.262     0.200
     0.366     7.223     0.200
     0.420     8.391     0.200
     0.418     7.973     0.200
     0.438     8.449     0.200
     0.447     8.449     0.200
     0.472     9.102     0.200
     0.522     9.949     0.200
     0.500     9.820     0.200
     0.555    11.223     0.200
     0.581    11.281     0.200
     0.628    11.441     0.200
     0.662    12.480     0.200
     0.668    12.562     0.200
     0.688    12.891     0.200
     0.686    13.902     0.200
     0.708    12.992     0.200
     0.708    13.082     0.200
     0.795    15.031     0.200
     0.861    16.121     0.200
     0.840    16.379     0.200
     1.007    18.891     0.200
     1.629    30.312     0.200
     0.360     7.820     0.200
     0.745    15.652     0.200
     1.040    19.840     0.200
     1.528    28.840     0.200
     0.139     3.812     0.200
     0.143     3.828     0.200
     0.227     4.914     0.200
     0.293     6.164     0.200
     0.307     6.266     0.200
     0.623    12.133     0.200
     0.734    13.789     0.200
     0.753    13.914     0.200
     0.782    14.766     0.200
     0.803    15.062     0.200
     0.018     2.341     0.200
     0.122     2.971     0.200
     0.166     3.841     0.200
     0.246     5.101     0.200
     0.428     8.071     0.200
     0.479     9.341     0.200
     0.599    11.621     0.200
     0.649    12.501     0.200
     0.683    12.821     0.200
     0.712    13.361     0.200
     0.698    13.601     0.200
     0.814    15.501     0.200
     1.097    20.746     0.200
     0.114     2.566     0.200
     0.165     3.758     0.200
     0.186     3.766     0.200
     0.261     5.418     0.200
     0.272     5.438     0.200
     0.346     6.906     0.200
     0.347     6.926     0.200
     0.377     7.457     0.200
     0.438     8.457     0.200
     0.526     9.977     0.200
     0.538    10.367     0.200
     0.587    11.406     0.200
     0.599    11.656     0.200
     0.614    11.535     0.200
     0.637    12.176     0.200
     0.651    12.527     0.200
     0.728    13.746     0.200
     0.795    15.516     0.200
     0.830    15.918     0.200
     0.881    16.809     0.200
     1.099    20.988     0.200
     1.170    21.855     0.200
     1.201    22.617     0.200
     1.598    31.777     0.200
     1.846    34.828     0.200
     0.134     3.312     0.200
     0.316     6.602     0.200
     0.317     6.582     0.200
     0.332     6.732     0.200
     0.421     8.302     0.200
     0.492     9.382     0.200
     0.525    10.012     0.200
     0.513     9.992     0.200
     0.614    11.902     0.200
     0.616    11.792     0.200
     0.700    13.772     0.200
     0.792    15.072     0.200
     0.789    15.102     0.200
     0.773    14.822     0.200
     0.828    15.672     0.200
     0.946    18.172     0.200
     1.046    19.692     0.200
     0.610    11.312     0.200
     2.006    37.782     0.200
     0.145     3.750     0.200
     0.166     3.828     0.200
     0.267     5.305     0.200
     0.315     6.156     0.200
     0.340     6.516     0.200
     0.307     6.180     0.200
     0.380     7.375     0.200
     0.384     7.734     0.200
     0.372     7.336     0.200
     0.422     8.602     0.200
     0.435     8.430     0.200
     0.507     9.734     0.200
     0.529     9.984     0.200
     0.545     9.852     0.200
     0.523    10.258     0.200
     0.540    10.469     0.200
     0.520    10.078     0.200
     0.647    12.602     0.200
     0.636    12.219     0.200
     0.660    12.758     0.200
     0.681    12.727     0.200
     0.685    12.727     0.200
     0.683    12.758     0.200
     0.726    13.445     0.200
     0.740    13.734     0.200
     0.749    13.734     0.200
     0.753    13.820     0.200
     0.786    15.000     0.200
     0.826    15.625     0.200
     0.825    16.219     0.200
     0.852    16.039     0.200
     0.917    17.188     0.200
     0.932    17.289     0.200
     1.044    19.648     0.200
     1.070    20.461     0.200
     1.090    20.789     0.200
     1.529    29.117     0.200
     1.570    29.938     0.200
     1.598    30.180     0.200
     1.674    31.570     0.200
     1.693    31.305     0.200
     1.725    31.547     0.200
     1.755    32.758     0.200
     0.300     6.250     0.200
     0.675    12.555     0.200
     0.981    18.250     0.200
     1.664    30.836     0.200
     1.751    31.656     0.200
     0.146     3.820     0.200
     0.168     3.867     0.200
     0.270     5.484     0.200
     0.318     6.203     0.200
     0.304     6.383     0.200
     0.344     6.523     0.200
     0.383     7.461     0.200
     0.384     7.906     0.200
     0.368     7.211     0.200
     0.424     8.633     0.200
     0.432     8.453     0.200
     0.510     9.883     0.200
     0.533     9.914     0.200
     0.524    10.445     0.200
     0.549    10.117     0.200
     0.543    10.445     0.200
     0.517    10.133     0.200
     0.633    12.336     0.200
     0.647    12.523     0.200
     0.662    12.750     0.200
     0.685    12.664     0.200
     0.687    12.805     0.200
     0.687    13.156     0.200
     0.730    13.305     0.200
     0.743    13.797     0.200
     0.753    13.812     0.200
     0.757    13.711     0.200
     0.784    15.141     0.200
     0.830    15.836     0.200
     0.824    16.312     0.200
     0.850    16.023     0.200
     0.921    17.227     0.200
     0.936    17.242     0.200
     0.946    17.547     0.200
     1.049    19.805     0.200
     1.074    20.523     0.200
     1.094    20.875     0.200
     1.186    22.352     0.200
     1.533    28.836     0.200
     1.574    29.852     0.200
     1.602    30.250     0.200
     1.678    31.570     0.200
     1.697    31.391     0.200
     1.728    31.977     0.200
     1.759    32.844     0.200
     0.677    12.547     0.200
     2.111    39.531     0.200
     0.075     2.977     0.200
     0.098     2.812     0.200
     0.237     5.312     0.200
     0.262     5.375     0.200
     0.421     8.086     0.200
     0.466     8.797     0.200
     0.539    10.461     0.200
     0.554    10.570     0.200
     0.575    10.883     0.200
     0.613    11.867     0.200
     0.611    12.211     0.200
     0.646    12.492     0.200
     0.796    15.055     0.200
     1.000    19.211     0.200
     1.104    20.844     0.200
     1.472    26.695     0.200
     1.585    29.188     0.200
     1.665    30.992     0.200
     0.422     7.523     0.200
     1.694    32.453     0.200
     0.054     1.984     0.200
     0.280     5.725     0.200
     0.295     5.836     0.200
     0.387     7.766     0.200
     0.377     7.365     0.200
     0.513     9.426     0.200
     0.568    10.605     0.200
     0.622    11.795     0.200
     0.661    12.734     0.200
     0.772    15.154     0.200
     0.775    14.795     0.200
     0.964    18.436     0.200
     1.517    27.814     0.200
     1.541    28.525     0.200
     1.741    32.256     0.200
     1.934    35.885     0.200
     2.517    45.734     0.200
     0.038     3.096     0.200
     0.112     3.436     0.200
     0.133     3.785     0.200
     0.190     4.596     0.200
     0.207     4.775     0.200
     0.266     5.727     0.200
     0.281     6.125     0.200
     0.309     6.256     0.200
     0.354     7.236     0.200
     0.474     9.246     0.200
     0.501     9.977     0.200
     0.501     9.615     0.200
     0.611    12.086     0.200
     0.622    11.916     0.200
     0.650    12.156     0.200
     0.688    13.035     0.200
     0.700    13.525     0.200
     0.700    13.375     0.200
     0.741    14.076     0.200
     0.783    15.166     0.200
     0.841    15.945     0.200
     0.875    16.246     0.200
     1.002    18.896     0.200
     0.207     4.406     0.200
     0.201     4.227     0.200
     0.218     4.828     0.200
     0.249     5.129     0.200
     0.299     5.969     0.200
     0.333     6.148     0.200
     0.356     6.418     0.200
     0.415     7.449     0.200
     0.444     8.605     0.200
     0.725    13.199     0.200
     0.442     7.648     0.200
     1.545    30.023     0.200
     1.811    34.039     0.200
     2.019    36.680     0.200
     2.634    44.961     0.200
     0.302     6.113     0.200
     1.451    26.574     0.200
     1.526    28.805     0.200
     1.591    30.453     0.200
     1.956    35.305     0.200
     1.985    35.414     0.200
     1.994    35.453     0.200
     2.076    37.594     0.200
     2.234    39.477     0.200
     2.161    38.156     0.200
     2.317    39.195     0.200
     2.343    40.836     0.200
     2.396    41.234     0.200
     2.490    42.055     0.200
     2.568    44.316     0.200
     0.451     7.986     0.200
     1.523    27.697     0.200
     1.877    32.887     0.200
     0.039     1.152     0.200
     0.972    17.684     0.200
     1.651    32.273     0.200
     1.627    32.434     0.200
     1.948    35.834     0.200
     1.867    36.203     0.200
     2.031    36.223     0.200
     2.052    38.303     0.200
     2.341    41.084     0.200
     2.362    43.533     0.200
     2.401    43.162     0.200
     2.446    43.594     0.200
     2.555    45.594     0.200
     2.868    49.754     0.200
     2.848    50.334     0.200
     0.607    12.447     0.200
     0.763    13.158     0.200
     0.751    15.018     0.200
     1.489    26.988     0.200
     1.666    30.738     0.200
     1.885    33.918     0.200
     2.911    50.617     0.200
     0.715    12.898     0.200
     1.408    26.461     0.200
     2.835    47.910     0.200
     3.010    51.891     0.200
     0.596    12.114     0.200
     1.901    33.975     0.200
     2.434    42.685     0.200
     2.600    46.795     0.200
     2.698    47.164     0.200
     0.458    10.487     0.200
     0.436     7.776     0.200
     0.537    11.377     0.200
     0.787    14.707     0.200
     1.431    27.977     0.200
     1.878    35.687     0.200
     1.355    24.131     0.200
     1.446    25.631     0.200
     1.955    35.571     0.200
     2.440    41.642     0.200
     2.467    42.921     0.200
     2.529    43.642     0.200
     2.965    52.421     0.200
     3.478    59.051     0.200
     4.032    67.461     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     7.414   186.350     0.200
    10.567   266.350     0.200
    12.457   304.350     0.200
    13.032   322.350     0.200
    16.878   408.350     0.200
    21.488   533.350     0.200
     3.380    90.047     0.200
     6.965   183.047     0.200
     9.153   229.047     0.200
     9.820   248.047     0.200
    10.951   277.047     0.200
    12.090   299.047     0.200
    12.285   302.047     0.200
    12.945   323.047     0.200
    14.893   363.047     0.200
    21.126   528.047     0.200
     1.072    35.262     0.200
     2.581    72.262     0.200
     7.612   191.262     0.200
    13.095   317.262     0.200
     2.799    79.088     0.200
     5.535   145.088     0.200
     8.268   212.088     0.200
    10.128   258.088     0.200
    11.494   286.088     0.200
    12.258   304.088     0.200
    13.165   325.088     0.200
    14.116   345.088     0.200
     2.669    75.689     0.200
     6.146   157.689     0.200
     3.032    81.570     0.200
    11.910   298.070     0.200
    12.878   318.570     0.200
    14.398   351.570     0.200
    14.565   357.172     0.200
    18.538   460.570     0.200
    10.020   250.266     0.200
    12.154   303.266     0.200
    12.536   302.965     0.200
    12.806   314.965     0.200
     3.163    87.969     0.200
     4.600   123.367     0.200
     4.646   123.367     0.200
     4.851   127.766     0.200
     5.078   132.066     0.200
     9.092   229.668     0.200
    11.797   295.668     0.200
    12.083   302.367     0.200
    12.867   314.668     0.200
    12.888   316.367     0.200
    12.888   320.367     0.200
    13.464   333.367     0.200
     6.484   168.664     0.200
     6.524   166.965     0.200
     6.444   170.766     0.200
     6.733   174.367     0.200
    13.401   326.266     0.200
     2.843    76.227     0.200
     8.026   200.027     0.200
    11.305   276.027     0.200
    12.585   305.027     0.200
    13.278   327.027     0.200
    13.730   335.727     0.200
     0.959    32.679     0.200
     9.955   251.179     0.200
    12.281   302.379     0.200
    12.913   321.179     0.200
     4.684   122.750     0.200
     8.339   212.648     0.200
     8.572   217.047     0.200
    10.070   249.047     0.200
    10.108   250.648     0.200
    10.386   259.750     0.200
    10.680   264.648     0.200
    12.152   309.750     0.200
    12.136   309.750     0.200
    12.412   305.547     0.200
    12.421   305.750     0.200
    13.069   321.047     0.200
    13.136   328.047     0.200
    13.622   332.047     0.200
    14.163   346.047     0.200
    19.368   472.047     0.200
    20.762   517.047     0.200
     5.667   148.203     0.200
     7.031   181.803     0.200
    12.214   303.803     0.200
    13.024   322.303     0.200
     5.640   148.758     0.200
     7.006   182.359     0.200
    12.243   302.359     0.200
    13.018   317.859     0.200
    13.883   338.359     0.200
    14.738   364.859     0.200
     3.105    87.570     0.200
     5.110   134.570     0.200
     6.184   159.969     0.200
     6.353   166.570     0.200
     8.272   211.570     0.200
     8.677   221.570     0.200
     9.269   239.070     0.200
     9.687   242.570     0.200
    10.817   273.070     0.200
    10.982   275.570     0.200
    11.875   297.070     0.200
    12.407   304.367     0.200
    12.952   321.570     0.200
    13.803   335.867     0.200
    16.468   401.570     0.200
     2.530    70.066     0.200
     5.695   148.566     0.200
     7.046   180.266     0.200
    13.083   318.266     0.200
     2.500    71.668     0.200
     8.903   225.668     0.200
    10.353   264.668     0.200
    12.194   302.668     0.200
    12.853   313.668     0.200
    12.910   320.668     0.200
    13.008   317.668     0.200
    13.228   322.668     0.200
    13.888   337.768     0.200
     2.609    72.951     0.200
     6.337   162.951     0.200
     7.625   193.951     0.200
     8.326   210.951     0.200
    11.074   279.051     0.200
    11.651   289.451     0.200
    11.799   293.650     0.200
     2.940    79.312     0.200
     8.347   211.109     0.200
    12.301   305.508     0.200
    12.280   298.109     0.200
    12.508   308.211     0.200
    12.921   320.109     0.200
    13.103   326.109     0.200
    13.565   334.609     0.200
    20.695   513.109     0.200
     6.575   169.727     0.200
     6.982   180.727     0.200
    10.301   262.930     0.200
    11.820   296.727     0.200
    12.533   317.727     0.200
    12.517   317.727     0.200
    13.043   321.727     0.200
    13.109   326.727     0.200
    18.315   447.727     0.200
     2.509    72.367     0.200
     5.298   137.867     0.200
     6.504   167.867     0.200
    10.185   256.867     0.200
    13.350   325.567     0.200
     6.506   166.748     0.200
    10.842   270.748     0.200
    11.262   280.748     0.200
    11.670   289.748     0.200
    12.489   314.748     0.200
    12.473   314.748     0.200
    12.984   317.748     0.200
    12.997   320.947     0.200
    14.046   341.748     0.200
    14.823   373.248     0.200
     2.445    68.348     0.200
     5.264   138.848     0.200
     6.485   169.848     0.200
     6.889   177.848     0.200
     2.457    69.957     0.200
     5.593   147.059     0.200
    13.234   324.559     0.200
    13.995   342.559     0.200
    15.825   387.559     0.200
     6.315   162.617     0.200
     7.130   182.414     0.200
    11.868   295.414     0.200
     2.571    69.664     0.200
     5.658   146.164     0.200
     5.799   151.264     0.200
     9.204   229.164     0.200
    12.988   316.164     0.200
    13.193   322.164     0.200
     3.178    85.549     0.200
    10.320   261.049     0.200
    13.772   345.049     0.200
    15.008   381.049     0.200
    20.211   506.049     0.200
     3.684   103.938     0.200
     3.789   104.438     0.200
     3.902   107.637     0.200
     7.224   182.836     0.200
     8.544   214.637     0.200
    11.900   295.336     0.200
    12.805   313.836     0.200
     1.908    57.000     0.200
     3.352    94.801     0.200
     3.444    95.801     0.200
     3.567    99.398     0.200
     4.068   110.621     0.200
     4.486   121.199     0.200
     4.696   125.340     0.200
     5.329   141.559     0.200
     5.887   153.500     0.200
     5.928   154.398     0.200
     5.966   159.602     0.200
     6.137   160.941     0.200
     6.341   164.621     0.200
     7.506   189.211     0.200
     7.364   189.441     0.200
     8.018   206.121     0.200
     8.045   205.441     0.200
    12.371   304.000     0.200
    12.186   302.000     0.200
    12.984   319.309     0.200
     5.966   156.062     0.200
     5.966   159.312     0.200
     5.966   158.883     0.200
     5.966   157.297     0.200
     2.609    73.242     0.200
     3.342    91.742     0.200
     3.556    96.941     0.200
     4.078   108.312     0.200
     4.498   119.293     0.200
     4.706   123.773     0.200
     5.141   134.043     0.200
     5.340   139.812     0.200
     5.898   152.094     0.200
     5.940   153.094     0.200
     6.148   158.473     0.200
     6.353   163.434     0.200
     7.499   189.004     0.200
     7.375   187.152     0.200
     8.030   204.230     0.200
     8.058   204.453     0.200
     9.313   235.242     0.200
    12.198   298.742     0.200
    12.974   318.473     0.200
    13.125   319.242     0.200
    14.010   342.203     0.200
     2.240    66.102     0.200
     3.602    99.832     0.200
     5.052   134.191     0.200
     5.693   150.371     0.200
     6.251   161.691     0.200
     6.293   164.574     0.200
     7.728   196.074     0.200
    13.250   324.902     0.200
    13.556   330.602     0.200
     1.137    36.617     0.200
     2.575    72.914     0.200
     3.565    95.617     0.200
     5.029   130.070     0.200
     5.743   149.016     0.200
     6.079   159.719     0.200
     7.396   185.234     0.200
     7.396   186.961     0.200
     9.101   236.344     0.200
     9.208   237.359     0.200
     9.258   237.836     0.200
     9.322   240.289     0.200
     9.338   241.125     0.200
    10.006   256.734     0.200
    10.730   271.117     0.200
    12.087   297.117     0.200
    12.259   299.117     0.200
    12.931   322.117     0.200
    13.188   322.914     0.200
    14.884   374.117     0.200
    15.742   383.516     0.200
    17.595   437.117     0.200
     3.613    97.242     0.200
     3.729   104.242     0.200
     7.325   185.219     0.200
     3.511    99.344     0.200
     6.123   161.539     0.200
     8.475   218.445     0.200
     8.559   222.359     0.200
     9.189   239.312     0.200
     9.197   237.789     0.200
     9.213   238.320     0.200
     9.263   238.516     0.200
     9.291   238.000     0.200
     9.326   240.086     0.200
     9.341   239.305     0.200
     9.524   241.742     0.200
    11.208   279.961     0.200
    12.826   313.969     0.200
    13.853   338.031     0.200
    14.949   375.742     0.200
     1.135    38.461     0.200
     2.945    83.562     0.200
     3.709   104.461     0.200
    12.074   297.961     0.200
    12.838   316.461     0.200
    12.941   317.461     0.200
     2.972    83.562     0.200
     3.709   104.062     0.200
     6.108   161.258     0.200
     6.916   178.258     0.200
     8.574   224.266     0.200
     9.205   238.023     0.200
     9.271   239.430     0.200
     9.301   241.891     0.200
     9.335   240.992     0.200
     9.350   241.102     0.200
     9.502   240.461     0.200
    12.951   317.461     0.200
     6.108   160.844     0.200
     6.108   160.844     0.200
     6.108   160.844     0.200
     6.108   159.977     0.200
     1.184    38.133     0.200
     3.544    98.336     0.200
     3.091    88.633     0.200
     3.575   100.133     0.200
     1.153    37.344     0.200
     2.542    74.047     0.200
     3.173    89.547     0.200
     3.527    99.047     0.200
    12.041   293.047     0.200
     8.537   220.641     0.200
     8.552   220.016     0.200
     1.164    37.867     0.200
     1.137    38.766     0.200
     3.500    98.766     0.200
     3.632   101.266     0.200
     0.996    32.914     0.200
     1.147    37.000     0.200
     1.149    37.703     0.200
     3.624    98.906     0.200
     3.654   101.703     0.200
     3.739   104.102     0.200
    12.045   296.703     0.200
     1.104    35.906     0.200
     6.139   161.500     0.200
     7.327   184.703     0.200
     6.139   161.133     0.200
     1.103    36.555     0.200
     1.354    42.656     0.200
     3.449    93.953     0.200
     3.479    97.156     0.200
    13.113   320.156     0.200
     1.301    41.359     0.200
     5.828   153.758     0.200
     5.971   156.453     0.200
     9.300   236.281     0.200
     9.338   239.914     0.200
     9.320   236.953     0.200
    12.182   300.156     0.200
    12.979   317.156     0.200
     5.971   156.750     0.200
     5.971   157.938     0.200
     1.121    37.266     0.200
     1.174    39.266     0.200
     3.626   102.766     0.200
     3.710   104.562     0.200
     3.493    98.867     0.200
     3.595    98.469     0.200
     6.110   160.969     0.200
     8.541   222.461     0.200
     8.565   221.688     0.200
     8.580   220.531     0.200
     6.110   161.062     0.200
     6.110   160.172     0.200
     6.110   160.008     0.200
     3.614    98.374     0.200
     3.645   101.874     0.200
     3.731   105.074     0.200
     7.353   180.874     0.200
    12.855   315.874     0.200
    12.948   315.874     0.200
    12.958   315.874     0.200
    13.882   340.874     0.200
     1.109    37.549     0.200
     2.635    75.549     0.200
     3.540   100.549     0.200
     0.960    33.336     0.200
     3.560   100.355     0.200
     1.123    37.174     0.200
     1.061    36.174     0.200
     1.154    38.475     0.200
     2.478    72.174     0.200
     3.497    98.674     0.200
     1.262    40.471     0.200
     2.531    73.471     0.200
     3.626   101.971     0.200
    12.869   315.971     0.200
    12.997   316.971     0.200
     5.849   155.170     0.200
     9.255   238.693     0.200
     9.323   237.803     0.200
     9.356   242.551     0.200
     9.388   241.760     0.200
     9.403   241.232     0.200
     9.428   238.271     0.200
    12.869   314.971     0.200
     1.114    36.523     0.200
     3.583    99.324     0.200
     3.485    97.023     0.200
     3.698   102.723     0.200
     7.340   185.523     0.200
    12.835   315.523     0.200
    12.941   316.523     0.200
     3.931   106.652     0.200
     4.560   122.703     0.200
     5.212   136.652     0.200
     6.019   156.375     0.200
     6.591   170.012     0.200
     7.165   183.523     0.200
     7.906   201.242     0.200
     8.570   221.000     0.200
     9.347   238.355     0.200
     9.361   239.676     0.200
    12.835   315.625     0.200
    12.952   316.523     0.200
    13.864   337.523     0.200
     1.128    38.281     0.200
     1.194    38.281     0.200
     1.188    38.117     0.200
     3.746   104.516     0.200
     7.380   186.086     0.200
    12.969   315.516     0.200
     6.963   178.516     0.200
     7.380   186.086     0.200
     8.420   220.461     0.200
     8.494   221.547     0.200
     8.509   220.188     0.200
     9.208   236.621     0.200
     9.238   238.543     0.200
     9.287   236.879     0.200
    12.025   297.516     0.200
    12.979   315.516     0.200
     1.034    34.609     0.200
     1.154    37.305     0.200
     2.976    79.602     0.200
     3.739   101.602     0.200
    11.226   282.680     0.200
    12.840   312.953     0.200
    13.866   336.258     0.200
     3.522    97.703     0.200
     3.623    98.898     0.200
     3.739   102.102     0.200
     4.967   127.602     0.200
     5.171   136.039     0.200
     5.954   155.203     0.200
     6.549   169.062     0.200
     7.337   183.891     0.200
     7.864   200.305     0.200
     8.423   220.266     0.200
     8.550   223.086     0.200
     9.179   236.094     0.200
     9.308   240.258     0.200
     9.323   240.148     0.200
     9.521   238.602     0.200
     9.885   245.508     0.200
     9.998   254.891     0.200
    10.754   271.602     0.200
    12.840   312.930     0.200
    13.118   319.602     0.200
    13.866   337.773     0.200
     1.202    39.062     0.200
     1.188    38.859     0.200
     2.689    74.859     0.200
     3.618    99.758     0.200
     2.625    77.176     0.200
     3.559   101.875     0.200
     3.019    82.576     0.200
     3.953   107.125     0.200
     4.375   118.566     0.200
     5.818   151.686     0.200
     6.590   169.887     0.200
     7.253   184.125     0.200
     0.975    32.609     0.200
     1.464    47.449     0.200
     3.866   104.340     0.200
     3.764   104.770     0.200
     5.141   134.797     0.200
     5.742   149.988     0.200
     5.949   154.270     0.200
     6.163   161.066     0.200
     6.518   168.348     0.200
     7.176   184.707     0.200
     6.163   161.453     0.200
     6.163   161.453     0.200
     6.163   162.781     0.200
     6.163   160.012     0.200
     6.163   162.355     0.200
     1.144    38.406     0.200
     2.964    84.605     0.200
     1.137    39.250     0.200
     1.185    39.750     0.200
     2.628    76.250     0.200
     1.143    37.763     0.200
     1.211    41.062     0.200
     6.056   159.400     0.200
     6.056   159.400     0.200
     6.056   159.400     0.200
     6.056   159.400     0.200
     2.688    76.895     0.200
     3.595    98.094     0.200
     3.716   103.994     0.200
     3.917   107.004     0.200
     5.184   136.244     0.200
     5.784   152.084     0.200
     7.219   186.725     0.200
     7.875   201.383     0.200
     1.181    39.242     0.200
     1.067    34.484     0.200
     2.730    75.953     0.200
     3.715   101.953     0.200
     7.367   184.930     0.200
    11.240   278.984     0.200
    12.867   313.031     0.200
    13.894   339.875     0.200
     3.498    97.250     0.200
     3.597    96.852     0.200
     6.110   159.656     0.200
     6.114   161.094     0.200
     7.367   184.625     0.200
     9.247   238.656     0.200
     9.311   238.570     0.200
    10.226   261.750     0.200
    11.240   278.984     0.200
    12.061   296.453     0.200
    12.974   316.953     0.200
    13.151   323.055     0.200
    13.894   339.875     0.200
    21.198   525.453     0.200
     6.114   159.578     0.200
     6.114   159.672     0.200
     1.070    34.898     0.200
     1.149    37.039     0.200
     1.188    38.039     0.200
     2.635    75.836     0.200
     2.859    79.336     0.200
     3.596    96.836     0.200
     3.317    91.039     0.200
     7.370   185.664     0.200
    12.869   315.336     0.200
    13.897   337.758     0.200
     3.497    96.734     0.200
     3.713   102.633     0.200
     5.001   129.836     0.200
     6.113   160.914     0.200
     7.370   186.469     0.200
     7.182   184.938     0.200
     9.171   236.859     0.200
     9.180   236.227     0.200
     9.197   236.906     0.200
     9.247   235.609     0.200
     9.277   236.977     0.200
     9.311   237.250     0.200
     9.326   237.938     0.200
     9.485   239.836     0.200
    12.869   315.336     0.200
    13.154   322.633     0.200
     6.113   160.109     0.200
     6.113   159.836     0.200
     1.141    37.414     0.200
     1.143    38.117     0.200
     0.942    33.195     0.200
     1.220    39.883     0.200
     3.680   100.289     0.200
     7.348   182.266     0.200
     1.061    35.184     0.200
     2.755    77.055     0.200
     3.738   102.055     0.200
     5.747   151.523     0.200
     7.369   184.695     0.200
     8.767   220.453     0.200
    11.257   281.965     0.200
    12.036   296.055     0.200
    12.873   312.855     0.200
    13.899   339.285     0.200
     2.755    77.555     0.200
     3.072    85.793     0.200
     3.072    85.195     0.200
     3.003    85.055     0.200
     3.522    97.953     0.200
     4.323   115.195     0.200
     4.475   122.555     0.200
     4.998   130.055     0.200
     5.167   135.254     0.200
     5.747   151.523     0.200
     5.723   147.055     0.200
     5.768   149.934     0.200
     5.974   154.176     0.200
     5.963   154.156     0.200
     6.187   161.375     0.200
     6.133   159.656     0.200
     6.544   168.316     0.200
     7.369   183.254     0.200
     7.207   185.055     0.200
     7.860   198.953     0.200
     8.384   218.918     0.200
     8.397   218.934     0.200
     8.490   221.945     0.200
     8.525   222.359     0.200
     8.767   220.434     0.200
     9.069   235.164     0.200
     9.148   235.254     0.200
     9.157   236.535     0.200
     9.223   238.051     0.200
     9.253   240.203     0.200
     9.287   238.781     0.200
     9.302   239.539     0.200
     9.499   239.555     0.200
    11.198   279.227     0.200
    11.257   281.965     0.200
    12.971   317.055     0.200
    13.140   321.484     0.200
    13.899   338.055     0.200
     3.580    99.094     0.200
     3.301    92.793     0.200
     3.697   102.793     0.200
     7.374   183.223     0.200
    12.871   312.023     0.200
    13.165   321.273     0.200
     3.292    92.793     0.200
     3.481    96.691     0.200
     4.364   117.824     0.200
     4.435   122.793     0.200
     5.208   135.742     0.200
     5.764   149.383     0.200
     5.922   155.895     0.200
     6.016   154.684     0.200
     6.092   159.992     0.200
     6.585   171.062     0.200
     7.166   185.094     0.200
     7.901   199.762     0.200
     9.104   233.738     0.200
     9.183   235.688     0.200
     9.260   235.289     0.200
     9.291   239.949     0.200
     9.339   237.934     0.200
     9.474   239.293     0.200
    10.239   261.793     0.200
    12.871   314.832     0.200
    12.984   316.793     0.200
    13.165   321.273     0.200
     0.852    29.008     0.200
     1.164    37.508     0.200
     1.130    37.195     0.200
     7.382   185.602     0.200
     1.131    39.109     0.200
     1.190    38.406     0.200
     5.715   149.859     0.200
     7.358   184.312     0.200
     1.121    38.398     0.200
     1.170    38.398     0.200
     1.140    36.719     0.200
     1.140    37.922     0.200
     1.187    38.117     0.200
     1.144    39.496     0.200
     1.038    34.180     0.200
     1.214    38.719     0.200
     1.063    34.758     0.200
     1.129    37.098     0.200
     1.145    37.699     0.200
     1.191    38.199     0.200
     1.034    33.930     0.200
     1.244    40.730     0.200
     1.119    36.428     0.200
     0.969    31.496     0.200
     1.160    37.305     0.200
     2.374    62.605     0.200
     2.496    72.008     0.200
     2.771    78.207     0.200
     3.651    99.305     0.200
     3.766   104.906     0.200
     4.549   120.906     0.200
     4.745   129.906     0.200
     7.305   183.266     0.200
     8.726   220.125     0.200
    12.811   314.906     0.200
     2.771    76.906     0.200
     3.548    98.105     0.200
     5.954   154.555     0.200
     6.528   167.777     0.200
     7.305   183.117     0.200
     7.182   182.055     0.200
     7.231   185.305     0.200
     8.675   216.406     0.200
     9.168   235.832     0.200
     9.168   236.906     0.200
     9.176   236.176     0.200
     9.192   237.375     0.200
     9.240   236.230     0.200
     9.240   236.355     0.200
     9.304   238.941     0.200
     9.304   238.707     0.200
     9.318   239.066     0.200
     9.318   240.172     0.200
     9.557   239.906     0.200
     9.852   246.406     0.200
    12.811   313.848     0.200
    13.082   317.305     0.200
    13.025   327.906     0.200
    13.837   336.348     0.200
     1.058    34.383     0.200
     1.173    38.074     0.200
     3.612   100.273     0.200
     0.948    33.215     0.200
     1.118    36.496     0.200
     3.672   100.594     0.200
     7.343   184.805     0.200
     1.148    36.914     0.200
     2.690    76.516     0.200
     2.734    77.016     0.200
     4.698   129.516     0.200
     5.725   149.527     0.200
     7.358   184.164     0.200
    12.859   313.156     0.200
    13.886   337.945     0.200
     3.503    97.617     0.200
     3.603   100.117     0.200
     3.720   101.316     0.200
     4.343   116.785     0.200
     4.539   121.805     0.200
     4.457   120.016     0.200
     4.989   130.016     0.200
     5.188   134.984     0.200
     5.725   149.527     0.200
     5.743   148.188     0.200
     5.789   150.047     0.200
     5.995   155.527     0.200
     6.209   158.688     0.200
     6.565   169.086     0.200
     7.358   183.574     0.200
     7.222   183.164     0.200
     7.881   198.566     0.200
     8.389   216.754     0.200
     8.422   219.996     0.200
     8.454   217.602     0.200
     8.535   222.402     0.200
     8.550   222.031     0.200
     8.611   220.254     0.200
     8.950   231.215     0.200
     9.094   231.848     0.200
     9.199   237.551     0.200
     9.248   239.191     0.200
     9.278   239.234     0.200
     9.312   239.844     0.200
     9.327   240.043     0.200
     9.496   239.016     0.200
     9.906   246.797     0.200
    12.221   299.016     0.200
    13.886   336.594     0.200
     1.141    37.441     0.200
     1.133    36.766     0.200
     1.182    38.566     0.200
     1.105    36.727     0.200
     1.141    37.227     0.200
     1.129    36.345     0.200
     1.177    38.345     0.200
     1.145    37.559     0.200
     1.138    37.457     0.200
     1.186    38.258     0.200
     3.595   100.059     0.200
     1.039    34.660     0.200
     1.101    35.961     0.200
     1.170    38.160     0.200
     3.632   100.062     0.200
     1.504    48.660     0.200
     3.532    97.660     0.200
     4.314   114.941     0.200
     4.510   119.820     0.200
     5.760   150.602     0.200
     6.148   163.020     0.200
     6.537   167.402     0.200
     6.148   161.016     0.200
     6.148   161.016     0.200
     6.148   159.430     0.200
     1.133    37.148     0.200
     3.595   101.448     0.200
     3.644   100.307     0.200
     5.738   149.997     0.200
     1.156    38.852     0.200
     5.733   149.984     0.200
     1.163    39.191     0.200
     1.164    39.379     0.200
     2.677    75.879     0.200
     5.707   148.828     0.200
    12.020   297.777     0.200
    12.821   314.457     0.200
     1.527    46.578     0.200
     5.707   148.828     0.200
     5.953   152.879     0.200
     5.975   155.879     0.200
     6.170   158.039     0.200
     6.165   164.535     0.200
     6.526   167.578     0.200
     7.181   181.117     0.200
     7.232   186.078     0.200
     9.551   239.777     0.200
    12.176   299.777     0.200
    12.821   314.777     0.200
    12.821   314.457     0.200
    12.915   314.777     0.200
     6.165   160.910     0.200
     6.165   160.910     0.200
     1.136    37.566     0.200
     5.706   150.727     0.200
     3.604    99.766     0.200
     5.514   140.066     0.200
     5.706   150.727     0.200
     5.935   155.367     0.200
     6.119   162.541     0.200
     6.927   178.967     0.200
    12.838   314.066     0.200
     1.160    38.975     0.200
     5.697   148.775     0.200
     1.424    49.037     0.200
     2.581    73.037     0.200
    13.595   331.037     0.200
    13.757   335.037     0.200
     3.949   108.022     0.200
     4.142   113.422     0.200
     6.759   173.933     0.200
     7.153   177.513     0.200
    12.639   311.022     0.200
     1.213    42.535     0.200
     2.308    63.336     0.200
     2.564    72.887     0.200
     2.915    83.336     0.200
     2.965    85.146     0.200
     3.334    94.137     0.200
     3.580   100.336     0.200
     3.922   105.846     0.200
     5.465   144.076     0.200
     5.661   149.035     0.200
     6.065   159.336     0.200
     6.308   162.355     0.200
     6.865   176.637     0.200
     6.908   177.977     0.200
     7.116   182.137     0.200
     7.754   191.816     0.200
     7.680   196.676     0.200
     8.343   211.615     0.200
     8.709   222.336     0.200
     8.999   228.297     0.200
     9.025   227.977     0.200
     1.262    43.193     0.200
     2.651    76.123     0.200
     4.783   131.193     0.200
     7.400   187.943     0.200
     1.135    39.551     0.200
     1.488    48.941     0.200
     2.382    69.852     0.200
     2.468    72.332     0.200
     2.828    80.342     0.200
     2.828    82.271     0.200
     4.932   133.602     0.200
     6.388   167.971     0.200
     6.943   180.191     0.200
     6.989   180.752     0.200
     7.195   185.312     0.200
     7.764   198.951     0.200
     7.692   195.391     0.200
    12.948   318.961     0.200
    14.036   343.352     0.200
     1.070    37.391     0.200
     2.530    71.391     0.200
     2.612    73.391     0.200
     4.843   130.289     0.200
     4.848   128.891     0.200
     5.610   146.984     0.200
     5.810   152.781     0.200
     6.453   167.039     0.200
     7.011   179.500     0.200
     7.053   179.883     0.200
     7.261   183.500     0.200
     7.822   198.883     0.200
     7.848   192.773     0.200
     8.488   212.273     0.200
     8.585   216.688     0.200
     9.165   228.297     0.200
    13.305   325.391     0.200
     1.164    40.211     0.200
     1.500    48.500     0.200
     2.565    69.699     0.200
     2.565    72.699     0.200
     2.484    72.199     0.200
     4.605   122.480     0.200
     4.810   127.461     0.200
     5.448   141.820     0.200
     6.048   155.438     0.200
     6.256   160.777     0.200
     6.820   174.480     0.200
     7.510   185.590     0.200
     7.483   189.820     0.200
     8.138   205.598     0.200
     8.865   218.098     0.200
    12.307   301.199     0.200
    12.966   317.199     0.200
     3.191    91.195     0.200
     3.165    87.695     0.200
     3.402    95.996     0.200
     4.036   109.996     0.200
     4.591   122.996     0.200
     4.637   123.996     0.200
     4.843   129.496     0.200
     5.061   134.795     0.200
     5.416   143.295     0.200
     6.237   162.215     0.200
     6.723   172.314     0.200
     7.200   181.885     0.200
     7.264   189.746     0.200
     8.338   215.195     0.200
     9.199   233.996     0.200
    10.312   261.695     0.200
    12.380   303.996     0.200
    12.558   307.195     0.200
    12.863   316.195     0.200
     1.220    42.281     0.200
     2.793    79.234     0.200
     3.342    91.453     0.200
     3.684   102.531     0.200
     3.875   107.836     0.200
     4.266   119.234     0.200
     4.530   121.438     0.200
     5.083   134.633     0.200
     5.133   136.133     0.200
     5.336   140.234     0.200
     5.560   146.531     0.200
     5.920   154.023     0.200
     6.564   169.031     0.200
     7.161   180.211     0.200
     7.226   185.133     0.200
     7.272   186.031     0.200
    11.413   281.031     0.200
    11.996   295.211     0.200
    12.635   310.336     0.200
    12.641   310.234     0.200
    16.817   416.031     0.200
     1.239    45.375     0.200
     1.469    48.215     0.200
     2.394    68.977     0.200
     3.153    86.375     0.200
     3.537    94.746     0.200
     3.620   101.977     0.200
     5.032   135.496     0.200
    16.165   400.004     0.200
     2.277    65.664     0.200
     3.253    88.965     0.200
     3.409    92.137     0.200
     3.551    95.023     0.200
     4.635   122.355     0.200
     6.327   160.645     0.200
     6.783   172.195     0.200
     7.279   181.645     0.200
     8.125   208.164     0.200
     8.373   213.863     0.200
     9.126   235.414     0.200
     3.240    91.330     0.200
     4.220   112.459     0.200
     4.515   121.730     0.200
     5.070   135.029     0.200
     5.117   135.730     0.200
     5.322   140.129     0.200
     5.542   146.029     0.200
     5.897   154.730     0.200
     6.549   168.830     0.200
     6.597   171.230     0.200
     6.886   176.459     0.200
     7.205   182.240     0.200
     7.210   185.330     0.200
    11.393   281.430     0.200
    13.799   336.029     0.200
    14.999   377.330     0.200
     1.083    36.197     0.200
     1.867    54.097     0.200
     2.885    81.157     0.200
     3.310    88.707     0.200
     4.781   123.447     0.200
     7.265   181.347     0.200
    13.745   336.722     0.200
     1.118    35.607     0.200
     2.627    70.808     0.200
     2.798    78.857     0.200
     2.828    77.607     0.200
     3.028    85.617     0.200
     3.459    95.058     0.200
     4.465   119.508     0.200
     5.307   138.808     0.200
     5.793   151.338     0.200
     5.865   151.508     0.200
     5.907   153.607     0.200
     5.983   156.607     0.200
     6.115   158.308     0.200
     6.319   163.907     0.200
     6.678   171.407     0.200
     7.404   185.848     0.200
     7.499   186.468     0.200
     7.499   187.928     0.200
     7.997   202.907     0.200
     8.783   220.508     0.200
     9.330   235.308     0.200
    10.048   251.308     0.200
    12.165   296.808     0.200
    13.039   322.688     0.200
    13.119   319.808     0.200
    13.119   322.808     0.200
    14.014   341.708     0.200
    14.341   348.889     0.200
    15.589   379.538     0.200
    16.356   401.378     0.200
     1.055    34.859     0.200
     2.975    84.160     0.200
     3.403    95.152     0.200
     4.510   120.859     0.200
     4.713   126.160     0.200
     5.353   139.461     0.200
     5.737   148.762     0.200
     5.910   153.660     0.200
     5.953   153.859     0.200
     6.161   160.461     0.200
     6.368   165.262     0.200
     6.726   173.359     0.200
     7.019   182.660     0.200
     7.388   188.762     0.200
     8.044   204.562     0.200
     8.784   218.160     0.200
    12.215   297.461     0.200
    12.940   318.461     0.200
    13.098   319.461     0.200
     2.906    82.969     0.200
     3.183    89.414     0.200
     4.158   114.617     0.200
     7.116   181.875     0.200
     7.519   189.688     0.200
    11.095   275.648     0.200
     3.352    90.969     0.200
     4.053   111.766     0.200
     4.595   123.367     0.200
     4.717   122.391     0.200
     5.162   136.867     0.200
     5.181   136.070     0.200
     5.401   141.672     0.200
     5.928   153.766     0.200
     6.510   169.359     0.200
     7.830   193.898     0.200
     7.803   201.867     0.200
     9.031   232.047     0.200
    11.384   277.969     0.200
    11.438   283.719     0.200
    13.165   320.672     0.200
    13.282   322.969     0.200
    14.374   362.766     0.200
    15.929   391.328     0.200
    16.171   396.508     0.200
     2.531    70.348     0.200
     2.943    83.559     0.200
     3.305    89.348     0.200
     3.358    93.770     0.200
     3.836   104.957     0.200
     7.492   188.758     0.200
    14.233   350.473     0.200
    14.233   350.449     0.200
    16.347   402.148     0.200
     1.375    41.904     0.200
     2.846    76.144     0.200
     2.884    80.704     0.200
     3.626    96.684     0.200
    14.247   347.792     0.200
    16.265   398.833     0.200
     3.177    89.438     0.200
     3.797   105.336     0.200
     4.387   118.238     0.200
     4.556   121.176     0.200
     4.950   132.637     0.200
     4.983   132.539     0.200
     5.195   137.637     0.200
     5.386   141.238     0.200
     7.503   190.258     0.200
     7.984   204.238     0.200
     8.292   206.938     0.200
     8.963   226.559     0.200
     9.378   237.238     0.200
    12.812   312.238     0.200
    12.931   315.938     0.200
    13.127   321.969     0.200
    14.109   344.836     0.200
    15.005   365.406     0.200
    16.537   404.574     0.200
     3.082    85.109     0.200
     6.857   172.738     0.200
     7.577   188.398     0.200
    10.928   270.898     0.200
    11.656   287.219     0.200
    12.225   297.898     0.200
    13.482   328.998     0.200
    15.663   382.688     0.200
     3.228    88.674     0.200
     3.187    88.174     0.200
     3.475    94.074     0.200
     3.837   104.773     0.200
     4.390   117.273     0.200
     4.441   118.475     0.200
     4.651   124.174     0.200
     4.605   120.963     0.200
     4.643   123.373     0.200
     4.643   123.674     0.200
     4.873   128.773     0.200
     4.873   128.975     0.200
     5.225   137.074     0.200
     7.088   178.494     0.200
     7.488   186.414     0.200
     7.659   190.404     0.200
     7.659   192.574     0.200
     7.659   193.725     0.200
     7.659   194.113     0.200
     8.327   216.254     0.200
     8.544   216.174     0.200
     9.074   230.574     0.200
    10.726   262.174     0.200
    12.399   304.174     0.200
    12.772   311.174     0.200
    13.720   334.074     0.200
    15.137   381.475     0.200
    15.511   378.984     0.200
     1.352    47.562     0.200
     1.614    51.250     0.200
     1.614    52.152     0.200
     2.613    75.531     0.200
     3.571    97.473     0.200
     3.571    98.832     0.200
     3.571    99.121     0.200
     2.467    70.443     0.200
     2.489    72.783     0.200
     3.661    99.623     0.200
     5.426   144.344     0.200
     5.550   143.134     0.200
     6.071   157.743     0.200
     6.301   164.943     0.200
     6.628   171.144     0.200
     6.671   172.243     0.200
     6.879   176.943     0.200
     7.085   181.743     0.200
     7.678   193.304     0.200
     9.308   231.203     0.200
    13.753   336.068     0.200
    16.149   395.762     0.200
    16.149   395.493     0.200
     2.819    78.994     0.200
     2.990    83.934     0.200
     3.362    91.455     0.200
     3.858   105.693     0.200
     4.283   117.994     0.200
     4.510   120.395     0.200
     4.401   119.693     0.200
     5.064   134.193     0.200
     5.113   135.693     0.200
     5.316   139.795     0.200
     5.539   145.693     0.200
     5.893   153.693     0.200
     5.945   152.193     0.200
     9.649   247.584     0.200
    11.391   279.994     0.200
    12.009   294.994     0.200
     1.029    32.623     0.200
     2.519    70.123     0.200
     2.921    81.854     0.200
     3.351    91.213     0.200
     3.566    95.822     0.200
     3.844   100.953     0.200
     4.692   122.822     0.200
     5.052   130.123     0.200
     5.340   139.223     0.200
     5.685   147.812     0.200
     5.941   154.023     0.200
     6.717   172.623     0.200
     9.383   230.523     0.200
    11.181   274.354     0.200
    12.733   310.754     0.200
    12.880   311.623     0.200
    13.258   321.113     0.200
    14.375   347.955     0.200
    16.442   398.898     0.200
    19.040   466.924     0.200
    21.292   527.623     0.200
     0.879    32.664     0.200
     2.042    58.062     0.200
     3.232    86.164     0.200
     4.162   112.664     0.200
     4.916   131.164     0.200
     4.947   131.562     0.200
     5.708   149.562     0.200
     7.540   187.945     0.200
     8.122   202.023     0.200
     9.326   236.461     0.200
     9.326   237.461     0.200
     9.872   248.664     0.200
    11.186   273.664     0.200
    11.910   291.203     0.200
    12.359   300.266     0.200
    12.820   312.641     0.200
    12.957   317.664     0.200
    14.662   370.664     0.200
    16.514   405.961     0.200
     2.056    60.273     0.200
     2.926    82.891     0.200
     2.926    83.375     0.200
     3.419    92.836     0.200
     3.762   104.375     0.200
     4.074   105.695     0.200
     4.342   117.570     0.200
     4.906   132.070     0.200
     4.936   131.172     0.200
     5.141   133.773     0.200
     5.150   137.477     0.200
     5.336   140.570     0.200
     5.697   149.977     0.200
     7.548   188.055     0.200
     8.116   203.414     0.200
     8.761   228.750     0.200
     9.312   235.875     0.200
    12.366   303.477     0.200
    13.178   323.773     0.200
    16.509   404.344     0.200
     2.855    79.455     0.200
     3.018    81.535     0.200
     3.169    86.625     0.200
     3.314    90.096     0.200
     3.694   101.986     0.200
     4.238   113.486     0.200
     4.356   116.686     0.200
     4.448   119.086     0.200
     4.907   129.986     0.200
     4.960   131.186     0.200
     5.162   136.086     0.200
     5.391   141.986     0.200
     5.744   149.887     0.200
     5.957   152.746     0.200
     6.725   170.727     0.200
     7.087   177.955     0.200
     7.952   200.916     0.200
     8.030   207.086     0.200
     8.297   218.736     0.200
     9.606   239.836     0.200
    11.911   292.086     0.200
    12.530   305.586     0.200
    12.713   311.086     0.200
    13.692   332.625     0.200
     2.617    73.735     0.200
     3.188    85.266     0.200
     3.220    87.766     0.200
     3.361    93.266     0.200
     4.570   117.676     0.200
     4.906   128.365     0.200
     7.192   178.456     0.200
     7.300   187.266     0.200
     8.379   210.266     0.200
     9.166   234.565     0.200
    10.873   266.766     0.200
     2.885    80.088     0.200
     3.356    89.008     0.200
     3.706   102.348     0.200
     4.268   110.459     0.200
     4.361   117.248     0.200
     4.435   116.148     0.200
     4.914   130.248     0.200
     4.964   130.949     0.200
     5.167   136.248     0.200
     5.393   140.949     0.200
     5.746   149.848     0.200
     5.992   151.369     0.200
     6.767   172.459     0.200
     7.131   178.418     0.200
     7.750   199.148     0.200
     7.974   202.209     0.200
     8.340   220.498     0.200
    13.454   336.279     0.200
     2.444    68.562     0.200
     2.659    75.004     0.200
     2.890    81.242     0.200
     3.191    85.781     0.200
     3.755    99.672     0.200
     0.958    32.477     0.200
     2.412    67.320     0.200
     2.628    74.008     0.200
     2.857    79.508     0.200
     4.278   114.820     0.200
     5.451   140.914     0.200
     5.624   149.219     0.200
     6.879   176.422     0.200
     7.073   181.320     0.200
     7.295   186.820     0.200
     7.652   194.922     0.200
     8.557   217.727     0.200
     8.771   222.117     0.200
     9.422   230.438     0.200
     9.817   239.453     0.200
    10.243   251.422     0.200
    10.820   265.109     0.200
    11.209   282.438     0.200
    12.974   315.844     0.200
    13.453   329.320     0.200
    13.629   332.312     0.200
    14.057   342.617     0.200
    14.880   372.719     0.200
    16.148   394.086     0.200
    16.148   394.023     0.200
    16.148   397.312     0.200
    21.919   542.922     0.200
     1.121    36.961     0.200
     1.504    48.902     0.200
     2.621    75.371     0.200
     2.852    82.391     0.200
     5.413   140.383     0.200
     5.977   156.961     0.200
     1.255    41.059     0.200
     3.497    97.027     0.200
     3.848   105.070     0.200
    16.388   405.629     0.200
     2.754    78.730     0.200
     3.259    90.789     0.200
     3.302    88.352     0.200
     3.580    99.719     0.200
     3.881   106.629     0.200
     4.135   111.332     0.200
     4.543   120.930     0.200
     5.095   133.730     0.200
     5.336   140.031     0.200
     5.348   140.129     0.200
     5.576   144.930     0.200
     5.929   153.531     0.200
     6.575   168.430     0.200
     7.123   178.340     0.200
     7.239   184.332     0.200
     7.288   184.629     0.200
     8.321   218.242     0.200
    12.608   309.730     0.200
     2.716    77.855     0.200
     2.844    79.117     0.200
     3.015    82.227     0.200
     3.176    87.148     0.200
     3.670    96.477     0.200
     3.849   104.316     0.200
     4.225   111.629     0.200
     4.498   119.617     0.200
     5.052   131.918     0.200
     5.100   132.719     0.200
     5.292   138.719     0.200
     5.304   137.918     0.200
     5.525   143.418     0.200
     5.880   151.816     0.200
     5.970   152.516     0.200
     6.532   167.719     0.200
     7.196   181.469     0.200
     7.192   183.418     0.200
     7.236   184.418     0.200
     7.880   203.617     0.200
    12.667   312.617     0.200
     2.871    80.848     0.200
     3.460    93.977     0.200
     4.506   119.066     0.200
     5.262   141.027     0.200
     6.406   165.227     0.200
     6.785   172.527     0.200
     7.080   182.227     0.200
     7.432   187.438     0.200
     7.998   203.527     0.200
     8.099   203.527     0.200
     9.397   238.328     0.200
    10.488   267.016     0.200
    11.801   290.355     0.200
    12.750   311.688     0.200
    12.855   315.707     0.200
    13.058   318.816     0.200
    13.474   339.266     0.200
    14.769   370.527     0.200
    15.055   369.168     0.200
    16.607   409.129     0.200
    16.607   409.039     0.200
    18.400   455.527     0.200
     1.159    43.480     0.200
     1.564    50.121     0.200
     3.571    95.320     0.200
     3.754   100.781     0.200
    11.992   302.906     0.200
    16.095   396.715     0.200
     3.206    91.344     0.200
     3.405    95.742     0.200
     4.052   110.242     0.200
     4.605   123.742     0.200
     4.858   130.641     0.200
     5.436   143.141     0.200
     6.085   158.445     0.200
     8.327   211.844     0.200
     8.361   221.242     0.200
    12.795   315.844     0.200
     2.646    76.002     0.200
     2.627    75.422     0.200
     2.983    83.082     0.200
     3.228    88.133     0.200
     3.228    90.133     0.200
     3.474    95.441     0.200
     3.779   103.361     0.200
     3.796   103.502     0.200
     3.970   108.602     0.200
     4.290   115.502     0.200
     4.664   123.002     0.200
     5.193   137.002     0.200
     5.247   137.701     0.200
     5.435   142.201     0.200
     5.448   142.803     0.200
     5.680   147.902     0.200
     6.032   156.002     0.200
     6.674   171.902     0.200
     6.808   173.213     0.200
     7.340   187.502     0.200
     7.394   188.102     0.200
     7.750   198.002     0.200
     8.264   218.312     0.200
    12.583   308.002     0.200
    13.337   331.223     0.200
    15.061   367.381     0.200
    15.061   367.963     0.200
    16.874   413.389     0.200
    16.874   413.781     0.200
    20.627   515.402     0.200
     4.251   111.850     0.200
     7.156   179.090     0.200
     7.788   196.930     0.200
     8.237   211.150     0.200
     9.314   237.961     0.200
     2.724    78.125     0.200
     3.156    87.324     0.200
     3.359    91.453     0.200
     3.652    97.715     0.200
     3.836   104.965     0.200
     3.908   105.984     0.200
     4.208   109.855     0.200
     5.042   133.164     0.200
     5.091   134.766     0.200
     5.283   139.164     0.200
     5.295   140.062     0.200
     5.295   139.164     0.200
     5.872   153.766     0.200
     6.522   168.766     0.200
     7.167   179.703     0.200
     7.184   183.965     0.200
     7.230   185.062     0.200
     7.891   203.164     0.200
     8.101   202.855     0.200
     8.369   219.645     0.200
    11.371   279.164     0.200
    12.617   306.652     0.200
    13.347   331.031     0.200
    16.821   414.988     0.200
     1.278    40.301     0.200
     1.924    54.871     0.200
     2.127    58.352     0.200
     2.348    65.352     0.200
     3.113    83.293     0.200
     6.466   166.562     0.200
    10.430   263.633     0.200
    11.516   286.336     0.200
    12.657   315.133     0.200
    12.861   315.133     0.200
    12.862   316.062     0.200
    12.876   316.434     0.200
    12.999   324.453     0.200
    13.748   335.551     0.200
    15.349   373.281     0.200
    16.565   403.543     0.200
     0.912    29.420     0.200
     2.080    58.279     0.200
     2.591    72.279     0.200
     3.038    83.119     0.200
     3.611    95.889     0.200
     5.428   142.279     0.200
     5.504   145.279     0.200
     6.070   157.479     0.200
     6.715   170.879     0.200
     7.272   184.979     0.200
     7.314   185.580     0.200
     7.510   191.180     0.200
     7.522   191.379     0.200
     7.959   198.939     0.200
     8.083   203.479     0.200
     8.120   206.479     0.200
     8.750   219.180     0.200
     9.425   234.180     0.200
     9.460   239.979     0.200
    10.582   261.279     0.200
    11.873   297.180     0.200
    12.030   297.080     0.200
    12.152   299.779     0.200
    13.220   321.619     0.200
    14.783   373.580     0.200
    15.900   388.680     0.200
    22.174   549.779     0.200
     3.475    97.430     0.200
     4.126   111.930     0.200
     4.270   116.805     0.200
     4.729   126.727     0.200
     4.920   130.227     0.200
     4.932   130.930     0.200
     5.159   136.625     0.200
     6.159   160.227     0.200
     6.822   176.328     0.200
     6.872   177.430     0.200
     8.339   217.398     0.200
     9.321   234.125     0.200
     9.321   238.031     0.200
    10.309   253.625     0.200
    12.597   304.797     0.200
    13.281   321.688     0.200
    13.765   332.656     0.200
    14.396   348.617     0.200
    15.123   366.055     0.200
    15.423   376.352     0.200
    16.973   417.969     0.200
    18.553   458.625     0.200
    20.582   512.328     0.200
     1.477    49.039     0.200
     3.018    84.809     0.200
     3.073    85.539     0.200
     3.390    93.078     0.200
     3.485    97.809     0.200
     4.140   113.709     0.200
     4.259   117.158     0.200
     4.400   117.519     0.200
     4.655   125.809     0.200
     4.692   126.908     0.200
     4.946   132.408     0.200
     5.174   138.309     0.200
     6.173   161.108     0.200
     6.836   177.009     0.200
     6.887   178.309     0.200
     8.323   219.519     0.200
    10.310   258.809     0.200
    16.983   418.386     0.200
     3.270    88.125     0.200
     3.404    90.867     0.200
     3.464    95.430     0.200
     3.849   101.328     0.200
     4.117   108.531     0.200
     4.281   113.352     0.200
     4.422   114.758     0.200
     4.669   122.031     0.200
     4.720   122.930     0.200
     6.150   155.430     0.200
     6.813   172.227     0.200
     7.108   175.898     0.200
     8.332   216.930     0.200
     9.315   234.727     0.200
    15.098   377.828     0.200
    20.581   509.227     0.200
     1.367    44.511     0.200
     2.437    68.371     0.200
     2.526    71.491     0.200
     3.217    86.121     0.200
     3.557    96.461     0.200
     3.898   102.682     0.200
     4.022   110.191     0.200
     4.869   128.591     0.200
     5.661   148.491     0.200
     5.674   148.091     0.200
     6.901   177.691     0.200
     7.109   177.941     0.200
     7.566   193.691     0.200
     7.618   195.991     0.200
    16.794   409.122     0.200
     0.958    32.078     0.200
     2.497    69.238     0.200
     2.905    81.479     0.200
     3.326    91.389     0.200
     3.810   102.348     0.200
     4.156   113.719     0.200
     4.786   127.818     0.200
     5.434   142.617     0.200
     5.989   155.418     0.200
     6.035   156.918     0.200
     6.228   161.617     0.200
     7.468   190.518     0.200
     8.126   206.418     0.200
     8.160   207.018     0.200
    12.627   313.211     0.200
    16.407   402.531     0.200
     3.109    85.613     0.200
     3.133    88.094     0.200
     3.397    93.102     0.200
     3.523    96.852     0.200
     3.523    97.852     0.200
     3.785   103.293     0.200
     4.045   108.664     0.200
     4.337   116.691     0.200
     4.393   117.293     0.200
     4.389   116.895     0.200
     4.630   123.184     0.200
     4.612   123.895     0.200
     5.818   150.594     0.200
     6.482   165.492     0.200
     6.537   167.895     0.200
     7.071   177.234     0.200
     7.434   186.492     0.200
    10.578   261.691     0.200
    10.676   262.344     0.200
    10.852   267.672     0.200
    10.923   268.023     0.200
    11.518   284.492     0.200
    12.129   294.672     0.200
    12.367   301.281     0.200
    12.369   300.621     0.200
    12.394   302.363     0.200
    12.760   310.895     0.200
    13.495   339.293     0.200
    13.517   339.121     0.200
    13.786   346.332     0.200
    13.884   344.203     0.200
    13.909   350.371     0.200
    15.164   374.602     0.200
    15.159   379.094     0.200
    15.494   376.715     0.200
    20.025   499.191     0.200
     2.903    82.805     0.200
     3.151    87.531     0.200
     4.033   107.703     0.200
     4.012   108.617     0.200
     4.156   113.734     0.200
     4.584   120.664     0.200
     4.951   131.234     0.200
     5.151   136.031     0.200
     5.353   140.836     0.200
     7.512   189.367     0.200
     7.794   198.734     0.200
     8.115   202.406     0.200
     9.344   238.031     0.200
     9.344   237.633     0.200
    11.194   275.234     0.200
    11.432   282.875     0.200
    11.471   284.133     0.200
    12.201   300.797     0.200
    12.655   308.555     0.200
    12.757   311.336     0.200
    12.930   315.562     0.200
    12.931   315.375     0.200
    13.036   317.633     0.200
    13.140   320.734     0.200
    13.026   325.750     0.200
    13.195   330.953     0.200
    13.195   327.281     0.200
    13.341   337.734     0.200
    13.716   335.414     0.200
    13.717   339.703     0.200
    14.390   352.727     0.200
    16.489   402.547     0.200
    16.538   408.367     0.200
    18.319   453.438     0.200
    20.346   509.406     0.200
    20.433   510.734     0.200
     3.223    89.793     0.200
     3.586    98.691     0.200
     1.112    35.760     0.200
     2.613    71.420     0.200
     2.868    80.420     0.200
     3.200    90.420     0.200
     3.597    97.820     0.200
     4.036   108.820     0.200
     4.664   123.619     0.200
     5.300   138.721     0.200
     5.858   151.920     0.200
     5.900   152.920     0.200
     6.095   158.020     0.200
     7.071   182.420     0.200
     7.335   186.920     0.200
     7.480   185.180     0.200
     9.535   241.520     0.200
    10.284   260.820     0.200
    11.612   285.160     0.200
    12.659   314.889     0.200
    12.659   313.279     0.200
    12.676   307.949     0.200
    12.692   312.820     0.200
    12.748   316.141     0.200
    12.815   323.420     0.200
    13.100   319.420     0.200
    13.415   326.150     0.200
    13.940   337.311     0.200
    14.357   352.369     0.200
    14.357   352.820     0.200
    16.353   399.029     0.200
    16.357   398.920     0.200
    16.375   402.426     0.200
    16.375   398.619     0.200
    16.375   400.119     0.200
    16.375   400.119     0.200
    18.946   468.020     0.200
    21.008   523.320     0.200
     1.154    38.840     0.200
     3.184    87.801     0.200
     3.362    93.529     0.200
     5.584   144.840     0.200
     6.612   167.891     0.200
     0.961    32.406     0.200
     5.009   132.000     0.200
     5.639   146.898     0.200
     6.086   160.500     0.200
     7.082   181.398     0.200
     7.660   195.203     0.200
     7.737   195.000     0.200
     7.922   200.117     0.200
     8.322   209.500     0.200
     8.730   221.602     0.200
     8.978   226.500     0.200
     9.005   227.398     0.200
     9.840   243.227     0.200
     9.821   250.156     0.200
    11.991   295.523     0.200
    12.028   299.422     0.200
    12.168   304.891     0.200
    12.200   306.438     0.200
    12.371   309.125     0.200
    12.384   309.805     0.200
    13.495   335.109     0.200
    13.497   331.359     0.200
    13.970   340.633     0.200
    13.998   341.789     0.200
    14.383   351.406     0.200
    14.815   363.609     0.200
    15.456   383.422     0.200
    16.071   397.867     0.200
    16.102   398.000     0.200
    16.102   396.602     0.200
    16.102   396.602     0.200
    17.996   449.820     0.200
    19.484   485.297     0.200
    19.473   481.938     0.200
     1.115    37.145     0.200
     2.755    78.045     0.200
     3.180    85.744     0.200
     3.203    89.514     0.200
     3.380    93.844     0.200
     3.474    95.334     0.200
     4.013   107.545     0.200
     4.370   115.193     0.200
     4.569   120.443     0.200
     4.562   120.164     0.200
     4.614   120.844     0.200
     4.807   126.045     0.200
     5.038   131.645     0.200
     6.047   154.943     0.200
     6.707   171.244     0.200
     7.198   180.324     0.200
     8.428   218.184     0.200
    10.329   256.545     0.200
    12.365   303.824     0.200
    12.551   304.635     0.200
    12.664   312.824     0.200
    12.864   313.494     0.200
    16.934   414.475     0.200
    20.009   500.045     0.200
    20.204   504.744     0.200
    20.442   509.244     0.200
     1.076    35.504     0.200
     2.430    67.023     0.200
     4.882   127.422     0.200
     5.146   133.695     0.200
     5.512   143.523     0.200
     6.719   172.422     0.200
     6.763   173.223     0.200
     7.674   190.754     0.200
     8.854   221.824     0.200
     8.883   223.125     0.200
     9.715   239.395     0.200
     9.929   251.258     0.200
    10.884   266.664     0.200
    11.024   278.422     0.200
    11.093   279.152     0.200
    11.798   287.402     0.200
    12.125   302.242     0.200
    12.125   301.352     0.200
    12.219   298.414     0.200
    12.438   308.090     0.200
    12.438   308.625     0.200
    12.490   307.824     0.200
    12.983   316.434     0.200
    13.023   321.652     0.200
    13.023   316.625     0.200
    13.704   334.344     0.200
    16.158   397.590     0.200
    16.158   399.102     0.200
    16.158   399.098     0.200
    16.158   398.043     0.200
     0.957    31.066     0.200
     5.005   131.598     0.200
     5.635   146.496     0.200
     7.081   180.695     0.200
     7.093   180.996     0.200
     7.659   194.297     0.200
     7.907   198.367     0.200
     8.321   209.695     0.200
     8.549   216.805     0.200
     8.745   217.895     0.200
     8.977   225.797     0.200
     9.834   249.297     0.200
    10.336   259.195     0.200
    12.132   301.301     0.200
    12.225   304.656     0.200
    12.389   309.195     0.200
    13.146   319.855     0.200
    16.120   394.676     0.200
    16.120   394.676     0.200
     0.802    26.945     0.200
     2.459    69.102     0.200
     2.606    73.883     0.200
     3.276    86.562     0.200
     3.735    98.844     0.200
     4.397   117.602     0.200
     5.026   134.203     0.200
     6.469   167.602     0.200
     6.481   167.898     0.200
     6.700   174.102     0.200
     7.049   180.102     0.200
     7.709   195.305     0.200
     7.941   200.531     0.200
    16.314   400.867     0.200
     1.005    33.758     0.200
     2.590    74.135     0.200
     2.886    81.854     0.200
     3.740   102.064     0.200
     3.794   103.655     0.200
     4.258   114.854     0.200
     4.637   123.554     0.200
     5.195   137.354     0.200
     5.237   138.554     0.200
     5.432   143.354     0.200
     5.445   143.354     0.200
     5.652   149.054     0.200
     6.010   156.755     0.200
     6.672   171.255     0.200
     7.327   187.854     0.200
     7.359   189.655     0.200
     4.113   109.273     0.200
     7.589   188.742     0.200
     8.128   203.863     0.200
    11.120   275.352     0.200
    11.498   284.254     0.200
    11.541   284.074     0.200
    12.243   300.641     0.200
    12.729   309.934     0.200
    12.475   318.953     0.200
    13.000   320.402     0.200
    13.092   320.613     0.200
    13.547   333.602     0.200
    13.781   334.723     0.200
    14.265   347.504     0.200
    14.453   354.402     0.200
     3.297    93.680     0.200
     3.818   104.266     0.200
     3.812   105.469     0.200
     4.249   114.672     0.200
     4.447   119.867     0.200
     5.094   134.570     0.200
     5.649   148.070     0.200
     5.695   148.672     0.200
     5.888   154.266     0.200
     5.901   154.172     0.200
     6.115   158.469     0.200
     6.471   167.266     0.200
     7.128   182.172     0.200
     7.345   183.977     0.200
     7.787   198.172     0.200
     7.823   199.766     0.200
     8.695   215.586     0.200
     9.556   236.469     0.200
    10.138   256.070     0.200
    12.861   313.969     0.200
    12.861   314.320     0.200
    16.532   408.531     0.200
    21.135   525.969     0.200
     0.949    32.820     0.200
     0.949    32.594     0.200
     2.472    70.695     0.200
     4.141   110.633     0.200
     4.771   126.430     0.200
     5.423   142.133     0.200
     6.024   155.930     0.200
     6.217   160.930     0.200
     6.800   174.234     0.200
     7.404   187.070     0.200
     7.404   185.703     0.200
     7.457   189.836     0.200
     8.116   206.430     0.200
     8.152   207.430     0.200
     8.896   224.070     0.200
     8.998   223.922     0.200
    16.437   401.859     0.200
     6.901   176.309     0.200
     7.179   179.828     0.200
     8.233   206.398     0.200
    13.250   332.598     0.200
    16.775   412.504     0.200
     2.831    78.668     0.200
     3.165    85.469     0.200
     3.238    88.469     0.200
     4.082   108.570     0.200
     4.639   121.770     0.200
     4.877   127.668     0.200
     4.889   127.770     0.200
     5.459   141.770     0.200
     6.117   156.070     0.200
     6.813   173.270     0.200
     9.221   233.969     0.200
    10.753   268.719     0.200
    10.954   267.609     0.200
    20.042   497.070     0.200
    20.256   506.070     0.200
     2.409    68.742     0.200
     8.692   216.039     0.200
    16.123   394.625     0.200
     1.416    44.469     0.200
     1.507    47.027     0.200
     2.906    82.668     0.200
     3.321    92.359     0.200
     3.800   102.410     0.200
     4.206   114.180     0.200
     4.638   123.879     0.200
     4.836   128.879     0.200
     4.836   129.078     0.200
     4.836   129.180     0.200
     5.116   130.398     0.200
     5.483   143.980     0.200
     5.773   146.559     0.200
     6.039   157.277     0.200
     6.083   157.480     0.200
     6.083   158.180     0.200
     6.083   158.578     0.200
     6.277   162.879     0.200
     6.290   162.980     0.200
     6.501   168.180     0.200
     6.858   176.680     0.200
     7.425   185.617     0.200
     7.457   186.379     0.200
     7.517   192.277     0.200
     8.175   208.180     0.200
     8.175   208.379     0.200
     8.207   208.777     0.200
     9.067   227.340     0.200
    10.009   248.699     0.200
    12.348   304.000     0.200
    12.469   315.508     0.200
    12.586   316.781     0.200
    12.586   315.602     0.200
    12.666   320.688     0.200
    12.675   311.828     0.200
    12.904   315.238     0.200
    13.266   326.980     0.200
    13.469   340.969     0.200
    13.702   336.027     0.200
    14.216   349.008     0.200
    14.347   352.848     0.200
    14.875   373.180     0.200
    15.021   366.340     0.200
    16.686   419.031     0.200
    18.049   446.777     0.200
    19.098   473.777     0.200
    19.638   490.617     0.200
    19.645   490.715     0.200
    19.933   501.902     0.200
    20.197   505.000     0.200
    20.465   512.691     0.200
    20.587   514.605     0.200
    20.691   512.906     0.200
    20.798   514.617     0.200
    20.892   518.461     0.200
    21.000   519.895     0.200
    21.019   522.332     0.200
    21.038   524.137     0.200
    21.103   521.398     0.200
    21.216   524.125     0.200
    21.199   525.680     0.200
    21.252   525.727     0.200
    21.265   526.414     0.200
    21.446   530.000     0.200
    21.590   532.223     0.200
    22.149   546.965     0.200
     1.411    44.477     0.200
     2.548    72.438     0.200
     2.548    73.719     0.200
     3.441    97.281     0.200
     5.708   148.102     0.200
     7.453   187.992     0.200
    12.565   314.766     0.200
     1.214    39.586     0.200
     1.180    38.395     0.200
     1.358    43.285     0.200
     3.971   108.484     0.200
     1.032    33.609     0.200
     1.178    38.930     0.200
     1.383    44.727     0.200
     1.116    36.547     0.200
     1.144    37.430     0.200
     1.226    40.219     0.200
     1.272    41.227     0.200
     1.307    42.430     0.200
     1.309    42.117     0.200
     1.373    44.297     0.200
     0.984    32.930     0.200
     1.139    37.148     0.200
     1.156    37.641     0.200
     1.208    39.266     0.200
     1.277    41.617     0.200
     1.140    37.688     0.200
     1.154    37.500     0.200
     1.261    40.738     0.200
     1.308    42.469     0.200
     1.390    44.668     0.200
     1.427    46.359     0.200
     1.441    47.359     0.200
     1.469    47.730     0.200
     1.536    49.008     0.200
     0.976    32.609     0.200
     1.419    44.629     0.200
     1.511    47.039     0.200
     2.549    74.070     0.200
     2.960    83.898     0.200
     3.855   103.598     0.200
     4.198   112.129     0.200
     4.623   122.328     0.200
     4.826   128.527     0.200
     5.466   143.230     0.200
     5.709   150.859     0.200
     6.023   156.230     0.200
     6.066   157.828     0.200
     6.273   162.730     0.200
     6.838   176.328     0.200
     7.503   187.938     0.200
     7.501   191.129     0.200
     8.156   207.930     0.200
     8.186   208.230     0.200
     8.870   221.891     0.200
     8.870   222.668     0.200
     9.070   225.719     0.200
     9.266   230.328     0.200
    10.055   252.270     0.200
    12.559   314.973     0.200
    12.648   311.707     0.200
    13.234   325.668     0.200
    14.077   345.020     0.200
    14.188   347.070     0.200
    16.337   403.230     0.200
    18.021   449.027     0.200
    21.156   526.430     0.200
     1.432    46.352     0.200
     1.584    51.797     0.200
     1.226    40.375     0.200
     1.260    41.703     0.200
     1.082    36.109     0.200
     1.121    36.629     0.200
     1.233    40.238     0.200
     1.347    42.910     0.200
     1.393    44.668     0.200
     1.429    45.680     0.200
     1.419    45.609     0.200
     1.495    48.320     0.200
     2.505    72.738     0.200
     2.914    83.078     0.200
     3.457    96.508     0.200
     5.448   144.449     0.200
     5.666   149.289     0.200
     6.255   163.648     0.200
     6.466   168.648     0.200
     6.823   176.750     0.200
     7.482   191.949     0.200
     8.173   208.047     0.200
    10.002   249.898     0.200
    10.002   250.707     0.200
    12.608   314.918     0.200
    16.391   402.848     0.200
     1.076    35.645     0.200
     1.104    36.145     0.200
     1.109    36.504     0.200
     1.223    40.324     0.200
     1.331    43.086     0.200
     1.357    43.703     0.200
     1.414    45.684     0.200
     1.413    45.855     0.200
     1.480    47.496     0.200
     2.485    71.984     0.200
     3.314    92.246     0.200
     0.922    30.695     0.200
     1.070    34.758     0.200
     1.158    38.086     0.200
     1.218    39.938     0.200
     1.244    41.008     0.200
     1.249    41.219     0.200
     1.295    41.906     0.200
     1.492    46.938     0.200
     1.097    35.844     0.200
     1.120    36.305     0.200
     1.325    42.719     0.200
     1.058    35.007     0.200
     1.195    39.206     0.200
     1.383    44.627     0.200
     1.006    33.273     0.200
     0.936    31.566     0.200
     1.110    36.828     0.200
     1.094    35.938     0.200
     1.099    36.094     0.200
     1.177    38.133     0.200
     1.212    39.891     0.200
     1.232    39.711     0.200
     1.322    42.758     0.200
     1.370    44.164     0.200
     1.405    45.227     0.200
     1.402    45.828     0.200
     1.471    47.008     0.200
     1.148    37.727     0.200
     1.309    42.746     0.200
     0.991    32.930     0.200
     1.013    33.344     0.200
     1.099    36.000     0.200
     1.113    37.094     0.200
     1.267    41.070     0.200
     1.287    41.773     0.200
     1.288    41.914     0.200
     1.338    43.336     0.200
     1.407    44.930     0.200
     0.944    30.883     0.200
     1.003    32.734     0.200
     1.073    35.324     0.200
     1.194    38.875     0.200
     1.206    39.609     0.200
     1.405    45.180     0.200
     1.071    35.055     0.200
     1.120    36.164     0.200
     1.210    38.992     0.200
     0.878    29.006     0.200
     1.321    43.453     0.200
     1.470    48.086     0.200
     2.499    69.746     0.200
     2.585    71.797     0.200
     4.980   131.648     0.200
     5.310   135.406     0.200
     5.624   144.258     0.200
     5.823   151.648     0.200
     6.618   170.648     0.200
     6.630   171.148     0.200
     6.835   176.445     0.200
     7.194   184.848     0.200
     7.617   191.137     0.200
     7.858   199.246     0.200
     8.539   216.246     0.200
     9.000   224.246     0.200
     9.137   226.547     0.200
    10.171   251.188     0.200
    10.171   253.398     0.200
    12.307   306.965     0.200
     3.134    87.667     0.200
     5.418   144.187     0.200
    16.199   397.773     0.200
     1.379    44.906     0.200
     1.447    46.727     0.200
     1.179    38.906     0.200
     1.239    39.875     0.200
     1.275    41.445     0.200
     1.358    43.812     0.200
     1.519    48.594     0.200
     1.560    50.527     0.200
     1.334    43.684     0.200
     1.327    42.793     0.200
     1.544    50.054     0.200
     3.673   103.684     0.200
     4.187   115.903     0.200
     1.354    44.016     0.200
     1.421    46.016     0.200
     1.065    34.590     0.200
     1.112    36.562     0.200
     1.151    37.160     0.200
     1.230    39.652     0.200
     1.327    43.273     0.200
     1.344    43.102     0.200
     1.383    44.781     0.200
     1.424    45.730     0.200
     1.357    43.664     0.200
     1.355    43.703     0.200
     1.444    46.539     0.200
     1.461    46.625     0.200
     1.567    50.250     0.200
     1.610    51.609     0.200
     1.204    39.043     0.200
     1.211    39.336     0.200
     1.388    44.561     0.200
     1.116    36.547     0.200
     1.165    38.688     0.200
     1.217    39.594     0.200
     1.300    41.594     0.200
     1.365    44.188     0.200
     1.439    46.398     0.200
     1.561    50.031     0.200
     1.321    44.422     0.200
     2.390    70.281     0.200
     3.010    87.234     0.200
     3.191    89.836     0.200
     3.745   105.492     0.200
     1.216    39.281     0.200
     1.300    42.148     0.200
     1.079    35.336     0.200
     1.188    38.434     0.200
     1.243    39.684     0.200
     1.252    41.266     0.200
     1.274    41.504     0.200
     1.337    43.355     0.200
     1.497    48.895     0.200
     1.193    37.766     0.200
     1.462    45.516     0.200
     1.386    44.074     0.200
     1.457    46.383     0.200
     1.381    44.234     0.200
     1.513    48.961     0.200
     1.553    50.656     0.200
     1.565    50.664     0.200
     1.449    46.336     0.200
     1.519    48.867     0.200
     1.419    45.902     0.200
     1.539    49.145     0.200
     1.548    49.355     0.200
     1.664    53.633     0.200
     1.670    53.484     0.200
     0.868    28.848     0.200
     0.896    28.998     0.200
     1.130    35.646     0.200
     1.247    40.477     0.200
     1.419    45.422     0.200
     1.490    48.711     0.200
     1.100    36.953     0.200
     1.134    37.555     0.200
     1.230    39.832     0.200
     1.348    44.953     0.200
     1.414    46.805     0.200
     1.493    48.562     0.200
     1.617    52.055     0.200
     0.973    32.391     0.200
     1.008    33.199     0.200
     1.264    41.480     0.200
     1.194    38.805     0.200
     1.215    39.609     0.200
     1.353    42.828     0.200
     1.429    45.695     0.200
     1.329    43.066     0.200
     1.584    50.312     0.200
     1.651    52.570     0.200
     1.085    36.160     0.200
     1.093    35.980     0.200
     1.258    41.551     0.200
     1.264    40.441     0.200
     1.326    42.840     0.200
     1.094    35.214     0.200
     1.144    37.125     0.200
     1.239    39.895     0.200
     1.241    40.395     0.200
     1.272    40.385     0.200
     1.273    41.294     0.200
     1.354    43.294     0.200
     1.488    46.194     0.200
     0.908    31.905     0.200
     3.127    87.974     0.200
     7.666   192.875     0.200
     0.793    26.047     0.200
     0.804    27.047     0.200
     0.862    28.023     0.200
     0.914    29.539     0.200
     1.132    35.648     0.200
     1.152    35.867     0.200
     1.285    40.547     0.200
     1.263    38.742     0.200
     1.305    41.867     0.200
     1.358    43.527     0.200
     1.558    48.824     0.200
     1.551    49.344     0.200
     1.135    38.102     0.200
     1.277    42.047     0.200
     0.915    30.092     0.200
     1.034    33.361     0.200
     1.169    37.121     0.200
     1.363    43.641     0.200
     1.377    44.012     0.200
     1.438    45.381     0.200
     1.496    47.641     0.200
     1.576    49.672     0.200
     1.159    37.883     0.200
     1.305    42.617     0.200
     1.388    44.547     0.200
     1.453    46.000     0.200
     1.150    36.297     0.200
     1.235    38.070     0.200
     1.418    44.148     0.200
     1.115    36.484     0.200
     1.164    37.758     0.200
     1.168    38.289     0.200
     1.277    41.828     0.200
     1.360    44.068     0.200
     1.397    45.508     0.200
     1.400    45.428     0.200
     1.420    45.988     0.200
     1.440    46.508     0.200
     1.507    48.539     0.200
     1.141    36.828     0.200
     1.462    46.180     0.200
     1.512    47.695     0.200
     1.043    34.461     0.200
     1.134    37.340     0.200
     1.190    38.580     0.200
     1.213    39.240     0.200
     1.239    40.100     0.200
     1.322    42.570     0.200
     1.329    42.570     0.200
     1.386    44.529     0.200
     1.411    44.930     0.200
     1.437    45.869     0.200
     1.475    47.080     0.200
     1.137    37.764     0.200
     1.218    39.535     0.200
     1.307    41.965     0.200
     1.377    44.305     0.200
     1.098    35.992     0.200
     1.141    37.078     0.200
     1.126    36.523     0.200
     1.269    41.273     0.200
     1.320    42.074     0.200
     1.353    42.514     0.200
     1.448    45.804     0.200
     1.085    35.352     0.200
     1.442    46.152     0.200
     1.509    47.711     0.200
     1.163    37.660     0.200
     1.201    38.629     0.200
     1.236    39.891     0.200
     1.332    42.379     0.200
     1.491    47.391     0.200
     1.310    41.996     0.200
     1.337    42.566     0.200
     1.458    46.576     0.200
     1.530    49.076     0.200
     1.200    41.727     0.200
     2.395    70.025     0.200
     2.344    68.807     0.200
     2.464    71.465     0.200
     3.634   100.057     0.200
     5.441   144.965     0.200
     6.165   160.506     0.200
     1.241    40.184     0.200
     1.307    41.953     0.200
     1.342    43.094     0.200
     1.425    45.305     0.200
     1.587    50.184     0.200
     1.327    42.969     0.200
     1.353    43.527     0.200
     1.327    42.648     0.200
     1.345    43.102     0.200
     1.493    48.281     0.200
     1.530    48.789     0.200
     1.227    39.914     0.200
     1.465    47.430     0.200
     1.517    49.680     0.200
     1.602    51.797     0.200
     1.633    52.102     0.200
     1.287    42.008     0.200
     0.954    31.109     0.200
     1.118    35.414     0.200
     1.340    44.430     0.200
     1.372    45.137     0.200
     1.412    46.199     0.200
     1.444    47.777     0.200
     1.593    52.520     0.200
     1.601    52.789     0.200
     1.725    56.820     0.200
     1.586    51.730     0.200
     2.474    70.000     0.200
     2.545    75.527     0.200
     2.712    77.719     0.200
     2.888    82.250     0.200
     3.056    86.438     0.200
     3.735   102.480     0.200
     1.424    46.509     0.200
     1.542    49.180     0.200
     1.570    49.270     0.200
     0.978    36.529     0.200
     1.157    41.629     0.200
     2.667    77.339     0.200
     3.148    90.560     0.200
     1.275    41.281     0.200
     0.856    29.148     0.200
     0.978    32.508     0.200
     0.975    31.789     0.200
     0.998    32.898     0.200
     1.024    33.328     0.200
     1.020    33.617     0.200
     1.092    35.672     0.200
     1.083    35.164     0.200
     1.104    36.594     0.200
     1.160    37.719     0.200
     1.276    41.250     0.200
     1.378    44.062     0.200
     1.385    44.117     0.200
     1.004    33.078     0.200
     1.062    34.703     0.200
     1.064    36.234     0.200
     1.141    36.305     0.200
     1.127    36.578     0.200
     1.180    39.250     0.200
     1.194    38.562     0.200
     1.202    40.109     0.200
     1.284    41.180     0.200
     1.312    43.039     0.200
     1.335    43.984     0.200
     1.372    43.359     0.200
     1.368    44.719     0.200
     1.433    46.375     0.200
     1.286    44.695     0.200
     1.325    41.273     0.200
     1.416    44.219     0.200
     4.121   110.875     0.200
     4.244   117.344     0.200
     4.750   126.672     0.200
     4.750   126.875     0.200
     5.045   133.242     0.200
     5.403   140.969     0.200
     5.958   155.570     0.200
     6.004   155.273     0.200
     6.004   155.570     0.200
     6.004   155.672     0.200
     6.197   160.273     0.200
     6.424   166.070     0.200
     6.781   174.672     0.200
     7.437   189.969     0.200
     8.096   206.070     0.200
    12.673   318.438     0.200
     1.292    41.812     0.200
     1.320    42.141     0.200
     1.394    44.422     0.200
     1.537    48.312     0.200
     1.005    32.828     0.200
     1.085    35.148     0.200
     1.242    39.938     0.200
     1.318    42.477     0.200
     1.466    47.031     0.200
     1.131    36.680     0.200
     1.173    38.660     0.200
     1.462    46.990     0.200
     1.531    49.273     0.200
     1.590    51.156     0.200
     1.672    52.484     0.200
     1.719    54.906     0.200
     1.656    54.785     0.200
     2.327    69.086     0.200
     3.095    89.805     0.200
     0.919    31.410     0.200
     1.054    34.590     0.200
     1.307    42.191     0.200
     1.487    47.648     0.200
     1.514    48.781     0.200
     1.228    41.453     0.200
     1.606    50.664     0.200
     2.203    65.242     0.200
     2.284    67.484     0.200
     2.613    76.102     0.200
     2.785    80.121     0.200
     3.095    87.203     0.200
     5.370   143.805     0.200
     1.029    34.016     0.200
     1.204    39.172     0.200
     1.427    46.422     0.200
     1.214    40.055     0.200
     1.330    43.602     0.200
     1.375    45.242     0.200
     1.478    48.531     0.200
     1.347    43.953     0.200
     1.450    46.781     0.200
     1.495    48.188     0.200
     1.580    50.375     0.200
     1.646    52.133     0.200
     1.671    53.172     0.200
     1.419    45.194     0.200
     1.516    47.274     0.200
     1.540    49.904     0.200
     1.568    49.604     0.200
     0.909    30.332     0.200
     0.988    32.512     0.200
     1.142    37.395     0.200
     1.189    38.125     0.200
     1.225    39.773     0.200
     1.309    41.832     0.200
     1.355    42.645     0.200
     1.024    33.843     0.200
     1.104    36.373     0.200
     1.142    38.453     0.200
     1.166    38.173     0.200
     1.160    37.684     0.200
     1.239    40.463     0.200
     1.250    40.693     0.200
     1.286    42.583     0.200
     1.298    41.703     0.200
     1.335    43.803     0.200
     0.893    31.191     0.200
     1.083    35.621     0.200
     1.141    38.055     0.200
     1.196    39.082     0.200
     1.212    39.004     0.200
     1.252    40.863     0.200
     1.313    42.414     0.200
     1.446    47.223     0.200
     1.453    46.555     0.200
     1.529    48.652     0.200
     1.295    42.031     0.200
     1.535    49.359     0.200
     1.596    51.062     0.200
     0.921    31.030     0.200
     1.107    36.760     0.200
     1.219    39.810     0.200
     1.412    45.240     0.200
     1.420    44.690     0.200
     1.091    35.246     0.200
     1.184    38.176     0.200
     1.444    47.086     0.200
     1.341    43.125     0.200
     1.463    47.289     0.200
     1.488    47.250     0.200
     1.604    51.609     0.200
     1.162    38.344     0.200
     1.254    40.543     0.200
     1.345    43.154     0.200
     1.418    46.145     0.200
     1.421    45.781     0.200
     1.454    46.145     0.200
     1.532    49.324     0.200
     0.921    29.914     0.200
     0.977    31.344     0.200
     1.020    32.414     0.200
     1.249    39.273     0.200
     1.219    40.371     0.200
     1.491    48.324     0.200
     1.514    49.613     0.200
     0.826    27.945     0.200
     0.947    31.031     0.200
     0.991    32.531     0.200
     1.044    33.836     0.200
     1.070    34.172     0.200
     1.075    35.039     0.200
     1.118    36.164     0.200
     1.139    37.266     0.200
     1.216    39.211     0.200
     1.246    40.289     0.200
     1.336    43.180     0.200
     1.454    46.539     0.200
     1.450    46.383     0.200
     1.325    43.945     0.200
     3.339    92.992     0.200
     3.791   104.812     0.200
     1.189    39.397     0.200
     1.440    46.557     0.200
     1.560    49.907     0.200
     1.587    51.047     0.200
     1.449    47.297     0.200
     1.507    48.625     0.200
     0.925    30.863     0.200
     1.128    36.855     0.200
     1.146    37.633     0.200
     1.196    38.523     0.200
     1.217    39.773     0.200
     1.229    40.344     0.200
     1.365    44.215     0.200
     1.433    46.113     0.200
     1.403    43.926     0.200
     2.531    71.336     0.200
     3.409    95.336     0.200
     3.484    97.613     0.200
     1.098    35.565     0.200
     1.288    42.676     0.200
     1.451    46.295     0.200
     1.493    46.976     0.200
     1.298    42.148     0.200
     1.379    44.848     0.200
     1.418    46.348     0.200
     1.515    48.768     0.200
     1.573    50.688     0.200
     1.603    51.568     0.200
     0.974    32.342     0.200
     1.060    34.962     0.200
     1.083    35.132     0.200
     1.090    36.222     0.200
     1.249    41.162     0.200
     1.294    40.652     0.200
     1.414    45.462     0.200
     2.966    83.712     0.200
     2.977    84.322     0.200
     3.403    94.912     0.200
     3.525    97.212     0.200
     4.129   111.812     0.200
     4.370   116.612     0.200
     4.464   120.482     0.200
     4.758   123.002     0.200
     4.925   129.712     0.200
     4.973   130.812     0.200
     5.164   135.412     0.200
     5.177   135.412     0.200
     5.398   143.412     0.200
     5.915   151.312     0.200
     6.147   158.962     0.200
     6.404   164.512     0.200
     6.376   163.662     0.200
     6.847   173.882     0.200
     7.065   180.812     0.200
     7.182   180.892     0.200
     7.905   198.282     0.200
     8.002   202.772     0.200
     8.036   201.842     0.200
     8.738   219.292     0.200
     8.391   219.222     0.200
     9.701   243.692     0.200
    10.920   270.092     0.200
    11.250   278.712     0.200
    12.806   314.922     0.200
    16.839   414.634     0.200
     1.257    41.266     0.200
     1.337    44.383     0.200
     1.065    34.977     0.200
     1.081    36.266     0.200
     1.136    37.578     0.200
     1.207    40.094     0.200
     1.080    36.248     0.200
     1.271    42.309     0.200
     1.287    41.219     0.200
     1.295    43.779     0.200
     1.313    42.340     0.200
     1.380    44.998     0.200
     2.588    75.430     0.200
     3.068    87.818     0.200
     3.359    94.668     0.200
     3.524    97.049     0.200
     3.582    99.529     0.200
     1.154    37.562     0.200
     1.205    38.926     0.200
     1.219    39.508     0.200
     1.257    40.566     0.200
     1.297    42.188     0.200
     0.882    29.609     0.200
     1.045    33.836     0.200
     1.055    34.195     0.200
     1.110    35.766     0.200
     1.180    37.648     0.200
     1.416    45.477     0.200
     1.509    48.109     0.200
     1.072    35.123     0.200
     1.227    39.493     0.200
     1.264    40.943     0.200
     1.305    42.013     0.200
     1.372    43.843     0.200
     1.214    40.094     0.200
     1.254    40.461     0.200
     1.268    40.859     0.200
     1.308    42.039     0.200
     1.433    46.469     0.200
     1.507    48.039     0.200
     1.530    49.305     0.200
     1.533    48.430     0.200
     1.197    38.625     0.200
     1.260    40.461     0.200
     1.294    42.109     0.200
     1.343    43.547     0.200
     1.452    47.055     0.200
     1.527    49.273     0.200
     1.533    48.516     0.200
     1.535    49.211     0.200
     3.923   107.352     0.200
     4.860   129.180     0.200
     1.038    34.410     0.200
     1.116    36.219     0.200
     1.152    37.098     0.200
     1.237    40.031     0.200
     1.309    40.859     0.200
     1.346    42.938     0.200
     1.413    45.281     0.200
     1.028    34.023     0.200
     1.106    36.844     0.200
     1.141    37.664     0.200
     1.160    37.172     0.200
     1.171    37.617     0.200
     1.175    38.586     0.200
     1.245    40.406     0.200
     1.296    42.141     0.200
     1.299    41.070     0.200
     1.336    42.336     0.200
     1.331    43.570     0.200
     1.403    45.055     0.200
     0.829    28.156     0.200
     0.957    30.934     0.200
     1.008    33.344     0.200
     1.046    34.305     0.200
     1.052    33.656     0.200
     1.042    33.535     0.200
     1.122    35.766     0.200
     1.184    37.066     0.200
     1.222    39.734     0.200
     1.223    38.246     0.200
     1.231    38.625     0.200
     1.289    41.305     0.200
     1.309    41.125     0.200
     1.301    42.004     0.200
     1.319    42.324     0.200
     1.358    43.105     0.200
     1.373    43.535     0.200
     1.451    49.074     0.200
     4.110   111.637     0.200
     4.402   117.707     0.200
     5.803   150.207     0.200
     5.845   150.504     0.200
     6.040   156.906     0.200
     6.053   156.504     0.200
     6.259   160.004     0.200
     6.617   169.305     0.200
     7.280   184.707     0.200
     7.935   200.004     0.200
     7.964   201.004     0.200
    12.696   315.324     0.200
    12.696   314.191     0.200
    16.393   402.906     0.200
     0.843    28.375     0.200
     0.958    31.426     0.200
     1.050    34.684     0.200
     1.050    34.035     0.200
     1.048    33.996     0.200
     1.135    36.484     0.200
     1.182    37.285     0.200
     1.227    39.176     0.200
     1.232    39.754     0.200
     1.219    39.086     0.200
     1.292    41.426     0.200
     1.312    41.555     0.200
     1.331    42.484     0.200
     1.362    43.145     0.200
     1.382    43.555     0.200
     0.961    31.754     0.200
     1.052    35.457     0.200
     1.053    34.234     0.200
     1.052    34.594     0.200
     1.190    38.074     0.200
     1.141    37.066     0.200
     1.232    39.004     0.200
     1.219    40.273     0.200
     1.235    39.266     0.200
     1.297    41.137     0.200
     1.316    42.945     0.200
     1.336    43.707     0.200
     1.366    43.555     0.200
     1.384    44.566     0.200
     1.256    40.348     0.200
     1.362    43.430     0.200
     1.016    33.250     0.200
     1.025    33.449     0.200
     1.034    33.867     0.200
     1.118    36.570     0.200
     1.137    36.508     0.200
     1.201    39.250     0.200
     1.220    39.438     0.200
     1.281    41.289     0.200
     1.274    41.480     0.200
     1.307    42.328     0.200
     1.355    44.180     0.200
     1.423    45.527     0.200
     1.330    41.959     0.200
     1.335    43.789     0.200
     1.382    44.797     0.200
     1.248    40.270     0.200
     1.471    47.129     0.200
     1.380    43.938     0.200
     1.411    45.514     0.200
     1.623    52.732     0.200
     1.627    53.414     0.200
     1.095    35.586     0.200
     1.275    40.117     0.200
     1.296    42.129     0.200
     1.375    44.499     0.200
     1.576    50.589     0.200
     1.613    51.609     0.200
     1.642    52.529     0.200
     1.223    43.809     0.200
     2.717    78.489     0.200
     3.157    90.149     0.200
     3.789   104.009     0.200
     3.880   106.539     0.200
     4.249   115.309     0.200
     4.774   127.109     0.200
     5.034   136.219     0.200
     7.687   195.819     0.200
     9.782   246.639     0.200
    13.967   351.839     0.200
    16.871   414.432     0.200
     1.589    50.608     0.200
     1.207    39.570     0.200
     1.422    45.785     0.200
     1.591    51.184     0.200
     1.212    39.523     0.200
     1.310    42.867     0.200
     1.087    35.652     0.200
     1.234    40.254     0.200
     1.238    40.262     0.200
     1.310    41.883     0.200
     1.238    41.012     0.200
     1.234    40.863     0.200
     1.319    42.703     0.200
     1.396    45.422     0.200
     1.451    46.789     0.200
     1.601    51.633     0.200
     0.973    33.556     0.200
     1.014    33.986     0.200
     1.121    35.613     0.200
     1.218    43.914     0.200
     3.803   107.336     0.200
     1.621    52.180     0.200
     1.627    51.547     0.200
     2.943    84.188     0.200
     1.364    43.863     0.200
     1.403    44.377     0.200
     1.311    42.797     0.200
     1.608    51.914     0.200
     3.694   100.617     0.200
     3.913   108.785     0.200
     4.356   117.785     0.200
     4.789   124.727     0.200
     1.211    39.840     0.200
     2.079    60.609     0.200
     3.789   105.055     0.200
     4.249   117.023     0.200
     1.210    39.352     0.200
     1.308    42.438     0.200
     1.440    46.570     0.200
     1.456    46.961     0.200
     1.589    51.484     0.200
     1.625    52.664     0.200
     1.655    53.219     0.200
     3.802   106.320     0.200
     1.097    35.758     0.200
     1.175    37.707     0.200
     1.248    39.809     0.200
     1.289    40.867     0.200
     1.394    44.098     0.200
     1.317    43.031     0.200
     1.352    43.934     0.200
     1.393    45.613     0.200
     1.550    50.434     0.200
     1.564    50.754     0.200
     1.091    36.078     0.200
     1.199    38.949     0.200
     1.192    39.250     0.200
     1.246    40.270     0.200
     1.281    41.520     0.200
     1.346    43.277     0.200
     1.060    35.363     0.200
     1.124    36.785     0.200
     1.184    38.184     0.200
     1.188    38.336     0.200
     1.245    40.145     0.200
     1.254    40.523     0.200
     1.288    41.453     0.200
     1.295    41.543     0.200
     1.354    43.023     0.200
     3.538    98.664     0.200
     1.055    34.812     0.200
     1.093    36.016     0.200
     1.122    36.836     0.200
     1.248    40.547     0.200
     1.283    41.570     0.200
     1.349    43.383     0.200
     1.314    42.719     0.200
     1.361    44.168     0.200
     1.431    46.648     0.200
     1.480    47.949     0.200
     1.512    48.879     0.200
     1.004    32.539     0.200
     1.104    34.891     0.200
     1.207    37.625     0.200
     1.214    38.586     0.200
     1.299    40.547     0.200
     1.342    42.875     0.200
     1.374    44.875     0.200
     1.395    45.293     0.200
     1.404    45.266     0.200
     1.451    47.316     0.200
     1.504    48.945     0.200
     1.538    50.094     0.200
     1.533    49.934     0.200
     1.576    51.164     0.200
     1.589    51.484     0.200
     1.303    42.375     0.200
     1.382    44.789     0.200
     1.433    46.469     0.200
     1.450    47.008     0.200
     1.582    51.258     0.200
     1.620    52.484     0.200
     1.430    45.648     0.200
     3.795   104.961     0.200
     1.371    45.168     0.200
     1.511    48.719     0.200
     1.339    43.656     0.200
     1.366    44.305     0.200
     1.378    44.914     0.200
     1.403    45.555     0.200
     1.461    47.426     0.200
     1.500    48.938     0.200
     1.537    49.836     0.200
     1.549    50.676     0.200
     1.348    43.047     0.200
     1.458    45.367     0.200
     1.455    46.461     0.200
     1.466    46.719     0.200
     1.475    46.984     0.200
     1.498    47.250     0.200
     1.591    50.289     0.200
     1.279    41.352     0.200
     1.194    38.617     0.200
     1.316    41.992     0.200
     1.341    42.406     0.200
     1.259    40.670     0.200
     1.285    41.398     0.200
     1.481    47.010     0.200
     0.819    27.836     0.200
     0.995    32.828     0.200
     1.139    35.746     0.200
     1.172    37.656     0.200
     1.202    37.277     0.200
     1.257    40.328     0.200
     1.330    40.816     0.200
     1.342    41.836     0.200
     1.066    34.876     0.200
     1.133    36.836     0.200
     1.151    37.596     0.200
     1.202    38.706     0.200
     1.393    45.386     0.200
     1.393    45.296     0.200
     1.484    47.756     0.200
     1.202    39.039     0.200
     1.299    42.367     0.200
     1.377    44.758     0.200
     1.432    46.469     0.200
     1.447    46.805     0.200
     1.582    50.875     0.200
     1.616    52.094     0.200
     1.223    39.297     0.200
     1.446    46.023     0.200
     1.544    48.289     0.200
     1.574    50.008     0.200
     1.567    49.922     0.200
     1.586    50.383     0.200
     1.381    44.398     0.200
     1.134    36.977     0.200
     1.131    36.930     0.200
     1.249    40.680     0.200
     1.262    40.766     0.200
     1.276    41.305     0.200
     1.307    42.297     0.200
     1.316    42.477     0.200
     1.310    42.711     0.200
     1.374    44.359     0.200
     1.386    44.719     0.200
     1.443    46.328     0.200
     1.262    41.016     0.200
     1.249    41.070     0.200
     1.276    41.500     0.200
     1.307    42.016     0.200
     1.316    42.734     0.200
     1.386    44.570     0.200
     1.443    46.195     0.200
     1.303    42.820     0.200
     3.058    86.430     0.200
     3.481    97.305     0.200
     3.498    97.219     0.200
     1.078    35.422     0.200
     1.199    38.953     0.200
     1.265    40.562     0.200
     1.255    41.070     0.200
     1.274    40.820     0.200
     1.318    42.594     0.200
     1.323    42.172     0.200
     1.328    42.992     0.200
     1.387    44.383     0.200
     1.101    35.867     0.200
     1.111    36.117     0.200
     1.279    41.195     0.200
     1.388    44.797     0.200
     1.406    44.898     0.200
     1.205    38.594     0.200
     1.170    38.078     0.200
     1.212    39.408     0.200
     1.308    42.029     0.200
     1.339    43.178     0.200
     1.385    44.559     0.200
     1.498    47.719     0.200
     1.584    50.529     0.200
     1.283    41.379     0.200
     1.304    41.797     0.200
     1.304    41.996     0.200
     1.536    48.828     0.200
     1.282    41.742     0.200
     1.595    50.773     0.200
     1.216    39.461     0.200
     1.037    33.688     0.200
     1.134    36.836     0.200
     1.169    37.246     0.200
     1.214    39.738     0.200
     1.227    38.898     0.200
     1.275    40.906     0.200
     1.296    40.746     0.200
     1.299    41.668     0.200
     1.341    42.617     0.200
     1.349    42.859     0.200
     1.459    46.727     0.200
     1.486    47.656     0.200
     1.127    36.355     0.200
     1.135    37.115     0.200
     1.163    38.275     0.200
     1.216    39.416     0.200
     1.264    41.235     0.200
     1.316    42.695     0.200
     1.348    43.266     0.200
     1.414    45.456     0.200
     1.239    39.500     0.200
     1.326    42.660     0.200
     1.342    42.949     0.200
     1.348    43.398     0.200
     1.464    46.391     0.200
     1.685    50.898     0.200
     1.527    50.148     0.200
     3.209    88.980     0.200
     3.224    90.238     0.200
     4.847   129.230     0.200
     5.036   133.531     0.200
     5.692   149.930     0.200
     6.247   163.031     0.200
     6.293   164.031     0.200
     6.486   168.531     0.200
     6.499   168.328     0.200
     6.713   173.930     0.200
     7.726   198.129     0.200
     1.188    39.625     0.200
     1.080    35.820     0.200
     1.111    36.869     0.200
     1.126    36.760     0.200
     1.193    39.230     0.200
     1.385    45.061     0.200
     1.070    35.398     0.200
     1.086    36.070     0.200
     1.110    36.609     0.200
     1.228    40.301     0.200
     1.412    45.820     0.200
     1.055    34.672     0.200
     0.920    31.555     0.200
     0.951    31.297     0.200
     1.031    33.898     0.200
     1.049    34.602     0.200
     1.112    37.102     0.200
     1.150    37.594     0.200
     1.165    38.133     0.200
     1.203    39.742     0.200
     1.216    40.016     0.200
     1.209    39.617     0.200
     1.221    40.016     0.200
     1.235    41.117     0.200
     1.238    41.062     0.200
     1.407    45.664     0.200
     1.433    45.762     0.200
     1.426    46.230     0.200
     1.441    46.621     0.200
     1.417    45.664     0.200
     1.481    46.672     0.200
     1.187    38.832     0.200
     1.260    40.953     0.200
     1.426    45.953     0.200
     1.433    46.023     0.200
     1.441    46.184     0.200
     1.481    46.812     0.200
     1.420    46.113     0.200
     2.323    66.293     0.200
     5.015   130.223     0.200
     5.833   151.953     0.200
     6.500   166.551     0.200
     1.243    40.562     0.200
     1.310    43.023     0.200
     1.350    43.844     0.200
     1.416    45.832     0.200
     1.349    43.727     0.200
     1.441    46.414     0.200
     1.460    46.555     0.200
     1.487    47.727     0.200
     1.601    51.422     0.200
     3.809   104.773     0.200
     1.177    38.156     0.200
     1.206    38.559     0.200
     1.354    43.355     0.200
     1.355    43.168     0.200
     1.431    45.605     0.200
     1.589    49.836     0.200
     1.457    46.375     0.200
     1.107    35.666     0.200
     1.122    36.416     0.200
     1.150    37.806     0.200
     1.228    39.266     0.200
     1.243    41.258     0.200
     1.296    42.133     0.200
     1.332    43.125     0.200
     1.332    43.016     0.200
     1.398    44.875     0.200
     1.287    41.883     0.200
     1.242    41.129     0.200
     1.329    43.170     0.200
     1.367    44.600     0.200
     1.378    45.699     0.200
     1.392    45.820     0.200
     1.530    50.100     0.200
     1.559    51.260     0.200
     1.593    51.770     0.200
     2.672    77.160     0.200
     2.787    79.199     0.200
     3.442    94.439     0.200
     3.743   105.869     0.200
     4.745   129.119     0.200
     1.444    47.250     0.200
     1.654    54.270     0.200
     1.089    35.625     0.200
     1.128    36.515     0.200
     1.255    40.925     0.200
     1.300    42.305     0.200
     1.327    42.745     0.200
     1.353    43.555     0.200
     1.359    43.765     0.200
     1.385    44.125     0.200
     1.422    45.955     0.200
     1.491    47.905     0.200
     1.571    50.245     0.200
     1.570    50.235     0.200
     0.811    27.000     0.200
     0.836    27.881     0.200
     0.958    31.449     0.200
     0.994    32.199     0.200
     1.014    32.770     0.200
     1.074    34.580     0.200
     1.081    34.961     0.200
     1.101    35.930     0.200
     1.127    36.961     0.200
     1.260    40.400     0.200
     1.276    40.840     0.200
     1.296    40.980     0.200
     1.316    41.650     0.200
     1.330    42.041     0.200
     1.346    42.949     0.200
     1.385    43.580     0.200
     1.416    45.279     0.200
     1.518    48.729     0.200
     0.918    30.531     0.200
     0.964    31.766     0.200
     1.027    33.531     0.200
     1.039    34.016     0.200
     1.214    39.086     0.200
     1.267    41.172     0.200
     1.293    41.664     0.200
     1.336    43.188     0.200
     1.371    44.047     0.200
     1.133    36.953     0.200
     1.400    45.266     0.200
     1.503    48.625     0.200
     1.339    43.773     0.200
     1.366    44.453     0.200
     1.368    44.812     0.200
     1.501    48.492     0.200
     1.519    48.805     0.200
     1.515    50.102     0.200
     1.544    50.266     0.200
     1.637    52.641     0.200
     1.684    54.180     0.200
     1.734    55.250     0.200
     0.808    26.391     0.200
     1.038    33.570     0.200
     1.078    34.266     0.200
     1.108    34.156     0.200
     1.139    35.328     0.200
     1.282    39.500     0.200
     1.561    49.609     0.200
     1.598    50.133     0.200
     1.606    51.164     0.200
     1.237    39.637     0.200
     1.265    40.516     0.200
     1.365    43.668     0.200
     1.367    43.516     0.200
     1.491    47.297     0.200
     1.581    50.086     0.200
     1.219    39.477     0.200
     1.230    40.125     0.200
     1.297    41.680     0.200
     1.309    41.984     0.200
     1.308    42.336     0.200
     1.452    46.508     0.200
     1.455    46.648     0.200
     1.477    47.156     0.200
     1.504    48.312     0.200
     1.056    34.622     0.200
     1.236    40.022     0.200
     1.308    42.092     0.200
     1.313    42.662     0.200
     1.317    42.422     0.200
     1.461    47.492     0.200
     1.462    46.322     0.200
     1.128    36.953     0.200
     1.130    36.844     0.200
     1.217    39.484     0.200
     1.273    41.469     0.200
     1.322    42.328     0.200
     1.422    45.203     0.200
     0.988    32.633     0.200
     1.075    35.945     0.200
     1.247    41.555     0.200
     1.076    35.891     0.200
     1.278    41.090     0.200
     1.288    40.680     0.200
     1.358    43.453     0.200
     1.379    43.422     0.200
     1.455    46.500     0.200
     1.109    36.828     0.200
     1.406    45.699     0.200
     1.363    44.086     0.200
     1.434    46.156     0.200
     1.554    49.367     0.200
     1.239    40.000     0.200
     1.395    45.703     0.200
     1.489    48.344     0.200
     1.115    36.576     0.200
     1.271    42.219     0.200
     1.319    42.336     0.200
     1.382    44.766     0.200
     1.276    41.492     0.200
     1.339    43.797     0.200
     1.386    45.523     0.200
     1.448    46.594     0.200
     1.517    49.438     0.200
     1.184    39.424     0.200
     1.380    43.484     0.200
     1.411    45.244     0.200
     1.471    47.034     0.200
     1.407    44.414     0.200
     0.889    29.527     0.200
     0.893    29.809     0.200
     0.895    29.840     0.200
     0.971    32.879     0.200
     1.009    33.219     0.200
     1.018    33.938     0.200
     1.094    35.559     0.200
     1.113    36.219     0.200
     1.155    37.500     0.200
     1.157    38.379     0.200
     1.213    40.457     0.200
     1.239    40.238     0.200
     1.283    41.758     0.200
     1.345    43.629     0.200
     1.354    44.258     0.200
     1.147    36.723     0.200
     1.359    43.422     0.200
     1.281    41.801     0.200
     1.301    43.152     0.200
     1.574    50.546     0.200
     1.018    36.859     0.200
     1.289    42.203     0.200
     1.324    43.281     0.200
     1.390    44.742     0.200
     1.417    46.031     0.200
     0.850    28.445     0.200
     0.959    31.547     0.200
     0.986    32.477     0.200
     1.012    32.305     0.200
     1.014    32.594     0.200
     1.029    33.266     0.200
     1.064    35.375     0.200
     1.081    34.984     0.200
     1.150    37.102     0.200
     1.187    37.938     0.200
     1.308    42.227     0.200
     1.422    46.328     0.200
     1.215    40.191     0.200
     1.233    40.902     0.200
     1.294    43.172     0.200
     1.311    43.305     0.200
     1.311    43.172     0.200
     1.451    48.004     0.200
     1.458    48.191     0.200
     1.501    49.352     0.200
     1.588    51.062     0.200
     1.630    53.211     0.200
     1.263    40.906     0.200
     1.263    41.586     0.200
     1.339    42.695     0.200
     1.340    42.766     0.200
     1.492    47.703     0.200
     1.488    47.602     0.200
     1.520    48.016     0.200
     1.547    49.531     0.200
     1.630    51.562     0.200
     1.237    39.492     0.200
     1.270    40.433     0.200
     1.266    41.412     0.200
     1.342    42.382     0.200
     1.345    42.902     0.200
     1.349    42.763     0.200
     1.490    47.272     0.200
     1.553    48.672     0.200
     1.142    37.330     0.200
     1.160    37.430     0.200
     1.219    40.030     0.200
     1.224    39.020     0.200
     1.375    44.050     0.200
     1.439    45.670     0.200
     1.513    47.630     0.200
     1.546    48.850     0.200
     1.033    34.006     0.200
     1.034    34.596     0.200
     1.110    36.426     0.200
     1.139    36.746     0.200
     1.150    37.615     0.200
     1.229    39.225     0.200
     1.254    39.885     0.200
     1.284    41.436     0.200
     1.304    41.326     0.200
     1.337    42.756     0.200
     1.344    43.576     0.200
     1.403    44.846     0.200
     1.228    39.793     0.200
     1.410    45.324     0.200
     1.459    47.391     0.200
     1.506    48.551     0.200
     1.561    50.254     0.200
     1.624    51.824     0.200
     1.089    35.453     0.200
     1.175    38.074     0.200
     1.185    37.984     0.200
     1.239    39.734     0.200
     1.262    41.473     0.200
     1.282    40.824     0.200
     1.320    42.305     0.200
     1.386    44.824     0.200
     1.170    37.621     0.200
     1.249    39.898     0.200
     1.255    40.277     0.200
     1.291    40.840     0.200
     1.329    42.348     0.200
     1.395    43.629     0.200
     1.045    34.449     0.200
     1.518    48.258     0.200
     1.000    33.547     0.200
     1.069    35.066     0.200
     1.120    36.758     0.200
     1.268    40.637     0.200
     1.486    47.949     0.200
     0.984    33.111     0.200
     1.229    38.951     0.200
     1.288    41.701     0.200
     1.305    42.932     0.200
     1.357    43.822     0.200
     1.016    33.375     0.200
     1.087    36.043     0.200
     1.155    37.773     0.200
     1.019    33.145     0.200
     1.163    36.766     0.200
     1.168    37.664     0.200
     1.228    39.453     0.200
     1.297    41.445     0.200
     1.351    43.754     0.200
     1.429    45.516     0.200
     0.976    32.648     0.200
     0.999    33.465     0.200
     1.163    37.828     0.200
     1.163    37.023     0.200
     1.171    37.750     0.200
     1.229    39.258     0.200
     0.984    31.861     0.200
     1.018    33.322     0.200
     1.164    36.881     0.200
     1.169    37.551     0.200
     1.211    37.752     0.200
     1.228    39.172     0.200
     1.263    40.211     0.200
     1.426    45.742     0.200
     1.503    47.805     0.200
     1.533    48.320     0.200
     1.389    44.646     0.200
     1.474    47.336     0.200
     1.471    47.125     0.200
     1.509    47.986     0.200
     1.531    48.715     0.200
     1.558    49.736     0.200
     1.652    52.977     0.200
     1.307    45.406     0.200
     3.698   101.396     0.200
     3.698   102.396     0.200
     4.545   122.096     0.200
     5.097   136.295     0.200
     5.097   135.496     0.200
     5.148   136.396     0.200
     5.148   135.996     0.200
     5.338   141.695     0.200
     5.338   141.896     0.200
     5.578   148.396     0.200
     5.578   145.195     0.200
     6.578   170.195     0.200
     7.241   187.195     0.200
     7.241   185.496     0.200
     7.291   187.295     0.200
     7.291   186.096     0.200
     1.103    35.617     0.200
     1.353    42.852     0.200
     1.392    45.130     0.200
     1.560    50.160     0.200
     0.882    29.289     0.200
     0.945    31.027     0.200
     1.018    33.340     0.200
     1.067    34.449     0.200
     1.171    38.340     0.200
     1.223    39.180     0.200
     1.472    47.559     0.200
     1.499    48.027     0.200
     1.374    44.523     0.200
     2.637    73.789     0.200
     3.229    88.969     0.200
     5.010   132.469     0.200
     5.204   138.570     0.200
     5.258   136.203     0.200
     5.854   152.469     0.200
     6.190   157.031     0.200
     6.410   165.273     0.200
     6.455   165.273     0.200
     6.649   171.570     0.200
     6.871   175.773     0.200
     7.889   200.469     0.200
     8.272   206.695     0.200
     8.577   215.375     0.200
     0.809    28.312     0.200
     0.919    31.623     0.200
     0.995    35.822     0.200
     1.182    37.502     0.200
     1.179    41.072     0.200
     2.084    59.312     0.200
     2.155    59.803     0.200
     2.261    62.582     0.200
     2.274    61.592     0.200
     2.325    65.322     0.200
     2.799    75.053     0.200
     4.835   123.861     0.200
     5.065   131.982     0.200
     5.576   143.842     0.200
     5.728   147.342     0.200
     6.423   162.842     0.200
     6.971   177.543     0.200
     7.028   176.941     0.200
     7.214   182.043     0.200
     7.227   182.643     0.200
     7.461   186.941     0.200
     7.814   196.043     0.200
     8.453   211.342     0.200
     1.140    36.967     0.200
     1.169    38.086     0.200
     1.183    38.896     0.200
     1.201    39.176     0.200
     1.567    50.309     0.200
     0.914    31.141     0.200
     1.059    35.297     0.200
     1.173    38.383     0.200
     1.205    39.469     0.200
     1.243    40.391     0.200
     1.264    41.477     0.200
     1.398    46.031     0.200
     1.406    45.383     0.200
     1.481    48.641     0.200
     0.961    31.490     0.200
     0.986    32.580     0.200
     1.001    32.630     0.200
     1.050    34.570     0.200
     1.085    35.290     0.200
     1.120    36.750     0.200
     1.177    38.800     0.200
     1.186    38.900     0.200
     1.264    41.120     0.200
     1.278    41.260     0.200
     1.316    42.950     0.200
     1.382    44.320     0.200
     1.361    41.960     0.200
     1.339    41.330     0.200
     2.698    76.680     0.200
     4.060   107.410     0.200
     4.690   123.310     0.200
     5.030   130.780     0.200
     5.341   137.010     0.200
     6.719   170.410     0.200
     7.375   186.910     0.200
     7.385   185.370     0.200
     8.034   201.210     0.200
     8.070   201.310     0.200
     9.150   231.510     0.200
    12.710   317.329     0.200
    12.710   314.290     0.200
    12.826   317.803     0.200
    13.557   332.335     0.200
    16.464   401.910     0.200
     1.175    37.914     0.200
     1.232    39.504     0.200
     1.313    42.695     0.200
     1.379    44.305     0.200
     1.297    41.840     0.200
     1.078    35.363     0.200
     1.308    42.312     0.200
     1.531    49.453     0.200
     1.080    35.258     0.200
     1.228    39.797     0.200
     1.265    41.180     0.200
     1.273    41.164     0.200
     1.309    42.062     0.200
     1.375    44.367     0.200
     1.264    40.219     0.200
     1.355    42.969     0.200
     3.059    87.016     0.200
     0.987    32.156     0.200
     1.171    37.195     0.200
     1.214    39.525     0.200
     1.271    40.109     0.200
     1.322    41.000     0.200
     1.355    42.480     0.200
     1.535    49.430     0.200
     1.326    43.520     0.200
     1.368    43.379     0.200
     1.348    43.680     0.200
     1.465    47.473     0.200
     1.610    51.652     0.200
     1.528    50.082     0.200
     3.215    88.250     0.200
     1.242    40.791     0.200
     1.219    39.707     0.200
     1.261    41.328     0.200
     1.267    41.598     0.200
     1.598    54.445     0.200
     1.349    43.182     0.200
     1.382    45.172     0.200
     1.303    41.898     0.200
     1.389    45.828     0.200
     1.407    45.102     0.200
     1.412    46.188     0.200
     1.529    49.477     0.200
     1.570    50.109     0.200
     1.598    50.195     0.200
     1.466    47.250     0.200
     2.648    74.547     0.200
     3.211    87.852     0.200
     1.308    42.031     0.200
     1.392    44.680     0.200
     1.411    45.195     0.200
     1.416    45.586     0.200
     1.533    49.547     0.200
     1.602    50.594     0.200
     3.786   105.172     0.200
     4.474   120.227     0.200
     4.914   131.023     0.200
     5.104   136.023     0.200
     5.758   149.023     0.200
     6.314   163.625     0.200
     6.360   163.820     0.200
     6.553   169.422     0.200
     6.565   169.625     0.200
     6.778   173.125     0.200
     7.135   183.422     0.200
     7.793   198.227     0.200
     8.451   214.023     0.200
     8.485   214.125     0.200
    12.430   309.039     0.200
    12.649   313.641     0.200
     1.053    34.703     0.200
     1.250    41.125     0.200
     1.255    40.984     0.200
     1.294    41.438     0.200
     1.327    42.297     0.200
     1.472    46.352     0.200
     1.585    50.766     0.200
     1.281    41.645     0.200
     1.293    41.875     0.200
     1.360    43.484     0.200
     1.370    43.904     0.200
     1.374    43.965     0.200
     1.406    45.096     0.200
     1.517    48.295     0.200
     1.541    48.645     0.200
     1.567    50.555     0.200
     1.229    39.545     0.200
     1.545    50.617     0.200
     2.634    76.094     0.200
     3.027    85.188     0.200
     2.972    85.102     0.200
     3.085    86.109     0.200
     3.392    95.398     0.200
     3.598   100.398     0.200
     3.844   104.492     0.200
     4.070   111.328     0.200
     4.237   116.203     0.200
     4.792   128.398     0.200
     4.839   129.297     0.200
     5.032   134.898     0.200
     5.044   134.297     0.200
     5.006   136.328     0.200
     6.125   157.859     0.200
     7.203   180.531     0.200
     7.723   195.102     0.200
     7.986   198.281     0.200
     7.986   201.523     0.200
     8.420   218.672     0.200
    10.829   269.094     0.200
    11.049   272.680     0.200
    13.816   337.680     0.200
     0.896    32.816     0.200
     1.240    40.945     0.200
     1.227    43.293     0.200
     1.451    48.324     0.200
     2.317    66.613     0.200
     2.582    73.703     0.200
     2.606    74.023     0.200
     3.378    94.445     0.200
     4.979   131.266     0.200
     6.938   178.555     0.200
     8.469   215.566     0.200
    12.048   299.207     0.200
    12.048   302.066     0.200
    16.152   394.414     0.200
     2.893    77.547     0.200
     2.890    80.367     0.200
     3.006    84.508     0.200
     3.016    83.637     0.200
     3.073    85.316     0.200
     3.174    86.258     0.200
     3.174    86.477     0.200
     3.314    91.227     0.200
     3.407    92.357     0.200
     3.521    93.947     0.200
     3.828   101.977     0.200
     4.171   108.646     0.200
     4.330   116.078     0.200
     4.697   121.328     0.200
     4.724   121.848     0.200
     4.666   123.697     0.200
     4.774   126.236     0.200
     4.774   123.547     0.200
     4.740   123.457     0.200
     4.965   128.348     0.200
     4.977   127.547     0.200
     5.203   132.547     0.200
     5.556   141.348     0.200
     5.881   148.627     0.200
     6.099   155.957     0.200
     6.099   156.807     0.200
     6.867   172.646     0.200
     6.915   173.646     0.200
     7.668   191.896     0.200
     7.960   198.158     0.200
     7.949   198.986     0.200
     9.637   237.957     0.200
     9.637   239.787     0.200
    10.054   253.848     0.200
    10.735   263.637     0.200
    11.056   272.217     0.200
    12.968   320.348     0.200
    13.578   337.891     0.200
    13.578   334.002     0.200
    15.075   374.447     0.200
    16.947   416.623     0.200
     1.166    42.184     0.200
     1.446    50.504     0.200
     1.470    52.562     0.200
     1.651    54.143     0.200
     1.627    54.184     0.200
     2.495    74.014     0.200
     2.574    75.223     0.200
     1.489    46.047     0.200
     2.661    72.857     0.200
     2.951    81.479     0.200
     2.833    79.598     0.200
     3.000    81.818     0.200
     3.247    90.297     0.200
     3.276    89.527     0.200
     3.774    99.328     0.200
     4.001   109.688     0.200
     4.223   111.598     0.200
     4.440   117.988     0.200
     4.519   119.467     0.200
     7.232   181.578     0.200
     1.408    44.148     0.200
     2.585    68.879     0.200
     3.813   105.141     0.200
     5.066   128.578     0.200
     7.246   180.578     0.200
     7.871   198.398     0.200
     8.055   204.367     0.200
    10.143   251.699     0.200
     1.220    42.874     0.200
     1.501    51.145     0.200
     1.901    54.755     0.200
     2.423    70.055     0.200
     2.434    67.564     0.200
     2.600    73.864     0.200
     3.155    89.345     0.200
     3.622    99.904     0.200
     5.330   141.704     0.200
     6.002   157.265     0.200
     6.604   171.864     0.200
     7.556   190.975     0.200
     8.707   223.864     0.200
    12.282   304.333     0.200
    12.565   312.649     0.200
    13.873   342.934     0.200
    16.243   400.134     0.200
    16.271   398.357     0.200
     3.022    85.497     0.200
     3.022    84.796     0.200
     3.431    94.767     0.200
     3.464    95.596     0.200
     3.464    95.197     0.200
     3.651   101.497     0.200
     3.651    99.997     0.200
     4.311   114.697     0.200
     4.311   115.497     0.200
     4.863   128.997     0.200
     4.914   129.156     0.200
     4.914   129.296     0.200
     4.914   128.997     0.200
     5.104   134.197     0.200
     5.104   133.697     0.200
     5.117   134.197     0.200
     5.345   140.596     0.200
     5.345   138.096     0.200
     7.008   180.096     0.200
     7.008   179.596     0.200
     7.059   181.197     0.200
     7.059   177.296     0.200
    11.014   274.717     0.200
     1.431    46.786     0.200
     2.844    82.347     0.200
     3.090    87.927     0.200
     3.523    98.427     0.200
     3.718   104.026     0.200
     4.026   111.337     0.200
     4.369   118.927     0.200
     4.541   122.276     0.200
     4.923   133.427     0.200
     5.163   137.326     0.200
     5.399   144.326     0.200
     7.110   184.627     0.200
     7.159   179.177     0.200
     7.992   203.566     0.200
     1.446    42.671     0.200
     2.488    68.111     0.200
     4.151   109.241     0.200
     4.781   123.941     0.200
     5.433   139.441     0.200
     5.988   154.642     0.200
     6.034   154.041     0.200
     6.227   159.541     0.200
     6.454   164.941     0.200
     6.811   173.541     0.200
     8.162   204.642     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.128    63.350     0.200
     2.799    85.088     0.200
     1.183    36.689     0.200
     2.669    79.689     0.200
     1.993    60.570     0.200
     3.645   108.469     0.200
     2.311    67.965     0.200
     0.777    24.164     0.200
     2.533    76.465     0.200
     1.819    55.328     0.200
     2.843    85.027     0.200
     1.337    41.379     0.200
     2.478    77.179     0.200
     2.503    72.047     0.200
     2.475    72.359     0.200
     3.814   112.469     0.200
     5.110   149.172     0.200
     2.530    75.766     0.200
     2.536    77.566     0.200
     1.027    33.068     0.200
     1.252    38.868     0.200
     1.477    45.352     0.200
     2.144    63.109     0.200
     2.940    88.609     0.200
     2.940    88.312     0.200
     3.866   111.109     0.200
     2.135    66.727     0.200
     2.474    75.227     0.200
     0.770    25.467     0.200
     5.627   163.867     0.200
     0.738    23.848     0.200
     2.068    63.148     0.200
     2.475    72.248     0.200
     0.704    21.848     0.200
     2.042    63.348     0.200
     2.445    73.848     0.200
     0.534    17.312     0.200
     2.276    69.312     0.200
     0.934    29.637     0.200
     2.533    74.836     0.200
     2.906    88.336     0.200
     1.103    35.000     0.200
     1.670    52.000     0.200
     2.623    78.000     0.200
     2.606    79.199     0.200
     3.025    92.000     0.200
     2.593    77.344     0.200
     3.013    91.242     0.200
     3.435   102.742     0.200
     0.830    25.402     0.200
     2.019    62.094     0.200
     1.006    32.375     0.200
     1.136    35.945     0.200
     2.490    73.445     0.200
     2.529    76.000     0.200
     1.026    32.461     0.200
     2.016    64.461     0.200
     2.491    73.758     0.200
     2.533    74.961     0.200
     1.095    34.133     0.200
     1.228    38.633     0.200
     2.532    74.133     0.200
     2.599    78.133     0.200
     2.729    82.133     0.200
     2.953    88.531     0.200
     3.445   100.633     0.200
     1.149    36.047     0.200
     2.048    64.547     0.200
     2.609    78.547     0.200
     2.049    64.547     0.200
     1.020    32.172     0.200
     1.188    37.562     0.200
     2.037    63.766     0.200
     2.540    75.367     0.200
     2.582    77.766     0.200
     2.715    80.266     0.200
     2.848    86.766     0.200
     5.750   167.766     0.200
     2.045    63.703     0.200
     2.857    84.203     0.200
     3.339   101.703     0.200
     2.045    63.703     0.200
     2.620    77.656     0.200
     2.999    88.156     0.200
     1.024    33.219     0.200
     2.015    61.766     0.200
     2.945    88.766     0.200
     2.016    61.766     0.200
     1.006    32.984     0.200
     1.167    36.874     0.200
     1.156    34.874     0.200
     2.042    61.874     0.200
     2.559    76.374     0.200
     2.692    81.874     0.200
     2.745    82.874     0.200
     2.979    90.074     0.200
     5.727   168.874     0.200
     1.118    36.074     0.200
     2.043    61.874     0.200
     1.226    38.549     0.200
     2.091    64.549     0.200
     2.384    74.248     0.200
     2.701    80.549     0.200
     2.827    83.949     0.200
     3.055    90.549     0.200
     1.122    35.555     0.200
     1.187    37.855     0.200
     2.561    76.355     0.200
     2.388    73.955     0.200
     2.694    81.855     0.200
     3.180    93.355     0.200
     1.034    31.014     0.200
     1.988    63.174     0.200
     2.436    75.174     0.200
     2.503    74.174     0.200
     2.630    79.174     0.200
     2.856    85.174     0.200
     2.640    79.971     0.200
     3.056    88.971     0.200
     2.928    88.670     0.200
     3.184    97.121     0.200
     1.036    31.754     0.200
     1.187    37.223     0.200
     2.482    74.324     0.200
     2.658    81.023     0.200
     2.945    88.523     0.200
     3.102    91.023     0.200
     1.864    59.512     0.200
     1.037    31.812     0.200
     1.148    36.180     0.200
     2.484    73.281     0.200
     2.612    76.281     0.200
     2.679    80.281     0.200
     2.741    80.281     0.200
     3.130    91.281     0.200
     1.068    34.367     0.200
     0.995    31.695     0.200
     2.595    77.516     0.200
     2.663    80.016     0.200
     2.727    80.516     0.200
     2.986    88.914     0.200
     1.114    35.414     0.200
     2.983    90.516     0.200
     3.012    88.914     0.200
     0.198     6.602     0.200
     1.107    34.500     0.200
     2.547    76.242     0.200
     1.153    36.102     0.200
     1.007    31.727     0.200
     1.098    35.250     0.200
     2.064    63.859     0.200
     2.756    82.859     0.200
     1.146    35.865     0.200
     1.192    38.676     0.200
     1.248    39.875     0.200
     1.169    38.176     0.200
     2.011    62.676     0.200
     2.759    83.676     0.200
     1.879    60.246     0.200
     2.012    62.676     0.200
     1.047    33.180     0.200
     1.093    35.270     0.200
     1.194    38.066     0.200
     2.652    81.066     0.200
     2.719    82.168     0.200
     2.079    64.668     0.200
     2.379    73.566     0.200
     2.586    76.668     0.200
     2.781    81.906     0.200
     2.780    82.668     0.200
     2.973    88.668     0.200
     3.646   109.469     0.200
     1.003    30.484     0.200
     1.001    31.137     0.200
     1.118    35.105     0.200
     2.028    62.406     0.200
     2.917    88.406     0.200
     1.024    31.219     0.200
     1.066    33.398     0.200
     1.147    35.148     0.200
     2.027    64.250     0.200
     2.694    80.250     0.200
     2.952    90.250     0.200
     0.276     7.953     0.200
     1.089    32.123     0.200
     1.985    62.463     0.200
     2.607    79.463     0.200
     2.741    82.463     0.200
     3.029    91.263     0.200
     0.573    17.645     0.200
     0.869    27.344     0.200
     0.976    31.344     0.200
     1.114    35.123     0.200
     1.211    38.395     0.200
     2.043    64.094     0.200
     2.576    77.293     0.200
     2.621    78.594     0.200
     2.754    84.094     0.200
     2.816    85.895     0.200
     3.041    91.895     0.200
     1.154    36.494     0.200
     2.043    64.094     0.200
     0.086     4.742     0.200
     0.241     6.492     0.200
     0.292     9.523     0.200
     0.324    10.438     0.200
     1.002    32.344     0.200
     1.070    33.703     0.200
     1.120    36.141     0.200
     1.173    37.141     0.200
     2.056    64.141     0.200
     2.590    78.141     0.200
     0.042     4.500     0.200
     0.216     7.359     0.200
     0.221     8.250     0.200
     0.292     9.297     0.200
     0.828    27.250     0.200
     1.023    31.516     0.200
     1.149    35.750     0.200
     2.028    61.953     0.200
     2.563    74.453     0.200
     2.858    83.555     0.200
     2.028    61.953     0.200
     2.633    80.352     0.200
     0.056     4.336     0.200
     0.063     5.039     0.200
     0.223     7.734     0.200
     0.219     7.414     0.200
     0.219     7.594     0.200
     0.292     9.336     0.200
     1.025    31.773     0.200
     2.027    62.836     0.200
     2.565    74.836     0.200
     2.729    80.836     0.200
     2.028    62.836     0.200
     2.956    89.234     0.200
     0.049     4.266     0.200
     0.065     3.367     0.200
     0.048     4.891     0.200
     0.070     4.844     0.200
     0.213     7.219     0.200
     0.217     7.727     0.200
     0.286     9.211     0.200
     0.816    26.117     0.200
     2.692    81.617     0.200
     0.058     2.969     0.200
     0.126     5.609     0.200
     0.249     8.336     0.200
     0.249     7.266     0.200
     0.366    11.555     0.200
     0.894    28.383     0.200
     1.060    33.289     0.200
     1.114    35.383     0.200
     2.111    66.086     0.200
     2.411    74.586     0.200
     0.077     4.883     0.200
     0.050     4.625     0.200
     0.088     4.055     0.200
     0.187     7.934     0.200
     0.230     8.133     0.200
     0.234     8.254     0.200
     0.852    27.555     0.200
     1.001    32.543     0.200
     1.173    35.855     0.200
     1.169    36.754     0.200
     2.877    85.055     0.200
     2.053    63.055     0.200
     2.579    77.055     0.200
     0.048     4.652     0.200
     0.055     4.055     0.200
     0.215     7.793     0.200
     0.216     8.121     0.200
     0.207     8.332     0.200
     0.816    26.293     0.200
     1.040    30.941     0.200
     1.078    33.602     0.200
     1.154    34.793     0.200
     1.136    35.895     0.200
     2.560    75.191     0.200
     2.694    79.793     0.200
     2.852    82.793     0.200
     2.755    81.293     0.200
     2.012    62.793     0.200
     5.729   165.793     0.200
     0.049     4.688     0.200
     0.082     5.059     0.200
     0.184     8.137     0.200
     0.236     8.566     0.200
     0.232     8.156     0.200
     0.292     9.258     0.200
     0.294     9.789     0.200
     0.577    18.258     0.200
     0.857    27.008     0.200
     0.995    32.348     0.200
     2.714    81.508     0.200
     0.088     4.848     0.200
     0.009     3.828     0.200
     0.037     4.629     0.200
     0.246     8.758     0.200
     0.243     8.160     0.200
     0.294     9.660     0.200
     0.301     9.699     0.200
     0.300     9.699     0.200
     0.862    27.551     0.200
     0.051     4.094     0.200
     0.063     4.406     0.200
     0.076     4.797     0.200
     0.221     7.297     0.200
     0.226     7.594     0.200
     0.248     8.797     0.200
     0.262     8.695     0.200
     0.522    16.195     0.200
     0.811    26.195     0.200
     0.802    26.445     0.200
     1.052    31.664     0.200
     1.089    34.352     0.200
     2.562    76.695     0.200
     2.758    83.492     0.200
     2.925    85.695     0.200
     0.023     4.648     0.200
     0.041     5.078     0.200
     0.255     8.055     0.200
     0.257     8.781     0.200
     0.319     9.961     0.200
     0.605    18.812     0.200
     0.885    28.211     0.200
     1.096    33.008     0.200
     0.999    32.062     0.200
     0.037     4.406     0.200
     0.060     4.719     0.200
     0.082     5.281     0.200
     0.207     7.211     0.200
     0.202     7.141     0.200
     0.251     7.609     0.200
     0.218     8.812     0.200
     0.530    16.609     0.200
     0.810    26.359     0.200
     0.804    25.859     0.200
     1.033    30.180     0.200
     1.063    32.219     0.200
     2.681    81.109     0.200
     2.742    81.109     0.200
     0.048     4.398     0.200
     0.050     3.859     0.200
     0.070     4.891     0.200
     0.220     7.438     0.200
     0.206     8.695     0.200
     0.254     8.656     0.200
     0.264     8.797     0.200
     0.820    27.398     0.200
     0.074     4.387     0.200
     0.023     3.809     0.200
     0.050     4.156     0.200
     0.229     6.867     0.200
     0.187     7.289     0.200
     0.290     9.598     0.200
     0.568    17.699     0.200
     0.688    20.699     0.200
     0.849    26.348     0.200
     1.172    37.098     0.200
     2.578    76.098     0.200
     0.044     4.523     0.200
     0.104     5.352     0.200
     0.052     3.398     0.200
     0.074     5.094     0.200
     0.208     6.391     0.200
     0.213     7.430     0.200
     0.259     8.570     0.200
     0.211     8.641     0.200
     0.259     8.570     0.200
     0.813    26.820     0.200
     0.819    27.023     0.200
     1.027    31.633     0.200
     0.130     5.133     0.200
     0.158     5.812     0.200
     0.107     5.078     0.200
     0.185     5.930     0.200
     0.185     6.203     0.200
     0.174     6.492     0.200
     0.177     6.938     0.200
     0.235     7.969     0.200
     0.286    10.070     0.200
     0.417    13.008     0.200
     0.707    24.211     0.200
     0.138     5.141     0.200
     0.096     5.016     0.200
     0.114     4.438     0.200
     0.161     5.641     0.200
     0.187     6.031     0.200
     0.163     6.156     0.200
     0.170     6.531     0.200
     0.217     6.688     0.200
     0.283    10.117     0.200
     0.424    13.188     0.200
     0.567    19.188     0.200
     0.712    24.188     0.200
     0.137     6.516     0.200
     0.196     6.820     0.200
     0.137     6.320     0.200
     0.241     8.820     0.200
     0.268     8.617     0.200
     0.268     9.016     0.200
     0.214     8.414     0.200
     0.293     8.844     0.200
     0.304    10.367     0.200
     0.301     9.914     0.200
     0.317    11.617     0.200
     0.480    15.164     0.200
     0.644    21.219     0.200
     0.781    26.664     0.200
     0.051     4.176     0.200
     0.111     5.055     0.200
     0.047     4.066     0.200
     0.191     6.195     0.200
     0.220     7.496     0.200
     0.265     8.195     0.200
     0.204     8.105     0.200
     0.287     9.176     0.200
     0.662    22.195     0.200
     0.817    27.945     0.200
     1.028    31.637     0.200
     1.069    34.434     0.200
     0.097     5.000     0.200
     0.137     5.109     0.200
     0.172     6.719     0.200
     0.216     6.391     0.200
     0.225     7.020     0.200
     0.284    10.090     0.200
     1.251    39.180     0.200
     1.901    59.180     0.200
     2.513    76.180     0.200
     0.046     4.250     0.200
     0.103     5.148     0.200
     0.050     5.047     0.200
     0.208     6.250     0.200
     0.213     7.867     0.200
     0.258     8.445     0.200
     0.210     8.297     0.200
     0.540    17.148     0.200
     0.659    20.898     0.200
     0.815    26.750     0.200
     0.820    26.648     0.200
     0.934    30.648     0.200
     0.060     3.619     0.200
     0.084     5.439     0.200
     0.127     5.939     0.200
     0.202     8.398     0.200
     0.231     7.818     0.200
     0.655    20.369     0.200
     1.051    31.449     0.200
     0.034     4.199     0.200
     0.033     4.250     0.200
     0.039     4.699     0.200
     0.092     5.109     0.200
     0.099     5.297     0.200
     0.063     4.750     0.200
     0.200     7.059     0.200
     0.246     8.598     0.200
     0.249     8.398     0.200
     0.221     8.797     0.200
     0.647    20.648     0.200
     1.035    31.520     0.200
     0.019     3.742     0.200
     0.090     4.672     0.200
     0.148     5.230     0.200
     0.153     6.082     0.200
     0.137     5.289     0.200
     0.153     4.730     0.200
     0.163     5.762     0.200
     0.203     6.891     0.200
     0.204     6.730     0.200
     0.213     7.020     0.200
     0.291    10.191     0.200
     0.422    12.930     0.200
     1.283    40.230     0.200
     2.502    75.230     0.200
     2.636    78.730     0.200
     2.901    88.332     0.200
     0.020     3.516     0.200
     0.080     3.844     0.200
     0.086     4.543     0.200
     0.139     5.254     0.200
     0.150     5.824     0.200
     0.146     5.094     0.200
     0.163     5.625     0.200
     0.199     6.113     0.200
     0.269     8.695     0.200
     0.292    10.406     0.200
     0.422    12.844     0.200
     0.822    26.645     0.200
     0.057     4.396     0.200
     0.055     3.865     0.200
     0.057     3.765     0.200
     0.127     5.345     0.200
     0.201     6.215     0.200
     0.232     7.505     0.200
     0.200     7.195     0.200
     0.280     9.085     0.200
     0.818    25.715     0.200
     0.061     3.633     0.200
     0.035     3.332     0.200
     0.113     4.932     0.200
     0.113     5.133     0.200
     0.060     4.332     0.200
     0.181     5.332     0.200
     0.220     6.531     0.200
     0.224     7.232     0.200
     0.224     7.432     0.200
     0.261     8.633     0.200
     0.272     8.832     0.200
     0.272     9.031     0.200
     0.395    12.633     0.200
     0.674    22.332     0.200
     0.830    27.582     0.200
     0.104     4.945     0.200
     0.121     5.043     0.200
     0.158     6.215     0.200
     0.185     6.754     0.200
     0.190     7.395     0.200
     0.230     7.465     0.200
     0.249     8.105     0.200
     0.409    12.816     0.200
     0.561    16.715     0.200
     0.079     4.328     0.200
     0.148     4.328     0.200
     0.191     6.728     0.200
     0.246     7.828     0.200
     0.266     8.728     0.200
     0.282     9.028     0.200
     0.261     8.628     0.200
     0.230     9.038     0.200
     0.652    21.828     0.200
     0.814    26.578     0.200
     0.033     3.660     0.200
     0.034     3.059     0.200
     0.055     4.367     0.200
     0.122     5.520     0.200
     0.227     7.258     0.200
     0.232     7.879     0.200
     0.191     8.160     0.200
     0.255     8.750     0.200
     0.279     8.809     0.200
     0.267     8.879     0.200
     0.299     9.598     0.200
     0.551    17.059     0.200
     0.675    20.660     0.200
     0.829    27.309     0.200
     1.139    36.457     0.200
     0.060     3.691     0.200
     0.032     3.594     0.200
     0.036     3.391     0.200
     0.056     4.594     0.200
     0.110     5.480     0.200
     0.120     5.582     0.200
     0.189     5.242     0.200
     0.193     7.691     0.200
     0.230     7.492     0.200
     0.254     8.691     0.200
     0.266     8.891     0.200
     0.298     9.891     0.200
     0.551    16.742     0.200
     0.835    27.992     0.200
     0.044     3.906     0.200
     0.082     4.008     0.200
     0.111     5.637     0.200
     0.183     5.508     0.200
     0.241     9.535     0.200
     0.303    10.008     0.200
     0.305    10.105     0.200
     0.836    26.105     0.200
     2.067    63.906     0.200
     2.530    74.406     0.200
     2.597    77.605     0.200
     2.836    82.105     0.200
     2.068    63.906     0.200
     2.916    84.605     0.200
     0.020     3.758     0.200
     0.048     3.656     0.200
     0.057     3.555     0.200
     0.089     4.688     0.200
     0.083     4.867     0.200
     0.112     5.328     0.200
     0.196     5.984     0.200
     0.200     6.688     0.200
     0.253     7.906     0.200
     0.221     8.609     0.200
     0.265     8.773     0.200
     0.819    26.406     0.200
     0.017     4.074     0.200
     0.034     3.973     0.200
     0.111     5.203     0.200
     0.267     9.176     0.200
     0.198     7.773     0.200
     0.277     9.074     0.200
     0.280     9.223     0.200
     0.304     9.676     0.200
     0.560    17.523     0.200
     0.677    21.074     0.200
     0.839    28.074     0.200
     0.833    27.125     0.200
     1.009    32.055     0.200
     2.042    63.074     0.200
     2.567    77.074     0.200
     2.700    81.074     0.200
     0.113     5.074     0.200
     0.133     5.734     0.200
     0.226     7.344     0.200
     0.194     7.504     0.200
     0.283     8.895     0.200
     0.291     9.645     0.200
     0.289     9.164     0.200
     0.844    26.895     0.200
     0.997    31.383     0.200
     1.053    33.934     0.200
     1.112    33.145     0.200
     2.354    73.246     0.200
     2.572    78.145     0.200
     0.015     4.047     0.200
     0.049     4.047     0.200
     0.096     4.547     0.200
     0.203     6.648     0.200
     0.207     6.523     0.200
     0.262     8.953     0.200
     0.261     8.547     0.200
     0.270     8.797     0.200
     0.213     7.578     0.200
     0.292     9.328     0.200
     0.822    26.750     0.200
     0.019     3.602     0.200
     0.032     3.500     0.200
     0.113     4.930     0.200
     0.179     5.602     0.200
     0.221     7.203     0.200
     0.225     7.398     0.200
     0.196     7.305     0.200
     0.277     9.000     0.200
     0.278     9.352     0.200
     0.304     9.602     0.200
     0.678    21.602     0.200
     0.840    28.102     0.200
     0.047     3.742     0.200
     0.066     3.641     0.200
     0.105     4.812     0.200
     0.180     5.992     0.200
     0.204     6.844     0.200
     0.209     6.781     0.200
     0.230     8.039     0.200
     0.240     7.891     0.200
     0.268     8.289     0.200
     0.220     8.266     0.200
     0.043     4.322     0.200
     0.088     5.132     0.200
     0.063     4.222     0.200
     0.177     6.072     0.200
     0.203     6.822     0.200
     0.208     6.832     0.200
     0.234     7.962     0.200
     0.243     8.112     0.200
     0.250     8.822     0.200
     0.270     8.792     0.200
     0.219     8.432     0.200
     0.052     2.551     0.200
     0.029     2.852     0.200
     0.043     2.852     0.200
     0.066     4.020     0.200
     0.106     4.742     0.200
     0.111     4.652     0.200
     0.216     6.652     0.200
     0.220     6.922     0.200
     0.203     6.750     0.200
     0.251     7.941     0.200
     0.262     8.191     0.200
     0.268     9.551     0.200
     0.291     8.762     0.200
     0.051     3.695     0.200
     0.055     3.695     0.200
     0.127     5.617     0.200
     0.077     4.934     0.200
     0.119     3.695     0.200
     0.181     7.035     0.200
     0.239     8.066     0.200
     0.193     7.676     0.200
     0.311     9.195     0.200
     0.327    10.727     0.200
     0.355    11.246     0.200
     1.065    32.695     0.200
     2.403    74.195     0.200
     2.583    77.195     0.200
     2.716    80.695     0.200
     0.021     4.016     0.200
     0.045     3.914     0.200
     0.064     4.266     0.200
     0.103     5.215     0.200
     0.052     4.617     0.200
     0.052     5.016     0.200
     0.111     5.566     0.200
     0.208     8.316     0.200
     0.291     9.516     0.200
     0.391    12.617     0.200
     1.017    30.816     0.200
     1.058    33.977     0.200
     1.130    34.914     0.200
     1.130    35.016     0.200
     1.178    37.016     0.200
     2.031    64.016     0.200
     2.332    72.516     0.200
     2.557    74.016     0.200
     2.626    76.016     0.200
     2.958    86.016     0.200
     2.334    72.516     0.200
     2.821    82.094     0.200
     0.050     3.543     0.200
     0.051     3.863     0.200
     0.032     3.242     0.200
     0.046     3.242     0.200
     0.103     4.871     0.200
     0.067     4.562     0.200
     0.111     5.133     0.200
     0.216     6.145     0.200
     0.213     7.984     0.200
     0.220     7.145     0.200
     0.204     8.191     0.200
     0.259     8.742     0.200
     0.266     8.543     0.200
     0.288     9.242     0.200
     0.382    12.305     0.200
     0.062     3.680     0.200
     0.062     4.570     0.200
     0.017     3.980     0.200
     0.035     3.781     0.200
     0.062     4.590     0.200
     0.110     5.281     0.200
     0.199     8.160     0.200
     0.213     7.730     0.200
     0.222     7.352     0.200
     0.275     9.172     0.200
     0.274     9.531     0.200
     0.302     9.723     0.200
     0.399    12.832     0.200
     0.051     4.406     0.200
     0.050     2.977     0.200
     0.026     4.078     0.200
     0.046     3.875     0.200
     0.069     4.688     0.200
     0.106     5.180     0.200
     0.216     7.336     0.200
     0.208     8.266     0.200
     0.207     8.406     0.200
     0.262     8.805     0.200
     0.264     8.727     0.200
     0.289     9.375     0.200
     1.183    37.180     0.200
     0.023     3.750     0.200
     0.031     4.547     0.200
     0.061     4.828     0.200
     0.070     4.250     0.200
     0.112     5.453     0.200
     0.087     4.148     0.200
     0.102     5.453     0.200
     0.208     6.953     0.200
     0.204     7.773     0.200
     0.189     5.250     0.200
     0.201     6.250     0.200
     0.207     7.453     0.200
     0.216     7.547     0.200
     0.237     7.750     0.200
     0.248     8.547     0.200
     0.232     9.047     0.200
     0.342    10.953     0.200
     1.083    33.023     0.200
     0.011     3.992     0.200
     0.076     4.992     0.200
     0.078     4.789     0.200
     0.037     4.188     0.200
     0.106     5.188     0.200
     0.066     4.992     0.200
     0.220     8.188     0.200
     0.217     6.391     0.200
     0.209     7.758     0.200
     0.281     9.539     0.200
     0.295     9.688     0.200
     0.316    10.289     0.200
     0.420    13.586     0.200
     0.059     3.547     0.200
     0.059     4.148     0.200
     0.019     4.445     0.200
     0.039     4.148     0.200
     0.116     5.438     0.200
     0.064     4.570     0.200
     0.108     5.266     0.200
     0.175     5.047     0.200
     0.215     5.750     0.200
     0.211     8.078     0.200
     0.202     8.250     0.200
     0.272     9.047     0.200
     0.298     9.547     0.200
     0.396    12.750     0.200
     0.037     4.125     0.200
     0.035     2.475     0.200
     0.059     2.574     0.200
     0.095     4.824     0.200
     0.100     4.674     0.200
     0.081     4.674     0.200
     0.207     6.855     0.200
     0.218     8.715     0.200
     0.252     8.475     0.200
     0.276     8.865     0.200
     0.050     3.699     0.200
     0.015     3.297     0.200
     0.109     5.258     0.200
     0.160     6.387     0.200
     0.159     6.797     0.200
     0.251     9.520     0.200
     0.262     8.297     0.200
     0.300     9.699     0.200
     0.315    10.199     0.200
     0.433    13.598     0.200
     0.032     4.154     0.200
     0.044     4.305     0.200
     0.099     5.244     0.200
     0.033     4.154     0.200
     0.066     4.754     0.200
     0.090     5.055     0.200
     0.160     4.555     0.200
     0.195     6.455     0.200
     0.244     8.555     0.200
     0.253     8.445     0.200
     0.246     8.195     0.200
     0.046     3.305     0.200
     0.061     3.617     0.200
     0.029     3.117     0.200
     0.103     5.047     0.200
     0.050     2.719     0.200
     0.175     4.367     0.200
     0.213     7.180     0.200
     0.208     5.617     0.200
     0.258     7.938     0.200
     0.249     8.055     0.200
     0.053     3.562     0.200
     0.056     4.141     0.200
     0.073     3.859     0.200
     0.104     5.242     0.200
     0.042     3.062     0.200
     0.063     4.383     0.200
     0.220     6.359     0.200
     0.225     7.547     0.200
     0.249     8.102     0.200
     0.260     8.383     0.200
     0.054     2.867     0.200
     0.054     4.176     0.200
     0.024     3.969     0.200
     0.042     2.867     0.200
     0.066     4.469     0.200
     0.108     4.969     0.200
     0.219     7.246     0.200
     0.203     8.078     0.200
     0.255     8.578     0.200
     0.265     8.676     0.200
     0.293     9.379     0.200
     0.084     5.066     0.200
     0.120     3.727     0.200
     0.128     6.238     0.200
     0.155     5.227     0.200
     0.162     6.156     0.200
     0.136     6.336     0.200
     0.142     4.828     0.200
     0.154     6.426     0.200
     0.193     6.676     0.200
     0.210     8.027     0.200
     0.264     8.695     0.200
     0.217     8.465     0.200
     0.298    10.227     0.200
     0.295     9.398     0.200
     0.287     7.926     0.200
     0.285     9.586     0.200
     1.182    35.797     0.200
     2.597    77.727     0.200
     0.050     4.352     0.200
     0.075     4.164     0.200
     0.062     3.766     0.200
     0.067     3.664     0.200
     0.079     5.055     0.200
     0.126     5.781     0.200
     0.220     7.766     0.200
     0.222     6.766     0.200
     0.228     7.586     0.200
     0.208     8.414     0.200
     0.270     8.844     0.200
     0.353    11.453     0.200
     0.020     3.945     0.200
     0.104     4.845     0.200
     0.066     3.845     0.200
     0.044     3.745     0.200
     0.053     4.445     0.200
     0.069     4.545     0.200
     0.215     7.245     0.200
     0.207     8.245     0.200
     0.267     8.745     0.200
     0.293     9.345     0.200
     1.058    33.465     0.200
     0.047     3.059     0.200
     0.047     4.480     0.200
     0.049     3.258     0.200
     0.072     4.668     0.200
     0.105     5.148     0.200
     0.210     6.059     0.200
     0.215     7.270     0.200
     0.209     8.359     0.200
     0.249     8.258     0.200
     0.259     8.559     0.200
     0.286     9.168     0.200
     0.383    12.367     0.200
     1.064    33.648     0.200
     2.024    61.559     0.200
     2.557    77.059     0.200
     0.014     2.277     0.200
     0.059     3.574     0.200
     0.057     4.105     0.200
     0.068     4.414     0.200
     0.103     4.695     0.200
     0.211     6.176     0.200
     0.215     6.824     0.200
     0.205     7.336     0.200
     0.264     8.324     0.200
     0.273     8.234     0.200
     1.171    36.977     0.200
     0.029     3.391     0.200
     0.035     3.695     0.200
     0.069     2.695     0.200
     0.087     4.594     0.200
     0.108     4.695     0.200
     0.225     7.492     0.200
     0.205     6.094     0.200
     0.211     6.594     0.200
     0.205     7.594     0.200
     0.354    10.594     0.200
     0.009     3.359     0.200
     0.041     3.562     0.200
     0.077     2.859     0.200
     0.073     4.340     0.200
     0.103     4.590     0.200
     0.070     4.633     0.200
     0.205     7.961     0.200
     0.214     6.461     0.200
     0.216     7.020     0.200
     0.204     8.180     0.200
     0.286     9.520     0.200
     0.294     9.270     0.200
     0.314     9.789     0.200
     1.151    36.660     0.200
     2.059    63.961     0.200
     2.562    75.961     0.200
     2.695    80.961     0.200
     2.762    83.961     0.200
     2.059    63.961     0.200
     2.950    89.961     0.200
     0.009     2.312     0.200
     0.010     3.672     0.200
     0.060     3.117     0.200
     0.087     4.031     0.200
     0.088     3.617     0.200
     0.109     5.008     0.200
     0.180     5.414     0.200
     0.186     5.961     0.200
     0.182     6.914     0.200
     0.222     7.305     0.200
     0.227     7.477     0.200
     0.247     7.586     0.200
     0.244     8.516     0.200
     0.331     9.914     0.200
     0.036     4.258     0.200
     0.038     2.748     0.200
     0.030     3.048     0.200
     0.062     3.148     0.200
     0.090     4.608     0.200
     0.086     4.818     0.200
     0.191     7.948     0.200
     0.194     5.548     0.200
     0.199     6.738     0.200
     0.224     8.548     0.200
     0.248     8.448     0.200
     0.255     8.448     0.200
     0.277     8.748     0.200
     0.357    10.448     0.200
     1.134    36.348     0.200
     2.020    61.948     0.200
     2.541    76.948     0.200
     2.674    79.948     0.200
     0.029     2.099     0.200
     0.062     4.009     0.200
     0.035     1.999     0.200
     0.078     3.499     0.200
     0.057     3.909     0.200
     0.112     5.129     0.200
     0.118     4.819     0.200
     0.186     5.249     0.200
     0.194     6.929     0.200
     0.220     7.999     0.200
     0.228     7.309     0.200
     0.257     8.429     0.200
     0.268     8.509     0.200
     0.299     9.169     0.200
     0.050     2.176     0.200
     0.050     3.348     0.200
     0.065     3.176     0.200
     0.025     1.777     0.200
     0.046     2.875     0.200
     0.107     5.086     0.200
     0.105     4.664     0.200
     0.070     4.348     0.200
     0.175     4.926     0.200
     0.211     5.676     0.200
     0.207     7.426     0.200
     0.215     6.664     0.200
     0.253     8.484     0.200
     0.207     7.547     0.200
     0.263     8.457     0.200
     0.264     9.176     0.200
     0.289     8.977     0.200
     0.049     2.906     0.200
     0.030     3.625     0.200
     0.142     4.203     0.200
     0.144     5.656     0.200
     0.158     4.703     0.200
     0.184     7.047     0.200
     0.119     5.281     0.200
     0.188     7.133     0.200
     0.243     6.953     0.200
     0.291     9.703     0.200
     0.302     9.555     0.200
     0.317     9.914     0.200
     0.337    10.773     0.200
     0.378    11.516     0.200
     0.076     4.719     0.200
     0.076     4.559     0.200
     0.054     4.199     0.200
     0.086     4.020     0.200
     0.133     5.879     0.200
     0.117     5.150     0.200
     0.117     5.369     0.200
     0.190     7.809     0.200
     0.278     8.980     0.200
     0.278     9.279     0.200
     0.289     9.619     0.200
     0.316    10.109     0.200
     0.412    13.219     0.200
     0.048     4.375     0.200
     0.063     3.117     0.200
     0.158     5.016     0.200
     0.159     6.418     0.200
     0.114     6.188     0.200
     0.172     6.816     0.200
     0.202     7.637     0.200
     0.198     7.688     0.200
     0.312    10.406     0.200
     0.336    10.945     0.200
     0.356    11.426     0.200
     0.395    12.785     0.200
     0.465    15.188     0.200
     0.055     3.219     0.200
     0.036     4.180     0.200
     0.149     5.520     0.200
     0.151     5.707     0.200
     0.165     5.219     0.200
     0.191     7.457     0.200
     0.194     7.379     0.200
     0.114     5.039     0.200
     0.248     7.469     0.200
     0.297    10.719     0.200
     0.308     9.648     0.200
     0.323    10.500     0.200
     0.343    10.828     0.200
     0.365    12.469     0.200
     0.076     5.240     0.200
     0.116     5.791     0.200
     0.115     5.641     0.200
     0.091     4.240     0.200
     0.124     6.141     0.200
     0.226     7.939     0.200
     0.198     7.740     0.200
     0.252     8.340     0.200
     0.313    10.141     0.200
     0.300     9.939     0.200
     0.049     3.059     0.200
     0.049     3.656     0.200
     0.026     3.258     0.200
     0.047     3.156     0.200
     0.106     5.105     0.200
     0.105     4.559     0.200
     0.071     4.156     0.200
     0.175     4.957     0.200
     0.210     6.457     0.200
     0.207     6.957     0.200
     0.214     6.457     0.200
     0.208     7.559     0.200
     0.252     7.957     0.200
     0.048     4.035     0.200
     0.029     3.156     0.200
     0.048     3.254     0.200
     0.103     5.004     0.200
     0.071     4.574     0.200
     0.106     4.484     0.200
     0.177     5.055     0.200
     0.210     6.055     0.200
     0.215     7.145     0.200
     0.207     7.805     0.200
     0.249     8.043     0.200
     0.259     8.406     0.200
     0.208     7.535     0.200
     0.262     9.305     0.200
     0.018     3.547     0.200
     0.074     4.246     0.200
     0.079     3.945     0.200
     0.092     4.547     0.200
     0.055     3.145     0.200
     0.083     4.746     0.200
     0.144     5.805     0.200
     0.148     4.445     0.200
     0.203     4.945     0.200
     0.205     6.945     0.200
     0.216     7.945     0.200
     0.291     9.617     0.200
     0.014     3.484     0.200
     0.066     3.285     0.200
     0.124     3.885     0.200
     0.149     5.266     0.200
     0.135     3.984     0.200
     0.153     5.096     0.200
     0.165     5.305     0.200
     0.143     5.564     0.200
     0.211     6.494     0.200
     0.225     6.654     0.200
     0.229     6.885     0.200
     0.022     2.407     0.200
     0.040     3.207     0.200
     0.091     4.207     0.200
     0.091     4.207     0.200
     0.110     4.907     0.200
     0.152     6.526     0.200
     0.212     8.207     0.200
     0.224     6.907     0.200
     0.222     6.207     0.200
     0.199     7.606     0.200
     0.289    10.207     0.200
     0.299     9.606     0.200
     0.307     9.517     0.200
     0.328    10.307     0.200
     2.073    64.707     0.200
     2.570    75.907     0.200
     0.057     4.352     0.200
     0.048     3.750     0.200
     0.065     3.051     0.200
     0.083     4.992     0.200
     0.107     4.551     0.200
     0.182     5.102     0.200
     0.205     7.602     0.200
     0.211     6.711     0.200
     0.219     7.941     0.200
     0.229     7.410     0.200
     0.250     8.602     0.200
     0.239     7.621     0.200
     0.268     8.090     0.200
     0.356    10.352     0.200
     1.125    35.852     0.200
     2.549    76.852     0.200
     0.058     2.648     0.200
     0.099     3.949     0.200
     0.167     5.449     0.200
     0.111     5.148     0.200
     0.192     7.230     0.200
     0.197     7.359     0.200
     0.251     6.699     0.200
     0.311    10.449     0.200
     0.324    10.199     0.200
     0.345    10.629     0.200
     0.387    12.250     0.200
     0.046     4.273     0.200
     0.022     3.004     0.200
     0.055     4.805     0.200
     0.110     5.004     0.200
     0.104     4.004     0.200
     0.120     5.703     0.200
     0.193     6.805     0.200
     0.200     6.805     0.200
     0.198     6.504     0.200
     0.197     6.805     0.200
     0.230     7.305     0.200
     0.226     7.805     0.200
     0.249     9.504     0.200
     0.036     3.125     0.200
     0.063     4.219     0.200
     0.108     4.828     0.200
     0.175     5.727     0.200
     0.211     8.727     0.200
     0.220     7.328     0.200
     0.200     7.727     0.200
     0.276     8.930     0.200
     0.383    10.727     0.200
     2.042    63.727     0.200
     2.565    75.727     0.200
     2.744    81.727     0.200
     0.046     4.041     0.200
     0.050     2.941     0.200
     0.073     4.551     0.200
     0.185     6.141     0.200
     0.212     7.090     0.200
     0.208     6.141     0.200
     0.205     7.891     0.200
     0.210     8.260     0.200
     0.259     8.451     0.200
     0.250     8.781     0.200
     0.285     9.061     0.200
     0.369    10.141     0.200
     0.385    12.180     0.200
     2.555    76.641     0.200
     0.007     3.791     0.200
     0.037     2.791     0.200
     0.065     4.691     0.200
     0.069     5.391     0.200
     0.075     4.291     0.200
     0.105     4.701     0.200
     0.166     6.291     0.200
     0.208     8.291     0.200
     0.202     8.291     0.200
     0.215     5.791     0.200
     0.218     7.791     0.200
     0.275     9.391     0.200
     0.284     9.342     0.200
     0.307     9.871     0.200
     0.410    13.201     0.200
     1.113    35.291     0.200
     2.563    78.291     0.200
     0.062     1.979     0.200
     0.078     2.479     0.200
     0.224     8.379     0.200
     0.310     9.779     0.200
     0.291     9.078     0.200
     0.296     9.180     0.200
     0.427    13.578     0.200
     1.090    34.879     0.200
     2.544    76.879     0.200
     0.026     3.465     0.200
     0.019     3.164     0.200
     0.055     3.996     0.200
     0.055     4.395     0.200
     0.082     3.867     0.200
     0.081     4.664     0.200
     0.089     4.766     0.200
     0.167     5.766     0.200
     0.189     7.746     0.200
     0.220     8.266     0.200
     0.285     9.367     0.200
     0.295     9.594     0.200
     0.321    10.086     0.200
     1.108    35.266     0.200
     0.033     3.413     0.200
     0.030     4.442     0.200
     0.036     3.513     0.200
     0.070     4.913     0.200
     0.095     5.232     0.200
     0.156     5.513     0.200
     0.191     6.612     0.200
     0.245     8.772     0.200
     0.232     9.192     0.200
     0.270     8.652     0.200
     0.056     3.883     0.200
     0.061     4.523     0.200
     0.026     3.223     0.200
     0.069     4.824     0.200
     0.098     4.812     0.200
     0.137     4.273     0.200
     0.137     5.602     0.200
     0.148     5.523     0.200
     0.183     5.922     0.200
     0.176     6.023     0.200
     0.186     5.984     0.200
     0.234     8.473     0.200
     0.275     8.965     0.200
     0.291     8.812     0.200
     0.361    11.523     0.200
     0.020     2.355     0.200
     0.059     4.004     0.200
     0.059     3.953     0.200
     0.038     1.855     0.200
     0.063     4.355     0.200
     0.176     5.504     0.200
     0.180     5.754     0.200
     0.172     6.523     0.200
     0.211     7.254     0.200
     0.201     7.953     0.200
     0.216     6.152     0.200
     0.220     7.504     0.200
     0.261     8.734     0.200
     0.298     9.402     0.200
     0.036     3.879     0.200
     0.084     5.258     0.200
     0.089     4.477     0.200
     0.101     5.629     0.200
     0.117     5.957     0.200
     0.185     7.188     0.200
     0.192     5.977     0.200
     0.194     6.957     0.200
     0.265     9.027     0.200
     0.232     9.508     0.200
     0.302    10.508     0.200
     0.315    10.406     0.200
     0.375    11.906     0.200
     1.203    37.277     0.200
     2.375    73.078     0.200
     2.539    75.277     0.200
     2.671    80.777     0.200
     2.845    85.078     0.200
     2.376    73.078     0.200
     2.925    88.277     0.200
     0.044     4.203     0.200
     0.031     3.094     0.200
     0.053     2.496     0.200
     0.075     4.836     0.200
     0.177     6.574     0.200
     0.174     5.145     0.200
     0.187     5.895     0.200
     0.177     6.984     0.200
     0.207     6.094     0.200
     0.204     6.895     0.200
     0.247     8.465     0.200
     0.212     8.324     0.200
     0.258     9.395     0.200
     0.282     9.266     0.200
     0.366    10.395     0.200
     0.363    11.336     0.200
     0.037     3.602     0.200
     0.071     4.203     0.200
     0.080     4.852     0.200
     0.085     4.000     0.200
     0.105     5.352     0.200
     0.127     4.703     0.200
     0.125     6.203     0.200
     0.116     5.305     0.200
     0.179     6.703     0.200
     0.187     5.703     0.200
     0.188     6.344     0.200
     0.259     8.703     0.200
     0.236     9.133     0.200
     0.299     9.984     0.200
     0.310     9.781     0.200
     0.369    11.555     0.200
     2.065    64.703     0.200
     2.534    74.703     0.200
     0.028     4.184     0.200
     0.050     3.586     0.200
     0.068     3.086     0.200
     0.087     5.023     0.200
     0.168     6.516     0.200
     0.181     5.484     0.200
     0.203     5.984     0.200
     0.203     6.484     0.200
     0.209     6.996     0.200
     0.202     7.484     0.200
     0.190     7.516     0.200
     0.248     8.734     0.200
     0.265     8.695     0.200
     1.159    36.984     0.200
     2.002    60.484     0.200
     2.546    75.984     0.200
     2.680    79.484     0.200
     0.028     3.352     0.200
     0.032     4.250     0.200
     0.054     4.051     0.200
     0.049     3.652     0.200
     0.068     4.051     0.200
     0.087     4.750     0.200
     0.167     6.551     0.200
     0.180     5.301     0.200
     0.208     6.852     0.200
     0.202     7.551     0.200
     0.208     6.652     0.200
     0.189     7.160     0.200
     0.201     6.551     0.200
     0.189     7.262     0.200
     0.265     8.551     0.200
     0.350    11.051     0.200
     0.075     4.703     0.200
     0.013     3.676     0.200
     0.076     4.074     0.200
     0.078     3.273     0.200
     0.049     4.273     0.200
     0.078     4.766     0.200
     0.154     4.824     0.200
     0.142     6.324     0.200
     0.147     6.074     0.200
     0.198     7.574     0.200
     0.210     7.055     0.200
     0.313     9.926     0.200
     0.313    10.363     0.200
     0.065     4.642     0.200
     0.049     5.202     0.200
     0.108     5.142     0.200
     0.114     5.941     0.200
     0.095     4.742     0.200
     0.184     7.572     0.200
     0.247     9.032     0.200
     0.255     8.342     0.200
     0.248     9.481     0.200
     0.251     9.842     0.200
     0.285    10.842     0.200
     0.291     9.572     0.200
     0.323    10.752     0.200
     0.325     9.592     0.200
     0.423    13.771     0.200
     0.041     4.355     0.200
     0.044     3.467     0.200
     0.083     4.477     0.200
     0.026     3.766     0.200
     0.063     4.266     0.200
     0.165     6.516     0.200
     0.090     5.096     0.200
     0.190     6.166     0.200
     0.194     6.777     0.200
     0.185     7.566     0.200
     0.194     6.547     0.200
     0.157     6.176     0.200
     0.168     7.566     0.200
     0.247     8.566     0.200
     0.281     8.996     0.200
     1.173    33.566     0.200
     2.538    76.566     0.200
     2.606    78.666     0.200
     3.503   102.967     0.200
     0.023     3.244     0.200
     0.046     3.043     0.200
     0.072     3.244     0.200
     0.094     4.244     0.200
     0.094     4.574     0.200
     0.169     5.443     0.200
     0.179     6.232     0.200
     0.198     6.184     0.200
     0.192     5.844     0.200
     0.263     8.123     0.200
     0.084     3.275     0.200
     0.171     4.225     0.200
     0.187     5.775     0.200
     0.230     7.975     0.200
     1.144    35.975     0.200
     2.529    76.475     0.200
     0.567    19.037     0.200
     3.062    91.066     0.200
     0.688    22.436     0.200
     1.632    52.336     0.200
     1.861    58.336     0.200
     2.470    73.336     0.200
     2.381    72.535     0.200
     1.168    36.693     0.200
     2.134    64.193     0.200
     2.429    75.793     0.200
     3.036    90.934     0.200
     3.408   100.193     0.200
     0.842    26.352     0.200
     1.538    47.652     0.200
     1.788    56.352     0.200
     2.280    69.451     0.200
     2.362    71.051     0.200
     0.773    24.688     0.200
     0.825    26.391     0.200
     1.715    52.391     0.200
     2.374    68.992     0.200
     2.459    74.094     0.200
     0.997    32.199     0.200
     1.786    55.430     0.200
     0.697    22.096     0.200
     1.760    56.395     0.200
     1.949    60.596     0.200
     3.517   107.346     0.200
     0.626    20.734     0.200
     0.609    18.977     0.200
     0.950    29.977     0.200
     2.187    65.945     0.200
     2.181    65.578     0.200
     2.265    67.676     0.200
     0.610    20.965     0.200
     1.168    36.529     0.200
     1.746    55.830     0.200
     1.950    60.730     0.200
     2.175    66.830     0.200
     2.672    81.000     0.200
     2.699    81.879     0.200
     2.840    82.930     0.200
     3.173    93.930     0.200
     0.486    16.597     0.200
     0.677    23.197     0.200
     2.312    66.907     0.200
     2.513    73.897     0.200
     2.414    73.097     0.200
     0.209     8.768     0.200
     2.245    66.897     0.200
     2.214    68.008     0.200
     2.444    74.918     0.200
     2.627    78.107     0.200
     0.269     9.012     0.200
     1.311    39.961     0.200
     2.012    60.461     0.200
     2.181    65.910     0.200
     2.572    75.461     0.200
     2.741    80.199     0.200
     2.774    81.723     0.200
     3.001    85.961     0.200
     3.507   106.160     0.200
     0.766    23.016     0.200
     2.030    61.820     0.200
     3.694   108.469     0.200
     4.400   131.617     0.200
     4.536   132.719     0.200
     0.677    20.961     0.200
     1.207    37.969     0.200
     0.388    12.879     0.200
     0.388    13.527     0.200
     0.956    30.949     0.200
     2.085    65.438     0.200
     1.472    44.204     0.200
     2.157    66.004     0.200
     2.884    84.114     0.200
     3.510   101.734     0.200
     3.994   115.704     0.200
     0.736    23.586     0.200
     1.991    61.438     0.200
     0.465    15.174     0.200
     2.387    69.873     0.200
     2.795    82.434     0.200
     0.608    20.762     0.200
     1.759    54.859     0.200
     2.072    63.859     0.200
     2.157    66.262     0.200
     2.398    70.961     0.200
     2.613    78.039     0.200
     1.724    53.733     0.200
     1.866    59.543     0.200
     1.994    60.943     0.200
     2.081    62.943     0.200
     2.582    75.543     0.200
     0.521    14.994     0.200
     1.246    38.254     0.200
     2.137    66.205     0.200
     2.711    82.033     0.200
     1.881    57.152     0.200
     2.151    63.883     0.200
     0.786    25.562     0.200
     1.765    54.186     0.200
     1.874    56.686     0.200
     1.988    62.086     0.200
     2.307    69.625     0.200
     0.525    18.266     0.200
     2.254    67.445     0.200
     1.879    57.148     0.200
     2.288    68.359     0.200
     0.675    22.262     0.200
     1.282    40.121     0.200
     2.290    69.363     0.200
     0.627    20.758     0.200
     0.605    20.844     0.200
     1.179    35.711     0.200
     1.652    52.117     0.200
     0.577    18.422     0.200
     0.643    19.961     0.200
     1.303    40.723     0.200
     2.297    69.359     0.200
     0.327    11.590     0.200
     1.350    41.129     0.200
     2.521    75.930     0.200
     2.533    77.129     0.200
     3.490   105.750     0.200
     0.653    21.730     0.200
     2.142    67.156     0.200
     0.687    22.629     0.200
     2.212    65.738     0.200
     0.676    21.480     0.200
     2.269    69.781     0.200
     2.442    75.480     0.200
     0.391    11.945     0.200
     2.185    66.375     0.200
     0.575    16.871     0.200
     0.649    21.402     0.200
     1.087    33.463     0.200
     1.857    58.553     0.200
     2.290    68.062     0.200
     0.476    16.250     0.200
     2.103    62.551     0.200
     0.503    17.062     0.200
     0.606    19.363     0.200
     1.761    54.664     0.200
     1.761    55.633     0.200
     2.826    83.164     0.200
     4.015   119.664     0.200
     0.241     9.203     0.200
     1.913    57.562     0.200
     1.924    56.871     0.200
     1.812    53.363     0.200
     2.044    59.613     0.200
     2.583    75.621     0.200
     0.602    19.549     0.200
     2.107    63.281     0.200
     2.107    65.828     0.200
     4.683   136.828     0.200
     2.091    65.249     0.200
     2.115    61.250     0.200
     3.096    92.086     0.200
     3.096    92.227     0.200
     0.851    26.491     0.200
     2.435    72.055     0.200
     2.506    73.094     0.200
     0.769    24.281     0.200
     2.025    60.797     0.200
     0.718    24.652     0.200
     0.839    27.613     0.200
     1.750    55.191     0.200
     1.979    61.742     0.200
     2.497    73.320     0.200
     2.565    74.531     0.200
     0.210     8.109     0.200
     2.632    77.619     0.200
     0.887    27.500     0.200
     0.943    30.301     0.200
     1.199    37.340     0.200
     1.623    50.141     0.200
     1.812    55.740     0.200
     2.047    62.250     0.200
     0.604    17.648     0.200
     0.673    22.078     0.200
     0.969    32.094     0.200
     1.650    53.102     0.200
     2.110    65.539     0.200
     2.200    68.102     0.200
     2.212    65.500     0.200
     3.355    99.000     0.200
     2.238    67.434     0.200
     0.641    21.312     0.200
     2.237    66.742     0.200
     0.655    21.527     0.200
     2.115    62.797     0.200
     2.439    70.496     0.200
     2.719    79.758     0.200
     0.325    10.547     0.200
     2.953    88.008     0.200
     2.976    87.203     0.200
     0.484    15.265     0.200
     1.681    52.665     0.200
     0.924    28.602     0.200
     2.081    62.543     0.200
     3.284    99.402     0.200
     1.232    38.586     0.200
     2.472    74.633     0.200
     0.606    18.887     0.200
     0.707    23.047     0.200
     1.620    50.938     0.200
     2.183    64.391     0.200
     0.655    20.586     0.200
     0.804    25.789     0.200
     2.329    69.930     0.200
     2.442    73.379     0.200
     2.494    72.328     0.200
     2.494    73.879     0.200
     0.979    30.828     0.200
     1.504    46.039     0.200
     2.471    75.258     0.200
     0.219     8.055     0.200
     0.240     8.406     0.200
     0.317    10.898     0.200
     0.338    11.453     0.200
     0.377    12.758     0.200
     0.576    18.945     0.200
     0.689    22.219     0.200
     0.689    23.039     0.200
     0.889    29.312     0.200
     1.032    33.797     0.200
     0.235     9.492     0.200
     0.261     9.828     0.200
     0.291    10.422     0.200
     0.363    12.812     0.200
     0.112     5.785     0.200
     0.248     9.426     0.200
     0.392    13.844     0.200
     0.419    14.184     0.200
     0.468    15.785     0.200
     0.495    16.863     0.200
     0.494    16.523     0.200
     0.596    19.664     0.200
     0.609    20.543     0.200
     0.630    21.023     0.200
     0.669    22.152     0.200
     0.804    26.496     0.200
     0.833    27.516     0.200
     0.832    27.516     0.200
     0.945    31.086     0.200
     1.035    33.414     0.200
     0.468    14.402     0.200
     1.826    57.684     0.200
     0.103     5.922     0.200
     0.117     6.039     0.200
     0.396    13.531     0.200
     0.420    14.578     0.200
     0.474    16.008     0.200
     0.494    16.633     0.200
     0.495    16.508     0.200
     0.599    19.867     0.200
     0.614    20.758     0.200
     0.635    21.633     0.200
     0.670    21.891     0.200
     0.205     7.645     0.200
     0.205     7.734     0.200
     0.280     9.863     0.200
     0.330    11.285     0.200
     0.329    11.434     0.200
     0.384    13.246     0.200
     0.513    17.375     0.200
     0.539    17.633     0.200
     0.554    18.375     0.200
     0.582    19.234     0.200
     0.653    21.902     0.200
     0.161     6.344     0.200
     0.181     6.914     0.200
     0.305    10.430     0.200
     0.401    13.688     0.200
     0.636    20.805     0.200
     0.651    21.367     0.200
     0.783    26.031     0.200
     0.114     5.078     0.200
     0.180     6.648     0.200
     0.199     6.969     0.200
     0.266     9.281     0.200
     0.492    16.430     0.200
     0.554    18.180     0.200
     0.702    22.859     0.200
     0.715    23.188     0.200
     0.949    30.914     0.200
     1.001    32.734     0.200
     0.998    32.797     0.200
     1.122    35.094     0.200
     0.071     5.000     0.200
     0.235     7.930     0.200
     0.325    10.875     0.200
     0.404    13.461     0.200
     0.470    16.039     0.200
     0.611    20.328     0.200
     0.676    22.039     0.200
     0.827    26.930     0.200
     0.863    27.961     0.200
     1.087    33.742     0.200
     1.098    35.422     0.200
     0.248     7.930     0.200
     0.266     9.219     0.200
     0.358    11.148     0.200
     0.465    15.520     0.200
     0.717    23.438     0.200
     0.864    28.359     0.200
     0.879    28.117     0.200
     1.285    40.609     0.200
     0.976    32.480     0.200
     1.419    44.051     0.200
     1.511    45.648     0.200
     1.766    55.289     0.200
     2.042    64.410     0.200
     2.105    66.051     0.200
     2.465    75.219     0.200
     2.517    75.379     0.200
     2.626    77.641     0.200
     2.626    79.867     0.200
     3.434   100.059     0.200
     0.052     2.883     0.200
     0.200     6.797     0.200
     0.340    10.469     0.200
     0.339    10.531     0.200
     0.377    12.023     0.200
     0.766    25.016     0.200
     1.197    39.023     0.200
     1.223    39.977     0.200
     1.224    39.703     0.200
     1.290    41.086     0.200
     0.206     7.133     0.200
     0.224     7.812     0.200
     0.268     9.062     0.200
     0.307    10.234     0.200
     0.329    11.215     0.200
     0.366    11.973     0.200
     0.560    18.324     0.200
     0.639    20.965     0.200
     0.700    22.863     0.200
     0.904    29.352     0.200
     0.164     5.906     0.200
     0.180     6.227     0.200
     0.209     6.844     0.200
     0.356    11.688     0.200
     0.441    14.789     0.200
     0.623    20.656     0.200
     0.692    22.602     0.200
     1.018    32.789     0.200
     1.022    33.688     0.200
     0.287    10.211     0.200
     0.336    11.477     0.200
     0.361    12.047     0.200
     0.362    12.438     0.200
     0.409    14.141     0.200
     0.461    15.773     0.200
     0.575    19.227     0.200
     0.600    19.867     0.200
     0.624    20.797     0.200
     0.623    20.680     0.200
     0.673    22.133     0.200
     0.763    25.203     0.200
     0.780    25.977     0.200
     0.817    27.070     0.200
     0.197     6.527     0.200
     0.150     6.750     0.200
     0.231     8.250     0.200
     0.308     9.738     0.200
     0.440    14.828     0.200
     0.676    22.000     0.200
     0.830    26.738     0.200
     0.824    26.688     0.200
     1.113    35.969     0.200
     0.955    30.789     0.200
     1.384    42.629     0.200
     1.475    44.250     0.200
     1.777    56.090     0.200
     2.477    74.309     0.200
     2.943    86.258     0.200
     0.176     6.234     0.200
     0.159     6.523     0.200
     0.220     7.934     0.200
     0.288     9.625     0.200
     0.660    21.562     0.200
     0.810    26.234     0.200
     0.809    26.562     0.200
     1.214    38.504     0.200
     0.378    11.086     0.200
     1.371    41.516     0.200
     1.780    56.223     0.200
     0.192     7.617     0.200
     0.207     8.445     0.200
     0.350    12.109     0.200
     0.351    12.039     0.200
     0.430    14.406     0.200
     0.463    16.016     0.200
     0.543    17.969     0.200
     0.546    18.070     0.200
     0.624    20.344     0.200
     0.649    21.258     0.200
     0.693    22.789     0.200
     0.747    23.820     0.200
     0.753    24.289     0.200
     0.764    25.469     0.200
     0.415    13.598     0.200
     0.420    13.266     0.200
     0.457    15.309     0.200
     0.556    18.355     0.200
     0.581    18.988     0.200
     0.631    20.988     0.200
     0.737    23.926     0.200
     1.079    34.996     0.200
     0.309    10.285     0.200
     0.317    10.207     0.200
     0.328    11.277     0.200
     0.355    11.715     0.200
     0.408    13.309     0.200
     0.478    15.758     0.200
     0.538    17.035     0.200
     0.578    18.816     0.200
     0.677    22.188     0.200
     0.775    24.727     0.200
     0.773    25.207     0.200
     0.106     5.617     0.200
     0.163     7.195     0.200
     0.259     9.234     0.200
     0.337    11.750     0.200
     0.352    12.289     0.200
     0.540    18.078     0.200
     0.598    20.398     0.200
     0.625    21.008     0.200
     0.652    21.969     0.200
     0.136     5.807     0.200
     0.246     9.356     0.200
     0.286    10.267     0.200
     0.374    12.906     0.200
     0.397    13.496     0.200
     0.461    15.387     0.200
     0.490    16.316     0.200
     0.531    17.807     0.200
     0.536    17.786     0.200
     0.640    21.066     0.200
     0.639    21.026     0.200
     0.666    22.606     0.200
     0.712    22.816     0.200
     0.711    23.097     0.200
     0.858    27.746     0.200
     0.205     7.141     0.200
     0.197     7.531     0.200
     0.404    13.684     0.200
     0.402    13.184     0.200
     0.410    13.551     0.200
     0.474    15.781     0.200
     0.570    19.004     0.200
     0.672    21.754     0.200
     0.697    22.844     0.200
     0.727    24.094     0.200
     0.774    25.262     0.200
     0.882    27.312     0.200
     0.931    30.301     0.200
     0.295     9.781     0.200
     0.299     9.703     0.200
     0.348    11.406     0.200
     0.368    11.961     0.200
     0.395    12.914     0.200
     0.471    15.609     0.200
     0.500    16.445     0.200
     0.541    17.266     0.200
     0.575    18.750     0.200
     0.575    18.484     0.200
     0.666    21.562     0.200
     0.730    23.914     0.200
     0.758    25.266     0.200
     0.774    24.875     0.200
     0.831    27.492     0.200
     0.917    29.945     0.200
     1.099    36.086     0.200
     0.285     9.848     0.200
     0.290    10.289     0.200
     0.331    11.078     0.200
     0.355    11.891     0.200
     0.374    12.777     0.200
     0.453    15.129     0.200
     0.478    15.898     0.200
     0.524    17.000     0.200
     0.555    18.047     0.200
     0.557    18.250     0.200
     0.585    18.918     0.200
     0.645    21.238     0.200
     0.643    21.188     0.200
     0.709    23.207     0.200
     0.737    24.348     0.200
     0.785    25.391     0.200
     0.836    26.379     0.200
     0.810    26.898     0.200
     0.932    30.910     0.200
     1.109    36.098     0.200
     0.277     9.676     0.200
     0.285    10.246     0.200
     0.327    11.176     0.200
     0.347    11.508     0.200
     0.367    12.738     0.200
     0.449    15.086     0.200
     0.471    15.918     0.200
     0.517    17.066     0.200
     0.548    17.969     0.200
     0.585    19.629     0.200
     0.639    20.688     0.200
     0.700    22.688     0.200
     0.729    24.027     0.200
     0.827    26.309     0.200
     0.178     6.422     0.200
     0.169     7.023     0.200
     0.281     9.594     0.200
     0.438    14.188     0.200
     0.652    21.531     0.200
     0.804    26.000     0.200
     0.800    25.750     0.200
     1.043    34.133     0.200
     1.208    38.477     0.200
     0.078     5.148     0.200
     0.161     6.348     0.200
     0.251     9.105     0.200
     0.299    10.445     0.200
     0.317    10.988     0.200
     0.458    15.285     0.200
     0.473    15.855     0.200
     0.517    18.078     0.200
     0.526    17.309     0.200
     0.555    18.176     0.200
     0.569    19.266     0.200
     0.689    22.598     0.200
     0.148     7.062     0.200
     0.290     9.781     0.200
     0.295    10.125     0.200
     0.290    10.070     0.200
     0.579    18.500     0.200
     0.596    19.305     0.200
     0.739    23.562     0.200
     0.745    23.766     0.200
     0.787    25.742     0.200
     1.005    32.055     0.200
     0.235     9.273     0.200
     0.295    10.902     0.200
     0.301    10.465     0.200
     0.419    15.012     0.200
     0.444    15.395     0.200
     0.479    15.883     0.200
     0.541    17.922     0.200
     0.611    20.223     0.200
     0.652    21.355     0.200
     0.670    22.082     0.200
     0.707    23.402     0.200
     0.758    25.512     0.200
     0.772    25.445     0.200
     0.809    26.355     0.200
     0.939    29.555     0.200
     0.942    30.605     0.200
     0.125     5.484     0.200
     0.222     8.430     0.200
     0.287    10.156     0.200
     0.291    10.258     0.200
     0.308    10.477     0.200
     0.322    11.219     0.200
     0.353    12.398     0.200
     0.426    14.852     0.200
     0.624    20.227     0.200
     0.664    21.719     0.200
     0.713    23.352     0.200
     0.801    26.172     0.200
     0.192     7.719     0.200
     0.236     9.172     0.200
     0.285    10.273     0.200
     0.311    11.391     0.200
     0.347    12.000     0.200
     0.357    12.305     0.200
     0.362    12.648     0.200
     0.503    16.812     0.200
     0.518    17.328     0.200
     0.595    19.719     0.200
     0.606    20.055     0.200
     0.680    22.625     0.200
     0.706    23.188     0.200
     0.076     5.281     0.200
     0.197     6.914     0.200
     0.333    10.680     0.200
     0.401    13.312     0.200
     0.452    14.891     0.200
     0.543    18.141     0.200
     0.550    17.961     0.200
     0.607    20.445     0.200
     0.812    26.375     0.200
     0.811    26.906     0.200
     0.822    26.734     0.200
     0.930    30.562     0.200
     1.071    34.242     0.200
     1.095    35.172     0.200
     1.142    36.227     0.200
     0.291    11.225     0.200
     0.320    11.895     0.200
     0.383    13.295     0.200
     0.397    14.074     0.200
     0.443    15.395     0.200
     0.495    17.645     0.200
     0.520    18.035     0.200
     0.543    18.176     0.200
     0.538    17.586     0.200
     0.547    18.814     0.200
     0.605    19.945     0.200
     0.700    23.285     0.200
     0.715    23.484     0.200
     0.733    24.186     0.200
     0.772    25.545     0.200
     0.805    26.205     0.200
     0.871    27.785     0.200
     0.114     4.953     0.200
     0.152     6.195     0.200
     0.222     7.859     0.200
     0.326    11.523     0.200
     0.339    11.328     0.200
     0.377    13.039     0.200
     0.527    17.906     0.200
     0.612    20.383     0.200
     0.644    21.547     0.200
     0.753    24.516     0.200
     1.115    36.023     0.200
     0.775    25.668     0.200
     0.864    28.105     0.200
     1.760    51.668     0.200
     1.850    54.816     0.200
     2.247    68.617     0.200
     2.560    73.219     0.200
     2.563    77.137     0.200
     3.077    89.328     0.200
     3.077    89.898     0.200
     0.580    19.247     0.200
     0.991    32.427     0.200
     2.180    66.427     0.200
     2.214    65.697     0.200
     2.685    78.847     0.200
     0.183     6.070     0.200
     0.267     8.773     0.200
     0.284     9.273     0.200
     0.318    10.172     0.200
     0.357    11.273     0.200
     0.635    20.273     0.200
     0.779    25.375     0.200
     0.783    25.086     0.200
     0.820    26.211     0.200
     0.856    27.500     0.200
     0.894    28.711     0.200
     0.891    29.086     0.200
     0.936    30.633     0.200
     1.042    33.547     0.200
     1.031    33.414     0.200
     1.055    34.133     0.200
     1.155    37.562     0.200
     0.115     5.781     0.200
     0.216     7.422     0.200
     0.235     8.875     0.200
     0.252     9.234     0.200
     0.393    13.055     0.200
     0.421    13.914     0.200
     0.472    15.641     0.200
     0.599    19.367     0.200
     0.613    19.922     0.200
     0.634    21.125     0.200
     0.671    21.938     0.200
     0.670    22.555     0.200
     0.685    22.594     0.200
     0.882    28.531     0.200
     0.949    31.320     0.200
     1.008    32.547     0.200
     1.597    51.172     0.200
     1.656    51.016     0.200
     1.687    52.883     0.200
     0.180     6.668     0.200
     0.309     9.758     0.200
     0.282     9.918     0.200
     0.321    10.539     0.200
     0.322    10.789     0.200
     0.335    11.117     0.200
     0.380    13.309     0.200
     0.422    13.777     0.200
     0.488    15.199     0.200
     0.473    15.559     0.200
     0.489    16.438     0.200
     0.572    19.109     0.200
     0.665    21.699     0.200
     0.912    29.488     0.200
     1.051    33.641     0.200
     1.219    39.199     0.200
     1.241    40.148     0.200
     0.219     7.813     0.200
     0.300    10.394     0.200
     0.368    11.604     0.200
     0.364    11.743     0.200
     0.442    14.913     0.200
     0.539    17.474     0.200
     0.584    19.163     0.200
     0.737    23.474     0.200
     0.813    25.974     0.200
     0.963    31.594     0.200
     1.063    34.104     0.200
     1.666    53.003     0.200
     1.753    55.753     0.200
     1.770    56.283     0.200
     0.792    24.014     0.200
     1.930    59.913     0.200
     2.489    76.073     0.200
     2.714    83.113     0.200
     0.154     5.906     0.200
     0.192     6.625     0.200
     0.247     8.297     0.200
     0.325    10.539     0.200
     0.684    22.625     0.200
     0.702    22.195     0.200
     0.745    23.844     0.200
     0.749    23.648     0.200
     0.745    24.289     0.200
     0.803    25.695     0.200
     0.834    26.328     0.200
     0.899    28.789     0.200
     0.998    31.805     0.200
     1.037    33.953     0.200
     0.147     6.301     0.200
     0.155     6.730     0.200
     0.228     7.883     0.200
     0.402    13.102     0.200
     0.502    16.582     0.200
     0.593    19.340     0.200
     0.660    22.250     0.200
     0.681    21.523     0.200
     0.740    23.941     0.200
     0.772    24.863     0.200
     0.784    25.410     0.200
     0.799    25.430     0.200
     0.807    26.211     0.200
     0.882    28.910     0.200
     0.937    30.883     0.200
     1.044    33.211     0.200
     1.201    37.500     0.200
     0.072     3.312     0.200
     0.233     8.203     0.200
     0.277     8.883     0.200
     0.351    11.203     0.200
     0.372    12.562     0.200
     0.396    13.203     0.200
     0.418    14.133     0.200
     0.455    14.312     0.200
     0.470    14.766     0.200
     0.539    17.516     0.200
     0.545    18.625     0.200
     0.686    22.180     0.200
     0.736    24.828     0.200
     0.870    27.969     0.200
     0.977    31.453     0.200
     1.212    38.320     0.200
     0.090     5.113     0.200
     0.194     7.180     0.200
     0.290    10.051     0.200
     0.301    10.840     0.200
     0.329    11.203     0.200
     0.458    14.840     0.200
     0.511    17.293     0.200
     0.679    22.160     0.200
     0.692    22.270     0.200
     0.697    22.660     0.200
     0.698    23.121     0.200
     0.723    24.250     0.200
     0.854    28.340     0.200
     0.974    31.871     0.200
     0.105     4.668     0.200
     0.176     6.418     0.200
     0.320    10.938     0.200
     0.450    15.016     0.200
     0.493    16.258     0.200
     0.679    21.965     0.200
     0.688    22.227     0.200
     0.700    22.395     0.200
     0.717    23.066     0.200
     0.835    27.555     0.200
     0.160     6.471     0.200
     0.269     9.000     0.200
     0.255     9.451     0.200
     0.369    11.771     0.200
     0.430    14.471     0.200
     0.467    15.100     0.200
     0.469    16.111     0.200
     0.467    16.111     0.200
     0.476    16.551     0.200
     0.705    22.131     0.200
     0.997    31.930     0.200
     1.214    38.650     0.200
     1.955    61.311     0.200
     0.117     4.398     0.200
     0.162     5.961     0.200
     0.182     6.219     0.200
     0.334    10.969     0.200
     0.444    14.117     0.200
     0.479    15.812     0.200
     0.668    21.719     0.200
     0.665    22.000     0.200
     0.686    21.953     0.200
     0.694    23.172     0.200
     0.701    21.938     0.200
     0.711    22.648     0.200
     0.751    24.141     0.200
     0.821    26.797     0.200
     0.998    33.047     0.200
     0.173     6.383     0.200
     0.309     9.305     0.200
     0.288     9.703     0.200
     0.309    10.695     0.200
     0.314    10.250     0.200
     0.377    13.094     0.200
     0.404    13.023     0.200
     0.458    15.031     0.200
     0.479    14.969     0.200
     0.489    16.281     0.200
     0.559    18.391     0.200
     0.648    20.516     0.200
     0.688    22.453     0.200
     0.658    21.992     0.200
     0.707    22.852     0.200
     0.813    26.039     0.200
     0.827    26.492     0.200
     0.870    27.695     0.200
     0.895    28.391     0.200
     1.038    34.023     0.200
     1.087    34.984     0.200
     1.177    36.969     0.200
     1.211    39.102     0.200
     1.234    39.633     0.200
     1.678    53.562     0.200
     1.693    53.969     0.200
     1.737    54.969     0.200
     1.820    57.234     0.200
     1.873    59.391     0.200
     1.896    60.102     0.200
     0.860    29.109     0.200
     1.896    57.805     0.200
     2.055    62.484     0.200
     2.020    64.430     0.200
     2.450    72.445     0.200
     2.501    76.133     0.200
     0.157     6.691     0.200
     0.179     6.871     0.200
     0.269    10.289     0.200
     0.338    11.039     0.200
     0.338    11.508     0.200
     0.546    18.289     0.200
     0.686    22.629     0.200
     0.694    23.059     0.200
     0.699    23.258     0.200
     0.707    22.449     0.200
     0.707    23.969     0.200
     0.746    24.559     0.200
     0.753    24.230     0.200
     0.790    25.301     0.200
     0.817    26.379     0.200
     0.101     4.773     0.200
     0.234     8.625     0.200
     0.221     7.793     0.200
     0.523    16.914     0.200
     0.530    17.496     0.200
     0.535    17.844     0.200
     0.559    18.305     0.200
     0.587    19.344     0.200
     0.730    23.965     0.200
     0.739    24.016     0.200
     0.755    24.543     0.200
     0.768    24.387     0.200
     0.801    25.637     0.200
     0.856    28.203     0.200
     0.910    29.477     0.200
     0.905    29.227     0.200
     1.057    34.344     0.200
     1.140    36.555     0.200
     1.166    37.266     0.200
     0.117     6.652     0.200
     0.179     8.633     0.200
     0.256    10.094     0.200
     0.310    10.922     0.200
     0.338    12.016     0.200
     0.390    13.344     0.200
     0.424    14.715     0.200
     0.413    14.992     0.200
     0.460    15.453     0.200
     0.584    19.016     0.200
     0.869    27.953     0.200
     0.881    28.105     0.200
     1.062    33.484     0.200
     1.606    49.695     0.200
     1.997    61.133     0.200
     2.035    62.004     0.200
     2.206    66.574     0.200
     0.170     6.746     0.200
     0.275     9.273     0.200
     0.262     9.445     0.200
     0.359    11.566     0.200
     0.437    13.914     0.200
     0.461    14.363     0.200
     0.470    15.383     0.200
     0.478    15.793     0.200
     0.537    16.285     0.200
     0.537    16.863     0.200
     0.687    22.695     0.200
     0.956    30.555     0.200
     1.051    33.805     0.200
     1.214    38.395     0.200
     1.790    56.023     0.200
     1.952    60.695     0.200
     2.045    63.336     0.200
     2.114    65.156     0.200
     0.207     6.586     0.200
     0.234     8.492     0.200
     0.323    10.820     0.200
     0.381    12.742     0.200
     0.441    14.820     0.200
     0.534    17.164     0.200
     0.541    18.070     0.200
     0.693    22.586     0.200
     0.797    25.969     0.200
     0.821    26.156     0.200
     0.847    28.281     0.200
     1.006    32.039     0.200
     1.014    32.203     0.200
     1.067    33.484     0.200
     1.052    34.961     0.200
     0.033     3.445     0.200
     0.154     6.488     0.200
     0.320    10.305     0.200
     0.370    11.465     0.200
     0.387    12.527     0.200
     0.476    16.406     0.200
     0.763    23.648     0.200
     0.974    30.328     0.200
     1.089    35.707     0.200
     1.119    35.508     0.200
     1.277    40.875     0.200
     1.715    54.367     0.200
     1.909    59.875     0.200
     1.966    61.637     0.200
     2.117    66.066     0.200
     0.172     6.895     0.200
     0.279     9.133     0.200
     0.300    10.195     0.200
     0.295    10.484     0.200
     0.339    11.766     0.200
     0.382    13.543     0.200
     0.461    14.246     0.200
     0.440    14.793     0.200
     0.499    16.613     0.200
     0.546    18.152     0.200
     0.625    20.594     0.200
     0.666    20.594     0.200
     0.671    20.973     0.200
     0.656    22.336     0.200
     0.709    23.543     0.200
     0.821    26.336     0.200
     0.816    26.652     0.200
     0.866    27.855     0.200
     0.869    27.613     0.200
     1.013    33.184     0.200
     1.070    33.664     0.200
     1.156    36.586     0.200
     1.217    38.812     0.200
     1.862    59.363     0.200
     0.095     8.797     0.200
     0.211    11.127     0.200
     0.286    12.387     0.200
     0.331    13.896     0.200
     0.349    13.816     0.200
     0.368    14.646     0.200
     0.510    17.887     0.200
     0.526    17.537     0.200
     0.539    18.816     0.200
     0.533    18.977     0.200
     0.587    20.896     0.200
     0.628    21.367     0.200
     0.618    21.236     0.200
     0.674    22.447     0.200
     0.690    22.758     0.200
     0.759    24.227     0.200
     1.216    38.137     0.200
     1.455    45.348     0.200
     1.516    47.197     0.200
     1.542    48.158     0.200
     1.926    58.527     0.200
     0.157     5.453     0.200
     0.158     6.312     0.200
     0.237     8.562     0.200
     0.297     9.805     0.200
     0.364    11.367     0.200
     0.361    11.562     0.200
     0.456    14.883     0.200
     0.494    15.422     0.200
     0.467    15.383     0.200
     0.488    16.461     0.200
     0.711    23.656     0.200
     0.734    23.188     0.200
     1.079    34.055     0.200
     1.091    35.977     0.200
     1.135    36.703     0.200
     1.343    42.773     0.200
     0.096     4.105     0.200
     0.113     5.023     0.200
     0.258     9.062     0.200
     0.327    10.824     0.200
     0.413    13.223     0.200
     0.412    14.715     0.200
     0.420    14.344     0.200
     0.438    14.934     0.200
     0.480    15.312     0.200
     0.526    17.883     0.200
     0.671    22.523     0.200
     0.738    23.492     0.200
     1.035    33.902     0.200
     0.037     4.410     0.200
     0.280     9.441     0.200
     0.390    13.422     0.200
     0.422    13.969     0.200
     0.560    18.730     0.200
     0.584    18.520     0.200
     0.826    27.781     0.200
     0.872    28.809     0.200
     0.917    29.762     0.200
     0.966    30.871     0.200
     0.970    31.730     0.200
     0.187     6.836     0.200
     0.226     7.906     0.200
     0.256     8.359     0.200
     0.333    11.234     0.200
     0.401    13.391     0.200
     0.501    16.469     0.200
     0.554    18.227     0.200
     0.704    22.844     0.200
     0.826    25.930     0.200
     0.832    27.094     0.200
     0.851    27.805     0.200
     0.861    27.258     0.200
     0.876    28.141     0.200
     0.893    29.664     0.200
     0.971    31.945     0.200
     1.094    35.570     0.200
     1.111    35.898     0.200
     1.136    36.609     0.200
     1.259    39.266     0.200
     0.037     3.467     0.200
     0.214     7.766     0.200
     0.537    17.936     0.200
     0.691    22.057     0.200
     0.813    25.746     0.200
     0.834    26.787     0.200
     0.910    28.877     0.200
     0.968    31.367     0.200
     1.040    33.367     0.200
     1.179    37.816     0.200
     1.730    55.227     0.200
     1.794    56.656     0.200
     1.808    57.316     0.200
     1.956    61.096     0.200
     1.995    62.217     0.200
     2.165    67.105     0.200
     2.201    68.297     0.200
     0.098     3.438     0.200
     0.250     7.820     0.200
     0.410    13.188     0.200
     0.454    13.672     0.200
     0.447    14.781     0.200
     0.449    15.688     0.200
     0.547    19.180     0.200
     0.664    21.133     0.200
     1.067    34.039     0.200
     1.103    34.758     0.200
     1.206    37.805     0.200
     1.384    44.039     0.200
     1.461    46.711     0.200
     1.779    56.719     0.200
     1.783    56.719     0.200
     1.788    56.648     0.200
     1.800    57.383     0.200
     1.852    58.562     0.200
     2.056    64.930     0.200
     0.203     6.891     0.200
     0.318    10.570     0.200
     0.318    10.441     0.200
     0.412    12.973     0.200
     0.505    15.512     0.200
     0.589    19.531     0.200
     0.610    19.090     0.200
     0.730    24.062     0.200
     0.739    23.461     0.200
     0.788    25.031     0.200
     0.825    28.082     0.200
     0.911    29.812     0.200
     0.971    30.922     0.200
     0.997    32.402     0.200
     0.098     5.375     0.200
     0.077     6.014     0.200
     0.159     6.074     0.200
     0.351    11.645     0.200
     0.300    10.834     0.200
     0.349    13.165     0.200
     0.428    14.544     0.200
     0.461    15.774     0.200
     0.480    16.834     0.200
     0.490    16.314     0.200
     0.569    18.224     0.200
     0.611    19.125     0.200
     0.747    24.264     0.200
     0.879    27.254     0.200
     1.076    33.875     0.200
     1.604    49.504     0.200
     1.633    50.865     0.200
     1.941    59.615     0.200
     1.961    60.034     0.200
     2.024    62.224     0.200
     2.121    64.435     0.200
     2.226    68.024     0.200
     2.284    69.714     0.200
     0.594    20.135     0.200
     2.098    65.594     0.200
     2.295    67.514     0.200
     2.372    70.004     0.200
     2.430    71.194     0.200
     0.057     7.688     0.200
     0.155     9.023     0.200
     0.221    10.734     0.200
     0.287    11.734     0.200
     0.318    12.664     0.200
     0.339    12.867     0.200
     0.418    15.297     0.200
     0.471    16.352     0.200
     0.545    18.672     0.200
     0.619    20.102     0.200
     0.623    20.820     0.200
     0.638    21.312     0.200
     0.698    23.273     0.200
     0.707    22.852     0.200
     0.783    24.133     0.200
     0.794    24.867     0.200
     1.366    42.508     0.200
     1.402    43.430     0.200
     1.477    45.852     0.200
     1.716    52.320     0.200
     1.774    53.852     0.200
     1.809    55.180     0.200
     2.078    61.453     0.200
     0.241     9.551     0.200
     0.277    11.121     0.200
     0.349    12.191     0.200
     0.345    12.391     0.200
     0.422    13.941     0.200
     0.404    14.414     0.200
     0.482    16.633     0.200
     0.577    18.051     0.200
     0.550    18.543     0.200
     0.853    27.184     0.200
     1.829    55.641     0.200
     0.327    10.541     0.200
     0.333    11.101     0.200
     0.317    10.521     0.200
     0.334    11.401     0.200
     0.363    13.161     0.200
     0.426    14.121     0.200
     0.471    15.961     0.200
     0.506    15.431     0.200
     0.471    16.331     0.200
     0.566    18.141     0.200
     1.648    51.851     0.200
     0.247     7.094     0.200
     0.266     9.305     0.200
     0.308     9.875     0.200
     0.322    11.445     0.200
     0.424    13.785     0.200
     0.460    15.625     0.200
     0.486    15.215     0.200
     0.793    25.895     0.200
     0.871    27.367     0.200
     1.338    42.277     0.200
     0.081     4.367     0.200
     0.106     4.852     0.200
     0.181     7.664     0.200
     0.269     9.906     0.200
     0.294     9.500     0.200
     0.301     9.961     0.200
     0.369    12.383     0.200
     0.432    14.461     0.200
     0.594    19.281     0.200
     0.663    21.367     0.200
     0.137     7.160     0.200
     0.117     7.262     0.200
     0.249     9.561     0.200
     0.357    12.801     0.200
     0.379    12.551     0.200
     0.423    15.150     0.200
     0.465    15.740     0.200
     0.508    17.672     0.200
     0.643    21.641     0.200
     0.659    21.461     0.200
     0.681    22.182     0.200
     0.727    23.641     0.200
     0.864    27.211     0.200
     0.881    28.252     0.200
     1.221    37.521     0.200
     0.106     4.578     0.200
     0.092     4.586     0.200
     0.137     6.516     0.200
     0.317    10.336     0.200
     0.392    12.641     0.200
     0.386    13.250     0.200
     0.459    15.047     0.200
     0.459    15.398     0.200
     0.514    17.797     0.200
     1.217    38.859     0.200
     1.903    59.000     0.200
     1.966    60.969     0.200
     2.229    68.609     0.200
     0.173     6.375     0.200
     0.193     7.031     0.200
     0.186     6.430     0.200
     0.360    11.336     0.200
     0.636    21.484     0.200
     0.662    21.695     0.200
     0.704    22.797     0.200
     0.775    24.914     0.200
     0.782    24.703     0.200
     0.046     5.348     0.200
     0.112     6.730     0.200
     0.111     7.059     0.200
     0.104     7.059     0.200
     0.247     9.098     0.200
     0.244     9.117     0.200
     0.309    10.750     0.200
     0.455    14.777     0.200
     0.474    15.688     0.200
     0.561    17.457     0.200
     0.577    18.270     0.200
     0.905    28.910     0.200
     0.941    29.758     0.200
     1.767    54.168     0.200
     1.843    55.809     0.200
     0.170     5.570     0.200
     0.154     6.031     0.200
     0.184     6.469     0.200
     0.299    10.008     0.200
     0.385    12.289     0.200
     0.396    13.148     0.200
     0.445    14.727     0.200
     0.512    17.188     0.200
     0.535    17.086     0.200
     0.623    20.391     0.200
     0.756    24.531     0.200
     0.849    27.484     0.200
     0.919    29.805     0.200
     0.955    31.211     0.200
     1.030    33.531     0.200
     1.094    35.484     0.200
     0.179     5.773     0.200
     0.141     5.977     0.200
     0.180     6.492     0.200
     0.287     9.312     0.200
     0.303    10.336     0.200
     0.399    13.344     0.200
     0.406    13.406     0.200
     0.526    16.953     0.200
     0.549    17.633     0.200
     0.636    20.461     0.200
     0.739    24.156     0.200
     0.787    25.320     0.200
     0.854    27.594     0.200
     0.952    31.273     0.200
     1.043    33.875     0.200
     1.049    34.125     0.200
     1.107    36.039     0.200
     0.106     5.047     0.200
     0.157     6.781     0.200
     0.233     8.508     0.200
     0.276    10.133     0.200
     0.333    11.531     0.200
     0.331    11.906     0.200
     0.379    13.203     0.200
     0.522    17.516     0.200
     0.579    19.812     0.200
     0.610    20.445     0.200
     0.152     5.678     0.200
     0.224     7.107     0.200
     0.238     7.479     0.200
     0.328    10.229     0.200
     0.411    13.438     0.200
     0.460    15.318     0.200
     0.485    15.449     0.200
     0.651    21.279     0.200
     0.664    21.729     0.200
     0.688    21.898     0.200
     0.699    22.938     0.200
     0.737    24.559     0.200
     0.759    24.238     0.200
     0.791    25.938     0.200
     0.836    26.648     0.200
     0.845    27.139     0.200
     0.849    27.318     0.200
     0.836    27.379     0.200
     0.916    29.578     0.200
     0.930    30.238     0.200
     0.950    29.678     0.200
     1.085    35.178     0.200
     1.098    35.789     0.200
     1.116    36.299     0.200
     1.128    36.719     0.200
     1.122    36.678     0.200
     1.209    38.818     0.200
     1.254    39.588     0.200
     1.237    40.107     0.200
     0.084     4.680     0.200
     0.101     5.820     0.200
     0.173     7.531     0.200
     0.407    14.367     0.200
     0.445    14.695     0.200
     0.457    15.406     0.200
     0.509    16.586     0.200
     0.528    16.781     0.200
     0.527    18.070     0.200
     1.009    32.172     0.200
     1.079    34.625     0.200
     1.729    54.102     0.200
     1.878    57.922     0.200
     2.031    62.789     0.200
     2.129    65.438     0.200
     2.135    65.711     0.200
     0.147     6.191     0.200
     0.156     6.043     0.200
     0.183     7.082     0.200
     0.204     7.773     0.200
     0.309    10.793     0.200
     0.369    12.883     0.200
     0.378    13.391     0.200
     0.415    13.711     0.200
     0.553    18.461     0.200
     0.615    20.230     0.200
     0.626    20.762     0.200
     0.074     3.594     0.200
     0.138     5.594     0.200
     0.150     5.516     0.200
     0.171     5.695     0.200
     0.308    10.422     0.200
     0.326    10.867     0.200
     0.367    12.242     0.200
     0.374    12.453     0.200
     0.450    14.898     0.200
     0.457    15.094     0.200
     0.546    18.172     0.200
     0.570    18.812     0.200
     0.896    29.125     0.200
     0.085     3.602     0.200
     0.142     5.410     0.200
     0.154     5.402     0.200
     0.157     5.902     0.200
     0.327    10.672     0.200
     0.341    11.531     0.200
     0.349    11.582     0.200
     0.389    12.320     0.200
     0.390    13.043     0.200
     0.410    13.453     0.200
     0.461    15.113     0.200
     0.486    16.211     0.200
     0.530    17.203     0.200
     0.582    19.160     0.200
     0.606    19.711     0.200
     0.645    21.121     0.200
     0.113     4.410     0.200
     0.161     6.211     0.200
     0.242     8.039     0.200
     0.267     8.631     0.200
     0.370    12.471     0.200
     0.393    13.020     0.200
     0.443    14.359     0.200
     0.437    14.400     0.200
     0.560    18.580     0.200
     0.646    20.820     0.200
     0.636    21.109     0.200
     0.657    21.359     0.200
     0.710    23.539     0.200
     0.733    23.840     0.200
     0.745    24.061     0.200
     0.726    24.160     0.200
     0.787    25.369     0.200
     0.791    25.359     0.200
     0.806    25.600     0.200
     0.801    26.570     0.200
     0.853    28.230     0.200
     0.910    29.480     0.200
     1.052    34.410     0.200
     1.118    36.270     0.200
     1.122    36.500     0.200
     1.184    37.221     0.200
     0.187     6.705     0.200
     0.251     9.055     0.200
     0.268     9.285     0.200
     0.303     9.965     0.200
     0.329    10.885     0.200
     0.451    14.584     0.200
     0.538    17.645     0.200
     0.576    19.193     0.200
     0.636    20.434     0.200
     0.779    25.145     0.200
     0.826    26.555     0.200
     0.828    26.604     0.200
     0.837    26.773     0.200
     0.845    27.625     0.200
     0.910    29.484     0.200
     1.050    34.055     0.200
     0.163     6.219     0.200
     0.243     8.758     0.200
     0.263     9.219     0.200
     0.328    11.094     0.200
     0.333    11.430     0.200
     0.359    12.000     0.200
     0.388    13.109     0.200
     0.402    13.508     0.200
     0.445    14.961     0.200
     0.494    15.180     0.200
     0.553    18.430     0.200
     0.577    18.984     0.200
     0.596    19.398     0.200
     0.704    23.133     0.200
     0.778    25.594     0.200
     0.864    28.344     0.200
     1.007    33.055     0.200
     1.794    55.844     0.200
     0.093     5.044     0.200
     0.088     4.854     0.200
     0.175     7.113     0.200
     0.256     9.443     0.200
     0.288     9.794     0.200
     0.358    12.284     0.200
     0.425    14.164     0.200
     0.491    16.313     0.200
     0.565    18.344     0.200
     0.579    19.434     0.200
     0.585    19.574     0.200
     0.626    20.594     0.200
     0.654    21.724     0.200
     0.755    23.634     0.200
     0.737    23.754     0.200
     0.758    24.324     0.200
     0.913    28.943     0.200
     0.923    29.794     0.200
     1.079    34.894     0.200
     1.776    56.014     0.200
     1.855    57.644     0.200
     0.201     7.770     0.200
     0.311    11.020     0.200
     0.315    11.242     0.200
     0.320    11.262     0.200
     0.345    12.020     0.200
     0.384    13.133     0.200
     0.415    13.152     0.200
     0.399    13.633     0.200
     0.436    14.590     0.200
     0.475    16.152     0.200
     0.505    16.723     0.200
     0.551    17.840     0.200
     0.586    19.371     0.200
     0.668    21.949     0.200
     0.764    25.070     0.200
     0.783    25.832     0.200
     1.711    52.531     0.200
     0.105     5.590     0.200
     0.147     6.461     0.200
     0.173     7.000     0.200
     0.216     8.570     0.200
     0.230     8.461     0.200
     0.332    11.719     0.200
     0.378    12.871     0.200
     0.416    14.160     0.200
     0.453    15.160     0.200
     0.460    15.309     0.200
     0.453    15.539     0.200
     0.554    18.500     0.200
     0.584    19.711     0.200
     0.597    20.129     0.200
     0.657    21.941     0.200
     0.701    23.012     0.200
     0.712    23.840     0.200
     0.786    25.699     0.200
     0.807    26.430     0.200
     1.012    32.879     0.200
     1.748    54.602     0.200
     1.824    56.641     0.200
     2.042    63.320     0.200
     2.157    66.371     0.200
     0.112     4.574     0.200
     0.216     7.344     0.200
     0.247     8.344     0.200
     0.289     9.711     0.200
     0.313    10.652     0.200
     0.324    11.012     0.200
     0.343    11.543     0.200
     0.422    13.133     0.200
     0.422    14.023     0.200
     0.428    14.312     0.200
     0.641    21.012     0.200
     0.677    22.242     0.200
     0.060     2.865     0.200
     0.228     7.715     0.200
     0.255     9.365     0.200
     0.346    10.775     0.200
     0.357    11.436     0.200
     0.385    12.615     0.200
     0.392    13.326     0.200
     0.370    11.096     0.200
     0.430    13.326     0.200
     0.581    18.076     0.200
     0.539    18.826     0.200
     0.586    19.965     0.200
     0.609    20.596     0.200
     0.792    25.186     0.200
     0.794    24.996     0.200
     0.849    27.096     0.200
     0.926    29.875     0.200
     0.949    30.346     0.200
     0.941    30.637     0.200
     0.974    31.025     0.200
     0.980    31.096     0.200
     1.098    35.266     0.200
     1.190    38.025     0.200
     1.264    40.336     0.200
     1.655    52.756     0.200
     1.674    53.166     0.200
     1.667    52.865     0.200
     1.727    54.336     0.200
     1.767    55.455     0.200
     1.789    56.506     0.200
     1.831    57.516     0.200
     1.925    60.326     0.200
     1.933    60.545     0.200
     1.989    62.275     0.200
     1.992    62.275     0.200
     2.058    65.346     0.200
     1.999    62.686     0.200
     2.062    63.307     0.200
     2.089    65.346     0.200
     2.782    83.066     0.200
     3.134    91.887     0.200
     0.061     3.613     0.200
     0.112     4.914     0.200
     0.207     7.684     0.200
     0.279     9.945     0.200
     0.273     9.523     0.200
     0.328    10.844     0.200
     0.379    12.785     0.200
     0.456    15.285     0.200
     0.484    15.426     0.200
     0.559    18.285     0.200
     0.612    20.105     0.200
     0.644    20.824     0.200
     0.648    21.285     0.200
     0.683    22.176     0.200
     0.732    22.926     0.200
     0.733    23.387     0.200
     0.738    23.695     0.200
     0.769    25.336     0.200
     0.804    26.125     0.200
     0.873    28.285     0.200
     0.900    29.195     0.200
     0.924    29.766     0.200
     1.072    35.043     0.200
     1.102    35.727     0.200
     1.724    54.043     0.200
     1.828    57.406     0.200
     2.134    66.305     0.200
     0.177     6.371     0.200
     0.233     8.301     0.200
     0.354    11.648     0.200
     0.363    11.570     0.200
     0.355    12.371     0.200
     0.398    13.410     0.200
     0.444    13.598     0.200
     0.470    15.699     0.200
     0.598    18.559     0.200
     0.572    19.051     0.200
     0.941    30.090     0.200
     0.962    30.578     0.200
     1.282    40.910     0.200
     1.690    53.898     0.200
     1.848    58.500     0.200
     0.140     5.641     0.200
     0.142     6.109     0.200
     0.169     6.570     0.200
     0.202     6.938     0.200
     0.328    10.609     0.200
     0.353    11.070     0.200
     0.367    11.734     0.200
     0.372    12.141     0.200
     0.381    12.211     0.200
     0.398    13.180     0.200
     0.432    14.219     0.200
     0.447    14.492     0.200
     0.451    15.305     0.200
     0.504    16.039     0.200
     0.503    16.719     0.200
     0.520    17.594     0.200
     0.534    17.500     0.200
     0.636    20.414     0.200
     0.643    20.953     0.200
     0.699    21.648     0.200
     0.681    22.367     0.200
     0.693    22.648     0.200
     0.763    25.094     0.200
     0.925    29.602     0.200
     1.658    53.203     0.200
     1.861    58.703     0.200
     0.150     5.781     0.200
     0.144     6.000     0.200
     0.176     5.742     0.200
     0.259     8.930     0.200
     0.275     9.727     0.200
     0.379    12.555     0.200
     0.374    12.320     0.200
     0.446    14.570     0.200
     0.455    14.883     0.200
     0.500    16.656     0.200
     0.611    18.211     0.200
     0.616    20.031     0.200
     0.631    19.961     0.200
     0.628    20.047     0.200
     0.637    21.047     0.200
     0.683    22.156     0.200
     0.702    23.273     0.200
     0.818    26.086     0.200
     0.861    27.711     0.200
     0.935    30.570     0.200
     0.963    31.172     0.200
     0.981    31.234     0.200
     1.914    61.062     0.200
     2.013    63.609     0.200
     2.124    66.906     0.200
     0.226     8.047     0.200
     0.229     8.508     0.200
     0.254     8.938     0.200
     0.367    12.875     0.200
     0.432    14.336     0.200
     0.507    16.336     0.200
     0.509    17.172     0.200
     0.611    19.953     0.200
     0.677    21.312     0.200
     0.682    22.312     0.200
     0.683    22.938     0.200
     0.845    27.961     0.200
     1.019    32.516     0.200
     1.047    34.086     0.200
     0.124     7.508     0.200
     0.134     7.898     0.200
     0.155     8.656     0.200
     0.269    11.344     0.200
     0.318    11.789     0.200
     0.496    16.727     0.200
     0.544    18.055     0.200
     0.532    18.445     0.200
     0.556    19.266     0.200
     0.618    20.164     0.200
     0.672    22.250     0.200
     0.764    25.320     0.200
     0.808    26.109     0.200
     0.875    28.039     0.200
     0.157     5.098     0.200
     0.273     9.020     0.200
     0.284     9.398     0.200
     0.322    10.059     0.200
     0.344    10.930     0.200
     0.360    12.070     0.200
     0.420    13.250     0.200
     0.443    15.328     0.200
     0.464    15.289     0.200
     0.507    16.797     0.200
     0.543    17.840     0.200
     0.588    19.449     0.200
     0.637    21.379     0.200
     0.722    23.988     0.200
     0.795    26.219     0.200
     0.795    26.309     0.200
     0.790    25.570     0.200
     1.801    57.707     0.200
     0.095     3.339     0.200
     0.101     3.919     0.200
     0.319    10.779     0.200
     0.464    15.209     0.200
     0.467    14.659     0.200
     0.655    20.419     0.200
     1.026    32.759     0.200
     1.106    35.489     0.200
     1.212    37.789     0.200
     1.306    41.209     0.200
     1.840    56.180     0.200
     1.885    59.289     0.200
     1.897    59.549     0.200
     1.908    59.909     0.200
     2.023    62.509     0.200
     2.061    64.720     0.200
     2.159    66.509     0.200
     2.165    66.789     0.200
     2.224    68.430     0.200
     1.973    61.999     0.200
     2.149    65.560     0.200
     2.161    66.689     0.200
     0.056     3.641     0.200
     0.180     6.273     0.200
     0.198     7.484     0.200
     0.310    10.547     0.200
     0.413    13.367     0.200
     0.412    13.125     0.200
     0.486    15.414     0.200
     0.554    17.906     0.200
     0.578    18.461     0.200
     0.626    20.844     0.200
     1.000    32.992     0.200
     1.064    34.383     0.200
     2.000    62.297     0.200
     0.162     5.062     0.200
     0.195     6.391     0.200
     0.199     6.695     0.200
     0.303     9.398     0.200
     0.318    10.320     0.200
     0.313    10.148     0.200
     0.345    10.719     0.200
     0.974    31.820     0.200
     0.059     1.871     0.200
     0.205     7.043     0.200
     0.268     9.281     0.200
     0.271     8.953     0.200
     0.271     9.492     0.200
     0.281     9.293     0.200
     0.325    10.980     0.200
     0.369    12.012     0.200
     0.381    12.980     0.200
     0.467    14.043     0.200
     0.453    14.691     0.200
     0.546    17.641     0.200
     0.592    19.012     0.200
     0.624    20.613     0.200
     0.626    20.453     0.200
     0.625    20.152     0.200
     0.080     5.133     0.200
     0.116     5.953     0.200
     0.191     7.617     0.200
     0.189     7.789     0.200
     0.241     9.602     0.200
     0.302    10.984     0.200
     0.350    11.812     0.200
     0.492    16.172     0.200
     0.499    16.328     0.200
     0.563    18.508     0.200
     0.679    21.797     0.200
     0.739    23.984     0.200
     0.762    24.703     0.200
     0.752    24.664     0.200
     0.861    28.062     0.200
     0.887    29.008     0.200
     0.969    30.633     0.200
     0.937    29.922     0.200
     1.047    33.320     0.200
     1.077    34.039     0.200
     0.177     6.914     0.200
     0.159     6.461     0.200
     0.203     8.148     0.200
     0.243     8.492     0.200
     0.362    11.266     0.200
     0.341    11.250     0.200
     0.406    12.930     0.200
     0.444    15.125     0.200
     0.464    15.250     0.200
     0.635    21.203     0.200
     0.653    20.664     0.200
     0.689    21.984     0.200
     0.710    23.453     0.200
     0.754    24.109     0.200
     0.758    24.102     0.200
     0.774    26.289     0.200
     0.785    26.320     0.200
     0.818    26.695     0.200
     0.869    28.281     0.200
     0.929    30.289     0.200
     0.988    31.922     0.200
     1.116    35.578     0.200
     1.169    35.922     0.200
     2.436    73.141     0.200
     2.472    74.703     0.200
     2.534    75.852     0.200
     2.878    84.234     0.200
     0.128     4.398     0.200
     0.208     6.516     0.200
     0.327    10.367     0.200
     0.385    12.117     0.200
     0.469    15.672     0.200
     0.503    15.656     0.200
     0.475    16.008     0.200
     0.603    19.617     0.200
     0.655    20.430     0.200
     0.770    25.156     0.200
     1.112    34.930     0.200
     1.140    36.016     0.200
     1.177    37.750     0.200
     1.652    52.242     0.200
     1.682    53.062     0.200
     1.808    56.680     0.200
     1.863    57.797     0.200
     1.933    59.500     0.200
     1.984    61.359     0.200
     2.005    62.289     0.200
     2.011    61.961     0.200
     2.025    62.695     0.200
     2.077    64.562     0.200
     2.167    66.977     0.200
     2.274    69.977     0.200
     2.272    70.070     0.200
     2.331    71.398     0.200
     0.110     5.680     0.200
     0.189     7.664     0.200
     0.235     8.617     0.200
     0.357    12.547     0.200
     0.391    13.578     0.200
     0.419    14.648     0.200
     0.465    15.227     0.200
     0.579    19.859     0.200
     0.638    21.367     0.200
     0.660    21.227     0.200
     0.661    21.914     0.200
     0.751    24.891     0.200
     0.762    25.117     0.200
     0.947    30.102     0.200
     1.967    61.008     0.200
     0.122     5.430     0.200
     0.118     4.969     0.200
     0.195     7.398     0.200
     0.394    13.367     0.200
     0.398    13.125     0.200
     0.409    13.461     0.200
     0.424    14.070     0.200
     0.451    15.484     0.200
     0.585    19.398     0.200
     0.586    19.250     0.200
     0.638    21.219     0.200
     0.708    23.320     0.200
     0.106     4.641     0.200
     0.112     5.039     0.200
     0.117     4.422     0.200
     0.157     5.672     0.200
     0.271     8.594     0.200
     0.359    11.859     0.200
     0.363    12.328     0.200
     0.399    12.711     0.200
     0.421    13.578     0.200
     0.477    15.039     0.200
     0.591    18.312     0.200
     0.644    20.938     0.200
     0.688    21.984     0.200
     0.703    23.219     0.200
     0.731    23.555     0.200
     0.746    23.828     0.200
     0.796    25.508     0.200
     0.811    25.664     0.200
     1.391    44.102     0.200
     0.161     6.810     0.200
     0.290    10.120     0.200
     0.305    11.010     0.200
     0.302    10.390     0.200
     0.310    10.650     0.200
     0.362    12.360     0.200
     0.436    13.320     0.200
     0.433    14.680     0.200
     0.449    14.690     0.200
     0.464    15.330     0.200
     0.556    18.020     0.200
     0.606    19.110     0.200
     0.628    20.730     0.200
     0.698    22.750     0.200
     0.723    23.180     0.200
     0.796    26.000     0.200
     0.836    26.140     0.200
     0.841    26.790     0.200
     1.739    55.480     0.200
     0.051     1.574     0.200
     0.282     8.906     0.200
     0.294    10.926     0.200
     0.389    12.223     0.200
     0.409    12.676     0.200
     0.506    17.484     0.200
     0.537    18.184     0.200
     0.606    19.633     0.200
     0.683    21.555     0.200
     0.723    23.016     0.200
     0.862    26.785     0.200
     0.877    28.434     0.200
     0.929    29.266     0.200
     0.950    30.414     0.200
     1.030    33.555     0.200
     1.015    33.016     0.200
     1.044    33.234     0.200
     1.141    36.355     0.200
     1.259    40.812     0.200
     1.375    43.645     0.200
     1.405    44.965     0.200
     1.733    55.723     0.200
     1.749    55.926     0.200
     1.816    57.934     0.200
     1.995    63.125     0.200
     1.998    62.504     0.200
     2.056    64.715     0.200
     0.780    23.703     0.200
     1.120    36.473     0.200
     1.984    62.074     0.200
     2.067    63.266     0.200
     2.312    70.105     0.200
     2.372    73.062     0.200
     2.527    76.055     0.200
     0.108     5.410     0.200
     0.226     8.148     0.200
     0.357    12.289     0.200
     0.392    13.512     0.200
     0.459    15.070     0.200
     0.545    18.211     0.200
     0.603    19.910     0.200
     0.629    21.051     0.200
     0.650    21.398     0.200
     0.719    23.609     0.200
     0.919    30.141     0.200
     0.982    32.090     0.200
     1.001    32.609     0.200
     0.658    23.441     0.200
     2.013    62.074     0.200
     2.111    65.883     0.200
     2.340    70.234     0.200
     2.392    71.441     0.200
     2.397    71.531     0.200
     2.555    76.203     0.200
     0.147     5.812     0.200
     0.136     5.445     0.200
     0.229     8.203     0.200
     0.356    11.898     0.200
     0.377    13.133     0.200
     0.432    14.141     0.200
     0.541    18.141     0.200
     0.602    20.266     0.200
     0.620    20.633     0.200
     0.625    20.648     0.200
     0.693    22.445     0.200
     0.730    23.734     0.200
     0.210     6.961     0.200
     0.302    10.023     0.200
     0.313    10.453     0.200
     0.336    11.504     0.200
     0.360    11.531     0.200
     0.399    12.031     0.200
     0.381    12.281     0.200
     0.422    13.273     0.200
     0.461    15.391     0.200
     0.484    16.184     0.200
     0.510    16.184     0.200
     0.516    16.613     0.200
     0.532    17.402     0.200
     0.571    18.441     0.200
     0.591    19.531     0.200
     0.681    22.262     0.200
     0.681    22.273     0.200
     0.747    24.301     0.200
     0.768    24.801     0.200
     0.775    25.211     0.200
     0.840    27.281     0.200
     0.854    27.332     0.200
     0.848    27.223     0.200
     0.950    31.031     0.200
     1.026    32.781     0.200
     1.074    34.391     0.200
     1.094    35.820     0.200
     1.696    54.742     0.200
     1.801    57.621     0.200
     0.168     5.953     0.200
     0.294     9.352     0.200
     0.451    14.844     0.200
     0.512    16.625     0.200
     0.515    16.727     0.200
     0.538    17.000     0.200
     0.663    20.977     0.200
     0.730    22.984     0.200
     0.732    23.562     0.200
     0.787    25.938     0.200
     0.808    25.852     0.200
     0.801    25.781     0.200
     0.816    26.117     0.200
     0.807    25.891     0.200
     0.116     4.570     0.200
     0.204     7.172     0.200
     0.267     9.016     0.200
     0.311     9.977     0.200
     0.328    10.031     0.200
     0.342    11.070     0.200
     0.532    16.891     0.200
     0.584    19.164     0.200
     0.714    22.641     0.200
     0.708    23.164     0.200
     0.735    23.281     0.200
     0.767    24.344     0.200
     0.855    27.125     0.200
     0.915    29.117     0.200
     0.918    29.555     0.200
     0.942    30.055     0.200
     1.050    33.773     0.200
     1.066    34.141     0.200
     1.168    37.602     0.200
     1.289    41.516     0.200
     1.421    44.484     0.200
     1.734    55.125     0.200
     0.145     6.184     0.200
     0.189     6.694     0.200
     0.288     9.534     0.200
     0.292     9.704     0.200
     0.317    10.314     0.200
     0.310    10.284     0.200
     0.396    13.124     0.200
     0.440    13.344     0.200
     0.458    13.844     0.200
     0.463    15.154     0.200
     0.510    16.574     0.200
     0.575    18.634     0.200
     0.568    18.754     0.200
     0.645    20.914     0.200
     0.667    20.524     0.200
     0.674    21.074     0.200
     0.730    24.264     0.200
     0.727    23.884     0.200
     0.781    24.064     0.200
     0.799    25.414     0.200
     0.809    26.154     0.200
     0.836    26.044     0.200
     0.882    27.764     0.200
     1.021    32.134     0.200
     1.020    32.384     0.200
     1.190    37.484     0.200
     1.213    38.974     0.200
     1.528    47.504     0.200
     1.656    52.244     0.200
     1.716    53.754     0.200
     1.875    58.864     0.200
     0.136     6.324     0.200
     0.168     7.293     0.200
     0.149     6.164     0.200
     0.261     9.965     0.200
     0.358    12.715     0.200
     0.373    13.402     0.200
     0.446    15.402     0.200
     0.449    14.734     0.200
     0.440    15.082     0.200
     0.484    15.645     0.200
     0.564    18.734     0.200
     0.617    19.312     0.200
     0.612    19.684     0.200
     0.621    20.555     0.200
     0.684    21.512     0.200
     0.681    22.395     0.200
     0.777    24.352     0.200
     0.784    25.062     0.200
     0.805    26.324     0.200
     0.849    26.441     0.200
     0.891    28.035     0.200
     0.921    30.234     0.200
     0.959    31.203     0.200
     0.989    31.535     0.200
     1.010    31.441     0.200
     1.136    35.902     0.200
     1.582    49.645     0.200
     1.609    50.094     0.200
     1.638    51.793     0.200
     1.787    55.254     0.200
     1.798    56.383     0.200
     1.922    58.324     0.200
     1.995    61.504     0.200
     2.019    62.723     0.200
     2.131    65.012     0.200
     0.481    14.895     0.200
     0.699    22.664     0.200
     0.113     5.014     0.200
     0.140     5.823     0.200
     0.172     6.854     0.200
     0.218     8.033     0.200
     0.240     8.153     0.200
     0.305    10.474     0.200
     0.333    10.273     0.200
     0.373    12.073     0.200
     0.438    13.533     0.200
     0.476    14.663     0.200
     0.474    15.333     0.200
     0.473    15.033     0.200
     0.487    16.213     0.200
     0.579    18.573     0.200
     0.609    19.394     0.200
     0.659    20.854     0.200
     0.690    22.033     0.200
     0.721    22.783     0.200
     0.727    23.264     0.200
     0.744    24.343     0.200
     0.744    24.023     0.200
     0.776    24.793     0.200
     0.816    27.503     0.200
     0.840    27.713     0.200
     0.906    29.123     0.200
     0.960    30.883     0.200
     0.973    31.923     0.200
     1.026    32.533     0.200
     1.143    35.854     0.200
     1.151    37.023     0.200
     1.333    41.903     0.200
     0.109     5.723     0.200
     0.177     6.902     0.200
     0.207     7.684     0.200
     0.305    10.453     0.200
     0.315    10.461     0.200
     0.316    10.453     0.200
     0.364    12.031     0.200
     0.434    15.043     0.200
     0.439    14.023     0.200
     0.434    14.844     0.200
     0.515    16.652     0.200
     0.561    18.691     0.200
     0.584    18.645     0.200
     0.584    18.555     0.200
     0.586    19.062     0.200
     0.670    21.363     0.200
     0.711    22.992     0.200
     0.736    22.922     0.200
     0.719    22.824     0.200
     0.763    24.461     0.200
     0.769    23.781     0.200
     0.813    26.273     0.200
     0.847    28.402     0.200
     0.942    30.395     0.200
     1.074    34.414     0.200
     1.077    34.941     0.200
     1.074    34.363     0.200
     0.134     5.125     0.200
     0.132     5.109     0.200
     0.183     6.211     0.200
     0.255     8.750     0.200
     0.340    11.680     0.200
     0.328    10.992     0.200
     0.415    13.344     0.200
     0.420    13.656     0.200
     0.454    15.000     0.200
     0.465    14.875     0.200
     0.585    19.672     0.200
     0.588    19.023     0.200
     0.661    20.430     0.200
     0.658    21.219     0.200
     0.746    23.883     0.200
     0.866    27.555     0.200
     0.884    29.266     0.200
     0.903    29.156     0.200
     0.927    29.859     0.200
     0.982    31.609     0.200
     0.986    31.711     0.200
     1.121    35.719     0.200
     1.162    36.445     0.200
     1.196    38.750     0.200
     1.770    56.539     0.200
     1.789    56.945     0.200
     1.913    61.391     0.200
     2.005    63.086     0.200
     2.122    66.664     0.200
     0.148     6.450     0.200
     0.207     7.210     0.200
     0.270     9.380     0.200
     0.296    10.420     0.200
     0.317    10.360     0.200
     0.329    10.820     0.200
     0.408    12.670     0.200
     0.431    13.480     0.200
     0.451    15.040     0.200
     0.571    18.720     0.200
     0.582    19.180     0.200
     0.602    19.780     0.200
     0.670    21.600     0.200
     0.723    23.260     0.200
     0.730    23.640     0.200
     0.807    26.290     0.200
     0.799    26.030     0.200
     0.851    27.390     0.200
     0.925    29.050     0.200
     1.086    34.210     0.200
     1.104    35.810     0.200
     1.168    37.200     0.200
     0.155     6.863     0.200
     0.249     9.324     0.200
     0.263     9.355     0.200
     0.318    11.785     0.200
     0.350    13.043     0.200
     0.393    13.684     0.200
     0.440    14.746     0.200
     0.490    15.586     0.200
     0.502    16.254     0.200
     0.578    18.496     0.200
     0.593    18.875     0.200
     0.659    21.246     0.200
     0.685    21.863     0.200
     0.700    23.055     0.200
     0.699    22.895     0.200
     0.773    25.523     0.200
     0.778    25.656     0.200
     0.787    24.375     0.200
     0.850    26.895     0.200
     0.860    27.824     0.200
     0.883    28.355     0.200
     0.915    29.023     0.200
     1.028    32.383     0.200
     1.668    50.566     0.200
     1.893    59.875     0.200
     0.040     2.438     0.200
     0.165     5.781     0.200
     0.175     6.539     0.200
     0.248     8.758     0.200
     0.311    10.812     0.200
     0.347    10.930     0.200
     0.376    12.438     0.200
     0.499    15.688     0.200
     0.471    15.352     0.200
     0.484    15.859     0.200
     0.505    16.258     0.200
     0.595    19.461     0.200
     0.710    22.242     0.200
     0.732    22.258     0.200
     0.724    23.594     0.200
     0.795    24.859     0.200
     0.942    29.938     0.200
     0.995    31.633     0.200
     1.031    32.500     0.200
     1.065    32.539     0.200
     1.124    36.570     0.200
     1.135    35.742     0.200
     1.252    39.555     0.200
     1.274    39.680     0.200
     1.778    55.422     0.200
     1.985    62.758     0.200
     2.075    63.883     0.200
     2.086    64.672     0.200
     2.146    66.461     0.200
     0.660    22.031     0.200
     2.065    62.820     0.200
     2.150    64.398     0.200
     2.245    67.258     0.200
     0.139     5.764     0.200
     0.128     5.684     0.200
     0.265     9.123     0.200
     0.306    10.453     0.200
     0.371    11.814     0.200
     0.371    12.453     0.200
     0.370    12.404     0.200
     0.528    17.225     0.200
     0.664    21.264     0.200
     0.679    21.844     0.200
     0.679    21.273     0.200
     0.841    26.943     0.200
     0.942    30.814     0.200
     1.008    33.225     0.200
     1.010    32.373     0.200
     1.042    33.225     0.200
     0.092     3.773     0.200
     0.317     9.492     0.200
     0.295    10.082     0.200
     0.491    16.094     0.200
     0.526    16.844     0.200
     0.504    16.934     0.200
     0.528    17.434     0.200
     0.634    21.613     0.200
     0.688    23.273     0.200
     0.719    25.062     0.200
     0.724    24.434     0.200
     0.919    29.324     0.200
     1.031    32.742     0.200
     1.063    33.781     0.200
     1.198    38.453     0.200
     1.335    42.254     0.200
     1.711    54.734     0.200
     0.184     9.062     0.200
     0.235     9.594     0.200
     0.261    10.453     0.200
     0.384    14.574     0.200
     0.413    14.574     0.200
     0.488    16.625     0.200
     0.484    16.785     0.200
     0.555    17.863     0.200
     0.524    18.145     0.200
     0.580    18.973     0.200
     0.570    19.844     0.200
     0.727    23.125     0.200
     0.742    24.164     0.200
     0.740    24.684     0.200
     0.814    26.402     0.200
     0.936    29.445     0.200
     1.504    47.492     0.200
     1.543    47.543     0.200
     1.721    53.543     0.200
     1.733    53.465     0.200
     1.940    59.812     0.200
     1.954    59.895     0.200
     0.212     7.133     0.200
     0.385    12.562     0.200
     0.395    13.094     0.200
     0.411    14.254     0.200
     0.460    14.434     0.200
     0.480    16.203     0.200
     0.525    16.453     0.200
     0.548    17.734     0.200
     0.548    18.492     0.200
     0.551    18.074     0.200
     0.650    21.102     0.200
     0.697    22.281     0.200
     0.738    23.352     0.200
     0.812    26.523     0.200
     0.880    28.461     0.200
     0.915    28.891     0.200
     0.892    29.512     0.200
     0.946    30.664     0.200
     1.693    54.582     0.200
     1.702    54.363     0.200
     1.814    58.273     0.200
     1.910    60.281     0.200
     1.925    61.711     0.200
     0.173     7.023     0.200
     0.195     8.039     0.200
     0.234     8.906     0.200
     0.268    10.422     0.200
     0.349    12.039     0.200
     0.427    15.125     0.200
     0.481    16.562     0.200
     0.500    16.633     0.200
     0.524    17.523     0.200
     0.689    22.812     0.200
     0.719    23.750     0.200
     0.735    24.891     0.200
     0.757    24.633     0.200
     0.839    27.656     0.200
     0.987    31.461     0.200
     1.025    32.859     0.200
     0.211     8.562     0.200
     1.100    34.344     0.200
     2.163    66.023     0.200
     0.121     4.897     0.200
     0.145     5.937     0.200
     0.240     7.437     0.200
     0.344    11.097     0.200
     0.367    13.417     0.200
     0.430    13.337     0.200
     0.409    14.487     0.200
     0.489    15.887     0.200
     0.541    18.087     0.200
     0.578    19.087     0.200
     0.752    23.967     0.200
     0.831    26.077     0.200
     1.038    33.117     0.200
     1.042    34.157     0.200
     1.177    37.507     0.200
     1.224    38.917     0.200
     1.328    42.047     0.200
     1.861    58.187     0.200
     1.908    60.057     0.200
     1.921    59.847     0.200
     2.005    62.677     0.200
     2.183    67.817     0.200
     2.233    69.097     0.200
     2.242    69.627     0.200
     0.085     3.547     0.200
     0.218     7.906     0.200
     0.254     9.008     0.200
     0.274     9.125     0.200
     0.337    10.926     0.200
     0.350    11.348     0.200
     0.366    12.047     0.200
     0.517    15.855     0.200
     0.514    16.355     0.200
     0.542    18.156     0.200
     0.615    19.426     0.200
     0.626    20.688     0.200
     0.667    21.688     0.200
     0.681    22.465     0.200
     0.785    24.707     0.200
     0.855    28.215     0.200
     0.887    29.137     0.200
     1.206    39.195     0.200
     1.701    55.438     0.200
     1.916    60.957     0.200
     0.099     5.285     0.200
     0.101     5.395     0.200
     0.166     6.723     0.200
     0.266     8.973     0.200
     0.271     9.633     0.200
     0.297    10.254     0.200
     0.341    11.414     0.200
     0.428    14.406     0.200
     0.521    16.766     0.200
     0.545    17.793     0.200
     0.722    23.633     0.200
     0.764    25.113     0.200
     0.766    25.336     0.200
     0.796    26.086     0.200
     0.831    27.184     0.200
     0.936    29.906     0.200
     1.023    33.395     0.200
     0.263     9.113     0.200
     1.309    39.586     0.200
     0.060     4.346     0.200
     0.123     5.726     0.200
     0.203     8.625     0.200
     0.304    10.186     0.200
     0.304    10.355     0.200
     0.388    13.565     0.200
     0.453    15.076     0.200
     0.510    16.766     0.200
     0.584    18.456     0.200
     0.591    19.136     0.200
     0.615    20.366     0.200
     0.657    21.646     0.200
     0.684    22.755     0.200
     0.790    25.286     0.200
     0.917    28.846     0.200
     0.926    29.875     0.200
     1.041    33.576     0.200
     1.117    35.976     0.200
     1.127    36.156     0.200
     1.749    54.545     0.200
     2.160    66.815     0.200
     0.185     6.108     0.200
     0.266     8.608     0.200
     0.280     9.108     0.200
     0.267     8.478     0.200
     0.348    11.458     0.200
     0.461    14.468     0.200
     0.441    14.768     0.200
     0.527    16.948     0.200
     0.535    17.718     0.200
     0.743    23.108     0.200
     0.763    24.288     0.200
     0.870    27.048     0.200
     0.911    29.028     0.200
     0.998    32.218     0.200
     0.067     5.002     0.200
     0.107     5.332     0.200
     0.209     8.502     0.200
     0.339    11.642     0.200
     0.373    12.812     0.200
     0.456    15.002     0.200
     0.472    15.342     0.200
     0.547    17.882     0.200
     0.552    18.482     0.200
     0.609    20.282     0.200
     0.643    21.722     0.200
     0.680    22.572     0.200
     0.726    23.772     0.200
     0.761    25.382     0.200
     0.864    27.592     0.200
     0.857    28.302     0.200
     0.878    28.712     0.200
     0.888    28.572     0.200
     0.914    28.922     0.200
     1.115    35.422     0.200
     1.743    54.382     0.200
     1.817    56.292     0.200
     1.898    59.242     0.200
     2.021    63.122     0.200
     2.101    65.432     0.200
     2.122    66.442     0.200
     0.558    18.692     0.200
     1.882    59.522     0.200
     2.954    87.892     0.200
     0.092     4.004     0.200
     0.178     6.375     0.200
     0.242     8.312     0.200
     0.265     9.023     0.200
     0.361    12.035     0.200
     0.404    13.934     0.200
     0.551    18.234     0.200
     0.608    19.875     0.200
     0.638    21.492     0.200
     0.930    30.883     0.200
     1.705    54.473     0.200
     0.097     5.625     0.200
     0.203     7.906     0.200
     0.224     8.281     0.200
     0.329    11.125     0.200
     0.340    11.398     0.200
     0.332    11.570     0.200
     0.465    14.578     0.200
     0.451    15.180     0.200
     0.793    25.906     0.200
     0.061     3.719     0.200
     0.110     4.539     0.200
     0.131     5.059     0.200
     0.224     7.209     0.200
     0.231     7.418     0.200
     0.284     9.930     0.200
     0.279    10.168     0.200
     0.366    11.879     0.200
     0.443    13.729     0.200
     0.535    17.039     0.200
     0.527    17.469     0.200
     0.523    17.939     0.200
     0.958    31.299     0.200
     0.988    32.049     0.200
     0.276     8.529     0.200
     1.263    38.408     0.200
     1.898    59.498     0.200
     2.527    74.090     0.200
     2.727    81.379     0.200
     0.208     7.812     0.200
     0.242     8.133     0.200
     0.328    11.211     0.200
     0.351    11.770     0.200
     0.351    11.281     0.200
     0.379    12.691     0.200
     0.469    15.223     0.200
     0.469    14.801     0.200
     0.595    18.871     0.200
     0.710    23.312     0.200
     0.746    23.711     0.200
     0.790    25.223     0.200
     0.790    25.883     0.200
     0.890    29.250     0.200
     0.903    29.301     0.200
     1.081    35.152     0.200
     1.100    35.652     0.200
     0.073     4.027     0.200
     0.091     4.578     0.200
     0.150     5.066     0.200
     0.217     7.379     0.200
     0.228     7.156     0.200
     0.270     8.598     0.200
     0.265     8.945     0.200
     0.494    15.227     0.200
     0.538    17.855     0.200
     0.544    16.809     0.200
     0.658    21.129     0.200
     1.061    34.227     0.200
     0.064     4.395     0.200
     0.095     4.977     0.200
     0.145     5.387     0.200
     0.213     7.945     0.200
     0.218     7.516     0.200
     0.268     9.617     0.200
     0.426    13.426     0.200
     0.488    15.738     0.200
     0.526    17.375     0.200
     0.528    17.016     0.200
     0.528    16.637     0.200
     0.547    17.426     0.200
     0.628    19.855     0.200
     0.648    20.785     0.200
     0.691    22.066     0.200
     0.693    22.137     0.200
     0.722    23.328     0.200
     0.753    24.418     0.200
     0.753    24.547     0.200
     0.804    26.027     0.200
     1.065    34.438     0.200
     1.096    35.488     0.200
     0.137     6.195     0.200
     0.134     6.406     0.200
     0.179     7.227     0.200
     0.246     9.484     0.200
     0.249     8.812     0.200
     0.280     9.836     0.200
     0.363    12.516     0.200
     0.356    12.047     0.200
     0.383    13.680     0.200
     0.513    16.523     0.200
     0.518    17.906     0.200
     0.534    17.578     0.200
     0.567    18.398     0.200
     0.601    19.297     0.200
     0.650    20.727     0.200
     0.666    21.398     0.200
     0.722    23.734     0.200
     0.741    23.992     0.200
     0.762    24.594     0.200
     0.787    25.773     0.200
     0.801    25.828     0.200
     0.872    28.008     0.200
     0.868    28.305     0.200
     0.956    30.594     0.200
     0.063     4.753     0.200
     0.102     5.353     0.200
     0.138     5.683     0.200
     0.223     8.233     0.200
     0.222     7.703     0.200
     0.276     9.773     0.200
     0.278     9.593     0.200
     0.358    11.263     0.200
     0.435    14.393     0.200
     0.497    15.733     0.200
     0.532    17.973     0.200
     0.529    17.483     0.200
     0.637    20.413     0.200
     0.654    20.563     0.200
     0.665    21.983     0.200
     0.700    22.383     0.200
     0.701    22.843     0.200
     0.762    24.123     0.200
     0.753    24.483     0.200
     0.812    26.003     0.200
     1.138    35.953     0.200
     0.163     6.172     0.200
     0.190     6.570     0.200
     0.329    11.430     0.200
     0.382    12.883     0.200
     0.431    14.664     0.200
     0.423    14.000     0.200
     0.458    14.719     0.200
     0.488    16.070     0.200
     0.554    18.234     0.200
     0.587    19.062     0.200
     0.662    21.164     0.200
     0.680    21.898     0.200
     0.683    22.352     0.200
     0.707    22.461     0.200
     0.744    23.531     0.200
     0.753    24.602     0.200
     0.775    25.523     0.200
     0.849    27.250     0.200
     0.857    27.641     0.200
     0.871    28.164     0.200
     0.933    30.164     0.200
     0.943    30.570     0.200
     0.959    31.320     0.200
     0.969    32.281     0.200
     0.997    31.602     0.200
     1.114    36.062     0.200
     1.173    37.633     0.200
     1.749    55.852     0.200
     1.749    54.805     0.200
     1.957    60.844     0.200
     1.976    62.070     0.200
     2.083    64.750     0.200
     0.135     5.250     0.200
     0.134     5.453     0.200
     0.181     6.633     0.200
     0.216     7.516     0.200
     0.257     9.164     0.200
     0.341    11.336     0.200
     0.331    11.172     0.200
     0.416    13.781     0.200
     0.420    13.812     0.200
     0.455    14.961     0.200
     0.601    18.664     0.200
     0.661    20.742     0.200
     0.746    24.016     0.200
     0.751    23.914     0.200
     0.770    24.922     0.200
     0.813    26.125     0.200
     0.901    29.883     0.200
     0.928    30.141     0.200
     0.974    32.195     0.200
     0.983    31.914     0.200
     0.984    31.992     0.200
     1.121    35.680     0.200
     1.162    37.164     0.200
     1.787    56.156     0.200
     1.978    62.492     0.200
     2.004    62.844     0.200
     2.120    65.773     0.200
     0.020     4.508     0.200
     0.096     5.180     0.200
     0.148     6.160     0.200
     0.188     7.219     0.200
     0.238     8.148     0.200
     0.475    15.008     0.200
     0.481    15.711     0.200
     0.497    15.848     0.200
     0.504    16.988     0.200
     0.620    20.348     0.200
     0.680    21.980     0.200
     0.703    23.031     0.200
     0.736    24.121     0.200
     0.765    24.598     0.200
     0.796    26.379     0.200
     0.021     4.492     0.200
     0.106     5.352     0.200
     0.138     6.172     0.200
     0.188     7.117     0.200
     0.229     8.086     0.200
     0.380    12.312     0.200
     0.448    14.062     0.200
     0.482    15.336     0.200
     0.491    15.875     0.200
     0.487    15.992     0.200
     0.504    16.922     0.200
     0.621    20.336     0.200
     0.625    20.227     0.200
     0.672    21.594     0.200
     0.676    22.727     0.200
     0.696    22.117     0.200
     0.709    22.805     0.200
     0.709    23.547     0.200
     0.726    23.414     0.200
     0.731    23.781     0.200
     0.759    24.742     0.200
     0.793    25.797     0.200
     0.826    26.297     0.200
     0.856    28.422     0.200
     0.912    29.375     0.200
     0.972    31.250     0.200
     0.995    32.297     0.200
     1.154    36.352     0.200
     0.134     7.176     0.200
     0.174     7.914     0.200
     0.207     8.527     0.200
     0.299    10.605     0.200
     0.337    11.547     0.200
     0.386    13.484     0.200
     0.486    15.695     0.200
     0.556    18.984     0.200
     0.583    18.754     0.200
     0.625    21.105     0.200
     0.644    21.535     0.200
     0.695    22.414     0.200
     0.706    23.164     0.200
     0.724    23.336     0.200
     0.729    23.316     0.200
     0.743    24.215     0.200
     0.768    24.945     0.200
     0.834    26.734     0.200
     0.839    27.344     0.200
     0.828    27.047     0.200
     0.858    27.977     0.200
     0.915    29.637     0.200
     1.172    35.957     0.200
     2.702    81.547     0.200
     0.147     7.406     0.200
     0.188     7.855     0.200
     0.216     8.637     0.200
     0.313    10.215     0.200
     0.352    11.574     0.200
     0.397    13.055     0.200
     0.498    16.707     0.200
     0.562    18.414     0.200
     0.598    19.156     0.200
     0.636    20.215     0.200
     0.659    21.316     0.200
     0.700    22.984     0.200
     0.712    23.477     0.200
     0.736    24.336     0.200
     0.744    23.996     0.200
     0.744    24.594     0.200
     0.783    25.305     0.200
     0.837    26.934     0.200
     0.853    27.137     0.200
     0.870    28.336     0.200
     0.877    28.574     0.200
     0.930    30.367     0.200
     0.157     7.414     0.200
     0.196     8.266     0.200
     0.196     8.387     0.200
     0.219     8.914     0.200
     0.323    10.887     0.200
     0.360    12.016     0.200
     0.405    13.484     0.200
     0.507    16.535     0.200
     0.568    19.156     0.200
     0.607    18.867     0.200
     0.641    21.207     0.200
     0.668    22.414     0.200
     0.706    23.285     0.200
     0.719    23.965     0.200
     0.745    24.164     0.200
     0.747    24.594     0.200
     0.792    25.797     0.200
     0.850    27.855     0.200
     0.841    27.055     0.200
     0.876    28.117     0.200
     0.940    30.387     0.200
     0.062     4.379     0.200
     0.094     4.910     0.200
     0.147     5.328     0.200
     0.209     7.730     0.200
     0.214     7.441     0.200
     0.286     9.730     0.200
     0.346    11.398     0.200
     0.422    14.129     0.200
     0.484    14.531     0.200
     0.521    17.039     0.200
     0.526    16.258     0.200
     0.544    17.641     0.200
     0.623    19.828     0.200
     0.644    20.629     0.200
     0.651    20.531     0.200
     0.689    21.781     0.200
     0.691    21.980     0.200
     0.716    22.379     0.200
     0.748    24.551     0.200
     0.741    24.398     0.200
     0.773    24.801     0.200
     0.867    29.141     0.200
     1.064    34.500     0.200
     1.095    35.520     0.200
     0.094     5.340     0.200
     0.107     5.289     0.200
     0.155     6.680     0.200
     0.262     8.469     0.200
     0.258     9.141     0.200
     0.287    10.141     0.200
     0.417    13.488     0.200
     0.499    16.438     0.200
     0.525    17.258     0.200
     0.560    17.738     0.200
     0.578    18.617     0.200
     0.609    19.391     0.200
     0.649    21.008     0.200
     0.694    22.449     0.200
     0.697    21.938     0.200
     0.729    24.238     0.200
     0.728    23.129     0.200
     0.737    24.070     0.200
     0.756    23.719     0.200
     0.791    25.930     0.200
     0.825    26.859     0.200
     0.821    26.699     0.200
     0.842    27.617     0.200
     0.924    29.688     0.200
     0.941    30.609     0.200
     0.976    31.848     0.200
     1.201    37.578     0.200
     0.185     6.990     0.200
     0.267     8.789     0.200
     0.303     9.549     0.200
     0.469    14.900     0.200
     0.594    19.770     0.200
     0.676    21.600     0.200
     0.696    22.480     0.200
     0.852    27.449     0.200
     0.973    31.090     0.200
     0.994    31.930     0.200
     1.617    50.779     0.200
     0.100     5.430     0.200
     0.115     5.008     0.200
     0.151     6.367     0.200
     0.258     9.164     0.200
     0.317    10.438     0.200
     0.568    18.750     0.200
     0.591    18.836     0.200
     0.636    21.383     0.200
     0.854    26.977     0.200
     0.960    30.977     0.200
     1.105    35.727     0.200
     1.757    55.133     0.200
     0.035     3.328     0.200
     0.245     8.789     0.200
     0.367    11.168     0.200
     0.401    12.719     0.200
     0.453    14.797     0.200
     0.671    21.977     0.200
     0.683    22.969     0.200
     0.705    22.977     0.200
     0.970    31.188     0.200
     1.082    34.930     0.200
     1.114    35.809     0.200
     0.138     5.609     0.200
     0.170     6.602     0.200
     0.191     6.992     0.200
     0.282     9.781     0.200
     0.293    10.570     0.200
     0.398    13.438     0.200
     0.451    14.867     0.200
     0.467    15.555     0.200
     0.522    16.961     0.200
     0.652    21.555     0.200
     0.661    21.719     0.200
     0.725    24.070     0.200
     0.107     4.891     0.200
     0.126     5.055     0.200
     0.146     5.766     0.200
     0.153     5.906     0.200
     0.300     9.805     0.200
     0.313    10.391     0.200
     0.324    10.328     0.200
     0.515    16.766     0.200
     0.527    16.367     0.200
     0.540    17.445     0.200
     0.621    19.945     0.200
     0.160     5.264     0.200
     0.290     9.803     0.200
     0.297     9.674     0.200
     0.301     9.703     0.200
     0.316    10.424     0.200
     0.352    11.742     0.200
     0.424    13.982     0.200
     0.460    15.123     0.200
     0.618    19.543     0.200
     0.719    23.623     0.200
     0.737    23.594     0.200
     0.818    26.553     0.200
     1.831    58.572     0.200
     1.851    59.322     0.200
     0.088     3.992     0.200
     0.177     6.547     0.200
     0.223     7.961     0.200
     0.230     8.016     0.200
     0.295    10.078     0.200
     0.335    11.375     0.200
     0.368    12.047     0.200
     0.368    12.336     0.200
     0.489    15.977     0.200
     0.585    19.312     0.200
     0.594    19.195     0.200
     0.030     4.195     0.200
     0.096     5.289     0.200
     0.151     6.500     0.200
     0.195     7.680     0.200
     0.250     9.047     0.200
     0.248     9.047     0.200
     0.328    11.250     0.200
     0.478    16.117     0.200
     0.516    17.727     0.200
     0.990    31.914     0.200
     0.065     3.519     0.200
     0.201     6.709     0.200
     0.261     9.199     0.200
     0.277     9.379     0.200
     0.278     9.459     0.200
     0.279     9.409     0.200
     0.331    10.859     0.200
     0.375    12.289     0.200
     0.389    12.729     0.200
     0.502    16.059     0.200
     0.553    17.389     0.200
     0.596    19.169     0.200
     0.618    19.859     0.200
     0.630    20.409     0.200
     0.702    22.189     0.200
     0.707    22.229     0.200
     0.732    22.609     0.200
     0.703    22.549     0.200
     0.767    24.579     0.200
     0.778    24.899     0.200
     0.825    26.889     0.200
     0.827    26.349     0.200
     0.827    26.929     0.200
     0.855    27.039     0.200
     0.962    31.469     0.200
     0.996    32.359     0.200
     1.003    31.509     0.200
     1.197    38.509     0.200
     1.974    61.949     0.200
     2.658    78.489     0.200
     2.710    80.039     0.200
     0.054     3.278     0.200
     0.206     7.338     0.200
     0.271     9.729     0.200
     0.266     9.179     0.200
     0.267     9.188     0.200
     0.282     9.409     0.200
     0.322    10.769     0.200
     0.364    12.358     0.200
     0.377    12.668     0.200
     0.541    17.929     0.200
     0.588    19.398     0.200
     0.620    20.079     0.200
     0.631    19.889     0.200
     0.693    22.458     0.200
     0.717    23.259     0.200
     0.779    25.208     0.200
     0.835    26.479     0.200
     0.839    26.739     0.200
     0.973    32.318     0.200
     1.210    38.759     0.200
     0.059     3.420     0.200
     0.203     7.189     0.200
     0.266     9.020     0.200
     0.279     9.189     0.200
     0.272     9.391     0.200
     0.273     9.240     0.200
     0.327    10.900     0.200
     0.369    11.869     0.200
     0.369    12.500     0.200
     0.383    13.039     0.200
     0.507    15.980     0.200
     0.547    17.629     0.200
     0.592    19.510     0.200
     0.624    20.490     0.200
     0.624    19.740     0.200
     0.625    20.770     0.200
     0.698    22.549     0.200
     0.731    22.549     0.200
     0.830    26.629     0.200
     1.858    58.561     0.200
     0.045     3.156     0.200
     0.200     7.047     0.200
     0.259     8.945     0.200
     0.265     9.188     0.200
     0.270     9.430     0.200
     0.276     9.422     0.200
     0.326    10.648     0.200
     0.355    11.461     0.200
     0.372    12.695     0.200
     0.513    16.570     0.200
     0.533    17.555     0.200
     0.578    18.797     0.200
     0.683    22.156     0.200
     0.874    27.617     0.200
     0.974    31.438     0.200
     0.067     3.984     0.200
     0.133     4.828     0.200
     0.191     7.094     0.200
     0.205     6.969     0.200
     0.205     7.609     0.200
     0.317    10.648     0.200
     0.409    13.547     0.200
     0.423    13.891     0.200
     0.483    15.828     0.200
     0.498    16.430     0.200
     0.563    18.500     0.200
     0.586    19.547     0.200
     0.635    20.781     0.200
     1.055    34.281     0.200
     1.867    59.578     0.200
     0.060     3.354     0.200
     0.202     6.965     0.200
     0.265     9.244     0.200
     0.278     9.273     0.200
     0.273     9.285     0.200
     0.274     9.055     0.200
     0.328    11.314     0.200
     0.369    12.494     0.200
     0.384    13.074     0.200
     0.592    19.334     0.200
     0.623    20.424     0.200
     0.772    24.334     0.200
     0.828    26.115     0.200
     1.044    34.385     0.200
     0.051     3.145     0.200
     0.204     7.016     0.200
     0.264     9.137     0.200
     0.271     9.496     0.200
     0.266     8.914     0.200
     0.280     9.387     0.200
     0.323    10.586     0.200
     0.361    12.086     0.200
     0.375    12.676     0.200
     0.513    16.727     0.200
     0.538    17.363     0.200
     0.584    18.746     0.200
     0.616    19.754     0.200
     0.632    20.836     0.200
     0.717    23.516     0.200
     0.781    25.285     0.200
     0.785    25.434     0.200
     0.820    26.965     0.200
     0.834    26.227     0.200
     0.841    27.324     0.200
     0.974    31.375     0.200
     1.049    34.547     0.200
     1.211    38.387     0.200
     1.866    59.016     0.200
     0.039     3.102     0.200
     0.187     6.883     0.200
     0.252     8.941     0.200
     0.263     9.000     0.200
     0.264     9.262     0.200
     0.268     9.043     0.200
     0.346    11.820     0.200
     0.372    12.691     0.200
     0.527    17.812     0.200
     0.565    18.590     0.200
     0.600    18.941     0.200
     0.051     3.320     0.200
     0.206     7.273     0.200
     0.264     9.258     0.200
     0.273     9.734     0.200
     0.264     9.094     0.200
     0.282     9.445     0.200
     0.321    10.891     0.200
     0.361    12.117     0.200
     0.374    12.766     0.200
     0.515    16.805     0.200
     0.538    17.289     0.200
     0.586    18.820     0.200
     0.617    20.320     0.200
     0.633    20.266     0.200
     0.633    20.656     0.200
     0.690    22.578     0.200
     0.719    23.391     0.200
     0.787    25.227     0.200
     0.782    26.430     0.200
     0.836    27.438     0.200
     1.011    32.938     0.200
     1.051    34.094     0.200
     0.072     4.582     0.200
     0.103     4.852     0.200
     0.182     7.441     0.200
     0.230     8.691     0.200
     0.245     8.684     0.200
     0.338    11.664     0.200
     0.425    14.102     0.200
     0.449    15.215     0.200
     0.523    17.473     0.200
     0.575    19.023     0.200
     0.607    20.402     0.200
     0.646    21.914     0.200
     0.983    31.863     0.200
     1.098    35.012     0.200
     0.072     4.375     0.200
     0.338    11.293     0.200
     0.425    13.785     0.200
     0.537    17.543     0.200
     0.646    22.023     0.200
     1.098    34.785     0.200
     0.043     3.117     0.200
     0.209     7.461     0.200
     0.255     8.852     0.200
     0.256     8.609     0.200
     0.280     9.297     0.200
     0.286     9.531     0.200
     0.316    10.773     0.200
     0.353    11.844     0.200
     0.365    12.469     0.200
     0.522    16.578     0.200
     0.529    16.797     0.200
     0.579    18.953     0.200
     0.609    19.844     0.200
     0.642    20.414     0.200
     0.642    20.633     0.200
     0.682    22.117     0.200
     0.696    22.258     0.200
     0.729    22.820     0.200
     0.726    23.633     0.200
     0.791    24.914     0.200
     0.792    25.672     0.200
     0.819    26.961     0.200
     0.843    27.141     0.200
     0.851    27.367     0.200
     0.880    28.844     0.200
     0.983    31.969     0.200
     1.022    32.641     0.200
     1.021    32.664     0.200
     1.057    33.797     0.200
     1.221    39.164     0.200
     1.636    52.570     0.200
     1.667    53.172     0.200
     1.876    59.688     0.200
     1.998    62.820     0.200
     0.045     3.666     0.200
     0.198     7.366     0.200
     0.259     9.346     0.200
     0.269     9.676     0.200
     0.265     9.266     0.200
     0.275     9.636     0.200
     0.327    11.776     0.200
     0.355    12.256     0.200
     0.373    12.946     0.200
     0.577    19.926     0.200
     0.633    20.736     0.200
     0.683    22.836     0.200
     0.784    25.636     0.200
     0.842    27.626     0.200
     0.198     7.896     0.200
     0.327    11.296     0.200
     0.355    12.146     0.200
     0.373    12.616     0.200
     0.533    17.886     0.200
     0.577    19.526     0.200
     0.683    22.456     0.200
     0.055     5.473     0.200
     0.218     8.994     0.200
     0.274    10.424     0.200
     0.278    10.633     0.200
     0.385    13.684     0.200
     0.466    15.193     0.200
     0.466    15.943     0.200
     0.557    18.652     0.200
     0.620    21.264     0.200
     0.654    22.084     0.200
     0.063     3.484     0.200
     0.195     6.773     0.200
     0.257     8.875     0.200
     0.271     8.688     0.200
     0.276     9.555     0.200
     0.372    12.578     0.200
     0.390    13.008     0.200
     0.459    14.258     0.200
     0.447    14.305     0.200
     0.498    15.836     0.200
     0.595    19.305     0.200
     0.617    20.344     0.200
     0.618    20.227     0.200
     0.626    20.547     0.200
     0.767    24.969     0.200
     1.850    58.477     0.200
     0.049     3.141     0.200
     0.199     6.734     0.200
     0.268     9.156     0.200
     0.262     8.867     0.200
     0.275     8.867     0.200
     0.359    12.016     0.200
     0.376    12.469     0.200
     0.451    14.250     0.200
     0.473    14.930     0.200
     0.608    19.609     0.200
     0.614    20.023     0.200
     0.631    20.297     0.200
     0.632    20.438     0.200
     0.781    25.125     0.200
     1.045    33.844     0.200
     1.655    53.086     0.200
     0.530    15.500     0.200
     0.628    20.078     0.200
     0.083     3.742     0.200
     0.180     6.031     0.200
     0.231     7.602     0.200
     0.257     8.648     0.200
     0.310    10.406     0.200
     0.292     9.930     0.200
     0.361    11.812     0.200
     0.539    16.258     0.200
     0.585    18.570     0.200
     0.605    19.320     0.200
     0.629    21.195     0.200
     0.750    23.531     0.200
     0.895    28.188     0.200
     0.900    28.688     0.200
     1.295    41.242     0.200
     0.901    27.906     0.200
     0.838    25.859     0.200
     2.437    73.539     0.200
     3.131    93.266     0.200
     0.089     4.664     0.200
     0.089     4.773     0.200
     0.161     5.836     0.200
     0.236     7.953     0.200
     0.256     8.680     0.200
     0.295    10.164     0.200
     0.321    10.031     0.200
     0.511    16.445     0.200
     0.514    16.164     0.200
     0.591    19.492     0.200
     0.665    20.883     0.200
     0.785    25.664     0.200
     1.181    37.945     0.200
     0.111     4.363     0.200
     0.262     8.652     0.200
     0.263     9.125     0.200
     0.284     9.363     0.200
     0.304    10.254     0.200
     0.608    19.523     0.200
     0.658    21.312     0.200
     0.671    21.555     0.200
     0.808    25.723     0.200
     0.818    26.074     0.200
     0.961    31.516     0.200
     0.023     4.747     0.200
     0.138     6.207     0.200
     0.191     7.237     0.200
     0.231     8.317     0.200
     0.308    10.667     0.200
     0.318    10.697     0.200
     0.484    15.337     0.200
     0.489    15.957     0.200
     0.585    18.637     0.200
     0.727    23.287     0.200
     0.732    23.567     0.200
     0.748    24.327     0.200
     0.761    24.947     0.200
     0.795    25.637     0.200
     0.211     7.336     0.200
     0.297    10.285     0.200
     0.410    13.344     0.200
     0.412    13.715     0.200
     0.447    14.824     0.200
     0.468    15.574     0.200
     0.486    16.086     0.200
     0.701    22.824     0.200
     0.749    24.105     0.200
     0.737    24.285     0.200
     2.157    67.496     0.200
     0.061     3.262     0.200
     0.206     6.992     0.200
     0.273     9.152     0.200
     0.282     9.230     0.200
     0.371    12.410     0.200
     0.382    12.789     0.200
     0.466    14.391     0.200
     0.452    14.449     0.200
     0.597    19.082     0.200
     0.604    19.832     0.200
     0.625    19.922     0.200
     0.833    26.652     0.200
     1.107    35.652     0.200
     0.048     3.609     0.200
     0.199     7.207     0.200
     0.262     9.387     0.200
     0.269     9.559     0.200
     0.276     9.387     0.200
     0.358    11.906     0.200
     0.375    12.777     0.200
     0.440    13.949     0.200
     0.452    14.949     0.200
     0.474    14.770     0.200
     0.511    16.539     0.200
     0.600    19.699     0.200
     0.609    20.277     0.200
     0.631    20.770     0.200
     0.633    20.648     0.200
     0.686    22.047     0.200
     0.691    22.578     0.200
     0.202     7.414     0.200
     0.262     8.922     0.200
     0.278     9.453     0.200
     0.279     9.531     0.200
     0.330    11.125     0.200
     0.375    12.609     0.200
     0.389    13.344     0.200
     0.459    14.180     0.200
     0.452    14.844     0.200
     0.617    20.000     0.200
     0.618    20.312     0.200
     0.631    20.359     0.200
     0.703    22.742     0.200
     0.766    25.062     0.200
     0.780    25.664     0.200
     0.827    26.594     0.200
     0.828    26.359     0.200
     0.546    16.609     0.200
     0.199     7.102     0.200
     0.262     9.539     0.200
     0.274     9.586     0.200
     0.275     9.414     0.200
     0.370    12.398     0.200
     0.446    14.836     0.200
     0.451    14.648     0.200
     0.621    20.406     0.200
     0.621    20.359     0.200
     0.698    23.000     0.200
     0.778    24.930     0.200
     0.823    26.977     0.200
     0.213     7.371     0.200
     0.277     9.012     0.200
     0.289     9.641     0.200
     0.375    12.039     0.200
     0.383    12.719     0.200
     0.466    14.941     0.200
     0.460    14.660     0.200
     0.512    16.332     0.200
     0.592    19.102     0.200
     0.602    19.750     0.200
     0.622    20.051     0.200
     0.625    19.980     0.200
     0.705    23.391     0.200
     0.771    24.660     0.200
     0.833    26.840     0.200
     0.836    27.750     0.200
     0.052     4.270     0.200
     0.128     6.031     0.200
     0.168     6.701     0.200
     0.202     7.150     0.200
     0.302     8.891     0.200
     0.326    11.131     0.200
     0.406    13.250     0.200
     0.554    17.420     0.200
     0.551    17.811     0.200
     0.601    19.330     0.200
     0.690    21.330     0.200
     0.697    22.131     0.200
     0.797    24.881     0.200
     0.205     6.672     0.200
     0.271     9.070     0.200
     0.266     8.891     0.200
     0.267     9.211     0.200
     0.281     9.219     0.200
     0.323    10.703     0.200
     0.363    12.344     0.200
     0.376    12.562     0.200
     0.447    14.453     0.200
     0.472    14.672     0.200
     0.457    14.383     0.200
     0.458    14.578     0.200
     0.512    16.539     0.200
     0.540    17.359     0.200
     0.587    19.164     0.200
     0.603    18.938     0.200
     0.604    19.852     0.200
     0.599    19.750     0.200
     0.619    20.438     0.200
     0.631    20.211     0.200
     0.630    20.648     0.200
     0.692    22.930     0.200
     0.698    22.539     0.200
     0.730    23.070     0.200
     0.779    24.570     0.200
     0.785    26.172     0.200
     0.823    27.094     0.200
     0.834    26.688     0.200
     1.009    32.828     0.200
     1.013    32.750     0.200
     1.049    34.008     0.200
     1.111    36.039     0.200
     1.154    37.523     0.200
     1.834    58.242     0.200
     1.864    59.398     0.200
     1.987    62.609     0.200
     0.533    15.750     0.200
     0.631    19.828     0.200
     0.623    19.250     0.200
     0.036     4.867     0.200
     0.127     5.688     0.200
     0.202     7.520     0.200
     0.230     8.219     0.200
     0.253     9.027     0.200
     0.299    10.566     0.200
     0.304    10.547     0.200
     0.375    12.156     0.200
     0.447    14.359     0.200
     0.496    16.148     0.200
     0.497    16.336     0.200
     0.502    16.508     0.200
     0.516    17.117     0.200
     0.635    20.359     0.200
     0.711    23.328     0.200
     0.720    23.680     0.200
     0.723    22.938     0.200
     0.743    23.969     0.200
     0.802    26.309     0.200
     0.988    31.527     0.200
     1.009    32.520     0.200
     0.061     2.152     0.200
     0.142     4.344     0.200
     0.227     7.504     0.200
     0.369    12.262     0.200
     0.374    12.531     0.200
     0.390    12.523     0.200
     0.395    12.512     0.200
     0.420    13.492     0.200
     0.525    16.441     0.200
     0.533    17.762     0.200
     0.537    17.414     0.200
     0.562    17.641     0.200
     0.572    18.602     0.200
     0.802    26.883     0.200
     0.921    30.074     0.200
     0.972    31.363     0.200
     0.063     4.680     0.200
     0.091     4.699     0.200
     0.177     6.797     0.200
     0.186     6.707     0.200
     0.252     9.199     0.200
     0.323    10.617     0.200
     0.309    10.840     0.200
     0.393    13.059     0.200
     0.448    14.328     0.200
     0.488    16.020     0.200
     0.506    16.770     0.200
     0.516    17.047     0.200
     0.527    16.508     0.200
     0.587    18.867     0.200
     0.613    19.660     0.200
     0.620    20.180     0.200
     0.669    21.828     0.200
     0.675    22.340     0.200
     0.682    21.777     0.200
     0.690    22.328     0.200
     0.692    22.277     0.200
     0.713    23.500     0.200
     0.736    24.309     0.200
     0.764    25.047     0.200
     0.975    31.297     0.200
     1.052    34.098     0.200
     0.055     4.414     0.200
     0.099     4.414     0.200
     0.180     6.605     0.200
     0.180     6.586     0.200
     0.260     9.043     0.200
     0.316    10.355     0.200
     0.330    10.445     0.200
     0.449    14.926     0.200
     0.484    16.062     0.200
     0.498    16.312     0.200
     0.535    17.535     0.200
     0.587    19.562     0.200
     0.608    19.676     0.200
     0.623    19.855     0.200
     0.676    22.184     0.200
     0.680    22.152     0.200
     0.683    22.586     0.200
     0.684    22.062     0.200
     0.695    21.926     0.200
     0.715    23.234     0.200
     0.727    23.484     0.200
     0.762    24.902     0.200
     0.775    25.992     0.200
     0.852    28.293     0.200
     0.865    28.855     0.200
     0.944    30.965     0.200
     0.961    31.523     0.200
     0.982    32.184     0.200
     0.983    32.305     0.200
     0.986    32.445     0.200
     1.103    35.535     0.200
     1.100    35.766     0.200
     1.206    38.324     0.200
     0.315    10.062     0.200
     1.245    38.855     0.200
     1.335    40.914     0.200
     0.060     4.484     0.200
     0.092     4.711     0.200
     0.180     6.523     0.200
     0.187     6.680     0.200
     0.255     9.344     0.200
     0.308    10.984     0.200
     0.397    12.664     0.200
     0.451    15.102     0.200
     0.490    16.750     0.200
     0.506    16.320     0.200
     0.590    19.266     0.200
     0.615    20.062     0.200
     0.623    20.430     0.200
     0.672    21.633     0.200
     0.678    22.297     0.200
     0.685    21.984     0.200
     0.692    22.516     0.200
     0.717    23.391     0.200
     0.735    23.930     0.200
     0.767    25.141     0.200
     0.860    28.375     0.200
     0.978    31.266     0.200
     0.976    31.602     0.200
     0.994    32.305     0.200
     0.105     3.910     0.200
     0.090     3.738     0.200
     0.216     7.508     0.200
     0.260     8.910     0.200
     0.293     9.578     0.200
     0.348    11.609     0.200
     0.335    11.688     0.200
     0.369    12.148     0.200
     0.362    12.480     0.200
     0.375    12.027     0.200
     0.383    11.969     0.200
     0.498    16.590     0.200
     0.516    16.980     0.200
     0.554    17.859     0.200
     0.561    18.098     0.200
     0.596    19.219     0.200
     0.613    19.949     0.200
     0.648    21.688     0.200
     0.834    27.340     0.200
     0.882    28.617     0.200
     0.931    30.230     0.200
     0.090     6.195     0.200
     0.170     7.258     0.200
     0.188     8.070     0.200
     0.262     9.984     0.200
     0.310    10.656     0.200
     0.323    11.234     0.200
     0.330    11.805     0.200
     0.323    11.422     0.200
     0.385    14.359     0.200
     0.442    14.172     0.200
     0.434    14.758     0.200
     0.534    17.734     0.200
     0.610    19.688     0.200
     0.582    20.148     0.200
     0.639    20.461     0.200
     0.674    21.938     0.200
     0.734    23.602     0.200
     0.767    25.016     0.200
     0.792    24.930     0.200
     0.810    25.727     0.200
     0.834    26.375     0.200
     0.897    29.109     0.200
     0.970    30.648     0.200
     0.972    31.180     0.200
     1.002    31.625     0.200
     1.042    32.461     0.200
     1.685    51.781     0.200
     1.739    53.828     0.200
     1.731    53.000     0.200
     1.789    55.180     0.200
     1.832    56.578     0.200
     1.907    58.086     0.200
     1.930    59.039     0.200
     1.958    60.531     0.200
     0.119     4.164     0.200
     0.228     7.453     0.200
     0.210     7.855     0.200
     0.247     8.086     0.200
     0.272     9.086     0.200
     0.389    13.094     0.200
     0.384    12.766     0.200
     0.476    15.234     0.200
     0.527    17.363     0.200
     0.545    18.074     0.200
     0.529    18.023     0.200
     0.551    17.715     0.200
     0.661    21.355     0.200
     0.657    21.555     0.200
     0.703    23.184     0.200
     0.719    23.496     0.200
     0.846    26.895     0.200
     0.828    27.996     0.200
     0.971    30.703     0.200
     1.031    33.695     0.200
     1.088    33.785     0.200
     0.207     6.758     0.200
     0.268     8.789     0.200
     0.283     9.148     0.200
     0.272     9.156     0.200
     0.274     9.406     0.200
     0.324    10.820     0.200
     0.371    12.469     0.200
     0.383    12.930     0.200
     0.466    14.461     0.200
     0.452    14.375     0.200
     0.453    14.805     0.200
     0.459    15.398     0.200
     0.509    16.461     0.200
     0.548    18.148     0.200
     0.596    19.727     0.200
     0.602    19.445     0.200
     0.595    19.625     0.200
     0.604    19.570     0.200
     0.623    19.836     0.200
     0.625    20.141     0.200
     0.627    20.500     0.200
     0.704    22.711     0.200
     0.700    23.039     0.200
     0.714    22.945     0.200
     0.735    23.039     0.200
     0.772    25.281     0.200
     0.785    25.781     0.200
     0.832    26.781     0.200
     0.833    26.836     0.200
     0.829    26.930     0.200
     0.969    31.570     0.200
     1.002    32.805     0.200
     1.010    32.719     0.200
     1.047    34.000     0.200
     1.107    35.484     0.200
     1.148    37.227     0.200
     1.204    39.016     0.200
     1.649    52.969     0.200
     1.829    58.266     0.200
     1.859    59.555     0.200
     1.980    62.516     0.200
     0.541    16.586     0.200
     0.639    20.148     0.200
     0.615    19.305     0.200
     2.068    66.141     0.200
     0.061     2.359     0.200
     0.174     6.348     0.200
     0.196     6.129     0.200
     0.241     8.309     0.200
     0.320     9.828     0.200
     0.353    11.758     0.200
     0.389    13.051     0.200
     0.429    13.180     0.200
     0.428    14.078     0.200
     0.480    14.809     0.200
     0.490    15.309     0.200
     0.487    16.270     0.200
     0.512    16.328     0.200
     0.633    20.938     0.200
     0.705    22.621     0.200
     0.716    23.469     0.200
     0.721    23.699     0.200
     0.786    25.758     0.200
     0.959    30.719     0.200
     1.037    33.738     0.200
     1.105    34.910     0.200
     1.153    37.668     0.200
     1.182    38.270     0.200
     1.776    56.469     0.200
     1.835    58.289     0.200
     0.050     1.887     0.200
     0.239     7.887     0.200
     0.247     8.867     0.200
     0.294    10.227     0.200
     0.354    11.566     0.200
     0.394    13.117     0.200
     0.386    12.926     0.200
     0.458    15.656     0.200
     0.539    17.656     0.200
     0.592    19.227     0.200
     0.805    26.387     0.200
     0.835    27.105     0.200
     0.908    29.566     0.200
     0.959    31.414     0.200
     1.304    42.188     0.200
     0.099     5.391     0.200
     0.236     8.172     0.200
     0.241     8.320     0.200
     0.236     8.641     0.200
     0.334    11.109     0.200
     0.389    11.922     0.200
     0.376    12.430     0.200
     0.370    12.258     0.200
     0.445    14.219     0.200
     0.451    14.758     0.200
     0.513    17.266     0.200
     0.528    17.109     0.200
     0.598    18.758     0.200
     0.582    19.789     0.200
     0.740    23.188     0.200
     0.715    23.891     0.200
     0.755    23.750     0.200
     0.743    24.070     0.200
     0.771    24.727     0.200
     0.780    24.641     0.200
     0.756    24.711     0.200
     0.795    24.977     0.200
     0.784    25.836     0.200
     0.825    26.359     0.200
     0.953    30.555     0.200
     0.951    30.648     0.200
     1.086    34.672     0.200
     1.120    36.008     0.200
     1.144    36.234     0.200
     1.604    50.586     0.200
     1.646    52.336     0.200
     1.730    54.430     0.200
     1.744    54.859     0.200
     1.805    56.484     0.200
     0.135     4.820     0.200
     0.212     6.891     0.200
     0.295    10.047     0.200
     0.296     9.898     0.200
     0.320    11.281     0.200
     0.354    11.102     0.200
     0.372    11.445     0.200
     0.427    14.289     0.200
     0.547    17.031     0.200
     0.594    19.078     0.200
     0.636    19.945     0.200
     0.612    20.609     0.200
     0.863    27.930     0.200
     0.912    29.141     0.200
     0.943    30.391     0.200
     0.953    30.609     0.200
     1.096    35.836     0.200
     1.104    35.578     0.200
     1.154    36.961     0.200
     1.745    55.375     0.200
     1.804    56.867     0.200
     1.888    59.492     0.200
     1.902    60.086     0.200
     1.963    61.461     0.200
     0.081     4.781     0.200
     0.184     6.688     0.200
     0.231     8.117     0.200
     0.251     8.648     0.200
     0.262     9.758     0.200
     0.361    11.609     0.200
     0.425    12.883     0.200
     0.406    13.578     0.200
     0.491    15.922     0.200
     0.552    18.406     0.200
     0.591    20.297     0.200
     0.644    20.156     0.200
     0.634    19.906     0.200
     0.641    21.000     0.200
     0.657    20.750     0.200
     0.796    24.930     0.200
     0.926    29.430     0.200
     0.943    30.719     0.200
     0.987    31.438     0.200
     1.112    35.641     0.200
     1.129    35.586     0.200
     1.273    40.562     0.200
     1.634    50.547     0.200
     1.675    52.938     0.200
     1.791    56.656     0.200
     1.838    57.391     0.200
     1.929    60.336     0.200
     1.939    59.836     0.200
     1.989    62.195     0.200
     1.999    61.992     0.200
     0.099     4.840     0.200
     0.175     6.818     0.200
     0.246     8.359     0.200
     0.241     8.639     0.200
     0.309    10.609     0.200
     0.307    10.389     0.200
     0.349    11.510     0.200
     0.378    11.930     0.200
     0.373    12.920     0.200
     0.494    16.580     0.200
     0.592    18.430     0.200
     0.587    19.119     0.200
     0.604    19.439     0.200
     0.584    19.529     0.200
     0.639    21.830     0.200
     0.646    21.729     0.200
     0.740    23.049     0.200
     0.873    27.670     0.200
     0.897    28.439     0.200
     0.896    28.279     0.200
     0.922    29.580     0.200
     0.931    29.850     0.200
     1.073    34.430     0.200
     1.138    36.709     0.200
     1.217    38.520     0.200
     1.621    51.219     0.200
     1.736    54.818     0.200
     1.781    55.939     0.200
     1.873    58.119     0.200
     1.942    60.449     0.200
     0.040     5.176     0.200
     0.223     9.055     0.200
     0.297    10.336     0.200
     0.306    12.137     0.200
     0.397    13.867     0.200
     0.435    14.988     0.200
     0.502    16.598     0.200
     0.486    18.215     0.200
     0.542    19.117     0.200
     0.630    20.285     0.200
     0.611    20.867     0.200
     0.753    24.336     0.200
     0.787    24.977     0.200
     0.824    25.715     0.200
     0.837    27.508     0.200
     0.896    28.016     0.200
     0.900    28.336     0.200
     0.961    30.066     0.200
     1.084    33.637     0.200
     1.602    49.746     0.200
     1.646    51.215     0.200
     1.712    52.926     0.200
     1.763    54.406     0.200
     1.818    55.766     0.200
     1.825    56.195     0.200
     0.112     5.826     0.200
     0.144     6.136     0.200
     0.177     7.146     0.200
     0.238     8.276     0.200
     0.254     8.756     0.200
     0.255     9.136     0.200
     0.367    12.396     0.200
     0.401    14.326     0.200
     0.478    15.536     0.200
     0.539    17.896     0.200
     0.552    18.106     0.200
     0.606    20.566     0.200
     0.621    19.986     0.200
     0.636    20.266     0.200
     0.661    20.746     0.200
     0.701    23.136     0.200
     0.716    24.246     0.200
     0.743    24.386     0.200
     0.755    25.096     0.200
     0.772    25.306     0.200
     0.792    25.746     0.200
     0.787    25.556     0.200
     0.805    26.536     0.200
     0.865    28.246     0.200
     0.891    29.046     0.200
     0.907    29.946     0.200
     0.935    30.176     0.200
     0.983    32.006     0.200
     1.029    32.146     0.200
     1.079    34.816     0.200
     0.196     6.469     0.200
     0.261     8.695     0.200
     0.272     9.016     0.200
     0.271     9.141     0.200
     0.276     9.516     0.200
     0.332    11.141     0.200
     0.366    12.477     0.200
     0.384    12.969     0.200
     0.442    14.297     0.200
     0.448    14.641     0.200
     0.465    14.523     0.200
     0.449    14.688     0.200
     0.503    16.234     0.200
     0.545    17.844     0.200
     0.587    19.188     0.200
     0.601    19.719     0.200
     0.622    20.141     0.200
     0.624    20.547     0.200
     0.621    20.344     0.200
     0.693    22.578     0.200
     0.724    22.469     0.200
     0.694    22.758     0.200
     0.707    22.867     0.200
     0.773    24.906     0.200
     0.818    26.680     0.200
     0.824    26.867     0.200
     0.964    31.156     0.200
     1.003    32.445     0.200
     1.002    32.734     0.200
     1.039    33.727     0.200
     1.102    35.797     0.200
     1.146    37.203     0.200
     1.825    57.758     0.200
     1.856    58.766     0.200
     1.979    62.469     0.200
     0.142     5.703     0.200
     0.127     5.578     0.200
     0.281     9.031     0.200
     0.255     9.000     0.200
     0.346    10.719     0.200
     0.360    12.000     0.200
     0.339    11.789     0.200
     0.506    16.914     0.200
     0.557    17.578     0.200
     0.563    17.812     0.200
     0.574    18.242     0.200
     0.602    19.688     0.200
     0.611    20.773     0.200
     0.665    22.344     0.200
     0.704    22.391     0.200
     0.706    22.328     0.200
     0.672    22.898     0.200
     0.790    24.852     0.200
     0.797    25.258     0.200
     0.841    27.008     0.200
     0.865    27.617     0.200
     0.853    27.734     0.200
     0.870    27.922     0.200
     0.886    27.930     0.200
     0.895    28.578     0.200
     1.039    33.711     0.200
     1.103    35.102     0.200
     1.181    37.672     0.200
     1.249    39.742     0.200
     1.639    51.883     0.200
     1.690    53.281     0.200
     1.701    53.609     0.200
     1.746    55.109     0.200
     1.837    57.484     0.200
     1.847    57.461     0.200
     1.907    59.484     0.200
     0.870    26.898     0.200
     1.827    56.148     0.200
     1.911    57.367     0.200
     2.483    74.273     0.200
     0.118     4.621     0.200
     0.217     7.531     0.200
     0.327    10.730     0.200
     0.347    11.230     0.200
     0.346    11.699     0.200
     0.364    12.211     0.200
     0.595    19.199     0.200
     0.698    22.512     0.200
     0.783    24.988     0.200
     1.046    33.488     0.200
     1.059    33.969     0.200
     1.653    52.391     0.200
     0.170     6.273     0.200
     0.199     6.797     0.200
     0.223     8.055     0.200
     0.299     9.969     0.200
     0.351    11.344     0.200
     0.364    12.023     0.200
     0.461    14.930     0.200
     0.553    17.617     0.200
     0.579    18.914     0.200
     0.612    20.055     0.200
     0.630    20.359     0.200
     0.638    20.477     0.200
     0.655    21.508     0.200
     0.770    24.930     0.200
     0.770    24.734     0.200
     0.779    25.109     0.200
     0.770    25.180     0.200
     0.788    25.289     0.200
     0.788    25.688     0.200
     0.803    26.250     0.200
     0.837    26.797     0.200
     0.860    27.867     0.200
     0.853    27.500     0.200
     0.870    28.406     0.200
     0.943    30.391     0.200
     0.959    31.406     0.200
     0.981    31.836     0.200
     0.996    32.391     0.200
     1.011    32.875     0.200
     1.041    33.938     0.200
     1.050    34.023     0.200
     1.085    35.430     0.200
     1.248    39.359     0.200
     0.170     6.156     0.200
     0.199     6.656     0.200
     0.364    12.141     0.200
     0.612    20.227     0.200
     0.630    20.086     0.200
     0.638    20.641     0.200
     0.655    21.367     0.200
     0.770    24.594     0.200
     0.770    24.523     0.200
     0.779    25.344     0.200
     0.788    25.164     0.200
     0.770    25.469     0.200
     0.788    25.477     0.200
     0.837    26.680     0.200
     0.860    27.586     0.200
     0.853    27.914     0.200
     0.870    29.000     0.200
     0.943    30.016     0.200
     0.959    31.148     0.200
     1.011    33.086     0.200
     1.050    33.836     0.200
     1.041    34.039     0.200
     1.085    35.258     0.200
     1.134    36.875     0.200
     1.248    39.523     0.200
     0.212     7.898     0.200
     0.763    24.219     0.200
     1.308    40.258     0.200
     1.404    43.438     0.200
     0.135     5.344     0.200
     0.134     6.008     0.200
     0.213     8.062     0.200
     0.289     9.719     0.200
     0.302    10.133     0.200
     0.312    10.805     0.200
     0.398    12.984     0.200
     0.489    15.961     0.200
     0.570    18.391     0.200
     0.578    18.781     0.200
     0.579    19.148     0.200
     0.596    19.234     0.200
     0.613    19.914     0.200
     0.713    23.031     0.200
     0.720    23.188     0.200
     0.725    23.188     0.200
     0.727    23.367     0.200
     0.733    23.711     0.200
     0.773    25.117     0.200
     0.787    25.750     0.200
     0.782    25.523     0.200
     0.810    26.102     0.200
     0.853    28.102     0.200
     0.892    28.961     0.200
     0.925    30.055     0.200
     0.969    31.305     0.200
     0.968    31.492     0.200
     0.988    31.805     0.200
     0.991    32.102     0.200
     0.996    32.555     0.200
     1.078    35.094     0.200
     1.090    35.508     0.200
     1.184    36.938     0.200
     1.248    39.914     0.200
     0.331    11.234     0.200
     0.320    11.008     0.200
     0.341    11.547     0.200
     0.358    12.094     0.200
     0.417    12.969     0.200
     0.409    13.609     0.200
     0.419    14.219     0.200
     0.459    15.555     0.200
     0.482    16.148     0.200
     0.527    17.570     0.200
     0.535    17.398     0.200
     0.616    20.234     0.200
     0.686    22.305     0.200
     0.687    22.750     0.200
     0.692    22.719     0.200
     0.744    24.016     0.200
     0.763    24.836     0.200
     0.787    26.055     0.200
     0.860    28.289     0.200
     0.868    28.219     0.200
     0.894    28.477     0.200
     0.868    28.141     0.200
     0.880    28.484     0.200
     0.917    29.938     0.200
     0.972    31.703     0.200
     0.994    32.344     0.200
     1.113    36.070     0.200
     1.595    50.977     0.200
     1.816    57.250     0.200
     1.920    60.195     0.200
     0.162     6.055     0.200
     0.230     8.398     0.200
     0.293     9.750     0.200
     0.306    11.141     0.200
     0.353    11.852     0.200
     0.379    12.445     0.200
     0.479    16.023     0.200
     0.588    19.133     0.200
     0.590    19.180     0.200
     0.578    19.359     0.200
     0.818    26.516     0.200
     0.857    27.695     0.200
     0.921    29.492     0.200
     1.043    33.719     0.200
     1.131    36.539     0.200
     0.108     4.928     0.200
     0.133     5.609     0.200
     0.229     8.199     0.200
     0.232     8.600     0.200
     0.343    11.738     0.200
     0.391    13.078     0.200
     0.466    14.988     0.200
     0.470    15.449     0.200
     0.460    15.279     0.200
     0.568    18.648     0.200
     0.594    19.809     0.200
     0.610    20.248     0.200
     0.641    20.699     0.200
     0.667    21.918     0.200
     0.711    22.818     0.200
     0.789    26.020     0.200
     0.797    25.859     0.200
     0.806    26.408     0.200
     0.813    26.408     0.200
     0.852    27.008     0.200
     0.920    29.809     0.200
     0.939    30.648     0.200
     0.979    31.879     0.200
     1.033    33.828     0.200
     1.166    37.629     0.200
     1.612    51.328     0.200
     1.815    57.139     0.200
     0.111     4.719     0.200
     0.135     5.906     0.200
     0.279     9.727     0.200
     0.317    10.219     0.200
     0.398    12.957     0.200
     0.480    15.379     0.200
     0.481    15.547     0.200
     0.521    16.797     0.200
     0.664    21.406     0.200
     0.733    23.336     0.200
     0.745    24.086     0.200
     0.783    25.129     0.200
     0.993    31.707     0.200
     1.153    37.078     0.200
     1.202    38.688     0.200
     1.829    57.078     0.200
     2.283    70.469     0.200
     2.400    73.648     0.200
     0.021     3.312     0.200
     0.173     6.672     0.200
     0.172     6.344     0.200
     0.271     9.445     0.200
     0.349    11.695     0.200
     0.447    14.961     0.200
     0.501    16.562     0.200
     0.517    16.984     0.200
     0.539    17.461     0.200
     0.552    17.875     0.200
     0.572    18.727     0.200
     0.219     7.684     0.200
     0.228     7.812     0.200
     0.281     9.551     0.200
     0.309    10.301     0.200
     0.342    11.684     0.200
     0.361    12.113     0.200
     0.385    12.660     0.200
     0.393    12.910     0.200
     0.524    16.391     0.200
     0.528    16.781     0.200
     0.561    17.863     0.200
     0.642    20.910     0.200
     0.653    21.352     0.200
     0.691    22.203     0.200
     0.703    22.613     0.200
     0.726    23.742     0.200
     0.886    29.203     0.200
     0.927    30.113     0.200
     1.052    34.152     0.200
     1.105    35.852     0.200
     1.144    37.062     0.200
     1.192    38.410     0.200
     1.926    61.090     0.200
     0.153     6.469     0.200
     0.156     7.336     0.200
     0.177     7.297     0.200
     0.204     7.547     0.200
     0.327    11.316     0.200
     0.422    13.836     0.200
     0.452    15.066     0.200
     0.449    15.188     0.200
     0.469    15.148     0.200
     0.475    15.676     0.200
     0.546    17.789     0.200
     0.601    19.797     0.200
     0.606    19.398     0.200
     0.613    20.828     0.200
     0.662    22.016     0.200
     0.688    22.238     0.200
     0.688    22.719     0.200
     0.731    23.727     0.200
     0.792    25.926     0.200
     0.874    26.887     0.200
     0.864    27.348     0.200
     0.874    28.266     0.200
     0.943    30.246     0.200
     0.071     3.102     0.200
     0.144     4.359     0.200
     0.141     5.539     0.200
     0.449    15.734     0.200
     0.481    15.461     0.200
     0.466    15.727     0.200
     0.451    15.211     0.200
     0.691    22.617     0.200
     0.735    23.195     0.200
     1.235    39.289     0.200
     1.412    44.820     0.200
     1.811    57.102     0.200
     1.980    62.586     0.200
     2.075    64.688     0.200
     0.017     4.556     0.200
     0.161     5.925     0.200
     0.223     7.905     0.200
     0.221     8.095     0.200
     0.322    11.275     0.200
     0.386    12.355     0.200
     0.445    14.186     0.200
     0.450    14.985     0.200
     0.449    14.855     0.200
     0.469    15.335     0.200
     0.585    19.186     0.200
     0.601    19.166     0.200
     0.639    20.786     0.200
     0.662    20.726     0.200
     0.678    21.425     0.200
     0.666    21.965     0.200
     0.719    23.605     0.200
     0.741    24.056     0.200
     0.734    23.945     0.200
     0.745    24.585     0.200
     0.743    23.835     0.200
     0.763    25.275     0.200
     0.818    26.246     0.200
     0.936    30.715     0.200
     1.046    33.615     0.200
     0.116     5.148     0.200
     0.172     7.379     0.200
     0.256     8.859     0.200
     0.275     9.000     0.200
     0.316    10.180     0.200
     0.365    12.141     0.200
     0.433    14.570     0.200
     0.467    15.531     0.200
     0.443    14.719     0.200
     0.479    14.660     0.200
     0.516    16.578     0.200
     0.624    19.980     0.200
     0.630    20.418     0.200
     0.660    20.418     0.200
     0.662    21.918     0.200
     0.685    21.980     0.200
     0.703    22.719     0.200
     0.702    22.391     0.200
     0.682    23.020     0.200
     0.790    25.750     0.200
     0.858    27.520     0.200
     0.879    28.301     0.200
     0.867    28.852     0.200
     0.913    30.379     0.200
     0.981    31.020     0.200
     1.005    32.508     0.200
     1.024    32.961     0.200
     1.364    42.301     0.200
     1.608    50.809     0.200
     1.627    50.898     0.200
     1.689    52.750     0.200
     0.621    19.730     0.200
     1.598    49.148     0.200
     2.392    70.141     0.200
     2.454    72.199     0.200
     2.474    73.750     0.200
     2.714    80.059     0.200
     0.169     5.865     0.200
     0.223     7.076     0.200
     0.308     9.486     0.200
     0.469    15.096     0.200
     0.463    14.896     0.200
     0.589    18.535     0.200
     0.607    19.455     0.200
     0.609    19.865     0.200
     0.643    21.365     0.200
     0.676    21.836     0.200
     0.717    22.396     0.200
     0.778    25.217     0.200
     0.160     4.891     0.200
     0.209     6.172     0.200
     0.228     7.750     0.200
     0.322    10.023     0.200
     0.311    11.266     0.200
     0.345    11.391     0.200
     0.333    11.422     0.200
     0.374    12.055     0.200
     0.448    15.039     0.200
     0.483    14.711     0.200
     0.576    18.570     0.200
     0.586    19.680     0.200
     0.635    20.156     0.200
     0.695    22.680     0.200
     0.704    23.023     0.200
     0.874    27.633     0.200
     0.886    29.695     0.200
     0.927    29.695     0.200
     0.174     5.840     0.200
     0.190     7.049     0.200
     0.264     8.520     0.200
     0.357    11.641     0.200
     0.362    11.750     0.200
     0.425    13.170     0.200
     0.447    14.820     0.200
     0.485    16.410     0.200
     0.602    19.359     0.200
     0.645    21.529     0.200
     0.773    24.799     0.200
     0.779    24.971     0.200
     0.780    25.439     0.200
     0.786    25.570     0.200
     0.792    25.279     0.200
     0.786    25.789     0.200
     0.827    26.789     0.200
     0.929    30.410     0.200
     1.024    33.289     0.200
     1.191    37.250     0.200
     0.226     7.750     0.200
     0.278     8.711     0.200
     0.387    12.398     0.200
     0.392    13.691     0.200
     0.407    13.680     0.200
     0.499    15.590     0.200
     0.571    18.539     0.200
     0.604    19.551     0.200
     0.658    21.191     0.200
     0.665    21.852     0.200
     0.745    24.730     0.200
     0.773    25.020     0.200
     0.775    24.172     0.200
     0.790    26.020     0.200
     0.796    25.660     0.200
     0.801    26.289     0.200
     0.807    26.250     0.200
     0.820    26.539     0.200
     1.044    33.828     0.200
     1.111    35.672     0.200
     1.202    38.070     0.200
     0.054     4.070     0.200
     0.123     5.367     0.200
     0.217     8.320     0.200
     0.226     7.461     0.200
     0.244     8.898     0.200
     0.244     9.172     0.200
     0.313    11.336     0.200
     0.362    12.422     0.200
     0.386    13.828     0.200
     0.395    13.438     0.200
     0.466    14.547     0.200
     0.626    20.766     0.200
     0.657    21.320     0.200
     0.676    22.047     0.200
     0.681    22.469     0.200
     0.749    24.672     0.200
     0.794    26.242     0.200
     0.796    26.008     0.200
     0.117     6.438     0.200
     0.144     6.836     0.200
     0.156     7.008     0.200
     0.164     7.164     0.200
     0.268    10.555     0.200
     0.342    12.281     0.200
     0.385    13.164     0.200
     0.450    14.945     0.200
     0.500    16.398     0.200
     0.550    17.914     0.200
     0.565    18.648     0.200
     0.591    19.844     0.200
     0.635    20.977     0.200
     0.650    21.172     0.200
     0.654    21.258     0.200
     0.659    21.414     0.200
     0.656    22.203     0.200
     0.704    22.727     0.200
     0.717    23.852     0.200
     0.727    23.547     0.200
     0.724    23.906     0.200
     0.735    24.117     0.200
     0.776    26.078     0.200
     0.798    25.953     0.200
     0.825    26.672     0.200
     0.875    28.305     0.200
     0.960    31.047     0.200
     1.224    37.617     0.200
     1.784    55.297     0.200
     1.949    59.273     0.200
     0.252     9.094     0.200
     0.348    11.324     0.200
     0.449    14.242     0.200
     0.424    14.691     0.200
     0.468    14.723     0.200
     0.480    15.230     0.200
     0.679    21.742     0.200
     0.679    21.742     0.200
     0.759    24.422     0.200
     0.812    25.824     0.200
     0.910    29.164     0.200
     0.953    29.902     0.200
     1.032    32.562     0.200
     1.126    36.004     0.200
     1.187    38.461     0.200
     1.246    39.492     0.200
     1.260    40.262     0.200
     1.298    40.824     0.200
     1.298    41.402     0.200
     1.765    55.922     0.200
     1.799    56.562     0.200
     1.969    61.832     0.200
     2.025    62.594     0.200
     2.136    66.664     0.200
     2.151    66.742     0.200
     2.264    70.172     0.200
     2.274    70.324     0.200
     2.385    73.012     0.200
     2.390    73.473     0.200
     2.441    74.562     0.200
     0.233     7.621     0.200
     0.252     9.242     0.200
     0.348    10.980     0.200
     0.468    14.883     0.200
     0.480    15.332     0.200
     0.679    21.863     0.200
     0.679    21.914     0.200
     0.678    21.062     0.200
     1.246    39.773     0.200
     1.298    40.801     0.200
     1.298    40.672     0.200
     1.969    61.973     0.200
     2.025    62.473     0.200
     2.151    66.902     0.200
     2.274    70.523     0.200
     2.385    73.453     0.200
     2.390    73.633     0.200
     2.441    75.004     0.200
     0.453    13.312     0.200
     1.415    43.824     0.200
     0.148     5.473     0.200
     0.249     8.160     0.200
     0.234     8.082     0.200
     0.313     9.812     0.200
     0.320    10.434     0.200
     0.396    12.230     0.200
     0.467    14.812     0.200
     0.484    15.383     0.200
     0.494    15.781     0.200
     0.511    15.934     0.200
     0.520    16.992     0.200
     0.598    18.773     0.200
     0.636    20.652     0.200
     0.645    20.191     0.200
     0.649    20.543     0.200
     0.684    23.184     0.200
     0.694    22.723     0.200
     0.741    23.434     0.200
     0.745    23.754     0.200
     0.764    24.594     0.200
     0.756    24.570     0.200
     0.779    24.660     0.200
     0.811    25.973     0.200
     0.868    28.102     0.200
     0.910    29.051     0.200
     0.977    31.703     0.200
     0.996    32.883     0.200
     1.029    33.531     0.200
     1.038    34.102     0.200
     1.172    36.922     0.200
     1.149    37.461     0.200
     1.161    37.543     0.200
     1.270    40.621     0.200
     0.248     8.781     0.200
     0.252     8.742     0.200
     0.297     9.961     0.200
     0.339    11.320     0.200
     0.373    12.453     0.200
     0.370    12.344     0.200
     0.495    15.531     0.200
     0.501    16.156     0.200
     0.540    17.227     0.200
     0.548    17.656     0.200
     0.572    18.297     0.200
     0.574    18.516     0.200
     0.570    18.734     0.200
     0.663    21.523     0.200
     0.657    21.352     0.200
     0.673    21.820     0.200
     0.746    24.602     0.200
     0.780    25.094     0.200
     0.823    25.906     0.200
     0.868    28.477     0.200
     0.870    28.477     0.200
     0.905    29.062     0.200
     1.016    33.086     0.200
     1.026    33.312     0.200
     1.082    34.914     0.200
     1.123    36.312     0.200
     1.166    37.531     0.200
     1.188    38.414     0.200
     1.666    53.406     0.200
     1.676    53.164     0.200
     1.897    59.492     0.200
     2.010    63.453     0.200
     0.565    16.914     0.200
     0.667    21.742     0.200
     0.055     4.348     0.200
     0.217     8.277     0.200
     0.256     8.559     0.200
     0.220     8.445     0.200
     0.297     9.918     0.200
     0.404    13.617     0.200
     0.440    14.438     0.200
     0.436    14.336     0.200
     0.558    18.059     0.200
     0.641    20.918     0.200
     0.683    21.848     0.200
     0.909    29.258     0.200
     1.105    35.367     0.200
     1.727    54.316     0.200
     2.102    64.797     0.200
     2.178    66.996     0.200
     2.296    70.457     0.200
     0.287    10.000     0.200
     0.300     9.602     0.200
     0.306    10.008     0.200
     0.359    11.570     0.200
     0.359    11.578     0.200
     0.435    14.602     0.200
     0.464    14.914     0.200
     0.512    16.133     0.200
     0.523    16.914     0.200
     0.529    17.203     0.200
     0.723    23.711     0.200
     0.797    26.070     0.200
     0.836    26.984     0.200
     1.081    35.180     0.200
     0.148     5.995     0.200
     0.239     8.976     0.200
     0.394    13.336     0.200
     0.422    13.865     0.200
     0.504    16.346     0.200
     0.544    18.226     0.200
     0.562    18.596     0.200
     0.605    19.605     0.200
     0.629    20.355     0.200
     0.737    23.596     0.200
     0.793    25.696     0.200
     0.975    31.526     0.200
     1.250    40.055     0.200
     0.113     5.188     0.200
     0.137     5.516     0.200
     0.177     6.438     0.200
     0.242     8.414     0.200
     0.328    10.758     0.200
     0.374    11.766     0.200
     0.480    15.055     0.200
     0.479    15.648     0.200
     0.492    16.164     0.200
     0.579    18.867     0.200
     0.614    19.914     0.200
     0.610    19.844     0.200
     0.662    22.039     0.200
     0.668    22.016     0.200
     0.693    22.875     0.200
     0.703    23.336     0.200
     0.721    23.594     0.200
     0.727    23.008     0.200
     0.738    23.906     0.200
     0.748    24.305     0.200
     0.749    24.258     0.200
     0.781    25.336     0.200
     0.821    26.555     0.200
     0.846    27.359     0.200
     0.965    30.898     0.200
     1.021    33.094     0.200
     1.025    33.398     0.200
     1.103    35.750     0.200
     1.140    37.016     0.200
     1.164    37.500     0.200
     0.688    22.789     0.200
     0.608    19.150     0.200
     0.163     5.590     0.200
     0.206     7.400     0.200
     0.236     7.699     0.200
     0.316    10.490     0.200
     0.332    11.020     0.200
     0.384    12.480     0.200
     0.393    12.070     0.200
     0.404    13.209     0.200
     0.435    13.369     0.200
     0.439    14.811     0.200
     0.447    14.260     0.200
     0.567    18.850     0.200
     0.574    18.650     0.200
     0.590    19.189     0.200
     0.652    20.619     0.200
     0.653    20.939     0.200
     0.665    21.420     0.200
     0.725    23.730     0.200
     0.722    23.260     0.200
     0.729    24.070     0.200
     0.771    24.920     0.200
     0.813    27.199     0.200
     0.813    25.949     0.200
     0.908    29.721     0.200
     0.950    30.359     0.200
     0.952    31.490     0.200
     0.987    32.289     0.200
     1.148    36.629     0.200
     1.720    56.141     0.200
     1.769    56.779     0.200
     1.800    57.279     0.200
     1.924    61.990     0.200
     0.582    17.789     0.200
     0.677    20.980     0.200
     2.532    76.619     0.200
     2.852    84.680     0.200
     0.211     6.598     0.200
     0.244     7.770     0.200
     0.293    10.199     0.200
     0.326    10.418     0.200
     0.363    12.367     0.200
     0.391    12.418     0.200
     0.433    14.430     0.200
     0.588    18.699     0.200
     0.602    19.117     0.200
     0.661    21.137     0.200
     0.702    23.027     0.200
     0.718    23.098     0.200
     0.887    28.656     0.200
     0.879    29.418     0.200
     0.888    28.859     0.200
     0.946    30.930     0.200
     1.016    33.156     0.200
     1.179    38.457     0.200
     0.341    11.535     0.200
     0.371    12.545     0.200
     0.361    12.425     0.200
     0.415    13.775     0.200
     0.407    13.895     0.200
     0.463    15.225     0.200
     0.484    16.215     0.200
     0.501    16.145     0.200
     0.512    16.895     0.200
     0.529    17.795     0.200
     0.582    18.935     0.200
     0.648    20.845     0.200
     0.679    22.885     0.200
     0.667    21.945     0.200
     0.678    22.235     0.200
     0.711    22.775     0.200
     0.758    24.695     0.200
     0.763    24.285     0.200
     0.830    27.105     0.200
     0.845    26.915     0.200
     0.843    27.395     0.200
     0.905    29.755     0.200
     0.942    30.765     0.200
     0.961    31.835     0.200
     1.065    34.675     0.200
     1.084    34.555     0.200
     1.692    53.845     0.200
     1.779    55.775     0.200
     1.796    56.675     0.200
     1.903    59.765     0.200
     0.146     7.471     0.200
     0.159     7.699     0.200
     0.180     7.730     0.200
     0.192     8.580     0.200
     0.325    11.461     0.200
     0.330    11.500     0.200
     0.406    13.750     0.200
     0.501    16.529     0.200
     0.580    19.301     0.200
     0.589    19.270     0.200
     0.601    20.041     0.200
     0.620    21.311     0.200
     0.636    20.541     0.200
     0.721    23.291     0.200
     0.730    23.480     0.200
     0.733    23.420     0.200
     0.702    23.699     0.200
     0.738    24.471     0.200
     0.758    24.570     0.200
     0.772    25.131     0.200
     0.782    25.461     0.200
     0.875    28.580     0.200
     0.914    29.490     0.200
     0.959    30.750     0.200
     0.992    31.461     0.200
     0.986    31.400     0.200
     0.184     6.769     0.200
     0.244     8.229     0.200
     0.256     9.249     0.200
     0.302     9.839     0.200
     0.291    10.519     0.200
     0.372    12.099     0.200
     0.394    13.169     0.200
     0.406    13.399     0.200
     0.424    13.679     0.200
     0.485    14.929     0.200
     0.493    14.989     0.200
     0.519    16.119     0.200
     0.642    20.549     0.200
     0.635    20.049     0.200
     0.687    21.889     0.200
     0.721    23.609     0.200
     0.829    26.539     0.200
     0.860    27.859     0.200
     0.850    28.009     0.200
     0.962    30.869     0.200
     1.031    33.189     0.200
     1.147    36.829     0.200
     0.099     6.016     0.200
     0.156     7.117     0.200
     0.185     7.555     0.200
     0.206     8.188     0.200
     0.312    10.547     0.200
     0.355    12.484     0.200
     0.357    12.000     0.200
     0.529    17.664     0.200
     0.549    17.641     0.200
     0.615    20.047     0.200
     0.622    20.602     0.200
     0.670    21.727     0.200
     0.679    22.797     0.200
     0.690    22.461     0.200
     0.741    23.797     0.200
     0.805    26.344     0.200
     0.811    26.891     0.200
     0.824    26.633     0.200
     0.845    27.945     0.200
     0.882    28.516     0.200
     0.888    29.234     0.200
     0.940    30.383     0.200
     0.176     6.469     0.200
     0.242     8.484     0.200
     0.251     9.430     0.200
     0.296    10.336     0.200
     0.286    10.398     0.200
     0.382    12.758     0.200
     0.391    13.406     0.200
     0.402    13.484     0.200
     0.438    14.062     0.200
     0.484    16.242     0.200
     0.480    16.078     0.200
     0.633    20.812     0.200
     0.633    20.812     0.200
     0.644    21.547     0.200
     0.650    21.305     0.200
     0.676    21.828     0.200
     0.674    21.664     0.200
     0.734    23.906     0.200
     0.789    24.984     0.200
     0.797    26.227     0.200
     0.816    26.562     0.200
     0.834    27.227     0.200
     0.851    27.703     0.200
     0.923    30.023     0.200
     0.967    31.664     0.200
     0.974    31.633     0.200
     1.035    33.797     0.200
     1.043    34.156     0.200
     1.610    51.586     0.200
     0.079     3.242     0.200
     0.182     6.984     0.200
     0.265     8.680     0.200
     0.304     9.922     0.200
     0.337    11.320     0.200
     0.399    13.414     0.200
     0.497    16.172     0.200
     0.528    17.039     0.200
     0.582    19.406     0.200
     0.683    22.305     0.200
     0.742    23.953     0.200
     0.749    24.672     0.200
     0.795    25.773     0.200
     1.007    33.156     0.200
     1.237    40.273     0.200
     1.255    40.516     0.200
     1.289    41.906     0.200
     1.839    58.789     0.200
     1.911    60.281     0.200
     1.924    61.203     0.200
     1.962    61.883     0.200
     1.985    62.852     0.200
     2.008    64.141     0.200
     2.101    65.992     0.200
     2.178    68.992     0.200
     2.302    72.156     0.200
     2.395    74.805     0.200
     0.081     8.891     0.200
     0.140     8.297     0.200
     0.212    10.086     0.200
     0.290    11.695     0.200
     0.334    12.617     0.200
     0.344    12.531     0.200
     0.310    11.945     0.200
     0.311    12.367     0.200
     0.399    13.883     0.200
     0.438    15.156     0.200
     0.476    16.359     0.200
     0.558    18.797     0.200
     0.616    20.656     0.200
     0.639    20.570     0.200
     0.754    24.227     0.200
     0.860    27.422     0.200
     0.894    28.258     0.200
     0.964    30.047     0.200
     0.972    30.398     0.200
     1.018    31.531     0.200
     1.334    41.156     0.200
     1.367    42.766     0.200
     1.408    44.359     0.200
     1.540    47.352     0.200
     1.632    50.148     0.200
     1.675    50.852     0.200
     1.830    55.492     0.200
     2.018    60.859     0.200
     2.059    61.570     0.200
     2.063    61.680     0.200
     2.067    62.398     0.200
     2.263    67.547     0.200
     2.286    68.141     0.200
     1.680    53.133     0.200
     0.062     3.297     0.200
     0.116     4.664     0.200
     0.178     5.766     0.200
     0.197     6.680     0.200
     0.185     6.883     0.200
     0.233     8.438     0.200
     0.322    11.430     0.200
     0.353    12.273     0.200
     0.369    11.609     0.200
     0.381    13.133     0.200
     0.433    14.148     0.200
     0.436    14.953     0.200
     0.481    15.617     0.200
     0.505    16.055     0.200
     0.513    17.617     0.200
     0.533    18.125     0.200
     0.608    19.500     0.200
     0.631    19.945     0.200
     0.677    21.719     0.200
     0.701    22.297     0.200
     0.701    22.375     0.200
     0.681    22.836     0.200
     0.761    24.398     0.200
     0.849    27.312     0.200
     0.874    27.953     0.200
     0.886    28.406     0.200
     0.939    30.234     0.200
     0.969    31.586     0.200
     1.082    34.734     0.200
     1.180    37.969     0.200
     1.705    53.766     0.200
     1.794    56.398     0.200
     1.810    56.945     0.200
     1.847    57.977     0.200
     2.216    68.535     0.200
     0.076     4.695     0.200
     0.187     6.348     0.200
     0.225     7.207     0.200
     0.245     9.438     0.200
     0.373    11.918     0.200
     0.363    12.867     0.200
     0.444    14.355     0.200
     0.522    16.688     0.200
     0.528    17.316     0.200
     0.564    18.195     0.200
     0.605    18.938     0.200
     0.662    21.285     0.200
     0.707    22.395     0.200
     0.933    29.766     0.200
     0.958    30.777     0.200
     0.994    31.707     0.200
     1.031    33.195     0.200
     1.248    39.895     0.200
     2.039    63.105     0.200
     2.053    63.797     0.200
     2.063    63.758     0.200
     2.117    65.418     0.200
     2.179    67.508     0.200
     2.321    71.258     0.200
     0.628    20.859     0.200
     0.120     5.312     0.200
     0.159     6.445     0.200
     0.215     7.516     0.200
     0.241     8.133     0.200
     0.330    11.562     0.200
     0.360    12.117     0.200
     0.388    13.297     0.200
     0.448    14.586     0.200
     0.547    18.180     0.200
     0.606    20.258     0.200
     0.709    23.188     0.200
     0.722    23.289     0.200
     0.746    24.406     0.200
     0.936    30.227     0.200
     0.990    31.984     0.200
     0.984    31.898     0.200
     1.007    33.016     0.200
     1.045    33.797     0.200
     1.080    34.898     0.200
     1.190    38.258     0.200
     1.630    51.430     0.200
     1.677    52.836     0.200
     1.787    56.180     0.200
     1.839    57.836     0.200
     1.869    58.484     0.200
     1.904    59.766     0.200
     1.930    60.180     0.200
     1.955    61.703     0.200
     2.042    63.539     0.200
     2.104    65.812     0.200
     2.120    65.836     0.200
     2.243    69.195     0.200
     2.340    72.148     0.200
     2.453    74.766     0.200
     0.111     5.182     0.200
     0.173     7.432     0.200
     0.226     8.102     0.200
     0.242     8.542     0.200
     0.371    12.512     0.200
     0.402    13.942     0.200
     0.559    18.642     0.200
     0.618    20.682     0.200
     0.641    21.372     0.200
     0.652    20.962     0.200
     0.721    23.542     0.200
     0.987    32.592     0.200
     1.877    58.762     0.200
     1.964    61.402     0.200
     2.348    71.992     0.200
     2.461    75.092     0.200
     0.349    12.039     0.200
     0.395    12.500     0.200
     0.458    14.656     0.200
     0.484    15.930     0.200
     0.487    15.438     0.200
     0.598    19.430     0.200
     0.617    19.273     0.200
     0.648    21.133     0.200
     0.676    22.047     0.200
     0.680    21.719     0.200
     0.693    22.844     0.200
     0.724    23.430     0.200
     0.743    24.227     0.200
     0.750    24.734     0.200
     0.778    24.836     0.200
     0.798    26.914     0.200
     0.830    26.594     0.200
     0.883    28.609     0.200
     0.943    30.438     0.200
     1.051    33.898     0.200
     0.086     5.914     0.200
     0.095     5.504     0.200
     0.093     5.426     0.200
     0.179     7.605     0.200
     0.254     9.496     0.200
     0.269     9.484     0.200
     0.265     9.914     0.200
     0.345    12.145     0.200
     0.410    14.285     0.200
     0.446    14.895     0.200
     0.481    16.113     0.200
     0.094     5.410     0.200
     0.086     5.629     0.200
     0.096     5.262     0.200
     0.177     7.301     0.200
     0.256     9.180     0.200
     0.267     9.449     0.200
     0.267     9.742     0.200
     0.407    14.141     0.200
     0.444    14.910     0.200
     0.479    16.062     0.200
     0.817    27.629     0.200
     0.979    31.469     0.200
     0.223     8.281     0.200
     0.310    10.836     0.200
     0.337    11.961     0.200
     0.343    12.023     0.200
     0.350    12.102     0.200
     0.426    13.211     0.200
     0.414    14.148     0.200
     0.474    16.688     0.200
     0.522    16.891     0.200
     0.552    17.773     0.200
     0.644    20.609     0.200
     0.692    22.406     0.200
     0.752    23.781     0.200
     0.778    24.898     0.200
     0.782    25.211     0.200
     0.855    28.773     0.200
     0.874    27.961     0.200
     1.120    35.359     0.200
     1.155    36.508     0.200
     1.826    57.453     0.200
     0.107     4.523     0.200
     0.246     8.469     0.200
     0.264     9.227     0.200
     0.278     9.922     0.200
     0.290    10.227     0.200
     0.326    11.508     0.200
     0.354    11.844     0.200
     0.367    12.406     0.200
     0.399    13.406     0.200
     0.491    15.328     0.200
     0.529    17.156     0.200
     0.560    18.227     0.200
     0.658    21.695     0.200
     0.668    21.133     0.200
     0.852    27.547     0.200
     0.097     4.082     0.200
     0.134     4.609     0.200
     0.121     4.680     0.200
     0.210     8.582     0.200
     0.306    10.379     0.200
     0.412    13.480     0.200
     0.401    13.531     0.200
     0.447    14.941     0.200
     0.425    15.121     0.200
     0.469    14.652     0.200
     0.709    22.820     0.200
     0.742    23.539     0.200
     1.031    33.070     0.200
     0.130     4.324     0.200
     0.101     3.965     0.200
     0.123     4.516     0.200
     0.233     7.645     0.200
     0.214     8.375     0.200
     0.303     9.914     0.200
     0.363    11.727     0.200
     0.386    12.625     0.200
     0.465    14.875     0.200
     0.587    18.484     0.200
     0.731    22.914     0.200
     0.109     3.367     0.200
     0.098     3.812     0.200
     0.186     6.648     0.200
     0.266     9.039     0.200
     0.319    10.477     0.200
     0.284    10.461     0.200
     0.323    10.609     0.200
     0.352    11.391     0.200
     0.441    13.617     0.200
     0.430    14.156     0.200
     0.456    14.969     0.200
     0.478    15.391     0.200
     0.515    15.383     0.200
     0.490    17.242     0.200
     0.504    16.852     0.200
     0.586    19.570     0.200
     0.666    20.352     0.200
     0.702    22.547     0.200
     0.737    23.148     0.200
     0.937    29.969     0.200
     0.974    30.617     0.200
     1.007    31.430     0.200
     1.012    31.781     0.200
     1.036    33.250     0.200
     1.079    34.180     0.200
     1.193    37.742     0.200
     1.217    39.438     0.200
     1.408    45.086     0.200
     1.758    56.156     0.200
     1.768    55.812     0.200
     1.824    58.141     0.200
     1.884    59.758     0.200
     1.930    61.086     0.200
     2.022    63.758     0.200
     2.032    63.242     0.200
     2.081    65.078     0.200
     2.091    65.789     0.200
     0.106     3.672     0.200
     0.102     3.859     0.200
     0.190     6.859     0.200
     0.314    10.289     0.200
     0.289    10.531     0.200
     0.322    10.680     0.200
     0.349    10.945     0.200
     0.436    13.844     0.200
     0.429    14.320     0.200
     0.479    15.703     0.200
     0.509    15.648     0.200
     0.495    17.195     0.200
     0.510    16.969     0.200
     0.660    20.734     0.200
     2.017    63.445     0.200
     0.104     5.029     0.200
     0.235     8.420     0.200
     0.251     8.721     0.200
     0.285     9.930     0.200
     0.263     9.311     0.200
     0.318    10.930     0.200
     0.368    11.850     0.200
     0.351    12.490     0.200
     0.369    12.301     0.200
     0.388    12.660     0.200
     0.438    14.850     0.200
     0.510    15.629     0.200
     0.518    15.980     0.200
     0.485    16.199     0.200
     0.563    17.641     0.200
     0.578    17.891     0.200
     0.580    18.330     0.200
     0.588    19.570     0.200
     0.642    21.619     0.200
     0.792    25.240     0.200
     0.807    26.029     0.200
     0.848    27.699     0.200
     0.872    27.539     0.200
     0.887    27.801     0.200
     1.195    38.039     0.200
     1.760    55.730     0.200
     0.187     6.734     0.200
     0.303    10.414     0.200
     0.345    11.703     0.200
     0.369    12.352     0.200
     0.403    13.570     0.200
     0.428    14.570     0.200
     0.479    15.648     0.200
     0.514    17.234     0.200
     0.574    18.398     0.200
     0.594    18.828     0.200
     0.634    20.648     0.200
     0.698    22.398     0.200
     0.721    23.688     0.200
     0.739    23.711     0.200
     0.813    26.430     0.200
     0.821    26.508     0.200
     0.843    27.391     0.200
     0.881    28.992     0.200
     0.904    29.000     0.200
     0.969    31.984     0.200
     1.008    32.414     0.200
     1.124    36.422     0.200
     1.195    38.531     0.200
     1.758    56.578     0.200
     0.105     5.445     0.200
     0.113     5.285     0.200
     0.254     9.146     0.200
     0.335    12.066     0.200
     0.338    11.166     0.200
     0.359    11.365     0.200
     0.378    12.686     0.200
     0.477    14.926     0.200
     0.482    15.477     0.200
     0.528    16.846     0.200
     0.574    18.467     0.200
     0.591    19.176     0.200
     0.612    19.875     0.200
     0.630    19.936     0.200
     0.710    22.615     0.200
     0.749    24.006     0.200
     0.835    27.236     0.200
     0.923    29.887     0.200
     1.066    34.285     0.200
     0.011     4.828     0.200
     0.093     5.086     0.200
     0.159     6.672     0.200
     0.172     6.766     0.200
     0.220     7.734     0.200
     0.326    11.328     0.200
     0.343    11.594     0.200
     0.457    14.852     0.200
     0.458    14.539     0.200
     0.464    15.375     0.200
     0.489    16.344     0.200
     0.489    16.117     0.200
     0.604    19.266     0.200
     0.600    19.094     0.200
     0.620    19.492     0.200
     0.654    22.414     0.200
     0.677    21.312     0.200
     0.672    21.508     0.200
     0.685    21.562     0.200
     0.748    24.062     0.200
     0.758    24.688     0.200
     0.756    24.742     0.200
     0.783    24.547     0.200
     0.804    26.492     0.200
     0.837    26.625     0.200
     1.048    33.438     0.200
     0.165     6.023     0.200
     0.220     7.438     0.200
     0.275     9.422     0.200
     0.270     9.594     0.200
     0.283     9.172     0.200
     0.379    11.914     0.200
     0.441    13.969     0.200
     0.538    17.727     0.200
     0.570    18.609     0.200
     0.621    19.547     0.200
     0.694    22.117     0.200
     0.697    21.664     0.200
     0.715    22.586     0.200
     0.812    26.383     0.200
     0.830    26.445     0.200
     0.842    27.562     0.200
     0.861    27.367     0.200
     0.854    27.375     0.200
     0.865    27.289     0.200
     0.898    28.789     0.200
     0.914    29.359     0.200
     0.960    31.508     0.200
     0.995    32.336     0.200
     1.017    32.914     0.200
     0.687    22.844     0.200
     0.150     6.883     0.200
     0.287    10.758     0.200
     0.297    10.938     0.200
     0.293    10.758     0.200
     0.308    11.516     0.200
     0.344    12.367     0.200
     0.360    12.797     0.200
     0.420    14.766     0.200
     0.532    17.742     0.200
     0.534    17.539     0.200
     0.614    20.844     0.200
     0.660    21.289     0.200
     0.710    23.344     0.200
     0.784    25.734     0.200
     0.830    26.375     0.200
     0.843    27.164     0.200
     0.687    22.114     0.200
     0.150     6.574     0.200
     0.287    10.264     0.200
     0.308    11.274     0.200
     0.298    10.224     0.200
     0.345    12.154     0.200
     0.360    12.334     0.200
     0.447    13.594     0.200
     0.457    14.594     0.200
     0.451    14.764     0.200
     0.532    17.264     0.200
     0.533    17.104     0.200
     0.527    16.984     0.200
     0.549    17.794     0.200
     0.589    19.984     0.200
     0.615    20.564     0.200
     0.610    20.114     0.200
     0.659    21.204     0.200
     0.710    23.194     0.200
     0.784    25.684     0.200
     0.800    25.564     0.200
     0.830    26.104     0.200
     0.817    26.454     0.200
     0.820    27.624     0.200
     0.843    27.414     0.200
     0.871    27.894     0.200
     0.966    31.534     0.200
     0.984    32.084     0.200
     1.047    33.164     0.200
     1.090    34.934     0.200
     1.141    36.654     0.200
     1.850    58.134     0.200
     1.960    61.874     0.200
     0.546    17.264     0.200
     0.609    18.734     0.200
     0.710    22.924     0.200
     0.097     5.828     0.200
     0.152     7.469     0.200
     0.204     8.168     0.200
     0.215     8.219     0.200
     0.264     9.449     0.200
     0.321    11.098     0.200
     0.348    11.719     0.200
     0.427    14.977     0.200
     0.414    13.680     0.200
     0.481    16.258     0.200
     0.544    17.539     0.200
     0.620    21.219     0.200
     0.637    21.598     0.200
     0.632    20.758     0.200
     0.666    21.707     0.200
     0.667    21.777     0.200
     0.669    21.609     0.200
     0.694    22.680     0.200
     0.768    25.078     0.200
     0.792    25.598     0.200
     0.812    26.527     0.200
     0.818    27.098     0.200
     0.854    27.648     0.200
     0.879    28.797     0.200
     0.939    30.398     0.200
     1.104    34.660     0.200
     1.856    58.242     0.200
     0.083     5.242     0.200
     0.166     6.812     0.200
     0.248     8.715     0.200
     0.255     9.434     0.200
     0.249     9.352     0.200
     0.332    11.215     0.200
     0.378    12.395     0.200
     0.418    13.992     0.200
     0.441    13.562     0.200
     0.420    14.555     0.200
     0.491    16.672     0.200
     0.543    18.574     0.200
     0.592    18.934     0.200
     0.576    19.672     0.200
     0.622    21.312     0.200
     0.674    22.195     0.200
     0.882    27.992     0.200
     0.904    28.383     0.200
     0.959    31.395     0.200
     0.605    20.941     0.200
     0.137     5.832     0.200
     0.133     5.301     0.200
     0.202     6.770     0.200
     0.245     8.562     0.200
     0.309    10.852     0.200
     0.337    11.391     0.200
     0.365    11.961     0.200
     0.524    17.160     0.200
     0.584    19.730     0.200
     0.625    19.930     0.200
     0.692    22.812     0.200
     0.853    27.371     0.200
     0.088     4.306     0.200
     0.158     5.636     0.200
     0.174     6.186     0.200
     0.182     7.096     0.200
     0.210     7.785     0.200
     0.298    10.296     0.200
     0.361    12.306     0.200
     0.435    14.046     0.200
     0.424    13.676     0.200
     0.453    14.766     0.200
     0.524    16.516     0.200
     0.551    18.396     0.200
     0.608    19.735     0.200
     0.647    19.766     0.200
     0.624    20.615     0.200
     0.732    24.096     0.200
     0.949    31.256     0.200
     1.011    32.535     0.200
     1.030    32.945     0.200
     1.659    53.516     0.200
     0.006     4.824     0.200
     0.150     7.094     0.200
     0.179     7.074     0.200
     0.192     7.504     0.200
     0.221     8.504     0.200
     0.266    10.082     0.200
     0.275     9.762     0.200
     0.349    11.965     0.200
     0.457    15.043     0.200
     0.473    15.332     0.200
     0.542    18.262     0.200
     0.607    20.043     0.200
     0.716    22.715     0.200
     1.204    37.852     0.200
     0.120     5.242     0.200
     0.129     5.102     0.200
     0.179     6.539     0.200
     0.250     8.430     0.200
     0.296    10.391     0.200
     0.323    10.766     0.200
     0.476    14.984     0.200
     0.484    15.469     0.200
     0.492    16.742     0.200
     0.571    18.273     0.200
     0.610    19.883     0.200
     0.612    19.500     0.200
     0.656    21.484     0.200
     0.673    22.312     0.200
     0.700    23.125     0.200
     0.709    23.281     0.200
     0.713    23.133     0.200
     0.719    22.672     0.200
     0.743    24.312     0.200
     0.779    26.320     0.200
     0.826    27.219     0.200
     0.101     4.293     0.200
     0.165     5.461     0.200
     0.175     5.863     0.200
     0.206     6.742     0.200
     0.285     9.703     0.200
     0.493    15.723     0.200
     0.491    15.750     0.200
     0.528    16.672     0.200
     0.623    19.941     0.200
     0.736    23.910     0.200
     0.104     6.039     0.200
     0.144     7.016     0.200
     0.213     8.516     0.200
     0.211     9.047     0.200
     0.294    10.688     0.200
     0.349    13.133     0.200
     0.377    13.117     0.200
     0.394    13.227     0.200
     0.488    15.992     0.200
     0.486    16.906     0.200
     0.500    16.578     0.200
     0.521    17.445     0.200
     0.542    17.766     0.200
     0.568    18.562     0.200
     0.573    18.617     0.200
     0.641    20.664     0.200
     0.637    20.812     0.200
     0.711    23.742     0.200
     0.724    23.562     0.200
     0.755    24.523     0.200
     0.764    25.016     0.200
     0.776    24.969     0.200
     0.840    27.289     0.200
     0.862    27.992     0.200
     0.121     4.684     0.200
     0.151     5.984     0.200
     0.214     7.234     0.200
     0.247     8.434     0.200
     0.324    10.703     0.200
     0.348    11.363     0.200
     0.380    12.723     0.200
     0.447    14.184     0.200
     0.536    17.422     0.200
     0.595    19.684     0.200
     0.637    20.832     0.200
     0.745    24.121     0.200
     0.867    28.543     0.200
     0.936    30.934     0.200
     0.969    31.582     0.200
     0.997    33.062     0.200
     1.188    38.492     0.200
     1.862    59.582     0.200
     1.906    60.562     0.200
     2.122    66.441     0.200
     2.246    70.883     0.200
     2.341    72.863     0.200
     2.455    75.594     0.200
     0.081     4.602     0.200
     0.206     6.906     0.200
     0.224     7.461     0.200
     0.218     7.938     0.200
     0.275     9.750     0.200
     0.422    14.352     0.200
     0.459    15.438     0.200
     0.492    16.320     0.200
     0.512    16.320     0.200
     0.632    20.211     0.200
     0.671    21.461     0.200
     0.843    27.875     0.200
     0.931    29.695     0.200
     0.082     4.125     0.200
     0.202     8.016     0.200
     0.258     9.195     0.200
     0.264     9.133     0.200
     0.374    12.477     0.200
     0.387    13.188     0.200
     0.429    14.672     0.200
     0.490    15.773     0.200
     0.577    18.922     0.200
     0.634    20.641     0.200
     0.664    22.242     0.200
     0.684    22.242     0.200
     0.752    24.406     0.200
     0.765    24.336     0.200
     0.787    25.852     0.200
     0.915    29.766     0.200
     0.956    31.086     0.200
     1.020    33.023     0.200
     1.088    35.227     0.200
     1.114    36.016     0.200
     1.232    39.070     0.200
     1.346    42.602     0.200
     1.907    59.641     0.200
     1.939    61.242     0.200
     1.994    62.742     0.200
     0.079     5.172     0.200
     0.209     8.343     0.200
     0.263     9.632     0.200
     0.265     9.473     0.200
     0.395    13.132     0.200
     0.437    15.192     0.200
     0.584    19.553     0.200
     0.641    21.702     0.200
     0.672    22.433     0.200
     0.758    24.843     0.200
     0.979    30.513     0.200
     1.094    35.332     0.200
     1.998    62.032     0.200
     2.381    72.103     0.200
     0.150     6.340     0.200
     0.153     6.200     0.200
     0.153     6.819     0.200
     0.203     7.340     0.200
     0.294    10.100     0.200
     0.376    12.540     0.200
     0.376    12.990     0.200
     0.394    13.069     0.200
     0.575    18.530     0.200
     0.571    18.920     0.200
     0.634    21.620     0.200
     0.646    20.800     0.200
     0.636    21.210     0.200
     0.671    22.280     0.200
     0.688    22.330     0.200
     0.855    27.149     0.200
     0.897    29.770     0.200
     0.914    29.189     0.200
     0.956    30.859     0.200
     0.997    32.520     0.200
     1.817    57.040     0.200
     2.023    62.800     0.200
     2.256    68.960     0.200
     0.399    12.790     0.200
     1.813    57.990     0.200
     0.012     4.465     0.200
     0.114     5.395     0.200
     0.158     6.305     0.200
     0.233     8.365     0.200
     0.310    11.006     0.200
     0.347    11.766     0.200
     0.375    12.045     0.200
     0.460    14.805     0.200
     0.468    15.436     0.200
     0.461    14.686     0.200
     0.473    15.756     0.200
     0.591    19.055     0.200
     0.600    19.625     0.200
     0.655    21.666     0.200
     0.679    22.045     0.200
     0.685    22.836     0.200
     0.723    23.555     0.200
     0.731    23.605     0.200
     0.737    24.305     0.200
     0.731    24.115     0.200
     0.764    25.115     0.200
     0.802    26.805     0.200
     0.824    26.426     0.200
     0.826    26.686     0.200
     0.895    29.006     0.200
     0.974    31.115     0.200
     1.015    33.035     0.200
     1.141    35.996     0.200
     0.133     5.223     0.200
     0.116     5.043     0.200
     0.184     5.691     0.200
     0.237     8.703     0.200
     0.269     8.992     0.200
     0.279     9.562     0.200
     0.285    10.383     0.200
     0.315    11.172     0.200
     0.410    13.703     0.200
     0.432    14.523     0.200
     0.484    15.551     0.200
     0.494    15.551     0.200
     0.515    16.031     0.200
     0.565    17.812     0.200
     0.574    18.102     0.200
     0.569    18.672     0.200
     0.752    25.152     0.200
     1.065    33.742     0.200
     1.651    52.102     0.200
     1.676    53.523     0.200
     0.034     4.742     0.200
     0.122     5.441     0.200
     0.194     7.441     0.200
     0.258     8.824     0.200
     0.291    10.684     0.200
     0.308    10.145     0.200
     0.365    12.305     0.200
     0.567    18.254     0.200
     0.621    19.984     0.200
     0.627    20.375     0.200
     0.661    21.473     0.200
     0.688    22.863     0.200
     0.709    22.375     0.200
     0.710    22.484     0.200
     0.715    22.902     0.200
     0.713    23.082     0.200
     0.723    24.164     0.200
     0.841    27.672     0.200
     0.865    27.863     0.200
     0.986    31.453     0.200
     1.004    32.113     0.200
     0.030     4.930     0.200
     0.113     5.668     0.200
     0.195     7.621     0.200
     0.250     9.168     0.200
     0.300    10.828     0.200
     0.311    10.379     0.200
     0.374    12.500     0.200
     0.444    14.688     0.200
     0.492    15.938     0.200
     0.496    16.270     0.200
     0.576    18.777     0.200
     0.627    20.328     0.200
     0.628    20.410     0.200
     0.685    22.488     0.200
     0.712    23.320     0.200
     0.706    23.309     0.200
     0.719    23.090     0.200
     0.724    23.320     0.200
     0.719    23.000     0.200
     0.796    25.961     0.200
     0.837    27.828     0.200
     1.019    32.711     0.200
     0.127     5.188     0.200
     0.200     7.277     0.200
     0.262     9.836     0.200
     0.273    10.699     0.200
     0.318    11.098     0.200
     0.388    13.227     0.200
     0.401    13.547     0.200
     0.412    13.406     0.200
     0.432    14.559     0.200
     0.629    20.246     0.200
     0.634    20.699     0.200
     0.645    21.559     0.200
     0.657    21.578     0.200
     0.732    24.148     0.200
     0.837    26.746     0.200
     0.874    28.727     0.200
     0.912    30.078     0.200
     0.919    29.586     0.200
     1.151    36.707     0.200
     1.623    51.289     0.200
     0.100     3.348     0.200
     0.185     6.316     0.200
     0.263     9.270     0.200
     0.276     9.809     0.200
     0.306    10.477     0.200
     0.369    12.879     0.200
     0.408    13.348     0.200
     0.427    14.137     0.200
     0.454    14.137     0.200
     0.456    14.457     0.200
     0.462    15.219     0.200
     0.531    16.719     0.200
     0.598    18.930     0.200
     0.638    19.930     0.200
     0.665    21.508     0.200
     0.688    21.859     0.200
     0.674    21.770     0.200
     0.691    22.520     0.200
     0.759    24.668     0.200
     0.782    25.297     0.200
     0.809    25.930     0.200
     0.919    30.289     0.200
     0.935    30.840     0.200
     0.955    30.906     0.200
     0.948    30.930     0.200
     1.020    32.648     0.200
     1.041    32.969     0.200
     1.075    34.359     0.200
     1.080    34.469     0.200
     1.591    51.379     0.200
     0.164     6.451     0.200
     0.179     7.691     0.200
     0.210     8.131     0.200
     0.285    10.092     0.200
     0.341    11.643     0.200
     0.361    12.172     0.200
     0.388    13.502     0.200
     0.629    20.242     0.200
     0.706    22.691     0.200
     0.732    23.672     0.200
     0.772    24.562     0.200
     0.084     5.066     0.200
     0.194     7.535     0.200
     0.233     9.004     0.200
     0.274     9.844     0.200
     0.309    10.566     0.200
     0.347    11.984     0.200
     0.367    11.805     0.200
     0.362    12.035     0.200
     0.488    16.383     0.200
     0.497    16.477     0.200
     0.503    16.125     0.200
     0.547    17.316     0.200
     0.556    18.504     0.200
     0.612    19.273     0.200
     0.745    24.215     0.200
     0.760    24.945     0.200
     0.820    26.754     0.200
     0.850    27.793     0.200
     1.040    33.293     0.200
     0.135     6.676     0.200
     0.212     8.555     0.200
     0.263     9.105     0.200
     0.343    12.215     0.200
     0.362    12.203     0.200
     0.414    13.344     0.200
     0.499    17.086     0.200
     0.636    21.145     0.200
     0.650    21.285     0.200
     0.677    21.625     0.200
     0.689    22.363     0.200
     0.680    21.766     0.200
     0.815    26.246     0.200
     0.882    28.227     0.200
     0.894    28.594     0.200
     0.983    31.754     0.200
     0.161     6.648     0.200
     0.194     7.906     0.200
     0.255     8.547     0.200
     0.338    11.668     0.200
     0.405    13.535     0.200
     0.623    20.918     0.200
     0.634    20.508     0.200
     0.656    21.355     0.200
     0.675    21.918     0.200
     0.688    22.516     0.200
     0.145     6.883     0.200
     0.202     8.656     0.200
     0.233     9.562     0.200
     0.255     9.562     0.200
     0.352    12.180     0.200
     0.406    13.469     0.200
     0.498    16.961     0.200
     0.558    18.211     0.200
     0.636    21.500     0.200
     0.649    21.133     0.200
     0.683    22.641     0.200
     0.708    22.773     0.200
     0.775    24.203     0.200
     0.807    25.859     0.200
     0.897    28.648     0.200
     0.986    31.359     0.200
     0.135     6.521     0.200
     0.211     8.611     0.200
     0.237     9.602     0.200
     0.262     9.242     0.200
     0.343    12.311     0.200
     0.361    12.072     0.200
     0.413    13.801     0.200
     0.450    15.102     0.200
     0.500    17.072     0.200
     0.637    20.941     0.200
     0.651    21.082     0.200
     0.681    22.432     0.200
     0.717    22.541     0.200
     0.716    23.361     0.200
     0.881    28.371     0.200
     0.901    28.711     0.200
     0.895    28.832     0.200
     0.161     6.070     0.200
     0.176     6.422     0.200
     0.188     7.523     0.200
     0.281    10.062     0.200
     0.313    10.797     0.200
     0.357    11.492     0.200
     0.413    14.109     0.200
     0.396    13.742     0.200
     0.433    14.320     0.200
     0.532    17.594     0.200
     0.573    18.266     0.200
     0.648    20.156     0.200
     0.654    21.273     0.200
     0.653    21.086     0.200
     0.726    24.227     0.200
     0.754    23.977     0.200
     0.818    25.953     0.200
     0.937    30.609     0.200
     1.085    34.977     0.200
     1.196    38.000     0.200
     1.243    39.055     0.200
     1.593    50.820     0.200
     1.743    55.047     0.200
     1.749    54.305     0.200
     1.872    59.234     0.200
     1.972    61.047     0.200
     2.082    63.812     0.200
     0.098     3.916     0.200
     0.195     6.486     0.200
     0.229     7.086     0.200
     0.247     7.906     0.200
     0.295     9.336     0.200
     0.315    10.666     0.200
     0.362    11.785     0.200
     0.358    11.396     0.200
     0.372    12.035     0.200
     0.511    15.996     0.200
     0.542    16.186     0.200
     0.512    16.406     0.200
     0.517    16.316     0.200
     0.539    16.625     0.200
     0.601    19.115     0.200
     0.608    19.355     0.200
     0.618    19.615     0.200
     0.632    19.795     0.200
     0.696    21.926     0.200
     0.692    22.166     0.200
     0.759    23.916     0.200
     0.840    26.686     0.200
     0.879    28.426     0.200
     0.879    28.746     0.200
     0.912    28.996     0.200
     0.924    28.955     0.200
     0.927    29.215     0.200
     1.060    34.836     0.200
     1.105    35.066     0.200
     1.142    36.986     0.200
     1.199    38.557     0.200
     1.231    39.266     0.200
     1.706    54.516     0.200
     1.725    54.445     0.200
     1.849    58.766     0.200
     1.915    60.625     0.200
     1.941    60.826     0.200
     2.057    65.025     0.200
     0.507    15.596     0.200
     0.650    21.586     0.200
     0.080     5.000     0.200
     0.222     9.148     0.200
     0.263     9.648     0.200
     0.271     9.758     0.200
     0.409    14.391     0.200
     0.450    15.289     0.200
     0.599    19.609     0.200
     0.656    22.180     0.200
     0.686    23.047     0.200
     0.114     4.140     0.200
     0.198     7.010     0.200
     0.219     6.800     0.200
     0.309     9.930     0.200
     0.321    10.609     0.200
     0.370    12.590     0.200
     0.373    12.430     0.200
     0.385    12.479     0.200
     0.541    16.670     0.200
     0.523    16.680     0.200
     0.542    17.290     0.200
     0.608    19.229     0.200
     0.623    19.410     0.200
     0.624    19.899     0.200
     0.632    20.540     0.200
     0.706    22.450     0.200
     0.837    26.720     0.200
     0.935    29.550     0.200
     1.152    37.240     0.200
     1.204    38.660     0.200
     1.233    39.399     0.200
     1.709    54.700     0.200
     1.942    61.020     0.200
     2.057    64.899     0.200
     0.179     6.977     0.200
     0.231     8.688     0.200
     0.336    10.859     0.200
     0.349    11.957     0.200
     0.364    12.609     0.200
     0.397    13.156     0.200
     0.407    14.418     0.200
     0.413    13.977     0.200
     0.440    15.188     0.200
     0.447    15.246     0.200
     0.511    16.406     0.200
     0.534    17.559     0.200
     0.546    17.859     0.200
     0.620    20.996     0.200
     0.639    20.707     0.200
     0.637    21.457     0.200
     0.660    20.996     0.200
     0.687    22.777     0.200
     0.751    23.789     0.200
     0.769    24.438     0.200
     0.773    25.656     0.200
     0.809    26.328     0.200
     0.843    27.156     0.200
     0.835    27.297     0.200
     0.861    28.188     0.200
     0.946    30.566     0.200
     1.585    49.988     0.200
     1.605    51.027     0.200
     1.769    55.430     0.200
     0.879    27.484     0.200
     1.770    53.000     0.200
     2.138    64.789     0.200
     2.427    72.398     0.200
     2.510    73.992     0.200
     2.671    78.109     0.200
     0.102     4.058     0.200
     0.205     7.048     0.200
     0.295     9.857     0.200
     0.326    10.777     0.200
     0.357    12.268     0.200
     0.369    12.407     0.200
     0.532    16.468     0.200
     0.524    17.338     0.200
     0.618    20.067     0.200
     0.629    20.737     0.200
     0.693    22.077     0.200
     0.703    23.088     0.200
     0.922    29.917     0.200
     0.347    12.361     0.200
     1.685    51.293     0.200
     1.709    51.482     0.200
     1.896    57.252     0.200
     2.141    61.723     0.200
     2.266    66.582     0.200
     2.115    64.842     0.200
     2.592    75.402     0.200
     0.151     5.617     0.200
     0.223     7.127     0.200
     0.235     8.817     0.200
     0.326    11.417     0.200
     0.349    11.247     0.200
     0.407    13.287     0.200
     0.484    16.297     0.200
     0.523    16.857     0.200
     0.581    19.027     0.200
     0.625    20.557     0.200
     0.677    21.497     0.200
     1.011    33.146     0.200
     0.032     3.527     0.200
     0.165     6.297     0.200
     0.175     6.316     0.200
     0.203     7.736     0.200
     0.369    12.617     0.200
     0.367    11.846     0.200
     0.482    15.477     0.200
     0.510    15.996     0.200
     0.581    18.816     0.200
     0.571    18.816     0.200
     0.590    18.846     0.200
     0.599    18.857     0.200
     0.643    20.857     0.200
     0.638    20.547     0.200
     0.665    21.506     0.200
     0.711    22.127     0.200
     0.708    23.836     0.200
     0.728    24.326     0.200
     0.725    23.137     0.200
     0.787    25.086     0.200
     0.848    27.586     0.200
     0.865    28.406     0.200
     0.864    27.947     0.200
     0.927    30.117     0.200
     1.011    32.316     0.200
     1.201    38.297     0.200
     1.188    36.518     0.200
     1.736    55.406     0.200
     1.967    62.377     0.200
     2.317    72.086     0.200
     2.633    80.166     0.200
     2.738    80.547     0.200
     0.175     6.406     0.200
     0.275     8.809     0.200
     0.311     9.598     0.200
     0.341    10.836     0.200
     0.347    11.418     0.200
     0.447    14.898     0.200
     0.439    14.277     0.200
     0.501    16.387     0.200
     0.545    16.938     0.200
     0.556    18.277     0.200
     0.661    21.117     0.200
     0.683    22.906     0.200
     0.720    21.957     0.200
     0.740    22.898     0.200
     1.038    33.559     0.200
     1.723    55.398     0.200
     0.122     5.562     0.200
     0.203     7.078     0.200
     0.257     9.188     0.200
     0.312    10.781     0.200
     0.317    10.922     0.200
     0.394    13.039     0.200
     0.426    14.477     0.200
     0.452    15.383     0.200
     0.586    18.820     0.200
     0.604    19.195     0.200
     0.624    20.688     0.200
     0.665    21.406     0.200
     0.713    23.188     0.200
     0.717    23.672     0.200
     0.721    23.867     0.200
     0.800    25.531     0.200
     0.809    26.492     0.200
     0.867    28.047     0.200
     0.903    29.461     0.200
     0.928    30.750     0.200
     0.991    32.297     0.200
     1.085    33.906     0.200
     0.035     4.900     0.200
     0.127     5.640     0.200
     0.193     7.240     0.200
     0.287    10.190     0.200
     0.308    10.630     0.200
     0.361    12.110     0.200
     0.431    14.470     0.200
     0.505    17.530     0.200
     0.500    16.750     0.200
     0.499    15.860     0.200
     0.563    18.860     0.200
     0.618    19.430     0.200
     0.625    20.760     0.200
     0.657    21.170     0.200
     0.688    23.620     0.200
     0.683    22.790     0.200
     0.706    22.910     0.200
     0.706    22.720     0.200
     0.711    23.170     0.200
     0.715    23.300     0.200
     0.748    23.910     0.200
     0.770    24.960     0.200
     0.789    25.680     0.200
     0.796    25.640     0.200
     0.841    28.060     0.200
     0.846    27.810     0.200
     0.931    29.970     0.200
     1.136    35.730     0.200
     1.269    39.320     0.200
     1.361    41.720     0.200
     2.301    69.640     0.200
     2.497    73.260     0.200
     0.034     4.453     0.200
     0.130     5.266     0.200
     0.187     6.285     0.200
     0.284     9.984     0.200
     0.312    10.664     0.200
     0.356    11.203     0.200
     0.425    13.555     0.200
     0.474    16.035     0.200
     0.496    15.992     0.200
     0.498    17.082     0.200
     0.560    17.766     0.200
     0.610    19.992     0.200
     0.619    20.504     0.200
     0.651    20.203     0.200
     0.684    22.184     0.200
     0.698    22.492     0.200
     0.702    22.734     0.200
     0.707    23.016     0.200
     0.714    22.492     0.200
     0.741    24.215     0.200
     0.767    23.992     0.200
     0.794    25.113     0.200
     0.837    27.812     0.200
     1.000    32.922     0.200
     1.050    34.273     0.200
     1.083    35.242     0.200
     1.130    35.523     0.200
     0.136     5.020     0.200
     0.231     7.680     0.200
     0.203     7.340     0.200
     0.286     9.730     0.200
     0.302    10.078     0.200
     0.311    11.117     0.200
     0.372    11.957     0.200
     0.414    14.199     0.200
     0.441    14.520     0.200
     0.463    15.809     0.200
     0.537    17.340     0.200
     0.545    17.848     0.200
     0.565    17.918     0.200
     0.606    20.590     0.200
     0.653    20.789     0.200
     0.634    21.328     0.200
     0.880    28.348     0.200
     0.930    30.090     0.200
     0.971    31.359     0.200
     0.037     4.422     0.200
     0.136     5.473     0.200
     0.185     6.504     0.200
     0.279     9.594     0.200
     0.420    13.793     0.200
     0.495    16.242     0.200
     0.555    18.102     0.200
     0.616    19.883     0.200
     0.645    20.652     0.200
     0.703    22.871     0.200
     0.716    23.730     0.200
     0.777    25.973     0.200
     0.837    27.934     0.200
     0.997    32.742     0.200
     0.135     4.602     0.200
     0.199     6.822     0.200
     0.210     6.902     0.200
     0.290     9.352     0.200
     0.340    11.232     0.200
     0.340    11.623     0.200
     0.488    16.303     0.200
     0.564    18.482     0.200
     0.681    21.232     0.200
     0.906    29.053     0.200
     0.037     5.156     0.200
     0.134     5.797     0.200
     0.185     7.359     0.200
     0.266     9.289     0.200
     0.313    10.914     0.200
     0.352    11.695     0.200
     0.421    14.242     0.200
     0.496    15.898     0.200
     0.498    15.742     0.200
     0.607    20.094     0.200
     0.646    19.969     0.200
     0.684    22.555     0.200
     0.695    22.555     0.200
     0.698    22.328     0.200
     0.715    23.195     0.200
     0.722    23.109     0.200
     0.768    24.094     0.200
     0.779    25.242     0.200
     0.792    25.695     0.200
     0.838    27.625     0.200
     0.849    26.805     0.200
     0.857    27.094     0.200
     1.126    34.945     0.200
     1.116    35.727     0.200
     1.176    37.297     0.200
     1.879    59.039     0.200
     2.183    68.375     0.200
     0.722    23.246     0.200
     0.192     8.246     0.200
     0.253     9.535     0.200
     0.290    10.496     0.200
     0.419    14.436     0.200
     0.415    14.395     0.200
     0.527    17.576     0.200
     0.718    23.455     0.200
     0.736    24.236     0.200
     0.809    26.805     0.200
     0.884    27.945     0.200
     0.901    28.865     0.200
     0.925    29.586     0.200
     0.020     5.758     0.200
     0.101     6.191     0.200
     0.152     7.379     0.200
     0.215     8.781     0.200
     0.470    15.738     0.200
     0.584    19.691     0.200
     0.604    19.301     0.200
     0.636    21.738     0.200
     0.667    22.070     0.200
     0.680    21.898     0.200
     0.740    24.211     0.200
     0.745    23.668     0.200
     0.787    25.699     0.200
     0.113     5.180     0.200
     0.175     6.820     0.200
     0.257     8.449     0.200
     0.278     8.891     0.200
     0.316    10.332     0.200
     0.366    12.152     0.200
     0.420    13.891     0.200
     0.418    13.621     0.200
     0.438    14.891     0.200
     0.447    14.723     0.200
     0.472    15.711     0.200
     0.522    16.570     0.200
     0.500    16.473     0.200
     0.555    18.770     0.200
     0.581    19.512     0.200
     0.662    20.789     0.200
     0.668    22.160     0.200
     0.688    21.320     0.200
     0.686    22.723     0.200
     0.708    22.180     0.200
     0.708    22.609     0.200
     0.795    25.512     0.200
     0.861    27.141     0.200
     0.840    27.402     0.200
     0.914    30.160     0.200
     1.007    32.570     0.200
     1.136    35.770     0.200
     1.242    39.359     0.200
     1.629    51.312     0.200
     1.692    53.082     0.200
     0.360    11.602     0.200
     0.745    25.562     0.200
     1.040    31.410     0.200
     0.139     6.227     0.200
     0.143     5.969     0.200
     0.227     8.203     0.200
     0.293    10.078     0.200
     0.307    10.039     0.200
     0.623    20.578     0.200
     0.734    23.125     0.200
     0.753    24.664     0.200
     0.782    25.984     0.200
     0.803    26.453     0.200
     0.018     4.441     0.200
     0.122     4.821     0.200
     0.166     6.751     0.200
     0.246     8.371     0.200
     0.428    13.411     0.200
     0.479    16.611     0.200
     0.599    18.721     0.200
     0.649    20.211     0.200
     0.683    21.581     0.200
     0.692    22.621     0.200
     0.712    23.201     0.200
     0.698    22.561     0.200
     0.814    27.051     0.200
     0.114     4.148     0.200
     0.165     5.887     0.200
     0.186     5.906     0.200
     0.261     9.219     0.200
     0.272     8.578     0.200
     0.346    12.098     0.200
     0.347    11.207     0.200
     0.377    12.086     0.200
     0.587    18.887     0.200
     0.599    18.727     0.200
     0.637    20.695     0.200
     0.651    20.957     0.200
     0.728    23.828     0.200
     0.795    26.238     0.200
     0.830    26.246     0.200
     1.099    35.086     0.200
     1.201    38.348     0.200
     1.313    40.008     0.200
     3.136    95.387     0.200
     0.134     5.562     0.200
     0.316    10.602     0.200
     0.317    10.792     0.200
     0.332    10.682     0.200
     0.421    13.742     0.200
     0.492    16.142     0.200
     0.525    16.512     0.200
     0.513    16.842     0.200
     0.614    19.702     0.200
     0.616    19.662     0.200
     0.792    24.822     0.200
     0.789    24.572     0.200
     0.773    24.622     0.200
     0.803    26.002     0.200
     0.828    26.432     0.200
     0.946    29.862     0.200
     0.946    30.382     0.200
     1.046    33.872     0.200
     1.819    57.682     0.200
     1.934    60.542     0.200
     0.610    18.742     0.200
     2.545    76.542     0.200
     0.145     5.930     0.200
     0.166     6.039     0.200
     0.267     8.445     0.200
     0.315     9.602     0.200
     0.340    10.648     0.200
     0.307    10.438     0.200
     0.380    11.820     0.200
     0.384    12.625     0.200
     0.372    12.078     0.200
     0.422    14.234     0.200
     0.507    16.578     0.200
     0.529    16.641     0.200
     0.545    16.555     0.200
     0.523    17.078     0.200
     0.540    17.031     0.200
     0.520    16.891     0.200
     0.647    21.586     0.200
     0.660    21.734     0.200
     0.681    21.117     0.200
     0.683    22.461     0.200
     0.740    23.367     0.200
     0.749    23.539     0.200
     0.753    23.211     0.200
     0.786    26.227     0.200
     0.826    26.469     0.200
     0.825    27.266     0.200
     0.852    28.117     0.200
     0.917    29.180     0.200
     0.932    29.906     0.200
     1.044    32.648     0.200
     1.070    33.852     0.200
     1.090    34.484     0.200
     1.181    37.164     0.200
     1.674    52.680     0.200
     1.693    53.141     0.200
     1.725    54.898     0.200
     1.755    55.180     0.200
     0.300    10.266     0.200
     0.675    22.000     0.200
     0.715    24.531     0.200
     0.981    29.570     0.200
     1.664    52.945     0.200
     1.751    53.641     0.200
     0.146     5.750     0.200
     0.168     6.094     0.200
     0.270     8.617     0.200
     0.318     9.797     0.200
     0.304    10.586     0.200
     0.344    10.750     0.200
     0.383    11.883     0.200
     0.384    12.695     0.200
     0.368    11.953     0.200
     0.424    14.430     0.200
     0.510    16.797     0.200
     0.524    17.023     0.200
     0.549    16.641     0.200
     0.517    16.734     0.200
     0.647    21.297     0.200
     0.662    21.641     0.200
     0.685    21.156     0.200
     0.687    22.344     0.200
     0.743    23.367     0.200
     0.753    23.633     0.200
     0.757    23.297     0.200
     0.784    25.625     0.200
     0.830    26.484     0.200
     0.824    27.312     0.200
     0.850    28.133     0.200
     0.921    29.344     0.200
     0.936    29.914     0.200
     0.946    30.133     0.200
     1.049    33.062     0.200
     1.074    33.844     0.200
     1.094    34.844     0.200
     1.186    37.000     0.200
     1.204    38.773     0.200
     1.678    52.797     0.200
     1.697    53.250     0.200
     1.728    54.836     0.200
     1.759    55.195     0.200
     0.677    21.805     0.200
     1.755    54.453     0.200
     2.111    64.414     0.200
     2.484    75.586     0.200
     0.075     4.508     0.200
     0.098     4.836     0.200
     0.237     8.906     0.200
     0.262     9.555     0.200
     0.421    13.820     0.200
     0.466    15.438     0.200
     0.539    17.445     0.200
     0.554    18.422     0.200
     0.575    18.922     0.200
     0.613    19.961     0.200
     0.611    20.383     0.200
     0.646    21.477     0.200
     0.734    22.352     0.200
     0.796    24.992     0.200
     0.873    28.102     0.200
     1.000    31.688     0.200
     1.104    35.125     0.200
     1.115    35.375     0.200
     1.138    36.594     0.200
     1.665    52.938     0.200
     0.422    13.016     0.200
     1.694    53.555     0.200
     0.054     3.484     0.200
     0.280     9.875     0.200
     0.295     9.695     0.200
     0.387    13.266     0.200
     0.377    12.984     0.200
     0.513    16.365     0.200
     0.568    18.756     0.200
     0.622    20.506     0.200
     0.661    21.375     0.200
     0.772    25.805     0.200
     0.775    25.336     0.200
     0.964    31.785     0.200
     1.003    31.426     0.200
     1.055    33.975     0.200
     1.107    35.525     0.200
     1.169    37.586     0.200
     1.255    40.006     0.200
     1.934    60.205     0.200
     0.038     5.016     0.200
     0.112     5.396     0.200
     0.133     5.686     0.200
     0.190     7.396     0.200
     0.207     7.826     0.200
     0.266     9.295     0.200
     0.281    10.016     0.200
     0.309    10.186     0.200
     0.354    11.465     0.200
     0.474    15.596     0.200
     0.501    17.006     0.200
     0.501    15.816     0.200
     0.611    19.416     0.200
     0.622    19.906     0.200
     0.650    21.166     0.200
     0.688    22.426     0.200
     0.700    22.266     0.200
     0.700    22.336     0.200
     0.704    22.396     0.200
     0.741    24.576     0.200
     0.783    24.965     0.200
     0.875    27.955     0.200
     1.002    32.227     0.200
     0.207     7.297     0.200
     0.201     7.438     0.200
     0.218     7.898     0.200
     0.249     8.629     0.200
     0.299    10.129     0.200
     0.333    10.637     0.200
     0.356    11.758     0.200
     0.415    13.449     0.200
     0.444    13.727     0.200
     0.725    23.238     0.200
     1.811    57.602     0.200
     0.302    10.176     0.200
     1.994    59.426     0.200
     2.076    63.625     0.200
     2.234    65.363     0.200
     2.161    64.746     0.200
     2.200    64.746     0.200
     2.343    70.105     0.200
     2.396    69.785     0.200
     2.482    71.805     0.200
     2.490    72.855     0.200
     2.568    75.094     0.200
     0.451    16.377     0.200
     1.523    47.227     0.200
     1.877    57.447     0.200
     2.466    72.418     0.200
     0.039     2.193     0.200
     0.972    31.764     0.200
     1.948    60.873     0.200
     1.897    61.094     0.200
     2.031    62.822     0.200
     2.052    64.062     0.200
     2.092    65.174     0.200
     2.341    70.883     0.200
     2.362    72.594     0.200
     2.401    72.553     0.200
     2.415    73.062     0.200
     2.555    76.934     0.200
     2.780    84.523     0.200
     2.868    85.943     0.200
     3.128    94.184     0.200
     0.607    20.527     0.200
     0.763    22.818     0.200
     0.751    23.928     0.200
     1.666    52.408     0.200
     1.885    57.768     0.200
     2.911    86.418     0.200
     0.715    22.141     0.200
     2.642    77.039     0.200
     2.835    84.148     0.200
     2.771    80.828     0.200
     2.778    84.348     0.200
     3.319    96.367     0.200
     0.596    19.244     0.200
     1.912    57.675     0.200
     2.045    60.595     0.200
     2.104    63.595     0.200
     2.363    71.505     0.200
     2.451    71.505     0.200
     2.698    78.005     0.200
     2.801    82.715     0.200
     0.863    26.947     0.200
     2.886    85.596     0.200
     3.055    89.536     0.200
     3.190    93.727     0.200
     3.205    94.806     0.200
     0.436    13.437     0.200
     0.787    24.366     0.200
     1.878    60.127     0.200
     0.381    13.231     0.200
     1.355    40.201     0.200
     1.955    60.062     0.200
     2.440    70.571     0.200
     2.467    72.651     0.200
     2.529    73.841     0.200
     2.965    89.451     0.200
     3.478   100.331     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.581    79.262     0.200
     5.110   162.570     0.200
     5.110   166.969     0.200
    21.597   707.748     0.200
     5.561   171.148     0.200
     3.178    99.049     0.200
     8.121   259.836     0.200
     2.696    83.000     0.200
     4.336   135.000     0.200
     4.327   135.242     0.200
     3.090    95.301     0.200
     3.207    98.902     0.200
     5.602   171.902     0.200
     2.950    92.117     0.200
     3.309   105.461     0.200
     3.300   105.859     0.200
     2.861    87.547     0.200
     3.145   101.547     0.200
     2.776    90.766     0.200
     2.537    78.703     0.200
     2.748    85.703     0.200
     2.610    80.156     0.200
     2.823    87.156     0.200
     3.022    93.156     0.200
     3.175    97.758     0.200
     2.525    79.266     0.200
     2.718    84.766     0.200
     3.497   109.266     0.200
     2.948    90.174     0.200
     2.996    92.874     0.200
     2.627    83.455     0.200
     2.560    81.355     0.200
     2.569    82.174     0.200
     3.136   100.674     0.200
     2.913    89.141     0.200
     2.525    78.023     0.200
     2.707    84.223     0.200
     2.707    83.922     0.200
     2.546    78.281     0.200
     2.766    86.516     0.200
     2.766    85.914     0.200
     2.935    91.805     0.200
     4.520   141.602     0.200
     2.765    85.859     0.200
     2.712    84.676     0.200
     2.498    77.406     0.200
     2.564    81.406     0.200
     2.690    85.406     0.200
     2.561    78.750     0.200
     2.755    86.250     0.200
     2.982    95.750     0.200
     2.744    86.994     0.200
     2.968    93.855     0.200
     2.952    91.895     0.200
     5.730   174.648     0.200
     2.605    81.531     0.200
     2.857    89.531     0.200
     3.355   106.406     0.200
     2.947    90.316     0.200
     2.558    78.845     0.200
     2.775    88.707     0.200
     2.764    85.879     0.200
     2.730    83.566     0.200
     2.896    92.037     0.200
     3.145    97.537     0.200
     2.769    84.522     0.200
     2.969    92.022     0.200
     3.103    97.723     0.200
     6.759   206.433     0.200
     2.651    83.243     0.200
     2.835    89.193     0.200
     3.077    98.193     0.200
     3.522   110.852     0.200
     3.450   106.500     0.200
     3.485   112.395     0.200
     3.883   120.996     0.200
     4.134   131.195     0.200
     7.264   228.170     0.200
     2.531    79.977     0.200
     2.635    81.578     0.200
     3.537   112.855     0.200
     3.678   113.238     0.200
     5.032   156.840     0.200
     3.524   111.566     0.200
     3.927   121.566     0.200
     4.503   138.965     0.200
     4.897   150.164     0.200
     3.007    97.230     0.200
     2.885    89.227     0.200
     2.828    88.218     0.200
     3.028    93.378     0.200
     3.028    93.657     0.200
     2.576    80.461     0.200
     3.547   109.562     0.200
     3.892   122.781     0.200
     3.548   110.156     0.200
     4.040   125.039     0.200
     2.943    92.977     0.200
     2.577    78.604     0.200
     3.510   108.304     0.200
     3.567   111.336     0.200
     3.721   114.598     0.200
     6.310   192.938     0.200
     3.909   125.699     0.200
     2.745    86.062     0.200
     2.703    85.943     0.200
     2.819    87.494     0.200
     3.014    97.395     0.200
     3.844   117.232     0.200
     3.374   106.531     0.200
     2.716    85.957     0.200
     2.716    86.176     0.200
     3.472   113.445     0.200
     3.275   105.201     0.200
     3.383   106.150     0.200
     3.777   115.350     0.200
     5.950   181.164     0.200
     2.715    83.180     0.200
     3.387   108.809     0.200
     2.668    83.991     0.200
     3.048    97.991     0.200
     2.620    81.398     0.200
     2.546    79.266     0.200
     2.518    80.766     0.200
     3.635   114.004     0.200
     2.738    85.027     0.200
     3.282   103.828     0.200
     5.876   180.027     0.200
     2.517    77.848     0.200
     3.165   100.633     0.200
     3.343   104.172     0.200
     2.511    77.711     0.200
     2.883    89.957     0.200
     2.848    89.354     0.200
     3.304   102.938     0.200
     2.622    83.336     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.128    63.350     0.200
     2.799    85.088     0.200
     1.183    36.689     0.200
     2.669    79.689     0.200
     1.993    60.570     0.200
     3.645   108.469     0.200
     2.311    67.965     0.200
     0.777    24.164     0.200
     2.533    76.465     0.200
     1.819    55.328     0.200
     2.843    85.027     0.200
     1.337    41.379     0.200
     2.478    77.179     0.200
     2.503    72.047     0.200
     2.475    72.359     0.200
     3.814   112.469     0.200
     5.110   149.172     0.200
     2.530    75.766     0.200
     2.536    77.566     0.200
     1.027    33.068     0.200
     1.252    38.868     0.200
     1.477    45.352     0.200
     2.144    63.109     0.200
     2.940    88.609     0.200
     2.940    88.312     0.200
     3.866   111.109     0.200
     2.135    66.727     0.200
     2.474    75.227     0.200
     0.770    25.467     0.200
     5.627   163.867     0.200
     0.738    23.848     0.200
     2.068    63.148     0.200
     2.475    72.248     0.200
     0.704    21.848     0.200
     2.042    63.348     0.200
     2.445    73.848     0.200
     0.534    17.312     0.200
     2.276    69.312     0.200
     0.934    29.637     0.200
     2.533    74.836     0.200
     2.906    88.336     0.200
     1.103    35.000     0.200
     1.670    52.000     0.200
     2.623    78.000     0.200
     2.606    79.199     0.200
     3.025    92.000     0.200
     2.593    77.344     0.200
     3.013    91.242     0.200
     3.435   102.742     0.200
     0.830    25.402     0.200
     2.019    62.094     0.200
     1.006    32.375     0.200
     1.136    35.945     0.200
     2.490    73.445     0.200
     2.529    76.000     0.200
     1.026    32.461     0.200
     2.016    64.461     0.200
     2.491    73.758     0.200
     2.533    74.961     0.200
     1.095    34.133     0.200
     1.228    38.633     0.200
     2.532    74.133     0.200
     2.599    78.133     0.200
     2.729    82.133     0.200
     2.953    88.531     0.200
     3.445   100.633     0.200
     1.149    36.047     0.200
     2.048    64.547     0.200
     2.609    78.547     0.200
     2.049    64.547     0.200
     1.020    32.172     0.200
     1.188    37.562     0.200
     2.037    63.766     0.200
     2.540    75.367     0.200
     2.582    77.766     0.200
     2.715    80.266     0.200
     2.848    86.766     0.200
     5.750   167.766     0.200
     2.045    63.703     0.200
     2.857    84.203     0.200
     3.339   101.703     0.200
     2.045    63.703     0.200
     2.620    77.656     0.200
     2.999    88.156     0.200
     1.024    33.219     0.200
     2.015    61.766     0.200
     2.945    88.766     0.200
     2.016    61.766     0.200
     1.006    32.984     0.200
     1.167    36.874     0.200
     1.156    34.874     0.200
     2.042    61.874     0.200
     2.559    76.374     0.200
     2.692    81.874     0.200
     2.745    82.874     0.200
     2.979    90.074     0.200
     5.727   168.874     0.200
     1.118    36.074     0.200
     2.043    61.874     0.200
     1.226    38.549     0.200
     2.091    64.549     0.200
     2.384    74.248     0.200
     2.701    80.549     0.200
     2.827    83.949     0.200
     3.055    90.549     0.200
     1.122    35.555     0.200
     1.187    37.855     0.200
     2.561    76.355     0.200
     2.388    73.955     0.200
     2.694    81.855     0.200
     3.180    93.355     0.200
     1.034    31.014     0.200
     1.988    63.174     0.200
     2.436    75.174     0.200
     2.503    74.174     0.200
     2.630    79.174     0.200
     2.856    85.174     0.200
     2.640    79.971     0.200
     3.056    88.971     0.200
     2.928    88.670     0.200
     3.184    97.121     0.200
     1.036    31.754     0.200
     1.187    37.223     0.200
     2.482    74.324     0.200
     2.658    81.023     0.200
     2.945    88.523     0.200
     3.102    91.023     0.200
     1.864    59.512     0.200
     1.037    31.812     0.200
     1.148    36.180     0.200
     2.484    73.281     0.200
     2.612    76.281     0.200
     2.679    80.281     0.200
     2.741    80.281     0.200
     3.130    91.281     0.200
     1.068    34.367     0.200
     0.995    31.695     0.200
     2.595    77.516     0.200
     2.663    80.016     0.200
     2.727    80.516     0.200
     2.986    88.914     0.200
     1.114    35.414     0.200
     2.983    90.516     0.200
     3.012    88.914     0.200
     0.198     6.602     0.200
     1.107    34.500     0.200
     2.547    76.242     0.200
     1.153    36.102     0.200
     1.007    31.727     0.200
     1.098    35.250     0.200
     2.064    63.859     0.200
     2.756    82.859     0.200
     1.146    35.865     0.200
     1.192    38.676     0.200
     1.248    39.875     0.200
     1.169    38.176     0.200
     2.011    62.676     0.200
     2.759    83.676     0.200
     1.879    60.246     0.200
     2.012    62.676     0.200
     1.047    33.180     0.200
     1.093    35.270     0.200
     1.194    38.066     0.200
     2.652    81.066     0.200
     2.719    82.168     0.200
     2.079    64.668     0.200
     2.379    73.566     0.200
     2.586    76.668     0.200
     2.781    81.906     0.200
     2.780    82.668     0.200
     2.973    88.668     0.200
     3.646   109.469     0.200
     1.003    30.484     0.200
     1.001    31.137     0.200
     1.118    35.105     0.200
     2.028    62.406     0.200
     2.917    88.406     0.200
     1.024    31.219     0.200
     1.066    33.398     0.200
     1.147    35.148     0.200
     2.027    64.250     0.200
     2.694    80.250     0.200
     2.952    90.250     0.200
     0.276     7.953     0.200
     1.089    32.123     0.200
     1.985    62.463     0.200
     2.607    79.463     0.200
     2.741    82.463     0.200
     3.029    91.263     0.200
     0.573    17.645     0.200
     0.869    27.344     0.200
     0.976    31.344     0.200
     1.114    35.123     0.200
     1.211    38.395     0.200
     2.043    64.094     0.200
     2.576    77.293     0.200
     2.621    78.594     0.200
     2.754    84.094     0.200
     2.816    85.895     0.200
     3.041    91.895     0.200
     1.154    36.494     0.200
     2.043    64.094     0.200
     0.086     4.742     0.200
     0.241     6.492     0.200
     0.292     9.523     0.200
     0.324    10.438     0.200
     1.002    32.344     0.200
     1.070    33.703     0.200
     1.120    36.141     0.200
     1.173    37.141     0.200
     2.056    64.141     0.200
     2.590    78.141     0.200
     0.042     4.500     0.200
     0.216     7.359     0.200
     0.221     8.250     0.200
     0.292     9.297     0.200
     0.828    27.250     0.200
     1.023    31.516     0.200
     1.149    35.750     0.200
     2.028    61.953     0.200
     2.563    74.453     0.200
     2.858    83.555     0.200
     2.028    61.953     0.200
     2.633    80.352     0.200
     0.056     4.336     0.200
     0.063     5.039     0.200
     0.223     7.734     0.200
     0.219     7.414     0.200
     0.219     7.594     0.200
     0.292     9.336     0.200
     1.025    31.773     0.200
     2.027    62.836     0.200
     2.565    74.836     0.200
     2.729    80.836     0.200
     2.028    62.836     0.200
     2.956    89.234     0.200
     0.049     4.266     0.200
     0.065     3.367     0.200
     0.048     4.891     0.200
     0.070     4.844     0.200
     0.213     7.219     0.200
     0.217     7.727     0.200
     0.286     9.211     0.200
     0.816    26.117     0.200
     2.692    81.617     0.200
     0.058     2.969     0.200
     0.126     5.609     0.200
     0.249     8.336     0.200
     0.249     7.266     0.200
     0.366    11.555     0.200
     0.894    28.383     0.200
     1.060    33.289     0.200
     1.114    35.383     0.200
     2.111    66.086     0.200
     2.411    74.586     0.200
     0.077     4.883     0.200
     0.050     4.625     0.200
     0.088     4.055     0.200
     0.187     7.934     0.200
     0.230     8.133     0.200
     0.234     8.254     0.200
     0.852    27.555     0.200
     1.001    32.543     0.200
     1.173    35.855     0.200
     1.169    36.754     0.200
     2.877    85.055     0.200
     2.053    63.055     0.200
     2.579    77.055     0.200
     0.048     4.652     0.200
     0.055     4.055     0.200
     0.215     7.793     0.200
     0.216     8.121     0.200
     0.207     8.332     0.200
     0.816    26.293     0.200
     1.040    30.941     0.200
     1.078    33.602     0.200
     1.154    34.793     0.200
     1.136    35.895     0.200
     2.560    75.191     0.200
     2.694    79.793     0.200
     2.852    82.793     0.200
     2.755    81.293     0.200
     2.012    62.793     0.200
     5.729   165.793     0.200
     0.049     4.688     0.200
     0.082     5.059     0.200
     0.184     8.137     0.200
     0.236     8.566     0.200
     0.232     8.156     0.200
     0.292     9.258     0.200
     0.294     9.789     0.200
     0.577    18.258     0.200
     0.857    27.008     0.200
     0.995    32.348     0.200
     2.714    81.508     0.200
     0.088     4.848     0.200
     0.009     3.828     0.200
     0.037     4.629     0.200
     0.246     8.758     0.200
     0.243     8.160     0.200
     0.294     9.660     0.200
     0.301     9.699     0.200
     0.300     9.699     0.200
     0.862    27.551     0.200
     0.051     4.094     0.200
     0.063     4.406     0.200
     0.076     4.797     0.200
     0.221     7.297     0.200
     0.226     7.594     0.200
     0.248     8.797     0.200
     0.262     8.695     0.200
     0.522    16.195     0.200
     0.811    26.195     0.200
     0.802    26.445     0.200
     1.052    31.664     0.200
     1.089    34.352     0.200
     2.562    76.695     0.200
     2.758    83.492     0.200
     2.925    85.695     0.200
     0.023     4.648     0.200
     0.041     5.078     0.200
     0.255     8.055     0.200
     0.257     8.781     0.200
     0.319     9.961     0.200
     0.605    18.812     0.200
     0.885    28.211     0.200
     1.096    33.008     0.200
     0.999    32.062     0.200
     0.037     4.406     0.200
     0.060     4.719     0.200
     0.082     5.281     0.200
     0.207     7.211     0.200
     0.202     7.141     0.200
     0.251     7.609     0.200
     0.218     8.812     0.200
     0.530    16.609     0.200
     0.810    26.359     0.200
     0.804    25.859     0.200
     1.033    30.180     0.200
     1.063    32.219     0.200
     2.681    81.109     0.200
     2.742    81.109     0.200
     0.048     4.398     0.200
     0.050     3.859     0.200
     0.070     4.891     0.200
     0.220     7.438     0.200
     0.206     8.695     0.200
     0.254     8.656     0.200
     0.264     8.797     0.200
     0.820    27.398     0.200
     0.074     4.387     0.200
     0.023     3.809     0.200
     0.050     4.156     0.200
     0.229     6.867     0.200
     0.187     7.289     0.200
     0.290     9.598     0.200
     0.568    17.699     0.200
     0.688    20.699     0.200
     0.849    26.348     0.200
     1.172    37.098     0.200
     2.578    76.098     0.200
     0.044     4.523     0.200
     0.104     5.352     0.200
     0.052     3.398     0.200
     0.074     5.094     0.200
     0.208     6.391     0.200
     0.213     7.430     0.200
     0.259     8.570     0.200
     0.211     8.641     0.200
     0.259     8.570     0.200
     0.813    26.820     0.200
     0.819    27.023     0.200
     1.027    31.633     0.200
     0.130     5.133     0.200
     0.158     5.812     0.200
     0.107     5.078     0.200
     0.185     5.930     0.200
     0.185     6.203     0.200
     0.174     6.492     0.200
     0.177     6.938     0.200
     0.235     7.969     0.200
     0.286    10.070     0.200
     0.417    13.008     0.200
     0.707    24.211     0.200
     0.138     5.141     0.200
     0.096     5.016     0.200
     0.114     4.438     0.200
     0.161     5.641     0.200
     0.187     6.031     0.200
     0.163     6.156     0.200
     0.170     6.531     0.200
     0.217     6.688     0.200
     0.283    10.117     0.200
     0.424    13.188     0.200
     0.567    19.188     0.200
     0.712    24.188     0.200
     0.137     6.516     0.200
     0.196     6.820     0.200
     0.137     6.320     0.200
     0.241     8.820     0.200
     0.268     8.617     0.200
     0.268     9.016     0.200
     0.214     8.414     0.200
     0.293     8.844     0.200
     0.304    10.367     0.200
     0.301     9.914     0.200
     0.317    11.617     0.200
     0.480    15.164     0.200
     0.644    21.219     0.200
     0.781    26.664     0.200
     0.051     4.176     0.200
     0.111     5.055     0.200
     0.047     4.066     0.200
     0.191     6.195     0.200
     0.220     7.496     0.200
     0.265     8.195     0.200
     0.204     8.105     0.200
     0.287     9.176     0.200
     0.662    22.195     0.200
     0.817    27.945     0.200
     1.028    31.637     0.200
     1.069    34.434     0.200
     0.097     5.000     0.200
     0.137     5.109     0.200
     0.172     6.719     0.200
     0.216     6.391     0.200
     0.225     7.020     0.200
     0.284    10.090     0.200
     1.251    39.180     0.200
     1.901    59.180     0.200
     2.513    76.180     0.200
     0.046     4.250     0.200
     0.103     5.148     0.200
     0.050     5.047     0.200
     0.208     6.250     0.200
     0.213     7.867     0.200
     0.258     8.445     0.200
     0.210     8.297     0.200
     0.540    17.148     0.200
     0.659    20.898     0.200
     0.815    26.750     0.200
     0.820    26.648     0.200
     0.934    30.648     0.200
     0.060     3.619     0.200
     0.084     5.439     0.200
     0.127     5.939     0.200
     0.202     8.398     0.200
     0.231     7.818     0.200
     0.655    20.369     0.200
     1.051    31.449     0.200
     0.034     4.199     0.200
     0.033     4.250     0.200
     0.039     4.699     0.200
     0.092     5.109     0.200
     0.099     5.297     0.200
     0.063     4.750     0.200
     0.200     7.059     0.200
     0.246     8.598     0.200
     0.249     8.398     0.200
     0.221     8.797     0.200
     0.647    20.648     0.200
     1.035    31.520     0.200
     0.019     3.742     0.200
     0.090     4.672     0.200
     0.148     5.230     0.200
     0.153     6.082     0.200
     0.137     5.289     0.200
     0.153     4.730     0.200
     0.163     5.762     0.200
     0.203     6.891     0.200
     0.204     6.730     0.200
     0.213     7.020     0.200
     0.291    10.191     0.200
     0.422    12.930     0.200
     1.283    40.230     0.200
     2.502    75.230     0.200
     2.636    78.730     0.200
     2.901    88.332     0.200
     0.020     3.516     0.200
     0.080     3.844     0.200
     0.086     4.543     0.200
     0.139     5.254     0.200
     0.150     5.824     0.200
     0.146     5.094     0.200
     0.163     5.625     0.200
     0.199     6.113     0.200
     0.269     8.695     0.200
     0.292    10.406     0.200
     0.422    12.844     0.200
     0.822    26.645     0.200
     0.057     4.396     0.200
     0.055     3.865     0.200
     0.057     3.765     0.200
     0.127     5.345     0.200
     0.201     6.215     0.200
     0.232     7.505     0.200
     0.200     7.195     0.200
     0.280     9.085     0.200
     0.818    25.715     0.200
     0.061     3.633     0.200
     0.035     3.332     0.200
     0.113     4.932     0.200
     0.113     5.133     0.200
     0.060     4.332     0.200
     0.181     5.332     0.200
     0.220     6.531     0.200
     0.224     7.232     0.200
     0.224     7.432     0.200
     0.261     8.633     0.200
     0.272     8.832     0.200
     0.272     9.031     0.200
     0.395    12.633     0.200
     0.674    22.332     0.200
     0.830    27.582     0.200
     0.104     4.945     0.200
     0.121     5.043     0.200
     0.158     6.215     0.200
     0.185     6.754     0.200
     0.190     7.395     0.200
     0.230     7.465     0.200
     0.249     8.105     0.200
     0.409    12.816     0.200
     0.561    16.715     0.200
     0.079     4.328     0.200
     0.148     4.328     0.200
     0.191     6.728     0.200
     0.246     7.828     0.200
     0.266     8.728     0.200
     0.282     9.028     0.200
     0.261     8.628     0.200
     0.230     9.038     0.200
     0.652    21.828     0.200
     0.814    26.578     0.200
     0.033     3.660     0.200
     0.034     3.059     0.200
     0.055     4.367     0.200
     0.122     5.520     0.200
     0.227     7.258     0.200
     0.232     7.879     0.200
     0.191     8.160     0.200
     0.255     8.750     0.200
     0.279     8.809     0.200
     0.267     8.879     0.200
     0.299     9.598     0.200
     0.551    17.059     0.200
     0.675    20.660     0.200
     0.829    27.309     0.200
     1.139    36.457     0.200
     0.060     3.691     0.200
     0.032     3.594     0.200
     0.036     3.391     0.200
     0.056     4.594     0.200
     0.110     5.480     0.200
     0.120     5.582     0.200
     0.189     5.242     0.200
     0.193     7.691     0.200
     0.230     7.492     0.200
     0.254     8.691     0.200
     0.266     8.891     0.200
     0.298     9.891     0.200
     0.551    16.742     0.200
     0.835    27.992     0.200
     0.044     3.906     0.200
     0.082     4.008     0.200
     0.111     5.637     0.200
     0.183     5.508     0.200
     0.241     9.535     0.200
     0.303    10.008     0.200
     0.305    10.105     0.200
     0.836    26.105     0.200
     2.067    63.906     0.200
     2.530    74.406     0.200
     2.597    77.605     0.200
     2.836    82.105     0.200
     2.068    63.906     0.200
     2.916    84.605     0.200
     0.020     3.758     0.200
     0.048     3.656     0.200
     0.057     3.555     0.200
     0.089     4.688     0.200
     0.083     4.867     0.200
     0.112     5.328     0.200
     0.196     5.984     0.200
     0.200     6.688     0.200
     0.253     7.906     0.200
     0.221     8.609     0.200
     0.265     8.773     0.200
     0.819    26.406     0.200
     0.017     4.074     0.200
     0.034     3.973     0.200
     0.111     5.203     0.200
     0.267     9.176     0.200
     0.198     7.773     0.200
     0.277     9.074     0.200
     0.280     9.223     0.200
     0.304     9.676     0.200
     0.560    17.523     0.200
     0.677    21.074     0.200
     0.839    28.074     0.200
     0.833    27.125     0.200
     1.009    32.055     0.200
     2.042    63.074     0.200
     2.567    77.074     0.200
     2.700    81.074     0.200
     0.113     5.074     0.200
     0.133     5.734     0.200
     0.226     7.344     0.200
     0.194     7.504     0.200
     0.283     8.895     0.200
     0.291     9.645     0.200
     0.289     9.164     0.200
     0.844    26.895     0.200
     0.997    31.383     0.200
     1.053    33.934     0.200
     1.112    33.145     0.200
     2.354    73.246     0.200
     2.572    78.145     0.200
     0.015     4.047     0.200
     0.049     4.047     0.200
     0.096     4.547     0.200
     0.203     6.648     0.200
     0.207     6.523     0.200
     0.262     8.953     0.200
     0.261     8.547     0.200
     0.270     8.797     0.200
     0.213     7.578     0.200
     0.292     9.328     0.200
     0.822    26.750     0.200
     0.019     3.602     0.200
     0.032     3.500     0.200
     0.113     4.930     0.200
     0.179     5.602     0.200
     0.221     7.203     0.200
     0.225     7.398     0.200
     0.196     7.305     0.200
     0.277     9.000     0.200
     0.278     9.352     0.200
     0.304     9.602     0.200
     0.678    21.602     0.200
     0.840    28.102     0.200
     0.047     3.742     0.200
     0.066     3.641     0.200
     0.105     4.812     0.200
     0.180     5.992     0.200
     0.204     6.844     0.200
     0.209     6.781     0.200
     0.230     8.039     0.200
     0.240     7.891     0.200
     0.268     8.289     0.200
     0.220     8.266     0.200
     0.043     4.322     0.200
     0.088     5.132     0.200
     0.063     4.222     0.200
     0.177     6.072     0.200
     0.203     6.822     0.200
     0.208     6.832     0.200
     0.234     7.962     0.200
     0.243     8.112     0.200
     0.250     8.822     0.200
     0.270     8.792     0.200
     0.219     8.432     0.200
     0.052     2.551     0.200
     0.029     2.852     0.200
     0.043     2.852     0.200
     0.066     4.020     0.200
     0.106     4.742     0.200
     0.111     4.652     0.200
     0.216     6.652     0.200
     0.220     6.922     0.200
     0.203     6.750     0.200
     0.251     7.941     0.200
     0.262     8.191     0.200
     0.268     9.551     0.200
     0.291     8.762     0.200
     0.051     3.695     0.200
     0.055     3.695     0.200
     0.127     5.617     0.200
     0.077     4.934     0.200
     0.119     3.695     0.200
     0.181     7.035     0.200
     0.239     8.066     0.200
     0.193     7.676     0.200
     0.311     9.195     0.200
     0.327    10.727     0.200
     0.355    11.246     0.200
     1.065    32.695     0.200
     2.403    74.195     0.200
     2.583    77.195     0.200
     2.716    80.695     0.200
     0.021     4.016     0.200
     0.045     3.914     0.200
     0.064     4.266     0.200
     0.103     5.215     0.200
     0.052     4.617     0.200
     0.052     5.016     0.200
     0.111     5.566     0.200
     0.208     8.316     0.200
     0.291     9.516     0.200
     0.391    12.617     0.200
     1.017    30.816     0.200
     1.058    33.977     0.200
     1.130    34.914     0.200
     1.130    35.016     0.200
     1.178    37.016     0.200
     2.031    64.016     0.200
     2.332    72.516     0.200
     2.557    74.016     0.200
     2.626    76.016     0.200
     2.958    86.016     0.200
     2.334    72.516     0.200
     2.821    82.094     0.200
     0.050     3.543     0.200
     0.051     3.863     0.200
     0.032     3.242     0.200
     0.046     3.242     0.200
     0.103     4.871     0.200
     0.067     4.562     0.200
     0.111     5.133     0.200
     0.216     6.145     0.200
     0.213     7.984     0.200
     0.220     7.145     0.200
     0.204     8.191     0.200
     0.259     8.742     0.200
     0.266     8.543     0.200
     0.288     9.242     0.200
     0.382    12.305     0.200
     0.062     3.680     0.200
     0.062     4.570     0.200
     0.017     3.980     0.200
     0.035     3.781     0.200
     0.062     4.590     0.200
     0.110     5.281     0.200
     0.199     8.160     0.200
     0.213     7.730     0.200
     0.222     7.352     0.200
     0.275     9.172     0.200
     0.274     9.531     0.200
     0.302     9.723     0.200
     0.399    12.832     0.200
     0.051     4.406     0.200
     0.050     2.977     0.200
     0.026     4.078     0.200
     0.046     3.875     0.200
     0.069     4.688     0.200
     0.106     5.180     0.200
     0.216     7.336     0.200
     0.208     8.266     0.200
     0.207     8.406     0.200
     0.262     8.805     0.200
     0.264     8.727     0.200
     0.289     9.375     0.200
     1.183    37.180     0.200
     0.023     3.750     0.200
     0.031     4.547     0.200
     0.061     4.828     0.200
     0.070     4.250     0.200
     0.112     5.453     0.200
     0.087     4.148     0.200
     0.102     5.453     0.200
     0.208     6.953     0.200
     0.204     7.773     0.200
     0.189     5.250     0.200
     0.201     6.250     0.200
     0.207     7.453     0.200
     0.216     7.547     0.200
     0.237     7.750     0.200
     0.248     8.547     0.200
     0.232     9.047     0.200
     0.342    10.953     0.200
     1.083    33.023     0.200
     0.011     3.992     0.200
     0.076     4.992     0.200
     0.078     4.789     0.200
     0.037     4.188     0.200
     0.106     5.188     0.200
     0.066     4.992     0.200
     0.220     8.188     0.200
     0.217     6.391     0.200
     0.209     7.758     0.200
     0.281     9.539     0.200
     0.295     9.688     0.200
     0.316    10.289     0.200
     0.420    13.586     0.200
     0.059     3.547     0.200
     0.059     4.148     0.200
     0.019     4.445     0.200
     0.039     4.148     0.200
     0.116     5.438     0.200
     0.064     4.570     0.200
     0.108     5.266     0.200
     0.175     5.047     0.200
     0.215     5.750     0.200
     0.211     8.078     0.200
     0.202     8.250     0.200
     0.272     9.047     0.200
     0.298     9.547     0.200
     0.396    12.750     0.200
     0.037     4.125     0.200
     0.035     2.475     0.200
     0.059     2.574     0.200
     0.095     4.824     0.200
     0.100     4.674     0.200
     0.081     4.674     0.200
     0.207     6.855     0.200
     0.218     8.715     0.200
     0.252     8.475     0.200
     0.276     8.865     0.200
     0.050     3.699     0.200
     0.015     3.297     0.200
     0.109     5.258     0.200
     0.160     6.387     0.200
     0.159     6.797     0.200
     0.251     9.520     0.200
     0.262     8.297     0.200
     0.300     9.699     0.200
     0.315    10.199     0.200
     0.433    13.598     0.200
     0.032     4.154     0.200
     0.044     4.305     0.200
     0.099     5.244     0.200
     0.033     4.154     0.200
     0.066     4.754     0.200
     0.090     5.055     0.200
     0.160     4.555     0.200
     0.195     6.455     0.200
     0.244     8.555     0.200
     0.253     8.445     0.200
     0.246     8.195     0.200
     0.046     3.305     0.200
     0.061     3.617     0.200
     0.029     3.117     0.200
     0.103     5.047     0.200
     0.050     2.719     0.200
     0.175     4.367     0.200
     0.213     7.180     0.200
     0.208     5.617     0.200
     0.258     7.938     0.200
     0.249     8.055     0.200
     0.053     3.562     0.200
     0.056     4.141     0.200
     0.073     3.859     0.200
     0.104     5.242     0.200
     0.042     3.062     0.200
     0.063     4.383     0.200
     0.220     6.359     0.200
     0.225     7.547     0.200
     0.249     8.102     0.200
     0.260     8.383     0.200
     0.054     2.867     0.200
     0.054     4.176     0.200
     0.024     3.969     0.200
     0.042     2.867     0.200
     0.066     4.469     0.200
     0.108     4.969     0.200
     0.219     7.246     0.200
     0.203     8.078     0.200
     0.255     8.578     0.200
     0.265     8.676     0.200
     0.293     9.379     0.200
     0.084     5.066     0.200
     0.120     3.727     0.200
     0.128     6.238     0.200
     0.155     5.227     0.200
     0.162     6.156     0.200
     0.136     6.336     0.200
     0.142     4.828     0.200
     0.154     6.426     0.200
     0.193     6.676     0.200
     0.210     8.027     0.200
     0.264     8.695     0.200
     0.217     8.465     0.200
     0.298    10.227     0.200
     0.295     9.398     0.200
     0.287     7.926     0.200
     0.285     9.586     0.200
     1.182    35.797     0.200
     2.597    77.727     0.200
     0.050     4.352     0.200
     0.075     4.164     0.200
     0.062     3.766     0.200
     0.067     3.664     0.200
     0.079     5.055     0.200
     0.126     5.781     0.200
     0.220     7.766     0.200
     0.222     6.766     0.200
     0.228     7.586     0.200
     0.208     8.414     0.200
     0.270     8.844     0.200
     0.353    11.453     0.200
     0.020     3.945     0.200
     0.104     4.845     0.200
     0.066     3.845     0.200
     0.044     3.745     0.200
     0.053     4.445     0.200
     0.069     4.545     0.200
     0.215     7.245     0.200
     0.207     8.245     0.200
     0.267     8.745     0.200
     0.293     9.345     0.200
     1.058    33.465     0.200
     0.047     3.059     0.200
     0.047     4.480     0.200
     0.049     3.258     0.200
     0.072     4.668     0.200
     0.105     5.148     0.200
     0.210     6.059     0.200
     0.215     7.270     0.200
     0.209     8.359     0.200
     0.249     8.258     0.200
     0.259     8.559     0.200
     0.286     9.168     0.200
     0.383    12.367     0.200
     1.064    33.648     0.200
     2.024    61.559     0.200
     2.557    77.059     0.200
     0.014     2.277     0.200
     0.059     3.574     0.200
     0.057     4.105     0.200
     0.068     4.414     0.200
     0.103     4.695     0.200
     0.211     6.176     0.200
     0.215     6.824     0.200
     0.205     7.336     0.200
     0.264     8.324     0.200
     0.273     8.234     0.200
     1.171    36.977     0.200
     0.029     3.391     0.200
     0.035     3.695     0.200
     0.069     2.695     0.200
     0.087     4.594     0.200
     0.108     4.695     0.200
     0.225     7.492     0.200
     0.205     6.094     0.200
     0.211     6.594     0.200
     0.205     7.594     0.200
     0.354    10.594     0.200
     0.009     3.359     0.200
     0.041     3.562     0.200
     0.077     2.859     0.200
     0.073     4.340     0.200
     0.103     4.590     0.200
     0.070     4.633     0.200
     0.205     7.961     0.200
     0.214     6.461     0.200
     0.216     7.020     0.200
     0.204     8.180     0.200
     0.286     9.520     0.200
     0.294     9.270     0.200
     0.314     9.789     0.200
     1.151    36.660     0.200
     2.059    63.961     0.200
     2.562    75.961     0.200
     2.695    80.961     0.200
     2.762    83.961     0.200
     2.059    63.961     0.200
     2.950    89.961     0.200
     0.009     2.312     0.200
     0.010     3.672     0.200
     0.060     3.117     0.200
     0.087     4.031     0.200
     0.088     3.617     0.200
     0.109     5.008     0.200
     0.180     5.414     0.200
     0.186     5.961     0.200
     0.182     6.914     0.200
     0.222     7.305     0.200
     0.227     7.477     0.200
     0.247     7.586     0.200
     0.244     8.516     0.200
     0.331     9.914     0.200
     0.036     4.258     0.200
     0.038     2.748     0.200
     0.030     3.048     0.200
     0.062     3.148     0.200
     0.090     4.608     0.200
     0.086     4.818     0.200
     0.191     7.948     0.200
     0.194     5.548     0.200
     0.199     6.738     0.200
     0.224     8.548     0.200
     0.248     8.448     0.200
     0.255     8.448     0.200
     0.277     8.748     0.200
     0.357    10.448     0.200
     1.134    36.348     0.200
     2.020    61.948     0.200
     2.541    76.948     0.200
     2.674    79.948     0.200
     0.029     2.099     0.200
     0.062     4.009     0.200
     0.035     1.999     0.200
     0.078     3.499     0.200
     0.057     3.909     0.200
     0.112     5.129     0.200
     0.118     4.819     0.200
     0.186     5.249     0.200
     0.194     6.929     0.200
     0.220     7.999     0.200
     0.228     7.309     0.200
     0.257     8.429     0.200
     0.268     8.509     0.200
     0.299     9.169     0.200
     0.050     2.176     0.200
     0.050     3.348     0.200
     0.065     3.176     0.200
     0.025     1.777     0.200
     0.046     2.875     0.200
     0.107     5.086     0.200
     0.105     4.664     0.200
     0.070     4.348     0.200
     0.175     4.926     0.200
     0.211     5.676     0.200
     0.207     7.426     0.200
     0.215     6.664     0.200
     0.253     8.484     0.200
     0.207     7.547     0.200
     0.263     8.457     0.200
     0.264     9.176     0.200
     0.289     8.977     0.200
     0.049     2.906     0.200
     0.030     3.625     0.200
     0.142     4.203     0.200
     0.144     5.656     0.200
     0.158     4.703     0.200
     0.184     7.047     0.200
     0.119     5.281     0.200
     0.188     7.133     0.200
     0.243     6.953     0.200
     0.291     9.703     0.200
     0.302     9.555     0.200
     0.317     9.914     0.200
     0.337    10.773     0.200
     0.378    11.516     0.200
     0.076     4.719     0.200
     0.076     4.559     0.200
     0.054     4.199     0.200
     0.086     4.020     0.200
     0.133     5.879     0.200
     0.117     5.150     0.200
     0.117     5.369     0.200
     0.190     7.809     0.200
     0.278     8.980     0.200
     0.278     9.279     0.200
     0.289     9.619     0.200
     0.316    10.109     0.200
     0.412    13.219     0.200
     0.048     4.375     0.200
     0.063     3.117     0.200
     0.158     5.016     0.200
     0.159     6.418     0.200
     0.114     6.188     0.200
     0.172     6.816     0.200
     0.202     7.637     0.200
     0.198     7.688     0.200
     0.312    10.406     0.200
     0.336    10.945     0.200
     0.356    11.426     0.200
     0.395    12.785     0.200
     0.465    15.188     0.200
     0.055     3.219     0.200
     0.036     4.180     0.200
     0.149     5.520     0.200
     0.151     5.707     0.200
     0.165     5.219     0.200
     0.191     7.457     0.200
     0.194     7.379     0.200
     0.114     5.039     0.200
     0.248     7.469     0.200
     0.297    10.719     0.200
     0.308     9.648     0.200
     0.323    10.500     0.200
     0.343    10.828     0.200
     0.365    12.469     0.200
     0.076     5.240     0.200
     0.116     5.791     0.200
     0.115     5.641     0.200
     0.091     4.240     0.200
     0.124     6.141     0.200
     0.226     7.939     0.200
     0.198     7.740     0.200
     0.252     8.340     0.200
     0.313    10.141     0.200
     0.300     9.939     0.200
     0.049     3.059     0.200
     0.049     3.656     0.200
     0.026     3.258     0.200
     0.047     3.156     0.200
     0.106     5.105     0.200
     0.105     4.559     0.200
     0.071     4.156     0.200
     0.175     4.957     0.200
     0.210     6.457     0.200
     0.207     6.957     0.200
     0.214     6.457     0.200
     0.208     7.559     0.200
     0.252     7.957     0.200
     0.048     4.035     0.200
     0.029     3.156     0.200
     0.048     3.254     0.200
     0.103     5.004     0.200
     0.071     4.574     0.200
     0.106     4.484     0.200
     0.177     5.055     0.200
     0.210     6.055     0.200
     0.215     7.145     0.200
     0.207     7.805     0.200
     0.249     8.043     0.200
     0.259     8.406     0.200
     0.208     7.535     0.200
     0.262     9.305     0.200
     0.018     3.547     0.200
     0.074     4.246     0.200
     0.079     3.945     0.200
     0.092     4.547     0.200
     0.055     3.145     0.200
     0.083     4.746     0.200
     0.144     5.805     0.200
     0.148     4.445     0.200
     0.203     4.945     0.200
     0.205     6.945     0.200
     0.216     7.945     0.200
     0.291     9.617     0.200
     0.014     3.484     0.200
     0.066     3.285     0.200
     0.124     3.885     0.200
     0.149     5.266     0.200
     0.135     3.984     0.200
     0.153     5.096     0.200
     0.165     5.305     0.200
     0.143     5.564     0.200
     0.211     6.494     0.200
     0.225     6.654     0.200
     0.229     6.885     0.200
     0.022     2.407     0.200
     0.040     3.207     0.200
     0.091     4.207     0.200
     0.091     4.207     0.200
     0.110     4.907     0.200
     0.152     6.526     0.200
     0.212     8.207     0.200
     0.224     6.907     0.200
     0.222     6.207     0.200
     0.199     7.606     0.200
     0.289    10.207     0.200
     0.299     9.606     0.200
     0.307     9.517     0.200
     0.328    10.307     0.200
     2.073    64.707     0.200
     2.570    75.907     0.200
     0.057     4.352     0.200
     0.048     3.750     0.200
     0.065     3.051     0.200
     0.083     4.992     0.200
     0.107     4.551     0.200
     0.182     5.102     0.200
     0.205     7.602     0.200
     0.211     6.711     0.200
     0.219     7.941     0.200
     0.229     7.410     0.200
     0.250     8.602     0.200
     0.239     7.621     0.200
     0.268     8.090     0.200
     0.356    10.352     0.200
     1.125    35.852     0.200
     2.549    76.852     0.200
     0.058     2.648     0.200
     0.099     3.949     0.200
     0.167     5.449     0.200
     0.111     5.148     0.200
     0.192     7.230     0.200
     0.197     7.359     0.200
     0.251     6.699     0.200
     0.311    10.449     0.200
     0.324    10.199     0.200
     0.345    10.629     0.200
     0.387    12.250     0.200
     0.046     4.273     0.200
     0.022     3.004     0.200
     0.055     4.805     0.200
     0.110     5.004     0.200
     0.104     4.004     0.200
     0.120     5.703     0.200
     0.193     6.805     0.200
     0.200     6.805     0.200
     0.198     6.504     0.200
     0.197     6.805     0.200
     0.230     7.305     0.200
     0.226     7.805     0.200
     0.249     9.504     0.200
     0.036     3.125     0.200
     0.063     4.219     0.200
     0.108     4.828     0.200
     0.175     5.727     0.200
     0.211     8.727     0.200
     0.220     7.328     0.200
     0.200     7.727     0.200
     0.276     8.930     0.200
     0.383    10.727     0.200
     2.042    63.727     0.200
     2.565    75.727     0.200
     2.744    81.727     0.200
     0.046     4.041     0.200
     0.050     2.941     0.200
     0.073     4.551     0.200
     0.185     6.141     0.200
     0.212     7.090     0.200
     0.208     6.141     0.200
     0.205     7.891     0.200
     0.210     8.260     0.200
     0.259     8.451     0.200
     0.250     8.781     0.200
     0.285     9.061     0.200
     0.369    10.141     0.200
     0.385    12.180     0.200
     2.555    76.641     0.200
     0.007     3.791     0.200
     0.037     2.791     0.200
     0.065     4.691     0.200
     0.069     5.391     0.200
     0.075     4.291     0.200
     0.105     4.701     0.200
     0.166     6.291     0.200
     0.208     8.291     0.200
     0.202     8.291     0.200
     0.215     5.791     0.200
     0.218     7.791     0.200
     0.275     9.391     0.200
     0.284     9.342     0.200
     0.307     9.871     0.200
     0.410    13.201     0.200
     1.113    35.291     0.200
     2.563    78.291     0.200
     0.062     1.979     0.200
     0.078     2.479     0.200
     0.224     8.379     0.200
     0.310     9.779     0.200
     0.291     9.078     0.200
     0.296     9.180     0.200
     0.427    13.578     0.200
     1.090    34.879     0.200
     2.544    76.879     0.200
     0.026     3.465     0.200
     0.019     3.164     0.200
     0.055     3.996     0.200
     0.055     4.395     0.200
     0.082     3.867     0.200
     0.081     4.664     0.200
     0.089     4.766     0.200
     0.167     5.766     0.200
     0.189     7.746     0.200
     0.220     8.266     0.200
     0.285     9.367     0.200
     0.295     9.594     0.200
     0.321    10.086     0.200
     1.108    35.266     0.200
     0.033     3.413     0.200
     0.030     4.442     0.200
     0.036     3.513     0.200
     0.070     4.913     0.200
     0.095     5.232     0.200
     0.156     5.513     0.200
     0.191     6.612     0.200
     0.245     8.772     0.200
     0.232     9.192     0.200
     0.270     8.652     0.200
     0.056     3.883     0.200
     0.061     4.523     0.200
     0.026     3.223     0.200
     0.069     4.824     0.200
     0.098     4.812     0.200
     0.137     4.273     0.200
     0.137     5.602     0.200
     0.148     5.523     0.200
     0.183     5.922     0.200
     0.176     6.023     0.200
     0.186     5.984     0.200
     0.234     8.473     0.200
     0.275     8.965     0.200
     0.291     8.812     0.200
     0.361    11.523     0.200
     0.020     2.355     0.200
     0.059     4.004     0.200
     0.059     3.953     0.200
     0.038     1.855     0.200
     0.063     4.355     0.200
     0.176     5.504     0.200
     0.180     5.754     0.200
     0.172     6.523     0.200
     0.211     7.254     0.200
     0.201     7.953     0.200
     0.216     6.152     0.200
     0.220     7.504     0.200
     0.261     8.734     0.200
     0.298     9.402     0.200
     0.036     3.879     0.200
     0.084     5.258     0.200
     0.089     4.477     0.200
     0.101     5.629     0.200
     0.117     5.957     0.200
     0.185     7.188     0.200
     0.192     5.977     0.200
     0.194     6.957     0.200
     0.265     9.027     0.200
     0.232     9.508     0.200
     0.302    10.508     0.200
     0.315    10.406     0.200
     0.375    11.906     0.200
     1.203    37.277     0.200
     2.375    73.078     0.200
     2.539    75.277     0.200
     2.671    80.777     0.200
     2.845    85.078     0.200
     2.376    73.078     0.200
     2.925    88.277     0.200
     0.044     4.203     0.200
     0.031     3.094     0.200
     0.053     2.496     0.200
     0.075     4.836     0.200
     0.177     6.574     0.200
     0.174     5.145     0.200
     0.187     5.895     0.200
     0.177     6.984     0.200
     0.207     6.094     0.200
     0.204     6.895     0.200
     0.247     8.465     0.200
     0.212     8.324     0.200
     0.258     9.395     0.200
     0.282     9.266     0.200
     0.366    10.395     0.200
     0.363    11.336     0.200
     0.037     3.602     0.200
     0.071     4.203     0.200
     0.080     4.852     0.200
     0.085     4.000     0.200
     0.105     5.352     0.200
     0.127     4.703     0.200
     0.125     6.203     0.200
     0.116     5.305     0.200
     0.179     6.703     0.200
     0.187     5.703     0.200
     0.188     6.344     0.200
     0.259     8.703     0.200
     0.236     9.133     0.200
     0.299     9.984     0.200
     0.310     9.781     0.200
     0.369    11.555     0.200
     2.065    64.703     0.200
     2.534    74.703     0.200
     0.028     4.184     0.200
     0.050     3.586     0.200
     0.068     3.086     0.200
     0.087     5.023     0.200
     0.168     6.516     0.200
     0.181     5.484     0.200
     0.203     5.984     0.200
     0.203     6.484     0.200
     0.209     6.996     0.200
     0.202     7.484     0.200
     0.190     7.516     0.200
     0.248     8.734     0.200
     0.265     8.695     0.200
     1.159    36.984     0.200
     2.002    60.484     0.200
     2.546    75.984     0.200
     2.680    79.484     0.200
     0.028     3.352     0.200
     0.032     4.250     0.200
     0.054     4.051     0.200
     0.049     3.652     0.200
     0.068     4.051     0.200
     0.087     4.750     0.200
     0.167     6.551     0.200
     0.180     5.301     0.200
     0.208     6.852     0.200
     0.202     7.551     0.200
     0.208     6.652     0.200
     0.189     7.160     0.200
     0.201     6.551     0.200
     0.189     7.262     0.200
     0.265     8.551     0.200
     0.350    11.051     0.200
     0.075     4.703     0.200
     0.013     3.676     0.200
     0.076     4.074     0.200
     0.078     3.273     0.200
     0.049     4.273     0.200
     0.078     4.766     0.200
     0.154     4.824     0.200
     0.142     6.324     0.200
     0.147     6.074     0.200
     0.198     7.574     0.200
     0.210     7.055     0.200
     0.313     9.926     0.200
     0.313    10.363     0.200
     0.065     4.642     0.200
     0.049     5.202     0.200
     0.108     5.142     0.200
     0.114     5.941     0.200
     0.095     4.742     0.200
     0.184     7.572     0.200
     0.247     9.032     0.200
     0.255     8.342     0.200
     0.248     9.481     0.200
     0.251     9.842     0.200
     0.285    10.842     0.200
     0.291     9.572     0.200
     0.323    10.752     0.200
     0.325     9.592     0.200
     0.423    13.771     0.200
     0.041     4.355     0.200
     0.044     3.467     0.200
     0.083     4.477     0.200
     0.026     3.766     0.200
     0.063     4.266     0.200
     0.165     6.516     0.200
     0.090     5.096     0.200
     0.190     6.166     0.200
     0.194     6.777     0.200
     0.185     7.566     0.200
     0.194     6.547     0.200
     0.157     6.176     0.200
     0.168     7.566     0.200
     0.247     8.566     0.200
     0.281     8.996     0.200
     1.173    33.566     0.200
     2.538    76.566     0.200
     2.606    78.666     0.200
     3.503   102.967     0.200
     0.023     3.244     0.200
     0.046     3.043     0.200
     0.072     3.244     0.200
     0.094     4.244     0.200
     0.094     4.574     0.200
     0.169     5.443     0.200
     0.179     6.232     0.200
     0.198     6.184     0.200
     0.192     5.844     0.200
     0.263     8.123     0.200
     0.084     3.275     0.200
     0.171     4.225     0.200
     0.187     5.775     0.200
     0.230     7.975     0.200
     1.144    35.975     0.200
     2.529    76.475     0.200
     0.567    19.037     0.200
     3.062    91.066     0.200
     0.688    22.436     0.200
     1.632    52.336     0.200
     1.861    58.336     0.200
     2.470    73.336     0.200
     2.381    72.535     0.200
     1.168    36.693     0.200
     2.134    64.193     0.200
     2.429    75.793     0.200
     3.036    90.934     0.200
     3.408   100.193     0.200
     0.842    26.352     0.200
     1.538    47.652     0.200
     1.788    56.352     0.200
     2.280    69.451     0.200
     2.362    71.051     0.200
     0.773    24.688     0.200
     0.825    26.391     0.200
     1.715    52.391     0.200
     2.374    68.992     0.200
     2.459    74.094     0.200
     0.997    32.199     0.200
     1.786    55.430     0.200
     0.697    22.096     0.200
     1.760    56.395     0.200
     1.949    60.596     0.200
     3.517   107.346     0.200
     0.626    20.734     0.200
     0.609    18.977     0.200
     0.950    29.977     0.200
     2.187    65.945     0.200
     2.181    65.578     0.200
     2.265    67.676     0.200
     0.610    20.965     0.200
     1.168    36.529     0.200
     1.746    55.830     0.200
     1.950    60.730     0.200
     2.175    66.830     0.200
     2.672    81.000     0.200
     2.699    81.879     0.200
     2.840    82.930     0.200
     3.173    93.930     0.200
     0.486    16.597     0.200
     0.677    23.197     0.200
     2.312    66.907     0.200
     2.513    73.897     0.200
     2.414    73.097     0.200
     0.209     8.768     0.200
     2.245    66.897     0.200
     2.214    68.008     0.200
     2.444    74.918     0.200
     2.627    78.107     0.200
     0.269     9.012     0.200
     1.311    39.961     0.200
     2.012    60.461     0.200
     2.181    65.910     0.200
     2.572    75.461     0.200
     2.741    80.199     0.200
     2.774    81.723     0.200
     3.001    85.961     0.200
     3.507   106.160     0.200
     0.766    23.016     0.200
     2.030    61.820     0.200
     3.694   108.469     0.200
     4.400   131.617     0.200
     4.536   132.719     0.200
     0.677    20.961     0.200
     1.207    37.969     0.200
     0.388    12.879     0.200
     0.388    13.527     0.200
     0.956    30.949     0.200
     2.085    65.438     0.200
     1.472    44.204     0.200
     2.157    66.004     0.200
     2.884    84.114     0.200
     3.510   101.734     0.200
     3.994   115.704     0.200
     0.736    23.586     0.200
     1.991    61.438     0.200
     0.465    15.174     0.200
     2.387    69.873     0.200
     2.795    82.434     0.200
     0.608    20.762     0.200
     1.759    54.859     0.200
     2.072    63.859     0.200
     2.157    66.262     0.200
     2.398    70.961     0.200
     2.613    78.039     0.200
     1.724    53.733     0.200
     1.866    59.543     0.200
     1.994    60.943     0.200
     2.081    62.943     0.200
     2.582    75.543     0.200
     0.521    14.994     0.200
     1.246    38.254     0.200
     2.137    66.205     0.200
     2.711    82.033     0.200
     1.881    57.152     0.200
     2.151    63.883     0.200
     0.786    25.562     0.200
     1.765    54.186     0.200
     1.874    56.686     0.200
     1.988    62.086     0.200
     2.307    69.625     0.200
     0.525    18.266     0.200
     2.254    67.445     0.200
     1.879    57.148     0.200
     2.288    68.359     0.200
     0.675    22.262     0.200
     1.282    40.121     0.200
     2.290    69.363     0.200
     0.627    20.758     0.200
     0.605    20.844     0.200
     1.179    35.711     0.200
     1.652    52.117     0.200
     0.577    18.422     0.200
     0.643    19.961     0.200
     1.303    40.723     0.200
     2.297    69.359     0.200
     0.327    11.590     0.200
     1.350    41.129     0.200
     2.521    75.930     0.200
     2.533    77.129     0.200
     3.490   105.750     0.200
     0.653    21.730     0.200
     2.142    67.156     0.200
     0.687    22.629     0.200
     2.212    65.738     0.200
     0.676    21.480     0.200
     2.269    69.781     0.200
     2.442    75.480     0.200
     0.391    11.945     0.200
     2.185    66.375     0.200
     0.575    16.871     0.200
     0.649    21.402     0.200
     1.087    33.463     0.200
     1.857    58.553     0.200
     2.290    68.062     0.200
     0.476    16.250     0.200
     2.103    62.551     0.200
     0.503    17.062     0.200
     0.606    19.363     0.200
     1.761    54.664     0.200
     1.761    55.633     0.200
     2.826    83.164     0.200
     4.015   119.664     0.200
     0.241     9.203     0.200
     1.913    57.562     0.200
     1.924    56.871     0.200
     1.812    53.363     0.200
     2.044    59.613     0.200
     2.583    75.621     0.200
     0.602    19.549     0.200
     2.107    63.281     0.200
     2.107    65.828     0.200
     4.683   136.828     0.200
     2.091    65.249     0.200
     2.115    61.250     0.200
     3.096    92.086     0.200
     3.096    92.227     0.200
     0.851    26.491     0.200
     2.435    72.055     0.200
     2.506    73.094     0.200
     0.769    24.281     0.200
     2.025    60.797     0.200
     0.718    24.652     0.200
     0.839    27.613     0.200
     1.750    55.191     0.200
     1.979    61.742     0.200
     2.497    73.320     0.200
     2.565    74.531     0.200
     0.210     8.109     0.200
     2.632    77.619     0.200
     0.887    27.500     0.200
     0.943    30.301     0.200
     1.199    37.340     0.200
     1.623    50.141     0.200
     1.812    55.740     0.200
     2.047    62.250     0.200
     0.604    17.648     0.200
     0.673    22.078     0.200
     0.969    32.094     0.200
     1.650    53.102     0.200
     2.110    65.539     0.200
     2.200    68.102     0.200
     2.212    65.500     0.200
     3.355    99.000     0.200
     2.238    67.434     0.200
     0.641    21.312     0.200
     2.237    66.742     0.200
     0.655    21.527     0.200
     2.115    62.797     0.200
     2.439    70.496     0.200
     2.719    79.758     0.200
     0.325    10.547     0.200
     2.953    88.008     0.200
     2.976    87.203     0.200
     0.484    15.265     0.200
     1.681    52.665     0.200
     0.924    28.602     0.200
     2.081    62.543     0.200
     3.284    99.402     0.200
     1.232    38.586     0.200
     2.472    74.633     0.200
     0.606    18.887     0.200
     0.707    23.047     0.200
     1.620    50.938     0.200
     2.183    64.391     0.200
     0.655    20.586     0.200
     0.804    25.789     0.200
     2.329    69.930     0.200
     2.442    73.379     0.200
     2.494    72.328     0.200
     2.494    73.879     0.200
     0.979    30.828     0.200
     1.504    46.039     0.200
     2.471    75.258     0.200
     0.219     8.055     0.200
     0.240     8.406     0.200
     0.317    10.898     0.200
     0.338    11.453     0.200
     0.377    12.758     0.200
     0.576    18.945     0.200
     0.689    22.219     0.200
     0.689    23.039     0.200
     0.889    29.312     0.200
     1.032    33.797     0.200
     0.235     9.492     0.200
     0.261     9.828     0.200
     0.291    10.422     0.200
     0.363    12.812     0.200
     0.112     5.785     0.200
     0.248     9.426     0.200
     0.392    13.844     0.200
     0.419    14.184     0.200
     0.468    15.785     0.200
     0.495    16.863     0.200
     0.494    16.523     0.200
     0.596    19.664     0.200
     0.609    20.543     0.200
     0.630    21.023     0.200
     0.669    22.152     0.200
     0.804    26.496     0.200
     0.833    27.516     0.200
     0.832    27.516     0.200
     0.945    31.086     0.200
     1.035    33.414     0.200
     0.468    14.402     0.200
     1.826    57.684     0.200
     0.103     5.922     0.200
     0.117     6.039     0.200
     0.396    13.531     0.200
     0.420    14.578     0.200
     0.474    16.008     0.200
     0.494    16.633     0.200
     0.495    16.508     0.200
     0.599    19.867     0.200
     0.614    20.758     0.200
     0.635    21.633     0.200
     0.670    21.891     0.200
     0.205     7.645     0.200
     0.205     7.734     0.200
     0.280     9.863     0.200
     0.330    11.285     0.200
     0.329    11.434     0.200
     0.384    13.246     0.200
     0.513    17.375     0.200
     0.539    17.633     0.200
     0.554    18.375     0.200
     0.582    19.234     0.200
     0.653    21.902     0.200
     0.161     6.344     0.200
     0.181     6.914     0.200
     0.305    10.430     0.200
     0.401    13.688     0.200
     0.636    20.805     0.200
     0.651    21.367     0.200
     0.783    26.031     0.200
     0.114     5.078     0.200
     0.180     6.648     0.200
     0.199     6.969     0.200
     0.266     9.281     0.200
     0.492    16.430     0.200
     0.554    18.180     0.200
     0.702    22.859     0.200
     0.715    23.188     0.200
     0.949    30.914     0.200
     1.001    32.734     0.200
     0.998    32.797     0.200
     1.122    35.094     0.200
     0.071     5.000     0.200
     0.235     7.930     0.200
     0.325    10.875     0.200
     0.404    13.461     0.200
     0.470    16.039     0.200
     0.611    20.328     0.200
     0.676    22.039     0.200
     0.827    26.930     0.200
     0.863    27.961     0.200
     1.087    33.742     0.200
     1.098    35.422     0.200
     0.248     7.930     0.200
     0.266     9.219     0.200
     0.358    11.148     0.200
     0.465    15.520     0.200
     0.717    23.438     0.200
     0.864    28.359     0.200
     0.879    28.117     0.200
     1.285    40.609     0.200
     0.976    32.480     0.200
     1.419    44.051     0.200
     1.511    45.648     0.200
     1.766    55.289     0.200
     2.042    64.410     0.200
     2.105    66.051     0.200
     2.465    75.219     0.200
     2.517    75.379     0.200
     2.626    77.641     0.200
     2.626    79.867     0.200
     3.434   100.059     0.200
     0.052     2.883     0.200
     0.200     6.797     0.200
     0.340    10.469     0.200
     0.339    10.531     0.200
     0.377    12.023     0.200
     0.766    25.016     0.200
     1.197    39.023     0.200
     1.223    39.977     0.200
     1.224    39.703     0.200
     1.290    41.086     0.200
     0.206     7.133     0.200
     0.224     7.812     0.200
     0.268     9.062     0.200
     0.307    10.234     0.200
     0.329    11.215     0.200
     0.366    11.973     0.200
     0.560    18.324     0.200
     0.639    20.965     0.200
     0.700    22.863     0.200
     0.904    29.352     0.200
     0.164     5.906     0.200
     0.180     6.227     0.200
     0.209     6.844     0.200
     0.356    11.688     0.200
     0.441    14.789     0.200
     0.623    20.656     0.200
     0.692    22.602     0.200
     1.018    32.789     0.200
     1.022    33.688     0.200
     0.287    10.211     0.200
     0.336    11.477     0.200
     0.361    12.047     0.200
     0.362    12.438     0.200
     0.409    14.141     0.200
     0.461    15.773     0.200
     0.575    19.227     0.200
     0.600    19.867     0.200
     0.624    20.797     0.200
     0.623    20.680     0.200
     0.673    22.133     0.200
     0.763    25.203     0.200
     0.780    25.977     0.200
     0.817    27.070     0.200
     0.197     6.527     0.200
     0.150     6.750     0.200
     0.231     8.250     0.200
     0.308     9.738     0.200
     0.440    14.828     0.200
     0.676    22.000     0.200
     0.830    26.738     0.200
     0.824    26.688     0.200
     1.113    35.969     0.200
     0.955    30.789     0.200
     1.384    42.629     0.200
     1.475    44.250     0.200
     1.777    56.090     0.200
     2.477    74.309     0.200
     2.943    86.258     0.200
     0.176     6.234     0.200
     0.159     6.523     0.200
     0.220     7.934     0.200
     0.288     9.625     0.200
     0.660    21.562     0.200
     0.810    26.234     0.200
     0.809    26.562     0.200
     1.214    38.504     0.200
     0.378    11.086     0.200
     1.371    41.516     0.200
     1.780    56.223     0.200
     0.192     7.617     0.200
     0.207     8.445     0.200
     0.350    12.109     0.200
     0.351    12.039     0.200
     0.430    14.406     0.200
     0.463    16.016     0.200
     0.543    17.969     0.200
     0.546    18.070     0.200
     0.624    20.344     0.200
     0.649    21.258     0.200
     0.693    22.789     0.200
     0.747    23.820     0.200
     0.753    24.289     0.200
     0.764    25.469     0.200
     0.415    13.598     0.200
     0.420    13.266     0.200
     0.457    15.309     0.200
     0.556    18.355     0.200
     0.581    18.988     0.200
     0.631    20.988     0.200
     0.737    23.926     0.200
     1.079    34.996     0.200
     0.309    10.285     0.200
     0.317    10.207     0.200
     0.328    11.277     0.200
     0.355    11.715     0.200
     0.408    13.309     0.200
     0.478    15.758     0.200
     0.538    17.035     0.200
     0.578    18.816     0.200
     0.677    22.188     0.200
     0.775    24.727     0.200
     0.773    25.207     0.200
     0.106     5.617     0.200
     0.163     7.195     0.200
     0.259     9.234     0.200
     0.337    11.750     0.200
     0.352    12.289     0.200
     0.540    18.078     0.200
     0.598    20.398     0.200
     0.625    21.008     0.200
     0.652    21.969     0.200
     0.136     5.807     0.200
     0.246     9.356     0.200
     0.286    10.267     0.200
     0.374    12.906     0.200
     0.397    13.496     0.200
     0.461    15.387     0.200
     0.490    16.316     0.200
     0.531    17.807     0.200
     0.536    17.786     0.200
     0.640    21.066     0.200
     0.639    21.026     0.200
     0.666    22.606     0.200
     0.712    22.816     0.200
     0.711    23.097     0.200
     0.858    27.746     0.200
     0.205     7.141     0.200
     0.197     7.531     0.200
     0.404    13.684     0.200
     0.402    13.184     0.200
     0.410    13.551     0.200
     0.474    15.781     0.200
     0.570    19.004     0.200
     0.672    21.754     0.200
     0.697    22.844     0.200
     0.727    24.094     0.200
     0.774    25.262     0.200
     0.882    27.312     0.200
     0.931    30.301     0.200
     0.295     9.781     0.200
     0.299     9.703     0.200
     0.348    11.406     0.200
     0.368    11.961     0.200
     0.395    12.914     0.200
     0.471    15.609     0.200
     0.500    16.445     0.200
     0.541    17.266     0.200
     0.575    18.750     0.200
     0.575    18.484     0.200
     0.666    21.562     0.200
     0.730    23.914     0.200
     0.758    25.266     0.200
     0.774    24.875     0.200
     0.831    27.492     0.200
     0.917    29.945     0.200
     1.099    36.086     0.200
     0.285     9.848     0.200
     0.290    10.289     0.200
     0.331    11.078     0.200
     0.355    11.891     0.200
     0.374    12.777     0.200
     0.453    15.129     0.200
     0.478    15.898     0.200
     0.524    17.000     0.200
     0.555    18.047     0.200
     0.557    18.250     0.200
     0.585    18.918     0.200
     0.645    21.238     0.200
     0.643    21.188     0.200
     0.709    23.207     0.200
     0.737    24.348     0.200
     0.785    25.391     0.200
     0.836    26.379     0.200
     0.810    26.898     0.200
     0.932    30.910     0.200
     1.109    36.098     0.200
     0.277     9.676     0.200
     0.285    10.246     0.200
     0.327    11.176     0.200
     0.347    11.508     0.200
     0.367    12.738     0.200
     0.449    15.086     0.200
     0.471    15.918     0.200
     0.517    17.066     0.200
     0.548    17.969     0.200
     0.585    19.629     0.200
     0.639    20.688     0.200
     0.700    22.688     0.200
     0.729    24.027     0.200
     0.827    26.309     0.200
     0.178     6.422     0.200
     0.169     7.023     0.200
     0.281     9.594     0.200
     0.438    14.188     0.200
     0.652    21.531     0.200
     0.804    26.000     0.200
     0.800    25.750     0.200
     1.043    34.133     0.200
     1.208    38.477     0.200
     0.078     5.148     0.200
     0.161     6.348     0.200
     0.251     9.105     0.200
     0.299    10.445     0.200
     0.317    10.988     0.200
     0.458    15.285     0.200
     0.473    15.855     0.200
     0.517    18.078     0.200
     0.526    17.309     0.200
     0.555    18.176     0.200
     0.569    19.266     0.200
     0.689    22.598     0.200
     0.148     7.062     0.200
     0.290     9.781     0.200
     0.295    10.125     0.200
     0.290    10.070     0.200
     0.579    18.500     0.200
     0.596    19.305     0.200
     0.739    23.562     0.200
     0.745    23.766     0.200
     0.787    25.742     0.200
     1.005    32.055     0.200
     0.235     9.273     0.200
     0.295    10.902     0.200
     0.301    10.465     0.200
     0.419    15.012     0.200
     0.444    15.395     0.200
     0.479    15.883     0.200
     0.541    17.922     0.200
     0.611    20.223     0.200
     0.652    21.355     0.200
     0.670    22.082     0.200
     0.707    23.402     0.200
     0.758    25.512     0.200
     0.772    25.445     0.200
     0.809    26.355     0.200
     0.939    29.555     0.200
     0.942    30.605     0.200
     0.125     5.484     0.200
     0.222     8.430     0.200
     0.287    10.156     0.200
     0.291    10.258     0.200
     0.308    10.477     0.200
     0.322    11.219     0.200
     0.353    12.398     0.200
     0.426    14.852     0.200
     0.624    20.227     0.200
     0.664    21.719     0.200
     0.713    23.352     0.200
     0.801    26.172     0.200
     0.192     7.719     0.200
     0.236     9.172     0.200
     0.285    10.273     0.200
     0.311    11.391     0.200
     0.347    12.000     0.200
     0.357    12.305     0.200
     0.362    12.648     0.200
     0.503    16.812     0.200
     0.518    17.328     0.200
     0.595    19.719     0.200
     0.606    20.055     0.200
     0.680    22.625     0.200
     0.706    23.188     0.200
     0.076     5.281     0.200
     0.197     6.914     0.200
     0.333    10.680     0.200
     0.401    13.312     0.200
     0.452    14.891     0.200
     0.543    18.141     0.200
     0.550    17.961     0.200
     0.607    20.445     0.200
     0.812    26.375     0.200
     0.811    26.906     0.200
     0.822    26.734     0.200
     0.930    30.562     0.200
     1.071    34.242     0.200
     1.095    35.172     0.200
     1.142    36.227     0.200
     0.291    11.225     0.200
     0.320    11.895     0.200
     0.383    13.295     0.200
     0.397    14.074     0.200
     0.443    15.395     0.200
     0.495    17.645     0.200
     0.520    18.035     0.200
     0.543    18.176     0.200
     0.538    17.586     0.200
     0.547    18.814     0.200
     0.605    19.945     0.200
     0.700    23.285     0.200
     0.715    23.484     0.200
     0.733    24.186     0.200
     0.772    25.545     0.200
     0.805    26.205     0.200
     0.871    27.785     0.200
     0.114     4.953     0.200
     0.152     6.195     0.200
     0.222     7.859     0.200
     0.326    11.523     0.200
     0.339    11.328     0.200
     0.377    13.039     0.200
     0.527    17.906     0.200
     0.612    20.383     0.200
     0.644    21.547     0.200
     0.753    24.516     0.200
     1.115    36.023     0.200
     0.775    25.668     0.200
     0.864    28.105     0.200
     1.760    51.668     0.200
     1.850    54.816     0.200
     2.247    68.617     0.200
     2.560    73.219     0.200
     2.563    77.137     0.200
     3.077    89.328     0.200
     3.077    89.898     0.200
     0.580    19.247     0.200
     0.991    32.427     0.200
     2.180    66.427     0.200
     2.214    65.697     0.200
     2.685    78.847     0.200
     0.183     6.070     0.200
     0.267     8.773     0.200
     0.284     9.273     0.200
     0.318    10.172     0.200
     0.357    11.273     0.200
     0.635    20.273     0.200
     0.779    25.375     0.200
     0.783    25.086     0.200
     0.820    26.211     0.200
     0.856    27.500     0.200
     0.894    28.711     0.200
     0.891    29.086     0.200
     0.936    30.633     0.200
     1.042    33.547     0.200
     1.031    33.414     0.200
     1.055    34.133     0.200
     1.155    37.562     0.200
     0.115     5.781     0.200
     0.216     7.422     0.200
     0.235     8.875     0.200
     0.252     9.234     0.200
     0.393    13.055     0.200
     0.421    13.914     0.200
     0.472    15.641     0.200
     0.599    19.367     0.200
     0.613    19.922     0.200
     0.634    21.125     0.200
     0.671    21.938     0.200
     0.670    22.555     0.200
     0.685    22.594     0.200
     0.882    28.531     0.200
     0.949    31.320     0.200
     1.008    32.547     0.200
     1.597    51.172     0.200
     1.656    51.016     0.200
     1.687    52.883     0.200
     0.180     6.668     0.200
     0.309     9.758     0.200
     0.282     9.918     0.200
     0.321    10.539     0.200
     0.322    10.789     0.200
     0.335    11.117     0.200
     0.380    13.309     0.200
     0.422    13.777     0.200
     0.488    15.199     0.200
     0.473    15.559     0.200
     0.489    16.438     0.200
     0.572    19.109     0.200
     0.665    21.699     0.200
     0.912    29.488     0.200
     1.051    33.641     0.200
     1.219    39.199     0.200
     1.241    40.148     0.200
     0.219     7.813     0.200
     0.300    10.394     0.200
     0.368    11.604     0.200
     0.364    11.743     0.200
     0.442    14.913     0.200
     0.539    17.474     0.200
     0.584    19.163     0.200
     0.737    23.474     0.200
     0.813    25.974     0.200
     0.963    31.594     0.200
     1.063    34.104     0.200
     1.666    53.003     0.200
     1.753    55.753     0.200
     1.770    56.283     0.200
     0.792    24.014     0.200
     1.930    59.913     0.200
     2.489    76.073     0.200
     2.714    83.113     0.200
     0.154     5.906     0.200
     0.192     6.625     0.200
     0.247     8.297     0.200
     0.325    10.539     0.200
     0.684    22.625     0.200
     0.702    22.195     0.200
     0.745    23.844     0.200
     0.749    23.648     0.200
     0.745    24.289     0.200
     0.803    25.695     0.200
     0.834    26.328     0.200
     0.899    28.789     0.200
     0.998    31.805     0.200
     1.037    33.953     0.200
     0.147     6.301     0.200
     0.155     6.730     0.200
     0.228     7.883     0.200
     0.402    13.102     0.200
     0.502    16.582     0.200
     0.593    19.340     0.200
     0.660    22.250     0.200
     0.681    21.523     0.200
     0.740    23.941     0.200
     0.772    24.863     0.200
     0.784    25.410     0.200
     0.799    25.430     0.200
     0.807    26.211     0.200
     0.882    28.910     0.200
     0.937    30.883     0.200
     1.044    33.211     0.200
     1.201    37.500     0.200
     0.072     3.312     0.200
     0.233     8.203     0.200
     0.277     8.883     0.200
     0.351    11.203     0.200
     0.372    12.562     0.200
     0.396    13.203     0.200
     0.418    14.133     0.200
     0.455    14.312     0.200
     0.470    14.766     0.200
     0.539    17.516     0.200
     0.545    18.625     0.200
     0.686    22.180     0.200
     0.736    24.828     0.200
     0.870    27.969     0.200
     0.977    31.453     0.200
     1.212    38.320     0.200
     0.090     5.113     0.200
     0.194     7.180     0.200
     0.290    10.051     0.200
     0.301    10.840     0.200
     0.329    11.203     0.200
     0.458    14.840     0.200
     0.511    17.293     0.200
     0.679    22.160     0.200
     0.692    22.270     0.200
     0.697    22.660     0.200
     0.698    23.121     0.200
     0.723    24.250     0.200
     0.854    28.340     0.200
     0.974    31.871     0.200
     0.105     4.668     0.200
     0.176     6.418     0.200
     0.320    10.938     0.200
     0.450    15.016     0.200
     0.493    16.258     0.200
     0.679    21.965     0.200
     0.688    22.227     0.200
     0.700    22.395     0.200
     0.717    23.066     0.200
     0.835    27.555     0.200
     0.160     6.471     0.200
     0.269     9.000     0.200
     0.255     9.451     0.200
     0.369    11.771     0.200
     0.430    14.471     0.200
     0.467    15.100     0.200
     0.469    16.111     0.200
     0.467    16.111     0.200
     0.476    16.551     0.200
     0.705    22.131     0.200
     0.997    31.930     0.200
     1.214    38.650     0.200
     1.955    61.311     0.200
     0.117     4.398     0.200
     0.162     5.961     0.200
     0.182     6.219     0.200
     0.334    10.969     0.200
     0.444    14.117     0.200
     0.479    15.812     0.200
     0.668    21.719     0.200
     0.665    22.000     0.200
     0.686    21.953     0.200
     0.694    23.172     0.200
     0.701    21.938     0.200
     0.711    22.648     0.200
     0.751    24.141     0.200
     0.821    26.797     0.200
     0.998    33.047     0.200
     0.173     6.383     0.200
     0.309     9.305     0.200
     0.288     9.703     0.200
     0.309    10.695     0.200
     0.314    10.250     0.200
     0.377    13.094     0.200
     0.404    13.023     0.200
     0.458    15.031     0.200
     0.479    14.969     0.200
     0.489    16.281     0.200
     0.559    18.391     0.200
     0.648    20.516     0.200
     0.688    22.453     0.200
     0.658    21.992     0.200
     0.707    22.852     0.200
     0.813    26.039     0.200
     0.827    26.492     0.200
     0.870    27.695     0.200
     0.895    28.391     0.200
     1.038    34.023     0.200
     1.087    34.984     0.200
     1.177    36.969     0.200
     1.211    39.102     0.200
     1.234    39.633     0.200
     1.678    53.562     0.200
     1.693    53.969     0.200
     1.737    54.969     0.200
     1.820    57.234     0.200
     1.873    59.391     0.200
     1.896    60.102     0.200
     0.860    29.109     0.200
     1.896    57.805     0.200
     2.055    62.484     0.200
     2.020    64.430     0.200
     2.450    72.445     0.200
     2.501    76.133     0.200
     0.157     6.691     0.200
     0.179     6.871     0.200
     0.269    10.289     0.200
     0.338    11.039     0.200
     0.338    11.508     0.200
     0.546    18.289     0.200
     0.686    22.629     0.200
     0.694    23.059     0.200
     0.699    23.258     0.200
     0.707    22.449     0.200
     0.707    23.969     0.200
     0.746    24.559     0.200
     0.753    24.230     0.200
     0.790    25.301     0.200
     0.817    26.379     0.200
     0.101     4.773     0.200
     0.234     8.625     0.200
     0.221     7.793     0.200
     0.523    16.914     0.200
     0.530    17.496     0.200
     0.535    17.844     0.200
     0.559    18.305     0.200
     0.587    19.344     0.200
     0.730    23.965     0.200
     0.739    24.016     0.200
     0.755    24.543     0.200
     0.768    24.387     0.200
     0.801    25.637     0.200
     0.856    28.203     0.200
     0.910    29.477     0.200
     0.905    29.227     0.200
     1.057    34.344     0.200
     1.140    36.555     0.200
     1.166    37.266     0.200
     0.117     6.652     0.200
     0.179     8.633     0.200
     0.256    10.094     0.200
     0.310    10.922     0.200
     0.338    12.016     0.200
     0.390    13.344     0.200
     0.424    14.715     0.200
     0.413    14.992     0.200
     0.460    15.453     0.200
     0.584    19.016     0.200
     0.869    27.953     0.200
     0.881    28.105     0.200
     1.062    33.484     0.200
     1.606    49.695     0.200
     1.997    61.133     0.200
     2.035    62.004     0.200
     2.206    66.574     0.200
     0.170     6.746     0.200
     0.275     9.273     0.200
     0.262     9.445     0.200
     0.359    11.566     0.200
     0.437    13.914     0.200
     0.461    14.363     0.200
     0.470    15.383     0.200
     0.478    15.793     0.200
     0.537    16.285     0.200
     0.537    16.863     0.200
     0.687    22.695     0.200
     0.956    30.555     0.200
     1.051    33.805     0.200
     1.214    38.395     0.200
     1.790    56.023     0.200
     1.952    60.695     0.200
     2.045    63.336     0.200
     2.114    65.156     0.200
     0.207     6.586     0.200
     0.234     8.492     0.200
     0.323    10.820     0.200
     0.381    12.742     0.200
     0.441    14.820     0.200
     0.534    17.164     0.200
     0.541    18.070     0.200
     0.693    22.586     0.200
     0.797    25.969     0.200
     0.821    26.156     0.200
     0.847    28.281     0.200
     1.006    32.039     0.200
     1.014    32.203     0.200
     1.067    33.484     0.200
     1.052    34.961     0.200
     0.033     3.445     0.200
     0.154     6.488     0.200
     0.320    10.305     0.200
     0.370    11.465     0.200
     0.387    12.527     0.200
     0.476    16.406     0.200
     0.763    23.648     0.200
     0.974    30.328     0.200
     1.089    35.707     0.200
     1.119    35.508     0.200
     1.277    40.875     0.200
     1.715    54.367     0.200
     1.909    59.875     0.200
     1.966    61.637     0.200
     2.117    66.066     0.200
     0.172     6.895     0.200
     0.279     9.133     0.200
     0.300    10.195     0.200
     0.295    10.484     0.200
     0.339    11.766     0.200
     0.382    13.543     0.200
     0.461    14.246     0.200
     0.440    14.793     0.200
     0.499    16.613     0.200
     0.546    18.152     0.200
     0.625    20.594     0.200
     0.666    20.594     0.200
     0.671    20.973     0.200
     0.656    22.336     0.200
     0.709    23.543     0.200
     0.821    26.336     0.200
     0.816    26.652     0.200
     0.866    27.855     0.200
     0.869    27.613     0.200
     1.013    33.184     0.200
     1.070    33.664     0.200
     1.156    36.586     0.200
     1.217    38.812     0.200
     1.862    59.363     0.200
     0.095     8.797     0.200
     0.211    11.127     0.200
     0.286    12.387     0.200
     0.331    13.896     0.200
     0.349    13.816     0.200
     0.368    14.646     0.200
     0.510    17.887     0.200
     0.526    17.537     0.200
     0.539    18.816     0.200
     0.533    18.977     0.200
     0.587    20.896     0.200
     0.628    21.367     0.200
     0.618    21.236     0.200
     0.674    22.447     0.200
     0.690    22.758     0.200
     0.759    24.227     0.200
     1.216    38.137     0.200
     1.455    45.348     0.200
     1.516    47.197     0.200
     1.542    48.158     0.200
     1.926    58.527     0.200
     0.157     5.453     0.200
     0.158     6.312     0.200
     0.237     8.562     0.200
     0.297     9.805     0.200
     0.364    11.367     0.200
     0.361    11.562     0.200
     0.456    14.883     0.200
     0.494    15.422     0.200
     0.467    15.383     0.200
     0.488    16.461     0.200
     0.711    23.656     0.200
     0.734    23.188     0.200
     1.079    34.055     0.200
     1.091    35.977     0.200
     1.135    36.703     0.200
     1.343    42.773     0.200
     0.096     4.105     0.200
     0.113     5.023     0.200
     0.258     9.062     0.200
     0.327    10.824     0.200
     0.413    13.223     0.200
     0.412    14.715     0.200
     0.420    14.344     0.200
     0.438    14.934     0.200
     0.480    15.312     0.200
     0.526    17.883     0.200
     0.671    22.523     0.200
     0.738    23.492     0.200
     1.035    33.902     0.200
     0.037     4.410     0.200
     0.280     9.441     0.200
     0.390    13.422     0.200
     0.422    13.969     0.200
     0.560    18.730     0.200
     0.584    18.520     0.200
     0.826    27.781     0.200
     0.872    28.809     0.200
     0.917    29.762     0.200
     0.966    30.871     0.200
     0.970    31.730     0.200
     0.187     6.836     0.200
     0.226     7.906     0.200
     0.256     8.359     0.200
     0.333    11.234     0.200
     0.401    13.391     0.200
     0.501    16.469     0.200
     0.554    18.227     0.200
     0.704    22.844     0.200
     0.826    25.930     0.200
     0.832    27.094     0.200
     0.851    27.805     0.200
     0.861    27.258     0.200
     0.876    28.141     0.200
     0.893    29.664     0.200
     0.971    31.945     0.200
     1.094    35.570     0.200
     1.111    35.898     0.200
     1.136    36.609     0.200
     1.259    39.266     0.200
     0.037     3.467     0.200
     0.214     7.766     0.200
     0.537    17.936     0.200
     0.691    22.057     0.200
     0.813    25.746     0.200
     0.834    26.787     0.200
     0.910    28.877     0.200
     0.968    31.367     0.200
     1.040    33.367     0.200
     1.179    37.816     0.200
     1.730    55.227     0.200
     1.794    56.656     0.200
     1.808    57.316     0.200
     1.956    61.096     0.200
     1.995    62.217     0.200
     2.165    67.105     0.200
     2.201    68.297     0.200
     0.098     3.438     0.200
     0.250     7.820     0.200
     0.410    13.188     0.200
     0.454    13.672     0.200
     0.447    14.781     0.200
     0.449    15.688     0.200
     0.547    19.180     0.200
     0.664    21.133     0.200
     1.067    34.039     0.200
     1.103    34.758     0.200
     1.206    37.805     0.200
     1.384    44.039     0.200
     1.461    46.711     0.200
     1.779    56.719     0.200
     1.783    56.719     0.200
     1.788    56.648     0.200
     1.800    57.383     0.200
     1.852    58.562     0.200
     2.056    64.930     0.200
     0.203     6.891     0.200
     0.318    10.570     0.200
     0.318    10.441     0.200
     0.412    12.973     0.200
     0.505    15.512     0.200
     0.589    19.531     0.200
     0.610    19.090     0.200
     0.730    24.062     0.200
     0.739    23.461     0.200
     0.788    25.031     0.200
     0.825    28.082     0.200
     0.911    29.812     0.200
     0.971    30.922     0.200
     0.997    32.402     0.200
     0.098     5.375     0.200
     0.077     6.014     0.200
     0.159     6.074     0.200
     0.351    11.645     0.200
     0.300    10.834     0.200
     0.349    13.165     0.200
     0.428    14.544     0.200
     0.461    15.774     0.200
     0.480    16.834     0.200
     0.490    16.314     0.200
     0.569    18.224     0.200
     0.611    19.125     0.200
     0.747    24.264     0.200
     0.879    27.254     0.200
     1.076    33.875     0.200
     1.604    49.504     0.200
     1.633    50.865     0.200
     1.941    59.615     0.200
     1.961    60.034     0.200
     2.024    62.224     0.200
     2.121    64.435     0.200
     2.226    68.024     0.200
     2.284    69.714     0.200
     0.594    20.135     0.200
     2.098    65.594     0.200
     2.295    67.514     0.200
     2.372    70.004     0.200
     2.430    71.194     0.200
     0.057     7.688     0.200
     0.155     9.023     0.200
     0.221    10.734     0.200
     0.287    11.734     0.200
     0.318    12.664     0.200
     0.339    12.867     0.200
     0.418    15.297     0.200
     0.471    16.352     0.200
     0.545    18.672     0.200
     0.619    20.102     0.200
     0.623    20.820     0.200
     0.638    21.312     0.200
     0.698    23.273     0.200
     0.707    22.852     0.200
     0.783    24.133     0.200
     0.794    24.867     0.200
     1.366    42.508     0.200
     1.402    43.430     0.200
     1.477    45.852     0.200
     1.716    52.320     0.200
     1.774    53.852     0.200
     1.809    55.180     0.200
     2.078    61.453     0.200
     0.241     9.551     0.200
     0.277    11.121     0.200
     0.349    12.191     0.200
     0.345    12.391     0.200
     0.422    13.941     0.200
     0.404    14.414     0.200
     0.482    16.633     0.200
     0.577    18.051     0.200
     0.550    18.543     0.200
     0.853    27.184     0.200
     1.829    55.641     0.200
     0.327    10.541     0.200
     0.333    11.101     0.200
     0.317    10.521     0.200
     0.334    11.401     0.200
     0.363    13.161     0.200
     0.426    14.121     0.200
     0.471    15.961     0.200
     0.506    15.431     0.200
     0.471    16.331     0.200
     0.566    18.141     0.200
     1.648    51.851     0.200
     0.247     7.094     0.200
     0.266     9.305     0.200
     0.308     9.875     0.200
     0.322    11.445     0.200
     0.424    13.785     0.200
     0.460    15.625     0.200
     0.486    15.215     0.200
     0.793    25.895     0.200
     0.871    27.367     0.200
     1.338    42.277     0.200
     0.081     4.367     0.200
     0.106     4.852     0.200
     0.181     7.664     0.200
     0.269     9.906     0.200
     0.294     9.500     0.200
     0.301     9.961     0.200
     0.369    12.383     0.200
     0.432    14.461     0.200
     0.594    19.281     0.200
     0.663    21.367     0.200
     0.137     7.160     0.200
     0.117     7.262     0.200
     0.249     9.561     0.200
     0.357    12.801     0.200
     0.379    12.551     0.200
     0.423    15.150     0.200
     0.465    15.740     0.200
     0.508    17.672     0.200
     0.643    21.641     0.200
     0.659    21.461     0.200
     0.681    22.182     0.200
     0.727    23.641     0.200
     0.864    27.211     0.200
     0.881    28.252     0.200
     1.221    37.521     0.200
     0.106     4.578     0.200
     0.092     4.586     0.200
     0.137     6.516     0.200
     0.317    10.336     0.200
     0.392    12.641     0.200
     0.386    13.250     0.200
     0.459    15.047     0.200
     0.459    15.398     0.200
     0.514    17.797     0.200
     1.217    38.859     0.200
     1.903    59.000     0.200
     1.966    60.969     0.200
     2.229    68.609     0.200
     0.173     6.375     0.200
     0.193     7.031     0.200
     0.186     6.430     0.200
     0.360    11.336     0.200
     0.636    21.484     0.200
     0.662    21.695     0.200
     0.704    22.797     0.200
     0.775    24.914     0.200
     0.782    24.703     0.200
     0.046     5.348     0.200
     0.112     6.730     0.200
     0.111     7.059     0.200
     0.104     7.059     0.200
     0.247     9.098     0.200
     0.244     9.117     0.200
     0.309    10.750     0.200
     0.455    14.777     0.200
     0.474    15.688     0.200
     0.561    17.457     0.200
     0.577    18.270     0.200
     0.905    28.910     0.200
     0.941    29.758     0.200
     1.767    54.168     0.200
     1.843    55.809     0.200
     0.170     5.570     0.200
     0.154     6.031     0.200
     0.184     6.469     0.200
     0.299    10.008     0.200
     0.385    12.289     0.200
     0.396    13.148     0.200
     0.445    14.727     0.200
     0.512    17.188     0.200
     0.535    17.086     0.200
     0.623    20.391     0.200
     0.756    24.531     0.200
     0.849    27.484     0.200
     0.919    29.805     0.200
     0.955    31.211     0.200
     1.030    33.531     0.200
     1.094    35.484     0.200
     0.179     5.773     0.200
     0.141     5.977     0.200
     0.180     6.492     0.200
     0.287     9.312     0.200
     0.303    10.336     0.200
     0.399    13.344     0.200
     0.406    13.406     0.200
     0.526    16.953     0.200
     0.549    17.633     0.200
     0.636    20.461     0.200
     0.739    24.156     0.200
     0.787    25.320     0.200
     0.854    27.594     0.200
     0.952    31.273     0.200
     1.043    33.875     0.200
     1.049    34.125     0.200
     1.107    36.039     0.200
     0.106     5.047     0.200
     0.157     6.781     0.200
     0.233     8.508     0.200
     0.276    10.133     0.200
     0.333    11.531     0.200
     0.331    11.906     0.200
     0.379    13.203     0.200
     0.522    17.516     0.200
     0.579    19.812     0.200
     0.610    20.445     0.200
     0.152     5.678     0.200
     0.224     7.107     0.200
     0.238     7.479     0.200
     0.328    10.229     0.200
     0.411    13.438     0.200
     0.460    15.318     0.200
     0.485    15.449     0.200
     0.651    21.279     0.200
     0.664    21.729     0.200
     0.688    21.898     0.200
     0.699    22.938     0.200
     0.737    24.559     0.200
     0.759    24.238     0.200
     0.791    25.938     0.200
     0.836    26.648     0.200
     0.845    27.139     0.200
     0.849    27.318     0.200
     0.836    27.379     0.200
     0.916    29.578     0.200
     0.930    30.238     0.200
     0.950    29.678     0.200
     1.085    35.178     0.200
     1.098    35.789     0.200
     1.116    36.299     0.200
     1.128    36.719     0.200
     1.122    36.678     0.200
     1.209    38.818     0.200
     1.254    39.588     0.200
     1.237    40.107     0.200
     0.084     4.680     0.200
     0.101     5.820     0.200
     0.173     7.531     0.200
     0.407    14.367     0.200
     0.445    14.695     0.200
     0.457    15.406     0.200
     0.509    16.586     0.200
     0.528    16.781     0.200
     0.527    18.070     0.200
     1.009    32.172     0.200
     1.079    34.625     0.200
     1.729    54.102     0.200
     1.878    57.922     0.200
     2.031    62.789     0.200
     2.129    65.438     0.200
     2.135    65.711     0.200
     0.147     6.191     0.200
     0.156     6.043     0.200
     0.183     7.082     0.200
     0.204     7.773     0.200
     0.309    10.793     0.200
     0.369    12.883     0.200
     0.378    13.391     0.200
     0.415    13.711     0.200
     0.553    18.461     0.200
     0.615    20.230     0.200
     0.626    20.762     0.200
     0.074     3.594     0.200
     0.138     5.594     0.200
     0.150     5.516     0.200
     0.171     5.695     0.200
     0.308    10.422     0.200
     0.326    10.867     0.200
     0.367    12.242     0.200
     0.374    12.453     0.200
     0.450    14.898     0.200
     0.457    15.094     0.200
     0.546    18.172     0.200
     0.570    18.812     0.200
     0.896    29.125     0.200
     0.085     3.602     0.200
     0.142     5.410     0.200
     0.154     5.402     0.200
     0.157     5.902     0.200
     0.327    10.672     0.200
     0.341    11.531     0.200
     0.349    11.582     0.200
     0.389    12.320     0.200
     0.390    13.043     0.200
     0.410    13.453     0.200
     0.461    15.113     0.200
     0.486    16.211     0.200
     0.530    17.203     0.200
     0.582    19.160     0.200
     0.606    19.711     0.200
     0.645    21.121     0.200
     0.113     4.410     0.200
     0.161     6.211     0.200
     0.242     8.039     0.200
     0.267     8.631     0.200
     0.370    12.471     0.200
     0.393    13.020     0.200
     0.443    14.359     0.200
     0.437    14.400     0.200
     0.560    18.580     0.200
     0.646    20.820     0.200
     0.636    21.109     0.200
     0.657    21.359     0.200
     0.710    23.539     0.200
     0.733    23.840     0.200
     0.745    24.061     0.200
     0.726    24.160     0.200
     0.787    25.369     0.200
     0.791    25.359     0.200
     0.806    25.600     0.200
     0.801    26.570     0.200
     0.853    28.230     0.200
     0.910    29.480     0.200
     1.052    34.410     0.200
     1.118    36.270     0.200
     1.122    36.500     0.200
     1.184    37.221     0.200
     0.187     6.705     0.200
     0.251     9.055     0.200
     0.268     9.285     0.200
     0.303     9.965     0.200
     0.329    10.885     0.200
     0.451    14.584     0.200
     0.538    17.645     0.200
     0.576    19.193     0.200
     0.636    20.434     0.200
     0.779    25.145     0.200
     0.826    26.555     0.200
     0.828    26.604     0.200
     0.837    26.773     0.200
     0.845    27.625     0.200
     0.910    29.484     0.200
     1.050    34.055     0.200
     0.163     6.219     0.200
     0.243     8.758     0.200
     0.263     9.219     0.200
     0.328    11.094     0.200
     0.333    11.430     0.200
     0.359    12.000     0.200
     0.388    13.109     0.200
     0.402    13.508     0.200
     0.445    14.961     0.200
     0.494    15.180     0.200
     0.553    18.430     0.200
     0.577    18.984     0.200
     0.596    19.398     0.200
     0.704    23.133     0.200
     0.778    25.594     0.200
     0.864    28.344     0.200
     1.007    33.055     0.200
     1.794    55.844     0.200
     0.093     5.044     0.200
     0.088     4.854     0.200
     0.175     7.113     0.200
     0.256     9.443     0.200
     0.288     9.794     0.200
     0.358    12.284     0.200
     0.425    14.164     0.200
     0.491    16.313     0.200
     0.565    18.344     0.200
     0.579    19.434     0.200
     0.585    19.574     0.200
     0.626    20.594     0.200
     0.654    21.724     0.200
     0.755    23.634     0.200
     0.737    23.754     0.200
     0.758    24.324     0.200
     0.913    28.943     0.200
     0.923    29.794     0.200
     1.079    34.894     0.200
     1.776    56.014     0.200
     1.855    57.644     0.200
     0.201     7.770     0.200
     0.311    11.020     0.200
     0.315    11.242     0.200
     0.320    11.262     0.200
     0.345    12.020     0.200
     0.384    13.133     0.200
     0.415    13.152     0.200
     0.399    13.633     0.200
     0.436    14.590     0.200
     0.475    16.152     0.200
     0.505    16.723     0.200
     0.551    17.840     0.200
     0.586    19.371     0.200
     0.668    21.949     0.200
     0.764    25.070     0.200
     0.783    25.832     0.200
     1.711    52.531     0.200
     0.105     5.590     0.200
     0.147     6.461     0.200
     0.173     7.000     0.200
     0.216     8.570     0.200
     0.230     8.461     0.200
     0.332    11.719     0.200
     0.378    12.871     0.200
     0.416    14.160     0.200
     0.453    15.160     0.200
     0.460    15.309     0.200
     0.453    15.539     0.200
     0.554    18.500     0.200
     0.584    19.711     0.200
     0.597    20.129     0.200
     0.657    21.941     0.200
     0.701    23.012     0.200
     0.712    23.840     0.200
     0.786    25.699     0.200
     0.807    26.430     0.200
     1.012    32.879     0.200
     1.748    54.602     0.200
     1.824    56.641     0.200
     2.042    63.320     0.200
     2.157    66.371     0.200
     0.112     4.574     0.200
     0.216     7.344     0.200
     0.247     8.344     0.200
     0.289     9.711     0.200
     0.313    10.652     0.200
     0.324    11.012     0.200
     0.343    11.543     0.200
     0.422    13.133     0.200
     0.422    14.023     0.200
     0.428    14.312     0.200
     0.641    21.012     0.200
     0.677    22.242     0.200
     0.060     2.865     0.200
     0.228     7.715     0.200
     0.255     9.365     0.200
     0.346    10.775     0.200
     0.357    11.436     0.200
     0.385    12.615     0.200
     0.392    13.326     0.200
     0.370    11.096     0.200
     0.430    13.326     0.200
     0.581    18.076     0.200
     0.539    18.826     0.200
     0.586    19.965     0.200
     0.609    20.596     0.200
     0.792    25.186     0.200
     0.794    24.996     0.200
     0.849    27.096     0.200
     0.926    29.875     0.200
     0.949    30.346     0.200
     0.941    30.637     0.200
     0.974    31.025     0.200
     0.980    31.096     0.200
     1.098    35.266     0.200
     1.190    38.025     0.200
     1.264    40.336     0.200
     1.655    52.756     0.200
     1.674    53.166     0.200
     1.667    52.865     0.200
     1.727    54.336     0.200
     1.767    55.455     0.200
     1.789    56.506     0.200
     1.831    57.516     0.200
     1.925    60.326     0.200
     1.933    60.545     0.200
     1.989    62.275     0.200
     1.992    62.275     0.200
     2.058    65.346     0.200
     1.999    62.686     0.200
     2.062    63.307     0.200
     2.089    65.346     0.200
     2.782    83.066     0.200
     3.134    91.887     0.200
     0.061     3.613     0.200
     0.112     4.914     0.200
     0.207     7.684     0.200
     0.279     9.945     0.200
     0.273     9.523     0.200
     0.328    10.844     0.200
     0.379    12.785     0.200
     0.456    15.285     0.200
     0.484    15.426     0.200
     0.559    18.285     0.200
     0.612    20.105     0.200
     0.644    20.824     0.200
     0.648    21.285     0.200
     0.683    22.176     0.200
     0.732    22.926     0.200
     0.733    23.387     0.200
     0.738    23.695     0.200
     0.769    25.336     0.200
     0.804    26.125     0.200
     0.873    28.285     0.200
     0.900    29.195     0.200
     0.924    29.766     0.200
     1.072    35.043     0.200
     1.102    35.727     0.200
     1.724    54.043     0.200
     1.828    57.406     0.200
     2.134    66.305     0.200
     0.177     6.371     0.200
     0.233     8.301     0.200
     0.354    11.648     0.200
     0.363    11.570     0.200
     0.355    12.371     0.200
     0.398    13.410     0.200
     0.444    13.598     0.200
     0.470    15.699     0.200
     0.598    18.559     0.200
     0.572    19.051     0.200
     0.941    30.090     0.200
     0.962    30.578     0.200
     1.282    40.910     0.200
     1.690    53.898     0.200
     1.848    58.500     0.200
     0.140     5.641     0.200
     0.142     6.109     0.200
     0.169     6.570     0.200
     0.202     6.938     0.200
     0.328    10.609     0.200
     0.353    11.070     0.200
     0.367    11.734     0.200
     0.372    12.141     0.200
     0.381    12.211     0.200
     0.398    13.180     0.200
     0.432    14.219     0.200
     0.447    14.492     0.200
     0.451    15.305     0.200
     0.504    16.039     0.200
     0.503    16.719     0.200
     0.520    17.594     0.200
     0.534    17.500     0.200
     0.636    20.414     0.200
     0.643    20.953     0.200
     0.699    21.648     0.200
     0.681    22.367     0.200
     0.693    22.648     0.200
     0.763    25.094     0.200
     0.925    29.602     0.200
     1.658    53.203     0.200
     1.861    58.703     0.200
     0.150     5.781     0.200
     0.144     6.000     0.200
     0.176     5.742     0.200
     0.259     8.930     0.200
     0.275     9.727     0.200
     0.379    12.555     0.200
     0.374    12.320     0.200
     0.446    14.570     0.200
     0.455    14.883     0.200
     0.500    16.656     0.200
     0.611    18.211     0.200
     0.616    20.031     0.200
     0.631    19.961     0.200
     0.628    20.047     0.200
     0.637    21.047     0.200
     0.683    22.156     0.200
     0.702    23.273     0.200
     0.818    26.086     0.200
     0.861    27.711     0.200
     0.935    30.570     0.200
     0.963    31.172     0.200
     0.981    31.234     0.200
     1.914    61.062     0.200
     2.013    63.609     0.200
     2.124    66.906     0.200
     0.226     8.047     0.200
     0.229     8.508     0.200
     0.254     8.938     0.200
     0.367    12.875     0.200
     0.432    14.336     0.200
     0.507    16.336     0.200
     0.509    17.172     0.200
     0.611    19.953     0.200
     0.677    21.312     0.200
     0.682    22.312     0.200
     0.683    22.938     0.200
     0.845    27.961     0.200
     1.019    32.516     0.200
     1.047    34.086     0.200
     0.124     7.508     0.200
     0.134     7.898     0.200
     0.155     8.656     0.200
     0.269    11.344     0.200
     0.318    11.789     0.200
     0.496    16.727     0.200
     0.544    18.055     0.200
     0.532    18.445     0.200
     0.556    19.266     0.200
     0.618    20.164     0.200
     0.672    22.250     0.200
     0.764    25.320     0.200
     0.808    26.109     0.200
     0.875    28.039     0.200
     0.157     5.098     0.200
     0.273     9.020     0.200
     0.284     9.398     0.200
     0.322    10.059     0.200
     0.344    10.930     0.200
     0.360    12.070     0.200
     0.420    13.250     0.200
     0.443    15.328     0.200
     0.464    15.289     0.200
     0.507    16.797     0.200
     0.543    17.840     0.200
     0.588    19.449     0.200
     0.637    21.379     0.200
     0.722    23.988     0.200
     0.795    26.219     0.200
     0.795    26.309     0.200
     0.790    25.570     0.200
     1.801    57.707     0.200
     0.095     3.339     0.200
     0.101     3.919     0.200
     0.319    10.779     0.200
     0.464    15.209     0.200
     0.467    14.659     0.200
     0.655    20.419     0.200
     1.026    32.759     0.200
     1.106    35.489     0.200
     1.212    37.789     0.200
     1.306    41.209     0.200
     1.840    56.180     0.200
     1.885    59.289     0.200
     1.897    59.549     0.200
     1.908    59.909     0.200
     2.023    62.509     0.200
     2.061    64.720     0.200
     2.159    66.509     0.200
     2.165    66.789     0.200
     2.224    68.430     0.200
     1.973    61.999     0.200
     2.149    65.560     0.200
     2.161    66.689     0.200
     0.056     3.641     0.200
     0.180     6.273     0.200
     0.198     7.484     0.200
     0.310    10.547     0.200
     0.413    13.367     0.200
     0.412    13.125     0.200
     0.486    15.414     0.200
     0.554    17.906     0.200
     0.578    18.461     0.200
     0.626    20.844     0.200
     1.000    32.992     0.200
     1.064    34.383     0.200
     2.000    62.297     0.200
     0.162     5.062     0.200
     0.195     6.391     0.200
     0.199     6.695     0.200
     0.303     9.398     0.200
     0.318    10.320     0.200
     0.313    10.148     0.200
     0.345    10.719     0.200
     0.974    31.820     0.200
     0.059     1.871     0.200
     0.205     7.043     0.200
     0.268     9.281     0.200
     0.271     8.953     0.200
     0.271     9.492     0.200
     0.281     9.293     0.200
     0.325    10.980     0.200
     0.369    12.012     0.200
     0.381    12.980     0.200
     0.467    14.043     0.200
     0.453    14.691     0.200
     0.546    17.641     0.200
     0.592    19.012     0.200
     0.624    20.613     0.200
     0.626    20.453     0.200
     0.625    20.152     0.200
     0.080     5.133     0.200
     0.116     5.953     0.200
     0.191     7.617     0.200
     0.189     7.789     0.200
     0.241     9.602     0.200
     0.302    10.984     0.200
     0.350    11.812     0.200
     0.492    16.172     0.200
     0.499    16.328     0.200
     0.563    18.508     0.200
     0.679    21.797     0.200
     0.739    23.984     0.200
     0.762    24.703     0.200
     0.752    24.664     0.200
     0.861    28.062     0.200
     0.887    29.008     0.200
     0.969    30.633     0.200
     0.937    29.922     0.200
     1.047    33.320     0.200
     1.077    34.039     0.200
     0.177     6.914     0.200
     0.159     6.461     0.200
     0.203     8.148     0.200
     0.243     8.492     0.200
     0.362    11.266     0.200
     0.341    11.250     0.200
     0.406    12.930     0.200
     0.444    15.125     0.200
     0.464    15.250     0.200
     0.635    21.203     0.200
     0.653    20.664     0.200
     0.689    21.984     0.200
     0.710    23.453     0.200
     0.754    24.109     0.200
     0.758    24.102     0.200
     0.774    26.289     0.200
     0.785    26.320     0.200
     0.818    26.695     0.200
     0.869    28.281     0.200
     0.929    30.289     0.200
     0.988    31.922     0.200
     1.116    35.578     0.200
     1.169    35.922     0.200
     2.436    73.141     0.200
     2.472    74.703     0.200
     2.534    75.852     0.200
     2.878    84.234     0.200
     0.128     4.398     0.200
     0.208     6.516     0.200
     0.327    10.367     0.200
     0.385    12.117     0.200
     0.469    15.672     0.200
     0.503    15.656     0.200
     0.475    16.008     0.200
     0.603    19.617     0.200
     0.655    20.430     0.200
     0.770    25.156     0.200
     1.112    34.930     0.200
     1.140    36.016     0.200
     1.177    37.750     0.200
     1.652    52.242     0.200
     1.682    53.062     0.200
     1.808    56.680     0.200
     1.863    57.797     0.200
     1.933    59.500     0.200
     1.984    61.359     0.200
     2.005    62.289     0.200
     2.011    61.961     0.200
     2.025    62.695     0.200
     2.077    64.562     0.200
     2.167    66.977     0.200
     2.274    69.977     0.200
     2.272    70.070     0.200
     2.331    71.398     0.200
     0.110     5.680     0.200
     0.189     7.664     0.200
     0.235     8.617     0.200
     0.357    12.547     0.200
     0.391    13.578     0.200
     0.419    14.648     0.200
     0.465    15.227     0.200
     0.579    19.859     0.200
     0.638    21.367     0.200
     0.660    21.227     0.200
     0.661    21.914     0.200
     0.751    24.891     0.200
     0.762    25.117     0.200
     0.947    30.102     0.200
     1.967    61.008     0.200
     0.122     5.430     0.200
     0.118     4.969     0.200
     0.195     7.398     0.200
     0.394    13.367     0.200
     0.398    13.125     0.200
     0.409    13.461     0.200
     0.424    14.070     0.200
     0.451    15.484     0.200
     0.585    19.398     0.200
     0.586    19.250     0.200
     0.638    21.219     0.200
     0.708    23.320     0.200
     0.106     4.641     0.200
     0.112     5.039     0.200
     0.117     4.422     0.200
     0.157     5.672     0.200
     0.271     8.594     0.200
     0.359    11.859     0.200
     0.363    12.328     0.200
     0.399    12.711     0.200
     0.421    13.578     0.200
     0.477    15.039     0.200
     0.591    18.312     0.200
     0.644    20.938     0.200
     0.688    21.984     0.200
     0.703    23.219     0.200
     0.731    23.555     0.200
     0.746    23.828     0.200
     0.796    25.508     0.200
     0.811    25.664     0.200
     1.391    44.102     0.200
     0.161     6.810     0.200
     0.290    10.120     0.200
     0.305    11.010     0.200
     0.302    10.390     0.200
     0.310    10.650     0.200
     0.362    12.360     0.200
     0.436    13.320     0.200
     0.433    14.680     0.200
     0.449    14.690     0.200
     0.464    15.330     0.200
     0.556    18.020     0.200
     0.606    19.110     0.200
     0.628    20.730     0.200
     0.698    22.750     0.200
     0.723    23.180     0.200
     0.796    26.000     0.200
     0.836    26.140     0.200
     0.841    26.790     0.200
     1.739    55.480     0.200
     0.051     1.574     0.200
     0.282     8.906     0.200
     0.294    10.926     0.200
     0.389    12.223     0.200
     0.409    12.676     0.200
     0.506    17.484     0.200
     0.537    18.184     0.200
     0.606    19.633     0.200
     0.683    21.555     0.200
     0.723    23.016     0.200
     0.862    26.785     0.200
     0.877    28.434     0.200
     0.929    29.266     0.200
     0.950    30.414     0.200
     1.030    33.555     0.200
     1.015    33.016     0.200
     1.044    33.234     0.200
     1.141    36.355     0.200
     1.259    40.812     0.200
     1.375    43.645     0.200
     1.405    44.965     0.200
     1.733    55.723     0.200
     1.749    55.926     0.200
     1.816    57.934     0.200
     1.995    63.125     0.200
     1.998    62.504     0.200
     2.056    64.715     0.200
     0.780    23.703     0.200
     1.120    36.473     0.200
     1.984    62.074     0.200
     2.067    63.266     0.200
     2.312    70.105     0.200
     2.372    73.062     0.200
     2.527    76.055     0.200
     0.108     5.410     0.200
     0.226     8.148     0.200
     0.357    12.289     0.200
     0.392    13.512     0.200
     0.459    15.070     0.200
     0.545    18.211     0.200
     0.603    19.910     0.200
     0.629    21.051     0.200
     0.650    21.398     0.200
     0.719    23.609     0.200
     0.919    30.141     0.200
     0.982    32.090     0.200
     1.001    32.609     0.200
     0.658    23.441     0.200
     2.013    62.074     0.200
     2.111    65.883     0.200
     2.340    70.234     0.200
     2.392    71.441     0.200
     2.397    71.531     0.200
     2.555    76.203     0.200
     0.147     5.812     0.200
     0.136     5.445     0.200
     0.229     8.203     0.200
     0.356    11.898     0.200
     0.377    13.133     0.200
     0.432    14.141     0.200
     0.541    18.141     0.200
     0.602    20.266     0.200
     0.620    20.633     0.200
     0.625    20.648     0.200
     0.693    22.445     0.200
     0.730    23.734     0.200
     0.210     6.961     0.200
     0.302    10.023     0.200
     0.313    10.453     0.200
     0.336    11.504     0.200
     0.360    11.531     0.200
     0.399    12.031     0.200
     0.381    12.281     0.200
     0.422    13.273     0.200
     0.461    15.391     0.200
     0.484    16.184     0.200
     0.510    16.184     0.200
     0.516    16.613     0.200
     0.532    17.402     0.200
     0.571    18.441     0.200
     0.591    19.531     0.200
     0.681    22.262     0.200
     0.681    22.273     0.200
     0.747    24.301     0.200
     0.768    24.801     0.200
     0.775    25.211     0.200
     0.840    27.281     0.200
     0.854    27.332     0.200
     0.848    27.223     0.200
     0.950    31.031     0.200
     1.026    32.781     0.200
     1.074    34.391     0.200
     1.094    35.820     0.200
     1.696    54.742     0.200
     1.801    57.621     0.200
     0.168     5.953     0.200
     0.294     9.352     0.200
     0.451    14.844     0.200
     0.512    16.625     0.200
     0.515    16.727     0.200
     0.538    17.000     0.200
     0.663    20.977     0.200
     0.730    22.984     0.200
     0.732    23.562     0.200
     0.787    25.938     0.200
     0.808    25.852     0.200
     0.801    25.781     0.200
     0.816    26.117     0.200
     0.807    25.891     0.200
     0.116     4.570     0.200
     0.204     7.172     0.200
     0.267     9.016     0.200
     0.311     9.977     0.200
     0.328    10.031     0.200
     0.342    11.070     0.200
     0.532    16.891     0.200
     0.584    19.164     0.200
     0.714    22.641     0.200
     0.708    23.164     0.200
     0.735    23.281     0.200
     0.767    24.344     0.200
     0.855    27.125     0.200
     0.915    29.117     0.200
     0.918    29.555     0.200
     0.942    30.055     0.200
     1.050    33.773     0.200
     1.066    34.141     0.200
     1.168    37.602     0.200
     1.289    41.516     0.200
     1.421    44.484     0.200
     1.734    55.125     0.200
     0.145     6.184     0.200
     0.189     6.694     0.200
     0.288     9.534     0.200
     0.292     9.704     0.200
     0.317    10.314     0.200
     0.310    10.284     0.200
     0.396    13.124     0.200
     0.440    13.344     0.200
     0.458    13.844     0.200
     0.463    15.154     0.200
     0.510    16.574     0.200
     0.575    18.634     0.200
     0.568    18.754     0.200
     0.645    20.914     0.200
     0.667    20.524     0.200
     0.674    21.074     0.200
     0.730    24.264     0.200
     0.727    23.884     0.200
     0.781    24.064     0.200
     0.799    25.414     0.200
     0.809    26.154     0.200
     0.836    26.044     0.200
     0.882    27.764     0.200
     1.021    32.134     0.200
     1.020    32.384     0.200
     1.190    37.484     0.200
     1.213    38.974     0.200
     1.528    47.504     0.200
     1.656    52.244     0.200
     1.716    53.754     0.200
     1.875    58.864     0.200
     0.136     6.324     0.200
     0.168     7.293     0.200
     0.149     6.164     0.200
     0.261     9.965     0.200
     0.358    12.715     0.200
     0.373    13.402     0.200
     0.446    15.402     0.200
     0.449    14.734     0.200
     0.440    15.082     0.200
     0.484    15.645     0.200
     0.564    18.734     0.200
     0.617    19.312     0.200
     0.612    19.684     0.200
     0.621    20.555     0.200
     0.684    21.512     0.200
     0.681    22.395     0.200
     0.777    24.352     0.200
     0.784    25.062     0.200
     0.805    26.324     0.200
     0.849    26.441     0.200
     0.891    28.035     0.200
     0.921    30.234     0.200
     0.959    31.203     0.200
     0.989    31.535     0.200
     1.010    31.441     0.200
     1.136    35.902     0.200
     1.582    49.645     0.200
     1.609    50.094     0.200
     1.638    51.793     0.200
     1.787    55.254     0.200
     1.798    56.383     0.200
     1.922    58.324     0.200
     1.995    61.504     0.200
     2.019    62.723     0.200
     2.131    65.012     0.200
     0.481    14.895     0.200
     0.699    22.664     0.200
     0.113     5.014     0.200
     0.140     5.823     0.200
     0.172     6.854     0.200
     0.218     8.033     0.200
     0.240     8.153     0.200
     0.305    10.474     0.200
     0.333    10.273     0.200
     0.373    12.073     0.200
     0.438    13.533     0.200
     0.476    14.663     0.200
     0.474    15.333     0.200
     0.473    15.033     0.200
     0.487    16.213     0.200
     0.579    18.573     0.200
     0.609    19.394     0.200
     0.659    20.854     0.200
     0.690    22.033     0.200
     0.721    22.783     0.200
     0.727    23.264     0.200
     0.744    24.343     0.200
     0.744    24.023     0.200
     0.776    24.793     0.200
     0.816    27.503     0.200
     0.840    27.713     0.200
     0.906    29.123     0.200
     0.960    30.883     0.200
     0.973    31.923     0.200
     1.026    32.533     0.200
     1.143    35.854     0.200
     1.151    37.023     0.200
     1.333    41.903     0.200
     0.109     5.723     0.200
     0.177     6.902     0.200
     0.207     7.684     0.200
     0.305    10.453     0.200
     0.315    10.461     0.200
     0.316    10.453     0.200
     0.364    12.031     0.200
     0.434    15.043     0.200
     0.439    14.023     0.200
     0.434    14.844     0.200
     0.515    16.652     0.200
     0.561    18.691     0.200
     0.584    18.645     0.200
     0.584    18.555     0.200
     0.586    19.062     0.200
     0.670    21.363     0.200
     0.711    22.992     0.200
     0.736    22.922     0.200
     0.719    22.824     0.200
     0.763    24.461     0.200
     0.769    23.781     0.200
     0.813    26.273     0.200
     0.847    28.402     0.200
     0.942    30.395     0.200
     1.074    34.414     0.200
     1.077    34.941     0.200
     1.074    34.363     0.200
     0.134     5.125     0.200
     0.132     5.109     0.200
     0.183     6.211     0.200
     0.255     8.750     0.200
     0.340    11.680     0.200
     0.328    10.992     0.200
     0.415    13.344     0.200
     0.420    13.656     0.200
     0.454    15.000     0.200
     0.465    14.875     0.200
     0.585    19.672     0.200
     0.588    19.023     0.200
     0.661    20.430     0.200
     0.658    21.219     0.200
     0.746    23.883     0.200
     0.866    27.555     0.200
     0.884    29.266     0.200
     0.903    29.156     0.200
     0.927    29.859     0.200
     0.982    31.609     0.200
     0.986    31.711     0.200
     1.121    35.719     0.200
     1.162    36.445     0.200
     1.196    38.750     0.200
     1.770    56.539     0.200
     1.789    56.945     0.200
     1.913    61.391     0.200
     2.005    63.086     0.200
     2.122    66.664     0.200
     0.148     6.450     0.200
     0.207     7.210     0.200
     0.270     9.380     0.200
     0.296    10.420     0.200
     0.317    10.360     0.200
     0.329    10.820     0.200
     0.408    12.670     0.200
     0.431    13.480     0.200
     0.451    15.040     0.200
     0.571    18.720     0.200
     0.582    19.180     0.200
     0.602    19.780     0.200
     0.670    21.600     0.200
     0.723    23.260     0.200
     0.730    23.640     0.200
     0.807    26.290     0.200
     0.799    26.030     0.200
     0.851    27.390     0.200
     0.925    29.050     0.200
     1.086    34.210     0.200
     1.104    35.810     0.200
     1.168    37.200     0.200
     0.155     6.863     0.200
     0.249     9.324     0.200
     0.263     9.355     0.200
     0.318    11.785     0.200
     0.350    13.043     0.200
     0.393    13.684     0.200
     0.440    14.746     0.200
     0.490    15.586     0.200
     0.502    16.254     0.200
     0.578    18.496     0.200
     0.593    18.875     0.200
     0.659    21.246     0.200
     0.685    21.863     0.200
     0.700    23.055     0.200
     0.699    22.895     0.200
     0.773    25.523     0.200
     0.778    25.656     0.200
     0.787    24.375     0.200
     0.850    26.895     0.200
     0.860    27.824     0.200
     0.883    28.355     0.200
     0.915    29.023     0.200
     1.028    32.383     0.200
     1.668    50.566     0.200
     1.893    59.875     0.200
     0.040     2.438     0.200
     0.165     5.781     0.200
     0.175     6.539     0.200
     0.248     8.758     0.200
     0.311    10.812     0.200
     0.347    10.930     0.200
     0.376    12.438     0.200
     0.499    15.688     0.200
     0.471    15.352     0.200
     0.484    15.859     0.200
     0.505    16.258     0.200
     0.595    19.461     0.200
     0.710    22.242     0.200
     0.732    22.258     0.200
     0.724    23.594     0.200
     0.795    24.859     0.200
     0.942    29.938     0.200
     0.995    31.633     0.200
     1.031    32.500     0.200
     1.065    32.539     0.200
     1.124    36.570     0.200
     1.135    35.742     0.200
     1.252    39.555     0.200
     1.274    39.680     0.200
     1.778    55.422     0.200
     1.985    62.758     0.200
     2.075    63.883     0.200
     2.086    64.672     0.200
     2.146    66.461     0.200
     0.660    22.031     0.200
     2.065    62.820     0.200
     2.150    64.398     0.200
     2.245    67.258     0.200
     0.139     5.764     0.200
     0.128     5.684     0.200
     0.265     9.123     0.200
     0.306    10.453     0.200
     0.371    11.814     0.200
     0.371    12.453     0.200
     0.370    12.404     0.200
     0.528    17.225     0.200
     0.664    21.264     0.200
     0.679    21.844     0.200
     0.679    21.273     0.200
     0.841    26.943     0.200
     0.942    30.814     0.200
     1.008    33.225     0.200
     1.010    32.373     0.200
     1.042    33.225     0.200
     0.092     3.773     0.200
     0.317     9.492     0.200
     0.295    10.082     0.200
     0.491    16.094     0.200
     0.526    16.844     0.200
     0.504    16.934     0.200
     0.528    17.434     0.200
     0.634    21.613     0.200
     0.688    23.273     0.200
     0.719    25.062     0.200
     0.724    24.434     0.200
     0.919    29.324     0.200
     1.031    32.742     0.200
     1.063    33.781     0.200
     1.198    38.453     0.200
     1.335    42.254     0.200
     1.711    54.734     0.200
     0.184     9.062     0.200
     0.235     9.594     0.200
     0.261    10.453     0.200
     0.384    14.574     0.200
     0.413    14.574     0.200
     0.488    16.625     0.200
     0.484    16.785     0.200
     0.555    17.863     0.200
     0.524    18.145     0.200
     0.580    18.973     0.200
     0.570    19.844     0.200
     0.727    23.125     0.200
     0.742    24.164     0.200
     0.740    24.684     0.200
     0.814    26.402     0.200
     0.936    29.445     0.200
     1.504    47.492     0.200
     1.543    47.543     0.200
     1.721    53.543     0.200
     1.733    53.465     0.200
     1.940    59.812     0.200
     1.954    59.895     0.200
     0.212     7.133     0.200
     0.385    12.562     0.200
     0.395    13.094     0.200
     0.411    14.254     0.200
     0.460    14.434     0.200
     0.480    16.203     0.200
     0.525    16.453     0.200
     0.548    17.734     0.200
     0.548    18.492     0.200
     0.551    18.074     0.200
     0.650    21.102     0.200
     0.697    22.281     0.200
     0.738    23.352     0.200
     0.812    26.523     0.200
     0.880    28.461     0.200
     0.915    28.891     0.200
     0.892    29.512     0.200
     0.946    30.664     0.200
     1.693    54.582     0.200
     1.702    54.363     0.200
     1.814    58.273     0.200
     1.910    60.281     0.200
     1.925    61.711     0.200
     0.173     7.023     0.200
     0.195     8.039     0.200
     0.234     8.906     0.200
     0.268    10.422     0.200
     0.349    12.039     0.200
     0.427    15.125     0.200
     0.481    16.562     0.200
     0.500    16.633     0.200
     0.524    17.523     0.200
     0.689    22.812     0.200
     0.719    23.750     0.200
     0.735    24.891     0.200
     0.757    24.633     0.200
     0.839    27.656     0.200
     0.987    31.461     0.200
     1.025    32.859     0.200
     0.211     8.562     0.200
     1.100    34.344     0.200
     2.163    66.023     0.200
     0.121     4.897     0.200
     0.145     5.937     0.200
     0.240     7.437     0.200
     0.344    11.097     0.200
     0.367    13.417     0.200
     0.430    13.337     0.200
     0.409    14.487     0.200
     0.489    15.887     0.200
     0.541    18.087     0.200
     0.578    19.087     0.200
     0.752    23.967     0.200
     0.831    26.077     0.200
     1.038    33.117     0.200
     1.042    34.157     0.200
     1.177    37.507     0.200
     1.224    38.917     0.200
     1.328    42.047     0.200
     1.861    58.187     0.200
     1.908    60.057     0.200
     1.921    59.847     0.200
     2.005    62.677     0.200
     2.183    67.817     0.200
     2.233    69.097     0.200
     2.242    69.627     0.200
     0.085     3.547     0.200
     0.218     7.906     0.200
     0.254     9.008     0.200
     0.274     9.125     0.200
     0.337    10.926     0.200
     0.350    11.348     0.200
     0.366    12.047     0.200
     0.517    15.855     0.200
     0.514    16.355     0.200
     0.542    18.156     0.200
     0.615    19.426     0.200
     0.626    20.688     0.200
     0.667    21.688     0.200
     0.681    22.465     0.200
     0.785    24.707     0.200
     0.855    28.215     0.200
     0.887    29.137     0.200
     1.206    39.195     0.200
     1.701    55.438     0.200
     1.916    60.957     0.200
     0.099     5.285     0.200
     0.101     5.395     0.200
     0.166     6.723     0.200
     0.266     8.973     0.200
     0.271     9.633     0.200
     0.297    10.254     0.200
     0.341    11.414     0.200
     0.428    14.406     0.200
     0.521    16.766     0.200
     0.545    17.793     0.200
     0.722    23.633     0.200
     0.764    25.113     0.200
     0.766    25.336     0.200
     0.796    26.086     0.200
     0.831    27.184     0.200
     0.936    29.906     0.200
     1.023    33.395     0.200
     0.263     9.113     0.200
     1.309    39.586     0.200
     0.060     4.346     0.200
     0.123     5.726     0.200
     0.203     8.625     0.200
     0.304    10.186     0.200
     0.304    10.355     0.200
     0.388    13.565     0.200
     0.453    15.076     0.200
     0.510    16.766     0.200
     0.584    18.456     0.200
     0.591    19.136     0.200
     0.615    20.366     0.200
     0.657    21.646     0.200
     0.684    22.755     0.200
     0.790    25.286     0.200
     0.917    28.846     0.200
     0.926    29.875     0.200
     1.041    33.576     0.200
     1.117    35.976     0.200
     1.127    36.156     0.200
     1.749    54.545     0.200
     2.160    66.815     0.200
     0.185     6.108     0.200
     0.266     8.608     0.200
     0.280     9.108     0.200
     0.267     8.478     0.200
     0.348    11.458     0.200
     0.461    14.468     0.200
     0.441    14.768     0.200
     0.527    16.948     0.200
     0.535    17.718     0.200
     0.743    23.108     0.200
     0.763    24.288     0.200
     0.870    27.048     0.200
     0.911    29.028     0.200
     0.998    32.218     0.200
     0.067     5.002     0.200
     0.107     5.332     0.200
     0.209     8.502     0.200
     0.339    11.642     0.200
     0.373    12.812     0.200
     0.456    15.002     0.200
     0.472    15.342     0.200
     0.547    17.882     0.200
     0.552    18.482     0.200
     0.609    20.282     0.200
     0.643    21.722     0.200
     0.680    22.572     0.200
     0.726    23.772     0.200
     0.761    25.382     0.200
     0.864    27.592     0.200
     0.857    28.302     0.200
     0.878    28.712     0.200
     0.888    28.572     0.200
     0.914    28.922     0.200
     1.115    35.422     0.200
     1.743    54.382     0.200
     1.817    56.292     0.200
     1.898    59.242     0.200
     2.021    63.122     0.200
     2.101    65.432     0.200
     2.122    66.442     0.200
     0.558    18.692     0.200
     1.882    59.522     0.200
     2.954    87.892     0.200
     0.092     4.004     0.200
     0.178     6.375     0.200
     0.242     8.312     0.200
     0.265     9.023     0.200
     0.361    12.035     0.200
     0.404    13.934     0.200
     0.551    18.234     0.200
     0.608    19.875     0.200
     0.638    21.492     0.200
     0.930    30.883     0.200
     1.705    54.473     0.200
     0.097     5.625     0.200
     0.203     7.906     0.200
     0.224     8.281     0.200
     0.329    11.125     0.200
     0.340    11.398     0.200
     0.332    11.570     0.200
     0.465    14.578     0.200
     0.451    15.180     0.200
     0.793    25.906     0.200
     0.061     3.719     0.200
     0.110     4.539     0.200
     0.131     5.059     0.200
     0.224     7.209     0.200
     0.231     7.418     0.200
     0.284     9.930     0.200
     0.279    10.168     0.200
     0.366    11.879     0.200
     0.443    13.729     0.200
     0.535    17.039     0.200
     0.527    17.469     0.200
     0.523    17.939     0.200
     0.958    31.299     0.200
     0.988    32.049     0.200
     0.276     8.529     0.200
     1.263    38.408     0.200
     1.898    59.498     0.200
     2.527    74.090     0.200
     2.727    81.379     0.200
     0.208     7.812     0.200
     0.242     8.133     0.200
     0.328    11.211     0.200
     0.351    11.770     0.200
     0.351    11.281     0.200
     0.379    12.691     0.200
     0.469    15.223     0.200
     0.469    14.801     0.200
     0.595    18.871     0.200
     0.710    23.312     0.200
     0.746    23.711     0.200
     0.790    25.223     0.200
     0.790    25.883     0.200
     0.890    29.250     0.200
     0.903    29.301     0.200
     1.081    35.152     0.200
     1.100    35.652     0.200
     0.073     4.027     0.200
     0.091     4.578     0.200
     0.150     5.066     0.200
     0.217     7.379     0.200
     0.228     7.156     0.200
     0.270     8.598     0.200
     0.265     8.945     0.200
     0.494    15.227     0.200
     0.538    17.855     0.200
     0.544    16.809     0.200
     0.658    21.129     0.200
     1.061    34.227     0.200
     0.064     4.395     0.200
     0.095     4.977     0.200
     0.145     5.387     0.200
     0.213     7.945     0.200
     0.218     7.516     0.200
     0.268     9.617     0.200
     0.426    13.426     0.200
     0.488    15.738     0.200
     0.526    17.375     0.200
     0.528    17.016     0.200
     0.528    16.637     0.200
     0.547    17.426     0.200
     0.628    19.855     0.200
     0.648    20.785     0.200
     0.691    22.066     0.200
     0.693    22.137     0.200
     0.722    23.328     0.200
     0.753    24.418     0.200
     0.753    24.547     0.200
     0.804    26.027     0.200
     1.065    34.438     0.200
     1.096    35.488     0.200
     0.137     6.195     0.200
     0.134     6.406     0.200
     0.179     7.227     0.200
     0.246     9.484     0.200
     0.249     8.812     0.200
     0.280     9.836     0.200
     0.363    12.516     0.200
     0.356    12.047     0.200
     0.383    13.680     0.200
     0.513    16.523     0.200
     0.518    17.906     0.200
     0.534    17.578     0.200
     0.567    18.398     0.200
     0.601    19.297     0.200
     0.650    20.727     0.200
     0.666    21.398     0.200
     0.722    23.734     0.200
     0.741    23.992     0.200
     0.762    24.594     0.200
     0.787    25.773     0.200
     0.801    25.828     0.200
     0.872    28.008     0.200
     0.868    28.305     0.200
     0.956    30.594     0.200
     0.063     4.753     0.200
     0.102     5.353     0.200
     0.138     5.683     0.200
     0.223     8.233     0.200
     0.222     7.703     0.200
     0.276     9.773     0.200
     0.278     9.593     0.200
     0.358    11.263     0.200
     0.435    14.393     0.200
     0.497    15.733     0.200
     0.532    17.973     0.200
     0.529    17.483     0.200
     0.637    20.413     0.200
     0.654    20.563     0.200
     0.665    21.983     0.200
     0.700    22.383     0.200
     0.701    22.843     0.200
     0.762    24.123     0.200
     0.753    24.483     0.200
     0.812    26.003     0.200
     1.138    35.953     0.200
     0.163     6.172     0.200
     0.190     6.570     0.200
     0.329    11.430     0.200
     0.382    12.883     0.200
     0.431    14.664     0.200
     0.423    14.000     0.200
     0.458    14.719     0.200
     0.488    16.070     0.200
     0.554    18.234     0.200
     0.587    19.062     0.200
     0.662    21.164     0.200
     0.680    21.898     0.200
     0.683    22.352     0.200
     0.707    22.461     0.200
     0.744    23.531     0.200
     0.753    24.602     0.200
     0.775    25.523     0.200
     0.849    27.250     0.200
     0.857    27.641     0.200
     0.871    28.164     0.200
     0.933    30.164     0.200
     0.943    30.570     0.200
     0.959    31.320     0.200
     0.969    32.281     0.200
     0.997    31.602     0.200
     1.114    36.062     0.200
     1.173    37.633     0.200
     1.749    55.852     0.200
     1.749    54.805     0.200
     1.957    60.844     0.200
     1.976    62.070     0.200
     2.083    64.750     0.200
     0.135     5.250     0.200
     0.134     5.453     0.200
     0.181     6.633     0.200
     0.216     7.516     0.200
     0.257     9.164     0.200
     0.341    11.336     0.200
     0.331    11.172     0.200
     0.416    13.781     0.200
     0.420    13.812     0.200
     0.455    14.961     0.200
     0.601    18.664     0.200
     0.661    20.742     0.200
     0.746    24.016     0.200
     0.751    23.914     0.200
     0.770    24.922     0.200
     0.813    26.125     0.200
     0.901    29.883     0.200
     0.928    30.141     0.200
     0.974    32.195     0.200
     0.983    31.914     0.200
     0.984    31.992     0.200
     1.121    35.680     0.200
     1.162    37.164     0.200
     1.787    56.156     0.200
     1.978    62.492     0.200
     2.004    62.844     0.200
     2.120    65.773     0.200
     0.020     4.508     0.200
     0.096     5.180     0.200
     0.148     6.160     0.200
     0.188     7.219     0.200
     0.238     8.148     0.200
     0.475    15.008     0.200
     0.481    15.711     0.200
     0.497    15.848     0.200
     0.504    16.988     0.200
     0.620    20.348     0.200
     0.680    21.980     0.200
     0.703    23.031     0.200
     0.736    24.121     0.200
     0.765    24.598     0.200
     0.796    26.379     0.200
     0.021     4.492     0.200
     0.106     5.352     0.200
     0.138     6.172     0.200
     0.188     7.117     0.200
     0.229     8.086     0.200
     0.380    12.312     0.200
     0.448    14.062     0.200
     0.482    15.336     0.200
     0.491    15.875     0.200
     0.487    15.992     0.200
     0.504    16.922     0.200
     0.621    20.336     0.200
     0.625    20.227     0.200
     0.672    21.594     0.200
     0.676    22.727     0.200
     0.696    22.117     0.200
     0.709    22.805     0.200
     0.709    23.547     0.200
     0.726    23.414     0.200
     0.731    23.781     0.200
     0.759    24.742     0.200
     0.793    25.797     0.200
     0.826    26.297     0.200
     0.856    28.422     0.200
     0.912    29.375     0.200
     0.972    31.250     0.200
     0.995    32.297     0.200
     1.154    36.352     0.200
     0.134     7.176     0.200
     0.174     7.914     0.200
     0.207     8.527     0.200
     0.299    10.605     0.200
     0.337    11.547     0.200
     0.386    13.484     0.200
     0.486    15.695     0.200
     0.556    18.984     0.200
     0.583    18.754     0.200
     0.625    21.105     0.200
     0.644    21.535     0.200
     0.695    22.414     0.200
     0.706    23.164     0.200
     0.724    23.336     0.200
     0.729    23.316     0.200
     0.743    24.215     0.200
     0.768    24.945     0.200
     0.834    26.734     0.200
     0.839    27.344     0.200
     0.828    27.047     0.200
     0.858    27.977     0.200
     0.915    29.637     0.200
     1.172    35.957     0.200
     2.702    81.547     0.200
     0.147     7.406     0.200
     0.188     7.855     0.200
     0.216     8.637     0.200
     0.313    10.215     0.200
     0.352    11.574     0.200
     0.397    13.055     0.200
     0.498    16.707     0.200
     0.562    18.414     0.200
     0.598    19.156     0.200
     0.636    20.215     0.200
     0.659    21.316     0.200
     0.700    22.984     0.200
     0.712    23.477     0.200
     0.736    24.336     0.200
     0.744    23.996     0.200
     0.744    24.594     0.200
     0.783    25.305     0.200
     0.837    26.934     0.200
     0.853    27.137     0.200
     0.870    28.336     0.200
     0.877    28.574     0.200
     0.930    30.367     0.200
     0.157     7.414     0.200
     0.196     8.266     0.200
     0.196     8.387     0.200
     0.219     8.914     0.200
     0.323    10.887     0.200
     0.360    12.016     0.200
     0.405    13.484     0.200
     0.507    16.535     0.200
     0.568    19.156     0.200
     0.607    18.867     0.200
     0.641    21.207     0.200
     0.668    22.414     0.200
     0.706    23.285     0.200
     0.719    23.965     0.200
     0.745    24.164     0.200
     0.747    24.594     0.200
     0.792    25.797     0.200
     0.850    27.855     0.200
     0.841    27.055     0.200
     0.876    28.117     0.200
     0.940    30.387     0.200
     0.062     4.379     0.200
     0.094     4.910     0.200
     0.147     5.328     0.200
     0.209     7.730     0.200
     0.214     7.441     0.200
     0.286     9.730     0.200
     0.346    11.398     0.200
     0.422    14.129     0.200
     0.484    14.531     0.200
     0.521    17.039     0.200
     0.526    16.258     0.200
     0.544    17.641     0.200
     0.623    19.828     0.200
     0.644    20.629     0.200
     0.651    20.531     0.200
     0.689    21.781     0.200
     0.691    21.980     0.200
     0.716    22.379     0.200
     0.748    24.551     0.200
     0.741    24.398     0.200
     0.773    24.801     0.200
     0.867    29.141     0.200
     1.064    34.500     0.200
     1.095    35.520     0.200
     0.094     5.340     0.200
     0.107     5.289     0.200
     0.155     6.680     0.200
     0.262     8.469     0.200
     0.258     9.141     0.200
     0.287    10.141     0.200
     0.417    13.488     0.200
     0.499    16.438     0.200
     0.525    17.258     0.200
     0.560    17.738     0.200
     0.578    18.617     0.200
     0.609    19.391     0.200
     0.649    21.008     0.200
     0.694    22.449     0.200
     0.697    21.938     0.200
     0.729    24.238     0.200
     0.728    23.129     0.200
     0.737    24.070     0.200
     0.756    23.719     0.200
     0.791    25.930     0.200
     0.825    26.859     0.200
     0.821    26.699     0.200
     0.842    27.617     0.200
     0.924    29.688     0.200
     0.941    30.609     0.200
     0.976    31.848     0.200
     1.201    37.578     0.200
     0.185     6.990     0.200
     0.267     8.789     0.200
     0.303     9.549     0.200
     0.469    14.900     0.200
     0.594    19.770     0.200
     0.676    21.600     0.200
     0.696    22.480     0.200
     0.852    27.449     0.200
     0.973    31.090     0.200
     0.994    31.930     0.200
     1.617    50.779     0.200
     0.100     5.430     0.200
     0.115     5.008     0.200
     0.151     6.367     0.200
     0.258     9.164     0.200
     0.317    10.438     0.200
     0.568    18.750     0.200
     0.591    18.836     0.200
     0.636    21.383     0.200
     0.854    26.977     0.200
     0.960    30.977     0.200
     1.105    35.727     0.200
     1.757    55.133     0.200
     0.035     3.328     0.200
     0.245     8.789     0.200
     0.367    11.168     0.200
     0.401    12.719     0.200
     0.453    14.797     0.200
     0.671    21.977     0.200
     0.683    22.969     0.200
     0.705    22.977     0.200
     0.970    31.188     0.200
     1.082    34.930     0.200
     1.114    35.809     0.200
     0.138     5.609     0.200
     0.170     6.602     0.200
     0.191     6.992     0.200
     0.282     9.781     0.200
     0.293    10.570     0.200
     0.398    13.438     0.200
     0.451    14.867     0.200
     0.467    15.555     0.200
     0.522    16.961     0.200
     0.652    21.555     0.200
     0.661    21.719     0.200
     0.725    24.070     0.200
     0.107     4.891     0.200
     0.126     5.055     0.200
     0.146     5.766     0.200
     0.153     5.906     0.200
     0.300     9.805     0.200
     0.313    10.391     0.200
     0.324    10.328     0.200
     0.515    16.766     0.200
     0.527    16.367     0.200
     0.540    17.445     0.200
     0.621    19.945     0.200
     0.160     5.264     0.200
     0.290     9.803     0.200
     0.297     9.674     0.200
     0.301     9.703     0.200
     0.316    10.424     0.200
     0.352    11.742     0.200
     0.424    13.982     0.200
     0.460    15.123     0.200
     0.618    19.543     0.200
     0.719    23.623     0.200
     0.737    23.594     0.200
     0.818    26.553     0.200
     1.831    58.572     0.200
     1.851    59.322     0.200
     0.088     3.992     0.200
     0.177     6.547     0.200
     0.223     7.961     0.200
     0.230     8.016     0.200
     0.295    10.078     0.200
     0.335    11.375     0.200
     0.368    12.047     0.200
     0.368    12.336     0.200
     0.489    15.977     0.200
     0.585    19.312     0.200
     0.594    19.195     0.200
     0.030     4.195     0.200
     0.096     5.289     0.200
     0.151     6.500     0.200
     0.195     7.680     0.200
     0.250     9.047     0.200
     0.248     9.047     0.200
     0.328    11.250     0.200
     0.478    16.117     0.200
     0.516    17.727     0.200
     0.990    31.914     0.200
     0.065     3.519     0.200
     0.201     6.709     0.200
     0.261     9.199     0.200
     0.277     9.379     0.200
     0.278     9.459     0.200
     0.279     9.409     0.200
     0.331    10.859     0.200
     0.375    12.289     0.200
     0.389    12.729     0.200
     0.502    16.059     0.200
     0.553    17.389     0.200
     0.596    19.169     0.200
     0.618    19.859     0.200
     0.630    20.409     0.200
     0.702    22.189     0.200
     0.707    22.229     0.200
     0.732    22.609     0.200
     0.703    22.549     0.200
     0.767    24.579     0.200
     0.778    24.899     0.200
     0.825    26.889     0.200
     0.827    26.349     0.200
     0.827    26.929     0.200
     0.855    27.039     0.200
     0.962    31.469     0.200
     0.996    32.359     0.200
     1.003    31.509     0.200
     1.197    38.509     0.200
     1.974    61.949     0.200
     2.658    78.489     0.200
     2.710    80.039     0.200
     0.054     3.278     0.200
     0.206     7.338     0.200
     0.271     9.729     0.200
     0.266     9.179     0.200
     0.267     9.188     0.200
     0.282     9.409     0.200
     0.322    10.769     0.200
     0.364    12.358     0.200
     0.377    12.668     0.200
     0.541    17.929     0.200
     0.588    19.398     0.200
     0.620    20.079     0.200
     0.631    19.889     0.200
     0.693    22.458     0.200
     0.717    23.259     0.200
     0.779    25.208     0.200
     0.835    26.479     0.200
     0.839    26.739     0.200
     0.973    32.318     0.200
     1.210    38.759     0.200
     0.059     3.420     0.200
     0.203     7.189     0.200
     0.266     9.020     0.200
     0.279     9.189     0.200
     0.272     9.391     0.200
     0.273     9.240     0.200
     0.327    10.900     0.200
     0.369    11.869     0.200
     0.369    12.500     0.200
     0.383    13.039     0.200
     0.507    15.980     0.200
     0.547    17.629     0.200
     0.592    19.510     0.200
     0.624    20.490     0.200
     0.624    19.740     0.200
     0.625    20.770     0.200
     0.698    22.549     0.200
     0.731    22.549     0.200
     0.830    26.629     0.200
     1.858    58.561     0.200
     0.045     3.156     0.200
     0.200     7.047     0.200
     0.259     8.945     0.200
     0.265     9.188     0.200
     0.270     9.430     0.200
     0.276     9.422     0.200
     0.326    10.648     0.200
     0.355    11.461     0.200
     0.372    12.695     0.200
     0.513    16.570     0.200
     0.533    17.555     0.200
     0.578    18.797     0.200
     0.683    22.156     0.200
     0.874    27.617     0.200
     0.974    31.438     0.200
     0.067     3.984     0.200
     0.133     4.828     0.200
     0.191     7.094     0.200
     0.205     6.969     0.200
     0.205     7.609     0.200
     0.317    10.648     0.200
     0.409    13.547     0.200
     0.423    13.891     0.200
     0.483    15.828     0.200
     0.498    16.430     0.200
     0.563    18.500     0.200
     0.586    19.547     0.200
     0.635    20.781     0.200
     1.055    34.281     0.200
     1.867    59.578     0.200
     0.060     3.354     0.200
     0.202     6.965     0.200
     0.265     9.244     0.200
     0.278     9.273     0.200
     0.273     9.285     0.200
     0.274     9.055     0.200
     0.328    11.314     0.200
     0.369    12.494     0.200
     0.384    13.074     0.200
     0.592    19.334     0.200
     0.623    20.424     0.200
     0.772    24.334     0.200
     0.828    26.115     0.200
     1.044    34.385     0.200
     0.051     3.145     0.200
     0.204     7.016     0.200
     0.264     9.137     0.200
     0.271     9.496     0.200
     0.266     8.914     0.200
     0.280     9.387     0.200
     0.323    10.586     0.200
     0.361    12.086     0.200
     0.375    12.676     0.200
     0.513    16.727     0.200
     0.538    17.363     0.200
     0.584    18.746     0.200
     0.616    19.754     0.200
     0.632    20.836     0.200
     0.717    23.516     0.200
     0.781    25.285     0.200
     0.785    25.434     0.200
     0.820    26.965     0.200
     0.834    26.227     0.200
     0.841    27.324     0.200
     0.974    31.375     0.200
     1.049    34.547     0.200
     1.211    38.387     0.200
     1.866    59.016     0.200
     0.039     3.102     0.200
     0.187     6.883     0.200
     0.252     8.941     0.200
     0.263     9.000     0.200
     0.264     9.262     0.200
     0.268     9.043     0.200
     0.346    11.820     0.200
     0.372    12.691     0.200
     0.527    17.812     0.200
     0.565    18.590     0.200
     0.600    18.941     0.200
     0.051     3.320     0.200
     0.206     7.273     0.200
     0.264     9.258     0.200
     0.273     9.734     0.200
     0.264     9.094     0.200
     0.282     9.445     0.200
     0.321    10.891     0.200
     0.361    12.117     0.200
     0.374    12.766     0.200
     0.515    16.805     0.200
     0.538    17.289     0.200
     0.586    18.820     0.200
     0.617    20.320     0.200
     0.633    20.266     0.200
     0.633    20.656     0.200
     0.690    22.578     0.200
     0.719    23.391     0.200
     0.787    25.227     0.200
     0.782    26.430     0.200
     0.836    27.438     0.200
     1.011    32.938     0.200
     1.051    34.094     0.200
     0.072     4.582     0.200
     0.103     4.852     0.200
     0.182     7.441     0.200
     0.230     8.691     0.200
     0.245     8.684     0.200
     0.338    11.664     0.200
     0.425    14.102     0.200
     0.449    15.215     0.200
     0.523    17.473     0.200
     0.575    19.023     0.200
     0.607    20.402     0.200
     0.646    21.914     0.200
     0.983    31.863     0.200
     1.098    35.012     0.200
     0.072     4.375     0.200
     0.338    11.293     0.200
     0.425    13.785     0.200
     0.537    17.543     0.200
     0.646    22.023     0.200
     1.098    34.785     0.200
     0.043     3.117     0.200
     0.209     7.461     0.200
     0.255     8.852     0.200
     0.256     8.609     0.200
     0.280     9.297     0.200
     0.286     9.531     0.200
     0.316    10.773     0.200
     0.353    11.844     0.200
     0.365    12.469     0.200
     0.522    16.578     0.200
     0.529    16.797     0.200
     0.579    18.953     0.200
     0.609    19.844     0.200
     0.642    20.414     0.200
     0.642    20.633     0.200
     0.682    22.117     0.200
     0.696    22.258     0.200
     0.729    22.820     0.200
     0.726    23.633     0.200
     0.791    24.914     0.200
     0.792    25.672     0.200
     0.819    26.961     0.200
     0.843    27.141     0.200
     0.851    27.367     0.200
     0.880    28.844     0.200
     0.983    31.969     0.200
     1.022    32.641     0.200
     1.021    32.664     0.200
     1.057    33.797     0.200
     1.221    39.164     0.200
     1.636    52.570     0.200
     1.667    53.172     0.200
     1.876    59.688     0.200
     1.998    62.820     0.200
     0.045     3.666     0.200
     0.198     7.366     0.200
     0.259     9.346     0.200
     0.269     9.676     0.200
     0.265     9.266     0.200
     0.275     9.636     0.200
     0.327    11.776     0.200
     0.355    12.256     0.200
     0.373    12.946     0.200
     0.577    19.926     0.200
     0.633    20.736     0.200
     0.683    22.836     0.200
     0.784    25.636     0.200
     0.842    27.626     0.200
     0.198     7.896     0.200
     0.327    11.296     0.200
     0.355    12.146     0.200
     0.373    12.616     0.200
     0.533    17.886     0.200
     0.577    19.526     0.200
     0.683    22.456     0.200
     0.055     5.473     0.200
     0.218     8.994     0.200
     0.274    10.424     0.200
     0.278    10.633     0.200
     0.385    13.684     0.200
     0.466    15.193     0.200
     0.466    15.943     0.200
     0.557    18.652     0.200
     0.620    21.264     0.200
     0.654    22.084     0.200
     0.063     3.484     0.200
     0.195     6.773     0.200
     0.257     8.875     0.200
     0.271     8.688     0.200
     0.276     9.555     0.200
     0.372    12.578     0.200
     0.390    13.008     0.200
     0.459    14.258     0.200
     0.447    14.305     0.200
     0.498    15.836     0.200
     0.595    19.305     0.200
     0.617    20.344     0.200
     0.618    20.227     0.200
     0.626    20.547     0.200
     0.767    24.969     0.200
     1.850    58.477     0.200
     0.049     3.141     0.200
     0.199     6.734     0.200
     0.268     9.156     0.200
     0.262     8.867     0.200
     0.275     8.867     0.200
     0.359    12.016     0.200
     0.376    12.469     0.200
     0.451    14.250     0.200
     0.473    14.930     0.200
     0.608    19.609     0.200
     0.614    20.023     0.200
     0.631    20.297     0.200
     0.632    20.438     0.200
     0.781    25.125     0.200
     1.045    33.844     0.200
     1.655    53.086     0.200
     0.530    15.500     0.200
     0.628    20.078     0.200
     0.083     3.742     0.200
     0.180     6.031     0.200
     0.231     7.602     0.200
     0.257     8.648     0.200
     0.310    10.406     0.200
     0.292     9.930     0.200
     0.361    11.812     0.200
     0.539    16.258     0.200
     0.585    18.570     0.200
     0.605    19.320     0.200
     0.629    21.195     0.200
     0.750    23.531     0.200
     0.895    28.188     0.200
     0.900    28.688     0.200
     1.295    41.242     0.200
     0.901    27.906     0.200
     0.838    25.859     0.200
     2.437    73.539     0.200
     3.131    93.266     0.200
     0.089     4.664     0.200
     0.089     4.773     0.200
     0.161     5.836     0.200
     0.236     7.953     0.200
     0.256     8.680     0.200
     0.295    10.164     0.200
     0.321    10.031     0.200
     0.511    16.445     0.200
     0.514    16.164     0.200
     0.591    19.492     0.200
     0.665    20.883     0.200
     0.785    25.664     0.200
     1.181    37.945     0.200
     0.111     4.363     0.200
     0.262     8.652     0.200
     0.263     9.125     0.200
     0.284     9.363     0.200
     0.304    10.254     0.200
     0.608    19.523     0.200
     0.658    21.312     0.200
     0.671    21.555     0.200
     0.808    25.723     0.200
     0.818    26.074     0.200
     0.961    31.516     0.200
     0.023     4.747     0.200
     0.138     6.207     0.200
     0.191     7.237     0.200
     0.231     8.317     0.200
     0.308    10.667     0.200
     0.318    10.697     0.200
     0.484    15.337     0.200
     0.489    15.957     0.200
     0.585    18.637     0.200
     0.727    23.287     0.200
     0.732    23.567     0.200
     0.748    24.327     0.200
     0.761    24.947     0.200
     0.795    25.637     0.200
     0.211     7.336     0.200
     0.297    10.285     0.200
     0.410    13.344     0.200
     0.412    13.715     0.200
     0.447    14.824     0.200
     0.468    15.574     0.200
     0.486    16.086     0.200
     0.701    22.824     0.200
     0.749    24.105     0.200
     0.737    24.285     0.200
     2.157    67.496     0.200
     0.061     3.262     0.200
     0.206     6.992     0.200
     0.273     9.152     0.200
     0.282     9.230     0.200
     0.371    12.410     0.200
     0.382    12.789     0.200
     0.466    14.391     0.200
     0.452    14.449     0.200
     0.597    19.082     0.200
     0.604    19.832     0.200
     0.625    19.922     0.200
     0.833    26.652     0.200
     1.107    35.652     0.200
     0.048     3.609     0.200
     0.199     7.207     0.200
     0.262     9.387     0.200
     0.269     9.559     0.200
     0.276     9.387     0.200
     0.358    11.906     0.200
     0.375    12.777     0.200
     0.440    13.949     0.200
     0.452    14.949     0.200
     0.474    14.770     0.200
     0.511    16.539     0.200
     0.600    19.699     0.200
     0.609    20.277     0.200
     0.631    20.770     0.200
     0.633    20.648     0.200
     0.686    22.047     0.200
     0.691    22.578     0.200
     0.202     7.414     0.200
     0.262     8.922     0.200
     0.278     9.453     0.200
     0.279     9.531     0.200
     0.330    11.125     0.200
     0.375    12.609     0.200
     0.389    13.344     0.200
     0.459    14.180     0.200
     0.452    14.844     0.200
     0.617    20.000     0.200
     0.618    20.312     0.200
     0.631    20.359     0.200
     0.703    22.742     0.200
     0.766    25.062     0.200
     0.780    25.664     0.200
     0.827    26.594     0.200
     0.828    26.359     0.200
     0.546    16.609     0.200
     0.199     7.102     0.200
     0.262     9.539     0.200
     0.274     9.586     0.200
     0.275     9.414     0.200
     0.370    12.398     0.200
     0.446    14.836     0.200
     0.451    14.648     0.200
     0.621    20.406     0.200
     0.621    20.359     0.200
     0.698    23.000     0.200
     0.778    24.930     0.200
     0.823    26.977     0.200
     0.213     7.371     0.200
     0.277     9.012     0.200
     0.289     9.641     0.200
     0.375    12.039     0.200
     0.383    12.719     0.200
     0.466    14.941     0.200
     0.460    14.660     0.200
     0.512    16.332     0.200
     0.592    19.102     0.200
     0.602    19.750     0.200
     0.622    20.051     0.200
     0.625    19.980     0.200
     0.705    23.391     0.200
     0.771    24.660     0.200
     0.833    26.840     0.200
     0.836    27.750     0.200
     0.052     4.270     0.200
     0.128     6.031     0.200
     0.168     6.701     0.200
     0.202     7.150     0.200
     0.302     8.891     0.200
     0.326    11.131     0.200
     0.406    13.250     0.200
     0.554    17.420     0.200
     0.551    17.811     0.200
     0.601    19.330     0.200
     0.690    21.330     0.200
     0.697    22.131     0.200
     0.797    24.881     0.200
     0.205     6.672     0.200
     0.271     9.070     0.200
     0.266     8.891     0.200
     0.267     9.211     0.200
     0.281     9.219     0.200
     0.323    10.703     0.200
     0.363    12.344     0.200
     0.376    12.562     0.200
     0.447    14.453     0.200
     0.472    14.672     0.200
     0.457    14.383     0.200
     0.458    14.578     0.200
     0.512    16.539     0.200
     0.540    17.359     0.200
     0.587    19.164     0.200
     0.603    18.938     0.200
     0.604    19.852     0.200
     0.599    19.750     0.200
     0.619    20.438     0.200
     0.631    20.211     0.200
     0.630    20.648     0.200
     0.692    22.930     0.200
     0.698    22.539     0.200
     0.730    23.070     0.200
     0.779    24.570     0.200
     0.785    26.172     0.200
     0.823    27.094     0.200
     0.834    26.688     0.200
     1.009    32.828     0.200
     1.013    32.750     0.200
     1.049    34.008     0.200
     1.111    36.039     0.200
     1.154    37.523     0.200
     1.834    58.242     0.200
     1.864    59.398     0.200
     1.987    62.609     0.200
     0.533    15.750     0.200
     0.631    19.828     0.200
     0.623    19.250     0.200
     0.036     4.867     0.200
     0.127     5.688     0.200
     0.202     7.520     0.200
     0.230     8.219     0.200
     0.253     9.027     0.200
     0.299    10.566     0.200
     0.304    10.547     0.200
     0.375    12.156     0.200
     0.447    14.359     0.200
     0.496    16.148     0.200
     0.497    16.336     0.200
     0.502    16.508     0.200
     0.516    17.117     0.200
     0.635    20.359     0.200
     0.711    23.328     0.200
     0.720    23.680     0.200
     0.723    22.938     0.200
     0.743    23.969     0.200
     0.802    26.309     0.200
     0.988    31.527     0.200
     1.009    32.520     0.200
     0.061     2.152     0.200
     0.142     4.344     0.200
     0.227     7.504     0.200
     0.369    12.262     0.200
     0.374    12.531     0.200
     0.390    12.523     0.200
     0.395    12.512     0.200
     0.420    13.492     0.200
     0.525    16.441     0.200
     0.533    17.762     0.200
     0.537    17.414     0.200
     0.562    17.641     0.200
     0.572    18.602     0.200
     0.802    26.883     0.200
     0.921    30.074     0.200
     0.972    31.363     0.200
     0.063     4.680     0.200
     0.091     4.699     0.200
     0.177     6.797     0.200
     0.186     6.707     0.200
     0.252     9.199     0.200
     0.323    10.617     0.200
     0.309    10.840     0.200
     0.393    13.059     0.200
     0.448    14.328     0.200
     0.488    16.020     0.200
     0.506    16.770     0.200
     0.516    17.047     0.200
     0.527    16.508     0.200
     0.587    18.867     0.200
     0.613    19.660     0.200
     0.620    20.180     0.200
     0.669    21.828     0.200
     0.675    22.340     0.200
     0.682    21.777     0.200
     0.690    22.328     0.200
     0.692    22.277     0.200
     0.713    23.500     0.200
     0.736    24.309     0.200
     0.764    25.047     0.200
     0.975    31.297     0.200
     1.052    34.098     0.200
     0.055     4.414     0.200
     0.099     4.414     0.200
     0.180     6.605     0.200
     0.180     6.586     0.200
     0.260     9.043     0.200
     0.316    10.355     0.200
     0.330    10.445     0.200
     0.449    14.926     0.200
     0.484    16.062     0.200
     0.498    16.312     0.200
     0.535    17.535     0.200
     0.587    19.562     0.200
     0.608    19.676     0.200
     0.623    19.855     0.200
     0.676    22.184     0.200
     0.680    22.152     0.200
     0.683    22.586     0.200
     0.684    22.062     0.200
     0.695    21.926     0.200
     0.715    23.234     0.200
     0.727    23.484     0.200
     0.762    24.902     0.200
     0.775    25.992     0.200
     0.852    28.293     0.200
     0.865    28.855     0.200
     0.944    30.965     0.200
     0.961    31.523     0.200
     0.982    32.184     0.200
     0.983    32.305     0.200
     0.986    32.445     0.200
     1.103    35.535     0.200
     1.100    35.766     0.200
     1.206    38.324     0.200
     0.315    10.062     0.200
     1.245    38.855     0.200
     1.335    40.914     0.200
     0.060     4.484     0.200
     0.092     4.711     0.200
     0.180     6.523     0.200
     0.187     6.680     0.200
     0.255     9.344     0.200
     0.308    10.984     0.200
     0.397    12.664     0.200
     0.451    15.102     0.200
     0.490    16.750     0.200
     0.506    16.320     0.200
     0.590    19.266     0.200
     0.615    20.062     0.200
     0.623    20.430     0.200
     0.672    21.633     0.200
     0.678    22.297     0.200
     0.685    21.984     0.200
     0.692    22.516     0.200
     0.717    23.391     0.200
     0.735    23.930     0.200
     0.767    25.141     0.200
     0.860    28.375     0.200
     0.978    31.266     0.200
     0.976    31.602     0.200
     0.994    32.305     0.200
     0.105     3.910     0.200
     0.090     3.738     0.200
     0.216     7.508     0.200
     0.260     8.910     0.200
     0.293     9.578     0.200
     0.348    11.609     0.200
     0.335    11.688     0.200
     0.369    12.148     0.200
     0.362    12.480     0.200
     0.375    12.027     0.200
     0.383    11.969     0.200
     0.498    16.590     0.200
     0.516    16.980     0.200
     0.554    17.859     0.200
     0.561    18.098     0.200
     0.596    19.219     0.200
     0.613    19.949     0.200
     0.648    21.688     0.200
     0.834    27.340     0.200
     0.882    28.617     0.200
     0.931    30.230     0.200
     0.090     6.195     0.200
     0.170     7.258     0.200
     0.188     8.070     0.200
     0.262     9.984     0.200
     0.310    10.656     0.200
     0.323    11.234     0.200
     0.330    11.805     0.200
     0.323    11.422     0.200
     0.385    14.359     0.200
     0.442    14.172     0.200
     0.434    14.758     0.200
     0.534    17.734     0.200
     0.610    19.688     0.200
     0.582    20.148     0.200
     0.639    20.461     0.200
     0.674    21.938     0.200
     0.734    23.602     0.200
     0.767    25.016     0.200
     0.792    24.930     0.200
     0.810    25.727     0.200
     0.834    26.375     0.200
     0.897    29.109     0.200
     0.970    30.648     0.200
     0.972    31.180     0.200
     1.002    31.625     0.200
     1.042    32.461     0.200
     1.685    51.781     0.200
     1.739    53.828     0.200
     1.731    53.000     0.200
     1.789    55.180     0.200
     1.832    56.578     0.200
     1.907    58.086     0.200
     1.930    59.039     0.200
     1.958    60.531     0.200
     0.119     4.164     0.200
     0.228     7.453     0.200
     0.210     7.855     0.200
     0.247     8.086     0.200
     0.272     9.086     0.200
     0.389    13.094     0.200
     0.384    12.766     0.200
     0.476    15.234     0.200
     0.527    17.363     0.200
     0.545    18.074     0.200
     0.529    18.023     0.200
     0.551    17.715     0.200
     0.661    21.355     0.200
     0.657    21.555     0.200
     0.703    23.184     0.200
     0.719    23.496     0.200
     0.846    26.895     0.200
     0.828    27.996     0.200
     0.971    30.703     0.200
     1.031    33.695     0.200
     1.088    33.785     0.200
     0.207     6.758     0.200
     0.268     8.789     0.200
     0.283     9.148     0.200
     0.272     9.156     0.200
     0.274     9.406     0.200
     0.324    10.820     0.200
     0.371    12.469     0.200
     0.383    12.930     0.200
     0.466    14.461     0.200
     0.452    14.375     0.200
     0.453    14.805     0.200
     0.459    15.398     0.200
     0.509    16.461     0.200
     0.548    18.148     0.200
     0.596    19.727     0.200
     0.602    19.445     0.200
     0.595    19.625     0.200
     0.604    19.570     0.200
     0.623    19.836     0.200
     0.625    20.141     0.200
     0.627    20.500     0.200
     0.704    22.711     0.200
     0.700    23.039     0.200
     0.714    22.945     0.200
     0.735    23.039     0.200
     0.772    25.281     0.200
     0.785    25.781     0.200
     0.832    26.781     0.200
     0.833    26.836     0.200
     0.829    26.930     0.200
     0.969    31.570     0.200
     1.002    32.805     0.200
     1.010    32.719     0.200
     1.047    34.000     0.200
     1.107    35.484     0.200
     1.148    37.227     0.200
     1.204    39.016     0.200
     1.649    52.969     0.200
     1.829    58.266     0.200
     1.859    59.555     0.200
     1.980    62.516     0.200
     0.541    16.586     0.200
     0.639    20.148     0.200
     0.615    19.305     0.200
     2.068    66.141     0.200
     0.061     2.359     0.200
     0.174     6.348     0.200
     0.196     6.129     0.200
     0.241     8.309     0.200
     0.320     9.828     0.200
     0.353    11.758     0.200
     0.389    13.051     0.200
     0.429    13.180     0.200
     0.428    14.078     0.200
     0.480    14.809     0.200
     0.490    15.309     0.200
     0.487    16.270     0.200
     0.512    16.328     0.200
     0.633    20.938     0.200
     0.705    22.621     0.200
     0.716    23.469     0.200
     0.721    23.699     0.200
     0.786    25.758     0.200
     0.959    30.719     0.200
     1.037    33.738     0.200
     1.105    34.910     0.200
     1.153    37.668     0.200
     1.182    38.270     0.200
     1.776    56.469     0.200
     1.835    58.289     0.200
     0.050     1.887     0.200
     0.239     7.887     0.200
     0.247     8.867     0.200
     0.294    10.227     0.200
     0.354    11.566     0.200
     0.394    13.117     0.200
     0.386    12.926     0.200
     0.458    15.656     0.200
     0.539    17.656     0.200
     0.592    19.227     0.200
     0.805    26.387     0.200
     0.835    27.105     0.200
     0.908    29.566     0.200
     0.959    31.414     0.200
     1.304    42.188     0.200
     0.099     5.391     0.200
     0.236     8.172     0.200
     0.241     8.320     0.200
     0.236     8.641     0.200
     0.334    11.109     0.200
     0.389    11.922     0.200
     0.376    12.430     0.200
     0.370    12.258     0.200
     0.445    14.219     0.200
     0.451    14.758     0.200
     0.513    17.266     0.200
     0.528    1