#!/bin/bash
gmt begin chamoli16.22_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source chamoli16.22'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.8 -10.0
  0.8 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.777     0.008     0.200
     0.982    -0.294     0.200
     0.426     0.016     0.200
     0.677    -0.329     0.200
     0.762    -1.167     0.200
     0.770    -0.108     0.200
     0.738    -0.265     0.200
     0.704    -0.319     0.200
     0.534    -0.775     0.200
     0.934     0.172     0.200
     0.830    -1.183     0.200
     0.996     0.628     0.200
     0.982     1.430     0.200
     0.960     1.347     0.200
     0.995     0.113     0.200
     0.198    -1.374     0.200
     0.997     0.040     0.200
     0.275    -0.674     0.200
     0.975     1.117     0.200
     0.276    -0.655     0.200
     0.573     0.016     0.200
     0.859     0.148     0.200
     0.869    -0.296     0.200
     0.976    -0.067     0.200
     0.086     0.024     0.200
     0.241    -1.696     0.200
     0.245    -0.377     0.200
     0.292    -0.233     0.200
     0.324    -0.417     0.200
     0.577    -0.116     0.200
     0.042    -0.613     0.200
     0.216    -0.459     0.200
     0.268    -0.396     0.200
     0.546    -0.353     0.200
     0.822    -1.154     0.200
     0.828     0.019     0.200
     0.054     0.010     0.200
     0.063     0.251     0.200
     0.223    -0.339     0.200
     0.219    -0.357     0.200
     0.219    -0.255     0.200
     0.262    -0.113     0.200
     0.292    -0.358     0.200
     0.049    -0.121     0.200
     0.065    -0.223     0.200
     0.070     0.021     0.200
     0.213    -0.447     0.200
     0.217    -0.414     0.200
     0.262    -0.206     0.200
     0.257    -0.191     0.200
     0.286    -0.396     0.200
     0.540     0.505     0.200
     0.816    -0.353     0.200
     0.822    -0.275     0.200
     0.058    -0.480     0.200
     0.077     0.213     0.200
     0.126     0.097     0.200
     0.249    -0.282     0.200
     0.249    -0.968     0.200
     0.344    -0.104     0.200
     0.346    -0.257     0.200
     0.366    -0.271     0.200
     0.626    -0.060     0.200
     0.897    -0.084     0.200
     0.894     0.119     0.200
     0.077    -0.082     0.200
     0.050    -0.009     0.200
     0.088    -0.992     0.200
     0.187     0.232     0.200
     0.224    -0.737     0.200
     0.230    -0.016     0.200
     0.234    -0.243     0.200
     0.288    -0.570     0.200
     0.293    -0.147     0.200
     0.288    -0.223     0.200
     0.571     0.327     0.200
     0.846    -0.481     0.200
     0.852    -0.593     0.200
     0.966    -0.482     0.200
     0.048    -0.000     0.200
     0.055    -0.597     0.200
     0.072     0.031     0.200
     0.215     0.053     0.200
     0.216    -0.529     0.200
     0.207     0.215     0.200
     0.262    -0.458     0.200
     0.255     0.018     0.200
     0.531     0.115     0.200
     0.809    -0.576     0.200
     0.816    -0.719     0.200
     0.049    -0.109     0.200
     0.082    -0.247     0.200
     0.184     0.309     0.200
     0.236    -0.354     0.200
     0.232    -0.122     0.200
     0.292    -0.502     0.200
     0.298    -0.354     0.200
     0.294    -0.350     0.200
     0.577    -0.112     0.200
     0.857    -0.759     0.200
     0.971    -0.152     0.200
     0.088    -0.175     0.200
     0.009    -0.632     0.200
     0.037     0.037     0.200
     0.243    -0.285     0.200
     0.246    -0.452     0.200
     0.294    -0.152     0.200
     0.301    -0.217     0.200
     0.300     0.053     0.200
     0.578     0.311     0.200
     0.855     0.471     0.200
     0.862    -0.304     0.200
     0.051    -0.031     0.200
     0.063    -0.152     0.200
     0.076    -0.014     0.200
     0.221    -0.708     0.200
     0.226    -0.367     0.200
     0.248     0.102     0.200
     0.262    -0.479     0.200
     0.522     0.110     0.200
     0.811    -0.694     0.200
     0.802    -0.283     0.200
     0.921    -1.260     0.200
     0.023    -0.008     0.200
     0.143    -0.004     0.200
     0.041    -0.132     0.200
     0.255    -0.464     0.200
     0.319    -0.312     0.200
     0.326     0.348     0.200
     0.605     0.156     0.200
     0.885    -0.598     0.200
     0.037    -0.127     0.200
     0.060    -0.610     0.200
     0.082    -0.072     0.200
     0.202    -0.661     0.200
     0.207    -0.338     0.200
     0.251    -0.461     0.200
     0.218     0.117     0.200
     0.530    -0.165     0.200
     0.810    -0.550     0.200
     0.804    -0.682     0.200
     0.048    -0.057     0.200
     0.050    -0.602     0.200
     0.070    -0.055     0.200
     0.220    -0.312     0.200
     0.206     0.097     0.200
     0.254    -0.278     0.200
     0.260    -0.238     0.200
     0.264    -0.655     0.200
     0.537    -0.056     0.200
     0.820    -0.668     0.200
     0.814    -0.386     0.200
     0.074    -0.131     0.200
     0.023    -0.827     0.200
     0.050    -0.029     0.200
     0.229    -1.112     0.200
     0.187     0.088     0.200
     0.290    -0.178     0.200
     0.568    -0.150     0.200
     0.843     0.161     0.200
     0.849    -0.955     0.200
     0.044    -0.116     0.200
     0.104    -0.077     0.200
     0.052    -1.232     0.200
     0.074    -0.048     0.200
     0.208    -0.872     0.200
     0.213    -0.336     0.200
     0.259    -0.127     0.200
     0.211     0.214     0.200
     0.259    -0.383     0.200
     0.538    -0.093     0.200
     0.657     0.466     0.200
     0.819    -0.342     0.200
     0.813    -0.372     0.200
     0.130    -0.254     0.200
     0.158    -0.208     0.200
     0.107     0.116     0.200
     0.185    -0.308     0.200
     0.174     0.139     0.200
     0.177    -0.043     0.200
     0.235    -0.313     0.200
     0.286     0.209     0.200
     0.417     0.062     0.200
     0.564    -0.297     0.200
     0.707    -0.257     0.200
     0.720    -0.662     0.200
     0.138    -0.267     0.200
     0.096     0.120     0.200
     0.114     0.239     0.200
     0.161    -0.317     0.200
     0.187    -0.355     0.200
     0.163     0.128     0.200
     0.170    -0.036     0.200
     0.217    -0.661     0.200
     0.283     0.206     0.200
     0.424     0.166     0.200
     0.567    -0.441     0.200
     0.712     0.162     0.200
     0.724    -0.976     0.200
     0.137     0.011     0.200
     0.196    -0.360     0.200
     0.137    -0.018     0.200
     0.241     0.079     0.200
     0.215    -0.075     0.200
     0.268    -0.437     0.200
     0.214     0.154     0.200
     0.293    -1.757     0.200
     0.304    -0.161     0.200
     0.301    -0.313     0.200
     0.317     0.091     0.200
     0.480    -0.001     0.200
     0.644     0.227     0.200
     0.781     0.534     0.200
     0.798    -0.089     0.200
     0.051    -0.045     0.200
     0.111    -0.086     0.200
     0.047    -0.145     0.200
     0.191    -0.519     0.200
     0.220    -0.364     0.200
     0.265    -0.719     0.200
     0.204     0.104     0.200
     0.287    -0.306     0.200
     0.662    -0.190     0.200
     0.824    -0.306     0.200
     0.817     0.220     0.200
     0.936    -1.276     0.200
     0.097     0.137     0.200
     0.137    -0.293     0.200
     0.172    -0.077     0.200
     0.216    -0.918     0.200
     0.225    -0.452     0.200
     0.284     0.164     0.200
     0.046    -0.217     0.200
     0.103    -0.225     0.200
     0.050    -0.182     0.200
     0.208    -1.591     0.200
     0.213    -0.398     0.200
     0.258    -0.299     0.200
     0.260     0.179     0.200
     0.210     0.292     0.200
     0.540     0.196     0.200
     0.659     0.011     0.200
     0.820     0.053     0.200
     0.934     0.174     0.200
     0.055    -0.219     0.200
     0.060    -0.733     0.200
     0.084     0.008     0.200
     0.127    -0.068     0.200
     0.202     0.108     0.200
     0.225    -1.373     0.200
     0.231    -0.249     0.200
     0.252    -0.097     0.200
     0.525    -0.007     0.200
     0.655    -0.121     0.200
     0.815    -0.299     0.200
     0.925    -0.603     0.200
     0.033     0.043     0.200
     0.034    -0.179     0.200
     0.039     0.058     0.200
     0.092    -0.155     0.200
     0.063    -0.520     0.200
     0.200    -0.713     0.200
     0.246    -0.170     0.200
     0.249    -0.384     0.200
     0.249    -0.078     0.200
     0.221     0.115     0.200
     0.373    -0.065     0.200
     0.528    -0.332     0.200
     0.647    -0.260     0.200
     0.802    -0.846     0.200
     0.808    -0.464     0.200
     0.019    -0.012     0.200
     0.090    -0.041     0.200
     0.148    -0.304     0.200
     0.153    -0.062     0.200
     0.137    -0.116     0.200
     0.153    -0.108     0.200
     0.163    -0.551     0.200
     0.203    -0.745     0.200
     0.204    -0.397     0.200
     0.213    -0.446     0.200
     0.291     0.018     0.200
     0.422    -0.195     0.200
     0.559    -0.251     0.200
     0.706    -0.935     0.200
     0.717    -0.651     0.200
     0.823    -0.886     0.200
     0.020    -0.004     0.200
     0.080    -0.272     0.200
     0.086     0.001     0.200
     0.139    -0.181     0.200
     0.152    -0.329     0.200
     0.150    -0.151     0.200
     0.146    -0.517     0.200
     0.163    -0.585     0.200
     0.199    -0.833     0.200
     0.269    -0.055     0.200
     0.292     0.023     0.200
     0.422    -0.097     0.200
     0.557    -0.384     0.200
     0.705     0.914     0.200
     0.716    -0.393     0.200
     0.822     0.308     0.200
     0.057     0.002     0.200
     0.055    -0.465     0.200
     0.057    -0.600     0.200
     0.127    -0.015     0.200
     0.201    -0.491     0.200
     0.243    -0.285     0.200
     0.232    -0.449     0.200
     0.200     0.207     0.200
     0.280    -0.405     0.200
     0.529     0.050     0.200
     0.658     0.217     0.200
     0.818     0.467     0.200
     0.928     0.502     0.200
     0.061    -0.486     0.200
     0.035    -0.490     0.200
     0.113    -0.025     0.200
     0.060    -0.003     0.200
     0.181    -0.802     0.200
     0.220    -1.413     0.200
     0.224    -0.231     0.200
     0.261    -0.160     0.200
     0.272    -0.198     0.200
     0.276    -0.019     0.200
     0.300    -0.361     0.200
     0.555    -0.306     0.200
     0.674     0.228     0.200
     0.836     0.005     0.200
     0.104    -0.209     0.200
     0.121    -0.353     0.200
     0.158    -0.156     0.200
     0.185    -0.351     0.200
     0.190     0.059     0.200
     0.230    -0.014     0.200
     0.249    -0.482     0.200
     0.291     0.099     0.200
     0.409    -0.381     0.200
     0.561    -0.395     0.200
     0.717    -0.978     0.200
     0.817    -0.592     0.200
     0.079    -0.047     0.200
     0.148    -1.329     0.200
     0.191    -0.328     0.200
     0.246    -0.004     0.200
     0.282    -0.132     0.200
     0.266    -0.163     0.200
     0.261    -0.270     0.200
     0.230     0.134     0.200
     0.543    -0.406     0.200
     0.652     0.379     0.200
     0.811     0.467     0.200
     0.814    -0.606     0.200
     0.932     0.295     0.200
     0.033    -0.232     0.200
     0.062    -1.267     0.200
     0.034    -0.760     0.200
     0.055    -0.025     0.200
     0.111    -0.011     0.200
     0.122    -0.117     0.200
     0.227    -0.806     0.200
     0.232    -0.402     0.200
     0.191     0.097     0.200
     0.255    -0.181     0.200
     0.267    -0.186     0.200
     0.275    -0.022     0.200
     0.279    -0.583     0.200
     0.299    -0.311     0.200
     0.551    -0.521     0.200
     0.675    -0.206     0.200
     0.836    -0.273     0.200
     0.060    -0.520     0.200
     0.032    -0.293     0.200
     0.036    -0.832     0.200
     0.056    -0.046     0.200
     0.110     0.033     0.200
     0.120    -0.007     0.200
     0.189    -1.524     0.200
     0.193     0.073     0.200
     0.230    -0.500     0.200
     0.254    -0.170     0.200
     0.266    -0.170     0.200
     0.551    -0.321     0.200
     0.674     0.402     0.200
     0.044    -0.423     0.200
     0.122    -1.270     0.200
     0.082    -1.224     0.200
     0.090    -1.314     0.200
     0.183    -1.063     0.200
     0.157    -0.172     0.200
     0.258    -0.102     0.200
     0.303    -0.281     0.200
     0.312    -0.304     0.200
     0.577    -0.758     0.200
     0.673     0.224     0.200
     0.836    -0.809     0.200
     0.998    -1.020     0.200
     0.020    -0.080     0.200
     0.048    -0.561     0.200
     0.057    -0.810     0.200
     0.089    -0.070     0.200
     0.083    -0.057     0.200
     0.112    -0.008     0.200
     0.158    -1.644     0.200
     0.196    -0.910     0.200
     0.200    -0.357     0.200
     0.221     0.185     0.200
     0.259    -0.187     0.200
     0.265    -0.251     0.200
     0.545    -0.305     0.200
     0.657     0.317     0.200
     0.819     0.382     0.200
     0.017     0.015     0.200
     0.034    -0.566     0.200
     0.111    -0.125     0.200
     0.219    -0.830     0.200
     0.267    -0.107     0.200
     0.198     0.034     0.200
     0.277    -0.167     0.200
     0.280     0.167     0.200
     0.304    -0.181     0.200
     0.560    -0.527     0.200
     0.677    -0.146     0.200
     0.839    -0.360     0.200
     0.833    -0.450     0.200
     0.953    -0.251     0.200
     0.113    -0.075     0.200
     0.133     0.144     0.200
     0.175    -1.156     0.200
     0.226    -0.312     0.200
     0.194     0.150     0.200
     0.283    -0.074     0.200
     0.291     0.036     0.200
     0.279    -0.263     0.200
     0.289    -0.289     0.200
     0.571     0.207     0.200
     0.687     0.057     0.200
     0.844     0.675     0.200
     0.849     0.075     0.200
     0.997     0.364     0.200
     0.015     0.325     0.200
     0.116    -0.093     0.200
     0.049    -0.362     0.200
     0.096    -0.046     0.200
     0.163    -0.579     0.200
     0.203    -0.932     0.200
     0.207    -0.270     0.200
     0.262    -0.182     0.200
     0.261    -0.038     0.200
     0.269    -0.138     0.200
     0.270    -0.196     0.200
     0.292    -0.155     0.200
     0.550    -0.265     0.200
     0.664     0.126     0.200
     0.826    -0.355     0.200
     0.942     0.476     0.200
     0.019    -0.131     0.200
     0.032    -0.705     0.200
     0.113    -0.109     0.200
     0.179    -0.762     0.200
     0.221    -0.664     0.200
     0.225    -0.306     0.200
     0.196     0.190     0.200
     0.277    -0.229     0.200
     0.304    -0.220     0.200
     0.678     0.421     0.200
     0.840    -0.305     0.200
     0.047    -0.128     0.200
     0.066    -0.799     0.200
     0.105    -0.025     0.200
     0.180    -0.879     0.200
     0.204    -0.740     0.200
     0.209    -0.386     0.200
     0.230    -0.179     0.200
     0.240    -0.166     0.200
     0.268    -0.269     0.200
     0.220     0.108     0.200
     0.043     0.318     0.200
     0.088    -0.021     0.200
     0.063    -0.350     0.200
     0.177    -0.860     0.200
     0.203    -0.836     0.200
     0.208    -0.530     0.200
     0.234    -0.200     0.200
     0.243    -0.157     0.200
     0.270    -0.248     0.200
     0.219     0.058     0.200
     0.052    -0.943     0.200
     0.029    -0.432     0.200
     0.043    -0.653     0.200
     0.066     0.045     0.200
     0.106     0.078     0.200
     0.111    -0.096     0.200
     0.181    -1.574     0.200
     0.216    -0.899     0.200
     0.220    -0.424     0.200
     0.203     0.120     0.200
     0.251    -0.107     0.200
     0.262    -0.068     0.200
     0.291    -0.218     0.200
     0.051    -0.207     0.200
     0.055    -0.360     0.200
     0.127     0.053     0.200
     0.077     0.040     0.200
     0.170    -1.026     0.200
     0.119    -0.970     0.200
     0.181    -0.030     0.200
     0.238    -1.546     0.200
     0.239    -0.189     0.200
     0.193     0.212     0.200
     0.311    -1.005     0.200
     0.327    -0.229     0.200
     0.336    -0.128     0.200
     0.355    -0.234     0.200
     0.021    -0.054     0.200
     0.045    -0.684     0.200
     0.064    -0.221     0.200
     0.103    -0.146     0.200
     0.052    -0.212     0.200
     0.052    -0.245     0.200
     0.172    -1.200     0.200
     0.111     0.155     0.200
     0.264    -0.520     0.200
     0.266    -0.272     0.200
     0.291    -0.313     0.200
     0.391    -0.139     0.200
     0.050    -0.388     0.200
     0.051     0.011     0.200
     0.032    -0.543     0.200
     0.046    -0.842     0.200
     0.103    -0.002     0.200
     0.067     0.016     0.200
     0.183    -1.621     0.200
     0.216    -1.634     0.200
     0.213    -0.031     0.200
     0.220    -0.291     0.200
     0.204     0.146     0.200
     0.259    -0.216     0.200
     0.266     0.665     0.200
     0.288    -0.254     0.200
     0.382    -0.439     0.200
     0.062    -0.503     0.200
     0.062    -0.138     0.200
     0.017    -0.112     0.200
     0.035    -0.403     0.200
     0.062    -0.061     0.200
     0.110    -0.078     0.200
     0.199     0.175     0.200
     0.213    -0.027     0.200
     0.222    -0.319     0.200
     0.275    -0.262     0.200
     0.302    -0.229     0.200
     0.399     0.048     0.200
     0.050    -1.114     0.200
     0.051    -0.081     0.200
     0.026     0.056     0.200
     0.046    -0.567     0.200
     0.107    -0.059     0.200
     0.069    -0.059     0.200
     0.106    -0.089     0.200
     0.176    -1.691     0.200
     0.216    -0.345     0.200
     0.212    -2.219     0.200
     0.208    -0.014     0.200
     0.207     0.192     0.200
     0.262    -0.175     0.200
     0.264     0.262     0.200
     0.289    -0.247     0.200
     0.387    -0.145     0.200
     0.023    -0.204     0.200
     0.031     0.070     0.200
     0.061    -0.228     0.200
     0.070     0.040     0.200
     0.112    -0.112     0.200
     0.087    -0.436     0.200
     0.102    -0.012     0.200
     0.208    -0.424     0.200
     0.189    -0.868     0.200
     0.201    -1.285     0.200
     0.207    -0.146     0.200
     0.216    -0.204     0.200
     0.237    -0.514     0.200
     0.248    -0.386     0.200
     0.232     0.110     0.200
     0.342    -0.253     0.200
     0.011    -0.259     0.200
     0.076    -0.120     0.200
     0.078     0.022     0.200
     0.037    -0.367     0.200
     0.106    -0.067     0.200
     0.066     0.012     0.200
     0.166    -1.335     0.200
     0.220    -0.292     0.200
     0.217    -1.588     0.200
     0.209    -0.072     0.200
     0.295    -0.159     0.200
     0.316    -0.187     0.200
     0.420    -0.110     0.200
     0.059    -0.606     0.200
     0.059    -0.124     0.200
     0.019     0.150     0.200
     0.039    -0.252     0.200
     0.116    -0.107     0.200
     0.064    -0.077     0.200
     0.108    -0.041     0.200
     0.175    -1.110     0.200
     0.219    -0.306     0.200
     0.202     0.127     0.200
     0.272    -0.191     0.200
     0.298    -0.155     0.200
     0.396     0.093     0.200
     0.037     0.024     0.200
     0.035    -0.265     0.200
     0.059    -0.559     0.200
     0.095    -0.061     0.200
     0.100    -0.049     0.200
     0.081     0.017     0.200
     0.173    -1.443     0.200
     0.207    -0.400     0.200
     0.218     0.112     0.200
     0.250    -0.270     0.200
     0.276    -0.251     0.200
     0.050     0.157     0.200
     0.015    -0.149     0.200
     0.109     0.053     0.200
     0.148    -0.047     0.200
     0.160     0.057     0.200
     0.205    -1.671     0.200
     0.159     0.135     0.200
     0.251    -0.209     0.200
     0.262    -0.418     0.200
     0.300    -0.194     0.200
     0.315    -0.239     0.200
     0.433    -0.286     0.200
     0.032     0.064     0.200
     0.044    -0.141     0.200
     0.099    -0.026     0.200
     0.033     0.104     0.200
     0.090     0.005     0.200
     0.160    -1.375     0.200
     0.195    -0.325     0.200
     0.253    -0.205     0.200
     0.246    -0.174     0.200
     0.273    -0.176     0.200
     0.046    -0.018     0.200
     0.061    -0.237     0.200
     0.029    -0.325     0.200
     0.103     0.049     0.200
     0.050    -0.994     0.200
     0.175    -1.036     0.200
     0.213    -0.273     0.200
     0.208    -1.773     0.200
     0.258    -0.177     0.200
     0.249    -0.078     0.200
     0.053    -0.395     0.200
     0.056    -0.001     0.200
     0.073     0.104     0.200
     0.104     0.023     0.200
     0.042    -0.904     0.200
     0.063     0.030     0.200
     0.220    -1.391     0.200
     0.225    -0.390     0.200
     0.249    -0.115     0.200
     0.260    -0.185     0.200
     0.291    -0.189     0.200
     0.054    -1.094     0.200
     0.054    -0.074     0.200
     0.024     0.117     0.200
     0.042    -0.995     0.200
     0.066    -0.041     0.200
     0.108    -0.102     0.200
     0.219    -0.397     0.200
     0.203     0.165     0.200
     0.255    -0.212     0.200
     0.265    -0.227     0.200
     0.293    -0.066     0.200
     0.390    -0.043     0.200
     0.084     0.002     0.200
     0.120    -1.072     0.200
     0.128     0.143     0.200
     0.155     0.104     0.200
     0.162    -0.361     0.200
     0.136    -0.022     0.200
     0.142    -0.753     0.200
     0.154    -0.300     0.200
     0.193    -0.352     0.200
     0.210    -0.142     0.200
     0.264    -0.472     0.200
     0.217     0.129     0.200
     0.295    -0.406     0.200
     0.298    -0.070     0.200
     0.287    -1.214     0.200
     0.285    -0.311     0.200
     0.050     0.019     0.200
     0.075    -0.007     0.200
     0.062    -0.475     0.200
     0.067    -1.038     0.200
     0.079     0.014     0.200
     0.126    -0.078     0.200
     0.220    -0.226     0.200
     0.222    -1.198     0.200
     0.228    -0.400     0.200
     0.208     0.089     0.200
     0.270    -0.364     0.200
     0.353    -0.121     0.200
     0.020     0.109     0.200
     0.104    -0.068     0.200
     0.066     0.153     0.200
     0.044    -0.529     0.200
     0.053    -0.031     0.200
     0.069    -0.052     0.200
     0.215    -0.386     0.200
     0.207     0.091     0.200
     0.267    -0.240     0.200
     0.293    -0.336     0.200
     0.393    -0.085     0.200
     0.047     0.007     0.200
     0.049    -0.849     0.200
     0.072     0.058     0.200
     0.105     0.006     0.200
     0.210    -1.025     0.200
     0.215    -0.316     0.200
     0.209     0.149     0.200
     0.249    -0.213     0.200
     0.259    -0.246     0.200
     0.286    -0.398     0.200
     0.383    -0.170     0.200
     0.014    -1.312     0.200
     0.059    -1.027     0.200
     0.057     0.164     0.200
     0.068     0.109     0.200
     0.103     0.021     0.200
     0.215    -0.385     0.200
     0.211    -1.272     0.200
     0.205     0.087     0.200
     0.264    -0.158     0.200
     0.273    -0.098     0.200
     0.298    -0.124     0.200
     0.029    -1.056     0.200
     0.035     0.093     0.200
     0.052     0.638     0.200
     0.069    -0.434     0.200
     0.087    -0.039     0.200
     0.108    -0.035     0.200
     0.225    -0.193     0.200
     0.235    -0.236     0.200
     0.205     0.265     0.200
     0.205    -1.323     0.200
     0.211    -0.450     0.200
     0.354    -0.387     0.200
     0.009    -0.480     0.200
     0.041    -0.337     0.200
     0.077    -1.668     0.200
     0.073     0.181     0.200
     0.103     0.058     0.200
     0.070     0.230     0.200
     0.205     0.130     0.200
     0.214    -0.798     0.200
     0.216    -0.270     0.200
     0.286    -0.074     0.200
     0.294    -0.099     0.200
     0.314    -0.172     0.200
     0.390    -0.664     0.200
     0.009    -1.607     0.200
     0.010     0.273     0.200
     0.060    -0.658     0.200
     0.087    -0.013     0.200
     0.088    -0.590     0.200
     0.109    -0.026     0.200
     0.180    -1.022     0.200
     0.182     0.053     0.200
     0.186    -0.485     0.200
     0.222    -0.149     0.200
     0.227    -0.233     0.200
     0.247    -0.389     0.200
     0.244     0.154     0.200
     0.331    -0.618     0.200
     0.036     0.063     0.200
     0.038    -1.509     0.200
     0.030    -0.927     0.200
     0.062    -0.561     0.200
     0.090    -0.026     0.200
     0.086     0.005     0.200
     0.191    -0.234     0.200
     0.194    -1.185     0.200
     0.199    -0.410     0.200
     0.224     0.203     0.200
     0.248    -0.184     0.200
     0.255    -0.238     0.200
     0.277    -0.352     0.200
     0.357    -0.645     0.200
     0.029    -1.284     0.200
     0.062     0.117     0.200
     0.035    -1.343     0.200
     0.078    -0.379     0.200
     0.057     0.201     0.200
     0.112     0.007     0.200
     0.118    -0.081     0.200
     0.186    -1.463     0.200
     0.194     0.120     0.200
     0.220     0.060     0.200
     0.228    -0.410     0.200
     0.257    -0.213     0.200
     0.268    -0.314     0.200
     0.299    -0.184     0.200
     0.050    -1.952     0.200
     0.050     0.104     0.200
     0.065    -0.210     0.200
     0.046    -0.901     0.200
     0.107     0.009     0.200
     0.105     0.019     0.200
     0.070     0.057     0.200
     0.175    -1.437     0.200
     0.211    -1.259     0.200
     0.207    -0.111     0.200
     0.215    -0.284     0.200
     0.207     0.133     0.200
     0.253    -0.266     0.200
     0.263    -0.206     0.200
     0.264     0.911     0.200
     0.030     0.112     0.200
     0.090    -1.309     0.200
     0.142    -1.572     0.200
     0.144    -0.041     0.200
     0.158    -0.397     0.200
     0.184     0.027     0.200
     0.188    -0.041     0.200
     0.119     0.046     0.200
     0.243    -1.543     0.200
     0.291    -0.038     0.200
     0.302    -0.263     0.200
     0.317    -0.040     0.200
     0.337    -0.064     0.200
     0.378    -0.080     0.200
     0.025    -0.558     0.200
     0.018    -0.511     0.200
     0.076    -0.074     0.200
     0.076     0.013     0.200
     0.054     0.033     0.200
     0.086    -0.362     0.200
     0.133    -0.049     0.200
     0.117    -0.023     0.200
     0.190     0.178     0.200
     0.220    -0.131     0.200
     0.278    -0.170     0.200
     0.289    -0.220     0.200
     0.412    -0.122     0.200
     0.048    -0.146     0.200
     0.158    -0.810     0.200
     0.159    -0.178     0.200
     0.114     0.100     0.200
     0.172    -0.396     0.200
     0.202    -0.074     0.200
     0.198    -0.044     0.200
     0.300     0.182     0.200
     0.312    -0.121     0.200
     0.336    -0.117     0.200
     0.356    -0.114     0.200
     0.465    -0.058     0.200
     0.055    -0.838     0.200
     0.036     0.006     0.200
     0.096    -1.428     0.200
     0.149    -0.561     0.200
     0.151    -0.103     0.200
     0.165    -0.182     0.200
     0.191     0.097     0.200
     0.194    -0.027     0.200
     0.114     0.124     0.200
     0.248    -1.758     0.200
     0.297     0.259     0.200
     0.308    -0.195     0.200
     0.323     0.009     0.200
     0.343    -0.189     0.200
     0.365     0.563     0.200
     0.385    -0.127     0.200
     0.116     0.011     0.200
     0.115    -0.349     0.200
     0.091    -0.974     0.200
     0.124    -0.016     0.200
     0.226    -0.163     0.200
     0.198    -0.036     0.200
     0.252    -0.227     0.200
     0.313    -0.106     0.200
     0.300    -0.268     0.200
     0.049    -1.159     0.200
     0.049     0.107     0.200
     0.026    -0.575     0.200
     0.047    -0.431     0.200
     0.106     0.082     0.200
     0.105     0.006     0.200
     0.071     0.006     0.200
     0.175    -1.404     0.200
     0.210    -0.965     0.200
     0.207    -0.319     0.200
     0.214    -0.330     0.200
     0.208     0.108     0.200
     0.252    -0.200     0.200
     0.288    -0.172     0.200
     0.048     0.080     0.200
     0.029    -0.853     0.200
     0.048    -0.695     0.200
     0.103     0.022     0.200
     0.071     0.022     0.200
     0.106     0.042     0.200
     0.177    -1.425     0.200
     0.210    -1.151     0.200
     0.215    -0.321     0.200
     0.207    -0.309     0.200
     0.249    -0.073     0.200
     0.259    -0.321     0.200
     0.208     0.106     0.200
     0.018    -0.219     0.200
     0.074    -0.089     0.200
     0.079    -0.708     0.200
     0.092     0.008     0.200
     0.055    -0.852     0.200
     0.083    -0.018     0.200
     0.144    -0.140     0.200
     0.148    -1.106     0.200
     0.203    -2.045     0.200
     0.205    -0.302     0.200
     0.216     0.255     0.200
     0.297    -0.054     0.200
     0.291    -0.059     0.200
     0.066    -1.246     0.200
     0.124    -0.695     0.200
     0.149     0.114     0.200
     0.135    -0.767     0.200
     0.153    -0.167     0.200
     0.165    -0.219     0.200
     0.143     0.045     0.200
     0.211    -0.405     0.200
     0.225    -0.227     0.200
     0.229    -0.452     0.200
     0.227    -0.524     0.200
     0.022    -1.372     0.200
     0.040    -0.687     0.200
     0.091     0.408     0.200
     0.091    -1.074     0.200
     0.110     0.043     0.200
     0.152     0.099     0.200
     0.164    -1.584     0.200
     0.212    -0.232     0.200
     0.224    -0.289     0.200
     0.222    -1.086     0.200
     0.199     0.124     0.200
     0.289    -0.047     0.200
     0.299    -0.088     0.200
     0.307    -0.141     0.200
     0.328    -0.162     0.200
     0.401    -1.129     0.200
     0.057    -0.620     0.200
     0.048    -0.475     0.200
     0.065    -1.043     0.200
     0.083     0.133     0.200
     0.107     0.125     0.200
     0.182    -1.210     0.200
     0.205    -0.476     0.200
     0.211    -0.287     0.200
     0.219     0.066     0.200
     0.229    -0.106     0.200
     0.250     0.265     0.200
     0.239    -0.110     0.200
     0.268    -0.326     0.200
     0.356    -1.172     0.200
     0.058    -1.228     0.200
     0.099    -0.878     0.200
     0.167     0.706     0.200
     0.111     0.182     0.200
     0.192    -0.056     0.200
     0.197    -0.067     0.200
     0.251    -1.931     0.200
     0.300    -0.446     0.200
     0.311    -0.308     0.200
     0.324    -0.095     0.200
     0.345    -0.043     0.200
     0.387    -0.152     0.200
     0.046     0.044     0.200
     0.022    -0.981     0.200
     0.055     0.195     0.200
     0.110    -0.103     0.200
     0.104    -0.653     0.200
     0.120     0.126     0.200
     0.193    -0.130     0.200
     0.200    -0.306     0.200
     0.198    -0.245     0.200
     0.197    -0.462     0.200
     0.226    -0.228     0.200
     0.249    -0.066     0.200
     0.036    -0.839     0.200
     0.063     0.084     0.200
     0.108    -0.003     0.200
     0.175    -1.141     0.200
     0.211     0.050     0.200
     0.220    -0.332     0.200
     0.200     0.203     0.200
     0.276    -0.249     0.200
     0.383    -0.786     0.200
     0.046    -0.709     0.200
     0.050    -1.020     0.200
     0.073     0.066     0.200
     0.185    -0.880     0.200
     0.212    -0.304     0.200
     0.205    -0.180     0.200
     0.208    -0.826     0.200
     0.210     0.127     0.200
     0.259    -0.258     0.200
     0.250    -0.200     0.200
     0.285    -0.291     0.200
     0.369    -0.610     0.200
     0.385    -0.229     0.200
     0.007    -0.284     0.200
     0.037    -1.402     0.200
     0.065    -0.003     0.200
     0.069     0.056     0.200
     0.075    -1.129     0.200
     0.166    -0.627     0.200
     0.208     0.253     0.200
     0.202     0.250     0.200
     0.215    -1.456     0.200
     0.218    -0.182     0.200
     0.275    -0.215     0.200
     0.284    -0.238     0.200
     0.307    -0.336     0.200
     0.410    -0.192     0.200
     0.224     0.243     0.200
     0.291    -0.224     0.200
     0.296    -0.204     0.200
     0.427    -0.223     0.200
     0.019    -0.767     0.200
     0.026    -0.013     0.200
     0.055     0.003     0.200
     0.082    -0.553     0.200
     0.081    -0.072     0.200
     0.089     0.349     0.200
     0.167    -0.565     0.200
     0.189     0.205     0.200
     0.220    -0.389     0.200
     0.231    -0.289     0.200
     0.285    -0.226     0.200
     0.295    -0.241     0.200
     0.321    -0.140     0.200
     0.419     0.065     0.200
     0.033    -0.679     0.200
     0.030    -0.043     0.200
     0.036    -0.554     0.200
     0.070     0.082     0.200
     0.095    -0.149     0.200
     0.156    -0.870     0.200
     0.191    -0.415     0.200
     0.245    -0.323     0.200
     0.232     0.180     0.200
     0.270    -0.187     0.200
     0.056     0.098     0.200
     0.061     0.254     0.200
     0.026    -0.468     0.200
     0.098     0.079     0.200
     0.137    -0.868     0.200
     0.137     0.173     0.200
     0.148    -0.427     0.200
     0.183    -0.547     0.200
     0.176    -0.326     0.200
     0.186    -0.400     0.200
     0.248    -0.775     0.200
     0.234     0.052     0.200
     0.275    -0.085     0.200
     0.291    -0.053     0.200
     0.020    -1.149     0.200
     0.059    -0.240     0.200
     0.059    -0.450     0.200
     0.063     0.001     0.200
     0.176    -0.132     0.200
     0.172    -0.071     0.200
     0.180    -0.601     0.200
     0.201     0.127     0.200
     0.211    -0.106     0.200
     0.216    -1.271     0.200
     0.261    -0.226     0.200
     0.298    -0.339     0.200
     0.084    -0.031     0.200
     0.036    -0.551     0.200
     0.089    -0.491     0.200
     0.101    -0.009     0.200
     0.131    -1.135     0.200
     0.117     0.106     0.200
     0.185    -0.118     0.200
     0.192    -1.316     0.200
     0.194    -0.285     0.200
     0.265    -0.269     0.200
     0.232     0.340     0.200
     0.302    -0.215     0.200
     0.315    -0.262     0.200
     0.375    -0.295     0.200
     0.044     0.084     0.200
     0.031    -0.720     0.200
     0.075     0.026     0.200
     0.177    -0.092     0.200
     0.174    -1.298     0.200
     0.177     0.053     0.200
     0.187    -0.661     0.200
     0.207    -1.249     0.200
     0.204    -0.411     0.200
     0.247    -0.461     0.200
     0.212     0.078     0.200
     0.258     0.925     0.200
     0.282    -0.541     0.200
     0.366    -0.308     0.200
     0.363    -0.317     0.200
     0.037    -0.449     0.200
     0.071    -0.388     0.200
     0.080     0.109     0.200
     0.085    -0.712     0.200
     0.105    -0.001     0.200
     0.127    -1.047     0.200
     0.125    -0.912     0.200
     0.116     0.116     0.200
     0.179    -0.080     0.200
     0.175    -0.638     0.200
     0.188    -0.306     0.200
     0.187    -1.318     0.200
     0.259    -0.038     0.200
     0.236     0.101     0.200
     0.299    -0.284     0.200
     0.310    -0.366     0.200
     0.369    -0.414     0.200
     0.028    -0.025     0.200
     0.050    -0.408     0.200
     0.068    -0.781     0.200
     0.087    -0.024     0.200
     0.168    -0.122     0.200
     0.181    -1.406     0.200
     0.203    -1.390     0.200
     0.209    -0.346     0.200
     0.202    -0.405     0.200
     0.190     0.006     0.200
     0.248    -0.125     0.200
     0.265    -0.410     0.200
     0.350    -0.373     0.200
     0.353    -0.542     0.200
     0.028    -0.493     0.200
     0.032    -0.098     0.200
     0.054    -0.398     0.200
     0.049    -0.380     0.200
     0.068    -0.471     0.200
     0.104    -0.053     0.200
     0.087    -0.064     0.200
     0.167    -0.161     0.200
     0.180    -0.977     0.200
     0.208    -0.378     0.200
     0.202    -0.230     0.200
     0.208    -0.480     0.200
     0.189    -0.002     0.200
     0.201    -0.237     0.200
     0.265    -0.242     0.200
     0.350    -0.483     0.200
     0.013    -0.342     0.200
     0.075    -0.139     0.200
     0.076    -0.707     0.200
     0.078    -0.803     0.200
     0.049    -0.035     0.200
     0.078    -0.010     0.200
     0.154    -1.160     0.200
     0.142     0.173     0.200
     0.147    -0.467     0.200
     0.198    -0.719     0.200
     0.210    -0.350     0.200
     0.313    -0.366     0.200
     0.108    -0.709     0.200
     0.065    -0.598     0.200
     0.049     0.007     0.200
     0.114    -0.118     0.200
     0.095    -0.839     0.200
     0.184    -0.080     0.200
     0.247    -0.161     0.200
     0.251    -0.169     0.200
     0.248     0.109     0.200
     0.255    -1.318     0.200
     0.285    -0.188     0.200
     0.291    -0.245     0.200
     0.323    -0.308     0.200
     0.325    -1.363     0.200
     0.423    -0.291     0.200
     0.041     0.044     0.200
     0.044    -0.687     0.200
     0.083    -0.048     0.200
     0.026    -0.453     0.200
     0.063    -0.305     0.200
     0.165    -0.069     0.200
     0.090    -0.091     0.200
     0.153    -1.519     0.200
     0.190    -0.887     0.200
     0.194    -0.494     0.200
     0.194    -0.375     0.200
     0.185    -0.109     0.200
     0.168    -0.389     0.200
     0.247    -0.102     0.200
     0.281    -0.198     0.200
     0.357    -0.790     0.200
     0.023    -0.518     0.200
     0.024     0.281     0.200
     0.046    -0.613     0.200
     0.072    -0.779     0.200
     0.094    -0.062     0.200
     0.094    -0.033     0.200
     0.169    -0.825     0.200
     0.179    -0.186     0.200
     0.192    -0.887     0.200
     0.198    -0.461     0.200
     0.011     0.052     0.200
     0.084    -0.622     0.200
     0.171    -1.583     0.200
     0.187    -0.849     0.200
     0.230    -0.029     0.200
     0.567    -0.040     0.200
     0.916    -1.611     0.200
     0.779     1.491     0.200
     0.535     0.534     0.200
     0.688    -0.071     0.200
     0.944    -0.478     0.200
     0.617    -0.031     0.200
     0.773     0.256     0.200
     0.825    -0.387     0.200
     0.997     0.466     0.200
     0.442    -0.348     0.200
     0.697    -0.681     0.200
     0.626    -0.395     0.200
     0.609    -0.982     0.200
     0.950     0.067     0.200
     0.610    -0.271     0.200
     0.547    -0.566     0.200
     0.845    -0.610     0.200
     0.486    -0.111     0.200
     0.677     0.403     0.200
     0.850    -0.818     0.200
     0.850    -0.338     0.200
     0.209    -0.354     0.200
     0.269    -0.258     0.200
     0.860    -0.819     0.200
     0.677    -1.070     0.200
     0.388    -0.223     0.200
     0.956    -0.436     0.200
     0.257    -0.834     0.200
     0.853     0.180     0.200
     0.196    -0.262     0.200
     0.177    -0.043     0.200
     0.465    -0.275     0.200
     0.608    -0.479     0.200
     0.668    -0.419     0.200
     0.685    -0.546     0.200
     0.521    -0.965     0.200
     0.624     0.190     0.200
     0.885    -0.381     0.200
     0.368    -0.630     0.200
     0.525     0.291     0.200
     0.408    -0.985     0.200
     0.510     0.723     0.200
     0.675    -0.317     0.200
     0.627     0.020     0.200
     0.605     0.991     0.200
     0.577     0.267     0.200
     0.643    -0.934     0.200
     0.327    -0.074     0.200
     0.653    -0.345     0.200
     0.530    -1.335     0.200
     0.658     0.156     0.200
     0.783     0.286     0.200
     0.676    -0.223     0.200
     0.552     0.642     0.200
     0.575    -0.410     0.200
     0.649     1.224     0.200
     0.957    -0.677     0.200
     0.476    -1.477     0.200
     0.241    -0.477     0.200
     0.602    -0.338     0.200
     0.811     0.044     0.200
     0.912    -0.212     0.200
     0.427    -0.493     0.200
     0.851     0.359     0.200
     0.956    -1.324     0.200
     0.958     0.869     0.200
     0.718     1.032     0.200
     0.839     0.529     0.200
     0.210     0.107     0.200
     0.887    -0.226     0.200
     0.943     0.591     0.200
     0.604    -0.811     0.200
     0.673     1.014     0.200
     0.720    -1.005     0.200
     0.969     0.123     0.200
     0.961     0.769     0.200
     0.641    -0.575     0.200
     0.655    -0.268     0.200
     0.957    -0.196     0.200
     0.802     0.125     0.200
     0.325    -0.173     0.200
     0.484    -0.171     0.200
     0.924     0.831     0.200
     0.949     1.763     0.200
     0.949     1.576     0.200
     0.606    -0.683     0.200
     0.707     0.394     0.200
     0.562     0.001     0.200
     0.655    -0.454     0.200
     0.804    -0.504     0.200
     0.979     0.200     0.200
     0.219    -0.063     0.200
     0.240     0.097     0.200
     0.317    -0.049     0.200
     0.338    -0.029     0.200
     0.377    -0.233     0.200
     0.576    -0.135     0.200
     0.689    -0.076     0.200
     0.689     0.226     0.200
     0.889     0.515     0.200
     0.235    -0.020     0.200
     0.261     0.138     0.200
     0.291    -0.082     0.200
     0.363    -0.005     0.200
     0.385    -0.126     0.200
     0.480    -0.210     0.200
     0.485    -0.013     0.200
     0.618     0.007     0.200
     0.626     0.189     0.200
     0.631     0.269     0.200
     0.639     0.458     0.200
     0.648    -0.002     0.200
     0.811     0.122     0.200
     0.889     0.286     0.200
     0.904     0.062     0.200
     0.104    -0.103     0.200
     0.112     0.079     0.200
     0.248     0.067     0.200
     0.392     0.262     0.200
     0.419     0.029     0.200
     0.468    -0.324     0.200
     0.495     0.061     0.200
     0.494    -0.069     0.200
     0.596     0.158     0.200
     0.609     0.137     0.200
     0.630    -0.091     0.200
     0.669    -0.132     0.200
     0.804     0.011     0.200
     0.833     0.028     0.200
     0.832     0.266     0.200
     0.945     0.283     0.200
     0.468    -0.887     0.200
     0.570     1.108     0.200
     0.103    -0.049     0.200
     0.117     0.055     0.200
     0.253     0.079     0.200
     0.420     0.216     0.200
     0.474    -0.327     0.200
     0.494     0.240     0.200
     0.495     0.208     0.200
     0.599    -0.018     0.200
     0.614     0.158     0.200
     0.635     0.416     0.200
     0.670     0.102     0.200
     0.205     0.003     0.200
     0.205     0.023     0.200
     0.280    -0.113     0.200
     0.330     0.147     0.200
     0.329     0.214     0.200
     0.384     0.071     0.200
     0.513     0.124     0.200
     0.539     0.204     0.200
     0.554     0.055     0.200
     0.582    -0.022     0.200
     0.653     0.019     0.200
     0.685     0.008     0.200
     0.712     0.133     0.200
     0.726     0.150     0.200
     0.839    -0.320     0.200
     0.161     0.264     0.200
     0.181     0.323     0.200
     0.242     0.214     0.200
     0.305    -0.063     0.200
     0.306    -0.106     0.200
     0.351     0.120     0.200
     0.401     0.195     0.200
     0.424     0.227     0.200
     0.460     0.129     0.200
     0.636     0.088     0.200
     0.651     0.332     0.200
     0.783     0.607     0.200
     0.853     0.737     0.200
     0.114     0.060     0.200
     0.180     0.130     0.200
     0.199    -0.071     0.200
     0.266     0.181     0.200
     0.492     0.094     0.200
     0.554    -0.147     0.200
     0.702    -0.178     0.200
     0.715    -0.187     0.200
     0.949     0.304     0.200
     0.998     0.092     0.200
     0.071     0.292     0.200
     0.235    -0.079     0.200
     0.325    -0.131     0.200
     0.404     0.303     0.200
     0.470     0.178     0.200
     0.611     0.090     0.200
     0.647    -0.030     0.200
     0.676    -0.239     0.200
     0.827    -0.006     0.200
     0.863     0.068     0.200
     0.882     0.162     0.200
     0.984     0.251     0.200
     0.248    -0.022     0.200
     0.266     0.400     0.200
     0.358     0.005     0.200
     0.465     0.127     0.200
     0.717    -0.062     0.200
     0.864    -0.199     0.200
     0.879    -0.227     0.200
     0.052     0.330     0.200
     0.200    -0.013     0.200
     0.340     0.006     0.200
     0.339    -0.228     0.200
     0.377    -0.017     0.200
     0.766     0.444     0.200
     0.915     0.405     0.200
     0.206     0.137     0.200
     0.224    -0.039     0.200
     0.268     0.141     0.200
     0.307    -0.115     0.200
     0.329     0.263     0.200
     0.366     0.129     0.200
     0.531    -0.023     0.200
     0.560    -0.105     0.200
     0.639     0.177     0.200
     0.700     0.062     0.200
     0.904     0.234     0.200
     0.164     0.201     0.200
     0.180     0.121     0.200
     0.209     0.188     0.200
     0.356    -0.066     0.200
     0.441     0.335     0.200
     0.623     0.430     0.200
     0.686     0.164     0.200
     0.692     0.228     0.200
     0.720    -0.493     0.200
     0.872     0.627     0.200
     0.287     0.099     0.200
     0.336     0.084     0.200
     0.361    -0.143     0.200
     0.362    -0.033     0.200
     0.409     0.065     0.200
     0.461     0.066     0.200
     0.575     0.150     0.200
     0.600    -0.182     0.200
     0.624     0.135     0.200
     0.623     0.123     0.200
     0.673    -0.217     0.200
     0.763     0.083     0.200
     0.780     0.075     0.200
     0.817     0.068     0.200
     0.853     0.176     0.200
     0.881     0.225     0.200
     0.947     0.084     0.200
     0.197    -0.224     0.200
     0.150     0.425     0.200
     0.231     0.167     0.200
     0.308    -0.269     0.200
     0.440     0.108     0.200
     0.676    -0.420     0.200
     0.830     0.146     0.200
     0.824    -0.274     0.200
     0.176     0.023     0.200
     0.159     0.226     0.200
     0.220     0.184     0.200
     0.288    -0.185     0.200
     0.429    -0.176     0.200
     0.660    -0.240     0.200
     0.810    -0.338     0.200
     0.809    -0.001     0.200
     0.378    -0.080     0.200
     0.192     0.040     0.200
     0.207     0.266     0.200
     0.350     0.336     0.200
     0.351     0.217     0.200
     0.430     0.027     0.200
     0.624     0.342     0.200
     0.649     0.447     0.200
     0.693     0.186     0.200
     0.747    -0.485     0.200
     0.415     0.094     0.200
     0.420    -0.149     0.200
     0.457     0.309     0.200
     0.556    -0.132     0.200
     0.581     0.117     0.200
     0.631    -0.303     0.200
     0.737     0.216     0.200
     0.841    -0.187     0.200
     0.309     0.121     0.200
     0.317    -0.088     0.200
     0.328    -0.069     0.200
     0.355     0.134     0.200
     0.408     0.107     0.200
     0.478     0.134     0.200
     0.578     0.361     0.200
     0.677    -0.111     0.200
     0.773     0.588     0.200
     0.106     0.110     0.200
     0.163     0.209     0.200
     0.259     0.081     0.200
     0.337     0.270     0.200
     0.352    -0.066     0.200
     0.540     0.179     0.200
     0.598     0.410     0.200
     0.625     0.012     0.200
     0.652     0.445     0.200
     0.881    -0.028     0.200
     0.136     0.122     0.200
     0.246     0.128     0.200
     0.286     0.069     0.200
     0.397     0.047     0.200
     0.461    -0.087     0.200
     0.531     0.241     0.200
     0.536     0.465     0.200
     0.640     0.104     0.200
     0.639     0.234     0.200
     0.666     0.376     0.200
     0.711     0.449     0.200
     0.858     0.061     0.200
     0.205     0.076     0.200
     0.404     0.170     0.200
     0.402     0.103     0.200
     0.410    -0.169     0.200
     0.474    -0.060     0.200
     0.570     0.038     0.200
     0.672     0.152     0.200
     0.697     0.379     0.200
     0.727    -0.045     0.200
     0.931     0.231     0.200
     0.295     0.022     0.200
     0.299    -0.017     0.200
     0.368    -0.181     0.200
     0.395     0.115     0.200
     0.471     0.076     0.200
     0.500     0.244     0.200
     0.575     0.187     0.200
     0.575    -0.370     0.200
     0.666     0.181     0.200
     0.774     0.008     0.200
     0.831     0.519     0.200
     0.285     0.005     0.200
     0.290     0.011     0.200
     0.331     0.197     0.200
     0.355    -0.022     0.200
     0.374     0.135     0.200
     0.453     0.183     0.200
     0.478     0.168     0.200
     0.524    -0.255     0.200
     0.555     0.076     0.200
     0.557    -0.030     0.200
     0.585    -0.012     0.200
     0.645     0.121     0.200
     0.643     0.178     0.200
     0.709     0.253     0.200
     0.737     0.045     0.200
     0.785     0.032     0.200
     0.836    -0.056     0.200
     0.809     0.254     0.200
     0.810     0.268     0.200
     0.932     0.349     0.200
     0.277     0.073     0.200
     0.285     0.061     0.200
     0.327     0.162     0.200
     0.347    -0.049     0.200
     0.367     0.258     0.200
     0.449     0.257     0.200
     0.471     0.346     0.200
     0.517    -0.168     0.200
     0.585    -0.047     0.200
     0.639    -0.070     0.200
     0.700     0.387     0.200
     0.729     0.234     0.200
     0.827    -0.417     0.200
     0.178     0.035     0.200
     0.169     0.304     0.200
     0.281    -0.152     0.200
     0.438    -0.225     0.200
     0.652    -0.231     0.200
     0.792    -0.214     0.200
     0.804    -0.196     0.200
     0.800    -0.221     0.200
     0.047    -0.190     0.200
     0.078     0.249     0.200
     0.161    -0.059     0.200
     0.251     0.034     0.200
     0.299     0.144     0.200
     0.317    -0.027     0.200
     0.458     0.483     0.200
     0.473     0.206     0.200
     0.517     0.453     0.200
     0.569     0.294     0.200
     0.148     0.321     0.200
     0.290    -0.137     0.200
     0.295    -0.034     0.200
     0.290     0.056     0.200
     0.579     0.256     0.200
     0.596     0.154     0.200
     0.739    -0.185     0.200
     0.745    -0.126     0.200
     0.235     0.507     0.200
     0.295    -0.026     0.200
     0.301     0.016     0.200
     0.419    -0.008     0.200
     0.444    -0.172     0.200
     0.479    -0.011     0.200
     0.541    -0.522     0.200
     0.611     0.513     0.200
     0.670     0.282     0.200
     0.758     0.256     0.200
     0.809    -0.422     0.200
     0.942     0.055     0.200
     0.125     0.289     0.200
     0.222     0.159     0.200
     0.287    -0.079     0.200
     0.291     0.271     0.200
     0.308     0.207     0.200
     0.322     0.257     0.200
     0.346     0.032     0.200
     0.353     0.251     0.200
     0.426     0.234     0.200
     0.713    -0.101     0.200
     0.801     0.289     0.200
     0.841     0.474     0.200
     0.192    -0.010     0.200
     0.236     0.207     0.200
     0.285    -0.069     0.200
     0.311     0.074     0.200
     0.347     0.176     0.200
     0.362     0.024     0.200
     0.503     0.419     0.200
     0.606     0.381     0.200
     0.680     0.565     0.200
     0.076     0.367     0.200
     0.197     0.004     0.200
     0.333     0.012     0.200
     0.401    -0.055     0.200
     0.452     0.190     0.200
     0.543     0.031     0.200
     0.550    -0.009     0.200
     0.607     0.057     0.200
     0.662    -0.050     0.200
     0.812     0.228     0.200
     0.811     0.193     0.200
     0.822     0.202     0.200
     0.291     0.101     0.200
     0.320     0.168     0.200
     0.383     0.076     0.200
     0.397     0.047     0.200
     0.443     0.182     0.200
     0.520     0.551     0.200
     0.543    -0.231     0.200
     0.538    -0.046     0.200
     0.547     0.316     0.200
     0.605     0.268     0.200
     0.700    -0.017     0.200
     0.715     0.358     0.200
     0.733     0.042     0.200
     0.114     0.171     0.200
     0.152     0.258     0.200
     0.222    -0.001     0.200
     0.326     0.194     0.200
     0.339     0.071     0.200
     0.377     0.127     0.200
     0.527     0.309     0.200
     0.612     0.427     0.200
     0.711     0.006     0.200
     0.871     0.255     0.200
     0.775     0.199     0.200
     0.580     0.291     0.200
     0.991    -0.462     0.200
     0.183    -0.147     0.200
     0.267    -0.077     0.200
     0.284     0.049     0.200
     0.318     0.107     0.200
     0.357    -0.343     0.200
     0.779    -0.159     0.200
     0.783    -0.400     0.200
     0.891     0.589     0.200
     0.936     0.231     0.200
     0.115    -0.090     0.200
     0.235     0.086     0.200
     0.252    -0.031     0.200
     0.421    -0.114     0.200
     0.472     0.353     0.200
     0.497    -0.034     0.200
     0.496     0.338     0.200
     0.599     0.004     0.200
     0.613     0.556     0.200
     0.634     0.314     0.200
     0.671     0.002     0.200
     0.882    -0.077     0.200
     0.942    -0.379     0.200
     0.180     0.418     0.200
     0.309    -0.090     0.200
     0.282     0.339     0.200
     0.321     0.080     0.200
     0.322     0.067     0.200
     0.335     0.089     0.200
     0.380     0.451     0.200
     0.422     0.160     0.200
     0.488    -0.224     0.200
     0.473     0.064     0.200
     0.489     0.313     0.200
     0.572     0.217     0.200
     0.912    -0.097     0.200
     0.219    -0.126     0.200
     0.300     0.192     0.200
     0.368    -0.242     0.200
     0.364     0.039     0.200
     0.442     0.111     0.200
     0.503     0.339     0.200
     0.539     0.030     0.200
     0.584    -0.017     0.200
     0.737    -0.081     0.200
     0.813     0.068     0.200
     0.792    -0.411     0.200
     0.154     0.165     0.200
     0.192     0.273     0.200
     0.247     0.208     0.200
     0.325     0.209     0.200
     0.325    -0.327     0.200
     0.684     0.300     0.200
     0.702     0.543     0.200
     0.745    -0.319     0.200
     0.749     0.103     0.200
     0.803     0.239     0.200
     0.834     0.441     0.200
     0.899     0.073     0.200
     0.965     0.111     0.200
     0.998     0.400     0.200
     0.147     0.262     0.200
     0.155     0.127     0.200
     0.228    -0.115     0.200
     0.402     0.137     0.200
     0.408    -0.440     0.200
     0.448    -0.265     0.200
     0.502    -0.149     0.200
     0.593     0.524     0.200
     0.660     0.309     0.200
     0.681     0.232     0.200
     0.740     0.472     0.200
     0.772     0.238     0.200
     0.784     0.421     0.200
     0.799    -0.130     0.200
     0.807     0.402     0.200
     0.817     0.370     0.200
     0.882     0.521     0.200
     0.937     0.259     0.200
     0.072     0.163     0.200
     0.233     0.344     0.200
     0.277     0.014     0.200
     0.351     0.255     0.200
     0.372     0.237     0.200
     0.396     0.288     0.200
     0.418     0.446     0.200
     0.455     0.081     0.200
     0.470    -0.159     0.200
     0.539    -0.156     0.200
     0.545     0.071     0.200
     0.603     0.146     0.200
     0.686    -0.095     0.200
     0.736     0.606     0.200
     0.765     0.027     0.200
     0.777     0.203     0.200
     0.870    -0.213     0.200
     0.919     0.710     0.200
     0.977    -0.519     0.200
     0.090     0.099     0.200
     0.194    -0.202     0.200
     0.290     0.121     0.200
     0.301    -0.009     0.200
     0.458    -0.147     0.200
     0.511     0.199     0.200
     0.679    -0.620     0.200
     0.697    -0.164     0.200
     0.723     0.255     0.200
     0.105     0.126     0.200
     0.176     0.150     0.200
     0.278     0.248     0.200
     0.320    -0.074     0.200
     0.450     0.064     0.200
     0.493     0.150     0.200
     0.679    -0.147     0.200
     0.700     0.090     0.200
     0.717    -0.063     0.200
     0.835    -0.293     0.200
     0.160     0.158     0.200
     0.269    -0.148     0.200
     0.255     0.668     0.200
     0.430     0.109     0.200
     0.469     0.486     0.200
     0.467     0.480     0.200
     0.476     0.524     0.200
     0.705    -0.494     0.200
     0.997    -0.157     0.200
     0.117    -0.138     0.200
     0.162     0.198     0.200
     0.182    -0.127     0.200
     0.270     0.218     0.200
     0.334    -0.542     0.200
     0.444    -0.010     0.200
     0.479     0.187     0.200
     0.665     0.496     0.200
     0.686    -0.466     0.200
     0.694     0.375     0.200
     0.701    -0.182     0.200
     0.711     0.245     0.200
     0.751    -0.705     0.200
     0.821     0.084     0.200
     0.998     0.627     0.200
     0.173     0.420     0.200
     0.309    -0.261     0.200
     0.305     0.171     0.200
     0.288     0.424     0.200
     0.309     0.388     0.200
     0.314     0.368     0.200
     0.377     0.384     0.200
     0.404     0.309     0.200
     0.458     0.286     0.200
     0.479    -0.446     0.200
     0.489     0.653     0.200
     0.559     0.236     0.200
     0.648     0.651     0.200
     0.678    -0.227     0.200
     0.688    -0.152     0.200
     0.658     0.301     0.200
     0.707     0.394     0.200
     0.800    -0.305     0.200
     0.813    -0.082     0.200
     0.827    -0.168     0.200
     0.870    -0.110     0.200
     0.895    -0.006     0.200
     0.649     0.920     0.200
     0.816    -0.426     0.200
     0.860     0.112     0.200
     0.120    -0.382     0.200
     0.157     0.225     0.200
     0.179    -0.086     0.200
     0.269     0.468     0.200
     0.475     0.789     0.200
     0.546     0.161     0.200
     0.694    -0.000     0.200
     0.699    -0.001     0.200
     0.707    -0.331     0.200
     0.753    -0.133     0.200
     0.817    -0.234     0.200
     0.963    -0.311     0.200
     0.101     0.068     0.200
     0.221     0.025     0.200
     0.523    -0.110     0.200
     0.530     0.155     0.200
     0.535     0.161     0.200
     0.559    -0.108     0.200
     0.587     0.657     0.200
     0.730     0.827     0.200
     0.755     0.161     0.200
     0.801     0.660     0.200
     0.856     0.081     0.200
     0.905     0.521     0.200
     0.117    -0.157     0.200
     0.179     0.421     0.200
     0.256     0.137     0.200
     0.338     0.522     0.200
     0.390     0.733     0.200
     0.424     0.184     0.200
     0.413     0.627     0.200
     0.869    -0.420     0.200
     0.881    -0.313     0.200
     0.170     0.241     0.200
     0.275     0.220     0.200
     0.262     0.586     0.200
     0.359     0.116     0.200
     0.437     0.160     0.200
     0.461     0.146     0.200
     0.470     0.498     0.200
     0.478     0.095     0.200
     0.477     0.280     0.200
     0.484     0.547     0.200
     0.537     0.160     0.200
     0.701    -0.251     0.200
     0.687     0.573     0.200
     0.956     0.622     0.200
     0.995    -0.218     0.200
     0.207    -0.333     0.200
     0.234     0.342     0.200
     0.323     0.286     0.200
     0.381     0.359     0.200
     0.441     0.376     0.200
     0.523    -0.040     0.200
     0.534    -0.103     0.200
     0.541     0.137     0.200
     0.693     0.083     0.200
     0.797    -0.123     0.200
     0.821     0.127     0.200
     0.847     0.373     0.200
     0.923     0.491     0.200
     0.033     0.494     0.200
     0.154     0.483     0.200
     0.320    -0.411     0.200
     0.370    -0.049     0.200
     0.387    -0.087     0.200
     0.476     0.167     0.200
     0.461     0.308     0.200
     0.763    -0.681     0.200
     0.172     0.257     0.200
     0.279    -0.212     0.200
     0.300     0.236     0.200
     0.295    -0.326     0.200
     0.339     0.009     0.200
     0.382     0.038     0.200
     0.440     0.239     0.200
     0.499     0.235     0.200
     0.546     0.538     0.200
     0.625    -0.273     0.200
     0.666    -0.497     0.200
     0.656     0.373     0.200
     0.709     0.754     0.200
     0.821    -0.597     0.200
     0.816     0.289     0.200
     0.866    -0.119     0.200
     0.869     0.026     0.200
     0.095     0.144     0.200
     0.211     0.151     0.200
     0.286    -0.531     0.200
     0.349    -0.189     0.200
     0.368    -0.301     0.200
     0.510     0.104     0.200
     0.526    -0.245     0.200
     0.539    -0.447     0.200
     0.533     0.008     0.200
     0.587    -0.214     0.200
     0.628     0.045     0.200
     0.674     0.036     0.200
     0.157     0.038     0.200
     0.158     0.564     0.200
     0.237     0.676     0.200
     0.297     0.155     0.200
     0.364    -0.062     0.200
     0.361     0.264     0.200
     0.456     0.095     0.200
     0.494    -0.037     0.200
     0.467     0.210     0.200
     0.488    -0.112     0.200
     0.711    -0.552     0.200
     0.734    -0.371     0.200
     0.096     0.189     0.200
     0.113     0.243     0.200
     0.142    -0.384     0.200
     0.212     0.971     0.200
     0.258     0.122     0.200
     0.327    -0.130     0.200
     0.420    -0.458     0.200
     0.431     0.672     0.200
     0.438    -0.190     0.200
     0.480    -0.342     0.200
     0.671    -0.149     0.200
     0.738    -0.281     0.200
     0.037     0.165     0.200
     0.280     0.131     0.200
     0.390     0.420     0.200
     0.422     0.536     0.200
     0.551     0.031     0.200
     0.560    -0.349     0.200
     0.584     0.302     0.200
     0.665    -0.396     0.200
     0.825    -0.029     0.200
     0.826    -0.399     0.200
     0.872     0.317     0.200
     0.917     0.046     0.200
     0.973    -0.064     0.200
     0.187     0.157     0.200
     0.226     0.210     0.200
     0.256    -0.016     0.200
     0.333     0.052     0.200
     0.401    -0.347     0.200
     0.501     0.073     0.200
     0.554    -0.295     0.200
     0.680    -0.232     0.200
     0.704     0.275     0.200
     0.826     0.016     0.200
     0.832     0.611     0.200
     0.851     0.461     0.200
     0.861    -0.113     0.200
     0.876     0.235     0.200
     0.893    -0.109     0.200
     0.037     0.034     0.200
     0.214     0.096     0.200
     0.537    -0.096     0.200
     0.591    -0.046     0.200
     0.691     0.064     0.200
     0.813     0.340     0.200
     0.834     0.105     0.200
     0.910     0.026     0.200
     0.968     0.149     0.200
     0.098    -0.080     0.200
     0.144     0.708     0.200
     0.250     0.106     0.200
     0.314     0.058     0.200
     0.410     0.243     0.200
     0.451     0.393     0.200
     0.447     0.074     0.200
     0.449     0.313     0.200
     0.547    -0.277     0.200
     0.664     0.364     0.200
     0.151     0.611     0.200
     0.203     0.134     0.200
     0.318     0.109     0.200
     0.314     0.319     0.200
     0.318     0.062     0.200
     0.412     0.462     0.200
     0.505    -0.552     0.200
     0.589     0.385     0.200
     0.610    -0.363     0.200
     0.730     0.178     0.200
     0.739     0.205     0.200
     0.788     0.069     0.200
     0.783    -0.491     0.200
     0.825     0.227     0.200
     0.850    -0.916     0.200
     0.911     0.654     0.200
     0.098     0.195     0.200
     0.077     0.619     0.200
     0.159    -0.209     0.200
     0.351     0.118     0.200
     0.300     0.724     0.200
     0.349     0.077     0.200
     0.428    -0.175     0.200
     0.461     0.064     0.200
     0.480     0.167     0.200
     0.498    -0.100     0.200
     0.490     0.501     0.200
     0.569     0.047     0.200
     0.611    -0.083     0.200
     0.724    -0.322     0.200
     0.747     0.578     0.200
     0.879    -0.361     0.200
     0.594     0.419     0.200
     0.057    -0.102     0.200
     0.155     0.198     0.200
     0.221     0.388     0.200
     0.287     0.060     0.200
     0.318     0.262     0.200
     0.339    -0.066     0.200
     0.418     0.259     0.200
     0.471     0.158     0.200
     0.545     0.475     0.200
     0.619     0.388     0.200
     0.623     0.022     0.200
     0.707     0.225     0.200
     0.804    -0.325     0.200
     0.194    -0.340     0.200
     0.241     0.102     0.200
     0.277     0.377     0.200
     0.349     0.252     0.200
     0.345     0.392     0.200
     0.422     0.072     0.200
     0.404     0.413     0.200
     0.482     0.542     0.200
     0.577    -0.412     0.200
     0.550     0.265     0.200
     0.327     0.101     0.200
     0.333     0.259     0.200
     0.334     0.409     0.200
     0.363     0.636     0.200
     0.426     0.827     0.200
     0.471     0.170     0.200
     0.506    -0.481     0.200
     0.471     0.372     0.200
     0.566    -0.094     0.200
     0.083     0.226     0.200
     0.247     0.118     0.200
     0.266     0.390     0.200
     0.308     0.161     0.200
     0.322     0.542     0.200
     0.384     0.040     0.200
     0.424     0.206     0.200
     0.486     0.454     0.200
     0.612     0.159     0.200
     0.793    -0.017     0.200
     0.871     0.277     0.200
     0.081    -0.085     0.200
     0.106     0.356     0.200
     0.181     0.605     0.200
     0.269     0.287     0.200
     0.369     0.216     0.200
     0.432     0.128     0.200
     0.594     0.026     0.200
     0.663     0.464     0.200
     0.137     0.045     0.200
     0.117     0.238     0.200
     0.249     0.176     0.200
     0.357    -0.157     0.200
     0.379    -0.069     0.200
     0.423    -0.030     0.200
     0.508     0.386     0.200
     0.643     0.057     0.200
     0.659     0.344     0.200
     0.681    -0.166     0.200
     0.881     0.082     0.200
     0.895    -0.197     0.200
     0.986    -0.074     0.200
     0.106     0.002     0.200
     0.092     0.363     0.200
     0.137     0.672     0.200
     0.317     0.211     0.200
     0.392     0.197     0.200
     0.386     0.217     0.200
     0.459    -0.087     0.200
     0.533     0.014     0.200
     0.514     0.477     0.200
     0.663    -0.487     0.200
     0.193     0.566     0.200
     0.186    -0.004     0.200
     0.360     0.343     0.200
     0.662     0.686     0.200
     0.704     0.037     0.200
     0.779    -0.724     0.200
     0.775    -0.603     0.200
     0.782     0.211     0.200
     0.783     0.326     0.200
     0.046     0.205     0.200
     0.112     0.304     0.200
     0.111     0.399     0.200
     0.104     0.430     0.200
     0.247     0.320     0.200
     0.244     0.111     0.200
     0.309     0.469     0.200
     0.366     0.367     0.200
     0.455     0.482     0.200
     0.446     0.805     0.200
     0.474     0.392     0.200
     0.561     0.202     0.200
     0.577    -0.064     0.200
     0.913    -0.788     0.200
     0.170    -0.313     0.200
     0.154     0.035     0.200
     0.184     0.082     0.200
     0.299    -0.187     0.200
     0.385     0.102     0.200
     0.396    -0.114     0.200
     0.445     0.310     0.200
     0.512     0.316     0.200
     0.535    -0.052     0.200
     0.544     0.341     0.200
     0.623     0.001     0.200
     0.756     0.089     0.200
     0.849     0.067     0.200
     0.919     0.063     0.200
     0.955     0.114     0.200
     0.179    -0.251     0.200
     0.141    -0.006     0.200
     0.180    -0.023     0.200
     0.287    -0.445     0.200
     0.303    -0.007     0.200
     0.399     0.369     0.200
     0.406     0.282     0.200
     0.526    -0.144     0.200
     0.549    -0.292     0.200
     0.535     0.101     0.200
     0.636    -0.143     0.200
     0.739     0.139     0.200
     0.787     0.009     0.200
     0.854     0.072     0.200
     0.952     0.332     0.200
     0.106     0.029     0.200
     0.157    -0.113     0.200
     0.233     0.392     0.200
     0.276     0.297     0.200
     0.333     0.161     0.200
     0.331     0.496     0.200
     0.379     0.470     0.200
     0.522     0.563     0.200
     0.579     0.480     0.200
     0.610     0.536     0.200
     0.152     0.412     0.200
     0.224    -0.186     0.200
     0.238     0.204     0.200
     0.328    -0.065     0.200
     0.370     0.065     0.200
     0.411     0.118     0.200
     0.460     0.243     0.200
     0.485     0.101     0.200
     0.559     0.156     0.200
     0.651     0.027     0.200
     0.664     0.211     0.200
     0.688    -0.187     0.200
     0.699     0.441     0.200
     0.737     0.344     0.200
     0.759     0.113     0.200
     0.791     0.203     0.200
     0.836    -0.049     0.200
     0.845     0.424     0.200
     0.849     0.297     0.200
     0.836     0.446     0.200
     0.916     0.087     0.200
     0.950     0.505     0.200
     0.084     0.048     0.200
     0.101     0.458     0.200
     0.173     0.325     0.200
     0.395     0.556     0.200
     0.407     0.606     0.200
     0.445     0.179     0.200
     0.457     0.268     0.200
     0.509    -0.329     0.200
     0.528     0.112     0.200
     0.527     0.492     0.200
     0.627    -0.154     0.200
     0.785    -0.321     0.200
     0.147     0.303     0.200
     0.156    -0.020     0.200
     0.183     0.244     0.200
     0.204     0.226     0.200
     0.309     0.223     0.200
     0.369     0.134     0.200
     0.378     0.361     0.200
     0.553     0.568     0.200
     0.615     0.537     0.200
     0.626     0.464     0.200
     0.074     0.143     0.200
     0.138     0.188     0.200
     0.150     0.146     0.200
     0.171    -0.219     0.200
     0.308     0.098     0.200
     0.326    -0.144     0.200
     0.413    -0.066     0.200
     0.450     0.080     0.200
     0.457    -0.018     0.200
     0.546     0.154     0.200
     0.546     0.459     0.200
     0.570     0.154     0.200
     0.896     0.556     0.200
     0.085     0.222     0.200
     0.142     0.126     0.200
     0.154     0.024     0.200
     0.327     0.131     0.200
     0.341     0.155     0.200
     0.349     0.076     0.200
     0.389    -0.298     0.200
     0.410     0.345     0.200
     0.461    -0.023     0.200
     0.486     0.250     0.200
     0.530     0.114     0.200
     0.582     0.225     0.200
     0.606     0.032     0.200
     0.645     0.154     0.200
     0.161     0.193     0.200
     0.242     0.115     0.200
     0.267     0.124     0.200
     0.370     0.175     0.200
     0.393     0.501     0.200
     0.443    -0.185     0.200
     0.437    -0.051     0.200
     0.485    -0.277     0.200
     0.560     0.281     0.200
     0.584     0.275     0.200
     0.600    -0.079     0.200
     0.646     0.017     0.200
     0.636     0.337     0.200
     0.657    -0.111     0.200
     0.710     0.212     0.200
     0.733    -0.025     0.200
     0.745    -0.116     0.200
     0.726     0.291     0.200
     0.787    -0.079     0.200
     0.791    -0.209     0.200
     0.806     0.251     0.200
     0.801     0.582     0.200
     0.853     0.164     0.200
     0.910    -0.028     0.200
     0.923     0.655     0.200
     0.187     0.084     0.200
     0.251     0.200     0.200
     0.268     0.069     0.200
     0.303     0.126     0.200
     0.329     0.081     0.200
     0.451    -0.251     0.200
     0.538    -0.391     0.200
     0.576     0.139     0.200
     0.636    -0.209     0.200
     0.779    -0.043     0.200
     0.826     0.129     0.200
     0.837    -0.043     0.200
     0.163     0.118     0.200
     0.243     0.037     0.200
     0.263     0.289     0.200
     0.328     0.242     0.200
     0.333     0.277     0.200
     0.359     0.221     0.200
     0.388    -0.034     0.200
     0.402     0.033     0.200
     0.445     0.498     0.200
     0.494    -0.440     0.200
     0.553    -0.076     0.200
     0.577     0.061     0.200
     0.596     0.037     0.200
     0.631     0.048     0.200
     0.664    -0.024     0.200
     0.704     0.061     0.200
     0.778     0.162     0.200
     0.864     0.103     0.200
     0.093     0.247     0.200
     0.088    -0.113     0.200
     0.175     0.313     0.200
     0.256     0.102     0.200
     0.288     0.031     0.200
     0.358    -0.069     0.200
     0.425     0.138     0.200
     0.491     0.260     0.200
     0.579     0.479     0.200
     0.585     0.067     0.200
     0.636     0.425     0.200
     0.654     0.301     0.200
     0.755    -0.078     0.200
     0.913    -0.100     0.200
     0.923     0.132     0.200
     0.201     0.349     0.200
     0.311     0.018     0.200
     0.315    -0.006     0.200
     0.345    -0.016     0.200
     0.384     0.305     0.200
     0.415    -0.326     0.200
     0.399     0.408     0.200
     0.436    -0.189     0.200
     0.475     0.135     0.200
     0.505     0.268     0.200
     0.586    -0.018     0.200
     0.668     0.009     0.200
     0.764     0.010     0.200
     0.783     0.081     0.200
     0.105     0.037     0.200
     0.147     0.116     0.200
     0.173    -0.033     0.200
     0.216     0.262     0.200
     0.230     0.255     0.200
     0.332     0.152     0.200
     0.378    -0.013     0.200
     0.416     0.036     0.200
     0.453     0.218     0.200
     0.460     0.353     0.200
     0.453     0.189     0.200
     0.554     0.011     0.200
     0.584     0.331     0.200
     0.597     0.008     0.200
     0.657     0.123     0.200
     0.701    -0.034     0.200
     0.712     0.142     0.200
     0.786    -0.039     0.200
     0.112     0.079     0.200
     0.216     0.184     0.200
     0.247     0.470     0.200
     0.289     0.195     0.200
     0.313    -0.036     0.200
     0.324    -0.022     0.200
     0.343     0.110     0.200
     0.422    -0.035     0.200
     0.422     0.006     0.200
     0.428     0.109     0.200
     0.641     0.154     0.200
     0.677     0.094     0.200
     0.060    -0.011     0.200
     0.194     0.406     0.200
     0.228     0.441     0.200
     0.255     0.304     0.200
     0.346     0.242     0.200
     0.357     0.473     0.200
     0.385     0.124     0.200
     0.392     0.215     0.200
     0.370     0.600     0.200
     0.430    -0.062     0.200
     0.469     0.279     0.200
     0.581     0.230     0.200
     0.539     0.563     0.200
     0.586     0.356     0.200
     0.609     0.544     0.200
     0.792    -0.292     0.200
     0.794    -0.258     0.200
     0.849    -0.255     0.200
     0.926    -0.111     0.200
     0.949    -0.091     0.200
     0.941     0.368     0.200
     0.974    -0.396     0.200
     0.980    -0.419     0.200
     0.573     1.281     0.200
     0.061    -0.116     0.200
     0.112     0.426     0.200
     0.207     0.300     0.200
     0.279     0.228     0.200
     0.273     0.316     0.200
     0.328     0.194     0.200
     0.379     0.238     0.200
     0.456     0.066     0.200
     0.484     0.219     0.200
     0.559    -0.131     0.200
     0.612     0.241     0.200
     0.644     0.576     0.200
     0.648     0.016     0.200
     0.683     0.681     0.200
     0.732    -0.276     0.200
     0.733    -0.266     0.200
     0.769     0.165     0.200
     0.177     0.379     0.200
     0.233     0.382     0.200
     0.354     0.207     0.200
     0.363    -0.068     0.200
     0.355     0.362     0.200
     0.398     0.369     0.200
     0.444    -0.039     0.200
     0.470    -0.080     0.200
     0.598     0.208     0.200
     0.572     0.589     0.200
     0.941     0.499     0.200
     0.962    -0.027     0.200
     0.140     0.067     0.200
     0.142     0.134     0.200
     0.169     0.068     0.200
     0.202    -0.071     0.200
     0.328    -0.074     0.200
     0.353    -0.307     0.200
     0.367     0.054     0.200
     0.372     0.300     0.200
     0.381    -0.068     0.200
     0.398    -0.097     0.200
     0.432    -0.090     0.200
     0.447     0.052     0.200
     0.451     0.660     0.200
     0.504    -0.288     0.200
     0.503     0.116     0.200
     0.520     0.190     0.200
     0.534    -0.243     0.200
     0.636     0.310     0.200
     0.643     0.055     0.200
     0.699     0.034     0.200
     0.681     0.115     0.200
     0.693     0.520     0.200
     0.714    -0.045     0.200
     0.763     0.194     0.200
     0.925     0.565     0.200
     0.150     0.183     0.200
     0.144    -0.281     0.200
     0.176    -0.265     0.200
     0.259     0.131     0.200
     0.275     0.361     0.200
     0.379     0.104     0.200
     0.374     0.084     0.200
     0.446    -0.094     0.200
     0.455     0.271     0.200
     0.447    -0.061     0.200
     0.500    -0.122     0.200
     0.611    -0.547     0.200
     0.616     0.036     0.200
     0.631    -0.249     0.200
     0.628     0.232     0.200
     0.637     0.820     0.200
     0.683    -0.089     0.200
     0.702     0.333     0.200
     0.779    -0.055     0.200
     0.818     0.617     0.200
     0.861     0.459     0.200
     0.935     0.341     0.200
     0.963     0.263     0.200
     0.981    -0.111     0.200
     0.092    -0.013     0.200
     0.226    -0.012     0.200
     0.229     0.374     0.200
     0.254     0.004     0.200
     0.367     0.126     0.200
     0.432     0.217     0.200
     0.507     0.309     0.200
     0.509     0.026     0.200
     0.611    -0.253     0.200
     0.677    -0.340     0.200
     0.682     0.221     0.200
     0.683     0.169     0.200
     0.845    -0.022     0.200
     0.124     0.148     0.200
     0.134    -0.065     0.200
     0.155     0.449     0.200
     0.269     0.486     0.200
     0.291     0.052     0.200
     0.318     0.090     0.200
     0.496    -0.068     0.200
     0.544    -0.178     0.200
     0.532     0.192     0.200
     0.556     0.237     0.200
     0.618    -0.188     0.200
     0.672    -0.064     0.200
     0.764     0.186     0.200
     0.808    -0.430     0.200
     0.875    -0.228     0.200
     0.157    -0.167     0.200
     0.273    -0.044     0.200
     0.284    -0.405     0.200
     0.322     0.198     0.200
     0.344    -0.250     0.200
     0.360    -0.403     0.200
     0.420    -0.396     0.200
     0.443    -0.197     0.200
     0.464     0.057     0.200
     0.507    -0.014     0.200
     0.543    -0.098     0.200
     0.563     0.552     0.200
     0.588     0.252     0.200
     0.637     0.301     0.200
     0.722     0.320     0.200
     0.795    -0.136     0.200
     0.795     0.421     0.200
     0.790    -0.123     0.200
     0.820     0.610     0.200
     0.921     0.473     0.200
     0.095     0.130     0.200
     0.101     0.092     0.200
     0.319     0.456     0.200
     0.437    -0.374     0.200
     0.464     0.413     0.200
     0.467    -0.166     0.200
     0.534     0.475     0.200
     0.655     0.160     0.200
     0.815    -0.059     0.200
     0.056     0.307     0.200
     0.137    -0.149     0.200
     0.180     0.453     0.200
     0.198     0.550     0.200
     0.310     0.607     0.200
     0.413     0.215     0.200
     0.412     0.055     0.200
     0.486    -0.092     0.200
     0.554     0.781     0.200
     0.563     0.090     0.200
     0.578     0.684     0.200
     0.626     0.291     0.200
     0.162     0.101     0.200
     0.195    -0.137     0.200
     0.199     0.322     0.200
     0.318     0.547     0.200
     0.313     0.570     0.200
     0.345     0.417     0.200
     0.532    -0.080     0.200
     0.574    -0.040     0.200
     0.672     0.421     0.200
     0.663    -0.036     0.200
     0.691     0.193     0.200
     0.851    -0.269     0.200
     0.904     0.001     0.200
     0.974     0.544     0.200
     0.205     0.054     0.200
     0.268     0.349     0.200
     0.271     0.256     0.200
     0.271     0.216     0.200
     0.281    -0.048     0.200
     0.325    -0.099     0.200
     0.369     0.350     0.200
     0.381     0.282     0.200
     0.467    -0.410     0.200
     0.453     0.309     0.200
     0.546     0.267     0.200
     0.592     0.224     0.200
     0.624     0.207     0.200
     0.626    -0.017     0.200
     0.625     0.118     0.200
     0.697     0.203     0.200
     0.834     0.020     0.200
     0.080     0.219     0.200
     0.116     0.065     0.200
     0.191    -0.009     0.200
     0.189     0.242     0.200
     0.241     0.371     0.200
     0.302     0.151     0.200
     0.350     0.403     0.200
     0.355    -0.166     0.200
     0.492     0.412     0.200
     0.499     0.146     0.200
     0.563    -0.075     0.200
     0.679     0.002     0.200
     0.739    -0.037     0.200
     0.762     0.477     0.200
     0.752     0.013     0.200
     0.769    -0.064     0.200
     0.775     0.226     0.200
     0.809     0.178     0.200
     0.887    -0.240     0.200
     0.177    -0.087     0.200
     0.159     0.073     0.200
     0.203     0.284     0.200
     0.243    -0.110     0.200
     0.362    -0.320     0.200
     0.341     0.100     0.200
     0.406    -0.361     0.200
     0.444     0.283     0.200
     0.464    -0.451     0.200
     0.614    -0.591     0.200
     0.633    -0.023     0.200
     0.635     0.722     0.200
     0.653     0.099     0.200
     0.689    -0.294     0.200
     0.710     0.450     0.200
     0.762    -0.474     0.200
     0.758    -0.326     0.200
     0.785     0.148     0.200
     0.774     0.084     0.200
     0.785     0.513     0.200
     0.818     0.619     0.200
     0.869     0.397     0.200
     0.929     0.085     0.200
     0.031     0.219     0.200
     0.128     0.009     0.200
     0.208    -0.072     0.200
     0.327     0.163     0.200
     0.250     0.667     0.200
     0.323     0.492     0.200
     0.385     0.209     0.200
     0.469     0.192     0.200
     0.503     0.269     0.200
     0.475     0.698     0.200
     0.603     0.219     0.200
     0.655     0.222     0.200
     0.776     0.034     0.200
     0.770     0.833     0.200
     0.927    -0.076     0.200
     0.928    -0.133     0.200
     0.110    -0.034     0.200
     0.189     0.526     0.200
     0.235     0.247     0.200
     0.357     0.303     0.200
     0.391    -0.211     0.200
     0.419     0.422     0.200
     0.579     0.277     0.200
     0.638     0.312     0.200
     0.660     0.633     0.200
     0.661     0.248     0.200
     0.762     0.005     0.200
     0.118     0.393     0.200
     0.195     0.678     0.200
     0.394     0.097     0.200
     0.398     0.047     0.200
     0.409    -0.584     0.200
     0.424    -0.144     0.200
     0.451     0.176     0.200
     0.585    -0.076     0.200
     0.586    -0.110     0.200
     0.638     0.090     0.200
     0.708     0.303     0.200
     0.106     0.124     0.200
     0.112     0.376     0.200
     0.117    -0.027     0.200
     0.157     0.016     0.200
     0.271    -0.097     0.200
     0.359    -0.104     0.200
     0.363    -0.047     0.200
     0.399    -0.006     0.200
     0.421     0.025     0.200
     0.477    -0.366     0.200
     0.591     0.144     0.200
     0.644    -0.077     0.200
     0.688     0.004     0.200
     0.703     0.338     0.200
     0.731     0.013     0.200
     0.746    -0.239     0.200
     0.796    -0.047     0.200
     0.811     0.141     0.200
     0.161     0.186     0.200
     0.290    -0.022     0.200
     0.305     0.008     0.200
     0.302    -0.027     0.200
     0.310     0.096     0.200
     0.362     0.127     0.200
     0.436    -0.254     0.200
     0.433     0.255     0.200
     0.449     0.022     0.200
     0.464     0.247     0.200
     0.556     0.116     0.200
     0.628    -0.034     0.200
     0.698     0.242     0.200
     0.723     0.387     0.200
     0.737    -0.253     0.200
     0.796     0.232     0.200
     0.836     0.239     0.200
     0.807     0.257     0.200
     0.841     0.341     0.200
     0.866    -0.229     0.200
     0.051    -0.110     0.200
     0.160     0.441     0.200
     0.196     0.253     0.200
     0.173     0.531     0.200
     0.282     0.008     0.200
     0.294     0.529     0.200
     0.360     0.115     0.200
     0.389     0.062     0.200
     0.409     0.199     0.200
     0.414     0.334     0.200
     0.458     0.166     0.200
     0.511    -0.242     0.200
     0.506     0.467     0.200
     0.537     0.498     0.200
     0.606     0.312     0.200
     0.651    -0.355     0.200
     0.683     0.205     0.200
     0.723    -0.115     0.200
     0.862    -0.294     0.200
     0.871    -0.273     0.200
     0.877    -0.220     0.200
     0.929     0.068     0.200
     0.950    -0.003     0.200
     0.954    -0.035     0.200
     0.780     0.246     0.200
     0.108     0.153     0.200
     0.165     0.160     0.200
     0.226     0.029     0.200
     0.357    -0.183     0.200
     0.392    -0.033     0.200
     0.459    -0.227     0.200
     0.545     0.131     0.200
     0.603     0.383     0.200
     0.629     0.332     0.200
     0.650     0.122     0.200
     0.719     0.404     0.200
     0.658     1.180     0.200
     0.147     0.141     0.200
     0.136     0.013     0.200
     0.199     0.148     0.200
     0.229     0.286     0.200
     0.356     0.102     0.200
     0.377     0.471     0.200
     0.432     0.036     0.200
     0.541     0.449     0.200
     0.602     0.303     0.200
     0.620     0.486     0.200
     0.625     0.176     0.200
     0.693     0.151     0.200
     0.730    -0.082     0.200
     0.974     0.469     0.200
     0.210     0.065     0.200
     0.302     0.116     0.200
     0.313     0.091     0.200
     0.336     0.062     0.200
     0.360     0.040     0.200
     0.399    -0.408     0.200
     0.381     0.048     0.200
     0.422     0.029     0.200
     0.461     0.096     0.200
     0.484     0.189     0.200
     0.510     0.021     0.200
     0.516     0.345     0.200
     0.532     0.209     0.200
     0.571     0.147     0.200
     0.681    -0.026     0.200
     0.681     0.049     0.200
     0.747     0.229     0.200
     0.768    -0.119     0.200
     0.775     0.169     0.200
     0.854     0.070     0.200
     0.848     0.424     0.200
     0.071     0.143     0.200
     0.168     0.091     0.200
     0.294     0.025     0.200
     0.383     0.344     0.200
     0.451     0.117     0.200
     0.512     0.264     0.200
     0.515    -0.090     0.200
     0.538    -0.317     0.200
     0.730    -0.120     0.200
     0.732    -0.141     0.200
     0.787     0.324     0.200
     0.808    -0.144     0.200
     0.801    -0.186     0.200
     0.816     0.361     0.200
     0.807    -0.261     0.200
     0.116    -0.025     0.200
     0.204     0.253     0.200
     0.267    -0.287     0.200
     0.311    -0.045     0.200
     0.328    -0.339     0.200
     0.342    -0.186     0.200
     0.360     0.344     0.200
     0.462     0.146     0.200
     0.524    -0.253     0.200
     0.532     0.011     0.200
     0.584     0.254     0.200
     0.652    -0.019     0.200
     0.684     0.237     0.200
     0.714     0.324     0.200
     0.682     0.396     0.200
     0.708     0.393     0.200
     0.735    -0.074     0.200
     0.767     0.305     0.200
     0.855     0.275     0.200
     0.842     1.077     0.200
     0.915    -0.102     0.200
     0.918    -0.460     0.200
     0.942     0.151     0.200
     0.145     0.677     0.200
     0.189     0.509     0.200
     0.288     0.152     0.200
     0.292     0.301     0.200
     0.317     0.400     0.200
     0.310     0.298     0.200
     0.396     0.296     0.200
     0.440    -0.106     0.200
     0.458    -0.242     0.200
     0.463     0.461     0.200
     0.507    -0.291     0.200
     0.510     0.478     0.200
     0.575     0.087     0.200
     0.568     0.567     0.200
     0.667    -0.077     0.200
     0.674    -0.126     0.200
     0.730     1.055     0.200
     0.727     0.139     0.200
     0.781     0.250     0.200
     0.799     0.038     0.200
     0.809     0.326     0.200
     0.836    -0.386     0.200
     0.882     0.038     0.200
     0.136     0.194     0.200
     0.168     0.254     0.200
     0.149    -0.015     0.200
     0.261     0.213     0.200
     0.358     0.353     0.200
     0.373     0.435     0.200
     0.446     0.391     0.200
     0.449     0.422     0.200
     0.440     0.072     0.200
     0.484    -0.124     0.200
     0.564     0.523     0.200
     0.617    -0.353     0.200
     0.612     0.518     0.200
     0.621     0.512     0.200
     0.684     0.309     0.200
     0.681    -0.058     0.200
     0.685     0.445     0.200
     0.759     0.227     0.200
     0.777     0.473     0.200
     0.784    -0.136     0.200
     0.805    -0.226     0.200
     0.849     0.512     0.200
     0.481    -0.661     0.200
     0.584     1.212     0.200
     0.011     0.445     0.200
     0.113     0.079     0.200
     0.140     0.170     0.200
     0.172     0.453     0.200
     0.218     0.188     0.200
     0.240     0.175     0.200
     0.305     0.206     0.200
     0.333    -0.584     0.200
     0.373    -0.004     0.200
     0.438    -0.527     0.200
     0.476     0.060     0.200
     0.474     0.199     0.200
     0.473     0.472     0.200
     0.487     0.276     0.200
     0.579    -0.087     0.200
     0.609     0.095     0.200
     0.659    -0.033     0.200
     0.692    -0.509     0.200
     0.690    -0.122     0.200
     0.721    -0.559     0.200
     0.727    -0.030     0.200
     0.744    -0.106     0.200
     0.744     0.641     0.200
     0.776     0.185     0.200
     0.816     0.661     0.200
     0.840     0.125     0.200
     0.906    -0.222     0.200
     0.960     0.396     0.200
     1.000     0.340     0.200
     0.109     0.566     0.200
     0.177     0.434     0.200
     0.207    -0.468     0.200
     0.305     0.203     0.200
     0.316    -0.357     0.200
     0.364     0.226     0.200
     0.434     0.357     0.200
     0.439    -0.184     0.200
     0.434     0.304     0.200
     0.515    -0.053     0.200
     0.561    -0.080     0.200
     0.584     0.076     0.200
     0.584     0.267     0.200
     0.586     0.022     0.200
     0.670     0.416     0.200
     0.711     0.139     0.200
     0.736     0.293     0.200
     0.719    -0.058     0.200
     0.763     0.088     0.200
     0.813     0.130     0.200
     0.869    -0.359     0.200
     0.893    -0.068     0.200
     0.134     0.096     0.200
     0.132     0.430     0.200
     0.183    -0.122     0.200
     0.255     0.278     0.200
     0.340     0.185     0.200
     0.328     0.107     0.200
     0.415    -0.017     0.200
     0.420     0.011     0.200
     0.454     0.257     0.200
     0.465    -0.195     0.200
     0.585     0.352     0.200
     0.588     0.378     0.200
     0.661    -0.244     0.200
     0.658     0.302     0.200
     0.746     0.299     0.200
     0.770    -0.081     0.200
     0.866    -0.050     0.200
     0.927     0.316     0.200
     0.982     0.105     0.200
     0.986    -0.397     0.200
     0.148     0.594     0.200
     0.207    -0.070     0.200
     0.270    -0.139     0.200
     0.296     0.305     0.200
     0.329    -0.007     0.200
     0.408     0.125     0.200
     0.431    -0.690     0.200
     0.451     0.228     0.200
     0.571     0.062     0.200
     0.582     0.057     0.200
     0.602    -0.206     0.200
     0.670     0.175     0.200
     0.723     0.106     0.200
     0.807    -0.350     0.200
     0.799     0.539     0.200
     0.851    -0.300     0.200
     0.925     0.284     0.200
     0.155     0.155     0.200
     0.249     0.057     0.200
     0.263     0.219     0.200
     0.318     0.338     0.200
     0.350     0.481     0.200
     0.393     0.304     0.200
     0.387     0.017     0.200
     0.440     0.541     0.200
     0.490    -0.076     0.200
     0.578    -0.400     0.200
     0.593    -0.295     0.200
     0.659    -0.170     0.200
     0.685     0.581     0.200
     0.700     0.741     0.200
     0.699     0.695     0.200
     0.773     0.226     0.200
     0.787     0.037     0.200
     0.850     0.381     0.200
     0.860    -0.184     0.200
     0.915     0.334     0.200
     0.040     0.016     0.200
     0.165     0.300     0.200
     0.175     0.504     0.200
     0.248     0.598     0.200
     0.311     0.482     0.200
     0.347     0.066     0.200
     0.376     0.323     0.200
     0.499     0.419     0.200
     0.471     0.347     0.200
     0.484     0.298     0.200
     0.505     0.430     0.200
     0.595     0.889     0.200
     0.710    -0.107     0.200
     0.732    -0.217     0.200
     0.783    -0.086     0.200
     0.795     0.371     0.200
     0.933    -0.174     0.200
     0.942    -0.242     0.200
     0.995    -0.787     0.200
     0.660     1.754     0.200
     0.139     0.021     0.200
     0.128     0.161     0.200
     0.306     0.220     0.200
     0.371    -0.059     0.200
     0.370     0.004     0.200
     0.528    -0.698     0.200
     0.664     0.175     0.200
     0.679     0.205     0.200
     0.679     0.522     0.200
     0.841     0.639     0.200
     0.942    -0.027     0.200
     0.317    -0.476     0.200
     0.295     0.253     0.200
     0.491    -0.268     0.200
     0.526     0.017     0.200
     0.504     0.218     0.200
     0.528    -0.315     0.200
     0.634     0.529     0.200
     0.688     0.096     0.200
     0.719     0.566     0.200
     0.724     0.589     0.200
     0.919    -0.499     0.200
     0.235     0.135     0.200
     0.261    -0.007     0.200
     0.384    -0.116     0.200
     0.413     0.418     0.200
     0.442     0.543     0.200
     0.488     0.447     0.200
     0.484    -0.066     0.200
     0.555    -0.528     0.200
     0.524     0.241     0.200
     0.570    -0.090     0.200
     0.727     0.016     0.200
     0.742     0.049     0.200
     0.740     0.021     0.200
     0.814    -0.128     0.200
     0.936    -0.285     0.200
     0.212    -0.017     0.200
     0.271     0.284     0.200
     0.385    -0.264     0.200
     0.395    -0.147     0.200
     0.411     0.655     0.200
     0.460     0.082     0.200
     0.525    -0.627     0.200
     0.548     0.601     0.200
     0.548     0.325     0.200
     0.551    -0.262     0.200
     0.650    -0.074     0.200
     0.697    -0.249     0.200
     0.738     0.118     0.200
     0.812     0.646     0.200
     0.880    -0.064     0.200
     0.915    -0.387     0.200
     0.892     0.420     0.200
     0.946     0.114     0.200
     0.128    -0.547     0.200
     0.173    -0.118     0.200
     0.195    -0.354     0.200
     0.234    -0.066     0.200
     0.268    -0.179     0.200
     0.349    -0.347     0.200
     0.427     0.361     0.200
     0.481     0.257     0.200
     0.500    -0.133     0.200
     0.524    -0.019     0.200
     0.689     0.258     0.200
     0.719     0.165     0.200
     0.735    -0.207     0.200
     0.826     0.218     0.200
     0.839    -0.026     0.200
     0.947     0.041     0.200
     0.987     0.046     0.200
     0.999    -0.181     0.200
     0.211     0.176     0.200
     0.121     0.507     0.200
     0.145     0.692     0.200
     0.240    -0.340     0.200
     0.344    -0.097     0.200
     0.367     0.472     0.200
     0.430    -0.002     0.200
     0.409     0.549     0.200
     0.489     0.111     0.200
     0.541     0.154     0.200
     0.578    -0.448     0.200
     0.831    -0.210     0.200
     0.218    -0.154     0.200
     0.254    -0.021     0.200
     0.274    -0.074     0.200
     0.337     0.385     0.200
     0.350    -0.266     0.200
     0.366     0.105     0.200
     0.517    -0.531     0.200
     0.514    -0.480     0.200
     0.542     0.183     0.200
     0.626    -0.241     0.200
     0.667     0.293     0.200
     0.681     0.216     0.200
     0.785    -1.030     0.200
     0.855     0.577     0.200
     0.887     0.420     0.200
     0.099     0.043     0.200
     0.101     0.183     0.200
     0.166     0.136     0.200
     0.266    -0.018     0.200
     0.271     0.207     0.200
     0.297    -0.121     0.200
     0.341     0.069     0.200
     0.428    -0.199     0.200
     0.521     0.419     0.200
     0.545     0.356     0.200
     0.640     0.357     0.200
     0.705     0.121     0.200
     0.722     0.294     0.200
     0.739    -0.071     0.200
     0.764    -0.315     0.200
     0.766    -0.723     0.200
     0.796     0.067     0.200
     0.835    -0.852     0.200
     0.831    -0.374     0.200
     0.835     0.344     0.200
     0.925    -0.257     0.200
     0.984    -0.273     0.200
     0.263     0.417     0.200
     0.716     2.230     0.200
     0.060    -0.070     0.200
     0.123     0.266     0.200
     0.203     0.553     0.200
     0.304    -0.134     0.200
     0.388     0.205     0.200
     0.453    -0.211     0.200
     0.510    -0.128     0.200
     0.584    -0.207     0.200
     0.615    -0.075     0.200
     0.657     0.608     0.200
     0.684     0.221     0.200
     0.790    -0.260     0.200
     0.917     0.615     0.200
     0.926     0.258     0.200
     0.185    -0.097     0.200
     0.266    -0.092     0.200
     0.280     0.038     0.200
     0.267     0.064     0.200
     0.348     0.093     0.200
     0.461    -0.334     0.200
     0.441     0.211     0.200
     0.527     0.022     0.200
     0.535     0.213     0.200
     0.743     0.445     0.200
     0.763    -0.069     0.200
     0.870    -0.267     0.200
     0.911     0.358     0.200
     0.998     0.133     0.200
     0.067     0.135     0.200
     0.107     0.003     0.200
     0.209     0.309     0.200
     0.339     0.374     0.200
     0.373     0.006     0.200
     0.456    -0.379     0.200
     0.472     0.023     0.200
     0.547    -0.474     0.200
     0.552    -0.043     0.200
     0.609    -0.155     0.200
     0.643     0.633     0.200
     0.680     0.420     0.200
     0.726     0.193     0.200
     0.761     0.056     0.200
     0.864     0.321     0.200
     0.857     0.487     0.200
     0.878     0.397     0.200
     0.888     0.318     0.200
     0.914     0.387     0.200
     0.558     0.983     0.200
     0.778     0.024     0.200
     0.092     0.184     0.200
     0.178     0.324     0.200
     0.242     0.162     0.200
     0.265     0.114     0.200
     0.361     0.082     0.200
     0.404     0.207     0.200
     0.551     0.278     0.200
     0.608     0.366     0.200
     0.638     0.306     0.200
     0.930     0.183     0.200
     0.097     0.424     0.200
     0.203     0.173     0.200
     0.224    -0.064     0.200
     0.329    -0.006     0.200
     0.340     0.169     0.200
     0.332     0.044     0.200
     0.465    -0.108     0.200
     0.451     0.132     0.200
     0.793     0.006     0.200
     0.752    -0.128     0.200
     0.061     0.181     0.200
     0.110    -0.046     0.200
     0.131    -0.026     0.200
     0.224    -0.200     0.200
     0.231    -0.169     0.200
     0.284    -0.300     0.200
     0.279     0.522     0.200
     0.366    -0.355     0.200
     0.443    -0.486     0.200
     0.535    -0.331     0.200
     0.527    -0.065     0.200
     0.523    -0.136     0.200
     0.958     0.162     0.200
     0.276    -0.411     0.200
     0.208     0.217     0.200
     0.242    -0.063     0.200
     0.328     0.221     0.200
     0.351    -0.127     0.200
     0.351     0.191     0.200
     0.379     0.060     0.200
     0.469    -0.141     0.200
     0.469    -0.170     0.200
     0.710     0.018     0.200
     0.746     0.155     0.200
     0.790    -0.435     0.200
     0.790     0.616     0.200
     0.790     0.342     0.200
     0.890     0.479     0.200
     0.073     0.306     0.200
     0.091     0.438     0.200
     0.150    -0.204     0.200
     0.217     0.064     0.200
     0.228    -0.112     0.200
     0.270     0.185     0.200
     0.265     0.056     0.200
     0.494    -0.274     0.200
     0.538    -0.064     0.200
     0.544    -0.068     0.200
     0.064     0.222     0.200
     0.095     0.342     0.200
     0.145    -0.055     0.200
     0.213     0.294     0.200
     0.218     0.140     0.200
     0.268     0.387     0.200
     0.488     0.044     0.200
     0.526     0.204     0.200
     0.547     0.084     0.200
     0.628    -0.045     0.200
     0.648    -0.423     0.200
     0.691     0.043     0.200
     0.693    -0.252     0.200
     0.722     0.112     0.200
     0.753    -0.131     0.200
     0.753    -0.153     0.200
     0.804    -0.198     0.200
     0.137     0.089     0.200
     0.134     0.210     0.200
     0.179     0.499     0.200
     0.246     0.210     0.200
     0.249     0.151     0.200
     0.280    -0.106     0.200
     0.363     0.110     0.200
     0.356     0.067     0.200
     0.383     0.268     0.200
     0.394    -0.206     0.200
     0.513    -0.111     0.200
     0.518     0.365     0.200
     0.534     0.124     0.200
     0.567    -0.210     0.200
     0.601     0.149     0.200
     0.650    -0.228     0.200
     0.666    -0.171     0.200
     0.722     0.466     0.200
     0.741    -0.682     0.200
     0.762     0.031     0.200
     0.787    -0.035     0.200
     0.801     0.564     0.200
     0.872     0.064     0.200
     0.868     0.473     0.200
     0.956    -0.127     0.200
     0.063     0.074     0.200
     0.102     0.159     0.200
     0.138    -0.017     0.200
     0.223     0.172     0.200
     0.222     0.182     0.200
     0.276     0.203     0.200
     0.278    -0.481     0.200
     0.435    -0.057     0.200
     0.497     0.154     0.200
     0.532     0.173     0.200
     0.529     0.152     0.200
     0.637    -0.051     0.200
     0.654     0.149     0.200
     0.665    -0.189     0.200
     0.753     0.098     0.200
     0.163     0.162     0.200
     0.190     0.082     0.200
     0.329     0.245     0.200
     0.382     0.061     0.200
     0.431     0.102     0.200
     0.423     0.129     0.200
     0.458    -0.054     0.200
     0.488    -0.044     0.200
     0.554    -0.078     0.200
     0.587    -0.005     0.200
     0.662    -0.009     0.200
     0.680     0.224     0.200
     0.683     0.297     0.200
     0.707     0.129     0.200
     0.744    -0.048     0.200
     0.753     0.293     0.200
     0.775     0.263     0.200
     0.849     0.108     0.200
     0.857     0.379     0.200
     0.871     0.094     0.200
     0.888     0.035     0.200
     0.933    -0.219     0.200
     0.943     0.391     0.200
     0.959     0.483     0.200
     0.997     0.104     0.200
     0.135     0.024     0.200
     0.134     0.335     0.200
     0.181    -0.099     0.200
     0.216     0.207     0.200
     0.257     0.320     0.200
     0.341     0.233     0.200
     0.331     0.211     0.200
     0.416     0.126     0.200
     0.420     0.152     0.200
     0.455     0.176     0.200
     0.661     0.083     0.200
     0.746     0.363     0.200
     0.751    -0.245     0.200
     0.769     0.199     0.200
     0.770     0.003     0.200
     0.813     0.051     0.200
     0.866    -0.216     0.200
     0.887    -0.340     0.200
     0.901    -0.257     0.200
     0.928     0.260     0.200
     0.974    -0.435     0.200
     0.983    -0.024     0.200
     0.984    -0.346     0.200
     0.020     0.189     0.200
     0.096     0.105     0.200
     0.148    -0.039     0.200
     0.188     0.134     0.200
     0.238    -0.070     0.200
     0.475    -0.357     0.200
     0.481     0.199     0.200
     0.497    -0.082     0.200
     0.504     0.300     0.200
     0.620    -0.044     0.200
     0.680    -0.272     0.200
     0.703     0.013     0.200
     0.736     0.075     0.200
     0.765    -0.943     0.200
     0.021     0.227     0.200
     0.106     0.049     0.200
     0.138     0.085     0.200
     0.188     0.145     0.200
     0.229    -0.062     0.200
     0.380    -0.176     0.200
     0.448    -0.155     0.200
     0.482     0.018     0.200
     0.491    -0.290     0.200
     0.487     0.087     0.200
     0.504     0.062     0.200
     0.584    -0.137     0.200
     0.621    -0.114     0.200
     0.625    -0.221     0.200
     0.672    -0.110     0.200
     0.676     0.308     0.200
     0.696     0.391     0.200
     0.709     0.311     0.200
     0.709     0.442     0.200
     0.726    -0.531     0.200
     0.731    -0.143     0.200
     0.759     0.051     0.200
     0.793     0.208     0.200
     0.817    -0.045     0.200
     0.826     0.308     0.200
     0.856    -0.099     0.200
     0.912     0.328     0.200
     0.995     0.062     0.200
     0.134     0.099     0.200
     0.174     0.201     0.200
     0.207     0.133     0.200
     0.299    -0.006     0.200
     0.337     0.029     0.200
     0.386    -0.191     0.200
     0.486    -0.306     0.200
     0.556    -0.283     0.200
     0.583    -0.210     0.200
     0.625    -0.076     0.200
     0.644     0.336     0.200
     0.706    -0.601     0.200
     0.724    -0.057     0.200
     0.729    -0.216     0.200
     0.731    -0.210     0.200
     0.768     0.211     0.200
     0.839    -1.043     0.200
     0.828     0.078     0.200
     0.939     0.045     0.200
     0.147     0.435     0.200
     0.188     0.303     0.200
     0.216     0.201     0.200
     0.313     0.180     0.200
     0.352    -0.112     0.200
     0.397    -0.103     0.200
     0.498     0.551     0.200
     0.562    -0.274     0.200
     0.598    -0.590     0.200
     0.636     0.075     0.200
     0.659     0.328     0.200
     0.700    -0.299     0.200
     0.712    -0.276     0.200
     0.736     0.321     0.200
     0.744     0.075     0.200
     0.783    -0.172     0.200
     0.853     0.315     0.200
     0.870     0.316     0.200
     0.946     0.105     0.200
     0.958    -0.240     0.200
     0.157     0.293     0.200
     0.196     0.372     0.200
     0.219     0.364     0.200
     0.323    -0.217     0.200
     0.360    -0.156     0.200
     0.405    -0.802     0.200
     0.568    -0.035     0.200
     0.607    -0.361     0.200
     0.641    -0.076     0.200
     0.668    -0.124     0.200
     0.706    -0.450     0.200
     0.719    -0.144     0.200
     0.745    -0.136     0.200
     0.841    -0.090     0.200
     0.876     0.269     0.200
     0.961    -0.378     0.200
     0.062     0.240     0.200
     0.094     0.328     0.200
     0.147    -0.131     0.200
     0.209     0.357     0.200
     0.214     0.175     0.200
     0.286    -0.068     0.200
     0.346    -0.676     0.200
     0.422    -0.213     0.200
     0.484    -0.156     0.200
     0.521     0.227     0.200
     0.526     0.016     0.200
     0.544     0.371     0.200
     0.623     0.068     0.200
     0.644    -0.255     0.200
     0.651    -0.620     0.200
     0.689     0.066     0.200
     0.691     0.004     0.200
     0.716     0.504     0.200
     0.748    -0.685     0.200
     0.741    -0.052     0.200
     0.867     0.586     0.200
     0.094     0.188     0.200
     0.107     0.074     0.200
     0.155     0.254     0.200
     0.262     0.032     0.200
     0.258     0.159     0.200
     0.287     0.174     0.200
     0.417     0.126     0.200
     0.499    -0.068     0.200
     0.525     0.322     0.200
     0.560    -0.078     0.200
     0.578     0.307     0.200
     0.609     0.152     0.200
     0.649     0.100     0.200
     0.694     0.052     0.200
     0.697    -0.220     0.200
     0.729    -0.282     0.200
     0.728     0.280     0.200
     0.737     0.414     0.200
     0.753    -0.127     0.200
     0.756    -0.044     0.200
     0.791     0.111     0.200
     0.825    -0.995     0.200
     0.821    -0.441     0.200
     0.842     0.182     0.200
     0.867     0.378     0.200
     0.185     0.192     0.200
     0.267     0.150     0.200
     0.303     0.032     0.200
     0.469     0.109     0.200
     0.696     0.886     0.200
     0.865    -0.668     0.200
     0.852     0.108     0.200
     0.973    -0.058     0.200
     0.994    -0.087     0.200
     0.100     0.476     0.200
     0.115    -0.100     0.200
     0.151     0.296     0.200
     0.258     0.390     0.200
     0.317     0.176     0.200
     0.568     0.010     0.200
     0.591     0.100     0.200
     0.612     0.277     0.200
     0.636    -0.116     0.200
     0.854     0.422     0.200
     0.960     0.078     0.200
     0.035     0.105     0.200
     0.245     0.253     0.200
     0.367    -0.326     0.200
     0.401     0.109     0.200
     0.453     0.066     0.200
     0.671     0.374     0.200
     0.683     1.069     0.200
     0.705     0.024     0.200
     0.859    -0.533     0.200
     0.970    -0.165     0.200
     0.138    -0.052     0.200
     0.170     0.195     0.200
     0.191    -0.027     0.200
     0.282     0.103     0.200
     0.293     0.082     0.200
     0.398    -0.042     0.200
     0.451     0.170     0.200
     0.467     0.265     0.200
     0.522    -0.347     0.200
     0.652     0.326     0.200
     0.661     0.444     0.200
     0.725     0.351     0.200
     0.107     0.007     0.200
     0.126    -0.110     0.200
     0.146     0.361     0.200
     0.153     0.126     0.200
     0.300    -0.324     0.200
     0.313     0.440     0.200
     0.324    -0.118     0.200
     0.515    -0.382     0.200
     0.540    -0.511     0.200
     0.621    -0.348     0.200
     0.160    -0.087     0.200
     0.290    -0.109     0.200
     0.297    -0.061     0.200
     0.301     0.614     0.200
     0.316     0.165     0.200
     0.352     0.169     0.200
     0.424     0.154     0.200
     0.460     0.148     0.200
     0.618     0.204     0.200
     0.697     0.162     0.200
     0.719     0.214     0.200
     0.737     0.621     0.200
     0.088     0.080     0.200
     0.177     0.267     0.200
     0.223     0.256     0.200
     0.230    -0.065     0.200
     0.295     0.438     0.200
     0.335     0.326     0.200
     0.368     0.401     0.200
     0.368    -0.150     0.200
     0.489     0.098     0.200
     0.585     0.136     0.200
     0.594     0.210     0.200
     0.030     0.040     0.200
     0.096     0.157     0.200
     0.151     0.288     0.200
     0.195     0.019     0.200
     0.250     0.238     0.200
     0.248     0.329     0.200
     0.328    -0.056     0.200
     0.478     0.455     0.200
     0.507     0.024     0.200
     0.516     0.051     0.200
     0.065     0.326     0.200
     0.201     0.244     0.200
     0.261     0.361     0.200
     0.277     0.175     0.200
     0.278     0.403     0.200
     0.279     0.289     0.200
     0.331    -0.021     0.200
     0.375     0.520     0.200
     0.389     0.486     0.200
     0.502    -0.083     0.200
     0.553     0.122     0.200
     0.596     0.512     0.200
     0.618    -0.007     0.200
     0.630     0.243     0.200
     0.702     0.312     0.200
     0.707    -0.201     0.200
     0.732    -0.250     0.200
     0.703     0.245     0.200
     0.767     0.298     0.200
     0.778    -0.474     0.200
     0.825    -0.124     0.200
     0.827    -0.198     0.200
     0.827     0.907     0.200
     0.855     0.313     0.200
     0.996     0.386     0.200
     0.054    -0.142     0.200
     0.206     0.025     0.200
     0.271     0.164     0.200
     0.266     0.284     0.200
     0.267     0.201     0.200
     0.282     0.009     0.200
     0.322    -0.007     0.200
     0.364     0.378     0.200
     0.377     0.324     0.200
     0.541     0.094     0.200
     0.588     0.339     0.200
     0.620     0.612     0.200
     0.631     0.140     0.200
     0.693     0.408     0.200
     0.717    -0.225     0.200
     0.779     0.502     0.200
     0.835     0.138     0.200
     0.839     0.015     0.200
     0.973    -0.181     0.200
     0.059     0.103     0.200
     0.203     0.103     0.200
     0.266     0.227     0.200
     0.279     0.076     0.200
     0.272     0.262     0.200
     0.273     0.448     0.200
     0.327    -0.108     0.200
     0.369     0.398     0.200
     0.383    -0.237     0.200
     0.547     0.297     0.200
     0.592     0.377     0.200
     0.624     0.219     0.200
     0.624     0.036     0.200
     0.625     0.569     0.200
     0.698     0.635     0.200
     0.773     0.438     0.200
     0.045     0.035     0.200
     0.200     0.083     0.200
     0.259     0.534     0.200
     0.265     0.276     0.200
     0.270     0.185     0.200
     0.276     0.048     0.200
     0.326    -0.127     0.200
     0.355     0.445     0.200
     0.372     0.597     0.200
     0.513     0.067     0.200
     0.533     0.265     0.200
     0.578     0.185     0.200
     0.683     0.183     0.200
     0.067     0.283     0.200
     0.133    -0.003     0.200
     0.191     0.323     0.200
     0.205    -0.156     0.200
     0.205     0.215     0.200
     0.317     0.348     0.200
     0.409     0.033     0.200
     0.423    -0.175     0.200
     0.483     0.323     0.200
     0.498     0.088     0.200
     0.563     0.164     0.200
     0.586     0.590     0.200
     0.060     0.034     0.200
     0.202    -0.057     0.200
     0.265     0.138     0.200
     0.278    -0.136     0.200
     0.273     0.272     0.200
     0.274     0.232     0.200
     0.328    -0.043     0.200
     0.369     0.250     0.200
     0.384    -0.062     0.200
     0.592     0.149     0.200
     0.623     0.042     0.200
     0.772     0.643     0.200
     0.051     0.057     0.200
     0.204     0.100     0.200
     0.264     0.285     0.200
     0.271     0.232     0.200
     0.266     0.130     0.200
     0.280     0.065     0.200
     0.323     0.006     0.200
     0.361     0.468     0.200
     0.375     0.250     0.200
     0.513    -0.200     0.200
     0.538     0.238     0.200
     0.584     0.450     0.200
     0.616     0.528     0.200
     0.632     0.234     0.200
     0.717    -0.421     0.200
     0.781     0.094     0.200
     0.785    -0.455     0.200
     0.820     0.124     0.200
     0.841     0.262     0.200
     0.039     0.053     0.200
     0.187     0.094     0.200
     0.252     0.125     0.200
     0.263     0.024     0.200
     0.264     0.066     0.200
     0.268     0.166     0.200
     0.346     0.198     0.200
     0.336    -0.085     0.200
     0.372     0.341     0.200
     0.527     0.381     0.200
     0.565    -0.311     0.200
     0.051    -0.072     0.200
     0.206     0.112     0.200
     0.264     0.247     0.200
     0.273     0.239     0.200
     0.264     0.294     0.200
     0.282     0.143     0.200
     0.321    -0.083     0.200
     0.361     0.459     0.200
     0.374     0.270     0.200
     0.515    -0.100     0.200
     0.538     0.247     0.200
     0.586     0.560     0.200
     0.617     0.431     0.200
     0.633     0.063     0.200
     0.633     0.176     0.200
     0.690     0.408     0.200
     0.719    -0.231     0.200
     0.787    -0.803     0.200
     0.782     0.238     0.200
     0.072     0.185     0.200
     0.103    -0.039     0.200
     0.182     0.302     0.200
     0.230     0.187     0.200
     0.245     0.006     0.200
     0.338     0.128     0.200
     0.425    -0.125     0.200
     0.449     0.012     0.200
     0.523     0.361     0.200
     0.575     0.068     0.200
     0.607     0.618     0.200
     0.607     0.317     0.200
     0.043     0.045     0.200
     0.209     0.033     0.200
     0.255     0.259     0.200
     0.256     0.225     0.200
     0.280     0.148     0.200
     0.286     0.009     0.200
     0.316    -0.101     0.200
     0.353     0.455     0.200
     0.365     0.288     0.200
     0.522    -0.053     0.200
     0.529     0.144     0.200
     0.579     0.243     0.200
     0.609     0.277     0.200
     0.642     0.035     0.200
     0.642    -0.176     0.200
     0.682     0.294     0.200
     0.696     0.490     0.200
     0.726    -0.320     0.200
     0.791    -0.029     0.200
     0.792    -0.320     0.200
     0.819     0.267     0.200
     0.843     0.378     0.200
     0.851     0.318     0.200
     0.045    -0.249     0.200
     0.198     0.491     0.200
     0.259    -0.090     0.200
     0.265     0.086     0.200
     0.275    -0.133     0.200
     0.327    -0.005     0.200
     0.355     0.029     0.200
     0.373    -0.030     0.200
     0.633    -0.158     0.200
     0.683     0.252     0.200
     0.784     0.152     0.200
     0.842     0.118     0.200
     0.259     0.330     0.200
     0.327     0.295     0.200
     0.355     0.529     0.200
     0.355     0.789     0.200
     0.373     0.170     0.200
     0.533     0.462     0.200
     0.577     0.767     0.200
     0.055    -0.079     0.200
     0.218     0.012     0.200
     0.274     0.094     0.200
     0.278     0.212     0.200
     0.385     0.129     0.200
     0.466     0.368     0.200
     0.557    -0.062     0.200
     0.620     0.310     0.200
     0.654     0.184     0.200
     0.063    -0.016     0.200
     0.195     0.267     0.200
     0.271     0.179     0.200
     0.276     0.164     0.200
     0.372     0.195     0.200
     0.390     0.112     0.200
     0.459    -0.285     0.200
     0.447     0.172     0.200
     0.498     0.071     0.200
     0.595    -0.070     0.200
     0.617     0.460     0.200
     0.618     0.211     0.200
     0.626     0.107     0.200
     0.695     0.319     0.200
     0.767     0.062     0.200
     0.825     0.171     0.200
     0.049     0.054     0.200
     0.199     0.180     0.200
     0.268     0.313     0.200
     0.262     0.324     0.200
     0.275     0.397     0.200
     0.359     0.330     0.200
     0.376    -0.055     0.200
     0.451     0.048     0.200
     0.473    -0.104     0.200
     0.510    -0.029     0.200
     0.608    -0.038     0.200
     0.614     0.364     0.200
     0.631     0.152     0.200
     0.632     0.247     0.200
     0.781     0.182     0.200
     0.781     0.001     0.200
     0.840     0.229     0.200
     0.530    -0.414     0.200
     0.628     0.221     0.200
     0.083     0.186     0.200
     0.180     0.070     0.200
     0.231     0.190     0.200
     0.257     0.131     0.200
     0.310     0.117     0.200
     0.292     0.238     0.200
     0.361     0.266     0.200
     0.539    -0.306     0.200
     0.585     0.092     0.200
     0.605    -0.108     0.200
     0.568     0.024     0.200
     0.629     0.860     0.200
     0.750     0.024     0.200
     0.895     0.277     0.200
     0.912    -0.058     0.200
     0.900     0.282     0.200
     0.901    -0.294     0.200
     0.838     0.006     0.200
     0.089     0.271     0.200
     0.089     0.402     0.200
     0.161     0.142     0.200
     0.236     0.124     0.200
     0.256    -0.151     0.200
     0.295     0.074     0.200
     0.321    -0.003     0.200
     0.367    -0.025     0.200
     0.511     0.134     0.200
     0.514     0.080     0.200
     0.665     0.155     0.200
     0.785     0.021     0.200
     0.802     0.054     0.200
     0.881     0.452     0.200
     0.111     0.314     0.200
     0.262    -0.111     0.200
     0.263     0.194     0.200
     0.284     0.260     0.200
     0.304     0.236     0.200
     0.562     0.074     0.200
     0.608     0.041     0.200
     0.658    -0.075     0.200
     0.646     0.545     0.200
     0.671     0.058     0.200
     0.808    -0.321     0.200
     0.818    -0.054     0.200
     0.961    -0.033     0.200
     0.981     0.279     0.200
     0.023     0.158     0.200
     0.138     0.103     0.200
     0.191     0.150     0.200
     0.231     0.084     0.200
     0.308     0.180     0.200
     0.318    -0.122     0.200
     0.484     0.030     0.200
     0.489     0.275     0.200
     0.585    -0.334     0.200
     0.732    -0.025     0.200
     0.795    -0.122     0.200
     0.211     0.074     0.200
     0.297     0.273     0.200
     0.410     0.035     0.200
     0.412     0.120     0.200
     0.447     0.158     0.200
     0.468     0.115     0.200
     0.486    -0.061     0.200
     0.616    -0.047     0.200
     0.654    -0.102     0.200
     0.663     0.081     0.200
     0.701     0.044     0.200
     0.786    -0.240     0.200
     0.992     0.362     0.200
     0.632     0.892     0.200
     0.672     0.585     0.200
     0.061     0.089     0.200
     0.206     0.199     0.200
     0.268     0.419     0.200
     0.273     0.118     0.200
     0.282     0.156     0.200
     0.371     0.419     0.200
     0.382     0.185     0.200
     0.466    -0.293     0.200
     0.452     0.096     0.200
     0.458     0.202     0.200
     0.597     0.009     0.200
     0.624     0.262     0.200
     0.625     0.057     0.200
     0.833     0.106     0.200
     0.048    -0.004     0.200
     0.199     0.171     0.200
     0.262     0.405     0.200
     0.269     0.335     0.200
     0.276     0.175     0.200
     0.358     0.563     0.200
     0.375     0.176     0.200
     0.440     0.217     0.200
     0.452    -0.044     0.200
     0.474    -0.578     0.200
     0.511    -0.127     0.200
     0.609    -0.148     0.200
     0.631     0.148     0.200
     0.633    -0.148     0.200
     0.686     0.332     0.200
     0.691     0.452     0.200
     0.781     0.240     0.200
     0.782     0.066     0.200
     0.815     0.366     0.200
     0.840     0.320     0.200
     0.202     0.002     0.200
     0.262     0.515     0.200
     0.278     0.173     0.200
     0.279     0.095     0.200
     0.330     0.064     0.200
     0.375     0.111     0.200
     0.389     0.253     0.200
     0.459    -0.389     0.200
     0.452     0.449     0.200
     0.454    -0.065     0.200
     0.502    -0.463     0.200
     0.617     0.191     0.200
     0.618     0.210     0.200
     0.631    -0.100     0.200
     0.703     0.389     0.200
     0.766     0.031     0.200
     0.780     0.260     0.200
     0.827    -0.067     0.200
     0.546    -0.249     0.200
     0.199     0.160     0.200
     0.262     0.079     0.200
     0.274     0.096     0.200
     0.275     0.169     0.200
     0.370     0.588     0.200
     0.386     0.183     0.200
     0.446    -0.107     0.200
     0.463    -0.207     0.200
     0.451     0.166     0.200
     0.625     0.040     0.200
     0.621     0.165     0.200
     0.621     0.040     0.200
     0.698     0.356     0.200
     0.778     0.205     0.200
     0.213     0.134     0.200
     0.277     0.379     0.200
     0.289     0.277     0.200
     0.375     0.464     0.200
     0.383     0.578     0.200
     0.466     0.204     0.200
     0.460    -0.134     0.200
     0.512    -0.128     0.200
     0.592     0.210     0.200
     0.602     0.126     0.200
     0.622     0.224     0.200
     0.625     0.171     0.200
     0.632     0.026     0.200
     0.705     0.339     0.200
     0.771     0.221     0.200
     0.790     0.308     0.200
     0.833     0.084     0.200
     0.836     0.810     0.200
     0.052     0.283     0.200
     0.128     0.386     0.200
     0.168     0.319     0.200
     0.202     0.052     0.200
     0.239    -0.211     0.200
     0.302    -0.238     0.200
     0.326    -0.027     0.200
     0.406     0.135     0.200
     0.554     0.320     0.200
     0.551    -0.205     0.200
     0.631    -0.076     0.200
     0.690     0.824     0.200
     0.697     0.368     0.200
     0.797     0.453     0.200
     0.839    -0.367     0.200
     0.919     0.454     0.200
     0.271     0.414     0.200
     0.266     0.322     0.200
     0.267     0.196     0.200
     0.281     0.167     0.200
     0.323     0.040     0.200
     0.363     0.373     0.200
     0.376     0.256     0.200
     0.447     0.195     0.200
     0.472    -0.063     0.200
     0.457     0.015     0.200
     0.458     0.207     0.200
     0.512    -0.449     0.200
     0.540     0.189     0.200
     0.587     0.150     0.200
     0.603     0.233     0.200
     0.604     0.302     0.200
     0.599    -0.069     0.200
     0.619     0.211     0.200
     0.631     0.014     0.200
     0.692     0.281     0.200
     0.698    -0.031     0.200
     0.717    -0.200     0.200
     0.779     0.443     0.200
     0.785     0.563     0.200
     0.834    -0.001     0.200
     0.839     0.103     0.200
     0.533    -0.421     0.200
     0.631     0.143     0.200
     0.036     0.079     0.200
     0.127     0.100     0.200
     0.202     0.096     0.200
     0.230     0.232     0.200
     0.253     0.100     0.200
     0.299     0.108     0.200
     0.304    -0.280     0.200
     0.375     0.432     0.200
     0.447    -0.746     0.200
     0.496     0.008     0.200
     0.502     0.118     0.200
     0.516     0.025     0.200
     0.720    -0.143     0.200
     0.723    -0.103     0.200
     0.743     0.070     0.200
     0.802    -0.391     0.200
     0.061    -0.267     0.200
     0.142    -0.245     0.200
     0.369    -0.210     0.200
     0.374     0.051     0.200
     0.395     0.022     0.200
     0.420    -0.692     0.200
     0.533     0.163     0.200
     0.562     0.178     0.200
     0.572    -0.378     0.200
     0.802     0.496     0.200
     0.972     0.184     0.200
     0.063     0.172     0.200
     0.091     0.162     0.200
     0.177     0.154     0.200
     0.186     0.089     0.200
     0.252     0.481     0.200
     0.292     0.017     0.200
     0.323     0.173     0.200
     0.309    -0.030     0.200
     0.393    -0.485     0.200
     0.448    -0.136     0.200
     0.488     0.275     0.200
     0.506    -0.022     0.200
     0.527     0.086     0.200
     0.587     0.095     0.200
     0.613    -0.076     0.200
     0.620    -0.116     0.200
     0.669    -0.199     0.200
     0.675    -0.151     0.200
     0.682     0.276     0.200
     0.690    -0.226     0.200
     0.713     0.041     0.200
     0.736     0.022     0.200
     0.055     0.314     0.200
     0.099     0.139     0.200
     0.180     0.103     0.200
     0.180     0.155     0.200
     0.260     0.249     0.200
     0.284     0.101     0.200
     0.316    -0.205     0.200
     0.330    -0.102     0.200
     0.398    -0.827     0.200
     0.449    -0.230     0.200
     0.484     0.098     0.200
     0.498     0.100     0.200
     0.508     0.008     0.200
     0.535    -0.178     0.200
     0.587    -0.262     0.200
     0.608    -0.024     0.200
     0.623    -0.363     0.200
     0.676    -0.569     0.200
     0.680    -0.298     0.200
     0.683    -0.213     0.200
     0.684    -0.073     0.200
     0.695    -0.192     0.200
     0.715    -0.156     0.200
     0.727     0.133     0.200
     0.762     0.018     0.200
     0.775     0.230     0.200
     0.852     0.035     0.200
     0.865     0.149     0.200
     0.929     0.589     0.200
     0.944     0.506     0.200
     0.983     0.184     0.200
     0.315    -0.064     0.200
     0.060     0.201     0.200
     0.092     0.202     0.200
     0.180     0.079     0.200
     0.187    -0.006     0.200
     0.255     0.248     0.200
     0.290    -0.052     0.200
     0.308     0.022     0.200
     0.397    -0.628     0.200
     0.451    -0.238     0.200
     0.490     0.233     0.200
     0.506    -0.299     0.200
     0.590    -0.011     0.200
     0.615    -0.157     0.200
     0.623    -0.057     0.200
     0.672    -0.223     0.200
     0.678    -0.083     0.200
     0.685     0.139     0.200
     0.692     0.501     0.200
     0.717    -0.040     0.200
     0.767    -0.038     0.200
     0.976     0.495     0.200
     0.090    -0.008     0.200
     0.105    -0.258     0.200
     0.216     0.162     0.200
     0.260     0.501     0.200
     0.293     0.005     0.200
     0.348     0.188     0.200
     0.335    -0.044     0.200
     0.369    -0.273     0.200
     0.362    -0.195     0.200
     0.375     0.204     0.200
     0.383    -0.429     0.200
     0.498     0.018     0.200
     0.516    -0.018     0.200
     0.554    -0.128     0.200
     0.561    -0.737     0.200
     0.613    -0.482     0.200
     0.834     0.470     0.200
     0.882    -0.522     0.200
     0.931     0.028     0.200
     0.090     0.367     0.200
     0.170     0.129     0.200
     0.188     0.102     0.200
     0.262     0.213     0.200
     0.310     0.017     0.200
     0.323     0.270     0.200
     0.330     0.179     0.200
     0.323     0.344     0.200
     0.385     0.708     0.200
     0.442    -0.458     0.200
     0.409     0.286     0.200
     0.434     0.518     0.200
     0.534     0.032     0.200
     0.610    -0.117     0.200
     0.582     0.133     0.200
     0.639    -0.211     0.200
     0.674     0.039     0.200
     0.734     0.578     0.200
     0.767     0.013     0.200
     0.792    -0.486     0.200
     0.810    -0.212     0.200
     0.834    -0.231     0.200
     0.897    -0.157     0.200
     0.119    -0.279     0.200
     0.228    -0.272     0.200
     0.210     0.432     0.200
     0.247    -0.095     0.200
     0.272    -0.337     0.200
     0.389    -0.281     0.200
     0.384    -0.125     0.200
     0.476    -0.264     0.200
     0.527     0.005     0.200
     0.545     0.122     0.200
     0.551    -0.304     0.200
     0.661    -0.186     0.200
     0.703    -0.078     0.200
     0.719    -0.383     0.200
     0.846    -0.218     0.200
     0.828     0.438     0.200
     0.971    -0.052     0.200
     0.207     0.115     0.200
     0.268     0.286     0.200
     0.283     0.024     0.200
     0.272     0.240     0.200
     0.274     0.302     0.200
     0.324     0.021     0.200
     0.371     0.351     0.200
     0.383     0.290     0.200
     0.466    -0.145     0.200
     0.452     0.101     0.200
     0.453    -0.016     0.200
     0.459    -0.023     0.200
     0.509    -0.003     0.200
     0.548     0.204     0.200
     0.596    -0.153     0.200
     0.602     0.142     0.200
     0.595     0.325     0.200
     0.623    -0.036     0.200
     0.625    -0.119     0.200
     0.627     0.131     0.200
     0.704    -0.104     0.200
     0.700     0.179     0.200
     0.714    -0.264     0.200
     0.735    -0.259     0.200
     0.772    -0.025     0.200
     0.785     0.332     0.200
     0.832     0.114     0.200
     0.833    -0.013     0.200
     0.829     0.037     0.200
     0.969     0.112     0.200
     0.541    -0.251     0.200
     0.639     0.191     0.200
     0.615     0.021     0.200
     0.061     0.048     0.200
     0.174     0.535     0.200
     0.196    -0.092     0.200
     0.241     0.536     0.200
     0.320    -0.023     0.200
     0.429    -0.383     0.200
     0.480    -0.117     0.200
     0.490    -0.005     0.200
     0.487    -0.174     0.200
     0.512    -0.160     0.200
     0.716    -0.105     0.200
     0.757    -0.713     0.200
     0.050    -0.127     0.200
     0.129    -0.043     0.200
     0.247     0.398     0.200
     0.277     0.047     0.200
     0.294     0.214     0.200
     0.354     0.185     0.200
     0.374    -0.367     0.200
     0.394    -0.536     0.200
     0.458     0.208     0.200
     0.592    -0.473     0.200
     0.805    -0.116     0.200
     0.835    -0.155     0.200
     0.908    -0.460     0.200
     0.959    -0.490     0.200
     0.099     0.594     0.200
     0.236     0.149     0.200
     0.241     0.166     0.200
     0.236     0.234     0.200
     0.334     0.228     0.200
     0.389    -0.226     0.200
     0.376     0.042     0.200
     0.370     0.188     0.200
     0.378     0.115     0.200
     0.445    -0.179     0.200
     0.451     0.234     0.200
     0.513    -0.122     0.200
     0.528    -0.089     0.200
     0.594     0.157     0.200
     0.598    -0.021     0.200
     0.582     0.646     0.200
     0.740    -0.329     0.200
     0.715     0.454     0.200
     0.755     0.097     0.200
     0.743     0.442     0.200
     0.756     1.013     0.200
     0.795    -0.400     0.200
     0.784     0.748     0.200
     0.825     0.090     0.200
     0.953    -0.477     0.200
     0.951    -0.368     0.200
     0.996    -0.321     0.200
     0.135     0.185     0.200
     0.212     0.154     0.200
     0.220     0.403     0.200
     0.296     0.264     0.200
     0.320     0.441     0.200
     0.354    -0.468     0.200
     0.372    -0.147     0.200
     0.427     0.556     0.200
     0.547    -0.375     0.200
     0.594    -0.166     0.200
     0.636    -0.324     0.200
     0.612     0.357     0.200
     0.863    -0.166     0.200
     0.912    -0.252     0.200
     0.943    -0.298     0.200
     0.081     0.554     0.200
     0.184    -0.045     0.200
     0.231     0.128     0.200
     0.251     0.329     0.200
     0.262     0.148     0.200
     0.361     0.030     0.200
     0.406     0.421     0.200
     0.491     0.160     0.200
     0.552     0.134     0.200
     0.591     0.633     0.200
     0.634     0.428     0.200
     0.641     0.564     0.200
     0.657    -0.047     0.200
     0.926    -0.679     0.200
     0.943    -0.160     0.200
     0.944    -0.237     0.200
     0.987    -0.310     0.200
     0.099     0.279     0.200
     0.175     0.331     0.200
     0.246     0.410     0.200
     0.241     0.127     0.200
     0.309    -0.306     0.200
     0.307     0.499     0.200
     0.349     0.285     0.200
     0.378    -0.040     0.200
     0.373     0.227     0.200
     0.592    -0.027     0.200
     0.587    -0.169     0.200
     0.604    -0.441     0.200
     0.584     0.428     0.200
     0.639     0.333     0.200
     0.646     1.240     0.200
     0.740    -0.615     0.200
     0.873    -0.373     0.200
     0.896    -0.523     0.200
     0.040    -0.222     0.200
     0.223     0.161     0.200
     0.297    -0.149     0.200
     0.306     0.351     0.200
     0.397    -0.117     0.200
     0.435    -0.098     0.200
     0.505    -0.435     0.200
     0.502    -0.305     0.200
     0.486     0.604     0.200
     0.630    -0.816     0.200
     0.598     0.069     0.200
     0.611     0.373     0.200
     0.753    -0.215     0.200
     0.787    -0.267     0.200
     0.837    -0.362     0.200
     0.896     0.046     0.200
     0.900    -0.548     0.200
     0.112     0.274     0.200
     0.144     0.089     0.200
     0.177     0.528     0.200
     0.238     0.070     0.200
     0.254    -0.003     0.200
     0.255     0.153     0.200
     0.367    -0.165     0.200
     0.401     0.089     0.200
     0.478    -0.041     0.200
     0.508    -0.373     0.200
     0.539     0.194     0.200
     0.552    -0.163     0.200
     0.606    -0.246     0.200
     0.621     0.030     0.200
     0.636    -0.081     0.200
     0.661    -0.369     0.200
     0.743    -0.076     0.200
     0.772    -0.162     0.200
     0.792     0.326     0.200
     0.787    -0.422     0.200
     0.805     0.070     0.200
     0.865    -0.071     0.200
     0.196    -0.194     0.200
     0.261     0.099     0.200
     0.272     0.084     0.200
     0.271     0.337     0.200
     0.276     0.195     0.200
     0.332    -0.061     0.200
     0.366     0.267     0.200
     0.384     0.327     0.200
     0.442     0.104     0.200
     0.448    -0.054     0.200
     0.465    -0.097     0.200
     0.449     0.173     0.200
     0.503    -0.022     0.200
     0.545     0.232     0.200
     0.593     0.128     0.200
     0.587     0.412     0.200
     0.601     0.037     0.200
     0.622     0.048     0.200
     0.624     0.054     0.200
     0.621     0.112     0.200
     0.693     0.086     0.200
     0.694     0.171     0.200
     0.707     0.042     0.200
     0.773     0.023     0.200
     0.818     0.382     0.200
     0.824     0.066     0.200
     0.964    -0.113     0.200
     0.142     0.236     0.200
     0.127     0.396     0.200
     0.281    -0.074     0.200
     0.255     0.397     0.200
     0.276     0.166     0.200
     0.346    -0.189     0.200
     0.360     0.279     0.200
     0.339     0.468     0.200
     0.358     0.113     0.200
     0.405     0.205     0.200
     0.506    -0.073     0.200
     0.557    -0.241     0.200
     0.563    -0.158     0.200
     0.574    -0.320     0.200
     0.602     0.423     0.200
     0.611     0.433     0.200
     0.665     0.591     0.200
     0.704    -0.178     0.200
     0.706     0.257     0.200
     0.672     0.499     0.200
     0.790    -0.027     0.200
     0.797    -0.252     0.200
     0.841    -0.198     0.200
     0.865    -0.194     0.200
     0.853     0.554     0.200
     0.870    -0.246     0.200
     0.886    -0.225     0.200
     0.895    -0.357     0.200
     0.855    -0.385     0.200
     0.870     0.030     0.200
     0.118     0.052     0.200
     0.217     0.198     0.200
     0.327     0.087     0.200
     0.347    -0.296     0.200
     0.346     0.240     0.200
     0.364     0.059     0.200
     0.698    -0.242     0.200
     0.783    -0.007     0.200
     0.170     0.325     0.200
     0.199     0.223     0.200
     0.223     0.311     0.200
     0.299     0.409     0.200
     0.351    -0.185     0.200
     0.364    -0.306     0.200
     0.461    -0.049     0.200
     0.553    -0.213     0.200
     0.579     0.337     0.200
     0.612     0.268     0.200
     0.638    -0.048     0.200
     0.655    -0.031     0.200
     0.770    -0.059     0.200
     0.770     0.195     0.200
     0.779    -0.404     0.200
     0.770     0.161     0.200
     0.788    -0.121     0.200
     0.788    -0.194     0.200
     0.803     0.554     0.200
     0.837    -0.405     0.200
     0.860     0.189     0.200
     0.853     0.243     0.200
     0.870    -0.108     0.200
     0.943     0.005     0.200
     0.959    -0.121     0.200
     0.981    -0.073     0.200
     0.996     0.399     0.200
     0.351    -0.021     0.200
     0.364     0.084     0.200
     0.461    -0.213     0.200
     0.579     0.486     0.200
     0.655     0.071     0.200
     0.770     0.074     0.200
     0.779    -0.255     0.200
     0.837    -0.046     0.200
     0.870     0.525     0.200
     0.959     0.199     0.200
     0.981     0.075     0.200
     0.212     0.467     0.200
     0.763     0.171     0.200
     0.135     0.216     0.200
     0.134     0.475     0.200
     0.213     0.184     0.200
     0.289     0.024     0.200
     0.302    -0.310     0.200
     0.312     0.035     0.200
     0.398    -0.232     0.200
     0.489    -0.335     0.200
     0.578    -0.538     0.200
     0.579     0.189     0.200
     0.596     0.136     0.200
     0.613     0.051     0.200
     0.713     0.059     0.200
     0.720    -0.170     0.200
     0.725    -0.405     0.200
     0.727    -0.346     0.200
     0.733     0.197     0.200
     0.773     0.024     0.200
     0.787     0.137     0.200
     0.782     0.069     0.200
     0.810    -0.258     0.200
     0.853     0.298     0.200
     0.892     0.186     0.200
     0.925     0.221     0.200
     0.969     0.190     0.200
     0.968     0.377     0.200
     0.991     0.098     0.200
     0.996     0.277     0.200
     0.331     0.042     0.200
     0.320     0.190     0.200
     0.341     0.169     0.200
     0.358    -0.112     0.200
     0.417    -0.409     0.200
     0.409     0.026     0.200
     0.419     0.250     0.200
     0.459     0.133     0.200
     0.482     0.054     0.200
     0.527     0.164     0.200
     0.535    -0.150     0.200
     0.575    -0.082     0.200
     0.616     0.211     0.200
     0.686     0.177     0.200
     0.687    -0.174     0.200
     0.692     0.263     0.200
     0.763     0.347     0.200
     0.787     0.117     0.200
     0.860     0.173     0.200
     0.868    -0.045     0.200
     0.894    -0.305     0.200
     0.868     0.049     0.200
     0.880     0.005     0.200
     0.917     0.062     0.200
     0.093     0.052     0.200
     0.230     0.322     0.200
     0.252     0.303     0.200
     0.293     0.092     0.200
     0.306     0.512     0.200
     0.353     0.073     0.200
     0.379    -0.071     0.200
     0.479     0.155     0.200
     0.588    -0.061     0.200
     0.590     0.065     0.200
     0.578     0.217     0.200
     0.108     0.302     0.200
     0.133    -0.181     0.200
     0.229     0.095     0.200
     0.232     0.082     0.200
     0.343     0.197     0.200
     0.391    -0.025     0.200
     0.466     0.056     0.200
     0.470    -0.032     0.200
     0.460     0.562     0.200
     0.568     0.264     0.200
     0.594     0.116     0.200
     0.610     0.293     0.200
     0.641    -0.183     0.200
     0.667     0.274     0.200
     0.711    -0.047     0.200
     0.813     0.153     0.200
     0.939     0.257     0.200
     0.979     0.309     0.200
     0.111     0.237     0.200
     0.135     0.697     0.200
     0.279     0.512     0.200
     0.317     0.131     0.200
     0.398     0.076     0.200
     0.480     0.086     0.200
     0.521    -0.005     0.200
     0.664    -0.012     0.200
     0.733    -0.289     0.200
     0.745     0.159     0.200
     0.783    -0.074     0.200
     0.021     0.138     0.200
     0.173     0.128     0.200
     0.172    -0.014     0.200
     0.271     0.282     0.200
     0.349     0.128     0.200
     0.447    -0.004     0.200
     0.501     0.372     0.200
     0.517     0.335     0.200
     0.539     0.792     0.200
     0.552     0.097     0.200
     0.572     0.398     0.200
     0.219     0.293     0.200
     0.228    -0.065     0.200
     0.281     0.060     0.200
     0.309    -0.036     0.200
     0.342     0.505     0.200
     0.361    -0.055     0.200
     0.385     0.130     0.200
     0.393     0.192     0.200
     0.524    -0.279     0.200
     0.538    -0.132     0.200
     0.561    -0.090     0.200
     0.642     0.194     0.200
     0.653     0.243     0.200
     0.691    -0.072     0.200
     0.703     0.047     0.200
     0.726     0.504     0.200
     0.886     0.116     0.200
     0.927    -0.087     0.200
     0.153     0.115     0.200
     0.156     0.296     0.200
     0.177     0.146     0.200
     0.204     0.203     0.200
     0.422     0.191     0.200
     0.452     0.329     0.200
     0.449     0.321     0.200
     0.469    -0.403     0.200
     0.475     0.238     0.200
     0.546    -0.451     0.200
     0.601     0.359     0.200
     0.606     0.083     0.200
     0.613     0.540     0.200
     0.662    -0.116     0.200
     0.688     0.713     0.200
     0.688     0.446     0.200
     0.731     0.215     0.200
     0.792     0.334     0.200
     0.874    -0.248     0.200
     0.864     0.063     0.200
     0.874    -0.245     0.200
     0.071     0.142     0.200
     0.144    -0.349     0.200
     0.141     0.505     0.200
     0.449     0.190     0.200
     0.481     0.256     0.200
     0.466     0.310     0.200
     0.451     0.358     0.200
     0.569    -0.182     0.200
     0.691     0.372     0.200
     0.735    -0.277     0.200
     0.017     0.219     0.200
     0.161    -0.156     0.200
     0.223     0.225     0.200
     0.221     0.161     0.200
     0.322     0.202     0.200
     0.357    -0.057     0.200
     0.386    -0.376     0.200
     0.445    -0.076     0.200
     0.450     0.172     0.200
     0.449    -0.179     0.200
     0.469     0.219     0.200
     0.585     0.122     0.200
     0.601     0.356     0.200
     0.595    -0.213     0.200
     0.639     0.576     0.200
     0.662    -0.305     0.200
     0.678    -0.275     0.200
     0.666     0.193     0.200
     0.719     0.193     0.200
     0.741    -0.127     0.200
     0.734    -0.291     0.200
     0.745    -0.307     0.200
     0.743    -0.130     0.200
     0.763     0.539     0.200
     0.818     0.811     0.200
     0.802     0.177     0.200
     0.883     0.526     0.200
     0.936    -0.200     0.200
     0.116    -0.079     0.200
     0.256    -0.097     0.200
     0.275    -0.061     0.200
     0.316    -0.070     0.200
     0.365     0.280     0.200
     0.433     0.243     0.200
     0.422     0.062     0.200
     0.465    -0.321     0.200
     0.467     0.165     0.200
     0.443     0.479     0.200
     0.479    -0.043     0.200
     0.516    -0.205     0.200
     0.501    -0.286     0.200
     0.580     0.368     0.200
     0.624    -0.214     0.200
     0.617    -0.033     0.200
     0.630    -0.131     0.200
     0.660    -0.277     0.200
     0.662     0.039     0.200
     0.685    -0.262     0.200
     0.703    -0.481     0.200
     0.702    -0.179     0.200
     0.682     0.449     0.200
     0.790    -0.085     0.200
     0.858    -0.157     0.200
     0.838     0.529     0.200
     0.876    -0.122     0.200
     0.879    -0.274     0.200
     0.913     0.312     0.200
     0.981    -0.193     0.200
     0.359     1.424     0.200
     0.621    -0.348     0.200
     0.087     0.118     0.200
     0.135     0.256     0.200
     0.172    -0.232     0.200
     0.169    -0.275     0.200
     0.223     0.260     0.200
     0.308    -0.339     0.200
     0.405     0.742     0.200
     0.469     0.377     0.200
     0.463     0.254     0.200
     0.495     1.125     0.200
     0.589    -0.491     0.200
     0.607    -0.429     0.200
     0.609     0.775     0.200
     0.643    -0.119     0.200
     0.676    -0.325     0.200
     0.717     0.556     0.200
     0.778     0.227     0.200
     0.160    -0.121     0.200
     0.209    -0.420     0.200
     0.228     0.248     0.200
     0.322     0.080     0.200
     0.311    -0.526     0.200
     0.345     0.195     0.200
     0.333     0.029     0.200
     0.374    -0.147     0.200
     0.448     0.037     0.200
     0.483     0.021     0.200
     0.635     0.471     0.200
     0.695     0.630     0.200
     0.704     0.331     0.200
     0.874    -0.422     0.200
     0.865     0.084     0.200
     0.886     0.668     0.200
     0.927     0.048     0.200
     0.043     0.447     0.200
     0.174     0.011     0.200
     0.190    -0.105     0.200
     0.264    -0.345     0.200
     0.357     0.100     0.200
     0.362    -0.204     0.200
     0.425    -0.582     0.200
     0.447     0.464     0.200
     0.485     0.223     0.200
     0.602    -0.530     0.200
     0.632     0.013     0.200
     0.645     0.318     0.200
     0.773     0.052     0.200
     0.779     0.096     0.200
     0.780    -0.032     0.200
     0.792     0.042     0.200
     0.786     0.302     0.200
     0.827     0.613     0.200
     0.076     0.228     0.200
     0.226    -0.277     0.200
     0.278    -0.378     0.200
     0.387     0.139     0.200
     0.392     0.403     0.200
     0.407     0.104     0.200
     0.499    -0.069     0.200
     0.571     0.163     0.200
     0.604     0.382     0.200
     0.658    -0.005     0.200
     0.665     0.397     0.200
     0.745     0.123     0.200
     0.773    -0.217     0.200
     0.775     0.113     0.200
     0.790    -0.157     0.200
     0.796     0.679     0.200
     0.807     0.308     0.200
     0.820     0.021     0.200
     0.054    -0.037     0.200
     0.123    -0.553     0.200
     0.217     0.260     0.200
     0.226    -0.028     0.200
     0.244    -0.205     0.200
     0.244    -0.230     0.200
     0.313     0.184     0.200
     0.362     0.017     0.200
     0.386     0.126     0.200
     0.395     0.145     0.200
     0.466    -0.105     0.200
     0.626     0.035     0.200
     0.657     0.127     0.200
     0.676     0.234     0.200
     0.681     0.246     0.200
     0.749     0.174     0.200
     0.794     0.175     0.200
     0.796    -0.002     0.200
     0.117     0.075     0.200
     0.144    -0.101     0.200
     0.156     0.058     0.200
     0.164     0.023     0.200
     0.342     0.225     0.200
     0.385     0.132     0.200
     0.450     0.162     0.200
     0.500    -0.059     0.200
     0.550    -0.347     0.200
     0.591     0.339     0.200
     0.650     0.240     0.200
     0.654    -0.036     0.200
     0.656     0.342     0.200
     0.704    -0.640     0.200
     0.717    -0.197     0.200
     0.727     0.077     0.200
     0.724    -0.160     0.200
     0.735    -0.228     0.200
     0.825     0.094     0.200
     0.252     0.664     0.200
     0.348     0.278     0.200
     0.449     0.077     0.200
     0.424     0.640     0.200
     0.468     0.095     0.200
     0.480     0.016     0.200
     0.679     0.225     0.200
     0.678     0.194     0.200
     0.759     0.005     0.200
     0.812     0.397     0.200
     0.910    -0.235     0.200
     0.953    -0.123     0.200
     0.233     0.188     0.200
     0.953     0.190     0.200
     0.453     0.004     0.200
     0.249     0.189     0.200
     0.234     0.269     0.200
     0.320    -0.065     0.200
     0.396    -0.204     0.200
     0.484     0.669     0.200
     0.494     0.528     0.200
     0.520    -0.101     0.200
     0.598    -0.201     0.200
     0.636    -0.443     0.200
     0.645    -0.131     0.200
     0.684     0.757     0.200
     0.741     0.110     0.200
     0.745    -0.165     0.200
     0.811    -0.197     0.200
     0.248     0.326     0.200
     0.252     0.059     0.200
     0.297     0.317     0.200
     0.339     0.057     0.200
     0.373     0.313     0.200
     0.370     0.233     0.200
     0.495    -0.628     0.200
     0.501     0.073     0.200
     0.540     0.169     0.200
     0.548     0.094     0.200
     0.572    -0.405     0.200
     0.574     0.072     0.200
     0.570    -0.086     0.200
     0.663     0.041     0.200
     0.657     0.331     0.200
     0.673     0.223     0.200
     0.746     0.178     0.200
     0.780    -0.031     0.200
     0.823    -0.008     0.200
     0.868     0.199     0.200
     0.870     0.027     0.200
     0.905    -0.090     0.200
     0.565    -0.715     0.200
     0.667     0.494     0.200
     0.055     0.212     0.200
     0.217     0.551     0.200
     0.240     0.522     0.200
     0.256     0.047     0.200
     0.220     0.761     0.200
     0.297     0.235     0.200
     0.404     0.043     0.200
     0.440     0.215     0.200
     0.436     0.059     0.200
     0.558     0.006     0.200
     0.641     0.003     0.200
     0.683    -0.087     0.200
     0.909     0.354     0.200
     0.287     0.120     0.200
     0.300    -0.055     0.200
     0.306     0.233     0.200
     0.359     0.469     0.200
     0.359     0.210     0.200
     0.435     0.298     0.200
     0.464     0.298     0.200
     0.512    -0.179     0.200
     0.523     0.178     0.200
     0.529     0.148     0.200
     0.554     0.536     0.200
     0.723     0.157     0.200
     0.797    -0.028     0.200
     0.836    -0.386     0.200
     0.148    -0.158     0.200
     0.239     0.216     0.200
     0.394     0.397     0.200
     0.544     0.177     0.200
     0.562     0.465     0.200
     0.629     0.552     0.200
     0.793     0.516     0.200
     0.943    -0.085     0.200
     0.113     0.338     0.200
     0.177     0.153     0.200
     0.242     0.089     0.200
     0.328    -0.148     0.200
     0.480    -0.207     0.200
     0.479     0.103     0.200
     0.478     0.169     0.200
     0.492    -0.066     0.200
     0.579    -0.287     0.200
     0.614     0.012     0.200
     0.610    -0.299     0.200
     0.662    -0.007     0.200
     0.668     0.067     0.200
     0.703     0.407     0.200
     0.749     0.552     0.200
     0.781     0.368     0.200
     0.821     0.244     0.200
     0.324    -0.530     0.200
     0.688    -0.196     0.200
     0.608     0.191     0.200
     0.163     0.118     0.200
     0.206     0.322     0.200
     0.236    -0.034     0.200
     0.316     0.433     0.200
     0.332     0.324     0.200
     0.384    -0.011     0.200
     0.393     0.027     0.200
     0.404     0.361     0.200
     0.435    -0.193     0.200
     0.447    -0.084     0.200
     0.545     0.057     0.200
     0.567    -0.078     0.200
     0.590     0.243     0.200
     0.652    -0.148     0.200
     0.653     0.144     0.200
     0.665     0.511     0.200
     0.725     0.080     0.200
     0.722     0.008     0.200
     0.729    -0.013     0.200
     0.771    -0.092     0.200
     0.777     0.131     0.200
     0.950     0.633     0.200
     0.952    -0.305     0.200
     0.987     0.736     0.200
     0.582     0.206     0.200
     0.677    -0.272     0.200
     0.211    -0.074     0.200
     0.244     0.014     0.200
     0.293     0.480     0.200
     0.326    -0.357     0.200
     0.363     0.044     0.200
     0.391     0.044     0.200
     0.433    -0.160     0.200
     0.521    -0.104     0.200
     0.515    -0.024     0.200
     0.602     0.146     0.200
     0.669    -0.086     0.200
     0.702    -0.067     0.200
     0.718    -0.049     0.200
     0.887     0.767     0.200
     0.888     0.276     0.200
     0.204     0.193     0.200
     0.293     0.274     0.200
     0.303     0.324     0.200
     0.341     0.159     0.200
     0.371     0.249     0.200
     0.361     0.196     0.200
     0.415     0.006     0.200
     0.407     0.205     0.200
     0.463     0.181     0.200
     0.484     0.110     0.200
     0.501    -0.245     0.200
     0.512     0.251     0.200
     0.529     0.183     0.200
     0.582     0.309     0.200
     0.648     0.131     0.200
     0.679    -0.135     0.200
     0.667    -0.039     0.200
     0.678    -0.092     0.200
     0.711    -0.495     0.200
     0.758    -0.066     0.200
     0.763    -0.204     0.200
     0.770     0.335     0.200
     0.830     0.186     0.200
     0.845    -0.317     0.200
     0.843     0.255     0.200
     0.905     0.029     0.200
     0.942    -0.404     0.200
     0.961     0.245     0.200
     0.146     0.054     0.200
     0.159    -0.045     0.200
     0.180    -0.087     0.200
     0.192     0.191     0.200
     0.325    -0.095     0.200
     0.330    -0.084     0.200
     0.406    -0.117     0.200
     0.580    -0.051     0.200
     0.589    -0.336     0.200
     0.601     0.017     0.200
     0.620     0.207     0.200
     0.636     0.099     0.200
     0.721    -0.398     0.200
     0.730     0.054     0.200
     0.733     0.014     0.200
     0.738    -0.196     0.200
     0.758     0.307     0.200
     0.772    -0.400     0.200
     0.782     0.194     0.200
     0.875    -0.071     0.200
     0.986    -0.221     0.200
     0.992    -0.144     0.200
     0.184     0.395     0.200
     0.244     0.130     0.200
     0.302    -0.041     0.200
     0.372    -0.200     0.200
     0.394    -0.261     0.200
     0.406     0.022     0.200
     0.424    -0.046     0.200
     0.485     0.145     0.200
     0.519     0.096     0.200
     0.642    -0.008     0.200
     0.860    -0.364     0.200
     0.099     0.218     0.200
     0.156     0.246     0.200
     0.185     0.031     0.200
     0.206     0.149     0.200
     0.312     0.184     0.200
     0.355    -0.023     0.200
     0.357     0.058     0.200
     0.529    -0.109     0.200
     0.549    -0.203     0.200
     0.615     0.227     0.200
     0.615     0.318     0.200
     0.622     0.189     0.200
     0.670    -0.365     0.200
     0.679    -0.177     0.200
     0.690     0.044     0.200
     0.695    -0.170     0.200
     0.741    -0.230     0.200
     0.805    -0.297     0.200
     0.811     0.141     0.200
     0.824     0.295     0.200
     0.845     0.044     0.200
     0.882    -0.040     0.200
     0.888     0.024     0.200
     0.918     0.174     0.200
     0.940    -0.026     0.200
     0.964     0.146     0.200
     0.176    -0.033     0.200
     0.242     0.170     0.200
     0.251     0.101     0.200
     0.296    -0.185     0.200
     0.286     0.237     0.200
     0.382    -0.008     0.200
     0.391     0.038     0.200
     0.402    -0.132     0.200
     0.438     0.214     0.200
     0.484    -0.170     0.200
     0.480     0.220     0.200
     0.516    -0.125     0.200
     0.621     0.176     0.200
     0.633    -0.168     0.200
     0.644    -0.309     0.200
     0.676    -0.295     0.200
     0.674    -0.106     0.200
     0.734     0.170     0.200
     0.797    -0.054     0.200
     0.816     0.036     0.200
     0.834     0.225     0.200
     0.851    -0.021     0.200
     0.923     0.300     0.200
     0.974     0.203     0.200
     0.079     0.370     0.200
     0.182     0.493     0.200
     0.265     0.031     0.200
     0.304    -0.015     0.200
     0.337     0.054     0.200
     0.358     0.371     0.200
     0.399     0.173     0.200
     0.528     0.216     0.200
     0.582     0.147     0.200
     0.683    -0.173     0.200
     0.742     0.003     0.200
     0.749    -0.119     0.200
     0.795    -0.179     0.200
     0.081     0.510     0.200
     0.140     0.862     0.200
     0.212     0.098     0.200
     0.290     0.197     0.200
     0.334     0.059     0.200
     0.344     0.062     0.200
     0.310     0.527     0.200
     0.311     0.440     0.200
     0.399    -0.016     0.200
     0.438    -0.040     0.200
     0.476     0.134     0.200
     0.497     0.093     0.200
     0.558     0.434     0.200
     0.616    -0.045     0.200
     0.639    -0.145     0.200
     0.754    -0.446     0.200
     0.860    -0.056     0.200
     0.894    -0.220     0.200
     0.964    -0.293     0.200
     0.062     0.282     0.200
     0.116     0.011     0.200
     0.131     0.287     0.200
     0.178    -0.130     0.200
     0.197     0.106     0.200
     0.185     0.325     0.200
     0.233     0.334     0.200
     0.322     0.261     0.200
     0.353     0.157     0.200
     0.369    -0.047     0.200
     0.381     0.500     0.200
     0.433     0.019     0.200
     0.436     0.250     0.200
     0.481     0.029     0.200
     0.505    -0.001     0.200
     0.513     0.482     0.200
     0.533     0.508     0.200
     0.607    -0.429     0.200
     0.608    -0.316     0.200
     0.631    -0.148     0.200
     0.677    -0.004     0.200
     0.701    -0.477     0.200
     0.701    -0.305     0.200
     0.681     0.456     0.200
     0.849    -0.219     0.200
     0.886     0.072     0.200
     0.939    -0.403     0.200
     0.969    -0.037     0.200
     0.076     0.662     0.200
     0.187     0.096     0.200
     0.225     0.042     0.200
     0.245     0.808     0.200
     0.373     0.205     0.200
     0.363     0.155     0.200
     0.444     0.344     0.200
     0.522     0.485     0.200
     0.528     0.252     0.200
     0.541    -0.112     0.200
     0.564    -0.150     0.200
     0.605    -0.344     0.200
     0.707    -0.021     0.200
     0.958     0.034     0.200
     0.994    -0.011     0.200
     0.628     0.218     0.200
     0.120     0.259     0.200
     0.159     0.319     0.200
     0.215     0.035     0.200
     0.241     0.116     0.200
     0.330     0.066     0.200
     0.360    -0.020     0.200
     0.388     0.123     0.200
     0.448     0.017     0.200
     0.547     0.252     0.200
     0.606     0.363     0.200
     0.709    -0.313     0.200
     0.722    -0.095     0.200
     0.746    -0.063     0.200
     0.936     0.067     0.200
     0.984     0.113     0.200
     0.990    -0.034     0.200
     0.111     0.165     0.200
     0.173     0.405     0.200
     0.226     0.052     0.200
     0.242     0.028     0.200
     0.371    -0.217     0.200
     0.402     0.044     0.200
     0.559     0.110     0.200
     0.618     0.393     0.200
     0.641     0.056     0.200
     0.652     0.037     0.200
     0.349     0.233     0.200
     0.395     0.129     0.200
     0.458     0.458     0.200
     0.484     0.273     0.200
     0.487     0.237     0.200
     0.598     0.077     0.200
     0.602    -0.025     0.200
     0.617    -0.112     0.200
     0.648     0.239     0.200
     0.676     0.006     0.200
     0.680     0.281     0.200
     0.693    -0.015     0.200
     0.724     0.645     0.200
     0.743    -0.142     0.200
     0.750    -0.270     0.200
     0.778    -0.682     0.200
     0.798     0.718     0.200
     0.799     0.298     0.200
     0.830     0.143     0.200
     0.883     0.480     0.200
     0.943    -0.010     0.200
     0.086     0.352     0.200
     0.095     0.227     0.200
     0.093     0.130     0.200
     0.179     0.299     0.200
     0.254     0.024     0.200
     0.269    -0.061     0.200
     0.265    -0.079     0.200
     0.410     0.266     0.200
     0.446     0.455     0.200
     0.481     0.521     0.200
     0.094     0.239     0.200
     0.086     0.369     0.200
     0.096     0.091     0.200
     0.177     0.320     0.200
     0.256     0.074     0.200
     0.267    -0.074     0.200
     0.267     0.021     0.200
     0.407     0.261     0.200
     0.444     0.257     0.200
     0.479     0.268     0.200
     0.817     0.679     0.200
     0.979    -0.518     0.200
     0.223     0.156     0.200
     0.310     0.160     0.200
     0.337     0.232     0.200
     0.343     0.262     0.200
     0.350    -0.213     0.200
     0.426    -0.185     0.200
     0.414     0.376     0.200
     0.474     0.317     0.200
     0.522     0.256     0.200
     0.552     0.053     0.200
     0.578     0.080     0.200
     0.644     0.001     0.200
     0.692     0.355     0.200
     0.680    -0.292     0.200
     0.752    -0.239     0.200
     0.778    -0.267     0.200
     0.793     0.153     0.200
     0.782     0.247     0.200
     0.874    -0.004     0.200
     0.887    -0.023     0.200
     0.107     0.009     0.200
     0.246     0.360     0.200
     0.264    -0.010     0.200
     0.278     0.252     0.200
     0.290     0.303     0.200
     0.326     0.407     0.200
     0.354     0.235     0.200
     0.399     0.106     0.200
     0.491    -0.409     0.200
     0.529    -0.226     0.200
     0.560     0.208     0.200
     0.658     0.290     0.200
     0.097     0.181     0.200
     0.134    -0.098     0.200
     0.121     0.144     0.200
     0.210     0.761     0.200
     0.306     0.152     0.200
     0.412    -0.212     0.200
     0.401     0.221     0.200
     0.447     0.339     0.200
     0.425     0.489     0.200
     0.469     0.474     0.200
     0.709    -0.044     0.200
     0.742    -0.231     0.200
     0.130     0.027     0.200
     0.101     0.194     0.200
     0.123     0.113     0.200
     0.233     0.205     0.200
     0.214     0.648     0.200
     0.303     0.137     0.200
     0.363     0.200     0.200
     0.386     0.005     0.200
     0.465     0.600     0.200
     0.587    -0.182     0.200
     0.731     0.032     0.200
     0.109    -0.071     0.200
     0.098     0.442     0.200
     0.186     0.359     0.200
     0.266     0.143     0.200
     0.319     0.130     0.200
     0.284     0.564     0.200
     0.323     0.167     0.200
     0.352     0.113     0.200
     0.441     0.433     0.200
     0.430     0.101     0.200
     0.456     0.245     0.200
     0.478     0.144     0.200
     0.515    -0.232     0.200
     0.490     0.216     0.200
     0.504     0.192     0.200
     0.586     0.430     0.200
     0.666    -0.355     0.200
     0.678    -0.284     0.200
     0.702     0.184     0.200
     0.736    -0.228     0.200
     0.737     0.090     0.200
     0.974     0.092     0.200
     0.106     0.020     0.200
     0.102     0.322     0.200
     0.190     0.343     0.200
     0.314     0.355     0.200
     0.289     0.699     0.200
     0.322     0.274     0.200
     0.349     0.364     0.200
     0.429     0.232     0.200
     0.509     0.037     0.200
     0.495     0.275     0.200
     0.510     0.131     0.200
     0.660    -0.457     0.200
     0.104     0.365     0.200
     0.235     0.366     0.200
     0.251     0.235     0.200
     0.285     0.230     0.200
     0.318     0.299     0.200
     0.368     0.075     0.200
     0.351     0.327     0.200
     0.369     0.256     0.200
     0.388     0.070     0.200
     0.438     0.460     0.200
     0.518     0.007     0.200
     0.485     0.256     0.200
     0.563     0.004     0.200
     0.578    -0.103     0.200
     0.580    -0.132     0.200
     0.588     0.104     0.200
     0.642     0.348     0.200
     0.651     0.584     0.200
     0.792     0.255     0.200
     0.187     0.209     0.200
     0.303     0.345     0.200
     0.345     0.193     0.200
     0.369     0.350     0.200
     0.403     0.149     0.200
     0.428     0.287     0.200
     0.479     0.267     0.200
     0.514    -0.419     0.200
     0.574     0.068     0.200
     0.634     0.017     0.200
     0.698     0.079     0.200
     0.721     0.071     0.200
     0.739     0.293     0.200
     0.773    -0.288     0.200
     0.813    -0.001     0.200
     0.904     0.057     0.200
     0.105     0.375     0.200
     0.113     0.393     0.200
     0.254    -0.184     0.200
     0.335     0.176     0.200
     0.359     0.202     0.200
     0.378    -0.096     0.200
     0.477     0.010     0.200
     0.528     0.221     0.200
     0.574    -0.613     0.200
     0.591     0.111     0.200
     0.612     0.281     0.200
     0.630     0.218     0.200
     0.710    -0.726     0.200
     0.749    -0.153     0.200
     0.835    -0.179     0.200
     0.011     0.214     0.200
     0.093    -0.042     0.200
     0.159     0.164     0.200
     0.172     0.134     0.200
     0.220    -0.088     0.200
     0.326     0.199     0.200
     0.343    -0.177     0.200
     0.457    -0.211     0.200
     0.458     0.015     0.200
     0.464     0.692     0.200
     0.489    -0.031     0.200
     0.489     0.072     0.200
     0.604     0.174     0.200
     0.600    -0.620     0.200
     0.620     0.148     0.200
     0.654     0.603     0.200
     0.677    -0.169     0.200
     0.672    -0.136     0.200
     0.685     0.145     0.200
     0.748    -0.027     0.200
     0.758    -0.108     0.200
     0.756     0.483     0.200
     0.783    -0.099     0.200
     0.804     0.390     0.200
     0.837    -0.251     0.200
     0.888     0.067     0.200
     0.165     0.182     0.200
     0.220     0.176     0.200
     0.275     0.352     0.200
     0.270     0.580     0.200
     0.283     0.090     0.200
     0.379     0.125     0.200
     0.441     0.189     0.200
     0.538     0.372     0.200
     0.570     0.194     0.200
     0.589     0.366     0.200
     0.621     0.217     0.200
     0.694    -0.077     0.200
     0.697     0.200     0.200
     0.715     0.387     0.200
     0.745     0.250     0.200
     0.804     0.128     0.200
     0.812     0.191     0.200
     0.814     0.195     0.200
     0.830    -0.051     0.200
     0.829     0.292     0.200
     0.842     0.359     0.200
     0.861    -0.465     0.200
     0.854     0.010     0.200
     0.865     0.062     0.200
     0.898    -0.324     0.200
     0.914     0.402     0.200
     0.946     0.025     0.200
     0.960    -0.375     0.200
     0.951     0.468     0.200
     0.995    -0.216     0.200
     0.150    -0.046     0.200
     0.287     0.190     0.200
     0.297     0.295     0.200
     0.293    -0.050     0.200
     0.308     0.145     0.200
     0.344     0.257     0.200
     0.360     0.135     0.200
     0.420     0.129     0.200
     0.451     0.217     0.200
     0.532     0.160     0.200
     0.534    -0.437     0.200
     0.614     0.147     0.200
     0.710     0.318     0.200
     0.784    -0.128     0.200
     0.830     0.316     0.200
     0.687     0.070     0.200
     0.150     0.212     0.200
     0.287     0.210     0.200
     0.308     0.215     0.200
     0.298     0.367     0.200
     0.345     0.372     0.200
     0.360     0.132     0.200
     0.447    -0.312     0.200
     0.457    -0.004     0.200
     0.451     0.350     0.200
     0.532    -0.060     0.200
     0.533    -0.231     0.200
     0.527    -0.541     0.200
     0.549     0.061     0.200
     0.615     0.004     0.200
     0.610     0.030     0.200
     0.659     0.616     0.200
     0.710     0.437     0.200
     0.743    -0.395     0.200
     0.739     0.180     0.200
     0.784     0.044     0.200
     0.800     0.193     0.200
     0.830     0.233     0.200
     0.817     0.422     0.200
     0.820    -0.348     0.200
     0.843    -0.054     0.200
     0.871    -0.474     0.200
     0.984     0.180     0.200
     0.546    -0.230     0.200
     0.609    -0.626     0.200
     0.710     0.047     0.200
     0.097     0.113     0.200
     0.152     0.314     0.200
     0.204     0.244     0.200
     0.215     0.135     0.200
     0.264     0.245     0.200
     0.321     0.204     0.200
     0.348     0.041     0.200
     0.427    -0.014     0.200
     0.414     0.226     0.200
     0.481     0.160     0.200
     0.544    -0.117     0.200
     0.620     0.233     0.200
     0.637     0.115     0.200
     0.632     0.097     0.200
     0.666    -0.554     0.200
     0.667    -0.151     0.200
     0.667    -0.042     0.200
     0.669    -0.378     0.200
     0.694    -0.345     0.200
     0.694    -0.082     0.200
     0.768    -0.083     0.200
     0.792    -0.355     0.200
     0.812    -0.098     0.200
     0.803     0.530     0.200
     0.818    -0.170     0.200
     0.854     0.275     0.200
     0.859    -0.284     0.200
     0.889    -0.005     0.200
     0.883    -0.134     0.200
     0.981     0.048     0.200
     0.083     0.220     0.200
     0.166     0.138     0.200
     0.248    -0.286     0.200
     0.255     0.105     0.200
     0.249     0.234     0.200
     0.297     0.051     0.200
     0.332     0.036     0.200
     0.378    -0.147     0.200
     0.418    -0.083     0.200
     0.420    -0.001     0.200
     0.491    -0.058     0.200
     0.543     0.354     0.200
     0.592    -0.480     0.200
     0.603    -0.364     0.200
     0.576     0.625     0.200
     0.622     0.747     0.200
     0.649    -0.533     0.200
     0.674     0.238     0.200
     0.882     0.172     0.200
     0.904    -0.323     0.200
     0.959     0.265     0.200
     0.960     0.393     0.200
     0.605     0.207     0.200
     0.137     0.381     0.200
     0.133     0.107     0.200
     0.202    -0.052     0.200
     0.245     0.142     0.200
     0.309     0.081     0.200
     0.337    -0.154     0.200
     0.365     0.079     0.200
     0.524     0.130     0.200
     0.584     0.206     0.200
     0.625     0.070     0.200
     0.692     0.666     0.200
     0.853     0.481     0.200
     0.088     0.159     0.200
     0.158    -0.174     0.200
     0.182     0.180     0.200
     0.210     0.141     0.200
     0.298     0.071     0.200
     0.361     0.054     0.200
     0.435    -0.245     0.200
     0.424    -0.391     0.200
     0.551     0.134     0.200
     0.624     0.133     0.200
     0.006     0.198     0.200
     0.150     0.255     0.200
     0.179     0.003     0.200
     0.192    -0.007     0.200
     0.221    -0.038     0.200
     0.266    -0.289     0.200
     0.275    -0.427     0.200
     0.349    -0.305     0.200
     0.473    -0.091     0.200
     0.607     0.097     0.200
     0.120     0.212     0.200
     0.129     0.341     0.200
     0.179     0.117     0.200
     0.250    -0.073     0.200
     0.296     0.413     0.200
     0.323    -0.077     0.200
     0.476    -0.499     0.200
     0.484    -0.377     0.200
     0.492    -0.212     0.200
     0.571    -0.135     0.200
     0.610    -0.125     0.200
     0.612    -0.396     0.200
     0.656    -0.234     0.200
     0.673     0.805     0.200
     0.700     0.194     0.200
     0.709     0.668     0.200
     0.713     0.414     0.200
     0.719    -0.470     0.200
     0.743    -0.544     0.200
     0.779     0.155     0.200
     0.826     0.103     0.200
     0.101     0.054     0.200
     0.165     0.053     0.200
     0.175    -0.133     0.200
     0.206    -0.061     0.200
     0.285     0.171     0.200
     0.493    -0.271     0.200
     0.528    -0.228     0.200
     0.623    -0.422     0.200
     0.736     0.267     0.200
     0.907     0.239     0.200
     0.104    -0.144     0.200
     0.144     0.031     0.200
     0.213     0.045     0.200
     0.211     0.148     0.200
     0.294     0.050     0.200
     0.349     0.134     0.200
     0.377     0.153     0.200
     0.394     0.078     0.200
     0.488     0.050     0.200
     0.486     0.041     0.200
     0.500    -0.046     0.200
     0.521     0.141     0.200
     0.542    -0.128     0.200
     0.568     0.407     0.200
     0.573     0.049     0.200
     0.641     0.074     0.200
     0.637     0.049     0.200
     0.711     0.449     0.200
     0.724    -0.019     0.200
     0.742     0.077     0.200
     0.755     0.107     0.200
     0.776     0.282     0.200
     0.840     0.186     0.200
     0.862     0.177     0.200
     0.121     0.346     0.200
     0.151     0.601     0.200
     0.214     0.117     0.200
     0.247     0.223     0.200
     0.324     0.143     0.200
     0.348    -0.162     0.200
     0.380    -0.009     0.200
     0.447    -0.260     0.200
     0.536     0.019     0.200
     0.595    -0.185     0.200
     0.637     0.137     0.200
     0.705     0.002     0.200
     0.745    -0.081     0.200
     0.867     0.260     0.200
     0.940    -0.464     0.200
     0.936    -0.072     0.200
     0.969     0.030     0.200
     0.997     0.970     0.200
     0.988    -0.080     0.200
     0.989     0.195     0.200
     0.081     0.039     0.200
     0.206    -0.127     0.200
     0.224    -0.170     0.200
     0.218     0.068     0.200
     0.275     0.201     0.200
     0.422    -0.157     0.200
     0.459     0.533     0.200
     0.582    -0.281     0.200
     0.671    -0.130     0.200
     0.843     0.164     0.200
     0.931    -0.138     0.200
     0.082     0.285     0.200
     0.202     0.487     0.200
     0.258     0.247     0.200
     0.264     0.021     0.200
     0.374     0.058     0.200
     0.387    -0.210     0.200
     0.429     0.235     0.200
     0.490    -0.358     0.200
     0.577    -0.081     0.200
     0.634    -0.085     0.200
     0.664    -0.007     0.200
     0.684     0.014     0.200
     0.752     0.087     0.200
     0.765     0.207     0.200
     0.787     0.008     0.200
     0.915     0.510     0.200
     0.079     0.156     0.200
     0.263     0.084     0.200
     0.265    -0.049     0.200
     0.395    -0.287     0.200
     0.437     0.120     0.200
     0.584    -0.086     0.200
     0.641     0.208     0.200
     0.672     0.062     0.200
     0.150     0.326     0.200
     0.153     0.006     0.200
     0.153     0.611     0.200
     0.203     0.019     0.200
     0.294     0.166     0.200
     0.376    -0.214     0.200
     0.376     0.193     0.200
     0.394    -0.025     0.200
     0.575    -0.000     0.200
     0.571     0.215     0.200
     0.634     0.722     0.200
     0.646     0.144     0.200
     0.636     0.206     0.200
     0.671    -0.181     0.200
     0.688    -0.091     0.200
     0.854    -0.521     0.200
     0.855    -0.299     0.200
     0.894    -0.519     0.200
     0.897     0.224     0.200
     0.914     0.356     0.200
     0.956     0.367     0.200
     0.399    -0.456     0.200
     0.012     0.093     0.200
     0.114     0.120     0.200
     0.158     0.166     0.200
     0.233     0.287     0.200
     0.310     0.443     0.200
     0.347     0.075     0.200
     0.375     0.156     0.200
     0.460     0.220     0.200
     0.468     0.082     0.200
     0.461    -0.063     0.200
     0.473     0.260     0.200
     0.583    -0.078     0.200
     0.591     0.171     0.200
     0.600    -0.102     0.200
     0.655     0.054     0.200
     0.680    -0.551     0.200
     0.679     0.067     0.200
     0.685     0.686     0.200
     0.723    -0.101     0.200
     0.731     0.144     0.200
     0.737    -0.411     0.200
     0.731     0.265     0.200
     0.764     0.014     0.200
     0.802     0.447     0.200
     0.814     0.237     0.200
     0.824    -0.305     0.200
     0.826     0.398     0.200
     0.947     0.016     0.200
     0.133     0.284     0.200
     0.116     0.323     0.200
     0.184    -0.061     0.200
     0.237     0.303     0.200
     0.269     0.344     0.200
     0.279     0.149     0.200
     0.285     0.267     0.200
     0.315     0.222     0.200
     0.410     0.189     0.200
     0.432     0.114     0.200
     0.484     0.038     0.200
     0.494    -0.089     0.200
     0.515    -0.516     0.200
     0.565     0.006     0.200
     0.574    -0.405     0.200
     0.569    -0.209     0.200
     0.690     0.159     0.200
     0.034     0.304     0.200
     0.122    -0.035     0.200
     0.194     0.248     0.200
     0.258     0.018     0.200
     0.291     0.406     0.200
     0.308    -0.146     0.200
     0.365     0.343     0.200
     0.498     0.009     0.200
     0.567     0.137     0.200
     0.621     0.217     0.200
     0.627    -0.263     0.200
     0.688     0.297     0.200
     0.709     0.354     0.200
     0.710    -0.135     0.200
     0.715     0.141     0.200
     0.723     0.016     0.200
     0.841     0.479     0.200
     0.865    -0.004     0.200
     0.030     0.120     0.200
     0.113     0.018     0.200
     0.195     0.311     0.200
     0.250     0.154     0.200
     0.300     0.297     0.200
     0.311    -0.351     0.200
     0.374     0.195     0.200
     0.444     0.201     0.200
     0.492     0.072     0.200
     0.496     0.263     0.200
     0.576     0.027     0.200
     0.627    -0.470     0.200
     0.628    -0.405     0.200
     0.685     0.436     0.200
     0.712    -0.104     0.200
     0.706     0.130     0.200
     0.719     0.113     0.200
     0.724     0.091     0.200
     0.719     0.338     0.200
     0.796     0.325     0.200
     0.127    -0.123     0.200
     0.200     0.062     0.200
     0.262     0.291     0.200
     0.273     0.658     0.200
     0.318     0.073     0.200
     0.388     0.152     0.200
     0.401     0.276     0.200
     0.412     0.121     0.200
     0.432     0.023     0.200
     0.486     0.173     0.200
     0.629    -0.105     0.200
     0.634    -0.407     0.200
     0.645     0.069     0.200
     0.657    -0.343     0.200
     0.732    -0.143     0.200
     0.874    -0.015     0.200
     0.919     0.241     0.200
     0.100    -0.528     0.200
     0.185     0.122     0.200
     0.263     0.436     0.200
     0.276     0.410     0.200
     0.306     0.363     0.200
     0.369     0.432     0.200
     0.408     0.390     0.200
     0.427     0.378     0.200
     0.454     0.420     0.200
     0.456     0.354     0.200
     0.462     0.010     0.200
     0.531    -0.071     0.200
     0.598     0.452     0.200
     0.638     0.302     0.200
     0.650    -0.224     0.200
     0.665     0.037     0.200
     0.688     0.347     0.200
     0.674    -0.056     0.200
     0.691     0.048     0.200
     0.759     0.403     0.200
     0.782     0.420     0.200
     0.790     0.030     0.200
     0.809    -0.371     0.200
     0.816    -0.067     0.200
     0.919     0.563     0.200
     0.948     0.289     0.200
     0.164    -0.071     0.200
     0.179     0.359     0.200
     0.210    -0.114     0.200
     0.285    -0.137     0.200
     0.341     0.114     0.200
     0.361     0.188     0.200
     0.388    -0.281     0.200
     0.629     0.143     0.200
     0.706    -0.274     0.200
     0.732    -0.293     0.200
     0.772    -0.323     0.200
     0.084     0.196     0.200
     0.194     0.275     0.200
     0.233     0.254     0.200
     0.274     0.080     0.200
     0.309     0.194     0.200
     0.347     0.369     0.200
     0.367    -0.137     0.200
     0.362     0.315     0.200
     0.488     0.144     0.200
     0.497     0.413     0.200
     0.503     0.162     0.200
     0.547    -0.047     0.200
     0.556     0.029     0.200
     0.612     0.259     0.200
     0.745     0.162     0.200
     0.760    -0.303     0.200
     0.135     0.213     0.200
     0.212     0.335     0.200
     0.263     0.069     0.200
     0.343     0.334     0.200
     0.362     0.199     0.200
     0.414    -0.220     0.200
     0.499     0.282     0.200
     0.636     0.266     0.200
     0.650     0.270     0.200
     0.677     0.259     0.200
     0.689    -0.011     0.200
     0.680    -0.105     0.200
     0.815    -0.432     0.200
     0.882     0.286     0.200
     0.894     0.017     0.200
     0.983     0.045     0.200
     0.161     0.181     0.200
     0.255     0.365     0.200
     0.338    -0.270     0.200
     0.405    -0.081     0.200
     0.623     0.022     0.200
     0.634     0.072     0.200
     0.656     0.441     0.200
     0.675    -0.185     0.200
     0.145    -0.063     0.200
     0.202     0.302     0.200
     0.233     0.309     0.200
     0.255     0.086     0.200
     0.352     0.218     0.200
     0.406     0.021     0.200
     0.498    -0.002     0.200
     0.558     0.109     0.200
     0.636     0.302     0.200
     0.649     0.299     0.200
     0.683    -0.305     0.200
     0.708    -0.034     0.200
     0.775    -0.225     0.200
     0.807     0.058     0.200
     0.897    -0.140     0.200
     0.135     0.130     0.200
     0.211     0.407     0.200
     0.237     0.216     0.200
     0.262     0.104     0.200
     0.343     0.124     0.200
     0.361     0.147     0.200
     0.413     0.003     0.200
     0.450    -0.156     0.200
     0.500    -0.546     0.200
     0.637     0.301     0.200
     0.651     0.085     0.200
     0.681     0.064     0.200
     0.717     0.225     0.200
     0.716     0.037     0.200
     0.881     0.277     0.200
     0.901     0.321     0.200
     0.895    -0.458     0.200
     0.161     0.275     0.200
     0.176    -0.171     0.200
     0.188     0.320     0.200
     0.281     0.295     0.200
     0.313    -0.012     0.200
     0.357     0.235     0.200
     0.413     0.236     0.200
     0.396     0.279     0.200
     0.433     0.240     0.200
     0.532    -0.267     0.200
     0.573     0.281     0.200
     0.648    -0.253     0.200
     0.654     0.008     0.200
     0.653     0.269     0.200
     0.726     0.258     0.200
     0.754     0.359     0.200
     0.818     0.775     0.200
     0.858     0.363     0.200
     0.937    -0.030     0.200
     0.979     0.128     0.200
     0.098     0.417     0.200
     0.195     0.435     0.200
     0.229    -0.020     0.200
     0.247     0.588     0.200
     0.295     0.476     0.200
     0.315     0.442     0.200
     0.362     0.463     0.200
     0.358     0.662     0.200
     0.372     0.452     0.200
     0.511     0.168     0.200
     0.542    -0.395     0.200
     0.512     0.159     0.200
     0.517    -0.161     0.200
     0.539     0.171     0.200
     0.601     0.398     0.200
     0.608     0.594     0.200
     0.618     0.652     0.200
     0.632     0.113     0.200
     0.696     0.264     0.200
     0.692     0.592     0.200
     0.759     0.096     0.200
     0.808     0.082     0.200
     0.840    -0.127     0.200
     0.879     0.338     0.200
     0.879     0.513     0.200
     0.912     0.012     0.200
     0.927     0.124     0.200
     0.924     0.090     0.200
     0.507    -0.292     0.200
     0.650    -0.022     0.200
     0.609     0.827     0.200
     0.080     0.116     0.200
     0.222     0.370     0.200
     0.263     0.083     0.200
     0.271     0.167     0.200
     0.409    -0.139     0.200
     0.450     0.175     0.200
     0.599     0.163     0.200
     0.656     0.172     0.200
     0.686     0.536     0.200
     0.114     0.123     0.200
     0.198     0.476     0.200
     0.219     0.148     0.200
     0.261     0.314     0.200
     0.309     0.305     0.200
     0.321     0.271     0.200
     0.370     0.475     0.200
     0.373     0.389     0.200
     0.385     0.225     0.200
     0.541    -0.234     0.200
     0.523    -0.045     0.200
     0.528     0.079     0.200
     0.542    -0.102     0.200
     0.608     0.090     0.200
     0.623    -0.174     0.200
     0.624     0.233     0.200
     0.632     0.414     0.200
     0.706     0.405     0.200
     0.837     0.131     0.200
     0.935     0.167     0.200
     0.231     0.224     0.200
     0.336    -0.415     0.200
     0.349     0.207     0.200
     0.364     0.452     0.200
     0.397     0.184     0.200
     0.407     0.236     0.200
     0.413     0.164     0.200
     0.440     0.492     0.200
     0.447     0.350     0.200
     0.511     0.360     0.200
     0.534     0.129     0.200
     0.546     0.033     0.200
     0.620     0.344     0.200
     0.639     0.090     0.200
     0.637     0.521     0.200
     0.687     0.471     0.200
     0.751    -0.084     0.200
     0.769    -0.344     0.200
     0.773     0.118     0.200
     0.809     0.045     0.200
     0.843    -0.161     0.200
     0.835    -0.141     0.200
     0.882     0.040     0.200
     0.946     0.267     0.200
     0.945    -0.044     0.200
     0.879    -0.008     0.200
     0.102    -0.076     0.200
     0.205     0.176     0.200
     0.295    -0.143     0.200
     0.326     0.478     0.200
     0.357     0.205     0.200
     0.369     0.329     0.200
     0.532    -0.476     0.200
     0.524     0.072     0.200
     0.618     0.141     0.200
     0.629     0.068     0.200
     0.693     0.199     0.200
     0.703     0.543     0.200
     0.922     0.398     0.200
     0.347    -0.396     0.200
     0.151    -0.039     0.200
     0.223    -0.026     0.200
     0.235     0.620     0.200
     0.326     0.165     0.200
     0.349     0.274     0.200
     0.407     0.072     0.200
     0.484    -0.057     0.200
     0.523     0.015     0.200
     0.677     0.493     0.200
     0.032     0.048     0.200
     0.165     0.124     0.200
     0.175     0.039     0.200
     0.203     0.220     0.200
     0.272     0.179     0.200
     0.369     0.300     0.200
     0.367     0.156     0.200
     0.482    -0.013     0.200
     0.510     0.054     0.200
     0.581     0.206     0.200
     0.571     0.024     0.200
     0.590     0.641     0.200
     0.599    -0.332     0.200
     0.643     0.174     0.200
     0.638     0.017     0.200
     0.665     0.141     0.200
     0.711    -0.365     0.200
     0.708     0.164     0.200
     0.728     0.109     0.200
     0.725     0.147     0.200
     0.787     0.286     0.200
     0.848     0.636     0.200
     0.864     0.362     0.200
     0.927     0.009     0.200
     0.175     0.225     0.200
     0.277     0.054     0.200
     0.311    -0.357     0.200
     0.341    -0.144     0.200
     0.347     0.275     0.200
     0.501    -0.299     0.200
     0.545    -0.209     0.200
     0.556     0.265     0.200
     0.661     0.158     0.200
     0.740     0.123     0.200
     0.122    -0.239     0.200
     0.203    -0.259     0.200
     0.257    -0.056     0.200
     0.312     0.028     0.200
     0.317     0.057     0.200
     0.394     0.018     0.200
     0.426    -0.105     0.200
     0.452    -0.277     0.200
     0.586    -0.502     0.200
     0.604    -0.411     0.200
     0.665    -0.306     0.200
     0.713    -0.095     0.200
     0.717     0.125     0.200
     0.721     0.135     0.200
     0.809     0.196     0.200
     0.807     0.248     0.200
     0.867    -0.158     0.200
     0.914     0.160     0.200
     0.932     0.277     0.200
     0.991     0.100     0.200
     0.035    -0.327     0.200
     0.127    -0.054     0.200
     0.193    -0.264     0.200
     0.287    -0.092     0.200
     0.308    -0.270     0.200
     0.361    -0.223     0.200
     0.431    -0.163     0.200
     0.481    -0.192     0.200
     0.500     0.050     0.200
     0.505     0.214     0.200
     0.499    -0.106     0.200
     0.563    -0.065     0.200
     0.618    -0.160     0.200
     0.625    -0.016     0.200
     0.657    -0.230     0.200
     0.688     0.935     0.200
     0.683    -0.126     0.200
     0.706     0.361     0.200
     0.706     0.144     0.200
     0.711    -0.132     0.200
     0.715     0.275     0.200
     0.748    -0.167     0.200
     0.770     0.416     0.200
     0.789     0.534     0.200
     0.796    -0.184     0.200
     0.846     0.058     0.200
     0.931     0.060     0.200
     0.961    -0.011     0.200
     0.986    -0.021     0.200
     0.034     0.283     0.200
     0.130    -0.021     0.200
     0.187     0.010     0.200
     0.284     0.187     0.200
     0.312    -0.263     0.200
     0.474    -0.333     0.200
     0.496     0.074     0.200
     0.610     0.274     0.200
     0.619    -0.302     0.200
     0.651    -0.448     0.200
     0.702     0.010     0.200
     0.707     0.107     0.200
     0.741    -0.182     0.200
     0.136     0.301     0.200
     0.231     0.131     0.200
     0.203     0.569     0.200
     0.286     0.122     0.200
     0.302     0.031     0.200
     0.311     0.205     0.200
     0.372    -0.192     0.200
     0.414     0.258     0.200
     0.441    -0.025     0.200
     0.463     0.415     0.200
     0.537    -0.109     0.200
     0.545     0.231     0.200
     0.565    -0.358     0.200
     0.606     0.337     0.200
     0.653     0.081     0.200
     0.634     0.301     0.200
     0.880    -0.104     0.200
     0.930    -0.000     0.200
     0.037     0.082     0.200
     0.136    -0.154     0.200
     0.185    -0.029     0.200
     0.279     0.237     0.200
     0.420    -0.147     0.200
     0.495    -0.002     0.200
     0.555    -0.129     0.200
     0.616    -0.521     0.200
     0.645    -0.196     0.200
     0.703    -0.306     0.200
     0.716     0.281     0.200
     0.777     0.409     0.200
     0.837     0.188     0.200
     0.997     0.211     0.200
     0.135     0.009     0.200
     0.199    -0.026     0.200
     0.290     0.313     0.200
     0.340     0.241     0.200
     0.488     0.191     0.200
     0.564     0.041     0.200
     0.681    -0.528     0.200
     0.906    -0.167     0.200
     0.037     0.449     0.200
     0.134    -0.490     0.200
     0.185     0.350     0.200
     0.266     0.108     0.200
     0.313     0.195     0.200
     0.352     0.136     0.200
     0.421     0.115     0.200
     0.496    -0.176     0.200
     0.498    -0.221     0.200
     0.607    -0.049     0.200
     0.646     0.232     0.200
     0.684     1.046     0.200
     0.695     0.233     0.200
     0.698     0.377     0.200
     0.715     0.351     0.200
     0.722     0.165     0.200
     0.737    -0.131     0.200
     0.768     0.422     0.200
     0.779     0.704     0.200
     0.792    -0.263     0.200
     0.838     0.575     0.200
     0.857     0.008     0.200
     0.722     0.343     0.200
     0.192     0.197     0.200
     0.253     0.081     0.200
     0.290     0.250     0.200
     0.419     0.288     0.200
     0.415     0.167     0.200
     0.527    -0.108     0.200
     0.585    -0.117     0.200
     0.736     0.410     0.200
     0.809    -0.034     0.200
     0.925     0.179     0.200
     0.020    -0.127     0.200
     0.101    -0.274     0.200
     0.152     0.005     0.200
     0.215    -0.119     0.200
     0.444     0.066     0.200
     0.470     0.287     0.200
     0.584     0.379     0.200
     0.604    -0.536     0.200
     0.636     0.386     0.200
     0.667    -0.197     0.200
     0.740    -0.477     0.200
     0.745    -0.197     0.200
     0.787     0.095     0.200
     0.113     0.240     0.200
     0.175     0.291     0.200
     0.257     0.061     0.200
     0.278    -0.177     0.200
     0.316     0.021     0.200
     0.366     0.159     0.200
     0.420     0.357     0.200
     0.418    -0.100     0.200
     0.438     0.031     0.200
     0.447    -0.069     0.200
     0.472     0.064     0.200
     0.522     0.064     0.200
     0.500     0.267     0.200
     0.555     0.638     0.200
     0.581     0.270     0.200
     0.628    -0.499     0.200
     0.662    -0.025     0.200
     0.668    -0.046     0.200
     0.688    -0.110     0.200
     0.686     0.908     0.200
     0.708    -0.390     0.200
     0.708    -0.250     0.200
     0.795     0.028     0.200
     0.861    -0.075     0.200
     0.840     0.525     0.200
     0.360     0.873     0.200
     0.745     1.624     0.200
     0.139     0.132     0.200
     0.143     0.136     0.200
     0.227    -0.088     0.200
     0.293     0.113     0.200
     0.307     0.067     0.200
     0.623     0.209     0.200
     0.734    -0.154     0.200
     0.753    -0.353     0.200
     0.782    -0.093     0.200
     0.803    -0.136     0.200
     0.018     0.038     0.200
     0.122    -0.205     0.200
     0.166     0.160     0.200
     0.246    -0.019     0.200
     0.428    -0.223     0.200
     0.479     0.112     0.200
     0.599     0.203     0.200
     0.649     0.194     0.200
     0.683    -0.095     0.200
     0.712    -0.151     0.200
     0.698     0.396     0.200
     0.814     0.086     0.200
     0.114    -0.000     0.200
     0.165     0.336     0.200
     0.186     0.047     0.200
     0.261     0.301     0.200
     0.272     0.186     0.200
     0.346     0.252     0.200
     0.347     0.293     0.200
     0.377     0.285     0.200
     0.438     0.146     0.200
     0.526    -0.006     0.200
     0.538     0.196     0.200
     0.587     0.323     0.200
     0.599     0.313     0.200
     0.614    -0.080     0.200
     0.637     0.137     0.200
     0.651     0.263     0.200
     0.728     0.060     0.200
     0.795     0.576     0.200
     0.830     0.314     0.200
     0.881     0.266     0.200
     0.134     0.087     0.200
     0.316     0.300     0.200
     0.317     0.320     0.200
     0.332     0.131     0.200
     0.421     0.173     0.200
     0.492    -0.078     0.200
     0.525    -0.106     0.200
     0.513     0.147     0.200
     0.614     0.244     0.200
     0.616     0.069     0.200
     0.700     0.491     0.200
     0.792     0.096     0.200
     0.789     0.218     0.200
     0.773     0.196     0.200
     0.828     0.035     0.200
     0.946     0.340     0.200
     0.610    -0.302     0.200
     0.145     0.694     0.200
     0.166     0.361     0.200
     0.267     0.093     0.200
     0.315     0.043     0.200
     0.340     0.023     0.200
     0.307     0.270     0.200
     0.380     0.064     0.200
     0.384     0.417     0.200
     0.372     0.161     0.200
     0.422     0.539     0.200
     0.435     0.122     0.200
     0.507     0.123     0.200
     0.529    -0.037     0.200
     0.545    -0.421     0.200
     0.523     0.314     0.200
     0.540     0.288     0.200
     0.520     0.240     0.200
     0.647     0.368     0.200
     0.636     0.207     0.200
     0.660     0.329     0.200
     0.681    -0.117     0.200
     0.685    -0.233     0.200
     0.683    -0.103     0.200
     0.726    -0.210     0.200
     0.740    -0.156     0.200
     0.749    -0.368     0.200
     0.753    -0.357     0.200
     0.786     0.182     0.200
     0.826     0.082     0.200
     0.825     0.743     0.200
     0.852     0.036     0.200
     0.917    -0.018     0.200
     0.932    -0.231     0.200
     0.300     0.471     0.200
     0.675    -0.189     0.200
     0.981    -0.229     0.200
     0.146     0.667     0.200
     0.168     0.286     0.200
     0.270     0.168     0.200
     0.318     0.003     0.200
     0.304     0.476     0.200
     0.344    -0.079     0.200
     0.383     0.055     0.200
     0.384     0.556     0.200
     0.368     0.074     0.200
     0.424     0.512     0.200
     0.432     0.183     0.200
     0.510     0.175     0.200
     0.533    -0.193     0.200
     0.524     0.471     0.200
     0.549    -0.251     0.200
     0.543     0.183     0.200
     0.517     0.321     0.200
     0.633     0.362     0.200
     0.647     0.276     0.200
     0.662     0.268     0.200
     0.685    -0.276     0.200
     0.687    -0.216     0.200
     0.687     0.210     0.200
     0.730    -0.439     0.200
     0.743    -0.179     0.200
     0.753    -0.383     0.200
     0.757    -0.559     0.200
     0.784     0.341     0.200
     0.830     0.209     0.200
     0.824     0.841     0.200
     0.850     0.060     0.200
     0.921    -0.070     0.200
     0.936    -0.368     0.200
     0.946    -0.253     0.200
     0.677    -0.256     0.200
     0.075     0.529     0.200
     0.098    -0.064     0.200
     0.237     0.379     0.200
     0.262     0.068     0.200
     0.421    -0.076     0.200
     0.466    -0.153     0.200
     0.539     0.128     0.200
     0.554    -0.036     0.200
     0.575    -0.100     0.200
     0.613     0.200     0.200
     0.611     0.569     0.200
     0.646     0.214     0.200
     0.796     0.013     0.200
     0.422    -0.663     0.200
     0.054     0.175     0.200
     0.280     0.268     0.200
     0.295     0.034     0.200
     0.387     0.331     0.200
     0.377     0.120     0.200
     0.513    -0.302     0.200
     0.568    -0.160     0.200
     0.622     0.027     0.200
     0.661     0.252     0.200
     0.772     0.602     0.200
     0.775     0.196     0.200
     0.964     0.319     0.200
     0.038     0.225     0.200
     0.112     0.093     0.200
     0.133     0.110     0.200
     0.190     0.254     0.200
     0.207     0.184     0.200
     0.266     0.041     0.200
     0.281     0.285     0.200
     0.309    -0.170     0.200
     0.354     0.155     0.200
     0.474    -0.008     0.200
     0.501     0.239     0.200
     0.501    -0.113     0.200
     0.611     0.357     0.200
     0.622     0.043     0.200
     0.650    -0.244     0.200
     0.688    -0.111     0.200
     0.700     0.163     0.200
     0.700     0.059     0.200
     0.741    -0.042     0.200
     0.783     0.270     0.200
     0.841    -0.044     0.200
     0.875    -0.332     0.200
     0.207     0.269     0.200
     0.201     0.059     0.200
     0.218     0.372     0.200
     0.249     0.235     0.200
     0.299     0.106     0.200
     0.333    -0.263     0.200
     0.356    -0.443     0.200
     0.415    -0.504     0.200
     0.444     0.103     0.200
     0.725    -0.481     0.200
     0.442    -0.835     0.200
     0.302    -0.309     0.200
     0.451    -1.194     0.200
     0.039     0.344     0.200
     0.972    -0.546     0.200
     0.607     0.685     0.200
     0.763    -1.424     0.200
     0.751     0.556     0.200
     0.715    -0.701     0.200
     0.596     0.678     0.200
     0.458     1.491     0.200
     0.436    -0.460     0.200
     0.537     1.296     0.200
     0.787    -0.086     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.959    -1.208     0.200
     0.860    -1.842     0.200
     0.942    -1.019     0.200
     0.852    -1.492     0.200
     0.975    -1.073     0.200
     0.880    -1.555     0.200
     0.999    -1.181     0.200
     0.815    -1.749     0.200
     0.830    -1.353     0.200
     0.949    -1.578     0.200
     0.829    -1.867     0.200
     0.835    -1.781     0.200
     0.836    -1.020     0.200
     0.969    -1.459     0.200
     0.964    -1.714     0.200
     0.822    -1.777     0.200
     0.948    -0.609     0.200
     0.958    -1.096     0.200
     0.944    -1.169     0.200
     0.955    -1.380     0.200
     0.976    -0.926     0.200
     0.930    -1.207     0.200
     0.772    -1.280     0.200
     0.805    -1.500     0.200
     0.871    -0.965     0.200
     0.878    -1.004     0.200
     0.864    -1.472     0.200
     0.618    -0.719     0.200
     0.690    -0.912     0.200
     0.868    -0.942     0.200
     0.896     0.216     0.200
     0.898    -1.701     0.200
     0.997    -0.119     0.200
     0.908    -1.365     0.200
     0.638    -1.438     0.200
     0.685    -0.931     0.200
     0.793    -1.137     0.200
     0.862    -1.085     0.200
     0.727    -1.505     0.200
     0.915    -1.024     0.200
     0.941    -1.113     0.200
     0.910    -1.813     0.200
     0.954    -1.207     0.200
     0.978     1.501     0.200
     0.861    -1.415     0.200
     0.856    -1.383     0.200
     0.969    -0.876     0.200
     0.937    -1.079     0.200
     0.975    -0.865     0.200
     0.978    -0.383     0.200
     0.998    -0.979     0.200
     0.906    -1.224     0.200
     0.891    -1.114     0.200
     0.909    -1.013     0.200
     0.921    -0.220     0.200
     0.959    -0.960     0.200
     0.988    -0.140     0.200
     0.989    -1.391     0.200
     0.973    -0.827     0.200
     0.847    -0.700     0.200
     0.942    -1.028     0.200
     0.921    -1.123     0.200
     0.778    -1.312     0.200
     0.883    -1.269     0.200
     0.921    -1.086     0.200
     0.977    -0.847     0.200
     0.991    -0.930     0.200
     0.936    -1.424     0.200
     0.974    -0.601     0.200
     0.988    -0.930     0.200
     0.972    -1.539     0.200
     0.834    -1.261     0.200
     0.829    -1.144     0.200
     0.858    -1.257     0.200
     0.915    -1.154     0.200
     0.843    -1.488     0.200
     0.930    -1.124     0.200
     0.850    -1.467     0.200
     0.940    -0.790     0.200
     0.941    -1.343     0.200
     0.830    -1.145     0.200
     0.974    -0.725     0.200
     0.974    -1.725     0.200
     0.784    -1.290     0.200
     0.973    -0.298     0.200
     0.970    -0.826     0.200
     0.972    -0.886     0.200
     0.995    -0.732     0.200
     0.943    -1.339     0.200
     0.867    -1.408     0.200
     0.929    -1.785     0.200
     0.920    -0.917     0.200
     0.951    -0.957     0.200
     0.960    -0.227     0.200
     0.811    -0.896     0.200
     0.914    -1.045     0.200
     0.911    -1.442     0.200
     0.958    -0.600     0.200
     0.972    -0.428     0.200
     0.988    -1.230     0.200
     0.843    -1.334     0.200
     0.966    -1.098     0.200
     0.879    -1.109     0.200
     0.895    -0.710     0.200
     0.893    -1.131     0.200
     0.939    -1.012     0.200
     0.971    -1.331     0.200
     1.000    -0.837     0.200
     0.764    -1.272     0.200
     0.850    -1.079     0.200
     0.959    -0.396     0.200
     0.970    -0.672     0.200
     0.974    -1.303     0.200
     0.837    -1.646     0.200
     0.837    -1.605     0.200
     0.912    -1.294     0.200
     0.935    -1.195     0.200
     0.984    -1.275     0.200
     0.850    -1.488     0.200
     0.999    -1.349     0.200
     0.986    -0.841     0.200
     0.984    -0.696     0.200
     0.861    -1.333     0.200
     0.809    -0.234     0.200
     0.919     1.278     0.200
     0.995     1.894     0.200
     0.903    -1.466     0.200
     0.841    -1.578     0.200
     0.952    -1.029     0.200
     0.718    -1.617     0.200
     0.762    -1.535     0.200
     0.884    -1.246     0.200
     0.901    -1.099     0.200
     0.987    -1.251     0.200
     0.914    -1.573     0.200
     0.774    -1.988     0.200
     0.873    -1.582     0.200
     0.896     0.915     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.777    -0.946     0.200
     0.770     0.494     0.200
     0.738    -0.018     0.200
     0.704    -1.052     0.200
     0.534    -0.112     0.200
     0.934    -0.418     0.200
     0.830    -1.298     0.200
     0.995    -0.388     0.200
     0.198    -1.398     0.200
     0.276    -1.344     0.200
     0.573    -0.959     0.200
     0.869    -0.690     0.200
     0.976    -0.130     0.200
     0.086     0.254     0.200
     0.241    -2.090     0.200
     0.292    -0.483     0.200
     0.324    -0.491     0.200
     0.042    -0.092     0.200
     0.216    -0.957     0.200
     0.221     0.003     0.200
     0.292    -0.997     0.200
     0.828     0.334     0.200
     0.056    -0.163     0.200
     0.063     0.429     0.200
     0.223    -0.432     0.200
     0.219    -0.807     0.200
     0.219    -0.627     0.200
     0.292    -0.853     0.200
     0.049    -0.151     0.200
     0.065    -1.486     0.200
     0.048     0.510     0.200
     0.070     0.135     0.200
     0.213    -0.836     0.200
     0.217    -0.274     0.200
     0.286    -0.789     0.200
     0.816    -0.355     0.200
     0.058    -0.765     0.200
     0.126     0.433     0.200
     0.249    -0.226     0.200
     0.249    -1.405     0.200
     0.366    -0.595     0.200
     0.894    -0.474     0.200
     0.077     0.077     0.200
     0.050     0.186     0.200
     0.088    -1.151     0.200
     0.187     0.579     0.200
     0.230    -0.401     0.200
     0.234    -0.203     0.200
     0.852    -0.073     0.200
     0.048    -0.027     0.200
     0.055    -0.671     0.200
     0.215    -0.323     0.200
     0.216    -0.190     0.200
     0.207     0.285     0.200
     0.816    -0.247     0.200
     0.049    -0.011     0.200
     0.082    -0.064     0.200
     0.184     0.664     0.200
     0.236    -0.089     0.200
     0.232    -0.593     0.200
     0.292    -1.035     0.200
     0.294    -0.609     0.200
     0.577    -0.769     0.200
     0.857    -0.826     0.200
     0.995     0.211     0.200
     0.088    -0.365     0.200
     0.009    -0.570     0.200
     0.037     0.041     0.200
     0.246    -0.199     0.200
     0.243    -0.875     0.200
     0.294    -0.728     0.200
     0.301    -0.860     0.200
     0.300    -0.827     0.200
     0.862    -0.433     0.200
     0.051    -0.344     0.200
     0.063    -0.159     0.200
     0.076    -0.012     0.200
     0.221    -0.977     0.200
     0.226    -0.662     0.200
     0.248    -0.098     0.200
     0.262    -0.593     0.200
     0.522    -1.058     0.200
     0.811    -0.133     0.200
     0.802     0.387     0.200
     0.023    -0.086     0.200
     0.041     0.173     0.200
     0.255    -1.448     0.200
     0.257    -0.609     0.200
     0.319    -1.212     0.200
     0.605    -1.135     0.200
     0.885    -0.670     0.200
     0.999    -0.199     0.200
     0.037    -0.169     0.200
     0.060    -0.070     0.200
     0.082     0.132     0.200
     0.207    -0.647     0.200
     0.202    -0.787     0.200
     0.251    -1.501     0.200
     0.218     0.452     0.200
     0.530    -0.969     0.200
     0.810    -0.005     0.200
     0.804    -0.308     0.200
     0.048     0.009     0.200
     0.050    -0.539     0.200
     0.070     0.185     0.200
     0.220    -0.630     0.200
     0.206     0.835     0.200
     0.254    -0.454     0.200
     0.264    -0.539     0.200
     0.820     0.768     0.200
     0.074     0.114     0.200
     0.023     0.209     0.200
     0.050     0.245     0.200
     0.229    -1.365     0.200
     0.187     0.233     0.200
     0.290    -0.290     0.200
     0.568    -0.858     0.200
     0.688    -1.651     0.200
     0.849    -1.112     0.200
     0.044    -0.113     0.200
     0.104    -0.077     0.200
     0.052    -1.292     0.200
     0.074     0.065     0.200
     0.208    -1.697     0.200
     0.213    -0.586     0.200
     0.259    -0.759     0.200
     0.211     0.472     0.200
     0.259    -0.768     0.200
     0.813     0.395     0.200
     0.819     0.400     0.200
     0.130    -0.741     0.200
     0.158    -0.644     0.200
     0.107    -0.283     0.200
     0.185    -1.245     0.200
     0.185    -0.971     0.200
     0.174    -0.359     0.200
     0.177    -0.086     0.200
     0.235    -0.516     0.200
     0.286    -0.056     0.200
     0.417    -1.011     0.200
     0.707     1.170     0.200
     0.138    -0.714     0.200
     0.096     0.088     0.200
     0.114    -1.027     0.200
     0.161    -0.708     0.200
     0.187    -1.048     0.200
     0.163    -0.258     0.200
     0.170    -0.145     0.200
     0.217    -1.185     0.200
     0.283     0.215     0.200
     0.424    -0.959     0.200
     0.567     0.591     0.200
     0.712     1.048     0.200
     0.137     0.091     0.200
     0.196    -1.016     0.200
     0.137    -0.128     0.200
     0.241    -0.157     0.200
     0.268    -1.133     0.200
     0.268    -0.735     0.200
     0.214     0.007     0.200
     0.293    -1.735     0.200
     0.304    -0.386     0.200
     0.301    -0.739     0.200
     0.317     0.446     0.200
     0.480    -0.945     0.200
     0.644     0.025     0.200
     0.781     1.200     0.200
     0.051     0.003     0.200
     0.111    -0.081     0.200
     0.047    -0.025     0.200
     0.191    -1.016     0.200
     0.220    -0.432     0.200
     0.265    -1.074     0.200
     0.204     0.434     0.200
     0.287    -0.756     0.200
     0.662     0.590     0.200
     0.817     1.467     0.200
     0.097     0.291     0.200
     0.137    -0.536     0.200
     0.172     0.175     0.200
     0.216    -1.463     0.200
     0.225    -0.945     0.200
     0.284     0.258     0.200
     0.046    -0.412     0.200
     0.103    -0.447     0.200
     0.050     0.376     0.200
     0.208    -1.852     0.200
     0.213    -0.161     0.200
     0.258    -0.929     0.200
     0.210     0.154     0.200
     0.540    -0.736     0.200
     0.659    -0.716     0.200
     0.815     0.262     0.200
     0.820    -0.034     0.200
     0.934     0.137     0.200
     0.060    -1.434     0.200
     0.084    -0.086     0.200
     0.127    -0.184     0.200
     0.202     0.290     0.200
     0.231    -0.845     0.200
     0.655    -1.166     0.200
     0.034    -0.332     0.200
     0.033    -0.295     0.200
     0.039     0.178     0.200
     0.092    -0.286     0.200
     0.099    -0.030     0.200
     0.063    -0.071     0.200
     0.200    -0.825     0.200
     0.246    -0.449     0.200
     0.249    -0.647     0.200
     0.221     0.378     0.200
     0.647    -0.573     0.200
     0.019    -0.265     0.200
     0.090    -0.136     0.200
     0.148    -0.818     0.200
     0.153    -0.069     0.200
     0.137    -0.556     0.200
     0.153    -1.413     0.200
     0.163    -0.709     0.200
     0.203    -0.757     0.200
     0.204    -0.764     0.200
     0.213    -0.714     0.200
     0.291     0.054     0.200
     0.422    -1.139     0.200
     0.020    -0.210     0.200
     0.080    -0.543     0.200
     0.086     0.074     0.200
     0.139    -0.434     0.200
     0.150    -0.072     0.200
     0.146    -0.743     0.200
     0.163    -0.668     0.200
     0.199    -1.282     0.200
     0.269    -0.654     0.200
     0.292     0.340     0.200
     0.422    -1.161     0.200
     0.822     0.003     0.200
     0.057     0.148     0.200
     0.055    -0.295     0.200
     0.057    -0.453     0.200
     0.127    -0.168     0.200
     0.201    -1.398     0.200
     0.232    -0.774     0.200
     0.200    -0.356     0.200
     0.280    -0.636     0.200
     0.818    -0.798     0.200
     0.061    -0.673     0.200
     0.035    -0.642     0.200
     0.113    -0.250     0.200
     0.113    -0.049     0.200
     0.060     0.030     0.200
     0.181    -1.730     0.200
     0.220    -1.577     0.200
     0.224    -0.823     0.200
     0.224    -0.624     0.200
     0.261    -0.574     0.200
     0.272    -0.678     0.200
     0.272    -0.479     0.200
     0.395    -0.609     0.200
     0.674     0.353     0.200
     0.830     0.704     0.200
     0.104    -0.618     0.200
     0.121    -0.842     0.200
     0.158    -0.414     0.200
     0.185    -0.581     0.200
     0.190    -0.049     0.200
     0.230    -1.061     0.200
     0.249    -0.917     0.200
     0.409    -1.034     0.200
     0.561    -1.855     0.200
     0.079    -0.166     0.200
     0.148    -1.919     0.200
     0.191    -0.389     0.200
     0.246    -0.874     0.200
     0.266    -0.613     0.200
     0.282    -0.761     0.200
     0.261    -0.587     0.200
     0.230     0.658     0.200
     0.652     0.542     0.200
     0.814     0.175     0.200
     0.033    -0.260     0.200
     0.034    -0.908     0.200
     0.055     0.135     0.200
     0.122     0.137     0.200
     0.227    -1.054     0.200
     0.232    -0.396     0.200
     0.191     0.843     0.200
     0.255    -0.277     0.200
     0.279    -0.851     0.200
     0.267    -0.500     0.200
     0.299    -0.691     0.200
     0.551    -1.039     0.200
     0.675    -1.341     0.200
     0.829     0.451     0.200
     0.060    -0.606     0.200
     0.032    -0.317     0.200
     0.036    -0.587     0.200
     0.056     0.339     0.200
     0.110     0.181     0.200
     0.120     0.241     0.200
     0.189    -2.045     0.200
     0.193     0.326     0.200
     0.230    -0.730     0.200
     0.254    -0.325     0.200
     0.266    -0.468     0.200
     0.298    -0.360     0.200
     0.551    -1.328     0.200
     0.835     0.951     0.200
     0.044    -0.937     0.200
     0.082    -1.350     0.200
     0.111    -0.261     0.200
     0.183    -2.134     0.200
     0.241     0.408     0.200
     0.303    -0.799     0.200
     0.305    -0.740     0.200
     0.836    -1.126     0.200
     0.020    -0.069     0.200
     0.048    -0.484     0.200
     0.057    -0.664     0.200
     0.089     0.007     0.200
     0.083     0.185     0.200
     0.112    -0.001     0.200
     0.196    -1.471     0.200
     0.200    -0.694     0.200
     0.253    -1.009     0.200
     0.221     0.488     0.200
     0.265    -0.557     0.200
     0.819    -0.150     0.200
     0.017    -0.307     0.200
     0.034    -0.546     0.200
     0.111    -0.362     0.200
     0.267    -0.457     0.200
     0.198    -0.043     0.200
     0.277    -0.837     0.200
     0.280    -0.720     0.200
     0.304    -0.967     0.200
     0.560    -0.956     0.200
     0.677    -1.110     0.200
     0.839     0.810     0.200
     0.833     0.043     0.200
     0.113    -0.110     0.200
     0.133    -0.075     0.200
     0.226    -0.770     0.200
     0.194     0.116     0.200
     0.283    -0.896     0.200
     0.291    -0.387     0.200
     0.289    -0.854     0.200
     0.844    -0.432     0.200
     0.997    -0.800     0.200
     0.015     0.245     0.200
     0.049    -0.075     0.200
     0.096    -0.266     0.200
     0.203    -1.004     0.200
     0.207    -1.057     0.200
     0.262    -0.296     0.200
     0.261    -0.588     0.200
     0.270    -0.666     0.200
     0.213    -0.340     0.200
     0.292    -0.752     0.200
     0.822     0.130     0.200
     0.019    -0.219     0.200
     0.032    -0.446     0.200
     0.113    -0.258     0.200
     0.179    -1.426     0.200
     0.221    -0.940     0.200
     0.225    -0.685     0.200
     0.196    -0.127     0.200
     0.277    -0.667     0.200
     0.278    -0.274     0.200
     0.304    -0.845     0.200
     0.678    -0.510     0.200
     0.840     0.890     0.200
     0.047    -0.314     0.200
     0.066    -0.708     0.200
     0.105    -0.192     0.200
     0.180    -1.049     0.200
     0.204    -0.815     0.200
     0.209    -0.850     0.200
     0.230    -0.296     0.200
     0.240    -0.692     0.200
     0.268    -1.076     0.200
     0.220     0.173     0.200
     0.043     0.036     0.200
     0.088     0.049     0.200
     0.063    -0.351     0.200
     0.177    -1.073     0.200
     0.203    -0.969     0.200
     0.208    -0.912     0.200
     0.234    -0.612     0.200
     0.243    -0.697     0.200
     0.250    -0.114     0.200
     0.270    -0.760     0.200
     0.219     0.203     0.200
     0.052    -0.857     0.200
     0.029    -0.198     0.200
     0.043    -0.402     0.200
     0.066     0.371     0.200
     0.106     0.160     0.200
     0.111     0.103     0.200
     0.216    -0.944     0.200
     0.220    -0.672     0.200
     0.203    -0.454     0.200
     0.251    -0.653     0.200
     0.262    -0.712     0.200
     0.268     0.519     0.200
     0.291    -0.987     0.200
     0.051    -0.416     0.200
     0.055    -0.502     0.200
     0.127     0.103     0.200
     0.077     0.359     0.200
     0.119    -1.719     0.200
     0.181     0.019     0.200
     0.239    -0.418     0.200
     0.193     0.321     0.200
     0.311    -1.422     0.200
     0.327    -0.449     0.200
     0.355    -0.736     0.200
     0.021    -0.384     0.200
     0.045    -0.706     0.200
     0.064    -0.839     0.200
     0.103    -0.199     0.200
     0.052    -0.084     0.200
     0.052     0.291     0.200
     0.111    -0.181     0.200
     0.208     0.239     0.200
     0.291    -0.770     0.200
     0.391    -0.699     0.200
     0.050    -0.615     0.200
     0.051    -0.295     0.200
     0.032    -0.668     0.200
     0.046    -0.839     0.200
     0.103    -0.267     0.200
     0.067     0.154     0.200
     0.111    -0.019     0.200
     0.216    -1.846     0.200
     0.213     0.221     0.200
     0.220    -0.807     0.200
     0.204     0.544     0.200
     0.259    -0.388     0.200
     0.266    -0.753     0.200
     0.288    -0.714     0.200
     0.382    -0.544     0.200
     0.062    -0.911     0.200
     0.062     0.002     0.200
     0.017    -0.116     0.200
     0.035    -0.472     0.200
     0.062     0.002     0.200
     0.110    -0.043     0.200
     0.199     0.474     0.200
     0.213    -0.161     0.200
     0.222    -0.767     0.200
     0.275    -0.566     0.200
     0.274    -0.109     0.200
     0.302    -0.754     0.200
     0.399    -0.637     0.200
     0.051    -0.011     0.200
     0.050    -1.455     0.200
     0.026    -0.065     0.200
     0.046    -0.478     0.200
     0.069    -0.011     0.200
     0.106    -0.069     0.200
     0.216    -0.627     0.200
     0.208     0.497     0.200
     0.207     0.522     0.200
     0.262    -0.557     0.200
     0.264    -0.630     0.200
     0.289    -0.730     0.200
     0.023    -0.449     0.200
     0.031     0.322     0.200
     0.061     0.164     0.200
     0.070    -0.388     0.200
     0.112     0.084     0.200
     0.087    -0.796     0.200
     0.102     0.180     0.200
     0.208    -0.785     0.200
     0.204     0.104     0.200
     0.189    -2.213     0.200
     0.201    -1.501     0.200
     0.207    -0.373     0.200
     0.216    -0.514     0.200
     0.237    -0.836     0.200
     0.248    -0.352     0.200
     0.232     0.460     0.200
     0.342    -0.771     0.200
     0.011    -0.369     0.200
     0.076    -0.040     0.200
     0.078    -0.293     0.200
     0.037    -0.359     0.200
     0.106    -0.292     0.200
     0.066     0.080     0.200
     0.220    -0.034     0.200
     0.217    -1.946     0.200
     0.209    -0.191     0.200
     0.281    -0.414     0.200
     0.295    -0.731     0.200
     0.316    -0.731     0.200
     0.420    -0.609     0.200
     0.059    -0.992     0.200
     0.059    -0.369     0.200
     0.019     0.342     0.200
     0.039    -0.133     0.200
     0.116    -0.196     0.200
     0.064    -0.053     0.200
     0.108    -0.022     0.200
     0.175    -2.056     0.200
     0.215    -2.379     0.200
     0.211     0.239     0.200
     0.202     0.495     0.200
     0.272    -0.583     0.200
     0.298    -0.817     0.200
     0.396    -0.613     0.200
     0.037     0.394     0.200
     0.035    -1.187     0.200
     0.059    -1.418     0.200
     0.095     0.064     0.200
     0.100    -0.007     0.200
     0.081     0.267     0.200
     0.207    -0.584     0.200
     0.218     0.818     0.200
     0.252    -0.292     0.200
     0.276    -0.626     0.200
     0.050     0.379     0.200
     0.015     0.309     0.200
     0.109     0.688     0.200
     0.160     0.426     0.200
     0.159     0.820     0.200
     0.251     0.999     0.200
     0.262    -0.544     0.200
     0.300    -0.386     0.200
     0.315    -0.327     0.200
     0.433    -0.601     0.200
     0.032    -0.107     0.200
     0.044    -0.303     0.200
     0.099    -0.057     0.200
     0.033    -0.041     0.200
     0.066     0.150     0.200
     0.090     0.008     0.200
     0.160    -2.160     0.200
     0.195    -0.943     0.200
     0.244    -0.215     0.200
     0.253    -0.640     0.200
     0.246    -0.731     0.200
     0.046    -0.279     0.200
     0.061    -0.402     0.200
     0.029    -0.206     0.200
     0.103     0.339     0.200
     0.050    -0.892     0.200
     0.175    -2.216     0.200
     0.213    -0.297     0.200
     0.208    -1.880     0.200
     0.258    -0.954     0.200
     0.249    -0.573     0.200
     0.053    -0.641     0.200
     0.056    -0.097     0.200
     0.073    -0.848     0.200
     0.104     0.073     0.200
     0.042    -0.983     0.200
     0.063     0.037     0.200
     0.220    -1.757     0.200
     0.225    -0.533     0.200
     0.249    -0.753     0.200
     0.260    -0.794     0.200
     0.054    -1.342     0.200
     0.054    -0.021     0.200
     0.024     0.117     0.200
     0.042    -1.175     0.200
     0.066     0.076     0.200
     0.108    -0.115     0.200
     0.219    -0.659     0.200
     0.203     0.437     0.200
     0.255    -0.469     0.200
     0.265    -0.653     0.200
     0.293    -0.722     0.200
     0.084     0.047     0.200
     0.120    -1.917     0.200
     0.128     0.433     0.200
     0.155    -1.391     0.200
     0.162    -0.508     0.200
     0.136     0.331     0.200
     0.142    -1.299     0.200
     0.154     0.049     0.200
     0.193    -0.749     0.200
     0.210     0.206     0.200
     0.264    -0.666     0.200
     0.217     0.312     0.200
     0.298    -0.127     0.200
     0.295    -0.850     0.200
     0.287    -2.228     0.200
     0.285    -0.466     0.200
     0.050    -0.055     0.200
     0.075    -0.828     0.200
     0.062    -0.752     0.200
     0.067    -0.960     0.200
     0.079     0.200     0.200
     0.126     0.097     0.200
     0.220    -0.411     0.200
     0.222    -1.544     0.200
     0.228    -0.712     0.200
     0.208     0.487     0.200
     0.270    -0.700     0.200
     0.353    -0.620     0.200
     0.020     0.119     0.200
     0.104    -0.142     0.200
     0.066    -0.753     0.200
     0.044    -0.316     0.200
     0.053     0.261     0.200
     0.069     0.103     0.200
     0.215    -0.548     0.200
     0.207     0.513     0.200
     0.267    -0.638     0.200
     0.293    -0.756     0.200
     0.047    -1.064     0.200
     0.047     0.370     0.200
     0.049    -0.862     0.200
     0.072     0.184     0.200
     0.105     0.130     0.200
     0.210    -1.773     0.200
     0.215    -0.515     0.200
     0.209     0.569     0.200
     0.249    -0.605     0.200
     0.259    -0.569     0.200
     0.286    -0.719     0.200
     0.383    -0.523     0.200
     0.014    -0.950     0.200
     0.059    -0.193     0.200
     0.057     0.359     0.200
     0.068     0.487     0.200
     0.103     0.133     0.200
     0.211    -1.419     0.200
     0.215    -0.731     0.200
     0.205    -0.075     0.200
     0.264    -0.760     0.200
     0.273    -1.112     0.200
     0.029    -0.287     0.200
     0.035    -0.034     0.200
     0.069    -1.454     0.200
     0.087     0.079     0.200
     0.108    -0.165     0.200
     0.225    -0.572     0.200
     0.205    -1.452     0.200
     0.211    -0.947     0.200
     0.205     0.183     0.200
     0.354    -1.334     0.200
     0.009    -0.136     0.200
     0.041    -0.196     0.200
     0.077    -1.464     0.200
     0.073     0.079     0.200
     0.103    -0.159     0.200
     0.070     0.424     0.200
     0.205     0.548     0.200
     0.214    -1.328     0.200
     0.216    -0.686     0.200
     0.204     0.658     0.200
     0.286    -0.307     0.200
     0.294    -0.788     0.200
     0.314    -0.862     0.200
     0.009    -0.970     0.200
     0.010     0.385     0.200
     0.060    -0.601     0.200
     0.087    -0.163     0.200
     0.088    -0.666     0.200
     0.109     0.222     0.200
     0.180    -1.307     0.200
     0.186    -0.756     0.200
     0.182     0.307     0.200
     0.222    -0.536     0.200
     0.227    -0.484     0.200
     0.247    -0.953     0.200
     0.244    -0.028     0.200
     0.331    -1.242     0.200
     0.036     0.246     0.200
     0.038    -1.284     0.200
     0.030    -0.846     0.200
     0.062    -1.145     0.200
     0.090    -0.090     0.200
     0.086     0.075     0.200
     0.191     0.789     0.200
     0.194    -1.856     0.200
     0.199    -0.605     0.200
     0.224     0.338     0.200
     0.248    -0.397     0.200
     0.255    -0.577     0.200
     0.277    -0.871     0.200
     0.357    -1.674     0.200
     0.029    -0.952     0.200
     0.062     0.432     0.200
     0.035    -1.150     0.200
     0.078    -0.558     0.200
     0.057     0.409     0.200
     0.112     0.394     0.200
     0.118     0.098     0.200
     0.186    -1.511     0.200
     0.194    -0.035     0.200
     0.220     0.403     0.200
     0.228    -0.514     0.200
     0.257    -0.325     0.200
     0.268    -0.590     0.200
     0.299    -0.828     0.200
     0.050    -1.462     0.200
     0.050    -0.294     0.200
     0.065    -0.896     0.200
     0.025    -1.516     0.200
     0.046    -0.677     0.200
     0.107     0.276     0.200
     0.105     0.064     0.200
     0.070     0.384     0.200
     0.175    -1.669     0.200
     0.211    -1.898     0.200
     0.207     0.089     0.200
     0.215    -0.885     0.200
     0.253    -0.271     0.200
     0.207     0.082     0.200
     0.263    -0.572     0.200
     0.264     0.164     0.200
     0.289    -0.820     0.200
     0.049    -0.681     0.200
     0.030     0.210     0.200
     0.142    -1.397     0.200
     0.144     0.002     0.200
     0.158    -1.441     0.200
     0.184     0.259     0.200
     0.119     0.156     0.200
     0.188     0.336     0.200
     0.243    -1.577     0.200
     0.291    -0.124     0.200
     0.302    -0.594     0.200
     0.317    -0.773     0.200
     0.337    -0.506     0.200
     0.378    -1.003     0.200
     0.076     0.189     0.200
     0.076     0.019     0.200
     0.054    -0.021     0.200
     0.086    -0.904     0.200
     0.133     0.069     0.200
     0.117    -0.125     0.200
     0.117     0.094     0.200
     0.190     0.526     0.200
     0.278    -0.733     0.200
     0.278    -0.435     0.200
     0.289    -0.404     0.200
     0.316    -0.679     0.200
     0.412    -0.551     0.200
     0.048    -0.320     0.200
     0.063    -1.713     0.200
     0.158    -1.704     0.200
     0.159    -0.317     0.200
     0.114     0.329     0.200
     0.172    -0.382     0.200
     0.202    -0.266     0.200
     0.198     0.034     0.200
     0.312    -0.433     0.200
     0.336    -0.710     0.200
     0.356    -0.795     0.200
     0.395    -0.596     0.200
     0.465    -0.370     0.200
     0.055    -0.982     0.200
     0.036     0.154     0.200
     0.149    -0.606     0.200
     0.151    -0.469     0.200
     0.165    -1.444     0.200
     0.191     0.191     0.200
     0.194     0.130     0.200
     0.114    -0.370     0.200
     0.248    -1.460     0.200
     0.297     0.514     0.200
     0.308    -0.875     0.200
     0.323    -0.550     0.200
     0.343    -0.816     0.200
     0.365     0.216     0.200
     0.076    -0.073     0.200
     0.116    -0.298     0.200
     0.115    -0.332     0.200
     0.091    -1.262     0.200
     0.124    -0.013     0.200
     0.226    -0.707     0.200
     0.198    -0.078     0.200
     0.252    -1.017     0.200
     0.313    -0.879     0.200
     0.300    -0.677     0.200
     0.049    -0.559     0.200
     0.049     0.033     0.200
     0.026    -0.044     0.200
     0.047    -0.413     0.200
     0.106     0.328     0.200
     0.105    -0.030     0.200
     0.071     0.173     0.200
     0.175    -1.635     0.200
     0.210    -1.093     0.200
     0.207    -0.361     0.200
     0.214    -1.070     0.200
     0.208     0.065     0.200
     0.252    -0.758     0.200
     0.048     0.163     0.200
     0.029    -0.448     0.200
     0.048    -0.594     0.200
     0.103     0.074     0.200
     0.071     0.344     0.200
     0.106    -0.332     0.200
     0.177    -1.742     0.200
     0.210    -1.644     0.200
     0.215    -0.521     0.200
     0.207     0.335     0.200
     0.249    -0.705     0.200
     0.259    -0.613     0.200
     0.208    -0.098     0.200
     0.262     0.244     0.200
     0.018     0.018     0.200
     0.074    -0.021     0.200
     0.079    -0.419     0.200
     0.092     0.033     0.200
     0.055    -0.785     0.200
     0.083     0.293     0.200
     0.144    -0.083     0.200
     0.148    -1.620     0.200
     0.203    -2.551     0.200
     0.205    -0.447     0.200
     0.216     0.085     0.200
     0.291    -0.376     0.200
     0.014     0.358     0.200
     0.066    -0.357     0.200
     0.124    -1.042     0.200
     0.149    -0.298     0.200
     0.135    -1.233     0.200
     0.153    -0.650     0.200
     0.165    -0.768     0.200
     0.143     0.097     0.200
     0.211    -0.861     0.200
     0.225    -1.070     0.200
     0.229    -0.965     0.200
     0.022    -1.150     0.200
     0.040    -0.546     0.200
     0.091    -0.572     0.200
     0.091    -0.377     0.200
     0.110    -0.011     0.200
     0.152     0.430     0.200
     0.212     0.608     0.200
     0.224    -1.015     0.200
     0.222    -1.809     0.200
     0.199     0.239     0.200
     0.289     0.357     0.200
     0.299    -0.611     0.200
     0.307    -0.947     0.200
     0.328    -0.748     0.200
     0.057     0.130     0.200
     0.048    -0.057     0.200
     0.065    -1.046     0.200
     0.083     0.466     0.200
     0.107    -0.290     0.200
     0.182    -1.834     0.200
     0.205     0.193     0.200
     0.211    -0.838     0.200
     0.219     0.019     0.200
     0.229    -0.760     0.200
     0.250    -0.107     0.200
     0.239    -0.812     0.200
     0.268    -1.165     0.200
     0.356    -1.648     0.200
     0.058    -1.075     0.200
     0.099    -0.547     0.200
     0.167    -0.941     0.200
     0.111     0.216     0.200
     0.192     0.214     0.200
     0.197     0.311     0.200
     0.251    -2.060     0.200
     0.311     0.030     0.200
     0.324    -0.696     0.200
     0.345    -0.882     0.200
     0.387    -0.539     0.200
     0.046     0.047     0.200
     0.022    -0.907     0.200
     0.055     0.347     0.200
     0.110    -0.108     0.200
     0.104    -1.057     0.200
     0.120     0.266     0.200
     0.193    -0.506     0.200
     0.200    -0.675     0.200
     0.198    -0.825     0.200
     0.197    -0.500     0.200
     0.230    -0.952     0.200
     0.226    -0.379     0.200
     0.249     0.580     0.200
     0.036    -0.582     0.200
     0.063     0.127     0.200
     0.108    -0.044     0.200
     0.175    -0.890     0.200
     0.211     1.149     0.200
     0.220    -0.491     0.200
     0.200     0.318     0.200
     0.276    -0.609     0.200
     0.383    -2.110     0.200
     0.046     0.192     0.200
     0.050    -0.925     0.200
     0.073     0.285     0.200
     0.185    -0.738     0.200
     0.212    -0.504     0.200
     0.208    -1.489     0.200
     0.205     0.495     0.200
     0.210     0.566     0.200
     0.259    -0.578     0.200
     0.250     0.010     0.200
     0.285    -0.712     0.200
     0.369    -2.248     0.200
     0.385    -0.662     0.200
     0.007    -0.275     0.200
     0.037    -1.477     0.200
     0.065     0.049     0.200
     0.069     0.712     0.200
     0.075    -0.699     0.200
     0.105    -0.527     0.200
     0.166    -0.414     0.200
     0.208     0.521     0.200
     0.202     0.529     0.200
     0.215    -2.322     0.200
     0.218    -0.231     0.200
     0.275    -0.351     0.200
     0.284    -0.649     0.200
     0.307    -0.771     0.200
     0.410    -0.574     0.200
     0.062    -1.330     0.200
     0.078    -1.196     0.200
     0.224     0.671     0.200
     0.310    -0.481     0.200
     0.291    -0.650     0.200
     0.296    -0.687     0.200
     0.427    -0.372     0.200
     0.026    -0.433     0.200
     0.019    -0.655     0.200
     0.055    -0.236     0.200
     0.055     0.163     0.200
     0.082    -0.781     0.200
     0.081     0.049     0.200
     0.089    -0.216     0.200
     0.167    -0.788     0.200
     0.189     0.480     0.200
     0.220     0.297     0.200
     0.285    -0.539     0.200
     0.295    -0.615     0.200
     0.321    -0.859     0.200
     0.033    -0.850     0.200
     0.030     0.223     0.200
     0.036    -0.710     0.200
     0.070     0.241     0.200
     0.095     0.098     0.200
     0.156    -1.121     0.200
     0.191    -0.663     0.200
     0.245    -0.116     0.200
     0.232     0.606     0.200
     0.270    -0.882     0.200
     0.056    -0.079     0.200
     0.061     0.467     0.200
     0.026    -0.359     0.200
     0.069     0.665     0.200
     0.098     0.071     0.200
     0.137    -1.519     0.200
     0.137    -0.009     0.200
     0.148    -0.379     0.200
     0.183    -1.030     0.200
     0.176    -0.566     0.200
     0.186    -0.868     0.200
     0.234     0.112     0.200
     0.275    -0.540     0.200
     0.291    -1.126     0.200
     0.361    -0.628     0.200
     0.020    -0.900     0.200
     0.059     0.253     0.200
     0.059     0.184     0.200
     0.038    -1.600     0.200
     0.063     0.503     0.200
     0.176    -1.129     0.200
     0.180    -0.840     0.200
     0.172     0.134     0.200
     0.211    -0.208     0.200
     0.201     0.665     0.200
     0.216    -1.575     0.200
     0.220    -0.193     0.200
     0.261    -0.260     0.200
     0.298    -0.662     0.200
     0.036    -0.621     0.200
     0.084     0.110     0.200
     0.089    -0.776     0.200
     0.101     0.140     0.200
     0.117     0.188     0.200
     0.185    -0.275     0.200
     0.192    -1.703     0.200
     0.194    -0.550     0.200
     0.265    -0.471     0.200
     0.232     0.793     0.200
     0.302    -0.152     0.200
     0.315    -0.583     0.200
     0.375    -0.826     0.200
     0.044     0.405     0.200
     0.031    -0.525     0.200
     0.053    -1.408     0.200
     0.075     0.532     0.200
     0.177    -0.185     0.200
     0.174    -1.588     0.200
     0.187    -1.043     0.200
     0.177     0.326     0.200
     0.207    -1.498     0.200
     0.204    -0.476     0.200
     0.247    -0.211     0.200
     0.212     0.576     0.200
     0.258     0.459     0.200
     0.282    -0.411     0.200
     0.366    -1.911     0.200
     0.363    -0.761     0.200
     0.037    -0.080     0.200
     0.071    -0.222     0.200
     0.080     0.495     0.200
     0.085    -0.477     0.200
     0.105     0.461     0.200
     0.127    -0.848     0.200
     0.125     0.875     0.200
     0.116     0.184     0.200
     0.179    -0.108     0.200
     0.187    -1.339     0.200
     0.188    -0.561     0.200
     0.259    -0.269     0.200
     0.236     0.709     0.200
     0.299    -0.241     0.200
     0.310    -0.739     0.200
     0.369    -0.742     0.200
     0.028     0.231     0.200
     0.050    -0.508     0.200
     0.068    -1.304     0.200
     0.087     0.271     0.200
     0.168    -0.162     0.200
     0.181    -1.588     0.200
     0.203    -1.663     0.200
     0.203    -1.010     0.200
     0.209    -0.628     0.200
     0.202    -0.025     0.200
     0.190     0.347     0.200
     0.248    -0.013     0.200
     0.265    -0.591     0.200
     0.028    -0.318     0.200
     0.032     0.574     0.200
     0.054    -0.131     0.200
     0.049    -0.166     0.200
     0.068    -0.090     0.200
     0.087     0.224     0.200
     0.167     0.056     0.200
     0.180    -1.577     0.200
     0.208    -0.612     0.200
     0.202     0.223     0.200
     0.208    -0.812     0.200
     0.189     0.174     0.200
     0.201    -0.784     0.200
     0.189     0.275     0.200
     0.265    -0.627     0.200
     0.350    -0.655     0.200
     0.075     0.196     0.200
     0.013    -0.119     0.200
     0.076    -0.676     0.200
     0.078    -1.307     0.200
     0.049     0.150     0.200
     0.078     0.171     0.200
     0.154    -1.554     0.200
     0.142     0.404     0.200
     0.147     0.015     0.200
     0.198     0.225     0.200
     0.210    -0.589     0.200
     0.313    -0.791     0.200
     0.313    -0.353     0.200
     0.065    -0.734     0.200
     0.049    -0.044     0.200
     0.108    -0.936     0.200
     0.114    -0.219     0.200
     0.095    -1.047     0.200
     0.184    -0.069     0.200
     0.247    -0.398     0.200
     0.255    -1.336     0.200
     0.248     0.128     0.200
     0.251     0.409     0.200
     0.285     0.515     0.200
     0.291    -0.906     0.200
     0.323    -0.704     0.200
     0.325    -1.892     0.200
     0.423    -0.608     0.200
     0.041     0.040     0.200
     0.044    -0.903     0.200
     0.083    -0.324     0.200
     0.026    -0.376     0.200
     0.063    -0.307     0.200
     0.165    -0.281     0.200
     0.090     0.054     0.200
     0.190    -1.275     0.200
     0.194    -0.572     0.200
     0.185     0.418     0.200
     0.194    -0.802     0.200
     0.157    -0.294     0.200
     0.168     0.798     0.200
     0.247    -0.284     0.200
     0.281    -0.855     0.200
     0.023    -0.109     0.200
     0.046    -0.475     0.200
     0.072    -0.727     0.200
     0.094    -0.093     0.200
     0.094     0.136     0.200
     0.169    -0.989     0.200
     0.179    -0.353     0.200
     0.198    -0.862     0.200
     0.192    -1.211     0.200
     0.263    -0.870     0.200
     0.084    -0.307     0.200
     0.171    -1.838     0.200
     0.187    -0.744     0.200
     0.230     0.270     0.200
     0.567     0.082     0.200
     0.688     0.154     0.200
     0.842    -0.729     0.200
     0.773    -0.534     0.200
     0.825    -0.481     0.200
     0.997     0.101     0.200
     0.697    -0.387     0.200
     0.626     0.463     0.200
     0.609    -0.827     0.200
     0.950    -0.672     0.200
     0.610     0.856     0.200
     0.486     0.135     0.200
     0.677     0.693     0.200
     0.209    -0.047     0.200
     0.269    -0.611     0.200
     0.766    -1.703     0.200
     0.677    -1.046     0.200
     0.388    -0.165     0.200
     0.388     0.484     0.200
     0.956     0.103     0.200
     0.736    -0.281     0.200
     0.465    -0.305     0.200
     0.608     1.170     0.200
     0.521    -2.037     0.200
     0.786     0.070     0.200
     0.525     0.398     0.200
     0.675     0.371     0.200
     0.627     0.044     0.200
     0.605     0.673     0.200
     0.577    -0.287     0.200
     0.643    -0.754     0.200
     0.327     0.372     0.200
     0.653     0.496     0.200
     0.687     0.364     0.200
     0.676    -0.278     0.200
     0.391    -0.774     0.200
     0.575    -2.076     0.200
     0.649     0.194     0.200
     0.476    -0.043     0.200
     0.503     0.422     0.200
     0.606    -0.420     0.200
     0.241    -0.376     0.200
     0.602    -0.567     0.200
     0.851    -0.980     0.200
     0.769    -0.644     0.200
     0.718     1.317     0.200
     0.839     0.404     0.200
     0.210    -0.016     0.200
     0.887    -1.157     0.200
     0.943    -0.093     0.200
     0.604    -2.043     0.200
     0.673     0.259     0.200
     0.969     0.897     0.200
     0.641     0.128     0.200
     0.655     0.063     0.200
     0.325    -0.415     0.200
     0.484    -0.625     0.200
     0.924    -1.166     0.200
     0.606    -0.803     0.200
     0.707     0.206     0.200
     0.655    -0.602     0.200
     0.804    -0.186     0.200
     0.979    -0.703     0.200
     0.219     0.349     0.200
     0.240     0.217     0.200
     0.317     0.286     0.200
     0.338     0.256     0.200
     0.377     0.269     0.200
     0.576     0.248     0.200
     0.689    -0.031     0.200
     0.689     0.748     0.200
     0.889     0.685     0.200
     0.235     0.386     0.200
     0.261     0.090     0.200
     0.291    -0.063     0.200
     0.363     0.176     0.200
     0.112     0.195     0.200
     0.248     0.263     0.200
     0.392     0.565     0.200
     0.419     0.081     0.200
     0.468     0.131     0.200
     0.495     0.353     0.200
     0.494     0.048     0.200
     0.596     0.060     0.200
     0.609     0.525     0.200
     0.630     0.359     0.200
     0.669     0.268     0.200
     0.804     0.366     0.200
     0.833     0.518     0.200
     0.832     0.515     0.200
     0.945     0.551     0.200
     0.468    -1.237     0.200
     0.103    -0.011     0.200
     0.117     0.113     0.200
     0.396     0.057     0.200
     0.420     0.367     0.200
     0.474     0.100     0.200
     0.494     0.071     0.200
     0.495    -0.071     0.200
     0.599     0.101     0.200
     0.614     0.506     0.200
     0.635     0.751     0.200
     0.670    -0.082     0.200
     0.205     0.248     0.200
     0.205     0.168     0.200
     0.280     0.164     0.200
     0.330     0.165     0.200
     0.329     0.287     0.200
     0.384     0.389     0.200
     0.513     0.591     0.200
     0.539    -0.008     0.200
     0.554     0.279     0.200
     0.582     0.247     0.200
     0.653     0.678     0.200
     0.161     0.360     0.200
     0.181     0.353     0.200
     0.305     0.167     0.200
     0.401     0.493     0.200
     0.636     0.215     0.200
     0.651     0.323     0.200
     0.783     0.733     0.200
     0.114    -0.030     0.200
     0.180    -0.057     0.200
     0.199    -0.242     0.200
     0.266    -0.043     0.200
     0.492     0.310     0.200
     0.554     0.042     0.200
     0.702     0.108     0.200
     0.715     0.002     0.200
     0.949     0.288     0.200
     0.998     0.646     0.200
     0.071     0.261     0.200
     0.235    -0.581     0.200
     0.325    -0.267     0.200
     0.404    -0.202     0.200
     0.470     0.379     0.200
     0.611     0.349     0.200
     0.676    -0.019     0.200
     0.827     0.070     0.200
     0.863     0.039     0.200
     0.248    -0.614     0.200
     0.266     0.092     0.200
     0.358    -0.742     0.200
     0.465     0.314     0.200
     0.717     0.196     0.200
     0.864     0.486     0.200
     0.879    -0.241     0.200
     0.976     1.066     0.200
     0.052     0.891     0.200
     0.200     0.334     0.200
     0.340    -0.469     0.200
     0.339    -0.385     0.200
     0.377    -0.086     0.200
     0.766     0.406     0.200
     0.206     0.304     0.200
     0.224     0.374     0.200
     0.268     0.260     0.200
     0.307     0.239     0.200
     0.329     0.499     0.200
     0.366     0.092     0.200
     0.560     0.292     0.200
     0.639     0.374     0.200
     0.700     0.358     0.200
     0.904     0.319     0.200
     0.164     0.396     0.200
     0.180     0.282     0.200
     0.209     0.011     0.200
     0.356     0.144     0.200
     0.441     0.564     0.200
     0.623     0.616     0.200
     0.692     0.366     0.200
     0.287     0.169     0.200
     0.336     0.104     0.200
     0.361    -0.126     0.200
     0.362     0.189     0.200
     0.409     0.440     0.200
     0.461     0.507     0.200
     0.575     0.405     0.200
     0.600     0.249     0.200
     0.624     0.473     0.200
     0.623     0.392     0.200
     0.673     0.236     0.200
     0.763     0.452     0.200
     0.780     0.689     0.200
     0.817     0.633     0.200
     0.197    -0.651     0.200
     0.150     0.633     0.200
     0.231     0.039     0.200
     0.308    -0.689     0.200
     0.440     0.338     0.200
     0.676     0.023     0.200
     0.830    -0.092     0.200
     0.824     0.069     0.200
     0.955     0.016     0.200
     0.176    -0.064     0.200
     0.159     0.518     0.200
     0.220     0.277     0.200
     0.288    -0.013     0.200
     0.660     0.166     0.200
     0.810     0.096     0.200
     0.809     0.496     0.200
     0.378    -1.410     0.200
     0.192    -0.072     0.200
     0.207     0.230     0.200
     0.350    -0.090     0.200
     0.351    -0.086     0.200
     0.430    -0.162     0.200
     0.463     0.434     0.200
     0.543    -0.065     0.200
     0.546     0.019     0.200
     0.624    -0.198     0.200
     0.649    -0.065     0.200
     0.693     0.096     0.200
     0.747    -0.550     0.200
     0.753    -0.258     0.200
     0.764     0.524     0.200
     0.415    -0.040     0.200
     0.420    -0.548     0.200
     0.457     0.328     0.200
     0.556     0.240     0.200
     0.581     0.080     0.200
     0.631     0.473     0.200
     0.737     0.104     0.200
     0.309     0.242     0.200
     0.317    -0.068     0.200
     0.328     0.609     0.200
     0.355     0.254     0.200
     0.408     0.134     0.200
     0.478     0.331     0.200
     0.538    -0.294     0.200
     0.578     0.234     0.200
     0.677     0.410     0.200
     0.775    -0.149     0.200
     0.773     0.382     0.200
     0.106     0.147     0.200
     0.163     0.284     0.200
     0.259    -0.254     0.200
     0.337     0.053     0.200
     0.352     0.173     0.200
     0.540     0.193     0.200
     0.598     0.712     0.200
     0.625     0.480     0.200
     0.652     0.643     0.200
     0.136     0.082     0.200
     0.246     0.554     0.200
     0.286     0.289     0.200
     0.374     0.359     0.200
     0.397     0.176     0.200
     0.461     0.162     0.200
     0.490     0.136     0.200
     0.531     0.321     0.200
     0.536     0.152     0.200
     0.640     0.203     0.200
     0.639     0.183     0.200
     0.666     0.910     0.200
     0.712    -0.299     0.200
     0.711     0.000     0.200
     0.858     0.016     0.200
     0.205    -0.246     0.200
     0.197     0.277     0.200
     0.404     0.295     0.200
     0.402    -0.139     0.200
     0.410    -0.074     0.200
     0.474     0.195     0.200
     0.570     0.347     0.200
     0.672    -0.063     0.200
     0.697     0.205     0.200
     0.727     0.567     0.200
     0.774     0.197     0.200
     0.882    -1.161     0.200
     0.931     0.243     0.200
     0.295     0.183     0.200
     0.299    -0.001     0.200
     0.348     0.159     0.200
     0.368     0.047     0.200
     0.395     0.156     0.200
     0.471     0.425     0.200
     0.500     0.345     0.200
     0.541    -0.138     0.200
     0.575     0.264     0.200
     0.575    -0.027     0.200
     0.666     0.164     0.200
     0.730     0.467     0.200
     0.758     0.914     0.200
     0.774     0.032     0.200
     0.831     0.798     0.200
     0.917     0.482     0.200
     0.285     0.172     0.200
     0.290     0.386     0.200
     0.331     0.015     0.200
     0.355     0.010     0.200
     0.374     0.331     0.200
     0.453     0.227     0.200
     0.478     0.204     0.200
     0.524    -0.115     0.200
     0.555    -0.041     0.200
     0.557     0.085     0.200
     0.585    -0.063     0.200
     0.645     0.299     0.200
     0.643     0.361     0.200
     0.709     0.257     0.200
     0.737     0.506     0.200
     0.785     0.045     0.200
     0.836    -0.602     0.200
     0.810     0.733     0.200
     0.932     0.826     0.200
     0.277     0.046     0.200
     0.285     0.290     0.200
     0.327     0.057     0.200
     0.347    -0.304     0.200
     0.367     0.344     0.200
     0.449     0.187     0.200
     0.471     0.337     0.200
     0.517     0.069     0.200
     0.548    -0.019     0.200
     0.585     0.540     0.200
     0.639    -0.134     0.200
     0.700    -0.071     0.200
     0.729     0.358     0.200
     0.827    -0.457     0.200
     0.178    -0.071     0.200
     0.169     0.581     0.200
     0.281     0.064     0.200
     0.438    -0.188     0.200
     0.652     0.377     0.200
     0.804     0.044     0.200
     0.800    -0.060     0.200
     0.078     0.485     0.200
     0.161    -0.156     0.200
     0.251     0.162     0.200
     0.299     0.166     0.200
     0.317     0.105     0.200
     0.458     0.130     0.200
     0.473     0.207     0.200
     0.517     1.066     0.200
     0.526    -0.009     0.200
     0.555    -0.009     0.200
     0.569     0.603     0.200
     0.689     0.188     0.200
     0.148     0.769     0.200
     0.290    -0.327     0.200
     0.295    -0.115     0.200
     0.290    -0.192     0.200
     0.579    -0.475     0.200
     0.596    -0.262     0.200
     0.739    -0.449     0.200
     0.745    -0.459     0.200
     0.787     0.195     0.200
     0.235     0.072     0.200
     0.295     0.005     0.200
     0.301    -0.443     0.200
     0.419     0.609     0.200
     0.444     0.175     0.200
     0.479    -0.297     0.200
     0.541    -0.185     0.200
     0.611    -0.115     0.200
     0.652    -0.134     0.200
     0.670    -0.032     0.200
     0.707     0.153     0.200
     0.758     0.570     0.200
     0.772     0.115     0.200
     0.809     0.073     0.200
     0.939    -0.562     0.200
     0.942     0.371     0.200
     0.125     0.304     0.200
     0.222     0.558     0.200
     0.287     0.369     0.200
     0.291     0.439     0.200
     0.308     0.055     0.200
     0.322     0.351     0.200
     0.353     0.620     0.200
     0.426     0.812     0.200
     0.624    -0.028     0.200
     0.664     0.225     0.200
     0.713     0.261     0.200
     0.801     0.285     0.200
     0.192     0.049     0.200
     0.236     0.200     0.200
     0.285     0.031     0.200
     0.311     0.345     0.200
     0.347    -0.101     0.200
     0.357    -0.109     0.200
     0.362     0.102     0.200
     0.503     0.015     0.200
     0.518     0.112     0.200
     0.595     0.078     0.200
     0.606     0.051     0.200
     0.680     0.326     0.200
     0.706     0.136     0.200
     0.076     0.470     0.200
     0.197    -0.545     0.200
     0.333    -0.700     0.200
     0.401    -0.220     0.200
     0.452    -0.222     0.200
     0.543     0.296     0.200
     0.550    -0.176     0.200
     0.607     0.566     0.200
     0.812     0.020     0.200
     0.811     0.633     0.200
     0.822     0.075     0.200
     0.930     0.469     0.200
     0.291     0.128     0.200
     0.320     0.135     0.200
     0.383    -0.358     0.200
     0.397     0.132     0.200
     0.443    -0.013     0.200
     0.495     0.729     0.200
     0.520     0.348     0.200
     0.543    -0.171     0.200
     0.538    -0.561     0.200
     0.547     0.313     0.200
     0.605    -0.311     0.200
     0.700     0.373     0.200
     0.715     0.061     0.200
     0.733     0.327     0.200
     0.772     0.454     0.200
     0.805     0.184     0.200
     0.871    -0.202     0.200
     0.114    -0.050     0.200
     0.152     0.120     0.200
     0.222    -0.033     0.200
     0.326     0.465     0.200
     0.339    -0.108     0.200
     0.377     0.408     0.200
     0.527     0.623     0.200
     0.612     0.438     0.200
     0.644     0.637     0.200
     0.753     0.111     0.200
     0.775     0.749     0.200
     0.864     0.377     0.200
     0.580     0.255     0.200
     0.991     0.258     0.200
     0.183    -0.070     0.200
     0.267    -0.058     0.200
     0.284     0.030     0.200
     0.318    -0.151     0.200
     0.357    -0.301     0.200
     0.635    -0.183     0.200
     0.779     0.349     0.200
     0.783    -0.085     0.200
     0.820    -0.148     0.200
     0.856    -0.004     0.200
     0.894    -0.019     0.200
     0.891     0.446     0.200
     0.936     0.563     0.200
     0.115     0.747     0.200
     0.216    -0.306     0.200
     0.235     0.503     0.200
     0.252     0.357     0.200
     0.393     0.007     0.200
     0.421    -0.014     0.200
     0.472     0.100     0.200
     0.599    -0.167     0.200
     0.613    -0.043     0.200
     0.634     0.506     0.200
     0.671     0.134     0.200
     0.670     0.827     0.200
     0.685     0.349     0.200
     0.882     0.046     0.200
     0.949     0.756     0.200
     0.180     0.627     0.200
     0.309    -0.356     0.200
     0.282     0.653     0.200
     0.321     0.107     0.200
     0.322     0.333     0.200
     0.335     0.260     0.200
     0.380     1.010     0.200
     0.422     0.123     0.200
     0.488    -0.515     0.200
     0.473     0.249     0.200
     0.489     0.653     0.200
     0.572     0.646     0.200
     0.665     0.309     0.200
     0.912     0.205     0.200
     0.219     0.220     0.200
     0.300     0.366     0.200
     0.368    -0.551     0.200
     0.364    -0.326     0.200
     0.442     0.353     0.200
     0.539    -0.034     0.200
     0.584     0.210     0.200
     0.737    -0.308     0.200
     0.813    -0.261     0.200
     0.963     0.647     0.200
     0.792    -1.521     0.200
     0.154    -0.196     0.200
     0.192    -0.411     0.200
     0.247    -0.297     0.200
     0.325    -0.452     0.200
     0.684     0.442     0.200
     0.702    -0.543     0.200
     0.745    -0.291     0.200
     0.749    -0.602     0.200
     0.745     0.193     0.200
     0.803    -0.272     0.200
     0.834    -0.599     0.200
     0.899    -0.234     0.200
     0.998    -0.385     0.200
     0.147     0.135     0.200
     0.155     0.114     0.200
     0.228    -0.527     0.200
     0.402    -0.364     0.200
     0.502    -0.033     0.200
     0.593    -0.123     0.200
     0.660     0.733     0.200
     0.681    -0.647     0.200
     0.740    -0.156     0.200
     0.772    -0.229     0.200
     0.784    -0.028     0.200
     0.799    -0.512     0.200
     0.807     0.047     0.200
     0.882     0.320     0.200
     0.937     0.591     0.200
     0.072    -0.124     0.200
     0.233     0.216     0.200
     0.277    -0.332     0.200
     0.351    -0.428     0.200
     0.372     0.372     0.200
     0.396     0.188     0.200
     0.418     0.499     0.200
     0.455    -0.467     0.200
     0.470    -0.558     0.200
     0.539     0.025     0.200
     0.545     0.939     0.200
     0.686     0.028     0.200
     0.736     1.085     0.200
     0.870    -0.035     0.200
     0.977     0.046     0.200
     0.090    -0.177     0.200
     0.194    -0.365     0.200
     0.290    -0.345     0.200
     0.301     0.076     0.200
     0.329    -0.179     0.200
     0.458    -0.503     0.200
     0.511     0.366     0.200
     0.679    -0.021     0.200
     0.692    -0.293     0.200
     0.697    -0.101     0.200
     0.698     0.301     0.200
     0.723     0.643     0.200
     0.854     0.594     0.200
     0.974     0.456     0.200
     0.105    -0.461     0.200
     0.176    -0.322     0.200
     0.320    -0.126     0.200
     0.450     0.078     0.200
     0.493     0.046     0.200
     0.679    -0.072     0.200
     0.688    -0.135     0.200
     0.700    -0.343     0.200
     0.717    -0.231     0.200
     0.835     0.484     0.200
     0.160     0.241     0.200
     0.269    -0.258     0.200
     0.255     0.523     0.200
     0.369    -0.668     0.200
     0.430     0.185     0.200
     0.467    -0.295     0.200
     0.469     0.634     0.200
     0.467     0.680     0.200
     0.476     0.925     0.200
     0.705    -0.708     0.200
     0.997    -0.215     0.200
     0.117    -0.228     0.200
     0.162     0.177     0.200
     0.182    -0.122     0.200
     0.334    -0.143     0.200
     0.444    -0.362     0.200
     0.479     0.259     0.200
     0.668     0.174     0.200
     0.665     0.487     0.200
     0.686    -0.220     0.200
     0.694     0.770     0.200
     0.701    -0.683     0.200
     0.711    -0.314     0.200
     0.751    -0.091     0.200
     0.821     0.308     0.200
     0.998     0.959     0.200
     0.173     0.482     0.200
     0.309    -0.860     0.200
     0.288     0.196     0.200
     0.309     0.613     0.200
     0.314    -0.101     0.200
     0.377     0.838     0.200
     0.404    -0.133     0.200
     0.458     0.163     0.200
     0.479    -0.517     0.200
     0.489     0.455     0.200
     0.559     0.312     0.200
     0.648    -0.355     0.200
     0.688     0.318     0.200
     0.658     0.776     0.200
     0.707     0.105     0.200
     0.813    -0.080     0.200
     0.827    -0.126     0.200
     0.870    -0.266     0.200
     0.895    -0.397     0.200
     0.860     1.433     0.200
     0.157    -0.102     0.200
     0.179    -0.436     0.200
     0.269     0.352     0.200
     0.338    -0.708     0.200
     0.338    -0.453     0.200
     0.546     0.141     0.200
     0.686     0.149     0.200
     0.694     0.353     0.200
     0.699     0.385     0.200
     0.707    -0.705     0.200
     0.707     0.848     0.200
     0.746     0.185     0.200
     0.753    -0.310     0.200
     0.790    -0.410     0.200
     0.817    -0.264     0.200
     0.101     0.106     0.200
     0.234     0.311     0.200
     0.221    -0.167     0.200
     0.523    -0.166     0.200
     0.530     0.131     0.200
     0.535     0.356     0.200
     0.559     0.079     0.200
     0.587     0.179     0.200
     0.730     0.253     0.200
     0.739     0.078     0.200
     0.755     0.050     0.200
     0.768    -0.460     0.200
     0.801    -0.252     0.200
     0.856     0.516     0.200
     0.910     0.050     0.200
     0.905     0.052     0.200
     0.117    -0.211     0.200
     0.179     0.488     0.200
     0.256     0.041     0.200
     0.310    -0.386     0.200
     0.338    -0.159     0.200
     0.390    -0.351     0.200
     0.424    -0.016     0.200
     0.413     0.677     0.200
     0.460    -0.245     0.200
     0.584    -0.452     0.200
     0.869    -0.129     0.200
     0.881    -0.094     0.200
     0.170     0.411     0.200
     0.275    -0.066     0.200
     0.262     0.406     0.200
     0.359    -0.483     0.200
     0.437    -0.511     0.200
     0.461    -0.735     0.200
     0.470    -0.065     0.200
     0.478     0.107     0.200
     0.537    -1.270     0.200
     0.537    -0.692     0.200
     0.687     0.448     0.200
     0.956    -0.206     0.200
     0.207    -0.321     0.200
     0.234     0.744     0.200
     0.323     0.219     0.200
     0.381     0.363     0.200
     0.441     0.482     0.200
     0.534    -0.065     0.200
     0.541     0.637     0.200
     0.693     0.249     0.200
     0.797     0.354     0.200
     0.821    -0.257     0.200
     0.847     1.030     0.200
     0.033     0.644     0.200
     0.154     1.002     0.200
     0.320    -0.198     0.200
     0.370    -0.687     0.200
     0.387    -0.075     0.200
     0.476     0.908     0.200
     0.763    -0.906     0.200
     0.974    -0.945     0.200
     0.172     1.114     0.200
     0.279     0.041     0.200
     0.300     0.419     0.200
     0.295     0.874     0.200
     0.339     0.687     0.200
     0.382     1.160     0.200
     0.461    -0.626     0.200
     0.440     0.524     0.200
     0.499     0.521     0.200
     0.546     0.521     0.200
     0.625     0.491     0.200
     0.666    -0.841     0.200
     0.671    -0.590     0.200
     0.656     1.200     0.200
     0.709     0.776     0.200
     0.821    -0.090     0.200
     0.816     0.436     0.200
     0.866     0.018     0.200
     0.869    -0.320     0.200
     0.095    -0.113     0.200
     0.211     0.524     0.200
     0.286     0.164     0.200
     0.331     0.532     0.200
     0.349    -0.016     0.200
     0.368     0.367     0.200
     0.510    -0.039     0.200
     0.526    -0.744     0.200
     0.539     0.141     0.200
     0.533     0.543     0.200
     0.587     0.886     0.200
     0.628     0.205     0.200
     0.618     0.221     0.200
     0.674     0.046     0.200
     0.690    -0.005     0.200
     0.759    -0.539     0.200
     0.157     0.009     0.200
     0.158     0.846     0.200
     0.237     0.677     0.200
     0.297     0.087     0.200
     0.364    -0.559     0.200
     0.361    -0.188     0.200
     0.456     0.076     0.200
     0.494    -0.526     0.200
     0.467     0.246     0.200
     0.488     0.663     0.200
     0.711     0.790     0.200
     0.734    -0.407     0.200
     0.096     0.106     0.200
     0.113     0.702     0.200
     0.258     0.502     0.200
     0.327     0.109     0.200
     0.413    -0.287     0.200
     0.412     1.238     0.200
     0.420     0.619     0.200
     0.438     0.669     0.200
     0.480    -0.237     0.200
     0.526     0.893     0.200
     0.671     0.897     0.200
     0.738    -0.271     0.200
     0.037    -0.128     0.200
     0.280    -0.368     0.200
     0.390     0.302     0.200
     0.422    -0.271     0.200
     0.560     0.358     0.200
     0.584    -0.607     0.200
     0.826     0.974     0.200
     0.872     0.560     0.200
     0.917     0.097     0.200
     0.966    -0.356     0.200
     0.970     0.346     0.200
     0.187    -0.084     0.200
     0.226    -0.042     0.200
     0.256    -0.415     0.200
     0.333    -0.021     0.200
     0.401     0.138     0.200
     0.501     0.114     0.200
     0.554     0.163     0.200
     0.704     0.061     0.200
     0.826    -0.719     0.200
     0.832     0.192     0.200
     0.851     0.338     0.200
     0.861    -0.526     0.200
     0.876    -0.134     0.200
     0.893     0.898     0.200
     0.971     0.639     0.200
     0.037     0.440     0.200
     0.214     0.373     0.200
     0.537     0.509     0.200
     0.691    -0.257     0.200
     0.813    -0.424     0.200
     0.834    -0.064     0.200
     0.910    -0.452     0.200
     0.968     0.234     0.200
     0.098     0.200     0.200
     0.250    -0.215     0.200
     0.410    -0.002     0.200
     0.454    -0.890     0.200
     0.447     0.407     0.200
     0.449     1.259     0.200
     0.547     1.633     0.200
     0.664    -0.155     0.200
     0.203    -0.542     0.200
     0.318    -0.083     0.200
     0.318    -0.332     0.200
     0.412    -0.598     0.200
     0.505    -1.018     0.200
     0.589     0.354     0.200
     0.610    -0.697     0.200
     0.730     0.463     0.200
     0.739    -0.444     0.200
     0.788    -0.424     0.200
     0.825     1.475     0.200
     0.911     0.434     0.200
     0.971    -0.322     0.200
     0.997     0.292     0.200
     0.098    -0.033     0.200
     0.077     0.890     0.200
     0.159    -0.804     0.200
     0.351    -0.389     0.200
     0.300     0.320     0.200
     0.349     1.083     0.200
     0.428     0.177     0.200
     0.461     0.315     0.200
     0.480     0.769     0.200
     0.490     0.081     0.200
     0.569    -0.572     0.200
     0.611    -0.894     0.200
     0.747    -0.051     0.200
     0.879    -1.212     0.200
     0.594     0.662     0.200
     0.057    -0.207     0.200
     0.155     0.232     0.200
     0.221     0.486     0.200
     0.287     0.149     0.200
     0.318     0.138     0.200
     0.339    -0.051     0.200
     0.418     0.196     0.200
     0.471    -0.171     0.200
     0.545     0.178     0.200
     0.619    -0.600     0.200
     0.623    -0.012     0.200
     0.638     0.089     0.200
     0.698     0.359     0.200
     0.707    -0.308     0.200
     0.783    -1.144     0.200
     0.794    -0.692     0.200
     0.241    -0.044     0.200
     0.277     0.560     0.200
     0.349    -0.366     0.200
     0.345    -0.266     0.200
     0.422    -0.869     0.200
     0.404     0.113     0.200
     0.482     0.055     0.200
     0.577    -1.306     0.200
     0.550    -0.086     0.200
     0.853    -0.108     0.200
     0.327    -0.507     0.200
     0.333    -0.029     0.200
     0.317    -0.098     0.200
     0.334     0.254     0.200
     0.363     1.076     0.200
     0.426     0.048     0.200
     0.471     0.466     0.200
     0.506    -1.081     0.200
     0.471     0.874     0.200
     0.566    -0.329     0.200
     0.247    -1.309     0.200
     0.266     0.225     0.200
     0.308    -0.491     0.200
     0.322     0.740     0.200
     0.424    -0.163     0.200
     0.460     0.604     0.200
     0.486    -0.613     0.200
     0.793     0.290     0.200
     0.871    -0.703     0.200
     0.081    -0.221     0.200
     0.106     0.032     0.200
     0.181     0.808     0.200
     0.269     0.543     0.200
     0.294    -0.505     0.200
     0.301    -0.289     0.200
     0.369    -0.003     0.200
     0.432     0.167     0.200
     0.594    -0.092     0.200
     0.663    -0.187     0.200
     0.137    -0.175     0.200
     0.117    -0.008     0.200
     0.249    -0.312     0.200
     0.357     0.011     0.200
     0.379    -0.848     0.200
     0.423     0.301     0.200
     0.465    -0.283     0.200
     0.508     0.328     0.200
     0.643     0.347     0.200
     0.659    -0.389     0.200
     0.681    -0.213     0.200
     0.727    -0.123     0.200
     0.864    -0.418     0.200
     0.881     0.014     0.200
     0.106    -0.261     0.200
     0.092     0.210     0.200
     0.137     1.001     0.200
     0.317    -0.296     0.200
     0.392    -0.289     0.200
     0.386     0.397     0.200
     0.459    -0.076     0.200
     0.459     0.284     0.200
     0.514     1.054     0.200
     0.173     0.166     0.200
     0.193     0.162     0.200
     0.186    -0.322     0.200
     0.360    -0.558     0.200
     0.636     0.873     0.200
     0.662     0.301     0.200
     0.704     0.073     0.200
     0.775    -0.105     0.200
     0.782    -0.525     0.200
     0.046    -0.584     0.200
     0.112    -0.009     0.200
     0.111     0.075     0.200
     0.104     0.084     0.200
     0.247    -0.679     0.200
     0.244    -0.751     0.200
     0.309    -0.689     0.200
     0.455    -1.007     0.200
     0.474    -0.644     0.200
     0.561    -1.525     0.200
     0.577    -1.086     0.200
     0.905     0.006     0.200
     0.941    -0.121     0.200
     0.170    -0.601     0.200
     0.154     0.098     0.200
     0.184    -0.134     0.200
     0.299     0.017     0.200
     0.385    -0.429     0.200
     0.396     0.106     0.200
     0.445     0.196     0.200
     0.512     0.534     0.200
     0.535    -0.338     0.200
     0.623     0.210     0.200
     0.756     0.123     0.200
     0.849     0.160     0.200
     0.919     0.205     0.200
     0.955     0.459     0.200
     0.179    -0.545     0.200
     0.141     0.551     0.200
     0.180     0.127     0.200
     0.287    -0.229     0.200
     0.303     0.321     0.200
     0.399     0.257     0.200
     0.406     0.108     0.200
     0.526    -0.099     0.200
     0.549    -0.186     0.200
     0.636    -0.098     0.200
     0.739     0.354     0.200
     0.787    -0.054     0.200
     0.854     0.131     0.200
     0.952     0.631     0.200
     0.106    -0.644     0.200
     0.157    -0.161     0.200
     0.233    -0.252     0.200
     0.276     0.023     0.200
     0.333    -0.130     0.200
     0.331     0.247     0.200
     0.379     0.148     0.200
     0.522     0.125     0.200
     0.579     0.660     0.200
     0.610     0.345     0.200
     0.152     0.398     0.200
     0.224    -0.270     0.200
     0.238    -0.379     0.200
     0.328    -0.402     0.200
     0.411     0.137     0.200
     0.460     0.491     0.200
     0.485    -0.183     0.200
     0.651     0.308     0.200
     0.664     0.387     0.200
     0.688    -0.262     0.200
     0.699     0.459     0.200
     0.737     0.830     0.200
     0.759    -0.129     0.200
     0.791     0.486     0.200
     0.836    -0.191     0.200
     0.845    -0.033     0.200
     0.849     0.057     0.200
     0.836     0.521     0.200
     0.916     0.160     0.200
     0.930     0.346     0.200
     0.950    -0.837     0.200
     0.084    -0.178     0.200
     0.101     0.803     0.200
     0.173     0.766     0.200
     0.407     0.702     0.200
     0.445    -0.138     0.200
     0.457     0.225     0.200
     0.509    -0.195     0.200
     0.528    -0.528     0.200
     0.527     0.828     0.200
     0.147    -0.136     0.200
     0.156    -0.346     0.200
     0.183    -0.017     0.200
     0.204    -0.063     0.200
     0.309     0.007     0.200
     0.369     0.349     0.200
     0.378     0.580     0.200
     0.415    -0.176     0.200
     0.553     0.266     0.200
     0.615     0.100     0.200
     0.626     0.268     0.200
     0.074    -0.157     0.200
     0.138     0.317     0.200
     0.150    -0.199     0.200
     0.171    -0.613     0.200
     0.308     0.074     0.200
     0.326     0.002     0.200
     0.367     0.139     0.200
     0.374     0.088     0.200
     0.450     0.118     0.200
     0.457     0.119     0.200
     0.546     0.400     0.200
     0.570     0.302     0.200
     0.896     0.293     0.200
     0.085    -0.173     0.200
     0.142     0.060     0.200
     0.154    -0.277     0.200
     0.157     0.228     0.200
     0.327    -0.134     0.200
     0.341     0.235     0.200
     0.349     0.090     0.200
     0.389    -0.436     0.200
     0.390     0.285     0.200
     0.410     0.013     0.200
     0.461     0.059     0.200
     0.486     0.401     0.200
     0.530     0.034     0.200
     0.582     0.289     0.200
     0.606     0.109     0.200
     0.645     0.262     0.200
     0.113    -0.192     0.200
     0.161     0.159     0.200
     0.242    -0.278     0.200
     0.267    -0.368     0.200
     0.370     0.294     0.200
     0.393     0.105     0.200
     0.443    -0.127     0.200
     0.437    -0.004     0.200
     0.560     0.360     0.200
     0.646    -0.068     0.200
     0.636     0.553     0.200
     0.657     0.071     0.200
     0.710     0.569     0.200
     0.733     0.138     0.200
     0.745    -0.018     0.200
     0.726     0.687     0.200
     0.787    -0.010     0.200
     0.791    -0.180     0.200
     0.806    -0.373     0.200
     0.801     0.743     0.200
     0.853     0.700     0.200
     0.910     0.182     0.200
     0.187    -0.132     0.200
     0.251     0.244     0.200
     0.268     0.007     0.200
     0.303    -0.235     0.200
     0.329    -0.113     0.200
     0.451    -0.215     0.200
     0.538     0.102     0.200
     0.576     0.486     0.200
     0.636    -0.230     0.200
     0.779    -0.004     0.200
     0.826    -0.123     0.200
     0.828    -0.089     0.200
     0.837    -0.211     0.200
     0.845     0.319     0.200
     0.910     0.099     0.200
     0.163    -0.050     0.200
     0.243     0.122     0.200
     0.263     0.111     0.200
     0.328     0.037     0.200
     0.333     0.139     0.200
     0.359    -0.079     0.200
     0.388     0.161     0.200
     0.402     0.102     0.200
     0.445     0.250     0.200
     0.494    -1.044     0.200
     0.553     0.272     0.200
     0.577     0.172     0.200
     0.596    -0.041     0.200
     0.704     0.273     0.200
     0.778     0.402     0.200
     0.864     0.455     0.200
     0.093     0.291     0.200
     0.088    -0.096     0.200
     0.175     0.256     0.200
     0.256     0.346     0.200
     0.288    -0.155     0.200
     0.358     0.174     0.200
     0.425     0.006     0.200
     0.491     0.129     0.200
     0.565    -0.189     0.200
     0.579     0.459     0.200
     0.585     0.437     0.200
     0.626     0.166     0.200
     0.654     0.398     0.200
     0.755    -0.853     0.200
     0.737    -0.163     0.200
     0.758    -0.250     0.200
     0.913    -0.545     0.200
     0.923     0.014     0.200
     0.201    -0.004     0.200
     0.311     0.057     0.200
     0.315     0.259     0.200
     0.320     0.005     0.200
     0.345     0.158     0.200
     0.384     0.018     0.200
     0.415    -0.825     0.200
     0.399     0.080     0.200
     0.436    -0.034     0.200
     0.475     0.217     0.200
     0.505    -0.080     0.200
     0.551    -0.361     0.200
     0.586     0.135     0.200
     0.668     0.088     0.200
     0.764     0.184     0.200
     0.783     0.394     0.200
     0.105     0.141     0.200
     0.147    -0.157     0.200
     0.173    -0.023     0.200
     0.216     0.281     0.200
     0.230    -0.168     0.200
     0.332     0.179     0.200
     0.378     0.008     0.200
     0.416     0.160     0.200
     0.453    -0.049     0.200
     0.460    -0.115     0.200
     0.453     0.362     0.200
     0.554     0.210     0.200
     0.584     0.479     0.200
     0.597     0.485     0.200
     0.657     0.432     0.200
     0.701     0.121     0.200
     0.712     0.544     0.200
     0.786     0.140     0.200
     0.807     0.243     0.200
     0.112     0.141     0.200
     0.216    -0.055     0.200
     0.247    -0.054     0.200
     0.289     0.032     0.200
     0.313     0.304     0.200
     0.324     0.247     0.200
     0.343     0.170     0.200
     0.422    -0.631     0.200
     0.422     0.224     0.200
     0.428     0.326     0.200
     0.641     0.272     0.200
     0.677     0.370     0.200
     0.060    -0.186     0.200
     0.228     0.058     0.200
     0.255     0.871     0.200
     0.346    -0.540     0.200
     0.357    -0.331     0.200
     0.385     0.028     0.200
     0.392     0.494     0.200
     0.370    -1.026     0.200
     0.430    -0.699     0.200
     0.581    -0.666     0.200
     0.539     1.367     0.200
     0.586     1.048     0.200
     0.609     0.976     0.200
     0.792    -0.281     0.200
     0.794    -0.558     0.200
     0.849    -0.181     0.200
     0.926     0.092     0.200
     0.949    -0.191     0.200
     0.941     0.388     0.200
     0.974    -0.267     0.200
     0.980    -0.422     0.200
     0.061    -0.386     0.200
     0.112     0.141     0.200
     0.207     0.240     0.200
     0.279     0.457     0.200
     0.273     0.146     0.200
     0.328    -0.131     0.200
     0.379     0.179     0.200
     0.456     0.306     0.200
     0.484    -0.418     0.200
     0.559     0.048     0.200
     0.612     0.206     0.200
     0.644    -0.077     0.200
     0.648     0.243     0.200
     0.683     0.052     0.200
     0.732    -0.731     0.200
     0.733    -0.319     0.200
     0.738    -0.170     0.200
     0.769     0.420     0.200
     0.804     0.150     0.200
     0.873     0.135     0.200
     0.900     0.192     0.200
     0.924    -0.006     0.200
     0.177     0.257     0.200
     0.233     0.576     0.200
     0.354     0.061     0.200
     0.363    -0.215     0.200
     0.355     0.782     0.200
     0.398     0.448     0.200
     0.444    -0.819     0.200
     0.470     0.458     0.200
     0.598    -0.688     0.200
     0.572     0.616     0.200
     0.941    -0.162     0.200
     0.962    -0.365     0.200
     0.140     0.142     0.200
     0.142     0.414     0.200
     0.169     0.298     0.200
     0.202    -0.363     0.200
     0.328    -0.348     0.200
     0.353    -0.681     0.200
     0.367    -0.465     0.200
     0.372    -0.258     0.200
     0.381    -0.436     0.200
     0.398     0.053     0.200
     0.432    -0.015     0.200
     0.447    -0.233     0.200
     0.451     0.459     0.200
     0.504    -0.389     0.200
     0.503     0.259     0.200
     0.520     0.624     0.200
     0.534    -0.003     0.200
     0.636    -0.237     0.200
     0.643     0.101     0.200
     0.699    -0.980     0.200
     0.681     0.315     0.200
     0.693     0.189     0.200
     0.763     0.414     0.200
     0.925    -0.238     0.200
     0.150     0.579     0.200
     0.144     0.840     0.200
     0.176    -0.238     0.200
     0.259     0.346     0.200
     0.275     0.651     0.200
     0.379     0.254     0.200
     0.374     0.126     0.200
     0.446     0.097     0.200
     0.455     0.135     0.200
     0.500     0.490     0.200
     0.611    -1.466     0.200
     0.616     0.183     0.200
     0.631    -0.362     0.200
     0.628    -0.219     0.200
     0.637     0.503     0.200
     0.683     0.145     0.200
     0.702     0.674     0.200
     0.818    -0.228     0.200
     0.861     0.019     0.200
     0.935     0.548     0.200
     0.963     0.211     0.200
     0.981    -0.259     0.200
     0.226     0.126     0.200
     0.229     0.457     0.200
     0.254     0.121     0.200
     0.367     0.659     0.200
     0.432     0.134     0.200
     0.507    -0.272     0.200
     0.509     0.523     0.200
     0.611     0.078     0.200
     0.677    -0.600     0.200
     0.682     0.217     0.200
     0.683     0.786     0.200
     0.845     0.726     0.200
     0.124     0.058     0.200
     0.134     0.078     0.200
     0.155     0.354     0.200
     0.269     0.540     0.200
     0.318    -0.131     0.200
     0.496    -0.172     0.200
     0.544    -0.358     0.200
     0.532     0.444     0.200
     0.556     0.448     0.200
     0.618    -0.264     0.200
     0.672     0.087     0.200
     0.764     0.697     0.200
     0.808     0.094     0.200
     0.875     0.135     0.200
     0.157     0.042     0.200
     0.273     0.251     0.200
     0.284     0.248     0.200
     0.322    -0.279     0.200
     0.344    -0.136     0.200
     0.360     0.489     0.200
     0.420    -0.235     0.200
     0.443     1.094     0.200
     0.464     0.380     0.200
     0.507     0.519     0.200
     0.543     0.406     0.200
     0.588     0.577     0.200
     0.637     0.949     0.200
     0.722     0.813     0.200
     0.795     0.698     0.200
     0.795     0.806     0.200
     0.790     0.224     0.200
     0.095    -0.457     0.200
     0.101     0.083     0.200
     0.319     0.355     0.200
     0.464     0.165     0.200
     0.467    -0.476     0.200
     0.655    -0.710     0.200
     0.056     0.021     0.200
     0.180    -0.387     0.200
     0.198     0.283     0.200
     0.310     0.075     0.200
     0.413    -0.236     0.200
     0.412    -0.488     0.200
     0.486    -0.530     0.200
     0.554    -0.145     0.200
     0.578    -0.372     0.200
     0.626     0.520     0.200
     0.162    -0.625     0.200
     0.195    -0.269     0.200
     0.199    -0.151     0.200
     0.303    -0.601     0.200
     0.318    -0.127     0.200
     0.313    -0.157     0.200
     0.345    -0.628     0.200
     0.974     0.515     0.200
     0.059    -0.501     0.200
     0.205     0.321     0.200
     0.268     0.543     0.200
     0.271     0.099     0.200
     0.271     0.682     0.200
     0.281     0.138     0.200
     0.325     0.422     0.200
     0.369     0.080     0.200
     0.381     0.644     0.200
     0.467    -1.003     0.200
     0.453     0.095     0.200
     0.546     0.066     0.200
     0.592    -0.038     0.200
     0.624     0.526     0.200
     0.626     0.352     0.200
     0.625     0.055     0.200
     0.080    -0.457     0.200
     0.116    -0.287     0.200
     0.191    -0.160     0.200
     0.189     0.003     0.200
     0.241     0.223     0.200
     0.302     0.066     0.200
     0.350    -0.514     0.200
     0.492    -0.328     0.200
     0.499    -0.465     0.200
     0.563    -0.191     0.200
     0.679    -0.527     0.200
     0.739    -0.149     0.200
     0.762    -0.200     0.200
     0.752     0.012     0.200
     0.861     0.018     0.200
     0.887     0.224     0.200
     0.969    -0.455     0.200
     0.937    -0.238     0.200
     0.177    -0.293     0.200
     0.159    -0.170     0.200
     0.203     0.155     0.200
     0.243    -0.367     0.200
     0.362    -1.278     0.200
     0.341    -0.506     0.200
     0.406    -0.758     0.200
     0.444     0.264     0.200
     0.464    -0.280     0.200
     0.635     0.372     0.200
     0.653    -0.689     0.200
     0.689    -0.472     0.200
     0.710     0.336     0.200
     0.754    -0.455     0.200
     0.758    -0.588     0.200
     0.774     1.081     0.200
     0.785     0.752     0.200
     0.818     0.136     0.200
     0.869     0.118     0.200
     0.929     0.193     0.200
     0.988     0.002     0.200
     0.128    -0.500     0.200
     0.208    -0.725     0.200
     0.327    -0.429     0.200
     0.385    -0.482     0.200
     0.469     0.385     0.200
     0.503    -0.721     0.200
     0.475     0.595     0.200
     0.603     0.079     0.200
     0.655    -0.701     0.200
     0.770     0.349     0.200
     0.110    -0.105     0.200
     0.189    -0.068     0.200
     0.235    -0.376     0.200
     0.357     0.130     0.200
     0.391     0.182     0.200
     0.419     0.387     0.200
     0.465    -0.357     0.200
     0.579     0.708     0.200
     0.638     0.387     0.200
     0.660    -0.421     0.200
     0.661     0.224     0.200
     0.751     0.385     0.200
     0.762     0.234     0.200
     0.947    -0.464     0.200
     0.122     0.010     0.200
     0.118    -0.375     0.200
     0.195    -0.002     0.200
     0.394     0.133     0.200
     0.398    -0.197     0.200
     0.409    -0.187     0.200
     0.424    -0.046     0.200
     0.451     0.500     0.200
     0.585     0.263     0.200
     0.586     0.092     0.200
     0.638     0.415     0.200
     0.708     0.296     0.200
     0.106     0.494     0.200
     0.112     0.940     0.200
     0.117     0.025     0.200
     0.157     0.153     0.200
     0.271    -0.314     0.200
     0.359     0.175     0.200
     0.363     0.526     0.200
     0.399    -0.229     0.200
     0.421    -0.108     0.200
     0.477    -0.391     0.200
     0.591    -0.746     0.200
     0.644     0.211     0.200
     0.688    -0.161     0.200
     0.703     0.559     0.200
     0.731     0.008     0.200
     0.746    -0.186     0.200
     0.796    -0.105     0.200
     0.811    -0.403     0.200
     0.161     0.591     0.200
     0.290     0.192     0.200
     0.305     0.565     0.200
     0.302     0.011     0.200
     0.310     0.133     0.200
     0.362     0.184     0.200
     0.436    -1.096     0.200
     0.433     0.343     0.200
     0.449    -0.098     0.200
     0.464     0.021     0.200
     0.556    -0.155     0.200
     0.606    -0.585     0.200
     0.628     0.293     0.200
     0.698     0.083     0.200
     0.723    -0.266     0.200
     0.796     0.230     0.200
     0.836    -0.890     0.200
     0.841    -0.397     0.200
     0.051    -0.147     0.200
     0.282    -0.170     0.200
     0.294     1.452     0.200
     0.389    -0.278     0.200
     0.409    -0.479     0.200
     0.506     1.239     0.200
     0.537     0.962     0.200
     0.606     0.178     0.200
     0.683    -0.370     0.200
     0.723    -0.217     0.200
     0.862    -0.854     0.200
     0.877     0.314     0.200
     0.929    -0.528     0.200
     0.950    -0.081     0.200
     0.780    -1.350     0.200
     0.108     0.537     0.200
     0.226     0.134     0.200
     0.357     0.312     0.200
     0.392     0.426     0.200
     0.459    -0.042     0.200
     0.545     0.375     0.200
     0.603     0.243     0.200
     0.629     0.575     0.200
     0.650     0.274     0.200
     0.719     0.297     0.200
     0.919     0.498     0.200
     0.982     0.420     0.200
     0.658     2.150     0.200
     0.147    -0.141     0.200
     0.136    -0.083     0.200
     0.229    -0.034     0.200
     0.356    -0.045     0.200
     0.377     0.515     0.200
     0.432    -0.133     0.200
     0.541     0.415     0.200
     0.602     0.643     0.200
     0.620     0.441     0.200
     0.625     0.337     0.200
     0.693    -0.069     0.200
     0.730     0.048     0.200
     0.210     0.070     0.200
     0.302     0.185     0.200
     0.313     0.304     0.200
     0.336     0.605     0.200
     0.360    -0.103     0.200
     0.399    -0.855     0.200
     0.381    -0.044     0.200
     0.422    -0.345     0.200
     0.461     0.489     0.200
     0.484     0.591     0.200
     0.510    -0.238     0.200
     0.516    -0.017     0.200
     0.532     0.286     0.200
     0.571     0.095     0.200
     0.591     0.508     0.200
     0.681     0.332     0.200
     0.681     0.381     0.200
     0.747     0.304     0.200
     0.768     0.155     0.200
     0.775     0.323     0.200
     0.840     0.309     0.200
     0.854    -0.084     0.200
     0.848    -0.010     0.200
     0.950     0.542     0.200
     0.168     0.196     0.200
     0.294    -0.215     0.200
     0.451     0.299     0.200
     0.512     0.087     0.200
     0.515     0.098     0.200
     0.538    -0.351     0.200
     0.663    -0.374     0.200
     0.730    -0.466     0.200
     0.732     0.030     0.200
     0.787     0.632     0.200
     0.808    -0.126     0.200
     0.801     0.041     0.200
     0.816    -0.124     0.200
     0.807    -0.021     0.200
     0.116     0.346     0.200
     0.204     0.393     0.200
     0.267     0.224     0.200
     0.311    -0.134     0.200
     0.328    -0.613     0.200
     0.342    -0.088     0.200
     0.532    -0.282     0.200
     0.584     0.340     0.200
     0.714    -0.301     0.200
     0.708     0.378     0.200
     0.735    -0.363     0.200
     0.767    -0.327     0.200
     0.855    -0.349     0.200
     0.915    -0.268     0.200
     0.918     0.066     0.200
     0.942    -0.212     0.200
     0.145     0.947     0.200
     0.189     0.193     0.200
     0.288    -0.069     0.200
     0.292     0.067     0.200
     0.317    -0.096     0.200
     0.310     0.038     0.200
     0.396     0.202     0.200
     0.440    -0.980     0.200
     0.458    -1.007     0.200
     0.463     0.095     0.200
     0.510     0.050     0.200
     0.575     0.025     0.200
     0.568     0.358     0.200
     0.645     0.112     0.200
     0.667    -0.954     0.200
     0.674    -0.698     0.200
     0.730     0.793     0.200
     0.727     0.468     0.200
     0.781    -1.074     0.200
     0.799    -0.277     0.200
     0.809     0.120     0.200
     0.836    -0.874     0.200
     0.882    -0.614     0.200
     0.136     0.007     0.200
     0.168     0.191     0.200
     0.149    -0.686     0.200
     0.261     0.333     0.200
     0.358     0.295     0.200
     0.373     0.597     0.200
     0.446     0.329     0.200
     0.449    -0.428     0.200
     0.440     0.279     0.200
     0.484    -0.558     0.200
     0.564     0.047     0.200
     0.617    -0.990     0.200
     0.612    -0.487     0.200
     0.621     0.099     0.200
     0.684    -0.920     0.200
     0.681    -0.003     0.200
     0.777    -0.937     0.200
     0.784    -0.449     0.200
     0.805     0.125     0.200
     0.849    -1.146     0.200
     0.891    -0.961     0.200
     0.921     0.516     0.200
     0.959     0.219     0.200
     0.989    -0.350     0.200
     0.481    -1.248     0.200
     0.699    -0.247     0.200
     0.113     0.003     0.200
     0.140     0.279     0.200
     0.172     0.536     0.200
     0.218     0.406     0.200
     0.240    -0.293     0.200
     0.305     0.198     0.200
     0.333    -0.983     0.200
     0.373    -0.297     0.200
     0.438    -0.883     0.200
     0.476    -0.939     0.200
     0.474    -0.169     0.200
     0.473    -0.484     0.200
     0.487     0.265     0.200
     0.579    -0.302     0.200
     0.609    -0.398     0.200
     0.659    -0.497     0.200
     0.690    -0.297     0.200
     0.721    -0.551     0.200
     0.727    -0.250     0.200
     0.744     0.259     0.200
     0.744    -0.010     0.200
     0.776    -0.287     0.200
     0.816     1.133     0.200
     0.840     0.605     0.200
     0.906    -0.078     0.200
     0.960    -0.080     0.200
     0.973     0.571     0.200
     0.109     0.268     0.200
     0.177     0.048     0.200
     0.207     0.052     0.200
     0.305    -0.153     0.200
     0.315    -0.276     0.200
     0.316    -0.329     0.200
     0.364    -0.320     0.200
     0.434     0.613     0.200
     0.439    -0.514     0.200
     0.434     0.384     0.200
     0.515    -0.350     0.200
     0.561     0.331     0.200
     0.584    -0.459     0.200
     0.584    -0.578     0.200
     0.586    -0.094     0.200
     0.670    -0.418     0.200
     0.711    -0.130     0.200
     0.736    -0.986     0.200
     0.719    -0.555     0.200
     0.763    -0.265     0.200
     0.769    -1.141     0.200
     0.813    -0.067     0.200
     0.847     0.983     0.200
     0.942    -0.032     0.200
     0.134     0.241     0.200
     0.132     0.314     0.200
     0.183    -0.189     0.200
     0.255     0.223     0.200
     0.340     0.546     0.200
     0.328     0.197     0.200
     0.415    -0.203     0.200
     0.420    -0.053     0.200
     0.454     0.290     0.200
     0.465    -0.215     0.200
     0.585     0.773     0.200
     0.588     0.009     0.200
     0.661    -0.913     0.200
     0.658    -0.016     0.200
     0.746    -0.116     0.200
     0.866    -0.322     0.200
     0.884     0.872     0.200
     0.903     0.077     0.200
     0.927     0.033     0.200
     0.982     0.030     0.200
     0.986     0.003     0.200
     0.148     0.524     0.200
     0.207    -0.282     0.200
     0.270    -0.091     0.200
     0.296     0.360     0.200
     0.317    -0.349     0.200
     0.329    -0.364     0.200
     0.408    -0.832     0.200
     0.431    -0.801     0.200
     0.451     0.132     0.200
     0.571     0.078     0.200
     0.582     0.206     0.200
     0.602     0.153     0.200
     0.670    -0.125     0.200
     0.723    -0.176     0.200
     0.730    -0.006     0.200
     0.807     0.181     0.200
     0.799     0.200     0.200
     0.851    -0.059     0.200
     0.925    -0.809     0.200
     0.155     0.087     0.200
     0.249    -0.040     0.200
     0.263    -0.243     0.200
     0.318     0.594     0.200
     0.350     0.812     0.200
     0.393     0.204     0.200
     0.440    -0.127     0.200
     0.490    -0.781     0.200
     0.502    -0.465     0.200
     0.578    -0.614     0.200
     0.593    -0.705     0.200
     0.659    -0.347     0.200
     0.685    -0.583     0.200
     0.700     0.195     0.200
     0.699    -0.004     0.200
     0.773     0.315     0.200
     0.778     0.240     0.200
     0.787    -1.278     0.200
     0.850    -0.730     0.200
     0.860    -0.084     0.200
     0.883    -0.441     0.200
     0.915    -0.642     0.200
     0.040    -0.197     0.200
     0.165     0.102     0.200
     0.175     0.556     0.200
     0.248     0.511     0.200
     0.311     0.651     0.200
     0.347    -0.446     0.200
     0.376     0.201     0.200
     0.499    -0.417     0.200
     0.471     0.130     0.200
     0.484     0.178     0.200
     0.505    -0.098     0.200
     0.595     0.320     0.200
     0.710    -0.626     0.200
     0.732    -1.273     0.200
     0.724     0.290     0.200
     0.795    -0.709     0.200
     0.942    -0.308     0.200
     0.995    -0.289     0.200
     0.660     0.728     0.200
     0.139     0.237     0.200
     0.128     0.238     0.200
     0.265     0.039     0.200
     0.306     0.173     0.200
     0.371    -0.498     0.200
     0.371     0.141     0.200
     0.370     0.163     0.200
     0.528    -0.029     0.200
     0.664    -0.238     0.200
     0.679    -0.168     0.200
     0.679    -0.701     0.200
     0.841    -0.201     0.200
     0.942     0.474     0.200
     0.092     0.232     0.200
     0.317    -0.860     0.200
     0.295     0.408     0.200
     0.491     0.215     0.200
     0.526    -0.114     0.200
     0.504     0.659     0.200
     0.528     0.357     0.200
     0.634     1.170     0.200
     0.688     1.138     0.200
     0.719     1.911     0.200
     0.724     1.175     0.200
     0.919    -0.220     0.200
     0.184     0.205     0.200
     0.235    -0.210     0.200
     0.261     0.043     0.200
     0.384     0.741     0.200
     0.413     0.008     0.200
     0.488    -0.183     0.200
     0.484     0.108     0.200
     0.555    -0.793     0.200
     0.524     0.429     0.200
     0.580    -0.369     0.200
     0.570     0.561     0.200
     0.727    -0.428     0.200
     0.742     0.065     0.200
     0.740     0.636     0.200
     0.814     0.249     0.200
     0.936    -0.198     0.200
     0.212     0.058     0.200
     0.385     0.090     0.200
     0.395     0.272     0.200
     0.411     0.933     0.200
     0.460    -0.439     0.200
     0.480     0.696     0.200
     0.525    -0.459     0.200
     0.548     0.087     0.200
     0.548     0.850     0.200
     0.551     0.280     0.200
     0.650     0.171     0.200
     0.697    -0.107     0.200
     0.738    -0.394     0.200
     0.812     0.426     0.200
     0.880     0.192     0.200
     0.915    -0.491     0.200
     0.892     0.885     0.200
     0.946     0.267     0.200
     0.173    -0.451     0.200
     0.195    -0.176     0.200
     0.234    -0.036     0.200
     0.268     0.586     0.200
     0.349    -0.274     0.200
     0.427     0.608     0.200
     0.481     0.400     0.200
     0.500    -0.184     0.200
     0.524     0.031     0.200
     0.689     0.133     0.200
     0.719     0.237     0.200
     0.735     0.789     0.200
     0.757    -0.083     0.200
     0.839     0.260     0.200
     0.987    -0.165     0.200
     0.211     0.085     0.200
     0.121     0.493     0.200
     0.145     0.811     0.200
     0.240    -0.520     0.200
     0.344    -0.100     0.200
     0.367     1.501     0.200
     0.430    -0.660     0.200
     0.409     1.164     0.200
     0.489     0.031     0.200
     0.541     0.643     0.200
     0.578     0.454     0.200
     0.752    -0.231     0.200
     0.831    -0.620     0.200
     0.085     0.600     0.200
     0.218     0.840     0.200
     0.254     0.755     0.200
     0.274     0.263     0.200
     0.337     0.036     0.200
     0.350     0.027     0.200
     0.366     0.229     0.200
     0.517    -0.774     0.200
     0.514    -0.148     0.200
     0.542     0.730     0.200
     0.615    -0.375     0.200
     0.626     0.576     0.200
     0.667     0.259     0.200
     0.681     0.602     0.200
     0.785    -0.502     0.200
     0.855     0.752     0.200
     0.887     0.680     0.200
     0.099    -0.167     0.200
     0.101    -0.008     0.200
     0.166    -0.015     0.200
     0.266    -0.416     0.200
     0.271    -0.133     0.200
     0.297    -0.049     0.200
     0.341    -0.235     0.200
     0.428     0.121     0.200
     0.521    -0.442     0.200
     0.545    -0.101     0.200
     0.722     0.138     0.200
     0.764     0.317     0.200
     0.766     0.424     0.200
     0.796     0.291     0.200
     0.831     0.277     0.200
     0.936    -0.343     0.200
     0.263    -0.337     0.200
     0.060    -0.157     0.200
     0.123     0.317     0.200
     0.203     1.031     0.200
     0.304    -0.263     0.200
     0.304    -0.071     0.200
     0.388     0.517     0.200
     0.453     0.043     0.200
     0.510     0.016     0.200
     0.584    -0.672     0.200
     0.591    -0.217     0.200
     0.615     0.280     0.200
     0.657     0.245     0.200
     0.684     0.486     0.200
     0.790    -0.381     0.200
     0.917    -0.742     0.200
     0.926    -0.018     0.200
     0.185    -0.070     0.200
     0.266    -0.093     0.200
     0.280     0.029     0.200
     0.267    -0.214     0.200
     0.348     0.214     0.200
     0.461    -0.373     0.200
     0.441     0.551     0.200
     0.527    -0.041     0.200
     0.535     0.509     0.200
     0.743    -0.775     0.200
     0.763    -0.184     0.200
     0.870    -0.875     0.200
     0.911    -0.237     0.200
     0.998     0.208     0.200
     0.067     0.137     0.200
     0.107     0.060     0.200
     0.209     0.596     0.200
     0.339     0.069     0.200
     0.373     0.128     0.200
     0.456    -0.177     0.200
     0.472    -0.303     0.200
     0.547    -0.139     0.200
     0.552     0.293     0.200
     0.609     0.320     0.200
     0.643     0.711     0.200
     0.680     0.390     0.200
     0.726     0.172     0.200
     0.761     0.601     0.200
     0.864    -0.370     0.200
     0.857     0.557     0.200
     0.878     0.299     0.200
     0.888    -0.150     0.200
     0.914    -0.637     0.200
     0.558     0.414     0.200
     0.092    -0.099     0.200
     0.178    -0.097     0.200
     0.242     0.047     0.200
     0.265    -0.056     0.200
     0.361     0.069     0.200
     0.404     0.628     0.200
     0.551     0.322     0.200
     0.608     0.157     0.200
     0.638     0.836     0.200
     0.930     0.935     0.200
     0.097     0.159     0.200
     0.203     0.196     0.200
     0.224     0.016     0.200
     0.329    -0.308     0.200
     0.340    -0.181     0.200
     0.332     0.197     0.200
     0.465    -0.834     0.200
     0.451     0.128     0.200
     0.793     0.183     0.200
     0.061     0.143     0.200
     0.110     0.106     0.200
     0.131    -0.016     0.200
     0.224    -0.386     0.200
     0.231    -0.383     0.200
     0.284     0.443     0.200
     0.279     0.732     0.200
     0.366    -0.121     0.200
     0.443    -0.741     0.200
     0.535    -0.327     0.200
     0.527     0.378     0.200
     0.523     0.979     0.200
     0.958     0.466     0.200
     0.988     0.278     0.200
     0.276    -0.742     0.200
     0.208     0.616     0.200
     0.242    -0.062     0.200
     0.328     0.297     0.200
     0.351     0.245     0.200
     0.351    -0.255     0.200
     0.379     0.209     0.200
     0.469    -0.064     0.200
     0.469    -0.424     0.200
     0.595    -0.357     0.200
     0.710     0.368     0.200
     0.746    -0.352     0.200
     0.790    -0.222     0.200
     0.790     0.416     0.200
     0.890     0.600     0.200
     0.903     0.229     0.200
     0.073     0.464     0.200
     0.091     0.805     0.200
     0.150    -0.376     0.200
     0.217     0.070     0.200
     0.228    -0.473     0.200
     0.270    -0.480     0.200
     0.265     0.121     0.200
     0.494    -0.792     0.200
     0.538     0.480     0.200
     0.544    -0.814     0.200
     0.658    -0.089     0.200
     0.064     0.019     0.200
     0.095     0.284     0.200
     0.145    -0.578     0.200
     0.213     0.322     0.200
     0.218    -0.237     0.200
     0.268     0.329     0.200
     0.426    -0.683     0.200
     0.488    -0.307     0.200
     0.526     0.148     0.200
     0.528    -0.226     0.200
     0.528    -0.634     0.200
     0.547    -0.477     0.200
     0.628    -0.575     0.200
     0.648    -0.239     0.200
     0.691    -0.386     0.200
     0.693    -0.340     0.200
     0.722    -0.031     0.200
     0.753     0.029     0.200
     0.753     0.193     0.200
     0.804     0.007     0.200
     0.137    -0.204     0.200
     0.134     0.015     0.200
     0.179    -0.409     0.200
     0.246     0.346     0.200
     0.249    -0.362     0.200
     0.280    -0.425     0.200
     0.363    -0.049     0.200
     0.356    -0.368     0.200
     0.383     0.482     0.200
     0.513    -0.579     0.200
     0.518     0.672     0.200
     0.534    -0.201     0.200
     0.567    -0.343     0.200
     0.601    -0.468     0.200
     0.650    -0.640     0.200
     0.666    -0.439     0.200
     0.722     0.162     0.200
     0.741    -0.238     0.200
     0.762    -0.218     0.200
     0.787     0.181     0.200
     0.801    -0.207     0.200
     0.872    -0.342     0.200
     0.868     0.095     0.200
     0.956    -0.177     0.200
     0.063    -0.405     0.200
     0.102    -0.163     0.200
     0.138    -0.709     0.200
     0.223    -0.076     0.200
     0.222    -0.588     0.200
     0.276    -0.103     0.200
     0.278    -0.508     0.200
     0.358    -0.974     0.200
     0.435    -0.252     0.200
     0.497    -0.810     0.200
     0.532     0.351     0.200
     0.529     0.012     0.200
     0.637    -0.459     0.200
     0.654    -0.779     0.200
     0.665     0.261     0.200
     0.700    -0.489     0.200
     0.701    -0.030     0.200
     0.762    -0.703     0.200
     0.753    -0.004     0.200
     0.812    -0.397     0.200
     0.163     0.200     0.200
     0.190    -0.050     0.200
     0.329     0.532     0.200
     0.382     0.371     0.200
     0.431     0.560     0.200
     0.423     0.150     0.200
     0.458    -0.231     0.200
     0.488     0.214     0.200
     0.554     0.265     0.200
     0.587     0.063     0.200
     0.662    -0.233     0.200
     0.680    -0.059     0.200
     0.683     0.290     0.200
     0.707    -0.364     0.200
     0.744    -0.438     0.200
     0.753     0.309     0.200
     0.775     0.551     0.200
     0.849    -0.086     0.200
     0.857     0.018     0.200
     0.871     0.116     0.200
     0.933     0.110     0.200
     0.943     0.245     0.200
     0.959     0.465     0.200
     0.969     1.163     0.200
     0.997    -0.451     0.200
     0.135     0.039     0.200
     0.134     0.305     0.200
     0.181     0.012     0.200
     0.216    -0.055     0.200
     0.257     0.382     0.200
     0.341     0.040     0.200
     0.331     0.132     0.200
     0.416     0.086     0.200
     0.420    -0.010     0.200
     0.455     0.123     0.200
     0.601    -0.813     0.200
     0.661    -0.660     0.200
     0.746    -0.062     0.200
     0.751    -0.343     0.200
     0.770     0.082     0.200
     0.813    -0.102     0.200
     0.901     0.806     0.200
     0.928     0.240     0.200
     0.974     0.854     0.200
     0.983     0.284     0.200
     0.984     0.300     0.200
     0.020    -0.000     0.200
     0.096    -0.142     0.200
     0.148    -0.135     0.200
     0.188     0.017     0.200
     0.238    -0.428     0.200
     0.475    -0.745     0.200
     0.481    -0.218     0.200
     0.497    -0.613     0.200
     0.504     0.295     0.200
     0.620     0.105     0.200
     0.680    -0.151     0.200
     0.703     0.171     0.200
     0.736     0.161     0.200
     0.765    -0.284     0.200
     0.796     0.550     0.200
     0.021     0.263     0.200
     0.106     0.070     0.200
     0.138     0.304     0.200
     0.188     0.048     0.200
     0.229    -0.128     0.200
     0.380    -0.427     0.200
     0.448    -0.822     0.200
     0.482    -0.582     0.200
     0.491    -0.338     0.200
     0.487    -0.033     0.200
     0.504     0.312     0.200
     0.621     0.114     0.200
     0.625    -0.179     0.200
     0.672    -0.245     0.200
     0.676     0.696     0.200
     0.696    -0.500     0.200
     0.709    -0.181     0.200
     0.709     0.527     0.200
     0.726    -0.190     0.200
     0.731     0.057     0.200
     0.759     0.101     0.200
     0.793     0.096     0.200
     0.826    -0.468     0.200
     0.856     0.755     0.200
     0.912    -0.083     0.200
     0.972    -0.150     0.200
     0.995     0.175     0.200
     0.134     0.131     0.200
     0.174    -0.198     0.200
     0.207    -0.252     0.200
     0.299    -0.380     0.200
     0.337    -0.522     0.200
     0.386    -0.043     0.200
     0.486    -0.843     0.200
     0.556     0.298     0.200
     0.583    -0.750     0.200
     0.625     0.334     0.200
     0.644     0.159     0.200
     0.695    -0.492     0.200
     0.706    -0.155     0.200
     0.724    -0.382     0.200
     0.729    -0.632     0.200
     0.743    -0.081     0.200
     0.768     0.011     0.200
     0.834    -0.123     0.200
     0.839     0.180     0.200
     0.828     0.283     0.200
     0.858     0.391     0.200
     0.915     0.325     0.200
     0.147     0.522     0.200
     0.188    -0.178     0.200
     0.216    -0.003     0.200
     0.313    -0.912     0.200
     0.352    -0.688     0.200
     0.397    -0.554     0.200
     0.498    -0.007     0.200
     0.562    -0.299     0.200
     0.598    -0.641     0.200
     0.636    -0.757     0.200
     0.659    -0.399     0.200
     0.700     0.046     0.200
     0.712     0.095     0.200
     0.736     0.272     0.200
     0.744    -0.352     0.200
     0.744     0.275     0.200
     0.783    -0.208     0.200
     0.837    -0.346     0.200
     0.853    -0.673     0.200
     0.870     0.152     0.200
     0.877     0.025     0.200
     0.930     0.363     0.200
     0.157     0.517     0.200
     0.196     0.232     0.200
     0.196     0.353     0.200
     0.219     0.347     0.200
     0.323    -0.405     0.200
     0.360    -0.388     0.200
     0.405    -0.277     0.200
     0.507    -0.372     0.200
     0.568     0.318     0.200
     0.607    -1.165     0.200
     0.641     0.147     0.200
     0.668     0.476     0.200
     0.706     0.223     0.200
     0.719     0.435     0.200
     0.745    -0.133     0.200
     0.747     0.222     0.200
     0.792     0.057     0.200
     0.850     0.207     0.200
     0.841    -0.273     0.200
     0.876    -0.357     0.200
     0.940    -0.023     0.200
     0.062     0.282     0.200
     0.094     0.462     0.200
     0.147    -0.497     0.200
     0.209     0.350     0.200
     0.214    -0.082     0.200
     0.286    -0.082     0.200
     0.346    -0.114     0.200
     0.422     0.205     0.200
     0.484    -1.313     0.200
     0.521     0.001     0.200
     0.526    -0.910     0.200
     0.544    -0.137     0.200
     0.623    -0.413     0.200
     0.644    -0.228     0.200
     0.651    -0.567     0.200
     0.689    -0.549     0.200
     0.691    -0.390     0.200
     0.716    -0.804     0.200
     0.748     0.339     0.200
     0.741     0.429     0.200
     0.773    -0.153     0.200
     0.867     1.137     0.200
     0.094    -0.265     0.200
     0.107    -0.461     0.200
     0.155     0.017     0.200
     0.262    -0.930     0.200
     0.258    -0.341     0.200
     0.287     0.008     0.200
     0.417    -0.556     0.200
     0.499    -0.155     0.200
     0.525    -0.129     0.200
     0.560    -0.737     0.200
     0.578    -0.448     0.200
     0.609    -0.636     0.200
     0.649    -0.324     0.200
     0.694    -0.167     0.200
     0.697    -0.826     0.200
     0.729     0.495     0.200
     0.728    -0.584     0.200
     0.737     0.042     0.200
     0.756    -0.910     0.200
     0.791     0.218     0.200
     0.825     0.033     0.200
     0.821     0.052     0.200
     0.842     0.245     0.200
     0.924    -0.211     0.200
     0.941     0.074     0.200
     0.976     0.197     0.200
     0.185     0.083     0.200
     0.267    -0.404     0.200
     0.303    -0.895     0.200
     0.469    -0.481     0.200
     0.594     0.425     0.200
     0.676    -0.346     0.200
     0.696    -0.118     0.200
     0.852    -0.108     0.200
     0.973    -0.289     0.200
     0.994    -0.139     0.200
     0.100     0.734     0.200
     0.115    -0.260     0.200
     0.151     0.317     0.200
     0.258     0.111     0.200
     0.317    -0.291     0.200
     0.568     0.192     0.200
     0.591    -0.447     0.200
     0.636     0.680     0.200
     0.854    -0.609     0.200
     0.960     0.043     0.200
     0.035     0.129     0.200
     0.245     0.417     0.200
     0.367    -0.926     0.200
     0.401    -0.404     0.200
     0.453    -0.005     0.200
     0.671     0.227     0.200
     0.683     0.934     0.200
     0.705     0.186     0.200
     0.970    -0.046     0.200
     0.138    -0.014     0.200
     0.170     0.330     0.200
     0.191     0.102     0.200
     0.282     0.120     0.200
     0.293     0.591     0.200
     0.398     0.252     0.200
     0.451     0.016     0.200
     0.467     0.209     0.200
     0.522    -0.082     0.200
     0.652     0.397     0.200
     0.661     0.280     0.200
     0.725     0.597     0.200
     0.107     0.388     0.200
     0.126     0.097     0.200
     0.146     0.448     0.200
     0.153     0.185     0.200
     0.300    -0.188     0.200
     0.313     0.019     0.200
     0.324    -0.359     0.200
     0.515     0.030     0.200
     0.527    -0.724     0.200
     0.540    -0.061     0.200
     0.621    -0.148     0.200
     0.160     0.015     0.200
     0.290     0.392     0.200
     0.297     0.071     0.200
     0.301    -0.001     0.200
     0.316     0.207     0.200
     0.352     0.365     0.200
     0.424     0.333     0.200
     0.460     0.318     0.200
     0.618    -0.282     0.200
     0.719     0.529     0.200
     0.737    -0.110     0.200
     0.818     0.303     0.200
     0.088    -0.054     0.200
     0.177     0.199     0.200
     0.223     0.181     0.200
     0.230    -0.002     0.200
     0.295     0.136     0.200
     0.335     0.224     0.200
     0.368    -0.135     0.200
     0.368     0.136     0.200
     0.489     0.033     0.200
     0.585     0.319     0.200
     0.594    -0.086     0.200
     0.030     0.078     0.200
     0.096     0.054     0.200
     0.151     0.060     0.200
     0.195     0.063     0.200
     0.250     0.066     0.200
     0.248     0.058     0.200
     0.328    -0.059     0.200
     0.478     0.244     0.200
     0.516     0.679     0.200
     0.990    -0.185     0.200
     0.065     0.403     0.200
     0.201    -0.137     0.200
     0.261     0.467     0.200
     0.277     0.156     0.200
     0.278     0.198     0.200
     0.279     0.188     0.200
     0.331    -0.058     0.200
     0.375     0.028     0.200
     0.389     0.014     0.200
     0.502    -0.201     0.200
     0.553    -0.492     0.200
     0.596    -0.094     0.200
     0.618    -0.079     0.200
     0.630     0.069     0.200
     0.702    -0.426     0.200
     0.707    -0.554     0.200
     0.732    -0.983     0.200
     0.703    -0.104     0.200
     0.767    -0.146     0.200
     0.778    -0.179     0.200
     0.825     0.344     0.200
     0.827    -0.228     0.200
     0.827     0.363     0.200
     0.855    -0.501     0.200
     0.962     0.537     0.200
     0.996     0.321     0.200
     0.054    -0.350     0.200
     0.206     0.010     0.200
     0.271     0.393     0.200
     0.266    -0.003     0.200
     0.267     0.087     0.200
     0.282    -0.244     0.200
     0.322    -0.120     0.200
     0.364     0.223     0.200
     0.377     0.148     0.200
     0.541     0.285     0.200
     0.588     0.260     0.200
     0.620    -0.065     0.200
     0.631    -0.543     0.200
     0.693     0.012     0.200
     0.717     0.035     0.200
     0.779    -0.015     0.200
     0.835    -0.462     0.200
     0.839    -0.317     0.200
     0.973     0.949     0.200
     0.059    -0.045     0.200
     0.203     0.063     0.200
     0.266    -0.052     0.200
     0.279    -0.279     0.200
     0.272     0.138     0.200
     0.273     0.047     0.200
     0.327    -0.037     0.200
     0.369    -0.350     0.200
     0.369     0.281     0.200
     0.383     0.397     0.200
     0.507    -0.546     0.200
     0.547    -0.146     0.200
     0.592     0.300     0.200
     0.624     0.278     0.200
     0.624    -0.455     0.200
     0.625     0.518     0.200
     0.698    -0.008     0.200
     0.731    -1.081     0.200
     0.830    -0.121     0.200
     0.045    -0.085     0.200
     0.200     0.027     0.200
     0.259     0.103     0.200
     0.265     0.247     0.200
     0.270     0.221     0.200
     0.276     0.057     0.200
     0.326    -0.265     0.200
     0.355    -0.314     0.200
     0.372     0.377     0.200
     0.513    -0.136     0.200
     0.533     0.209     0.200
     0.578     0.035     0.200
     0.683     0.057     0.200
     0.874    -0.576     0.200
     0.974     0.075     0.200
     0.067     0.418     0.200
     0.133    -0.482     0.200
     0.191     0.266     0.200
     0.205    -0.219     0.200
     0.205     0.346     0.200
     0.317     0.030     0.200
     0.409     0.116     0.200
     0.423     0.020     0.200
     0.483     0.036     0.200
     0.498     0.158     0.200
     0.563     0.211     0.200
     0.586     0.528     0.200
     0.635     0.208     0.200
     0.060     0.122     0.200
     0.202    -0.012     0.200
     0.265     0.306     0.200
     0.278    -0.066     0.200
     0.273     0.113     0.200
     0.274    -0.086     0.200
     0.328     0.416     0.200
     0.369     0.339     0.200
     0.384     0.471     0.200
     0.592     0.175     0.200
     0.623     0.296     0.200
     0.772    -0.600     0.200
     0.828    -0.566     0.200
     0.051     0.069     0.200
     0.204    -0.021     0.200
     0.264     0.241     0.200
     0.271     0.357     0.200
     0.266     0.027     0.200
     0.280    -0.020     0.200
     0.323    -0.162     0.200
     0.361     0.199     0.200
     0.375     0.350     0.200
     0.513     0.061     0.200
     0.538    -0.093     0.200
     0.584    -0.188     0.200
     0.616    -0.197     0.200
     0.632     0.393     0.200
     0.717     0.362     0.200
     0.781     0.060     0.200
     0.785     0.121     0.200
     0.820     0.574     0.200
     0.834    -0.640     0.200
     0.841     0.272     0.200
     0.974     0.040     0.200
     0.039    -0.062     0.200
     0.187     0.235     0.200
     0.252     0.288     0.200
     0.263     0.021     0.200
     0.264     0.236     0.200
     0.268     0.002     0.200
     0.346     0.331     0.200
     0.372     0.371     0.200
     0.527     0.673     0.200
     0.565     0.235     0.200
     0.600    -0.520     0.200
     0.051    -0.265     0.200
     0.206    -0.060     0.200
     0.264     0.163     0.200
     0.273     0.347     0.200
     0.264     0.064     0.200
     0.282    -0.215     0.200
     0.321     0.036     0.200
     0.361     0.069     0.200
     0.374     0.327     0.200
     0.515    -0.014     0.200
     0.538    -0.263     0.200
     0.586    -0.239     0.200
     0.617     0.265     0.200
     0.633    -0.247     0.200
     0.633     0.116     0.200
     0.690     0.220     0.200
     0.719     0.111     0.200
     0.787    -0.218     0.200
     0.782     1.116     0.200
     0.836     0.450     0.200
     0.072     0.204     0.200
     0.103    -0.379     0.200
     0.182     0.411     0.200
     0.230     0.325     0.200
     0.245    -0.024     0.200
     0.338     0.148     0.200
     0.425    -0.059     0.200
     0.449     0.337     0.200
     0.523     0.246     0.200
     0.575     0.182     0.200
     0.607     0.562     0.200
     0.646     0.840     0.200
     0.983     0.134     0.200
     0.072    -0.003     0.200
     0.338    -0.223     0.200
     0.425    -0.375     0.200
     0.537    -0.112     0.200
     0.646     0.949     0.200
     0.043     0.162     0.200
     0.209     0.263     0.200
     0.255     0.223     0.200
     0.256     0.024     0.200
     0.280    -0.118     0.200
     0.286    -0.045     0.200
     0.316     0.256     0.200
     0.353     0.196     0.200
     0.365     0.454     0.200
     0.522    -0.383     0.200
     0.529    -0.378     0.200
     0.579     0.186     0.200
     0.609     0.118     0.200
     0.642    -0.306     0.200
     0.642    -0.118     0.200
     0.682     0.076     0.200
     0.696    -0.194     0.200
     0.729    -0.683     0.200
     0.726     0.192     0.200
     0.791    -0.622     0.200
     0.792     0.135     0.200
     0.819     0.601     0.200
     0.843     0.005     0.200
     0.851    -0.003     0.200
     0.880     0.498     0.200
     0.983     0.330     0.200
     0.045    -0.913     0.200
     0.198    -0.328     0.200
     0.259    -0.103     0.200
     0.269    -0.087     0.200
     0.265    -0.255     0.200
     0.275    -0.263     0.200
     0.327     0.323     0.200
     0.355     0.032     0.200
     0.373     0.176     0.200
     0.577     0.901     0.200
     0.633     0.018     0.200
     0.683     0.511     0.200
     0.784     0.064     0.200
     0.842     0.319     0.200
     0.198     0.202     0.200
     0.327    -0.157     0.200
     0.355    -0.079     0.200
     0.373    -0.154     0.200
     0.533     0.236     0.200
     0.577     0.501     0.200
     0.683     0.131     0.200
     0.055    -0.327     0.200
     0.218     0.179     0.200
     0.274     0.220     0.200
     0.278     0.229     0.200
     0.385     0.225     0.200
     0.466    -0.648     0.200
     0.466     0.102     0.200
     0.557    -0.007     0.200
     0.620     0.683     0.200
     0.654     0.451     0.200
     0.063    -0.043     0.200
     0.195    -0.106     0.200
     0.257     0.079     0.200
     0.271    -0.521     0.200
     0.276     0.175     0.200
     0.372     0.283     0.200
     0.390     0.142     0.200
     0.459    -0.732     0.200
     0.447    -0.312     0.200
     0.498    -0.408     0.200
     0.595    -0.065     0.200
     0.617     0.392     0.200
     0.618     0.203     0.200
     0.626     0.246     0.200
     0.767     0.174     0.200
     0.049     0.094     0.200
     0.199    -0.158     0.200
     0.268     0.116     0.200
     0.262     0.004     0.200
     0.275    -0.392     0.200
     0.359     0.193     0.200
     0.376     0.108     0.200
     0.451    -0.468     0.200
     0.473    -0.458     0.200
     0.608    -0.129     0.200
     0.614     0.153     0.200
     0.631    -0.061     0.200
     0.632    -0.003     0.200
     0.781    -0.047     0.200
     0.530    -1.702     0.200
     0.628    -0.179     0.200
     0.083     0.189     0.200
     0.180    -0.213     0.200
     0.231    -0.145     0.200
     0.257     0.107     0.200
     0.310     0.208     0.200
     0.292     0.269     0.200
     0.361    -0.053     0.200
     0.539    -1.160     0.200
     0.585    -0.303     0.200
     0.605    -0.259     0.200
     0.629     0.918     0.200
     0.750    -0.607     0.200
     0.895    -0.599     0.200
     0.900    -0.242     0.200
     0.901    -1.089     0.200
     0.838    -1.159     0.200
     0.089     0.306     0.200
     0.089     0.477     0.200
     0.161    -0.180     0.200
     0.236    -0.406     0.200
     0.256    -0.279     0.200
     0.295     0.154     0.200
     0.321    -0.714     0.200
     0.511    -0.241     0.200
     0.514    -0.663     0.200
     0.591     0.281     0.200
     0.665    -0.698     0.200
     0.785     0.275     0.200
     0.111    -0.081     0.200
     0.262    -0.156     0.200
     0.263     0.289     0.200
     0.284    -0.071     0.200
     0.304     0.059     0.200
     0.608    -0.127     0.200
     0.658    -0.000     0.200
     0.671    -0.077     0.200
     0.808    -0.317     0.200
     0.818    -0.248     0.200
     0.961     0.598     0.200
     0.023     0.222     0.200
     0.138     0.146     0.200
     0.191    -0.053     0.200
     0.231    -0.080     0.200
     0.308    -0.008     0.200
     0.318    -0.418     0.200
     0.484    -0.693     0.200
     0.489    -0.196     0.200
     0.585    -0.572     0.200
     0.727    -0.393     0.200
     0.732    -0.222     0.200
     0.748     0.019     0.200
     0.761     0.190     0.200
     0.795    -0.188     0.200
     0.211     0.204     0.200
     0.297     0.447     0.200
     0.410     0.000     0.200
     0.412     0.281     0.200
     0.447     0.333     0.200
     0.468     0.359     0.200
     0.486     0.292     0.200
     0.701     0.208     0.200
     0.749    -0.028     0.200
     0.737     0.526     0.200
     0.061     0.008     0.200
     0.206    -0.108     0.200
     0.273    -0.037     0.200
     0.282    -0.235     0.200
     0.371     0.213     0.200
     0.382     0.224     0.200
     0.466    -0.773     0.200
     0.452    -0.291     0.200
     0.597    -0.282     0.200
     0.604     0.326     0.200
     0.625    -0.257     0.200
     0.833    -0.164     0.200
     0.048    -0.195     0.200
     0.199    -0.061     0.200
     0.262     0.240     0.200
     0.269     0.193     0.200
     0.276    -0.174     0.200
     0.358    -0.120     0.200
     0.375     0.223     0.200
     0.440    -0.592     0.200
     0.452     0.046     0.200
     0.474    -0.813     0.200
     0.511    -0.215     0.200
     0.600     0.186     0.200
     0.609     0.366     0.200
     0.631     0.267     0.200
     0.633     0.054     0.200
     0.686    -0.224     0.200
     0.691     0.165     0.200
     0.202     0.526     0.200
     0.262     0.164     0.200
     0.278     0.188     0.200
     0.279     0.254     0.200
     0.330     0.240     0.200
     0.375     0.324     0.200
     0.389     0.631     0.200
     0.459    -0.731     0.200
     0.452     0.162     0.200
     0.617     0.067     0.200
     0.618     0.377     0.200
     0.631    -0.010     0.200
     0.703     0.080     0.200
     0.766     0.341     0.200
     0.780     0.548     0.200
     0.827     0.011     0.200
     0.828    -0.253     0.200
     0.546    -1.070     0.200
     0.199    -0.029     0.200
     0.262     0.493     0.200
     0.274     0.181     0.200
     0.275    -0.027     0.200
     0.370     0.077     0.200
     0.446     0.157     0.200
     0.451    -0.168     0.200
     0.621     0.282     0.200
     0.621     0.188     0.200
     0.698     0.392     0.200
     0.778    -0.219     0.200
     0.823     0.463     0.200
     0.213     0.251     0.200
     0.277    -0.131     0.200
     0.289     0.118     0.200
     0.375    -0.195     0.200
     0.383     0.253     0.200
     0.466    -0.121     0.200
     0.460    -0.233     0.200
     0.512    -0.211     0.200
     0.592    -0.044     0.200
     0.602     0.366     0.200
     0.622    -0.003     0.200
     0.625    -0.155     0.200
     0.705     0.696     0.200
     0.771    -0.193     0.200
     0.833     0.062     0.200
     0.836     0.916     0.200
     0.052     0.582     0.200
     0.128     0.810     0.200
     0.168     0.502     0.200
     0.202    -0.218     0.200
     0.302    -1.256     0.200
     0.326     0.159     0.200
     0.406    -0.206     0.200
     0.554    -0.655     0.200
     0.551    -0.119     0.200
     0.601    -0.209     0.200
     0.690    -1.052     0.200
     0.697    -0.403     0.200
     0.797    -0.883     0.200
     0.205    -0.205     0.200
     0.271     0.105     0.200
     0.266     0.086     0.200
     0.267     0.434     0.200
     0.281    -0.066     0.200
     0.323     0.103     0.200
     0.363     0.496     0.200
     0.376     0.300     0.200
     0.447    -0.044     0.200
     0.472    -0.601     0.200
     0.457    -0.428     0.200
     0.458    -0.225     0.200
     0.512    -0.025     0.200
     0.540    -0.094     0.200
     0.587     0.217     0.200
     0.603    -0.472     0.200
     0.604     0.329     0.200
     0.599     0.453     0.200
     0.619     0.472     0.200
     0.631    -0.087     0.200
     0.630     0.332     0.200
     0.692     0.643     0.200
     0.698     0.056     0.200
     0.730    -0.429     0.200
     0.779    -0.538     0.200
     0.785     0.896     0.200
     0.823     0.671     0.200
     0.834    -0.130     0.200
     0.533    -1.486     0.200
     0.631    -0.494     0.200
     0.623    -0.848     0.200
     0.036     0.258     0.200
     0.127    -0.122     0.200
     0.202    -0.068     0.200
     0.230    -0.134     0.200
     0.253    -0.179     0.200
     0.299     0.162     0.200
     0.304    -0.170     0.200
     0.375    -0.507     0.200
     0.447    -0.550     0.200
     0.496    -0.292     0.200
     0.497    -0.125     0.200
     0.502    -0.069     0.200
     0.516     0.061     0.200
     0.635    -0.335     0.200
     0.711     0.206     0.200
     0.720     0.236     0.200
     0.723    -0.578     0.200
     0.743    -0.197     0.200
     0.802     0.262     0.200
     0.988    -0.556     0.200
     0.061     0.071     0.200
     0.142    -0.314     0.200
     0.227     0.191     0.200
     0.369     0.389     0.200
     0.374     0.512     0.200
     0.390    -0.027     0.200
     0.395    -0.177     0.200
     0.420    -0.012     0.200
     0.525    -0.412     0.200
     0.533     0.605     0.200
     0.537     0.156     0.200
     0.562    -0.437     0.200
     0.572     0.226     0.200
     0.802     1.117     0.200
     0.921     0.528     0.200
     0.972     0.205     0.200
     0.063     0.057     0.200
     0.091    -0.135     0.200
     0.177     0.057     0.200
     0.186    -0.311     0.200
     0.252     0.271     0.200
     0.323    -0.381     0.200
     0.309     0.085     0.200
     0.393    -0.118     0.200
     0.448    -0.544     0.200
     0.488    -0.112     0.200
     0.506     0.157     0.200
     0.516     0.076     0.200
     0.527    -0.853     0.200
     0.587    -0.342     0.200
     0.613    -0.309     0.200
     0.620    -0.003     0.200
     0.669     0.024     0.200
     0.675     0.390     0.200
     0.682    -0.363     0.200
     0.690    -0.102     0.200
     0.692    -0.237     0.200
     0.713     0.308     0.200
     0.736     0.430     0.200
     0.764     0.257     0.200
     0.975    -0.195     0.200
     0.055     0.424     0.200
     0.099    -0.157     0.200
     0.180     0.061     0.200
     0.180     0.031     0.200
     0.260     0.108     0.200
     0.316    -0.377     0.200
     0.330    -0.574     0.200
     0.449     0.164     0.200
     0.484     0.187     0.200
     0.498     0.057     0.200
     0.535     0.062     0.200
     0.587     0.463     0.200
     0.608    -0.043     0.200
     0.623    -0.347     0.200
     0.676     0.252     0.200
     0.680     0.166     0.200
     0.683     0.486     0.200
     0.684    -0.128     0.200
     0.695    -0.590     0.200
     0.715     0.077     0.200
     0.727    -0.041     0.200
     0.762     0.251     0.200
     0.775     0.961     0.200
     0.852     0.805     0.200
     0.865     0.934     0.200
     0.944     0.557     0.200
     0.961     0.532     0.200
     0.982     0.573     0.200
     0.983     0.613     0.200
     0.986     0.648     0.200
     0.315    -0.579     0.200
     0.060     0.160     0.200
     0.092     0.074     0.200
     0.180    -0.163     0.200
     0.187    -0.218     0.200
     0.255     0.452     0.200
     0.308     0.369     0.200
     0.397    -0.541     0.200
     0.451     0.198     0.200
     0.490     0.621     0.200
     0.506    -0.232     0.200
     0.590     0.012     0.200
     0.615     0.090     0.200
     0.623     0.183     0.200
     0.672    -0.223     0.200
     0.678     0.299     0.200
     0.685    -0.197     0.200
     0.692     0.040     0.200
     0.717     0.134     0.200
     0.735     0.139     0.200
     0.767     0.305     0.200
     0.860     0.625     0.200
     0.978    -0.273     0.200
     0.976     0.170     0.200
     0.994     0.234     0.200
     0.105    -0.106     0.200
     0.090     0.288     0.200
     0.216     0.317     0.200
     0.260     0.298     0.200
     0.293    -0.014     0.200
     0.348     0.281     0.200
     0.335     0.770     0.200
     0.369     0.138     0.200
     0.362     0.700     0.200
     0.375    -0.205     0.200
     0.383    -0.513     0.200
     0.498     0.460     0.200
     0.516     0.269     0.200
     0.554    -0.027     0.200
     0.561    -0.016     0.200
     0.596    -0.002     0.200
     0.613     0.192     0.200
     0.648     0.822     0.200
     0.834     0.503     0.200
     0.882     0.269     0.200
     0.931     0.334     0.200
     0.090     0.307     0.200
     0.170    -0.433     0.200
     0.188    -0.067     0.200
     0.262     0.103     0.200
     0.310    -0.528     0.200
     0.323    -0.378     0.200
     0.330     0.030     0.200
     0.323    -0.186     0.200
     0.385     1.048     0.200
     0.442    -0.845     0.200
     0.434    -0.192     0.200
     0.534    -0.180     0.200
     0.610    -0.625     0.200
     0.582     0.812     0.200
     0.639    -0.634     0.200
     0.674    -0.232     0.200
     0.734    -0.498     0.200
     0.767    -0.265     0.200
     0.792    -0.944     0.200
     0.810    -0.678     0.200
     0.834    -0.621     0.200
     0.897     0.211     0.200
     0.970    -0.373     0.200
     0.972     0.078     0.200
     0.119     0.228     0.200
     0.228     0.056     0.200
     0.210     1.027     0.200
     0.247     0.071     0.200
     0.272     0.263     0.200
     0.389     0.539     0.200
     0.384     0.402     0.200
     0.476    -0.079     0.200
     0.527     0.407     0.200
     0.545     0.553     0.200
     0.529     1.019     0.200
     0.551     0.018     0.200
     0.661     0.147     0.200
     0.657     0.453     0.200
     0.703     0.582     0.200
     0.719     0.369     0.200
     0.846    -0.245     0.200
     0.828     1.405     0.200
     0.971    -0.477     0.200
     0.207    -0.257     0.200
     0.268    -0.161     0.200
     0.283    -0.252     0.200
     0.272     0.146     0.200
     0.274     0.283     0.200
     0.324     0.116     0.200
     0.371     0.312     0.200
     0.383     0.414     0.200
     0.466    -0.646     0.200
     0.452    -0.304     0.200
     0.453     0.089     0.200
     0.459     0.507     0.200
     0.509    -0.025     0.200
     0.548     0.411     0.200
     0.596     0.424     0.200
     0.602     0.025     0.200
     0.595     0.398     0.200
     0.604     0.096     0.200
     0.623    -0.284     0.200
     0.625     0.001     0.200
     0.627     0.246     0.200
     0.704     0.020     0.200
     0.700     0.468     0.200
     0.714    -0.064     0.200
     0.735    -0.649     0.200
     0.772     0.371     0.200
     0.785     0.494     0.200
     0.832     0.012     0.200
     0.833     0.051     0.200
     0.829     0.298     0.200
     0.969     0.413     0.200
     0.541    -0.937     0.200
     0.639    -0.454     0.200
     0.615    -0.569     0.200
     0.061    -0.112     0.200
     0.174     0.591     0.200
     0.196    -0.313     0.200
     0.241     0.459     0.200
     0.320    -0.592     0.200
     0.353     0.298     0.200
     0.389     0.501     0.200
     0.429    -0.630     0.200
     0.428     0.218     0.200
     0.480    -0.616     0.200
     0.490    -0.477     0.200
     0.487     0.547     0.200
     0.512    -0.209     0.200
     0.633     0.568     0.200
     0.705    -0.019     0.200
     0.716     0.445     0.200
     0.721     0.535     0.200
     0.786     0.499     0.200
     0.959    -0.045     0.200
     0.050    -0.012     0.200
     0.239     0.145     0.200
     0.247     0.826     0.200
     0.294     0.744     0.200
     0.354     0.124     0.200
     0.394     0.455     0.200
     0.386     0.485     0.200
     0.458     0.928     0.200
     0.539     0.301     0.200
     0.592     0.207     0.200
     0.805     0.534     0.200
     0.835     0.282     0.200
     0.908     0.433     0.200
     0.959     0.652     0.200
     0.099     0.824     0.200
     0.236    -0.163     0.200
     0.241    -0.007     0.200
     0.236     0.408     0.200
     0.334    -0.029     0.200
     0.389    -0.905     0.200
     0.376    -0.101     0.200
     0.370    -0.129     0.200
     0.445    -0.493     0.200
     0.451    -0.052     0.200
     0.513     0.492     0.200
     0.528    -0.055     0.200
     0.598    -0.640     0.200
     0.582     0.835     0.200
     0.740    -0.719     0.200
     0.715     0.716     0.200
     0.755    -0.729     0.200
     0.743     0.056     0.200
     0.771    -0.180     0.200
     0.780    -0.548     0.200
     0.756     0.315     0.200
     0.795    -0.709     0.200
     0.784     0.517     0.200
     0.825    -0.276     0.200
     0.953    -0.169     0.200
     0.951     0.027     0.200
     0.135     0.026     0.200
     0.212    -0.223     0.200
     0.295     0.295     0.200
     0.296     0.219     0.200
     0.320     0.807     0.200
     0.354    -0.406     0.200
     0.372    -0.702     0.200
     0.427     0.419     0.200
     0.547    -0.597     0.200
     0.594    -0.128     0.200
     0.636    -0.512     0.200
     0.612     0.855     0.200
     0.863     0.221     0.200
     0.912    -0.156     0.200
     0.943     0.072     0.200
     0.953    -0.009     0.200
     0.081     0.852     0.200
     0.184     0.011     0.200
     0.231     0.150     0.200
     0.251     0.119     0.200
     0.262     0.861     0.200
     0.361    -0.308     0.200
     0.425    -1.114     0.200
     0.406     0.188     0.200
     0.491    -0.117     0.200
     0.552     0.426     0.200
     0.591     1.156     0.200
     0.644    -0.732     0.200
     0.634    -0.590     0.200
     0.641     0.271     0.200
     0.657    -0.536     0.200
     0.796    -0.718     0.200
     0.926    -0.404     0.200
     0.943     0.372     0.200
     0.987    -0.345     0.200
     0.099     0.101     0.200
     0.175     0.187     0.200
     0.246    -0.218     0.200
     0.241     0.078     0.200
     0.309     0.126     0.200
     0.307    -0.048     0.200
     0.349    -0.327     0.200
     0.378    -0.743     0.200
     0.373     0.422     0.200
     0.494     0.309     0.200
     0.592    -0.922     0.200
     0.587     0.019     0.200
     0.604    -0.267     0.200
     0.584     0.431     0.200
     0.639     1.082     0.200
     0.646     0.792     0.200
     0.740    -0.890     0.200
     0.873    -0.511     0.200
     0.897    -0.561     0.200
     0.896    -0.665     0.200
     0.922    -0.159     0.200
     0.931    -0.182     0.200
     0.040    -0.456     0.200
     0.223    -0.093     0.200
     0.297    -0.555     0.200
     0.306     0.769     0.200
     0.397     0.037     0.200
     0.435    -0.046     0.200
     0.502    -0.423     0.200
     0.486     1.757     0.200
     0.542     0.917     0.200
     0.630    -0.641     0.200
     0.611     0.536     0.200
     0.753    -0.386     0.200
     0.787    -0.692     0.200
     0.824    -0.870     0.200
     0.837     0.330     0.200
     0.896    -0.739     0.200
     0.900    -0.449     0.200
     0.961    -0.503     0.200
     0.112     0.348     0.200
     0.144    -0.036     0.200
     0.177    -0.074     0.200
     0.238    -0.314     0.200
     0.254    -0.316     0.200
     0.255    -0.160     0.200
     0.367    -0.093     0.200
     0.401     0.772     0.200
     0.478    -0.390     0.200
     0.539     0.172     0.200
     0.552    -0.093     0.200
     0.606     0.745     0.200
     0.621    -0.322     0.200
     0.636    -0.534     0.200
     0.661    -0.827     0.200
     0.701     0.343     0.200
     0.716     0.935     0.200
     0.743     0.222     0.200
     0.755     0.523     0.200
     0.772     0.289     0.200
     0.792     0.077     0.200
     0.787     0.053     0.200
     0.805     0.413     0.200
     0.865     0.215     0.200
     0.891     0.186     0.200
     0.907     0.580     0.200
     0.935    -0.037     0.200
     0.983     0.194     0.200
     0.196    -0.233     0.200
     0.261    -0.052     0.200
     0.272    -0.068     0.200
     0.271     0.116     0.200
     0.276     0.401     0.200
     0.332     0.175     0.200
     0.366     0.484     0.200
     0.384     0.410     0.200
     0.442    -0.079     0.200
     0.448     0.070     0.200
     0.465    -0.555     0.200
     0.449     0.118     0.200
     0.503    -0.070     0.200
     0.545     0.207     0.200
     0.587     0.217     0.200
     0.601     0.259     0.200
     0.622     0.074     0.200
     0.624     0.406     0.200
     0.621     0.285     0.200
     0.693     0.228     0.200
     0.724    -0.872     0.200
     0.694     0.388     0.200
     0.707     0.062     0.200
     0.773    -0.016     0.200
     0.818     0.385     0.200
     0.824     0.337     0.200
     0.964     0.163     0.200
     0.142     0.109     0.200
     0.127     0.390     0.200
     0.281    -0.496     0.200
     0.255     0.265     0.200
     0.346    -0.891     0.200
     0.360    -0.019     0.200
     0.339     0.443     0.200
     0.506     0.353     0.200
     0.557    -0.635     0.200
     0.563    -0.461     0.200
     0.574    -0.462     0.200
     0.602     0.134     0.200
     0.611     0.894     0.200
     0.665     0.841     0.200
     0.704    -0.371     0.200
     0.706    -0.522     0.200
     0.672     1.130     0.200
     0.790    -0.627     0.200
     0.797    -0.480     0.200
     0.841    -0.141     0.200
     0.865    -0.343     0.200
     0.853     0.231     0.200
     0.870    -0.161     0.200
     0.886    -0.635     0.200
     0.895    -0.287     0.200
     0.870    -1.226     0.200
     0.118    -0.152     0.200
     0.217     0.080     0.200
     0.327    -0.056     0.200
     0.347    -0.273     0.200
     0.346     0.205     0.200
     0.364     0.254     0.200
     0.595    -0.033     0.200
     0.698    -0.040     0.200
     0.783    -0.244     0.200
     0.170    -0.085     0.200
     0.199    -0.246     0.200
     0.223     0.181     0.200
     0.299    -0.121     0.200
     0.351    -0.249     0.200
     0.364    -0.007     0.200
     0.461    -0.131     0.200
     0.553    -0.370     0.200
     0.579     0.123     0.200
     0.612     0.259     0.200
     0.630    -0.043     0.200
     0.638    -0.216     0.200
     0.655     0.291     0.200
     0.770     0.082     0.200
     0.770    -0.085     0.200
     0.779    -0.007     0.200
     0.770     0.326     0.200
     0.788    -0.128     0.200
     0.788     0.244     0.200
     0.803     0.323     0.200
     0.837    -0.199     0.200
     0.860     0.188     0.200
     0.853     0.015     0.200
     0.870     0.347     0.200
     0.943     0.009     0.200
     0.959     0.516     0.200
     0.981     0.275     0.200
     0.996     0.345     0.200
     0.170    -0.203     0.200
     0.199    -0.386     0.200
     0.364     0.111     0.200
     0.612     0.431     0.200
     0.630    -0.316     0.200
     0.638    -0.052     0.200
     0.655     0.150     0.200
     0.770    -0.254     0.200
     0.770    -0.296     0.200
     0.779     0.227     0.200
     0.788    -0.253     0.200
     0.770     0.615     0.200
     0.788     0.033     0.200
     0.837    -0.316     0.200
     0.860    -0.093     0.200
     0.853     0.429     0.200
     0.870     0.941     0.200
     0.943    -0.366     0.200
     0.959     0.259     0.200
     0.212     0.438     0.200
     0.763    -0.394     0.200
     0.135     0.092     0.200
     0.134     0.610     0.200
     0.213     0.478     0.200
     0.289     0.036     0.200
     0.302     0.022     0.200
     0.312     0.303     0.200
     0.398    -0.075     0.200
     0.489    -0.002     0.200
     0.570    -0.135     0.200
     0.578    -0.008     0.200
     0.579     0.345     0.200
     0.596    -0.078     0.200
     0.613     0.042     0.200
     0.713    -0.008     0.200
     0.720    -0.069     0.200
     0.725    -0.198     0.200
     0.727    -0.142     0.200
     0.733     0.060     0.200
     0.773     0.155     0.200
     0.787     0.341     0.200
     0.782     0.284     0.200
     0.810     0.014     0.200
     0.853     0.616     0.200
     0.892     0.216     0.200
     0.925     0.248     0.200
     0.969     0.119     0.200
     0.968     0.341     0.200
     0.988    -0.004     0.200
     0.991     0.183     0.200
     0.996     0.509     0.200
     0.331     0.011     0.200
     0.320     0.096     0.200
     0.341     0.097     0.200
     0.358     0.132     0.200
     0.417    -0.845     0.200
     0.409     0.005     0.200
     0.419     0.289     0.200
     0.459     0.335     0.200
     0.482     0.275     0.200
     0.527     0.282     0.200
     0.535    -0.125     0.200
     0.616     0.184     0.200
     0.686     0.074     0.200
     0.687     0.447     0.200
     0.692     0.202     0.200
     0.744    -0.105     0.200
     0.763     0.110     0.200
     0.787     0.588     0.200
     0.860     0.492     0.200
     0.868     0.175     0.200
     0.894    -0.372     0.200
     0.868     0.123     0.200
     0.880     0.062     0.200
     0.917     0.323     0.200
     0.972     0.354     0.200
     0.994     0.350     0.200
     0.162    -0.227     0.200
     0.230     0.296     0.200
     0.293    -0.230     0.200
     0.306     0.710     0.200
     0.353    -0.041     0.200
     0.379    -0.274     0.200
     0.479     0.224     0.200
     0.588    -0.068     0.200
     0.590    -0.105     0.200
     0.578     0.472     0.200
     0.818     0.076     0.200
     0.857     0.005     0.200
     0.921    -0.233     0.200
     0.108     0.260     0.200
     0.133     0.112     0.200
     0.229     0.130     0.200
     0.232     0.437     0.200
     0.343     0.235     0.200
     0.391     0.152     0.200
     0.466    -0.334     0.200
     0.470    -0.001     0.200
     0.460     0.167     0.200
     0.568     0.134     0.200
     0.594     0.478     0.200
     0.610     0.430     0.200
     0.641    -0.094     0.200
     0.667     0.287     0.200
     0.711    -0.188     0.200
     0.789     0.514     0.200
     0.797     0.138     0.200
     0.806     0.396     0.200
     0.813     0.171     0.200
     0.852    -0.478     0.200
     0.920     0.196     0.200
     0.939     0.329     0.200
     0.979     0.340     0.200
     0.111     0.134     0.200
     0.135     0.878     0.200
     0.279     0.455     0.200
     0.317    -0.290     0.200
     0.398    -0.128     0.200
     0.480    -0.217     0.200
     0.481    -0.125     0.200
     0.521    -0.113     0.200
     0.664    -0.053     0.200
     0.733    -0.308     0.200
     0.745     0.087     0.200
     0.783    -0.098     0.200
     0.993    -0.260     0.200
     0.021     0.099     0.200
     0.173     0.191     0.200
     0.172    -0.161     0.200
     0.271     0.129     0.200
     0.349     0.039     0.200
     0.447     0.286     0.200
     0.501     0.166     0.200
     0.517     0.073     0.200
     0.539    -0.144     0.200
     0.552    -0.137     0.200
     0.572     0.111     0.200
     0.219     0.314     0.200
     0.228     0.064     0.200
     0.281     0.193     0.200
     0.309     0.145     0.200
     0.342     0.452     0.200
     0.361     0.257     0.200
     0.385     0.075     0.200
     0.393     0.066     0.200
     0.524    -0.565     0.200
     0.528    -0.292     0.200
     0.561    -0.267     0.200
     0.642     0.187     0.200
     0.653     0.286     0.200
     0.691    -0.051     0.200
     0.703    -0.015     0.200
     0.726     0.330     0.200
     0.886     0.695     0.200
     0.927     0.301     0.200
     0.153    -0.345     0.200
     0.156     0.406     0.200
     0.177    -0.131     0.200
     0.204    -0.358     0.200
     0.327    -0.223     0.200
     0.422    -0.421     0.200
     0.452    -0.179     0.200
     0.449     0.104     0.200
     0.469    -0.545     0.200
     0.475    -0.301     0.200
     0.546    -0.276     0.200
     0.601    -0.099     0.200
     0.606    -0.567     0.200
     0.613     0.643     0.200
     0.662     0.237     0.200
     0.688    -0.322     0.200
     0.688     0.222     0.200
     0.731    -0.186     0.200
     0.792     0.145     0.200
     0.874    -1.611     0.200
     0.864    -0.740     0.200
     0.874    -0.370     0.200
     0.943    -0.203     0.200
     0.071     0.088     0.200
     0.144    -0.596     0.200
     0.141     0.683     0.200
     0.449     1.183     0.200
     0.481    -0.070     0.200
     0.466     0.655     0.200
     0.451     0.653     0.200
     0.691     0.400     0.200
     0.735    -0.422     0.200
     0.017     0.344     0.200
     0.161    -0.525     0.200
     0.223    -0.128     0.200
     0.221    -0.078     0.200
     0.322     0.283     0.200
     0.386    -0.555     0.200
     0.445    -0.579     0.200
     0.450     0.116     0.200
     0.449    -0.038     0.200
     0.469    -0.206     0.200
     0.585     0.109     0.200
     0.601    -0.478     0.200
     0.639    -0.064     0.200
     0.662    -0.788     0.200
     0.678    -0.591     0.200
     0.666     0.288     0.200
     0.719     0.272     0.200
     0.741    -0.004     0.200
     0.734     0.101     0.200
     0.745     0.411     0.200
     0.743    -0.250     0.200
     0.763     0.520     0.200
     0.818    -0.223     0.200
     0.936     0.470     0.200
     0.116    -0.163     0.200
     0.172     0.834     0.200
     0.256    -0.020     0.200
     0.275    -0.455     0.200
     0.316    -0.663     0.200
     0.365    -0.059     0.200
     0.433     0.214     0.200
     0.467     0.135     0.200
     0.443     0.115     0.200
     0.479    -1.049     0.200
     0.516    -0.270     0.200
     0.624    -0.335     0.200
     0.630    -0.133     0.200
     0.660    -1.012     0.200
     0.662     0.426     0.200
     0.685    -0.250     0.200
     0.703    -0.098     0.200
     0.702    -0.343     0.200
     0.682     0.840     0.200
     0.790     0.191     0.200
     0.858    -0.157     0.200
     0.879    -0.109     0.200
     0.867     0.876     0.200
     0.913     0.924     0.200
     0.981    -0.624     0.200
     0.621    -0.498     0.200
     0.169     0.122     0.200
     0.223    -0.241     0.200
     0.308    -0.568     0.200
     0.469    -0.016     0.200
     0.463    -0.045     0.200
     0.589    -0.438     0.200
     0.607    -0.127     0.200
     0.609     0.258     0.200
     0.643     0.643     0.200
     0.676     0.061     0.200
     0.717    -0.665     0.200
     0.778     0.209     0.200
     0.160    -0.530     0.200
     0.209    -0.753     0.200
     0.228     0.201     0.200
     0.322    -0.453     0.200
     0.311     1.067     0.200
     0.345     0.200     0.200
     0.333     0.631     0.200
     0.374    -0.087     0.200
     0.448     0.507     0.200
     0.483    -0.875     0.200
     0.576    -0.014     0.200
     0.586     0.815     0.200
     0.635    -0.278     0.200
     0.695     0.319     0.200
     0.704     0.360     0.200
     0.874    -0.441     0.200
     0.886     1.235     0.200
     0.927    -0.083     0.200
     0.174    -0.405     0.200
     0.190     0.257     0.200
     0.264    -0.390     0.200
     0.357    -0.179     0.200
     0.362    -0.299     0.200
     0.425    -0.745     0.200
     0.447     0.208     0.200
     0.485     0.564     0.200
     0.602    -0.120     0.200
     0.645     0.663     0.200
     0.773    -0.155     0.200
     0.779    -0.180     0.200
     0.780     0.283     0.200
     0.786     0.219     0.200
     0.792    -0.295     0.200
     0.786     0.388     0.200
     0.827     0.149     0.200
     0.929     0.474     0.200
     0.226    -0.197     0.200
     0.278    -0.717     0.200
     0.387    -0.417     0.200
     0.392     0.717     0.200
     0.407     0.283     0.200
     0.499    -0.742     0.200
     0.571     0.005     0.200
     0.604    -0.080     0.200
     0.658    -0.173     0.200
     0.665     0.334     0.200
     0.745     0.612     0.200
     0.773     0.026     0.200
     0.775    -0.901     0.200
     0.790     0.525     0.200
     0.796    -0.069     0.200
     0.801     0.428     0.200
     0.807     0.217     0.200
     0.820     0.060     0.200
     0.054    -0.111     0.200
     0.123    -0.073     0.200
     0.217     0.374     0.200
     0.226    -0.654     0.200
     0.244     0.158     0.200
     0.244     0.393     0.200
     0.313     0.473     0.200
     0.362     0.109     0.200
     0.386     0.912     0.200
     0.395     0.194     0.200
     0.466    -0.858     0.200
     0.626     0.313     0.200
     0.657    -0.092     0.200
     0.676     0.034     0.200
     0.681     0.331     0.200
     0.749     0.415     0.200
     0.794     0.498     0.200
     0.796     0.201     0.200
     0.117     0.162     0.200
     0.144    -0.033     0.200
     0.156     0.081     0.200
     0.164    -0.174     0.200
     0.268     0.601     0.200
     0.342     0.209     0.200
     0.385    -0.050     0.200
     0.450    -0.313     0.200
     0.500    -0.365     0.200
     0.550    -0.334     0.200
     0.565    -0.093     0.200
     0.591     0.287     0.200
     0.635     0.061     0.200
     0.650    -0.274     0.200
     0.654    -0.288     0.200
     0.659    -0.306     0.200
     0.656     0.608     0.200
     0.704    -0.358     0.200
     0.717     0.348     0.200
     0.727    -0.319     0.200
     0.724     0.216     0.200
     0.735     0.042     0.200
     0.776     0.738     0.200
     0.798    -0.151     0.200
     0.825    -0.390     0.200
     0.875     0.004     0.200
     0.960     0.142     0.200
     0.252     0.714     0.200
     0.348    -0.062     0.200
     0.449    -0.288     0.200
     0.424     0.988     0.200
     0.468    -0.418     0.200
     0.480    -0.315     0.200
     0.679    -0.116     0.200
     0.679    -0.149     0.200
     0.759     0.009     0.200
     0.812    -0.263     0.200
     0.910    -0.103     0.200
     0.953    -0.690     0.200
     0.233    -0.137     0.200
     0.252     0.862     0.200
     0.348    -0.406     0.200
     0.468    -0.258     0.200
     0.480    -0.213     0.200
     0.679     0.006     0.200
     0.679     0.023     0.200
     0.678    -0.825     0.200
     0.453    -1.345     0.200
     0.148     0.282     0.200
     0.249    -0.037     0.200
     0.234     0.244     0.200
     0.313    -0.511     0.200
     0.320    -0.040     0.200
     0.396    -0.628     0.200
     0.467    -0.307     0.200
     0.484    -0.263     0.200
     0.494    -0.175     0.200
     0.511    -0.592     0.200
     0.520     0.173     0.200
     0.598    -0.526     0.200
     0.636     0.186     0.200
     0.645    -0.595     0.200
     0.649    -0.420     0.200
     0.684     1.126     0.200
     0.694     0.376     0.200
     0.741    -0.437     0.200
     0.745    -0.205     0.200
     0.764     0.013     0.200
     0.756     0.253     0.200
     0.779    -0.413     0.200
     0.811    -0.129     0.200
     0.868     0.223     0.200
     0.910    -0.177     0.200
     0.977     0.286     0.200
     0.996     0.877     0.200
     0.248     0.438     0.200
     0.252     0.167     0.200
     0.297     0.094     0.200
     0.339     0.079     0.200
     0.373     0.190     0.200
     0.370     0.155     0.200
     0.495    -0.552     0.200
     0.501    -0.100     0.200
     0.540    -0.279     0.200
     0.548    -0.102     0.200
     0.572    -0.231     0.200
     0.574    -0.140     0.200
     0.570     0.269     0.200
     0.663     0.145     0.200
     0.657     0.125     0.200
     0.673     0.088     0.200
     0.746     0.528     0.200
     0.780    -0.061     0.200
     0.823    -0.621     0.200
     0.868     0.509     0.200
     0.870     0.439     0.200
     0.905    -0.067     0.200
     0.565    -1.407     0.200
     0.667     0.238     0.200
     0.055     0.187     0.200
     0.217     0.589     0.200
     0.256    -0.369     0.200
     0.220     0.614     0.200
     0.297    -0.305     0.200
     0.404     0.118     0.200
     0.440    -0.095     0.200
     0.436    -0.136     0.200
     0.558    -0.206     0.200
     0.641     0.085     0.200
     0.683    -0.285     0.200
     0.909    -0.118     0.200
     0.287     0.589     0.200
     0.300    -0.286     0.200
     0.306    -0.075     0.200
     0.359    -0.137     0.200
     0.359    -0.131     0.200
     0.435     0.473     0.200
     0.464    -0.137     0.200
     0.512    -0.468     0.200
     0.523     0.020     0.200
     0.529     0.104     0.200
     0.723     0.425     0.200
     0.797     0.444     0.200
     0.836     0.081     0.200
     0.148    -0.370     0.200
     0.239     0.239     0.200
     0.394     0.129     0.200
     0.422    -0.262     0.200
     0.504    -0.278     0.200
     0.544     0.269     0.200
     0.562     0.103     0.200
     0.605    -0.184     0.200
     0.629    -0.180     0.200
     0.737    -0.370     0.200
     0.793     0.002     0.200
     0.975     0.008     0.200
     0.113     0.581     0.200
     0.137     0.364     0.200
     0.177     0.216     0.200
     0.242     0.131     0.200
     0.328    -0.162     0.200
     0.374    -0.484     0.200
     0.480    -0.564     0.200
     0.479     0.085     0.200
     0.492     0.148     0.200
     0.579     0.097     0.200
     0.614     0.063     0.200
     0.610     0.138     0.200
     0.662     0.676     0.200
     0.668     0.411     0.200
     0.693     0.500     0.200
     0.703     0.661     0.200
     0.721     0.330     0.200
     0.727    -0.421     0.200
     0.738     0.095     0.200
     0.748     0.170     0.200
     0.749     0.143     0.200
     0.781     0.158     0.200
     0.821     0.087     0.200
     0.846     0.128     0.200
     0.965    -0.172     0.200
     0.688     0.589     0.200
     0.608    -0.418     0.200
     0.163     0.179     0.200
     0.206     0.581     0.200
     0.236    -0.038     0.200
     0.316     0.218     0.200
     0.332     0.290     0.200
     0.384     0.056     0.200
     0.393    -0.603     0.200
     0.404     0.157     0.200
     0.435    -0.656     0.200
     0.439     0.646     0.200
     0.447    -0.159     0.200
     0.567     0.573     0.200
     0.574     0.172     0.200
     0.590     0.220     0.200
     0.652    -0.352     0.200
     0.653    -0.076     0.200
     0.665     0.074     0.200
     0.725     0.426     0.200
     0.722     0.019     0.200
     0.729     0.647     0.200
     0.771     0.146     0.200
     0.813     1.111     0.200
     0.813    -0.190     0.200
     0.908     0.578     0.200
     0.950    -0.097     0.200
     0.952     0.913     0.200
     0.987     0.596     0.200
     0.582    -0.929     0.200
     0.677    -0.757     0.200
     0.211    -0.248     0.200
     0.244    -0.178     0.200
     0.293     0.676     0.200
     0.326    -0.109     0.200
     0.363     0.655     0.200
     0.391    -0.211     0.200
     0.433     0.467     0.200
     0.588    -0.215     0.200
     0.602    -0.208     0.200
     0.661    -0.120     0.200
     0.702     0.475     0.200
     0.718     0.023     0.200
     0.887     0.174     0.200
     0.879     1.204     0.200
     0.888     0.354     0.200
     0.946     0.573     0.200
     0.341    -0.111     0.200
     0.371     0.020     0.200
     0.361     0.289     0.200
     0.415    -0.040     0.200
     0.407     0.268     0.200
     0.463    -0.187     0.200
     0.484     0.232     0.200
     0.501    -0.380     0.200
     0.512     0.041     0.200
     0.529     0.423     0.200
     0.582    -0.119     0.200
     0.648    -0.228     0.200
     0.679     0.750     0.200
     0.667     0.255     0.200
     0.678     0.164     0.200
     0.711    -0.326     0.200
     0.758     0.064     0.200
     0.763    -0.432     0.200
     0.830     0.224     0.200
     0.845    -0.426     0.200
     0.843     0.113     0.200
     0.905     0.475     0.200
     0.942     0.317     0.200
     0.961     0.864     0.200
     0.146    -0.053     0.200
     0.159    -0.297     0.200
     0.180    -0.631     0.200
     0.192    -0.156     0.200
     0.325    -0.403     0.200
     0.330    -0.705     0.200
     0.406    -0.460     0.200
     0.501    -0.572     0.200
     0.580    -0.291     0.200
     0.589    -0.534     0.200
     0.601    -0.074     0.200
     0.620     0.713     0.200
     0.636    -0.642     0.200
     0.721    -0.237     0.200
     0.730    -0.413     0.200
     0.733    -0.509     0.200
     0.702     0.534     0.200
     0.738     0.471     0.200
     0.758     0.054     0.200
     0.772     0.131     0.200
     0.782     0.131     0.200
     0.875     0.640     0.200
     0.914     0.325     0.200
     0.959     0.393     0.200
     0.992     0.058     0.200
     0.986     0.154     0.200
     0.184     0.756     0.200
     0.244     0.273     0.200
     0.256     0.930     0.200
     0.302     0.072     0.200
     0.291     1.058     0.200
     0.372     0.106     0.200
     0.394     0.447     0.200
     0.406     0.280     0.200
     0.424     0.045     0.200
     0.485    -0.650     0.200
     0.493    -0.876     0.200
     0.519    -0.553     0.200
     0.642    -0.081     0.200
     0.635    -0.383     0.200
     0.687    -0.195     0.200
     0.721     0.458     0.200
     0.829    -0.033     0.200
     0.860     0.249     0.200
     0.850     0.739     0.200
     0.962    -0.007     0.200
     0.099     0.320     0.200
     0.156     0.034     0.200
     0.185    -0.227     0.200
     0.206    -0.026     0.200
     0.312    -0.445     0.200
     0.355     0.231     0.200
     0.357    -0.442     0.200
     0.529     0.038     0.200
     0.549    -0.569     0.200
     0.615    -0.220     0.200
     0.622     0.157     0.200
     0.670    -0.225     0.200
     0.679     0.529     0.200
     0.690    -0.094     0.200
     0.741    -0.336     0.200
     0.805     0.123     0.200
     0.811     0.458     0.200
     0.824    -0.156     0.200
     0.845     0.505     0.200
     0.882    -0.231     0.200
     0.888     0.414     0.200
     0.940    -0.045     0.200
     0.176    -0.152     0.200
     0.242    -0.042     0.200
     0.251     0.566     0.200
     0.296     0.203     0.200
     0.286     0.457     0.200
     0.382     0.028     0.200
     0.391     0.292     0.200
     0.402     0.090     0.200
     0.438    -0.389     0.200
     0.484     0.332     0.200
     0.480     0.258     0.200
     0.633     0.205     0.200
     0.633     0.170     0.200
     0.644     0.641     0.200
     0.650     0.154     0.200
     0.676    -0.139     0.200
     0.674    -0.248     0.200
     0.734     0.110     0.200
     0.789    -0.495     0.200
     0.797     0.481     0.200
     0.816     0.237     0.200
     0.834     0.261     0.200
     0.851     0.206     0.200
     0.923     0.232     0.200
     0.967     0.463     0.200
     0.974     0.207     0.200
     0.079     0.688     0.200
     0.182     1.100     0.200
     0.265     0.172     0.200
     0.304     0.132     0.200
     0.337     0.495     0.200
     0.399     0.592     0.200
     0.497     0.221     0.200
     0.528     0.096     0.200
     0.582     0.721     0.200
     0.683     0.395     0.200
     0.742     0.142     0.200
     0.749     0.635     0.200
     0.795     0.259     0.200
     0.081     0.812     0.200
     0.140    -0.137     0.200
     0.212    -0.041     0.200
     0.290    -0.040     0.200
     0.334    -0.386     0.200
     0.344    -0.464     0.200
     0.310    -0.344     0.200
     0.311     0.190     0.200
     0.399    -0.588     0.200
     0.438    -0.416     0.200
     0.476    -0.360     0.200
     0.558    -0.071     0.200
     0.616     0.118     0.200
     0.639    -0.551     0.200
     0.754    -0.141     0.200
     0.860    -0.147     0.200
     0.894    -0.351     0.200
     0.964    -0.369     0.200
     0.972    -0.232     0.200
     0.062    -0.177     0.200
     0.116    -0.172     0.200
     0.178    -0.592     0.200
     0.197    -0.310     0.200
     0.185     0.160     0.200
     0.233     0.419     0.200
     0.322     0.643     0.200
     0.353     0.590     0.200
     0.369    -0.529     0.200
     0.381     0.586     0.200
     0.433    -0.066     0.200
     0.436     0.633     0.200
     0.481    -0.132     0.200
     0.505    -0.360     0.200
     0.513     0.900     0.200
     0.533     0.745     0.200
     0.608    -0.242     0.200
     0.631    -0.539     0.200
     0.677    -0.203     0.200
     0.701    -0.358     0.200
     0.701    -0.297     0.200
     0.681     0.822     0.200
     0.761    -0.183     0.200
     0.849    -0.056     0.200
     0.874    -0.206     0.200
     0.886    -0.155     0.200
     0.939     0.022     0.200
     0.969     0.362     0.200
     0.076     0.794     0.200
     0.187    -0.340     0.200
     0.225    -0.668     0.200
     0.245     1.074     0.200
     0.373    -0.400     0.200
     0.363     0.813     0.200
     0.444    -0.150     0.200
     0.522    -0.264     0.200
     0.528     0.105     0.200
     0.564    -0.165     0.200
     0.605    -0.672     0.200
     0.662    -0.167     0.200
     0.707    -0.426     0.200
     0.933    -0.240     0.200
     0.958    -0.103     0.200
     0.994    -0.295     0.200
     0.628     0.494     0.200
     0.120     0.542     0.200
     0.159     0.492     0.200
     0.215     0.049     0.200
     0.241    -0.203     0.200
     0.330     0.544     0.200
     0.360     0.209     0.200
     0.388     0.476     0.200
     0.448    -0.064     0.200
     0.547     0.389     0.200
     0.606     0.594     0.200
     0.709     0.257     0.200
     0.722    -0.051     0.200
     0.746     0.288     0.200
     0.936     0.102     0.200
     0.990     0.127     0.200
     0.984     0.196     0.200
     0.111     0.257     0.200
     0.173     0.806     0.200
     0.226     0.091     0.200
     0.242    -0.089     0.200
     0.371     0.099     0.200
     0.402     0.559     0.200
     0.559     0.372     0.200
     0.618     0.565     0.200
     0.641     0.509     0.200
     0.652    -0.208     0.200
     0.721     0.161     0.200
     0.987     0.709     0.200
     0.349     0.209     0.200
     0.395    -0.625     0.200
     0.458    -0.399     0.200
     0.484     0.004     0.200
     0.487    -0.566     0.200
     0.598    -0.022     0.200
     0.617    -0.810     0.200
     0.648     0.057     0.200
     0.676     0.140     0.200
     0.680    -0.318     0.200
     0.693     0.384     0.200
     0.724    -0.008     0.200
     0.743     0.140     0.200
     0.750     0.447     0.200
     0.778    -0.368     0.200
     0.798     1.049     0.200
     0.830    -0.203     0.200
     0.883     0.096     0.200
     0.943     0.010     0.200
     0.086     0.368     0.200
     0.095    -0.207     0.200
     0.093    -0.045     0.200
     0.179     0.120     0.200
     0.254     0.127     0.200
     0.269    -0.364     0.200
     0.265     0.110     0.200
     0.345     0.196     0.200
     0.410     0.311     0.200
     0.446    -0.181     0.200
     0.481    -0.027     0.200
     0.094    -0.046     0.200
     0.086     0.340     0.200
     0.096    -0.014     0.200
     0.177     0.045     0.200
     0.256    -0.095     0.200
     0.267    -0.194     0.200
     0.267     0.017     0.200
     0.407     0.334     0.200
     0.444    -0.014     0.200
     0.479     0.079     0.200
     0.817     1.121     0.200
     0.979    -0.185     0.200
     0.223    -0.065     0.200
     0.310    -0.135     0.200
     0.337     0.254     0.200
     0.343     0.220     0.200
     0.350     0.110     0.200
     0.426    -1.121     0.200
     0.414     0.147     0.200
     0.474     0.844     0.200
     0.522    -0.435     0.200
     0.552    -0.467     0.200
     0.644    -0.451     0.200
     0.692    -0.150     0.200
     0.752    -0.724     0.200
     0.778    -0.432     0.200
     0.782    -0.226     0.200
     0.855     1.017     0.200
     0.874    -0.392     0.200
     0.107    -0.354     0.200
     0.246    -0.129     0.200
     0.264    -0.024     0.200
     0.278     0.366     0.200
     0.290     0.223     0.200
     0.326     0.441     0.200
     0.354    -0.067     0.200
     0.367     0.104     0.200
     0.399     0.123     0.200
     0.491    -0.802     0.200
     0.529    -0.167     0.200
     0.560    -0.062     0.200
     0.658     0.299     0.200
     0.668    -0.544     0.200
     0.852     0.012     0.200
     0.097    -0.020     0.200
     0.134    -0.446     0.200
     0.121    -0.145     0.200
     0.210     1.323     0.200
     0.306     0.232     0.200
     0.412    -0.030     0.200
     0.401     0.350     0.200
     0.447     0.351     0.200
     0.425     1.270     0.200
     0.469    -0.590     0.200
     0.709    -0.012     0.200
     0.742    -0.417     0.200
     0.130    -0.209     0.200
     0.101     0.278     0.200
     0.123     0.124     0.200
     0.233    -0.000     0.200
     0.214     1.267     0.200
     0.303     0.050     0.200
     0.363    -0.036     0.200
     0.386     0.083     0.200
     0.465    -0.120     0.200
     0.587    -0.447     0.200
     0.731    -0.583     0.200
     0.109    -0.178     0.200
     0.098     0.587     0.200
     0.186     0.659     0.200
     0.266     0.491     0.200
     0.319     0.215     0.200
     0.284     1.328     0.200
     0.323     0.218     0.200
     0.352     0.050     0.200
     0.441    -0.525     0.200
     0.430     0.334     0.200
     0.456     0.318     0.200
     0.478     0.037     0.200
     0.515    -1.169     0.200
     0.490     1.481     0.200
     0.504     0.664     0.200
     0.586     0.786     0.200
     0.666    -1.039     0.200
     0.702     0.044     0.200
     0.737    -0.494     0.200
     0.937    -0.081     0.200
     0.974    -0.623     0.200
     0.106    -0.158     0.200
     0.102     0.035     0.200
     0.190     0.499     0.200
     0.314     0.063     0.200
     0.289     1.072     0.200
     0.322     0.233     0.200
     0.349    -0.448     0.200
     0.436    -0.237     0.200
     0.429     0.408     0.200
     0.479     0.220     0.200
     0.509    -0.806     0.200
     0.495     1.212     0.200
     0.510     0.536     0.200
     0.660    -0.534     0.200
     0.104     0.181     0.200
     0.235     0.162     0.200
     0.251    -0.035     0.200
     0.285     0.189     0.200
     0.263     0.105     0.200
     0.318     0.150     0.200
     0.368    -0.527     0.200
     0.351     0.659     0.200
     0.369    -0.118     0.200
     0.388    -0.338     0.200
     0.438     0.347     0.200
     0.510    -1.061     0.200
     0.518    -1.030     0.200
     0.485     0.212     0.200
     0.563    -0.685     0.200
     0.578    -1.029     0.200
     0.580    -0.606     0.200
     0.588     0.362     0.200
     0.642     0.781     0.200
     0.792    -0.349     0.200
     0.807    -0.091     0.200
     0.848     0.289     0.200
     0.872    -0.621     0.200
     0.887    -0.903     0.200
     0.187     0.089     0.200
     0.303     0.295     0.200
     0.345     0.223     0.200
     0.369     0.123     0.200
     0.403     0.289     0.200
     0.428     0.533     0.200
     0.479    -0.015     0.200
     0.514     0.436     0.200
     0.574    -0.249     0.200
     0.594    -0.438     0.200
     0.634     0.095     0.200
     0.698    -0.145     0.200
     0.721     0.367     0.200
     0.739    -0.165     0.200
     0.813     0.213     0.200
     0.821    -0.005     0.200
     0.843     0.223     0.200
     0.881     0.583     0.200
     0.904    -0.134     0.200
     0.969     0.769     0.200
     0.105     0.537     0.200
     0.113     0.234     0.200
     0.254     0.135     0.200
     0.335     0.745     0.200
     0.338    -0.288     0.200
     0.359    -0.626     0.200
     0.378     0.033     0.200
     0.477    -0.785     0.200
     0.482    -0.407     0.200
     0.528    -0.467     0.200
     0.574    -0.233     0.200
     0.591    -0.099     0.200
     0.612    -0.061     0.200
     0.630    -0.559     0.200
     0.710    -0.432     0.200
     0.749    -0.206     0.200
     0.835     0.225     0.200
     0.923     0.131     0.200
     0.011     0.348     0.200
     0.093    -0.179     0.200
     0.159     0.096     0.200
     0.172    -0.016     0.200
     0.220    -0.544     0.200
     0.326     0.130     0.200
     0.343    -0.263     0.200
     0.457    -0.372     0.200
     0.458    -0.702     0.200
     0.464    -0.002     0.200
     0.489     0.120     0.200
     0.489    -0.106     0.200
     0.604    -0.463     0.200
     0.600    -0.607     0.200
     0.620    -0.804     0.200
     0.654     1.046     0.200
     0.677    -0.723     0.200
     0.672    -0.407     0.200
     0.685    -0.750     0.200
     0.748    -0.240     0.200
     0.758     0.026     0.200
     0.756     0.159     0.200
     0.783    -0.880     0.200
     0.804     0.355     0.200
     0.837    -0.499     0.200
     0.165    -0.146     0.200
     0.220    -0.322     0.200
     0.275     0.128     0.200
     0.270     0.326     0.200
     0.283    -0.434     0.200
     0.379    -0.551     0.200
     0.441    -0.463     0.200
     0.538     0.256     0.200
     0.570     0.095     0.200
     0.621    -0.549     0.200
     0.694    -0.333     0.200
     0.697    -0.884     0.200
     0.715    -0.532     0.200
     0.812     0.181     0.200
     0.830    -0.329     0.200
     0.842     0.437     0.200
     0.861    -0.366     0.200
     0.854    -0.153     0.200
     0.865    -0.594     0.200
     0.898    -0.129     0.200
     0.914    -0.069     0.200
     0.960     0.586     0.200
     0.995     0.290     0.200
     0.687     0.207     0.200
     0.150    -0.192     0.200
     0.287     0.194     0.200
     0.297     0.109     0.200
     0.293    -0.123     0.200
     0.308     0.243     0.200
     0.344     0.083     0.200
     0.360     0.062     0.200
     0.420     0.294     0.200
     0.532    -0.106     0.200
     0.534    -0.365     0.200
     0.614     0.460     0.200
     0.660    -0.443     0.200
     0.710    -0.023     0.200
     0.784     0.075     0.200
     0.830    -0.591     0.200
     0.843    -0.228     0.200
     0.687    -0.240     0.200
     0.150     0.477     0.200
     0.287     0.330     0.200
     0.308     0.627     0.200
     0.298    -0.009     0.200
     0.345     0.423     0.200
     0.360     0.140     0.200
     0.447    -1.221     0.200
     0.457    -0.521     0.200
     0.451    -0.223     0.200
     0.532    -0.214     0.200
     0.533    -0.423     0.200
     0.527    -0.414     0.200
     0.549    -0.209     0.200
     0.589     0.741     0.200
     0.615     0.492     0.200
     0.610     0.224     0.200
     0.659    -0.237     0.200
     0.710     0.099     0.200
     0.784     0.270     0.200
     0.800    -0.358     0.200
     0.830    -0.757     0.200
     0.817     0.017     0.200
     0.820     1.038     0.200
     0.843     0.124     0.200
     0.871    -0.280     0.200
     0.966     0.320     0.200
     0.984     0.325     0.200
     0.546    -0.665     0.200
     0.609    -1.180     0.200
     0.710    -0.115     0.200
     0.097    -0.082     0.200
     0.152     0.236     0.200
     0.204    -0.248     0.200
     0.215    -0.264     0.200
     0.264    -0.460     0.200
     0.321    -0.279     0.200
     0.348    -0.422     0.200
     0.427     0.407     0.200
     0.414    -0.568     0.200
     0.481     0.006     0.200
     0.544    -0.612     0.200
     0.620     0.779     0.200
     0.637     0.575     0.200
     0.632    -0.119     0.200
     0.666    -0.173     0.200
     0.667    -0.115     0.200
     0.669    -0.373     0.200
     0.694    -0.092     0.200
     0.768     0.052     0.200
     0.792    -0.269     0.200
     0.812     0.051     0.200
     0.818     0.244     0.200
     0.854    -0.184     0.200
     0.879     0.320     0.200
     0.939     0.247     0.200
     0.083     0.357     0.200
     0.166    -0.035     0.200
     0.248    -0.248     0.200
     0.255     0.343     0.200
     0.249     0.388     0.200
     0.332    -0.314     0.200
     0.378    -0.346     0.200
     0.418    -0.056     0.200
     0.441    -1.215     0.200
     0.420     0.413     0.200
     0.491     0.375     0.200
     0.543     0.658     0.200
     0.592    -0.519     0.200
     0.576     0.801     0.200
     0.622     1.032     0.200
     0.674     0.198     0.200
     0.882    -0.509     0.200
     0.904    -0.883     0.200
     0.959     0.380     0.200
     0.605     1.370     0.200
     0.137     0.641     0.200
     0.133     0.333     0.200
     0.202    -0.196     0.200
     0.245     0.203     0.200
     0.309     0.551     0.200
     0.337     0.252     0.200
     0.365    -0.070     0.200
     0.524     0.147     0.200
     0.584     0.825     0.200
     0.625    -0.256     0.200
     0.692     0.451     0.200
     0.853    -0.099     0.200
     0.088     0.497     0.200
     0.158    -0.057     0.200
     0.174    -0.094     0.200
     0.182     0.618     0.200
     0.210     0.504     0.200
     0.298     0.365     0.200
     0.361     0.433     0.200
     0.435    -0.186     0.200
     0.424    -0.182     0.200
     0.453    -0.020     0.200
     0.524    -0.494     0.200
     0.551     0.529     0.200
     0.608     0.069     0.200
     0.647    -1.141     0.200
     0.624     0.430     0.200
     0.732     0.439     0.200
     0.949     0.703     0.200
     0.006     0.351     0.200
     0.150     0.514     0.200
     0.179    -0.033     0.200
     0.192    -0.142     0.200
     0.221     0.102     0.200
     0.266     0.449     0.200
     0.275    -0.020     0.200
     0.349     0.024     0.200
     0.457    -0.201     0.200
     0.473    -0.414     0.200
     0.542     0.347     0.200
     0.607     0.029     0.200
     0.716    -0.695     0.200
     0.120     0.448     0.200
     0.129     0.159     0.200
     0.179     0.268     0.200
     0.250    -0.090     0.200
     0.296     0.556     0.200
     0.323    -0.020     0.200
     0.476    -0.505     0.200
     0.484    -0.248     0.200
     0.492     0.716     0.200
     0.571    -0.250     0.200
     0.610     0.131     0.200
     0.612    -0.251     0.200
     0.656     0.307     0.200
     0.673     0.566     0.200
     0.700     0.524     0.200
     0.709     0.426     0.200
     0.713     0.113     0.200
     0.719    -0.508     0.200
     0.743     0.320     0.200
     0.779     1.192     0.200
     0.826     0.589     0.200
     0.101     0.316     0.200
     0.165    -0.161     0.200
     0.175    -0.191     0.200
     0.206    -0.287     0.200
     0.285     0.361     0.200
     0.493    -0.178     0.200
     0.491    -0.102     0.200
     0.528    -0.383     0.200
     0.623    -0.139     0.200
     0.736     0.217     0.200
     0.104    -0.669     0.200
     0.144    -0.461     0.200
     0.213    -0.413     0.200
     0.211    -0.143     0.200
     0.294    -0.556     0.200
     0.349     0.435     0.200
     0.377    -0.374     0.200
     0.394    -0.626     0.200
     0.488    -0.706     0.200
     0.486     0.304     0.200
     0.500    -0.521     0.200
     0.521    -0.303     0.200
     0.542    -0.532     0.200
     0.568    -0.483     0.200
     0.573    -0.641     0.200
     0.641    -0.608     0.200
     0.637    -0.395     0.200
     0.711     0.401     0.200
     0.724    -0.032     0.200
     0.755    -0.094     0.200
     0.764     0.190     0.200
     0.776    -0.071     0.200
     0.840     0.232     0.200
     0.862     0.326     0.200
     0.121     0.777     0.200
     0.151     1.076     0.200
     0.214     0.353     0.200
     0.247     0.448     0.200
     0.324     0.288     0.200
     0.348     0.173     0.200
     0.380     0.518     0.200
     0.447    -0.161     0.200
     0.536     0.220     0.200
     0.595     0.588     0.200
     0.637     0.378     0.200
     0.745     0.208     0.200
     0.867     0.738     0.200
     0.936     0.913     0.200
     0.969     0.484     0.200
     0.997     1.114     0.200
     0.081     0.012     0.200
     0.206    -0.690     0.200
     0.224    -0.481     0.200
     0.218     0.104     0.200
     0.275     0.304     0.200
     0.422     0.380     0.200
     0.459     0.339     0.200
     0.492     0.188     0.200
     0.512    -0.417     0.200
     0.632    -0.356     0.200
     0.671    -0.326     0.200
     0.843     0.631     0.200
     0.931    -0.327     0.200
     0.082     0.658     0.200
     0.202     1.087     0.200
     0.258     0.637     0.200
     0.264     0.297     0.200
     0.374     0.236     0.200
     0.387     0.533     0.200
     0.429     0.685     0.200
     0.490    -0.092     0.200
     0.577     0.260     0.200
     0.634     0.175     0.200
     0.664     0.813     0.200
     0.684     0.214     0.200
     0.752     0.158     0.200
     0.765    -0.316     0.200
     0.787     0.483     0.200
     0.915     0.338     0.200
     0.956     0.364     0.200
     0.079     0.676     0.200
     0.209     0.573     0.200
     0.263     0.424     0.200
     0.265     0.075     0.200
     0.395    -0.089     0.200
     0.437     0.653     0.200
     0.584     0.428     0.200
     0.641     0.803     0.200
     0.672     0.564     0.200
     0.758     0.224     0.200
     0.979    -1.067     0.200
     0.150     0.273     0.200
     0.153    -0.160     0.200
     0.153     0.547     0.200
     0.203    -0.159     0.200
     0.294    -0.129     0.200
     0.376    -0.065     0.200
     0.376     0.326     0.200
     0.394    -0.127     0.200
     0.575    -0.268     0.200
     0.571     0.214     0.200
     0.634     0.938     0.200
     0.646    -0.285     0.200
     0.636     0.465     0.200
     0.671     0.403     0.200
     0.688    -0.056     0.200
     0.855    -0.493     0.200
     0.897     0.771     0.200
     0.914    -0.344     0.200
     0.956     0.002     0.200
     0.997     0.403     0.200
     0.399    -0.575     0.200
     0.012    -0.305     0.200
     0.114    -0.493     0.200
     0.158    -0.304     0.200
     0.233    -0.434     0.200
     0.310     0.151     0.200
     0.347    -0.330     0.200
     0.375    -0.726     0.200
     0.460    -0.534     0.200
     0.468    -0.207     0.200
     0.461    -0.732     0.200
     0.473    -0.061     0.200
     0.591    -0.315     0.200
     0.600    -0.088     0.200
     0.655     0.254     0.200
     0.679    -0.126     0.200
     0.685     0.487     0.200
     0.723    -0.052     0.200
     0.731    -0.217     0.200
     0.737     0.269     0.200
     0.731     0.319     0.200
     0.764     0.230     0.200
     0.802     0.705     0.200
     0.824    -0.326     0.200
     0.826    -0.116     0.200
     0.895     0.011     0.200
     0.974    -0.407     0.200
     0.133     0.384     0.200
     0.116     0.545     0.200
     0.184    -0.578     0.200
     0.237     0.769     0.200
     0.269     0.043     0.200
     0.279     0.337     0.200
     0.285     0.896     0.200
     0.315     0.837     0.200
     0.410     0.359     0.200
     0.432     0.439     0.200
     0.484    -0.182     0.200
     0.494    -0.483     0.200
     0.515    -0.653     0.200
     0.565    -0.515     0.200
     0.574    -0.495     0.200
     0.569     0.299     0.200
     0.752     0.926     0.200
     0.034     0.150     0.200
     0.122    -0.399     0.200
     0.194     0.054     0.200
     0.258    -0.530     0.200
     0.291     0.521     0.200
     0.308    -0.678     0.200
     0.365    -0.057     0.200
     0.567    -0.419     0.200
     0.621    -0.342     0.200
     0.627    -0.075     0.200
     0.661    -0.075     0.200
     0.688     0.410     0.200
     0.709    -0.651     0.200
     0.710    -0.665     0.200
     0.715    -0.342     0.200
     0.713    -0.105     0.200
     0.723     0.653     0.200
     0.841     0.382     0.200
     0.865    -0.118     0.200
     0.986    -0.569     0.200
     0.030    -0.199     0.200
     0.113    -0.439     0.200
     0.195    -0.101     0.200
     0.250    -0.244     0.200
     0.300     0.162     0.200
     0.311    -0.779     0.200
     0.374    -0.330     0.200
     0.444    -0.316     0.200
     0.492    -0.508     0.200
     0.496    -0.253     0.200
     0.576    -0.315     0.200
     0.627    -0.295     0.200
     0.628    -0.178     0.200
     0.685     0.013     0.200
     0.712     0.076     0.200
     0.706     0.227     0.200
     0.719    -0.454     0.200
     0.724    -0.313     0.200
     0.719    -0.470     0.200
     0.796     0.019     0.200
     0.837     0.562     0.200
     0.127    -0.578     0.200
     0.200    -0.279     0.200
     0.262     0.404     0.200
     0.273     0.884     0.200
     0.318     0.072     0.200
     0.388     0.153     0.200
     0.401    -0.037     0.200
     0.412    -0.456     0.200
     0.432     0.133     0.200
     0.629    -0.379     0.200
     0.634     0.019     0.200
     0.645     0.452     0.200
     0.657     0.132     0.200
     0.732     0.328     0.200
     0.837    -0.337     0.200
     0.874     0.413     0.200
     0.912     0.557     0.200
     0.919    -0.148     0.200
     0.100    -1.404     0.200
     0.185    -0.542     0.200
     0.263     0.002     0.200
     0.276     0.211     0.200
     0.306     0.036     0.200
     0.369     0.437     0.200
     0.408    -0.184     0.200
     0.427    -0.037     0.200
     0.454    -0.791     0.200
     0.456    -0.627     0.200
     0.462     0.023     0.200
     0.531    -0.642     0.200
     0.598    -0.602     0.200
     0.638    -0.836     0.200
     0.665    -0.071     0.200
     0.688    -0.479     0.200
     0.674    -0.148     0.200
     0.691     0.102     0.200
     0.759     0.074     0.200
     0.782     0.015     0.200
     0.809    -0.202     0.200
     0.919     0.642     0.200
     0.935     0.680     0.200
     0.955     0.100     0.200
     0.948     0.356     0.200
     0.164    -0.642     0.200
     0.179     0.274     0.200
     0.210    -0.033     0.200
     0.285    -0.038     0.200
     0.341    -0.084     0.200
     0.361    -0.297     0.200
     0.388     0.362     0.200
     0.629    -0.383     0.200
     0.706    -0.366     0.200
     0.732    -0.200     0.200
     0.772    -0.502     0.200
     0.084    -0.322     0.200
     0.194    -0.187     0.200
     0.233    -0.018     0.200
     0.274    -0.266     0.200
     0.309    -0.404     0.200
     0.347    -0.151     0.200
     0.367    -0.787     0.200
     0.362    -0.550     0.200
     0.488     0.082     0.200
     0.497    -0.172     0.200
     0.503    -0.725     0.200
     0.547    -0.777     0.200
     0.556     0.117     0.200
     0.612    -0.883     0.200
     0.745    -0.042     0.200
     0.760     0.176     0.200
     0.820     0.056     0.200
     0.850     0.153     0.200
     0.135     0.026     0.200
     0.212     0.116     0.200
     0.263    -0.635     0.200
     0.343     0.312     0.200
     0.362    -0.243     0.200
     0.414    -0.804     0.200
     0.499     0.368     0.200
     0.636     0.254     0.200
     0.650    -0.097     0.200
     0.677    -0.534     0.200
     0.689    -0.172     0.200
     0.680    -0.497     0.200
     0.815    -0.292     0.200
     0.882    -0.456     0.200
     0.894    -0.511     0.200
     0.983     0.078     0.200
     0.161    -0.381     0.200
     0.194     0.104     0.200
     0.255    -0.825     0.200
     0.338     0.047     0.200
     0.405    -0.239     0.200
     0.623     0.501     0.200
     0.634    -0.307     0.200
     0.656    -0.096     0.200
     0.675    -0.141     0.200
     0.688     0.049     0.200
     0.145    -0.650     0.200
     0.202    -0.097     0.200
     0.233     0.286     0.200
     0.255    -0.447     0.200
     0.352    -0.309     0.200
     0.406    -0.780     0.200
     0.498     0.007     0.200
     0.558    -0.538     0.200
     0.636     0.406     0.200
     0.649    -0.419     0.200
     0.683     0.069     0.200
     0.708    -0.562     0.200
     0.775    -0.926     0.200
     0.807    -0.382     0.200
     0.897    -0.170     0.200
     0.986    -0.007     0.200
     0.135    -0.591     0.200
     0.211    -0.164     0.200
     0.237     0.382     0.200
     0.262    -0.774     0.200
     0.343     0.158     0.200
     0.361    -0.577     0.200
     0.413    -0.528     0.200
     0.450    -0.265     0.200
     0.500     0.155     0.200
     0.637    -0.109     0.200
     0.651    -0.460     0.200
     0.681     0.014     0.200
     0.717    -1.013     0.200
     0.716    -0.155     0.200
     0.881    -0.034     0.200
     0.901    -0.231     0.200
     0.895    -0.052     0.200
     0.161    -0.143     0.200
     0.176    -0.354     0.200
     0.188     0.583     0.200
     0.281     0.352     0.200
     0.313     0.119     0.200
     0.357    -0.446     0.200
     0.413     0.358     0.200
     0.396     0.555     0.200
     0.433    -0.028     0.200
     0.532     0.177     0.200
     0.573    -0.433     0.200
     0.648    -0.916     0.200
     0.654     0.022     0.200
     0.653    -0.146     0.200
     0.726     0.672     0.200
     0.754    -0.405     0.200
     0.818    -0.500     0.200
     0.937     0.369     0.200
     0.098     0.333     0.200
     0.195     0.026     0.200
     0.229    -0.531     0.200
     0.247    -0.235     0.200
     0.295    -0.285     0.200
     0.315     0.391     0.200
     0.362     0.012     0.200
     0.358    -0.249     0.200
     0.372    -0.034     0.200
     0.511    -0.508     0.200
     0.542    -1.264     0.200
     0.512    -0.116     0.200
     0.517    -0.348     0.200
     0.539    -0.736     0.200
     0.601    -0.252     0.200
     0.608    -0.217     0.200
     0.618    -0.286     0.200
     0.632    -0.586     0.200
     0.696    -0.439     0.200
     0.692    -0.087     0.200
     0.759    -0.467     0.200
     0.840    -0.332     0.200
     0.879     0.192     0.200
     0.879     0.533     0.200
     0.912    -0.266     0.200
     0.924    -0.723     0.200
     0.927    -0.548     0.200
     0.507    -0.784     0.200
     0.650     0.638     0.200
     0.080    -0.005     0.200
     0.222     0.736     0.200
     0.263     0.042     0.200
     0.271     0.090     0.200
     0.409     0.545     0.200
     0.450     0.180     0.200
     0.599    -0.098     0.200
     0.656     0.708     0.200
     0.686     0.619     0.200
     0.114    -0.040     0.200
     0.198     0.351     0.200
     0.219    -0.597     0.200
     0.309    -0.164     0.200
     0.321     0.097     0.200
     0.370     0.517     0.200
     0.373     0.273     0.200
     0.385    -0.059     0.200
     0.541    -0.801     0.200
     0.523    -0.235     0.200
     0.542    -0.203     0.200
     0.608    -0.364     0.200
     0.623    -0.719     0.200
     0.624    -0.218     0.200
     0.632     0.151     0.200
     0.706    -0.288     0.200
     0.837    -0.225     0.200
     0.935    -0.507     0.200
     0.179    -0.532     0.200
     0.231    -0.297     0.200
     0.336    -1.022     0.200
     0.349    -0.316     0.200
     0.364    -0.110     0.200
     0.397    -0.508     0.200
     0.407     0.450     0.200
     0.413    -0.181     0.200
     0.440     0.278     0.200
     0.447     0.041     0.200
     0.511    -0.666     0.200
     0.534    -0.270     0.200
     0.546    -0.275     0.200
     0.620     0.528     0.200
     0.639    -0.340     0.200
     0.637     0.426     0.200
     0.660    -0.742     0.200
     0.687     0.191     0.200
     0.751    -0.702     0.200
     0.769    -0.646     0.200
     0.773     0.377     0.200
     0.809    -0.076     0.200
     0.843    -0.454     0.200
     0.835     0.116     0.200
     0.861     0.196     0.200
     0.946     0.193     0.200
     0.879    -0.936     0.200
     0.102    -0.119     0.200
     0.205    -0.003     0.200
     0.295     0.056     0.200
     0.326    -0.034     0.200
     0.357     0.480     0.200
     0.369     0.247     0.200
     0.532    -0.785     0.200
     0.524     0.330     0.200
     0.618     0.083     0.200
     0.629     0.389     0.200
     0.693    -0.286     0.200
     0.703     0.398     0.200
     0.922     0.239     0.200
     0.347    -0.947     0.200
     0.151     0.242     0.200
     0.223    -0.466     0.200
     0.235     0.954     0.200
     0.326     0.667     0.200
     0.349    -0.179     0.200
     0.407     0.047     0.200
     0.484     0.560     0.200
     0.523    -0.101     0.200
     0.581     0.242     0.200
     0.625     0.360     0.200
     0.677    -0.325     0.200
     0.032    -0.214     0.200
     0.165    -0.150     0.200
     0.175    -0.203     0.200
     0.203     0.290     0.200
     0.369     0.258     0.200
     0.367    -0.372     0.200
     0.482    -0.341     0.200
     0.510    -0.688     0.200
     0.581    -0.149     0.200
     0.571     0.190     0.200
     0.590    -0.363     0.200
     0.599    -0.671     0.200
     0.643    -0.116     0.200
     0.638    -0.215     0.200
     0.665    -0.092     0.200
     0.711    -0.930     0.200
     0.708     0.868     0.200
     0.728     0.697     0.200
     0.725    -0.363     0.200
     0.787    -0.430     0.200
     0.848     0.210     0.200
     0.865     0.426     0.200
     0.864     0.041     0.200
     0.927     0.223     0.200
     0.175     0.605     0.200
     0.275    -0.164     0.200
     0.311    -0.451     0.200
     0.341    -0.243     0.200
     0.347     0.191     0.200
     0.447     0.475     0.200
     0.439     0.137     0.200
     0.501     0.238     0.200
     0.545    -0.582     0.200
     0.556     0.373     0.200
     0.661    -0.130     0.200
     0.683     0.949     0.200
     0.720    -1.167     0.200
     0.740    -0.870     0.200
     0.122     0.238     0.200
     0.203    -0.165     0.200
     0.257     0.227     0.200
     0.312     0.293     0.200
     0.317     0.198     0.200
     0.394     0.029     0.200
     0.426     0.444     0.200
     0.452     0.490     0.200
     0.586    -0.213     0.200
     0.604    -0.438     0.200
     0.624     0.451     0.200
     0.665    -0.111     0.200
     0.713     0.097     0.200
     0.717     0.498     0.200
     0.721     0.552     0.200
     0.800    -0.309     0.200
     0.809     0.386     0.200
     0.867     0.072     0.200
     0.903     0.341     0.200
     0.928     0.824     0.200
     0.991     0.387     0.200
     0.035    -0.547     0.200
     0.127    -0.951     0.200
     0.193    -0.611     0.200
     0.287    -0.238     0.200
     0.308    -0.580     0.200
     0.361    -0.431     0.200
     0.431    -0.236     0.200
     0.505     0.580     0.200
     0.500     0.033     0.200
     0.499    -0.893     0.200
     0.563     0.100     0.200
     0.618    -0.975     0.200
     0.625     0.184     0.200
     0.657    -0.414     0.200
     0.688     0.988     0.200
     0.683     0.275     0.200
     0.706    -0.277     0.200
     0.706    -0.373     0.200
     0.711    -0.110     0.200
     0.715    -0.118     0.200
     0.748    -0.575     0.200
     0.770    -0.163     0.200
     0.789    -0.093     0.200
     0.796    -0.317     0.200
     0.841     0.533     0.200
     0.846     0.172     0.200
     0.931    -0.009     0.200
     0.034     0.696     0.200
     0.130    -0.152     0.200
     0.187    -0.464     0.200
     0.284     0.342     0.200
     0.312     0.026     0.200
     0.356    -0.636     0.200
     0.425    -0.475     0.200
     0.474     0.496     0.200
     0.496    -0.187     0.200
     0.498     0.774     0.200
     0.560    -0.495     0.200
     0.610     0.163     0.200
     0.619     0.450     0.200
     0.651    -0.867     0.200
     0.684     0.009     0.200
     0.698    -0.088     0.200
     0.702    -0.019     0.200
     0.707     0.132     0.200
     0.714    -0.599     0.200
     0.741     0.242     0.200
     0.767    -0.784     0.200
     0.794    -0.535     0.200
     0.837     0.747     0.200
     0.136     0.314     0.200
     0.231     0.071     0.200
     0.203     0.529     0.200
     0.286     0.340     0.200
     0.302     0.263     0.200
     0.311     0.999     0.200
     0.372    -0.072     0.200
     0.414     0.811     0.200
     0.441     0.262     0.200
     0.463     0.813     0.200
     0.537    -0.005     0.200
     0.545     0.265     0.200
     0.565    -0.256     0.200
     0.606     1.051     0.200
     0.653    -0.191     0.200
     0.634     0.928     0.200
     0.880     0.089     0.200
     0.930     0.215     0.200
     0.971     0.171     0.200
     0.037     0.360     0.200
     0.136    -0.261     0.200
     0.185    -0.313     0.200
     0.279    -0.011     0.200
     0.420    -0.127     0.200
     0.495     0.019     0.200
     0.555    -0.058     0.200
     0.616    -0.120     0.200
     0.645    -0.275     0.200
     0.703     0.101     0.200
     0.716     0.532     0.200
     0.777     0.812     0.200
     0.837     0.839     0.200
     0.997     0.622     0.200
     0.135    -0.166     0.200
     0.199     0.129     0.200
     0.210    -0.032     0.200
     0.290    -0.105     0.200
     0.340     0.216     0.200
     0.340     0.607     0.200
     0.488     0.551     0.200
     0.564     0.334     0.200
     0.681    -0.678     0.200
     0.906    -0.038     0.200
     0.037     0.544     0.200
     0.134    -0.301     0.200
     0.185     0.212     0.200
     0.266    -0.272     0.200
     0.313    -0.066     0.200
     0.352    -0.283     0.200
     0.421     0.112     0.200
     0.496    -0.532     0.200
     0.498    -0.748     0.200
     0.607     0.222     0.200
     0.646    -1.111     0.200
     0.684     0.246     0.200
     0.695    -0.057     0.200
     0.698    -0.445     0.200
     0.715    -0.081     0.200
     0.722    -0.346     0.200
     0.768    -0.826     0.200
     0.779    -0.052     0.200
     0.792     0.025     0.200
     0.838     0.438     0.200
     0.849    -0.733     0.200
     0.857    -0.645     0.200
     0.722    -0.500     0.200
     0.192     0.203     0.200
     0.253    -0.253     0.200
     0.290    -0.116     0.200
     0.419    -0.036     0.200
     0.415     0.074     0.200
     0.527    -0.209     0.200
     0.718    -0.086     0.200
     0.736     0.074     0.200
     0.809     0.403     0.200
     0.884    -0.579     0.200
     0.901    -0.193     0.200
     0.925    -0.136     0.200
     0.020    -0.184     0.200
     0.101    -0.431     0.200
     0.152     0.094     0.200
     0.215    -0.227     0.200
     0.470    -0.337     0.200
     0.584     0.238     0.200
     0.604    -0.844     0.200
     0.636     0.599     0.200
     0.667     0.044     0.200
     0.680    -0.517     0.200
     0.740    -0.097     0.200
     0.745    -0.774     0.200
     0.787    -0.023     0.200
     0.113     0.351     0.200
     0.175     0.460     0.200
     0.257    -0.374     0.200
     0.278    -0.465     0.200
     0.316    -0.314     0.200
     0.366     0.069     0.200
     0.420     0.139     0.200
     0.418    -0.156     0.200
     0.438     0.507     0.200
     0.447     0.139     0.200
     0.472     0.262     0.200
     0.522    -0.364     0.200
     0.500     0.150     0.200
     0.555     0.688     0.200
     0.581     0.669     0.200
     0.662    -0.622     0.200
     0.668     0.572     0.200
     0.688    -0.920     0.200
     0.686     0.506     0.200
     0.708    -0.718     0.200
     0.708    -0.231     0.200
     0.795    -0.158     0.200
     0.861    -0.601     0.200
     0.840     0.290     0.200
     0.914     0.740     0.200
     0.360    -0.284     0.200
     0.745     1.531     0.200
     0.139    -0.059     0.200
     0.143    -0.340     0.200
     0.227    -0.338     0.200
     0.293    -0.262     0.200
     0.307    -0.577     0.200
     0.623     0.177     0.200
     0.734    -0.741     0.200
     0.753     0.225     0.200
     0.782     0.561     0.200
     0.803     0.420     0.200
     0.018     0.510     0.200
     0.122    -0.604     0.200
     0.166     0.448     0.200
     0.246    -0.373     0.200
     0.428    -0.774     0.200
     0.479     0.829     0.200
     0.599    -0.816     0.200
     0.649    -0.866     0.200
     0.683    -0.547     0.200
     0.692     0.163     0.200
     0.712     0.087     0.200
     0.698    -0.055     0.200
     0.814     0.691     0.200
     0.114    -0.233     0.200
     0.165     0.049     0.200
     0.186    -0.459     0.200
     0.261     0.483     0.200
     0.272    -0.414     0.200
     0.346     0.731     0.200
     0.347    -0.143     0.200
     0.377    -0.189     0.200
     0.587    -0.071     0.200
     0.599    -0.654     0.200
     0.637     0.115     0.200
     0.651    -0.040     0.200
     0.728     0.390     0.200
     0.795     0.666     0.200
     0.830    -0.457     0.200
     0.134     0.043     0.200
     0.316    -0.170     0.200
     0.317     0.071     0.200
     0.332    -0.595     0.200
     0.421    -0.174     0.200
     0.492    -0.039     0.200
     0.525    -0.769     0.200
     0.513     0.001     0.200
     0.614    -0.264     0.200
     0.616    -0.396     0.200
     0.792    -0.813     0.200
     0.789    -0.924     0.200
     0.773    -0.408     0.200
     0.803     0.016     0.200
     0.828    -0.333     0.200
     0.946    -0.691     0.200
     0.946    -0.137     0.200
     0.610    -1.125     0.200
     0.145     0.711     0.200
     0.166     0.131     0.200
     0.267    -0.452     0.200
     0.315    -0.827     0.200
     0.340    -0.463     0.200
     0.307     0.335     0.200
     0.380    -0.645     0.200
     0.384     0.103     0.200
     0.372    -0.155     0.200
     0.422     0.465     0.200
     0.507     0.152     0.200
     0.529    -0.497     0.200
     0.545    -1.036     0.200
     0.523     0.100     0.200
     0.540    -0.408     0.200
     0.520     0.062     0.200
     0.647     0.677     0.200
     0.660     0.458     0.200
     0.681    -0.849     0.200
     0.683     0.450     0.200
     0.740    -0.428     0.200
     0.749    -0.587     0.200
     0.753    -1.046     0.200
     0.786     0.894     0.200
     0.826    -0.122     0.200
     0.825     0.749     0.200
     0.852     0.710     0.200
     0.917    -0.290     0.200
     0.932    -0.068     0.200
     0.300     0.385     0.200
     0.675     0.214     0.200
     0.715     1.503     0.200
     0.981    -2.014     0.200
     0.146     0.363     0.200
     0.168    -0.013     0.200
     0.270    -0.462     0.200
     0.318    -0.785     0.200
     0.304     0.486     0.200
     0.344    -0.552     0.200
     0.383    -0.750     0.200
     0.384     0.116     0.200
     0.368    -0.220     0.200
     0.424     0.558     0.200
     0.510     0.203     0.200
     0.524    -0.010     0.200
     0.549    -1.114     0.200
     0.517    -0.050     0.200
     0.647     0.363     0.200
     0.662     0.272     0.200
     0.685    -0.978     0.200
     0.687     0.185     0.200
     0.743    -0.575     0.200
     0.753    -0.654     0.200
     0.757    -1.120     0.200
     0.784     0.321     0.200
     0.830    -0.251     0.200
     0.824     0.803     0.200
     0.850     0.793     0.200
     0.921    -0.283     0.200
     0.936    -0.217     0.200
     0.946    -0.319     0.200
     0.677    -0.085     0.200
     0.075     0.319     0.200
     0.098    -0.076     0.200
     0.237     0.475     0.200
     0.262     0.474     0.200
     0.421    -0.140     0.200
     0.466     0.119     0.200
     0.539    -0.224     0.200
     0.554     0.288     0.200
     0.575     0.137     0.200
     0.613    -0.001     0.200
     0.611     0.468     0.200
     0.646     0.470     0.200
     0.734    -1.409     0.200
     0.796    -0.750     0.200
     0.873    -0.079     0.200
     0.422    -0.984     0.200
     0.054     0.389     0.200
     0.280     0.539     0.200
     0.295    -0.203     0.200
     0.387     0.566     0.200
     0.377     0.601     0.200
     0.513    -0.283     0.200
     0.568     0.350     0.200
     0.622     0.380     0.200
     0.661     0.026     0.200
     0.772     0.914     0.200
     0.775     0.357     0.200
     0.964     0.778     0.200
     0.038     0.110     0.200
     0.112    -0.322     0.200
     0.133    -0.596     0.200
     0.190    -0.039     0.200
     0.207    -0.038     0.200
     0.266    -0.422     0.200
     0.281     0.019     0.200
     0.309    -0.791     0.200
     0.354    -0.661     0.200
     0.474    -0.239     0.200
     0.501     0.348     0.200
     0.501    -0.835     0.200
     0.611    -0.659     0.200
     0.622    -0.440     0.200
     0.650    -0.074     0.200
     0.688    -0.066     0.200
     0.700    -0.599     0.200
     0.700    -0.480     0.200
     0.704    -0.578     0.200
     0.741     0.417     0.200
     0.783    -0.530     0.200
     0.875    -0.425     0.200
     0.207     0.215     0.200
     0.201     0.338     0.200
     0.218     0.303     0.200
     0.249     0.257     0.200
     0.299     0.124     0.200
     0.333    -0.337     0.200
     0.356     0.034     0.200
     0.415    -0.134     0.200
     0.444    -0.790     0.200
     0.725    -0.158     0.200
     0.302    -0.821     0.200
     0.451     0.694     0.200
     0.039     0.834     0.200
     0.972     0.588     0.200
     0.607     0.371     0.200
     0.763    -2.028     0.200
     0.751    -0.712     0.200
     0.715    -1.028     0.200
     0.596    -0.350     0.200
     0.863    -1.147     0.200
     0.436    -0.626     0.200
     0.787    -0.925     0.200
     0.381    -0.623     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.959    -2.097     0.200
     0.996    -2.545     0.200
     0.960    -1.261     0.200
     0.975    -2.363     0.200
     0.942    -1.153     0.200
     0.852    -2.468     0.200
     0.969    -2.554     0.200
     0.948    -0.920     0.200
     0.879     1.724     0.200
     0.958    -1.000     0.200
     0.912    -1.849     0.200
     0.958    -2.291     0.200
     0.961    -2.274     0.200
     0.957    -1.523     0.200
     0.802    -2.147     0.200
     0.949    -1.327     0.200
     0.949    -1.554     0.200
     0.984    -1.880     0.200
     0.976    -2.388     0.200
     0.922    -2.365     0.200
     0.936    -2.394     0.200
     0.991    -1.884     0.200
     0.944    -2.166     0.200
     0.878    -2.091     0.200
     0.868    -0.575     0.200
     0.896    -0.917     0.200
     0.973    -2.045     0.200
     0.908    -0.936     0.200
     0.793    -2.073     0.200
     0.804    -1.587     0.200
     0.862    -1.789     0.200
     0.914    -1.500     0.200
     0.915    -1.789     0.200
     0.954    -1.427     0.200
     0.978     0.476     0.200
     0.856    -2.023     0.200
     0.978    -1.519     0.200
     0.975    -2.077     0.200
     0.998    -1.552     0.200
     0.919    -2.143     0.200
     0.909    -2.467     0.200
     0.988    -1.848     0.200
     0.893    -1.624     0.200
     0.921    -2.656     0.200
     0.921    -1.753     0.200
     0.977    -1.852     0.200
     0.826    -2.499     0.200
     0.947    -2.486     0.200
     0.991    -1.800     0.200
     0.925    -2.407     0.200
     0.974    -1.971     0.200
     0.882    -2.380     0.200
     0.829    -2.027     0.200
     0.957    -2.291     0.200
     0.843    -2.513     0.200
     0.958    -2.198     0.200
     0.961    -2.140     0.200
     0.973    -0.818     0.200
     0.819    -1.933     0.200
     0.995    -1.216     0.200
     0.920    -1.238     0.200
     0.951    -2.367     0.200
     0.811    -2.540     0.200
     0.836    -2.082     0.200
     0.958    -1.720     0.200
     0.994    -1.572     0.200
     0.918    -2.149     0.200
     0.964    -2.290     0.200
     0.808    -2.323     0.200
     0.988    -1.931     0.200
     0.889    -2.433     0.200
     0.893    -2.111     0.200
     0.895    -2.229     0.200
     0.971    -1.049     0.200
     0.850    -1.998     0.200
     0.959    -1.391     0.200
     0.986    -1.178     0.200
     0.984    -1.611     0.200
     0.976    -1.790     0.200
     0.999    -1.624     0.200
     0.984    -2.202     0.200
     0.882    -2.510     0.200
     0.945    -2.392     0.200
     0.809    -0.014     0.200
     0.919     0.492     0.200
     0.995     3.339     0.200
     0.914    -2.563     0.200
     0.961    -2.159     0.200
     0.986    -1.779     0.200
     0.987    -2.077     0.200
     0.896     0.833     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.012
 0.80    0.012
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -1.303
 0.80   -1.303
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00   -0.1
 0.80   -0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -2.1
 0.80   -2.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.8)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -1.3 (solid green line)
     0.050    -7.500   Sg = red circles; average =  -0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -2.1 (dashed green line)
EOF
gmt end
