#!/bin/bash
gmt begin chamoli16.22_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic chamoli16.22'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.726
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.112
   139.000     2.217
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.677
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.503
   144.500     3.659
   145.000     3.821
   145.500     3.990
   146.000     4.165
   146.500     4.346
   147.000     4.535
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.364
   149.500     5.592
   150.000     5.830
   150.500     6.078
   151.000     6.337
   151.500     6.605
   152.000     6.884
   152.500     7.172
   153.000     7.471
   153.500     7.781
   154.000     8.101
   154.500     8.432
   155.000     8.774
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.687
   145.500     0.276
   146.000     1.303
   146.500     2.372
   147.000     3.477
   147.500     4.610
   148.000     5.771
   148.500     6.958
   149.000     8.167
   149.500     9.400
   150.000    10.655
   150.500    11.931
   151.000    13.228
   151.500    14.544
   152.000    15.879
   152.500    17.232
   153.000    18.604
   153.500    19.993
   154.000    21.400
   154.500    22.824
   155.000    24.266
   155.500    25.724
   156.000    27.199
   156.500    28.691
   157.000    30.200
   157.500    31.726
   158.000    33.268
   158.500    34.827
   159.000    36.402
   159.500    37.993
   160.000    39.601
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.690
   145.500     0.076
   146.000     0.769
   146.500     1.411
   147.000     2.010
   147.500     2.570
   148.000     3.095
   148.500     3.587
   149.000     4.053
   149.500     4.499
   150.000     4.929
   150.500     5.346
   151.000     5.753
   151.500     6.150
   152.000     6.539
   152.500     6.920
   153.000     7.296
   153.500     7.667
   154.000     8.036
   154.500     8.402
   155.000     8.767
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   148.301     1.697     0.200
   151.038     2.650     0.200
   151.323     3.013     0.200
   152.377    -1.669     0.200
   144.642     0.696     0.200
   147.474     0.884     0.200
   148.698     1.770     0.200
   148.872     1.089     0.200
   151.439     3.059     0.200
   152.778    -1.940     0.200
   153.706     2.719     0.200
   147.294     0.994     0.200
   135.235     0.272     0.200
   148.048     0.176     0.200
   150.464    -0.301     0.200
   150.897     1.927     0.200
   151.181     2.890     0.200
   152.235    -0.098     0.200
   153.006     1.267     0.200
   153.443     1.135     0.200
   153.602     0.906     0.200
   155.150     0.243     0.200
   155.750     0.434     0.200
   148.378     1.929     0.200
   148.387     2.402     0.200
   147.887     0.163     0.200
   147.999     0.979     0.200
   144.758     0.337     0.200
   148.212     1.345     0.200
   147.654     0.333     0.200
   148.223     2.081     0.200
   138.106    -3.315     0.200
   138.691    -2.140     0.200
   138.751    -4.686     0.200
   139.466    -2.986     0.200
   141.428    -2.456     0.200
   146.551     1.054     0.200
   146.666     1.056     0.200
   149.388     2.283     0.200
   151.787     2.556     0.200
   151.828     1.096     0.200
   151.995     0.846     0.200
   152.195    -0.054     0.200
   152.299     1.291     0.200
   153.905     0.459     0.200
   153.920     2.437     0.200
   153.991     1.337     0.200
   154.022     0.294     0.200
   154.027     3.287     0.200
   154.030     3.282     0.200
   154.259     0.959     0.200
   154.290     2.916     0.200
   154.661     0.400     0.200
   154.781    -4.766     0.200
   154.822     2.677     0.200
   148.409     0.532     0.200
   151.148     2.193     0.200
   143.982     0.446     0.200
   149.958     2.454     0.200
   151.300     0.552     0.200
   152.265     0.123     0.200
   152.435     1.667     0.200
   152.633     0.673     0.200
   152.890    -2.798     0.200
   153.590    -1.412     0.200
   154.119     2.087     0.200
   154.443     1.734     0.200
   154.729     0.712     0.200
   153.555     0.457     0.200
   153.574     0.220     0.200
   152.822    -2.854     0.200
   146.062    -0.145     0.200
   142.694     0.324     0.200
   148.479     1.111     0.200
   142.747    -0.420     0.200
   148.041     1.211     0.200
   151.554     1.557     0.200
   148.132     1.594     0.200
   148.336     3.139     0.200
   140.940     0.599     0.200
   146.084     1.400     0.200
   148.001     0.165     0.200
   147.672     1.566     0.200
   145.669     0.658     0.200
   145.669     1.043     0.200
   143.931     0.832     0.200
   148.195     1.927     0.200
   142.721     0.928     0.200
   148.203     2.646     0.200
   135.959     0.172     0.200
   137.102    -0.820     0.200
   137.870    -0.538     0.200
   138.025    -0.266     0.200
   140.466     0.893     0.200
   141.607     0.007     0.200
   141.754     0.314     0.200
   143.328    -1.351     0.200
   144.252    -0.919     0.200
   144.252    -0.149     0.200
   148.528     1.675     0.200
   148.528     1.226     0.200
   149.925     0.823     0.200
   150.214     2.329     0.200
   152.743    -0.611     0.200
   154.203    -0.133     0.200
   154.203     1.792     0.200
   155.138     1.607     0.200
   140.955    -1.575     0.200
   146.201     1.243     0.200
   146.080     1.775     0.200
   146.394    -0.071     0.200
   141.944     0.518     0.200
   147.252     1.269     0.200
   153.174    -2.225     0.200
   138.218     0.577     0.200
   138.218     0.276     0.200
   138.595     0.025     0.200
   138.958    -0.590     0.200
   140.808    -0.040     0.200
   141.625    -0.064     0.200
   141.680    -0.608     0.200
   141.680     0.419     0.200
   142.648     0.256     0.200
   143.477    -1.157     0.200
   144.237     0.193     0.200
   146.871     1.855     0.200
   146.871     0.941     0.200
   146.871     0.254     0.200
   147.287    -1.625     0.200
   149.033     1.360     0.200
   149.396    -2.262     0.200
   149.848    -0.032     0.200
   150.345     2.217     0.200
   150.382     1.238     0.200
   150.981    -3.519     0.200
   151.330    -0.686     0.200
   151.926     0.406     0.200
   152.120    -1.704     0.200
   152.997    -0.536     0.200
   153.068    -0.870     0.200
   153.370    -0.710     0.200
   153.448     0.694     0.200
   153.448    -1.798     0.200
   153.771     1.388     0.200
   153.816    -0.817     0.200
   154.379     0.152     0.200
   141.666    -1.473     0.200
   148.152     2.643     0.200
   148.152     1.672     0.200
   141.153     0.117     0.200
   146.350     1.496     0.200
   146.350     1.237     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   151.727     4.226     0.200
   153.706     6.719     0.200
   147.816     1.515     0.200
   147.989     2.030     0.200
   147.226     2.641     0.200
   147.396     2.258     0.200
   148.161     2.287     0.200
   148.491     2.646     0.200
   147.262     1.079     0.200
   148.666     1.970     0.200
   148.324     2.161     0.200
   146.950     1.821     0.200
   147.064     2.130     0.200
   147.111     1.552     0.200
   147.542     2.519     0.200
   148.333     2.900     0.200
   150.723     3.181     0.200
   152.665     3.851     0.200
   146.869     1.914     0.200
   148.311     3.793     0.200
   148.059     3.348     0.200
   147.058     1.988     0.200
   146.297     0.863     0.200
   147.009     1.632     0.200
   153.511     6.997     0.200
   148.118     3.444     0.200
   153.207     5.490     0.200
   146.658     1.546     0.200
   153.006     6.830     0.200
   148.016     3.108     0.200
   154.187     7.369     0.200
   147.913     2.900     0.200
   148.179     3.077     0.200
   147.396     2.720     0.200
   147.449     2.517     0.200
   154.203     7.066     0.200
   148.032     3.149     0.200
   148.073     3.612     0.200
   150.856     4.120     0.200
   152.403     6.142     0.200
   145.169    -1.602     0.200
   150.415     4.936     0.200
   153.007     6.407     0.200
   147.225     2.431     0.200
   149.424     4.224     0.200
   149.853     3.542     0.200
   153.501     6.946     0.200
   152.995     6.409     0.200
   153.120     6.214     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   145.835     1.394     0.200
   146.350     1.815     0.200
   148.939     7.527     0.200
   146.484     1.814     0.200
   147.311     3.600     0.200
   145.637     1.062     0.200
   147.863     5.934     0.200
   146.084     1.970     0.200
   147.839     5.213     0.200
   146.459     1.861     0.200
   151.607    16.278     0.200
   146.081     1.226     0.200
   146.081     1.351     0.200
   147.175     2.715     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   138.216     1.709     0.200
   147.124     7.278     0.200
   149.848     6.938     0.200
   150.552     6.320     0.200
   149.948     6.915     0.200
   150.210     6.802     0.200
   137.538     4.395     0.200
   137.707     4.185     0.200
   147.775     3.924     0.200
   151.230     8.315     0.200
   148.274     4.387     0.200
   148.646     4.780     0.200
   148.916     5.740     0.200
   145.999     2.613     0.200
   150.001     6.129     0.200
   151.414     6.745     0.200
   151.719     7.183     0.200
   151.721     7.281     0.200
   153.362     8.759     0.200
   153.474     8.598     0.200
   153.716     7.751     0.200
   153.734     8.725     0.200
   154.124     8.674     0.200
   135.347     1.047     0.200
   143.602     5.035     0.200
   149.046     5.230     0.200
   146.599     6.420     0.200
   149.320     5.941     0.200
   152.489     7.777     0.200
   147.841     3.581     0.200
   152.548     9.298     0.200
   150.002     6.697     0.200
   149.984     4.906     0.200
   153.581     7.703     0.200
   153.035     7.056     0.200
   153.520     7.520     0.200
   148.297     4.599     0.200
   148.063     3.735     0.200
   148.102     4.450     0.200
   148.479     4.047     0.200
   151.554     7.299     0.200
   148.001     4.516     0.200
   152.778     6.943     0.200
   140.126     1.719     0.200
   147.933     3.810     0.200
   148.179     3.952     0.200
   151.607     7.638     0.200
   137.857     2.966     0.200
   150.895     7.259     0.200
   135.541     0.949     0.200
   137.326     1.593     0.200
   150.214     7.529     0.200
   151.838     7.643     0.200
   152.743     8.788     0.200
   141.817     1.661     0.200
   153.038     7.009     0.200
   148.319     3.958     0.200
   148.319     4.478     0.200
   150.915     7.119     0.200
   151.249     7.107     0.200
   153.636     8.436     0.200
   150.761     6.670     0.200
   151.191     6.766     0.200
   153.174     7.474     0.200
   150.624     5.841     0.200
   150.981     6.688     0.200
   151.846     6.417     0.200
   151.926     7.266     0.200
   152.422     7.276     0.200
   153.448     8.249     0.200
   151.882     6.414     0.200
   147.684     3.812     0.200
   153.720     8.575     0.200
   147.005     3.810     0.200
   154.041     9.422     0.200
   154.041     7.642     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
