#!/bin/bash
gmt begin chamoli16.22_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P chamoli16.22'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.708
    79.000     8.533
    80.000     7.442
    81.000     6.438
    82.000     5.519
    83.000     4.684
    84.000     3.933
    85.000     3.270
    86.000     2.692
    87.000     2.193
    88.000     1.797
    89.000     1.497
    90.000     1.239
    91.000     1.013
    92.000     0.812
    93.000     0.630
    94.000     0.464
    95.000     0.319
    96.000     0.199
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    20.120    -0.503     0.200
    20.428    -0.844     0.200
    21.855    -0.236     0.200
    23.664    -1.155     0.200
    24.242    -0.438     0.200
    25.278     1.130     0.200
    29.483     1.404     0.200
    29.681    -1.352     0.200
    30.253    -0.407     0.200
    31.000     1.999     0.200
    31.117    -0.039     0.200
    31.958     1.561     0.200
    37.832     0.887     0.200
    38.698     2.098     0.200
    39.184    -0.474     0.200
    39.683     0.357     0.200
    39.905     0.512     0.200
    42.720     1.393     0.200
    42.793     0.799     0.200
    43.053     0.692     0.200
    43.735    -0.811     0.200
    44.160     2.879     0.200
    44.774    -0.129     0.200
    45.132    -1.975     0.200
    45.795    -1.229     0.200
    46.288     0.986     0.200
    46.430    -0.231     0.200
    46.714    -0.458     0.200
    47.127     0.317     0.200
    47.523     0.233     0.200
    47.704    -0.177     0.200
    48.112    -0.835     0.200
    48.468    -1.083     0.200
    48.817     0.531     0.200
    48.985    -0.255     0.200
    49.128    -0.149     0.200
    49.163    -1.421     0.200
    49.730     2.252     0.200
    49.790    -0.005     0.200
    50.195     1.418     0.200
    50.320    -0.229     0.200
    50.477    -0.212     0.200
    50.988     0.735     0.200
    51.039    -0.848     0.200
    51.389    -0.578     0.200
    51.555     0.480     0.200
    51.838    -0.231     0.200
    51.936     0.637     0.200
    52.626     0.611     0.200
    53.252    -0.106     0.200
    53.431     2.276     0.200
    53.454     0.508     0.200
    53.495     0.105     0.200
    53.611    -2.749     0.200
    53.847    -0.771     0.200
    53.945    -0.591     0.200
    54.094    -0.275     0.200
    54.262     0.499     0.200
    54.373     0.688     0.200
    54.380     0.634     0.200
    55.083    -0.362     0.200
    56.163     0.983     0.200
    56.639     1.693     0.200
    57.201     0.410     0.200
    58.203    -3.640     0.200
    58.429    -0.221     0.200
    58.454     0.507     0.200
    58.456     2.592     0.200
    58.545     0.969     0.200
    58.907     0.451     0.200
    60.474    -1.039     0.200
    61.606    -1.020     0.200
    61.671     0.541     0.200
    62.239    -0.580     0.200
    62.437    -0.605     0.200
    62.466     0.099     0.200
    62.772    -0.943     0.200
    63.096     0.004     0.200
    64.214    -0.373     0.200
    66.133     1.173     0.200
    66.334    -1.120     0.200
    66.507     1.675     0.200
    66.774     0.071     0.200
    67.602    -0.185     0.200
    68.246     1.766     0.200
    70.315    -1.550     0.200
    72.571    -1.167     0.200
    73.321    -2.108     0.200
    75.032    -0.093     0.200
    78.350    -0.239     0.200
    78.289    -0.498     0.200
    80.217    -0.032     0.200
    80.502    -0.663     0.200
    84.734    -0.596     0.200
    87.106    -1.343     0.200
    88.193     0.952     0.200
    89.585    -0.498     0.200
    90.596    -0.418     0.200
    91.497     0.300     0.200
    96.300    -0.060     0.200
    99.000    -1.224     0.200
    19.690    -2.248     0.200
    19.716    -0.531     0.200
    20.567     1.210     0.200
    20.629    -0.462     0.200
    22.260     1.000     0.200
    24.616    -0.362     0.200
    27.414     2.313     0.200
    29.718     0.799     0.200
    29.727     0.721     0.200
    29.888     1.297     0.200
    30.745     0.721     0.200
    30.566     0.295     0.200
    31.402     1.925     0.200
    31.561    -0.174     0.200
    31.403     0.913     0.200
    32.362     2.486     0.200
    35.417    -0.063     0.200
    36.210     2.931     0.200
    36.202     0.200     0.200
    38.666     2.023     0.200
    38.824     1.394     0.200
    39.089     0.771     0.200
    39.598     0.528     0.200
    39.585     2.628     0.200
    40.053     0.739     0.200
    40.310     0.612     0.200
    41.693     2.213     0.200
    42.527     1.405     0.200
    43.198     1.675     0.200
    43.452     0.913     0.200
    44.139     0.395     0.200
    44.322     0.923     0.200
    45.133    -0.541     0.200
    45.124    -0.470     0.200
    45.957     1.631     0.200
    46.824     0.118     0.200
    47.031    -0.503     0.200
    47.530     0.610     0.200
    47.726     0.087     0.200
    47.868    -1.011     0.200
    47.919     0.591     0.200
    48.063    -0.523     0.200
    48.745    -0.281     0.200
    49.127     0.892     0.200
    49.223     0.847     0.200
    49.239    -1.569     0.200
    49.310    -0.407     0.200
    49.438    -1.291     0.200
    49.438    -1.291     0.200
    49.474     1.637     0.200
    49.659     1.124     0.200
    50.084     2.995     0.200
    50.128     1.654     0.200
    50.102     0.754     0.200
    50.245     2.768     0.200
    50.598     2.099     0.200
    50.823     0.106     0.200
    51.385     1.180     0.200
    51.403    -0.156     0.200
    51.716    -0.395     0.200
    51.779     0.234     0.200
    51.876     0.008     0.200
    52.150     0.571     0.200
    52.215    -1.017     0.200
    52.717    -0.341     0.200
    52.955     0.502     0.200
    53.020     2.026     0.200
    53.325    -0.224     0.200
    53.437    -3.043     0.200
    53.647    -0.189     0.200
    53.845    -0.034     0.200
    53.896    -0.408     0.200
    53.864     1.822     0.200
    53.991     0.898     0.200
    54.219    -0.873     0.200
    54.295     0.381     0.200
    54.665    -1.014     0.200
    54.757     3.323     0.200
    54.820    -0.134     0.200
    55.397     1.695     0.200
    55.449     0.218     0.200
    55.785     1.908     0.200
    56.558    -0.416     0.200
    57.033     2.007     0.200
    57.523     1.547     0.200
    57.531     1.494     0.200
    57.563     1.163     0.200
    58.713    -0.490     0.200
    59.015     0.315     0.200
    58.829     0.111     0.200
    58.855     0.122     0.200
    58.943    -0.383     0.200
    59.318    -0.981     0.200
    59.630    -0.638     0.200
    59.679    -1.474     0.200
    60.356    -1.624     0.200
    60.637    -1.147     0.200
    60.871    -0.931     0.200
    61.210     2.563     0.200
    61.857    -0.608     0.200
    62.633    -0.711     0.200
    62.827    -0.506     0.200
    62.814    -0.717     0.200
    62.843    -0.209     0.200
    63.166    -0.658     0.200
    63.811    -2.321     0.200
    63.984    -0.963     0.200
    66.560    -2.168     0.200
    66.960    -2.716     0.200
    66.856    -0.056     0.200
    66.966    -1.254     0.200
    67.836    -1.261     0.200
    69.963    -1.497     0.200
    70.758     0.641     0.200
    71.359    -1.506     0.200
    71.217     0.849     0.200
    71.525    -3.007     0.200
    71.497    -1.443     0.200
    73.486    -0.993     0.200
    74.632     1.205     0.200
    74.820    -1.984     0.200
    75.968     2.218     0.200
    75.780    -0.208     0.200
    75.844    -0.076     0.200
    76.897    -0.347     0.200
    77.811     1.535     0.200
    78.590     0.214     0.200
    78.359    -1.509     0.200
    80.097    -1.309     0.200
    81.971    -1.995     0.200
    83.717    -2.061     0.200
    84.346    -0.270     0.200
    85.276     1.049     0.200
    86.207    -1.576     0.200
    87.258    -1.716     0.200
    89.181     0.357     0.200
    89.595     2.214     0.200
    90.206     0.361     0.200
    91.101     0.196     0.200
    91.289    -0.678     0.200
    91.683     0.497     0.200
    93.330     2.891     0.200
    93.691     0.834     0.200
    93.354    -0.220     0.200
    94.568    -3.198     0.200
    95.393     1.429     0.200
    96.453    -0.399     0.200
    96.442    -1.348     0.200
    20.289    -0.073     0.200
    23.145    -0.640     0.200
    28.479    -0.278     0.200
    29.319     1.264     0.200
    36.229    -0.068     0.200
    38.579     1.016     0.200
    43.289     1.233     0.200
    45.151    -0.683     0.200
    46.340     0.934     0.200
    46.366     0.026     0.200
    46.630    -0.247     0.200
    47.441     0.330     0.200
    47.649     1.707     0.200
    48.011    -0.097     0.200
    48.855    -0.594     0.200
    49.803     0.165     0.200
    49.949    -0.447     0.200
    50.410    -0.540     0.200
    51.386     0.215     0.200
    52.072     0.097     0.200
    52.287     0.501     0.200
    53.210    -0.321     0.200
    53.380    -0.573     0.200
    53.689     1.160     0.200
    53.989    -0.229     0.200
    57.757     0.980     0.200
    60.574    -2.517     0.200
    65.312    -1.017     0.200
    66.246    -0.031     0.200
    67.100     1.518     0.200
    69.611     0.306     0.200
    70.079    -1.072     0.200
    72.953    -0.396     0.200
    72.815    -1.578     0.200
    76.218     0.663     0.200
    78.064    -0.699     0.200
    79.690    -0.626     0.200
    80.194    -0.550     0.200
    81.704     0.397     0.200
    81.968     0.512     0.200
    20.603    -0.434     0.200
    21.374     1.240     0.200
    29.915    -0.209     0.200
    38.711    -0.323     0.200
    39.265    -0.962     0.200
    43.965     1.013     0.200
    44.348    -0.860     0.200
    45.143     0.106     0.200
    47.009    -0.099     0.200
    47.301     0.123     0.200
    48.078    -0.012     0.200
    48.367     0.853     0.200
    48.483     0.457     0.200
    48.621    -0.104     0.200
    48.630    -0.169     0.200
    49.128    -0.998     0.200
    49.453     0.522     0.200
    50.091    -0.140     0.200
    50.627    -0.697     0.200
    51.032    -0.042     0.200
    51.335     1.283     0.200
    52.054    -0.089     0.200
    52.454    -0.067     0.200
    52.790     0.443     0.200
    53.001    -0.109     0.200
    53.925     0.101     0.200
    54.053    -0.837     0.200
    54.270     0.585     0.200
    54.409     0.571     0.200
    54.670     0.577     0.200
    56.434    -0.109     0.200
    57.960    -0.403     0.200
    58.452     1.253     0.200
    59.495    -0.990     0.200
    59.776    -0.924     0.200
    60.011    -0.838     0.200
    61.348    -0.353     0.200
    61.781    -0.480     0.200
    61.977    -1.094     0.200
    62.006    -0.494     0.200
    62.035    -0.790     0.200
    62.314    -0.660     0.200
    63.540     1.383     0.200
    65.985    -1.765     0.200
    66.110    -1.568     0.200
    70.285    -0.757     0.200
    70.329    -0.028     0.200
    71.361    -0.707     0.200
    72.231    -1.035     0.200
    73.162    -1.376     0.200
    73.173    -2.140     0.200
    75.380    -1.003     0.200
    78.236    -0.517     0.200
    78.259    -0.845     0.200
    78.285    -0.588     0.200
    78.523     1.293     0.200
    78.743    -0.718     0.200
    79.857     0.699     0.200
    79.882    -0.940     0.200
    80.356    -0.898     0.200
    80.985    -0.164     0.200
    80.736    -0.333     0.200
    82.030    -0.197     0.200
    82.582    -0.087     0.200
    83.160    -2.484     0.200
    85.804    -1.873     0.200
    86.975    -2.634     0.200
    90.675    -1.118     0.200
    94.754     0.057     0.200
    18.869    -1.624     0.200
    20.312     0.113     0.200
    23.254    -0.690     0.200
    28.212     0.887     0.200
    28.374     0.442     0.200
    29.886     1.022     0.200
    32.296     2.777     0.200
    36.760     2.163     0.200
    37.461     2.211     0.200
    37.644     1.658     0.200
    38.081     0.965     0.200
    38.071    -0.947     0.200
    38.268     1.396     0.200
    38.636     1.295     0.200
    40.084     1.012     0.200
    41.281     0.326     0.200
    41.633     0.436     0.200
    41.944    -0.102     0.200
    42.635    -1.733     0.200
    43.001     1.294     0.200
    43.754     1.223     0.200
    43.752     0.233     0.200
    43.884     0.176     0.200
    44.504     1.208     0.200
    44.662     0.349     0.200
    45.084    -0.412     0.200
    45.329     0.640     0.200
    45.794    -0.043     0.200
    45.937    -0.170     0.200
    46.408    -0.276     0.200
    46.682     0.077     0.200
    47.481    -1.260     0.200
    47.725     0.940     0.200
    48.003    -1.308     0.200
    47.979     0.871     0.200
    48.046    -0.244     0.200
    48.724    -0.869     0.200
    48.884     0.201     0.200
    49.484    -0.295     0.200
    49.881    -0.216     0.200
    50.003    -1.246     0.200
    50.401     0.143     0.200
    50.446    -0.297     0.200
    50.877     0.747     0.200
    51.461     0.064     0.200
    51.477    -0.157     0.200
    51.526     0.877     0.200
    51.814    -0.273     0.200
    52.148    -0.765     0.200
    52.323     0.939     0.200
    52.359    -0.330     0.200
    52.542     0.917     0.200
    53.283    -0.159     0.200
    53.628     1.412     0.200
    53.767     1.291     0.200
    53.880     0.466     0.200
    55.060    -0.110     0.200
    55.536     1.453     0.200
    55.707     0.228     0.200
    55.918    -0.086     0.200
    56.024    -0.046     0.200
    56.045     1.802     0.200
    56.168    -0.076     0.200
    56.323     0.820     0.200
    57.202    -1.123     0.200
    57.810     0.891     0.200
    58.163     0.216     0.200
    58.853    -0.897     0.200
    59.134    -0.644     0.200
    60.667    -1.479     0.200
    60.852    -0.437     0.200
    61.139    -0.689     0.200
    61.335    -1.013     0.200
    61.672    -0.792     0.200
    62.773    -1.671     0.200
    62.904     1.061     0.200
    65.328    -0.457     0.200
    65.229     0.180     0.200
    65.648    -1.529     0.200
    65.946     0.550     0.200
    66.344    -2.006     0.200
    68.774    -1.157     0.200
    69.704     0.881     0.200
    70.173    -1.003     0.200
    70.840    -0.076     0.200
    71.537    -0.295     0.200
    72.871     0.228     0.200
    72.783    -1.248     0.200
    72.794    -1.813     0.200
    77.991    -0.272     0.200
    78.016    -0.812     0.200
    78.041    -0.748     0.200
    78.432    -1.116     0.200
    79.771     0.056     0.200
    79.642    -1.046     0.200
    79.682     0.036     0.200
    80.512    -0.345     0.200
    81.302    -1.661     0.200
    81.613     0.091     0.200
    82.078     0.243     0.200
    82.636    -1.673     0.200
    85.367    -1.602     0.200
    86.612    -1.758     0.200
    91.691     0.275     0.200
    18.262     0.001     0.200
    19.837     0.389     0.200
    20.358    -0.678     0.200
    20.445     0.478     0.200
    20.442    -0.493     0.200
    20.590    -0.091     0.200
    21.279     0.458     0.200
    21.641     1.567     0.200
    21.713    -0.205     0.200
    23.450    -1.639     0.200
    24.110    -0.277     0.200
    24.528    -0.587     0.200
    24.699     0.653     0.200
    24.885    -0.842     0.200
    25.459    -2.051     0.200
    26.310     2.233     0.200
    26.501     1.507     0.200
    26.651     1.260     0.200
    26.867     2.207     0.200
    27.803     0.210     0.200
    28.351    -1.078     0.200
    28.354     1.097     0.200
    29.172     0.619     0.200
    29.183     0.522     0.200
    29.341    -0.275     0.200
    29.341    -1.080     0.200
    29.539     0.366     0.200
    29.662    -0.226     0.200
    30.142     0.024     0.200
    30.517     1.714     0.200
    30.523     0.454     0.200
    30.823     2.012     0.200
    30.855     1.728     0.200
    31.407     2.861     0.200
    31.816     1.766     0.200
    31.816     1.664     0.200
    32.400    -2.064     0.200
    32.954     0.289     0.200
    33.537     0.399     0.200
    34.501     1.825     0.200
    34.872     0.115     0.200
    34.872     0.013     0.200
    35.057     1.023     0.200
    35.385     0.202     0.200
    35.842    -0.625     0.200
    36.211     0.113     0.200
    38.137    -0.244     0.200
    39.051     1.185     0.200
    39.186    -0.051     0.200
    39.553    -0.114     0.200
    39.694    -1.285     0.200
    39.883     0.145     0.200
    41.333     1.758     0.200
    41.626    -1.349     0.200
    41.677    -0.263     0.200
    41.887    -0.882     0.200
    42.186     0.181     0.200
    42.236    -0.025     0.200
    42.581    -0.238     0.200
    42.602     0.087     0.200
    42.913     0.270     0.200
    43.075    -0.246     0.200
    43.285     0.260     0.200
    43.417    -1.308     0.200
    43.489    -1.386     0.200
    43.542    -0.024     0.200
    43.557    -0.434     0.200
    43.784    -0.468     0.200
    43.783    -0.754     0.200
    43.960    -0.885     0.200
    43.972     1.721     0.200
    44.083    -0.164     0.200
    44.160    -0.578     0.200
    44.194     1.946     0.200
    44.296     3.123     0.200
    44.410     2.211     0.200
    44.648     0.315     0.200
    44.725     0.695     0.200
    44.756    -0.348     0.200
    44.837     0.804     0.200
    44.837     1.202     0.200
    45.135    -0.165     0.200
    45.314     1.010     0.200
    45.475    -0.265     0.200
    45.760     0.378     0.200
    46.309     0.155     0.200
    46.602    -0.351     0.200
    46.724     2.100     0.200
    46.794     2.349     0.200
    46.968     0.988     0.200
    46.984    -0.639     0.200
    47.304     0.162     0.200
    47.383     2.253     0.200
    47.383     2.152     0.200
    47.472    -0.942     0.200
    47.578     0.238     0.200
    47.820     0.358     0.200
    48.077    -0.233     0.200
    48.173     0.621     0.200
    48.198    -0.865     0.200
    48.253    -0.693     0.200
    48.331     0.404     0.200
    48.686    -0.727     0.200
    48.689     1.647     0.200
    48.726    -2.640     0.200
    48.739     1.264     0.200
    48.891    -1.606     0.200
    48.870    -0.043     0.200
    48.870     0.253     0.200
    48.941    -0.289     0.200
    49.025    -1.230     0.200
    49.079    -0.246     0.200
    49.136    -1.389     0.200
    49.218    -0.612     0.200
    49.229    -0.601     0.200
    49.494    -1.317     0.200
    49.587    -2.229     0.200
    49.589    -0.248     0.200
    49.682    -0.658     0.200
    49.680     0.061     0.200
    49.768    -1.407     0.200
    49.887    -1.310     0.200
    50.355    -0.662     0.200
    50.376    -1.120     0.200
    50.910    -0.552     0.200
    51.245    -0.472     0.200
    51.274    -0.784     0.200
    51.339     0.524     0.200
    51.367     0.315     0.200
    51.476     0.497     0.200
    51.551    -0.060     0.200
    51.857     1.856     0.200
    51.795     0.014     0.200
    52.252     0.208     0.200
    52.287    -0.151     0.200
    52.423     0.444     0.200
    52.487    -0.036     0.200
    52.751     0.409     0.200
    52.773    -0.148     0.200
    52.784    -0.130     0.200
    52.843    -0.667     0.200
    52.903    -0.511     0.200
    53.112    -0.155     0.200
    53.112    -0.257     0.200
    53.129     0.426     0.200
    53.194    -0.361     0.200
    53.289     0.047     0.200
    53.316    -0.757     0.200
    53.354    -0.731     0.200
    53.464     0.152     0.200
    53.478     0.656     0.200
    53.569    -0.013     0.200
    53.647    -1.381     0.200
    53.691    -1.910     0.200
    53.920    -0.085     0.200
    54.093    -0.845     0.200
    54.106     0.057     0.200
    54.120    -0.041     0.200
    54.141    -2.995     0.200
    54.169    -0.902     0.200
    54.242     0.064     0.200
    54.590     0.834     0.200
    54.730    -1.481     0.200
    54.733     0.200     0.200
    54.784    -1.472     0.200
    54.965    -0.685     0.200
    54.954    -0.904     0.200
    55.418     1.545     0.200
    55.514     0.655     0.200
    55.597    -0.344     0.200
    56.024     0.099     0.200
    56.309     1.663     0.200
    56.303    -0.197     0.200
    56.336     0.670     0.200
    56.571    -2.707     0.200
    56.617    -0.434     0.200
    56.712    -0.706     0.200
    56.757    -1.733     0.200
    56.877    -0.083     0.200
    57.069    -0.239     0.200
    57.084     0.153     0.200
    57.287    -0.581     0.200
    57.338    -0.441     0.200
    57.367    -1.146     0.200
    57.449    -0.725     0.200
    57.625    -0.365     0.200
    57.701    -0.702     0.200
    57.760    -0.112     0.200
    57.761     0.174     0.200
    57.920    -0.037     0.200
    57.854     1.226     0.200
    57.972    -1.807     0.200
    58.021    -0.247     0.200
    58.066    -2.265     0.200
    58.105    -1.241     0.200
    58.699    -0.386     0.200
    58.769    -0.273     0.200
    58.789     0.687     0.200
    58.885    -0.680     0.200
    58.963    -0.117     0.200
    59.821     0.549     0.200
    59.803    -0.624     0.200
    59.808    -0.361     0.200
    59.812    -0.388     0.200
    59.819    -0.835     0.200
    59.971    -0.375     0.200
    60.100    -0.468     0.200
    60.265    -0.492     0.200
    60.917    -0.044     0.200
    61.151     0.174     0.200
    61.596     0.257     0.200
    61.747    -0.461     0.200
    61.839    -0.976     0.200
    61.871     0.207     0.200
    61.926    -0.161     0.200
    61.952     0.458     0.200
    61.952     0.559     0.200
    62.101    -0.640     0.200
    62.125    -0.201     0.200
    62.140     0.595     0.200
    62.263     0.078     0.200
    62.287     0.714     0.200
    62.295    -0.845     0.200
    62.304    -0.303     0.200
    62.334    -0.499     0.200
    62.498     0.296     0.200
    62.634    -0.709     0.200
    62.643    -0.466     0.200
    62.753     0.702     0.200
    62.809    -0.573     0.200
    62.846    -0.623     0.200
    63.044    -1.240     0.200
    63.070    -1.807     0.200
    63.318    -1.256     0.200
    63.517    -2.374     0.200
    63.875     0.162     0.200
    64.600    -0.694     0.200
    64.606    -0.424     0.200
    64.784    -0.394     0.200
    65.181    -0.974     0.200
    65.156    -0.209     0.200
    65.389    -2.619     0.200
    66.113    -1.294     0.200
    66.024     0.284     0.200
    66.329    -0.675     0.200
    66.390     0.833     0.200
    67.157    -2.461     0.200
    67.318     0.221     0.200
    67.506    -0.166     0.200
    67.460     0.119     0.200
    68.882    -1.802     0.200
    69.100    -1.158     0.200
    70.169     1.752     0.200
    70.466    -0.769     0.200
    70.445     0.458     0.200
    70.671     0.184     0.200
    70.763     1.622     0.200
    71.334     1.363     0.200
    71.900    -0.754     0.200
    71.908    -0.798     0.200
    72.505    -0.269     0.200
    72.844     0.615     0.200
    73.387     1.401     0.200
    73.515     0.645     0.200
    74.137    -1.203     0.200
    74.505     0.860     0.200
    74.644    -0.845     0.200
    75.173     0.697     0.200
    75.462    -1.168     0.200
    75.704     0.447     0.200
    75.718    -0.636     0.200
    75.924    -0.513     0.200
    77.126    -0.219     0.200
    78.254    -0.616     0.200
    78.264    -0.668     0.200
    78.264    -1.168     0.200
    78.902    -1.277     0.200
    78.893     0.568     0.200
    79.781    -0.382     0.200
    80.345    -1.828     0.200
    80.644    -0.435     0.200
    82.599     0.341     0.200
    83.353    -1.872     0.200
    84.870    -0.794     0.200
    84.809    -0.186     0.200
    85.473     0.386     0.200
    85.803    -0.551     0.200
    85.982    -0.336     0.200
    87.024    -0.760     0.200
    88.167    -0.041     0.200
    89.062     1.941     0.200
    89.727    -1.778     0.200
    90.612    -1.303     0.200
    90.734    -0.574     0.200
    90.884     0.229     0.200
    91.427    -2.288     0.200
    91.637    -0.560     0.200
    92.073     0.115     0.200
    95.573    -1.167     0.200
    96.250    -0.948     0.200
    96.759    -0.759     0.200
    99.032    -0.985     0.200
    99.300    -1.179     0.200
    15.018     4.750     0.200
    19.926     0.314     0.200
    19.926     0.014     0.200
    20.174    -0.891     0.200
    20.131     0.573     0.200
    20.176    -1.912     0.200
    20.528    -0.734     0.200
    20.943    -0.419     0.200
    23.152    -1.298     0.200
    23.736    -1.004     0.200
    23.873    -1.150     0.200
    24.298    -0.730     0.200
    24.363     0.677     0.200
    25.034    -1.435     0.200
    26.505     1.234     0.200
    26.629     1.415     0.200
    28.345     0.740     0.200
    28.345     1.541     0.200
    30.407    -0.546     0.200
    30.648     1.323     0.200
    30.796    -0.180     0.200
    31.743    -0.128     0.200
    32.153     1.074     0.200
    32.092    -0.888     0.200
    34.808    -1.054     0.200
    35.535     2.279     0.200
    36.210    -0.106     0.200
    36.210     0.494     0.200
    37.356     1.141     0.200
    37.989     0.190     0.200
    39.388     0.048     0.200
    39.840    -1.019     0.200
    40.195     0.331     0.200
    40.579     1.660     0.200
    44.631     3.239     0.200
    44.949    -0.293     0.200
    45.172     2.930     0.200
    45.133    -0.254     0.200
    47.404    -0.611     0.200
    47.590    -0.563     0.200
    47.714     1.974     0.200
    47.781     0.160     0.200
    47.879    -0.003     0.200
    49.019     1.411     0.200
    49.144    -0.345     0.200
    49.144    -0.044     0.200
    49.204    -1.505     0.200
    49.270    -1.010     0.200
    49.943    -0.039     0.200
    50.646    -0.558     0.200
    51.216    -0.048     0.200
    51.549    -0.544     0.200
    51.578     0.545     0.200
    51.592     0.133     0.200
    51.667    -0.123     0.200
    51.667     0.377     0.200
    52.817     0.335     0.200
    53.079     0.098     0.200
    53.118    -0.708     0.200
    53.209    -0.456     0.200
    53.414    -0.418     0.200
    53.443     0.222     0.200
    53.643    -0.747     0.200
    54.472    -0.696     0.200
    54.570    -0.011     0.200
    54.919     0.961     0.200
    55.411    -0.786     0.200
    55.586    -0.847     0.200
    55.586     0.053     0.200
    58.091    -0.220     0.200
    58.353    -0.449     0.200
    59.097     0.772     0.200
    59.298    -0.321     0.200
    59.666    -0.258     0.200
    60.135    -0.984     0.200
    60.151    -0.092     0.200
    60.303    -0.432     0.200
    60.432    -0.617     0.200
    60.597    -0.638     0.200
    61.250    -0.074     0.200
    61.483    -0.154     0.200
    61.930    -0.264     0.200
    61.950    -0.697     0.200
    62.204    -0.109     0.200
    62.596    -0.331     0.200
    62.832    -0.301     0.200
    63.713    -0.836     0.200
    66.447    -1.602     0.200
    66.555    -0.793     0.200
    71.566    -0.601     0.200
    71.574    -1.152     0.200
    73.405    -0.360     0.200
    74.841     0.258     0.200
    75.372     0.193     0.200
    75.701    -0.891     0.200
    78.328    -1.467     0.200
    78.891    -1.370     0.200
    80.307     1.030     0.200
    83.584    -1.497     0.200
    87.156    -1.032     0.200
    87.184    -1.472     0.200
    18.432    -2.342     0.200
    18.769    -0.852     0.200
    19.051     0.852     0.200
    20.030    -1.350     0.200
    20.030     0.451     0.200
    20.032     0.336     0.200
    20.232     0.155     0.200
    20.252     0.940     0.200
    20.252     1.140     0.200
    20.482    -1.562     0.200
    20.482    -0.664     0.200
    21.047    -0.170     0.200
    21.246    -0.221     0.200
    21.552    -0.908     0.200
    22.889     1.942     0.200
    23.706    -0.980     0.200
    23.865     0.366     0.200
    24.320    -0.285     0.200
    24.375    -0.792     0.200
    24.756     0.936     0.200
    24.995    -0.738     0.200
    26.208     0.563     0.200
    26.512     0.814     0.200
    26.512     1.213     0.200
    26.644     1.124     0.200
    27.405     1.781     0.200
    27.510     0.039     0.200
    30.710     0.422     0.200
    30.716    -0.635     0.200
    30.716     0.064     0.200
    31.155    -0.308     0.200
    34.891     0.266     0.200
    36.219    -0.541     0.200
    36.219     0.158     0.200
    36.347     1.167     0.200
    36.483     0.002     0.200
    37.378     0.587     0.200
    38.042    -0.426     0.200
    39.770     2.496     0.200
    39.802    -0.968     0.200
    41.082    -1.354     0.200
    42.465     0.222     0.200
    44.528     2.193     0.200
    44.859     0.053     0.200
    45.069     1.382     0.200
    45.142    -1.196     0.200
    45.142    -0.895     0.200
    47.506     0.222     0.200
    47.613     2.391     0.200
    47.613     2.891     0.200
    47.694    -0.039     0.200
    47.789    -0.177     0.200
    48.052     1.590     0.200
    48.918     1.314     0.200
    49.055     0.263     0.200
    49.064    -0.104     0.200
    49.867    -0.130     0.200
    50.296    -1.190     0.200
    50.296    -0.990     0.200
    50.560    -0.282     0.200
    51.125    -0.537     0.200
    51.469     0.286     0.200
    51.492    -1.193     0.200
    52.652    -0.120     0.200
    52.652    -0.018     0.200
    52.979     0.158     0.200
    53.027    -0.704     0.200
    53.117    -0.458     0.200
    53.323    -0.354     0.200
    53.629     0.979     0.200
    54.381    -0.515     0.200
    54.470     0.838     0.200
    54.770    -0.338     0.200
    55.847     0.904     0.200
    55.935    -0.329     0.200
    56.066    -0.666     0.200
    56.899    -0.998     0.200
    56.961     2.963     0.200
    57.310     0.990     0.200
    57.531    -0.068     0.200
    57.906     0.602     0.200
    57.990    -0.488     0.200
    58.233     0.107     0.200
    58.251    -0.422     0.200
    58.967    -0.711     0.200
    60.034    -0.969     0.200
    60.050    -0.179     0.200
    60.201    -0.515     0.200
    60.331    -0.702     0.200
    60.495    -0.825     0.200
    61.148    -0.266     0.200
    61.381    -0.250     0.200
    61.827    -0.156     0.200
    61.848    -0.694     0.200
    62.102     0.195     0.200
    62.730    -0.100     0.200
    63.239    -1.288     0.200
    66.553    -0.665     0.200
    70.544    -0.591     0.200
    71.442    -0.842     0.200
    71.669    -0.211     0.200
    71.677    -1.262     0.200
    73.368    -1.536     0.200
    73.899    -0.651     0.200
    75.767    -0.658     0.200
    77.161     0.143     0.200
    78.316    -0.798     0.200
    78.316    -0.697     0.200
    78.867    -1.835     0.200
    80.412     1.771     0.200
    80.387    -2.196     0.200
    82.802     0.341     0.200
    83.518    -1.558     0.200
    87.123    -1.272     0.200
    87.137    -1.944     0.200
    87.151    -1.711     0.200
    96.343    -1.304     0.200
    45.886     0.365     0.200
    46.038    -0.829     0.200
    48.373    -0.037     0.200
    49.908    -0.395     0.200
    51.308    -0.765     0.200
    51.391    -0.388     0.200
    51.603    -0.472     0.200
    51.820    -0.821     0.200
    52.847    -1.216     0.200
    73.544    -0.855     0.200
    78.254    -1.042     0.200
    86.344    -0.363     0.200
    20.401     0.499     0.200
    21.410    -0.694     0.200
    24.720    -0.571     0.200
    26.495     1.741     0.200
    48.839    -0.256     0.200
    54.106    -0.875     0.200
    72.028    -0.697     0.200
    73.328    -1.222     0.200
    78.722    -1.354     0.200
    19.094    -0.541     0.200
    21.160     0.179     0.200
    43.720     1.734     0.200
    46.550     0.340     0.200
    46.606    -0.196     0.200
    51.831    -0.579     0.200
    51.915    -0.306     0.200
    52.126    -0.477     0.200
    52.343    -0.794     0.200
    53.191    -0.864     0.200
    72.865    -1.057     0.200
    78.137    -1.312     0.200
    78.484    -1.435     0.200
    14.163     6.530     0.200
    16.294     3.318     0.200
    19.368    -1.359     0.200
    19.596    -0.054     0.200
    20.451    -0.257     0.200
    22.040     0.423     0.200
    22.043     0.095     0.200
    22.511    -0.588     0.200
    22.567    -0.974     0.200
    22.943    -0.961     0.200
    23.083     0.566     0.200
    23.523    -1.023     0.200
    23.641    -0.105     0.200
    24.867     0.216     0.200
    24.898     0.433     0.200
    25.362    -0.083     0.200
    25.471    -2.780     0.200
    25.481     0.128     0.200
    26.149    -0.920     0.200
    26.620     0.221     0.200
    26.940     0.943     0.200
    26.937     0.368     0.200
    27.051     1.447     0.200
    27.093     1.366     0.200
    27.196     0.640     0.200
    27.485     0.046     0.200
    28.284     0.905     0.200
    28.424    -0.342     0.200
    28.443     0.489     0.200
    28.494     1.840     0.200
    28.552     0.526     0.200
    28.614     2.972     0.200
    28.653     2.628     0.200
    28.682     0.868     0.200
    28.765     0.331     0.200
    29.029    -0.419     0.200
    29.159     2.126     0.200
    29.383     0.640     0.200
    29.571     3.276     0.200
    30.352    -0.036     0.200
    31.106    -0.383     0.200
    31.108    -0.109     0.200
    31.816    -0.340     0.200
    32.085     1.297     0.200
    32.328    -0.834     0.200
    32.635     2.476     0.200
    32.783    -0.119     0.200
    32.880    -0.073     0.200
    33.335    -0.044     0.200
    33.584    -1.816     0.200
    34.187    -0.849     0.200
    34.452    -1.353     0.200
    34.454    -0.371     0.200
    34.647    -0.042     0.200
    35.673     2.128     0.200
    36.178    -0.706     0.200
    36.276    -0.141     0.200
    36.327    -0.377     0.200
    36.779    -0.328     0.200
    36.803     1.467     0.200
    36.810    -0.598     0.200
    37.036     0.479     0.200
    37.518    -0.004     0.200
    37.513     0.440     0.200
    37.559     1.042     0.200
    37.639     1.075     0.200
    37.773    -0.059     0.200
    37.821    -0.170     0.200
    37.814    -1.907     0.200
    37.884    -0.495     0.200
    37.891     2.443     0.200
    38.232     1.363     0.200
    38.611     3.180     0.200
    38.809    -0.779     0.200
    39.062     3.399     0.200
    39.217    -0.401     0.200
    39.386    -2.313     0.200
    39.428     0.834     0.200
    39.641     0.065     0.200
    39.999     0.583     0.200
    40.087     0.358     0.200
    40.133     0.075     0.200
    40.696    -1.181     0.200
    40.760     0.082     0.200
    40.978     1.488     0.200
    41.307    -2.212     0.200
    41.334     0.565     0.200
    41.715    -2.564     0.200
    42.162     0.784     0.200
    42.177    -0.838     0.200
    42.177    -1.338     0.200
    42.218     0.329     0.200
    42.465     0.320     0.200
    42.454    -2.093     0.200
    42.508     0.468     0.200
    42.558    -2.436     0.200
    42.595     3.260     0.200
    42.601    -0.086     0.200
    42.669    -0.337     0.200
    42.958     1.316     0.200
    43.058     1.504     0.200
    43.067     0.435     0.200
    43.243     0.011     0.200
    43.582     0.481     0.200
    43.658    -0.043     0.200
    43.734    -2.948     0.200
    43.910     1.641     0.200
    44.103     1.088     0.200
    44.259     0.840     0.200
    44.259     1.239     0.200
    44.292     0.976     0.200
    44.334     0.236     0.200
    44.648    -1.271     0.200
    44.740     1.493     0.200
    44.827    -3.698     0.200
    44.837     1.620     0.200
    44.861    -0.176     0.200
    45.180     0.891     0.200
    45.224    -0.859     0.200
    45.241    -0.193     0.200
    45.432    -0.404     0.200
    45.568     0.316     0.200
    45.585    -0.118     0.200
    45.590    -0.359     0.200
    45.595     0.100     0.200
    45.647    -0.204     0.200
    45.920    -0.364     0.200
    45.936    -0.491     0.200
    46.006    -0.644     0.200
    46.492     0.036     0.200
    46.495     0.714     0.200
    46.755    -0.321     0.200
    46.777     0.102     0.200
    47.147    -1.488     0.200
    47.247    -1.765     0.200
    47.656     0.053     0.200
    47.844     0.387     0.200
    47.969     0.425     0.200
    48.444     0.159     0.200
    48.641    -0.265     0.200
    48.703    -0.040     0.200
    48.767    -1.532     0.200
    48.889    -1.467     0.200
    48.896    -0.420     0.200
    49.034    -0.372     0.200
    49.161     0.243     0.200
    49.590    -1.030     0.200
    50.004     0.523     0.200
    50.236     0.362     0.200
    50.268     1.025     0.200
    50.390     1.096     0.200
    50.539     0.269     0.200
    50.560     0.414     0.200
    50.564    -0.419     0.200
    50.576     0.490     0.200
    50.636    -0.761     0.200
    50.777     0.177     0.200
    50.845    -1.337     0.200
    50.917    -0.080     0.200
    50.917     0.021     0.200
    51.000    -0.004     0.200
    51.128     0.035     0.200
    51.147    -0.808     0.200
    51.178    -0.336     0.200
    51.260    -0.457     0.200
    51.296    -0.426     0.200
    51.324    -0.234     0.200
    51.374    -0.209     0.200
    51.376    -0.122     0.200
    51.661    -0.660     0.200
    51.877     0.435     0.200
    51.925     0.174     0.200
    51.998    -0.574     0.200
    52.022     0.355     0.200
    52.066     0.231     0.200
    52.175    -1.587     0.200
    52.397    -0.337     0.200
    52.402     0.028     0.200
    52.402     0.731     0.200
    52.670    -0.456     0.200
    52.712     0.438     0.200
    52.862    -0.678     0.200
    52.930    -0.176     0.200
    53.182    -0.741     0.200
    53.190     0.200     0.200
    53.391     0.226     0.200
    53.488    -0.385     0.200
    53.600    -0.809     0.200
    53.828     0.520     0.200
    53.927    -1.203     0.200
    53.944    -0.330     0.200
    53.992    -0.180     0.200
    54.235    -0.650     0.200
    54.437    -0.524     0.200
    54.449    -0.709     0.200
    54.475    -1.197     0.200
    54.475    -0.494     0.200
    54.550    -0.643     0.200
    54.827    -0.749     0.200
    54.918     0.594     0.200
    54.929     0.113     0.200
    55.061    -0.045     0.200
    55.081    -0.490     0.200
    55.074    -1.139     0.200
    55.128    -1.128     0.200
    55.141    -0.723     0.200
    55.147    -1.564     0.200
    55.170    -0.734     0.200
    55.154    -0.118     0.200
    55.327    -0.366     0.200
    55.456     0.103     0.200
    55.511    -0.688     0.200
    55.557    -0.316     0.200
    55.618    -0.455     0.200
    55.647    -0.560     0.200
    55.671     0.063     0.200
    55.785     0.551     0.200
    55.821    -0.312     0.200
    55.878    -0.121     0.200
    56.020     0.265     0.200
    56.502    -0.575     0.200
    56.593     0.176     0.200
    56.651    -0.632     0.200
    56.729    -0.290     0.200
    57.328     1.268     0.200
    57.624     0.681     0.200
    57.597    -0.825     0.200
    57.615    -0.761     0.200
    57.761    -0.685     0.200
    57.895    -0.523     0.200
    58.057    -0.761     0.200
    58.449    -0.605     0.200
    58.716     0.036     0.200
    58.941    -0.024     0.200
    59.376     0.165     0.200
    59.408    -0.556     0.200
    59.654     0.242     0.200
    59.790    -0.496     0.200
    59.882    -0.525     0.200
    59.922    -0.906     0.200
    60.042     0.078     0.200
    60.057    -0.523     0.200
    60.113    -1.109     0.200
    60.212    -0.487     0.200
    60.214    -0.703     0.200
    60.264    -0.344     0.200
    60.280     0.046     0.200
    60.276    -0.832     0.200
    60.398    -2.961     0.200
    60.439    -0.743     0.200
    60.448    -0.903     0.200
    60.578    -0.692     0.200
    60.657    -0.829     0.200
    60.679    -0.481     0.200
    61.088    -1.059     0.200
    61.534    -0.977     0.200
    62.607    -0.483     0.200
    62.638    -0.487     0.200
    62.844    -0.565     0.200
    63.034     0.776     0.200
    63.034    -0.431     0.200
    64.303    -0.097     0.200
    64.279     0.955     0.200
    64.532     0.402     0.200
    64.548     0.900     0.200
    65.020    -0.780     0.200
    65.031    -0.246     0.200
    65.222    -0.086     0.200
    65.636    -1.769     0.200
    65.796    -0.598     0.200
    65.857    -0.492     0.200
    66.352    -0.372     0.200
    66.584     0.145     0.200
    66.612     1.463     0.200
    66.622     2.196     0.200
    66.842    -0.107     0.200
    67.294    -0.377     0.200
    67.404     0.135     0.200
    67.527    -0.051     0.200
    68.033    -0.238     0.200
    68.214    -0.968     0.200
    68.422     2.021     0.200
    69.205    -1.057     0.200
    69.325     0.803     0.200
    69.609     0.151     0.200
    70.019    -1.374     0.200
    70.256     0.171     0.200
    70.922    -0.288     0.200
    71.140     0.788     0.200
    71.510    -2.447     0.200
    72.403    -1.302     0.200
    72.363    -0.768     0.200
    72.832    -1.357     0.200
    73.672    -1.317     0.200
    73.858    -0.802     0.200
    74.003    -1.255     0.200
    74.127     0.124     0.200
    74.127     0.022     0.200
    74.923    -1.101     0.200
    75.385    -0.161     0.200
    75.622    -1.623     0.200
    76.910     0.662     0.200
    77.397     0.828     0.200
    77.891    -0.224     0.200
    77.891    -0.224     0.200
    78.157    -0.305     0.200
    78.330     0.635     0.200
    78.330     1.136     0.200
    80.075    -0.701     0.200
    80.078    -0.714     0.200
    80.573     0.417     0.200
    80.547     0.059     0.200
    80.669     0.604     0.200
    80.887     0.533     0.200
    81.849    -1.860     0.200
    81.877     0.190     0.200
    82.893     0.481     0.200
    83.211     0.738     0.200
    86.190    -0.492     0.200
    86.205    -0.563     0.200
    86.216    -1.121     0.200
    86.853    -0.144     0.200
    87.773     0.810     0.200
    88.517     0.985     0.200
    89.243    -0.630     0.200
    89.432    -0.221     0.200
    90.819     0.214     0.200
    91.972    -0.834     0.200
    92.819    -0.244     0.200
    92.905     0.359     0.200
    93.119     0.373     0.200
    93.839    -0.047     0.200
    94.269     0.179     0.200
    94.536    -1.146     0.200
    98.082    -0.748     0.200
    14.916     6.930     0.200
    16.881     2.474     0.200
    21.330    -0.480     0.200
    21.330    -0.380     0.200
    21.308     0.949     0.200
    21.469    -0.276     0.200
    24.291    -1.249     0.200
    24.435     0.037     0.200
    25.327    -1.082     0.200
    43.785     0.986     0.200
    46.445    -0.153     0.200
    46.604     0.196     0.200
    46.662     0.143     0.200
    49.979    -1.652     0.200
    50.453    -0.048     0.200
    53.248    -1.000     0.200
    56.726    -0.454     0.200
    56.989    -0.620     0.200
    57.196     0.316     0.200
    58.785    -1.028     0.200
    58.933    -0.757     0.200
    59.065    -1.274     0.200
    60.112    -0.197     0.200
    72.887    -0.899     0.200
    72.949    -0.470     0.200
    72.958    -0.620     0.200
    14.738     6.637     0.200
    14.934     6.563     0.200
    21.136     1.110     0.200
    21.356    -0.167     0.200
    21.356    -0.264     0.200
    21.500     0.083     0.200
    24.318    -1.788     0.200
    24.468     0.449     0.200
    25.360    -0.870     0.200
    46.434    -0.049     0.200
    46.592    -0.092     0.200
    46.648    -0.032     0.200
    48.894     0.344     0.200
    49.464    -0.516     0.200
    49.963    -1.821     0.200
    50.444    -0.261     0.200
    52.330     0.104     0.200
    53.178     0.331     0.200
    53.234    -0.976     0.200
    53.458     1.271     0.200
    54.544     0.336     0.200
    54.639    -0.350     0.200
    55.093    -0.244     0.200
    55.601    -0.598     0.200
    55.714    -1.112     0.200
    56.608     0.300     0.200
    56.704    -0.379     0.200
    56.936     0.171     0.200
    56.967    -0.547     0.200
    57.172     0.297     0.200
    58.745    -0.834     0.200
    58.910    -0.882     0.200
    59.042    -0.704     0.200
    59.205    -0.629     0.200
    59.865    -0.185     0.200
    69.973    -0.185     0.200
    72.973    -0.990     0.200
    72.981    -1.041     0.200
    72.894    -1.222     0.200
    78.555    -1.112     0.200
    81.579    -0.051     0.200
    81.679     0.220     0.200
    81.737     0.612     0.200
    81.893    -0.109     0.200
    18.481    -1.758     0.200
    19.777    -1.960     0.200
    20.095     0.077     0.200
    20.515     0.005     0.200
    22.467     0.824     0.200
    23.313    -0.715     0.200
    24.436    -0.505     0.200
    24.808     0.104     0.200
    26.261     1.524     0.200
    27.457     1.539     0.200
    27.567     0.163     0.200
    30.764     1.267     0.200
    31.885     0.097     0.200
    36.537    -1.041     0.200
    38.094    -0.252     0.200
    44.474     0.918     0.200
    45.015     1.606     0.200
    47.035     2.677     0.200
    47.472     0.473     0.200
    47.658     0.622     0.200
    47.751     0.107     0.200
    51.084    -0.654     0.200
    51.438    -0.410     0.200
    53.077    -0.590     0.200
    53.291     0.734     0.200
    54.523    -0.673     0.200
    57.938    -0.566     0.200
    58.200    -0.706     0.200
    58.288    -0.620     0.200
    58.419     0.260     0.200
    58.913    -0.676     0.200
    59.140    -0.151     0.200
    59.982    -1.155     0.200
    59.998    -0.866     0.200
    60.149    -0.606     0.200
    60.279    -0.793     0.200
    60.443    -0.916     0.200
    60.836    -0.802     0.200
    61.106    -0.326     0.200
    61.329    -0.340     0.200
    61.774    -0.149     0.200
    61.796    -0.795     0.200
    62.049     0.202     0.200
    62.286    -0.990     0.200
    62.481    -0.294     0.200
    62.677    -0.201     0.200
    62.822    -0.964     0.200
    71.723    -1.105     0.200
    71.731    -0.555     0.200
    73.370    -0.819     0.200
    73.950    -0.931     0.200
    78.877    -1.173     0.200
    80.470     0.174     0.200
    82.738     0.585     0.200
    82.841     0.648     0.200
    87.127    -0.992     0.200
    95.689    -0.737     0.200
    14.870     7.766     0.200
    16.939     2.368     0.200
    21.115     0.383     0.200
    21.376    -0.031     0.200
    21.305     0.234     0.200
    21.498     0.660     0.200
    24.458     0.195     0.200
    25.330    -0.445     0.200
    43.734     0.674     0.200
    46.542     0.059     0.200
    46.601    -0.299     0.200
    53.365    -0.977     0.200
    56.672    -0.586     0.200
    56.935    -0.554     0.200
    57.007    -0.465     0.200
    57.143     0.268     0.200
    58.713    -0.948     0.200
    58.879    -0.702     0.200
    59.011    -0.715     0.200
    59.174    -0.846     0.200
    59.567    -0.764     0.200
    59.835    -0.208     0.200
    60.059    -0.246     0.200
    72.828    -0.262     0.200
    73.009    -0.836     0.200
    78.489    -1.177     0.200
    81.757     0.678     0.200
    14.926     6.387     0.200
    21.301     0.538     0.200
    21.451    -0.081     0.200
    22.319     0.133     0.200
    24.158     0.583     0.200
    24.419    -0.203     0.200
    25.318    -0.076     0.200
    26.898     0.722     0.200
    30.185     0.943     0.200
    41.188     0.135     0.200
    43.808     2.829     0.200
    46.685    -0.212     0.200
    48.923     0.429     0.200
    50.001    -1.001     0.200
    51.421     0.393     0.200
    52.105     0.084     0.200
    53.246     0.141     0.200
    53.271    -1.243     0.200
    56.330    -0.309     0.200
    56.748    -0.588     0.200
    57.011    -0.554     0.200
    57.218     0.083     0.200
    57.266     0.084     0.200
    57.773     0.470     0.200
    58.789    -0.937     0.200
    58.807    -0.859     0.200
    58.955    -0.587     0.200
    59.087    -0.604     0.200
    59.250    -0.732     0.200
    59.643    -0.845     0.200
    59.911    -0.188     0.200
    60.135    -0.125     0.200
    60.573     0.073     0.200
    60.601    -0.618     0.200
    60.851     0.183     0.200
    61.106    -0.954     0.200
    61.240    -0.059     0.200
    61.296    -1.136     0.200
    61.477     0.035     0.200
    61.631    -1.002     0.200
    61.632    -1.010     0.200
    62.609     0.334     0.200
    67.012    -1.163     0.200
    70.002    -1.353     0.200
    72.927    -0.609     0.200
    72.902    -0.964     0.200
    75.142    -0.959     0.200
    75.627    -0.843     0.200
    81.627     0.344     0.200
    81.727     0.154     0.200
    81.941     0.267     0.200
    82.702    -1.033     0.200
    86.698    -2.699     0.200
    87.313     0.804     0.200
    18.049     1.364     0.200
    23.965     0.579     0.200
    25.003     0.220     0.200
    44.386     0.630     0.200
    46.827    -0.185     0.200
    46.922     0.074     0.200
    47.244    -0.044     0.200
    48.798     0.233     0.200
    49.828    -0.539     0.200
    52.559    -0.745     0.200
    52.628     0.340     0.200
    53.659    -0.853     0.200
    53.832    -0.917     0.200
    57.329    -0.456     0.200
    57.592    -0.513     0.200
    57.798     0.143     0.200
    57.807     0.176     0.200
    59.370    -0.919     0.200
    59.535    -0.760     0.200
    59.668    -0.872     0.200
    59.831    -0.794     0.200
    60.491    -0.220     0.200
    60.715    -0.448     0.200
    61.153    -0.127     0.200
    61.687    -0.636     0.200
    61.820    -0.229     0.200
    62.057    -0.126     0.200
    62.211    -0.661     0.200
    62.423     0.021     0.200
    78.838    -1.017     0.200
    82.083    -0.148     0.200
    82.185    -0.086     0.200
    82.397     0.005     0.200
    83.176    -1.039     0.200
    15.308     4.879     0.200
    18.703    -2.549     0.200
    20.025     0.398     0.200
    20.213    -0.247     0.200
    20.335    -0.473     0.200
    20.748    -1.157     0.200
    20.748    -0.454     0.200
    20.695    -0.076     0.200
    21.023    -0.129     0.200
    23.381    -0.243     0.200
    23.632     0.126     0.200
    23.991    -0.756     0.200
    24.553    -0.089     0.200
    24.589     0.084     0.200
    26.469     1.030     0.200
    26.945     0.246     0.200
    27.666     1.570     0.200
    27.751     0.014     0.200
    30.903     1.045     0.200
    30.903     0.646     0.200
    30.962     1.525     0.200
    36.521    -0.779     0.200
    36.521    -0.279     0.200
    36.742     0.540     0.200
    38.309    -0.134     0.200
    40.224     0.068     0.200
    40.224    -0.034     0.200
    44.574     0.673     0.200
    45.112     1.387     0.200
    45.112     2.387     0.200
    47.602    -0.067     0.200
    47.934    -0.351     0.200
    49.249    -0.164     0.200
    49.475     0.010     0.200
    49.489    -0.701     0.200
    50.064    -0.074     0.200
    50.458    -0.056     0.200
    50.721     0.057     0.200
    51.652    -0.530     0.200
    52.727     0.483     0.200
    53.060     0.123     0.200
    53.255    -0.712     0.200
    53.354    -0.042     0.200
    53.412    -0.567     0.200
    54.353    -0.744     0.200
    54.353    -1.650     0.200
    54.524    -0.990     0.200
    54.526     0.190     0.200
    54.893     0.837     0.200
    54.893    -1.367     0.200
    55.243     0.999     0.200
    55.991    -0.167     0.200
    55.991    -0.371     0.200
    56.106    -0.691     0.200
    57.465    -1.498     0.200
    57.585     0.517     0.200
    57.650    -2.801     0.200
    57.767    -1.068     0.200
    57.960     0.485     0.200
    57.977     0.135     0.200
    58.239    -0.985     0.200
    58.268     0.345     0.200
    58.288     0.485     0.200
    58.302    -1.637     0.200
    58.319    -1.235     0.200
    58.381    -1.053     0.200
    58.474    -1.288     0.200
    58.615    -0.435     0.200
    58.666    -0.148     0.200
    60.114    -0.858     0.200
    62.640    -0.442     0.200
    66.854    -0.214     0.200
    71.621    -1.748     0.200
    71.621    -0.748     0.200
    71.738     0.254     0.200
    71.630    -0.799     0.200
    73.835    -0.898     0.200
    73.837    -0.908     0.200
    76.066     0.318     0.200
    78.615     0.235     0.200
    78.967     0.104     0.200
    79.158    -1.045     0.200
    80.687     0.477     0.200
    14.028     6.209     0.200
    19.224    -0.593     0.200
    19.664    -0.207     0.200
    20.651     0.255     0.200
    21.438    -0.445     0.200
    21.557     0.279     0.200
    21.557     0.599     0.200
    21.784    -0.454     0.200
    21.784    -0.321     0.200
    21.877    -0.450     0.200
    21.877    -0.207     0.200
    22.714     0.134     0.200
    22.798    -0.751     0.200
    23.134    -0.306     0.200
    23.137    -0.536     0.200
    23.646     0.470     0.200
    23.773     1.308     0.200
    23.956     1.240     0.200
    24.034     1.131     0.200
    24.039     1.588     0.200
    24.148    -0.119     0.200
    24.638     3.418     0.200
    24.745    -2.555     0.200
    24.820     0.158     0.200
    25.255     0.799     0.200
    25.347     2.969     0.200
    25.613    -0.656     0.200
    25.828     2.206     0.200
    26.094    -0.011     0.200
    26.282     1.492     0.200
    26.343     0.944     0.200
    26.482     0.488     0.200
    26.560     0.882     0.200
    26.823     0.611     0.200
    27.089     1.213     0.200
    27.238     0.372     0.200
    27.654     1.146     0.200
    28.018     0.894     0.200
    28.287     0.893     0.200
    28.467     0.684     0.200
    28.566    -0.287     0.200
    28.983     1.299     0.200
    29.005     2.103     0.200
    29.199     0.883     0.200
    29.325     0.767     0.200
    29.325     0.517     0.200
    29.333     1.192     0.200
    29.339     1.539     0.200
    29.378     1.196     0.200
    29.824     0.848     0.200
    30.104    -0.133     0.200
    30.396    -0.210     0.200
    30.522     1.173     0.200
    31.072    -0.183     0.200
    31.119     1.300     0.200
    31.264     0.624     0.200
    31.317     0.764     0.200
    31.317     0.647     0.200
    31.654    -0.010     0.200
    31.664     1.104     0.200
    31.664     1.315     0.200
    32.194     3.951     0.200
    32.291     0.494     0.200
    32.658    -0.117     0.200
    32.658     0.180     0.200
    32.980     2.065     0.200
    33.171    -0.607     0.200
    33.358     1.764     0.200
    33.499    -0.370     0.200
    33.628     0.404     0.200
    34.092    -0.025     0.200
    34.970     0.279     0.200
    35.175    -0.490     0.200
    35.537    -0.109     0.200
    35.800     1.038     0.200
    35.832     0.363     0.200
    35.873     1.238     0.200
    35.960     0.557     0.200
    36.215     0.582     0.200
    36.274    -0.219     0.200
    36.370     0.755     0.200
    36.382     0.657     0.200
    36.385     0.625     0.200
    36.404    -0.031     0.200
    36.457     0.115     0.200
    36.489     1.534     0.200
    36.500     0.251     0.200
    36.638     1.172     0.200
    36.658     1.300     0.200
    36.754     0.878     0.200
    36.828     0.851     0.200
    36.970     0.439     0.200
    37.093    -1.501     0.200
    37.379    -0.829     0.200
    37.523     0.747     0.200
    37.529     0.692     0.200
    37.531     1.878     0.200
    37.612     1.801     0.200
    37.812     0.506     0.200
    37.962    -2.868     0.200
    38.019     0.181     0.200
    38.163     0.541     0.200
    38.169     0.492     0.200
    38.260     0.262     0.200
    38.260     0.153     0.200
    38.286     0.504     0.200
    38.484     0.539     0.200
    38.484     0.265     0.200
    38.856     0.111     0.200
    38.976     0.411     0.200
    39.082    -0.179     0.200
    39.800     2.836     0.200
    40.110    -0.247     0.200
    40.155    -0.619     0.200
    40.367     1.127     0.200
    40.627     0.375     0.200
    40.638    -0.113     0.200
    40.727     2.152     0.200
    40.793     0.404     0.200
    40.860     0.054     0.200
    40.877    -0.191     0.200
    41.081     0.634     0.200
    41.100     1.076     0.200
    41.094     3.126     0.200
    41.113    -0.030     0.200
    41.217     3.116     0.200
    41.411    -0.484     0.200
    41.455     2.159     0.200
    41.487     0.296     0.200
    41.661     2.469     0.200
    41.773    -0.450     0.200
    41.821     1.160     0.200
    41.821     1.660     0.200
    41.859     0.850     0.200
    41.869     0.263     0.200
    41.973    -0.288     0.200
    42.021    -0.974     0.200
    42.025     0.993     0.200
    42.036     0.008     0.200
    42.282    -3.607     0.200
    42.381     0.091     0.200
    42.433     0.667     0.200
    42.439    -0.583     0.200
    42.442    -0.607     0.200
    42.567     3.077     0.200
    42.578    -0.012     0.200
    42.640    -0.317     0.200
    42.788     0.280     0.200
    42.788     2.280     0.200
    42.855     0.738     0.200
    42.899     1.384     0.200
    43.067     4.023     0.200
    43.144    -0.600     0.200
    43.211     0.858     0.200
    43.235    -0.040     0.200
    43.260     0.459     0.200
    43.305     0.098     0.200
    43.305     0.598     0.200
    43.327     0.917     0.200
    43.328    -0.486     0.200
    43.368    -0.089     0.200
    43.537     1.223     0.200
    43.734     0.133     0.200
    44.379    -0.042     0.200
    44.503     0.472     0.200
    44.524     2.301     0.200
    44.809     1.026     0.200
    44.979     0.311     0.200
    45.062     2.014     0.200
    45.194    -1.139     0.200
    45.202    -0.316     0.200
    45.237    -0.380     0.200
    45.252    -0.134     0.200
    45.409    -0.379     0.200
    45.419    -0.919     0.200
    45.460     0.856     0.200
    45.720    -0.420     0.200
    45.721    -0.613     0.200
    45.891     0.444     0.200
    45.925     0.384     0.200
    45.951    -0.628     0.200
    46.114    -0.154     0.200
    46.140    -0.597     0.200
    46.233     0.253     0.200
    46.272    -2.159     0.200
    46.367     1.699     0.200
    46.398    -1.189     0.200
    46.565    -1.861     0.200
    46.640     3.555     0.200
    46.663    -0.524     0.200
    46.732    -0.465     0.200
    46.871    -2.251     0.200
    46.905    -0.203     0.200
    46.949    -0.862     0.200
    47.183     0.452     0.200
    47.214     0.772     0.200
    47.203     0.550     0.200
    47.251     1.276     0.200
    47.302    -0.414     0.200
    47.371    -0.156     0.200
    47.460    -0.648     0.200
    47.491     0.410     0.200
    47.657    -0.177     0.200
    47.785     3.629     0.200
    47.862    -1.212     0.200
    47.873    -0.557     0.200
    47.973    -2.330     0.200
    48.090     0.363     0.200
    48.108     1.127     0.200
    48.174    -1.383     0.200
    48.243     0.579     0.200
    48.299     0.447     0.200
    48.361     0.276     0.200
    48.433     0.617     0.200
    48.449    -0.305     0.200
    48.516     0.176     0.200
    48.516    -0.066     0.200
    48.558     1.253     0.200
    48.585     1.741     0.200
    48.630     0.494     0.200
    48.771    -0.488     0.200
    48.857    -1.145     0.200
    48.876    -0.790     0.200
    49.133    -0.963     0.200
    49.133    -0.760     0.200
    49.354    -0.247     0.200
    49.430    -0.534     0.200
    49.450    -0.214     0.200
    49.544    -0.407     0.200
    49.581     0.816     0.200
    49.673     2.011     0.200
    49.790     0.220     0.200
    49.874     0.290     0.200
    50.030     0.003     0.200
    50.053    -0.381     0.200
    50.125     0.681     0.200
    50.125     1.181     0.200
    50.147     1.008     0.200
    50.237    -0.671     0.200
    50.259    -1.339     0.200
    50.288     0.944     0.200
    50.293     0.402     0.200
    50.430    -0.633     0.200
    50.632    -1.365     0.200
    50.650     0.702     0.200
    50.704    -1.443     0.200
    50.726     0.527     0.200
    50.830     0.345     0.200
    50.902     0.007     0.200
    50.942     0.606     0.200
    50.942     0.707     0.200
    50.989    -0.454     0.200
    51.007     1.012     0.200
    51.045     1.329     0.200
    51.056     1.649     0.200
    51.056     2.149     0.200
    51.099    -0.022     0.200
    51.108     0.457     0.200
    51.123     0.042     0.200
    51.278    -0.019     0.200
    51.278     0.180     0.200
    51.349     0.154     0.200
    51.383     0.593     0.200
    51.392    -0.776     0.200
    51.394    -0.388     0.200
    51.407    -0.092     0.200
    51.503     0.291     0.200
    51.524    -0.860     0.200
    51.524    -0.657     0.200
    51.539    -0.268     0.200
    51.575     0.283     0.200
    51.626     0.080     0.200
    51.626     0.330     0.200
    51.670     1.048     0.200
    51.686    -2.672     0.200
    51.845    -0.161     0.200
    51.847    -0.173     0.200
    51.847    -0.480     0.200
    51.851    -0.115     0.200
    51.920     0.546     0.200
    51.945     0.894     0.200
    51.976    -0.133     0.200
    52.054     1.286     0.200
    52.083    -0.032     0.200
    52.414     1.803     0.200
    52.416    -0.513     0.200
    52.476    -0.951     0.200
    52.487    -0.037     0.200
    52.489     0.250     0.200
    52.530    -2.456     0.200
    52.601     0.117     0.200
    52.601    -0.024     0.200
    52.629     0.310     0.200
    52.639    -0.554     0.200
    52.640     0.126     0.200
    52.745    -0.147     0.200
    52.768     0.485     0.200
    52.817    -0.682     0.200
    52.832     0.412     0.200
    52.990    -1.257     0.200
    53.025    -0.312     0.200
    53.026     0.873     0.200
    53.108     0.975     0.200
    53.109    -1.134     0.200
    53.109     0.303     0.200
    53.111    -0.648     0.200
    53.122    -0.730     0.200
    53.142    -0.879     0.200
    53.210    -0.479     0.200
    53.211    -0.985     0.200
    53.241     0.396     0.200
    53.241     0.029     0.200
    53.266    -0.187     0.200
    53.374     2.517     0.200
    53.424     3.051     0.200
    53.434     0.270     0.200
    53.447     0.265     0.200
    53.460     1.078     0.200
    53.482    -1.173     0.200
    53.555     0.987     0.200
    53.578    -0.580     0.200
    53.582    -0.337     0.200
    53.582    -0.110     0.200
    53.595     0.429     0.200
    53.863     0.930     0.200
    53.905    -0.476     0.200
    54.086     1.495     0.200
    54.109     0.632     0.200
    54.204    -0.056     0.200
    54.225     0.886     0.200
    54.229    -1.239     0.200
    54.322    -0.721     0.200
    54.605     0.212     0.200
    54.708    -0.328     0.200
    54.745     0.404     0.200
    54.827     0.012     0.200
    54.949    -0.370     0.200
    54.971    -0.729     0.200
    54.999     0.429     0.200
    55.005     0.627     0.200
    55.080     0.456     0.200
    55.149    -0.816     0.200
    55.165    -0.534     0.200
    55.170    -0.876     0.200
    55.260     0.066     0.200
    55.263    -0.739     0.200
    55.279    -1.056     0.200
    55.297     0.572     0.200
    55.317     0.169     0.200
    55.394     0.717     0.200
    55.415     0.170     0.200
    55.451    -0.418     0.200
    55.470     0.275     0.200
    55.533     1.511     0.200
    55.534     0.307     0.200
    55.609     0.575     0.200
    55.609     0.169     0.200
    55.621     0.080     0.200
    55.624     0.060     0.200
    55.678     1.083     0.200
    55.680    -0.980     0.200
    55.707     0.173     0.200
    55.761    -0.918     0.200
    55.767    -0.074     0.200
    55.771    -0.059     0.200
    55.796     0.280     0.200
    55.798    -0.485     0.200
    55.817     1.668     0.200
    55.850    -0.445     0.200
    55.855    -0.712     0.200
    55.863    -1.789     0.200
    55.865    -1.766     0.200
    55.867     1.271     0.200
    55.879    -0.029     0.200
    55.891    -0.056     0.200
    55.956     0.454     0.200
    55.960    -0.553     0.200
    55.960    -0.342     0.200
    55.982    -0.891     0.200
    56.039    -0.114     0.200
    56.173     0.333     0.200
    56.177    -0.690     0.200
    56.191     0.075     0.200
    56.230     0.569     0.200
    56.266    -0.043     0.200
    56.268    -0.154     0.200
    56.319    -0.115     0.200
    56.319     0.268     0.200
    56.347    -0.011     0.200
    56.354    -0.163     0.200
    56.375     0.582     0.200
    56.418     0.269     0.200
    56.428    -0.190     0.200
    56.453    -1.687     0.200
    56.481     0.571     0.200
    56.501     0.392     0.200
    56.516    -2.756     0.200
    56.531    -0.632     0.200
    56.533    -0.824     0.200
    56.596    -1.065     0.200
    56.597    -1.295     0.200
    56.600    -0.710     0.200
    56.609     0.021     0.200
    56.670    -0.019     0.200
    56.674     1.059     0.200
    56.688    -1.511     0.200
    56.699     0.377     0.200
    56.733    -0.160     0.200
    56.737     0.108     0.200
    56.747     0.041     0.200
    56.785     0.165     0.200
    56.828    -0.047     0.200
    56.879     0.704     0.200
    57.224    -0.736     0.200
    57.295     0.429     0.200
    57.321     1.971     0.200
    57.372    -0.788     0.200
    57.419     0.076     0.200
    57.451    -0.441     0.200
    57.691     0.572     0.200
    57.716     0.290     0.200
    57.764     1.855     0.200
    57.820    -0.038     0.200
    57.941     0.316     0.200
    58.233     1.360     0.200
    58.305    -0.143     0.200
    58.305     0.013     0.200
    58.309    -1.071     0.200
    58.327    -1.297     0.200
    58.475    -1.023     0.200
    58.607    -0.947     0.200
    58.770    -0.978     0.200
    58.776    -0.019     0.200
    58.831    -0.003     0.200
    58.888     1.798     0.200
    59.089     0.104     0.200
    59.143    -0.308     0.200
    59.163    -1.009     0.200
    59.205     0.299     0.200
    59.244     0.132     0.200
    59.430    -0.461     0.200
    59.654    -0.406     0.200
    60.093    -0.022     0.200
    60.121    -1.014     0.200
    60.201    -2.060     0.200
    60.218     0.222     0.200
    60.233    -0.275     0.200
    60.361     3.140     0.200
    60.370    -0.118     0.200
    60.409    -0.297     0.200
    60.461    -0.341     0.200
    60.549    -0.340     0.200
    60.628    -0.979     0.200
    60.633    -0.304     0.200
    60.646    -0.310     0.200
    60.667    -0.309     0.200
    60.681    -0.157     0.200
    60.731     0.318     0.200
    60.775    -0.275     0.200
    60.817    -1.472     0.200
    60.881    -0.202     0.200
    60.888    -0.547     0.200
    60.888    -0.063     0.200
    60.917    -0.347     0.200
    60.925    -1.356     0.200
    60.935    -0.071     0.200
    60.944    -0.526     0.200
    60.997    -0.286     0.200
    61.020    -0.352     0.200
    61.145     0.004     0.200
    61.151    -0.832     0.200
    61.153    -0.951     0.200
    61.288    -0.865     0.200
    61.299    -0.437     0.200
    61.347    -0.367     0.200
    61.363    -0.679     0.200
    61.732     2.534     0.200
    61.760    -0.152     0.200
    61.808    -1.275     0.200
    61.877     0.558     0.200
    62.026    -1.441     0.200
    62.165     3.628     0.200
    62.185    -0.301     0.200
    62.303     0.697     0.200
    62.337     0.969     0.200
    62.359    -1.676     0.200
    62.420    -0.041     0.200
    62.435     2.113     0.200
    62.517     0.423     0.200
    62.521     2.103     0.200
    62.605     0.481     0.200
    62.734    -0.169     0.200
    62.734     1.323     0.200
    62.733     1.123     0.200
    63.233    -0.100     0.200
    63.292     0.214     0.200
    63.310     0.287     0.200
    63.359     0.269     0.200
    63.531     0.129     0.200
    63.720     0.577     0.200
    63.725     0.144     0.200
    63.760     0.239     0.200
    63.811     0.858     0.200
    63.934     0.834     0.200
    64.193     0.107     0.200
    64.729     0.138     0.200
    64.862    -0.625     0.200
    64.952    -1.288     0.200
    65.140     1.688     0.200
    65.257     0.303     0.200
    65.394    -0.206     0.200
    65.523    -0.393     0.200
    65.614     0.511     0.200
    65.628     0.149     0.200
    65.753     0.168     0.200
    65.881     1.594     0.200
    65.945    -0.459     0.200
    65.945     0.424     0.200
    65.945     0.213     0.200
    66.368     1.222     0.200
    66.399    -0.635     0.200
    66.522    -0.537     0.200
    66.530    -0.257     0.200
    66.685    -0.165     0.200
    66.692    -0.302     0.200
    66.785     0.404     0.200
    66.977     1.490     0.200
    67.226     0.596     0.200
    67.264     2.154     0.200
    67.335     0.581     0.200
    67.361     0.239     0.200
    67.568     0.083     0.200
    67.880     0.645     0.200
    68.010     0.716     0.200
    68.030    -0.482     0.200
    68.248     2.152     0.200
    68.254    -0.835     0.200
    68.357    -1.533     0.200
    68.477     0.221     0.200
    68.487    -1.346     0.200
    68.602    -0.061     0.200
    68.708     0.275     0.200
    68.757    -0.361     0.200
    68.935     0.568     0.200
    69.149     1.033     0.200
    69.182    -0.469     0.200
    69.182    -2.672     0.200
    69.376    -0.976     0.200
    69.740     3.382     0.200
    70.006     0.944     0.200
    70.048     1.987     0.200
    70.869    -1.530     0.200
    70.983     0.276     0.200
    71.064    -0.217     0.200
    71.769    -1.471     0.200
    71.867    -0.059     0.200
    71.985     3.228     0.200
    72.190    -1.700     0.200
    72.649    -0.531     0.200
    72.731     1.177     0.200
    72.800    -0.132     0.200
    72.967     1.877     0.200
    73.037    -1.040     0.200
    73.322    -1.118     0.200
    73.427     0.261     0.200
    74.089    -2.021     0.200
    74.295    -0.926     0.200
    74.562     1.121     0.200
    75.010     1.628     0.200
    75.448     1.401     0.200
    75.488    -1.323     0.200
    75.488    -0.526     0.200
    75.855     1.275     0.200
    76.358     0.106     0.200
    76.975     0.225     0.200
    76.975     0.428     0.200
    76.970    -0.145     0.200
    77.798    -1.388     0.200
    77.958     1.726     0.200
    78.007    -0.539     0.200
    78.007    -0.547     0.200
    78.292     1.473     0.200
    78.379     0.389     0.200
    78.379     0.788     0.200
    78.384     2.362     0.200
    78.855    -1.736     0.200
    79.437    -0.420     0.200
    79.817    -0.487     0.200
    79.827    -0.240     0.200
    79.880    -0.430     0.200
    79.938     1.656     0.200
    80.158    -0.431     0.200
    80.635    -1.099     0.200
    80.648     0.742     0.200
    81.101     1.617     0.200
    81.206    -0.440     0.200
    81.229     0.641     0.200
    81.327     0.634     0.200
    81.543     0.654     0.200
    81.613    -1.097     0.200
    81.911     0.328     0.200
    81.911     0.031     0.200
    82.598    -0.062     0.200
    82.714    -0.870     0.200
    84.616     0.775     0.200
    84.993    -0.521     0.200
    85.039     1.248     0.200
    86.329     0.135     0.200
    87.269     2.243     0.200
    87.578     2.852     0.200
    87.793     0.724     0.200
    87.897     0.627     0.200
    87.897     0.229     0.200
    88.717     0.146     0.200
    90.122    -2.235     0.200
    91.247     0.535     0.200
    92.204     1.103     0.200
    92.216     1.342     0.200
    92.397     0.212     0.200
    93.128     0.440     0.200
    93.366     0.341     0.200
    93.725     0.089     0.200
    94.870    -0.869     0.200
    98.740    -0.691     0.200
    14.081     7.744     0.200
    21.572     0.203     0.200
    21.855    -0.133     0.200
    51.456    -0.557     0.200
    52.735    -1.171     0.200
    56.661     0.252     0.200
    56.670     0.185     0.200
    73.503    -0.283     0.200
    77.954    -0.147     0.200
    14.046     5.035     0.200
    14.823     5.146     0.200
    19.253    -0.034     0.200
    21.597     0.333     0.200
    21.854    -0.912     0.200
    22.867    -0.696     0.200
    23.084    -0.478     0.200
    24.218     0.609     0.200
    24.880     0.180     0.200
    25.659    -0.500     0.200
    26.558     0.373     0.200
    26.826     0.654     0.200
    27.120     0.305     0.200
    28.318     0.993     0.200
    30.573     0.597     0.200
    36.271    -0.009     0.200
    37.410    -0.300     0.200
    38.103     0.439     0.200
    38.418    -0.014     0.200
    38.884    -0.124     0.200
    41.896     0.752     0.200
    43.257     0.887     0.200
    45.861     0.093     0.200
    46.168    -0.326     0.200
    46.168     0.074     0.200
    47.598    -0.303     0.200
    49.479    -0.287     0.200
    51.209    -0.075     0.200
    51.473    -0.555     0.200
    52.752    -1.668     0.200
    56.199    -0.517     0.200
    56.462    -0.594     0.200
    56.668     0.044     0.200
    56.677     0.077     0.200
    58.240    -0.739     0.200
    58.405    -0.894     0.200
    58.538    -0.718     0.200
    58.701    -0.852     0.200
    59.361    -0.231     0.200
    59.585    -0.178     0.200
    60.023    -0.092     0.200
    60.052    -0.688     0.200
    60.559    -0.756     0.200
    60.748    -1.047     0.200
    60.927    -0.065     0.200
    61.082    -0.812     0.200
    61.084    -0.933     0.200
    61.294    -1.055     0.200
    65.503     0.597     0.200
    66.387    -0.594     0.200
    66.387    -0.094     0.200
    69.866     0.077     0.200
    71.044     0.383     0.200
    72.615    -0.055     0.200
    73.477    -0.159     0.200
    73.496    -0.272     0.200
    75.470     0.357     0.200
    75.691    -0.509     0.200
    77.988     0.241     0.200
    78.331    -0.855     0.200
    80.143    -0.157     0.200
    80.631     0.922     0.200
    81.169    -0.055     0.200
    81.901     0.378     0.200
    87.863     0.898     0.200
    51.467    -0.456     0.200
    14.858     7.182     0.200
    19.217    -0.063     0.200
    19.709    -0.147     0.200
    21.405     0.460     0.200
    21.538     0.237     0.200
    21.728    -1.102     0.200
    24.779    -1.137     0.200
    25.588    -0.697     0.200
    26.580     0.334     0.200
    26.580     1.233     0.200
    26.838     0.701     0.200
    27.079     1.333     0.200
    28.549     1.690     0.200
    30.491     0.474     0.200
    36.294    -0.068     0.200
    38.849    -0.008     0.200
    39.126    -0.418     0.200
    43.386     1.961     0.200
    45.985     0.023     0.200
    46.293    -0.207     0.200
    48.574     0.043     0.200
    51.599    -0.412     0.200
    51.628    -0.323     0.200
    52.878    -1.113     0.200
    56.328    -0.570     0.200
    56.592    -0.543     0.200
    56.658    -0.421     0.200
    56.797     0.097     0.200
    56.806     0.132     0.200
    58.369    -0.979     0.200
    58.535    -0.929     0.200
    58.667    -0.755     0.200
    58.830    -0.786     0.200
    59.490    -0.160     0.200
    59.714    -0.206     0.200
    60.688    -0.779     0.200
    61.056     0.015     0.200
    62.317    -0.285     0.200
    66.427    -0.803     0.200
    66.427    -0.303     0.200
    72.693    -0.491     0.200
    73.348    -0.176     0.200
    73.368    -0.589     0.200
    75.562    -0.850     0.200
    75.519    -0.949     0.200
    78.039    -1.174     0.200
    78.395    -1.197     0.200
    81.269     0.223     0.200
    81.237    -0.865     0.200
    81.368     0.198     0.200
    81.584     0.256     0.200
    82.630    -0.142     0.200
    14.955     7.213     0.200
    20.163    -0.040     0.200
    23.175    -0.339     0.200
    24.296    -0.581     0.200
    26.130     1.256     0.200
    45.112     1.991     0.200
    47.459     0.033     0.200
    47.806    -0.162     0.200
    53.323     0.058     0.200
    58.513     0.175     0.200
    58.523     0.205     0.200
    63.706    -1.260     0.200
    71.627    -0.361     0.200
    71.636    -1.209     0.200
    82.874     0.253     0.200
    19.035    -1.252     0.200
    21.165    -0.413     0.200
    21.487     1.232     0.200
    21.324    -0.123     0.200
    21.579     0.140     0.200
    21.701    -0.169     0.200
    23.294    -1.563     0.200
    23.624    -0.945     0.200
    24.529     0.493     0.200
    24.348    -0.864     0.200
    25.363    -1.091     0.200
    26.491     0.690     0.200
    29.526     0.290     0.200
    30.253     0.653     0.200
    31.446    -0.967     0.200
    35.954     0.952     0.200
    36.703     0.157     0.200
    38.668    -0.257     0.200
    38.729    -1.671     0.200
    43.616     0.763     0.200
    43.616     1.263     0.200
    45.382    -0.734     0.200
    46.058    -0.275     0.200
    46.155    -0.243     0.200
    46.155    -0.141     0.200
    46.472     0.073     0.200
    48.908    -0.826     0.200
    48.910    -1.640     0.200
    49.098     0.021     0.200
    49.789    -1.251     0.200
    51.848    -0.358     0.200
    51.848    -0.458     0.200
    52.884    -0.940     0.200
    53.058    -1.120     0.200
    54.914    -0.569     0.200
    54.914    -0.369     0.200
    56.054    -1.268     0.200
    56.550    -0.505     0.200
    56.813    -0.472     0.200
    56.889    -0.414     0.200
    57.024     0.232     0.200
    57.033     0.067     0.200
    58.592    -0.978     0.200
    58.609    -1.197     0.200
    58.758    -0.634     0.200
    58.890    -0.746     0.200
    59.053    -0.779     0.200
    59.714    -0.245     0.200
    59.938    -0.182     0.200
    60.379    -0.004     0.200
    60.405    -0.779     0.200
    60.656     0.208     0.200
    60.906    -0.791     0.200
    61.046    -0.242     0.200
    61.146    -1.226     0.200
    61.433    -0.965     0.200
    61.431    -1.054     0.200
    62.252    -1.172     0.200
    62.192    -1.274     0.200
    66.249    -0.167     0.200
    72.722    -1.233     0.200
    73.119    -0.889     0.200
    73.128    -0.541     0.200
    74.849    -0.397     0.200
    75.341    -1.036     0.200
    75.482    -0.542     0.200
    77.252     0.321     0.200
    78.065    -1.011     0.200
    78.006    -2.188     0.200
    78.006    -1.688     0.200
    78.353    -1.609     0.200
    79.865    -1.578     0.200
    80.676     3.112     0.200
    81.465     0.157     0.200
    81.519     0.700     0.200
    81.618     0.477     0.200
    81.833     0.323     0.200
    84.853    -1.531     0.200
    85.864    -0.278     0.200
    86.521    -2.114     0.200
    89.957    -0.364     0.200
    49.098     0.050     0.200
    49.098     0.050     0.200
    49.098     0.130     0.200
    49.098     0.111     0.200
    45.382     0.174     0.200
    45.382     0.160     0.200
    15.008     7.015     0.200
    18.422    -2.275     0.200
    20.008     0.150     0.200
    20.014    -0.012     0.200
    20.444     0.413     0.200
    21.968     0.690     0.200
    22.969     0.050     0.200
    23.228    -0.684     0.200
    24.220    -0.849     0.200
    24.360    -1.420     0.200
    24.341    -0.249     0.200
    25.004    -1.094     0.200
    26.197     1.292     0.200
    26.642     1.270     0.200
    27.053     0.913     0.200
    27.122     3.545     0.200
    27.393     1.108     0.200
    27.496     0.186     0.200
    28.354     0.521     0.200
    29.127     0.153     0.200
    29.416     1.591     0.200
    29.425     2.005     0.200
    30.026     1.990     0.200
    30.347    -0.151     0.200
    30.689     1.228     0.200
    30.697     1.254     0.200
    30.734     1.433     0.200
    31.152    -0.257     0.200
    31.381     0.054     0.200
    31.819    -0.126     0.200
    31.973     1.513     0.200
    32.840    -0.088     0.200
    32.853     0.803     0.200
    32.836     0.249     0.200
    33.002     0.102     0.200
    33.075    -1.342     0.200
    33.082     0.604     0.200
    33.719     3.571     0.200
    33.901    -0.505     0.200
    33.994    -0.147     0.200
    34.799     0.883     0.200
    34.874     1.236     0.200
    35.127     2.053     0.200
    35.339     0.231     0.200
    35.654     0.822     0.200
    36.218     0.785     0.200
    36.472     0.120     0.200
    36.624     1.017     0.200
    36.795     0.563     0.200
    37.164     0.429     0.200
    38.032     0.279     0.200
    38.125     0.492     0.200
    38.678     1.000     0.200
    38.948     0.778     0.200
    39.744    -0.372     0.200
    39.791    -0.456     0.200
    40.205    -1.397     0.200
    40.122    -0.208     0.200
    41.079     1.881     0.200
    41.071    -0.055     0.200
    41.664     1.675     0.200
    42.488    -0.145     0.200
    42.995     0.340     0.200
    43.166    -0.144     0.200
    43.474     1.366     0.200
    43.539     0.344     0.200
    44.339     0.413     0.200
    44.550     0.229     0.200
    44.550     0.729     0.200
    44.664     1.816     0.200
    44.879     1.109     0.200
    45.091     0.917     0.200
    45.091     1.517     0.200
    45.141    -0.176     0.200
    45.393     2.025     0.200
    45.459     0.495     0.200
    45.569     1.627     0.200
    45.712    -0.504     0.200
    46.073     0.644     0.200
    46.090     0.509     0.200
    46.139     0.325     0.200
    46.542    -0.038     0.200
    46.562    -0.100     0.200
    47.148     0.221     0.200
    47.253     3.598     0.200
    47.295     0.073     0.200
    47.322    -0.140     0.200
    47.378    -0.275     0.200
    47.436    -1.022     0.200
    47.465     0.052     0.200
    47.727     0.116     0.200
    47.925     0.180     0.200
    47.809    -0.121     0.200
    47.890    -0.349     0.200
    47.916    -0.654     0.200
    48.053    -0.616     0.200
    48.053    -0.716     0.200
    48.055    -1.028     0.200
    48.041     1.284     0.200
    48.112     0.729     0.200
    48.130     0.592     0.200
    48.438    -1.786     0.200
    48.439     0.207     0.200
    48.507    -0.719     0.200
    48.578    -0.765     0.200
    48.590    -0.959     0.200
    48.862     1.856     0.200
    48.955     1.243     0.200
    48.990     1.271     0.200
    49.191     0.928     0.200
    49.224     0.182     0.200
    49.284     0.223     0.200
    49.365    -0.496     0.200
    49.868    -0.334     0.200
    49.913    -0.878     0.200
    50.287    -0.413     0.200
    50.280    -0.057     0.200
    50.308     1.233     0.200
    50.316    -0.133     0.200
    50.351     0.907     0.200
    50.744     0.037     0.200
    50.848     0.224     0.200
    51.100    -0.243     0.200
    51.145     0.621     0.200
    51.379     0.162     0.200
    51.547     1.218     0.200
    51.512     0.270     0.200
    51.514    -0.148     0.200
    52.031    -1.405     0.200
    52.054    -0.076     0.200
    52.307     0.941     0.200
    52.673    -0.075     0.200
    52.673     0.186     0.200
    52.673     0.436     0.200
    52.738    -0.253     0.200
    53.001     0.305     0.200
    53.038     0.534     0.200
    53.281     0.239     0.200
    53.364    -0.367     0.200
    53.364     0.053     0.200
    53.376     1.039     0.200
    53.430    -1.052     0.200
    53.477     0.098     0.200
    53.495     0.254     0.200
    53.565    -0.147     0.200
    53.593     0.021     0.200
    53.608    -0.060     0.200
    53.620    -0.251     0.200
    53.721    -0.487     0.200
    53.792     0.259     0.200
    53.911     0.155     0.200
    54.060     0.164     0.200
    54.079     0.651     0.200
    54.172    -0.543     0.200
    54.180    -0.165     0.200
    54.232    -0.521     0.200
    54.258     0.487     0.200
    54.258     0.786     0.200
    54.374     0.141     0.200
    54.374     0.840     0.200
    54.401    -1.154     0.200
    54.435    -0.320     0.200
    54.492     0.484     0.200
    54.496     0.153     0.200
    54.496    -0.011     0.200
    54.496    -0.728     0.200
    54.514     0.323     0.200
    54.677    -1.088     0.200
    54.794     0.691     0.200
    54.794     0.890     0.200
    54.796     0.980     0.200
    54.796     1.279     0.200
    54.823    -0.097     0.200
    54.840     0.858     0.200
    54.861    -0.796     0.200
    54.895    -0.437     0.200
    54.892    -1.020     0.200
    54.915    -0.252     0.200
    55.024    -0.219     0.200
    55.041     0.177     0.200
    55.111    -0.188     0.200
    55.156    -0.826     0.200
    55.158     0.019     0.200
    55.190    -0.229     0.200
    55.203     0.735     0.200
    55.209    -1.011     0.200
    55.215    -0.304     0.200
    55.228     0.655     0.200
    55.231     0.183     0.200
    55.330    -0.683     0.200
    55.356     0.101     0.200
    55.358     0.111     0.200
    55.519    -0.441     0.200
    55.568     0.277     0.200
    55.596     0.902     0.200
    55.618     0.906     0.200
    55.635     0.072     0.200
    55.643     0.109     0.200
    55.673     0.855     0.200
    55.729    -0.047     0.200
    55.761    -0.210     0.200
    55.830    -0.472     0.200
    55.860    -0.201     0.200
    55.869     0.248     0.200
    55.957    -0.182     0.200
    56.088    -0.283     0.200
    56.158     0.080     0.200
    56.170    -0.208     0.200
    56.162    -0.593     0.200
    56.202    -0.858     0.200
    56.230    -0.318     0.200
    56.360    -0.367     0.200
    56.367     0.020     0.200
    56.403    -0.700     0.200
    56.410     0.478     0.200
    56.462    -0.093     0.200
    56.553    -0.036     0.200
    56.553     0.160     0.200
    56.701    -0.089     0.200
    56.713    -0.276     0.200
    56.741     0.061     0.200
    56.767     1.097     0.200
    56.793    -0.317     0.200
    56.797     2.473     0.200
    56.894    -0.264     0.200
    56.921    -0.554     0.200
    57.125    -1.299     0.200
    57.010    -0.384     0.200
    57.036    -1.227     0.200
    57.150     0.024     0.200
    57.153    -0.635     0.200
    57.176     0.338     0.200
    57.200    -0.128     0.200
    57.200    -0.430     0.200
    57.244    -0.536     0.200
    57.308     0.708     0.200
    57.332     0.541     0.200
    57.517     0.535     0.200
    57.532    -0.072     0.200
    57.539     0.381     0.200
    57.553    -0.221     0.200
    57.590    -0.477     0.200
    57.590    -1.278     0.200
    57.601     0.042     0.200
    57.622    -1.286     0.200
    57.701    -0.761     0.200
    57.782     0.069     0.200
    57.824     0.171     0.200
    57.928     0.748     0.200
    57.974    -0.578     0.200
    58.031    -0.490     0.200
    58.061    -1.107     0.200
    58.077    -0.400     0.200
    58.104     0.351     0.200
    58.212     1.834     0.200
    58.239    -0.045     0.200
    58.255     0.252     0.200
    58.273    -0.573     0.200
    58.277    -0.411     0.200
    58.297    -1.350     0.200
    58.342     0.448     0.200
    58.359    -1.486     0.200
    58.360    -1.140     0.200
    58.451    -0.232     0.200
    58.464     0.094     0.200
    58.495     0.180     0.200
    58.504     0.215     0.200
    58.542     0.651     0.200
    58.557    -1.457     0.200
    58.589    -0.106     0.200
    58.639     0.076     0.200
    58.644    -0.659     0.200
    58.668    -0.028     0.200
    58.719    -0.081     0.200
    58.873    -0.055     0.200
    58.990    -0.663     0.200
    59.139    -0.801     0.200
    59.139    -0.089     0.200
    59.217    -0.440     0.200
    59.221    -0.167     0.200
    59.242    -0.014     0.200
    59.271    -0.111     0.200
    59.665    -0.038     0.200
    59.894    -0.810     0.200
    59.975    -0.064     0.200
    60.070    -0.323     0.200
    60.071    -0.929     0.200
    60.071    -1.528     0.200
    60.223    -0.667     0.200
    60.352    -0.754     0.200
    60.352    -1.453     0.200
    60.517    -0.878     0.200
    60.528    -0.351     0.200
    60.840    -0.378     0.200
    60.961    -0.101     0.200
    60.997    -0.344     0.200
    61.403    -0.198     0.200
    61.403    -0.598     0.200
    61.849    -0.007     0.200
    61.849    -0.607     0.200
    62.358    -0.923     0.200
    62.545    -1.277     0.200
    62.546    -1.397     0.200
    62.752    -0.151     0.200
    62.752    -0.651     0.200
    62.884    -1.034     0.200
    62.884    -1.534     0.200
    62.895    -1.007     0.200
    63.254    -0.992     0.200
    63.360    -0.895     0.200
    64.011    -0.591     0.200
    64.130     0.731     0.200
    64.190     3.295     0.200
    64.241     0.101     0.200
    64.446    -0.944     0.200
    64.499    -1.191     0.200
    64.640    -0.611     0.200
    64.927     0.017     0.200
    65.484    -0.294     0.200
    65.584     0.107     0.200
    66.976    -2.469     0.200
    67.031     0.182     0.200
    67.389    -0.786     0.200
    67.403     0.320     0.200
    67.521     0.078     0.200
    67.798    -1.174     0.200
    67.727    -0.623     0.200
    68.468    -1.324     0.200
    69.102    -1.278     0.200
    69.295    -2.723     0.200
    69.341    -0.009     0.200
    70.212    -1.871     0.200
    70.613    -2.421     0.200
    71.105    -0.514     0.200
    71.477    -2.263     0.200
    71.446    -0.476     0.200
    71.647    -0.388     0.200
    71.655     0.262     0.200
    72.130    -1.386     0.200
    72.751     1.306     0.200
    73.377    -1.198     0.200
    74.923     0.578     0.200
    75.365     0.534     0.200
    75.774     0.187     0.200
    75.770    -0.618     0.200
    75.903    -0.559     0.200
    77.163    -0.170     0.200
    78.470    -0.762     0.200
    78.529     0.154     0.200
    78.672    -1.876     0.200
    78.873    -1.181     0.200
    80.390     0.476     0.200
    80.389    -1.392     0.200
    80.922    -0.476     0.200
    81.544    -0.981     0.200
    82.022    -0.698     0.200
    82.772     0.132     0.200
    82.823     0.681     0.200
    82.926     0.482     0.200
    83.137     0.349     0.200
    84.408    -1.516     0.200
    84.623    -0.405     0.200
    86.021     1.011     0.200
    86.905    -0.132     0.200
    87.131    -1.830     0.200
    90.353     1.146     0.200
    90.360    -0.687     0.200
    90.471     0.195     0.200
    90.485     0.130     0.200
    91.083    -0.749     0.200
    91.385    -0.752     0.200
    21.166     0.235     0.200
    46.580    -0.292     0.200
    46.995    -0.344     0.200
    49.600    -0.050     0.200
    52.366     0.137     0.200
    53.582    -0.437     0.200
    57.535    -0.070     0.200
    57.545    -0.136     0.200
    66.751    -0.122     0.200
    72.610     0.649     0.200
    75.752     0.213     0.200
    78.289    -0.644     0.200
    86.887    -1.758     0.200
    78.289    -0.062     0.200
    21.533     0.264     0.200
    23.671    -0.190     0.200
    46.199     0.346     0.200
    49.221    -0.006     0.200
    53.203    -0.404     0.200
    72.954    -1.356     0.200
    75.177    -1.554     0.200
    81.622    -0.265     0.200
    18.958     0.905     0.200
    21.036    -1.323     0.200
    21.222     0.678     0.200
    21.544     0.414     0.200
    23.677    -0.587     0.200
    24.386     1.440     0.200
    25.248    -0.213     0.200
    35.677     1.922     0.200
    36.703    -0.249     0.200
    38.791    -0.903     0.200
    46.195     0.195     0.200
    46.291     0.139     0.200
    46.611    -0.172     0.200
    49.219     0.330     0.200
    53.198    -0.935     0.200
    53.198    -0.834     0.200
    56.667    -0.737     0.200
    56.967    -0.566     0.200
    57.180     0.229     0.200
    57.189     0.163     0.200
    57.327    -0.111     0.200
    58.764    -1.181     0.200
    58.913    -0.719     0.200
    59.044    -0.828     0.200
    59.208    -0.863     0.200
    66.406     0.089     0.200
    72.963    -0.629     0.200
    72.982    -0.645     0.200
    75.185    -1.209     0.200
    75.186    -1.117     0.200
    77.095    -0.078     0.200
    78.380    -1.137     0.200
    85.710    -1.121     0.200
    88.216    -0.300     0.200
    49.219     0.061     0.200
    49.219    -0.006     0.200
    49.219     0.061     0.200
    21.476    -0.539     0.200
    21.895     0.561     0.200
    23.589    -0.834     0.200
    25.526     0.210     0.200
    27.491     1.011     0.200
    35.822     0.705     0.200
    36.735     0.502     0.200
    38.683    -0.477     0.200
    48.969    -0.263     0.200
    62.081    -0.579     0.200
    73.308    -0.421     0.200
    73.324    -0.217     0.200
    75.524    -0.716     0.200
    75.526    -0.925     0.200
    86.478    -1.989     0.200
    14.884     6.413     0.200
    18.894    -0.612     0.200
    18.966    -1.402     0.200
    20.241    -0.735     0.200
    20.771     0.920     0.200
    20.980    -0.545     0.200
    21.206    -0.719     0.200
    21.206     0.156     0.200
    21.206    -0.954     0.200
    21.200    -0.212     0.200
    21.339     0.783     0.200
    21.339    -0.342     0.200
    21.956     0.076     0.200
    23.330    -0.396     0.200
    23.535    -1.518     0.200
    23.535    -0.737     0.200
    23.789    -0.335     0.200
    24.307     0.724     0.200
    24.524    -1.547     0.200
    25.212    -0.810     0.200
    25.212    -1.091     0.200
    26.007     0.980     0.200
    25.960    -0.353     0.200
    26.551     0.268     0.200
    26.771     0.081     0.200
    26.806     1.264     0.200
    27.421     1.831     0.200
    27.408     0.505     0.200
    27.408     1.169     0.200
    27.778     0.437     0.200
    27.778     0.687     0.200
    28.004     1.522     0.200
    28.225     0.341     0.200
    28.438     0.353     0.200
    29.520     2.539     0.200
    29.435     0.796     0.200
    29.837    -0.770     0.200
    29.791     0.640     0.200
    30.075     0.123     0.200
    30.661     1.350     0.200
    30.781     2.390     0.200
    30.871     0.893     0.200
    31.130     0.312     0.200
    31.350     1.471     0.200
    31.350     0.674     0.200
    31.358     1.302     0.200
    31.648     0.449     0.200
    31.893     0.423     0.200
    31.893     0.587     0.200
    31.893     1.298     0.200
    31.904     1.501     0.200
    31.925     0.110     0.200
    32.130     0.718     0.200
    32.858     1.535     0.200
    33.077    -0.779     0.200
    33.671     0.534     0.200
    33.935     0.742     0.200
    34.458     1.811     0.200
    34.508     1.775     0.200
    35.042     0.660     0.200
    35.150     1.327     0.200
    35.355     1.466     0.200
    35.505     1.175     0.200
    35.603     2.329     0.200
    35.634     2.071     0.200
    35.751     1.064     0.200
    35.709     1.525     0.200
    35.709     0.455     0.200
    35.746     0.106     0.200
    35.787     0.755     0.200
    35.965     0.929     0.200
    36.225     1.500     0.200
    36.266    -0.848     0.200
    36.352    -0.083     0.200
    36.481     2.117     0.200
    36.778     0.187     0.200
    37.039     2.811     0.200
    37.094    -0.400     0.200
    37.192     2.375     0.200
    37.210     2.500     0.200
    37.224     2.528     0.200
    37.285     1.472     0.200
    37.306     2.400     0.200
    37.359     1.140     0.200
    37.435     2.444     0.200
    37.486     3.139     0.200
    37.493     1.607     0.200
    37.496     2.915     0.200
    37.528     1.713     0.200
    37.583     2.054     0.200
    37.641     2.829     0.200
    37.643     2.518     0.200
    37.640     2.690     0.200
    37.717     2.182     0.200
    37.882     1.925     0.200
    37.894     2.821     0.200
    37.931     1.964     0.200
    37.939     1.867     0.200
    37.952     0.126     0.200
    38.069     1.946     0.200
    38.108     2.019     0.200
    38.108     1.017     0.200
    38.161     3.255     0.200
    38.153     1.841     0.200
    38.258     1.356     0.200
    38.265     2.365     0.200
    38.279     1.868     0.200
    38.336     1.299     0.200
    38.344     1.822     0.200
    38.377     1.651     0.200
    38.349     0.982     0.200
    38.547     1.989     0.200
    38.530     0.665     0.200
    38.710     1.564     0.200
    38.599    -0.613     0.200
    38.730     1.887     0.200
    38.730     0.934     0.200
    38.703     2.010     0.200
    38.798     2.113     0.200
    38.863     1.563     0.200
    39.023    -0.473     0.200
    39.023     0.074     0.200
    39.023     0.527     0.200
    39.121     2.213     0.200
    39.491    -0.897     0.200
    39.491    -0.514     0.200
    39.543     1.984     0.200
    39.542     0.393     0.200
    40.037     0.577     0.200
    40.564     0.905     0.200
    40.849     0.157     0.200
    41.274     1.659     0.200
    41.295     0.488     0.200
    41.370     0.468     0.200
    41.438    -0.085     0.200
    41.453    -0.106     0.200
    41.509     2.934     0.200
    41.745     0.193     0.200
    41.745     1.216     0.200
    41.637     0.184     0.200
    41.659    -0.701     0.200
    41.621    -0.688     0.200
    41.621     0.453     0.200
    41.691     0.238     0.200
    41.825     3.143     0.200
    42.010     0.632     0.200
    41.985     0.832     0.200
    42.064     0.087     0.200
    42.131     0.537     0.200
    42.173    -0.572     0.200
    42.350     0.857     0.200
    42.398     0.465     0.200
    42.547     0.858     0.200
    42.555     0.689     0.200
    42.599     1.037     0.200
    42.651     1.411     0.200
    42.875     1.386     0.200
    43.143     3.421     0.200
    43.216     0.127     0.200
    43.283     0.291     0.200
    43.268     1.407     0.200
    43.364     0.636     0.200
    43.417     0.003     0.200
    43.475     2.738     0.200
    43.812     0.227     0.200
    43.824    -0.073     0.200
    43.923     0.637     0.200
    43.903     1.292     0.200
    43.903     2.081     0.200
    43.946     0.921     0.200
    44.204     1.879     0.200
    44.323     0.527     0.200
    44.523     2.421     0.200
    44.644     1.162     0.200
    44.756     0.349     0.200
    44.896    -0.074     0.200
    45.052     1.156     0.200
    45.189    -0.545     0.200
    45.189    -0.981     0.200
    45.377     1.531     0.200
    45.557     0.485     0.200
    45.639    -0.545     0.200
    45.643    -0.580     0.200
    45.643    -0.455     0.200
    45.760     0.098     0.200
    45.780     0.662     0.200
    45.829     0.842     0.200
    45.952     1.438     0.200
    45.952    -0.015     0.200
    45.996     0.634     0.200
    45.987     0.593     0.200
    46.098    -0.166     0.200
    46.280     0.511     0.200
    46.298     0.056     0.200
    46.299     0.091     0.200
    46.304     0.309     0.200
    46.304    -0.722     0.200
    46.393     0.512     0.200
    46.338    -0.256     0.200
    46.434    -0.409     0.200
    46.692     0.206     0.200
    46.718     0.002     0.200
    46.753    -0.210     0.200
    46.975    -0.369     0.200
    47.310     0.336     0.200
    47.431     1.396     0.200
    47.484     1.066     0.200
    47.547     0.996     0.200
    47.610     0.007     0.200
    47.791     1.104     0.200
    47.880    -0.886     0.200
    48.063     0.555     0.200
    48.121    -0.555     0.200
    48.342     0.015     0.200
    48.363     0.726     0.200
    48.440    -1.092     0.200
    48.551     0.226     0.200
    48.663     1.863     0.200
    48.686     1.200     0.200
    48.742     1.261     0.200
    48.740     0.771     0.200
    48.793    -0.326     0.200
    48.795     0.559     0.200
    48.877    -0.427     0.200
    48.939    -0.760     0.200
    49.019     0.135     0.200
    49.042     2.959     0.200
    48.971    -0.461     0.200
    48.971    -0.148     0.200
    49.027    -0.086     0.200
    49.107     1.255     0.200
    49.152     1.408     0.200
    49.185     0.859     0.200
    49.209    -0.343     0.200
    49.349    -0.192     0.200
    49.360     0.126     0.200
    49.435    -0.362     0.200
    49.578    -0.938     0.200
    49.578     0.335     0.200
    49.925     0.014     0.200
    49.914    -1.042     0.200
    50.008    -0.811     0.200
    50.320     1.120     0.200
    50.356     0.252     0.200
    50.445     0.075     0.200
    50.608    -0.054     0.200
    50.906     0.801     0.200
    50.774    -0.306     0.200
    50.774    -0.415     0.200
    50.863     1.420     0.200
    50.869    -2.418     0.200
    51.053     0.197     0.200
    51.191     1.302     0.200
    51.183     0.421     0.200
    51.212     1.528     0.200
    51.309     0.977     0.200
    51.377     1.465     0.200
    51.413    -0.108     0.200
    51.406     1.334     0.200
    51.465     0.904     0.200
    51.509     0.272     0.200
    51.556     0.922     0.200
    51.575     1.784     0.200
    51.563    -1.013     0.200
    51.647     0.841     0.200
    51.647     0.716     0.200
    51.788     0.393     0.200
    51.826     0.904     0.200
    51.843     0.382     0.200
    51.843     0.234     0.200
    51.849    -0.063     0.200
    51.853     0.499     0.200
    51.958     1.468     0.200
    51.968     1.142     0.200
    51.984     0.523     0.200
    51.980     1.157     0.200
    51.987     0.808     0.200
    52.082     0.501     0.200
    52.103    -2.936     0.200
    52.103     0.236     0.200
    52.138     0.383     0.200
    52.138     0.086     0.200
    52.135     0.138     0.200
    52.256     0.207     0.200
    52.195     0.159     0.200
    52.293    -0.370     0.200
    52.344     1.051     0.200
    52.422     0.471     0.200
    52.410    -0.145     0.200
    52.410    -0.309     0.200
    52.422    -0.132     0.200
    52.549    -0.265     0.200
    52.625     1.039     0.200
    52.602     1.842     0.200
    52.636     2.490     0.200
    52.621    -0.104     0.200
    52.652     0.668     0.200
    52.652     0.496     0.200
    52.730     0.394     0.200
    52.936     0.568     0.200
    52.990    -0.436     0.200
    53.061     0.452     0.200
    53.064     1.521     0.200
    53.117    -1.410     0.200
    53.179     0.671     0.200
    53.195     0.258     0.200
    53.250     0.499     0.200
    53.307     0.139     0.200
    53.313     0.292     0.200
    53.332     1.182     0.200
    53.333     0.243     0.200
    53.333     0.141     0.200
    53.362     0.132     0.200
    53.340    -0.808     0.200
    53.340    -0.909     0.200
    53.426     1.034     0.200
    53.429     1.017     0.200
    53.439     0.832     0.200
    53.479     1.183     0.200
    53.524     0.614     0.200
    53.541     0.811     0.200
    53.567    -0.179     0.200
    53.550     0.548     0.200
    53.554     0.551     0.200
    53.603     0.061     0.200
    53.590     0.607     0.200
    53.604     1.555     0.200
    53.605     1.377     0.200
    53.664     0.421     0.200
    53.676     1.128     0.200
    53.676     0.698     0.200
    53.684    -0.728     0.200
    53.700    -0.552     0.200
    53.715    -1.058     0.200
    53.789    -0.304     0.200
    53.812     0.631     0.200
    53.812     0.733     0.200
    53.840    -0.275     0.200
    53.978    -0.883     0.200
    54.009     1.792     0.200
    54.008     0.037     0.200
    54.037     1.083     0.200
    54.032    -0.982     0.200
    54.059     0.625     0.200
    54.132     1.097     0.200
    54.112    -1.221     0.200
    54.112    -0.775     0.200
    54.112    -1.041     0.200
    54.151    -0.449     0.200
    54.408     0.881     0.200
    54.510    -0.209     0.200
    54.664    -0.077     0.200
    54.655    -0.511     0.200
    54.684     0.578     0.200
    54.761     0.019     0.200
    54.777    -0.398     0.200
    54.866     0.352     0.200
    54.988    -0.024     0.200
    54.991    -0.346     0.200
    54.948    -0.237     0.200
    55.012    -1.292     0.200
    55.106     0.401     0.200
    55.120     0.075     0.200
    55.230    -0.279     0.200
    55.259    -0.682     0.200
    55.282    -0.548     0.200
    55.383     0.221     0.200
    55.393     0.353     0.200
    55.393     0.533     0.200
    55.473     0.575     0.200
    55.522    -0.576     0.200
    55.581     0.903     0.200
    55.568     0.270     0.200
    55.609    -0.420     0.200
    55.720    -0.304     0.200
    55.720    -1.000     0.200
    55.725    -0.633     0.200
    55.675    -0.772     0.200
    55.740    -0.840     0.200
    55.718     0.268     0.200
    55.740    -1.637     0.200
    55.740    -0.637     0.200
    55.740    -0.497     0.200
    55.753    -0.438     0.200
    55.752     1.175     0.200
    55.752     0.379     0.200
    55.835    -0.922     0.200
    55.886     1.010     0.200
    55.913    -0.380     0.200
    55.984    -0.451     0.200
    55.983    -0.382     0.200
    56.002     0.193     0.200
    56.015    -0.211     0.200
    56.022    -0.664     0.200
    56.014     0.617     0.200
    56.071    -0.317     0.200
    56.071     0.992     0.200
    56.167     1.201     0.200
    56.185     0.574     0.200
    56.216    -2.007     0.200
    56.248     1.124     0.200
    56.339    -1.731     0.200
    56.355    -0.240     0.200
    56.372    -0.559     0.200
    56.349     0.361     0.200
    56.373    -0.472     0.200
    56.369     0.556     0.200
    56.420    -1.103     0.200
    56.420    -0.306     0.200
    56.426     0.148     0.200
    56.438    -0.771     0.200
    56.439    -1.342     0.200
    56.467    -0.540     0.200
    56.479    -1.500     0.200
    56.540    -0.254     0.200
    56.559    -0.474     0.200
    56.629     0.291     0.200
    56.645    -0.000     0.200
    56.755     0.057     0.200
    56.747     0.072     0.200
    56.768    -0.318     0.200
    56.801    -1.113     0.200
    56.883    -0.215     0.200
    56.905     0.693     0.200
    56.906     0.661     0.200
    56.942     0.655     0.200
    56.942     0.444     0.200
    56.989     0.561     0.200
    57.007    -0.068     0.200
    57.028    -0.647     0.200
    57.065     1.315     0.200
    57.075     0.146     0.200
    57.091    -1.099     0.200
    57.098     0.083     0.200
    57.102    -1.047     0.200
    57.109     0.290     0.200
    57.153     1.487     0.200
    57.172    -0.268     0.200
    57.173    -1.348     0.200
    57.250     1.105     0.200
    57.264    -0.209     0.200
    57.312    -0.227     0.200
    57.321    -0.293     0.200
    57.360     1.029     0.200
    57.369     1.068     0.200
    57.454     0.465     0.200
    57.458    -1.360     0.200
    57.481     1.342     0.200
    57.541    -0.443     0.200
    57.586     1.341     0.200
    57.715    -0.565     0.200
    57.800    -1.167     0.200
    57.860    -0.543     0.200
    57.860     0.598     0.200
    57.949    -1.213     0.200
    57.983     0.266     0.200
    58.036    -1.324     0.200
    58.059     1.174     0.200
    58.113    -0.662     0.200
    58.879     0.794     0.200
    58.886    -0.755     0.200
    58.898    -1.438     0.200
    59.000    -2.748     0.200
    59.047    -1.173     0.200
    59.178    -1.187     0.200
    59.342    -1.215     0.200
    59.349     0.837     0.200
    59.405     0.913     0.200
    59.641    -0.473     0.200
    59.662     0.780     0.200
    59.708    -0.638     0.200
    59.699     0.541     0.200
    59.735    -1.121     0.200
    59.744     1.206     0.200
    59.779     1.073     0.200
    59.781     0.703     0.200
    59.817     1.006     0.200
    60.073    -1.146     0.200
    60.227    -0.702     0.200
    60.218     0.562     0.200
    60.218     0.062     0.200
    60.239     0.812     0.200
    60.239     0.234     0.200
    60.351     0.051     0.200
    60.474     0.003     0.200
    60.501     0.063     0.200
    60.492     0.226     0.200
    60.550     0.050     0.200
    60.667    -0.508     0.200
    60.742     0.484     0.200
    60.747     0.393     0.200
    60.751    -0.125     0.200
    60.752     0.056     0.200
    60.758     0.375     0.200
    60.758     0.148     0.200
    60.865     0.837     0.200
    60.860     0.475     0.200
    60.860     0.186     0.200
    60.860     0.874     0.200
    60.860     0.397     0.200
    60.866     0.137     0.200
    60.881    -0.190     0.200
    60.905    -0.050     0.200
    60.915     0.041     0.200
    60.950     1.365     0.200
    60.944    -0.392     0.200
    60.950    -0.361     0.200
    60.950     0.499     0.200
    60.961     0.572     0.200
    60.933    -1.024     0.200
    60.960     0.790     0.200
    60.979    -0.734     0.200
    60.965    -0.165     0.200
    61.005    -0.010     0.200
    61.005    -0.112     0.200
    61.004     0.225     0.200
    61.080     0.483     0.200
    61.072     0.247     0.200
    61.091    -0.091     0.200
    61.090    -0.128     0.200
    61.195    -1.400     0.200
    61.193     0.559     0.200
    61.203    -0.004     0.200
    61.229     0.670     0.200
    61.227     0.657     0.200
    61.241     0.544     0.200
    61.263     0.061     0.200
    61.272     0.176     0.200
    61.272     0.067     0.200
    61.305     1.355     0.200
    61.318     0.070     0.200
    61.318    -0.031     0.200
    61.350    -0.108     0.200
    61.384    -1.577     0.200
    61.407     0.358     0.200
    61.419    -0.214     0.200
    61.423     0.556     0.200
    61.423     0.056     0.200
    61.429     0.226     0.200
    61.434    -0.688     0.200
    61.434    -1.415     0.200
    61.452     0.003     0.200
    61.463    -1.011     0.200
    61.463    -0.370     0.200
    61.474    -0.054     0.200
    61.504     0.410     0.200
    61.479     0.061     0.200
    61.485    -0.056     0.200
    61.521    -0.042     0.200
    61.530     0.072     0.200
    61.571    -0.543     0.200
    61.573     0.357     0.200
    61.597     1.087     0.200
    61.618     0.224     0.200
    61.619    -0.117     0.200
    61.682     0.224     0.200
    61.683     0.223     0.200
    61.689     0.384     0.200
    61.722    -1.360     0.200
    61.721    -1.453     0.200
    61.746     0.330     0.200
    61.773     0.221     0.200
    61.777     0.062     0.200
    61.805     0.052     0.200
    61.809     0.192     0.200
    61.837     0.342     0.200
    61.865     0.076     0.200
    61.853     0.054     0.200
    61.853    -0.142     0.200
    61.892     0.037     0.200
    61.889     0.310     0.200
    61.889     0.044     0.200
    61.934     0.238     0.200
    61.947     0.045     0.200
    61.956     0.164     0.200
    61.980     0.147     0.200
    62.018     0.154     0.200
    62.056     0.167     0.200
    62.061     0.396     0.200
    62.096     0.135     0.200
    62.098     0.020     0.200
    62.108    -0.160     0.200
    62.108    -0.363     0.200
    62.136     0.155     0.200
    62.133    -0.233     0.200
    62.137    -0.466     0.200
    62.144    -0.203     0.200
    62.191     0.057     0.200
    62.231    -0.112     0.200
    62.262    -0.521     0.200
    62.275    -0.073     0.200
    62.292     0.355     0.200
    62.292    -0.895     0.200
    62.292    -0.403     0.200
    62.280    -0.044     0.200
    62.298    -0.230     0.200
    62.298    -0.519     0.200
    62.314     0.944     0.200
    62.422    -0.960     0.200
    62.422    -1.210     0.200
    62.322    -0.046     0.200
    62.349    -0.472     0.200
    62.351     0.062     0.200
    62.364    -0.174     0.200
    62.364    -0.393     0.200
    62.384    -1.511     0.200
    62.364     0.155     0.200
    62.411     0.062     0.200
    62.416     0.452     0.200
    62.451     1.327     0.200
    62.443     0.402     0.200
    62.443     0.168     0.200
    62.411    -0.692     0.200
    62.484     0.616     0.200
    62.517     0.300     0.200
    62.536     0.000     0.200
    62.548     0.398     0.200
    62.548     0.234     0.200
    62.566     1.273     0.200
    62.569     1.057     0.200
    62.569     0.299     0.200
    62.575    -0.023     0.200
    62.648     1.035     0.200
    62.629     0.166     0.200
    62.650     0.998     0.200
    62.658     0.387     0.200
    62.705     0.450     0.200
    62.693     0.137     0.200
    62.725     0.062     0.200
    62.722     0.214     0.200
    62.742     0.405     0.200
    62.742     0.233     0.200
    62.781     0.355     0.200
    62.812     0.376     0.200
    62.849    -1.112     0.200
    62.886     0.563     0.200
    62.883     0.364     0.200
    62.883     0.067     0.200
    62.937     1.006     0.200
    62.997     1.105     0.200
    63.054    -0.475     0.200
    63.084     1.328     0.200
    63.096     0.649     0.200
    63.148     0.032     0.200
    63.222     0.314     0.200
    63.270    -0.052     0.200
    63.285    -1.306     0.200
    63.312     1.316     0.200
    63.336    -1.539     0.200
    63.437     0.489     0.200
    63.454    -0.527     0.200
    63.537     0.413     0.200
    63.650     0.482     0.200
    63.724    -0.298     0.200
    63.786     0.711     0.200
    63.786     0.492     0.200
    63.861     0.989     0.200
    63.906     1.388     0.200
    63.919    -0.291     0.200
    63.936    -0.197     0.200
    63.947    -0.361     0.200
    63.947    -0.131     0.200
    63.950     0.510     0.200
    63.950    -0.162     0.200
    63.973    -0.129     0.200
    63.978    -0.403     0.200
    63.979    -0.066     0.200
    64.000    -0.197     0.200
    64.086     1.114     0.200
    64.206    -0.273     0.200
    64.274     1.176     0.200
    64.399    -0.143     0.200
    64.338     0.859     0.200
    64.390     1.420     0.200
    64.510     0.838     0.200
    64.770     0.729     0.200
    65.090     0.579     0.200
    65.308     1.143     0.200
    65.730    -1.396     0.200
    65.730    -0.763     0.200
    65.836     1.027     0.200
    66.192     0.937     0.200
    66.206     0.645     0.200
    66.224    -2.468     0.200
    66.534    -0.253     0.200
    66.534     0.442     0.200
    66.858     0.251     0.200
    66.946     0.813     0.200
    67.108     0.591     0.200
    67.270     0.959     0.200
    67.381     0.055     0.200
    67.522     0.062     0.200
    67.551     1.083     0.200
    67.591    -0.466     0.200
    67.801     1.207     0.200
    67.912     0.909     0.200
    68.065    -1.159     0.200
    68.146     0.835     0.200
    68.174     0.656     0.200
    68.584     0.992     0.200
    68.854    -0.589     0.200
    68.832    -0.156     0.200
    68.824     2.296     0.200
    68.824     1.343     0.200
    68.961     0.244     0.200
    68.991     0.762     0.200
    69.336     0.623     0.200
    69.568     1.279     0.200
    69.740     0.719     0.200
    69.977     0.967     0.200
    70.129     3.529     0.200
    70.348    -0.807     0.200
    70.314     1.194     0.200
    70.318     0.876     0.200
    70.361     0.714     0.200
    70.559     0.698     0.200
    70.604     1.627     0.200
    70.622     0.815     0.200
    70.625     1.898     0.200
    70.784     1.030     0.200
    70.792     1.281     0.200
    71.034     0.612     0.200
    71.253    -0.813     0.200
    71.205    -0.625     0.200
    71.668    -1.215     0.200
    72.520    -0.626     0.200
    72.520    -2.313     0.200
    72.833     0.214     0.200
    74.160     1.203     0.200
    74.591     1.100     0.200
    75.052    -0.372     0.200
    75.052    -1.454     0.200
    75.596    -1.015     0.200
    75.772    -1.010     0.200
    76.110     0.273     0.200
    76.110     1.336     0.200
    76.487     0.928     0.200
    77.053    -0.307     0.200
    78.073     1.133     0.200
    78.082    -0.917     0.200
    78.082    -0.792     0.200
    78.130    -0.906     0.200
    78.130    -1.008     0.200
    78.222     0.574     0.200
    78.353     0.381     0.200
    78.445     0.778     0.200
    78.542    -1.269     0.200
    78.869     1.039     0.200
    80.251    -1.550     0.200
    80.516     1.197     0.200
    80.754    -0.082     0.200
    80.907     0.183     0.200
    80.905     1.214     0.200
    81.588     0.089     0.200
    81.588     0.276     0.200
    81.686     0.469     0.200
    81.739     0.618     0.200
    81.839     0.589     0.200
    82.054     0.463     0.200
    81.965    -1.057     0.200
    82.190     1.418     0.200
    82.427     1.682     0.200
    82.528     1.150     0.200
    83.070     2.339     0.200
    83.548    -0.027     0.200
    83.548     0.450     0.200
    85.575    -1.077     0.200
    85.769     0.664     0.200
    86.718     0.047     0.200
    86.693    -1.689     0.200
    88.022     0.235     0.200
    90.212    -0.596     0.200
    91.543     1.518     0.200
    92.795     0.533     0.200
    93.151    -3.208     0.200
    93.841    -0.096     0.200
    95.157    -1.085     0.200
    98.548    -3.369     0.200
    98.492    -0.619     0.200
    98.797    -1.241     0.200
    99.537    -0.582     0.200
    21.883     0.925     0.200
    14.949     5.797     0.200
    18.933    -0.911     0.200
    19.003    -1.174     0.200
    20.985    -0.270     0.200
    21.223    -0.336     0.200
    21.324     0.578     0.200
    21.324     0.680     0.200
    21.883     0.315     0.200
    23.861    -0.730     0.200
    24.299     0.563     0.200
    24.597    -1.650     0.200
    25.228    -0.595     0.200
    26.612     1.473     0.200
    26.828    -0.379     0.200
    27.447     1.058     0.200
    28.037     0.778     0.200
    29.861    -0.421     0.200
    29.861    -0.523     0.200
    30.083     0.612     0.200
    30.825     1.052     0.200
    31.381     0.756     0.200
    31.695     0.388     0.200
    31.933     0.591     0.200
    31.939     0.342     0.200
    31.947    -0.028     0.200
    33.684     1.273     0.200
    35.756     0.860     0.200
    35.756     0.563     0.200
    35.798     0.707     0.200
    36.327    -0.324     0.200
    36.841     0.592     0.200
    37.127    -0.842     0.200
    37.901     2.201     0.200
    38.088     2.225     0.200
    38.275     0.442     0.200
    38.300     2.237     0.200
    38.396     1.837     0.200
    38.765     0.532     0.200
    38.980    -0.478     0.200
    39.084     0.457     0.200
    41.659    -1.167     0.200
    42.396    -0.486     0.200
    42.396     0.413     0.200
    43.411     1.287     0.200
    43.411     2.084     0.200
    43.462    -0.024     0.200
    43.950     0.151     0.200
    43.950     1.846     0.200
    44.250     1.536     0.200
    44.569     1.627     0.200
    45.714    -0.109     0.200
    46.402    -0.436     0.200
    46.499    -0.196     0.200
    46.570    -0.452     0.200
    46.817    -0.289     0.200
    47.352     0.034     0.200
    47.920    -0.381     0.200
    48.174     0.160     0.200
    48.820    -0.618     0.200
    49.430    -0.095     0.200
    49.630    -0.623     0.200
    49.984    -0.968     0.200
    49.984     1.079     0.200
    50.409     0.566     0.200
    50.916    -0.158     0.200
    51.102    -0.056     0.200
    51.241     0.296     0.200
    51.562     0.096     0.200
    51.633    -0.856     0.200
    51.836     0.444     0.200
    51.901     0.859     0.200
    51.899    -0.227     0.200
    52.028     1.372     0.200
    52.129    -0.040     0.200
    52.189     0.218     0.200
    52.189     0.515     0.200
    52.247     0.288     0.200
    52.470     0.497     0.200
    52.465    -0.830     0.200
    52.598     0.079     0.200
    52.788     0.974     0.200
    53.039     0.037     0.200
    53.097     0.495     0.200
    53.223     0.848     0.200
    53.186    -0.069     0.200
    53.361     0.653     0.200
    53.404    -1.061     0.200
    53.404    -0.061     0.200
    53.647     0.480     0.200
    53.728     0.957     0.200
    53.744     0.015     0.200
    53.733    -0.886     0.200
    53.862     1.169     0.200
    54.083     1.230     0.200
    54.082    -1.132     0.200
    54.177     1.501     0.200
    54.200    -0.095     0.200
    54.555    -0.519     0.200
    54.732     0.935     0.200
    54.826    -0.441     0.200
    55.040    -0.398     0.200
    55.057    -0.887     0.200
    55.005    -0.040     0.200
    55.013    -0.001     0.200
    55.280    -0.428     0.200
    55.331    -0.589     0.200
    55.572    -0.729     0.200
    55.627     1.526     0.200
    55.771    -0.856     0.200
    55.788    -0.503     0.200
    55.803    -0.389     0.200
    55.962    -0.431     0.200
    56.072    -0.615     0.200
    56.087    -0.080     0.200
    56.383    -1.339     0.200
    56.471    -0.566     0.200
    56.487    -0.828     0.200
    56.589    -0.302     0.200
    56.694     0.054     0.200
    56.795     0.129     0.200
    56.852    -0.774     0.200
    56.995     1.355     0.200
    57.056    -0.115     0.200
    57.111     0.491     0.200
    57.123     0.109     0.200
    57.147     0.038     0.200
    57.153    -0.701     0.200
    57.200     0.765     0.200
    57.296     0.385     0.200
    57.322     0.649     0.200
    57.360     0.132     0.200
    57.369    -0.036     0.200
    57.408     0.691     0.200
    57.505    -0.893     0.200
    57.590    -0.289     0.200
    57.768    -0.243     0.200
    57.846    -0.893     0.200
    57.914     0.607     0.200
    57.995    -1.032     0.200
    58.084    -1.156     0.200
    58.166    -0.331     0.200
    58.934    -0.392     0.200
    58.949    -1.187     0.200
    59.097    -0.816     0.200
    59.229    -0.935     0.200
    59.392    -0.960     0.200
    59.398     0.496     0.200
    59.688    -0.205     0.200
    59.711     0.337     0.200
    59.785    -0.966     0.200
    59.828     0.738     0.200
    59.866     0.472     0.200
    60.276    -0.443     0.200
    60.715    -0.145     0.200
    60.993    -0.134     0.200
    61.026    -0.359     0.200
    61.248    -1.058     0.200
    61.437    -1.235     0.200
    61.493    -0.180     0.200
    61.493    -0.617     0.200
    61.619    -0.274     0.200
    61.772    -1.104     0.200
    61.773    -1.210     0.200
    62.431    -1.330     0.200
    62.484    -1.081     0.200
    62.902    -0.766     0.200
    63.101    -0.090     0.200
    63.338    -1.164     0.200
    63.388    -1.293     0.200
    63.502    -0.144     0.200
    65.624    -0.723     0.200
    66.579     0.146     0.200
    66.636    -0.825     0.200
    68.004    -3.290     0.200
    71.274     0.138     0.200
    75.000    -0.793     0.200
    75.002    -0.802     0.200
    75.664    -1.251     0.200
    76.429    -0.965     0.200
    77.119     0.534     0.200
    78.035     0.019     0.200
    78.198    -1.441     0.200
    78.613    -1.084     0.200
    81.548    -0.353     0.200
    81.694     0.391     0.200
    81.747     0.557     0.200
    81.848     0.526     0.200
    82.061     0.481     0.200
    85.523    -2.656     0.200
    86.766    -1.791     0.200
    90.284    -0.373     0.200
    91.497    -0.512     0.200
    92.745    -0.483     0.200
    14.936     6.949     0.200
    18.914    -0.767     0.200
    19.001    -0.723     0.200
    20.994     0.073     0.200
    21.226     0.564     0.200
    21.338     0.863     0.200
    24.311     0.370     0.200
    24.579    -1.774     0.200
    25.233    -0.526     0.200
    26.819     0.618     0.200
    27.453     0.952     0.200
    29.839     0.389     0.200
    30.805     3.139     0.200
    35.751     1.415     0.200
    36.829     0.507     0.200
    38.810     1.164     0.200
    39.062     0.150     0.200
    42.831    -0.511     0.200
    43.458    -0.390     0.200
    45.692    -0.532     0.200
    46.380    -0.164     0.200
    46.477    -0.017     0.200
    46.795    -0.213     0.200
    48.153     0.124     0.200
    49.408     0.076     0.200
    49.962    -0.798     0.200
    49.962     1.264     0.200
    51.879     0.031     0.200
    51.875     0.555     0.200
    52.168     0.273     0.200
    52.226     0.344     0.200
    52.443    -0.171     0.200
    52.649    -0.094     0.200
    53.366     0.416     0.200
    53.387     0.158     0.200
    53.382    -1.202     0.200
    53.382    -0.905     0.200
    53.627    -0.209     0.200
    53.724    -0.816     0.200
    53.713    -0.632     0.200
    53.707     0.612     0.200
    54.063     0.806     0.200
    54.061    -1.082     0.200
    54.157     1.016     0.200
    54.806    -0.299     0.200
    55.020    -0.249     0.200
    55.037    -1.070     0.200
    54.996    -0.272     0.200
    55.260    -0.279     0.200
    55.425    -0.277     0.200
    55.551    -0.581     0.200
    55.768    -0.637     0.200
    55.782    -0.343     0.200
    56.052    -0.569     0.200
    56.450    -0.120     0.200
    56.673     0.200     0.200
    56.775     0.173     0.200
    56.831    -0.525     0.200
    57.103     0.246     0.200
    57.126     0.183     0.200
    57.132    -0.461     0.200
    57.340     0.377     0.200
    57.349     0.311     0.200
    57.485    -0.650     0.200
    57.570     0.356     0.200
    57.747     0.108     0.200
    57.826    -0.652     0.200
    57.975    -0.697     0.200
    58.064    -0.819     0.200
    58.145    -0.184     0.200
    58.914    -0.150     0.200
    58.928    -0.951     0.200
    59.076    -0.479     0.200
    59.208    -0.691     0.200
    59.371    -0.717     0.200
    59.668    -0.567     0.200
    59.764    -0.732     0.200
    60.256    -0.210     0.200
    61.227    -0.824     0.200
    61.416    -0.604     0.200
    61.471    -0.676     0.200
    61.599    -0.138     0.200
    61.752    -0.873     0.200
    61.752    -0.970     0.200
    62.881    -0.528     0.200
    63.317    -0.832     0.200
    65.645    -1.066     0.200
    66.559    -0.131     0.200
    66.656    -1.251     0.200
    75.021    -0.827     0.200
    75.023    -0.938     0.200
    78.040    -0.323     0.200
    78.184    -0.550     0.200
    78.596    -0.902     0.200
    81.682     0.241     0.200
    81.735     0.453     0.200
    81.836     0.321     0.200
    82.049     0.298     0.200
    85.544    -0.671     0.200
    86.748    -1.819     0.200
    90.262    -0.888     0.200
    49.408    -0.096     0.200
    49.408     0.052     0.200
    49.408    -0.018     0.200
    49.408    -0.034     0.200
    49.408    -0.018     0.200
    29.839     0.053     0.200
    29.839    -0.010     0.200
    75.023     0.007     0.200
    75.023     0.007     0.200
    75.023     0.007     0.200
    75.023     0.007     0.200
    75.023     0.015     0.200
    46.380     0.047     0.200
    46.380     0.047     0.200
    46.380     0.047     0.200
    46.380     0.047     0.200
    46.380     0.047     0.200
    46.380     0.047     0.200
    46.380     0.047     0.200
    46.380     0.024     0.200
    46.380     0.000     0.200
    46.380     0.016     0.200
    52.168     0.039     0.200
    52.168     0.023     0.200
    52.168     0.094     0.200
    52.168     0.055     0.200
    21.338     0.019     0.200
    21.338     0.019     0.200
    45.692     0.054     0.200
    45.692    -0.095     0.200
    54.996    -0.132     0.200
    53.382     0.048     0.200
    53.382     0.048     0.200
    53.382     0.048     0.200
    53.382    -0.007     0.200
    53.382     0.017     0.200
    53.382     0.001     0.200
    53.382     0.071     0.200
    39.062     0.048     0.200
    39.062     0.048     0.200
    39.062     0.079     0.200
    85.544     0.001     0.200
    85.544    -0.030     0.200
    27.453    -0.134     0.200
    27.453    -0.548     0.200
    27.453    -0.048     0.200
    25.233     0.036     0.200
    25.233    -0.026     0.200
    86.748     0.040     0.200
    86.748     0.040     0.200
    86.748    -0.069     0.200
    46.507    -0.441     0.200
    46.825    -0.234     0.200
    53.412    -1.305     0.200
    57.373     0.167     0.200
    57.382     0.101     0.200
    57.859    -0.759     0.200
    74.990    -0.801     0.200
    74.990     0.019     0.200
    74.990     0.019     0.200
    74.990     0.035     0.200
    74.990     0.019     0.200
    74.990     0.027     0.200
    74.990     0.066     0.200
    74.990     0.011     0.200
    21.307     0.050     0.200
    86.763    -0.199     0.200
    38.981    -2.804     0.200
    46.410    -0.026     0.200
    14.796     6.535     0.200
    21.020    -0.445     0.200
    25.233    -0.218     0.200
    27.358    -0.092     0.200
    38.791    -2.765     0.200
    46.206     0.036     0.200
    46.301     0.086     0.200
    49.227     0.391     0.200
    52.017    -0.568     0.200
    53.209    -1.395     0.200
    53.209    -0.895     0.200
    56.299     0.599     0.200
    56.681    -0.427     0.200
    56.981    -0.253     0.200
    57.195     0.434     0.200
    57.204     0.368     0.200
    57.342    -0.606     0.200
    58.928    -0.407     0.200
    59.059    -0.621     0.200
    59.222    -1.153     0.200
    60.107    -0.651     0.200
    61.073    -0.738     0.200
    61.453    -0.014     0.200
    66.421     0.094     0.200
    78.125    -0.440     0.200
    86.579    -1.629     0.200
    53.209     0.042     0.200
    53.209    -0.036     0.200
    27.358    -0.115     0.200
    23.852    -0.887     0.200
    38.971    -2.536     0.200
    46.386    -0.056     0.200
    49.415     0.276     0.200
    52.171     0.298     0.200
    53.386    -0.694     0.200
    57.342     0.404     0.200
    57.351     0.440     0.200
    75.020    -0.979     0.200
    81.679     0.396     0.200
    86.757    -0.622     0.200
    49.415    -0.037     0.200
    75.020    -0.002     0.200
    75.020     0.006     0.200
    75.020    -0.002     0.200
    75.020    -0.002     0.200
    46.386     0.022     0.200
    46.386     0.038     0.200
    46.386     0.022     0.200
    52.171     0.025     0.200
    53.386     0.025     0.200
    86.757    -0.051     0.200
    23.852     0.082     0.200
    18.973     0.562     0.200
    21.196     0.371     0.200
    23.835    -0.658     0.200
    35.726     0.664     0.200
    36.811     0.592     0.200
    38.955    -1.620     0.200
    46.393     0.186     0.200
    49.415     0.368     0.200
    75.002    -0.546     0.200
    78.586    -1.468     0.200
    81.712     0.260     0.200
    23.835    -0.731     0.200
    14.906     6.860     0.200
    21.259    -0.210     0.200
    25.274    -0.779     0.200
    38.907     0.074     0.200
    46.298    -0.072     0.200
    46.395     0.066     0.200
    46.712     0.078     0.200
    48.853    -1.029     0.200
    49.330     0.216     0.200
    52.084     0.246     0.200
    53.298    -0.843     0.200
    53.298    -0.843     0.200
    56.747    -0.977     0.200
    57.048    -0.910     0.200
    57.256     0.618     0.200
    57.265     0.552     0.200
    61.387    -0.551     0.200
    66.476     0.358     0.200
    72.889    -0.380     0.200
    72.905    -0.077     0.200
    75.107    -0.753     0.200
    86.695    -1.581     0.200
    90.186    -1.256     0.200
    49.330     0.023     0.200
    49.330     0.044     0.200
    49.330    -0.067     0.200
    49.330    -0.005     0.200
    49.330     0.073     0.200
    46.298     0.012     0.200
    46.298     0.088     0.200
    46.298    -0.007     0.200
    46.298     0.043     0.200
    53.298     0.124     0.200
    53.298    -0.017     0.200
    53.298    -0.075     0.200
    53.298     0.003     0.200
    53.298     0.081     0.200
    53.298     0.038     0.200
    14.940     7.444     0.200
    21.410     0.523     0.200
    46.373    -0.013     0.200
    46.788     0.338     0.200
    49.403     0.113     0.200
    52.158    -0.656     0.200
    53.374    -1.147     0.200
    57.330    -0.052     0.200
    57.339    -0.017     0.200
    62.394    -0.174     0.200
    72.815    -0.289     0.200
    72.832    -0.387     0.200
    75.032    -0.872     0.200
    78.530    -1.114     0.200
    86.748    -1.692     0.200
    21.410    -0.294     0.200
    21.410    -0.012     0.200
    46.373    -0.080     0.200
    46.373     0.022     0.200
    72.815     0.035     0.200
    72.815     0.012     0.200
    72.815     0.004     0.200
    21.358     0.472     0.200
    23.811    -0.503     0.200
    29.840     0.836     0.200
    38.933    -0.493     0.200
    46.392    -0.471     0.200
    46.488    -0.222     0.200
    49.409     0.262     0.200
    52.199    -0.264     0.200
    53.396    -0.915     0.200
    57.373    -0.166     0.200
    57.383    -0.134     0.200
    72.770    -1.031     0.200
    74.991    -1.739     0.200
    78.485    -1.472     0.200
    49.409     0.019     0.200
    72.770    -0.004     0.200
    14.935     8.074     0.200
    18.945    -2.331     0.200
    18.984    -0.762     0.200
    20.967     0.438     0.200
    21.204     0.083     0.200
    21.308     0.466     0.200
    21.368     0.416     0.200
    21.893     0.001     0.200
    23.851    -1.277     0.200
    24.282     0.488     0.200
    24.588    -1.297     0.200
    25.209    -0.155     0.200
    26.596     1.087     0.200
    26.812     0.336     0.200
    26.821     0.462     0.200
    27.442     1.230     0.200
    27.821     0.585     0.200
    28.019     1.518     0.200
    28.277     1.920     0.200
    28.232     0.316     0.200
    29.504     1.010     0.200
    29.860     0.145     0.200
    29.860     0.653     0.200
    30.064     0.849     0.200
    30.836     1.238     0.200
    31.362     1.099     0.200
    31.370     0.531     0.200
    31.705     0.182     0.200
    31.949     0.932     0.200
    33.114     0.727     0.200
    33.665     0.920     0.200
    34.555     1.492     0.200
    35.739     1.500     0.200
    35.779     1.151     0.200
    36.312    -0.407     0.200
    36.826     0.308     0.200
    37.108    -0.192     0.200
    37.323     1.083     0.200
    37.917     1.561     0.200
    38.104     1.585     0.200
    38.159     2.413     0.200
    38.291     1.004     0.200
    38.315     1.498     0.200
    38.380     1.554     0.200
    38.411     1.292     0.200
    38.400     0.488     0.200
    38.617    -0.436     0.200
    38.769    -0.216     0.200
    38.913    -0.124     0.200
    38.912     0.287     0.200
    38.971    -0.706     0.200
    39.089     0.105     0.200
    40.493     0.424     0.200
    42.043    -1.313     0.200
    43.444     0.216     0.200
    43.892    -0.286     0.200
    43.975     0.041     0.200
    44.945    -0.212     0.200
    45.301    -0.039     0.200
    45.235    -0.915     0.200
    45.691    -0.629     0.200
    45.713    -0.303     0.200
    46.005    -0.108     0.200
    46.150    -0.753     0.200
    46.368    -0.363     0.200
    46.405    -0.258     0.200
    46.502    -0.014     0.200
    46.581    -0.238     0.200
    46.820    -0.308     0.200
    47.363    -0.748     0.200
    47.932    -1.164     0.200
    48.182    -0.798     0.200
    49.049    -0.971     0.200
    49.057    -1.038     0.200
    49.246     0.326     0.200
    49.430     0.116     0.200
    49.638    -0.376     0.200
    49.984    -0.760     0.200
    50.271    -0.077     0.200
    50.417    -0.182     0.200
    50.926    -0.122     0.200
    50.797    -0.850     0.200
    51.111     0.187     0.200
    51.247    -0.437     0.200
    51.360     0.715     0.200
    51.515     0.350     0.200
    51.570     0.348     0.200
    51.606    -0.423     0.200
    51.633    -0.644     0.200
    51.846     0.382     0.200
    51.879     0.377     0.200
    51.911     0.601     0.200
    51.908    -0.082     0.200
    51.904     0.447     0.200
    52.023    -0.443     0.200
    52.034    -0.315     0.200
    52.040     0.828     0.200
    52.134     0.042     0.200
    52.197     0.367     0.200
    52.197     0.070     0.200
    52.255     0.540     0.200
    52.351    -0.469     0.200
    52.479    -0.229     0.200
    52.472    -0.275     0.200
    52.508    -1.613     0.200
    52.607    -0.073     0.200
    52.679    -0.103     0.200
    52.666    -0.614     0.200
    52.794     0.338     0.200
    53.045    -0.812     0.200
    53.048    -0.333     0.200
    53.233     0.303     0.200
    53.361     0.064     0.200
    53.394     0.322     0.200
    53.417     0.249     0.200
    53.407    -0.874     0.200
    53.407    -0.874     0.200
    53.657    -0.109     0.200
    53.754    -0.724     0.200
    53.736     0.815     0.200
    53.742    -0.636     0.200
    53.773    -0.959     0.200
    53.871     0.328     0.200
    53.898    -0.073     0.200
    54.037    -0.789     0.200
    54.093     0.800     0.200
    54.187     1.111     0.200
    54.209    -0.447     0.200
    54.179    -1.099     0.200
    54.473     0.132     0.200
    54.565    -0.871     0.200
    54.713    -0.410     0.200
    54.742     0.488     0.200
    54.822     0.103     0.200
    54.835    -0.291     0.200
    55.049    -0.240     0.200
    55.047     0.073     0.200
    55.067    -1.173     0.200
    54.988    -0.105     0.200
    55.289    -0.275     0.200
    55.319    -0.683     0.200
    55.340    -0.438     0.200
    55.443    -0.080     0.200
    55.454     0.138     0.200
    55.532    -0.128     0.200
    55.581    -0.569     0.200
    55.637     0.821     0.200
    55.780    -0.802     0.200
    55.797    -0.625     0.200
    55.812    -0.330     0.200
    55.812     0.271     0.200
    55.894    -0.918     0.200
    55.946    -0.095     0.200
    56.040    -1.342     0.200
    56.043    -0.292     0.200
    56.081    -0.562     0.200
    56.076     0.281     0.200
    56.086    -0.399     0.200
    56.130    -0.611     0.200
    56.083    -0.485     0.200
    56.230     1.077     0.200
    56.247     0.158     0.200
    56.312    -1.106     0.200
    56.394    -0.992     0.200
    56.415     0.551     0.200
    56.430    -0.310     0.200
    56.431    -0.558     0.200
    56.429    -0.740     0.200
    56.480    -0.704     0.200
    56.485    -0.448     0.200
    56.495    -2.004     0.200
    56.497    -1.528     0.200
    56.523    -1.117     0.200
    56.590    -0.591     0.200
    56.598    -0.148     0.200
    56.615    -1.456     0.200
    56.669    -0.299     0.200
    56.703     0.208     0.200
    56.805     0.189     0.200
    56.824    -0.980     0.200
    56.861    -0.514     0.200
    56.898    -0.219     0.200
    56.961    -0.100     0.200
    56.944    -0.388     0.200
    56.961    -0.625     0.200
    56.967    -0.192     0.200
    57.003     0.550     0.200
    57.045    -0.535     0.200
    57.085    -2.103     0.200
    57.121    -0.157     0.200
    57.132     0.264     0.200
    57.148    -1.771     0.200
    57.156     0.201     0.200
    57.166    -0.855     0.200
    57.161    -0.339     0.200
    57.209     0.219     0.200
    57.228    -1.327     0.200
    57.230    -1.729     0.200
    57.306    -0.364     0.200
    57.321    -1.745     0.200
    57.332     0.081     0.200
    57.360    -0.333     0.200
    57.369     0.387     0.200
    57.379     0.423     0.200
    57.417    -0.350     0.200
    57.425    -0.199     0.200
    57.461    -0.219     0.200
    57.511    -0.215     0.200
    57.515    -0.640     0.200
    57.599    -0.030     0.200
    57.642    -0.432     0.200
    57.776     0.025     0.200
    57.856    -0.641     0.200
    57.922     0.079     0.200
    58.005    -0.780     0.200
    58.083    -0.429     0.200
    58.093    -0.806     0.200
    58.174    -0.062     0.200
    58.260     0.028     0.200
    58.448     0.390     0.200
    58.533     0.180     0.200
    58.591     0.023     0.200
    58.735     0.320     0.200
    58.761     0.037     0.200
    58.937    -0.376     0.200
    58.944    -0.329     0.200
    58.957    -0.923     0.200
    59.106    -0.655     0.200
    59.238    -0.569     0.200
    59.401    -0.696     0.200
    59.407    -0.343     0.200
    59.462    -0.327     0.200
    59.697     0.054     0.200
    59.720    -0.298     0.200
    59.767    -0.121     0.200
    59.793    -0.608     0.200
    59.837    -0.001     0.200
    59.875     0.032     0.200
    60.285    -0.178     0.200
    60.725     0.118     0.200
    60.797    -0.774     0.200
    60.866    -0.539     0.200
    60.921    -0.221     0.200
    61.002     0.131     0.200
    61.036    -0.294     0.200
    61.255    -0.784     0.200
    61.361    -0.303     0.200
    61.444    -0.961     0.200
    61.499    -0.725     0.200
    61.628    -0.008     0.200
    61.653    -0.570     0.200
    61.736     0.270     0.200
    61.781    -0.834     0.200
    61.781    -0.936     0.200
    61.931    -0.846     0.200
    61.916    -0.641     0.200
    62.171    -1.055     0.200
    62.338    -0.969     0.200
    62.441    -1.160     0.200
    62.507     0.297     0.200
    62.506    -0.502     0.200
    62.481    -0.734     0.200
    62.910    -0.591     0.200
    62.992     0.262     0.200
    63.052    -0.233     0.200
    63.110     0.074     0.200
    63.346    -0.885     0.200
    63.396    -0.922     0.200
    63.511     0.123     0.200
    63.707     0.125     0.200
    63.971    -0.111     0.200
    64.340    -0.137     0.200
    64.391    -0.064     0.200
    64.444     0.490     0.200
    64.566     0.290     0.200
    64.826    -0.309     0.200
    65.360    -0.283     0.200
    65.889     0.106     0.200
    66.245    -0.081     0.200
    66.258    -0.071     0.200
    66.386     0.113     0.200
    66.589    -0.281     0.200
    66.589    -0.281     0.200
    66.626    -0.515     0.200
    67.000    -0.307     0.200
    67.161    -0.828     0.200
    67.323    -0.856     0.200
    67.434    -1.152     0.200
    67.575    -0.952     0.200
    67.609    -0.361     0.200
    67.643    -1.180     0.200
    67.858    -0.434     0.200
    67.967    -0.017     0.200
    68.199    -0.476     0.200
    68.640    -1.437     0.200
    68.786    -1.849     0.200
    68.884    -1.560     0.200
    69.389    -0.795     0.200
    71.262    -0.752     0.200
    72.775    -0.518     0.200
    72.792    -0.115     0.200
    72.846     0.257     0.200
    74.992    -0.803     0.200
    74.993    -0.610     0.200
    77.106    -0.580     0.200
    78.053    -0.230     0.200
    78.185    -0.802     0.200
    78.497     0.813     0.200
    78.529    -1.071     0.200
    78.918    -1.505     0.200
    80.305    -1.701     0.200
    80.566    -1.651     0.200
    80.431    -1.028     0.200
    80.809     0.045     0.200
    81.536     0.273     0.200
    81.764     0.501     0.200
    81.865     0.470     0.200
    82.078     0.425     0.200
    82.016    -1.168     0.200
    85.515    -1.757     0.200
    86.756    -1.588     0.200
    90.282    -0.503     0.200
    91.487     0.796     0.200
    49.430     0.053     0.200
    49.430     0.053     0.200
    49.430     0.053     0.200
    49.430     0.053     0.200
    29.860     0.059     0.200
    21.368    -0.006     0.200
    61.499     0.048     0.200
    46.405     0.055     0.200
    46.405     0.055     0.200
    46.405     0.055     0.200
    46.405     0.055     0.200
    46.405     0.055     0.200
    46.405     0.055     0.200
    46.405     0.031     0.200
    52.197     0.046     0.200
    52.197     0.046     0.200
    52.197     0.046     0.200
    35.739     0.039     0.200
    78.529     0.039     0.200
    78.529    -0.008     0.200
    21.308     0.294     0.200
    45.713     0.111     0.200
    45.713     0.056     0.200
    45.713    -0.014     0.200
    45.713     0.041     0.200
    21.204    -0.097     0.200
    21.204     0.060     0.200
    21.204    -0.331     0.200
    54.988     0.044     0.200
    49.638     0.046     0.200
    49.638     0.046     0.200
    53.407     0.048     0.200
    53.407     0.064     0.200
    53.407     0.079     0.200
    38.971     0.223     0.200
    38.971     0.223     0.200
    38.971    -0.050     0.200
    38.971    -0.050     0.200
    38.971    -0.050     0.200
    38.971    -0.050     0.200
    39.089     0.034     0.200
    39.089     0.050     0.200
    39.089     0.097     0.200
    39.089     0.034     0.200
    46.368     0.082     0.200
    27.442     0.042     0.200
    27.442    -0.372     0.200
    27.442     0.128     0.200
    46.005     0.048     0.200
    25.209     0.025     0.200
    25.209     0.095     0.200
    23.851     0.059     0.200
    23.851     0.207     0.200
    23.851    -0.293     0.200
    46.373     0.064     0.200
    46.373     0.111     0.200
    46.373     0.049     0.200
    46.373     0.025     0.200
    46.373     0.049     0.200
    72.779    -0.017     0.200
    72.779    -0.001     0.200
    21.341     1.506     0.200
    72.752     0.033     0.200
    49.315     0.055     0.200
    49.315     0.006     0.200
    49.315     0.085     0.200
    46.296     0.046     0.200
    46.296     0.027     0.200
    46.296     0.003     0.200
    46.296     0.027     0.200
    46.296     0.101     0.200
    46.296     0.038     0.200
    53.299     0.040     0.200
    53.299     0.041     0.200
    53.299     0.017     0.200
    18.923    -1.378     0.200
    18.972    -0.517     0.200
    20.970    -0.280     0.200
    21.198     0.151     0.200
    21.320     0.148     0.200
    21.391     1.354     0.200
    23.820    -1.483     0.200
    24.291     0.711     0.200
    24.556    -1.304     0.200
    25.207    -0.231     0.200
    26.572     1.111     0.200
    26.810     1.055     0.200
    26.789     0.445     0.200
    27.797    -0.215     0.200
    28.008     1.117     0.200
    28.225     0.576     0.200
    29.471     1.003     0.200
    29.827     1.050     0.200
    30.066     0.736     0.200
    30.812     1.649     0.200
    31.353     0.691     0.200
    31.360     0.810     0.200
    31.924     0.950     0.200
    31.923    -0.036     0.200
    35.782    -0.175     0.200
    35.779     0.348     0.200
    36.387     0.148     0.200
    36.287    -0.101     0.200
    37.098    -0.508     0.200
    38.604     0.363     0.200
    38.891     0.810     0.200
    38.939    -0.600     0.200
    39.059     0.155     0.200
    40.487     0.424     0.200
    41.627    -0.217     0.200
    43.428     0.441     0.200
    43.952    -0.575     0.200
    44.923    -0.338     0.200
    45.278     0.839     0.200
    45.210    -1.626     0.200
    45.669    -0.256     0.200
    45.680    -0.143     0.200
    45.982     0.269     0.200
    46.128    -0.879     0.200
    46.339    -0.941     0.200
    46.374    -0.143     0.200
    46.470    -0.172     0.200
    46.559    -0.766     0.200
    46.789    -0.174     0.200
    47.340    -0.876     0.200
    47.909    -1.796     0.200
    49.020    -0.954     0.200
    49.028    -1.021     0.200
    49.219     0.625     0.200
    49.396     0.148     0.200
    49.611    -0.078     0.200
    49.951    -0.495     0.200
    50.244    -0.079     0.200
    50.389    -0.280     0.200
    50.868    -1.188     0.200
    50.900    -2.435     0.200
    50.782    -0.750     0.200
    51.085     0.176     0.200
    51.494     0.433     0.200
    51.543     0.245     0.200
    51.585    -0.413     0.200
    51.600    -0.540     0.200
    51.820     0.367     0.200
    51.885     0.483     0.200
    51.882    -0.194     0.200
    51.876     0.447     0.200
    52.001    -0.538     0.200
    52.013    -0.216     0.200
    52.017     0.496     0.200
    52.170     0.062     0.200
    52.170     0.008     0.200
    52.228    -0.068     0.200
    52.444    -0.174     0.200
    52.476    -1.610     0.200
    52.581    -0.189     0.200
    52.653    -0.323     0.200
    53.023    -0.428     0.200
    53.210     0.512     0.200
    53.154    -1.215     0.200
    53.367     0.217     0.200
    53.393     0.025     0.200
    53.376    -0.851     0.200
    53.376    -0.445     0.200
    53.633    -0.038     0.200
    53.731    -0.499     0.200
    53.716    -0.753     0.200
    53.709     0.604     0.200
    53.747    -0.982     0.200
    53.844     0.409     0.200
    53.872    -0.296     0.200
    54.011    -0.907     0.200
    54.068     0.827     0.200
    54.065    -1.100     0.200
    54.163     0.708     0.200
    54.541    -0.792     0.200
    54.687    -0.332     0.200
    54.716    -0.043     0.200
    54.795     0.296     0.200
    54.809    -0.310     0.200
    55.023    -0.165     0.200
    55.020     0.255     0.200
    55.043    -1.164     0.200
    54.976     0.089     0.200
    54.966     0.054     0.200
    55.263    -0.192     0.200
    55.292    -0.206     0.200
    55.314    -0.459     0.200
    55.427    -0.075     0.200
    55.506     0.161     0.200
    55.555    -0.597     0.200
    55.612     0.732     0.200
    55.753    -0.718     0.200
    55.772    -0.656     0.200
    55.786    -0.256     0.200
    55.695    -0.403     0.200
    55.868    -0.741     0.200
    55.919    -0.507     0.200
    55.945    -0.298     0.200
    56.016    -0.306     0.200
    56.055    -0.481     0.200
    56.060    -0.416     0.200
    56.104    -0.433     0.200
    56.219     0.347     0.200
    56.287    -1.369     0.200
    56.370    -1.231     0.200
    56.388     0.343     0.200
    56.404    -0.178     0.200
    56.453     0.576     0.200
    56.459    -0.569     0.200
    56.470    -2.577     0.200
    56.471    -1.655     0.200
    56.590    -1.338     0.200
    56.658    -0.484     0.200
    56.677     0.185     0.200
    56.779     0.258     0.200
    56.799    -0.635     0.200
    56.834    -0.635     0.200
    56.874    -0.767     0.200
    56.936    -0.818     0.200
    56.975     0.317     0.200
    57.021    -1.317     0.200
    57.039    -0.086     0.200
    57.060    -1.982     0.200
    57.096    -1.290     0.200
    57.107     0.239     0.200
    57.123    -2.144     0.200
    57.130     0.168     0.200
    57.141    -0.863     0.200
    57.135    -0.459     0.200
    57.185     0.086     0.200
    57.203    -1.905     0.200
    57.205    -1.610     0.200
    57.207    -0.380     0.200
    57.296    -2.260     0.200
    57.307     0.252     0.200
    57.333    -0.211     0.200
    57.344     0.258     0.200
    57.353     0.192     0.200
    57.392    -0.080     0.200
    57.400    -0.638     0.200
    57.486    -0.252     0.200
    57.490    -0.670     0.200
    57.573    -0.156     0.200
    57.617     0.042     0.200
    57.748     0.011     0.200
    57.832    -0.777     0.200
    57.894    -0.240     0.200
    57.980    -0.917     0.200
    58.059    -0.566     0.200
    58.068    -0.938     0.200
    58.091     0.005     0.200
    58.146    -0.179     0.200
    58.235    -0.608     0.200
    58.423    -0.011     0.200
    58.508    -0.207     0.200
    58.545    -0.071     0.200
    58.566    -0.419     0.200
    58.710     0.387     0.200
    58.736    -0.695     0.200
    58.818     0.030     0.200
    58.918    -0.267     0.200
    58.931    -0.955     0.200
    59.079    -0.681     0.200
    59.211    -0.695     0.200
    59.374    -0.824     0.200
    59.381    -0.083     0.200
    59.672    -0.083     0.200
    59.694    -0.233     0.200
    59.740    -0.053     0.200
    59.767    -0.737     0.200
    59.811    -1.040     0.200
    60.259    -0.309     0.200
    60.699    -0.017     0.200
    60.842    -0.487     0.200
    60.976     0.098     0.200
    61.011    -0.239     0.200
    61.228    -0.910     0.200
    61.336    -0.242     0.200
    61.417    -1.086     0.200
    61.469    -0.693     0.200
    61.534     1.025     0.200
    61.603    -0.145     0.200
    61.755    -0.965     0.200
    61.754    -0.961     0.200
    61.907    -0.887     0.200
    62.431    -0.972     0.200
    62.416    -1.209     0.200
    62.447    -1.514     0.200
    62.882    -0.618     0.200
    62.968    -0.185     0.200
    63.085     0.031     0.200
    63.319    -0.913     0.200
    63.369    -1.052     0.200
    63.486     0.479     0.200
    64.420     0.530     0.200
    64.801    -0.360     0.200
    65.337    -0.445     0.200
    65.643     0.436     0.200
    65.866     0.140     0.200
    66.222     0.053     0.200
    66.236     0.264     0.200
    66.361    -0.135     0.200
    66.565    -0.244     0.200
    66.565    -0.041     0.200
    66.649    -0.780     0.200
    66.977    -0.063     0.200
    67.138    -0.494     0.200
    67.300    -1.023     0.200
    67.411    -1.022     0.200
    67.552    -0.914     0.200
    67.943    -0.081     0.200
    68.176    -0.446     0.200
    68.617    -1.206     0.200
    68.862    -1.128     0.200
    69.366    -0.657     0.200
    71.233    -0.284     0.200
    72.800    -0.433     0.200
    72.817    -0.476     0.200
    75.018    -0.667     0.200
    75.020    -0.778     0.200
    75.623    -0.440     0.200
    77.078    -0.448     0.200
    78.157    -0.775     0.200
    78.157    -0.619     0.200
    78.470     0.946     0.200
    78.500    -1.771     0.200
    79.637    -0.737     0.200
    80.781     0.282     0.200
    81.559    -0.370     0.200
    81.702     0.176     0.200
    81.755     0.232     0.200
    81.856     0.139     0.200
    82.070     0.093     0.200
    81.989    -0.021     0.200
    85.542    -1.308     0.200
    86.725    -2.247     0.200
    49.396     0.062     0.200
    49.396     0.047     0.200
    49.396     0.047     0.200
    49.396     0.047     0.200
    49.396     0.047     0.200
    49.396     0.047     0.200
    49.396     0.062     0.200
    29.827     0.050     0.200
    75.020     0.058     0.200
    21.391     0.065     0.200
    21.391     0.065     0.200
    46.374     0.045     0.200
    46.374     0.045     0.200
    46.374     0.045     0.200
    46.374     0.045     0.200
    46.374     0.045     0.200
    46.374     0.045     0.200
    46.374     0.045     0.200
    52.170     0.023     0.200
    52.170    -0.016     0.200
    52.170     0.039     0.200
    78.500     0.049     0.200
    78.500     0.049     0.200
    78.500     0.049     0.200
    45.680     0.044     0.200
    45.680     0.044     0.200
    21.198     0.050     0.200
    21.198     0.050     0.200
    21.198    -0.185     0.200
    49.611    -0.007     0.200
    49.611     0.063     0.200
    53.376     0.048     0.200
    53.376     0.048     0.200
    53.376     0.048     0.200
    53.376     0.048     0.200
    38.939     0.104     0.200
    38.939     0.111     0.200
    39.059     0.030     0.200
    39.059     0.046     0.200
    39.059     0.093     0.200
    39.059     0.062     0.200
    46.339     0.051     0.200
    49.028    -0.084     0.200
    45.982    -0.027     0.200
    72.800    -0.003     0.200
    72.800     0.036     0.200
    25.207     0.191     0.200
    23.820    -0.054     0.200
    23.820     0.095     0.200
    20.969    -0.330     0.200
    21.197     0.608     0.200
    21.392     0.411     0.200
    23.817    -1.001     0.200
    24.291     0.444     0.200
    25.206    -0.194     0.200
    26.808     1.004     0.200
    31.359     0.553     0.200
    38.603     0.106     0.200
    38.936    -0.529     0.200
    39.057     0.001     0.200
    40.485     1.374     0.200
    46.468    -0.031     0.200
    46.787    -0.229     0.200
    49.394     0.212     0.200
    49.610     0.159     0.200
    50.242    -0.046     0.200
    51.541     0.278     0.200
    51.875     0.488     0.200
    52.169     0.267     0.200
    52.226     0.167     0.200
    52.652     0.013     0.200
    53.336     0.063     0.200
    53.365    -0.251     0.200
    53.392     0.054     0.200
    53.374    -1.214     0.200
    53.374    -0.612     0.200
    53.707     0.941     0.200
    56.369    -1.202     0.200
    56.451    -0.190     0.200
    56.833    -0.698     0.200
    57.133    -0.429     0.200
    57.206    -0.343     0.200
    57.342     0.295     0.200
    57.352     0.230     0.200
    57.488    -0.734     0.200
    57.830    -0.741     0.200
    57.979    -0.888     0.200
    58.057    -0.639     0.200
    58.067    -1.002     0.200
    58.917    -0.332     0.200
    59.078    -0.652     0.200
    59.210    -0.760     0.200
    59.373    -0.795     0.200
    59.671    -0.047     0.200
    60.258    -0.280     0.200
    60.698    -0.184     0.200
    61.009    -0.305     0.200
    61.227    -0.982     0.200
    61.467    -0.748     0.200
    61.601    -0.312     0.200
    61.753    -0.937     0.200
    62.431    -0.107     0.200
    62.415    -0.479     0.200
    63.084     0.058     0.200
    63.317    -1.384     0.200
    66.650    -0.864     0.200
    66.564     0.305     0.200
    72.802    -0.370     0.200
    72.818    -0.468     0.200
    75.019    -0.855     0.200
    75.021    -0.865     0.200
    78.498    -1.406     0.200
    81.702     0.588     0.200
    85.543    -1.498     0.200
    86.722    -0.768     0.200
    90.246    -0.435     0.200
    49.394    -0.038     0.200
    49.394     0.040     0.200
    49.394     0.040     0.200
    49.394     0.040     0.200
    49.394     0.040     0.200
    49.394     0.040     0.200
    49.394     0.040     0.200
    49.394     0.040     0.200
    75.021     0.002     0.200
    75.021     0.002     0.200
    75.021     0.002     0.200
    75.021     0.002     0.200
    75.021     0.010     0.200
    21.392    -0.230     0.200
    21.392     0.004     0.200
    21.392     0.043     0.200
    46.372     0.053     0.200
    46.372     0.037     0.200
    46.372     0.014     0.200
    46.372     0.037     0.200
    46.372     0.037     0.200
    46.372     0.037     0.200
    52.169     0.032     0.200
    78.498    -0.015     0.200
    78.498    -0.054     0.200
    78.498     0.039     0.200
    78.498     0.039     0.200
    21.197    -0.118     0.200
    21.197     0.038     0.200
    21.197    -0.306     0.200
    49.610     0.034     0.200
    53.374     0.036     0.200
    53.374     0.036     0.200
    53.374     0.036     0.200
    38.936     0.049     0.200
    38.936     0.049     0.200
    38.936     0.049     0.200
    38.936     0.049     0.200
    39.057     0.040     0.200
    39.057     0.040     0.200
    85.543     0.002     0.200
    72.802     0.005     0.200
    72.802     0.005     0.200
    72.802     0.005     0.200
    72.802     0.005     0.200
    72.802     0.005     0.200
    25.206     0.197     0.200
    25.206     0.033     0.200
    25.206     0.033     0.200
    86.722     0.037     0.200
    23.817     0.054     0.200
    23.817     0.054     0.200
    23.817     0.054     0.200
    23.817     0.054     0.200
    18.947    -1.681     0.200
    18.954    -0.757     0.200
    20.946    -0.659     0.200
    21.177     0.043     0.200
    21.294     0.977     0.200
    21.367     0.352     0.200
    24.266     0.288     0.200
    24.558    -1.375     0.200
    25.184    -0.576     0.200
    26.563     1.538     0.200
    26.791     0.778     0.200
    26.779    -0.011     0.200
    27.788     1.329     0.200
    30.835     1.392     0.200
    31.333     1.110     0.200
    31.341     0.933     0.200
    31.947     0.494     0.200
    35.706     0.614     0.200
    36.278     1.023     0.200
    38.586     0.065     0.200
    38.757     0.027     0.200
    38.915     0.701     0.200
    39.078     0.142     0.200
    40.466    -0.757     0.200
    41.609     0.477     0.200
    43.412     0.517     0.200
    45.202    -1.612     0.200
    46.391    -0.181     0.200
    46.487     0.043     0.200
    46.807    -0.368     0.200
    48.176    -0.214     0.200
    49.016    -0.882     0.200
    49.410     0.304     0.200
    49.633     0.103     0.200
    50.266    -0.102     0.200
    50.766    -0.782     0.200
    51.564     0.123     0.200
    51.843     0.243     0.200
    51.904    -0.213     0.200
    51.898     0.332     0.200
    52.192     0.287     0.200
    52.250     0.212     0.200
    52.465    -0.388     0.200
    52.676    -0.344     0.200
    53.361    -0.103     0.200
    53.388     0.400     0.200
    53.394    -1.442     0.200
    53.394    -0.618     0.200
    53.731     0.587     0.200
    53.738    -0.771     0.200
    54.033    -1.026     0.200
    54.092     0.846     0.200
    54.832    -0.035     0.200
    54.955    -0.230     0.200
    55.046     0.018     0.200
    55.285     0.089     0.200
    55.337    -0.183     0.200
    55.577    -0.312     0.200
    55.686    -0.395     0.200
    55.775    -0.435     0.200
    55.794    -0.473     0.200
    55.808     0.030     0.200
    55.968    -0.017     0.200
    56.038     0.171     0.200
    56.077    -0.301     0.200
    56.082    -0.445     0.200
    56.427     0.005     0.200
    56.424     0.127     0.200
    56.481    -0.523     0.200
    56.664    -0.065     0.200
    56.699     0.365     0.200
    56.801     0.442     0.200
    56.856    -0.748     0.200
    56.957    -0.361     0.200
    57.061     0.400     0.200
    57.129     0.420     0.200
    57.152     0.352     0.200
    57.157    -0.677     0.200
    57.230    -0.097     0.200
    57.366     0.040     0.200
    57.376    -0.026     0.200
    57.414    -0.196     0.200
    57.513    -0.889     0.200
    57.595    -0.575     0.200
    57.770    -0.198     0.200
    57.855    -0.896     0.200
    58.091    -1.453     0.200
    58.167    -0.090     0.200
    58.941    -0.581     0.200
    58.953    -0.964     0.200
    59.102    -0.894     0.200
    59.233    -1.009     0.200
    59.396    -1.236     0.200
    59.695    -0.198     0.200
    60.281    -0.520     0.200
    61.488    -0.799     0.200
    61.488    -1.331     0.200
    62.439    -0.719     0.200
    62.458    -0.748     0.200
    66.625    -0.889     0.200
    66.588    -0.250     0.200
    71.230    -0.627     0.200
    72.778    -0.407     0.200
    72.794    -0.305     0.200
    72.813     0.383     0.200
    74.996    -1.000     0.200
    74.998    -1.010     0.200
    75.619    -0.582     0.200
    78.153    -0.456     0.200
    78.497    -1.570     0.200
    79.991    -0.736     0.200
    80.272    -0.847     0.200
    81.727     0.230     0.200
    81.780     0.301     0.200
    81.881     0.193     0.200
    82.095     0.229     0.200
    85.520    -1.162     0.200
    86.726    -1.516     0.200
    74.998     0.002     0.200
    74.998     0.002     0.200
    74.998     0.002     0.200
    74.998     0.002     0.200
    21.367    -0.336     0.200
    72.778    -0.000     0.200
    72.778     0.004     0.200
    72.778     0.004     0.200
    25.184    -0.115     0.200
    18.977    -0.137     0.200
    20.982     1.429     0.200
    21.207     0.100     0.200
    21.335     0.424     0.200
    21.408     0.741     0.200
    25.217    -0.383     0.200
    26.816    -0.659     0.200
    35.724     1.555     0.200
    38.930    -1.350     0.200
    39.042    -0.018     0.200
    46.358    -0.024     0.200
    46.454    -0.003     0.200
    46.773    -0.207     0.200
    49.382     0.335     0.200
    51.859     0.817     0.200
    52.153     0.378     0.200
    53.360    -0.895     0.200
    53.360    -0.571     0.200
    55.006     0.041     0.200
    57.327     0.520     0.200
    57.336     0.556     0.200
    57.814    -1.114     0.200
    59.062    -0.222     0.200
    59.357    -0.264     0.200
    61.452    -0.697     0.200
    72.818    -0.292     0.200
    72.834    -0.542     0.200
    75.037    -0.834     0.200
    75.617    -0.273     0.200
    78.068     0.070     0.200
    78.151    -0.753     0.200
    78.495    -1.455     0.200
    86.716    -1.360     0.200
    49.382    -0.094     0.200
    49.382    -0.032     0.200
    49.382     0.046     0.200
    49.382     0.046     0.200
    75.037     0.010     0.200
    46.358     0.015     0.200
    46.358    -0.056     0.200
    46.358     0.046     0.200
    46.358     0.046     0.200
    46.358     0.046     0.200
    35.724     0.015     0.200
    78.495    -0.080     0.200
    78.495     0.037     0.200
    53.360     0.046     0.200
    53.360     0.046     0.200
    21.513     1.155     0.200
    49.317     0.619     0.200
    75.136    -1.098     0.200
    18.997    -0.696     0.200
    20.963     0.088     0.200
    21.209     0.331     0.200
    21.294     0.316     0.200
    21.344     0.385     0.200
    23.885    -0.578     0.200
    24.622    -0.504     0.200
    25.211    -0.161     0.200
    26.622     1.158     0.200
    26.831    -0.028     0.200
    26.836     0.628     0.200
    27.462     1.073     0.200
    29.540     0.797     0.200
    29.896     0.645     0.200
    30.862     1.308     0.200
    31.371     2.235     0.200
    31.379     0.756     0.200
    35.757     1.638     0.200
    36.853     0.780     0.200
    38.629    -0.433     0.200
    38.936     1.089     0.200
    39.006    -0.842     0.200
    39.122     0.294     0.200
    40.499     1.322     0.200
    43.461     0.386     0.200
    45.261    -1.719     0.200
    45.749    -0.282     0.200
    46.440    -0.047     0.200
    46.536    -0.082     0.200
    46.854    -0.075     0.200
    49.275     0.801     0.200
    49.466     0.248     0.200
    49.668    -0.094     0.200
    50.019    -0.355     0.200
    50.300     0.106     0.200
    50.812    -0.962     0.200
    51.139     0.278     0.200
    51.600     0.328     0.200
    51.668    -0.576     0.200
    51.874     0.481     0.200
    51.937    -0.187     0.200
    51.934     0.831     0.200
    52.226     0.156     0.200
    52.284    -0.375     0.200
    52.379     0.124     0.200
    52.543    -1.097     0.200
    52.636     0.020     0.200
    53.077    -0.339     0.200
    53.388     0.073     0.200
    53.425     0.303     0.200
    53.441    -1.119     0.200
    53.441    -0.795     0.200
    53.766     1.597     0.200
    54.120     0.810     0.200
    54.120    -0.786     0.200
    54.864    -0.294     0.200
    55.078    -0.145     0.200
    55.046     0.016     0.200
    55.318    -0.178     0.200
    55.368    -0.139     0.200
    55.609    -0.071     0.200
    55.826    -0.624     0.200
    55.745    -0.645     0.200
    56.110    -0.459     0.200
    56.458     0.254     0.200
    56.731     0.209     0.200
    56.833     0.289     0.200
    56.890    -0.713     0.200
    57.161     0.266     0.200
    57.184     0.301     0.200
    57.259    -0.431     0.200
    57.397     0.095     0.200
    57.407     0.130     0.200
    57.543    -0.827     0.200
    57.806    -0.082     0.200
    57.883    -0.825     0.200
    58.032    -1.169     0.200
    58.121    -0.193     0.200
    58.972     0.180     0.200
    59.134    -0.948     0.200
    59.267    -0.863     0.200
    59.725    -0.231     0.200
    61.063    -0.277     0.200
    61.531    -0.647     0.200
    61.531    -1.444     0.200
    62.433    -0.949     0.200
    63.138     0.899     0.200
    66.615    -0.048     0.200
    74.963    -0.730     0.200
    74.964    -0.740     0.200
    78.035    -0.701     0.200
    78.216    -0.823     0.200
    78.560    -1.385     0.200
    78.635    -1.197     0.200
    80.947     0.005     0.200
    81.512    -0.265     0.200
    81.721    -0.344     0.200
    81.774     0.260     0.200
    81.875     0.209     0.200
    82.088     0.184     0.200
    81.985    -0.869     0.200
    85.485    -0.856     0.200
    86.790    -1.348     0.200
    78.560     0.412     0.200
    21.209    -0.380     0.200
    21.209    -0.380     0.200
    21.209    -0.380     0.200
    53.441     0.236     0.200
    39.006    -0.280     0.200
    39.006    -0.280     0.200
    39.006    -0.280     0.200
    39.006    -0.280     0.200
    27.462    -0.330     0.200
    27.462    -0.330     0.200
    27.462     0.151     0.200
    23.885    -0.277     0.200
    14.916     5.924     0.200
    18.977     0.092     0.200
    20.971     0.371     0.200
    21.202    -0.120     0.200
    21.318     1.023     0.200
    21.386     0.043     0.200
    23.829    -0.504     0.200
    24.290     0.575     0.200
    25.209    -0.589     0.200
    26.580     1.200     0.200
    26.815     1.580     0.200
    26.797     0.639     0.200
    27.805     1.689     0.200
    29.836     0.335     0.200
    30.067     0.285     0.200
    30.817     1.667     0.200
    31.357     1.962     0.200
    31.365     0.835     0.200
    31.930     1.864     0.200
    35.727     1.145     0.200
    38.609    -0.514     0.200
    38.895     0.384     0.200
    38.948     0.184     0.200
    39.066     0.056     0.200
    39.066     0.455     0.200
    40.490    -0.644     0.200
    45.218    -0.927     0.200
    45.688    -0.050     0.200
    46.381    -0.114     0.200
    46.478    -0.171     0.200
    46.797    -0.370     0.200
    49.225     0.141     0.200
    49.405     0.193     0.200
    49.617    -0.057     0.200
    50.250     0.036     0.200
    50.395    -0.765     0.200
    51.091     0.095     0.200
    51.549     0.258     0.200
    51.826     0.591     0.200
    51.891     0.505     0.200
    51.887    -0.073     0.200
    51.883     0.463     0.200
    52.176     0.304     0.200
    52.234     0.348     0.200
    52.450    -0.158     0.200
    52.587    -0.168     0.200
    52.659    -0.098     0.200
    53.028    -0.231     0.200
    53.343     0.153     0.200
    53.398     0.245     0.200
    53.373     0.331     0.200
    53.384    -0.848     0.200
    53.384    -0.598     0.200
    53.638     0.183     0.200
    53.722    -0.630     0.200
    53.715     1.021     0.200
    53.753    -0.957     0.200
    53.850     0.229     0.200
    53.878    -0.172     0.200
    54.016    -0.785     0.200
    54.074     0.797     0.200
    54.071    -0.977     0.200
    54.168     1.108     0.200
    54.815    -0.191     0.200
    55.029    -0.042     0.200
    55.320    -0.339     0.200
    55.320    -0.140     0.200
    55.560    -0.571     0.200
    55.560    -0.372     0.200
    55.759    -0.330     0.200
    55.791    -0.133     0.200
    55.703    -0.396     0.200
    55.951    -0.374     0.200
    56.022     0.213     0.200
    56.061    -0.460     0.200
    56.054     2.116     0.200
    56.066    -0.556     0.200
    56.375    -1.103     0.200
    56.394     0.768     0.200
    56.410    -0.151     0.200
    56.459    -0.001     0.200
    56.648     0.453     0.200
    56.683     0.207     0.200
    56.784     0.383     0.200
    56.840    -0.512     0.200
    57.045    -0.161     0.200
    57.112     0.359     0.200
    57.141    -0.341     0.200
    57.213    -0.151     0.200
    57.349     0.383     0.200
    57.359     0.419     0.200
    57.397     0.346     0.200
    57.495    -0.544     0.200
    57.579    -0.036     0.200
    57.754     0.030     0.200
    57.837    -0.650     0.200
    57.900     1.244     0.200
    57.986    -0.793     0.200
    58.064    -0.341     0.200
    58.074    -0.410     0.200
    58.924    -0.141     0.200
    58.937    -0.929     0.200
    59.085    -0.659     0.200
    59.217    -0.572     0.200
    59.380    -0.700     0.200
    59.678     0.044     0.200
    60.265    -0.188     0.200
    60.705     0.007     0.200
    60.982     0.326     0.200
    61.016    -0.111     0.200
    61.234    -0.791     0.200
    61.423    -0.968     0.200
    61.608     0.283     0.200
    61.760    -0.743     0.200
    62.429    -0.902     0.200
    62.888    -0.495     0.200
    63.091     0.058     0.200
    63.325    -0.692     0.200
    63.375    -0.928     0.200
    66.644    -1.085     0.200
    66.570    -0.213     0.200
    72.795    -0.385     0.200
    72.811    -0.584     0.200
    75.012    -0.969     0.200
    75.014    -0.830     0.200
    75.631    -0.427     0.200
    77.086    -0.586     0.200
    78.064    -0.387     0.200
    78.165    -1.319     0.200
    78.478     0.763     0.200
    78.509    -1.909     0.200
    80.005    -0.881     0.200
    80.789     0.100     0.200
    81.703     0.170     0.200
    81.756     0.358     0.200
    81.856     0.227     0.200
    82.070     0.184     0.200
    85.536    -1.165     0.200
    29.836     0.054     0.200
    29.836     0.046     0.200
    75.014     0.013     0.200
    75.014    -0.010     0.200
    75.014     0.021     0.200
    75.014     0.006     0.200
    75.014     0.006     0.200
    21.386     0.004     0.200
    78.165     0.036     0.200
    61.476    -0.030     0.200
    46.381     0.023     0.200
    46.381    -0.001     0.200
    46.381     0.050     0.200
    46.381     0.038     0.200
    46.381     0.038     0.200
    52.176     0.003     0.200
    52.176     0.030     0.200
    52.176     0.030     0.200
    52.176     0.030     0.200
    78.509    -0.010     0.200
    78.509    -0.120     0.200
    78.509     0.037     0.200
    45.688     0.044     0.200
    45.688     0.044     0.200
    49.617    -0.014     0.200
    49.617     0.064     0.200
    49.617     0.032     0.200
    53.384     0.055     0.200
    53.384     0.019     0.200
    53.384     0.078     0.200
    53.384     0.035     0.200
    39.066     0.037     0.200
    39.066     0.037     0.200
    39.066     0.037     0.200
    85.536     0.007     0.200
    27.429     0.047     0.200
    27.429     0.047     0.200
    27.429     0.047     0.200
    27.429     0.047     0.200
    72.795    -0.037     0.200
    72.795     0.014     0.200
    72.795     0.006     0.200
    72.795     0.006     0.200
    72.795     0.006     0.200
    25.209     0.032     0.200
    23.829     0.524     0.200
    23.829     0.051     0.200
    23.843    -1.123     0.200
    38.964    -1.161     0.200
    52.205    -0.330     0.200
    72.766    -1.360     0.200
    78.519    -1.665     0.200
    49.430    -0.208     0.200
    72.766    -0.024     0.200
    21.202    -0.357     0.200
    21.343    -0.630     0.200
    27.453     1.504     0.200
    46.436     0.124     0.200
    49.460     0.077     0.200
    56.508     0.713     0.200
    57.397     0.209     0.200
    57.406     0.245     0.200
    58.121    -1.778     0.200
    72.748    -0.497     0.200
    74.965    -0.988     0.200
    78.551    -0.128     0.200
    53.437     0.026     0.200
    27.453     0.407     0.200
    21.387    -0.111     0.200
    53.392    -0.364     0.200
    57.351     0.462     0.200
    57.360     0.296     0.200
    72.794    -0.342     0.200
    75.012    -0.829     0.200
    78.529    -1.134     0.200
    14.802     8.863     0.200
    22.209     0.931     0.200
    22.173    -1.080     0.200
    22.768    -0.002     0.200
    22.946    -0.392     0.200
    26.294    -1.047     0.200
    27.782     1.533     0.200
    28.578    -0.192     0.200
    32.185     0.815     0.200
    36.744     0.247     0.200
    37.608     0.415     0.200
    44.991     0.070     0.200
    45.099     0.210     0.200
    45.388     0.020     0.200
    50.015     0.312     0.200
    50.636     0.238     0.200
    50.695    -0.033     0.200
    51.967    -1.067     0.200
    51.967    -0.692     0.200
    53.907    -0.042     0.200
    55.940    -0.497     0.200
    57.393    -1.725     0.200
    57.673    -1.495     0.200
    61.273    -0.549     0.200
    61.535    -0.718     0.200
    65.010    -0.298     0.200
    67.175    -1.848     0.200
    76.559    -0.345     0.200
    77.832    -0.443     0.200
    78.169    -0.916     0.200
    80.022    -1.085     0.200
    83.114     0.036     0.200
    24.129    -0.186     0.200
    46.973    -0.167     0.200
    47.065    -0.188     0.200
    49.944     0.339     0.200
    53.983    -1.057     0.200
    53.983    -0.982     0.200
    62.874    -0.303     0.200
    78.695    -0.734     0.200
    87.042    -1.526     0.200
    14.825     6.825     0.200
    21.899    -0.719     0.200
    22.509     1.427     0.200
    23.414    -0.034     0.200
    25.991    -0.611     0.200
    36.670    -0.445     0.200
    45.383     0.066     0.200
    45.488    -0.015     0.200
    45.785    -0.067     0.200
    48.132    -0.708     0.200
    48.514     0.060     0.200
    52.366    -1.390     0.200
    52.366    -0.666     0.200
    61.591    -0.584     0.200
    65.448    -0.111     0.200
    78.270    -0.867     0.200
    86.271    -2.540     0.200
    23.800     0.281     0.200
    36.654     0.337     0.200
    46.431    -0.309     0.200
    49.046    -0.675     0.200
    49.436     0.230     0.200
    62.543    -0.848     0.200
    74.934    -1.006     0.200
    78.461    -0.837     0.200
    22.584    -0.965     0.200
    45.366    -0.178     0.200
    45.473     0.077     0.200
    48.520    -0.168     0.200
    52.345    -0.622     0.200
    61.470     0.514     0.200
    73.976    -0.404     0.200
    76.181    -0.731     0.200
    78.355    -0.941     0.200
    86.334    -1.284     0.200
    86.695    -1.051     0.200
    16.367     3.481     0.200
    21.960     1.339     0.200
    21.967    -0.527     0.200
    22.656    -0.404     0.200
    23.330     0.143     0.200
    26.070    -1.168     0.200
    37.868     0.387     0.200
    45.236     0.351     0.200
    48.376     0.124     0.200
    50.917    -0.401     0.200
    52.218    -0.683     0.200
    52.218    -0.894     0.200
    56.082    -0.261     0.200
    58.118    -0.765     0.200
    59.002    -0.324     0.200
    61.822    -1.394     0.200
    65.299    -0.466     0.200
    74.063     0.190     0.200
    76.276    -0.289     0.200
    77.853    -0.420     0.200
    78.205    -0.957     0.200
    86.179    -1.229     0.200
    19.026    -0.488     0.200
    21.305    -0.977     0.200
    21.651    -0.268     0.200
    23.657    -0.734     0.200
    25.338    -0.136     0.200
    26.115    -0.545     0.200
    27.413     1.340     0.200
    35.729     1.709     0.200
    40.586     1.058     0.200
    46.110    -0.166     0.200
    49.148     0.370     0.200
    53.110    -0.811     0.200
    54.924    -0.367     0.200
    57.076     0.118     0.200
    57.086    -0.248     0.200
    57.223    -0.821     0.200
    58.811    -0.852     0.200
    62.280    -0.730     0.200
    73.067    -1.050     0.200
    75.289    -1.320     0.200
    81.818    -0.046     0.200
    85.811    -1.560     0.200
    86.556    -0.880     0.200
    53.110     0.036     0.200
    15.010     6.858     0.200
    19.776    -0.613     0.200
    20.236     0.400     0.200
    20.225    -0.236     0.200
    20.847    -0.815     0.200
    21.253    -0.637     0.200
    24.372    -0.604     0.200
    24.341     0.156     0.200
    25.003    -1.345     0.200
    26.648     0.049     0.200
    27.128     1.115     0.200
    30.725     0.427     0.200
    36.223    -0.443     0.200
    39.756     0.284     0.200
    47.369    -0.014     0.200
    47.455     0.013     0.200
    47.799    -0.259     0.200
    49.876    -0.913     0.200
    50.272     0.169     0.200
    50.272    -0.009     0.200
    53.295     0.158     0.200
    54.391    -0.812     0.200
    54.391    -0.335     0.200
    62.535    -1.151     0.200
    63.347    -0.185     0.200
    71.660    -1.193     0.200
    73.891    -1.283     0.200
    78.674    -1.812     0.200
    78.874    -1.733     0.200
    20.724     0.187     0.200
    20.675    -0.462     0.200
    24.127     0.178     0.200
    24.787    -0.739     0.200
    25.456    -1.038     0.200
    46.989     0.013     0.200
    49.564    -0.567     0.200
    49.956    -0.311     0.200
    54.001    -0.652     0.200
    58.012     0.397     0.200
    58.022     0.433     0.200
    62.901    -1.539     0.200
    72.131    -0.958     0.200
    78.688    -0.536     0.200
    78.831    -1.094     0.200
    87.041    -1.676     0.200
    90.786    -1.325     0.200
    48.583    -0.206     0.200
    73.876    -1.103     0.200
    86.350    -1.839     0.200
    16.865     2.317     0.200
    20.797    -0.521     0.200
    22.560     1.025     0.200
    24.157    -0.977     0.200
    24.518    -0.227     0.200
    27.040     1.583     0.200
    39.448     0.057     0.200
    39.411     0.253     0.200
    47.361     0.042     0.200
    54.386    -1.233     0.200
    58.506     0.239     0.200
    58.515     0.175     0.200
    61.040    -0.341     0.200
    64.254    -0.644     0.200
    71.635    -1.010     0.200
    73.871    -1.406     0.200
    78.250    -0.268     0.200
    78.599    -0.876     0.200
    78.805    -1.438     0.200
    80.315    -0.882     0.200
    87.067    -1.428     0.200
    14.999     7.362     0.200
    18.686    -1.089     0.200
    20.440     0.151     0.200
    20.641    -1.543     0.200
    20.692     0.419     0.200
    20.713    -0.678     0.200
    20.792     0.438     0.200
    22.696    -0.973     0.200
    23.694     0.640     0.200
    24.246    -0.720     0.200
    24.246    -0.310     0.200
    24.559    -1.066     0.200
    24.745    -0.552     0.200
    25.418    -0.142     0.200
    26.489     2.825     0.200
    26.576     0.741     0.200
    27.286     1.117     0.200
    27.773     0.288     0.200
    31.002     1.316     0.200
    31.010     1.465     0.200
    33.177     0.446     0.200
    35.539     0.724     0.200
    36.288    -0.038     0.200
    36.870     0.593     0.200
    38.893     0.390     0.200
    39.692     0.035     0.200
    41.026     1.586     0.200
    41.343    -1.415     0.200
    44.610     1.295     0.200
    45.212    -2.675     0.200
    46.977    -0.131     0.200
    48.400    -2.157     0.200
    49.936    -0.094     0.200
    50.911    -1.071     0.200
    52.721    -0.346     0.200
    52.839    -0.497     0.200
    53.990    -0.996     0.200
    53.990    -0.596     0.200
    54.903    -0.587     0.200
    54.903    -0.037     0.200
    55.445     0.935     0.200
    57.803    -0.421     0.200
    58.018     0.375     0.200
    58.027     0.310     0.200
    58.411     0.022     0.200
    58.561    -0.124     0.200
    58.809    -0.050     0.200
    59.750    -0.564     0.200
    59.881    -0.663     0.200
    60.045    -0.787     0.200
    60.930    -0.834     0.200
    61.145    -0.394     0.200
    61.373    -0.033     0.200
    61.893    -0.847     0.200
    62.082    -1.013     0.200
    62.276    -0.114     0.200
    62.419    -1.074     0.200
    62.424    -0.909     0.200
    63.547    -0.573     0.200
    63.983    -0.746     0.200
    78.297    -1.272     0.200
    78.643    -1.367     0.200
    78.789    -1.746     0.200
    78.789    -1.091     0.200
    78.843     0.143     0.200
    81.168    -1.268     0.200
    87.001    -2.153     0.200
    87.001    -1.657     0.200
    88.304    -0.799     0.200
    45.446     0.586     0.200
    48.710     0.358     0.200
    52.399    -0.667     0.200
    86.785    -0.729     0.200
    15.837     5.520     0.200
    18.935    -0.091     0.200
    20.125    -0.848     0.200
    20.125    -0.598     0.200
    21.004     0.371     0.200
    21.194    -0.670     0.200
    21.329    -1.132     0.200
    21.396    -0.049     0.200
    21.511     0.015     0.200
    22.647    -0.215     0.200
    22.958    -0.299     0.200
    23.361     0.458     0.200
    23.414     0.197     0.200
    23.595    -0.567     0.200
    23.932    -0.423     0.200
    23.932    -0.154     0.200
    24.352     1.012     0.200
    25.218    -0.374     0.200
    25.732     0.467     0.200
    25.985     0.118     0.200
    26.472     0.869     0.200
    26.699     0.720     0.200
    26.781     1.281     0.200
    27.350     1.291     0.200
    27.584     0.386     0.200
    27.584     1.546     0.200
    27.606     0.474     0.200
    27.606     1.724     0.200
    27.787     0.194     0.200
    27.703     1.301     0.200
    27.951    -0.214     0.200
    27.951     0.887     0.200
    29.613     1.151     0.200
    29.670     0.112     0.200
    29.670    -0.489     0.200
    29.906     2.620     0.200
    31.331     0.080     0.200
    31.794     0.748     0.200
    33.684     2.924     0.200
    35.658     0.636     0.200
    35.658     1.125     0.200
    36.073    -1.599     0.200
    36.187    -0.976     0.200
    37.070     0.103     0.200
    38.568     0.141     0.200
    38.587    -1.919     0.200
    38.909     0.416     0.200
    38.909     0.186     0.200
    41.007     1.458     0.200
    41.588     1.789     0.200
    43.371     0.279     0.200
    46.219    -0.041     0.200
    46.315    -0.368     0.200
    48.849    -0.960     0.200
    48.904    -1.298     0.200
    49.238     0.223     0.200
    50.243     0.611     0.200
    50.248     0.572     0.200
    50.930     0.921     0.200
    50.951     0.472     0.200
    51.071    -1.332     0.200
    51.403     0.173     0.200
    51.687     0.552     0.200
    51.736     0.188     0.200
    51.746    -0.089     0.200
    52.033     0.072     0.200
    52.033     0.085     0.200
    52.090     0.047     0.200
    52.303    -0.133     0.200
    52.447    -0.104     0.200
    52.520    -0.066     0.200
    52.731     1.394     0.200
    53.144     0.294     0.200
    53.226     0.539     0.200
    53.223    -0.836     0.200
    53.223    -0.785     0.200
    53.266     0.207     0.200
    53.375    -0.825     0.200
    53.570     0.614     0.200
    53.570     0.614     0.200
    53.581    -0.569     0.200
    53.612    -0.797     0.200
    53.776     0.403     0.200
    53.876    -0.826     0.200
    53.900     0.298     0.200
    53.930    -0.821     0.200
    53.940     0.935     0.200
    54.034     1.294     0.200
    54.146     1.231     0.200
    54.762    -0.478     0.200
    54.801    -0.161     0.200
    54.840    -0.343     0.200
    54.819    -0.337     0.200
    54.878    -0.418     0.200
    55.026    -0.387     0.200
    55.135    -0.479     0.200
    55.286     0.130     0.200
    55.555    -1.102     0.200
    55.635    -0.579     0.200
    55.651    -0.190     0.200
    55.752    -0.820     0.200
    55.810    -0.337     0.200
    55.920    -0.521     0.200
    56.015    -0.404     0.200
    56.221    -0.775     0.200
    56.315    -0.347     0.200
    56.389    -0.271     0.200
    56.438    -0.022     0.200
    56.645     0.304     0.200
    56.665     0.061     0.200
    56.697    -0.767     0.200
    56.815     0.098     0.200
    56.818    -0.026     0.200
    56.905    -0.038     0.200
    56.930     0.284     0.200
    56.996     0.412     0.200
    56.998    -0.696     0.200
    57.114    -0.023     0.200
    57.211     0.094     0.200
    57.220     0.028     0.200
    57.333     0.232     0.200
    57.354     0.063     0.200
    57.358    -0.847     0.200
    57.608    -0.103     0.200
    57.702    -0.970     0.200
    57.756    -0.447     0.200
    57.851    -0.918     0.200
    58.005    -0.298     0.200
    58.362    -0.797     0.200
    58.786    -0.448     0.200
    58.794    -1.207     0.200
    58.944    -0.846     0.200
    59.075    -0.854     0.200
    59.238    -0.887     0.200
    59.541    -0.177     0.200
    59.632    -0.801     0.200
    60.124    -0.385     0.200
    60.566    -0.208     0.200
    60.842     0.010     0.200
    60.880    -0.850     0.200
    60.971    -0.228     0.200
    60.971    -0.767     0.200
    61.089    -1.066     0.200
    61.277    -1.145     0.200
    61.350    -1.233     0.200
    61.469    -0.241     0.200
    61.615    -1.123     0.200
    61.618    -1.047     0.200
    62.258    -0.117     0.200
    62.285    -0.731     0.200
    62.290    -0.262     0.200
    62.550    -0.030     0.200
    62.743    -0.787     0.200
    62.914    -0.300     0.200
    62.955    -0.099     0.200
    63.179    -0.986     0.200
    63.230    -1.225     0.200
    63.252     0.231     0.200
    63.355    -0.752     0.200
    63.683     0.740     0.200
    64.295     0.755     0.200
    64.410     0.899     0.200
    64.673     0.168     0.200
    65.038     0.943     0.200
    65.742     0.649     0.200
    66.049     0.228     0.200
    66.114     0.358     0.200
    66.233     0.300     0.200
    66.438    -0.006     0.200
    66.457    -0.009     0.200
    66.651     0.134     0.200
    66.773    -0.967     0.200
    66.852    -0.091     0.200
    67.015     0.143     0.200
    67.289    -0.133     0.200
    67.431    -0.096     0.200
    67.498    -0.307     0.200
    67.700     0.286     0.200
    68.052    -0.368     0.200
    68.530     0.287     0.200
    68.726     0.322     0.200
    68.852     0.340     0.200
    68.865    -0.532     0.200
    68.860     0.809     0.200
    68.893     0.484     0.200
    69.115    -0.185     0.200
    69.642     0.442     0.200
    69.786     0.353     0.200
    69.798    -0.238     0.200
    69.820     0.045     0.200
    70.033     0.638     0.200
    70.462    -0.389     0.200
    72.932    -0.517     0.200
    72.933    -1.360     0.200
    72.933    -0.479     0.200
    72.940    -0.703     0.200
    75.156    -0.697     0.200
    78.033    -1.023     0.200
    78.376    -1.675     0.200
    78.437    -1.198     0.200
    78.437    -0.983     0.200
    78.595    -0.599     0.200
    79.748    -0.848     0.200
    80.872    -1.077     0.200
    81.678     0.034     0.200
    81.546    -0.728     0.200
    81.695     0.145     0.200
    81.794     0.020     0.200
    81.818    -0.135     0.200
    82.009    -0.010     0.200
    85.680    -1.073     0.200
    85.680    -1.598     0.200
    86.515    -1.777     0.200
    86.583    -1.633     0.200
    87.992    -0.702     0.200
    87.992    -0.267     0.200
    90.091    -0.483     0.200
    78.376     0.039     0.200
    53.223     0.046     0.200
    53.223     0.046     0.200
    48.904     0.045     0.200
    27.350     0.040     0.200
    14.836     5.843     0.200
    20.141     0.046     0.200
    21.257    -0.408     0.200
    21.555     0.081     0.200
    22.961    -0.630     0.200
    23.364     0.639     0.200
    23.417     1.100     0.200
    23.595     0.623     0.200
    23.595    -0.233     0.200
    26.749    -0.335     0.200
    27.405     1.066     0.200
    31.765     3.605     0.200
    43.765     1.257     0.200
    46.202    -0.811     0.200
    48.940    -1.393     0.200
    49.232     0.508     0.200
    51.929    -0.472     0.200
    53.203    -0.875     0.200
    72.970    -0.988     0.200
    75.192    -0.773     0.200
    78.413    -1.947     0.200
    86.607    -1.984     0.200
    20.562    -0.859     0.200
    23.833    -0.656     0.200
    23.914     0.357     0.200
    24.122    -1.089     0.200
    46.951    -0.347     0.200
    16.183     4.053     0.200
    20.348    -0.349     0.200
    20.796    -0.208     0.200
    20.796     0.487     0.200
    23.088     0.402     0.200
    23.481    -1.750     0.200
    23.487    -0.038     0.200
    23.555     0.464     0.200
    23.765    -0.114     0.200
    24.058     0.474     0.200
    24.258    -0.733     0.200
    26.130     0.564     0.200
    34.926     0.146     0.200
    35.140     1.765     0.200
    37.789    -0.416     0.200
    44.473     1.589     0.200
    44.785    -0.298     0.200
    46.620     0.050     0.200
    49.493     0.053     0.200
    51.731     1.585     0.200
    53.650    -1.132     0.200
    72.276    -1.028     0.200
    72.277    -0.824     0.200
    72.285    -1.187     0.200
    74.533    -1.030     0.200
    78.019    -1.837     0.200
    85.074    -1.681     0.200
    21.680    -0.784     0.200
    21.680    -0.315     0.200
    23.288    -0.295     0.200
    23.341    -1.059     0.200
    23.341     0.726     0.200
    23.673     0.121     0.200
    23.862     0.018     0.200
    23.862    -0.341     0.200
    46.098    -0.167     0.200
    49.142    -0.139     0.200
    51.878    -0.221     0.200
    53.097    -0.942     0.200
    73.093    -1.264     0.200
    75.312    -1.508     0.200
    78.401    -1.463     0.200
    16.265     1.303     0.200
    23.264    -0.619     0.200
    23.835     1.139     0.200
    46.128    -0.753     0.200
    49.143     0.582     0.200
    73.005    -0.817     0.200
    16.537     0.540     0.200
    20.148     0.485     0.200
    20.377    -0.103     0.200
    20.435    -0.666     0.200
    20.435    -0.834     0.200
    20.595    -0.715     0.200
    21.720    -1.002     0.200
    23.851     0.432     0.200
    23.851    -0.541     0.200
    23.905     1.354     0.200
    24.112    -1.624     0.200
    24.409    -0.777     0.200
    24.451    -0.008     0.200
    24.613     0.101     0.200
    24.810    -0.095     0.200
    26.255     1.001     0.200
    30.284    -0.068     0.200
    30.674     1.586     0.200
    35.305     1.123     0.200
    42.873    -0.157     0.200
    44.697     1.552     0.200
    44.889    -0.359     0.200
    45.913     0.097     0.200
    46.932    -0.903     0.200
    48.291    -0.964     0.200
    48.880    -0.167     0.200
    49.436     0.079     0.200
    49.436    -0.124     0.200
    49.831    -0.414     0.200
    51.573     0.885     0.200
    51.573     1.181     0.200
    52.582     0.416     0.200
    52.694    -0.634     0.200
    52.896    -0.724     0.200
    53.957    -0.503     0.200
    53.957    -0.054     0.200
    57.564    -0.291     0.200
    58.094    -0.110     0.200
    58.103    -0.275     0.200
    58.246    -0.277     0.200
    58.454     0.569     0.200
    58.822    -0.491     0.200
    58.852    -0.399     0.200
    59.662    -0.408     0.200
    59.816    -0.468     0.200
    59.944    -0.245     0.200
    60.109    -0.180     0.200
    60.503    -0.877     0.200
    61.942    -1.224     0.200
    62.128    -1.381     0.200
    63.595    -0.842     0.200
    63.845    -0.492     0.200
    64.029    -0.603     0.200
    67.340     0.684     0.200
    72.046    -0.801     0.200
    74.288    -1.090     0.200
    75.455    -0.701     0.200
    76.015    -0.524     0.200
    78.351    -1.161     0.200
    78.519    -1.859     0.200
    86.752    -2.750     0.200
    21.157    -0.595     0.200
    21.157    -0.778     0.200
    21.157    -1.048     0.200
    24.149    -0.046     0.200
    24.559    -0.062     0.200
    24.816     0.094     0.200
    24.816    -0.485     0.200
    25.177     0.137     0.200
    25.083     0.963     0.200
    27.062     1.775     0.200
    37.258     2.054     0.200
    43.434    -1.506     0.200
    47.569    -0.132     0.200
    50.518    -0.010     0.200
    53.405    -0.410     0.200
    54.582    -1.261     0.200
    71.573    -0.703     0.200
    73.786    -1.346     0.200
    78.667    -0.373     0.200
    79.016    -0.997     0.200
    87.460    -1.576     0.200
    20.031     0.188     0.200
    20.410    -0.034     0.200
    24.387     0.390     0.200
    24.496     0.004     0.200
    24.496     0.067     0.200
    24.551    -0.395     0.200
    24.899    -0.114     0.200
    25.053     0.138     0.200
    25.177    -1.586     0.200
    26.612     1.309     0.200
    26.728     0.967     0.200
    26.791     1.619     0.200
    27.180     0.998     0.200
    27.779    -1.773     0.200
    29.043     0.372     0.200
    30.674     0.835     0.200
    32.171     1.348     0.200
    32.703     1.483     0.200
    34.799    -1.544     0.200
    35.381    -0.262     0.200
    35.835     1.741     0.200
    39.573     0.728     0.200
    43.529    -0.309     0.200
    43.739    -0.398     0.200
    44.751     1.790     0.200
    45.292     1.128     0.200
    45.292     2.122     0.200
    45.238    -0.578     0.200
    45.852     0.427     0.200
    46.894     0.177     0.200
    47.343     0.670     0.200
    47.597     1.117     0.200
    47.593    -0.003     0.200
    47.679    -0.548     0.200
    49.338    -1.124     0.200
    50.491     0.290     0.200
    51.059    -0.230     0.200
    51.586     0.993     0.200
    52.706    -1.249     0.200
    53.352    -0.094     0.200
    53.514     0.155     0.200
    53.570     0.081     0.200
    53.643    -0.837     0.200
    53.774     0.086     0.200
    54.480    -0.461     0.200
    54.616    -1.249     0.200
    54.616    -0.826     0.200
    54.861    -0.331     0.200
    55.048     0.521     0.200
    55.048     0.521     0.200
    56.325    -0.244     0.200
    57.730    -0.398     0.200
    57.796    -0.865     0.200
    58.180    -0.856     0.200
    58.479    -0.448     0.200
    58.565    -0.346     0.200
    58.697     0.331     0.200
    58.707     0.267     0.200
    58.845    -0.498     0.200
    58.923    -0.237     0.200
    59.082    -0.338     0.200
    59.189    -0.684     0.200
    59.236    -0.304     0.200
    59.339    -0.518     0.200
    59.423    -0.501     0.200
    59.850    -0.141     0.200
    60.273    -0.544     0.200
    60.428    -0.605     0.200
    60.558    -0.493     0.200
    60.722    -0.612     0.200
    61.028    -0.294     0.200
    61.115    -0.286     0.200
    61.608    -0.319     0.200
    62.052    -0.707     0.200
    62.328    -0.257     0.200
    62.368    -0.624     0.200
    62.566    -1.148     0.200
    62.754    -0.701     0.200
    62.759    -0.988     0.200
    63.092    -0.552     0.200
    63.101    -1.010     0.200
    63.773    -0.456     0.200
    64.013    -0.617     0.200
    64.037    -2.006     0.200
    64.219    -0.794     0.200
    64.442    -0.353     0.200
    64.655    -0.642     0.200
    64.707    -1.085     0.200
    64.842    -0.963     0.200
    65.169    -0.062     0.200
    67.720     0.583     0.200
    67.925    -0.120     0.200
    67.925     0.253     0.200
    68.300    -0.365     0.200
    70.465     0.309     0.200
    70.600     0.466     0.200
    71.445    -0.674     0.200
    71.446    -0.817     0.200
    71.453    -0.761     0.200
    73.671    -0.767     0.200
    73.673    -0.776     0.200
    75.899    -0.564     0.200
    78.455    -0.917     0.200
    78.805    -1.194     0.200
    79.024    -0.799     0.200
    80.199     0.164     0.200
    80.199     0.039     0.200
    82.900     0.675     0.200
    84.201    -1.605     0.200
    84.201    -1.332     0.200
    87.228    -1.981     0.200
    87.295    -1.223     0.200
    88.503    -0.376     0.200
    91.291    -0.504     0.200
    23.473     0.399     0.200
    27.295     1.285     0.200
    45.536    -0.152     0.200
    48.661    -0.056     0.200
    51.237    -0.600     0.200
    78.316    -0.871     0.200
    86.380    -1.035     0.200
    19.356     0.112     0.200
    19.807    -0.805     0.200
    19.807    -1.133     0.200
    21.661     0.014     0.200
    21.734     0.132     0.200
    22.135    -1.262     0.200
    22.502    -0.358     0.200
    22.898    -0.059     0.200
    22.898    -0.036     0.200
    22.950     0.042     0.200
    23.092     0.281     0.200
    25.066    -0.474     0.200
    26.641     0.879     0.200
    26.857    -0.285     0.200
    27.200     1.126     0.200
    37.336    -0.719     0.200
    38.985     0.129     0.200
    41.334    -1.388     0.200
    41.994     0.140     0.200
    43.054     1.401     0.200
    43.492    -0.920     0.200
    45.583    -0.829     0.200
    48.688    -0.560     0.200
    51.298     0.866     0.200
    51.290    -0.385     0.200
    51.325    -0.137     0.200
    52.571    -0.777     0.200
    52.571    -0.475     0.200
    54.097    -0.569     0.200
    56.465     0.022     0.200
    56.474    -0.044     0.200
    56.697    -0.327     0.200
    58.057    -0.526     0.200
    58.204    -0.656     0.200
    58.337    -0.685     0.200
    58.499    -0.220     0.200
    59.821    -0.277     0.200
    60.549    -1.069     0.200
    62.014    -0.789     0.200
    62.205    -0.472     0.200
    73.680    -0.812     0.200
    73.682    -0.831     0.200
    78.300    -1.916     0.200
    86.413    -1.676     0.200
    86.349    -1.716     0.200
    20.670    -0.835     0.200
    20.670    -0.984     0.200
    24.022    -0.934     0.200
    24.076    -1.704     0.200
    24.511     0.534     0.200
    24.586    -0.565     0.200
    26.228    -0.974     0.200
    26.919     1.748     0.200
    42.874    -0.736     0.200
    46.997    -0.716     0.200
    49.960    -0.293     0.200
    54.010    -0.636     0.200
    72.115    -1.448     0.200
    78.674    -1.190     0.200
    19.040    -1.091     0.200
    20.200    -1.188     0.200
    21.089     1.126     0.200
    21.292     0.539     0.200
    21.459    -1.254     0.200
    23.015    -1.300     0.200
    23.418    -0.433     0.200
    23.418    -0.185     0.200
    23.753    -1.044     0.200
    23.767    -0.504     0.200
    24.178     0.892     0.200
    24.424     0.943     0.200
    24.496    -0.316     0.200
    25.312    -0.636     0.200
    25.470     0.349     0.200
    25.470     0.351     0.200
    25.763     0.477     0.200
    26.069    -0.260     0.200
    26.577     0.518     0.200
    26.806    -0.345     0.200
    26.885     1.436     0.200
    27.058     0.867     0.200
    27.234     0.307     0.200
    27.344    -0.216     0.200
    27.458     1.592     0.200
    27.458     0.902     0.200
    27.515     0.406     0.200
    27.719    -0.028     0.200
    29.325     0.415     0.200
    29.583     0.984     0.200
    29.710     0.358     0.200
    30.183     1.273     0.200
    31.777     0.224     0.200
    31.922     1.402     0.200
    32.132     1.599     0.200
    32.799     0.754     0.200
    33.351    -1.916     0.200
    33.593     0.088     0.200
    33.775     0.744     0.200
    33.818    -0.428     0.200
    34.337     1.471     0.200
    34.570    -0.790     0.200
    34.600    -0.109     0.200
    35.024    -0.057     0.200
    35.310     1.118     0.200
    35.422     1.955     0.200
    35.635    -0.719     0.200
    35.766     1.551     0.200
    35.892    -0.824     0.200
    36.077    -0.106     0.200
    36.403    -0.035     0.200
    36.962     1.582     0.200
    37.117     1.138     0.200
    37.135    -0.579     0.200
    37.272     2.047     0.200
    37.524     1.738     0.200
    38.014    -0.377     0.200
    38.067    -0.254     0.200
    38.067    -0.013     0.200
    38.115     1.180     0.200
    38.211     1.100     0.200
    38.229    -0.359     0.200
    38.303     0.913     0.200
    38.603    -0.318     0.200
    38.674     0.486     0.200
    38.798     0.182     0.200
    38.922     0.008     0.200
    39.274    -0.930     0.200
    39.454    -0.370     0.200
    40.151    -0.885     0.200
    40.226    -0.675     0.200
    41.085    -3.118     0.200
    41.173     0.566     0.200
    41.516    -1.290     0.200
    41.694    -0.476     0.200
    42.054    -0.961     0.200
    43.248     0.623     0.200
    43.610     0.853     0.200
    43.728     0.051     0.200
    43.787     0.480     0.200
    44.355    -0.078     0.200
    44.458    -1.599     0.200
    44.774     0.181     0.200
    45.103     0.159     0.200
    45.129     0.355     0.200
    45.215    -0.927     0.200
    45.215    -0.128     0.200
    45.215    -1.187     0.200
    45.406    -0.825     0.200
    45.520    -0.242     0.200
    45.565    -0.997     0.200
    45.800     0.041     0.200
    45.833    -0.219     0.200
    45.979    -0.367     0.200
    46.112     0.376     0.200
    46.198    -0.630     0.200
    46.243    -0.325     0.200
    46.370    -1.243     0.200
    46.904     1.171     0.200
    47.058     0.074     0.200
    47.548     2.258     0.200
    47.674     1.177     0.200
    47.949    -0.454     0.200
    48.009     0.681     0.200
    48.645    -0.220     0.200
    48.893    -1.027     0.200
    49.001     0.547     0.200
    49.016     0.829     0.200
    49.073    -0.108     0.200
    49.281    -0.047     0.200
    49.281    -0.397     0.200
    49.466    -0.211     0.200
    49.833     0.573     0.200
    50.238     0.221     0.200
    50.245     0.213     0.200
    50.245    -0.426     0.200
    50.432     0.356     0.200
    50.822     0.312     0.200
    50.841    -0.430     0.200
    50.826     0.860     0.200
    50.938     0.374     0.200
    51.025    -0.161     0.200
    51.077    -0.907     0.200
    51.270     0.746     0.200
    51.293     0.324     0.200
    51.352    -0.164     0.200
    51.398     0.692     0.200
    51.483    -1.323     0.200
    51.673     0.431     0.200
    51.732    -0.206     0.200
    51.735    -0.261     0.200
    52.025    -0.824     0.200
    52.082     0.083     0.200
    52.300    -0.636     0.200
    52.351    -1.315     0.200
    52.418    -0.387     0.200
    52.434    -0.094     0.200
    52.506    -0.062     0.200
    52.539     0.592     0.200
    52.602    -0.070     0.200
    52.726     0.811     0.200
    52.946    -0.534     0.200
    53.033     0.514     0.200
    53.120     0.303     0.200
    53.222     0.450     0.200
    53.243    -1.004     0.200
    53.243    -0.979     0.200
    53.245     0.286     0.200
    53.395    -1.150     0.200
    53.564    -0.058     0.200
    53.564    -0.058     0.200
    53.569    -0.697     0.200
    53.601    -0.698     0.200
    53.725     0.061     0.200
    53.780     0.159     0.200
    53.864    -0.943     0.200
    53.918    -1.154     0.200
    54.013    -1.146     0.200
    54.127     1.128     0.200
    54.308    -0.396     0.200
    54.737     0.588     0.200
    54.751    -0.626     0.200
    54.849     1.281     0.200
    54.895    -1.052     0.200
    55.135     0.115     0.200
    55.627    -1.127     0.200
    55.703     0.826     0.200
    56.243     0.061     0.200
    56.256     1.067     0.200
    56.307     0.005     0.200
    56.313    -0.435     0.200
    56.496    -0.642     0.200
    56.688    -0.407     0.200
    56.949    -0.054     0.200
    56.989    -0.239     0.200
    57.037     2.021     0.200
    57.059    -0.140     0.200
    57.159     0.355     0.200
    57.187    -0.142     0.200
    57.197     0.391     0.200
    57.206     0.424     0.200
    57.252     0.399     0.200
    57.338    -0.611     0.200
    57.342    -0.538     0.200
    57.426     0.069     0.200
    57.604     0.221     0.200
    57.684    -0.541     0.200
    57.748     0.003     0.200
    57.921    -0.006     0.200
    58.002     0.126     0.200
    58.345     0.323     0.200
    58.771    -0.044     0.200
    58.933    -0.368     0.200
    59.065    -0.482     0.200
    59.228    -0.512     0.200
    59.234    -0.556     0.200
    59.525     0.238     0.200
    59.547     0.081     0.200
    59.594     0.058     0.200
    59.621    -0.524     0.200
    59.664    -1.122     0.200
    60.112     0.097     0.200
    60.552     0.192     0.200
    60.829     0.304     0.200
    60.863    -0.026     0.200
    61.073    -0.720     0.200
    61.083    -0.621     0.200
    61.272    -0.802     0.200
    61.456     0.058     0.200
    61.609    -0.775     0.200
    61.608    -0.672     0.200
    61.752    -0.438     0.200
    62.237     0.015     0.200
    62.268    -1.005     0.200
    62.508     0.444     0.200
    62.531     0.338     0.200
    62.737    -0.338     0.200
    62.819    -1.784     0.200
    62.938     0.328     0.200
    63.174    -0.539     0.200
    63.224    -0.772     0.200
    63.338     0.870     0.200
    63.502    -0.536     0.200
    63.661     0.122     0.200
    65.014     0.833     0.200
    65.717     0.528     0.200
    66.074     0.434     0.200
    66.417    -0.703     0.200
    66.417    -0.265     0.200
    66.417    -0.426     0.200
    66.432    -0.311     0.200
    66.624     0.463     0.200
    66.828     0.109     0.200
    66.949    -0.249     0.200
    66.949    -0.560     0.200
    66.989    -0.217     0.200
    67.403    -0.443     0.200
    67.407    -1.040     0.200
    67.686    -1.425     0.200
    68.058    -0.497     0.200
    68.544    -0.065     0.200
    68.708     0.766     0.200
    68.713    -0.666     0.200
    68.834     0.577     0.200
    68.839    -0.692     0.200
    68.855    -0.092     0.200
    68.874     0.332     0.200
    68.957    -0.347     0.200
    69.091    -0.128     0.200
    69.623     0.592     0.200
    69.765     0.518     0.200
    69.775     0.080     0.200
    69.859     0.442     0.200
    70.674     0.654     0.200
    72.805    -0.604     0.200
    72.948    -0.596     0.200
    72.956    -0.655     0.200
    75.010    -1.158     0.200
    75.164    -0.850     0.200
    75.404    -0.826     0.200
    76.231     0.510     0.200
    76.231     1.649     0.200
    76.592    -0.097     0.200
    78.130    -0.905     0.200
    78.130    -1.075     0.200
    78.473    -1.904     0.200
    78.527    -1.303     0.200
    80.257    -1.128     0.200
    80.725    -0.641     0.200
    80.967    -1.201     0.200
    81.569    -0.400     0.200
    81.569     0.075     0.200
    81.707     0.142     0.200
    81.707    -0.358     0.200
    81.920     0.022     0.200
    81.937    -0.066     0.200
    85.687    -1.436     0.200
    85.687    -1.712     0.200
    86.668    -1.923     0.200
    88.086    -0.081     0.200
    90.139    -1.296     0.200
    95.915    -0.767     0.200
    20.419    -0.499     0.200
    20.419    -1.514     0.200
    20.361    -1.170     0.200
    20.416     0.131     0.200
    23.223     1.700     0.200
    23.434    -0.306     0.200
    23.389    -0.748     0.200
    23.814    -0.989     0.200
    23.845    -0.651     0.200
    23.845     0.037     0.200
    23.900     0.443     0.200
    24.109    -0.555     0.200
    24.109    -0.820     0.200
    24.374    -0.684     0.200
    24.464    -0.299     0.200
    24.590    -0.448     0.200
    24.774     2.173     0.200
    25.073    -0.359     0.200
    26.096    -1.421     0.200
    26.181    -0.875     0.200
    26.368     0.214     0.200
    26.504     1.387     0.200
    26.898    -0.359     0.200
    27.153    -0.360     0.200
    27.402     0.006     0.200
    30.572     1.844     0.200
    30.611     0.994     0.200
    32.590     0.130     0.200
    32.720     1.054     0.200
    32.815     2.915     0.200
    34.924    -0.912     0.200
    35.345     1.267     0.200
    35.923     0.702     0.200
    36.914     0.236     0.200
    37.915    -0.046     0.200
    39.065     0.485     0.200
    39.065     0.032     0.200
    39.701    -0.419     0.200
    39.701     0.338     0.200
    39.705     0.637     0.200
    40.947    -0.438     0.200
    42.925    -0.446     0.200
    43.177     0.363     0.200
    44.184     2.852     0.200
    44.728     2.007     0.200
    44.846    -1.237     0.200
    45.115    -0.669     0.200
    45.271     0.988     0.200
    46.943    -0.703     0.200
    46.971     2.202     0.200
    47.003     1.051     0.200
    47.028     0.158     0.200
    47.270     0.874     0.200
    47.765     1.022     0.200
    47.805     2.215     0.200
    47.952    -0.226     0.200
    48.454     2.101     0.200
    48.862     0.463     0.200
    48.845    -0.716     0.200
    48.845    -0.896     0.200
    49.437    -0.041     0.200
    49.550     2.093     0.200
    49.833    -0.186     0.200
    50.139    -0.884     0.200
    50.356     0.874     0.200
    50.401     0.309     0.200
    51.120     1.110     0.200
    51.312     0.875     0.200
    51.436     0.730     0.200
    51.628     0.909     0.200
    51.717     0.845     0.200
    51.856     1.133     0.200
    52.050     0.201     0.200
    52.048    -1.484     0.200
    52.195     0.541     0.200
    52.231     2.313     0.200
    52.283     0.923     0.200
    52.607     0.128     0.200
    52.646    -0.420     0.200
    52.923     0.286     0.200
    52.923     0.395     0.200
    52.978     0.682     0.200
    52.988    -0.782     0.200
    53.191    -0.363     0.200
    53.581    -0.560     0.200
    53.678     0.134     0.200
    53.807     0.791     0.200
    53.970    -1.299     0.200
    53.970    -0.728     0.200
    54.098     0.163     0.200
    54.451     1.095     0.200
    54.451     1.095     0.200
    54.484    -0.022     0.200
    54.525    -0.144     0.200
    54.525     0.083     0.200
    54.613     0.122     0.200
    54.759     0.062     0.200
    54.832    -0.808     0.200
    55.311    -0.633     0.200
    55.663    -0.672     0.200
    55.889     0.013     0.200
    56.160     0.072     0.200
    56.311    -0.003     0.200
    56.763    -0.116     0.200
    57.126     1.615     0.200
    57.178     0.541     0.200
    57.205    -0.645     0.200
    57.591    -0.772     0.200
    57.713     0.672     0.200
    57.713     1.047     0.200
    57.713     1.571     0.200
    57.818     1.187     0.200
    58.003    -0.363     0.200
    58.123     0.095     0.200
    58.133     0.125     0.200
    58.269     0.370     0.200
    58.276    -0.178     0.200
    58.341    -0.335     0.200
    58.625    -0.468     0.200
    58.642    -0.432     0.200
    58.641     1.823     0.200
    58.743    -0.073     0.200
    58.852     0.108     0.200
    59.284     0.109     0.200
    59.689    -1.085     0.200
    59.701    -0.358     0.200
    59.844    -0.750     0.200
    59.971    -0.921     0.200
    60.137    -0.955     0.200
    60.152    -0.660     0.200
    60.460    -0.168     0.200
    60.463    -0.188     0.200
    60.497    -0.319     0.200
    60.531    -0.855     0.200
    60.588     0.062     0.200
    60.794    -0.946     0.200
    61.024    -0.408     0.200
    61.477    -0.174     0.200
    61.749    -0.013     0.200
    61.802    -0.167     0.200
    61.967    -1.082     0.200
    62.154    -1.233     0.200
    62.378    -0.334     0.200
    62.494    -1.211     0.200
    62.513    -1.034     0.200
    62.702    -0.786     0.200
    63.190     0.135     0.200
    63.449    -0.098     0.200
    63.476    -0.217     0.200
    63.620    -0.693     0.200
    63.875     0.429     0.200
    64.054    -0.951     0.200
    64.109    -1.107     0.200
    64.273    -0.080     0.200
    64.619     2.024     0.200
    67.065     1.327     0.200
    67.161    -0.276     0.200
    67.373    -0.272     0.200
    67.373     0.033     0.200
    67.403    -0.088     0.200
    67.601    -0.052     0.200
    67.689    -0.244     0.200
    67.795    -0.823     0.200
    68.373     3.385     0.200
    69.913     1.761     0.200
    70.055     1.727     0.200
    71.097     0.217     0.200
    72.016    -0.635     0.200
    72.017    -1.776     0.200
    72.017    -0.635     0.200
    72.024    -0.717     0.200
    73.845    -1.108     0.200
    74.260    -0.889     0.200
    75.417    -1.642     0.200
    76.067    -0.289     0.200
    78.316    -1.773     0.200
    78.754    -1.040     0.200
    80.496    -1.755     0.200
    80.724     0.024     0.200
    80.724    -0.749     0.200
    80.724     0.227     0.200
    86.727    -1.863     0.200
    20.080    -0.338     0.200
    20.416    -1.590     0.200
    23.214    -1.640     0.200
    23.809    -1.226     0.200
    23.809    -0.726     0.200
    23.846    -0.201     0.200
    23.901    -1.163     0.200
    24.109    -1.071     0.200
    24.586    -1.512     0.200
    25.059    -0.677     0.200
    26.186    -0.244     0.200
    26.186    -0.244     0.200
    26.492     0.910     0.200
    26.886    -1.461     0.200
    27.279     0.799     0.200
    30.291     0.907     0.200
    30.291     0.071     0.200
    30.597    -0.302     0.200
    32.800    -1.076     0.200
    35.356     2.633     0.200
    36.585     2.017     0.200
    39.076    -0.667     0.200
    39.076     1.263     0.200
    39.707    -0.501     0.200
    44.193     2.337     0.200
    44.737     2.788     0.200
    44.836    -2.403     0.200
    44.836     0.159     0.200
    44.916    -2.639     0.200
    45.280    -0.032     0.200
    45.367     1.682     0.200
    46.813     2.189     0.200
    46.980     2.279     0.200
    46.948    -0.959     0.200
    46.948     0.432     0.200
    47.775     1.595     0.200
    47.960    -0.341     0.200
    49.439     0.491     0.200
    50.364     0.257     0.200
    50.364    -0.775     0.200
    51.001     1.055     0.200
    51.001     1.477     0.200
    51.642    -0.151     0.200
    52.714    -0.842     0.200
    52.932    -0.190     0.200
    53.975    -1.079     0.200
    55.301    -1.524     0.200
    55.754    -0.011     0.200
    57.188    -0.099     0.200
    57.213    -0.275     0.200
    58.142    -0.308     0.200
    58.350     0.030     0.200
    58.638    -0.374     0.200
    58.861    -0.225     0.200
    58.885    -0.295     0.200
    59.698    -0.118     0.200
    59.710    -0.200     0.200
    59.853    -0.081     0.200
    60.145    -0.591     0.200
    60.540    -0.288     0.200
    61.033    -0.351     0.200
    61.486    -0.119     0.200
    61.758    -0.153     0.200
    61.812    -0.013     0.200
    61.975    -0.420     0.200
    62.162    -0.969     0.200
    62.387    -0.772     0.200
    63.216    -0.295     0.200
    63.628    -0.432     0.200
    63.885    -0.419     0.200
    72.007    -1.757     0.200
    72.007    -1.312     0.200
    72.008    -1.625     0.200
    73.858     0.054     0.200
    74.252    -1.443     0.200
    78.309    -1.636     0.200
    82.618    -0.442     0.200
    86.722    -2.375     0.200
    86.722    -1.711     0.200
    18.700    -1.624     0.200
    20.334    -1.391     0.200
    20.366    -0.036     0.200
    20.765    -0.259     0.200
    20.808    -1.607     0.200
    20.808    -0.927     0.200
    23.589     0.002     0.200
    23.769    -1.754     0.200
    24.178    -0.293     0.200
    24.178    -0.894     0.200
    24.232    -0.374     0.200
    24.238     0.375     0.200
    24.430    -0.083     0.200
    24.697    -0.417     0.200
    24.681    -0.348     0.200
    24.741    -0.413     0.200
    25.006    -0.926     0.200
    26.398    -0.349     0.200
    26.398    -0.349     0.200
    26.822     0.823     0.200
    26.949     1.683     0.200
    27.342     1.050     0.200
    27.858     1.532     0.200
    30.567     0.084     0.200
    30.567     0.414     0.200
    32.775     1.458     0.200
    35.221     2.320     0.200
    36.379    -0.612     0.200
    36.633     1.412     0.200
    39.055    -0.048     0.200
    39.881     0.064     0.200
    43.043    -0.362     0.200
    43.043    -0.487     0.200
    45.360    -0.750     0.200
    47.167    -0.067     0.200
    48.375     1.449     0.200
    49.731    -1.124     0.200
    50.124     0.088     0.200
    50.124     0.338     0.200
    53.020    -0.838     0.200
    54.180    -0.987     0.200
    54.180    -0.912     0.200
    57.302     0.608     0.200
    58.195    -0.371     0.200
    58.204    -0.437     0.200
    58.424    -0.270     0.200
    58.919     0.078     0.200
    59.770    -0.400     0.200
    59.781     0.023     0.200
    60.225    -1.124     0.200
    61.110    -0.256     0.200
    61.250    -0.009     0.200
    61.550     0.160     0.200
    62.076    -0.979     0.200
    63.730    -0.485     0.200
    64.166    -0.652     0.200
    71.949    -0.775     0.200
    71.958    -0.810     0.200
    73.670    -0.053     0.200
    74.168    -0.690     0.200
    74.170    -0.700     0.200
    74.170    -1.151     0.200
    75.868    -0.507     0.200
    78.323    -1.105     0.200
    78.419    -0.535     0.200
    78.927    -1.235     0.200
    82.411     0.252     0.200
    84.693    -1.295     0.200
    87.151    -1.697     0.200
    15.020     6.206     0.200
    18.418    -1.084     0.200
    24.239    -0.391     0.200
    24.317    -0.570     0.200
    24.372    -0.757     0.200
    24.581    -0.166     0.200
    25.023    -1.091     0.200
    26.642     0.123     0.200
    26.642     0.128     0.200
    26.733     1.729     0.200
    29.111    -0.417     0.200
    30.760    -0.810     0.200
    32.001     0.565     0.200
    32.760    -0.789     0.200
    33.109     1.758     0.200
    37.349     0.370     0.200
    39.413     0.612     0.200
    40.150     0.280     0.200
    43.348    -0.263     0.200
    45.119     1.734     0.200
    45.149    -1.201     0.200
    45.582    -1.039     0.200
    47.419     0.857     0.200
    47.406    -0.045     0.200
    50.306     0.274     0.200
    53.029     0.112     0.200
    53.336    -0.110     0.200
    54.429    -1.289     0.200
    54.429    -1.114     0.200
    55.604    -0.276     0.200
    58.002    -0.595     0.200
    58.523     0.366     0.200
    58.532     0.302     0.200
    58.672    -0.672     0.200
    58.747    -0.193     0.200
    58.991    -0.290     0.200
    59.017    -0.373     0.200
    59.249    -0.276     0.200
    60.100    -1.035     0.200
    60.251    -1.273     0.200
    60.381    -1.258     0.200
    60.545    -0.781     0.200
    60.938    -0.760     0.200
    61.431    -0.798     0.200
    61.877    -0.104     0.200
    62.386    -0.918     0.200
    62.923    -0.699     0.200
    64.040    -0.579     0.200
    67.755     0.447     0.200
    71.619    -0.591     0.200
    71.627    -1.481     0.200
    73.850    -0.804     0.200
    74.053    -0.740     0.200
    74.053    -0.236     0.200
    78.889    -1.132     0.200
    82.793     0.194     0.200
    87.149    -1.317     0.200
    16.889     1.979     0.200
    20.385    -1.230     0.200
    24.141    -1.347     0.200
    24.195    -1.297     0.200
    24.704    -0.434     0.200
    26.371    -0.192     0.200
    26.371    -0.192     0.200
    26.908     1.150     0.200
    27.302     1.296     0.200
    43.025    -0.725     0.200
    45.331    -0.455     0.200
    47.140    -0.240     0.200
    47.230    -0.396     0.200
    49.697    -0.307     0.200
    50.090     0.103     0.200
    53.003    -0.604     0.200
    54.154    -0.632     0.200
    54.154    -1.007     0.200
    57.968    -0.418     0.200
    58.181     0.490     0.200
    58.190     0.525     0.200
    59.915    -0.434     0.200
    60.046    -0.933     0.200
    60.209    -0.656     0.200
    61.094     0.009     0.200
    62.058    -0.700     0.200
    63.924     0.300     0.200
    71.963    -0.915     0.200
    71.971    -0.297     0.200
    73.680    -0.074     0.200
    80.723    -1.032     0.200
    24.562     0.375     0.200
    24.562     0.371     0.200
    27.330     0.790     0.200
    45.335    -0.128     0.200
    48.479     0.042     0.200
    52.316    -1.192     0.200
    52.316    -0.641     0.200
    71.844    -0.726     0.200
    73.983    -0.753     0.200
    76.192    -0.626     0.200
    86.276    -1.685     0.200
    14.880     5.081     0.200
    19.517    -0.296     0.200
    19.771    -0.588     0.200
    19.771    -1.651     0.200
    19.771    -1.073     0.200
    21.867    -0.032     0.200
    21.919     0.411     0.200
    22.263    -0.765     0.200
    22.263    -1.195     0.200
    22.350    -0.391     0.200
    22.477    -0.657     0.200
    22.422    -0.830     0.200
    22.816    -0.934     0.200
    22.816    -0.528     0.200
    22.816    -0.864     0.200
    22.867    -1.069     0.200
    22.867    -0.171     0.200
    22.948    -0.228     0.200
    22.948    -0.525     0.200
    23.273    -1.454     0.200
    23.619    -0.434     0.200
    23.643     1.098     0.200
    24.165    -1.217     0.200
    24.664     0.530     0.200
    24.664     0.530     0.200
    25.280     1.725     0.200
    26.005    -0.644     0.200
    26.386     0.919     0.200
    26.701    -0.431     0.200
    26.650     1.677     0.200
    26.663     1.433     0.200
    26.849     0.824     0.200
    26.953     0.399     0.200
    27.110    -1.120     0.200
    27.319     0.660     0.200
    27.397     0.304     0.200
    27.925     1.462     0.200
    27.925     0.579     0.200
    28.594     1.115     0.200
    28.645     0.341     0.200
    28.645     2.661     0.200
    28.664     0.194     0.200
    28.991    -0.115     0.200
    28.991     0.088     0.200
    30.848     1.409     0.200
    30.848     0.855     0.200
    30.942     0.119     0.200
    31.987     1.121     0.200
    32.105     0.792     0.200
    33.721    -0.140     0.200
    34.495     1.345     0.200
    34.707    -0.690     0.200
    35.193    -0.580     0.200
    36.169     0.634     0.200
    36.365    -1.232     0.200
    37.063     0.221     0.200
    37.686     0.038     0.200
    37.760    -1.486     0.200
    38.070     0.297     0.200
    38.070    -0.007     0.200
    38.468     0.595     0.200
    38.821     1.552     0.200
    39.143     0.680     0.200
    39.280    -1.065     0.200
    41.081     0.040     0.200
    41.179     0.516     0.200
    41.179    -0.602     0.200
    41.154    -0.495     0.200
    41.154    -0.464     0.200
    41.163    -0.794     0.200
    42.149     0.152     0.200
    42.321     1.677     0.200
    42.375     0.715     0.200
    42.716    -2.759     0.200
    42.859     1.589     0.200
    42.859     0.479     0.200
    43.436     0.391     0.200
    43.488     0.094     0.200
    43.681    -0.058     0.200
    44.267    -0.470     0.200
    44.357    -0.279     0.200
    44.898     0.993     0.200
    44.898     0.798     0.200
    45.122     1.210     0.200
    45.202     0.552     0.200
    45.202     0.779     0.200
    45.281    -2.052     0.200
    45.434     0.645     0.200
    45.456     0.863     0.200
    45.543     0.173     0.200
    45.991     0.937     0.200
    46.632    -0.205     0.200
    46.763     0.971     0.200
    47.031     0.471     0.200
    47.031     0.675     0.200
    47.103    -0.081     0.200
    47.629     1.822     0.200
    47.729    -0.457     0.200
    47.948     0.457     0.200
    48.016     0.926     0.200
    48.164     0.172     0.200
    48.192     0.359     0.200
    48.557    -0.346     0.200
    48.557     1.247     0.200
    48.574    -0.312     0.200
    48.574     0.211     0.200
    48.770     0.403     0.200
    48.867    -1.310     0.200
    49.115    -0.249     0.200
    49.187    -0.399     0.200
    49.287     0.342     0.200
    49.332     0.300     0.200
    49.478    -0.918     0.200
    49.480    -0.814     0.200
    49.527     0.314     0.200
    49.740     0.993     0.200
    49.911     0.485     0.200
    50.017     0.886     0.200
    50.099     0.433     0.200
    50.173     0.244     0.200
    50.367    -0.384     0.200
    50.401     0.900     0.200
    50.447     0.828     0.200
    50.490     0.503     0.200
    50.743     0.560     0.200
    50.766    -0.132     0.200
    50.829    -0.112     0.200
    50.873     0.013     0.200
    50.916    -1.745     0.200
    51.013     0.202     0.200
    51.111     0.118     0.200
    51.111    -0.397     0.200
    51.170    -0.326     0.200
    51.170    -0.724     0.200
    51.199     0.755     0.200
    51.243    -0.143     0.200
    51.243    -0.870     0.200
    51.400    -0.548     0.200
    51.494    -0.570     0.200
    51.586    -0.432     0.200
    51.628     0.148     0.200
    51.624     1.077     0.200
    51.798     0.478     0.200
    51.820    -0.288     0.200
    51.862    -0.202     0.200
    51.894     0.258     0.200
    52.012     0.383     0.200
    52.182     0.011     0.200
    52.319     0.499     0.200
    52.373    -1.299     0.200
    52.420    -0.854     0.200
    52.420    -1.128     0.200
    52.655     0.606     0.200
    52.655     0.606     0.200
    52.897     0.114     0.200
    53.003     0.142     0.200
    53.177     0.399     0.200
    53.177    -0.242     0.200
    53.495     0.247     0.200
    53.832    -0.653     0.200
    54.081     0.313     0.200
    54.217     1.378     0.200
    54.431     0.575     0.200
    54.566     0.594     0.200
    54.967    -0.107     0.200
    55.134     0.082     0.200
    55.786    -0.208     0.200
    55.773    -0.911     0.200
    55.924    -0.206     0.200
    56.075    -0.978     0.200
    56.130    -0.573     0.200
    56.273    -0.089     0.200
    56.282    -0.156     0.200
    56.413    -0.099     0.200
    56.709    -1.972     0.200
    56.754    -0.914     0.200
    56.837    -0.410     0.200
    57.098    -0.159     0.200
    57.417    -1.709     0.200
    57.841    -0.103     0.200
    57.846    -0.531     0.200
    58.015    -0.909     0.200
    58.148    -0.948     0.200
    58.310    -0.878     0.200
    58.598    -0.383     0.200
    59.194    -0.328     0.200
    59.629    -0.332     0.200
    59.805    -1.249     0.200
    59.907     0.351     0.200
    60.176    -1.193     0.200
    60.366    -0.995     0.200
    60.533    -0.435     0.200
    60.693    -1.122     0.200
    60.701    -0.876     0.200
    60.821     0.544     0.200
    61.047     0.071     0.200
    61.305     0.062     0.200
    61.579     0.326     0.200
    61.830    -0.828     0.200
    62.010     0.065     0.200
    62.268    -0.866     0.200
    62.316    -0.986     0.200
    62.576     1.047     0.200
    64.782     0.781     0.200
    65.138    -0.390     0.200
    65.150     0.584     0.200
    65.324    -0.364     0.200
    65.282     0.686     0.200
    65.484     0.404     0.200
    65.484    -0.400     0.200
    65.496    -0.486     0.200
    65.687     0.632     0.200
    65.893    -0.321     0.200
    66.215    -0.725     0.200
    66.468    -1.134     0.200
    66.700    -0.447     0.200
    67.131     0.313     0.200
    67.779     0.806     0.200
    67.906     0.807     0.200
    67.944     0.370     0.200
    68.025     0.430     0.200
    68.207     0.224     0.200
    68.267     0.544     0.200
    68.398     0.225     0.200
    68.693     0.878     0.200
    68.833     0.805     0.200
    68.833     0.407     0.200
    68.926     0.626     0.200
    69.740     0.787     0.200
    71.935    -0.307     0.200
    72.584     3.362     0.200
    72.823    -0.631     0.200
    73.429     0.694     0.200
    73.874    -0.173     0.200
    73.883    -0.403     0.200
    75.474    -0.030     0.200
    76.083    -0.412     0.200
    76.989     0.359     0.200
    77.468    -0.423     0.200
    77.816    -0.594     0.200
    77.991    -0.745     0.200
    78.128    -0.396     0.200
    78.280    -0.275     0.200
    78.425     1.154     0.200
    78.572    -0.717     0.200
    79.770    -0.216     0.200
    80.160    -0.318     0.200
    80.357    -0.436     0.200
    80.647    -0.567     0.200
    80.715     0.800     0.200
    80.771     0.197     0.200
    80.787    -0.490     0.200
    80.869     0.278     0.200
    81.205    -0.364     0.200
    81.887    -0.011     0.200
    82.001     0.241     0.200
    82.003     0.403     0.200
    82.044     0.352     0.200
    82.645    -0.086     0.200
    84.530     0.715     0.200
    85.751     0.826     0.200
    86.334    -1.111     0.200
    86.599    -0.763     0.200
    86.599    -1.584     0.200
    87.886    -0.602     0.200
    89.190     0.581     0.200
    89.463    -0.153     0.200
    92.651     0.865     0.200
    95.598     0.163     0.200
    19.735    -0.979     0.200
    22.754    -0.306     0.200
    23.473    -1.054     0.200
    24.569     0.717     0.200
    24.569     0.717     0.200
    27.373     1.172     0.200
    41.042    -1.187     0.200
    48.494     0.213     0.200
    52.322    -1.071     0.200
    52.322    -0.770     0.200
    71.814    -0.804     0.200
    73.992    -0.537     0.200
    76.199    -0.476     0.200
    80.596     0.273     0.200
    16.388     3.827     0.200
    20.139    -0.978     0.200
    21.606     0.457     0.200
    23.349    -0.562     0.200
    23.727    -1.664     0.200
    27.042     1.190     0.200
    49.209    -0.640     0.200
    72.756     0.224     0.200
    73.018    -0.842     0.200
    75.237    -1.085     0.200
    86.612    -1.581     0.200
    20.734    -0.609     0.200
    20.704    -0.926     0.200
    20.704    -2.508     0.200
    24.044    -0.577     0.200
    24.174    -0.765     0.200
    24.512     0.900     0.200
    26.230     0.716     0.200
    26.230     0.716     0.200
    26.982     1.211     0.200
    40.173     0.213     0.200
    47.000    -0.589     0.200
    49.974    -0.157     0.200
    52.739    -0.517     0.200
    65.988    -0.403     0.200
    72.136    -1.314     0.200
    78.726    -1.597     0.200
    20.694     0.008     0.200
    20.656    -1.810     0.200
    24.013    -0.829     0.200
    24.114    -0.345     0.200
    24.510     0.563     0.200
    26.227    -0.269     0.200
    26.227    -0.269     0.200
    26.894     1.607     0.200
    42.879    -1.096     0.200
    49.954    -0.166     0.200
    58.036     0.171     0.200
    58.046     0.208     0.200
    58.183    -0.558     0.200
    58.264    -0.319     0.200
    59.769    -1.265     0.200
    59.900    -0.868     0.200
    60.064    -0.390     0.200
    72.107    -0.147     0.200
    73.569    -0.317     0.200
    78.653    -1.248     0.200
    14.769     5.656     0.200
    18.400     0.975     0.200
    19.910    -0.868     0.200
    20.178    -1.285     0.200
    20.361    -1.380     0.200
    20.361    -0.978     0.200
    20.361    -0.470     0.200
    20.502    -1.313     0.200
    20.502    -1.914     0.200
    20.502    -1.453     0.200
    20.502    -1.680     0.200
    20.474    -0.907     0.200
    20.509    -0.080     0.200
    20.578     0.100     0.200
    20.578    -0.080     0.200
    21.388     2.112     0.200
    21.388    -0.182     0.200
    21.624     2.331     0.200
    21.842     0.722     0.200
    21.983     3.470     0.200
    22.110     3.017     0.200
    22.316     2.326     0.200
    22.460     3.379     0.200
    22.842     0.595     0.200
    23.234    -1.841     0.200
    23.911    -1.466     0.200
    23.922    -1.206     0.200
    23.922    -1.534     0.200
    23.966    -0.254     0.200
    23.966    -1.453     0.200
    23.966    -0.523     0.200
    23.966    -1.816     0.200
    24.497    -0.675     0.200
    24.683    -1.993     0.200
    25.156    -0.982     0.200
    26.214    -1.617     0.200
    26.203    -1.093     0.200
    26.481     0.792     0.200
    26.617    -0.039     0.200
    27.011     2.213     0.200
    27.011     2.897     0.200
    27.131     1.037     0.200
    27.400     0.918     0.200
    28.238     0.159     0.200
    28.521     0.109     0.200
    28.697     0.282     0.200
    28.966     1.146     0.200
    29.954     1.886     0.200
    30.281     1.038     0.200
    30.271    -0.919     0.200
    30.338     1.290     0.200
    30.338    -0.140     0.200
    30.338     0.591     0.200
    30.550     2.319     0.200
    30.550     2.619     0.200
    30.716    -0.247     0.200
    30.724    -0.221     0.200
    30.753     1.499     0.200
    30.800     2.114     0.200
    31.608     1.195     0.200
    32.711     2.210     0.200
    32.711     1.268     0.200
    33.396     2.027     0.200
    34.845    -0.853     0.200
    35.012     1.004     0.200
    35.258     0.385     0.200
    35.315     0.594     0.200
    35.315     0.332     0.200
    35.445     0.877     0.200
    36.492    -0.201     0.200
    36.568    -1.938     0.200
    36.611     0.870     0.200
    36.787     0.690     0.200
    37.039     0.190     0.200
    37.041     0.568     0.200
    38.747    -3.480     0.200
    38.810    -1.247     0.200
    39.041    -1.442     0.200
    39.041    -0.641     0.200
    39.126    -0.428     0.200
    39.392     1.721     0.200
    39.417    -1.085     0.200
    39.724     0.254     0.200
    40.757    -1.007     0.200
    40.760    -1.035     0.200
    41.056    -0.775     0.200
    41.428    -0.328     0.200
    42.689    -0.029     0.200
    42.789    -1.237     0.200
    42.932    -1.073     0.200
    42.932    -0.702     0.200
    42.941     0.128     0.200
    43.169     0.788     0.200
    43.684     1.332     0.200
    44.177     1.262     0.200
    44.231     0.732     0.200
    44.231     1.529     0.200
    44.420    -0.381     0.200
    44.720     1.425     0.200
    44.958     0.926     0.200
    44.958     0.215     0.200
    45.114     1.690     0.200
    45.156    -1.446     0.200
    45.197     0.514     0.200
    45.194     2.154     0.200
    45.213     1.299     0.200
    45.269     1.251     0.200
    45.282     0.294     0.200
    45.350     1.112     0.200
    45.494     0.752     0.200
    45.589     0.878     0.200
    45.734     0.970     0.200
    45.882    -2.498     0.200
    46.084     1.809     0.200
    46.157     0.734     0.200
    46.170     0.037     0.200
    46.415     1.304     0.200
    46.434     2.555     0.200
    46.787     0.584     0.200
    46.938     0.812     0.200
    46.951     1.604     0.200
    46.967     2.280     0.200
    46.967     1.878     0.200
    47.006     0.776     0.200
    47.006     0.374     0.200
    47.006     1.573     0.200
    47.042     0.715     0.200
    47.042     0.414     0.200
    47.083     1.271     0.200
    47.253     1.547     0.200
    47.271     1.304     0.200
    47.372    -0.485     0.200
    47.758     1.422     0.200
    47.806     2.746     0.200
    47.955     0.598     0.200
    48.115     0.071     0.200
    48.116    -1.379     0.200
    48.356    -1.475     0.200
    48.454     1.241     0.200
    48.571     1.037     0.200
    48.861     0.413     0.200
    48.898     0.624     0.200
    48.951    -0.081     0.200
    48.951    -1.023     0.200
    49.492    -0.417     0.200
    49.492    -1.120     0.200
    49.551     0.530     0.200
    49.836     0.358     0.200
    49.966    -0.031     0.200
    50.250     0.517     0.200
    50.359    -0.013     0.200
    50.359     1.487     0.200
    50.384    -0.809     0.200
    50.453    -1.435     0.200
    50.996     1.384     0.200
    51.050     1.071     0.200
    51.119     0.559     0.200
    51.126     0.708     0.200
    51.522     0.686     0.200
    51.522     0.334     0.200
    51.568     0.187     0.200
    51.570     0.149     0.200
    51.720     0.458     0.200
    51.854     0.503     0.200
    52.101     0.068     0.200
    52.191     0.593     0.200
    52.223     0.585     0.200
    52.237     1.702     0.200
    52.244     0.776     0.200
    52.614    -0.139     0.200
    52.645     0.080     0.200
    52.646     0.080     0.200
    52.924    -0.123     0.200
    52.980     0.297     0.200
    53.032    -0.522     0.200
    53.103    -0.105     0.200
    53.177     0.349     0.200
    53.202     1.965     0.200
    53.613     1.542     0.200
    53.958    -1.844     0.200
    54.002    -1.601     0.200
    54.002    -1.152     0.200
    54.011     1.329     0.200
    54.455     0.390     0.200
    54.455     0.390     0.200
    54.483    -0.516     0.200
    54.513     0.117     0.200
    54.830    -0.739     0.200
    55.040     0.443     0.200
    55.130    -0.873     0.200
    55.662    -0.263     0.200
    56.156     0.708     0.200
    56.264     0.661     0.200
    56.418     1.169     0.200
    56.418     1.560     0.200
    56.766     0.384     0.200
    56.819    -0.292     0.200
    57.207    -0.540     0.200
    57.400    -0.005     0.200
    57.592    -0.858     0.200
    57.718     1.535     0.200
    57.883     0.898     0.200
    57.891    -0.860     0.200
    57.971     1.682     0.200
    57.994    -0.183     0.200
    58.051     2.122     0.200
    58.069    -0.912     0.200
    58.093    -0.276     0.200
    58.119     0.040     0.200
    58.128     0.078     0.200
    58.270    -0.819     0.200
    58.340    -0.402     0.200
    58.404     1.148     0.200
    58.486    -0.422     0.200
    58.619    -0.756     0.200
    58.632     1.293     0.200
    58.624    -1.164     0.200
    58.645    -0.532     0.200
    58.847    -0.336     0.200
    58.884    -0.492     0.200
    59.082    -1.866     0.200
    59.277     0.080     0.200
    59.686    -0.441     0.200
    59.690    -1.272     0.200
    59.696    -0.510     0.200
    59.843    -0.927     0.200
    59.972    -1.009     0.200
    60.137    -1.039     0.200
    60.150     0.570     0.200
    60.454    -0.210     0.200
    60.461     0.035     0.200
    60.904    -0.484     0.200
    61.024    -0.494     0.200
    61.473    -0.237     0.200
    61.795    -0.410     0.200
    61.972    -0.303     0.200
    62.160    -0.560     0.200
    62.375    -0.403     0.200
    62.499    -1.331     0.200
    62.514    -1.232     0.200
    63.199    -0.599     0.200
    63.626    -0.919     0.200
    63.869    -0.119     0.200
    64.060    -1.180     0.200
    64.267    -0.139     0.200
    65.303     1.007     0.200
    66.283     0.286     0.200
    67.361    -0.710     0.200
    67.361     0.068     0.200
    67.685    -0.132     0.200
    69.383    -0.243     0.200
    69.642     1.558     0.200
    70.148     0.849     0.200
    70.805     1.728     0.200
    72.021    -1.261     0.200
    72.029    -0.324     0.200
    72.193    -0.503     0.200
    73.782    -1.347     0.200
    74.260    -0.749     0.200
    75.683    -0.289     0.200
    75.956    -1.029     0.200
    77.731    -0.751     0.200
    77.836    -0.196     0.200
    78.075    -1.153     0.200
    78.110     0.452     0.200
    78.222    -1.122     0.200
    78.422    -1.078     0.200
    78.590    -0.876     0.200
    78.590    -0.751     0.200
    78.642    -1.041     0.200
    79.929    -0.833     0.200
    80.077     0.003     0.200
    80.156    -0.545     0.200
    80.214    -0.262     0.200
    80.604    -1.260     0.200
    80.735     1.659     0.200
    80.743    -0.230     0.200
    80.743     0.395     0.200
    80.954    -1.260     0.200
    81.752    -0.561     0.200
    81.752     1.240     0.200
    81.886     0.020     0.200
    81.935    -0.224     0.200
    81.935     0.323     0.200
    82.537    -0.680     0.200
    82.590     0.848     0.200
    82.691     0.917     0.200
    82.904    -0.190     0.200
    84.792    -1.345     0.200
    84.792    -1.545     0.200
    84.792    -0.494     0.200
    86.822    -1.970     0.200
    90.874    -0.569     0.200
    19.613    -0.104     0.200
    22.562    -1.009     0.200
    22.740    -0.153     0.200
    23.437     0.179     0.200
    27.315     0.867     0.200
    48.491    -0.699     0.200
    71.868    -0.836     0.200
    78.288    -1.612     0.200
    86.276    -1.350     0.200
    20.247    -0.369     0.200
    20.810    -0.675     0.200
    24.326    -0.585     0.200
    24.290    -0.718     0.200
    26.624     0.139     0.200
    26.807     1.456     0.200
    43.313     0.283     0.200
    45.571    -0.050     0.200
    47.390     0.047     0.200
    50.305     0.185     0.200
    58.479    -0.401     0.200
    58.489    -0.466     0.200
    71.663    -0.762     0.200
    73.979     0.160     0.200
    15.139     8.438     0.200
    18.877    -1.025     0.200
    20.623    -0.872     0.200
    20.623    -1.052     0.200
    20.712    -1.054     0.200
    20.829     0.485     0.200
    20.829    -0.205     0.200
    20.986     0.497     0.200
    23.622    -0.491     0.200
    23.622    -0.007     0.200
    23.868     0.718     0.200
    24.028    -0.146     0.200
    24.028    -0.033     0.200
    24.082     0.847     0.200
    24.201    -0.020     0.200
    24.201    -0.920     0.200
    24.461     0.696     0.200
    24.461     1.071     0.200
    24.937    -0.731     0.200
    25.604     0.100     0.200
    26.178     0.322     0.200
    26.178     0.084     0.200
    27.068     0.544     0.200
    32.303     0.224     0.200
    38.501    -0.617     0.200
    38.771     0.676     0.200
    40.284    -0.099     0.200
    40.284    -0.100     0.200
    42.479    -0.121     0.200
    42.785    -0.530     0.200
    42.794    -0.483     0.200
    43.974     1.294     0.200
    44.028     1.362     0.200
    44.512     1.284     0.200
    44.512     1.704     0.200
    45.085     0.722     0.200
    45.097     0.510     0.200
    45.142     0.468     0.200
    45.153    -1.018     0.200
    45.435     0.545     0.200
    46.743    -0.163     0.200
    46.773     0.999     0.200
    46.949    -0.692     0.200
    46.949    -0.178     0.200
    49.942    -0.065     0.200
    50.197     0.011     0.200
    51.043     1.241     0.200
    52.755     0.351     0.200
    53.956    -1.055     0.200
    53.956    -0.834     0.200
    55.481    -1.358     0.200
    55.556    -0.647     0.200
    57.038    -0.027     0.200
    57.381     0.063     0.200
    57.719    -0.537     0.200
    57.784    -0.294     0.200
    57.924     0.323     0.200
    57.934     0.257     0.200
    58.069    -0.789     0.200
    58.156    -0.199     0.200
    58.345    -0.620     0.200
    58.335    -0.652     0.200
    58.408    -0.662     0.200
    58.479    -0.460     0.200
    59.498    -0.331     0.200
    59.537    -0.611     0.200
    59.663    -0.565     0.200
    59.795    -1.176     0.200
    59.958    -0.795     0.200
    60.842    -0.241     0.200
    61.280    -0.613     0.200
    61.814    -0.821     0.200
    62.339    -0.940     0.200
    62.340    -1.049     0.200
    62.994    -0.312     0.200
    63.469    -0.658     0.200
    63.664     0.053     0.200
    63.905    -0.838     0.200
    63.955    -1.168     0.200
    67.103    -0.829     0.200
    67.138    -0.344     0.200
    72.221    -1.133     0.200
    72.223    -0.991     0.200
    73.387    -0.482     0.200
    74.436    -1.295     0.200
    75.558    -0.062     0.200
    76.340    -0.941     0.200
    78.177    -0.958     0.200
    78.775    -1.536     0.200
    78.903    -0.909     0.200
    80.997     0.029     0.200
    80.997     0.119     0.200
    82.130     0.386     0.200
    82.140    -0.667     0.200
    88.427    -0.271     0.200
    20.750    -0.608     0.200
    20.839    -1.021     0.200
    24.243    -0.174     0.200
    24.243    -0.145     0.200
    24.254    -0.737     0.200
    24.822     0.306     0.200
    26.539     0.291     0.200
    26.811     0.759     0.200
    39.861    -0.544     0.200
    39.861    -0.549     0.200
    43.223    -0.570     0.200
    45.488    -0.088     0.200
    47.306    -0.213     0.200
    50.227     0.165     0.200
    58.389     0.179     0.200
    58.399     0.214     0.200
    60.250    -0.886     0.200
    61.300    -0.432     0.200
    67.617    -0.463     0.200
    73.980    -1.104     0.200
    73.902    -1.496     0.200
    78.709    -0.635     0.200
    82.643     1.151     0.200
    87.142    -1.280     0.200
    15.037     6.319     0.200
    18.705    -1.314     0.200
    20.103    -0.512     0.200
    20.471    -0.512     0.200
    20.475    -0.553     0.200
    20.596    -1.143     0.200
    20.684    -1.166     0.200
    20.677     0.153     0.200
    20.685    -2.136     0.200
    20.801     0.212     0.200
    20.867     0.194     0.200
    21.168     0.150     0.200
    22.333     0.660     0.200
    22.652    -1.028     0.200
    22.824     3.850     0.200
    23.016     2.425     0.200
    23.364     0.057     0.200
    23.503     1.793     0.200
    24.040    -0.542     0.200
    24.094    -0.836     0.200
    24.144    -1.044     0.200
    24.144    -0.485     0.200
    24.532    -0.208     0.200
    24.749    -0.509     0.200
    24.894    -0.429     0.200
    26.249     0.181     0.200
    26.505    -0.033     0.200
    26.610     0.823     0.200
    26.774    -0.663     0.200
    26.919     1.213     0.200
    27.805     1.282     0.200
    30.421     1.551     0.200
    30.421    -0.227     0.200
    31.509     0.959     0.200
    32.434     0.430     0.200
    35.429    -0.783     0.200
    36.322    -1.436     0.200
    36.922    -0.962     0.200
    38.327    -0.145     0.200
    38.821    -1.199     0.200
    38.920     0.170     0.200
    39.731    -0.202     0.200
    40.100    -0.463     0.200
    40.100    -0.464     0.200
    42.274    -0.518     0.200
    42.896    -0.500     0.200
    42.905    -0.572     0.200
    43.061     0.013     0.200
    44.103     2.164     0.200
    44.157     1.134     0.200
    44.643     1.749     0.200
    45.208     0.449     0.200
    45.212     0.814     0.200
    45.246    -1.452     0.200
    45.272     0.238     0.200
    45.565     0.012     0.200
    45.901    -1.043     0.200
    47.019    -0.415     0.200
    47.110    -0.026     0.200
    47.682     1.121     0.200
    47.754     2.465     0.200
    47.905     0.487     0.200
    48.410    -0.311     0.200
    49.210    -1.256     0.200
    49.587    -0.236     0.200
    49.979     0.077     0.200
    51.083     0.437     0.200
    51.222     0.699     0.200
    52.587    -0.353     0.200
    52.874     0.099     0.200
    54.031    -1.102     0.200
    54.031    -0.801     0.200
    54.770    -0.562     0.200
    55.489    -0.270     0.200
    57.078     0.087     0.200
    57.538    -0.658     0.200
    57.838    -0.468     0.200
    57.916    -0.715     0.200
    58.051     0.239     0.200
    58.060     0.072     0.200
    58.147    -0.132     0.200
    58.197     0.013     0.200
    58.447    -0.134     0.200
    59.385    -1.544     0.200
    59.784    -0.602     0.200
    59.915    -1.004     0.200
    60.964    -0.271     0.200
    61.181    -0.443     0.200
    62.177    -1.459     0.200
    62.976    -1.091     0.200
    67.274     0.420     0.200
    69.504     0.041     0.200
    72.093    -1.013     0.200
    72.094    -1.124     0.200
    73.568    -0.172     0.200
    74.315    -0.944     0.200
    75.395    -1.191     0.200
    78.337    -0.674     0.200
    78.335    -0.466     0.200
    78.682    -1.482     0.200
    80.852     0.049     0.200
    82.029    -0.186     0.200
    82.314     0.520     0.200
    83.291    -1.753     0.200
    84.840    -1.249     0.200
    87.044    -1.758     0.200
    90.807    -0.944     0.200
    20.266    -1.157     0.200
    20.266    -0.880     0.200
    20.359     0.152     0.200
    20.359    -0.388     0.200
    22.141     0.169     0.200
    23.405    -0.325     0.200
    23.456    -0.220     0.200
    23.484     1.100     0.200
    23.484     0.323     0.200
    24.060    -1.063     0.200
    25.199     0.189     0.200
    25.199     0.306     0.200
    27.702     1.446     0.200
    37.451     0.527     0.200
    41.606     0.094     0.200
    44.743    -0.837     0.200
    45.972    -0.234     0.200
    49.145    -0.660     0.200
    51.541     0.203     0.200
    52.943    -0.709     0.200
    56.678    -0.015     0.200
    56.688     0.417     0.200
    57.142    -1.204     0.200
    57.397    -0.206     0.200
    58.434    -0.980     0.200
    72.050     0.043     0.200
    72.050    -0.028     0.200
    73.478    -0.410     0.200
    73.480    -0.369     0.200
    75.664    -0.295     0.200
    78.870    -0.924     0.200
    80.804     0.922     0.200
    86.167    -0.761     0.200
    86.913    -0.974     0.200
    16.076     5.611     0.200
    16.185     2.801     0.200
    19.388    -0.995     0.200
    19.483     0.196     0.200
    19.657     0.795     0.200
    20.433     1.144     0.200
    20.697     0.962     0.200
    20.976     0.160     0.200
    21.691     1.321     0.200
    22.139    -0.506     0.200
    22.174     0.815     0.200
    22.457    -0.990     0.200
    22.457    -0.476     0.200
    22.507    -0.527     0.200
    22.507    -0.226     0.200
    22.518    -0.539     0.200
    22.518     0.109     0.200
    22.734     0.870     0.200
    22.917    -0.671     0.200
    22.952    -0.445     0.200
    23.260    -0.035     0.200
    23.260    -0.863     0.200
    23.260     0.414     0.200
    24.234     0.053     0.200
    25.637    -0.337     0.200
    26.204     3.697     0.200
    26.260    -0.975     0.200
    26.923    -0.561     0.200
    27.345     1.543     0.200
    28.588     0.350     0.200
    28.588     0.100     0.200
    28.748     0.424     0.200
    30.201    -0.078     0.200
    31.283     0.502     0.200
    34.764     1.100     0.200
    35.390     0.005     0.200
    36.694     0.348     0.200
    37.627    -0.182     0.200
    37.627     0.425     0.200
    40.704    -1.396     0.200
    40.712    -0.662     0.200
    40.735    -0.751     0.200
    41.048     0.474     0.200
    41.380    -0.754     0.200
    41.380    -0.755     0.200
    41.872     1.309     0.200
    41.926     1.269     0.200
    42.411     1.414     0.200
    42.411     1.721     0.200
    42.815     0.621     0.200
    42.986     0.251     0.200
    42.989    -0.055     0.200
    43.040     0.511     0.200
    43.996    -0.743     0.200
    44.052    -0.888     0.200
    44.454     0.438     0.200
    44.460     0.196     0.200
    44.806     1.729     0.200
    44.983    -0.280     0.200
    45.007     0.080     0.200
    45.207    -1.260     0.200
    45.403     0.982     0.200
    47.714     0.465     0.200
    47.793     0.248     0.200
    48.173     0.360     0.200
    48.173     0.284     0.200
    48.700    -1.352     0.200
    48.882     0.056     0.200
    48.882     0.354     0.200
    49.076     0.462     0.200
    49.290     0.247     0.200
    49.952     0.152     0.200
    50.039     0.223     0.200
    50.379     0.089     0.200
    50.661    -0.081     0.200
    50.720    -0.026     0.200
    50.950    -0.457     0.200
    51.668    -0.570     0.200
    51.984    -0.899     0.200
    51.984    -0.649     0.200
    52.159    -0.526     0.200
    52.200    -0.477     0.200
    52.549    -0.722     0.200
    52.846    -0.777     0.200
    53.382    -0.690     0.200
    55.282    -0.245     0.200
    55.322    -0.857     0.200
    55.624    -0.828     0.200
    55.683    -0.549     0.200
    55.719    -0.808     0.200
    55.823    -0.059     0.200
    55.833    -0.025     0.200
    55.967    -0.788     0.200
    56.057    -0.529     0.200
    56.277    -1.125     0.200
    57.397    -0.547     0.200
    57.564    -0.928     0.200
    57.860    -1.107     0.200
    58.149    -0.332     0.200
    58.744    -0.480     0.200
    59.179    -0.303     0.200
    59.487    -0.429     0.200
    59.725    -0.573     0.200
    59.915    -0.179     0.200
    60.927     0.007     0.200
    60.892    -1.455     0.200
    61.562    -0.991     0.200
    61.865    -0.536     0.200
    61.963    -0.293     0.200
    64.982     0.046     0.200
    65.038    -0.340     0.200
    68.387     0.625     0.200
    68.468     0.117     0.200
    71.571    -1.161     0.200
    71.571    -0.882     0.200
    74.323    -0.010     0.200
    74.325     0.357     0.200
    75.000     0.640     0.200
    75.350    -0.935     0.200
    75.391     0.038     0.200
    76.533    -0.024     0.200
    76.564    -0.405     0.200
    76.907     0.231     0.200
    77.538    -0.246     0.200
    77.777    -0.458     0.200
    77.819    -1.138     0.200
    77.819    -0.117     0.200
    78.009    -1.064     0.200
    78.068    -1.265     0.200
    78.156    -1.011     0.200
    78.156    -1.360     0.200
    78.683    -0.824     0.200
    79.211    -1.120     0.200
    79.550    -0.565     0.200
    79.581    -0.537     0.200
    79.798    -0.585     0.200
    79.974    -0.765     0.200
    80.007    -1.144     0.200
    80.208    -0.261     0.200
    80.356    -0.227     0.200
    80.596    -0.728     0.200
    81.059    -0.359     0.200
    81.762     0.685     0.200
    83.085    -0.694     0.200
    83.085     0.380     0.200
    83.839     0.461     0.200
    86.076    -1.439     0.200
    86.076    -1.445     0.200
    87.049    -0.783     0.200
    87.049    -0.527     0.200
    17.803     2.547     0.200
    18.553    -1.873     0.200
    18.686    -1.610     0.200
    18.742    -0.356     0.200
    18.772    -0.375     0.200
    20.108    -0.287     0.200
    20.111    -0.429     0.200
    20.153    -0.479     0.200
    20.320    -0.357     0.200
    20.320    -0.349     0.200
    20.320    -0.497     0.200
    20.339    -0.108     0.200
    20.355    -1.035     0.200
    20.582    -0.442     0.200
    20.792    -1.365     0.200
    20.881    -0.974     0.200
    20.881    -1.170     0.200
    21.468    -0.499     0.200
    21.970    -0.380     0.200
    22.403     0.325     0.200
    22.465     3.747     0.200
    22.467     0.741     0.200
    23.000    -0.031     0.200
    23.143     1.360     0.200
    23.361     0.064     0.200
    23.460    -1.770     0.200
    24.152     0.861     0.200
    24.285    -1.406     0.200
    24.285    -0.906     0.200
    24.285    -0.757     0.200
    24.290    -0.944     0.200
    24.294    -0.653     0.200
    24.348    -0.634     0.200
    24.348     0.170     0.200
    24.348    -0.455     0.200
    24.499    -0.514     0.200
    24.515     0.997     0.200
    24.781     1.920     0.200
    24.779     1.023     0.200
    24.854     0.206     0.200
    25.050    -1.624     0.200
    25.070    -0.300     0.200
    25.128     0.039     0.200
    25.345     2.890     0.200
    25.327     0.765     0.200
    25.366    -0.054     0.200
    26.572     0.094     0.200
    26.610     1.145     0.200
    26.748     0.804     0.200
    26.847     1.301     0.200
    26.847     1.301     0.200
    26.858     1.278     0.200
    27.215     0.496     0.200
    27.528     0.589     0.200
    27.790     0.886     0.200
    28.166     0.062     0.200
    28.405     0.960     0.200
    28.789    -0.156     0.200
    29.266     1.206     0.200
    30.332     0.270     0.200
    30.713    -0.097     0.200
    30.713     0.005     0.200
    30.825     1.416     0.200
    30.833     0.842     0.200
    30.801     2.226     0.200
    30.801     2.999     0.200
    31.007     0.708     0.200
    31.066     0.079     0.200
    31.280     0.509     0.200
    31.750     1.365     0.200
    31.750     0.787     0.200
    31.880     0.080     0.200
    31.930     2.621     0.200
    32.213    -1.100     0.200
    32.168     3.660     0.200
    32.745     1.934     0.200
    32.745     0.778     0.200
    32.796     0.114     0.200
    32.822     3.064     0.200
    32.914    -0.943     0.200
    32.994     0.259     0.200
    32.994     0.470     0.200
    34.169    -0.166     0.200
    34.936     0.387     0.200
    35.324     0.150     0.200
    35.324     0.603     0.200
    35.546     1.641     0.200
    35.697     1.159     0.200
    35.775    -0.519     0.200
    36.318    -0.568     0.200
    36.406     1.227     0.200
    36.531     1.804     0.200
    36.949     2.896     0.200
    36.956     1.999     0.200
    36.968     0.403     0.200
    37.113     0.250     0.200
    37.270    -0.273     0.200
    38.886    -1.710     0.200
    39.209    -0.306     0.200
    39.283    -0.116     0.200
    39.283    -0.117     0.200
    39.540    -1.265     0.200
    39.883    -0.690     0.200
    39.883    -0.721     0.200
    39.888    -1.181     0.200
    39.883    -0.690     0.200
    39.933     1.359     0.200
    40.063    -0.525     0.200
    40.068     0.141     0.200
    40.068    -0.461     0.200
    40.647    -0.089     0.200
    41.039    -1.094     0.200
    41.857     1.502     0.200
    42.815     0.501     0.200
    42.900    -0.281     0.200
    43.083    -0.070     0.200
    43.248    -0.783     0.200
    43.248    -0.307     0.200
    43.248    -0.807     0.200
    43.257     0.222     0.200
    43.257    -0.379     0.200
    43.280    -0.644     0.200
    43.382     0.614     0.200
    43.419     0.117     0.200
    43.451     0.457     0.200
    43.646     0.287     0.200
    44.231    -0.126     0.200
    44.464     1.424     0.200
    44.518     1.689     0.200
    44.542     0.597     0.200
    44.568     0.995     0.200
    45.004     1.618     0.200
    45.219    -2.593     0.200
    45.241    -0.866     0.200
    45.566     0.952     0.200
    45.570    -0.019     0.200
    45.579    -0.138     0.200
    45.634     0.726     0.200
    46.232    -0.199     0.200
    46.466    -0.742     0.200
    46.547    -0.372     0.200
    46.547    -0.693     0.200
    46.535     0.721     0.200
    46.649     1.229     0.200
    47.053     1.070     0.200
    47.259     1.158     0.200
    47.314     0.331     0.200
    47.314     0.432     0.200
    47.338    -0.255     0.200
    47.338    -0.232     0.200
    47.372    -0.823     0.200
    47.372    -0.721     0.200
    47.556     0.350     0.200
    47.576    -1.702     0.200
    48.043     0.876     0.200
    48.071    -0.139     0.200
    48.192    -0.515     0.200
    48.192    -1.077     0.200
    48.194    -0.622     0.200
    48.261    -0.309     0.200
    48.756    -1.115     0.200
    48.878     0.344     0.200
    48.878     0.445     0.200
    49.113     0.340     0.200
    49.159    -0.015     0.200
    49.159     0.790     0.200
    49.209    -0.093     0.200
    49.209     1.563     0.200
    49.281    -0.049     0.200
    49.281    -1.964     0.200
    49.285    -0.171     0.200
    49.869     0.467     0.200
    49.887     0.434     0.200
    50.088     0.507     0.200
    50.264    -0.279     0.200
    50.264     0.057     0.200
    50.275     0.488     0.200
    50.668     0.518     0.200
    50.668     0.917     0.200
    50.851    -0.958     0.200
    50.851    -0.856     0.200
    51.178    -0.516     0.200
    51.151    -0.219     0.200
    51.209    -1.507     0.200
    51.209    -0.593     0.200
    51.302     0.851     0.200
    51.438     0.838     0.200
    51.630     0.598     0.200
    51.868     0.092     0.200
    52.026     0.145     0.200
    52.445    -0.565     0.200
    52.484     0.534     0.200
    52.510     0.140     0.200
    52.537     0.326     0.200
    52.550     0.952     0.200
    52.598     0.296     0.200
    52.663     0.316     0.200
    52.928     0.045     0.200
    52.928     0.357     0.200
    52.945    -0.608     0.200
    52.953    -0.027     0.200
    52.953     0.887     0.200
    53.230     0.233     0.200
    53.230    -0.173     0.200
    53.230    -0.142     0.200
    53.287     0.317     0.200
    53.287    -0.339     0.200
    53.291     0.183     0.200
    53.297     0.637     0.200
    53.494    -0.204     0.200
    53.743     0.262     0.200
    53.901     0.406     0.200
    53.942     0.010     0.200
    53.966     0.336     0.200
    53.988     0.370     0.200
    53.997     0.305     0.200
    54.089     0.236     0.200
    54.121     1.000     0.200
    54.165     0.685     0.200
    54.270     0.118     0.200
    54.357    -1.113     0.200
    54.357    -1.363     0.200
    54.357    -1.363     0.200
    54.419     0.128     0.200
    54.531    -0.615     0.200
    54.765     0.921     0.200
    54.766     1.015     0.200
    54.780    -0.869     0.200
    54.906     0.401     0.200
    54.957     0.331     0.200
    55.089     0.274     0.200
    55.129    -0.802     0.200
    55.339    -0.810     0.200
    55.423    -0.033     0.200
    55.427    -0.454     0.200
    55.699    -0.419     0.200
    55.803     0.265     0.200
    55.961    -0.606     0.200
    56.131     0.534     0.200
    56.480     0.204     0.200
    56.645    -0.073     0.200
    56.833     0.392     0.200
    56.833    -0.554     0.200
    57.055     0.016     0.200
    57.074     0.385     0.200
    57.623    -0.492     0.200
    57.703     0.046     0.200
    57.865    -0.088     0.200
    57.967     0.561     0.200
    57.967    -0.111     0.200
    58.030     1.004     0.200
    58.030     0.551     0.200
    58.166     0.394     0.200
    58.377     0.523     0.200
    58.470     0.476     0.200
    58.554    -0.813     0.200
    58.860    -0.216     0.200
    58.860     0.768     0.200
    58.946     0.253     0.200
    58.967     0.629     0.200
    59.067    -0.080     0.200
    59.299    -1.232     0.200
    59.303    -1.250     0.200
    60.446     0.033     0.200
    60.758     0.199     0.200
    60.878     0.389     0.200
    60.915     0.036     0.200
    62.518     0.437     0.200
    62.518    -0.071     0.200
    62.976    -0.422     0.200
    63.230    -1.407     0.200
    63.663     0.727     0.200
    64.189     0.830     0.200
    64.720    -2.207     0.200
    64.892    -1.122     0.200
    65.163     0.915     0.200
    65.200     2.470     0.200
    67.435     0.057     0.200
    67.636    -0.162     0.200
    67.960     0.244     0.200
    69.275     0.333     0.200
    69.731     1.618     0.200
    69.765    -0.489     0.200
    69.765     0.136     0.200
    70.051    -0.353     0.200
    70.420     0.492     0.200
    70.841     0.517     0.200
    70.985     0.647     0.200
    71.409     0.483     0.200
    71.732    -1.042     0.200
    71.732    -0.464     0.200
    71.734    -1.175     0.200
    71.734    -0.074     0.200
    71.734    -0.847     0.200
    73.901    -0.353     0.200
    73.901    -0.346     0.200
    73.958    -1.168     0.200
    73.958    -1.168     0.200
    73.915    -0.722     0.200
    75.037     1.258     0.200
    75.776    -0.088     0.200
    75.885    -0.728     0.200
    76.013    -0.038     0.200
    77.453     0.128     0.200
    77.714     1.502     0.200
    78.053    -0.603     0.200
    78.201     0.351     0.200
    78.403    -0.352     0.200
    78.403    -0.141     0.200
    78.458     1.021     0.200
    78.448    -0.297     0.200
    78.540     0.095     0.200
    78.587    -0.961     0.200
    78.637    -0.966     0.200
    78.641     1.155     0.200
    78.739    -0.252     0.200
    78.751    -2.077     0.200
    78.751    -1.319     0.200
    78.751    -1.319     0.200
    78.938    -0.498     0.200
    78.942     0.086     0.200
    79.010    -1.491     0.200
    79.209    -0.581     0.200
    79.809    -0.100     0.200
    80.044    -0.097     0.200
    80.082     0.685     0.200
    80.264    -0.387     0.200
    80.474    -0.333     0.200
    80.488     0.464     0.200
    80.488     0.589     0.200
    80.540    -0.393     0.200
    80.650    -0.241     0.200
    80.860    -0.104     0.200
    81.290    -0.355     0.200
    81.477     0.108     0.200
    81.881     0.311     0.200
    82.055     0.469     0.200
    82.055     0.172     0.200
    82.186     0.090     0.200
    82.364     0.311     0.200
    82.640     0.511     0.200
    82.640     1.011     0.200
    82.690     0.352     0.200
    82.799     0.745     0.200
    83.005     0.015     0.200
    84.490     0.497     0.200
    84.484    -2.005     0.200
    86.226     1.166     0.200
    87.184    -1.798     0.200
    87.184    -2.353     0.200
    88.433     0.605     0.200
    91.602     0.292     0.200
    95.742     0.057     0.200
    15.104     6.629     0.200
    16.983     1.929     0.200
    16.983     2.110     0.200
    18.573    -0.699     0.200
    19.556     0.719     0.200
    20.120    -0.337     0.200
    20.124     0.122     0.200
    20.150     0.183     0.200
    20.172    -0.205     0.200
    20.333     0.002     0.200
    20.333     0.153     0.200
    20.357     0.392     0.200
    20.799    -0.933     0.200
    20.887    -1.362     0.200
    21.983     1.264     0.200
    22.551     2.706     0.200
    22.795     0.863     0.200
    23.013     0.117     0.200
    23.153     1.731     0.200
    23.475     2.251     0.200
    23.512     0.588     0.200
    24.136     2.028     0.200
    24.190     0.933     0.200
    24.297    -0.855     0.200
    24.295    -0.580     0.200
    24.351     0.862     0.200
    24.351     1.562     0.200
    24.522     1.801     0.200
    24.520    -0.776     0.200
    24.558     0.979     0.200
    24.765     2.037     0.200
    24.851     0.407     0.200
    24.851     0.497     0.200
    25.060    -1.092     0.200
    25.083     0.092     0.200
    25.350    -0.218     0.200
    25.356     2.918     0.200
    26.044     0.380     0.200
    26.568    -0.011     0.200
    26.568     0.139     0.200
    26.765     0.967     0.200
    26.865     1.461     0.200
    27.548     0.726     0.200
    27.806     2.613     0.200
    28.412     1.109     0.200
    30.789     1.555     0.200
    30.789     0.845     0.200
    30.854    -0.126     0.200
    31.014     1.002     0.200
    31.731     1.252     0.200
    31.871    -0.790     0.200
    31.886    -0.291     0.200
    32.749     0.834     0.200
    32.785     0.768     0.200
    32.934     0.490     0.200
    37.263    -0.216     0.200
    39.118    -1.054     0.200
    39.198     0.378     0.200
    39.261     1.032     0.200
    39.270     0.617     0.200
    39.270     0.376     0.200
    39.786    -0.011     0.200
    39.903     0.302     0.200
    39.903     0.301     0.200
    40.063     0.177     0.200
    41.193     0.494     0.200
    43.240    -0.407     0.200
    43.240    -0.557     0.200
    43.249    -0.829     0.200
    43.371    -0.411     0.200
    43.440     0.028     0.200
    43.635     0.963     0.200
    44.454     1.689     0.200
    44.508     1.858     0.200
    44.556     0.873     0.200
    44.566     2.194     0.200
    44.994     1.683     0.200
    44.994     1.583     0.200
    45.391     0.929     0.200
    45.425    -0.943     0.200
    45.529    -0.216     0.200
    45.557     1.012     0.200
    45.623     0.187     0.200
    45.825    -0.170     0.200
    45.889    -0.183     0.200
    45.916     0.072     0.200
    45.921    -0.279     0.200
    46.458     0.609     0.200
    46.547    -0.093     0.200
    46.727    -0.805     0.200
    47.042     1.137     0.200
    47.224    -1.790     0.200
    47.249     1.315     0.200
    47.335    -0.238     0.200
    47.335    -0.204     0.200
    47.547     0.000     0.200
    47.567    -0.254     0.200
    47.983     1.517     0.200
    48.033     0.930     0.200
    48.212     0.243     0.200
    48.253     0.232     0.200
    49.150     0.533     0.200
    50.078     0.556     0.200
    50.267     0.827     0.200
    50.265     0.093     0.200
    50.436    -0.056     0.200
    50.660    -0.344     0.200
    51.390     1.264     0.200
    51.429     0.271     0.200
    51.622     0.327     0.200
    51.858     0.184     0.200
    52.018     0.376     0.200
    52.436     0.565     0.200
    52.474     0.573     0.200
    52.528     0.437     0.200
    52.542     1.983     0.200
    52.590     0.425     0.200
    52.877     0.424     0.200
    52.935    -0.319     0.200
    53.221     0.062     0.200
    53.278     0.046     0.200
    53.486    -0.783     0.200
    54.270     0.183     0.200
    54.353    -0.922     0.200
    54.353    -0.797     0.200
    54.771    -0.650     0.200
    55.119    -0.776     0.200
    55.329    -0.858     0.200
    55.418    -1.050     0.200
    55.716    -0.352     0.200
    55.716    -0.977     0.200
    55.793     0.247     0.200
    56.189    -0.264     0.200
    58.021    -0.632     0.200
    58.544    -0.483     0.200
    58.846    -0.091     0.200
    66.432    -0.326     0.200
    67.415     0.422     0.200
    67.625    -0.683     0.200
    70.675    -1.883     0.200
    71.742    -1.243     0.200
    71.744    -0.902     0.200
    73.883    -0.305     0.200
    73.967    -1.544     0.200
    75.052     2.004     0.200
    75.052     0.714     0.200
    75.756    -0.944     0.200
    76.027    -0.220     0.200
    78.067    -0.665     0.200
    78.416    -0.599     0.200
    78.429    -0.692     0.200
    78.765    -1.270     0.200
    78.950    -0.840     0.200
    78.956    -0.669     0.200
    80.097     1.159     0.200
    80.278    -1.116     0.200
    80.501    -0.057     0.200
    81.303    -0.871     0.200
    82.622     0.952     0.200
    84.503     0.173     0.200
    87.195    -1.534     0.200
    18.554    -2.979     0.200
    19.533    -0.200     0.200
    20.098    -0.355     0.200
    20.098    -0.956     0.200
    20.098     0.012     0.200
    20.101    -0.396     0.200
    20.149    -0.308     0.200
    20.173    -0.002     0.200
    20.310    -0.289     0.200
    20.310    -0.062     0.200
    20.332     0.200     0.200
    20.581     0.092     0.200
    20.794     0.193     0.200
    20.803    -1.730     0.200
    20.891    -0.955     0.200
    21.960    -0.234     0.200
    22.262     1.310     0.200
    22.322     3.645     0.200
    22.456     1.234     0.200
    22.454     1.416     0.200
    22.529     0.611     0.200
    22.771     0.496     0.200
    22.990     0.137     0.200
    22.986     1.729     0.200
    23.193     0.660     0.200
    23.355    -1.705     0.200
    23.468     2.398     0.200
    23.749     1.415     0.200
    23.753     0.881     0.200
    23.946     1.442     0.200
    23.951     2.511     0.200
    24.295    -1.112     0.200
    24.295    -0.776     0.200
    24.295    -0.558     0.200
    24.305    -0.782     0.200
    24.360    -0.341     0.200
    24.360    -0.544     0.200
    24.360    -1.076     0.200
    24.535     0.758     0.200
    24.497    -1.093     0.200
    24.524     0.642     0.200
    24.789     2.049     0.200
    25.060     0.079     0.200
    25.061    -0.627     0.200
    25.124    -0.272     0.200
    25.335     2.188     0.200
    25.374     0.502     0.200
    26.067     0.995     0.200
    26.222     1.696     0.200
    26.332     0.558     0.200
    26.584     0.284     0.200
    26.617     1.487     0.200
    26.753     0.654     0.200
    26.851     1.718     0.200
    26.970     1.703     0.200
    27.556     1.749     0.200
    27.528     1.089     0.200
    27.605     0.206     0.200
    27.741     1.495     0.200
    27.796     1.466     0.200
    27.796     1.200     0.200
    27.796     1.005     0.200
    28.252     1.291     0.200
    28.463     1.161     0.200
    29.262     0.557     0.200
    29.888     1.495     0.200
    30.344     0.580     0.200
    30.725     0.018     0.200
    30.725    -0.287     0.200
    30.725    -0.576     0.200
    30.811     1.552     0.200
    30.811     3.162     0.200
    30.811     1.146     0.200
    30.825     0.635     0.200
    30.833     1.358     0.200
    30.995    -0.767     0.200
    30.995     0.382     0.200
    31.278     0.837     0.200
    31.756     1.441     0.200
    31.756     1.261     0.200
    31.868     0.092     0.200
    31.893    -1.166     0.200
    32.460    -1.322     0.200
    32.733     1.662     0.200
    32.733     1.412     0.200
    32.807    -0.207     0.200
    32.911     0.209     0.200
    33.005     0.188     0.200
    33.005     1.063     0.200
    33.785    -0.114     0.200
    34.157     1.067     0.200
    34.255     2.610     0.200
    34.936     0.923     0.200
    35.010     1.782     0.200
    35.312     0.785     0.200
    35.312    -0.387     0.200
    35.464     0.976     0.200
    35.464     0.804     0.200
    35.555     0.899     0.200
    35.643     0.744     0.200
    35.752     2.317     0.200
    36.324     0.113     0.200
    36.622     0.074     0.200
    36.783     1.904     0.200
    36.862     2.526     0.200
    36.943     2.464     0.200
    36.950     2.223     0.200
    36.962     1.483     0.200
    37.281    -0.530     0.200
    37.431    -1.201     0.200
    38.166    -0.200     0.200
    38.356     1.594     0.200
    38.728     0.071     0.200
    38.779     0.093     0.200
    38.877     1.522     0.200
    38.885    -0.564     0.200
    38.968     0.470     0.200
    39.094     0.498     0.200
    39.131    -2.300     0.200
    39.219    -0.444     0.200
    39.293    -0.067     0.200
    39.293    -0.810     0.200
    39.293     0.144     0.200
    39.519     0.488     0.200
    39.538    -1.004     0.200
    39.751    -0.969     0.200
    39.882    -0.555     0.200
    39.882    -0.610     0.200
    39.943    -0.471     0.200
    39.943     0.458     0.200
    40.025    -0.520     0.200
    40.025     0.418     0.200
    40.052     1.434     0.200
    40.031     0.244     0.200
    40.126    -1.283     0.200
    40.080    -0.196     0.200
    40.080    -0.298     0.200
    40.129     0.598     0.200
    40.204     1.364     0.200
    40.493     0.568     0.200
    40.546     0.590     0.200
    40.636    -0.839     0.200
    40.725     0.414     0.200
    40.753     0.450     0.200
    41.028    -1.935     0.200
    41.171     0.836     0.200
    41.205    -1.585     0.200
    41.205    -1.156     0.200
    41.577     1.361     0.200
    41.846     1.955     0.200
    42.070    -1.369     0.200
    42.901     0.054     0.200
    43.094    -1.086     0.200
    43.214    -0.555     0.200
    43.242     0.422     0.200
    43.260    -0.700     0.200
    43.260    -0.427     0.200
    43.269    -0.702     0.200
    43.269    -1.171     0.200
    43.393     0.900     0.200
    43.393     0.299     0.200
    43.430    -0.100     0.200
    43.462     0.344     0.200
    43.656     0.777     0.200
    43.963     0.812     0.200
    43.963    -0.086     0.200
    44.475     1.113     0.200
    44.529     1.487     0.200
    44.553     0.590     0.200
    44.578     0.789     0.200
    44.587     0.522     0.200
    44.766    -1.509     0.200
    45.015     1.311     0.200
    45.055    -0.305     0.200
    45.055     0.195     0.200
    45.247    -0.434     0.200
    45.412     1.067     0.200
    45.422     0.779     0.200
    45.476     0.358     0.200
    45.476    -0.041     0.200
    45.546     0.321     0.200
    45.577     0.654     0.200
    45.644     0.625     0.200
    45.789    -0.616     0.200
    45.789    -1.319     0.200
    45.843     0.361     0.200
    45.906     0.323     0.200
    46.004    -2.115     0.200
    45.939     0.331     0.200
    46.004     0.187     0.200
    46.162     0.444     0.200
    46.244    -0.204     0.200
    46.360     0.593     0.200
    46.478    -0.037     0.200
    46.548     2.116     0.200
    46.559    -0.570     0.200
    46.559     0.031     0.200
    46.559    -0.242     0.200
    46.655     0.672     0.200
    46.630     0.563     0.200
    46.668    -0.028     0.200
    46.668    -0.426     0.200
    46.750     0.629     0.200
    46.750    -0.668     0.200
    46.784     2.063     0.200
    46.803     0.614     0.200
    46.865    -0.074     0.200
    46.890    -0.061     0.200
    46.890    -0.264     0.200
    46.937     0.269     0.200
    46.937     0.370     0.200
    47.064     0.176     0.200
    47.064     0.879     0.200
    47.064    -0.223     0.200
    47.070     0.230     0.200
    47.070     0.332     0.200
    47.096     0.126     0.200
    47.147    -0.275     0.200
    47.152     0.193     0.200
    47.146     1.334     0.200
    47.209    -0.356     0.200
    47.246     0.663     0.200
    47.270     0.870     0.200
    47.342    -0.792     0.200
    47.342    -1.816     0.200
    47.326     0.939     0.200
    47.356    -1.899     0.200
    47.350    -0.183     0.200
    47.373    -0.533     0.200
    47.373    -0.431     0.200
    47.384    -0.116     0.200
    47.408    -0.507     0.200
    47.419     0.109     0.200
    47.419    -0.094     0.200
    47.484     1.704     0.200
    47.460    -3.211     0.200
    47.567    -0.336     0.200
    47.587     0.408     0.200
    47.639    -0.000     0.200
    47.942    -1.449     0.200
    47.942    -2.246     0.200
    48.004     1.474     0.200
    48.191    -0.073     0.200
    48.191    -0.323     0.200
    48.191    -0.769     0.200
    48.223    -1.114     0.200
    48.235    -0.209     0.200
    48.254    -1.854     0.200
    48.280    -1.053     0.200
    48.280    -1.553     0.200
    48.273    -0.102     0.200
    48.462    -0.958     0.200
    48.498    -0.733     0.200
    48.666    -2.031     0.200
    48.714    -1.398     0.200
    48.819     1.000     0.200
    48.767     0.799     0.200
    48.859    -3.011     0.200
    48.859    -1.808     0.200
    48.884    -0.204     0.200
    48.884    -2.001     0.200
    48.889     1.055     0.200
    48.889     1.156     0.200
    49.017    -0.220     0.200
    49.103     1.019     0.200
    49.120     0.091     0.200
    49.133    -0.108     0.200
    49.170     0.308     0.200
    49.170     1.308     0.200
    49.170     0.902     0.200
    49.221    -1.678     0.200
    49.221    -1.576     0.200
    49.295    -0.250     0.200
    49.559    -0.365     0.200
    49.876     0.519     0.200
    49.881    -0.314     0.200
    50.099     0.532     0.200
    50.099     0.329     0.200
    50.286     0.113     0.200
    50.276     0.068     0.200
    50.276     0.060     0.200
    50.276    -0.151     0.200
    50.400    -0.446     0.200
    50.477     0.173     0.200
    50.418     0.412     0.200
    50.679    -0.058     0.200
    50.679     0.747     0.200
    50.841    -0.292     0.200
    50.862     0.067     0.200
    50.862     0.168     0.200
    51.199    -0.361     0.200
    51.199    -1.118     0.200
    51.199    -0.486     0.200
    51.199    -1.251     0.200
    51.163     0.215     0.200
    51.179     0.990     0.200
    51.270     0.575     0.200
    51.314     1.279     0.200
    51.410     0.883     0.200
    51.410     0.359     0.200
    51.449     0.469     0.200
    51.453     0.839     0.200
    51.676    -1.228     0.200
    51.642     0.723     0.200
    51.879     0.227     0.200
    52.038     0.272     0.200
    52.161     0.386     0.200
    52.338    -0.900     0.200
    52.512    -1.649     0.200
    52.456     0.072     0.200
    52.495     0.306     0.200
    52.489    -1.077     0.200
    52.521     0.702     0.200
    52.548     0.403     0.200
    52.561     1.386     0.200
    52.610     0.332     0.200
    52.674     0.454     0.200
    52.775     0.589     0.200
    52.876     0.265     0.200
    52.898     0.649     0.200
    52.909    -0.517     0.200
    52.940     0.269     0.200
    52.956    -0.053     0.200
    52.964     0.115     0.200
    52.964    -0.186     0.200
    53.176    -0.514     0.200
    53.241     0.273     0.200
    53.241    -0.078     0.200
    53.298    -0.244     0.200
    53.302     0.648     0.200
    53.309     0.473     0.200
    53.506     0.312     0.200
    53.505    -0.266     0.200
    53.505    -0.164     0.200
    53.657     0.003     0.200
    53.755     0.406     0.200
    53.815    -0.535     0.200
    53.912     0.355     0.200
    53.936     0.079     0.200
    53.953    -0.047     0.200
    53.978     0.472     0.200
    54.000     0.312     0.200
    53.988     0.555     0.200
    54.009     0.246     0.200
    54.100     0.382     0.200
    54.133     0.943     0.200
    54.176     0.729     0.200
    54.282    -3.144     0.200
    54.282    -0.041     0.200
    54.292     0.784     0.200
    54.369    -0.877     0.200
    54.369    -1.072     0.200
    54.430     0.275     0.200
    54.523    -1.481     0.200
    54.776     0.867     0.200
    54.777     0.758     0.200
    54.791    -0.350     0.200
    54.822    -0.395     0.200
    54.917     0.349     0.200
    54.968     0.276     0.200
    55.100     0.128     0.200
    55.140    -0.900     0.200
    55.350    -0.578     0.200
    55.434    -0.084     0.200
    55.438    -0.675     0.200
    55.705     0.071     0.200
    55.972    -0.315     0.200
    56.142     0.296     0.200
    56.209     0.068     0.200
    56.209    -0.331     0.200
    56.462    -0.440     0.200
    56.491     0.057     0.200
    56.656     0.085     0.200
    56.844     0.256     0.200
    56.844    -1.228     0.200
    57.067    -0.027     0.200
    57.225    -0.545     0.200
    57.234    -0.755     0.200
    57.695    -0.658     0.200
    57.695    -2.486     0.200
    57.979    -0.305     0.200
    58.041     0.225     0.200
    58.453     0.487     0.200
    58.565    -0.337     0.200
    58.869    -0.410     0.200
    58.957     0.159     0.200
    59.079     0.255     0.200
    59.303    -1.515     0.200
    59.989    -0.786     0.200
    61.215    -0.244     0.200
    62.529     0.921     0.200
    63.242    -1.021     0.200
    66.457    -0.145     0.200
    66.423    -1.030     0.200
    67.647     0.119     0.200
    67.647    -0.584     0.200
    67.970     0.159     0.200
    69.776    -0.073     0.200
    69.776    -0.416     0.200
    69.936    -0.055     0.200
    70.430    -0.480     0.200
    70.995     1.084     0.200
    71.505    -1.428     0.200
    71.721    -0.153     0.200
    71.723    -0.310     0.200
    71.723    -0.115     0.200
    73.908     0.103     0.200
    73.908    -0.124     0.200
    73.946    -0.349     0.200
    75.028     1.223     0.200
    75.028     0.091     0.200
    76.022     0.043     0.200
    78.061    -0.355     0.200
    78.445    -0.583     0.200
    78.445    -0.809     0.200
    78.411    -0.268     0.200
    78.411    -0.471     0.200
    78.547     0.197     0.200
    78.747    -0.751     0.200
    78.759    -1.062     0.200
    78.947    -0.628     0.200
    78.950     0.267     0.200
    80.089     0.467     0.200
    80.273    -0.774     0.200
    80.478     0.669     0.200
    80.478     0.474     0.200
    80.548    -0.308     0.200
    80.658    -0.294     0.200
    81.889    -0.004     0.200
    82.062     0.471     0.200
    82.062     0.573     0.200
    82.062     0.041     0.200
    82.371    -0.354     0.200
    82.646     0.816     0.200
    82.696     0.852     0.200
    82.800     0.913     0.200
    83.011     0.720     0.200
    84.473    -0.933     0.200
    84.473    -1.402     0.200
    87.164    -0.792     0.200
    87.194    -1.094     0.200
    88.442     0.539     0.200
    19.428     0.171     0.200
    20.514    -0.729     0.200
    20.604    -0.619     0.200
    21.055    -1.988     0.200
    22.734    -0.855     0.200
    23.881    -0.449     0.200
    24.126    -0.178     0.200
    25.983     0.626     0.200
    25.983     0.157     0.200
    27.127     1.649     0.200
    32.079     0.269     0.200
    38.544     0.193     0.200
    40.429    -0.474     0.200
    40.429    -0.475     0.200
    41.919     0.339     0.200
    42.569    -0.655     0.200
    42.578    -0.701     0.200
    43.346     0.110     0.200
    43.411     0.275     0.200
    43.751     1.409     0.200
    43.805     0.676     0.200
    44.289     1.492     0.200
    46.756    -0.172     0.200
    47.282     1.644     0.200
    47.329     0.378     0.200
    49.377     0.074     0.200
    49.773     0.336     0.200
    49.978     0.897     0.200
    49.978     0.067     0.200
    52.246     0.398     0.200
    52.535    -0.164     0.200
    53.758    -1.097     0.200
    53.758    -0.771     0.200
    58.118    -0.228     0.200
    66.913    -0.463     0.200
    72.445    -0.767     0.200
    72.446    -0.876     0.200
    73.175    -0.580     0.200
    74.657    -0.921     0.200
    74.657    -0.980     0.200
    75.398    -0.539     0.200
    75.783    -0.084     0.200
    78.398    -0.713     0.200
    78.743    -1.116     0.200
    78.845    -1.522     0.200
    81.922     0.169     0.200
    87.023    -1.496     0.200
    18.851    -0.692     0.200
    21.633    -0.654     0.200
    23.354    -0.534     0.200
    27.079     1.319     0.200
    37.974     0.275     0.200
    41.963    -0.488     0.200
    43.510    -2.025     0.200
    46.161    -0.098     0.200
    49.208     0.148     0.200
    51.933     0.177     0.200
    53.159    -1.073     0.200
    53.159    -0.620     0.200
    54.995    -0.132     0.200
    55.707    -0.604     0.200
    66.323     0.156     0.200
    72.719    -1.326     0.200
    73.041    -0.932     0.200
    75.258    -1.177     0.200
    78.455    -1.918     0.200
    81.801    -0.638     0.200
    81.913    -0.926     0.200
    86.631    -1.674     0.200
    15.159     5.716     0.200
    18.425    -2.289     0.200
    19.643    -2.037     0.200
    19.765     0.126     0.200
    19.765    -0.745     0.200
    19.893    -0.070     0.200
    20.012    -1.178     0.200
    20.025     0.688     0.200
    20.091    -0.523     0.200
    20.389     0.033     0.200
    20.713    -0.565     0.200
    20.991    -0.785     0.200
    21.132     1.889     0.200
    21.078    -0.426     0.200
    21.127    -0.048     0.200
    21.628     0.665     0.200
    21.860     1.075     0.200
    21.949     1.011     0.200
    21.949     0.906     0.200
    22.124     0.554     0.200
    22.285    -0.297     0.200
    22.285     1.117     0.200
    22.285     0.020     0.200
    22.308     1.029     0.200
    22.310     2.967     0.200
    22.407     2.123     0.200
    22.515     2.862     0.200
    22.658     0.773     0.200
    22.765     2.455     0.200
    22.803     0.141     0.200
    22.898     2.561     0.200
    23.064    -1.626     0.200
    23.163     2.750     0.200
    23.460    -1.088     0.200
    23.835     0.815     0.200
    24.130    -0.780     0.200
    24.203     0.957     0.200
    24.275    -1.001     0.200
    24.434    -0.661     0.200
    24.434    -0.450     0.200
    24.543    -1.048     0.200
    24.543    -0.037     0.200
    24.598    -0.049     0.200
    24.598    -0.811     0.200
    24.598     0.083     0.200
    24.729    -0.541     0.200
    24.810    -2.179     0.200
    24.866     0.014     0.200
    25.129    -0.479     0.200
    25.099    -0.712     0.200
    25.165     0.193     0.200
    25.165     0.807     0.200
    25.212    -0.834     0.200
    26.147     1.092     0.200
    26.181     1.484     0.200
    26.650     1.540     0.200
    26.627     1.256     0.200
    26.738     0.350     0.200
    26.794     1.404     0.200
    26.806     0.532     0.200
    26.882     0.356     0.200
    27.115     0.985     0.200
    27.240     2.033     0.200
    27.183     0.848     0.200
    27.183     1.332     0.200
    27.377     1.006     0.200
    27.474     1.734     0.200
    27.447     0.976     0.200
    27.696    -0.751     0.200
    27.791     0.801     0.200
    27.933     1.359     0.200
    28.074     1.070     0.200
    28.460     0.233     0.200
    28.460     0.234     0.200
    28.724     1.080     0.200
    29.011     0.633     0.200
    29.157     1.131     0.200
    29.850    -1.811     0.200
    30.371     1.184     0.200
    30.539    -0.199     0.200
    30.603     2.735     0.200
    30.607     0.497     0.200
    30.678     1.634     0.200
    30.678     1.270     0.200
    30.658     0.953     0.200
    30.666     0.878     0.200
    30.840     1.043     0.200
    30.996     0.493     0.200
    30.996     0.364     0.200
    31.075     0.075     0.200
    31.144     1.825     0.200
    31.144     2.126     0.200
    31.144     2.013     0.200
    31.409     2.538     0.200
    31.552    -0.016     0.200
    31.743    -1.958     0.200
    31.895    -0.352     0.200
    32.033     0.573     0.200
    32.225     1.053     0.200
    32.273     2.094     0.200
    32.436     2.308     0.200
    32.436     2.007     0.200
    32.593     0.731     0.200
    32.674     0.018     0.200
    32.927    -0.798     0.200
    33.138     0.008     0.200
    33.165     2.428     0.200
    33.336     0.837     0.200
    33.336     1.224     0.200
    33.526     2.544     0.200
    33.526     2.372     0.200
    33.852     0.534     0.200
    33.842     2.628     0.200
    33.958     2.418     0.200
    34.755     0.115     0.200
    34.768     1.096     0.200
    35.004     0.967     0.200
    35.339     0.480     0.200
    35.366     0.454     0.200
    35.379     0.132     0.200
    35.379     0.630     0.200
    35.451     1.213     0.200
    36.087    -0.138     0.200
    36.113     1.039     0.200
    36.241     2.093     0.200
    36.283     1.899     0.200
    36.329    -0.411     0.200
    36.464     1.238     0.200
    36.450    -0.243     0.200
    36.713     3.163     0.200
    36.654     3.016     0.200
    36.664     1.828     0.200
    36.680     2.096     0.200
    36.964     2.498     0.200
    37.009     1.601     0.200
    37.059     2.561     0.200
    37.194    -0.272     0.200
    37.504     0.760     0.200
    37.601    -0.325     0.200
    37.645     1.813     0.200
    37.687     0.938     0.200
    37.724    -0.327     0.200
    37.725    -0.575     0.200
    37.761     1.854     0.200
    37.790     0.449     0.200
    37.910     0.095     0.200
    38.044     2.430     0.200
    38.024    -0.303     0.200
    38.152     1.668     0.200
    38.202     0.197     0.200
    38.571     0.190     0.200
    38.595     0.523     0.200
    38.697    -0.477     0.200
    38.693    -0.171     0.200
    38.790     0.595     0.200
    39.345     0.075     0.200
    39.547     0.228     0.200
    39.559    -0.174     0.200
    39.551     0.795     0.200
    39.579    -1.070     0.200
    39.625     0.245     0.200
    39.625    -0.076     0.200
    39.625     0.077     0.200
    39.697     0.982     0.200
    39.739     1.332     0.200
    39.689     0.042     0.200
    39.689    -0.661     0.200
    39.695    -1.620     0.200
    39.689    -0.662     0.200
    39.790     0.466     0.200
    39.818    -0.728     0.200
    39.887     0.799     0.200
    39.896    -0.657     0.200
    40.059    -2.231     0.200
    40.136    -0.196     0.200
    40.305     1.380     0.200
    40.305     0.888     0.200
    40.390    -0.206     0.200
    40.390     0.025     0.200
    40.390     0.185     0.200
    40.526     1.102     0.200
    40.648     0.653     0.200
    40.680     0.694     0.200
    40.712     0.160     0.200
    40.839    -1.429     0.200
    40.838     1.221     0.200
    40.946     0.636     0.200
    40.950     0.802     0.200
    40.991    -0.442     0.200
    41.105    -1.076     0.200
    41.068    -0.271     0.200
    41.518     1.437     0.200
    41.742    -0.466     0.200
    41.762    -3.063     0.200
    41.746     0.333     0.200
    41.722    -1.114     0.200
    41.722    -0.559     0.200
    41.783     0.108     0.200
    41.913    -2.484     0.200
    42.341     0.148     0.200
    42.592    -0.991     0.200
    42.760    -0.101     0.200
    42.865     0.266     0.200
    42.906    -0.264     0.200
    43.015    -1.672     0.200
    43.021    -2.713     0.200
    43.022    -0.426     0.200
    43.144     0.496     0.200
    43.424     0.330     0.200
    43.434     1.247     0.200
    43.463    -0.044     0.200
    43.545    -0.049     0.200
    43.574     0.320     0.200
    43.574     0.120     0.200
    43.584    -0.438     0.200
    43.593    -0.636     0.200
    43.613    -0.059     0.200
    43.616    -1.271     0.200
    43.715     1.283     0.200
    43.725     0.403     0.200
    43.707     1.150     0.200
    43.746     2.390     0.200
    43.779     0.167     0.200
    43.793     0.355     0.200
    43.830    -2.447     0.200
    43.836     0.510     0.200
    43.988     0.786     0.200
    44.177    -0.185     0.200
    44.237    -1.150     0.200
    44.295    -0.075     0.200
    44.573     2.904     0.200
    44.584     1.614     0.200
    44.602     2.673     0.200
    44.647    -0.324     0.200
    44.742     0.014     0.200
    44.806     1.247     0.200
    44.860     1.419     0.200
    44.883     0.430     0.200
    44.910     1.112     0.200
    44.918     2.150     0.200
    45.072     0.528     0.200
    45.072     0.368     0.200
    45.082    -1.954     0.200
    45.119     2.355     0.200
    45.113    -2.500     0.200
    45.147     0.933     0.200
    45.245    -0.048     0.200
    45.251    -0.295     0.200
    45.251    -0.592     0.200
    45.251    -0.803     0.200
    45.346     1.851     0.200
    45.346     1.652     0.200
    45.387     0.425     0.200
    45.689    -2.160     0.200
    45.742     0.915     0.200
    45.770     2.396     0.200
    45.758    -0.309     0.200
    45.808     0.193     0.200
    45.806     1.013     0.200
    45.907     0.818     0.200
    45.919     0.618     0.200
    45.966     1.349     0.200
    45.976     0.672     0.200
    46.030     1.643     0.200
    46.121     0.527     0.200
    46.139     0.289     0.200
    46.165    -0.318     0.200
    46.157     0.222     0.200
    46.216     1.277     0.200
    46.219     0.212     0.200
    46.253     0.201     0.200
    46.269     0.766     0.200
    46.319    -0.158     0.200
    46.320     0.259     0.200
    46.336     2.833     0.200
    46.336     0.024     0.200
    46.372     0.955     0.200
    46.490     0.925     0.200
    46.490     0.816     0.200
    46.477     1.529     0.200
    46.573    -1.053     0.200
    46.549    -0.738     0.200
    46.804    -0.533     0.200
    46.823    -0.483     0.200
    46.823    -0.292     0.200
    46.877     0.396     0.200
    46.944    -0.253     0.200
    46.990     1.508     0.200
    47.000     0.329     0.200
    47.071     1.977     0.200
    47.082    -0.010     0.200
    47.070     0.184     0.200
    47.154     1.529     0.200
    47.197     2.693     0.200
    47.269     0.437     0.200
    47.242    -0.196     0.200
    47.295     1.131     0.200
    47.396     0.946     0.200
    47.396     0.743     0.200
    47.396     0.845     0.200
    47.396     0.446     0.200
    47.429    -0.109     0.200
    47.480     1.489     0.200
    47.477     1.314     0.200
    47.517    -0.201     0.200
    47.577     0.337     0.200
    47.600     0.957     0.200
    47.647     0.791     0.200
    47.652     0.753     0.200
    47.652     0.855     0.200
    47.645    -0.842     0.200
    47.646    -0.348     0.200
    47.705    -0.359     0.200
    47.702    -0.334     0.200
    47.723     0.908     0.200
    47.741    -0.031     0.200
    47.751     0.387     0.200
    47.895    -0.130     0.200
    47.915    -1.687     0.200
    47.914     0.520     0.200
    47.972    -0.274     0.200
    47.999    -0.231     0.200
    47.999    -0.723     0.200
    48.000    -1.310     0.200
    48.053    -0.952     0.200
    48.123     0.102     0.200
    48.134     0.319     0.200
    48.158     0.132     0.200
    48.260    -0.450     0.200
    48.273    -1.451     0.200
    48.334     1.473     0.200
    48.353     0.929     0.200
    48.385     0.683     0.200
    48.586    -1.063     0.200
    48.611    -1.452     0.200
    48.599     0.332     0.200
    48.646    -1.328     0.200
    48.688    -0.752     0.200
    48.708    -1.403     0.200
    48.754    -0.269     0.200
    48.770     0.416     0.200
    48.788    -0.813     0.200
    48.793    -1.159     0.200
    48.829    -0.436     0.200
    48.967     0.207     0.200
    48.967     0.308     0.200
    48.997    -0.922     0.200
    49.035    -0.413     0.200
    49.009    -1.617     0.200
    49.095     0.529     0.200
    49.190    -1.698     0.200
    49.217    -0.306     0.200
    49.235    -0.147     0.200
    49.216     1.199     0.200
    49.216     1.301     0.200
    49.362    -1.312     0.200
    49.362    -1.413     0.200
    49.453     2.392     0.200
    49.499     0.939     0.200
    49.499     0.740     0.200
    49.493    -0.418     0.200
    49.544     0.690     0.200
    49.546     0.279     0.200
    49.546     0.150     0.200
    49.704     1.276     0.200
    49.704    -2.123     0.200
    49.737    -0.676     0.200
    49.741    -0.601     0.200
    49.762     1.036     0.200
    49.787    -0.355     0.200
    49.807     0.091     0.200
    49.995    -0.634     0.200
    50.018     0.690     0.200
    50.026     0.824     0.200
    50.075    -0.343     0.200
    50.101     0.162     0.200
    50.130     0.138     0.200
    50.145    -0.176     0.200
    50.144     0.996     0.200
    50.144    -0.164     0.200
    50.145     1.228     0.200
    50.192     0.171     0.200
    50.321    -0.612     0.200
    50.298    -0.538     0.200
    50.298     0.383     0.200
    50.383    -1.276     0.200
    50.401    -0.818     0.200
    50.472    -0.049     0.200
    50.495     0.180     0.200
    50.506    -0.407     0.200
    50.534    -0.022     0.200
    50.557    -0.690     0.200
    50.540     0.033     0.200
    50.540     0.057     0.200
    50.540     0.201     0.200
    50.603    -0.436     0.200
    50.613     0.386     0.200
    50.624     0.300     0.200
    50.656     0.859     0.200
    50.783    -0.301     0.200
    50.762    -0.390     0.200
    50.794    -0.180     0.200
    50.868    -0.793     0.200
    50.879    -0.723     0.200
    51.006     0.624     0.200
    51.026    -0.622     0.200
    51.026    -0.782     0.200
    51.109    -0.040     0.200
    51.579     1.026     0.200
    51.579     1.424     0.200
    51.579     0.424     0.200
    51.531     0.308     0.200
    51.641     0.467     0.200
    51.700     0.824     0.200
    51.756     0.300     0.200
    51.774     0.769     0.200
    51.777     0.446     0.200
    51.951    -0.231     0.200
    51.967     0.430     0.200
    52.207     0.589     0.200
    52.288    -0.258     0.200
    52.490     0.334     0.200
    52.578     0.296     0.200
    52.574    -1.477     0.200
    52.671    -0.295     0.200
    52.673     0.435     0.200
    52.737    -2.584     0.200
    52.756    -0.106     0.200
    52.782     0.483     0.200
    52.851     0.321     0.200
    52.878     0.690     0.200
    52.886     0.412     0.200
    52.935     0.548     0.200
    52.967     0.569     0.200
    53.000     0.770     0.200
    53.105     0.336     0.200
    53.228     0.762     0.200
    53.242    -0.141     0.200
    53.264     0.318     0.200
    53.284     0.078     0.200
    53.294     0.707     0.200
    53.483     0.718     0.200
    53.508     0.382     0.200
    53.498     0.835     0.200
    53.539     0.987     0.200
    53.569     0.290     0.200
    53.569     0.165     0.200
    53.574     0.128     0.200
    53.625     0.078     0.200
    53.625    -0.473     0.200
    53.632     0.120     0.200
    53.695    -1.067     0.200
    53.776    -1.030     0.200
    53.829    -0.518     0.200
    53.829    -0.416     0.200
    53.836     0.126     0.200
    53.864    -1.073     0.200
    53.986     0.045     0.200
    53.988    -0.379     0.200
    54.187    -0.235     0.200
    54.269    -0.285     0.200
    54.289    -0.494     0.200
    54.343    -0.938     0.200
    54.429    -0.194     0.200
    54.500    -0.730     0.200
    54.500    -0.359     0.200
    54.593    -0.690     0.200
    54.601    -0.292     0.200
    54.631    -0.442     0.200
    54.669    -0.942     0.200
    54.669    -0.989     0.200
    54.824    -0.110     0.200
    54.844    -0.803     0.200
    54.882    -0.579     0.200
    54.895    -0.709     0.200
    54.869    -0.468     0.200
    55.103     0.416     0.200
    55.120    -0.495     0.200
    55.151    -0.645     0.200
    55.458    -0.648     0.200
    55.678    -0.487     0.200
    55.723    -0.161     0.200
    55.699    -0.874     0.200
    55.699    -0.472     0.200
    55.767    -0.535     0.200
    55.784     0.621     0.200
    55.976    -0.487     0.200
    56.144     0.243     0.200
    56.301    -0.323     0.200
    56.536     0.546     0.200
    56.570    -0.395     0.200
    56.740     0.097     0.200
    56.792    -0.514     0.200
    56.896    -0.412     0.200
    57.040    -1.110     0.200
    57.110     0.320     0.200
    57.171    -0.261     0.200
    57.171    -0.511     0.200
    57.364    -1.621     0.200
    57.364    -2.571     0.200
    57.412     0.342     0.200
    57.571    -1.328     0.200
    57.633    -0.118     0.200
    57.962    -0.328     0.200
    58.042     0.006     0.200
    58.212     0.019     0.200
    58.198    -0.785     0.200
    58.205     0.116     0.200
    58.337    -0.453     0.200
    58.367     0.839     0.200
    58.596     1.339     0.200
    58.630     0.198     0.200
    58.676    -0.117     0.200
    58.694    -0.242     0.200
    58.731    -0.201     0.200
    58.812     0.238     0.200
    58.915    -1.380     0.200
    58.915    -1.083     0.200
    59.029     0.029     0.200
    59.201     0.112     0.200
    59.201     0.237     0.200
    59.231    -0.705     0.200
    59.231    -1.721     0.200
    59.499     0.276     0.200
    60.319    -0.159     0.200
    60.319    -0.358     0.200
    60.445     0.180     0.200
    60.500     0.202     0.200
    60.786    -0.148     0.200
    60.839    -1.207     0.200
    61.049    -0.034     0.200
    61.099     0.030     0.200
    61.218     0.117     0.200
    61.246    -0.870     0.200
    61.246    -1.030     0.200
    61.255    -0.131     0.200
    61.322     2.116     0.200
    61.322     0.726     0.200
    61.656     0.159     0.200
    62.096     1.301     0.200
    62.127     2.095     0.200
    62.305     0.096     0.200
    62.351    -1.008     0.200
    62.393     0.308     0.200
    62.634    -0.002     0.200
    62.823     0.337     0.200
    62.843    -0.191     0.200
    62.843    -0.331     0.200
    62.947     0.753     0.200
    63.093    -0.956     0.200
    63.308    -0.881     0.200
    63.479    -1.111     0.200
    63.648    -0.529     0.200
    63.751    -1.810     0.200
    64.006     0.915     0.200
    64.092     0.149     0.200
    64.328     0.397     0.200
    64.538     0.521     0.200
    65.063     1.204     0.200
    65.505     0.337     0.200
    65.542     0.598     0.200
    65.824     1.280     0.200
    65.925     1.128     0.200
    66.207     0.314     0.200
    66.450    -0.043     0.200
    66.775    -0.715     0.200
    67.923    -0.019     0.200
    67.979    -0.114     0.200
    67.979    -0.068     0.200
    68.302     0.131     0.200
    68.484     2.591     0.200
    69.179     0.066     0.200
    69.617     0.258     0.200
    70.020     0.078     0.200
    70.020    -0.293     0.200
    70.055    -0.140     0.200
    70.072     0.156     0.200
    70.107    -0.054     0.200
    70.178     0.209     0.200
    70.267     0.360     0.200
    70.267    -0.140     0.200
    70.393     0.289     0.200
    70.434     0.238     0.200
    70.532     0.347     0.200
    70.763     0.138     0.200
    70.891    -0.145     0.200
    71.048     0.375     0.200
    71.209    -2.273     0.200
    71.184     0.481     0.200
    71.268    -0.028     0.200
    71.327     0.214     0.200
    71.391    -1.346     0.200
    71.392    -1.179     0.200
    71.392    -0.890     0.200
    71.399    -1.073     0.200
    71.421    -0.053     0.200
    71.560     0.109     0.200
    71.703     0.042     0.200
    71.752     0.231     0.200
    71.780     0.380     0.200
    71.822    -0.173     0.200
    71.867     0.362     0.200
    72.068    -0.046     0.200
    72.069     0.237     0.200
    72.236     0.146     0.200
    72.280     0.045     0.200
    72.280    -0.314     0.200
    72.445    -0.903     0.200
    73.618    -1.225     0.200
    73.618    -1.296     0.200
    74.211    -0.411     0.200
    74.211    -0.462     0.200
    74.701     0.837     0.200
    75.883    -0.364     0.200
    75.845     0.715     0.200
    75.864    -1.149     0.200
    76.050     1.756     0.200
    76.094    -0.674     0.200
    76.891    -1.100     0.200
    77.302    -0.085     0.200
    77.314    -0.220     0.200
    77.524    -0.471     0.200
    77.874     0.450     0.200
    77.899     0.478     0.200
    78.119    -0.636     0.200
    78.262    -0.498     0.200
    78.306    -0.783     0.200
    78.541    -0.382     0.200
    78.541    -0.679     0.200
    78.478    -1.031     0.200
    78.478    -0.398     0.200
    78.532    -0.461     0.200
    78.598     0.284     0.200
    78.661    -1.241     0.200
    78.685     0.929     0.200
    78.710    -1.250     0.200
    78.828    -1.915     0.200
    78.828    -1.505     0.200
    78.828    -1.407     0.200
    79.010    -0.460     0.200
    79.053    -0.989     0.200
    79.277    -1.214     0.200
    79.532    -1.709     0.200
    79.861    -0.098     0.200
    79.970    -0.745     0.200
    80.146     0.567     0.200
    80.353    -0.950     0.200
    80.484    -0.888     0.200
    80.533    -0.723     0.200
    80.613    -0.446     0.200
    80.707    -0.538     0.200
    80.924     0.588     0.200
    81.140     0.177     0.200
    81.279    -1.658     0.200
    81.380    -1.094     0.200
    81.946     0.785     0.200
    82.091    -0.283     0.200
    82.219    -0.625     0.200
    82.402     1.176     0.200
    82.431    -0.086     0.200
    82.942     0.176     0.200
    82.942     0.375     0.200
    83.096     0.076     0.200
    83.306     0.493     0.200
    83.902     0.233     0.200
    83.861     1.646     0.200
    84.146    -1.186     0.200
    84.146    -1.511     0.200
    85.358     1.685     0.200
    86.310     0.382     0.200
    86.831    -0.534     0.200
    87.328    -1.760     0.200
    87.328    -2.518     0.200
    88.529     0.324     0.200
    91.339    -0.657     0.200
    91.339     0.061     0.200
    91.796    -0.672     0.200
    95.915    -0.302     0.200
    97.909    -2.060     0.200
    14.689     7.777     0.200
    18.958    -1.731     0.200
    19.928     0.232     0.200
    20.346    -0.565     0.200
    20.353    -0.789     0.200
    20.564    -0.086     0.200
    20.441    -1.551     0.200
    20.441    -1.699     0.200
    21.040     3.123     0.200
    21.683     0.393     0.200
    21.688     0.643     0.200
    21.684     3.372     0.200
    22.207     1.598     0.200
    22.173     3.763     0.200
    22.662     2.984     0.200
    22.885     2.985     0.200
    23.435     1.598     0.200
    23.451    -1.238     0.200
    23.852    -0.728     0.200
    23.852    -0.853     0.200
    23.863    -1.139     0.200
    23.863    -0.343     0.200
    23.918     0.345     0.200
    23.918    -0.381     0.200
    24.424     0.620     0.200
    24.398    -0.742     0.200
    24.473     0.443     0.200
    24.473    -0.338     0.200
    24.614    -1.216     0.200
    24.984     1.828     0.200
    25.094    -0.377     0.200
    25.676     0.437     0.200
    26.123    -0.310     0.200
    26.191    -0.198     0.200
    26.397    -0.489     0.200
    26.533     1.340     0.200
    26.927     0.930     0.200
    26.927     0.422     0.200
    30.302     0.067     0.200
    30.302    -0.128     0.200
    30.567     2.537     0.200
    30.567     1.834     0.200
    30.812     1.965     0.200
    31.146     1.625     0.200
    31.618    -1.032     0.200
    31.979     0.695     0.200
    32.523     0.069     0.200
    32.554     2.939     0.200
    32.718     0.065     0.200
    32.718     2.409     0.200
    32.718     0.214     0.200
    33.128     0.124     0.200
    35.416    -0.315     0.200
    35.951    -1.410     0.200
    36.574    -1.737     0.200
    36.986     0.636     0.200
    36.933    -0.987     0.200
    37.528     0.259     0.200
    39.060     0.408     0.200
    39.300    -0.023     0.200
    39.731    -0.136     0.200
    39.731    -0.137     0.200
    39.708     0.250     0.200
    42.157     1.973     0.200
    42.790    -0.283     0.200
    42.850    -1.074     0.200
    42.928    -0.476     0.200
    42.937    -0.471     0.200
    42.937    -1.143     0.200
    43.176     0.491     0.200
    43.196    -0.175     0.200
    44.183     0.481     0.200
    44.237     0.743     0.200
    44.256     0.093     0.200
    44.374     0.556     0.200
    44.506     0.694     0.200
    44.727     0.934     0.200
    44.875    -0.055     0.200
    44.875    -1.352     0.200
    45.119     1.204     0.200
    45.272     0.698     0.200
    45.357     0.524     0.200
    45.650    -0.201     0.200
    45.862     1.524     0.200
    45.969     0.480     0.200
    46.130     0.614     0.200
    46.258    -0.094     0.200
    46.362     1.290     0.200
    46.855     0.925     0.200
    47.010     1.010     0.200
    46.953     0.328     0.200
    46.971     0.812     0.200
    47.005     1.130     0.200
    47.005     0.552     0.200
    47.254    -1.189     0.200
    47.271    -0.529     0.200
    47.709     1.167     0.200
    47.739     1.038     0.200
    47.764     0.737     0.200
    47.806     1.210     0.200
    47.953     0.172     0.200
    48.570     1.059     0.200
    48.862     0.765     0.200
    48.862     0.265     0.200
    48.873    -0.916     0.200
    48.873    -1.478     0.200
    49.452    -0.645     0.200
    49.551     0.391     0.200
    49.848     0.032     0.200
    49.964     1.248     0.200
    50.302    -0.340     0.200
    50.357     0.969     0.200
    50.838     0.431     0.200
    50.995     0.856     0.200
    51.123     0.793     0.200
    51.123     0.743     0.200
    51.314     1.057     0.200
    51.601     1.581     0.200
    51.570     0.738     0.200
    51.857     0.619     0.200
    52.132     1.049     0.200
    52.248     0.861     0.200
    52.285     0.809     0.200
    52.609     0.118     0.200
    52.647     0.287     0.200
    52.925    -0.177     0.200
    52.979     0.374     0.200
    53.172    -0.247     0.200
    53.610     0.635     0.200
    53.979    -1.373     0.200
    53.979    -0.646     0.200
    54.454     0.868     0.200
    54.554     0.745     0.200
    54.832    -0.479     0.200
    55.041    -0.131     0.200
    55.133    -0.254     0.200
    55.340     0.554     0.200
    55.340    -0.150     0.200
    55.664    -0.197     0.200
    58.645     1.237     0.200
    59.690    -0.803     0.200
    60.823    -0.357     0.200
    60.823    -0.490     0.200
    66.321     0.415     0.200
    67.371     0.073     0.200
    67.661    -0.607     0.200
    72.016    -0.861     0.200
    72.016    -0.111     0.200
    72.017    -0.619     0.200
    74.259    -0.876     0.200
    75.604    -1.102     0.200
    78.142    -0.962     0.200
    78.344    -2.174     0.200
    78.515    -1.167     0.200
    78.726    -0.103     0.200
    80.728    -0.252     0.200
    80.728     0.248     0.200
    82.588     1.128     0.200
    84.794    -1.728     0.200
    86.752    -1.849     0.200
    94.656     1.354     0.200
    19.566    -1.347     0.200
    22.684     0.568     0.200
    24.515     0.083     0.200
    45.288     0.137     0.200
    52.270    -0.982     0.200
    71.824    -0.969     0.200
    74.023    -0.633     0.200
    76.233    -0.304     0.200
    14.813     5.243     0.200
    18.946    -0.672     0.200
    20.053    -0.717     0.200
    20.053     0.244     0.200
    20.144    -0.659     0.200
    20.144    -0.909     0.200
    21.008     0.173     0.200
    21.188     0.703     0.200
    21.202     1.083     0.200
    21.288     1.253     0.200
    21.288    -0.548     0.200
    21.394     1.109     0.200
    21.503     0.595     0.200
    21.537    -0.086     0.200
    21.984     3.389     0.200
    23.150     1.108     0.200
    23.201    -0.355     0.200
    23.201     2.275     0.200
    23.201     0.805     0.200
    23.379    -0.028     0.200
    23.379    -0.764     0.200
    23.713    -0.710     0.200
    23.713    -0.941     0.200
    23.717    -0.979     0.200
    23.745     0.416     0.200
    23.745     0.287     0.200
    23.831     2.179     0.200
    24.185     1.146     0.200
    24.353     0.314     0.200
    24.432    -1.109     0.200
    25.225    -0.329     0.200
    25.462    -0.356     0.200
    25.462    -0.059     0.200
    25.988     0.507     0.200
    26.716    -0.022     0.200
    26.965     1.450     0.200
    26.965     1.450     0.200
    26.976     1.342     0.200
    27.365     1.532     0.200
    27.365    -0.958     0.200
    27.990     0.943     0.200
    29.686     0.493     0.200
    29.686     0.263     0.200
    30.100     0.700     0.200
    31.606     0.112     0.200
    33.860    -1.063     0.200
    37.922     1.073     0.200
    38.108     0.259     0.200
    38.108     0.197     0.200
    38.108     0.258     0.200
    38.580    -0.163     0.200
    38.923     0.462     0.200
    39.111     0.059     0.200
    40.487    -0.909     0.200
    42.069    -0.786     0.200
    42.078    -0.833     0.200
    42.101    -0.421     0.200
    43.274     0.549     0.200
    43.310    -0.617     0.200
    43.328     1.415     0.200
    43.385    -0.018     0.200
    43.522    -0.496     0.200
    43.814     1.898     0.200
    43.814     1.629     0.200
    44.211     1.912     0.200
    44.378     0.777     0.200
    44.390     0.527     0.200
    44.737     0.909     0.200
    45.002     0.454     0.200
    45.101     0.613     0.200
    46.234    -0.152     0.200
    46.234    -0.326     0.200
    46.234    -0.201     0.200
    46.821     0.241     0.200
    46.896    -0.439     0.200
    48.793    -1.373     0.200
    48.922    -0.838     0.200
    48.922    -0.350     0.200
    49.255    -0.070     0.200
    49.255     0.035     0.200
    49.255    -0.039     0.200
    49.484    -1.135     0.200
    50.255     0.802     0.200
    50.448     0.739     0.200
    50.680     0.863     0.200
    50.919     0.836     0.200
    51.348     1.010     0.200
    51.415     0.664     0.200
    51.697     1.091     0.200
    51.747     0.449     0.200
    51.757     0.101     0.200
    52.045    -1.228     0.200
    52.044    -0.359     0.200
    52.101     0.741     0.200
    52.998    -0.502     0.200
    53.171    -0.280     0.200
    53.199    -0.818     0.200
    53.237    -1.068     0.200
    53.237    -0.988     0.200
    53.237    -0.994     0.200
    53.466    -0.131     0.200
    53.592    -0.037     0.200
    53.940    -0.802     0.200
    54.238    -0.437     0.200
    54.773    -0.594     0.200
    55.262    -0.091     0.200
    55.615    -0.057     0.200
    55.646    -0.185     0.200
    56.676     0.168     0.200
    56.787    -0.003     0.200
    57.261     0.188     0.200
    57.689    -0.807     0.200
    57.765     0.179     0.200
    58.789     0.103     0.200
    59.448    -1.366     0.200
    59.449    -1.374     0.200
    60.989    -0.619     0.200
    62.308    -1.015     0.200
    65.178     0.061     0.200
    66.392     0.003     0.200
    66.447     0.203     0.200
    66.447     0.357     0.200
    66.771     0.410     0.200
    68.085     0.293     0.200
    68.821    -0.110     0.200
    68.821     0.029     0.200
    69.652     0.542     0.200
    69.796    -0.143     0.200
    70.030    -0.482     0.200
    70.173     0.340     0.200
    70.221     0.455     0.200
    70.250     0.865     0.200
    70.335     0.145     0.200
    72.873    -0.247     0.200
    72.873    -0.247     0.200
    72.922    -0.457     0.200
    72.922    -0.461     0.200
    72.923    -0.344     0.200
    72.930    -0.415     0.200
    75.145    -0.631     0.200
    75.175    -0.764     0.200
    75.645    -0.612     0.200
    75.670    -1.043     0.200
    76.180    -0.065     0.200
    76.993     0.304     0.200
    77.119    -0.553     0.200
    77.733    -1.071     0.200
    77.882    -0.810     0.200
    78.051    -0.773     0.200
    78.220    -1.380     0.200
    78.238    -1.328     0.200
    78.245    -0.694     0.200
    78.293    -1.371     0.200
    78.395    -1.575     0.200
    78.395    -1.646     0.200
    78.395    -1.685     0.200
    78.396     0.562     0.200
    78.456    -1.209     0.200
    78.613    -0.780     0.200
    78.884    -1.372     0.200
    79.760    -0.610     0.200
    80.045    -1.293     0.200
    80.176    -0.901     0.200
    80.198    -0.717     0.200
    80.545    -0.489     0.200
    80.709     0.235     0.200
    80.891    -1.156     0.200
    80.976    -0.772     0.200
    81.233    -0.462     0.200
    81.564    -0.154     0.200
    81.640    -0.243     0.200
    81.640     0.282     0.200
    81.670     0.324     0.200
    81.694     0.299     0.200
    81.794     0.172     0.200
    81.836    -0.750     0.200
    81.836    -0.500     0.200
    81.982    -0.465     0.200
    82.029    -0.196     0.200
    82.040    -0.560     0.200
    82.635     0.066     0.200
    82.637    -3.244     0.200
    85.669    -2.647     0.200
    85.842     0.170     0.200
    86.602    -1.982     0.200
    86.602    -1.986     0.200
    90.108    -0.791     0.200
    90.108    -1.192     0.200
    20.866     0.098     0.200
    38.168     0.276     0.200
    46.743    -0.505     0.200
    49.885     0.184     0.200
    14.835     5.347     0.200
    19.089     0.066     0.200
    19.484    -0.199     0.200
    19.473    -1.259     0.200
    19.633    -1.006     0.200
    19.726    -2.052     0.200
    19.726     0.018     0.200
    20.382     0.092     0.200
    21.851    -0.137     0.200
    21.893     0.512     0.200
    22.274    -0.858     0.200
    22.274    -1.561     0.200
    22.274    -0.139     0.200
    22.278    -0.898     0.200
    22.346    -0.323     0.200
    22.488    -0.272     0.200
    22.488    -0.335     0.200
    22.522    -0.544     0.200
    22.775    -0.377     0.200
    22.826     0.182     0.200
    22.826    -0.818     0.200
    22.826     0.550     0.200
    22.970     0.154     0.200
    22.916    -0.215     0.200
    22.916    -0.473     0.200
    23.174     0.802     0.200
    23.440    -0.796     0.200
    23.444    -1.338     0.200
    23.444    -1.088     0.200
    23.444    -0.939     0.200
    23.448    -1.131     0.200
    23.628    -1.542     0.200
    23.686     0.928     0.200
    24.120    -0.233     0.200
    24.632     0.792     0.200
    24.632     0.143     0.200
    24.705    -0.173     0.200
    25.271     0.677     0.200
    25.300     0.519     0.200
    25.330    -0.762     0.200
    26.346     0.139     0.200
    26.611     0.440     0.200
    26.831     0.686     0.200
    26.910     0.048     0.200
    26.977    -0.754     0.200
    26.982    -1.404     0.200
    27.279     1.566     0.200
    27.279     1.566     0.200
    27.290     0.752     0.200
    27.497    -0.829     0.200
    27.522    -0.852     0.200
    27.686    -0.021     0.200
    27.686     0.799     0.200
    27.882     0.525     0.200
    27.882     0.627     0.200
    27.931    -0.807     0.200
    28.562     1.560     0.200
    28.627     0.794     0.200
    28.634     0.694     0.200
    28.634     0.225     0.200
    28.954     0.466     0.200
    28.954     0.677     0.200
    28.954    -0.260     0.200
    29.716     1.318     0.200
    29.750     0.238     0.200
    29.984     1.844     0.200
    30.633     0.413     0.200
    30.657     1.303     0.200
    30.877    -0.842     0.200
    30.832     0.455     0.200
    30.832     0.775     0.200
    30.924     0.446     0.200
    31.521    -0.113     0.200
    31.950     1.109     0.200
    31.957     1.047     0.200
    32.067    -0.617     0.200
    33.681    -0.328     0.200
    34.474    -0.218     0.200
    34.712     0.364     0.200
    35.183    -0.440     0.200
    35.316    -0.586     0.200
    35.811     0.060     0.200
    36.050     0.512     0.200
    36.140    -0.958     0.200
    36.321    -0.806     0.200
    37.120     0.439     0.200
    37.120     0.368     0.200
    37.120     0.438     0.200
    37.245     2.277     0.200
    37.654     0.059     0.200
    37.731    -2.991     0.200
    38.042     0.284     0.200
    38.809     1.043     0.200
    38.824     2.254     0.200
    38.835     2.570     0.200
    39.110     0.414     0.200
    39.243     0.677     0.200
    39.247    -1.333     0.200
    39.247    -1.232     0.200
    40.157    -0.574     0.200
    41.151     0.044     0.200
    41.151    -0.932     0.200
    41.155    -0.167     0.200
    41.132    -0.567     0.200
    41.132    -0.567     0.200
    41.151    -0.980     0.200
    41.140    -0.843     0.200
    41.163    -0.929     0.200
    41.353    -0.883     0.200
    41.617    -2.652     0.200
    42.115     0.479     0.200
    42.304     1.330     0.200
    42.358     1.095     0.200
    42.386     0.063     0.200
    42.719     0.355     0.200
    42.843     1.174     0.200
    42.843     2.057     0.200
    42.881     1.141     0.200
    43.417     0.509     0.200
    43.421     0.053     0.200
    43.430     0.204     0.200
    43.482     0.420     0.200
    43.523     0.657     0.200
    43.680    -1.011     0.200
    43.680    -0.316     0.200
    43.798     0.289     0.200
    43.798     0.141     0.200
    43.765    -0.596     0.200
    43.778     0.520     0.200
    43.834     0.427     0.200
    43.848     0.564     0.200
    43.877     0.540     0.200
    43.983     1.749     0.200
    44.257     0.135     0.200
    44.238     0.208     0.200
    44.336    -0.677     0.200
    44.469    -0.454     0.200
    44.582     0.851     0.200
    44.822    -0.023     0.200
    44.885    -0.062     0.200
    44.885    -0.233     0.200
    45.181     0.368     0.200
    45.181    -0.319     0.200
    45.237    -0.550     0.200
    45.237    -1.363     0.200
    45.237    -0.800     0.200
    45.293    -0.665     0.200
    45.293    -0.532     0.200
    45.406     0.150     0.200
    45.406     0.192     0.200
    45.406     0.223     0.200
    45.406     0.098     0.200
    45.414    -0.166     0.200
    45.835     1.001     0.200
    45.847     0.113     0.200
    45.883     0.230     0.200
    46.126     0.309     0.200
    46.523     0.457     0.200
    46.613     0.386     0.200
    46.743     0.913     0.200
    46.891    -0.292     0.200
    47.012     1.057     0.200
    47.012     0.440     0.200
    47.081    -0.252     0.200
    47.119    -0.349     0.200
    47.710    -0.072     0.200
    48.079     0.966     0.200
    48.144     0.261     0.200
    48.155     0.482     0.200
    48.537     0.433     0.200
    48.537     0.432     0.200
    48.537     0.362     0.200
    48.537     0.464     0.200
    48.536     0.639     0.200
    48.536    -0.338     0.200
    48.758    -0.191     0.200
    48.757    -0.131     0.200
    48.821    -0.960     0.200
    48.821    -1.109     0.200
    49.166     0.995     0.200
    49.311     0.193     0.200
    49.447    -0.940     0.200
    49.450    -0.972     0.200
    49.450    -1.276     0.200
    49.452     0.116     0.200
    49.506     0.607     0.200
    49.580    -0.363     0.200
    49.554     0.812     0.200
    49.721     0.196     0.200
    49.831     0.422     0.200
    50.315     0.458     0.200
    50.361     0.977     0.200
    50.383     0.241     0.200
    50.469     0.289     0.200
    50.732     1.334     0.200
    50.798    -0.354     0.200
    50.808    -0.017     0.200
    51.092    -0.859     0.200
    51.091    -0.207     0.200
    51.091    -0.176     0.200
    51.107    -0.199     0.200
    51.150    -0.048     0.200
    51.207    -0.269     0.200
    51.279     0.289     0.200
    51.378    -1.154     0.200
    51.445    -0.830     0.200
    51.445    -1.229     0.200
    51.552    -0.574     0.200
    52.133    -0.356     0.200
    52.147    -0.938     0.200
    52.151    -1.076     0.200
    52.214    -0.610     0.200
    52.214    -0.500     0.200
    52.280    -0.479     0.200
    52.326    -0.303     0.200
    52.340    -0.766     0.200
    52.352    -1.372     0.200
    52.390    -0.599     0.200
    52.390    -0.568     0.200
    52.390    -0.576     0.200
    52.540    -1.142     0.200
    52.564    -0.423     0.200
    52.585    -0.196     0.200
    52.602    -0.569     0.200
    52.621    -0.064     0.200
    52.981    -1.158     0.200
    53.147    -0.005     0.200
    53.147    -0.458     0.200
    53.192    -1.105     0.200
    53.277    -1.024     0.200
    53.464    -0.223     0.200
    53.651    -0.216     0.200
    53.813    -0.597     0.200
    53.889    -0.821     0.200
    54.234    -0.194     0.200
    54.234    -1.303     0.200
    54.403    -0.357     0.200
    54.438    -0.384     0.200
    54.647     0.557     0.200
    54.751     0.342     0.200
    54.833     0.279     0.200
    55.092     0.112     0.200
    55.315    -0.691     0.200
    55.341     0.131     0.200
    55.713    -0.568     0.200
    55.742    -0.072     0.200
    55.990    -1.048     0.200
    56.274     0.319     0.200
    56.701    -0.045     0.200
    57.609     0.354     0.200
    57.823    -0.450     0.200
    59.759     0.633     0.200
    59.763    -1.444     0.200
    59.765    -1.453     0.200
    59.867    -1.859     0.200
    59.867    -1.695     0.200
    60.438    -0.866     0.200
    61.002    -0.613     0.200
    61.677    -0.879     0.200
    64.466     0.289     0.200
    64.466     0.789     0.200
    65.414    -0.178     0.200
    65.470    -0.139     0.200
    65.470     0.181     0.200
    65.793     0.270     0.200
    66.555     0.049     0.200
    66.555     0.291     0.200
    66.679     0.291     0.200
    67.114     0.121     0.200
    67.572     0.417     0.200
    67.608     0.494     0.200
    67.680     0.435     0.200
    67.763     0.414     0.200
    67.763     0.742     0.200
    67.890     0.510     0.200
    67.928     0.374     0.200
    68.024     0.066     0.200
    68.168     0.266     0.200
    68.168     0.470     0.200
    68.253    -0.063     0.200
    68.383     0.019     0.200
    68.545    -1.328     0.200
    68.678     0.474     0.200
    68.760    -0.040     0.200
    68.818    -0.004     0.200
    68.911     0.120     0.200
    69.049     0.161     0.200
    69.193     0.572     0.200
    69.242    -0.136     0.200
    69.270     0.598     0.200
    69.357     0.556     0.200
    69.561     1.092     0.200
    69.726     0.676     0.200
    69.968     0.686     0.200
    70.801    -1.267     0.200
    70.849    -0.266     0.200
    71.943    -0.554     0.200
    71.943    -0.452     0.200
    71.943    -0.452     0.200
    73.891    -0.211     0.200
    73.891    -0.209     0.200
    74.996    -1.392     0.200
    74.996    -0.985     0.200
    75.096     0.016     0.200
    75.096     0.157     0.200
    75.524    -0.173     0.200
    76.102    -0.430     0.200
    76.102    -0.430     0.200
    76.172     0.073     0.200
    77.027     0.101     0.200
    77.283     0.861     0.200
    77.654    -0.536     0.200
    77.833     0.090     0.200
    77.856    -0.723     0.200
    77.945    -1.097     0.200
    78.134    -1.046     0.200
    78.234    -0.402     0.200
    78.284    -1.384     0.200
    78.284    -1.274     0.200
    78.284    -1.501     0.200
    78.526    -0.315     0.200
    78.801    -1.030     0.200
    79.481    -0.223     0.200
    79.710    -0.357     0.200
    79.724    -0.451     0.200
    80.098    -0.396     0.200
    80.470    -0.001     0.200
    80.637     0.665     0.200
    80.725     0.154     0.200
    80.741    -0.354     0.200
    80.781     0.034     0.200
    80.878     0.015     0.200
    81.095    -0.143     0.200
    81.842    -0.096     0.200
    83.978    -0.493     0.200
    84.752    -0.482     0.200
    85.705     0.430     0.200
    86.221    -0.984     0.200
    86.288    -1.012     0.200
    86.288    -1.004     0.200
    86.619    -1.683     0.200
    87.840     0.326     0.200
    94.656    -0.581     0.200
    15.013     6.383     0.200
    16.931     0.873     0.200
    19.999     0.051     0.200
    20.009    -1.498     0.200
    20.213    -0.367     0.200
    20.247     0.348     0.200
    20.271    -0.012     0.200
    20.772    -0.876     0.200
    20.859    -0.955     0.200
    21.328     0.524     0.200
    22.096     1.297     0.200
    22.894     0.104     0.200
    22.894     1.614     0.200
    23.222     0.060     0.200
    24.071     1.245     0.200
    24.241    -0.925     0.200
    24.241    -0.579     0.200
    24.241    -0.874     0.200
    24.302    -0.958     0.200
    24.302    -0.255     0.200
    24.356    -0.196     0.200
    24.356    -0.757     0.200
    24.435     1.125     0.200
    24.907     0.428     0.200
    24.907     0.498     0.200
    26.624     0.446     0.200
    26.733     1.408     0.200
    26.744     0.988     0.200
    27.123    -1.228     0.200
    27.691     0.784     0.200
    30.743    -0.885     0.200
    30.743    -0.109     0.200
    30.910     0.022     0.200
    31.983     0.676     0.200
    32.035     2.335     0.200
    32.693     1.246     0.200
    32.771    -0.929     0.200
    32.894    -0.008     0.200
    32.922    -0.653     0.200
    33.091    -0.833     0.200
    37.945    -1.133     0.200
    38.032     0.039     0.200
    39.154    -0.184     0.200
    39.395     0.593     0.200
    39.395     0.302     0.200
    39.742     0.307     0.200
    39.742     0.306     0.200
    40.132    -0.229     0.200
    41.166    -1.371     0.200
    41.166    -1.269     0.200
    42.996    -1.151     0.200
    42.996    -1.301     0.200
    43.330    -0.728     0.200
    43.330    -0.473     0.200
    43.339    -0.596     0.200
    43.339    -0.975     0.200
    43.362    -0.902     0.200
    43.548     0.235     0.200
    44.560     1.724     0.200
    44.614     1.692     0.200
    45.101     1.508     0.200
    45.101     1.813     0.200
    45.496     1.175     0.200
    45.658     0.799     0.200
    45.661     0.135     0.200
    45.670     0.403     0.200
    45.731     0.924     0.200
    46.743     1.461     0.200
    47.388    -0.281     0.200
    47.388    -0.153     0.200
    48.109     1.031     0.200
    48.182    -0.192     0.200
    49.209    -1.718     0.200
    49.385     0.133     0.200
    49.894    -0.064     0.200
    50.290     0.076     0.200
    50.754     0.747     0.200
    53.011     0.161     0.200
    53.318     0.195     0.200
    53.318    -0.814     0.200
    53.575     0.371     0.200
    53.738    -0.628     0.200
    54.171    -0.146     0.200
    54.345    -2.737     0.200
    54.411    -0.937     0.200
    54.411    -1.013     0.200
    54.871    -0.561     0.200
    55.429    -1.612     0.200
    55.518    -0.347     0.200
    55.600    -1.833     0.200
    55.738    -0.180     0.200
    55.738    -0.613     0.200
    56.051    -0.867     0.200
    56.131    -0.599     0.200
    56.543     0.805     0.200
    56.802    -0.616     0.200
    57.957     0.311     0.200
    58.648     0.029     0.200
    58.973    -0.177     0.200
    58.973     0.820     0.200
    60.071     0.063     0.200
    62.556    -1.654     0.200
    67.736    -0.720     0.200
    71.637    -0.782     0.200
    71.646    -0.900     0.200
    73.869    -0.731     0.200
    73.869    -1.012     0.200
    73.899    -0.298     0.200
    74.038     0.247     0.200
    74.038    -0.901     0.200
    75.081    -0.486     0.200
    76.244    -0.175     0.200
    77.378    -0.270     0.200
    77.976    -0.904     0.200
    78.122    -0.154     0.200
    78.158    -0.902     0.200
    78.323     0.452     0.200
    78.323     0.972     0.200
    78.460    -0.315     0.200
    78.563    -1.391     0.200
    78.678    -1.506     0.200
    78.678    -1.326     0.200
    78.880    -1.117     0.200
    79.330    -0.770     0.200
    80.045    -1.390     0.200
    80.096    -0.636     0.200
    80.661    -1.115     0.200
    81.222    -0.998     0.200
    81.876    -0.378     0.200
    82.778     0.985     0.200
    84.398    -2.377     0.200
    85.233    -0.490     0.200
    87.138    -1.427     0.200
    88.367    -0.624     0.200
    14.855     6.879     0.200
    17.932     2.194     0.200
    19.162    -0.752     0.200
    19.707    -0.658     0.200
    19.800    -0.540     0.200
    19.800    -1.669     0.200
    19.800    -0.700     0.200
    19.980     0.233     0.200
    21.823    -0.571     0.200
    22.149    -0.541     0.200
    22.149     0.748     0.200
    22.153     0.708     0.200
    22.362    -0.506     0.200
    22.362     0.224     0.200
    22.397    -0.602     0.200
    22.921    -0.682     0.200
    22.921     0.048     0.200
    23.034    -0.371     0.200
    23.504    -0.868     0.200
    23.501    -1.212     0.200
    23.501    -0.740     0.200
    23.501    -1.212     0.200
    23.505    -0.778     0.200
    23.602    -0.398     0.200
    23.602    -0.566     0.200
    24.181    -0.663     0.200
    24.578     1.519     0.200
    25.043    -0.692     0.200
    25.043     0.691     0.200
    25.165     0.783     0.200
    25.902    -0.411     0.200
    27.262     1.324     0.200
    27.262     1.324     0.200
    27.273    -0.983     0.200
    27.668    -1.380     0.200
    27.668     0.081     0.200
    29.063    -0.440     0.200
    30.959     0.384     0.200
    34.390    -0.341     0.200
    35.308    -0.559     0.200
    35.948     0.044     0.200
    37.245    -1.106     0.200
    38.164     0.113     0.200
    41.258    -0.708     0.200
    41.258    -0.634     0.200
    41.266    -0.675     0.200
    41.266    -0.207     0.200
    41.289    -0.895     0.200
    43.547    -0.391     0.200
    43.588    -0.693     0.200
    43.588    -1.095     0.200
    43.762     0.904     0.200
    43.768    -0.194     0.200
    43.768    -1.944     0.200
    43.789    -0.327     0.200
    44.591    -1.681     0.200
    45.524    -0.285     0.200
    45.524     0.541     0.200
    45.524     0.541     0.200
    46.361    -0.255     0.200
    48.644    -0.308     0.200
    48.644    -0.308     0.200
    48.644     0.102     0.200
    48.859    -1.499     0.200
    48.859    -0.858     0.200
    50.410    -0.404     0.200
    51.218    -0.366     0.200
    52.271    -0.752     0.200
    52.445    -0.265     0.200
    52.471     0.129     0.200
    52.509    -0.894     0.200
    52.509    -0.663     0.200
    52.509    -0.663     0.200
    65.596    -0.625     0.200
    72.051    -0.203     0.200
    72.051    -0.733     0.200
    72.051    -0.730     0.200
    73.764    -0.570     0.200
    73.765    -0.572     0.200
    73.766     0.624     0.200
    73.773    -0.691     0.200
    73.798    -0.339     0.200
    75.508    -1.130     0.200
    75.975    -0.903     0.200
    75.975    -0.415     0.200
    77.064    -0.428     0.200
    77.815    -0.998     0.200
    77.866    -0.577     0.200
    77.877    -1.728     0.200
    78.173    -1.707     0.200
    78.219    -1.287     0.200
    78.230    -1.567     0.200
    78.286    -1.044     0.200
    78.286    -1.408     0.200
    78.323    -0.702     0.200
    78.323    -0.862     0.200
    79.688    -1.292     0.200
    79.722    -0.857     0.200
    80.785    -0.870     0.200
    82.530    -0.978     0.200
    86.352    -0.969     0.200
    86.352    -1.523     0.200
    86.492    -0.901     0.200
    14.854     6.664     0.200
    19.650    -0.744     0.200
    19.650    -0.287     0.200
    19.744    -2.087     0.200
    19.744    -1.314     0.200
    19.744    -0.607     0.200
    19.744    -0.435     0.200
    20.371     0.095     0.200
    21.860    -0.309     0.200
    21.906     0.501     0.200
    22.272    -0.796     0.200
    22.272    -0.015     0.200
    22.276    -0.157     0.200
    22.350    -0.541     0.200
    22.350    -0.061     0.200
    22.486    -0.745     0.200
    22.486    -0.034     0.200
    22.520    -0.779     0.200
    22.664     1.724     0.200
    22.790    -0.081     0.200
    22.790     0.189     0.200
    22.790     0.001     0.200
    22.841    -1.333     0.200
    22.841     0.347     0.200
    22.841     0.448     0.200
    22.927    -0.113     0.200
    22.927    -0.457     0.200
    22.927    -1.066     0.200
    23.463    -1.396     0.200
    23.463    -1.396     0.200
    23.463    -0.196     0.200
    23.627    -1.116     0.200
    24.138    -0.478     0.200
    24.135     0.749     0.200
    24.320    -0.344     0.200
    24.643    -0.293     0.200
    24.643     0.633     0.200
    25.166    -1.349     0.200
    25.166     0.249     0.200
    25.277     1.345     0.200
    25.993    -0.850     0.200
    25.993    -0.701     0.200
    26.840    -0.511     0.200
    26.928    -0.488     0.200
    27.296     1.401     0.200
    27.296     1.401     0.200
    27.307    -0.764     0.200
    28.968     0.294     0.200
    30.836     0.554     0.200
    30.934     0.693     0.200
    31.456     1.392     0.200
    33.689    -0.357     0.200
    34.485    -0.165     0.200
    35.191    -0.961     0.200
    35.819    -0.761     0.200
    36.067     0.919     0.200
    36.339    -0.512     0.200
    37.121     0.147     0.200
    37.121     0.627     0.200
    37.121     0.151     0.200
    37.329    -0.439     0.200
    38.051     0.460     0.200
    39.125     0.442     0.200
    39.258    -1.072     0.200
    41.165    -0.480     0.200
    41.165    -0.480     0.200
    41.138    -0.631     0.200
    41.138    -0.745     0.200
    41.147    -1.829     0.200
    41.147    -0.630     0.200
    41.170    -1.435     0.200
    41.629    -0.486     0.200
    42.847     0.285     0.200
    43.426    -0.627     0.200
    43.435    -0.625     0.200
    43.476    -0.795     0.200
    43.814     0.284     0.200
    43.849     0.651     0.200
    44.248     0.606     0.200
    44.836     0.010     0.200
    45.109     0.734     0.200
    45.187     0.414     0.200
    45.417    -1.126     0.200
    45.417    -0.556     0.200
    45.417     0.188     0.200
    45.417     0.188     0.200
    45.813     0.162     0.200
    45.887     0.277     0.200
    46.699    -0.711     0.200
    46.749     0.903     0.200
    47.356     0.064     0.200
    47.405     0.684     0.200
    48.550     0.399     0.200
    48.550     0.395     0.200
    48.542     0.479     0.200
    48.840    -1.689     0.200
    48.840    -0.009     0.200
    50.346     0.940     0.200
    51.097    -0.449     0.200
    51.461    -0.058     0.200
    51.385    -0.504     0.200
    52.162    -1.071     0.200
    52.224     1.936     0.200
    52.400    -0.874     0.200
    52.400    -0.323     0.200
    52.400    -0.273     0.200
    52.632    -1.499     0.200
    61.020    -0.706     0.200
    65.417    -0.440     0.200
    65.473     0.033     0.200
    70.867    -1.008     0.200
    71.937    -2.043     0.200
    72.731     1.046     0.200
    73.887    -0.001     0.200
    73.887     0.005     0.200
    73.888    -0.699     0.200
    75.490    -0.623     0.200
    75.543    -0.353     0.200
    76.097    -0.128     0.200
    76.097    -0.179     0.200
    76.127    -0.363     0.200
    77.046     0.164     0.200
    77.852     0.434     0.200
    77.838    -0.673     0.200
    78.252    -0.328     0.200
    78.303    -1.218     0.200
    78.303    -0.593     0.200
    78.303    -0.457     0.200
    79.360    -0.263     0.200
    79.701     0.131     0.200
    80.719     0.489     0.200
    80.775     0.347     0.200
    80.872     0.026     0.200
    81.861    -0.195     0.200
    81.861     0.086     0.200
    82.654     0.188     0.200
    86.239    -0.833     0.200
    86.306    -0.959     0.200
    86.306    -1.513     0.200
    86.613    -0.996     0.200
    21.874    -0.288     0.200
    23.187    -1.164     0.200
    23.656    -1.353     0.200
    25.173     0.087     0.200
    45.947     0.278     0.200
    49.016     0.261     0.200
    52.941    -0.202     0.200
    73.281    -0.308     0.200
    78.404    -1.731     0.200
    86.531    -2.521     0.200
    20.033     0.478     0.200
    21.611     0.201     0.200
    23.335     0.118     0.200
    23.712    -1.784     0.200
    25.385    -0.023     0.200
    46.158    -0.485     0.200
    49.196     0.054     0.200
    53.159    -0.481     0.200
    72.758    -0.490     0.200
    73.025    -0.778     0.200
    75.245    -1.115     0.200
    78.415    -1.771     0.200
    19.645    -1.878     0.200
    20.377    -0.626     0.200
    23.935     0.428     0.200
    26.037     0.375     0.200
    26.794     2.319     0.200
    46.805    -0.174     0.200
    73.490    -0.834     0.200
    20.296    -0.102     0.200
    20.384    -1.358     0.200
    23.232    -0.539     0.200
    23.785    -1.458     0.200
    23.785     0.120     0.200
    23.819     0.300     0.200
    26.450     2.223     0.200
    72.007    -1.414     0.200
    74.255    -1.858     0.200
    18.925    -0.914     0.200
    19.191    -0.476     0.200
    19.191    -0.695     0.200
    19.905     0.383     0.200
    20.013    -1.809     0.200
    20.232    -0.549     0.200
    20.239    -1.192     0.200
    20.323    -1.479     0.200
    20.714    -1.320     0.200
    20.890     0.171     0.200
    21.079    -0.977     0.200
    21.079    -1.271     0.200
    21.083    -1.314     0.200
    21.102    -0.520     0.200
    21.135     1.022     0.200
    21.214    -0.723     0.200
    21.227     0.232     0.200
    21.227    -0.666     0.200
    21.282     1.541     0.200
    21.288     1.127     0.200
    21.293     1.300     0.200
    21.293    -0.598     0.200
    21.293     0.675     0.200
    21.300     0.460     0.200
    21.310     1.393     0.200
    21.320    -0.863     0.200
    21.328     1.040     0.200
    21.337     0.901     0.200
    21.355     0.756     0.200
    21.371    -0.418     0.200
    21.776     0.918     0.200
    22.332    -0.312     0.200
    22.407     0.499     0.200
    22.436     0.193     0.200
    22.793     0.465     0.200
    22.941     0.829     0.200
    23.017     0.720     0.200
    23.017    -0.577     0.200
    23.175     1.361     0.200
    23.513     1.408     0.200
    23.583     0.029     0.200
    23.636    -0.449     0.200
    23.636    -0.621     0.200
    23.715    -0.549     0.200
    23.867    -1.212     0.200
    23.867    -0.204     0.200
    23.969    -0.352     0.200
    24.114     0.813     0.200
    24.202     0.479     0.200
    24.764     0.282     0.200
    25.136    -0.028     0.200
    25.136    -0.130     0.200
    25.151     0.700     0.200
    25.480     3.064     0.200
    25.516     1.525     0.200
    25.686     0.602     0.200
    26.524     0.400     0.200
    26.777     0.217     0.200
    26.999     1.963     0.200
    27.397     0.637     0.200
    27.397     0.387     0.200
    27.788    -0.864     0.200
    27.957     1.030     0.200
    28.184    -1.096     0.200
    28.177    -0.036     0.200
    28.691     0.280     0.200
    28.718     0.351     0.200
    29.011     0.438     0.200
    29.021     0.349     0.200
    29.124     0.240     0.200
    29.545     0.508     0.200
    29.649    -0.715     0.200
    29.719    -2.131     0.200
    29.747    -1.742     0.200
    29.830     1.206     0.200
    29.830    -1.012     0.200
    29.904     0.619     0.200
    29.904     0.181     0.200
    29.988     0.882     0.200
    30.039     0.331     0.200
    30.281     1.190     0.200
    30.909     0.744     0.200
    30.941     0.200     0.200
    30.957     2.127     0.200
    30.966     0.245     0.200
    31.153     1.095     0.200
    31.194     2.332     0.200
    31.298     0.022     0.200
    31.823    -0.004     0.200
    31.849     0.466     0.200
    31.947    -0.304     0.200
    31.996     0.076     0.200
    32.015     0.504     0.200
    32.021    -0.948     0.200
    32.021    -0.276     0.200
    32.063     0.565     0.200
    32.063    -1.709     0.200
    32.533     0.036     0.200
    32.707     0.404     0.200
    32.819    -0.680     0.200
    33.126     0.777     0.200
    33.051    -0.720     0.200
    33.125    -0.504     0.200
    33.591    -1.077     0.200
    33.635    -0.709     0.200
    34.581     2.022     0.200
    34.817    -0.416     0.200
    34.874     0.920     0.200
    34.874     0.194     0.200
    35.076    -1.053     0.200
    35.555     0.332     0.200
    35.690    -0.032     0.200
    36.143     0.466     0.200
    36.282    -1.503     0.200
    36.325    -0.774     0.200
    36.940    -0.114     0.200
    37.233     0.212     0.200
    37.779     0.010     0.200
    38.264     0.135     0.200
    38.293    -0.365     0.200
    38.314    -0.244     0.200
    38.314     0.561     0.200
    38.827    -1.455     0.200
    39.148     0.527     0.200
    39.148    -0.246     0.200
    39.148    -0.035     0.200
    39.274     0.426     0.200
    39.274     0.301     0.200
    39.274    -0.027     0.200
    40.266    -1.245     0.200
    40.425     0.012     0.200
    41.419     0.246     0.200
    41.424     1.203     0.200
    41.619    -0.232     0.200
    42.111    -0.193     0.200
    42.151     0.074     0.200
    42.266     0.053     0.200
    42.293    -0.378     0.200
    42.293    -1.003     0.200
    42.293    -0.487     0.200
    42.478     0.141     0.200
    42.478     0.485     0.200
    42.530    -0.477     0.200
    42.727    -0.598     0.200
    43.289     0.015     0.200
    43.289    -0.250     0.200
    43.289     0.686     0.200
    43.392     0.398     0.200
    43.392    -1.227     0.200
    43.438    -0.544     0.200
    43.492     1.474     0.200
    43.572     0.085     0.200
    43.820    -1.974     0.200
    43.965     0.492     0.200
    44.032     1.502     0.200
    44.032     1.127     0.200
    44.429     0.879     0.200
    44.498     0.487     0.200
    44.598     0.301     0.200
    44.611    -0.104     0.200
    44.661     0.025     0.200
    44.661     1.291     0.200
    44.901    -0.376     0.200
    44.954     0.713     0.200
    44.998    -0.714     0.200
    45.205    -0.347     0.200
    45.205    -0.643     0.200
    45.205    -0.768     0.200
    45.553     0.996     0.200
    45.651     0.125     0.200
    45.679     1.087     0.200
    45.755    -0.189     0.200
    45.785     0.292     0.200
    46.080     0.333     0.200
    46.080     0.442     0.200
    46.136     1.602     0.200
    46.193    -0.241     0.200
    46.289     0.964     0.200
    46.289     1.292     0.200
    46.352     0.991     0.200
    46.352     0.194     0.200
    46.431    -0.677     0.200
    46.431    -0.364     0.200
    46.458    -0.118     0.200
    46.458     0.040     0.200
    46.611     0.763     0.200
    46.724     0.571     0.200
    46.872    -2.072     0.200
    47.038     0.471     0.200
    47.071     1.343     0.200
    47.101    -0.673     0.200
    47.146     1.479     0.200
    47.680    -0.120     0.200
    47.915     1.945     0.200
    48.192     0.062     0.200
    48.233    -1.055     0.200
    48.249     0.986     0.200
    48.249     0.017     0.200
    48.365     0.104     0.200
    48.814     2.872     0.200
    48.887     0.311     0.200
    49.043    -0.873     0.200
    49.043    -2.194     0.200
    49.043    -1.170     0.200
    49.068    -0.272     0.200
    49.082    -0.286     0.200
    49.116     0.283     0.200
    49.259     1.356     0.200
    49.471     0.486     0.200
    49.471    -0.389     0.200
    49.648     0.784     0.200
    49.707     0.543     0.200
    49.707    -0.059     0.200
    49.929     1.151     0.200
    50.026     0.087     0.200
    50.191     0.661     0.200
    50.196    -0.805     0.200
    50.237     0.025     0.200
    50.339     0.513     0.200
    50.339     0.638     0.200
    50.339     1.435     0.200
    50.475     0.677     0.200
    50.478     0.689     0.200
    50.480     0.275     0.200
    50.540     0.719     0.200
    50.642    -0.251     0.200
    50.742    -0.108     0.200
    50.901     0.563     0.200
    50.954     0.952     0.200
    51.156     0.948     0.200
    51.181     0.508     0.200
    51.266     0.331     0.200
    51.568     0.566     0.200
    51.638     0.370     0.200
    51.675     0.113     0.200
    51.685    -0.463     0.200
    51.917     0.991     0.200
    51.971     0.360     0.200
    51.978     0.021     0.200
    52.010     0.696     0.200
    52.266    -0.054     0.200
    52.266    -0.062     0.200
    52.323    -0.738     0.200
    52.323    -0.035     0.200
    52.340     0.908     0.200
    52.441    -0.364     0.200
    52.507     0.111     0.200
    52.526     0.894     0.200
    52.538    -0.232     0.200
    52.556    -1.685     0.200
    52.566     0.040     0.200
    52.662    -0.168     0.200
    53.029     0.842     0.200
    53.160     0.790     0.200
    53.204     0.770     0.200
    53.232    -0.668     0.200
    53.283     0.079     0.200
    53.290    -0.873     0.200
    53.369    -0.345     0.200
    53.435    -0.029     0.200
    53.461     0.403     0.200
    53.463    -0.855     0.200
    53.463    -0.925     0.200
    53.789     0.605     0.200
    53.812    -0.451     0.200
    53.844    -0.414     0.200
    54.107    -0.775     0.200
    54.136     0.644     0.200
    54.161    -0.881     0.200
    54.236    -0.216     0.200
    54.371    -0.524     0.200
    54.459    -0.378     0.200
    54.525    -0.118     0.200
    54.825    -0.795     0.200
    54.880    -0.380     0.200
    54.952     0.005     0.200
    54.952     0.287     0.200
    54.993    -0.254     0.200
    55.040    -0.071     0.200
    55.040     0.077     0.200
    55.040    -0.040     0.200
    55.482     0.813     0.200
    55.626     0.733     0.200
    55.688    -0.065     0.200
    55.688    -0.612     0.200
    56.896     0.346     0.200
    56.930    -1.177     0.200
    57.305    -0.828     0.200
    57.440    -0.287     0.200
    57.450    -0.353     0.200
    57.893    -0.549     0.200
    58.202    -0.242     0.200
    59.470    -0.454     0.200
    60.217    -0.248     0.200
    60.217     0.806     0.200
    60.355    -0.738     0.200
    61.086    -0.720     0.200
    61.086    -0.423     0.200
    61.046    -0.063     0.200
    62.514    -0.622     0.200
    62.514    -0.333     0.200
    63.602    -0.213     0.200
    65.393     0.529     0.200
    65.529    -0.057     0.200
    65.548    -0.248     0.200
    65.548    -0.115     0.200
    66.662    -0.104     0.200
    66.986    -0.198     0.200
    67.058     0.643     0.200
    68.399     0.330     0.200
    68.628    -1.725     0.200
    69.030     0.671     0.200
    69.030     0.054     0.200
    69.446     0.068     0.200
    69.738    -0.055     0.200
    70.243     0.569     0.200
    70.435     0.394     0.200
    70.914    -0.930     0.200
    71.370    -0.739     0.200
    71.522    -1.085     0.200
    71.522    -1.874     0.200
    71.594    -1.709     0.200
    72.624    -0.430     0.200
    72.704    -0.357     0.200
    72.705    -0.389     0.200
    72.712    -0.329     0.200
    72.755    -0.570     0.200
    73.032    -0.452     0.200
    73.032    -0.280     0.200
    74.885    -0.416     0.200
    74.924    -0.709     0.200
    74.924    -0.600     0.200
    75.453    -1.046     0.200
    75.491    -0.161     0.200
    75.768    -0.704     0.200
    75.987    -0.080     0.200
    75.987     0.896     0.200
    77.237    -0.514     0.200
    77.292    -0.513     0.200
    77.543    -0.840     0.200
    77.848    -0.832     0.200
    78.002    -0.757     0.200
    78.042    -0.621     0.200
    78.101    -0.445     0.200
    78.169    -0.529     0.200
    78.172    -0.388     0.200
    78.203    -0.761     0.200
    78.270    -0.530     0.200
    78.299    -0.301     0.200
    78.358    -1.318     0.200
    78.516    -0.948     0.200
    78.516    -1.144     0.200
    78.598    -0.968     0.200
    78.598    -0.843     0.200
    79.081    -1.433     0.200
    79.234    -0.803     0.200
    79.869    -0.540     0.200
    79.925    -0.539     0.200
    79.997    -0.767     0.200
    80.317    -0.905     0.200
    81.019    -1.113     0.200
    81.461     0.683     0.200
    81.461     0.183     0.200
    81.648    -0.138     0.200
    81.791     0.413     0.200
    81.844     0.158     0.200
    81.945     0.229     0.200
    82.158     0.209     0.200
    82.562    -1.192     0.200
    85.447    -0.567     0.200
    85.447    -0.762     0.200
    86.760    -1.523     0.200
    20.091    -0.335     0.200
    20.183    -1.292     0.200
    21.408    -0.849     0.200
    21.621    -1.670     0.200
    23.383    -0.221     0.200
    23.435    -0.008     0.200
    23.695    -0.007     0.200
    23.695    -0.148     0.200
    23.777     0.399     0.200
    23.777    -0.038     0.200
    25.412     0.335     0.200
    27.103     1.086     0.200
    27.103     0.484     0.200
    37.985    -0.206     0.200
    37.985     0.091     0.200
    37.985    -0.245     0.200
    38.857    -0.245     0.200
    41.090     0.116     0.200
    41.390    -0.765     0.200
    41.934     0.192     0.200
    41.982    -0.961     0.200
    41.982    -0.610     0.200
    42.213    -1.300     0.200
    43.224     1.178     0.200
    43.709     1.509     0.200
    43.709     1.110     0.200
    44.107     0.706     0.200
    44.280    -0.189     0.200
    44.280     0.147     0.200
    44.292     0.507     0.200
    46.184    -0.611     0.200
    46.185    -0.179     0.200
    46.714     0.791     0.200
    46.749     0.622     0.200
    48.794    -0.815     0.200
    48.848     0.175     0.200
    49.235    -0.192     0.200
    49.235     0.207     0.200
    51.950     0.226     0.200
    51.950    -0.086     0.200
    53.117    -0.454     0.200
    53.183    -0.828     0.200
    53.183    -0.703     0.200
    53.464     0.814     0.200
    54.443    -0.662     0.200
    54.491     0.667     0.200
    55.021    -0.052     0.200
    56.576     0.365     0.200
    57.261     0.039     0.200
    57.564    -1.093     0.200
    57.564    -0.320     0.200
    61.095    -1.112     0.200
    66.338    -0.721     0.200
    66.338    -0.471     0.200
    66.661     0.138     0.200
    72.719    -0.849     0.200
    72.719    -0.349     0.200
    72.946    -0.732     0.200
    73.025    -1.125     0.200
    74.843    -0.642     0.200
    75.241    -1.829     0.200
    75.241    -0.868     0.200
    75.351    -0.396     0.200
    76.973     0.043     0.200
    76.982    -0.003     0.200
    78.076    -1.188     0.200
    78.076    -0.985     0.200
    78.342     0.774     0.200
    78.485    -2.554     0.200
    86.661    -0.225     0.200
    20.531    -0.353     0.200
    20.829     0.100     0.200
    24.101    -0.391     0.200
    26.127     0.115     0.200
    26.963     1.024     0.200
    46.898    -0.303     0.200
    49.875    -0.065     0.200
    53.907    -0.006     0.200
    72.235    -1.168     0.200
    73.429    -0.489     0.200
    74.455    -1.338     0.200
    14.966     6.921     0.200
    16.070     0.951     0.200
    16.870     0.799     0.200
    17.784     1.743     0.200
    18.417    -2.860     0.200
    18.994    -0.092     0.200
    19.322    -3.081     0.200
    19.828     0.910     0.200
    20.042    -0.838     0.200
    20.069    -2.010     0.200
    20.201    -0.465     0.200
    20.256    -0.071     0.200
    20.284     0.380     0.200
    20.284    -0.120     0.200
    20.379    -0.384     0.200
    20.404     0.523     0.200
    20.455    -0.323     0.200
    20.683    -0.103     0.200
    20.702    -0.531     0.200
    20.702    -1.105     0.200
    20.790    -0.203     0.200
    20.790    -0.656     0.200
    20.870     0.323     0.200
    21.235    -0.875     0.200
    21.246     3.355     0.200
    21.452    -1.798     0.200
    21.484     2.116     0.200
    21.776     1.978     0.200
    21.878     2.757     0.200
    22.056     0.596     0.200
    22.148     1.194     0.200
    22.148     2.233     0.200
    22.216     2.045     0.200
    22.357     1.859     0.200
    22.432     3.557     0.200
    22.562    -0.268     0.200
    22.562    -0.397     0.200
    22.562     0.298     0.200
    22.671     0.594     0.200
    22.738     2.369     0.200
    22.831     2.552     0.200
    23.080    -0.723     0.200
    23.268    -0.790     0.200
    23.319     0.740     0.200
    23.751     1.343     0.200
    23.828     2.601     0.200
    24.179    -0.226     0.200
    24.179    -0.190     0.200
    24.226    -1.092     0.200
    24.226    -0.194     0.200
    24.281    -0.861     0.200
    24.281     0.721     0.200
    24.281     0.209     0.200
    24.687     2.202     0.200
    24.827     0.428     0.200
    24.827    -0.943     0.200
    25.018    -0.416     0.200
    25.018     0.592     0.200
    26.197     0.198     0.200
    26.479     1.059     0.200
    26.521     1.728     0.200
    26.544    -0.033     0.200
    26.614     0.638     0.200
    26.710     1.066     0.200
    27.102    -0.526     0.200
    27.102     1.763     0.200
    27.102     0.447     0.200
    27.325     1.040     0.200
    27.394     1.019     0.200
    27.754     1.303     0.200
    27.847     1.839     0.200
    28.320    -0.547     0.200
    28.850    -0.062     0.200
    29.154     0.640     0.200
    29.272     0.886     0.200
    29.373    -1.605     0.200
    30.278     0.477     0.200
    30.645     1.537     0.200
    30.665    -0.064     0.200
    30.665    -0.732     0.200
    30.665     0.268     0.200
    30.693    -0.573     0.200
    30.693     1.415     0.200
    30.693     0.665     0.200
    30.702     1.443     0.200
    30.840     2.374     0.200
    30.840     0.624     0.200
    31.154     0.654     0.200
    31.379     1.474     0.200
    31.853     0.234     0.200
    31.853     2.335     0.200
    31.853     1.484     0.200
    31.887    -0.042     0.200
    31.910    -1.798     0.200
    32.196     0.289     0.200
    32.773    -0.367     0.200
    32.773    -0.566     0.200
    32.773     1.734     0.200
    32.772     0.628     0.200
    32.797    -2.376     0.200
    32.820    -0.352     0.200
    32.820     0.324     0.200
    32.962    -0.818     0.200
    32.962    -0.415     0.200
    34.190     0.187     0.200
    34.807     0.852     0.200
    35.341    -1.453     0.200
    35.324     1.891     0.200
    35.324     0.692     0.200
    35.677    -0.335     0.200
    35.677     0.267     0.200
    35.752    -0.377     0.200
    36.099    -0.656     0.200
    36.186     0.502     0.200
    36.310     0.585     0.200
    36.434     0.527     0.200
    36.474     0.148     0.200
    36.527    -0.017     0.200
    36.610     1.380     0.200
    36.799     3.876     0.200
    36.859    -0.016     0.200
    36.859     1.363     0.200
    36.862     2.341     0.200
    36.868    -1.214     0.200
    36.868     0.887     0.200
    37.266    -0.495     0.200
    37.390     0.753     0.200
    37.866    -0.476     0.200
    38.030    -0.556     0.200
    38.758     0.257     0.200
    38.758    -0.399     0.200
    39.075    -1.528     0.200
    39.326     0.434     0.200
    39.326     0.544     0.200
    39.326     0.223     0.200
    39.413    -1.369     0.200
    39.413    -0.557     0.200
    39.632     0.825     0.200
    39.721    -0.421     0.200
    39.737    -0.486     0.200
    39.755    -0.203     0.200
    40.075    -0.061     0.200
    40.053     0.192     0.200
    40.053    -0.175     0.200
    40.053     0.325     0.200
    40.381    -0.998     0.200
    40.625    -1.283     0.200
    41.069     0.079     0.200
    41.069    -0.370     0.200
    41.069    -0.261     0.200
    41.140    -0.097     0.200
    41.138     1.159     0.200
    41.876    -1.002     0.200
    42.693     0.517     0.200
    42.765     0.039     0.200
    42.765    -0.106     0.200
    42.984    -1.804     0.200
    43.157    -1.801     0.200
    43.253    -0.727     0.200
    43.253    -0.598     0.200
    43.263     0.325     0.200
    43.474     0.429     0.200
    43.510    -0.137     0.200
    43.691     1.167     0.200
    44.224    -1.499     0.200
    44.485     0.587     0.200
    44.539     1.327     0.200
    44.561     0.929     0.200
    44.746    -0.693     0.200
    44.850     1.682     0.200
    45.026     2.019     0.200
    45.026     0.577     0.200
    45.026     0.370     0.200
    45.057     0.762     0.200
    45.109    -1.117     0.200
    45.109    -0.547     0.200
    45.109    -2.117     0.200
    45.422     1.276     0.200
    45.422     0.400     0.200
    45.524    -0.391     0.200
    45.582     0.821     0.200
    45.821    -0.196     0.200
    45.916    -0.276     0.200
    46.212    -0.685     0.200
    46.212    -1.064     0.200
    46.475    -0.029     0.200
    46.494    -0.129     0.200
    46.494     0.019     0.200
    47.085    -0.694     0.200
    47.114    -0.502     0.200
    47.114    -0.240     0.200
    47.308    -0.331     0.200
    47.309    -0.087     0.200
    47.309     0.050     0.200
    47.397     0.780     0.200
    47.397     0.518     0.200
    47.547    -1.003     0.200
    47.568    -0.468     0.200
    47.705     1.079     0.200
    47.785     0.193     0.200
    47.759    -0.476     0.200
    47.793    -0.410     0.200
    48.066    -0.382     0.200
    48.122     1.043     0.200
    48.768    -0.738     0.200
    49.074    -0.081     0.200
    49.159    -1.645     0.200
    49.159    -0.134     0.200
    49.159    -1.524     0.200
    49.217    -0.220     0.200
    49.239     0.649     0.200
    49.816    -0.599     0.200
    49.876     0.002     0.200
    49.865    -0.318     0.200
    49.865    -0.216     0.200
    50.196     0.294     0.200
    50.196     2.044     0.200
    50.211     0.588     0.200
    50.212     0.708     0.200
    50.393    -0.121     0.200
    50.396    -0.177     0.200
    50.779     0.141     0.200
    50.908    -0.897     0.200
    51.187    -1.299     0.200
    51.187    -1.768     0.200
    51.203     0.620     0.200
    51.444     0.375     0.200
    51.542     1.145     0.200
    51.542     0.055     0.200
    51.882     0.274     0.200
    51.906     2.329     0.200
    52.426     0.070     0.200
    52.555     0.883     0.200
    52.606     0.325     0.200
    52.905     1.008     0.200
    52.933     0.349     0.200
    52.959     0.117     0.200
    53.068    -0.400     0.200
    53.228    -0.035     0.200
    53.241     0.342     0.200
    53.297    -0.169     0.200
    53.345    -0.514     0.200
    53.360    -1.097     0.200
    53.497     0.159     0.200
    53.622    -0.611     0.200
    53.935     0.256     0.200
    54.003    -0.102     0.200
    54.091    -1.025     0.200
    54.196    -0.698     0.200
    54.198    -0.818     0.200
    54.332    -0.840     0.200
    54.332    -1.137     0.200
    54.377    -0.852     0.200
    54.422    -0.794     0.200
    54.558    -0.671     0.200
    54.759    -0.140     0.200
    54.789    -0.751     0.200
    54.795    -0.285     0.200
    54.864    -1.532     0.200
    54.958    -0.353     0.200
    55.090    -0.743     0.200
    55.143    -0.727     0.200
    55.353    -0.288     0.200
    55.426    -1.391     0.200
    55.443    -0.509     0.200
    55.566    -1.565     0.200
    55.663     0.377     0.200
    55.803     0.346     0.200
    56.055    -0.016     0.200
    56.292     1.038     0.200
    56.292     0.640     0.200
    57.684    -1.398     0.200
    57.881    -0.084     0.200
    58.573    -0.174     0.200
    58.588     0.502     0.200
    58.905    -0.978     0.200
    58.905    -1.603     0.200
    58.905     0.323     0.200
    58.951     0.167     0.200
    59.163    -0.848     0.200
    59.744    -1.750     0.200
    59.996    -0.693     0.200
    61.080    -1.372     0.200
    61.080    -0.673     0.200
    61.080    -1.154     0.200
    62.477    -0.431     0.200
    63.162    -1.711     0.200
    64.284    -1.308     0.200
    66.521    -0.501     0.200
    67.663    -0.042     0.200
    67.763    -1.477     0.200
    68.983    -1.239     0.200
    69.990    -0.786     0.200
    70.750     0.031     0.200
    71.421    -2.300     0.200
    71.421    -1.222     0.200
    71.632    -0.281     0.200
    71.712    -0.737     0.200
    71.713    -0.741     0.200
    71.713    -0.222     0.200
    71.713    -1.401     0.200
    72.063    -2.142     0.200
    72.063    -2.322     0.200
    72.124    -0.883     0.200
    73.909    -0.323     0.200
    73.945    -0.479     0.200
    73.945    -0.608     0.200
    73.975    -0.136     0.200
    74.441    -2.501     0.200
    74.454    -0.436     0.200
    74.515    -0.782     0.200
    74.811    -0.557     0.200
    74.979    -1.108     0.200
    74.979     1.032     0.200
    74.979     0.833     0.200
    74.988    -0.558     0.200
    75.030    -0.555     0.200
    75.153    -0.103     0.200
    75.175    -0.089     0.200
    75.299    -0.437     0.200
    75.433    -0.495     0.200
    75.443    -0.251     0.200
    75.469    -0.675     0.200
    75.627    -1.019     0.200
    75.666     0.022     0.200
    75.720    -0.212     0.200
    75.838     0.400     0.200
    75.892    -0.509     0.200
    75.892    -0.341     0.200
    76.273    -0.486     0.200
    76.273     0.186     0.200
    76.287    -0.137     0.200
    76.315     0.083     0.200
    76.408    -0.121     0.200
    76.523     0.007     0.200
    76.764    -0.802     0.200
    76.796    -0.100     0.200
    76.854    -0.334     0.200
    76.889     0.008     0.200
    77.008    -0.102     0.200
    77.081     0.358     0.200
    77.096    -0.614     0.200
    77.096     0.124     0.200
    77.123    -1.129     0.200
    77.123     0.172     0.200
    77.279     0.321     0.200
    77.316     0.201     0.200
    77.330    -0.397     0.200
    77.330     0.189     0.200
    77.480     0.289     0.200
    77.549     0.422     0.200
    77.646    -0.614     0.200
    77.646     0.499     0.200
    77.673     0.673     0.200
    77.692    -0.130     0.200
    77.753     0.545     0.200
    77.754     0.581     0.200
    77.819     0.930     0.200
    77.827     0.170     0.200
    77.939    -0.935     0.200
    77.929    -0.879     0.200
    78.027    -0.106     0.200
    78.076    -0.644     0.200
    78.076     0.192     0.200
    78.109    -0.870     0.200
    78.140    -0.273     0.200
    78.140    -0.011     0.200
    78.152     0.236     0.200
    78.214    -0.862     0.200
    78.214    -0.108     0.200
    78.277    -0.674     0.200
    78.280    -0.576     0.200
    78.280    -0.025     0.200
    78.335    -0.007     0.200
    78.377    -0.904     0.200
    78.377    -0.782     0.200
    78.414    -1.240     0.200
    78.414    -0.791     0.200
    78.428    -0.854     0.200
    78.428     0.005     0.200
    78.464    -1.444     0.200
    78.489    -0.743     0.200
    78.489    -0.083     0.200
    78.514    -1.811     0.200
    78.585    -0.008     0.200
    78.586    -0.178     0.200
    78.614    -0.449     0.200
    78.629    -1.001     0.200
    78.818    -0.389     0.200
    78.824    -1.266     0.200
    78.824    -0.625     0.200
    78.848    -0.896     0.200
    78.875    -0.787     0.200
    78.887    -0.610     0.200
    78.996    -1.121     0.200
    79.099    -0.331     0.200
    79.212    -0.147     0.200
    79.285    -0.793     0.200
    79.360    -0.788     0.200
    79.368    -1.566     0.200
    79.368    -1.781     0.200
    79.439    -0.468     0.200
    79.485    -1.008     0.200
    79.498    -0.797     0.200
    79.498    -0.555     0.200
    79.538    -0.574     0.200
    79.586    -1.148     0.200
    79.586    -0.062     0.200
    79.607    -0.391     0.200
    79.617    -0.448     0.200
    79.683    -0.767     0.200
    79.745    -0.609     0.200
    79.777    -0.390     0.200
    79.807    -0.063     0.200
    79.854    -1.525     0.200
    79.854    -0.419     0.200
    79.910    -2.069     0.200
    79.910    -0.737     0.200
    79.918    -1.374     0.200
    79.918    -0.632     0.200
    80.042    -0.847     0.200
    80.046    -0.384     0.200
    80.046    -0.134     0.200
    80.144    -0.833     0.200
    80.144    -0.451     0.200
    80.284    -1.578     0.200
    80.329    -1.316     0.200
    80.349    -1.945     0.200
    80.349    -0.852     0.200
    80.351    -1.394     0.200
    80.351    -1.132     0.200
    80.358    -0.861     0.200
    80.402    -1.353     0.200
    80.417    -1.135     0.200
    80.451     0.635     0.200
    80.451    -0.857     0.200
    80.451     0.635     0.200
    80.515     0.001     0.200
    80.525    -1.129     0.200
    80.525    -0.629     0.200
    80.642    -0.737     0.200
    80.699    -0.860     0.200
    80.735    -0.798     0.200
    80.878    -0.399     0.200
    80.947     0.150     0.200
    80.976    -0.733     0.200
    80.976     0.001     0.200
    81.133    -1.870     0.200
    81.133    -0.338     0.200
    81.154    -0.395     0.200
    81.170    -1.186     0.200
    81.170    -0.678     0.200
    81.226    -1.581     0.200
    81.351    -0.913     0.200
    81.363     0.297     0.200
    81.404     0.013     0.200
    81.430    -0.613     0.200
    81.430    -0.117     0.200
    81.572     0.227     0.200
    81.612    -2.886     0.200
    81.739    -0.749     0.200
    81.739     0.001     0.200
    81.812     0.195     0.200
    81.919     0.408     0.200
    82.150     0.524     0.200
    82.215     0.512     0.200
    82.240     0.514     0.200
    82.282     0.228     0.200
    82.379    -0.155     0.200
    82.379     0.341     0.200
    82.407     0.649     0.200
    82.731     0.341     0.200
    82.757     0.412     0.200
    82.782     0.526     0.200
    82.783    -0.225     0.200
    82.885     0.388     0.200
    82.917     0.828     0.200
    83.032    -0.034     0.200
    83.063    -0.153     0.200
    83.097     0.294     0.200
    83.378     0.180     0.200
    83.629    -0.564     0.200
    83.663     0.517     0.200
    83.684     0.112     0.200
    83.939    -0.157     0.200
    83.961    -0.827     0.200
    83.961    -0.456     0.200
    84.041     0.294     0.200
    84.178    -1.530     0.200
    84.178    -0.034     0.200
    84.222     0.188     0.200
    84.245    -1.305     0.200
    84.245     0.226     0.200
    84.293     0.636     0.200
    84.369    -0.246     0.200
    84.369     0.570     0.200
    84.475    -0.781     0.200
    84.521     0.065     0.200
    84.782     0.113     0.200
    85.182    -0.711     0.200
    85.182    -0.270     0.200
    85.187     0.115     0.200
    85.191    -0.441     0.200
    85.316    -0.049     0.200
    85.896     0.006     0.200
    86.085     1.199     0.200
    86.076    -1.178     0.200
    86.076    -0.263     0.200
    86.105    -1.190     0.200
    86.105    -0.338     0.200
    87.141    -0.635     0.200
    87.237    -0.216     0.200
    87.314     0.535     0.200
    87.344     0.076     0.200
    88.029     0.086     0.200
    88.181    -0.202     0.200
    88.274     0.025     0.200
    88.315    -0.586     0.200
    88.315     0.136     0.200
    88.522    -0.207     0.200
    89.571    -0.211     0.200
    93.523    -1.409     0.200
    19.627    -1.481     0.200
    22.631    -0.750     0.200
    22.734    -0.349     0.200
    23.465    -0.203     0.200
    24.542     0.523     0.200
    27.384     0.158     0.200
    45.316    -0.177     0.200
    48.471     0.320     0.200
    48.866    -0.448     0.200
    52.294    -0.986     0.200
    71.784    -0.787     0.200
    74.024    -0.558     0.200
    76.230    -0.879     0.200
    78.327    -0.823     0.200
    86.298    -1.248     0.200
    14.278     6.503     0.200
    14.875     7.467     0.200
    16.686     2.226     0.200
    18.049     1.177     0.200
    18.801    -1.084     0.200
    18.801    -1.377     0.200
    19.098    -0.536     0.200
    19.975     0.352     0.200
    20.028    -0.701     0.200
    20.113    -0.118     0.200
    20.120    -1.699     0.200
    20.303     0.409     0.200
    20.798     0.797     0.200
    21.000     0.078     0.200
    21.019     0.613     0.200
    21.019     1.570     0.200
    21.038     2.753     0.200
    21.103     2.485     0.200
    21.103     3.099     0.200
    21.216     2.924     0.200
    21.216     3.650     0.200
    21.199    -0.381     0.200
    21.252     2.540     0.200
    21.265     1.687     0.200
    21.265     2.000     0.200
    21.375     0.816     0.200
    21.446     2.079     0.200
    21.446     2.782     0.200
    21.469    -0.999     0.200
    21.590     1.914     0.200
    21.590     2.867     0.200
    21.590     0.012     0.200
    21.682    -0.171     0.200
    21.682    -0.714     0.200
    21.682    -0.792     0.200
    21.682    -1.019     0.200
    21.682    -0.581     0.200
    21.709     1.973     0.200
    21.709     3.059     0.200
    21.778    -0.479     0.200
    21.856     2.972     0.200
    21.856     3.101     0.200
    22.149     2.071     0.200
    22.170     1.174     0.200
    22.170     2.389     0.200
    22.635    -1.003     0.200
    22.690     0.940     0.200
    22.690     2.050     0.200
    23.234     0.499     0.200
    23.314    -0.390     0.200
    23.366    -0.454     0.200
    23.366    -0.267     0.200
    23.623    -0.550     0.200
    23.720    -1.469     0.200
    23.720    -0.602     0.200
    24.039    -0.036     0.200
    24.039     2.014     0.200
    24.548     0.042     0.200
    25.151    -1.047     0.200
    25.194     1.684     0.200
    25.340     0.461     0.200
    25.414     2.434     0.200
    25.407     0.133     0.200
    25.526     0.478     0.200
    25.565     1.685     0.200
    26.076     0.969     0.200
    26.118     1.992     0.200
    26.135     0.630     0.200
    26.179     0.733     0.200
    26.229     1.516     0.200
    26.572     0.780     0.200
    26.812     0.320     0.200
    26.917     1.455     0.200
    26.950     0.578     0.200
    27.082     1.812     0.200
    27.082     1.589     0.200
    27.456     0.827     0.200
    27.483     1.354     0.200
    27.483     1.483     0.200
    27.787     0.461     0.200
    28.147     1.648     0.200
    28.302     0.970     0.200
    28.328     0.839     0.200
    28.335     1.180     0.200
    28.394     0.349     0.200
    28.469     0.484     0.200
    28.654     0.038     0.200
    28.735     0.814     0.200
    29.242     0.817     0.200
    29.260     0.252     0.200
    29.440     1.826     0.200
    29.440     1.608     0.200
    29.440     2.229     0.200
    29.440     1.967     0.200
    29.591     0.590     0.200
    29.591     0.261     0.200
    29.591     0.922     0.200
    30.095     1.557     0.200
    30.179     0.919     0.200
    30.289     0.840     0.200
    30.520    -1.097     0.200
    30.553    -0.001     0.200
    30.567     2.044     0.200
    30.646     0.899     0.200
    30.646     1.488     0.200
    30.646     0.395     0.200
    30.763     1.943     0.200
    30.805     1.555     0.200
    30.815    -0.607     0.200
    31.372     1.666     0.200
    31.435     0.056     0.200
    31.435     0.431     0.200
    31.460     0.310     0.200
    31.504     1.520     0.200
    31.512     1.356     0.200
    31.607     0.216     0.200
    31.633     0.275     0.200
    31.633    -0.514     0.200
    31.633     1.052     0.200
    31.633     1.372     0.200
    31.702     0.181     0.200
    32.037     1.540     0.200
    32.105     0.740     0.200
    32.182    -0.839     0.200
    32.320    -0.246     0.200
    32.423    -0.751     0.200
    32.662     1.599     0.200
    32.923     0.975     0.200
    33.137     0.700     0.200
    33.191    -0.886     0.200
    33.486    -1.046     0.200
    33.485    -3.456     0.200
    33.875     0.677     0.200
    33.987     0.289     0.200
    33.987     0.898     0.200
    33.987    -0.801     0.200
    34.445    -0.176     0.200
    34.546    -0.444     0.200
    35.169     0.862     0.200
    35.435    -1.417     0.200
    35.492    -2.000     0.200
    35.668     0.383     0.200
    35.754    -0.633     0.200
    35.800     1.445     0.200
    35.952    -0.550     0.200
    35.993     0.493     0.200
    36.082     0.735     0.200
    36.115     0.948     0.200
    36.218     0.211     0.200
    36.288     0.178     0.200
    36.570    -0.236     0.200
    36.605    -0.236     0.200
    36.605     0.467     0.200
    36.605    -1.533     0.200
    36.738     0.784     0.200
    37.015    -0.737     0.200
    37.311     0.258     0.200
    37.573     1.033     0.200
    37.690    -2.349     0.200
    37.687    -0.651     0.200
    37.687     2.279     0.200
    37.848    -0.884     0.200
    37.875     0.180     0.200
    37.868    -0.957     0.200
    37.925    -0.506     0.200
    37.925     0.064     0.200
    37.925    -0.123     0.200
    38.005     1.130     0.200
    38.111     2.285     0.200
    38.111     2.492     0.200
    38.117     2.005     0.200
    38.130     2.036     0.200
    38.469    -0.021     0.200
    38.468    -2.809     0.200
    38.534     0.729     0.200
    38.534     2.077     0.200
    38.575     1.398     0.200
    38.575    -0.505     0.200
    38.575     0.855     0.200
    38.589    -0.224     0.200
    38.732    -0.425     0.200
    38.786     0.424     0.200
    38.786    -0.029     0.200
    38.786     0.221     0.200
    39.107     0.558     0.200
    39.107     0.336     0.200
    39.662    -0.488     0.200
    39.662     0.602     0.200
    39.787     0.178     0.200
    40.272     0.634     0.200
    40.347    -1.411     0.200
    40.347    -0.790     0.200
    40.347    -0.591     0.200
    40.375    -0.797     0.200
    40.444    -0.145     0.200
    40.638    -1.277     0.200
    40.657    -0.995     0.200
    40.657    -0.507     0.200
    40.867     0.415     0.200
    40.965     0.465     0.200
    41.033     0.218     0.200
    41.334    -0.762     0.200
    41.361     0.349     0.200
    41.361    -1.253     0.200
    41.503     1.286     0.200
    41.548    -0.192     0.200
    41.611     0.098     0.200
    41.728    -0.456     0.200
    41.750     0.462     0.200
    41.869    -0.165     0.200
    41.877     0.457     0.200
    41.913    -0.737     0.200
    41.913    -1.475     0.200
    41.913    -0.776     0.200
    41.932    -0.718     0.200
    42.019     0.359     0.200
    42.007    -0.450     0.200
    42.052     0.391     0.200
    42.090     0.182     0.200
    42.146    -0.538     0.200
    42.159     0.823     0.200
    42.211     0.667     0.200
    42.220    -0.075     0.200
    42.301     1.000     0.200
    42.324     0.547     0.200
    42.368    -0.758     0.200
    42.405     0.553     0.200
    42.540    -0.034     0.200
    42.540     0.615     0.200
    42.589    -0.486     0.200
    42.638     0.925     0.200
    42.812     1.522     0.200
    43.034    -0.044     0.200
    43.105     1.015     0.200
    43.107     1.853     0.200
    43.159     1.380     0.200
    43.185     0.235     0.200
    43.236     0.753     0.200
    43.394    -0.858     0.200
    43.415     1.716     0.200
    43.450    -1.275     0.200
    43.470     1.274     0.200
    43.461    -0.076     0.200
    43.461    -0.345     0.200
    43.461     0.463     0.200
    43.461     0.205     0.200
    43.519     0.543     0.200
    43.551     2.087     0.200
    43.597     0.463     0.200
    43.644     1.605     0.200
    43.644     1.426     0.200
    43.660    -0.448     0.200
    43.701     0.827     0.200
    43.701     0.331     0.200
    43.701     0.721     0.200
    43.768     0.609     0.200
    44.042     0.676     0.200
    44.050    -0.482     0.200
    44.129     0.385     0.200
    44.162    -0.021     0.200
    44.213     0.640     0.200
    44.213     0.003     0.200
    44.225    -0.297     0.200
    44.263     0.236     0.200
    44.273     0.421     0.200
    44.326     0.933     0.200
    44.566     0.613     0.200
    44.601    -0.111     0.200
    44.614     0.769     0.200
    44.631     0.227     0.200
    44.781     1.575     0.200
    44.843     0.397     0.200
    44.970    -0.731     0.200
    44.970     0.480     0.200
    45.123    -0.550     0.200
    45.175     0.710     0.200
    45.210    -0.578     0.200
    45.210    -1.078     0.200
    45.210    -1.539     0.200
    45.257     3.288     0.200
    45.266    -0.285     0.200
    45.266    -0.434     0.200
    45.292     1.641     0.200
    45.378     1.367     0.200
    45.448    -0.124     0.200
    45.448     0.177     0.200
    45.567     0.031     0.200
    45.591     0.611     0.200
    45.622     1.299     0.200
    45.690     0.894     0.200
    45.690     0.047     0.200
    45.690    -0.742     0.200
    45.776     1.282     0.200
    45.825    -0.022     0.200
    45.875     0.238     0.200
    45.903     0.821     0.200
    45.927    -0.301     0.200
    46.031    -0.195     0.200
    46.040     0.666     0.200
    46.080     1.027     0.200
    46.080    -0.078     0.200
    46.113     0.214     0.200
    46.145    -0.159     0.200
    46.206    -0.116     0.200
    46.206     2.583     0.200
    46.267    -0.482     0.200
    46.455    -0.745     0.200
    46.516    -0.127     0.200
    46.519    -2.225     0.200
    46.574    -0.122     0.200
    46.635     1.066     0.200
    46.649     0.952     0.200
    46.637     0.600     0.200
    46.683     0.287     0.200
    46.719     0.140     0.200
    46.762     0.221     0.200
    46.916    -0.480     0.200
    47.031     1.707     0.200
    47.043     0.294     0.200
    47.048    -0.338     0.200
    47.221    -0.235     0.200
    47.302     0.079     0.200
    47.532     1.245     0.200
    47.618    -2.220     0.200
    47.855    -0.089     0.200
    47.922    -0.083     0.200
    47.920     0.636     0.200
    47.977     0.757     0.200
    48.023     0.176     0.200
    48.076     1.298     0.200
    48.215     0.595     0.200
    48.249    -0.490     0.200
    48.249    -0.142     0.200
    48.471    -0.590     0.200
    48.471     0.148     0.200
    48.503     0.307     0.200
    48.729     0.034     0.200
    48.777     0.156     0.200
    48.874     1.151     0.200
    48.932     0.708     0.200
    48.965    -1.782     0.200
    48.965    -0.954     0.200
    48.962    -0.722     0.200
    48.962    -0.425     0.200
    48.964    -0.372     0.200
    49.026     0.187     0.200
    49.164     0.578     0.200
    49.164     0.578     0.200
    49.184    -0.987     0.200
    49.265     0.755     0.200
    49.297     1.199     0.200
    49.324     0.005     0.200
    49.324    -0.131     0.200
    49.324     0.501     0.200
    49.368     0.365     0.200
    49.367     1.649     0.200
    49.367     1.493     0.200
    49.437     0.435     0.200
    49.529     0.055     0.200
    49.529    -0.562     0.200
    49.529    -0.266     0.200
    49.544     0.222     0.200
    49.715    -0.066     0.200
    49.809     0.305     0.200
    49.956     0.800     0.200
    49.956     0.386     0.200
    50.063    -1.330     0.200
    50.097     0.517     0.200
    50.097     0.319     0.200
    50.103     0.206     0.200
    50.103     0.569     0.200
    50.159     0.441     0.200
    50.160     0.159     0.200
    50.172     0.477     0.200
    50.239    -0.259     0.200
    50.291     0.549     0.200
    50.282     0.417     0.200
    50.430    -1.003     0.200
    50.474    -1.127     0.200
    50.474    -0.937     0.200
    50.516     0.350     0.200
    50.591     0.975     0.200
    50.732    -0.305     0.200
    50.732     0.214     0.200
    50.762     0.067     0.200
    50.762     2.051     0.200
    50.795     0.966     0.200
    50.845    -0.378     0.200
    50.880     0.223     0.200
    50.889    -0.677     0.200
    50.889     0.234     0.200
    50.889    -0.165     0.200
    50.932     0.148     0.200
    50.939    -3.156     0.200
    50.968    -0.764     0.200
    50.994     1.020     0.200
    51.081    -0.251     0.200
    51.083    -1.018     0.200
    51.102    -0.070     0.200
    51.181     0.557     0.200
    51.256     0.574     0.200
    51.364     0.194     0.200
    51.484    -0.135     0.200
    51.530     0.869     0.200
    51.538    -0.075     0.200
    51.561    -0.011     0.200
    51.561    -0.433     0.200
    51.591     0.503     0.200
    51.593     0.185     0.200
    51.626     0.243     0.200
    51.775     0.301     0.200
    51.785    -0.416     0.200
    51.787    -0.202     0.200
    51.808    -0.209     0.200
    51.883    -0.045     0.200
    51.883     0.225     0.200
    51.940    -0.273     0.200
    51.940     0.258     0.200
    51.961     0.639     0.200
    52.027    -0.738     0.200
    52.029    -0.028     0.200
    52.117    -0.400     0.200
    52.139     1.203     0.200
    52.159    -0.985     0.200
    52.159    -0.372     0.200
    52.159     0.081     0.200
    52.191    -0.693     0.200
    52.206     0.255     0.200
    52.213    -0.253     0.200
    52.227    -0.954     0.200
    52.244    -0.433     0.200
    52.245    -0.218     0.200
    52.292    -0.097     0.200
    52.359    -0.461     0.200
    52.561     0.366     0.200
    52.584     1.473     0.200
    52.590    -0.180     0.200
    52.626     0.641     0.200
    52.648     0.437     0.200
    52.658     0.472     0.200
    52.681    -0.252     0.200
    52.750     0.534     0.200
    52.778     0.830     0.200
    52.805     0.088     0.200
    52.823     0.928     0.200
    52.823    -0.675     0.200
    52.897    -0.203     0.200
    52.911    -0.623     0.200
    52.935     0.416     0.200
    52.937    -0.455     0.200
    52.937     1.565     0.200
    53.003    -0.559     0.200
    53.032    -0.793     0.200
    53.031    -0.500     0.200
    53.046     0.179     0.200
    53.060    -0.785     0.200
    53.081     0.557     0.200
    53.111    -0.519     0.200
    53.111    -0.594     0.200
    53.189    -0.167     0.200
    53.422    -0.277     0.200
    53.422     0.969     0.200
    53.423     0.423     0.200
    53.427    -0.425     0.200
    53.458    -0.623     0.200
    53.472    -0.548     0.200
    53.556     0.592     0.200
    53.575     0.500     0.200
    53.582    -0.253     0.200
    53.641     0.567     0.200
    53.670    -0.695     0.200
    53.678    -0.582     0.200
    53.721    -0.515     0.200
    53.758     0.609     0.200
    53.776    -0.713     0.200
    53.867     0.703     0.200
    53.879    -0.339     0.200
    53.879    -0.230     0.200
    53.986    -0.176     0.200
    54.035    -0.798     0.200
    54.038     0.391     0.200
    54.073    -0.458     0.200
    54.168    -0.663     0.200
    54.177    -0.175     0.200
    54.273    -1.357     0.200
    54.300     0.414     0.200
    54.319    -0.812     0.200
    54.398    -0.094     0.200
    54.448    -0.268     0.200
    54.527     0.650     0.200
    54.608    -0.172     0.200
    54.774    -0.115     0.200
    54.851    -0.272     0.200
    54.851     0.376     0.200
    54.895     0.580     0.200
    54.992     0.316     0.200
    54.992    -0.235     0.200
    55.096    -0.265     0.200
    55.141     0.358     0.200
    55.144     0.297     0.200
    55.144    -0.781     0.200
    55.184    -0.840     0.200
    55.184    -1.840     0.200
    55.319     0.382     0.200
    55.356    -0.955     0.200
    55.401     0.888     0.200
    55.485    -0.273     0.200
    55.701     0.070     0.200
    55.701    -1.755     0.200
    55.724     0.394     0.200
    55.849    -1.184     0.200
    55.849     0.179     0.200
    55.967     0.341     0.200
    56.067     0.230     0.200
    56.165     0.317     0.200
    56.275    -0.700     0.200
    56.510    -0.131     0.200
    56.546    -0.898     0.200
    56.557    -0.012     0.200
    56.631    -0.288     0.200
    56.672     0.402     0.200
    56.689     0.134     0.200
    56.689     0.763     0.200
    56.689     0.490     0.200
    56.847    -0.734     0.200
    56.912     0.557     0.200
    56.916    -0.729     0.200
    57.063    -0.069     0.200
    57.105     0.472     0.200
    57.196    -0.268     0.200
    57.197     0.325     0.200
    57.199    -0.931     0.200
    57.247     0.216     0.200
    57.284    -0.432     0.200
    57.463    -0.177     0.200
    57.463    -0.193     0.200
    57.505     0.050     0.200
    57.608     0.280     0.200
    57.732     0.179     0.200
    57.778    -0.212     0.200
    57.860    -0.391     0.200
    57.918     0.402     0.200
    58.269    -1.155     0.200
    58.588    -0.584     0.200
    58.621    -0.275     0.200
    58.628    -0.458     0.200
    58.642    -1.261     0.200
    58.790    -0.889     0.200
    58.923    -0.909     0.200
    59.066    -1.929     0.200
    59.066    -1.101     0.200
    59.066    -1.402     0.200
    59.086    -0.938     0.200
    59.464    -0.430     0.200
    59.478    -0.955     0.200
    59.530    -0.993     0.200
    59.556    -0.314     0.200
    59.568    -0.972     0.200
    59.568    -1.097     0.200
    59.970    -0.443     0.200
    60.149    -2.228     0.200
    60.149    -1.869     0.200
    60.409    -0.248     0.200
    60.604    -0.581     0.200
    60.604    -0.081     0.200
    60.604    -1.484     0.200
    60.622    -0.514     0.200
    60.630    -0.139     0.200
    60.686    -0.344     0.200
    60.852    -1.270     0.200
    60.720    -0.471     0.200
    60.768     0.205     0.200
    60.797    -0.794     0.200
    60.942    -1.081     0.200
    61.054    -0.633     0.200
    61.054    -0.441     0.200
    61.131    -1.264     0.200
    61.193    -0.683     0.200
    61.222    -0.510     0.200
    61.222    -0.201     0.200
    61.313    -0.298     0.200
    61.304     0.664     0.200
    61.329    -0.890     0.200
    61.436     0.098     0.200
    61.439    -0.956     0.200
    61.466    -1.135     0.200
    61.467    -1.143     0.200
    61.786    -0.640     0.200
    61.809    -0.188     0.200
    61.816     1.477     0.200
    61.839    -0.813     0.200
    61.886    -0.561     0.200
    62.125    -1.369     0.200
    62.208    -0.060     0.200
    62.237     0.009     0.200
    62.238    -1.330     0.200
    62.238    -1.517     0.200
    62.596    -0.820     0.200
    62.795    -0.147     0.200
    63.032    -0.927     0.200
    63.026    -0.288     0.200
    63.026     1.212     0.200
    63.082    -1.259     0.200
    63.195     0.389     0.200
    63.182     0.580     0.200
    63.315    -0.671     0.200
    65.088     0.123     0.200
    65.088    -0.166     0.200
    65.264     1.120     0.200
    66.273     0.188     0.200
    66.316     0.172     0.200
    66.597    -0.271     0.200
    66.802     1.437     0.200
    66.802    -0.063     0.200
    66.949    -0.103     0.200
    67.915     0.485     0.200
    68.146    -0.781     0.200
    68.354     1.126     0.200
    68.372     1.017     0.200
    68.407     1.397     0.200
    68.479     1.244     0.200
    68.691     0.919     0.200
    68.731     0.878     0.200
    68.746    -0.770     0.200
    68.827     1.072     0.200
    69.057     0.546     0.200
    69.251     1.841     0.200
    69.251     0.259     0.200
    69.312    -0.525     0.200
    69.372     0.990     0.200
    69.622     0.749     0.200
    69.716     0.773     0.200
    69.794     0.788     0.200
    69.854     0.717     0.200
    69.854    -0.142     0.200
    69.998     0.537     0.200
    70.046     0.740     0.200
    70.046    -0.713     0.200
    70.046     0.138     0.200
    70.161     0.933     0.200
    70.531     0.872     0.200
    70.574     0.806     0.200
    70.574    -0.132     0.200
    70.574     0.107     0.200
    70.773     0.797     0.200
    70.773     0.266     0.200
    70.889    -0.207     0.200
    71.122     0.135     0.200
    71.179    -0.876     0.200
    71.179    -0.497     0.200
    71.284    -0.923     0.200
    71.284    -1.243     0.200
    71.285    -1.377     0.200
    71.298    -1.389     0.200
    71.328    -0.339     0.200
    71.328    -0.097     0.200
    72.490    -1.148     0.200
    72.575    -0.862     0.200
    72.628    -1.495     0.200
    72.657    -0.240     0.200
    72.678    -0.115     0.200
    72.746    -1.430     0.200
    72.746    -1.687     0.200
    72.784     0.085     0.200
    72.784     0.729     0.200
    72.848    -1.652     0.200
    73.091    -0.463     0.200
    73.092    -0.492     0.200
    73.092     0.079     0.200
    73.092    -0.620     0.200
    74.091    -2.423     0.200
    74.194    -0.414     0.200
    74.281    -0.169     0.200
    74.736    -0.682     0.200
    74.794    -0.590     0.200
    74.794    -0.305     0.200
    74.804    -0.414     0.200
    74.887     0.001     0.200
    74.928    -0.969     0.200
    74.955    -0.076     0.200
    75.030    -0.535     0.200
    75.217    -0.534     0.200
    75.298    -0.753     0.200
    75.308    -0.796     0.200
    75.308    -0.698     0.200
    75.308    -0.937     0.200
    75.339    -0.322     0.200
    75.364     0.241     0.200
    75.487    -0.082     0.200
    75.512     0.048     0.200
    75.590    -0.567     0.200
    75.590    -0.743     0.200
    75.590    -1.602     0.200
    75.605    -1.723     0.200
    75.685    -0.885     0.200
    75.685    -0.241     0.200
    76.058    -0.312     0.200
    76.112    -0.304     0.200
    76.116    -0.449     0.200
    76.153    -0.543     0.200
    76.316    -1.124     0.200
    76.316    -0.780     0.200
    76.348    -0.192     0.200
    76.370     0.387     0.200
    76.370     1.184     0.200
    76.550     0.138     0.200
    76.696    -0.193     0.200
    76.790     0.104     0.200
    76.822    -0.206     0.200
    76.932    -0.028     0.200
    76.994    -0.208     0.200
    77.036     0.096     0.200
    77.094     0.791     0.200
    77.086     0.477     0.200
    77.165    -0.466     0.200
    77.165    -0.126     0.200
    77.228     0.149     0.200
    77.348    -1.275     0.200
    77.348     0.026     0.200
    77.369     0.097     0.200
    77.369     0.331     0.200
    77.459     0.104     0.200
    77.467    -0.453     0.200
    77.467    -0.144     0.200
    77.540    -0.080     0.200
    77.662    -1.721     0.200
    77.662     3.119     0.200
    77.735     0.839     0.200
    77.781    -0.563     0.200
    77.925    -1.164     0.200
    77.944    -0.031     0.200
    77.949    -0.609     0.200
    77.949    -0.230     0.200
    77.969    -0.880     0.200
    77.969    -0.450     0.200
    78.021    -0.319     0.200
    78.056     0.040     0.200
    78.091     2.232     0.200
    78.092    -0.753     0.200
    78.092    -0.894     0.200
    78.092    -1.012     0.200
    78.092    -0.567     0.200
    78.094    -1.027     0.200
    78.094    -0.691     0.200
    78.112    -0.216     0.200
    78.125     0.016     0.200
    78.173    -0.337     0.200
    78.205    -0.878     0.200
    78.213    -0.597     0.200
    78.213     0.063     0.200
    78.282    -1.706     0.200
    78.295     0.837     0.200
    78.297    -0.330     0.200
    78.337    -2.141     0.200
    78.437    -1.854     0.200
    78.437    -1.584     0.200
    78.437    -1.854     0.200
    78.456     0.671     0.200
    78.456     1.011     0.200
    78.472    -1.297     0.200
    78.472    -0.997     0.200
    78.476    -1.419     0.200
    78.476    -0.770     0.200
    78.578     0.283     0.200
    78.617    -0.228     0.200
    78.660    -0.883     0.200
    78.664    -1.021     0.200
    78.680     1.778     0.200
    78.702    -2.134     0.200
    78.702    -1.724     0.200
    78.729    -0.080     0.200
    78.828     0.171     0.200
    78.840     2.496     0.200
    78.932    -1.726     0.200
    78.935    -1.686     0.200
    78.935    -1.425     0.200
    78.982    -0.675     0.200
    78.997    -0.046     0.200
    79.037     0.492     0.200
    79.113    -0.238     0.200
    79.129    -1.024     0.200
    79.178    -1.305     0.200
    79.178    -0.766     0.200
    79.201    -0.808     0.200
    79.219     1.023     0.200
    79.260    -1.856     0.200
    79.260    -1.223     0.200
    79.291    -0.371     0.200
    79.460     0.505     0.200
    79.460     0.778     0.200
    79.461    -1.916     0.200
    79.469     0.389     0.200
    79.470    -0.812     0.200
    79.470    -0.449     0.200
    79.497    -0.951     0.200
    79.530    -0.677     0.200
    79.530    -0.231     0.200
    79.530    -0.396     0.200
    79.531    -0.078     0.200
    79.534    -0.048     0.200
    79.534     0.350     0.200
    79.555    -1.144     0.200
    79.594    -0.467     0.200
    79.617    -1.439     0.200
    79.617    -1.068     0.200
    79.747     0.115     0.200
    79.777    -0.473     0.200
    79.777     0.179     0.200
    79.803    -1.297     0.200
    79.803    -1.012     0.200
    79.813    -0.887     0.200
    79.813    -0.609     0.200
    79.842    -0.871     0.200
    79.842    -0.363     0.200
    79.885    -0.893     0.200
    79.893    -1.058     0.200
    79.905    -1.011     0.200
    79.905    -0.612     0.200
    79.963    -0.526     0.200
    80.079    -1.560     0.200
    80.079    -1.150     0.200
    80.086    -1.162     0.200
    80.155    -0.604     0.200
    80.155    -1.080     0.200
    80.197    -0.878     0.200
    80.197    -0.120     0.200
    80.206    -0.539     0.200
    80.221    -1.149     0.200
    80.227    -0.875     0.200
    80.227    -0.676     0.200
    80.227    -0.555     0.200
    80.242    -1.011     0.200
    80.242    -0.843     0.200
    80.307    -1.020     0.200
    80.307    -0.504     0.200
    80.326    -0.826     0.200
    80.384    -1.053     0.200
    80.417    -1.025     0.200
    80.417    -0.849     0.200
    80.506    -0.793     0.200
    80.569    -1.045     0.200
    80.575    -0.602     0.200
    80.594    -0.879     0.200
    80.594    -1.015     0.200
    80.679    -1.415     0.200
    80.682    -1.557     0.200
    80.722    -0.173     0.200
    80.751    -0.866     0.200
    80.751     0.634     0.200
    80.781    -0.596     0.200
    80.781    -0.224     0.200
    80.778     0.124     0.200
    80.854    -0.669     0.200
    80.881    -0.880     0.200
    80.881    -1.005     0.200
    80.925    -1.007     0.200
    80.925    -0.597     0.200
    81.034    -1.286     0.200
    81.037    -1.015     0.200
    81.037    -0.730     0.200
    81.092    -1.167     0.200
    81.150    -1.047     0.200
    81.153    -0.852     0.200
    81.153     0.027     0.200
    81.161    -1.003     0.200
    81.257    -1.030     0.200
    81.257    -0.788     0.200
    81.281    -0.179     0.200
    81.363    -0.993     0.200
    81.383    -0.372     0.200
    81.383    -0.255     0.200
    81.445     0.514     0.200
    81.445     0.178     0.200
    81.499     0.455     0.200
    81.553    -0.473     0.200
    81.577    -0.180     0.200
    81.577     0.191     0.200
    81.599     0.327     0.200
    81.612    -0.457     0.200
    81.720    -0.349     0.200
    81.813    -0.506     0.200
    81.850     1.000     0.200
    81.850    -0.899     0.200
    81.850     0.152     0.200
    81.850     1.000     0.200
    81.900    -0.605     0.200
    81.900    -0.277     0.200
    81.935    -0.594     0.200
    81.941    -0.027     0.200
    81.998    -0.106     0.200
    82.038    -0.189     0.200
    82.048    -0.049     0.200
    82.048     0.170     0.200
    82.048     0.459     0.200
    82.079    -0.461     0.200
    82.079    -0.023     0.200
    82.079     0.399     0.200
    82.087    -0.592     0.200
    82.087     0.006     0.200
    82.136    -0.250     0.200
    82.205    -0.311     0.200
    82.205    -0.026     0.200
    82.210    -0.569     0.200
    82.525     0.208     0.200
    82.567    -0.852     0.200
    82.579    -0.197     0.200
    82.614     0.401     0.200
    82.706    -0.076     0.200
    82.777    -0.659     0.200
    82.813    -0.845     0.200
    82.813    -0.537     0.200
    82.850    -0.005     0.200
    83.174    -0.365     0.200
    83.413    -0.298     0.200
    83.491     0.134     0.200
    83.693    -1.262     0.200
    83.693    -0.536     0.200
    83.706     0.087     0.200
    83.828     0.132     0.200
    83.899    -1.260     0.200
    83.899    -0.604     0.200
    83.989    -0.040     0.200
    83.999    -0.843     0.200
    83.999    -0.194     0.200
    84.039     0.426     0.200
    84.039     0.090     0.200
    84.148     0.001     0.200
    84.148     0.208     0.200
    84.299     0.132     0.200
    84.318    -0.312     0.200
    84.548     0.022     0.200
    84.635     0.303     0.200
    84.635     0.631     0.200
    84.803    -0.279     0.200
    84.892    -0.145     0.200
    84.917    -1.065     0.200
    84.937    -0.735     0.200
    85.620    -0.139     0.200
    85.815    -1.259     0.200
    85.815    -0.920     0.200
    85.829    -0.291     0.200
    85.829    -0.901     0.200
    85.879     0.282     0.200
    85.879     0.075     0.200
    85.879     0.610     0.200
    86.159    -0.260     0.200
    86.603    -1.459     0.200
    86.603    -2.057     0.200
    86.953     0.084     0.200
    86.967     0.964     0.200
    87.060    -0.610     0.200
    87.124    -0.379     0.200
    87.476     1.095     0.200
    87.637    -0.398     0.200
    87.947    -0.417     0.200
    87.984    -0.365     0.200
    88.042    -0.543     0.200
    88.042     0.082     0.200
    88.267     0.138     0.200
    88.340    -0.216     0.200
    88.537    -0.540     0.200
    89.316    -0.090     0.200
    90.026    -0.534     0.200
    90.190    -0.678     0.200
    90.819    -0.944     0.200
    90.904     1.281     0.200
    91.803     0.322     0.200
    91.803     1.412     0.200
    91.891     0.352     0.200
    91.891     0.504     0.200
    93.146    -0.262     0.200
    94.480    -1.517     0.200
    95.043    -0.908     0.200
    95.853    -0.900     0.200
    96.386    -0.617     0.200
    99.407    -0.657     0.200
    21.661    -0.424     0.200
    23.291     0.301     0.200
    46.108    -0.260     0.200
    49.149    -0.417     0.200
    72.718    -0.769     0.200
    73.076    -0.721     0.200
    75.296    -0.981     0.200
    86.565    -1.397     0.200
    14.824     7.214     0.200
    17.452     0.950     0.200
    18.816    -0.632     0.200
    18.816    -1.944     0.200
    18.816    -0.151     0.200
    18.894    -0.184     0.200
    19.045    -0.405     0.200
    19.686    -0.823     0.200
    19.694     0.278     0.200
    19.945    -0.122     0.200
    19.990    -0.461     0.200
    20.081    -0.609     0.200
    20.081    -0.438     0.200
    20.269     0.321     0.200
    21.044     2.873     0.200
    21.065     1.652     0.200
    21.086     2.480     0.200
    21.156     0.222     0.200
    21.261     2.126     0.200
    21.302     2.409     0.200
    21.395     2.924     0.200
    21.325     0.791     0.200
    21.490     2.613     0.200
    21.454    -0.641     0.200
    21.454     0.211     0.200
    21.454    -0.055     0.200
    21.558     0.193     0.200
    21.634     3.003     0.200
    21.668     0.550     0.200
    21.668     0.410     0.200
    21.668    -1.512     0.200
    21.755     2.431     0.200
    21.758    -0.700     0.200
    21.901     3.140     0.200
    22.200     1.496     0.200
    23.270    -0.252     0.200
    23.270     0.178     0.200
    23.285    -0.276     0.200
    23.285    -0.585     0.200
    23.337    -0.670     0.200
    23.337    -0.111     0.200
    23.337    -0.432     0.200
    23.611    -0.104     0.200
    23.611    -0.565     0.200
    23.676    -1.075     0.200
    23.676    -1.376     0.200
    23.676    -0.805     0.200
    23.676    -1.227     0.200
    24.069    -0.380     0.200
    24.493     2.233     0.200
    24.512     0.367     0.200
    25.132     1.118     0.200
    25.235     1.057     0.200
    25.328     0.138     0.200
    25.375     1.095     0.200
    25.359     0.055     0.200
    25.567     1.519     0.200
    25.705     0.826     0.200
    26.065     2.655     0.200
    26.152     1.966     0.200
    26.136     1.214     0.200
    26.280     1.400     0.200
    26.519     1.252     0.200
    26.758    -0.503     0.200
    26.968     1.218     0.200
    26.897     0.646     0.200
    27.027     0.552     0.200
    27.027     0.391     0.200
    27.429    -0.338     0.200
    27.429     1.365     0.200
    27.796     1.275     0.200
    27.800     0.938     0.200
    28.314     0.952     0.200
    28.342     1.300     0.200
    28.286     0.994     0.200
    28.343     1.691     0.200
    28.752     1.849     0.200
    29.219     1.108     0.200
    29.455     1.209     0.200
    29.484    -2.541     0.200
    29.570     0.232     0.200
    29.570     0.591     0.200
    30.128     0.949     0.200
    30.245     0.915     0.200
    30.531    -0.007     0.200
    31.023     0.312     0.200
    31.444     0.334     0.200
    31.488     2.450     0.200
    31.452     1.566     0.200
    31.460     1.300     0.200
    31.642    -0.506     0.200
    31.983     1.197     0.200
    33.828    -0.740     0.200
    33.997     0.020     0.200
    33.997     0.488     0.200
    33.997    -0.512     0.200
    34.442     0.232     0.200
    34.528     0.686     0.200
    35.519     1.340     0.200
    35.746     1.426     0.200
    36.079    -1.962     0.200
    36.234     0.011     0.200
    37.042    -0.626     0.200
    37.351    -0.997     0.200
    37.942     0.394     0.200
    37.942     0.500     0.200
    37.942    -0.641     0.200
    37.942     0.601     0.200
    37.942    -0.051     0.200
    37.953    -1.992     0.200
    38.079     2.643     0.200
    38.115     0.140     0.200
    38.460    -0.867     0.200
    38.779     0.387     0.200
    38.779     0.043     0.200
    38.779    -0.445     0.200
    38.871     0.784     0.200
    39.264     1.191     0.200
    40.587    -0.964     0.200
    40.607    -0.514     0.200
    40.812     0.737     0.200
    41.448     1.308     0.200
    41.620    -0.056     0.200
    41.731    -0.414     0.200
    41.731    -0.218     0.200
    41.696     0.471     0.200
    41.887     0.142     0.200
    41.914    -0.940     0.200
    41.923    -0.325     0.200
    41.923    -1.356     0.200
    41.998    -0.307     0.200
    42.099    -0.195     0.200
    42.151    -0.315     0.200
    42.151    -0.143     0.200
    42.167     0.739     0.200
    42.230     0.073     0.200
    42.824    -0.226     0.200
    43.113     0.703     0.200
    43.167     1.286     0.200
    43.167     1.103     0.200
    43.192     0.402     0.200
    43.248     0.626     0.200
    43.405     1.159     0.200
    43.446    -1.634     0.200
    43.408     0.185     0.200
    43.408     0.356     0.200
    43.408    -0.195     0.200
    43.408     0.184     0.200
    43.478     1.246     0.200
    43.464     0.201     0.200
    43.615     0.900     0.200
    43.653     0.425     0.200
    43.653     1.042     0.200
    43.893     0.251     0.200
    44.050     0.531     0.200
    44.125    -0.114     0.200
    44.172     0.916     0.200
    44.219     0.361     0.200
    44.219    -0.065     0.200
    44.232     0.398     0.200
    44.282     0.502     0.200
    44.575     0.790     0.200
    44.787     0.786     0.200
    45.183     0.778     0.200
    45.157    -1.009     0.200
    45.157    -0.251     0.200
    45.426    -0.175     0.200
    45.426    -0.484     0.200
    45.629     0.794     0.200
    45.821     0.308     0.200
    45.883    -0.035     0.200
    45.921     0.256     0.200
    46.056     0.370     0.200
    46.101     0.180     0.200
    46.101    -0.051     0.200
    46.332     0.339     0.200
    46.507     0.496     0.200
    46.563     0.317     0.200
    46.582     0.697     0.200
    46.643     0.868     0.200
    46.692     0.055     0.200
    46.692     0.234     0.200
    46.766     1.452     0.200
    47.933    -0.272     0.200
    48.192     0.743     0.200
    48.507     1.130     0.200
    48.628    -0.337     0.200
    48.736    -0.287     0.200
    48.754    -0.289     0.200
    48.916    -0.615     0.200
    48.911    -0.372     0.200
    48.913    -0.600     0.200
    49.012     0.353     0.200
    49.151     0.787     0.200
    49.142     0.886     0.200
    49.142     0.128     0.200
    49.142     0.323     0.200
    49.269     0.983     0.200
    49.327     0.234     0.200
    49.327     0.336     0.200
    49.694     0.412     0.200
    49.831    -0.057     0.200
    49.960     0.571     0.200
    49.960     0.317     0.200
    50.099     0.857     0.200
    50.101    -0.053     0.200
    50.152    -0.182     0.200
    50.162     0.185     0.200
    50.150     0.976     0.200
    50.245    -0.398     0.200
    50.263     0.817     0.200
    50.293     0.093     0.200
    50.469    -0.591     0.200
    50.458     0.938     0.200
    50.521     0.424     0.200
    50.815     0.758     0.200
    50.815     1.446     0.200
    50.815     0.024     0.200
    50.802     0.081     0.200
    50.824     0.536     0.200
    50.906     1.363     0.200
    50.936     1.157     0.200
    51.159    -0.039     0.200
    51.188     0.448     0.200
    51.213     0.756     0.200
    51.343     0.348     0.200
    51.488    -1.510     0.200
    51.520     0.355     0.200
    51.537     0.554     0.200
    51.556    -1.137     0.200
    51.593     0.190     0.200
    51.598    -0.058     0.200
    51.781    -1.358     0.200
    51.825    -0.422     0.200
    51.887     0.154     0.200
    51.932     0.174     0.200
    51.941     0.060     0.200
    51.944     0.687     0.200
    52.035     0.075     0.200
    52.099     0.148     0.200
    52.127    -0.318     0.200
    52.146     0.339     0.200
    52.160     0.174     0.200
    52.185    -1.059     0.200
    52.201    -0.555     0.200
    52.210    -0.522     0.200
    52.226     0.077     0.200
    52.252    -0.467     0.200
    52.298     0.258     0.200
    52.564     0.087     0.200
    52.660     0.517     0.200
    52.711    -0.076     0.200
    52.752     0.317     0.200
    52.781     0.365     0.200
    52.788     0.247     0.200
    52.804     0.077     0.200
    52.825     0.813     0.200
    52.861    -0.380     0.200
    52.904    -0.558     0.200
    52.927    -0.326     0.200
    52.937     0.304     0.200
    53.043    -0.278     0.200
    53.052    -1.390     0.200
    53.083     0.225     0.200
    53.100    -0.588     0.200
    53.100    -1.186     0.200
    53.433    -0.365     0.200
    53.464    -0.739     0.200
    53.639     0.470     0.200
    53.678    -1.698     0.200
    53.727    -0.662     0.200
    53.759     0.494     0.200
    53.781    -0.567     0.200
    53.867     0.395     0.200
    53.870     0.070     0.200
    53.992    -0.212     0.200
    54.038     0.430     0.200
    54.079    -0.189     0.200
    54.166    -0.605     0.200
    54.404    -0.241     0.200
    54.517     0.586     0.200
    54.614    -0.135     0.200
    54.745     0.813     0.200
    54.883     0.731     0.200
    54.938    -0.070     0.200
    54.938     0.391     0.200
    55.137     0.994     0.200
    55.137    -0.346     0.200
    55.139    -0.219     0.200
    55.168    -0.674     0.200
    55.168     0.127     0.200
    55.318     0.474     0.200
    55.452     1.381     0.200
    55.647     0.280     0.200
    55.819     0.274     0.200
    56.089    -1.491     0.200
    56.559     0.279     0.200
    56.633    -0.657     0.200
    56.925    -0.645     0.200
    57.061     0.094     0.200
    57.070     0.028     0.200
    57.107     0.051     0.200
    57.198     0.132     0.200
    57.207    -0.839     0.200
    57.249     0.385     0.200
    57.464    -0.155     0.200
    57.465     0.503     0.200
    57.523    -0.641     0.200
    57.610     0.517     0.200
    57.862    -0.255     0.200
    58.559     0.767     0.200
    58.647    -1.144     0.200
    58.927    -0.894     0.200
    59.091    -0.929     0.200
    59.484    -0.944     0.200
    59.555    -0.266     0.200
    59.513    -1.808     0.200
    59.513    -1.698     0.200
    60.486    -0.201     0.200
    60.760    -0.319     0.200
    60.765    -0.740     0.200
    60.799    -0.225     0.200
    60.944    -1.053     0.200
    61.002    -0.606     0.200
    61.188    -1.232     0.200
    61.217    -0.723     0.200
    61.471    -1.020     0.200
    61.685    -0.049     0.200
    61.783    -0.469     0.200
    61.834    -0.813     0.200
    61.884    -1.261     0.200
    62.078    -0.405     0.200
    62.134    -1.386     0.200
    62.202    -0.243     0.200
    62.210    -0.708     0.200
    63.011     2.355     0.200
    63.011     0.355     0.200
    63.289    -0.750     0.200
    64.841    -2.081     0.200
    65.066     0.247     0.200
    66.283    -0.180     0.200
    66.284    -0.744     0.200
    66.608     0.031     0.200
    67.924     0.767     0.200
    68.115    -0.456     0.200
    68.574     0.690     0.200
    68.574     0.460     0.200
    68.700     0.703     0.200
    68.740     0.651     0.200
    68.720     0.248     0.200
    68.837     0.445     0.200
    69.068     0.509     0.200
    69.067     0.746     0.200
    69.197     0.011     0.200
    69.168     2.095     0.200
    69.573    -0.118     0.200
    69.633     0.617     0.200
    69.727     0.435     0.200
    69.804     0.664     0.200
    70.009     0.401     0.200
    70.057     0.503     0.200
    70.086     0.626     0.200
    70.172     0.601     0.200
    70.542     0.537     0.200
    70.608    -1.960     0.200
    70.701    -2.190     0.200
    70.785     0.558     0.200
    70.837    -2.063     0.200
    71.012    -0.600     0.200
    71.098    -0.076     0.200
    71.146    -0.826     0.200
    71.479    -0.834     0.200
    71.624    -0.268     0.200
    71.638    -0.603     0.200
    71.742    -0.338     0.200
    71.794    -0.494     0.200
    71.862    -0.609     0.200
    72.314     0.382     0.200
    72.399    -0.107     0.200
    72.562    -0.496     0.200
    72.576    -0.449     0.200
    72.598    -0.282     0.200
    72.713    -0.519     0.200
    72.713    -0.551     0.200
    72.713    -0.715     0.200
    72.733     0.672     0.200
    72.778    -0.279     0.200
    72.868    -0.388     0.200
    72.943    -0.048     0.200
    72.976     0.254     0.200
    73.055    -0.393     0.200
    73.083    -0.560     0.200
    73.084    -0.893     0.200
    73.268    -0.158     0.200
    73.291    -0.352     0.200
    73.534    -0.735     0.200
    73.612    -0.397     0.200
    73.759    -0.162     0.200
    73.764    -0.739     0.200
    73.773     0.299     0.200
    73.791    -0.513     0.200
    73.789    -0.961     0.200
    74.139    -0.279     0.200
    74.146    -0.596     0.200
    74.232    -0.688     0.200
    74.243    -0.510     0.200
    74.359    -0.161     0.200
    74.455    -0.509     0.200
    74.468     0.279     0.200
    74.543    -0.975     0.200
    74.550    -0.823     0.200
    74.550    -0.149     0.200
    74.712    -0.265     0.200
    74.719    -0.338     0.200
    74.746    -0.420     0.200
    74.755    -0.290     0.200
    74.770     0.611     0.200
    74.839    -0.148     0.200
    74.862    -0.136     0.200
    74.906    -0.290     0.200
    74.983    -0.409     0.200
    75.066    -1.310     0.200
    75.066    -0.056     0.200
    75.169    -0.408     0.200
    75.187     0.687     0.200
    75.249    -0.755     0.200
    75.303    -0.839     0.200
    75.303    -0.992     0.200
    75.419    -0.594     0.200
    75.438    -0.407     0.200
    75.462    -0.215     0.200
    75.488     0.640     0.200
    75.512    -0.631     0.200
    75.564    -1.030     0.200
    75.564    -1.511     0.200
    75.566    -0.515     0.200
    75.636    -0.349     0.200
    75.659     0.079     0.200
    75.894     0.350     0.200
    75.978     0.424     0.200
    76.010    -0.635     0.200
    76.062    -0.293     0.200
    76.066    -0.407     0.200
    76.105    -0.581     0.200
    76.175    -0.287     0.200
    76.210    -0.351     0.200
    76.272    -0.870     0.200
    76.298    -0.519     0.200
    76.303     0.441     0.200
    76.347    -0.227     0.200
    76.347     0.843     0.200
    76.347     0.644     0.200
    76.356     0.433     0.200
    76.377     0.172     0.200
    76.385     0.062     0.200
    76.501    -0.174     0.200
    76.581    -0.432     0.200
    76.607     0.534     0.200
    76.646    -0.098     0.200
    76.714     0.049     0.200
    76.741    -0.186     0.200
    76.745     0.634     0.200
    76.774    -0.528     0.200
    76.822     0.192     0.200
    76.884    -0.190     0.200
    76.934     0.196     0.200
    76.947    -0.491     0.200
    76.985    -0.684     0.200
    77.031    -0.873     0.200
    77.038    -0.074     0.200
    77.115    -0.370     0.200
    77.217    -0.064     0.200
    77.245     0.162     0.200
    77.249     0.641     0.200
    77.299     0.043     0.200
    77.319     0.056     0.200
    77.389     0.304     0.200
    77.418    -0.469     0.200
    77.455    -0.534     0.200
    77.490    -0.764     0.200
    77.529     0.311     0.200
    77.541    -0.081     0.200
    77.542    -0.215     0.200
    77.542     1.089     0.200
    77.683     0.300     0.200
    77.731    -0.844     0.200
    77.790    -0.489     0.200
    77.893    -0.072     0.200
    77.898    -0.126     0.200
    77.919    -0.648     0.200
    77.972    -0.484     0.200
    77.986    -0.537     0.200
    78.005    -0.085     0.200
    78.045    -0.977     0.200
    78.045    -0.750     0.200
    78.046     0.288     0.200
    78.064    -0.310     0.200
    78.147    -1.375     0.200
    78.142     0.177     0.200
    78.165    -0.265     0.200
    78.227    -0.049     0.200
    78.247    -0.727     0.200
    78.388    -1.438     0.200
    78.422    -0.362     0.200
    78.429    -0.985     0.200
    78.526     0.299     0.200
    78.569    -0.769     0.200
    78.587     0.175     0.200
    78.610    -1.161     0.200
    78.610    -1.351     0.200
    78.621    -0.204     0.200
    78.652    -2.087     0.200
    78.773    -0.772     0.200
    78.776    -0.502     0.200
    78.891    -1.660     0.200
    78.919    -2.143     0.200
    78.919    -1.335     0.200
    78.933    -0.653     0.200
    78.986     0.201     0.200
    79.065    -0.542     0.200
    79.082    -0.550     0.200
    79.127    -0.865     0.200
    79.155    -1.212     0.200
    79.288    -0.430     0.200
    79.288    -0.966     0.200
    79.408     0.534     0.200
    79.411    -1.614     0.200
    79.448    -1.107     0.200
    79.481    -0.429     0.200
    79.483     0.253     0.200
    79.508    -1.218     0.200
    79.513    -1.311     0.200
    79.567    -0.526     0.200
    79.587    -0.892     0.200
    79.695     0.126     0.200
    79.726    -0.769     0.200
    79.726     0.075     0.200
    79.745    -0.447     0.200
    79.753    -1.314     0.200
    79.763    -0.790     0.200
    79.793    -0.498     0.200
    79.843    -0.739     0.200
    79.856    -0.157     0.200
    80.166    -1.504     0.200
    80.177    -0.942     0.200
    80.192    -0.962     0.200
    80.245    -1.232     0.200
    80.255    -0.988     0.200
    80.274     0.002     0.200
    80.332    -0.410     0.200
    80.367    -0.483     0.200
    80.394    -1.271     0.200
    80.455    -0.675     0.200
    80.482    -0.902     0.200
    80.517    -1.053     0.200
    80.524    -0.675     0.200
    80.544    -0.613     0.200
    80.571    -1.188     0.200
    80.626    -0.409     0.200
    80.631    -2.108     0.200
    80.672    -0.058     0.200
    80.732    -0.356     0.200
    80.728     0.120     0.200
    80.803     0.191     0.200
    80.877    -0.847     0.200
    80.987    -0.176     0.200
    81.104    -0.455     0.200
    81.112    -0.743     0.200
    81.120    -0.476     0.200
    81.142    -0.676     0.200
    81.231    -0.281     0.200
    81.309    -0.494     0.200
    81.334    -0.553     0.200
    81.358    -0.780     0.200
    81.482    -0.691     0.200
    81.482    -0.133     0.200
    81.536     0.280     0.200
    81.505    -0.789     0.200
    81.527    -0.218     0.200
    81.635     0.255     0.200
    81.850     0.222     0.200
    81.835     0.498     0.200
    81.835    -0.189     0.200
    81.835     0.299     0.200
    81.849    -0.599     0.200
    81.849    -0.056     0.200
    81.892    -0.489     0.200
    81.947     1.061     0.200
    81.990    -0.335     0.200
    81.996    -0.156     0.200
    82.029     0.024     0.200
    82.037    -0.436     0.200
    82.089    -0.520     0.200
    82.134     0.001     0.200
    82.155    -0.502     0.200
    82.476    -0.333     0.200
    82.530    -1.583     0.200
    82.608     0.251     0.200
    82.765    -0.601     0.200
    83.364    -0.581     0.200
    83.645    -0.664     0.200
    83.658    -0.682     0.200
    83.779    -0.234     0.200
    83.852    -1.032     0.200
    83.951    -0.588     0.200
    84.100     0.031     0.200
    84.269    -1.816     0.200
    84.290     0.596     0.200
    84.499    -0.244     0.200
    84.758    -1.074     0.200
    84.870    -1.715     0.200
    84.888    -1.130     0.200
    85.064    -0.415     0.200
    85.526    -0.448     0.200
    85.767    -0.956     0.200
    85.826    -1.208     0.200
    85.826    -1.533     0.200
    86.560    -1.229     0.200
    86.917    -0.597     0.200
    87.012    -0.921     0.200
    87.994    -0.925     0.200
    88.219    -0.427     0.200
    88.334    -0.172     0.200
    90.001    -0.978     0.200
    99.370    -0.636     0.200
    20.043    -1.001     0.200
    21.648    -0.230     0.200
    23.335    -0.600     0.200
    23.730    -1.279     0.200
    26.929     0.222     0.200
    27.071     0.060     0.200
    37.960     0.699     0.200
    49.189    -0.352     0.200
    51.865    -1.024     0.200
    72.711    -0.669     0.200
    73.057    -1.234     0.200
    75.275    -1.221     0.200
    78.441    -2.080     0.200
    86.614    -2.483     0.200
    19.811    -0.931     0.200
    19.904    -1.224     0.200
    19.904    -0.306     0.200
    20.598    -0.710     0.200
    21.553    -0.116     0.200
    22.025    -0.669     0.200
    23.044    -0.129     0.200
    23.096    -0.228     0.200
    23.096     0.631     0.200
    23.296     0.191     0.200
    23.296     0.430     0.200
    23.551    -0.843     0.200
    23.551    -0.495     0.200
    23.551    -0.800     0.200
    25.613     0.384     0.200
    27.112     0.565     0.200
    34.318    -2.250     0.200
    37.585    -1.238     0.200
    37.585     0.680     0.200
    40.825    -0.481     0.200
    44.636    -0.820     0.200
    44.828     0.212     0.200
    45.167    -2.328     0.200
    45.167    -0.832     0.200
    45.786     0.360     0.200
    45.787     0.124     0.200
    45.787    -0.333     0.200
    48.478    -0.718     0.200
    48.851    -0.979     0.200
    48.851    -0.338     0.200
    48.863     0.338     0.200
    48.863    -0.662     0.200
    49.124    -1.789     0.200
    51.502     0.035     0.200
    52.541    -1.226     0.200
    52.606    -1.133     0.200
    52.715    -0.544     0.200
    52.742    -1.117     0.200
    52.780    -0.616     0.200
    52.780    -0.690     0.200
    53.010     0.615     0.200
    60.853    -0.402     0.200
    71.729     0.098     0.200
    72.496    -1.116     0.200
    72.704    -0.669     0.200
    73.438    -0.448     0.200
    73.530    -1.212     0.200
    73.694    -1.131     0.200
    75.655    -0.589     0.200
    75.655    -1.737     0.200
    75.655    -0.448     0.200
    76.320    -0.046     0.200
    76.801    -0.127     0.200
    76.856    -0.455     0.200
    77.209     0.086     0.200
    77.442    -0.187     0.200
    78.320    -0.944     0.200
    79.197    -2.274     0.200
    79.502    -2.183     0.200
    80.479    -1.106     0.200
    81.051    -0.872     0.200
    81.420    -1.003     0.200
    81.909    -0.203     0.200
    84.024     0.390     0.200
    19.733     0.255     0.200
    22.432     1.334     0.200
    22.875     0.089     0.200
    23.006    -0.077     0.200
    23.006    -0.667     0.200
    23.542    -0.662     0.200
    23.542     0.073     0.200
    37.172     0.798     0.200
    37.172    -0.979     0.200
    38.126    -0.331     0.200
    40.279     0.595     0.200
    41.207    -0.851     0.200
    41.207    -1.116     0.200
    43.486    -0.700     0.200
    43.499    -0.113     0.200
    45.254     1.177     0.200
    45.495    -0.459     0.200
    45.496    -0.255     0.200
    45.496     0.270     0.200
    48.633     0.123     0.200
    51.194    -0.114     0.200
    52.239    -0.756     0.200
    52.478    -0.786     0.200
    52.478    -0.437     0.200
    65.531    -0.004     0.200
    71.790     0.266     0.200
    71.960    -0.652     0.200
    71.960    -0.523     0.200
    71.960    -0.182     0.200
    72.596    -0.545     0.200
    73.570    -1.417     0.200
    73.825     0.156     0.200
    76.415     0.119     0.200
    76.840    -0.420     0.200
    77.460    -0.466     0.200
    80.403    -0.945     0.200
    20.106    -0.343     0.200
    21.600    -1.399     0.200
    23.400    -0.848     0.200
    23.789    -1.303     0.200
    25.432    -0.261     0.200
    46.205    -0.227     0.200
    49.254    -0.074     0.200
    51.927    -0.475     0.200
    53.203    -0.892     0.200
    61.284    -1.569     0.200
    72.736    -0.424     0.200
    73.004    -0.565     0.200
    75.220    -1.216     0.200
    20.266    -0.168     0.200
    23.622     0.207     0.200
    23.896    -1.094     0.200
    72.662    -0.221     0.200
    74.882    -0.622     0.200
    20.354    -1.153     0.200
    20.567    -0.216     0.200
    20.567    -0.716     0.200
    20.630    -0.715     0.200
    20.704     0.015     0.200
    20.719    -1.041     0.200
    20.719    -2.121     0.200
    22.621     0.499     0.200
    22.621    -0.651     0.200
    23.012    -0.741     0.200
    23.797    -0.154     0.200
    24.097    -0.113     0.200
    24.158    -1.655     0.200
    24.158    -0.540     0.200
    24.620    -0.570     0.200
    24.620    -0.820     0.200
    26.419    -1.709     0.200
    26.862     2.353     0.200
    27.256    -0.355     0.200
    32.547    -0.355     0.200
    35.594     1.059     0.200
    39.038    -0.278     0.200
    39.038     0.483     0.200
    39.038    -0.147     0.200
    39.599    -0.005     0.200
    39.599    -0.955     0.200
    40.003    -0.638     0.200
    42.137     0.220     0.200
    42.723    -0.144     0.200
    42.979     0.047     0.200
    42.990     0.005     0.200
    43.001    -0.827     0.200
    43.001    -0.292     0.200
    43.001    -0.642     0.200
    43.010    -0.974     0.200
    43.010    -0.661     0.200
    43.202    -0.050     0.200
    43.248    -0.406     0.200
    43.269     0.479     0.200
    43.333    -0.025     0.200
    43.415     0.376     0.200
    44.215     0.979     0.200
    44.269     0.802     0.200
    44.271    -1.422     0.200
    44.293     0.048     0.200
    44.415     0.056     0.200
    44.510    -0.437     0.200
    44.507     1.382     0.200
    44.717     0.880     0.200
    44.755     0.495     0.200
    45.152     0.622     0.200
    45.187    -0.359     0.200
    45.317     0.397     0.200
    45.330     0.009     0.200
    45.385     0.124     0.200
    45.678    -0.068     0.200
    46.286     0.728     0.200
    46.730     1.262     0.200
    47.010     0.596     0.200
    47.105    -0.441     0.200
    47.105    -0.651     0.200
    49.200    -1.828     0.200
    49.200    -1.668     0.200
    50.050    -0.033     0.200
    52.853    -0.515     0.200
    52.981    -0.672     0.200
    54.121    -1.106     0.200
    54.121    -0.981     0.200
    55.543    -0.448     0.200
    62.245    -0.841     0.200
    67.387    -0.435     0.200
    67.387    -0.897     0.200
    71.981    -0.491     0.200
    71.981    -0.878     0.200
    73.688    -0.155     0.200
    74.206    -0.899     0.200
    78.671    -1.222     0.200
    82.433     0.219     0.200
    82.433     0.484     0.200
    20.079    -0.647     0.200
    21.448     0.785     0.200
    23.414    -0.065     0.200
    23.730    -0.406     0.200
    25.509     0.086     0.200
    31.863     1.151     0.200
    38.163     0.051     0.200
    39.131     0.793     0.200
    46.281    -0.407     0.200
    49.296     0.038     0.200
    72.868    -0.425     0.200
    72.924    -0.157     0.200
    75.092    -0.630     0.200
    78.403    -0.673     0.200
    15.133     6.879     0.200
    16.860     0.695     0.200
    17.271     3.833     0.200
    18.857    -1.462     0.200
    20.614     0.260     0.200
    20.622    -1.250     0.200
    20.622    -0.434     0.200
    20.607    -0.462     0.200
    20.607     0.038     0.200
    20.607    -0.251     0.200
    20.712    -1.176     0.200
    20.712    -1.405     0.200
    20.712    -0.506     0.200
    20.833     0.843     0.200
    20.842     0.389     0.200
    20.818    -0.648     0.200
    23.855    -0.087     0.200
    24.030    -0.704     0.200
    24.030     0.167     0.200
    24.065    -0.931     0.200
    24.198    -0.342     0.200
    24.467     0.933     0.200
    24.925    -0.740     0.200
    25.591     0.531     0.200
    26.184    -0.258     0.200
    27.059     1.233     0.200
    27.454     1.292     0.200
    27.454     1.652     0.200
    27.867     0.189     0.200
    29.789     1.105     0.200
    30.412     0.134     0.200
    31.270     1.457     0.200
    31.270     1.257     0.200
    32.313    -0.097     0.200
    32.512     0.309     0.200
    33.161     1.949     0.200
    33.355    -1.867     0.200
    35.805     0.335     0.200
    38.782    -0.235     0.200
    38.798     0.337     0.200
    38.798     0.542     0.200
    39.626    -0.656     0.200
    39.651    -0.619     0.200
    39.651     0.011     0.200
    39.651     0.321     0.200
    40.272    -0.528     0.200
    42.172     0.026     0.200
    42.742     0.086     0.200
    42.761     0.036     0.200
    42.782    -0.342     0.200
    42.792     0.083     0.200
    42.794    -0.684     0.200
    42.794    -0.534     0.200
    42.799    -0.077     0.200
    42.803    -0.386     0.200
    42.803     0.033     0.200
    42.803    -0.506     0.200
    42.895    -0.358     0.200
    42.935    -0.278     0.200
    43.614    -0.469     0.200
    43.803    -1.090     0.200
    43.984     0.367     0.200
    44.038     1.375     0.200
    44.323     0.031     0.200
    44.322    -0.155     0.200
    44.349     1.226     0.200
    44.486     0.778     0.200
    44.522     1.796     0.200
    44.522     2.026     0.200
    44.921     1.105     0.200
    44.958    -0.329     0.200
    44.977    -0.180     0.200
    44.990    -0.083     0.200
    45.001     0.476     0.200
    45.094     0.759     0.200
    45.152     0.503     0.200
    45.152     1.040     0.200
    45.444     0.366     0.200
    46.259     1.333     0.200
    46.655     0.770     0.200
    46.783     0.571     0.200
    46.851     0.524     0.200
    46.913     1.154     0.200
    46.955    -0.062     0.200
    47.089    -0.534     0.200
    47.562     1.236     0.200
    47.593     0.620     0.200
    48.414     0.688     0.200
    48.987     0.222     0.200
    49.296    -1.110     0.200
    49.296    -1.480     0.200
    49.608     0.130     0.200
    49.755     0.310     0.200
    49.946     0.138     0.200
    49.946     0.158     0.200
    50.029     1.326     0.200
    50.054     0.237     0.200
    50.206     0.435     0.200
    50.504     0.018     0.200
    50.947     0.866     0.200
    50.978     0.352     0.200
    51.041     0.883     0.200
    51.120     0.663     0.200
    51.142    -0.381     0.200
    51.172     1.097     0.200
    51.397     0.449     0.200
    51.676     0.751     0.200
    52.062     0.594     0.200
    52.153    -0.254     0.200
    52.366     0.583     0.200
    52.398     0.642     0.200
    52.410     0.272     0.200
    52.474    -0.242     0.200
    52.690    -0.461     0.200
    52.764    -0.470     0.200
    52.908     0.528     0.200
    53.124    -0.487     0.200
    53.173     0.151     0.200
    53.247     0.390     0.200
    53.596    -0.099     0.200
    53.622     0.510     0.200
    53.586    -0.215     0.200
    53.639    -0.216     0.200
    53.703    -0.604     0.200
    53.862    -0.545     0.200
    53.906     0.301     0.200
    53.962    -1.177     0.200
    53.962    -1.152     0.200
    54.308    -0.222     0.200
    54.339    -0.572     0.200
    54.602    -0.816     0.200
    54.657    -0.529     0.200
    54.868    -0.314     0.200
    54.954    -0.738     0.200
    55.483     0.419     0.200
    55.483    -0.828     0.200
    55.489    -0.017     0.200
    58.356    -0.084     0.200
    59.527    -1.860     0.200
    62.063    -0.858     0.200
    65.939    -0.147     0.200
    67.148    -0.259     0.200
    72.212    -1.208     0.200
    73.399    -0.237     0.200
    74.427    -1.504     0.200
    78.187     0.463     0.200
    78.769    -1.075     0.200
    79.460    -1.076     0.200
    79.700     0.216     0.200
    80.182    -1.390     0.200
    82.143     0.421     0.200
    87.097    -2.119     0.200
    20.868    -0.017     0.200
    24.200    -0.497     0.200
    46.923    -0.921     0.200
    49.922    -0.124     0.200
    72.258    -1.551     0.200
    16.964     0.983     0.200
    20.781    -1.332     0.200
    24.277    -1.375     0.200
    20.613    -0.379     0.200
    20.736     1.260     0.200
    24.173    -0.904     0.200
    26.228    -0.359     0.200
    26.982     1.616     0.200
    52.737    -0.910     0.200
    19.861    -0.992     0.200
    23.079    -0.313     0.200
    23.610    -0.216     0.200
    73.457    -0.315     0.200
    75.670    -0.836     0.200
    19.953    -0.059     0.200
    20.048    -0.252     0.200
    22.597     0.323     0.200
    23.032    -1.529     0.200
    23.032    -1.529     0.200
    23.807     0.190     0.200
    27.711     0.598     0.200
    45.519    -0.861     0.200
    48.721    -0.540     0.200
    73.946    -0.677     0.200
    76.134    -0.698     0.200
    18.507    -0.855     0.200
    18.638    -0.697     0.200
    20.129    -0.020     0.200
    20.177     0.151     0.200
    20.220    -0.873     0.200
    20.211     1.080     0.200
    21.103    -1.071     0.200
    21.173     1.099     0.200
    21.326    -0.926     0.200
    21.326    -0.566     0.200
    21.465     1.030     0.200
    21.539    -0.067     0.200
    21.539    -0.207     0.200
    21.539     1.133     0.200
    21.557     0.940     0.200
    21.575     0.250     0.200
    21.639    -0.160     0.200
    22.493    -0.999     0.200
    23.435    -0.258     0.200
    23.435    -0.333     0.200
    23.765    -0.072     0.200
    23.765    -0.592     0.200
    23.802    -0.363     0.200
    23.802    -1.163     0.200
    23.870     2.036     0.200
    24.322     2.087     0.200
    24.354    -0.255     0.200
    25.328     0.128     0.200
    25.482     0.439     0.200
    26.828     0.355     0.200
    27.080     1.710     0.200
    27.080     0.210     0.200
    27.088     0.818     0.200
    27.480    -0.366     0.200
    27.480     1.594     0.200
    27.480     1.804     0.200
    27.601    -0.088     0.200
    28.259     1.341     0.200
    29.583     0.474     0.200
    29.583     2.374     0.200
    29.583     2.484     0.200
    29.583     1.374     0.200
    29.752    -0.302     0.200
    29.752    -0.471     0.200
    29.752     0.179     0.200
    30.138     2.606     0.200
    30.747     0.684     0.200
    30.747     2.374     0.200
    30.747     1.884     0.200
    31.294     1.299     0.200
    31.396     1.958     0.200
    31.581    -0.044     0.200
    31.779    -0.214     0.200
    31.847    -0.432     0.200
    31.847    -0.107     0.200
    32.460    -0.067     0.200
    32.804     0.307     0.200
    33.820    -0.866     0.200
    33.844    -0.675     0.200
    34.305     2.065     0.200
    34.591    -0.656     0.200
    34.683     0.528     0.200
    35.876     0.890     0.200
    36.098    -0.320     0.200
    36.228     0.070     0.200
    36.716     0.403     0.200
    37.285    -0.155     0.200
    37.462    -0.553     0.200
    38.065     0.069     0.200
    38.067    -0.555     0.200
    38.067    -0.045     0.200
    38.067     0.355     0.200
    38.067    -0.555     0.200
    38.612    -1.137     0.200
    38.605    -1.212     0.200
    38.931     0.192     0.200
    38.931    -0.248     0.200
    38.931     0.392     0.200
    39.196     0.202     0.200
    39.196    -0.372     0.200
    39.196     0.378     0.200
    39.196    -0.122     0.200
    40.070    -1.206     0.200
    40.241     0.574     0.200
    40.596    -0.308     0.200
    41.112     0.386     0.200
    41.437    -0.990     0.200
    41.547     0.209     0.200
    42.009    -0.566     0.200
    42.060    -0.513     0.200
    42.060    -0.688     0.200
    42.060    -0.888     0.200
    42.069    -1.421     0.200
    42.069    -0.451     0.200
    42.069    -1.061     0.200
    42.069    -1.843     0.200
    42.236     0.127     0.200
    42.293    -0.284     0.200
    42.305     0.519     0.200
    42.447     0.669     0.200
    42.880    -0.658     0.200
    43.251     0.873     0.200
    43.305     1.179     0.200
    43.424    -0.759     0.200
    43.424     0.241     0.200
    43.426     0.425     0.200
    43.500    -0.271     0.200
    43.542     2.731     0.200
    43.596    -0.314     0.200
    43.588    -0.875     0.200
    43.692    -0.314     0.200
    43.753     1.001     0.200
    43.790     1.738     0.200
    43.790     2.026     0.200
    43.790     1.496     0.200
    44.188     0.759     0.200
    44.225    -0.692     0.200
    44.244    -0.145     0.200
    44.275     0.173     0.200
    44.350    -0.100     0.200
    44.360     0.542     0.200
    44.372     0.326     0.200
    44.419     0.644     0.200
    44.419     0.248     0.200
    44.712     0.613     0.200
    44.712     0.168     0.200
    44.927     1.173     0.200
    45.321     0.361     0.200
    45.321     0.180     0.200
    45.742     0.304     0.200
    45.769     0.224     0.200
    45.923     0.255     0.200
    45.971     0.416     0.200
    45.971    -0.074     0.200
    46.049     0.870     0.200
    46.163     0.290     0.200
    46.178     1.073     0.200
    46.178     0.393     0.200
    46.252    -0.084     0.200
    46.255    -0.059     0.200
    46.255    -0.339     0.200
    46.261    -0.160     0.200
    46.470     1.112     0.200
    46.659     0.255     0.200
    46.781     0.728     0.200
    46.830     0.942     0.200
    48.760    -0.476     0.200
    48.760    -0.757     0.200
    48.875    -0.277     0.200
    48.875     0.262     0.200
    48.875     0.032     0.200
    48.908    -0.222     0.200
    49.260    -0.320     0.200
    49.296     0.229     0.200
    49.296     0.104     0.200
    49.296     0.433     0.200
    49.296    -0.052     0.200
    49.300     0.276     0.200
    49.295     0.318     0.200
    49.471    -0.734     0.200
    49.471    -0.134     0.200
    49.848     0.089     0.200
    49.956    -0.125     0.200
    50.015    -0.038     0.200
    50.103     0.159     0.200
    50.244     0.692     0.200
    50.244     0.394     0.200
    50.244     0.834     0.200
    50.303     0.874     0.200
    50.307     0.219     0.200
    50.408     0.649     0.200
    50.512     0.055     0.200
    50.827     0.385     0.200
    50.978     0.770     0.200
    51.403     0.261     0.200
    51.497     0.287     0.200
    51.664     0.213     0.200
    51.738    -0.169     0.200
    51.738     0.406     0.200
    51.741     0.281     0.200
    51.978    -0.303     0.200
    52.029     0.384     0.200
    52.029     0.108     0.200
    52.029     0.293     0.200
    52.087    -0.048     0.200
    52.087     0.652     0.200
    52.254    -0.006     0.200
    52.267    -0.090     0.200
    52.306    -0.475     0.200
    52.306    -0.243     0.200
    52.380    -0.116     0.200
    52.544     0.495     0.200
    52.709     0.670     0.200
    52.731    -1.427     0.200
    52.897     0.563     0.200
    52.918     0.283     0.200
    52.943     0.151     0.200
    53.047    -0.585     0.200
    53.080    -0.510     0.200
    53.171    -1.009     0.200
    53.228    -0.048     0.200
    53.252     0.244     0.200
    53.254    -0.780     0.200
    53.254    -1.280     0.200
    53.254    -0.480     0.200
    53.336    -1.073     0.200
    53.569     1.434     0.200
    53.703     0.571     0.200
    53.787    -0.663     0.200
    54.023    -0.330     0.200
    54.185     0.158     0.200
    54.319     0.051     0.200
    54.447     0.342     0.200
    54.670     0.921     0.200
    54.894    -0.576     0.200
    55.007     0.330     0.200
    54.998     0.299     0.200
    55.289     0.676     0.200
    55.288     0.770     0.200
    55.466    -0.046     0.200
    55.521     0.047     0.200
    55.726    -1.146     0.200
    55.871    -0.164     0.200
    56.146    -0.489     0.200
    56.210    -0.413     0.200
    57.342    -0.749     0.200
    57.610     0.250     0.200
    57.646     0.161     0.200
    61.338    -0.502     0.200
    66.169    -0.144     0.200
    66.419     0.100     0.200
    66.743     0.006     0.200
    68.061     0.639     0.200
    68.838     0.325     0.200
    68.876    -0.148     0.200
    69.202     0.229     0.200
    69.332     0.135     0.200
    69.456     0.667     0.200
    69.767     0.407     0.200
    69.861     0.712     0.200
    70.143    -0.270     0.200
    70.191     0.633     0.200
    70.191     0.873     0.200
    72.796     0.030     0.200
    72.945    -0.002     0.200
    72.946     0.040     0.200
    72.946    -0.220     0.200
    75.161    -0.156     0.200
    75.661    -0.624     0.200
    75.897     0.445     0.200
    76.996     0.006     0.200
    77.674     0.466     0.200
    78.104    -0.719     0.200
    78.496    -1.295     0.200
    80.145    -1.245     0.200
    81.222     0.031     0.200
    81.559     0.034     0.200
    81.707    -0.097     0.200
    85.682    -1.239     0.200
    86.689    -1.078     0.200
    88.193    -0.153     0.200
    19.936    -1.444     0.200
    21.956    -1.169     0.200
    23.407    -0.454     0.200
    23.672    -1.944     0.200
    72.407    -1.489     0.200
    73.357    -1.028     0.200
    75.569    -1.253     0.200
    78.435    -1.988     0.200
    86.087    -1.714     0.200
    86.544    -2.345     0.200
    14.999     6.770     0.200
    20.223    -0.876     0.200
    20.436    -0.292     0.200
    20.436    -0.214     0.200
    20.436     0.434     0.200
    20.537    -0.364     0.200
    20.451    -0.225     0.200
    20.593     1.135     0.200
    20.668    -0.224     0.200
    20.756    -1.110     0.200
    21.389    -0.891     0.200
    22.766     2.005     0.200
    23.268    -0.846     0.200
    24.160     0.492     0.200
    24.195     0.044     0.200
    24.172    -0.907     0.200
    24.172    -0.313     0.200
    24.172    -0.548     0.200
    24.718    -1.267     0.200
    24.718     0.054     0.200
    25.174    -0.169     0.200
    26.797     0.449     0.200
    27.190     0.105     0.200
    30.823     0.925     0.200
    32.882    -1.766     0.200
    39.171     0.757     0.200
    39.746     0.192     0.200
    39.893    -0.529     0.200
    43.088    -0.708     0.200
    47.202    -0.435     0.200
    50.128    -0.248     0.200
    50.515    -1.148     0.200
    50.512    -1.130     0.200
    52.954    -0.376     0.200
    53.103    -0.008     0.200
    55.630    -0.290     0.200
    71.856    -1.042     0.200
    73.825    -0.241     0.200
    74.085    -1.317     0.200
    74.085    -1.692     0.200
    78.657    -1.318     0.200
    84.612    -2.284     0.200
    84.612    -1.901     0.200
    87.072    -1.728     0.200
    19.632    -0.398     0.200
    19.671    -1.429     0.200
    19.765    -1.086     0.200
    19.765    -0.497     0.200
    19.765    -0.758     0.200
    19.998    -0.501     0.200
    21.842     0.811     0.200
    21.975     0.659     0.200
    22.322    -1.068     0.200
    22.322    -0.432     0.200
    22.410    -0.982     0.200
    22.534     0.146     0.200
    22.534    -0.491     0.200
    22.530    -0.890     0.200
    22.632    -0.832     0.200
    22.829    -0.384     0.200
    22.909    -0.232     0.200
    22.909    -0.471     0.200
    22.909    -0.572     0.200
    23.494    -0.917     0.200
    23.494    -0.128     0.200
    23.494    -0.807     0.200
    24.866     2.008     0.200
    26.908     0.016     0.200
    27.357     0.886     0.200
    27.764    -0.281     0.200
    30.594    -0.659     0.200
    30.793    -0.321     0.200
    38.026     0.212     0.200
    38.026    -0.089     0.200
    39.192    -0.080     0.200
    41.104    -1.039     0.200
    41.234    -0.452     0.200
    42.804     1.171     0.200
    43.878    -0.456     0.200
    43.916     0.070     0.200
    45.398    -0.075     0.200
    45.399    -0.066     0.200
    45.399    -0.191     0.200
    48.163    -0.071     0.200
    48.544     0.237     0.200
    48.544    -0.013     0.200
    48.881    -0.120     0.200
    48.881    -1.257     0.200
    48.881    -0.901     0.200
    51.095    -0.867     0.200
    52.379    -1.004     0.200
    52.379    -0.636     0.200
    54.254     0.125     0.200
    61.053    -0.679     0.200
    65.428     0.544     0.200
    67.152     0.049     0.200
    70.784     1.095     0.200
    71.872    -0.178     0.200
    72.340     0.216     0.200
    72.776     0.446     0.200
    73.929    -0.005     0.200
    73.929    -0.130     0.200
    73.930     0.159     0.200
    76.136    -0.268     0.200
    76.136    -0.026     0.200
    78.343    -1.146     0.200
    86.333    -1.260     0.200
    86.333    -0.760     0.200
    86.355    -0.827     0.200
    86.651    -0.494     0.200
    15.075     6.370     0.200
    16.803     4.113     0.200
    17.465     0.391     0.200
    18.558    -0.875     0.200
    19.348    -1.043     0.200
    20.153     0.105     0.200
    20.157     0.032     0.200
    20.366     0.213     0.200
    20.377    -1.058     0.200
    20.461     0.227     0.200
    20.499     0.616     0.200
    20.761    -1.067     0.200
    20.761    -1.760     0.200
    20.849    -0.931     0.200
    20.849    -1.271     0.200
    21.321    -0.574     0.200
    21.378     1.233     0.200
    22.698     2.931     0.200
    22.698     2.739     0.200
    23.046     0.456     0.200
    23.190     0.704     0.200
    23.190     0.245     0.200
    24.256    -0.429     0.200
    24.256    -0.679     0.200
    24.260    -0.874     0.200
    24.260    -0.566     0.200
    24.260    -0.216     0.200
    24.368     1.704     0.200
    24.525    -0.430     0.200
    24.810     0.370     0.200
    24.810    -0.069     0.200
    24.985     1.585     0.200
    25.159    -0.001     0.200
    26.276     1.277     0.200
    26.743     1.063     0.200
    26.848     1.200     0.200
    26.848    -0.044     0.200
    26.856    -0.557     0.200
    26.859    -0.582     0.200
    27.240     1.493     0.200
    27.240    -0.288     0.200
    27.240    -0.426     0.200
    27.240     1.792     0.200
    27.542     1.176     0.200
    27.783    -0.378     0.200
    27.783    -0.529     0.200
    27.783     1.821     0.200
    28.773     0.501     0.200
    29.296     1.160     0.200
    30.702     0.012     0.200
    30.702    -0.378     0.200
    30.756     2.147     0.200
    30.842    -0.413     0.200
    30.788     2.161     0.200
    31.303     0.987     0.200
    31.526     0.964     0.200
    31.828     0.734     0.200
    32.204     0.698     0.200
    32.467    -0.552     0.200
    32.789     0.393     0.200
    32.789     0.973     0.200
    32.750    -0.082     0.200
    32.922     0.811     0.200
    32.948     0.489     0.200
    34.956     1.051     0.200
    34.936     1.150     0.200
    35.475     1.487     0.200
    35.591     1.419     0.200
    35.674     0.567     0.200
    35.711    -0.151     0.200
    36.567    -0.270     0.200
    36.841    -0.679     0.200
    36.841    -0.900     0.200
    37.067     0.371     0.200
    37.224    -0.556     0.200
    37.349    -1.720     0.200
    37.685    -0.162     0.200
    37.829    -0.081     0.200
    38.178     0.476     0.200
    39.236     0.096     0.200
    39.238     0.082     0.200
    39.238    -0.854     0.200
    39.238     0.332     0.200
    39.562    -0.419     0.200
    39.562    -0.249     0.200
    39.694     0.677     0.200
    39.709    -0.272     0.200
    39.709    -0.047     0.200
    39.709    -0.547     0.200
    39.778     0.381     0.200
    39.805     1.094     0.200
    39.904    -0.233     0.200
    39.928    -0.464     0.200
    39.904     0.104     0.200
    39.937    -0.438     0.200
    40.023     0.048     0.200
    40.023     0.160     0.200
    40.523    -0.299     0.200
    42.017    -0.959     0.200
    42.913     0.333     0.200
    42.913    -0.014     0.200
    42.915    -0.573     0.200
    43.185     0.333     0.200
    43.192     0.021     0.200
    43.202    -0.972     0.200
    43.202    -0.408     0.200
    43.202    -0.597     0.200
    43.202    -0.597     0.200
    43.202    -0.197     0.200
    43.211    -1.849     0.200
    44.028    -0.246     0.200
    44.030    -1.562     0.200
    44.418     1.290     0.200
    44.418     1.173     0.200
    44.418    -0.167     0.200
    44.535    -0.403     0.200
    44.472     1.236     0.200
    44.709     0.157     0.200
    44.744    -0.568     0.200
    44.888     0.487     0.200
    44.958     1.468     0.200
    44.958     0.585     0.200
    44.958     0.226     0.200
    45.205    -0.799     0.200
    45.234    -0.065     0.200
    45.355     0.779     0.200
    45.365    -0.008     0.200
    45.383    -0.050     0.200
    45.385     0.580     0.200
    45.396    -0.057     0.200
    45.520     0.491     0.200
    45.533     0.164     0.200
    45.587    -0.125     0.200
    45.735    -0.337     0.200
    45.881     0.305     0.200
    46.187    -1.004     0.200
    46.480     0.157     0.200
    46.489     0.220     0.200
    46.489     0.048     0.200
    46.506    -0.546     0.200
    46.506    -0.007     0.200
    46.506     0.394     0.200
    46.806    -0.306     0.200
    46.933     1.261     0.200
    47.078    -0.136     0.200
    47.089     1.230     0.200
    47.189     0.631     0.200
    47.268     0.597     0.200
    47.291    -0.244     0.200
    47.295    -0.670     0.200
    47.295    -0.039     0.200
    47.295    -0.265     0.200
    47.318     0.128     0.200
    47.301    -0.221     0.200
    47.326    -0.358     0.200
    47.337     0.581     0.200
    47.352     0.522     0.200
    47.568     0.073     0.200
    47.709    -0.408     0.200
    47.637     1.409     0.200
    47.696     0.213     0.200
    47.746    -0.377     0.200
    47.735    -0.869     0.200
    47.868    -0.226     0.200
    47.865    -1.279     0.200
    47.947     1.354     0.200
    47.965     0.275     0.200
    47.997     0.226     0.200
    47.997     1.976     0.200
    48.025    -0.972     0.200
    48.122     0.040     0.200
    48.214    -0.340     0.200
    48.489    -0.522     0.200
    48.737     0.233     0.200
    49.035    -0.929     0.200
    48.966     0.133     0.200
    49.158    -1.559     0.200
    49.082     0.077     0.200
    49.113     0.220     0.200
    49.113     0.679     0.200
    49.163     0.684     0.200
    49.264    -0.581     0.200
    49.256     0.397     0.200
    49.255     0.464     0.200
    49.292     0.481     0.200
    49.544     0.494     0.200
    49.829    -0.174     0.200
    49.829     0.236     0.200
    50.040     0.329     0.200
    50.223    -0.367     0.200
    50.223    -0.294     0.200
    50.223    -0.069     0.200
    50.227    -0.398     0.200
    50.351    -1.636     0.200
    50.426     0.060     0.200
    50.439    -0.028     0.200
    50.622     0.381     0.200
    50.788     0.014     0.200
    51.105    -0.498     0.200
    51.105     0.582     0.200
    51.218     0.727     0.200
    51.256     0.338     0.200
    51.256    -0.352     0.200
    51.393     0.196     0.200
    51.393     0.911     0.200
    51.393     1.210     0.200
    51.370    -0.108     0.200
    51.391     0.645     0.200
    51.395    -0.342     0.200
    51.395     0.706     0.200
    51.398     0.058     0.200
    51.398    -0.413     0.200
    51.453     0.537     0.200
    51.546     0.093     0.200
    51.554    -0.094     0.200
    51.584     0.022     0.200
    51.629    -0.344     0.200
    51.733    -1.169     0.200
    51.822     0.002     0.200
    51.916     0.330     0.200
    52.055     0.255     0.200
    52.147     0.412     0.200
    52.104     0.369     0.200
    52.104    -0.551     0.200
    52.286     0.267     0.200
    52.436    -0.068     0.200
    52.491     0.211     0.200
    52.552    -0.059     0.200
    52.617     0.439     0.200
    52.766     0.327     0.200
    52.807     0.432     0.200
    52.840     0.478     0.200
    52.840     0.342     0.200
    52.882     0.479     0.200
    52.898     0.040     0.200
    52.898    -0.257     0.200
    53.046    -0.570     0.200
    53.184    -0.125     0.200
    53.184    -0.016     0.200
    53.223     0.378     0.200
    53.230    -0.005     0.200
    53.240     0.598     0.200
    53.240    -0.191     0.200
    53.292    -0.010     0.200
    53.354    -0.023     0.200
    53.431    -0.131     0.200
    53.600    -0.601     0.200
    53.855    -0.108     0.200
    53.884    -0.229     0.200
    53.896     0.010     0.200
    53.891     0.096     0.200
    53.905    -0.067     0.200
    53.933    -0.182     0.200
    53.952    -0.296     0.200
    54.012    -0.224     0.200
    54.014    -0.781     0.200
    54.075     0.232     0.200
    54.188    -0.918     0.200
    54.312    -0.837     0.200
    54.312    -0.837     0.200
    54.368     0.010     0.200
    54.373     0.212     0.200
    54.376     0.347     0.200
    54.470    -0.147     0.200
    54.503    -0.227     0.200
    54.734    -0.507     0.200
    55.028    -0.676     0.200
    55.043     0.298     0.200
    55.082    -0.926     0.200
    55.292    -0.873     0.200
    55.381    -0.520     0.200
    55.703    -0.482     0.200
    55.698    -0.887     0.200
    55.757    -0.084     0.200
    55.914    -0.203     0.200
    55.914    -0.557     0.200
    56.078     0.494     0.200
    56.152     0.671     0.200
    56.152    -0.300     0.200
    56.375     0.208     0.200
    56.708    -0.964     0.200
    56.769     0.075     0.200
    56.786    -0.858     0.200
    56.786    -1.819     0.200
    56.963    -0.385     0.200
    57.395     0.346     0.200
    57.752    -1.529     0.200
    57.921     0.355     0.200
    58.120     0.342     0.200
    58.281    -0.067     0.200
    58.433     0.109     0.200
    58.488     0.517     0.200
    58.507    -0.426     0.200
    58.507    -0.186     0.200
    58.618     0.016     0.200
    58.731    -0.946     0.200
    58.815    -0.116     0.200
    58.921    -0.816     0.200
    58.921    -1.806     0.200
    58.976     0.314     0.200
    59.932     0.156     0.200
    59.932     0.277     0.200
    59.946    -0.353     0.200
    61.197     0.088     0.200
    61.182    -0.161     0.200
    62.034     0.372     0.200
    62.443    -0.684     0.200
    62.443    -0.397     0.200
    62.472     0.046     0.200
    62.533     0.062     0.200
    62.770    -0.490     0.200
    63.193    -1.021     0.200
    65.004     0.174     0.200
    66.407    -0.046     0.200
    66.407     1.365     0.200
    66.851     1.510     0.200
    67.422     1.110     0.200
    67.590    -0.441     0.200
    67.590     0.284     0.200
    67.914     0.204     0.200
    69.879     0.130     0.200
    71.001     0.677     0.200
    71.171     0.426     0.200
    71.778    -0.516     0.200
    71.778    -0.067     0.200
    71.780     0.044     0.200
    71.780    -0.075     0.200
    73.644    -0.062     0.200
    73.863    -0.059     0.200
    74.004    -0.261     0.200
    74.004    -0.888     0.200
    74.034    -0.238     0.200
    75.647    -1.075     0.200
    75.647    -0.364     0.200
    75.767     0.646     0.200
    75.997     0.039     0.200
    76.388     0.803     0.200
    78.152    -1.254     0.200
    78.441    -0.852     0.200
    78.441    -0.577     0.200
    78.441     0.493     0.200
    78.386     0.167     0.200
    78.386    -0.263     0.200
    78.386    -0.003     0.200
    78.735    -0.792     0.200
    78.735    -0.743     0.200
    78.735    -0.593     0.200
    78.748    -0.868     0.200
    78.917    -0.696     0.200
    81.476    -0.335     0.200
    82.043    -0.011     0.200
    82.043     0.480     0.200
    82.043    -0.899     0.200
    82.043     0.220     0.200
    82.043     0.681     0.200
    82.602     0.423     0.200
    82.602     1.278     0.200
    82.602     0.948     0.200
    82.602     0.099     0.200
    83.046    -0.666     0.200
    85.284    -0.125     0.200
    86.071    -1.203     0.200
    87.033    -0.120     0.200
    87.159    -1.176     0.200
    87.159    -1.128     0.200
    88.414     0.003     0.200
    88.523     0.053     0.200
    19.835    -0.131     0.200
    19.928    -0.689     0.200
    23.008     0.513     0.200
    23.173    -0.372     0.200
    23.173    -0.601     0.200
    23.618    -1.646     0.200
    23.618    -0.410     0.200
    24.582     1.811     0.200
    36.782    -1.240     0.200
    41.387    -1.398     0.200
    45.663    -0.323     0.200
    45.664    -0.140     0.200
    46.375    -0.668     0.200
    51.365    -0.623     0.200
    52.648    -1.356     0.200
    55.964    -0.141     0.200
    58.073    -0.624     0.200
    73.643    -0.669     0.200
    73.643    -0.939     0.200
    73.644    -0.428     0.200
    75.850    -0.912     0.200
    20.533     1.969     0.200
    36.707     0.727     0.200
    47.068    -0.191     0.200
    50.007    -0.455     0.200
    72.003    -1.144     0.200
    74.231    -0.729     0.200
    20.494    -0.539     0.200
    20.773    -0.466     0.200
    24.049    -0.965     0.200
    26.874     1.320     0.200
    36.716    -0.325     0.200
    40.102    -0.258     0.200
    43.043     0.440     0.200
    43.207    -0.257     0.200
    49.869    -0.264     0.200
    52.653    -0.887     0.200
    72.189    -0.878     0.200
    74.414    -1.161     0.200
    78.602    -1.434     0.200
    14.632     7.564     0.200
    19.296    -0.330     0.200
    19.840    -0.908     0.200
    19.840     0.001     0.200
    19.933    -0.703     0.200
    21.630    -0.393     0.200
    21.986    -0.721     0.200
    22.199    -0.820     0.200
    22.199    -1.750     0.200
    22.217    -0.811     0.200
    23.024    -0.177     0.200
    23.024    -0.177     0.200
    23.207     0.412     0.200
    23.207     0.183     0.200
    23.614    -0.740     0.200
    23.614    -1.249     0.200
    25.003    -1.433     0.200
    24.923     0.188     0.200
    24.923     0.412     0.200
    27.281     0.465     0.200
    27.289     1.513     0.200
    27.292     1.283     0.200
    28.656     1.474     0.200
    28.922     1.437     0.200
    29.256    -0.680     0.200
    29.256     0.476     0.200
    30.929    -0.245     0.200
    30.929    -0.120     0.200
    31.128     0.024     0.200
    33.103     1.667     0.200
    33.643     1.512     0.200
    35.325     0.779     0.200
    36.760    -0.702     0.200
    37.404    -0.038     0.200
    37.405     0.117     0.200
    37.405     0.247     0.200
    37.405     0.147     0.200
    37.405     0.017     0.200
    37.492     0.313     0.200
    37.974     0.821     0.200
    38.339     0.226     0.200
    38.339     0.495     0.200
    38.965     0.057     0.200
    38.965     0.406     0.200
    39.142    -0.403     0.200
    40.812    -1.006     0.200
    41.034     0.036     0.200
    41.431    -0.690     0.200
    41.431    -0.150     0.200
    41.431    -1.140     0.200
    41.440    -1.213     0.200
    41.440    -0.743     0.200
    41.651    -1.088     0.200
    42.088     1.685     0.200
    42.246    -1.107     0.200
    42.601     1.008     0.200
    42.655     0.896     0.200
    42.871    -0.099     0.200
    42.947    -1.404     0.200
    43.138     1.408     0.200
    43.138     1.156     0.200
    43.597    -0.949     0.200
    43.715    -0.201     0.200
    43.728     0.293     0.200
    44.113     0.042     0.200
    44.061     0.210     0.200
    44.061     0.103     0.200
    44.533    -0.152     0.200
    44.669     0.272     0.200
    44.669     0.493     0.200
    45.121     0.497     0.200
    45.168     0.327     0.200
    45.367    -0.013     0.200
    45.402     0.214     0.200
    45.480     0.441     0.200
    45.472     0.644     0.200
    45.536     0.174     0.200
    45.694     0.110     0.200
    45.697    -0.115     0.200
    45.815     0.066     0.200
    45.819     0.705     0.200
    46.081    -0.855     0.200
    46.040    -1.673     0.200
    46.078     0.431     0.200
    46.147     0.456     0.200
    46.142     0.356     0.200
    46.179     0.268     0.200
    47.042     1.142     0.200
    47.310     0.129     0.200
    47.381    -0.591     0.200
    47.484    -0.045     0.200
    47.862    -2.072     0.200
    48.226     0.045     0.200
    48.427     0.556     0.200
    48.810     0.546     0.200
    48.810     0.091     0.200
    48.835     0.402     0.200
    48.948    -0.605     0.200
    48.991     0.176     0.200
    49.338     0.353     0.200
    49.321    -0.002     0.200
    49.321    -0.191     0.200
    49.354     0.259     0.200
    49.610     0.403     0.200
    49.610     0.103     0.200
    49.674     0.509     0.200
    49.776     1.653     0.200
    49.776     0.044     0.200
    49.805    -0.078     0.200
    49.920    -1.504     0.200
    50.018    -0.185     0.200
    50.188     0.028     0.200
    50.240    -0.759     0.200
    50.486     1.125     0.200
    50.450    -2.269     0.200
    50.437     0.946     0.200
    50.437     0.776     0.200
    50.535     0.485     0.200
    50.731     1.845     0.200
    50.768     0.297     0.200
    50.989    -1.064     0.200
    50.999     0.922     0.200
    51.004     0.220     0.200
    50.974    -0.374     0.200
    51.021    -0.313     0.200
    51.105     0.170     0.200
    51.097    -0.264     0.200
    51.401    -0.556     0.200
    51.390    -0.532     0.200
    51.390    -0.427     0.200
    51.689    -0.414     0.200
    51.712    -0.397     0.200
    51.836    -0.632     0.200
    51.742    -0.237     0.200
    51.742     0.759     0.200
    51.869     0.147     0.200
    51.907    -0.011     0.200
    52.041     0.250     0.200
    52.070    -0.055     0.200
    52.359    -0.439     0.200
    52.394     0.006     0.200
    52.417     0.329     0.200
    52.432     0.530     0.200
    52.502    -0.669     0.200
    52.536     0.699     0.200
    52.620    -0.693     0.200
    52.628     0.028     0.200
    52.683    -0.574     0.200
    52.683    -0.599     0.200
    52.778    -0.463     0.200
    53.172    -0.801     0.200
    53.196     0.473     0.200
    53.517     0.329     0.200
    53.756     0.801     0.200
    53.949    -0.232     0.200
    54.111    -0.507     0.200
    54.477     1.119     0.200
    54.897    -1.617     0.200
    55.158    -0.547     0.200
    56.299    -0.277     0.200
    56.460    -0.572     0.200
    56.614     0.190     0.200
    56.680    -0.099     0.200
    56.914    -1.226     0.200
    56.984    -0.173     0.200
    57.157     0.181     0.200
    58.120    -0.498     0.200
    59.768    -1.298     0.200
    60.215    -0.575     0.200
    60.533    -0.149     0.200
    60.736    -0.738     0.200
    61.318    -0.804     0.200
    61.934    -0.769     0.200
    62.324    -0.496     0.200
    62.992     2.358     0.200
    65.026     0.234     0.200
    65.763    -0.472     0.200
    66.087    -0.106     0.200
    66.752    -0.520     0.200
    68.921    -0.356     0.200
    73.595    -0.699     0.200
    75.119    -0.871     0.200
    75.804    -0.903     0.200
    76.887    -0.142     0.200
    77.866    -0.483     0.200
    78.075     0.189     0.200
    78.394    -0.171     0.200
    78.415    -1.225     0.200
    79.498    -0.429     0.200
    79.780    -1.339     0.200
    86.473    -0.026     0.200
    15.105     6.227     0.200
    20.502     0.108     0.200
    20.502    -1.411     0.200
    20.523     0.488     0.200
    20.616    -0.820     0.200
    20.726     0.685     0.200
    20.730    -0.660     0.200
    20.819    -1.809     0.200
    23.318    -0.390     0.200
    24.254    -0.429     0.200
    24.254    -1.174     0.200
    24.713    -1.689     0.200
    24.713    -0.259     0.200
    26.925     1.293     0.200
    30.350     2.040     0.200
    36.836     0.019     0.200
    39.697    -0.516     0.200
    40.026    -0.544     0.200
    43.019     0.025     0.200
    43.082     0.041     0.200
    44.828     0.254     0.200
    47.199     0.485     0.200
    47.199    -0.035     0.200
    50.148     0.273     0.200
    50.148     0.503     0.200
    67.458    -0.457     0.200
    71.907    -0.454     0.200
    71.907    -1.398     0.200
    74.029    -0.868     0.200
    74.129    -0.532     0.200
    74.184     0.194     0.200
    76.518    -0.188     0.200
    77.303    -0.029     0.200
    77.624     0.313     0.200
    78.217     0.724     0.200
    78.351     0.624     0.200
    80.875    -0.135     0.200
    84.494    -0.352     0.200
    84.653    -0.276     0.200
    20.651    -1.105     0.200
    24.115     0.120     0.200
    24.180    -0.965     0.200
    71.976    -2.060     0.200
    20.089    -1.048     0.200
    23.687    -0.798     0.200
    23.776    -0.353     0.200
    23.776    -1.560     0.200
    27.108     1.549     0.200
    32.368    -1.011     0.200
    36.734    -0.274     0.200
    46.178     0.030     0.200
    46.178    -0.550     0.200
    49.229     0.459     0.200
    49.229     0.148     0.200
    51.898    -0.234     0.200
    53.175    -1.354     0.200
    53.175    -1.049     0.200
    73.035    -0.887     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   103.803     0.421     0.200
   109.121     3.278     0.200
   109.239     1.055     0.200
   109.458     1.278     0.200
   115.665     2.685     0.200
   101.104     4.771     0.200
   102.939     4.133     0.200
   100.508    -0.552     0.200
   102.422     0.439     0.200
   100.039    -0.485     0.200
   100.671     0.810     0.200
    99.677     0.134     0.200
    99.969    -0.168     0.200
   100.058    -1.563     0.200
   100.058    -0.962     0.200
   100.190     1.850     0.200
   100.261    -0.861     0.200
   102.161     1.660     0.200
   102.360     0.111     0.200
   103.106     0.285     0.200
   103.546     3.434     0.200
   104.742     3.825     0.200
   105.101     2.517     0.200
   105.442    -0.201     0.200
   105.442     0.002     0.200
   105.758    -1.904     0.200
   107.043     1.886     0.200
   107.555     5.109     0.200
   109.798     1.137     0.200
   109.908     2.946     0.200
   110.916     1.099     0.200
   111.971     2.469     0.200
   113.492     3.238     0.200
   113.492     2.317     0.200
   114.464     0.894     0.200
   114.467     0.879     0.200
   100.096     0.428     0.200
   100.772    -0.179     0.200
   100.131     0.715     0.200
   100.446     0.064     0.200
   103.325     0.181     0.200
   107.586     2.183     0.200
   104.825     3.077     0.200
   110.374    -4.092     0.200
   107.293     1.091     0.200
   109.946     2.216     0.200
   102.042    -0.948     0.200
   101.380    -0.608     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    42.720   109.393     0.200
    47.704    89.823     0.200
    49.163    81.579     0.200
    72.571    18.333     0.200
    98.159    -0.459     0.200
    44.430   104.062     0.200
    51.876    74.508     0.200
    52.717    64.261     0.200
    53.786    64.394     0.200
    53.845    62.966     0.200
    54.820    59.866     0.200
    57.563    50.264     0.200
    60.871    40.366     0.200
    70.758    21.641     0.200
    78.590    12.214     0.200
    98.007    -0.119     0.200
    99.181     1.326     0.200
    70.840    14.924     0.200
    71.537    19.705     0.200
    70.763    15.622     0.200
    71.900    15.746     0.200
    71.908    15.702     0.200
    72.505    23.630     0.200
    98.214     0.680     0.200
    54.570    62.989     0.200
    49.192    80.219     0.200
    78.722     5.044     0.200
    13.902   325.007     0.200
    13.069   330.954     0.200
    14.163   323.530     0.200
    26.937   201.969     0.200
    28.443   192.489     0.200
    32.085   169.797     0.200
    34.187   157.948     0.200
    34.647   154.357     0.200
    38.809   129.518     0.200
    39.217   128.099     0.200
    48.767    82.968     0.200
    51.147    75.098     0.200
    51.296    74.777     0.200
    55.074    58.462     0.200
    27.089   197.213     0.200
    39.082   133.821     0.200
    43.067   108.023     0.200
    43.537   109.723     0.200
    46.732    97.832     0.200
    48.876    81.210     0.200
    51.847    69.725     0.200
    51.847    69.225     0.200
    57.295    53.952     0.200
    97.606     1.402     0.200
    98.489     1.435     0.200
    98.594     0.964     0.200
    98.616    -0.136     0.200
    98.785     2.110     0.200
    99.061     3.078     0.200
    36.703   141.858     0.200
    46.058    95.625     0.200
    48.910    82.860     0.200
    51.848    74.442     0.200
    75.341    13.464     0.200
    35.127   149.053     0.200
    35.339   150.430     0.200
    47.378    89.024     0.200
    50.351    82.305     0.200
    52.673    71.925     0.200
    73.377    14.404     0.200
     9.451   378.665     0.200
    12.891   335.808     0.200
    21.339   249.283     0.200
    21.339   249.182     0.200
    28.248   188.840     0.200
    38.703   131.010     0.200
    43.268   111.407     0.200
    43.824   106.927     0.200
    45.189   101.019     0.200
    46.304    92.505     0.200
    47.431    90.997     0.200
    51.509    71.170     0.200
    55.675    56.735     0.200
    55.675    57.228     0.200
    59.000    46.252     0.200
    62.997    32.503     0.200
    64.338    30.055     0.200
    65.308    29.643     0.200
    65.836    29.629     0.200
    66.192    30.734     0.200
    66.206    28.247     0.200
    66.224    26.532     0.200
    66.330    30.647     0.200
    66.534    30.340     0.200
    67.381    30.555     0.200
    67.551    31.185     0.200
    67.801    30.903     0.200
    68.146    31.132     0.200
    68.961    30.643     0.200
    97.266     2.997     0.200
    75.023    13.562     0.200
    46.410    97.974     0.200
    38.791   130.235     0.200
    21.368   244.518     0.200
    26.812   200.742     0.200
    31.362   175.099     0.200
    31.370   174.531     0.200
    14.908   308.073     0.200
    21.391   244.370     0.200
    21.386   244.195     0.200
    36.808   142.567     0.200
    36.744   142.997     0.200
    12.947   331.686     0.200
    20.713   250.144     0.200
    41.343   115.884     0.200
    36.187   143.323     0.200
    32.688   169.974     0.200
    24.496   218.442     0.200
    26.791   202.193     0.200
    14.896   310.989     0.200
    19.040   265.209     0.200
    27.058   200.627     0.200
    46.370    95.458     0.200
    52.025    71.725     0.200
    26.504   204.246     0.200
    27.293   201.487     0.200
    30.288   179.145     0.200
    60.794    42.554     0.200
    27.279   198.002     0.200
    26.949   201.064     0.200
    30.567   177.885     0.200
    32.775   169.057     0.200
    39.881   127.865     0.200
    25.280   216.225     0.200
    26.005   211.958     0.200
    27.319   199.433     0.200
    28.594   191.514     0.200
    28.991   185.588     0.200
    38.070   136.493     0.200
    39.280   130.537     0.200
    41.081   118.126     0.200
    45.980    95.328     0.200
    46.632    91.396     0.200
    61.047    42.970     0.200
    20.578   251.268     0.200
    23.457   227.709     0.200
    26.617   204.223     0.200
    27.400   200.219     0.200
    32.711   165.608     0.200
    39.806   125.821     0.200
    41.056   119.424     0.200
    60.904    46.219     0.200
    27.879   198.614     0.200
    49.942    79.056     0.200
    20.684   250.682     0.200
    61.181    42.557     0.200
    14.783   312.421     0.200
    15.090   308.907     0.200
    20.153   253.919     0.200
    20.320   254.448     0.200
    20.355   253.770     0.200
    20.792   249.174     0.200
    20.881   248.229     0.200
    24.294   220.019     0.200
    26.847   202.129     0.200
    26.847   202.129     0.200
    26.858   202.497     0.200
    39.883   125.631     0.200
    39.888   125.420     0.200
    39.883   125.630     0.200
    40.068   124.641     0.200
    45.219    97.805     0.200
    47.576    88.899     0.200
    48.192    86.673     0.200
    48.194    86.659     0.200
    48.261    86.691     0.200
    52.874    66.654     0.200
    53.230    68.233     0.200
    53.230    68.225     0.200
    20.172   253.895     0.200
    20.333   253.703     0.200
    26.865   201.220     0.200
    38.311   135.000     0.200
    40.063   124.578     0.200
    15.098   310.429     0.200
    20.149   253.192     0.200
    20.310   253.336     0.200
    23.355   228.194     0.200
    24.305   220.054     0.200
    26.851   202.296     0.200
    28.463   192.254     0.200
    39.882   125.539     0.200
    39.882   125.538     0.200
    43.123   106.474     0.200
    53.505    67.633     0.200
    61.215    43.256     0.200
    15.159   304.216     0.200
    20.991   247.039     0.200
    21.078   246.074     0.200
    23.064   231.175     0.200
    26.794   202.564     0.200
    31.895   170.351     0.200
    39.697   127.830     0.200
    39.689   125.940     0.200
    39.695   125.782     0.200
    39.689   125.940     0.200
    40.059   123.570     0.200
    45.113    98.101     0.200
    45.251    98.208     0.200
    48.000    87.940     0.200
    30.302   178.770     0.200
    40.728   118.294     0.200
    60.823    41.541     0.200
    24.353   220.814     0.200
    38.923   130.162     0.200
    22.488   234.767     0.200
    27.279   199.191     0.200
    27.279   199.191     0.200
    28.954   188.255     0.200
    34.231   156.368     0.200
    54.234    63.752     0.200
    33.091   164.468     0.200
    40.132   124.471     0.200
    61.025    44.443     0.200
    27.296   199.069     0.200
    27.296   199.073     0.200
    38.051   137.960     0.200
    61.020    43.091     0.200
    27.957   199.327     0.200
    43.820   104.862     0.200
    20.284   254.181     0.200
    26.710   202.848     0.200
    27.325   199.239     0.200
    44.746    97.576     0.200
    44.746   101.678     0.200
    45.109    97.852     0.200
    58.588    48.010     0.200
    58.804    47.960     0.200
    29.260   186.651     0.200
    31.512   173.454     0.200
    32.037   175.040     0.200
    33.137   163.700     0.200
    42.052   113.789     0.200
    50.889    76.534     0.200
    51.591    75.066     0.200
    51.940    73.157     0.200
    52.159    71.027     0.200
    61.054    46.258     0.200
    97.065     0.999     0.200
    21.668   241.718     0.200
    27.027   201.391     0.200
    37.042   141.139     0.200
    41.914   114.217     0.200
    43.408   105.680     0.200
    51.887    71.572     0.200
    53.100    67.760     0.200
    54.745    62.071     0.200
    44.510   102.583     0.200
    26.848   202.516     0.200
    26.848   201.606     0.200
    44.709   102.897     0.200
    45.234   100.634     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
