#!/bin/bash
gmt begin chamoli16.22_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times chamoli16.22'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.704
    25.500   328.247
    26.000   332.779
    26.500   337.299
    27.000   341.807
    27.500   346.299
    28.000   350.771
    28.500   355.227
    29.000   359.672
    29.500   364.108
    30.000   368.537
    30.500   372.958
    31.000   377.371
    31.500   381.776
    32.000   386.173
    32.500   390.561
    33.000   394.938
    33.500   399.302
    34.000   403.652
    34.500   407.988
    35.000   412.308
    35.500   416.613
    36.000   420.904
    36.500   425.178
    37.000   429.438
    37.500   433.682
    38.000   437.910
    38.500   442.121
    39.000   446.316
    39.500   450.495
    40.000   454.656
    40.500   458.800
    41.000   462.927
    41.500   467.037
    42.000   471.130
    42.500   475.206
    43.000   479.264
    43.500   483.305
    44.000   487.328
    44.500   491.333
    45.000   495.320
    45.500   499.290
    46.000   503.241
    46.500   507.175
    47.000   511.090
    47.500   514.987
    48.000   518.867
    48.500   522.728
    49.000   526.571
    49.500   530.395
    50.000   534.202
    50.500   537.990
    51.000   541.760
    51.500   545.511
    52.000   549.245
    52.500   552.960
    53.000   556.658
    53.500   560.338
    54.000   564.000
    54.500   567.644
    55.000   571.269
    55.500   574.875
    56.000   578.464
    56.500   582.033
    57.000   585.585
    57.500   589.118
    58.000   592.633
    58.500   596.130
    59.000   599.609
    59.500   603.070
    60.000   606.512
    60.500   609.936
    61.000   613.341
    61.500   616.728
    62.000   620.097
    62.500   623.448
    63.000   626.781
    63.500   630.096
    64.000   633.393
    64.500   636.672
    65.000   639.933
    65.500   643.176
    66.000   646.401
    66.500   649.609
    67.000   652.798
    67.500   655.969
    68.000   659.121
    68.500   662.256
    69.000   665.372
    69.500   668.471
    70.000   671.551
    70.500   674.613
    71.000   677.657
    71.500   680.683
    72.000   683.690
    72.500   686.680
    73.000   689.651
    73.500   692.603
    74.000   695.537
    74.500   698.452
    75.000   701.348
    75.500   704.226
    76.000   707.085
    76.500   709.927
    77.000   712.750
    77.500   715.555
    78.000   718.342
    78.500   721.111
    79.000   723.862
    79.500   726.594
    80.000   729.307
    80.500   732.002
    81.000   734.677
    81.500   737.333
    82.000   739.970
    82.500   742.588
    83.000   745.188
    83.500   747.768
    84.000   750.329
    84.500   752.870
    85.000   755.390
    85.500   757.890
    86.000   760.372
    86.500   762.836
    87.000   765.282
    87.500   767.705
    88.000   770.094
    88.500   772.460
    89.000   774.815
    89.500   777.160
    90.000   779.498
    90.500   781.829
    91.000   784.154
    91.500   786.473
    92.000   788.788
    92.500   791.099
    93.000   793.406
    93.500   795.710
    94.000   798.010
    94.500   800.306
    95.000   802.596
    95.500   804.880
    96.000   807.158
    96.500   809.430
    97.000   811.695
    97.500   813.954
    98.000   816.205
    98.500   818.449
    99.000   820.686
    99.500   822.914
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.926
   116.000  1122.888
   116.500  1123.850
   117.000  1124.812
   117.500  1125.774
   118.000  1126.736
   118.500  1127.698
   119.000  1128.660
   119.500  1129.621
   120.000  1130.582
   120.500  1131.543
   121.000  1132.504
   121.500  1133.465
   122.000  1134.425
   122.500  1135.385
   123.000  1136.344
   123.500  1137.303
   124.000  1138.262
   124.500  1139.220
   125.000  1140.178
   125.500  1141.135
   126.000  1142.092
   126.500  1143.047
   127.000  1144.003
   127.500  1144.957
   128.000  1145.911
   128.500  1146.864
   129.000  1147.815
   129.500  1148.766
   130.000  1149.716
   130.500  1150.665
   131.000  1151.613
   131.500  1152.559
   132.000  1153.504
   132.500  1154.448
   133.000  1155.390
   133.500  1156.330
   134.000  1157.269
   134.500  1158.206
   135.000  1159.142
   135.500  1160.075
   136.000  1161.006
   136.500  1161.935
   137.000  1162.861
   137.500  1163.785
   138.000  1164.707
   138.500  1165.625
   139.000  1166.541
   139.500  1167.454
   140.000  1168.363
   140.500  1169.269
   141.000  1170.172
   141.500  1171.070
   142.000  1171.965
   142.500  1172.855
   143.000  1173.741
   143.500  1174.623
   144.000  1175.499
   144.500  1176.370
   145.000  1177.236
   145.500  1178.096
   146.000  1178.950
   146.500  1179.797
   147.000  1180.638
   147.500  1181.472
   148.000  1182.299
   148.500  1183.119
   149.000  1183.930
   149.500  1184.733
   150.000  1185.526
   150.500  1186.310
   151.000  1187.083
   151.500  1187.846
   152.000  1188.600
   152.500  1189.343
   153.000  1190.077
   153.500  1190.800
   154.000  1191.512
   154.500  1192.214
   155.000  1192.904
   155.500  1193.583
   156.000  1194.250
   156.500  1194.906
   157.000  1195.549
   157.500  1196.181
   158.000  1196.800
   158.500  1197.406
   159.000  1198.001
   159.500  1198.582
   160.000  1199.151
   160.500  1199.706
   161.000  1200.248
   161.500  1200.778
   162.000  1201.294
   162.500  1201.797
   163.000  1202.286
   163.500  1202.762
   164.000  1203.225
   164.500  1203.673
   165.000  1204.108
   165.500  1204.528
   166.000  1204.935
   166.500  1205.328
   167.000  1205.707
   167.500  1206.073
   168.000  1206.424
   168.500  1206.761
   169.000  1207.083
   169.500  1207.392
   170.000  1207.687
   170.500  1207.967
   171.000  1208.233
   171.500  1208.485
   172.000  1208.723
   172.500  1208.946
   173.000  1209.155
   173.500  1209.349
   174.000  1209.530
   174.500  1209.695
   175.000  1209.847
   175.500  1209.984
   176.000  1210.107
   176.500  1210.215
   177.000  1210.309
   177.500  1210.388
   178.000  1210.453
   178.500  1210.504
   179.000  1210.540
   179.500  1210.561
   180.000  1210.569
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.867
     1.000   992.876
     1.500   992.890
     2.000   992.909
     2.500   992.934
     3.000   992.965
     3.500   993.001
     4.000   993.043
     4.500   993.091
     5.000   993.144
     5.500   993.203
     6.000   993.267
     6.500   993.337
     7.000   993.412
     7.500   993.493
     8.000   993.580
     8.500   993.672
     9.000   993.770
     9.500   993.873
    10.000   993.982
    10.500   994.097
    11.000   994.217
    11.500   994.342
    12.000   994.473
    12.500   994.610
    13.000   994.752
    13.500   994.900
    14.000   995.053
    14.500   995.212
    15.000   995.376
    15.500   995.546
    16.000   995.721
    16.500   995.902
    17.000   996.088
    17.500   996.280
    18.000   996.477
    18.500   996.680
    19.000   996.888
    19.500   997.102
    20.000   997.321
    20.500   997.545
    21.000   997.775
    21.500   998.011
    22.000   998.251
    22.500   998.497
    23.000   998.749
    23.500   999.006
    24.000   999.269
    24.500   999.536
    25.000   999.809
    25.500  1000.088
    26.000  1000.372
    26.500  1000.661
    27.000  1000.955
    27.500  1001.255
    28.000  1001.560
    28.500  1001.871
    29.000  1002.186
    29.500  1002.507
    30.000  1002.834
    30.500  1003.165
    31.000  1003.502
    31.500  1003.844
    32.000  1004.191
    32.500  1004.543
    33.000  1004.901
    33.500  1005.264
    34.000  1005.632
    34.500  1006.005
    35.000  1006.383
    35.500  1006.766
    36.000  1007.155
    36.500  1007.548
    37.000  1007.947
    37.500  1008.351
    38.000  1008.760
    38.500  1009.174
    39.000  1009.593
    39.500  1010.017
    40.000  1010.446
    40.500  1010.880
    41.000  1011.319
    41.500  1011.763
    42.000  1012.212
    42.500  1012.665
    43.000  1013.124
    43.500  1013.588
    44.000  1014.056
    44.500  1014.530
    45.000  1015.008
    45.500  1015.491
    46.000  1015.979
    46.500  1016.472
    47.000  1016.970
    47.500  1017.472
    48.000  1017.979
    48.500  1018.491
    49.000  1019.008
    49.500  1019.529
    50.000  1020.055
    50.500  1020.586
    51.000  1021.122
    51.500  1021.662
    52.000  1022.206
    52.500  1022.756
    53.000  1023.310
    53.500  1023.868
    54.000  1024.431
    54.500  1024.999
    55.000  1025.571
    55.500  1026.148
    56.000  1026.729
    56.500  1027.314
    57.000  1027.905
    57.500  1028.499
    58.000  1029.098
    58.500  1029.701
    59.000  1030.309
    59.500  1030.921
    60.000  1031.537
    60.500  1032.158
    61.000  1032.783
    61.500  1033.413
    62.000  1034.046
    62.500  1034.684
    63.000  1035.326
    63.500  1035.972
    64.000  1036.623
    64.500  1037.277
    65.000  1037.936
    65.500  1038.599
    66.000  1039.266
    66.500  1039.937
    67.000  1040.612
    67.500  1041.291
    68.000  1041.974
    68.500  1042.661
    69.000  1043.353
    69.500  1044.048
    70.000  1044.747
    70.500  1045.450
    71.000  1046.157
    71.500  1046.867
    72.000  1047.582
    72.500  1048.300
    73.000  1049.023
    73.500  1049.749
    74.000  1050.478
    74.500  1051.212
    75.000  1051.949
    75.500  1052.690
    76.000  1053.435
    76.500  1054.183
    77.000  1054.935
    77.500  1055.690
    78.000  1056.449
    78.500  1057.212
    79.000  1057.978
    79.500  1058.748
    80.000  1059.521
    80.500  1060.298
    81.000  1061.078
    81.500  1061.862
    82.000  1062.649
    82.500  1063.439
    83.000  1064.233
    83.500  1065.030
    84.000  1065.831
    84.500  1066.634
    85.000  1067.441
    85.500  1068.252
    86.000  1069.065
    86.500  1069.882
    87.000  1070.702
    87.500  1071.525
    88.000  1072.351
    88.500  1073.180
    89.000  1074.013
    89.500  1074.848
    90.000  1075.687
    90.500  1076.528
    91.000  1077.372
    91.500  1078.220
    92.000  1079.070
    92.500  1079.924
    93.000  1080.780
    93.500  1081.639
    94.000  1082.501
    94.500  1083.366
    95.000  1084.233
    95.500  1085.104
    96.000  1085.977
    96.500  1086.853
    97.000  1087.731
    97.500  1088.613
    98.000  1089.497
    98.500  1090.383
    99.000  1091.272
    99.500  1092.164
   100.000  1093.059
   100.500  1093.955
   101.000  1094.855
   101.500  1095.757
   102.000  1096.661
   102.500  1097.568
   103.000  1098.477
   103.500  1099.389
   104.000  1100.303
   104.500  1101.219
   105.000  1102.138
   105.500  1103.059
   106.000  1103.983
   106.500  1104.908
   107.000  1105.836
   107.500  1106.766
   108.000  1107.698
   108.500  1108.632
   109.000  1109.569
   109.500  1110.507
   110.000  1111.448
   110.500  1112.391
   111.000  1113.336
   111.500  1114.282
   112.000  1115.231
   112.500  1116.182
   113.000  1117.135
   113.500  1118.089
   114.000  1119.046
   114.500  1120.004
   115.000  1120.964
   115.500  1121.926
   116.000  1122.890
   116.500  1123.856
   117.000  1124.823
   117.500  1125.792
   118.000  1126.763
   118.500  1127.735
   119.000  1128.709
   119.500  1129.685
   120.000  1130.662
   120.500  1131.641
   121.000  1132.622
   121.500  1133.604
   122.000  1134.587
   122.500  1135.572
   123.000  1136.559
   123.500  1137.547
   124.000  1138.536
   124.500  1139.527
   125.000  1140.519
   125.500  1141.512
   126.000  1142.507
   126.500  1143.503
   127.000  1144.500
   127.500  1145.499
   128.000  1146.499
   128.500  1147.500
   129.000  1148.502
   129.500  1149.505
   130.000  1150.510
   130.500  1151.515
   131.000  1152.522
   131.500  1153.530
   132.000  1154.538
   132.500  1155.548
   133.000  1156.559
   133.500  1157.571
   134.000  1158.583
   134.500  1159.597
   135.000  1160.612
   135.500  1161.627
   136.000  1162.643
   136.500  1163.660
   137.000  1164.678
   137.500  1165.697
   138.000  1166.717
   138.500  1167.737
   139.000  1168.758
   139.500  1169.779
   140.000  1170.802
   140.500  1171.825
   141.000  1172.848
   141.500  1173.872
   142.000  1174.897
   142.500  1175.923
   143.000  1176.948
   143.500  1177.975
   144.000  1179.002
   144.500  1180.029
   145.000  1181.057
   145.500  1182.085
   146.000  1183.114
   146.500  1184.143
   147.000  1185.173
   147.500  1186.203
   148.000  1187.233
   148.500  1188.263
   149.000  1189.294
   149.500  1190.325
   150.000  1191.356
   150.500  1192.388
   151.000  1193.420
   151.500  1194.452
   152.000  1195.484
   152.500  1196.516
   153.000  1197.548
   153.500  1198.581
   154.000  1199.613
   154.500  1200.646
   155.000  1201.678
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.549
   145.500  1178.372
   146.000  1180.252
   146.500  1182.170
   147.000  1184.115
   147.500  1186.083
   148.000  1188.071
   148.500  1190.077
   149.000  1192.098
   149.500  1194.133
   150.000  1196.181
   150.500  1198.240
   151.000  1200.311
   151.500  1202.390
   152.000  1204.479
   152.500  1206.576
   153.000  1208.680
   153.500  1210.793
   154.000  1212.912
   154.500  1215.037
   155.000  1217.169
   155.500  1219.307
   156.000  1221.449
   156.500  1223.597
   157.000  1225.750
   157.500  1227.906
   158.000  1230.068
   158.500  1232.233
   159.000  1234.402
   159.500  1236.575
   160.000  1238.751
   160.500  1240.931
   161.000  1243.114
   161.500  1245.299
   162.000  1247.487
   162.500  1249.678
   163.000  1251.871
   163.500  1254.066
   164.000  1256.264
   164.500  1258.464
   165.000  1260.665
   165.500  1262.869
   166.000  1265.074
   166.500  1267.280
   167.000  1269.489
   167.500  1271.698
   168.000  1273.909
   168.500  1276.121
   169.000  1278.335
   169.500  1280.549
   170.000  1282.765
   170.500  1284.981
   171.000  1287.198
   171.500  1289.416
   172.000  1291.635
   172.500  1293.854
   173.000  1296.074
   173.500  1298.295
   174.000  1300.516
   174.500  1302.737
   175.000  1304.959
   175.500  1307.181
   176.000  1309.403
   176.500  1311.626
   177.000  1313.849
   177.500  1316.071
   178.000  1318.294
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.546
   145.500  1178.172
   146.000  1179.719
   146.500  1181.208
   147.000  1182.648
   147.500  1184.042
   148.000  1185.394
   148.500  1186.706
   149.000  1187.984
   149.500  1189.232
   150.000  1190.455
   150.500  1191.656
   151.000  1192.836
   151.500  1193.996
   152.000  1195.138
   152.500  1196.263
   153.000  1197.372
   153.500  1198.467
   154.000  1199.548
   154.500  1200.616
   155.000  1201.671
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.743
     1.000   509.779
     1.500   509.839
     2.000   509.923
     2.500   510.031
     3.000   510.163
     3.500   510.319
     4.000   510.498
     4.500   510.702
     5.000   510.930
     5.500   511.181
     6.000   511.456
     6.500   511.755
     7.000   512.077
     7.500   512.423
     8.000   512.792
     8.500   513.185
     9.000   513.601
     9.500   514.041
    10.000   514.503
    10.500   514.989
    11.000   515.498
    11.500   516.030
    12.000   516.584
    12.500   517.161
    13.000   517.761
    13.500   518.384
    14.000   519.028
    14.500   519.695
    15.000   520.384
    15.500   521.096
    16.000   521.829
    16.500   522.583
    17.000   523.360
    17.500   524.158
    18.000   524.977
    18.500   525.818
    19.000   526.679
    19.500   527.562
    20.000   528.465
    20.500   529.389
    21.000   530.333
    21.500   531.298
    22.000   532.283
    22.500   533.287
    23.000   534.312
    23.500   535.356
    24.000   536.420
    24.500   537.503
    25.000   538.605
    25.500   539.726
    26.000   540.866
    26.500   542.025
    27.000   543.202
    27.500   544.397
    28.000   545.611
    28.500   546.842
    29.000   548.091
    29.500   549.357
    30.000   550.641
    30.500   551.942
    31.000   553.261
    31.500   554.595
    32.000   555.947
    32.500   557.315
    33.000   558.699
    33.500   560.100
    34.000   561.516
    34.500   562.948
    35.000   564.395
    35.500   565.858
    36.000   567.336
    36.500   568.828
    37.000   570.336
    37.500   571.858
    38.000   573.395
    38.500   574.945
    39.000   576.510
    39.500   578.089
    40.000   579.681
    40.500   581.287
    41.000   582.906
    41.500   584.538
    42.000   586.183
    42.500   587.841
    43.000   589.511
    43.500   591.194
    44.000   592.888
    44.500   594.595
    45.000   596.314
    45.500   598.044
    46.000   599.786
    46.500   601.540
    47.000   603.304
    47.500   605.079
    48.000   606.865
    48.500   608.662
    49.000   610.469
    49.500   612.287
    50.000   614.114
    50.500   615.952
    51.000   617.799
    51.500   619.656
    52.000   621.523
    52.500   623.398
    53.000   625.283
    53.500   627.177
    54.000   629.080
    54.500   630.991
    55.000   632.911
    55.500   634.839
    56.000   636.776
    56.500   638.720
    57.000   640.673
    57.500   642.633
    58.000   644.601
    58.500   646.576
    59.000   648.559
    59.500   650.549
    60.000   652.546
    60.500   654.549
    61.000   656.560
    61.500   658.577
    62.000   660.601
    62.500   662.631
    63.000   664.667
    63.500   666.709
    64.000   668.758
    64.500   670.812
    65.000   672.872
    65.500   674.937
    66.000   677.008
    66.500   679.085
    67.000   681.166
    67.500   683.253
    68.000   685.344
    68.500   687.441
    69.000   689.542
    69.500   691.648
    70.000   693.758
    70.500   695.873
    71.000   697.992
    71.500   700.115
    72.000   702.242
    72.500   704.373
    73.000   706.508
    73.500   708.647
    74.000   710.790
    74.500   712.936
    75.000   715.085
    75.500   717.238
    76.000   719.394
    76.500   721.554
    77.000   723.716
    77.500   725.882
    78.000   728.050
    78.500   730.221
    79.000   732.395
    79.500   734.571
    80.000   736.750
    80.500   738.931
    81.000   741.115
    81.500   743.301
    82.000   745.489
    82.500   747.679
    83.000   749.872
    83.500   752.066
    84.000   754.262
    84.500   756.460
    85.000   758.660
    85.500   760.861
    86.000   763.064
    86.500   765.269
    87.000   767.475
    87.500   769.682
    88.000   771.891
    88.500   774.101
    89.000   776.312
    89.500   778.524
    90.000   780.737
    90.500   782.951
    91.000   785.167
    91.500   787.383
    92.000   789.600
    92.500   791.817
    93.000   794.036
    93.500   796.255
    94.000   798.474
    94.500   800.694
    95.000   802.915
    95.500   805.136
    96.000   807.358
    96.500   809.579
    97.000   811.802
    97.500   814.024
    98.000   816.246
    98.500   818.469
    99.000   820.692
    99.500   822.915
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.549
    29.000   425.106
    29.500   430.663
    30.000   436.219
    30.500   441.774
    31.000   447.328
    31.500   452.880
    32.000   458.430
    32.500   463.977
    33.000   469.521
    33.500   475.062
    34.000   480.600
    34.500   486.133
    35.000   491.662
    35.500   497.186
    36.000   502.704
    36.500   508.216
    37.000   513.721
    37.500   519.219
    38.000   524.710
    38.500   530.192
    39.000   535.665
    39.500   541.129
    40.000   546.583
    40.500   552.027
    41.000   557.459
    41.500   562.879
    42.000   568.288
    42.500   573.683
    43.000   579.065
    43.500   584.433
    44.000   589.787
    44.500   595.126
    45.000   600.449
    45.500   605.757
    46.000   611.049
    46.500   616.324
    47.000   621.582
    47.500   626.325
    48.000   630.895
    48.500   635.462
    49.000   640.023
    49.500   644.580
    50.000   649.131
    50.500   653.677
    51.000   658.218
    51.500   662.754
    52.000   667.284
    52.500   671.808
    53.000   676.326
    53.500   680.838
    54.000   685.344
    54.500   689.841
    55.000   694.329
    55.500   698.807
    56.000   703.275
    56.500   707.735
    57.000   712.188
    57.500   716.636
    58.000   721.080
    58.500   725.519
    59.000   729.953
    59.500   734.384
    60.000   738.811
    60.500   743.234
    61.000   747.653
    61.500   752.069
    62.000   756.480
    62.500   760.888
    63.000   765.292
    63.500   769.691
    64.000   774.087
    64.500   778.477
    65.000   782.863
    65.500   787.244
    66.000   791.618
    66.500   795.987
    67.000   800.349
    67.500   804.703
    68.000   809.051
    68.500   813.391
    69.000   817.723
    69.500   822.048
    70.000   826.365
    70.500   830.675
    71.000   834.977
    71.500   839.272
    72.000   843.559
    72.500   847.839
    73.000   852.110
    73.500   856.375
    74.000   860.631
    74.500   864.879
    75.000   869.120
    75.500   873.353
    76.000   877.577
    76.500   881.794
    77.000   886.002
    77.500   890.202
    78.000   894.394
    78.500   898.578
    79.000   902.752
    79.500   906.919
    80.000   911.076
    80.500   915.226
    81.000   919.366
    81.500   923.498
    82.000   927.622
    82.500   931.737
    83.000   935.844
    83.500   939.942
    84.000   944.032
    84.500   948.112
    85.000   952.185
    85.500   956.248
    86.000   960.303
    86.500   964.349
    87.000   968.386
    87.500   972.414
    88.000   976.434
    88.500   980.444
    89.000   984.446
    89.500   988.439
    90.000   992.423
    90.500   996.397
    91.000  1000.363
    91.500  1004.320
    92.000  1008.268
    92.500  1012.206
    93.000  1016.136
    93.500  1020.057
    94.000  1023.969
    94.500  1027.871
    95.000  1031.765
    95.500  1035.650
    96.000  1039.525
    96.500  1043.391
    97.000  1047.249
    97.500  1051.097
    98.000  1054.936
    98.500  1058.766
    99.000  1062.587
    99.500  1066.399
   100.000  1070.202
   100.500  1073.995
   101.000  1077.779
   101.500  1081.555
   102.000  1085.321
   102.500  1089.077
   103.000  1092.825
   103.500  1096.564
   104.000  1100.294
   104.500  1104.015
   105.000  1107.727
   105.500  1111.430
   106.000  1115.124
   106.500  1118.809
   107.000  1122.486
   107.500  1126.153
   108.000  1129.811
   108.500  1133.460
   109.000  1137.100
   109.500  1140.730
   110.000  1144.352
   110.500  1147.964
   111.000  1151.566
   111.500  1155.160
   112.000  1158.744
   112.500  1162.319
   113.000  1165.885
   113.500  1169.442
   114.000  1172.989
   114.500  1176.528
   115.000  1180.057
   115.500  1183.578
   116.000  1187.089
   116.500  1190.591
   117.000  1194.085
   117.500  1197.569
   118.000  1201.044
   118.500  1204.510
   119.000  1207.967
   119.500  1211.414
   120.000  1214.853
   120.500  1218.282
   121.000  1221.702
   121.500  1225.112
   122.000  1228.514
   122.500  1231.906
   123.000  1235.289
   123.500  1238.664
   124.000  1242.029
   124.500  1245.384
   125.000  1248.731
   125.500  1252.069
   126.000  1255.398
   126.500  1258.718
   127.000  1262.029
   127.500  1265.332
   128.000  1268.625
   128.500  1271.909
   129.000  1275.184
   129.500  1278.451
   130.000  1281.708
   130.500  1284.957
   131.000  1288.196
   131.500  1291.427
   132.000  1294.648
   132.500  1297.860
   133.000  1301.063
   133.500  1304.258
   134.000  1307.443
   134.500  1310.619
   135.000  1313.786
   135.500  1316.944
   136.000  1320.093
   136.500  1323.233
   137.000  1326.364
   137.500  1329.485
   138.000  1332.598
   138.500  1335.701
   139.000  1338.796
   139.500  1341.881
   140.000  1344.957
   140.500  1348.025
   141.000  1351.083
   141.500  1354.132
   142.000  1357.172
   142.500  1360.203
   143.000  1363.224
   143.500  1366.237
   144.000  1369.241
   144.500  1372.236
   145.000  1375.221
   145.500  1378.197
   146.000  1381.164
   146.500  1384.122
   147.000  1387.071
   147.500  1390.010
   148.000  1392.939
   148.500  1395.860
   149.000  1398.770
   149.500  1401.672
   150.000  1404.564
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.137
   100.500   827.360
   101.000   829.583
   101.500   831.806
   102.000   834.029
   102.500   836.252
   103.000   838.474
   103.500   840.697
   104.000   842.920
   104.500   845.143
   105.000   847.366
   105.500   849.589
   106.000   851.811
   106.500   854.034
   107.000   856.257
   107.500   858.480
   108.000   860.703
   108.500   862.926
   109.000   865.148
   109.500   867.371
   110.000   869.594
   110.500   871.817
   111.000   874.040
   111.500   876.263
   112.000   878.485
   112.500   880.708
   113.000   882.931
   113.500   885.154
   114.000   887.377
   114.500   889.600
   115.000   891.822
   115.500   894.045
   116.000   896.268
   116.500   898.491
   117.000   900.714
   117.500   902.937
   118.000   905.159
   118.500   907.382
   119.000   909.605
   119.500   911.828
   120.000   914.051
   120.500   916.274
   121.000   918.496
   121.500   920.719
   122.000   922.942
   122.500   925.165
   123.000   927.388
   123.500   929.611
   124.000   931.833
   124.500   934.056
   125.000   936.279
   125.500   938.502
   126.000   940.725
   126.500   942.948
   127.000   945.170
   127.500   947.393
   128.000   949.616
   128.500   951.839
   129.000   954.062
   129.500   956.285
   130.000   958.508
   130.500   960.730
   131.000   962.953
   131.500   965.176
   132.000   967.399
   132.500   969.622
   133.000   971.845
   133.500   974.067
   134.000   976.290
   134.500   978.513
   135.000   980.736
   135.500   982.959
   136.000   985.182
   136.500   987.404
   137.000   989.627
   137.500   991.850
   138.000   994.073
   138.500   996.296
   139.000   998.518
   139.500  1000.741
   140.000  1002.964
   140.500  1005.187
   141.000  1007.410
   141.500  1009.633
   142.000  1011.856
   142.500  1014.078
   143.000  1016.301
   143.500  1018.524
   144.000  1020.747
   144.500  1022.970
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.425
    15.000   395.664
    15.500   405.899
    16.000   416.126
    16.500   426.344
    17.000   436.547
    17.500   446.732
    18.000   456.894
    18.500   467.027
    19.000   477.127
    19.500   487.188
    20.000   497.202
    20.500   507.165
    21.000   517.071
    21.500   526.913
    22.000   536.688
    22.500   546.390
    23.000   555.055
    23.500   563.198
    24.000   571.307
    24.500   579.383
    25.000   587.416
    25.500   595.369
    26.000   603.280
    26.500   611.180
    27.000   619.072
    27.500   626.956
    28.000   634.833
    28.500   642.703
    29.000   650.567
    29.500   658.424
    30.000   666.274
    30.500   674.116
    31.000   681.948
    31.500   689.768
    32.000   697.576
    32.500   705.370
    33.000   713.149
    33.500   720.910
    34.000   728.654
    34.500   736.379
    35.000   744.085
    35.500   751.772
    36.000   759.439
    36.500   767.086
    37.000   774.713
    37.500   782.319
    38.000   789.904
    38.500   797.467
    39.000   805.009
    39.500   812.527
    40.000   820.023
    40.500   827.496
    41.000   834.946
    41.500   842.371
    42.000   849.773
    42.500   857.151
    43.000   864.504
    43.500   871.833
    44.000   879.137
    44.500   886.416
    45.000   893.671
    45.500   900.899
    46.000   908.102
    46.500   915.280
    47.000   922.431
    47.500   929.556
    48.000   936.654
    48.500   943.725
    49.000   950.770
    49.500   957.787
    50.000   964.777
    50.500   971.740
    51.000   978.676
    51.500   985.585
    52.000   992.466
    52.500   999.319
    53.000  1006.145
    53.500  1012.945
    54.000  1019.720
    54.500  1026.467
    55.000  1033.189
    55.500  1039.883
    56.000  1046.550
    56.500  1053.188
    57.000  1059.799
    57.500  1066.382
    58.000  1072.937
    58.500  1079.464
    59.000  1085.963
    59.500  1092.434
    60.000  1098.878
    60.500  1105.294
    61.000  1111.683
    61.500  1118.043
    62.000  1124.375
    62.500  1130.679
    63.000  1136.954
    63.500  1143.201
    64.000  1149.419
    64.500  1155.609
    65.000  1161.770
    65.500  1167.904
    66.000  1174.009
    66.500  1180.086
    67.000  1186.134
    67.500  1192.154
    68.000  1198.146
    68.500  1204.109
    69.000  1210.043
    69.500  1215.948
    70.000  1221.825
    70.500  1227.673
    71.000  1233.493
    71.500  1239.283
    72.000  1245.044
    72.500  1250.776
    73.000  1256.478
    73.500  1262.151
    74.000  1267.793
    74.500  1273.405
    75.000  1278.987
    75.500  1284.540
    76.000  1290.064
    76.500  1295.558
    77.000  1301.023
    77.500  1306.458
    78.000  1311.862
    78.500  1317.236
    79.000  1322.580
    79.500  1327.894
    80.000  1333.180
    80.500  1338.436
    81.000  1343.661
    81.500  1348.856
    82.000  1354.018
    82.500  1359.149
    83.000  1364.248
    83.500  1369.315
    84.000  1374.352
    84.500  1379.357
    85.000  1384.331
    85.500  1389.274
    86.000  1394.186
    86.500  1399.065
    87.000  1403.912
    87.500  1408.726
    88.000  1413.508
    88.500  1418.256
    89.000  1422.971
    89.500  1427.653
    90.000  1432.301
    90.500  1436.915
    91.000  1441.495
    91.500  1446.042
    92.000  1450.555
    92.500  1455.034
    93.000  1459.479
    93.500  1463.889
    94.000  1468.274
    94.500  1472.642
    95.000  1476.997
    95.500  1481.341
    96.000  1485.672
    96.500  1489.991
    97.000  1494.293
    97.500  1498.575
    98.000  1502.837
    98.500  1507.079
    99.000  1511.301
    99.500  1515.504
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.469
     1.000   720.516
     1.500   720.594
     2.000   720.703
     2.500   720.843
     3.000   721.014
     3.500   721.216
     4.000   721.449
     4.500   721.713
     5.000   722.008
     5.500   722.333
     6.000   722.689
     6.500   723.076
     7.000   723.493
     7.500   723.941
     8.000   724.419
     8.500   724.927
     9.000   725.466
     9.500   726.034
    10.000   726.632
    10.500   727.259
    11.000   727.916
    11.500   728.603
    12.000   729.318
    12.500   730.063
    13.000   730.836
    13.500   731.638
    14.000   732.469
    14.500   733.328
    15.000   734.215
    15.500   735.129
    16.000   736.072
    16.500   737.041
    17.000   738.038
    17.500   739.062
    18.000   740.113
    18.500   741.190
    19.000   742.294
    19.500   743.423
    20.000   744.578
    20.500   745.759
    21.000   746.965
    21.500   748.196
    22.000   749.452
    22.500   750.732
    23.000   752.036
    23.500   753.364
    24.000   754.716
    24.500   756.091
    25.000   757.489
    25.500   758.910
    26.000   760.353
    26.500   761.818
    27.000   763.306
    27.500   764.814
    28.000   766.344
    28.500   767.895
    29.000   769.466
    29.500   771.058
    30.000   772.669
    30.500   774.300
    31.000   775.951
    31.500   777.620
    32.000   779.308
    32.500   781.015
    33.000   782.739
    33.500   784.481
    34.000   786.241
    34.500   788.017
    35.000   789.810
    35.500   791.620
    36.000   793.445
    36.500   795.286
    37.000   797.143
    37.500   799.014
    38.000   800.901
    38.500   802.801
    39.000   804.716
    39.500   806.644
    40.000   808.585
    40.500   810.540
    41.000   812.507
    41.500   814.486
    42.000   816.478
    42.500   818.481
    43.000   820.495
    43.500   822.521
    44.000   824.557
    44.500   826.603
    45.000   828.660
    45.500   830.726
    46.000   832.801
    46.500   834.886
    47.000   836.979
    47.500   839.081
    48.000   841.190
    48.500   843.308
    49.000   845.433
    49.500   847.565
    50.000   849.704
    50.500   851.849
    51.000   854.001
    51.500   856.159
    52.000   858.322
    52.500   860.491
    53.000   862.664
    53.500   864.843
    54.000   867.026
    54.500   869.213
    55.000   871.404
    55.500   873.599
    56.000   875.798
    56.500   878.000
    57.000   880.204
    57.500   882.412
    58.000   884.621
    58.500   886.833
    59.000   889.048
    59.500   891.263
    60.000   893.481
    60.500   895.700
    61.000   897.920
    61.500   900.141
    62.000   902.362
    62.500   904.584
    63.000   906.807
    63.500   909.030
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   932.523
     1.000   932.590
     1.500   932.700
     2.000   932.855
     2.500   933.055
     3.000   933.298
     3.500   933.586
     4.000   933.917
     4.500   934.293
     5.000   934.712
     5.500   935.176
     6.000   935.683
     6.500   936.234
     7.000   936.829
     7.500   937.467
     8.000   938.148
     8.500   938.873
     9.000   939.640
     9.500   940.451
    10.000   941.304
    10.500   942.200
    11.000   943.139
    11.500   944.120
    12.000   945.143
    12.500   946.208
    13.000   947.314
    13.500   948.463
    14.000   949.652
    14.500   950.883
    15.000   952.154
    15.500   953.467
    16.000   954.819
    16.500   956.212
    17.000   957.645
    17.500   959.118
    18.000   960.630
    18.500   962.181
    19.000   963.771
    19.500   965.400
    20.000   967.068
    20.500   968.773
    21.000   970.517
    21.500   972.298
    22.000   974.116
    22.500   975.971
    23.000   977.863
    23.500   979.792
    24.000   981.756
    24.500   983.756
    25.000   985.792
    25.500   987.863
    26.000   989.969
    26.500   992.109
    27.000   994.283
    27.500   996.492
    28.000   998.734
    28.500  1001.009
    29.000  1003.317
    29.500  1005.658
    30.000  1008.031
    30.500  1010.436
    31.000  1012.872
    31.500  1015.340
    32.000  1017.839
    32.500  1020.368
    33.000  1022.928
    33.500  1025.517
    34.000  1028.136
    34.500  1030.785
    35.000  1033.462
    35.500  1036.168
    36.000  1038.902
    36.500  1041.664
    37.000  1044.453
    37.500  1047.270
    38.000  1050.114
    38.500  1052.984
    39.000  1055.880
    39.500  1058.803
    40.000  1061.750
    40.500  1064.724
    41.000  1067.721
    41.500  1070.744
    42.000  1073.791
    42.500  1076.861
    43.000  1079.956
    43.500  1083.073
    44.000  1086.214
    44.500  1089.377
    45.000  1092.562
    45.500  1095.769
    46.000  1098.998
    46.500  1102.248
    47.000  1105.520
    47.500  1108.812
    48.000  1112.124
    48.500  1115.457
    49.000  1118.809
    49.500  1122.180
    50.000  1125.571
    50.500  1128.981
    51.000  1132.410
    51.500  1135.856
    52.000  1139.321
    52.500  1142.803
    53.000  1146.303
    53.500  1149.820
    54.000  1153.354
    54.500  1156.904
    55.000  1160.470
    55.500  1164.053
    56.000  1167.651
    56.500  1171.265
    57.000  1174.894
    57.500  1178.538
    58.000  1182.196
    58.500  1185.869
    59.000  1189.556
    59.500  1193.257
    60.000  1196.971
    60.500  1200.699
    61.000  1204.440
    61.500  1208.194
    62.000  1211.960
    62.500  1215.739
    63.000  1219.530
    63.500  1223.332
    64.000  1227.147
    64.500  1230.972
    65.000  1234.809
    65.500  1238.657
    66.000  1242.516
    66.500  1246.385
    67.000  1250.264
    67.500  1254.153
    68.000  1258.052
    68.500  1261.961
    69.000  1265.879
    69.500  1269.807
    70.000  1273.743
    70.500  1277.688
    71.000  1281.642
    71.500  1285.604
    72.000  1289.574
    72.500  1293.552
    73.000  1297.538
    73.500  1301.531
    74.000  1305.532
    74.500  1309.540
    75.000  1313.555
    75.500  1317.577
    76.000  1321.605
    76.500  1325.640
    77.000  1329.681
    77.500  1333.729
    78.000  1337.782
    78.500  1341.841
    79.000  1345.905
    79.500  1349.975
    80.000  1354.050
    80.500  1358.130
    81.000  1362.216
    81.500  1366.306
    82.000  1370.400
    82.500  1374.499
    83.000  1378.602
    83.500  1382.710
    84.000  1386.821
    84.500  1390.936
    85.000  1395.055
    85.500  1399.178
    86.000  1403.303
    86.500  1407.433
    87.000  1411.565
    87.500  1415.700
    88.000  1419.838
    88.500  1423.979
    89.000  1428.122
    89.500  1432.268
    90.000  1436.416
    90.500  1440.567
    91.000  1444.719
    91.500  1448.873
    92.000  1453.030
    92.500  1457.188
    93.000  1461.347
    93.500  1465.508
    94.000  1469.671
    94.500  1473.834
    95.000  1477.999
    95.500  1482.165
    96.000  1486.331
    96.500  1490.499
    97.000  1494.667
    97.500  1498.836
    98.000  1503.005
    98.500  1507.175
    99.000  1511.345
    99.500  1515.515
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.379
    29.500   783.619
    30.000   793.857
    30.500   804.093
    31.000   814.327
    31.500   824.558
    32.000   834.784
    32.500   845.005
    33.000   855.221
    33.500   865.429
    34.000   875.630
    34.500   885.822
    35.000   896.003
    35.500   906.174
    36.000   916.331
    36.500   926.475
    37.000   936.604
    37.500   946.716
    38.000   956.810
    38.500   966.555
    39.000   976.937
    39.500   986.968
    40.000   996.974
    40.500  1006.955
    41.000  1016.909
    41.500  1026.835
    42.000  1036.730
    42.500  1046.594
    43.000  1056.426
    43.500  1066.223
    44.000  1075.986
    44.500  1085.712
    45.000  1095.401
    45.500  1104.768
    46.000  1112.938
    46.500  1121.091
    47.000  1129.227
    47.500  1137.346
    48.000  1145.450
    48.500  1153.536
    49.000  1161.606
    49.500  1169.655
    50.000  1177.677
    50.500  1185.663
    51.000  1193.594
    51.500  1201.510
    52.000  1209.418
    52.500  1217.322
    53.000  1225.220
    53.500  1233.114
    54.000  1241.003
    54.500  1248.889
    55.000  1256.772
    55.500  1264.651
    56.000  1272.527
    56.500  1280.399
    57.000  1288.268
    57.500  1296.134
    58.000  1303.997
    58.500  1311.856
    59.000  1319.712
    59.500  1327.564
    60.000  1335.413
    60.500  1343.257
    61.000  1351.097
    61.500  1358.932
    62.000  1366.762
    62.500  1374.587
    63.000  1382.405
    63.500  1390.217
    64.000  1398.022
    64.500  1405.821
    65.000  1413.612
    65.500  1421.395
    66.000  1429.170
    66.500  1436.937
    67.000  1444.695
    67.500  1452.445
    68.000  1460.185
    68.500  1467.916
    69.000  1475.638
    69.500  1483.350
    70.000  1491.052
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     2.128    36.350     0.150
     2.128    40.350     0.150
     2.128    47.350     0.150
     2.128    74.350     0.150
     2.128    88.350     0.150
     2.366    97.350     0.150
     2.366   170.350     0.150
     7.414   121.350     0.150
    10.567   148.350     0.150
    11.720   289.350     0.150
    12.610   318.350     0.150
    12.637   180.350     0.150
    12.637   320.350     0.150
    13.032   184.350     0.150
    14.527   199.350     0.150
    14.527   360.350     0.150
    14.527   199.350     0.150
    14.527   360.350     0.150
    16.878   242.350     0.150
    19.980   309.350     0.150
    19.980   527.350     0.150
    19.980   539.350     0.150
    21.488   297.350     0.150
    24.242   559.350     0.150
     1.820   325.350     0.150
    25.278   605.550     0.150
    25.278   326.350     0.150
    25.278   605.350     0.150
    28.348   355.350     0.150
    28.348   355.350     0.150
    29.483   364.350     0.150
    29.483   658.350     0.150
    30.253   671.350     0.150
    30.253   369.350     0.150
    30.253   671.350     0.150
    31.000   815.350     0.150
    36.208   423.350     0.150
    37.832   968.350     0.150
    39.193   440.350     0.150
    39.184   446.350     0.150
    39.184   537.350     0.150
    39.184   805.350     0.150
    39.184   971.350     0.150
    39.683   536.350     0.150
    39.683   451.350     0.150
    39.683   812.350     0.150
    42.720  1097.350     0.150
    42.720   477.350     0.150
    42.720   861.350     0.150
    42.720  1073.350     0.150
    42.720  1097.350     0.150
    44.774   492.350     0.150
    44.774   886.350     0.150
    46.430   922.350     0.150
    46.714   907.350     0.150
    47.704   631.350     0.150
    48.112   942.350     0.150
    48.468   689.350     0.150
    48.468  1123.350     0.150
    49.163   601.350     0.150
    49.163   692.350     0.150
    49.163   953.350     0.150
    49.163  1177.350     0.150
    49.790   645.350     0.150
    49.790  1193.350     0.150
    50.320   535.350     0.150
    51.039   973.350     0.150
    51.039   540.150     0.150
    51.039   973.350     0.150
    51.385   548.350     0.150
    51.936   965.350     0.150
    52.561   551.350     0.150
    52.925   556.650     0.150
    53.454   564.250     0.150
    53.454    16.100     0.150
    53.454   592.750     0.150
    53.454   637.350     0.150
    53.454   674.350     0.150
    53.454   683.550     0.150
    53.454   711.150     0.150
    53.454   718.550     0.150
    53.454   748.350     0.150
    53.454   810.350     0.150
    53.454   559.450     0.150
    53.454    15.900     0.150
    53.454   592.350     0.150
    53.454   637.350     0.150
    53.454   674.350     0.150
    53.454   711.350     0.150
    53.454   718.350     0.150
    53.454   748.350     0.150
    53.454   810.350     0.150
    53.454  1012.350     0.150
    53.611  1042.350     0.150
    53.611  1160.350     0.150
    54.380    17.000     0.150
    54.662   620.750     0.150
    57.128   574.350     0.150
    57.140   584.850     0.150
    57.198   587.150     0.150
    58.927   603.350     0.150
    59.959   606.050     0.150
    60.240   604.650     0.150
    61.671   617.350     0.150
    61.671  1113.350     0.150
    61.681   613.350     0.150
    61.681  1093.350     0.150
    61.681  1378.350     0.150
    62.466  1121.350     0.150
    62.466  5339.350     0.150
    91.497  2017.350     0.150
    99.071   812.350     0.150
   113.486   900.350     0.150
   113.486  1108.350     0.150
   119.788  1126.350     0.150
   119.788  1962.350     0.150
   129.163  1130.350     0.150
   148.301  1583.350     0.150
     2.514   111.047     0.150
     5.918    89.047     0.150
     5.918   148.047     0.150
     7.397   108.047     0.150
     7.397   182.047     0.150
     7.435   167.047     0.150
     7.435   249.047     0.150
    10.608   267.047     0.150
    10.951   156.047     0.150
    10.951   156.047     0.150
    10.951   277.047     0.150
    12.888   176.047     0.150
    12.888   309.047     0.150
    13.075   179.047     0.150
    13.075   320.047     0.150
    12.852   327.047     0.150
    12.852   184.047     0.150
    12.983   184.047     0.150
    13.312   186.047     0.150
    13.760   195.047     0.150
    13.982   347.047     0.150
    13.982   197.047     0.150
    14.893   220.047     0.150
    14.893   207.047     0.150
    14.893   207.047     0.150
    16.692   401.047     0.150
    19.690   292.047     0.150
    19.690   468.047     0.150
    19.690   494.047     0.150
    19.690   507.047     0.150
    19.716   489.047     0.150
    20.384   279.047     0.150
    20.384   279.047     0.150
    20.629   279.047     0.150
    22.260   298.047     0.150
     2.213   329.047     0.150
    27.414   624.047     0.150
    27.414   348.047     0.150
    27.414   624.047     0.150
    27.414   348.047     0.150
    28.332   357.047     0.150
    28.332   357.047     0.150
    28.332   643.047     0.150
    28.332   357.047     0.150
    29.718   563.047     0.150
    29.727   664.047     0.150
    29.727   367.047     0.150
    29.888   369.047     0.150
    30.745   663.047     0.150
    30.566   447.047     0.150
    30.566   805.047     0.150
    30.566   997.047     0.150
    30.566   374.047     0.150
    30.566   374.047     0.150
    31.402   383.047     0.150
    31.403   382.047     0.150
    32.362   392.047     0.150
    35.417   416.047     0.150
    39.585   973.047     0.150
    39.585   454.047     0.150
    39.585   815.047     0.150
    39.585   454.047     0.150
    40.053   456.047     0.150
    42.527   584.047     0.150
    42.527  1057.047     0.150
    42.527   477.047     0.150
    42.527   859.047     0.150
    42.527   477.047     0.150
    43.452   874.047     0.150
    43.452   484.047     0.150
    44.430   487.047     0.150
    44.430   871.047     0.150
    44.735   503.047     0.150
    45.133   898.047     0.150
    45.133  1008.047     0.150
    45.133  1153.047     0.150
    45.133   496.047     0.150
    45.133   496.047     0.150
    45.124   496.047     0.150
    46.018   507.047     0.150
    46.824   510.047     0.150
    47.031   913.047     0.150
    47.031   511.047     0.150
    47.919   939.047     0.150
    47.919   519.047     0.150
    48.063   659.047     0.150
    48.063   923.047     0.150
    48.063  1132.047     0.150
    49.127   628.047     0.150
    49.223   554.047     0.150
    49.223   585.047     0.150
    49.239   945.047     0.150
    49.239   527.047     0.150
    49.310    14.297     0.150
    49.474   708.047     0.150
    50.084     8.000     0.150
    50.102   571.047     0.150
    50.102   658.047     0.150
    50.102   961.047     0.150
    50.102  1193.047     0.150
    50.102  1213.047     0.150
    50.102  1293.047     0.150
    50.102  1317.047     0.150
    50.163   538.047     0.150
    50.163   657.047     0.150
    50.163   538.047     0.150
    50.163   962.047     0.150
    50.163   538.047     0.150
    50.245   539.047     0.150
    50.598    12.000     0.150
    50.823   970.047     0.150
    51.403   987.047     0.150
    51.403  1220.047     0.150
    51.403   544.844     0.150
    51.403   987.047     0.150
    51.779   548.047     0.150
    52.215    15.000     0.150
    52.955   684.047     0.150
    53.325   728.047     0.150
    53.786   558.047     0.150
    53.786  1005.047     0.150
    53.835   569.047     0.150
    53.835  1020.047     0.150
    53.845     2.000     0.150
    53.845   762.047     0.150
    53.845   798.047     0.150
    53.845  1014.047     0.150
    53.845  1033.047     0.150
    53.845  4921.047     0.150
    53.991  1036.047     0.150
    53.991  1045.047     0.150
    53.991  1261.047     0.150
    54.773   569.047     0.150
    54.757   573.047     0.150
    54.757  1035.047     0.150
    55.244   588.047     0.150
    55.270   570.047     0.150
    55.563   592.547     0.150
    55.563  1916.047     0.150
    57.169   582.047     0.150
    57.169  1042.047     0.150
    57.531     1.000     0.150
    57.531    13.000     0.150
    57.584   591.547     0.150
    57.824   598.047     0.150
    57.824   634.047     0.150
    57.824   696.047     0.150
    59.299   597.750     0.150
    59.299    13.297     0.150
    59.679  1441.047     0.150
    59.679   603.047     0.150
    60.871    13.297     0.150
    62.843  1140.047     0.150
    62.843  3463.047     0.150
    63.245   624.047     0.150
    63.811   783.047     0.150
     0.725   630.648     0.150
    64.420   629.344     0.150
    70.677   680.047     0.150
    70.758   937.047     0.150
    70.758  1693.047     0.150
    77.811  1253.047     0.150
    80.408   733.750     0.150
    83.406   746.148     0.150
    95.826   807.047     0.150
   100.669   833.047     0.150
   103.638   853.148     0.150
   103.914   848.648     0.150
   109.247   875.648     0.150
   109.346   878.750     0.150
   109.601   877.547     0.150
   110.358  1141.047     0.150
   111.280  1113.047     0.150
   111.386  1146.344     0.150
   113.172  1110.047     0.150
   115.272  1109.547     0.150
   115.272  1413.047     0.150
   115.272  2623.047     0.150
   115.289   900.344     0.150
   115.865   907.344     0.150
   119.592  1753.047     0.150
   120.090  1124.547     0.150
   148.698  1384.047     0.150
   148.872  1385.047     0.150
     1.072    12.262     0.150
     2.581    37.361     0.150
     7.547    99.262     0.150
    10.646   297.262     0.150
    11.180   152.262     0.150
    11.180   274.262     0.150
    11.620   292.262     0.150
    12.196   164.762     0.150
    12.196   304.262     0.150
    20.289   499.262     0.150
    21.323   281.262     0.150
    21.323   525.262     0.150
     0.746   311.262     0.150
    46.366   510.262     0.150
    46.630   522.262     0.150
    48.011   523.262     0.150
    49.440   524.762     0.150
    53.689     7.000     0.150
    57.121   575.961     0.150
    57.238   580.262     0.150
    58.776   593.262     0.150
    59.056   595.361     0.150
    60.574   615.262     0.150
    61.065   611.262     0.150
    61.261   612.461     0.150
    61.598   610.262     0.150
     1.030   619.762     0.150
   120.381  1131.062     0.150
     2.799    56.088     0.150
     5.535    88.088     0.150
     7.409   113.088     0.150
     7.409   239.088     0.150
     8.243   123.088     0.150
     8.243   263.088     0.150
     8.268   121.088     0.150
    11.873   172.088     0.150
    11.873   301.088     0.150
    12.258   176.088     0.150
    12.735   187.088     0.150
    12.735   306.088     0.150
    12.744   184.088     0.150
    12.744   321.088     0.150
    12.829   298.088     0.150
    12.944   315.088     0.150
    17.063   414.088     0.150
    19.947   332.088     0.150
    20.603   460.088     0.150
    21.374   511.088     0.150
    28.999   365.088     0.150
    43.001   480.088     0.150
    45.199   499.088     0.150
    45.199   895.088     0.150
    49.453     9.000     0.150
    66.505   646.088     0.150
    67.327   652.088     0.150
    75.518   710.088     0.150
     2.669    50.689     0.150
     2.669    85.689     0.150
     7.654   135.689     0.150
     7.637   108.689     0.150
     8.879   130.689     0.150
     8.879   290.689     0.150
    11.660   293.689     0.150
    13.000   321.689     0.150
    13.064   187.689     0.150
    13.064   304.689     0.150
    12.825   318.689     0.150
    13.114   317.689     0.150
    20.312   514.689     0.150
     0.857   314.689     0.150
    26.338   620.689     0.150
    27.419   348.689     0.150
    29.347   372.689     0.150
    32.296   417.689     0.150
    41.281  1046.689     0.150
    43.187   480.689     0.150
    44.504     2.000     0.150
    47.725    10.900     0.150
    48.046    10.600     0.150
    48.621   528.689     0.150
    48.724   938.689     0.150
    48.884  1150.689     0.150
    48.884  1182.689     0.150
    48.883   524.689     0.150
    52.542    12.400     0.150
    53.283     4.000     0.150
    53.759   555.689     0.150
    54.044   574.589     0.150
    56.112   578.689     0.150
    57.358   592.689     0.150
    60.611   611.689     0.150
     0.971   622.489     0.150
    68.853   668.689     0.150
    69.704   740.689     0.150
    71.537   726.689     0.150
    71.537   771.689     0.150
    72.355   679.689     0.150
    72.871   756.689     0.150
    76.118   714.689     0.150
     5.277    81.367     0.150
     5.277   108.672     0.150
    10.346   268.570     0.150
    11.149   273.570     0.150
    11.149   274.070     0.150
    11.757   303.172     0.150
    11.757   166.672     0.150
    11.757   303.172     0.150
    11.910   168.672     0.150
    11.910   298.070     0.150
    12.170   317.672     0.150
    12.516   174.969     0.150
    12.516   306.273     0.150
    12.516   174.969     0.150
    12.516   306.273     0.150
    12.655   303.570     0.150
    12.659   302.570     0.150
    12.785   322.367     0.150
    12.785   179.367     0.150
    12.785   322.367     0.150
    13.021   324.570     0.150
    13.120   192.570     0.150
    13.577   332.570     0.150
    13.577   332.570     0.150
    13.577   332.570     0.150
    13.577   332.570     0.150
    13.577   190.570     0.150
    13.577   332.570     0.150
    14.398   351.570     0.150
    14.398   351.570     0.150
    14.398   351.570     0.150
    14.398   199.570     0.150
    14.398   351.570     0.150
    14.565   357.172     0.150
    14.565   357.172     0.150
    14.565   357.172     0.150
    14.565   200.570     0.150
    14.565   357.172     0.150
    15.656   210.570     0.150
    15.656   378.570     0.150
    16.946   404.570     0.150
    18.538   254.570     0.150
    19.837   477.367     0.150
    19.837   477.367     0.150
    19.837   477.367     0.150
    19.837   270.867     0.150
    20.020   273.570     0.150
    20.358   494.867     0.150
    20.358   275.469     0.150
    20.358   494.867     0.150
    21.641   523.570     0.150
    21.713   290.570     0.150
    21.713   528.570     0.150
    23.614   319.773     0.150
    23.614   319.773     0.150
    23.614   564.570     0.150
     1.683   324.570     0.150
    24.885   588.773     0.150
    24.885   588.773     0.150
    24.885   321.570     0.150
    24.885   588.773     0.150
    26.501   338.570     0.150
    26.651   615.570     0.150
    26.651   615.570     0.150
    26.651   615.570     0.150
    26.651   339.672     0.150
    26.651   615.570     0.150
    26.867   623.570     0.150
    26.867   342.570     0.150
    26.867   623.570     0.150
    27.803   625.070     0.150
    27.803   348.969     0.150
    27.803   625.070     0.150
    28.354   643.070     0.150
    28.354   354.773     0.150
    28.354   643.070     0.150
    29.183   361.570     0.150
    29.341   362.172     0.150
    29.341     3.602     0.150
    29.341   652.969     0.150
    29.539   364.570     0.150
    29.539   656.570     0.150
    30.142   662.570     0.150
    30.142   369.570     0.150
    30.142   662.570     0.150
    30.517   675.570     0.150
    30.517   374.570     0.150
    30.517   675.570     0.150
    30.523   373.367     0.150
    30.523     6.000     0.150
    30.523   669.570     0.150
    30.855   682.570     0.150
    30.855   377.570     0.150
    30.855   682.570     0.150
    31.407   383.570     0.150
    31.407   690.570     0.150
    31.816   699.570     0.150
    31.816   699.570     0.150
    31.816   699.570     0.150
    32.582   390.570     0.150
    32.582   390.570     0.150
    32.582   702.070     0.150
    34.872   741.570     0.150
    34.872   741.570     0.150
    35.842   566.070     0.150
    36.211   422.570     0.150
    37.123   436.672     0.150
    37.123   447.570     0.150
    39.553   809.570     0.150
    39.553   809.570     0.150
    39.553   450.570     0.150
    39.553     5.000     0.150
    39.553   809.570     0.150
    39.694   816.570     0.150
    39.694   450.570     0.150
    39.694   816.570     0.150
    39.883   453.570     0.150
    39.883   816.570     0.150
    42.913   861.570     0.150
    42.913   861.570     0.150
    42.913   478.570     0.150
    42.913   861.570     0.150
    44.296   493.570     0.150
    44.648   492.570     0.150
    44.648   886.570     0.150
    45.135   495.969     0.150
    46.602   913.570     0.150
    46.602   913.570     0.150
    46.602   507.367     0.150
    46.602   913.570     0.150
    46.794   511.570     0.150
    46.794   919.570     0.150
    47.383   922.570     0.150
    47.383   922.570     0.150
    47.578   550.469     0.150
    47.578   622.570     0.150
    47.578   515.570     0.150
    48.077   600.570     0.150
    48.198   932.570     0.150
    48.198   932.570     0.150
    48.198   932.570     0.150
    48.331  1091.570     0.150
     1.779   522.672     0.150
     1.779     6.898     0.150
     1.779   590.570     0.150
     1.779   636.570     0.150
    48.987   528.570     0.150
    49.136   953.070     0.150
    49.136   525.969     0.150
    49.136   953.070     0.150
    49.680   654.570     0.150
    50.376   958.570     0.150
    50.376   535.672     0.150
    50.376   958.570     0.150
    50.910  1207.570     0.150
    51.064   537.070     0.150
    51.339  1010.570     0.150
    51.367   684.570     0.150
    51.476   984.570     0.150
    51.476   545.570     0.150
    51.476     5.797     0.150
    51.476   984.570     0.150
    51.795     1.102     0.150
    51.795   563.367     0.150
    51.795   706.570     0.150
    52.423   552.570     0.150
    52.423   998.570     0.150
    52.487   186.000     0.150
    52.487  1066.570     0.150
    52.751   554.969     0.150
    52.751  1002.570     0.150
    52.773   570.570     0.150
    52.903   555.172     0.150
    52.903   555.172     0.150
    53.112  1274.570     0.150
    53.316  1005.570     0.150
    53.316   557.969     0.150
    53.316  1005.570     0.150
    53.354  1264.570     0.150
    53.354  1372.570     0.150
    53.354  1438.773     0.150
     3.443   561.172     0.150
    54.242   692.570     0.150
    54.242   565.570     0.150
    54.242  1022.570     0.150
    54.590     1.102     0.150
    54.590  1031.570     0.150
    54.590  1031.570     0.150
    54.784   567.969     0.150
    54.784     1.305     0.150
    54.784  1024.570     0.150
    54.784  1027.570     0.150
    55.514     9.203     0.150
    55.597   574.969     0.150
    55.597  1039.469     0.150
    57.061   586.570     0.150
    57.061   610.570     0.150
    57.084   610.070     0.150
    57.084   658.367     0.150
    57.084   797.570     0.150
    57.674   589.367     0.150
    57.761   623.070     0.150
    57.761   801.070     0.150
    57.790   592.273     0.150
    59.812  1090.570     0.150
    59.812  1090.570     0.150
    59.812   604.570     0.150
    59.812  1090.570     0.150
    61.547   608.570     0.150
    61.617   617.172     0.150
    62.184   621.672     0.150
    62.345   623.070     0.150
    65.486   643.570     0.150
    66.521   649.570     0.150
    66.521   649.570     0.150
    66.521  1178.570     0.150
     0.737   654.570     0.150
    67.460  1646.570     0.150
    69.759   658.367     0.150
    70.440   670.570     0.150
    72.505   726.570     0.150
    72.505   746.570     0.150
    74.644   698.172     0.150
    74.644   698.172     0.150
    75.462   985.570     0.150
    78.264  1314.570     0.150
    78.264  1314.570     0.150
    85.982  1252.469     0.150
    96.759   809.570     0.150
   110.426  1119.273     0.150
   111.372  1112.570     0.150
   113.391  1125.570     0.150
   114.013  1111.070     0.150
   114.311  1106.570     0.150
   115.062  1115.570     0.150
   131.075  1134.570     0.150
   144.524  1160.273     0.150
   151.181  1240.570     0.150
   155.053  1202.070     0.150
     2.311    38.566     0.150
     2.311    40.965     0.150
     2.311    47.066     0.150
     2.311    71.566     0.150
     3.236    91.266     0.150
     3.343    56.266     0.150
     3.980    62.365     0.150
     3.980   117.865     0.150
     4.997   156.365     0.150
     7.398    94.266     0.150
     7.627   111.566     0.150
     7.627   200.266     0.150
     9.110   235.365     0.150
    12.154   170.266     0.150
    12.154   303.266     0.150
    12.536   185.266     0.150
    12.806   188.865     0.150
    12.806   188.266     0.150
    12.806   314.965     0.150
    13.111   319.666     0.150
    13.111   319.666     0.150
    14.225   191.266     0.150
    14.225   201.266     0.150
    14.225   208.266     0.150
    14.225   337.266     0.150
    14.225   361.266     0.150
    14.225   363.266     0.150
    14.225   525.266     0.150
    14.705   198.266     0.150
    14.705   198.865     0.150
    19.754   274.266     0.150
    19.926   506.266     0.150
    20.528    11.100     0.150
    20.528   302.766     0.150
    20.528   505.365     0.150
    23.736   309.865     0.150
    23.873   310.965     0.150
    25.034   582.266     0.150
    25.034   321.266     0.150
    25.034   582.266     0.150
    26.505   337.266     0.150
    26.629   338.566     0.150
    30.407   370.266     0.150
    30.796   374.066     0.150
    32.153   387.266     0.150
    39.840   450.965     0.150
    39.840   573.266     0.150
    40.195   455.266     0.150
    44.949   493.266     0.150
    45.172   498.766     0.150
    45.133   494.766     0.150
    47.714   517.266     0.150
    47.879   516.566     0.150
    49.204   525.266     0.150
    49.204     6.000     0.150
    49.270   526.266     0.150
    51.578    16.000     0.150
    51.667    16.000     0.150
    51.667    15.500     0.150
    52.752   552.766     0.150
    52.752   552.766     0.150
    53.079   555.965     0.150
    54.570   622.266     0.150
    54.570   566.766     0.150
    54.570   622.266     0.150
    54.570   566.766     0.150
    57.089   590.766     0.150
    58.008   590.766     0.150
    63.307   624.666     0.150
     0.545   629.566     0.150
    66.555    12.500     0.150
    66.555   647.766     0.150
    66.555     8.500     0.150
    66.555    12.500     0.150
    95.734   798.266     0.150
     2.452   100.168     0.150
     2.452   167.168     0.150
     2.452   173.969     0.150
    10.656   149.367     0.150
    10.656   267.168     0.150
    10.656   149.766     0.150
    10.656   267.168     0.150
    11.984   174.367     0.150
    11.984   301.266     0.150
    11.984   175.066     0.150
    11.984   301.266     0.150
    12.083   170.367     0.150
    12.083   302.367     0.150
    12.565   179.367     0.150
    12.565   200.867     0.150
    12.565   303.867     0.150
    12.720   311.566     0.150
    12.720   311.566     0.150
    12.888   189.867     0.150
    12.888   196.367     0.150
    13.012   185.367     0.150
    13.012   185.367     0.150
    13.464   197.367     0.150
    13.464   205.367     0.150
    13.464   346.367     0.150
    13.464   712.367     0.150
    13.756   189.367     0.150
    13.756   189.367     0.150
    13.828   203.367     0.150
    13.828   334.367     0.150
    13.828   350.367     0.150
    14.613   352.367     0.150
    14.613   352.367     0.150
    14.792   219.367     0.150
    14.792   370.066     0.150
    14.792   219.367     0.150
    14.792   370.066     0.150
    19.783   561.367     0.150
    20.030   552.367     0.150
    20.069   267.367     0.150
    20.482   500.266     0.150
    21.246   284.969     0.150
    23.706   310.066     0.150
    23.865   312.867     0.150
    24.375   581.367     0.150
    24.467   320.367     0.150
    24.995   322.066     0.150
    24.995   583.367     0.150
    25.686   334.367     0.150
    26.644   338.867     0.150
    29.145   358.367     0.150
    32.048   393.367     0.150
    32.048   393.367     0.150
    37.378   432.367     0.150
    38.042   775.367     0.150
    39.802   451.168     0.150
    39.802     7.199     0.150
    40.101   453.367     0.150
    44.859   493.367     0.150
    44.859     8.000     0.150
    45.142   892.566     0.150
    47.200   517.367     0.150
    47.613    18.000     0.150
    47.613    17.500     0.150
    47.694   515.566     0.150
    47.789   516.168     0.150
    48.067   518.367     0.150
    48.485   522.867     0.150
    48.918   543.367     0.150
    48.968   529.066     0.150
    49.192   537.367     0.150
    49.192   537.367     0.150
    49.637   528.367     0.150
    52.979   555.766     0.150
    52.979     8.801     0.150
    53.342   555.969     0.150
    53.342   556.066     0.150
    53.544   562.367     0.150
    54.770    12.000     0.150
    54.770   568.367     0.150
    54.770     6.000     0.150
    54.770    12.000     0.150
    55.002   570.867     0.150
    55.181   574.367     0.150
    58.997   601.168     0.150
    62.336   621.969     0.150
    62.873   625.566     0.150
     0.461   629.066     0.150
    66.553   648.367     0.150
    66.553   672.367     0.150
    67.591   652.367     0.150
     2.533    50.965     0.150
     2.533    86.766     0.150
     5.366    84.164     0.150
    14.118   359.766     0.150
    15.222   197.766     0.150
    17.230   412.766     0.150
    47.512   517.766     0.150
     1.819    35.127     0.150
     1.819    66.328     0.150
     5.322    69.328     0.150
     5.322   122.027     0.150
    11.409   162.527     0.150
    11.409   303.627     0.150
    12.585   183.527     0.150
    12.585   312.027     0.150
    72.020   685.027     0.150
    82.416   744.127     0.150
    13.293   189.179     0.150
    13.902   205.179     0.150
    13.902   213.179     0.150
    13.902   346.179     0.150
    13.902   363.179     0.150
    13.902   376.179     0.150
    14.917   217.179     0.150
    24.498   324.379     0.150
    25.379   332.079     0.150
    51.831   555.579     0.150
    51.831   774.179     0.150
    51.915   556.479     0.150
    51.915   775.778     0.150
     1.538    21.844     0.150
     3.119    52.547     0.150
     5.475    90.250     0.150
     5.849   173.148     0.150
     6.725   120.047     0.150
     8.339   120.648     0.150
     8.339   212.648     0.150
     9.591   255.047     0.150
     9.615   253.844     0.150
     9.615   138.047     0.150
     9.615   253.844     0.150
     9.790   248.344     0.150
    10.108   250.648     0.150
    10.643   262.445     0.150
    10.643   150.344     0.150
    10.643   262.445     0.150
    10.680   151.047     0.150
    10.680   264.648     0.150
    11.411   158.844     0.150
    12.032   304.047     0.150
    12.032   173.047     0.150
    12.032   304.047     0.150
    12.188   172.648     0.150
    12.412   173.445     0.150
    12.412   305.547     0.150
    12.421   176.047     0.150
    12.421   176.047     0.150
    12.421   305.750     0.150
    12.527   180.047     0.150
    12.527   314.047     0.150
    12.576   168.547     0.150
    12.576   291.047     0.150
    13.069   351.047     0.150
    13.136   188.547     0.150
    13.136   200.047     0.150
    13.136   337.047     0.150
    13.379   184.250     0.150
    13.622   191.047     0.150
    13.622   200.547     0.150
    13.622   210.047     0.150
    13.622   346.047     0.150
    14.163   213.047     0.150
    14.163   361.047     0.150
    14.163   373.047     0.150
    14.185   363.047     0.150
    14.827   212.344     0.150
    14.827   377.047     0.150
    17.589   426.047     0.150
    17.589   243.047     0.150
    17.589   426.047     0.150
    17.771   430.047     0.150
    17.771   430.047     0.150
    19.368   263.148     0.150
    19.368   472.047     0.150
    19.466   486.047     0.150
    19.466   267.047     0.150
    19.466   486.047     0.150
    20.451   276.047     0.150
    20.451   503.047     0.150
    20.762   305.047     0.150
    20.762   315.047     0.150
    20.762   557.047     0.150
    20.762   569.047     0.150
    22.051   294.047     0.150
    22.040     8.203     0.150
    22.043     5.500     0.150
    22.511   549.047     0.150
    22.567    14.000     0.150
    22.567   332.047     0.150
    22.567   536.047     0.150
     0.793   303.047     0.150
    22.943   548.047     0.150
    22.943   302.047     0.150
    22.943   548.047     0.150
    23.641   310.047     0.150
    24.621   331.047     0.150
    24.621   331.047     0.150
    26.148   337.047     0.150
    26.620   337.445     0.150
    26.937   612.047     0.150
    26.937   340.445     0.150
    26.937   396.047     0.150
    26.937   612.047     0.150
    27.093    16.000     0.150
    27.093   623.047     0.150
    27.093   638.648     0.150
    27.093   342.844     0.150
    27.093     7.406     0.150
    27.093    16.000     0.150
    27.093   623.047     0.150
    27.093   638.648     0.150
    27.500   351.047     0.150
    28.284   353.047     0.150
    28.284   637.047     0.150
    28.443   354.047     0.150
    28.443     9.000     0.150
    28.443   423.047     0.150
    28.443   640.047     0.150
    28.494   360.047     0.150
    28.552   355.047     0.150
    28.552   645.047     0.150
    28.765   647.047     0.150
    28.765   356.750     0.150
    28.765   647.047     0.150
    29.571   366.844     0.150
    30.185   365.547     0.150
    30.352   370.445     0.150
    31.108   675.047     0.150
    32.085   693.047     0.150
    32.635   393.047     0.150
    32.635   469.047     0.150
    32.635   703.047     0.150
    33.335   720.047     0.150
    34.187   461.148     0.150
    34.454   406.047     0.150
    34.454   732.047     0.150
    36.178   754.047     0.150
    36.327   422.148     0.150
    36.810   426.047     0.150
    36.810   769.047     0.150
    37.518   448.148     0.150
    37.513    12.000     0.150
    37.513   433.047     0.150
    37.513    12.000     0.150
    37.513   779.047     0.150
    37.821   435.047     0.150
    37.821   547.047     0.150
    37.821   578.047     0.150
    37.821   784.047     0.150
    37.821   796.047     0.150
    37.814   433.250     0.150
    38.809   442.750     0.150
    38.809   799.047     0.150
    38.809   997.047     0.150
    39.131   451.047     0.150
    40.696   823.047     0.150
    40.696   458.047     0.150
    40.696   823.047     0.150
    40.696  1001.047     0.150
    41.052   459.047     0.150
    41.847   449.047     0.150
    42.069   468.047     0.150
    42.069   467.445     0.150
    42.218   845.047     0.150
    42.465   474.047     0.150
    42.465   852.047     0.150
     1.082   473.250     0.150
    42.607   473.047     0.150
    42.669   475.047     0.150
    42.669     6.000     0.150
    42.669   857.047     0.150
    42.669  1031.047     0.150
    43.910   487.047     0.150
    43.910   877.047     0.150
    44.103   488.047     0.150
    44.103   878.047     0.150
    44.688   504.047     0.150
    44.861   889.047     0.150
    44.861   492.844     0.150
    44.861   889.047     0.150
    45.180    16.898     0.150
    45.180   899.047     0.150
    45.180   496.445     0.150
    45.180     7.398     0.150
    45.180    16.898     0.150
    45.180   899.047     0.150
    45.241   892.047     0.150
    45.241   495.844     0.150
    45.241   892.047     0.150
    45.241  1084.844     0.150
    45.568   498.945     0.150
    45.595   498.945     0.150
    46.542   506.750     0.150
    46.777     4.797     0.150
    46.777   524.047     0.150
    46.777   552.047     0.150
    47.844   516.844     0.150
    47.844   633.047     0.150
    47.969   933.047     0.150
    48.767    13.000     0.150
    48.767   522.047     0.150
    48.767     7.000     0.150
    48.767    13.000     0.150
    48.767   941.047     0.150
    49.034    15.797     0.150
    49.034   557.047     0.150
    49.034   571.047     0.150
    49.034   525.250     0.150
    49.034    15.797     0.150
    49.161    13.703     0.150
    50.236   535.148     0.150
    50.236   967.047     0.150
    50.268   536.047     0.150
    50.268   967.047     0.150
    50.564   541.844     0.150
    50.564   579.945     0.150
    50.576   542.250     0.150
    50.576   551.047     0.150
    50.576   537.844     0.150
    50.576    13.203     0.150
    50.678   546.047     0.150
    50.917   545.047     0.150
    50.917  1261.047     0.150
    51.147   540.844     0.150
    51.147   616.750     0.150
    51.147   976.047     0.150
    51.260   546.648     0.150
    51.260   554.945     0.150
    51.260   565.445     0.150
    51.260   542.047     0.150
    51.260    12.898     0.150
    51.296    13.703     0.150
    51.296   542.344     0.150
    51.296    13.703     0.150
    51.376   543.250     0.150
    51.376   982.047     0.150
     2.514   544.148     0.150
    51.759   545.547     0.150
    51.925   547.648     0.150
    52.066   553.047     0.150
    52.066   548.750     0.150
    52.066   553.047     0.150
    52.066   989.047     0.150
    52.066   548.750     0.150
    52.529   551.344     0.150
    52.529   551.344     0.150
    52.862   553.750     0.150
    53.190   571.047     0.150
    53.504   554.047     0.150
    54.918   575.047     0.150
    54.929   574.047     0.150
    55.074   569.445     0.150
    55.074  1029.047     0.150
    55.618   579.250     0.150
    55.647   579.047     0.150
    60.214   606.047     0.150
    60.243   666.547     0.150
    60.398   605.047     0.150
    60.398  1097.047     0.150
    61.534   614.750     0.150
     2.180   616.250     0.150
     2.180   656.250     0.150
     2.180   744.945     0.150
    63.257   631.047     0.150
    65.222   645.547     0.150
    66.352   664.547     0.150
    66.352   647.047     0.150
    66.352   664.547     0.150
    66.352    28.602     0.150
    66.352  1175.047     0.150
     1.312   652.047     0.150
    73.419   680.844     0.150
    74.135   695.750     0.150
    76.335   708.250     0.150
    76.335  1281.047     0.150
   118.734  1128.047     0.150
   120.917  1129.750     0.150
   120.917  1129.750     0.150
   145.951  1180.047     0.150
   148.939  1218.547     0.150
     1.015    27.803     0.150
     2.501    68.303     0.150
     8.926   216.803     0.150
     9.393   239.803     0.150
    11.163   165.103     0.150
    12.863   185.603     0.150
    12.863   321.103     0.150
    12.918   192.803     0.150
    12.918   334.803     0.150
    13.024   183.803     0.150
    13.024   240.303     0.150
    13.024   328.803     0.150
    16.881   514.803     0.150
    21.103   286.803     0.150
     0.982    28.160     0.150
     0.982    82.559     0.150
     1.294    46.160     0.150
     5.142   138.859     0.150
     6.179    99.758     0.150
     8.853   144.961     0.150
     8.945   228.359     0.150
    11.135   153.359     0.150
    12.845   342.359     0.150
    13.018   207.859     0.150
    13.018   327.359     0.150
    13.096   330.359     0.150
    14.738   222.859     0.150
    16.873   234.359     0.150
    16.873   404.359     0.150
    25.783   329.359     0.150
    53.701   560.359     0.150
    57.314   582.359     0.150
    57.730   593.961     0.150
     1.032   626.160     0.150
     0.426    18.469     0.150
     2.145    68.867     0.150
     3.105   100.070     0.150
     5.110    99.773     0.150
     5.544    85.172     0.150
     5.544   147.867     0.150
     5.539   166.969     0.150
    10.277   260.570     0.150
    11.732   169.570     0.150
    11.732   299.570     0.150
    12.559   180.172     0.150
    12.559   187.367     0.150
    12.559   306.570     0.150
    12.559   316.570     0.150
    12.839   311.172     0.150
    12.995   172.570     0.150
    12.995   188.570     0.150
    12.995   318.570     0.150
    12.995   346.070     0.150
    12.952   191.969     0.150
    12.952   200.070     0.150
    12.952   340.070     0.150
    13.803   200.570     0.150
    13.803   350.070     0.150
    13.803   361.570     0.150
    13.803   407.070     0.150
    20.088   720.570     0.150
    29.207   358.773     0.150
    38.094     8.602     0.150
    49.034   527.773     0.150
    50.233   540.773     0.150
    51.084   546.469     0.150
    52.601   558.570     0.150
    52.930   559.773     0.150
    53.495   562.570     0.150
    54.421   571.570     0.150
    62.474   621.672     0.150
     1.006    43.266     0.150
     2.133    42.266     0.150
     4.252    76.664     0.150
     5.750   148.266     0.150
    10.581   157.266     0.150
    12.254   305.867     0.150
    12.910   321.766     0.150
    12.962   179.465     0.150
    46.382   503.266     0.150
    73.001   691.266     0.150
    86.625   763.465     0.150
     5.981   148.668     0.150
     8.903   208.668     0.150
    10.618   155.168     0.150
    10.618   276.168     0.150
    13.008   323.668     0.150
    13.888   203.668     0.150
    13.888   217.668     0.150
    13.888   351.168     0.150
    13.888   362.668     0.150
    14.926     8.900     0.150
    19.055   501.468     0.150
    28.325   358.668     0.150
    38.688   449.668     0.150
    46.369   505.468     0.150
    50.475   535.568     0.150
    51.995   547.568     0.150
    52.324   548.668     0.150
    52.324   548.668     0.150
    53.246   558.668     0.150
    61.356   613.468     0.150
    75.142   694.868     0.150
     2.535    52.951     0.150
     5.754   155.951     0.150
    11.074   161.051     0.150
    11.799  -102.350     0.150
    12.659   175.252     0.150
    12.659   307.951     0.150
    12.659   323.951     0.150
    12.739   174.951     0.150
    12.693   321.951     0.150
    15.099   215.650     0.150
    15.099     5.801     0.150
    16.541   230.951     0.150
    16.541   230.951     0.150
    44.386   493.752     0.150
    46.922   510.451     0.150
    49.828   532.252     0.150
    52.559    18.201     0.150
    52.559   552.551     0.150
    52.559    18.201     0.150
    52.628   554.150     0.150
    53.659   560.551     0.150
    87.026   763.252     0.150
    87.026   763.551     0.150
     2.940    54.312     0.150
     3.866    63.109     0.150
     4.906    77.109     0.150
     4.906   100.109     0.150
     4.906   135.109     0.150
     4.906   164.109     0.150
     5.978    84.109     0.150
     5.978   147.109     0.150
     7.095   106.109     0.150
     9.355   240.711     0.150
     9.707   247.109     0.150
    10.963   157.109     0.150
    10.963   279.109     0.150
    12.160   242.109     0.150
    12.301   174.406     0.150
    12.301   305.508     0.150
    12.280   179.609     0.150
    12.566   303.109     0.150
    12.566   171.109     0.150
    12.729   306.109     0.150
    12.921   179.109     0.150
    12.921   179.109     0.150
    12.921   320.109     0.150
    13.103   185.109     0.150
    13.103   326.109     0.150
    13.527   190.109     0.150
    13.527   200.109     0.150
    14.750   204.109     0.150
    14.883   220.109     0.150
    14.883   220.109     0.150
    15.308     9.500     0.150
    17.399   234.109     0.150
    17.399   418.109     0.150
    18.703    10.305     0.150
    18.703    15.703     0.150
    19.498   477.109     0.150
    20.695     5.500     0.150
    20.695   503.109     0.150
    21.964   307.109     0.150
    21.964   307.109     0.150
    23.991   312.312     0.150
    24.553   318.109     0.150
    26.469   613.109     0.150
    26.945   614.109     0.150
    26.945   340.109     0.150
    26.945   614.109     0.150
    30.903   387.508     0.150
    30.903   414.312     0.150
    30.903   376.109     0.150
    60.530   356.609     0.150
    39.899   455.109     0.150
    40.224     5.000     0.150
    40.224   612.109     0.150
    40.224  1503.109     0.150
    40.224   455.109     0.150
    45.443   494.109     0.150
    45.443   891.109     0.150
    45.443   494.508     0.150
    45.443   891.109     0.150
    45.443   904.109     0.150
    47.602   514.211     0.150
    47.602   514.211     0.150
    47.934   516.508     0.150
    49.489   955.109     0.150
    49.489   528.109     0.150
    49.489   955.109     0.150
    49.489   968.109     0.150
    50.458   542.406     0.150
    50.458    13.398     0.150
    50.458   536.109     0.150
    52.727   552.109     0.150
    53.255   559.812     0.150
    53.255    15.000     0.150
    53.255   556.312     0.150
    53.255   559.812     0.150
    53.255    11.195     0.150
    53.255    15.000     0.150
    53.255   556.312     0.150
    53.354   557.711     0.150
    54.353    15.398     0.150
    54.893   567.609     0.150
    56.218   576.406     0.150
    56.790   582.109     0.150
    60.114   604.906     0.150
    63.950   642.109     0.150
    67.737   653.812     0.150
    87.405   764.109     0.150
    87.405   764.211     0.150
    87.405   768.812     0.150
    87.405   773.211     0.150
     0.762    22.727     0.150
     1.727    54.727     0.150
     2.135    43.328     0.150
     2.474    42.727     0.150
     2.474    75.227     0.150
     5.602    91.828     0.150
     6.596   107.727     0.150
     6.596   171.727     0.150
     9.006   227.227     0.150
     9.006   130.430     0.150
     9.006   227.227     0.150
     9.039   233.727     0.150
    10.228   147.727     0.150
    10.228   271.727     0.150
    10.228   147.727     0.150
    10.228   271.727     0.150
    10.301   147.430     0.150
    10.301   262.930     0.150
    10.749   163.523     0.150
    10.891   280.727     0.150
    10.891   157.328     0.150
    10.891   280.727     0.150
    11.432   278.727     0.150
    12.506   178.727     0.150
    12.579   319.727     0.150
    12.579   319.727     0.150
    12.657   181.227     0.150
    12.657   323.727     0.150
    12.969   185.227     0.150
    12.969   194.727     0.150
    12.969   330.727     0.150
    12.969   345.727     0.150
    12.988   185.227     0.150
    12.988   330.727     0.150
    13.043   183.523     0.150
    13.043   183.523     0.150
    13.043   321.727     0.150
    13.109   183.727     0.150
    13.109   326.727     0.150
    13.280   323.727     0.150
    13.280   359.727     0.150
    13.280  2361.727     0.150
    13.619   187.727     0.150
    14.028   194.727     0.150
    14.028   204.727     0.150
    14.028   348.727     0.150
    14.028   348.727     0.150
    14.655   202.727     0.150
    14.832   208.328     0.150
    15.858   218.727     0.150
    15.858   391.727     0.150
    17.020   411.727     0.150
    18.101   438.227     0.150
    18.315   252.727     0.150
    18.315   447.727     0.150
    19.224    10.398     0.150
    19.224   471.727     0.150
    20.192   275.727     0.150
    20.192   499.727     0.150
    20.651   279.727     0.150
    20.651   509.727     0.150
    21.557     6.203     0.150
    21.557     9.203     0.150
    21.557   529.727     0.150
    21.557   558.727     0.150
    21.784   519.727     0.150
    21.784   291.227     0.150
    21.784   519.727     0.150
    21.877     5.500     0.150
    21.877   525.727     0.150
    22.199   290.727     0.150
    22.199    24.000     0.150
    22.199   526.727     0.150
    23.134   551.727     0.150
    23.134   305.727     0.150
    23.134   551.727     0.150
    23.137   305.523     0.150
    23.137   348.727     0.150
    23.137   556.727     0.150
    24.148    11.500     0.150
    24.148   385.727     0.150
    24.745   323.727     0.150
    24.745   330.227     0.150
    25.334   338.727     0.150
    25.347   329.727     0.150
    25.521   331.727     0.150
    25.613    11.203     0.150
    25.613   383.727     0.150
    25.613   657.727     0.150
    25.613   851.727     0.150
    26.282   336.727     0.150
    26.282   600.727     0.150
    26.560   338.625     0.150
    26.823   340.727     0.150
    26.823   617.727     0.150
    27.089    12.500     0.150
    27.089   392.727     0.150
    27.089   405.227     0.150
    27.672   351.227     0.150
    27.672   351.227     0.150
    27.672   411.727     0.150
    27.672   631.227     0.150
    27.672   707.727     0.150
    28.018   351.727     0.150
    28.018   638.727     0.150
    28.287   641.727     0.150
    28.467     9.203     0.150
    28.467   377.727     0.150
    28.467   459.727     0.150
    28.467   578.727     0.150
    28.467   607.727     0.150
    28.467   815.727     0.150
    28.467   355.523     0.150
    28.467     9.203     0.150
    28.467   415.727     0.150
    28.467   645.727     0.150
    28.467   725.727     0.150
    28.566   638.727     0.150
    28.983   643.727     0.150
    28.983   360.727     0.150
    28.983   643.727     0.150
    29.005   361.727     0.150
    29.005   423.727     0.150
    29.040   366.727     0.150
    29.199   533.727     0.150
    29.199   773.227     0.150
    29.325   660.727     0.150
    29.325   676.727     0.150
    29.325   363.227     0.150
    29.325   418.727     0.150
    29.325   660.727     0.150
    29.325   676.727     0.150
    29.333   649.727     0.150
    29.333   363.727     0.150
    29.333   433.727     0.150
    29.333   649.727     0.150
    29.378   436.727     0.150
    29.378   655.523     0.150
    29.378   655.523     0.150
    29.378   767.727     0.150
    30.104   441.227     0.150
    30.104   728.727     0.150
    30.104   758.727     0.150
    30.104   812.125     0.150
    30.396   665.727     0.150
    31.072   377.727     0.150
    31.072   445.727     0.150
    31.072   681.727     0.150
    31.317    10.000     0.150
    31.317   380.680     0.150
    31.317   380.828     0.150
    31.317    10.000     0.150
    31.317   688.430     0.150
    32.291    10.602     0.150
    32.291   700.727     0.150
    32.658   705.328     0.150
    33.171   711.727     0.150
    33.171   395.727     0.150
    33.171   711.727     0.150
    33.358   399.727     0.150
    33.358   717.727     0.150
    33.358   843.727     0.150
    34.092    10.398     0.150
    35.175   413.227     0.150
    35.175   495.727     0.150
    35.175   740.727     0.150
    35.832    10.000     0.150
    35.873     1.734     0.150
    35.873   424.594     0.150
    35.873   420.906     0.150
    36.274   422.930     0.150
    36.828   454.125     0.150
    37.379    10.000     0.150
    37.531   435.727     0.150
    37.531   779.727     0.150
    38.019     1.914     0.150
    38.019     9.359     0.150
    38.169   785.727     0.150
    38.169   439.727     0.150
    38.169   567.727     0.150
    38.169   785.727     0.150
    38.169   951.727     0.150
    38.260     1.320     0.150
    38.484   470.727     0.150
    38.484   558.727     0.150
    38.484   580.727     0.150
    38.484   791.727     0.150
    38.484   985.727     0.150
    38.484  1035.727     0.150
    38.484   442.414     0.150
    38.484   442.430     0.150
    38.484   528.727     0.150
    38.484   558.727     0.150
    38.484   580.727     0.150
    38.484   791.727     0.150
    38.484   955.727     0.150
    38.484   985.727     0.150
    39.082   794.727     0.150
    39.082   446.727     0.150
    39.082   559.727     0.150
    39.082   794.727     0.150
    39.082   962.727     0.150
    40.299   462.227     0.150
    40.727   607.727     0.150
    40.727   967.727     0.150
    40.797   465.125     0.150
    41.057   467.727     0.150
    41.057   847.727     0.150
    41.100   492.727     0.150
    41.411   465.727     0.150
    41.411   839.727     0.150
    41.411  1020.727     0.150
    41.869    10.500     0.150
    41.869  1023.727     0.150
    41.913   463.727     0.150
    42.062   482.727     0.150
    42.062   520.727     0.150
    42.578   576.727     0.150
    43.067   877.727     0.150
    43.069   473.727     0.150
    43.144   867.727     0.150
    43.144   479.727     0.150
    43.144   583.727     0.150
    43.144   867.727     0.150
    43.305   866.727     0.150
    43.537   484.727     0.150
    43.537   625.227     0.150
    43.537   873.727     0.150
    43.537  1051.727     0.150
    43.964   496.727     0.150
    44.064   483.727     0.150
    44.809   494.727     0.150
    44.809   642.727     0.150
    44.809   890.727     0.150
    45.194     9.102     0.150
    45.194   571.727     0.150
    45.194   574.727     0.150
    45.194   642.727     0.150
    45.194   880.727     0.150
    45.194   902.727     0.150
    45.194  1056.727     0.150
    45.194  1092.727     0.150
    45.194  1156.727     0.150
    45.194   495.625     0.150
    45.194     9.102     0.150
    45.194   642.727     0.150
    45.194   902.727     0.150
    45.194  1092.727     0.150
    45.225   492.727     0.150
    45.419   897.727     0.150
    45.419   497.625     0.150
    45.419   897.727     0.150
    45.465   503.727     0.150
    45.763   505.727     0.150
    45.875   497.727     0.150
    45.891   900.727     0.150
    45.891   502.727     0.150
    45.891   900.727     0.150
    46.233  1175.727     0.150
    46.732   528.227     0.150
    46.732   634.727     0.150
    46.732   917.227     0.150
    46.732  1011.727     0.150
    46.732  1027.227     0.150
    46.732  1147.727     0.150
    46.871   615.727     0.150
    46.871   915.727     0.150
    47.251   663.125     0.150
    47.251   514.227     0.150
    47.251   619.023     0.150
    47.460     1.594     0.150
    47.460   531.328     0.150
    47.460   923.727     0.150
    47.460   513.930     0.150
    47.460     5.000     0.150
    47.460    17.398     0.150
    47.460   923.727     0.150
    48.090    13.898     0.150
    48.090   538.727     0.150
    48.090   559.727     0.150
    48.090   577.727     0.150
    48.090   598.727     0.150
    48.476   509.727     0.150
    48.516   633.727     0.150
    48.516   939.727     0.150
    48.516  1155.727     0.150
    48.516   522.898     0.150
    48.558   619.023     0.150
    48.558   524.328     0.150
    48.558   638.523     0.150
    48.876   939.727     0.150
    48.876   524.727     0.150
    48.876   939.727     0.150
    48.876   949.727     0.150
    48.876   965.727     0.150
    49.058   530.727     0.150
    49.133   526.523     0.150
    49.133   950.727     0.150
    49.673   927.930     0.150
    49.874   659.727     0.150
    49.874   690.328     0.150
    49.874   533.430     0.150
    49.874     5.398     0.150
    49.874   650.430     0.150
    49.874   957.727     0.150
    50.650   539.727     0.150
    50.650   975.727     0.150
    50.989    17.102     0.150
    50.989   541.125     0.150
    50.989    17.102     0.150
    50.989   719.727     0.150
    50.989   975.727     0.150
    51.056   987.727     0.150
    51.278   545.727     0.150
    51.278   545.727     0.150
    51.278   552.727     0.150
    51.278   552.727     0.150
    51.278   592.727     0.150
    51.278   592.727     0.150
    51.278   666.727     0.150
    51.278   698.727     0.150
    51.278   698.727     0.150
    51.278   863.727     0.150
    51.278   979.727     0.150
    51.278  1195.727     0.150
    51.278  3306.727     0.150
    51.278   543.727     0.150
    51.278     9.203     0.150
    51.278   979.727     0.150
    51.278   628.727     0.150
    51.349   674.023     0.150
    51.568   544.023     0.150
    51.568    14.000     0.150
    51.568   560.125     0.150
    51.626   592.430     0.150
    51.626   652.625     0.150
    51.718   540.828     0.150
    51.847   630.727     0.150
    51.847   709.727     0.150
    51.847   750.727     0.150
    51.847   774.727     0.150
    51.847  2391.727     0.150
    51.847   547.828     0.150
    51.847   630.523     0.150
    51.847   669.727     0.150
    51.847   709.727     0.150
    51.847   750.727     0.150
    51.847   774.727     0.150
    51.847   989.727     0.150
    51.847  1133.727     0.150
    51.847  1192.727     0.150
    51.847  2391.727     0.150
    51.847   547.828     0.150
    51.847   617.227     0.150
    51.847   989.727     0.150
    51.847  1321.727     0.150
    51.976     5.500     0.150
    51.976   568.828     0.150
    51.976   548.828     0.150
    51.976     5.500     0.150
    52.054   590.227     0.150
    52.054  1143.727     0.150
    52.083   549.773     0.150
     2.649   550.828     0.150
    52.414   551.727     0.150
    52.530  1389.828     0.150
    52.768  1006.727     0.150
    52.768   555.328     0.150
    52.768   585.727     0.150
    52.768   595.727     0.150
    52.768   679.727     0.150
    52.768  1006.727     0.150
    52.768  1230.727     0.150
    52.768  1273.727     0.150
    52.768  1503.727     0.150
    52.768   555.328     0.150
    52.768  1006.727     0.150
    52.948   552.727     0.150
    53.108   558.328     0.150
    53.108  1010.727     0.150
    53.111     5.297     0.150
    53.111   661.828     0.150
    53.111   556.727     0.150
    53.111     5.297     0.150
    53.111   681.930     0.150
    53.111   998.930     0.150
    53.111  1010.328     0.150
    53.142     5.500     0.150
    53.142     9.398     0.150
    53.142   556.727     0.150
    53.142     9.398     0.150
    53.582   562.148     0.150
    53.582     2.969     0.150
    53.582   568.023     0.150
    53.582   560.500     0.150
    54.745   569.727     0.150
    54.745  1029.727     0.150
    54.827   569.945     0.150
    54.971   570.227     0.150
    54.971   771.727     0.150
    54.971  1025.727     0.150
    55.624   575.727     0.150
    55.903   581.727     0.150
    56.331   579.523     0.150
    56.347   580.828     0.150
    56.577   575.477     0.150
    56.609    25.000     0.150
    56.609   775.727     0.150
    56.609  1047.727     0.150
    56.609  1123.727     0.150
    56.609  1339.727     0.150
    56.609   582.727     0.150
    56.609   715.727     0.150
    56.609  1047.727     0.150
    57.820     1.398     0.150
    57.820   684.023     0.150
    57.820   806.430     0.150
    59.196   605.727     0.150
    60.201  1099.727     0.150
    60.201   605.727     0.150
    60.201   836.727     0.150
    60.201  1099.727     0.150
    60.759   621.328     0.150
    60.917   607.625     0.150
    62.071   620.578     0.150
    62.165   638.727     0.150
    62.165  1088.727     0.150
    62.796   621.727     0.150
    63.884   636.727     0.150
    65.523  1171.727     0.150
    65.881   883.727     0.150
    65.945   647.805     0.150
     0.591   648.227     0.150
     0.591   675.727     0.150
    66.399   648.227     0.150
    66.399   891.727     0.150
    66.399  1173.727     0.150
    66.785   653.727     0.150
    66.785   659.727     0.150
    67.221   657.930     0.150
    67.361  1173.727     0.150
    69.149     2.500     0.150
    69.885   672.430     0.150
    70.048   797.625     0.150
    70.983   724.227     0.150
    71.867   714.727     0.150
    73.037   688.766     0.150
    73.059   679.727     0.150
    75.010   709.625     0.150
    75.041   712.930     0.150
    75.622   705.023     0.150
    75.622  1282.930     0.150
    75.622   705.023     0.150
    75.622  1282.930     0.150
    77.544   720.930     0.150
    80.110   747.727     0.150
    80.110   931.727     0.150
    80.110  1659.727     0.150
    80.158   729.625     0.150
     1.722   730.523     0.150
    80.593   741.727     0.150
    80.593   931.727     0.150
    80.593  1669.727     0.150
    86.457   761.227     0.150
    93.366  1042.727     0.150
    93.725     3.000     0.150
    97.606   815.727     0.150
    97.606   821.727     0.150
    97.606  1183.727     0.150
    97.606  1496.727     0.150
    98.740    18.000     0.150
   102.161  1577.414     0.150
   102.161  1641.430     0.150
   104.742  1696.914     0.150
   104.817   853.727     0.150
   109.263   873.688     0.150
   109.757   883.727     0.150
   109.798   869.727     0.150
   109.798  1141.727     0.150
   109.798  1773.727     0.150
   110.879   883.727     0.150
   110.916  1754.227     0.150
   111.615   884.727     0.150
   111.615  1094.727     0.150
   111.615  1121.727     0.150
   111.615  1128.727     0.150
   111.615  1145.727     0.150
   111.615  1168.727     0.150
   111.615  1200.727     0.150
   111.615  1246.727     0.150
   111.615  1273.727     0.150
   111.615  1291.727     0.150
   111.615  1309.727     0.150
   111.615  1337.727     0.150
   111.615  1363.727     0.150
   111.615  1368.727     0.150
   111.615  1445.727     0.150
   111.615  1472.727     0.150
   111.615  1491.727     0.150
   111.615  1503.727     0.150
   111.615   884.727     0.150
   111.615  1158.727     0.150
   112.702  1119.727     0.150
   113.492  1081.727     0.150
   113.492  1135.727     0.150
   113.492  1430.727     0.150
   113.492  1945.625     0.150
   113.492  2123.727     0.150
   113.691  1089.227     0.150
   113.708  1043.727     0.150
   113.708  1624.727     0.150
   113.962  1315.430     0.150
   114.058  1082.328     0.150
   114.381   878.719     0.150
   114.464  1088.727     0.150
   114.464  1157.023     0.150
   114.464  1276.227     0.150
   114.464  1976.523     0.150
   114.467  1088.727     0.150
   114.467  1133.727     0.150
   114.467  1156.727     0.150
   114.467  1303.727     0.150
   114.467  1419.727     0.150
   114.467  1823.727     0.150
   114.467  2171.727     0.150
   114.467   890.227     0.150
   114.467  1174.727     0.150
   114.467  1527.727     0.150
   114.467  1747.727     0.150
   114.467  1823.727     0.150
     0.501  1122.727     0.150
   115.247  1124.727     0.150
   117.726  1148.727     0.150
   117.726  1191.727     0.150
   119.394  1785.727     0.150
   119.394  1883.727     0.150
   119.394  2161.727     0.150
   120.581  1134.930     0.150
   120.581  1134.930     0.150
   121.454  1138.727     0.150
   123.823  1132.227     0.150
   127.926  1153.227     0.150
   128.140  1161.727     0.150
   130.864  1139.430     0.150
   131.387  1169.227     0.150
   132.245  1158.930     0.150
   135.082  1173.727     0.150
   135.347  1827.727     0.150
   135.410  1154.125     0.150
   136.287  1151.727     0.150
   138.281  1157.539     0.150
   138.665  1158.484     0.150
   140.555  1162.727     0.150
   143.602  1403.727     0.150
   143.602  1976.727     0.150
   146.551  2002.727     0.150
   146.551  2455.727     0.150
     2.073    25.867     0.150
     2.073    44.867     0.150
     5.627    92.768     0.150
     6.679   168.367     0.150
     6.922    96.467     0.150
     9.309   229.867     0.150
    10.198   141.867     0.150
    10.198   251.867     0.150
    10.185   149.867     0.150
    12.722   180.867     0.150
    12.722   323.367     0.150
    13.019   187.367     0.150
    13.019   322.867     0.150
    13.032   185.867     0.150
    13.032   387.867     0.150
    13.350   337.867     0.150
    14.081   350.867     0.150
    14.081   367.367     0.150
    21.572    17.900     0.150
     1.836    39.748     0.150
     1.796    23.748     0.150
     1.796    97.748     0.150
     5.593    90.549     0.150
     8.987   227.947     0.150
    10.170   268.248     0.150
    10.809   280.148     0.150
    10.842   155.148     0.150
    10.842   270.748     0.150
    11.262   159.748     0.150
    11.262   280.748     0.150
    11.670   166.748     0.150
    11.670   289.748     0.150
    12.455   315.549     0.150
    12.455   315.549     0.150
    12.725   180.748     0.150
    12.725   323.748     0.150
    12.984   329.748     0.150
    12.997   329.748     0.150
    13.318   321.248     0.150
    13.318   334.748     0.150
    13.674   187.748     0.150
    13.674   334.748     0.150
    14.046   356.748     0.150
    18.246   255.748     0.150
    19.628   267.748     0.150
    19.628   484.748     0.150
    21.491   285.049     0.150
    21.597     7.500     0.150
    21.597    10.500     0.150
    21.940   294.348     0.150
    23.084   303.748     0.150
    23.110   304.549     0.150
    23.110   556.748     0.150
    23.110   304.549     0.150
    23.110   556.748     0.150
    24.707   323.748     0.150
    25.659     7.600     0.150
    26.826   339.447     0.150
    36.271   421.848     0.150
    38.103   437.748     0.150
    38.103     8.000     0.150
    38.418   460.748     0.150
    38.418   439.947     0.150
    38.418   526.748     0.150
    38.884    15.000     0.150
    45.861   500.748     0.150
    51.473   543.248     0.150
    59.093   598.748     0.150
    77.614   713.748     0.150
    77.614   801.748     0.150
    77.988   716.947     0.150
     2.445    47.348     0.150
    10.138   163.148     0.150
    12.749   317.348     0.150
    13.303   317.848     0.150
     0.770    18.559     0.150
     0.770    29.559     0.150
     2.187    70.559     0.150
     5.560   152.559     0.150
     9.094   133.957     0.150
     9.094   133.957     0.150
    10.266   150.359     0.150
    10.266   283.559     0.150
    11.760   163.559     0.150
    11.760   285.559     0.150
    12.604   314.059     0.150
    12.939   329.059     0.150
    12.562   180.559     0.150
    12.962   185.059     0.150
    12.962   329.559     0.150
    12.962   178.559     0.150
    13.234   332.059     0.150
    13.562   176.559     0.150
    13.562   314.559     0.150
    13.995   202.559     0.150
    13.995   357.559     0.150
    17.074   225.559     0.150
    19.709   269.359     0.150
    19.709   490.559     0.150
    20.412   494.160     0.150
    20.412   517.859     0.150
    21.538     9.500     0.150
    21.538    15.000     0.150
    21.728   285.559     0.150
    24.779     7.602     0.150
    25.588     6.602     0.150
    26.838   341.258     0.150
    38.849    10.301     0.150
    39.126   447.160     0.150
    45.985   503.359     0.150
    46.245   503.359     0.150
    46.293   505.559     0.150
    51.599   546.059     0.150
    61.214   614.859     0.150
    86.499   760.957     0.150
     7.979   122.617     0.150
     9.130   140.812     0.150
    12.606   305.914     0.150
    13.888   343.617     0.150
    24.296    10.500     0.150
    47.706   514.914     0.150
    87.085   763.812     0.150
     2.571    39.664     0.150
     2.571    69.664     0.150
     5.799    85.064     0.150
     5.799   151.264     0.150
     9.204   229.164     0.150
    10.515   150.564     0.150
    10.515   279.164     0.150
    12.988   178.164     0.150
    12.672   327.164     0.150
    12.672   178.164     0.150
    12.672   327.164     0.150
    13.193   194.664     0.150
    13.193   179.664     0.150
    13.193   322.164     0.150
    17.320   229.164     0.150
    19.035     8.000     0.150
    21.324    10.000     0.150
    21.324    18.500     0.150
    21.579    14.000     0.150
    23.294   303.664     0.150
    24.348   577.664     0.150
    24.348   314.164     0.150
    24.348   577.664     0.150
    25.363    12.000     0.150
    26.491   335.264     0.150
    31.454   378.164     0.150
    38.737   442.164     0.150
    38.729   439.564     0.150
    38.729    12.900     0.150
    45.382   494.164     0.150
    46.472   504.264     0.150
    51.783   544.863     0.150
    51.848   548.465     0.150
    72.722   683.764     0.150
    72.722    15.100     0.150
    73.119   686.465     0.150
    73.119    12.500     0.150
    75.339   701.863     0.150
     3.266    48.049     0.150
     8.351   116.049     0.150
     9.185   229.049     0.150
    10.320   145.248     0.150
    10.320   145.248     0.150
    10.320   152.049     0.150
    10.320   154.049     0.150
    10.320   157.049     0.150
    10.320   161.049     0.150
    10.320   271.049     0.150
    10.320   273.049     0.150
    10.320   511.049     0.150
    11.817   379.049     0.150
    11.817   435.049     0.150
    12.558   303.049     0.150
    12.558   173.549     0.150
    12.558   303.049     0.150
    13.665   191.549     0.150
    13.772   204.049     0.150
    13.772   204.049     0.150
    13.772   345.049     0.150
    15.008   210.648     0.150
    15.008     5.000     0.150
    16.470  1416.049     0.150
    18.422   252.549     0.150
    20.008   490.850     0.150
    20.014   272.248     0.150
    20.211   275.049     0.150
    20.211   275.049     0.150
    20.211   495.049     0.150
    20.211   506.049     0.150
    20.444   277.350     0.150
    20.444   300.049     0.150
    20.444   533.049     0.150
    20.444   277.350     0.150
    20.444   -13.000     0.150
    20.444   300.049     0.150
    20.444   502.049     0.150
    20.444   515.049     0.150
    20.444   533.049     0.150
    21.025   303.049     0.150
    21.968   294.049     0.150
    21.968   535.049     0.150
    24.360   316.049     0.150
    25.004   581.248     0.150
    25.004   322.248     0.150
    25.004   358.049     0.150
    25.004   581.248     0.150
    26.642   339.449     0.150
    26.642   613.049     0.150
    27.122   346.049     0.150
    27.122   623.049     0.150
    28.354    14.000     0.150
    28.354   354.049     0.150
    28.354     7.000     0.150
    28.354    14.000     0.150
    28.669   361.248     0.150
    28.669   645.049     0.150
    28.598   360.248     0.150
    30.026   659.049     0.150
    30.347   778.049     0.150
    30.347   371.049     0.150
    30.347   672.049     0.150
    30.347   778.049     0.150
    30.697   375.549     0.150
    30.697     9.500     0.150
    30.697    12.500     0.150
    30.697   375.549     0.150
    30.697     9.500     0.150
    30.697   388.049     0.150
    30.697   677.049     0.150
    30.697   775.049     0.150
    30.697  1007.049     0.150
    30.734   785.049     0.150
    30.734   376.049     0.150
    30.734     8.500     0.150
    30.734   436.549     0.150
    30.734   677.049     0.150
    30.734   785.049     0.150
    31.140   379.049     0.150
    31.140   379.049     0.150
    31.140   677.049     0.150
    31.152   677.049     0.150
    31.152   756.049     0.150
    31.152   815.049     0.150
    31.973   387.049     0.150
    31.973   457.049     0.150
    31.973   701.049     0.150
    32.853   394.049     0.150
    32.836   393.350     0.150
    32.836   709.049     0.150
    32.884   391.850     0.150
    33.082   711.850     0.150
    33.082   395.850     0.150
    33.082   711.850     0.150
    33.086   399.248     0.150
    33.994   729.549     0.150
    34.799   735.049     0.150
    34.874   412.049     0.150
    35.127   904.049     0.150
    35.127   415.049     0.150
    35.127   562.049     0.150
    35.127   904.049     0.150
    35.127  1027.049     0.150
    36.218   423.148     0.150
    36.472   762.049     0.150
    38.032   438.049     0.150
    38.032    10.000     0.150
    38.032   789.049     0.150
    38.125   971.049     0.150
    39.635   437.318     0.150
    39.791   554.049     0.150
    39.791   452.049     0.150
    39.791   554.049     0.150
    39.791   816.049     0.150
    40.122     9.000     0.150
    40.122   559.049     0.150
    40.122   455.049     0.150
    40.122     9.000     0.150
    40.122   559.049     0.150
    40.122   819.049     0.150
    41.071   463.049     0.150
    41.071   829.049     0.150
    41.523   468.049     0.150
    41.523   635.049     0.150
    42.995   866.049     0.150
    43.166    16.000     0.150
    43.166   594.049     0.150
    43.166   480.049     0.150
    43.166     5.000     0.150
    43.166    16.000     0.150
    43.166   577.049     0.150
    43.166   594.049     0.150
    43.166   865.049     0.150
    44.663   494.049     0.150
     0.594   492.850     0.150
    44.879   495.049     0.150
    44.879   890.049     0.150
    44.879  1085.049     0.150
    45.141   591.049     0.150
    45.141   642.049     0.150
    45.141   905.049     0.150
    45.141  1089.049     0.150
    45.141   495.850     0.150
    45.141   591.049     0.150
    45.141   602.049     0.150
    45.141   642.049     0.150
    45.141   895.049     0.150
    45.141   905.049     0.150
    45.141  1089.049     0.150
    46.542   913.049     0.150
    46.542   507.049     0.150
    46.542   913.049     0.150
    46.562  1107.949     0.150
    46.562   507.148     0.150
    46.562     5.500     0.150
    46.562   618.648     0.150
    46.562   911.049     0.150
    46.562  1107.949     0.150
    47.222   510.049     0.150
    47.436   613.049     0.150
    47.436   889.049     0.150
    48.053   929.648     0.150
    48.981   522.549     0.150
    49.145   522.850     0.150
    49.191   545.549     0.150
    49.191   528.549     0.150
    49.191     5.600     0.150
    49.191    17.000     0.150
    49.191   955.049     0.150
    49.842   530.049     0.150
    49.842     3.000     0.150
    49.842    12.000     0.150
    50.287   535.549     0.150
    50.287   654.049     0.150
    50.287   966.049     0.150
    50.351    15.199     0.150
    50.351   574.350     0.150
    50.848     1.830     0.150
    51.619   545.049     0.150
    52.494   557.049     0.150
    52.663   558.949     0.150
    52.673    10.000     0.150
    52.673  1005.049     0.150
    52.673   553.748     0.150
    52.673    10.000     0.150
    52.673   625.748     0.150
    52.673  1005.049     0.150
    53.001   556.549     0.150
    53.025   558.350     0.150
    53.025     4.699     0.150
    53.025    12.000     0.150
    53.038    12.199     0.150
    53.182   560.449     0.150
    60.273   558.818     0.150
    53.364    12.000     0.150
    53.364   584.049     0.150
    53.364   621.049     0.150
    53.364   558.549     0.150
    53.364    12.000     0.150
    53.364   621.049     0.150
    53.364  1013.049     0.150
    53.430    12.680     0.150
    53.565   560.248     0.150
    53.565     4.500     0.150
    53.565   560.248     0.150
    60.273   561.139     0.150
    53.721   561.049     0.150
    53.852   567.148     0.150
     3.613   563.449     0.150
    54.079     0.881     0.150
    54.172   564.248     0.150
    54.188   569.049     0.150
    54.492   699.049     0.150
    54.492   567.648     0.150
    54.492     4.900     0.150
    54.492  1161.049     0.150
    54.496   567.449     0.150
    54.840   570.549     0.150
    54.840     5.000     0.150
    54.861     5.000     0.150
    54.861    12.100     0.150
    54.892     5.100     0.150
    54.892    15.900     0.150
    55.024   570.748     0.150
    55.156     5.000     0.150
    55.203   573.148     0.150
    55.209     5.100     0.150
    55.209    12.100     0.150
    55.330   572.549     0.150
    55.869   577.449     0.150
    56.088   578.350     0.150
    56.162    12.160     0.150
    57.036   584.148     0.150
    57.443   590.350     0.150
    57.621   591.449     0.150
    57.622   588.248     0.150
    57.747   591.639     0.150
    57.942   597.949     0.150
    57.945   598.449     0.150
    58.172   599.748     0.150
    58.273   593.049     0.150
    58.449   601.248     0.150
    58.360   593.549     0.150
    58.846   604.148     0.150
    58.990   599.049     0.150
     0.891   598.949     0.150
    60.223   606.049     0.150
    60.517   608.049     0.150
    62.358   620.049     0.150
    62.545   624.049     0.150
    62.895   624.049     0.150
    63.254   627.049     0.150
    63.837   636.219     0.150
    64.130  1153.049     0.150
    68.142   657.529     0.150
    68.787   672.049     0.150
    75.770   704.648     0.150
    77.163   713.049     0.150
    78.529   720.949     0.150
    78.672  1861.850     0.150
    80.389   729.549     0.150
     3.194   730.148     0.150
    82.897   743.248     0.150
    91.083  1004.850     0.150
   110.913  1125.049     0.150
   115.171  1119.549     0.150
     2.194    35.836     0.150
     2.194    62.836     0.150
     2.533    84.035     0.150
     2.508    81.438     0.150
     6.296   225.836     0.150
     9.687   135.336     0.150
     9.687   135.336     0.150
     9.687   135.336     0.150
     9.687   135.336     0.150
    10.117   151.234     0.150
    12.752   164.836     0.150
    12.752   307.637     0.150
    15.026   217.438     0.150
    20.999   292.836     0.150
    46.580    12.602     0.150
    46.676   509.637     0.150
    49.600    12.500     0.150
    52.366    12.598     0.150
    53.582   559.836     0.150
    53.582    11.801     0.150
    66.751    12.199     0.150
    74.825   703.938     0.150
    78.027   719.836     0.150
    86.887    12.500     0.150
     0.587    33.539     0.150
     0.587    56.320     0.150
     1.908    37.000     0.150
     2.193    70.699     0.150
     7.506   244.629     0.150
     7.506   244.699     0.150
     8.456   106.035     0.150
     8.467   126.289     0.150
     8.481   127.551     0.150
     8.535   128.949     0.150
     8.566   129.363     0.150
    12.984   179.000     0.150
    12.984   189.602     0.150
    12.984   427.719     0.150
    13.130   200.500     0.150
    13.326   320.801     0.150
    62.390   626.602     0.150
    72.973   689.199     0.150
    75.176   706.699     0.150
     5.966    88.867     0.150
     5.966    88.867     0.150
     5.966    88.867     0.150
     5.966    88.867     0.150
     5.966    97.984     0.150
     5.966    86.113     0.150
     5.966   162.457     0.150
     5.966   162.141     0.150
     5.966   165.605     0.150
     5.966   164.555     0.150
     5.966   154.594     0.150
     1.087    17.844     0.150
     1.087    33.441     0.150
     0.571    32.223     0.150
     1.895    56.242     0.150
     2.181    69.344     0.150
     2.609    48.742     0.150
     2.609    75.742     0.150
     5.141    78.242     0.150
     5.775   146.242     0.150
     5.812    89.742     0.150
     7.499   239.953     0.150
     7.499   240.391     0.150
     8.301   124.547     0.150
     8.438   120.332     0.150
     8.442   120.590     0.150
     8.437   124.473     0.150
     8.453   122.000     0.150
     8.471   101.633     0.150
     8.483   124.902     0.150
     8.497   119.512     0.150
     8.531   124.586     0.150
     8.550   122.793     0.150
     8.558   119.043     0.150
     8.545   124.832     0.150
     8.551   124.965     0.150
     8.576   123.715     0.150
     8.582   118.230     0.150
     8.583   120.031     0.150
     8.565   124.984     0.150
     8.590   121.660     0.150
     9.244   126.352     0.150
     9.244   237.133     0.150
     9.251   237.238     0.150
     9.263   134.664     0.150
     9.263   180.348     0.150
     9.316   239.148     0.150
     9.355   135.395     0.150
     9.355   238.629     0.150
     9.382   134.770     0.150
     9.382   239.223     0.150
     9.398   126.980     0.150
     9.398   239.500     0.150
    10.053   146.465     0.150
    10.725   157.664     0.150
    12.974   315.242     0.150
    21.222    12.500     0.150
    25.248     6.199     0.150
    38.882   441.742     0.150
    62.374   623.742     0.150
     5.956    96.285     0.150
     5.956    87.547     0.150
     5.956    87.547     0.150
     5.956    84.008     0.150
     5.956    96.055     0.150
     5.956    93.531     0.150
     1.633    44.703     0.150
     1.827    35.703     0.150
     1.827    60.504     0.150
     0.366    37.391     0.150
     0.366    64.914     0.150
     2.475    77.301     0.150
     2.928    82.902     0.150
     2.991    80.504     0.150
     4.850    75.953     0.150
     8.717   129.820     0.150
     8.774   130.684     0.150
     8.832   136.617     0.150
     8.823   130.582     0.150
     8.869   133.207     0.150
     8.898   133.207     0.150
     9.028   134.566     0.150
     9.079   134.746     0.150
     9.454   139.098     0.150
    10.349   146.844     0.150
    12.435   177.902     0.150
    12.975   189.902     0.150
    21.343   290.902     0.150
    25.526     7.199     0.150
    52.900   554.102     0.150
    78.352   717.402     0.150
     0.624    29.148     0.150
     1.876    31.445     0.150
     2.003    37.117     0.150
     2.003    79.117     0.150
     2.301    73.320     0.150
     2.704    72.414     0.150
     3.280    93.516     0.150
     3.468    98.219     0.150
     3.565    52.820     0.150
     3.684   105.258     0.150
     4.661   133.617     0.150
     6.595    96.414     0.150
     7.396   319.664     0.150
     8.289   223.531     0.150
     8.343   223.359     0.150
     8.385   224.594     0.150
     8.407   221.984     0.150
     8.410   221.383     0.150
     8.423   224.289     0.150
     8.454   223.539     0.150
     8.463   222.180     0.150
     8.479   223.688     0.150
     8.514   224.164     0.150
     8.512   126.961     0.150
     8.525   226.469     0.150
     8.538   228.375     0.150
     8.538   225.391     0.150
     8.541   125.219     0.150
     8.544   225.125     0.150
     8.553   227.648     0.150
     8.563   225.500     0.150
     8.616   233.172     0.150
     8.738   127.688     0.150
     8.738   231.086     0.150
     8.914   232.570     0.150
     8.957   234.555     0.150
     8.547   132.977     0.150
     8.547   229.680     0.150
     9.181   238.383     0.150
     9.190   237.789     0.150
     9.208   133.922     0.150
     9.290   241.453     0.150
     9.451   142.117     0.150
     9.451   146.117     0.150
     9.451   243.117     0.150
     9.451   251.117     0.150
    10.241   251.117     0.150
    10.730   151.320     0.150
    10.730   271.117     0.150
    10.678   269.359     0.150
    11.249   277.148     0.150
    11.249   360.227     0.150
    11.249   362.547     0.150
    11.253   272.188     0.150
    12.891   186.016     0.150
    12.891   313.305     0.150
    12.891   325.016     0.150
    12.891   416.211     0.150
    12.891   416.625     0.150
    12.957   324.117     0.150
    13.006   315.117     0.150
    13.006   178.320     0.150
    12.931   183.117     0.150
    12.931   322.117     0.150
    12.919   329.117     0.150
    12.919   183.117     0.150
    12.919   329.117     0.150
    13.188   182.117     0.150
    13.920   347.141     0.150
    14.884     4.500     0.150
    18.894   458.117     0.150
    18.894   259.117     0.150
    18.894   458.117     0.150
    18.966    10.000     0.150
    18.966    14.000     0.150
    18.966   457.117     0.150
    18.966   964.117     0.150
    20.771   281.117     0.150
    20.980   507.117     0.150
    21.206   284.219     0.150
    21.200     8.500     0.150
    21.200    12.500     0.150
    21.200   284.617     0.150
    21.200    12.500     0.150
    21.200   311.117     0.150
    21.200   515.117     0.150
    21.200   530.117     0.150
    21.339     4.000     0.150
    21.339     7.297     0.150
    21.339    24.000     0.150
    21.339   517.117     0.150
    21.339   523.117     0.150
    21.339   287.117     0.150
    21.339   320.516     0.150
    21.339   517.117     0.150
    21.339   548.117     0.150
    21.956   298.164     0.150
    22.455   287.117     0.150
    22.455   288.117     0.150
    23.330   307.117     0.150
    23.330   559.117     0.150
    23.789   311.617     0.150
    24.524   575.117     0.150
    24.524   317.117     0.150
    24.524   575.117     0.150
    25.212   592.117     0.150
    26.771   339.117     0.150
    27.408     1.531     0.150
    27.408   345.219     0.150
    28.229   355.617     0.150
    28.248   353.617     0.150
    28.248   640.117     0.150
    28.248   731.117     0.150
    28.248   353.617     0.150
    28.248   402.117     0.150
    28.248   541.117     0.150
    28.248   640.117     0.150
    28.248   731.117     0.150
    28.438    14.797     0.150
    28.438   423.117     0.150
    28.438   635.117     0.150
    28.438   354.320     0.150
    28.438     6.797     0.150
    28.438    14.797     0.150
    28.438   399.117     0.150
    28.438   423.117     0.150
    28.438   635.117     0.150
    28.438   727.117     0.150
    29.520   717.789     0.150
    29.435   422.117     0.150
    29.435   659.117     0.150
    29.435   363.617     0.150
    29.435   422.117     0.150
    29.435   659.117     0.150
    29.435   752.117     0.150
    29.837   659.117     0.150
    29.837   365.617     0.150
    29.837   659.117     0.150
    29.791   653.117     0.150
    29.791   366.617     0.150
    29.791   419.117     0.150
    29.791   653.117     0.150
    29.791   671.117     0.150
    30.781   377.117     0.150
    30.781   680.117     0.150
    31.350   380.414     0.150
    31.358   381.117     0.150
    31.358   445.117     0.150
    31.358   685.117     0.150
    31.358   794.117     0.150
    31.358  1010.117     0.150
    31.648   382.820     0.150
    31.648   691.117     0.150
    31.893   462.719     0.150
    31.904   469.117     0.150
    31.925   696.117     0.150
    32.130   682.117     0.150
    33.671     7.797     0.150
    33.671    12.000     0.150
    33.935   493.117     0.150
    33.935   845.117     0.150
    33.935   403.117     0.150
    33.935     9.000     0.150
    33.935   475.117     0.150
    33.935   493.117     0.150
    33.935   723.117     0.150
    33.935   845.117     0.150
    34.846   414.688     0.150
    35.042     7.500     0.150
    35.751   518.117     0.150
    35.751   756.117     0.150
    35.751   419.117     0.150
    35.751   494.117     0.150
    35.751   518.117     0.150
    35.751   756.117     0.150
    35.751   891.117     0.150
    35.746   418.117     0.150
    35.746   894.117     0.150
    35.787    10.000     0.150
    35.787   437.516     0.150
    35.787   505.117     0.150
    35.787   757.117     0.150
    35.787   419.102     0.150
    36.266   421.617     0.150
    36.352   423.117     0.150
    36.778   427.016     0.150
    37.544   437.117     0.150
    38.108   439.117     0.150
    38.108   789.117     0.150
    38.258   440.734     0.150
    38.703   533.117     0.150
    38.703   558.117     0.150
    38.703   999.117     0.150
    38.703   445.117     0.150
    38.703   533.117     0.150
    38.703   558.117     0.150
    38.703   574.117     0.150
    38.703   798.117     0.150
    38.703   965.117     0.150
    38.703   999.117     0.150
    38.703  1053.117     0.150
    39.023   581.914     0.150
    40.093   451.117     0.150
    40.684   467.414     0.150
    41.621   837.117     0.150
    41.985   598.117     0.150
    41.985   848.117     0.150
    41.985  1035.117     0.150
    41.985   471.117     0.150
    41.985   569.117     0.150
    41.985   598.117     0.150
    41.985   848.117     0.150
    41.985  1035.117     0.150
    42.662   472.617     0.150
    43.268    13.000     0.150
    43.268  1078.117     0.150
    43.268   482.117     0.150
    43.268    13.000     0.150
    43.268   584.117     0.150
    43.268   592.117     0.150
    43.268   867.117     0.150
    43.268  1078.117     0.150
    43.417   862.117     0.150
    43.417   481.914     0.150
    43.417   862.117     0.150
    43.824   631.117     0.150
    43.824  1121.117     0.150
    43.824   485.117     0.150
    43.824   592.117     0.150
    43.824   631.117     0.150
    43.824   875.117     0.150
    43.824  1061.117     0.150
    43.824  1121.117     0.150
    45.189   904.117     0.150
    45.189  1151.117     0.150
    45.189   495.070     0.150
    45.189   495.117     0.150
    45.189   597.117     0.150
    45.189   603.117     0.150
    45.189   894.117     0.150
    45.189   904.117     0.150
    45.189  1086.117     0.150
    45.189  1151.117     0.150
    45.377   499.117     0.150
    45.377   897.117     0.150
    45.643  1092.125     0.150
    45.643   499.117     0.150
    46.304   921.219     0.150
    46.304   504.188     0.150
    46.434   505.516     0.150
    46.529   507.117     0.150
    46.529   531.414     0.150
    46.753   508.219     0.150
    47.431   936.914     0.150
    47.431  1108.016     0.150
    47.431  1116.016     0.150
    48.121   518.516     0.150
    48.121     6.203     0.150
    48.121   631.914     0.150
    48.121   935.820     0.150
    48.663   525.117     0.150
    48.663   636.117     0.150
    48.663   947.117     0.150
    48.793   524.117     0.150
    49.586   524.117     0.150
    49.586   943.117     0.150
    49.925   532.914     0.150
    49.925  1124.016     0.150
    50.356     1.703     0.150
    50.815   552.477     0.150
    50.774    14.102     0.150
    50.774   651.117     0.150
    50.774   721.117     0.150
    50.774   975.117     0.150
    50.774   993.117     0.150
    50.774   539.016     0.150
    50.774    14.305     0.150
    50.774   651.117     0.150
    50.774   721.117     0.150
    50.774   971.117     0.150
    50.774   975.117     0.150
    50.774   993.219     0.150
    50.774  1127.117     0.150
    50.774  1191.117     0.150
    50.837   539.820     0.150
    51.183   672.117     0.150
    51.183   542.820     0.150
    51.509   545.117     0.150
    51.509     7.000     0.150
    51.509   616.016     0.150
    51.509   664.219     0.150
    51.509   986.016     0.150
    51.509  1134.117     0.150
    51.563    17.070     0.150
    51.843     2.102     0.150
    51.843   733.219     0.150
    51.843   807.219     0.150
    51.843  1211.117     0.150
    51.843  2365.820     0.150
    51.843   547.719     0.150
    51.843   670.117     0.150
    51.843   733.219     0.150
    51.843   992.516     0.150
    51.853     1.203     0.150
    51.972   548.516     0.150
    52.047   553.086     0.150
    52.103   549.508     0.150
    52.195   622.617     0.150
    52.195   550.117     0.150
    52.195   622.617     0.150
    52.195   997.117     0.150
    52.195  1139.117     0.150
    52.410   551.414     0.150
    52.410   996.117     0.150
    52.410  1139.117     0.150
    52.602  1246.117     0.150
    52.602   554.820     0.150
    52.602   675.117     0.150
    52.602  1001.117     0.150
    52.730   663.320     0.150
     2.863   554.617     0.150
    52.992   555.516     0.150
    53.250     1.781     0.150
    53.333     2.000     0.150
    53.333   591.617     0.150
    53.333   610.320     0.150
    53.333   656.914     0.150
    53.333   675.117     0.150
    53.333   558.617     0.150
    53.333   591.617     0.150
    53.333   610.320     0.150
    53.333   675.117     0.150
    53.333  1238.117     0.150
    53.333  2376.117     0.150
    53.333   558.617     0.150
    53.333   675.117     0.150
    53.676   562.016     0.150
    53.676  1017.117     0.150
    54.112  1395.570     0.150
    54.948   771.117     0.150
    54.948   569.914     0.150
    54.948   771.117     0.150
    54.948  1028.117     0.150
    55.106   571.766     0.150
    55.282     0.203     0.150
    55.522     0.102     0.150
    55.675  1058.125     0.150
    55.675   574.617     0.150
    55.675   704.117     0.150
    55.675  1058.617     0.150
    55.782   574.258     0.150
    56.014   594.117     0.150
    56.027   578.219     0.150
    56.014  1318.539     0.150
    56.167   810.117     0.150
    56.216  1310.164     0.150
    56.216  1516.984     0.150
    56.256   579.836     0.150
     0.065   578.117     0.150
    56.530   582.016     0.150
    56.609   582.719     0.150
    56.902   584.617     0.150
    57.276   588.328     0.150
    57.300   587.875     0.150
    57.404   588.477     0.150
     0.490   591.375     0.150
    59.000   596.117     0.150
    59.000   645.117     0.150
    59.000   729.117     0.150
    59.000  1073.117     0.150
    60.073  1095.117     0.150
    60.073  1191.117     0.150
    60.073   605.117     0.150
    60.073   740.117     0.150
    60.073  1095.117     0.150
    60.073  1191.117     0.150
    60.811   612.219     0.150
    60.866   611.844     0.150
    60.933   842.156     0.150
    60.933  1007.805     0.150
    61.091   613.141     0.150
    61.090   612.016     0.150
    61.434   618.125     0.150
    61.434   616.414     0.150
    61.875   618.914     0.150
    62.275   621.086     0.150
    62.349   621.266     0.150
    62.411   621.414     0.150
    62.411  1127.117     0.150
    62.648   653.820     0.150
    62.937  1127.117     0.150
    64.206   633.664     0.150
    64.276   635.914     0.150
    66.111   653.117     0.150
    66.224   896.617     0.150
    66.330   648.719     0.150
    66.679   650.820     0.150
    67.381  1200.320     0.150
    69.336   698.117     0.150
    72.833   688.141     0.150
    75.051   702.117     0.150
    75.772   703.914     0.150
    75.772   704.008     0.150
    76.110   708.344     0.150
    78.082   717.117     0.150
    78.130   717.320     0.150
     2.299   729.367     0.150
    81.686   738.016     0.150
    82.427  2880.117     0.150
    82.427  2952.117     0.150
    82.528    12.000     0.150
    82.528  2882.117     0.150
    82.528  3027.117     0.150
    83.070  2687.117     0.150
    83.070  2907.117     0.150
    95.157   801.008     0.150
    98.548   814.516     0.150
   108.023  1137.117     0.150
   110.069  1117.117     0.150
   111.707  1127.219     0.150
   114.712  1127.117     0.150
   115.000  1120.820     0.150
   117.622  1126.414     0.150
   117.891  1117.219     0.150
   117.891  1117.219     0.150
   118.201  1133.016     0.150
   118.201  1136.414     0.150
   118.201  1139.719     0.150
   120.289  1128.516     0.150
   120.469  1132.516     0.150
   124.391  1146.117     0.150
   128.260  1272.883     0.150
   128.260  1278.117     0.150
   129.230  1275.398     0.150
   129.230  1349.539     0.150
   130.533  1292.930     0.150
   133.357  1160.109     0.150
   136.835  1154.117     0.150
   152.890  1391.320     0.150
   153.590  1188.719     0.150
     2.033    65.242     0.150
     2.338    75.242     0.150
    46.026    44.844     0.150
     3.613    54.445     0.150
     3.328    95.242     0.150
    46.817    56.844     0.150
    46.817    99.344     0.150
     5.697    87.242     0.150
    12.826   318.602     0.150
    15.674   216.242     0.150
     1.006    19.359     0.150
     1.006    32.375     0.150
     1.136    21.242     0.150
     1.136    35.945     0.150
     2.033    38.242     0.150
     2.033    65.242     0.150
     2.338    42.242     0.150
     2.338    75.242     0.150
     2.490    40.945     0.150
     2.490    73.445     0.150
     2.529    43.266     0.150
     2.529    76.000     0.150
     2.595    45.344     0.150
     2.828    46.742     0.150
     2.721    47.742     0.150
     2.736    45.242     0.150
    46.026    44.844     0.150
     2.948    50.742     0.150
     3.613    54.445     0.150
     3.613    97.242     0.150
     3.328    55.242     0.150
     3.328    95.242     0.150
    46.817    56.844     0.150
    46.817    99.344     0.150
     3.729    60.242     0.150
     3.729   104.242     0.150
     5.697    83.242     0.150
     5.697    87.242     0.150
    12.826   318.602     0.150
    15.674   216.242     0.150
     7.325   106.562     0.150
     7.325   185.219     0.150
    11.208   160.914     0.150
    13.853   193.516     0.150
    12.826   180.781     0.150
    21.883   294.094     0.150
     1.136    21.242     0.150
     1.136    35.945     0.150
     1.496    25.773     0.150
     0.630    29.211     0.150
     1.835    31.812     0.150
     2.033    38.242     0.150
     2.033    65.242     0.150
     2.339    75.242     0.150
     2.529    43.266     0.150
     2.529    76.000     0.150
     2.736    45.242     0.150
     2.736    68.242     0.150
     2.807    44.969     0.150
     2.917    44.844     0.150
     2.917    58.141     0.150
     3.082    49.070     0.150
     3.319    55.242     0.150
     3.319    95.242     0.150
     3.613    54.445     0.150
     3.613    97.242     0.150
     3.729    60.242     0.150
     3.729   104.242     0.150
     5.697    83.242     0.150
     6.128    92.344     0.150
     7.325   185.219     0.150
     7.325   243.492     0.150
     7.325   243.625     0.150
     7.325   310.141     0.150
     8.412   222.539     0.150
     8.426   221.695     0.150
     8.428   220.797     0.150
     8.442   222.430     0.150
     8.445   223.039     0.150
     8.480   223.625     0.150
     8.530   224.047     0.150
     8.533   224.695     0.150
     8.537   223.945     0.150
     8.553   224.375     0.150
     8.569   224.742     0.150
     8.966   244.852     0.150
     8.479   132.359     0.150
     8.479   229.883     0.150
     8.479   302.586     0.150
     8.479   302.672     0.150
    11.208   368.852     0.150
    11.208   368.852     0.150
    11.208   450.070     0.150
    12.188   175.242     0.150
    12.826   420.594     0.150
    12.826   420.719     0.150
    12.826   510.109     0.150
    12.933   310.242     0.150
    13.853   557.500     0.150
    14.949     4.500     0.150
    15.674   216.242     0.150
    15.674   378.242     0.150
    19.003    10.000     0.150
    19.003    13.500     0.150
    21.223    15.500     0.150
    21.223   285.742     0.150
    21.223    15.500     0.150
    21.324    11.797     0.150
    21.324    11.602     0.150
    21.324    18.195     0.150
    23.861   312.945     0.150
    24.299   578.742     0.150
    24.597   318.742     0.150
    24.597   582.242     0.150
    25.228     5.703     0.150
    26.828   340.242     0.150
    28.037     5.297     0.150
    30.825   377.242     0.150
    31.389   380.242     0.150
    31.939   386.344     0.150
    36.327   423.742     0.150
    36.841   429.039     0.150
    38.765   544.242     0.150
    38.765   445.242     0.150
    38.765   544.242     0.150
    39.084   807.844     0.150
    39.084   447.844     0.150
    39.084   807.844     0.150
    39.084   975.242     0.150
    38.980   446.039     0.150
    38.980   446.039     0.150
    43.462   483.344     0.150
    46.499   507.344     0.150
    46.817   509.742     0.150
    50.856   553.961     0.150
    51.241   544.242     0.150
    51.562     9.398     0.150
    51.562   546.445     0.150
    51.562     9.398     0.150
    52.090   554.992     0.150
    52.129   550.539     0.150
    53.034   556.969     0.150
    53.387   560.945     0.150
    53.387   560.945     0.150
    53.407   559.602     0.150
    53.728   563.344     0.150
    53.889   564.266     0.150
    55.005   571.641     0.150
    56.035   580.641     0.150
     0.030   579.539     0.150
    56.421   583.125     0.150
    57.502   591.352     0.150
    62.484   622.641     0.150
    78.035   718.945     0.150
    78.198   718.344     0.150
    78.511   723.445     0.150
    78.613   721.039     0.150
    81.694   739.141     0.150
    86.766   762.742     0.150
   129.813  1151.141     0.150
   153.555  1191.742     0.150
    46.402   507.984     0.150
     6.128   100.961     0.150
     6.128    87.273     0.150
     6.128    85.281     0.150
     1.126    21.961     0.150
     1.126    36.664     0.150
   135.982    15.461     0.150
   135.982    33.164     0.150
   135.982    17.700     0.150
     2.319    76.359     0.150
     2.718    45.461     0.150
     2.718    77.461     0.150
    46.007    50.461     0.150
     2.953    49.461     0.150
     2.945    57.461     0.150
     3.593    54.664     0.150
     3.593    95.664     0.150
    46.795    57.258     0.150
    46.795   100.664     0.150
   109.376   102.461     0.150
   109.376   128.461     0.150
     8.493    65.461     0.150
     8.493   163.461     0.150
    12.941   184.461     0.150
     1.135    22.461     0.150
     1.135    38.461     0.150
     1.126    21.961     0.150
     1.126    36.664     0.150
     1.126    81.461     0.150
     1.126    91.461     0.150
     2.016    64.461     0.150
     2.321    76.359     0.150
     2.718    45.461     0.150
     2.718    77.461     0.150
     3.492   100.664     0.150
     3.593    54.664     0.150
     3.593    95.664     0.150
     4.974    78.461     0.150
     4.974   128.461     0.150
     6.108    91.062     0.150
     6.108    91.062     0.150
     6.108   161.258     0.150
     6.916    97.258     0.150
     7.550   104.461     0.150
     8.447   125.750     0.150
     8.536   225.180     0.150
     8.559   225.727     0.150
     8.565   225.000     0.150
     9.196   240.297     0.150
    12.074   169.961     0.150
    12.074   297.961     0.150
    12.838   181.461     0.150
    12.838   316.461     0.150
    12.838   330.359     0.150
    12.838   400.664     0.150
    12.951   184.461     0.150
    14.936     5.000     0.150
    21.226     8.500     0.150
    21.226   286.961     0.150
    21.226     8.500     0.150
    21.338   288.461     0.150
    24.311     8.000     0.150
    26.819   341.461     0.150
    27.453   347.461     0.150
    29.839   368.164     0.150
    30.805   379.461     0.150
    36.829   429.164     0.150
    39.062   495.758     0.150
    39.062   447.664     0.150
    39.062   805.961     0.150
    46.477   507.664     0.150
    46.795   509.961     0.150
    50.857   535.461     0.150
    51.541   548.258     0.150
    51.875   596.664     0.150
    51.875   549.562     0.150
    53.366   560.461     0.150
    53.382   558.961     0.150
    53.713   561.961     0.150
    54.061   564.062     0.150
    54.996   571.664     0.150
     0.036   579.859     0.150
    56.450   582.258     0.150
    56.831   584.562     0.150
    57.340   589.062     0.150
    57.349   589.062     0.150
    61.471   616.562     0.150
    62.463   620.961     0.150
    78.040   718.961     0.150
    78.184   719.461     0.150
    78.596   721.461     0.150
    81.682   739.258     0.150
    86.748   762.961     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    86.453     0.150
     6.108    88.180     0.150
     6.108    88.852     0.150
     6.108   160.844     0.150
     6.108   160.844     0.150
     6.108   160.844     0.150
     6.108   155.305     0.150
     1.971    64.133     0.150
     2.272    73.234     0.150
    40.810    44.633     0.150
    40.810    76.633     0.150
     2.783    -5.867     0.150
     3.544    53.133     0.150
     3.064    88.133     0.150
    40.882    40.547     0.150
    40.882    76.547     0.150
     2.843    85.344     0.150
     2.843    85.344     0.150
     2.751    20.547     0.150
     2.751    81.547     0.150
     2.861    50.547     0.150
    46.041   -12.352     0.150
    46.041    18.047     0.150
     2.979    84.547     0.150
     3.173    52.547     0.150
     3.527    58.047     0.150
     3.657   222.047     0.150
    74.404   312.547     0.150
     1.153    21.047     0.150
     1.153    37.344     0.150
     2.542    44.547     0.150
     2.542    74.047     0.150
     2.751    81.547     0.150
     3.005    84.547     0.150
     3.333   108.945     0.150
     3.742    54.648     0.150
     3.742    99.250     0.150
     5.710   100.547     0.150
     8.355   124.172     0.150
     8.521   217.305     0.150
     8.528   126.266     0.150
     8.559   125.797     0.150
    12.041   169.047     0.150
    12.041   293.047     0.150
    21.307   290.344     0.150
    86.763   761.047     0.150
     2.037    23.766     0.150
     2.335    22.266     0.150
     2.335    75.867     0.150
     2.540    37.562     0.150
    40.879    45.766     0.150
    40.879    75.766     0.150
     2.715    43.266     0.150
     2.739    87.766     0.150
    46.023    49.164     0.150
    46.023    82.766     0.150
     3.150    90.266     0.150
     3.500    52.766     0.150
     5.750    53.766     0.150
    12.052    62.266     0.150
    74.412   377.766     0.150
    12.884   106.766     0.150
    12.884   395.766     0.150
     2.349    77.203     0.150
     2.499    77.203     0.150
    40.878    46.203     0.150
    40.878    72.703     0.150
     2.976   225.703     0.150
     3.171    91.203     0.150
    46.825    57.000     0.150
    46.825   100.203     0.150
     3.525    58.703     0.150
     3.525   100.203     0.150
   109.398   -45.297     0.150
   109.398   -35.297     0.150
     7.327   184.703     0.150
     7.327   231.703     0.150
    12.922   353.203     0.150
    12.922   499.703     0.150
     1.147    21.406     0.150
     1.147    37.000     0.150
     2.351    77.203     0.150
     2.537    43.703     0.150
     2.537    78.703     0.150
     2.748    85.703     0.150
     3.330    56.703     0.150
     3.330   101.703     0.150
     3.522   100.203     0.150
     3.624    56.102     0.150
     3.624    98.906     0.150
     3.739    60.703     0.150
     3.739   104.102     0.150
    12.045   169.203     0.150
    12.045   296.703     0.150
    49.436   531.102     0.150
     6.139    90.609     0.150
     6.139    90.609     0.150
     6.139    90.609     0.150
     6.139    90.609     0.150
     6.139    86.922     0.150
     6.139    98.945     0.150
     6.139   160.820     0.150
     6.139   160.820     0.150
     6.139   160.820     0.150
     6.139   160.820     0.150
     6.139   160.820     0.150
     6.139   164.258     0.150
     6.139   169.938     0.150
     6.139   155.570     0.150
     1.178    18.547     0.150
     1.178    18.547     0.150
     1.178    30.914     0.150
     1.178    30.914     0.150
     1.911    61.156     0.150
     2.196    41.656     0.150
     2.196    71.656     0.150
    40.767    43.156     0.150
    40.767    80.156     0.150
     2.555   135.055     0.150
    45.879    49.953     0.150
    45.879    93.156     0.150
     3.186    97.758     0.150
    46.622    54.656     0.150
    46.622    54.656     0.150
    46.622    95.758     0.150
    46.622    95.758     0.150
     3.344    56.156     0.150
     3.344    95.656     0.150
     3.572   101.953     0.150
     5.785    82.156     0.150
     7.500     5.156     0.150
     7.500    52.156     0.150
    13.113   173.656     0.150
     1.103    20.156     0.150
     1.103    36.555     0.150
     1.912    61.156     0.150
     2.197    41.656     0.150
     2.197    71.656     0.150
     2.620    43.156     0.150
     2.620    77.656     0.150
     2.610    48.156     0.150
     2.610    80.156     0.150
     3.357    95.758     0.150
     3.449    53.953     0.150
     3.449    93.953     0.150
     3.572    58.156     0.150
     3.572   101.953     0.150
     5.785    82.156     0.150
     7.500   130.156     0.150
     8.287   218.375     0.150
     8.468   125.688     0.150
     8.564   128.625     0.150
     8.575   128.844     0.150
     8.718   123.305     0.150
     9.136   231.211     0.150
     9.216   223.477     0.150
     9.228   135.039     0.150
     9.228   228.461     0.150
     9.247   227.008     0.150
     9.365   133.570     0.150
     9.365   231.508     0.150
     9.382   237.281     0.150
    12.979   190.156     0.150
    13.124   173.656     0.150
    13.124   320.156     0.150
    46.622   508.656     0.150
    72.948   685.156     0.150
    75.172   698.055     0.150
     5.971    93.500     0.150
     5.971    88.352     0.150
     5.971    88.352     0.150
     5.971    88.352     0.150
     5.971    88.352     0.150
     5.971    88.352     0.150
     5.971    95.672     0.150
     5.971    90.070     0.150
     5.971    93.648     0.150
     5.971    90.742     0.150
     5.971   156.750     0.150
     5.971   156.750     0.150
     5.971   151.742     0.150
     2.320    76.266     0.150
    40.849    46.266     0.150
    40.849    78.266     0.150
     2.828    82.766     0.150
     3.595   218.469     0.150
    46.008    72.266     0.150
    46.008    91.766     0.150
     3.142    90.266     0.150
    46.800    57.562     0.150
    46.800    98.867     0.150
     3.497    58.766     0.150
     7.332   197.766     0.150
     7.332   245.766     0.150
    12.829    81.766     0.150
    12.829   268.766     0.150
     1.131    23.562     0.150
     1.131    40.469     0.150
     1.121    21.766     0.150
     1.121    37.266     0.150
     2.321    76.266     0.150
     2.525    44.266     0.150
     2.525    79.266     0.150
     2.718    84.766     0.150
     3.595    56.664     0.150
     3.710    60.969     0.150
     3.710   104.562     0.150
     5.922   158.969     0.150
     8.436   217.375     0.150
     8.439   217.375     0.150
     8.554   129.070     0.150
     8.557   126.844     0.150
    12.943   177.766     0.150
     6.110    90.844     0.150
     6.110    90.844     0.150
     6.110    90.844     0.150
     6.110    90.844     0.150
     6.110    90.844     0.150
     6.110    90.844     0.150
     6.110    90.844     0.150
     6.110    88.672     0.150
     6.110    88.078     0.150
     6.110   165.578     0.150
     6.110   161.062     0.150
     6.110   161.062     0.150
     6.110   161.062     0.150
     2.344   -17.226     0.150
     2.344    13.574     0.150
    40.880    45.874     0.150
    40.880    80.374     0.150
    46.032    52.874     0.150
    46.032    90.174     0.150
     2.854    83.374     0.150
     3.162    92.374     0.150
    46.808    57.374     0.150
    46.808    99.674     0.150
     3.514    58.874     0.150
     3.514   101.374     0.150
    74.409   168.874     0.150
    12.855   186.874     0.150
    12.948   174.874     0.150
     1.156    21.874     0.150
     1.156    34.874     0.150
     0.648    30.304     0.150
     2.559    41.874     0.150
     2.559    76.374     0.150
     2.948    52.874     0.150
     2.745    50.874     0.150
     2.745    82.874     0.150
     3.515    99.674     0.150
     3.614    56.774     0.150
     3.614    98.374     0.150
     3.731    60.674     0.150
     3.731   105.074     0.150
     5.727    87.874     0.150
     5.727   168.874     0.150
     7.353   102.874     0.150
     7.353   180.874     0.150
     9.506   242.374     0.150
    12.047   294.874     0.150
    12.855   303.874     0.150
    12.855   312.874     0.150
    12.855   338.574     0.150
    12.855   397.074     0.150
    12.958   174.874     0.150
    14.920   217.874     0.150
    21.196     8.000     0.150
    52.188   551.774     0.150
    53.395   561.174     0.150
    86.740   765.474     0.150
    83.607    21.299     0.150
     0.982    32.270     0.150
     1.109    23.549     0.150
     2.555    79.549     0.150
    40.936    49.549     0.150
    40.936    83.549     0.150
    40.936    34.000     0.150
     2.768    93.049     0.150
     3.193    92.049     0.150
    46.812    57.949     0.150
    46.812   100.850     0.150
     3.540    50.549     0.150
    13.152    39.549     0.150
     1.072    17.855     0.150
     1.072    30.855     0.150
     2.084    62.855     0.150
     2.388    45.355     0.150
    40.918    45.355     0.150
    40.918    83.855     0.150
    40.918    92.355     0.150
     1.154    24.475     0.150
     2.303    74.475     0.150
     2.569    46.174     0.150
    40.806    45.174     0.150
    40.806    77.674     0.150
    46.824    39.773     0.150
    46.824    57.074     0.150
     3.497    58.174     0.150
     1.111    18.090     0.150
     1.111    30.650     0.150
     1.219    35.971     0.150
     1.072   128.771     0.150
     2.238     5.871     0.150
     2.238    43.471     0.150
     2.410    75.471     0.150
     2.810    40.471     0.150
     2.810    73.471     0.150
    40.780    45.471     0.150
    40.780    77.971     0.150
    45.926    48.070     0.150
    45.926    88.670     0.150
     3.509   102.170     0.150
     3.029    42.471     0.150
     3.029    79.971     0.150
     3.228    55.771     0.150
    46.712    56.371     0.150
    46.712    97.670     0.150
     3.410    87.971     0.150
   109.312    73.971     0.150
   109.312   164.971     0.150
     5.698   173.971     0.150
    74.511   170.971     0.150
    12.869   158.971     0.150
     0.558    31.961     0.150
     2.531    42.471     0.150
     2.531    73.471     0.150
     2.640    47.971     0.150
     2.640    79.971     0.150
     3.219    55.771     0.150
     3.219   105.971     0.150
     3.409    97.670     0.150
     3.509    58.971     0.150
     3.509   102.170     0.150
     3.626    58.971     0.150
     3.626   102.371     0.150
     5.025   164.971     0.150
     5.698    82.971     0.150
     5.698   173.971     0.150
     8.515   126.156     0.150
     8.571   126.746     0.150
     8.604   127.922     0.150
     8.581   127.150     0.150
     8.585   127.225     0.150
     8.752   129.703     0.150
     8.802   130.260     0.150
     9.272   133.785     0.150
     9.272   236.783     0.150
     9.356   138.234     0.150
     9.388   135.596     0.150
    12.869   306.871     0.150
    12.869   330.971     0.150
    13.008   316.971     0.150
    13.902   367.971     0.150
    21.259    14.000     0.150
    75.105   706.871     0.150
    81.619   740.271     0.150
    49.330   526.363     0.150
     6.025    84.385     0.150
     6.025    89.088     0.150
     6.025    89.088     0.150
     6.025    91.811     0.150
     6.025    87.113     0.150
     6.025    92.484     0.150
    53.298   558.559     0.150
     2.308    75.023     0.150
     2.481    43.523     0.150
     2.481    79.023     0.150
    40.839    51.523     0.150
    40.839    85.523     0.150
    40.839    34.000     0.150
     2.707    53.223     0.150
     3.130    90.523     0.150
     3.298    46.523     0.150
    46.788    15.223     0.150
    46.788    99.223     0.150
   109.374    73.523     0.150
   109.374   170.523     0.150
     5.693    91.523     0.150
     5.693   170.523     0.150
    74.448   171.523     0.150
    74.448   296.523     0.150
    12.941   181.023     0.150
     1.143    31.824     0.150
     1.114    20.523     0.150
     1.114    36.523     0.150
     0.606    31.223     0.150
     1.864    33.902     0.150
     2.525    44.023     0.150
     2.525    78.023     0.150
     2.310    75.023     0.150
     2.707    53.223     0.150
     3.481    99.223     0.150
     3.583    57.125     0.150
     3.583    99.324     0.150
     3.698    59.625     0.150
     3.698   102.723     0.150
     4.973   170.523     0.150
     5.693    88.523     0.150
     5.693   170.523     0.150
     5.912   157.824     0.150
     7.340   105.523     0.150
     7.340   185.523     0.150
     8.569   129.371     0.150
     8.585   218.617     0.150
     8.985   129.082     0.150
     9.217   233.207     0.150
     9.233   232.430     0.150
     9.283   235.332     0.150
     9.312   236.578     0.150
    12.203   296.523     0.150
    12.085   292.523     0.150
    12.835   181.523     0.150
    12.835   191.523     0.150
    46.470   503.223     0.150
    53.374   559.523     0.150
    75.031   700.422     0.150
    78.598   719.125     0.150
     6.098    90.059     0.150
     6.098    90.059     0.150
     6.098    90.059     0.150
     6.098    92.914     0.150
    72.815   688.391     0.150
    26.000    10.281     0.150
     2.311    75.180     0.150
    40.848    45.281     0.150
    40.848    77.281     0.150
     2.712    84.980     0.150
     2.966    96.281     0.150
     3.103    89.281     0.150
     3.613   102.281     0.150
    26.060    10.414     0.150
     1.168    34.016     0.150
     2.064    65.516     0.150
     2.361    76.617     0.150
     2.727    43.516     0.150
    46.049    51.914     0.150
    46.049    90.516     0.150
    46.049    38.600     0.150
     3.014    53.117     0.150
     3.627    96.414     0.150
    46.808    57.414     0.150
    46.808   100.617     0.150
     5.763   171.516     0.150
     7.380   243.016     0.150
     8.616   170.016     0.150
    74.386   169.516     0.150
    74.386   238.516     0.150
    13.143   327.504     0.150
     1.188    22.016     0.150
     1.188    38.117     0.150
     2.064    65.516     0.150
     2.363    76.617     0.150
     2.595    43.516     0.150
     2.595    77.516     0.150
     2.663    46.617     0.150
     2.663    80.016     0.150
     3.530   100.617     0.150
     3.627    55.617     0.150
     3.627    96.414     0.150
     3.746    60.516     0.150
     3.746   104.516     0.150
     4.522    73.516     0.150
     4.723    84.516     0.150
     4.723   133.516     0.150
     5.763    99.516     0.150
     5.763   171.516     0.150
     8.496   233.566     0.150
     8.500   222.500     0.150
     8.509   126.348     0.150
     8.616   170.016     0.150
     8.692   126.734     0.150
     8.867   131.762     0.150
     8.909   133.574     0.150
     8.918   132.062     0.150
     9.053   134.902     0.150
     9.142   234.098     0.150
     9.158   233.852     0.150
     9.272   131.113     0.150
     9.272   234.723     0.150
    13.143   327.504     0.150
    13.911   335.516     0.150
    46.808   507.914     0.150
    12.979   184.289     0.150
     6.146    85.633     0.150
     6.146    88.355     0.150
     6.146    96.957     0.150
     0.997    34.609     0.150
     2.046    64.602     0.150
     2.350    76.102     0.150
     2.749    73.602     0.150
    46.038    50.203     0.150
    46.038    91.805     0.150
    46.820    56.805     0.150
    46.820    97.703     0.150
   109.389    73.102     0.150
   109.389   127.602     0.150
     5.715    80.602     0.150
     7.337   183.070     0.150
     9.885   241.000     0.150
    12.043   166.602     0.150
    12.043   299.602     0.150
    74.406   169.602     0.150
    13.118   321.602     0.150
    15.688   377.602     0.150
   113.346   244.305     0.150
     1.153    20.602     0.150
     1.107    19.703     0.150
     1.107    34.500     0.150
     0.647    30.133     0.150
     2.047    37.602     0.150
     2.047    64.602     0.150
     2.351    76.102     0.150
     2.547    42.852     0.150
     2.547    76.242     0.150
     2.749    44.602     0.150
     2.749    73.602     0.150
     3.002    79.602     0.150
     3.623    56.102     0.150
     3.739    58.602     0.150
     4.717   133.602     0.150
     5.715    80.602     0.150
     6.138    91.305     0.150
     7.337   186.883     0.150
     7.337   244.133     0.150
     7.337   244.469     0.150
     7.822   205.922     0.150
     8.407   131.773     0.150
     8.407   228.531     0.150
     8.409   124.984     0.150
     8.409   219.914     0.150
     8.423   125.047     0.150
     8.426   220.445     0.150
     8.456   125.328     0.150
     8.461   222.633     0.150
     8.511   225.109     0.150
     8.518   222.742     0.150
     8.525   222.922     0.150
     8.534   224.352     0.150
     8.540   215.461     0.150
     8.548   223.531     0.150
     8.492   230.234     0.150
     8.492   313.672     0.150
     8.492   313.805     0.150
     9.195   238.852     0.150
     9.244   240.562     0.150
     9.273   142.641     0.150
     9.273   246.852     0.150
    10.754   147.602     0.150
    10.754   147.602     0.150
    10.754   271.602     0.150
    10.669   275.727     0.150
    11.226   281.820     0.150
    11.226   367.422     0.150
    11.226   367.523     0.150
    12.043   299.602     0.150
    12.390   179.602     0.150
    12.840   319.453     0.150
    12.910   185.258     0.150
    12.910   370.562     0.150
    12.942   310.102     0.150
    12.942   179.102     0.150
    12.999   341.602     0.150
    12.999   186.102     0.150
    12.999   341.602     0.150
    12.988   184.602     0.150
    13.866   195.609     0.150
    14.935     4.000     0.150
    14.935     5.000     0.150
    14.935   375.602     0.150
    14.935   385.102     0.150
    14.935   394.102     0.150
    15.688   212.602     0.150
    15.688   377.602     0.150
    18.945   463.305     0.150
    18.945   258.102     0.150
    18.945   463.305     0.150
    18.984     9.000     0.150
    18.984    12.500     0.150
    21.204    26.500     0.150
    21.204    36.500     0.150
    21.204   523.602     0.150
    21.204   547.602     0.150
    21.204   285.102     0.150
    21.204    26.500     0.150
    21.204    36.500     0.150
    21.204   523.602     0.150
    21.204   547.602     0.150
    21.308    11.000     0.150
    21.308   317.898     0.150
    21.308   524.602     0.150
    21.308   286.602     0.150
    21.308    11.000     0.150
    21.308   317.898     0.150
    21.308   524.602     0.150
    21.893   299.219     0.150
    21.893   535.852     0.150
    23.851   311.398     0.150
    24.282     8.500     0.150
    24.588   318.102     0.150
    24.588   581.602     0.150
    26.812   339.898     0.150
    26.812   540.305     0.150
    27.461   350.102     0.150
    27.442   346.500     0.150
    29.504   439.602     0.150
    29.504   364.602     0.150
    29.504   439.602     0.150
    29.860   429.602     0.150
    30.836   376.602     0.150
    30.836   437.602     0.150
    31.362   381.102     0.150
    31.362   555.102     0.150
    31.370   380.602     0.150
    31.370   554.602     0.150
    31.949   386.102     0.150
    31.949   697.602     0.150
    33.665     9.500     0.150
    36.312   422.602     0.150
    36.826   427.703     0.150
    38.769   443.602     0.150
    38.769   530.602     0.150
    39.089   446.602     0.150
    38.971   444.805     0.150
    38.971   444.805     0.150
    42.043    10.000     0.150
    42.043    15.000     0.150
    42.043   469.602     0.150
    42.043    10.000     0.150
    42.043    15.000     0.150
    43.444   482.500     0.150
    46.368   505.203     0.150
    46.368  1115.898     0.150
    46.502   506.602     0.150
    46.581   504.305     0.150
    46.820   508.805     0.150
    47.846   522.602     0.150
    48.182     8.602     0.150
    48.182   518.898     0.150
    48.182     8.602     0.150
    50.271  1821.805     0.150
    50.867   552.742     0.150
    50.797   538.805     0.150
    51.247   542.602     0.150
    51.570     9.797     0.150
    51.570   560.102     0.150
    51.570   545.805     0.150
    51.570     9.797     0.150
    51.570    14.297     0.150
    51.911   546.602     0.150
    51.904   548.398     0.150
    52.100   553.695     0.150
    52.166   546.211     0.150
    52.197     2.305     0.150
    52.255    19.000     0.150
    52.472   551.898     0.150
    52.508    10.250     0.150
    52.666   553.000     0.150
     2.847   554.898     0.150
     2.847   554.898     0.150
    53.394   559.305     0.150
    53.394   559.305     0.150
    53.736   562.305     0.150
    53.871   562.805     0.150
    54.988   570.500     0.150
    54.988  1159.898     0.150
    56.083   580.445     0.150
     0.011   578.805     0.150
     0.420   590.703     0.150
    61.499   619.211     0.150
    62.703   624.102     0.150
    75.651   703.062     0.150
    86.756   771.203     0.150
   129.830  1150.000     0.150
   153.574  1190.500     0.150
     6.138    87.188     0.150
     6.138    85.156     0.150
    72.775   687.727     0.150
     2.358    76.758     0.150
    46.044    54.359     0.150
    46.044    92.359     0.150
    46.790    57.656     0.150
    46.790   100.062     0.150
     3.739   106.062     0.150
     6.139    95.438     0.150
     6.139    94.539     0.150
     6.139    93.984     0.150
     6.139    90.758     0.150
     6.139    95.211     0.150
     6.139    92.688     0.150
     1.068    20.676     0.150
     2.011    27.676     0.150
     2.301    75.375     0.150
    45.987    52.176     0.150
    45.987    82.576     0.150
     3.559    60.076     0.150
    46.729    58.176     0.150
     1.192    21.375     0.150
     1.192    38.676     0.150
     1.169    22.275     0.150
     1.169    38.176     0.150
     2.012    27.676     0.150
     2.303    75.375     0.150
     2.625    42.676     0.150
     2.625    77.176     0.150
     2.876    46.545     0.150
     2.712    84.676     0.150
     3.465   100.275     0.150
     3.559    60.076     0.150
     3.559   101.875     0.150
     7.908   114.986     0.150
   136.014    21.668     0.150
   136.014    36.867     0.150
    46.066    54.867     0.150
    46.066    88.668     0.150
    46.830    57.668     0.150
    46.830   101.270     0.150
     1.093    20.668     0.150
     1.093    35.270     0.150
     1.194    20.668     0.150
     1.194    38.066     0.150
     0.686    29.656     0.150
     0.686    52.406     0.150
     3.029   102.066     0.150
     3.548   101.270     0.150
     3.646    66.770     0.150
     5.754   103.668     0.150
     5.754   171.668     0.150
     6.518    96.367     0.150
    12.959   312.668     0.150
    13.894   350.668     0.150
    23.831   310.270     0.150
    74.972   701.770     0.150
     6.163    94.359     0.150
     6.163   100.324     0.150
     6.163    92.898     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    90.934     0.150
     6.163    87.320     0.150
     6.163   161.453     0.150
     1.104    40.105     0.150
     2.337    74.508     0.150
     2.964    43.805     0.150
     3.730   101.406     0.150
     2.628    52.750     0.150
     2.276    39.963     0.150
     2.276    72.263     0.150
     2.276    32.300     0.150
     2.686    54.062     0.150
     2.686    87.763     0.150
     3.536    99.763     0.150
     6.056    84.955     0.150
     6.056    96.697     0.150
     6.056    93.854     0.150
     6.056    89.878     0.150
     6.056    89.878     0.150
     6.056    87.354     0.150
     6.056   169.127     0.150
     6.056   159.400     0.150
     6.056   164.135     0.150
     1.030    32.824     0.150
     1.211    19.094     0.150
     2.335    75.793     0.150
     2.576    49.494     0.150
     2.744    54.793     0.150
     3.595    56.094     0.150
     4.691   134.094     0.150
     1.154    19.094     0.150
     2.337    75.793     0.150
     2.576    49.494     0.150
     2.576    77.293     0.150
     2.621    44.594     0.150
     2.621    44.594     0.150
     2.621    78.594     0.150
     2.838    46.443     0.150
     2.744    54.793     0.150
     2.744    86.994     0.150
     3.094    50.645     0.150
     3.501    99.994     0.150
     3.595    56.094     0.150
     3.595    98.094     0.150
     3.917    61.225     0.150
     4.340    67.824     0.150
     4.545    70.463     0.150
     4.691    80.594     0.150
     4.691   134.094     0.150
     5.184    80.404     0.150
     5.184    80.404     0.150
     5.184   136.244     0.150
     7.219   105.703     0.150
     7.219   186.725     0.150
    12.925   364.094     0.150
     0.245    10.070     0.150
     1.173    28.641     0.150
     2.354    45.438     0.150
     2.354    75.641     0.150
     2.590    37.141     0.150
     0.065     2.891     0.150
     0.065     4.945     0.150
     0.221     4.391     0.150
     0.292     5.492     0.150
     1.137    18.156     0.150
     1.137    27.852     0.150
     2.328    74.852     0.150
    46.016    48.352     0.150
    46.016    84.852     0.150
     2.984    45.453     0.150
     3.597    55.055     0.150
     3.145    53.453     0.150
    46.789    56.352     0.150
    46.789    97.250     0.150
   109.356    73.953     0.150
   109.356   133.953     0.150
    15.716   214.953     0.150
     1.149    21.250     0.150
     1.149    35.750     0.150
     1.137    18.156     0.150
     1.137    27.852     0.150
     0.638    30.664     0.150
     2.329    74.852     0.150
     2.563    41.453     0.150
     2.563    74.453     0.150
     2.563    41.453     0.150
     2.563    74.453     0.150
     2.563    41.453     0.150
     2.563    74.453     0.150
     2.633    44.703     0.150
     2.730    75.953     0.150
     2.954    84.852     0.150
     2.979   344.555     0.150
     3.309   111.953     0.150
     3.597    55.055     0.150
     3.715    58.953     0.150
     3.715   101.953     0.150
     4.418    39.453     0.150
     4.998   133.953     0.150
     5.732    46.953     0.150
     6.037   186.953     0.150
     6.114    91.250     0.150
     6.114   161.055     0.150
     7.367   102.023     0.150
     7.367   236.000     0.150
     7.367   239.570     0.150
     7.820   205.766     0.150
     8.403   132.578     0.150
     8.406   125.672     0.150
     8.458   126.922     0.150
     8.532   223.852     0.150
     8.548   126.242     0.150
     8.548   223.273     0.150
     8.542   209.133     0.150
     8.787   161.625     0.150
     8.521   310.664     0.150
     8.521   311.555     0.150
     9.172   135.625     0.150
     9.278   142.805     0.150
     9.278   245.547     0.150
     9.311   135.062     0.150
     9.915   137.750     0.150
     9.915   241.750     0.150
    11.220   254.055     0.150
    11.220   356.344     0.150
    12.061   378.953     0.150
    12.867   175.953     0.150
    12.867   313.031     0.150
    12.867   144.102     0.150
    12.867   418.133     0.150
    12.867   418.703     0.150
    12.935   194.453     0.150
    12.935   342.453     0.150
    12.974   179.453     0.150
    13.151   186.953     0.150
    13.894   343.344     0.150
    14.908   212.555     0.150
    14.908     3.602     0.150
    14.908     8.695     0.150
    14.908   376.055     0.150
    14.908   381.453     0.150
    14.908   393.352     0.150
    15.716   214.953     0.150
    17.904   538.523     0.150
    18.972     8.398     0.150
    21.198     8.203     0.150
    21.198    14.203     0.150
    21.198   285.250     0.150
    21.198     8.203     0.150
    21.198   525.453     0.150
    21.320   286.555     0.150
    21.391   288.555     0.150
    21.391   531.555     0.150
    23.820   311.055     0.150
    24.556   317.953     0.150
    24.556   581.953     0.150
    26.789   339.953     0.150
    29.471   364.453     0.150
    29.827   367.656     0.150
    30.812   376.953     0.150
    31.353   380.750     0.150
    31.360   380.953     0.150
    31.924   386.055     0.150
    35.782    11.500     0.150
    35.782   418.453     0.150
    35.782    11.500     0.150
    36.287   422.852     0.150
    39.059   446.555     0.150
    38.939   444.750     0.150
    38.939   444.750     0.150
    42.017   465.953     0.150
    42.017   844.953     0.150
    42.017   465.953     0.150
    42.017   844.953     0.150
    43.574   487.953     0.150
    43.428   482.750     0.150
    45.210   494.953     0.150
    46.339    10.102     0.150
    46.339   504.555     0.150
    46.339    10.102     0.150
    46.339   617.156     0.150
    46.470   506.352     0.150
    46.789   508.852     0.150
    47.465   524.750     0.150
    47.465   620.156     0.150
    50.845   552.633     0.150
    50.782   538.953     0.150
    51.543     9.695     0.150
    51.543   545.656     0.150
    51.543     9.695     0.150
    51.820    19.102     0.150
    51.876   548.352     0.150
    52.077   553.516     0.150
    52.137   546.109     0.150
    52.228   575.953     0.150
    52.444   551.953     0.150
    53.022   555.672     0.150
    53.367   559.156     0.150
    53.367   563.750     0.150
    53.367   559.156     0.150
    53.709   562.055     0.150
    53.844   562.852     0.150
    54.966   570.656     0.150
    54.966  1032.156     0.150
    55.314     0.094     0.150
    55.555     0.102     0.150
    55.695   575.453     0.150
    56.048   582.852     0.150
     0.028   578.852     0.150
    56.642   581.555     0.150
    57.436   586.781     0.150
    61.469    12.016     0.150
    61.469   613.953     0.150
    62.431   621.555     0.150
    62.447   621.156     0.150
    62.679   624.156     0.150
    66.565   653.453     0.150
    72.800   687.555     0.150
     2.328   729.812     0.150
    81.702   738.156     0.150
     6.114    86.367     0.150
     6.114    89.945     0.150
     6.114    89.945     0.150
     6.114    87.039     0.150
     6.114   169.984     0.150
     6.114   159.672     0.150
     6.114   159.672     0.150
     6.114   164.836     0.150
    72.800   688.094     0.150
     0.054   103.242     0.150
     0.054   105.797     0.150
     0.072    57.836     0.150
     0.072    58.836     0.150
     0.216    66.336     0.150
     0.216    63.336     0.150
     0.216    49.086     0.150
     0.262     6.234     0.150
     0.546    70.086     0.150
     0.822    75.086     0.150
     1.139    32.734     0.150
     2.327    76.336     0.150
     2.699   380.836     0.150
     2.699   414.836     0.150
    46.015    48.836     0.150
    46.015    89.234     0.150
     3.596    55.234     0.150
     3.143    90.336     0.150
    46.787    56.234     0.150
    46.787    96.734     0.150
   109.353    73.836     0.150
   109.353   129.836     0.150
     6.039   126.836     0.150
     6.039   202.836     0.150
    12.937   314.836     0.150
     1.139    20.133     0.150
     1.139    32.734     0.150
     1.149    21.734     0.150
     1.149    37.039     0.150
     0.639    30.805     0.150
     2.328    76.336     0.150
     2.565    74.836     0.150
     2.565    41.336     0.150
     2.565    74.836     0.150
     2.635    44.836     0.150
     2.635    75.836     0.150
     2.729    46.438     0.150
     2.729    80.836     0.150
     3.308    91.039     0.150
     3.596    55.234     0.150
     3.596    96.836     0.150
     3.713    59.836     0.150
     4.417    40.336     0.150
     5.734   182.195     0.150
     5.734   184.047     0.150
     6.039   126.836     0.150
     7.370    99.914     0.150
     7.370   105.875     0.150
     7.370   235.578     0.150
     7.370   236.867     0.150
     8.789   166.703     0.150
     8.523   311.336     0.150
     8.523   313.227     0.150
     9.918   239.539     0.150
     9.918   328.234     0.150
    10.225   254.836     0.150
    11.242   137.227     0.150
    12.869   180.336     0.150
    12.937   179.836     0.150
    12.937   314.836     0.150
    12.977   321.836     0.150
    13.897   338.203     0.150
    13.897   447.266     0.150
    13.897   447.547     0.150
    14.905   212.234     0.150
    14.905     3.602     0.150
    14.905     8.703     0.150
    14.905   375.836     0.150
    21.197     7.000     0.150
    25.206     6.703     0.150
    46.372   506.406     0.150
    52.226   581.336     0.150
    53.365   558.836     0.150
    54.067   563.836     0.150
    46.372   505.945     0.150
     6.113    91.758     0.150
     6.113    99.102     0.150
     6.113    96.320     0.150
     6.113    90.039     0.150
     6.113    90.039     0.150
     6.113    90.039     0.150
     6.113   159.836     0.150
     6.113   159.836     0.150
     6.113   159.836     0.150
     6.113   159.836     0.150
     6.113   159.836     0.150
     6.113   159.836     0.150
     6.113   159.836     0.150
     0.048     3.000     0.150
     0.213     8.180     0.150
     0.262     8.719     0.150
     0.257     6.188     0.150
     0.077     4.930     0.150
     0.346     8.742     0.150
     2.593    43.688     0.150
     2.593    76.086     0.150
     2.725    92.086     0.150
    46.099    54.086     0.150
     3.680    56.688     0.150
     3.228    93.086     0.150
    59.746     2.555     0.150
    70.638     2.055     0.150
    70.638     4.055     0.150
    58.413     3.305     0.150
    58.413     5.805     0.150
     0.224     7.055     0.150
     0.293     5.805     0.150
     0.288     8.133     0.150
     0.571    11.305     0.150
     0.846    15.555     0.150
     0.852    27.555     0.150
     0.966    17.805     0.150
     1.118    17.055     0.150
     2.712    78.055     0.150
    46.040    49.453     0.150
     2.977    85.055     0.150
     3.620   102.055     0.150
     3.168    53.055     0.150
     3.168    90.055     0.150
     3.342    55.055     0.150
     3.342    94.453     0.150
    46.807    56.453     0.150
    46.807    97.953     0.150
     4.715    79.055     0.150
     4.715   132.555     0.150
   109.362    74.055     0.150
   109.362   130.055     0.150
    74.397   170.555     0.150
    13.140   334.664     0.150
    15.720   378.055     0.150
     1.118    17.055     0.150
     1.118    30.055     0.150
     1.173    21.254     0.150
     1.173    35.855     0.150
     0.663    29.793     0.150
     2.579    42.555     0.150
     2.579    42.555     0.150
     3.333    94.453     0.150
     3.738    59.055     0.150
     3.738   102.055     0.150
     4.715    79.055     0.150
     4.715   132.555     0.150
     5.747   152.906     0.150
     5.747   153.504     0.150
     5.747   191.426     0.150
     6.020   108.055     0.150
     6.020   207.055     0.150
     6.137    92.156     0.150
     7.369   108.406     0.150
     7.369   114.156     0.150
     8.381   221.172     0.150
     8.436   222.074     0.150
     8.510   222.609     0.150
     8.516   223.047     0.150
     8.732   454.254     0.150
    10.201   266.055     0.150
    10.646   157.617     0.150
    11.198   362.824     0.150
    11.257   370.336     0.150
    12.036   168.855     0.150
    12.036   296.055     0.150
    12.231   326.055     0.150
    12.388   217.176     0.150
    12.873   180.074     0.150
    12.873   312.855     0.150
    12.943   202.055     0.150
    12.943   342.055     0.150
    12.971   180.055     0.150
    12.971   317.055     0.150
    13.899   198.684     0.150
    14.902   212.656     0.150
    14.902     4.000     0.150
    14.902     9.000     0.150
    15.720   211.055     0.150
    15.720   378.055     0.150
    17.289   416.266     0.150
    18.954     9.000     0.150
    20.946   504.055     0.150
    21.177     8.500     0.150
    21.177   285.055     0.150
    21.177     8.500     0.150
    21.294     5.000     0.150
    21.294     8.402     0.150
    21.294   287.254     0.150
    21.367   287.453     0.150
    21.923   680.727     0.150
    24.558   318.055     0.150
    24.558   581.055     0.150
    26.779   388.754     0.150
    26.779   339.555     0.150
    26.779   388.754     0.150
    27.788   349.953     0.150
    30.042   367.254     0.150
    30.835    12.000     0.150
    30.835   377.055     0.150
    30.835    12.000     0.150
    30.835   433.055     0.150
    31.333   381.156     0.150
    31.341   381.055     0.150
    31.947   385.953     0.150
    35.706   418.754     0.150
    39.078   446.855     0.150
    43.412   482.855     0.150
    45.202   495.055     0.150
    45.693   499.156     0.150
    45.693   499.156     0.150
    46.487   506.855     0.150
    46.807   508.953     0.150
    51.564   545.855     0.150
    51.898   548.555     0.150
    52.465   552.055     0.150
    53.388   559.656     0.150
    53.388   559.656     0.150
    53.731   562.355     0.150
    53.738     9.898     0.150
    53.738   561.055     0.150
    53.738     9.898     0.150
    54.033   562.953     0.150
    55.337     0.102     0.150
    55.577     0.098     0.150
    55.686   575.555     0.150
    56.038   578.656     0.150
     0.022   579.355     0.150
    58.082   591.254     0.150
    61.488   618.656     0.150
    61.488   619.750     0.150
    62.458   622.156     0.150
    72.778   687.656     0.150
    78.153   718.453     0.150
    86.726   762.156     0.150
    12.971   185.715     0.150
     6.137    97.863     0.150
     6.137    87.656     0.150
     6.137    95.336     0.150
     6.137    90.387     0.150
     6.137    90.387     0.150
     6.137    85.754     0.150
     6.137    96.008     0.150
    53.394   559.332     0.150
    72.778   687.715     0.150
    70.597     2.293     0.150
    70.597     3.793     0.150
    59.731     3.293     0.150
     0.072     4.914     0.150
    58.372     3.793     0.150
    58.372     6.543     0.150
     0.222     4.645     0.150
     0.222     8.562     0.150
     0.247     2.734     0.150
     0.247     4.652     0.150
     0.928     8.543     0.150
     1.154    17.793     0.150
     1.202    35.793     0.150
     1.173   165.793     0.150
     1.173   181.293     0.150
     1.362    37.992     0.150
     2.627    43.293     0.150
     2.755    45.293     0.150
     2.714    77.793     0.150
    45.999    49.293     0.150
    45.999    91.895     0.150
     2.981    48.895     0.150
     2.936    48.793     0.150
     2.936   114.395     0.150
     3.128    52.293     0.150
     3.128    89.293     0.150
    46.773    55.992     0.150
    46.773    96.691     0.150
     4.675    78.793     0.150
     4.675   131.293     0.150
   109.344    73.793     0.150
   109.344   165.793     0.150
     5.728   144.543     0.150
     6.054   132.793     0.150
     6.054   207.793     0.150
    12.077   300.293     0.150
    74.439   169.793     0.150
    12.937   194.793     0.150
    12.937   335.793     0.150
    15.721   381.793     0.150
    15.721   480.793     0.150
    53.541   -64.309     0.150
     1.136    21.492     0.150
     1.136    35.895     0.150
     1.154    17.793     0.150
     1.154    34.793     0.150
     0.625    30.934     0.150
     2.560    41.793     0.150
     2.560    41.793     0.150
     2.560    75.191     0.150
     2.714    77.793     0.150
     3.697    58.793     0.150
     3.697   102.793     0.150
     4.675    78.793     0.150
     4.675   131.293     0.150
     5.007   165.793     0.150
     6.054   132.793     0.150
     6.054   207.793     0.150
     6.585    98.523     0.150
     7.243   181.684     0.150
     7.374   183.223     0.150
     8.960   225.824     0.150
     9.193   234.656     0.150
     9.324   236.297     0.150
    12.077   169.793     0.150
    12.077   300.293     0.150
    12.937   194.793     0.150
    12.937   335.793     0.150
    14.904   212.793     0.150
    14.904     3.500     0.150
    14.904   223.094     0.150
    15.721   381.793     0.150
    15.721   480.793     0.150
    29.812   371.492     0.150
    40.495   460.293     0.150
    56.436   582.691     0.150
    66.548   654.145     0.150
    66.666   655.191     0.150
    75.035   699.191     0.150
    83.533   745.484     0.150
     6.097    86.734     0.150
     6.097    89.719     0.150
     6.097    87.406     0.150
    59.748     2.508     0.150
    59.748     6.008     0.150
     0.995    19.328     0.150
     1.112    17.406     0.150
     1.112    33.406     0.150
     1.178    47.109     0.150
     2.358    76.207     0.150
     2.774    84.508     0.150
     2.983    49.508     0.150
     2.983   102.109     0.150
     3.626    58.707     0.150
     3.626   104.109     0.150
    59.721     2.695     0.150
    58.361     4.195     0.150
    58.361     6.195     0.150
     1.166    17.695     0.150
     1.166    32.695     0.150
     2.300    44.797     0.150
     2.300    75.195     0.150
     2.695    46.695     0.150
     2.695    79.695     0.150
     2.758    48.492     0.150
     2.925    53.695     0.150
     3.568   102.797     0.150
    59.747     2.711     0.150
    59.747     4.211     0.150
     0.143     5.328     0.150
     0.257     6.008     0.150
    59.746     3.109     0.150
    59.746     6.609     0.150
    58.376    63.609     0.150
    58.376    66.109     0.150
    58.376     2.500     0.150
     0.251     7.109     0.150
     0.924     7.711     0.150
     1.144    18.109     0.150
     1.144    33.109     0.150
     2.315    74.609     0.150
     2.547    73.109     0.150
     2.968    49.312     0.150
     2.941 79996.109     0.150
     2.941 80016.109     0.150
     3.134    52.609     0.150
     3.134    90.609     0.150
    59.736     2.297     0.150
    59.736     5.797     0.150
     0.215    35.680     0.150
     0.215    38.836     0.150
     0.260     6.648     0.150
     0.814    28.547     0.150
     1.141    30.297     0.150
     0.120     2.848     0.150
     0.120     5.098     0.150
    58.410     2.598     0.150
    58.410     5.348     0.150
   106.848     4.246     0.150
   106.848     7.488     0.150
     0.688    11.699     0.150
     0.843    29.348     0.150
     1.170    42.996     0.150
     2.049    65.598     0.150
     2.348    44.496     0.150
     2.348    76.098     0.150
     2.578    45.598     0.150
    70.610     1.320     0.150
    70.610     2.820     0.150
    59.745     2.320     0.150
    59.745     5.820     0.150
     0.100     1.570     0.150
     0.100     4.070     0.150
     0.188     2.820     0.150
     0.188     5.320     0.150
    58.383     3.320     0.150
    58.383     5.820     0.150
     0.205     3.070     0.150
     0.205     6.070     0.150
     2.021    64.820     0.150
     2.322    44.523     0.150
     2.322    75.320     0.150
    70.481     4.461     0.150
    70.481     5.711     0.150
     0.185     3.891     0.150
     0.239     3.461     0.150
     0.239     5.961     0.150
    53.530     4.109     0.150
    53.530     7.383     0.150
    58.254     5.961     0.150
    58.254     9.711     0.150
     0.720    23.562     0.150
     1.035    35.258     0.150
     1.035    47.164     0.150
    59.690     5.688     0.150
     0.170     3.867     0.150
     0.170     6.531     0.150
    59.690     3.688     0.150
    53.540     3.781     0.150
    53.540     5.875     0.150
     0.230     5.938     0.150
     0.230     9.688     0.150
    58.263     4.188     0.150
    58.263     7.438     0.150
    59.625     3.117     0.150
    59.625     5.117     0.150
    70.502     5.117     0.150
    70.502     6.320     0.150
     0.215     7.516     0.150
     0.268     5.266     0.150
    53.539     2.297     0.150
    53.539     8.016     0.150
     0.301     3.617     0.150
     0.301     7.617     0.150
    70.610     1.195     0.150
    70.610     1.945     0.150
     0.068     4.594     0.150
     0.068     8.086     0.150
    59.739    21.195     0.150
    59.739    37.695     0.150
     0.212     1.695     0.150
     0.212     4.695     0.150
     0.263     6.445     0.150
     0.263     9.945     0.150
     0.541    11.445     0.150
    59.739    17.195     0.150
    59.739    29.945     0.150
     3.592     6.895     0.150
     3.592    94.695     0.150
    59.691     3.180     0.150
    59.691     4.680     0.150
     0.216    -6.820     0.150
     0.216    -3.320     0.150
    59.691     3.930     0.150
    59.691     7.180     0.150
    58.262     5.680     0.150
    58.262     9.930     0.150
    53.540     5.031     0.150
    53.540     8.391     0.150
     1.292    42.180     0.150
     2.201    41.281     0.150
     2.201    70.879     0.150
     0.045    -5.352     0.150
     0.045    -3.852     0.150
    59.746     2.648     0.150
    59.746     4.148     0.150
    59.746     3.148     0.150
    59.746     8.648     0.150
     0.208     3.148     0.150
    58.385     4.398     0.150
    58.385     7.398     0.150
     0.260    11.648     0.150
    53.658     7.539     0.150
    53.658    12.180     0.150
    59.746    17.547     0.150
    59.746    29.797     0.150
     1.138    40.148     0.150
     0.055     4.168     0.150
    59.718     2.719     0.150
    59.718     5.719     0.150
    59.718     2.469     0.150
    59.718     4.719     0.150
    58.363     4.469     0.150
    58.363     6.969     0.150
     0.267     7.219     0.150
     0.267    13.219     0.150
    53.632     7.088     0.150
    53.632    12.488     0.150
     0.806   614.969     0.150
    59.718    16.719     0.150
    59.718    28.719     0.150
     1.092    32.039     0.150
     1.166    39.520     0.150
     2.302    44.619     0.150
     2.302    75.219     0.150
    59.747     2.398     0.150
    59.747     4.898     0.150
    59.747     3.148     0.150
    58.374     4.398     0.150
    58.374     7.398     0.150
     0.373    13.109     0.150
     0.528    15.148     0.150
     0.802    23.148     0.150
     0.808    36.398     0.150
    59.747    16.898     0.150
    59.747    36.898     0.150
    59.704     3.230     0.150
    59.704     5.230     0.150
    59.704     5.230     0.150
    58.265     5.730     0.150
    58.265     8.730     0.150
    53.546     5.410     0.150
    53.546     8.832     0.150
     0.706    20.980     0.150
     0.717    21.230     0.150
    59.704    14.480     0.150
     1.140    16.402     0.150
     1.140    28.082     0.150
     1.244    24.730     0.150
     1.903    60.730     0.150
     2.205    42.629     0.150
     2.205    72.230     0.150
     2.445    76.930     0.150
     2.605    52.129     0.150
     3.479    70.930     0.150
     3.479   115.930     0.150
    45.893    47.629     0.150
    45.893    88.332     0.150
     4.377    83.730     0.150
     7.375    87.539     0.150
     7.375   186.520     0.150
     1.034    20.031     0.150
     1.034    33.930     0.150
     1.244    24.730     0.150
     1.244    40.730     0.150
     1.903    60.730     0.150
     2.206    42.629     0.150
     2.206    72.230     0.150
     2.445    40.430     0.150
     2.445    76.930     0.150
     2.502    42.230     0.150
     2.502    75.230     0.150
     2.502    42.230     0.150
     2.502    75.230     0.150
     2.605    52.129     0.150
     2.605    81.531     0.150
     3.377    53.129     0.150
     3.479    70.930     0.150
     3.479   115.930     0.150
     3.594   101.332     0.150
     4.377    83.730     0.150
     4.574   129.730     0.150
     7.375   110.039     0.150
     7.375   186.520     0.150
     7.375   235.789     0.150
     7.375   235.852     0.150
    46.278   506.004     0.150
    59.708     3.395     0.150
    59.708     5.895     0.150
     0.225     5.895     0.150
     0.225     8.895     0.150
    58.267     5.395     0.150
    58.267     9.145     0.150
    59.708    15.344     0.150
    59.708    26.344     0.150
    59.718     2.465     0.150
    59.718     3.965     0.150
     0.243     7.175     0.150
    53.634     7.166     0.150
    53.634    11.525     0.150
    59.718    13.715     0.150
     0.023     2.832     0.150
     0.023     4.633     0.150
     0.113     3.002     0.150
    59.744     2.332     0.150
    59.744     3.832     0.150
     0.060     2.502     0.150
     0.060     4.232     0.150
    58.398     4.332     0.150
    58.398     6.832     0.150
     0.224     4.492     0.150
     0.261     5.232     0.150
     0.261     8.652     0.150
     0.272     5.402     0.150
     0.300     7.932     0.150
     0.395     3.662     0.150
    53.668     7.602     0.150
    53.668    12.732     0.150
    59.744    18.582     0.150
    59.744    30.332     0.150
    59.667     4.215     0.150
    59.667     6.715     0.150
     0.266     6.215     0.150
     0.266     9.965     0.150
     0.291     9.484     0.150
    59.667    20.016     0.150
    59.667    30.016     0.150
     0.048     4.328     0.150
     0.048     6.328     0.150
     0.025     5.228     0.150
     0.025     6.728     0.150
     0.187     5.328     0.150
     0.187     7.828     0.150
     0.065     4.328     0.150
     0.065     6.228     0.150
    59.773     2.328     0.150
    59.773     4.328     0.150
    58.395     4.078     0.150
    58.395     6.578     0.150
     0.260    64.728     0.150
    59.773    18.828     0.150
    59.773    30.828     0.150
     1.119    24.228     0.150
     0.062     2.359     0.150
    59.733     2.059     0.150
    59.733     4.559     0.150
     0.111   -13.941     0.150
     0.191     2.309     0.150
     0.191     4.809     0.150
    58.392     4.059     0.150
    58.392     6.559     0.150
    53.659     7.387     0.150
    53.659    12.379     0.150
    59.733    17.309     0.150
     1.189    41.059     0.150
     2.330    44.559     0.150
     2.330    76.160     0.150
    59.734     1.992     0.150
    59.734     3.992     0.150
     0.298     6.172     0.150
    53.660     7.422     0.150
    53.660    12.191     0.150
    59.734    19.742     0.150
     0.073     3.008     0.150
     0.073     4.977     0.150
    58.433     3.656     0.150
    58.433     6.156     0.150
    58.433     2.500     0.150
     0.090     3.105     0.150
    59.809     2.906     0.150
     0.111     3.266     0.150
     0.185     4.168     0.150
     0.185     7.016     0.150
     0.157     6.438     0.150
     0.241     5.477     0.150
     0.291    15.508     0.150
     0.312    10.355     0.150
     0.305     6.156     0.150
    53.717     8.367     0.150
    53.717    13.707     0.150
     0.998    30.078     0.150
     1.075    29.906     0.150
     1.405    39.105     0.150
     2.662    42.906     0.150
     2.771    46.406     0.150
    46.062    46.707     0.150
    46.062    84.605     0.150
     3.364   106.406     0.150
    46.854    56.105     0.150
    46.854    98.105     0.150
     4.745    78.406     0.150
   109.425    51.906     0.150
   109.425   102.906     0.150
     5.698   152.125     0.150
     9.852   136.305     0.150
     9.852   238.305     0.150
    74.387   168.906     0.150
    74.387   294.906     0.150
    12.883   312.906     0.150
    13.082   321.047     0.150
    13.837   341.957     0.150
    15.657   212.906     0.150
    15.657   375.906     0.150
     1.075    30.105     0.150
     1.160    22.105     0.150
     1.160    37.305     0.150
     0.658    29.797     0.150
     2.376    62.605     0.150
     2.496    40.805     0.150
     2.496    72.008     0.150
     2.530    40.906     0.150
     2.530    74.406     0.150
     2.597    43.605     0.150
     2.597    77.605     0.150
     3.355    56.906     0.150
     3.651    57.508     0.150
     3.651    99.305     0.150
     3.766    59.906     0.150
     3.766   104.906     0.150
     4.549   120.906     0.150
     4.745    78.406     0.150
     4.745   129.906     0.150
     5.698   151.828     0.150
     7.305   104.797     0.150
     7.305   233.438     0.150
     7.305   233.707     0.150
     8.307   123.000     0.150
     8.360   123.441     0.150
     8.400   124.117     0.150
     8.412   124.609     0.150
     8.427   124.203     0.150
     8.433   124.348     0.150
     8.460   124.648     0.150
     8.464   125.871     0.150
     8.486   125.004     0.150
     8.524   125.695     0.150
     8.536   224.746     0.150
     8.536   224.246     0.150
     8.531   125.500     0.150
     8.533   125.680     0.150
     8.558   124.980     0.150
     8.553   125.926     0.150
     8.726   125.555     0.150
     8.726   220.125     0.150
     8.681   127.270     0.150
     8.681   228.578     0.150
     8.731   127.695     0.150
     8.461   129.766     0.150
     8.461   225.797     0.150
     9.090   235.832     0.150
     9.090   235.742     0.150
     9.176   132.043     0.150
     9.176   236.785     0.150
     9.192   131.922     0.150
     9.267   241.469     0.150
     9.267   137.129     0.150
     9.267   240.969     0.150
     9.304   133.535     0.150
    12.022   288.906     0.150
    12.167   294.906     0.150
    12.811   178.895     0.150
    12.811   407.805     0.150
    12.811   407.805     0.150
    12.883   313.406     0.150
    12.907   178.406     0.150
    12.907   323.906     0.150
    12.907   178.406     0.150
    12.907   323.906     0.150
    13.025   183.906     0.150
    13.025   327.906     0.150
    15.657   212.906     0.150
    15.657   375.906     0.150
    20.963   517.906     0.150
    21.209     7.000     0.150
    21.209     9.000     0.150
    21.209   285.406     0.150
    21.209     9.000     0.150
    21.294   286.305     0.150
    21.344   286.906     0.150
    23.885   312.406     0.150
    24.272   318.707     0.150
    24.622   319.207     0.150
    24.622   578.406     0.150
    25.211     3.500     0.150
    26.836   378.906     0.150
    26.836   340.406     0.150
    26.836   378.906     0.150
    27.462   346.508     0.150
    28.239   357.508     0.150
    29.540   364.707     0.150
    29.896   367.707     0.150
    30.862     9.000     0.150
    30.862   376.906     0.150
    30.862     9.000     0.150
    31.371   382.305     0.150
    31.379   380.906     0.150
    35.757   419.906     0.150
    36.853   428.406     0.150
    39.122   447.008     0.150
    39.122     9.098     0.150
    39.122    17.199     0.150
    39.122   538.105     0.150
    39.006   445.008     0.150
    45.749   500.406     0.150
    46.536   506.805     0.150
    46.854   509.305     0.150
    48.211   530.406     0.150
    50.019    13.508     0.150
    50.881   548.496     0.150
    51.600   546.008     0.150
    51.600    11.500     0.150
    51.934   549.008     0.150
    51.934    11.500     0.150
    52.284   550.406     0.150
    52.284    11.500     0.150
    52.379     4.000     0.150
    52.502   553.906     0.150
    52.707   553.406     0.150
    53.425   559.508     0.150
    53.441   558.207     0.150
    53.771   559.805     0.150
    53.771   559.805     0.150
    54.120   563.508     0.150
    55.745   575.406     0.150
    57.191   586.707     0.150
    58.110   591.707     0.150
    59.429   602.105     0.150
    60.314   608.508     0.150
    62.433   621.508     0.150
    66.600   653.707     0.150
    78.216   718.105     0.150
    78.635   720.008     0.150
    86.790   762.305     0.150
    91.460   792.305     0.150
    59.763     2.156     0.150
    59.763     3.656     0.150
     0.158     3.656     0.150
     0.253   -10.344     0.150
     0.259    18.516     0.150
    53.671     7.469     0.150
    53.671    12.234     0.150
     0.815    13.156     0.150
     0.935    12.906     0.150
    59.763    12.859     0.150
    58.403     4.074     0.150
    58.403     6.824     0.150
    53.674     7.844     0.150
    53.674    13.273     0.150
    59.749    17.074     0.150
    59.749    30.324     0.150
     1.123    20.074     0.150
     1.123    37.074     0.150
     2.342    75.773     0.150
     2.567    44.074     0.150
    59.754     2.145     0.150
    58.415     3.895     0.150
    58.415     6.145     0.150
     0.175     4.145     0.150
     0.279     9.113     0.150
     0.314     6.426     0.150
     0.314     8.844     0.150
    53.686     7.875     0.150
    53.686    12.543     0.150
    59.754    18.645     0.150
   135.997    22.645     0.150
   135.997    38.445     0.150
     2.054    38.145     0.150
     2.054    65.145     0.150
     2.354    45.445     0.150
     0.116   -54.516     0.150
    59.759     2.047     0.150
    59.759     3.547     0.150
     0.163   -54.453     0.150
    58.398     3.297     0.150
    58.398     3.320     0.150
     0.213    64.484     0.150
    53.673     7.656     0.150
    53.673    11.805     0.150
     0.664    18.398     0.150
    59.759    19.547     0.150
     1.122    26.945     0.150
     1.122    32.148     0.150
    59.746     2.602     0.150
    59.746     4.602     0.150
    58.403     4.102     0.150
    58.403     6.852     0.150
     0.278   -33.398     0.150
    53.673     7.828     0.150
    53.673    11.102     0.150
     0.560    15.602     0.150
     0.560    22.852     0.150
     2.342    93.102     0.150
     3.611    81.102     0.150
    59.739     2.742     0.150
    59.739     4.742     0.150
    53.641     7.125     0.150
    53.641    10.266     0.150
    59.742     2.822     0.150
    59.742     4.822     0.150
    58.370     4.322     0.150
    58.370     6.822     0.150
     0.250   -15.178     0.150
    53.645     7.172     0.150
    53.645    10.112     0.150
    59.741     1.801     0.150
    59.741     3.301     0.150
     0.181     4.301     0.150
     0.268   -25.449     0.150
    53.659     7.562     0.150
    53.659    12.172     0.150
    58.464     3.195     0.150
    58.464     6.195     0.150
    59.782    -8.305     0.150
    59.782     2.695     0.150
     0.170     4.695     0.150
     0.336    11.066     0.150
    53.734     8.895     0.150
    53.734    14.934     0.150
     1.024    30.844     0.150
     1.209     8.094     0.150
     1.209    24.496     0.150
    46.858    57.297     0.150
    46.858   100.195     0.150
     5.751   156.145     0.150
     7.343   136.234     0.150
    70.620     2.766     0.150
    70.620     4.266     0.150
    59.750     3.016     0.150
     0.070     2.625     0.150
     0.070     4.715     0.150
    58.393     4.016     0.150
    58.393     6.516     0.150
    58.393     2.500     0.150
     0.205     4.645     0.150
     0.205     7.395     0.150
     0.214     7.414     0.150
     0.210     2.516     0.150
     0.210     5.617     0.150
     0.208     4.746     0.150
     0.266     9.316     0.150
     2.853    46.715     0.150
     2.853    80.016     0.150
     2.958    49.016     0.150
    46.797    56.914     0.150
    46.797    97.617     0.150
     3.720    60.016     0.150
     4.698    77.016     0.150
   109.365    74.016     0.150
   109.365   130.016     0.150
     9.906   238.016     0.150
    12.058   294.016     0.150
    74.420   170.016     0.150
    74.420   299.016     0.150
    12.927   187.016     0.150
    15.707   221.016     0.150
     1.130    35.016     0.150
     1.148    22.215     0.150
     1.148    36.914     0.150
     0.638    30.336     0.150
     2.032    64.016     0.150
     2.557    42.516     0.150
     2.557    42.516     0.150
     2.557    74.016     0.150
     2.626    44.516     0.150
     2.626    76.016     0.150
     2.734    45.016     0.150
     2.734    77.016     0.150
     2.734   140.016     0.150
     2.984    86.016     0.150
     3.090    87.277     0.150
     3.720    60.016     0.150
     4.499    68.816     0.150
     5.725   188.676     0.150
     5.725   189.094     0.150
     6.119    91.516     0.150
     6.931   172.816     0.150
     7.358   105.316     0.150
     8.406   223.277     0.150
     8.409   220.848     0.150
     8.423   222.191     0.150
     8.461   222.859     0.150
     8.515   223.410     0.150
     8.541   223.062     0.150
     8.545   223.410     0.150
     8.780   166.074     0.150
     8.683   222.707     0.150
     8.959   129.688     0.150
     8.512   132.445     0.150
     8.512   229.605     0.150
     8.512   234.457     0.150
     8.512   234.535     0.150
     9.173   231.848     0.150
     9.182   234.758     0.150
     9.906   142.484     0.150
    10.225   159.016     0.150
    10.672   149.918     0.150
    11.214   366.715     0.150
    11.214   382.516     0.150
    12.058   294.016     0.150
    12.859   312.637     0.150
    12.927   187.016     0.150
    12.927   327.016     0.150
    12.965   311.016     0.150
    14.916     4.500     0.150
    14.916     6.301     0.150
    15.707   221.016     0.150
    18.977     7.602     0.150
    18.977    11.102     0.150
    21.202    16.000     0.150
    21.202    23.000     0.150
    21.202   285.016     0.150
    21.202    16.000     0.150
    21.202    23.000     0.150
    21.318   287.414     0.150
    21.386   287.215     0.150
    21.386   531.316     0.150
    21.916   662.516     0.150
    23.829   312.117     0.150
    25.209     7.199     0.150
    26.797   340.215     0.150
    27.429   343.406     0.150
    27.429   343.414     0.150
    27.805   350.316     0.150
    30.817   377.016     0.150
    30.817     8.000     0.150
    31.357   382.117     0.150
    31.365     4.000     0.150
    31.365    10.000     0.150
    31.365   381.016     0.150
    31.365    10.000     0.150
    35.727   419.316     0.150
    36.808   428.840     0.150
    36.808   428.816     0.150
    36.808   570.016     0.150
    39.066    16.203     0.150
    38.948   445.617     0.150
    46.478   506.414     0.150
    46.797   508.715     0.150
    48.160   514.016     0.150
    51.549   545.715     0.150
    51.883   548.414     0.150
    53.373   559.316     0.150
    53.373   559.316     0.150
    53.722   560.914     0.150
    53.715   562.516     0.150
    53.753   560.816     0.150
    53.850   562.715     0.150
    54.016   562.914     0.150
    54.071   563.117     0.150
    55.433   573.016     0.150
    55.703   575.516     0.150
     0.021   578.816     0.150
    58.152   591.215     0.150
    61.476   614.016     0.150
    61.476   614.016     0.150
    62.429   621.617     0.150
    78.165   717.414     0.150
    81.703   738.117     0.150
    86.734   764.094     0.150
    86.734   764.117     0.150
    91.507   778.117     0.150
   153.581  1198.117     0.150
    72.795   688.891     0.150
    70.610     2.543     0.150
    70.610     2.793     0.150
    59.739     2.543     0.150
    59.739     4.293     0.150
     0.111     3.473     0.150
     0.183     4.293     0.150
    58.385     3.043     0.150
    58.385     5.543     0.150
    70.628     2.680     0.150
    70.628     4.180     0.150
    58.402     3.980     0.150
    58.402     6.531     0.150
     0.199     4.680     0.150
     0.199     8.180     0.150
     0.218     2.480     0.150
     0.218     5.680     0.150
    70.615     2.727     0.150
    70.615     3.727     0.150
    59.746     2.477     0.150
    59.746     3.977     0.150
     0.176     3.977     0.150
    58.389     3.977     0.150
    58.389     6.477     0.150
     0.212     5.078     0.150
     0.387    13.477     0.150
     1.135    39.180     0.150
     1.183    25.180     0.150
     2.328    76.078     0.150
    70.570     3.500     0.150
    70.570     4.250     0.150
    59.729     3.250     0.150
    59.729     4.250     0.150
     0.204     5.047     0.150
    58.343     4.750     0.150
    58.343     7.203     0.150
     1.066    29.398     0.150
     1.176    39.852     0.150
     1.221    41.953     0.150
     2.282    73.750     0.150
    70.649     3.039     0.150
    70.649     5.039     0.150
    59.765     3.289     0.150
    59.765     4.789     0.150
     0.166     4.289     0.150
    58.422     3.789     0.150
    58.422     6.039     0.150
    70.624     2.797     0.150
    70.624     4.797     0.150
    70.624     2.000     0.150
    59.749     3.047     0.150
    59.749     4.547     0.150
    58.398     4.047     0.150
    58.398     6.797     0.150
     0.219     8.250     0.150
     0.215     2.547     0.150
     0.215     4.594     0.150
     0.215     2.050     0.150
    59.747     2.725     0.150
    59.747     3.975     0.150
    58.378     3.975     0.150
    58.378     6.475     0.150
     0.250     8.844     0.150
     0.252    -3.025     0.150
     0.031     2.148     0.150
     0.031     4.109     0.150
    59.737     2.598     0.150
    59.737     4.098     0.150
    70.658     3.020     0.150
    70.658     3.707     0.150
     0.148     6.137     0.150
    58.437     3.598     0.150
    58.437     6.098     0.150
     0.205     4.098     0.150
     0.066     3.055     0.150
    59.759     4.305     0.150
    59.759     6.055     0.150
     0.188    -3.695     0.150
     0.188    -0.695     0.150
    58.381     4.555     0.150
    58.381     4.555     0.150
    58.381     7.555     0.150
    58.381     7.555     0.150
     0.244   -52.445     0.150
     0.273     8.174     0.150
    59.746     2.867     0.150
    59.746     4.367     0.150
    58.385     4.617     0.150
    58.385     4.617     0.150
    58.385     6.617     0.150
    58.385     6.617     0.150
     0.205     0.617     0.150
     0.205    -0.633     0.150
    53.658     7.461     0.150
    53.658    10.469     0.150
     0.034    -4.438     0.150
     0.034    -2.938     0.150
    59.735     3.359     0.150
    59.735     5.109     0.150
    58.385     4.359     0.150
    58.385     4.359     0.150
    58.385     7.359     0.150
    58.385     7.359     0.150
     0.217    -3.641     0.150
     0.217    -0.391     0.150
     0.291     8.500     0.150
    53.655     7.500     0.150
    53.655     9.711     0.150
    58.392     4.066     0.150
    58.392     6.867     0.150
     0.390    13.148     0.150
    59.630     4.977     0.150
     0.288     3.727     0.150
    58.287     5.926     0.150
    58.287     9.227     0.150
     1.182    22.738     0.150
     1.260    44.426     0.150
   135.849    25.727     0.150
   135.849    42.727     0.150
     1.311    42.926     0.150
     1.935    61.727     0.150
     2.225    42.027     0.150
     2.225    71.625     0.150
     0.044     1.164     0.150
     0.044     2.664     0.150
    59.717     3.664     0.150
    59.717     5.164     0.150
     0.202     1.414     0.150
     0.202     4.164     0.150
    58.357     4.664     0.150
    58.357    21.164     0.150
     0.223    56.664     0.150
     0.223    59.664     0.150
    58.394    -2.155     0.150
    58.394     0.595     0.150
     0.173     1.095     0.150
     0.173     3.595     0.150
     0.053    -0.655     0.150
     0.053     1.345     0.150
    59.750     3.345     0.150
    59.750     5.345     0.150
     0.206    56.845     0.150
     0.206    59.845     0.150
   135.983    23.345     0.150
     2.333    76.445     0.150
     0.047     0.559     0.150
     0.029     0.660     0.150
     0.029     2.258     0.150
     2.324    75.059     0.150
     2.690    77.559     0.150
    46.012    41.457     0.150
     0.041     0.176     0.150
     0.041     0.574     0.150
     0.298     8.465     0.150
    53.673     7.746     0.150
    53.673    11.555     0.150
     0.052     4.695     0.150
     0.235     6.891     0.150
    74.218     4.094     0.150
    74.218     9.094     0.150
   106.848     4.844     0.150
   106.848     6.594     0.150
    53.636     6.891     0.150
    53.636    10.695     0.150
     1.205    41.094     0.150
     0.204     4.910     0.150
     0.390     9.961     0.150
    53.695     8.230     0.150
    53.695    13.172     0.150
     1.101    -8.039     0.150
     2.361    74.660     0.150
    46.049    51.859     0.150
    46.049    89.961     0.150
    46.824    56.062     0.150
    46.824    97.660     0.150
   109.384   128.961     0.150
     1.101    -8.039     0.150
     1.101    35.961     0.150
     1.170    22.762     0.150
     1.170    38.160     0.150
     1.504    28.160     0.150
     1.504    48.660     0.150
     1.813    58.789     0.150
     2.362    74.660     0.150
     2.562    42.961     0.150
     2.562    75.961     0.150
     2.562    42.961     0.150
     2.562    75.961     0.150
     2.762    83.961     0.150
     2.950    51.859     0.150
     3.342    83.961     0.150
     3.632    57.461     0.150
     3.632   100.062     0.150
     3.749   106.160     0.150
     4.314    65.859     0.150
     4.528    69.961     0.150
     4.727    77.961     0.150
     4.727   132.461     0.150
     4.975   133.961     0.150
     5.159   133.020     0.150
     5.500   170.961     0.150
     6.537    96.660     0.150
     7.852   111.980     0.150
    12.852   334.961     0.150
    12.922  -105.039     0.150
    46.409   505.887     0.150
    49.430   531.094     0.150
    62.448   625.730     0.150
     6.148    96.160     0.150
     6.148    88.949     0.150
     6.148    88.387     0.150
     6.148    98.625     0.150
     6.148    92.617     0.150
     6.148    99.090     0.150
     6.148    86.422     0.150
     6.148    96.484     0.150
     6.148    90.715     0.150
     6.148    87.094     0.150
     6.148   164.590     0.150
     6.148   164.273     0.150
     6.148   158.699     0.150
     6.148   167.738     0.150
     6.148   158.426     0.150
    72.766   688.297     0.150
    74.242     3.914     0.150
    74.242     6.914     0.150
   106.869     5.414     0.150
   106.869     7.914     0.150
    53.636     6.766     0.150
    53.636    10.688     0.150
     1.104    34.914     0.150
     0.191     3.948     0.150
     0.191     7.948     0.150
   106.868     5.198     0.150
   106.868     8.448     0.150
    74.233     4.948     0.150
    74.233     9.948     0.150
    53.660     7.338     0.150
    53.660    12.348     0.150
   137.444     4.948     0.150
   137.444     9.948     0.150
     2.323    75.848     0.150
    12.946   171.948     0.150
    12.946   171.948     0.150
    59.737     1.749     0.150
    59.737     3.749     0.150
   106.845     4.699     0.150
   106.845     6.499     0.150
    74.205     5.999     0.150
    74.205     7.999     0.150
     0.025    -0.223     0.150
    59.747     2.176     0.150
    58.390     3.426     0.150
    58.390     5.676     0.150
   106.855     5.477     0.150
   106.855     7.676     0.150
    74.217     4.676     0.150
    74.217     8.176     0.150
     0.289     5.035     0.150
    53.820     6.676     0.150
    53.820    11.176     0.150
    53.662     7.414     0.150
    53.662    12.047     0.150
     1.134    40.676     0.150
    59.708     1.953     0.150
    59.708     3.453     0.150
     0.049     0.203     0.150
     0.090     2.906     0.150
   106.802     4.203     0.150
   106.802     4.703     0.150
    58.449     3.453     0.150
    58.449     6.703     0.150
    74.144     6.203     0.150
    74.144    11.203     0.150
    53.699     8.820     0.150
    53.699    13.812     0.150
     0.018     0.020     0.150
     0.025     0.020     0.150
    59.750     2.020     0.150
     0.054     2.510     0.150
     0.117     3.080     0.150
     0.179     2.770     0.150
     0.179     5.520     0.150
    58.415     3.520     0.150
    58.415     5.770     0.150
     0.278     5.520     0.150
     0.289     5.670     0.150
     0.289     8.859     0.150
     0.316     6.480     0.150
     0.316     7.600     0.150
     0.316     9.709     0.150
    53.684     7.840     0.150
    53.684    12.020     0.150
    59.714     2.316     0.150
    59.714     4.816     0.150
     0.063     1.316     0.150
     0.102    -0.684     0.150
     0.102     2.016     0.150
    58.468     4.066     0.150
    58.468     7.566     0.150
     0.248     3.816     0.150
     0.248     7.566     0.150
     0.395     7.047     0.150
    53.891     6.316     0.150
    53.891     8.316     0.150
    59.706     1.969     0.150
    59.706     4.219     0.150
   106.799     4.219     0.150
   106.799     8.719     0.150
    58.454     3.969     0.150
    58.454     6.219     0.150
     0.385    11.250     0.150
    53.703     8.758     0.150
    53.703    14.141     0.150
    53.877     8.719     0.150
    53.877    15.219     0.150
     0.076     3.221     0.150
    59.649     2.740     0.150
    59.649     5.490     0.150
     0.117     0.740     0.150
     0.117     3.240     0.150
     0.158    -3.439     0.150
     0.158     5.439     0.150
    53.600     7.109     0.150
    53.600    11.141     0.150
    59.747     2.207     0.150
    59.747     3.457     0.150
    58.388     2.957     0.150
    58.388     5.957     0.150
   106.855     4.957     0.150
   106.855     6.957     0.150
    74.218     4.457     0.150
    74.218     7.957     0.150
     0.261     4.328     0.150
     0.261     7.355     0.150
     0.288     8.355     0.150
    53.818     6.957     0.150
    53.818    10.957     0.150
     0.047    -1.945     0.150
     0.047    -0.645     0.150
    59.744     2.055     0.150
    59.744     3.805     0.150
    58.386     3.555     0.150
    58.386     6.055     0.150
   106.854     6.055     0.150
   106.854     8.055     0.150
    74.216     4.555     0.150
    74.216     8.055     0.150
    53.658     5.266     0.150
    53.658    11.055     0.150
    59.782     2.195     0.150
    59.782     4.695     0.150
     0.297     8.645     0.150
    53.703     8.137     0.150
    53.703    12.445     0.150
     0.014     2.055     0.150
    59.696     3.135     0.150
    59.696     5.385     0.150
    59.772     1.957     0.150
    58.435     2.707     0.150
    58.435     6.207     0.150
   106.873     3.907     0.150
   106.873     7.207     0.150
    74.222     5.207     0.150
    74.222    10.207     0.150
     0.401    10.707     0.150
    53.707     8.606     0.150
    53.707    13.707     0.150
     1.182    42.006     0.150
    59.772    23.207     0.150
    59.772    40.707     0.150
     2.374    43.207     0.150
     2.374    74.207     0.150
     2.638    76.106     0.150
     2.702    55.207     0.150
     2.702    91.707     0.150
    46.062    58.506     0.150
    46.062    91.506     0.150
     0.031    -1.750     0.150
     0.031     0.250     0.150
    59.737     2.352     0.150
    58.366     3.352     0.150
    58.366     5.852     0.150
   106.849     4.652     0.150
   106.849     5.953     0.150
    74.218     3.953     0.150
    74.218     8.852     0.150
   135.959    22.852     0.150
   135.959    37.852     0.150
     2.305    44.152     0.150
     2.305    74.551     0.150
     2.549    44.852     0.150
    59.704     1.699     0.150
    59.704     3.699     0.150
     0.151     1.348     0.150
     0.151     3.348     0.150
   106.797     2.949     0.150
    58.455     3.949     0.150
    58.455     6.949     0.150
     0.300     8.949     0.150
    74.136     5.949     0.150
    74.136    10.949     0.150
    53.703     8.820     0.150
    53.703    14.789     0.150
     0.085     6.605     0.150
     0.085     8.305     0.150
    59.731     2.805     0.150
    59.731     5.555     0.150
    74.230     3.805     0.150
    74.230     6.805     0.150
    59.731     6.805     0.150
    59.731     4.055     0.150
     0.230     4.004     0.150
   106.850     5.805     0.150
   106.850     8.703     0.150
    53.760    10.805     0.150
    53.607     6.395     0.150
    53.607     9.805     0.150
    53.760     9.805     0.150
     0.015     0.328     0.150
     0.015     2.023     0.150
    70.629     2.227     0.150
    70.629     4.727     0.150
    70.629     2.500     0.150
     0.063     0.430     0.150
     0.063     2.930     0.150
   106.857     4.727     0.150
   106.857     8.727     0.150
   106.857     4.000     0.150
    74.215     4.727     0.150
    74.215     7.727     0.150
    53.674     7.609     0.150
    53.674    12.727     0.150
     1.122    34.727     0.150
   135.988    21.430     0.150
   135.988    35.727     0.150
     2.342    75.828     0.150
     2.698    46.227     0.150
     2.698    80.227     0.150
     0.028     0.340     0.150
     0.028     1.941     0.150
    70.613     2.141     0.150
    70.613     3.641     0.150
   106.856     4.941     0.150
   106.856     6.141     0.150
    74.219     4.141     0.150
    74.219     7.641     0.150
     1.136    39.141     0.150
   135.977    23.441     0.150
   135.977    36.641     0.150
     2.325    44.840     0.150
     2.325    74.641     0.150
     0.105     2.672     0.150
   106.864     3.791     0.150
   106.864     6.291     0.150
    74.220     5.291     0.150
    74.220     8.291     0.150
    53.841     7.291     0.150
    53.841    12.291     0.150
     1.163    24.191     0.150
   135.998    21.791     0.150
     2.696    77.791     0.150
    46.813    57.592     0.150
    46.813   100.490     0.150
     0.085     2.629     0.150
     0.085     4.680     0.150
     0.023     1.479     0.150
     0.023     3.180     0.150
     0.062     0.379     0.150
     0.078    -0.121     0.150
     0.091     2.680     0.150
     0.091     4.680     0.150
     0.198     4.418     0.150
     0.198     7.479     0.150
     0.196     3.979     0.150
     0.196     6.479     0.150
     0.224     8.379     0.150
     0.310     6.100     0.150
     0.427     7.939     0.150
   136.024    21.578     0.150
   136.024    36.879     0.150
    46.838    58.279     0.150
    46.838    99.979     0.150
     0.055     2.484     0.150
     0.081     2.625     0.150
     0.081     4.754     0.150
   106.857     4.516     0.150
   106.857     5.516     0.150
     0.231     8.504     0.150
    74.210     4.766     0.150
    74.210     8.516     0.150
    53.851     7.266     0.150
    53.851    11.766     0.150
     0.419    14.215     0.150
   136.001    22.965     0.150
   136.001    37.965     0.150
    59.762     2.013     0.150
    59.762     5.013     0.150
     0.239   -22.487     0.150
    70.638     1.523     0.150
    70.638     3.523     0.150
     0.069     2.625     0.150
    59.786     2.023     0.150
    59.786     4.023     0.150
    74.252     4.023     0.150
    74.252     7.023     0.150
     0.361    10.523     0.150
     0.038     0.254     0.150
    70.624     2.254     0.150
    70.624     3.754     0.150
    59.747     1.754     0.150
    59.747     2.754     0.150
     0.220     3.664     0.150
    74.214     4.754     0.150
    74.214     7.754     0.150
     0.073     0.977     0.150
     0.073     3.176     0.150
    59.801     2.277     0.150
    59.801     5.777     0.150
     1.166    24.777     0.150
     1.166    41.176     0.150
   136.037    20.777     0.150
   136.037    33.477     0.150
     2.539    40.777     0.150
     3.765    55.777     0.150
     3.765   100.777     0.150
     7.314    77.777     0.150
     7.314   205.777     0.150
    74.385   299.777     0.150
    13.846   368.777     0.150
     1.166    24.777     0.150
     1.166    41.176     0.150
     0.662    29.387     0.150
     0.662    51.188     0.150
     2.539    40.777     0.150
     2.539    75.277     0.150
     2.772    49.777     0.150
     3.356   102.777     0.150
     3.548    58.477     0.150
     3.548   101.676     0.150
     3.650   104.078     0.150
     3.765    55.777     0.150
     3.765   100.777     0.150
     4.745   132.777     0.150
     5.701   145.438     0.150
     5.707   180.039     0.150
     6.526    96.156     0.150
     7.314    77.777     0.150
     8.508   129.066     0.150
     8.529   128.621     0.150
     8.530   128.863     0.150
     8.535   128.910     0.150
     8.544   128.012     0.150
    12.020   169.277     0.150
    12.020   297.777     0.150
    13.846   368.777     0.150
    25.204   325.777     0.150
    52.225   552.398     0.150
    53.437   561.605     0.150
    59.133   604.777     0.150
    59.265   602.578     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165   166.070     0.150
     6.165   165.730     0.150
     6.165   168.168     0.150
     6.165   167.832     0.150
     0.043    -0.504     0.150
     0.043    -0.504     0.150
     0.043     1.496     0.150
     0.043     1.496     0.150
    70.610     2.395     0.150
    70.610     3.395     0.150
     0.031     3.094     0.150
     0.053     0.695     0.150
    59.746     1.395     0.150
    59.746     3.395     0.150
   106.856     4.695     0.150
   106.856     6.395     0.150
    53.813     6.895     0.150
    53.813    10.395     0.150
     0.076     0.703     0.150
     0.076     2.500     0.150
    59.803     2.203     0.150
     0.175     8.703     0.150
   106.907     5.102     0.150
   106.907     7.203     0.150
    74.259     3.703     0.150
    74.259     8.703     0.150
    53.864     6.703     0.150
    53.864     9.203     0.150
     1.160    40.906     0.150
   136.036    21.406     0.150
   136.036    37.203     0.150
     2.371    45.203     0.150
     2.371    77.000     0.150
    70.590     2.484     0.150
    70.590     4.734     0.150
    59.737     1.484     0.150
     0.203     6.484     0.150
    74.220     3.484     0.150
   106.850     4.785     0.150
   106.850     9.484     0.150
     0.353     8.734     0.150
     1.122    40.484     0.150
   135.958    22.984     0.150
   135.958    37.984     0.150
     2.302    73.984     0.150
     0.104     5.262     0.150
    59.739     2.051     0.150
    59.739     4.051     0.150
    74.221     2.551     0.150
    74.221     6.051     0.150
    74.221     3.500     0.150
   106.851     5.051     0.150
   106.851     6.551     0.150
    53.794     6.551     0.150
    53.794    10.551     0.150
     0.075     4.734     0.150
     0.075     2.496     0.150
     0.078     2.676     0.150
     0.078     4.844     0.150
    59.777     1.574     0.150
    59.777     3.574     0.150
    59.777     2.000     0.150
     0.142     3.633     0.150
     0.210     4.113     0.150
     0.210     7.152     0.150
     0.313     5.895     0.150
    59.670     3.592     0.150
    59.670     1.842     0.150
    70.592     3.842     0.150
    70.592     5.842     0.150
   106.776     5.542     0.150
   106.776     6.142     0.150
    74.139     4.842     0.150
     0.285     3.142     0.150
     0.285     7.242     0.150
    70.620     2.066     0.150
    70.620     4.066     0.150
     0.083     3.916     0.150
     0.083     6.547     0.150
    59.767     1.566     0.150
     0.090     2.867     0.150
     0.090     5.127     0.150
     0.157     2.867     0.150
     0.157     3.807     0.150
     0.157     5.096     0.150
     0.281     5.596     0.150
     0.281     9.037     0.150
   106.877     5.066     0.150
   106.877     9.566     0.150
     2.331    72.967     0.150
     2.671    76.566     0.150
    46.019    42.367     0.150
    46.019    72.967     0.150
    46.805    59.467     0.150
    46.805   102.967     0.150
     1.136    37.566     0.150
     2.332    72.967     0.150
     2.538    42.566     0.150
     2.538    76.566     0.150
     2.927    72.967     0.150
     2.983   111.566     0.150
     3.720    56.166     0.150
     4.699   131.566     0.150
     5.706   150.727     0.150
     5.706   187.736     0.150
     5.791    87.557     0.150
     7.224   106.617     0.150
     8.422   125.010     0.150
     8.477   125.523     0.150
     8.562   125.895     0.150
    12.202   297.566     0.150
    13.866   304.467     0.150
    13.866   435.967     0.150
    54.163   571.516     0.150
    57.496   586.367     0.150
    58.075   584.867     0.150
    59.749     1.443     0.150
    59.749     3.443     0.150
     0.240     7.943     0.150
     0.263     2.443     0.150
     0.059     1.275     0.150
     0.059     2.775     0.150
    59.747     1.975     0.150
     1.107    21.275     0.150
     1.107    38.174     0.150
     2.294    73.475     0.150
     2.662    45.475     0.150
     2.662    78.975     0.150
     0.916    28.037     0.150
     0.779    29.537     0.150
     1.217    25.236     0.150
     1.217    42.838     0.150
     1.424    28.236     0.150
     1.756    57.637     0.150
     1.943    61.838     0.150
     2.055    65.438     0.150
     2.161    42.938     0.150
     2.161    74.637     0.150
     3.027    86.338     0.150
     3.027   566.338     0.150
     2.868 86343.039     0.150
     2.896    49.037     0.150
     4.555   124.637     0.150
     5.483   127.998     0.150
     5.483   150.156     0.150
     7.955   193.938     0.150
     7.955   205.047     0.150
     8.415   209.838     0.150
     9.415   141.037     0.150
     9.838   219.537     0.150
     9.838   278.037     0.150
    12.798   179.037     0.150
    13.136   185.037     0.150
    13.136   178.977     0.150
    13.136   312.057     0.150
    13.757   350.037     0.150
    14.239   201.008     0.150
    14.239   336.307     0.150
    14.339   342.338     0.150
    14.339   463.236     0.150
    14.802     4.898     0.150
    16.076   505.037     0.150
    16.076   229.037     0.150
    22.173     7.500     0.150
    22.173    13.000     0.150
    55.797   575.436     0.150
    57.371   585.838     0.150
    57.539   587.037     0.150
    57.835   588.936     0.150
    58.718   594.139     0.150
    61.793   615.236     0.150
     0.535    15.022     0.150
     2.656    75.022     0.150
     2.769    91.022     0.150
     2.769    95.022     0.150
     2.820    80.522     0.150
     2.969    49.422     0.150
     3.103    59.723     0.150
     4.359   123.623     0.150
     4.359   150.022     0.150
     4.738   143.022     0.150
     5.337    72.022     0.150
     5.337   126.022     0.150
     7.153    98.522     0.150
     7.153   184.192     0.150
     7.153   184.723     0.150
    12.639   325.022     0.150
    12.872   308.022     0.150
    12.872   389.022     0.150
    24.814   322.522     0.150
    24.814     4.500     0.150
     0.944   -28.664     0.150
     2.191    71.336     0.150
     2.470    66.836     0.150
     2.625    76.365     0.150
     0.648    78.365     0.150
     0.648    45.445     0.150
     3.334   138.836     0.150
     3.580    54.336     0.150
     4.993   137.336     0.150
     6.470    89.836     0.150
     6.865   102.996     0.150
     7.754   240.676     0.150
     7.754   241.205     0.150
     8.999   131.756     0.150
    13.165   187.336     0.150
    13.165   315.836     0.150
    13.516   336.336     0.150
    14.117   199.855     0.150
    76.125   708.387     0.150
     1.071    58.193     0.150
     2.651    83.253     0.150
     2.835    87.033     0.150
     2.835    59.193     0.150
     3.808    50.793     0.150
     3.808    96.293     0.150
     4.579    73.193     0.150
     4.783    65.193     0.150
     7.400   241.434     0.150
     7.400   241.483     0.150
    12.917   201.193     0.150
    21.293   290.723     0.150
     0.617    23.852     0.150
     1.528    31.891     0.150
     2.535    77.752     0.150
     2.828    82.271     0.150
     4.932    89.627     0.150
     5.392    78.352     0.150
     6.483   116.352     0.150
     7.692   198.002     0.150
     7.692   198.051     0.150
     9.112   226.652     0.150
    12.918   175.912     0.150
    12.918   320.252     0.150
    13.467   326.352     0.150
    45.765   501.252     0.150
    52.345   553.652     0.150
    77.741   719.312     0.150
     1.674    34.070     0.150
     1.674    54.602     0.150
     2.047    53.391     0.150
     2.459    36.094     0.150
     2.449    37.391     0.150
     2.449    77.391     0.150
     2.977   113.078     0.150
     2.977   113.758     0.150
     3.430    92.891     0.150
     9.142   226.719     0.150
     9.620   233.789     0.150
    10.397   261.711     0.150
    12.703   305.891     0.150
    13.064   313.891     0.150
    13.623   192.891     0.150
    13.623   329.391     0.150
    21.967     7.000     0.150
    26.070     8.000     0.150
    56.092   577.391     0.150
    56.227   577.094     0.150
    57.955   589.188     0.150
     1.164    26.348     0.150
     2.073    68.000     0.150
     2.565    60.199     0.150
     2.727    72.379     0.150
     2.720    80.199     0.150
     3.051   102.199     0.150
     3.392    88.730     0.150
     5.725   141.289     0.150
     5.725   183.688     0.150
     5.725   184.301     0.150
     7.510   240.418     0.150
     7.510   240.750     0.150
     9.251   144.199     0.150
     9.251   149.199     0.150
    10.062   145.340     0.150
    10.062   219.129     0.150
    13.155   316.199     0.150
    14.007   198.199     0.150
    14.007   351.199     0.150
    14.813   214.699     0.150
    21.305    19.000     0.150
    21.651   292.129     0.150
    25.338    11.000     0.150
    78.379   720.930     0.150
   111.624  1109.898     0.150
   120.446  1123.680     0.150
    49.148   527.797     0.150
     0.525    13.195     0.150
     0.525    22.195     0.150
     1.751    13.596     0.150
     3.165   105.195     0.150
     3.180    55.195     0.150
     3.180   101.195     0.150
     3.462   111.506     0.150
     3.517    57.734     0.150
     3.883    74.395     0.150
     4.465   125.195     0.150
     4.765   218.195     0.150
     4.740   144.195     0.150
     4.865    78.295     0.150
     4.865   157.996     0.150
     5.627    88.795     0.150
     6.237   206.135     0.150
     6.237   206.615     0.150
     7.200   236.506     0.150
     7.200   236.814     0.150
     7.713   199.564     0.150
     9.700   145.195     0.150
     9.700   249.295     0.150
    10.913   226.895     0.150
    11.997   291.965     0.150
    12.380   381.795     0.150
    12.558   187.195     0.150
    12.863   188.596     0.150
    12.863   330.096     0.150
    12.863   402.096     0.150
    12.914   170.195     0.150
    13.824   335.795     0.150
    13.824   427.395     0.150
    13.619   197.186     0.150
    18.777   259.195     0.150
    19.776   458.195     0.150
    21.253   318.695     0.150
    24.372     8.000     0.150
     0.523     8.031     0.150
     1.220    25.414     0.150
     1.220    45.266     0.150
     1.220    45.344     0.150
     1.718    56.836     0.150
     2.625    89.664     0.150
     2.793    92.234     0.150
     3.342    64.445     0.150
     3.342   119.281     0.150
     3.342   119.336     0.150
     3.295    55.711     0.150
     3.295    63.453     0.150
     4.174    65.992     0.150
     4.174   116.344     0.150
     4.384   116.336     0.150
     5.362    86.734     0.150
     5.362   152.234     0.150
     5.920   190.344     0.150
     5.920   190.531     0.150
     6.783   175.359     0.150
     7.161   224.641     0.150
     7.161   225.977     0.150
    10.015   256.938     0.150
    12.763   175.234     0.150
    12.763   310.234     0.150
    24.787     9.500     0.150
    62.421   623.031     0.150
     2.219    72.977     0.150
     2.635    38.977     0.150
     3.153   100.277     0.150
     3.537   112.945     0.150
     3.678   119.707     0.150
     3.678   120.207     0.150
    16.165   224.676     0.150
     2.599    91.965     0.150
     3.253   104.465     0.150
     3.225    91.676     0.150
     3.551   121.945     0.150
     3.551   121.945     0.150
     3.803   108.137     0.150
     3.927    74.266     0.150
     4.635   157.836     0.150
     4.635   158.656     0.150
     4.897    80.066     0.150
     6.327   208.684     0.150
     6.327   209.137     0.150
     7.279   227.496     0.150
     7.279   227.895     0.150
    10.865   271.465     0.150
    12.624   181.965     0.150
    12.624   304.965     0.150
    12.624   173.965     0.150
    12.624   181.965     0.150
    12.624   304.965     0.150
    12.947   199.965     0.150
    12.947   329.965     0.150
    12.947   344.965     0.150
    12.947   356.965     0.150
    12.947   359.965     0.150
    14.934   219.465     0.150
    14.934   219.465     0.150
    24.157   314.340     0.150
    24.924   329.074     0.150
    45.105   494.285     0.150
    53.124   555.434     0.150
    53.124   555.434     0.150
    54.386   564.840     0.150
    60.079   607.863     0.150
    61.412   613.664     0.150
    71.635   679.723     0.150
    78.805   720.664     0.150
    87.067   781.164     0.150
    87.067   763.410     0.150
   120.903  1131.289     0.150
     0.547    19.930     0.150
     1.272    19.029     0.150
     2.699    45.500     0.150
     2.840    75.430     0.150
     3.402    66.430     0.150
     3.667   111.219     0.150
     3.987   114.430     0.150
     5.968    81.660     0.150
     5.968   198.311     0.150
     5.968   199.770     0.150
     7.205   234.330     0.150
     7.205   235.650     0.150
     8.135   123.230     0.150
     9.641   140.879     0.150
     9.641   140.930     0.150
     9.992   146.830     0.150
     9.992   255.830     0.150
    11.346   169.430     0.150
    12.661   297.430     0.150
    12.680   308.430     0.150
    12.680   308.430     0.150
    12.810   187.430     0.150
    12.810   194.430     0.150
    12.810   309.480     0.150
    12.810   327.430     0.150
    12.810   339.430     0.150
    12.933   326.891     0.150
    16.778   408.980     0.150
    16.778   231.381     0.150
    16.778   408.980     0.150
    16.778   231.430     0.150
    20.641   277.830     0.150
    20.692   280.330     0.150
    20.692   285.230     0.150
    20.692   289.430     0.150
    20.692   507.029     0.150
    20.692   280.330     0.150
    20.692   289.430     0.150
    20.692   507.029     0.150
    20.713   279.430     0.150
    20.713   530.330     0.150
    20.713   530.279     0.150
    20.792   304.430     0.150
    20.792   506.430     0.150
    20.792   281.430     0.150
    20.792   -14.000     0.150
    20.792   -10.000     0.150
    20.792   304.430     0.150
    20.792   506.430     0.150
    20.792   520.430     0.150
    20.792   538.430     0.150
    20.792   281.430     0.150
    20.792   -10.000     0.150
    20.792   304.430     0.150
    20.792   506.430     0.150
    20.792   520.430     0.150
    20.792   538.430     0.150
    23.694     9.100     0.150
    24.050   312.150     0.150
    24.050   312.129     0.150
    24.745     8.100     0.150
    27.286   345.430     0.150
    27.687   352.629     0.150
    31.002   378.607     0.150
    31.002   378.629     0.150
    31.010   378.830     0.150
    35.539   417.529     0.150
    38.309   438.830     0.150
    38.309    10.600     0.150
    41.343     8.799     0.150
    41.343    11.799     0.150
    41.343   807.230     0.150
    41.343   848.629     0.150
    44.610   493.430     0.150
    46.977   510.680     0.150
    46.977   510.730     0.150
    48.400   519.701     0.150
    48.400   519.730     0.150
    49.936   533.518     0.150
    49.936   533.529     0.150
    50.911   539.922     0.150
    51.236   541.490     0.150
    51.236   541.492     0.150
    52.721   554.148     0.150
    52.721   554.129     0.150
    52.839   554.867     0.150
    52.839   554.830     0.150
    53.990   562.830     0.150
    53.990   563.230     0.150
    55.445   575.312     0.150
    61.145   745.830     0.150
    71.017   685.730     0.150
    71.017   726.029     0.150
    78.297   718.629     0.150
    78.789   721.529     0.150
    78.843   723.029     0.150
    87.001   763.529     0.150
     1.969    63.197     0.150
     2.312    71.867     0.150
     2.312    71.897     0.150
     2.414    45.897     0.150
     2.456    76.097     0.150
     2.885    89.277     0.150
     4.781   159.877     0.150
     4.781   160.397     0.150
     7.265   225.697     0.150
     7.265   225.787     0.150
    16.646   229.772     0.150
    45.446   498.403     0.150
    48.710   523.660     0.150
    52.399   550.491     0.150
    86.785   762.392     0.150
     1.287    21.708     0.150
     1.287    31.407     0.150
     1.929    60.308     0.150
     3.193    90.808     0.150
     3.589   100.208     0.150
     3.951    55.628     0.150
     3.951   101.208     0.150
     5.793   180.378     0.150
     5.793   180.857     0.150
     7.499   242.357     0.150
     7.499   242.397     0.150
     9.330   141.808     0.150
     9.330   147.107     0.150
     9.330   246.107     0.150
     9.330   517.808     0.150
    11.793   291.918     0.150
    11.905   172.788     0.150
    11.935   169.598     0.150
    12.251   173.317     0.150
    12.385   175.588     0.150
    12.553   178.928     0.150
    12.641   178.697     0.150
    12.674   181.048     0.150
    12.981   190.308     0.150
    12.981   196.308     0.150
    12.981   310.808     0.150
    12.981   324.308     0.150
    12.981   336.308     0.150
    12.981   531.308     0.150
    12.851   182.737     0.150
    13.119   180.808     0.150
    13.309   321.808     0.150
    13.235   188.298     0.150
    15.837   381.478     0.150
    16.356   395.562     0.150
    16.356   227.032     0.150
    16.356   401.383     0.150
    18.935     6.300     0.150
    20.125   272.338     0.150
    21.194     9.300     0.150
    21.194    13.500     0.150
    21.194    24.500     0.150
    22.314   278.808     0.150
    23.414   308.298     0.150
    23.414   308.208     0.150
    23.595   309.308     0.150
    23.595   309.329     0.150
    24.352     9.000     0.150
    24.413   314.508     0.150
    25.218     8.800     0.150
    26.699   618.708     0.150
    27.787   349.378     0.150
    27.979   354.808     0.150
    27.979    10.500     0.150
    29.670   761.808     0.150
    29.906    11.000     0.150
    30.096   366.308     0.150
    31.331   379.308     0.150
    31.794   384.107     0.150
    33.684    10.500     0.150
    35.658   417.508     0.150
    45.522   497.008     0.150
    46.219   503.907     0.150
    52.303   550.308     0.150
    53.226   557.808     0.150
    53.226   557.808     0.150
    53.223   556.407     0.150
    57.438   586.507     0.150
    61.350   612.507     0.150
    62.290   620.708     0.150
    64.451   631.019     0.150
    66.438   648.171     0.150
    68.514   656.808     0.150
    69.881   668.407     0.150
    74.935   696.558     0.150
    75.154   701.907     0.150
     1.929   728.417     0.150
    90.091   778.333     0.150
   120.356  1128.007     0.150
     0.538    32.562     0.150
     1.876    61.492     0.150
     2.167    69.461     0.150
     2.774    47.609     0.150
     3.001    85.961     0.150
     2.975    99.352     0.150
     2.975    99.660     0.150
     3.146    52.461     0.150
     3.146   104.461     0.150
     3.427   124.461     0.150
     3.892    55.941     0.150
     3.892   100.152     0.150
     3.892   122.801     0.150
     5.737   181.359     0.150
     5.737   181.422     0.150
    12.940   181.461     0.150
    12.995   203.461     0.150
    12.995   341.242     0.150
    13.098   181.961     0.150
    13.098   315.461     0.150
    13.310   329.461     0.150
    14.329   348.121     0.150
    16.382   396.895     0.150
    16.382   227.660     0.150
    25.282   322.262     0.150
    25.282     7.199     0.150
    31.765   398.461     0.150
    51.998   547.320     0.150
    86.607   761.160     0.150
     0.766    11.516     0.150
     0.772    10.477     0.150
     0.772    21.461     0.150
     0.860    37.117     0.150
     3.212    96.617     0.150
     3.212   107.617     0.150
     3.385    97.156     0.150
     3.385   114.578     0.150
     3.548   118.305     0.150
     3.548   118.336     0.150
     4.040    67.180     0.150
     7.519   256.977     0.150
     7.519   257.328     0.150
     9.339   226.773     0.150
    11.095   281.047     0.150
    11.095   281.141     0.150
    49.844   535.336     0.150
     0.677    27.047     0.150
     0.677    27.531     0.150
     1.995    67.172     0.150
     2.763    81.242     0.150
     3.006   100.969     0.150
     3.447    66.867     0.150
     4.173   107.969     0.150
     4.321   136.969     0.150
     4.717    61.727     0.150
     6.700   101.867     0.150
     7.830   252.391     0.150
     7.830   253.867     0.150
     9.410   227.562     0.150
    11.384   162.969     0.150
    11.438   164.617     0.150
    11.564   402.969     0.150
    13.282   187.969     0.150
    13.282   187.969     0.150
    13.282   322.969     0.150
    13.434   323.969     0.150
    14.684   365.602     0.150
    18.159   257.969     0.150
    18.159     4.500     0.150
    18.159     7.000     0.150
    20.348     9.000     0.150
    20.348    14.000     0.150
    20.348   301.969     0.150
    20.348   495.969     0.150
    20.544   276.570     0.150
    20.544     7.797     0.150
    23.481     7.898     0.150
    23.481    10.797     0.150
    23.481   562.867     0.150
    23.555   307.867     0.150
    23.765   312.391     0.150
    24.058   315.625     0.150
    34.926   737.266     0.150
    49.096   530.969     0.150
    52.650   555.594     0.150
    53.650   560.992     0.150
    53.650   560.992     0.150
    56.930   583.070     0.150
    57.862   589.469     0.150
    57.871   589.469     0.150
    58.018   590.367     0.150
    58.366   593.172     0.150
    58.375   592.367     0.150
    59.418   600.070     0.150
    59.440   600.266     0.150
    59.575   601.469     0.150
    61.546   614.367     0.150
    62.114   618.266     0.150
    62.950   623.766     0.150
    64.015   630.367     0.150
   120.485  1129.867     0.150
     0.388    13.559     0.150
     1.752    37.066     0.150
     1.752    62.906     0.150
     2.042    39.746     0.150
     2.042    66.746     0.150
     2.451    77.246     0.150
     2.531    39.348     0.150
     2.822    85.770     0.150
     2.943    92.977     0.150
     3.836   128.086     0.150
     3.836   128.438     0.150
    23.673   311.617     0.150
     1.123    17.004     0.150
     1.123    29.804     0.150
     1.883    58.834     0.150
     2.577    46.804     0.150
     2.846    43.144     0.150
     2.884    45.964     0.150
     3.395    52.004     0.150
     3.395    95.004     0.150
     3.510    51.904     0.150
     3.626    63.684     0.150
     3.626   119.204     0.150
     3.626   119.454     0.150
     3.994    58.074     0.150
     3.994   120.354     0.150
     3.994   120.594     0.150
     5.787   143.004     0.150
    14.095   217.504     0.150
    16.265   398.919     0.150
     0.736    12.016     0.150
     0.758    12.336     0.150
     0.758    22.438     0.150
     0.853    30.438     0.150
     1.602    52.898     0.150
     1.602    54.238     0.150
     2.869    88.387     0.150
     3.515   117.828     0.150
     3.515   118.129     0.150
     3.721   127.199     0.150
     3.721   127.566     0.150
     4.123   117.938     0.150
     4.368   131.938     0.150
     4.503   142.938     0.150
     4.556   157.199     0.150
     4.556   158.027     0.150
     5.078    67.938     0.150
     5.078   125.938     0.150
     5.135    92.938     0.150
     8.963   117.816     0.150
     9.378   137.438     0.150
     9.378   237.227     0.150
    10.021   129.039     0.150
    11.227   262.938     0.150
    12.931   191.938     0.150
    12.931     5.000     0.150
    13.127   437.477     0.150
    13.127   438.137     0.150
    13.260   199.398     0.150
    16.537   227.238     0.150
    16.537   404.539     0.150
    16.537   227.227     0.150
    16.537   404.578     0.150
    18.345   258.039     0.150
    18.345     6.098     0.150
    21.408   290.438     0.150
    24.112   314.039     0.150
    24.112   313.957     0.150
    24.409   317.539     0.150
    24.409   317.527     0.150
    24.451   318.738     0.150
    30.284   432.938     0.150
    30.284   666.938     0.150
    30.535   378.938     0.150
    30.535   378.887     0.150
    32.688   396.438     0.150
    39.683   454.238     0.150
    44.697   494.539     0.150
    44.697   494.516     0.150
    46.932   509.738     0.150
    46.932   509.719     0.150
    46.976   510.238     0.150
    46.976   510.219     0.150
    48.241   517.938     0.150
    49.436   530.039     0.150
    49.436   529.836     0.150
    49.831   532.539     0.150
    49.831   532.566     0.150
    49.936   537.137     0.150
    49.936   537.137     0.150
    49.936   537.137     0.150
    50.329   540.219     0.150
    50.966   546.227     0.150
    50.966   546.227     0.150
    51.095   546.336     0.150
    51.095   546.336     0.150
    51.095   546.336     0.150
    51.287   547.938     0.150
    51.287   547.938     0.150
    51.287   547.938     0.150
    52.258   555.938     0.150
    52.258   555.938     0.150
    52.258   555.938     0.150
    52.582   554.039     0.150
    52.582   558.438     0.150
    52.694   553.836     0.150
    52.694   553.816     0.150
    52.896   555.238     0.150
    52.896   555.227     0.150
    52.951   561.238     0.150
    52.951   561.238     0.150
    52.951   561.238     0.150
    53.957   563.238     0.150
    53.957   563.238     0.150
    53.957   563.738     0.150
    53.957   563.688     0.150
    54.073   568.938     0.150
    54.073   568.938     0.150
    54.425   571.738     0.150
    54.425   571.738     0.150
    55.717   577.828     0.150
    55.717   577.828     0.150
    57.564   589.336     0.150
    57.564   589.336     0.150
    57.862   591.836     0.150
    57.862   591.836     0.150
    57.862   591.836     0.150
    58.094   593.238     0.150
    58.094   593.238     0.150
    58.103   593.137     0.150
    58.103   593.137     0.150
    58.246   594.137     0.150
    58.246   594.137     0.150
    58.454   596.438     0.150
    58.454   596.438     0.150
    58.822   597.938     0.150
    58.822   597.938     0.150
    58.852   598.238     0.150
    58.852   598.238     0.150
    59.662   603.836     0.150
    59.662   603.836     0.150
    59.816   604.836     0.150
    59.816   604.836     0.150
    59.944   605.938     0.150
    59.944   605.938     0.150
    60.109   607.137     0.150
    60.109   607.137     0.150
    60.503   609.137     0.150
    60.503   609.137     0.150
    60.834   613.336     0.150
    60.996   612.039     0.150
    60.996   612.039     0.150
    60.996   612.039     0.150
    61.942   618.539     0.150
    61.942   618.539     0.150
    62.128   619.637     0.150
    62.128   619.637     0.150
    63.595   629.938     0.150
    63.845   631.938     0.150
    64.029   633.039     0.150
    67.340   655.699     0.150
    72.046   683.238     0.150
    72.046   683.219     0.150
    74.288   696.188     0.150
    78.351   899.289     0.150
    78.351   719.238     0.150
    78.351   899.238     0.150
    78.351   719.188     0.150
    78.351   899.289     0.150
    78.519   719.418     0.150
    82.606   745.039     0.150
    82.606   745.039     0.150
    82.707   745.438     0.150
    82.707   745.438     0.150
    82.921   746.637     0.150
    82.921   746.637     0.150
    83.094   746.137     0.150
    83.094   746.137     0.150
    84.822   746.438     0.150
    84.822   746.438     0.150
    86.752   761.336     0.150
    86.752   761.379     0.150
   142.694  1173.586     0.150
   148.063  1180.289     0.150
     0.196    14.398     0.150
     0.177     7.898     0.150
     2.180    69.898     0.150
     3.207    99.119     0.150
     3.909    77.998     0.150
     5.964   149.898     0.150
     6.857   223.199     0.150
     6.857   223.529     0.150
     7.577   124.898     0.150
    10.928   156.898     0.150
    11.656   360.598     0.150
    12.225   170.898     0.150
    12.225   297.898     0.150
    12.524   192.398     0.150
    12.524   302.119     0.150
    13.482   417.398     0.150
    17.250   239.068     0.150
    39.325   444.248     0.150
    71.574   678.619     0.150
     1.722    18.994     0.150
     1.722    42.623     0.150
     3.228   106.174     0.150
     3.475   120.975     0.150
     3.475   122.145     0.150
     4.441    67.174     0.150
     4.953   136.174     0.150
     6.553   196.564     0.150
     7.088   231.703     0.150
     7.088   233.273     0.150
     7.488   251.604     0.150
     7.488   252.334     0.150
     8.327   125.793     0.150
     9.074   226.873     0.150
     9.074   132.824     0.150
     9.074   226.854     0.150
    12.174   295.104     0.150
    12.174   391.834     0.150
    12.174   392.613     0.150
    12.399   173.174     0.150
    12.399   299.674     0.150
    12.399   173.174     0.150
    12.399   299.674     0.150
    12.951   322.283     0.150
    15.137   215.574     0.150
    15.137    13.600     0.150
    17.562   546.773     0.150
    24.551   318.953     0.150
    25.053   324.055     0.150
    27.180   344.135     0.150
    27.779   346.783     0.150
    30.674   375.094     0.150
    30.946   373.574     0.150
    30.946   373.523     0.150
    31.091   373.873     0.150
    32.703     9.400     0.150
    33.282   395.373     0.150
    35.381   415.113     0.150
    35.835   420.975     0.150
    40.336   455.574     0.150
    40.336    16.699     0.150
    45.292   499.475     0.150
    45.238   496.324     0.150
    51.059   541.703     0.150
    53.643   560.293     0.150
    54.616   566.975     0.150
    55.048   571.873     0.150
    55.048   571.873     0.150
    58.180   592.773     0.150
    58.479   595.273     0.150
    58.565   595.975     0.150
    58.697   597.574     0.150
    58.707   597.574     0.150
    58.845   597.773     0.150
    58.923   598.574     0.150
    59.189   599.975     0.150
    59.339   601.174     0.150
    59.423   601.773     0.150
    60.273   607.574     0.150
    60.428   608.574     0.150
    60.558   609.574     0.150
    60.722   610.574     0.150
    61.608   616.873     0.150
    62.328   621.773     0.150
    62.566   622.475     0.150
    62.955   624.773     0.150
    63.101   626.174     0.150
    63.745   632.645     0.150
    64.442   635.674     0.150
    64.842   637.674     0.150
    67.720   657.674     0.150
    68.133   663.953     0.150
    71.446   679.234     0.150
    78.455   719.703     0.150
    80.199   730.273     0.150
     0.668    20.410     0.150
     1.073    11.770     0.150
     1.073    26.891     0.150
     1.073    50.590     0.150
     1.062    33.473     0.150
     2.332    74.961     0.150
    25.184   329.562     0.150
     1.173    19.304     0.150
     1.173    34.243     0.150
     5.426    83.344     0.150
     5.426   144.344     0.150
     6.071    91.443     0.150
     6.071   157.743     0.150
     6.628    98.644     0.150
     6.628   171.144     0.150
     6.671    99.243     0.150
     6.671   172.243     0.150
     6.671    99.243     0.150
     6.671   172.243     0.150
     6.879   102.243     0.150
     6.879   176.943     0.150
     6.879   102.243     0.150
     6.879   176.943     0.150
    10.995   158.943     0.150
    12.156   173.743     0.150
    13.412   348.943     0.150
    13.412   187.943     0.150
    13.412   348.943     0.150
    13.753   189.644     0.150
    14.817   212.943     0.150
    14.817   220.943     0.150
    14.817    12.000     0.150
    14.817   378.943     0.150
    14.817   396.943     0.150
    16.149   225.243     0.150
    16.149   395.543     0.150
    19.807   269.743     0.150
    21.734    13.000     0.150
    21.734    19.600     0.150
    21.734   291.844     0.150
    21.734    13.000     0.150
    21.734    19.600     0.150
    22.135   294.644     0.150
    22.135     3.200     0.150
    22.135   294.644     0.150
    22.502   299.543     0.150
    22.898   304.043     0.150
    22.950     9.311     0.150
    22.950   304.743     0.150
    22.950     9.300     0.150
    23.092   306.344     0.150
    23.092   551.943     0.150
    45.685   496.344     0.150
    48.304   518.243     0.150
    51.325   544.644     0.150
    52.571   553.243     0.150
    56.465   582.344     0.150
    56.474   582.344     0.150
    56.610   583.943     0.150
    58.057   593.043     0.150
    58.204   593.943     0.150
    60.630   609.144     0.150
    62.014   619.943     0.150
    65.682   645.906     0.150
    73.682   693.443     0.150
    78.274   718.193     0.150
     0.624    15.994     0.150
     1.743    56.994     0.150
     2.819    55.994     0.150
     3.407    69.094     0.150
     3.407   114.494     0.150
     4.200   108.475     0.150
    11.391   165.994     0.150
    12.650   182.994     0.150
    13.328   191.795     0.150
    15.095   366.635     0.150
    20.670   278.994     0.150
    24.076   313.795     0.150
    24.586   319.594     0.150
    26.228   336.688     0.150
    26.228   334.068     0.150
    49.960   533.814     0.150
     1.072    14.943     0.150
     1.072    29.504     0.150
     2.475    41.523     0.150
     5.052    71.123     0.150
     6.147   159.424     0.150
    10.357   263.924     0.150
    10.357   147.662     0.150
    11.365   276.312     0.150
    12.694   193.123     0.150
    12.733   179.604     0.150
    12.733   310.754     0.150
    12.877   188.424     0.150
    12.877   316.223     0.150
    13.039   334.623     0.150
    13.039   177.623     0.150
    14.375   197.572     0.150
    14.375   347.953     0.150
    14.896   212.123     0.150
    14.896   224.924     0.150
    14.896   377.523     0.150
    16.442   396.781     0.150
    16.442   226.174     0.150
    16.442   396.773     0.150
    16.442   226.402     0.150
    16.442   398.893     0.150
    19.040    10.801     0.150
    19.040    16.801     0.150
    19.040   275.723     0.150
    19.040   581.223     0.150
    19.040   621.223     0.150
    21.089    23.900     0.150
    21.089   509.523     0.150
    21.292     8.500     0.150
    21.292    12.801     0.150
    21.292    24.000     0.150
    21.366   282.123     0.150
    21.459    12.201     0.150
    21.459    18.201     0.150
    21.459    26.400     0.150
    21.459   320.924     0.150
    21.459   570.023     0.150
    23.015   301.223     0.150
    23.015   301.232     0.150
    23.418   306.322     0.150
    23.418   559.023     0.150
    23.753   308.822     0.150
    23.753   563.123     0.150
    23.753   308.803     0.150
    23.753   563.143     0.150
    24.424    11.699     0.150
    24.424    39.500     0.150
    24.424   577.924     0.150
    25.312     6.500     0.150
    25.470   601.443     0.150
    25.470   601.443     0.150
    25.470   325.748     0.150
    29.710   432.023     0.150
    29.710   541.322     0.150
    30.183    12.199     0.150
    31.777   547.723     0.150
    32.799   851.822     0.150
    33.775    12.000     0.150
    33.818   496.023     0.150
    35.892    13.100     0.150
    36.292   418.023     0.150
    38.251   443.023     0.150
    38.674    12.699     0.150
    38.922   450.424     0.150
    42.054   468.043     0.150
    43.346   474.424     0.150
    44.355   487.562     0.150
    44.416   492.223     0.150
    46.341   501.924     0.150
    46.341   501.924     0.150
    47.548   530.523     0.150
    47.949   515.393     0.150
    48.893   522.123     0.150
    49.466   527.354     0.150
    49.833   530.902     0.150
    51.025   539.223     0.150
    51.077   538.822     0.150
    51.483   541.443     0.150
    51.732   544.453     0.150
    52.025   546.322     0.150
    52.025   546.322     0.150
    52.082   547.322     0.150
    52.300   548.223     0.150
    52.300    15.900     0.150
    52.300   548.223     0.150
    52.300     8.900     0.150
    52.300    15.900     0.150
    52.351   547.924     0.150
    53.033   554.793     0.150
    53.222   556.123     0.150
    53.222   556.123     0.150
    53.243   554.822     0.150
    53.243   554.822     0.150
    53.243   554.822     0.150
    53.564   558.123     0.150
    53.564   558.123     0.150
    53.725   559.424     0.150
    53.899   560.023     0.150
    53.899   560.023     0.150
    53.920   561.123     0.150
    54.013   560.273     0.150
    54.308   563.223     0.150
    55.282   569.623     0.150
    55.282   569.623     0.150
    55.627   572.023     0.150
    55.951   573.223     0.150
    56.307   578.023     0.150
    56.688   580.322     0.150
    56.989   582.623     0.150
    57.059   583.223     0.150
    57.197   584.723     0.150
    57.206   584.822     0.150
    57.338   584.703     0.150
    57.342   584.822     0.150
    57.426   586.023     0.150
    57.604   587.424     0.150
    57.684   587.223     0.150
    57.921   589.424     0.150
    58.002   590.123     0.150
    58.771   595.322     0.150
    58.933   596.123     0.150
    59.065   596.924     0.150
    59.228   598.023     0.150
    59.621   600.723     0.150
    60.112   604.723     0.150
    60.552   607.822     0.150
    60.829   609.822     0.150
    60.863   609.723     0.150
    61.073   609.424     0.150
    61.083   610.623     0.150
    61.272   611.723     0.150
    61.609   614.023     0.150
    61.608   614.123     0.150
    62.737   622.023     0.150
    63.174   624.723     0.150
    63.224   624.822     0.150
    65.717   642.463     0.150
    66.035   641.014     0.150
    66.074   644.613     0.150
    66.828   649.162     0.150
    66.949   649.174     0.150
    66.989   649.803     0.150
    67.403   652.223     0.150
    67.686   653.023     0.150
    68.544   659.723     0.150
    68.713   660.232     0.150
    75.010   697.473     0.150
    75.404   700.113     0.150
    78.527   717.242     0.150
    80.257   726.822     0.150
    81.569   735.033     0.150
    81.707   735.723     0.150
    81.707   735.822     0.150
    81.707   735.312     0.150
    86.668   758.963     0.150
    86.668  1833.312     0.150
   147.009  1179.523     0.150
   147.253  1179.723     0.150
   153.511  1194.924     0.150
     3.610   102.766     0.150
     4.539    66.961     0.150
     5.160   137.562     0.150
     6.830    96.961     0.150
     6.830   168.664     0.150
     7.803   110.266     0.150
     8.020   113.562     0.150
     8.752   230.172     0.150
     9.326   135.742     0.150
     9.326   237.414     0.150
    11.186   159.055     0.150
    12.820   180.477     0.150
    12.957   333.664     0.150
    12.957   178.164     0.150
    12.957   178.164     0.150
    13.304   321.047     0.150
    14.662   216.266     0.150
    14.662   387.664     0.150
    15.014   205.562     0.150
    18.291   447.266     0.150
    18.291   471.266     0.150
    20.094   491.664     0.150
    20.416     9.000     0.150
    20.416    14.305     0.150
    23.389    11.602     0.150
    23.389    17.203     0.150
    23.389    30.906     0.150
    23.389   551.664     0.150
    23.389   599.461     0.150
    23.900   570.266     0.150
    23.900   312.914     0.150
    23.900   570.211     0.150
    24.590   357.562     0.150
    24.590   574.164     0.150
    24.590   645.766     0.150
    26.181   332.391     0.150
    26.504   337.562     0.150
    26.504   540.461     0.150
    26.898   343.203     0.150
    27.293   345.562     0.150
    27.293     3.805     0.150
    27.293     6.203     0.150
    27.293   393.766     0.150
    27.293   626.367     0.150
    27.293   628.766     0.150
    27.293   766.562     0.150
    28.921   361.766     0.150
    28.921   653.461     0.150
    30.288   368.461     0.150
    30.288   437.461     0.150
    30.288   371.852     0.150
    30.572   374.273     0.150
    30.611   373.742     0.150
    32.715   388.664     0.150
    32.720   392.422     0.150
    32.815    11.102     0.150
    32.815    14.898     0.150
    32.815   726.664     0.150
    34.924     8.703     0.150
    34.924    12.602     0.150
    34.924   488.664     0.150
    35.146   410.961     0.150
    35.146   410.992     0.150
    36.576   427.961     0.150
    40.716   458.961     0.150
    40.947    11.594     0.150
    40.947    16.195     0.150
    40.947  1012.961     0.150
    42.925   476.961     0.150
    45.358   499.062     0.150
    46.943   508.664     0.150
    47.027   511.266     0.150
    47.028   510.266     0.150
    47.270   520.766     0.150
    47.805   523.164     0.150
    48.568   525.062     0.150
    48.862   524.766     0.150
    48.893   527.062     0.150
    49.833   533.922     0.150
    49.962   529.367     0.150
    50.356   536.594     0.150
    51.628   544.711     0.150
    51.628   546.172     0.150
    52.607   552.633     0.150
    52.607   552.664     0.150
    52.923   555.164     0.150
    53.169   552.664     0.150
    53.169   732.062     0.150
    53.169   552.664     0.150
    53.169   569.164     0.150
    53.353   558.633     0.150
    53.970   561.836     0.150
    54.098   561.164     0.150
    54.098   561.164     0.150
    54.451   567.164     0.150
    54.451   567.164     0.150
    54.515   567.156     0.150
    54.759   568.367     0.150
    54.779   568.398     0.150
    56.160   578.461     0.150
    57.178   586.164     0.150
    57.178   586.164     0.150
    57.205   585.164     0.150
    57.205   585.164     0.150
    57.317   587.461     0.150
    57.399   583.961     0.150
    57.591   587.766     0.150
    57.591   587.766     0.150
    57.643   590.617     0.150
    57.713   590.914     0.150
    57.889   590.961     0.150
    57.889   590.961     0.150
    57.889   590.961     0.150
    58.003   591.062     0.150
    58.003   591.062     0.150
    58.123   592.367     0.150
    58.123   592.367     0.150
    58.133   592.461     0.150
    58.133   592.461     0.150
    58.169   595.062     0.150
    58.269   593.633     0.150
    58.276   593.164     0.150
    58.276   593.164     0.150
    58.341   593.461     0.150
    58.341   593.461     0.150
    58.479   593.562     0.150
    58.479   593.562     0.150
    58.479   593.562     0.150
    58.628   595.766     0.150
    58.628   595.766     0.150
    58.628   595.766     0.150
    58.642   595.461     0.150
    58.852   597.461     0.150
    58.852   597.461     0.150
    58.871   599.961     0.150
    59.689   602.062     0.150
    59.689   602.062     0.150
    59.701   602.867     0.150
    59.844   603.461     0.150
    59.971   604.164     0.150
    60.137   605.266     0.150
    60.531   608.062     0.150
    61.024   611.867     0.150
    61.477   615.164     0.150
    61.749   617.164     0.150
    61.802   617.367     0.150
    61.967   617.562     0.150
    62.154   618.664     0.150
    62.378   621.062     0.150
    62.494   620.961     0.150
    62.513   621.266     0.150
    63.620   628.961     0.150
    63.848   635.688     0.150
    63.875   631.766     0.150
    64.054   631.562     0.150
    66.960   655.016     0.150
    68.373   661.883     0.150
    72.016   681.867     0.150
    74.260   694.961     0.150
    75.215   702.664     0.150
    78.489   719.961     0.150
    78.754   720.164     0.150
    78.754   720.141     0.150
    80.724   731.188     0.150
    80.724   732.203     0.150
    82.971   742.867     0.150
    84.796   749.562     0.150
    84.796   750.039     0.150
    84.796   750.117     0.150
   117.532  1122.164     0.150
   120.552  1129.586     0.150
   148.041  1182.266     0.150
     0.793    12.273     0.150
     0.793    22.273     0.150
     0.885    29.773     0.150
     1.670    22.711     0.150
     1.670    43.086     0.150
     4.624    72.406     0.150
     4.550    67.875     0.150
     5.150    78.773     0.150
     5.150   137.477     0.150
     5.150    78.773     0.150
     5.150   137.477     0.150
     5.336    80.977     0.150
     5.336   140.570     0.150
     5.697    86.070     0.150
     5.697   149.977     0.150
     6.377   159.062     0.150
     9.312   136.484     0.150
     9.312   235.914     0.150
    12.962   191.773     0.150
    12.962   321.773     0.150
    12.962   179.773     0.150
    12.962   191.773     0.150
    12.962   314.773     0.150
    13.178   192.773     0.150
    13.178   199.773     0.150
    13.178   204.656     0.150
    13.178   337.273     0.150
    13.178   338.055     0.150
    13.178   349.273     0.150
    13.178   522.773     0.150
    16.509   227.273     0.150
    16.509   404.375     0.150
    20.394   280.875     0.150
    20.416   275.555     0.150
    22.932   299.406     0.150
    23.846   313.070     0.150
    23.901   312.523     0.150
    24.109   314.547     0.150
    26.186   334.273     0.150
    26.358   338.977     0.150
    26.492   540.227     0.150
    26.492   338.172     0.150
    26.492   540.273     0.150
    26.886   339.383     0.150
    27.279     9.398     0.150
    27.279    13.398     0.150
    27.279   393.570     0.150
    30.597   373.523     0.150
    32.891   389.727     0.150
    32.891   389.953     0.150
    32.800     9.102     0.150
    32.800    14.203     0.150
    32.800   477.273     0.150
    32.800   702.773     0.150
    35.133   410.172     0.150
    35.133   410.203     0.150
    40.934   458.195     0.150
    42.809   474.477     0.150
    42.933   476.984     0.150
    42.933   480.977     0.150
    43.187   479.172     0.150
    43.187   479.211     0.150
    44.193   491.320     0.150
    44.737   496.062     0.150
    44.916   887.172     0.150
    45.280   497.547     0.150
    45.367   500.016     0.150
    46.980   513.305     0.150
    47.011   507.953     0.150
    47.033   515.070     0.150
    47.775   518.742     0.150
    48.838   521.875     0.150
    49.835   531.070     0.150
    49.835   531.070     0.150
    51.642   544.875     0.150
    52.615   555.773     0.150
    52.615   555.773     0.150
    52.714   553.773     0.150
    52.932   556.070     0.150
    53.975   564.375     0.150
    53.975   562.773     0.150
    54.514   566.133     0.150
    55.754   576.742     0.150
    57.600   590.070     0.150
    57.898   591.977     0.150
    58.132   593.172     0.150
    58.286   594.875     0.150
    59.980   606.570     0.150
    72.008   682.125     0.150
    72.015   681.672     0.150
    74.252   695.672     0.150
    78.309   718.477     0.150
    78.483   719.000     0.150
    78.483   718.977     0.150
    78.767   720.320     0.150
    78.767   720.375     0.150
    82.618   742.875     0.150
    82.618   742.281     0.150
    84.788   750.570     0.150
    84.788   750.477     0.150
    84.788   750.086     0.150
     1.003    28.986     0.150
     2.857    82.576     0.150
     3.018    45.945     0.150
     5.744   149.887     0.150
    11.911   292.086     0.150
    12.479   308.285     0.150
    12.530   185.086     0.150
    12.530   190.586     0.150
    12.530   316.086     0.150
    12.530   328.086     0.150
    12.530   175.586     0.150
    12.530   175.586     0.150
    12.530   305.586     0.150
    13.489   191.057     0.150
    15.263   371.049     0.150
    18.700     8.201     0.150
    18.700    12.000     0.150
    20.334   274.775     0.150
    20.765     5.801     0.150
    20.765     9.000     0.150
    20.808   280.336     0.150
    24.232   316.396     0.150
    24.430   318.467     0.150
    24.681   588.887     0.150
    24.741   320.967     0.150
    24.741   320.896     0.150
    26.822   402.586     0.150
    26.949   343.086     0.150
    26.949   542.486     0.150
    27.342   346.025     0.150
    30.567   670.086     0.150
    33.119   400.986     0.150
    36.633    12.400     0.150
    40.960   460.387     0.150
    43.043   479.307     0.150
    45.353   497.285     0.150
    45.360   497.486     0.150
    47.259   512.086     0.150
    47.259   512.086     0.150
    49.731   531.086     0.150
    57.302   588.387     0.150
    57.302   588.387     0.150
    57.684   590.887     0.150
    57.684   590.887     0.150
    57.684   590.887     0.150
    58.195   593.686     0.150
    58.195   593.686     0.150
    58.204   593.686     0.150
    58.204   593.686     0.150
    58.341   595.486     0.150
    59.930   606.285     0.150
    60.061   607.086     0.150
    60.061   607.086     0.150
    60.061   607.086     0.150
    61.110   613.887     0.150
    61.110   613.887     0.150
    62.076   619.686     0.150
    62.076   619.686     0.150
    62.605   624.486     0.150
    78.419   720.217     0.150
    78.927   722.297     0.150
    82.776   749.887     0.150
    87.151   764.387     0.150
     3.361    64.065     0.150
     3.361    96.065     0.150
     3.923    63.266     0.150
     3.995    74.865     0.150
     3.995   109.565     0.150
     3.995   109.466     0.150
     4.551   122.766     0.150
     4.551   122.766     0.150
     4.597   123.266     0.150
     4.597   123.266     0.150
     4.802   129.466     0.150
     4.802   129.365     0.150
     5.021   134.166     0.150
     5.376    79.266     0.150
     5.376   141.766     0.150
     5.376   141.766     0.150
     9.166   132.636     0.150
     9.166   234.605     0.150
    11.986   285.706     0.150
    12.541   184.266     0.150
    12.541   195.766     0.150
    12.541   172.766     0.150
    18.418   258.065     0.150
    18.418     8.800     0.150
    18.418    23.000     0.150
    20.434   279.266     0.150
    20.434   279.266     0.150
    20.434   285.166     0.150
    20.434   288.766     0.150
    24.372   315.256     0.150
    24.581   317.735     0.150
    30.760   428.166     0.150
    32.760     5.200     0.150
    32.760     8.700     0.150
    32.760   474.266     0.150
    32.760   714.266     0.150
    34.859   404.266     0.150
    43.348   479.785     0.150
    47.492   511.865     0.150
    47.492   511.865     0.150
    53.029   554.966     0.150
    54.429   563.766     0.150
    54.429   563.936     0.150
    58.523   594.565     0.150
    58.523   594.565     0.150
    58.532   594.565     0.150
    58.532   594.565     0.150
    60.251   604.865     0.150
    60.251   604.865     0.150
    60.381   605.766     0.150
    60.381   605.766     0.150
    61.431   613.365     0.150
    61.431   613.365     0.150
    62.386   619.666     0.150
    62.386   619.666     0.150
    78.889   719.976     0.150
    87.149   762.506     0.150
   148.336  1183.766     0.150
     0.510    18.449     0.150
     3.203    84.838     0.150
     3.165    53.648     0.150
     3.165    83.148     0.150
    12.573   183.148     0.150
    12.573   315.648     0.150
    12.573   175.148     0.150
    12.573   324.148     0.150
    16.889   418.473     0.150
    54.154   564.168     0.150
    74.185   696.949     0.150
    78.361   718.324     0.150
     1.547    23.574     0.150
     1.547    44.262     0.150
     2.290    41.664     0.150
     2.454    31.148     0.150
     2.454    59.281     0.150
     2.474    34.469     0.150
     2.474    63.820     0.150
     4.278    68.320     0.150
     8.757   137.602     0.150
     8.757   240.078     0.150
    11.209   277.820     0.150
    11.209   159.719     0.150
    11.209   282.422     0.150
    12.581   305.320     0.150
    12.954   315.961     0.150
    12.974   315.844     0.150
    13.140   317.320     0.150
    13.453   499.320     0.150
    13.453   186.320     0.150
    13.453   186.320     0.150
    13.453   329.320     0.150
    14.880   378.219     0.150
    16.148   222.719     0.150
    16.148   397.320     0.150
    19.517     7.305     0.150
    19.517    12.000     0.150
    19.517   489.117     0.150
    19.517   503.320     0.150
    21.867     3.797     0.150
    21.867     7.297     0.150
    21.867    25.500     0.150
    21.867   533.219     0.150
    21.919     9.602     0.150
    21.919    13.398     0.150
    21.919    26.102     0.150
    22.263   294.922     0.150
    22.303   295.320     0.150
    22.350    12.203     0.150
    22.350    16.500     0.150
    22.350    28.500     0.150
    22.350   578.719     0.150
    22.477   292.523     0.150
    22.477   534.367     0.150
    22.477   297.719     0.150
    22.477   534.422     0.150
    22.422   296.922     0.150
    22.816   301.117     0.150
    24.664   320.320     0.150
    25.280     9.602     0.150
    25.280    14.500     0.150
    25.280    39.500     0.150
    26.005     9.000     0.150
    26.005    13.398     0.150
    26.005    39.602     0.150
    26.005   655.922     0.150
    27.203   346.719     0.150
    27.319   344.523     0.150
    27.319   543.219     0.150
    27.925   411.922     0.150
    28.594     9.500     0.150
    28.594    13.500     0.150
    28.645   358.320     0.150
    28.664   648.023     0.150
    28.991   358.680     0.150
    28.991   413.719     0.150
    28.991   645.117     0.150
    30.876   378.219     0.150
    30.848   676.117     0.150
    30.942   674.719     0.150
    33.398   393.477     0.150
    34.495     4.398     0.150
    34.495     7.195     0.150
    39.143   807.617     0.150
    41.081   462.719     0.150
    41.081   580.820     0.150
    41.179   462.922     0.150
    41.154   462.820     0.150
    41.163   462.617     0.150
    41.163    10.703     0.150
    41.163   558.422     0.150
    42.149     3.000     0.150
    42.149   816.422     0.150
    42.149   851.922     0.150
    42.149   857.320     0.150
    43.681   483.820     0.150
    43.831   483.422     0.150
    43.835   481.320     0.150
    45.202   496.617     0.150
    45.434   505.320     0.150
    45.434  1084.320     0.150
    45.543   498.922     0.150
    45.980   500.617     0.150
    45.980   513.922     0.150
    45.980   648.320     0.150
    45.980   918.922     0.150
    45.980  1092.219     0.150
    45.980  1159.719     0.150
    46.632   507.117     0.150
    47.031   510.922     0.150
    47.729   515.422     0.150
    48.164   519.422     0.150
    48.164   931.719     0.150
    48.192   519.820     0.150
    48.574   522.117     0.150
    48.867   523.422     0.150
    49.115   526.312     0.150
    49.480   528.547     0.150
    49.480   528.523     0.150
    50.348   535.930     0.150
    50.766   538.969     0.150
    50.766   539.023     0.150
    51.111   541.820     0.150
    51.111   541.320     0.150
    51.170   604.320     0.150
    51.400   543.320     0.150
    51.400   543.320     0.150
    51.400   737.320     0.150
    51.586   544.828     0.150
    51.628   545.719     0.150
    51.820   558.922     0.150
    51.820   546.719     0.150
    51.820    12.203     0.150
    51.820   992.117     0.150
    52.291   552.414     0.150
    52.291   552.414     0.150
    52.319   551.219     0.150
    52.420   550.344     0.150
    52.420   550.320     0.150
    52.655   553.820     0.150
    52.655  1008.617     0.150
    52.655   553.820     0.150
    52.655  1008.617     0.150
    52.783   553.719     0.150
    52.897   555.117     0.150
    53.003   555.922     0.150
    53.495   559.648     0.150
    54.081   564.023     0.150
    54.081   563.922     0.150
    54.217   566.062     0.150
    55.356   568.953     0.150
    56.075   577.117     0.150
    56.075   577.117     0.150
    56.130   577.922     0.150
    56.130   577.922     0.150
    56.273   579.422     0.150
    56.273   579.422     0.150
    56.282   579.422     0.150
    56.282   579.422     0.150
    56.413   580.422     0.150
    56.413    10.602     0.150
    56.507   579.617     0.150
    56.507   579.617     0.150
    56.507   579.617     0.150
    56.754   582.023     0.150
    56.754   582.023     0.150
    56.837   583.117     0.150
    57.098   585.219     0.150
    57.098   585.219     0.150
    57.417   585.922     0.150
    58.015   590.922     0.150
    58.015   590.922     0.150
    58.310   593.023     0.150
    58.310   593.023     0.150
    59.194   599.719     0.150
    59.194   599.719     0.150
    59.629   602.719     0.150
    59.629   602.719     0.150
    59.907   605.320     0.150
    59.907   605.320     0.150
    59.935   603.320     0.150
    59.935   603.320     0.150
    59.935   603.320     0.150
    60.176   605.617     0.150
    60.176   605.617     0.150
    60.366   607.117     0.150
    60.533   608.820     0.150
    60.533   608.820     0.150
    61.830   617.219     0.150
    61.830   617.219     0.150
    62.010   619.320     0.150
    62.010   619.320     0.150
    62.268   620.117     0.150
    62.268   620.117     0.150
    62.316   620.320     0.150
    62.316   620.320     0.150
    64.782   638.422     0.150
    65.138   639.523     0.150
    65.150   640.617     0.150
    65.282   641.523     0.150
    65.893   644.523     0.150
    66.215   646.117     0.150
    66.468   647.320     0.150
    67.732   660.219     0.150
    72.159   686.922     0.150
    73.874   693.719     0.150
    76.083   706.219     0.150
    76.670   713.742     0.150
    77.816   715.820     0.150
    78.572   719.820     0.150
    80.160   728.922     0.150
    80.715   733.023     0.150
    81.085   732.219     0.150
    81.085   732.422     0.150
    81.085   732.219     0.150
    82.645   742.320     0.150
    86.334   759.922     0.150
    89.463   775.898     0.150
    92.651   791.719     0.150
   120.046  1130.523     0.150
   140.940  1169.719     0.150
     0.835    17.359     0.150
     0.835    29.223     0.150
     1.821    59.430     0.150
     2.844    50.660     0.150
     5.897    86.938     0.150
     5.897    86.930     0.150
    10.402   150.828     0.150
    12.624   179.930     0.150
    16.388   230.078     0.150
    16.388   405.676     0.150
    20.139   272.953     0.150
    23.349   307.715     0.150
    23.727   310.328     0.150
    49.209   527.379     0.150
     0.505     6.930     0.150
     0.505    12.629     0.150
     2.670    77.449     0.150
     2.986    46.230     0.150
    10.035   246.730     0.150
    10.299   151.059     0.150
    10.299   258.109     0.150
    12.608   321.730     0.150
    16.850   235.707     0.150
    38.868   447.879     0.150
    45.197   492.930     0.150
    49.974   533.906     0.150
    72.136   683.254     0.150
    74.355   695.574     0.150
     0.658    22.926     0.150
     2.716    79.168     0.150
     4.225    66.086     0.150
    10.010   242.418     0.150
    12.667   176.117     0.150
    12.667   312.617     0.150
    16.792   417.695     0.150
    16.792   233.727     0.150
    16.792   417.703     0.150
    18.684   265.016     0.150
    24.114   315.344     0.150
    40.084   454.062     0.150
    46.996   509.742     0.150
    57.822   590.016     0.150
    57.822   590.016     0.150
    58.580   595.516     0.150
    74.331   698.816     0.150
     0.687    10.629     0.150
     0.744    10.559     0.150
     0.744    20.168     0.150
     2.871    88.027     0.150
     2.871    93.098     0.150
     3.953    55.176     0.150
     3.953   101.176     0.150
     5.262    85.027     0.150
     6.911   100.727     0.150
     7.998   113.926     0.150
     9.397   136.848     0.150
     9.397   238.309     0.150
     9.929   138.629     0.150
    10.466   265.797     0.150
    10.488   162.887     0.150
    12.860   186.527     0.150
    12.860   328.527     0.150
    13.023   182.188     0.150
    13.220   186.926     0.150
    13.220   186.879     0.150
    14.769   219.527     0.150
    15.055   207.527     0.150
    15.055   207.559     0.150
    16.607   228.527     0.150
    16.607   409.027     0.150
    18.400   251.828     0.150
    18.400     2.297     0.150
    18.400   476.828     0.150
    19.923   271.129     0.150
    19.923   483.129     0.150
    20.178     4.398     0.150
    20.178     7.801     0.150
    20.178   492.828     0.150
    20.178   520.629     0.150
    20.361   275.637     0.150
    20.388   274.027     0.150
    20.502   274.926     0.150
    20.474     4.402     0.150
    20.474    23.102     0.150
    20.509   280.828     0.150
    20.509     4.598     0.150
    20.509   508.027     0.150
    21.141   291.477     0.150
    21.553   296.297     0.150
    22.220   300.949     0.150
    22.842   303.855     0.150
    23.457   307.426     0.150
    23.457    34.301     0.150
    23.457   553.527     0.150
    23.911   312.527     0.150
    23.922   312.527     0.150
    23.922   312.547     0.150
    24.468   317.027     0.150
    24.683   327.328     0.150
    26.214   333.301     0.150
    26.214   333.328     0.150
    26.617   338.527     0.150
    26.617   542.828     0.150
    27.011   344.297     0.150
    27.400     4.301     0.150
    27.400     7.102     0.150
    27.400   632.328     0.150
    27.515   350.629     0.150
    27.515   623.027     0.150
    29.283   361.527     0.150
    30.338   675.328     0.150
    30.550   375.926     0.150
    30.716   374.848     0.150
    30.800   377.895     0.150
    32.213   389.719     0.150
    32.905   397.328     0.150
    32.905     4.301     0.150
    32.905     6.898     0.150
    35.012   749.227     0.150
    35.258   415.078     0.150
    35.315   415.828     0.150
    36.568     9.699     0.150
    36.942   429.527     0.150
    38.023   435.828     0.150
    39.392   541.227     0.150
    39.806   451.527     0.150
    39.806   451.527     0.150
    39.806   579.129     0.150
    39.806   807.129     0.150
    41.056     3.098     0.150
    41.056     4.500     0.150
    41.056   462.906     0.150
    42.014   474.738     0.150
    42.689   476.926     0.150
    42.789   857.527     0.150
    42.789   476.527     0.150
    42.789   857.527     0.150
    42.932   477.828     0.150
    42.934   474.328     0.150
    42.941   479.168     0.150
    42.954   480.129     0.150
    42.954   480.129     0.150
    43.169   481.629     0.150
    44.177   490.227     0.150
    44.231   490.926     0.150
    44.420   490.527     0.150
    44.720   494.727     0.150
    45.040   497.227     0.150
    45.040  1138.727     0.150
    45.156   495.328     0.150
    45.269   498.926     0.150
    45.350   499.426     0.150
    46.170   506.027     0.150
    46.787   510.227     0.150
    46.787   510.227     0.150
    46.951   512.527     0.150
    46.979   509.227     0.150
    46.979   509.227     0.150
    47.006   511.738     0.150
    47.065   511.129     0.150
    47.065   511.129     0.150
    47.253   522.027     0.150
    47.253   942.527     0.150
    47.271   514.727     0.150
    47.271   514.727     0.150
    47.758   518.629     0.150
    47.806   520.328     0.150
    47.806   520.328     0.150
    47.955   519.328     0.150
    47.955   519.328     0.150
    48.116   518.629     0.150
    48.149   518.148     0.150
    48.454   523.828     0.150
    48.454   523.828     0.150
    48.861   526.156     0.150
    48.861   527.727     0.150
    48.861   526.129     0.150
    49.492   530.148     0.150
    49.551   531.527     0.150
    49.551   531.527     0.150
    49.836   533.527     0.150
    49.887   532.477     0.150
    49.887   532.527     0.150
    49.887   532.477     0.150
    49.887   532.766     0.150
    49.966   534.129     0.150
    50.359   537.168     0.150
    50.720   541.129     0.150
    50.720   541.129     0.150
    50.720   541.129     0.150
    50.996   543.328     0.150
    51.126   543.629     0.150
    51.318   546.129     0.150
    51.318   546.129     0.150
    51.522   546.238     0.150
    51.720   547.828     0.150
    52.191   551.477     0.150
    52.223   551.707     0.150
    52.237   552.926     0.150
    52.288   553.828     0.150
    52.288   553.828     0.150
    52.594   552.766     0.150
    52.614  2377.988     0.150
    52.980   557.066     0.150
    52.980   558.129     0.150
    53.002   558.027     0.150
    53.002   558.027     0.150
    53.103   566.926     0.150
    53.103   557.527     0.150
    53.103     2.102     0.150
    53.103   566.926     0.150
    53.177   565.527     0.150
    53.177   558.527     0.150
    53.177   565.527     0.150
    53.177   558.527     0.150
    53.177     7.000     0.150
    53.350   561.332     0.150
    53.613   562.926     0.150
    54.002   563.129     0.150
    54.011   565.586     0.150
    54.105   564.027     0.150
    54.105   564.027     0.150
    54.455   567.926     0.150
    54.455   567.926     0.150
    54.777   570.000     0.150
    57.221   588.828     0.150
    57.319   588.828     0.150
    57.592   589.129     0.150
    57.592   589.129     0.150
    57.651   591.789     0.150
    57.891   591.227     0.150
    57.891   591.227     0.150
    57.994   592.629     0.150
    57.994   592.629     0.150
    58.119   593.727     0.150
    58.119   593.727     0.150
    58.128   593.828     0.150
    58.128   593.828     0.150
    58.270   593.926     0.150
    58.270   593.926     0.150
    58.340   594.828     0.150
    58.340   594.828     0.150
    58.486   595.828     0.150
    58.486   595.828     0.150
    58.619   596.426     0.150
    58.619   596.426     0.150
    58.847   598.426     0.150
    58.847   598.426     0.150
    58.884   598.527     0.150
    58.884   598.527     0.150
    59.082   598.527     0.150
    59.277   601.828     0.150
    59.663   597.527     0.150
    59.663  1083.328     0.150
    59.686   604.129     0.150
    59.690   603.328     0.150
    59.690   603.328     0.150
    59.696   604.129     0.150
    59.696   604.129     0.150
    59.843   604.727     0.150
    59.843   604.727     0.150
    59.972   605.527     0.150
    59.972   605.527     0.150
    60.137   606.629     0.150
    60.137   606.629     0.150
    60.904   613.727     0.150
    60.904   743.527     0.150
    61.024   613.227     0.150
    61.024   613.227     0.150
    61.473   616.527     0.150
    61.473   616.527     0.150
    61.795   618.527     0.150
    61.795   618.527     0.150
    61.972   619.828     0.150
    61.972   619.828     0.150
    62.160   620.828     0.150
    62.375   622.426     0.150
    62.375   622.426     0.150
    62.514   622.527     0.150
    62.514   622.527     0.150
    63.626   630.227     0.150
    63.626   630.227     0.150
    63.869   632.629     0.150
    63.869   632.629     0.150
    65.846   647.426     0.150
    65.846   646.277     0.150
    66.283   648.738     0.150
    67.685   657.258     0.150
    68.989   668.129     0.150
    72.021   682.828     0.150
    74.260   696.527     0.150
    75.956   706.047     0.150
    78.075   717.797     0.150
    78.422   719.828     0.150
    78.422   895.828     0.150
    78.590   720.926     0.150
    80.156   729.797     0.150
    80.214   730.449     0.150
     2.871   730.328     0.150
     2.871   730.289     0.150
    80.743   733.328     0.150
    80.743   733.297     0.150
    80.743   733.949     0.150
    81.752   738.355     0.150
    82.537   742.328     0.150
    82.904   746.328     0.150
    82.904   746.328     0.150
    83.224   746.129     0.150
    87.284   765.926     0.150
    87.437   768.527     0.150
   120.644  1132.527     0.150
   142.668  1170.477     0.150
   142.668  1170.527     0.150
   148.001  1187.027     0.150
   154.187  1199.426     0.150
     0.886    19.191     0.150
     0.886    31.809     0.150
     1.575    32.480     0.150
     1.575    55.281     0.150
     2.549    39.379     0.150
     2.549    83.379     0.150
     3.571    53.070     0.150
    45.351   497.789     0.150
     0.391     1.641     0.150
     0.456    17.531     0.150
     0.456    25.945     0.150
     3.161    53.594     0.150
     3.161    91.914     0.150
     3.472    58.445     0.150
     3.865   125.344     0.150
     4.340   123.031     0.150
     4.735   135.844     0.150
     4.857    84.844     0.150
     4.857   154.242     0.150
     7.700   188.555     0.150
     8.361   269.781     0.150
    10.936   156.867     0.150
    54.410   568.383     0.150
    73.891   696.234     0.150
     0.552     2.201     0.150
     1.585    51.713     0.150
     2.571    43.492     0.150
     2.571    75.393     0.150
     2.893    85.002     0.150
     6.454    99.502     0.150
     9.606   236.393     0.150
     9.819   142.223     0.150
    10.012   243.402     0.150
    10.204   261.303     0.150
    12.583   320.002     0.150
    13.324   327.422     0.150
    13.324   335.781     0.150
    13.324   187.846     0.150
    13.324   327.422     0.150
    15.139     4.199     0.150
    15.139     6.500     0.150
    15.139   383.402     0.150
    16.874   413.777     0.150
    18.877     7.699     0.150
    20.627   302.002     0.150
    20.712   278.752     0.150
    20.829   280.902     0.150
    20.986     8.500     0.150
    20.986    11.898     0.150
    24.028   314.414     0.150
    24.201   315.102     0.150
    26.178   334.076     0.150
    27.068   342.562     0.150
    27.879   351.803     0.150
    27.879     7.898     0.150
    27.879    11.500     0.150
    32.303   388.652     0.150
    38.771   444.660     0.150
    42.785   476.576     0.150
    42.958   476.701     0.150
    44.512   492.721     0.150
    46.949   510.102     0.150
    47.044   509.402     0.150
    47.788   513.303     0.150
    49.942   533.277     0.150
    49.942   612.398     0.150
    51.043   542.902     0.150
    52.755   554.787     0.150
    53.956   562.428     0.150
    55.481   572.963     0.150
    55.556   574.209     0.150
    57.038   585.402     0.150
    57.719   589.701     0.150
    57.784   590.402     0.150
    57.924   592.002     0.150
    57.934   592.002     0.150
    58.069   591.902     0.150
    58.156   593.102     0.150
    58.345   594.002     0.150
    58.335   593.902     0.150
    58.408   594.402     0.150
    58.479   595.102     0.150
    59.498   602.303     0.150
    59.537   602.287     0.150
    59.663   603.201     0.150
    59.795   603.502     0.150
    59.958   605.002     0.150
    60.842   611.602     0.150
    61.280   614.201     0.150
    61.558   616.102     0.150
    61.558   616.102     0.150
    61.814   617.602     0.150
    62.003   619.602     0.150
    62.003   619.602     0.150
    62.339   621.002     0.150
    62.340   620.902     0.150
    62.994   626.002     0.150
    63.469   628.803     0.150
    63.664   630.803     0.150
    63.905   631.502     0.150
    63.955   631.502     0.150
    67.103   652.195     0.150
    67.138   652.902     0.150
    72.221   683.451     0.150
    73.387   691.027     0.150
    74.436   696.352     0.150
    75.558   704.062     0.150
    76.340   707.646     0.150
    78.177   717.928     0.150
    78.775   720.652     0.150
    78.903   721.977     0.150
    80.997   734.252     0.150
    82.130   740.602     0.150
    82.140   739.602     0.150
    88.427   771.402     0.150
     0.395    -2.949     0.150
     0.395     6.150     0.150
     3.074    51.621     0.150
     3.074    86.641     0.150
     4.724   142.150     0.150
     9.314   130.301     0.150
    12.543   304.150     0.150
    12.543   319.150     0.150
    12.543   172.650     0.150
    12.543   319.150     0.150
    15.388   379.641     0.150
    16.931   234.283     0.150
    20.336   270.900     0.150
    20.336   270.900     0.150
    24.243   315.350     0.150
    24.254   314.863     0.150
    26.539   336.625     0.150
    26.811   339.551     0.150
    43.223   479.150     0.150
    47.306   511.900     0.150
    50.227   534.725     0.150
    58.389   594.150     0.150
    58.399   594.250     0.150
    60.250   605.951     0.150
    61.300   613.551     0.150
    67.617   654.844     0.150
    71.753   678.051     0.150
    71.753   678.051     0.150
    73.980   692.900     0.150
    73.902   692.051     0.150
    78.709   720.201     0.150
    82.643   743.051     0.150
    87.142   763.246     0.150
     0.503     4.465     0.150
     0.606    29.562     0.150
     3.036    80.766     0.150
     3.428   111.164     0.150
     3.643    58.266     0.150
     3.836    60.465     0.150
     3.836   104.965     0.150
     4.489    69.266     0.150
     5.042    76.465     0.150
     5.042   133.164     0.150
     5.091    77.164     0.150
     5.091   134.766     0.150
     5.091    77.164     0.150
     5.091   134.766     0.150
     5.295    79.562     0.150
     5.295   139.164     0.150
     5.518    82.863     0.150
     5.872    88.266     0.150
     5.872   153.766     0.150
     6.522    95.965     0.150
     6.522   168.766     0.150
     7.184   105.266     0.150
     7.184   183.965     0.150
     7.230   106.266     0.150
     7.230   185.062     0.150
    12.638   306.164     0.150
    12.638   174.164     0.150
    12.638   306.164     0.150
    13.348   188.926     0.150
    13.573   193.004     0.150
    13.763   329.766     0.150
    15.037     7.000     0.150
    15.037    11.199     0.150
    15.116   209.836     0.150
    18.705     6.297     0.150
    18.705     9.699     0.150
    20.685   277.586     0.150
    20.685   508.125     0.150
    20.801   284.266     0.150
    20.801     4.801     0.150
    22.652   299.734     0.150
    22.652   547.234     0.150
    24.040   314.125     0.150
    24.144   315.141     0.150
    24.894   574.863     0.150
    26.249   334.988     0.150
    27.329   356.164     0.150
    30.421   676.664     0.150
    32.546   393.465     0.150
    32.546   393.488     0.150
    32.434   390.164     0.150
    38.920   445.562     0.150
    39.731   575.863     0.150
    40.100   454.715     0.150
    40.100   454.715     0.150
    40.812   459.164     0.150
    42.896   477.613     0.150
    43.089   478.766     0.150
    43.089   478.766     0.150
    44.103   489.965     0.150
    44.157   489.465     0.150
    44.643   493.965     0.150
    45.208   497.164     0.150
    45.212   497.562     0.150
    45.246   882.863     0.150
    45.246   905.266     0.150
    45.272   497.465     0.150
    47.019   510.539     0.150
    47.110   511.664     0.150
    47.682   517.266     0.150
    47.754   519.164     0.150
    47.905   518.363     0.150
    48.410   521.477     0.150
    49.587   530.562     0.150
    49.979   533.812     0.150
    50.797   543.266     0.150
    50.797   549.164     0.150
    50.797   543.266     0.150
    51.083   542.562     0.150
    51.222   543.891     0.150
    52.874   555.516     0.150
    52.930   557.465     0.150
    52.930   557.465     0.150
    53.141   561.164     0.150
    53.141   561.164     0.150
    54.031   563.188     0.150
    55.489   574.215     0.150
    55.602   571.625     0.150
    57.078   585.965     0.150
    57.078   585.965     0.150
    57.538   588.465     0.150
    57.538   588.465     0.150
    57.838   590.766     0.150
    57.838   590.766     0.150
    57.916   591.062     0.150
    57.916   591.062     0.150
    58.051   592.965     0.150
    58.051   592.965     0.150
    58.060   592.863     0.150
    58.060   592.863     0.150
    58.147   593.266     0.150
    58.197   593.766     0.150
    58.197   593.766     0.150
    58.447   595.363     0.150
    58.447   595.363     0.150
    58.497   597.789     0.150
    59.385   600.414     0.150
    59.784   604.164     0.150
    59.784   604.164     0.150
    59.915   604.664     0.150
    59.915   604.664     0.150
    60.964   612.562     0.150
    60.964   612.562     0.150
    61.181   754.766     0.150
    62.976   625.266     0.150
    63.793   629.766     0.150
    63.793   629.766     0.150
    63.793   629.766     0.150
    69.504   668.266     0.150
    72.093   682.988     0.150
    72.094   682.895     0.150
    74.315   696.164     0.150
    75.395   702.176     0.150
    78.337   719.266     0.150
    78.682   720.363     0.150
    78.682   896.832     0.150
    80.852   733.664     0.150
    82.314   741.891     0.150
    82.679   740.465     0.150
    82.679   740.465     0.150
    83.291   744.641     0.150
    84.840   753.039     0.150
    87.044   763.461     0.150
   147.839  1186.914     0.150
     1.080    16.992     0.150
     1.649    53.562     0.150
     1.881    36.961     0.150
     1.881    61.664     0.150
     2.715    70.871     0.150
     8.900   222.672     0.150
    12.657   319.605     0.150
    12.657   315.133     0.150
    12.750   320.621     0.150
    12.750   182.543     0.150
    12.862   330.562     0.150
    12.862   178.562     0.150
    13.748   192.023     0.150
    14.193   352.750     0.150
    16.717   406.012     0.150
    23.405   309.527     0.150
    23.456   310.867     0.150
    24.060   314.773     0.150
    56.678   582.062     0.150
    56.688   582.562     0.150
    57.142   584.164     0.150
    57.397   586.961     0.150
    58.434   593.461     0.150
     0.811    30.279     0.150
     1.251    43.279     0.150
     1.603    31.479     0.150
     1.603    53.760     0.150
     1.679    54.020     0.150
     1.876    35.600     0.150
     1.876    58.779     0.150
     2.631    75.180     0.150
     2.924    51.779     0.150
     2.924    82.279     0.150
     5.504   102.279     0.150
     8.120   117.289     0.150
     8.120   206.430     0.150
     8.418   205.779     0.150
     8.990   143.789     0.150
     8.990   247.770     0.150
    10.267   250.080     0.150
    11.706   285.799     0.150
    11.706   285.799     0.150
    11.706   295.209     0.150
    11.815   170.080     0.150
    11.815   170.068     0.150
    11.873   169.639     0.150
    11.873   297.219     0.150
    13.220   184.279     0.150
    13.757   334.439     0.150
    13.759   346.279     0.150
    13.759   190.279     0.150
    13.759   346.279     0.150
    13.759   190.279     0.150
    13.759   346.279     0.150
    13.848   334.818     0.150
    14.662   355.568     0.150
    14.783   218.779     0.150
    14.783   223.080     0.150
    14.783     6.801     0.150
    15.921   386.176     0.150
    15.921   221.148     0.150
    15.921   386.180     0.150
    15.921   393.689     0.150
    16.210   390.930     0.150
    17.482   423.449     0.150
    19.483   265.549     0.150
    19.483   477.840     0.150
    19.657     9.000     0.150
    19.657    13.500     0.150
    19.657   515.580     0.150
    22.139    11.000     0.150
    22.139    17.199     0.150
    22.174    11.301     0.150
    22.174    16.801     0.150
    22.174    27.500     0.150
    22.174   531.580     0.150
    23.917   306.779     0.150
    24.234   315.279     0.150
    25.637    12.500     0.150
    25.637    41.000     0.150
    25.637   610.779     0.150
    28.748    13.801     0.150
    28.748    17.500     0.150
    28.748   658.779     0.150
    36.694   425.580     0.150
    37.357   426.270     0.150
    37.627   433.020     0.150
    40.712   458.279     0.150
    41.380   463.680     0.150
    41.380   463.680     0.150
    41.872   469.779     0.150
    41.926   470.180     0.150
    42.411   474.279     0.150
    42.986   477.779     0.150
    43.040   478.479     0.150
    43.996   484.939     0.150
    44.454   489.779     0.150
    44.460   489.539     0.150
    44.983   510.479     0.150
    45.007   493.879     0.150
    47.714   515.479     0.150
    47.793   515.830     0.150
    48.882   524.389     0.150
    49.076   525.979     0.150
    50.039   533.080     0.150
    50.379   535.479     0.150
    50.720   537.979     0.150
    50.950     6.000     0.150
    50.950   539.279     0.150
    50.950   545.279     0.150
    55.322   571.080     0.150
    55.322   571.080     0.150
    55.624   573.279     0.150
    55.624   573.279     0.150
    55.683   573.979     0.150
    55.683   573.979     0.150
    55.823   575.479     0.150
    55.823   575.479     0.150
    55.833   575.580     0.150
    55.833   575.580     0.150
    55.967   575.779     0.150
    55.967   575.779     0.150
    56.057   576.680     0.150
    56.057   576.680     0.150
    57.397   586.180     0.150
    57.397   586.180     0.150
    57.564   586.979     0.150
    57.564   586.979     0.150
    57.860   588.879     0.150
    57.860   588.879     0.150
    58.149   591.680     0.150
    58.744   595.680     0.150
    58.744   595.680     0.150
    59.179   598.879     0.150
    59.179   598.879     0.150
    59.487   600.879     0.150
    59.487   600.879     0.150
    59.725   602.379     0.150
    59.725   602.379     0.150
    59.915   604.080     0.150
    59.915   604.080     0.150
    60.927   611.209     0.150
    60.892   609.479     0.150
    60.892   609.479     0.150
    61.562   614.479     0.150
    61.562   614.479     0.150
    61.817   617.180     0.150
    61.817   617.180     0.150
    61.817   617.180     0.150
    61.865   616.979     0.150
    61.865   616.979     0.150
    61.963   617.879     0.150
    61.963   617.879     0.150
    68.468   660.479     0.150
    74.323   695.680     0.150
    74.325   696.039     0.150
    75.000   700.250     0.150
    77.651   714.459     0.150
    78.683   719.580     0.150
    79.974   726.699     0.150
    80.007   726.430     0.150
    80.356   729.309     0.150
    81.762   737.629     0.150
    83.085   744.289     0.150
    87.049   762.979     0.150
   102.125  1082.350     0.150
   102.365  1079.840     0.150
   145.669  1177.279     0.150
     0.356     0.625     0.150
     0.356     5.727     0.150
     0.434    10.227     0.150
     2.107    36.328     0.150
     3.087    87.867     0.150
     3.475    54.430     0.150
     3.475    97.430     0.150
     3.790   126.625     0.150
     4.126    63.227     0.150
     4.126   111.930     0.150
     4.679    70.125     0.150
     4.729    71.328     0.150
     4.729   126.727     0.150
     4.729    71.328     0.150
     4.729   126.727     0.150
     4.932    73.930     0.150
     4.932   130.930     0.150
     4.932    73.930     0.150
     4.932   130.930     0.150
     9.321   135.102     0.150
     9.321   238.047     0.150
    10.309   247.625     0.150
    10.309   151.125     0.150
    10.309   155.930     0.150
    10.309   264.727     0.150
    10.713   152.086     0.150
    10.713   264.547     0.150
    10.998   269.688     0.150
    10.998   280.469     0.150
    11.043   271.938     0.150
    11.043   279.898     0.150
    11.774   287.758     0.150
    11.774   298.586     0.150
    12.243   299.281     0.150
    12.243   310.945     0.150
    12.499   303.602     0.150
    12.499   318.102     0.150
    12.501   171.828     0.150
    12.501   316.828     0.150
    12.501   171.828     0.150
    12.501   171.828     0.150
    12.501   303.328     0.150
    12.597   319.328     0.150
    13.281   335.875     0.150
    13.602   191.531     0.150
    13.618   204.875     0.150
    13.618   352.750     0.150
    13.618   343.227     0.150
    13.618   192.695     0.150
    13.618   343.000     0.150
    13.618   343.188     0.150
    13.618   352.750     0.150
    13.765   210.828     0.150
    13.765   347.758     0.150
    13.852   350.031     0.150
    13.852   195.641     0.150
    13.852   350.008     0.150
    13.953   338.797     0.150
    13.953   353.141     0.150
    14.396   363.609     0.150
    15.123   380.320     0.150
    15.423   213.617     0.150
    16.051   388.531     0.150
    16.051   403.766     0.150
    16.973   235.320     0.150
    16.973   232.906     0.150
    16.973   417.969     0.150
    18.553     6.398     0.150
    20.108   272.430     0.150
    20.108   272.406     0.150
    20.153     8.102     0.150
    20.153    12.203     0.150
    20.320   529.477     0.150
    20.339     8.602     0.150
    20.339    13.000     0.150
    20.339   298.125     0.150
    20.339   503.227     0.150
    20.582     8.195     0.150
    20.582    12.695     0.150
    20.582   499.828     0.150
    20.582   528.828     0.150
    20.881   279.930     0.150
    20.881   508.727     0.150
    20.881   529.320     0.150
    22.467   298.828     0.150
    22.467   545.828     0.150
    22.467   298.852     0.150
    22.467   545.797     0.150
    23.361     8.500     0.150
    23.361    31.203     0.150
    23.361   553.430     0.150
    24.499     8.805     0.150
    25.050   591.930     0.150
    28.789    12.203     0.150
    28.789   356.617     0.150
    30.713   373.875     0.150
    30.825   376.227     0.150
    31.066   377.031     0.150
    31.930   387.125     0.150
    32.168   390.328     0.150
    38.889   449.227     0.150
    39.883   451.961     0.150
    39.883   451.930     0.150
    39.883   578.328     0.150
    39.933   454.398     0.150
    39.947   448.961     0.150
    42.815   477.227     0.150
    42.972   478.930     0.150
    43.121   474.828     0.150
    43.083   478.828     0.150
    43.248   479.461     0.150
    45.219   637.531     0.150
    45.219  1141.125     0.150
    45.241   495.289     0.150
    45.431   493.828     0.150
    47.338   512.461     0.150
    47.338   512.531     0.150
    47.556   522.430     0.150
    47.556   528.625     0.150
    47.576   512.828     0.150
    48.071   518.250     0.150
    48.192   517.328     0.150
    48.261   519.531     0.150
    48.756   522.531     0.150
    49.159   526.711     0.150
    49.209   527.125     0.150
    49.869   532.586     0.150
    50.275   535.727     0.150
    50.275   546.625     0.150
    50.668   538.719     0.150
    51.178   541.531     0.150
    51.151   541.625     0.150
    51.151   553.031     0.150
    51.438   544.828     0.150
    51.438   553.625     0.150
    51.438   557.828     0.150
    51.630   546.031     0.150
    52.026   548.531     0.150
    52.550   553.227     0.150
    52.598   552.930     0.150
    52.598   562.328     0.150
    52.663   553.430     0.150
    52.874   547.930     0.150
    52.874   735.625     0.150
    52.874  1326.031     0.150
    52.928   555.125     0.150
    53.230   557.148     0.150
    53.230   625.531     0.150
    53.287   558.031     0.150
    53.287   568.727     0.150
    53.494   559.031     0.150
    53.494   677.828     0.150
    53.494   559.031     0.150
    53.494   567.828     0.150
    53.494   559.117     0.150
    54.357   564.430     0.150
    54.766   569.531     0.150
    55.141   573.727     0.150
    55.141   573.719     0.150
    57.967   591.195     0.150
    57.997   592.328     0.150
    58.030   592.727     0.150
    58.030   592.727     0.150
    58.554   594.672     0.150
    63.230   625.828     0.150
    67.435   654.539     0.150
    67.960   658.047     0.150
    69.275   666.328     0.150
    69.731   670.430     0.150
    69.765   668.531     0.150
    70.051   670.430     0.150
    70.420   673.531     0.150
    70.841   676.125     0.150
    70.985   677.125     0.150
    71.409   679.531     0.150
    73.988   693.195     0.150
    75.037   701.695     0.150
    75.776   704.641     0.150
    78.231   716.734     0.150
    78.938   721.938     0.150
    78.942   722.555     0.150
    79.209   723.352     0.150
    80.474   730.422     0.150
    80.488   731.398     0.150
    80.540   730.719     0.150
    80.860   732.750     0.150
    82.055   739.336     0.150
    82.640   743.227     0.150
    82.794   744.227     0.150
    84.484   749.727     0.150
    84.484   749.680     0.150
    87.184   763.227     0.150
    91.602   786.148     0.150
    95.742   804.969     0.150
   107.154  1105.883     0.150
   121.012  1132.180     0.150
     0.339     1.908     0.150
     0.339     6.709     0.150
     0.420    10.009     0.150
     0.420    18.009     0.150
     1.018    14.309     0.150
     1.018    27.299     0.150
     3.776   124.408     0.150
     4.743   128.309     0.150
     4.933   132.709     0.150
     8.242   213.809     0.150
     9.340   231.009     0.150
     9.340   136.749     0.150
    10.310   151.608     0.150
    10.310   155.509     0.150
    10.310   265.509     0.150
    10.310   272.908     0.150
    10.988   270.289     0.150
    10.988   280.448     0.150
    11.032   271.969     0.150
    11.032   280.339     0.150
    11.772   289.839     0.150
    11.772   300.238     0.150
    12.230   299.238     0.150
    12.230   310.919     0.150
    12.488   304.778     0.150
    12.488   316.528     0.150
    12.490   304.809     0.150
    12.591   305.839     0.150
    12.591   320.209     0.150
    12.907   189.828     0.150
    13.271   324.849     0.150
    13.271   336.438     0.150
    13.605   192.639     0.150
    13.755   334.749     0.150
    13.755   348.309     0.150
    13.853   193.209     0.150
    13.853   193.188     0.150
    13.944   352.969     0.150
    14.386   348.009     0.150
    14.386   364.129     0.150
    15.111   367.519     0.150
    15.111   381.238     0.150
    15.104     3.900     0.150
    15.104     7.700     0.150
    15.104   231.809     0.150
    15.104   387.908     0.150
    15.421   214.639     0.150
    16.043   389.198     0.150
    16.043   402.179     0.150
    16.983   232.908     0.150
    16.983   232.908     0.150
    16.983   418.408     0.150
    16.983   418.389     0.150
    18.573     4.300     0.150
    18.573     8.000     0.150
    19.752   275.709     0.150
    20.120   273.499     0.150
    20.172     4.699     0.150
    20.172   501.408     0.150
    20.444   274.509     0.150
    20.887   280.849     0.150
    24.297   315.309     0.150
    24.295   316.809     0.150
    24.520     4.601     0.150
    27.548     6.000     0.150
    27.548   398.009     0.150
    30.789   376.368     0.150
    32.983   392.908     0.150
    39.903   454.209     0.150
    39.903   454.209     0.150
    40.063   463.709     0.150
    40.063  1024.809     0.150
    42.920   477.783     0.150
    43.240   480.658     0.150
    43.249   480.509     0.150
    43.371   481.908     0.150
    43.440   482.908     0.150
    44.454   492.709     0.150
    44.508   493.209     0.150
    44.556   492.709     0.150
    44.566   494.108     0.150
    45.557   500.809     0.150
    45.623   500.509     0.150
    46.727   508.209     0.150
    47.042   512.608     0.150
    47.249   514.408     0.150
    47.335   505.509     0.150
    47.547   523.209     0.150
    47.567   515.309     0.150
    48.033   520.108     0.150
    48.212   520.828     0.150
    48.253   521.009     0.150
    49.150   528.349     0.150
    50.078   535.408     0.150
    50.267   537.108     0.150
    50.267   543.608     0.150
    50.436   537.499     0.150
    50.660   538.879     0.150
    51.390   547.108     0.150
    51.390   546.089     0.150
    51.429   545.309     0.150
    51.622   546.809     0.150
    52.018   549.809     0.150
    52.542   549.709     0.150
    52.542   549.709     0.150
    52.590   554.108     0.150
    53.278   558.809     0.150
    53.486   559.509     0.150
    54.270   566.188     0.150
    56.189   579.599     0.150
    57.716   592.448     0.150
    58.021   592.198     0.150
    58.544   595.969     0.150
    61.223   616.809     0.150
    66.432   648.898     0.150
    67.415   655.858     0.150
    71.744   681.278     0.150
    75.756   704.818     0.150
    78.416   720.108     0.150
    78.950   722.849     0.150
    78.956   722.969     0.150
    80.501   732.049     0.150
     3.073   731.809     0.150
     3.073   731.818     0.150
    87.195   764.809     0.150
   121.021  1132.809     0.150
   148.179  1186.559     0.150
     0.350    -0.273     0.150
     0.350     4.727     0.150
     1.037    10.969     0.150
     1.037    27.820     0.150
     3.040    77.828     0.150
     3.096    92.227     0.150
     3.409    94.828     0.150
     3.800    62.625     0.150
     4.389    56.828     0.150
     7.191   102.125     0.150
     7.994   112.328     0.150
     9.315   132.680     0.150
     9.315   234.750     0.150
    10.321   148.227     0.150
    10.321   154.430     0.150
    10.321   156.125     0.150
    10.321   262.625     0.150
    10.321   274.930     0.150
    10.321   282.227     0.150
    10.988   266.922     0.150
    10.988   275.086     0.150
    11.034   267.320     0.150
    11.034   276.461     0.150
    11.762   285.852     0.150
    11.762   294.250     0.150
    12.235   297.930     0.150
    12.235   308.039     0.150
    12.489   302.234     0.150
    12.489   314.180     0.150
    12.491   177.828     0.150
    12.491   301.828     0.150
    12.491   315.828     0.150
    12.586   303.000     0.150
    12.586   316.516     0.150
    13.271   180.727     0.150
    13.271   319.055     0.150
    13.271   333.289     0.150
    13.614   188.977     0.150
    13.755   330.461     0.150
    13.755   343.828     0.150
    13.942   337.727     0.150
    13.942   349.516     0.150
    13.864   194.367     0.150
    14.386   346.570     0.150
    14.386   360.461     0.150
    15.114   361.117     0.150
    15.114   376.719     0.150
    15.098   393.625     0.150
    16.041   386.039     0.150
    16.041   401.367     0.150
    16.983   236.227     0.150
    16.983   236.188     0.150
    16.983   409.180     0.150
    18.554     8.000     0.150
    18.554    12.602     0.150
    18.554   453.125     0.150
    20.098   269.781     0.150
    20.149     8.898     0.150
    20.149    13.594     0.150
    20.332     8.898     0.150
    20.332    13.094     0.150
    20.581     9.203     0.150
    20.581    13.203     0.150
    20.891   276.727     0.150
    20.891   278.359     0.150
    20.891   276.711     0.150
    20.891   505.648     0.150
    21.099   277.852     0.150
    22.456   536.586     0.150
    22.456   297.328     0.150
    22.456   536.125     0.150
    22.456   536.625     0.150
    22.456   297.367     0.150
    22.456   536.172     0.150
    22.456   536.586     0.150
    23.355    10.898     0.150
    23.355    16.102     0.150
    23.355    33.695     0.150
    23.355   568.828     0.150
    24.360   314.336     0.150
    24.497    13.094     0.150
    24.497    35.000     0.150
    24.497   567.930     0.150
    25.061   590.031     0.150
    27.528    11.500     0.150
    27.528   387.227     0.150
    27.528   637.227     0.150
    27.634   349.727     0.150
    27.634   627.227     0.150
    27.796   347.430     0.150
    30.825   373.445     0.150
    31.868   379.953     0.150
    33.005   392.078     0.150
    39.751   813.430     0.150
    39.882   449.977     0.150
    39.882   576.125     0.150
    39.882   804.625     0.150
    39.882   450.031     0.150
    39.882   576.125     0.150
    39.882   804.625     0.150
    39.943   450.656     0.150
    40.080   567.930     0.150
    40.080   452.000     0.150
    41.171   459.125     0.150
    41.205   826.531     0.150
    41.412   469.125     0.150
    43.094   475.828     0.150
    43.123   473.727     0.150
    43.214   477.328     0.150
    43.242   478.500     0.150
    44.578   489.531     0.150
    44.766   488.828     0.150
    45.055   492.328     0.150
    45.055   492.328     0.150
    45.247   493.734     0.150
    45.443   493.828     0.150
    45.476   495.930     0.150
    45.789   497.125     0.150
    45.989   506.828     0.150
    46.037   508.828     0.150
    46.668   504.930     0.150
    46.890   507.031     0.150
    46.890   507.031     0.150
    46.916   502.328     0.150
    46.937   507.727     0.150
    46.937   507.727     0.150
    47.064   508.625     0.150
    47.064   508.625     0.150
    47.070   508.727     0.150
    47.070   508.727     0.150
    47.096   508.828     0.150
    47.096   508.828     0.150
    47.326   511.430     0.150
    47.373   510.430     0.150
    47.384   510.828     0.150
    47.408   510.625     0.150
    47.408   510.625     0.150
    47.567   524.828     0.150
    47.587   512.930     0.150
    47.653   514.328     0.150
    47.639   512.930     0.150
    47.639   512.930     0.150
    47.721   520.328     0.150
    47.860   508.828     0.150
    47.942   513.031     0.150
    47.957   522.828     0.150
    48.280   516.328     0.150
    48.273   517.727     0.150
    48.767   522.430     0.150
    48.859   520.531     0.150
    49.133   524.328     0.150
    49.133   524.328     0.150
    49.170   525.055     0.150
    49.295   526.328     0.150
    49.881   529.867     0.150
    50.286   533.328     0.150
    50.418   534.656     0.150
    50.608   539.828     0.150
    50.679   536.117     0.150
    51.163   540.031     0.150
    51.163   555.227     0.150
    51.410   542.484     0.150
    51.449     8.695     0.150
    51.449   542.430     0.150
    51.449   551.125     0.150
    51.449   557.430     0.150
    51.453   542.828     0.150
    51.642   544.125     0.150
    51.642   559.531     0.150
    52.038   546.625     0.150
    52.456     8.000     0.150
    52.561   551.625     0.150
    52.561   566.727     0.150
    52.610     8.500     0.150
    52.610   550.930     0.150
    52.610   559.430     0.150
    52.610   566.031     0.150
    52.674   551.531     0.150
    52.674   566.930     0.150
    52.940   553.227     0.150
    52.940   553.328     0.150
    53.298     7.297     0.150
    53.298   555.430     0.150
    53.298   555.375     0.150
    53.505   557.031     0.150
    53.936   560.430     0.150
    53.936   576.531     0.150
    54.292   563.719     0.150
    54.369   562.625     0.150
    54.777   567.266     0.150
    56.209   576.445     0.150
    57.866   584.180     0.150
    58.565   593.008     0.150
    59.989   602.422     0.150
    59.989   734.617     0.150
    61.215   743.031     0.150
    63.242   624.125     0.150
    66.457   645.938     0.150
    67.970   655.867     0.150
    69.776   666.828     0.150
    71.721   678.531     0.150
    71.723   678.547     0.150
    77.713   710.820     0.150
    78.445   716.930     0.150
    78.947   719.578     0.150
    78.950   720.484     0.150
    79.365   908.828     0.150
    80.478   728.977     0.150
    80.548   728.586     0.150
     3.096   728.930     0.150
     3.096   909.727     0.150
     3.096   728.945     0.150
     3.096   909.727     0.150
    84.473   748.430     0.150
    87.194   761.727     0.150
   148.203  1181.828     0.150
     0.760    11.892     0.150
     0.760    22.091     0.150
     0.956    30.642     0.150
     2.345    68.751     0.150
     2.728    74.541     0.150
     3.957   110.991     0.150
     8.284   129.011     0.150
     8.284   222.131     0.150
    11.185   156.972     0.150
    11.185   274.271     0.150
    11.185   283.511     0.150
    11.199   274.801     0.150
    11.199   284.881     0.150
    11.079   212.812     0.150
    11.758   286.951     0.150
    12.233   300.392     0.150
    12.233   308.602     0.150
    12.291   300.961     0.150
    12.291   311.131     0.150
    12.664   308.091     0.150
    12.664   319.771     0.150
    12.666   308.991     0.150
    12.666   318.991     0.150
    12.666   171.341     0.150
    12.666   306.491     0.150
    12.666   323.991     0.150
    12.660   187.491     0.150
    12.755   172.191     0.150
    12.926   314.352     0.150
    12.926   327.301     0.150
    13.490   327.972     0.150
    13.490   340.432     0.150
    13.954   338.071     0.150
    13.954   352.081     0.150
    14.196   346.001     0.150
    14.196   359.361     0.150
    14.590   354.441     0.150
    14.590   366.551     0.150
    14.878   200.892     0.150
    14.878   200.831     0.150
    15.240   368.171     0.150
    15.240   381.881     0.150
    16.284   394.791     0.150
    16.284   407.682     0.150
    24.266   313.341     0.150
    24.266   313.341     0.150
     1.088     9.988     0.150
     1.088    22.928     0.150
     1.789    57.248     0.150
     2.959    85.729     0.150
     8.569   133.617     0.150
    25.388   325.969     0.150
    81.485   735.941     0.150
     0.502    13.492     0.150
     0.502    23.594     0.150
     2.506    41.395     0.150
     2.506    73.094     0.150
     3.109    47.762     0.150
     3.133    50.395     0.150
     3.133    88.094     0.150
     3.254    84.293     0.150
     3.427    96.844     0.150
     3.485    54.414     0.150
     3.523    97.852     0.150
     3.785    59.094     0.150
     3.785   103.293     0.150
     3.849    59.715     0.150
     4.045    61.723     0.150
     4.045   108.664     0.150
     4.045   108.754     0.150
     4.337    66.492     0.150
     4.337   116.691     0.150
     4.630    70.543     0.150
     4.630   123.184     0.150
     5.128   131.293     0.150
     9.036   131.992     0.150
    10.578   147.395     0.150
    10.578   153.094     0.150
    10.578   155.793     0.150
    11.055   156.812     0.150
    12.129   294.734     0.150
    12.163   294.703     0.150
    12.369   298.293     0.150
    13.621   329.082     0.150
    13.785   336.531     0.150
    13.884   344.191     0.150
    13.884   194.562     0.150
    13.884   344.203     0.150
    13.909   212.992     0.150
    14.029   348.293     0.150
    14.126   198.402     0.150
    14.249   344.602     0.150
    14.412   197.992     0.150
    15.010   361.664     0.150
    15.164   208.824     0.150
    15.159     5.699     0.150
    15.887   382.762     0.150
    17.132   236.684     0.150
    17.133   237.762     0.150
    17.133   237.762     0.150
    17.133   992.324     0.150
    18.031   447.633     0.150
    18.425     7.102     0.150
    19.765   269.402     0.150
    19.893     5.301     0.150
    19.893   487.293     0.150
    19.978   527.191     0.150
    20.025     4.801     0.150
    20.025     6.398     0.150
    20.389     4.000     0.150
    20.389     6.699     0.150
    20.389   505.293     0.150
    20.389   530.793     0.150
    20.772   283.117     0.150
    20.934   281.691     0.150
    21.132   285.988     0.150
    21.078   283.043     0.150
    21.078   511.672     0.150
    21.078   529.621     0.150
    21.078   283.070     0.150
    21.372   289.043     0.150
    21.601   291.754     0.150
    21.807   294.492     0.150
    21.949   293.773     0.150
    22.216   299.254     0.150
    22.515     0.137     0.150
    22.515     0.137     0.150
    22.515     0.137     0.150
    22.571   302.457     0.150
    24.434     0.160     0.150
    24.434   317.395     0.150
    24.598   319.426     0.150
    27.115   343.125     0.150
    27.183   343.664     0.150
    27.183   344.078     0.150
    27.377     4.699     0.150
    27.791   349.094     0.150
    27.791   348.992     0.150
    27.791   349.055     0.150
    27.933   350.828     0.150
    30.658   374.555     0.150
    30.996   447.691     0.150
    30.996   546.094     0.150
    30.996   788.191     0.150
    30.996   802.191     0.150
    30.996   377.102     0.150
    31.075   689.492     0.150
    31.144   379.691     0.150
    31.144   379.941     0.150
    31.409   382.793     0.150
    31.895   384.152     0.150
    31.895   554.902     0.150
    32.273   398.492     0.150
    32.273   389.992     0.150
    32.674     4.000     0.150
    32.927   404.691     0.150
    32.927   457.793     0.150
    33.336   398.094     0.150
    33.336   397.957     0.150
    33.336   397.957     0.150
    33.336   397.957     0.150
    34.768     5.801     0.150
    35.004   412.594     0.150
    35.379   877.594     0.150
    35.379   415.523     0.150
    35.762   418.492     0.150
    37.002   450.039     0.150
    37.015   450.082     0.150
    37.023   450.789     0.150
    37.194   516.793     0.150
    37.194   533.793     0.150
    37.609   430.164     0.150
    38.024     7.199     0.150
    39.551   975.293     0.150
    39.689   450.691     0.150
    39.689   577.293     0.150
    39.689   450.691     0.150
    39.689   577.293     0.150
    40.289   452.055     0.150
    40.390   817.191     0.150
    40.390  1030.293     0.150
    41.068   462.574     0.150
    41.423   461.895     0.150
    43.310   477.191     0.150
    43.424  1068.293     0.150
    43.424   482.293     0.150
    43.424   488.293     0.150
    43.424   868.293     0.150
    43.545   482.895     0.150
    43.574   483.305     0.150
    43.584   482.793     0.150
    43.584   583.992     0.150
    43.593   482.645     0.150
    43.924   487.191     0.150
    45.082   636.293     0.150
    45.082   493.293     0.150
    45.082   600.293     0.150
    45.082   636.293     0.150
    45.082   890.293     0.150
    45.113   636.293     0.150
    45.113   902.094     0.150
    45.113  1139.594     0.150
    45.245   492.293     0.150
    45.251  1081.691     0.150
    45.346   499.023     0.150
    45.387   498.094     0.150
    45.387   498.094     0.150
    45.808   501.191     0.150
    46.121   503.992     0.150
    47.000   510.691     0.150
    47.269   512.895     0.150
    47.269   512.895     0.150
    47.396   514.242     0.150
    47.429   513.594     0.150
    47.480   515.594     0.150
    47.480   515.594     0.150
    47.645     0.648     0.150
    47.646   515.094     0.150
    47.705   515.492     0.150
    47.702   515.492     0.150
    47.741   516.094     0.150
    47.741   516.094     0.150
    47.895   521.191     0.150
    47.915   515.793     0.150
    47.914   517.992     0.150
    47.999   516.691     0.150
    47.999   924.293     0.150
    48.053   517.594     0.150
    48.123   519.191     0.150
    48.134   519.492     0.150
    48.134   519.492     0.150
    48.158   519.492     0.150
    48.158   519.492     0.150
    48.260   519.691     0.150
    48.273   518.793     0.150
    48.611   521.395     0.150
    48.599   523.094     0.150
    48.646   521.793     0.150
    48.688   522.691     0.150
    48.793   523.094     0.150
    48.829   524.094     0.150
    48.997   524.895     0.150
    49.095   527.094     0.150
    49.190   525.594     0.150
    49.499   530.371     0.150
    49.546   530.293     0.150
    49.737   530.793     0.150
    49.762   532.691     0.150
    49.995   532.754     0.150
    50.144   534.422     0.150
    50.192   535.094     0.150
    50.540   537.742     0.150
    50.613   538.492     0.150
    50.613   653.895     0.150
    51.006   541.664     0.150
    51.579   546.395     0.150
    51.640   542.293     0.150
    51.774    13.199     0.150
    51.774   547.594     0.150
    51.774   553.395     0.150
    51.774   560.793     0.150
    51.774   667.191     0.150
    51.774   987.492     0.150
    51.777   547.293     0.150
    51.967   548.691     0.150
    51.967   554.191     0.150
    51.967   668.395     0.150
    52.574   551.293     0.150
    52.671   553.191     0.150
    52.737  1325.793     0.150
    52.782    13.801     0.150
    52.782   554.793     0.150
    52.782   559.691     0.150
    52.782   568.594     0.150
    52.782   676.594     0.150
    52.782  1002.094     0.150
    52.886   555.492     0.150
    52.886   561.293     0.150
    52.886   677.094     0.150
    52.935   555.992     0.150
    52.935   561.992     0.150
    52.935  1003.191     0.150
    53.000   556.691     0.150
    53.264   679.293     0.150
    53.264  1013.293     0.150
    53.264   558.191     0.150
    53.264   679.293     0.150
    53.264  1013.293     0.150
    53.569   560.395     0.150
    53.569   560.293     0.150
    53.625   560.594     0.150
    53.625   564.492     0.150
    53.625  1013.293     0.150
    53.829   574.793     0.150
    53.829  1248.293     0.150
    53.829  1302.293     0.150
    53.829   561.492     0.150
    53.829   574.793     0.150
    53.829  1014.293     0.150
    53.864   561.234     0.150
    53.988   562.793     0.150
    54.532   568.395     0.150
    54.669   567.191     0.150
    54.669   567.191     0.150
    54.869   569.113     0.150
    55.092   575.395     0.150
    55.103   571.691     0.150
    55.469   574.242     0.150
    55.458   573.094     0.150
    55.458   573.121     0.150
    55.784   583.691     0.150
    55.976   577.145     0.150
    56.536   582.055     0.150
    58.212   593.422     0.150
    58.367   595.324     0.150
    58.895   588.094     0.150
    58.895   588.094     0.150
     1.092   600.492     0.150
    60.319   607.574     0.150
    63.479   628.094     0.150
     1.438   634.215     0.150
    66.450   648.492     0.150
    66.674   646.293     0.150
    66.775   649.934     0.150
    67.184   644.293     0.150
    67.673   646.293     0.150
    68.302   660.371     0.150
    70.020   670.992     0.150
    71.209   675.863     0.150
    71.391  2347.645     0.150
    71.391   677.895     0.150
    71.752   681.691     0.150
    71.752   681.594     0.150
    72.069   683.492     0.150
    72.280   684.594     0.150
    72.445   684.691     0.150
    73.618   691.293     0.150
    73.648   691.234     0.150
    74.701   699.602     0.150
    75.883   705.262     0.150
    75.864   704.352     0.150
    76.891   708.895     0.150
    76.891   708.895     0.150
    77.302   713.574     0.150
    78.828  1852.645     0.150
    79.010   722.715     0.150
    79.053   722.402     0.150
    79.277   723.352     0.150
    79.532   724.293     0.150
    80.146   729.871     0.150
    80.533   730.691     0.150
    80.613   731.414     0.150
     3.427   731.594     0.150
     3.427   731.562     0.150
    80.924   734.074     0.150
    81.620   738.074     0.150
    82.942   744.512     0.150
    82.991   743.395     0.150
    85.358   758.055     0.150
    87.328  2288.238     0.150
    87.328  2319.438     0.150
    91.796   786.414     0.150
    95.915   805.652     0.150
    97.909   812.992     0.150
   102.085   842.012     0.150
   115.366  1121.242     0.150
   115.902  1122.543     0.150
   117.389  1125.465     0.150
   117.604  1125.832     0.150
   120.178  1130.012     0.150
   132.837  1152.863     0.150
   138.169  1157.594     0.150
   138.169  1160.043     0.150
   138.432  1162.004     0.150
   138.931  1161.434     0.150
   140.466  1163.762     0.150
   142.392  1168.215     0.150
   142.462  1167.113     0.150
   142.990  1168.742     0.150
   142.990  1404.969     0.150
   142.990  1170.293     0.150
   142.990  1170.293     0.150
   148.528  1183.613     0.150
   152.743  1188.324     0.150
   152.743  1197.652     0.150
   154.203  1198.012     0.150
     0.769    12.836     0.150
     3.151    50.531     0.150
     9.344   136.125     0.150
     9.344   237.602     0.150
    11.194   159.234     0.150
    11.211   282.102     0.150
    11.211   160.438     0.150
    12.757   177.633     0.150
    12.931   191.734     0.150
    12.931   328.734     0.150
    13.140   190.734     0.150
    13.140   197.734     0.150
    13.140   334.734     0.150
    13.140   346.734     0.150
    13.140   522.234     0.150
    13.172   321.000     0.150
    13.172   187.531     0.150
    13.717   191.531     0.150
    14.198   346.086     0.150
    14.830   361.102     0.150
    14.689     5.000     0.150
    14.689   366.734     0.150
    14.689   379.133     0.150
    15.924   384.516     0.150
    16.538   234.102     0.150
    16.538   234.133     0.150
    16.538   410.609     0.150
    18.958   259.438     0.150
    20.346   275.688     0.150
    20.353   505.312     0.150
    20.433   497.734     0.150
    20.441   505.336     0.150
    20.441   275.586     0.150
    20.441   275.734     0.150
    20.441   505.312     0.150
    22.284   301.500     0.150
    23.451   308.234     0.150
    24.008   318.938     0.150
    24.398     5.406     0.150
    24.398     8.805     0.150
    24.398   571.133     0.150
    24.398   621.633     0.150
    24.473   319.438     0.150
    24.778   326.633     0.150
    26.191   334.398     0.150
    26.191   334.336     0.150
    26.241   340.734     0.150
    29.219   363.938     0.150
    30.567   375.438     0.150
    30.812   377.734     0.150
    31.138   383.219     0.150
    31.582   387.906     0.150
    31.906   390.930     0.150
    31.906   390.938     0.150
    32.718   712.336     0.150
    36.450   432.633     0.150
    39.374   462.133     0.150
    39.731   452.336     0.150
    39.708   566.938     0.150
    40.728   458.734     0.150
    42.676   477.930     0.150
    46.130   505.633     0.150
    46.436   504.234     0.150
    47.005   512.336     0.150
    47.254   517.336     0.150
    47.254   526.633     0.150
    47.271   512.734     0.150
    47.806   518.633     0.150
    47.953   524.133     0.150
    47.953   518.734     0.150
    47.953   524.133     0.150
    48.041   521.469     0.150
    48.114   514.633     0.150
    48.570   524.336     0.150
    48.862   525.812     0.150
    49.117   527.031     0.150
    49.117   527.031     0.150
    49.452   529.477     0.150
    49.551   531.234     0.150
    49.964   535.234     0.150
    50.167   538.734     0.150
    50.838   541.031     0.150
    51.123   543.531     0.150
    51.123   548.336     0.150
    51.123   543.531     0.150
    51.314   545.234     0.150
    52.132   551.336     0.150
    52.285   552.234     0.150
    52.285   557.336     0.150
    52.609   553.938     0.150
    52.979   556.938     0.150
    52.979   561.836     0.150
    52.979   556.875     0.150
    53.172   562.133     0.150
    53.172   564.234     0.150
    53.172  1012.734     0.150
    53.172   557.734     0.150
    53.172   562.133     0.150
    53.172  1012.734     0.150
    53.610   561.836     0.150
    54.454   568.227     0.150
    58.997   600.227     0.150
    59.690   603.617     0.150
    60.823   623.734     0.150
    66.321   648.953     0.150
    67.661   656.414     0.150
    72.017   683.227     0.150
    80.728   733.492     0.150
    84.794   752.734     0.150
     1.313    38.953     0.150
     1.565    51.793     0.150
    48.431   520.688     0.150
     1.368    39.820     0.150
     1.933    61.141     0.150
     2.613    35.420     0.150
     3.597    54.420     0.150
     8.920   218.260     0.150
     9.535   136.240     0.150
     9.535   241.510     0.150
    10.284   149.320     0.150
    10.284   260.840     0.150
    11.649   284.971     0.150
    12.159   295.420     0.150
    12.659   312.480     0.150
    12.692   180.520     0.150
    12.692   312.820     0.150
    12.868   182.641     0.150
    12.963   313.449     0.150
    13.099   318.949     0.150
    13.100   333.420     0.150
    13.100   317.449     0.150
    13.098   322.375     0.150
    13.098   183.520     0.150
    14.357   199.721     0.150
    14.357   199.709     0.150
    14.357   352.840     0.150
    14.397   347.939     0.150
    14.658   372.561     0.150
    14.813     2.000     0.150
    15.034   361.650     0.150
    16.357   226.010     0.150
    16.357   398.910     0.150
    16.375   227.449     0.150
    16.375   398.631     0.150
    16.375   398.670     0.150
    18.453   453.260     0.150
    18.946     7.301     0.150
    19.818   480.045     0.150
    21.008     3.699     0.150
    21.008     5.500     0.150
    21.008   517.221     0.150
    21.202     3.000     0.150
    21.202     5.699     0.150
    21.202   513.820     0.150
    21.202   523.820     0.150
    21.288   285.490     0.150
    21.394     3.000     0.150
    22.618   306.920     0.150
    23.379   308.320     0.150
    23.745   312.221     0.150
    24.353   352.020     0.150
    25.225     4.000     0.150
    25.225     6.701     0.150
    25.225   653.020     0.150
    25.724   332.820     0.150
    26.489   340.221     0.150
    27.990     9.799     0.150
    27.990   640.920     0.150
    31.804   382.119     0.150
    34.592   409.221     0.150
    36.100   421.920     0.150
    36.714   424.320     0.150
    38.580     4.199     0.150
    38.771   439.510     0.150
    38.923    12.699     0.150
    38.923  1000.420     0.150
    40.043   451.221     0.150
    40.174   458.820     0.150
    40.487   457.420     0.150
    42.078   470.561     0.150
    42.261   476.920     0.150
    42.261   476.920     0.150
    42.309   471.320     0.150
    42.309   471.320     0.150
    43.252   475.420     0.150
    43.252    13.699     0.150
    43.252   861.020     0.150
    43.274   481.619     0.150
    43.328   482.920     0.150
    43.353   485.221     0.150
    43.522   482.570     0.150
    43.814   487.320     0.150
    44.378   490.721     0.150
    45.127   498.520     0.150
    46.234   504.471     0.150
    46.803   501.820     0.150
    46.853   516.119     0.150
    46.853   516.119     0.150
    46.896   509.420     0.150
    49.484   528.721     0.150
    50.255   536.520     0.150
    50.448   537.920     0.150
    50.919   541.570     0.150
    51.415   545.119     0.150
    51.415   550.420     0.150
    51.747   547.420     0.150
    52.101   550.320     0.150
    52.101   567.119     0.150
    52.315   549.420     0.150
    52.315   549.420     0.150
    54.894   571.020     0.150
    57.689   589.221     0.150
    58.789   597.859     0.150
    60.989    14.100     0.150
    62.308   620.721     0.150
    65.178   640.721     0.150
    66.771   651.270     0.150
    68.821   663.721     0.150
    68.862   662.920     0.150
    70.221   672.920     0.150
    72.923   688.369     0.150
    75.670   703.721     0.150
    78.051   717.381     0.150
    78.456   719.221     0.150
    78.613   720.510     0.150
    78.884   721.369     0.150
    80.176   728.891     0.150
    80.198   729.199     0.150
     1.933   729.721     0.150
     1.933   729.750     0.150
    80.545   731.279     0.150
    81.640   737.910     0.150
    81.670   738.141     0.150
    82.009   738.721     0.150
    82.635   742.920     0.150
    85.669   755.119     0.150
    85.669   755.109     0.150
    86.602   760.920     0.150
   120.374  1131.020     0.150
     3.362    51.311     0.150
    21.424   292.385     0.150
    72.600   692.994     0.150
     0.720    20.523     0.150
     2.285    60.602     0.150
     2.458    76.500     0.150
     3.355    58.500     0.150
     8.547   124.320     0.150
     8.730   129.797     0.150
     8.730   230.602     0.150
     8.803   139.789     0.150
     8.803   243.711     0.150
    11.200   286.797     0.150
    11.200   160.523     0.150
    11.991   167.648     0.150
    12.028   304.820     0.150
    12.028   172.898     0.150
    12.028   305.500     0.150
    12.028   172.898     0.150
    12.028   299.422     0.150
    12.097   300.477     0.150
    12.116   305.469     0.150
    12.116   173.312     0.150
    12.193   312.500     0.150
    12.208   311.320     0.150
    12.323   178.602     0.150
    12.384   175.500     0.150
    12.384   309.797     0.150
    12.622   181.797     0.150
    12.935   319.812     0.150
    13.145   319.117     0.150
    13.497   336.500     0.150
    13.497   187.500     0.150
    13.497   336.500     0.150
    13.497   187.500     0.150
    13.497   336.500     0.150
    13.593   338.359     0.150
    13.593   190.898     0.150
    13.593   190.742     0.150
    13.970   196.320     0.150
    14.835   223.000     0.150
    14.835   384.898     0.150
    15.138   379.977     0.150
    15.938   223.727     0.150
    16.071   222.906     0.150
    16.102   399.820     0.150
    16.102   224.000     0.150
    16.102   396.602     0.150
    16.102   223.703     0.150
    16.102   396.602     0.150
    19.089   461.547     0.150
    19.484     6.898     0.150
    19.484    10.797     0.150
    19.484   512.898     0.150
    19.726   267.531     0.150
    19.726   486.547     0.150
    21.703   296.703     0.150
    21.851    10.500     0.150
    21.893     5.898     0.150
    21.893     9.602     0.150
    21.893   536.898     0.150
    22.274   295.539     0.150
    22.274   296.922     0.150
    22.346     8.000     0.150
    22.346    11.398     0.150
    22.916   303.602     0.150
    22.916   551.703     0.150
    23.444   308.469     0.150
    23.686   312.711     0.150
    24.632   581.359     0.150
    24.632   320.500     0.150
    26.710   342.500     0.150
    28.954   547.500     0.150
    28.954   645.703     0.150
    28.954   547.570     0.150
    29.762   367.000     0.150
    29.762   367.031     0.150
    29.984   370.297     0.150
    30.087   370.203     0.150
    30.924   673.500     0.150
    31.950   386.930     0.150
    36.050   421.891     0.150
    36.140   758.500     0.150
    37.654   787.500     0.150
    37.731   445.398     0.150
    37.784   430.789     0.150
    38.042   438.547     0.150
    39.110    10.797     0.150
    39.247   535.797     0.150
    41.151   463.250     0.150
    41.132   461.648     0.150
    41.132   463.453     0.150
    41.140   463.352     0.150
    41.288   463.797     0.150
    41.288   463.797     0.150
    41.353   465.000     0.150
    41.684   469.297     0.150
    42.304   475.000     0.150
    42.358   475.203     0.150
    42.843   479.297     0.150
    42.843   479.281     0.150
    43.417   483.203     0.150
    44.257   489.578     0.150
    44.494   490.703     0.150
    44.494   490.703     0.150
    44.582   492.898     0.150
    44.822   494.797     0.150
    44.885   494.398     0.150
    45.181   496.500     0.150
    45.293   497.000     0.150
    45.406   498.828     0.150
    45.414   508.102     0.150
    45.414   514.102     0.150
    45.883   502.602     0.150
    46.126   504.602     0.150
    46.523   507.898     0.150
    46.613   508.500     0.150
    46.743   510.000     0.150
    47.012   512.297     0.150
    47.081   511.500     0.150
    47.081   511.594     0.150
    47.710   516.602     0.150
    48.079   520.500     0.150
    48.144   520.297     0.150
    48.155   520.570     0.150
    48.536   523.703     0.150
    48.757   524.602     0.150
    49.166   528.898     0.150
    49.311   529.203     0.150
    49.450   529.109     0.150
    49.506   531.102     0.150
    50.177   539.398     0.150
    50.177   539.398     0.150
    50.315   537.102     0.150
    50.361   538.000     0.150
    50.361   537.961     0.150
    50.469   543.500     0.150
    50.469   538.102     0.150
    50.808   540.398     0.150
    50.843   535.203     0.150
    50.843   966.203     0.150
    51.091   542.328     0.150
    51.150   542.898     0.150
    51.150   542.898     0.150
    51.207   550.602     0.150
    51.207   658.602     0.150
    51.207   543.180     0.150
    52.390   551.602     0.150
    53.147   557.359     0.150
    56.701   583.469     0.150
    57.823   591.023     0.150
    61.002   622.602     0.150
    61.677   617.102     0.150
    64.466   636.844     0.150
    65.793   645.383     0.150
    68.168   660.531     0.150
    68.383   661.633     0.150
    77.777   716.961     0.150
    77.945   716.969     0.150
    78.234   719.344     0.150
    78.526   720.969     0.150
    78.801   721.820     0.150
    80.098   729.539     0.150
     0.961   730.203     0.150
     0.961   730.148     0.150
    80.470   731.922     0.150
    80.725   733.500     0.150
    80.725   733.523     0.150
    94.656   800.469     0.150
   120.001  1130.203     0.150
   146.081  1180.523     0.150
   146.685  1181.320     0.150
     7.287   104.924     0.150
     7.287   104.943     0.150
     7.500   106.764     0.150
    10.329   152.545     0.150
    10.329   154.244     0.150
    10.329   270.045     0.150
    10.652   149.795     0.150
    10.822   154.145     0.150
    10.890   152.244     0.150
    12.551   317.744     0.150
    13.028   201.514     0.150
    13.028   317.045     0.150
    13.636   333.014     0.150
    15.013     6.301     0.150
    15.464   214.443     0.150
    15.464   214.744     0.150
    16.931   236.443     0.150
    16.934   234.844     0.150
    16.934   414.475     0.150
    16.934   234.844     0.150
    16.934   414.443     0.150
    18.422   257.744     0.150
    19.999   271.145     0.150
    19.999   272.744     0.150
    20.859   279.545     0.150
    21.355   288.244     0.150
    24.356   318.744     0.150
    24.956   324.943     0.150
    25.334   335.943     0.150
    27.393   342.744     0.150
    27.393     7.500     0.150
    27.393   619.744     0.150
    27.393   702.545     0.150
    32.035   387.344     0.150
    33.091   477.344     0.150
    35.830   416.943     0.150
    36.222   414.145     0.150
    37.345   429.344     0.150
    39.742   451.344     0.150
    40.132  1051.943     0.150
    43.330   479.744     0.150
    43.548   482.443     0.150
    44.560   492.045     0.150
    44.614   492.443     0.150
    45.101   496.174     0.150
    45.658   499.844     0.150
    45.731   500.545     0.150
    46.743   509.045     0.150
    48.182   518.545     0.150
    49.894   531.844     0.150
    50.754   539.145     0.150
    51.958   543.617     0.150
    52.630   551.289     0.150
    52.980   550.475     0.150
    53.011   555.344     0.150
    53.035   552.463     0.150
    53.147   554.898     0.150
    55.219   569.791     0.150
    56.802   582.045     0.150
    58.648   595.645     0.150
    60.071   605.545     0.150
    78.571   722.545     0.150
    78.880   719.094     0.150
    78.880   720.545     0.150
   148.073  1184.443     0.150
     5.146    78.223     0.150
     5.146   133.723     0.150
     8.673   222.004     0.150
     8.673   126.023     0.150
     8.673   222.023     0.150
     8.824   217.324     0.150
     9.621   134.664     0.150
     8.750   136.875     0.150
     8.750   240.555     0.150
     9.929   145.422     0.150
     9.929   251.223     0.150
    10.690   152.523     0.150
    11.093   155.523     0.150
    11.093   158.324     0.150
    11.093   279.125     0.150
    11.253   160.422     0.150
    11.564   163.125     0.150
    12.207   304.797     0.150
    12.207   304.824     0.150
    12.290   302.785     0.150
    12.438   176.023     0.150
    12.492   174.035     0.150
    12.490   307.105     0.150
    12.490   175.625     0.150
    13.023   182.824     0.150
    13.023   321.625     0.150
    13.421   342.023     0.150
    13.421   487.023     0.150
    13.704   191.723     0.150
    13.704   191.625     0.150
    16.158   398.793     0.150
    16.158   224.324     0.150
    16.158   398.824     0.150
    19.436   488.023     0.150
    21.823    10.500     0.150
    21.823    14.000     0.150
    21.823   321.023     0.150
    22.149   294.023     0.150
    22.233   298.324     0.150
    22.233     9.699     0.150
    22.540   303.125     0.150
    22.845   306.422     0.150
    24.011   321.922     0.150
    25.165     8.699     0.150
    25.165   362.523     0.150
    25.902     8.699     0.150
    26.220   336.324     0.150
    28.510   353.523     0.150
    29.063   356.965     0.150
    29.063   541.023     0.150
    33.805   405.723     0.150
    35.935   421.223     0.150
    37.245   429.234     0.150
    38.164   779.324     0.150
    38.164   981.824     0.150
    38.842   441.125     0.150
    41.086   460.879     0.150
    41.258   466.422     0.150
    41.258   463.223     0.150
    42.969   477.312     0.150
    42.969   477.324     0.150
    45.524   498.824     0.150
    50.410   535.047     0.150
    50.410   535.723     0.150
    61.025   609.023     0.150
    61.025  1114.922     0.150
    73.766   693.523     0.150
    80.830   731.273     0.150
     1.183    34.477     0.150
     1.504    47.797     0.150
     1.591    51.375     0.150
     2.884    81.305     0.150
     5.023    73.297     0.150
     5.023    73.297     0.150
     8.549   121.895     0.150
     8.549   216.797     0.150
     8.745   127.598     0.150
     8.745   222.598     0.150
     9.834   250.781     0.150
     8.784   139.086     0.150
     8.784   243.957     0.150
    10.336   146.098     0.150
    10.336   259.195     0.150
    10.616   151.996     0.150
    10.918   155.098     0.150
    11.188   162.426     0.150
    11.206   159.098     0.150
    11.507   162.195     0.150
    12.044   304.258     0.150
    12.044   305.141     0.150
    12.044   170.965     0.150
    12.044   304.250     0.150
    12.389   311.367     0.150
    12.398   312.375     0.150
    12.980   177.426     0.150
    12.980   317.355     0.150
    13.146   181.797     0.150
    13.480   335.496     0.150
    13.606   337.535     0.150
    13.606   188.996     0.150
    14.854   366.996     0.150
    14.854   208.098     0.150
    16.120   222.395     0.150
    16.120   394.672     0.150
    19.077   459.035     0.150
    21.906     5.500     0.150
    21.906     8.199     0.150
    21.906   522.598     0.150
    22.272   294.695     0.150
    22.350     5.000     0.150
    22.350     6.898     0.150
    22.350   296.297     0.150
    23.467   307.895     0.150
    25.993     9.398     0.150
    25.993    13.801     0.150
    25.993   330.496     0.150
    26.344   338.195     0.150
    28.577   353.098     0.150
    37.121   427.688     0.150
    38.051   435.516     0.150
    38.051   441.797     0.150
    39.258   445.895     0.150
    41.165   462.195     0.150
    42.847   476.695     0.150
    45.417   497.195     0.150
    48.550   520.215     0.150
    50.346   539.195     0.150
    51.097   540.430     0.150
    51.385   542.496     0.150
    52.400   550.246     0.150
    65.797   642.656     0.150
    65.797   642.695     0.150
    71.937   679.746     0.150
    71.937     1.719     0.150
    71.937   679.570     0.150
    72.731   687.395     0.150
    73.888   692.496     0.150
    78.066   714.848     0.150
    78.252   717.672     0.150
    81.089   731.598     0.150
    81.861   737.316     0.150
   120.019  1129.395     0.150
     0.584     9.109     0.150
     0.584    15.234     0.150
     1.553    51.672     0.150
     1.926    29.461     0.150
     1.926    53.828     0.150
     2.882    75.930     0.150
     7.536   185.898     0.150
     8.630   133.281     0.150
     8.630   231.750     0.150
    19.935   267.805     0.150
    27.130   340.047     0.150
    75.497   705.078     0.150
     1.819    58.875     0.150
     3.375    43.312     0.150
     3.375    86.422     0.150
    12.942   325.854     0.150
    20.841   286.804     0.150
     0.833     9.602     0.150
     0.833    19.402     0.150
     2.940    84.762     0.150
     4.555    75.402     0.150
     4.555   125.402     0.150
     7.175   183.793     0.150
     8.037   248.402     0.150
     8.803   230.641     0.150
    12.998   315.344     0.150
    15.618   378.441     0.150
    16.473   233.773     0.150
    23.874   309.551     0.150
    46.932   506.746     0.150
    49.813   529.879     0.150
     2.126    68.461     0.150
     6.212    93.258     0.150
     9.556   134.266     0.150
     9.556   138.367     0.150
     9.742   140.148     0.150
    10.138   156.672     0.150
    10.138   145.789     0.150
    11.964   167.930     0.150
    11.964   167.945     0.150
    12.682   178.672     0.150
    12.746   179.172     0.150
    12.751   179.367     0.150
    12.868   317.664     0.150
    12.868   182.602     0.150
    12.904   182.172     0.150
    12.934   326.969     0.150
    12.934   312.062     0.150
    13.023   183.469     0.150
    13.075   183.469     0.150
    13.715   192.172     0.150
    13.985   196.172     0.150
    14.085   197.266     0.150
     3.592   200.922     0.150
     3.592   200.867     0.150
    14.578   203.211     0.150
    14.578   203.047     0.150
    14.620   204.570     0.150
    14.789   204.867     0.150
    14.915   214.570     0.150
    14.915     4.102     0.150
    14.915   210.125     0.150
    15.246   213.266     0.150
    16.516   228.266     0.150
    17.543   243.070     0.150
    19.905   480.594     0.150
    20.013   270.867     0.150
    20.239   273.867     0.150
    20.323   274.516     0.150
    21.079   283.227     0.150
    21.135     4.203     0.150
    21.227     3.195     0.150
    21.227     4.695     0.150
    21.227   285.141     0.150
    21.293   287.172     0.150
    21.327   288.367     0.150
    22.664   305.711     0.150
    23.017   304.398     0.150
    24.202   348.070     0.150
    25.136     9.000     0.150
    25.136   324.859     0.150
    26.567   341.570     0.150
    28.184   360.969     0.150
    28.377   349.266     0.150
    28.377   632.672     0.150
    29.649   428.469     0.150
    29.830   368.281     0.150
    29.904   368.266     0.150
    30.966   377.367     0.150
    31.278   378.172     0.150
    31.298   380.016     0.150
    31.823   383.766     0.150
    35.690   418.281     0.150
    35.879   416.266     0.150
    35.879   507.867     0.150
    38.314   440.359     0.150
    40.266   455.672     0.150
    40.266   549.367     0.150
    41.419   466.641     0.150
    42.530   474.969     0.150
    43.492   484.766     0.150
    43.546   483.258     0.150
    43.546   483.172     0.150
    43.820   483.961     0.150
    43.820   483.961     0.150
    43.820   585.727     0.150
    43.820   619.727     0.150
    43.820  1109.242     0.150
    44.032   488.719     0.150
    44.498   491.859     0.150
    44.498   491.859     0.150
    44.498   642.695     0.150
    44.498  1181.758     0.150
    44.598   492.469     0.150
    44.604   490.680     0.150
    45.505   495.672     0.150
    45.679   501.766     0.150
    45.755   501.117     0.150
    46.080   504.375     0.150
    46.352   506.266     0.150
    46.431   506.266     0.150
    46.431   506.281     0.150
    46.458   506.969     0.150
    46.611   508.867     0.150
    47.071   512.969     0.150
    47.101   511.227     0.150
    47.146   513.766     0.150
    47.915   521.266     0.150
    48.192   520.492     0.150
    48.249   520.852     0.150
    48.887   526.070     0.150
    49.082   526.961     0.150
    49.259   529.969     0.150
    49.707   531.961     0.150
    49.929   534.867     0.150
    50.084   539.469     0.150
    50.191   536.367     0.150
    50.478   538.570     0.150
    50.480   540.070     0.150
    50.484   539.867     0.150
    50.540   539.070     0.150
    51.638   546.969     0.150
    52.538   553.070     0.150
    52.677   552.828     0.150
    54.795   572.867     0.150
    54.952   571.219     0.150
    55.626   576.586     0.150
    56.467   584.367     0.150
    57.230   586.172     0.150
    57.587   590.070     0.150
    57.929   590.867     0.150
    61.086  1105.570     0.150
    65.393   643.086     0.150
    65.529   643.328     0.150
     0.140   643.859     0.150
    66.986   652.602     0.150
    67.058   653.820     0.150
    69.030   665.680     0.150
    72.825   687.469     0.150
    72.825   687.500     0.150
    75.491   704.016     0.150
    78.203   718.766     0.150
    78.203   718.758     0.150
    78.598   720.875     0.150
    80.317   730.180     0.150
    81.461   737.336     0.150
    81.791   739.250     0.150
     1.346    39.133     0.150
     1.797    57.414     0.150
     1.797    34.141     0.150
     1.797    57.859     0.150
     3.302    85.227     0.150
     5.707    86.133     0.150
     5.887    88.766     0.150
     8.998   129.406     0.150
     9.345   230.930     0.150
     9.413   136.727     0.150
    10.442   149.086     0.150
    11.688   166.930     0.150
    11.697   168.109     0.150
    12.293   171.992     0.150
    12.222   175.711     0.150
    12.655   180.336     0.150
    13.051   330.133     0.150
    14.323   200.953     0.150
    14.323   200.727     0.150
    14.917   214.031     0.150
    16.417   229.242     0.150
    16.437   230.352     0.150
    16.437   231.180     0.150
    20.183   273.195     0.150
    21.408   286.914     0.150
    21.621   288.430     0.150
    23.383   308.531     0.150
    23.435   309.312     0.150
    23.777   314.133     0.150
    23.777   314.164     0.150
    25.412   327.836     0.150
    27.103   343.836     0.150
    37.985   437.656     0.150
    37.985   437.930     0.150
    41.090   463.789     0.150
    41.934   470.844     0.150
    41.982   470.406     0.150
    42.213   471.633     0.150
    43.170   479.586     0.150
    43.170   479.633     0.150
    43.224   482.336     0.150
    43.709   486.531     0.150
    44.280   488.008     0.150
    44.280   488.031     0.150
    46.185   504.633     0.150
    46.749   509.836     0.150
    48.848   525.602     0.150
    49.235   528.586     0.150
    51.950   549.133     0.150
    53.183   557.336     0.150
    55.021   571.406     0.150
    57.261   587.531     0.150
    66.661   650.820     0.150
    73.025   688.734     0.150
    75.241   701.914     0.150
    75.351   702.984     0.150
    78.076   717.852     0.150
    78.485   718.531     0.150
    86.661   763.430     0.150
     0.707    17.129     0.150
     0.707    27.926     0.150
     2.579    75.719     0.150
     4.444    86.887     0.150
     5.876   107.699     0.150
     6.901    99.828     0.150
     0.489     6.758     0.150
     0.489    13.270     0.150
     0.562    21.008     0.150
     7.214   103.789     0.150
     7.214   104.863     0.150
     7.214   103.770     0.150
     9.221   226.980     0.150
     9.221   132.867     0.150
    10.954   151.367     0.150
    11.958   168.270     0.150
    12.032   169.070     0.150
    12.608   180.488     0.150
    12.608   317.828     0.150
    12.793   180.809     0.150
    12.793   180.770     0.150
    12.840   177.668     0.150
    13.192   183.969     0.150
    13.207   184.367     0.150
    13.372   187.469     0.150
    13.488   189.168     0.150
    13.477   188.570     0.150
    13.600   188.770     0.150
    13.559   192.473     0.150
    13.569   189.270     0.150
    14.276   199.168     0.150
    14.310   198.270     0.150
    14.826   206.668     0.150
    14.966     5.102     0.150
    15.385   213.367     0.150
    15.385   213.367     0.150
    16.867   231.668     0.150
    17.789   245.168     0.150
    18.417     6.102     0.150
    18.994   467.070     0.150
    19.716   472.707     0.150
    20.069   269.270     0.150
    20.256    11.199     0.150
    20.455     8.801     0.150
    20.455    12.199     0.150
    20.455   529.168     0.150
    20.657   279.461     0.150
    20.870   280.270     0.150
    21.246   287.395     0.150
    21.484   288.715     0.150
    21.878   293.582     0.150
    22.089   297.754     0.150
    22.089   297.754     0.150
    22.148   295.938     0.150
    22.216   296.477     0.150
    22.357   297.789     0.150
    22.432   300.289     0.150
    22.738   302.344     0.150
    22.831   303.512     0.150
    23.003   302.609     0.150
    23.828   313.531     0.150
    24.378   312.168     0.150
    24.378    14.402     0.150
    26.320   337.574     0.150
    26.320   337.574     0.150
    26.521   337.121     0.150
    27.325   610.668     0.150
    27.847   349.141     0.150
    30.693   371.969     0.150
    30.693     8.539     0.150
    30.702     8.598     0.150
    30.702   551.867     0.150
    31.379    10.297     0.150
    31.379    12.797     0.150
    31.853   382.969     0.150
    32.196   386.070     0.150
    32.275   385.270     0.150
    32.773     4.500     0.150
    33.017   391.367     0.150
    35.063   407.469     0.150
    35.063   502.070     0.150
    35.063   736.770     0.150
    35.063   876.570     0.150
    35.063   895.168     0.150
    36.854   424.117     0.150
    38.758   439.219     0.150
    38.758   442.367     0.150
    38.758   439.270     0.150
    39.326   447.367     0.150
    40.053     6.801     0.150
    40.053   568.469     0.150
    40.315   459.168     0.150
    41.069     7.801     0.150
    41.069     7.250     0.150
    42.765   475.270     0.150
    43.253   478.469     0.150
    43.253   479.367     0.150
    43.607   483.027     0.150
    44.746   490.438     0.150
    44.746   490.438     0.150
    44.746   631.078     0.150
    44.746  1063.488     0.150
    44.746   490.367     0.150
    44.746   588.668     0.150
    44.746   592.770     0.150
    44.746   631.070     0.150
    44.746   886.367     0.150
    45.109   637.969     0.150
    45.109   910.367     0.150
    45.109  1147.168     0.150
    46.475   907.770     0.150
    46.740   503.070     0.150
    47.085   508.867     0.150
    47.309   511.270     0.150
    47.568   519.469     0.150
    48.122   518.668     0.150
    48.267   523.777     0.150
    48.768   521.867     0.150
    48.888   530.480     0.150
    49.217   525.867     0.150
    49.816   529.969     0.150
    50.284   541.270     0.150
    50.625   543.570     0.150
    50.677   541.668     0.150
    50.802   543.984     0.150
    50.908   537.969     0.150
    51.312   547.070     0.150
    51.444   543.270     0.150
    51.447   548.688     0.150
    51.455   548.969     0.150
    51.505   548.070     0.150
    51.607   550.258     0.150
    52.606   551.867     0.150
    52.933   554.270     0.150
    52.933   560.867     0.150
    53.297   556.469     0.150
    53.497   558.270     0.150
    54.332   563.367     0.150
    54.437   564.180     0.150
    54.958   568.367     0.150
    56.728   574.188     0.150
    56.728   574.168     0.150
    58.037   598.309     0.150
    58.573   594.270     0.150
    58.804   603.059     0.150
    59.996   603.570     0.150
    59.996   599.500     0.150
    61.620   613.168     0.150
    64.939   636.629     0.150
    66.521   646.969     0.150
    71.713   678.969     0.150
    75.030   697.918     0.150
    76.764   707.090     0.150
    77.123   710.070     0.150
    77.929   715.738     0.150
    78.277   715.891     0.150
    78.280   715.430     0.150
    78.280   716.969     0.150
    78.344   716.480     0.150
    78.513   717.289     0.150
    78.824   719.367     0.150
    79.285   721.520     0.150
    80.349   726.969     0.150
    80.417   726.969     0.150
    80.417   726.969     0.150
    80.451   728.570     0.150
     3.136   728.859     0.150
     3.136   730.035     0.150
    80.878   731.324     0.150
     1.496    49.469     0.150
     1.982    66.625     0.150
     2.411    70.523     0.150
     3.218    54.836     0.150
     1.742    55.078     0.150
     3.423    97.750     0.150
     4.160   118.551     0.150
     5.823    87.480     0.150
     8.175   208.277     0.150
     9.276   229.277     0.150
    10.480   268.379     0.150
    10.480   150.168     0.150
    10.480   150.180     0.150
    11.477   161.277     0.150
    12.348   172.680     0.150
    12.469   176.879     0.150
    12.469   315.480     0.150
    12.545   178.078     0.150
    12.559   178.277     0.150
    12.577   178.180     0.150
    12.586   178.898     0.150
    12.586   178.848     0.150
    12.586   178.922     0.150
    12.586   178.922     0.150
    12.586   315.602     0.150
    12.666   179.578     0.150
    12.666   320.680     0.150
    12.784   180.277     0.150
    12.868   182.078     0.150
    13.111   186.980     0.150
    13.111   317.129     0.150
    13.111   334.051     0.150
    13.331   188.578     0.150
    13.371   189.277     0.150
    13.469   190.578     0.150
    13.469   340.879     0.150
    13.647   191.578     0.150
     3.209   196.340     0.150
     3.209   196.277     0.150
    14.252   198.480     0.150
    14.252   198.379     0.150
    14.278   201.379     0.150
    14.410   201.879     0.150
    14.973   209.480     0.150
    16.360   225.578     0.150
    16.381   398.484     0.150
    17.426   242.078     0.150
    19.098     5.000     0.150
    19.638   472.879     0.150
    19.645   269.750     0.150
    19.645   490.715     0.150
    19.933   274.156     0.150
    19.933   501.902     0.150
    19.975   271.980     0.150
    20.028   490.375     0.150
    20.197   276.574     0.150
    20.197   505.000     0.150
    20.303     6.500     0.150
    20.303   507.777     0.150
    20.465   279.844     0.150
    20.465   512.691     0.150
    20.587   280.539     0.150
    20.587   514.605     0.150
    20.691   281.766     0.150
    20.691   512.906     0.150
    20.798   281.457     0.150
    20.798   281.457     0.150
    20.798   514.617     0.150
    20.892   284.988     0.150
    20.892   518.461     0.150
    21.000   285.852     0.150
    21.000   519.895     0.150
    21.019   284.594     0.150
    21.019   522.332     0.150
    21.038   285.980     0.150
    21.038   524.137     0.150
    21.103   287.027     0.150
    21.103   521.398     0.150
    21.199     2.402     0.150
    21.199     6.199     0.150
    21.375     4.199     0.150
    21.375     7.398     0.150
    21.469   286.879     0.150
    22.149   297.227     0.150
    22.149   546.965     0.150
    22.170   297.762     0.150
    22.170   543.406     0.150
    23.234   307.180     0.150
    23.234   311.277     0.150
    23.234   560.109     0.150
    23.366   307.578     0.150
    23.366   307.777     0.150
    23.366   559.328     0.150
    24.039   316.402     0.150
    24.039   572.410     0.150
    24.548     8.500     0.150
    25.414   329.344     0.150
    25.414   595.363     0.150
    25.407     5.898     0.150
    25.565   329.973     0.150
    25.565   595.531     0.150
    26.118   335.281     0.150
    26.118   611.043     0.150
    26.229   335.816     0.150
    26.229   606.688     0.150
    26.917   341.965     0.150
    27.483   347.078     0.150
    27.989   347.680     0.150
    27.989   708.180     0.150
    28.335     4.199     0.150
    28.335     7.398     0.150
    29.242   658.578     0.150
    29.440   364.879     0.150
    30.289   673.980     0.150
    30.567   375.078     0.150
    30.646   375.137     0.150
    30.763   376.680     0.150
    30.805   376.680     0.150
    31.512     5.398     0.150
    31.633   687.129     0.150
    32.037     4.098     0.150
    33.137   720.680     0.150
    33.191   394.879     0.150
    33.486   395.180     0.150
    33.675   393.480     0.150
    33.675   483.078     0.150
    33.675   712.777     0.150
    33.675   845.480     0.150
    35.668   759.680     0.150
    37.342   429.480     0.150
    37.573   434.680     0.150
    37.925   436.691     0.150
    37.925   436.680     0.150
    38.117   440.379     0.150
    38.122   437.379     0.150
    38.468   558.680     0.150
    38.575   443.578     0.150
    38.732     6.801     0.150
    39.662   450.777     0.150
    39.931   453.578     0.150
    39.931   453.578     0.150
    39.931   453.578     0.150
    39.931   566.277     0.150
    39.931   816.578     0.150
    39.931   453.578     0.150
    39.931   816.578     0.150
    40.444   457.680     0.150
    40.657   458.578     0.150
    40.867     4.500     0.150
    41.033   462.879     0.150
    41.503   476.980     0.150
    41.503   847.980     0.150
    41.611   467.480     0.150
    41.725   468.879     0.150
    41.725   468.945     0.150
    41.725   468.879     0.150
    41.728  1591.879     0.150
    41.728   467.879     0.150
    41.728   471.879     0.150
    41.728   563.879     0.150
    41.869   469.379     0.150
    42.090   471.480     0.150
    42.146   471.180     0.150
    42.220   472.277     0.150
    43.105   480.480     0.150
    43.159   481.277     0.150
    43.450   481.059     0.150
    43.450   481.059     0.150
    43.450   581.660     0.150
    43.450   616.801     0.150
    43.450  1101.301     0.150
    43.450   480.980     0.150
    43.450   581.578     0.150
    43.450   616.777     0.150
    43.450   868.277     0.150
    43.450  1101.277     0.150
    43.519   483.379     0.150
    43.644   485.480     0.150
    44.213   488.480     0.150
    44.263   489.078     0.150
    44.273   489.277     0.150
    45.123  1145.277     0.150
    45.210   904.680     0.150
    45.292   498.680     0.150
    45.378   499.078     0.150
    45.591   499.980     0.150
    45.690   501.078     0.150
    45.776   502.180     0.150
    45.825   501.328     0.150
    45.903   502.680     0.150
    46.040   503.680     0.150
    46.113   503.680     0.150
    46.206  1106.879     0.150
    46.323   506.594     0.150
    46.455   505.480     0.150
    46.683   508.277     0.150
    46.762   508.879     0.150
    46.916   509.379     0.150
    47.221   511.980     0.150
    47.920   518.277     0.150
    48.076   520.180     0.150
    48.503   522.480     0.150
    48.777   524.480     0.150
    48.874   526.180     0.150
    48.932   526.180     0.150
    48.962   524.980     0.150
    49.164   527.879     0.150
    49.324   528.480     0.150
    49.544   530.379     0.150
    49.669   531.777     0.150
    49.669   531.777     0.150
    49.809   532.480     0.150
    49.956   534.078     0.150
    50.097   534.879     0.150
    50.159   535.277     0.150
    50.291   536.379     0.150
    50.591   976.879     0.150
    50.762   539.480     0.150
    50.889   977.379     0.150
    51.102   541.879     0.150
    51.256   543.680     0.150
    51.484   544.680     0.150
    51.591   546.078     0.150
    51.591   546.133     0.150
    51.626   546.152     0.150
    51.940   548.480     0.150
    51.940   621.379     0.150
    52.159   665.879     0.150
    52.159   743.879     0.150
    52.159  1211.879     0.150
    52.159   549.480     0.150
    52.159   620.879     0.150
    52.159   992.879     0.150
    52.584   554.480     0.150
    53.111   552.480     0.150
    53.111   556.379     0.150
    53.422   558.879     0.150
    53.423   559.578     0.150
    53.582   560.078     0.150
    53.879   562.180     0.150
    54.851   569.379     0.150
    54.992   570.879     0.150
    54.992   570.379     0.150
    55.401   574.480     0.150
    55.485   573.879     0.150
    56.275   579.180     0.150
    56.689   582.980     0.150
    57.196   586.078     0.150
    58.621   596.078     0.150
    59.568   601.879     0.150
    60.149   604.777     0.150
    60.149  1098.680     0.150
    60.852   616.328     0.150
    61.054   835.980     0.150
    61.054  1511.578     0.150
    61.222   614.078     0.150
    65.088   640.078     0.150
    66.597   649.379     0.150
    69.186   666.879     0.150
    69.186   665.367     0.150
    69.251   666.578     0.150
    69.563   668.980     0.150
    70.046   671.398     0.150
    70.574   674.668     0.150
    70.889   676.238     0.150
    71.478   680.879     0.150
    72.746   689.578     0.150
    72.746   689.480     0.150
    72.746   686.078     0.150
    72.784   687.879     0.150
    73.091   689.078     0.150
    74.091   693.078     0.150
    74.928   699.379     0.150
    75.308   701.879     0.150
    75.364   703.078     0.150
    76.370   708.980     0.150
    77.036   712.512     0.150
    77.036   712.578     0.150
    77.036   712.480     0.150
    77.781   712.707     0.150
    77.944   717.473     0.150
    77.985   711.508     0.150
    78.021   717.516     0.150
    78.094   717.480     0.150
    78.094   717.277     0.150
    78.297   719.156     0.150
    78.476   718.980     0.150
    78.660   720.492     0.150
    78.660   720.480     0.150
    78.932   721.180     0.150
    79.555   725.164     0.150
    80.227   729.078     0.150
    80.242   728.980     0.150
     1.742   729.359     0.150
     1.742   730.066     0.150
     1.742   729.379     0.150
    80.575   731.223     0.150
    80.594   731.078     0.150
    80.722   732.457     0.150
    81.281   735.379     0.150
    81.850   738.777     0.150
    81.900   738.277     0.150
    85.829   758.578     0.150
    88.537   772.180     0.150
    90.026   778.520     0.150
    90.819   781.777     0.150
    91.891   788.078     0.150
   119.271  1128.277     0.150
   129.558  1148.348     0.150
   141.625  1162.699     0.150
   147.175  1182.980     0.150
   150.382  1186.777     0.150
   150.382  1186.750     0.150
   152.422  1195.879     0.150
   153.771  1191.980     0.150
     1.773    56.156     0.150
    16.342   397.891     0.150
     0.570    20.234     0.150
     2.790    81.723     0.150
     0.841    16.891     0.150
     0.841    28.336     0.150
     1.689    32.078     0.150
     1.689    54.469     0.150
     0.882    29.609     0.150
     0.138     4.469     0.150
     0.138     6.891     0.150
     1.441    28.027     0.150
     1.469    28.027     0.150
     1.419    44.129     0.150
     1.766    33.430     0.150
     2.042    37.980     0.150
     2.465    78.867     0.150
     2.754    46.707     0.150
     2.918    84.270     0.150
     3.434    98.199     0.150
     4.172    68.520     0.150
     4.172   117.148     0.150
     5.834    88.129     0.150
     9.248   132.230     0.150
     9.248   134.828     0.150
     9.248   228.828     0.150
     9.266   228.250     0.150
     9.369   135.328     0.150
    10.442   150.230     0.150
    11.086   159.027     0.150
    11.141   159.730     0.150
    11.605   165.230     0.150
    11.784   166.430     0.150
    11.835   172.801     0.150
    11.857   170.730     0.150
    11.910   167.738     0.150
    12.326   172.629     0.150
    12.326   172.668     0.150
    12.432   176.930     0.150
    12.506   177.629     0.150
    12.518   178.328     0.150
    12.519   178.230     0.150
    12.540   177.930     0.150
    12.559   179.590     0.150
    12.632   179.129     0.150
    12.691   180.730     0.150
    12.830   182.027     0.150
    13.152   335.828     0.150
    13.242   323.320     0.150
    13.303   188.930     0.150
    13.337   188.328     0.150
    13.436   190.129     0.150
    13.746   194.430     0.150
     3.213   197.168     0.150
     3.213   197.129     0.150
    14.234   199.129     0.150
    14.234   199.027     0.150
    14.226   205.430     0.150
    14.226     4.500     0.150
    14.226   362.328     0.150
    14.372   202.527     0.150
    14.824   222.129     0.150
    14.944   210.230     0.150
    16.316   226.129     0.150
    17.380   242.527     0.150
    19.558   269.609     0.150
    19.686   476.527     0.150
    19.694   269.621     0.150
    19.945   271.930     0.150
    20.245   277.496     0.150
    20.269     6.000     0.150
    20.514   280.441     0.150
    20.634   282.098     0.150
    20.842   285.469     0.150
    21.044   286.879     0.150
    21.065   285.883     0.150
    21.086   286.938     0.150
    21.156     2.598     0.150
    21.156     4.000     0.150
    21.395   290.707     0.150
    21.325     8.801     0.150
    21.325   549.430     0.150
    21.454   287.828     0.150
    21.558     3.199     0.150
    21.558   529.328     0.150
    22.200   297.910     0.150
    23.270   307.527     0.150
    23.337   308.348     0.150
    23.611   310.719     0.150
    24.512   581.027     0.150
    25.359     4.297     0.150
    25.465   331.484     0.150
    26.280   336.918     0.150
    26.897     4.297     0.150
    26.897     7.098     0.150
    27.027   342.828     0.150
    27.998   347.527     0.150
    27.998   629.629     0.150
    28.095   353.328     0.150
    28.343   645.129     0.150
    29.570   414.730     0.150
    29.570   744.328     0.150
    30.245     4.301     0.150
    31.444   380.453     0.150
    33.685   398.230     0.150
    33.685   467.328     0.150
    33.685   839.328     0.150
    33.828     2.699     0.150
    35.500   412.027     0.150
    35.500   559.930     0.150
    35.746   420.328     0.150
    35.746   420.328     0.150
    35.950   417.527     0.150
    36.566   423.430     0.150
    38.460   792.430     0.150
    39.916   450.629     0.150
    39.916   450.629     0.150
    41.620   468.129     0.150
    41.731   468.730     0.150
    41.731   475.129     0.150
    41.696   469.328     0.150
    41.696     3.102     0.150
    41.696     4.301     0.150
    41.696   850.930     0.150
    41.923   469.328     0.150
    42.099   471.930     0.150
    42.230   473.230     0.150
    43.113   481.027     0.150
    43.446   481.449     0.150
    43.446   481.449     0.150
    43.446   581.699     0.150
    43.446   613.379     0.150
    43.446  1102.980     0.150
    43.446   481.430     0.150
    43.446   581.629     0.150
    43.446   613.328     0.150
    43.446   870.129     0.150
    43.446  1102.930     0.150
    43.653   485.828     0.150
    44.219   489.629     0.150
    44.282   490.230     0.150
    45.157   641.527     0.150
    45.157  1083.430     0.150
    45.661   498.430     0.150
    45.883   502.430     0.150
    46.766   510.930     0.150
    48.507   524.129     0.150
    48.754   524.629     0.150
    48.916   525.527     0.150
    49.142   528.027     0.150
    49.327   529.430     0.150
    49.960   534.629     0.150
    50.099   536.027     0.150
    50.162   535.828     0.150
    50.263   537.230     0.150
    50.293   536.730     0.150
    51.213   544.328     0.150
    51.259   543.527     0.150
    51.259   543.527     0.150
    51.488   544.129     0.150
    51.593   546.527     0.150
    51.887   547.133     0.150
    51.944   547.629     0.150
    52.160   550.828     0.150
    52.587   549.430     0.150
    53.100   557.027     0.150
    54.745   567.043     0.150
    54.938   571.027     0.150
    56.778   592.629     0.150
    57.785   592.629     0.150
    58.796   598.430     0.150
    61.002   613.027     0.150
    66.608   650.527     0.150
    68.720   664.129     0.150
    68.720   664.129     0.150
    70.057   672.688     0.150
    70.057   672.629     0.150
    73.084   689.527     0.150
    75.303   702.527     0.150
    75.419   703.430     0.150
    75.564   703.828     0.150
    76.347   710.129     0.150
    77.893   717.914     0.150
    78.045   717.930     0.150
    78.045   717.828     0.150
    78.147   718.027     0.150
    78.147   717.379     0.150
    78.652   720.090     0.150
     1.766   730.414     0.150
    81.482   736.730     0.150
    81.835   739.129     0.150
    81.849   738.828     0.150
    85.826   758.527     0.150
    86.560   762.105     0.150
   106.542  1103.121     0.150
   120.323  1129.246     0.150
   120.418  1128.301     0.150
   141.666  1170.078     0.150
   147.225  1183.730     0.150
     0.915    30.562     0.150
     0.630    11.047     0.150
     0.630    19.734     0.150
     0.872    29.062     0.150
     1.082    20.777     0.150
     1.113    20.289     0.150
     3.333    95.090     0.150
     4.172   115.750     0.150
     4.195   117.090     0.150
     9.298   134.148     0.150
     9.298   143.148     0.150
     9.298   146.148     0.150
     9.298   231.648     0.150
    26.929     9.500     0.150
    26.929    13.199     0.150
    37.218   424.648     0.150
    37.218   765.148     0.150
    40.634   458.496     0.150
    46.142   503.105     0.150
    53.141   555.742     0.150
     1.239    37.223     0.150
     1.462    42.086     0.150
     2.481    78.445     0.150
     2.953    85.375     0.150
     0.463     9.977     0.150
     0.543     9.781     0.150
     1.645    52.016     0.150
     0.786    23.797     0.150
     0.792    26.469     0.150
     0.047     3.816     0.150
     0.787    15.742     0.150
     0.346    11.156     0.150
     0.841    28.234     0.150
     1.585    51.258     0.150
     0.711    24.336     0.150
     1.419    27.707     0.150
     1.419    41.656     0.150
     2.114    66.328     0.150
     2.114    68.875     0.150
     2.499    77.387     0.150
     2.585    38.977     0.150
     3.305    95.066     0.150
     3.815    62.938     0.150
     6.251   160.227     0.150
     6.380   164.848     0.150
     9.000   127.445     0.150
     9.000   129.945     0.150
     9.137   224.527     0.150
    11.672   163.277     0.150
    12.680   174.488     0.150
    14.427   195.348     0.150
    14.427   198.445     0.150
    14.427     1.902     0.150
    14.801   212.047     0.150
    18.459   251.078     0.150
    21.444   283.848     0.150
    22.025   289.328     0.150
    22.114   289.527     0.150
    28.277   350.848     0.150
    32.140   381.445     0.150
    34.094   399.848     0.150
    41.568   466.738     0.150
    43.866   483.238     0.150
    51.909   545.828     0.150
    73.358   687.355     0.150
    73.446   688.926     0.150
    79.407   722.797     0.150
     1.689    55.277     0.150
    13.396   189.467     0.150
    13.396   340.467     0.150
    16.199   228.567     0.150
    48.633   523.672     0.150
     1.656    32.047     0.150
     1.542    50.724     0.150
     2.489    42.983     0.150
     3.193    92.384     0.150
     1.796    56.670     0.150
     1.547    29.641     0.150
     1.561    28.375     0.150
     1.835    58.383     0.150
     0.649    24.500     0.150
     0.816    37.469     0.150
     3.745    62.844     0.150
     0.461    17.148     0.150
     0.974    17.375     0.150
     1.849    32.906     0.150
     1.849    58.695     0.150
     0.461     7.523     0.150
     0.671    11.863     0.150
     1.606    51.465     0.150
     1.816    58.035     0.150
     0.759    13.896     0.150
     1.813    58.203     0.150
     1.822    58.023     0.150
     1.938    61.945     0.150
     0.413     5.742     0.150
     0.412     7.305     0.150
     0.526     8.715     0.150
     1.414    25.375     0.150
     1.681    54.945     0.150
     1.813    58.242     0.150
     1.821    57.773     0.150
     1.833    59.305     0.150
     1.884    60.062     0.150
     1.949    62.523     0.150
     2.088    66.914     0.150
     0.383    11.801     0.150
     0.551    17.109     0.150
     0.970    17.602     0.150
     1.351    44.180     0.150
     1.579    50.691     0.150
     0.680    20.789     0.150
     0.898    27.781     0.150
     0.298     4.867     0.150
     0.298     9.176     0.150
     0.423     7.137     0.150
     0.423    12.906     0.150
     0.591    18.316     0.150
     0.115     1.641     0.150
     0.115     2.273     0.150
     0.144     6.711     0.150
     0.247     6.164     0.150
     0.454     7.812     0.150
     0.551     9.109     0.150
     0.706    12.555     0.150
     0.706    21.289     0.150
     0.992    13.703     0.150
     1.788    32.703     0.150
     1.915    61.219     0.150
     0.151     7.141     0.150
     0.314    11.461     0.150
     0.783    24.363     0.150
     0.850    25.973     0.150
     0.971    17.402     0.150
     1.115    20.180     0.150
     1.326    26.691     0.150
     1.076    19.274     0.150
     1.241    23.544     0.150
     1.488    28.084     0.150
     1.550    48.964     0.150
     1.758    32.655     0.150
     1.758    54.964     0.150
     1.817    57.194     0.150
     1.954    36.204     0.150
     1.954    60.885     0.150
     1.975    61.405     0.150
     2.090    65.214     0.150
     2.121    37.594     0.150
     2.223    38.754     0.150
     2.226    38.764     0.150
     2.289    71.204     0.150
     1.605    31.754     0.150
     1.605    54.284     0.150
     2.098    67.524     0.150
     0.685    23.148     0.150
     0.783    13.859     0.150
     0.914    16.352     0.150
     1.641    51.461     0.150
     2.078    39.000     0.150
     0.301     5.188     0.150
     0.508    10.621     0.150
     1.363    26.070     0.150
     0.560     9.898     0.150
     0.173     4.516     0.150
     0.636    13.391     0.150
     0.779    23.117     0.150
     0.787    15.617     0.150
     0.787    23.586     0.150
     0.366    11.398     0.150
     1.277    38.277     0.150
     1.418    27.449     0.150
     1.662    29.277     0.150
     1.666    52.141     0.150
     0.923    27.939     0.150
     1.711    33.590     0.150
     1.948    37.340     0.150
     1.948    52.949     0.150
     1.622    50.846     0.150
     1.662    52.926     0.150
     0.573    21.516     0.150
     1.200    24.516     0.150
     1.649    32.125     0.150
     1.649    55.137     0.150
     1.631    55.137     0.150
     1.901    30.086     0.150
     1.901    50.465     0.150
     1.915    36.166     0.150
     1.915    60.656     0.150
     2.062    40.846     0.150
     2.089    40.275     0.150
     2.344    44.346     0.150
     2.416    42.887     0.150
     2.416    75.557     0.150
     2.782    50.465     0.150
     3.634    57.176     0.150
     5.269    85.105     0.150
     5.269   140.887     0.150
     5.441    87.146     0.150
     6.165    97.336     0.150
     2.031    38.766     0.150
     2.031    60.836     0.150
     0.750    13.609     0.150
     1.991    63.602     0.150
     0.092     5.812     0.150
     0.563    19.379     0.150
     0.820    27.797     0.150
     0.921    31.168     0.150
     1.065    35.879     0.150
     1.593    31.199     0.150
     1.801    33.109     0.150
     0.527    11.090     0.150
     0.527    20.367     0.150
     2.772    79.289     0.150
     3.056    50.230     0.150
     3.542    95.480     0.150
     4.248   113.117     0.150
     0.147     2.009     0.150
     0.147     3.720     0.150
     0.437    12.549     0.150
     0.534    15.939     0.150
     0.815    23.899     0.150
     1.175    36.930     0.150
     1.208    22.819     0.150
     1.208    37.089     0.150
     1.570    30.159     0.150
     1.693    32.069     0.150
     1.693    54.069     0.150
     1.759    56.899     0.150
     1.961    62.100     0.150
     2.061    36.399     0.150
     2.159    38.439     0.150
     2.165    38.060     0.150
     0.597    15.699     0.150
     0.597    24.390     0.150
     1.157    25.520     0.150
     1.675    27.379     0.150
     1.675    44.789     0.150
     0.563    17.484     0.150
     1.776    34.211     0.150
     0.355    10.938     0.150
     0.775    24.430     0.150
     0.809    25.258     0.150
     0.488    20.570     0.150
     0.614    18.602     0.150
     0.633    19.391     0.150
     0.754    13.383     0.150
     0.762    23.133     0.150
     0.854    15.281     0.150
     0.854    26.641     0.150
     0.988    18.484     0.150
     1.037    18.320     0.150
     1.062    18.719     0.150
     1.064    19.492     0.150
     1.180    21.289     0.150
     0.358     5.289     0.150
     0.358     8.453     0.150
     0.961    21.883     0.150
     0.961    37.633     0.150
     1.286    26.211     0.150
     1.816    34.289     0.150
     1.816    58.578     0.150
     2.436    42.695     0.150
     2.518    37.750     0.150
     2.518    65.023     0.150
     2.472    43.641     0.150
     2.534    44.281     0.150
     2.878    49.172     0.150
     2.996    85.734     0.150
     3.303    54.945     0.150
     3.303    94.211     0.150
     4.121    65.469     0.150
     5.045    77.570     0.150
     7.437   109.469     0.150
    16.450   399.195     0.150
     0.927    28.031     0.150
     1.292    23.539     0.150
     1.537    29.469     0.150
     2.073    64.891     0.150
     2.140    39.656     0.150
     2.140    66.922     0.150
     1.466    31.648     0.150
     1.171    38.633     0.150
     1.796    58.176     0.150
     1.863    36.195     0.150
     1.893    60.863     0.150
     0.529    12.785     0.150
     0.529    20.324     0.150
     1.822    60.613     0.150
     2.372    43.125     0.150
     0.906    31.871     0.150
     1.818    57.691     0.150
     0.663    13.273     0.150
     0.507    14.894     0.150
     1.065    33.304     0.150
     1.327    41.384     0.150
     1.419    25.874     0.150
     1.601    51.464     0.150
     1.799    33.844     0.150
     1.799    57.134     0.150
     1.814    32.764     0.150
     1.814    55.274     0.150
     0.685    21.684     0.150
     0.759    23.535     0.150
     1.225    24.184     0.150
     1.557    50.293     0.150
     1.582    29.703     0.150
     1.638    30.902     0.150
     1.922    35.832     0.150
     0.584    20.523     0.150
     0.699    11.262     0.150
     2.743    46.133     0.150
     2.743    79.223     0.150
     0.011     4.483     0.150
     0.692    20.093     0.150
     1.000    30.184     0.150
     1.104    22.783     0.150
     1.166    20.894     0.150
     1.239    22.583     0.150
     1.286    26.023     0.150
     1.333    26.413     0.150
     0.315     6.902     0.150
     0.869    25.473     0.150
     1.039    32.223     0.150
     1.252    25.582     0.150
     0.606    17.844     0.150
     0.770    22.930     0.150
     0.903    16.359     0.150
     1.076    31.940     0.150
     0.387    12.633     0.150
     1.184    21.285     0.150
     1.791    34.355     0.150
     1.791    58.426     0.150
     1.873    59.605     0.150
     0.783    23.891     0.150
     0.933    28.859     0.150
     1.070    32.688     0.150
     1.087    33.188     0.150
     1.791    34.180     0.150
     1.791    58.539     0.150
     1.817    34.203     0.150
     1.817    58.781     0.150
     1.823    34.453     0.150
     1.823    58.430     0.150
     1.877    35.648     0.150
     1.877    61.320     0.150
     1.923    36.758     0.150
     1.923    62.398     0.150
     1.934    36.672     0.150
     1.934    62.320     0.150
     2.128    39.375     0.150
     2.128    67.359     0.150
     1.079    35.820     0.150
     1.774    27.555     0.150
     1.774    46.531     0.150
     0.265     4.305     0.150
     0.092     2.941     0.150
     1.418    26.121     0.150
     1.653    53.422     0.150
     0.184     5.812     0.150
     0.480     8.551     0.150
     0.128     6.922     0.150
     0.757    13.875     0.150
     0.999    32.523     0.150
     4.590   126.055     0.150
    20.984   278.391     0.150
     0.752    13.337     0.150
     1.707    54.627     0.150
     1.897    60.807     0.150
     1.977    62.167     0.150
     2.037    64.457     0.150
     0.085     0.824     0.150
     0.615    10.734     0.150
     0.583    10.484     0.150
     1.433    27.574     0.150
     0.716    27.855     0.150
     2.581    67.793     0.150
     3.035    88.273     0.150
     3.484    58.145     0.150
     0.304     5.596     0.150
     0.591    10.536     0.150
     2.056    60.636     0.150
     0.266     5.172     0.150
     1.414    27.152     0.150
     1.456    48.142     0.150
     1.615    31.232     0.150
     1.615    52.522     0.150
     1.682    32.082     0.150
     1.682    53.562     0.150
     1.712    54.632     0.150
     1.817    34.452     0.150
     2.021    37.882     0.150
     2.232    66.022     0.150
     0.778    28.052     0.150
     2.844    81.962     0.150
     2.919    83.672     0.150
     3.085    48.832     0.150
     3.286    93.182     0.150
     3.547    53.102     0.150
     4.912   134.622     0.150
     5.275   142.832     0.150
     9.515   133.582     0.150
     9.515   238.512     0.150
    10.101   143.312     0.150
    10.101   149.512     0.150
    13.786   334.932     0.150
    20.354   277.752     0.150
    20.704    10.600     0.150
    26.419     4.300     0.150
    26.419   606.712     0.150
    26.862   337.472     0.150
    27.616   346.312     0.150
    43.010   476.962     0.150
    44.510   490.722     0.150
    44.510   490.722     0.150
    44.510   632.072     0.150
    44.510  1080.012     0.150
    44.510  1127.632     0.150
    44.755   492.852     0.150
    44.755   491.752     0.150
    47.134   510.182     0.150
    50.050   534.242     0.150
     0.752    25.914     0.150
     1.080    36.248     0.150
     1.355    40.379     0.150
     0.595    10.562     0.150
     0.766    23.953     0.150
     0.528     9.266     0.150
     1.416    27.117     0.150
     0.762    13.423     0.150
     1.668    53.883     0.150
     0.887    28.125     0.150
     1.571    50.859     0.150
     1.769    56.844     0.150
     0.703    15.672     0.150
     0.703    26.133     0.150
     1.756    58.797     0.150
     1.756    58.797     0.150
     2.730    79.344     0.150
     3.434    86.125     0.150
     0.796    14.078     0.150
     1.038    18.629     0.150
     1.152    20.980     0.150
     0.695    12.855     0.150
     0.743    13.285     0.150
     0.882    16.027     0.150
     0.939    30.914     0.150
     0.957    17.246     0.150
     1.046    18.824     0.150
     1.052    18.715     0.150
     1.156    27.684     0.150
     1.156    46.785     0.150
     1.451    29.074     0.150
     1.987    37.824     0.150
     1.987    65.184     0.150
     2.253    70.406     0.150
     2.686    71.457     0.150
     4.402    69.406     0.150
     4.391    71.797     0.150
     4.391   123.246     0.150
     5.803    88.207     0.150
     5.845    89.004     0.150
     5.798    89.605     0.150
     5.798   156.164     0.150
     6.040    91.406     0.150
     6.053    91.406     0.150
     6.617    98.805     0.150
     7.280   108.004     0.150
     7.468   110.664     0.150
     7.468   190.746     0.150
     7.964   117.504     0.150
     8.869   218.156     0.150
     9.385   134.605     0.150
     9.385   232.105     0.150
    14.401   350.430     0.150
    31.863     8.801     0.150
    52.012   546.312     0.150
    53.285   558.535     0.150
     0.837    15.355     0.150
     0.946    30.844     0.150
     0.984    32.008     0.150
     0.753    25.488     0.150
     1.016    18.457     0.150
     0.612    19.203     0.150
     1.974    37.617     0.150
     1.505    48.867     0.150
     1.380    25.148     0.150
     0.818    13.633     0.150
     1.097    36.713     0.150
     0.553    17.439     0.150
     0.962    17.489     0.150
     0.546    14.189     0.150
     0.546    22.579     0.150
     0.611    14.789     0.150
     0.611    23.589     0.150
     1.598    32.199     0.150
     1.598    54.209     0.150
     2.582    75.829     0.150
     2.717    47.769     0.150
     2.831    48.989     0.150
     2.831    83.189     0.150
     3.157    55.079     0.150
     3.286    82.749     0.150
     5.034    81.169     0.150
     7.687   115.299     0.150
     9.806   139.739     0.150
    11.522   165.079     0.150
    12.586   180.929     0.150
    13.303   328.350     0.150
    13.327   324.860     0.150
    15.065   368.290     0.150
    18.857    16.100     0.150
    20.614     8.000     0.150
    20.614    15.300     0.150
    20.973   284.739     0.150
    21.573   297.449     0.150
    23.855     9.300     0.150
    26.598   342.239     0.150
    26.598     4.800     0.150
    26.598     7.300     0.150
    27.867   349.939     0.150
    32.512    15.800     0.150
    33.136   401.040     0.150
    40.072   454.339     0.150
    42.803   478.299     0.150
    44.323   490.629     0.150
    44.323   490.629     0.150
    44.323    13.390     0.150
    44.323    17.580     0.150
    44.323   600.259     0.150
    44.323   632.049     0.150
    44.323   904.779     0.150
    44.323  1136.089     0.150
    44.522   494.030     0.150
    45.444   498.299     0.150
    46.696   510.299     0.150
    49.608   535.366     0.150
    50.426   543.339     0.150
    52.927   557.989     0.150
    53.045   554.729     0.150
    53.040   553.939     0.150
    53.962   563.239     0.150
     0.773    23.990     0.150
     0.832    17.227     0.150
     0.828    16.465     0.150
     0.834    16.523     0.150
     0.072     2.754     0.150
     0.103     3.004     0.150
     0.103     4.914     0.150
     0.182     4.402     0.150
     0.182     7.434     0.150
     0.230     5.125     0.150
     0.230     8.602     0.150
     0.245     5.062     0.150
     0.245     8.703     0.150
     0.338     6.934     0.150
     0.425     8.133     0.150
     0.449    15.285     0.150
     0.575    11.113     0.150
     0.575    19.094     0.150
     0.607    20.383     0.150
     1.238    25.844     0.150
     0.259     9.406     0.150
     0.373     7.516     0.150
     0.683    13.366     0.150
     0.045     2.446     0.150
     0.045     3.636     0.150
     0.198     5.006     0.150
     0.259     8.796     0.150
     0.265     5.636     0.150
     0.265     9.196     0.150
     0.636    13.826     0.150
     0.636    22.646     0.150
     0.683    13.246     0.150
     0.784    27.646     0.150
     0.385     8.023     0.150
     1.608    31.797     0.150
     1.608    54.227     0.150
     2.079    67.609     0.150
     2.595    44.758     0.150
     2.595    76.891     0.150
     4.264   119.523     0.150
     1.239    47.352     0.150
     1.940    56.266     0.150
     2.921    49.500     0.150
     2.921    84.242     0.150
     0.632    21.406     0.150
     0.672    23.785     0.150
     2.737    46.746     0.150
     2.737    80.746     0.150
     2.868    83.395     0.150
     4.356    66.297     0.150
     0.529     4.246     0.150
     0.529    11.066     0.150
     0.628    14.246     0.150
     0.628    28.090     0.150
     1.608    32.066     0.150
     1.608    52.938     0.150
     2.079    32.859     0.150
     2.596    36.949     0.150
     2.596    70.617     0.150
     3.484    44.898     0.150
     3.484    80.727     0.150
     3.299    43.387     0.150
     3.299    77.340     0.150
     3.804    56.828     0.150
     3.804   100.887     0.150
     4.315    63.348     0.150
     4.315   109.680     0.150
     4.265    61.367     0.150
     4.265   111.988     0.150
     5.915    83.977     0.150
     5.915   148.988     0.150
     0.644    14.945     0.150
     0.644    23.914     0.150
     0.611    14.664     0.150
     0.611    24.070     0.150
     1.598    33.531     0.150
     1.598    55.625     0.150
     2.063    66.375     0.150
     2.583    77.375     0.150
     3.286    86.984     0.150
     0.386    12.227     0.150
     0.829    16.438     0.150
     0.601    12.170     0.150
     1.153    36.291     0.150
     1.327    40.400     0.150
     0.623    10.633     0.150
     2.076    67.648     0.150
     2.595    77.469     0.150
     0.929    31.105     0.150
     0.961    17.492     0.150
     0.982    17.824     0.150
     1.011    23.223     0.150
     1.011    39.254     0.150
     1.366    48.723     0.150
     1.891    60.836     0.150
     2.593    40.426     0.150
     2.593    69.133     0.150
     3.076    51.652     0.150
     3.076    89.145     0.150
     1.482    28.367     0.150
     1.482    47.375     0.150
     1.518    47.727     0.150
     1.574    49.766     0.150
     1.659    52.438     0.150
     1.685    31.359     0.150
     1.727    54.000     0.150
     1.731    32.078     0.150
     1.832    33.789     0.150
     1.605    31.906     0.150
     1.605    53.719     0.150
     2.589    77.625     0.150
     0.757    25.270     0.150
     1.463    47.809     0.150
     1.573    51.590     0.150
     1.673    54.238     0.150
     1.772    57.289     0.150
     0.594    18.305     0.150
     0.771    13.570     0.150
     0.996    31.141     0.150
     1.533    48.688     0.150
     1.690    54.281     0.150
     0.425     7.539     0.150
     0.644    11.562     0.150
     1.653    53.156     0.150
     1.665    52.922     0.150
     1.731    54.719     0.150
     1.610    51.148     0.150
     1.675    53.398     0.150
     1.883    59.279     0.150
     0.471     7.867     0.150
     0.471    14.137     0.150
     0.505    15.438     0.150
     0.542    10.078     0.150
     1.602    29.848     0.150
     1.630    51.297     0.150
     1.670    52.555     0.150
     1.774    55.426     0.150
     1.567    29.469     0.150
     1.587    50.383     0.150
     0.855    25.891     0.150
     2.965    50.047     0.150
     2.965    85.289     0.150
     2.990    86.633     0.150
     0.170     4.008     0.150
     0.199     4.297     0.150
     0.223     4.977     0.150
     0.223     7.977     0.150
     0.299     6.344     0.150
     0.299     9.945     0.150
     0.351    11.359     0.150
     0.461    14.930     0.150
     0.553    10.398     0.150
     0.553    17.641     0.150
     0.579    18.984     0.150
     0.612    11.750     0.150
     0.638    12.023     0.150
     0.770    14.648     0.150
     0.788    14.805     0.150
     0.770    14.586     0.150
     0.788    14.586     0.150
     0.803    15.688     0.150
     0.803    26.297     0.150
     0.860    16.297     0.150
     0.853    16.195     0.150
     0.943    17.805     0.150
     0.996    19.070     0.150
     0.981    31.906     0.150
     0.996    32.305     0.150
     1.131    21.539     0.150
     1.131    37.023     0.150
     1.249    23.734     0.150
     1.276    23.938     0.150
     1.310    25.180     0.150
     1.310    42.727     0.150
     1.374    44.320     0.150
     1.386    26.125     0.150
     1.789    56.566     0.150
     1.765    55.898     0.150
     0.876    27.301     0.150
     1.533    49.418     0.150
     3.185    91.891     0.150
     3.958   112.750     0.150
     0.643    19.525     0.150
     0.576    11.422     0.150
     0.586    10.625     0.150
     0.865    28.750     0.150
     0.043     4.629     0.150
     0.632    19.471     0.150
     0.786    15.830     0.150
     0.076     5.191     0.150
     0.801    15.859     0.150
     0.268     6.336     0.150
     0.967    31.422     0.150
     1.171    39.125     0.150
     0.971     1.984     0.150
     0.971    15.586     0.150
     1.275    22.117     0.150
     1.275    37.117     0.150
     1.784    24.672     0.150
     0.109     3.703     0.150
     0.109     6.824     0.150
     1.426    26.973     0.150
     1.417    26.703     0.150
     1.655    53.133     0.150
     1.700    54.242     0.150
     2.132    66.672     0.150
     2.136    38.352     0.150
     0.109     3.730     0.150
     0.109     6.711     0.150
     0.252     5.562     0.150
     0.348     7.023     0.150
     0.449     8.562     0.150
     0.449    14.242     0.150
     0.424     8.664     0.150
     0.424    14.711     0.150
     0.468     8.961     0.150
     0.480     9.172     0.150
     0.679    13.922     0.150
     0.679    13.031     0.150
     0.678    12.922     0.150
     0.812    15.703     0.150
     0.812    25.852     0.150
     0.910    16.844     0.150
     0.910    27.992     0.150
     0.953    29.953     0.150
     1.032    19.441     0.150
     1.032    32.531     0.150
     1.260    23.594     0.150
     1.298    24.422     0.150
     1.426    27.023     0.150
     1.433    26.730     0.150
     1.481    28.344     0.150
     1.655    53.301     0.150
     1.700    54.691     0.150
     1.765    55.891     0.150
     1.799    33.301     0.150
     1.799    57.480     0.150
     1.969    36.051     0.150
     2.025    36.781     0.150
     2.132    38.191     0.150
     2.132    66.824     0.150
     2.136    38.230     0.150
     2.136    67.512     0.150
     2.264    70.914     0.150
     2.332    64.312     0.150
     2.379    64.574     0.150
     2.459    65.402     0.150
     2.387    65.492     0.150
     2.428    66.543     0.150
     2.439    47.594     0.150
     2.439    80.754     0.150
     3.061    82.391     0.150
     5.310   137.441     0.150
     5.655   146.852     0.150
     0.036     2.371     0.150
     0.036     4.281     0.150
     0.727    21.941     0.150
     0.788    14.430     0.150
     1.601    30.664     0.150
     2.067    66.750     0.150
     2.621    77.922     0.150
     1.603    50.809     0.150
     1.686    53.406     0.150
     0.978    30.046     0.150
     0.943    31.266     0.150
     0.324     8.984     0.150
     1.378    45.086     0.150
     1.720    33.150     0.150
    20.881   282.975     0.150
    74.472   697.330     0.150
     0.669    19.688     0.150
     0.836    16.641     0.150
     1.625    50.739     0.150
     0.358    11.266     0.150
     0.497     8.930     0.150
     1.039    20.461     0.150
     1.039    34.609     0.150
     1.083    35.969     0.150
     0.497    16.078     0.150
     1.216    37.883     0.150
     2.164    64.469     0.150
     2.236    66.219     0.150
     1.610    51.539     0.150
     1.698    53.855     0.150
     1.913    60.156     0.150
     1.589    50.633     0.150
     2.453    43.562     0.150
     0.756    22.962     0.150
     1.461    27.962     0.150
     0.855    16.781     0.150
     0.926    17.062     0.150
     0.937    16.500     0.150
     1.745    56.258     0.150
     0.510     8.869     0.150
     0.807    15.740     0.150
     0.848    15.129     0.150
     1.239    22.180     0.150
     1.605    51.180     0.150
     1.656    52.459     0.150
     0.345     6.914     0.150
     1.354    45.305     0.150
     1.112    20.188     0.150
     1.517    29.195     0.150
     0.451    14.742     0.150
     1.627    30.904     0.150
     1.147    39.168     0.150
     1.427    27.477     0.150
     0.441     8.062     0.150
     1.692    53.914     0.150
     1.749    55.004     0.150
     0.563   -35.475     0.150
     0.563   -28.954     0.150
     0.647    11.296     0.150
     0.732    12.995     0.150
     1.243    25.070     0.150
     0.021     2.445     0.150
     0.021     4.422     0.150
     0.748    13.734     0.150
     0.970    31.164     0.150
     1.422    27.242     0.150
     0.705    23.883     0.150
     0.988    33.191     0.150
     1.041    34.914     0.150
     1.083    36.184     0.150
     1.474    48.961     0.150
     1.679    54.781     0.150
     1.787    58.422     0.150
     1.870    60.402     0.150
     1.955    63.184     0.150
     2.045    65.824     0.150
     2.104    67.473     0.150
     2.246    40.852     0.150
    50.248   535.641     0.150
    73.978   692.199     0.150
     1.826    58.055     0.150
     1.939    34.781     0.150
     0.491    11.390     0.150
     0.491    19.410     0.150
     1.010    18.555     0.150
     1.452    47.102     0.150
     0.713    12.574     0.150
     1.004    18.062     0.150
     1.170    21.230     0.150
     0.955    16.938     0.150
     1.020    19.977     0.150
     0.194     5.426     0.150
     0.215     9.016     0.150
     0.570     9.805     0.150
     0.570    16.734     0.150
     0.858    26.805     0.150
     0.609    22.006     0.150
     4.545    70.795     0.150
     4.545   122.195     0.150
     5.148    79.896     0.150
     6.578   170.195     0.150
    46.998   510.945     0.150
    72.138   686.619     0.150
     1.562    50.352     0.150
     0.261     7.950     0.150
     1.472    28.297     0.150
     1.594    50.891     0.150
     1.667    53.703     0.150
     3.014    49.680     0.150
     3.014    86.141     0.150
     3.055    86.641     0.150
     3.791    61.875     0.150
     3.791   106.273     0.150
    12.340   171.219     0.150
    12.340   311.016     0.150
     1.179    24.781     0.150
     1.505    50.992     0.150
     2.592    44.111     0.150
     2.652    76.703     0.150
     3.302    54.822     0.150
     3.302    95.123     0.150
     6.971   102.742     0.150
    16.466   227.592     0.150
     1.461    27.777     0.150
     0.865    17.146     0.150
     1.092    19.957     0.150
     1.946    62.236     0.150
     2.093    64.697     0.150
     3.249    93.057     0.150
     1.243    22.828     0.150
     1.015    33.800     0.150
     1.878    59.450     0.150
     2.559    43.030     0.150
     2.698    44.710     0.150
     3.424    54.960     0.150
     4.305   121.340     0.150
     4.647   125.310     0.150
     4.690    73.310     0.150
     5.664   150.700     0.150
     5.896   149.710     0.150
     5.942   152.110     0.150
     5.968    89.110     0.150
     6.135   156.310     0.150
     6.148   155.910     0.150
     6.362   159.310     0.150
     8.526   131.590     0.150
     9.495   136.510     0.150
    10.367   262.010     0.150
    11.236   160.410     0.150
    11.284   160.710     0.150
    11.742   165.490     0.150
    11.742   165.510     0.150
    11.758   166.010     0.150
    11.758   165.910     0.150
    11.938   167.810     0.150
    11.998   170.630     0.150
    12.710   179.500     0.150
    12.710   179.177     0.150
    12.826   180.710     0.150
    12.842   181.720     0.150
    13.018   330.360     0.150
    13.242   191.820     0.150
    14.227   204.210     0.150
    14.227     4.300     0.150
    14.388   199.410     0.150
    14.388   350.445     0.150
    14.388   199.810     0.150
   155.455   206.130     0.150
    14.919   213.110     0.150
    14.919   219.710     0.150
    16.444   228.410     0.150
    16.464   407.105     0.150
    16.464   229.090     0.150
    17.216   257.640     0.150
    20.220   273.310     0.150
    20.464   276.690     0.150
    21.310   290.310     0.150
    21.326   285.310     0.150
    21.465     3.300     0.150
    23.435   308.290     0.150
    23.765   311.585     0.150
    23.967   312.710     0.150
    23.967   315.520     0.150
    25.328     2.400     0.150
    27.080   342.010     0.150
    27.601   399.310     0.150
    28.103   350.610     0.150
    28.259   645.810     0.150
    29.752   365.210     0.150
    30.197   368.810     0.150
    30.747   375.110     0.150
    32.238   383.270     0.150
    33.820   485.910     0.150
    33.820   847.610     0.150
    37.656   439.270     0.150
    38.067   437.210     0.150
    38.067   438.210     0.150
    38.694   449.010     0.150
    38.931     2.800     0.150
    38.931   578.510     0.150
    42.060   470.430     0.150
    42.060   470.310     0.150
    42.069   469.110     0.150
    42.236   472.510     0.150
    42.293   471.761     0.150
    42.293   471.810     0.150
    43.251   481.410     0.150
    43.305   482.210     0.150
    43.596   483.040     0.150
    43.596   483.040     0.150
    43.596   617.990     0.150
    43.596  1071.610     0.150
    43.596  1112.640     0.150
    43.596   483.010     0.150
    43.596   584.510     0.150
    43.596   617.910     0.150
    43.596   873.010     0.150
    43.596  1112.610     0.150
    43.790   486.610     0.150
    44.360   490.010     0.150
    44.419   490.610     0.150
    45.923   502.110     0.150
    59.689   502.870     0.150
    46.049   502.990     0.150
    46.049   503.010     0.150
    46.255   504.510     0.150
    48.908   524.920     0.150
    49.471   528.710     0.150
    49.956   533.010     0.150
    50.244   533.910     0.150
    50.244   533.910     0.150
    50.307   536.010     0.150
    50.408   537.210     0.150
    51.403   544.310     0.150
    52.029   549.010     0.150
    52.306   550.310     0.150
    52.731   552.510     0.150
    52.959   553.500     0.150
    53.254   556.510     0.150
    55.632   575.832     0.150
    57.342   586.530     0.150
    66.419   648.410     0.150
    66.743   650.380     0.150
    70.191   672.620     0.150
    70.191   672.610     0.150
    72.945   688.610     0.150
    75.161   701.360     0.150
    78.104   717.410     0.150
    78.104   717.430     0.150
    81.559   736.910     0.150
    81.559   736.910     0.150
    81.707   737.610     0.150
    86.689   761.910     0.150
   147.005  1183.660     0.150
     1.644    31.848     0.150
     1.355    26.906     0.150
     2.183    41.367     0.150
     1.692    32.020     0.150
     0.438    15.168     0.150
     1.846    59.977     0.150
     0.803    14.512     0.150
     0.709    19.272     0.150
     2.006    66.292     0.150
     3.890   110.406     0.150
    12.430   304.773     0.150
    14.056   347.867     0.150
    16.330   396.773     0.150
    21.453   287.789     0.150
    23.167   304.945     0.150
    27.196   342.656     0.150
    45.898   501.703     0.150
    48.983   525.469     0.150
     0.734    12.633     0.150
     0.523    12.422     0.150
     0.523    19.492     0.150
     1.003    17.795     0.150
     1.567    30.115     0.150
     1.741    55.836     0.150
     0.704    12.605     0.150
     3.751     8.828     0.150
     3.751    14.898     0.150
     0.442    12.156     0.150
     2.019    64.477     0.150
     2.978    51.367     0.150
     2.978    87.023     0.150
     4.839    74.203     0.150
     9.958   151.797     0.150
     9.958   258.797     0.150
    13.482   341.617     0.150
    13.482   341.617     0.150
    14.999     8.898     0.150
    18.292   245.156     0.150
    20.593    10.102     0.150
    22.881   304.289     0.150
    24.160   316.898     0.150
    26.797   338.820     0.150
    45.440   498.172     0.150
    47.202   512.531     0.150
    50.128   535.289     0.150
    53.103   557.781     0.150
    73.825   696.477     0.150
    78.657   721.047     0.150
    87.072   764.297     0.150
     0.600    14.504     0.150
     0.600    23.926     0.150
     1.227    25.746     0.150
     1.526    49.023     0.150
     1.591    51.625     0.150
     1.956    62.246     0.150
     1.985    63.434     0.150
     2.842    80.977     0.150
     3.149    88.535     0.150
     3.267    92.266     0.150
     3.314    53.094     0.150
     3.314    93.395     0.150
     4.979    74.234     0.150
     4.979    74.266     0.150
     4.979   131.266     0.150
     6.938   100.137     0.150
     6.938   100.164     0.150
     6.938   178.566     0.150
     8.499   122.664     0.150
     9.996   142.094     0.150
    10.778   151.195     0.150
    10.778   151.164     0.150
    10.900   154.164     0.150
    12.414   175.164     0.150
    13.597   338.035     0.150
    13.597   189.164     0.150
    13.597   189.266     0.150
    16.152   401.434     0.150
    17.856   446.051     0.150
    17.856   244.363     0.150
    17.856   446.066     0.150
    21.975     7.199     0.150
    22.322   295.664     0.150
    22.796   300.012     0.150
    22.829   301.664     0.150
    23.489   309.137     0.150
    23.494   308.965     0.150
    24.625   318.465     0.150
    27.357   343.703     0.150
    41.104   461.766     0.150
    45.399   497.465     0.150
    48.163   519.137     0.150
    48.544   522.344     0.150
    52.202   554.066     0.150
    52.379   554.863     0.150
    72.776   687.863     0.150
    73.930   694.324     0.150
    76.136   706.863     0.150
    86.651   762.176     0.150
    86.651   762.164     0.150
     0.365     3.607     0.150
     0.365     9.047     0.150
     3.239    89.947     0.150
     3.325    88.348     0.150
     3.353    94.037     0.150
     3.745    60.578     0.150
     3.745   106.566     0.150
     4.387    82.227     0.150
     4.774    71.646     0.150
     4.774   126.248     0.150
     5.477    87.938     0.150
     5.477   149.098     0.150
     7.949   113.967     0.150
     8.349   218.236     0.150
    10.667   150.047     0.150
    10.667   150.547     0.150
    12.404   305.037     0.150
    12.525   177.146     0.150
    12.525   319.146     0.150
    12.673   176.607     0.150
    12.818   177.447     0.150
    12.897   179.348     0.150
    13.266   184.697     0.150
    13.280   184.998     0.150
    13.435   336.195     0.150
    13.435   186.848     0.150
    13.518   188.297     0.150
    13.578   190.947     0.150
    13.640   189.348     0.150
    13.636   193.348     0.150
    13.636   200.547     0.150
    13.636   344.047     0.150
    13.622   189.547     0.150
    14.347   200.057     0.150
     4.513   210.447     0.150
     4.513   210.467     0.150
    15.171   210.867     0.150
    15.380   382.236     0.150
    15.380   211.848     0.150
    15.605   214.707     0.150
    16.941   233.348     0.150
    18.343   242.838     0.150
    17.878   246.027     0.150
    18.558     8.799     0.150
    19.348   262.646     0.150
    20.153   272.768     0.150
    20.153   272.748     0.150
    20.366   275.467     0.150
    20.377    10.000     0.150
    20.402   276.146     0.150
    20.474   276.307     0.150
    20.474   276.248     0.150
    20.499     9.500     0.150
    20.761   277.348     0.150
    20.849   279.137     0.150
    22.828   300.807     0.150
    22.828   300.736     0.150
    22.828   302.146     0.150
    24.256   314.748     0.150
    24.260   314.797     0.150
    24.525     5.199     0.150
    24.525   577.646     0.150
    24.810   320.646     0.150
    26.527   334.328     0.150
    26.527   334.248     0.150
    30.702   372.947     0.150
    30.842   373.848     0.150
    30.788     4.301     0.150
    32.750   389.422     0.150
    32.750   390.947     0.150
    34.956   742.047     0.150
    39.238   446.848     0.150
    39.562   449.047     0.150
    39.709   450.297     0.150
    39.904   451.848     0.150
    41.276   465.547     0.150
    43.185   479.348     0.150
    43.211   476.977     0.150
    43.211   476.973     0.150
    43.211   477.348     0.150
    43.211   477.047     0.150
    43.405   477.432     0.150
    44.418   488.748     0.150
    44.709   491.396     0.150
    44.709   491.396     0.150
    44.709   635.207     0.150
    44.709  1129.768     0.150
    44.709   491.348     0.150
    44.709   594.047     0.150
    44.709   635.146     0.150
    44.709   885.248     0.150
    44.709  1086.146     0.150
    44.709  1129.748     0.150
    44.958   494.748     0.150
    45.234   639.848     0.150
    45.234  1089.848     0.150
    45.533   497.848     0.150
    45.881   500.787     0.150
    46.751   503.547     0.150
    47.078   509.848     0.150
    60.281   510.188     0.150
    47.268   512.047     0.150
    47.295   511.646     0.150
    47.326   511.547     0.150
    47.352   512.547     0.150
    47.568   513.848     0.150
    47.746   514.777     0.150
    48.025   516.348     0.150
    48.214   518.408     0.150
    48.214   518.447     0.150
    48.489   520.348     0.150
    49.082   525.547     0.150
    49.113   526.348     0.150
    49.163   526.748     0.150
    49.264   526.248     0.150
    49.829   531.367     0.150
    49.829   530.977     0.150
    50.223   536.287     0.150
    50.223   534.047     0.150
    50.622   537.598     0.150
    50.622   537.547     0.150
    50.622   537.447     0.150
    51.256   542.248     0.150
    51.393   545.547     0.150
    51.370   542.678     0.150
    51.391   543.547     0.150
    51.398   543.047     0.150
    51.584   544.447     0.150
    51.629   544.396     0.150
    52.552   551.547     0.150
    52.617   552.447     0.150
    52.882   554.447     0.150
    53.184   556.248     0.150
    53.349   558.748     0.150
    53.600   558.223     0.150
    53.600   558.646     0.150
    54.118   563.127     0.150
    54.142   565.547     0.150
    54.312   563.547     0.150
    54.312   563.447     0.150
    54.373   565.146     0.150
    54.911   567.607     0.150
    54.911   567.646     0.150
    56.769   582.248     0.150
    57.395   586.947     0.150
    57.921   590.646     0.150
    58.120   592.047     0.150
    58.433   593.947     0.150
    58.507   593.947     0.150
    59.932   604.547     0.150
    59.946   603.947     0.150
    62.034   618.848     0.150
    62.472   621.447     0.150
    62.472   621.457     0.150
    62.770   622.947     0.150
    63.193   627.646     0.150
    67.422   654.797     0.150
    67.914   657.027     0.150
    67.914   656.928     0.150
    67.914   656.928     0.150
    69.879   669.037     0.150
    71.778   679.928     0.150
    73.863   692.828     0.150
    75.647   702.848     0.150
    75.767   704.598     0.150
    75.911   703.117     0.150
    78.441   718.387     0.150
    78.386   718.348     0.150
    78.735   719.947     0.150
    78.917   720.947     0.150
    78.917   720.748     0.150
    82.602   742.248     0.150
    82.602   742.578     0.150
   142.683  1167.572     0.150
   148.152  1182.248     0.150
   154.041  1197.248     0.150
     1.867    62.264     0.150
     5.265    79.293     0.150
    13.845   338.131     0.150
    45.664   500.623     0.150
    75.850   707.014     0.150
     0.507     8.467     0.150
     0.507    14.557     0.150
     2.833    47.328     0.150
     3.536    97.547     0.150
    16.788   236.408     0.150
    20.583   274.588     0.150
    20.581   278.895     0.150
     3.345    95.750     0.150
     4.330    67.340     0.150
     4.330   117.379     0.150
     4.718   129.738     0.150
     5.066    79.020     0.150
     8.443   222.129     0.150
    46.909   507.777     0.150
     0.916    15.295     0.150
     0.916    27.255     0.150
     1.501    31.284     0.150
     1.920    30.744     0.150
     1.920    49.645     0.150
     2.045    34.505     0.150
     2.577    78.515     0.150
     2.916    45.824     0.150
     2.916    79.784     0.150
     4.094   112.364     0.150
     5.462   148.675     0.150
     6.604    97.164     0.150
     8.834   128.095     0.150
     9.541   139.784     0.150
    12.282   304.334     0.150
    12.282   303.937     0.150
    13.286   191.715     0.150
    13.286   334.295     0.150
    16.271   402.150     0.150
    19.933   270.484     0.150
    19.933   270.476     0.150
    21.764   284.265     0.150
    21.764     7.300     0.150
    22.098   298.164     0.150
    23.207   306.799     0.150
    24.620   321.975     0.150
    25.828   328.765     0.150
    29.256   360.704     0.150
    38.339   440.364     0.150
    41.440   464.814     0.150
    43.669   488.704     0.150
    59.407   497.555     0.150
    45.697   500.064     0.150
    48.427   522.114     0.150
    48.810   524.635     0.150
    49.338   528.935     0.150
    49.826   535.435     0.150
    50.437   537.715     0.150
    50.992   545.364     0.150
    51.029   540.784     0.150
    52.502   551.635     0.150
    54.485   571.484     0.150
    59.768   603.034     0.150
    60.269   612.484     0.150
    65.763   643.744     0.150
    73.595   691.864     0.150
    77.866   716.515     0.150
    78.415   718.814     0.150
    86.320   761.864     0.150
    86.473   762.074     0.150
   120.201  1130.274     0.150
   141.153  1169.944     0.150
   153.120  1195.845     0.150
     0.863    12.177     0.150
     2.949    84.227     0.150
     2.951    41.346     0.150
     3.190    49.856     0.150
     3.217    35.066     0.150
     3.217    73.987     0.150
     3.431    50.816     0.150
     3.464    54.997     0.150
     3.651    57.896     0.150
     3.605    37.737     0.150
     3.605    70.846     0.150
     4.311    66.096     0.150
     4.411   125.036     0.150
     5.499   135.437     0.150
     5.991   158.707     0.150
     7.854   201.927     0.150
     8.309   129.286     0.150
     8.309   229.656     0.150
    15.105   223.697     0.150
    16.936   235.197     0.150
    18.198   244.866     0.150
    20.523    12.100     0.150
    20.726     8.500     0.150
    26.925   339.497     0.150
    39.697   449.326     0.150
    43.019   475.566     0.150
    52.944   553.951     0.150
    53.328   556.697     0.150
    75.152   700.086     0.150
     0.537    19.257     0.150
     3.155    92.627     0.150
    20.564   275.512     0.150
    47.118   511.252     0.150
    74.200   695.526     0.150
     0.381     9.102     0.150
     0.939    21.771     0.150
     0.939    36.361     0.150
     1.786    36.291     0.150
     1.786    61.091     0.150
     2.089    41.551     0.150
     2.089    70.261     0.150
     2.257    43.011     0.150
     2.257    73.001     0.150
     3.296    54.381     0.150
     3.296    92.352     0.150
     4.032   115.131     0.150
    10.886   153.821     0.150
    27.108   340.671     0.150
    36.734   425.301     0.150
    51.898   546.602     0.150
    53.175   555.251     0.150
    73.035   687.271     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     2.128    63.350     0.150
     3.117    48.350     0.150
     5.520    81.350     0.150
     7.414   104.350     0.150
     7.414   186.350     0.150
     8.749   124.350     0.150
    10.567   266.350     0.150
    11.720   162.850     0.150
    12.457   173.350     0.150
    12.457   304.350     0.150
    12.610   177.350     0.150
    13.032   322.350     0.150
    13.502   189.350     0.150
    16.878   408.350     0.150
    19.980   272.350     0.150
    19.980   492.350     0.150
    20.120   272.350     0.150
    20.120   489.350     0.150
    20.428   275.350     0.150
    20.428   500.350     0.150
    21.488   533.350     0.150
    21.855   291.350     0.150
    23.664   309.350     0.150
    24.242   315.350     0.150
    25.278   326.350     0.150
    29.483   364.350     0.150
    29.483   658.350     0.150
    29.681   363.350     0.150
    30.253   369.350     0.150
    31.000   378.350     0.150
    31.000   676.350     0.150
    31.117   377.350     0.150
    31.117   681.350     0.150
    31.958   386.350     0.150
    37.832   436.350     0.150
    37.832   797.350     0.150
    38.698   444.850     0.150
    39.184   446.350     0.150
    39.184   537.350     0.150
    39.184   805.350     0.150
    39.184   971.350     0.150
    39.683   451.350     0.150
    39.683   812.350     0.150
    39.905   453.350     0.150
    42.720   477.350     0.150
    42.720   585.350     0.150
    42.720   861.350     0.150
    42.720  1073.350     0.150
    42.793   477.350     0.150
    43.053   479.350     0.150
    43.053   862.350     0.150
    43.735   483.350     0.150
    44.160   490.450     0.150
    44.774   492.350     0.150
    44.774   886.350     0.150
    44.774  1085.350     0.150
    45.132   493.350     0.150
    45.795   499.350     0.150
    45.795   903.350     0.150
    46.288   505.450     0.150
    46.430   505.350     0.150
    46.430   912.350     0.150
    46.430  1099.350     0.150
    46.714   507.350     0.150
    47.127   511.350     0.150
    47.127   625.350     0.150
    47.127   921.350     0.150
    47.523   514.350     0.150
    47.523   928.350     0.150
    47.704   515.350     0.150
    47.704     7.000     0.150
    47.704   605.350     0.150
    47.704   926.350     0.150
    47.704  1105.350     0.150
    47.704  1139.350     0.150
    48.112   517.850     0.150
    48.468   520.350     0.150
    48.468   942.350     0.150
    48.817   524.650     0.150
    48.817   639.350     0.150
    48.817   946.350     0.150
    48.985   525.150     0.150
    49.128   526.350     0.150
    49.163   525.350     0.150
    49.163   608.350     0.150
    49.163  1151.350     0.150
    49.730   533.350     0.150
    49.790   531.550     0.150
    49.790   959.350     0.150
    50.195   536.050     0.150
    50.320   535.350     0.150
    50.477   536.550     0.150
    50.477   968.350     0.150
    50.988   541.350     0.150
    51.039   540.150     0.150
    51.389   543.050     0.150
    51.389   985.350     0.150
    51.555   545.350     0.150
    51.555   984.350     0.150
    51.838   546.750     0.150
    51.936   548.350     0.150
    52.561   999.350     0.150
    52.626   553.450     0.150
    52.626   997.350     0.150
    53.252   557.350     0.150
    53.431   561.050     0.150
    53.431  1007.350     0.150
    53.454   559.450     0.150
    53.454  1012.350     0.150
    53.454   683.350     0.150
    53.495   559.350     0.150
    53.495  1010.350     0.150
    53.611   557.350     0.150
    53.611  1011.350     0.150
    53.847   561.050     0.150
    53.847   691.350     0.150
    53.945   561.950     0.150
    54.094   563.350     0.150
    54.262   565.350     0.150
    54.262  1019.350     0.150
    54.373   566.350     0.150
    54.373  1021.350     0.150
    54.380   566.350     0.150
    54.380  1024.350     0.150
    55.083   570.450     0.150
    55.083  1032.350     0.150
    55.083  1258.350     0.150
    56.163   579.550     0.150
    56.163  1047.350     0.150
    56.639   583.650     0.150
    56.639  1057.350     0.150
    57.201   586.350     0.150
    58.203   589.350     0.150
    58.203  1073.350     0.150
    58.429   594.350     0.150
    58.454   595.250     0.150
    58.454     6.100     0.150
    58.456   597.350     0.150
    58.545   596.350     0.150
    58.907   598.350     0.150
    58.907  1085.350     0.150
    58.907  1322.350     0.150
    58.927  1091.350     0.150
    60.474   607.650     0.150
    61.606   615.350     0.150
    61.606  1126.350     0.150
    61.671   617.350     0.150
    61.671  1113.350     0.150
    62.239   620.050     0.150
    62.437   621.350     0.150
    62.466   622.250     0.150
    62.772   623.250     0.150
    63.096   626.350     0.150
    64.214   633.350     0.150
    66.133   647.350     0.150
    66.334   646.350     0.150
    66.507   650.250     0.150
    66.774   650.350     0.150
    67.602   655.350     0.150
    67.602  1193.350     0.150
    68.246   661.350     0.150
    70.315   670.850     0.150
    72.571   684.850     0.150
    72.571   704.350     0.150
    73.321   688.350     0.150
    75.032   700.350     0.150
    75.032  1263.350     0.150
    78.350   718.950     0.150
    78.289   718.350     0.150
    80.217   729.350     0.150
    80.502   730.250     0.150
    84.734   752.350     0.150
    87.106   763.350     0.150
    88.193   770.850     0.150
    89.585   775.950     0.150
    90.596   780.750     0.150
    91.497   785.650     0.150
    91.497  1441.350     0.150
    96.300   807.350     0.150
    98.159   815.350     0.150
    99.000   818.350     0.150
   103.803   841.350     0.150
   109.121   867.850     0.150
   109.239   866.150     0.150
   109.458   867.350     0.150
   113.078  1117.350     0.150
   115.117  1120.350     0.150
   115.164  1121.350     0.150
   115.665   896.350     0.150
   115.665  1121.350     0.150
   115.665  1774.350     0.150
   117.158  1124.150     0.150
   118.271  1125.350     0.150
   128.979  1148.350     0.150
   148.301  1183.350     0.150
   151.038  1188.650     0.150
   151.323  1189.450     0.150
   152.377  1186.350     0.150
     2.514    44.047     0.150
     3.380    52.445     0.150
     3.380    90.047     0.150
     6.965   104.148     0.150
     6.965   183.047     0.150
     9.153   131.047     0.150
     9.153   229.047     0.150
     9.820   141.047     0.150
     9.820   248.047     0.150
    10.608   148.844     0.150
    10.951   277.047     0.150
    12.090   169.547     0.150
    12.090   299.047     0.150
    12.285   175.047     0.150
    12.285   302.047     0.150
    12.284   175.047     0.150
    12.682   178.047     0.150
    12.852   184.047     0.150
    12.983   184.047     0.150
    12.945   184.047     0.150
    12.945   323.047     0.150
    13.312   186.047     0.150
    13.760   195.047     0.150
    13.982   197.047     0.150
    14.893   207.047     0.150
    14.893   363.047     0.150
    15.091   209.047     0.150
    16.692   228.047     0.150
    19.690   267.047     0.150
    19.690   283.047     0.150
    19.716   269.047     0.150
    20.384   279.047     0.150
    20.384   503.047     0.150
    20.567   280.047     0.150
    20.629   279.047     0.150
    20.629   507.047     0.150
    21.126   287.047     0.150
    21.126   528.047     0.150
    22.260   298.047     0.150
    24.616   320.047     0.150
    27.414   348.047     0.150
    27.414   389.047     0.150
    27.414   703.047     0.150
    28.332   412.047     0.150
    28.332   643.047     0.150
    29.718   367.047     0.150
    29.718   672.047     0.150
    29.727   367.047     0.150
    29.888   369.047     0.150
    30.745   376.047     0.150
    30.566   374.047     0.150
    30.566   676.047     0.150
    31.402   383.047     0.150
    31.561   382.344     0.150
    31.403   382.047     0.150
    32.362   392.047     0.150
    32.362   705.047     0.150
    35.417   416.047     0.150
    36.210   425.844     0.150
    36.210   768.047     0.150
    36.202   423.047     0.150
    38.666   445.750     0.150
    38.666   969.047     0.150
    38.824   446.445     0.150
    39.089   448.047     0.150
    39.089   543.047     0.150
    39.089   810.047     0.150
    39.598   452.047     0.150
    39.585   454.047     0.150
    39.585   542.047     0.150
    39.585   815.047     0.150
    40.053   456.047     0.150
    40.053   819.047     0.150
    40.310   458.047     0.150
    41.693   471.047     0.150
    41.693   849.047     0.150
    42.527   477.047     0.150
    42.527   819.047     0.150
    42.527   859.047     0.150
    43.198   482.750     0.150
    43.452   484.047     0.150
    44.139   489.047     0.150
    44.430   595.047     0.150
    44.322   491.047     0.150
    45.133   496.047     0.150
    45.133   604.047     0.150
    45.133  1087.047     0.150
    45.124   496.047     0.150
    45.124   897.047     0.150
    45.957   504.750     0.150
    46.824   510.047     0.150
    46.824   918.047     0.150
    47.031   511.047     0.150
    47.530   516.047     0.150
    47.530   630.047     0.150
    47.726   517.047     0.150
    47.726   632.047     0.150
    47.726   932.047     0.150
    47.868   517.047     0.150
    47.919   519.047     0.150
    48.063   519.047     0.150
    48.063   633.047     0.150
    48.063   937.047     0.150
    48.063  1151.047     0.150
    48.745   524.547     0.150
    49.127   528.648     0.150
    49.127     6.398     0.150
    49.127   954.047     0.150
    49.127  1167.047     0.150
    49.223   529.344     0.150
    49.223   951.047     0.150
    49.239   527.047     0.150
    49.310   528.750     0.150
    49.310   634.047     0.150
    49.438   528.844     0.150
    49.438   528.844     0.150
    49.474   532.047     0.150
    49.474   644.047     0.150
    49.474  1165.047     0.150
    49.659   532.945     0.150
    50.084   538.047     0.150
    50.128   537.047     0.150
    50.102   535.945     0.150
    50.102     5.102     0.150
    50.102   646.047     0.150
    50.163   962.047     0.150
    50.163  1122.047     0.150
    50.245   539.047     0.150
    50.598   541.047     0.150
    50.598     5.000     0.150
    50.823   540.750     0.150
    51.385   546.047     0.150
    51.403   544.844     0.150
    51.716   546.945     0.150
    51.779   548.047     0.150
    51.779   992.047     0.150
    51.876   548.547     0.150
    51.876   623.047     0.150
    51.876   668.047     0.150
    52.150   551.148     0.150
    52.215   550.047     0.150
    52.215     6.000     0.150
    52.717   554.445     0.150
    52.717   619.047     0.150
    52.955   557.047     0.150
    53.020   559.047     0.150
    53.020   676.047     0.150
    53.020  1006.047     0.150
    53.325   559.047     0.150
    53.325   672.047     0.150
    53.325  1013.047     0.150
    53.437   557.047     0.150
    53.647   561.445     0.150
    53.786   627.047     0.150
    53.845   563.047     0.150
    53.845     6.000     0.150
    53.845   626.047     0.150
    53.845   688.047     0.150
    53.896   563.047     0.150
    53.896  1019.047     0.150
    53.864   565.047     0.150
    53.991   565.047     0.150
    53.991   690.047     0.150
    54.219   564.945     0.150
    54.295   566.750     0.150
    54.665   568.047     0.150
    54.773     3.000     0.150
    54.773   691.047     0.150
    54.773  1029.047     0.150
    54.757   573.047     0.150
    54.757  1035.047     0.150
    54.820   570.047     0.150
    54.820     6.000     0.150
    54.820   630.047     0.150
    54.820   691.047     0.150
    54.820  1043.047     0.150
    55.244  1040.047     0.150
    55.270     7.000     0.150
    55.397   576.047     0.150
    55.397  1039.047     0.150
    55.449   574.945     0.150
    55.449     3.102     0.150
    55.449  1042.047     0.150
    55.785   579.047     0.150
    55.785  1043.047     0.150
    56.558   582.250     0.150
    57.033   588.047     0.150
    57.523   591.047     0.150
    57.523  1075.047     0.150
    57.531   591.047     0.150
    57.563   590.945     0.150
    57.563     6.102     0.150
    57.563   640.047     0.150
    58.713   597.344     0.150
    59.015   600.250     0.150
    59.015  1085.047     0.150
    58.829   598.750     0.150
    58.855   598.945     0.150
    58.943   599.047     0.150
    59.299     6.297     0.150
    59.318   601.047     0.150
    59.630   603.547     0.150
    59.679   603.047     0.150
    60.356   607.547     0.150
    60.637   609.945     0.150
    60.871   611.750     0.150
    60.871   653.047     0.150
    60.871   743.047     0.150
    61.210   617.547     0.150
    61.857   618.750     0.150
    62.633   623.844     0.150
    62.827   625.344     0.150
    62.814   625.047     0.150
    62.843   625.750     0.150
    62.843     3.297     0.150
    63.245   764.047     0.150
    63.245  1141.047     0.150
    63.166   627.445     0.150
    63.811   630.047     0.150
    63.984   632.547     0.150
    66.560   648.047     0.150
    66.960   650.047     0.150
    66.856   652.047     0.150
    66.856     3.000     0.150
    66.856  1188.047     0.150
    66.966   651.547     0.150
    67.836   657.047     0.150
    69.963   670.047     0.150
    70.758   677.047     0.150
    70.758   698.047     0.150
    70.758   836.047     0.150
    70.758  1237.047     0.150
    70.758  1278.047     0.150
    70.758  1509.047     0.150
    71.359   678.547     0.150
    71.359  1233.047     0.150
    71.217   680.047     0.150
    71.525   678.047     0.150
    71.497   679.445     0.150
    73.486   691.750     0.150
    74.632   700.648     0.150
    74.632  1275.047     0.150
    74.820   698.547     0.150
    75.968   709.344     0.150
    75.780   705.844     0.150
    75.844   706.344     0.150
    76.897   712.047     0.150
    76.897     4.000     0.150
    77.811   719.047     0.150
    78.590   722.047     0.150
    78.590   734.047     0.150
    78.590   905.047     0.150
    78.590  1323.047     0.150
    78.359   719.047     0.150
    80.097   728.750     0.150
    80.097  1330.047     0.150
    81.971   738.047     0.150
    83.717   747.047     0.150
    84.346   752.047     0.150
    84.346  1373.047     0.150
    85.276   758.047     0.150
    86.207   760.047     0.150
    87.258   765.047     0.150
    89.181   776.250     0.150
    89.595   780.047     0.150
    89.595  1430.047     0.150
    90.206   781.047     0.150
    91.101   785.047     0.150
    91.101  1418.047     0.150
    91.289   785.047     0.150
    91.683   788.047     0.150
    91.683  1425.047     0.150
    93.330   798.047     0.150
    93.691   797.648     0.150
    93.354   795.047     0.150
    94.568   797.648     0.150
    95.393   806.047     0.150
    96.453   809.047     0.150
    96.453  1441.047     0.150
    96.442   808.047     0.150
    98.007   816.344     0.150
    99.181   823.047     0.150
   101.104   835.047     0.150
   109.346  1113.047     0.150
   109.346  1140.047     0.150
   109.346  1775.047     0.150
   111.280  1113.047     0.150
   111.280  1509.047     0.150
   113.752  1118.648     0.150
   115.289  1123.047     0.150
   115.865  1122.250     0.150
   117.284  1126.047     0.150
   117.996  1125.047     0.150
   119.592  1128.047     0.150
   119.592  1552.047     0.150
   120.090  1128.047     0.150
   120.090  1135.047     0.150
   125.839  1144.047     0.150
   129.363  1146.047     0.150
   129.363  1279.047     0.150
   138.216  1167.047     0.150
   138.216  1384.047     0.150
   144.642  1177.547     0.150
   144.642  1369.047     0.150
   147.474  1182.547     0.150
   148.698  1185.445     0.150
   148.698  1401.047     0.150
   148.698  2543.047     0.150
   148.872  1185.047     0.150
   148.872  1401.047     0.150
   151.439  1191.047     0.150
   151.439  1413.047     0.150
   151.727  1192.648     0.150
   152.778  1188.047     0.150
   153.706  1194.047     0.150
   153.706  1198.047     0.150
   153.706  1425.047     0.150
     1.072    35.262     0.150
     2.581    41.262     0.150
     2.581    72.262     0.150
     2.581    79.262     0.150
     4.349    76.262     0.150
     5.359    79.762     0.150
     7.612   105.262     0.150
     7.612   191.262     0.150
    10.646   148.562     0.150
    11.620   162.262     0.150
    13.000   178.262     0.150
    13.095   179.262     0.150
    13.095   317.262     0.150
    12.759   182.262     0.150
    20.289   273.262     0.150
    23.145   303.262     0.150
    28.479   352.262     0.150
    29.319   361.262     0.150
    36.229   420.262     0.150
    38.579   441.262     0.150
    43.289   480.262     0.150
    45.151   493.262     0.150
    46.340   504.262     0.150
    46.366   503.562     0.150
    46.630   505.361     0.150
    47.441   512.262     0.150
    47.649   515.262     0.150
    48.011   516.262     0.150
    48.855   522.262     0.150
    49.803   530.262     0.150
    49.949   530.762     0.150
    50.410   534.162     0.150
    51.386   542.262     0.150
    52.072   547.262     0.150
    52.287   549.262     0.150
    53.210   555.262     0.150
    53.380   556.262     0.150
    53.689   560.262     0.150
    53.989   561.062     0.150
    57.757   589.262     0.150
    60.574   605.262     0.150
    65.312   638.262     0.150
    66.246   645.262     0.150
    67.100   652.262     0.150
    69.611   666.762     0.150
    70.079   668.262     0.150
    72.953   686.262     0.150
    72.815   684.262     0.150
    76.218   706.262     0.150
    78.064   715.262     0.150
    79.690   724.262     0.150
    80.194   727.062     0.150
    81.704   736.062     0.150
    81.968   737.562     0.150
   115.046  1173.162     0.150
   147.124  1185.262     0.150
   147.294  1179.262     0.150
   149.848  1189.361     0.150
     1.655    28.088     0.150
     2.799    45.588     0.150
     2.799    49.088     0.150
     2.799    79.088     0.150
     2.799    85.088     0.150
     5.035    76.088     0.150
     5.535   145.088     0.150
     6.080    91.488     0.150
     8.268   212.088     0.150
    10.128   146.088     0.150
    10.128   258.088     0.150
    10.218   146.588     0.150
    11.259   159.188     0.150
    11.494   162.088     0.150
    11.494   286.088     0.150
    12.495   175.088     0.150
    12.258   304.088     0.150
    12.735   176.188     0.150
    12.473   176.088     0.150
    12.829   178.588     0.150
    12.944   180.088     0.150
    13.165   187.088     0.150
    13.165   325.088     0.150
    14.116   197.088     0.150
    14.116   345.088     0.150
    16.625   226.588     0.150
    17.063   239.088     0.150
    19.496   268.088     0.150
    20.603   279.088     0.150
    21.374   289.088     0.150
    29.915   368.088     0.150
    38.711   444.088     0.150
    39.265   448.088     0.150
    43.965   488.588     0.150
    44.348   489.787     0.150
    45.143   497.088     0.150
    47.009   511.588     0.150
    47.301   514.088     0.150
    47.301     3.000     0.150
    48.078   519.988     0.150
    48.078     5.100     0.150
    48.367   523.088     0.150
    48.483   523.588     0.150
    48.621   524.088     0.150
    48.630   524.088     0.150
    49.128   527.088     0.150
    49.453   531.088     0.150
    50.091   535.287     0.150
    50.627   538.787     0.150
    51.032   542.488     0.150
    51.335   546.088     0.150
    52.054   550.088     0.150
    52.454   553.088     0.150
    52.790   556.088     0.150
    53.001   557.088     0.150
    53.925   564.088     0.150
    54.053   564.088     0.150
    54.270   567.088     0.150
    54.409   568.088     0.150
    54.409     5.000     0.150
    54.670   569.988     0.150
    56.434   581.988     0.150
    57.960   592.488     0.150
    58.452   597.588     0.150
    59.495   602.588     0.150
    59.776   604.588     0.150
    60.011   606.287     0.150
    61.348   615.889     0.150
    61.781   618.688     0.150
    61.977   619.389     0.150
    62.006   620.188     0.150
    62.035   620.088     0.150
    62.314   622.088     0.150
    63.540   632.287     0.150
    65.985   645.088     0.150
    66.110   646.088     0.150
    70.285   673.088     0.150
    70.329   674.088     0.150
    71.361   679.688     0.150
    72.231   684.588     0.150
    73.162   689.787     0.150
    73.173   689.088     0.150
    75.380   703.088     0.150
    78.236   719.688     0.150
    78.259   719.488     0.150
    78.285   719.889     0.150
    78.523   723.088     0.150
    78.743   722.287     0.150
    79.857   729.787     0.150
    79.882   728.287     0.150
    80.356   730.889     0.150
    80.985   734.988     0.150
    80.736   733.488     0.150
    82.030   740.488     0.150
    82.582   743.488     0.150
    83.160   744.088     0.150
    85.804   758.088     0.150
    86.975   763.088     0.150
    90.675   782.088     0.150
    94.754   802.088     0.150
   115.063  1122.488     0.150
   119.973  1128.889     0.150
   147.816  1184.088     0.150
   147.989  1184.889     0.150
   150.552  1193.287     0.150
     1.183    21.689     0.150
     1.183    36.689     0.150
     2.669    42.889     0.150
     2.669    45.689     0.150
     2.669    47.689     0.150
     2.669    75.689     0.150
     2.669    79.689     0.150
     4.453    67.689     0.150
     6.146    88.689     0.150
     6.146   157.689     0.150
     6.051    90.689     0.150
     7.654   108.689     0.150
     9.593   137.189     0.150
    10.757   150.589     0.150
    11.660   164.689     0.150
    12.097   168.689     0.150
    13.000   180.689     0.150
    12.825   181.689     0.150
    13.114   180.689     0.150
    13.494   187.689     0.150
    16.978   233.189     0.150
    17.487   240.689     0.150
    18.869   257.689     0.150
    20.312   275.189     0.150
    23.254   305.889     0.150
    23.254   554.689     0.150
    28.212   352.689     0.150
    28.212   639.689     0.150
    28.374   353.689     0.150
    29.886   367.689     0.150
    32.296   390.689     0.150
    36.760   428.689     0.150
    37.461   434.689     0.150
    37.644   435.689     0.150
    37.644   784.689     0.150
    38.081   438.689     0.150
    38.071   436.689     0.150
    38.268   440.689     0.150
    38.636   443.689     0.150
    38.636   796.689     0.150
    40.084   455.489     0.150
    41.281   464.689     0.150
    41.281   838.689     0.150
    41.633   467.689     0.150
    41.944   469.689     0.150
    42.635   473.689     0.150
    43.001   479.689     0.150
    43.754   485.689     0.150
    43.752   484.689     0.150
    43.884   485.689     0.150
    44.504   491.689     0.150
    44.504     7.000     0.150
    44.662   492.089     0.150
    45.084   494.689     0.150
    45.329   497.689     0.150
    45.794   500.689     0.150
    45.794   900.689     0.150
    45.937   501.689     0.150
    46.408   505.289     0.150
    46.408     9.400     0.150
    46.408   911.689     0.150
    46.682   507.789     0.150
    46.682   914.689     0.150
    46.682  1100.689     0.150
    47.481   512.689     0.150
    47.481    10.000     0.150
    47.481   621.689     0.150
    47.725   516.789     0.150
    48.003   516.689     0.150
    47.979   518.689     0.150
    47.979     5.000     0.150
    47.979   632.689     0.150
    48.046   518.089     0.150
    48.724   522.689     0.150
    48.884   524.989     0.150
    48.884     9.700     0.150
    48.884   946.689     0.150
    49.484   529.089     0.150
    49.484   953.689     0.150
    49.881   532.189     0.150
    50.003   532.089     0.150
    50.003   960.689     0.150
    50.401   536.489     0.150
    50.446   536.389     0.150
    50.446   966.689     0.150
    50.877   540.689     0.150
    50.877   974.689     0.150
    51.461   544.389     0.150
    51.461   662.689     0.150
    51.461   982.689     0.150
    51.477   544.289     0.150
    51.477     9.400     0.150
    51.526   545.689     0.150
    51.526     6.000     0.150
    51.814   546.689     0.150
    52.148   548.689     0.150
    52.148   664.689     0.150
    52.323   551.689     0.150
    52.359   550.689     0.150
    52.542   553.289     0.150
    52.542  1000.689     0.150
    53.283   557.689     0.150
    53.628   561.789     0.150
    53.767   562.689     0.150
    53.767     5.000     0.150
    53.880   562.689     0.150
    55.060   570.689     0.150
    55.536   575.689     0.150
    55.707   575.689     0.150
    55.918   576.889     0.150
    56.024   577.689     0.150
    56.045   579.689     0.150
    56.168   578.689     0.150
    56.323   580.689     0.150
    57.202   584.989     0.150
    57.810   591.289     0.150
    57.810  1071.689     0.150
    58.163   593.089     0.150
    58.853   596.789     0.150
    59.134   598.989     0.150
    60.611  1119.689     0.150
    60.667   608.689     0.150
    60.852   610.989     0.150
    61.139   612.689     0.150
    61.335   613.689     0.150
    61.672   616.189     0.150
    62.773   622.689     0.150
    62.773     7.000     0.150
    62.904   626.289     0.150
    65.328   640.689     0.150
    65.229   640.689     0.150
    65.229  1168.689     0.150
    65.648   641.689     0.150
    65.946   645.689     0.150
    66.344   645.689     0.150
    66.344     7.000     0.150
    68.774   661.889     0.150
    69.704   669.689     0.150
    69.704     5.000     0.150
    70.173   670.689     0.150
    70.173     6.000     0.150
    70.840   675.689     0.150
    70.840     5.000     0.150
    70.840   690.689     0.150
    71.537   679.689     0.150
    71.537   699.689     0.150
    72.871   688.189     0.150
    72.783   686.189     0.150
    72.794   685.689     0.150
    77.991   717.089     0.150
    78.016   716.689     0.150
    78.041   716.889     0.150
    78.432   718.689     0.150
    79.771   727.189     0.150
    79.642   725.389     0.150
    79.682   726.689     0.150
    80.512   730.789     0.150
    81.302   733.689     0.150
    81.613   737.089     0.150
    82.078   739.689     0.150
    82.636   740.689     0.150
    85.367   754.689     0.150
    86.612   760.689     0.150
    91.691   786.689     0.150
    91.691    10.000     0.150
   102.939   841.389     0.150
   114.733  1120.889     0.150
   120.394  1128.389     0.150
   147.226  1182.689     0.150
   147.396  1182.589     0.150
   149.948  1191.389     0.150
   150.210  1191.689     0.150
   150.210  1199.689     0.150
     1.993    35.570     0.150
     1.993    60.570     0.150
     3.032    47.969     0.150
     3.032    81.570     0.150
     3.645    57.969     0.150
     3.645   108.469     0.150
    10.346   150.570     0.150
    10.559   149.469     0.150
    11.149   156.570     0.150
    11.757   166.672     0.150
    11.910   168.672     0.150
    11.910   298.070     0.150
    12.170   168.969     0.150
    12.655   175.570     0.150
    12.659   175.070     0.150
    12.878   178.172     0.150
    12.878   318.570     0.150
    12.785   179.367     0.150
    13.021   180.570     0.150
    13.428   188.570     0.150
    13.412   188.570     0.150
    13.577   190.570     0.150
    14.398   199.570     0.150
    14.398   351.570     0.150
    14.565   200.570     0.150
    14.565   357.172     0.150
    16.562   225.469     0.150
    16.946   229.570     0.150
    18.262   253.070     0.150
    18.538   460.570     0.150
    18.825   260.070     0.150
    19.837   270.867     0.150
    20.020   273.570     0.150
    20.358   275.469     0.150
    20.445   277.570     0.150
    20.445   498.570     0.150
    20.442   276.570     0.150
    20.590   278.570     0.150
    20.590   503.570     0.150
    21.279   286.570     0.150
    21.641   291.570     0.150
    21.713   290.570     0.150
    21.713   528.570     0.150
    23.450   307.570     0.150
    23.450   558.570     0.150
    23.614   564.570     0.150
    24.110   315.070     0.150
    24.528   318.570     0.150
    24.528   576.570     0.150
    24.699   321.367     0.150
    24.885   321.570     0.150
    25.459   325.570     0.150
    26.310   337.570     0.150
    26.310   609.570     0.150
    26.501   338.570     0.150
    26.651   339.672     0.150
    26.867   342.570     0.150
    27.803   348.969     0.150
    27.803   625.070     0.150
    28.351   352.570     0.150
    28.351   996.570     0.150
    28.354   354.773     0.150
    28.354   643.070     0.150
    29.172   361.570     0.150
    29.183   361.570     0.150
    29.341   362.172     0.150
    29.341     3.602     0.150
    29.341   652.969     0.150
    29.341   361.367     0.150
    29.341   654.570     0.150
    29.539   364.570     0.150
    29.539   656.570     0.150
    29.662   365.070     0.150
    29.662   658.570     0.150
    30.142   369.570     0.150
    30.517   374.570     0.150
    30.517   675.570     0.150
    30.523   373.367     0.150
    30.523     6.000     0.150
    30.823   377.570     0.150
    30.823   680.570     0.150
    30.855   377.570     0.150
    31.407   383.570     0.150
    31.407   690.570     0.150
    31.816   386.070     0.150
    31.816   699.570     0.150
    31.816   385.969     0.150
    32.400   387.367     0.150
    32.582   702.070     0.150
    32.954   394.570     0.150
    32.954   712.570     0.150
    33.537   399.773     0.150
    34.501   409.570     0.150
    34.872   411.070     0.150
    34.872   410.969     0.150
    35.057   413.570     0.150
    35.057   743.570     0.150
    35.385   415.570     0.150
    35.842   418.672     0.150
    36.211   422.570     0.150
    38.137   438.570     0.150
    39.051   447.672     0.150
    39.186   447.570     0.150
    39.186   804.570     0.150
    39.553   450.570     0.150
    39.553     5.000     0.150
    39.553   809.570     0.150
    39.694   450.570     0.150
    39.883   453.570     0.150
    39.883   816.570     0.150
    41.333   467.172     0.150
    41.626   466.469     0.150
    41.677   467.969     0.150
    41.887   469.070     0.150
    42.186   472.570     0.150
    42.186   853.070     0.150
    42.236   472.773     0.150
    42.581   475.367     0.150
    42.602   475.867     0.150
    42.602   856.570     0.150
    42.913   478.570     0.150
    42.913   861.570     0.150
    43.075   479.367     0.150
    43.285   481.570     0.150
    43.417   481.070     0.150
    43.489   481.570     0.150
    43.542   483.367     0.150
    43.557   483.070     0.150
    43.784   484.867     0.150
    43.783   484.570     0.150
    43.960   485.867     0.150
    43.972   488.570     0.150
    44.083   487.570     0.150
    44.160   487.773     0.150
    44.194   490.570     0.150
    44.296   492.570     0.150
    44.410   492.570     0.150
    44.648   492.570     0.150
    44.648   886.570     0.150
    44.725   493.570     0.150
    44.756   492.773     0.150
    44.837   494.570     0.150
    44.837   494.969     0.150
    45.135   495.969     0.150
    45.314   498.570     0.150
    45.475   498.570     0.150
    45.760   501.469     0.150
    46.309   505.570     0.150
    46.602   507.367     0.150
    46.602   913.570     0.150
    46.724   510.773     0.150
    46.794   511.570     0.150
    46.794   919.570     0.150
    46.968   511.570     0.150
    46.984   510.070     0.150
    47.304   513.367     0.150
    47.304     6.102     0.150
    47.304   628.570     0.150
    47.304   924.570     0.150
    47.383   516.070     0.150
    47.383   515.969     0.150
    47.383     5.602     0.150
    47.472   513.570     0.150
    47.578   515.570     0.150
    47.578   926.570     0.150
    47.820   517.570     0.150
    48.077   518.969     0.150
    48.173   520.570     0.150
    48.173   938.570     0.150
    48.198   519.273     0.150
    48.253   519.867     0.150
    48.331   521.570     0.150
    48.331   633.570     0.150
    48.331   937.570     0.150
    48.686   523.172     0.150
    48.689   525.570     0.150
    48.689     7.500     0.150
    48.726   521.570     0.150
    48.739   525.570     0.150
    48.891   523.867     0.150
    48.870   525.273     0.150
    48.870   525.570     0.150
    48.941   525.570     0.150
    48.941   637.570     0.150
    48.941   948.570     0.150
    49.025   525.273     0.150
    49.079   526.672     0.150
    49.136   525.969     0.150
    49.218   527.367     0.150
    49.229   527.469     0.150
    49.494   528.773     0.150
    49.587   528.570     0.150
    49.589   530.570     0.150
    49.682   530.867     0.150
    49.680   531.570     0.150
    49.680     6.102     0.150
    49.680   958.570     0.150
    49.768   530.773     0.150
    49.887   531.773     0.150
    50.355   535.969     0.150
    50.376   535.672     0.150
    50.910   540.273     0.150
    50.910   658.367     0.150
    50.910   973.969     0.150
    51.245   542.867     0.150
    51.274   542.773     0.150
    51.339   544.570     0.150
    51.367   544.570     0.150
    51.476   545.570     0.150
    51.476     5.797     0.150
    51.476   984.570     0.150
    51.551   545.570     0.150
    51.857   549.773     0.150
    51.795   547.469     0.150
    52.252   551.070     0.150
    52.287   550.969     0.150
    52.423   552.570     0.150
    52.423   998.570     0.150
    52.487   552.570     0.150
    52.751   554.969     0.150
    52.751  1002.570     0.150
    52.773   554.570     0.150
    52.784   554.672     0.150
    52.843   554.570     0.150
    52.903   555.172     0.150
    53.112   557.070     0.150
    53.112  1007.570     0.150
    53.112  1142.570     0.150
    53.112   556.969     0.150
    53.129   557.773     0.150
    53.194   557.469     0.150
    53.289   558.570     0.150
    53.289  1006.570     0.150
    53.316   557.969     0.150
    53.354   558.273     0.150
    53.354   680.570     0.150
    53.354  1009.570     0.150
    53.464   559.969     0.150
    53.478   560.570     0.150
    53.478   681.570     0.150
    53.478  1011.570     0.150
    53.569   560.570     0.150
    53.647   559.773     0.150
    53.691   559.570     0.150
    53.920   563.070     0.150
    54.093   563.570     0.150
    54.106   564.570     0.150
    54.120   564.570     0.150
    54.141   561.773     0.150
    54.169   564.070     0.150
    54.242   565.570     0.150
    54.242  1022.570     0.150
    54.590   568.867     0.150
    54.590  1031.570     0.150
    54.730   567.570     0.150
    54.730   694.570     0.150
    54.730  1022.570     0.150
    54.733   569.273     0.150
    54.784   567.969     0.150
    54.784  1024.570     0.150
    54.784  1027.570     0.150
    54.965   570.070     0.150
    54.954   569.773     0.150
    55.418   575.570     0.150
    55.418  1036.570     0.150
    55.514   575.367     0.150
    55.514  1036.070     0.150
    55.597   574.969     0.150
    55.597  1039.469     0.150
    56.024   578.469     0.150
    56.309   582.070     0.150
    56.303   580.172     0.150
    56.336   581.273     0.150
    56.571   579.570     0.150
    56.617   582.172     0.150
    56.712   582.570     0.150
    56.757   581.867     0.150
    56.877   584.367     0.150
    57.069   585.570     0.150
    57.084   586.070     0.150
    57.084     7.297     0.150
    57.287   586.773     0.150
    57.338   587.273     0.150
    57.367   586.773     0.150
    57.449   587.773     0.150
    57.449   712.570     0.150
    57.449  1062.570     0.150
    57.449  1172.570     0.150
    57.625   589.367     0.150
    57.701   589.570     0.150
    57.760   590.570     0.150
    57.761   590.867     0.150
    57.761     7.203     0.150
    57.920   591.773     0.150
    57.854   592.570     0.150
    57.972   590.367     0.150
    58.021   592.273     0.150
    58.066   590.570     0.150
    58.066  1073.570     0.150
    58.105   591.867     0.150
    58.699   596.867     0.150
    58.769   597.469     0.150
    58.769  1084.570     0.150
    58.789   598.570     0.150
    58.885   597.867     0.150
    58.963   598.969     0.150
    59.821   605.570     0.150
    59.803   604.273     0.150
    59.808   604.570     0.150
    59.812   604.570     0.150
    59.812  1090.570     0.150
    59.819   604.172     0.150
    59.971   605.672     0.150
    60.100   606.469     0.150
    60.265   607.570     0.150
    60.917   612.469     0.150
    61.151   614.273     0.150
    61.596   617.367     0.150
    61.747   617.672     0.150
    61.839   617.773     0.150
    61.871   619.172     0.150
    61.926   619.172     0.150
    61.952   619.969     0.150
    61.952   620.070     0.150
    62.101   619.867     0.150
    62.125   620.469     0.150
    62.140   621.367     0.150
    62.263   621.672     0.150
    62.287   622.469     0.150
    62.295   620.969     0.150
    62.304   621.570     0.150
    62.334   621.570     0.150
    62.498   623.469     0.150
    62.634   623.367     0.150
    62.643   623.672     0.150
    62.753   625.570     0.150
    62.809   624.672     0.150
    62.846   624.867     0.150
    63.044   625.570     0.150
    63.070   625.172     0.150
    63.070  1136.570     0.150
    63.318   627.367     0.150
    63.517   627.570     0.150
    63.875   632.469     0.150
    63.875  1146.773     0.150
    64.600   636.367     0.150
    64.606   636.672     0.150
    64.784   637.867     0.150
    65.181   639.867     0.150
    65.156   640.469     0.150
    65.389   639.570     0.150
    66.113   645.570     0.150
    66.024   646.570     0.150
    66.024  1177.570     0.150
    66.329   647.570     0.150
    66.390   649.469     0.150
    66.521  1178.570     0.150
    67.157   651.070     0.150
    67.318   654.773     0.150
    67.318  1189.570     0.150
    67.506   655.570     0.150
    67.460   655.570     0.150
    67.460  1190.570     0.150
    68.882   662.570     0.150
    68.882  1205.570     0.150
    69.100   664.570     0.150
    70.169   674.070     0.150
    70.466   673.367     0.150
    70.445   674.469     0.150
    70.671   675.570     0.150
    70.671     6.500     0.150
    70.763   677.570     0.150
    70.763   691.570     0.150
    70.763   844.070     0.150
    71.334   680.773     0.150
    71.900   682.070     0.150
    71.900   698.570     0.150
    71.908   682.070     0.150
    71.908   698.570     0.150
    72.505   686.172     0.150
    72.505   710.070     0.150
    72.844   689.070     0.150
    73.387   693.070     0.150
    73.515   693.070     0.150
    74.137   694.867     0.150
    74.505   699.070     0.150
    74.644   698.172     0.150
    75.173   702.773     0.150
    75.462   702.570     0.150
    75.462   871.570     0.150
    75.462  1281.570     0.150
    75.704   705.570     0.150
    75.718   704.570     0.150
    75.924   705.867     0.150
    77.126   712.969     0.150
    78.254   718.867     0.150
    78.264   718.867     0.150
    78.264  1314.570     0.150
    78.264   718.367     0.150
    78.902   721.773     0.150
    78.893   723.570     0.150
    79.781   727.469     0.150
    80.345   729.070     0.150
    80.644   732.070     0.150
    80.644  1336.570     0.150
    82.599   743.172     0.150
    83.353   744.867     0.150
    84.870   753.672     0.150
    84.809   753.969     0.150
    85.473   757.867     0.150
    85.803   758.570     0.150
    85.982   759.672     0.150
    87.024   764.367     0.150
    88.167   770.570     0.150
    89.062   776.773     0.150
    89.062  1431.867     0.150
    89.727   776.172     0.150
    90.612   780.773     0.150
    90.734   782.070     0.150
    90.884   783.570     0.150
    91.427   783.570     0.150
    91.637   786.273     0.150
    92.073   788.969     0.150
    95.573   803.773     0.150
    96.250   807.070     0.150
    96.759   809.570     0.150
    98.214   817.570     0.150
    99.032   819.570     0.150
    99.300   820.570     0.150
   100.508   826.570     0.150
   102.422   836.070     0.150
   110.426  1142.773     0.150
   111.372  1112.570     0.150
   112.973  1114.773     0.150
   115.642  1122.070     0.150
   115.642  1193.969     0.150
   117.113  1125.273     0.150
   118.368  1126.570     0.150
   119.857  1128.070     0.150
   121.812  1133.867     0.150
   125.306  1142.070     0.150
   128.843  1147.570     0.150
   132.289  1156.570     0.150
   135.235  1159.570     0.150
   137.538  1167.969     0.150
   137.538  1173.070     0.150
   137.707  1168.070     0.150
   147.775  1185.570     0.150
   148.048  1182.273     0.150
   148.161  1184.570     0.150
   150.464  1185.672     0.150
   150.897  1188.570     0.150
   150.897  1193.773     0.150
   151.181  1189.969     0.150
   151.181  1195.570     0.150
   152.235  1188.570     0.150
   153.006  1191.070     0.150
   153.443  1191.570     0.150
   153.602  1191.570     0.150
   153.602  1198.969     0.150
   155.150  1193.070     0.150
   155.750  1194.070     0.150
     2.311    67.965     0.150
     3.236    50.766     0.150
     4.997    91.365     0.150
     9.110   133.965     0.150
    10.020   250.266     0.150
    10.378   148.266     0.150
    10.896   153.766     0.150
    10.896   153.666     0.150
    10.816   151.266     0.150
    11.848   165.965     0.150
    12.154   170.266     0.150
    12.154   303.266     0.150
    12.536   174.066     0.150
    12.536   302.965     0.150
    12.806   314.965     0.150
    13.111   181.266     0.150
    13.111   181.666     0.150
    13.046   181.266     0.150
    13.645   191.266     0.150
    13.629   191.965     0.150
    13.829   196.266     0.150
    13.829   197.066     0.150
    14.891   206.266     0.150
    14.891   206.666     0.150
    15.018   215.766     0.150
    16.451   223.666     0.150
    18.587   256.266     0.150
    19.754   506.266     0.150
    19.926   270.766     0.150
    19.926   270.465     0.150
    20.174   272.266     0.150
    20.131   273.266     0.150
    20.176   271.266     0.150
    20.176   493.266     0.150
    20.389   277.266     0.150
    20.389   503.266     0.150
    20.528   276.266     0.150
    20.528   502.766     0.150
    20.943   281.066     0.150
    23.152   303.766     0.150
    23.736   309.865     0.150
    23.736   973.266     0.150
    23.873   310.965     0.150
    23.873   568.465     0.150
    24.298   315.266     0.150
    24.363   317.266     0.150
    25.034   321.266     0.150
    26.505   337.266     0.150
    26.629   338.566     0.150
    28.345   353.266     0.150
    28.345   354.066     0.150
    30.407   370.266     0.150
    30.407   435.766     0.150
    30.648   374.266     0.150
    30.796   374.066     0.150
    31.743   382.465     0.150
    32.153   387.266     0.150
    32.092   384.766     0.150
    34.808   408.266     0.150
    35.535   417.865     0.150
    36.210   421.266     0.150
    36.210   421.865     0.150
    37.356   432.266     0.150
    37.989   436.666     0.150
    39.388   448.266     0.150
    39.840   450.965     0.150
    39.840   542.266     0.150
    40.195   455.266     0.150
    40.579   459.766     0.150
    44.631   494.266     0.150
    44.949   493.266     0.150
    45.172   498.266     0.150
    45.133   494.766     0.150
    47.404   512.266     0.150
    47.590   513.766     0.150
    47.714   517.266     0.150
    47.781   515.965     0.150
    47.879   516.566     0.150
    49.019   526.766     0.150
    49.144   525.965     0.150
    49.144   526.266     0.150
    49.204   525.266     0.150
    49.204     6.000     0.150
    49.270   526.266     0.150
    49.270     6.600     0.150
    49.943   532.365     0.150
    50.646   537.166     0.150
    51.216   541.965     0.150
    51.549   543.965     0.150
    51.578   545.266     0.150
    51.592   544.965     0.150
    51.667   545.266     0.150
    51.667    10.000     0.150
    51.667   545.766     0.150
    51.667     9.500     0.150
    52.752   674.266     0.150
    52.752   673.766     0.150
    52.817   554.266     0.150
    53.079   555.965     0.150
    53.118   555.445     0.150
    53.209   556.365     0.150
    53.414   557.916     0.150
    53.443   558.766     0.150
    53.643   559.266     0.150
    54.472   565.365     0.150
    54.570   566.766     0.150
    54.570   629.766     0.150
    54.919   570.266     0.150
    55.411   572.066     0.150
    55.586   573.266     0.150
    55.586   574.166     0.150
    58.091   591.666     0.150
    58.353   593.266     0.150
    59.097   599.666     0.150
    59.298   599.965     0.150
    59.666   602.566     0.150
    60.135   605.066     0.150
    60.151   606.066     0.150
    60.303   606.766     0.150
    60.432   607.465     0.150
    60.597   608.566     0.150
    61.250   613.566     0.150
    61.483   615.066     0.150
    61.930   617.965     0.150
    61.950   617.666     0.150
    62.204   619.965     0.150
    62.596   622.365     0.150
    62.832   623.965     0.150
    63.713   629.266     0.150
    66.447   646.266     0.150
    66.555   647.766     0.150
    66.555     8.500     0.150
    71.566   679.066     0.150
    71.574   678.566     0.150
    73.405   690.266     0.150
    74.841   699.266     0.150
    75.372   702.266     0.150
    75.701   703.066     0.150
    78.328   717.266     0.150
    78.891   720.465     0.150
    80.307   730.566     0.150
    83.584   745.266     0.150
    87.156   763.566     0.150
    87.184   763.266     0.150
   119.995  1128.766     0.150
   148.378  1183.365     0.150
   148.491  1184.266     0.150
   151.230  1194.266     0.150
     3.163    49.969     0.150
     3.163    87.969     0.150
     4.600    69.969     0.150
     4.600   123.367     0.150
     4.646    70.469     0.150
     4.646   123.367     0.150
     4.851    73.168     0.150
     4.851   127.766     0.150
     5.078    75.168     0.150
     5.078   132.066     0.150
     5.595    86.367     0.150
     7.069   102.469     0.150
     7.250   106.668     0.150
     8.071   116.566     0.150
     8.385   120.566     0.150
     8.696   124.969     0.150
     9.092   131.168     0.150
     9.092   229.668     0.150
     9.204   134.266     0.150
     9.706   136.367     0.150
    10.921   154.168     0.150
    11.797   165.668     0.150
    11.797   295.668     0.150
    12.083   170.367     0.150
    12.083   302.367     0.150
    12.565   173.367     0.150
    12.720   178.367     0.150
    12.720   178.867     0.150
    12.867   179.168     0.150
    12.867   314.668     0.150
    12.888   179.367     0.150
    12.888   316.367     0.150
    12.888   320.367     0.150
    13.464   187.367     0.150
    13.464   333.367     0.150
    13.828   190.367     0.150
    14.613   202.367     0.150
    14.613   202.867     0.150
    15.008   209.969     0.150
    16.477   223.668     0.150
    18.432   252.168     0.150
    18.769   257.367     0.150
    19.051   262.168     0.150
    19.783   270.367     0.150
    19.783   509.367     0.150
    20.030   270.668     0.150
    20.030   272.469     0.150
    20.032   272.367     0.150
    20.232   274.367     0.150
    20.252   275.367     0.150
    20.252   275.566     0.150
    20.482   275.367     0.150
    20.482   500.266     0.150
    20.482   276.266     0.150
    20.482   293.469     0.150
    21.047   282.867     0.150
    21.246   284.969     0.150
    21.552   287.566     0.150
    22.889   304.668     0.150
    23.706   310.066     0.150
    23.865   312.867     0.150
    24.320   316.367     0.150
    24.375   316.367     0.150
    24.756   321.566     0.150
    24.756   753.668     0.150
    24.995   322.066     0.150
    24.995   583.367     0.150
    26.208   334.367     0.150
    26.512   337.367     0.150
    26.512   337.766     0.150
    26.644   338.867     0.150
    27.405   346.367     0.150
    27.510   345.566     0.150
    30.710   374.367     0.150
    30.716   373.367     0.150
    30.716   374.066     0.150
    31.155   377.566     0.150
    34.891   410.766     0.150
    36.219   421.367     0.150
    36.219   422.066     0.150
    36.347   424.168     0.150
    36.483   424.168     0.150
    37.378   432.367     0.150
    38.042   436.969     0.150
    39.770   454.367     0.150
    39.802   451.168     0.150
    39.802     7.199     0.150
    41.082   461.367     0.150
    42.465   474.266     0.150
    44.528   492.867     0.150
    44.859   493.367     0.150
    44.859     8.000     0.150
    45.069   496.367     0.150
    45.142   494.367     0.150
    45.142   892.566     0.150
    45.142   494.668     0.150
    47.506   514.367     0.150
    47.506     9.199     0.150
    47.613   517.367     0.150
    47.613     7.000     0.150
    47.613   517.867     0.150
    47.613     6.500     0.150
    47.694   515.566     0.150
    47.789   516.168     0.150
    48.052   519.969     0.150
    48.918   526.367     0.150
    49.055   526.367     0.150
    49.064   526.066     0.150
    49.192   607.367     0.150
    49.867   532.168     0.150
    50.296   534.367     0.150
    50.296   534.566     0.150
    50.560   537.266     0.150
    50.560     8.902     0.150
    51.125   541.266     0.150
    51.469   544.668     0.150
    51.492   543.367     0.150
    52.652   553.066     0.150
    52.652   553.168     0.150
    52.979   555.766     0.150
    52.979     8.801     0.150
    53.027   555.258     0.150
    53.117   556.168     0.150
    53.323   557.789     0.150
    53.629   561.367     0.150
    54.381   565.367     0.150
    54.470   567.367     0.150
    54.770   568.367     0.150
    54.770     6.000     0.150
    55.847   577.367     0.150
    55.935   576.766     0.150
    56.066   577.367     0.150
    56.899   582.969     0.150
    56.961   587.367     0.150
    57.310   587.867     0.150
    57.310     4.500     0.150
    57.531   588.367     0.150
    57.906   591.668     0.150
    57.990   591.168     0.150
    58.233   593.469     0.150
    58.251   593.066     0.150
    58.967   597.766     0.150
    60.034   604.867     0.150
    60.050   605.766     0.150
    60.201   606.469     0.150
    60.331   607.168     0.150
    60.495   608.168     0.150
    61.148   613.168     0.150
    61.381   614.766     0.150
    61.827   617.867     0.150
    61.848   617.469     0.150
    62.102   620.066     0.150
    62.730   623.969     0.150
    63.239   626.168     0.150
    66.553   648.367     0.150
    70.544   673.367     0.150
    71.442   678.566     0.150
    71.669   680.566     0.150
    71.677   679.566     0.150
    73.368   689.367     0.150
    73.899   693.367     0.150
    75.767   704.168     0.150
    77.161   712.867     0.150
    78.316   718.367     0.150
    78.316   718.469     0.150
    78.867   720.367     0.150
    80.412   732.367     0.150
    80.387   728.266     0.150
    82.802   743.566     0.150
    83.518   745.367     0.150
    87.123   763.668     0.150
    87.137   763.066     0.150
    87.151   763.367     0.150
    96.343   806.469     0.150
   148.274  1186.168     0.150
   148.387  1184.367     0.150
   148.646  1187.168     0.150
   148.916  1188.566     0.150
     0.777    14.664     0.150
     0.777    24.164     0.150
     2.533    41.266     0.150
     2.533    76.465     0.150
     5.248    79.164     0.150
     6.212    92.965     0.150
     6.484    96.766     0.150
     6.484   168.664     0.150
     6.524    96.867     0.150
     6.524   166.965     0.150
     6.444    96.367     0.150
     6.444   170.766     0.150
     6.522    98.164     0.150
     6.733   100.164     0.150
     6.733   174.367     0.150
     6.872   102.766     0.150
     7.312   108.664     0.150
    13.401   185.766     0.150
    13.401   326.266     0.150
    14.118   195.766     0.150
    17.230   234.766     0.150
    45.886   502.766     0.150
    46.038   502.766     0.150
    48.373   521.766     0.150
    49.908   533.164     0.150
    51.308   543.367     0.150
    51.391   544.367     0.150
    51.603   545.867     0.150
    51.820   547.137     0.150
    52.847   554.367     0.150
    73.544   692.066     0.150
    78.254   718.766     0.150
    86.344   761.766     0.150
     1.819    31.127     0.150
     1.819    55.328     0.150
     2.843    44.027     0.150
     2.843    53.027     0.150
     2.843    76.227     0.150
     2.843    85.027     0.150
     8.026   114.027     0.150
     8.026   200.027     0.150
     9.651   135.627     0.150
     9.586   138.527     0.150
    11.305   157.527     0.150
    11.305   276.027     0.150
    12.549   174.027     0.150
    12.585   173.027     0.150
    12.585   305.027     0.150
    12.746   176.727     0.150
    12.878   177.527     0.150
    13.278   184.027     0.150
    13.278   327.027     0.150
    13.730   188.227     0.150
    13.730   335.727     0.150
    16.482   222.227     0.150
    19.800   270.027     0.150
    20.401   275.527     0.150
    21.410   285.227     0.150
    24.720   318.627     0.150
    26.495   337.027     0.150
    48.839   523.027     0.150
    54.106   561.828     0.150
    72.028   681.027     0.150
    73.328   688.227     0.150
    78.722   718.828     0.150
    78.722   725.227     0.150
    78.722    12.199     0.150
   147.887  1180.027     0.150
   147.999  1181.027     0.150
     0.959    19.179     0.150
     0.959    32.679     0.150
     1.337    24.179     0.150
     1.337    41.379     0.150
     2.478    42.679     0.150
     2.478    77.179     0.150
     9.955   140.679     0.150
     9.955   251.179     0.150
    10.431   151.379     0.150
    12.281   173.179     0.150
    12.281   302.379     0.150
    12.863   182.179     0.150
    12.913   181.179     0.150
    12.913   321.179     0.150
    13.902   193.179     0.150
    13.902   522.179     0.150
    16.901   231.179     0.150
    19.094   262.379     0.150
    21.160   285.579     0.150
    43.720   487.179     0.150
    46.550   508.278     0.150
    46.606   508.179     0.150
    51.831   547.778     0.150
    51.915   548.679     0.150
    52.126   550.079     0.150
    52.343   551.379     0.150
    53.191   557.579     0.150
    72.865   688.179     0.150
    78.137   718.179     0.150
    78.484   719.979     0.150
     2.434    40.445     0.150
     2.503    41.047     0.150
     2.503    72.047     0.150
     4.684    70.750     0.150
     4.684   122.750     0.150
     5.610   104.750     0.150
     5.849   107.750     0.150
     5.920   109.344     0.150
     7.081   102.945     0.150
     7.124   103.648     0.150
     7.253   105.344     0.150
     7.331   106.445     0.150
     8.339   120.648     0.150
     8.339   212.648     0.150
     8.572   125.047     0.150
     8.572   217.047     0.150
     9.591   136.047     0.150
     9.615   138.047     0.150
     9.790   139.148     0.150
    10.070   142.047     0.150
    10.070   249.047     0.150
    10.108   142.047     0.150
    10.108   250.648     0.150
    10.108   142.648     0.150
    10.386   145.445     0.150
    10.386   259.750     0.150
    10.643   150.344     0.150
    10.680   151.047     0.150
    10.680   264.648     0.150
    10.794   153.047     0.150
    12.032   173.047     0.150
    12.188   172.648     0.150
    12.152   172.047     0.150
    12.152   309.750     0.150
    12.136   172.047     0.150
    12.136   309.750     0.150
    12.412   173.445     0.150
    12.412   305.547     0.150
    12.421   305.750     0.150
    13.029   181.148     0.150
    13.069   183.047     0.150
    13.069   321.047     0.150
    13.069   515.547     0.150
    13.069   727.047     0.150
    13.136   328.047     0.150
    13.622   187.547     0.150
    13.622   332.047     0.150
    14.154   196.047     0.150
    14.163   195.047     0.150
    14.163   206.047     0.150
    14.163   346.047     0.150
    14.163   523.047     0.150
    14.163   953.047     0.150
    14.185   197.047     0.150
    14.827   206.547     0.150
    16.294   231.047     0.150
    16.619   231.844     0.150
    17.414   236.047     0.150
    17.589   243.047     0.150
    17.771   243.047     0.150
    17.771   243.844     0.150
    19.368   263.148     0.150
    19.368   472.047     0.150
    19.466   267.047     0.150
    19.596   266.945     0.150
    19.596   272.547     0.150
    19.596   486.547     0.150
    20.451   276.047     0.150
    20.451   503.047     0.150
    20.762   281.047     0.150
    20.762   517.047     0.150
    22.040   293.844     0.150
    22.040   534.047     0.150
    22.043   293.547     0.150
    22.043   533.047     0.150
    22.511   297.844     0.150
    22.567   298.047     0.150
    22.567   542.547     0.150
    22.943   302.047     0.150
    23.083   305.047     0.150
    23.523   308.047     0.150
    23.641   310.047     0.150
    23.641   597.047     0.150
    24.867   321.547     0.150
    24.898   322.047     0.150
    25.362   325.750     0.150
    25.471   324.047     0.150
    25.481   327.047     0.150
    25.481   590.047     0.150
    25.481   754.648     0.150
    26.149   332.047     0.150
    26.620   337.445     0.150
    26.940   341.047     0.150
    26.937   340.445     0.150
    26.937   542.047     0.150
    27.051   342.547     0.150
    27.093   342.844     0.150
    27.093     7.406     0.150
    27.196   343.047     0.150
    27.485   345.047     0.150
    27.485   627.047     0.150
    28.284   353.047     0.150
    28.284   637.047     0.150
    28.424   353.047     0.150
    28.443   354.047     0.150
    28.443     9.000     0.150
    28.443   640.047     0.150
    28.443   402.547     0.150
    28.443   546.047     0.150
    28.494   355.844     0.150
    28.552   355.047     0.150
    28.552   645.047     0.150
    28.552   411.047     0.150
    28.614   358.047     0.150
    28.653   358.047     0.150
    28.682   356.547     0.150
    28.765   356.750     0.150
    29.029   358.344     0.150
    29.159   362.047     0.150
    29.383   362.547     0.150
    29.571   366.844     0.150
    29.571   748.047     0.150
    30.352   370.445     0.150
    31.106   376.750     0.150
    31.106   681.547     0.150
    31.108   377.047     0.150
    31.816   383.047     0.150
    32.085   387.047     0.150
    32.085   555.547     0.150
    32.085   775.047     0.150
    32.085   779.047     0.150
    32.085  1013.047     0.150
    32.328   387.047     0.150
    32.328   699.047     0.150
    32.635   393.047     0.150
    32.635   703.047     0.150
    32.635   817.047     0.150
    32.783   391.750     0.150
    32.880   392.648     0.150
    33.335   396.648     0.150
    33.584   397.047     0.150
    34.187   403.250     0.150
    34.187   562.047     0.150
    34.452   405.047     0.150
    34.454   406.047     0.150
    34.454   732.047     0.150
    34.454   485.047     0.150
    34.647   408.047     0.150
    34.647   562.445     0.150
    34.647   737.047     0.150
    34.647   785.047     0.150
    35.673   419.047     0.150
    36.178   420.547     0.150
    36.276   421.945     0.150
    36.327   422.148     0.150
    36.779   426.047     0.150
    36.779   769.047     0.150
    36.803   428.047     0.150
    36.810   426.047     0.150
    36.810   769.047     0.150
    36.810   509.047     0.150
    37.036   429.047     0.150
    37.518   432.648     0.150
    37.513   433.047     0.150
    37.513   779.047     0.150
    37.559   434.047     0.150
    37.639   434.750     0.150
    37.639     5.297     0.150
    37.773   434.750     0.150
    37.773     5.297     0.150
    37.821   435.047     0.150
    37.821   784.047     0.150
    37.821   796.047     0.150
    37.821   518.047     0.150
    37.821   937.047     0.150
    37.814   433.250     0.150
    37.884   435.250     0.150
    37.891   438.250     0.150
    38.232   440.047     0.150
    38.611   445.047     0.150
    38.809   442.750     0.150
    38.809   799.047     0.150
    38.809   573.047     0.150
    39.062   449.047     0.150
    39.217   446.547     0.150
    39.217     5.500     0.150
    39.217   575.047     0.150
    39.217   801.047     0.150
    39.386   446.047     0.150
    39.428   449.547     0.150
    39.641   450.547     0.150
    39.999   454.047     0.150
    40.087   454.547     0.150
    40.133   454.648     0.150
    40.696   458.047     0.150
    40.696   555.047     0.150
    40.696  1062.047     0.150
    40.760   459.844     0.150
    40.978   463.047     0.150
    41.307   462.047     0.150
    41.334   465.047     0.150
    41.334   835.047     0.150
    41.715   465.047     0.150
    42.162   472.047     0.150
    42.177   470.547     0.150
    42.177   470.047     0.150
    42.218   472.047     0.150
    42.218   571.047     0.150
    42.465   474.047     0.150
    42.465   852.047     0.150
    42.454   471.547     0.150
    42.508   474.547     0.150
    42.558   472.047     0.150
    42.595   478.047     0.150
    42.601   474.750     0.150
    42.607   812.047     0.150
    42.669   475.047     0.150
    42.669     6.000     0.150
    42.669   857.047     0.150
    42.958   479.047     0.150
    43.058   480.047     0.150
    43.067   479.047     0.150
    43.243   480.047     0.150
    43.582   483.250     0.150
    43.658   483.344     0.150
    43.734   481.047     0.150
    43.910   487.047     0.150
    43.910   877.047     0.150
    43.910   589.047     0.150
    44.103   488.047     0.150
    44.103   878.047     0.150
    44.103   590.047     0.150
    44.259   489.047     0.150
    44.259   489.445     0.150
    44.292   489.445     0.150
    44.334   489.047     0.150
    44.648   490.047     0.150
    44.740   493.547     0.150
    44.827   489.047     0.150
    44.827   822.047     0.150
    44.837   494.445     0.150
    44.861   492.844     0.150
    45.180   496.445     0.150
    45.180     7.398     0.150
    45.224   495.047     0.150
    45.241   495.844     0.150
    45.241   601.844     0.150
    45.432   497.148     0.150
    45.432   897.047     0.150
    45.568   498.945     0.150
    45.585   498.648     0.150
    45.590   498.445     0.150
    45.595   498.945     0.150
    45.595   895.047     0.150
    45.647   499.047     0.150
    45.920   501.047     0.150
    45.936   501.047     0.150
    46.006   501.445     0.150
    46.492   505.945     0.150
    46.495   506.648     0.150
    46.755   507.648     0.150
    46.755    10.398     0.150
    46.777   508.250     0.150
    47.147   509.547     0.150
    47.247   510.047     0.150
    47.656   515.047     0.150
    47.844   516.844     0.150
    47.844   633.047     0.150
    47.969   517.844     0.150
    48.444   521.250     0.150
    48.641   522.344     0.150
    48.703   523.047     0.150
    48.767   522.047     0.150
    48.767     7.000     0.150
    48.767   941.047     0.150
    48.767   606.547     0.150
    48.767   637.047     0.150
    48.767  1109.047     0.150
    48.889   523.047     0.150
    48.896   524.148     0.150
    48.896   944.047     0.150
    49.034   525.250     0.150
    49.161   526.844     0.150
    49.590   528.844     0.150
    49.590   955.047     0.150
    50.004   533.547     0.150
    50.236   535.148     0.150
    50.236   967.047     0.150
    50.268   536.047     0.150
    50.268   967.047     0.150
    50.390   537.047     0.150
    50.390   973.047     0.150
    50.539   537.344     0.150
    50.560   537.648     0.150
    50.564   536.844     0.150
    50.576   537.844     0.150
    50.576   660.047     0.150
    50.636   537.047     0.150
    50.777   539.047     0.150
    50.845   538.047     0.150
    50.917   539.844     0.150
    50.917   539.945     0.150
    51.000   540.547     0.150
    51.128   541.547     0.150
    51.147   540.844     0.150
    51.147   616.750     0.150
    51.147   976.047     0.150
    51.178   541.547     0.150
    51.260   542.047     0.150
    51.296   542.344     0.150
    51.296   617.547     0.150
    51.324   542.750     0.150
    51.374   543.148     0.150
    51.376   543.250     0.150
    51.376   982.047     0.150
    51.661   544.844     0.150
    51.877   547.547     0.150
    51.925   547.648     0.150
    51.998   547.445     0.150
    52.022   548.547     0.150
    52.066   548.750     0.150
    52.066   989.047     0.150
    52.175   547.750     0.150
    52.397   550.648     0.150
    52.402   551.047     0.150
    52.402   551.750     0.150
    52.670   552.547     0.150
    52.712   553.750     0.150
    52.862   553.750     0.150
    52.930   554.750     0.150
    53.182   556.047     0.150
    53.190   557.047     0.150
    53.391   558.547     0.150
    53.488   558.648     0.150
    53.600   559.047     0.150
    53.828   562.047     0.150
    53.927   561.047     0.150
    53.944   562.047     0.150
    53.992   562.547     0.150
    54.235   563.844     0.150
    54.437   565.445     0.150
    54.449   565.344     0.150
    54.475   565.047     0.150
    54.475   565.750     0.150
    54.550   566.148     0.150
    54.827   568.047     0.150
    54.918   570.047     0.150
    54.929   569.648     0.150
    55.061   570.445     0.150
    55.081   570.148     0.150
    55.074   569.445     0.150
    55.074  1029.047     0.150
    55.074   629.047     0.150
    55.074   694.047     0.150
    55.074  1041.047     0.150
    55.128   569.844     0.150
    55.141   570.344     0.150
    55.147   569.547     0.150
    55.170   570.547     0.150
    55.154   571.047     0.150
    55.327   572.047     0.150
    55.456   573.445     0.150
    55.511   573.047     0.150
    55.557   573.750     0.150
    55.618   574.047     0.150
    55.647   574.148     0.150
    55.671   574.945     0.150
    55.785   576.250     0.150
    55.821   575.648     0.150
    55.878   576.250     0.150
    56.020   577.648     0.150
    56.502   580.250     0.150
    56.593   581.648     0.150
    56.651   581.250     0.150
    56.729   582.148     0.150
    57.328   587.945     0.150
    57.624   589.445     0.150
    57.597   587.750     0.150
    57.615   587.945     0.150
    57.761   589.047     0.150
    57.895   590.148     0.150
    58.057   591.047     0.150
    58.449   593.945     0.150
    58.716   596.445     0.150
    58.941   597.945     0.150
    59.376   601.148     0.150
    59.408   600.648     0.150
    59.654   603.148     0.150
    59.790   603.344     0.150
    59.882   603.945     0.150
    59.922   603.844     0.150
    60.042   605.648     0.150
    60.057   605.148     0.150
    60.113   604.945     0.150
    60.212   606.250     0.150
    60.214   606.047     0.150
    60.264   606.750     0.150
    60.280   607.250     0.150
    60.276   606.344     0.150
    60.398   605.047     0.150
    60.398  1097.047     0.150
    60.398   745.047     0.150
    60.439   607.547     0.150
    60.448   607.445     0.150
    60.578   608.547     0.150
    60.657   608.945     0.150
    60.679   609.445     0.150
    61.088   611.648     0.150
    61.534   614.750     0.150
    62.607   622.445     0.150
    62.638   622.648     0.150
    62.844   623.945     0.150
    63.034   626.547     0.150
    63.034   625.344     0.150
    64.303   634.047     0.150
    64.279   634.945     0.150
    64.532   636.047     0.150
    64.548   636.648     0.150
    65.020   638.047     0.150
    65.031   638.648     0.150
    65.222   640.047     0.150
    65.222  1163.047     0.150
    65.636   641.047     0.150
    65.796   643.250     0.150
    65.857   643.750     0.150
    66.352   647.047     0.150
    66.352  1175.047     0.150
    66.352  1239.047     0.150
    66.584   649.047     0.150
    66.612   650.547     0.150
    66.622   651.344     0.150
    66.842   650.445     0.150
    67.294   653.047     0.150
    67.404   654.250     0.150
    67.527   654.844     0.150
    68.033   657.844     0.150
    68.214   658.250     0.150
    68.422   662.547     0.150
    69.205   664.344     0.150
    69.325   666.945     0.150
    69.609   668.047     0.150
    70.019   669.047     0.150
    70.256   672.047     0.150
    70.922   675.648     0.150
    71.140   678.047     0.150
    71.510   677.047     0.150
    72.403   683.547     0.150
    72.363   683.844     0.150
    72.832   686.047     0.150
    73.672   691.047     0.150
    73.858   692.648     0.150
    74.003   693.047     0.150
    74.127   695.148     0.150
    74.127   695.047     0.150
    74.923   698.547     0.150
    75.385   702.148     0.150
    75.622   702.047     0.150
    76.910   711.648     0.150
    77.397   714.547     0.150
    77.891   716.250     0.150
    77.891   716.250     0.150
    78.157   717.648     0.150
    78.330   719.547     0.150
    78.330   720.047     0.150
    80.075   727.750     0.150
    80.078   727.750     0.150
    80.573   731.547     0.150
    80.547   731.047     0.150
    80.669   732.250     0.150
    80.887   733.344     0.150
    81.849   736.047     0.150
    81.877   738.250     0.150
    82.893   743.844     0.150
    83.211   745.750     0.150
    86.190   759.547     0.150
    86.205   759.547     0.150
    86.216   759.047     0.150
    86.853   763.148     0.150
    87.773   768.547     0.150
    88.517   772.250     0.150
    89.243   774.047     0.150
    89.432   775.344     0.150
    90.819   782.250     0.150
    91.972   786.547     0.150
    92.819   791.047     0.150
    92.905   792.047     0.150
    93.119   793.047     0.150
    93.839   795.945     0.150
    94.269   798.148     0.150
    94.536   798.047     0.150
    98.082   814.547     0.150
   100.039   823.547     0.150
   100.671   827.648     0.150
   114.182  1119.047     0.150
   119.877  1129.047     0.150
   119.888  1129.844     0.150
   126.704  1143.047     0.150
   144.758  1175.844     0.150
   145.835  1178.750     0.150
   145.999  1180.250     0.150
   146.350  1180.047     0.150
   147.262  1180.844     0.150
   148.666  1184.047     0.150
   148.939  1190.047     0.150
   150.001  1190.344     0.150
   151.414  1193.148     0.150
   151.719  1194.047     0.150
   151.721  1194.148     0.150
   153.362  1198.047     0.150
   153.474  1198.047     0.150
   153.716  1197.547     0.150
   153.734  1198.547     0.150
   154.124  1199.047     0.150
     1.015    18.803     0.150
     1.275    23.402     0.150
     2.501    42.803     0.150
     3.572    66.402     0.150
     4.301    68.803     0.150
     5.667    85.402     0.150
     5.667   148.203     0.150
     5.785    86.203     0.150
     7.031   102.902     0.150
     7.031   181.803     0.150
     7.087   104.603     0.150
     7.828   115.103     0.150
     8.926   126.803     0.150
     9.393   136.803     0.150
    12.214   171.303     0.150
    12.214   303.803     0.150
    13.024   322.303     0.150
    14.916   217.803     0.150
    16.881   238.803     0.150
    21.330   286.603     0.150
    21.330   286.703     0.150
    21.308   287.803     0.150
    21.469   288.303     0.150
    24.291   316.203     0.150
    24.435   318.803     0.150
    25.327   325.803     0.150
    43.785   486.803     0.150
    46.445   506.803     0.150
    46.604   508.402     0.150
    46.662   508.803     0.150
    49.979   532.603     0.150
    50.453   537.803     0.150
    53.248   557.703     0.150
    56.726   583.402     0.150
    56.989   585.103     0.150
    57.196   587.503     0.150
    58.785   597.303     0.150
    58.933   598.603     0.150
    59.065   599.003     0.150
    60.112   607.303     0.150
    72.887   688.303     0.150
    72.949   689.103     0.150
    72.958   689.003     0.150
     0.982    18.160     0.150
     1.294    23.059     0.150
     2.475    42.258     0.150
     2.475    72.359     0.150
     4.276    68.859     0.150
     5.142    78.359     0.150
     5.640    85.359     0.150
     5.640   148.758     0.150
     6.746    98.961     0.150
     7.006   102.359     0.150
     7.006   182.359     0.150
     7.059   104.258     0.150
     7.797   113.961     0.150
     8.945   127.359     0.150
     9.389   136.859     0.150
     9.930   142.359     0.150
    12.243   171.359     0.150
    12.243   302.359     0.150
    12.845   182.059     0.150
    12.899   181.359     0.150
    13.018   182.359     0.150
    13.018   317.859     0.150
    13.096   185.258     0.150
    13.883   194.359     0.150
    13.883   338.359     0.150
    14.738   204.359     0.150
    14.738   214.961     0.150
    14.738   364.859     0.150
    14.934   217.559     0.150
    21.136   285.961     0.150
    21.356   287.059     0.150
    21.356   286.961     0.150
    21.500   288.859     0.150
    24.318   315.758     0.150
    24.468   319.359     0.150
    25.360   326.160     0.150
    46.434   506.660     0.150
    46.592   507.859     0.150
    46.648   508.359     0.150
    48.894   526.160     0.150
    49.464   529.660     0.150
    49.963   532.160     0.150
    50.444   537.359     0.150
    52.330   551.859     0.150
    53.178   558.359     0.150
    53.234   557.461     0.150
    53.458   561.359     0.150
    54.544   568.359     0.150
    54.639   568.359     0.150
    55.093   571.758     0.150
    55.601   575.059     0.150
    55.714   575.359     0.150
    56.608   583.160     0.150
    56.704   583.160     0.150
    56.936   585.359     0.150
    56.967   584.859     0.150
    57.172   587.160     0.150
    58.745   597.059     0.150
    58.910   598.160     0.150
    59.042   599.258     0.150
    59.205   600.461     0.150
    59.865   605.461     0.150
    69.973   671.258     0.150
    72.973   688.559     0.150
    72.981   688.559     0.150
    72.894   687.859     0.150
    78.555   720.359     0.150
    81.579   737.758     0.150
    81.679   738.559     0.150
    81.737   739.258     0.150
    81.893   739.359     0.150
     0.426     8.172     0.150
     2.145    38.367     0.150
     3.105    51.070     0.150
     3.105    87.570     0.150
     3.181    58.570     0.150
     3.814    65.273     0.150
     3.814   112.469     0.150
     5.110    77.070     0.150
     5.110   134.570     0.150
     5.110   149.172     0.150
     5.110   162.570     0.150
     5.110   166.969     0.150
     5.539    85.570     0.150
     6.184    92.367     0.150
     6.184   159.969     0.150
     6.353    95.070     0.150
     6.353   166.570     0.150
     7.007   103.070     0.150
     8.011   116.969     0.150
     8.272   120.469     0.150
     8.272   211.570     0.150
     8.633   124.570     0.150
     8.677   126.570     0.150
     8.677   221.570     0.150
     9.029   130.867     0.150
     9.269   135.367     0.150
     9.269   239.070     0.150
     9.687   138.570     0.150
     9.687   242.570     0.150
    10.277   148.570     0.150
    10.817   156.570     0.150
    10.817   273.070     0.150
    10.982   155.172     0.150
    10.982   275.570     0.150
    11.875   172.570     0.150
    11.875   297.070     0.150
    12.407   174.570     0.150
    12.407   304.367     0.150
    12.559   175.867     0.150
    12.839   181.172     0.150
    12.952   181.570     0.150
    12.952   321.570     0.150
    13.803   190.867     0.150
    13.803   335.867     0.150
    15.027   213.070     0.150
    16.468   226.570     0.150
    16.468   401.570     0.150
    18.481   254.570     0.150
    19.777   268.570     0.150
    20.088   274.570     0.150
    20.095   274.070     0.150
    20.515   278.570     0.150
    22.467   300.367     0.150
    23.313   307.773     0.150
    24.436   318.570     0.150
    24.808   322.570     0.150
    26.261   337.172     0.150
    27.457   347.969     0.150
    27.567   347.570     0.150
    30.764   377.070     0.150
    31.885   385.773     0.150
    36.537   424.969     0.150
    38.094   438.969     0.150
    44.474   492.570     0.150
    45.015   497.570     0.150
    47.035   514.570     0.150
    47.472   515.773     0.150
    47.658   517.367     0.150
    47.751   517.570     0.150
    51.084   542.273     0.150
    51.438   545.172     0.150
    53.077   557.172     0.150
    53.291   560.070     0.150
    54.523   567.672     0.150
    57.938   592.172     0.150
    58.200   593.867     0.150
    58.288   594.570     0.150
    58.419   596.367     0.150
    58.913   598.867     0.150
    59.140   600.969     0.150
    59.982   605.773     0.150
    59.998   606.172     0.150
    60.149   607.469     0.150
    60.279   608.172     0.150
    60.443   609.172     0.150
    60.836   611.969     0.150
    61.106   614.273     0.150
    61.329   615.773     0.150
    61.774   618.969     0.150
    61.796   618.469     0.150
    62.049   621.172     0.150
    62.286   621.570     0.150
    62.481   623.570     0.150
    62.677   624.969     0.150
    62.822   625.172     0.150
    71.723   681.469     0.150
    71.731   682.070     0.150
    73.370   691.570     0.150
    73.950   694.867     0.150
    78.877   722.570     0.150
    80.470   732.570     0.150
    82.738   744.969     0.150
    82.841   745.570     0.150
    87.127   765.469     0.150
    95.689   805.570     0.150
   148.212  1184.570     0.150
   148.324  1185.570     0.150
     1.006    18.965     0.150
     2.530    42.066     0.150
     2.530    70.066     0.150
     2.530    75.766     0.150
     2.536    43.965     0.150
     2.536    77.566     0.150
     5.389    81.266     0.150
     5.695    83.566     0.150
     5.695   148.566     0.150
     5.750    86.664     0.150
     5.946    89.164     0.150
     5.990    89.266     0.150
     5.909    89.266     0.150
     6.197    91.867     0.150
     6.407    95.164     0.150
     6.733   100.266     0.150
     6.984   103.465     0.150
     7.046   106.066     0.150
     7.046   180.266     0.150
     7.376   109.867     0.150
     7.389   109.465     0.150
     7.797   115.465     0.150
    12.254   171.867     0.150
    12.910   181.266     0.150
    13.083   182.266     0.150
    13.083   318.266     0.150
    14.870   217.766     0.150
    16.939   239.164     0.150
    19.041   263.066     0.150
    21.115   284.867     0.150
    21.376   287.266     0.150
    21.305   286.766     0.150
    21.498   289.266     0.150
    24.458   318.867     0.150
    25.330   326.164     0.150
    43.734   485.766     0.150
    46.542   507.465     0.150
    46.601   507.566     0.150
    53.365   558.266     0.150
    56.672   582.566     0.150
    56.935   584.465     0.150
    57.007   585.066     0.150
    57.143   586.766     0.150
    58.713   596.566     0.150
    58.879   597.965     0.150
    59.011   598.867     0.150
    59.174   599.867     0.150
    59.567   602.664     0.150
    59.835   605.066     0.150
    60.059   606.566     0.150
    72.828   688.266     0.150
    73.009   688.766     0.150
    78.489   719.766     0.150
    81.757   739.266     0.150
   146.950  1182.266     0.150
   147.064  1182.766     0.150
   147.111  1182.266     0.150
     1.027    19.468     0.150
     1.027    33.068     0.150
     1.252    23.268     0.150
     1.252    38.868     0.150
     2.500    42.468     0.150
     2.500    71.668     0.150
     5.323    80.468     0.150
     5.879    88.268     0.150
     5.925    88.468     0.150
     5.981    89.968     0.150
     6.130    90.868     0.150
     6.345    94.068     0.150
     6.794   100.168     0.150
     7.053   103.268     0.150
     8.903   128.668     0.150
     8.903   225.668     0.150
    10.353   149.668     0.150
    10.353   264.668     0.150
    12.194   170.668     0.150
    12.194   302.668     0.150
    12.853   177.668     0.150
    12.853   313.668     0.150
    12.910   181.668     0.150
    12.910   320.668     0.150
    13.008   181.668     0.150
    13.008   317.668     0.150
    13.228   185.668     0.150
    13.228   322.668     0.150
    13.888   193.668     0.150
    13.888   337.768     0.150
    14.926   217.268     0.150
    16.865   231.668     0.150
    17.490   243.668     0.150
    19.055   263.068     0.150
    20.201   276.668     0.150
    21.301   287.168     0.150
    21.451   288.168     0.150
    22.319   297.668     0.150
    24.158   316.668     0.150
    24.419   318.268     0.150
    25.318   326.568     0.150
    26.898   341.668     0.150
    30.185   371.168     0.150
    41.188   464.668     0.150
    43.808   488.668     0.150
    46.685   508.468     0.150
    48.923   526.468     0.150
    50.001   533.268     0.150
    51.421   545.368     0.150
    52.105   550.168     0.150
    53.246   558.668     0.150
    53.271   557.468     0.150
    56.330   580.568     0.150
    56.748   583.268     0.150
    57.011   585.168     0.150
    57.218   587.268     0.150
    57.266   587.608     0.150
    57.773   591.568     0.150
    58.789   597.268     0.150
    58.807   597.468     0.150
    58.955   598.768     0.150
    59.087   599.668     0.150
    59.250   600.668     0.150
    59.643   603.268     0.150
    59.911   605.768     0.150
    60.135   607.368     0.150
    60.573   610.568     0.150
    60.601   610.068     0.150
    60.851   612.568     0.150
    61.106   613.168     0.150
    61.240   614.968     0.150
    61.296   614.268     0.150
    61.477   616.668     0.150
    61.631   616.668     0.150
    61.632   616.668     0.150
    62.609   624.568     0.150
    67.012   651.768     0.150
    70.002   670.268     0.150
    72.927   688.668     0.150
    72.902   688.168     0.150
    75.142   701.268     0.150
    75.627   704.168     0.150
    81.627   738.408     0.150
    81.727   738.748     0.150
    81.941   739.988     0.150
    82.702   742.668     0.150
    86.698   761.168     0.150
    87.313   767.668     0.150
    13.008   184.696     0.150
     0.677    12.551     0.150
     1.477    26.352     0.150
     1.477    45.352     0.150
     2.609    42.451     0.150
     2.609    72.951     0.150
     4.764    72.551     0.150
     5.315    79.932     0.150
     5.367    80.570     0.150
     5.569    83.051     0.150
     5.798    86.592     0.150
     5.754    88.951     0.150
     6.337    95.150     0.150
     6.337   162.951     0.150
     6.558    98.352     0.150
     7.625   111.951     0.150
     7.625   193.951     0.150
     7.662   111.951     0.150
     7.963   115.150     0.150
     8.326   120.951     0.150
     8.326   210.951     0.150
     8.358   121.752     0.150
     9.912   144.951     0.150
    11.074   279.051     0.150
    11.651   163.451     0.150
    11.651   289.451     0.150
    11.799   165.951     0.150
    11.799   169.051     0.150
    11.799   293.650     0.150
    12.693   180.951     0.150
    18.049   251.951     0.150
    19.867   272.951     0.150
    20.741   283.150     0.150
    23.965   314.752     0.150
    25.003   323.852     0.150
    44.386   490.951     0.150
    46.827   509.451     0.150
    46.922   510.451     0.150
    47.244   512.852     0.150
    48.798   525.150     0.150
    49.828   532.252     0.150
    52.559   552.551     0.150
    52.628   554.150     0.150
    53.659   560.551     0.150
    53.832   561.752     0.150
    57.329   587.352     0.150
    57.592   589.150     0.150
    57.798   591.252     0.150
    57.807   591.352     0.150
    59.370   601.150     0.150
    59.535   602.451     0.150
    59.668   603.252     0.150
    59.831   604.451     0.150
    60.491   609.551     0.150
    60.715   610.852     0.150
    61.153   614.150     0.150
    61.687   617.252     0.150
    61.820   618.551     0.150
    62.057   620.252     0.150
    62.211   620.752     0.150
    62.423   622.852     0.150
    78.838   721.852     0.150
    82.083   740.150     0.150
    82.185   740.752     0.150
    82.397   741.951     0.150
    83.176   744.951     0.150
   147.542  1183.951     0.150
   147.654  1181.951     0.150
     2.144    36.109     0.150
     2.144    63.109     0.150
     2.940    45.812     0.150
     2.940    54.312     0.150
     2.940    79.312     0.150
     2.940    88.609     0.150
     2.940    88.312     0.150
     3.866   111.109     0.150
     4.060    62.172     0.150
     4.605    69.633     0.150
     4.666    70.148     0.150
     4.863    73.250     0.150
     5.110    76.953     0.150
     7.027   101.312     0.150
     7.284   106.211     0.150
     8.052   115.609     0.150
     8.347   119.312     0.150
     8.347   211.109     0.150
     8.369   120.109     0.150
     9.355   135.312     0.150
     9.707   139.109     0.150
    10.963   153.109     0.150
    12.160   170.008     0.150
    12.301   174.406     0.150
    12.301   305.508     0.150
    12.280   169.109     0.150
    12.280   298.109     0.150
    12.508   174.109     0.150
    12.508   175.312     0.150
    12.508   308.211     0.150
    12.566   175.109     0.150
    12.729   177.109     0.150
    12.729   176.711     0.150
    12.753   178.109     0.150
    12.921   320.109     0.150
    13.103   185.109     0.150
    13.103   326.109     0.150
    13.565   188.109     0.150
    13.565   334.609     0.150
    13.966   198.109     0.150
    14.750   204.109     0.150
    15.308   219.609     0.150
    16.188   221.109     0.150
    18.703   254.406     0.150
    18.703   468.109     0.150
    19.498   266.109     0.150
    20.025   271.812     0.150
    20.213   273.211     0.150
    20.335   274.312     0.150
    20.748   278.109     0.150
    20.748   278.812     0.150
    20.695   278.609     0.150
    20.695   513.109     0.150
    21.023   282.109     0.150
    23.381   307.109     0.150
    23.381   572.109     0.150
    23.632   309.906     0.150
    23.991   312.312     0.150
    24.553   318.109     0.150
    24.589   318.609     0.150
    26.469   336.609     0.150
    26.469     8.500     0.150
    26.945   340.109     0.150
    27.666   347.906     0.150
    27.751   347.109     0.150
    30.903   376.109     0.150
    30.903   375.711     0.150
    30.962   377.109     0.150
    36.521   423.109     0.150
    36.521   423.609     0.150
    36.742   426.312     0.150
    38.309   438.906     0.150
    40.224   455.109     0.150
    40.224   455.008     0.150
    44.574   491.109     0.150
    45.112   496.109     0.150
    45.112   497.109     0.150
    47.602   514.211     0.150
    47.934   516.508     0.150
    49.249   526.812     0.150
    49.475   528.711     0.150
    49.475     9.297     0.150
    49.489   528.109     0.150
    50.064   533.109     0.150
    50.458   536.109     0.150
    50.458     9.898     0.150
    50.458     7.000     0.150
    50.721   538.211     0.150
    51.652   544.609     0.150
    52.727   553.609     0.150
    53.060   555.711     0.150
    53.255   556.312     0.150
    53.255    11.195     0.150
    53.354   557.711     0.150
    53.412   557.609     0.150
    53.412     7.500     0.150
    54.353   564.312     0.150
    54.353   563.406     0.150
    54.524   565.312     0.150
    54.526   566.508     0.150
    54.893   569.812     0.150
    54.893   567.609     0.150
    55.243   572.508     0.150
    55.991   576.711     0.150
    55.991   576.508     0.150
    56.106   577.008     0.150
    57.465   585.852     0.150
    57.585   588.711     0.150
    57.650   585.852     0.150
    57.767   588.406     0.150
    57.960   591.312     0.150
    57.977   591.078     0.150
    58.239   591.797     0.150
    58.268   593.328     0.150
    58.288   593.609     0.150
    58.302   591.586     0.150
    58.319   592.102     0.150
    58.381   592.719     0.150
    58.474   593.133     0.150
    58.615   594.969     0.150
    58.666   595.609     0.150
    60.114   604.906     0.150
    62.640   622.406     0.150
    66.854   650.109     0.150
    71.621   678.109     0.150
    71.621   679.109     0.150
    71.738   680.812     0.150
    71.630   679.109     0.150
    73.835   692.109     0.150
    73.837   692.109     0.150
    76.066   706.211     0.150
    78.615   720.406     0.150
    78.967   722.211     0.150
    79.158   722.109     0.150
    80.687   731.906     0.150
   148.223  1183.109     0.150
   148.333  1184.109     0.150
     0.762    13.227     0.150
     1.727    30.727     0.150
     2.135    37.523     0.150
     2.135    66.727     0.150
     2.474    42.727     0.150
     2.474    75.227     0.150
     5.357    81.227     0.150
     5.501    84.625     0.150
     5.797    87.125     0.150
     6.331    94.727     0.150
     6.354    94.125     0.150
     6.397    94.930     0.150
     6.575    97.828     0.150
     6.575   169.727     0.150
     6.596    95.328     0.150
     6.604    97.727     0.150
     6.811   101.125     0.150
     6.982   104.227     0.150
     6.982   180.727     0.150
     7.413   110.430     0.150
     9.006   130.430     0.150
     9.039   131.727     0.150
     9.228   129.328     0.150
    10.136   144.227     0.150
    10.301   147.430     0.150
    10.301   262.930     0.150
    10.749   154.328     0.150
    10.765   152.227     0.150
    10.891   157.328     0.150
    11.330   159.727     0.150
    11.330   160.227     0.150
    11.432   158.727     0.150
    11.820   167.727     0.150
    11.820   296.727     0.150
    12.506   178.727     0.150
    12.533   179.227     0.150
    12.533   317.727     0.150
    12.517   179.227     0.150
    12.517   317.727     0.150
    12.579   179.727     0.150
    12.657   176.328     0.150
    12.969   180.727     0.150
    12.969   180.930     0.150
    13.043   321.727     0.150
    13.109   183.727     0.150
    13.109   326.727     0.150
    13.280   184.023     0.150
    14.028   194.727     0.150
    14.028   204.727     0.150
    14.832   208.328     0.150
    14.832   208.492     0.150
    17.020   236.727     0.150
    18.101   244.727     0.150
    18.315   252.727     0.150
    18.315   447.727     0.150
    19.224   263.328     0.150
    19.664   268.523     0.150
    20.192   275.727     0.150
    20.192   499.727     0.150
    20.651   279.727     0.150
    20.651   509.727     0.150
    20.651   533.727     0.150
    21.438   287.523     0.150
    21.438   520.727     0.150
    21.557   289.523     0.150
    21.557   523.727     0.150
    21.557   289.844     0.150
    21.784   291.227     0.150
    21.784   291.359     0.150
    21.877   292.227     0.150
    21.877   292.469     0.150
    22.199   561.727     0.150
    22.714   301.727     0.150
    22.798   301.727     0.150
    23.134   305.727     0.150
    23.137   305.523     0.150
    23.137   556.727     0.150
    23.646   311.727     0.150
    23.773   313.727     0.150
    23.956   315.328     0.150
    24.034   315.930     0.150
    24.039   316.430     0.150
    24.148   315.727     0.150
    24.638   323.727     0.150
    24.745   318.727     0.150
    24.820   322.125     0.150
    24.820   581.727     0.150
    25.255   326.727     0.150
    25.347   329.727     0.150
    25.521   593.727     0.150
    25.613   328.523     0.150
    25.613   594.727     0.150
    25.613   602.727     0.150
    25.828   333.328     0.150
    26.094   333.523     0.150
    26.282   336.727     0.150
    26.282   600.727     0.150
    26.343   336.727     0.150
    26.482   337.523     0.150
    26.560   338.625     0.150
    26.823   340.727     0.150
    26.823   617.727     0.150
    27.089   343.727     0.150
    27.089   539.727     0.150
    27.089   622.727     0.150
    27.238   344.227     0.150
    27.654   348.727     0.150
    27.672   631.227     0.150
    28.018   351.727     0.150
    28.018   638.727     0.150
    28.287   354.125     0.150
    28.287     8.102     0.150
    28.467   355.523     0.150
    28.467   415.727     0.150
    28.467   645.727     0.150
    28.467   725.727     0.150
    28.566   355.430     0.150
    28.983   360.727     0.150
    28.983   411.727     0.150
    29.005   361.727     0.150
    29.040   649.727     0.150
    29.199   362.227     0.150
    29.199     8.000     0.150
    29.199   419.727     0.150
    29.199   654.727     0.150
    29.199   662.727     0.150
    29.325   363.227     0.150
    29.325   362.977     0.150
    29.333   363.727     0.150
    29.339   364.125     0.150
    29.339     8.602     0.150
    29.339   655.523     0.150
    29.378   364.125     0.150
    29.378     8.602     0.150
    29.378   418.727     0.150
    29.824   367.727     0.150
    29.824   653.727     0.150
    30.104   369.227     0.150
    30.104     4.500     0.150
    30.104   422.727     0.150
    30.104   666.727     0.150
    30.396   371.727     0.150
    30.522   374.227     0.150
    30.522   673.727     0.150
    31.072   377.727     0.150
    31.072   681.727     0.150
    31.072   784.727     0.150
    31.119   379.625     0.150
    31.119   682.727     0.150
    31.264   380.227     0.150
    31.264   683.727     0.150
    31.317   380.828     0.150
    31.317   688.430     0.150
    31.317   380.711     0.150
    31.654   383.023     0.150
    31.654   690.727     0.150
    31.664   384.227     0.150
    31.664   693.727     0.150
    31.664   384.438     0.150
    32.194   391.727     0.150
    32.291   389.125     0.150
    32.658   391.727     0.150
    32.658   705.328     0.150
    32.658   392.023     0.150
    32.980   396.727     0.150
    33.171   395.727     0.150
    33.358   399.727     0.150
    33.358   717.727     0.150
    33.358   473.727     0.150
    33.499   398.828     0.150
    33.499     5.898     0.150
    33.628   400.727     0.150
    34.092   404.328     0.150
    34.092   728.727     0.150
    34.970   412.227     0.150
    35.175   413.227     0.150
    35.175   740.727     0.150
    35.537   416.727     0.150
    35.537   749.727     0.150
    35.800   420.125     0.150
    35.832   419.727     0.150
    35.873   420.953     0.150
    35.873     8.273     0.150
    35.873   494.773     0.150
    35.873   759.500     0.150
    35.873   767.773     0.150
    35.873   920.219     0.150
    35.960   421.023     0.150
    36.215   423.227     0.150
    36.274   422.930     0.150
    36.370   424.727     0.150
    36.382   424.727     0.150
    36.385   424.727     0.150
    36.385   507.727     0.150
    36.385   765.727     0.150
    36.404   424.227     0.150
    36.457   424.828     0.150
    36.489   426.523     0.150
    36.500   425.328     0.150
    36.638   427.430     0.150
    36.658   427.727     0.150
    36.754   428.125     0.150
    36.828   428.727     0.150
    36.970   429.523     0.150
    37.093   428.625     0.150
    37.379   431.727     0.150
    37.379   777.727     0.150
    37.523   434.523     0.150
    37.529   434.523     0.150
    37.531   435.727     0.150
    37.531   779.727     0.150
    37.612   436.328     0.150
    37.812   436.727     0.150
    37.962   434.625     0.150
    38.019   438.156     0.150
    38.019   530.875     0.150
    38.163   439.727     0.150
    38.169   439.727     0.150
    38.260   440.266     0.150
    38.260     6.367     0.150
    38.260   528.023     0.150
    38.260   440.156     0.150
    38.286   440.727     0.150
    38.484   442.430     0.150
    38.484   528.727     0.150
    38.484   955.727     0.150
    38.484   442.156     0.150
    38.856   445.125     0.150
    38.856   532.727     0.150
    38.976   446.430     0.150
    39.082   446.727     0.150
    39.082   534.727     0.150
    39.082   580.727     0.150
    39.800   455.727     0.150
    40.110   455.227     0.150
    40.155   455.227     0.150
    40.367   458.727     0.150
    40.627   460.125     0.150
    40.638   459.727     0.150
    40.638   827.727     0.150
    40.638  1019.727     0.150
    40.727   462.727     0.150
    40.727   563.727     0.150
    40.727   811.727     0.150
    40.793   461.523     0.150
    40.860   461.727     0.150
    40.877   461.625     0.150
    41.081   464.125     0.150
    41.100   464.727     0.150
    41.094   466.727     0.150
    41.113   463.727     0.150
    41.217   467.727     0.150
    41.411   465.727     0.150
    41.411   839.727     0.150
    41.411   567.727     0.150
    41.455   468.727     0.150
    41.487   467.125     0.150
    41.661   470.727     0.150
    41.773   468.727     0.150
    41.821   470.727     0.150
    41.821   471.227     0.150
    41.859   470.727     0.150
    41.869   470.227     0.150
    41.869   571.727     0.150
    41.869   843.727     0.150
    41.973   470.523     0.150
    42.021   470.227     0.150
    42.025   472.227     0.150
    42.025   855.727     0.150
    42.036   471.328     0.150
    42.282   469.727     0.150
    42.381   474.227     0.150
    42.433   475.227     0.150
    42.439   474.023     0.150
    42.442   474.023     0.150
    42.567   478.727     0.150
    42.578   475.727     0.150
    42.640   475.930     0.150
    42.788   477.727     0.150
    42.788   855.727     0.150
    42.788   479.727     0.150
    42.855   478.727     0.150
    42.899   479.727     0.150
    43.067   483.727     0.150
    43.067   587.727     0.150
    43.144   479.727     0.150
    43.211   481.727     0.150
    43.235   481.023     0.150
    43.260   481.727     0.150
    43.260   864.727     0.150
    43.260  1051.727     0.150
    43.305   481.727     0.150
    43.305   866.727     0.150
    43.305   482.227     0.150
    43.305   585.727     0.150
    43.305  1055.727     0.150
    43.327   482.727     0.150
    43.328   481.328     0.150
    43.368   482.047     0.150
    43.537   484.727     0.150
    43.537   873.727     0.150
    43.537   593.227     0.150
    43.537  1077.727     0.150
    43.734   485.227     0.150
    44.379   490.227     0.150
    44.503   491.727     0.150
    44.524   493.727     0.150
    44.809   494.727     0.150
    44.809   890.727     0.150
    44.809   601.727     0.150
    44.809  1088.727     0.150
    44.979   495.367     0.150
    45.062   497.727     0.150
    45.194   495.625     0.150
    45.202   496.508     0.150
    45.237   496.727     0.150
    45.252   497.086     0.150
    45.409   498.086     0.150
    45.419   497.625     0.150
    45.460   499.727     0.150
    45.465   899.727     0.150
    45.720   500.508     0.150
    45.721   500.328     0.150
    45.721   901.930     0.150
    45.891   502.727     0.150
    45.891   608.727     0.150
    45.925   502.930     0.150
    45.951   502.125     0.150
    46.114   503.883     0.150
    46.140   503.648     0.150
    46.233   505.227     0.150
    46.233     5.297     0.150
    46.233   611.727     0.150
    46.233   909.727     0.150
    46.233  1101.727     0.150
    46.272   503.125     0.150
    46.367   507.727     0.150
    46.398   505.086     0.150
    46.565   505.727     0.150
    46.640   511.727     0.150
    46.663   507.828     0.150
    46.732   508.430     0.150
    46.732     3.797     0.150
    46.732     7.797     0.150
    46.732   606.727     0.150
    46.732   916.227     0.150
    46.871   507.727     0.150
    46.905   510.047     0.150
    46.949   509.727     0.150
    47.183   512.867     0.150
    47.214   513.430     0.150
    47.214   927.227     0.150
    47.203   513.125     0.150
    47.251   514.227     0.150
    47.251   619.023     0.150
    47.302   512.930     0.150
    47.302     7.000     0.150
    47.371   513.727     0.150
    47.460   513.930     0.150
    47.460     5.000     0.150
    47.491   515.227     0.150
    47.657   515.930     0.150
    47.785   520.727     0.150
    47.862   516.484     0.150
    47.873   517.227     0.150
    47.973   516.227     0.150
    47.973  1109.727     0.150
    48.090   519.828     0.150
    48.090     6.898     0.150
    48.090   635.727     0.150
    48.108   520.727     0.150
    48.174   518.727     0.150
    48.243   521.227     0.150
    48.299   521.523     0.150
    48.299   947.727     0.150
    48.361   521.828     0.150
    48.433   522.727     0.150
    48.449   521.930     0.150
    48.516   522.930     0.150
    48.516     4.797     0.150
    48.516  1111.727     0.150
    48.516   522.688     0.150
    48.558   524.328     0.150
    48.558   638.523     0.150
    48.585   525.023     0.150
    48.585   638.727     0.150
    48.585   947.727     0.150
    48.630   524.125     0.150
    48.771   524.227     0.150
    48.857   524.227     0.150
    48.876   524.727     0.150
    48.876   606.727     0.150
    48.876   641.727     0.150
    48.876  1111.727     0.150
    49.133   526.523     0.150
    49.133   950.727     0.150
    49.133   526.727     0.150
    49.354   528.930     0.150
    49.430   529.227     0.150
    49.450   529.695     0.150
    49.544   530.227     0.150
    49.544   647.727     0.150
    49.544   955.727     0.150
    49.581   531.727     0.150
    49.673   533.625     0.150
    49.790   532.727     0.150
    49.874   533.430     0.150
    49.874     5.398     0.150
    49.874   650.430     0.150
    49.874   957.727     0.150
    50.030   534.328     0.150
    50.053   534.125     0.150
    50.125   535.727     0.150
    50.125   536.227     0.150
    50.147   536.227     0.150
    50.237   535.227     0.150
    50.259   534.727     0.150
    50.288   537.227     0.150
    50.288   969.227     0.150
    50.293   536.727     0.150
    50.430   536.727     0.150
    50.430   972.727     0.150
    50.632   537.523     0.150
    50.632   655.727     0.150
    50.650   539.727     0.150
    50.650   975.727     0.150
    50.650   655.727     0.150
    50.650  1129.727     0.150
    50.650  1179.727     0.150
    50.704   537.984     0.150
    50.726   540.125     0.150
    50.830   540.727     0.150
    50.902   540.930     0.150
    50.942   541.828     0.150
    50.942   658.430     0.150
    50.942   978.625     0.150
    50.942  1128.227     0.150
    50.942  1191.227     0.150
    50.942   541.930     0.150
    50.989   541.125     0.150
    50.989   975.727     0.150
    50.989   661.727     0.150
    50.989  1126.727     0.150
    51.007   542.727     0.150
    51.007   661.727     0.150
    51.045   543.328     0.150
    51.056   543.727     0.150
    51.056   987.727     0.150
    51.056   544.227     0.150
    51.099   542.383     0.150
    51.108   542.930     0.150
    51.123   542.625     0.150
    51.278   543.727     0.150
    51.278   666.727     0.150
    51.278   863.727     0.150
    51.278  1139.727     0.150
    51.278   543.930     0.150
    51.278   983.727     0.150
    51.278  1136.727     0.150
    51.349   544.430     0.150
    51.383   545.125     0.150
    51.392   543.828     0.150
    51.394   544.227     0.150
    51.407   544.625     0.150
    51.503   545.727     0.150
    51.524   544.727     0.150
    51.524   544.930     0.150
    51.539   545.430     0.150
    51.568     7.305     0.150
    51.575   546.250     0.150
    51.626   546.430     0.150
    51.626   665.727     0.150
    51.626   987.727     0.150
    51.626  1136.727     0.150
    51.626  1211.727     0.150
    51.626   546.680     0.150
    51.670   547.727     0.150
    51.686   544.125     0.150
    51.845   547.828     0.150
    51.847   547.828     0.150
    51.847   617.727     0.150
    51.847   669.727     0.150
    51.847   855.727     0.150
    51.847   989.727     0.150
    51.847  1133.727     0.150
    51.847   617.227     0.150
    51.847   855.523     0.150
    51.847   547.523     0.150
    51.847   667.727     0.150
    51.847   987.727     0.150
    51.847  1203.727     0.150
    51.851   547.914     0.150
    51.920   549.094     0.150
    51.945   549.625     0.150
    51.976   548.828     0.150
    52.054   550.828     0.150
    52.054   669.727     0.150
    52.054   991.727     0.150
    52.083   549.727     0.150
    52.083   994.727     0.150
    52.414   554.023     0.150
    52.416   551.727     0.150
    52.476   551.727     0.150
    52.487   552.727     0.150
    52.489   553.023     0.150
    52.530   550.625     0.150
    52.601   553.727     0.150
    52.601   553.586     0.150
    52.629   554.125     0.150
    52.629  1005.727     0.150
    52.639   553.336     0.150
    52.640   554.023     0.150
    52.745   554.523     0.150
    52.768   555.328     0.150
    52.768  1143.727     0.150
    52.817   554.523     0.150
    52.832   555.727     0.150
    52.990   555.227     0.150
    53.025   556.430     0.150
    53.026   557.625     0.150
    53.108   558.328     0.150
    53.108  1010.727     0.150
    53.109   556.227     0.150
    53.109   557.664     0.150
    53.109     3.102     0.150
    53.109     7.031     0.150
    53.111   556.727     0.150
    53.111   681.930     0.150
    53.111   998.930     0.150
    53.111  1010.328     0.150
    53.122   556.727     0.150
    53.142   556.727     0.150
    53.210   557.625     0.150
    53.211   557.125     0.150
    53.241   558.727     0.150
    53.241  1008.930     0.150
    53.241   558.359     0.150
    53.266   558.328     0.150
    53.374   561.828     0.150
    53.424   562.727     0.150
    53.434   560.023     0.150
    53.447   560.109     0.150
    53.460   561.023     0.150
    53.482   558.930     0.150
    53.555   561.625     0.150
    53.578   560.227     0.150
    53.582   560.500     0.150
    53.582     6.617     0.150
    53.582   683.133     0.150
    53.582  1012.500     0.150
    53.582  1150.547     0.150
    53.582   560.727     0.150
    53.595   561.359     0.150
    53.863   563.828     0.150
    53.905   562.727     0.150
    53.905  1017.727     0.150
    54.086   566.023     0.150
    54.109   565.328     0.150
    54.204   565.328     0.150
    54.225   566.430     0.150
    54.229   564.328     0.150
    54.322   565.523     0.150
    54.605   568.516     0.150
    54.708   568.727     0.150
    54.745   569.727     0.150
    54.745  1029.727     0.150
    54.745   699.727     0.150
    54.745  1249.727     0.150
    54.827   569.930     0.150
    54.949   570.430     0.150
    54.971   570.227     0.150
    54.971  1025.727     0.150
    54.971   693.727     0.150
    54.999   571.586     0.150
    55.005   571.828     0.150
    55.080   572.203     0.150
    55.149   571.430     0.150
    55.165   571.828     0.150
    55.170   571.516     0.150
    55.260   573.109     0.150
    55.263   572.328     0.150
    55.279   572.125     0.150
    55.297   573.883     0.150
    55.317   573.625     0.150
    55.394   574.727     0.150
    55.415   574.328     0.150
    55.451   574.000     0.150
    55.470   574.836     0.150
    55.533   576.523     0.150
    55.533   703.727     0.150
    55.533  1034.023     0.150
    55.534   575.328     0.150
    55.609   576.133     0.150
    55.609   575.727     0.150
    55.621   575.727     0.150
    55.624   575.727     0.150
    55.678   577.133     0.150
    55.680   575.086     0.150
    55.707   576.438     0.150
    55.761   575.734     0.150
    55.767   576.617     0.150
    55.771   576.664     0.150
    55.796   577.180     0.150
    55.798   576.430     0.150
    55.817   578.719     0.150
    55.850   576.844     0.150
    55.855   576.609     0.150
    55.863   575.594     0.150
    55.865   575.625     0.150
    55.867   578.680     0.150
    55.879   577.469     0.150
    55.891   577.523     0.150
    55.956   578.500     0.150
    55.960   577.523     0.150
    55.960   577.734     0.150
    55.982   577.344     0.150
    56.039   578.523     0.150
    56.173   579.930     0.150
    56.177   578.938     0.150
    56.191   579.805     0.150
    56.230   580.578     0.150
    56.266   580.219     0.150
    56.268   580.125     0.150
    56.319   580.523     0.150
    56.319   580.906     0.150
    56.347   580.828     0.150
    56.354   580.727     0.150
    56.375   581.625     0.150
    56.418   581.617     0.150
    56.428   581.227     0.150
    56.453   579.906     0.150
    56.481   582.367     0.150
    56.501   582.328     0.150
    56.516   579.289     0.150
    56.531   581.523     0.150
    56.533   581.344     0.150
    56.596   581.547     0.150
    56.597   581.328     0.150
    56.600   581.930     0.150
    56.609   582.727     0.150
    56.609   715.727     0.150
    56.670   583.125     0.150
    56.674   584.227     0.150
    56.688   581.758     0.150
    56.699   583.727     0.150
    56.733   583.430     0.150
    56.737   583.727     0.150
    56.747   583.727     0.150
    56.785   584.125     0.150
    56.828   584.219     0.150
    56.879   585.328     0.150
    57.224   586.328     0.150
    57.295   588.000     0.150
    57.295   641.523     0.150
    57.295  1065.727     0.150
    57.295  1177.727     0.150
    57.321   589.727     0.150
    57.321  1065.727     0.150
    57.321  1175.727     0.150
    57.372   587.328     0.150
    57.419   588.523     0.150
    57.451   588.227     0.150
    57.691   590.930     0.150
    57.716   590.828     0.150
    57.764   592.727     0.150
    57.820   591.227     0.150
    57.820   724.227     0.150
    57.820  1069.727     0.150
    57.941   592.430     0.150
    58.233   595.523     0.150
    58.305   594.523     0.150
    58.305   594.680     0.150
    58.309   593.625     0.150
    58.327   593.523     0.150
    58.475   594.828     0.150
    58.607   595.828     0.150
    58.770   596.930     0.150
    58.776   597.930     0.150
    58.831   598.328     0.150
    58.888   600.523     0.150
    59.089   600.227     0.150
    59.143   600.188     0.150
    59.163   599.625     0.150
    59.205   601.227     0.150
    59.244   601.328     0.150
    59.430   602.023     0.150
    59.654   603.625     0.150
    60.093   607.023     0.150
    60.121   606.227     0.150
    60.201   605.727     0.150
    60.201   743.727     0.150
    60.218   608.125     0.150
    60.233   607.734     0.150
    60.361   612.023     0.150
    60.370   608.828     0.150
    60.409   608.914     0.150
    60.461   609.227     0.150
    60.549   609.828     0.150
    60.628   609.727     0.150
    60.633   610.438     0.150
    60.646   610.516     0.150
    60.667   610.664     0.150
    60.681   610.914     0.150
    60.731   611.727     0.150
    60.775   611.430     0.150
    60.817   610.523     0.150
    60.881   612.227     0.150
    60.888   611.930     0.150
    60.888   612.414     0.150
    60.917   612.328     0.150
    60.925   611.375     0.150
    60.935   612.727     0.150
    60.944   612.328     0.150
    60.997   612.930     0.150
    61.020   613.023     0.150
    61.145   614.227     0.150
    61.151   613.430     0.150
    61.153   613.328     0.150
    61.288   614.328     0.150
    61.299   614.828     0.150
    61.347   615.227     0.150
    61.363   615.023     0.150
    61.732   620.727     0.150
    61.760   618.227     0.150
    61.808   617.430     0.150
    61.877   619.727     0.150
    62.026   618.727     0.150
    62.165   624.727     0.150
    62.165  1126.727     0.150
    62.165  1218.727     0.150
    62.185   620.938     0.150
    62.303   622.727     0.150
    62.337   623.227     0.150
    62.359   620.727     0.150
    62.359  1127.727     0.150
    62.420   622.766     0.150
    62.435   625.023     0.150
    62.517   623.883     0.150
    62.521   625.586     0.150
    62.605   624.523     0.150
    62.734   624.734     0.150
    62.734   626.227     0.150
    62.734     4.391     0.150
    62.734     8.203     0.150
    62.734   764.688     0.150
    62.734  1129.844     0.150
    62.734  1142.258     0.150
    62.734  1215.094     0.150
    62.734  1366.977     0.150
    62.733   626.023     0.150
    63.233   628.125     0.150
    63.292   628.828     0.150
    63.310   629.023     0.150
    63.359   629.328     0.150
    63.531   630.328     0.150
    63.720   632.023     0.150
    63.725   631.625     0.150
    63.760   631.945     0.150
    63.811   632.906     0.150
    63.934   633.688     0.150
    64.193   634.664     0.150
    64.729   638.203     0.150
    64.862   638.305     0.150
    64.952   638.227     0.150
    65.140   642.430     0.150
    65.257   641.805     0.150
    65.394   642.180     0.150
    65.523   642.828     0.150
    65.614   644.320     0.150
    65.628   644.047     0.150
    65.753   644.875     0.150
    65.881   647.125     0.150
    65.881   786.727     0.150
    65.881  1173.727     0.150
    65.881  1424.727     0.150
    65.945   645.484     0.150
    65.945     4.141     0.150
    65.945   799.750     0.150
    65.945  1172.727     0.150
    65.945  1427.727     0.150
    65.945   646.367     0.150
    65.945   646.156     0.150
    66.368   649.883     0.150
    66.399   648.227     0.150
    66.399  1173.727     0.150
    66.399   794.727     0.150
    66.399  1243.727     0.150
    66.522   649.109     0.150
    66.530   649.438     0.150
    66.685   650.523     0.150
    66.692   650.430     0.150
    66.785   651.727     0.150
    66.785     3.000     0.150
    66.785     7.000     0.150
    66.977   654.039     0.150
    67.226   654.727     0.150
    67.264   656.523     0.150
    67.335   655.398     0.150
    67.361   655.227     0.150
    67.568   656.375     0.150
    67.880   658.906     0.150
    68.010   659.797     0.150
    68.030   658.727     0.150
    68.248   662.727     0.150
    68.248     3.500     0.150
    68.254   659.773     0.150
    68.357   659.727     0.150
    68.477   662.227     0.150
    68.487   660.727     0.150
    68.602   662.727     0.150
    68.708   663.727     0.150
    68.708  1207.727     0.150
    68.757   663.398     0.150
    68.935   665.430     0.150
    69.149   667.227     0.150
    69.182   665.930     0.150
    69.182   663.727     0.150
    69.376   666.625     0.150
    69.740   673.227     0.150
    69.740     3.500     0.150
    70.006   672.430     0.150
    70.006     3.797     0.150
    70.048   673.727     0.150
    70.048  1220.727     0.150
    70.869   675.227     0.150
    70.983   677.727     0.150
    71.064   677.727     0.150
    71.769   680.727     0.150
    71.769  1237.727     0.150
    71.867   682.727     0.150
    71.985   686.727     0.150
    72.190   683.023     0.150
    72.649   686.930     0.150
    72.731   689.125     0.150
    72.800   688.227     0.150
    72.967   691.227     0.150
    73.037   688.727     0.150
    73.037  1255.727     0.150
    73.322   690.328     0.150
    73.427   692.328     0.150
    73.427  1255.023     0.150
    74.089   693.930     0.150
    74.089  1269.727     0.150
    74.295   696.227     0.150
    74.562   699.828     0.150
    75.010   702.930     0.150
    75.448   705.227     0.150
    75.488   702.727     0.150
    75.488   703.523     0.150
    75.622  2350.023     0.150
    75.855   707.430     0.150
    76.358   709.125     0.150
    76.975   712.727     0.150
    76.975   712.930     0.150
    76.970   712.328     0.150
    77.544  1307.727     0.150
    77.798   715.727     0.150
    77.958   719.727     0.150
    77.958  1311.727     0.150
    78.007   717.734     0.150
    78.007   717.727     0.150
    78.292   721.328     0.150
    78.379   720.727     0.150
    78.379   721.125     0.150
    78.384   722.727     0.150
    78.855   721.227     0.150
    79.437   725.727     0.150
    79.817   727.727     0.150
    79.817   914.328     0.150
    79.827   728.023     0.150
    79.880   728.125     0.150
    79.938   730.523     0.150
    80.110  1351.727     0.150
    80.158   729.625     0.150
    80.593  1346.727     0.150
    80.635   731.523     0.150
    80.635   910.727     0.150
    80.648   733.430     0.150
    81.101   736.727     0.150
    81.206   735.227     0.150
    81.206   918.828     0.150
    81.229   736.430     0.150
    81.229  1344.727     0.150
    81.327   736.945     0.150
    81.543   738.109     0.150
    81.613   736.727     0.150
    81.911   739.727     0.150
    81.911   739.430     0.150
    82.598   742.930     0.150
    82.714   742.727     0.150
    84.616   754.125     0.150
    84.993   754.727     0.150
    85.039   756.727     0.150
    86.329   762.023     0.150
    87.269   768.727     0.150
    87.578   770.828     0.150
    87.578  1406.828     0.150
    87.793   769.727     0.150
    87.793  1411.125     0.150
    87.897   770.125     0.150
    87.897   769.727     0.150
    88.717   773.523     0.150
    90.122   777.727     0.150
    91.247   785.727     0.150
    91.247     5.500     0.150
    91.247  1422.727     0.150
    91.247  1443.727     0.150
    91.247  1511.727     0.150
    92.204   790.727     0.150
    92.204     5.898     0.150
    92.216   791.023     0.150
    92.216     7.602     0.150
    92.397   790.727     0.150
    93.128   794.328     0.150
    93.128     7.602     0.150
    93.366   795.328     0.150
    93.725   796.727     0.150
    93.725  1023.727     0.150
    93.725  1431.727     0.150
    93.725  1463.727     0.150
    94.870   801.023     0.150
    97.606   815.727     0.150
    97.606   821.727     0.150
    97.606  1496.727     0.150
    97.606  1058.727     0.150
    97.606  1448.727     0.150
    97.606  1579.727     0.150
    97.606  1896.727     0.150
    98.489   819.727     0.150
    98.594   819.727     0.150
    98.616   818.727     0.150
    98.740   818.727     0.150
    98.785   821.727     0.150
    99.061   823.930     0.150
    99.677   823.727     0.150
    99.969   824.727     0.150
   100.058   823.727     0.150
   100.058   824.328     0.150
   100.190   827.727     0.150
   100.261   825.328     0.150
   102.161   836.297     0.150
   102.161  1085.898     0.150
   102.161  1087.219     0.150
   102.161  1473.469     0.150
   102.161  1535.484     0.150
   102.161  1627.414     0.150
   102.360   835.633     0.150
   102.360  1091.023     0.150
   102.360  1091.367     0.150
   102.360  1477.273     0.150
   102.360  1539.758     0.150
   102.360  1639.086     0.150
   103.106   839.125     0.150
   103.546   844.227     0.150
   103.546  1478.727     0.150
   104.742   849.938     0.150
   104.742  1488.867     0.150
   104.742  1556.586     0.150
   104.742  1659.773     0.150
   105.101   850.227     0.150
   105.442   849.023     0.150
   105.442  1105.727     0.150
   105.442   849.227     0.150
   105.758   848.727     0.150
   107.043   858.227     0.150
   107.555   863.727     0.150
   107.555  1125.727     0.150
   107.555  1500.727     0.150
   107.555  1684.727     0.150
   107.555  2041.727     0.150
   109.263  1507.055     0.150
   109.263  1557.828     0.150
   109.263  1560.039     0.150
   109.263  1593.203     0.150
   109.263  1707.070     0.150
   109.263  1712.945     0.150
   109.263  1771.344     0.150
   109.798   869.727     0.150
   109.798  1141.727     0.150
   109.798  1773.727     0.150
   109.908   872.023     0.150
   110.879  1716.727     0.150
   110.916   874.656     0.150
   110.916  1148.758     0.150
   110.916  1150.906     0.150
   110.916  1510.758     0.150
   110.916  1568.688     0.150
   110.916  1571.586     0.150
   110.916  1607.656     0.150
   110.916  1711.469     0.150
   111.615  1153.727     0.150
   111.615  1158.727     0.150
   111.615  1513.727     0.150
   111.615  1543.727     0.150
   111.615  1572.727     0.150
   111.971   880.719     0.150
   113.492   888.250     0.150
   113.492  1523.094     0.150
   113.492  1584.898     0.150
   113.492  1586.547     0.150
   113.492  1629.664     0.150
   113.492   887.328     0.150
   113.492  1530.727     0.150
   113.492  1636.727     0.150
   113.492  1743.023     0.150
   113.691  1746.430     0.150
   113.708  1744.727     0.150
   113.708  2113.727     0.150
   113.818  1118.727     0.150
   113.962  1119.727     0.150
   113.962  1168.227     0.150
   114.058  1745.430     0.150
   114.464   890.227     0.150
   114.464  1173.688     0.150
   114.464  1174.844     0.150
   114.464  1529.047     0.150
   114.464  1595.484     0.150
   114.464  1597.414     0.150
   114.464  1753.727     0.150
   114.467   890.227     0.150
   114.467  1174.727     0.150
   114.467  1527.727     0.150
   114.467  1595.727     0.150
   114.467  1747.727     0.150
   115.698  1121.227     0.150
   117.726  1125.328     0.150
   119.394  1130.727     0.150
   119.394  1545.727     0.150
   119.394  1630.727     0.150
   119.394  1683.727     0.150
   119.394  1744.727     0.150
   119.394  2197.727     0.150
   120.114  1130.328     0.150
   120.114  1218.125     0.150
   120.207  1133.430     0.150
   120.207  1743.125     0.150
   120.581  1734.828     0.150
   121.164  1134.523     0.150
   122.858  1136.500     0.150
   123.724  1140.227     0.150
   126.121  1143.727     0.150
   127.395  1148.227     0.150
   128.862  1151.328     0.150
   129.259  1149.727     0.150
   129.409  1150.227     0.150
   129.833  1151.727     0.150
   130.405  1152.023     0.150
   131.125  1153.227     0.150
   131.387  1154.523     0.150
   131.387  1159.523     0.150
   131.387  1301.227     0.150
   131.387  1357.930     0.150
   134.398  1158.727     0.150
   134.766  1156.023     0.150
   134.766  1163.727     0.150
   134.766  1316.930     0.150
   134.766  1369.930     0.150
   135.347  1160.727     0.150
   135.347  1317.727     0.150
   138.106  1161.477     0.150
   138.691  1163.727     0.150
   138.751  1161.289     0.150
   139.466  1164.297     0.150
   141.428  1168.375     0.150
   143.602  1179.727     0.150
   143.602  1365.727     0.150
   143.602  1778.727     0.150
   143.602  2487.727     0.150
   146.551  1180.828     0.150
   146.666  1181.023     0.150
   149.046  1189.125     0.150
   149.388  1186.727     0.150
   150.723  1189.727     0.150
   151.787  1190.727     0.150
   151.787  1195.227     0.150
   151.828  1189.328     0.150
   151.995  1189.328     0.150
   152.195  1188.727     0.150
   152.299  1190.227     0.150
   152.665  1193.328     0.150
   153.905  1191.727     0.150
   153.920  1193.727     0.150
   153.991  1192.727     0.150
   154.022  1191.727     0.150
   154.027  1194.727     0.150
   154.030  1194.727     0.150
   154.259  1192.727     0.150
   154.290  1194.727     0.150
   154.661  1192.727     0.150
   154.781  1187.727     0.150
   154.822  1195.227     0.150
     0.770    14.467     0.150
     0.770    25.467     0.150
     2.509    41.667     0.150
     2.509    72.367     0.150
     5.298    79.167     0.150
     5.298   137.867     0.150
     5.427    83.067     0.150
     5.627   163.867     0.150
     5.867    88.268     0.150
     6.266    93.067     0.150
     6.425    96.167     0.150
     6.466    95.268     0.150
     6.504    97.067     0.150
     6.504   167.867     0.150
     6.679    96.867     0.150
     6.675    98.867     0.150
     6.878   101.667     0.150
     7.359   109.268     0.150
     9.309   129.867     0.150
    10.185   256.867     0.150
    13.350   184.067     0.150
    13.350   325.567     0.150
    13.699   189.867     0.150
    14.081   196.867     0.150
    14.081   206.867     0.150
    21.572   289.467     0.150
    21.855   292.167     0.150
    51.456   544.367     0.150
    52.735   553.268     0.150
    56.661   583.167     0.150
    56.670   583.167     0.150
    73.503   692.067     0.150
    77.954   717.667     0.150
     0.738    13.748     0.150
     0.738    23.848     0.150
     2.068    37.148     0.150
     2.068    63.148     0.150
     2.475    40.248     0.150
     2.475    72.248     0.150
     5.291    78.848     0.150
     5.432    82.049     0.150
     5.866    86.348     0.150
     6.263    91.947     0.150
     6.423    94.348     0.150
     6.466    94.148     0.150
     6.506    95.148     0.150
     6.506   166.748     0.150
     6.662    94.248     0.150
     6.674    97.748     0.150
     6.916   100.848     0.150
     6.880    99.248     0.150
     7.349   107.947     0.150
     8.987   129.748     0.150
     9.286   127.348     0.150
    10.164   143.248     0.150
    10.170   144.248     0.150
    10.699   150.748     0.150
    10.699   151.248     0.150
    10.809   155.748     0.150
    10.842   155.148     0.150
    10.842   270.748     0.150
    11.262   159.748     0.150
    11.262   280.748     0.150
    11.670   166.748     0.150
    11.670   289.748     0.150
    12.455   176.748     0.150
    12.455   177.549     0.150
    12.489   176.748     0.150
    12.489   314.748     0.150
    12.473   314.748     0.150
    12.984   183.748     0.150
    12.984   178.947     0.150
    12.984   317.748     0.150
    12.997   183.748     0.150
    12.997   180.947     0.150
    12.997   320.947     0.150
    13.318   182.748     0.150
    14.046   192.748     0.150
    14.046   202.748     0.150
    14.046   341.748     0.150
    14.823   207.648     0.150
    14.823   213.447     0.150
    14.823   373.248     0.150
    14.823   389.748     0.150
    16.951   231.748     0.150
    19.253   262.947     0.150
    19.253   277.748     0.150
    19.628   267.748     0.150
    19.628   484.748     0.150
    21.597   288.748     0.150
    21.597   707.748     0.150
    21.854   290.248     0.150
    22.867   301.248     0.150
    23.084   303.748     0.150
    24.218   315.748     0.150
    24.880   321.348     0.150
    25.659   327.748     0.150
    26.558   336.748     0.150
    26.826   339.447     0.150
    27.120   341.748     0.150
    28.318   353.148     0.150
    30.573   372.748     0.150
    36.271   421.748     0.150
    37.410   431.148     0.150
    37.410     7.600     0.150
    38.103   437.748     0.150
    38.103     8.000     0.150
    38.418   439.947     0.150
    38.418   526.748     0.150
    38.884   443.748     0.150
    41.896   469.549     0.150
    43.257   480.748     0.150
    45.861   500.748     0.150
    46.168   502.748     0.150
    46.168   503.148     0.150
    47.598   513.947     0.150
    49.479   528.447     0.150
    51.209   541.748     0.150
    51.473   543.248     0.150
    52.752   551.648     0.150
    56.199   577.848     0.150
    56.462   579.648     0.150
    56.668   581.748     0.150
    56.677   581.848     0.150
    58.240   592.049     0.150
    58.405   593.049     0.150
    58.538   594.148     0.150
    58.701   595.148     0.150
    59.361   600.348     0.150
    59.585   601.947     0.150
    60.023   605.049     0.150
    60.052   604.648     0.150
    60.559   608.049     0.150
    60.748   609.049     0.150
    60.927   611.248     0.150
    61.082   611.549     0.150
    61.084   611.447     0.150
    61.294   612.748     0.150
    65.503   642.248     0.150
    66.387   646.748     0.150
    66.387   647.248     0.150
    69.866   669.248     0.150
    71.044   676.748     0.150
    72.615   685.748     0.150
    73.477   690.748     0.150
    73.496   690.748     0.150
    75.470   702.848     0.150
    75.691   703.248     0.150
    77.988   716.947     0.150
    78.331   717.748     0.150
    80.143   728.348     0.150
    80.631   732.049     0.150
    81.169   733.947     0.150
    81.901   738.248     0.150
    87.863   768.748     0.150
   146.484  1179.947     0.150
   146.599  1184.748     0.150
   149.320  1188.748     0.150
     0.704    13.047     0.150
     0.704    21.848     0.150
     2.042    36.148     0.150
     2.042    63.348     0.150
     2.445    39.848     0.150
     2.445    68.348     0.150
     2.445    73.848     0.150
     5.264    79.047     0.150
     5.264   138.848     0.150
     5.561    82.848     0.150
     5.561   171.148     0.150
     5.413    82.648     0.150
     5.888    88.047     0.150
     6.238    92.949     0.150
     6.444    96.047     0.150
     6.488    96.047     0.150
     6.485    95.949     0.150
     6.485   169.848     0.150
     6.695    98.848     0.150
     6.904   102.047     0.150
     6.889   101.148     0.150
     6.889   177.848     0.150
     7.320   107.949     0.150
    12.749   177.848     0.150
    13.303   183.348     0.150
    14.022   196.848     0.150
    51.467   544.547     0.150
     2.457    41.457     0.150
     2.457    69.957     0.150
     2.187    40.559     0.150
     5.593    84.559     0.150
     5.593   147.059     0.150
     5.741    86.438     0.150
     5.560    85.758     0.150
     6.297    94.539     0.150
     6.342    94.598     0.150
     6.548    97.719     0.150
     6.384    95.359     0.150
     6.757   100.160     0.150
     6.633    98.758     0.150
     7.031   104.160     0.150
     7.459   112.160     0.150
     9.094   133.957     0.150
    10.708   154.359     0.150
    10.826   154.758     0.150
    12.604   176.559     0.150
    12.939   184.559     0.150
    12.562   180.559     0.150
    13.234   183.059     0.150
    13.234   324.559     0.150
    13.995   192.758     0.150
    13.995   342.559     0.150
    14.858   209.559     0.150
    14.858   217.258     0.150
    15.825   216.559     0.150
    15.825   387.559     0.150
    19.217   264.059     0.150
    19.709   269.359     0.150
    19.709   490.559     0.150
    20.412   278.258     0.150
    21.405   288.359     0.150
    21.538   289.559     0.150
    21.728   290.258     0.150
    24.779   320.758     0.150
    25.588   328.559     0.150
    26.580   338.559     0.150
    26.580   339.457     0.150
    26.838   341.258     0.150
    27.079   344.059     0.150
    28.549   357.559     0.150
    30.491   373.559     0.150
    36.294   423.559     0.150
    38.849   445.258     0.150
    39.126   447.160     0.150
    43.386   484.559     0.150
    45.985   503.359     0.150
    46.293   505.559     0.150
    48.574   523.559     0.150
    51.599   546.059     0.150
    51.628   546.359     0.150
    51.628     4.199     0.150
    52.878   554.859     0.150
    56.328   580.457     0.150
    56.592   582.359     0.150
    56.658   582.957     0.150
    56.797   584.457     0.150
    56.806   584.559     0.150
    58.369   594.457     0.150
    58.535   595.660     0.150
    58.667   596.758     0.150
    58.830   597.859     0.150
    59.490   603.059     0.150
    59.714   604.559     0.150
    60.688   610.660     0.150
    61.056   613.957     0.150
    62.317   622.160     0.150
    66.427   648.559     0.150
    66.427   649.059     0.150
    72.693   687.559     0.150
    73.348   691.758     0.150
    73.368   691.457     0.150
    75.562   703.957     0.150
    75.519   703.609     0.150
    78.039   717.609     0.150
    78.395   719.559     0.150
    81.269   736.559     0.150
    81.237   735.297     0.150
    81.368   737.059     0.150
    81.584   738.258     0.150
    82.630   743.348     0.150
     0.534     9.414     0.150
     0.534    17.312     0.150
     2.276    39.016     0.150
     2.276    69.312     0.150
     3.243    51.914     0.150
     6.315    93.617     0.150
     6.315   162.617     0.150
     7.130   104.414     0.150
     7.130   182.414     0.150
     7.297   107.211     0.150
     8.128   118.414     0.150
     8.378   122.414     0.150
     9.157   132.211     0.150
    11.868   169.117     0.150
    11.868   295.414     0.150
    12.402   174.016     0.150
    12.606   174.914     0.150
    12.930   180.914     0.150
    13.888   193.914     0.150
    14.955   218.617     0.150
    16.520   225.414     0.150
    18.354   255.414     0.150
    18.823   260.414     0.150
    19.954   274.211     0.150
    20.163   274.414     0.150
    23.175   306.414     0.150
    24.296   316.914     0.150
    26.130   335.414     0.150
    45.112   498.414     0.150
    47.459   514.914     0.150
    47.806   517.414     0.150
    53.323   559.312     0.150
    58.513   596.617     0.150
    58.523   596.711     0.150
    63.706   630.414     0.150
    71.627   681.312     0.150
    71.636   680.516     0.150
    82.874   745.016     0.150
     2.571    39.664     0.150
     2.571    69.664     0.150
     5.658    83.164     0.150
     5.658   146.164     0.150
     5.799    85.064     0.150
     5.799   151.264     0.150
     6.633    95.764     0.150
     6.872    98.465     0.150
     7.283   103.965     0.150
     7.712   111.164     0.150
     9.204   131.965     0.150
     9.204   229.164     0.150
    12.355   170.164     0.150
    12.355   170.664     0.150
    12.988   178.164     0.150
    12.988   316.164     0.150
    13.031   179.164     0.150
    12.672   178.164     0.150
    13.193   179.664     0.150
    13.193   322.164     0.150
    14.793   207.664     0.150
    17.044   229.465     0.150
    19.035   258.164     0.150
    20.381   276.664     0.150
    21.165   282.164     0.150
    21.487   287.264     0.150
    21.324   284.164     0.150
    21.579   287.164     0.150
    21.701   288.164     0.150
    21.701   744.164     0.150
    23.294   303.664     0.150
    23.624   307.465     0.150
    24.529   317.164     0.150
    24.348   314.164     0.150
    25.363   323.164     0.150
    26.491   335.164     0.150
    29.526   361.863     0.150
    30.253   368.664     0.150
    31.446   377.564     0.150
    35.954   418.664     0.150
    36.703   424.264     0.150
    36.703    10.701     0.150
    36.703   565.965     0.150
    38.668   440.465     0.150
    38.729   439.564     0.150
    38.729    12.900     0.150
    43.616   482.164     0.150
    43.616   482.664     0.150
    45.382   494.764     0.150
    46.058   500.564     0.150
    46.058    11.799     0.150
    46.058   596.465     0.150
    46.058   826.363     0.150
    46.155   501.363     0.150
    46.155   501.465     0.150
    46.472   504.164     0.150
    48.908   522.164     0.150
    48.910   521.363     0.150
    48.910   605.863     0.150
    49.098   524.465     0.150
    49.789   528.465     0.150
    51.848   544.863     0.150
    51.848   544.764     0.150
    51.848   619.664     0.150
    52.884   551.965     0.150
    52.884    12.100     0.150
    53.058   553.064     0.150
    54.914   567.164     0.150
    54.914   567.363     0.150
    54.914  1038.064     0.150
    56.054   574.664     0.150
    56.550   578.965     0.150
    56.813   580.863     0.150
    56.889   581.465     0.150
    57.024   583.064     0.150
    57.033   582.965     0.150
    58.592   592.863     0.150
    58.609   592.764     0.150
    58.758   594.363     0.150
    58.890   595.164     0.150
    59.053   596.264     0.150
    59.714   601.363     0.150
    59.938   602.965     0.150
    60.379   606.164     0.150
    60.405   605.564     0.150
    60.656   608.264     0.150
    60.906   608.965     0.150
    61.046   610.465     0.150
    61.146   610.164     0.150
    61.433   612.363     0.150
    61.431   612.264     0.150
    62.252   617.664     0.150
    62.192   617.164     0.150
    66.249   644.863     0.150
    72.722   683.764     0.150
    72.722    15.100     0.150
    73.119   686.465     0.150
    73.119    12.500     0.150
    73.128   686.863     0.150
    74.849   697.064     0.150
    75.341   699.264     0.150
    75.341   713.764     0.150
    75.482   700.564     0.150
    77.252   711.465     0.150
    78.065   714.664     0.150
    78.006   713.164     0.150
    78.006   713.664     0.150
    78.353   715.664     0.150
    78.353    14.600     0.150
    78.353   892.164     0.150
    79.865   723.965     0.150
    80.676   733.023     0.150
    81.465   734.264     0.150
    81.519   735.094     0.150
    81.618   735.395     0.150
    81.833   736.375     0.150
    84.853   750.064     0.150
    85.864   756.363     0.150
    86.521   757.764     0.150
    86.521    15.600     0.150
    86.521   958.564     0.150
    89.957   775.863     0.150
    89.957   987.863     0.150
   120.283  1127.863     0.150
   146.869  1179.164     0.150
    49.098   524.494     0.150
    49.098   524.494     0.150
    49.098   524.574     0.150
    49.098   524.555     0.150
    45.382   495.672     0.150
    45.382   495.658     0.150
     5.799    83.896     0.150
     5.799    83.896     0.150
     5.799    82.828     0.150
     5.799    82.809     0.150
     3.178    50.449     0.150
     3.178    59.049     0.150
     3.178    85.549     0.150
     3.178    99.049     0.150
     7.273   108.350     0.150
     7.278   106.148     0.150
     8.718   126.049     0.150
     9.185   135.049     0.150
    10.320   261.049     0.150
    11.817   168.049     0.150
    12.558   173.549     0.150
    12.868   178.549     0.150
    13.665   191.549     0.150
    13.772   345.049     0.150
    15.008   210.648     0.150
    15.008   218.648     0.150
    15.008   381.049     0.150
    16.470   225.049     0.150
    18.422   252.549     0.150
    20.008   272.350     0.150
    20.014   272.248     0.150
    20.014   493.049     0.150
    20.222   275.248     0.150
    20.222   743.949     0.150
    20.211   275.049     0.150
    20.211   495.049     0.150
    20.211   506.049     0.150
    20.444   277.350     0.150
    20.444   287.049     0.150
    20.444   290.549     0.150
    20.444   502.049     0.150
    20.444   515.049     0.150
    21.968   294.049     0.150
    21.968   535.049     0.150
    22.969   304.049     0.150
    23.228   306.049     0.150
    24.220   315.350     0.150
    24.360   316.049     0.150
    24.360   575.049     0.150
    24.341   317.049     0.150
    25.004   322.248     0.150
    25.004   358.049     0.150
    26.197   335.449     0.150
    26.642   339.449     0.150
    26.642   613.049     0.150
    27.053   342.799     0.150
    27.122   346.049     0.150
    27.122   623.049     0.150
    27.393   346.049     0.150
    27.393   625.049     0.150
    27.496   346.049     0.150
    27.496   623.049     0.150
    28.354   354.049     0.150
    28.354     7.000     0.150
    29.127   360.549     0.150
    29.127   651.049     0.150
    29.416   364.549     0.150
    29.425   365.049     0.150
    30.026   370.350     0.150
    30.347   371.049     0.150
    30.347   672.049     0.150
    30.689   375.449     0.150
    30.697   375.549     0.150
    30.697   677.049     0.150
    30.697   775.049     0.150
    30.697  1007.049     0.150
    30.734   376.049     0.150
    30.734     8.500     0.150
    30.734   436.549     0.150
    30.734   677.049     0.150
    31.152   378.049     0.150
    31.152  1002.049     0.150
    31.381   380.379     0.150
    31.819   384.049     0.150
    31.973   387.049     0.150
    31.973   457.049     0.150
    31.973   701.049     0.150
    32.840   393.049     0.150
    32.853   394.049     0.150
    32.836   393.350     0.150
    32.836   709.049     0.150
    33.002   394.648     0.150
    33.075   393.850     0.150
    33.082   395.850     0.150
    33.719   404.379     0.150
    33.901   401.879     0.150
    33.994   403.049     0.150
    34.799   411.049     0.150
    34.874   412.049     0.150
    34.874   740.049     0.150
    35.127   415.049     0.150
    35.127   562.049     0.150
    35.127  1027.049     0.150
    35.339   415.049     0.150
    35.339   565.248     0.150
    35.654   418.350     0.150
    36.218   423.148     0.150
    36.472   424.648     0.150
    36.624   426.850     0.150
    36.795   427.850     0.150
    37.164   430.850     0.150
    38.032   438.049     0.150
    38.125   439.049     0.150
    38.678   444.209     0.150
    38.948   446.248     0.150
    39.744   451.748     0.150
    39.744   806.949     0.150
    39.791   452.049     0.150
    39.791   816.049     0.150
    40.205   454.549     0.150
    40.122   455.049     0.150
    40.122   819.049     0.150
    41.079   465.049     0.150
    41.071   463.049     0.150
    41.071   560.049     0.150
    41.664   469.648     0.150
    42.488   474.549     0.150
    42.995   479.148     0.150
    42.995   578.049     0.150
    43.166   480.049     0.150
    43.166     5.000     0.150
    43.166   577.049     0.150
    43.166   865.049     0.150
    43.474   484.049     0.150
    43.539   483.549     0.150
    44.339   490.049     0.150
    44.550   491.549     0.150
    44.550   492.049     0.150
    44.664   494.049     0.150
    44.879   495.049     0.150
    44.879   890.049     0.150
    44.879  1085.049     0.150
    45.091   496.549     0.150
    45.091   497.148     0.150
    45.141   495.850     0.150
    45.141   602.049     0.150
    45.141   895.049     0.150
    45.393   500.049     0.150
    45.459   499.049     0.150
    45.569   501.049     0.150
    45.712   500.049     0.150
    46.073   504.049     0.150
    46.090   504.049     0.150
    46.139   504.248     0.150
    46.542   507.049     0.150
    46.562   507.148     0.150
    46.562     5.500     0.150
    46.562   618.648     0.150
    46.562   911.049     0.150
    47.148   512.049     0.150
    47.253   516.248     0.150
    47.295   513.049     0.150
    47.322   513.049     0.150
    47.378   513.350     0.150
    47.378   602.648     0.150
    47.378   837.648     0.150
    47.436   513.049     0.150
    47.465   514.350     0.150
    47.727   516.449     0.150
    47.727     4.600     0.150
    47.925   518.049     0.150
    47.809   516.850     0.150
    47.890   517.248     0.150
    47.916   517.148     0.150
    48.053   518.248     0.150
    48.053   518.148     0.150
    48.055   517.850     0.150
    48.055   841.449     0.150
    48.041   520.049     0.150
    48.112   520.049     0.150
    48.130   520.049     0.150
    48.438   520.049     0.150
    48.439   522.049     0.150
    48.507   521.648     0.150
    48.507     5.400     0.150
    48.578   522.148     0.150
    48.590   522.049     0.150
    48.862   526.949     0.150
    48.955   527.049     0.150
    48.990   527.350     0.150
    49.191   528.549     0.150
    49.191     5.600     0.150
    49.191   955.049     0.150
    49.224   528.049     0.150
    49.284   528.549     0.150
    49.284   955.049     0.150
    49.365   528.449     0.150
    49.868   532.449     0.150
    49.913   532.248     0.150
    50.287   535.549     0.150
    50.287   654.049     0.150
    50.287   966.049     0.150
    50.280   535.850     0.150
    50.308   537.350     0.150
    50.316   536.049     0.150
    50.351   537.350     0.150
    50.351     4.398     0.150
    50.351   618.748     0.150
    50.744   539.449     0.150
    50.848   540.418     0.150
    51.100   541.850     0.150
    51.145   543.049     0.150
    51.145     3.900     0.150
    51.145   977.049     0.150
    51.379   544.350     0.150
    51.547   546.658     0.150
    51.512   545.449     0.150
    51.514   545.049     0.150
    51.619     6.000     0.150
    52.031   547.648     0.150
    52.054   549.148     0.150
    52.307   552.049     0.150
    52.673   553.748     0.150
    52.673     5.102     0.150
    52.673   625.748     0.150
    52.673   554.010     0.150
    52.673   554.260     0.150
    52.738   554.049     0.150
    52.738     5.000     0.150
    53.001   556.549     0.150
    53.001     4.500     0.150
    53.038   557.049     0.150
    53.038     5.500     0.150
    53.281   558.549     0.150
    53.364   558.549     0.150
    53.364     5.400     0.150
    53.364  1013.049     0.150
    53.364   558.969     0.150
    53.376   560.049     0.150
    53.430   558.350     0.150
    53.477   559.850     0.150
    53.477     5.000     0.150
    53.495   560.139     0.150
    53.565   560.248     0.150
    53.565     4.500     0.150
    53.565  1014.049     0.150
    53.593   560.619     0.150
    53.608   560.648     0.150
    53.620   560.549     0.150
    53.721   561.049     0.150
    53.792   562.318     0.150
    53.911   563.088     0.150
    54.060   564.180     0.150
    54.079   564.809     0.150
    54.172   564.289     0.150
    54.180   564.729     0.150
    54.232   564.748     0.150
    54.258   565.949     0.150
    54.258   566.248     0.150
    54.374   566.449     0.150
    54.374   567.148     0.150
    54.401   565.350     0.150
    54.435   566.430     0.150
    54.492   567.648     0.150
    54.492     4.900     0.150
    54.492     8.701     0.150
    54.492   689.049     0.150
    54.492  1025.049     0.150
    54.492  1235.049     0.150
    54.496   567.350     0.150
    54.496   567.180     0.150
    54.496   566.469     0.150
    54.514   567.648     0.150
    54.677   567.418     0.150
    54.794   570.049     0.150
    54.794   570.248     0.150
    54.796   570.350     0.150
    54.796   570.648     0.150
    54.823   569.469     0.150
    54.840   570.549     0.150
    54.840     5.000     0.150
    54.861   569.049     0.150
    54.895   569.648     0.150
    54.892   569.049     0.150
    54.915   569.979     0.150
    55.024   570.799     0.150
    55.041   571.318     0.150
    55.111   571.459     0.150
    55.156   571.148     0.150
    55.158   572.010     0.150
    55.190   571.988     0.150
    55.203   573.049     0.150
    55.209   571.350     0.150
    55.215   572.100     0.150
    55.228   573.148     0.150
    55.231   572.699     0.150
    55.330   572.549     0.150
    55.356   573.520     0.150
    55.358   573.539     0.150
    55.519   574.148     0.150
    55.568   575.219     0.150
    55.596   576.049     0.150
    55.618   576.209     0.150
    55.635   575.498     0.150
    55.643   575.588     0.150
    55.673   576.549     0.150
    55.729   576.049     0.150
    55.761   576.119     0.150
    55.830   576.350     0.150
    55.860   576.838     0.150
    55.869   577.350     0.150
    55.957   577.549     0.150
    56.088   578.389     0.150
    56.158   579.248     0.150
    56.170   579.049     0.150
    56.162   578.609     0.150
    56.202   578.629     0.150
    56.230   579.369     0.150
    56.360   580.248     0.150
    56.367   580.680     0.150
    56.403   580.219     0.150
    56.410   581.449     0.150
    56.462   581.248     0.150
    56.553   581.949     0.150
    56.553   582.148     0.150
    56.701   582.949     0.150
    56.713   582.850     0.150
    56.741   583.389     0.150
    56.767   584.609     0.150
    56.793   583.379     0.150
    56.797   586.199     0.150
    56.894   584.148     0.150
    56.921   584.049     0.150
    57.125   584.748     0.150
    57.010   584.850     0.150
    57.036   584.189     0.150
    57.150   586.248     0.150
    57.153   585.609     0.150
    57.176   586.748     0.150
    57.200   586.449     0.150
    57.200   586.148     0.150
    57.244   586.350     0.150
    57.308   588.049     0.150
    57.332   588.049     0.150
    57.517   589.350     0.150
    57.532   588.850     0.150
    57.539   589.350     0.150
    57.553   588.850     0.150
    57.590   588.850     0.150
    57.590   588.049     0.150
    57.601   589.449     0.150
    57.622   588.270     0.150
    57.701   589.350     0.150
    57.782   590.748     0.150
    57.824   591.148     0.150
    57.928   592.449     0.150
    57.974   591.449     0.150
    58.031   591.939     0.150
    58.061   591.529     0.150
    58.077   592.350     0.150
    58.104   593.289     0.150
    58.212   595.529     0.150
    58.239   593.838     0.150
    58.255   594.248     0.150
    58.273   593.549     0.150
    58.277   593.738     0.150
    58.297   592.939     0.150
    58.342   595.049     0.150
    58.359   593.238     0.150
    58.360   593.588     0.150
    58.451   595.129     0.150
    58.464   595.549     0.150
    58.495   595.850     0.150
    58.504   595.949     0.150
    58.542   596.648     0.150
    58.557   594.648     0.150
    58.589   596.219     0.150
    58.639   596.748     0.150
    58.644   596.049     0.150
    58.668   596.850     0.150
    58.719   597.148     0.150
    58.873   598.248     0.150
    58.990   598.449     0.150
    59.139   599.350     0.150
    59.139   600.059     0.150
    59.217   600.248     0.150
    59.221   600.549     0.150
    59.242   600.850     0.150
    59.271   600.949     0.150
    59.665   603.748     0.150
    59.894   604.549     0.150
    59.975   605.850     0.150
    60.070   606.248     0.150
    60.071   605.648     0.150
    60.071   605.049     0.150
    60.223   606.949     0.150
    60.352   607.748     0.150
    60.352   607.049     0.150
    60.517   608.748     0.150
    60.528   609.350     0.150
    60.840   611.449     0.150
    60.961   612.549     0.150
    60.997   612.549     0.150
    61.403   615.449     0.150
    61.403   615.049     0.150
    61.849   618.648     0.150
    61.849   618.049     0.150
    62.358   621.148     0.150
    62.545   622.049     0.150
    62.546   621.930     0.150
    62.752   624.549     0.150
    62.752   624.049     0.150
    62.884   624.549     0.150
    62.884   624.049     0.150
    62.895   624.648     0.150
    63.254   627.049     0.150
    63.360   627.850     0.150
    64.011   632.449     0.150
    64.130   634.549     0.150
    64.190   637.510     0.150
    64.241   634.648     0.150
    64.446   634.949     0.150
    64.499   635.049     0.150
    64.640   636.549     0.150
    64.927   639.049     0.150
    65.484   642.350     0.150
    65.584   643.398     0.150
    66.976   649.748     0.150
    67.031   652.748     0.150
    67.389   654.049     0.150
    67.403   655.248     0.150
    67.521   655.748     0.150
    67.798   656.248     0.150
    67.727   656.350     0.150
    68.468   660.299     0.150
    69.102   664.299     0.150
    69.295   664.049     0.150
    69.341   667.049     0.150
    70.212   670.549     0.150
    70.613   672.449     0.150
    71.105   677.350     0.150
    71.477   677.850     0.150
    71.446   679.449     0.150
    71.647   680.748     0.150
    71.655   681.449     0.150
    71.655  1236.850     0.150
    72.130   682.648     0.150
    72.751   689.049     0.150
    73.377   690.248     0.150
    73.377   705.850     0.150
    74.923   701.049     0.150
    75.365   703.549     0.150
    75.774   705.549     0.150
    75.770   704.719     0.150
    75.903   705.539     0.150
    77.163   713.059     0.150
    78.470   719.748     0.150
    78.529   720.988     0.150
    78.672   719.748     0.150
    78.873   721.549     0.150
    80.390   731.449     0.150
    80.389   729.578     0.150
    80.922   733.350     0.150
    81.544   736.148     0.150
    82.022   738.949     0.150
    82.772   743.699     0.150
    82.823   744.510     0.150
    82.926   744.850     0.150
    83.137   745.809     0.150
    84.408   750.449     0.150
    84.623   752.648     0.150
    86.021   761.049     0.150
    86.905   764.248     0.150
    87.131   763.648     0.150
    87.131  1834.650     0.150
    87.131  2324.650     0.150
    90.353   781.850     0.150
    90.360   780.049     0.150
    90.471   781.449     0.150
    90.485   781.449     0.150
    91.083   783.350     0.150
    91.385   784.748     0.150
   100.096   825.549     0.150
   100.772   827.949     0.150
   107.099  1104.338     0.150
   107.099  1105.350     0.150
   109.812  1111.248     0.150
   115.171  1119.549     0.150
   115.713  1121.549     0.150
   117.086  1122.949     0.150
   120.965  1132.447     0.150
   120.965  1734.447     0.150
   130.881  1152.150     0.150
   130.903  1152.248     0.150
   130.903  1293.748     0.150
   130.903  1358.350     0.150
   148.311  1186.150     0.150
   148.409  1183.049     0.150
   151.148  1189.049     0.150
   152.489  1196.650     0.150
     0.934    17.734     0.150
     0.934    29.637     0.150
     2.533    41.836     0.150
     2.533    74.836     0.150
     2.508    45.234     0.150
     2.906    48.836     0.150
     2.906    88.336     0.150
     3.684    60.336     0.150
     3.684   103.938     0.150
     3.789    61.035     0.150
     3.789   104.438     0.150
     3.902    63.535     0.150
     3.902   107.637     0.150
     6.091    92.137     0.150
     6.296    95.234     0.150
     6.301    94.734     0.150
     7.224   105.035     0.150
     7.224   182.836     0.150
     7.093   105.734     0.150
     7.365   109.137     0.150
     7.718   114.035     0.150
     8.121   120.035     0.150
     8.121   259.836     0.150
     8.544   122.836     0.150
     8.544   214.637     0.150
    11.900   167.836     0.150
    11.900   295.336     0.150
    12.805   178.836     0.150
    12.805   313.836     0.150
    18.981   261.836     0.150
    19.270   267.637     0.150
    21.166   285.836     0.150
    46.580   508.035     0.150
    46.995   511.234     0.150
    49.600   531.637     0.150
    52.366   552.637     0.150
    53.582   561.035     0.150
    57.535   589.836     0.150
    57.545   589.836     0.150
    66.751   651.637     0.150
    72.610   688.535     0.150
    75.752   706.438     0.150
    78.289   719.855     0.150
    86.887   763.535     0.150
   147.311  1185.336     0.150
    78.289   720.438     0.150
    12.805   182.273     0.150
    12.805   181.828     0.150
     6.301    93.242     0.150
     1.103    20.000     0.150
     1.103    35.000     0.150
     1.670    30.441     0.150
     1.670    52.000     0.150
     1.908    57.000     0.150
     1.993    36.238     0.150
     2.193    40.199     0.150
     2.623    43.000     0.150
     2.623    47.000     0.150
     2.623    78.000     0.150
     2.696    83.000     0.150
     2.606    48.699     0.150
     2.606    79.199     0.150
     3.025    53.102     0.150
     3.025    92.000     0.150
     2.992    48.941     0.150
     3.245    52.680     0.150
     3.352    55.301     0.150
     3.352    94.801     0.150
     3.444    55.801     0.150
     3.444    95.801     0.150
     3.567    57.500     0.150
     3.567    99.398     0.150
     4.068    63.539     0.150
     4.068   110.621     0.150
     4.336    68.000     0.150
     4.336   135.000     0.150
     4.486    69.559     0.150
     4.486   121.199     0.150
     4.696    73.699     0.150
     4.696   125.340     0.150
     5.329    82.102     0.150
     5.329   141.559     0.150
     5.825    86.500     0.150
     5.887    89.422     0.150
     5.887   153.500     0.150
     5.928    89.941     0.150
     5.928   154.398     0.150
     5.962    90.398     0.150
     5.966    90.500     0.150
     5.966   159.602     0.150
     6.137    92.941     0.150
     6.137   160.941     0.150
     6.341    95.500     0.150
     6.341   164.621     0.150
     6.802   101.602     0.150
     7.041   105.398     0.150
     7.506   108.281     0.150
     7.506   189.211     0.150
     7.364   109.160     0.150
     7.364   189.441     0.150
     7.876   117.000     0.150
     8.018   117.980     0.150
     8.018   206.121     0.150
     8.045   118.262     0.150
     8.045   205.441     0.150
     8.423   126.348     0.150
     8.427   126.609     0.150
     8.438   126.754     0.150
     8.543   128.008     0.150
     8.516   127.375     0.150
     8.530   127.738     0.150
     8.535   127.738     0.150
     8.560   128.426     0.150
     8.567   128.504     0.150
     8.550   128.090     0.150
     8.575   128.871     0.150
    10.302   150.602     0.150
    12.371   304.000     0.150
    12.186   171.000     0.150
    12.186   302.000     0.150
    12.984   319.309     0.150
    14.019   196.410     0.150
    21.533   290.102     0.150
    23.671   312.199     0.150
    46.199   506.000     0.150
    49.221   529.102     0.150
    53.203   558.602     0.150
    72.954   688.898     0.150
    75.177   701.699     0.150
    81.622   738.602     0.150
     5.966    88.867     0.150
     5.966    88.867     0.150
     5.966    87.969     0.150
     5.966    87.406     0.150
     5.966    88.426     0.150
     5.966   156.062     0.150
     5.966   159.312     0.150
     5.966   158.883     0.150
     5.966   157.297     0.150
     1.679    28.742     0.150
     1.895    35.242     0.150
     2.003    35.102     0.150
     2.181    39.242     0.150
     2.609    41.941     0.150
     2.609    73.242     0.150
     2.593    48.043     0.150
     2.593    77.344     0.150
     3.013    51.742     0.150
     3.013    91.242     0.150
     2.828    46.844     0.150
     3.000    48.043     0.150
     3.255    51.602     0.150
     3.342    53.742     0.150
     3.342    91.742     0.150
     3.435    53.543     0.150
     3.435   102.742     0.150
     3.556    56.441     0.150
     3.556    96.941     0.150
     4.078    62.293     0.150
     4.078   108.312     0.150
     4.327    65.242     0.150
     4.327   135.242     0.150
     4.498    68.594     0.150
     4.498   119.293     0.150
     4.706    72.133     0.150
     4.706   123.773     0.150
     5.141   134.043     0.150
     5.340    80.914     0.150
     5.340   139.812     0.150
     5.775    85.242     0.150
     5.898    88.570     0.150
     5.898   152.094     0.150
     5.940    88.871     0.150
     5.940   153.094     0.150
     5.951    89.742     0.150
     5.956    89.242     0.150
     6.148    91.914     0.150
     6.148   158.473     0.150
     6.353    94.230     0.150
     6.353   163.434     0.150
     6.789    99.742     0.150
     7.030   102.641     0.150
     7.499   106.852     0.150
     7.499   189.004     0.150
     7.375   108.031     0.150
     7.375   187.152     0.150
     7.863   114.344     0.150
     8.030   116.914     0.150
     8.030   204.230     0.150
     8.058   117.152     0.150
     8.058   204.453     0.150
     8.356   124.301     0.150
     8.401   125.477     0.150
     8.962   131.203     0.150
     8.976   130.867     0.150
     9.014   131.941     0.150
     9.073   132.676     0.150
     9.152   132.520     0.150
     9.232   133.945     0.150
     9.251   133.773     0.150
     9.313   134.742     0.150
     9.313   235.242     0.150
    10.317   148.844     0.150
    12.198   169.742     0.150
    12.198   298.742     0.150
    12.364   171.242     0.150
    12.974   180.152     0.150
    12.974   181.242     0.150
    12.974   318.473     0.150
    13.125   181.242     0.150
    13.125   319.242     0.150
    14.010   194.254     0.150
    14.010   196.242     0.150
    14.010   342.203     0.150
    18.958   261.344     0.150
    21.036   281.742     0.150
    21.222   285.742     0.150
    21.544   288.941     0.150
    23.677   310.344     0.150
    24.386   318.844     0.150
    25.248   325.043     0.150
    35.677   419.344     0.150
    36.703   425.941     0.150
    38.791   442.941     0.150
    38.882     8.398     0.150
    46.195   504.242     0.150
    46.291   504.941     0.150
    46.611   507.141     0.150
    49.219   527.844     0.150
    53.198   556.441     0.150
    53.198   556.543     0.150
    56.667   581.742     0.150
    56.967   584.043     0.150
    57.180   586.344     0.150
    57.189   586.344     0.150
    57.327   587.043     0.150
    58.764   596.043     0.150
    58.913   597.543     0.150
    59.044   598.344     0.150
    59.208   599.441     0.150
    66.406   648.344     0.150
    72.963   688.043     0.150
    72.982   688.141     0.150
    75.185   700.441     0.150
    75.186   700.543     0.150
    77.095   712.441     0.150
    78.380   718.543     0.150
    85.710   757.043     0.150
    88.216   770.043     0.150
    49.219   527.574     0.150
    49.219   527.508     0.150
    49.219   527.574     0.150
     5.956    87.547     0.150
     5.956    87.547     0.150
     5.956    86.934     0.150
     0.830    14.402     0.150
     0.830    25.402     0.150
     1.633    29.703     0.150
     2.019    35.953     0.150
     2.019    62.094     0.150
     2.240    38.504     0.150
     2.240    66.102     0.150
     2.352    41.113     0.150
     2.475    42.301     0.150
     2.928    47.703     0.150
     2.991    50.602     0.150
     3.090    50.504     0.150
     3.090    95.301     0.150
     3.207    53.504     0.150
     3.207    98.902     0.150
     3.330    53.230     0.150
     3.602    57.133     0.150
     3.602    99.832     0.150
     4.423    67.691     0.150
     5.052    78.254     0.150
     5.052   134.191     0.150
     5.461    82.703     0.150
     5.602    85.902     0.150
     5.602   171.902     0.150
     5.607    85.602     0.150
     5.693    86.332     0.150
     5.693   150.371     0.150
     6.251    94.133     0.150
     6.251   161.691     0.150
     6.293    94.594     0.150
     6.293   164.574     0.150
     6.435    96.203     0.150
     6.501    97.371     0.150
     6.678    99.402     0.150
     6.707    99.711     0.150
     7.065   104.832     0.150
     7.728   112.672     0.150
     7.728   196.074     0.150
     8.384   122.094     0.150
     8.599   128.504     0.150
     8.650   128.719     0.150
     8.689   129.953     0.150
     8.712   129.930     0.150
     8.785   130.758     0.150
     8.844   132.078     0.150
     8.860   131.988     0.150
     8.868   132.410     0.150
     8.868   132.633     0.150
     8.873   132.965     0.150
     8.955   133.641     0.150
    10.648   156.902     0.150
    13.250   183.902     0.150
    13.250   324.902     0.150
    13.556   330.602     0.150
    14.029   195.902     0.150
    21.476   288.402     0.150
    21.895   294.004     0.150
    23.589   310.504     0.150
    25.526   329.203     0.150
    27.491   347.742     0.150
    35.822   420.602     0.150
    36.735   428.203     0.150
    38.683   443.703     0.150
    48.969   526.602     0.150
    62.081   620.602     0.150
    73.308   691.602     0.150
    73.324   691.902     0.150
    75.524   704.203     0.150
    75.526   704.004     0.150
    86.478   761.301     0.150
     1.137    19.617     0.150
     1.137    36.617     0.150
     1.544    25.844     0.150
     2.301    42.117     0.150
     2.575    41.914     0.150
     2.575    72.914     0.150
     2.645    45.516     0.150
     2.704    44.320     0.150
     2.862    45.469     0.150
     2.968    47.117     0.150
     2.950    46.117     0.150
     2.950    92.117     0.150
     3.126    49.344     0.150
     3.280    53.516     0.150
     3.468    55.320     0.150
     3.565    95.617     0.150
     3.684    58.914     0.150
     4.460    68.117     0.150
     4.575    68.859     0.150
     4.661    78.414     0.150
     5.029    73.867     0.150
     5.029   130.070     0.150
     5.220    77.773     0.150
     5.743    83.820     0.150
     5.743   149.016     0.150
     5.776    85.234     0.150
     5.821    85.734     0.150
     5.914    89.914     0.150
     6.027    88.258     0.150
     6.079    91.719     0.150
     6.079   159.719     0.150
     6.083    90.617     0.150
     6.238    91.516     0.150
     6.901   101.719     0.150
     7.154   105.117     0.150
     7.396   105.109     0.150
     7.396   185.234     0.150
     7.396   186.961     0.150
     7.541   110.719     0.150
     7.912   114.359     0.150
     7.957   117.016     0.150
     8.289   123.844     0.150
     8.343   124.492     0.150
     8.385   125.227     0.150
     8.407   125.625     0.150
     8.410   124.898     0.150
     8.423   125.203     0.150
     8.419   125.727     0.150
     8.454   126.031     0.150
     8.463   126.578     0.150
     8.479   126.320     0.150
     8.514   126.445     0.150
     8.518   125.523     0.150
     8.521   126.727     0.150
     8.525   126.188     0.150
     8.538   125.914     0.150
     8.538   126.102     0.150
     8.544   126.633     0.150
     8.543   127.398     0.150
     8.553   127.031     0.150
     8.563   126.250     0.150
     8.616   127.883     0.150
     8.688   127.969     0.150
     8.914   130.742     0.150
     8.957   131.148     0.150
     8.966   130.352     0.150
     9.101   132.672     0.150
     9.101   236.344     0.150
     9.181   133.695     0.150
     9.190   133.602     0.150
     9.208   237.359     0.150
     9.258   134.586     0.150
     9.258   237.836     0.150
     9.290   138.250     0.150
     9.322   135.320     0.150
     9.322   240.289     0.150
     9.338   135.352     0.150
     9.338   241.125     0.150
     9.451   136.414     0.150
     9.451   514.117     0.150
     9.451   723.117     0.150
     9.451   726.117     0.150
     9.451   936.117     0.150
    10.006   144.258     0.150
    10.006   256.734     0.150
    10.241   147.117     0.150
    10.241   146.719     0.150
    10.730   151.320     0.150
    10.730   271.117     0.150
    10.678   153.594     0.150
    11.249   159.914     0.150
    11.253   158.734     0.150
    12.087   169.016     0.150
    12.087   297.117     0.150
    12.259   169.117     0.150
    12.259   299.117     0.150
    12.891   180.219     0.150
    12.891   518.328     0.150
    12.763   180.117     0.150
    12.763   179.711     0.150
    12.957   182.117     0.150
    13.006   178.320     0.150
    12.931   183.117     0.150
    12.931   322.117     0.150
    12.919   183.117     0.150
    13.188   322.914     0.150
    13.920   193.094     0.150
    13.920   194.859     0.150
    14.884   208.617     0.150
    14.884   216.117     0.150
    14.884   374.117     0.150
    14.884   208.406     0.150
    15.742   214.516     0.150
    15.742   383.516     0.150
    17.595   243.117     0.150
    17.595   437.117     0.150
    18.894   259.117     0.150
    18.966   259.117     0.150
    20.241   273.719     0.150
    20.771   281.117     0.150
    20.980   281.914     0.150
    21.206   284.180     0.150
    21.206   285.055     0.150
    21.206   283.945     0.150
    21.200   284.617     0.150
    21.200   311.117     0.150
    21.200   515.117     0.150
    21.200   530.117     0.150
    21.339   287.117     0.150
    21.339   535.617     0.150
    21.339   548.117     0.150
    21.339   751.117     0.150
    21.339   285.992     0.150
    21.339   311.117     0.150
    21.339   535.516     0.150
    21.956   293.023     0.150
    21.956   531.680     0.150
    23.330   307.117     0.150
    23.330   559.117     0.150
    23.535   308.117     0.150
    23.535   308.898     0.150
    23.789   311.617     0.150
    24.307   317.414     0.150
    24.307   573.117     0.150
    24.307   981.117     0.150
    24.524   317.117     0.150
    25.212   324.117     0.150
    25.212   323.836     0.150
    26.007   333.117     0.150
    26.007   603.117     0.150
    25.960   331.359     0.150
    26.551   337.320     0.150
    26.771   339.117     0.150
    26.806   340.617     0.150
    27.421   346.719     0.150
    27.408   345.273     0.150
    27.408   345.938     0.150
    27.778   348.516     0.150
    27.778   348.766     0.150
    28.004   351.617     0.150
    28.004   636.117     0.150
    28.248   402.117     0.150
    28.248   541.117     0.150
    28.225   352.414     0.150
    28.225   637.117     0.150
    28.438   354.320     0.150
    28.438     6.797     0.150
    28.438   399.117     0.150
    28.438   727.117     0.150
    29.520   366.117     0.150
    29.435   363.617     0.150
    29.435   752.117     0.150
    29.837   365.617     0.150
    29.791   366.617     0.150
    29.791   419.117     0.150
    29.791   671.117     0.150
    30.075   368.617     0.150
    30.075   667.117     0.150
    30.661   375.016     0.150
    30.781   377.117     0.150
    30.781   680.117     0.150
    30.871   376.414     0.150
    31.130   378.117     0.150
    31.130   682.117     0.150
    31.350   381.219     0.150
    31.350   380.422     0.150
    31.358   381.117     0.150
    31.358   445.117     0.150
    31.358   685.117     0.150
    31.358   794.117     0.150
    31.358  1010.117     0.150
    31.648   382.820     0.150
    31.648   691.117     0.150
    31.893   384.945     0.150
    31.893   385.109     0.150
    31.893   385.820     0.150
    31.893   695.719     0.150
    31.904   386.117     0.150
    31.904   451.117     0.150
    31.904   693.117     0.150
    31.925   384.914     0.150
    32.130   387.320     0.150
    32.858   394.516     0.150
    33.077   394.117     0.150
    33.671   400.617     0.150
    33.671   475.117     0.150
    33.671   723.117     0.150
    33.935   403.117     0.150
    33.935     9.000     0.150
    33.935   475.117     0.150
    33.935   723.117     0.150
    34.458   408.719     0.150
    34.508   409.117     0.150
    35.042   412.617     0.150
    35.042   491.117     0.150
    35.042   743.117     0.150
    35.150   414.219     0.150
    35.355   416.117     0.150
    35.505   417.117     0.150
    35.505   751.117     0.150
    35.603   419.117     0.150
    35.634   419.117     0.150
    35.751   419.117     0.150
    35.751   494.117     0.150
    35.751   891.117     0.150
    35.709   419.219     0.150
    35.709   418.148     0.150
    35.746   418.117     0.150
    35.746   754.125     0.150
    35.746   894.117     0.150
    35.746   754.516     0.150
    35.787   419.117     0.150
    35.787   767.117     0.150
    35.787   917.117     0.150
    35.965   420.820     0.150
    36.225   423.617     0.150
    36.266   421.617     0.150
    36.352   423.117     0.150
    36.481   426.414     0.150
    36.778   427.016     0.150
    37.039   431.867     0.150
    37.094   429.117     0.150
    37.094   517.117     0.150
    37.192   432.727     0.150
    37.210   433.008     0.150
    37.224   433.148     0.150
    37.285   432.617     0.150
    37.306   433.719     0.150
    37.359   432.914     0.150
    37.435   434.859     0.150
    37.486   435.984     0.150
    37.493   434.516     0.150
    37.496   435.844     0.150
    37.528   434.914     0.150
    37.583   435.719     0.150
    37.641   436.984     0.150
    37.643   436.695     0.150
    37.640   436.844     0.150
    37.717   436.984     0.150
    37.882   438.117     0.150
    37.894   439.117     0.150
    37.931   438.570     0.150
    37.939   438.547     0.150
    37.952   436.914     0.150
    38.069   439.719     0.150
    38.108   440.117     0.150
    38.108   439.117     0.150
    38.108   789.117     0.150
    38.161   441.805     0.150
    38.153   440.320     0.150
    38.258   440.719     0.150
    38.265   441.789     0.150
    38.279   441.414     0.150
    38.336   441.320     0.150
    38.344   441.914     0.150
    38.377   442.016     0.150
    38.349   441.117     0.150
    38.547   443.789     0.150
    38.530   442.320     0.150
    38.710   444.734     0.150
    38.599   441.617     0.150
    38.599   529.117     0.150
    38.730   445.219     0.150
    38.730   444.266     0.150
    38.703   445.117     0.150
    38.703   574.117     0.150
    38.703   798.117     0.150
    38.703   965.117     0.150
    38.703  1053.117     0.150
    38.798   446.016     0.150
    38.863   446.016     0.150
    39.023   445.320     0.150
    39.023   445.867     0.150
    39.023   446.320     0.150
    39.023     6.500     0.150
    39.023   540.820     0.150
    39.023   803.617     0.150
    39.121   448.820     0.150
    39.491   448.805     0.150
    39.491   449.188     0.150
    39.543   452.117     0.150
    39.542   450.516     0.150
    40.037   454.820     0.150
    40.564   459.516     0.150
    40.849   461.117     0.150
    41.274   466.117     0.150
    41.295   465.117     0.150
    41.370   465.719     0.150
    41.438   465.719     0.150
    41.453   465.820     0.150
    41.509   469.320     0.150
    41.745   468.516     0.150
    41.745   469.539     0.150
    41.637   467.617     0.150
    41.659   466.914     0.150
    41.621   466.617     0.150
    41.621   562.117     0.150
    41.621   467.758     0.150
    41.691   468.117     0.150
    41.825   472.117     0.150
    42.010   471.117     0.150
    41.985   471.117     0.150
    41.985   569.117     0.150
    42.064   471.016     0.150
    42.131   472.016     0.150
    42.173   471.250     0.150
    42.350   474.117     0.150
    42.398   474.117     0.150
    42.547   475.719     0.150
    42.555   475.617     0.150
    42.662   854.617     0.150
    42.599   476.320     0.150
    42.651   477.117     0.150
    42.875   478.914     0.150
    43.143   483.117     0.150
    43.216   480.414     0.150
    43.283   481.117     0.150
    43.268   482.117     0.150
    43.268   584.117     0.150
    43.268   592.117     0.150
    43.268   867.117     0.150
    43.364   482.117     0.150
    43.417   481.914     0.150
    43.417  1072.125     0.150
    43.417  1072.617     0.150
    43.475   485.117     0.150
    43.812   485.320     0.150
    43.824   485.117     0.150
    43.824   592.117     0.150
    43.824   875.117     0.150
    43.824  1061.117     0.150
    43.923   486.617     0.150
    43.903   487.117     0.150
    43.903   487.906     0.150
    43.946   487.086     0.150
    44.204   490.117     0.150
    44.323   489.719     0.150
    44.523   493.211     0.150
    44.644   492.914     0.150
    44.756   493.000     0.150
    44.896   493.688     0.150
    45.052   496.164     0.150
    45.189   495.547     0.150
    45.189   495.117     0.150
    45.189   597.117     0.150
    45.189   603.117     0.150
    45.189   894.117     0.150
    45.189  1086.117     0.150
    45.377   499.117     0.150
    45.377   897.117     0.150
    45.557   499.500     0.150
    45.639   499.117     0.150
    45.643   499.117     0.150
    45.643   605.125     0.150
    45.643   895.125     0.150
    45.643   499.242     0.150
    45.643   605.914     0.150
    45.643   895.914     0.150
    45.643  1092.617     0.150
    45.760   500.719     0.150
    45.780   501.438     0.150
    45.829   502.008     0.150
    45.952   503.570     0.150
    45.952   502.117     0.150
    45.996   503.117     0.150
    45.987   503.000     0.150
    46.098   503.117     0.150
    46.280   505.227     0.150
    46.298   504.914     0.150
    46.299   504.961     0.150
    46.304   505.219     0.150
    46.304     5.297     0.150
    46.304   597.414     0.150
    46.304   613.516     0.150
    46.304   911.016     0.150
    46.304  1099.914     0.150
    46.304  1110.719     0.150
    46.304   504.188     0.150
    46.393   506.117     0.150
    46.338   504.914     0.150
    46.434   505.516     0.150
    46.529   915.117     0.150
    46.692   508.156     0.150
    46.718   508.156     0.150
    46.753   508.219     0.150
    46.975   509.797     0.150
    47.310   513.117     0.150
    47.431   515.117     0.150
    47.431   604.719     0.150
    47.431   625.719     0.150
    47.431   928.516     0.150
    47.484   515.195     0.150
    47.547   515.617     0.150
    47.610   515.117     0.150
    47.791   517.617     0.150
    47.880   516.320     0.150
    48.063   519.180     0.150
    48.121   518.516     0.150
    48.121     6.203     0.150
    48.121   631.914     0.150
    48.121   935.820     0.150
    48.342   520.797     0.150
    48.363   521.664     0.150
    48.440   520.438     0.150
    48.551   522.617     0.150
    48.663   525.117     0.150
    48.663   636.117     0.150
    48.663   947.117     0.150
    48.686   524.625     0.150
    48.742   525.117     0.150
    48.740   524.617     0.150
    48.793   523.922     0.150
    48.793   944.117     0.150
    48.795   524.820     0.150
    48.877   524.469     0.150
    48.939   524.609     0.150
    49.019   526.117     0.150
    49.042   529.117     0.150
    48.971   525.156     0.150
    48.971   525.469     0.150
    49.027   525.961     0.150
    49.107   527.914     0.150
    49.152   528.414     0.150
    49.152   643.617     0.150
    49.152   953.117     0.150
    49.185   528.117     0.150
    49.185   647.117     0.150
    49.209   527.094     0.150
    49.349   528.320     0.150
    49.360   528.719     0.150
    49.435   528.805     0.150
    49.578   529.320     0.150
    49.578   530.594     0.150
    49.925   532.914     0.150
    49.925   964.617     0.150
    49.925  1124.016     0.150
    49.925  1185.117     0.150
    49.925   964.516     0.150
    49.914   531.773     0.150
    49.914     6.297     0.150
    50.008   532.719     0.150
    50.320   537.016     0.150
    50.356   536.414     0.150
    50.356   654.117     0.150
    50.356   968.617     0.150
    50.445   536.914     0.150
    50.608   538.016     0.150
    50.906   541.117     0.150
    50.774   539.016     0.150
    50.774     8.102     0.150
    50.774   971.117     0.150
    50.774  1127.117     0.150
    50.774  1191.117     0.150
    50.774   538.906     0.150
    50.774     8.203     0.150
    50.863   541.414     0.150
    50.863   977.117     0.150
    50.869   537.617     0.150
    51.053   541.617     0.150
    51.191   543.758     0.150
    51.183   542.820     0.150
    51.212   544.148     0.150
    51.309   544.320     0.150
    51.377   545.320     0.150
    51.413   544.016     0.150
    51.406   545.406     0.150
    51.465   545.414     0.150
    51.509   545.117     0.150
    51.509     7.000     0.150
    51.509   616.016     0.150
    51.509   664.219     0.150
    51.509   986.016     0.150
    51.509  1134.117     0.150
    51.509  1205.117     0.150
    51.556   546.117     0.150
    51.575   547.117     0.150
    51.563   544.234     0.150
    51.647   546.719     0.150
    51.647   546.594     0.150
    51.788   547.320     0.150
    51.826   548.117     0.150
    51.843   547.719     0.150
    51.843   670.117     0.150
    51.843   992.516     0.150
    51.843  1140.117     0.150
    51.843   547.570     0.150
    51.849   547.320     0.150
    51.853   547.914     0.150
    51.853   663.117     0.150
    51.853   989.617     0.150
    51.853  1001.914     0.150
    51.853  1137.617     0.150
    51.958   549.664     0.150
    51.968   549.414     0.150
    51.984   548.914     0.150
    51.980   549.516     0.150
    51.987   549.219     0.150
    52.082   549.617     0.150
    52.103   546.336     0.150
    52.103   549.508     0.150
    52.138   549.914     0.150
    52.138   549.617     0.150
    52.135   549.648     0.150
    52.256   550.617     0.150
    52.195   550.117     0.150
    52.195   997.117     0.150
    52.195  1139.117     0.150
    52.293   550.320     0.150
    52.344   552.117     0.150
    52.422   552.117     0.150
    52.410   551.414     0.150
    52.410   996.117     0.150
    52.410  1139.117     0.150
    52.410   551.250     0.150
    52.422   551.516     0.150
    52.549   552.320     0.150
    52.625   554.188     0.150
    52.602   554.820     0.150
    52.602   675.117     0.150
    52.602  1001.117     0.150
    52.636   555.719     0.150
    52.621   553.016     0.150
    52.652   554.016     0.150
    52.652   553.844     0.150
    52.730   554.320     0.150
    52.730  1229.914     0.150
    52.936   556.016     0.150
    52.990   555.414     0.150
    53.061   556.820     0.150
    53.064   557.914     0.150
    53.117   555.375     0.150
    53.117     8.125     0.150
    53.179   557.914     0.150
    53.195   557.617     0.150
    53.250   558.258     0.150
    53.307   558.320     0.150
    53.313   558.516     0.150
    53.332   559.547     0.150
    53.333   558.617     0.150
    53.333   558.516     0.150
    53.333  1019.117     0.150
    53.333  1149.117     0.150
    53.362   558.719     0.150
    53.340   557.617     0.150
    53.340   557.516     0.150
    53.426   560.094     0.150
    53.429   560.094     0.150
    53.439   559.984     0.150
    53.479   560.625     0.150
    53.524   560.391     0.150
    53.541   560.711     0.150
    53.567   559.914     0.150
    53.550   560.516     0.150
    53.554   560.547     0.150
    53.603   560.414     0.150
    53.590   560.867     0.150
    53.604   561.914     0.150
    53.605   561.750     0.150
    53.664   561.227     0.150
    53.676   562.016     0.150
    53.676  1017.117     0.150
    53.676   561.586     0.150
    53.684   560.219     0.150
    53.700   560.516     0.150
    53.715   560.117     0.150
    53.789   561.414     0.150
    53.812   562.516     0.150
    53.812  1016.820     0.150
    53.812   562.617     0.150
    53.840   561.820     0.150
    53.978   562.219     0.150
    54.009   565.117     0.150
    54.008   563.359     0.150
    54.037   564.617     0.150
    54.032   562.516     0.150
    54.059   564.320     0.150
    54.132   565.320     0.150
    54.112   562.859     0.150
    54.112   563.305     0.150
    54.112     8.336     0.150
    54.112   683.930     0.150
    54.112  1023.375     0.150
    54.112  1235.320     0.150
    54.112   563.039     0.150
    54.151   563.914     0.150
    54.408   567.117     0.150
    54.408   691.117     0.150
    54.408  1015.320     0.150
    54.408  1253.320     0.150
    54.510   566.766     0.150
    54.664   568.016     0.150
    54.655   567.516     0.150
    54.684   568.820     0.150
    54.761   568.820     0.150
    54.777   568.516     0.150
    54.866   569.914     0.150
    54.988   570.414     0.150
    54.991   570.117     0.150
    54.948   569.914     0.150
    54.948   693.125     0.150
    54.948  1028.117     0.150
    54.948   693.820     0.150
    55.012   569.320     0.150
    55.106   571.695     0.150
    55.120   571.469     0.150
    55.120     7.742     0.150
    55.230   571.914     0.150
    55.259   571.719     0.150
    55.282   572.016     0.150
    55.383   573.516     0.150
    55.393   573.719     0.150
    55.393   700.516     0.150
    55.393  1040.820     0.150
    55.393   573.898     0.150
    55.473   574.516     0.150
    55.522   573.719     0.150
    55.581   575.617     0.150
    55.568   574.891     0.150
    55.609   574.500     0.150
    55.609     6.438     0.150
    55.720   575.414     0.150
    55.720   574.719     0.150
    55.725   575.117     0.150
    55.675   574.617     0.150
    55.675   632.125     0.150
    55.675   704.117     0.150
    55.675  1042.125     0.150
    55.675  1160.125     0.150
    55.675   632.617     0.150
    55.675  1042.617     0.150
    55.675  1160.617     0.150
    55.740   575.016     0.150
    55.718   575.969     0.150
    55.718     5.906     0.150
    55.740   574.219     0.150
    55.740   575.219     0.150
    55.740   575.359     0.150
    55.753   575.516     0.150
    55.752   577.117     0.150
    55.752   576.320     0.150
    55.782     9.438     0.150
    55.835   575.617     0.150
    55.886   577.914     0.150
    55.913   576.719     0.150
    55.984   577.156     0.150
    55.983   577.219     0.150
    56.002   577.930     0.150
    56.015   577.617     0.150
    56.022   577.219     0.150
    56.014   578.438     0.150
    56.014     4.656     0.150
    56.014  1047.906     0.150
    56.071   577.914     0.150
    56.071   579.219     0.150
    56.167   580.117     0.150
    56.185   579.617     0.150
    56.185  1049.117     0.150
    56.216   577.258     0.150
    56.216   695.555     0.150
    56.216  1045.219     0.150
    56.248   580.617     0.150
    56.339   578.414     0.150
    56.355   580.016     0.150
    56.372   579.820     0.150
    56.349   580.578     0.150
    56.349     4.148     0.150
    56.373   579.914     0.150
    56.369   580.914     0.150
    56.420   579.617     0.150
    56.420   580.414     0.150
    56.426   580.914     0.150
    56.438   580.078     0.150
    56.439   579.516     0.150
    56.467   580.516     0.150
    56.479   579.641     0.150
    56.479     6.727     0.150
    56.540   581.320     0.150
    56.559   581.234     0.150
    56.629   582.500     0.150
    56.645   582.320     0.150
    56.755   583.164     0.150
    56.747   583.117     0.150
    56.768   582.875     0.150
    56.801   582.320     0.150
    56.883   583.797     0.150
    56.905   584.859     0.150
    56.906   584.836     0.150
    56.906   709.586     0.150
    56.906  1059.578     0.150
    56.906  1172.430     0.150
    56.942   585.086     0.150
    56.942   584.875     0.150
    56.989   585.328     0.150
    57.007   584.820     0.150
    57.028   584.391     0.150
    57.065   586.617     0.150
    57.075   585.516     0.150
    57.091   584.391     0.150
    57.098   585.617     0.150
    57.102   584.516     0.150
    57.109   585.906     0.150
    57.153   587.414     0.150
    57.172   585.789     0.150
    57.173   584.719     0.150
    57.250   587.719     0.150
    57.264   586.500     0.150
    57.312   586.820     0.150
    57.321   586.820     0.150
    57.360   588.414     0.150
    57.369   588.516     0.150
    57.454   588.516     0.150
    57.458   586.719     0.150
    57.481   589.586     0.150
    57.541   588.219     0.150
    57.586   590.320     0.150
    57.715   589.320     0.150
    57.800   589.320     0.150
    57.860   590.367     0.150
    57.860   591.508     0.150
    57.949   590.320     0.150
    57.983   592.039     0.150
    58.036   590.820     0.150
    58.059   593.477     0.150
    58.113   592.016     0.150
    58.879   598.820     0.150
    58.886   597.320     0.150
    58.898   596.719     0.150
    59.000   596.117     0.150
    59.000   645.117     0.150
    59.000   729.117     0.150
    59.000  1073.117     0.150
    59.047   598.016     0.150
    59.178   598.914     0.150
    59.342   600.016     0.150
    59.349   602.117     0.150
    59.405   602.578     0.150
    59.641   602.820     0.150
    59.662   604.219     0.150
    59.708   603.117     0.150
    59.699   604.234     0.150
    59.735   602.820     0.150
    59.744   605.211     0.150
    59.779   605.320     0.150
    59.781   604.961     0.150
    59.817   605.516     0.150
    60.073   605.117     0.150
    60.073   740.117     0.150
    60.227   606.617     0.150
    60.218   607.820     0.150
    60.218   607.320     0.150
    60.239   608.219     0.150
    60.239   607.641     0.150
    60.351   608.219     0.150
    60.474   609.016     0.150
    60.501   609.258     0.150
    60.492   609.359     0.150
    60.550   609.578     0.150
    60.667   609.820     0.150
    60.742   611.320     0.150
    60.747   611.266     0.150
    60.751   610.773     0.150
    60.752   610.961     0.150
    60.758   611.320     0.150
    60.758   611.094     0.150
    60.865   612.516     0.150
    60.860   612.117     0.150
    60.860   611.828     0.150
    60.860   612.516     0.150
    60.860   612.039     0.150
    60.866   611.820     0.150
    60.881   611.594     0.150
    60.905   611.898     0.150
    60.915   612.055     0.150
    60.950   613.617     0.150
    60.944   611.820     0.150
    60.950   611.891     0.150
    60.950   612.750     0.150
    60.961   612.898     0.150
    60.933   611.117     0.150
    60.933   754.086     0.150
    60.933  1110.555     0.150
    60.960   613.109     0.150
    60.979   611.719     0.150
    60.965   612.188     0.150
    61.005   612.617     0.150
    61.005   612.516     0.150
    61.004   612.844     0.150
    61.080   613.617     0.150
    61.072   613.328     0.150
    61.091   613.117     0.150
    61.090   613.078     0.150
    61.195   612.516     0.150
    61.193   614.461     0.150
    61.203   613.969     0.150
    61.229   614.820     0.150
    61.227   614.789     0.150
    61.241   614.773     0.150
    61.263   614.438     0.150
    61.272   614.617     0.150
    61.272   614.508     0.150
    61.305   616.016     0.150
    61.318   614.820     0.150
    61.318   614.719     0.150
    61.350   614.859     0.150
    61.384   613.617     0.150
    61.407   615.711     0.150
    61.419   615.219     0.150
    61.423   616.016     0.150
    61.423   615.516     0.150
    61.429   615.727     0.150
    61.434   614.844     0.150
    61.434     6.297     0.150
    61.434   614.117     0.150
    61.452   615.656     0.150
    61.463   614.719     0.150
    61.463   615.359     0.150
    61.474   615.750     0.150
    61.504   616.414     0.150
    61.479   615.898     0.150
    61.485   615.820     0.150
    61.521   616.078     0.150
    61.530   616.258     0.150
    61.571   615.914     0.150
    61.573   616.828     0.150
    61.597   617.719     0.150
    61.618   617.000     0.150
    61.619   616.664     0.150
    61.682   617.430     0.150
    61.683   617.438     0.150
    61.689   617.641     0.150
    61.722   616.117     0.150
    61.721   616.016     0.150
    61.746   617.969     0.150
    61.773   618.039     0.150
    61.777   617.914     0.150
    61.805   618.086     0.150
    61.809   618.258     0.150
    61.837   618.594     0.150
    61.865   618.516     0.150
    61.853   618.414     0.150
    61.853   618.219     0.150
    61.892   618.656     0.150
    61.889   618.914     0.150
    61.889   618.648     0.150
    61.934   619.141     0.150
    61.947   619.039     0.150
    61.956   619.219     0.150
    61.980   619.359     0.150
    62.018   619.625     0.150
    62.056   619.891     0.150
    62.061   620.156     0.150
    62.096   620.125     0.150
    62.098   620.023     0.150
    62.108   619.914     0.150
    62.108   619.711     0.150
    62.136   620.414     0.150
    62.133   620.008     0.150
    62.137   619.805     0.150
    62.144   620.109     0.150
    62.191   620.688     0.150
    62.231   620.789     0.150
    62.262   620.586     0.150
    62.275   621.117     0.150
    62.292   621.664     0.150
    62.292   620.414     0.150
    62.292   620.906     0.150
    62.280   621.180     0.150
    62.298   621.117     0.150
    62.298   620.828     0.150
    62.314   622.398     0.150
    62.422   621.219     0.150
    62.422   620.969     0.150
    62.322   621.461     0.150
    62.349   621.219     0.150
    62.351   621.766     0.150
    62.364   621.617     0.150
    62.364   621.398     0.150
    62.384   620.414     0.150
    62.364   621.945     0.150
    62.411   622.164     0.150
    62.416   622.586     0.150
    62.451   623.695     0.150
    62.443   622.719     0.150
    62.443   622.484     0.150
    62.411   621.414     0.150
    62.411  1127.117     0.150
    62.411  2370.117     0.150
    62.484   623.211     0.150
    62.517   623.109     0.150
    62.536   622.938     0.150
    62.548   623.414     0.150
    62.548   623.250     0.150
    62.566   624.414     0.150
    62.569   624.219     0.150
    62.569   623.461     0.150
    62.575   623.180     0.150
    62.648   624.719     0.150
    62.648  1124.914     0.150
    62.629   623.727     0.150
    62.650   624.695     0.150
    62.658   624.141     0.150
    62.705   624.516     0.150
    62.693   624.125     0.150
    62.725   624.266     0.150
    62.722   624.391     0.150
    62.742   624.719     0.150
    62.742   624.547     0.150
    62.781   624.930     0.150
    62.812   625.156     0.150
    62.849   623.914     0.150
    62.886   625.836     0.150
    62.883   625.617     0.150
    62.883   625.320     0.150
    62.937   626.617     0.150
    62.997   627.117     0.150
    62.997   658.516     0.150
    63.054   625.914     0.150
    63.084   627.914     0.150
    63.096   627.320     0.150
    63.148   627.047     0.150
    63.222   627.820     0.150
    63.270   627.773     0.150
    63.285   626.617     0.150
    63.312   629.414     0.150
    63.336   626.719     0.150
    63.437   629.414     0.150
    63.454   628.516     0.150
    63.537   630.000     0.150
    63.650   630.820     0.150
    63.650  1139.414     0.150
    63.724   630.523     0.150
    63.786   631.945     0.150
    63.786   631.727     0.150
    63.861   632.719     0.150
    63.906   633.414     0.150
    63.919   631.820     0.150
    63.936   632.023     0.150
    63.947   631.930     0.150
    63.947   632.164     0.150
    63.950   632.820     0.150
    63.950   632.148     0.150
    63.973   632.336     0.150
    63.978   632.094     0.150
    63.979   632.438     0.150
    64.000   632.445     0.150
    64.086   634.320     0.150
    64.206   633.719     0.150
    64.274   635.617     0.150
    64.399   635.117     0.150
    64.338   635.719     0.150
    64.338   664.914     0.150
    64.390   636.617     0.150
    64.510   636.820     0.150
    64.510  1150.117     0.150
    64.770   638.414     0.150
    64.770  1152.016     0.150
    65.090   640.344     0.150
    65.308   642.320     0.150
    65.308   670.820     0.150
    65.730   642.516     0.150
    65.730   643.148     0.150
    65.836   645.617     0.150
    65.836   674.219     0.150
    66.192   647.820     0.150
    66.192   677.617     0.150
    66.206   647.617     0.150
    66.206   675.219     0.150
    66.224   644.617     0.150
    66.224   673.617     0.150
    66.224   793.617     0.150
    66.224  1174.117     0.150
    66.224  1198.117     0.150
    66.224  1237.117     0.150
    66.330   678.414     0.150
    66.330  1171.820     0.150
    66.534   648.820     0.150
    66.534  1174.516     0.150
    66.534   649.516     0.150
    66.534   679.414     0.150
    66.534  1174.219     0.150
    66.679  1178.820     0.150
    66.858   651.391     0.150
    66.946   652.516     0.150
    67.108   653.320     0.150
    67.270   654.719     0.150
    67.381   654.516     0.150
    67.381   685.016     0.150
    67.522   655.414     0.150
    67.522  1186.219     0.150
    67.551   656.617     0.150
    67.551   686.719     0.150
    67.591   655.320     0.150
    67.591  1187.820     0.150
    67.801   658.320     0.150
    67.801   688.016     0.150
    67.912   658.719     0.150
    68.065   657.617     0.150
    68.146   660.117     0.150
    68.146   690.414     0.150
    68.174   660.117     0.150
    68.584   663.016     0.150
    68.854   663.117     0.150
    68.832   663.414     0.150
    68.832  1201.516     0.150
    68.824   665.820     0.150
    68.824   664.867     0.150
    68.961   664.617     0.150
    68.961   695.016     0.150
    68.991   665.320     0.150
    69.336   667.320     0.150
    69.568   669.414     0.150
    69.740   669.914     0.150
    69.977   671.617     0.150
    70.129   675.117     0.150
    70.129  1227.117     0.150
    70.348   672.117     0.150
    70.314   673.914     0.150
    70.318   673.617     0.150
    70.361   673.719     0.150
    70.559   674.914     0.150
    70.604   676.117     0.150
    70.622   675.414     0.150
    70.625   676.516     0.150
    70.625  1231.117     0.150
    70.784   676.617     0.150
    70.792   676.914     0.150
    71.034   677.719     0.150
    71.253   677.617     0.150
    71.205   677.516     0.150
    71.668   679.719     0.150
    72.520   685.414     0.150
    72.520   683.727     0.150
    72.833   688.117     0.150
    74.160   696.914     0.150
    74.591   699.320     0.150
    75.051  1273.617     0.150
    75.052   700.516     0.150
    75.052   699.430     0.150
    75.596   703.000     0.150
    75.772   704.008     0.150
    76.110   707.219     0.150
    76.110   708.281     0.150
    76.487   710.016     0.150
    77.053   711.977     0.150
    78.073   719.117     0.150
    78.082   717.117     0.150
    78.082   717.242     0.150
    78.130   717.391     0.150
    78.130   717.289     0.150
    78.222   719.383     0.150
    78.353   719.914     0.150
    78.445   720.820     0.150
    78.542   719.305     0.150
    78.869   723.414     0.150
    80.251   728.344     0.150
    80.516   732.516     0.150
    80.754   732.516     0.150
    80.907   733.594     0.150
    80.905   734.617     0.150
    81.588   737.117     0.150
    81.588   737.305     0.150
    81.686   738.016     0.150
    81.739   738.445     0.150
    81.839   738.945     0.150
    82.054   739.945     0.150
    81.965   737.961     0.150
    82.190   741.617     0.150
    82.427   743.117     0.150
    82.427   931.117     0.150
    82.427  1358.117     0.150
    82.427  1682.117     0.150
    82.528   743.117     0.150
    82.528  1359.117     0.150
    82.528  1675.117     0.150
    83.070   747.117     0.150
    83.070  1375.117     0.150
    83.548   747.219     0.150
    83.548   747.695     0.150
    85.575   756.414     0.150
    85.769   759.117     0.150
    86.718   763.180     0.150
    86.693   761.320     0.150
    88.022   769.656     0.150
    90.212   779.117     0.150
    91.543   787.414     0.150
    91.543  1430.219     0.150
    92.795   792.219     0.150
    93.151   790.117     0.150
    93.151  1022.117     0.150
    93.151  1428.117     0.150
    93.151  1456.117     0.150
    93.841   796.406     0.150
    95.157   801.453     0.150
    97.266   815.117     0.150
    97.266   824.117     0.150
    97.266  1053.117     0.150
    97.266  1447.117     0.150
    98.548   814.516     0.150
    98.492   817.016     0.150
    98.797   817.758     0.150
    99.537   821.719     0.150
   100.131   825.656     0.150
   100.446   826.406     0.150
   103.325   839.320     0.150
   106.673  1105.141     0.150
   107.586   860.266     0.150
   107.901  1106.844     0.150
   109.540  1111.164     0.150
   113.600  1118.594     0.150
   115.000  1120.891     0.150
   115.127  1120.500     0.150
   116.195  1121.219     0.150
   116.195  1766.117     0.150
   116.836  1123.984     0.150
   117.406  1126.016     0.150
   118.201  1127.320     0.150
   118.989  1126.898     0.150
   119.751  1129.867     0.150
   120.289  1128.516     0.150
   120.469  1130.844     0.150
   128.260  1147.844     0.150
   128.260  1154.156     0.150
   129.230  1147.797     0.150
   129.230  1155.797     0.150
   129.803  1150.180     0.150
   129.803  1150.016     0.150
   130.533  1151.727     0.150
   130.533  1287.250     0.150
   130.533  1353.711     0.150
   130.479  1153.117     0.150
   130.559  1151.250     0.150
   130.722  1153.117     0.150
   130.940  1153.273     0.150
   131.418  1153.414     0.150
   136.835  1332.117     0.150
   143.982  1175.117     0.150
   147.841  1184.820     0.150
   149.958  1187.117     0.150
   151.300  1187.297     0.150
   152.265  1188.320     0.150
   152.435  1190.117     0.150
   152.548  1197.914     0.150
   152.633  1189.414     0.150
   152.890  1186.320     0.150
   153.590  1188.719     0.150
   154.119  1192.969     0.150
   154.443  1193.070     0.150
   154.729  1192.445     0.150
     1.006    19.359     0.150
     1.006    32.375     0.150
     1.136    21.242     0.150
     1.136    35.945     0.150
     2.033    38.242     0.150
     2.338    42.242     0.150
     2.490    40.945     0.150
     2.490    73.445     0.150
     2.529    43.266     0.150
     2.529    76.000     0.150
     2.595    45.344     0.150
     2.828    46.742     0.150
     2.721    47.742     0.150
     2.736    45.242     0.150
     2.948    50.742     0.150
     3.613    97.242     0.150
     3.328    55.242     0.150
     3.729    60.242     0.150
     3.729   104.242     0.150
     5.697    83.242     0.150
     7.325   106.562     0.150
     7.325   185.219     0.150
    11.208   160.914     0.150
    13.853   193.516     0.150
    12.826   180.781     0.150
    21.883   294.094     0.150
     2.339    42.242     0.150
     3.511    56.844     0.150
     3.511    99.344     0.150
     5.939    91.242     0.150
     6.123    93.539     0.150
     6.123   161.539     0.150
     6.128    92.344     0.150
     6.933   103.242     0.150
     7.195   106.445     0.150
     7.325   106.344     0.150
     7.566   112.242     0.150
     7.977   118.039     0.150
     8.317   124.938     0.150
     8.371   125.562     0.150
     8.412   126.141     0.150
     8.426   127.047     0.150
     8.428   126.422     0.150
     8.442   126.516     0.150
     8.445   126.539     0.150
     8.475   126.805     0.150
     8.475   218.445     0.150
     8.480   127.773     0.150
     8.501   127.164     0.150
     8.530   127.578     0.150
     8.533   127.117     0.150
     8.537   127.656     0.150
     8.552   126.719     0.150
     8.553   127.500     0.150
     8.544   127.742     0.150
     8.555   126.734     0.150
     8.547   127.781     0.150
     8.559   127.117     0.150
     8.559   222.359     0.150
     8.569   127.906     0.150
     8.576   127.391     0.150
     8.567   128.039     0.150
     8.628   128.016     0.150
     8.700   128.734     0.150
     8.750   129.258     0.150
     8.925   131.453     0.150
     8.966   131.969     0.150
     8.975   131.969     0.150
     9.110   133.453     0.150
     9.189   134.250     0.150
     9.189   239.312     0.150
     9.197   134.234     0.150
     9.197   237.789     0.150
     9.213   134.086     0.150
     9.213   238.320     0.150
     9.263   135.109     0.150
     9.263   238.516     0.150
     9.291   139.070     0.150
     9.291   238.000     0.150
     9.326   135.852     0.150
     9.326   240.086     0.150
     9.341   135.984     0.150
     9.341   239.305     0.150
     9.524   137.742     0.150
     9.524   241.742     0.150
    10.017   144.641     0.150
    10.688   153.602     0.150
    11.208   159.594     0.150
    11.208   279.961     0.150
    12.826   180.781     0.150
    12.826   313.969     0.150
    12.933   180.742     0.150
    13.853   193.148     0.150
    13.853   338.031     0.150
    14.949   209.742     0.150
    14.949   217.242     0.150
    14.949   375.742     0.150
    14.949   392.242     0.150
    17.630   245.242     0.150
    18.933   260.242     0.150
    19.003   260.742     0.150
    20.985   283.242     0.150
    21.223   285.742     0.150
    21.324   287.742     0.150
    21.324   287.844     0.150
    21.883   293.484     0.150
    21.883   531.719     0.150
    23.861   312.945     0.150
    24.299   318.242     0.150
    24.597   318.742     0.150
    24.597   582.242     0.150
    25.228   325.539     0.150
    26.612   340.141     0.150
    26.828   340.242     0.150
    27.447   347.242     0.150
    28.037   352.242     0.150
    29.861   367.242     0.150
    29.861   367.141     0.150
    30.083   370.242     0.150
    30.825   377.242     0.150
    31.381   381.844     0.150
    31.695   384.242     0.150
    31.933   386.539     0.150
    31.939   386.344     0.150
    31.947   386.039     0.150
    33.684   402.539     0.150
    35.756   420.039     0.150
    35.756   419.742     0.150
    35.798   420.242     0.150
    36.327   423.742     0.150
    36.841   429.039     0.150
    37.127   430.039     0.150
    37.901   439.641     0.150
    38.088   441.242     0.150
    38.275   441.039     0.150
    38.300   443.039     0.150
    38.396   443.445     0.150
    38.765   445.242     0.150
    38.980   446.039     0.150
    39.084   447.844     0.150
    39.084   975.242     0.150
    41.659   467.539     0.150
    42.396   474.242     0.150
    42.396   475.141     0.150
    43.411   484.242     0.150
    43.411   485.039     0.150
    43.462   483.344     0.150
    43.950   487.445     0.150
    43.950   489.141     0.150
    44.250   491.242     0.150
    44.569   493.883     0.150
    45.714   501.242     0.150
    46.402   506.344     0.150
    46.499   507.344     0.150
    46.570   507.641     0.150
    46.817   509.742     0.150
    47.352   514.242     0.150
    47.920   518.242     0.150
    48.174   520.742     0.150
    48.820   524.945     0.150
    49.430   530.141     0.150
    49.630   531.141     0.150
    49.984   533.484     0.150
    49.984   535.531     0.150
    50.409   538.242     0.150
    50.916   541.344     0.150
    51.102   542.844     0.150
    51.241   544.242     0.150
    51.562   546.445     0.150
    51.633   546.023     0.150
    51.836   548.844     0.150
    51.901   549.742     0.150
    51.899   548.641     0.150
    52.028   551.203     0.150
    52.129   550.539     0.150
    52.189   551.242     0.150
    52.189   551.539     0.150
    52.247   551.742     0.150
    52.470   553.609     0.150
    52.465   552.242     0.150
    52.598   554.141     0.150
    52.788   556.445     0.150
    53.039   557.359     0.150
    53.097   558.242     0.150
    53.223   559.523     0.150
    53.186   558.336     0.150
    53.361   560.344     0.150
    53.404   558.945     0.150
    53.404   559.945     0.150
    53.647   562.273     0.150
    53.728   563.344     0.150
    53.744   562.516     0.150
    53.733   561.539     0.150
    53.862   564.539     0.150
    54.083   566.211     0.150
    54.082   563.844     0.150
    54.177   567.172     0.150
    54.200   565.742     0.150
    54.555   567.898     0.150
    54.732   570.641     0.150
    54.826   569.945     0.150
    55.040   571.539     0.150
    55.057   571.172     0.150
    55.005   571.641     0.150
    55.013   571.742     0.150
    55.280   573.242     0.150
    55.331   573.445     0.150
    55.572   575.039     0.150
    55.627   577.695     0.150
    55.771   576.344     0.150
    55.788   576.820     0.150
    55.803   577.039     0.150
    55.962   578.141     0.150
    56.072   578.742     0.150
    56.087   579.383     0.150
    56.383   580.242     0.150
    56.471   581.641     0.150
    56.487   581.492     0.150
    56.589   582.742     0.150
    56.694   583.844     0.150
    56.795   584.641     0.150
    56.852   584.141     0.150
    56.995   587.281     0.150
    57.056   586.242     0.150
    57.111   587.242     0.150
    57.123   586.945     0.150
    57.147   587.039     0.150
    57.153   586.344     0.150
    57.200   588.141     0.150
    57.296   588.445     0.150
    57.322   588.891     0.150
    57.360   588.641     0.150
    57.369   588.539     0.150
    57.408   589.539     0.150
    57.505   588.641     0.150
    57.590   589.844     0.150
    57.768   591.141     0.150
    57.846   591.039     0.150
    57.914   593.016     0.150
    57.995   591.945     0.150
    58.084   592.445     0.150
    58.166   593.844     0.150
    58.934   599.141     0.150
    58.949   598.445     0.150
    59.097   599.844     0.150
    59.229   600.641     0.150
    59.392   601.742     0.150
    59.398   603.242     0.150
    59.688   604.539     0.150
    59.711   605.242     0.150
    59.785   604.445     0.150
    59.828   606.445     0.150
    59.866   606.445     0.150
    60.276   608.344     0.150
    60.715   611.641     0.150
    60.993   613.539     0.150
    61.026   613.539     0.150
    61.248   614.344     0.150
    61.437   615.445     0.150
    61.493   616.883     0.150
    61.493   616.445     0.150
    61.619   617.641     0.150
    61.772   617.844     0.150
    61.773   617.742     0.150
    62.431   622.039     0.150
    62.484   622.641     0.150
    62.902   625.742     0.150
    63.101   627.742     0.150
    63.338   628.242     0.150
    63.388   628.445     0.150
    63.502   630.344     0.150
    65.624   643.641     0.150
    66.579   650.641     0.150
    66.636   650.039     0.150
    68.004   656.242     0.150
    71.274   679.844     0.150
    75.000   700.945     0.150
    75.002   700.945     0.150
    75.664   704.305     0.150
    76.429   708.945     0.150
    77.119   714.344     0.150
    78.035   718.945     0.150
    78.198   718.391     0.150
    78.613   721.039     0.150
    81.548   737.625     0.150
    81.694   739.141     0.150
    81.747   739.586     0.150
    81.848   740.086     0.150
    82.061   741.164     0.150
    85.523   755.742     0.150
    86.766   762.742     0.150
    90.284   780.844     0.150
    91.497   786.344     0.150
    92.745   792.141     0.150
   129.813  1151.141     0.150
   153.555  1191.742     0.150
     6.128    90.758     0.150
     6.128    90.758     0.150
     6.128    90.758     0.150
     6.128    90.758     0.150
     6.128    90.758     0.150
     6.128    91.523     0.150
     1.026    18.844     0.150
     1.026    32.461     0.150
     1.135    22.461     0.150
     1.135    38.461     0.150
     1.126    14.700     0.150
     2.016    37.461     0.150
     2.016    64.461     0.150
     2.319    43.164     0.150
     2.491    43.062     0.150
     2.491    73.758     0.150
     2.533    44.820     0.150
     2.533    74.961     0.150
     2.600    45.859     0.150
     2.727    47.461     0.150
     2.718    32.000     0.150
     2.945    83.562     0.150
     3.309    54.859     0.150
     3.309   105.461     0.150
     3.709    60.461     0.150
     3.709   104.461     0.150
    12.074   169.961     0.150
    12.074   297.961     0.150
    12.838   181.461     0.150
    12.838   316.461     0.150
    12.941   317.461     0.150
     2.016    37.461     0.150
     2.321    43.164     0.150
     2.533    44.461     0.150
     2.924    50.461     0.150
     2.972    57.461     0.150
     2.972    83.562     0.150
     3.300    54.859     0.150
     3.300   105.859     0.150
     3.492    57.258     0.150
     3.709    60.359     0.150
     3.709   104.062     0.150
     6.104    91.664     0.150
     6.108   161.258     0.150
     6.916   178.258     0.150
     7.962   119.461     0.150
     8.319   125.312     0.150
     8.373   125.562     0.150
     8.414   126.203     0.150
     8.430   127.477     0.150
     8.433   126.859     0.150
     8.447   126.867     0.150
     8.479   127.180     0.150
     8.485   128.211     0.150
     8.504   127.609     0.150
     8.539   127.594     0.150
     8.536   128.250     0.150
     8.558   127.539     0.150
     8.540   128.016     0.150
     8.561   127.398     0.150
     8.559   128.156     0.150
     8.548   128.109     0.150
     8.551   128.109     0.150
     8.565   128.039     0.150
     8.574   128.570     0.150
     8.574   224.266     0.150
     8.582   127.680     0.150
     8.570   128.375     0.150
     8.635   128.422     0.150
     8.706   129.047     0.150
     8.756   129.672     0.150
     8.932   131.570     0.150
     8.974   132.320     0.150
     8.983   131.625     0.150
     9.117   133.891     0.150
     9.196   134.609     0.150
     9.205   134.227     0.150
     9.205   238.023     0.150
     9.222   134.852     0.150
     9.271   135.453     0.150
     9.271   239.430     0.150
     9.301   139.852     0.150
     9.301   241.891     0.150
     9.335   136.227     0.150
     9.335   240.992     0.150
     9.350   135.742     0.150
     9.350   241.102     0.150
     9.502   137.961     0.150
     9.502   240.461     0.150
    10.023   145.500     0.150
    10.695   153.734     0.150
    12.951   317.461     0.150
    14.936   210.961     0.150
    14.936   218.461     0.150
    17.612   246.461     0.150
    18.914   260.461     0.150
    19.001   261.461     0.150
    20.994   283.961     0.150
    21.226   286.961     0.150
    21.338   288.461     0.150
    24.311   318.461     0.150
    24.579   318.758     0.150
    25.233   325.961     0.150
    26.819   341.461     0.150
    27.453   347.492     0.150
    29.839   368.164     0.150
    30.805   379.461     0.150
    35.751   420.859     0.150
    36.829   429.164     0.150
    38.810   446.562     0.150
    39.062   447.664     0.150
    39.062     4.500     0.150
    39.062   805.961     0.150
    42.831   478.062     0.150
    43.458   483.258     0.150
    45.692   500.961     0.150
    46.380   506.758     0.150
    46.477   507.664     0.150
    46.795   509.961     0.150
    48.153   520.859     0.150
    49.408   530.461     0.150
    49.962   533.805     0.150
    49.962   535.867     0.150
    51.879   549.062     0.150
    51.875   549.562     0.150
    52.168   551.461     0.150
    52.226   551.961     0.150
    52.443   553.062     0.150
    52.649   554.664     0.150
    53.366   560.461     0.150
    53.387   560.359     0.150
    53.382   558.961     0.150
    53.382   559.258     0.150
    53.627   561.758     0.150
    53.724   561.859     0.150
    53.713   561.961     0.150
    53.707   563.164     0.150
    53.707     4.398     0.150
    54.063   565.961     0.150
    54.061   564.062     0.150
    54.157   566.859     0.150
    54.806   570.258     0.150
    55.020   571.859     0.150
    55.037   571.164     0.150
    54.996   571.664     0.150
    55.260   573.562     0.150
    55.425   574.758     0.150
    55.551   575.359     0.150
    55.768   576.859     0.150
    55.782   577.258     0.150
    56.052   578.961     0.150
    56.450   582.258     0.150
    56.673   584.164     0.150
    56.775   584.859     0.150
    56.831   584.562     0.150
    57.103   587.258     0.150
    57.126   587.359     0.150
    57.132   586.758     0.150
    57.340   589.062     0.150
    57.349   589.062     0.150
    57.485   589.062     0.150
    57.570   590.664     0.150
    57.747   591.664     0.150
    57.826   591.461     0.150
    57.975   592.461     0.150
    58.064   592.961     0.150
    58.145   594.164     0.150
    58.914   599.562     0.150
    58.928   598.859     0.150
    59.076   600.359     0.150
    59.208   601.062     0.150
    59.371   602.164     0.150
    59.668   604.359     0.150
    59.764   604.859     0.150
    60.256   608.758     0.150
    61.227   614.758     0.150
    61.416   616.258     0.150
    61.471   616.562     0.150
    61.599   617.961     0.150
    61.752   618.258     0.150
    61.752   618.164     0.150
    62.881   626.164     0.150
    63.317   628.758     0.150
    65.645   643.758     0.150
    66.559   650.562     0.150
    66.656   650.062     0.150
    75.021   701.359     0.150
    75.023   701.258     0.150
    75.023   715.758     0.150
    78.040   718.961     0.150
    78.184   719.531     0.150
    78.596   721.461     0.150
    81.682   739.258     0.150
    81.735   739.750     0.150
    81.836   740.148     0.150
    82.049   741.250     0.150
    85.544   758.164     0.150
    86.748   762.961     0.150
    90.262   780.562     0.150
    49.408   530.289     0.150
    49.408   530.438     0.150
    49.408   530.367     0.150
    49.408   530.352     0.150
    49.408   530.367     0.150
    29.839   367.828     0.150
    29.839   367.766     0.150
    75.023   702.203     0.150
    75.023   702.203     0.150
    75.023   702.203     0.150
    75.023   702.203     0.150
    75.023   702.211     0.150
    46.380   506.969     0.150
    46.380   506.969     0.150
    46.380   506.969     0.150
    46.380   506.969     0.150
    46.380   506.969     0.150
    46.380   506.969     0.150
    46.380   506.969     0.150
    46.380   506.945     0.150
    46.380   506.922     0.150
    46.380   506.938     0.150
    52.168   551.227     0.150
    52.168   551.211     0.150
    52.168   551.281     0.150
    52.168   551.242     0.150
    21.338   287.617     0.150
    21.338   287.617     0.150
    45.692   501.547     0.150
    45.692   501.398     0.150
    54.996   571.805     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108    90.703     0.150
     6.108   160.844     0.150
     6.108   160.844     0.150
     6.108   160.844     0.150
     6.108   159.977     0.150
    53.382   560.211     0.150
    53.382   560.211     0.150
    53.382   560.211     0.150
    53.382   560.156     0.150
    53.382   560.180     0.150
    53.382   560.164     0.150
    53.382   560.234     0.150
    39.062   447.562     0.150
    39.062   447.562     0.150
    39.062   447.594     0.150
    85.544   758.836     0.150
    85.544   758.805     0.150
    27.453   346.406     0.150
    27.453   345.992     0.150
    27.453   346.492     0.150
    14.936   211.703     0.150
    25.233   326.523     0.150
    25.233   326.461     0.150
    86.748   764.820     0.150
    86.748   764.820     0.150
    86.748   764.711     0.150
     1.095    19.633     0.150
     1.095    34.133     0.150
     1.184    23.133     0.150
     1.184    38.133     0.150
     1.228    23.836     0.150
     1.228    38.633     0.150
     1.971    37.133     0.150
     2.272    41.031     0.150
     2.532    44.133     0.150
     2.532    74.133     0.150
     2.599    43.133     0.150
     2.599    78.133     0.150
     2.729    45.133     0.150
     2.729    82.133     0.150
     2.953    48.133     0.150
     2.953    88.531     0.150
     3.544    98.336     0.150
     3.064    51.133     0.150
     3.091    52.633     0.150
     3.091    88.633     0.150
     3.445    58.633     0.150
     3.445   100.633     0.150
     3.575    58.133     0.150
     3.575   100.133     0.150
     1.149    23.250     0.150
     1.149    36.047     0.150
     1.153    21.047     0.150
     1.153    37.344     0.150
     2.048    38.547     0.150
     2.048    64.547     0.150
     2.542    44.547     0.150
     2.542    74.047     0.150
     2.609    45.547     0.150
     2.609    78.547     0.150
     2.734    46.344     0.150
     2.861    87.547     0.150
     2.962    47.547     0.150
     3.145    52.547     0.150
     3.145   101.547     0.150
     3.173    89.547     0.150
     3.527    99.047     0.150
     3.657    58.547     0.150
     5.710   100.547     0.150
    12.041   169.047     0.150
    12.041   293.047     0.150
     2.049    38.547     0.150
     2.049    64.547     0.150
     3.333    54.148     0.150
     8.301   124.695     0.150
     8.396   125.562     0.150
     8.409   126.633     0.150
     8.412   125.984     0.150
     8.429   125.961     0.150
     8.426   126.062     0.150
     8.458   126.320     0.150
     8.464   127.234     0.150
     8.484   126.625     0.150
     8.521   127.172     0.150
     8.514   127.344     0.150
     8.516   126.883     0.150
     8.531   127.281     0.150
     8.537   127.266     0.150
     8.537   220.641     0.150
     8.535   125.977     0.150
     8.539   126.125     0.150
     8.550   126.828     0.150
     8.542   127.375     0.150
     8.552   127.672     0.150
     8.552   220.016     0.150
     8.733   128.789     0.150
     8.908   130.938     0.150
     8.959   131.844     0.150
     9.093   132.289     0.150
     9.172   133.758     0.150
     9.196   133.625     0.150
     9.246   133.609     0.150
    46.507   506.844     0.150
    46.825   509.547     0.150
    53.412   558.445     0.150
    57.373   588.445     0.150
    57.382   588.445     0.150
    57.859   590.945     0.150
    74.990   700.547     0.150
    74.990   701.367     0.150
    74.990   701.367     0.150
    74.990   701.383     0.150
    74.990   701.367     0.150
    74.990   701.375     0.150
    74.990   701.414     0.150
    74.990   701.359     0.150
    21.307   286.750     0.150
    86.763   763.984     0.150
     1.020    18.672     0.150
     1.020    32.172     0.150
     1.164    21.266     0.150
     1.164    37.867     0.150
     1.137    24.766     0.150
     1.137    38.766     0.150
     1.188    24.062     0.150
     1.188    37.562     0.150
     2.037    63.766     0.150
     2.540    75.367     0.150
     2.582    39.766     0.150
     2.582    77.766     0.150
     2.649    45.766     0.150
     2.715    80.266     0.150
     2.776    47.766     0.150
     2.776    90.766     0.150
     2.848    52.266     0.150
     2.848    86.766     0.150
     3.002    49.367     0.150
     3.125    52.266     0.150
     3.150    53.266     0.150
     3.500    98.766     0.150
     3.632    59.266     0.150
     3.632   101.266     0.150
     5.750   167.766     0.150
     0.996    19.383     0.150
     0.996    32.914     0.150
     1.147    21.406     0.150
     1.147    37.000     0.150
     1.149    22.203     0.150
     1.149    37.703     0.150
     2.045    36.703     0.150
     2.045    63.703     0.150
     2.349    42.602     0.150
     2.499    43.805     0.150
     2.537    43.703     0.150
     2.537    78.703     0.150
     2.603    47.703     0.150
     2.729    49.906     0.150
     2.748    85.703     0.150
     2.857    48.703     0.150
     2.857    84.203     0.150
     2.976    48.703     0.150
     2.956    51.703     0.150
     3.624    56.102     0.150
     3.624    98.906     0.150
     3.171    53.703     0.150
     3.339    56.703     0.150
     3.339   101.703     0.150
     3.654    58.703     0.150
     3.654   101.703     0.150
     3.739    60.703     0.150
     3.739   104.102     0.150
    12.045   169.203     0.150
    12.045   296.703     0.150
     1.104    21.203     0.150
     1.104    35.906     0.150
     2.045    36.703     0.150
     2.045    63.703     0.150
     2.351    42.602     0.150
     3.002    48.703     0.150
     3.522    57.000     0.150
     4.521    85.906     0.150
     6.139    93.406     0.150
     6.139   161.500     0.150
     7.327   184.703     0.150
    38.981   443.406     0.150
    46.410   506.500     0.150
    46.410   604.500     0.150
     6.139    91.172     0.150
     6.139    90.609     0.150
     6.139    90.609     0.150
     6.139    90.609     0.150
     6.139    90.984     0.150
     6.139    90.047     0.150
     6.139    89.312     0.150
     6.139   161.133     0.150
     1.103    20.156     0.150
     1.103    36.555     0.150
     1.354    26.156     0.150
     1.354    42.656     0.150
     1.911    35.156     0.150
     2.555    45.258     0.150
     2.620    43.156     0.150
     2.620    77.656     0.150
     2.687    46.359     0.150
     2.610    48.156     0.150
     2.610    80.156     0.150
     2.823    48.156     0.150
     2.823    87.156     0.150
     2.716    46.156     0.150
     3.449    53.953     0.150
     3.449    93.953     0.150
     3.042    51.156     0.150
     2.999    51.156     0.150
     2.999    88.156     0.150
     3.186    54.359     0.150
     3.479    56.656     0.150
     3.479    97.156     0.150
     3.572    58.156     0.150
    13.113   320.156     0.150
     1.301    25.258     0.150
     1.301    41.359     0.150
     1.912    35.156     0.150
     3.022    49.953     0.150
     3.022    93.156     0.150
     2.844    46.156     0.150
     3.175    54.359     0.150
     3.175    97.758     0.150
     3.357    54.656     0.150
     5.828    88.758     0.150
     5.828   153.758     0.150
     5.966    91.359     0.150
     5.971    90.453     0.150
     5.971   156.453     0.150
     7.046   105.758     0.150
     8.287   124.500     0.150
     8.342   124.969     0.150
     8.423   125.820     0.150
     8.387   125.391     0.150
     8.427   126.156     0.150
     8.438   125.734     0.150
     8.423   125.992     0.150
     8.481   127.773     0.150
     8.491   126.539     0.150
     8.542   127.688     0.150
     8.535   128.203     0.150
     8.566   127.055     0.150
     8.560   128.539     0.150
     8.517   126.844     0.150
     8.567   128.203     0.150
     8.530   127.266     0.150
     8.536   127.266     0.150
     8.591   127.055     0.150
     8.550   127.477     0.150
     8.645   128.922     0.150
     8.768   128.883     0.150
     8.946   132.086     0.150
     8.990   132.562     0.150
     8.998   131.914     0.150
     9.136   133.047     0.150
     9.216   134.078     0.150
     9.247   134.719     0.150
     9.300   135.188     0.150
     9.300   236.281     0.150
     9.338   139.852     0.150
     9.338   239.914     0.150
     9.382   137.125     0.150
     9.320   135.156     0.150
     9.320   236.953     0.150
    10.037   145.617     0.150
    12.182   171.156     0.150
    12.182   300.156     0.150
    12.979   317.156     0.150
    14.796   215.656     0.150
    18.946   262.656     0.150
    21.020   283.156     0.150
    25.233   325.656     0.150
    27.358   344.984     0.150
    38.791   441.859     0.150
    38.791   574.859     0.150
    46.206   504.953     0.150
    46.301   505.758     0.150
    49.227   528.758     0.150
    52.017   548.859     0.150
    53.209   556.859     0.150
    53.209   557.359     0.150
    53.209   864.055     0.150
    56.299   581.258     0.150
    56.681   582.953     0.150
    56.981   585.258     0.150
    57.195   587.453     0.150
    57.204   587.453     0.150
    57.342   587.453     0.150
    58.928   598.758     0.150
    59.059   599.453     0.150
    59.222   600.055     0.150
    60.107   606.656     0.150
    61.073   613.156     0.150
    61.453   616.453     0.150
    66.421   649.258     0.150
    78.125   718.656     0.150
    86.579   761.656     0.150
     5.971    88.352     0.150
     5.971    88.352     0.150
     5.971    87.312     0.150
     5.971    87.453     0.150
     5.971   156.750     0.150
     5.971   157.938     0.150
    53.209   558.297     0.150
    53.209   558.219     0.150
    27.358   344.961     0.150
     1.024    19.938     0.150
     1.024    33.219     0.150
     1.121    21.766     0.150
     1.121    37.266     0.150
     1.174    23.766     0.150
     1.174    39.266     0.150
     2.015    36.766     0.150
     2.015    61.766     0.150
     2.320    43.266     0.150
     2.484    45.664     0.150
     2.525    44.266     0.150
     2.525    79.266     0.150
     2.718    84.766     0.150
     2.591    48.562     0.150
     2.828    49.266     0.150
     2.719    50.766     0.150
     2.946    48.562     0.150
     3.595    56.664     0.150
     2.945    51.766     0.150
     2.945    88.766     0.150
     3.142    53.766     0.150
     3.497   109.266     0.150
     3.626    59.766     0.150
     3.626   102.766     0.150
     3.710    60.969     0.150
     3.710   104.562     0.150
     2.016    36.766     0.150
     2.016    61.766     0.150
     2.321    43.266     0.150
     2.973    48.562     0.150
     3.493    57.562     0.150
     3.493    98.867     0.150
     3.595    98.469     0.150
     5.922    90.969     0.150
     6.105    93.969     0.150
     6.110    93.062     0.150
     6.110   160.969     0.150
     7.177   107.266     0.150
     7.960   119.562     0.150
     8.379   126.008     0.150
     8.420   126.898     0.150
     8.436   127.648     0.150
     8.439   126.945     0.150
     8.453   127.133     0.150
     8.485   127.320     0.150
     8.491   128.320     0.150
     8.511   127.320     0.150
     8.541   128.320     0.150
     8.541   222.461     0.150
     8.544   128.570     0.150
     8.565   128.492     0.150
     8.565   221.688     0.150
     8.567   127.008     0.150
     8.570   128.281     0.150
     8.576   128.477     0.150
     8.580   128.664     0.150
     8.580   220.531     0.150
    23.852   313.164     0.150
    38.971   444.367     0.150
    46.386   507.062     0.150
    49.415   530.867     0.150
    52.171   551.664     0.150
    53.386   559.664     0.150
    57.342   589.266     0.150
    57.351   589.367     0.150
    75.020   701.367     0.150
    81.679   739.562     0.150
    86.757   764.367     0.150
    49.415   530.555     0.150
    75.020   702.344     0.150
    75.020   702.352     0.150
    75.020   702.344     0.150
    75.020   702.344     0.150
    46.386   507.141     0.150
    46.386   507.156     0.150
    46.386   507.141     0.150
    52.171   551.391     0.150
     6.110    90.898     0.150
     6.110    90.844     0.150
     6.110    91.336     0.150
     6.110   161.062     0.150
     6.110   160.172     0.150
     6.110   160.008     0.150
    53.386   560.383     0.150
    86.757   764.938     0.150
    23.852   314.133     0.150
     1.006    19.254     0.150
     1.006    32.984     0.150
     1.167    21.374     0.150
     1.167    36.874     0.150
     1.156    21.874     0.150
     1.156    34.874     0.150
     2.042    37.874     0.150
     2.042    61.874     0.150
     2.559    41.874     0.150
     2.559    76.374     0.150
     2.625    46.274     0.150
     2.692    45.874     0.150
     2.692    81.874     0.150
     2.752    47.474     0.150
     2.745    50.874     0.150
     2.745    82.874     0.150
     2.979    47.874     0.150
     2.979    90.074     0.150
     2.854    48.374     0.150
     2.969    48.274     0.150
     3.614    56.774     0.150
     3.614    98.374     0.150
     3.162    53.874     0.150
     3.645    59.874     0.150
     3.645   101.874     0.150
     3.731    60.674     0.150
     3.731   105.074     0.150
     5.727    87.874     0.150
     5.727   168.874     0.150
     7.353   102.874     0.150
     7.353   180.874     0.150
    12.855   315.874     0.150
    12.948   315.874     0.150
     1.118    21.774     0.150
     1.118    36.074     0.150
     1.495    26.464     0.150
     1.830    32.864     0.150
     2.043    37.874     0.150
     2.043    61.874     0.150
     2.809    45.744     0.150
     2.948    90.174     0.150
     3.079    49.924     0.150
     2.996    48.274     0.150
     2.996    92.874     0.150
     3.515    57.374     0.150
     9.506   139.174     0.150
    10.216   149.174     0.150
    12.215   168.874     0.150
    12.047   168.874     0.150
    12.855   177.874     0.150
    12.958   315.874     0.150
    13.882   190.874     0.150
    13.882   340.874     0.150
    18.973   261.874     0.150
    21.196   285.874     0.150
    23.835   312.474     0.150
    35.726   419.274     0.150
    36.811   428.474     0.150
    38.955   444.374     0.150
    46.393   506.574     0.150
    49.415   530.174     0.150
    75.002   700.874     0.150
    78.586   720.174     0.150
    81.712   738.774     0.150
    23.835   312.401     0.150
     0.982    19.930     0.150
     1.226    22.549     0.150
     1.226    38.549     0.150
     1.109    37.549     0.150
     2.091    38.549     0.150
     2.091    64.549     0.150
     2.384    42.449     0.150
     2.384    74.248     0.150
     2.635    40.549     0.150
     2.635    75.549     0.150
     2.555    44.049     0.150
     2.701    44.549     0.150
     2.701    80.549     0.150
     2.768    46.549     0.150
     2.827    46.949     0.150
     2.827    83.949     0.150
     3.055    51.549     0.150
     3.055    90.549     0.150
     3.171    53.049     0.150
     3.193    54.049     0.150
     3.540   100.549     0.150
     0.960    19.436     0.150
     0.960    33.336     0.150
     1.122    20.555     0.150
     1.122    35.555     0.150
     1.187    21.855     0.150
     1.187    37.855     0.150
     2.084    37.855     0.150
     2.561    42.355     0.150
     2.561    76.355     0.150
     2.388    73.955     0.150
     2.627    41.855     0.150
     2.627    83.455     0.150
     2.694    45.855     0.150
     2.694    81.855     0.150
     2.560    43.855     0.150
     2.560    81.355     0.150
     2.751    43.855     0.150
     2.980    47.855     0.150
     3.180    52.855     0.150
     3.180    93.355     0.150
     3.560    58.355     0.150
     3.560   100.355     0.150
     1.034    18.994     0.150
     1.034    31.014     0.150
     1.123    22.174     0.150
     1.123    37.174     0.150
     1.061    21.174     0.150
     1.061    36.174     0.150
     1.154    38.475     0.150
     1.988    36.174     0.150
     1.988    63.174     0.150
     2.303    41.674     0.150
     2.436    42.174     0.150
     2.436    75.174     0.150
     2.478    42.674     0.150
     2.478    72.174     0.150
     2.503    41.174     0.150
     2.503    74.174     0.150
     2.569    82.174     0.150
     2.630    43.174     0.150
     2.630    79.174     0.150
     2.856    45.174     0.150
     2.856    85.174     0.150
     3.136    59.174     0.150
     3.136   100.674     0.150
     3.497    98.674     0.150
     1.219    21.971     0.150
     1.262    24.471     0.150
     1.262    40.471     0.150
     2.192    40.570     0.150
     2.531    42.471     0.150
     2.531    73.471     0.150
     2.598    41.971     0.150
     2.410    41.971     0.150
     2.665    43.971     0.150
     2.810    33.000     0.150
     2.730    43.971     0.150
     2.640    47.971     0.150
     2.640    79.971     0.150
     2.952    46.971     0.150
     3.509    58.971     0.150
     3.029    37.500     0.150
     3.056    52.471     0.150
     3.056    88.971     0.150
     3.410    57.471     0.150
     3.626    58.971     0.150
     3.626   101.971     0.150
     5.698    82.971     0.150
    12.869   315.971     0.150
    12.997   316.971     0.150
     1.600    28.781     0.150
     1.935    34.721     0.150
     2.913    48.381     0.150
     2.913    89.141     0.150
     2.928    48.070     0.150
     2.928    88.670     0.150
     3.184    51.561     0.150
     3.184    97.121     0.150
     3.409    56.371     0.150
     4.406    68.170     0.150
     5.025    73.971     0.150
     5.849    88.170     0.150
     5.849   155.170     0.150
     6.021    92.170     0.150
     6.025    91.170     0.150
     6.838   101.971     0.150
     7.094   105.771     0.150
     7.892   117.170     0.150
     8.346   125.426     0.150
     8.400   125.807     0.150
     8.443   125.916     0.150
     8.468   127.520     0.150
     8.471   126.818     0.150
     8.484   126.873     0.150
     8.478   126.617     0.150
     8.524   128.293     0.150
     8.540   127.225     0.150
     8.581   128.688     0.150
     8.576   128.561     0.150
     8.601   125.561     0.150
     8.600   128.305     0.150
     8.606   128.434     0.150
     8.615   129.070     0.150
     8.626   127.234     0.150
     8.602   127.557     0.150
     8.680   129.191     0.150
     8.978   131.914     0.150
     9.021   131.996     0.150
     9.029   132.459     0.150
     9.165   133.682     0.150
     9.245   133.994     0.150
     9.255   134.150     0.150
     9.255   238.693     0.150
     9.262   135.088     0.150
     9.323   134.652     0.150
     9.323   237.803     0.150
     9.356   242.551     0.150
     9.388   241.760     0.150
     9.403   136.342     0.150
     9.403   241.232     0.150
     9.428   134.771     0.150
     9.428   238.271     0.150
    10.307   150.971     0.150
    12.150   170.971     0.150
    12.250   171.471     0.150
    12.869   178.971     0.150
    12.869   314.971     0.150
    13.008   178.971     0.150
    13.902   193.971     0.150
    14.906   217.471     0.150
    19.018   262.971     0.150
    21.259   285.971     0.150
    25.274   325.471     0.150
    38.907   445.670     0.150
    46.298   505.570     0.150
    46.395   506.471     0.150
    46.712   508.971     0.150
    48.853   524.471     0.150
    49.330   529.371     0.150
    52.084   550.170     0.150
    53.298   558.070     0.150
    53.298   558.070     0.150
    56.747   582.871     0.150
    57.048   585.070     0.150
    57.256   588.070     0.150
    57.265   588.070     0.150
    61.387   615.471     0.150
    66.476   649.871     0.150
    72.889   688.670     0.150
    72.905   689.070     0.150
    75.107   701.271     0.150
    86.695   762.271     0.150
    90.186   779.170     0.150
    49.330   529.178     0.150
    49.330   529.199     0.150
    49.330   529.088     0.150
    49.330   529.150     0.150
    49.330   529.229     0.150
    46.298   505.654     0.150
    46.298   505.730     0.150
    46.298   505.635     0.150
    46.298   505.686     0.150
     6.025    90.092     0.150
     6.025    89.088     0.150
     6.025    89.088     0.150
     6.025    88.955     0.150
     6.025    88.471     0.150
    53.298   559.037     0.150
    53.298   558.896     0.150
    53.298   558.838     0.150
    53.298   558.916     0.150
    53.298   558.994     0.150
    53.298   558.951     0.150
     1.036    19.195     0.150
     1.036    31.754     0.150
     1.187    23.223     0.150
     1.187    37.223     0.150
     1.114    20.523     0.150
     1.114    36.523     0.150
     2.308    41.824     0.150
     2.482    40.723     0.150
     2.482    74.324     0.150
     2.525    44.023     0.150
     2.525    78.023     0.150
     2.592    44.523     0.150
     2.658    43.523     0.150
     2.658    81.023     0.150
     2.720    45.523     0.150
     2.707    84.223     0.150
     2.945    46.523     0.150
     2.945    88.523     0.150
     3.583    57.125     0.150
     3.583    99.324     0.150
     3.102    52.023     0.150
     3.102    91.023     0.150
     3.130    53.523     0.150
     3.485    55.523     0.150
     3.485    97.023     0.150
     3.698    59.625     0.150
     3.698   102.723     0.150
     7.340   105.523     0.150
     7.340   185.523     0.150
    12.835   181.523     0.150
    12.835   315.523     0.150
    12.941   316.523     0.150
     1.143    21.324     0.150
     1.526    28.043     0.150
     1.864    59.512     0.150
     2.310    41.824     0.150
     2.837    46.832     0.150
     2.707    83.922     0.150
     3.112    50.512     0.150
     3.481    57.223     0.150
     3.931    61.445     0.150
     3.931   106.652     0.150
     4.367    67.945     0.150
     4.560    70.375     0.150
     4.560   122.703     0.150
     4.481    69.523     0.150
     4.973    73.523     0.150
     5.212    78.922     0.150
     5.212   136.652     0.150
     5.767    87.703     0.150
     5.814    87.043     0.150
     6.019    90.984     0.150
     6.019   156.375     0.150
     5.912    89.824     0.150
     6.235    93.332     0.150
     6.093    92.723     0.150
     6.098    91.922     0.150
     6.591    98.125     0.150
     6.591   170.012     0.150
     6.904   103.723     0.150
     7.247   106.125     0.150
     7.165   106.523     0.150
     7.165   183.523     0.150
     7.906   116.164     0.150
     7.906   201.242     0.150
     7.951   118.523     0.150
     8.329   124.688     0.150
     8.383   125.398     0.150
     8.441   127.035     0.150
     8.444   126.363     0.150
     8.424   125.926     0.150
     8.457   126.422     0.150
     8.458   126.320     0.150
     8.496   127.707     0.150
     8.489   126.715     0.150
     8.515   127.020     0.150
     8.550   126.727     0.150
     8.546   127.504     0.150
     8.572   126.953     0.150
     8.570   127.664     0.150
     8.570   221.000     0.150
     8.550   127.520     0.150
     8.576   128.324     0.150
     8.558   127.621     0.150
     8.562   127.695     0.150
     8.585   128.059     0.150
     8.580   127.855     0.150
     8.768   129.539     0.150
     8.943   131.734     0.150
     8.994   131.875     0.150
     9.129   133.277     0.150
     9.217   134.152     0.150
     9.225   134.438     0.150
     9.233   134.324     0.150
     9.283   135.031     0.150
     9.312   139.363     0.150
     9.347   135.777     0.150
     9.347   238.355     0.150
     9.361   135.918     0.150
     9.361   239.676     0.150
     9.498   137.523     0.150
    10.258   149.523     0.150
    12.085   169.523     0.150
    12.835   315.625     0.150
    12.952   181.023     0.150
    12.952   316.523     0.150
    13.864   194.523     0.150
    13.864   337.523     0.150
    14.940   218.523     0.150
    21.410   288.324     0.150
    46.373   506.223     0.150
    46.788   509.824     0.150
    49.403   529.824     0.150
    52.158   549.824     0.150
    53.374   558.324     0.150
    57.330   587.922     0.150
    57.339   588.023     0.150
    62.394   622.625     0.150
    72.815   688.324     0.150
    72.832   688.324     0.150
    75.032   700.723     0.150
    78.530   720.223     0.150
    86.748   762.422     0.150
    21.410   287.508     0.150
    21.410   287.789     0.150
    46.373   506.156     0.150
    46.373   506.258     0.150
    12.952   183.855     0.150
     6.098    89.055     0.150
     6.098    90.059     0.150
     6.098    90.059     0.150
     6.098    90.059     0.150
    72.815   688.648     0.150
    72.815   688.625     0.150
    72.815   688.617     0.150
     1.037    18.832     0.150
     1.037    31.812     0.150
     1.148    21.180     0.150
     1.148    36.180     0.150
     1.128    22.281     0.150
     1.128    38.281     0.150
     1.194    23.281     0.150
     1.194    38.281     0.150
     2.311    41.383     0.150
     2.546    44.781     0.150
     2.546    78.281     0.150
     2.484    42.781     0.150
     2.484    73.281     0.150
     2.612    41.281     0.150
     2.612    76.281     0.150
     2.679    44.281     0.150
     2.679    80.281     0.150
     2.741    43.281     0.150
     2.741    80.281     0.150
     2.966    45.480     0.150
     3.103    51.281     0.150
     3.130    53.281     0.150
     3.130    91.281     0.150
     3.613    58.281     0.150
     1.068    19.277     0.150
     1.068    34.367     0.150
     1.168    21.215     0.150
     0.995    18.855     0.150
     0.995    31.695     0.150
     1.188    22.016     0.150
     1.188    38.117     0.150
     2.064    37.516     0.150
     2.361    42.215     0.150
     2.595    43.516     0.150
     2.595    77.516     0.150
     2.663    46.617     0.150
     2.663    80.016     0.150
     2.661    47.516     0.150
     2.727    80.516     0.150
     2.787    50.117     0.150
     2.766    50.516     0.150
     2.766    86.516     0.150
     2.986    47.516     0.150
     2.986    88.914     0.150
     3.627    55.617     0.150
     3.746    60.516     0.150
     3.746   104.516     0.150
     5.763    99.516     0.150
     7.380   186.086     0.150
    12.969   179.516     0.150
    12.969   315.516     0.150
     1.114    21.414     0.150
     1.114    35.414     0.150
     2.064    37.516     0.150
     2.363    42.215     0.150
     2.766    50.117     0.150
     2.766    85.914     0.150
     2.983    51.914     0.150
     2.983    90.516     0.150
     3.012    47.516     0.150
     3.012    88.914     0.150
     3.530    57.414     0.150
     6.141    92.516     0.150
     6.146    92.117     0.150
     6.963   103.516     0.150
     6.963   178.516     0.150
     7.216   107.215     0.150
     7.380   135.516     0.150
     7.380   186.086     0.150
     7.601   112.414     0.150
     8.017   118.316     0.150
     8.254   123.730     0.150
     8.307   124.438     0.150
     8.348   124.945     0.150
     8.365   125.543     0.150
     8.368   125.164     0.150
     8.381   125.320     0.150
     8.382   125.363     0.150
     8.413   125.629     0.150
     8.420   126.816     0.150
     8.420   220.461     0.150
     8.439   126.004     0.150
     8.470   126.637     0.150
     8.474   126.059     0.150
     8.474   126.512     0.150
     8.482   126.602     0.150
     8.493   126.156     0.150
     8.485   126.602     0.150
     8.494   126.348     0.150
     8.494   221.547     0.150
     8.496   126.254     0.150
     8.500   126.590     0.150
     8.509   220.188     0.150
     8.504   126.734     0.150
     8.518   126.828     0.150
     8.570   127.215     0.150
     9.132   132.094     0.150
     9.142   132.836     0.150
     9.158   133.172     0.150
     9.208   133.281     0.150
     9.208   236.621     0.150
     9.238   138.262     0.150
     9.238   238.543     0.150
     9.287   133.727     0.150
     9.287   236.879     0.150
     9.496   138.816     0.150
    10.186   148.816     0.150
    12.025   168.516     0.150
    12.025   297.516     0.150
    12.979   179.516     0.150
    12.979   315.516     0.150
    21.358   287.715     0.150
    23.811   312.414     0.150
    29.840   368.016     0.150
    38.933   445.316     0.150
    46.392   505.914     0.150
    46.488   506.914     0.150
    49.409   530.016     0.150
    52.199   550.516     0.150
    53.303  1008.316     0.150
    53.396   558.715     0.150
    57.373   588.117     0.150
    57.383   588.215     0.150
    72.770   687.316     0.150
    74.991   699.617     0.150
    78.485   719.617     0.150
    49.409   529.773     0.150
     6.146    90.848     0.150
     6.146    90.883     0.150
     6.146    90.723     0.150
     6.146    90.723     0.150
     6.146    90.535     0.150
     6.146    90.648     0.150
     6.146    90.773     0.150
     6.146    89.031     0.150
    72.770   688.344     0.150
     0.198     3.305     0.150
     0.198     6.602     0.150
     1.034    19.195     0.150
     1.034    34.609     0.150
     0.997    18.875     0.150
     1.107    19.703     0.150
     1.107    34.500     0.150
     1.154    21.102     0.150
     1.154    37.305     0.150
     1.153    20.602     0.150
     2.046    37.602     0.150
     2.350    41.898     0.150
     2.547    42.852     0.150
     2.547    76.242     0.150
     2.613    44.602     0.150
     2.679    43.602     0.150
     2.739    46.602     0.150
     2.749    44.602     0.150
     2.966    47.000     0.150
     2.976    45.602     0.150
     2.976    79.602     0.150
     3.623    56.102     0.150
     3.739    58.602     0.150
     3.739   101.602     0.150
     7.337   105.430     0.150
     9.885   139.000     0.150
    11.226   159.734     0.150
    11.226   282.680     0.150
    12.840   178.602     0.150
    12.840   312.953     0.150
    12.931   179.102     0.150
    13.118   182.602     0.150
    13.866   192.672     0.150
    13.866   336.258     0.150
     1.153    36.102     0.150
     1.486    26.109     0.150
     1.823    32.328     0.150
     2.351    40.898     0.150
     2.799    45.695     0.150
     2.935    50.203     0.150
     2.935    91.805     0.150
     3.002    45.602     0.150
     3.072    49.789     0.150
     3.522    56.805     0.150
     3.522    97.703     0.150
     3.623    98.898     0.150
     3.739   102.102     0.150
     4.520    67.602     0.150
     4.520   141.602     0.150
     4.520    69.445     0.150
     4.717    79.602     0.150
     4.967    73.102     0.150
     4.967   127.602     0.150
     5.171    78.445     0.150
     5.171   136.039     0.150
     5.726    85.219     0.150
     5.772    86.000     0.150
     5.954    90.203     0.150
     5.954   155.203     0.150
     5.978    89.102     0.150
     6.134    92.305     0.150
     6.138    91.305     0.150
     6.193    91.641     0.150
     6.549    96.883     0.150
     6.549   169.062     0.150
     6.946   102.203     0.150
     7.206   105.703     0.150
     7.337   105.539     0.150
     7.337   183.891     0.150
     7.580   111.805     0.150
     7.864   114.203     0.150
     7.864   200.305     0.150
     7.993   117.398     0.150
     7.822   116.641     0.150
     8.393   124.859     0.150
     8.423   220.266     0.150
     8.426   125.258     0.150
     8.461   126.898     0.150
     8.511   126.875     0.150
     8.514   125.719     0.150
     8.518   126.453     0.150
     8.533   124.172     0.150
     8.525   126.383     0.150
     8.534   126.273     0.150
     8.529   126.602     0.150
     8.537   125.719     0.150
     8.540   126.109     0.150
     8.550   126.930     0.150
     8.550   223.086     0.150
     8.548   126.602     0.150
     8.557   126.414     0.150
     8.567   124.125     0.150
     8.610   127.062     0.150
     8.681   127.867     0.150
     8.731   128.305     0.150
     8.906   130.141     0.150
     8.948   130.961     0.150
     8.957   131.055     0.150
     8.492   127.219     0.150
     9.091   132.453     0.150
     9.170   133.891     0.150
     9.179   132.648     0.150
     9.179   236.094     0.150
     9.195   133.141     0.150
     9.244   134.180     0.150
     9.308   134.898     0.150
     9.308   240.258     0.150
     9.323   134.234     0.150
     9.323   240.148     0.150
     9.521   137.102     0.150
     9.521   238.602     0.150
     9.885   139.828     0.150
     9.885   245.508     0.150
     9.998   144.188     0.150
     9.998   254.891     0.150
    10.754   271.602     0.150
    10.669   153.133     0.150
    11.226   159.750     0.150
    12.199   169.602     0.150
    12.043   168.602     0.150
    12.390   174.602     0.150
    12.840   180.430     0.150
    12.840   312.930     0.150
    12.942   179.102     0.150
    12.999   186.102     0.150
    13.118   182.602     0.150
    13.118   319.602     0.150
    12.988   184.602     0.150
    13.866   192.305     0.150
    13.866   193.875     0.150
    13.866   337.773     0.150
    14.935   211.102     0.150
    14.935   218.602     0.150
    17.642   243.602     0.150
    18.945   258.102     0.150
    18.984   260.102     0.150
    20.967   282.898     0.150
    21.204   285.102     0.150
    21.308   286.602     0.150
    21.368   287.203     0.150
    21.368   531.305     0.150
    21.893   292.414     0.150
    23.851   311.398     0.150
    24.282   317.102     0.150
    24.282   574.602     0.150
    24.588   318.102     0.150
    24.588   581.602     0.150
    25.209   324.898     0.150
    26.596   338.703     0.150
    26.812   339.898     0.150
    26.812   540.305     0.150
    26.821   340.102     0.150
    27.442   346.453     0.150
    27.821   349.203     0.150
    28.019   351.898     0.150
    28.277   354.602     0.150
    28.232   352.602     0.150
    29.504   364.602     0.150
    29.860   366.891     0.150
    29.860   367.398     0.150
    29.860     8.203     0.150
    30.064   369.398     0.150
    30.836   376.602     0.150
    30.836   437.602     0.150
    31.362   381.102     0.150
    31.362   555.102     0.150
    31.370   380.602     0.150
    31.370   554.602     0.150
    31.705   383.203     0.150
    31.949   386.102     0.150
    31.949   697.602     0.150
    33.114   396.102     0.150
    33.665   401.102     0.150
    34.555   409.398     0.150
    35.739   419.602     0.150
    35.779   419.602     0.150
    36.312   422.602     0.150
    36.826   427.703     0.150
    37.108   429.602     0.150
    37.323   432.703     0.150
    37.917   438.203     0.150
    38.104   439.805     0.150
    38.159   441.102     0.150
    38.291   440.805     0.150
    38.315   441.500     0.150
    38.380   442.102     0.150
    38.411   442.102     0.150
    38.400   441.203     0.150
    38.617   442.102     0.150
    38.769   443.602     0.150
    38.769   530.602     0.150
    38.913   444.898     0.150
    38.912   445.305     0.150
    38.971   444.805     0.150
    39.089   446.602     0.150
    40.493   458.602     0.150
    42.043   469.602     0.150
    43.444   482.500     0.150
    43.892   485.602     0.150
    43.975   486.602     0.150
    44.945   494.102     0.150
    45.301   497.102     0.150
    45.235   495.703     0.150
    45.691   499.602     0.150
    45.713   500.102     0.150
    46.005   502.602     0.150
    46.150   503.102     0.150
    46.368   505.203     0.150
    46.368  1115.898     0.150
    46.405   505.602     0.150
    46.502   506.602     0.150
    46.581   507.000     0.150
    46.820   508.805     0.150
    47.363   512.602     0.150
    47.932   516.602     0.150
    48.182   518.898     0.150
    49.049   525.398     0.150
    49.057   525.391     0.150
    49.246   528.203     0.150
    49.430   529.398     0.150
    49.638   530.500     0.150
    49.984   532.742     0.150
    49.984     5.266     0.150
    50.271   535.602     0.150
    50.417   536.602     0.150
    50.926   540.500     0.150
    50.797   538.805     0.150
    51.111   542.203     0.150
    51.247   542.602     0.150
    51.360   544.602     0.150
    51.515   545.398     0.150
    51.570   545.805     0.150
    51.570     3.195     0.150
    51.606   545.305     0.150
    51.633   545.281     0.150
    51.846   547.898     0.150
    51.879   548.141     0.150
    51.911   548.602     0.150
    51.908   547.898     0.150
    51.904   548.398     0.150
    51.904     4.102     0.150
    52.023   548.398     0.150
    52.034   548.602     0.150
    52.040   549.789     0.150
    52.134   549.703     0.150
    52.197   550.500     0.150
    52.197   550.203     0.150
    52.255   551.102     0.150
    52.351   550.805     0.150
    52.479   552.000     0.150
    52.472   551.898     0.150
    52.508   550.828     0.150
    52.607   553.102     0.150
    52.679   553.602     0.150
    52.666   553.000     0.150
    52.794   554.898     0.150
    53.045   555.602     0.150
    53.048   556.102     0.150
    53.233   558.102     0.150
    53.361   558.805     0.150
    53.394   559.305     0.150
    53.394     4.297     0.150
    53.417   559.398     0.150
    53.407   558.203     0.150
    53.407   558.203     0.150
    53.657   560.805     0.150
    53.754   560.898     0.150
    53.736   562.305     0.150
    53.742   560.898     0.150
    53.773   560.805     0.150
    53.871   562.805     0.150
    53.898   562.602     0.150
    54.037   562.898     0.150
    54.093   564.898     0.150
    54.187   565.898     0.150
    54.209   564.500     0.150
    54.179   563.625     0.150
    54.473   567.000     0.150
    54.565   566.664     0.150
    54.713   568.203     0.150
    54.742   569.305     0.150
    54.822   569.500     0.150
    54.835   569.203     0.150
    55.049   570.805     0.150
    55.047   571.102     0.150
    55.067   570.000     0.150
    54.988   570.500     0.150
    54.988  1159.898     0.150
    55.289   572.500     0.150
    55.319   572.305     0.150
    55.340   572.703     0.150
    55.443   573.805     0.150
    55.454   574.102     0.150
    55.454     4.102     0.150
    55.532   574.398     0.150
    55.581   574.305     0.150
    55.637   576.102     0.150
    55.780   575.500     0.150
    55.797   575.805     0.150
    55.812   576.203     0.150
    55.812   576.805     0.150
    55.894   576.203     0.150
    55.946   577.398     0.150
    56.040   576.828     0.150
    56.043   577.898     0.150
    56.081   577.898     0.150
    56.076   578.703     0.150
    56.086   578.102     0.150
    56.130   578.203     0.150
    56.083   577.992     0.150
    56.230   580.602     0.150
    56.247   579.805     0.150
    56.312   579.008     0.150
    56.394   579.703     0.150
    56.415   581.398     0.150
    56.430   580.641     0.150
    56.431   580.398     0.150
    56.429   580.203     0.150
    56.480   580.602     0.150
    56.485   580.898     0.150
    56.495   579.414     0.150
    56.497   579.898     0.150
    56.523   580.500     0.150
    56.590   581.500     0.150
    56.598   582.000     0.150
    56.615   580.812     0.150
    56.669   582.352     0.150
    56.703   583.102     0.150
    56.805   583.805     0.150
    56.824   582.773     0.150
    56.861   583.500     0.150
    56.898   584.062     0.150
    56.961   584.625     0.150
    56.944   584.219     0.150
    56.961   584.102     0.150
    56.967   584.578     0.150
    57.003   585.570     0.150
    57.045   584.789     0.150
    57.085   583.500     0.150
    57.121   585.703     0.150
    57.132   586.203     0.150
    57.148   584.281     0.150
    57.156   586.305     0.150
    57.166   585.320     0.150
    57.161   585.805     0.150
    57.209   586.703     0.150
    57.228   585.289     0.150
    57.230   584.898     0.150
    57.306   586.805     0.150
    57.321   585.523     0.150
    57.332   587.430     0.150
    57.360   587.211     0.150
    57.369   588.000     0.150
    57.379   588.102     0.150
    57.417   587.602     0.150
    57.425   587.805     0.150
    57.461   588.039     0.150
    57.511   588.398     0.150
    57.515   588.000     0.150
    57.599   589.203     0.150
    57.642   589.102     0.150
    57.776   590.500     0.150
    57.856   590.398     0.150
    57.922   591.578     0.150
    58.005   591.305     0.150
    58.083   592.203     0.150
    58.093   591.898     0.150
    58.174   593.203     0.150
    58.260   593.898     0.150
    58.448   595.570     0.150
    58.533   595.953     0.150
    58.591   596.203     0.150
    58.735   597.500     0.150
    58.761   597.398     0.150
    58.937   598.211     0.150
    58.944   598.305     0.150
    58.957   597.805     0.150
    59.106   599.102     0.150
    59.238   600.102     0.150
    59.401   601.102     0.150
    59.407   601.500     0.150
    59.462   601.898     0.150
    59.697   603.898     0.150
    59.720   603.703     0.150
    59.767   604.203     0.150
    59.793   603.898     0.150
    59.837   604.805     0.150
    59.875   605.102     0.150
    60.285   607.703     0.150
    60.725   611.000     0.150
    60.797   610.602     0.150
    60.866   611.305     0.150
    60.921   612.000     0.150
    61.002   612.898     0.150
    61.036   612.703     0.150
    61.255   613.703     0.150
    61.361   614.898     0.150
    61.444   614.805     0.150
    61.499   615.406     0.150
    61.628   617.000     0.150
    61.653   616.602     0.150
    61.736   618.000     0.150
    61.781   617.203     0.150
    61.781   617.102     0.150
    61.931   618.203     0.150
    61.916   618.305     0.150
    62.171   619.602     0.150
    62.338   620.805     0.150
    62.441   621.305     0.150
    62.507   623.203     0.150
    62.506   622.398     0.150
    62.481   622.000     0.150
    62.910   625.000     0.150
    62.992   626.398     0.150
    63.052   626.305     0.150
    63.110   627.000     0.150
    63.346   627.602     0.150
    63.396   627.898     0.150
    63.511   629.703     0.150
    63.707   631.000     0.150
    63.971   632.500     0.150
    64.340   634.898     0.150
    64.391   635.305     0.150
    64.444   636.203     0.150
    64.566   636.805     0.150
    64.826   637.898     0.150
    65.360   641.398     0.150
    65.889   645.203     0.150
    66.245   647.305     0.150
    66.258   647.398     0.150
    66.386   648.398     0.150
    66.589   649.305     0.150
    66.589   649.305     0.150
    66.626   649.305     0.150
    67.000   651.898     0.150
    67.161   652.398     0.150
    67.323   653.398     0.150
    67.434   653.805     0.150
    67.575   654.898     0.150
    67.609   655.703     0.150
    67.643   655.102     0.150
    67.858   657.203     0.150
    67.967   658.305     0.150
    68.199   659.305     0.150
    68.640   661.102     0.150
    68.786   661.602     0.150
    68.884   662.500     0.150
    69.389   666.398     0.150
    71.262   677.898     0.150
    72.775   687.203     0.150
    72.792   687.703     0.150
    72.846   688.398     0.150
    74.992   699.898     0.150
    74.993   700.102     0.150
    77.106   712.164     0.150
    78.053   717.805     0.150
    78.185   717.969     0.150
    78.497   721.305     0.150
    78.529   719.602     0.150
    78.918   721.305     0.150
    80.305   728.648     0.150
    80.566   730.102     0.150
    80.431   730.000     0.150
    80.809   733.102     0.150
    81.536   737.195     0.150
    81.764   738.625     0.150
    81.865   739.125     0.150
    82.078   740.203     0.150
    82.016   738.281     0.150
    85.515   755.602     0.150
    86.756   761.898     0.150
    90.282   779.703     0.150
    90.282   992.898     0.150
    91.487   786.602     0.150
   120.534  1130.664     0.150
   120.534  1131.102     0.150
   129.808  1149.820     0.150
   129.830  1150.000     0.150
   150.002  1191.602     0.150
   153.574  1190.500     0.150
    49.430   529.336     0.150
    49.430   529.336     0.150
    49.430   529.336     0.150
    49.430   529.336     0.150
    29.860   366.805     0.150
    21.368   286.781     0.150
    61.499   616.180     0.150
    46.405   505.914     0.150
    46.405   505.914     0.150
    46.405   505.914     0.150
    46.405   505.914     0.150
    46.405   505.914     0.150
    46.405   505.914     0.150
    46.405   505.891     0.150
    52.197   550.180     0.150
    52.197   550.180     0.150
    52.197   550.180     0.150
    35.739   418.141     0.150
    12.942   183.305     0.150
    12.942   183.305     0.150
    12.942   183.305     0.150
    12.942   183.633     0.150
    78.529   720.711     0.150
    78.529   720.664     0.150
    21.308   286.430     0.150
    45.713   500.516     0.150
    45.713   500.461     0.150
    45.713   500.391     0.150
    45.713   500.445     0.150
    21.204   284.922     0.150
    21.204   285.078     0.150
    21.204   284.688     0.150
    54.988   570.648     0.150
    49.638   530.922     0.150
    49.638   530.922     0.150
     6.138    91.297     0.150
     6.138    90.172     0.150
     6.138    90.172     0.150
     6.138    90.172     0.150
     6.138    90.172     0.150
     6.138    90.172     0.150
     6.138    90.172     0.150
     6.138    90.172     0.150
     6.138    89.617     0.150
     6.138    89.438     0.150
    53.407   559.125     0.150
    53.407   559.141     0.150
    53.407   559.156     0.150
    38.971   445.734     0.150
    38.971   445.734     0.150
    38.971   445.461     0.150
    38.971   445.461     0.150
    38.971   445.461     0.150
    38.971   445.461     0.150
    39.089   446.531     0.150
    39.089   446.547     0.150
    39.089   446.594     0.150
    39.089   446.531     0.150
    46.368   505.648     0.150
    27.442   345.266     0.150
    27.442   344.852     0.150
    27.442   345.352     0.150
    46.005   502.758     0.150
    14.935   210.594     0.150
    25.209   325.078     0.150
    25.209   325.148     0.150
    23.851   312.734     0.150
    23.851   312.883     0.150
    23.851   312.383     0.150
     0.275     4.859     0.150
     1.007    19.617     0.150
     1.007    31.727     0.150
     1.098    21.203     0.150
     1.098    35.250     0.150
     1.202    22.859     0.150
     1.202    39.062     0.150
     1.188    23.656     0.150
     1.188    38.859     0.150
     2.064    36.859     0.150
     2.064    63.859     0.150
     2.358    42.562     0.150
     2.689    46.859     0.150
     2.689    74.859     0.150
     2.756    45.359     0.150
     2.756    82.859     0.150
     2.816    47.859     0.150
     2.765    85.859     0.150
     3.043    53.258     0.150
     3.618    57.062     0.150
     3.618    99.758     0.150
     3.739    60.461     0.150
    46.373   506.453     0.150
    46.373   506.500     0.150
    46.373   506.438     0.150
    46.373   506.414     0.150
    46.373   506.438     0.150
     6.139    91.930     0.150
     6.139    90.297     0.150
     6.139    89.266     0.150
     6.139    89.109     0.150
     6.139    90.758     0.150
     6.139    90.758     0.150
     6.139    92.016     0.150
     6.139    90.422     0.150
     6.139    90.555     0.150
    72.779   688.547     0.150
    72.779   688.562     0.150
     1.068    19.137     0.150
     1.146    20.676     0.150
     1.146    35.865     0.150
     1.192    21.375     0.150
     1.192    38.676     0.150
     1.248    24.676     0.150
     1.248    39.875     0.150
     1.169    22.275     0.150
     1.169    38.176     0.150
     2.011    62.676     0.150
     2.301    42.576     0.150
     2.625    42.676     0.150
     2.625    77.176     0.150
     2.692    45.676     0.150
     2.759    45.676     0.150
     2.759    83.676     0.150
     2.822    49.477     0.150
     2.712    84.676     0.150
     3.046    52.676     0.150
     3.559   101.875     0.150
     1.879    34.545     0.150
     1.879    60.246     0.150
     2.012    62.676     0.150
     2.303    42.576     0.150
     3.019    52.176     0.150
     3.019    82.576     0.150
     3.130    50.826     0.150
     3.465    58.176     0.150
     3.953    61.545     0.150
     3.953   107.125     0.150
     4.375    68.066     0.150
     4.375   118.566     0.150
     4.581    71.785     0.150
     5.218    80.406     0.150
     5.775    88.545     0.150
     5.818    88.545     0.150
     5.818   151.686     0.150
     6.025    91.906     0.150
     6.233    93.566     0.150
     6.590    98.986     0.150
     6.590   169.887     0.150
     7.253   106.605     0.150
     7.253   184.125     0.150
     1.047    20.148     0.150
     1.047    33.180     0.150
     0.975    19.496     0.150
     0.975    32.609     0.150
     1.093    20.668     0.150
     1.093    35.270     0.150
     1.194    20.668     0.150
     1.194    38.066     0.150
     2.652    45.066     0.150
     2.652    81.066     0.150
     2.719    44.668     0.150
     2.719    82.168     0.150
     2.777    46.668     0.150
     3.006    49.270     0.150
     3.003    49.668     0.150
     1.464    26.957     0.150
     1.464    47.449     0.150
     1.796    33.340     0.150
     2.079    37.668     0.150
     2.079    64.668     0.150
     2.379    42.168     0.150
     2.379    73.566     0.150
     2.586    42.668     0.150
     2.586    76.668     0.150
     2.781    45.840     0.150
     2.781    81.906     0.150
     2.780    51.668     0.150
     2.780    82.668     0.150
     3.046    49.879     0.150
     2.973    54.867     0.150
     2.973    88.668     0.150
     3.029    49.668     0.150
     3.548    57.668     0.150
     3.646   109.469     0.150
     3.866    72.066     0.150
     3.866   104.340     0.150
     3.866    59.629     0.150
     3.764    60.668     0.150
     3.764   104.770     0.150
     4.297    66.297     0.150
     4.495    69.707     0.150
     4.541    88.668     0.150
     5.141    77.668     0.150
     5.141   134.797     0.150
     5.697    86.270     0.150
     5.742    85.988     0.150
     5.742   149.988     0.150
     5.949    89.430     0.150
     5.949   154.270     0.150
     6.162    91.977     0.150
     6.163    93.066     0.150
     6.163   161.066     0.150
     6.518   168.348     0.150
     7.176   104.488     0.150
     7.176   184.707     0.150
     7.834   114.348     0.150
    12.959   179.668     0.150
    21.341   288.566     0.150
    72.752   688.270     0.150
    12.959   183.230     0.150
     6.163    90.934     0.150
     6.163    91.605     0.150
     6.163   161.453     0.150
     6.163   161.453     0.150
     6.163   162.781     0.150
     6.163   160.012     0.150
     6.163   162.355     0.150
     1.003    17.516     0.150
     1.003    30.484     0.150
     1.001    19.246     0.150
     1.001    31.137     0.150
     1.104    20.605     0.150
     1.118    18.605     0.150
     1.118    35.105     0.150
     1.144    22.906     0.150
     1.144    38.406     0.150
     2.028    36.406     0.150
     2.028    62.406     0.150
     2.337    43.305     0.150
     2.498    44.406     0.150
     2.498    77.406     0.150
     2.564    43.406     0.150
     2.564    81.406     0.150
     2.690    47.406     0.150
     2.690    85.406     0.150
     2.964    84.605     0.150
     2.917    48.406     0.150
     2.917    88.406     0.150
     3.730    59.508     0.150
     1.024    18.648     0.150
     1.024    31.219     0.150
     1.066    20.398     0.150
     1.066    33.398     0.150
     1.137    22.648     0.150
     1.137    39.250     0.150
     1.147    19.453     0.150
     1.147    35.148     0.150
     1.185    24.250     0.150
     1.185    39.750     0.150
     2.027    37.250     0.150
     2.027    64.250     0.150
     2.561    44.750     0.150
     2.561    78.750     0.150
     2.628    76.250     0.150
     2.694    45.750     0.150
     2.694    80.250     0.150
     2.755    49.250     0.150
     2.755    86.250     0.150
     2.982    52.750     0.150
     2.982    95.750     0.150
     2.952    57.250     0.150
     2.952    90.250     0.150
     0.276     4.793     0.150
     0.276     7.953     0.150
     1.089    19.163     0.150
     1.089    32.123     0.150
     1.143    20.963     0.150
     1.143    37.763     0.150
     1.211    25.263     0.150
     1.211    41.062     0.150
     1.985    36.463     0.150
     1.985    62.463     0.150
     2.607    43.963     0.150
     2.607    79.463     0.150
     2.674    46.463     0.150
     2.741    45.463     0.150
     2.741    82.463     0.150
     2.806    48.463     0.150
     3.536    56.763     0.150
     3.029    51.263     0.150
     3.029    91.263     0.150
    49.315   529.566     0.150
    49.315   529.518     0.150
    49.315   529.596     0.150
    46.296   506.146     0.150
    46.296   506.127     0.150
    46.296   506.104     0.150
    46.296   506.127     0.150
    46.296   506.201     0.150
    46.296   506.139     0.150
     6.056    90.104     0.150
     6.056    89.205     0.150
     6.056    88.643     0.150
     6.056    89.878     0.150
     6.056    89.878     0.150
     6.056    89.878     0.150
     6.056    90.256     0.150
     6.056   159.400     0.150
     6.056   159.400     0.150
     6.056   159.400     0.150
     6.056   159.400     0.150
    53.299   559.439     0.150
    53.299   559.440     0.150
    53.299   559.416     0.150
     0.573    10.895     0.150
     0.573    17.645     0.150
     0.859    16.344     0.150
     0.869    16.094     0.150
     0.869    27.344     0.150
     0.976    18.344     0.150
     0.976    31.344     0.150
     1.030    19.564     0.150
     1.114    21.293     0.150
     1.114    35.123     0.150
     1.211    38.395     0.150
     2.043    37.094     0.150
     2.043    64.094     0.150
     2.335    41.793     0.150
     2.576    77.293     0.150
     2.621    44.594     0.150
     2.621    78.594     0.150
     2.688    46.895     0.150
     2.688    76.895     0.150
     2.754    46.094     0.150
     2.754    84.094     0.150
     2.744    86.994     0.150
     2.816    48.895     0.150
     2.816    85.895     0.150
     3.041    51.895     0.150
     3.041    91.895     0.150
     3.595    98.094     0.150
     4.691    80.594     0.150
     1.154    36.494     0.150
     2.043    37.094     0.150
     2.043    64.094     0.150
     2.337    41.793     0.150
     2.838    46.443     0.150
     3.094    50.645     0.150
     3.012    49.094     0.150
     3.501    57.594     0.150
     3.716    59.895     0.150
     3.716   103.994     0.150
     3.917    61.225     0.150
     3.917   107.004     0.150
     4.340    67.824     0.150
     4.545    70.463     0.150
     5.184   136.244     0.150
     5.784   152.084     0.150
     7.219   105.703     0.150
     7.219   186.725     0.150
     7.875   201.383     0.150
     0.086     2.648     0.150
     0.086     4.742     0.150
     0.241     3.328     0.150
     0.241     6.492     0.150
     0.245     4.609     0.150
     0.292     5.617     0.150
     0.292     9.523     0.150
     0.324     5.969     0.150
     0.324    10.438     0.150
     0.577    10.891     0.150
     0.860    17.141     0.150
     1.002    19.062     0.150
     1.002    32.344     0.150
     1.070    20.250     0.150
     1.070    33.703     0.150
     1.120    22.141     0.150
     1.120    36.141     0.150
     1.173    37.141     0.150
     1.181    22.641     0.150
     1.181    39.242     0.150
     2.056    38.141     0.150
     2.056    64.141     0.150
     2.590    78.141     0.150
     0.042     2.070     0.150
     0.042     4.500     0.150
     0.216     4.406     0.150
     0.216     7.359     0.150
     0.221     8.250     0.150
     0.268     5.203     0.150
     0.292     9.297     0.150
     0.546    10.203     0.150
     0.822    14.453     0.150
     0.828    15.750     0.150
     0.828    27.250     0.150
     1.023    18.484     0.150
     1.023    31.516     0.150
     1.067    19.992     0.150
     1.067    34.484     0.150
     1.149    21.250     0.150
     1.149    35.750     0.150
     2.028    35.953     0.150
     2.028    61.953     0.150
     2.328    41.656     0.150
     2.563    41.453     0.150
     2.563    74.453     0.150
     2.633    44.703     0.150
     2.630    41.656     0.150
     2.697    45.953     0.150
     2.858    44.852     0.150
     2.858    83.555     0.150
     2.757    44.453     0.150
     2.730    46.555     0.150
     2.730    75.953     0.150
     3.715    58.953     0.150
     3.715   101.953     0.150
     7.367   105.703     0.150
     7.367   184.930     0.150
    11.240   159.727     0.150
    11.240   278.984     0.150
    12.867   180.570     0.150
    12.867   313.031     0.150
    13.894   193.930     0.150
    13.894   339.875     0.150
     1.512    27.422     0.150
     1.846    33.562     0.150
     2.028    35.953     0.150
     2.028    61.953     0.150
     2.329    41.656     0.150
     2.633    80.352     0.150
     2.730    46.953     0.150
     2.828    46.203     0.150
     2.954    48.352     0.150
     3.095    50.141     0.150
     3.309    53.953     0.150
     3.498    56.352     0.150
     3.498    97.250     0.150
     3.597    96.852     0.150
     4.347    67.461     0.150
     4.544    69.641     0.150
     4.998    73.953     0.150
     5.192    78.641     0.150
     5.533    79.453     0.150
     5.747    85.945     0.150
     5.793    86.641     0.150
     6.037   105.953     0.150
     5.999    89.000     0.150
     6.110    92.656     0.150
     6.110   159.656     0.150
     6.114    91.297     0.150
     6.114   161.094     0.150
     6.212    92.023     0.150
     6.569    97.320     0.150
     6.927   102.750     0.150
     7.183   106.055     0.150
     7.367   105.555     0.150
     7.367   184.625     0.150
     7.226   105.562     0.150
     7.564   112.250     0.150
     7.884   114.906     0.150
     7.820   116.750     0.150
     7.979   117.750     0.150
     8.385   124.922     0.150
     8.419   125.258     0.150
     8.419   125.344     0.150
     8.451   125.430     0.150
     8.509   126.641     0.150
     8.512   126.242     0.150
     8.511   126.422     0.150
     8.532   125.422     0.150
     8.520   126.461     0.150
     8.532   125.734     0.150
     8.535   125.969     0.150
     8.523   126.422     0.150
     8.538   125.961     0.150
     8.557   126.148     0.150
     8.542   126.680     0.150
     8.566   126.617     0.150
     8.609   126.945     0.150
     8.787   125.625     0.150
     8.681   127.695     0.150
     8.731   128.188     0.150
     8.907   130.320     0.150
     8.949   130.781     0.150
     8.957   130.875     0.150
     9.093   132.281     0.150
     9.181   133.148     0.150
     9.197   133.438     0.150
     9.247   133.961     0.150
     9.247   238.656     0.150
     9.311   238.570     0.150
     9.326   134.719     0.150
     9.998   144.414     0.150
    10.226   147.352     0.150
    10.226   261.750     0.150
    11.240   159.727     0.150
    11.240   278.984     0.150
    12.061   167.953     0.150
    12.061   296.453     0.150
    12.867   180.570     0.150
    12.867   181.836     0.150
    12.974   179.453     0.150
    12.974   316.953     0.150
    13.151   183.352     0.150
    13.151   323.055     0.150
    13.894   339.875     0.150
    13.894   192.477     0.150
    14.908   209.156     0.150
    14.908   518.352     0.150
    14.908   732.250     0.150
    18.923   258.953     0.150
    18.972   260.352     0.150
    20.970   282.352     0.150
    21.198   285.250     0.150
    21.198   525.453     0.150
    21.320   286.555     0.150
    21.391   288.523     0.150
    21.391   531.539     0.150
    23.820   311.055     0.150
    24.291   317.555     0.150
    24.556   317.953     0.150
    24.556   581.953     0.150
    25.207   324.953     0.150
    26.572   338.656     0.150
    26.810   340.750     0.150
    26.789   339.953     0.150
    27.797   348.344     0.150
    28.008   351.555     0.150
    28.225   352.953     0.150
    29.471   364.453     0.150
    29.827   367.656     0.150
    30.066   369.453     0.150
    30.812   376.953     0.150
    31.353   380.766     0.150
    31.360   380.953     0.150
    31.924   386.055     0.150
    31.924   453.953     0.150
    31.924   454.156     0.150
    31.923   385.055     0.150
    35.782   418.453     0.150
    35.779   418.953     0.150
    36.387   423.953     0.150
    36.287   422.852     0.150
    37.098   429.352     0.150
    38.604   442.953     0.150
    38.891   445.805     0.150
    38.939   444.797     0.150
    39.059   446.555     0.150
    39.059   807.961     0.150
    39.059   808.750     0.150
    40.487   458.703     0.150
    41.627   467.453     0.150
    43.428   482.750     0.150
    43.952   485.953     0.150
    44.923   493.953     0.150
    45.278   497.953     0.150
    45.210   494.953     0.150
    45.669   499.953     0.150
    45.680   500.156     0.150
    45.982   502.953     0.150
    46.128   502.953     0.150
    46.339   504.555     0.150
    46.339   617.156     0.150
    46.374   505.625     0.150
    46.470   506.352     0.150
    46.559   506.453     0.150
    46.789   508.852     0.150
    47.340   512.453     0.150
    47.465     4.203     0.150
    47.909   515.953     0.150
    49.020   525.352     0.150
    49.028   525.344     0.150
    49.219   528.453     0.150
    49.396   529.336     0.150
    49.611   530.750     0.150
    49.951   532.914     0.150
    50.244   535.555     0.150
    50.389   536.453     0.150
    50.868   539.156     0.150
    50.900   538.156     0.150
    50.782   538.953     0.150
    51.085   542.156     0.150
    51.494   545.477     0.150
    51.543   545.656     0.150
    51.585   545.312     0.150
    51.600   545.297     0.150
    51.820   547.852     0.150
    51.885   548.453     0.150
    51.882   547.750     0.150
    51.876   548.352     0.150
    51.876     4.500     0.150
    52.001   548.297     0.150
    52.013   548.703     0.150
    52.017   549.445     0.150
    52.170   550.156     0.150
    52.170   550.102     0.150
    52.228   550.453     0.150
    52.444   551.953     0.150
    52.476   550.750     0.150
    52.476     5.805     0.150
    52.581   552.953     0.150
    52.653   553.352     0.150
    53.023   555.977     0.150
    53.210   558.297     0.150
    53.154   556.156     0.150
    53.367   559.156     0.150
    53.367     4.594     0.150
    53.393   559.156     0.150
    53.376   558.156     0.150
    53.376   558.562     0.150
    53.633   560.859     0.150
    53.731   561.109     0.150
    53.716   560.750     0.150
    53.709   562.055     0.150
    53.747   560.750     0.150
    53.844   562.852     0.150
    53.872   562.352     0.150
    54.011   562.750     0.150
    54.068   564.906     0.150
    54.065   562.953     0.150
    54.163   565.477     0.150
    54.541   566.727     0.150
    54.687   568.250     0.150
    54.716   568.750     0.150
    54.795   569.656     0.150
    54.809   569.156     0.150
    55.023   570.852     0.150
    55.020   571.250     0.150
    55.043   569.992     0.150
    54.976   570.766     0.150
    54.966   570.656     0.150
    54.966  1032.156     0.150
    55.263   572.555     0.150
    55.292   572.750     0.150
    55.314   572.656     0.150
    55.427   573.852     0.150
    55.506   574.656     0.150
    55.555   574.250     0.150
    55.612   575.992     0.150
    55.753   575.555     0.150
    55.772   575.750     0.150
    55.786   576.250     0.150
    55.695   575.453     0.150
    55.868   576.352     0.150
    55.919   576.953     0.150
    55.945   577.352     0.150
    56.016   577.852     0.150
    56.055   577.953     0.150
    56.060   578.055     0.150
    56.104   578.352     0.150
    56.219   579.953     0.150
    56.219     4.500     0.150
    56.287   578.727     0.150
    56.370   579.453     0.150
    56.388   581.156     0.150
    56.404   580.750     0.150
    56.453   581.852     0.150
    56.459   580.750     0.150
    56.470   578.820     0.150
    56.471   579.750     0.150
    56.590   580.914     0.150
    56.658   582.250     0.150
    56.677   583.055     0.150
    56.779   583.852     0.150
    56.799   583.102     0.150
    56.834   583.352     0.150
    56.874   583.500     0.150
    56.936   583.891     0.150
    56.975   585.305     0.150
    57.021   583.992     0.150
    57.039   585.352     0.150
    57.060   583.602     0.150
    57.096   584.555     0.150
    57.107   586.156     0.150
    57.123   583.891     0.150
    57.130   586.250     0.150
    57.141   585.297     0.150
    57.135   585.656     0.150
    57.185   586.555     0.150
    57.203   584.695     0.150
    57.205   585.000     0.150
    57.207   586.250     0.150
    57.296   584.992     0.150
    57.307   587.586     0.150
    57.333   587.305     0.150
    57.344   587.852     0.150
    57.353   587.852     0.150
    57.392   587.852     0.150
    57.400   587.352     0.150
    57.486   588.344     0.150
    57.490   587.953     0.150
    57.573   589.055     0.150
    57.617   589.562     0.150
    57.748   590.453     0.150
    57.832   590.250     0.150
    57.894   591.227     0.150
    57.980   591.156     0.150
    58.059   592.055     0.150
    58.068   591.750     0.150
    58.091   592.852     0.150
    58.146   593.055     0.150
    58.235   593.250     0.150
    58.423   595.156     0.150
    58.508   595.555     0.150
    58.545   595.953     0.150
    58.566   595.750     0.150
    58.710   597.555     0.150
    58.736   596.656     0.150
    58.818   597.953     0.150
    58.918   598.352     0.150
    58.931   597.750     0.150
    59.079   599.055     0.150
    59.211   599.953     0.150
    59.374   600.953     0.150
    59.381   601.742     0.150
    59.672   603.750     0.150
    59.694   603.750     0.150
    59.740   604.250     0.150
    59.767   603.750     0.150
    59.811   603.750     0.150
    60.259   607.555     0.150
    60.699   610.852     0.150
    60.842   611.352     0.150
    60.842     3.500     0.150
    60.976   612.852     0.150
    61.011   612.750     0.150
    61.228   613.555     0.150
    61.336   614.953     0.150
    61.417   614.656     0.150
    61.469   615.398     0.150
    61.469     4.320     0.150
    61.534   617.555     0.150
    61.603   616.852     0.150
    61.755   617.055     0.150
    61.754   617.055     0.150
    61.907   618.156     0.150
    62.431   621.586     0.150
    62.416   621.250     0.150
    62.447   621.156     0.150
    62.679     3.195     0.150
    62.882   624.953     0.150
    62.968   625.953     0.150
    63.085   626.953     0.150
    63.319   627.555     0.150
    63.369   627.750     0.150
    63.486   630.055     0.150
    64.420   636.250     0.150
    64.801   637.852     0.150
    64.801     3.602     0.150
    65.337   641.250     0.150
    65.643   644.109     0.150
    65.866   645.250     0.150
    66.222   647.453     0.150
    66.236   647.750     0.150
    66.361   648.156     0.150
    66.361     4.000     0.150
    66.565   649.352     0.150
    66.565   649.555     0.150
    66.565     3.695     0.150
    66.649   649.352     0.150
    66.977   652.156     0.150
    66.977     3.500     0.150
    67.138   652.750     0.150
    67.300   653.250     0.150
    67.300     4.500     0.150
    67.411   653.953     0.150
    67.411     4.203     0.150
    67.552   654.953     0.150
    67.943   658.250     0.150
    67.943     4.305     0.150
    68.176   659.352     0.150
    68.617   661.352     0.150
    68.862   662.953     0.150
    69.366   666.555     0.150
    71.233   678.352     0.150
    72.800   687.602     0.150
    72.817   687.656     0.150
    75.018   700.352     0.150
    75.020   700.250     0.150
    75.623   704.055     0.150
    77.078   712.305     0.150
    78.157   718.000     0.150
    78.157   718.156     0.150
    78.470   721.453     0.150
    78.500   718.906     0.150
    78.500   894.703     0.150
    79.637   726.164     0.150
    80.781   733.352     0.150
    81.559   736.836     0.150
    81.702   738.141     0.150
    81.755   738.477     0.150
    81.856   738.914     0.150
    82.070   739.992     0.150
    81.989   739.453     0.150
    85.542   756.352     0.150
    86.725   761.250     0.150
   149.984  1189.953     0.150
    49.396   529.250     0.150
    49.396   529.234     0.150
    49.396   529.234     0.150
    49.396   529.234     0.150
    49.396   529.234     0.150
    49.396   529.234     0.150
    49.396   529.250     0.150
    29.827   366.656     0.150
    75.020   701.086     0.150
    21.391   287.234     0.150
    21.391   287.234     0.150
    46.374   505.812     0.150
    46.374   505.812     0.150
    46.374   505.812     0.150
    46.374   505.812     0.150
    46.374   505.812     0.150
    46.374   505.812     0.150
    46.374   505.812     0.150
    52.170   550.117     0.150
    52.170   550.078     0.150
    52.170   550.133     0.150
    12.974   183.961     0.150
    12.974   183.961     0.150
    12.974   183.961     0.150
    12.974   184.023     0.150
    78.500   720.727     0.150
    78.500   720.727     0.150
    78.500   720.727     0.150
    45.680   500.344     0.150
    45.680   500.344     0.150
    21.198   285.148     0.150
    21.198   285.148     0.150
    21.198   284.914     0.150
    49.611   530.820     0.150
    49.611   530.891     0.150
     6.114    88.898     0.150
     6.114    88.359     0.150
     6.114    89.945     0.150
     6.114    89.352     0.150
     6.114   159.578     0.150
     6.114   159.672     0.150
    53.376   559.055     0.150
    53.376   559.055     0.150
    53.376   559.055     0.150
    53.376   559.055     0.150
    38.939   445.500     0.150
    38.939   445.508     0.150
    39.059   446.430     0.150
    39.059   446.445     0.150
    39.059   446.492     0.150
    39.059   446.461     0.150
    46.339   505.547     0.150
    49.028   526.281     0.150
    45.982   502.656     0.150
    72.800   688.031     0.150
    72.800   688.070     0.150
    25.207   325.375     0.150
    23.820   312.484     0.150
    23.820   312.633     0.150
     0.054     2.625     0.150
     0.056     4.336     0.150
     0.072     1.000     0.150
     0.063     2.945     0.150
     0.063     5.039     0.150
     0.223     4.430     0.150
     0.223     7.734     0.150
     0.219     4.453     0.150
     0.219     4.555     0.150
     0.219     7.414     0.150
     0.219     7.594     0.150
     0.262     5.359     0.150
     0.292     5.594     0.150
     0.292     9.336     0.150
     1.025    18.289     0.150
     1.025    31.773     0.150
     1.070    20.375     0.150
     1.070    34.898     0.150
     1.149    21.734     0.150
     1.149    37.039     0.150
     1.139    20.133     0.150
     1.188    22.836     0.150
     1.188    38.039     0.150
     2.027    35.836     0.150
     2.027    62.836     0.150
     2.327    41.734     0.150
     2.565    41.336     0.150
     2.565    74.836     0.150
     2.635    44.836     0.150
     2.635    75.836     0.150
     2.859    45.836     0.150
     2.859    79.336     0.150
     2.729    46.438     0.150
     2.729    80.836     0.150
     3.596    96.836     0.150
     3.143    53.336     0.150
     3.317    52.836     0.150
     3.317    91.039     0.150
     3.713    59.836     0.150
     5.734    84.836     0.150
     7.370   105.875     0.150
     7.370   185.664     0.150
    11.242   159.430     0.150
    12.869   180.336     0.150
    12.869   315.336     0.150
    12.937   179.836     0.150
    13.897   192.773     0.150
    13.897   337.758     0.150
     1.513    27.242     0.150
     1.847    33.727     0.150
     2.028    35.836     0.150
     2.028    62.836     0.150
     2.328    41.734     0.150
     2.565    40.836     0.150
     2.829    46.383     0.150
     2.956    48.836     0.150
     2.956    89.234     0.150
     3.097    50.164     0.150
     3.308    52.836     0.150
     3.497    56.234     0.150
     3.497    96.734     0.150
     3.713   102.633     0.150
     4.348    67.578     0.150
     4.546    69.664     0.150
     5.001    73.836     0.150
     5.001   129.836     0.150
     5.193    78.383     0.150
     5.536    79.836     0.150
     5.734    84.836     0.150
     5.748    85.734     0.150
     5.794    86.469     0.150
     6.000    88.984     0.150
     6.213    92.938     0.150
     6.108    93.133     0.150
     6.113    92.078     0.150
     6.113   160.914     0.150
     6.569    97.578     0.150
     6.927   102.836     0.150
     7.227   105.609     0.150
     7.370   186.469     0.150
     7.182   106.938     0.150
     7.182   184.938     0.150
     7.564   112.633     0.150
     7.885   114.797     0.150
     7.979   117.633     0.150
     8.289   123.664     0.150
     8.342   124.570     0.150
     8.384   125.312     0.150
     8.402   126.492     0.150
     8.405   125.805     0.150
     8.418   125.852     0.150
     8.418   125.562     0.150
     8.450   126.203     0.150
     8.457   127.117     0.150
     8.476   126.055     0.150
     8.511   126.258     0.150
     8.508   126.984     0.150
     8.510   126.734     0.150
     8.531   125.695     0.150
     8.534   126.164     0.150
     8.531   126.812     0.150
     8.519   126.773     0.150
     8.522   126.789     0.150
     8.537   127.016     0.150
     8.547   127.391     0.150
     8.556   126.070     0.150
     8.540   126.992     0.150
     8.608   127.500     0.150
     8.789   125.703     0.150
     8.680   128.172     0.150
     8.730   128.742     0.150
     8.906   130.312     0.150
     8.948   130.945     0.150
     8.957   131.398     0.150
     9.092   132.844     0.150
     9.171   133.414     0.150
     9.171   236.859     0.150
     9.180   133.305     0.150
     9.180   236.227     0.150
     9.197   133.695     0.150
     9.197   236.906     0.150
     9.247   134.180     0.150
     9.247   235.609     0.150
     9.277   138.859     0.150
     9.277   236.977     0.150
     9.311   135.250     0.150
     9.311   237.250     0.150
     9.326   135.422     0.150
     9.326   237.938     0.150
     9.485   136.836     0.150
     9.485   239.836     0.150
     9.918   139.539     0.150
     9.997   144.555     0.150
    10.225   147.633     0.150
    11.242   159.430     0.150
    12.869   180.336     0.150
    12.869   315.336     0.150
    12.977   179.836     0.150
    13.154   183.539     0.150
    13.154   322.633     0.150
    13.897   192.695     0.150
    14.905   208.836     0.150
    18.970   261.836     0.150
    18.970   268.836     0.150
    20.969   282.438     0.150
    21.197   285.836     0.150
    21.392   287.734     0.150
    23.817   311.664     0.150
    24.291   317.438     0.150
    25.206   325.133     0.150
    26.808   340.836     0.150
    31.359   380.836     0.150
    38.603   442.836     0.150
    38.936   445.000     0.150
    39.057   446.539     0.150
    40.485   459.797     0.150
    46.468   506.633     0.150
    46.787   508.938     0.150
    49.394   529.539     0.150
    49.610   531.133     0.150
    50.242   535.734     0.150
    51.541   545.836     0.150
    51.875   548.539     0.150
    52.169   550.508     0.150
    52.226   550.836     0.150
    52.652   553.836     0.150
    53.336   558.938     0.150
    53.365   558.836     0.150
    53.392   559.336     0.150
    53.374   557.938     0.150
    53.374   558.539     0.150
    53.707   562.539     0.150
    56.369   579.633     0.150
    56.451   581.234     0.150
    56.833   583.438     0.150
    57.133   585.836     0.150
    57.206   586.438     0.150
    57.342   588.039     0.150
    57.352   588.039     0.150
    57.488   588.039     0.150
    57.830   590.438     0.150
    57.979   591.336     0.150
    58.057   592.133     0.150
    58.067   591.836     0.150
    58.917   598.438     0.150
    59.078   599.234     0.150
    59.210   600.039     0.150
    59.373   601.133     0.150
    59.671   603.938     0.150
    60.258   607.734     0.150
    60.698   610.836     0.150
    61.009   612.836     0.150
    61.227   613.633     0.150
    61.467   615.492     0.150
    61.601   616.836     0.150
    61.753   617.234     0.150
    62.431   622.617     0.150
    62.415   622.133     0.150
    63.084   627.133     0.150
    63.317   627.234     0.150
    66.650   649.438     0.150
    66.564   650.055     0.150
    72.802   687.836     0.150
    72.818   687.836     0.150
    75.019   700.336     0.150
    75.021   700.336     0.150
    78.498   719.422     0.150
    78.498   894.586     0.150
    81.702   738.719     0.150
    85.543   756.336     0.150
    86.722   762.883     0.150
    90.246   779.938     0.150
    49.394   529.289     0.150
    49.394   529.367     0.150
    49.394   529.367     0.150
    49.394   529.367     0.150
    49.394   529.367     0.150
    49.394   529.367     0.150
    49.394   529.367     0.150
    49.394   529.367     0.150
    75.021   701.203     0.150
    75.021   701.203     0.150
    75.021   701.203     0.150
    75.021   701.203     0.150
    75.021   701.211     0.150
    21.392   287.094     0.150
    21.392   287.328     0.150
    21.392   287.367     0.150
    46.372   505.961     0.150
    46.372   505.945     0.150
    46.372   505.922     0.150
    46.372   505.945     0.150
    46.372   505.945     0.150
    46.372   505.945     0.150
    52.169   550.273     0.150
    12.977   184.008     0.150
    12.977   184.008     0.150
    12.977   184.008     0.150
    12.977   184.008     0.150
    78.498   720.812     0.150
    78.498   720.773     0.150
    78.498   720.867     0.150
    78.498   720.867     0.150
    21.197   285.109     0.150
    21.197   285.266     0.150
    21.197   284.922     0.150
    49.610   531.008     0.150
     6.113   160.109     0.150
     6.113   159.836     0.150
    53.374   559.188     0.150
    53.374   559.188     0.150
    53.374   559.188     0.150
    38.936   445.578     0.150
    38.936   445.578     0.150
    38.936   445.578     0.150
    38.936   445.578     0.150
    39.057   446.578     0.150
    39.057   446.578     0.150
    85.543   757.836     0.150
    72.802   688.211     0.150
    72.802   688.211     0.150
    72.802   688.211     0.150
    72.802   688.211     0.150
    72.802   688.211     0.150
    25.206   325.523     0.150
    25.206   325.359     0.150
    25.206   325.359     0.150
    86.722   763.688     0.150
    23.817   312.719     0.150
    23.817   312.719     0.150
    23.817   312.719     0.150
    23.817   312.719     0.150
     0.049     2.461     0.150
     0.049     4.266     0.150
     0.065     2.617     0.150
     0.065     3.367     0.150
     0.048     4.891     0.150
     0.070     2.773     0.150
     0.070     4.844     0.150
     0.213     4.266     0.150
     0.213     7.219     0.150
     0.217     4.258     0.150
     0.217     7.727     0.150
     0.262     5.219     0.150
     0.257     5.195     0.150
     0.286     5.445     0.150
     0.286     9.211     0.150
     0.540    10.914     0.150
     0.816    15.117     0.150
     0.816    26.117     0.150
     0.822    15.320     0.150
     1.141    19.617     0.150
     1.141    37.414     0.150
     1.143    21.117     0.150
     1.143    38.117     0.150
     2.692    47.617     0.150
     2.692    81.617     0.150
     0.058     1.703     0.150
     0.058     2.969     0.150
     0.077     2.609     0.150
     0.126     3.125     0.150
     0.126     5.609     0.150
     0.249     4.719     0.150
     0.249     8.336     0.150
     0.249     4.109     0.150
     0.249     7.266     0.150
     0.344     6.586     0.150
     0.346     6.492     0.150
     0.366     6.828     0.150
     0.366    11.555     0.150
     0.626    11.836     0.150
     0.897    16.836     0.150
     0.894    16.984     0.150
     0.894    28.383     0.150
     1.060    19.188     0.150
     1.060    33.289     0.150
     0.942    19.133     0.150
     0.942    33.195     0.150
     1.114    21.383     0.150
     1.114    35.383     0.150
     1.220    23.383     0.150
     1.220    39.883     0.150
     2.111    38.086     0.150
     2.111    66.086     0.150
     2.411    42.586     0.150
     2.411    74.586     0.150
     2.593    32.400     0.150
     2.725    47.086     0.150
     3.680   100.289     0.150
     3.228    52.586     0.150
     7.348   106.930     0.150
     7.348   182.266     0.150
     0.077     2.727     0.150
     0.077     4.883     0.150
     0.050     2.586     0.150
     0.050     4.625     0.150
     0.088     4.055     0.150
     0.088     2.055     0.150
     0.187     4.535     0.150
     0.187     7.934     0.150
     0.224     4.055     0.150
     0.230     4.977     0.150
     0.230     8.133     0.150
     0.234     4.695     0.150
     0.234     8.254     0.150
     0.288     5.305     0.150
     0.293     5.805     0.150
     0.288     5.684     0.150
     0.571    11.305     0.150
     0.846    15.555     0.150
     0.852    15.555     0.150
     0.852    27.555     0.150
     0.966    17.805     0.150
     1.001    18.945     0.150
     1.001    32.543     0.150
     1.061    20.273     0.150
     1.061    35.184     0.150
     1.173    21.254     0.150
     1.173    35.855     0.150
     1.169    22.355     0.150
     1.169    36.754     0.150
     2.579    42.555     0.150
     2.712    45.055     0.150
     2.877    45.855     0.150
     2.877    85.055     0.150
     2.755    45.055     0.150
     2.755    77.055     0.150
     2.977    49.254     0.150
     3.620    58.254     0.150
     3.342    39.400     0.150
     3.738    59.055     0.150
     3.738   102.055     0.150
     4.715    53.500     0.150
     5.747    87.035     0.150
     5.747   151.523     0.150
     7.369   105.785     0.150
     7.369   184.695     0.150
     8.767   125.477     0.150
     8.767   220.453     0.150
    11.257   160.477     0.150
    11.257   281.965     0.150
    12.036   168.855     0.150
    12.036   296.055     0.150
    12.873   180.074     0.150
    12.873   312.855     0.150
    13.140   183.254     0.150
    13.899   192.715     0.150
    13.899   339.285     0.150
     1.490    26.695     0.150
     1.822    32.496     0.150
     2.053    36.055     0.150
     2.053    63.055     0.150
     2.353    41.555     0.150
     2.579    77.055     0.150
     2.807    45.977     0.150
     2.755    45.453     0.150
     2.755    77.555     0.150
     2.968    49.453     0.150
     2.968    93.855     0.150
     3.072    49.793     0.150
     3.072    85.793     0.150
     3.072    85.195     0.150
     3.003    49.254     0.150
     3.003    85.055     0.150
     3.333    55.055     0.150
     3.522    56.453     0.150
     3.522    97.953     0.150
     4.323    67.156     0.150
     4.323   115.195     0.150
     4.521    69.316     0.150
     4.475    70.555     0.150
     4.475   122.555     0.150
     4.998    74.055     0.150
     4.998   130.055     0.150
     5.167    78.113     0.150
     5.167   135.254     0.150
     5.747    87.035     0.150
     5.747   151.523     0.150
     5.723    85.375     0.150
     5.723   147.055     0.150
     5.768    86.156     0.150
     5.768   149.934     0.150
     5.974    89.355     0.150
     5.974   154.176     0.150
     5.963    89.156     0.150
     5.963   154.156     0.150
     6.187    92.895     0.150
     6.187   161.375     0.150
     6.133    92.656     0.150
     6.133   159.656     0.150
     6.137    92.180     0.150
     6.544    97.113     0.150
     6.544   168.316     0.150
     6.952   102.453     0.150
     7.369   183.254     0.150
     7.207   106.055     0.150
     7.207   185.055     0.150
     7.860   115.133     0.150
     7.860   198.953     0.150
     8.270   123.961     0.150
     8.324   124.508     0.150
     8.365   124.551     0.150
     8.381   125.848     0.150
     8.384   125.145     0.150
     8.384   218.918     0.150
     8.397   125.461     0.150
     8.397   218.934     0.150
     8.398   125.051     0.150
     8.429   125.777     0.150
     8.436   126.574     0.150
     8.455   126.098     0.150
     8.486   126.824     0.150
     8.490   125.531     0.150
     8.509   125.484     0.150
     8.490   126.164     0.150
     8.490   221.945     0.150
     8.512   125.777     0.150
     8.510   126.711     0.150
     8.498   126.711     0.150
     8.502   126.211     0.150
     8.516   126.848     0.150
     8.525   127.074     0.150
     8.525   222.359     0.150
     8.534   126.188     0.150
     8.520   127.004     0.150
     8.586   126.961     0.150
     8.767   125.363     0.150
     8.767   220.434     0.150
     8.658   127.688     0.150
     8.708   128.277     0.150
     8.883   130.391     0.150
     8.925   131.391     0.150
     8.934   130.891     0.150
     9.069   131.684     0.150
     9.069   235.164     0.150
     9.148   133.180     0.150
     9.148   235.254     0.150
     9.157   133.180     0.150
     9.157   236.535     0.150
     9.223   134.082     0.150
     9.223   238.051     0.150
     9.253   138.926     0.150
     9.253   240.203     0.150
     9.287   134.891     0.150
     9.287   238.781     0.150
     9.302   135.719     0.150
     9.302   239.539     0.150
     9.499   137.754     0.150
     9.499   239.555     0.150
     9.975   144.617     0.150
    10.201   148.254     0.150
    11.198   279.227     0.150
    11.257   160.477     0.150
    11.257   161.316     0.150
    11.257   281.965     0.150
    12.231   170.555     0.150
    12.873   180.055     0.150
    12.873   182.664     0.150
    12.971   180.055     0.150
    12.971   317.055     0.150
    13.140   183.254     0.150
    13.140   184.016     0.150
    13.140   184.305     0.150
    13.140   321.484     0.150
    13.899   193.055     0.150
    13.899   338.055     0.150
    14.902   208.656     0.150
    18.947   259.055     0.150
    18.954   260.055     0.150
    20.946   281.855     0.150
    21.177   285.055     0.150
    21.294   287.254     0.150
    21.367   287.406     0.150
    24.266   317.055     0.150
    24.558   318.055     0.150
    24.558   581.055     0.150
    25.184   324.555     0.150
    26.563   339.156     0.150
    26.791   340.453     0.150
    26.779   339.555     0.150
    27.788   349.953     0.150
    30.835   377.055     0.150
    30.835   433.055     0.150
    31.333   381.164     0.150
    31.341   381.055     0.150
    31.947   385.953     0.150
    35.706   418.746     0.150
    36.278   424.055     0.150
    38.586   442.656     0.150
    38.757   444.055     0.150
    38.915   446.055     0.150
    39.078   446.855     0.150
    39.078    11.199     0.150
    39.078    11.301     0.150
    40.466   457.504     0.150
    41.609   468.156     0.150
    43.412   482.855     0.150
    45.202   495.055     0.150
    46.391   505.879     0.150
    46.487   506.855     0.150
    46.807   508.953     0.150
    48.176   519.754     0.150
    49.016   525.555     0.150
    49.410   529.754     0.150
    49.633   531.254     0.150
    50.266   535.855     0.150
    50.766   538.953     0.150
    51.564   545.855     0.150
    51.843   548.055     0.150
    51.904   548.055     0.150
    51.898   548.555     0.150
    52.192   550.703     0.150
    52.250   551.055     0.150
    52.465   552.055     0.150
    52.676   553.656     0.150
    53.361   558.953     0.150
    53.388   559.656     0.150
    53.394   557.855     0.150
    53.394   558.680     0.150
    53.731   562.355     0.150
    53.738   561.055     0.150
    54.033   562.953     0.150
    54.092   565.254     0.150
    54.832   569.754     0.150
    54.955   570.453     0.150
    55.046   571.355     0.150
    55.285   573.156     0.150
    55.337   573.254     0.150
    55.577   574.855     0.150
    55.686   575.555     0.150
    55.775   576.156     0.150
    55.794   576.254     0.150
    55.808   576.855     0.150
    55.968   577.953     0.150
    56.038   578.645     0.150
    56.077   578.453     0.150
    56.082   578.344     0.150
    56.427   581.254     0.150
    56.424   581.355     0.150
    56.481   581.113     0.150
    56.664   582.875     0.150
    56.699   583.555     0.150
    56.801   584.355     0.150
    56.856   583.555     0.150
    56.957   584.656     0.150
    57.061   586.156     0.150
    57.129   586.656     0.150
    57.152   586.754     0.150
    57.157   585.754     0.150
    57.230   586.855     0.150
    57.366   587.953     0.150
    57.376   587.953     0.150
    57.414   588.055     0.150
    57.513   588.055     0.150
    57.595   588.953     0.150
    57.770   590.555     0.150
    57.855   590.453     0.150
    58.091   591.555     0.150
    58.167   593.453     0.150
    58.941   598.355     0.150
    58.953   598.055     0.150
    59.102   599.156     0.150
    59.233   599.953     0.150
    59.396   600.855     0.150
    59.695   603.953     0.150
    60.281   607.656     0.150
    61.488   615.586     0.150
    61.488   615.055     0.150
    62.439   622.055     0.150
    62.458   622.156     0.150
    66.625   649.254     0.150
    66.588   649.656     0.150
    71.230   678.156     0.150
    72.778   687.656     0.150
    72.794   687.855     0.150
    72.813   688.656     0.150
    74.996   700.055     0.150
    74.998   700.055     0.150
    75.619   704.055     0.150
    78.153   718.465     0.150
    78.497   719.254     0.150
    78.497   896.855     0.150
    79.991   728.254     0.150
    80.272   729.656     0.150
    81.727   738.492     0.150
    81.780   738.844     0.150
    81.881   739.266     0.150
    82.095   740.426     0.150
    85.520   756.555     0.150
    86.726   762.156     0.150
   120.504  1131.828     0.150
    74.998   701.066     0.150
    74.998   701.066     0.150
    74.998   701.066     0.150
    74.998   701.066     0.150
    21.367   286.719     0.150
    12.971   183.441     0.150
    12.971   184.527     0.150
    12.971   183.918     0.150
    12.971   184.234     0.150
    12.971   183.953     0.150
    12.971   183.953     0.150
    12.971   183.578     0.150
     6.137    90.426     0.150
     6.137    89.812     0.150
     6.137    89.789     0.150
     6.137    90.387     0.150
     6.137    89.395     0.150
    72.778   688.062     0.150
    72.778   688.066     0.150
    72.778   688.066     0.150
    25.184   325.016     0.150
     0.048     2.734     0.150
     0.048     4.652     0.150
     0.055     2.164     0.150
     0.055     4.055     0.150
     0.072     2.953     0.150
     0.215     4.793     0.150
     0.215     7.793     0.150
     0.216     4.332     0.150
     0.216     8.121     0.150
     0.207     4.922     0.150
     0.207     8.332     0.150
     0.262     5.043     0.150
     0.255     5.395     0.150
     0.531    10.395     0.150
     0.809    14.793     0.150
     0.816    14.793     0.150
     0.816    26.293     0.150
     1.040    18.281     0.150
     1.040    30.941     0.150
     1.078    20.191     0.150
     1.078    33.602     0.150
     1.154    34.793     0.150
     1.136    21.492     0.150
     1.136    35.895     0.150
     1.202    23.793     0.150
     1.173    15.500     0.150
     2.311    41.492     0.150
     2.560    41.793     0.150
     2.560    75.191     0.150
     2.694    44.793     0.150
     2.694    79.793     0.150
     2.852    46.293     0.150
     2.852    82.793     0.150
     2.755    81.293     0.150
     2.714    46.395     0.150
     3.580    58.094     0.150
     3.580    99.094     0.150
     3.301    92.793     0.150
     3.697    58.793     0.150
     3.697   102.793     0.150
     4.675    52.500     0.150
     7.374   183.223     0.150
    12.077   169.793     0.150
    12.871   181.793     0.150
    12.871   312.023     0.150
    13.165   321.273     0.150
     1.529    27.594     0.150
     1.863    34.031     0.150
     2.012    35.793     0.150
     2.012    62.793     0.150
     2.312    41.492     0.150
     2.714    46.793     0.150
     2.845    46.473     0.150
     2.952    49.293     0.150
     2.952    91.895     0.150
     2.962    48.793     0.150
     3.112    50.293     0.150
     3.292    53.793     0.150
     3.292    92.793     0.150
     3.481    55.992     0.150
     3.481    96.691     0.150
     4.364    67.723     0.150
     4.364   117.824     0.150
     4.435    70.793     0.150
     4.435   122.793     0.150
     4.561    70.262     0.150
     5.007    73.793     0.150
     5.208    78.723     0.150
     5.208   135.742     0.150
     5.729    83.793     0.150
     5.729    85.812     0.150
     5.729   165.793     0.150
     5.764    87.082     0.150
     5.764   149.383     0.150
     5.810    86.664     0.150
     5.922    88.895     0.150
     5.922   155.895     0.150
     6.016    90.203     0.150
     6.016   154.684     0.150
     6.092    91.992     0.150
     6.092   159.992     0.150
     6.097    91.594     0.150
     6.229    92.902     0.150
     6.585   171.062     0.150
     6.911   102.191     0.150
     7.166   106.094     0.150
     7.166   185.094     0.150
     7.243   105.645     0.150
     7.374   105.715     0.150
     7.901   115.863     0.150
     7.901   199.762     0.150
     8.298   124.031     0.150
     8.352   124.484     0.150
     8.393   125.062     0.150
     8.413   126.316     0.150
     8.416   125.793     0.150
     8.429   125.828     0.150
     8.427   125.551     0.150
     8.461   126.070     0.150
     8.468   127.043     0.150
     8.486   126.445     0.150
     8.519   127.215     0.150
     8.523   126.238     0.150
     8.520   126.652     0.150
     8.529   127.027     0.150
     8.532   127.027     0.150
     8.542   126.035     0.150
     8.543   126.781     0.150
     8.546   126.090     0.150
     8.549   126.934     0.150
     8.550   126.988     0.150
     8.558   127.270     0.150
     8.567   126.598     0.150
     8.620   126.613     0.150
     8.692   128.148     0.150
     8.804   125.965     0.150
     8.742   128.598     0.150
     8.918   130.445     0.150
     8.960   130.871     0.150
     8.969   131.062     0.150
     9.104   132.793     0.150
     9.104   233.738     0.150
     9.183   133.555     0.150
     9.183   235.688     0.150
     9.193   133.242     0.150
     9.260   134.477     0.150
     9.260   235.289     0.150
     9.291   138.582     0.150
     9.291   239.949     0.150
     9.324   135.211     0.150
     9.339   135.359     0.150
     9.339   237.934     0.150
     9.474   136.992     0.150
     9.474   239.293     0.150
    10.009   144.887     0.150
    10.239   147.395     0.150
    10.239   261.793     0.150
    12.237   169.793     0.150
    12.871   181.793     0.150
    12.871   181.363     0.150
    12.871   314.832     0.150
    12.984   180.293     0.150
    12.984   316.793     0.150
    13.165   321.273     0.150
    14.904   209.293     0.150
    18.977   260.793     0.150
    20.982   284.191     0.150
    21.207   285.293     0.150
    21.335   286.992     0.150
    21.408   288.094     0.150
    25.217   324.895     0.150
    26.816   339.094     0.150
    35.724   419.684     0.150
    38.930   443.969     0.150
    39.042   446.242     0.150
    46.358   505.617     0.150
    46.454   506.395     0.150
    46.773   508.691     0.150
    49.382   529.410     0.150
    51.859   548.594     0.150
    52.153   550.344     0.150
    53.360   557.992     0.150
    53.360   558.316     0.150
    55.006   570.934     0.150
    57.327   587.992     0.150
    57.336   588.094     0.150
    57.814   589.793     0.150
    59.062   599.395     0.150
    59.357   601.395     0.150
    61.452   615.281     0.150
    72.818   687.844     0.150
    72.834   687.691     0.150
    75.037   700.293     0.150
    75.617   704.191     0.150
    78.068   718.352     0.150
    78.151   717.992     0.150
    78.495   719.191     0.150
    86.716   762.094     0.150
    49.382   528.980     0.150
    49.382   529.043     0.150
    49.382   529.121     0.150
    49.382   529.121     0.150
    75.037   701.137     0.150
    46.358   505.656     0.150
    46.358   505.586     0.150
    46.358   505.688     0.150
    46.358   505.688     0.150
    46.358   505.688     0.150
    35.724   418.145     0.150
    12.984   183.926     0.150
    12.984   183.770     0.150
    12.984   184.125     0.150
    12.984   184.191     0.150
    12.984   183.906     0.150
    12.984   184.008     0.150
    12.984   183.043     0.150
    78.495   720.566     0.150
    78.495   720.684     0.150
     6.097    91.223     0.150
     6.097    89.934     0.150
     6.097    89.262     0.150
     6.097    89.102     0.150
     6.097    90.137     0.150
     6.097    89.957     0.150
     6.097    89.719     0.150
     6.097    89.719     0.150
     6.097    89.719     0.150
     6.097    89.719     0.150
     6.097    89.719     0.150
     6.097    89.719     0.150
     6.097    90.051     0.150
    53.360   558.934     0.150
    53.360   558.934     0.150
     0.049     2.637     0.150
     0.049     4.688     0.150
     0.082     2.746     0.150
     0.082     5.059     0.150
     0.184     4.680     0.150
     0.184     8.137     0.150
     0.236     4.699     0.150
     0.232     4.996     0.150
     0.236     8.566     0.150
     0.232     8.156     0.150
     0.292     5.508     0.150
     0.292     9.258     0.150
     0.298     5.758     0.150
     0.294     5.727     0.150
     0.294     9.789     0.150
     0.577    11.008     0.150
     0.577    18.258     0.150
     0.852    17.008     0.150
     0.852    29.008     0.150
     0.857    15.508     0.150
     0.857    27.008     0.150
     0.971    18.258     0.150
     0.995    32.348     0.150
     1.112    16.000     0.150
     1.164    23.207     0.150
     1.164    37.508     0.150
     1.178    22.008     0.150
     2.648    45.309     0.150
     2.714    48.008     0.150
     2.714    81.508     0.150
     3.001    48.508     0.150
     0.088     2.871     0.150
     0.088     4.848     0.150
     0.009     1.938     0.150
     0.009     3.828     0.150
     0.037     2.719     0.150
     0.037     4.629     0.150
     0.243     5.000     0.150
     0.246     4.777     0.150
     0.246     8.758     0.150
     0.243     8.160     0.150
     0.294     5.918     0.150
     0.294     9.660     0.150
     0.301     5.949     0.150
     0.301     9.699     0.150
     0.300     6.199     0.150
     0.300     9.699     0.150
     0.578    11.449     0.150
     0.855    16.699     0.150
     0.862    16.051     0.150
     0.862    27.551     0.150
     0.975    19.199     0.150
     0.051     2.562     0.150
     0.051     4.094     0.150
     0.063     2.516     0.150
     0.063     4.406     0.150
     0.076     4.797     0.150
     0.076     2.797     0.150
     0.221     4.133     0.150
     0.221     7.297     0.150
     0.226     4.453     0.150
     0.226     7.594     0.150
     0.248     5.297     0.150
     0.248     8.797     0.150
     0.262     4.945     0.150
     0.262     8.695     0.150
     0.522    10.195     0.150
     0.522    16.195     0.150
     0.811    14.695     0.150
     0.811    26.195     0.150
     0.802    14.945     0.150
     0.802    26.445     0.150
     0.921    16.195     0.150
     1.052    18.383     0.150
     1.052    31.664     0.150
     1.089    20.016     0.150
     1.089    34.352     0.150
     1.130    21.492     0.150
     1.130    37.195     0.150
     2.562    43.695     0.150
     2.562    76.695     0.150
     2.629    45.695     0.150
     2.695    33.000     0.150
     2.758    83.492     0.150
     2.925    85.695     0.150
     2.983    50.695     0.150
     3.568    57.992     0.150
     5.730   174.648     0.150
     7.382   185.602     0.150
     0.023     2.758     0.150
     0.023     4.648     0.150
     0.143     3.781     0.150
     0.041     2.734     0.150
     0.041     5.078     0.150
     0.255     5.094     0.150
     0.255     8.055     0.150
     0.257     8.781     0.150
     0.319     6.211     0.150
     0.319     9.961     0.150
     0.326     7.008     0.150
     0.605    11.812     0.150
     0.605    18.812     0.150
     0.885    16.211     0.150
     0.885    28.211     0.150
     0.880    17.211     0.150
     1.096    18.312     0.150
     1.096    33.008     0.150
     0.999    19.312     0.150
     0.999    32.062     0.150
     0.037     2.547     0.150
     0.037     4.406     0.150
     0.060     2.188     0.150
     0.060     4.719     0.150
     0.082     2.938     0.150
     0.082     5.281     0.150
     0.207     7.211     0.150
     0.202     3.977     0.150
     0.202     7.141     0.150
     0.207     4.250     0.150
     0.251     4.859     0.150
     0.251     7.609     0.150
     0.218     5.008     0.150
     0.218     8.812     0.150
     0.530    10.109     0.150
     0.530    16.609     0.150
     0.810    14.859     0.150
     0.810    26.359     0.150
     0.804    14.609     0.150
     0.804    25.859     0.150
     1.033    18.336     0.150
     1.033    30.180     0.150
     1.063    19.930     0.150
     1.063    32.219     0.150
     1.144    15.000     0.150
     1.131    22.312     0.150
     1.131    39.109     0.150
     1.190    23.109     0.150
     1.190    38.406     0.150
     2.315    41.609     0.150
     2.547    42.109     0.150
     2.614    43.109     0.150
     2.681    46.109     0.150
     2.681    81.109     0.150
     2.742    47.109     0.150
     2.742    81.109     0.150
     5.715   149.859     0.150
     7.358   184.312     0.150
     0.048     2.508     0.150
     0.048     4.398     0.150
     0.050     1.969     0.150
     0.050     3.859     0.150
     0.070     4.891     0.150
     0.070     2.695     0.150
     0.215     3.160     0.150
     0.220     4.398     0.150
     0.220     7.438     0.150
     0.206     4.695     0.150
     0.206     8.695     0.150
     0.254     5.047     0.150
     0.254     8.656     0.150
     0.260     5.148     0.150
     0.264     4.797     0.150
     0.264     8.797     0.150
     0.537    10.297     0.150
     0.820    14.898     0.150
     0.820    27.398     0.150
     0.814    15.047     0.150
     1.141    22.000     0.150
     0.074     2.367     0.150
     0.074     4.387     0.150
     0.023     1.277     0.150
     0.023     3.809     0.150
     0.120     2.250     0.150
     0.050     2.258     0.150
     0.050     4.156     0.150
     0.229     3.707     0.150
     0.229     6.867     0.150
     0.187     4.219     0.150
     0.187     7.289     0.150
     0.290     5.598     0.150
     0.290     9.598     0.150
     0.568    10.699     0.150
     0.568    17.699     0.150
     0.688    20.699     0.150
     0.843    16.098     0.150
     0.849    15.098     0.150
     0.849    26.348     0.150
     1.121    22.496     0.150
     1.121    38.398     0.150
     1.170    38.398     0.150
     1.172    22.598     0.150
     1.172    37.098     0.150
     2.049    37.598     0.150
     2.578    76.098     0.150
     0.044     2.594     0.150
     0.044     4.523     0.150
     0.104     3.094     0.150
     0.104     5.352     0.150
     0.052     1.508     0.150
     0.052     3.398     0.150
     0.074     2.891     0.150
     0.074     5.094     0.150
     0.208     3.859     0.150
     0.208     6.391     0.150
     0.213     4.344     0.150
     0.213     7.430     0.150
     0.259     5.320     0.150
     0.259     8.570     0.150
     0.211     4.992     0.150
     0.211     8.641     0.150
     0.259     5.070     0.150
     0.259     8.570     0.150
     0.538    10.320     0.150
     0.657    13.070     0.150
     0.813    26.820     0.150
     0.819    15.219     0.150
     0.819    27.023     0.150
     0.813    15.070     0.150
     1.027    18.398     0.150
     1.027    31.633     0.150
     1.140    23.719     0.150
     1.140    36.719     0.150
     1.140    22.320     0.150
     1.140    37.922     0.150
     1.187    24.523     0.150
     1.187    38.117     0.150
     2.021    37.820     0.150
     0.130     3.180     0.150
     0.130     5.133     0.150
     0.158     3.562     0.150
     0.158     5.812     0.150
     0.107     3.250     0.150
     0.107     5.078     0.150
     0.185     3.883     0.150
     0.185     5.930     0.150
     0.185     6.203     0.150
     0.174     4.141     0.150
     0.174     6.492     0.150
     0.177     4.062     0.150
     0.177     6.938     0.150
     0.235     4.641     0.150
     0.235     7.969     0.150
     0.286     6.133     0.150
     0.286    10.070     0.150
     0.417     8.258     0.150
     0.417    13.008     0.150
     0.564    10.562     0.150
     0.707    13.211     0.150
     0.707    24.211     0.150
     0.720    13.062     0.150
     0.138     3.156     0.150
     0.138     5.141     0.150
     0.096     3.000     0.150
     0.096     5.016     0.150
     0.114     3.438     0.150
     0.114     4.438     0.150
     0.161     3.391     0.150
     0.161     5.641     0.150
     0.187     3.781     0.150
     0.187     6.031     0.150
     0.163     3.875     0.150
     0.163     6.156     0.150
     0.170     3.867     0.150
     0.170     6.531     0.150
     0.217     3.938     0.150
     0.217     6.688     0.150
     0.283     6.000     0.150
     0.283    10.117     0.150
     0.424     8.438     0.150
     0.424    13.188     0.150
     0.567    10.438     0.150
     0.567    19.188     0.150
     0.712    13.688     0.150
     0.712    24.188     0.150
     0.724    12.789     0.150
     0.137     3.766     0.150
     0.137     6.516     0.150
     0.196     4.219     0.150
     0.196     6.820     0.150
     0.137     3.750     0.150
     0.137     6.320     0.150
     0.241     5.320     0.150
     0.241     8.820     0.150
     0.215     4.758     0.150
     0.268     5.258     0.150
     0.268     8.617     0.150
     0.268     9.016     0.150
     0.214     5.070     0.150
     0.214     8.414     0.150
     0.293     4.430     0.150
     0.293     8.844     0.150
     0.304     6.117     0.150
     0.304    10.367     0.150
     0.301     5.906     0.150
     0.301     9.914     0.150
     0.317     6.617     0.150
     0.317    11.617     0.150
     0.480     9.414     0.150
     0.480    15.164     0.150
     0.644    12.617     0.150
     0.644    21.219     0.150
     0.781    15.414     0.150
     0.781    26.664     0.150
     0.798    15.117     0.150
     0.051     2.395     0.150
     0.051     4.176     0.150
     0.111     2.914     0.150
     0.111     5.055     0.150
     0.047     2.246     0.150
     0.047     4.066     0.150
     0.191     3.695     0.150
     0.191     6.195     0.150
     0.220     4.266     0.150
     0.220     7.496     0.150
     0.265     4.695     0.150
     0.265     8.195     0.150
     0.204     4.594     0.150
     0.204     8.105     0.150
     0.287     5.496     0.150
     0.287     9.176     0.150
     0.662    12.445     0.150
     0.662    22.195     0.150
     0.824    15.297     0.150
     0.817    15.695     0.150
     0.817    27.945     0.150
     0.936    16.445     0.150
     1.028    18.195     0.150
     1.028    31.637     0.150
     1.069    19.855     0.150
     1.069    34.434     0.150
     1.144    22.395     0.150
     1.144    39.496     0.150
     0.097     2.891     0.150
     0.097     5.000     0.150
     0.137     3.008     0.150
     0.137     5.109     0.150
     0.172     3.750     0.150
     0.172     6.719     0.150
     0.216     3.680     0.150
     0.216     6.391     0.150
     0.225     4.199     0.150
     0.225     7.020     0.150
     0.284     5.918     0.150
     0.284    10.090     0.150
     1.038    18.980     0.150
     1.038    34.180     0.150
     1.251    23.180     0.150
     1.251    39.180     0.150
     1.292    26.180     0.150
     1.901    34.180     0.150
     1.901    59.180     0.150
     2.513    76.180     0.150
     0.046     2.508     0.150
     0.046     4.250     0.150
     0.103     3.047     0.150
     0.103     5.148     0.150
     0.050     2.547     0.150
     0.050     5.047     0.150
     0.208     3.148     0.150
     0.208     6.250     0.150
     0.213     4.289     0.150
     0.213     7.867     0.150
     0.258     5.180     0.150
     0.258     8.445     0.150
     0.260     5.648     0.150
     0.210     5.055     0.150
     0.210     8.297     0.150
     0.540    10.648     0.150
     0.540    17.148     0.150
     0.659    12.648     0.150
     0.659    20.898     0.150
     0.815    16.250     0.150
     0.815    26.750     0.150
     0.820    15.648     0.150
     0.820    26.648     0.150
     0.934    17.898     0.150
     0.934    30.648     0.150
     1.138    23.852     0.150
     0.055     2.719     0.150
     0.060     2.219     0.150
     0.060     3.619     0.150
     0.084     3.238     0.150
     0.084     5.439     0.150
     0.127     3.508     0.150
     0.127     5.939     0.150
     0.202     4.850     0.150
     0.202     8.398     0.150
     0.225     3.719     0.150
     0.231     4.809     0.150
     0.231     7.818     0.150
     0.252     5.318     0.150
     0.525    10.219     0.150
     0.655    12.469     0.150
     0.655    20.369     0.150
     0.815    15.219     0.150
     0.925    16.969     0.150
     1.051    19.008     0.150
     1.051    31.449     0.150
     1.092    20.689     0.150
     1.166    23.918     0.150
     1.214    23.719     0.150
     1.214    38.719     0.150
     0.033     2.699     0.150
     0.034     2.469     0.150
     0.034     4.199     0.150
     0.033     4.250     0.150
     0.039     2.699     0.150
     0.039     4.699     0.150
     0.092     3.000     0.150
     0.092     5.109     0.150
     0.099     5.297     0.150
     0.063     2.297     0.150
     0.063     4.750     0.150
     0.200     3.898     0.150
     0.200     7.059     0.150
     0.246     5.117     0.150
     0.246     8.598     0.150
     0.249     4.898     0.150
     0.249     8.398     0.150
     0.249     5.199     0.150
     0.221     5.039     0.150
     0.221     8.797     0.150
     0.373     7.398     0.150
     0.528     9.898     0.150
     0.647    12.148     0.150
     0.647    20.648     0.150
     0.802    14.398     0.150
     0.808    14.898     0.150
     1.035    18.250     0.150
     1.035    31.520     0.150
     1.063    19.969     0.150
     1.063    34.758     0.150
     1.129    21.398     0.150
     1.129    37.098     0.150
     1.145    21.500     0.150
     1.145    37.699     0.150
     1.191    23.199     0.150
     1.191    38.199     0.150
     2.502    42.598     0.150
     2.679    45.398     0.150
     0.019     2.332     0.150
     0.019     3.742     0.150
     0.090     2.770     0.150
     0.090     4.672     0.150
     0.148     3.230     0.150
     0.148     5.230     0.150
     0.153     3.531     0.150
     0.153     6.082     0.150
     0.137     3.301     0.150
     0.137     5.289     0.150
     0.153     3.480     0.150
     0.153     4.730     0.150
     0.163     3.230     0.150
     0.163     5.762     0.150
     0.203     3.730     0.150
     0.203     6.891     0.150
     0.204     3.980     0.150
     0.204     6.730     0.150
     0.213     4.070     0.150
     0.213     7.020     0.150
     0.291     5.949     0.150
     0.291    10.191     0.150
     0.422     8.031     0.150
     0.422    12.930     0.150
     0.559    10.480     0.150
     0.706    12.480     0.150
     0.717    12.980     0.150
     0.823    14.730     0.150
     1.034    20.031     0.150
     1.034    33.930     0.150
     1.118    20.090     0.150
     1.244    40.730     0.150
     1.283    24.730     0.150
     1.283    40.230     0.150
     1.903    34.730     0.150
     2.445    40.430     0.150
     2.502    42.230     0.150
     2.502    75.230     0.150
     2.605    81.531     0.150
     2.636    43.730     0.150
     2.636    78.730     0.150
     1.903    34.730     0.150
     2.901    47.629     0.150
     2.901    88.332     0.150
     2.857    47.230     0.150
     2.857    89.531     0.150
     3.594    56.031     0.150
     4.574    78.230     0.150
    21.513   289.930     0.150
    49.317   529.516     0.150
    75.136   700.930     0.150
     0.020     2.176     0.150
     0.020     3.516     0.150
     0.080     2.293     0.150
     0.080     3.844     0.150
     0.086     2.613     0.150
     0.086     4.543     0.150
     0.139     3.145     0.150
     0.139     5.254     0.150
     0.152     3.145     0.150
     0.150     3.293     0.150
     0.150     5.824     0.150
     0.146     2.895     0.150
     0.146     5.094     0.150
     0.163     3.094     0.150
     0.163     5.625     0.150
     0.199     3.496     0.150
     0.199     6.113     0.150
     0.269     5.414     0.150
     0.269     8.695     0.150
     0.292     5.914     0.150
     0.292    10.406     0.150
     0.422     8.094     0.150
     0.422    12.844     0.150
     0.557    10.293     0.150
     0.705    14.293     0.150
     0.716    13.195     0.150
     0.822    15.895     0.150
     0.822    26.645     0.150
     0.057     2.485     0.150
     0.057     4.396     0.150
     0.055     1.965     0.150
     0.055     3.865     0.150
     0.057     1.865     0.150
     0.057     3.765     0.150
     0.127     3.206     0.150
     0.127     5.345     0.150
     0.201     3.965     0.150
     0.201     6.215     0.150
     0.243     4.795     0.150
     0.232     4.385     0.150
     0.232     7.505     0.150
     0.200     4.625     0.150
     0.200     7.195     0.150
     0.280     5.275     0.150
     0.280     9.085     0.150
     0.529    10.215     0.150
     0.658    12.765     0.150
     0.818    15.965     0.150
     0.818    25.715     0.150
     0.928    18.065     0.150
     0.061     2.031     0.150
     0.061     3.633     0.150
     0.035     1.832     0.150
     0.035     3.332     0.150
     0.113     3.002     0.150
     0.113     4.932     0.150
     0.113     5.133     0.150
     0.060     2.512     0.150
     0.060     4.332     0.150
     0.181     3.332     0.150
     0.181     5.332     0.150
     0.220     3.332     0.150
     0.220     6.531     0.150
     0.224     4.473     0.150
     0.224     7.232     0.150
     0.224     7.432     0.150
     0.261     5.223     0.150
     0.261     8.633     0.150
     0.272     5.361     0.150
     0.272     8.832     0.150
     0.272     9.031     0.150
     0.276     5.582     0.150
     0.300     5.662     0.150
     0.395    12.633     0.150
     0.555    10.332     0.150
     0.674    13.082     0.150
     0.674    22.332     0.150
     0.830    17.082     0.150
     0.830    27.582     0.150
     0.836    15.832     0.150
     0.949    18.582     0.150
     0.104     3.043     0.150
     0.104     4.945     0.150
     0.121     3.086     0.150
     0.121     5.043     0.150
     0.158     3.715     0.150
     0.158     6.215     0.150
     0.185     3.934     0.150
     0.185     6.754     0.150
     0.190     4.406     0.150
     0.190     7.395     0.150
     0.230     4.965     0.150
     0.230     7.465     0.150
     0.249     4.785     0.150
     0.249     8.105     0.150
     0.291     6.164     0.150
     0.409     7.715     0.150
     0.409    12.816     0.150
     0.561    10.465     0.150
     0.561    16.715     0.150
     0.717    12.715     0.150
     0.817    14.965     0.150
     0.048     2.000     0.150
     0.079     2.578     0.150
     0.079     4.328     0.150
     0.148     2.328     0.150
     0.148     4.328     0.150
     0.187     2.500     0.150
     0.191     3.828     0.150
     0.191     6.728     0.150
     0.246     5.078     0.150
     0.246     7.828     0.150
     0.282     5.588     0.150
     0.266     8.728     0.150
     0.282     9.028     0.150
     0.266     5.298     0.150
     0.261     5.118     0.150
     0.261     8.628     0.150
     0.230     5.038     0.150
     0.230     9.038     0.150
     0.543    10.028     0.150
     0.652    12.828     0.150
     0.652    21.828     0.150
     0.811    15.828     0.150
     0.814    14.828     0.150
     0.814    26.578     0.150
     0.932    17.928     0.150
     1.119    36.428     0.150
     0.033     2.059     0.150
     0.033     3.660     0.150
     0.062     1.258     0.150
     0.034     1.559     0.150
     0.034     3.059     0.150
     0.055     2.449     0.150
     0.055     4.367     0.150
     0.111     3.098     0.150
     0.122     3.027     0.150
     0.122     5.520     0.150
     0.227     4.059     0.150
     0.227     7.258     0.150
     0.232     4.430     0.150
     0.232     7.879     0.150
     0.191     4.379     0.150
     0.191     8.160     0.150
     0.255     5.098     0.150
     0.255     8.750     0.150
     0.279     8.809     0.150
     0.267     5.297     0.150
     0.267     8.879     0.150
     0.275     5.559     0.150
     0.279     5.059     0.150
     0.299     5.699     0.150
     0.299     9.598     0.150
     0.551    10.059     0.150
     0.551    17.059     0.150
     0.675    12.660     0.150
     0.675    20.660     0.150
     0.829    16.559     0.150
     0.829    27.309     0.150
     0.836    15.559     0.150
     1.139    23.160     0.150
     1.139    36.457     0.150
     1.189    23.758     0.150
     0.060     1.992     0.150
     0.060     3.691     0.150
     0.032     1.992     0.150
     0.032     3.594     0.150
     0.036     1.492     0.150
     0.036     3.391     0.150
     0.056     2.441     0.150
     0.056     4.594     0.150
     0.110     3.133     0.150
     0.110     5.480     0.150
     0.120     3.113     0.150
     0.120     5.582     0.150
     0.189     2.742     0.150
     0.189     5.242     0.150
     0.193     4.383     0.150
     0.193     7.691     0.150
     0.230     4.301     0.150
     0.230     7.492     0.150
     0.254     5.102     0.150
     0.254     8.691     0.150
     0.266     5.301     0.150
     0.266     8.891     0.150
     0.298     9.891     0.150
     0.551    10.242     0.150
     0.551    16.742     0.150
     0.674    13.242     0.150
     0.835    16.742     0.150
     0.835    27.992     0.150
     0.044     3.906     0.150
     0.044     2.406     0.150
     0.122     2.406     0.150
     0.082     1.906     0.150
     0.082     4.008     0.150
     0.090     1.906     0.150
     0.111     5.637     0.150
     0.183     3.406     0.150
     0.183     5.508     0.150
     0.157     3.895     0.150
     0.258     5.406     0.150
     0.241     9.535     0.150
     0.303     6.035     0.150
     0.303    10.008     0.150
     0.312     6.117     0.150
     0.305    10.105     0.150
     0.577    10.406     0.150
     0.673    13.156     0.150
     0.836    15.105     0.150
     0.836    26.105     0.150
     0.836    17.156     0.150
     0.998    17.816     0.150
     0.969    18.484     0.150
     0.969    31.496     0.150
     1.075    19.906     0.150
     1.120    21.207     0.150
     1.160    22.105     0.150
     1.160    37.305     0.150
     1.198    22.406     0.150
     2.067    35.906     0.150
     2.067    63.906     0.150
     2.374    42.008     0.150
     2.374    62.605     0.150
     2.496    40.805     0.150
     2.496    72.008     0.150
     2.530    40.906     0.150
     2.530    74.406     0.150
     2.597    43.605     0.150
     2.597    77.605     0.150
     2.836    44.008     0.150
     2.836    82.105     0.150
     2.771    78.207     0.150
     3.651    57.508     0.150
     3.651    99.305     0.150
     3.364    56.906     0.150
     3.766    59.906     0.150
     3.766   104.906     0.150
     4.549   120.906     0.150
     4.745   129.906     0.150
     5.698    83.637     0.150
     7.305   104.758     0.150
     7.305   183.266     0.150
     8.726   125.555     0.150
     8.726   220.125     0.150
    12.811   178.828     0.150
    12.811   314.906     0.150
    12.883   179.906     0.150
    12.907   178.406     0.150
    13.082   182.066     0.150
    13.837   191.895     0.150
     1.075    20.105     0.150
     1.458    26.176     0.150
     1.799    32.215     0.150
     2.068    35.906     0.150
     2.068    63.906     0.150
     2.376    42.008     0.150
     2.530    41.406     0.150
     2.769    45.457     0.150
     2.771    44.906     0.150
     2.771    76.906     0.150
     2.916    46.707     0.150
     2.916    84.605     0.150
     3.046    49.535     0.150
     3.355   106.406     0.150
     3.548    56.105     0.150
     3.548    98.105     0.150
     4.302    66.836     0.150
     4.493    69.078     0.150
     4.549    69.906     0.150
     5.148    77.734     0.150
     5.698    84.586     0.150
     5.702    84.957     0.150
     5.750    85.516     0.150
     5.972    89.105     0.150
     5.954    88.234     0.150
     5.954   154.555     0.150
     6.160    91.805     0.150
     6.172    91.734     0.150
     6.528    96.695     0.150
     6.528   167.777     0.150
     6.968   101.406     0.150
     7.305   183.117     0.150
     7.182   104.836     0.150
     7.182   182.055     0.150
     7.231   105.305     0.150
     7.231   185.305     0.150
     7.599   110.508     0.150
     7.842   114.578     0.150
     8.307   124.227     0.150
     8.360   124.645     0.150
     8.400   125.125     0.150
     8.410   126.008     0.150
     8.410   125.266     0.150
     8.412   125.410     0.150
     8.427   125.684     0.150
     8.433   125.746     0.150
     8.460   125.980     0.150
     8.464   126.770     0.150
     8.486   126.316     0.150
     8.675   124.906     0.150
     8.675   216.406     0.150
     8.515   125.531     0.150
     8.515   125.371     0.150
     8.513   127.102     0.150
     8.513   126.578     0.150
     8.534   125.621     0.150
     8.534   124.590     0.150
     8.524   126.711     0.150
     8.538   125.723     0.150
     8.538   125.566     0.150
     8.536   125.973     0.150
     8.536   125.727     0.150
     8.531   126.902     0.150
     8.533   126.891     0.150
     8.542   126.148     0.150
     8.542   125.902     0.150
     8.552   127.242     0.150
     8.552   126.648     0.150
     8.558   126.344     0.150
     8.553   127.223     0.150
     8.609   126.484     0.150
     8.609   126.258     0.150
     8.681   127.859     0.150
     8.731   128.266     0.150
     8.905   130.398     0.150
     8.905   129.293     0.150
     8.946   130.895     0.150
     8.946   129.898     0.150
     8.956   130.910     0.150
     8.956   130.520     0.150
     9.090   132.074     0.150
     9.090   131.176     0.150
     9.168   132.871     0.150
     9.168   235.832     0.150
     9.168   131.832     0.150
     9.168   236.906     0.150
     9.176   132.973     0.150
     9.176   236.176     0.150
     9.192   133.168     0.150
     9.192   237.375     0.150
     9.240   133.711     0.150
     9.240   236.230     0.150
     9.240   133.117     0.150
     9.240   236.355     0.150
     9.267   138.609     0.150
     9.304   134.820     0.150
     9.304   238.941     0.150
     9.304   238.707     0.150
     9.318   134.969     0.150
     9.318   239.066     0.150
     9.318   133.812     0.150
     9.318   240.172     0.150
     9.557   138.305     0.150
     9.557   239.906     0.150
     9.852   138.828     0.150
     9.852   246.406     0.150
     9.997   144.156     0.150
     9.997   143.645     0.150
    10.209   147.906     0.150
    10.668   152.879     0.150
    10.668   152.348     0.150
    12.022   168.406     0.150
    12.167   168.906     0.150
    12.811   178.906     0.150
    12.811   313.848     0.150
    12.883   180.406     0.150
    13.082   182.066     0.150
    13.082   317.305     0.150
    13.025   183.906     0.150
    13.025   327.906     0.150
    13.837   191.918     0.150
    13.837   192.426     0.150
    13.837   336.348     0.150
    14.964   209.906     0.150
    14.964   224.906     0.150
    18.997   260.305     0.150
    20.963   282.508     0.150
    21.209   285.406     0.150
    21.294   286.305     0.150
    21.344   286.906     0.150
    23.885   312.406     0.150
    24.622   319.207     0.150
    24.622   578.406     0.150
    25.211   324.906     0.150
    26.622   339.008     0.150
    26.831   339.707     0.150
    26.836   340.406     0.150
    27.462   346.477     0.150
    29.540   364.707     0.150
    29.896   367.707     0.150
    30.862   376.906     0.150
    31.371   382.316     0.150
    31.379   380.906     0.150
    35.757   419.895     0.150
    36.853   428.406     0.150
    38.629   442.207     0.150
    38.936   446.305     0.150
    39.006   444.957     0.150
    39.122   447.066     0.150
    40.499   459.551     0.150
    43.461   482.805     0.150
    45.261   495.105     0.150
    45.749   500.406     0.150
    46.440   506.082     0.150
    46.536   506.805     0.150
    46.854   509.305     0.150
    49.275   528.906     0.150
    49.466   529.805     0.150
    49.668   531.008     0.150
    50.019   533.418     0.150
    50.300   536.008     0.150
    50.812   538.805     0.150
    51.139   542.508     0.150
    51.600   546.008     0.150
    51.600    11.500     0.150
    51.668   545.617     0.150
    51.668    10.961     0.150
    51.874   548.207     0.150
    51.937   548.008     0.150
    51.934   549.008     0.150
    51.934    11.500     0.150
    52.226   550.508     0.150
    52.284   550.406     0.150
    52.284    11.500     0.150
    52.379   551.605     0.150
    52.379    11.602     0.150
    52.543   551.605     0.150
    52.636   553.406     0.150
    53.077   556.305     0.150
    53.388   559.008     0.150
    53.425   559.508     0.150
    53.441   558.207     0.150
    53.441   558.531     0.150
    53.766   563.305     0.150
    54.120   565.105     0.150
    54.120   563.508     0.150
    54.864   569.406     0.150
    55.078   571.105     0.150
    55.046   571.039     0.150
    55.318   572.805     0.150
    55.368   573.207     0.150
    55.609   575.008     0.150
    55.826   576.008     0.150
    55.745   575.406     0.150
    56.110   578.207     0.150
    56.458   581.406     0.150
    56.731   583.305     0.150
    56.833   584.105     0.150
    56.890   583.508     0.150
    57.161   586.406     0.150
    57.184   586.605     0.150
    57.259   586.406     0.150
    57.397   587.906     0.150
    57.407   588.008     0.150
    57.543   588.008     0.150
    57.806   590.605     0.150
    57.883   590.406     0.150
    58.032   591.105     0.150
    58.121   592.707     0.150
    58.972   599.008     0.150
    59.134   599.008     0.150
    59.267   600.008     0.150
    59.725   603.805     0.150
    61.063   612.906     0.150
    61.531   615.703     0.150
    61.531   614.906     0.150
    62.433   621.465     0.150
    63.138   628.008     0.150
    66.615   649.707     0.150
    74.963   699.805     0.150
    74.964   699.805     0.150
    78.035   717.234     0.150
    78.216   718.117     0.150
    78.560   719.457     0.150
    78.635   720.055     0.150
    80.947   733.797     0.150
    81.512   736.527     0.150
    81.721   737.555     0.150
    81.774   738.438     0.150
    81.875   738.918     0.150
    82.088   740.016     0.150
    81.985   738.418     0.150
    85.485   756.355     0.150
    86.790   762.305     0.150
    12.907   183.086     0.150
    12.907   183.438     0.150
    12.907   183.477     0.150
    12.907   182.355     0.150
    12.907   182.355     0.150
    12.907   182.797     0.150
    78.560   721.254     0.150
    21.209   284.695     0.150
    21.209   284.695     0.150
    21.209   284.695     0.150
    53.441   559.562     0.150
    39.006   445.520     0.150
    39.006   445.520     0.150
    39.006   445.520     0.150
    39.006   445.520     0.150
    27.462   345.074     0.150
    27.462   345.074     0.150
    27.462   345.555     0.150
    23.885   312.707     0.150
     0.020     2.156     0.150
     0.020     3.758     0.150
     0.048     1.859     0.150
     0.048     3.656     0.150
     0.057     1.656     0.150
     0.057     3.555     0.150
     0.089     2.664     0.150
     0.089     4.688     0.150
     0.083     2.680     0.150
     0.083     4.867     0.150
     0.112     3.109     0.150
     0.112     5.328     0.150
     0.158     2.156     0.150
     0.196     3.453     0.150
     0.196     5.984     0.150
     0.200     3.953     0.150
     0.200     6.688     0.150
     0.253     7.906     0.150
     0.221     4.938     0.150
     0.221     8.609     0.150
     0.259     5.164     0.150
     0.265     5.203     0.150
     0.265     8.773     0.150
     0.545    10.156     0.150
     0.657    12.859     0.150
     0.819    15.906     0.150
     0.819    26.406     0.150
     0.017     2.574     0.150
     0.017     4.074     0.150
     0.034     2.074     0.150
     0.034     3.973     0.150
     0.111     3.125     0.150
     0.111     5.203     0.150
     0.219     4.074     0.150
     0.267     5.523     0.150
     0.267     9.176     0.150
     0.198     4.605     0.150
     0.198     7.773     0.150
     0.277     5.625     0.150
     0.277     9.074     0.150
     0.280     5.973     0.150
     0.280     9.223     0.150
     0.304     6.035     0.150
     0.304     9.676     0.150
     0.560    10.273     0.150
     0.560    17.523     0.150
     0.677    12.824     0.150
     0.677    21.074     0.150
     0.839    15.574     0.150
     0.839    28.074     0.150
     0.833    15.375     0.150
     0.833    27.125     0.150
     0.953    17.824     0.150
     1.009    18.953     0.150
     1.009    32.055     0.150
     1.058    19.625     0.150
     1.058    34.383     0.150
     1.123    17.000     0.150
     1.173    22.574     0.150
     1.173    38.074     0.150
     2.042    38.074     0.150
     2.042    63.074     0.150
     2.342    42.574     0.150
     2.567    77.074     0.150
     2.700    46.074     0.150
     2.700    81.074     0.150
     3.612    57.875     0.150
     3.612   100.273     0.150
     0.113     2.953     0.150
     0.113     5.074     0.150
     0.133     3.543     0.150
     0.133     5.734     0.150
     0.175     2.895     0.150
     0.226     4.426     0.150
     0.226     7.344     0.150
     0.194     4.473     0.150
     0.194     7.504     0.150
     0.283     5.645     0.150
     0.283     8.895     0.150
     0.291     5.895     0.150
     0.291     9.645     0.150
     0.279     5.426     0.150
     0.289     5.566     0.150
     0.289     9.164     0.150
     0.571    11.145     0.150
     0.687    13.145     0.150
     0.844    16.645     0.150
     0.844    26.895     0.150
     0.849    16.145     0.150
     0.964    18.645     0.150
     0.997    19.164     0.150
     0.997    31.383     0.150
     1.053    20.133     0.150
     1.053    33.934     0.150
     1.112    22.145     0.150
     1.112    33.145     0.150
     2.054    27.000     0.150
     2.354    73.246     0.150
     2.572    45.145     0.150
     2.572    78.145     0.150
     0.015     2.547     0.150
     0.015     4.047     0.150
     0.116     3.070     0.150
     0.049     2.047     0.150
     0.049     4.047     0.150
     0.096     2.766     0.150
     0.096     4.547     0.150
     0.163     3.297     0.150
     0.203     3.547     0.150
     0.203     6.648     0.150
     0.207     4.156     0.150
     0.207     6.523     0.150
     0.262     5.227     0.150
     0.262     8.953     0.150
     0.261     5.297     0.150
     0.261     8.547     0.150
     0.269     5.344     0.150
     0.270     5.336     0.150
     0.270     8.797     0.150
     0.213     7.578     0.150
     0.292     5.734     0.150
     0.292     9.328     0.150
     0.550    10.297     0.150
     0.664    12.797     0.150
     0.822    16.547     0.150
     0.822    26.750     0.150
     0.826    15.297     0.150
     0.942    18.297     0.150
     0.019     2.102     0.150
     0.019     3.602     0.150
     0.032     1.602     0.150
     0.032     3.500     0.150
     0.113     2.922     0.150
     0.113     4.930     0.150
     0.179     3.352     0.150
     0.179     5.602     0.150
     0.221     4.102     0.150
     0.221     7.203     0.150
     0.225     4.414     0.150
     0.225     7.398     0.150
     0.196     4.539     0.150
     0.196     7.305     0.150
     0.277     5.422     0.150
     0.277     9.000     0.150
     0.278     9.352     0.150
     0.304     5.883     0.150
     0.304     9.602     0.150
     0.678    13.352     0.150
     0.678    21.602     0.150
     0.840    15.602     0.150
     0.840    28.102     0.150
     0.047     2.242     0.150
     0.047     3.742     0.150
     0.066     1.742     0.150
     0.066     3.641     0.150
     0.105     2.898     0.150
     0.105     4.812     0.150
     0.180     3.242     0.150
     0.180     5.992     0.150
     0.204     3.742     0.150
     0.204     6.844     0.150
     0.209     4.070     0.150
     0.209     6.781     0.150
     0.230     4.695     0.150
     0.230     8.039     0.150
     0.240     4.852     0.150
     0.240     7.891     0.150
     0.268     5.203     0.150
     0.268     8.289     0.150
     0.220     4.844     0.150
     0.220     8.266     0.150
     0.043     2.822     0.150
     0.043     4.322     0.150
     0.088     2.952     0.150
     0.088     5.132     0.150
     0.063     2.322     0.150
     0.063     4.222     0.150
     0.177     3.322     0.150
     0.177     6.072     0.150
     0.203     3.722     0.150
     0.203     6.822     0.150
     0.208     3.992     0.150
     0.208     6.832     0.150
     0.234     4.812     0.150
     0.234     7.962     0.150
     0.243     4.992     0.150
     0.243     8.112     0.150
     0.250     8.822     0.150
     0.270     5.332     0.150
     0.270     8.792     0.150
     0.219     4.872     0.150
     0.219     8.432     0.150
     0.052     1.051     0.150
     0.052     2.551     0.150
     0.029     1.352     0.150
     0.029     2.852     0.150
     0.043     1.250     0.150
     0.043     2.852     0.150
     0.066     2.180     0.150
     0.066     4.020     0.150
     0.106     2.762     0.150
     0.106     4.742     0.150
     0.111     2.562     0.150
     0.111     4.652     0.150
     0.181     2.301     0.150
     0.216     3.551     0.150
     0.216     6.652     0.150
     0.220     4.012     0.150
     0.220     6.922     0.150
     0.203     4.340     0.150
     0.203     6.750     0.150
     0.251     4.922     0.150
     0.251     7.941     0.150
     0.262     5.141     0.150
     0.262     8.191     0.150
     0.268     9.551     0.150
     0.291     5.480     0.150
     0.291     8.762     0.150
     0.051     2.195     0.150
     0.051     3.695     0.150
     0.055     2.094     0.150
     0.055     3.695     0.150
     0.127     3.273     0.150
     0.127     5.617     0.150
     0.077     2.715     0.150
     0.077     4.934     0.150
     0.170     2.945     0.150
     0.119     2.195     0.150
     0.119     3.695     0.150
     0.181     4.074     0.150
     0.181     7.035     0.150
     0.239     8.066     0.150
     0.238     3.496     0.150
     0.239     4.766     0.150
     0.193     4.516     0.150
     0.193     7.676     0.150
     0.311     5.195     0.150
     0.311     9.195     0.150
     0.327     6.305     0.150
     0.327    10.727     0.150
     0.336     6.555     0.150
     0.355     6.766     0.150
     0.355    11.246     0.150
     1.024    19.344     0.150
     0.948    19.406     0.150
     0.948    33.215     0.150
     1.065    18.695     0.150
     1.065    32.695     0.150
     1.118    21.195     0.150
     1.118    36.496     0.150
     2.403    42.797     0.150
     2.403    74.195     0.150
     2.583    43.195     0.150
     2.583    77.195     0.150
     2.716    45.695     0.150
     2.716    80.695     0.150
     3.672    58.195     0.150
     3.672   100.594     0.150
     7.343   184.805     0.150
     0.021     2.516     0.150
     0.021     4.016     0.150
     0.045     2.016     0.150
     0.045     3.914     0.150
     0.064     2.766     0.150
     0.064     4.266     0.150
     0.103     3.016     0.150
     0.103     5.215     0.150
     0.052     2.535     0.150
     0.052     4.617     0.150
     0.052     2.516     0.150
     0.052     5.016     0.150
     0.172     3.016     0.150
     0.111     3.516     0.150
     0.111     5.566     0.150
     0.205     2.750     0.150
     0.210     3.100     0.150
     0.208     8.316     0.150
     0.264     5.016     0.150
     0.266     5.336     0.150
     0.291     5.695     0.150
     0.291     9.516     0.150
     0.391     7.645     0.150
     0.391    12.617     0.150
     1.017    18.676     0.150
     1.017    30.816     0.150
     1.058    19.676     0.150
     1.058    33.977     0.150
     1.130    19.914     0.150
     1.130    34.914     0.150
     1.130    35.016     0.150
     1.178    21.715     0.150
     1.178    37.016     0.150
     1.148    22.215     0.150
     1.148    36.914     0.150
     1.185    22.016     0.150
     2.031    37.016     0.150
     2.031    64.016     0.150
     2.332    41.164     0.150
     2.332    41.516     0.150
     2.332    72.516     0.150
     2.557    42.516     0.150
     2.557    74.016     0.150
     2.626    44.516     0.150
     2.626    76.016     0.150
     2.690    44.516     0.150
     2.690    76.516     0.150
     2.853    33.300     0.150
     2.734    45.016     0.150
     2.734    77.016     0.150
     2.958    86.016     0.150
     4.499    68.816     0.150
     4.698   129.516     0.150
     5.725    85.094     0.150
     5.725   149.527     0.150
     7.358   105.316     0.150
     7.358   184.164     0.150
     9.906   140.016     0.150
    12.859   180.285     0.150
    12.859   313.156     0.150
    13.886   192.945     0.150
    13.886   337.945     0.150
     1.130    20.016     0.150
     1.506    26.914     0.150
     1.841    33.016     0.150
     2.032    37.016     0.150
     2.334    41.164     0.150
     2.334    72.516     0.150
     2.821    45.977     0.150
     2.821    82.094     0.150
     2.947    48.016     0.150
     2.947    90.316     0.150
     2.984    49.016     0.150
     3.090    49.977     0.150
     3.503    56.914     0.150
     3.503    97.617     0.150
     3.603    57.316     0.150
     3.603   100.117     0.150
     3.720   101.316     0.150
     4.343    67.406     0.150
     4.343   116.785     0.150
     4.539    70.305     0.150
     4.539   121.805     0.150
     4.457    70.016     0.150
     4.457   120.016     0.150
     4.989    74.016     0.150
     4.989   130.016     0.150
     5.188    78.867     0.150
     5.188   134.984     0.150
     5.725    86.164     0.150
     5.725   149.527     0.150
     5.743    85.625     0.150
     5.743   148.188     0.150
     5.789    86.664     0.150
     5.789   150.047     0.150
     5.940    88.016     0.150
     5.995    89.906     0.150
     5.995   155.527     0.150
     6.115    91.617     0.150
     6.119    91.551     0.150
     6.209    92.664     0.150
     6.209   158.688     0.150
     6.565    97.426     0.150
     6.565   169.086     0.150
     6.931   100.816     0.150
     7.358   183.574     0.150
     7.222   105.285     0.150
     7.222   183.164     0.150
     7.188   105.016     0.150
     7.567   110.516     0.150
     7.881   115.527     0.150
     7.881   198.566     0.150
     8.294   124.145     0.150
     8.348   124.691     0.150
     8.389   125.004     0.150
     8.389   216.754     0.150
     8.406   126.012     0.150
     8.409   125.633     0.150
     8.422   125.633     0.150
     8.422   219.996     0.150
     8.423   125.676     0.150
     8.454   125.844     0.150
     8.454   217.602     0.150
     8.461   126.852     0.150
     8.480   126.285     0.150
     8.515   126.262     0.150
     8.511   126.996     0.150
     8.534   126.094     0.150
     8.515   126.789     0.150
     8.537   126.348     0.150
     8.535   126.641     0.150
     8.535   222.402     0.150
     8.523   126.871     0.150
     8.541   126.727     0.150
     8.527   126.871     0.150
     8.550   127.355     0.150
     8.550   222.031     0.150
     8.559   126.727     0.150
     8.545   127.145     0.150
     8.780   126.074     0.150
     8.611   126.367     0.150
     8.611   220.254     0.150
     8.683   128.109     0.150
     8.733   128.285     0.150
     8.908   129.809     0.150
     8.950   132.168     0.150
     8.950   231.215     0.150
     9.094   131.773     0.150
     9.094   231.848     0.150
     9.173   132.336     0.150
     9.182   133.078     0.150
     9.199   133.078     0.150
     9.199   237.551     0.150
     9.248   133.891     0.150
     9.248   239.191     0.150
     9.278   138.930     0.150
     9.278   239.234     0.150
     9.312   134.762     0.150
     9.312   239.844     0.150
     9.327   135.176     0.150
     9.327   240.043     0.150
     9.496   137.516     0.150
     9.496   239.016     0.150
     9.906   246.797     0.150
    10.000   145.461     0.150
    10.225   148.016     0.150
    12.221   170.016     0.150
    12.221   299.016     0.150
    12.058   169.016     0.150
    12.859   181.016     0.150
    12.859   180.387     0.150
    12.965   180.016     0.150
    13.143   183.215     0.150
    12.964   186.016     0.150
    13.886   192.945     0.150
    13.886   336.594     0.150
    14.916   208.516     0.150
    14.916   216.316     0.150
    17.626   244.016     0.150
    18.977   261.016     0.150
    20.971   283.016     0.150
    21.202   285.016     0.150
    21.318   287.414     0.150
    21.386   287.164     0.150
    21.386   531.316     0.150
    23.829   312.117     0.150
    24.290   317.414     0.150
    25.209   324.617     0.150
    26.580   338.816     0.150
    26.815   341.316     0.150
    26.797   340.215     0.150
    27.805   350.316     0.150
    29.836   367.016     0.150
    30.067   369.016     0.150
    30.817   377.016     0.150
    30.817     8.000     0.150
    31.357   382.074     0.150
    31.365   381.016     0.150
    31.930   387.016     0.150
    35.727   419.305     0.150
    36.808   569.965     0.150
    38.609   442.117     0.150
    38.895   445.414     0.150
    38.948   445.656     0.150
    39.066   446.516     0.150
    39.066   446.914     0.150
    39.066   804.414     0.150
    40.490   457.664     0.150
    45.218   495.715     0.150
    45.688   500.316     0.150
    46.381   505.715     0.150
    46.478   506.414     0.150
    46.797   508.715     0.150
    49.225   528.016     0.150
    49.405   529.445     0.150
    49.617   530.816     0.150
    50.250   535.715     0.150
    50.395   536.016     0.150
    51.091   542.117     0.150
    51.549   545.715     0.150
    51.826   548.117     0.150
    51.891   548.516     0.150
    51.887   547.914     0.150
    51.883   548.414     0.150
    51.883     4.402     0.150
    52.176   550.441     0.150
    52.234   550.914     0.150
    52.234     4.602     0.150
    52.450   552.016     0.150
    52.587   553.016     0.150
    52.659   553.617     0.150
    53.028   556.215     0.150
    53.343   558.914     0.150
    53.398   559.414     0.150
    53.373   559.316     0.150
    53.384   558.215     0.150
    53.384   558.465     0.150
    53.638   561.117     0.150
    53.722   560.914     0.150
    53.715   562.516     0.150
    53.715     4.199     0.150
    53.753   560.816     0.150
    53.850   562.715     0.150
    53.878   562.516     0.150
    54.016   562.914     0.150
    54.074   564.914     0.150
    54.071   563.117     0.150
    54.168   565.914     0.150
    54.815   569.316     0.150
    55.029   571.016     0.150
    55.320   572.816     0.150
    55.320   573.016     0.150
    55.560   574.316     0.150
    55.560   574.516     0.150
    55.759   575.984     0.150
    55.791   576.414     0.150
    55.703   575.516     0.150
    55.951   577.316     0.150
    56.022   578.414     0.150
    56.061   578.016     0.150
    56.054   580.547     0.150
    56.066   577.957     0.150
    56.375   579.617     0.150
    56.394   581.625     0.150
    56.410   580.816     0.150
    56.459   581.316     0.150
    56.648   583.117     0.150
    56.683   583.117     0.150
    56.784   584.016     0.150
    56.840   583.516     0.150
    57.045   585.316     0.150
    57.112   586.316     0.150
    57.141   585.816     0.150
    57.213   586.516     0.150
    57.349   588.016     0.150
    57.359   588.117     0.150
    57.397   588.316     0.150
    57.495   588.117     0.150
    57.579   589.215     0.150
    57.754   590.516     0.150
    57.837   590.414     0.150
    57.900   592.754     0.150
    57.986   591.316     0.150
    58.064   592.316     0.150
    58.074   592.316     0.150
    58.924   598.516     0.150
    58.937   597.816     0.150
    59.085   599.117     0.150
    59.217   600.117     0.150
    59.380   601.117     0.150
    59.678   603.914     0.150
    60.265   607.715     0.150
    60.705   610.914     0.150
    60.982   613.117     0.150
    61.016   612.914     0.150
    61.234   613.715     0.150
    61.423   614.816     0.150
    61.608   617.316     0.150
    61.760   617.316     0.150
    62.429   621.645     0.150
    62.888   625.117     0.150
    63.091   627.016     0.150
    63.325   627.816     0.150
    63.375   627.914     0.150
    66.644   649.016     0.150
    66.570   649.414     0.150
    72.795   687.617     0.150
    72.811   687.516     0.150
    75.012   700.016     0.150
    75.014   700.164     0.150
    75.631   704.117     0.150
    77.086   712.215     0.150
    78.064   717.875     0.150
    78.165   717.504     0.150
    78.478   721.316     0.150
    78.509   718.816     0.150
    78.509   896.367     0.150
    80.005   728.016     0.150
    80.789   733.215     0.150
    81.703   738.137     0.150
    81.756   738.605     0.150
    81.856   739.004     0.150
    82.070   740.086     0.150
    85.536   756.465     0.150
   120.510  1131.191     0.150
   153.581  1198.164     0.150
    29.836   366.734     0.150
    29.836   366.727     0.150
    75.014   701.008     0.150
    75.014   700.984     0.150
    75.014   701.016     0.150
    75.014   701.000     0.150
    75.014   701.000     0.150
    21.386   287.125     0.150
    78.165   718.859     0.150
    61.476   616.109     0.150
    46.381   505.852     0.150
    46.381   505.828     0.150
    46.381   505.879     0.150
    46.381   505.867     0.150
    46.381   505.867     0.150
    52.176   550.141     0.150
    52.176   550.168     0.150
    52.176   550.168     0.150
    52.176   550.168     0.150
    12.965   183.730     0.150
    12.965   183.730     0.150
    78.509   720.715     0.150
    78.509   720.605     0.150
    78.509   720.762     0.150
    45.688   500.410     0.150
    45.688   500.410     0.150
    49.617   530.859     0.150
    49.617   530.938     0.150
    49.617   530.906     0.150
     6.119    89.637     0.150
     6.119    89.609     0.150
     6.119    90.062     0.150
     6.119    89.891     0.150
     6.119    89.812     0.150
     6.119    90.004     0.150
     6.119    90.004     0.150
     6.119    90.004     0.150
    53.384   559.117     0.150
    53.384   559.082     0.150
    53.384   559.141     0.150
    53.384   559.098     0.150
    39.066   446.496     0.150
    39.066   446.496     0.150
    39.066   446.496     0.150
    85.536   757.637     0.150
    27.429   345.309     0.150
    27.429   345.309     0.150
    27.429   345.309     0.150
    27.429   345.309     0.150
    72.795   687.965     0.150
    72.795   688.016     0.150
    72.795   688.008     0.150
    72.795   688.008     0.150
    72.795   688.008     0.150
    25.209   325.238     0.150
    23.829   313.145     0.150
    23.829   312.672     0.150
     0.050     2.043     0.150
     0.050     3.543     0.150
     0.051     2.441     0.150
     0.051     3.863     0.150
     0.032     1.742     0.150
     0.032     3.242     0.150
     0.046     1.543     0.150
     0.046     3.242     0.150
     0.103     3.004     0.150
     0.103     4.871     0.150
     0.067     4.562     0.150
     0.067     2.594     0.150
     0.111     5.133     0.150
     0.183     2.543     0.150
     0.216     3.043     0.150
     0.216     6.145     0.150
     0.213     4.504     0.150
     0.213     7.984     0.150
     0.220     4.352     0.150
     0.220     7.145     0.150
     0.204     4.621     0.150
     0.204     8.191     0.150
     0.259     5.121     0.150
     0.259     8.742     0.150
     0.266     6.094     0.150
     0.266     8.543     0.150
     0.288     5.562     0.150
     0.288     9.242     0.150
     0.382     7.074     0.150
     0.382    12.305     0.150
     1.141    23.344     0.150
     1.141    37.441     0.150
     0.062     2.180     0.150
     0.062     3.680     0.150
     0.062     2.531     0.150
     0.062     4.570     0.150
     0.017     2.281     0.150
     0.017     3.980     0.150
     0.035     2.082     0.150
     0.035     3.781     0.150
     0.062     2.621     0.150
     0.062     4.590     0.150
     0.110     3.031     0.150
     0.110     5.281     0.150
     0.199     4.672     0.150
     0.199     8.160     0.150
     0.218     3.200     0.150
     0.213     4.582     0.150
     0.213     7.730     0.150
     0.222     4.422     0.150
     0.222     7.352     0.150
     0.275     5.430     0.150
     0.275     9.172     0.150
     0.274     9.531     0.150
     0.302     5.891     0.150
     0.302     9.723     0.150
     0.399     7.922     0.150
     0.399    12.832     0.150
     0.050     1.477     0.150
     0.051     2.500     0.150
     0.051     4.406     0.150
     0.050     2.977     0.150
     0.026     2.477     0.150
     0.026     4.078     0.150
     0.046     1.977     0.150
     0.046     3.875     0.150
     0.107     3.125     0.150
     0.069     4.688     0.150
     0.069     2.688     0.150
     0.106     2.977     0.150
     0.106     5.180     0.150
     0.176     2.477     0.150
     0.216     4.305     0.150
     0.216     7.336     0.150
     0.212     2.477     0.150
     0.208     4.523     0.150
     0.208     8.266     0.150
     0.207     4.805     0.150
     0.207     8.406     0.150
     0.262     5.297     0.150
     0.262     8.805     0.150
     0.264     5.727     0.150
     0.264     8.727     0.150
     0.289     5.656     0.150
     0.289     9.375     0.150
     0.387     7.508     0.150
     1.135    22.773     0.150
     1.183    37.180     0.150
     0.023     2.250     0.150
     0.023     3.750     0.150
     0.031     2.539     0.150
     0.031     4.547     0.150
     0.061     2.500     0.150
     0.061     4.828     0.150
     0.070     2.750     0.150
     0.070     4.250     0.150
     0.112     3.023     0.150
     0.112     5.453     0.150
     0.087     2.453     0.150
     0.087     4.148     0.150
     0.102     3.070     0.150
     0.102     5.453     0.150
     0.208     6.953     0.150
     0.204     7.773     0.150
     0.208     4.094     0.150
     0.189     3.500     0.150
     0.189     5.250     0.150
     0.201     3.250     0.150
     0.201     6.250     0.150
     0.207     4.430     0.150
     0.207     7.453     0.150
     0.216     4.508     0.150
     0.216     7.547     0.150
     0.237     4.500     0.150
     0.237     7.750     0.150
     0.248     4.812     0.150
     0.248     8.547     0.150
     0.232     5.133     0.150
     0.232     9.047     0.150
     0.342     6.602     0.150
     0.342    10.953     0.150
     1.066    18.148     0.150
     1.083    20.297     0.150
     1.083    33.023     0.150
     1.176    24.047     0.150
     1.221    24.750     0.150
     0.011     2.289     0.150
     0.011     3.992     0.150
     0.076     2.820     0.150
     0.076     4.992     0.150
     0.078     4.789     0.150
     0.078     2.992     0.150
     0.037     2.289     0.150
     0.037     4.188     0.150
     0.106     3.133     0.150
     0.106     5.188     0.150
     0.066     2.883     0.150
     0.066     4.992     0.150
     0.166     2.789     0.150
     0.220     4.508     0.150
     0.220     8.188     0.150
     0.217     3.289     0.150
     0.217     6.391     0.150
     0.209     4.570     0.150
     0.209     7.758     0.150
     0.281     9.539     0.150
     0.295     5.930     0.150
     0.295     9.688     0.150
     0.316     6.250     0.150
     0.316    10.289     0.150
     0.420     8.188     0.150
     0.420    13.586     0.150
     0.059     2.047     0.150
     0.059     3.547     0.150
     0.059     2.516     0.150
     0.059     4.148     0.150
     0.019     2.547     0.150
     0.019     4.445     0.150
     0.039     2.250     0.150
     0.039     4.148     0.150
     0.116     3.188     0.150
     0.116     5.438     0.150
     0.064     2.625     0.150
     0.064     4.570     0.150
     0.108     3.047     0.150
     0.108     5.266     0.150
     0.175     3.047     0.150
     0.175     5.047     0.150
     0.215     5.750     0.150
     0.211     8.078     0.150
     0.219     4.398     0.150
     0.202     4.664     0.150
     0.202     8.250     0.150
     0.272     5.438     0.150
     0.272     9.047     0.150
     0.298     5.898     0.150
     0.298     9.547     0.150
     0.396     7.906     0.150
     0.396    12.750     0.150
     0.037     2.205     0.150
     0.037     4.125     0.150
     0.035     1.875     0.150
     0.035     2.475     0.150
     0.059     1.775     0.150
     0.059     2.574     0.150
     0.095     2.725     0.150
     0.095     4.824     0.150
     0.100     2.686     0.150
     0.100     4.674     0.150
     0.081     2.594     0.150
     0.081     4.674     0.150
     0.173     2.475     0.150
     0.207     3.945     0.150
     0.207     6.855     0.150
     0.218     4.734     0.150
     0.218     8.715     0.150
     0.250     4.855     0.150
     0.252     8.475     0.150
     0.276     5.295     0.150
     0.276     8.865     0.150
     0.050     2.098     0.150
     0.050     3.699     0.150
     0.015     1.598     0.150
     0.015     3.297     0.150
     0.109     2.727     0.150
     0.109     5.258     0.150
     0.148     3.188     0.150
     0.160     3.547     0.150
     0.160     6.387     0.150
     0.205     2.598     0.150
     0.159     3.637     0.150
     0.159     6.797     0.150
     0.251     4.770     0.150
     0.251     9.520     0.150
     0.262     4.746     0.150
     0.262     8.297     0.150
     0.300     5.707     0.150
     0.300     9.699     0.150
     0.315     5.918     0.150
     0.315    10.199     0.150
     0.433     8.020     0.150
     0.433    13.598     0.150
     0.032     2.555     0.150
     0.032     4.154     0.150
     0.044     2.555     0.150
     0.044     4.305     0.150
     0.099     3.074     0.150
     0.099     5.244     0.150
     0.033     2.555     0.150
     0.033     4.154     0.150
     0.066     4.754     0.150
     0.090     2.955     0.150
     0.090     5.055     0.150
     0.160     2.555     0.150
     0.160     4.555     0.150
     0.188     3.000     0.150
     0.195     3.994     0.150
     0.195     6.455     0.150
     0.244     8.555     0.150
     0.253     5.105     0.150
     0.253     8.445     0.150
     0.246     5.045     0.150
     0.246     8.195     0.150
     0.273     5.455     0.150
     0.046     2.078     0.150
     0.046     3.305     0.150
     0.061     2.117     0.150
     0.061     3.617     0.150
     0.029     1.617     0.150
     0.029     3.117     0.150
     0.103     2.805     0.150
     0.103     5.047     0.150
     0.050     1.117     0.150
     0.050     2.719     0.150
     0.175     2.820     0.150
     0.175     4.367     0.150
     0.213     4.094     0.150
     0.213     7.180     0.150
     0.208     2.617     0.150
     0.208     5.617     0.150
     0.258     5.023     0.150
     0.258     7.938     0.150
     0.249     4.969     0.150
     0.249     8.055     0.150
     0.053     2.062     0.150
     0.053     3.562     0.150
     0.056     2.477     0.150
     0.056     4.141     0.150
     0.073     2.859     0.150
     0.073     3.859     0.150
     0.034     1.500     0.150
     0.104     3.047     0.150
     0.104     5.242     0.150
     0.042     1.461     0.150
     0.042     3.062     0.150
     0.063     2.570     0.150
     0.063     4.383     0.150
     0.220     3.359     0.150
     0.220     6.359     0.150
     0.217     3.250     0.150
     0.225     4.328     0.150
     0.225     7.547     0.150
     0.249     5.062     0.150
     0.249     8.102     0.150
     0.260     5.180     0.150
     0.260     8.383     0.150
     0.291     5.680     0.150
     0.054     1.367     0.150
     0.054     2.867     0.150
     0.054     2.379     0.150
     0.054     4.176     0.150
     0.024     2.367     0.150
     0.024     3.969     0.150
     0.042     1.367     0.150
     0.042     2.867     0.150
     0.066     2.527     0.150
     0.066     4.469     0.150
     0.108     2.867     0.150
     0.108     4.969     0.150
     0.219     4.219     0.150
     0.219     7.246     0.150
     0.203     4.637     0.150
     0.203     8.078     0.150
     0.255     5.078     0.150
     0.255     8.578     0.150
     0.265     5.227     0.150
     0.265     8.676     0.150
     0.293     5.836     0.150
     0.293     9.379     0.150
     0.390     7.605     0.150
     1.133    22.766     0.150
     1.133    36.766     0.150
     1.182    23.266     0.150
     1.182    38.566     0.150
     0.084     2.938     0.150
     0.084     5.066     0.150
     0.120     2.227     0.150
     0.120     3.727     0.150
     0.128     3.535     0.150
     0.128     6.238     0.150
     0.155     3.977     0.150
     0.155     5.227     0.150
     0.162     3.535     0.150
     0.162     6.156     0.150
     0.136     3.488     0.150
     0.136     6.336     0.150
     0.142     2.828     0.150
     0.142     4.828     0.150
     0.154     3.426     0.150
     0.154     6.426     0.150
     0.193     3.988     0.150
     0.193     6.676     0.150
     0.210     4.426     0.150
     0.210     8.027     0.150
     0.264     4.996     0.150
     0.264     8.695     0.150
     0.217     4.898     0.150
     0.217     8.465     0.150
     0.298    10.227     0.150
     0.295     5.578     0.150
     0.295     9.398     0.150
     0.298     5.977     0.150
     0.287     4.727     0.150
     0.287     7.926     0.150
     0.285     5.566     0.150
     0.285     9.586     0.150
     1.105    21.727     0.150
     1.105    36.727     0.150
     1.141    21.227     0.150
     1.141    37.227     0.150
     1.182    35.797     0.150
     1.260    26.027     0.150
     1.311    25.727     0.150
     1.935    34.727     0.150
     2.225    29.600     0.150
     2.597    77.727     0.150
     0.050     2.594     0.150
     0.050     4.352     0.150
     0.075     2.914     0.150
     0.075     4.164     0.150
     0.062     2.164     0.150
     0.062     3.766     0.150
     0.067     1.664     0.150
     0.067     3.664     0.150
     0.079     2.852     0.150
     0.079     5.055     0.150
     0.126     3.242     0.150
     0.126     5.781     0.150
     0.220     4.555     0.150
     0.220     7.766     0.150
     0.222     3.664     0.150
     0.222     6.766     0.150
     0.223     3.000     0.150
     0.228     4.445     0.150
     0.228     7.586     0.150
     0.208     4.727     0.150
     0.208     8.414     0.150
     0.270     5.211     0.150
     0.270     8.844     0.150
     0.353     6.938     0.150
     0.353    11.453     0.150
     0.020     2.345     0.150
     0.020     3.945     0.150
     0.104     2.845     0.150
     0.104     4.845     0.150
     0.066     2.845     0.150
     0.066     3.845     0.150
     0.044     1.845     0.150
     0.044     3.745     0.150
     0.053     2.415     0.150
     0.053     4.445     0.150
     0.053     2.000     0.150
     0.069     2.545     0.150
     0.069     4.545     0.150
     0.206     3.000     0.150
     0.215     4.165     0.150
     0.215     7.245     0.150
     0.207     4.615     0.150
     0.207     8.245     0.150
     0.267     5.245     0.150
     0.267     8.745     0.150
     0.293     5.565     0.150
     0.293     9.345     0.150
     0.393     7.615     0.150
     1.058    19.905     0.150
     1.058    33.465     0.150
     1.129    22.545     0.150
     1.129    36.345     0.150
     1.177    38.345     0.150
     2.333    43.045     0.150
     2.558    78.845     0.150
     0.047     3.059     0.150
     0.047     2.410     0.150
     0.047     4.480     0.150
     0.049     1.559     0.150
     0.049     3.258     0.150
     0.072     2.680     0.150
     0.072     4.668     0.150
     0.105     2.938     0.150
     0.105     5.148     0.150
     0.210     3.559     0.150
     0.210     6.059     0.150
     0.215     4.230     0.150
     0.215     7.270     0.150
     0.209     4.707     0.150
     0.209     8.359     0.150
     0.249     4.969     0.150
     0.249     8.258     0.150
     0.259     5.090     0.150
     0.259     8.559     0.150
     0.286     5.379     0.150
     0.286     9.168     0.150
     0.383     7.367     0.150
     0.383    12.367     0.150
     1.064    20.387     0.150
     1.064    33.648     0.150
     1.145    22.059     0.150
     1.145    37.559     0.150
     1.138    21.859     0.150
     1.138    37.457     0.150
     1.186    23.359     0.150
     1.186    38.258     0.150
     2.024    35.559     0.150
     2.024    61.559     0.150
     2.324    41.660     0.150
     2.557    43.559     0.150
     2.557    77.059     0.150
     2.690    44.559     0.150
     3.595    58.059     0.150
     3.595   100.059     0.150
     0.014     0.574     0.150
     0.014     2.277     0.150
     0.059     1.176     0.150
     0.059     3.574     0.150
     0.057     2.355     0.150
     0.057     4.105     0.150
     0.068     2.406     0.150
     0.068     4.414     0.150
     0.103     2.688     0.150
     0.103     4.695     0.150
     0.211     6.176     0.150
     0.215     4.027     0.150
     0.215     6.824     0.150
     0.211     3.176     0.150
     0.205     4.426     0.150
     0.205     7.336     0.150
     0.264     5.156     0.150
     0.264     8.324     0.150
     0.273     5.367     0.150
     0.273     8.234     0.150
     0.298     5.754     0.150
     1.171    22.477     0.150
     1.171    36.977     0.150
     0.029     1.094     0.150
     0.029     3.391     0.150
     0.035     2.273     0.150
     0.035     3.695     0.150
     0.052     2.891     0.150
     0.069     1.992     0.150
     0.069     2.695     0.150
     0.087     2.602     0.150
     0.087     4.594     0.150
     0.108     2.805     0.150
     0.108     4.695     0.150
     0.225     4.523     0.150
     0.225     7.492     0.150
     0.235     4.633     0.150
     0.205     4.594     0.150
     0.205     3.094     0.150
     0.205     6.094     0.150
     0.211     3.953     0.150
     0.211     6.594     0.150
     0.205     7.594     0.150
     0.354     6.594     0.150
     0.354    10.594     0.150
     1.205    24.094     0.150
     0.009     1.562     0.150
     0.009     3.359     0.150
     0.041     1.859     0.150
     0.041     3.562     0.150
     0.077     0.859     0.150
     0.077     2.859     0.150
     0.073     2.672     0.150
     0.073     4.340     0.150
     0.103     2.832     0.150
     0.103     4.590     0.150
     0.070     2.691     0.150
     0.070     4.633     0.150
     0.205     4.461     0.150
     0.205     7.961     0.150
     0.214     3.762     0.150
     0.214     6.461     0.150
     0.216     4.230     0.150
     0.216     7.020     0.150
     0.204     8.180     0.150
     0.286     5.672     0.150
     0.286     9.520     0.150
     0.294     5.781     0.150
     0.294     9.270     0.150
     0.314     6.051     0.150
     0.314     9.789     0.150
     0.390     6.961     0.150
     1.039    19.199     0.150
     1.039    34.660     0.150
     1.101    35.961     0.150
     1.170    22.762     0.150
     1.170    38.160     0.150
     1.151    21.461     0.150
     1.151    36.660     0.150
     2.059    36.961     0.150
     2.059    63.961     0.150
     2.361    41.660     0.150
     2.562    42.961     0.150
     2.562    75.961     0.150
     2.695    44.961     0.150
     2.695    80.961     0.150
     2.762    83.961     0.150
     3.632    57.461     0.150
     3.632   100.062     0.150
     4.528    69.961     0.150
     1.504    28.160     0.150
     1.504    48.660     0.150
     1.813    32.750     0.150
     2.059    36.961     0.150
     2.059    63.961     0.150
     2.362    41.660     0.150
     2.792    45.770     0.150
     2.762    50.961     0.150
     2.950    89.961     0.150
     3.532    56.062     0.150
     3.532    97.660     0.150
     3.749    59.762     0.150
     4.314   114.941     0.150
     4.510    70.242     0.150
     4.510   119.820     0.150
     5.159    78.039     0.150
     5.714    85.520     0.150
     5.760    86.141     0.150
     5.760   150.602     0.150
     5.966    89.461     0.150
     6.181    91.562     0.150
     6.148    92.570     0.150
     6.148   163.020     0.150
     6.537   167.402     0.150
     7.194   105.223     0.150
    23.843   312.086     0.150
    38.964   444.910     0.150
    52.205   550.500     0.150
    72.766   686.961     0.150
    78.519   719.609     0.150
    49.430   529.711     0.150
     6.148    89.848     0.150
     6.148    92.223     0.150
     6.148    90.652     0.150
     6.148    89.621     0.150
     6.148    90.715     0.150
     6.148   161.016     0.150
     6.148   161.016     0.150
     6.148   159.430     0.150
    72.766   688.297     0.150
     0.009     0.312     0.150
     0.009     2.312     0.150
     0.010     2.195     0.150
     0.010     3.672     0.150
     0.060     1.516     0.150
     0.060     3.117     0.150
     0.087     2.438     0.150
     0.087     4.031     0.150
     0.088     1.914     0.150
     0.088     3.617     0.150
     0.109     2.773     0.150
     0.109     5.008     0.150
     0.180     2.914     0.150
     0.180     5.414     0.150
     0.182     3.914     0.150
     0.186     3.438     0.150
     0.186     5.961     0.150
     0.182     6.914     0.150
     0.222     4.438     0.150
     0.222     7.305     0.150
     0.227     4.422     0.150
     0.227     7.477     0.150
     0.247     4.602     0.150
     0.247     7.586     0.150
     0.244     5.156     0.150
     0.244     8.516     0.150
     0.331     5.914     0.150
     0.331     9.914     0.150
     0.036     2.408     0.150
     0.036     4.258     0.150
     0.038     0.848     0.150
     0.038     2.748     0.150
     0.030     1.348     0.150
     0.030     3.048     0.150
     0.062     1.948     0.150
     0.062     3.148     0.150
     0.090     2.718     0.150
     0.090     4.608     0.150
     0.086     2.778     0.150
     0.086     4.818     0.150
     0.191     3.948     0.150
     0.191     7.948     0.150
     0.194     3.148     0.150
     0.194     5.548     0.150
     0.199     3.878     0.150
     0.199     6.738     0.150
     0.224     5.008     0.150
     0.224     8.548     0.150
     0.248     4.988     0.150
     0.248     8.448     0.150
     0.255     5.038     0.150
     0.255     8.448     0.150
     0.277     5.268     0.150
     0.277     8.748     0.150
     0.357     6.448     0.150
     0.357    10.448     0.150
     1.051    19.448     0.150
     1.133    21.948     0.150
     1.133    37.148     0.150
     1.134    22.348     0.150
     1.134    36.348     0.150
     2.020    35.948     0.150
     2.020    61.948     0.150
     2.323    42.248     0.150
     2.541    42.948     0.150
     2.541    76.948     0.150
     2.674    44.948     0.150
     2.674    79.948     0.150
     3.595    58.448     0.150
     3.595   101.448     0.150
     0.029     0.499     0.150
     0.029     2.099     0.150
     0.062     2.209     0.150
     0.062     4.009     0.150
     0.035     0.499     0.150
     0.035     1.999     0.150
     0.078     1.999     0.150
     0.078     3.499     0.150
     0.057     2.249     0.150
     0.057     3.909     0.150
     0.112     2.779     0.150
     0.112     5.129     0.150
     0.118     2.679     0.150
     0.118     4.819     0.150
     0.186     2.499     0.150
     0.186     5.249     0.150
     0.194     4.199     0.150
     0.194     6.929     0.150
     0.220     4.499     0.150
     0.220     7.999     0.150
     0.228     4.159     0.150
     0.228     7.309     0.150
     0.257     4.909     0.150
     0.257     8.429     0.150
     0.268     5.009     0.150
     0.268     8.509     0.150
     0.299     5.659     0.150
     0.299     9.169     0.150
     0.050     0.176     0.150
     0.050     2.176     0.150
     0.050     2.234     0.150
     0.050     3.348     0.150
     0.065     2.176     0.150
     0.065     3.176     0.150
     0.025     1.777     0.150
     0.046     1.176     0.150
     0.046     2.875     0.150
     0.107     2.824     0.150
     0.107     5.086     0.150
     0.105     2.707     0.150
     0.105     4.664     0.150
     0.070     2.375     0.150
     0.070     4.348     0.150
     0.175     2.426     0.150
     0.175     4.926     0.150
     0.211     3.176     0.150
     0.211     5.676     0.150
     0.207     4.176     0.150
     0.207     7.426     0.150
     0.215     4.125     0.150
     0.215     6.664     0.150
     0.207     4.504     0.150
     0.253     4.855     0.150
     0.253     8.484     0.150
     0.207     7.547     0.150
     0.263     5.074     0.150
     0.263     8.457     0.150
     0.264     6.176     0.150
     0.264     9.176     0.150
     0.289     8.977     0.150
     1.134    23.676     0.150
     0.049     2.906     0.150
     0.030     2.109     0.150
     0.030     3.625     0.150
     0.090     1.203     0.150
     0.142     1.703     0.150
     0.142     4.203     0.150
     0.144     3.266     0.150
     0.144     5.656     0.150
     0.158     3.203     0.150
     0.158     4.703     0.150
     0.184     4.000     0.150
     0.184     7.047     0.150
     0.119     5.281     0.150
     0.188     3.930     0.150
     0.188     7.133     0.150
     0.119     3.047     0.150
     0.243     3.453     0.150
     0.243     6.953     0.150
     0.291     5.703     0.150
     0.291     9.703     0.150
     0.302     5.664     0.150
     0.302     9.555     0.150
     0.317     6.211     0.150
     0.317     9.914     0.150
     0.337     6.531     0.150
     0.337    10.773     0.150
     0.378     7.234     0.150
     0.378    11.516     0.150
     0.025     1.719     0.150
     0.018     1.719     0.150
     0.076     4.719     0.150
     0.076     2.580     0.150
     0.076     4.559     0.150
     0.076     2.660     0.150
     0.054     2.500     0.150
     0.054     4.199     0.150
     0.086     2.520     0.150
     0.086     4.020     0.150
     0.133     3.350     0.150
     0.133     5.879     0.150
     0.117     3.059     0.150
     0.117     5.150     0.150
     0.117     5.369     0.150
     0.179     2.750     0.150
     0.190     4.439     0.150
     0.190     7.809     0.150
     0.220     4.520     0.150
     0.278     5.510     0.150
     0.278     8.980     0.150
     0.278     9.279     0.150
     0.289     5.639     0.150
     0.289     9.619     0.150
     0.316    10.109     0.150
     0.412     7.930     0.150
     0.412    13.219     0.150
     0.048     2.598     0.150
     0.048     4.375     0.150
     0.063     3.117     0.150
     0.102     2.700     0.150
     0.158     3.117     0.150
     0.158     5.016     0.150
     0.159     3.758     0.150
     0.159     6.418     0.150
     0.114     3.527     0.150
     0.114     6.188     0.150
     0.172     3.816     0.150
     0.172     6.816     0.150
     0.202     4.547     0.150
     0.202     7.637     0.150
     0.198     4.426     0.150
     0.198     7.688     0.150
     0.248     3.750     0.150
     0.300     6.316     0.150
     0.312     6.207     0.150
     0.312    10.406     0.150
     0.336     6.695     0.150
     0.336    10.945     0.150
     0.356     7.027     0.150
     0.356    11.426     0.150
     0.395    12.785     0.150
     0.465     9.035     0.150
     0.465    15.188     0.150
     0.055     1.617     0.150
     0.055     3.219     0.150
     0.036     2.359     0.150
     0.036     4.180     0.150
     0.096     1.418     0.150
     0.149     3.020     0.150
     0.149     5.520     0.150
     0.151     3.508     0.150
     0.151     5.707     0.150
     0.165     3.719     0.150
     0.165     5.219     0.150
     0.191     4.348     0.150
     0.191     7.457     0.150
     0.194     4.207     0.150
     0.194     7.379     0.150
     0.114     3.289     0.150
     0.114     5.039     0.150
     0.248     3.469     0.150
     0.248     7.469     0.150
     0.297     6.219     0.150
     0.297    10.719     0.150
     0.308     5.949     0.150
     0.308     9.648     0.150
     0.323     6.469     0.150
     0.323    10.500     0.150
     0.343     6.617     0.150
     0.343    10.828     0.150
     0.365     7.719     0.150
     0.365    12.469     0.150
     0.385     7.398     0.150
     0.076     5.240     0.150
     0.116     5.791     0.150
     0.116     3.570     0.150
     0.115     3.141     0.150
     0.115     5.641     0.150
     0.091     2.240     0.150
     0.091     4.240     0.150
     0.124     3.580     0.150
     0.124     6.141     0.150
     0.117     2.500     0.150
     0.226     4.891     0.150
     0.226     7.939     0.150
     0.198     4.529     0.150
     0.198     7.740     0.150
     0.252     5.240     0.150
     0.252     8.340     0.150
     0.313     6.330     0.150
     0.313    10.141     0.150
     0.300     5.930     0.150
     0.300     9.939     0.150
     0.049     3.059     0.150
     0.049     3.656     0.150
     0.049     0.957     0.150
     0.049     2.227     0.150
     0.026     1.355     0.150
     0.026     3.258     0.150
     0.047     1.656     0.150
     0.047     3.156     0.150
     0.106     2.879     0.150
     0.106     5.105     0.150
     0.105     2.688     0.150
     0.105     4.559     0.150
     0.071     2.336     0.150
     0.071     4.156     0.150
     0.175     2.457     0.150
     0.175     4.957     0.150
     0.210     3.457     0.150
     0.210     6.457     0.150
     0.207     3.957     0.150
     0.207     6.957     0.150
     0.214     4.066     0.150
     0.214     6.457     0.150
     0.208     4.496     0.150
     0.208     7.559     0.150
     0.252     4.898     0.150
     0.252     7.957     0.150
     0.288     5.527     0.150
     0.048     2.344     0.150
     0.048     4.035     0.150
     0.029     1.254     0.150
     0.029     3.156     0.150
     0.048     1.555     0.150
     0.048     3.254     0.150
     0.103     2.906     0.150
     0.103     5.004     0.150
     0.071     2.496     0.150
     0.071     4.574     0.150
     0.106     2.855     0.150
     0.106     4.484     0.150
     0.177     2.555     0.150
     0.177     5.055     0.150
     0.210     3.355     0.150
     0.210     6.055     0.150
     0.215     4.156     0.150
     0.215     7.145     0.150
     0.207     4.055     0.150
     0.207     7.805     0.150
     0.249     5.043     0.150
     0.249     8.043     0.150
     0.259     4.953     0.150
     0.259     8.406     0.150
     0.208     4.574     0.150
     0.208     7.535     0.150
     0.262     9.305     0.150
     0.018     1.844     0.150
     0.018     3.547     0.150
     0.074     2.406     0.150
     0.074     4.246     0.150
     0.079     1.844     0.150
     0.079     3.945     0.150
     0.092     2.645     0.150
     0.092     4.547     0.150
     0.055     1.445     0.150
     0.055     3.145     0.150
     0.083     2.586     0.150
     0.083     4.746     0.150
     0.144     3.305     0.150
     0.144     5.805     0.150
     0.148     2.445     0.150
     0.148     4.445     0.150
     0.203     2.344     0.150
     0.203     4.945     0.150
     0.205     4.016     0.150
     0.205     6.945     0.150
     0.216     4.855     0.150
     0.216     7.945     0.150
     0.291     9.617     0.150
     0.297     5.887     0.150
     0.291     5.785     0.150
     0.014     3.484     0.150
     0.066     0.885     0.150
     0.066     3.285     0.150
     0.124     2.186     0.150
     0.124     3.885     0.150
     0.149     3.365     0.150
     0.149     5.266     0.150
     0.135     2.285     0.150
     0.135     3.984     0.150
     0.153     3.195     0.150
     0.153     5.096     0.150
     0.165     3.334     0.150
     0.165     5.305     0.150
     0.143     3.244     0.150
     0.143     5.564     0.150
     0.211     3.895     0.150
     0.211     6.494     0.150
     0.225     4.285     0.150
     0.225     6.654     0.150
     0.229     4.135     0.150
     0.229     6.885     0.150
     0.227     4.135     0.150
     0.022     0.707     0.150
     0.022     2.407     0.150
     0.040     1.506     0.150
     0.040     3.207     0.150
     0.091     3.207     0.150
     0.091     4.207     0.150
     0.091     1.606     0.150
     0.091     4.207     0.150
     0.110     2.917     0.150
     0.110     4.907     0.150
     0.152     3.667     0.150
     0.152     6.526     0.150
     0.164     2.207     0.150
     0.212     4.207     0.150
     0.212     8.207     0.150
     0.224     4.336     0.150
     0.224     6.907     0.150
     0.222     3.606     0.150
     0.222     6.207     0.150
     0.199     4.437     0.150
     0.199     7.606     0.150
     0.289     5.707     0.150
     0.289    10.207     0.150
     0.299     5.887     0.150
     0.299     9.606     0.150
     0.307     5.977     0.150
     0.307     9.517     0.150
     0.328     6.296     0.150
     0.328    10.307     0.150
     0.401     6.707     0.150
     1.182    23.707     0.150
     2.073    37.707     0.150
     2.073    64.707     0.150
     2.374    31.000     0.150
     2.570    41.907     0.150
     2.570    75.907     0.150
     2.775    88.707     0.150
     3.644    57.307     0.150
     3.644   100.307     0.150
     5.738    85.157     0.150
     5.738   149.997     0.150
     0.031     2.000     0.150
     0.057     1.852     0.150
     0.057     4.352     0.150
     0.048     1.750     0.150
     0.048     3.750     0.150
     0.065     1.352     0.150
     0.065     3.051     0.150
     0.083     2.781     0.150
     0.083     4.992     0.150
     0.107     2.953     0.150
     0.107     4.551     0.150
     0.182     2.852     0.150
     0.182     5.102     0.150
     0.205     3.852     0.150
     0.205     7.602     0.150
     0.211     4.121     0.150
     0.211     6.711     0.150
     0.219     4.703     0.150
     0.219     7.941     0.150
     0.229     7.410     0.150
     0.250     8.602     0.150
     0.229     4.672     0.150
     0.250     5.352     0.150
     0.239     4.820     0.150
     0.239     7.621     0.150
     0.268     5.082     0.150
     0.268     8.090     0.150
     0.356     5.852     0.150
     0.356    10.352     0.150
     1.125    22.051     0.150
     1.125    35.852     0.150
     1.156    22.852     0.150
     1.156    38.852     0.150
     2.549    76.852     0.150
     0.058     0.949     0.150
     0.058     2.648     0.150
     0.099     1.750     0.150
     0.099     3.949     0.150
     0.167     4.449     0.150
     0.167     5.449     0.150
     0.111     3.070     0.150
     0.111     5.148     0.150
     0.192     4.051     0.150
     0.192     7.230     0.150
     0.197     4.051     0.150
     0.197     7.359     0.150
     0.251     3.199     0.150
     0.251     6.699     0.150
     0.300     5.449     0.150
     0.311     5.777     0.150
     0.311    10.449     0.150
     0.324     6.277     0.150
     0.324    10.199     0.150
     0.345    10.629     0.150
     0.345     6.688     0.150
     0.387     7.320     0.150
     0.387    12.250     0.150
     0.046     2.516     0.150
     0.046     4.273     0.150
     0.022     1.305     0.150
     0.022     3.004     0.150
     0.055     2.805     0.150
     0.055     4.805     0.150
     0.085     1.700     0.150
     0.110     2.883     0.150
     0.110     5.004     0.150
     0.104     2.305     0.150
     0.104     4.004     0.150
     0.120     3.305     0.150
     0.120     5.703     0.150
     0.193     4.145     0.150
     0.193     6.805     0.150
     0.200     4.066     0.150
     0.200     6.805     0.150
     0.198     4.035     0.150
     0.198     6.504     0.150
     0.197     3.805     0.150
     0.197     6.805     0.150
     0.230     7.305     0.150
     0.226     4.555     0.150
     0.226     7.805     0.150
     0.249     5.156     0.150
     0.249     9.504     0.150
     0.036     1.328     0.150
     0.036     3.125     0.150
     0.063     2.477     0.150
     0.063     4.219     0.150
     0.063     2.500     0.150
     0.108     2.844     0.150
     0.108     4.828     0.150
     0.175     2.727     0.150
     0.175     5.727     0.150
     0.211     4.477     0.150
     0.211     8.727     0.150
     0.220     4.234     0.150
     0.220     7.328     0.150
     0.200     4.539     0.150
     0.200     7.727     0.150
     0.276     5.328     0.150
     0.276     8.930     0.150
     0.383     6.727     0.150
     0.383    10.727     0.150
     1.122    20.727     0.150
     1.159    21.727     0.150
     2.042    36.727     0.150
     2.042    63.727     0.150
     2.342    41.828     0.150
     2.565    41.727     0.150
     2.565    75.727     0.150
     2.698    34.000     0.150
     2.744    81.727     0.150
     5.733    87.539     0.150
     5.733   149.984     0.150
     0.046     1.541     0.150
     0.046     4.041     0.150
     0.050     1.240     0.150
     0.050     2.941     0.150
     0.073     2.561     0.150
     0.073     4.551     0.150
     0.185     3.141     0.150
     0.185     6.141     0.150
     0.212     4.131     0.150
     0.212     7.090     0.150
     0.205     4.141     0.150
     0.208     3.641     0.150
     0.208     6.141     0.150
     0.205     7.891     0.150
     0.210     4.631     0.150
     0.210     8.260     0.150
     0.259     5.021     0.150
     0.259     8.451     0.150
     0.250     4.930     0.150
     0.250     8.781     0.150
     0.285     5.420     0.150
     0.285     9.061     0.150
     0.369     6.641     0.150
     0.369    10.141     0.150
     0.385     7.281     0.150
     0.385    12.180     0.150
     1.136    23.141     0.150
     2.555    42.141     0.150
     2.555    76.641     0.150
     0.007     2.092     0.150
     0.007     3.791     0.150
     0.037     1.092     0.150
     0.037     2.791     0.150
     0.065     2.711     0.150
     0.065     4.691     0.150
     0.069     2.791     0.150
     0.069     5.391     0.150
     0.075     1.791     0.150
     0.075     4.291     0.150
     0.105     4.701     0.150
     0.166     3.291     0.150
     0.166     6.291     0.150
     0.208     4.791     0.150
     0.208     8.291     0.150
     0.202     4.791     0.150
     0.202     8.291     0.150
     0.215     3.291     0.150
     0.215     5.791     0.150
     0.218     4.502     0.150
     0.218     7.791     0.150
     0.275     5.480     0.150
     0.275     9.391     0.150
     0.284     5.602     0.150
     0.284     9.342     0.150
     0.307     5.881     0.150
     0.307     9.871     0.150
     0.410     7.861     0.150
     0.410    13.201     0.150
     1.113    20.291     0.150
     1.113    35.291     0.150
     1.163    39.191     0.150
     2.563    44.791     0.150
     2.563    78.291     0.150
     2.696    46.791     0.150
     0.085     2.050     0.150
     0.023     1.700     0.150
     0.062     1.979     0.150
     0.078     2.479     0.150
     0.091     2.000     0.150
     0.198     3.060     0.150
     0.196     2.500     0.150
     0.224     4.760     0.150
     0.224     8.379     0.150
     0.310     9.779     0.150
     0.291     5.469     0.150
     0.291     9.078     0.150
     0.296     5.568     0.150
     0.296     9.180     0.150
     0.427     7.939     0.150
     0.427    13.578     0.150
     1.090    19.879     0.150
     1.090    34.879     0.150
     1.164    23.379     0.150
     1.164    39.379     0.150
     2.365    42.379     0.150
     2.544    42.879     0.150
     2.544    76.879     0.150
     2.677    44.879     0.150
     2.677    75.879     0.150
     2.764    85.879     0.150
     0.019     1.465     0.150
     0.026     2.266     0.150
     0.026     3.465     0.150
     0.019     3.164     0.150
     0.055     2.477     0.150
     0.055     3.996     0.150
     0.055     4.395     0.150
     0.082     2.164     0.150
     0.082     3.867     0.150
     0.081     2.625     0.150
     0.081     4.664     0.150
     0.089     3.266     0.150
     0.089     4.766     0.150
     0.167     3.266     0.150
     0.167     5.766     0.150
     0.189     4.457     0.150
     0.189     7.746     0.150
     0.220     4.266     0.150
     0.220     8.266     0.150
     0.231     4.527     0.150
     0.285     5.566     0.150
     0.285     9.367     0.150
     0.295     5.727     0.150
     0.295     9.594     0.150
     0.321     6.254     0.150
     0.321    10.086     0.150
     0.419     8.234     0.150
     1.108    19.266     0.150
     1.108    35.266     0.150
     0.033     1.812     0.150
     0.033     3.413     0.150
     0.030     2.423     0.150
     0.030     4.442     0.150
     0.036     1.913     0.150
     0.036     3.513     0.150
     0.070     2.812     0.150
     0.070     4.913     0.150
     0.095     2.853     0.150
     0.095     5.232     0.150
     0.156     3.013     0.150
     0.156     5.513     0.150
     0.191     3.833     0.150
     0.191     6.612     0.150
     0.245     4.873     0.150
     0.245     8.772     0.150
     0.232     5.203     0.150
     0.232     9.192     0.150
     0.270     5.383     0.150
     0.270     8.652     0.150
     0.056     2.414     0.150
     0.056     3.883     0.150
     0.061     2.625     0.150
     0.061     4.523     0.150
     0.026     1.625     0.150
     0.026     3.223     0.150
     0.069     4.824     0.150
     0.098     2.852     0.150
     0.098     4.812     0.150
     0.137     2.523     0.150
     0.137     4.273     0.150
     0.137     3.453     0.150
     0.137     5.602     0.150
     0.148     3.023     0.150
     0.148     5.523     0.150
     0.183     3.523     0.150
     0.183     5.922     0.150
     0.176     3.523     0.150
     0.176     6.023     0.150
     0.186     3.602     0.150
     0.186     5.984     0.150
     0.248     4.273     0.150
     0.234     4.945     0.150
     0.234     8.473     0.150
     0.275     5.473     0.150
     0.275     8.965     0.150
     0.291     5.754     0.150
     0.291     8.812     0.150
     0.361    11.523     0.150
     0.020     0.754     0.150
     0.020     2.355     0.150
     0.059     1.953     0.150
     0.059     4.004     0.150
     0.059     1.754     0.150
     0.059     3.953     0.150
     0.038     1.855     0.150
     0.063     2.254     0.150
     0.063     4.355     0.150
     0.176     3.754     0.150
     0.172     3.664     0.150
     0.176     5.504     0.150
     0.180     5.754     0.150
     0.172     6.523     0.150
     0.180     3.254     0.150
     0.201     4.395     0.150
     0.211     7.254     0.150
     0.201     7.953     0.150
     0.211     4.254     0.150
     0.216     3.254     0.150
     0.216     6.152     0.150
     0.220     7.504     0.150
     0.261     5.035     0.150
     0.261     8.734     0.150
     0.298     5.543     0.150
     0.298     9.402     0.150
     0.084     2.977     0.150
     0.036     2.078     0.150
     0.036     3.879     0.150
     0.084     5.258     0.150
     0.089     2.578     0.150
     0.089     4.477     0.150
     0.073     2.200     0.150
     0.101     3.199     0.150
     0.101     5.629     0.150
     0.131     2.527     0.150
     0.117     3.477     0.150
     0.117     5.957     0.150
     0.185     4.246     0.150
     0.185     7.188     0.150
     0.192     3.176     0.150
     0.192     5.977     0.150
     0.194     4.098     0.150
     0.194     6.957     0.150
     0.265     5.277     0.150
     0.265     9.027     0.150
     0.232     5.438     0.150
     0.232     9.508     0.150
     0.302     6.016     0.150
     0.302    10.508     0.150
     0.315     6.156     0.150
     0.315    10.406     0.150
     0.375     7.137     0.150
     0.375    11.906     0.150
     1.166    16.400     0.150
     1.203    21.277     0.150
     1.203    37.277     0.150
     2.375    42.277     0.150
     2.375    73.078     0.150
     2.539    75.277     0.150
     2.671    44.277     0.150
     2.671    80.777     0.150
     2.845    46.977     0.150
     2.845    85.078     0.150
     2.772    49.777     0.150
     5.707    85.816     0.150
     5.707   148.828     0.150
    12.020   169.277     0.150
    12.020   297.777     0.150
    12.821   179.316     0.150
    12.821   314.457     0.150
    13.846   193.777     0.150
     1.527    27.578     0.150
     1.527    46.578     0.150
     1.798    32.168     0.150
     2.376    42.277     0.150
     2.376    73.078     0.150
     2.771    45.207     0.150
     2.925    48.277     0.150
     2.925    88.277     0.150
     3.356    62.777     0.150
     3.650    61.879     0.150
     4.301    65.957     0.150
     4.493    68.379     0.150
     4.745    74.777     0.150
     5.146    78.297     0.150
     5.470    77.777     0.150
     5.701    85.738     0.150
     5.707    85.816     0.150
     5.707   148.828     0.150
     5.748    85.438     0.150
     5.953    89.336     0.150
     5.953   152.879     0.150
     5.975    89.879     0.150
     5.975   155.879     0.150
     6.170    91.738     0.150
     6.170   158.039     0.150
     6.160    92.676     0.150
     6.165    91.660     0.150
     6.165   164.535     0.150
     6.526   167.578     0.150
     6.969   102.676     0.150
     7.181   104.059     0.150
     7.181   181.117     0.150
     7.232   108.078     0.150
     7.232   186.078     0.150
     7.840   113.676     0.150
     8.012   117.176     0.150
     8.298   124.582     0.150
     8.352   124.637     0.150
     8.392   125.184     0.150
     8.402   125.809     0.150
     8.405   125.371     0.150
     8.419   125.465     0.150
     8.452   125.676     0.150
     8.457   126.828     0.150
     8.478   126.176     0.150
     8.506   127.262     0.150
     8.523   126.773     0.150
     8.526   126.828     0.150
     8.545   127.078     0.150
     9.551   138.176     0.150
     9.551   239.777     0.150
    10.204   149.578     0.150
    12.176   299.777     0.150
    12.821   177.777     0.150
    12.821   314.777     0.150
    12.821   179.316     0.150
    12.821   314.457     0.150
    12.915   179.277     0.150
    12.915   314.777     0.150
    13.846   193.777     0.150
    21.202   284.777     0.150
    21.343   286.027     0.150
    27.453   346.977     0.150
    46.436   506.379     0.150
    49.460   529.750     0.150
    56.508   582.379     0.150
    57.397   588.176     0.150
    57.406   588.277     0.150
    58.121   591.277     0.150
    72.748   687.227     0.150
    74.965   699.727     0.150
    78.551   720.828     0.150
    12.915   183.227     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165    90.621     0.150
     6.165   160.910     0.150
     6.165   160.910     0.150
    53.437   559.484     0.150
    27.453   345.879     0.150
     0.044     2.305     0.150
     0.044     4.203     0.150
     0.031     1.395     0.150
     0.031     3.094     0.150
     0.053     2.496     0.150
     0.075     2.543     0.150
     0.075     4.836     0.150
     0.177     3.863     0.150
     0.177     6.574     0.150
     0.174     2.645     0.150
     0.174     5.145     0.150
     0.177     3.945     0.150
     0.187     3.395     0.150
     0.187     5.895     0.150
     0.177     6.984     0.150
     0.207     3.195     0.150
     0.207     6.094     0.150
     0.204     3.895     0.150
     0.204     6.895     0.150
     0.247     4.613     0.150
     0.247     8.465     0.150
     0.212     4.613     0.150
     0.212     8.324     0.150
     0.258     6.145     0.150
     0.258     9.395     0.150
     0.282     5.113     0.150
     0.282     9.266     0.150
     0.366     6.895     0.150
     0.366    10.395     0.150
     0.363     6.746     0.150
     0.363    11.336     0.150
     0.037     1.703     0.150
     0.037     3.602     0.150
     0.071     2.203     0.150
     0.071     4.203     0.150
     0.080     2.656     0.150
     0.080     4.852     0.150
     0.085     1.906     0.150
     0.085     4.000     0.150
     0.105     2.859     0.150
     0.105     5.352     0.150
     0.127     2.203     0.150
     0.127     4.703     0.150
     0.125     2.203     0.150
     0.125     6.203     0.150
     0.116     3.109     0.150
     0.116     5.305     0.150
     0.179     3.906     0.150
     0.179     6.703     0.150
     0.175     3.203     0.150
     0.188     3.727     0.150
     0.187     2.805     0.150
     0.187     5.703     0.150
     0.188     6.344     0.150
     0.259     5.203     0.150
     0.259     8.703     0.150
     0.236     5.031     0.150
     0.236     9.133     0.150
     0.299     5.695     0.150
     0.299     9.984     0.150
     0.310     5.781     0.150
     0.310     9.781     0.150
     0.369     6.766     0.150
     0.369    11.555     0.150
     1.160    24.203     0.150
     1.198    21.703     0.150
     2.065    37.703     0.150
     2.065    64.703     0.150
     2.371    31.800     0.150
     2.534    74.703     0.150
     0.028     2.285     0.150
     0.028     4.184     0.150
     0.050     1.984     0.150
     0.050     3.586     0.150
     0.068     1.785     0.150
     0.068     3.086     0.150
     0.087     2.754     0.150
     0.087     5.023     0.150
     0.168     3.785     0.150
     0.168     6.516     0.150
     0.181     2.734     0.150
     0.181     5.484     0.150
     0.203     3.086     0.150
     0.203     5.984     0.150
     0.203     6.484     0.150
     0.209     4.105     0.150
     0.209     6.996     0.150
     0.202     3.984     0.150
     0.202     7.484     0.150
     0.190     4.195     0.150
     0.190     7.516     0.150
     0.248     4.984     0.150
     0.248     8.734     0.150
     0.265     5.016     0.150
     0.265     8.695     0.150
     0.350     6.516     0.150
     0.353     6.484     0.150
     1.122    23.484     0.150
     1.159    20.984     0.150
     1.159    36.984     0.150
     2.002    35.484     0.150
     2.002    60.484     0.150
     2.302    40.984     0.150
     2.546    43.484     0.150
     2.546    75.984     0.150
     2.680    44.484     0.150
     2.680    79.484     0.150
     5.714    87.656     0.150
     0.028     1.652     0.150
     0.028     3.352     0.150
     0.032     2.051     0.150
     0.032     4.250     0.150
     0.054     2.051     0.150
     0.054     4.051     0.150
     0.049     1.852     0.150
     0.049     3.652     0.150
     0.068     1.949     0.150
     0.068     4.051     0.150
     0.104     2.742     0.150
     0.087     2.582     0.150
     0.087     4.750     0.150
     0.167     3.641     0.150
     0.167     6.551     0.150
     0.180     3.051     0.150
     0.180     5.301     0.150
     0.208     3.980     0.150
     0.208     6.852     0.150
     0.202     4.051     0.150
     0.202     7.551     0.150
     0.208     3.879     0.150
     0.208     6.652     0.150
     0.189     4.082     0.150
     0.189     7.160     0.150
     0.201     4.051     0.150
     0.201     6.551     0.150
     0.189     7.262     0.150
     0.265     5.121     0.150
     0.265     8.551     0.150
     0.350     6.352     0.150
     0.350    11.051     0.150
     0.013     1.875     0.150
     0.075     4.703     0.150
     0.013     3.676     0.150
     0.075     2.496     0.150
     0.076     2.074     0.150
     0.076     4.074     0.150
     0.078     1.875     0.150
     0.078     3.273     0.150
     0.049     2.375     0.150
     0.049     4.273     0.150
     0.078     2.676     0.150
     0.078     4.766     0.150
     0.154     2.574     0.150
     0.154     4.824     0.150
     0.142     3.633     0.150
     0.142     6.324     0.150
     0.147     6.074     0.150
     0.147     3.074     0.150
     0.198     3.574     0.150
     0.198     7.574     0.150
     0.210     4.113     0.150
     0.210     7.055     0.150
     0.313     5.895     0.150
     0.313     9.926     0.150
     0.313    10.363     0.150
     0.108     2.842     0.150
     0.065     2.542     0.150
     0.065     4.642     0.150
     0.049     3.072     0.150
     0.049     5.202     0.150
     0.108     5.142     0.150
     0.114     3.481     0.150
     0.114     5.941     0.150
     0.095     2.542     0.150
     0.095     4.742     0.150
     0.184     4.382     0.150
     0.184     7.572     0.150
     0.247     5.352     0.150
     0.247     9.032     0.150
     0.251     5.342     0.150
     0.248     5.572     0.150
     0.255     4.342     0.150
     0.255     8.342     0.150
     0.248     9.481     0.150
     0.251     9.842     0.150
     0.285     5.842     0.150
     0.285    10.842     0.150
     0.291     5.872     0.150
     0.291     9.572     0.150
     0.323     6.382     0.150
     0.323    10.752     0.150
     0.325     5.342     0.150
     0.325     9.592     0.150
     0.423     8.102     0.150
     0.423    13.771     0.150
     0.041     2.566     0.150
     0.041     4.355     0.150
     0.044     1.867     0.150
     0.044     3.467     0.150
     0.083     2.756     0.150
     0.083     4.477     0.150
     0.026     1.967     0.150
     0.026     3.766     0.150
     0.063     2.367     0.150
     0.063     4.266     0.150
     0.165     3.906     0.150
     0.165     6.516     0.150
     0.090     2.855     0.150
     0.090     5.096     0.150
     0.153     2.316     0.150
     0.190     3.467     0.150
     0.190     6.166     0.150
     0.194     3.797     0.150
     0.194     3.916     0.150
     0.194     6.777     0.150
     0.185     4.066     0.150
     0.185     7.566     0.150
     0.194     6.547     0.150
     0.168     3.566     0.150
     0.157     6.176     0.150
     0.168     7.566     0.150
     0.247     5.066     0.150
     0.247     8.566     0.150
     0.281     5.557     0.150
     0.281     8.996     0.150
     0.357     6.367     0.150
     1.136    21.566     0.150
     1.136    37.566     0.150
     1.173    21.066     0.150
     1.173    33.566     0.150
     2.331    42.367     0.150
     2.538    42.566     0.150
     2.538    76.566     0.150
     2.606    44.566     0.150
     2.606    78.666     0.150
     2.671    44.566     0.150
     2.730    50.566     0.150
     2.730    83.566     0.150
     5.706    86.426     0.150
     5.706   150.727     0.150
     1.136    22.066     0.150
     2.332    42.367     0.150
     2.927    51.566     0.150
     2.983    50.967     0.150
     3.503    59.467     0.150
     3.503   102.967     0.150
     3.604    57.166     0.150
     3.604    99.766     0.150
     4.345    67.416     0.150
     4.539    69.596     0.150
     5.190    78.986     0.150
     5.514   140.066     0.150
     5.706    87.137     0.150
     5.706   150.727     0.150
     5.745    87.057     0.150
     5.935    88.367     0.150
     5.935   155.367     0.150
     5.997    90.307     0.150
     6.115    92.066     0.150
     6.119    91.766     0.150
     6.119   162.541     0.150
     6.212    93.057     0.150
     6.569    97.557     0.150
     6.927   102.967     0.150
     6.927   178.967     0.150
     7.339   127.566     0.150
     7.187   106.367     0.150
     8.425   125.895     0.150
     8.438   125.553     0.150
    12.838   314.066     0.150
    21.387   287.166     0.150
    53.392   558.916     0.150
    57.351   588.266     0.150
    57.360   588.166     0.150
    72.794   687.816     0.150
    72.794     5.000     0.150
    75.012   700.316     0.150
    75.012     4.500     0.150
    78.529   719.865     0.150
    78.529     6.301     0.150
     0.023     1.443     0.150
     0.023     3.244     0.150
     0.024     2.232     0.150
     0.046     1.443     0.150
     0.046     3.043     0.150
     0.072     1.543     0.150
     0.072     3.244     0.150
     0.094     2.473     0.150
     0.094     4.244     0.150
     0.094     2.562     0.150
     0.094     4.574     0.150
     0.169     2.943     0.150
     0.169     5.443     0.150
     0.179     3.664     0.150
     0.179     6.232     0.150
     0.192     3.244     0.150
     0.198     3.654     0.150
     0.198     6.184     0.150
     0.192     5.844     0.150
     0.263     8.123     0.150
     0.059     1.500     0.150
     0.011     1.475     0.150
     0.084     1.475     0.150
     0.084     3.275     0.150
     0.171     1.975     0.150
     0.171     4.225     0.150
     0.187     2.975     0.150
     0.187     5.775     0.150
     0.230     4.475     0.150
     0.230     7.975     0.150
     1.160    21.475     0.150
     1.160    38.975     0.150
     1.107    16.900     0.150
     1.144    19.475     0.150
     1.144    35.975     0.150
     2.529    42.475     0.150
     2.529    76.475     0.150
     2.662    33.500     0.150
     5.697    89.275     0.150
     5.697   148.775     0.150
     0.567    11.037     0.150
     0.567    19.037     0.150
     0.916    15.637     0.150
     0.779    16.338     0.150
     1.424    49.037     0.150
     1.756    31.537     0.150
     1.943    36.037     0.150
     2.055    36.037     0.150
     2.581    41.037     0.150
     2.581    73.037     0.150
     3.027    49.438     0.150
     3.062    49.447     0.150
     3.062    91.066     0.150
     2.896    92.037     0.150
     2.964    45.537     0.150
     3.145    50.537     0.150
     3.145    97.537     0.150
     3.402    54.287     0.150
     4.355    66.947     0.150
     4.449    67.637     0.150
     4.651    70.547     0.150
     4.555    70.637     0.150
     4.901    97.037     0.150
     5.396    81.037     0.150
     5.627    84.037     0.150
     5.901    88.057     0.150
     6.098    91.037     0.150
     6.744    99.617     0.150
     7.302   107.357     0.150
     7.344   107.037     0.150
     7.552   110.178     0.150
     7.754   112.297     0.150
     7.955   112.727     0.150
     8.113   117.678     0.150
     8.415   122.637     0.150
     8.779   126.297     0.150
     9.433   135.258     0.150
     9.456   135.098     0.150
    10.498   146.537     0.150
    11.381   162.557     0.150
    13.136   185.928     0.150
    13.595   188.037     0.150
    13.595   331.037     0.150
    13.757   190.537     0.150
    13.757   335.037     0.150
    14.239   194.867     0.150
    14.802   210.037     0.150
    14.802   217.338     0.150
    16.076   225.037     0.150
    19.689   269.037     0.150
    19.689   274.637     0.150
    22.209   296.438     0.150
    22.173   294.037     0.150
    22.768   301.438     0.150
    22.946   302.938     0.150
    26.294   333.537     0.150
    27.782   349.498     0.150
    28.578   354.865     0.150
    32.185   387.748     0.150
    36.744   426.639     0.150
    36.744   569.389     0.150
    37.608   434.139     0.150
    44.991   494.436     0.150
    45.099   495.436     0.150
    45.388   497.537     0.150
    50.015   533.736     0.150
    50.636   538.361     0.150
    50.695   538.537     0.150
    51.967   547.037     0.150
    51.967   547.412     0.150
    53.907   562.377     0.150
    55.940   576.639     0.150
    57.393   585.736     0.150
    57.673   587.936     0.150
    61.273   613.736     0.150
    61.535   615.338     0.150
    65.010   638.787     0.150
    67.175   651.146     0.150
    76.559   708.986     0.150
    77.832   716.037     0.150
    78.169   717.436     0.150
    80.022   727.408     0.150
    83.114   744.877     0.150
   145.637  1178.424     0.150
   152.822  1185.994     0.150
     0.535    11.022     0.150
     2.656    43.022     0.150
     2.769    43.522     0.150
     2.769    51.022     0.150
     2.769    54.022     0.150
     2.769    84.522     0.150
     2.820    48.022     0.150
     2.969    92.022     0.150
     3.103    97.723     0.150
     3.949    61.022     0.150
     3.949   108.022     0.150
     4.142    64.623     0.150
     4.142   113.422     0.150
     4.359    73.922     0.150
     4.738    88.022     0.150
     4.989    73.022     0.150
     5.137    77.022     0.150
     6.754    99.822     0.150
     6.759    99.157     0.150
     6.759   173.933     0.150
     6.759   206.433     0.150
     7.153   177.513     0.150
     7.555   109.822     0.150
     7.825   114.822     0.150
     8.571   125.022     0.150
    10.005   140.522     0.150
    11.990   166.022     0.150
    12.639   176.022     0.150
    12.639   311.022     0.150
    12.751   180.022     0.150
    12.751   176.672     0.150
    24.129   314.723     0.150
    46.973   509.822     0.150
    47.065   510.522     0.150
    49.944   533.223     0.150
    53.983   561.922     0.150
    53.983   561.998     0.150
    62.874   624.725     0.150
    78.695   720.522     0.150
    87.042   763.022     0.150
     0.688    12.936     0.150
     0.688    22.436     0.150
     0.944    17.336     0.150
     1.213    25.336     0.150
     1.213    42.535     0.150
     1.632    31.336     0.150
     1.632    52.336     0.150
     1.861    33.336     0.150
     1.861    58.336     0.150
     2.308    41.836     0.150
     2.308    63.336     0.150
     2.191    39.336     0.150
     2.470    39.836     0.150
     2.470    73.336     0.150
     2.564    41.137     0.150
     2.564    72.887     0.150
     2.381    40.936     0.150
     2.381    72.535     0.150
     2.625    44.365     0.150
     2.915    48.236     0.150
     2.915    83.336     0.150
     2.965    49.166     0.150
     2.965    85.146     0.150
     3.334    94.137     0.150
     3.580   100.336     0.150
     3.922    61.246     0.150
     3.922   105.846     0.150
     4.213    65.186     0.150
     4.993    77.336     0.150
     5.465    83.396     0.150
     5.465   144.076     0.150
     5.661    86.316     0.150
     5.661   149.035     0.150
     5.823    87.535     0.150
     6.065    91.336     0.150
     6.065   159.336     0.150
     6.308    94.336     0.150
     6.308   162.355     0.150
     6.865   176.637     0.150
     6.908   102.156     0.150
     6.908   177.977     0.150
     7.116   105.076     0.150
     7.116   182.137     0.150
     7.754   113.736     0.150
     7.754   191.816     0.150
     7.680   112.695     0.150
     7.680   196.676     0.150
     8.343   120.637     0.150
     8.343   211.615     0.150
     8.709   129.336     0.150
     8.709   222.336     0.150
     8.999   228.297     0.150
     9.025   130.455     0.150
     9.025   227.977     0.150
    10.305   146.336     0.150
    13.034   180.836     0.150
    13.516   187.336     0.150
    14.117   197.535     0.150
    14.825   216.336     0.150
    21.899   292.336     0.150
    22.509   300.986     0.150
    23.414   309.086     0.150
    25.991   332.137     0.150
    36.670   426.236     0.150
    45.383   498.486     0.150
    45.488   499.236     0.150
    45.785   501.535     0.150
    48.132   519.236     0.150
    48.514   522.953     0.150
    52.366   550.637     0.150
    52.366   551.361     0.150
    61.591   616.820     0.150
    65.448   642.785     0.150
    78.270   719.035     0.150
    86.271   759.230     0.150
   146.062  1178.973     0.150
   153.035  1197.246     0.150
     1.071    19.193     0.150
     1.168    21.193     0.150
     1.168    36.693     0.150
     1.262    22.894     0.150
     1.262    43.193     0.150
     2.134    37.193     0.150
     2.134    64.193     0.150
     2.429    43.793     0.150
     2.429    75.793     0.150
     2.651    45.594     0.150
     2.651    76.123     0.150
     2.651    83.243     0.150
     2.835    47.693     0.150
     2.835    89.193     0.150
     3.036    52.483     0.150
     3.036    90.934     0.150
     3.077    51.193     0.150
     3.077    98.193     0.150
     3.408    56.193     0.150
     3.408   100.193     0.150
     4.783   131.193     0.150
     5.493    96.193     0.150
     7.400   107.174     0.150
     7.400   187.943     0.150
    12.985   180.693     0.150
    23.800   313.855     0.150
    36.654   427.653     0.150
    46.431   507.168     0.150
    49.046   527.094     0.150
    49.436   530.981     0.150
    62.543   623.753     0.150
    74.934   700.844     0.150
    78.461   720.943     0.150
     0.617    11.551     0.150
     0.842    26.352     0.150
     1.135    22.752     0.150
     1.135    39.551     0.150
     1.488    28.492     0.150
     1.488    48.941     0.150
     1.538    26.752     0.150
     1.538    47.652     0.150
     1.788    31.352     0.150
     1.788    56.352     0.150
     2.197    38.441     0.150
     2.280    40.252     0.150
     2.280    69.451     0.150
     2.362    40.652     0.150
     2.362    71.051     0.150
     2.382    39.852     0.150
     2.382    69.852     0.150
     2.468    43.621     0.150
     2.468    72.332     0.150
     2.535    43.252     0.150
     2.828    47.201     0.150
     2.828    80.342     0.150
     2.828    82.271     0.150
     3.345    53.352     0.150
     3.522    56.852     0.150
     3.522   110.852     0.150
     4.932    76.701     0.150
     4.932   133.602     0.150
     5.543    84.852     0.150
     5.729    87.111     0.150
     6.388    95.912     0.150
     6.388   167.971     0.150
     6.943   103.451     0.150
     6.943   180.191     0.150
     6.989   104.191     0.150
     6.989   180.752     0.150
     7.195   106.451     0.150
     7.195   185.312     0.150
     7.764   114.572     0.150
     7.764   198.951     0.150
     7.692   111.891     0.150
     7.692   195.391     0.150
     8.422   122.611     0.150
     9.080   131.852     0.150
     9.112   132.291     0.150
    12.948   182.191     0.150
    12.948   318.961     0.150
    13.253   184.852     0.150
    13.467   187.352     0.150
    14.036   195.152     0.150
    14.036   343.352     0.150
    22.584   300.252     0.150
    45.366   499.051     0.150
    45.473   500.152     0.150
    48.520   523.715     0.150
    52.345   552.197     0.150
    61.470   618.062     0.150
    73.976   696.035     0.150
    76.181   708.434     0.150
    78.355   720.418     0.150
    86.334   761.797     0.150
    86.695   763.801     0.150
     0.773    14.992     0.150
     0.773    24.688     0.150
     0.825    15.391     0.150
     0.825    26.391     0.150
     1.070    21.992     0.150
     1.070    37.391     0.150
     1.715    30.391     0.150
     1.715    52.391     0.150
     2.047    34.391     0.150
     2.374    41.992     0.150
     2.374    68.992     0.150
     2.459    74.094     0.150
     2.530    40.891     0.150
     2.530    71.391     0.150
     2.612    46.391     0.150
     2.612    73.391     0.150
     2.977    48.258     0.150
     3.242    50.789     0.150
     3.430    53.891     0.150
     4.731    70.594     0.150
     4.843    73.289     0.150
     4.843   130.289     0.150
     4.848    74.039     0.150
     4.848   128.891     0.150
     5.610    84.859     0.150
     5.610   146.984     0.150
     5.810    86.820     0.150
     5.810   152.781     0.150
     5.685    83.992     0.150
     5.918    86.992     0.150
     6.453    95.844     0.150
     6.453   167.039     0.150
     6.353    92.992     0.150
     7.011   103.000     0.150
     7.011   179.500     0.150
     7.053   103.141     0.150
     7.053   179.883     0.150
     7.261   106.500     0.150
     7.261   183.500     0.150
     7.822   113.961     0.150
     7.822   198.883     0.150
     7.848   113.594     0.150
     7.848   192.773     0.150
     8.488   121.320     0.150
     8.488   212.273     0.150
     8.585   125.391     0.150
     8.585   216.688     0.150
     9.142   131.078     0.150
     9.165   131.281     0.150
     9.165   228.297     0.150
    10.397   147.328     0.150
    11.331   163.188     0.150
    11.975   172.234     0.150
    13.064   180.562     0.150
    13.098   183.391     0.150
    13.305   186.391     0.150
    13.305   325.391     0.150
    13.623   188.891     0.150
    14.188   198.391     0.150
    14.784   206.391     0.150
    16.367   232.391     0.150
    21.960   294.188     0.150
    21.967   292.391     0.150
    22.656   299.852     0.150
    23.330   307.516     0.150
    26.070   331.391     0.150
    37.868   436.312     0.150
    45.236   496.664     0.150
    48.376   521.008     0.150
    50.917   539.844     0.150
    52.218   549.289     0.150
    52.218   549.078     0.150
    52.218     5.539     0.150
    56.082   577.891     0.150
    58.118   591.789     0.150
    59.002   598.391     0.150
    61.822   616.594     0.150
    65.299   640.492     0.150
    74.063   695.172     0.150
    74.063     5.930     0.150
    76.276   707.438     0.150
    76.276     6.953     0.150
    77.853   716.172     0.150
    78.205   717.594     0.150
    86.179   759.086     0.150
     0.997    19.199     0.150
     0.997    32.199     0.150
     1.164    40.211     0.150
     1.500    29.699     0.150
     1.500    48.500     0.150
     1.786    33.309     0.150
     1.786    55.430     0.150
     2.125    38.777     0.150
     2.214    38.348     0.150
     2.073    39.000     0.150
     2.381    41.027     0.150
     2.531    42.320     0.150
     2.565    42.199     0.150
     2.565    48.699     0.150
     2.565    69.699     0.150
     2.565    72.699     0.150
     2.484    42.500     0.150
     2.484    72.199     0.150
     2.727    45.391     0.150
     2.720    45.199     0.150
     2.975    49.320     0.150
     3.051    51.199     0.150
     3.392    53.629     0.150
     3.450    56.199     0.150
     3.450   106.500     0.150
     4.224    66.199     0.150
     4.605    70.598     0.150
     4.605   122.480     0.150
     4.810    74.277     0.150
     4.810   127.461     0.150
     5.448    82.777     0.150
     5.448   141.820     0.150
     5.725    85.969     0.150
     6.006    90.578     0.150
     6.048    91.199     0.150
     6.048   155.438     0.150
     6.256    93.777     0.150
     6.256   160.777     0.150
     6.820   101.480     0.150
     6.820   174.480     0.150
     7.510   108.570     0.150
     7.510   185.590     0.150
     7.483   109.520     0.150
     7.483   189.820     0.150
     8.138   119.000     0.150
     8.138   205.598     0.150
     8.167   118.738     0.150
     8.865   128.199     0.150
     8.865   218.098     0.150
     9.251   136.199     0.150
    10.422   151.199     0.150
    12.307   172.199     0.150
    12.307   301.199     0.150
    12.966   181.449     0.150
    12.966   317.199     0.150
    13.155   182.199     0.150
    19.026   261.398     0.150
    21.305   285.699     0.150
    21.651   290.125     0.150
    23.657   310.773     0.150
    25.338   326.699     0.150
    26.115   333.328     0.150
    27.413   346.910     0.150
    35.729   420.344     0.150
    40.586   460.629     0.150
    46.110   504.000     0.150
    49.148   528.129     0.150
    53.110   556.719     0.150
    54.924   570.410     0.150
    57.076   586.301     0.150
    57.086   586.000     0.150
    57.223   586.398     0.150
    58.811   597.500     0.150
    62.280   621.301     0.150
    73.067   689.059     0.150
    75.289   701.750     0.150
    81.818   739.027     0.150
    85.811   757.938     0.150
    86.556   762.289     0.150
   112.236  1115.898     0.150
   112.913  1119.098     0.150
   153.520  1198.410     0.150
    53.110   557.566     0.150
     0.442     8.096     0.150
     0.697    12.496     0.150
     0.697    22.096     0.150
     1.273    23.496     0.150
     1.425    27.096     0.150
     1.760    32.195     0.150
     1.760    56.395     0.150
     1.949    35.096     0.150
     1.949    60.596     0.150
     3.191    52.695     0.150
     3.191    91.195     0.150
     3.165    50.695     0.150
     3.165    61.195     0.150
     3.165    87.695     0.150
     3.321    54.045     0.150
     3.402    55.096     0.150
     3.402    95.996     0.150
     3.389    55.965     0.150
     3.462    56.195     0.150
     3.517   107.346     0.150
     3.485    57.795     0.150
     3.485   112.395     0.150
     4.036    63.895     0.150
     4.036   109.996     0.150
     3.883   120.996     0.150
     4.134    65.195     0.150
     4.134   131.195     0.150
     4.591    71.096     0.150
     4.591   122.996     0.150
     4.637    71.895     0.150
     4.637   123.996     0.150
     4.465    70.195     0.150
     4.701    68.285     0.150
     4.765    70.195     0.150
     4.650    73.395     0.150
     4.843    74.295     0.150
     4.843   129.496     0.150
     4.740    73.096     0.150
     5.061    77.596     0.150
     5.061   134.795     0.150
     5.416    82.695     0.150
     5.416   143.295     0.150
     6.070    90.895     0.150
     6.237    93.166     0.150
     6.237   162.215     0.150
     6.723   100.686     0.150
     6.723   172.314     0.150
     6.729   100.795     0.150
     6.772   100.996     0.150
     7.200   103.625     0.150
     7.200   181.885     0.150
     7.077   104.695     0.150
     7.259   107.895     0.150
     7.264   107.996     0.150
     7.264   189.746     0.150
     7.264   228.170     0.150
     7.713   112.564     0.150
     8.079   118.195     0.150
     8.338   122.195     0.150
     8.338   215.195     0.150
     9.199   136.195     0.150
     9.199   233.996     0.150
    10.312   150.695     0.150
    10.312   261.695     0.150
    10.913   154.695     0.150
    11.997   168.355     0.150
    12.380   303.996     0.150
    12.558   175.195     0.150
    12.558   307.195     0.150
    12.863   178.695     0.150
    12.863   316.195     0.150
    13.824   194.195     0.150
    15.010   219.496     0.150
    19.776   270.195     0.150
    20.236   276.213     0.150
    20.225   275.465     0.150
    20.847   281.635     0.150
    21.253   286.195     0.150
    21.253   520.195     0.150
    24.372   318.195     0.150
    24.341   318.666     0.150
    25.003   323.195     0.150
    26.648   339.496     0.150
    27.128   344.895     0.150
    30.725   376.195     0.150
    36.223   423.195     0.150
    36.223     5.301     0.150
    39.756   453.746     0.150
    47.369   514.795     0.150
    47.455   515.496     0.150
    47.799   517.895     0.150
    49.876   533.195     0.150
    50.272   537.283     0.150
    50.272   537.105     0.150
    53.295   559.846     0.150
    54.391   566.895     0.150
    54.391   567.371     0.150
    62.535   623.395     0.150
    63.347   629.764     0.150
    71.660   681.330     0.150
    73.891   694.496     0.150
    78.674   721.145     0.150
    78.874   722.320     0.150
   120.963  1133.795     0.150
   148.059  1186.666     0.150
   148.297  1188.307     0.150
     0.626    11.438     0.150
     0.626    20.734     0.150
     1.220    42.281     0.150
     1.718    32.633     0.150
     2.625    44.836     0.150
     2.686    46.297     0.150
     2.793    47.234     0.150
     2.793    79.234     0.150
     2.995    50.438     0.150
     3.342    52.742     0.150
     3.342    91.453     0.150
     3.619    58.461     0.150
     3.684    58.836     0.150
     3.684   102.531     0.150
     3.875    61.336     0.150
     3.875   107.836     0.150
     3.975    63.234     0.150
     4.266    67.234     0.150
     4.266   119.234     0.150
     4.530    70.031     0.150
     4.530   121.438     0.150
     4.384    66.438     0.150
     4.978    87.734     0.150
     5.083    77.133     0.150
     5.083   134.633     0.150
     5.133    77.836     0.150
     5.133   136.133     0.150
     5.336    80.438     0.150
     5.336   140.234     0.150
     5.560    83.336     0.150
     5.560   146.531     0.150
     5.920    88.438     0.150
     5.920   154.023     0.150
     6.564    96.938     0.150
     6.564   169.031     0.150
     6.779   100.633     0.150
     6.783   100.711     0.150
     7.161   102.484     0.150
     7.161   180.211     0.150
     7.226   106.531     0.150
     7.226   185.133     0.150
     7.272   107.531     0.150
     7.272   186.031     0.150
     7.582   111.531     0.150
     7.851   115.836     0.150
     9.688   138.234     0.150
     9.675   142.031     0.150
    10.015   146.438     0.150
    11.413   160.531     0.150
    11.413   281.031     0.150
    11.996   168.562     0.150
    11.996   295.211     0.150
    12.635   310.336     0.150
    12.641   176.234     0.150
    12.641   310.234     0.150
    13.551   192.766     0.150
    16.817   234.188     0.150
    16.817   416.031     0.150
    20.724   280.734     0.150
    20.675   279.555     0.150
    24.127   316.133     0.150
    24.787   321.234     0.150
    25.456   327.016     0.150
    46.989   511.234     0.150
    49.564   530.531     0.150
    49.956   533.773     0.150
    54.001   563.570     0.150
    58.012   593.336     0.150
    58.022   593.438     0.150
    62.901   624.805     0.150
    72.131   683.742     0.150
    78.688   721.836     0.150
    78.831   722.062     0.150
    87.041   764.031     0.150
    90.786   782.062     0.150
     0.609    10.578     0.150
     0.609    18.977     0.150
     0.950    17.977     0.150
     0.950    29.977     0.150
     1.239    25.777     0.150
     1.239    45.375     0.150
     1.469    28.797     0.150
     1.469    48.215     0.150
     2.187    38.957     0.150
     2.187    65.945     0.150
     2.181    38.777     0.150
     2.181    65.578     0.150
     2.219    38.977     0.150
     2.265    39.477     0.150
     2.265    67.676     0.150
     2.394    39.977     0.150
     2.394    68.977     0.150
     2.531    44.977     0.150
     2.531    79.977     0.150
     2.635    81.578     0.150
     2.839    49.477     0.150
     3.153    50.125     0.150
     3.153    59.328     0.150
     3.153    86.375     0.150
     3.537    54.656     0.150
     3.537    94.746     0.150
     3.537   112.855     0.150
     3.678    68.496     0.150
     3.678   113.238     0.150
     3.620    58.977     0.150
     3.620   101.977     0.150
     5.032    78.172     0.150
     5.032   135.496     0.150
     5.032   156.840     0.150
    16.165   400.004     0.150
    48.583   523.219     0.150
    73.876   693.766     0.150
    86.350   760.320     0.150
     0.610    11.465     0.150
     0.610    20.965     0.150
     2.277    36.965     0.150
     2.277    65.664     0.150
     2.599    45.965     0.150
     3.094    50.074     0.150
     3.253    50.465     0.150
     3.253    60.465     0.150
     3.253    88.965     0.150
     3.409    52.586     0.150
     3.409    92.137     0.150
     3.322    61.375     0.150
     3.476    64.344     0.150
     3.551    55.453     0.150
     3.551    95.023     0.150
     3.524    56.766     0.150
     3.524   111.566     0.150
     3.803    68.004     0.150
     3.927   121.566     0.150
     4.737    83.965     0.150
     4.635    70.094     0.150
     4.635   122.355     0.150
     4.503    68.965     0.150
     4.503   138.965     0.150
     4.897   150.164     0.150
     6.327    92.203     0.150
     6.327   160.645     0.150
     6.783    98.543     0.150
     6.783   172.195     0.150
     7.279   102.934     0.150
     7.279   181.645     0.150
     7.128   104.363     0.150
     7.291   107.863     0.150
     8.125   118.164     0.150
     8.125   208.164     0.150
     8.373   121.863     0.150
     8.373   213.863     0.150
     9.126   133.086     0.150
     9.126   235.414     0.150
    10.865   153.465     0.150
    12.624   173.965     0.150
    12.947   181.965     0.150
    12.947   514.965     0.150
    16.865   237.664     0.150
    20.201   274.863     0.150
    20.797   279.965     0.150
    22.560   300.406     0.150
    24.157   314.344     0.150
    24.518   318.387     0.150
    27.040   343.043     0.150
    39.448   449.395     0.150
    39.411   449.285     0.150
    47.361   513.215     0.150
    54.386   564.844     0.150
    58.506   595.664     0.150
    58.515   595.664     0.150
    61.040   612.523     0.150
    64.254   633.664     0.150
    71.635   679.727     0.150
    73.871   692.613     0.150
    78.250   718.695     0.150
    78.599   720.016     0.150
    78.805   720.586     0.150
    80.315   729.355     0.150
    87.067   763.406     0.150
   120.903  1131.293     0.150
     0.547     9.930     0.150
     0.845    15.430     0.150
     1.168    23.029     0.150
     1.168    36.529     0.150
     1.746    32.430     0.150
     1.746    55.830     0.150
     1.950    36.330     0.150
     1.950    60.730     0.150
     2.175    40.230     0.150
     2.175    66.830     0.150
     2.672    45.629     0.150
     2.672    81.000     0.150
     2.699    81.879     0.150
     2.806    48.520     0.150
     2.840    45.430     0.150
     2.840    53.930     0.150
     2.840    82.930     0.150
     3.012    51.869     0.150
     3.007    51.029     0.150
     3.007    97.230     0.150
     3.052    53.811     0.150
     3.173    55.510     0.150
     3.173    93.930     0.150
     3.240    52.230     0.150
     3.240    91.330     0.150
     3.667    55.990     0.150
     3.670    58.629     0.150
     3.868    60.930     0.150
     3.987    63.430     0.150
     4.220    64.250     0.150
     4.220   112.459     0.150
     4.272    68.430     0.150
     4.515    69.529     0.150
     4.515   121.730     0.150
     5.001    75.430     0.150
     5.070    76.830     0.150
     5.070   135.029     0.150
     5.117    77.529     0.150
     5.117   135.730     0.150
     5.322    79.930     0.150
     5.322   140.129     0.150
     5.542    83.330     0.150
     5.542   146.029     0.150
     5.897    88.430     0.150
     5.897   154.730     0.150
     6.549    96.629     0.150
     6.549   168.830     0.150
     6.597    97.230     0.150
     6.597   171.230     0.150
     6.787   100.930     0.150
     6.886   101.359     0.150
     6.886   176.459     0.150
     7.205   103.850     0.150
     7.205   182.240     0.150
     7.210   106.029     0.150
     7.210   185.330     0.150
     7.599   111.529     0.150
     9.641   140.930     0.150
    11.393   160.430     0.150
    11.393   281.430     0.150
    12.039   167.430     0.150
    12.661   176.230     0.150
    12.680   175.430     0.150
    12.680   175.930     0.150
    12.810   177.430     0.150
    12.810   178.680     0.150
    12.933   180.619     0.150
    13.799   191.330     0.150
    13.799   336.029     0.150
    14.999   211.629     0.150
    14.999   219.129     0.150
    14.999   377.330     0.150
    16.778   231.379     0.150
    18.686   256.930     0.150
    18.686   262.830     0.150
    18.686   265.529     0.150
    20.440   277.330     0.150
    20.641   277.820     0.150
    20.692   280.330     0.150
    20.692   285.230     0.150
    20.692   289.430     0.150
    20.692   507.029     0.150
    20.713   279.457     0.150
    20.713   530.279     0.150
    20.792   281.430     0.150
    20.792   290.430     0.150
    20.792   294.430     0.150
    20.792   520.430     0.150
    20.792   538.430     0.150
    22.696   300.430     0.150
    23.694   312.330     0.150
    24.246   316.020     0.150
    24.246   316.430     0.150
    24.559   318.529     0.150
    24.745   320.730     0.150
    25.418   327.260     0.150
    26.489   339.930     0.150
    26.576   338.629     0.150
    27.286   345.400     0.150
    27.773   348.930     0.150
    31.002   378.609     0.150
    31.010   378.830     0.150
    33.177   396.830     0.150
    33.177   715.430     0.150
    35.539   417.570     0.150
    36.288   423.230     0.150
    36.870   428.830     0.150
    36.870     5.000     0.150
    38.893   445.709     0.150
    39.692   452.029     0.150
    39.692   541.430     0.150
    41.026   464.629     0.150
    41.343   464.230     0.150
    41.343   560.330     0.150
    41.343   581.529     0.150
    41.343   812.330     0.150
    41.343   838.129     0.150
    41.343   854.029     0.150
    44.610   493.410     0.150
    45.212   494.230     0.150
    46.977   510.680     0.150
    48.400   519.699     0.150
    49.936   533.520     0.150
    50.911   539.920     0.150
    52.721   554.150     0.150
    52.839   554.869     0.150
    53.990   562.830     0.150
    53.990   563.230     0.150
    54.903   569.879     0.150
    54.903   570.430     0.150
    55.445   575.311     0.150
    57.803   590.730     0.150
    58.018   593.029     0.150
    58.027   593.029     0.150
    58.411   595.430     0.150
    58.561   596.330     0.150
    58.809   598.129     0.150
    59.750   604.129     0.150
    59.881   604.930     0.150
    60.045   605.930     0.150
    60.930   611.930     0.150
    61.145   613.830     0.150
    61.373   615.730     0.150
    61.893   618.430     0.150
    62.082   619.529     0.150
    62.276   621.730     0.150
    62.419   621.730     0.150
    62.424   621.930     0.150
    63.547   629.730     0.150
    63.983   632.430     0.150
    78.297   718.609     0.150
    78.643   720.430     0.150
    78.789   720.850     0.150
    78.789   721.504     0.150
    78.843   723.039     0.150
    81.168   734.199     0.150
    87.001   763.029     0.150
    87.001   763.525     0.150
    88.304   770.629     0.150
   120.812  1131.930     0.150
     0.486     9.497     0.150
     0.486    16.597     0.150
     0.677    13.507     0.150
     0.677    23.197     0.150
     0.850    15.197     0.150
     0.850    15.677     0.150
     1.083    22.197     0.150
     1.083    36.197     0.150
     1.164    19.397     0.150
     1.164    21.397     0.150
     1.867    31.397     0.150
     1.867    54.097     0.150
     1.915    32.967     0.150
     1.969    34.897     0.150
     2.312    38.557     0.150
     2.312    66.907     0.150
     2.513    42.897     0.150
     2.513    73.897     0.150
     2.414    73.097     0.150
     2.456    41.597     0.150
     2.555    41.117     0.150
     2.885    45.367     0.150
     2.885    81.157     0.150
     2.885    89.227     0.150
     3.310    51.517     0.150
     3.310    88.707     0.150
     4.781    71.207     0.150
     4.781   123.447     0.150
     7.265   181.347     0.150
    13.745   192.650     0.150
    13.745   336.722     0.150
    16.646   230.274     0.150
    16.646   229.777     0.150
    45.446   498.407     0.150
    48.710   523.657     0.150
    52.399   550.487     0.150
    86.785   762.397     0.150
     0.209     4.798     0.150
     0.209     8.768     0.150
     1.118    20.008     0.150
     1.118    35.607     0.150
     1.929    34.538     0.150
     2.245    38.508     0.150
     2.245    66.897     0.150
     2.214    68.008     0.150
     2.444    42.758     0.150
     2.444    74.918     0.150
     2.627    40.808     0.150
     2.627    70.808     0.150
     2.627    45.008     0.150
     2.627    78.107     0.150
     2.798    45.978     0.150
     2.798    78.857     0.150
     2.828    46.327     0.150
     2.828    77.607     0.150
     2.828    88.218     0.150
     3.028    49.067     0.150
     3.028    85.617     0.150
     3.028    93.378     0.150
     3.028    93.657     0.150
     3.193    51.808     0.150
     3.459    54.407     0.150
     3.459    95.058     0.150
     3.589    57.008     0.150
     4.047    61.708     0.150
     4.465    68.107     0.150
     4.465   119.508     0.150
     4.674    70.407     0.150
     5.307    79.208     0.150
     5.307   138.808     0.150
     5.793    87.277     0.150
     5.793   151.338     0.150
     5.865    86.508     0.150
     5.865   151.508     0.150
     5.907    87.308     0.150
     5.907   153.607     0.150
     5.846    86.808     0.150
     5.983    89.607     0.150
     5.983   156.607     0.150
     6.115    89.907     0.150
     6.115   158.308     0.150
     6.319    93.607     0.150
     6.319   163.907     0.150
     6.678    98.308     0.150
     6.678   171.407     0.150
     6.823    99.208     0.150
     7.063   102.308     0.150
     7.404   106.628     0.150
     7.404   185.848     0.150
     7.342   106.208     0.150
     7.499   106.438     0.150
     7.499   186.468     0.150
     7.499   187.928     0.150
     7.471   109.508     0.150
     7.897   114.907     0.150
     7.997   115.808     0.150
     7.997   202.907     0.150
     8.783   124.208     0.150
     8.783   220.508     0.150
     9.330   134.808     0.150
     9.330   235.308     0.150
    10.048   142.308     0.150
    10.048   251.308     0.150
    10.284   147.308     0.150
    10.284   148.107     0.150
    10.894   156.008     0.150
    11.793   166.718     0.150
    11.905   172.788     0.150
    11.935   169.598     0.150
    12.165   169.308     0.150
    12.165   296.808     0.150
    12.363   171.308     0.150
    12.251   173.317     0.150
    12.385   175.588     0.150
    12.553   178.928     0.150
    12.641   178.697     0.150
    12.674   181.048     0.150
    12.981   179.808     0.150
    13.039   182.768     0.150
    13.039   322.688     0.150
    12.851   182.737     0.150
    13.119   180.808     0.150
    13.119   319.808     0.150
    13.119   322.808     0.150
    13.235   188.298     0.150
    14.014   195.708     0.150
    14.014   341.708     0.150
    14.341   199.258     0.150
    14.341   348.889     0.150
    14.341   199.208     0.150
    14.795   208.808     0.150
    15.589   216.388     0.150
    15.589   379.538     0.150
    15.837   227.498     0.150
    16.356   227.056     0.150
    16.356   227.038     0.150
    16.356   401.378     0.150
    18.935   259.808     0.150
    20.125   272.058     0.150
    20.125   272.308     0.150
    21.004   282.808     0.150
    21.004   515.607     0.150
    21.194   283.808     0.150
    21.329   284.808     0.150
    21.396   286.607     0.150
    21.511   287.907     0.150
    22.647   299.808     0.150
    22.958   303.008     0.150
    23.361   308.013     0.150
    23.414   308.308     0.150
    23.414   558.808     0.150
    23.595   309.308     0.150
    23.932   312.538     0.150
    23.932   312.808     0.150
    24.352   317.808     0.150
    24.352   574.808     0.150
    24.413   579.507     0.150
    25.218   324.308     0.150
    25.732   329.808     0.150
    25.985   331.748     0.150
    26.472   336.907     0.150
    26.699   338.808     0.150
    26.781   340.107     0.150
    27.350   345.237     0.150
    27.584   346.428     0.150
    27.584   347.588     0.150
    27.606   346.708     0.150
    27.606   347.958     0.150
    27.787   348.048     0.150
    27.703   348.407     0.150
    27.951   349.107     0.150
    27.951   350.208     0.150
    29.613   365.248     0.150
    29.670   364.708     0.150
    29.670   364.107     0.150
    29.906   369.308     0.150
    31.331   379.354     0.150
    31.794   384.098     0.150
    33.684   402.808     0.150
    35.658   417.588     0.150
    35.658   418.077     0.150
    36.073   418.907     0.150
    36.187   420.508     0.150
    36.187   564.808     0.150
    37.070   429.107     0.150
    38.568   441.808     0.150
    38.587   439.907     0.150
    38.909   444.938     0.150
    38.909   444.708     0.150
    41.007   463.407     0.150
    41.588   468.518     0.150
    43.371   481.508     0.150
    46.219   503.883     0.150
    46.315   504.308     0.150
    48.849   523.407     0.150
    48.904   523.487     0.150
    49.238   527.570     0.150
    50.243   535.607     0.150
    50.248   535.607     0.150
    50.248     6.601     0.150
    50.930   541.103     0.150
    50.951   540.808     0.150
    51.071   539.907     0.150
    51.403   543.907     0.150
    51.687   546.407     0.150
    51.736   546.407     0.150
    51.746   546.208     0.150
    52.033   548.508     0.150
    52.033   548.521     0.150
    52.090   548.907     0.150
    52.303   550.308     0.150
    52.447   551.407     0.150
    52.520   551.987     0.150
    52.731   555.008     0.150
    53.144   556.958     0.150
    53.226   557.808     0.150
    53.223   556.407     0.150
    53.223   556.458     0.150
    53.266   557.768     0.150
    53.375   557.538     0.150
    53.570   560.407     0.150
    53.570   560.407     0.150
    53.581   559.308     0.150
    53.612   559.308     0.150
    53.776   561.708     0.150
    53.876   561.208     0.150
    53.900   562.508     0.150
    53.930   561.607     0.150
    53.940   563.438     0.150
    54.034   564.487     0.150
    54.146   565.237     0.150
    54.762   568.008     0.150
    54.801   568.607     0.150
    54.840   568.708     0.150
    54.819   568.564     0.150
    54.878   568.907     0.150
    54.878   688.208     0.150
    54.878  1156.007     0.150
    55.026   570.008     0.150
    55.135   570.708     0.150
    55.286   572.407     0.150
    55.555   573.107     0.150
    55.635   574.208     0.150
    55.651   574.708     0.150
    55.752   574.808     0.150
    55.810   575.708     0.150
    55.920   576.308     0.150
    56.015   577.108     0.150
    56.221   578.208     0.150
    56.315   579.308     0.150
    56.389   579.907     0.150
    56.438   580.507     0.150
    56.645   582.308     0.150
    56.665   582.208     0.150
    56.697   581.608     0.150
    56.815   583.308     0.150
    56.818   583.208     0.150
    56.905   583.808     0.150
    56.930   584.308     0.150
    56.996   584.907     0.150
    56.998   583.808     0.150
    57.114   585.308     0.150
    57.211   586.108     0.150
    57.220   586.108     0.150
    57.333   587.108     0.150
    57.354   587.087     0.150
    57.358   586.208     0.150
    57.608   588.708     0.150
    57.702   588.507     0.150
    57.756   589.407     0.150
    57.851   589.608     0.150
    58.005   591.308     0.150
    58.362   593.308     0.150
    58.786   596.608     0.150
    58.794   595.907     0.150
    58.944   597.308     0.150
    59.075   598.208     0.150
    59.238   599.308     0.150
    59.541   602.108     0.150
    59.632   602.108     0.150
    60.124   605.907     0.150
    60.566   609.108     0.150
    60.842   611.208     0.150
    60.880   610.608     0.150
    60.971   611.847     0.150
    60.971   611.308     0.150
    61.089   611.808     0.150
    61.277   613.007     0.150
    61.350   613.407     0.150
    61.469   615.208     0.150
    61.615   615.308     0.150
    61.618   615.407     0.150
    62.258   620.638     0.150
    62.285   620.208     0.150
    62.290   620.708     0.150
    62.550   622.677     0.150
    62.743   623.208     0.150
    62.914   624.837     0.150
    62.955   625.308     0.150
    63.179   625.907     0.150
    63.230   626.007     0.150
    63.252   627.608     0.150
    63.355   627.308     0.150
    63.683   630.968     0.150
    64.295   635.007     0.150
    64.410   635.907     0.150
    64.673   636.897     0.150
    65.038   640.048     0.150
    65.742   644.308     0.150
    66.049   645.868     0.150
    66.114   646.417     0.150
    66.233   647.118     0.150
    66.438   648.128     0.150
    66.457   648.247     0.150
    66.651   649.628     0.150
    66.773   649.308     0.150
    66.852   650.688     0.150
    67.015   651.958     0.150
    67.289   653.417     0.150
    67.431   654.358     0.150
    67.498   654.567     0.150
    67.700   656.438     0.150
    68.052   657.997     0.150
    68.530   661.647     0.150
    68.726   662.907     0.150
    68.852   663.708     0.150
    68.865   662.917     0.150
    68.860   664.228     0.150
    68.893   664.108     0.150
    69.115   664.817     0.150
    69.642   668.708     0.150
    69.786   669.507     0.150
    69.798   668.987     0.150
    69.820   669.407     0.150
    70.033   671.308     0.150
    70.462   672.907     0.150
    72.932   687.642     0.150
    72.933   686.808     0.150
    72.933   687.688     0.150
    72.940   687.507     0.150
    75.156   700.458     0.150
    78.033   716.407     0.150
    78.376   717.657     0.150
    78.376   893.058     0.150
    78.437   718.468     0.150
    78.437   718.683     0.150
    78.595   719.938     0.150
    79.748   725.997     0.150
    80.872   731.817     0.150
    81.678   737.208     0.150
    81.546   735.747     0.150
    81.695   737.407     0.150
    81.794   737.808     0.150
    81.818   737.778     0.150
    82.009   738.907     0.150
    85.680   756.608     0.150
    85.680   756.083     0.150
    86.515   760.028     0.150
    86.583   760.503     0.150
    87.992   768.247     0.150
    87.992   768.683     0.150
    90.091   778.327     0.150
   147.058  1181.583     0.150
    78.376   719.372     0.150
    16.356   228.708     0.150
    53.223   557.289     0.150
    53.223   557.289     0.150
    48.904   524.830     0.150
    27.350   343.986     0.150
     0.269     5.371     0.150
     0.269     9.012     0.150
     1.055    20.461     0.150
     1.055    34.859     0.150
     1.311    22.762     0.150
     1.311    39.961     0.150
     1.684    29.461     0.150
     2.012    33.660     0.150
     2.012    60.461     0.150
     2.181    39.980     0.150
     2.181    65.910     0.150
     2.642    43.359     0.150
     2.572    41.461     0.150
     2.572    75.461     0.150
     2.576    44.461     0.150
     2.576    80.461     0.150
     2.785    45.359     0.150
     2.741    45.812     0.150
     2.741    80.199     0.150
     2.774    81.723     0.150
     3.001    49.160     0.150
     3.001    56.762     0.150
     2.975    49.520     0.150
     2.975    84.160     0.150
     3.403    54.520     0.150
     3.403    95.152     0.150
     3.427    55.461     0.150
     3.507    65.602     0.150
     3.507   106.160     0.150
     3.547    57.461     0.150
     3.547   109.562     0.150
     3.892   122.781     0.150
     4.510    69.961     0.150
     4.510   120.859     0.150
     4.713    72.859     0.150
     4.713   126.160     0.150
     5.353    80.961     0.150
     5.353   139.461     0.150
     5.737    86.941     0.150
     5.737   148.762     0.150
     5.910    88.461     0.150
     5.910   153.660     0.150
     5.792    87.160     0.150
     5.953    88.859     0.150
     5.953   153.859     0.150
     5.942    89.461     0.150
     6.161    91.859     0.150
     6.161   160.461     0.150
     6.368    94.359     0.150
     6.368   165.262     0.150
     6.726    99.562     0.150
     6.726   173.359     0.150
     6.773    99.461     0.150
     7.019   102.660     0.150
     7.019   182.660     0.150
     7.388   107.859     0.150
     7.388   188.762     0.150
     7.417   108.961     0.150
     7.468   109.660     0.150
     8.044   117.359     0.150
     8.044   204.562     0.150
     8.784   124.660     0.150
     8.784   218.160     0.150
    10.344   150.242     0.150
    10.628   149.961     0.150
    12.215   169.961     0.150
    12.215   297.461     0.150
    12.333   171.461     0.150
    12.940   181.461     0.150
    12.940   318.461     0.150
    13.098   181.961     0.150
    13.098   319.461     0.150
    14.329   199.910     0.150
    14.836   215.262     0.150
    16.382   228.285     0.150
    16.382   227.609     0.150
    18.995   261.461     0.150
    18.995   266.961     0.150
    20.141   273.840     0.150
    21.257   285.461     0.150
    21.555   289.160     0.150
    22.961   303.434     0.150
    23.364   308.945     0.150
    23.417   309.961     0.150
    23.595   311.262     0.150
    23.595   310.406     0.150
    26.749   338.961     0.150
    27.405   346.262     0.150
    31.765   387.461     0.150
    43.765   486.441     0.150
    46.202   503.762     0.150
    48.940   524.461     0.150
    49.232   528.598     0.150
    51.929   547.980     0.150
    53.203   557.020     0.150
    72.970   688.219     0.150
    75.192   701.410     0.150
    78.413   718.410     0.150
    86.607   761.105     0.150
    16.382   228.945     0.150
     0.766    23.016     0.150
     0.860    15.320     0.150
     2.030    34.719     0.150
     2.030    61.820     0.150
     2.762    48.039     0.150
     2.906    47.578     0.150
     2.906    82.969     0.150
     3.212    60.617     0.150
     3.183    50.617     0.150
     3.183    89.414     0.150
     3.385    59.375     0.150
     3.548    61.258     0.150
     3.548   110.156     0.150
     3.694    67.500     0.150
     3.694   108.469     0.150
     4.040   125.039     0.150
     4.158    64.617     0.150
     4.158   114.617     0.150
     4.400    69.617     0.150
     4.400   131.617     0.150
     4.536    68.820     0.150
     4.536   132.719     0.150
     5.127    78.117     0.150
     7.116   104.258     0.150
     7.116   181.875     0.150
     7.519   108.477     0.150
     7.519   189.688     0.150
     9.339   136.688     0.150
    11.095   158.508     0.150
    11.095   275.648     0.150
    12.937   179.617     0.150
    16.532   230.484     0.150
    20.562   281.398     0.150
    20.562   278.219     0.150
    23.833   312.914     0.150
    23.914   314.664     0.150
    24.122   315.117     0.150
    46.951   510.891     0.150
     0.677    11.797     0.150
     0.677    20.961     0.150
     1.109    20.969     0.150
     1.109    21.969     0.150
     1.207    23.672     0.150
     1.207    37.969     0.150
     1.995    35.969     0.150
     2.763    47.945     0.150
     2.926    48.070     0.150
     3.006    50.969     0.150
     3.117    52.242     0.150
     3.352    52.469     0.150
     3.352    90.969     0.150
     3.537    54.297     0.150
     3.548    58.250     0.150
     3.769    59.570     0.150
     4.053    63.867     0.150
     4.053   111.766     0.150
     4.173    66.969     0.150
     4.321    68.172     0.150
     4.595    70.570     0.150
     4.595   123.367     0.150
     4.717   122.391     0.150
     5.162    78.367     0.150
     5.162   136.867     0.150
     5.181    78.570     0.150
     5.181   136.070     0.150
     5.401    81.867     0.150
     5.401   141.672     0.150
     5.486    82.469     0.150
     5.928    88.867     0.150
     5.928   153.766     0.150
     6.510    96.312     0.150
     6.510   169.359     0.150
     6.678    99.766     0.150
     7.622   111.172     0.150
     7.830   113.969     0.150
     7.830   193.898     0.150
     7.803   114.867     0.150
     7.803   201.867     0.150
     8.646   126.766     0.150
     8.746   127.266     0.150
     9.072   130.250     0.150
     9.410   137.570     0.150
     9.410   136.797     0.150
     9.031   133.266     0.150
     9.031   232.047     0.150
    11.384   277.969     0.150
    11.438   283.719     0.150
    11.564   163.969     0.150
    13.165   184.969     0.150
    13.165   320.672     0.150
    13.282   322.969     0.150
    13.434   189.969     0.150
    14.374   203.570     0.150
    14.374   362.766     0.150
    14.374   376.969     0.150
    14.684   204.391     0.150
    15.929   221.961     0.150
    15.929   391.328     0.150
    16.171   224.188     0.150
    16.171   396.508     0.150
    16.183   231.375     0.150
    16.183   224.594     0.150
    20.348   275.969     0.150
    20.796   280.977     0.150
    20.796   281.672     0.150
    23.088   306.094     0.150
    23.481   308.070     0.150
    23.487   309.844     0.150
    23.555   311.039     0.150
    23.765   312.375     0.150
    24.058   315.648     0.150
    24.258   316.266     0.150
    26.130   334.570     0.150
    34.926   411.867     0.150
    35.140   415.336     0.150
    37.789   435.766     0.150
    37.789   782.672     0.150
    44.473   492.766     0.150
    44.785   493.367     0.150
    46.620   508.219     0.150
    49.493   530.453     0.150
    51.731   548.883     0.150
    53.650   560.367     0.150
    72.276   684.375     0.150
    72.277   684.586     0.150
    72.285   684.266     0.150
    74.533   697.672     0.150
    78.019   716.672     0.150
    85.074   754.141     0.150
   120.220  1130.445     0.150
   147.863  1188.070     0.150
     0.388     7.406     0.150
     0.388    12.879     0.150
     0.388    13.527     0.150
     0.956    17.566     0.150
     0.956    30.949     0.150
     2.085    38.027     0.150
     2.085    65.438     0.150
     2.451    45.246     0.150
     2.531    70.348     0.150
     2.736    45.559     0.150
     2.822    52.770     0.150
     2.943    47.898     0.150
     2.943    83.559     0.150
     2.943    92.977     0.150
     3.305    52.348     0.150
     3.305    89.348     0.150
     3.358    53.328     0.150
     3.358    93.770     0.150
     3.836    59.219     0.150
     3.836   104.957     0.150
     5.691    82.348     0.150
     7.492   188.758     0.150
    14.233   200.355     0.150
    14.233   350.473     0.150
    14.233   199.246     0.150
    14.233   350.449     0.150
    16.347   229.199     0.150
    16.347   228.473     0.150
    16.347   402.148     0.150
    21.680   289.777     0.150
    21.680   290.246     0.150
    23.288   307.359     0.150
    23.341   307.148     0.150
    23.341   308.934     0.150
    23.673   311.621     0.150
    23.862   313.246     0.150
    23.862   312.887     0.150
    46.098   503.746     0.150
    49.142   527.422     0.150
    51.878   548.012     0.150
    53.097   556.328     0.150
    73.093   688.832     0.150
    75.312   701.535     0.150
    78.401   718.996     0.150
     0.257     5.464     0.150
     1.375    23.904     0.150
     1.375    41.904     0.150
     1.472    25.504     0.150
     1.472    44.204     0.150
     1.883    35.854     0.150
     2.157    40.204     0.150
     2.157    66.004     0.150
     2.577    78.604     0.150
     2.846    76.144     0.150
     2.884    80.704     0.150
     2.884    84.114     0.150
     3.510   101.734     0.150
     3.510   108.304     0.150
     3.626    96.684     0.150
     3.994   115.704     0.150
    14.247   197.954     0.150
    14.247   347.792     0.150
    16.265   228.226     0.150
    16.265   225.479     0.150
    16.265   398.833     0.150
    20.030   272.344     0.150
    23.264   305.266     0.150
    23.835   312.523     0.150
    46.128   501.729     0.150
    49.143   526.470     0.150
    73.005   687.013     0.150
     0.736    23.586     0.150
     0.853    16.238     0.150
     1.602    29.488     0.150
     1.991    34.336     0.150
     1.991    61.438     0.150
     2.869    51.969     0.150
     3.083    50.426     0.150
     3.148    52.039     0.150
     3.148    58.039     0.150
     3.177    49.738     0.150
     3.177    89.438     0.150
     3.351    52.586     0.150
     3.386    53.418     0.150
     3.515    54.797     0.150
     3.567    58.039     0.150
     3.567   111.336     0.150
     3.550    57.336     0.150
     3.657    57.227     0.150
     3.721    58.379     0.150
     3.721   114.598     0.150
     3.797    59.637     0.150
     3.797   105.336     0.150
     4.006    61.906     0.150
     4.123    64.938     0.150
     4.368    66.938     0.150
     4.387    68.039     0.150
     4.387   118.238     0.150
     4.503    70.039     0.150
     4.556    69.387     0.150
     4.556   121.176     0.150
     4.950    75.539     0.150
     4.950   132.637     0.150
     4.983    75.836     0.150
     4.983   132.539     0.150
     5.135    73.938     0.150
     5.195    79.039     0.150
     5.195   137.637     0.150
     5.386    81.336     0.150
     5.386   141.238     0.150
     6.310    92.938     0.150
     6.310   192.938     0.150
     6.786    99.738     0.150
     6.893   102.438     0.150
     7.503   108.109     0.150
     7.503   190.258     0.150
     7.761   112.238     0.150
     7.984   116.238     0.150
     7.984   204.238     0.150
     8.292   119.438     0.150
     8.292   206.938     0.150
     8.411   121.539     0.150
     8.832   127.738     0.150
     8.963   226.559     0.150
     8.713   129.469     0.150
     9.378   137.438     0.150
     9.378   237.238     0.150
    11.227   157.238     0.150
    12.325   173.836     0.150
    12.372   175.578     0.150
    12.452   178.426     0.150
    12.812   178.836     0.150
    12.812   312.238     0.150
    12.797   180.789     0.150
    12.931   178.938     0.150
    12.931   315.938     0.150
    12.968   183.047     0.150
    13.072   184.668     0.150
    13.127   185.539     0.150
    13.127   321.969     0.150
    13.160   188.129     0.150
    13.180   185.379     0.150
    14.109   195.738     0.150
    14.109   344.836     0.150
    15.005   208.238     0.150
    15.005   365.406     0.150
    15.005   208.238     0.150
    16.537   232.387     0.150
    16.537   227.223     0.150
    16.537   404.574     0.150
    20.148   274.637     0.150
    20.377   276.539     0.150
    20.435   276.605     0.150
    20.435   276.438     0.150
    20.595   278.289     0.150
    21.720   290.137     0.150
    23.851   313.707     0.150
    23.851   312.734     0.150
    23.905   315.129     0.150
    24.112   314.039     0.150
    24.409   317.602     0.150
    24.451   318.754     0.150
    24.613   320.336     0.150
    24.810   321.938     0.150
    26.255   336.137     0.150
    26.255   985.137     0.150
    30.284   371.039     0.150
    30.674   376.137     0.150
    32.688   462.836     0.150
    32.688   562.238     0.150
    32.688   710.539     0.150
    35.305   416.117     0.150
    39.683   542.539     0.150
    39.683   981.738     0.150
    42.873   478.137     0.150
    44.697   494.512     0.150
    44.889   494.137     0.150
    45.913   502.707     0.150
    46.932   509.711     0.150
    48.291   520.207     0.150
    48.880   525.539     0.150
    49.436   530.039     0.150
    49.436   529.836     0.150
    49.831   532.562     0.150
    51.573   547.000     0.150
    51.573   547.297     0.150
    52.582   554.039     0.150
    52.694   553.820     0.150
    52.896   555.227     0.150
    53.957   563.238     0.150
    53.957   563.688     0.150
    57.564   589.336     0.150
    58.094   593.238     0.150
    58.103   593.137     0.150
    58.246   594.137     0.150
    58.454   596.438     0.150
    58.822   597.938     0.150
    58.852   598.238     0.150
    59.662   603.836     0.150
    59.816   604.836     0.150
    59.944   605.938     0.150
    60.109   607.137     0.150
    60.503   609.137     0.150
    61.942   618.539     0.150
    62.128   619.637     0.150
    63.595   629.938     0.150
    63.845   631.938     0.150
    64.029   633.039     0.150
    67.340   655.699     0.150
    72.046   683.223     0.150
    74.288   696.188     0.150
    75.455   703.328     0.150
    76.015   706.707     0.150
    78.351   719.188     0.150
    78.519   719.414     0.150
    86.752   761.383     0.150
   120.101  1128.836     0.150
   142.694  1173.586     0.150
   148.063  1186.199     0.150
     0.196     3.898     0.150
     0.177     3.898     0.150
     2.180    39.898     0.150
     2.939    46.398     0.150
     2.939    56.398     0.150
     3.082    49.068     0.150
     3.082    59.428     0.150
     3.082    85.109     0.150
     3.207    62.188     0.150
     3.909   125.699     0.150
     6.857    99.768     0.150
     6.857   172.738     0.150
     7.577   188.398     0.150
    10.928   270.898     0.150
    11.656   287.219     0.150
    12.225   170.898     0.150
    12.225   297.898     0.150
    13.482   328.998     0.150
    15.663   217.684     0.150
    15.663   382.688     0.150
    17.250   239.074     0.150
    20.191   276.051     0.150
    21.157   284.482     0.150
    21.157   284.299     0.150
    21.157   284.029     0.150
    24.149   315.959     0.150
    24.559   319.686     0.150
    24.816   322.176     0.150
    24.816   321.598     0.150
    25.177   325.508     0.150
    25.083   325.473     0.150
    27.062   344.199     0.150
    37.258   433.736     0.150
    43.434   481.324     0.150
    47.569   515.449     0.150
    50.518   538.174     0.150
    53.405   559.289     0.150
    54.582   567.035     0.150
    71.573   680.479     0.150
    73.786   692.998     0.150
    78.667   721.719     0.150
    79.016   723.012     0.150
    87.460   765.998     0.150
     0.465     8.773     0.150
     0.465    15.174     0.150
     2.387    41.773     0.150
     2.387    69.873     0.150
     2.745    44.404     0.150
     2.795    47.623     0.150
     2.795    82.434     0.150
     3.228    50.674     0.150
     3.228    60.373     0.150
     3.228    88.674     0.150
     3.187    51.873     0.150
     3.187    88.174     0.150
     3.373    53.703     0.150
     3.475    54.213     0.150
     3.475    94.074     0.150
     3.394    53.283     0.150
     3.458    55.463     0.150
     3.837    60.373     0.150
     3.837   104.773     0.150
     4.022    62.154     0.150
     4.493    65.674     0.150
     4.390    67.975     0.150
     4.390   117.273     0.150
     4.441   118.475     0.150
     4.651    68.174     0.150
     4.651   124.174     0.150
     4.605    70.523     0.150
     4.605   120.963     0.150
     4.643    70.873     0.150
     4.643   123.373     0.150
     4.643   123.674     0.150
     4.873    74.574     0.150
     4.873   128.773     0.150
     4.873   128.975     0.150
     4.953    75.174     0.150
     5.225    79.273     0.150
     5.225   137.074     0.150
     6.258    91.174     0.150
     6.553   123.494     0.150
     7.088   102.424     0.150
     7.088   178.494     0.150
     7.488   108.184     0.150
     7.488   186.414     0.150
     7.469   109.373     0.150
     7.659   109.754     0.150
     7.659   190.404     0.150
     7.659   110.475     0.150
     7.659   192.574     0.150
     7.659   193.725     0.150
     7.659   194.113     0.150
     8.273   119.174     0.150
     8.327   124.953     0.150
     8.327   216.254     0.150
     8.544   123.773     0.150
     8.544   216.174     0.150
     8.887   128.373     0.150
     9.084   129.805     0.150
     9.074   133.475     0.150
     9.074   230.574     0.150
     9.074   132.873     0.150
     9.273   133.475     0.150
    10.726   151.174     0.150
    10.726   262.174     0.150
    11.068   155.674     0.150
    11.868   165.674     0.150
    12.174   170.305     0.150
    12.399   173.174     0.150
    12.399   304.174     0.150
    12.772   178.174     0.150
    12.772   311.174     0.150
    12.951   179.225     0.150
    13.720   190.975     0.150
    13.720   334.074     0.150
    13.835   194.873     0.150
    13.835   193.514     0.150
    15.137   381.475     0.150
    15.511   217.984     0.150
    15.511   378.984     0.150
    17.098   237.373     0.150
    17.562   241.924     0.150
    20.031   272.775     0.150
    20.410   276.674     0.150
    20.410   284.674     0.150
    20.410   288.475     0.150
    24.387   318.262     0.150
    24.496   318.873     0.150
    24.496   318.936     0.150
    24.496   537.311     0.150
    24.551   318.975     0.150
    24.899   322.424     0.150
    25.053   324.074     0.150
    25.177   323.475     0.150
    26.612   339.373     0.150
    26.728   340.074     0.150
    26.791   341.293     0.150
    26.791   541.867     0.150
    27.180   344.174     0.150
    27.779   346.773     0.150
    29.043   360.174     0.150
    30.674   375.074     0.150
    32.171   388.773     0.150
    32.703   393.574     0.150
    32.703   464.475     0.150
    32.703   708.174     0.150
    34.799   408.773     0.150
    35.381   415.074     0.150
    35.835   420.975     0.150
    39.573   451.574     0.150
    40.336   824.373     0.150
    43.529   482.975     0.150
    43.739   484.574     0.150
    44.751   494.873     0.150
    45.292   498.510     0.150
    45.292   499.504     0.150
    45.238   496.373     0.150
    45.852   502.244     0.150
    46.894   510.178     0.150
    47.343   514.174     0.150
    47.597   516.604     0.150
    47.593   515.449     0.150
    47.679   515.574     0.150
    49.338   527.773     0.150
    50.491   537.949     0.150
    51.059   541.713     0.150
    51.059     3.150     0.150
    51.059     4.521     0.150
    51.586   546.887     0.150
    52.706   552.975     0.150
    53.352   558.895     0.150
    53.514   560.336     0.150
    53.570   560.674     0.150
    53.643   560.293     0.150
    53.774   562.174     0.150
    54.480   566.773     0.150
    54.616   566.975     0.150
    54.616   567.398     0.150
    54.861   569.674     0.150
    55.048   571.873     0.150
    55.048   571.873     0.150
    56.325   580.281     0.150
    57.730   590.074     0.150
    57.796   590.074     0.150
    58.180   592.773     0.150
    58.479   595.273     0.150
    58.565   595.975     0.150
    58.697   597.574     0.150
    58.707   597.574     0.150
    58.845   597.773     0.150
    58.923   598.574     0.150
    59.082   599.574     0.150
    59.189   599.975     0.150
    59.236   600.674     0.150
    59.339   601.174     0.150
    59.423   601.773     0.150
    59.850   605.074     0.150
    60.273   607.574     0.150
    60.428   608.574     0.150
    60.558   609.574     0.150
    60.722   610.574     0.150
    61.028   612.975     0.150
    61.115   613.574     0.150
    61.608   616.873     0.150
    62.052   619.475     0.150
    62.328   621.773     0.150
    62.368   621.674     0.150
    62.566   622.475     0.150
    62.754   624.174     0.150
    62.759   623.924     0.150
    63.092   626.574     0.150
    63.101   626.174     0.150
    63.773   631.174     0.150
    64.013   632.594     0.150
    64.037   631.363     0.150
    64.219   633.773     0.150
    64.442   635.674     0.150
    64.655   636.773     0.150
    64.707   636.674     0.150
    64.842   637.674     0.150
    65.169   640.703     0.150
    67.720   657.674     0.150
    67.925   658.262     0.150
    67.925   658.635     0.150
    68.300   660.373     0.150
    70.465   674.443     0.150
    70.600   675.424     0.150
    71.445   679.408     0.150
    71.446   679.273     0.150
    71.453   679.373     0.150
    73.671   692.574     0.150
    73.673   692.574     0.150
    75.899   705.674     0.150
    78.455   719.674     0.150
    78.805   721.324     0.150
    78.805   896.574     0.150
    79.024   722.924     0.150
    80.199   730.273     0.150
    80.199   730.148     0.150
    82.900   745.074     0.150
    84.201   749.475     0.150
    84.201   749.748     0.150
    87.228   764.135     0.150
    87.295   765.219     0.150
    88.503   771.824     0.150
    91.291   784.725     0.150
    91.291  1001.799     0.150
   107.261  1105.574     0.150
   118.652  1127.904     0.150
   121.135  1132.773     0.150
   148.102  1186.635     0.150
   148.479  1186.850     0.150
   148.479  1183.914     0.150
     0.608    10.961     0.150
     0.608    20.762     0.150
     0.668    12.223     0.150
     1.352    26.961     0.150
     1.352    47.562     0.150
     1.614    29.973     0.150
     1.614    51.250     0.150
     1.614    52.152     0.150
     1.759    34.062     0.150
     1.759    54.859     0.150
     2.072    36.859     0.150
     2.072    63.859     0.150
     2.157    37.961     0.150
     2.157    66.262     0.150
     2.398    39.461     0.150
     2.398    70.961     0.150
     2.332    41.961     0.150
     2.613    43.641     0.150
     2.613    75.531     0.150
     2.613    78.039     0.150
     2.745    46.562     0.150
     2.745    86.062     0.150
     3.571    55.852     0.150
     3.571    97.473     0.150
     3.571    98.832     0.150
     3.571    99.121     0.150
    11.112   160.711     0.150
    12.146   175.590     0.150
    23.473   310.859     0.150
    27.295   346.562     0.150
    45.536   500.262     0.150
    48.661   524.758     0.150
    51.237   543.789     0.150
    78.316   720.109     0.150
    86.380   762.105     0.150
     0.685    12.344     0.150
     1.449    29.943     0.150
     1.724    31.363     0.150
     1.724    53.733     0.150
     1.866    35.743     0.150
     1.866    59.543     0.150
     1.994    34.943     0.150
     1.994    60.943     0.150
     2.081    35.943     0.150
     2.081    62.943     0.150
     2.219    38.833     0.150
     2.467    39.943     0.150
     2.467    70.443     0.150
     2.489    41.974     0.150
     2.489    42.083     0.150
     2.489    72.783     0.150
     2.582    43.184     0.150
     2.582    45.323     0.150
     2.582    75.543     0.150
     2.719    46.943     0.150
     2.832    47.443     0.150
     3.661    56.833     0.150
     3.661    57.184     0.150
     3.661    99.623     0.150
     5.092    76.844     0.150
     5.227    80.743     0.150
     5.426    83.344     0.150
     5.426   144.344     0.150
     5.550    82.613     0.150
     5.550   143.134     0.150
     6.059    90.743     0.150
     6.071    91.443     0.150
     6.071   157.743     0.150
     6.301    94.344     0.150
     6.301   164.943     0.150
     6.628    98.644     0.150
     6.628   171.144     0.150
     6.671    99.243     0.150
     6.671   172.243     0.150
     6.716   100.943     0.150
     6.879   102.243     0.150
     6.879   176.943     0.150
     7.085   104.743     0.150
     7.085   181.743     0.150
     7.154   107.144     0.150
     7.678   112.054     0.150
     7.678   193.304     0.150
     9.308   231.203     0.150
    10.739   154.943     0.150
    10.951   156.663     0.150
    10.995   159.943     0.150
    10.995   158.983     0.150
    12.156   174.113     0.150
    12.156   173.783     0.150
    13.412   187.943     0.150
    13.753   194.657     0.150
    13.753   336.068     0.150
    14.817   390.943     0.150
    16.149   225.304     0.150
    16.149   395.762     0.150
    16.149   225.193     0.150
    16.149   395.493     0.150
    19.356   266.043     0.150
    19.807   270.052     0.150
    19.807   269.724     0.150
    21.661   290.943     0.150
    21.734   291.844     0.150
    22.135   294.743     0.150
    22.502   299.553     0.150
    22.898   304.057     0.150
    22.898   304.080     0.150
    22.950   304.703     0.150
    23.092   306.442     0.150
    25.066   324.344     0.150
    26.641   339.963     0.150
    26.857   340.743     0.150
    27.200   345.243     0.150
    37.336   432.094     0.150
    38.985   446.844     0.150
    41.334   464.811     0.150
    41.994   471.743     0.150
    43.054   481.625     0.150
    43.492   482.844     0.150
    45.583   499.644     0.150
    48.688   524.144     0.150
    51.298   545.395     0.150
    51.290   544.087     0.150
    51.325   544.594     0.150
    52.571   553.243     0.150
    52.571   553.545     0.150
    54.097   564.677     0.150
    56.465   582.344     0.150
    56.474   582.344     0.150
    56.697   583.644     0.150
    58.057   593.043     0.150
    58.204   593.943     0.150
    58.337   594.844     0.150
    58.499   596.443     0.150
    59.821   605.543     0.150
    60.549   609.743     0.150
    62.014   619.943     0.150
    62.205   621.543     0.150
    73.680   693.403     0.150
    73.682   693.394     0.150
    78.300   718.644     0.150
    78.300   893.894     0.150
    86.413   761.293     0.150
    86.349   760.938     0.150
   120.076  1130.793     0.150
   146.297  1180.894     0.150
     0.521     8.994     0.150
     0.521    14.994     0.150
     0.624    11.994     0.150
     1.246    22.193     0.150
     1.246    38.254     0.150
     1.743    31.594     0.150
     2.137    40.033     0.150
     2.137    66.205     0.150
     2.711    49.824     0.150
     2.711    82.033     0.150
     2.703    44.484     0.150
     2.703    85.943     0.150
     2.819    48.494     0.150
     2.819    78.994     0.150
     2.819    87.494     0.150
     2.990    49.783     0.150
     2.990    83.934     0.150
     3.014    51.193     0.150
     3.014    97.395     0.150
     3.362    53.084     0.150
     3.362    62.824     0.150
     3.362    91.455     0.150
     3.645    54.783     0.150
     3.858    60.494     0.150
     3.858   105.693     0.150
     4.200    64.385     0.150
     4.283    68.994     0.150
     4.283   117.994     0.150
     4.510    69.494     0.150
     4.510   120.395     0.150
     4.401    68.295     0.150
     4.401   119.693     0.150
     4.976    75.994     0.150
     5.064    76.994     0.150
     5.064   134.193     0.150
     5.113    77.994     0.150
     5.113   135.693     0.150
     5.316    80.594     0.150
     5.316   139.795     0.150
     5.539    84.395     0.150
     5.539   145.693     0.150
     5.893    88.895     0.150
     5.893   153.693     0.150
     5.945   152.193     0.150
     8.109   118.594     0.150
     9.649   141.033     0.150
     9.649   247.584     0.150
    11.391   279.994     0.150
    12.009   294.994     0.150
    12.780   180.994     0.150
    12.904   180.994     0.150
    13.328   191.764     0.150
    15.095   211.777     0.150
    16.808   235.189     0.150
    16.808   236.318     0.150
    20.670   279.123     0.150
    20.670   278.975     0.150
    24.022   314.061     0.150
    24.076   313.783     0.150
    24.511   319.988     0.150
    24.586   319.574     0.150
    26.228   334.074     0.150
    26.919   343.033     0.150
    42.874   477.719     0.150
    46.997   510.568     0.150
    49.960   533.818     0.150
    54.010   563.652     0.150
    72.115   683.152     0.150
    78.674   721.104     0.150
     1.029    32.623     0.150
     1.329    22.844     0.150
     1.369    22.424     0.150
     1.881    30.844     0.150
     1.881    57.152     0.150
     2.152    32.662     0.150
     2.151    35.232     0.150
     2.151    63.883     0.150
     2.181    36.723     0.150
     2.519    39.123     0.150
     2.519    70.123     0.150
     2.690    42.434     0.150
     2.720    42.834     0.150
     2.921    45.973     0.150
     2.921    81.854     0.150
     3.160    49.123     0.150
     3.351    50.973     0.150
     3.351    91.213     0.150
     3.450    53.123     0.150
     3.566    54.424     0.150
     3.566    95.822     0.150
     3.844    57.094     0.150
     3.844   100.953     0.150
     3.844   117.232     0.150
     4.303    67.123     0.150
     4.692    69.322     0.150
     4.692   122.822     0.150
     5.052   130.123     0.150
     5.160    76.623     0.150
     5.340    78.424     0.150
     5.340   139.223     0.150
     5.685    84.482     0.150
     5.685   147.812     0.150
     5.793    84.123     0.150
     5.896    86.623     0.150
     5.941    87.223     0.150
     5.941   154.023     0.150
     5.961    86.723     0.150
     6.147    89.822     0.150
     6.360    92.723     0.150
     6.717    97.822     0.150
     6.717   172.623     0.150
     6.780    97.523     0.150
     7.035   100.723     0.150
     7.407   104.213     0.150
     7.419   105.023     0.150
     7.837   113.424     0.150
     8.928   126.062     0.150
     9.383   130.924     0.150
     9.383   230.523     0.150
    10.357   148.424     0.150
    10.357   147.623     0.150
    11.181   155.953     0.150
    11.181   274.354     0.150
    11.965   171.264     0.150
    11.990   168.812     0.150
    12.272   168.322     0.150
    12.302   172.152     0.150
    12.431   173.883     0.150
    12.608   177.684     0.150
    12.733   181.912     0.150
    12.733   179.611     0.150
    12.733   310.754     0.150
    12.733   180.723     0.150
    12.850   181.123     0.150
    12.899   180.504     0.150
    12.880   177.473     0.150
    12.880   311.623     0.150
    12.978   182.713     0.150
    13.039   177.623     0.150
    13.258   182.834     0.150
    13.258   321.113     0.150
    13.289   187.684     0.150
    14.375   197.580     0.150
    14.375   347.955     0.150
    14.375   198.023     0.150
    14.896   519.523     0.150
    14.896   945.123     0.150
    16.442   226.178     0.150
    16.442   226.398     0.150
    16.442   398.898     0.150
    19.040   258.623     0.150
    19.040   466.924     0.150
    19.040   524.924     0.150
    20.200   271.184     0.150
    20.200   491.656     0.150
    21.089   283.123     0.150
    21.089   543.723     0.150
    21.292   284.723     0.150
    21.292   514.424     0.150
    21.292   527.623     0.150
    21.292   547.924     0.150
    21.459   284.723     0.150
    21.459   516.623     0.150
    21.459   536.924     0.150
    21.459   555.023     0.150
    23.015   301.240     0.150
    23.418   306.338     0.150
    23.418   559.004     0.150
    23.418   306.586     0.150
    23.418   561.186     0.150
    23.753   308.811     0.150
    23.753   563.146     0.150
    23.767   309.473     0.150
    24.178   314.623     0.150
    24.424   316.924     0.150
    24.496   316.322     0.150
    24.496   573.822     0.150
    24.496   621.924     0.150
    25.312   323.424     0.150
    25.470   325.844     0.150
    25.470   325.846     0.150
    25.763   328.623     0.150
    26.069   330.662     0.150
    26.577   336.023     0.150
    26.806   337.223     0.150
    26.885   339.723     0.150
    27.058   340.703     0.150
    27.058   540.463     0.150
    27.234   341.723     0.150
    27.344   342.193     0.150
    27.458   345.023     0.150
    27.458   344.334     0.150
    27.515   344.344     0.150
    27.719   345.732     0.150
    29.325   360.473     0.150
    29.583   363.324     0.150
    29.710   363.822     0.150
    29.710   766.523     0.150
    30.183   368.924     0.150
    31.777   381.924     0.150
    31.922   384.383     0.150
    32.132   386.424     0.150
    32.799   391.424     0.150
    33.351   393.572     0.150
    33.593   397.684     0.150
    33.775   399.924     0.150
    33.775   473.924     0.150
    33.775   721.123     0.150
    33.818   399.123     0.150
    34.337   405.523     0.150
    34.570   405.283     0.150
    34.600   406.223     0.150
    35.024   409.934     0.150
    35.310   413.572     0.150
    35.422   415.369     0.150
    35.635   414.523     0.150
    35.766   417.924     0.150
    35.892   416.623     0.150
    35.892   752.623     0.150
    35.892   789.424     0.150
    36.077   418.924     0.150
    36.403   421.783     0.150
    36.962   428.164     0.150
    37.117   429.031     0.150
    37.135   427.473     0.150
    37.272   431.258     0.150
    37.524   433.090     0.150
    38.014   435.113     0.150
    38.067   435.684     0.150
    38.067   435.924     0.150
    38.115   437.516     0.150
    38.211   438.252     0.150
    38.229   436.943     0.150
    38.303   438.836     0.150
    38.603   440.123     0.150
    38.603   525.424     0.150
    38.674   441.523     0.150
    38.674   794.424     0.150
    38.798   442.264     0.150
    38.922   443.123     0.150
    38.922   533.623     0.150
    39.274   445.133     0.150
    39.454   447.193     0.150
    40.151   452.473     0.150
    40.226   453.303     0.150
    41.085   457.953     0.150
    41.173   462.363     0.150
    41.516   463.322     0.150
    41.694   465.594     0.150
    42.054   468.049     0.150
    43.248   479.322     0.150
    43.610   482.473     0.150
    43.728   482.623     0.150
    43.787   483.523     0.150
    44.355   487.523     0.150
    44.458   486.822     0.150
    44.774   491.123     0.150
    45.103   493.723     0.150
    45.129   494.123     0.150
    45.215   493.523     0.150
    45.215   494.322     0.150
    45.215   493.264     0.150
    45.406   495.139     0.150
    45.520   496.623     0.150
    45.565   496.223     0.150
    45.800   499.123     0.150
    45.833   499.123     0.150
    45.979   500.123     0.150
    46.112   501.912     0.150
    46.198   501.584     0.150
    46.243   502.248     0.150
    46.370   502.322     0.150
    46.370   599.023     0.150
    46.904   508.924     0.150
    47.058   509.023     0.150
    47.058     8.500     0.150
    47.548   515.023     0.150
    47.674   514.924     0.150
    47.949   515.424     0.150
    48.009   517.023     0.150
    48.645   521.023     0.150
    48.893   522.123     0.150
    49.001   524.523     0.150
    49.016   524.924     0.150
    49.073   524.424     0.150
    49.281   526.072     0.150
    49.281   525.723     0.150
    49.466   527.322     0.150
    49.833   530.902     0.150
    50.238   533.623     0.150
    50.245   533.662     0.150
    50.245   533.023     0.150
    50.432   535.223     0.150
    50.822   538.123     0.150
    50.841   537.523     0.150
    50.826   538.697     0.150
    50.938   539.057     0.150
    51.025   539.174     0.150
    51.077   538.822     0.150
    51.270   541.924     0.150
    51.293   541.674     0.150
    51.352   541.623     0.150
    51.398   542.822     0.150
    51.483   541.443     0.150
    51.673   544.619     0.150
    51.732   544.424     0.150
    51.735   544.393     0.150
    52.025   545.986     0.150
    52.025   618.535     0.150
    52.082   547.322     0.150
    52.082    10.801     0.150
    52.300   548.223     0.150
    52.300     8.900     0.150
    52.351   547.924     0.150
    52.418   549.344     0.150
    52.434   549.760     0.150
    52.506   550.322     0.150
    52.539   551.223     0.150
    52.602   551.023     0.150
    52.726   552.822     0.150
    52.946   553.104     0.150
    53.033   554.793     0.150
    53.120   555.223     0.150
    53.222   556.123     0.150
    53.243   554.822     0.150
    53.243   554.848     0.150
    53.245   556.123     0.150
    53.395   555.793     0.150
    53.564   558.123     0.150
    53.564   558.123     0.150
    53.569   557.525     0.150
    53.601   557.754     0.150
    53.725   559.424     0.150
    53.780   559.924     0.150
    53.864   559.436     0.150
    53.918   559.621     0.150
    54.013   560.322     0.150
    54.127   563.424     0.150
    54.308   563.223     0.150
    54.737   567.322     0.150
    54.751   566.205     0.150
    54.849   568.822     0.150
    54.895   566.822     0.150
    55.135   569.723     0.150
    55.627   572.023     0.150
    55.703   574.523     0.150
    56.243   577.623     0.150
    56.256   578.723     0.150
    56.307   578.023     0.150
    56.313   577.623     0.150
    56.496   578.723     0.150
    56.688   580.322     0.150
    56.949   582.523     0.150
    56.989   582.623     0.150
    57.037   585.223     0.150
    57.059   583.223     0.150
    57.159   584.424     0.150
    57.187   584.123     0.150
    57.197   584.723     0.150
    57.206   584.822     0.150
    57.252   585.123     0.150
    57.338   584.723     0.150
    57.342   584.822     0.150
    57.426   586.023     0.150
    57.604   587.424     0.150
    57.684   587.223     0.150
    57.748   588.223     0.150
    57.921   589.424     0.150
    58.002   590.123     0.150
    58.345   592.723     0.150
    58.771   595.322     0.150
    58.933   596.123     0.150
    59.065   596.924     0.150
    59.228   598.023     0.150
    59.234   598.023     0.150
    59.525   600.822     0.150
    59.547   600.822     0.150
    59.594   601.123     0.150
    59.621   600.723     0.150
    59.664   600.424     0.150
    60.112   604.723     0.150
    60.552   607.822     0.150
    60.829   609.822     0.150
    60.863   609.723     0.150
    61.073    10.000     0.150
    61.073   610.453     0.150
    61.083   610.623     0.150
    61.272   611.723     0.150
    61.456   613.822     0.150
    61.609   614.023     0.150
    61.608   614.123     0.150
    61.752   615.322     0.150
    62.237   619.033     0.150
    62.268   618.223     0.150
    62.508   621.273     0.150
    62.531   621.322     0.150
    62.737   622.023     0.150
    62.819   621.123     0.150
    62.938   624.023     0.150
    63.174   624.723     0.150
    63.224   624.822     0.150
    63.338   627.223     0.150
    63.502   626.902     0.150
    63.661   628.604     0.150
    65.014   638.174     0.150
    65.717   642.424     0.150
    66.074   644.623     0.150
    66.417   645.686     0.150
    66.417   646.123     0.150
    66.417   645.963     0.150
    66.432   646.174     0.150
    66.624   648.174     0.150
    66.828   649.123     0.150
    66.949   649.533     0.150
    66.949   649.223     0.150
    66.989   649.822     0.150
    67.403   652.223     0.150
    67.407   651.652     0.150
    67.686   653.023     0.150
    68.058   656.293     0.150
    68.544   659.771     0.150
    68.708   661.623     0.150
    68.713   660.223     0.150
    68.834   662.223     0.150
    68.839   660.982     0.150
    68.855   661.684     0.150
    68.874   662.223     0.150
    68.957   662.062     0.150
    69.091   663.113     0.150
    69.623   667.123     0.150
    69.765   667.924     0.150
    69.775   667.543     0.150
    69.859   668.424     0.150
    70.674   673.623     0.150
    72.805   685.174     0.150
    72.948   686.031     0.150
    72.956   686.023     0.150
    75.010   697.523     0.150
    75.164   698.723     0.150
    75.404   700.123     0.150
    76.231   706.184     0.150
    76.231   707.322     0.150
    76.592   707.623     0.150
    78.130   715.424     0.150
    78.130   715.254     0.150
    78.473   716.322     0.150
    78.473   891.822     0.150
    78.527   717.223     0.150
    80.257   726.822     0.150
    80.725   729.822     0.150
    80.967   730.553     0.150
    81.569   734.549     0.150
    81.569   735.023     0.150
    81.707   735.822     0.150
    81.707   735.322     0.150
    81.920   736.822     0.150
    81.937   736.822     0.150
    85.687   754.623     0.150
    85.687   754.348     0.150
    86.668   758.969     0.150
    86.668  1833.318     0.150
    88.086   767.648     0.150
    90.139   776.072     0.150
    95.915   803.223     0.150
   120.436  1128.049     0.150
   147.009  1179.424     0.150
   153.511  1194.947     0.150
     0.786    25.562     0.150
     0.879    32.664     0.150
     2.042    35.062     0.150
     2.042    58.062     0.150
     3.188    52.062     0.150
     3.232    49.164     0.150
     3.232    86.164     0.150
     3.610    62.367     0.150
     3.770    58.664     0.150
     4.162    62.664     0.150
     4.162   112.664     0.150
     4.402    66.664     0.150
     4.352    66.562     0.150
     4.916    74.266     0.150
     4.916   131.164     0.150
     4.947    74.562     0.150
     4.947   131.562     0.150
     5.141    76.164     0.150
     5.160    77.367     0.150
     5.347    79.867     0.150
     5.708    85.062     0.150
     5.708   149.562     0.150
     6.364    91.664     0.150
     6.928   100.461     0.150
     7.540   106.906     0.150
     7.540   187.945     0.150
     8.122   115.867     0.150
     8.122   202.023     0.150
     8.300   117.664     0.150
     8.456   119.867     0.150
     8.879   126.367     0.150
     8.752   131.961     0.150
     9.326   136.062     0.150
     9.326   236.461     0.150
     9.326   135.766     0.150
     9.326   237.461     0.150
     9.872   141.664     0.150
     9.872   248.664     0.150
    11.186   273.664     0.150
    11.316   160.664     0.150
    11.910   167.133     0.150
    11.910   291.203     0.150
    12.367   174.141     0.150
    12.359   172.664     0.150
    12.359   300.266     0.150
    12.450   174.688     0.150
    12.797   180.203     0.150
    12.820   312.641     0.150
    12.970   182.273     0.150
    12.957   178.164     0.150
    12.957   317.664     0.150
    13.070   186.477     0.150
    13.155   185.906     0.150
    13.155   185.664     0.150
    13.179   184.508     0.150
    13.179   183.352     0.150
    13.304   185.273     0.150
    13.325   187.664     0.150
    13.419   188.805     0.150
    13.441   188.211     0.150
    13.759   193.758     0.150
    14.662   207.664     0.150
    14.662   370.664     0.150
    15.014   205.562     0.150
    16.514   226.961     0.150
    16.514   227.188     0.150
    16.514   405.961     0.150
    18.291   251.266     0.150
    18.291   261.867     0.150
    18.291   267.461     0.150
    18.291   463.664     0.150
    20.094   274.164     0.150
    20.094   294.461     0.150
    20.094   521.164     0.150
    20.419   275.461     0.150
    20.419   274.445     0.150
    20.361   274.164     0.150
    20.408   277.867     0.150
    20.408   289.961     0.150
    20.408   503.664     0.150
    20.416   276.062     0.150
    20.416   296.461     0.150
    23.223   307.664     0.150
    23.434   307.867     0.150
    23.389   306.961     0.150
    23.389   570.867     0.150
    23.814   310.742     0.150
    23.845   311.367     0.150
    23.845   312.055     0.150
    23.900   312.961     0.150
    24.109   313.867     0.150
    24.109   313.602     0.150
    24.374   316.164     0.150
    24.464   317.367     0.150
    24.590   318.367     0.150
    24.774   322.664     0.150
    25.073   322.852     0.150
    26.096   331.062     0.150
    26.181   332.383     0.150
    26.368   335.164     0.150
    26.504   337.562     0.150
    26.504   540.422     0.150
    26.898   339.367     0.150
    27.153   341.664     0.150
    27.293   544.766     0.150
    27.293   695.867     0.150
    27.293   767.766     0.150
    27.402   344.266     0.150
    30.288   426.867     0.150
    30.288   549.062     0.150
    30.288   764.867     0.150
    30.572   374.266     0.150
    30.611   373.766     0.150
    32.590   390.312     0.150
    32.720   392.367     0.150
    32.815   395.062     0.150
    32.815   465.266     0.150
    32.815   705.664     0.150
    34.924   409.562     0.150
    34.924   737.961     0.150
    34.924   753.062     0.150
    35.345   415.367     0.150
    35.923   419.766     0.150
    36.914   427.766     0.150
    37.915   435.961     0.150
    39.065   446.164     0.150
    39.065   445.711     0.150
    39.701   450.562     0.150
    39.701   547.367     0.150
    39.701   813.367     0.150
    39.701   451.320     0.150
    39.705   451.656     0.150
    40.947   460.867     0.150
    40.947   555.867     0.150
    40.947   830.367     0.150
    42.925   477.016     0.150
    43.177   479.867     0.150
    44.184   490.461     0.150
    44.728   493.961     0.150
    44.846   491.664     0.150
    45.115   494.367     0.150
    45.271   497.266     0.150
    46.943   508.742     0.150
    46.971   511.867     0.150
    47.003   510.961     0.150
    47.028   510.266     0.150
    47.270   512.867     0.150
    47.765   516.867     0.150
    47.805   518.367     0.150
    47.952   517.062     0.150
    48.454   523.266     0.150
    48.862   524.766     0.150
    48.845   523.461     0.150
    48.845   523.281     0.150
    49.437   528.664     0.150
    49.550   531.664     0.150
    49.833   531.539     0.150
    50.139   533.164     0.150
    50.356   536.562     0.150
    50.401   536.344     0.150
    51.120   542.562     0.150
    51.312   543.766     0.150
    51.436   544.547     0.150
    51.628   546.164     0.150
    51.717   546.766     0.150
    51.856   548.094     0.150
    52.050   548.602     0.150
    52.048   546.906     0.150
    52.195   550.023     0.150
    52.231   552.062     0.150
    52.283   551.062     0.150
    52.607   552.664     0.150
    52.646   552.406     0.150
    52.923   555.164     0.150
    52.923   555.273     0.150
    52.978   555.961     0.150
    52.988   554.570     0.150
    53.191   556.484     0.150
    53.581   559.156     0.150
    53.678   560.562     0.150
    53.807   562.164     0.150
    53.970   561.266     0.150
    53.970   561.836     0.150
    54.098   563.664     0.150
    54.451   567.164     0.150
    54.451   567.164     0.150
    54.484   566.289     0.150
    54.525   566.461     0.150
    54.525   566.688     0.150
    54.613   567.367     0.150
    54.759   568.367     0.150
    54.832   568.023     0.150
    55.311   571.664     0.150
    55.663   574.156     0.150
    55.889   576.461     0.150
    56.160   578.461     0.150
    56.311   579.461     0.150
    56.763   582.562     0.150
    57.126   586.867     0.150
    57.178   586.164     0.150
    57.205   585.164     0.150
    57.591   587.766     0.150
    57.643     8.141     0.150
    57.713   590.062     0.150
    57.713   590.438     0.150
    57.713     7.594     0.150
    57.713   590.961     0.150
    57.818   591.320     0.150
    58.003   591.062     0.150
    58.123   592.367     0.150
    58.133   592.461     0.150
    58.269   593.664     0.150
    58.276   593.164     0.150
    58.341   593.461     0.150
    58.625   595.305     0.150
    58.642   595.461     0.150
    58.641   597.711     0.150
    58.743   596.523     0.150
    58.743     7.039     0.150
    58.852   597.461     0.150
    59.284   600.461     0.150
    59.689   602.062     0.150
    59.701   602.867     0.150
    59.844   603.461     0.150
    59.971   604.164     0.150
    60.137   605.266     0.150
    60.152   605.664     0.150
    60.460   608.266     0.150
    60.463   608.266     0.150
    60.497   608.367     0.150
    60.531   608.062     0.150
    60.588   609.367     0.150
    60.794   609.766     0.150
    60.794   653.266     0.150
    61.024   611.867     0.150
    61.477   615.164     0.150
    61.749   617.164     0.150
    61.802   617.367     0.150
    61.967   617.562     0.150
    62.154   618.664     0.150
    62.378   621.062     0.150
    62.494   620.961     0.150
    62.513   621.266     0.150
    62.702   622.773     0.150
    63.190   626.945     0.150
    63.449   628.422     0.150
    63.476   628.484     0.150
    63.620   628.961     0.150
    63.875   631.766     0.150
    64.054   631.562     0.150
    64.109   631.766     0.150
    64.273   633.867     0.150
    64.619   638.234     0.150
    67.065   653.297     0.150
    67.161   652.305     0.150
    67.373   653.648     0.150
    67.373   653.953     0.150
    67.403   654.023     0.150
    67.601   655.312     0.150
    67.689   655.672     0.150
    67.795   655.766     0.150
    68.373   663.602     0.150
    69.913   671.531     0.150
    70.055   672.367     0.150
    71.097   677.211     0.150
    72.016   681.898     0.150
    72.017   680.766     0.150
    72.017   681.906     0.150
    72.024   681.867     0.150
    73.845   692.266     0.150
    74.260   694.914     0.150
    75.417   700.852     0.150
    76.067   705.922     0.150
    78.316   717.062     0.150
    78.316   896.062     0.150
    78.754   720.211     0.150
    80.496   728.961     0.150
    80.724   731.961     0.150
    80.724   731.188     0.150
    80.724   732.164     0.150
    86.727   760.812     0.150
    86.727  1833.812     0.150
   104.825   848.383     0.150
   110.374   865.883     0.150
   117.532  1122.164     0.150
   120.552  1129.586     0.150
   142.747  1171.562     0.150
   148.041  1182.266     0.150
   148.118  1184.625     0.150
   151.554  1188.172     0.150
   151.554  1193.914     0.150
     0.885    16.273     0.150
     2.056    33.875     0.150
     2.056    60.273     0.150
     2.926    45.930     0.150
     2.926    46.367     0.150
     2.926    82.891     0.150
     2.926    83.375     0.150
     3.245    50.773     0.150
     3.200    51.273     0.150
     3.419    53.914     0.150
     3.419    92.836     0.150
     3.455    53.547     0.150
     3.622    57.273     0.150
     3.777    58.344     0.150
     3.762    59.570     0.150
     3.762   104.375     0.150
     4.074    61.461     0.150
     4.074   105.695     0.150
     4.342    67.477     0.150
     4.342   117.570     0.150
     4.412    67.773     0.150
     4.624    69.195     0.150
     4.906    74.773     0.150
     4.906   132.070     0.150
     4.936    75.375     0.150
     4.936   131.172     0.150
     5.141   133.773     0.150
     5.150    78.773     0.150
     5.150   137.477     0.150
     5.336    80.977     0.150
     5.336   140.570     0.150
     5.697    86.070     0.150
     5.697   149.977     0.150
     6.377    92.773     0.150
     6.377    94.203     0.150
     7.139   104.500     0.150
     7.548   108.125     0.150
     7.548   188.055     0.150
     8.116   116.961     0.150
     8.116   203.414     0.150
     8.761   130.977     0.150
     8.761   228.750     0.150
     9.312   136.875     0.150
     9.312   136.477     0.150
     9.312   235.875     0.150
     9.874   140.570     0.150
    11.175   157.773     0.150
    11.328   159.773     0.150
    12.366   172.273     0.150
    12.366   303.477     0.150
    12.820   179.172     0.150
    12.962   179.773     0.150
    13.178   182.773     0.150
    13.178   323.773     0.150
    16.509   227.320     0.150
    16.509   404.344     0.150
    20.080   273.070     0.150
    20.350   278.273     0.150
    20.403   279.570     0.150
    20.394   293.273     0.150
    20.394   298.273     0.150
    20.416   275.477     0.150
    23.214   305.375     0.150
    23.809   311.672     0.150
    23.809   312.172     0.150
    23.846   313.031     0.150
    23.901   312.570     0.150
    24.109   314.570     0.150
    24.586   318.477     0.150
    25.059   323.617     0.150
    26.186   334.273     0.150
    26.186   334.273     0.150
    26.492   338.195     0.150
    26.886   339.375     0.150
    27.279   345.172     0.150
    27.279   542.375     0.150
    27.279   621.273     0.150
    27.279   636.273     0.150
    27.279   761.172     0.150
    30.291   372.070     0.150
    30.291   371.234     0.150
    30.597   373.570     0.150
    32.800   392.172     0.150
    32.800   460.773     0.150
    35.356   418.062     0.150
    36.585   427.977     0.150
    39.076   446.344     0.150
    39.076   448.273     0.150
    39.707   451.773     0.150
    44.193   491.273     0.150
    44.737   496.070     0.150
    44.836   491.672     0.150
    44.836   494.234     0.150
    44.916   492.070     0.150
    45.280   497.570     0.150
    45.367   499.977     0.150
    46.813   511.875     0.150
    46.980   513.273     0.150
    46.948   509.781     0.150
    46.948   511.172     0.150
    47.278   528.570     0.150
    47.775   518.773     0.150
    47.960   518.273     0.150
    49.439   530.477     0.150
    50.364   537.273     0.150
    50.364   536.242     0.150
    51.001   542.883     0.150
    51.001   543.305     0.150
    51.642   546.477     0.150
    52.714   553.758     0.150
    52.932   556.023     0.150
    53.975   562.797     0.150
    55.301   571.977     0.150
    55.754   576.750     0.150
    57.188   586.875     0.150
    57.213   586.875     0.150
    58.142   593.375     0.150
    58.350   595.172     0.150
    58.638   596.773     0.150
    58.861   598.477     0.150
    58.885   598.570     0.150
    59.698   604.375     0.150
    59.710   604.375     0.150
    59.853   605.477     0.150
    60.145   606.977     0.150
    60.540   609.977     0.150
    61.033   613.273     0.150
    61.486   616.570     0.150
    61.758   618.375     0.150
    61.812   618.875     0.150
    61.975   619.570     0.150
    62.162   620.273     0.150
    62.387   621.977     0.150
    63.216   627.977     0.150
    63.628   630.570     0.150
    63.885   632.273     0.150
    72.007   682.031     0.150
    72.007   682.477     0.150
    72.008   682.172     0.150
    73.858   694.820     0.150
    74.252   695.625     0.150
    78.309   718.477     0.150
    82.618   742.820     0.150
    86.722   761.609     0.150
    86.722   762.273     0.150
   148.132  1184.172     0.150
     0.368     6.586     0.150
     1.003    17.586     0.150
     1.634    30.586     0.150
     1.765    32.486     0.150
     1.765    54.186     0.150
     1.874    34.887     0.150
     1.874    56.686     0.150
     1.988    35.486     0.150
     1.988    62.086     0.150
     2.390    40.516     0.150
     2.307    41.066     0.150
     2.307    69.625     0.150
     2.855    46.875     0.150
     2.855    79.455     0.150
     2.905    48.086     0.150
     2.857    47.936     0.150
     3.018    81.535     0.150
     3.074    50.676     0.150
     3.169    51.416     0.150
     3.169    86.625     0.150
     3.314    53.266     0.150
     3.314    90.096     0.150
     3.174    53.285     0.150
     3.694    58.586     0.150
     3.694   101.986     0.150
     4.238    65.535     0.150
     4.238   113.486     0.150
     4.153    66.086     0.150
     4.356    67.586     0.150
     4.356   116.686     0.150
     4.448    68.086     0.150
     4.448   119.086     0.150
     4.907    74.686     0.150
     4.907   129.986     0.150
     4.960    75.686     0.150
     4.960   131.186     0.150
     5.162    78.186     0.150
     5.162   136.086     0.150
     5.391    81.486     0.150
     5.391   141.986     0.150
     5.744   149.887     0.150
     5.744    86.686     0.150
     5.957    89.205     0.150
     5.957   152.746     0.150
     6.725    99.695     0.150
     6.725   170.727     0.150
     6.743   100.486     0.150
     7.087   102.926     0.150
     7.087   177.955     0.150
     6.960   103.887     0.150
     7.754   113.486     0.150
     7.952   114.807     0.150
     7.952   200.916     0.150
     8.030   117.586     0.150
     8.030   207.086     0.150
     8.297   218.736     0.150
     8.759   126.986     0.150
     9.606   137.125     0.150
     9.606   239.836     0.150
    11.911   292.086     0.150
    12.530   175.586     0.150
    12.530   305.586     0.150
    12.713   311.086     0.150
    13.692   332.625     0.150
    13.489   191.086     0.150
    15.263   211.660     0.150
    16.910   234.092     0.150
    16.932   234.189     0.150
    16.932   735.186     0.150
    18.700   256.686     0.150
    20.334   274.785     0.150
    20.361   278.186     0.150
    20.366   276.486     0.150
    20.765   280.586     0.150
    20.808   279.707     0.150
    20.808   280.387     0.150
    23.589   310.887     0.150
    23.769   310.777     0.150
    24.178   315.975     0.150
    24.178   315.373     0.150
    24.232   316.387     0.150
    24.238   317.186     0.150
    24.430   318.486     0.150
    24.697   320.586     0.150
    24.681   320.506     0.150
    24.741   320.986     0.150
    25.006   322.887     0.150
    25.006   589.486     0.150
    26.398   336.086     0.150
    26.398   336.086     0.150
    26.822   341.086     0.150
    26.949   343.086     0.150
    26.949   542.467     0.150
    27.342   345.986     0.150
    27.342     4.430     0.150
    27.858   351.086     0.150
    27.858   634.887     0.150
    30.567   373.686     0.150
    30.567   429.785     0.150
    30.567   551.486     0.150
    30.567   374.016     0.150
    32.775   394.486     0.150
    32.775   562.086     0.150
    35.221   416.586     0.150
    36.379   423.586     0.150
    36.633   427.785     0.150
    36.633   765.686     0.150
    39.055   446.785     0.150
    39.881   453.785     0.150
    39.881   544.186     0.150
    39.881   581.586     0.150
    43.043   479.311     0.150
    43.043   479.186     0.150
    45.360   497.486     0.150
    47.167   512.387     0.150
    48.375   523.273     0.150
    49.731   531.086     0.150
    50.124   535.285     0.150
    50.124   535.535     0.150
    53.020   556.023     0.150
    54.180   564.387     0.150
    54.180   564.461     0.150
    57.302   588.387     0.150
    58.195   593.686     0.150
    58.204   593.686     0.150
    58.424   595.387     0.150
    58.919   599.186     0.150
    59.770   604.586     0.150
    59.781   605.086     0.150
    60.225   606.986     0.150
    61.110   613.887     0.150
    61.250   615.086     0.150
    61.550   617.285     0.150
    62.076   619.686     0.150
    63.730   631.186     0.150
    64.166   633.887     0.150
    71.949   682.670     0.150
    71.958   682.686     0.150
    73.670   693.611     0.150
    74.168   695.887     0.150
    74.170   695.887     0.150
    74.170   695.436     0.150
    75.868   705.887     0.150
    78.323   719.086     0.150
    78.419   720.186     0.150
    78.927   722.285     0.150
    82.411   742.436     0.150
    84.693   752.611     0.150
    87.151   764.381     0.150
     0.525    10.766     0.150
     0.525    18.266     0.150
     2.254    39.426     0.150
     2.254    67.445     0.150
     2.617    43.535     0.150
     2.617    73.735     0.150
     3.188    49.266     0.150
     3.188    85.266     0.150
     3.220    51.346     0.150
     3.220    87.766     0.150
     3.286    50.836     0.150
     3.342    51.315     0.150
     3.361    53.065     0.150
     3.361    52.666     0.150
     3.361    93.266     0.150
     3.481    53.456     0.150
     3.995    61.466     0.150
     3.995    60.766     0.150
     4.570    66.896     0.150
     4.570   117.676     0.150
     4.551    68.865     0.150
     4.551    68.666     0.150
     4.597    68.966     0.150
     4.597    69.166     0.150
     4.802    71.865     0.150
     4.802    71.365     0.150
     4.906   128.365     0.150
     5.021    75.166     0.150
     5.021    74.766     0.150
     5.376    80.166     0.150
     6.254    90.246     0.150
     6.702    97.626     0.150
     7.192   102.155     0.150
     7.192   178.456     0.150
     7.116   103.266     0.150
     7.300   105.766     0.150
     7.300   187.266     0.150
     8.120   116.565     0.150
     8.379   120.865     0.150
     8.379   210.266     0.150
     8.743   124.865     0.150
     9.138   130.365     0.150
     9.166   133.565     0.150
     9.166   132.666     0.150
     9.166   234.565     0.150
     9.690   136.155     0.150
    10.873   152.766     0.150
    10.873   266.766     0.150
    11.110   154.266     0.150
    12.541   172.766     0.150
    13.818   190.365     0.150
    13.652   191.466     0.150
    13.652   191.655     0.150
    15.020   216.766     0.150
    16.945   233.141     0.150
    16.945   233.766     0.150
    18.418   252.266     0.150
    20.434   285.266     0.150
    20.434   288.766     0.150
    24.239   314.416     0.150
    24.317   314.952     0.150
    24.372   315.266     0.150
    24.581   317.766     0.150
    25.023   320.865     0.150
    26.642   336.735     0.150
    26.642   336.740     0.150
    26.733   339.166     0.150
    29.111   358.266     0.150
    30.760   372.466     0.150
    30.760   676.266     0.150
    30.760   772.266     0.150
    32.001   384.766     0.150
    32.760   390.065     0.150
    32.760   458.565     0.150
    32.760   705.266     0.150
    33.109   395.666     0.150
    37.349   430.766     0.150
    39.413   448.365     0.150
    40.150   454.166     0.150
    40.150    11.000     0.150
    43.348   479.791     0.150
    45.119   495.966     0.150
    45.149   493.266     0.150
    45.582   496.865     0.150
    47.419   513.166     0.150
    47.406   512.166     0.150
    50.306   534.740     0.150
    53.029   554.916     0.150
    53.336   556.954     0.150
    54.429   563.766     0.150
    54.429   563.940     0.150
    55.604   573.266     0.150
    58.002   589.966     0.150
    58.523   594.565     0.150
    58.532   594.565     0.150
    58.672   594.565     0.150
    58.747   595.565     0.150
    58.991   597.166     0.150
    59.017   597.266     0.150
    59.249   598.966     0.150
    60.100   604.065     0.150
    60.251   604.865     0.150
    60.381   605.766     0.150
    60.545   607.365     0.150
    60.938   610.065     0.150
    61.431   613.365     0.150
    61.877   617.065     0.150
    62.386   619.666     0.150
    62.923   623.466     0.150
    64.040   630.966     0.150
    67.755   655.903     0.150
    71.619   678.675     0.150
    71.627   677.836     0.150
    73.850   691.716     0.150
    74.053   692.966     0.150
    74.053   693.470     0.150
    78.889   719.966     0.150
    82.793   742.141     0.150
    87.149   762.511     0.150
   148.336  1183.740     0.150
   153.207  1193.615     0.150
     0.408     6.949     0.150
     0.510    10.449     0.150
     1.879    32.148     0.150
     1.879    57.148     0.150
     2.288    40.418     0.150
     2.288    68.359     0.150
     2.885    47.309     0.150
     2.885    80.088     0.150
     3.050    49.098     0.150
     3.203    51.039     0.150
     3.356    89.008     0.150
     3.706    58.648     0.150
     3.706    69.648     0.150
     3.706   102.348     0.150
     4.268    64.168     0.150
     4.268   110.459     0.150
     4.361    67.348     0.150
     4.361   117.248     0.150
     4.435   116.148     0.150
     4.553    69.848     0.150
     4.914    74.748     0.150
     4.914   130.248     0.150
     4.964    75.549     0.150
     4.964   130.949     0.150
     5.167    78.049     0.150
     5.167   136.248     0.150
     5.393    81.748     0.150
     5.393   140.949     0.150
     5.746    86.549     0.150
     5.746   149.848     0.150
     5.992    89.508     0.150
     5.992   151.369     0.150
     6.767   101.469     0.150
     6.767   172.459     0.150
     6.948   103.248     0.150
     7.131   103.539     0.150
     7.131   178.418     0.150
     7.750   113.748     0.150
     7.750   199.148     0.150
     7.974   115.258     0.150
     7.974   202.209     0.150
     8.020   117.848     0.150
     8.369   122.348     0.150
     8.340   126.828     0.150
     8.340   220.498     0.150
     9.650   138.148     0.150
     9.529   139.648     0.150
     9.529   139.488     0.150
    11.955   166.408     0.150
    12.573   175.148     0.150
    13.454   188.609     0.150
    13.454   336.279     0.150
    16.889   238.279     0.150
    16.889   234.498     0.150
    18.664   259.648     0.150
    18.664   263.648     0.150
    18.664   267.148     0.150
    20.385   275.498     0.150
    24.141   314.586     0.150
    24.195   315.123     0.150
    24.704   320.629     0.150
    26.371   335.998     0.150
    26.371   335.998     0.150
    26.908   342.188     0.150
    27.302   345.869     0.150
    43.025   478.799     0.150
    45.331   497.549     0.150
    47.140   511.998     0.150
    47.230   512.549     0.150
    49.697   531.648     0.150
    50.090   535.049     0.150
    53.003   556.137     0.150
    54.154   564.549     0.150
    54.154   564.174     0.150
    57.968   592.049     0.150
    58.181   594.449     0.150
    58.190   594.549     0.150
    59.915   605.549     0.150
    60.046   605.949     0.150
    60.209   607.348     0.150
    61.094   614.049     0.150
    62.058   619.848     0.150
    63.924   633.248     0.150
    71.963   682.609     0.150
    71.971   683.279     0.150
    73.680   693.648     0.150
    80.723   732.223     0.150
     0.675    12.461     0.150
     0.675    22.262     0.150
     1.282    23.883     0.150
     1.282    40.121     0.150
     2.290    69.363     0.150
     2.444    40.562     0.150
     2.444    68.562     0.150
     2.659    44.324     0.150
     2.659    75.004     0.150
     2.890    47.102     0.150
     2.890    81.242     0.150
     3.191    51.164     0.150
     3.191    85.781     0.150
     3.559    55.734     0.150
     3.755    99.672     0.150
    11.677   167.793     0.150
    16.097   223.816     0.150
    24.562   320.141     0.150
    24.562   320.137     0.150
    27.330   345.621     0.150
    45.335   497.914     0.150
    48.479   522.668     0.150
    52.316   550.461     0.150
    52.316   551.012     0.150
    71.844   682.086     0.150
    73.983   694.746     0.150
    76.192   707.613     0.150
    86.276   760.109     0.150
     0.627    12.109     0.150
     0.627    20.758     0.150
     0.605    12.789     0.150
     0.605    20.844     0.150
     0.958    18.508     0.150
     0.958    32.477     0.150
     1.179    20.828     0.150
     1.179    35.711     0.150
     1.243    24.320     0.150
     1.652    28.922     0.150
     1.652    52.117     0.150
     2.181    36.219     0.150
     2.265    36.117     0.150
     2.412    37.320     0.150
     2.412    67.320     0.150
     2.628    42.469     0.150
     2.628    74.008     0.150
     2.531    41.320     0.150
     2.636    44.117     0.150
     2.857    46.609     0.150
     2.857    79.508     0.150
     3.173    50.383     0.150
     4.278   114.820     0.150
     4.877    74.320     0.150
     5.030    76.922     0.150
     5.434    81.617     0.150
     5.451    82.258     0.150
     5.451   140.914     0.150
     5.624    84.523     0.150
     5.624   149.219     0.150
     5.847    86.820     0.150
     6.098    89.922     0.150
     6.278    93.219     0.150
     6.414    92.820     0.150
     6.834   100.117     0.150
     6.879   100.922     0.150
     6.879   176.422     0.150
     7.073   103.117     0.150
     7.073   181.320     0.150
     7.085   103.422     0.150
     7.295   106.523     0.150
     7.295   186.820     0.150
     7.579   108.180     0.150
     7.652   111.719     0.150
     7.652   194.922     0.150
     8.313   119.719     0.150
     8.557   123.883     0.150
     8.557   217.727     0.150
     8.771   128.617     0.150
     8.771   222.117     0.150
     8.970   128.922     0.150
     9.000   129.117     0.150
     9.422   132.938     0.150
     9.422   230.438     0.150
     9.817   138.648     0.150
     9.817   239.453     0.150
    10.243   144.320     0.150
    10.243   251.422     0.150
    10.820   153.773     0.150
    10.820   265.109     0.150
    11.209   159.922     0.150
    11.209   159.727     0.150
    11.209   282.438     0.150
    12.551   174.609     0.150
    12.954   181.211     0.150
    12.974   180.938     0.150
    12.974   315.844     0.150
    13.140   183.320     0.150
    13.453   186.320     0.150
    13.453   329.320     0.150
    13.629   190.078     0.150
    13.629   332.312     0.150
    13.629   189.617     0.150
    13.932   193.547     0.150
    14.057   195.820     0.150
    14.057   342.617     0.150
    14.880   207.820     0.150
    14.880   214.617     0.150
    14.880   372.719     0.150
    14.880   390.617     0.150
    15.892   219.094     0.150
    16.148   223.266     0.150
    16.148   394.086     0.150
    16.148   223.320     0.150
    16.148   394.023     0.150
    16.148   222.719     0.150
    16.148   397.312     0.150
    19.183   263.320     0.150
    19.517   266.117     0.150
    19.517   483.820     0.150
    19.517   741.617     0.150
    19.517   961.719     0.150
    19.771   268.602     0.150
    19.771   267.539     0.150
    19.771   268.117     0.150
    21.867   291.820     0.150
    21.867   527.219     0.150
    21.867   563.219     0.150
    21.919   292.820     0.150
    21.919   528.117     0.150
    21.919   542.922     0.150
    22.263   295.320     0.150
    22.263   294.891     0.150
    22.350   296.617     0.150
    22.350   536.617     0.150
    22.350   752.617     0.150
    22.477   297.695     0.150
    22.422   296.938     0.150
    22.816   301.016     0.150
    22.816   301.422     0.150
    22.816   301.086     0.150
    22.867   301.422     0.150
    22.867   302.320     0.150
    22.948   303.117     0.150
    22.948   553.195     0.150
    22.948   302.820     0.150
    23.273   305.320     0.150
    23.619   309.820     0.150
    23.643   311.570     0.150
    24.165   314.023     0.150
    24.165   570.523     0.150
    24.664   320.320     0.150
    24.664   320.320     0.150
    25.280   327.117     0.150
    25.280   541.617     0.150
    25.280   588.219     0.150
    25.280   649.320     0.150
    25.280   756.320     0.150
    26.005   331.320     0.150
    26.005   543.922     0.150
    26.005   598.117     0.150
    26.005   757.820     0.150
    26.005   761.719     0.150
    26.386   336.328     0.150
    26.701   337.820     0.150
    26.650   339.477     0.150
    26.663   339.344     0.150
    26.849   340.414     0.150
    26.953   340.922     0.150
    27.110   340.820     0.150
    27.203   620.320     0.150
    27.203   692.820     0.150
    27.319   344.477     0.150
    27.319   543.250     0.150
    27.319   761.898     0.150
    27.397   344.820     0.150
    27.925   350.703     0.150
    27.925   349.820     0.150
    27.925   635.523     0.150
    27.925   716.719     0.150
    28.594   356.320     0.150
    28.594   408.820     0.150
    28.594   546.719     0.150
    28.594   640.617     0.150
    28.594   764.320     0.150
    28.594   768.617     0.150
    28.594   996.320     0.150
    28.645   356.000     0.150
    28.645   358.320     0.150
    28.664   356.023     0.150
    28.991   358.617     0.150
    28.991   358.820     0.150
    28.991   544.320     0.150
    30.876   677.320     0.150
    30.848   376.578     0.150
    30.848   376.023     0.150
    30.942   376.117     0.150
    31.987   386.320     0.150
    31.987   695.117     0.150
    32.105   387.023     0.150
    33.721   400.219     0.150
    34.495   408.422     0.150
    34.495   484.320     0.150
    34.495   734.320     0.150
    34.495   741.820     0.150
    34.495   864.820     0.150
    34.707   408.219     0.150
    34.707   736.719     0.150
    35.193   412.523     0.150
    36.169   422.117     0.150
    36.169   762.719     0.150
    36.365   421.922     0.150
    37.063   429.320     0.150
    37.686   434.422     0.150
    37.760   433.523     0.150
    37.760   518.219     0.150
    37.760   782.523     0.150
    38.070   437.922     0.150
    38.070   437.617     0.150
    38.070   524.422     0.150
    38.070   574.117     0.150
    38.070   786.820     0.150
    38.468   441.570     0.150
    38.821   445.492     0.150
    39.143   447.320     0.150
    39.280   446.719     0.150
    39.280   578.320     0.150
    39.280   800.117     0.150
    41.081   462.758     0.150
    41.081   580.844     0.150
    41.179   464.039     0.150
    41.179   462.922     0.150
    41.179   809.922     0.150
    41.154   462.820     0.150
    41.154   462.852     0.150
    41.154   559.062     0.150
    41.163   462.594     0.150
    41.163    10.758     0.150
    41.163   558.438     0.150
    42.149   471.617     0.150
    42.149   569.820     0.150
    42.321   474.547     0.150
    42.375   474.023     0.150
    42.716   473.320     0.150
    42.859   478.828     0.150
    42.859   477.719     0.150
    43.436   482.297     0.150
    43.488   482.422     0.150
    43.681   483.820     0.150
    43.835   866.820     0.150
    43.835  1075.820     0.150
    44.267   488.117     0.150
    44.357   489.023     0.150
    44.898   494.617     0.150
    44.898   494.422     0.150
    45.122   496.617     0.150
    45.202   496.594     0.150
    45.202   496.820     0.150
    45.281   494.617     0.150
    45.434   498.523     0.150
    45.434   896.320     0.150
    45.456   498.922     0.150
    45.543   498.922     0.150
    45.980     9.500     0.150
    45.980   597.523     0.150
    45.980   607.719     0.150
    45.980   902.219     0.150
    45.991   503.219     0.150
    46.632   507.117     0.150
    46.632   598.719     0.150
    46.763   509.320     0.150
    47.031   510.914     0.150
    47.031   511.117     0.150
    47.103   510.922     0.150
    47.629   516.922     0.150
    47.729   515.422     0.150
    47.948   518.031     0.150
    48.016   519.023     0.150
    48.164   519.422     0.150
    48.164   931.719     0.150
    48.192   519.820     0.150
    48.557   521.930     0.150
    48.557   523.523     0.150
    48.574   522.094     0.150
    48.574   522.617     0.150
    48.770   524.320     0.150
    48.867   523.352     0.150
    49.115   526.312     0.150
    49.187   526.711     0.150
    49.287   528.219     0.150
    49.332   528.523     0.150
    49.332     7.297     0.150
    49.332   951.922     0.150
    49.478   528.422     0.150
    49.478   953.320     0.150
    49.480   528.539     0.150
    49.527   530.023     0.150
    49.527     6.797     0.150
    49.740   532.328     0.150
    49.911   533.117     0.150
    50.017   534.328     0.150
    50.099   534.492     0.150
    50.173   534.867     0.150
    50.173    10.086     0.150
    50.367   535.703     0.150
    50.401   537.250     0.150
    50.447   537.523     0.150
    50.490   537.523     0.150
    50.490   969.117     0.150
    50.743   539.492     0.150
    50.766   538.969     0.150
    50.766   973.398     0.150
    50.766  1192.070     0.150
    50.829   539.469     0.150
    50.829   976.320     0.150
    50.873   539.922     0.150
    50.916   538.492     0.150
    51.013   541.164     0.150
    51.111   541.820     0.150
    51.111   541.305     0.150
    51.170   541.820     0.150
    51.170   541.422     0.150
    51.199   543.117     0.150
    51.243   542.547     0.150
    51.243   541.820     0.150
    51.400   543.320     0.150
    51.400   662.320     0.150
    51.494   544.000     0.150
    51.586   544.828     0.150
    51.628   545.719     0.150
    51.624   546.617     0.150
    51.798   547.320     0.150
    51.820   546.719     0.150
    51.820   992.117     0.150
    51.862   547.117     0.150
    51.894   547.820     0.150
    52.012   548.820     0.150
    52.182   549.711     0.150
    52.319   551.219     0.150
    52.373   549.820     0.150
    52.420   550.617     0.150
    52.420   550.344     0.150
    52.655   553.820     0.150
    52.655  1008.617     0.150
    52.655   553.820     0.150
    52.655  1008.617     0.150
    52.897   555.117     0.150
    53.003   555.922     0.150
    53.177   557.461     0.150
    53.177   556.820     0.150
    53.495   559.648     0.150
    53.832   561.219     0.150
    54.081   564.008     0.150
    54.217   566.062     0.150
    54.431   566.820     0.150
    54.566   567.820     0.150
    54.967   570.023     0.150
    55.134   571.422     0.150
    55.356  1043.258     0.150
    55.786   575.820     0.150
    55.773   575.023     0.150
    55.924   576.812     0.150
    56.075   577.117     0.150
    56.130   577.922     0.150
    56.273   579.422     0.150
    56.282   579.422     0.150
    56.413   580.414     0.150
    56.413    10.586     0.150
    56.709   580.648     0.150
    56.754   582.023     0.150
    56.837   583.117     0.150
    57.098   585.219     0.150
    57.417   585.922     0.150
    57.841   590.508     0.150
    57.846   590.117     0.150
    58.015   590.922     0.150
    58.148   591.820     0.150
    58.310   593.023     0.150
    58.598   595.523     0.150
    59.194   599.719     0.150
    59.629   602.719     0.150
    59.805   603.016     0.150
    59.907   605.320     0.150
    60.176   605.617     0.150
    60.366   607.117     0.150
    60.533   608.820     0.150
    60.693   609.219     0.150
    60.701   609.523     0.150
    60.821   611.758     0.150
    61.047   612.820     0.150
    61.047   655.719     0.150
    61.305   614.562     0.150
    61.579   616.680     0.150
    61.830   617.219     0.150
    62.010   619.320     0.150
    62.268   620.117     0.150
    62.316   620.320     0.150
    62.576   624.094     0.150
    64.782   638.383     0.150
    65.138   639.523     0.150
    65.150   640.578     0.150
    65.324   640.758     0.150
    65.282   641.539     0.150
    65.484   642.562     0.150
    65.484   641.758     0.150
    65.496   641.750     0.150
    65.687   644.102     0.150
    65.893   644.477     0.150
    66.215   646.141     0.150
    66.468   647.352     0.150
    66.700   649.523     0.150
    67.131   653.023     0.150
    67.779   657.617     0.150
    67.779  1195.523     0.150
    67.906   658.422     0.150
    67.944   658.219     0.150
    68.025   658.789     0.150
    68.207   659.727     0.150
    68.267   660.422     0.150
    68.398   660.922     0.150
    68.398  1202.219     0.150
    68.693   663.422     0.150
    68.833   664.219     0.150
    68.833   663.820     0.150
    68.926   664.617     0.150
    69.740   669.820     0.150
    71.935   682.070     0.150
    72.584   689.617     0.150
    72.823   687.047     0.150
    73.429   691.953     0.150
    73.874   693.703     0.150
    73.883   693.523     0.150
    75.474   703.117     0.150
    76.083   706.219     0.150
    76.989   712.117     0.150
    77.468   714.023     0.150
    77.816   715.797     0.150
    77.991   716.617     0.150
    78.128   717.727     0.150
    78.280   718.688     0.150
    78.425   720.922     0.150
    78.572   719.859     0.150
    79.770   726.914     0.150
    80.160   728.922     0.150
    80.357   729.867     0.150
    80.647   731.289     0.150
    80.715   733.023     0.150
    80.771   732.719     0.150
    80.787   732.117     0.150
    80.869   733.320     0.150
    81.205   734.469     0.150
    81.887   738.430     0.150
    82.001   739.281     0.150
    82.003   739.453     0.150
    82.044   739.617     0.150
    82.645   742.320     0.150
    84.530   752.797     0.150
    85.751   759.023     0.150
    86.334   759.969     0.150
    86.599   761.617     0.150
    86.599   760.797     0.150
    87.886   768.008     0.150
    89.190   775.344     0.150
    89.463   775.891     0.150
    92.651   791.719     0.150
    95.598   804.547     0.150
   120.046  1130.492     0.150
   140.940  1169.695     0.150
   146.084  1180.094     0.150
   146.084  1179.523     0.150
   146.658  1180.641     0.150
   153.006  1195.945     0.150
     0.577    11.230     0.150
     0.577    18.422     0.150
     0.643    11.160     0.150
     0.643    19.961     0.150
     1.121    24.359     0.150
     1.121    36.961     0.150
     1.303    24.090     0.150
     1.303    40.723     0.150
     1.504    29.699     0.150
     1.504    48.902     0.150
     1.528    27.762     0.150
     2.101    35.961     0.150
     2.222    38.980     0.150
     2.297    39.562     0.150
     2.297    69.359     0.150
     2.406    39.961     0.150
     2.518    43.359     0.150
     2.621    44.160     0.150
     2.621    75.371     0.150
     2.852    46.949     0.150
     2.852    82.391     0.150
     4.911    77.062     0.150
     5.413    81.723     0.150
     5.413   140.383     0.150
     5.977    90.961     0.150
     5.977   156.961     0.150
    16.131   224.637     0.150
    19.735   269.230     0.150
    22.754   302.422     0.150
    23.473   309.262     0.150
    24.569   321.160     0.150
    24.569   321.160     0.150
    27.373   347.000     0.150
    41.042   462.762     0.150
    48.494   523.586     0.150
    52.322   551.262     0.150
    52.322   551.562     0.150
    71.814   682.484     0.150
    73.992   695.672     0.150
    76.199   708.461     0.150
    80.596   733.512     0.150
     0.327     6.488     0.150
     0.327    11.590     0.150
     1.350    24.129     0.150
     1.350    41.129     0.150
     1.255    24.949     0.150
     1.255    41.059     0.150
     1.821    34.879     0.150
     2.115    39.629     0.150
     2.521    45.328     0.150
     2.521    75.930     0.150
     2.533    77.129     0.150
     3.379    55.129     0.150
     3.497    55.828     0.150
     3.497    97.027     0.150
     3.490    65.008     0.150
     3.490   105.750     0.150
     3.848    59.488     0.150
     3.848   105.070     0.150
    10.402   150.820     0.150
    12.360   175.680     0.150
    12.624   179.938     0.150
    16.388   233.648     0.150
    16.388   230.129     0.150
    16.388   405.629     0.150
    20.139   272.930     0.150
    21.606   290.230     0.150
    23.349   307.730     0.150
    23.727   310.328     0.150
    27.042   343.281     0.150
    49.209   527.430     0.150
    72.756   688.324     0.150
    73.018   688.812     0.150
    75.237   701.527     0.150
    86.612   761.699     0.150
     0.653    12.070     0.150
     0.653    21.730     0.150
     2.646    43.941     0.150
     2.670    44.281     0.150
     2.754    46.230     0.150
     2.754    78.730     0.150
     3.085    49.512     0.150
     3.259    52.980     0.150
     3.259    90.789     0.150
     3.302    51.449     0.150
     3.302    88.352     0.150
     3.374    61.930     0.150
     3.374   106.531     0.150
     3.580    58.402     0.150
     3.580    99.719     0.150
     3.881    62.332     0.150
     3.881   106.629     0.150
     4.135    62.832     0.150
     4.135   111.332     0.150
     4.543    70.031     0.150
     4.543   120.930     0.150
     5.095    77.430     0.150
     5.095   133.730     0.150
     5.336    80.832     0.150
     5.336   140.031     0.150
     5.348    80.629     0.150
     5.348   140.129     0.150
     5.576    84.430     0.150
     5.576   144.930     0.150
     5.929    88.930     0.150
     5.929   153.531     0.150
     6.575    97.332     0.150
     6.575   168.430     0.150
     7.123   102.719     0.150
     7.123   178.340     0.150
     7.239   106.629     0.150
     7.239   184.332     0.150
     7.288   107.629     0.150
     7.288   184.629     0.150
     8.321   125.980     0.150
     8.321   218.242     0.150
    10.035   142.531     0.150
    12.608   175.730     0.150
    12.608   309.730     0.150
    12.960   183.242     0.150
    13.111   185.180     0.150
    16.850   236.230     0.150
    16.850   235.699     0.150
    20.734   279.898     0.150
    20.704   279.262     0.150
    20.704   277.680     0.150
    24.044   314.469     0.150
    24.174   315.465     0.150
    24.512   320.219     0.150
    26.230   335.629     0.150
    26.230   335.629     0.150
    26.982   342.910     0.150
    40.173   456.359     0.150
    47.000   510.559     0.150
    49.974   533.902     0.150
    52.739   554.273     0.150
    65.988   645.980     0.150
    72.136   683.250     0.150
    78.726   720.816     0.150
     0.530     8.816     0.150
     0.658    12.668     0.150
     2.142    39.828     0.150
     2.142    67.156     0.150
     2.716    77.855     0.150
     2.716    85.957     0.150
     2.716    86.176     0.150
     2.844    46.617     0.150
     2.844    55.617     0.150
     2.844    79.117     0.150
     3.015    48.848     0.150
     3.015    82.227     0.150
     3.025    49.117     0.150
     3.176    50.668     0.150
     3.176    87.148     0.150
     3.670    56.148     0.150
     3.670    96.477     0.150
     3.849    61.016     0.150
     3.849   104.316     0.150
     4.225   111.629     0.150
     4.498    69.719     0.150
     4.498   119.617     0.150
     4.778    72.617     0.150
     5.052    77.016     0.150
     5.052   131.918     0.150
     5.100    77.918     0.150
     5.100   132.719     0.150
     5.292    80.418     0.150
     5.292   138.719     0.150
     5.304    80.117     0.150
     5.304   137.918     0.150
     5.525    84.117     0.150
     5.525   143.418     0.150
     5.880    88.516     0.150
     5.880   151.816     0.150
     5.970    88.656     0.150
     5.970   152.516     0.150
     6.532    96.516     0.150
     6.532   167.719     0.150
     6.805   102.816     0.150
     7.196   103.996     0.150
     7.196   181.469     0.150
     7.192   106.418     0.150
     7.192   183.418     0.150
     7.236   107.117     0.150
     7.236   184.418     0.150
     7.880   116.117     0.150
     7.880   203.617     0.150
     9.722   138.309     0.150
     9.628   139.516     0.150
    10.010   143.418     0.150
    10.339   148.496     0.150
    12.667   176.117     0.150
    12.667   312.617     0.150
    12.935   183.117     0.150
    13.090   185.586     0.150
    16.792   235.488     0.150
    16.792   233.727     0.150
    20.694   280.090     0.150
    20.656   277.855     0.150
    24.013   313.930     0.150
    24.114   315.336     0.150
    24.510   319.855     0.150
    26.227   334.617     0.150
    26.227   334.617     0.150
    26.894   342.516     0.150
    42.879   477.242     0.150
    49.954   533.742     0.150
    58.036   593.117     0.150
    58.046   593.219     0.150
    58.183   593.418     0.150
    58.264   594.219     0.150
    59.769   603.719     0.150
    59.900   605.016     0.150
    60.064   606.617     0.150
    72.107   684.242     0.150
    73.569   692.754     0.150
    78.653   720.766     0.150
     0.687    22.629     0.150
     0.783    15.027     0.150
     1.973    33.027     0.150
     2.212    38.289     0.150
     2.212    65.738     0.150
     2.871    46.016     0.150
     2.871    80.848     0.150
     3.057    49.988     0.150
     3.126    48.527     0.150
     3.157    51.629     0.150
     3.147    51.527     0.150
     3.460    55.008     0.150
     3.460    93.977     0.150
     3.531    56.629     0.150
     3.768    58.828     0.150
     3.768    59.629     0.150
     4.371    67.828     0.150
     4.506    67.879     0.150
     4.506   119.066     0.150
     4.932    75.227     0.150
     4.968    75.629     0.150
     5.006    75.527     0.150
     5.166    78.828     0.150
     5.179    78.527     0.150
     5.262   141.027     0.150
     5.376    81.027     0.150
     5.376    82.227     0.150
     6.406    94.426     0.150
     6.406   165.227     0.150
     6.785    99.027     0.150
     6.785   172.527     0.150
     7.056   104.328     0.150
     7.080   104.328     0.150
     7.080   182.227     0.150
     7.432   107.988     0.150
     7.432   187.438     0.150
     7.767   112.629     0.150
     7.998   203.527     0.150
     8.099   203.527     0.150
     8.642   130.219     0.150
     9.397   136.828     0.150
     9.397   238.328     0.150
     9.950   141.598     0.150
    10.466   148.605     0.150
    10.488   267.016     0.150
    11.203   157.527     0.150
    11.220   158.527     0.150
    11.801   167.309     0.150
    11.801   290.355     0.150
    12.254   171.539     0.150
    12.433   176.777     0.150
    12.511   176.066     0.150
    12.511   176.637     0.150
    12.750   179.289     0.150
    12.750   311.688     0.150
    12.855   181.246     0.150
    12.855   180.926     0.150
    12.855   315.707     0.150
    12.860   179.027     0.150
    13.023   182.266     0.150
    13.058   183.129     0.150
    13.058   318.816     0.150
    13.131   188.887     0.150
    13.220   186.918     0.150
    13.238   185.758     0.150
    13.218   185.527     0.150
    13.474   191.027     0.150
    13.474   190.059     0.150
    13.474   339.266     0.150
    13.502   193.789     0.150
    13.819   195.906     0.150
    14.769   207.527     0.150
    14.769   214.527     0.150
    14.769   370.527     0.150
    14.769   387.527     0.150
    15.055   369.168     0.150
    16.607   229.789     0.150
    16.607   409.129     0.150
    16.607   228.527     0.150
    16.607   409.039     0.150
    18.400   256.129     0.150
    18.400   455.527     0.150
    19.910   270.828     0.150
    20.178   273.328     0.150
    20.178   292.527     0.150
    20.178   498.328     0.150
    20.361   275.227     0.150
    20.361   275.629     0.150
    20.361   276.137     0.150
    20.502   276.828     0.150
    20.502   276.227     0.150
    20.502   276.688     0.150
    20.502   276.461     0.150
    20.474   276.926     0.150
    20.474   279.926     0.150
    20.474   500.227     0.150
    20.474   531.727     0.150
    20.509   278.129     0.150
    20.509   502.129     0.150
    20.509   532.227     0.150
    20.564   280.867     0.150
    20.578   279.059     0.150
    20.578   278.879     0.150
    20.578   530.227     0.150
    20.578   745.777     0.150
    21.388   289.828     0.150
    21.388   287.527     0.150
    21.624   292.578     0.150
    21.842   293.309     0.150
    21.983   297.566     0.150
    22.110   298.465     0.150
    22.316   299.969     0.150
    22.460   302.555     0.150
    22.842   303.828     0.150
    23.234   305.527     0.150
    23.457   537.426     0.150
    23.457   606.527     0.150
    23.457   755.328     0.150
    23.911   312.516     0.150
    23.922   312.879     0.150
    23.922   312.551     0.150
    23.966   314.227     0.150
    23.966   313.027     0.150
    23.966   313.957     0.150
    23.966   312.664     0.150
    24.468   575.629     0.150
    24.497   318.656     0.150
    24.683   319.027     0.150
    24.683   350.828     0.150
    24.683   582.828     0.150
    25.156   324.348     0.150
    26.214   333.309     0.150
    26.203   333.727     0.150
    26.481   338.129     0.150
    26.617   338.527     0.150
    26.617   542.789     0.150
    27.011   344.328     0.150
    27.011   345.012     0.150
    27.131   344.227     0.150
    27.400   346.527     0.150
    27.400   393.926     0.150
    27.400   545.828     0.150
    27.400   624.727     0.150
    27.400   701.328     0.150
    27.400   763.629     0.150
    28.238   353.258     0.150
    28.521   355.727     0.150
    28.697   357.469     0.150
    28.966   360.727     0.150
    28.966   652.727     0.150
    28.966   658.227     0.150
    29.283   653.527     0.150
    29.954   370.227     0.150
    29.954   666.828     0.150
    30.281   372.266     0.150
    30.271   370.227     0.150
    30.271   668.426     0.150
    30.338   373.027     0.150
    30.338   428.328     0.150
    30.338   768.828     0.150
    30.338   371.598     0.150
    30.338   372.328     0.150
    30.550   375.926     0.150
    30.550   376.227     0.150
    30.716   374.828     0.150
    30.724   374.926     0.150
    30.724   678.129     0.150
    30.753   376.898     0.150
    30.800   377.926     0.150
    31.608   384.129     0.150
    32.711   394.828     0.150
    32.711   458.129     0.150
    32.711   558.227     0.150
    32.711   393.887     0.150
    33.396   400.629     0.150
    34.845   410.328     0.150
    34.845   740.828     0.150
    35.012   413.629     0.150
    35.012   743.727     0.150
    35.258   415.129     0.150
    35.315   415.828     0.150
    35.315   415.566     0.150
    35.445   417.227     0.150
    36.492   425.117     0.150
    36.568   424.027     0.150
    36.568   506.227     0.150
    36.568   762.926     0.150
    36.611   427.207     0.150
    36.787   428.527     0.150
    37.039   430.168     0.150
    37.041   430.566     0.150
    38.023   524.926     0.150
    38.023   785.828     0.150
    38.747   440.926     0.150
    38.810   443.688     0.150
    39.041   445.426     0.150
    39.041   446.227     0.150
    39.126   447.152     0.150
    39.392   451.527     0.150
    39.417   448.926     0.150
    39.724   452.828     0.150
    39.724   814.129     0.150
    39.806   579.078     0.150
    39.806   807.078     0.150
    40.757   460.129     0.150
    40.760   460.129     0.150
    41.056   462.828     0.150
    41.056   554.828     0.150
    41.056   583.027     0.150
    41.056   835.027     0.150
    41.428   466.328     0.150
    42.689   476.926     0.150
    42.789   476.527     0.150
    42.932   477.855     0.150
    42.932   478.227     0.150
    42.941   479.129     0.150
    43.169   481.629     0.150
    43.684   486.328     0.150
    44.177   490.227     0.150
    44.231   490.129     0.150
    44.231   490.926     0.150
    44.420   490.527     0.150
    44.720   494.727     0.150
    44.958   496.129     0.150
    44.958   495.418     0.150
    45.040   898.426     0.150
    45.114   498.129     0.150
    45.156   495.328     0.150
    45.197   497.617     0.150
    45.194   499.227     0.150
    45.213   498.527     0.150
    45.269   498.926     0.150
    45.282   498.066     0.150
    45.350   499.426     0.150
    45.494   500.207     0.150
    45.589   501.086     0.150
    45.734   502.328     0.150
    45.882   500.027     0.150
    46.084   505.926     0.150
    46.157   505.426     0.150
    46.170   504.828     0.150
    46.415   508.027     0.150
    46.434   509.426     0.150
    46.787   510.227     0.150
    46.938   511.629     0.150
    46.951   512.527     0.150
    46.967   513.328     0.150
    46.967   512.926     0.150
    47.006   512.129     0.150
    47.006   511.727     0.150
    47.006   512.926     0.150
    47.042   512.348     0.150
    47.042   512.047     0.150
    47.083   513.227     0.150
    47.253   514.828     0.150
    47.253   626.027     0.150
    47.253  1128.027     0.150
    47.271   514.727     0.150
    47.372   513.719     0.150
    47.758   518.629     0.150
    47.806   520.328     0.150
    47.955   519.328     0.150
    48.115   520.039     0.150
    48.116   518.602     0.150
    48.356   520.355     0.150
    48.454   523.828     0.150
    48.571   524.527     0.150
    48.861   526.129     0.150
    48.898   526.629     0.150
    48.951   526.328     0.150
    48.951   525.387     0.150
    49.492   530.129     0.150
    49.492   529.426     0.150
    49.551   531.527     0.150
    49.836   533.527     0.150
    49.966   534.129     0.150
    50.250   536.828     0.150
    50.359   537.129     0.150
    50.359   538.629     0.150
    50.384   536.516     0.150
    50.453   536.418     0.150
    50.996   543.328     0.150
    51.050   543.426     0.150
    51.119   543.426     0.150
    51.126   543.629     0.150
    51.522   546.578     0.150
    51.522   546.227     0.150
    51.568   546.426     0.150
    51.570   546.402     0.150
    51.720   547.828     0.150
    51.854   548.875     0.150
    52.101   550.277     0.150
    52.191   551.477     0.150
    52.223   551.707     0.150
    52.237   552.926     0.150
    52.244   552.055     0.150
    52.614   553.879     0.150
    52.614     1.348     0.150
    52.645   554.332     0.150
    52.646   554.336     0.150
    52.924   556.188     0.150
    52.980   557.027     0.150
    53.032   556.586     0.150
    53.103   557.527     0.150
    53.103     2.102     0.150
    53.177   558.527     0.150
    53.202   560.328     0.150
    53.613   562.926     0.150
    53.958   562.066     0.150
    54.002   562.629     0.150
    54.002   563.078     0.150
    54.011   565.629     0.150
    54.455   567.926     0.150
    54.455   567.926     0.150
    54.483   567.219     0.150
    54.513   568.074     0.150
    54.830   569.520     0.150
    55.040   572.215     0.150
    55.130   571.555     0.150
    55.662   575.996     0.150
    56.156   580.508     0.150
    56.264   581.227     0.150
    56.418   582.836     0.150
    56.418   583.227     0.150
    56.766   584.527     0.150
    56.819   584.227     0.150
    57.207   586.727     0.150
    57.400   588.629     0.150
    57.592   589.129     0.150
    57.718   592.406     0.150
    57.883   592.926     0.150
    57.891   591.227     0.150
    57.971   594.328     0.150
    57.994   592.629     0.150
    58.051   595.328     0.150
    58.069   592.426     0.150
    58.093   593.227     0.150
    58.119   593.727     0.150
    58.128   593.828     0.150
    58.270   593.926     0.150
    58.340   594.828     0.150
    58.404   596.828     0.150
    58.486   595.828     0.150
    58.619   596.426     0.150
    58.632   598.559     0.150
    58.624   596.051     0.150
    58.645   596.828     0.150
    58.847   598.426     0.150
    58.884   598.527     0.150
    59.082   598.527     0.150
    59.277   601.828     0.150
    59.663  1321.926     0.150
    59.686   604.129     0.150
    59.690   603.328     0.150
    59.696   604.129     0.150
    59.843   604.727     0.150
    59.972   605.527     0.150
    60.137   606.629     0.150
    60.150   608.328     0.150
    60.454   609.629     0.150
    60.461   609.926     0.150
    60.904   659.129     0.150
    60.904  1340.926     0.150
    60.904   612.426     0.150
    61.024   613.227     0.150
    61.473   616.527     0.150
    61.795   618.527     0.150
    61.972   619.828     0.150
    62.160   620.828     0.150
    62.375   622.426     0.150
    62.499   622.328     0.150
    62.514   622.527     0.150
    63.199   627.727     0.150
    63.626   630.227     0.150
    63.869   632.629     0.150
    64.060   632.828     0.150
    64.267   635.227     0.150
    65.303   643.129     0.150
    66.283   648.727     0.150
    67.361   654.602     0.150
    67.361   655.379     0.150
    67.685   657.227     0.150
    69.383   667.727     0.150
    69.642   671.129     0.150
    70.148   673.527     0.150
    70.805   678.426     0.150
    72.021   682.777     0.150
    72.029   683.766     0.150
    72.193   684.566     0.150
    73.782   693.137     0.150
    74.260   696.527     0.150
    75.683   705.207     0.150
    75.956   706.027     0.150
    77.731   716.316     0.150
    77.836   717.457     0.150
    78.075   717.828     0.150
    78.110   719.629     0.150
    78.222   718.676     0.150
    78.422   719.828     0.150
    78.422   895.777     0.150
    78.590   720.953     0.150
    78.590   721.078     0.150
    78.642   721.078     0.150
    79.929   728.316     0.150
    80.077   729.949     0.150
    80.156   729.828     0.150
    80.214   730.426     0.150
    80.604   731.527     0.150
    80.735   735.148     0.150
    80.743   733.301     0.150
    80.743   733.926     0.150
    80.954   733.398     0.150
    81.752   738.328     0.150
    81.752   740.129     0.150
    81.886   739.617     0.150
    81.935   739.629     0.150
    81.935   740.176     0.150
    82.537   742.328     0.150
    82.590   744.129     0.150
    82.691   744.727     0.150
    82.904   744.727     0.150
    84.792   753.227     0.150
    84.792   753.027     0.150
    84.792   754.078     0.150
    86.822   762.672     0.150
    90.874   783.227     0.150
   118.171  1128.547     0.150
   120.644  1132.527     0.150
   148.001  1187.051     0.150
   148.001  1182.699     0.150
   148.016  1185.668     0.150
   154.187  1199.379     0.150
     0.676    12.480     0.150
     0.676    21.480     0.150
     1.159    24.980     0.150
     1.159    43.480     0.150
     1.564    30.309     0.150
     1.564    50.121     0.150
     2.269    41.582     0.150
     2.269    69.781     0.150
     2.353    41.379     0.150
     2.442    45.480     0.150
     2.442    75.480     0.150
     3.571    95.320     0.150
     3.754    60.340     0.150
     3.754   100.781     0.150
    11.992   170.574     0.150
    11.992   302.906     0.150
    16.095   224.312     0.150
    16.095   396.715     0.150
    19.613   268.922     0.150
    22.562   299.824     0.150
    22.740   302.570     0.150
    23.437   310.262     0.150
    27.315   346.324     0.150
    48.491   522.805     0.150
    71.868   682.941     0.150
    78.288   719.211     0.150
    86.276   761.277     0.150
     0.391    11.945     0.150
     2.185    38.641     0.150
     2.185    66.375     0.150
     2.778    46.445     0.150
     3.105    49.844     0.150
     3.206    52.641     0.150
     3.206    91.344     0.150
     3.472   113.445     0.150
     3.405    56.141     0.150
     3.405    95.742     0.150
     3.865    72.641     0.150
     4.052    63.445     0.150
     4.052   110.242     0.150
     4.340    69.352     0.150
     4.605    71.641     0.150
     4.605   123.742     0.150
     4.735    80.844     0.150
     4.654    71.945     0.150
     4.845    75.641     0.150
     4.858    74.547     0.150
     4.858   130.641     0.150
     5.083    78.242     0.150
     5.436    82.844     0.150
     5.436   143.141     0.150
     6.085    91.141     0.150
     6.085   158.445     0.150
     6.747   100.445     0.150
     6.795   101.445     0.150
     7.252   108.242     0.150
     7.700   110.688     0.150
     8.060   118.742     0.150
     8.327   122.547     0.150
     8.327   211.844     0.150
     8.361   221.242     0.150
    12.795   315.844     0.150
    16.980   238.180     0.150
    20.247   275.570     0.150
    20.810   281.367     0.150
    24.326   317.789     0.150
    24.290   317.328     0.150
    26.624   339.375     0.150
    26.807   342.336     0.150
    43.313   482.914     0.150
    45.571   500.641     0.150
    47.390   515.023     0.150
    50.305   537.547     0.150
    58.479   596.445     0.150
    58.489   596.445     0.150
    71.663   681.781     0.150
    73.979   696.453     0.150
     0.552    11.303     0.150
     0.575    10.662     0.150
     0.575    16.871     0.150
     0.649    13.602     0.150
     0.649    21.402     0.150
     0.957    17.432     0.150
     1.087    19.922     0.150
     1.087    33.463     0.150
     1.585    30.842     0.150
     1.857    33.912     0.150
     1.857    58.553     0.150
     2.290    40.133     0.150
     2.290    68.062     0.150
     2.646    44.002     0.150
     2.646    76.002     0.150
     2.627    45.092     0.150
     2.627    75.422     0.150
     2.819    47.582     0.150
     2.858    47.332     0.150
     2.893    49.602     0.150
     2.983    49.781     0.150
     2.983    83.082     0.150
     3.145    56.133     0.150
     3.228    51.031     0.150
     3.228    88.133     0.150
     3.228    90.133     0.150
     3.275    56.803     0.150
     3.275   105.201     0.150
     3.474    55.152     0.150
     3.474    95.441     0.150
     3.779    58.072     0.150
     3.779   103.361     0.150
     3.796    59.902     0.150
     3.796   103.502     0.150
     3.970    62.102     0.150
     3.970   108.602     0.150
     4.290    65.002     0.150
     4.290   115.502     0.150
     4.664    70.002     0.150
     4.664   123.002     0.150
     5.193    78.201     0.150
     5.193   137.002     0.150
     5.247    78.902     0.150
     5.247   137.701     0.150
     5.435    81.303     0.150
     5.435   142.201     0.150
     5.448    81.502     0.150
     5.448   142.803     0.150
     5.680    85.002     0.150
     5.680   147.902     0.150
     6.032    89.902     0.150
     6.032   156.002     0.150
     6.684    99.803     0.150
     6.674    98.002     0.150
     6.674   171.902     0.150
     6.808   100.291     0.150
     6.808   173.213     0.150
     7.340   107.402     0.150
     7.340   187.502     0.150
     7.394   108.701     0.150
     7.394   188.102     0.150
     7.750   114.102     0.150
     7.750   198.002     0.150
     8.448   120.592     0.150
     8.264   124.422     0.150
     8.264   218.312     0.150
     9.606   136.541     0.150
     9.819   142.303     0.150
    10.012   140.502     0.150
    10.204   146.432     0.150
    12.583   175.002     0.150
    12.583   308.002     0.150
    12.659   177.002     0.150
    13.324   187.922     0.150
    13.337   190.033     0.150
    13.337   331.223     0.150
    13.337   190.473     0.150
    13.543   193.053     0.150
    15.061   209.281     0.150
    15.061   367.381     0.150
    15.061   209.082     0.150
    15.061   367.963     0.150
    15.139   216.102     0.150
    15.139   221.803     0.150
    15.139   392.303     0.150
    16.874   236.160     0.150
    16.874   413.389     0.150
    16.874   236.562     0.150
    16.874   235.053     0.150
    16.874   413.781     0.150
    16.874   233.678     0.150
    18.877   258.803     0.150
    18.877   263.102     0.150
    20.618   280.053     0.150
    20.623   278.006     0.150
    20.623   277.826     0.150
    20.627   280.502     0.150
    20.627   287.701     0.150
    20.627   291.502     0.150
    20.627   504.303     0.150
    20.627   515.402     0.150
    20.627   535.201     0.150
    20.712   278.795     0.150
    20.829   281.592     0.150
    20.829   280.902     0.150
    20.986   283.303     0.150
    23.622   310.238     0.150
    23.622   310.723     0.150
    23.868   313.701     0.150
    24.028   314.299     0.150
    24.028   314.412     0.150
    24.082   315.781     0.150
    24.201   316.002     0.150
    24.201   315.102     0.150
    24.461   319.088     0.150
    24.461   319.463     0.150
    24.937   322.002     0.150
    25.604   328.893     0.150
    26.178   334.311     0.150
    26.178   334.072     0.150
    27.068   342.562     0.150
    27.879   401.602     0.150
    27.879   547.902     0.150
    27.879   633.002     0.150
    27.879   642.803     0.150
    27.879   712.102     0.150
    27.879   766.102     0.150
    27.879   996.201     0.150
    32.303   388.652     0.150
    38.501   441.102     0.150
    38.501   532.803     0.150
    38.501   794.201     0.150
    38.771   444.662     0.150
    40.284   456.502     0.150
    40.284   456.502     0.150
    42.479   474.502     0.150
    42.785   476.582     0.150
    42.794   476.701     0.150
    43.974   488.002     0.150
    44.028   488.502     0.150
    44.512   492.303     0.150
    44.512   492.723     0.150
    45.085   496.303     0.150
    45.097   496.191     0.150
    45.142   496.502     0.150
    45.153   495.102     0.150
    45.435   498.902     0.150
    46.743   508.502     0.150
    46.773   509.902     0.150
    46.949   509.582     0.150
    46.949   510.102     0.150
    49.942   533.281     0.150
    49.942   612.402     0.150
    50.197   535.291     0.150
    51.043   542.902     0.150
    52.755   554.781     0.150
    53.956   562.201     0.150
    53.956   562.422     0.150
    55.481   572.963     0.150
    55.556   574.213     0.150
    57.038   585.402     0.150
    57.381   587.922     0.150
    57.719   589.701     0.150
    57.784   590.402     0.150
    57.924   592.002     0.150
    57.934   592.002     0.150
    58.069   591.902     0.150
    58.156   593.102     0.150
    58.345   594.002     0.150
    58.335   593.902     0.150
    58.408   594.402     0.150
    58.479   595.102     0.150
    59.498   602.303     0.150
    59.537   602.291     0.150
    59.663   603.201     0.150
    59.795   603.502     0.150
    59.958   605.002     0.150
    60.842   611.602     0.150
    61.280   614.201     0.150
    61.814   617.602     0.150
    62.339   621.002     0.150
    62.340   620.902     0.150
    62.994   626.002     0.150
    63.469   628.803     0.150
    63.664   630.803     0.150
    63.905   631.502     0.150
    63.955   631.502     0.150
    67.103   652.191     0.150
    67.138   652.902     0.150
    72.221   683.451     0.150
    72.223   683.602     0.150
    73.387   691.021     0.150
    74.436   696.352     0.150
    75.558   704.062     0.150
    76.340   707.643     0.150
    78.177   717.932     0.150
    78.775   720.652     0.150
    78.903   721.982     0.150
    80.997   734.252     0.150
    80.997   734.342     0.150
    82.130   740.602     0.150
    82.140   739.602     0.150
    88.427   771.402     0.150
   147.672  1182.871     0.150
     0.476     8.051     0.150
     0.476    16.250     0.150
     2.103    37.600     0.150
     2.103    62.551     0.150
     3.383    55.150     0.150
     3.383   106.150     0.150
     3.777    67.350     0.150
     3.777   115.350     0.150
     4.251    68.270     0.150
     4.251   111.850     0.150
     4.724    70.150     0.150
     7.156   102.061     0.150
     7.156   179.090     0.150
     7.162   104.850     0.150
     7.788   196.930     0.150
     8.237   118.650     0.150
     8.237   211.150     0.150
     9.314   237.961     0.150
    12.543   172.650     0.150
    15.388   213.121     0.150
    16.931   234.311     0.150
    16.931   234.281     0.150
    20.750   278.801     0.150
    20.839   279.340     0.150
    24.243   315.320     0.150
    24.243   315.350     0.150
    24.254   314.861     0.150
    24.822   321.080     0.150
    26.539   336.631     0.150
    26.811   339.551     0.150
    39.861   451.611     0.150
    39.861   451.607     0.150
    43.223   479.150     0.150
    45.488   497.750     0.150
    47.306   511.900     0.150
    50.227   534.721     0.150
    58.389   594.150     0.150
    58.399   594.250     0.150
    60.250   605.951     0.150
    61.300   613.551     0.150
    67.617   654.840     0.150
    73.980   692.900     0.150
    73.902   692.051     0.150
    78.709   720.201     0.150
    82.643   743.051     0.150
    87.142   763.250     0.150
     0.503    17.062     0.150
     0.606    19.363     0.150
     1.761    32.645     0.150
     1.761    34.164     0.150
     1.761    54.664     0.150
     1.761    55.633     0.150
     2.724    45.273     0.150
     2.724    78.125     0.150
     2.826    46.164     0.150
     2.826    83.164     0.150
     3.036    51.164     0.150
     3.156    49.625     0.150
     3.156    87.324     0.150
     3.359    52.164     0.150
     3.359    91.453     0.150
     3.428    57.965     0.150
     3.643    58.266     0.150
     3.652    55.965     0.150
     3.652    97.715     0.150
     3.836    60.465     0.150
     3.836   104.965     0.150
     3.908    62.242     0.150
     3.908   105.984     0.150
     4.015    64.664     0.150
     4.015   119.664     0.150
     4.208    63.766     0.150
     4.208   109.855     0.150
     4.305    68.164     0.150
     4.489    69.266     0.150
     5.042    76.465     0.150
     5.042   133.164     0.150
     5.091    77.164     0.150
     5.091   134.766     0.150
     5.283    79.562     0.150
     5.283   139.164     0.150
     5.295    79.766     0.150
     5.295   140.062     0.150
     5.295    79.562     0.150
     5.295   139.164     0.150
     5.518    82.863     0.150
     5.872    88.266     0.150
     5.872   153.766     0.150
     5.950    87.164     0.150
     5.950   181.164     0.150
     6.522    95.965     0.150
     6.522   168.766     0.150
     6.619    96.465     0.150
     6.818   101.465     0.150
     7.167   103.723     0.150
     7.167   179.703     0.150
     7.184   105.266     0.150
     7.184   183.965     0.150
     7.230   106.266     0.150
     7.230   185.062     0.150
     7.891   115.465     0.150
     7.891   203.164     0.150
     8.101   116.723     0.150
     8.101   202.855     0.150
     8.369   127.086     0.150
     8.369   219.645     0.150
     9.633   140.766     0.150
    10.036   142.062     0.150
    11.371   161.164     0.150
    11.371   279.164     0.150
    12.617   176.004     0.150
    12.617   306.652     0.150
    12.638   174.164     0.150
    12.775   179.164     0.150
    13.348   188.965     0.150
    13.347   187.664     0.150
    13.347   188.508     0.150
    13.347   331.031     0.150
    13.573   192.965     0.150
    13.763   190.363     0.150
    15.037   218.465     0.150
    15.116   209.766     0.150
    15.116   209.863     0.150
    16.821   234.164     0.150
    16.821   233.113     0.150
    16.821   414.988     0.150
    16.821   735.688     0.150
    18.705   256.766     0.150
    19.905   271.664     0.150
    20.103   272.863     0.150
    20.471   276.863     0.150
    20.475   276.863     0.150
    20.596   277.590     0.150
    20.596   508.121     0.150
    20.596   743.863     0.150
    20.684   278.516     0.150
    20.684   530.363     0.150
    20.684   744.516     0.150
    20.677   279.766     0.150
    20.685   277.562     0.150
    20.685   508.164     0.150
    20.685   743.863     0.150
    20.801   281.164     0.150
    20.867   281.863     0.150
    21.168   285.062     0.150
    22.333   298.062     0.150
    22.652   299.766     0.150
    22.652   547.266     0.150
    22.824   306.465     0.150
    23.016   307.062     0.150
    23.364   308.363     0.150
    23.503   311.562     0.150
    24.040   314.164     0.150
    24.040   752.918     0.150
    24.094   314.363     0.150
    24.144   314.605     0.150
    24.144   315.164     0.150
    24.532   318.984     0.150
    24.749   320.664     0.150
    24.894   322.062     0.150
    26.249   334.965     0.150
    26.505   337.062     0.150
    26.610   338.863     0.150
    26.774   338.863     0.150
    26.919   342.043     0.150
    27.805   350.062     0.150
    30.421   373.562     0.150
    30.421   430.562     0.150
    30.421   768.664     0.150
    30.421   371.785     0.150
    31.509   382.562     0.150
    32.434   390.164     0.150
    35.429   414.965     0.150
    36.322   421.965     0.150
    36.922   427.562     0.150
    38.327   440.266     0.150
    38.821   443.363     0.150
    38.920   445.562     0.150
    39.731   451.965     0.150
    40.100   454.766     0.150
    40.100   454.766     0.150
    42.274   472.590     0.150
    42.896   477.664     0.150
    42.905   477.664     0.150
    43.061   479.516     0.150
    44.103   490.062     0.150
    44.157   489.465     0.150
    44.643   493.965     0.150
    45.208   497.164     0.150
    45.212   497.562     0.150
    45.246   495.562     0.150
    45.246     8.902     0.150
    45.246   600.164     0.150
    45.272   497.465     0.150
    45.565   499.562     0.150
    45.901   501.164     0.150
    47.019   510.562     0.150
    47.110   511.664     0.150
    47.682   517.266     0.150
    47.754   519.164     0.150
    47.905   518.363     0.150
    48.410   521.465     0.150
    49.210   526.664     0.150
    49.587   530.562     0.150
    49.979   533.863     0.150
    51.083   542.562     0.150
    51.083     3.902     0.150
    51.222   543.863     0.150
    52.587   552.988     0.150
    52.874   555.562     0.150
    54.031   562.863     0.150
    54.031   563.164     0.150
    54.770   568.781     0.150
    55.489   574.266     0.150
    57.078   585.965     0.150
    57.538   588.465     0.150
    57.838   590.766     0.150
    57.916   591.062     0.150
    58.051   592.965     0.150
    58.060   592.863     0.150
    58.147   593.266     0.150
    58.197   593.766     0.150
    58.447   595.363     0.150
    59.385   600.465     0.150
    59.784   604.164     0.150
    59.915   604.664     0.150
    60.964   612.562     0.150
    61.181   613.863     0.150
    61.181   656.863     0.150
    62.177   619.562     0.150
    62.976   625.266     0.150
    67.274   654.688     0.150
    69.504   668.266     0.150
    72.093   682.965     0.150
    72.094   682.863     0.150
    73.568   692.562     0.150
    74.315   696.164     0.150
    75.395   702.164     0.150
    78.337   719.266     0.150
    78.335   719.465     0.150
    78.682   720.363     0.150
    78.682   896.863     0.150
    80.852   733.664     0.150
    82.029   739.664     0.150
    82.314   741.863     0.150
    83.291   744.664     0.150
    84.840   753.062     0.150
    87.044   763.465     0.150
    90.807   782.039     0.150
   119.838  1128.285     0.150
   120.855  1131.980     0.150
   147.839  1186.965     0.150
   152.778  1196.414     0.150
     0.241     5.113     0.150
     0.241     9.203     0.150
     1.278    22.301     0.150
     1.278    40.301     0.150
     1.363    23.562     0.150
     1.649    29.562     0.150
     1.913    33.562     0.150
     1.913    57.562     0.150
     1.924    30.102     0.150
     1.924    54.871     0.150
     1.924    56.871     0.150
     1.812    29.961     0.150
     1.812    53.363     0.150
     2.044    34.312     0.150
     2.044    59.613     0.150
     2.127    34.941     0.150
     2.127    58.352     0.150
     2.348    38.742     0.150
     2.348    65.352     0.150
     2.583    43.281     0.150
     2.583    75.621     0.150
     2.715    43.852     0.150
     3.113    48.684     0.150
     3.113    83.293     0.150
     5.106    76.863     0.150
     5.271    79.363     0.150
     5.433    81.664     0.150
     5.981    89.062     0.150
     6.136    90.863     0.150
     6.466    94.664     0.150
     6.466   166.562     0.150
     6.525    95.863     0.150
     6.587    97.164     0.150
     6.770    99.363     0.150
     6.783    99.262     0.150
     7.028   102.363     0.150
     7.378   107.562     0.150
     8.007   115.262     0.150
     8.680   124.762     0.150
     8.743   125.461     0.150
     8.900   128.723     0.150
    10.430   150.402     0.150
    10.430   263.633     0.150
    11.128   159.531     0.150
    11.516   161.879     0.150
    11.516   286.336     0.150
    12.657   181.945     0.150
    12.657   181.031     0.150
    12.657   315.133     0.150
    12.657   180.602     0.150
    12.750   182.527     0.150
    12.861   179.414     0.150
    12.861   315.133     0.150
    12.862   178.562     0.150
    12.862   316.062     0.150
    12.832   182.781     0.150
    12.876   316.434     0.150
    12.999   183.109     0.150
    12.999   324.453     0.150
    13.748   335.551     0.150
    14.193   197.539     0.150
    14.193   197.074     0.150
    15.349   373.281     0.150
    16.565   403.543     0.150
    16.717   230.086     0.150
    16.717   230.773     0.150
    16.717   230.664     0.150
    18.465   255.133     0.150
    20.266   273.137     0.150
    20.266   273.414     0.150
    20.359   275.461     0.150
    20.359   274.922     0.150
    22.141   294.664     0.150
    23.405   307.551     0.150
    23.456   308.191     0.150
    23.484   309.801     0.150
    23.484   309.023     0.150
    24.060   312.914     0.150
    25.199   324.547     0.150
    25.199   324.664     0.150
    27.702   348.391     0.150
    37.451   432.613     0.150
    41.606   466.809     0.150
    44.743   491.242     0.150
    45.972   501.586     0.150
    49.145   525.812     0.150
    51.541   544.809     0.150
    52.943   554.316     0.150
    56.678   582.062     0.150
    56.688   582.562     0.150
    57.142   584.164     0.150
    57.397   586.961     0.150
    58.434   593.461     0.150
    72.050   682.781     0.150
    72.050   682.711     0.150
    73.478   690.812     0.150
    73.480   690.863     0.150
    75.664   703.613     0.150
    78.870   720.961     0.150
    80.804   733.289     0.150
    86.167   759.164     0.150
    86.913   762.609     0.150
     0.602    11.459     0.150
     0.602    19.549     0.150
     0.811    15.279     0.150
     0.912    16.770     0.150
     0.912    29.420     0.150
     1.251    25.879     0.150
     1.679    30.850     0.150
     2.080    34.279     0.150
     2.080    58.279     0.150
     2.591    41.279     0.150
     2.591    72.279     0.150
     2.631    44.979     0.150
     2.715    45.479     0.150
     2.715    83.180     0.150
     3.038    49.148     0.150
     3.038    83.119     0.150
     3.611    55.709     0.150
     3.611    95.889     0.150
     4.483    67.580     0.150
     4.583    70.379     0.150
     5.428    80.479     0.150
     5.428   142.279     0.150
     5.504   145.279     0.150
     6.070    89.979     0.150
     6.070   157.479     0.150
     6.715    98.180     0.150
     6.715   170.879     0.150
     7.272   105.680     0.150
     7.272   184.979     0.150
     7.314   106.080     0.150
     7.314   185.580     0.150
     7.510   109.080     0.150
     7.510   191.180     0.150
     7.522   109.180     0.150
     7.522   191.379     0.150
     7.723   111.379     0.150
     7.959   114.750     0.150
     7.959   198.939     0.150
     8.083   116.680     0.150
     8.083   203.479     0.150
     8.120   117.279     0.150
     8.120   206.479     0.150
     8.418   120.279     0.150
     8.750   125.080     0.150
     8.750   219.180     0.150
     9.403   134.080     0.150
     9.425   133.879     0.150
     9.425   234.180     0.150
     9.460   137.080     0.150
     9.460   239.979     0.150
    10.267   143.529     0.150
    10.582   148.779     0.150
    10.582   261.279     0.150
    11.035   158.590     0.150
    11.306   161.689     0.150
    11.387   161.930     0.150
    11.647   166.580     0.150
    11.706   165.723     0.150
    11.706   166.879     0.150
    11.706   167.109     0.150
    11.815   170.109     0.150
    11.873   169.680     0.150
    11.873   297.180     0.150
    11.874   168.479     0.150
    12.030   168.779     0.150
    12.030   297.080     0.150
    12.152   173.080     0.150
    12.152   299.779     0.150
    13.149   184.479     0.150
    13.220   184.080     0.150
    13.220   184.279     0.150
    13.220   321.619     0.150
    13.757   191.219     0.150
    13.759   190.279     0.150
    13.848   194.410     0.150
    14.662   202.010     0.150
    14.783   210.279     0.150
    14.783   373.580     0.150
    14.783   387.279     0.150
    14.783   520.080     0.150
    14.783   729.080     0.150
    14.783   734.279     0.150
    14.783   947.279     0.150
    15.620   218.500     0.150
    15.900   222.299     0.150
    15.900   388.680     0.150
    15.921   222.779     0.150
    15.921   221.080     0.150
    16.076   230.209     0.150
    16.167   223.740     0.150
    16.185   228.799     0.150
    16.210   223.979     0.150
    16.735   230.750     0.150
    17.482   241.840     0.150
    19.033   261.639     0.150
    19.388   263.354     0.150
    19.483   265.580     0.150
    19.483   477.879     0.150
    19.657   268.080     0.150
    19.657   486.080     0.150
    19.657   502.080     0.150
    20.433   276.879     0.150
    20.697   279.559     0.150
    20.976   281.770     0.150
    21.691   290.619     0.150
    22.139   293.580     0.150
    22.174   295.279     0.150
    22.174   549.779     0.150
    22.174   572.779     0.150
    22.457   296.479     0.150
    22.457   296.992     0.150
    22.507   297.479     0.150
    22.507   297.779     0.150
    22.507   543.139     0.150
    22.518   297.580     0.150
    22.518   298.229     0.150
    22.518   541.469     0.150
    22.734   301.279     0.150
    22.917   301.680     0.150
    22.952   302.270     0.150
    23.260   305.930     0.150
    23.260   305.102     0.150
    23.260   306.379     0.150
    24.234   315.205     0.150
    25.637   327.580     0.150
    25.637   591.279     0.150
    25.637   657.779     0.150
    26.204   336.750     0.150
    26.260   332.580     0.150
    26.923   338.979     0.150
    27.345   344.879     0.150
    28.588   354.779     0.150
    28.588   403.479     0.150
    28.588   640.979     0.150
    28.588   354.529     0.150
    28.748   356.279     0.150
    28.748   409.580     0.150
    28.748   645.279     0.150
    30.201   368.654     0.150
    31.283   378.779     0.150
    31.283   683.279     0.150
    34.764   409.779     0.150
    35.390   414.080     0.150
    36.694   425.580     0.150
    37.627   432.973     0.150
    37.627   433.580     0.150
    37.627   518.279     0.150
    40.704   457.473     0.150
    40.712   458.279     0.150
    40.735   458.379     0.150
    41.048   462.180     0.150
    41.380   463.680     0.150
    41.380   463.680     0.150
    41.872   469.779     0.150
    41.926   470.180     0.150
    42.411   474.273     0.150
    42.411   474.580     0.150
    42.815   476.770     0.150
    42.986   477.779     0.150
    42.989   477.500     0.150
    43.040   478.479     0.150
    43.996   484.930     0.150
    44.052   485.232     0.150
    44.454   489.779     0.150
    44.460   489.580     0.150
    44.806   493.879     0.150
    44.983   493.279     0.150
    45.007   493.830     0.150
    45.207   494.080     0.150
    45.403   497.879     0.150
    47.714   515.479     0.150
    47.793   515.879     0.150
    48.173   518.930     0.150
    48.173   518.854     0.150
    48.700   521.279     0.150
    48.882   524.080     0.150
    48.882     5.000     0.150
    48.882   524.379     0.150
    49.076   525.979     0.150
    49.290   527.398     0.150
    49.952   532.344     0.150
    50.039   533.080     0.150
    50.379   535.520     0.150
    50.661   537.479     0.150
    50.720   537.979     0.150
    50.950   539.279     0.150
    51.668   544.553     0.150
    51.984   546.580     0.150
    51.984   546.830     0.150
    52.159   548.250     0.150
    52.200   548.605     0.150
    52.549   550.951     0.150
    52.846   553.090     0.150
    53.382   557.125     0.150
    55.282   571.398     0.150
    55.322   571.080     0.150
    55.624   573.279     0.150
    55.683   573.979     0.150
    55.719   573.979     0.150
    55.823   575.479     0.150
    55.833   575.580     0.150
    55.967   575.779     0.150
    56.057   576.680     0.150
    56.277   577.654     0.150
    57.397   586.180     0.150
    57.564   586.979     0.150
    57.860   588.879     0.150
    58.149   591.680     0.150
    58.744   595.680     0.150
    59.179   598.879     0.150
    59.487   600.879     0.150
    59.725   602.379     0.150
    59.915   604.080     0.150
    60.927   611.180     0.150
    60.892   609.479     0.150
    61.562   614.479     0.150
    61.865   616.979     0.150
    61.963   617.879     0.150
    64.982   638.180     0.150
    65.038   638.154     0.150
    68.387   660.479     0.150
    68.468   660.479     0.150
    71.571   678.250     0.150
    71.571   678.529     0.150
    74.323   695.705     0.150
    74.325   696.080     0.150
    75.000   700.279     0.150
    75.350   700.719     0.150
    75.391   701.930     0.150
    76.533   708.379     0.150
    76.564   708.170     0.150
    76.907   710.740     0.150
    77.538   713.809     0.150
    77.777   714.930     0.150
    77.819   714.479     0.150
    77.819   715.500     0.150
    78.009   715.609     0.150
    78.068   715.740     0.150
    78.156   716.479     0.150
    78.156   716.129     0.150
    78.156   891.830     0.150
    78.683   719.580     0.150
    79.211   722.180     0.150
    79.550   724.580     0.150
    79.581   724.779     0.150
    79.798   725.910     0.150
    79.974   726.680     0.150
    80.007   726.479     0.150
    80.208   728.449     0.150
    80.356   729.279     0.150
    80.596   730.068     0.150
    81.059   732.910     0.150
    81.762   737.680     0.150
    83.085   743.205     0.150
    83.085   744.279     0.150
    83.839   748.240     0.150
    86.076   757.574     0.150
    86.076   757.568     0.150
    87.049   763.004     0.150
    87.049   763.260     0.150
   119.762  1128.705     0.150
   145.669  1177.254     0.150
   145.669  1177.639     0.150
   146.459  1179.799     0.150
     2.107    36.438     0.150
     2.107    63.281     0.150
     2.107    65.828     0.150
     3.087    49.008     0.150
     3.399    54.430     0.150
     3.475    54.430     0.150
     3.475    97.430     0.150
     3.790    65.828     0.150
     4.126    63.227     0.150
     4.126   111.930     0.150
     4.270    65.672     0.150
     4.270   116.805     0.150
     4.679    70.125     0.150
     4.666    69.828     0.150
     4.729    71.328     0.150
     4.729   126.727     0.150
     4.683   136.828     0.150
     4.920    73.531     0.150
     4.920   130.227     0.150
     4.932    73.930     0.150
     4.932   130.930     0.150
     5.159    77.125     0.150
     5.159   136.625     0.150
     6.159    90.328     0.150
     6.159   160.227     0.150
     6.114    89.828     0.150
     6.822    99.531     0.150
     6.822   176.328     0.150
     6.872   100.328     0.150
     6.872   177.430     0.150
     6.976   102.227     0.150
     7.115   101.656     0.150
     7.181   104.227     0.150
     7.759   110.352     0.150
     7.985   115.031     0.150
     8.254   119.328     0.150
     8.339   217.398     0.150
     9.321   135.227     0.150
     9.321   234.125     0.150
     9.321   135.125     0.150
     9.321   238.031     0.150
    10.309   145.430     0.150
    10.309   143.727     0.150
    10.309   253.625     0.150
    10.713   152.125     0.150
    11.012   154.227     0.150
    10