#!/bin/bash
gmt begin chamoli16.22_seis pdf,ps
proj=-JM16.0c+
reg=-R77.4/81.0/29.5/31.3
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map chamoli16.22'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    80.452    29.855
    80.476    29.959
>
    80.849    29.543
    80.883    29.762
>
    79.279    30.369
    79.267    30.555
>
    79.880    29.938
    79.957    30.145
>
    79.362    30.438
    79.396    30.567
>
    80.332    29.963
    80.332    30.028
>
    80.591    29.972
    80.669    29.860
>
    80.565    29.871
    80.560    29.905
>
    78.586    30.432
    78.689    30.878
>
    80.229    29.626
    80.118    29.978
>
    79.142    30.286
    79.144    30.513
>
    78.024    31.063
    78.034    31.092
>
    79.158    30.424
    79.216    30.487
>
    79.153    30.315
    79.177    30.482
>
    80.447    29.707
    80.486    29.908
>
    79.189    30.451
    79.192    30.547
>
    79.180    30.307
    79.233    30.469
>
    79.824    30.143
    79.741    30.088
>
    80.356    29.695
    80.398    29.637
>
    78.791    30.756
    78.784    30.755
>
    78.702    30.702
    78.734    30.826
>
    78.655    30.708
    78.717    30.794
>
    78.739    30.654
    78.680    30.779
>
    78.938    30.495
    78.829    30.708
>
    80.519    29.685
    80.645    29.934
>
    79.139    30.457
    79.117    30.659
>
    80.612    29.817
    80.582    29.894
>
    79.620    30.092
    79.503    30.251
>
    79.230    30.377
    79.295    30.589
>
    79.230    30.413
    79.278    30.585
>
    78.791    30.516
    78.900    30.723
>
    79.335    30.364
    79.362    30.461
>
    79.305    30.318
    79.367    30.387
>
    79.350    30.322
    79.355    30.406
>
    79.338    30.370
    79.314    30.441
>
    79.531    30.386
    79.387    30.388
>
    79.339    30.405
    79.396    30.439
>
    79.406    30.403
    79.382    30.386
>
    79.268    30.472
    79.298    30.582
>
    79.143    30.489
    79.350    30.398
>
    79.356    30.226
    79.390    30.411
>
    79.301    30.365
    79.465    30.450
>
    79.450    30.250
    79.426    30.377
>
    79.348    30.320
    79.280    30.327
>
    79.367    30.295
    79.286    30.467
>
    79.423    30.395
    79.341    30.407
>
    79.359    30.346
    79.354    30.423
>
    79.587    30.392
    79.425    30.431
>
    79.444    30.333
    79.388    30.395
>
    79.375    30.360
    79.438    30.461
>
    79.411    30.370
    79.392    30.507
>
    79.446    30.366
    79.433    30.409
>
    79.382    30.424
    79.347    30.358
>
    79.387    30.396
    79.375    30.422
>
    79.320    30.506
    79.361    30.510
>
    79.180    30.391
    79.418    30.477
>
    79.388    30.323
    79.416    30.432
>
    79.368    30.394
    79.379    30.428
>
    79.339    30.405
    79.380    30.430
>
    79.358    30.397
    79.372    30.428
>
    79.459    30.332
    79.465    30.389
>
    79.395    30.405
    79.408    30.423
>
    79.392    30.384
    79.364    30.438
>
    79.421    30.382
    79.414    30.421
>
    79.356    30.438
    79.418    30.433
>
    79.322    30.402
    79.355    30.448
>
    79.494    30.320
    79.447    30.422
>
    79.367    30.377
    79.360    30.422
>
    79.340    30.427
    79.370    30.432
>
    79.375    30.390
    79.405    30.425
>
    79.355    30.388
    79.369    30.424
>
    79.198    30.468
    79.239    30.487
>
    79.216    30.493
    79.246    30.479
>
    79.275    30.550
    79.313    30.544
>
    79.342    30.403
    79.374    30.429
>
    79.236    30.455
    79.244    30.478
>
    79.311    30.432
    79.372    30.423
>
    79.352    30.446
    79.360    30.451
>
    79.328    30.416
    79.357    30.422
>
    79.246    30.449
    79.241    30.465
>
    79.232    30.475
    79.240    30.461
>
    79.318    30.451
    79.363    30.450
>
    79.332    30.429
    79.389    30.425
>
    79.206    30.483
    79.230    30.502
>
    79.291    30.375
    79.368    30.396
>
    79.363    30.426
    79.387    30.436
>
    79.364    30.435
    79.386    30.435
>
    79.404    30.328
    79.397    30.359
>
    79.354    30.401
    79.373    30.405
>
    79.340    30.417
    79.394    30.420
>
    79.366    30.382
    79.406    30.414
>
    79.334    30.411
    79.380    30.409
>
    79.353    30.416
    79.394    30.422
>
    79.321    30.431
    79.352    30.430
>
    79.321    30.417
    79.355    30.427
>
    79.352    30.426
    79.378    30.428
>
    79.460    30.339
    79.452    30.386
>
    79.413    30.367
    79.379    30.419
>
    79.348    30.426
    79.375    30.430
>
    79.347    30.447
    79.391    30.420
>
    79.346    30.423
    79.377    30.423
>
    79.302    30.425
    79.327    30.440
>
    79.364    30.402
    79.408    30.404
>
    79.346    30.435
    79.387    30.420
>
    79.345    30.418
    79.361    30.422
>
    79.398    30.429
    79.444    30.432
>
    79.303    30.410
    79.358    30.409
>
    79.331    30.419
    79.371    30.422
>
    79.330    30.428
    79.378    30.433
>
    79.348    30.433
    79.381    30.424
>
    79.285    30.513
    79.311    30.539
>
    79.316    30.452
    79.351    30.452
>
    79.424    30.326
    79.381    30.419
>
    79.351    30.420
    79.373    30.424
>
    79.371    30.417
    79.387    30.415
>
    79.313    30.449
    79.348    30.434
>
    79.393    30.378
    79.406    30.401
>
    79.304    30.422
    79.329    30.415
>
    79.349    30.402
    79.362    30.411
>
    79.369    30.436
    79.387    30.431
>
    79.347    30.418
    79.377    30.422
>
    79.431    30.453
    79.476    30.461
>
    79.373    30.441
    79.408    30.418
>
    79.439    30.466
    79.497    30.455
>
    79.413    30.451
    79.484    30.463
>
    79.356    30.533
    79.382    30.520
>
    79.351    30.415
    79.375    30.422
>
    79.344    30.423
    79.373    30.424
>
    79.373    30.385
    79.403    30.387
>
    79.259    30.458
    79.277    30.473
>
    79.396    30.402
    79.421    30.397
>
    79.347    30.412
    79.352    30.432
>
    79.437    30.455
    79.486    30.465
>
    79.283    30.444
    79.307    30.438
>
    79.410    30.388
    79.392    30.418
>
    79.356    30.417
    79.372    30.422
>
    79.402    30.403
    79.398    30.410
>
    79.407    30.325
    79.399    30.380
>
    79.396    30.428
    79.414    30.414
>
    79.337    30.406
    79.354    30.406
>
    79.342    30.386
    79.377    30.383
>
    79.372    30.424
    79.387    30.421
>
    79.357    30.374
    79.403    30.367
>
    79.341    30.423
    79.369    30.423
>
    79.372    30.368
    79.397    30.366
>
    79.324    30.396
    79.348    30.431
>
    79.318    30.423
    79.349    30.430
>
    79.357    30.397
    79.404    30.392
>
    79.351    30.490
    79.403    30.499
>
    79.313    30.404
    79.367    30.401
>
    79.334    30.418
    79.346    30.420
>
    79.363    30.363
    79.331    30.422
>
    77.841    31.034
    77.820    31.220
>
    79.981    29.944
    79.981    30.047
>
    78.258    30.832
    78.256    30.991
>
    79.529    30.336
    79.511    30.431
>
    78.196    30.966
    78.123    30.939
>
    78.208    31.085
    78.128    31.096
>
    79.133    30.460
    79.158    30.620
>
    80.601    29.766
    80.566    29.897
>
    80.027    29.911
    80.015    30.045
>
    78.186    30.826
    78.244    30.912
>
    80.679    29.721
    80.649    29.952
>
    80.026    30.046
    80.053    30.080
>
    77.625    30.522
    77.549    30.534
>
    79.311    30.468
    79.317    30.577
>
    79.324    30.562
    79.246    30.559
>
    80.388    30.240
    80.403    30.302
>
    80.295    30.599
    80.335    30.659
>
    79.262    30.649
    79.113    30.610
>
    79.643    30.810
    79.292    30.672
>
    80.332    30.285
    80.358    30.301
>
    80.437    29.369
    80.418    29.579
>
    80.649    29.575
    80.717    29.714
>
    78.446    30.814
    78.367    30.870
>
    78.471    30.834
    78.505    30.890
>
    80.052    29.931
    80.044    30.051
>
    79.237    30.513
    79.229    30.500
>
    80.361    30.331
    80.418    30.320
>
    80.387    30.222
    80.434    30.323
>
    80.148    29.780
    80.167    29.917
>
    80.542    29.774
    80.605    29.874
>
    80.116    29.912
    80.184    29.959
>
    78.058    30.985
    78.159    30.995
>
    78.284    30.858
    78.259    30.927
>
    78.173    30.958
    78.121    30.965
>
    79.365    30.622
    79.179    30.561
>
    79.990    29.945
    79.982    30.014
>
    80.056    29.981
    80.068    30.066
>
    80.333    30.264
    80.334    30.232
>
    78.259    30.951
    78.187    30.992
>
    80.383    29.756
    80.515    29.844
>
    79.801    29.948
    79.849    30.002
>
    80.469    29.807
    80.434    29.899
>
    80.085    30.011
    80.063    30.036
>
    78.246    30.305
    78.334    30.336
>
    77.857    31.230
    77.861    31.223
>
    80.466    29.877
    80.427    29.856
>
    80.397    29.845
    80.406    29.848
>
    80.428    29.790
    80.434    29.846
>
    79.615    30.009
    79.615    30.103
>
    79.177    30.543
    79.134    30.547
>
    80.729    29.626
    80.763    29.676
>
    80.415    30.216
    80.397    30.297
>
    78.223    31.088
    78.139    31.040
>
    79.319    30.551
    79.315    30.558
>
    78.907    29.717
    78.909    29.735
>
    78.298    30.944
    78.272    30.972
>
    80.599    29.852
    80.589    29.886
>
    78.396    30.896
    78.391    30.897
>
    78.325    30.999
    78.264    30.955
>
    78.939    30.704
    78.894    30.670
>
    79.279    30.444
    79.182    30.575
>
    79.990    30.208
    79.997    30.254
>
    80.524    30.173
    80.463    30.358
>
    79.482    30.375
    79.480    30.382
>
    79.151    30.407
    79.131    30.516
>
    80.093    30.093
    79.909    30.095
>
    80.545    29.936
    80.539    29.953
>
    78.139    30.859
    78.087    30.979
>
    79.079    30.577
    79.089    30.578
>
    79.113    30.569
    79.140    30.612
>
    79.982    30.089
    79.986    30.088
>
    79.544    30.231
    79.551    30.236
>
    80.126    30.016
    80.134    30.014
>
    80.130    30.021
    80.132    30.019
>
    79.999    30.051
    80.002    30.053
>
    80.371    29.659
    80.374    29.658
>
    79.207    30.455
    79.208    30.464
>
    79.375    30.434
    79.388    30.448
>
    79.136    30.568
    79.134    30.617
>
    78.984    30.590
    78.990    30.588
>
    79.976    30.035
    79.982    30.038
>
    80.383    29.961
    80.392    29.972
>
    79.927    30.170
    79.930    30.173
>
    79.121    30.527
    79.126    30.564
>
    79.113    30.526
    79.121    30.541
>
    79.789    30.046
    79.795    30.047
>
    78.854    30.018
    78.835    30.005
>
    79.866    30.154
    79.872    30.154
>
    80.419    29.866
    80.423    29.863
>
    80.160    30.033
    80.174    30.041
>
    79.442    30.232
    79.452    30.244
>
    79.858    30.135
    79.865    30.137
>
    79.864    30.114
    79.870    30.116
>
    79.860    30.099
    79.868    30.107
>
    79.119    30.516
    79.132    30.537
>
    80.194    29.868
    80.200    29.869
>
    79.270    30.521
    79.296    30.552
>
    79.549    30.288
    79.563    30.297
>
    80.354    29.610
    80.364    29.604
>
    79.968    29.999
    79.974    30.003
>
    79.383    30.360
    79.404    30.379
>
    79.817    30.167
    79.831    30.177
>
    80.409    29.853
    80.413    29.853
>
    78.805    30.762
    78.772    30.792
>
    78.299    30.911
    78.282    30.871
>
    79.261    30.567
    79.260    30.582
>
    80.123    30.009
    80.135    30.017
>
    78.656    30.741
    78.642    30.753
>
    79.805    30.151
    79.827    30.156
>
    79.187    30.498
    79.191    30.511
>
    79.089    30.505
    79.093    30.521
>
    78.713    30.371
    78.699    30.380
>
    79.230    30.442
    79.232    30.451
>
    79.212    30.436
    79.210    30.448
>
    78.423    30.831
    78.388    30.839
>
    79.196    30.432
    79.194    30.446
>
    78.652    30.728
    78.635    30.737
>
    79.189    30.432
    79.190    30.443
>
    78.834    29.907
    78.822    29.893
>
    78.004    30.532
    77.974    30.534
>
    78.425    30.831
    78.398    30.844
>
    78.554    30.064
    78.530    30.061
>
    78.409    30.874
    78.354    30.895
>
    78.657    30.700
    78.635    30.711
>
    79.951    30.011
    79.964    30.023
>
    78.397    30.865
    78.374    30.870
>
    78.349    30.836
    78.333    30.833
>
    79.003    30.667
    78.999    30.669
>
    79.184    30.574
    79.187    30.600
>
    80.186    29.815
    80.209    29.816
>
    78.414    30.800
    78.372    30.823
>
    79.324    30.544
    79.332    30.557
>
    78.223    30.889
    78.192    30.906
>
    80.261    30.024
    80.281    30.024
>
    78.529    30.754
    78.507    30.762
>
    78.641    30.746
    78.625    30.765
>
    78.751    30.404
    78.734    30.412
>
    80.252    29.981
    80.244    29.985
>
    79.434    30.485
    79.438    30.499
>
    78.290    30.869
    78.260    30.887
>
    79.138    30.488
    79.144    30.523
>
    78.377    30.478
    78.356    30.465
>
    79.532    30.378
    79.533    30.386
>
    79.529    30.389
    79.530    30.400
>
    80.419    29.835
    80.423    29.842
>
    79.139    30.571
    79.141    30.587
>
    78.328    30.855
    78.298    30.871
>
    80.373    29.898
    80.375    29.901
>
    79.740    29.933
    79.743    29.930
>
    79.718    29.961
    79.720    29.962
>
    79.068    30.483
    79.062    30.496
>
    79.276    30.575
    79.281    30.591
>
    79.955    30.100
    79.960    30.101
>
    80.210    29.978
    80.230    29.978
>
    79.874    30.142
    79.880    30.147
>
    80.088    29.993
    80.093    29.989
>
    79.841    30.043
    79.842    30.046
>
    78.523    30.741
    78.494    30.755
>
    80.203    30.012
    80.214    30.009
>
    78.505    30.761
    78.482    30.768
>
    79.721    30.019
    79.725    30.020
>
    80.058    30.031
    80.075    30.034
>
    80.132    30.007
    80.149    30.015
>
    78.331    30.278
    78.314    30.283
>
    79.870    30.098
    79.870    30.101
>
    78.289    30.888
    78.272    30.891
>
    80.123    29.949
    80.142    29.957
>
    79.580    30.185
    79.593    30.198
>
    79.868    29.997
    79.871    29.999
>
    79.413    30.322
    79.424    30.330
>
    79.171    30.516
    79.149    30.501
>
    78.182    30.899
    78.136    30.922
>
    80.411    29.907
    80.433    29.903
>
    79.766    29.974
    79.768    29.977
>
    79.064    30.491
    79.054    30.497
>
    79.885    30.100
    79.892    30.107
>
    78.423    30.752
    78.399    30.761
>
    80.410    29.869
    80.422    29.870
>
    78.206    30.881
    78.181    30.875
>
    80.382    29.882
    80.392    29.880
>
    79.854    30.148
    79.864    30.154
>
    79.131    30.528
    79.143    30.553
>
    78.857    30.651
    78.851    30.684
>
    78.670    30.711
    78.655    30.724
>
    80.061    30.015
    80.076    30.017
>
    79.184    30.477
    79.186    30.482
>
    79.509    30.425
    79.524    30.435
>
    80.035    29.999
    80.047    29.988
>
    79.451    30.427
    79.486    30.448
>
    79.944    30.088
    79.952    30.094
>
    78.414    30.866
    78.390    30.882
>
    79.416    30.505
    79.421    30.516
>
    78.700    30.510
    78.682    30.516
>
    80.031    30.136
    80.045    30.145
>
    80.002    30.133
    80.009    30.140
>
    79.519    30.354
    79.511    30.349
>
    78.301    30.901
    78.271    30.916
>
    79.944    30.021
    79.950    30.019
>
    79.247    30.552
    79.253    30.561
>
    80.226    30.014
    80.244    30.006
>
    78.942    30.635
    78.943    30.662
>
    80.178    29.997
    80.199    30.008
>
    80.438    29.867
    80.440    29.866
>
    79.529    30.447
    79.553    30.441
>
    79.231    30.473
    79.247    30.495
>
    79.549    30.449
    79.554    30.461
>
    79.260    30.476
    79.260    30.479
>
    79.239    30.468
    79.249    30.477
>
    79.463    30.368
    79.474    30.377
>
    79.246    30.474
    79.249    30.487
>
    80.041    30.086
    80.051    30.084
>
    80.033    29.994
    80.047    29.992
>
    79.188    30.495
    79.192    30.502
>
    79.191    30.484
    79.199    30.494
>
    79.375    30.518
    79.371    30.533
>
    79.368    30.523
    79.385    30.543
>
    79.371    30.521
    79.391    30.551
>
    79.239    30.461
    79.246    30.473
>
    79.247    30.536
    79.257    30.551
>
    78.856    30.588
    78.858    30.618
>
    80.235    29.956
    80.265    29.954
>
    78.646    30.535
    78.634    30.545
>
    80.075    30.057
    80.079    30.058
>
    79.011    30.537
    79.008    30.535
>
    79.904    30.111
    79.906    30.106
>
    79.984    29.989
    79.987    29.992
>
    80.171    29.879
    80.178    29.877
>
    79.853    30.000
    79.863    30.002
>
    79.869    29.997
    79.875    29.995
>
    79.863    30.000
    79.869    29.999
>
    79.873    29.986
    79.874    29.985
>
    80.131    29.969
    80.136    29.967
>
    79.863    29.999
    79.868    29.998
>
    79.871    29.991
    79.875    29.992
>
    79.863    29.963
    79.865    29.971
>
    79.870    29.989
    79.877    29.993
>
    80.175    29.980
    80.181    29.976
>
    79.876    29.989
    79.885    29.987
>
    79.870    29.991
    79.873    29.984
>
    80.203    30.025
    80.205    30.018
>
    79.850    29.997
    79.859    29.997
>
    79.862    29.985
    79.871    29.988
>
    78.553    30.719
    78.532    30.728
>
    79.378    30.333
    79.385    30.335
>
    78.527    30.803
    78.511    30.812
>
    79.201    30.487
    79.201    30.496
>
    80.093    30.078
    80.096    30.070
>
    79.864    30.005
    79.871    30.001
>
    79.866    29.985
    79.872    29.987
>
    79.862    30.004
    79.864    30.004
>
    79.862    29.992
    79.864    29.998
>
    79.871    30.012
    79.876    30.008
>
    79.343    30.361
    79.367    30.371
>
    79.866    29.994
    79.875    29.994
>
    79.214    30.487
    79.217    30.495
>
    78.629    30.205
    78.614    30.205
>
    79.221    30.429
    79.225    30.442
>
    79.219    30.441
    79.216    30.445
>
    79.222    30.437
    79.225    30.445
>
    78.680    30.211
    78.668    30.216
>
    78.319    30.486
    78.288    30.492
>
    78.520    30.063
    78.503    30.065
>
    79.864    30.003
    79.871    30.002
>
    78.614    30.623
    78.604    30.625
>
    78.637    30.190
    78.624    30.192
>
    78.721    30.656
    78.703    30.667
>
    78.596    30.769
    78.576    30.782
>
    78.535    30.767
    78.507    30.775
>
    78.572    30.725
    78.550    30.732
>
    78.307    30.180
    78.268    30.198
>
    79.444    30.382
    79.450    30.392
>
    79.855    29.992
    79.864    29.993
>
    78.603    30.692
    78.582    30.708
>
    78.866    30.690
    78.857    30.700
>
    79.315    30.590
    79.320    30.606
>
    79.315    30.523
    79.319    30.541
>
    79.881    30.169
    79.889    30.172
>
    78.556    30.700
    78.543    30.713
>
    80.090    30.000
    80.105    30.000
>
    77.879    30.787
    77.837    30.798
>
    80.179    29.899
    80.188    29.899
>
    79.965    30.049
    79.975    30.050
>
    78.780    30.001
    78.770    29.999
>
    78.385    30.840
    78.361    30.851
>
    79.151    30.466
    79.157    30.483
>
    78.857    30.602
    78.842    30.619
>
    78.791    29.987
    78.783    29.983
>
    79.599    30.215
    79.599    30.227
>
    79.146    30.498
    79.147    30.523
>
    79.091    30.498
    79.099    30.524
>
    79.468    30.227
    79.475    30.234
>
    78.856    29.829
    78.844    29.819
>
    78.022    30.892
    77.972    30.928
>
    79.200    30.500
    79.204    30.514
>
    79.936    30.065
    79.947    30.066
>
    77.955    30.715
    77.924    30.724
>
    79.882    30.115
    79.887    30.106
>
    78.956    29.897
    78.949    29.887
>
    79.192    30.474
    79.192    30.484
>
    79.798    30.002
    79.801    30.007
>
    79.584    30.233
    79.591    30.245
>
    79.845    30.145
    79.855    30.147
>
    79.341    30.531
    79.345    30.552
>
    79.541    30.234
    79.554    30.246
>
    79.348    30.489
    79.356    30.501
>
    79.533    30.245
    79.538    30.252
>
    80.445    29.829
    80.456    29.828
>
    77.985    30.620
    77.937    30.632
>
    78.466    30.479
    78.445    30.488
>
    78.160    30.957
    78.125    30.983
>
    80.394    29.885
    80.411    29.878
>
    80.408    29.888
    80.424    29.885
>
    79.158    30.479
    79.165    30.497
>
    80.150    29.806
    80.150    29.812
>
    80.145    29.808
    80.150    29.809
>
    79.890    30.173
    79.899    30.169
>
    79.931    30.045
    79.934    30.049
>
    78.336    30.797
    78.318    30.811
>
    78.343    30.799
    78.322    30.808
>
    78.444    30.818
    78.420    30.830
>
    78.448    30.825
    78.426    30.827
>
    78.579    30.699
    78.556    30.707
>
    79.919    30.130
    79.931    30.131
>
    79.411    30.353
    79.433    30.363
>
    79.165    30.485
    79.172    30.498
>
    79.287    30.655
    79.300    30.681
>
    79.895    30.086
    79.901    30.096
>
    79.887    30.091
    79.901    30.096
>
    79.400    30.452
    79.411    30.466
>
    78.519    30.782
    78.493    30.788
>
    80.384    29.858
    80.392    29.860
>
    80.073    29.962
    80.082    29.956
>
    78.921    29.926
    78.916    29.922
>
    79.195    30.471
    79.198    30.479
>
    78.948    30.530
    78.945    30.541
>
    79.465    30.331
    79.472    30.342
>
    80.407    29.858
    80.407    29.866
>
    78.911    30.578
    78.901    30.589
>
    80.448    29.885
    80.460    29.886
>
    80.455    29.894
    80.467    29.891
>
    80.318    29.941
    80.333    29.937
>
    79.168    30.469
    79.170    30.477
>
    78.569    30.313
    78.550    30.322
>
    79.216    30.478
    79.215    30.484
>
    79.211    30.485
    79.210    30.492
>
    79.553    30.255
    79.562    30.264
>
    79.513    30.271
    79.527    30.277
>
    79.377    30.525
    79.376    30.534
>
    79.423    30.326
    79.438    30.332
>
    79.412    30.473
    79.422    30.487
>
    79.399    30.469
    79.399    30.465
>
    79.399    30.482
    79.411    30.483
>
    79.409    30.481
    79.421    30.488
>
    80.017    30.063
    80.035    30.057
>
    79.972    30.018
    79.980    30.015
>
    80.474    29.904
    80.476    29.904
>
    79.982    30.034
    79.988    30.031
>
    79.249    29.654
    79.251    29.644
>
    78.638    30.718
    78.702    30.742
>
    79.965    30.020
    79.973    30.026
>
    78.005    30.594
    77.930    30.654
>
    78.138    30.930
    78.119    30.940
>
    78.916    29.897
    78.907    29.886
>
    78.842    30.634
    78.831    30.655
>
    79.472    30.438
    79.470    30.448
>
    79.217    30.471
    79.216    30.479
>
    79.211    30.470
    79.212    30.473
>
    78.581    30.789
    78.566    30.798
>
    79.212    30.458
    79.212    30.467
>
    78.983    30.578
    78.984    30.597
>
    79.203    30.464
    79.212    30.469
>
    79.950    30.126
    79.956    30.132
>
    79.158    30.473
    79.153    30.487
>
    78.853    30.610
    78.845    30.624
>
    79.306    30.557
    79.306    30.571
>
    79.193    30.464
    79.185    30.471
>
    78.889    30.033
    78.889    30.028
>
    79.849    30.084
    79.855    30.074
>
    78.798    30.645
    78.785    30.663
>
    78.796    30.648
    78.783    30.667
>
    80.181    29.978
    80.200    29.973
>
    80.462    29.865
    80.483    29.861
>
    79.218    30.466
    79.217    30.472
>
    79.395    30.389
    79.404    30.393
>
    80.286    29.814
    80.353    29.978
>
    78.235    30.930
    78.186    30.934
>
    80.397    29.829
    80.386    29.886
>
    78.485    30.757
    78.458    30.768
>
    80.137    29.911
    80.211    30.059
>
    80.133    30.021
    80.010    30.137
>
    78.602    30.778
    78.522    30.763
>
    80.237    29.905
    80.220    29.909
>
    80.188    29.933
    80.189    29.987
>
    79.235    30.353
    79.119    30.518
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    80.473    29.955
    80.476    29.959
>
    80.883    29.763
    80.883    29.762
>
    79.261    30.543
    79.267    30.555
>
    79.954    30.144
    79.957    30.145
>
    79.394    30.565
    79.396    30.567
>
    80.331    30.025
    80.332    30.028
>
    80.669    29.858
    80.669    29.860
>
    80.560    29.904
    80.560    29.905
>
    78.690    30.876
    78.689    30.878
>
    80.120    29.976
    80.118    29.978
>
    79.145    30.510
    79.144    30.513
>
    78.027    31.092
    78.034    31.092
>
    79.217    30.486
    79.216    30.487
>
    79.178    30.478
    79.177    30.482
>
    80.493    29.912
    80.486    29.908
>
    79.191    30.545
    79.192    30.547
>
    79.232    30.465
    79.233    30.469
>
    79.740    30.085
    79.741    30.088
>
    80.398    29.633
    80.398    29.637
>
    78.783    30.750
    78.784    30.755
>
    78.735    30.822
    78.734    30.826
>
    78.717    30.791
    78.717    30.794
>
    78.680    30.778
    78.680    30.779
>
    78.830    30.705
    78.829    30.708
>
    80.644    29.931
    80.645    29.934
>
    79.117    30.656
    79.117    30.659
>
    80.581    29.891
    80.582    29.894
>
    79.504    30.247
    79.503    30.251
>
    79.295    30.588
    79.295    30.589
>
    79.278    30.580
    79.278    30.585
>
    78.899    30.719
    78.900    30.723
>
    79.362    30.458
    79.362    30.461
>
    79.368    30.380
    79.367    30.387
>
    79.354    30.402
    79.355    30.406
>
    79.320    30.441
    79.314    30.441
>
    79.388    30.390
    79.387    30.388
>
    79.403    30.444
    79.396    30.439
>
    79.379    30.380
    79.382    30.386
>
    79.298    30.577
    79.298    30.582
>
    79.350    30.394
    79.350    30.398
>
    79.387    30.406
    79.390    30.411
>
    79.470    30.461
    79.465    30.450
>
    79.428    30.373
    79.426    30.377
>
    79.293    30.337
    79.280    30.327
>
    79.286    30.462
    79.286    30.467
>
    79.340    30.401
    79.341    30.407
>
    79.355    30.417
    79.354    30.423
>
    79.426    30.428
    79.425    30.431
>
    79.389    30.391
    79.388    30.395
>
    79.437    30.457
    79.438    30.461
>
    79.390    30.502
    79.392    30.507
>
    79.442    30.411
    79.433    30.409
>
    79.354    30.363
    79.347    30.358
>
    79.376    30.418
    79.375    30.422
>
    79.362    30.505
    79.361    30.510
>
    79.417    30.473
    79.418    30.477
>
    79.418    30.433
    79.416    30.432
>
    79.379    30.428
    79.379    30.428
>
    79.379    30.426
    79.380    30.430
>
    79.372    30.427
    79.372    30.428
>
    79.467    30.387
    79.465    30.389
>
    79.409    30.420
    79.408    30.423
>
    79.365    30.435
    79.364    30.438
>
    79.414    30.419
    79.414    30.421
>
    79.417    30.432
    79.418    30.433
>
    79.355    30.447
    79.355    30.448
>
    79.448    30.420
    79.447    30.422
>
    79.360    30.421
    79.360    30.422
>
    79.369    30.432
    79.370    30.432
>
    79.405    30.423
    79.405    30.425
>
    79.370    30.422
    79.369    30.424
>
    79.238    30.486
    79.239    30.487
>
    79.245    30.478
    79.246    30.479
>
    79.313    30.544
    79.313    30.544
>
    79.373    30.429
    79.374    30.429
>
    79.242    30.486
    79.244    30.478
>
    79.370    30.423
    79.372    30.423
>
    79.360    30.450
    79.360    30.451
>
    79.357    30.421
    79.357    30.422
>
    79.241    30.464
    79.241    30.465
>
    79.240    30.461
    79.240    30.461
>
    79.363    30.450
    79.363    30.450
>
    79.388    30.424
    79.389    30.425
>
    79.230    30.501
    79.230    30.502
>
    79.368    30.396
    79.368    30.396
>
    79.387    30.436
    79.387    30.436
>
    79.386    30.434
    79.386    30.435
>
    79.404    30.349
    79.397    30.359
>
    79.372    30.405
    79.373    30.405
>
    79.394    30.419
    79.394    30.420
>
    79.405    30.415
    79.406    30.414
>
    79.380    30.409
    79.380    30.409
>
    79.394    30.422
    79.394    30.422
>
    79.351    30.430
    79.352    30.430
>
    79.354    30.427
    79.355    30.427
>
    79.378    30.427
    79.378    30.428
>
    79.454    30.384
    79.452    30.386
>
    79.378    30.414
    79.379    30.419
>
    79.375    30.429
    79.375    30.430
>
    79.391    30.419
    79.391    30.420
>
    79.377    30.422
    79.377    30.423
>
    79.327    30.440
    79.327    30.440
>
    79.408    30.403
    79.408    30.404
>
    79.387    30.420
    79.387    30.420
>
    79.361    30.421
    79.361    30.422
>
    79.443    30.432
    79.444    30.432
>
    79.353    30.408
    79.358    30.409
>
    79.371    30.422
    79.371    30.422
>
    79.378    30.433
    79.378    30.433
>
    79.381    30.423
    79.381    30.424
>
    79.310    30.538
    79.311    30.539
>
    79.351    30.451
    79.351    30.452
>
    79.381    30.418
    79.381    30.419
>
    79.372    30.423
    79.373    30.424
>
    79.386    30.415
    79.387    30.415
>
    79.347    30.433
    79.348    30.434
>
    79.405    30.399
    79.406    30.401
>
    79.328    30.415
    79.329    30.415
>
    79.362    30.411
    79.362    30.411
>
    79.387    30.431
    79.387    30.431
>
    79.376    30.422
    79.377    30.422
>
    79.476    30.460
    79.476    30.461
>
    79.407    30.418
    79.408    30.418
>
    79.497    30.454
    79.497    30.455
>
    79.483    30.463
    79.484    30.463
>
    79.382    30.519
    79.382    30.520
>
    79.370    30.423
    79.375    30.422
>
    79.372    30.424
    79.373    30.424
>
    79.402    30.387
    79.403    30.387
>
    79.276    30.472
    79.277    30.473
>
    79.421    30.397
    79.421    30.397
>
    79.351    30.432
    79.352    30.432
>
    79.485    30.465
    79.486    30.465
>
    79.306    30.437
    79.307    30.438
>
    79.391    30.417
    79.392    30.418
>
    79.372    30.421
    79.372    30.422
>
    79.397    30.409
    79.398    30.410
>
    79.398    30.380
    79.399    30.380
>
    79.413    30.414
    79.414    30.414
>
    79.353    30.406
    79.354    30.406
>
    79.376    30.383
    79.377    30.383
>
    79.386    30.421
    79.387    30.421
>
    79.403    30.365
    79.403    30.367
>
    79.368    30.423
    79.369    30.423
>
    79.396    30.366
    79.397    30.366
>
    79.348    30.431
    79.348    30.431
>
    79.349    30.430
    79.349    30.430
>
    79.404    30.391
    79.404    30.392
>
    79.404    30.498
    79.403    30.499
>
    79.366    30.399
    79.367    30.401
>
    79.347    30.418
    79.346    30.420
>
    79.329    30.424
    79.331    30.422
>
    77.812    31.217
    77.820    31.220
>
    79.983    30.044
    79.981    30.047
>
    78.258    30.989
    78.256    30.991
>
    79.508    30.426
    79.511    30.431
>
    78.126    30.937
    78.123    30.939
>
    78.128    31.094
    78.128    31.096
>
    79.159    30.620
    79.158    30.620
>
    80.567    29.894
    80.566    29.897
>
    80.015    30.041
    80.015    30.045
>
    78.242    30.910
    78.244    30.912
>
    80.656    29.950
    80.649    29.952
>
    80.055    30.078
    80.053    30.080
>
    77.547    30.531
    77.549    30.534
>
    79.317    30.574
    79.317    30.577
>
    79.246    30.558
    79.246    30.559
>
    80.403    30.299
    80.403    30.302
>
    80.335    30.657
    80.335    30.659
>
    79.113    30.608
    79.113    30.610
>
    79.293    30.670
    79.292    30.672
>
    80.358    30.297
    80.358    30.301
>
    80.418    29.574
    80.418    29.579
>
    80.718    29.712
    80.717    29.714
>
    78.365    30.870
    78.367    30.870
>
    78.506    30.887
    78.505    30.890
>
    80.045    30.047
    80.044    30.051
>
    79.230    30.494
    79.229    30.500
>
    80.417    30.314
    80.418    30.320
>
    80.436    30.322
    80.434    30.323
>
    80.167    29.914
    80.167    29.917
>
    80.606    29.871
    80.605    29.874
>
    80.184    29.956
    80.184    29.959
>
    78.159    30.993
    78.159    30.995
>
    78.259    30.924
    78.259    30.927
>
    78.122    30.964
    78.121    30.965
>
    79.179    30.559
    79.179    30.561
>
    79.984    30.012
    79.982    30.014
>
    80.078    30.073
    80.068    30.066
>
    80.336    30.229
    80.334    30.232
>
    78.192    30.993
    78.187    30.992
>
    80.514    29.840
    80.515    29.844
>
    79.849    30.000
    79.849    30.002
>
    80.432    29.898
    80.434    29.899
>
    80.063    30.033
    80.063    30.036
>
    78.335    30.333
    78.334    30.336
>
    77.881    31.219
    77.861    31.223
>
    80.428    29.855
    80.427    29.856
>
    80.410    29.847
    80.406    29.848
>
    80.434    29.843
    80.434    29.846
>
    79.615    30.100
    79.615    30.103
>
    79.136    30.544
    79.134    30.547
>
    80.762    29.672
    80.763    29.676
>
    80.398    30.294
    80.397    30.297
>
    78.137    31.040
    78.139    31.040
>
    79.316    30.555
    79.315    30.558
>
    78.909    29.735
    78.909    29.735
>
    78.274    30.969
    78.272    30.972
>
    80.590    29.884
    80.589    29.886
>
    78.394    30.894
    78.391    30.897
>
    78.265    30.952
    78.264    30.955
>
    78.893    30.666
    78.894    30.670
>
    79.181    30.569
    79.182    30.575
>
    79.999    30.253
    79.997    30.254
>
    80.464    30.356
    80.463    30.358
>
    79.481    30.379
    79.480    30.382
>
    79.132    30.512
    79.131    30.516
>
    79.909    30.093
    79.909    30.095
>
    80.539    29.951
    80.539    29.953
>
    78.053    30.994
    78.087    30.979
>
    79.090    30.576
    79.089    30.578
>
    79.139    30.609
    79.140    30.612
>
    79.986    30.088
    79.986    30.088
>
    79.551    30.236
    79.551    30.236
>
    80.133    30.013
    80.134    30.014
>
    80.132    30.019
    80.132    30.019
>
    80.002    30.053
    80.002    30.053
>
    80.373    29.658
    80.374    29.658
>
    79.208    30.464
    79.208    30.464
>
    79.386    30.451
    79.388    30.448
>
    79.135    30.616
    79.134    30.617
>
    78.990    30.588
    78.990    30.588
>
    79.982    30.037
    79.982    30.038
>
    80.392    29.971
    80.392    29.972
>
    79.930    30.172
    79.930    30.173
>
    79.127    30.563
    79.126    30.564
>
    79.121    30.541
    79.121    30.541
>
    79.795    30.047
    79.795    30.047
>
    78.835    30.004
    78.835    30.005
>
    79.872    30.154
    79.872    30.154
>
    80.423    29.863
    80.423    29.863
>
    80.173    30.040
    80.174    30.041
>
    79.453    30.244
    79.452    30.244
>
    79.865    30.137
    79.865    30.137
>
    79.870    30.116
    79.870    30.116
>
    79.868    30.107
    79.868    30.107
>
    79.133    30.537
    79.132    30.537
>
    80.201    29.868
    80.200    29.869
>
    79.297    30.553
    79.296    30.552
>
    79.563    30.297
    79.563    30.297
>
    80.363    29.604
    80.364    29.604
>
    79.974    30.003
    79.974    30.003
>
    79.404    30.379
    79.404    30.379
>
    79.831    30.177
    79.831    30.177
>
    80.413    29.853
    80.413    29.853
>
    78.772    30.792
    78.772    30.792
>
    78.282    30.870
    78.282    30.871
>
    79.260    30.581
    79.260    30.582
>
    80.135    30.017
    80.135    30.017
>
    78.642    30.753
    78.642    30.753
>
    79.828    30.156
    79.827    30.156
>
    79.190    30.511
    79.191    30.511
>
    79.094    30.521
    79.093    30.521
>
    78.699    30.380
    78.699    30.380
>
    79.232    30.450
    79.232    30.451
>
    79.211    30.448
    79.210    30.448
>
    78.388    30.839
    78.388    30.839
>
    79.193    30.446
    79.194    30.446
>
    78.635    30.737
    78.635    30.737
>
    79.190    30.443
    79.190    30.443
>
    78.822    29.893
    78.822    29.893
>
    77.974    30.533
    77.974    30.534
>
    78.399    30.844
    78.398    30.844
>
    78.531    30.060
    78.530    30.061
>
    78.355    30.894
    78.354    30.895
>
    78.635    30.710
    78.635    30.711
>
    79.964    30.023
    79.964    30.023
>
    78.375    30.870
    78.374    30.870
>
    78.334    30.832
    78.333    30.833
>
    78.999    30.669
    78.999    30.669
>
    79.187    30.600
    79.187    30.600
>
    80.209    29.815
    80.209    29.816
>
    78.372    30.822
    78.372    30.823
>
    79.332    30.557
    79.332    30.557
>
    78.193    30.905
    78.192    30.906
>
    80.282    30.024
    80.281    30.024
>
    78.508    30.761
    78.507    30.762
>
    78.625    30.766
    78.625    30.765
>
    78.734    30.412
    78.734    30.412
>
    80.245    29.985
    80.244    29.985
>
    79.439    30.499
    79.438    30.499
>
    78.261    30.886
    78.260    30.887
>
    79.146    30.529
    79.144    30.523
>
    78.357    30.465
    78.356    30.465
>
    79.533    30.386
    79.533    30.386
>
    79.530    30.400
    79.530    30.400
>
    80.423    29.841
    80.423    29.842
>
    79.142    30.587
    79.141    30.587
>
    78.298    30.870
    78.298    30.871
>
    80.376    29.900
    80.375    29.901
>
    79.743    29.930
    79.743    29.930
>
    79.720    29.962
    79.720    29.962
>
    79.062    30.496
    79.062    30.496
>
    79.282    30.590
    79.281    30.591
>
    79.961    30.100
    79.960    30.101
>
    80.230    29.978
    80.230    29.978
>
    79.880    30.147
    79.880    30.147
>
    80.093    29.989
    80.093    29.989
>
    79.842    30.046
    79.842    30.046
>
    78.495    30.754
    78.494    30.755
>
    80.214    30.009
    80.214    30.009
>
    78.482    30.768
    78.482    30.768
>
    79.725    30.019
    79.725    30.020
>
    80.076    30.033
    80.075    30.034
>
    80.149    30.015
    80.149    30.015
>
    78.314    30.283
    78.314    30.283
>
    79.869    30.100
    79.870    30.101
>
    78.273    30.891
    78.272    30.891
>
    80.142    29.957
    80.142    29.957
>
    79.593    30.198
    79.593    30.198
>
    79.871    29.999
    79.871    29.999
>
    79.424    30.331
    79.424    30.330
>
    79.149    30.499
    79.149    30.501
>
    78.136    30.922
    78.136    30.922
>
    80.434    29.903
    80.433    29.903
>
    79.768    29.976
    79.768    29.977
>
    79.054    30.497
    79.054    30.497
>
    79.892    30.107
    79.892    30.107
>
    78.399    30.761
    78.399    30.761
>
    80.422    29.869
    80.422    29.870
>
    78.183    30.875
    78.181    30.875
>
    80.393    29.880
    80.392    29.880
>
    79.864    30.154
    79.864    30.154
>
    79.143    30.553
    79.143    30.553
>
    78.851    30.684
    78.851    30.684
>
    78.656    30.724
    78.655    30.724
>
    80.076    30.017
    80.076    30.017
>
    79.184    30.481
    79.186    30.482
>
    79.524    30.435
    79.524    30.435
>
    80.047    29.988
    80.047    29.988
>
    79.486    30.448
    79.486    30.448
>
    79.953    30.094
    79.952    30.094
>
    78.390    30.882
    78.390    30.882
>
    79.421    30.516
    79.421    30.516
>
    78.682    30.516
    78.682    30.516
>
    80.045    30.144
    80.045    30.145
>
    80.008    30.140
    80.009    30.140
>
    79.511    30.348
    79.511    30.349
>
    78.272    30.915
    78.271    30.916
>
    79.950    30.018
    79.950    30.019
>
    79.253    30.561
    79.253    30.561
>
    80.245    30.006
    80.244    30.006
>
    78.943    30.662
    78.943    30.662
>
    80.198    30.007
    80.199    30.008
>
    80.440    29.866
    80.440    29.866
>
    79.554    30.441
    79.553    30.441
>
    79.246    30.493
    79.247    30.495
>
    79.555    30.461
    79.554    30.461
>
    79.260    30.479
    79.260    30.479
>
    79.249    30.477
    79.249    30.477
>
    79.474    30.378
    79.474    30.377
>
    79.250    30.486
    79.249    30.487
>
    80.051    30.084
    80.051    30.084
>
    80.047    29.991
    80.047    29.992
>
    79.193    30.502
    79.192    30.502
>
    79.199    30.494
    79.199    30.494
>
    79.370    30.532
    79.371    30.533
>
    79.385    30.543
    79.385    30.543
>
    79.392    30.552
    79.391    30.551
>
    79.246    30.473
    79.246    30.473
>
    79.257    30.551
    79.257    30.551
>
    78.858    30.617
    78.858    30.618
>
    80.265    29.953
    80.265    29.954
>
    78.634    30.545
    78.634    30.545
>
    80.079    30.057
    80.079    30.058
>
    79.008    30.534
    79.008    30.535
>
    79.906    30.106
    79.906    30.106
>
    79.987    29.992
    79.987    29.992
>
    80.178    29.877
    80.178    29.877
>
    79.863    30.001
    79.863    30.002
>
    79.875    29.995
    79.875    29.995
>
    79.869    29.998
    79.869    29.999
>
    79.874    29.984
    79.874    29.985
>
    80.136    29.967
    80.136    29.967
>
    79.870    29.998
    79.868    29.998
>
    79.875    29.991
    79.875    29.992
>
    79.866    29.971
    79.865    29.971
>
    79.877    29.993
    79.877    29.993
>
    80.181    29.976
    80.181    29.976
>
    79.885    29.987
    79.885    29.987
>
    79.873    29.984
    79.873    29.984
>
    80.205    30.018
    80.205    30.018
>
    79.858    29.997
    79.859    29.997
>
    79.871    29.988
    79.871    29.988
>
    78.532    30.728
    78.532    30.728
>
    79.385    30.334
    79.385    30.335
>
    78.511    30.812
    78.511    30.812
>
    79.202    30.495
    79.201    30.496
>
    80.096    30.069
    80.096    30.070
>
    79.871    30.001
    79.871    30.001
>
    79.872    29.987
    79.872    29.987
>
    79.864    30.003
    79.864    30.004
>
    79.864    29.997
    79.864    29.998
>
    79.876    30.008
    79.876    30.008
>
    79.367    30.371
    79.367    30.371
>
    79.875    29.994
    79.875    29.994
>
    79.217    30.495
    79.217    30.495
>
    78.614    30.204
    78.614    30.205
>
    79.226    30.441
    79.225    30.442
>
    79.216    30.445
    79.216    30.445
>
    79.226    30.445
    79.225    30.445
>
    78.669    30.216
    78.668    30.216
>
    78.287    30.492
    78.288    30.492
>
    78.503    30.064
    78.503    30.065
>
    79.872    30.002
    79.871    30.002
>
    78.604    30.625
    78.604    30.625
>
    78.624    30.191
    78.624    30.192
>
    78.703    30.666
    78.703    30.667
>
    78.576    30.781
    78.576    30.782
>
    78.507    30.775
    78.507    30.775
>
    78.551    30.732
    78.550    30.732
>
    78.269    30.198
    78.268    30.198
>
    79.450    30.391
    79.450    30.392
>
    79.864    29.993
    79.864    29.993
>
    78.582    30.708
    78.582    30.708
>
    78.858    30.700
    78.857    30.700
>
    79.320    30.605
    79.320    30.606
>
    79.319    30.541
    79.319    30.541
>
    79.889    30.172
    79.889    30.172
>
    78.544    30.712
    78.543    30.713
>
    80.105    29.999
    80.105    30.000
>
    77.837    30.798
    77.837    30.798
>
    80.188    29.899
    80.188    29.899
>
    79.975    30.050
    79.975    30.050
>
    78.770    29.998
    78.770    29.999
>
    78.362    30.851
    78.361    30.851
>
    79.158    30.482
    79.157    30.483
>
    78.842    30.619
    78.842    30.619
>
    78.784    29.983
    78.783    29.983
>
    79.599    30.227
    79.599    30.227
>
    79.148    30.522
    79.147    30.523
>
    79.099    30.524
    79.099    30.524
>
    79.476    30.234
    79.475    30.234
>
    78.843    29.817
    78.844    29.819
>
    77.971    30.930
    77.972    30.928
>
    79.205    30.514
    79.204    30.514
>
    79.947    30.066
    79.947    30.066
>
    77.924    30.724
    77.924    30.724
>
    79.888    30.106
    79.887    30.106
>
    78.949    29.887
    78.949    29.887
>
    79.192    30.484
    79.192    30.484
>
    79.800    30.006
    79.801    30.007
>
    79.591    30.245
    79.591    30.245
>
    79.856    30.147
    79.855    30.147
>
    79.345    30.551
    79.345    30.552
>
    79.555    30.246
    79.554    30.246
>
    79.357    30.501
    79.356    30.501
>
    79.538    30.252
    79.538    30.252
>
    80.456    29.828
    80.456    29.828
>
    77.939    30.631
    77.937    30.632
>
    78.445    30.488
    78.445    30.488
>
    78.126    30.983
    78.125    30.983
>
    80.410    29.877
    80.411    29.878
>
    80.424    29.885
    80.424    29.885
>
    79.165    30.497
    79.165    30.497
>
    80.150    29.812
    80.150    29.812
>
    80.150    29.809
    80.150    29.809
>
    79.900    30.169
    79.899    30.169
>
    79.934    30.048
    79.934    30.049
>
    78.319    30.810
    78.318    30.811
>
    78.322    30.808
    78.322    30.808
>
    78.420    30.830
    78.420    30.830
>
    78.426    30.827
    78.426    30.827
>
    78.556    30.707
    78.556    30.707
>
    79.931    30.131
    79.931    30.131
>
    79.433    30.363
    79.433    30.363
>
    79.172    30.499
    79.172    30.498
>
    79.300    30.681
    79.300    30.681
>
    79.901    30.095
    79.901    30.096
>
    79.901    30.096
    79.901    30.096
>
    79.411    30.466
    79.411    30.466
>
    78.494    30.788
    78.493    30.788
>
    80.392    29.860
    80.392    29.860
>
    80.082    29.956
    80.082    29.956
>
    78.916    29.922
    78.916    29.922
>
    79.198    30.478
    79.198    30.479
>
    78.945    30.541
    78.945    30.541
>
    79.472    30.342
    79.472    30.342
>
    80.408    29.866
    80.407    29.866
>
    78.901    30.589
    78.901    30.589
>
    80.460    29.886
    80.460    29.886
>
    80.466    29.891
    80.467    29.891
>
    80.333    29.937
    80.333    29.937
>
    79.170    30.477
    79.170    30.477
>
    78.550    30.322
    78.550    30.322
>
    79.215    30.484
    79.215    30.484
>
    79.210    30.491
    79.210    30.492
>
    79.562    30.264
    79.562    30.264
>
    79.527    30.276
    79.527    30.277
>
    79.376    30.534
    79.376    30.534
>
    79.438    30.332
    79.438    30.332
>
    79.422    30.487
    79.422    30.487
>
    79.400    30.465
    79.399    30.465
>
    79.411    30.483
    79.411    30.483
>
    79.421    30.488
    79.421    30.488
>
    80.035    30.057
    80.035    30.057
>
    79.980    30.015
    79.980    30.015
>
    80.476    29.904
    80.476    29.904
>
    79.988    30.031
    79.988    30.031
>
    79.251    29.644
    79.251    29.644
>
    78.703    30.741
    78.702    30.742
>
    79.973    30.025
    79.973    30.026
>
    77.931    30.651
    77.930    30.654
>
    78.119    30.940
    78.119    30.940
>
    78.907    29.886
    78.907    29.886
>
    78.831    30.655
    78.831    30.655
>
    79.470    30.447
    79.470    30.448
>
    79.216    30.478
    79.216    30.479
>
    79.212    30.472
    79.212    30.473
>
    78.566    30.798
    78.566    30.798
>
    79.212    30.467
    79.212    30.467
>
    78.984    30.597
    78.984    30.597
>
    79.212    30.468
    79.212    30.469
>
    79.956    30.131
    79.956    30.132
>
    79.153    30.487
    79.153    30.487
>
    78.845    30.624
    78.845    30.624
>
    79.306    30.571
    79.306    30.571
>
    79.185    30.471
    79.185    30.471
>
    78.889    30.028
    78.889    30.028
>
    79.855    30.074
    79.855    30.074
>
    78.785    30.663
    78.785    30.663
>
    78.783    30.667
    78.783    30.667
>
    80.201    29.973
    80.200    29.973
>
    80.483    29.861
    80.483    29.861
>
    79.217    30.472
    79.217    30.472
>
    79.404    30.393
    79.404    30.393
>
    80.353    29.976
    80.353    29.978
>
    78.184    30.931
    78.186    30.934
>
    80.388    29.883
    80.386    29.886
>
    78.457    30.767
    78.458    30.768
>
    80.201    30.051
    80.211    30.059
>
    80.010    30.135
    80.010    30.137
>
    78.523    30.760
    78.522    30.763
>
    80.220    29.906
    80.220    29.909
>
    80.189    29.985
    80.189    29.987
>
    79.122    30.519
    79.119    30.518
>
EOF

# Location symbols, open circles, diameter 1 km
gmt plot $proj $reg -SE -Wthicker << EOF
    80.476    29.959     0.000     1.000     1.000
    80.883    29.762     0.000     1.000     1.000
    79.267    30.555     0.000     1.000     1.000
    79.957    30.145     0.000     1.000     1.000
    79.396    30.567     0.000     1.000     1.000
    80.332    30.028     0.000     1.000     1.000
    80.669    29.860     0.000     1.000     1.000
    80.560    29.905     0.000     1.000     1.000
    78.689    30.878     0.000     1.000     1.000
    80.118    29.978     0.000     1.000     1.000
    79.144    30.513     0.000     1.000     1.000
    78.034    31.092     0.000     1.000     1.000
    79.216    30.487     0.000     1.000     1.000
    79.177    30.482     0.000     1.000     1.000
    80.486    29.908     0.000     1.000     1.000
    79.192    30.547     0.000     1.000     1.000
    79.233    30.469     0.000     1.000     1.000
    79.741    30.088     0.000     1.000     1.000
    80.398    29.637     0.000     1.000     1.000
    78.784    30.755     0.000     1.000     1.000
    78.734    30.826     0.000     1.000     1.000
    78.717    30.794     0.000     1.000     1.000
    78.680    30.779     0.000     1.000     1.000
    78.829    30.708     0.000     1.000     1.000
    80.645    29.934     0.000     1.000     1.000
    79.117    30.659     0.000     1.000     1.000
    80.582    29.894     0.000     1.000     1.000
    79.503    30.251     0.000     1.000     1.000
    79.295    30.589     0.000     1.000     1.000
    79.278    30.585     0.000     1.000     1.000
    78.900    30.723     0.000     1.000     1.000
    79.362    30.461     0.000     1.000     1.000
    79.367    30.387     0.000     1.000     1.000
    79.355    30.406     0.000     1.000     1.000
    79.314    30.441     0.000     1.000     1.000
    79.387    30.388     0.000     1.000     1.000
    79.396    30.439     0.000     1.000     1.000
    79.382    30.386     0.000     1.000     1.000
    79.298    30.582     0.000     1.000     1.000
    79.350    30.398     0.000     1.000     1.000
    79.390    30.411     0.000     1.000     1.000
    79.465    30.450     0.000     1.000     1.000
    79.426    30.377     0.000     1.000     1.000
    79.280    30.327     0.000     1.000     1.000
    79.286    30.467     0.000     1.000     1.000
    79.341    30.407     0.000     1.000     1.000
    79.354    30.423     0.000     1.000     1.000
    79.425    30.431     0.000     1.000     1.000
    79.388    30.395     0.000     1.000     1.000
    79.438    30.461     0.000     1.000     1.000
    79.392    30.507     0.000     1.000     1.000
    79.433    30.409     0.000     1.000     1.000
    79.347    30.358     0.000     1.000     1.000
    79.375    30.422     0.000     1.000     1.000
    79.361    30.510     0.000     1.000     1.000
    79.418    30.477     0.000     1.000     1.000
    79.416    30.432     0.000     1.000     1.000
    79.379    30.428     0.000     1.000     1.000
    79.380    30.430     0.000     1.000     1.000
    79.372    30.428     0.000     1.000     1.000
    79.465    30.389     0.000     1.000     1.000
    79.408    30.423     0.000     1.000     1.000
    79.364    30.438     0.000     1.000     1.000
    79.414    30.421     0.000     1.000     1.000
    79.418    30.433     0.000     1.000     1.000
    79.355    30.448     0.000     1.000     1.000
    79.447    30.422     0.000     1.000     1.000
    79.360    30.422     0.000     1.000     1.000
    79.370    30.432     0.000     1.000     1.000
    79.405    30.425     0.000     1.000     1.000
    79.369    30.424     0.000     1.000     1.000
    79.239    30.487     0.000     1.000     1.000
    79.246    30.479     0.000     1.000     1.000
    79.313    30.544     0.000     1.000     1.000
    79.374    30.429     0.000     1.000     1.000
    79.244    30.478     0.000     1.000     1.000
    79.372    30.423     0.000     1.000     1.000
    79.360    30.451     0.000     1.000     1.000
    79.357    30.422     0.000     1.000     1.000
    79.241    30.465     0.000     1.000     1.000
    79.240    30.461     0.000     1.000     1.000
    79.363    30.450     0.000     1.000     1.000
    79.389    30.425     0.000     1.000     1.000
    79.230    30.502     0.000     1.000     1.000
    79.368    30.396     0.000     1.000     1.000
    79.387    30.436     0.000     1.000     1.000
    79.386    30.435     0.000     1.000     1.000
    79.397    30.359     0.000     1.000     1.000
    79.373    30.405     0.000     1.000     1.000
    79.394    30.420     0.000     1.000     1.000
    79.406    30.414     0.000     1.000     1.000
    79.380    30.409     0.000     1.000     1.000
    79.394    30.422     0.000     1.000     1.000
    79.352    30.430     0.000     1.000     1.000
    79.355    30.427     0.000     1.000     1.000
    79.378    30.428     0.000     1.000     1.000
    79.452    30.386     0.000     1.000     1.000
    79.379    30.419     0.000     1.000     1.000
    79.375    30.430     0.000     1.000     1.000
    79.391    30.420     0.000     1.000     1.000
    79.377    30.423     0.000     1.000     1.000
    79.327    30.440     0.000     1.000     1.000
    79.408    30.404     0.000     1.000     1.000
    79.387    30.420     0.000     1.000     1.000
    79.361    30.422     0.000     1.000     1.000
    79.444    30.432     0.000     1.000     1.000
    79.358    30.409     0.000     1.000     1.000
    79.371    30.422     0.000     1.000     1.000
    79.378    30.433     0.000     1.000     1.000
    79.381    30.424     0.000     1.000     1.000
    79.311    30.539     0.000     1.000     1.000
    79.351    30.452     0.000     1.000     1.000
    79.381    30.419     0.000     1.000     1.000
    79.373    30.424     0.000     1.000     1.000
    79.387    30.415     0.000     1.000     1.000
    79.348    30.434     0.000     1.000     1.000
    79.406    30.401     0.000     1.000     1.000
    79.329    30.415     0.000     1.000     1.000
    79.362    30.411     0.000     1.000     1.000
    79.387    30.431     0.000     1.000     1.000
    79.377    30.422     0.000     1.000     1.000
    79.476    30.461     0.000     1.000     1.000
    79.408    30.418     0.000     1.000     1.000
    79.497    30.455     0.000     1.000     1.000
    79.484    30.463     0.000     1.000     1.000
    79.382    30.520     0.000     1.000     1.000
    79.375    30.422     0.000     1.000     1.000
    79.373    30.424     0.000     1.000     1.000
    79.403    30.387     0.000     1.000     1.000
    79.277    30.473     0.000     1.000     1.000
    79.421    30.397     0.000     1.000     1.000
    79.352    30.432     0.000     1.000     1.000
    79.486    30.465     0.000     1.000     1.000
    79.307    30.438     0.000     1.000     1.000
    79.392    30.418     0.000     1.000     1.000
    79.372    30.422     0.000     1.000     1.000
    79.398    30.410     0.000     1.000     1.000
    79.399    30.380     0.000     1.000     1.000
    79.414    30.414     0.000     1.000     1.000
    79.354    30.406     0.000     1.000     1.000
    79.377    30.383     0.000     1.000     1.000
    79.387    30.421     0.000     1.000     1.000
    79.403    30.367     0.000     1.000     1.000
    79.369    30.423     0.000     1.000     1.000
    79.397    30.366     0.000     1.000     1.000
    79.348    30.431     0.000     1.000     1.000
    79.349    30.430     0.000     1.000     1.000
    79.404    30.392     0.000     1.000     1.000
    79.403    30.499     0.000     1.000     1.000
    79.367    30.401     0.000     1.000     1.000
    79.346    30.420     0.000     1.000     1.000
    79.331    30.422     0.000     1.000     1.000
    77.820    31.220     0.000     1.000     1.000
    79.981    30.047     0.000     1.000     1.000
    78.256    30.991     0.000     1.000     1.000
    79.511    30.431     0.000     1.000     1.000
    78.123    30.939     0.000     1.000     1.000
    78.128    31.096     0.000     1.000     1.000
    79.158    30.620     0.000     1.000     1.000
    80.566    29.897     0.000     1.000     1.000
    80.015    30.045     0.000     1.000     1.000
    78.244    30.912     0.000     1.000     1.000
    80.649    29.952     0.000     1.000     1.000
    80.053    30.080     0.000     1.000     1.000
    77.549    30.534     0.000     1.000     1.000
    79.317    30.577     0.000     1.000     1.000
    79.246    30.559     0.000     1.000     1.000
    80.403    30.302     0.000     1.000     1.000
    80.335    30.659     0.000     1.000     1.000
    79.113    30.610     0.000     1.000     1.000
    79.292    30.672     0.000     1.000     1.000
    80.358    30.301     0.000     1.000     1.000
    80.418    29.579     0.000     1.000     1.000
    80.717    29.714     0.000     1.000     1.000
    78.367    30.870     0.000     1.000     1.000
    78.505    30.890     0.000     1.000     1.000
    80.044    30.051     0.000     1.000     1.000
    79.229    30.500     0.000     1.000     1.000
    80.418    30.320     0.000     1.000     1.000
    80.434    30.323     0.000     1.000     1.000
    80.167    29.917     0.000     1.000     1.000
    80.605    29.874     0.000     1.000     1.000
    80.184    29.959     0.000     1.000     1.000
    78.159    30.995     0.000     1.000     1.000
    78.259    30.927     0.000     1.000     1.000
    78.121    30.965     0.000     1.000     1.000
    79.179    30.561     0.000     1.000     1.000
    79.982    30.014     0.000     1.000     1.000
    80.068    30.066     0.000     1.000     1.000
    80.334    30.232     0.000     1.000     1.000
    78.187    30.992     0.000     1.000     1.000
    80.515    29.844     0.000     1.000     1.000
    79.849    30.002     0.000     1.000     1.000
    80.434    29.899     0.000     1.000     1.000
    80.063    30.036     0.000     1.000     1.000
    78.334    30.336     0.000     1.000     1.000
    77.861    31.223     0.000     1.000     1.000
    80.427    29.856     0.000     1.000     1.000
    80.406    29.848     0.000     1.000     1.000
    80.434    29.846     0.000     1.000     1.000
    79.615    30.103     0.000     1.000     1.000
    79.134    30.547     0.000     1.000     1.000
    80.763    29.676     0.000     1.000     1.000
    80.397    30.297     0.000     1.000     1.000
    78.139    31.040     0.000     1.000     1.000
    79.315    30.558     0.000     1.000     1.000
    78.909    29.735     0.000     1.000     1.000
    78.272    30.972     0.000     1.000     1.000
    80.589    29.886     0.000     1.000     1.000
    78.391    30.897     0.000     1.000     1.000
    78.264    30.955     0.000     1.000     1.000
    78.894    30.670     0.000     1.000     1.000
    79.182    30.575     0.000     1.000     1.000
    79.997    30.254     0.000     1.000     1.000
    80.463    30.358     0.000     1.000     1.000
    79.480    30.382     0.000     1.000     1.000
    79.131    30.516     0.000     1.000     1.000
    79.909    30.095     0.000     1.000     1.000
    80.539    29.953     0.000     1.000     1.000
    78.087    30.979     0.000     1.000     1.000
    79.089    30.578     0.000     1.000     1.000
    79.140    30.612     0.000     1.000     1.000
    79.986    30.088     0.000     1.000     1.000
    79.551    30.236     0.000     1.000     1.000
    80.134    30.014     0.000     1.000     1.000
    80.132    30.019     0.000     1.000     1.000
    80.002    30.053     0.000     1.000     1.000
    80.374    29.658     0.000     1.000     1.000
    79.208    30.464     0.000     1.000     1.000
    79.388    30.448     0.000     1.000     1.000
    79.134    30.617     0.000     1.000     1.000
    78.990    30.588     0.000     1.000     1.000
    79.982    30.038     0.000     1.000     1.000
    80.392    29.972     0.000     1.000     1.000
    79.930    30.173     0.000     1.000     1.000
    79.126    30.564     0.000     1.000     1.000
    79.121    30.541     0.000     1.000     1.000
    79.795    30.047     0.000     1.000     1.000
    78.835    30.005     0.000     1.000     1.000
    79.872    30.154     0.000     1.000     1.000
    80.423    29.863     0.000     1.000     1.000
    80.174    30.041     0.000     1.000     1.000
    79.452    30.244     0.000     1.000     1.000
    79.865    30.137     0.000     1.000     1.000
    79.870    30.116     0.000     1.000     1.000
    79.868    30.107     0.000     1.000     1.000
    79.132    30.537     0.000     1.000     1.000
    80.200    29.869     0.000     1.000     1.000
    79.296    30.552     0.000     1.000     1.000
    79.563    30.297     0.000     1.000     1.000
    80.364    29.604     0.000     1.000     1.000
    79.974    30.003     0.000     1.000     1.000
    79.404    30.379     0.000     1.000     1.000
    79.831    30.177     0.000     1.000     1.000
    80.413    29.853     0.000     1.000     1.000
    78.772    30.792     0.000     1.000     1.000
    78.282    30.871     0.000     1.000     1.000
    79.260    30.582     0.000     1.000     1.000
    80.135    30.017     0.000     1.000     1.000
    78.642    30.753     0.000     1.000     1.000
    79.827    30.156     0.000     1.000     1.000
    79.191    30.511     0.000     1.000     1.000
    79.093    30.521     0.000     1.000     1.000
    78.699    30.380     0.000     1.000     1.000
    79.232    30.451     0.000     1.000     1.000
    79.210    30.448     0.000     1.000     1.000
    78.388    30.839     0.000     1.000     1.000
    79.194    30.446     0.000     1.000     1.000
    78.635    30.737     0.000     1.000     1.000
    79.190    30.443     0.000     1.000     1.000
    78.822    29.893     0.000     1.000     1.000
    77.974    30.534     0.000     1.000     1.000
    78.398    30.844     0.000     1.000     1.000
    78.530    30.061     0.000     1.000     1.000
    78.354    30.895     0.000     1.000     1.000
    78.635    30.711     0.000     1.000     1.000
    79.964    30.023     0.000     1.000     1.000
    78.374    30.870     0.000     1.000     1.000
    78.333    30.833     0.000     1.000     1.000
    78.999    30.669     0.000     1.000     1.000
    79.187    30.600     0.000     1.000     1.000
    80.209    29.816     0.000     1.000     1.000
    78.372    30.823     0.000     1.000     1.000
    79.332    30.557     0.000     1.000     1.000
    78.192    30.906     0.000     1.000     1.000
    80.281    30.024     0.000     1.000     1.000
    78.507    30.762     0.000     1.000     1.000
    78.625    30.765     0.000     1.000     1.000
    78.734    30.412     0.000     1.000     1.000
    80.244    29.985     0.000     1.000     1.000
    79.438    30.499     0.000     1.000     1.000
    78.260    30.887     0.000     1.000     1.000
    79.144    30.523     0.000     1.000     1.000
    78.356    30.465     0.000     1.000     1.000
    79.533    30.386     0.000     1.000     1.000
    79.530    30.400     0.000     1.000     1.000
    80.423    29.842     0.000     1.000     1.000
    79.141    30.587     0.000     1.000     1.000
    78.298    30.871     0.000     1.000     1.000
    80.375    29.901     0.000     1.000     1.000
    79.743    29.930     0.000     1.000     1.000
    79.720    29.962     0.000     1.000     1.000
    79.062    30.496     0.000     1.000     1.000
    79.281    30.591     0.000     1.000     1.000
    79.960    30.101     0.000     1.000     1.000
    80.230    29.978     0.000     1.000     1.000
    79.880    30.147     0.000     1.000     1.000
    80.093    29.989     0.000     1.000     1.000
    79.842    30.046     0.000     1.000     1.000
    78.494    30.755     0.000     1.000     1.000
    80.214    30.009     0.000     1.000     1.000
    78.482    30.768     0.000     1.000     1.000
    79.725    30.020     0.000     1.000     1.000
    80.075    30.034     0.000     1.000     1.000
    80.149    30.015     0.000     1.000     1.000
    78.314    30.283     0.000     1.000     1.000
    79.870    30.101     0.000     1.000     1.000
    78.272    30.891     0.000     1.000     1.000
    80.142    29.957     0.000     1.000     1.000
    79.593    30.198     0.000     1.000     1.000
    79.871    29.999     0.000     1.000     1.000
    79.424    30.330     0.000     1.000     1.000
    79.149    30.501     0.000     1.000     1.000
    78.136    30.922     0.000     1.000     1.000
    80.433    29.903     0.000     1.000     1.000
    79.768    29.977     0.000     1.000     1.000
    79.054    30.497     0.000     1.000     1.000
    79.892    30.107     0.000     1.000     1.000
    78.399    30.761     0.000     1.000     1.000
    80.422    29.870     0.000     1.000     1.000
    78.181    30.875     0.000     1.000     1.000
    80.392    29.880     0.000     1.000     1.000
    79.864    30.154     0.000     1.000     1.000
    79.143    30.553     0.000     1.000     1.000
    78.851    30.684     0.000     1.000     1.000
    78.655    30.724     0.000     1.000     1.000
    80.076    30.017     0.000     1.000     1.000
    79.186    30.482     0.000     1.000     1.000
    79.524    30.435     0.000     1.000     1.000
    80.047    29.988     0.000     1.000     1.000
    79.486    30.448     0.000     1.000     1.000
    79.952    30.094     0.000     1.000     1.000
    78.390    30.882     0.000     1.000     1.000
    79.421    30.516     0.000     1.000     1.000
    78.682    30.516     0.000     1.000     1.000
    80.045    30.145     0.000     1.000     1.000
    80.009    30.140     0.000     1.000     1.000
    79.511    30.349     0.000     1.000     1.000
    78.271    30.916     0.000     1.000     1.000
    79.950    30.019     0.000     1.000     1.000
    79.253    30.561     0.000     1.000     1.000
    80.244    30.006     0.000     1.000     1.000
    78.943    30.662     0.000     1.000     1.000
    80.199    30.008     0.000     1.000     1.000
    80.440    29.866     0.000     1.000     1.000
    79.553    30.441     0.000     1.000     1.000
    79.247    30.495     0.000     1.000     1.000
    79.554    30.461     0.000     1.000     1.000
    79.260    30.479     0.000     1.000     1.000
    79.249    30.477     0.000     1.000     1.000
    79.474    30.377     0.000     1.000     1.000
    79.249    30.487     0.000     1.000     1.000
    80.051    30.084     0.000     1.000     1.000
    80.047    29.992     0.000     1.000     1.000
    79.192    30.502     0.000     1.000     1.000
    79.199    30.494     0.000     1.000     1.000
    79.371    30.533     0.000     1.000     1.000
    79.385    30.543     0.000     1.000     1.000
    79.391    30.551     0.000     1.000     1.000
    79.246    30.473     0.000     1.000     1.000
    79.257    30.551     0.000     1.000     1.000
    78.858    30.618     0.000     1.000     1.000
    80.265    29.954     0.000     1.000     1.000
    78.634    30.545     0.000     1.000     1.000
    80.079    30.058     0.000     1.000     1.000
    79.008    30.535     0.000     1.000     1.000
    79.906    30.106     0.000     1.000     1.000
    79.987    29.992     0.000     1.000     1.000
    80.178    29.877     0.000     1.000     1.000
    79.863    30.002     0.000     1.000     1.000
    79.875    29.995     0.000     1.000     1.000
    79.869    29.999     0.000     1.000     1.000
    79.874    29.985     0.000     1.000     1.000
    80.136    29.967     0.000     1.000     1.000
    79.868    29.998     0.000     1.000     1.000
    79.875    29.992     0.000     1.000     1.000
    79.865    29.971     0.000     1.000     1.000
    79.877    29.993     0.000     1.000     1.000
    80.181    29.976     0.000     1.000     1.000
    79.885    29.987     0.000     1.000     1.000
    79.873    29.984     0.000     1.000     1.000
    80.205    30.018     0.000     1.000     1.000
    79.859    29.997     0.000     1.000     1.000
    79.871    29.988     0.000     1.000     1.000
    78.532    30.728     0.000     1.000     1.000
    79.385    30.335     0.000     1.000     1.000
    78.511    30.812     0.000     1.000     1.000
    79.201    30.496     0.000     1.000     1.000
    80.096    30.070     0.000     1.000     1.000
    79.871    30.001     0.000     1.000     1.000
    79.872    29.987     0.000     1.000     1.000
    79.864    30.004     0.000     1.000     1.000
    79.864    29.998     0.000     1.000     1.000
    79.876    30.008     0.000     1.000     1.000
    79.367    30.371     0.000     1.000     1.000
    79.875    29.994     0.000     1.000     1.000
    79.217    30.495     0.000     1.000     1.000
    78.614    30.205     0.000     1.000     1.000
    79.225    30.442     0.000     1.000     1.000
    79.216    30.445     0.000     1.000     1.000
    79.225    30.445     0.000     1.000     1.000
    78.668    30.216     0.000     1.000     1.000
    78.288    30.492     0.000     1.000     1.000
    78.503    30.065     0.000     1.000     1.000
    79.871    30.002     0.000     1.000     1.000
    78.604    30.625     0.000     1.000     1.000
    78.624    30.192     0.000     1.000     1.000
    78.703    30.667     0.000     1.000     1.000
    78.576    30.782     0.000     1.000     1.000
    78.507    30.775     0.000     1.000     1.000
    78.550    30.732     0.000     1.000     1.000
    78.268    30.198     0.000     1.000     1.000
    79.450    30.392     0.000     1.000     1.000
    79.864    29.993     0.000     1.000     1.000
    78.582    30.708     0.000     1.000     1.000
    78.857    30.700     0.000     1.000     1.000
    79.320    30.606     0.000     1.000     1.000
    79.319    30.541     0.000     1.000     1.000
    79.889    30.172     0.000     1.000     1.000
    78.543    30.713     0.000     1.000     1.000
    80.105    30.000     0.000     1.000     1.000
    77.837    30.798     0.000     1.000     1.000
    80.188    29.899     0.000     1.000     1.000
    79.975    30.050     0.000     1.000     1.000
    78.770    29.999     0.000     1.000     1.000
    78.361    30.851     0.000     1.000     1.000
    79.157    30.483     0.000     1.000     1.000
    78.842    30.619     0.000     1.000     1.000
    78.783    29.983     0.000     1.000     1.000
    79.599    30.227     0.000     1.000     1.000
    79.147    30.523     0.000     1.000     1.000
    79.099    30.524     0.000     1.000     1.000
    79.475    30.234     0.000     1.000     1.000
    78.844    29.819     0.000     1.000     1.000
    77.972    30.928     0.000     1.000     1.000
    79.204    30.514     0.000     1.000     1.000
    79.947    30.066     0.000     1.000     1.000
    77.924    30.724     0.000     1.000     1.000
    79.887    30.106     0.000     1.000     1.000
    78.949    29.887     0.000     1.000     1.000
    79.192    30.484     0.000     1.000     1.000
    79.801    30.007     0.000     1.000     1.000
    79.591    30.245     0.000     1.000     1.000
    79.855    30.147     0.000     1.000     1.000
    79.345    30.552     0.000     1.000     1.000
    79.554    30.246     0.000     1.000     1.000
    79.356    30.501     0.000     1.000     1.000
    79.538    30.252     0.000     1.000     1.000
    80.456    29.828     0.000     1.000     1.000
    77.937    30.632     0.000     1.000     1.000
    78.445    30.488     0.000     1.000     1.000
    78.125    30.983     0.000     1.000     1.000
    80.411    29.878     0.000     1.000     1.000
    80.424    29.885     0.000     1.000     1.000
    79.165    30.497     0.000     1.000     1.000
    80.150    29.812     0.000     1.000     1.000
    80.150    29.809     0.000     1.000     1.000
    79.899    30.169     0.000     1.000     1.000
    79.934    30.049     0.000     1.000     1.000
    78.318    30.811     0.000     1.000     1.000
    78.322    30.808     0.000     1.000     1.000
    78.420    30.830     0.000     1.000     1.000
    78.426    30.827     0.000     1.000     1.000
    78.556    30.707     0.000     1.000     1.000
    79.931    30.131     0.000     1.000     1.000
    79.433    30.363     0.000     1.000     1.000
    79.172    30.498     0.000     1.000     1.000
    79.300    30.681     0.000     1.000     1.000
    79.901    30.096     0.000     1.000     1.000
    79.901    30.096     0.000     1.000     1.000
    79.411    30.466     0.000     1.000     1.000
    78.493    30.788     0.000     1.000     1.000
    80.392    29.860     0.000     1.000     1.000
    80.082    29.956     0.000     1.000     1.000
    78.916    29.922     0.000     1.000     1.000
    79.198    30.479     0.000     1.000     1.000
    78.945    30.541     0.000     1.000     1.000
    79.472    30.342     0.000     1.000     1.000
    80.407    29.866     0.000     1.000     1.000
    78.901    30.589     0.000     1.000     1.000
    80.460    29.886     0.000     1.000     1.000
    80.467    29.891     0.000     1.000     1.000
    80.333    29.937     0.000     1.000     1.000
    79.170    30.477     0.000     1.000     1.000
    78.550    30.322     0.000     1.000     1.000
    79.215    30.484     0.000     1.000     1.000
    79.210    30.492     0.000     1.000     1.000
    79.562    30.264     0.000     1.000     1.000
    79.527    30.277     0.000     1.000     1.000
    79.376    30.534     0.000     1.000     1.000
    79.438    30.332     0.000     1.000     1.000
    79.422    30.487     0.000     1.000     1.000
    79.399    30.465     0.000     1.000     1.000
    79.411    30.483     0.000     1.000     1.000
    79.421    30.488     0.000     1.000     1.000
    80.035    30.057     0.000     1.000     1.000
    79.980    30.015     0.000     1.000     1.000
    80.476    29.904     0.000     1.000     1.000
    79.988    30.031     0.000     1.000     1.000
    79.251    29.644     0.000     1.000     1.000
    78.702    30.742     0.000     1.000     1.000
    79.973    30.026     0.000     1.000     1.000
    77.930    30.654     0.000     1.000     1.000
    78.119    30.940     0.000     1.000     1.000
    78.907    29.886     0.000     1.000     1.000
    78.831    30.655     0.000     1.000     1.000
    79.470    30.448     0.000     1.000     1.000
    79.216    30.479     0.000     1.000     1.000
    79.212    30.473     0.000     1.000     1.000
    78.566    30.798     0.000     1.000     1.000
    79.212    30.467     0.000     1.000     1.000
    78.984    30.597     0.000     1.000     1.000
    79.212    30.469     0.000     1.000     1.000
    79.956    30.132     0.000     1.000     1.000
    79.153    30.487     0.000     1.000     1.000
    78.845    30.624     0.000     1.000     1.000
    79.306    30.571     0.000     1.000     1.000
    79.185    30.471     0.000     1.000     1.000
    78.889    30.028     0.000     1.000     1.000
    79.855    30.074     0.000     1.000     1.000
    78.785    30.663     0.000     1.000     1.000
    78.783    30.667     0.000     1.000     1.000
    80.200    29.973     0.000     1.000     1.000
    80.483    29.861     0.000     1.000     1.000
    79.217    30.472     0.000     1.000     1.000
    79.404    30.393     0.000     1.000     1.000
    80.353    29.978     0.000     1.000     1.000
    78.186    30.934     0.000     1.000     1.000
    80.386    29.886     0.000     1.000     1.000
    78.458    30.768     0.000     1.000     1.000
    80.211    30.059     0.000     1.000     1.000
    80.010    30.137     0.000     1.000     1.000
    78.522    30.763     0.000     1.000     1.000
    80.220    29.909     0.000     1.000     1.000
    80.189    29.987     0.000     1.000     1.000
    79.119    30.518     0.000     1.000     1.000
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    80.476    29.959     0.200
    78.784    30.755     0.200
    79.362    30.461     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    77.509    29.528   -72.022     0.644     0.843
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    77.532    29.528   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    77.509    29.528     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    77.509    29.528     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    77.509    29.483   5 km
EOF
gmt end
