#!/bin/bash
gmt begin chamoli16.22_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-51/51/-51/51
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation chamoli16.22'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     4.546     4.546
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.235   -11.497
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.235   -11.497 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.412   -24.274
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.412   -24.274 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.076   -20.537
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.076   -20.537 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.473   -23.001
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.473   -23.001 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.318   -14.373
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.318   -14.373 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -7.186
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.000    -7.186 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.454    12.405
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.454    12.405 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.530    -3.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.613   -49.453
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.613   -49.453 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.490   -39.148
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.490   -39.148 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -25.210
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.000   -25.210 11
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.993    -3.248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.590    -6.903
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.590    -6.903 13
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.268   -18.468
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.268   -18.468 14
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.537   -22.333
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.537   -22.333 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.375   -10.726
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.375   -10.726 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.143   -17.935
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.143   -17.935 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.036     6.055
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.036     6.055 18
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.024     6.439
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.024     6.439 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.657     0.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.915   -13.714
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.915   -13.714 21
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.935    -9.498
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.935    -9.498 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.618   -13.906
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.618   -13.906 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.525   -23.639
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.525   -23.639 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.267   -27.551
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.267   -27.551 25
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.352   -22.380
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.352   -22.380 26
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.780    -8.557
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.780    -8.557 27
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.110   -17.780
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.110   -17.780 28
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.291   -23.477
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.291   -23.477 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.746   -19.035
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.746   -19.035 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.245   -23.012
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.245   -23.012 31
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.506   -10.855
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.506   -10.855 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.994    -7.672
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.994    -7.672 33
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.489    -9.325
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.489    -9.325 34
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.389    -7.813
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.389    -7.813 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.817    -0.241
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.817    -0.241 36
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.424    -3.798
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.424    -3.798 37
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.299     1.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.827   -12.243
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.827   -12.243 39
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -19.896    10.137
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -19.896    10.137 40
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.245   -20.487
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.245   -20.487 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.720    -9.445
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -15.720    -9.445 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.226   -14.056
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.226   -14.056 43
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.493    -0.797
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.493    -0.797 44
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.707   -19.077
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.707   -19.077 45
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.874    -1.388
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.874    -1.388 46
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.447    -8.533
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.447    -8.533 47
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.590    -4.177
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.590    -4.177 48
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.374    -6.878
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.374    -6.878 49
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.954   -11.197
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.954   -11.197 50
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.867   -15.206
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.867   -15.206 51
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.188    -4.767
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.188    -4.767 52
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.396     7.283
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.396     7.283 53
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.167    -2.888
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.904    -0.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -22.776    -9.668
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -22.776    -9.668 56
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.791   -12.088
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.791   -12.088 57
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.073    -3.741
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.896    -2.830
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.896    -2.830 59
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.374    -3.400
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.550    -6.281
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.550    -6.281 61
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.253    -2.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.682    -6.023
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.682    -6.023 63
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.604    -4.295
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.963     0.627
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.963     0.627 65
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.205    -5.129
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.205    -5.129 66
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.559   -11.284
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.559   -11.284 67
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.706    -5.027
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.706    -5.027 68
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.845    -0.605
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.819    -3.880
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.819    -3.880 70
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.364    -3.962
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.885    -2.153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.850     1.580
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.678     0.648
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.057    -2.952
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.768    -2.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.814     1.025
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.814     1.025 77
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.722    -0.585
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.773    -0.691
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.514    -1.794
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.803     1.511
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.365     0.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.463     0.478
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.463     0.478 83
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.314    -2.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.447    -2.277
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.447    -2.277 85
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.346    -1.094
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.119     0.037
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.611    -3.464
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.803    -0.483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.138    -0.359
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.138    -0.359 90
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.836    -3.577
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.836    -3.577 91
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.449     0.155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.974    -0.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.949     0.103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.229    -1.112
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.516    -0.176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.739    -5.258
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.739    -5.258 97
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.181    -5.739
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.181    -5.739 98
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.579    -0.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.280     2.997
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.280     2.997 100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.951    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.408    -1.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.258    -0.149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.927     1.667
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.570    -0.421
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.395    -0.385
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.328     0.093
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.328     0.093 107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.881    -0.408
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.627    -0.568
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.627    -0.568 109
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.155     1.025
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.483    -2.856
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.407    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.145   -10.260
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.145   -10.260 113
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.071    -0.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.531     0.243
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.330     1.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.221    -2.503
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.357     0.766
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.274    -0.995
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.764     0.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.868    -0.454
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.352    -0.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.323     2.504
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.597     1.190
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.597     1.190 124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.806    -1.323
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.806    -1.323 125
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.551     1.473
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.321    -0.799
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.784    -0.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.907    -0.152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.706    -1.648
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.407     0.556
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.433    -2.228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.691    -1.083
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.691    -1.083 133
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.251     0.731
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.753    -3.297
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.563    -0.508
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.387    -0.760
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.753    -6.132
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.753    -6.132 138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.691     1.523
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.650    -0.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.360     0.353
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.456     0.309
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.465     0.707
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.643     0.046
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.400     0.252
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.351    -3.914
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.351    -3.914 146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.946    -0.789
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.532     0.557
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.532     0.557 148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.027    -0.977
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.027    -0.977 149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.156     0.270
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.156     0.270 150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.164    -0.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.049    -6.538
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.049    -6.538 152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.798   -20.548
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.798   -20.548 153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -11.389
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.000   -11.389 154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.308   -17.634
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.308   -17.634 155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.669   -10.541
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.669   -10.541 156
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.893     3.069
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.893     3.069 157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.650    -1.212
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.650    -1.212 158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.489   -17.712
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.489   -17.712 159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.341   -14.472
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.341   -14.472 160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.299   -14.845
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.299   -14.845 161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.501    -9.528
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.501    -9.528 162
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.131   -25.502
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.131   -25.502 163
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.656    -3.792
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.656    -3.792 164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.256    -1.410
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.256    -1.410 165
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.635   -12.119
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.635   -12.119 166
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.507     0.393
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.507     0.393 167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.454    -6.839
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.454    -6.839 168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.831    -6.635
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.831    -6.635 169
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.269     4.362
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.269     4.362 170
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    33.424    15.586
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    33.424    15.586 171
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.505    -1.754
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.028   -23.182
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.028   -23.182 173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.534   -15.394
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.534   -15.394 174
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.527    -6.316
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.527    -6.316 175
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.273    -6.156
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.273    -6.156 176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.696   -13.278
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.696   -13.278 177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.766     1.441
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.485     1.266
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.485     1.266 179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.548   -11.256
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.548   -11.256 180
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.861   -15.161
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.861   -15.161 181
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.120   -11.042
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.120   -11.042 182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.562    -5.127
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.562    -5.127 183
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.596    -1.009
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.596    -1.009 184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.505    -7.709
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.505    -7.709 185
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.916    -0.867
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.916    -0.867 186
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.865     6.858
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    17.865     6.858 187
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.672    -7.686
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.672    -7.686 188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.158    -9.432
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.158    -9.432 189
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.125     3.574
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.933    -4.502
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.933    -4.502 191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.799    -9.645
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.799    -9.645 192
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.522    -6.001
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.522    -6.001 193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.508   -10.187
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.508   -10.187 194
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.086    -2.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.461    -3.419
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.461    -3.419 196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.392     0.840
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.734     2.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.787    -0.436
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.540    -6.169
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.540    -6.169 200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -10.435
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.000   -10.435 201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.038    -0.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.266    -5.435
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.266    -5.435 203
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.734    -8.919
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.734    -8.919 204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.993     5.391
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.993     5.391 205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.408    -0.737
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.141    -2.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.536    -3.022
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.948    -3.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.436    -0.109
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.837     4.898
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.837     4.898 211
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.302     3.873
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.302     3.873 212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.414   -14.497
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.414   -14.497 213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.795    -5.021
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.795    -5.021 214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.864   -20.451
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.864   -20.451 215
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.210    -0.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.908   -12.046
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.908   -12.046 217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.752    -0.310
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    17.752    -0.310 218
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.544    -1.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.865   -13.367
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.865   -13.367 220
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.029    -0.108
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.620    -4.727
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.620    -4.727 222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.398     0.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.693    -0.561
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.721     0.277
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.214     0.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.261    -0.261
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.258     0.149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.142    -1.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.291    -1.539
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.191    -5.469
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.191    -5.469 231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.591     0.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.571    -0.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.860    -1.228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.295    -0.295
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.499    -4.068
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.722    -1.700
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.584    -0.157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.844     1.493
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.623    -0.011
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.417     0.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.309    -0.883
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.013    -1.297
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.639    -0.220
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.581    -0.247
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.734    -0.906
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.271    -2.391
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.619    -0.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.535    -3.489
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.312    -0.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.924     0.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.558    -0.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.980    -2.051
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.310    -1.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.408    -0.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.151    -3.379
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.151    -3.379 256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.623     4.460
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.623     4.460 257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.084    -1.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.128    -0.913
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.374    -1.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.148    -0.576
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.339    -1.467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.418    -1.811
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.387    -1.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.184    -0.946
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.145    -1.380
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.340    -0.958
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.163    -1.549
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.609    -1.006
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.062    -1.188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.175     1.559
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.859    -0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.547    -1.412
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.266     0.400
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.242    -2.334
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.242    -2.334 275
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.143    -1.188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.217    -1.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.180    -0.544
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.514     0.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.342    -0.258
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.305    -2.906
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.224    -0.078
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.045    -2.528
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.045    -2.528 283
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.750    -1.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.921    -1.897
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.959    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.130    -0.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.564    -2.153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.662    -0.847
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.743    -0.429
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.390    -1.565
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.833    -1.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.620    -3.916
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.006     1.457
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.127    -0.906
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.106    -1.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.387    -0.728
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.217    -1.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.814    -1.759
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.219    -0.302
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.241     0.298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.178    -0.120
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.625    -1.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.525    -1.717
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.524    -0.064
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.887    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.561    -0.561
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.451     0.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.135    -0.352
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.734    -1.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.014     0.349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.193    -0.798
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.423    -0.090
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.683    -0.327
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.615    -0.895
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.673    -0.576
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.035    -0.330
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.587    -0.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.814    -0.924
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.246    -1.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.299    -0.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.029    -0.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.168     1.634
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.445    -2.567
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.445    -2.567 324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.163     0.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.231    -0.286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.998    -0.699
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.715    -0.794
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.318    -1.032
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.144    -0.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.430     0.606
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.007     0.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.944    -0.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.167    -2.749
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.583    -3.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.410    -1.460
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.442    -0.228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.193    -0.503
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.441    -1.086
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.157     1.157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.342    -2.340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.816    -0.661
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.307    -1.803
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.440    -1.208
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.761    -0.641
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.400    -0.980
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.648    -0.830
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.779     0.609
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.833    -1.636
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.621     0.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.583    -1.010
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.734     0.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.104    -2.982
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.017    -1.212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.185     0.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.348     0.673
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.500    -2.400
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.515    -1.341
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.027    -0.383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.952    -0.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.019    -1.056
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.325    -1.406
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.917     0.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.344     0.261
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.353    -0.793
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.782    -1.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.354    -1.666
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.622    -2.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.942    -3.364
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.681    -1.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.918    -1.656
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.229    -3.280
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.930     0.256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.192    -1.151
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.359    -0.057
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.320     0.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.207     0.569
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.269    -0.344
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.648     0.186
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.993    -0.285
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.605     0.185
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.593     0.148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.082     0.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.452     0.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.451     0.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.398    -0.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.240    -0.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.697    -0.436
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.550     0.478
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.897     0.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.249     0.765
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.193     0.722
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.823    -0.014
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.884    -0.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.037    -0.993
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.639    -0.183
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.549    -1.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.018    -1.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.340     0.886
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.699     0.437
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.563    -0.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.210     0.041
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.206    -0.633
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.437     0.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.280    -1.162
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.844    -0.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.313    -0.908
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.451     0.025
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.429    -1.405
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.240    -0.491
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.318    -0.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.109    -0.565
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.973    -0.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.677    -0.206
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.712     0.126
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.986    -0.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.235    -0.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.749    -1.180
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.888    -1.423
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.664    -0.866
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.095    -0.721
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.771    -2.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.572    -1.075
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.836    -0.118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.010    -1.810
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.814    -1.120
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.431    -1.729
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.390    -2.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.808    -0.377
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.210    -1.392
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.424     0.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.050    -1.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.851    -0.045
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.009    -0.124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.996     0.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.267    -1.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.632    -1.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.428    -1.895
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.741     0.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.023    -1.340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.143    -2.738
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.727    -2.917
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.715    -0.767
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.186     1.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.771    -4.003
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.771    -4.003 445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.414    -1.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.056    -0.111
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.934    -0.953
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.515     0.968
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.643     1.160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.040    -1.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.242    -0.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.635    -1.303
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.009    -0.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.360    -2.272
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.291    -1.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.806    -1.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.512    -0.819
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.107     0.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.566    -1.309
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.566    -1.309 460
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.996    -0.974
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.339    -2.903
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.604     0.817
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.528     0.353
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.648    -1.993
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.023    -0.650
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.498    -0.152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.902     0.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.288    -0.428
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.679    -1.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.995    -0.973
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.348    -1.301
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.150    -0.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.252    -0.910
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.171    -0.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.097    -1.069
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.630    -1.483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.214    -2.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.602    -1.085
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.332    -0.565
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.062    -1.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.446    -0.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.741    -0.270
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.859     0.671
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.451     0.435
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.289    -0.840
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.302    -1.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.639    -1.254
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.016    -0.939
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.946    -1.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.188    -0.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.157     0.332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.436     0.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.213    -0.855
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.809    -1.045
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.077    -0.629
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.079    -0.748
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.829    -1.024
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.369    -0.610
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.088    -1.004
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.406    -0.656
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.927    -1.542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.022     0.429
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.109    -0.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.129    -0.733
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.745     0.705
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.753     0.289
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.197     0.042
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.561     0.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.208     1.068
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.188    -2.627
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.188    -2.627 511
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.811    -0.634
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.173    -6.689
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.173    -6.689 513
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.858    -1.073
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.889     1.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.028    -2.309
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.190    -1.075
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.083    -0.943
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.093    -0.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.429    -1.038
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -1.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.075    -2.142
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.887    -0.533
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.555    -0.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.491    -1.607
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.745    -1.597
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.055    -1.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.786    -0.814
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.010     0.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.581     1.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.250    -2.001
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.225    -2.121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.879     0.539
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.046     0.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.145    -0.680
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.879    -0.487
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.619   -18.186
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.619   -18.186 537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.642    -0.488
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.642    -0.488 538
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.115    -6.326
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.115    -6.326 539
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.659    -1.240
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.269   -16.327
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.269   -16.327 541
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.919   -12.781
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.919   -12.781 542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.593     1.614
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.593     1.614 543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.631    -0.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.103    -5.918
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.103    -5.918 545
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.035   -18.366
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.035   -18.366 546
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -0.260    -2.744     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -49.000    49.000 Author: all ( 546 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -49.000   -49.000 Average =   2.8 km at 185.4 deg; median =    2.3 km
EOF
gmt end
