#!/bin/bash
gmt begin chamoli16.22_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-22/34/0/140
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya100f25+lCounts -BWeSn+t'Focal Depth Mislocation chamoli16.22' << EOF
    11.900
     5.800
    -5.000
    11.600
    -0.200
     3.700
    11.800
     2.800
    17.000
    10.000
    26.000
    -3.800
    14.000
    13.000
    15.000
    12.000
    13.000
    23.000
     6.800
     4.100
    22.000
     4.400
    22.000
    24.400
     9.000
    -3.800
    10.200
    27.000
    18.000
     8.500
    16.000
     7.800
    -4.300
     3.700
    -6.400
     1.800
    -9.300
    -6.600
     0.500
    -5.000
     4.000
    -7.300
    -9.300
    -2.600
     3.800
    -5.700
    -3.200
    -5.500
    -1.800
    -7.300
    -1.900
   -10.000
    -6.000
    -4.000
    -7.000
    -8.000
    -2.100
     0.500
    -0.600
     2.000
     1.500
     2.000
     2.200
     6.000
    -1.400
    -0.500
     1.400
    -0.000
     1.200
     0.500
    -1.300
     1.200
     1.000
    -3.000
     3.600
    -0.600
     1.600
     1.400
     2.600
     2.900
     2.900
    -0.400
     1.000
    -2.000
     3.000
     0.400
     2.500
    -1.100
     3.000
     0.300
     0.200
     0.700
     1.600
    -2.700
    -1.100
     1.400
    -0.800
     0.200
    -0.300
    -0.800
     0.500
     1.100
     0.900
    -0.000
    -0.200
     4.200
    -1.400
     1.000
    -0.000
     3.000
    -1.800
    -1.100
    -4.400
     0.300
     5.000
     1.700
     0.900
    -0.500
    -0.200
     1.400
    -1.000
     0.700
    -0.000
    -1.200
    -0.500
    -4.000
     1.900
    -0.200
     2.300
     0.100
     0.200
    -2.700
     0.900
    -0.500
     1.500
     0.500
     1.400
    -5.200
     3.000
     0.700
     1.700
     1.100
    -2.000
    -0.800
     0.200
     2.100
     1.800
     0.700
    -3.800
    -2.600
     0.900
     2.200
    -7.000
    -1.000
    17.100
    11.000
     1.800
     2.200
    29.000
    17.000
    24.400
     3.400
     7.000
    11.700
     7.200
     6.400
     1.600
     3.000
    -0.000
    17.600
    12.000
    -0.000
     8.200
     6.000
    -5.600
    14.900
    16.100
     8.800
     0.300
    -0.000
    14.000
    -2.000
     5.000
    25.100
    10.100
     2.400
    12.900
     5.000
     5.000
     1.900
    17.800
    17.000
     6.600
     3.000
     3.500
     6.800
     4.400
    -0.700
    -5.600
   -13.600
    -4.400
    13.000
     1.400
    12.000
    -3.100
    12.600
    -5.800
    13.800
     2.000
    -9.000
   -15.700
    -2.700
     7.300
    -0.000
    -1.000
     6.000
    12.000
    15.400
    -2.200
    -6.600
    -0.400
     4.400
     0.300
     0.100
     0.500
     0.200
    -0.000
    -0.500
    -0.400
    -0.300
    -4.000
     4.000
    -1.500
    -2.000
    -0.200
    -1.600
     0.800
    -0.000
     0.100
    -0.000
    -0.500
    -0.100
    -0.200
    -0.000
     0.100
    -0.200
     0.500
    -0.700
     0.300
     0.100
     0.400
    -0.700
     2.100
     1.000
    -2.400
     4.100
     2.700
     1.500
     1.000
    -1.000
    -2.100
    -1.800
    -1.300
    -1.900
    -0.900
    -1.000
    -6.500
    -0.000
    -2.000
    -1.600
    -1.800
     1.000
    -0.900
    -2.500
    -2.400
    -1.300
    -0.100
    -2.000
    -3.000
    -1.300
    -0.500
    -0.600
    -1.000
     0.300
    -1.000
    -0.300
     2.600
     0.600
    -0.300
    -0.100
     0.100
    -0.300
    -0.200
     0.300
    -0.200
     1.300
    -6.400
     0.400
    -0.100
    -3.300
    -0.400
     0.400
    -0.300
     1.000
    -0.200
     0.400
    -0.100
     0.100
     0.500
    -1.600
     1.100
    -2.000
    -0.500
    -2.000
     0.800
     1.400
    -0.000
    -0.300
    -0.500
     0.400
    -0.400
    -2.400
    -4.100
    -0.500
    -3.900
     0.100
     4.000
    -0.300
     2.200
    -0.300
    -2.000
    -3.100
    -0.000
    -1.300
     1.200
     1.500
    -1.500
     0.900
    -1.500
    -3.000
     3.300
    -2.300
    -2.200
     1.100
     0.100
     0.500
    -0.700
    -0.500
    -1.800
     0.600
    -1.700
    -0.200
     0.900
    -1.700
    -1.400
     0.800
    -0.800
     4.400
     3.900
     1.000
    -0.600
    -1.300
    -0.400
    -2.200
     1.200
    -0.000
    -0.500
     0.500
    -0.600
     1.600
    -2.000
    -0.600
    -0.600
    -1.000
     0.100
     4.800
    -0.600
     0.100
     0.500
     0.600
    -0.700
    -0.500
    -0.800
    -0.400
     0.200
     0.500
     0.200
    -0.400
    -0.000
    -0.800
    -3.500
     0.400
    -1.200
    -1.000
    -0.900
     2.500
    -0.300
     1.400
    -3.000
    -1.100
    -1.100
    -1.000
    -0.600
    -2.000
     3.800
    -1.200
     1.800
     0.800
    -0.100
     1.600
     0.800
    -0.000
    -1.700
     0.600
    -3.000
    -0.000
     0.100
    -0.000
    -1.000
    -1.000
    -1.600
    -3.500
    -0.100
    -1.000
    -1.100
     0.900
     0.300
     2.400
    -0.200
     1.400
    -0.500
     0.500
    -0.200
    -2.300
    -0.700
    -1.000
    -1.100
    -1.400
     1.200
    -1.000
     0.900
    -0.600
     0.400
    -3.500
     0.800
     3.900
    -0.600
     0.100
    -2.000
    -0.500
     1.200
    -0.000
     1.000
    -2.400
    -1.800
     9.200
    -0.500
     0.200
     4.100
    -1.800
    -0.800
     0.600
     0.900
     0.200
    -1.900
    -2.000
    -0.700
    -1.800
    -0.500
    -2.300
    -1.000
     2.600
    -0.500
    -3.000
    -5.000
     3.200
    -1.600
    -1.200
     0.100
    -1.300
    -4.000
    -2.400
    -0.000
    -0.000
     3.100
     2.000
     0.100
    -3.500
     3.500
    -0.200
     3.600
     2.100
    -0.100
    -1.100
    -1.500
    -0.300
    -0.000
     1.200
    -2.300
    -2.000
    -1.100
    -1.800
    -0.000
     1.400
     0.200
    -1.200
     0.800
    -0.000
    -0.700
    -4.000
     5.700
    -0.100
     5.300
     0.200
    -0.500
     0.100
    -2.000
    -4.600
     2.000
    -1.000
    -0.200
    -1.000
     0.500
    -0.500
    -0.800
    -0.800
    -0.900
     0.600
    -0.900
    -1.800
    -0.600
    -1.100
    -0.400
     0.400
     0.100
     5.900
    18.800
     0.200
     0.700
     3.800
    -3.400
     0.500
     3.100
    -0.000
     8.200
   -17.400
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.000   124.350 Median =  -0.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.0  0.
 -0.0 121.9
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -21.000   132.650 Author: all ( 546 samples)
EOF
gmt end
