#!/bin/bash
gmt begin chamoli16.22_dcal pdf,ps
proj=-JM16.0c+
reg=-R75.4/83.1/27.7/33.1
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration chamoli16.22'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
    78.056    30.323
    78.689    30.878
>
    78.056    30.323
    78.689    30.878
>
    80.217    29.550
    80.486    29.908
>
    80.217    29.550
    79.741    30.088
>
    78.056    30.323
    78.784    30.755
>
    78.056    30.323
    78.734    30.826
>
    78.056    30.323
    78.734    30.826
>
    78.056    30.323
    78.717    30.794
>
    78.056    30.323
    78.717    30.794
>
    78.056    30.323
    78.680    30.779
>
    78.056    30.323
    78.680    30.779
>
    80.217    29.550
    80.645    29.934
>
    80.217    29.550
    80.645    29.934
>
    79.217    30.262
    79.388    30.395
>
    79.217    30.262
    79.388    30.395
>
    79.217    30.262
    79.438    30.461
>
    79.217    30.262
    79.361    30.510
>
    79.217    30.262
    79.361    30.510
>
    78.757    30.526
    79.418    30.477
>
    78.757    30.526
    79.418    30.477
>
    79.321    30.407
    79.416    30.432
>
    79.321    30.407
    79.416    30.432
>
    79.217    30.262
    79.416    30.432
>
    79.217    30.262
    79.416    30.432
>
    79.223    30.252
    79.416    30.432
>
    79.090    30.510
    79.416    30.432
>
    79.090    30.510
    79.416    30.432
>
    79.042    30.413
    79.416    30.432
>
    79.042    30.413
    79.416    30.432
>
    78.757    30.526
    79.416    30.432
>
    79.427    30.437
    79.379    30.428
>
    79.427    30.437
    79.379    30.428
>
    79.217    30.262
    79.379    30.428
>
    79.217    30.262
    79.379    30.428
>
    79.223    30.252
    79.379    30.428
>
    79.069    30.426
    79.379    30.428
>
    79.042    30.413
    79.379    30.428
>
    78.757    30.526
    79.379    30.428
>
    79.319    30.418
    79.380    30.430
>
    79.321    30.407
    79.380    30.430
>
    79.317    30.383
    79.380    30.430
>
    79.442    30.463
    79.380    30.430
>
    79.442    30.463
    79.380    30.430
>
    79.223    30.252
    79.380    30.430
>
    79.223    30.252
    79.380    30.430
>
    79.217    30.262
    79.380    30.430
>
    79.217    30.262
    79.380    30.430
>
    79.217    30.262
    79.380    30.430
>
    79.217    30.262
    79.380    30.430
>
    79.090    30.510
    79.380    30.430
>
    79.042    30.413
    79.380    30.430
>
    79.042    30.413
    79.380    30.430
>
    79.321    30.407
    79.372    30.428
>
    79.321    30.407
    79.372    30.428
>
    79.317    30.383
    79.372    30.428
>
    79.317    30.383
    79.372    30.428
>
    79.427    30.437
    79.372    30.428
>
    79.442    30.463
    79.372    30.428
>
    79.442    30.463
    79.372    30.428
>
    79.217    30.262
    79.372    30.428
>
    79.217    30.262
    79.372    30.428
>
    79.223    30.252
    79.372    30.428
>
    79.223    30.252
    79.372    30.428
>
    79.069    30.426
    79.372    30.428
>
    79.090    30.510
    79.372    30.428
>
    79.042    30.413
    79.372    30.428
>
    79.042    30.413
    79.372    30.428
>
    78.757    30.526
    79.372    30.428
>
    79.427    30.437
    79.465    30.389
>
    79.427    30.437
    79.465    30.389
>
    79.442    30.463
    79.465    30.389
>
    79.321    30.407
    79.465    30.389
>
    79.321    30.407
    79.465    30.389
>
    79.223    30.252
    79.465    30.389
>
    79.223    30.252
    79.465    30.389
>
    79.217    30.262
    79.465    30.389
>
    79.217    30.262
    79.465    30.389
>
    79.069    30.426
    79.465    30.389
>
    79.090    30.510
    79.465    30.389
>
    79.042    30.413
    79.465    30.389
>
    79.042    30.413
    79.465    30.389
>
    78.757    30.526
    79.465    30.389
>
    79.321    30.407
    79.408    30.423
>
    79.321    30.407
    79.408    30.423
>
    79.442    30.463
    79.408    30.423
>
    79.442    30.463
    79.408    30.423
>
    79.317    30.383
    79.408    30.423
>
    79.317    30.383
    79.408    30.423
>
    79.561    30.555
    79.408    30.423
>
    79.561    30.555
    79.408    30.423
>
    79.247    30.247
    79.408    30.423
>
    79.217    30.262
    79.408    30.423
>
    79.217    30.262
    79.408    30.423
>
    79.223    30.252
    79.408    30.423
>
    79.223    30.252
    79.408    30.423
>
    79.108    30.296
    79.408    30.423
>
    79.069    30.426
    79.408    30.423
>
    79.090    30.510
    79.408    30.423
>
    78.757    30.526
    79.408    30.423
>
    79.321    30.407
    79.364    30.438
>
    79.321    30.407
    79.364    30.438
>
    79.427    30.437
    79.364    30.438
>
    79.427    30.437
    79.364    30.438
>
    79.442    30.463
    79.364    30.438
>
    79.247    30.247
    79.364    30.438
>
    79.247    30.247
    79.364    30.438
>
    79.217    30.262
    79.364    30.438
>
    79.217    30.262
    79.364    30.438
>
    79.561    30.555
    79.364    30.438
>
    79.561    30.555
    79.364    30.438
>
    79.108    30.296
    79.364    30.438
>
    79.069    30.426
    79.364    30.438
>
    78.757    30.526
    79.364    30.438
>
    79.442    30.463
    79.414    30.421
>
    79.442    30.463
    79.414    30.421
>
    79.320    30.410
    79.414    30.421
>
    79.320    30.410
    79.414    30.421
>
    79.561    30.555
    79.414    30.421
>
    79.561    30.555
    79.414    30.421
>
    79.223    30.252
    79.414    30.421
>
    79.217    30.262
    79.414    30.421
>
    79.223    30.252
    79.414    30.421
>
    79.217    30.262
    79.414    30.421
>
    79.108    30.296
    79.414    30.421
>
    79.108    30.296
    79.414    30.421
>
    79.069    30.426
    79.414    30.421
>
    79.090    30.510
    79.414    30.421
>
    79.090    30.510
    79.414    30.421
>
    78.757    30.526
    79.414    30.421
>
    78.757    30.526
    79.414    30.421
>
    79.320    30.410
    79.418    30.433
>
    79.320    30.410
    79.418    30.433
>
    79.427    30.437
    79.418    30.433
>
    79.427    30.437
    79.418    30.433
>
    79.442    30.463
    79.418    30.433
>
    79.442    30.463
    79.418    30.433
>
    79.217    30.262
    79.418    30.433
>
    79.223    30.252
    79.418    30.433
>
    79.223    30.252
    79.418    30.433
>
    79.217    30.262
    79.418    30.433
>
    79.090    30.510
    79.418    30.433
>
    79.090    30.510
    79.418    30.433
>
    79.069    30.426
    79.418    30.433
>
    79.069    30.426
    79.418    30.433
>
    79.108    30.296
    79.418    30.433
>
    79.108    30.296
    79.418    30.433
>
    78.757    30.526
    79.418    30.433
>
    79.321    30.407
    79.355    30.448
>
    79.321    30.407
    79.355    30.448
>
    79.427    30.437
    79.355    30.448
>
    79.427    30.437
    79.355    30.448
>
    79.442    30.463
    79.355    30.448
>
    79.442    30.463
    79.355    30.448
>
    79.217    30.262
    79.355    30.448
>
    79.217    30.262
    79.355    30.448
>
    79.223    30.252
    79.355    30.448
>
    79.223    30.252
    79.355    30.448
>
    79.069    30.426
    79.355    30.448
>
    79.069    30.426
    79.355    30.448
>
    79.108    30.296
    79.355    30.448
>
    79.108    30.296
    79.355    30.448
>
    78.757    30.526
    79.355    30.448
>
    78.757    30.526
    79.355    30.448
>
    79.427    30.437
    79.447    30.422
>
    79.427    30.437
    79.447    30.422
>
    79.321    30.328
    79.447    30.422
>
    79.442    30.463
    79.447    30.422
>
    79.442    30.463
    79.447    30.422
>
    79.217    30.262
    79.447    30.422
>
    79.217    30.262
    79.447    30.422
>
    79.223    30.252
    79.447    30.422
>
    79.108    30.296
    79.447    30.422
>
    79.108    30.296
    79.447    30.422
>
    79.069    30.426
    79.447    30.422
>
    78.757    30.526
    79.447    30.422
>
    78.757    30.526
    79.447    30.422
>
    79.321    30.407
    79.360    30.422
>
    79.321    30.407
    79.360    30.422
>
    79.427    30.437
    79.360    30.422
>
    79.427    30.437
    79.360    30.422
>
    79.442    30.463
    79.360    30.422
>
    79.442    30.463
    79.360    30.422
>
    79.223    30.252
    79.360    30.422
>
    79.217    30.262
    79.360    30.422
>
    79.217    30.262
    79.360    30.422
>
    79.223    30.252
    79.360    30.422
>
    79.108    30.296
    79.360    30.422
>
    79.108    30.296
    79.360    30.422
>
    79.561    30.555
    79.360    30.422
>
    79.561    30.555
    79.360    30.422
>
    78.757    30.526
    79.360    30.422
>
    78.757    30.526
    79.360    30.422
>
    79.320    30.410
    79.370    30.432
>
    79.320    30.410
    79.370    30.432
>
    79.427    30.437
    79.370    30.432
>
    79.427    30.437
    79.370    30.432
>
    79.442    30.463
    79.370    30.432
>
    79.442    30.463
    79.370    30.432
>
    79.217    30.262
    79.370    30.432
>
    79.223    30.252
    79.370    30.432
>
    79.223    30.252
    79.370    30.432
>
    79.561    30.555
    79.370    30.432
>
    79.561    30.555
    79.370    30.432
>
    79.090    30.510
    79.370    30.432
>
    79.090    30.510
    79.370    30.432
>
    79.069    30.426
    79.370    30.432
>
    79.108    30.296
    79.370    30.432
>
    79.108    30.296
    79.370    30.432
>
    78.757    30.526
    79.370    30.432
>
    79.321    30.407
    79.405    30.425
>
    79.321    30.407
    79.405    30.425
>
    79.427    30.437
    79.405    30.425
>
    79.427    30.437
    79.405    30.425
>
    79.321    30.328
    79.405    30.425
>
    79.442    30.463
    79.405    30.425
>
    79.442    30.463
    79.405    30.425
>
    79.217    30.262
    79.405    30.425
>
    79.217    30.262
    79.405    30.425
>
    79.561    30.555
    79.405    30.425
>
    79.561    30.555
    79.405    30.425
>
    79.069    30.426
    79.405    30.425
>
    79.069    30.426
    79.405    30.425
>
    78.757    30.526
    79.405    30.425
>
    78.757    30.526
    79.405    30.425
>
    78.621    30.305
    79.405    30.425
>
    79.319    30.418
    79.369    30.424
>
    79.319    30.418
    79.369    30.424
>
    79.321    30.328
    79.369    30.424
>
    79.321    30.328
    79.369    30.424
>
    79.427    30.437
    79.369    30.424
>
    79.427    30.437
    79.369    30.424
>
    79.442    30.463
    79.369    30.424
>
    79.442    30.463
    79.369    30.424
>
    79.217    30.262
    79.369    30.424
>
    79.217    30.262
    79.369    30.424
>
    79.223    30.252
    79.369    30.424
>
    79.223    30.252
    79.369    30.424
>
    79.108    30.296
    79.369    30.424
>
    79.108    30.296
    79.369    30.424
>
    79.561    30.555
    79.369    30.424
>
    79.561    30.555
    79.369    30.424
>
    79.069    30.426
    79.369    30.424
>
    79.069    30.426
    79.369    30.424
>
    78.757    30.526
    79.369    30.424
>
    78.621    30.305
    79.369    30.424
>
    79.090    30.510
    79.239    30.487
>
    79.090    30.510
    79.239    30.487
>
    79.069    30.426
    79.239    30.487
>
    79.069    30.426
    79.239    30.487
>
    79.321    30.407
    79.239    30.487
>
    79.321    30.407
    79.239    30.487
>
    79.042    30.413
    79.239    30.487
>
    79.042    30.413
    79.239    30.487
>
    79.042    30.413
    79.239    30.487
>
    79.321    30.328
    79.239    30.487
>
    79.321    30.328
    79.239    30.487
>
    79.442    30.463
    79.239    30.487
>
    79.442    30.463
    79.239    30.487
>
    79.223    30.252
    79.239    30.487
>
    79.223    30.252
    79.239    30.487
>
    79.561    30.555
    79.239    30.487
>
    79.561    30.555
    79.239    30.487
>
    78.757    30.526
    79.239    30.487
>
    78.757    30.526
    79.239    30.487
>
    78.621    30.305
    79.239    30.487
>
    78.430    30.377
    79.239    30.487
>
    78.430    30.377
    79.239    30.487
>
    78.432    30.304
    79.239    30.487
>
    79.090    30.510
    79.246    30.479
>
    79.090    30.510
    79.246    30.479
>
    79.321    30.407
    79.246    30.479
>
    79.321    30.407
    79.246    30.479
>
    79.317    30.383
    79.246    30.479
>
    79.317    30.383
    79.246    30.479
>
    79.069    30.426
    79.246    30.479
>
    79.069    30.426
    79.246    30.479
>
    79.042    30.413
    79.246    30.479
>
    79.042    30.413
    79.246    30.479
>
    79.321    30.328
    79.246    30.479
>
    79.321    30.328
    79.246    30.479
>
    79.442    30.463
    79.246    30.479
>
    79.442    30.463
    79.246    30.479
>
    79.108    30.296
    79.246    30.479
>
    79.108    30.296
    79.246    30.479
>
    79.561    30.555
    79.246    30.479
>
    79.561    30.555
    79.246    30.479
>
    78.757    30.526
    79.246    30.479
>
    78.757    30.526
    79.246    30.479
>
    78.621    30.305
    79.246    30.479
>
    78.621    30.305
    79.246    30.479
>
    78.430    30.377
    79.246    30.479
>
    78.430    30.377
    79.246    30.479
>
    78.432    30.304
    79.246    30.479
>
    79.321    30.407
    79.313    30.544
>
    79.321    30.407
    79.313    30.544
>
    79.090    30.510
    79.313    30.544
>
    79.090    30.510
    79.313    30.544
>
    79.442    30.463
    79.313    30.544
>
    79.442    30.463
    79.313    30.544
>
    79.069    30.426
    79.313    30.544
>
    79.069    30.426
    79.313    30.544
>
    79.321    30.328
    79.313    30.544
>
    79.042    30.413
    79.313    30.544
>
    79.042    30.413
    79.313    30.544
>
    79.042    30.413
    79.313    30.544
>
    79.561    30.555
    79.313    30.544
>
    79.561    30.555
    79.313    30.544
>
    79.217    30.262
    79.313    30.544
>
    79.217    30.262
    79.313    30.544
>
    79.108    30.296
    79.313    30.544
>
    79.108    30.296
    79.313    30.544
>
    79.223    30.252
    79.313    30.544
>
    79.223    30.252
    79.313    30.544
>
    79.456    30.251
    79.313    30.544
>
    79.456    30.251
    79.313    30.544
>
    78.757    30.526
    79.313    30.544
>
    78.757    30.526
    79.313    30.544
>
    78.621    30.305
    79.313    30.544
>
    78.621    30.305
    79.313    30.544
>
    78.430    30.377
    79.313    30.544
>
    78.430    30.377
    79.313    30.544
>
    78.432    30.304
    79.313    30.544
>
    79.321    30.407
    79.374    30.429
>
    79.321    30.407
    79.374    30.429
>
    79.321    30.328
    79.374    30.429
>
    79.321    30.328
    79.374    30.429
>
    79.427    30.437
    79.374    30.429
>
    79.427    30.437
    79.374    30.429
>
    79.456    30.251
    79.374    30.429
>
    79.456    30.251
    79.374    30.429
>
    79.223    30.252
    79.374    30.429
>
    79.223    30.252
    79.374    30.429
>
    79.108    30.296
    79.374    30.429
>
    79.108    30.296
    79.374    30.429
>
    79.561    30.555
    79.374    30.429
>
    79.561    30.555
    79.374    30.429
>
    79.042    30.413
    79.374    30.429
>
    79.042    30.413
    79.374    30.429
>
    78.621    30.305
    79.374    30.429
>
    78.621    30.305
    79.374    30.429
>
    79.321    30.407
    79.244    30.478
>
    79.321    30.407
    79.244    30.478
>
    79.090    30.510
    79.244    30.478
>
    79.090    30.510
    79.244    30.478
>
    79.442    30.463
    79.244    30.478
>
    79.442    30.463
    79.244    30.478
>
    79.217    30.262
    79.244    30.478
>
    79.217    30.262
    79.244    30.478
>
    79.223    30.252
    79.244    30.478
>
    79.223    30.252
    79.244    30.478
>
    79.561    30.555
    79.244    30.478
>
    79.561    30.555
    79.244    30.478
>
    79.321    30.407
    79.372    30.423
>
    79.321    30.407
    79.372    30.423
>
    79.263    30.465
    79.372    30.423
>
    79.263    30.465
    79.372    30.423
>
    79.427    30.437
    79.372    30.423
>
    79.427    30.437
    79.372    30.423
>
    79.217    30.262
    79.372    30.423
>
    79.217    30.262
    79.372    30.423
>
    79.223    30.252
    79.372    30.423
>
    79.223    30.252
    79.372    30.423
>
    79.090    30.510
    79.372    30.423
>
    79.090    30.510
    79.372    30.423
>
    79.108    30.296
    79.372    30.423
>
    79.561    30.555
    79.372    30.423
>
    79.561    30.555
    79.372    30.423
>
    78.757    30.526
    79.372    30.423
>
    78.757    30.526
    79.372    30.423
>
    78.621    30.305
    79.372    30.423
>
    78.621    30.305
    79.372    30.423
>
    79.321    30.407
    79.360    30.451
>
    79.427    30.437
    79.360    30.451
>
    79.427    30.437
    79.360    30.451
>
    79.263    30.465
    79.360    30.451
>
    79.263    30.465
    79.360    30.451
>
    79.321    30.328
    79.360    30.451
>
    79.321    30.328
    79.360    30.451
>
    79.561    30.555
    79.360    30.451
>
    79.561    30.555
    79.360    30.451
>
    79.217    30.262
    79.360    30.451
>
    79.223    30.252
    79.360    30.451
>
    79.223    30.252
    79.360    30.451
>
    79.069    30.426
    79.360    30.451
>
    78.757    30.526
    79.360    30.451
>
    78.621    30.305
    79.360    30.451
>
    78.621    30.305
    79.360    30.451
>
    79.319    30.418
    79.357    30.422
>
    79.320    30.410
    79.357    30.422
>
    79.320    30.410
    79.357    30.422
>
    79.319    30.418
    79.357    30.422
>
    79.396    30.403
    79.357    30.422
>
    79.396    30.403
    79.357    30.422
>
    79.263    30.465
    79.357    30.422
>
    79.263    30.465
    79.357    30.422
>
    79.321    30.328
    79.357    30.422
>
    79.427    30.437
    79.357    30.422
>
    79.427    30.437
    79.357    30.422
>
    79.217    30.262
    79.357    30.422
>
    79.217    30.262
    79.357    30.422
>
    79.090    30.510
    79.357    30.422
>
    79.090    30.510
    79.357    30.422
>
    79.108    30.296
    79.357    30.422
>
    79.108    30.296
    79.357    30.422
>
    79.069    30.426
    79.357    30.422
>
    79.561    30.555
    79.357    30.422
>
    79.561    30.555
    79.357    30.422
>
    78.998    30.631
    79.357    30.422
>
    78.757    30.526
    79.357    30.422
>
    78.621    30.305
    79.357    30.422
>
    78.621    30.305
    79.357    30.422
>
    79.263    30.465
    79.241    30.465
>
    79.263    30.465
    79.241    30.465
>
    79.321    30.407
    79.241    30.465
>
    79.321    30.407
    79.241    30.465
>
    79.396    30.403
    79.241    30.465
>
    79.396    30.403
    79.241    30.465
>
    79.321    30.328
    79.241    30.465
>
    79.321    30.328
    79.241    30.465
>
    79.090    30.510
    79.241    30.465
>
    79.090    30.510
    79.241    30.465
>
    79.069    30.426
    79.241    30.465
>
    79.069    30.426
    79.241    30.465
>
    79.427    30.437
    79.241    30.465
>
    79.427    30.437
    79.241    30.465
>
    79.217    30.262
    79.241    30.465
>
    79.217    30.262
    79.241    30.465
>
    79.108    30.296
    79.241    30.465
>
    79.108    30.296
    79.241    30.465
>
    79.223    30.252
    79.241    30.465
>
    79.223    30.252
    79.241    30.465
>
    79.561    30.555
    79.241    30.465
>
    79.561    30.555
    79.241    30.465
>
    78.757    30.526
    79.241    30.465
>
    78.757    30.526
    79.241    30.465
>
    78.621    30.305
    79.241    30.465
>
    78.430    30.377
    79.241    30.465
>
    78.432    30.304
    79.241    30.465
>
    79.263    30.465
    79.240    30.461
>
    79.263    30.465
    79.240    30.461
>
    79.319    30.418
    79.240    30.461
>
    79.319    30.418
    79.240    30.461
>
    79.320    30.410
    79.240    30.461
>
    79.320    30.410
    79.240    30.461
>
    79.090    30.510
    79.240    30.461
>
    79.090    30.510
    79.240    30.461
>
    79.069    30.426
    79.240    30.461
>
    79.321    30.328
    79.240    30.461
>
    79.321    30.328
    79.240    30.461
>
    79.396    30.403
    79.240    30.461
>
    79.396    30.403
    79.240    30.461
>
    79.427    30.437
    79.240    30.461
>
    79.427    30.437
    79.240    30.461
>
    79.217    30.262
    79.240    30.461
>
    79.217    30.262
    79.240    30.461
>
    78.998    30.631
    79.240    30.461
>
    78.998    30.631
    79.240    30.461
>
    79.561    30.555
    79.240    30.461
>
    79.561    30.555
    79.240    30.461
>
    78.757    30.526
    79.240    30.461
>
    78.757    30.526
    79.240    30.461
>
    78.621    30.305
    79.240    30.461
>
    78.430    30.377
    79.240    30.461
>
    78.432    30.304
    79.240    30.461
>
    79.321    30.407
    79.363    30.450
>
    79.321    30.407
    79.363    30.450
>
    79.396    30.403
    79.363    30.450
>
    79.396    30.403
    79.363    30.450
>
    79.427    30.437
    79.363    30.450
>
    79.427    30.437
    79.363    30.450
>
    79.321    30.328
    79.363    30.450
>
    79.321    30.328
    79.363    30.450
>
    79.334    30.250
    79.363    30.450
>
    79.334    30.250
    79.363    30.450
>
    79.090    30.510
    79.363    30.450
>
    79.223    30.252
    79.363    30.450
>
    79.223    30.252
    79.363    30.450
>
    79.561    30.555
    79.363    30.450
>
    79.561    30.555
    79.363    30.450
>
    79.042    30.413
    79.363    30.450
>
    79.042    30.413
    79.363    30.450
>
    78.757    30.526
    79.363    30.450
>
    78.621    30.305
    79.363    30.450
>
    79.319    30.418
    79.389    30.425
>
    79.319    30.418
    79.389    30.425
>
    79.427    30.437
    79.389    30.425
>
    79.427    30.437
    79.389    30.425
>
    79.321    30.328
    79.389    30.425
>
    79.321    30.328
    79.389    30.425
>
    79.321    30.328
    79.389    30.425
>
    79.442    30.463
    79.389    30.425
>
    79.442    30.463
    79.389    30.425
>
    79.334    30.250
    79.389    30.425
>
    79.334    30.250
    79.389    30.425
>
    79.217    30.262
    79.389    30.425
>
    79.217    30.262
    79.389    30.425
>
    79.223    30.252
    79.389    30.425
>
    79.223    30.252
    79.389    30.425
>
    79.223    30.252
    79.389    30.425
>
    79.123    30.549
    79.389    30.425
>
    79.123    30.549
    79.389    30.425
>
    79.090    30.510
    79.389    30.425
>
    79.090    30.510
    79.389    30.425
>
    79.090    30.510
    79.389    30.425
>
    79.069    30.426
    79.389    30.425
>
    79.042    30.413
    79.389    30.425
>
    78.998    30.631
    79.389    30.425
>
    78.757    30.526
    79.389    30.425
>
    78.621    30.305
    79.389    30.425
>
    78.621    30.305
    79.389    30.425
>
    79.123    30.549
    79.230    30.502
>
    79.123    30.549
    79.230    30.502
>
    79.090    30.510
    79.230    30.502
>
    79.090    30.510
    79.230    30.502
>
    79.069    30.426
    79.230    30.502
>
    79.069    30.426
    79.230    30.502
>
    79.042    30.413
    79.230    30.502
>
    79.042    30.413
    79.230    30.502
>
    79.321    30.328
    79.230    30.502
>
    79.321    30.328
    79.230    30.502
>
    79.108    30.296
    79.230    30.502
>
    79.108    30.296
    79.230    30.502
>
    79.223    30.252
    79.230    30.502
>
    79.223    30.252
    79.230    30.502
>
    79.561    30.555
    79.230    30.502
>
    78.757    30.526
    79.230    30.502
>
    78.757    30.526
    79.230    30.502
>
    78.621    30.305
    79.230    30.502
>
    78.621    30.305
    79.230    30.502
>
    78.432    30.304
    79.230    30.502
>
    79.319    30.418
    79.368    30.396
>
    79.321    30.328
    79.368    30.396
>
    79.321    30.328
    79.368    30.396
>
    79.334    30.250
    79.368    30.396
>
    79.334    30.250
    79.368    30.396
>
    79.217    30.262
    79.368    30.396
>
    79.223    30.252
    79.368    30.396
>
    79.223    30.252
    79.368    30.396
>
    79.108    30.296
    79.368    30.396
>
    79.108    30.296
    79.368    30.396
>
    79.042    30.413
    79.368    30.396
>
    79.090    30.510
    79.368    30.396
>
    79.042    30.413
    79.368    30.396
>
    79.090    30.510
    79.368    30.396
>
    79.123    30.549
    79.368    30.396
>
    79.123    30.549
    79.368    30.396
>
    79.561    30.555
    79.368    30.396
>
    79.561    30.555
    79.368    30.396
>
    78.757    30.526
    79.368    30.396
>
    78.621    30.305
    79.368    30.396
>
    78.621    30.305
    79.368    30.396
>
    79.396    30.403
    79.387    30.436
>
    79.396    30.403
    79.387    30.436
>
    79.319    30.418
    79.387    30.436
>
    79.427    30.437
    79.387    30.436
>
    79.427    30.437
    79.387    30.436
>
    79.442    30.463
    79.387    30.436
>
    79.442    30.463
    79.387    30.436
>
    79.263    30.465
    79.387    30.436
>
    79.321    30.328
    79.387    30.436
>
    79.321    30.328
    79.387    30.436
>
    79.217    30.262
    79.387    30.436
>
    79.217    30.262
    79.387    30.436
>
    79.223    30.252
    79.387    30.436
>
    79.223    30.252
    79.387    30.436
>
    79.561    30.555
    79.387    30.436
>
    79.561    30.555
    79.387    30.436
>
    79.123    30.549
    79.387    30.436
>
    79.123    30.549
    79.387    30.436
>
    79.108    30.296
    79.387    30.436
>
    79.090    30.510
    79.387    30.436
>
    79.090    30.510
    79.387    30.436
>
    79.069    30.426
    79.387    30.436
>
    79.108    30.296
    79.387    30.436
>
    79.042    30.413
    79.387    30.436
>
    79.042    30.413
    79.387    30.436
>
    78.757    30.526
    79.387    30.436
>
    78.757    30.526
    79.387    30.436
>
    78.621    30.305
    79.387    30.436
>
    78.621    30.305
    79.387    30.436
>
    79.319    30.418
    79.386    30.435
>
    79.319    30.418
    79.386    30.435
>
    79.396    30.403
    79.386    30.435
>
    79.396    30.403
    79.386    30.435
>
    79.427    30.437
    79.386    30.435
>
    79.427    30.437
    79.386    30.435
>
    79.442    30.463
    79.386    30.435
>
    79.442    30.463
    79.386    30.435
>
    79.263    30.465
    79.386    30.435
>
    79.263    30.465
    79.386    30.435
>
    79.321    30.328
    79.386    30.435
>
    79.321    30.328
    79.386    30.435
>
    79.334    30.250
    79.386    30.435
>
    79.334    30.250
    79.386    30.435
>
    79.561    30.555
    79.386    30.435
>
    79.561    30.555
    79.386    30.435
>
    79.223    30.252
    79.386    30.435
>
    79.223    30.252
    79.386    30.435
>
    79.123    30.549
    79.386    30.435
>
    79.123    30.549
    79.386    30.435
>
    79.090    30.510
    79.386    30.435
>
    79.090    30.510
    79.386    30.435
>
    79.042    30.413
    79.386    30.435
>
    78.757    30.526
    79.386    30.435
>
    78.757    30.526
    79.386    30.435
>
    78.621    30.305
    79.386    30.435
>
    79.396    30.403
    79.397    30.359
>
    79.396    30.403
    79.397    30.359
>
    79.334    30.250
    79.397    30.359
>
    79.427    30.437
    79.397    30.359
>
    79.427    30.437
    79.397    30.359
>
    79.319    30.418
    79.397    30.359
>
    79.442    30.463
    79.397    30.359
>
    79.217    30.262
    79.397    30.359
>
    79.217    30.262
    79.397    30.359
>
    79.263    30.465
    79.397    30.359
>
    79.108    30.296
    79.397    30.359
>
    79.561    30.555
    79.397    30.359
>
    79.123    30.549
    79.397    30.359
>
    79.123    30.549
    79.397    30.359
>
    79.042    30.413
    79.397    30.359
>
    79.090    30.510
    79.397    30.359
>
    78.757    30.526
    79.397    30.359
>
    78.621    30.305
    79.397    30.359
>
    79.396    30.403
    79.373    30.405
>
    79.396    30.403
    79.373    30.405
>
    79.319    30.418
    79.373    30.405
>
    79.319    30.418
    79.373    30.405
>
    79.427    30.437
    79.373    30.405
>
    79.427    30.437
    79.373    30.405
>
    79.321    30.328
    79.373    30.405
>
    79.321    30.328
    79.373    30.405
>
    79.442    30.463
    79.373    30.405
>
    79.442    30.463
    79.373    30.405
>
    79.263    30.465
    79.373    30.405
>
    79.263    30.465
    79.373    30.405
>
    79.334    30.250
    79.373    30.405
>
    79.217    30.262
    79.373    30.405
>
    79.217    30.262
    79.373    30.405
>
    79.223    30.252
    79.373    30.405
>
    79.223    30.252
    79.373    30.405
>
    79.108    30.296
    79.373    30.405
>
    79.561    30.555
    79.373    30.405
>
    79.561    30.555
    79.373    30.405
>
    79.123    30.549
    79.373    30.405
>
    79.090    30.510
    79.373    30.405
>
    79.090    30.510
    79.373    30.405
>
    78.757    30.526
    79.373    30.405
>
    78.621    30.305
    79.373    30.405
>
    79.396    30.403
    79.394    30.420
>
    79.396    30.403
    79.394    30.420
>
    79.427    30.437
    79.394    30.420
>
    79.427    30.437
    79.394    30.420
>
    79.321    30.328
    79.394    30.420
>
    79.321    30.328
    79.394    30.420
>
    79.217    30.262
    79.394    30.420
>
    79.123    30.549
    79.394    30.420
>
    79.123    30.549
    79.394    30.420
>
    79.561    30.555
    79.394    30.420
>
    79.561    30.555
    79.394    30.420
>
    79.090    30.510
    79.394    30.420
>
    79.090    30.510
    79.394    30.420
>
    79.069    30.426
    79.394    30.420
>
    79.069    30.426
    79.394    30.420
>
    79.042    30.413
    79.394    30.420
>
    79.042    30.413
    79.394    30.420
>
    78.757    30.526
    79.394    30.420
>
    78.757    30.526
    79.394    30.420
>
    78.621    30.305
    79.394    30.420
>
    78.621    30.305
    79.394    30.420
>
    79.321    30.328
    79.406    30.414
>
    79.321    30.328
    79.406    30.414
>
    79.263    30.465
    79.406    30.414
>
    79.263    30.465
    79.406    30.414
>
    79.334    30.250
    79.406    30.414
>
    79.223    30.252
    79.406    30.414
>
    79.223    30.252
    79.406    30.414
>
    79.561    30.555
    79.406    30.414
>
    79.561    30.555
    79.406    30.414
>
    79.108    30.296
    79.406    30.414
>
    79.108    30.296
    79.406    30.414
>
    79.069    30.426
    79.406    30.414
>
    79.069    30.426
    79.406    30.414
>
    79.123    30.549
    79.406    30.414
>
    79.090    30.510
    79.406    30.414
>
    79.090    30.510
    79.406    30.414
>
    78.757    30.526
    79.406    30.414
>
    78.621    30.305
    79.406    30.414
>
    79.396    30.403
    79.380    30.409
>
    79.396    30.403
    79.380    30.409
>
    79.263    30.465
    79.380    30.409
>
    79.427    30.437
    79.380    30.409
>
    79.427    30.437
    79.380    30.409
>
    79.321    30.328
    79.380    30.409
>
    79.321    30.328
    79.380    30.409
>
    79.334    30.250
    79.380    30.409
>
    79.217    30.262
    79.380    30.409
>
    79.217    30.262
    79.380    30.409
>
    79.223    30.252
    79.380    30.409
>
    79.223    30.252
    79.380    30.409
>
    79.123    30.549
    79.380    30.409
>
    79.123    30.549
    79.380    30.409
>
    79.108    30.296
    79.380    30.409
>
    79.108    30.296
    79.380    30.409
>
    79.069    30.426
    79.380    30.409
>
    79.090    30.510
    79.380    30.409
>
    79.090    30.510
    79.380    30.409
>
    79.561    30.555
    79.380    30.409
>
    79.042    30.413
    79.380    30.409
>
    79.042    30.413
    79.380    30.409
>
    78.757    30.526
    79.380    30.409
>
    78.621    30.305
    79.380    30.409
>
    79.396    30.403
    79.394    30.422
>
    79.396    30.403
    79.394    30.422
>
    79.427    30.437
    79.394    30.422
>
    79.427    30.437
    79.394    30.422
>
    79.321    30.328
    79.394    30.422
>
    79.321    30.328
    79.394    30.422
>
    79.334    30.250
    79.394    30.422
>
    79.334    30.250
    79.394    30.422
>
    79.217    30.262
    79.394    30.422
>
    79.217    30.262
    79.394    30.422
>
    79.223    30.252
    79.394    30.422
>
    79.223    30.252
    79.394    30.422
>
    79.561    30.555
    79.394    30.422
>
    79.561    30.555
    79.394    30.422
>
    79.090    30.510
    79.394    30.422
>
    79.090    30.510
    79.394    30.422
>
    79.108    30.296
    79.394    30.422
>
    79.042    30.413
    79.394    30.422
>
    79.042    30.413
    79.394    30.422
>
    78.621    30.305
    79.394    30.422
>
    78.621    30.305
    79.394    30.422
>
    79.396    30.403
    79.352    30.430
>
    79.396    30.403
    79.352    30.430
>
    79.427    30.437
    79.352    30.430
>
    79.427    30.437
    79.352    30.430
>
    79.321    30.328
    79.352    30.430
>
    79.321    30.328
    79.352    30.430
>
    79.334    30.250
    79.352    30.430
>
    79.334    30.250
    79.352    30.430
>
    79.217    30.262
    79.352    30.430
>
    79.217    30.262
    79.352    30.430
>
    79.223    30.252
    79.352    30.430
>
    79.223    30.252
    79.352    30.430
>
    79.123    30.549
    79.352    30.430
>
    79.123    30.549
    79.352    30.430
>
    79.090    30.510
    79.352    30.430
>
    79.090    30.510
    79.352    30.430
>
    79.042    30.413
    79.352    30.430
>
    79.042    30.413
    79.352    30.430
>
    79.561    30.555
    79.352    30.430
>
    79.561    30.555
    79.352    30.430
>
    79.396    30.403
    79.355    30.427
>
    79.396    30.403
    79.355    30.427
>
    79.263    30.465
    79.355    30.427
>
    79.263    30.465
    79.355    30.427
>
    79.427    30.437
    79.355    30.427
>
    79.427    30.437
    79.355    30.427
>
    79.334    30.250
    79.355    30.427
>
    79.334    30.250
    79.355    30.427
>
    79.217    30.262
    79.355    30.427
>
    79.217    30.262
    79.355    30.427
>
    79.223    30.252
    79.355    30.427
>
    79.223    30.252
    79.355    30.427
>
    79.123    30.549
    79.355    30.427
>
    79.123    30.549
    79.355    30.427
>
    79.090    30.510
    79.355    30.427
>
    79.090    30.510
    79.355    30.427
>
    79.108    30.296
    79.355    30.427
>
    79.042    30.413
    79.355    30.427
>
    79.042    30.413
    79.355    30.427
>
    79.561    30.555
    79.355    30.427
>
    79.561    30.555
    79.355    30.427
>
    79.319    30.418
    79.378    30.428
>
    79.319    30.418
    79.378    30.428
>
    79.396    30.403
    79.378    30.428
>
    79.396    30.403
    79.378    30.428
>
    79.427    30.437
    79.378    30.428
>
    79.427    30.437
    79.378    30.428
>
    79.442    30.463
    79.378    30.428
>
    79.442    30.463
    79.378    30.428
>
    79.263    30.465
    79.378    30.428
>
    79.263    30.465
    79.378    30.428
>
    79.321    30.328
    79.378    30.428
>
    79.321    30.328
    79.378    30.428
>
    79.334    30.250
    79.378    30.428
>
    79.217    30.262
    79.378    30.428
>
    79.217    30.262
    79.378    30.428
>
    79.223    30.252
    79.378    30.428
>
    79.223    30.252
    79.378    30.428
>
    79.561    30.555
    79.378    30.428
>
    79.561    30.555
    79.378    30.428
>
    79.123    30.549
    79.378    30.428
>
    79.123    30.549
    79.378    30.428
>
    79.090    30.510
    79.378    30.428
>
    79.090    30.510
    79.378    30.428
>
    79.108    30.296
    79.378    30.428
>
    79.042    30.413
    79.378    30.428
>
    79.042    30.413
    79.378    30.428
>
    79.396    30.403
    79.452    30.386
>
    79.396    30.403
    79.452    30.386
>
    79.427    30.437
    79.452    30.386
>
    79.427    30.437
    79.452    30.386
>
    79.321    30.328
    79.452    30.386
>
    79.321    30.328
    79.452    30.386
>
    79.442    30.463
    79.452    30.386
>
    79.442    30.463
    79.452    30.386
>
    79.334    30.250
    79.452    30.386
>
    79.319    30.418
    79.452    30.386
>
    79.319    30.418
    79.452    30.386
>
    79.263    30.465
    79.452    30.386
>
    79.263    30.465
    79.452    30.386
>
    79.223    30.252
    79.452    30.386
>
    79.217    30.262
    79.452    30.386
>
    79.223    30.252
    79.452    30.386
>
    79.561    30.555
    79.452    30.386
>
    79.561    30.555
    79.452    30.386
>
    79.108    30.296
    79.452    30.386
>
    79.108    30.296
    79.452    30.386
>
    79.123    30.549
    79.452    30.386
>
    79.123    30.549
    79.452    30.386
>
    79.090    30.510
    79.452    30.386
>
    79.042    30.413
    79.452    30.386
>
    79.042    30.413
    79.452    30.386
>
    79.396    30.403
    79.379    30.419
>
    79.396    30.403
    79.379    30.419
>
    79.427    30.437
    79.379    30.419
>
    79.427    30.437
    79.379    30.419
>
    79.317    30.383
    79.379    30.419
>
    79.317    30.383
    79.379    30.419
>
    79.321    30.328
    79.379    30.419
>
    79.321    30.328
    79.379    30.419
>
    79.320    30.410
    79.379    30.419
>
    79.320    30.410
    79.379    30.419
>
    79.319    30.418
    79.379    30.419
>
    79.319    30.418
    79.379    30.419
>
    79.334    30.250
    79.379    30.419
>
    79.263    30.465
    79.379    30.419
>
    79.263    30.465
    79.379    30.419
>
    79.247    30.247
    79.379    30.419
>
    79.217    30.262
    79.379    30.419
>
    79.561    30.555
    79.379    30.419
>
    79.108    30.296
    79.379    30.419
>
    79.090    30.510
    79.379    30.419
>
    79.042    30.413
    79.379    30.419
>
    79.042    30.413
    79.379    30.419
>
    78.998    30.631
    79.379    30.419
>
    78.998    30.631
    79.379    30.419
>
    79.319    30.418
    79.375    30.430
>
    79.319    30.418
    79.375    30.430
>
    79.320    30.410
    79.375    30.430
>
    79.320    30.410
    79.375    30.430
>
    79.396    30.403
    79.375    30.430
>
    79.396    30.403
    79.375    30.430
>
    79.427    30.437
    79.375    30.430
>
    79.427    30.437
    79.375    30.430
>
    79.263    30.465
    79.375    30.430
>
    79.263    30.465
    79.375    30.430
>
    79.442    30.463
    79.375    30.430
>
    79.442    30.463
    79.375    30.430
>
    79.321    30.328
    79.375    30.430
>
    79.334    30.250
    79.375    30.430
>
    79.217    30.262
    79.375    30.430
>
    79.217    30.262
    79.375    30.430
>
    79.247    30.247
    79.375    30.430
>
    79.247    30.247
    79.375    30.430
>
    79.223    30.252
    79.375    30.430
>
    79.223    30.252
    79.375    30.430
>
    79.561    30.555
    79.375    30.430
>
    79.561    30.555
    79.375    30.430
>
    79.090    30.510
    79.375    30.430
>
    79.090    30.510
    79.375    30.430
>
    79.108    30.296
    79.375    30.430
>
    79.108    30.296
    79.375    30.430
>
    79.042    30.413
    79.375    30.430
>
    79.042    30.413
    79.375    30.430
>
    78.998    30.631
    79.375    30.430
>
    78.998    30.631
    79.375    30.430
>
    79.319    30.418
    79.391    30.420
>
    79.319    30.418
    79.391    30.420
>
    79.320    30.410
    79.391    30.420
>
    79.320    30.410
    79.391    30.420
>
    79.396    30.403
    79.391    30.420
>
    79.396    30.403
    79.391    30.420
>
    79.427    30.437
    79.391    30.420
>
    79.427    30.437
    79.391    30.420
>
    79.442    30.463
    79.391    30.420
>
    79.442    30.463
    79.391    30.420
>
    79.321    30.328
    79.391    30.420
>
    79.321    30.328
    79.391    30.420
>
    79.561    30.555
    79.391    30.420
>
    79.561    30.555
    79.391    30.420
>
    79.217    30.262
    79.391    30.420
>
    79.247    30.247
    79.391    30.420
>
    79.247    30.247
    79.391    30.420
>
    79.223    30.252
    79.391    30.420
>
    79.223    30.252
    79.391    30.420
>
    79.090    30.510
    79.391    30.420
>
    79.090    30.510
    79.391    30.420
>
    79.108    30.296
    79.391    30.420
>
    79.042    30.413
    79.391    30.420
>
    79.042    30.413
    79.391    30.420
>
    78.998    30.631
    79.391    30.420
>
    78.998    30.631
    79.391    30.420
>
    79.319    30.418
    79.377    30.423
>
    79.320    30.410
    79.377    30.423
>
    79.320    30.410
    79.377    30.423
>
    79.319    30.418
    79.377    30.423
>
    79.396    30.403
    79.377    30.423
>
    79.396    30.403
    79.377    30.423
>
    79.427    30.437
    79.377    30.423
>
    79.427    30.437
    79.377    30.423
>
    79.263    30.465
    79.377    30.423
>
    79.442    30.463
    79.377    30.423
>
    79.442    30.463
    79.377    30.423
>
    79.321    30.328
    79.377    30.423
>
    79.321    30.328
    79.377    30.423
>
    79.334    30.250
    79.377    30.423
>
    79.223    30.252
    79.377    30.423
>
    79.223    30.252
    79.377    30.423
>
    79.217    30.262
    79.377    30.423
>
    79.247    30.247
    79.377    30.423
>
    79.247    30.247
    79.377    30.423
>
    79.561    30.555
    79.377    30.423
>
    79.561    30.555
    79.377    30.423
>
    79.090    30.510
    79.377    30.423
>
    79.090    30.510
    79.377    30.423
>
    79.108    30.296
    79.377    30.423
>
    79.108    30.296
    79.377    30.423
>
    79.042    30.413
    79.377    30.423
>
    79.042    30.413
    79.377    30.423
>
    78.998    30.631
    79.377    30.423
>
    79.319    30.418
    79.327    30.440
>
    79.319    30.418
    79.327    30.440
>
    79.320    30.410
    79.327    30.440
>
    79.320    30.410
    79.327    30.440
>
    79.263    30.465
    79.327    30.440
>
    79.263    30.465
    79.327    30.440
>
    79.396    30.403
    79.327    30.440
>
    79.396    30.403
    79.327    30.440
>
    79.321    30.328
    79.327    30.440
>
    79.321    30.328
    79.327    30.440
>
    79.427    30.437
    79.327    30.440
>
    79.427    30.437
    79.327    30.440
>
    79.442    30.463
    79.327    30.440
>
    79.442    30.463
    79.327    30.440
>
    79.223    30.252
    79.327    30.440
>
    79.247    30.247
    79.327    30.440
>
    79.223    30.252
    79.327    30.440
>
    79.334    30.250
    79.327    30.440
>
    79.334    30.250
    79.327    30.440
>
    79.217    30.262
    79.327    30.440
>
    79.217    30.262
    79.327    30.440
>
    79.123    30.549
    79.327    30.440
>
    79.123    30.549
    79.327    30.440
>
    79.090    30.510
    79.327    30.440
>
    79.090    30.510
    79.327    30.440
>
    79.108    30.296
    79.327    30.440
>
    79.108    30.296
    79.327    30.440
>
    79.042    30.413
    79.327    30.440
>
    79.042    30.413
    79.327    30.440
>
    79.561    30.555
    79.327    30.440
>
    79.561    30.555
    79.327    30.440
>
    78.998    30.631
    79.327    30.440
>
    78.998    30.631
    79.327    30.440
>
    79.396    30.403
    79.408    30.404
>
    79.396    30.403
    79.408    30.404
>
    79.320    30.410
    79.408    30.404
>
    79.320    30.410
    79.408    30.404
>
    79.319    30.418
    79.408    30.404
>
    79.319    30.418
    79.408    30.404
>
    79.427    30.437
    79.408    30.404
>
    79.427    30.437
    79.408    30.404
>
    79.321    30.328
    79.408    30.404
>
    79.321    30.328
    79.408    30.404
>
    79.442    30.463
    79.408    30.404
>
    79.442    30.463
    79.408    30.404
>
    79.334    30.250
    79.408    30.404
>
    79.223    30.252
    79.408    30.404
>
    79.223    30.252
    79.408    30.404
>
    79.217    30.262
    79.408    30.404
>
    79.217    30.262
    79.408    30.404
>
    79.247    30.247
    79.408    30.404
>
    79.247    30.247
    79.408    30.404
>
    79.108    30.296
    79.408    30.404
>
    79.090    30.510
    79.408    30.404
>
    79.090    30.510
    79.408    30.404
>
    79.042    30.413
    79.408    30.404
>
    79.042    30.413
    79.408    30.404
>
    78.998    30.631
    79.408    30.404
>
    78.998    30.631
    79.408    30.404
>
    79.319    30.418
    79.387    30.420
>
    79.319    30.418
    79.387    30.420
>
    79.320    30.410
    79.387    30.420
>
    79.320    30.410
    79.387    30.420
>
    79.396    30.403
    79.387    30.420
>
    79.396    30.403
    79.387    30.420
>
    79.427    30.437
    79.387    30.420
>
    79.427    30.437
    79.387    30.420
>
    79.263    30.465
    79.387    30.420
>
    79.263    30.465
    79.387    30.420
>
    79.442    30.463
    79.387    30.420
>
    79.442    30.463
    79.387    30.420
>
    79.321    30.328
    79.387    30.420
>
    79.321    30.328
    79.387    30.420
>
    79.334    30.250
    79.387    30.420
>
    79.334    30.250
    79.387    30.420
>
    79.217    30.262
    79.387    30.420
>
    79.247    30.247
    79.387    30.420
>
    79.223    30.252
    79.387    30.420
>
    79.561    30.555
    79.387    30.420
>
    79.561    30.555
    79.387    30.420
>
    79.090    30.510
    79.387    30.420
>
    79.090    30.510
    79.387    30.420
>
    79.042    30.413
    79.387    30.420
>
    79.042    30.413
    79.387    30.420
>
    78.998    30.631
    79.387    30.420
>
    78.998    30.631
    79.387    30.420
>
    79.320    30.410
    79.361    30.422
>
    79.320    30.410
    79.361    30.422
>
    79.396    30.403
    79.361    30.422
>
    79.396    30.403
    79.361    30.422
>
    79.427    30.437
    79.361    30.422
>
    79.427    30.437
    79.361    30.422
>
    79.263    30.465
    79.361    30.422
>
    79.263    30.465
    79.361    30.422
>
    79.321    30.328
    79.361    30.422
>
    79.321    30.328
    79.361    30.422
>
    79.442    30.463
    79.361    30.422
>
    79.442    30.463
    79.361    30.422
>
    79.334    30.250
    79.361    30.422
>
    79.223    30.252
    79.361    30.422
>
    79.223    30.252
    79.361    30.422
>
    79.561    30.555
    79.361    30.422
>
    79.561    30.555
    79.361    30.422
>
    79.090    30.510
    79.361    30.422
>
    79.108    30.296
    79.361    30.422
>
    79.042    30.413
    79.361    30.422
>
    79.042    30.413
    79.361    30.422
>
    79.396    30.403
    79.444    30.432
>
    79.396    30.403
    79.444    30.432
>
    79.427    30.437
    79.444    30.432
>
    79.427    30.437
    79.444    30.432
>
    79.320    30.410
    79.444    30.432
>
    79.320    30.410
    79.444    30.432
>
    79.321    30.328
    79.444    30.432
>
    79.263    30.465
    79.444    30.432
>
    79.263    30.465
    79.444    30.432
>
    79.334    30.250
    79.444    30.432
>
    79.561    30.555
    79.444    30.432
>
    79.561    30.555
    79.444    30.432
>
    79.247    30.247
    79.444    30.432
>
    79.247    30.247
    79.444    30.432
>
    79.223    30.252
    79.444    30.432
>
    79.223    30.252
    79.444    30.432
>
    79.123    30.549
    79.444    30.432
>
    79.123    30.549
    79.444    30.432
>
    79.090    30.510
    79.444    30.432
>
    79.090    30.510
    79.444    30.432
>
    78.998    30.631
    79.444    30.432
>
    78.998    30.631
    79.444    30.432
>
    79.321    30.407
    79.358    30.409
>
    79.321    30.407
    79.358    30.409
>
    79.317    30.383
    79.358    30.409
>
    79.317    30.383
    79.358    30.409
>
    79.263    30.465
    79.358    30.409
>
    79.263    30.465
    79.358    30.409
>
    79.396    30.403
    79.358    30.409
>
    79.396    30.403
    79.358    30.409
>
    79.427    30.437
    79.358    30.409
>
    79.442    30.463
    79.358    30.409
>
    79.442    30.463
    79.358    30.409
>
    79.334    30.250
    79.358    30.409
>
    79.334    30.250
    79.358    30.409
>
    79.247    30.247
    79.358    30.409
>
    79.223    30.252
    79.358    30.409
>
    79.223    30.252
    79.358    30.409
>
    79.108    30.296
    79.358    30.409
>
    79.090    30.510
    79.358    30.409
>
    79.090    30.510
    79.358    30.409
>
    79.123    30.549
    79.358    30.409
>
    79.123    30.549
    79.358    30.409
>
    79.042    30.413
    79.358    30.409
>
    79.321    30.407
    79.371    30.422
>
    79.321    30.407
    79.371    30.422
>
    79.317    30.383
    79.371    30.422
>
    79.317    30.383
    79.371    30.422
>
    79.396    30.403
    79.371    30.422
>
    79.396    30.403
    79.371    30.422
>
    79.263    30.465
    79.371    30.422
>
    79.263    30.465
    79.371    30.422
>
    79.427    30.437
    79.371    30.422
>
    79.427    30.437
    79.371    30.422
>
    79.334    30.250
    79.371    30.422
>
    79.334    30.250
    79.371    30.422
>
    79.223    30.252
    79.371    30.422
>
    79.223    30.252
    79.371    30.422
>
    79.217    30.262
    79.371    30.422
>
    79.217    30.262
    79.371    30.422
>
    79.090    30.510
    79.371    30.422
>
    79.090    30.510
    79.371    30.422
>
    79.123    30.549
    79.371    30.422
>
    79.123    30.549
    79.371    30.422
>
    79.319    30.418
    79.378    30.433
>
    79.319    30.418
    79.378    30.433
>
    79.321    30.407
    79.378    30.433
>
    79.321    30.407
    79.378    30.433
>
    79.317    30.383
    79.378    30.433
>
    79.317    30.383
    79.378    30.433
>
    79.396    30.403
    79.378    30.433
>
    79.263    30.465
    79.378    30.433
>
    79.263    30.465
    79.378    30.433
>
    79.427    30.437
    79.378    30.433
>
    79.427    30.437
    79.378    30.433
>
    79.442    30.463
    79.378    30.433
>
    79.442    30.463
    79.378    30.433
>
    79.217    30.262
    79.378    30.433
>
    79.217    30.262
    79.378    30.433
>
    79.247    30.247
    79.378    30.433
>
    79.223    30.252
    79.378    30.433
>
    79.223    30.252
    79.378    30.433
>
    79.123    30.549
    79.378    30.433
>
    79.123    30.549
    79.378    30.433
>
    79.090    30.510
    79.378    30.433
>
    79.090    30.510
    79.378    30.433
>
    79.042    30.413
    79.378    30.433
>
    79.319    30.418
    79.381    30.424
>
    79.319    30.418
    79.381    30.424
>
    79.320    30.410
    79.381    30.424
>
    79.320    30.410
    79.381    30.424
>
    79.396    30.403
    79.381    30.424
>
    79.396    30.403
    79.381    30.424
>
    79.427    30.437
    79.381    30.424
>
    79.427    30.437
    79.381    30.424
>
    79.442    30.463
    79.381    30.424
>
    79.442    30.463
    79.381    30.424
>
    79.321    30.328
    79.381    30.424
>
    79.321    30.328
    79.381    30.424
>
    79.223    30.252
    79.381    30.424
>
    79.223    30.252
    79.381    30.424
>
    79.561    30.555
    79.381    30.424
>
    79.561    30.555
    79.381    30.424
>
    79.123    30.549
    79.381    30.424
>
    79.123    30.549
    79.381    30.424
>
    79.090    30.510
    79.381    30.424
>
    79.090    30.510
    79.381    30.424
>
    79.042    30.413
    79.381    30.424
>
    79.042    30.413
    79.381    30.424
>
    78.998    30.631
    79.381    30.424
>
    79.263    30.465
    79.311    30.539
>
    79.263    30.465
    79.311    30.539
>
    79.319    30.418
    79.311    30.539
>
    79.319    30.418
    79.311    30.539
>
    79.320    30.410
    79.311    30.539
>
    79.320    30.410
    79.311    30.539
>
    79.317    30.383
    79.311    30.539
>
    79.317    30.383
    79.311    30.539
>
    79.123    30.549
    79.311    30.539
>
    79.123    30.549
    79.311    30.539
>
    79.442    30.463
    79.311    30.539
>
    79.442    30.463
    79.311    30.539
>
    79.427    30.437
    79.311    30.539
>
    79.427    30.437
    79.311    30.539
>
    79.396    30.403
    79.311    30.539
>
    79.396    30.403
    79.311    30.539
>
    79.090    30.510
    79.311    30.539
>
    79.090    30.510
    79.311    30.539
>
    79.321    30.328
    79.311    30.539
>
    79.321    30.328
    79.311    30.539
>
    79.042    30.413
    79.311    30.539
>
    79.042    30.413
    79.311    30.539
>
    79.561    30.555
    79.311    30.539
>
    79.561    30.555
    79.311    30.539
>
    79.108    30.296
    79.311    30.539
>
    79.223    30.252
    79.311    30.539
>
    79.223    30.252
    79.311    30.539
>
    79.108    30.296
    79.311    30.539
>
    79.217    30.262
    79.311    30.539
>
    79.217    30.262
    79.311    30.539
>
    78.998    30.631
    79.311    30.539
>
    78.998    30.631
    79.311    30.539
>
    79.320    30.410
    79.351    30.452
>
    79.320    30.410
    79.351    30.452
>
    79.317    30.383
    79.351    30.452
>
    79.317    30.383
    79.351    30.452
>
    79.396    30.403
    79.351    30.452
>
    79.396    30.403
    79.351    30.452
>
    79.427    30.437
    79.351    30.452
>
    79.427    30.437
    79.351    30.452
>
    79.442    30.463
    79.351    30.452
>
    79.442    30.463
    79.351    30.452
>
    79.321    30.328
    79.351    30.452
>
    79.321    30.328
    79.351    30.452
>
    79.123    30.549
    79.351    30.452
>
    79.123    30.549
    79.351    30.452
>
    79.217    30.262
    79.351    30.452
>
    79.217    30.262
    79.351    30.452
>
    79.247    30.247
    79.351    30.452
>
    79.223    30.252
    79.351    30.452
>
    79.223    30.252
    79.351    30.452
>
    79.561    30.555
    79.351    30.452
>
    79.561    30.555
    79.351    30.452
>
    79.042    30.413
    79.351    30.452
>
    79.042    30.413
    79.351    30.452
>
    78.998    30.631
    79.351    30.452
>
    78.998    30.631
    79.351    30.452
>
    79.396    30.403
    79.381    30.419
>
    79.396    30.403
    79.381    30.419
>
    79.321    30.328
    79.381    30.419
>
    79.321    30.328
    79.381    30.419
>
    79.317    30.383
    79.381    30.419
>
    79.317    30.383
    79.381    30.419
>
    79.427    30.437
    79.381    30.419
>
    79.427    30.437
    79.381    30.419
>
    79.320    30.410
    79.381    30.419
>
    79.320    30.410
    79.381    30.419
>
    79.319    30.418
    79.381    30.419
>
    79.442    30.463
    79.381    30.419
>
    79.442    30.463
    79.381    30.419
>
    79.247    30.247
    79.381    30.419
>
    79.223    30.252
    79.381    30.419
>
    79.223    30.252
    79.381    30.419
>
    79.561    30.555
    79.381    30.419
>
    79.561    30.555
    79.381    30.419
>
    79.090    30.510
    79.381    30.419
>
    79.090    30.510
    79.381    30.419
>
    79.042    30.413
    79.381    30.419
>
    79.042    30.413
    79.381    30.419
>
    78.998    30.631
    79.381    30.419
>
    79.319    30.418
    79.373    30.424
>
    79.320    30.410
    79.373    30.424
>
    79.320    30.410
    79.373    30.424
>
    79.427    30.437
    79.373    30.424
>
    79.427    30.437
    79.373    30.424
>
    79.442    30.463
    79.373    30.424
>
    79.442    30.463
    79.373    30.424
>
    79.321    30.328
    79.373    30.424
>
    79.321    30.328
    79.373    30.424
>
    79.217    30.262
    79.373    30.424
>
    79.217    30.262
    79.373    30.424
>
    79.223    30.252
    79.373    30.424
>
    79.223    30.252
    79.373    30.424
>
    79.561    30.555
    79.373    30.424
>
    79.561    30.555
    79.373    30.424
>
    79.123    30.549
    79.373    30.424
>
    79.123    30.549
    79.373    30.424
>
    79.090    30.510
    79.373    30.424
>
    79.090    30.510
    79.373    30.424
>
    79.042    30.413
    79.373    30.424
>
    79.042    30.413
    79.373    30.424
>
    78.998    30.631
    79.373    30.424
>
    78.998    30.631
    79.373    30.424
>
    79.396    30.403
    79.387    30.415
>
    79.396    30.403
    79.387    30.415
>
    79.319    30.418
    79.387    30.415
>
    79.319    30.418
    79.387    30.415
>
    79.321    30.407
    79.387    30.415
>
    79.321    30.407
    79.387    30.415
>
    79.442    30.463
    79.387    30.415
>
    79.442    30.463
    79.387    30.415
>
    79.321    30.328
    79.387    30.415
>
    79.321    30.328
    79.387    30.415
>
    79.217    30.262
    79.387    30.415
>
    79.223    30.252
    79.387    30.415
>
    79.223    30.252
    79.387    30.415
>
    79.217    30.262
    79.387    30.415
>
    79.561    30.555
    79.387    30.415
>
    79.561    30.555
    79.387    30.415
>
    79.123    30.549
    79.387    30.415
>
    79.123    30.549
    79.387    30.415
>
    79.090    30.510
    79.387    30.415
>
    79.090    30.510
    79.387    30.415
>
    79.042    30.413
    79.387    30.415
>
    79.319    30.418
    79.348    30.434
>
    79.319    30.418
    79.348    30.434
>
    79.321    30.407
    79.348    30.434
>
    79.321    30.407
    79.348    30.434
>
    79.396    30.403
    79.348    30.434
>
    79.427    30.437
    79.348    30.434
>
    79.427    30.437
    79.348    30.434
>
    79.442    30.463
    79.348    30.434
>
    79.442    30.463
    79.348    30.434
>
    79.321    30.328
    79.348    30.434
>
    79.321    30.328
    79.348    30.434
>
    79.123    30.549
    79.348    30.434
>
    79.123    30.549
    79.348    30.434
>
    79.090    30.510
    79.348    30.434
>
    79.247    30.247
    79.348    30.434
>
    79.217    30.262
    79.348    30.434
>
    79.217    30.262
    79.348    30.434
>
    79.223    30.252
    79.348    30.434
>
    79.223    30.252
    79.348    30.434
>
    79.247    30.247
    79.348    30.434
>
    78.973    30.291
    79.348    30.434
>
    78.973    30.291
    79.348    30.434
>
    79.396    30.403
    79.406    30.401
>
    79.396    30.403
    79.406    30.401
>
    79.427    30.437
    79.406    30.401
>
    79.427    30.437
    79.406    30.401
>
    79.319    30.418
    79.406    30.401
>
    79.319    30.418
    79.406    30.401
>
    79.321    30.407
    79.406    30.401
>
    79.321    30.407
    79.406    30.401
>
    79.321    30.328
    79.406    30.401
>
    79.321    30.328
    79.406    30.401
>
    79.442    30.463
    79.406    30.401
>
    79.442    30.463
    79.406    30.401
>
    79.247    30.247
    79.406    30.401
>
    79.247    30.247
    79.406    30.401
>
    79.217    30.262
    79.406    30.401
>
    79.217    30.262
    79.406    30.401
>
    79.223    30.252
    79.406    30.401
>
    79.223    30.252
    79.406    30.401
>
    79.561    30.555
    79.406    30.401
>
    79.123    30.549
    79.406    30.401
>
    79.123    30.549
    79.406    30.401
>
    79.090    30.510
    79.406    30.401
>
    79.090    30.510
    79.406    30.401
>
    79.042    30.413
    79.406    30.401
>
    79.042    30.413
    79.406    30.401
>
    78.973    30.291
    79.406    30.401
>
    79.319    30.418
    79.329    30.415
>
    79.319    30.418
    79.329    30.415
>
    79.321    30.407
    79.329    30.415
>
    79.321    30.407
    79.329    30.415
>
    79.396    30.403
    79.329    30.415
>
    79.396    30.403
    79.329    30.415
>
    79.321    30.328
    79.329    30.415
>
    79.321    30.328
    79.329    30.415
>
    79.427    30.437
    79.329    30.415
>
    79.427    30.437
    79.329    30.415
>
    79.442    30.463
    79.329    30.415
>
    79.442    30.463
    79.329    30.415
>
    79.217    30.262
    79.329    30.415
>
    79.217    30.262
    79.329    30.415
>
    79.247    30.247
    79.329    30.415
>
    79.223    30.252
    79.329    30.415
>
    79.223    30.252
    79.329    30.415
>
    79.247    30.247
    79.329    30.415
>
    79.123    30.549
    79.329    30.415
>
    79.123    30.549
    79.329    30.415
>
    79.090    30.510
    79.329    30.415
>
    79.090    30.510
    79.329    30.415
>
    79.042    30.413
    79.329    30.415
>
    79.042    30.413
    79.329    30.415
>
    79.561    30.555
    79.329    30.415
>
    79.561    30.555
    79.329    30.415
>
    78.973    30.291
    79.329    30.415
>
    78.973    30.291
    79.329    30.415
>
    79.321    30.407
    79.362    30.411
>
    79.321    30.407
    79.362    30.411
>
    79.319    30.418
    79.362    30.411
>
    79.319    30.418
    79.362    30.411
>
    79.396    30.403
    79.362    30.411
>
    79.396    30.403
    79.362    30.411
>
    79.427    30.437
    79.362    30.411
>
    79.427    30.437
    79.362    30.411
>
    79.321    30.328
    79.362    30.411
>
    79.321    30.328
    79.362    30.411
>
    79.442    30.463
    79.362    30.411
>
    79.442    30.463
    79.362    30.411
>
    79.247    30.247
    79.362    30.411
>
    79.247    30.247
    79.362    30.411
>
    79.217    30.262
    79.362    30.411
>
    79.217    30.262
    79.362    30.411
>
    79.223    30.252
    79.362    30.411
>
    79.223    30.252
    79.362    30.411
>
    79.561    30.555
    79.362    30.411
>
    79.561    30.555
    79.362    30.411
>
    79.123    30.549
    79.362    30.411
>
    79.123    30.549
    79.362    30.411
>
    79.090    30.510
    79.362    30.411
>
    79.090    30.510
    79.362    30.411
>
    79.042    30.413
    79.362    30.411
>
    79.042    30.413
    79.362    30.411
>
    78.973    30.291
    79.362    30.411
>
    78.973    30.291
    79.362    30.411
>
    79.396    30.403
    79.387    30.431
>
    79.396    30.403
    79.387    30.431
>
    79.321    30.407
    79.387    30.431
>
    79.321    30.407
    79.387    30.431
>
    79.427    30.437
    79.387    30.431
>
    79.427    30.437
    79.387    30.431
>
    79.317    30.383
    79.387    30.431
>
    79.317    30.383
    79.387    30.431
>
    79.442    30.463
    79.387    30.431
>
    79.442    30.463
    79.387    30.431
>
    79.263    30.465
    79.387    30.431
>
    79.263    30.465
    79.387    30.431
>
    79.321    30.328
    79.387    30.431
>
    79.321    30.328
    79.387    30.431
>
    79.334    30.250
    79.387    30.431
>
    79.334    30.250
    79.387    30.431
>
    79.561    30.555
    79.387    30.431
>
    79.561    30.555
    79.387    30.431
>
    79.247    30.247
    79.387    30.431
>
    79.247    30.247
    79.387    30.431
>
    79.223    30.252
    79.387    30.431
>
    79.223    30.252
    79.387    30.431
>
    79.123    30.549
    79.387    30.431
>
    79.123    30.549
    79.387    30.431
>
    79.090    30.510
    79.387    30.431
>
    79.090    30.510
    79.387    30.431
>
    79.042    30.413
    79.387    30.431
>
    79.042    30.413
    79.387    30.431
>
    79.319    30.418
    79.377    30.422
>
    79.319    30.418
    79.377    30.422
>
    79.321    30.407
    79.377    30.422
>
    79.321    30.407
    79.377    30.422
>
    79.317    30.383
    79.377    30.422
>
    79.317    30.383
    79.377    30.422
>
    79.396    30.403
    79.377    30.422
>
    79.427    30.437
    79.377    30.422
>
    79.427    30.437
    79.377    30.422
>
    79.263    30.465
    79.377    30.422
>
    79.263    30.465
    79.377    30.422
>
    79.321    30.328
    79.377    30.422
>
    79.321    30.328
    79.377    30.422
>
    79.442    30.463
    79.377    30.422
>
    79.442    30.463
    79.377    30.422
>
    79.334    30.250
    79.377    30.422
>
    79.334    30.250
    79.377    30.422
>
    79.217    30.262
    79.377    30.422
>
    79.217    30.262
    79.377    30.422
>
    79.247    30.247
    79.377    30.422
>
    79.247    30.247
    79.377    30.422
>
    79.223    30.252
    79.377    30.422
>
    79.223    30.252
    79.377    30.422
>
    79.561    30.555
    79.377    30.422
>
    79.123    30.549
    79.377    30.422
>
    79.123    30.549
    79.377    30.422
>
    79.561    30.555
    79.377    30.422
>
    79.090    30.510
    79.377    30.422
>
    79.090    30.510
    79.377    30.422
>
    79.108    30.296
    79.377    30.422
>
    79.108    30.296
    79.377    30.422
>
    79.042    30.413
    79.377    30.422
>
    79.427    30.437
    79.476    30.461
>
    79.442    30.463
    79.476    30.461
>
    79.442    30.463
    79.476    30.461
>
    79.396    30.403
    79.476    30.461
>
    79.319    30.418
    79.476    30.461
>
    79.319    30.418
    79.476    30.461
>
    79.321    30.407
    79.476    30.461
>
    79.321    30.407
    79.476    30.461
>
    79.317    30.383
    79.476    30.461
>
    79.317    30.383
    79.476    30.461
>
    79.263    30.465
    79.476    30.461
>
    79.263    30.465
    79.476    30.461
>
    79.561    30.555
    79.476    30.461
>
    79.321    30.328
    79.476    30.461
>
    79.321    30.328
    79.476    30.461
>
    79.561    30.555
    79.476    30.461
>
    79.334    30.250
    79.476    30.461
>
    79.334    30.250
    79.476    30.461
>
    79.247    30.247
    79.476    30.461
>
    79.247    30.247
    79.476    30.461
>
    79.223    30.252
    79.476    30.461
>
    79.223    30.252
    79.476    30.461
>
    79.123    30.549
    79.476    30.461
>
    79.123    30.549
    79.476    30.461
>
    79.090    30.510
    79.476    30.461
>
    79.090    30.510
    79.476    30.461
>
    79.042    30.413
    79.476    30.461
>
    79.042    30.413
    79.476    30.461
>
    79.427    30.437
    79.408    30.418
>
    79.396    30.403
    79.408    30.418
>
    79.320    30.410
    79.408    30.418
>
    79.321    30.407
    79.408    30.418
>
    79.321    30.407
    79.408    30.418
>
    79.320    30.410
    79.408    30.418
>
    79.442    30.463
    79.408    30.418
>
    79.442    30.463
    79.408    30.418
>
    79.317    30.383
    79.408    30.418
>
    79.317    30.383
    79.408    30.418
>
    79.263    30.465
    79.408    30.418
>
    79.263    30.465
    79.408    30.418
>
    79.321    30.328
    79.408    30.418
>
    79.321    30.328
    79.408    30.418
>
    79.321    30.328
    79.408    30.418
>
    79.334    30.250
    79.408    30.418
>
    79.561    30.555
    79.408    30.418
>
    79.561    30.555
    79.408    30.418
>
    79.247    30.247
    79.408    30.418
>
    79.123    30.549
    79.408    30.418
>
    79.123    30.549
    79.408    30.418
>
    79.123    30.549
    79.408    30.418
>
    79.090    30.510
    79.408    30.418
>
    79.090    30.510
    79.408    30.418
>
    79.042    30.413
    79.408    30.418
>
    78.998    30.631
    79.408    30.418
>
    78.998    30.631
    79.408    30.418
>
    79.442    30.463
    79.497    30.455
>
    79.442    30.463
    79.497    30.455
>
    79.427    30.437
    79.497    30.455
>
    79.396    30.403
    79.497    30.455
>
    79.319    30.418
    79.497    30.455
>
    79.319    30.418
    79.497    30.455
>
    79.320    30.410
    79.497    30.455
>
    79.320    30.410
    79.497    30.455
>
    79.561    30.555
    79.497    30.455
>
    79.561    30.555
    79.497    30.455
>
    79.317    30.383
    79.497    30.455
>
    79.317    30.383
    79.497    30.455
>
    79.263    30.465
    79.497    30.455
>
    79.263    30.465
    79.497    30.455
>
    79.321    30.328
    79.497    30.455
>
    79.321    30.328
    79.497    30.455
>
    79.334    30.250
    79.497    30.455
>
    79.247    30.247
    79.497    30.455
>
    79.223    30.252
    79.497    30.455
>
    79.223    30.252
    79.497    30.455
>
    79.123    30.549
    79.497    30.455
>
    79.123    30.549
    79.497    30.455
>
    79.090    30.510
    79.497    30.455
>
    79.090    30.510
    79.497    30.455
>
    79.042    30.413
    79.497    30.455
>
    78.998    30.631
    79.497    30.455
>
    78.998    30.631
    79.497    30.455
>
    79.427    30.437
    79.484    30.463
>
    79.427    30.437
    79.484    30.463
>
    79.442    30.463
    79.484    30.463
>
    79.442    30.463
    79.484    30.463
>
    79.396    30.403
    79.484    30.463
>
    79.319    30.418
    79.484    30.463
>
    79.319    30.418
    79.484    30.463
>
    79.321    30.407
    79.484    30.463
>
    79.321    30.407
    79.484    30.463
>
    79.317    30.383
    79.484    30.463
>
    79.317    30.383
    79.484    30.463
>
    79.263    30.465
    79.484    30.463
>
    79.263    30.465
    79.484    30.463
>
    79.321    30.328
    79.484    30.463
>
    79.321    30.328
    79.484    30.463
>
    79.561    30.555
    79.484    30.463
>
    79.561    30.555
    79.484    30.463
>
    79.334    30.250
    79.484    30.463
>
    79.334    30.250
    79.484    30.463
>
    79.247    30.247
    79.484    30.463
>
    79.247    30.247
    79.484    30.463
>
    79.223    30.252
    79.484    30.463
>
    79.223    30.252
    79.484    30.463
>
    79.123    30.549
    79.484    30.463
>
    79.123    30.549
    79.484    30.463
>
    79.090    30.510
    79.484    30.463
>
    79.090    30.510
    79.484    30.463
>
    79.108    30.296
    79.484    30.463
>
    79.108    30.296
    79.484    30.463
>
    79.042    30.413
    79.484    30.463
>
    79.442    30.463
    79.382    30.520
>
    79.263    30.465
    79.382    30.520
>
    79.263    30.465
    79.382    30.520
>
    79.319    30.418
    79.382    30.520
>
    79.319    30.418
    79.382    30.520
>
    79.427    30.437
    79.382    30.520
>
    79.427    30.437
    79.382    30.520
>
    79.321    30.407
    79.382    30.520
>
    79.321    30.407
    79.382    30.520
>
    79.396    30.403
    79.382    30.520
>
    79.123    30.549
    79.382    30.520
>
    79.123    30.549
    79.382    30.520
>
    79.321    30.328
    79.382    30.520
>
    79.321    30.328
    79.382    30.520
>
    79.090    30.510
    79.382    30.520
>
    79.090    30.510
    79.382    30.520
>
    79.042    30.413
    79.382    30.520
>
    79.042    30.413
    79.382    30.520
>
    79.223    30.252
    79.382    30.520
>
    79.223    30.252
    79.382    30.520
>
    79.319    30.418
    79.375    30.422
>
    79.321    30.407
    79.375    30.422
>
    79.319    30.418
    79.375    30.422
>
    79.321    30.407
    79.375    30.422
>
    79.396    30.403
    79.375    30.422
>
    79.396    30.403
    79.375    30.422
>
    79.427    30.437
    79.375    30.422
>
    79.427    30.437
    79.375    30.422
>
    79.263    30.465
    79.375    30.422
>
    79.263    30.465
    79.375    30.422
>
    79.321    30.328
    79.375    30.422
>
    79.321    30.328
    79.375    30.422
>
    79.442    30.463
    79.375    30.422
>
    79.442    30.463
    79.375    30.422
>
    79.334    30.250
    79.375    30.422
>
    79.334    30.250
    79.375    30.422
>
    79.217    30.262
    79.375    30.422
>
    79.217    30.262
    79.375    30.422
>
    79.247    30.247
    79.375    30.422
>
    79.247    30.247
    79.375    30.422
>
    79.223    30.252
    79.375    30.422
>
    79.223    30.252
    79.375    30.422
>
    79.561    30.555
    79.375    30.422
>
    79.561    30.555
    79.375    30.422
>
    79.123    30.549
    79.375    30.422
>
    79.123    30.549
    79.375    30.422
>
    79.042    30.413
    79.375    30.422
>
    79.321    30.407
    79.373    30.424
>
    79.321    30.407
    79.373    30.424
>
    79.396    30.403
    79.373    30.424
>
    79.396    30.403
    79.373    30.424
>
    79.427    30.437
    79.373    30.424
>
    79.427    30.437
    79.373    30.424
>
    79.263    30.465
    79.373    30.424
>
    79.263    30.465
    79.373    30.424
>
    79.442    30.463
    79.373    30.424
>
    79.442    30.463
    79.373    30.424
>
    79.321    30.328
    79.373    30.424
>
    79.321    30.328
    79.373    30.424
>
    79.334    30.250
    79.373    30.424
>
    79.334    30.250
    79.373    30.424
>
    79.217    30.262
    79.373    30.424
>
    79.217    30.262
    79.373    30.424
>
    79.223    30.252
    79.373    30.424
>
    79.223    30.252
    79.373    30.424
>
    79.247    30.247
    79.373    30.424
>
    79.247    30.247
    79.373    30.424
>
    79.123    30.549
    79.373    30.424
>
    79.123    30.549
    79.373    30.424
>
    79.090    30.510
    79.373    30.424
>
    79.090    30.510
    79.373    30.424
>
    79.561    30.555
    79.373    30.424
>
    79.561    30.555
    79.373    30.424
>
    79.108    30.296
    79.373    30.424
>
    79.396    30.403
    79.403    30.387
>
    79.396    30.403
    79.403    30.387
>
    79.321    30.407
    79.403    30.387
>
    79.321    30.407
    79.403    30.387
>
    79.319    30.418
    79.403    30.387
>
    79.319    30.418
    79.403    30.387
>
    79.321    30.328
    79.403    30.387
>
    79.321    30.328
    79.403    30.387
>
    79.427    30.437
    79.403    30.387
>
    79.427    30.437
    79.403    30.387
>
    79.442    30.463
    79.403    30.387
>
    79.442    30.463
    79.403    30.387
>
    79.263    30.465
    79.403    30.387
>
    79.263    30.465
    79.403    30.387
>
    79.334    30.250
    79.403    30.387
>
    79.334    30.250
    79.403    30.387
>
    79.217    30.262
    79.403    30.387
>
    79.217    30.262
    79.403    30.387
>
    79.223    30.252
    79.403    30.387
>
    79.223    30.252
    79.403    30.387
>
    79.561    30.555
    79.403    30.387
>
    79.561    30.555
    79.403    30.387
>
    79.123    30.549
    79.403    30.387
>
    79.090    30.510
    79.403    30.387
>
    79.123    30.549
    79.403    30.387
>
    79.263    30.465
    79.277    30.473
>
    79.319    30.418
    79.277    30.473
>
    79.319    30.418
    79.277    30.473
>
    79.396    30.403
    79.277    30.473
>
    79.396    30.403
    79.277    30.473
>
    79.321    30.328
    79.277    30.473
>
    79.321    30.328
    79.277    30.473
>
    79.427    30.437
    79.277    30.473
>
    79.427    30.437
    79.277    30.473
>
    79.123    30.549
    79.277    30.473
>
    79.123    30.549
    79.277    30.473
>
    79.090    30.510
    79.277    30.473
>
    79.090    30.510
    79.277    30.473
>
    79.442    30.463
    79.277    30.473
>
    79.442    30.463
    79.277    30.473
>
    79.042    30.413
    79.277    30.473
>
    79.042    30.413
    79.277    30.473
>
    79.223    30.252
    79.277    30.473
>
    79.223    30.252
    79.277    30.473
>
    79.108    30.296
    79.277    30.473
>
    79.108    30.296
    79.277    30.473
>
    79.334    30.250
    79.277    30.473
>
    79.396    30.403
    79.421    30.397
>
    79.396    30.403
    79.421    30.397
>
    79.427    30.437
    79.421    30.397
>
    79.427    30.437
    79.421    30.397
>
    79.317    30.383
    79.421    30.397
>
    79.317    30.383
    79.421    30.397
>
    79.319    30.418
    79.421    30.397
>
    79.319    30.418
    79.421    30.397
>
    79.321    30.328
    79.421    30.397
>
    79.321    30.328
    79.421    30.397
>
    79.263    30.465
    79.421    30.397
>
    79.263    30.465
    79.421    30.397
>
    79.334    30.250
    79.421    30.397
>
    79.247    30.247
    79.421    30.397
>
    79.247    30.247
    79.421    30.397
>
    79.223    30.252
    79.421    30.397
>
    79.223    30.252
    79.421    30.397
>
    79.217    30.262
    79.421    30.397
>
    79.217    30.262
    79.421    30.397
>
    79.561    30.555
    79.421    30.397
>
    79.561    30.555
    79.421    30.397
>
    79.108    30.296
    79.421    30.397
>
    79.108    30.296
    79.421    30.397
>
    79.123    30.549
    79.421    30.397
>
    79.123    30.549
    79.421    30.397
>
    79.090    30.510
    79.421    30.397
>
    79.090    30.510
    79.421    30.397
>
    79.042    30.413
    79.421    30.397
>
    79.042    30.413
    79.421    30.397
>
    78.973    30.291
    79.421    30.397
>
    79.319    30.418
    79.352    30.432
>
    79.317    30.383
    79.352    30.432
>
    79.317    30.383
    79.352    30.432
>
    79.396    30.403
    79.352    30.432
>
    79.396    30.403
    79.352    30.432
>
    79.427    30.437
    79.352    30.432
>
    79.427    30.437
    79.352    30.432
>
    79.263    30.465
    79.352    30.432
>
    79.263    30.465
    79.352    30.432
>
    79.321    30.328
    79.352    30.432
>
    79.321    30.328
    79.352    30.432
>
    79.334    30.250
    79.352    30.432
>
    79.334    30.250
    79.352    30.432
>
    79.247    30.247
    79.352    30.432
>
    79.247    30.247
    79.352    30.432
>
    79.223    30.252
    79.352    30.432
>
    79.223    30.252
    79.352    30.432
>
    79.561    30.555
    79.352    30.432
>
    79.561    30.555
    79.352    30.432
>
    79.123    30.549
    79.352    30.432
>
    79.108    30.296
    79.352    30.432
>
    79.123    30.549
    79.352    30.432
>
    79.108    30.296
    79.352    30.432
>
    79.090    30.510
    79.352    30.432
>
    79.090    30.510
    79.352    30.432
>
    79.042    30.413
    79.352    30.432
>
    79.042    30.413
    79.352    30.432
>
    78.973    30.291
    79.352    30.432
>
    78.973    30.291
    79.352    30.432
>
    79.427    30.437
    79.486    30.465
>
    79.427    30.437
    79.486    30.465
>
    79.396    30.403
    79.486    30.465
>
    79.396    30.403
    79.486    30.465
>
    79.317    30.383
    79.486    30.465
>
    79.317    30.383
    79.486    30.465
>
    79.561    30.555
    79.486    30.465
>
    79.561    30.555
    79.486    30.465
>
    79.263    30.465
    79.486    30.465
>
    79.263    30.465
    79.486    30.465
>
    79.321    30.328
    79.486    30.465
>
    79.321    30.328
    79.486    30.465
>
    79.334    30.250
    79.486    30.465
>
    79.334    30.250
    79.486    30.465
>
    79.247    30.247
    79.486    30.465
>
    79.223    30.252
    79.486    30.465
>
    79.223    30.252
    79.486    30.465
>
    79.123    30.549
    79.486    30.465
>
    79.123    30.549
    79.486    30.465
>
    79.090    30.510
    79.486    30.465
>
    79.090    30.510
    79.486    30.465
>
    79.042    30.413
    79.486    30.465
>
    79.042    30.413
    79.486    30.465
>
    79.263    30.465
    79.307    30.438
>
    79.263    30.465
    79.307    30.438
>
    79.319    30.418
    79.307    30.438
>
    79.319    30.418
    79.307    30.438
>
    79.317    30.383
    79.307    30.438
>
    79.317    30.383
    79.307    30.438
>
    79.396    30.403
    79.307    30.438
>
    79.321    30.328
    79.307    30.438
>
    79.321    30.328
    79.307    30.438
>
    79.427    30.437
    79.307    30.438
>
    79.427    30.437
    79.307    30.438
>
    79.442    30.463
    79.307    30.438
>
    79.442    30.463
    79.307    30.438
>
    79.123    30.549
    79.307    30.438
>
    79.123    30.549
    79.307    30.438
>
    79.090    30.510
    79.307    30.438
>
    79.090    30.510
    79.307    30.438
>
    79.223    30.252
    79.307    30.438
>
    79.223    30.252
    79.307    30.438
>
    79.247    30.247
    79.307    30.438
>
    79.247    30.247
    79.307    30.438
>
    79.042    30.413
    79.307    30.438
>
    79.456    30.251
    79.307    30.438
>
    79.456    30.251
    79.307    30.438
>
    79.561    30.555
    79.307    30.438
>
    79.561    30.555
    79.307    30.438
>
    79.427    30.437
    79.392    30.418
>
    79.427    30.437
    79.392    30.418
>
    79.442    30.463
    79.392    30.418
>
    79.442    30.463
    79.392    30.418
>
    79.319    30.418
    79.392    30.418
>
    79.321    30.328
    79.392    30.418
>
    79.321    30.328
    79.392    30.418
>
    79.456    30.251
    79.392    30.418
>
    79.456    30.251
    79.392    30.418
>
    79.247    30.247
    79.392    30.418
>
    79.247    30.247
    79.392    30.418
>
    79.223    30.252
    79.392    30.418
>
    79.223    30.252
    79.392    30.418
>
    79.561    30.555
    79.392    30.418
>
    79.561    30.555
    79.392    30.418
>
    79.090    30.510
    79.392    30.418
>
    79.090    30.510
    79.392    30.418
>
    78.973    30.291
    79.392    30.418
>
    78.973    30.291
    79.392    30.418
>
    79.319    30.418
    79.372    30.422
>
    79.319    30.418
    79.372    30.422
>
    79.427    30.437
    79.372    30.422
>
    79.427    30.437
    79.372    30.422
>
    79.442    30.463
    79.372    30.422
>
    79.442    30.463
    79.372    30.422
>
    79.456    30.251
    79.372    30.422
>
    79.456    30.251
    79.372    30.422
>
    79.223    30.252
    79.372    30.422
>
    79.223    30.252
    79.372    30.422
>
    79.247    30.247
    79.372    30.422
>
    79.217    30.262
    79.372    30.422
>
    79.217    30.262
    79.372    30.422
>
    79.247    30.247
    79.372    30.422
>
    79.561    30.555
    79.372    30.422
>
    79.561    30.555
    79.372    30.422
>
    79.090    30.510
    79.372    30.422
>
    79.090    30.510
    79.372    30.422
>
    79.123    30.549
    79.372    30.422
>
    79.123    30.549
    79.372    30.422
>
    79.042    30.413
    79.372    30.422
>
    79.042    30.413
    79.372    30.422
>
    78.973    30.291
    79.372    30.422
>
    78.973    30.291
    79.372    30.422
>
    78.998    30.631
    79.372    30.422
>
    78.998    30.631
    79.372    30.422
>
    79.396    30.403
    79.398    30.410
>
    79.396    30.403
    79.398    30.410
>
    79.427    30.437
    79.398    30.410
>
    79.427    30.437
    79.398    30.410
>
    79.442    30.463
    79.398    30.410
>
    79.442    30.463
    79.398    30.410
>
    79.319    30.418
    79.398    30.410
>
    79.319    30.418
    79.398    30.410
>
    79.317    30.383
    79.398    30.410
>
    79.317    30.383
    79.398    30.410
>
    79.321    30.328
    79.398    30.410
>
    79.456    30.251
    79.398    30.410
>
    79.456    30.251
    79.398    30.410
>
    79.247    30.247
    79.398    30.410
>
    79.247    30.247
    79.398    30.410
>
    79.561    30.555
    79.398    30.410
>
    79.561    30.555
    79.398    30.410
>
    79.217    30.262
    79.398    30.410
>
    79.217    30.262
    79.398    30.410
>
    79.223    30.252
    79.398    30.410
>
    79.223    30.252
    79.398    30.410
>
    79.123    30.549
    79.398    30.410
>
    79.123    30.549
    79.398    30.410
>
    79.090    30.510
    79.398    30.410
>
    79.090    30.510
    79.398    30.410
>
    79.042    30.413
    79.398    30.410
>
    79.042    30.413
    79.398    30.410
>
    78.998    30.631
    79.398    30.410
>
    78.998    30.631
    79.398    30.410
>
    79.321    30.328
    79.399    30.380
>
    79.396    30.403
    79.399    30.380
>
    79.427    30.437
    79.399    30.380
>
    79.319    30.418
    79.399    30.380
>
    79.442    30.463
    79.399    30.380
>
    79.223    30.252
    79.399    30.380
>
    79.217    30.262
    79.399    30.380
>
    79.561    30.555
    79.399    30.380
>
    79.561    30.555
    79.399    30.380
>
    79.042    30.413
    79.399    30.380
>
    79.123    30.549
    79.399    30.380
>
    79.123    30.549
    79.399    30.380
>
    79.090    30.510
    79.399    30.380
>
    79.090    30.510
    79.399    30.380
>
    78.998    30.631
    79.399    30.380
>
    78.998    30.631
    79.399    30.380
>
    79.396    30.403
    79.414    30.414
>
    79.427    30.437
    79.414    30.414
>
    79.427    30.437
    79.414    30.414
>
    79.396    30.403
    79.414    30.414
>
    79.442    30.463
    79.414    30.414
>
    79.442    30.463
    79.414    30.414
>
    79.442    30.463
    79.414    30.414
>
    79.319    30.418
    79.414    30.414
>
    79.319    30.418
    79.414    30.414
>
    79.320    30.410
    79.414    30.414
>
    79.320    30.410
    79.414    30.414
>
    79.317    30.383
    79.414    30.414
>
    79.317    30.383
    79.414    30.414
>
    79.456    30.251
    79.414    30.414
>
    79.456    30.251
    79.414    30.414
>
    79.561    30.555
    79.414    30.414
>
    79.561    30.555
    79.414    30.414
>
    79.247    30.247
    79.414    30.414
>
    79.247    30.247
    79.414    30.414
>
    79.223    30.252
    79.414    30.414
>
    79.123    30.549
    79.414    30.414
>
    79.123    30.549
    79.414    30.414
>
    79.090    30.510
    79.414    30.414
>
    79.090    30.510
    79.414    30.414
>
    79.042    30.413
    79.414    30.414
>
    79.042    30.413
    79.414    30.414
>
    78.998    30.631
    79.414    30.414
>
    79.319    30.418
    79.354    30.406
>
    79.319    30.418
    79.354    30.406
>
    79.320    30.410
    79.354    30.406
>
    79.320    30.410
    79.354    30.406
>
    79.396    30.403
    79.354    30.406
>
    79.396    30.403
    79.354    30.406
>
    79.427    30.437
    79.354    30.406
>
    79.427    30.437
    79.354    30.406
>
    79.442    30.463
    79.354    30.406
>
    79.442    30.463
    79.354    30.406
>
    79.334    30.250
    79.354    30.406
>
    79.334    30.250
    79.354    30.406
>
    79.223    30.252
    79.354    30.406
>
    79.223    30.252
    79.354    30.406
>
    79.123    30.549
    79.354    30.406
>
    79.123    30.549
    79.354    30.406
>
    79.561    30.555
    79.354    30.406
>
    79.561    30.555
    79.354    30.406
>
    79.042    30.413
    79.354    30.406
>
    79.042    30.413
    79.354    30.406
>
    79.320    30.410
    79.377    30.383
>
    79.320    30.410
    79.377    30.383
>
    79.319    30.418
    79.377    30.383
>
    79.319    30.418
    79.377    30.383
>
    79.396    30.403
    79.377    30.383
>
    79.396    30.403
    79.377    30.383
>
    79.427    30.437
    79.377    30.383
>
    79.442    30.463
    79.377    30.383
>
    79.442    30.463
    79.377    30.383
>
    79.334    30.250
    79.377    30.383
>
    79.334    30.250
    79.377    30.383
>
    79.416    30.250
    79.377    30.383
>
    79.416    30.250
    79.377    30.383
>
    79.456    30.251
    79.377    30.383
>
    79.456    30.251
    79.377    30.383
>
    79.217    30.262
    79.377    30.383
>
    79.217    30.262
    79.377    30.383
>
    79.247    30.247
    79.377    30.383
>
    79.247    30.247
    79.377    30.383
>
    79.223    30.252
    79.377    30.383
>
    79.223    30.252
    79.377    30.383
>
    79.108    30.296
    79.377    30.383
>
    79.561    30.555
    79.377    30.383
>
    79.561    30.555
    79.377    30.383
>
    79.123    30.549
    79.377    30.383
>
    79.123    30.549
    79.377    30.383
>
    79.042    30.413
    79.377    30.383
>
    79.042    30.413
    79.377    30.383
>
    78.973    30.291
    79.377    30.383
>
    79.396    30.403
    79.387    30.421
>
    79.396    30.403
    79.387    30.421
>
    79.320    30.410
    79.387    30.421
>
    79.320    30.410
    79.387    30.421
>
    79.319    30.418
    79.387    30.421
>
    79.319    30.418
    79.387    30.421
>
    79.427    30.437
    79.387    30.421
>
    79.442    30.463
    79.387    30.421
>
    79.442    30.463
    79.387    30.421
>
    79.334    30.250
    79.387    30.421
>
    79.416    30.250
    79.387    30.421
>
    79.334    30.250
    79.387    30.421
>
    79.456    30.251
    79.387    30.421
>
    79.416    30.250
    79.387    30.421
>
    79.456    30.251
    79.387    30.421
>
    79.561    30.555
    79.387    30.421
>
    79.247    30.247
    79.387    30.421
>
    79.561    30.555
    79.387    30.421
>
    79.247    30.247
    79.387    30.421
>
    79.217    30.262
    79.387    30.421
>
    79.217    30.262
    79.387    30.421
>
    79.223    30.252
    79.387    30.421
>
    79.123    30.549
    79.387    30.421
>
    79.123    30.549
    79.387    30.421
>
    79.042    30.413
    79.387    30.421
>
    79.042    30.413
    79.387    30.421
>
    79.320    30.410
    79.403    30.367
>
    79.396    30.403
    79.403    30.367
>
    79.396    30.403
    79.403    30.367
>
    79.320    30.410
    79.403    30.367
>
    79.319    30.418
    79.403    30.367
>
    79.319    30.418
    79.403    30.367
>
    79.427    30.437
    79.403    30.367
>
    79.442    30.463
    79.403    30.367
>
    79.442    30.463
    79.403    30.367
>
    79.334    30.250
    79.403    30.367
>
    79.416    30.250
    79.403    30.367
>
    79.416    30.250
    79.403    30.367
>
    79.194    30.329
    79.403    30.367
>
    79.194    30.329
    79.403    30.367
>
    79.217    30.262
    79.403    30.367
>
    79.217    30.262
    79.403    30.367
>
    79.223    30.252
    79.403    30.367
>
    79.223    30.252
    79.403    30.367
>
    79.108    30.296
    79.403    30.367
>
    79.108    30.296
    79.403    30.367
>
    79.561    30.555
    79.403    30.367
>
    79.561    30.555
    79.403    30.367
>
    79.123    30.549
    79.403    30.367
>
    79.123    30.549
    79.403    30.367
>
    79.042    30.413
    79.403    30.367
>
    79.042    30.413
    79.403    30.367
>
    78.980    30.284
    79.403    30.367
>
    78.980    30.284
    79.403    30.367
>
    79.320    30.410
    79.369    30.423
>
    79.320    30.410
    79.369    30.423
>
    79.396    30.403
    79.369    30.423
>
    79.396    30.403
    79.369    30.423
>
    79.427    30.437
    79.369    30.423
>
    79.442    30.463
    79.369    30.423
>
    79.442    30.463
    79.369    30.423
>
    79.194    30.329
    79.369    30.423
>
    79.194    30.329
    79.369    30.423
>
    79.334    30.250
    79.369    30.423
>
    79.334    30.250
    79.369    30.423
>
    79.416    30.250
    79.369    30.423
>
    79.456    30.251
    79.369    30.423
>
    79.456    30.251
    79.369    30.423
>
    79.416    30.250
    79.369    30.423
>
    79.217    30.262
    79.369    30.423
>
    79.217    30.262
    79.369    30.423
>
    79.247    30.247
    79.369    30.423
>
    79.247    30.247
    79.369    30.423
>
    79.123    30.549
    79.369    30.423
>
    79.123    30.549
    79.369    30.423
>
    79.561    30.555
    79.369    30.423
>
    79.561    30.555
    79.369    30.423
>
    79.108    30.296
    79.369    30.423
>
    79.108    30.296
    79.369    30.423
>
    79.042    30.413
    79.369    30.423
>
    79.042    30.413
    79.369    30.423
>
    78.973    30.291
    79.369    30.423
>
    78.973    30.291
    79.369    30.423
>
    78.980    30.284
    79.369    30.423
>
    78.980    30.284
    79.369    30.423
>
    79.396    30.403
    79.397    30.366
>
    79.396    30.403
    79.397    30.366
>
    79.317    30.383
    79.397    30.366
>
    79.317    30.383
    79.397    30.366
>
    79.320    30.410
    79.397    30.366
>
    79.320    30.410
    79.397    30.366
>
    79.319    30.418
    79.397    30.366
>
    79.319    30.418
    79.397    30.366
>
    79.442    30.463
    79.397    30.366
>
    79.442    30.463
    79.397    30.366
>
    79.334    30.250
    79.397    30.366
>
    79.334    30.250
    79.397    30.366
>
    79.456    30.251
    79.397    30.366
>
    79.456    30.251
    79.397    30.366
>
    79.416    30.250
    79.397    30.366
>
    79.416    30.250
    79.397    30.366
>
    79.194    30.329
    79.397    30.366
>
    79.194    30.329
    79.397    30.366
>
    79.247    30.247
    79.397    30.366
>
    79.223    30.252
    79.397    30.366
>
    79.217    30.262
    79.397    30.366
>
    79.217    30.262
    79.397    30.366
>
    79.223    30.252
    79.397    30.366
>
    79.108    30.296
    79.397    30.366
>
    79.108    30.296
    79.397    30.366
>
    79.561    30.555
    79.397    30.366
>
    79.561    30.555
    79.397    30.366
>
    79.123    30.549
    79.397    30.366
>
    79.123    30.549
    79.397    30.366
>
    79.042    30.413
    79.397    30.366
>
    79.042    30.413
    79.397    30.366
>
    78.980    30.284
    79.397    30.366
>
    78.980    30.284
    79.397    30.366
>
    79.319    30.418
    79.348    30.431
>
    79.319    30.418
    79.348    30.431
>
    79.396    30.403
    79.348    30.431
>
    79.396    30.403
    79.348    30.431
>
    79.427    30.437
    79.348    30.431
>
    79.427    30.437
    79.348    30.431
>
    79.442    30.463
    79.348    30.431
>
    79.442    30.463
    79.348    30.431
>
    79.194    30.329
    79.348    30.431
>
    79.194    30.329
    79.348    30.431
>
    79.334    30.250
    79.348    30.431
>
    79.334    30.250
    79.348    30.431
>
    79.217    30.262
    79.348    30.431
>
    79.217    30.262
    79.348    30.431
>
    79.247    30.247
    79.348    30.431
>
    79.223    30.252
    79.348    30.431
>
    79.223    30.252
    79.348    30.431
>
    79.456    30.251
    79.348    30.431
>
    79.456    30.251
    79.348    30.431
>
    79.416    30.250
    79.348    30.431
>
    79.416    30.250
    79.348    30.431
>
    79.108    30.296
    79.348    30.431
>
    79.108    30.296
    79.348    30.431
>
    79.042    30.413
    79.348    30.431
>
    79.042    30.413
    79.348    30.431
>
    78.980    30.284
    79.348    30.431
>
    78.973    30.291
    79.348    30.431
>
    79.319    30.418
    79.349    30.430
>
    79.319    30.418
    79.349    30.430
>
    79.320    30.410
    79.349    30.430
>
    79.320    30.410
    79.349    30.430
>
    79.317    30.383
    79.349    30.430
>
    79.317    30.383
    79.349    30.430
>
    79.396    30.403
    79.349    30.430
>
    79.396    30.403
    79.349    30.430
>
    79.427    30.437
    79.349    30.430
>
    79.427    30.437
    79.349    30.430
>
    79.321    30.328
    79.349    30.430
>
    79.442    30.463
    79.349    30.430
>
    79.442    30.463
    79.349    30.430
>
    79.194    30.329
    79.349    30.430
>
    79.194    30.329
    79.349    30.430
>
    79.334    30.250
    79.349    30.430
>
    79.334    30.250
    79.349    30.430
>
    79.223    30.252
    79.349    30.430
>
    79.223    30.252
    79.349    30.430
>
    79.247    30.247
    79.349    30.430
>
    79.247    30.247
    79.349    30.430
>
    79.223    30.252
    79.349    30.430
>
    79.223    30.252
    79.349    30.430
>
    79.416    30.250
    79.349    30.430
>
    79.416    30.250
    79.349    30.430
>
    79.456    30.251
    79.349    30.430
>
    79.456    30.251
    79.349    30.430
>
    79.416    30.250
    79.349    30.430
>
    79.042    30.413
    79.349    30.430
>
    79.042    30.413
    79.349    30.430
>
    78.980    30.284
    79.349    30.430
>
    78.980    30.284
    79.349    30.430
>
    79.396    30.403
    79.404    30.392
>
    79.320    30.410
    79.404    30.392
>
    79.396    30.403
    79.404    30.392
>
    79.320    30.410
    79.404    30.392
>
    79.317    30.383
    79.404    30.392
>
    79.317    30.383
    79.404    30.392
>
    79.319    30.418
    79.404    30.392
>
    79.319    30.418
    79.404    30.392
>
    79.427    30.437
    79.404    30.392
>
    79.427    30.437
    79.404    30.392
>
    79.442    30.463
    79.404    30.392
>
    79.442    30.463
    79.404    30.392
>
    79.334    30.250
    79.404    30.392
>
    79.334    30.250
    79.404    30.392
>
    79.416    30.250
    79.404    30.392
>
    79.416    30.250
    79.404    30.392
>
    79.456    30.251
    79.404    30.392
>
    79.456    30.251
    79.404    30.392
>
    79.247    30.247
    79.404    30.392
>
    79.247    30.247
    79.404    30.392
>
    79.223    30.252
    79.404    30.392
>
    79.223    30.252
    79.404    30.392
>
    79.042    30.413
    79.404    30.392
>
    79.042    30.413
    79.404    30.392
>
    79.042    30.413
    79.404    30.392
>
    79.319    30.418
    79.403    30.499
>
    79.427    30.437
    79.403    30.499
>
    79.427    30.437
    79.403    30.499
>
    79.442    30.463
    79.403    30.499
>
    79.442    30.463
    79.403    30.499
>
    79.319    30.418
    79.403    30.499
>
    79.320    30.410
    79.403    30.499
>
    79.320    30.410
    79.403    30.499
>
    79.396    30.403
    79.403    30.499
>
    79.396    30.403
    79.403    30.499
>
    79.321    30.328
    79.403    30.499
>
    79.321    30.328
    79.403    30.499
>
    79.194    30.329
    79.403    30.499
>
    79.194    30.329
    79.403    30.499
>
    79.456    30.251
    79.403    30.499
>
    79.416    30.250
    79.403    30.499
>
    79.334    30.250
    79.403    30.499
>
    79.334    30.250
    79.403    30.499
>
    79.416    30.250
    79.403    30.499
>
    79.456    30.251
    79.403    30.499
>
    79.247    30.247
    79.403    30.499
>
    79.247    30.247
    79.403    30.499
>
    79.223    30.252
    79.403    30.499
>
    79.223    30.252
    79.403    30.499
>
    79.042    30.413
    79.403    30.499
>
    79.042    30.413
    79.403    30.499
>
    79.108    30.296
    79.403    30.499
>
    79.108    30.296
    79.403    30.499
>
    78.980    30.284
    79.403    30.499
>
    78.980    30.284
    79.403    30.499
>
    79.320    30.410
    79.367    30.401
>
    79.320    30.410
    79.367    30.401
>
    79.319    30.418
    79.367    30.401
>
    79.319    30.418
    79.367    30.401
>
    79.321    30.328
    79.367    30.401
>
    79.321    30.328
    79.367    30.401
>
    79.396    30.403
    79.367    30.401
>
    79.396    30.403
    79.367    30.401
>
    79.427    30.437
    79.367    30.401
>
    79.427    30.437
    79.367    30.401
>
    79.194    30.329
    79.367    30.401
>
    79.194    30.329
    79.367    30.401
>
    79.442    30.463
    79.367    30.401
>
    79.442    30.463
    79.367    30.401
>
    79.334    30.250
    79.367    30.401
>
    79.217    30.262
    79.367    30.401
>
    79.217    30.262
    79.367    30.401
>
    79.223    30.252
    79.367    30.401
>
    79.223    30.252
    79.367    30.401
>
    79.223    30.252
    79.367    30.401
>
    79.247    30.247
    79.367    30.401
>
    79.247    30.247
    79.367    30.401
>
    79.223    30.252
    79.367    30.401
>
    79.456    30.251
    79.367    30.401
>
    79.416    30.250
    79.367    30.401
>
    79.456    30.251
    79.367    30.401
>
    79.108    30.296
    79.367    30.401
>
    79.108    30.296
    79.367    30.401
>
    79.042    30.413
    79.367    30.401
>
    79.042    30.413
    79.367    30.401
>
    78.973    30.291
    79.367    30.401
>
    79.319    30.418
    79.346    30.420
>
    79.319    30.418
    79.346    30.420
>
    79.320    30.410
    79.346    30.420
>
    79.396    30.403
    79.346    30.420
>
    79.396    30.403
    79.346    30.420
>
    79.427    30.437
    79.346    30.420
>
    79.427    30.437
    79.346    30.420
>
    79.321    30.328
    79.346    30.420
>
    79.321    30.328
    79.346    30.420
>
    79.442    30.463
    79.346    30.420
>
    79.442    30.463
    79.346    30.420
>
    79.334    30.250
    79.346    30.420
>
    79.334    30.250
    79.346    30.420
>
    79.416    30.250
    79.346    30.420
>
    79.416    30.250
    79.346    30.420
>
    79.217    30.262
    79.346    30.420
>
    79.223    30.252
    79.346    30.420
>
    79.223    30.252
    79.346    30.420
>
    79.217    30.262
    79.346    30.420
>
    79.042    30.413
    79.346    30.420
>
    79.396    30.403
    79.331    30.422
>
    79.319    30.418
    79.331    30.422
>
    79.427    30.437
    79.331    30.422
>
    79.427    30.437
    79.331    30.422
>
    79.334    30.250
    79.331    30.422
>
    79.334    30.250
    79.331    30.422
>
    79.217    30.262
    79.331    30.422
>
    79.217    30.262
    79.331    30.422
>
    79.108    30.296
    79.331    30.422
>
    79.108    30.296
    79.331    30.422
>
    77.167    31.128
    77.820    31.220
>
    77.167    31.128
    77.820    31.220
>
    76.970    31.500
    77.820    31.220
>
    80.217    29.550
    79.981    30.047
>
    78.056    30.323
    78.256    30.991
>
    78.056    30.323
    78.256    30.991
>
    78.056    30.323
    78.123    30.939
>
    78.056    30.323
    78.128    31.096
>
    78.056    30.323
    78.128    31.096
>
    80.740    29.480
    80.566    29.897
>
    81.200    29.470
    80.566    29.897
>
    81.200    29.470
    80.566    29.897
>
    80.246    29.450
    80.015    30.045
>
    80.246    29.450
    80.015    30.045
>
    78.056    30.323
    78.244    30.912
>
    78.056    30.323
    78.244    30.912
>
    80.246    29.450
    80.649    29.952
>
    80.246    29.450
    80.649    29.952
>
    80.217    29.550
    80.053    30.080
>
    78.056    30.323
    77.549    30.534
>
    78.056    30.323
    77.549    30.534
>
    77.167    31.128
    77.549    30.534
>
    77.167    31.128
    77.549    30.534
>
    79.558    30.556
    79.317    30.577
>
    79.558    30.556
    79.317    30.577
>
    79.558    30.556
    79.246    30.559
>
    79.558    30.556
    79.246    30.559
>
    80.217    29.550
    80.403    30.302
>
    79.558    30.556
    80.335    30.659
>
    79.558    30.556
    80.335    30.659
>
    79.558    30.556
    79.113    30.610
>
    79.558    30.556
    79.113    30.610
>
    79.558    30.556
    79.113    30.610
>
    79.558    30.556
    79.292    30.672
>
    79.558    30.556
    80.358    30.301
>
    80.246    29.450
    80.418    29.579
>
    80.217    29.550
    80.418    29.579
>
    80.217    29.550
    80.717    29.714
>
    80.217    29.550
    80.717    29.714
>
    78.056    30.323
    78.367    30.870
>
    78.056    30.323
    78.367    30.870
>
    78.250    31.533
    78.367    30.870
>
    78.056    30.323
    78.505    30.890
>
    80.217    29.550
    80.044    30.051
>
    80.217    29.550
    80.044    30.051
>
    80.246    29.450
    80.044    30.051
>
    80.217    29.550
    80.418    30.320
>
    80.217    29.550
    80.167    29.917
>
    80.246    29.450
    80.605    29.874
>
    80.246    29.450
    80.605    29.874
>
    80.217    29.550
    80.184    29.959
>
    80.246    29.450
    80.184    29.959
>
    78.056    30.323
    78.159    30.995
>
    78.056    30.323
    78.159    30.995
>
    78.056    30.323
    78.259    30.927
>
    78.056    30.323
    78.259    30.927
>
    78.250    31.533
    78.259    30.927
>
    78.250    31.533
    78.259    30.927
>
    78.250    31.533
    78.121    30.965
>
    78.250    31.533
    78.121    30.965
>
    78.056    30.323
    78.121    30.965
>
    78.056    30.323
    78.121    30.965
>
    79.558    30.556
    79.179    30.561
>
    79.558    30.556
    79.179    30.561
>
    79.558    30.556
    79.982    30.014
>
    79.558    30.556
    79.982    30.014
>
    80.217    29.550
    80.068    30.066
>
    79.558    30.556
    80.068    30.066
>
    80.217    29.550
    80.334    30.232
>
    80.246    29.450
    80.334    30.232
>
    78.056    30.323
    78.187    30.992
>
    78.056    30.323
    78.187    30.992
>
    80.217    29.550
    80.515    29.844
>
    80.217    29.550
    79.849    30.002
>
    79.208    30.152
    79.849    30.002
>
    79.208    30.152
    79.849    30.002
>
    80.246    29.450
    79.849    30.002
>
    80.246    29.450
    79.849    30.002
>
    80.246    29.450
    80.434    29.899
>
    80.246    29.450
    80.434    29.899
>
    80.217    29.550
    80.063    30.036
>
    80.246    29.450
    80.063    30.036
>
    78.056    30.323
    78.334    30.336
>
    78.056    30.323
    78.334    30.336
>
    77.167    31.128
    77.861    31.223
>
    77.167    31.128
    77.861    31.223
>
    80.246    29.450
    80.434    29.846
>
    79.558    30.556
    80.397    30.297
>
    78.056    30.323
    78.139    31.040
>
    78.056    30.323
    78.139    31.040
>
    79.558    30.556
    79.315    30.558
>
    79.558    30.556
    79.315    30.558
>
    78.748    30.527
    78.272    30.972
>
    78.748    30.527
    78.272    30.972
>
    78.056    30.323
    78.272    30.972
>
    78.056    30.323
    78.272    30.972
>
    79.003    30.621
    78.272    30.972
>
    78.056    30.323
    78.391    30.897
>
    78.056    30.323
    78.391    30.897
>
    78.056    30.323
    78.264    30.955
>
    78.056    30.323
    78.264    30.955
>
    79.558    30.556
    79.182    30.575
>
    79.558    30.556
    79.182    30.575
>
    79.558    30.556
    79.997    30.254
>
    79.558    30.556
    79.997    30.254
>
    80.217    29.550
    79.909    30.095
>
    80.217    29.550
    79.909    30.095
>
    80.246    29.450
    79.909    30.095
>
    80.246    29.450
    79.909    30.095
>
    80.246    29.450
    80.539    29.953
>
    78.056    30.323
    78.087    30.979
>
    78.056    30.323
    78.087    30.979
>
    80.238    30.066
    79.986    30.088
>
    80.238    30.066
    79.986    30.088
>
    80.164    29.905
    79.986    30.088
>
    80.164    29.905
    79.986    30.088
>
    80.049    29.775
    79.986    30.088
>
    80.049    29.775
    79.986    30.088
>
    79.673    29.887
    79.986    30.088
>
    79.673    29.887
    79.986    30.088
>
    79.563    30.001
    79.986    30.088
>
    79.563    30.001
    79.986    30.088
>
    79.648    29.592
    79.986    30.088
>
    79.648    29.592
    79.986    30.088
>
    79.217    30.265
    79.986    30.088
>
    79.217    30.265
    79.986    30.088
>
    80.094    29.403
    79.986    30.088
>
    80.094    29.403
    79.986    30.088
>
    79.563    30.001
    79.551    30.236
>
    79.563    30.001
    79.551    30.236
>
    79.322    30.406
    79.551    30.236
>
    79.322    30.406
    79.551    30.236
>
    79.217    30.265
    79.551    30.236
>
    79.217    30.265
    79.551    30.236
>
    79.673    29.887
    79.551    30.236
>
    79.673    29.887
    79.551    30.236
>
    79.595    29.852
    79.551    30.236
>
    79.416    29.770
    79.551    30.236
>
    79.019    30.389
    79.551    30.236
>
    80.238    30.066
    79.551    30.236
>
    80.164    29.905
    79.551    30.236
>
    80.049    29.775
    79.551    30.236
>
    78.975    30.639
    79.551    30.236
>
    79.648    29.592
    79.551    30.236
>
    80.238    30.066
    80.134    30.014
>
    80.164    29.905
    80.134    30.014
>
    80.164    29.905
    80.134    30.014
>
    80.049    29.775
    80.134    30.014
>
    80.049    29.775
    80.134    30.014
>
    80.544    29.849
    80.134    30.014
>
    80.544    29.849
    80.134    30.014
>
    79.673    29.887
    80.134    30.014
>
    79.673    29.887
    80.134    30.014
>
    80.234    29.552
    80.134    30.014
>
    80.234    29.552
    80.134    30.014
>
    79.563    30.001
    80.134    30.014
>
    79.563    30.001
    80.134    30.014
>
    79.595    29.852
    80.134    30.014
>
    79.595    29.852
    80.134    30.014
>
    79.648    29.592
    80.134    30.014
>
    79.648    29.592
    80.134    30.014
>
    80.094    29.403
    80.134    30.014
>
    80.094    29.403
    80.134    30.014
>
    79.930    29.407
    80.134    30.014
>
    79.930    29.407
    80.134    30.014
>
    79.416    29.770
    80.134    30.014
>
    79.416    29.770
    80.134    30.014
>
    80.217    29.550
    80.134    30.014
>
    80.217    29.550
    80.134    30.014
>
    80.246    29.450
    80.134    30.014
>
    80.238    30.066
    80.132    30.019
>
    80.238    30.066
    80.132    30.019
>
    80.164    29.905
    80.132    30.019
>
    80.164    29.905
    80.132    30.019
>
    80.049    29.775
    80.132    30.019
>
    80.544    29.849
    80.132    30.019
>
    79.673    29.887
    80.132    30.019
>
    79.673    29.887
    80.132    30.019
>
    80.234    29.552
    80.132    30.019
>
    80.234    29.552
    80.132    30.019
>
    79.563    30.001
    80.132    30.019
>
    79.563    30.001
    80.132    30.019
>
    79.595    29.852
    80.132    30.019
>
    79.595    29.852
    80.132    30.019
>
    79.648    29.592
    80.132    30.019
>
    79.648    29.592
    80.132    30.019
>
    80.094    29.403
    80.132    30.019
>
    80.094    29.403
    80.132    30.019
>
    79.930    29.407
    80.132    30.019
>
    79.930    29.407
    80.132    30.019
>
    79.416    29.770
    80.132    30.019
>
    79.416    29.770
    80.132    30.019
>
    80.164    29.905
    80.002    30.053
>
    80.164    29.905
    80.002    30.053
>
    80.238    30.066
    80.002    30.053
>
    80.238    30.066
    80.002    30.053
>
    80.049    29.775
    80.002    30.053
>
    80.049    29.775
    80.002    30.053
>
    79.673    29.887
    80.002    30.053
>
    79.673    29.887
    80.002    30.053
>
    80.248    29.803
    80.002    30.053
>
    80.248    29.803
    80.002    30.053
>
    79.563    30.001
    80.002    30.053
>
    79.563    30.001
    80.002    30.053
>
    80.544    29.849
    80.002    30.053
>
    80.544    29.849
    80.002    30.053
>
    80.234    29.552
    80.002    30.053
>
    80.234    29.552
    80.002    30.053
>
    79.648    29.592
    80.002    30.053
>
    79.648    29.592
    80.002    30.053
>
    79.416    29.770
    80.002    30.053
>
    79.416    29.770
    80.002    30.053
>
    80.094    29.403
    80.002    30.053
>
    80.094    29.403
    80.002    30.053
>
    79.322    30.406
    80.002    30.053
>
    79.217    30.265
    80.002    30.053
>
    80.107    29.330
    80.002    30.053
>
    80.234    29.552
    80.374    29.658
>
    80.234    29.552
    80.374    29.658
>
    80.248    29.803
    80.374    29.658
>
    80.248    29.803
    80.374    29.658
>
    80.544    29.849
    80.374    29.658
>
    80.049    29.775
    80.374    29.658
>
    80.049    29.775
    80.374    29.658
>
    80.164    29.905
    80.374    29.658
>
    80.094    29.403
    80.374    29.658
>
    80.107    29.330
    80.374    29.658
>
    80.107    29.330
    80.374    29.658
>
    80.238    30.066
    80.374    29.658
>
    79.930    29.407
    80.374    29.658
>
    79.648    29.592
    80.374    29.658
>
    79.648    29.592
    80.374    29.658
>
    79.673    29.887
    80.374    29.658
>
    79.673    29.887
    80.374    29.658
>
    79.563    30.001
    80.374    29.658
>
    79.563    30.001
    80.374    29.658
>
    79.322    30.406
    79.208    30.464
>
    79.322    30.406
    79.208    30.464
>
    79.019    30.389
    79.208    30.464
>
    79.019    30.389
    79.208    30.464
>
    79.217    30.265
    79.208    30.464
>
    79.217    30.265
    79.208    30.464
>
    78.975    30.639
    79.208    30.464
>
    78.975    30.639
    79.208    30.464
>
    78.640    30.431
    79.208    30.464
>
    78.640    30.431
    79.208    30.464
>
    79.563    30.001
    79.208    30.464
>
    79.563    30.001
    79.208    30.464
>
    79.673    29.887
    79.208    30.464
>
    79.673    29.887
    79.208    30.464
>
    79.416    29.770
    79.208    30.464
>
    79.416    29.770
    79.208    30.464
>
    79.322    30.406
    79.388    30.448
>
    79.322    30.406
    79.388    30.448
>
    79.217    30.265
    79.388    30.448
>
    79.217    30.265
    79.388    30.448
>
    79.019    30.389
    79.388    30.448
>
    79.019    30.389
    79.388    30.448
>
    78.975    30.639
    79.388    30.448
>
    78.975    30.639
    79.388    30.448
>
    79.563    30.001
    79.388    30.448
>
    79.563    30.001
    79.388    30.448
>
    79.673    29.887
    79.388    30.448
>
    79.673    29.887
    79.388    30.448
>
    78.640    30.431
    79.388    30.448
>
    79.416    29.770
    79.388    30.448
>
    79.416    29.770
    79.388    30.448
>
    79.019    30.389
    79.134    30.617
>
    79.019    30.389
    79.134    30.617
>
    79.322    30.406
    79.134    30.617
>
    79.322    30.406
    79.134    30.617
>
    79.217    30.265
    79.134    30.617
>
    79.217    30.265
    79.134    30.617
>
    78.640    30.431
    79.134    30.617
>
    78.640    30.431
    79.134    30.617
>
    79.563    30.001
    79.134    30.617
>
    79.563    30.001
    79.134    30.617
>
    78.975    30.639
    78.990    30.588
>
    78.975    30.639
    78.990    30.588
>
    79.019    30.389
    78.990    30.588
>
    79.019    30.389
    78.990    30.588
>
    78.640    30.431
    78.990    30.588
>
    78.640    30.431
    78.990    30.588
>
    79.322    30.406
    78.990    30.588
>
    79.322    30.406
    78.990    30.588
>
    79.217    30.265
    78.990    30.588
>
    79.217    30.265
    78.990    30.588
>
    79.563    30.001
    78.990    30.588
>
    79.563    30.001
    78.990    30.588
>
    80.164    29.905
    79.982    30.038
>
    80.164    29.905
    79.982    30.038
>
    80.238    30.066
    79.982    30.038
>
    80.238    30.066
    79.982    30.038
>
    80.049    29.775
    79.982    30.038
>
    80.049    29.775
    79.982    30.038
>
    79.673    29.887
    79.982    30.038
>
    79.673    29.887
    79.982    30.038
>
    80.248    29.803
    79.982    30.038
>
    80.248    29.803
    79.982    30.038
>
    79.563    30.001
    79.982    30.038
>
    79.563    30.001
    79.982    30.038
>
    80.234    29.552
    79.982    30.038
>
    79.416    29.770
    79.982    30.038
>
    79.416    29.770
    79.982    30.038
>
    80.094    29.403
    79.982    30.038
>
    80.094    29.403
    79.982    30.038
>
    79.217    30.265
    79.982    30.038
>
    79.217    30.265
    79.982    30.038
>
    80.238    30.066
    80.392    29.972
>
    80.238    30.066
    80.392    29.972
>
    80.544    29.849
    80.392    29.972
>
    80.544    29.849
    80.392    29.972
>
    80.164    29.905
    80.392    29.972
>
    80.164    29.905
    80.392    29.972
>
    80.049    29.775
    80.392    29.972
>
    80.049    29.775
    80.392    29.972
>
    80.234    29.552
    80.392    29.972
>
    80.234    29.552
    80.392    29.972
>
    80.094    29.403
    80.392    29.972
>
    80.094    29.403
    80.392    29.972
>
    79.673    29.887
    80.392    29.972
>
    80.107    29.330
    80.392    29.972
>
    79.930    29.407
    80.392    29.972
>
    79.930    29.407
    80.392    29.972
>
    79.563    30.001
    80.392    29.972
>
    80.238    30.066
    79.930    30.173
>
    80.238    30.066
    79.930    30.173
>
    80.164    29.905
    79.930    30.173
>
    80.164    29.905
    79.930    30.173
>
    79.673    29.887
    79.930    30.173
>
    79.673    29.887
    79.930    30.173
>
    79.563    30.001
    79.930    30.173
>
    79.563    30.001
    79.930    30.173
>
    80.049    29.775
    79.930    30.173
>
    80.049    29.775
    79.930    30.173
>
    80.248    29.803
    79.930    30.173
>
    80.248    29.803
    79.930    30.173
>
    79.322    30.406
    79.930    30.173
>
    79.322    30.406
    79.930    30.173
>
    79.416    29.770
    79.930    30.173
>
    79.416    29.770
    79.930    30.173
>
    79.217    30.265
    79.930    30.173
>
    79.217    30.265
    79.930    30.173
>
    80.544    29.849
    79.930    30.173
>
    80.544    29.849
    79.930    30.173
>
    80.234    29.552
    79.930    30.173
>
    80.234    29.552
    79.930    30.173
>
    79.930    29.407
    79.930    30.173
>
    79.930    29.407
    79.930    30.173
>
    80.094    29.403
    79.930    30.173
>
    80.094    29.403
    79.930    30.173
>
    79.019    30.389
    79.126    30.564
>
    79.019    30.389
    79.126    30.564
>
    78.975    30.639
    79.126    30.564
>
    78.975    30.639
    79.126    30.564
>
    79.322    30.406
    79.126    30.564
>
    79.322    30.406
    79.126    30.564
>
    79.217    30.265
    79.126    30.564
>
    79.217    30.265
    79.126    30.564
>
    78.640    30.431
    79.126    30.564
>
    78.640    30.431
    79.126    30.564
>
    79.563    30.001
    79.126    30.564
>
    79.563    30.001
    79.126    30.564
>
    79.019    30.389
    79.121    30.541
>
    79.019    30.389
    79.121    30.541
>
    78.975    30.639
    79.121    30.541
>
    78.975    30.639
    79.121    30.541
>
    79.322    30.406
    79.121    30.541
>
    79.322    30.406
    79.121    30.541
>
    79.217    30.265
    79.121    30.541
>
    79.217    30.265
    79.121    30.541
>
    78.640    30.431
    79.121    30.541
>
    79.563    30.001
    79.121    30.541
>
    79.563    30.001
    79.121    30.541
>
    79.558    30.556
    79.121    30.541
>
    79.558    30.556
    79.121    30.541
>
    79.673    29.887
    79.795    30.047
>
    79.673    29.887
    79.795    30.047
>
    79.563    30.001
    79.795    30.047
>
    79.563    30.001
    79.795    30.047
>
    80.049    29.775
    79.795    30.047
>
    80.049    29.775
    79.795    30.047
>
    80.164    29.905
    79.795    30.047
>
    80.164    29.905
    79.795    30.047
>
    79.416    29.770
    79.795    30.047
>
    79.416    29.770
    79.795    30.047
>
    80.248    29.803
    79.795    30.047
>
    79.322    30.406
    79.795    30.047
>
    79.217    30.265
    79.795    30.047
>
    80.234    29.552
    79.795    30.047
>
    80.234    29.552
    79.795    30.047
>
    79.930    29.407
    79.795    30.047
>
    79.930    29.407
    79.795    30.047
>
    80.094    29.403
    79.795    30.047
>
    80.094    29.403
    79.795    30.047
>
    79.457    29.359
    79.795    30.047
>
    79.457    29.359
    79.795    30.047
>
    79.019    30.389
    79.795    30.047
>
    80.107    29.330
    79.795    30.047
>
    79.019    30.389
    78.835    30.005
>
    79.019    30.389
    78.835    30.005
>
    79.217    30.265
    78.835    30.005
>
    79.217    30.265
    78.835    30.005
>
    78.640    30.431
    78.835    30.005
>
    78.640    30.431
    78.835    30.005
>
    79.416    29.770
    78.835    30.005
>
    79.416    29.770
    78.835    30.005
>
    79.322    30.406
    78.835    30.005
>
    79.322    30.406
    78.835    30.005
>
    79.563    30.001
    78.835    30.005
>
    79.563    30.001
    78.835    30.005
>
    79.673    29.887
    78.835    30.005
>
    79.673    29.887
    78.835    30.005
>
    79.563    30.001
    79.872    30.154
>
    79.563    30.001
    79.872    30.154
>
    79.673    29.887
    79.872    30.154
>
    79.673    29.887
    79.872    30.154
>
    80.238    30.066
    79.872    30.154
>
    80.238    30.066
    79.872    30.154
>
    80.164    29.905
    79.872    30.154
>
    80.164    29.905
    79.872    30.154
>
    80.049    29.775
    79.872    30.154
>
    80.049    29.775
    79.872    30.154
>
    80.248    29.803
    79.872    30.154
>
    80.248    29.803
    79.872    30.154
>
    79.322    30.406
    79.872    30.154
>
    79.217    30.265
    79.872    30.154
>
    79.217    30.265
    79.872    30.154
>
    80.234    29.552
    79.872    30.154
>
    80.234    29.552
    79.872    30.154
>
    79.019    30.389
    79.872    30.154
>
    80.094    29.403
    79.872    30.154
>
    80.094    29.403
    79.872    30.154
>
    80.544    29.849
    80.423    29.863
>
    80.544    29.849
    80.423    29.863
>
    80.248    29.803
    80.423    29.863
>
    80.248    29.803
    80.423    29.863
>
    80.238    30.066
    80.423    29.863
>
    80.238    30.066
    80.423    29.863
>
    80.049    29.775
    80.423    29.863
>
    80.049    29.775
    80.423    29.863
>
    80.234    29.552
    80.423    29.863
>
    80.234    29.552
    80.423    29.863
>
    80.094    29.403
    80.423    29.863
>
    80.094    29.403
    80.423    29.863
>
    80.107    29.330
    80.423    29.863
>
    80.107    29.330
    80.423    29.863
>
    79.930    29.407
    80.423    29.863
>
    79.930    29.407
    80.423    29.863
>
    79.673    29.887
    80.423    29.863
>
    79.673    29.887
    80.423    29.863
>
    80.164    29.905
    80.174    30.041
>
    80.164    29.905
    80.174    30.041
>
    80.248    29.803
    80.174    30.041
>
    80.248    29.803
    80.174    30.041
>
    80.049    29.775
    80.174    30.041
>
    80.049    29.775
    80.174    30.041
>
    80.544    29.849
    80.174    30.041
>
    80.040    29.660
    80.174    30.041
>
    80.040    29.660
    80.174    30.041
>
    79.673    29.887
    80.174    30.041
>
    79.673    29.887
    80.174    30.041
>
    80.234    29.552
    80.174    30.041
>
    79.563    30.001
    80.174    30.041
>
    79.563    30.001
    80.174    30.041
>
    79.595    29.852
    80.174    30.041
>
    79.595    29.852
    80.174    30.041
>
    79.648    29.592
    80.174    30.041
>
    79.648    29.592
    80.174    30.041
>
    80.094    29.403
    80.174    30.041
>
    80.094    29.403
    80.174    30.041
>
    79.930    29.407
    80.174    30.041
>
    79.930    29.407
    80.174    30.041
>
    79.416    29.770
    80.174    30.041
>
    80.107    29.330
    80.174    30.041
>
    80.107    29.330
    80.174    30.041
>
    79.217    30.265
    79.452    30.244
>
    79.217    30.265
    79.452    30.244
>
    79.322    30.406
    79.452    30.244
>
    79.673    29.887
    79.452    30.244
>
    79.673    29.887
    79.452    30.244
>
    79.019    30.389
    79.452    30.244
>
    79.019    30.389
    79.452    30.244
>
    79.595    29.852
    79.452    30.244
>
    79.595    29.852
    79.452    30.244
>
    79.416    29.770
    79.452    30.244
>
    79.416    29.770
    79.452    30.244
>
    78.975    30.639
    79.452    30.244
>
    78.975    30.639
    79.452    30.244
>
    79.648    29.592
    79.452    30.244
>
    79.648    29.592
    79.452    30.244
>
    80.049    29.775
    79.452    30.244
>
    80.049    29.775
    79.452    30.244
>
    78.640    30.431
    79.452    30.244
>
    78.640    30.431
    79.452    30.244
>
    80.040    29.660
    79.452    30.244
>
    79.563    30.001
    79.865    30.137
>
    79.563    30.001
    79.865    30.137
>
    79.673    29.887
    79.865    30.137
>
    79.673    29.887
    79.865    30.137
>
    80.164    29.905
    79.865    30.137
>
    79.595    29.852
    79.865    30.137
>
    79.595    29.852
    79.865    30.137
>
    80.049    29.775
    79.865    30.137
>
    80.049    29.775
    79.865    30.137
>
    80.248    29.803
    79.865    30.137
>
    80.248    29.803
    79.865    30.137
>
    80.040    29.660
    79.865    30.137
>
    80.040    29.660
    79.865    30.137
>
    79.322    30.406
    79.865    30.137
>
    79.217    30.265
    79.865    30.137
>
    79.217    30.265
    79.865    30.137
>
    79.648    29.592
    79.865    30.137
>
    79.648    29.592
    79.865    30.137
>
    80.234    29.552
    79.865    30.137
>
    80.234    29.552
    79.865    30.137
>
    79.930    29.407
    79.865    30.137
>
    80.094    29.403
    79.865    30.137
>
    79.019    30.389
    79.865    30.137
>
    79.019    30.389
    79.865    30.137
>
    79.673    29.887
    79.870    30.116
>
    79.673    29.887
    79.870    30.116
>
    79.563    30.001
    79.870    30.116
>
    79.563    30.001
    79.870    30.116
>
    80.164    29.905
    79.870    30.116
>
    80.164    29.905
    79.870    30.116
>
    79.595    29.852
    79.870    30.116
>
    79.595    29.852
    79.870    30.116
>
    80.049    29.775
    79.870    30.116
>
    80.049    29.775
    79.870    30.116
>
    80.248    29.803
    79.870    30.116
>
    80.248    29.803
    79.870    30.116
>
    80.040    29.660
    79.870    30.116
>
    80.040    29.660
    79.870    30.116
>
    79.416    29.770
    79.870    30.116
>
    79.416    29.770
    79.870    30.116
>
    79.322    30.406
    79.870    30.116
>
    79.322    30.406
    79.870    30.116
>
    79.648    29.592
    79.870    30.116
>
    79.648    29.592
    79.870    30.116
>
    79.217    30.265
    79.870    30.116
>
    79.217    30.265
    79.870    30.116
>
    80.234    29.552
    79.870    30.116
>
    80.234    29.552
    79.870    30.116
>
    80.544    29.849
    79.870    30.116
>
    80.544    29.849
    79.870    30.116
>
    79.930    29.407
    79.870    30.116
>
    79.930    29.407
    79.870    30.116
>
    80.094    29.403
    79.870    30.116
>
    80.094    29.403
    79.870    30.116
>
    79.019    30.389
    79.870    30.116
>
    79.019    30.389
    79.870    30.116
>
    79.673    29.887
    79.868    30.107
>
    79.673    29.887
    79.868    30.107
>
    79.563    30.001
    79.868    30.107
>
    79.563    30.001
    79.868    30.107
>
    80.164    29.905
    79.868    30.107
>
    80.164    29.905
    79.868    30.107
>
    79.595    29.852
    79.868    30.107
>
    79.595    29.852
    79.868    30.107
>
    80.049    29.775
    79.868    30.107
>
    80.049    29.775
    79.868    30.107
>
    80.248    29.803
    79.868    30.107
>
    80.248    29.803
    79.868    30.107
>
    80.040    29.660
    79.868    30.107
>
    80.040    29.660
    79.868    30.107
>
    79.416    29.770
    79.868    30.107
>
    79.416    29.770
    79.868    30.107
>
    79.648    29.592
    79.868    30.107
>
    79.217    30.265
    79.868    30.107
>
    79.217    30.265
    79.868    30.107
>
    80.234    29.552
    79.868    30.107
>
    80.234    29.552
    79.868    30.107
>
    79.930    29.407
    79.868    30.107
>
    79.930    29.407
    79.868    30.107
>
    80.094    29.403
    79.868    30.107
>
    80.094    29.403
    79.868    30.107
>
    79.019    30.389
    79.132    30.537
>
    79.019    30.389
    79.132    30.537
>
    78.975    30.639
    79.132    30.537
>
    78.975    30.639
    79.132    30.537
>
    79.217    30.265
    79.132    30.537
>
    79.217    30.265
    79.132    30.537
>
    78.640    30.431
    79.132    30.537
>
    78.640    30.431
    79.132    30.537
>
    79.563    30.001
    79.132    30.537
>
    79.563    30.001
    79.132    30.537
>
    79.595    29.852
    79.132    30.537
>
    79.673    29.887
    79.132    30.537
>
    79.673    29.887
    79.132    30.537
>
    80.164    29.905
    80.200    29.869
>
    80.248    29.803
    80.200    29.869
>
    80.248    29.803
    80.200    29.869
>
    80.049    29.775
    80.200    29.869
>
    80.049    29.775
    80.200    29.869
>
    80.040    29.660
    80.200    29.869
>
    80.040    29.660
    80.200    29.869
>
    80.544    29.849
    80.200    29.869
>
    80.544    29.849
    80.200    29.869
>
    80.234    29.552
    80.200    29.869
>
    80.234    29.552
    80.200    29.869
>
    79.673    29.887
    80.200    29.869
>
    79.673    29.887
    80.200    29.869
>
    80.094    29.403
    80.200    29.869
>
    80.094    29.403
    80.200    29.869
>
    79.930    29.407
    80.200    29.869
>
    79.930    29.407
    80.200    29.869
>
    79.595    29.852
    80.200    29.869
>
    79.648    29.592
    80.200    29.869
>
    79.563    30.001
    80.200    29.869
>
    79.563    30.001
    80.200    29.869
>
    79.416    29.770
    80.200    29.869
>
    79.322    30.406
    79.296    30.552
>
    79.322    30.406
    79.296    30.552
>
    79.019    30.389
    79.296    30.552
>
    79.019    30.389
    79.296    30.552
>
    79.217    30.265
    79.296    30.552
>
    79.217    30.265
    79.296    30.552
>
    78.975    30.639
    79.296    30.552
>
    78.975    30.639
    79.296    30.552
>
    78.640    30.431
    79.296    30.552
>
    78.640    30.431
    79.296    30.552
>
    79.563    30.001
    79.296    30.552
>
    79.563    30.001
    79.296    30.552
>
    79.673    29.887
    79.296    30.552
>
    79.673    29.887
    79.296    30.552
>
    79.595    29.852
    79.296    30.552
>
    79.595    29.852
    79.296    30.552
>
    79.416    29.770
    79.296    30.552
>
    79.322    30.406
    79.563    30.297
>
    79.322    30.406
    79.563    30.297
>
    79.563    30.001
    79.563    30.297
>
    79.563    30.001
    79.563    30.297
>
    79.217    30.265
    79.563    30.297
>
    79.217    30.265
    79.563    30.297
>
    79.673    29.887
    79.563    30.297
>
    79.673    29.887
    79.563    30.297
>
    79.595    29.852
    79.563    30.297
>
    79.595    29.852
    79.563    30.297
>
    79.019    30.389
    79.563    30.297
>
    79.019    30.389
    79.563    30.297
>
    79.416    29.770
    79.563    30.297
>
    79.416    29.770
    79.563    30.297
>
    78.975    30.639
    79.563    30.297
>
    78.975    30.639
    79.563    30.297
>
    80.164    29.905
    79.563    30.297
>
    80.049    29.775
    79.563    30.297
>
    80.049    29.775
    79.563    30.297
>
    79.648    29.592
    79.563    30.297
>
    80.040    29.660
    79.563    30.297
>
    80.040    29.660
    79.563    30.297
>
    80.248    29.803
    79.563    30.297
>
    80.234    29.552
    80.364    29.604
>
    80.234    29.552
    80.364    29.604
>
    80.248    29.803
    80.364    29.604
>
    80.248    29.803
    80.364    29.604
>
    80.040    29.660
    80.364    29.604
>
    80.040    29.660
    80.364    29.604
>
    80.544    29.849
    80.364    29.604
>
    80.544    29.849
    80.364    29.604
>
    80.094    29.403
    80.364    29.604
>
    80.094    29.403
    80.364    29.604
>
    80.049    29.775
    80.364    29.604
>
    80.049    29.775
    80.364    29.604
>
    80.164    29.905
    80.364    29.604
>
    80.107    29.330
    80.364    29.604
>
    80.107    29.330
    80.364    29.604
>
    79.930    29.407
    80.364    29.604
>
    79.930    29.407
    80.364    29.604
>
    79.648    29.592
    80.364    29.604
>
    79.673    29.887
    80.364    29.604
>
    79.595    29.852
    80.364    29.604
>
    79.595    29.852
    80.364    29.604
>
    80.164    29.905
    79.974    30.003
>
    80.164    29.905
    79.974    30.003
>
    80.049    29.775
    79.974    30.003
>
    80.049    29.775
    79.974    30.003
>
    79.673    29.887
    79.974    30.003
>
    79.673    29.887
    79.974    30.003
>
    80.248    29.803
    79.974    30.003
>
    80.248    29.803
    79.974    30.003
>
    80.040    29.660
    79.974    30.003
>
    80.040    29.660
    79.974    30.003
>
    79.563    30.001
    79.974    30.003
>
    79.595    29.852
    79.974    30.003
>
    79.595    29.852
    79.974    30.003
>
    80.234    29.552
    79.974    30.003
>
    80.234    29.552
    79.974    30.003
>
    80.544    29.849
    79.974    30.003
>
    79.930    29.407
    79.974    30.003
>
    80.094    29.403
    79.974    30.003
>
    80.094    29.403
    79.974    30.003
>
    80.107    29.330
    79.974    30.003
>
    80.107    29.330
    79.974    30.003
>
    79.217    30.265
    79.974    30.003
>
    79.322    30.406
    79.404    30.379
>
    79.322    30.406
    79.404    30.379
>
    79.217    30.265
    79.404    30.379
>
    79.217    30.265
    79.404    30.379
>
    79.019    30.389
    79.404    30.379
>
    79.019    30.389
    79.404    30.379
>
    79.563    30.001
    79.404    30.379
>
    79.563    30.001
    79.404    30.379
>
    78.975    30.639
    79.404    30.379
>
    78.975    30.639
    79.404    30.379
>
    79.673    29.887
    79.404    30.379
>
    79.673    29.887
    79.404    30.379
>
    79.595    29.852
    79.404    30.379
>
    79.595    29.852
    79.404    30.379
>
    79.416    29.770
    79.404    30.379
>
    79.416    29.770
    79.404    30.379
>
    78.640    30.431
    79.404    30.379
>
    79.563    30.001
    79.831    30.177
>
    79.563    30.001
    79.831    30.177
>
    79.673    29.887
    79.831    30.177
>
    79.673    29.887
    79.831    30.177
>
    79.595    29.852
    79.831    30.177
>
    79.595    29.852
    79.831    30.177
>
    80.164    29.905
    79.831    30.177
>
    80.164    29.905
    79.831    30.177
>
    80.049    29.775
    79.831    30.177
>
    80.049    29.775
    79.831    30.177
>
    79.322    30.406
    79.831    30.177
>
    80.248    29.803
    79.831    30.177
>
    80.248    29.803
    79.831    30.177
>
    79.416    29.770
    79.831    30.177
>
    79.416    29.770
    79.831    30.177
>
    79.217    30.265
    79.831    30.177
>
    79.217    30.265
    79.831    30.177
>
    80.040    29.660
    79.831    30.177
>
    80.040    29.660
    79.831    30.177
>
    79.648    29.592
    79.831    30.177
>
    79.648    29.592
    79.831    30.177
>
    80.544    29.849
    79.831    30.177
>
    80.544    29.849
    79.831    30.177
>
    80.234    29.552
    79.831    30.177
>
    80.234    29.552
    79.831    30.177
>
    79.019    30.389
    79.831    30.177
>
    79.019    30.389
    79.831    30.177
>
    79.930    29.407
    79.831    30.177
>
    79.930    29.407
    79.831    30.177
>
    80.544    29.849
    80.413    29.853
>
    80.544    29.849
    80.413    29.853
>
    80.248    29.803
    80.413    29.853
>
    80.248    29.803
    80.413    29.853
>
    80.164    29.905
    80.413    29.853
>
    80.164    29.905
    80.413    29.853
>
    80.049    29.775
    80.413    29.853
>
    80.049    29.775
    80.413    29.853
>
    80.234    29.552
    80.413    29.853
>
    80.234    29.552
    80.413    29.853
>
    80.040    29.660
    80.413    29.853
>
    80.040    29.660
    80.413    29.853
>
    80.094    29.403
    80.413    29.853
>
    80.094    29.403
    80.413    29.853
>
    79.930    29.407
    80.413    29.853
>
    79.930    29.407
    80.413    29.853
>
    79.673    29.887
    80.413    29.853
>
    79.595    29.852
    80.413    29.853
>
    79.563    30.001
    80.413    29.853
>
    78.056    30.323
    78.772    30.792
>
    78.056    30.323
    78.772    30.792
>
    78.056    30.323
    78.282    30.871
>
    78.056    30.323
    78.282    30.871
>
    79.322    30.406
    79.260    30.582
>
    79.322    30.406
    79.260    30.582
>
    79.566    30.538
    79.260    30.582
>
    79.566    30.538
    79.260    30.582
>
    79.019    30.389
    79.260    30.582
>
    79.019    30.389
    79.260    30.582
>
    79.217    30.265
    79.260    30.582
>
    79.217    30.265
    79.260    30.582
>
    79.416    30.250
    79.260    30.582
>
    79.416    30.250
    79.260    30.582
>
    79.563    30.001
    79.260    30.582
>
    79.673    29.887
    79.260    30.582
>
    79.673    29.887
    79.260    30.582
>
    79.595    29.852
    79.260    30.582
>
    79.595    29.852
    79.260    30.582
>
    80.164    29.905
    80.135    30.017
>
    80.164    29.905
    80.135    30.017
>
    79.900    29.946
    80.135    30.017
>
    80.248    29.803
    80.135    30.017
>
    80.248    29.803
    80.135    30.017
>
    80.049    29.775
    80.135    30.017
>
    80.049    29.775
    80.135    30.017
>
    80.544    29.849
    80.135    30.017
>
    79.673    29.887
    80.135    30.017
>
    79.673    29.887
    80.135    30.017
>
    80.234    29.552
    80.135    30.017
>
    80.234    29.552
    80.135    30.017
>
    79.595    29.852
    80.135    30.017
>
    79.563    30.001
    80.135    30.017
>
    79.648    29.592
    80.135    30.017
>
    79.648    29.592
    80.135    30.017
>
    80.094    29.403
    80.135    30.017
>
    80.094    29.403
    80.135    30.017
>
    79.930    29.407
    80.135    30.017
>
    79.930    29.407
    80.135    30.017
>
    79.416    29.770
    80.135    30.017
>
    79.416    29.770
    80.135    30.017
>
    79.376    30.145
    80.135    30.017
>
    80.107    29.330
    80.135    30.017
>
    78.436    30.721
    78.642    30.753
>
    78.436    30.721
    78.642    30.753
>
    78.975    30.639
    78.642    30.753
>
    78.975    30.639
    78.642    30.753
>
    78.377    30.921
    78.642    30.753
>
    78.377    30.921
    78.642    30.753
>
    78.640    30.431
    78.642    30.753
>
    78.640    30.431
    78.642    30.753
>
    78.330    30.574
    78.642    30.753
>
    78.330    30.574
    78.642    30.753
>
    78.378    30.508
    78.642    30.753
>
    78.378    30.508
    78.642    30.753
>
    78.205    30.808
    78.642    30.753
>
    78.205    30.808
    78.642    30.753
>
    78.429    30.373
    78.642    30.753
>
    78.429    30.373
    78.642    30.753
>
    79.019    30.389
    78.642    30.753
>
    79.019    30.389
    78.642    30.753
>
    78.244    30.427
    78.642    30.753
>
    78.244    30.427
    78.642    30.753
>
    78.103    30.909
    78.642    30.753
>
    78.103    30.909
    78.642    30.753
>
    78.074    30.455
    78.642    30.753
>
    78.074    30.455
    78.642    30.753
>
    78.287    30.161
    78.642    30.753
>
    79.900    29.946
    79.827    30.156
>
    79.900    29.946
    79.827    30.156
>
    79.673    29.887
    79.827    30.156
>
    79.673    29.887
    79.827    30.156
>
    79.416    30.250
    79.827    30.156
>
    79.416    30.250
    79.827    30.156
>
    79.595    29.852
    79.827    30.156
>
    79.595    29.852
    79.827    30.156
>
    79.566    30.538
    79.827    30.156
>
    79.566    30.538
    79.827    30.156
>
    79.322    30.406
    79.827    30.156
>
    79.217    30.265
    79.827    30.156
>
    79.217    30.265
    79.827    30.156
>
    79.648    29.592
    79.827    30.156
>
    79.648    29.592
    79.827    30.156
>
    79.019    30.389
    79.827    30.156
>
    79.019    30.389
    79.827    30.156
>
    80.246    29.450
    79.827    30.156
>
    80.246    29.450
    79.827    30.156
>
    79.322    30.406
    79.191    30.511
>
    79.322    30.406
    79.191    30.511
>
    79.019    30.389
    79.191    30.511
>
    79.019    30.389
    79.191    30.511
>
    79.217    30.265
    79.191    30.511
>
    79.217    30.265
    79.191    30.511
>
    79.416    30.250
    79.191    30.511
>
    79.416    30.250
    79.191    30.511
>
    79.566    30.538
    79.191    30.511
>
    78.436    30.721
    79.191    30.511
>
    78.436    30.721
    79.191    30.511
>
    78.378    30.508
    79.191    30.511
>
    78.378    30.508
    79.191    30.511
>
    79.595    29.852
    79.191    30.511
>
    79.595    29.852
    79.191    30.511
>
    79.673    29.887
    79.191    30.511
>
    79.673    29.887
    79.191    30.511
>
    78.330    30.574
    79.191    30.511
>
    79.019    30.389
    79.093    30.521
>
    79.019    30.389
    79.093    30.521
>
    78.975    30.639
    79.093    30.521
>
    78.975    30.639
    79.093    30.521
>
    79.322    30.406
    79.093    30.521
>
    79.322    30.406
    79.093    30.521
>
    78.640    30.431
    79.093    30.521
>
    78.640    30.431
    79.093    30.521
>
    79.566    30.538
    79.093    30.521
>
    79.376    30.145
    79.093    30.521
>
    79.049    30.019
    79.093    30.521
>
    79.049    30.019
    79.093    30.521
>
    78.429    30.373
    79.093    30.521
>
    78.429    30.373
    79.093    30.521
>
    78.330    30.574
    79.093    30.521
>
    78.330    30.574
    79.093    30.521
>
    78.711    29.924
    79.093    30.521
>
    78.711    29.924
    79.093    30.521
>
    78.244    30.427
    79.093    30.521
>
    78.244    30.427
    79.093    30.521
>
    79.015    29.750
    79.093    30.521
>
    79.015    29.750
    79.093    30.521
>
    78.287    30.161
    79.093    30.521
>
    78.287    30.161
    79.093    30.521
>
    79.416    29.770
    79.093    30.521
>
    79.416    29.770
    79.093    30.521
>
    78.640    30.431
    78.699    30.380
>
    78.640    30.431
    78.699    30.380
>
    78.429    30.373
    78.699    30.380
>
    78.429    30.373
    78.699    30.380
>
    79.019    30.389
    78.699    30.380
>
    79.019    30.389
    78.699    30.380
>
    78.975    30.639
    78.699    30.380
>
    78.975    30.639
    78.699    30.380
>
    78.330    30.574
    78.699    30.380
>
    78.330    30.574
    78.699    30.380
>
    78.244    30.427
    78.699    30.380
>
    78.244    30.427
    78.699    30.380
>
    78.287    30.161
    78.699    30.380
>
    78.287    30.161
    78.699    30.380
>
    78.711    29.924
    78.699    30.380
>
    78.711    29.924
    78.699    30.380
>
    79.049    30.019
    78.699    30.380
>
    79.049    30.019
    78.699    30.380
>
    79.322    30.406
    78.699    30.380
>
    79.322    30.406
    78.699    30.380
>
    78.074    30.455
    78.699    30.380
>
    78.074    30.455
    78.699    30.380
>
    78.205    30.808
    78.699    30.380
>
    79.015    29.750
    78.699    30.380
>
    79.015    29.750
    78.699    30.380
>
    78.103    30.909
    78.699    30.380
>
    78.103    30.909
    78.699    30.380
>
    79.566    30.538
    78.699    30.380
>
    77.873    30.691
    78.699    30.380
>
    79.322    30.406
    79.232    30.451
>
    79.322    30.406
    79.232    30.451
>
    79.019    30.389
    79.232    30.451
>
    79.019    30.389
    79.232    30.451
>
    78.975    30.639
    79.232    30.451
>
    78.975    30.639
    79.232    30.451
>
    79.566    30.538
    79.232    30.451
>
    79.566    30.538
    79.232    30.451
>
    79.376    30.145
    79.232    30.451
>
    79.049    30.019
    79.232    30.451
>
    79.049    30.019
    79.232    30.451
>
    78.640    30.431
    79.232    30.451
>
    78.640    30.431
    79.232    30.451
>
    79.673    29.887
    79.232    30.451
>
    79.673    29.887
    79.232    30.451
>
    78.711    29.924
    79.232    30.451
>
    79.416    29.770
    79.232    30.451
>
    79.416    29.770
    79.232    30.451
>
    78.429    30.373
    79.232    30.451
>
    79.015    29.750
    79.232    30.451
>
    79.015    29.750
    79.232    30.451
>
    79.322    30.406
    79.210    30.448
>
    79.322    30.406
    79.210    30.448
>
    79.019    30.389
    79.210    30.448
>
    79.019    30.389
    79.210    30.448
>
    78.975    30.639
    79.210    30.448
>
    79.566    30.538
    79.210    30.448
>
    79.566    30.538
    79.210    30.448
>
    79.049    30.019
    79.210    30.448
>
    79.049    30.019
    79.210    30.448
>
    78.640    30.431
    79.210    30.448
>
    78.640    30.431
    79.210    30.448
>
    78.711    29.924
    79.210    30.448
>
    78.711    29.924
    79.210    30.448
>
    79.673    29.887
    79.210    30.448
>
    79.416    29.770
    79.210    30.448
>
    79.416    29.770
    79.210    30.448
>
    79.015    29.750
    79.210    30.448
>
    79.015    29.750
    79.210    30.448
>
    78.205    30.808
    78.388    30.839
>
    78.205    30.808
    78.388    30.839
>
    78.330    30.574
    78.388    30.839
>
    78.330    30.574
    78.388    30.839
>
    78.103    30.909
    78.388    30.839
>
    78.103    30.909
    78.388    30.839
>
    78.753    31.036
    78.388    30.839
>
    78.244    30.427
    78.388    30.839
>
    78.244    30.427
    78.388    30.839
>
    78.429    30.373
    78.388    30.839
>
    78.074    30.455
    78.388    30.839
>
    78.074    30.455
    78.388    30.839
>
    77.873    30.691
    78.388    30.839
>
    77.873    30.691
    78.388    30.839
>
    77.845    30.934
    78.388    30.839
>
    77.845    30.934
    78.388    30.839
>
    79.019    30.389
    78.388    30.839
>
    79.019    30.389
    78.388    30.839
>
    79.322    30.406
    79.194    30.446
>
    79.322    30.406
    79.194    30.446
>
    79.019    30.389
    79.194    30.446
>
    79.019    30.389
    79.194    30.446
>
    79.217    30.265
    79.194    30.446
>
    79.217    30.265
    79.194    30.446
>
    78.975    30.639
    79.194    30.446
>
    79.566    30.538
    79.194    30.446
>
    79.566    30.538
    79.194    30.446
>
    79.049    30.019
    79.194    30.446
>
    79.049    30.019
    79.194    30.446
>
    78.640    30.431
    79.194    30.446
>
    78.640    30.431
    79.194    30.446
>
    78.711    29.924
    79.194    30.446
>
    78.429    30.373
    79.194    30.446
>
    78.429    30.373
    79.194    30.446
>
    79.595    29.852
    79.194    30.446
>
    79.595    29.852
    79.194    30.446
>
    79.673    29.887
    79.194    30.446
>
    79.673    29.887
    79.194    30.446
>
    79.416    29.770
    79.194    30.446
>
    79.416    29.770
    79.194    30.446
>
    79.015    29.750
    79.194    30.446
>
    79.015    29.750
    79.194    30.446
>
    78.680    29.839
    79.194    30.446
>
    78.680    29.839
    79.194    30.446
>
    78.436    30.721
    78.635    30.737
>
    78.436    30.721
    78.635    30.737
>
    78.975    30.639
    78.635    30.737
>
    78.975    30.639
    78.635    30.737
>
    78.640    30.431
    78.635    30.737
>
    78.377    30.921
    78.635    30.737
>
    78.377    30.921
    78.635    30.737
>
    78.330    30.574
    78.635    30.737
>
    78.330    30.574
    78.635    30.737
>
    78.753    31.036
    78.635    30.737
>
    78.753    31.036
    78.635    30.737
>
    78.205    30.808
    78.635    30.737
>
    78.205    30.808
    78.635    30.737
>
    78.429    30.373
    78.635    30.737
>
    78.429    30.373
    78.635    30.737
>
    78.244    30.427
    78.635    30.737
>
    78.244    30.427
    78.635    30.737
>
    79.019    30.389
    78.635    30.737
>
    79.019    30.389
    78.635    30.737
>
    78.103    30.909
    78.635    30.737
>
    78.103    30.909
    78.635    30.737
>
    78.074    30.455
    78.635    30.737
>
    78.074    30.455
    78.635    30.737
>
    78.287    30.161
    78.635    30.737
>
    78.287    30.161
    78.635    30.737
>
    79.322    30.406
    78.635    30.737
>
    79.217    30.265
    78.635    30.737
>
    79.217    30.265
    78.635    30.737
>
    77.873    30.691
    78.635    30.737
>
    77.873    30.691
    78.635    30.737
>
    77.845    30.934
    78.635    30.737
>
    77.845    30.934
    78.635    30.737
>
    79.049    30.019
    78.635    30.737
>
    78.056    30.323
    78.635    30.737
>
    79.322    30.406
    79.190    30.443
>
    79.019    30.389
    79.190    30.443
>
    79.019    30.389
    79.190    30.443
>
    79.217    30.265
    79.190    30.443
>
    79.217    30.265
    79.190    30.443
>
    78.975    30.639
    79.190    30.443
>
    78.975    30.639
    79.190    30.443
>
    79.376    30.145
    79.190    30.443
>
    79.566    30.538
    79.190    30.443
>
    78.640    30.431
    79.190    30.443
>
    79.563    30.001
    79.190    30.443
>
    79.563    30.001
    79.190    30.443
>
    79.595    29.852
    79.190    30.443
>
    79.673    29.887
    79.190    30.443
>
    79.673    29.887
    79.190    30.443
>
    79.416    29.770
    79.190    30.443
>
    79.416    29.770
    79.190    30.443
>
    79.015    29.750
    79.190    30.443
>
    79.015    29.750
    79.190    30.443
>
    78.436    30.721
    79.190    30.443
>
    78.680    29.839
    79.190    30.443
>
    78.330    30.574
    79.190    30.443
>
    78.330    30.574
    79.190    30.443
>
    79.900    29.946
    79.190    30.443
>
    78.711    29.924
    78.822    29.893
>
    78.711    29.924
    78.822    29.893
>
    79.049    30.019
    78.822    29.893
>
    79.015    29.750
    78.822    29.893
>
    79.015    29.750
    78.822    29.893
>
    79.019    30.389
    78.822    29.893
>
    79.019    30.389
    78.822    29.893
>
    79.416    29.770
    78.822    29.893
>
    79.416    29.770
    78.822    29.893
>
    78.287    30.161
    78.822    29.893
>
    78.287    30.161
    78.822    29.893
>
    78.640    30.431
    78.822    29.893
>
    78.640    30.431
    78.822    29.893
>
    78.429    30.373
    78.822    29.893
>
    78.429    30.373
    78.822    29.893
>
    78.244    30.427
    78.822    29.893
>
    78.244    30.427
    78.822    29.893
>
    79.673    29.887
    78.822    29.893
>
    78.975    30.639
    78.822    29.893
>
    78.975    30.639
    78.822    29.893
>
    79.457    29.359
    78.822    29.893
>
    78.074    30.455
    77.974    30.534
>
    78.074    30.455
    77.974    30.534
>
    77.873    30.691
    77.974    30.534
>
    77.873    30.691
    77.974    30.534
>
    78.244    30.427
    77.974    30.534
>
    78.244    30.427
    77.974    30.534
>
    78.330    30.574
    77.974    30.534
>
    78.205    30.808
    77.974    30.534
>
    78.205    30.808
    77.974    30.534
>
    78.103    30.909
    77.974    30.534
>
    78.103    30.909
    77.974    30.534
>
    78.429    30.373
    77.974    30.534
>
    78.429    30.373
    77.974    30.534
>
    77.845    30.934
    77.974    30.534
>
    77.845    30.934
    77.974    30.534
>
    78.287    30.161
    77.974    30.534
>
    78.640    30.431
    77.974    30.534
>
    78.205    30.808
    78.398    30.844
>
    78.205    30.808
    78.398    30.844
>
    78.330    30.574
    78.398    30.844
>
    78.330    30.574
    78.398    30.844
>
    78.103    30.909
    78.398    30.844
>
    78.103    30.909
    78.398    30.844
>
    78.753    31.036
    78.398    30.844
>
    78.753    31.036
    78.398    30.844
>
    78.244    30.427
    78.398    30.844
>
    78.244    30.427
    78.398    30.844
>
    78.640    30.431
    78.398    30.844
>
    78.640    30.431
    78.398    30.844
>
    78.429    30.373
    78.398    30.844
>
    78.429    30.373
    78.398    30.844
>
    78.074    30.455
    78.398    30.844
>
    78.074    30.455
    78.398    30.844
>
    77.873    30.691
    78.398    30.844
>
    77.845    30.934
    78.398    30.844
>
    78.975    30.639
    78.398    30.844
>
    78.975    30.639
    78.398    30.844
>
    78.975    30.639
    78.398    30.844
>
    79.019    30.389
    78.398    30.844
>
    78.287    30.161
    78.398    30.844
>
    78.287    30.161
    78.398    30.844
>
    78.711    29.924
    78.530    30.061
>
    78.711    29.924
    78.530    30.061
>
    78.287    30.161
    78.530    30.061
>
    78.287    30.161
    78.530    30.061
>
    78.429    30.373
    78.530    30.061
>
    78.429    30.373
    78.530    30.061
>
    78.640    30.431
    78.530    30.061
>
    78.640    30.431
    78.530    30.061
>
    78.244    30.427
    78.530    30.061
>
    78.244    30.427
    78.530    30.061
>
    79.015    29.750
    78.530    30.061
>
    79.019    30.389
    78.530    30.061
>
    79.019    30.389
    78.530    30.061
>
    78.330    30.574
    78.530    30.061
>
    78.330    30.574
    78.530    30.061
>
    78.975    30.639
    78.530    30.061
>
    78.975    30.639
    78.530    30.061
>
    78.205    30.808
    78.530    30.061
>
    78.205    30.808
    78.530    30.061
>
    78.377    30.921
    78.354    30.895
>
    78.377    30.921
    78.354    30.895
>
    78.205    30.808
    78.354    30.895
>
    78.205    30.808
    78.354    30.895
>
    78.330    30.574
    78.354    30.895
>
    78.330    30.574
    78.354    30.895
>
    78.753    31.036
    78.354    30.895
>
    78.753    31.036
    78.354    30.895
>
    78.378    30.508
    78.354    30.895
>
    78.378    30.508
    78.354    30.895
>
    78.244    30.427
    78.354    30.895
>
    78.244    30.427
    78.354    30.895
>
    77.873    30.691
    78.354    30.895
>
    79.019    30.389
    78.354    30.895
>
    79.019    30.389
    78.354    30.895
>
    78.436    30.721
    78.635    30.711
>
    78.436    30.721
    78.635    30.711
>
    78.640    30.431
    78.635    30.711
>
    78.640    30.431
    78.635    30.711
>
    78.378    30.508
    78.635    30.711
>
    78.378    30.508
    78.635    30.711
>
    78.330    30.574
    78.635    30.711
>
    78.330    30.574
    78.635    30.711
>
    78.753    31.036
    78.635    30.711
>
    78.753    31.036
    78.635    30.711
>
    78.205    30.808
    78.635    30.711
>
    78.205    30.808
    78.635    30.711
>
    79.019    30.389
    78.635    30.711
>
    78.244    30.427
    78.635    30.711
>
    78.244    30.427
    78.635    30.711
>
    78.103    30.909
    78.635    30.711
>
    78.103    30.909
    78.635    30.711
>
    78.074    30.455
    78.635    30.711
>
    78.074    30.455
    78.635    30.711
>
    78.287    30.161
    78.635    30.711
>
    78.287    30.161
    78.635    30.711
>
    79.322    30.406
    78.635    30.711
>
    79.322    30.406
    78.635    30.711
>
    79.217    30.265
    78.635    30.711
>
    77.873    30.691
    78.635    30.711
>
    77.873    30.691
    78.635    30.711
>
    77.843    30.518
    78.635    30.711
>
    77.843    30.518
    78.635    30.711
>
    79.900    29.946
    79.964    30.023
>
    79.900    29.946
    79.964    30.023
>
    80.164    29.905
    79.964    30.023
>
    80.164    29.905
    79.964    30.023
>
    79.673    29.887
    79.964    30.023
>
    79.673    29.887
    79.964    30.023
>
    80.248    29.803
    79.964    30.023
>
    79.563    30.001
    79.964    30.023
>
    79.563    30.001
    79.964    30.023
>
    80.040    29.660
    79.964    30.023
>
    80.040    29.660
    79.964    30.023
>
    79.648    29.592
    79.964    30.023
>
    79.648    29.592
    79.964    30.023
>
    79.416    30.250
    79.964    30.023
>
    79.416    30.250
    79.964    30.023
>
    79.416    29.770
    79.964    30.023
>
    79.416    29.770
    79.964    30.023
>
    80.544    29.849
    79.964    30.023
>
    80.544    29.849
    79.964    30.023
>
    79.288    30.051
    79.964    30.023
>
    79.288    30.051
    79.964    30.023
>
    80.094    29.403
    79.964    30.023
>
    80.094    29.403
    79.964    30.023
>
    79.566    30.538
    79.964    30.023
>
    79.566    30.538
    79.964    30.023
>
    79.322    30.406
    79.964    30.023
>
    79.322    30.406
    79.964    30.023
>
    79.217    30.265
    79.964    30.023
>
    79.217    30.265
    79.964    30.023
>
    79.547    29.355
    79.964    30.023
>
    78.436    30.721
    78.374    30.870
>
    78.436    30.721
    78.374    30.870
>
    78.205    30.808
    78.374    30.870
>
    78.205    30.808
    78.374    30.870
>
    78.103    30.909
    78.374    30.870
>
    78.103    30.909
    78.374    30.870
>
    78.330    30.574
    78.374    30.870
>
    78.330    30.574
    78.374    30.870
>
    78.753    31.036
    78.374    30.870
>
    78.753    31.036
    78.374    30.870
>
    78.378    30.508
    78.374    30.870
>
    78.378    30.508
    78.374    30.870
>
    78.244    30.427
    78.374    30.870
>
    78.244    30.427
    78.374    30.870
>
    78.640    30.431
    78.374    30.870
>
    78.640    30.431
    78.374    30.870
>
    77.873    30.691
    78.374    30.870
>
    77.873    30.691
    78.374    30.870
>
    78.074    30.455
    78.374    30.870
>
    78.074    30.455
    78.374    30.870
>
    78.287    30.161
    78.374    30.870
>
    78.287    30.161
    78.374    30.870
>
    79.019    30.389
    78.374    30.870
>
    79.019    30.389
    78.374    30.870
>
    78.377    30.921
    78.333    30.833
>
    78.377    30.921
    78.333    30.833
>
    78.205    30.808
    78.333    30.833
>
    78.205    30.808
    78.333    30.833
>
    78.436    30.721
    78.333    30.833
>
    78.103    30.909
    78.333    30.833
>
    78.330    30.574
    78.333    30.833
>
    78.330    30.574
    78.333    30.833
>
    78.378    30.508
    78.333    30.833
>
    78.378    30.508
    78.333    30.833
>
    78.753    31.036
    78.333    30.833
>
    78.244    30.427
    78.333    30.833
>
    77.873    30.691
    78.333    30.833
>
    77.873    30.691
    78.333    30.833
>
    77.845    30.934
    78.333    30.833
>
    78.074    30.455
    78.333    30.833
>
    78.074    30.455
    78.333    30.833
>
    78.640    30.431
    78.333    30.833
>
    78.640    30.431
    78.333    30.833
>
    77.843    30.518
    78.333    30.833
>
    78.287    30.161
    78.333    30.833
>
    78.287    30.161
    78.333    30.833
>
    79.019    30.389
    78.333    30.833
>
    79.019    30.389
    78.333    30.833
>
    78.975    30.639
    78.999    30.669
>
    78.975    30.639
    78.999    30.669
>
    79.019    30.389
    78.999    30.669
>
    79.019    30.389
    78.999    30.669
>
    78.640    30.431
    78.999    30.669
>
    78.640    30.431
    78.999    30.669
>
    78.753    31.036
    78.999    30.669
>
    78.753    31.036
    78.999    30.669
>
    79.416    30.250
    78.999    30.669
>
    78.378    30.508
    78.999    30.669
>
    78.378    30.508
    78.999    30.669
>
    78.330    30.574
    78.999    30.669
>
    78.330    30.574
    78.999    30.669
>
    79.288    30.051
    78.999    30.669
>
    78.975    30.639
    79.187    30.600
>
    78.975    30.639
    79.187    30.600
>
    79.322    30.406
    79.187    30.600
>
    79.322    30.406
    79.187    30.600
>
    79.019    30.389
    79.187    30.600
>
    79.019    30.389
    79.187    30.600
>
    79.566    30.538
    79.187    30.600
>
    79.566    30.538
    79.187    30.600
>
    79.416    30.250
    79.187    30.600
>
    79.416    30.250
    79.187    30.600
>
    78.640    30.431
    79.187    30.600
>
    78.640    30.431
    79.187    30.600
>
    79.288    30.051
    79.187    30.600
>
    79.288    30.051
    79.187    30.600
>
    79.563    30.001
    79.187    30.600
>
    78.378    30.508
    79.187    30.600
>
    78.378    30.508
    79.187    30.600
>
    80.248    29.803
    80.209    29.816
>
    80.248    29.803
    80.209    29.816
>
    80.040    29.660
    80.209    29.816
>
    80.040    29.660
    80.209    29.816
>
    79.648    29.592
    80.209    29.816
>
    79.648    29.592
    80.209    29.816
>
    79.563    30.001
    80.209    29.816
>
    79.416    29.770
    80.209    29.816
>
    79.416    29.770
    80.209    29.816
>
    78.377    30.921
    78.372    30.823
>
    78.377    30.921
    78.372    30.823
>
    78.205    30.808
    78.372    30.823
>
    78.330    30.574
    78.372    30.823
>
    78.330    30.574
    78.372    30.823
>
    78.378    30.508
    78.372    30.823
>
    78.244    30.427
    78.372    30.823
>
    78.244    30.427
    78.372    30.823
>
    78.640    30.431
    78.372    30.823
>
    78.429    30.373
    78.372    30.823
>
    78.074    30.455
    78.372    30.823
>
    78.074    30.455
    78.372    30.823
>
    77.873    30.691
    78.372    30.823
>
    77.873    30.691
    78.372    30.823
>
    77.843    30.518
    78.372    30.823
>
    77.843    30.518
    78.372    30.823
>
    78.287    30.161
    78.372    30.823
>
    78.287    30.161
    78.372    30.823
>
    79.322    30.406
    79.332    30.557
>
    79.566    30.538
    79.332    30.557
>
    79.566    30.538
    79.332    30.557
>
    79.019    30.389
    79.332    30.557
>
    79.019    30.389
    79.332    30.557
>
    79.416    30.250
    79.332    30.557
>
    78.975    30.639
    79.332    30.557
>
    78.975    30.639
    79.332    30.557
>
    79.376    30.145
    79.332    30.557
>
    79.376    30.145
    79.332    30.557
>
    79.288    30.051
    79.332    30.557
>
    79.288    30.051
    79.332    30.557
>
    79.563    30.001
    79.332    30.557
>
    79.563    30.001
    79.332    30.557
>
    78.640    30.431
    79.332    30.557
>
    78.640    30.431
    79.332    30.557
>
    79.673    29.887
    79.332    30.557
>
    79.673    29.887
    79.332    30.557
>
    79.595    29.852
    79.332    30.557
>
    79.595    29.852
    79.332    30.557
>
    79.416    29.770
    79.332    30.557
>
    79.416    29.770
    79.332    30.557
>
    79.900    29.946
    79.332    30.557
>
    78.205    30.808
    78.192    30.906
>
    78.205    30.808
    78.192    30.906
>
    78.103    30.909
    78.192    30.906
>
    78.103    30.909
    78.192    30.906
>
    78.377    30.921
    78.192    30.906
>
    78.377    30.921
    78.192    30.906
>
    78.330    30.574
    78.192    30.906
>
    78.330    30.574
    78.192    30.906
>
    77.845    30.934
    78.192    30.906
>
    77.845    30.934
    78.192    30.906
>
    77.873    30.691
    78.192    30.906
>
    77.873    30.691
    78.192    30.906
>
    78.378    30.508
    78.192    30.906
>
    78.378    30.508
    78.192    30.906
>
    78.074    30.455
    78.192    30.906
>
    78.074    30.455
    78.192    30.906
>
    78.244    30.427
    78.192    30.906
>
    78.244    30.427
    78.192    30.906
>
    78.753    31.036
    78.192    30.906
>
    77.843    30.518
    78.192    30.906
>
    77.843    30.518
    78.192    30.906
>
    78.429    30.373
    78.192    30.906
>
    78.429    30.373
    78.192    30.906
>
    78.640    30.431
    78.192    30.906
>
    78.640    30.431
    78.192    30.906
>
    78.975    30.639
    78.192    30.906
>
    78.287    30.161
    78.192    30.906
>
    78.287    30.161
    78.192    30.906
>
    78.056    30.323
    78.192    30.906
>
    78.056    30.323
    78.192    30.906
>
    80.238    30.066
    80.281    30.024
>
    80.238    30.066
    80.281    30.024
>
    80.164    29.905
    80.281    30.024
>
    80.164    29.905
    80.281    30.024
>
    80.248    29.803
    80.281    30.024
>
    80.248    29.803
    80.281    30.024
>
    80.544    29.849
    80.281    30.024
>
    80.544    29.849
    80.281    30.024
>
    80.049    29.775
    80.281    30.024
>
    80.049    29.775
    80.281    30.024
>
    79.900    29.946
    80.281    30.024
>
    79.900    29.946
    80.281    30.024
>
    80.040    29.660
    80.281    30.024
>
    80.040    29.660
    80.281    30.024
>
    80.234    29.552
    80.281    30.024
>
    80.234    29.552
    80.281    30.024
>
    79.673    29.887
    80.281    30.024
>
    79.673    29.887
    80.281    30.024
>
    79.595    29.852
    80.281    30.024
>
    79.595    29.852
    80.281    30.024
>
    79.563    30.001
    80.281    30.024
>
    79.563    30.001
    80.281    30.024
>
    80.094    29.403
    80.281    30.024
>
    80.094    29.403
    80.281    30.024
>
    79.930    29.407
    80.281    30.024
>
    79.648    29.592
    80.281    30.024
>
    80.107    29.330
    80.281    30.024
>
    80.107    29.330
    80.281    30.024
>
    79.416    30.250
    80.281    30.024
>
    79.376    30.145
    80.281    30.024
>
    79.416    29.770
    80.281    30.024
>
    79.416    29.770
    80.281    30.024
>
    78.377    30.921
    78.507    30.762
>
    78.330    30.574
    78.507    30.762
>
    78.330    30.574
    78.507    30.762
>
    78.378    30.508
    78.507    30.762
>
    78.378    30.508
    78.507    30.762
>
    78.640    30.431
    78.507    30.762
>
    78.640    30.431
    78.507    30.762
>
    78.753    31.036
    78.507    30.762
>
    78.753    31.036
    78.507    30.762
>
    78.975    30.639
    78.507    30.762
>
    78.975    30.639
    78.507    30.762
>
    78.244    30.427
    78.507    30.762
>
    78.244    30.427
    78.507    30.762
>
    78.074    30.455
    78.507    30.762
>
    78.074    30.455
    78.507    30.762
>
    79.019    30.389
    78.507    30.762
>
    79.019    30.389
    78.507    30.762
>
    77.873    30.691
    78.507    30.762
>
    77.873    30.691
    78.507    30.762
>
    78.975    30.639
    78.625    30.765
>
    78.975    30.639
    78.625    30.765
>
    78.640    30.431
    78.625    30.765
>
    78.640    30.431
    78.625    30.765
>
    78.330    30.574
    78.625    30.765
>
    78.378    30.508
    78.625    30.765
>
    78.378    30.508
    78.625    30.765
>
    78.205    30.808
    78.625    30.765
>
    78.205    30.808
    78.625    30.765
>
    78.429    30.373
    78.625    30.765
>
    78.429    30.373
    78.625    30.765
>
    78.244    30.427
    78.625    30.765
>
    78.244    30.427
    78.625    30.765
>
    79.019    30.389
    78.625    30.765
>
    79.019    30.389
    78.625    30.765
>
    78.103    30.909
    78.625    30.765
>
    78.103    30.909
    78.625    30.765
>
    78.074    30.455
    78.625    30.765
>
    78.074    30.455
    78.625    30.765
>
    78.640    30.431
    78.734    30.412
>
    79.019    30.389
    78.734    30.412
>
    79.019    30.389
    78.734    30.412
>
    78.429    30.373
    78.734    30.412
>
    78.429    30.373
    78.734    30.412
>
    78.975    30.639
    78.734    30.412
>
    78.975    30.639
    78.734    30.412
>
    78.378    30.508
    78.734    30.412
>
    78.378    30.508
    78.734    30.412
>
    78.330    30.574
    78.734    30.412
>
    78.244    30.427
    78.734    30.412
>
    78.244    30.427
    78.734    30.412
>
    78.287    30.161
    78.734    30.412
>
    78.711    29.924
    78.734    30.412
>
    78.711    29.924
    78.734    30.412
>
    79.416    30.250
    78.734    30.412
>
    77.873    30.691
    78.734    30.412
>
    77.873    30.691
    78.734    30.412
>
    80.238    30.066
    80.244    29.985
>
    80.238    30.066
    80.244    29.985
>
    80.164    29.905
    80.244    29.985
>
    80.164    29.905
    80.244    29.985
>
    80.248    29.803
    80.244    29.985
>
    80.248    29.803
    80.244    29.985
>
    80.049    29.775
    80.244    29.985
>
    80.049    29.775
    80.244    29.985
>
    80.544    29.849
    80.244    29.985
>
    79.900    29.946
    80.244    29.985
>
    80.040    29.660
    80.244    29.985
>
    80.040    29.660
    80.244    29.985
>
    80.234    29.552
    80.244    29.985
>
    80.234    29.552
    80.244    29.985
>
    80.094    29.403
    80.244    29.985
>
    80.094    29.403
    80.244    29.985
>
    80.107    29.330
    80.244    29.985
>
    80.107    29.330
    80.244    29.985
>
    79.322    30.406
    79.438    30.499
>
    79.322    30.406
    79.438    30.499
>
    79.566    30.538
    79.438    30.499
>
    79.566    30.538
    79.438    30.499
>
    79.416    30.250
    79.438    30.499
>
    79.416    30.250
    79.438    30.499
>
    79.376    30.145
    79.438    30.499
>
    79.376    30.145
    79.438    30.499
>
    79.019    30.389
    79.438    30.499
>
    79.019    30.389
    79.438    30.499
>
    78.975    30.639
    79.438    30.499
>
    78.975    30.639
    79.438    30.499
>
    79.288    30.051
    79.438    30.499
>
    79.563    30.001
    79.438    30.499
>
    79.563    30.001
    79.438    30.499
>
    79.673    29.887
    79.438    30.499
>
    79.673    29.887
    79.438    30.499
>
    79.595    29.852
    79.438    30.499
>
    79.595    29.852
    79.438    30.499
>
    79.900    29.946
    79.438    30.499
>
    79.900    29.946
    79.438    30.499
>
    79.416    29.770
    79.438    30.499
>
    79.416    29.770
    79.438    30.499
>
    78.377    30.921
    78.260    30.887
>
    78.377    30.921
    78.260    30.887
>
    78.205    30.808
    78.260    30.887
>
    78.205    30.808
    78.260    30.887
>
    78.103    30.909
    78.260    30.887
>
    78.103    30.909
    78.260    30.887
>
    78.330    30.574
    78.260    30.887
>
    78.330    30.574
    78.260    30.887
>
    78.378    30.508
    78.260    30.887
>
    78.378    30.508
    78.260    30.887
>
    77.873    30.691
    78.260    30.887
>
    77.873    30.691
    78.260    30.887
>
    78.244    30.427
    78.260    30.887
>
    78.074    30.455
    78.260    30.887
>
    78.074    30.455
    78.260    30.887
>
    78.429    30.373
    78.260    30.887
>
    77.843    30.518
    78.260    30.887
>
    77.843    30.518
    78.260    30.887
>
    78.975    30.639
    78.260    30.887
>
    79.019    30.389
    79.144    30.523
>
    79.322    30.406
    79.144    30.523
>
    79.322    30.406
    79.144    30.523
>
    78.975    30.639
    79.144    30.523
>
    78.975    30.639
    79.144    30.523
>
    79.416    30.250
    79.144    30.523
>
    79.416    30.250
    79.144    30.523
>
    78.429    30.373
    79.144    30.523
>
    78.378    30.508
    79.144    30.523
>
    78.378    30.508
    79.144    30.523
>
    78.330    30.574
    79.144    30.523
>
    78.330    30.574
    79.144    30.523
>
    79.015    29.750
    79.144    30.523
>
    79.595    29.852
    79.144    30.523
>
    79.595    29.852
    79.144    30.523
>
    79.673    29.887
    79.144    30.523
>
    79.673    29.887
    79.144    30.523
>
    78.244    30.427
    79.144    30.523
>
    78.378    30.508
    78.356    30.465
>
    78.378    30.508
    78.356    30.465
>
    78.330    30.574
    78.356    30.465
>
    78.330    30.574
    78.356    30.465
>
    78.429    30.373
    78.356    30.465
>
    78.429    30.373
    78.356    30.465
>
    78.244    30.427
    78.356    30.465
>
    78.244    30.427
    78.356    30.465
>
    78.640    30.431
    78.356    30.465
>
    78.640    30.431
    78.356    30.465
>
    78.074    30.455
    78.356    30.465
>
    78.074    30.455
    78.356    30.465
>
    78.287    30.161
    78.356    30.465
>
    78.287    30.161
    78.356    30.465
>
    78.205    30.808
    78.356    30.465
>
    78.377    30.921
    78.356    30.465
>
    78.377    30.921
    78.356    30.465
>
    77.843    30.518
    78.356    30.465
>
    77.873    30.691
    78.356    30.465
>
    77.873    30.691
    78.356    30.465
>
    78.975    30.639
    78.356    30.465
>
    78.975    30.639
    78.356    30.465
>
    79.019    30.389
    78.356    30.465
>
    79.019    30.389
    78.356    30.465
>
    79.416    30.250
    79.533    30.386
>
    79.416    30.250
    79.533    30.386
>
    79.566    30.538
    79.533    30.386
>
    79.566    30.538
    79.533    30.386
>
    79.322    30.406
    79.533    30.386
>
    79.322    30.406
    79.533    30.386
>
    79.217    30.265
    79.533    30.386
>
    79.217    30.265
    79.533    30.386
>
    79.563    30.001
    79.533    30.386
>
    79.563    30.001
    79.533    30.386
>
    79.288    30.051
    79.533    30.386
>
    79.288    30.051
    79.533    30.386
>
    79.019    30.389
    79.533    30.386
>
    79.019    30.389
    79.533    30.386
>
    79.673    29.887
    79.533    30.386
>
    79.673    29.887
    79.533    30.386
>
    79.595    29.852
    79.533    30.386
>
    79.595    29.852
    79.533    30.386
>
    78.975    30.639
    79.533    30.386
>
    79.416    29.770
    79.533    30.386
>
    79.416    29.770
    79.533    30.386
>
    80.049    29.775
    79.533    30.386
>
    80.049    29.775
    79.533    30.386
>
    79.416    30.250
    79.530    30.400
>
    79.416    30.250
    79.530    30.400
>
    79.566    30.538
    79.530    30.400
>
    79.566    30.538
    79.530    30.400
>
    79.322    30.406
    79.530    30.400
>
    79.322    30.406
    79.530    30.400
>
    79.376    30.145
    79.530    30.400
>
    79.376    30.145
    79.530    30.400
>
    79.217    30.265
    79.530    30.400
>
    79.217    30.265
    79.530    30.400
>
    79.563    30.001
    79.530    30.400
>
    79.563    30.001
    79.530    30.400
>
    79.288    30.051
    79.530    30.400
>
    79.288    30.051
    79.530    30.400
>
    79.673    29.887
    79.530    30.400
>
    79.673    29.887
    79.530    30.400
>
    79.595    29.852
    79.530    30.400
>
    79.595    29.852
    79.530    30.400
>
    78.975    30.639
    79.530    30.400
>
    79.416    29.770
    79.530    30.400
>
    79.416    29.770
    79.530    30.400
>
    80.164    29.905
    79.530    30.400
>
    80.164    29.905
    79.530    30.400
>
    79.015    29.750
    79.530    30.400
>
    79.015    29.750
    79.530    30.400
>
    80.544    29.849
    80.423    29.842
>
    80.544    29.849
    80.423    29.842
>
    80.248    29.803
    80.423    29.842
>
    80.248    29.803
    80.423    29.842
>
    80.164    29.905
    80.423    29.842
>
    80.164    29.905
    80.423    29.842
>
    80.238    30.066
    80.423    29.842
>
    80.238    30.066
    80.423    29.842
>
    80.234    29.552
    80.423    29.842
>
    80.234    29.552
    80.423    29.842
>
    80.049    29.775
    80.423    29.842
>
    80.049    29.775
    80.423    29.842
>
    80.040    29.660
    80.423    29.842
>
    80.040    29.660
    80.423    29.842
>
    80.094    29.403
    80.423    29.842
>
    80.094    29.403
    80.423    29.842
>
    80.107    29.330
    80.423    29.842
>
    80.107    29.330
    80.423    29.842
>
    79.930    29.407
    80.423    29.842
>
    79.930    29.407
    80.423    29.842
>
    78.975    30.639
    79.141    30.587
>
    78.975    30.639
    79.141    30.587
>
    79.019    30.389
    79.141    30.587
>
    79.019    30.389
    79.141    30.587
>
    79.322    30.406
    79.141    30.587
>
    79.322    30.406
    79.141    30.587
>
    79.217    30.265
    79.141    30.587
>
    79.217    30.265
    79.141    30.587
>
    79.566    30.538
    79.141    30.587
>
    79.416    30.250
    79.141    30.587
>
    79.416    30.250
    79.141    30.587
>
    78.640    30.431
    79.141    30.587
>
    78.640    30.431
    79.141    30.587
>
    79.376    30.145
    79.141    30.587
>
    79.376    30.145
    79.141    30.587
>
    78.753    31.036
    79.141    30.587
>
    78.429    30.373
    79.141    30.587
>
    78.429    30.373
    79.141    30.587
>
    78.378    30.508
    79.141    30.587
>
    78.378    30.508
    79.141    30.587
>
    79.563    30.001
    79.141    30.587
>
    79.563    30.001
    79.141    30.587
>
    78.330    30.574
    79.141    30.587
>
    78.330    30.574
    79.141    30.587
>
    78.377    30.921
    79.141    30.587
>
    78.377    30.921
    79.141    30.587
>
    78.711    29.924
    79.141    30.587
>
    78.711    29.924
    79.141    30.587
>
    78.244    30.427
    79.141    30.587
>
    78.244    30.427
    79.141    30.587
>
    78.377    30.921
    78.298    30.871
>
    78.377    30.921
    78.298    30.871
>
    78.205    30.808
    78.298    30.871
>
    78.205    30.808
    78.298    30.871
>
    78.103    30.909
    78.298    30.871
>
    78.103    30.909
    78.298    30.871
>
    77.845    30.934
    78.298    30.871
>
    77.873    30.691
    78.298    30.871
>
    77.873    30.691
    78.298    30.871
>
    78.244    30.427
    78.298    30.871
>
    78.244    30.427
    78.298    30.871
>
    78.074    30.455
    78.298    30.871
>
    78.074    30.455
    78.298    30.871
>
    78.429    30.373
    78.298    30.871
>
    78.429    30.373
    78.298    30.871
>
    78.640    30.431
    78.298    30.871
>
    78.640    30.431
    78.298    30.871
>
    77.843    30.518
    78.298    30.871
>
    77.843    30.518
    78.298    30.871
>
    78.975    30.639
    78.298    30.871
>
    79.019    30.389
    78.298    30.871
>
    80.248    29.803
    80.375    29.901
>
    80.248    29.803
    80.375    29.901
>
    80.544    29.849
    80.375    29.901
>
    80.544    29.849
    80.375    29.901
>
    80.164    29.905
    80.375    29.901
>
    80.164    29.905
    80.375    29.901
>
    80.238    30.066
    80.375    29.901
>
    80.238    30.066
    80.375    29.901
>
    80.049    29.775
    80.375    29.901
>
    80.049    29.775
    80.375    29.901
>
    80.234    29.552
    80.375    29.901
>
    80.234    29.552
    80.375    29.901
>
    80.040    29.660
    80.375    29.901
>
    80.040    29.660
    80.375    29.901
>
    79.900    29.946
    80.375    29.901
>
    80.094    29.403
    80.375    29.901
>
    80.094    29.403
    80.375    29.901
>
    80.107    29.330
    80.375    29.901
>
    80.107    29.330
    80.375    29.901
>
    79.930    29.407
    80.375    29.901
>
    79.930    29.407
    80.375    29.901
>
    79.673    29.887
    79.743    29.930
>
    79.673    29.887
    79.743    29.930
>
    79.900    29.946
    79.743    29.930
>
    79.900    29.946
    79.743    29.930
>
    79.595    29.852
    79.743    29.930
>
    79.595    29.852
    79.743    29.930
>
    79.563    30.001
    79.743    29.930
>
    79.563    30.001
    79.743    29.930
>
    80.049    29.775
    79.743    29.930
>
    80.049    29.775
    79.743    29.930
>
    79.416    29.770
    79.743    29.930
>
    79.416    29.770
    79.743    29.930
>
    80.164    29.905
    79.743    29.930
>
    80.040    29.660
    79.743    29.930
>
    79.288    30.051
    79.743    29.930
>
    80.238    30.066
    79.743    29.930
>
    80.238    30.066
    79.743    29.930
>
    80.248    29.803
    79.743    29.930
>
    80.248    29.803
    79.743    29.930
>
    79.930    29.407
    79.743    29.930
>
    79.930    29.407
    79.743    29.930
>
    79.930    29.407
    79.743    29.930
>
    80.234    29.552
    79.743    29.930
>
    80.234    29.552
    79.743    29.930
>
    79.673    29.887
    79.720    29.962
>
    79.673    29.887
    79.720    29.962
>
    79.563    30.001
    79.720    29.962
>
    79.563    30.001
    79.720    29.962
>
    79.595    29.852
    79.720    29.962
>
    79.595    29.852
    79.720    29.962
>
    79.900    29.946
    79.720    29.962
>
    79.416    29.770
    79.720    29.962
>
    79.416    29.770
    79.720    29.962
>
    80.049    29.775
    79.720    29.962
>
    80.049    29.775
    79.720    29.962
>
    79.376    30.145
    79.720    29.962
>
    79.376    30.145
    79.720    29.962
>
    79.416    30.250
    79.720    29.962
>
    79.416    30.250
    79.720    29.962
>
    80.164    29.905
    79.720    29.962
>
    80.040    29.660
    79.720    29.962
>
    80.040    29.660
    79.720    29.962
>
    80.238    30.066
    79.720    29.962
>
    80.238    30.066
    79.720    29.962
>
    80.248    29.803
    79.720    29.962
>
    80.248    29.803
    79.720    29.962
>
    79.217    30.265
    79.720    29.962
>
    79.217    30.265
    79.720    29.962
>
    79.930    29.407
    79.720    29.962
>
    79.930    29.407
    79.720    29.962
>
    80.234    29.552
    79.720    29.962
>
    80.234    29.552
    79.720    29.962
>
    80.094    29.403
    79.720    29.962
>
    80.094    29.403
    79.720    29.962
>
    79.019    30.389
    79.062    30.496
>
    78.975    30.639
    79.062    30.496
>
    78.975    30.639
    79.062    30.496
>
    79.322    30.406
    79.062    30.496
>
    79.322    30.406
    79.062    30.496
>
    79.217    30.265
    79.062    30.496
>
    79.217    30.265
    79.062    30.496
>
    78.640    30.431
    79.062    30.496
>
    78.640    30.431
    79.062    30.496
>
    79.416    30.250
    79.062    30.496
>
    79.416    30.250
    79.062    30.496
>
    79.376    30.145
    79.062    30.496
>
    79.376    30.145
    79.062    30.496
>
    79.566    30.538
    79.062    30.496
>
    79.566    30.538
    79.062    30.496
>
    79.288    30.051
    79.062    30.496
>
    78.429    30.373
    79.062    30.496
>
    78.429    30.373
    79.062    30.496
>
    78.436    30.721
    79.062    30.496
>
    78.753    31.036
    79.062    30.496
>
    78.711    29.924
    79.062    30.496
>
    78.711    29.924
    79.062    30.496
>
    78.330    30.574
    79.062    30.496
>
    78.330    30.574
    79.062    30.496
>
    79.563    30.001
    79.062    30.496
>
    79.563    30.001
    79.062    30.496
>
    78.244    30.427
    79.062    30.496
>
    78.244    30.427
    79.062    30.496
>
    78.680    29.839
    79.062    30.496
>
    78.680    29.839
    79.062    30.496
>
    79.015    29.750
    79.062    30.496
>
    79.015    29.750
    79.062    30.496
>
    78.377    30.921
    79.062    30.496
>
    78.377    30.921
    79.062    30.496
>
    79.416    29.770
    79.062    30.496
>
    79.416    29.770
    79.062    30.496
>
    79.595    29.852
    79.062    30.496
>
    79.595    29.852
    79.062    30.496
>
    79.322    30.406
    79.281    30.591
>
    79.322    30.406
    79.281    30.591
>
    79.566    30.538
    79.281    30.591
>
    79.566    30.538
    79.281    30.591
>
    78.975    30.639
    79.281    30.591
>
    78.975    30.639
    79.281    30.591
>
    79.019    30.389
    79.281    30.591
>
    79.019    30.389
    79.281    30.591
>
    79.217    30.265
    79.281    30.591
>
    79.217    30.265
    79.281    30.591
>
    79.376    30.145
    79.281    30.591
>
    79.376    30.145
    79.281    30.591
>
    79.288    30.051
    79.281    30.591
>
    79.288    30.051
    79.281    30.591
>
    78.640    30.431
    79.281    30.591
>
    78.640    30.431
    79.281    30.591
>
    79.563    30.001
    79.281    30.591
>
    79.563    30.001
    79.281    30.591
>
    79.673    29.887
    79.281    30.591
>
    79.673    29.887
    79.281    30.591
>
    79.900    29.946
    79.960    30.101
>
    79.900    29.946
    79.960    30.101
>
    80.238    30.066
    79.960    30.101
>
    80.238    30.066
    79.960    30.101
>
    80.164    29.905
    79.960    30.101
>
    80.164    29.905
    79.960    30.101
>
    79.673    29.887
    79.960    30.101
>
    79.673    29.887
    79.960    30.101
>
    80.049    29.775
    79.960    30.101
>
    80.049    29.775
    79.960    30.101
>
    79.563    30.001
    79.960    30.101
>
    79.563    30.001
    79.960    30.101
>
    80.248    29.803
    79.960    30.101
>
    80.248    29.803
    79.960    30.101
>
    79.595    29.852
    79.960    30.101
>
    79.595    29.852
    79.960    30.101
>
    80.040    29.660
    79.960    30.101
>
    80.040    29.660
    79.960    30.101
>
    79.416    30.250
    79.960    30.101
>
    79.416    30.250
    79.960    30.101
>
    79.566    30.538
    79.960    30.101
>
    79.566    30.538
    79.960    30.101
>
    79.416    29.770
    79.960    30.101
>
    79.416    29.770
    79.960    30.101
>
    80.234    29.552
    79.960    30.101
>
    80.234    29.552
    79.960    30.101
>
    79.322    30.406
    79.960    30.101
>
    79.217    30.265
    79.960    30.101
>
    80.094    29.403
    79.960    30.101
>
    80.094    29.403
    79.960    30.101
>
    80.107    29.330
    79.960    30.101
>
    80.107    29.330
    79.960    30.101
>
    80.164    29.905
    80.230    29.978
>
    80.164    29.905
    80.230    29.978
>
    80.238    30.066
    80.230    29.978
>
    80.238    30.066
    80.230    29.978
>
    80.248    29.803
    80.230    29.978
>
    80.248    29.803
    80.230    29.978
>
    80.049    29.775
    80.230    29.978
>
    80.049    29.775
    80.230    29.978
>
    79.900    29.946
    80.230    29.978
>
    79.900    29.946
    80.230    29.978
>
    80.040    29.660
    80.230    29.978
>
    80.040    29.660
    80.230    29.978
>
    80.234    29.552
    80.230    29.978
>
    80.234    29.552
    80.230    29.978
>
    79.673    29.887
    80.230    29.978
>
    79.673    29.887
    80.230    29.978
>
    79.595    29.852
    80.230    29.978
>
    79.563    30.001
    80.230    29.978
>
    79.563    30.001
    80.230    29.978
>
    80.094    29.403
    80.230    29.978
>
    80.094    29.403
    80.230    29.978
>
    79.930    29.407
    80.230    29.978
>
    79.648    29.592
    80.230    29.978
>
    80.107    29.330
    80.230    29.978
>
    80.107    29.330
    80.230    29.978
>
    79.416    30.250
    80.230    29.978
>
    79.416    30.250
    80.230    29.978
>
    79.416    29.770
    80.230    29.978
>
    79.376    30.145
    80.230    29.978
>
    79.900    29.946
    79.880    30.147
>
    79.900    29.946
    79.880    30.147
>
    79.563    30.001
    79.880    30.147
>
    79.563    30.001
    79.880    30.147
>
    79.673    29.887
    79.880    30.147
>
    79.673    29.887
    79.880    30.147
>
    80.238    30.066
    79.880    30.147
>
    80.164    29.905
    79.880    30.147
>
    80.164    29.905
    79.880    30.147
>
    79.595    29.852
    79.880    30.147
>
    79.595    29.852
    79.880    30.147
>
    79.416    30.250
    79.880    30.147
>
    79.416    30.250
    79.880    30.147
>
    80.049    29.775
    79.880    30.147
>
    80.049    29.775
    79.880    30.147
>
    79.376    30.145
    79.880    30.147
>
    79.376    30.145
    79.880    30.147
>
    79.566    30.538
    79.880    30.147
>
    79.566    30.538
    79.880    30.147
>
    80.040    29.660
    79.880    30.147
>
    80.040    29.660
    79.880    30.147
>
    79.416    29.770
    79.880    30.147
>
    79.217    30.265
    79.880    30.147
>
    79.217    30.265
    79.880    30.147
>
    80.234    29.552
    79.880    30.147
>
    80.234    29.552
    79.880    30.147
>
    80.094    29.403
    79.880    30.147
>
    80.094    29.403
    79.880    30.147
>
    79.019    30.389
    79.880    30.147
>
    79.019    30.389
    79.880    30.147
>
    80.164    29.905
    80.093    29.989
>
    80.164    29.905
    80.093    29.989
>
    80.238    30.066
    80.093    29.989
>
    80.238    30.066
    80.093    29.989
>
    79.900    29.946
    80.093    29.989
>
    79.900    29.946
    80.093    29.989
>
    80.049    29.775
    80.093    29.989
>
    80.049    29.775
    80.093    29.989
>
    80.248    29.803
    80.093    29.989
>
    80.248    29.803
    80.093    29.989
>
    80.040    29.660
    80.093    29.989
>
    80.040    29.660
    80.093    29.989
>
    79.673    29.887
    80.093    29.989
>
    79.673    29.887
    80.093    29.989
>
    80.544    29.849
    80.093    29.989
>
    80.544    29.849
    80.093    29.989
>
    79.595    29.852
    80.093    29.989
>
    79.595    29.852
    80.093    29.989
>
    79.563    30.001
    80.093    29.989
>
    79.563    30.001
    80.093    29.989
>
    80.234    29.552
    80.093    29.989
>
    80.234    29.552
    80.093    29.989
>
    79.648    29.592
    80.093    29.989
>
    79.648    29.592
    80.093    29.989
>
    80.094    29.403
    80.093    29.989
>
    80.094    29.403
    80.093    29.989
>
    79.930    29.407
    80.093    29.989
>
    79.930    29.407
    80.093    29.989
>
    80.107    29.330
    80.093    29.989
>
    80.107    29.330
    80.093    29.989
>
    79.288    30.051
    80.093    29.989
>
    79.288    30.051
    80.093    29.989
>
    79.566    30.538
    80.093    29.989
>
    79.566    30.538
    80.093    29.989
>
    79.322    30.406
    80.093    29.989
>
    79.322    30.406
    80.093    29.989
>
    79.900    29.946
    79.842    30.046
>
    79.900    29.946
    79.842    30.046
>
    79.673    29.887
    79.842    30.046
>
    79.673    29.887
    79.842    30.046
>
    79.563    30.001
    79.842    30.046
>
    79.563    30.001
    79.842    30.046
>
    79.595    29.852
    79.842    30.046
>
    79.595    29.852
    79.842    30.046
>
    80.164    29.905
    79.842    30.046
>
    80.164    29.905
    79.842    30.046
>
    80.049    29.775
    79.842    30.046
>
    80.049    29.775
    79.842    30.046
>
    80.238    30.066
    79.842    30.046
>
    80.238    30.066
    79.842    30.046
>
    79.416    30.250
    79.842    30.046
>
    79.416    30.250
    79.842    30.046
>
    80.040    29.660
    79.842    30.046
>
    80.040    29.660
    79.842    30.046
>
    80.248    29.803
    79.842    30.046
>
    80.248    29.803
    79.842    30.046
>
    79.930    29.407
    79.842    30.046
>
    79.930    29.407
    79.842    30.046
>
    80.094    29.403
    79.842    30.046
>
    80.094    29.403
    79.842    30.046
>
    78.436    30.721
    78.494    30.755
>
    78.436    30.721
    78.494    30.755
>
    78.377    30.921
    78.494    30.755
>
    78.330    30.574
    78.494    30.755
>
    78.330    30.574
    78.494    30.755
>
    78.205    30.808
    78.494    30.755
>
    78.205    30.808
    78.494    30.755
>
    78.640    30.431
    78.494    30.755
>
    78.640    30.431
    78.494    30.755
>
    78.753    31.036
    78.494    30.755
>
    78.753    31.036
    78.494    30.755
>
    78.429    30.373
    78.494    30.755
>
    78.429    30.373
    78.494    30.755
>
    78.244    30.427
    78.494    30.755
>
    78.244    30.427
    78.494    30.755
>
    78.103    30.909
    78.494    30.755
>
    78.103    30.909
    78.494    30.755
>
    78.975    30.639
    78.494    30.755
>
    78.975    30.639
    78.494    30.755
>
    78.074    30.455
    78.494    30.755
>
    79.019    30.389
    78.494    30.755
>
    79.019    30.389
    78.494    30.755
>
    77.873    30.691
    78.494    30.755
>
    77.873    30.691
    78.494    30.755
>
    77.845    30.934
    78.494    30.755
>
    77.845    30.934
    78.494    30.755
>
    77.843    30.518
    78.494    30.755
>
    77.843    30.518
    78.494    30.755
>
    79.217    30.265
    78.494    30.755
>
    79.217    30.265
    78.494    30.755
>
    79.322    30.406
    78.494    30.755
>
    79.322    30.406
    78.494    30.755
>
    78.056    30.323
    78.494    30.755
>
    80.238    30.066
    80.214    30.009
>
    80.238    30.066
    80.214    30.009
>
    80.164    29.905
    80.214    30.009
>
    80.164    29.905
    80.214    30.009
>
    80.248    29.803
    80.214    30.009
>
    80.248    29.803
    80.214    30.009
>
    79.900    29.946
    80.214    30.009
>
    79.900    29.946
    80.214    30.009
>
    80.049    29.775
    80.214    30.009
>
    80.049    29.775
    80.214    30.009
>
    80.544    29.849
    80.214    30.009
>
    80.544    29.849
    80.214    30.009
>
    80.040    29.660
    80.214    30.009
>
    80.040    29.660
    80.214    30.009
>
    80.234    29.552
    80.214    30.009
>
    80.234    29.552
    80.214    30.009
>
    79.673    29.887
    80.214    30.009
>
    79.673    29.887
    80.214    30.009
>
    79.595    29.852
    80.214    30.009
>
    79.595    29.852
    80.214    30.009
>
    80.094    29.403
    80.214    30.009
>
    80.094    29.403
    80.214    30.009
>
    79.648    29.592
    80.214    30.009
>
    79.648    29.592
    80.214    30.009
>
    79.930    29.407
    80.214    30.009
>
    79.930    29.407
    80.214    30.009
>
    80.107    29.330
    80.214    30.009
>
    80.107    29.330
    80.214    30.009
>
    79.416    30.250
    80.214    30.009
>
    79.416    30.250
    80.214    30.009
>
    79.416    29.770
    80.214    30.009
>
    79.416    29.770
    80.214    30.009
>
    79.376    30.145
    80.214    30.009
>
    79.566    30.538
    80.214    30.009
>
    79.566    30.538
    80.214    30.009
>
    78.377    30.921
    78.482    30.768
>
    78.377    30.921
    78.482    30.768
>
    78.330    30.574
    78.482    30.768
>
    78.330    30.574
    78.482    30.768
>
    78.753    31.036
    78.482    30.768
>
    78.753    31.036
    78.482    30.768
>
    78.640    30.431
    78.482    30.768
>
    78.640    30.431
    78.482    30.768
>
    78.103    30.909
    78.482    30.768
>
    78.103    30.909
    78.482    30.768
>
    78.244    30.427
    78.482    30.768
>
    78.244    30.427
    78.482    30.768
>
    78.975    30.639
    78.482    30.768
>
    78.975    30.639
    78.482    30.768
>
    78.074    30.455
    78.482    30.768
>
    78.074    30.455
    78.482    30.768
>
    79.019    30.389
    78.482    30.768
>
    79.019    30.389
    78.482    30.768
>
    77.845    30.934
    78.482    30.768
>
    77.845    30.934
    78.482    30.768
>
    79.673    29.887
    79.725    30.020
>
    79.673    29.887
    79.725    30.020
>
    79.563    30.001
    79.725    30.020
>
    79.563    30.001
    79.725    30.020
>
    79.900    29.946
    79.725    30.020
>
    79.900    29.946
    79.725    30.020
>
    79.595    29.852
    79.725    30.020
>
    79.595    29.852
    79.725    30.020
>
    79.376    30.145
    79.725    30.020
>
    79.376    30.145
    79.725    30.020
>
    79.416    30.250
    79.725    30.020
>
    79.416    30.250
    79.725    30.020
>
    79.416    29.770
    79.725    30.020
>
    79.416    29.770
    79.725    30.020
>
    80.049    29.775
    79.725    30.020
>
    80.049    29.775
    79.725    30.020
>
    79.288    30.051
    79.725    30.020
>
    79.288    30.051
    79.725    30.020
>
    80.164    29.905
    79.725    30.020
>
    80.164    29.905
    79.725    30.020
>
    79.648    29.592
    79.725    30.020
>
    79.648    29.592
    79.725    30.020
>
    80.238    30.066
    79.725    30.020
>
    80.238    30.066
    79.725    30.020
>
    80.040    29.660
    79.725    30.020
>
    80.040    29.660
    79.725    30.020
>
    79.217    30.265
    79.725    30.020
>
    79.217    30.265
    79.725    30.020
>
    80.248    29.803
    79.725    30.020
>
    80.248    29.803
    79.725    30.020
>
    79.322    30.406
    79.725    30.020
>
    79.322    30.406
    79.725    30.020
>
    79.566    30.538
    79.725    30.020
>
    79.566    30.538
    79.725    30.020
>
    79.930    29.407
    79.725    30.020
>
    79.930    29.407
    79.725    30.020
>
    80.234    29.552
    79.725    30.020
>
    80.234    29.552
    79.725    30.020
>
    79.457    29.359
    79.725    30.020
>
    79.457    29.359
    79.725    30.020
>
    79.547    29.355
    79.725    30.020
>
    79.547    29.355
    79.725    30.020
>
    80.094    29.403
    79.725    30.020
>
    80.094    29.403
    79.725    30.020
>
    79.019    30.389
    79.725    30.020
>
    80.107    29.330
    79.725    30.020
>
    80.107    29.330
    79.725    30.020
>
    80.164    29.905
    80.075    30.034
>
    80.164    29.905
    80.075    30.034
>
    80.238    30.066
    80.075    30.034
>
    80.238    30.066
    80.075    30.034
>
    79.900    29.946
    80.075    30.034
>
    79.900    29.946
    80.075    30.034
>
    80.049    29.775
    80.075    30.034
>
    80.049    29.775
    80.075    30.034
>
    80.248    29.803
    80.075    30.034
>
    80.248    29.803
    80.075    30.034
>
    79.673    29.887
    80.075    30.034
>
    79.673    29.887
    80.075    30.034
>
    80.040    29.660
    80.075    30.034
>
    80.040    29.660
    80.075    30.034
>
    79.563    30.001
    80.075    30.034
>
    79.563    30.001
    80.075    30.034
>
    79.595    29.852
    80.075    30.034
>
    79.595    29.852
    80.075    30.034
>
    80.544    29.849
    80.075    30.034
>
    80.234    29.552
    80.075    30.034
>
    80.234    29.552
    80.075    30.034
>
    79.416    30.250
    80.075    30.034
>
    79.416    30.250
    80.075    30.034
>
    79.376    30.145
    80.075    30.034
>
    79.376    30.145
    80.075    30.034
>
    79.416    29.770
    80.075    30.034
>
    79.416    29.770
    80.075    30.034
>
    80.094    29.403
    80.075    30.034
>
    80.094    29.403
    80.075    30.034
>
    79.930    29.407
    80.075    30.034
>
    79.930    29.407
    80.075    30.034
>
    79.288    30.051
    80.075    30.034
>
    79.288    30.051
    80.075    30.034
>
    80.107    29.330
    80.075    30.034
>
    80.107    29.330
    80.075    30.034
>
    79.217    30.265
    80.075    30.034
>
    80.238    30.066
    80.149    30.015
>
    79.900    29.946
    80.149    30.015
>
    79.900    29.946
    80.149    30.015
>
    80.248    29.803
    80.149    30.015
>
    80.248    29.803
    80.149    30.015
>
    80.049    29.775
    80.149    30.015
>
    80.049    29.775
    80.149    30.015
>
    80.040    29.660
    80.149    30.015
>
    80.040    29.660
    80.149    30.015
>
    79.673    29.887
    80.149    30.015
>
    79.673    29.887
    80.149    30.015
>
    79.595    29.852
    80.149    30.015
>
    79.595    29.852
    80.149    30.015
>
    79.563    30.001
    80.149    30.015
>
    79.563    30.001
    80.149    30.015
>
    80.094    29.403
    80.149    30.015
>
    80.094    29.403
    80.149    30.015
>
    79.416    30.250
    80.149    30.015
>
    79.416    30.250
    80.149    30.015
>
    79.416    29.770
    80.149    30.015
>
    79.416    29.770
    80.149    30.015
>
    80.107    29.330
    80.149    30.015
>
    80.107    29.330
    80.149    30.015
>
    78.287    30.161
    78.314    30.283
>
    78.287    30.161
    78.314    30.283
>
    78.429    30.373
    78.314    30.283
>
    78.429    30.373
    78.314    30.283
>
    78.244    30.427
    78.314    30.283
>
    78.244    30.427
    78.314    30.283
>
    78.074    30.455
    78.314    30.283
>
    78.074    30.455
    78.314    30.283
>
    78.330    30.574
    78.314    30.283
>
    78.640    30.431
    78.314    30.283
>
    78.640    30.431
    78.314    30.283
>
    78.711    29.924
    78.314    30.283
>
    78.711    29.924
    78.314    30.283
>
    78.680    29.839
    78.314    30.283
>
    78.680    29.839
    78.314    30.283
>
    78.205    30.808
    78.314    30.283
>
    78.205    30.808
    78.314    30.283
>
    77.873    30.691
    78.314    30.283
>
    77.873    30.691
    78.314    30.283
>
    79.019    30.389
    78.314    30.283
>
    79.019    30.389
    78.314    30.283
>
    78.975    30.639
    78.314    30.283
>
    78.975    30.639
    78.314    30.283
>
    77.845    30.934
    78.314    30.283
>
    77.845    30.934
    78.314    30.283
>
    79.900    29.946
    79.870    30.101
>
    79.900    29.946
    79.870    30.101
>
    79.673    29.887
    79.870    30.101
>
    79.673    29.887
    79.870    30.101
>
    79.563    30.001
    79.870    30.101
>
    79.563    30.001
    79.870    30.101
>
    80.164    29.905
    79.870    30.101
>
    80.164    29.905
    79.870    30.101
>
    79.595    29.852
    79.870    30.101
>
    79.595    29.852
    79.870    30.101
>
    80.049    29.775
    79.870    30.101
>
    80.049    29.775
    79.870    30.101
>
    79.416    30.250
    79.870    30.101
>
    79.416    30.250
    79.870    30.101
>
    80.248    29.803
    79.870    30.101
>
    80.248    29.803
    79.870    30.101
>
    80.040    29.660
    79.870    30.101
>
    80.040    29.660
    79.870    30.101
>
    79.288    30.051
    79.870    30.101
>
    79.288    30.051
    79.870    30.101
>
    79.648    29.592
    79.870    30.101
>
    79.648    29.592
    79.870    30.101
>
    79.322    30.406
    79.870    30.101
>
    79.217    30.265
    79.870    30.101
>
    79.217    30.265
    79.870    30.101
>
    80.544    29.849
    79.870    30.101
>
    80.544    29.849
    79.870    30.101
>
    80.094    29.403
    79.870    30.101
>
    80.094    29.403
    79.870    30.101
>
    80.107    29.330
    79.870    30.101
>
    80.107    29.330
    79.870    30.101
>
    79.547    29.355
    79.870    30.101
>
    79.547    29.355
    79.870    30.101
>
    79.019    30.389
    79.870    30.101
>
    79.019    30.389
    79.870    30.101
>
    78.377    30.921
    78.272    30.891
>
    78.377    30.921
    78.272    30.891
>
    78.205    30.808
    78.272    30.891
>
    78.205    30.808
    78.272    30.891
>
    78.330    30.574
    78.272    30.891
>
    78.330    30.574
    78.272    30.891
>
    78.753    31.036
    78.272    30.891
>
    78.244    30.427
    78.272    30.891
>
    78.244    30.427
    78.272    30.891
>
    78.074    30.455
    78.272    30.891
>
    78.074    30.455
    78.272    30.891
>
    78.429    30.373
    78.272    30.891
>
    78.975    30.639
    78.272    30.891
>
    78.975    30.639
    78.272    30.891
>
    80.164    29.905
    80.142    29.957
>
    80.164    29.905
    80.142    29.957
>
    80.238    30.066
    80.142    29.957
>
    80.248    29.803
    80.142    29.957
>
    80.248    29.803
    80.142    29.957
>
    80.049    29.775
    80.142    29.957
>
    80.049    29.775
    80.142    29.957
>
    80.040    29.660
    80.142    29.957
>
    80.040    29.660
    80.142    29.957
>
    79.673    29.887
    80.142    29.957
>
    79.673    29.887
    80.142    29.957
>
    80.234    29.552
    80.142    29.957
>
    80.234    29.552
    80.142    29.957
>
    79.595    29.852
    80.142    29.957
>
    79.595    29.852
    80.142    29.957
>
    80.094    29.403
    80.142    29.957
>
    80.094    29.403
    80.142    29.957
>
    79.648    29.592
    80.142    29.957
>
    79.930    29.407
    80.142    29.957
>
    79.930    29.407
    80.142    29.957
>
    80.107    29.330
    80.142    29.957
>
    80.107    29.330
    80.142    29.957
>
    79.416    30.250
    79.593    30.198
>
    79.416    30.250
    79.593    30.198
>
    79.376    30.145
    79.593    30.198
>
    79.376    30.145
    79.593    30.198
>
    79.563    30.001
    79.593    30.198
>
    79.563    30.001
    79.593    30.198
>
    79.288    30.051
    79.593    30.198
>
    79.673    29.887
    79.593    30.198
>
    79.673    29.887
    79.593    30.198
>
    79.322    30.406
    79.593    30.198
>
    79.322    30.406
    79.593    30.198
>
    79.595    29.852
    79.593    30.198
>
    79.595    29.852
    79.593    30.198
>
    79.019    30.389
    79.593    30.198
>
    80.238    30.066
    79.593    30.198
>
    79.015    29.750
    79.593    30.198
>
    80.040    29.660
    79.593    30.198
>
    78.975    30.639
    79.593    30.198
>
    79.900    29.946
    79.871    29.999
>
    79.673    29.887
    79.871    29.999
>
    79.673    29.887
    79.871    29.999
>
    79.563    30.001
    79.871    29.999
>
    79.563    30.001
    79.871    29.999
>
    80.049    29.775
    79.871    29.999
>
    80.049    29.775
    79.871    29.999
>
    80.164    29.905
    79.871    29.999
>
    80.164    29.905
    79.871    29.999
>
    79.595    29.852
    79.871    29.999
>
    79.595    29.852
    79.871    29.999
>
    80.238    30.066
    79.871    29.999
>
    80.238    30.066
    79.871    29.999
>
    80.040    29.660
    79.871    29.999
>
    80.040    29.660
    79.871    29.999
>
    80.248    29.803
    79.871    29.999
>
    80.248    29.803
    79.871    29.999
>
    79.416    30.250
    79.871    29.999
>
    79.416    30.250
    79.871    29.999
>
    79.376    30.145
    79.871    29.999
>
    79.376    30.145
    79.871    29.999
>
    80.234    29.552
    79.871    29.999
>
    80.234    29.552
    79.871    29.999
>
    79.930    29.407
    79.871    29.999
>
    79.930    29.407
    79.871    29.999
>
    80.094    29.403
    79.871    29.999
>
    80.094    29.403
    79.871    29.999
>
    79.217    30.265
    79.871    29.999
>
    79.217    30.265
    79.871    29.999
>
    79.322    30.406
    79.871    29.999
>
    79.322    30.406
    79.871    29.999
>
    80.107    29.330
    79.871    29.999
>
    79.416    30.250
    79.424    30.330
>
    79.416    30.250
    79.424    30.330
>
    79.322    30.406
    79.424    30.330
>
    79.322    30.406
    79.424    30.330
>
    79.217    30.265
    79.424    30.330
>
    79.217    30.265
    79.424    30.330
>
    79.376    30.145
    79.424    30.330
>
    79.376    30.145
    79.424    30.330
>
    79.566    30.538
    79.424    30.330
>
    79.566    30.538
    79.424    30.330
>
    79.288    30.051
    79.424    30.330
>
    79.288    30.051
    79.424    30.330
>
    79.563    30.001
    79.424    30.330
>
    79.563    30.001
    79.424    30.330
>
    79.019    30.389
    79.424    30.330
>
    79.673    29.887
    79.424    30.330
>
    79.673    29.887
    79.424    30.330
>
    79.595    29.852
    79.424    30.330
>
    79.595    29.852
    79.424    30.330
>
    79.900    29.946
    79.424    30.330
>
    79.900    29.946
    79.424    30.330
>
    79.015    29.750
    79.424    30.330
>
    79.015    29.750
    79.424    30.330
>
    78.711    29.924
    79.424    30.330
>
    78.711    29.924
    79.424    30.330
>
    79.648    29.592
    79.424    30.330
>
    79.648    29.592
    79.424    30.330
>
    80.238    30.066
    79.424    30.330
>
    80.238    30.066
    79.424    30.330
>
    80.164    29.905
    79.424    30.330
>
    80.049    29.775
    79.424    30.330
>
    79.322    30.406
    79.149    30.501
>
    79.322    30.406
    79.149    30.501
>
    79.019    30.389
    79.149    30.501
>
    79.019    30.389
    79.149    30.501
>
    78.975    30.639
    79.149    30.501
>
    78.975    30.639
    79.149    30.501
>
    79.217    30.265
    79.149    30.501
>
    79.217    30.265
    79.149    30.501
>
    79.566    30.538
    79.149    30.501
>
    79.566    30.538
    79.149    30.501
>
    79.416    30.250
    79.149    30.501
>
    79.416    30.250
    79.149    30.501
>
    79.376    30.145
    79.149    30.501
>
    79.376    30.145
    79.149    30.501
>
    78.640    30.431
    79.149    30.501
>
    78.640    30.431
    79.149    30.501
>
    79.288    30.051
    79.149    30.501
>
    79.288    30.051
    79.149    30.501
>
    79.563    30.001
    79.149    30.501
>
    78.753    31.036
    79.149    30.501
>
    78.429    30.373
    79.149    30.501
>
    78.429    30.373
    79.149    30.501
>
    78.436    30.721
    79.149    30.501
>
    78.436    30.721
    79.149    30.501
>
    78.711    29.924
    79.149    30.501
>
    78.711    29.924
    79.149    30.501
>
    78.330    30.574
    79.149    30.501
>
    78.330    30.574
    79.149    30.501
>
    79.595    29.852
    79.149    30.501
>
    79.673    29.887
    79.149    30.501
>
    79.015    29.750
    79.149    30.501
>
    79.015    29.750
    79.149    30.501
>
    78.377    30.921
    79.149    30.501
>
    78.680    29.839
    79.149    30.501
>
    78.680    29.839
    79.149    30.501
>
    78.244    30.427
    79.149    30.501
>
    78.244    30.427
    79.149    30.501
>
    78.103    30.909
    78.136    30.922
>
    78.205    30.808
    78.136    30.922
>
    78.205    30.808
    78.136    30.922
>
    78.377    30.921
    78.136    30.922
>
    78.377    30.921
    78.136    30.922
>
    78.436    30.721
    78.136    30.922
>
    78.436    30.721
    78.136    30.922
>
    77.845    30.934
    78.136    30.922
>
    77.873    30.691
    78.136    30.922
>
    78.330    30.574
    78.136    30.922
>
    78.330    30.574
    78.136    30.922
>
    78.074    30.455
    78.136    30.922
>
    78.074    30.455
    78.136    30.922
>
    78.244    30.427
    78.136    30.922
>
    78.244    30.427
    78.136    30.922
>
    77.843    30.518
    78.136    30.922
>
    77.843    30.518
    78.136    30.922
>
    78.429    30.373
    78.136    30.922
>
    78.429    30.373
    78.136    30.922
>
    78.640    30.431
    78.136    30.922
>
    78.640    30.431
    78.136    30.922
>
    78.975    30.639
    78.136    30.922
>
    78.287    30.161
    78.136    30.922
>
    78.287    30.161
    78.136    30.922
>
    80.544    29.849
    80.433    29.903
>
    80.544    29.849
    80.433    29.903
>
    80.248    29.803
    80.433    29.903
>
    80.248    29.803
    80.433    29.903
>
    80.238    30.066
    80.433    29.903
>
    80.238    30.066
    80.433    29.903
>
    80.049    29.775
    80.433    29.903
>
    80.049    29.775
    80.433    29.903
>
    80.234    29.552
    80.433    29.903
>
    80.234    29.552
    80.433    29.903
>
    80.040    29.660
    80.433    29.903
>
    80.040    29.660
    80.433    29.903
>
    79.900    29.946
    80.433    29.903
>
    80.094    29.403
    80.433    29.903
>
    80.094    29.403
    80.433    29.903
>
    80.107    29.330
    80.433    29.903
>
    80.107    29.330
    80.433    29.903
>
    79.673    29.887
    80.433    29.903
>
    79.673    29.887
    80.433    29.903
>
    79.930    29.407
    80.433    29.903
>
    79.930    29.407
    80.433    29.903
>
    79.648    29.592
    80.433    29.903
>
    79.563    30.001
    80.433    29.903
>
    79.563    30.001
    80.433    29.903
>
    79.673    29.887
    79.768    29.977
>
    79.900    29.946
    79.768    29.977
>
    79.900    29.946
    79.768    29.977
>
    79.595    29.852
    79.768    29.977
>
    79.595    29.852
    79.768    29.977
>
    80.040    29.660
    79.768    29.977
>
    80.040    29.660
    79.768    29.977
>
    79.648    29.592
    79.768    29.977
>
    79.648    29.592
    79.768    29.977
>
    79.416    30.250
    79.768    29.977
>
    79.416    30.250
    79.768    29.977
>
    79.288    30.051
    79.768    29.977
>
    79.288    30.051
    79.768    29.977
>
    80.248    29.803
    79.768    29.977
>
    80.248    29.803
    79.768    29.977
>
    79.930    29.407
    79.768    29.977
>
    79.930    29.407
    79.768    29.977
>
    80.234    29.552
    79.768    29.977
>
    80.234    29.552
    79.768    29.977
>
    80.094    29.403
    79.768    29.977
>
    80.094    29.403
    79.768    29.977
>
    80.107    29.330
    79.768    29.977
>
    80.107    29.330
    79.768    29.977
>
    79.176    30.488
    79.054    30.497
>
    79.176    30.488
    79.054    30.497
>
    79.019    30.389
    79.054    30.497
>
    79.019    30.389
    79.054    30.497
>
    79.141    30.588
    79.054    30.497
>
    79.141    30.588
    79.054    30.497
>
    78.975    30.639
    79.054    30.497
>
    78.975    30.639
    79.054    30.497
>
    79.217    30.265
    79.054    30.497
>
    79.217    30.265
    79.054    30.497
>
    78.649    30.579
    79.054    30.497
>
    78.649    30.579
    79.054    30.497
>
    78.640    30.431
    79.054    30.497
>
    78.640    30.431
    79.054    30.497
>
    79.416    30.250
    79.054    30.497
>
    79.416    30.250
    79.054    30.497
>
    78.768    30.155
    79.054    30.497
>
    78.768    30.155
    79.054    30.497
>
    79.049    30.019
    79.054    30.497
>
    79.049    30.019
    79.054    30.497
>
    78.918    29.916
    79.054    30.497
>
    78.918    29.916
    79.054    30.497
>
    78.711    29.924
    79.054    30.497
>
    78.711    29.924
    79.054    30.497
>
    79.210    29.820
    79.054    30.497
>
    79.210    29.820
    79.054    30.497
>
    78.244    30.427
    79.054    30.497
>
    78.244    30.427
    79.054    30.497
>
    78.680    29.839
    79.054    30.497
>
    78.680    29.839
    79.054    30.497
>
    79.015    29.750
    79.054    30.497
>
    79.015    29.750
    79.054    30.497
>
    79.595    29.852
    79.054    30.497
>
    79.595    29.852
    79.054    30.497
>
    79.900    29.946
    79.892    30.107
>
    79.900    29.946
    79.892    30.107
>
    79.673    29.887
    79.892    30.107
>
    79.673    29.887
    79.892    30.107
>
    79.563    30.001
    79.892    30.107
>
    79.563    30.001
    79.892    30.107
>
    80.238    30.066
    79.892    30.107
>
    80.238    30.066
    79.892    30.107
>
    80.164    29.905
    79.892    30.107
>
    80.164    29.905
    79.892    30.107
>
    79.595    29.852
    79.892    30.107
>
    79.595    29.852
    79.892    30.107
>
    79.416    30.250
    79.892    30.107
>
    79.416    30.250
    79.892    30.107
>
    80.248    29.803
    79.892    30.107
>
    80.248    29.803
    79.892    30.107
>
    79.376    30.145
    79.892    30.107
>
    79.376    30.145
    79.892    30.107
>
    80.040    29.660
    79.892    30.107
>
    80.040    29.660
    79.892    30.107
>
    79.648    29.592
    79.892    30.107
>
    79.648    29.592
    79.892    30.107
>
    79.217    30.265
    79.892    30.107
>
    80.234    29.552
    79.892    30.107
>
    80.234    29.552
    79.892    30.107
>
    79.930    29.407
    79.892    30.107
>
    79.930    29.407
    79.892    30.107
>
    80.094    29.403
    79.892    30.107
>
    80.094    29.403
    79.892    30.107
>
    79.049    30.019
    79.892    30.107
>
    80.107    29.330
    79.892    30.107
>
    80.107    29.330
    79.892    30.107
>
    78.436    30.721
    78.399    30.761
>
    78.436    30.721
    78.399    30.761
>
    78.377    30.921
    78.399    30.761
>
    78.330    30.574
    78.399    30.761
>
    78.205    30.808
    78.399    30.761
>
    78.649    30.579
    78.399    30.761
>
    78.649    30.579
    78.399    30.761
>
    78.103    30.909
    78.399    30.761
>
    78.103    30.909
    78.399    30.761
>
    78.244    30.427
    78.399    30.761
>
    78.640    30.431
    78.399    30.761
>
    78.640    30.431
    78.399    30.761
>
    78.753    31.036
    78.399    30.761
>
    78.753    31.036
    78.399    30.761
>
    78.074    30.455
    78.399    30.761
>
    77.873    30.691
    78.399    30.761
>
    78.975    30.639
    78.399    30.761
>
    77.845    30.934
    78.399    30.761
>
    77.845    30.934
    78.399    30.761
>
    77.843    30.518
    78.399    30.761
>
    77.843    30.518
    78.399    30.761
>
    78.287    30.161
    78.399    30.761
>
    78.287    30.161
    78.399    30.761
>
    79.019    30.389
    78.399    30.761
>
    78.768    30.155
    78.399    30.761
>
    78.768    30.155
    78.399    30.761
>
    79.176    30.488
    78.399    30.761
>
    79.176    30.488
    78.399    30.761
>
    78.250    31.533
    78.399    30.761
>
    78.250    31.533
    78.399    30.761
>
    80.544    29.849
    80.422    29.870
>
    80.544    29.849
    80.422    29.870
>
    80.248    29.803
    80.422    29.870
>
    80.164    29.905
    80.422    29.870
>
    80.164    29.905
    80.422    29.870
>
    80.234    29.552
    80.422    29.870
>
    80.234    29.552
    80.422    29.870
>
    80.040    29.660
    80.422    29.870
>
    80.040    29.660
    80.422    29.870
>
    79.900    29.946
    80.422    29.870
>
    79.900    29.946
    80.422    29.870
>
    80.094    29.403
    80.422    29.870
>
    80.094    29.403
    80.422    29.870
>
    80.107    29.330
    80.422    29.870
>
    80.107    29.330
    80.422    29.870
>
    79.930    29.407
    80.422    29.870
>
    79.930    29.407
    80.422    29.870
>
    79.673    29.887
    80.422    29.870
>
    79.673    29.887
    80.422    29.870
>
    79.595    29.852
    80.422    29.870
>
    79.595    29.852
    80.422    29.870
>
    78.250    31.533
    78.181    30.875
>
    78.250    31.533
    78.181    30.875
>
    80.248    29.803
    80.392    29.880
>
    80.248    29.803
    80.392    29.880
>
    80.544    29.849
    80.392    29.880
>
    80.544    29.849
    80.392    29.880
>
    80.164    29.905
    80.392    29.880
>
    80.238    30.066
    80.392    29.880
>
    80.238    30.066
    80.392    29.880
>
    80.234    29.552
    80.392    29.880
>
    80.234    29.552
    80.392    29.880
>
    80.040    29.660
    80.392    29.880
>
    80.040    29.660
    80.392    29.880
>
    79.900    29.946
    80.392    29.880
>
    79.900    29.946
    80.392    29.880
>
    80.094    29.403
    80.392    29.880
>
    80.094    29.403
    80.392    29.880
>
    80.107    29.330
    80.392    29.880
>
    80.107    29.330
    80.392    29.880
>
    79.930    29.407
    80.392    29.880
>
    79.930    29.407
    80.392    29.880
>
    79.673    29.887
    80.392    29.880
>
    79.673    29.887
    80.392    29.880
>
    79.595    29.852
    80.392    29.880
>
    79.595    29.852
    80.392    29.880
>
    79.563    30.001
    80.392    29.880
>
    79.563    30.001
    80.392    29.880
>
    79.900    29.946
    79.864    30.154
>
    79.900    29.946
    79.864    30.154
>
    79.563    30.001
    79.864    30.154
>
    79.563    30.001
    79.864    30.154
>
    79.673    29.887
    79.864    30.154
>
    79.673    29.887
    79.864    30.154
>
    80.238    30.066
    79.864    30.154
>
    80.238    30.066
    79.864    30.154
>
    80.164    29.905
    79.864    30.154
>
    80.164    29.905
    79.864    30.154
>
    79.416    30.250
    79.864    30.154
>
    79.416    30.250
    79.864    30.154
>
    79.595    29.852
    79.864    30.154
>
    79.595    29.852
    79.864    30.154
>
    79.376    30.145
    79.864    30.154
>
    79.376    30.145
    79.864    30.154
>
    79.566    30.538
    79.864    30.154
>
    79.566    30.538
    79.864    30.154
>
    80.248    29.803
    79.864    30.154
>
    80.248    29.803
    79.864    30.154
>
    79.288    30.051
    79.864    30.154
>
    79.288    30.051
    79.864    30.154
>
    80.040    29.660
    79.864    30.154
>
    80.040    29.660
    79.864    30.154
>
    79.322    30.406
    79.864    30.154
>
    79.322    30.406
    79.864    30.154
>
    79.217    30.265
    79.864    30.154
>
    79.217    30.265
    79.864    30.154
>
    79.648    29.592
    79.864    30.154
>
    79.176    30.488
    79.864    30.154
>
    79.176    30.488
    79.864    30.154
>
    80.234    29.552
    79.864    30.154
>
    80.234    29.552
    79.864    30.154
>
    79.930    29.407
    79.864    30.154
>
    79.930    29.407
    79.864    30.154
>
    79.019    30.389
    79.864    30.154
>
    79.019    30.389
    79.864    30.154
>
    80.094    29.403
    79.864    30.154
>
    80.094    29.403
    79.864    30.154
>
    79.176    30.488
    79.143    30.553
>
    78.975    30.639
    79.143    30.553
>
    78.975    30.639
    79.143    30.553
>
    79.217    30.265
    79.143    30.553
>
    79.217    30.265
    79.143    30.553
>
    79.416    30.250
    79.143    30.553
>
    78.640    30.431
    79.143    30.553
>
    78.640    30.431
    79.143    30.553
>
    78.768    30.155
    79.143    30.553
>
    78.768    30.155
    79.143    30.553
>
    79.288    30.051
    79.143    30.553
>
    79.288    30.051
    79.143    30.553
>
    79.049    30.019
    79.143    30.553
>
    79.049    30.019
    79.143    30.553
>
    78.918    29.916
    79.143    30.553
>
    78.711    29.924
    79.143    30.553
>
    78.711    29.924
    79.143    30.553
>
    79.210    29.820
    79.143    30.553
>
    79.210    29.820
    79.143    30.553
>
    78.244    30.427
    79.143    30.553
>
    78.244    30.427
    79.143    30.553
>
    78.975    30.639
    78.851    30.684
>
    78.975    30.639
    78.851    30.684
>
    78.649    30.579
    78.851    30.684
>
    78.649    30.579
    78.851    30.684
>
    79.141    30.588
    78.851    30.684
>
    79.141    30.588
    78.851    30.684
>
    78.640    30.431
    78.851    30.684
>
    78.640    30.431
    78.851    30.684
>
    79.019    30.389
    78.851    30.684
>
    79.019    30.389
    78.851    30.684
>
    79.176    30.488
    78.851    30.684
>
    79.176    30.488
    78.851    30.684
>
    78.436    30.721
    78.851    30.684
>
    78.330    30.574
    78.851    30.684
>
    79.217    30.265
    78.851    30.684
>
    78.768    30.155
    78.851    30.684
>
    78.768    30.155
    78.851    30.684
>
    78.244    30.427
    78.851    30.684
>
    78.244    30.427
    78.851    30.684
>
    79.416    30.250
    78.851    30.684
>
    79.049    30.019
    78.851    30.684
>
    78.287    30.161
    78.851    30.684
>
    78.287    30.161
    78.851    30.684
>
    78.103    30.909
    78.851    30.684
>
    78.074    30.455
    78.851    30.684
>
    78.074    30.455
    78.851    30.684
>
    79.288    30.051
    78.851    30.684
>
    79.288    30.051
    78.851    30.684
>
    78.918    29.916
    78.851    30.684
>
    78.918    29.916
    78.851    30.684
>
    78.649    30.579
    78.655    30.724
>
    78.649    30.579
    78.655    30.724
>
    78.436    30.721
    78.655    30.724
>
    78.436    30.721
    78.655    30.724
>
    78.975    30.639
    78.655    30.724
>
    78.975    30.639
    78.655    30.724
>
    78.640    30.431
    78.655    30.724
>
    78.640    30.431
    78.655    30.724
>
    78.330    30.574
    78.655    30.724
>
    78.330    30.574
    78.655    30.724
>
    78.377    30.921
    78.655    30.724
>
    78.377    30.921
    78.655    30.724
>
    78.205    30.808
    78.655    30.724
>
    78.205    30.808
    78.655    30.724
>
    79.141    30.588
    78.655    30.724
>
    79.141    30.588
    78.655    30.724
>
    79.019    30.389
    78.655    30.724
>
    79.019    30.389
    78.655    30.724
>
    78.244    30.427
    78.655    30.724
>
    78.244    30.427
    78.655    30.724
>
    79.176    30.488
    78.655    30.724
>
    78.103    30.909
    78.655    30.724
>
    78.103    30.909
    78.655    30.724
>
    78.768    30.155
    78.655    30.724
>
    78.768    30.155
    78.655    30.724
>
    78.074    30.455
    78.655    30.724
>
    78.074    30.455
    78.655    30.724
>
    78.287    30.161
    78.655    30.724
>
    79.217    30.265
    78.655    30.724
>
    79.217    30.265
    78.655    30.724
>
    77.873    30.691
    78.655    30.724
>
    77.873    30.691
    78.655    30.724
>
    77.843    30.518
    78.655    30.724
>
    77.843    30.518
    78.655    30.724
>
    77.845    30.934
    78.655    30.724
>
    77.845    30.934
    78.655    30.724
>
    79.049    30.019
    78.655    30.724
>
    79.049    30.019
    78.655    30.724
>
    78.711    29.924
    78.655    30.724
>
    78.711    29.924
    78.655    30.724
>
    80.164    29.905
    80.076    30.017
>
    80.164    29.905
    80.076    30.017
>
    79.900    29.946
    80.076    30.017
>
    79.900    29.946
    80.076    30.017
>
    80.238    30.066
    80.076    30.017
>
    80.238    30.066
    80.076    30.017
>
    80.248    29.803
    80.076    30.017
>
    80.248    29.803
    80.076    30.017
>
    80.040    29.660
    80.076    30.017
>
    80.040    29.660
    80.076    30.017
>
    79.673    29.887
    80.076    30.017
>
    79.673    29.887
    80.076    30.017
>
    79.563    30.001
    80.076    30.017
>
    79.563    30.001
    80.076    30.017
>
    79.595    29.852
    80.076    30.017
>
    79.595    29.852
    80.076    30.017
>
    80.544    29.849
    80.076    30.017
>
    80.544    29.849
    80.076    30.017
>
    80.234    29.552
    80.076    30.017
>
    80.234    29.552
    80.076    30.017
>
    79.648    29.592
    80.076    30.017
>
    79.648    29.592
    80.076    30.017
>
    79.416    30.250
    80.076    30.017
>
    79.416    30.250
    80.076    30.017
>
    80.094    29.403
    80.076    30.017
>
    80.094    29.403
    80.076    30.017
>
    79.930    29.407
    80.076    30.017
>
    79.930    29.407
    80.076    30.017
>
    79.288    30.051
    80.076    30.017
>
    79.288    30.051
    80.076    30.017
>
    79.566    30.538
    80.076    30.017
>
    79.566    30.538
    80.076    30.017
>
    80.107    29.330
    80.076    30.017
>
    79.322    30.406
    80.076    30.017
>
    79.210    29.820
    80.076    30.017
>
    79.210    29.820
    80.076    30.017
>
    79.217    30.265
    80.076    30.017
>
    79.217    30.265
    80.076    30.017
>
    80.217    29.550
    80.076    30.017
>
    80.217    29.550
    80.076    30.017
>
    80.246    29.450
    80.076    30.017
>
    79.558    30.556
    80.076    30.017
>
    79.176    30.488
    79.186    30.482
>
    79.141    30.588
    79.186    30.482
>
    79.141    30.588
    79.186    30.482
>
    79.322    30.406
    79.186    30.482
>
    79.322    30.406
    79.186    30.482
>
    79.019    30.389
    79.186    30.482
>
    79.019    30.389
    79.186    30.482
>
    79.217    30.265
    79.186    30.482
>
    79.217    30.265
    79.186    30.482
>
    78.975    30.639
    79.186    30.482
>
    78.975    30.639
    79.186    30.482
>
    79.416    30.250
    79.186    30.482
>
    79.416    30.250
    79.186    30.482
>
    79.566    30.538
    79.186    30.482
>
    79.566    30.538
    79.186    30.482
>
    79.376    30.145
    79.186    30.482
>
    79.376    30.145
    79.186    30.482
>
    79.288    30.051
    79.186    30.482
>
    79.288    30.051
    79.186    30.482
>
    79.049    30.019
    79.186    30.482
>
    79.049    30.019
    79.186    30.482
>
    78.640    30.431
    79.186    30.482
>
    78.640    30.431
    79.186    30.482
>
    78.649    30.579
    79.186    30.482
>
    78.649    30.579
    79.186    30.482
>
    78.768    30.155
    79.186    30.482
>
    78.768    30.155
    79.186    30.482
>
    79.563    30.001
    79.186    30.482
>
    79.563    30.001
    79.186    30.482
>
    78.918    29.916
    79.186    30.482
>
    78.918    29.916
    79.186    30.482
>
    79.210    29.820
    79.186    30.482
>
    79.210    29.820
    79.186    30.482
>
    78.711    29.924
    79.186    30.482
>
    78.436    30.721
    79.186    30.482
>
    78.436    30.721
    79.186    30.482
>
    79.595    29.852
    79.186    30.482
>
    79.595    29.852
    79.186    30.482
>
    79.673    29.887
    79.186    30.482
>
    79.673    29.887
    79.186    30.482
>
    79.015    29.750
    79.186    30.482
>
    79.015    29.750
    79.186    30.482
>
    78.330    30.574
    79.186    30.482
>
    78.330    30.574
    79.186    30.482
>
    78.680    29.839
    79.186    30.482
>
    78.680    29.839
    79.186    30.482
>
    79.566    30.538
    79.524    30.435
>
    79.566    30.538
    79.524    30.435
>
    79.322    30.406
    79.524    30.435
>
    79.322    30.406
    79.524    30.435
>
    79.416    30.250
    79.524    30.435
>
    79.416    30.250
    79.524    30.435
>
    79.176    30.488
    79.524    30.435
>
    79.176    30.488
    79.524    30.435
>
    79.217    30.265
    79.524    30.435
>
    79.376    30.145
    79.524    30.435
>
    79.376    30.145
    79.524    30.435
>
    79.141    30.588
    79.524    30.435
>
    79.141    30.588
    79.524    30.435
>
    79.288    30.051
    79.524    30.435
>
    79.288    30.051
    79.524    30.435
>
    79.019    30.389
    79.524    30.435
>
    79.019    30.389
    79.524    30.435
>
    79.563    30.001
    79.524    30.435
>
    79.563    30.001
    79.524    30.435
>
    78.975    30.639
    79.524    30.435
>
    78.975    30.639
    79.524    30.435
>
    79.673    29.887
    79.524    30.435
>
    79.673    29.887
    79.524    30.435
>
    79.049    30.019
    79.524    30.435
>
    79.049    30.019
    79.524    30.435
>
    79.595    29.852
    79.524    30.435
>
    79.595    29.852
    79.524    30.435
>
    79.900    29.946
    79.524    30.435
>
    79.900    29.946
    79.524    30.435
>
    79.210    29.820
    79.524    30.435
>
    79.210    29.820
    79.524    30.435
>
    78.768    30.155
    79.524    30.435
>
    78.768    30.155
    79.524    30.435
>
    78.918    29.916
    79.524    30.435
>
    78.918    29.916
    79.524    30.435
>
    80.238    30.066
    79.524    30.435
>
    80.238    30.066
    79.524    30.435
>
    78.640    30.431
    79.524    30.435
>
    78.640    30.431
    79.524    30.435
>
    78.649    30.579
    79.524    30.435
>
    79.900    29.946
    80.047    29.988
>
    79.900    29.946
    80.047    29.988
>
    80.164    29.905
    80.047    29.988
>
    80.164    29.905
    80.047    29.988
>
    80.238    30.066
    80.047    29.988
>
    80.238    30.066
    80.047    29.988
>
    80.248    29.803
    80.047    29.988
>
    80.248    29.803
    80.047    29.988
>
    79.673    29.887
    80.047    29.988
>
    79.673    29.887
    80.047    29.988
>
    80.040    29.660
    80.047    29.988
>
    80.040    29.660
    80.047    29.988
>
    79.595    29.852
    80.047    29.988
>
    79.595    29.852
    80.047    29.988
>
    79.563    30.001
    80.047    29.988
>
    79.563    30.001
    80.047    29.988
>
    80.544    29.849
    80.047    29.988
>
    80.544    29.849
    80.047    29.988
>
    80.234    29.552
    80.047    29.988
>
    80.234    29.552
    80.047    29.988
>
    80.094    29.403
    80.047    29.988
>
    80.094    29.403
    80.047    29.988
>
    79.930    29.407
    80.047    29.988
>
    79.930    29.407
    80.047    29.988
>
    79.288    30.051
    80.047    29.988
>
    79.288    30.051
    80.047    29.988
>
    80.107    29.330
    80.047    29.988
>
    80.107    29.330
    80.047    29.988
>
    79.210    29.820
    80.047    29.988
>
    79.210    29.820
    80.047    29.988
>
    79.217    30.265
    80.047    29.988
>
    79.322    30.406
    79.486    30.448
>
    79.322    30.406
    79.486    30.448
>
    79.416    30.250
    79.486    30.448
>
    79.416    30.250
    79.486    30.448
>
    79.176    30.488
    79.486    30.448
>
    79.176    30.488
    79.486    30.448
>
    79.217    30.265
    79.486    30.448
>
    79.217    30.265
    79.486    30.448
>
    79.376    30.145
    79.486    30.448
>
    79.141    30.588
    79.486    30.448
>
    79.141    30.588
    79.486    30.448
>
    79.019    30.389
    79.486    30.448
>
    79.019    30.389
    79.486    30.448
>
    79.288    30.051
    79.486    30.448
>
    79.288    30.051
    79.486    30.448
>
    79.563    30.001
    79.486    30.448
>
    79.563    30.001
    79.486    30.448
>
    79.049    30.019
    79.486    30.448
>
    79.049    30.019
    79.486    30.448
>
    79.673    29.887
    79.486    30.448
>
    79.673    29.887
    79.486    30.448
>
    79.595    29.852
    79.486    30.448
>
    79.595    29.852
    79.486    30.448
>
    79.210    29.820
    79.486    30.448
>
    79.210    29.820
    79.486    30.448
>
    78.918    29.916
    79.486    30.448
>
    78.918    29.916
    79.486    30.448
>
    78.640    30.431
    79.486    30.448
>
    80.164    29.905
    79.486    30.448
>
    80.164    29.905
    79.486    30.448
>
    79.900    29.946
    79.952    30.094
>
    79.900    29.946
    79.952    30.094
>
    80.238    30.066
    79.952    30.094
>
    80.238    30.066
    79.952    30.094
>
    80.164    29.905
    79.952    30.094
>
    80.164    29.905
    79.952    30.094
>
    79.673    29.887
    79.952    30.094
>
    79.673    29.887
    79.952    30.094
>
    79.563    30.001
    79.952    30.094
>
    79.563    30.001
    79.952    30.094
>
    79.595    29.852
    79.952    30.094
>
    79.595    29.852
    79.952    30.094
>
    80.248    29.803
    79.952    30.094
>
    80.040    29.660
    79.952    30.094
>
    80.040    29.660
    79.952    30.094
>
    79.416    30.250
    79.952    30.094
>
    79.416    30.250
    79.952    30.094
>
    79.376    30.145
    79.952    30.094
>
    79.288    30.051
    79.952    30.094
>
    79.288    30.051
    79.952    30.094
>
    80.234    29.552
    79.952    30.094
>
    80.234    29.552
    79.952    30.094
>
    79.217    30.265
    79.952    30.094
>
    79.217    30.265
    79.952    30.094
>
    79.930    29.407
    79.952    30.094
>
    79.930    29.407
    79.952    30.094
>
    79.210    29.820
    79.952    30.094
>
    79.210    29.820
    79.952    30.094
>
    80.094    29.403
    79.952    30.094
>
    80.094    29.403
    79.952    30.094
>
    80.107    29.330
    79.952    30.094
>
    80.107    29.330
    79.952    30.094
>
    79.176    30.488
    79.952    30.094
>
    79.176    30.488
    79.952    30.094
>
    79.049    30.019
    79.952    30.094
>
    79.049    30.019
    79.952    30.094
>
    78.377    30.921
    78.390    30.882
>
    78.377    30.921
    78.390    30.882
>
    78.436    30.721
    78.390    30.882
>
    78.436    30.721
    78.390    30.882
>
    78.205    30.808
    78.390    30.882
>
    78.205    30.808
    78.390    30.882
>
    78.103    30.909
    78.390    30.882
>
    78.103    30.909
    78.390    30.882
>
    78.330    30.574
    78.390    30.882
>
    78.330    30.574
    78.390    30.882
>
    78.753    31.036
    78.390    30.882
>
    78.753    31.036
    78.390    30.882
>
    78.649    30.579
    78.390    30.882
>
    78.649    30.579
    78.390    30.882
>
    78.640    30.431
    78.390    30.882
>
    78.640    30.431
    78.390    30.882
>
    77.845    30.934
    78.390    30.882
>
    77.845    30.934
    78.390    30.882
>
    77.873    30.691
    78.390    30.882
>
    77.873    30.691
    78.390    30.882
>
    78.074    30.455
    78.390    30.882
>
    78.074    30.455
    78.390    30.882
>
    77.843    30.518
    78.390    30.882
>
    77.843    30.518
    78.390    30.882
>
    79.141    30.588
    78.390    30.882
>
    79.141    30.588
    78.390    30.882
>
    79.019    30.389
    78.390    30.882
>
    79.019    30.389
    78.390    30.882
>
    78.287    30.161
    78.390    30.882
>
    79.176    30.488
    78.390    30.882
>
    78.768    30.155
    78.390    30.882
>
    78.768    30.155
    78.390    30.882
>
    78.250    31.533
    78.390    30.882
>
    78.250    31.533
    78.390    30.882
>
    79.322    30.406
    79.421    30.516
>
    79.322    30.406
    79.421    30.516
>
    79.566    30.538
    79.421    30.516
>
    79.566    30.538
    79.421    30.516
>
    79.416    30.250
    79.421    30.516
>
    79.217    30.265
    79.421    30.516
>
    79.217    30.265
    79.421    30.516
>
    79.376    30.145
    79.421    30.516
>
    79.376    30.145
    79.421    30.516
>
    79.376    30.145
    79.421    30.516
>
    79.019    30.389
    79.421    30.516
>
    79.019    30.389
    79.421    30.516
>
    79.563    30.001
    79.421    30.516
>
    79.563    30.001
    79.421    30.516
>
    79.673    29.887
    79.421    30.516
>
    79.673    29.887
    79.421    30.516
>
    79.595    29.852
    79.421    30.516
>
    79.595    29.852
    79.421    30.516
>
    78.640    30.431
    79.421    30.516
>
    78.640    30.431
    79.421    30.516
>
    78.640    30.431
    78.682    30.516
>
    79.019    30.389
    78.682    30.516
>
    79.019    30.389
    78.682    30.516
>
    78.436    30.721
    78.682    30.516
>
    78.436    30.721
    78.682    30.516
>
    78.287    30.161
    78.682    30.516
>
    78.287    30.161
    78.682    30.516
>
    79.217    30.265
    78.682    30.516
>
    79.217    30.265
    78.682    30.516
>
    78.205    30.808
    78.682    30.516
>
    78.205    30.808
    78.682    30.516
>
    78.074    30.455
    78.682    30.516
>
    78.074    30.455
    78.682    30.516
>
    78.103    30.909
    78.682    30.516
>
    78.103    30.909
    78.682    30.516
>
    79.416    30.250
    78.682    30.516
>
    79.416    30.250
    78.682    30.516
>
    77.873    30.691
    78.682    30.516
>
    77.873    30.691
    78.682    30.516
>
    77.843    30.518
    78.682    30.516
>
    77.843    30.518
    78.682    30.516
>
    80.238    30.066
    80.045    30.145
>
    79.900    29.946
    80.045    30.145
>
    79.900    29.946
    80.045    30.145
>
    80.164    29.905
    80.045    30.145
>
    80.164    29.905
    80.045    30.145
>
    80.248    29.803
    80.045    30.145
>
    80.248    29.803
    80.045    30.145
>
    79.673    29.887
    80.045    30.145
>
    79.673    29.887
    80.045    30.145
>
    79.563    30.001
    80.045    30.145
>
    79.595    29.852
    80.045    30.145
>
    79.595    29.852
    80.045    30.145
>
    80.040    29.660
    80.045    30.145
>
    80.040    29.660
    80.045    30.145
>
    79.416    30.250
    80.045    30.145
>
    79.416    30.250
    80.045    30.145
>
    80.544    29.849
    80.045    30.145
>
    80.544    29.849
    80.045    30.145
>
    79.566    30.538
    80.045    30.145
>
    79.376    30.145
    80.045    30.145
>
    79.566    30.538
    80.045    30.145
>
    79.217    30.265
    80.045    30.145
>
    79.217    30.265
    80.045    30.145
>
    79.930    29.407
    80.045    30.145
>
    79.930    29.407
    80.045    30.145
>
    80.094    29.403
    80.045    30.145
>
    80.094    29.403
    80.045    30.145
>
    80.238    30.066
    80.009    30.140
>
    80.238    30.066
    80.009    30.140
>
    80.164    29.905
    80.009    30.140
>
    79.673    29.887
    80.009    30.140
>
    79.673    29.887
    80.009    30.140
>
    80.248    29.803
    80.009    30.140
>
    80.248    29.803
    80.009    30.140
>
    79.563    30.001
    80.009    30.140
>
    79.563    30.001
    80.009    30.140
>
    79.595    29.852
    80.009    30.140
>
    79.595    29.852
    80.009    30.140
>
    80.040    29.660
    80.009    30.140
>
    79.416    30.250
    80.009    30.140
>
    79.416    30.250
    80.009    30.140
>
    79.376    30.145
    80.009    30.140
>
    79.376    30.145
    80.009    30.140
>
    80.544    29.849
    80.009    30.140
>
    80.544    29.849
    80.009    30.140
>
    79.566    30.538
    80.009    30.140
>
    79.566    30.538
    80.009    30.140
>
    79.322    30.406
    80.009    30.140
>
    79.322    30.406
    80.009    30.140
>
    79.217    30.265
    80.009    30.140
>
    79.217    30.265
    80.009    30.140
>
    80.094    29.403
    80.009    30.140
>
    80.094    29.403
    80.009    30.140
>
    79.416    30.250
    79.511    30.349
>
    79.322    30.406
    79.511    30.349
>
    79.322    30.406
    79.511    30.349
>
    79.566    30.538
    79.511    30.349
>
    79.566    30.538
    79.511    30.349
>
    79.376    30.145
    79.511    30.349
>
    79.376    30.145
    79.511    30.349
>
    79.217    30.265
    79.511    30.349
>
    79.217    30.265
    79.511    30.349
>
    79.563    30.001
    79.511    30.349
>
    79.563    30.001
    79.511    30.349
>
    79.019    30.389
    79.511    30.349
>
    79.019    30.389
    79.511    30.349
>
    79.673    29.887
    79.511    30.349
>
    79.673    29.887
    79.511    30.349
>
    79.595    29.852
    79.511    30.349
>
    79.595    29.852
    79.511    30.349
>
    79.900    29.946
    79.511    30.349
>
    79.900    29.946
    79.511    30.349
>
    80.238    30.066
    79.511    30.349
>
    80.238    30.066
    79.511    30.349
>
    80.164    29.905
    79.511    30.349
>
    80.164    29.905
    79.511    30.349
>
    79.015    29.750
    79.511    30.349
>
    79.015    29.750
    79.511    30.349
>
    78.640    30.431
    79.511    30.349
>
    79.558    30.556
    79.511    30.349
>
    79.558    30.556
    79.511    30.349
>
    78.205    30.808
    78.271    30.916
>
    78.205    30.808
    78.271    30.916
>
    78.103    30.909
    78.271    30.916
>
    78.103    30.909
    78.271    30.916
>
    78.436    30.721
    78.271    30.916
>
    78.436    30.721
    78.271    30.916
>
    78.330    30.574
    78.271    30.916
>
    78.330    30.574
    78.271    30.916
>
    77.845    30.934
    78.271    30.916
>
    77.845    30.934
    78.271    30.916
>
    78.753    31.036
    78.271    30.916
>
    78.753    31.036
    78.271    30.916
>
    77.873    30.691
    78.271    30.916
>
    77.873    30.691
    78.271    30.916
>
    78.074    30.455
    78.271    30.916
>
    78.074    30.455
    78.271    30.916
>
    77.843    30.518
    78.271    30.916
>
    77.843    30.518
    78.271    30.916
>
    78.640    30.431
    78.271    30.916
>
    78.640    30.431
    78.271    30.916
>
    78.287    30.161
    78.271    30.916
>
    79.900    29.946
    79.950    30.019
>
    80.164    29.905
    79.950    30.019
>
    80.164    29.905
    79.950    30.019
>
    80.238    30.066
    79.950    30.019
>
    80.238    30.066
    79.950    30.019
>
    79.673    29.887
    79.950    30.019
>
    79.673    29.887
    79.950    30.019
>
    79.563    30.001
    79.950    30.019
>
    79.563    30.001
    79.950    30.019
>
    79.595    29.852
    79.950    30.019
>
    79.595    29.852
    79.950    30.019
>
    80.040    29.660
    79.950    30.019
>
    80.040    29.660
    79.950    30.019
>
    79.416    30.250
    79.950    30.019
>
    79.416    30.250
    79.950    30.019
>
    79.376    30.145
    79.950    30.019
>
    79.376    30.145
    79.950    30.019
>
    80.544    29.849
    79.950    30.019
>
    80.544    29.849
    79.950    30.019
>
    79.566    30.538
    79.950    30.019
>
    80.094    29.403
    79.950    30.019
>
    80.094    29.403
    79.950    30.019
>
    79.322    30.406
    79.950    30.019
>
    79.322    30.406
    79.950    30.019
>
    79.217    30.265
    79.950    30.019
>
    79.217    30.265
    79.950    30.019
>
    79.457    29.359
    79.950    30.019
>
    79.457    29.359
    79.950    30.019
>
    79.176    30.488
    79.253    30.561
>
    79.176    30.488
    79.253    30.561
>
    79.141    30.588
    79.253    30.561
>
    79.141    30.588
    79.253    30.561
>
    79.322    30.406
    79.253    30.561
>
    79.322    30.406
    79.253    30.561
>
    79.019    30.389
    79.253    30.561
>
    79.019    30.389
    79.253    30.561
>
    79.566    30.538
    79.253    30.561
>
    79.566    30.538
    79.253    30.561
>
    79.217    30.265
    79.253    30.561
>
    79.217    30.265
    79.253    30.561
>
    79.416    30.250
    79.253    30.561
>
    79.416    30.250
    79.253    30.561
>
    79.376    30.145
    79.253    30.561
>
    79.376    30.145
    79.253    30.561
>
    78.649    30.579
    79.253    30.561
>
    78.649    30.579
    79.253    30.561
>
    78.640    30.431
    79.253    30.561
>
    78.640    30.431
    79.253    30.561
>
    78.753    31.036
    79.253    30.561
>
    78.918    29.916
    79.253    30.561
>
    78.436    30.721
    79.253    30.561
>
    78.436    30.721
    79.253    30.561
>
    79.210    29.820
    79.253    30.561
>
    79.673    29.887
    79.253    30.561
>
    79.673    29.887
    79.253    30.561
>
    79.595    29.852
    79.253    30.561
>
    79.595    29.852
    79.253    30.561
>
    78.330    30.574
    79.253    30.561
>
    78.330    30.574
    79.253    30.561
>
    79.558    30.556
    79.253    30.561
>
    79.558    30.556
    79.253    30.561
>
    78.446    30.730
    79.253    30.561
>
    80.238    30.066
    80.244    30.006
>
    80.238    30.066
    80.244    30.006
>
    80.164    29.905
    80.244    30.006
>
    80.164    29.905
    80.244    30.006
>
    80.248    29.803
    80.244    30.006
>
    80.248    29.803
    80.244    30.006
>
    79.900    29.946
    80.244    30.006
>
    80.544    29.849
    80.244    30.006
>
    80.544    29.849
    80.244    30.006
>
    80.040    29.660
    80.244    30.006
>
    80.040    29.660
    80.244    30.006
>
    80.234    29.552
    80.244    30.006
>
    80.234    29.552
    80.244    30.006
>
    79.673    29.887
    80.244    30.006
>
    79.673    29.887
    80.244    30.006
>
    79.595    29.852
    80.244    30.006
>
    79.595    29.852
    80.244    30.006
>
    79.563    30.001
    80.244    30.006
>
    80.094    29.403
    80.244    30.006
>
    80.094    29.403
    80.244    30.006
>
    79.930    29.407
    80.244    30.006
>
    79.930    29.407
    80.244    30.006
>
    80.107    29.330
    80.244    30.006
>
    80.107    29.330
    80.244    30.006
>
    79.566    30.538
    80.244    30.006
>
    79.566    30.538
    80.244    30.006
>
    79.141    30.588
    78.943    30.662
>
    79.141    30.588
    78.943    30.662
>
    79.176    30.488
    78.943    30.662
>
    79.176    30.488
    78.943    30.662
>
    79.019    30.389
    78.943    30.662
>
    79.019    30.389
    78.943    30.662
>
    78.649    30.579
    78.943    30.662
>
    78.649    30.579
    78.943    30.662
>
    78.640    30.431
    78.943    30.662
>
    78.640    30.431
    78.943    30.662
>
    79.217    30.265
    78.943    30.662
>
    79.217    30.265
    78.943    30.662
>
    78.436    30.721
    78.943    30.662
>
    78.436    30.721
    78.943    30.662
>
    78.768    30.155
    78.943    30.662
>
    78.768    30.155
    78.943    30.662
>
    78.330    30.574
    78.943    30.662
>
    78.330    30.574
    78.943    30.662
>
    78.918    29.916
    78.943    30.662
>
    78.918    29.916
    78.943    30.662
>
    78.711    29.924
    78.943    30.662
>
    78.711    29.924
    78.943    30.662
>
    80.238    30.066
    80.199    30.008
>
    80.238    30.066
    80.199    30.008
>
    80.164    29.905
    80.199    30.008
>
    80.164    29.905
    80.199    30.008
>
    80.248    29.803
    80.199    30.008
>
    80.248    29.803
    80.199    30.008
>
    80.544    29.849
    80.199    30.008
>
    80.544    29.849
    80.199    30.008
>
    80.040    29.660
    80.199    30.008
>
    80.040    29.660
    80.199    30.008
>
    80.234    29.552
    80.199    30.008
>
    80.234    29.552
    80.199    30.008
>
    79.673    29.887
    80.199    30.008
>
    79.673    29.887
    80.199    30.008
>
    79.595    29.852
    80.199    30.008
>
    79.595    29.852
    80.199    30.008
>
    79.563    30.001
    80.199    30.008
>
    79.563    30.001
    80.199    30.008
>
    80.094    29.403
    80.199    30.008
>
    80.094    29.403
    80.199    30.008
>
    79.930    29.407
    80.199    30.008
>
    79.930    29.407
    80.199    30.008
>
    80.107    29.330
    80.199    30.008
>
    80.107    29.330
    80.199    30.008
>
    79.376    30.145
    80.199    30.008
>
    79.376    30.145
    80.199    30.008
>
    79.566    30.538
    80.199    30.008
>
    79.566    30.538
    80.199    30.008
>
    80.246    29.450
    80.199    30.008
>
    80.246    29.450
    80.199    30.008
>
    79.558    30.556
    80.199    30.008
>
    80.544    29.849
    80.440    29.866
>
    80.544    29.849
    80.440    29.866
>
    80.248    29.803
    80.440    29.866
>
    80.248    29.803
    80.440    29.866
>
    80.164    29.905
    80.440    29.866
>
    80.164    29.905
    80.440    29.866
>
    80.238    30.066
    80.440    29.866
>
    80.238    30.066
    80.440    29.866
>
    80.234    29.552
    80.440    29.866
>
    80.234    29.552
    80.440    29.866
>
    80.040    29.660
    80.440    29.866
>
    80.040    29.660
    80.440    29.866
>
    80.094    29.403
    80.440    29.866
>
    80.094    29.403
    80.440    29.866
>
    80.107    29.330
    80.440    29.866
>
    80.107    29.330
    80.440    29.866
>
    79.930    29.407
    80.440    29.866
>
    79.930    29.407
    80.440    29.866
>
    79.566    30.538
    79.553    30.441
>
    79.566    30.538
    79.553    30.441
>
    79.322    30.406
    79.553    30.441
>
    79.322    30.406
    79.553    30.441
>
    79.416    30.250
    79.553    30.441
>
    79.416    30.250
    79.553    30.441
>
    79.176    30.488
    79.553    30.441
>
    79.176    30.488
    79.553    30.441
>
    79.217    30.265
    79.553    30.441
>
    79.217    30.265
    79.553    30.441
>
    79.376    30.145
    79.553    30.441
>
    79.376    30.145
    79.553    30.441
>
    79.019    30.389
    79.553    30.441
>
    79.019    30.389
    79.553    30.441
>
    79.288    30.051
    79.553    30.441
>
    79.288    30.051
    79.553    30.441
>
    78.649    30.579
    79.553    30.441
>
    78.649    30.579
    79.553    30.441
>
    80.164    29.905
    79.553    30.441
>
    79.176    30.488
    79.247    30.495
>
    79.176    30.488
    79.247    30.495
>
    79.322    30.406
    79.247    30.495
>
    79.322    30.406
    79.247    30.495
>
    79.141    30.588
    79.247    30.495
>
    79.141    30.588
    79.247    30.495
>
    79.019    30.389
    79.247    30.495
>
    79.019    30.389
    79.247    30.495
>
    79.217    30.265
    79.247    30.495
>
    79.217    30.265
    79.247    30.495
>
    79.416    30.250
    79.247    30.495
>
    79.416    30.250
    79.247    30.495
>
    79.566    30.538
    79.247    30.495
>
    79.566    30.538
    79.247    30.495
>
    79.376    30.145
    79.247    30.495
>
    79.376    30.145
    79.247    30.495
>
    79.288    30.051
    79.247    30.495
>
    79.288    30.051
    79.247    30.495
>
    78.768    30.155
    79.247    30.495
>
    78.768    30.155
    79.247    30.495
>
    78.640    30.431
    79.247    30.495
>
    78.640    30.431
    79.247    30.495
>
    78.649    30.579
    79.247    30.495
>
    78.649    30.579
    79.247    30.495
>
    79.558    30.556
    79.247    30.495
>
    79.558    30.556
    79.247    30.495
>
    79.322    30.406
    79.554    30.461
>
    79.322    30.406
    79.554    30.461
>
    79.416    30.250
    79.554    30.461
>
    79.416    30.250
    79.554    30.461
>
    79.176    30.488
    79.554    30.461
>
    79.176    30.488
    79.554    30.461
>
    79.376    30.145
    79.554    30.461
>
    79.376    30.145
    79.554    30.461
>
    79.217    30.265
    79.554    30.461
>
    79.217    30.265
    79.554    30.461
>
    79.141    30.588
    79.554    30.461
>
    79.141    30.588
    79.554    30.461
>
    79.288    30.051
    79.554    30.461
>
    79.288    30.051
    79.554    30.461
>
    79.019    30.389
    79.554    30.461
>
    79.019    30.389
    79.554    30.461
>
    79.900    29.946
    79.554    30.461
>
    80.238    30.066
    79.554    30.461
>
    80.238    30.066
    79.554    30.461
>
    78.768    30.155
    79.554    30.461
>
    78.768    30.155
    79.554    30.461
>
    78.640    30.431
    79.554    30.461
>
    78.640    30.431
    79.554    30.461
>
    78.640    30.431
    79.554    30.461
>
    78.649    30.579
    79.554    30.461
>
    78.649    30.579
    79.554    30.461
>
    79.176    30.488
    79.260    30.479
>
    79.176    30.488
    79.260    30.479
>
    79.322    30.406
    79.260    30.479
>
    79.322    30.406
    79.260    30.479
>
    79.141    30.588
    79.260    30.479
>
    79.141    30.588
    79.260    30.479
>
    79.217    30.265
    79.260    30.479
>
    79.217    30.265
    79.260    30.479
>
    79.019    30.389
    79.260    30.479
>
    79.019    30.389
    79.260    30.479
>
    79.566    30.538
    79.260    30.479
>
    79.566    30.538
    79.260    30.479
>
    79.416    30.250
    79.260    30.479
>
    79.416    30.250
    79.260    30.479
>
    79.049    30.019
    79.260    30.479
>
    79.049    30.019
    79.260    30.479
>
    78.640    30.431
    79.260    30.479
>
    78.640    30.431
    79.260    30.479
>
    79.563    30.001
    79.260    30.479
>
    79.563    30.001
    79.260    30.479
>
    79.210    29.820
    79.260    30.479
>
    79.176    30.488
    79.249    30.477
>
    79.176    30.488
    79.249    30.477
>
    79.322    30.406
    79.249    30.477
>
    79.322    30.406
    79.249    30.477
>
    79.141    30.588
    79.249    30.477
>
    79.141    30.588
    79.249    30.477
>
    79.217    30.265
    79.249    30.477
>
    79.217    30.265
    79.249    30.477
>
    79.019    30.389
    79.249    30.477
>
    79.019    30.389
    79.249    30.477
>
    79.416    30.250
    79.249    30.477
>
    79.416    30.250
    79.249    30.477
>
    79.288    30.051
    79.249    30.477
>
    79.049    30.019
    79.249    30.477
>
    79.049    30.019
    79.249    30.477
>
    78.768    30.155
    79.249    30.477
>
    78.768    30.155
    79.249    30.477
>
    78.640    30.431
    79.249    30.477
>
    78.649    30.579
    79.249    30.477
>
    79.563    30.001
    79.249    30.477
>
    79.563    30.001
    79.249    30.477
>
    78.918    29.916
    79.249    30.477
>
    78.918    29.916
    79.249    30.477
>
    78.605    30.144
    79.249    30.477
>
    78.605    30.144
    79.249    30.477
>
    79.595    29.852
    79.249    30.477
>
    79.595    29.852
    79.249    30.477
>
    79.673    29.887
    79.249    30.477
>
    79.673    29.887
    79.249    30.477
>
    78.711    29.924
    79.249    30.477
>
    78.711    29.924
    79.249    30.477
>
    79.015    29.750
    79.249    30.477
>
    79.015    29.750
    79.249    30.477
>
    78.378    30.508
    79.249    30.477
>
    78.378    30.508
    79.249    30.477
>
    79.416    30.250
    79.474    30.377
>
    79.416    30.250
    79.474    30.377
>
    79.322    30.406
    79.474    30.377
>
    79.322    30.406
    79.474    30.377
>
    79.566    30.538
    79.474    30.377
>
    79.566    30.538
    79.474    30.377
>
    79.376    30.145
    79.474    30.377
>
    79.376    30.145
    79.474    30.377
>
    79.217    30.265
    79.474    30.377
>
    79.217    30.265
    79.474    30.377
>
    79.176    30.488
    79.474    30.377
>
    79.176    30.488
    79.474    30.377
>
    79.288    30.051
    79.474    30.377
>
    79.288    30.051
    79.474    30.377
>
    79.141    30.588
    79.474    30.377
>
    79.141    30.588
    79.474    30.377
>
    79.563    30.001
    79.474    30.377
>
    79.563    30.001
    79.474    30.377
>
    79.019    30.389
    79.474    30.377
>
    79.049    30.019
    79.474    30.377
>
    79.049    30.019
    79.474    30.377
>
    79.673    29.887
    79.474    30.377
>
    79.673    29.887
    79.474    30.377
>
    79.595    29.852
    79.474    30.377
>
    79.595    29.852
    79.474    30.377
>
    79.900    29.946
    79.474    30.377
>
    79.900    29.946
    79.474    30.377
>
    79.210    29.820
    79.474    30.377
>
    79.210    29.820
    79.474    30.377
>
    78.768    30.155
    79.474    30.377
>
    78.768    30.155
    79.474    30.377
>
    78.918    29.916
    79.474    30.377
>
    78.918    29.916
    79.474    30.377
>
    78.640    30.431
    79.474    30.377
>
    78.640    30.431
    79.474    30.377
>
    79.015    29.750
    79.474    30.377
>
    79.015    29.750
    79.474    30.377
>
    80.164    29.905
    79.474    30.377
>
    80.164    29.905
    79.474    30.377
>
    78.605    30.144
    79.474    30.377
>
    78.605    30.144
    79.474    30.377
>
    79.176    30.488
    79.249    30.487
>
    79.176    30.488
    79.249    30.487
>
    79.322    30.406
    79.249    30.487
>
    79.322    30.406
    79.249    30.487
>
    79.141    30.588
    79.249    30.487
>
    79.141    30.588
    79.249    30.487
>
    79.217    30.265
    79.249    30.487
>
    79.217    30.265
    79.249    30.487
>
    79.019    30.389
    79.249    30.487
>
    79.019    30.389
    79.249    30.487
>
    79.416    30.250
    79.249    30.487
>
    79.416    30.250
    79.249    30.487
>
    79.566    30.538
    79.249    30.487
>
    79.566    30.538
    79.249    30.487
>
    79.376    30.145
    79.249    30.487
>
    79.288    30.051
    79.249    30.487
>
    79.288    30.051
    79.249    30.487
>
    79.049    30.019
    79.249    30.487
>
    79.049    30.019
    79.249    30.487
>
    78.768    30.155
    79.249    30.487
>
    78.768    30.155
    79.249    30.487
>
    78.640    30.431
    79.249    30.487
>
    78.640    30.431
    79.249    30.487
>
    78.918    29.916
    79.249    30.487
>
    78.918    29.916
    79.249    30.487
>
    78.605    30.144
    79.249    30.487
>
    78.605    30.144
    79.249    30.487
>
    79.210    29.820
    79.249    30.487
>
    79.210    29.820
    79.249    30.487
>
    79.595    29.852
    79.249    30.487
>
    79.673    29.887
    79.249    30.487
>
    79.015    29.750
    79.249    30.487
>
    78.378    30.508
    79.249    30.487
>
    78.378    30.508
    79.249    30.487
>
    80.238    30.066
    80.051    30.084
>
    80.238    30.066
    80.051    30.084
>
    79.900    29.946
    80.051    30.084
>
    79.900    29.946
    80.051    30.084
>
    80.248    29.803
    80.051    30.084
>
    80.248    29.803
    80.051    30.084
>
    79.673    29.887
    80.051    30.084
>
    79.673    29.887
    80.051    30.084
>
    79.563    30.001
    80.051    30.084
>
    79.563    30.001
    80.051    30.084
>
    80.040    29.660
    80.051    30.084
>
    80.040    29.660
    80.051    30.084
>
    79.595    29.852
    80.051    30.084
>
    79.595    29.852
    80.051    30.084
>
    80.544    29.849
    80.051    30.084
>
    80.544    29.849
    80.051    30.084
>
    80.234    29.552
    80.051    30.084
>
    80.234    29.552
    80.051    30.084
>
    79.376    30.145
    80.051    30.084
>
    79.376    30.145
    80.051    30.084
>
    79.288    30.051
    80.051    30.084
>
    79.288    30.051
    80.051    30.084
>
    80.094    29.403
    80.051    30.084
>
    80.094    29.403
    80.051    30.084
>
    79.930    29.407
    80.051    30.084
>
    79.930    29.407
    80.051    30.084
>
    79.322    30.406
    80.051    30.084
>
    79.322    30.406
    80.051    30.084
>
    79.217    30.265
    80.051    30.084
>
    79.217    30.265
    80.051    30.084
>
    80.107    29.330
    80.051    30.084
>
    80.107    29.330
    80.051    30.084
>
    79.210    29.820
    80.051    30.084
>
    79.210    29.820
    80.051    30.084
>
    79.900    29.946
    80.047    29.992
>
    79.900    29.946
    80.047    29.992
>
    80.164    29.905
    80.047    29.992
>
    80.164    29.905
    80.047    29.992
>
    80.238    30.066
    80.047    29.992
>
    80.238    30.066
    80.047    29.992
>
    80.049    29.775
    80.047    29.992
>
    80.049    29.775
    80.047    29.992
>
    80.248    29.803
    80.047    29.992
>
    80.248    29.803
    80.047    29.992
>
    79.673    29.887
    80.047    29.992
>
    79.673    29.887
    80.047    29.992
>
    80.040    29.660
    80.047    29.992
>
    80.040    29.660
    80.047    29.992
>
    79.595    29.852
    80.047    29.992
>
    79.595    29.852
    80.047    29.992
>
    79.563    30.001
    80.047    29.992
>
    79.563    30.001
    80.047    29.992
>
    80.544    29.849
    80.047    29.992
>
    80.544    29.849
    80.047    29.992
>
    79.376    30.145
    80.047    29.992
>
    79.288    30.051
    80.047    29.992
>
    79.288    30.051
    80.047    29.992
>
    79.210    29.820
    80.047    29.992
>
    79.210    29.820
    80.047    29.992
>
    79.322    30.406
    80.047    29.992
>
    79.322    30.406
    80.047    29.992
>
    79.217    30.265
    80.047    29.992
>
    79.547    29.355
    80.047    29.992
>
    79.547    29.355
    80.047    29.992
>
    79.176    30.488
    79.192    30.502
>
    79.176    30.488
    79.192    30.502
>
    79.141    30.588
    79.192    30.502
>
    79.141    30.588
    79.192    30.502
>
    79.322    30.406
    79.192    30.502
>
    79.322    30.406
    79.192    30.502
>
    79.019    30.389
    79.192    30.502
>
    79.019    30.389
    79.192    30.502
>
    79.217    30.265
    79.192    30.502
>
    79.217    30.265
    79.192    30.502
>
    78.649    30.579
    79.192    30.502
>
    78.649    30.579
    79.192    30.502
>
    78.640    30.431
    79.192    30.502
>
    78.640    30.431
    79.192    30.502
>
    79.049    30.019
    79.192    30.502
>
    79.049    30.019
    79.192    30.502
>
    78.768    30.155
    79.192    30.502
>
    78.768    30.155
    79.192    30.502
>
    78.605    30.144
    79.192    30.502
>
    78.605    30.144
    79.192    30.502
>
    79.210    29.820
    79.192    30.502
>
    79.210    29.820
    79.192    30.502
>
    78.378    30.508
    79.192    30.502
>
    78.378    30.508
    79.192    30.502
>
    79.595    29.852
    79.192    30.502
>
    79.595    29.852
    79.192    30.502
>
    79.015    29.750
    79.192    30.502
>
    79.015    29.750
    79.192    30.502
>
    78.680    29.839
    79.192    30.502
>
    79.176    30.488
    79.199    30.494
>
    79.176    30.488
    79.199    30.494
>
    79.141    30.588
    79.199    30.494
>
    79.141    30.588
    79.199    30.494
>
    79.322    30.406
    79.199    30.494
>
    79.322    30.406
    79.199    30.494
>
    79.019    30.389
    79.199    30.494
>
    79.019    30.389
    79.199    30.494
>
    79.217    30.265
    79.199    30.494
>
    79.217    30.265
    79.199    30.494
>
    79.376    30.145
    79.199    30.494
>
    79.376    30.145
    79.199    30.494
>
    79.288    30.051
    79.199    30.494
>
    79.288    30.051
    79.199    30.494
>
    78.649    30.579
    79.199    30.494
>
    78.649    30.579
    79.199    30.494
>
    79.049    30.019
    79.199    30.494
>
    79.049    30.019
    79.199    30.494
>
    78.640    30.431
    79.199    30.494
>
    78.640    30.431
    79.199    30.494
>
    78.768    30.155
    79.199    30.494
>
    78.768    30.155
    79.199    30.494
>
    79.563    30.001
    79.199    30.494
>
    78.605    30.144
    79.199    30.494
>
    78.605    30.144
    79.199    30.494
>
    78.918    29.916
    79.199    30.494
>
    78.918    29.916
    79.199    30.494
>
    79.210    29.820
    79.199    30.494
>
    79.210    29.820
    79.199    30.494
>
    78.429    30.373
    79.199    30.494
>
    78.429    30.373
    79.199    30.494
>
    78.436    30.721
    79.199    30.494
>
    78.436    30.721
    79.199    30.494
>
    78.711    29.924
    79.199    30.494
>
    78.711    29.924
    79.199    30.494
>
    78.378    30.508
    79.199    30.494
>
    78.378    30.508
    79.199    30.494
>
    79.595    29.852
    79.199    30.494
>
    79.595    29.852
    79.199    30.494
>
    79.673    29.887
    79.199    30.494
>
    79.673    29.887
    79.199    30.494
>
    79.015    29.750
    79.199    30.494
>
    79.015    29.750
    79.199    30.494
>
    78.680    29.839
    79.199    30.494
>
    78.680    29.839
    79.199    30.494
>
    79.322    30.406
    79.371    30.533
>
    79.322    30.406
    79.371    30.533
>
    79.176    30.488
    79.371    30.533
>
    79.176    30.488
    79.371    30.533
>
    79.141    30.588
    79.371    30.533
>
    79.141    30.588
    79.371    30.533
>
    79.217    30.265
    79.371    30.533
>
    79.217    30.265
    79.371    30.533
>
    79.019    30.389
    79.371    30.533
>
    79.019    30.389
    79.371    30.533
>
    79.376    30.145
    79.371    30.533
>
    79.376    30.145
    79.371    30.533
>
    79.288    30.051
    79.371    30.533
>
    79.288    30.051
    79.371    30.533
>
    79.563    30.001
    79.371    30.533
>
    79.563    30.001
    79.371    30.533
>
    79.049    30.019
    79.371    30.533
>
    79.049    30.019
    79.371    30.533
>
    78.649    30.579
    79.371    30.533
>
    78.649    30.579
    79.371    30.533
>
    78.768    30.155
    79.371    30.533
>
    78.768    30.155
    79.371    30.533
>
    79.673    29.887
    79.371    30.533
>
    79.595    29.852
    79.371    30.533
>
    79.595    29.852
    79.371    30.533
>
    79.210    29.820
    79.371    30.533
>
    79.210    29.820
    79.371    30.533
>
    78.918    29.916
    79.371    30.533
>
    78.918    29.916
    79.371    30.533
>
    79.900    29.946
    79.371    30.533
>
    78.753    31.036
    79.371    30.533
>
    78.605    30.144
    79.371    30.533
>
    78.605    30.144
    79.371    30.533
>
    79.322    30.406
    79.385    30.543
>
    79.322    30.406
    79.385    30.543
>
    79.176    30.488
    79.385    30.543
>
    79.176    30.488
    79.385    30.543
>
    79.141    30.588
    79.385    30.543
>
    79.141    30.588
    79.385    30.543
>
    79.217    30.265
    79.385    30.543
>
    79.217    30.265
    79.385    30.543
>
    79.019    30.389
    79.385    30.543
>
    79.019    30.389
    79.385    30.543
>
    79.376    30.145
    79.385    30.543
>
    79.376    30.145
    79.385    30.543
>
    79.288    30.051
    79.385    30.543
>
    79.288    30.051
    79.385    30.543
>
    79.563    30.001
    79.385    30.543
>
    79.563    30.001
    79.385    30.543
>
    79.049    30.019
    79.385    30.543
>
    79.049    30.019
    79.385    30.543
>
    78.649    30.579
    79.385    30.543
>
    78.649    30.579
    79.385    30.543
>
    78.768    30.155
    79.385    30.543
>
    78.768    30.155
    79.385    30.543
>
    79.673    29.887
    79.385    30.543
>
    79.673    29.887
    79.385    30.543
>
    79.595    29.852
    79.385    30.543
>
    79.595    29.852
    79.385    30.543
>
    79.210    29.820
    79.385    30.543
>
    79.210    29.820
    79.385    30.543
>
    78.918    29.916
    79.385    30.543
>
    78.918    29.916
    79.385    30.543
>
    79.900    29.946
    79.385    30.543
>
    78.605    30.144
    79.385    30.543
>
    78.605    30.144
    79.385    30.543
>
    79.322    30.406
    79.391    30.551
>
    79.322    30.406
    79.391    30.551
>
    79.176    30.488
    79.391    30.551
>
    79.176    30.488
    79.391    30.551
>
    79.176    30.488
    79.391    30.551
>
    79.141    30.588
    79.391    30.551
>
    79.141    30.588
    79.391    30.551
>
    79.217    30.265
    79.391    30.551
>
    79.217    30.265
    79.391    30.551
>
    79.019    30.389
    79.391    30.551
>
    79.019    30.389
    79.391    30.551
>
    79.376    30.145
    79.391    30.551
>
    79.376    30.145
    79.391    30.551
>
    79.288    30.051
    79.391    30.551
>
    79.563    30.001
    79.391    30.551
>
    79.563    30.001
    79.391    30.551
>
    79.049    30.019
    79.391    30.551
>
    79.049    30.019
    79.391    30.551
>
    78.649    30.579
    79.391    30.551
>
    78.649    30.579
    79.391    30.551
>
    78.768    30.155
    79.391    30.551
>
    78.768    30.155
    79.391    30.551
>
    79.673    29.887
    79.391    30.551
>
    79.673    29.887
    79.391    30.551
>
    79.595    29.852
    79.391    30.551
>
    79.595    29.852
    79.391    30.551
>
    79.210    29.820
    79.391    30.551
>
    79.210    29.820
    79.391    30.551
>
    79.900    29.946
    79.391    30.551
>
    78.605    30.144
    79.391    30.551
>
    79.176    30.488
    79.246    30.473
>
    79.176    30.488
    79.246    30.473
>
    79.322    30.406
    79.246    30.473
>
    79.322    30.406
    79.246    30.473
>
    79.141    30.588
    79.246    30.473
>
    79.141    30.588
    79.246    30.473
>
    79.217    30.265
    79.246    30.473
>
    79.217    30.265
    79.246    30.473
>
    79.019    30.389
    79.246    30.473
>
    79.019    30.389
    79.246    30.473
>
    78.975    30.639
    79.246    30.473
>
    78.975    30.639
    79.246    30.473
>
    79.376    30.145
    79.246    30.473
>
    79.376    30.145
    79.246    30.473
>
    79.288    30.051
    79.246    30.473
>
    79.288    30.051
    79.246    30.473
>
    79.049    30.019
    79.246    30.473
>
    79.049    30.019
    79.246    30.473
>
    78.768    30.155
    79.246    30.473
>
    78.768    30.155
    79.246    30.473
>
    78.649    30.579
    79.246    30.473
>
    78.649    30.579
    79.246    30.473
>
    79.563    30.001
    79.246    30.473
>
    79.563    30.001
    79.246    30.473
>
    78.918    29.916
    79.246    30.473
>
    78.918    29.916
    79.246    30.473
>
    78.605    30.144
    79.246    30.473
>
    78.605    30.144
    79.246    30.473
>
    79.210    29.820
    79.246    30.473
>
    79.210    29.820
    79.246    30.473
>
    79.595    29.852
    79.246    30.473
>
    79.595    29.852
    79.246    30.473
>
    79.673    29.887
    79.246    30.473
>
    79.673    29.887
    79.246    30.473
>
    79.416    29.770
    79.246    30.473
>
    79.416    29.770
    79.246    30.473
>
    79.015    29.750
    79.246    30.473
>
    79.015    29.750
    79.246    30.473
>
    78.436    30.721
    79.246    30.473
>
    78.436    30.721
    79.246    30.473
>
    79.900    29.946
    79.246    30.473
>
    79.176    30.488
    79.257    30.551
>
    79.176    30.488
    79.257    30.551
>
    79.141    30.588
    79.257    30.551
>
    79.141    30.588
    79.257    30.551
>
    79.322    30.406
    79.257    30.551
>
    79.322    30.406
    79.257    30.551
>
    79.019    30.389
    79.257    30.551
>
    79.019    30.389
    79.257    30.551
>
    78.975    30.639
    79.257    30.551
>
    78.975    30.639
    79.257    30.551
>
    79.217    30.265
    79.257    30.551
>
    79.217    30.265
    79.257    30.551
>
    79.376    30.145
    79.257    30.551
>
    79.376    30.145
    79.257    30.551
>
    79.288    30.051
    79.257    30.551
>
    79.288    30.051
    79.257    30.551
>
    78.649    30.579
    79.257    30.551
>
    78.649    30.579
    79.257    30.551
>
    79.049    30.019
    79.257    30.551
>
    79.049    30.019
    79.257    30.551
>
    78.768    30.155
    79.257    30.551
>
    78.768    30.155
    79.257    30.551
>
    79.563    30.001
    79.257    30.551
>
    79.563    30.001
    79.257    30.551
>
    78.753    31.036
    79.257    30.551
>
    78.753    31.036
    79.257    30.551
>
    78.605    30.144
    79.257    30.551
>
    78.605    30.144
    79.257    30.551
>
    78.918    29.916
    79.257    30.551
>
    78.918    29.916
    79.257    30.551
>
    79.210    29.820
    79.257    30.551
>
    79.210    29.820
    79.257    30.551
>
    78.436    30.721
    79.257    30.551
>
    78.436    30.721
    79.257    30.551
>
    78.429    30.373
    79.257    30.551
>
    78.429    30.373
    79.257    30.551
>
    79.673    29.887
    79.257    30.551
>
    79.595    29.852
    79.257    30.551
>
    79.595    29.852
    79.257    30.551
>
    79.416    29.770
    79.257    30.551
>
    79.416    29.770
    79.257    30.551
>
    78.649    30.579
    78.858    30.618
>
    78.649    30.579
    78.858    30.618
>
    79.019    30.389
    78.858    30.618
>
    79.019    30.389
    78.858    30.618
>
    79.176    30.488
    78.858    30.618
>
    79.176    30.488
    78.858    30.618
>
    79.217    30.265
    78.858    30.618
>
    79.217    30.265
    78.858    30.618
>
    78.205    30.808
    78.858    30.618
>
    79.288    30.051
    78.858    30.618
>
    78.074    30.455
    78.858    30.618
>
    78.074    30.455
    78.858    30.618
>
    80.164    29.905
    80.265    29.954
>
    80.164    29.905
    80.265    29.954
>
    80.238    30.066
    80.265    29.954
>
    80.238    30.066
    80.265    29.954
>
    80.248    29.803
    80.265    29.954
>
    80.248    29.803
    80.265    29.954
>
    80.049    29.775
    80.265    29.954
>
    80.049    29.775
    80.265    29.954
>
    79.900    29.946
    80.265    29.954
>
    79.900    29.946
    80.265    29.954
>
    80.094    29.403
    80.265    29.954
>
    80.094    29.403
    80.265    29.954
>
    79.595    29.852
    80.265    29.954
>
    79.595    29.852
    80.265    29.954
>
    79.563    30.001
    80.265    29.954
>
    80.107    29.330
    80.265    29.954
>
    80.107    29.330
    80.265    29.954
>
    78.649    30.579
    78.634    30.545
>
    78.649    30.579
    78.634    30.545
>
    78.436    30.721
    78.634    30.545
>
    78.436    30.721
    78.634    30.545
>
    79.019    30.389
    78.634    30.545
>
    79.019    30.389
    78.634    30.545
>
    78.605    30.144
    78.634    30.545
>
    78.605    30.144
    78.634    30.545
>
    78.205    30.808
    78.634    30.545
>
    78.205    30.808
    78.634    30.545
>
    77.873    30.691
    78.634    30.545
>
    77.873    30.691
    78.634    30.545
>
    77.843    30.518
    78.634    30.545
>
    77.843    30.518
    78.634    30.545
>
    78.680    29.839
    78.634    30.545
>
    78.680    29.839
    78.634    30.545
>
    80.238    30.066
    80.079    30.058
>
    80.238    30.066
    80.079    30.058
>
    80.164    29.905
    80.079    30.058
>
    80.164    29.905
    80.079    30.058
>
    79.900    29.946
    80.079    30.058
>
    79.900    29.946
    80.079    30.058
>
    80.049    29.775
    80.079    30.058
>
    80.049    29.775
    80.079    30.058
>
    80.248    29.803
    80.079    30.058
>
    80.248    29.803
    80.079    30.058
>
    80.040    29.660
    80.079    30.058
>
    80.040    29.660
    80.079    30.058
>
    79.563    30.001
    80.079    30.058
>
    79.563    30.001
    80.079    30.058
>
    79.595    29.852
    80.079    30.058
>
    79.595    29.852
    80.079    30.058
>
    80.234    29.552
    80.079    30.058
>
    80.234    29.552
    80.079    30.058
>
    80.094    29.403
    80.079    30.058
>
    80.094    29.403
    80.079    30.058
>
    79.930    29.407
    80.079    30.058
>
    79.930    29.407
    80.079    30.058
>
    80.107    29.330
    80.079    30.058
>
    80.107    29.330
    80.079    30.058
>
    78.975    30.639
    79.008    30.535
>
    78.975    30.639
    79.008    30.535
>
    79.141    30.588
    79.008    30.535
>
    79.141    30.588
    79.008    30.535
>
    79.019    30.389
    79.008    30.535
>
    79.019    30.389
    79.008    30.535
>
    79.176    30.488
    79.008    30.535
>
    79.176    30.488
    79.008    30.535
>
    79.322    30.406
    79.008    30.535
>
    79.322    30.406
    79.008    30.535
>
    78.649    30.579
    79.008    30.535
>
    78.649    30.579
    79.008    30.535
>
    79.217    30.265
    79.008    30.535
>
    79.217    30.265
    79.008    30.535
>
    79.049    30.019
    79.008    30.535
>
    79.049    30.019
    79.008    30.535
>
    78.436    30.721
    79.008    30.535
>
    79.288    30.051
    79.008    30.535
>
    79.288    30.051
    79.008    30.535
>
    78.918    29.916
    79.008    30.535
>
    78.918    29.916
    79.008    30.535
>
    79.900    29.946
    79.906    30.106
>
    79.900    29.946
    79.906    30.106
>
    80.238    30.066
    79.906    30.106
>
    80.238    30.066
    79.906    30.106
>
    79.673    29.887
    79.906    30.106
>
    79.673    29.887
    79.906    30.106
>
    80.164    29.905
    79.906    30.106
>
    80.164    29.905
    79.906    30.106
>
    79.563    30.001
    79.906    30.106
>
    79.563    30.001
    79.906    30.106
>
    80.049    29.775
    79.906    30.106
>
    80.049    29.775
    79.906    30.106
>
    80.248    29.803
    79.906    30.106
>
    80.248    29.803
    79.906    30.106
>
    80.040    29.660
    79.906    30.106
>
    80.040    29.660
    79.906    30.106
>
    79.217    30.265
    79.906    30.106
>
    79.217    30.265
    79.906    30.106
>
    79.930    29.407
    79.906    30.106
>
    80.094    29.403
    79.906    30.106
>
    80.094    29.403
    79.906    30.106
>
    79.176    30.488
    79.906    30.106
>
    79.176    30.488
    79.906    30.106
>
    79.900    29.946
    79.987    29.992
>
    79.900    29.946
    79.987    29.992
>
    80.164    29.905
    79.987    29.992
>
    80.164    29.905
    79.987    29.992
>
    80.049    29.775
    79.987    29.992
>
    80.049    29.775
    79.987    29.992
>
    80.238    30.066
    79.987    29.992
>
    80.238    30.066
    79.987    29.992
>
    80.248    29.803
    79.987    29.992
>
    80.248    29.803
    79.987    29.992
>
    80.040    29.660
    79.987    29.992
>
    80.040    29.660
    79.987    29.992
>
    79.595    29.852
    79.987    29.992
>
    79.595    29.852
    79.987    29.992
>
    79.563    30.001
    79.987    29.992
>
    79.563    30.001
    79.987    29.992
>
    80.234    29.552
    79.987    29.992
>
    80.234    29.552
    79.987    29.992
>
    79.930    29.407
    79.987    29.992
>
    79.930    29.407
    79.987    29.992
>
    80.094    29.403
    79.987    29.992
>
    80.094    29.403
    79.987    29.992
>
    80.164    29.905
    80.178    29.877
>
    80.164    29.905
    80.178    29.877
>
    80.248    29.803
    80.178    29.877
>
    80.248    29.803
    80.178    29.877
>
    80.049    29.775
    80.178    29.877
>
    80.049    29.775
    80.178    29.877
>
    80.238    30.066
    80.178    29.877
>
    80.238    30.066
    80.178    29.877
>
    79.900    29.946
    80.178    29.877
>
    79.900    29.946
    80.178    29.877
>
    80.040    29.660
    80.178    29.877
>
    80.040    29.660
    80.178    29.877
>
    80.234    29.552
    80.178    29.877
>
    80.234    29.552
    80.178    29.877
>
    80.094    29.403
    80.178    29.877
>
    80.094    29.403
    80.178    29.877
>
    79.595    29.852
    80.178    29.877
>
    79.930    29.407
    80.178    29.877
>
    79.930    29.407
    80.178    29.877
>
    79.900    29.946
    79.863    30.002
>
    79.900    29.946
    79.863    30.002
>
    79.673    29.887
    79.863    30.002
>
    79.673    29.887
    79.863    30.002
>
    79.563    30.001
    79.863    30.002
>
    79.563    30.001
    79.863    30.002
>
    79.595    29.852
    79.863    30.002
>
    79.595    29.852
    79.863    30.002
>
    80.049    29.775
    79.863    30.002
>
    80.049    29.775
    79.863    30.002
>
    80.164    29.905
    79.863    30.002
>
    80.164    29.905
    79.863    30.002
>
    80.238    30.066
    79.863    30.002
>
    80.238    30.066
    79.863    30.002
>
    80.040    29.660
    79.863    30.002
>
    80.040    29.660
    79.863    30.002
>
    80.248    29.803
    79.863    30.002
>
    80.248    29.803
    79.863    30.002
>
    79.288    30.051
    79.863    30.002
>
    79.288    30.051
    79.863    30.002
>
    80.234    29.552
    79.863    30.002
>
    80.234    29.552
    79.863    30.002
>
    79.930    29.407
    79.863    30.002
>
    79.930    29.407
    79.863    30.002
>
    79.322    30.406
    79.863    30.002
>
    79.322    30.406
    79.863    30.002
>
    80.094    29.403
    79.863    30.002
>
    80.094    29.403
    79.863    30.002
>
    79.547    29.355
    79.863    30.002
>
    79.547    29.355
    79.863    30.002
>
    79.049    30.019
    79.863    30.002
>
    79.049    30.019
    79.863    30.002
>
    79.457    29.359
    79.863    30.002
>
    79.457    29.359
    79.863    30.002
>
    80.107    29.330
    79.863    30.002
>
    80.107    29.330
    79.863    30.002
>
    79.176    30.488
    79.863    30.002
>
    79.176    30.488
    79.863    30.002
>
    79.015    29.750
    79.863    30.002
>
    79.015    29.750
    79.863    30.002
>
    79.900    29.946
    79.875    29.995
>
    79.900    29.946
    79.875    29.995
>
    79.673    29.887
    79.875    29.995
>
    79.673    29.887
    79.875    29.995
>
    79.563    30.001
    79.875    29.995
>
    79.563    30.001
    79.875    29.995
>
    80.049    29.775
    79.875    29.995
>
    80.049    29.775
    79.875    29.995
>
    80.164    29.905
    79.875    29.995
>
    80.164    29.905
    79.875    29.995
>
    79.595    29.852
    79.875    29.995
>
    79.595    29.852
    79.875    29.995
>
    80.238    30.066
    79.875    29.995
>
    80.238    30.066
    79.875    29.995
>
    80.040    29.660
    79.875    29.995
>
    80.040    29.660
    79.875    29.995
>
    80.248    29.803
    79.875    29.995
>
    80.248    29.803
    79.875    29.995
>
    80.234    29.552
    79.875    29.995
>
    80.234    29.552
    79.875    29.995
>
    79.930    29.407
    79.875    29.995
>
    79.930    29.407
    79.875    29.995
>
    80.094    29.403
    79.875    29.995
>
    80.094    29.403
    79.875    29.995
>
    79.217    30.265
    79.875    29.995
>
    79.217    30.265
    79.875    29.995
>
    80.107    29.330
    79.875    29.995
>
    80.107    29.330
    79.875    29.995
>
    79.049    30.019
    79.875    29.995
>
    79.049    30.019
    79.875    29.995
>
    79.176    30.488
    79.875    29.995
>
    79.176    30.488
    79.875    29.995
>
    79.900    29.946
    79.869    29.999
>
    79.900    29.946
    79.869    29.999
>
    79.673    29.887
    79.869    29.999
>
    79.673    29.887
    79.869    29.999
>
    79.563    30.001
    79.869    29.999
>
    79.563    30.001
    79.869    29.999
>
    79.595    29.852
    79.869    29.999
>
    79.595    29.852
    79.869    29.999
>
    80.049    29.775
    79.869    29.999
>
    80.049    29.775
    79.869    29.999
>
    80.164    29.905
    79.869    29.999
>
    80.164    29.905
    79.869    29.999
>
    80.238    30.066
    79.869    29.999
>
    80.238    30.066
    79.869    29.999
>
    80.040    29.660
    79.869    29.999
>
    80.040    29.660
    79.869    29.999
>
    80.040    29.660
    79.869    29.999
>
    80.248    29.803
    79.869    29.999
>
    80.248    29.803
    79.869    29.999
>
    79.288    30.051
    79.869    29.999
>
    80.234    29.552
    79.869    29.999
>
    80.234    29.552
    79.869    29.999
>
    79.930    29.407
    79.869    29.999
>
    79.930    29.407
    79.869    29.999
>
    79.217    30.265
    79.869    29.999
>
    79.322    30.406
    79.869    29.999
>
    79.322    30.406
    79.869    29.999
>
    79.217    30.265
    79.869    29.999
>
    80.094    29.403
    79.869    29.999
>
    80.094    29.403
    79.869    29.999
>
    80.107    29.330
    79.869    29.999
>
    80.107    29.330
    79.869    29.999
>
    79.457    29.359
    79.869    29.999
>
    79.176    30.488
    79.869    29.999
>
    79.900    29.946
    79.874    29.985
>
    79.900    29.946
    79.874    29.985
>
    79.673    29.887
    79.874    29.985
>
    79.673    29.887
    79.874    29.985
>
    80.049    29.775
    79.874    29.985
>
    80.049    29.775
    79.874    29.985
>
    80.164    29.905
    79.874    29.985
>
    80.164    29.905
    79.874    29.985
>
    79.563    30.001
    79.874    29.985
>
    79.563    30.001
    79.874    29.985
>
    79.595    29.852
    79.874    29.985
>
    79.595    29.852
    79.874    29.985
>
    80.238    30.066
    79.874    29.985
>
    80.238    30.066
    79.874    29.985
>
    80.040    29.660
    79.874    29.985
>
    80.040    29.660
    79.874    29.985
>
    80.248    29.803
    79.874    29.985
>
    80.248    29.803
    79.874    29.985
>
    79.288    30.051
    79.874    29.985
>
    79.288    30.051
    79.874    29.985
>
    80.234    29.552
    79.874    29.985
>
    80.234    29.552
    79.874    29.985
>
    79.930    29.407
    79.874    29.985
>
    79.930    29.407
    79.874    29.985
>
    80.107    29.330
    79.874    29.985
>
    80.107    29.330
    79.874    29.985
>
    80.164    29.905
    80.136    29.967
>
    80.164    29.905
    80.136    29.967
>
    80.238    30.066
    80.136    29.967
>
    80.238    30.066
    80.136    29.967
>
    80.248    29.803
    80.136    29.967
>
    80.248    29.803
    80.136    29.967
>
    79.900    29.946
    80.136    29.967
>
    79.900    29.946
    80.136    29.967
>
    80.049    29.775
    80.136    29.967
>
    80.049    29.775
    80.136    29.967
>
    80.040    29.660
    80.136    29.967
>
    80.040    29.660
    80.136    29.967
>
    79.673    29.887
    80.136    29.967
>
    79.673    29.887
    80.136    29.967
>
    80.234    29.552
    80.136    29.967
>
    80.234    29.552
    80.136    29.967
>
    79.595    29.852
    80.136    29.967
>
    79.595    29.852
    80.136    29.967
>
    79.563    30.001
    80.136    29.967
>
    79.563    30.001
    80.136    29.967
>
    80.094    29.403
    80.136    29.967
>
    80.094    29.403
    80.136    29.967
>
    79.930    29.407
    80.136    29.967
>
    79.930    29.407
    80.136    29.967
>
    80.107    29.330
    80.136    29.967
>
    79.900    29.946
    79.868    29.998
>
    79.900    29.946
    79.868    29.998
>
    79.673    29.887
    79.868    29.998
>
    79.673    29.887
    79.868    29.998
>
    79.563    30.001
    79.868    29.998
>
    79.563    30.001
    79.868    29.998
>
    79.595    29.852
    79.868    29.998
>
    79.595    29.852
    79.868    29.998
>
    80.049    29.775
    79.868    29.998
>
    80.049    29.775
    79.868    29.998
>
    80.164    29.905
    79.868    29.998
>
    80.164    29.905
    79.868    29.998
>
    80.238    30.066
    79.868    29.998
>
    80.238    30.066
    79.868    29.998
>
    80.040    29.660
    79.868    29.998
>
    80.040    29.660
    79.868    29.998
>
    80.248    29.803
    79.868    29.998
>
    80.248    29.803
    79.868    29.998
>
    79.930    29.407
    79.868    29.998
>
    79.930    29.407
    79.868    29.998
>
    79.217    30.265
    79.868    29.998
>
    79.217    30.265
    79.868    29.998
>
    79.176    30.488
    79.868    29.998
>
    79.176    30.488
    79.868    29.998
>
    79.900    29.946
    79.875    29.992
>
    79.900    29.946
    79.875    29.992
>
    79.673    29.887
    79.875    29.992
>
    79.673    29.887
    79.875    29.992
>
    80.049    29.775
    79.875    29.992
>
    80.049    29.775
    79.875    29.992
>
    79.563    30.001
    79.875    29.992
>
    79.563    30.001
    79.875    29.992
>
    80.164    29.905
    79.875    29.992
>
    80.164    29.905
    79.875    29.992
>
    79.595    29.852
    79.875    29.992
>
    79.595    29.852
    79.875    29.992
>
    80.238    30.066
    79.875    29.992
>
    80.238    30.066
    79.875    29.992
>
    80.040    29.660
    79.875    29.992
>
    80.040    29.660
    79.875    29.992
>
    80.248    29.803
    79.875    29.992
>
    80.248    29.803
    79.875    29.992
>
    79.288    30.051
    79.875    29.992
>
    79.288    30.051
    79.875    29.992
>
    80.234    29.552
    79.875    29.992
>
    80.234    29.552
    79.875    29.992
>
    79.930    29.407
    79.875    29.992
>
    79.930    29.407
    79.875    29.992
>
    80.094    29.403
    79.875    29.992
>
    80.094    29.403
    79.875    29.992
>
    79.322    30.406
    79.875    29.992
>
    79.322    30.406
    79.875    29.992
>
    79.049    30.019
    79.875    29.992
>
    79.049    30.019
    79.875    29.992
>
    79.176    30.488
    79.875    29.992
>
    79.176    30.488
    79.875    29.992
>
    79.015    29.750
    79.875    29.992
>
    79.015    29.750
    79.875    29.992
>
    79.900    29.946
    79.865    29.971
>
    79.900    29.946
    79.865    29.971
>
    79.673    29.887
    79.865    29.971
>
    79.673    29.887
    79.865    29.971
>
    80.049    29.775
    79.865    29.971
>
    80.049    29.775
    79.865    29.971
>
    79.595    29.852
    79.865    29.971
>
    79.595    29.852
    79.865    29.971
>
    79.563    30.001
    79.865    29.971
>
    79.563    30.001
    79.865    29.971
>
    80.164    29.905
    79.865    29.971
>
    80.164    29.905
    79.865    29.971
>
    80.040    29.660
    79.865    29.971
>
    80.040    29.660
    79.865    29.971
>
    80.238    30.066
    79.865    29.971
>
    80.248    29.803
    79.865    29.971
>
    80.248    29.803
    79.865    29.971
>
    80.234    29.552
    79.865    29.971
>
    80.234    29.552
    79.865    29.971
>
    79.930    29.407
    79.865    29.971
>
    79.930    29.407
    79.865    29.971
>
    80.094    29.403
    79.865    29.971
>
    79.900    29.946
    79.877    29.993
>
    79.900    29.946
    79.877    29.993
>
    79.673    29.887
    79.877    29.993
>
    79.673    29.887
    79.877    29.993
>
    80.049    29.775
    79.877    29.993
>
    80.049    29.775
    79.877    29.993
>
    79.563    30.001
    79.877    29.993
>
    79.563    30.001
    79.877    29.993
>
    80.164    29.905
    79.877    29.993
>
    80.164    29.905
    79.877    29.993
>
    79.595    29.852
    79.877    29.993
>
    79.595    29.852
    79.877    29.993
>
    80.238    30.066
    79.877    29.993
>
    80.238    30.066
    79.877    29.993
>
    80.040    29.660
    79.877    29.993
>
    80.040    29.660
    79.877    29.993
>
    80.248    29.803
    79.877    29.993
>
    80.248    29.803
    79.877    29.993
>
    79.288    30.051
    79.877    29.993
>
    79.288    30.051
    79.877    29.993
>
    80.234    29.552
    79.877    29.993
>
    80.234    29.552
    79.877    29.993
>
    79.930    29.407
    79.877    29.993
>
    79.930    29.407
    79.877    29.993
>
    80.094    29.403
    79.877    29.993
>
    80.094    29.403
    79.877    29.993
>
    79.217    30.265
    79.877    29.993
>
    79.217    30.265
    79.877    29.993
>
    79.322    30.406
    79.877    29.993
>
    79.322    30.406
    79.877    29.993
>
    80.107    29.330
    79.877    29.993
>
    80.107    29.330
    79.877    29.993
>
    79.049    30.019
    79.877    29.993
>
    79.049    30.019
    79.877    29.993
>
    79.015    29.750
    79.877    29.993
>
    79.015    29.750
    79.877    29.993
>
    79.176    30.488
    79.877    29.993
>
    79.176    30.488
    79.877    29.993
>
    80.164    29.905
    80.181    29.976
>
    80.164    29.905
    80.181    29.976
>
    80.238    30.066
    80.181    29.976
>
    80.238    30.066
    80.181    29.976
>
    80.248    29.803
    80.181    29.976
>
    80.248    29.803
    80.181    29.976
>
    80.049    29.775
    80.181    29.976
>
    80.049    29.775
    80.181    29.976
>
    79.900    29.946
    80.181    29.976
>
    79.900    29.946
    80.181    29.976
>
    80.040    29.660
    80.181    29.976
>
    80.040    29.660
    80.181    29.976
>
    80.234    29.552
    80.181    29.976
>
    80.234    29.552
    80.181    29.976
>
    79.673    29.887
    80.181    29.976
>
    79.673    29.887
    80.181    29.976
>
    79.595    29.852
    80.181    29.976
>
    79.595    29.852
    80.181    29.976
>
    80.094    29.403
    80.181    29.976
>
    80.094    29.403
    80.181    29.976
>
    79.930    29.407
    80.181    29.976
>
    79.930    29.407
    80.181    29.976
>
    80.107    29.330
    80.181    29.976
>
    80.164    29.905
    80.181    29.976
>
    80.040    29.660
    80.181    29.976
>
    80.234    29.552
    80.181    29.976
>
    79.563    30.001
    80.181    29.976
>
    79.930    29.407
    80.181    29.976
>
    80.107    29.330
    80.181    29.976
>
    79.900    29.946
    79.885    29.987
>
    79.900    29.946
    79.885    29.987
>
    79.673    29.887
    79.885    29.987
>
    79.673    29.887
    79.885    29.987
>
    80.049    29.775
    79.885    29.987
>
    80.049    29.775
    79.885    29.987
>
    80.164    29.905
    79.885    29.987
>
    80.164    29.905
    79.885    29.987
>
    79.563    30.001
    79.885    29.987
>
    79.563    30.001
    79.885    29.987
>
    79.595    29.852
    79.885    29.987
>
    79.595    29.852
    79.885    29.987
>
    80.238    30.066
    79.885    29.987
>
    80.238    30.066
    79.885    29.987
>
    80.040    29.660
    79.885    29.987
>
    80.040    29.660
    79.885    29.987
>
    80.248    29.803
    79.885    29.987
>
    80.248    29.803
    79.885    29.987
>
    79.288    30.051
    79.885    29.987
>
    79.288    30.051
    79.885    29.987
>
    80.234    29.552
    79.885    29.987
>
    80.234    29.552
    79.885    29.987
>
    79.930    29.407
    79.885    29.987
>
    79.930    29.407
    79.885    29.987
>
    80.094    29.403
    79.885    29.987
>
    80.094    29.403
    79.885    29.987
>
    79.217    30.265
    79.885    29.987
>
    79.217    30.265
    79.885    29.987
>
    79.322    30.406
    79.885    29.987
>
    79.322    30.406
    79.885    29.987
>
    80.107    29.330
    79.885    29.987
>
    80.107    29.330
    79.885    29.987
>
    79.547    29.355
    79.885    29.987
>
    79.547    29.355
    79.885    29.987
>
    79.457    29.359
    79.885    29.987
>
    79.049    30.019
    79.885    29.987
>
    79.049    30.019
    79.885    29.987
>
    79.176    30.488
    79.885    29.987
>
    79.176    30.488
    79.885    29.987
>
    79.015    29.750
    79.885    29.987
>
    79.015    29.750
    79.885    29.987
>
    79.900    29.946
    79.873    29.984
>
    79.900    29.946
    79.873    29.984
>
    79.673    29.887
    79.873    29.984
>
    79.673    29.887
    79.873    29.984
>
    80.049    29.775
    79.873    29.984
>
    80.049    29.775
    79.873    29.984
>
    79.563    30.001
    79.873    29.984
>
    80.164    29.905
    79.873    29.984
>
    80.164    29.905
    79.873    29.984
>
    79.595    29.852
    79.873    29.984
>
    79.595    29.852
    79.873    29.984
>
    80.238    30.066
    79.873    29.984
>
    80.238    30.066
    79.873    29.984
>
    80.040    29.660
    79.873    29.984
>
    80.040    29.660
    79.873    29.984
>
    80.248    29.803
    79.873    29.984
>
    80.248    29.803
    79.873    29.984
>
    79.930    29.407
    79.873    29.984
>
    79.217    30.265
    79.873    29.984
>
    79.217    30.265
    79.873    29.984
>
    80.107    29.330
    79.873    29.984
>
    80.107    29.330
    79.873    29.984
>
    79.176    30.488
    79.873    29.984
>
    79.176    30.488
    79.873    29.984
>
    79.673    29.887
    79.873    29.984
>
    80.049    29.775
    79.873    29.984
>
    80.238    30.066
    79.873    29.984
>
    80.238    30.066
    79.873    29.984
>
    80.040    29.660
    79.873    29.984
>
    80.040    29.660
    79.873    29.984
>
    80.040    29.660
    79.873    29.984
>
    80.248    29.803
    79.873    29.984
>
    80.248    29.803
    79.873    29.984
>
    80.234    29.552
    79.873    29.984
>
    80.234    29.552
    79.873    29.984
>
    79.930    29.407
    79.873    29.984
>
    79.930    29.407
    79.873    29.984
>
    80.107    29.330
    79.873    29.984
>
    79.176    30.488
    79.873    29.984
>
    80.238    30.066
    80.205    30.018
>
    80.238    30.066
    80.205    30.018
>
    80.248    29.803
    80.205    30.018
>
    80.248    29.803
    80.205    30.018
>
    79.900    29.946
    80.205    30.018
>
    79.900    29.946
    80.205    30.018
>
    80.049    29.775
    80.205    30.018
>
    80.049    29.775
    80.205    30.018
>
    80.040    29.660
    80.205    30.018
>
    80.040    29.660
    80.205    30.018
>
    80.234    29.552
    80.205    30.018
>
    80.234    29.552
    80.205    30.018
>
    80.234    29.552
    80.205    30.018
>
    79.563    30.001
    80.205    30.018
>
    79.563    30.001
    80.205    30.018
>
    80.094    29.403
    80.205    30.018
>
    80.094    29.403
    80.205    30.018
>
    79.930    29.407
    80.205    30.018
>
    79.930    29.407
    80.205    30.018
>
    79.900    29.946
    79.859    29.997
>
    79.900    29.946
    79.859    29.997
>
    79.673    29.887
    79.859    29.997
>
    79.673    29.887
    79.859    29.997
>
    79.563    30.001
    79.859    29.997
>
    79.595    29.852
    79.859    29.997
>
    79.595    29.852
    79.859    29.997
>
    80.049    29.775
    79.859    29.997
>
    80.049    29.775
    79.859    29.997
>
    80.040    29.660
    79.859    29.997
>
    80.040    29.660
    79.859    29.997
>
    80.248    29.803
    79.859    29.997
>
    80.248    29.803
    79.859    29.997
>
    79.416    30.250
    79.859    29.997
>
    79.416    30.250
    79.859    29.997
>
    79.416    29.770
    79.859    29.997
>
    79.416    29.770
    79.859    29.997
>
    79.288    30.051
    79.859    29.997
>
    79.288    30.051
    79.859    29.997
>
    79.566    30.538
    79.859    29.997
>
    79.566    30.538
    79.859    29.997
>
    79.217    30.265
    79.859    29.997
>
    79.217    30.265
    79.859    29.997
>
    79.322    30.406
    79.859    29.997
>
    79.322    30.406
    79.859    29.997
>
    80.094    29.403
    79.859    29.997
>
    80.094    29.403
    79.859    29.997
>
    79.547    29.355
    79.859    29.997
>
    79.176    30.488
    79.859    29.997
>
    79.176    30.488
    79.859    29.997
>
    79.900    29.946
    79.871    29.988
>
    79.900    29.946
    79.871    29.988
>
    79.673    29.887
    79.871    29.988
>
    79.673    29.887
    79.871    29.988
>
    79.563    30.001
    79.871    29.988
>
    79.563    30.001
    79.871    29.988
>
    80.049    29.775
    79.871    29.988
>
    80.049    29.775
    79.871    29.988
>
    79.595    29.852
    79.871    29.988
>
    79.595    29.852
    79.871    29.988
>
    80.040    29.660
    79.871    29.988
>
    80.040    29.660
    79.871    29.988
>
    80.248    29.803
    79.871    29.988
>
    80.248    29.803
    79.871    29.988
>
    79.416    29.770
    79.871    29.988
>
    79.416    29.770
    79.871    29.988
>
    79.416    30.250
    79.871    29.988
>
    79.416    30.250
    79.871    29.988
>
    79.288    30.051
    79.871    29.988
>
    79.566    30.538
    79.871    29.988
>
    79.566    30.538
    79.871    29.988
>
    80.094    29.403
    79.871    29.988
>
    80.094    29.403
    79.871    29.988
>
    79.217    30.265
    79.871    29.988
>
    79.217    30.265
    79.871    29.988
>
    79.322    30.406
    79.871    29.988
>
    79.322    30.406
    79.871    29.988
>
    79.015    29.750
    79.871    29.988
>
    79.015    29.750
    79.871    29.988
>
    79.176    30.488
    79.871    29.988
>
    80.217    29.550
    79.871    29.988
>
    80.217    29.550
    79.871    29.988
>
    80.246    29.450
    79.871    29.988
>
    80.246    29.450
    79.871    29.988
>
    78.436    30.721
    78.532    30.728
>
    78.436    30.721
    78.532    30.728
>
    78.649    30.579
    78.532    30.728
>
    78.649    30.579
    78.532    30.728
>
    78.330    30.574
    78.532    30.728
>
    78.330    30.574
    78.532    30.728
>
    78.378    30.508
    78.532    30.728
>
    78.378    30.508
    78.532    30.728
>
    78.640    30.431
    78.532    30.728
>
    78.640    30.431
    78.532    30.728
>
    78.205    30.808
    78.532    30.728
>
    78.205    30.808
    78.532    30.728
>
    78.753    31.036
    78.532    30.728
>
    78.753    31.036
    78.532    30.728
>
    79.019    30.389
    78.532    30.728
>
    79.019    30.389
    78.532    30.728
>
    78.605    30.144
    78.532    30.728
>
    78.605    30.144
    78.532    30.728
>
    79.176    30.488
    78.532    30.728
>
    79.176    30.488
    78.532    30.728
>
    77.873    30.691
    78.532    30.728
>
    77.843    30.518
    78.532    30.728
>
    77.843    30.518
    78.532    30.728
>
    79.217    30.265
    78.532    30.728
>
    79.217    30.265
    78.532    30.728
>
    79.322    30.406
    79.385    30.335
>
    79.322    30.406
    79.385    30.335
>
    79.416    30.250
    79.385    30.335
>
    79.416    30.250
    79.385    30.335
>
    79.217    30.265
    79.385    30.335
>
    79.217    30.265
    79.385    30.335
>
    79.176    30.488
    79.385    30.335
>
    79.176    30.488
    79.385    30.335
>
    79.566    30.538
    79.385    30.335
>
    79.566    30.538
    79.385    30.335
>
    79.288    30.051
    79.385    30.335
>
    79.288    30.051
    79.385    30.335
>
    79.019    30.389
    79.385    30.335
>
    79.019    30.389
    79.385    30.335
>
    79.563    30.001
    79.385    30.335
>
    79.673    29.887
    79.385    30.335
>
    79.673    29.887
    79.385    30.335
>
    79.595    29.852
    79.385    30.335
>
    79.595    29.852
    79.385    30.335
>
    79.900    29.946
    79.385    30.335
>
    79.015    29.750
    79.385    30.335
>
    79.015    29.750
    79.385    30.335
>
    78.680    29.839
    79.385    30.335
>
    78.680    29.839
    79.385    30.335
>
    78.436    30.721
    78.511    30.812
>
    78.436    30.721
    78.511    30.812
>
    78.649    30.579
    78.511    30.812
>
    78.649    30.579
    78.511    30.812
>
    78.205    30.808
    78.511    30.812
>
    78.205    30.808
    78.511    30.812
>
    78.330    30.574
    78.511    30.812
>
    78.330    30.574
    78.511    30.812
>
    78.753    31.036
    78.511    30.812
>
    78.753    31.036
    78.511    30.812
>
    77.873    30.691
    78.511    30.812
>
    79.019    30.389
    78.511    30.812
>
    79.019    30.389
    78.511    30.812
>
    79.176    30.488
    78.511    30.812
>
    79.176    30.488
    78.511    30.812
>
    77.843    30.518
    78.511    30.812
>
    78.605    30.144
    78.511    30.812
>
    78.605    30.144
    78.511    30.812
>
    79.176    30.488
    79.201    30.496
>
    79.176    30.488
    79.201    30.496
>
    79.322    30.406
    79.201    30.496
>
    79.322    30.406
    79.201    30.496
>
    79.019    30.389
    79.201    30.496
>
    79.019    30.389
    79.201    30.496
>
    79.217    30.265
    79.201    30.496
>
    79.217    30.265
    79.201    30.496
>
    79.416    30.250
    79.201    30.496
>
    79.416    30.250
    79.201    30.496
>
    79.566    30.538
    79.201    30.496
>
    79.566    30.538
    79.201    30.496
>
    78.649    30.579
    79.201    30.496
>
    78.649    30.579
    79.201    30.496
>
    78.640    30.431
    79.201    30.496
>
    78.640    30.431
    79.201    30.496
>
    79.563    30.001
    79.201    30.496
>
    79.563    30.001
    79.201    30.496
>
    79.595    29.852
    79.201    30.496
>
    79.673    29.887
    79.201    30.496
>
    79.673    29.887
    79.201    30.496
>
    79.416    29.770
    79.201    30.496
>
    79.015    29.750
    79.201    30.496
>
    78.680    29.839
    79.201    30.496
>
    78.680    29.839
    79.201    30.496
>
    79.900    29.946
    80.096    30.070
>
    79.900    29.946
    80.096    30.070
>
    80.248    29.803
    80.096    30.070
>
    80.248    29.803
    80.096    30.070
>
    79.673    29.887
    80.096    30.070
>
    79.673    29.887
    80.096    30.070
>
    80.040    29.660
    80.096    30.070
>
    80.040    29.660
    80.096    30.070
>
    80.544    29.849
    80.096    30.070
>
    80.544    29.849
    80.096    30.070
>
    79.563    30.001
    80.096    30.070
>
    79.563    30.001
    80.096    30.070
>
    79.595    29.852
    80.096    30.070
>
    79.595    29.852
    80.096    30.070
>
    79.648    29.592
    80.096    30.070
>
    79.566    30.538
    80.096    30.070
>
    79.416    29.770
    80.096    30.070
>
    79.288    30.051
    80.096    30.070
>
    79.288    30.051
    80.096    30.070
>
    79.322    30.406
    80.096    30.070
>
    80.107    29.330
    80.096    30.070
>
    79.217    30.265
    80.096    30.070
>
    80.246    29.450
    80.096    30.070
>
    79.558    30.556
    80.096    30.070
>
    79.900    29.946
    79.871    30.001
>
    79.900    29.946
    79.871    30.001
>
    79.673    29.887
    79.871    30.001
>
    79.673    29.887
    79.871    30.001
>
    79.563    30.001
    79.871    30.001
>
    80.049    29.775
    79.871    30.001
>
    80.049    29.775
    79.871    30.001
>
    79.595    29.852
    79.871    30.001
>
    79.595    29.852
    79.871    30.001
>
    80.040    29.660
    79.871    30.001
>
    80.040    29.660
    79.871    30.001
>
    80.248    29.803
    79.871    30.001
>
    80.248    29.803
    79.871    30.001
>
    79.416    30.250
    79.871    30.001
>
    79.416    30.250
    79.871    30.001
>
    79.648    29.592
    79.871    30.001
>
    79.648    29.592
    79.871    30.001
>
    79.416    29.770
    79.871    30.001
>
    79.566    30.538
    79.871    30.001
>
    79.566    30.538
    79.871    30.001
>
    80.544    29.849
    79.871    30.001
>
    79.322    30.406
    79.871    30.001
>
    79.217    30.265
    79.871    30.001
>
    79.217    30.265
    79.871    30.001
>
    79.900    29.946
    79.872    29.987
>
    79.900    29.946
    79.872    29.987
>
    79.673    29.887
    79.872    29.987
>
    79.673    29.887
    79.872    29.987
>
    80.049    29.775
    79.872    29.987
>
    80.049    29.775
    79.872    29.987
>
    79.563    30.001
    79.872    29.987
>
    79.563    30.001
    79.872    29.987
>
    79.595    29.852
    79.872    29.987
>
    79.595    29.852
    79.872    29.987
>
    80.040    29.660
    79.872    29.987
>
    80.040    29.660
    79.872    29.987
>
    80.248    29.803
    79.872    29.987
>
    80.248    29.803
    79.872    29.987
>
    79.648    29.592
    79.872    29.987
>
    79.648    29.592
    79.872    29.987
>
    79.416    29.770
    79.872    29.987
>
    79.416    29.770
    79.872    29.987
>
    79.416    30.250
    79.872    29.987
>
    79.416    30.250
    79.872    29.987
>
    79.288    30.051
    79.872    29.987
>
    79.288    30.051
    79.872    29.987
>
    80.544    29.849
    79.872    29.987
>
    79.566    30.538
    79.872    29.987
>
    79.566    30.538
    79.872    29.987
>
    79.217    30.265
    79.872    29.987
>
    79.217    30.265
    79.872    29.987
>
    79.322    30.406
    79.872    29.987
>
    79.322    30.406
    79.872    29.987
>
    80.107    29.330
    79.872    29.987
>
    80.107    29.330
    79.872    29.987
>
    79.547    29.355
    79.872    29.987
>
    79.547    29.355
    79.872    29.987
>
    79.015    29.750
    79.872    29.987
>
    79.176    30.488
    79.872    29.987
>
    79.673    29.887
    79.864    30.004
>
    79.673    29.887
    79.864    30.004
>
    79.563    30.001
    79.864    30.004
>
    79.563    30.001
    79.864    30.004
>
    79.595    29.852
    79.864    30.004
>
    79.595    29.852
    79.864    30.004
>
    80.049    29.775
    79.864    30.004
>
    80.049    29.775
    79.864    30.004
>
    80.238    30.066
    79.864    30.004
>
    80.238    30.066
    79.864    30.004
>
    80.040    29.660
    79.864    30.004
>
    80.040    29.660
    79.864    30.004
>
    80.248    29.803
    79.864    30.004
>
    80.248    29.803
    79.864    30.004
>
    79.416    30.250
    79.864    30.004
>
    79.416    30.250
    79.864    30.004
>
    79.648    29.592
    79.864    30.004
>
    79.648    29.592
    79.864    30.004
>
    79.416    29.770
    79.864    30.004
>
    79.288    30.051
    79.864    30.004
>
    79.322    30.406
    79.864    30.004
>
    79.322    30.406
    79.864    30.004
>
    79.217    30.265
    79.864    30.004
>
    79.217    30.265
    79.864    30.004
>
    80.094    29.403
    79.864    30.004
>
    80.094    29.403
    79.864    30.004
>
    79.547    29.355
    79.864    30.004
>
    79.547    29.355
    79.864    30.004
>
    79.176    30.488
    79.864    30.004
>
    79.176    30.488
    79.864    30.004
>
    79.015    29.750
    79.864    30.004
>
    79.015    29.750
    79.864    30.004
>
    80.217    29.550
    79.864    30.004
>
    80.217    29.550
    79.864    30.004
>
    79.673    29.887
    79.864    29.998
>
    79.673    29.887
    79.864    29.998
>
    79.563    30.001
    79.864    29.998
>
    79.563    30.001
    79.864    29.998
>
    80.049    29.775
    79.864    29.998
>
    80.049    29.775
    79.864    29.998
>
    79.595    29.852
    79.864    29.998
>
    79.595    29.852
    79.864    29.998
>
    80.040    29.660
    79.864    29.998
>
    80.040    29.660
    79.864    29.998
>
    80.248    29.803
    79.864    29.998
>
    79.648    29.592
    79.864    29.998
>
    79.648    29.592
    79.864    29.998
>
    79.416    30.250
    79.864    29.998
>
    79.416    29.770
    79.864    29.998
>
    79.416    29.770
    79.864    29.998
>
    80.094    29.403
    79.864    29.998
>
    79.217    30.265
    79.864    29.998
>
    79.217    30.265
    79.864    29.998
>
    79.322    30.406
    79.864    29.998
>
    79.322    30.406
    79.864    29.998
>
    80.107    29.330
    79.864    29.998
>
    80.107    29.330
    79.864    29.998
>
    79.015    29.750
    79.864    29.998
>
    79.015    29.750
    79.864    29.998
>
    79.673    29.887
    79.876    30.008
>
    79.673    29.887
    79.876    30.008
>
    80.049    29.775
    79.876    30.008
>
    80.049    29.775
    79.876    30.008
>
    79.595    29.852
    79.876    30.008
>
    79.595    29.852
    79.876    30.008
>
    80.040    29.660
    79.876    30.008
>
    80.040    29.660
    79.876    30.008
>
    80.248    29.803
    79.876    30.008
>
    80.248    29.803
    79.876    30.008
>
    79.416    30.250
    79.876    30.008
>
    79.416    30.250
    79.876    30.008
>
    79.648    29.592
    79.876    30.008
>
    79.648    29.592
    79.876    30.008
>
    79.288    30.051
    79.876    30.008
>
    79.288    30.051
    79.876    30.008
>
    79.566    30.538
    79.876    30.008
>
    79.566    30.538
    79.876    30.008
>
    80.544    29.849
    79.876    30.008
>
    80.544    29.849
    79.876    30.008
>
    79.322    30.406
    79.876    30.008
>
    79.322    30.406
    79.876    30.008
>
    79.217    30.265
    79.876    30.008
>
    79.217    30.265
    79.876    30.008
>
    80.094    29.403
    79.876    30.008
>
    80.107    29.330
    79.876    30.008
>
    80.107    29.330
    79.876    30.008
>
    79.176    30.488
    79.876    30.008
>
    79.176    30.488
    79.876    30.008
>
    79.015    29.750
    79.876    30.008
>
    79.322    30.406
    79.367    30.371
>
    79.322    30.406
    79.367    30.371
>
    79.416    30.250
    79.367    30.371
>
    79.416    30.250
    79.367    30.371
>
    79.217    30.265
    79.367    30.371
>
    79.217    30.265
    79.367    30.371
>
    79.176    30.488
    79.367    30.371
>
    79.176    30.488
    79.367    30.371
>
    79.566    30.538
    79.367    30.371
>
    79.019    30.389
    79.367    30.371
>
    79.019    30.389
    79.367    30.371
>
    79.288    30.051
    79.367    30.371
>
    79.288    30.051
    79.367    30.371
>
    79.563    30.001
    79.367    30.371
>
    79.563    30.001
    79.367    30.371
>
    79.595    29.852
    79.367    30.371
>
    79.595    29.852
    79.367    30.371
>
    79.673    29.887
    79.367    30.371
>
    79.673    29.887
    79.367    30.371
>
    79.416    29.770
    79.367    30.371
>
    78.640    30.431
    79.367    30.371
>
    79.015    29.750
    79.367    30.371
>
    79.015    29.750
    79.367    30.371
>
    78.605    30.144
    79.367    30.371
>
    78.605    30.144
    79.367    30.371
>
    78.680    29.839
    79.367    30.371
>
    78.680    29.839
    79.367    30.371
>
    79.673    29.887
    79.875    29.994
>
    79.563    30.001
    79.875    29.994
>
    79.563    30.001
    79.875    29.994
>
    80.049    29.775
    79.875    29.994
>
    80.049    29.775
    79.875    29.994
>
    80.164    29.905
    79.875    29.994
>
    80.164    29.905
    79.875    29.994
>
    79.595    29.852
    79.875    29.994
>
    79.595    29.852
    79.875    29.994
>
    80.238    30.066
    79.875    29.994
>
    80.238    30.066
    79.875    29.994
>
    80.040    29.660
    79.875    29.994
>
    80.040    29.660
    79.875    29.994
>
    80.248    29.803
    79.875    29.994
>
    80.248    29.803
    79.875    29.994
>
    79.648    29.592
    79.875    29.994
>
    79.648    29.592
    79.875    29.994
>
    79.416    30.250
    79.875    29.994
>
    79.416    30.250
    79.875    29.994
>
    79.416    29.770
    79.875    29.994
>
    79.416    29.770
    79.875    29.994
>
    79.376    30.145
    79.875    29.994
>
    79.376    30.145
    79.875    29.994
>
    79.288    30.051
    79.875    29.994
>
    79.288    30.051
    79.875    29.994
>
    80.234    29.552
    79.875    29.994
>
    80.234    29.552
    79.875    29.994
>
    79.930    29.407
    79.875    29.994
>
    79.930    29.407
    79.875    29.994
>
    79.210    29.820
    79.875    29.994
>
    79.210    29.820
    79.875    29.994
>
    79.566    30.538
    79.875    29.994
>
    79.566    30.538
    79.875    29.994
>
    80.544    29.849
    79.875    29.994
>
    80.544    29.849
    79.875    29.994
>
    80.094    29.403
    79.875    29.994
>
    80.094    29.403
    79.875    29.994
>
    79.217    30.265
    79.875    29.994
>
    79.217    30.265
    79.875    29.994
>
    79.322    30.406
    79.875    29.994
>
    80.107    29.330
    79.875    29.994
>
    80.107    29.330
    79.875    29.994
>
    79.547    29.355
    79.875    29.994
>
    79.547    29.355
    79.875    29.994
>
    79.457    29.359
    79.875    29.994
>
    79.049    30.019
    79.875    29.994
>
    79.176    30.488
    79.875    29.994
>
    79.176    30.488
    79.875    29.994
>
    79.015    29.750
    79.875    29.994
>
    79.015    29.750
    79.875    29.994
>
    80.217    29.550
    79.875    29.994
>
    80.217    29.550
    79.875    29.994
>
    80.246    29.450
    79.875    29.994
>
    80.246    29.450
    79.875    29.994
>
    79.558    30.556
    79.875    29.994
>
    79.176    30.488
    79.217    30.495
>
    79.176    30.488
    79.217    30.495
>
    79.322    30.406
    79.217    30.495
>
    79.322    30.406
    79.217    30.495
>
    79.019    30.389
    79.217    30.495
>
    79.019    30.389
    79.217    30.495
>
    79.217    30.265
    79.217    30.495
>
    79.217    30.265
    79.217    30.495
>
    78.975    30.639
    79.217    30.495
>
    78.975    30.639
    79.217    30.495
>
    79.416    30.250
    79.217    30.495
>
    79.416    30.250
    79.217    30.495
>
    79.566    30.538
    79.217    30.495
>
    79.566    30.538
    79.217    30.495
>
    79.376    30.145
    79.217    30.495
>
    79.376    30.145
    79.217    30.495
>
    79.288    30.051
    79.217    30.495
>
    79.288    30.051
    79.217    30.495
>
    79.049    30.019
    79.217    30.495
>
    79.049    30.019
    79.217    30.495
>
    78.649    30.579
    79.217    30.495
>
    78.640    30.431
    79.217    30.495
>
    78.640    30.431
    79.217    30.495
>
    78.768    30.155
    79.217    30.495
>
    78.768    30.155
    79.217    30.495
>
    78.605    30.144
    79.217    30.495
>
    78.436    30.721
    79.217    30.495
>
    79.595    29.852
    79.217    30.495
>
    79.595    29.852
    79.217    30.495
>
    79.673    29.887
    79.217    30.495
>
    79.673    29.887
    79.217    30.495
>
    79.416    29.770
    79.217    30.495
>
    79.416    29.770
    79.217    30.495
>
    78.605    30.144
    78.614    30.205
>
    78.605    30.144
    78.614    30.205
>
    78.768    30.155
    78.614    30.205
>
    78.768    30.155
    78.614    30.205
>
    78.640    30.431
    78.614    30.205
>
    78.680    29.839
    78.614    30.205
>
    78.680    29.839
    78.614    30.205
>
    78.649    30.579
    78.614    30.205
>
    78.649    30.579
    78.614    30.205
>
    78.918    29.916
    78.614    30.205
>
    79.019    30.389
    78.614    30.205
>
    79.019    30.389
    78.614    30.205
>
    79.049    30.019
    78.614    30.205
>
    79.049    30.019
    78.614    30.205
>
    79.217    30.265
    78.614    30.205
>
    78.975    30.639
    78.614    30.205
>
    78.975    30.639
    78.614    30.205
>
    78.436    30.721
    78.614    30.205
>
    79.176    30.488
    78.614    30.205
>
    79.176    30.488
    78.614    30.205
>
    79.015    29.750
    78.614    30.205
>
    79.015    29.750
    78.614    30.205
>
    79.176    30.488
    79.225    30.442
>
    79.176    30.488
    79.225    30.442
>
    79.322    30.406
    79.225    30.442
>
    79.322    30.406
    79.225    30.442
>
    79.217    30.265
    79.225    30.442
>
    79.217    30.265
    79.225    30.442
>
    79.019    30.389
    79.225    30.442
>
    79.019    30.389
    79.225    30.442
>
    79.416    30.250
    79.225    30.442
>
    79.416    30.250
    79.225    30.442
>
    78.975    30.639
    79.225    30.442
>
    79.376    30.145
    79.225    30.442
>
    79.376    30.145
    79.225    30.442
>
    79.566    30.538
    79.225    30.442
>
    79.566    30.538
    79.225    30.442
>
    79.288    30.051
    79.225    30.442
>
    79.288    30.051
    79.225    30.442
>
    79.049    30.019
    79.225    30.442
>
    79.049    30.019
    79.225    30.442
>
    78.768    30.155
    79.225    30.442
>
    78.768    30.155
    79.225    30.442
>
    78.640    30.431
    79.225    30.442
>
    78.640    30.431
    79.225    30.442
>
    78.649    30.579
    79.225    30.442
>
    79.563    30.001
    79.225    30.442
>
    79.563    30.001
    79.225    30.442
>
    78.918    29.916
    79.225    30.442
>
    78.918    29.916
    79.225    30.442
>
    78.605    30.144
    79.225    30.442
>
    78.605    30.144
    79.225    30.442
>
    79.210    29.820
    79.225    30.442
>
    79.210    29.820
    79.225    30.442
>
    79.595    29.852
    79.225    30.442
>
    79.595    29.852
    79.225    30.442
>
    79.673    29.887
    79.225    30.442
>
    79.673    29.887
    79.225    30.442
>
    78.711    29.924
    79.225    30.442
>
    78.711    29.924
    79.225    30.442
>
    79.416    29.770
    79.225    30.442
>
    79.416    29.770
    79.225    30.442
>
    78.429    30.373
    79.225    30.442
>
    79.015    29.750
    79.225    30.442
>
    79.015    29.750
    79.225    30.442
>
    78.436    30.721
    79.225    30.442
>
    78.436    30.721
    79.225    30.442
>
    78.680    29.839
    79.225    30.442
>
    79.176    30.488
    79.216    30.445
>
    79.176    30.488
    79.216    30.445
>
    79.322    30.406
    79.216    30.445
>
    79.322    30.406
    79.216    30.445
>
    79.217    30.265
    79.216    30.445
>
    79.217    30.265
    79.216    30.445
>
    79.019    30.389
    79.216    30.445
>
    79.019    30.389
    79.216    30.445
>
    79.416    30.250
    79.216    30.445
>
    79.416    30.250
    79.216    30.445
>
    78.975    30.639
    79.216    30.445
>
    79.566    30.538
    79.216    30.445
>
    79.566    30.538
    79.216    30.445
>
    79.376    30.145
    79.216    30.445
>
    79.376    30.145
    79.216    30.445
>
    79.288    30.051
    79.216    30.445
>
    79.049    30.019
    79.216    30.445
>
    79.049    30.019
    79.216    30.445
>
    78.768    30.155
    79.216    30.445
>
    78.768    30.155
    79.216    30.445
>
    78.640    30.431
    79.216    30.445
>
    78.640    30.431
    79.216    30.445
>
    78.649    30.579
    79.216    30.445
>
    79.563    30.001
    79.216    30.445
>
    79.563    30.001
    79.216    30.445
>
    78.918    29.916
    79.216    30.445
>
    78.918    29.916
    79.216    30.445
>
    78.605    30.144
    79.216    30.445
>
    78.605    30.144
    79.216    30.445
>
    79.210    29.820
    79.216    30.445
>
    79.210    29.820
    79.216    30.445
>
    79.595    29.852
    79.216    30.445
>
    79.595    29.852
    79.216    30.445
>
    78.711    29.924
    79.216    30.445
>
    78.711    29.924
    79.216    30.445
>
    79.673    29.887
    79.216    30.445
>
    79.673    29.887
    79.216    30.445
>
    78.429    30.373
    79.216    30.445
>
    78.429    30.373
    79.216    30.445
>
    79.416    29.770
    79.216    30.445
>
    79.416    29.770
    79.216    30.445
>
    79.015    29.750
    79.216    30.445
>
    79.015    29.750
    79.216    30.445
>
    78.436    30.721
    79.216    30.445
>
    78.436    30.721
    79.216    30.445
>
    78.680    29.839
    79.216    30.445
>
    78.680    29.839
    79.216    30.445
>
    78.330    30.574
    79.216    30.445
>
    78.330    30.574
    79.216    30.445
>
    79.558    30.556
    79.216    30.445
>
    79.558    30.556
    79.216    30.445
>
    79.176    30.488
    79.225    30.445
>
    79.176    30.488
    79.225    30.445
>
    79.322    30.406
    79.225    30.445
>
    79.322    30.406
    79.225    30.445
>
    79.217    30.265
    79.225    30.445
>
    79.217    30.265
    79.225    30.445
>
    79.019    30.389
    79.225    30.445
>
    79.019    30.389
    79.225    30.445
>
    79.416    30.250
    79.225    30.445
>
    79.416    30.250
    79.225    30.445
>
    78.975    30.639
    79.225    30.445
>
    79.566    30.538
    79.225    30.445
>
    79.566    30.538
    79.225    30.445
>
    79.288    30.051
    79.225    30.445
>
    79.288    30.051
    79.225    30.445
>
    79.049    30.019
    79.225    30.445
>
    79.049    30.019
    79.225    30.445
>
    78.768    30.155
    79.225    30.445
>
    78.768    30.155
    79.225    30.445
>
    78.640    30.431
    79.225    30.445
>
    78.640    30.431
    79.225    30.445
>
    78.918    29.916
    79.225    30.445
>
    78.918    29.916
    79.225    30.445
>
    78.605    30.144
    79.225    30.445
>
    78.605    30.144
    79.225    30.445
>
    79.210    29.820
    79.225    30.445
>
    79.210    29.820
    79.225    30.445
>
    79.595    29.852
    79.225    30.445
>
    79.595    29.852
    79.225    30.445
>
    79.673    29.887
    79.225    30.445
>
    79.673    29.887
    79.225    30.445
>
    78.711    29.924
    79.225    30.445
>
    78.711    29.924
    79.225    30.445
>
    78.429    30.373
    79.225    30.445
>
    78.429    30.373
    79.225    30.445
>
    79.015    29.750
    79.225    30.445
>
    79.015    29.750
    79.225    30.445
>
    78.436    30.721
    79.225    30.445
>
    78.680    29.839
    79.225    30.445
>
    78.680    29.839
    79.225    30.445
>
    78.605    30.144
    78.668    30.216
>
    78.768    30.155
    78.668    30.216
>
    78.768    30.155
    78.668    30.216
>
    78.605    30.144
    78.668    30.216
>
    78.640    30.431
    78.668    30.216
>
    78.640    30.431
    78.668    30.216
>
    78.429    30.373
    78.668    30.216
>
    78.429    30.373
    78.668    30.216
>
    78.711    29.924
    78.668    30.216
>
    78.711    29.924
    78.668    30.216
>
    79.019    30.389
    78.668    30.216
>
    79.019    30.389
    78.668    30.216
>
    78.287    30.161
    78.668    30.216
>
    78.287    30.161
    78.668    30.216
>
    78.918    29.916
    78.668    30.216
>
    78.918    29.916
    78.668    30.216
>
    78.649    30.579
    78.668    30.216
>
    78.649    30.579
    78.668    30.216
>
    78.680    29.839
    78.668    30.216
>
    78.680    29.839
    78.668    30.216
>
    79.049    30.019
    78.668    30.216
>
    79.049    30.019
    78.668    30.216
>
    78.975    30.639
    78.668    30.216
>
    78.975    30.639
    78.668    30.216
>
    79.176    30.488
    78.668    30.216
>
    79.176    30.488
    78.668    30.216
>
    79.015    29.750
    78.668    30.216
>
    79.015    29.750
    78.668    30.216
>
    79.288    30.051
    78.668    30.216
>
    79.288    30.051
    78.668    30.216
>
    79.322    30.406
    78.668    30.216
>
    79.210    29.820
    78.668    30.216
>
    79.210    29.820
    78.668    30.216
>
    79.416    30.250
    78.668    30.216
>
    78.330    30.574
    78.288    30.492
>
    78.330    30.574
    78.288    30.492
>
    78.429    30.373
    78.288    30.492
>
    78.429    30.373
    78.288    30.492
>
    78.074    30.455
    78.288    30.492
>
    78.074    30.455
    78.288    30.492
>
    78.436    30.721
    78.288    30.492
>
    78.436    30.721
    78.288    30.492
>
    78.640    30.431
    78.288    30.492
>
    78.640    30.431
    78.288    30.492
>
    78.649    30.579
    78.288    30.492
>
    78.649    30.579
    78.288    30.492
>
    78.287    30.161
    78.288    30.492
>
    78.287    30.161
    78.288    30.492
>
    78.205    30.808
    78.288    30.492
>
    78.205    30.808
    78.288    30.492
>
    77.843    30.518
    78.288    30.492
>
    77.843    30.518
    78.288    30.492
>
    78.605    30.144
    78.288    30.492
>
    78.605    30.144
    78.288    30.492
>
    77.873    30.691
    78.288    30.492
>
    78.377    30.921
    78.288    30.492
>
    78.377    30.921
    78.288    30.492
>
    78.768    30.155
    78.288    30.492
>
    78.768    30.155
    78.288    30.492
>
    78.975    30.639
    78.288    30.492
>
    78.975    30.639
    78.288    30.492
>
    77.845    30.934
    78.288    30.492
>
    77.845    30.934
    78.288    30.492
>
    79.019    30.389
    78.288    30.492
>
    79.019    30.389
    78.288    30.492
>
    78.711    29.924
    78.288    30.492
>
    78.711    29.924
    78.288    30.492
>
    78.680    29.839
    78.288    30.492
>
    78.680    29.839
    78.288    30.492
>
    79.176    30.488
    78.288    30.492
>
    79.176    30.488
    78.288    30.492
>
    78.918    29.916
    78.288    30.492
>
    78.918    29.916
    78.288    30.492
>
    78.605    30.144
    78.503    30.065
>
    78.605    30.144
    78.503    30.065
>
    78.711    29.924
    78.503    30.065
>
    78.711    29.924
    78.503    30.065
>
    78.287    30.161
    78.503    30.065
>
    78.287    30.161
    78.503    30.065
>
    78.768    30.155
    78.503    30.065
>
    78.768    30.155
    78.503    30.065
>
    78.680    29.839
    78.503    30.065
>
    78.680    29.839
    78.503    30.065
>
    78.918    29.916
    78.503    30.065
>
    78.918    29.916
    78.503    30.065
>
    78.640    30.431
    78.503    30.065
>
    78.640    30.431
    78.503    30.065
>
    79.049    30.019
    78.503    30.065
>
    79.049    30.019
    78.503    30.065
>
    78.649    30.579
    78.503    30.065
>
    78.649    30.579
    78.503    30.065
>
    79.015    29.750
    78.503    30.065
>
    79.015    29.750
    78.503    30.065
>
    78.330    30.574
    78.503    30.065
>
    79.019    30.389
    78.503    30.065
>
    79.019    30.389
    78.503    30.065
>
    79.210    29.820
    78.503    30.065
>
    79.210    29.820
    78.503    30.065
>
    78.436    30.721
    78.503    30.065
>
    78.975    30.639
    78.503    30.065
>
    78.975    30.639
    78.503    30.065
>
    79.176    30.488
    78.503    30.065
>
    79.176    30.488
    78.503    30.065
>
    79.673    29.887
    79.871    30.002
>
    79.673    29.887
    79.871    30.002
>
    79.563    30.001
    79.871    30.002
>
    79.563    30.001
    79.871    30.002
>
    79.595    29.852
    79.871    30.002
>
    79.595    29.852
    79.871    30.002
>
    80.164    29.905
    79.871    30.002
>
    80.164    29.905
    79.871    30.002
>
    80.049    29.775
    79.871    30.002
>
    80.049    29.775
    79.871    30.002
>
    80.238    30.066
    79.871    30.002
>
    80.238    30.066
    79.871    30.002
>
    80.040    29.660
    79.871    30.002
>
    80.040    29.660
    79.871    30.002
>
    80.248    29.803
    79.871    30.002
>
    80.248    29.803
    79.871    30.002
>
    79.416    30.250
    79.871    30.002
>
    79.416    30.250
    79.871    30.002
>
    79.376    30.145
    79.871    30.002
>
    79.376    30.145
    79.871    30.002
>
    79.648    29.592
    79.871    30.002
>
    79.648    29.592
    79.871    30.002
>
    79.416    29.770
    79.871    30.002
>
    79.416    29.770
    79.871    30.002
>
    79.288    30.051
    79.871    30.002
>
    79.288    30.051
    79.871    30.002
>
    80.234    29.552
    79.871    30.002
>
    80.234    29.552
    79.871    30.002
>
    79.566    30.538
    79.871    30.002
>
    79.566    30.538
    79.871    30.002
>
    79.210    29.820
    79.871    30.002
>
    79.210    29.820
    79.871    30.002
>
    79.930    29.407
    79.871    30.002
>
    79.930    29.407
    79.871    30.002
>
    80.544    29.849
    79.871    30.002
>
    79.322    30.406
    79.871    30.002
>
    79.322    30.406
    79.871    30.002
>
    79.217    30.265
    79.871    30.002
>
    79.217    30.265
    79.871    30.002
>
    80.094    29.403
    79.871    30.002
>
    80.094    29.403
    79.871    30.002
>
    79.547    29.355
    79.871    30.002
>
    79.547    29.355
    79.871    30.002
>
    80.107    29.330
    79.871    30.002
>
    80.107    29.330
    79.871    30.002
>
    79.049    30.019
    79.871    30.002
>
    79.049    30.019
    79.871    30.002
>
    79.457    29.359
    79.871    30.002
>
    79.457    29.359
    79.871    30.002
>
    79.176    30.488
    79.871    30.002
>
    79.176    30.488
    79.871    30.002
>
    79.015    29.750
    79.871    30.002
>
    79.015    29.750
    79.871    30.002
>
    80.217    29.550
    79.871    30.002
>
    80.217    29.550
    79.871    30.002
>
    80.246    29.450
    79.871    30.002
>
    80.246    29.450
    79.871    30.002
>
    79.558    30.556
    79.871    30.002
>
    79.558    30.556
    79.871    30.002
>
    78.649    30.579
    78.604    30.625
>
    78.649    30.579
    78.604    30.625
>
    78.436    30.721
    78.604    30.625
>
    78.436    30.721
    78.604    30.625
>
    78.640    30.431
    78.604    30.625
>
    78.640    30.431
    78.604    30.625
>
    78.330    30.574
    78.604    30.625
>
    78.330    30.574
    78.604    30.625
>
    78.975    30.639
    78.604    30.625
>
    78.975    30.639
    78.604    30.625
>
    78.377    30.921
    78.604    30.625
>
    78.205    30.808
    78.604    30.625
>
    79.019    30.389
    78.604    30.625
>
    79.019    30.389
    78.604    30.625
>
    78.753    31.036
    78.604    30.625
>
    78.605    30.144
    78.604    30.625
>
    78.605    30.144
    78.604    30.625
>
    78.768    30.155
    78.604    30.625
>
    78.768    30.155
    78.604    30.625
>
    78.074    30.455
    78.604    30.625
>
    78.074    30.455
    78.604    30.625
>
    79.176    30.488
    78.604    30.625
>
    79.176    30.488
    78.604    30.625
>
    77.873    30.691
    78.604    30.625
>
    78.711    29.924
    78.604    30.625
>
    79.049    30.019
    78.604    30.625
>
    79.049    30.019
    78.604    30.625
>
    77.845    30.934
    78.604    30.625
>
    78.918    29.916
    78.604    30.625
>
    78.680    29.839
    78.604    30.625
>
    78.605    30.144
    78.624    30.192
>
    78.605    30.144
    78.624    30.192
>
    78.768    30.155
    78.624    30.192
>
    78.640    30.431
    78.624    30.192
>
    78.429    30.373
    78.624    30.192
>
    78.429    30.373
    78.624    30.192
>
    78.711    29.924
    78.624    30.192
>
    78.287    30.161
    78.624    30.192
>
    78.287    30.161
    78.624    30.192
>
    78.680    29.839
    78.624    30.192
>
    78.680    29.839
    78.624    30.192
>
    78.918    29.916
    78.624    30.192
>
    79.019    30.389
    78.624    30.192
>
    79.019    30.389
    78.624    30.192
>
    78.649    30.579
    78.624    30.192
>
    78.330    30.574
    78.624    30.192
>
    78.330    30.574
    78.624    30.192
>
    78.975    30.639
    78.624    30.192
>
    79.288    30.051
    78.624    30.192
>
    79.288    30.051
    78.624    30.192
>
    78.649    30.579
    78.703    30.667
>
    78.649    30.579
    78.703    30.667
>
    78.975    30.639
    78.703    30.667
>
    78.975    30.639
    78.703    30.667
>
    78.640    30.431
    78.703    30.667
>
    78.640    30.431
    78.703    30.667
>
    78.436    30.721
    78.703    30.667
>
    78.436    30.721
    78.703    30.667
>
    78.330    30.574
    78.703    30.667
>
    78.330    30.574
    78.703    30.667
>
    79.019    30.389
    78.703    30.667
>
    79.019    30.389
    78.703    30.667
>
    78.429    30.373
    78.703    30.667
>
    78.429    30.373
    78.703    30.667
>
    78.753    31.036
    78.703    30.667
>
    78.753    31.036
    78.703    30.667
>
    78.377    30.921
    78.703    30.667
>
    79.176    30.488
    78.703    30.667
>
    79.176    30.488
    78.703    30.667
>
    78.205    30.808
    78.703    30.667
>
    78.205    30.808
    78.703    30.667
>
    78.768    30.155
    78.703    30.667
>
    78.768    30.155
    78.703    30.667
>
    78.605    30.144
    78.703    30.667
>
    78.605    30.144
    78.703    30.667
>
    79.322    30.406
    78.703    30.667
>
    79.217    30.265
    78.703    30.667
>
    79.217    30.265
    78.703    30.667
>
    78.074    30.455
    78.703    30.667
>
    78.074    30.455
    78.703    30.667
>
    78.711    29.924
    78.703    30.667
>
    78.711    29.924
    78.703    30.667
>
    77.873    30.691
    78.703    30.667
>
    77.873    30.691
    78.703    30.667
>
    79.566    30.538
    78.703    30.667
>
    79.566    30.538
    78.703    30.667
>
    79.416    30.250
    78.703    30.667
>
    79.416    30.250
    78.703    30.667
>
    78.918    29.916
    78.703    30.667
>
    79.376    30.145
    78.703    30.667
>
    77.843    30.518
    78.703    30.667
>
    77.843    30.518
    78.703    30.667
>
    79.288    30.051
    78.703    30.667
>
    79.288    30.051
    78.703    30.667
>
    77.845    30.934
    78.703    30.667
>
    77.845    30.934
    78.703    30.667
>
    78.436    30.721
    78.576    30.782
>
    78.436    30.721
    78.576    30.782
>
    78.649    30.579
    78.576    30.782
>
    78.649    30.579
    78.576    30.782
>
    78.377    30.921
    78.576    30.782
>
    78.753    31.036
    78.576    30.782
>
    78.330    30.574
    78.576    30.782
>
    78.330    30.574
    78.576    30.782
>
    78.205    30.808
    78.576    30.782
>
    78.205    30.808
    78.576    30.782
>
    78.640    30.431
    78.576    30.782
>
    78.640    30.431
    78.576    30.782
>
    78.975    30.639
    78.576    30.782
>
    78.975    30.639
    78.576    30.782
>
    78.429    30.373
    78.576    30.782
>
    78.429    30.373
    78.576    30.782
>
    79.019    30.389
    78.576    30.782
>
    79.019    30.389
    78.576    30.782
>
    79.176    30.488
    78.576    30.782
>
    79.176    30.488
    78.576    30.782
>
    78.605    30.144
    78.576    30.782
>
    78.605    30.144
    78.576    30.782
>
    77.873    30.691
    78.576    30.782
>
    77.873    30.691
    78.576    30.782
>
    78.436    30.721
    78.507    30.775
>
    78.436    30.721
    78.507    30.775
>
    78.377    30.921
    78.507    30.775
>
    78.377    30.921
    78.507    30.775
>
    78.649    30.579
    78.507    30.775
>
    78.649    30.579
    78.507    30.775
>
    78.330    30.574
    78.507    30.775
>
    78.330    30.574
    78.507    30.775
>
    78.205    30.808
    78.507    30.775
>
    78.205    30.808
    78.507    30.775
>
    78.640    30.431
    78.507    30.775
>
    78.640    30.431
    78.507    30.775
>
    78.975    30.639
    78.507    30.775
>
    78.429    30.373
    78.507    30.775
>
    78.429    30.373
    78.507    30.775
>
    78.074    30.455
    78.507    30.775
>
    78.074    30.455
    78.507    30.775
>
    77.873    30.691
    78.507    30.775
>
    77.873    30.691
    78.507    30.775
>
    77.845    30.934
    78.507    30.775
>
    77.845    30.934
    78.507    30.775
>
    79.176    30.488
    78.507    30.775
>
    78.605    30.144
    78.507    30.775
>
    78.605    30.144
    78.507    30.775
>
    78.287    30.161
    78.507    30.775
>
    78.287    30.161
    78.507    30.775
>
    78.768    30.155
    78.507    30.775
>
    78.768    30.155
    78.507    30.775
>
    79.217    30.265
    78.507    30.775
>
    78.436    30.721
    78.550    30.732
>
    78.436    30.721
    78.550    30.732
>
    78.649    30.579
    78.550    30.732
>
    78.649    30.579
    78.550    30.732
>
    78.330    30.574
    78.550    30.732
>
    78.330    30.574
    78.550    30.732
>
    78.377    30.921
    78.550    30.732
>
    78.377    30.921
    78.550    30.732
>
    78.640    30.431
    78.550    30.732
>
    78.640    30.431
    78.550    30.732
>
    78.205    30.808
    78.550    30.732
>
    78.205    30.808
    78.550    30.732
>
    78.753    31.036
    78.550    30.732
>
    78.753    31.036
    78.550    30.732
>
    78.975    30.639
    78.550    30.732
>
    78.975    30.639
    78.550    30.732
>
    78.429    30.373
    78.550    30.732
>
    78.429    30.373
    78.550    30.732
>
    78.074    30.455
    78.550    30.732
>
    79.176    30.488
    78.550    30.732
>
    79.176    30.488
    78.550    30.732
>
    78.605    30.144
    78.550    30.732
>
    78.605    30.144
    78.550    30.732
>
    78.768    30.155
    78.550    30.732
>
    78.768    30.155
    78.550    30.732
>
    77.873    30.691
    78.550    30.732
>
    77.873    30.691
    78.550    30.732
>
    77.845    30.934
    78.550    30.732
>
    77.845    30.934
    78.550    30.732
>
    77.843    30.518
    78.550    30.732
>
    77.843    30.518
    78.550    30.732
>
    79.217    30.265
    78.550    30.732
>
    79.217    30.265
    78.550    30.732
>
    78.287    30.161
    78.268    30.198
>
    78.287    30.161
    78.268    30.198
>
    78.429    30.373
    78.268    30.198
>
    78.429    30.373
    78.268    30.198
>
    78.605    30.144
    78.268    30.198
>
    78.605    30.144
    78.268    30.198
>
    78.074    30.455
    78.268    30.198
>
    78.074    30.455
    78.268    30.198
>
    78.640    30.431
    78.268    30.198
>
    78.640    30.431
    78.268    30.198
>
    78.768    30.155
    78.268    30.198
>
    78.768    30.155
    78.268    30.198
>
    78.680    29.839
    78.268    30.198
>
    78.649    30.579
    78.268    30.198
>
    78.649    30.579
    78.268    30.198
>
    77.843    30.518
    78.268    30.198
>
    77.843    30.518
    78.268    30.198
>
    78.436    30.721
    78.268    30.198
>
    78.918    29.916
    78.268    30.198
>
    78.918    29.916
    78.268    30.198
>
    77.873    30.691
    78.268    30.198
>
    78.205    30.808
    78.268    30.198
>
    78.205    30.808
    78.268    30.198
>
    78.975    30.639
    78.268    30.198
>
    78.975    30.639
    78.268    30.198
>
    79.015    29.750
    78.268    30.198
>
    79.015    29.750
    78.268    30.198
>
    79.322    30.406
    79.450    30.392
>
    79.322    30.406
    79.450    30.392
>
    79.416    30.250
    79.450    30.392
>
    79.416    30.250
    79.450    30.392
>
    79.566    30.538
    79.450    30.392
>
    79.566    30.538
    79.450    30.392
>
    79.217    30.265
    79.450    30.392
>
    79.217    30.265
    79.450    30.392
>
    79.376    30.145
    79.450    30.392
>
    79.376    30.145
    79.450    30.392
>
    79.176    30.488
    79.450    30.392
>
    79.176    30.488
    79.450    30.392
>
    79.288    30.051
    79.450    30.392
>
    79.288    30.051
    79.450    30.392
>
    79.563    30.001
    79.450    30.392
>
    79.563    30.001
    79.450    30.392
>
    78.975    30.639
    79.450    30.392
>
    78.975    30.639
    79.450    30.392
>
    79.049    30.019
    79.450    30.392
>
    79.673    29.887
    79.450    30.392
>
    79.673    29.887
    79.450    30.392
>
    79.595    29.852
    79.450    30.392
>
    79.595    29.852
    79.450    30.392
>
    79.210    29.820
    79.450    30.392
>
    79.210    29.820
    79.450    30.392
>
    79.416    29.770
    79.450    30.392
>
    79.416    29.770
    79.450    30.392
>
    78.768    30.155
    79.450    30.392
>
    78.768    30.155
    79.450    30.392
>
    78.918    29.916
    79.450    30.392
>
    78.918    29.916
    79.450    30.392
>
    78.640    30.431
    79.450    30.392
>
    78.649    30.579
    79.450    30.392
>
    79.015    29.750
    79.450    30.392
>
    79.015    29.750
    79.450    30.392
>
    80.238    30.066
    79.450    30.392
>
    78.605    30.144
    79.450    30.392
>
    78.605    30.144
    79.450    30.392
>
    78.711    29.924
    79.450    30.392
>
    78.711    29.924
    79.450    30.392
>
    80.164    29.905
    79.450    30.392
>
    80.164    29.905
    79.450    30.392
>
    79.673    29.887
    79.864    29.993
>
    79.673    29.887
    79.864    29.993
>
    79.563    30.001
    79.864    29.993
>
    79.563    30.001
    79.864    29.993
>
    79.595    29.852
    79.864    29.993
>
    79.595    29.852
    79.864    29.993
>
    80.049    29.775
    79.864    29.993
>
    80.049    29.775
    79.864    29.993
>
    80.164    29.905
    79.864    29.993
>
    80.164    29.905
    79.864    29.993
>
    80.238    30.066
    79.864    29.993
>
    80.238    30.066
    79.864    29.993
>
    80.040    29.660
    79.864    29.993
>
    80.040    29.660
    79.864    29.993
>
    80.248    29.803
    79.864    29.993
>
    80.248    29.803
    79.864    29.993
>
    79.648    29.592
    79.864    29.993
>
    79.648    29.592
    79.864    29.993
>
    79.416    29.770
    79.864    29.993
>
    79.416    29.770
    79.864    29.993
>
    79.416    30.250
    79.864    29.993
>
    79.416    30.250
    79.864    29.993
>
    79.376    30.145
    79.864    29.993
>
    79.376    30.145
    79.864    29.993
>
    79.288    30.051
    79.864    29.993
>
    79.288    30.051
    79.864    29.993
>
    80.234    29.552
    79.864    29.993
>
    80.234    29.552
    79.864    29.993
>
    79.210    29.820
    79.864    29.993
>
    79.930    29.407
    79.864    29.993
>
    79.930    29.407
    79.864    29.993
>
    79.566    30.538
    79.864    29.993
>
    79.566    30.538
    79.864    29.993
>
    79.217    30.265
    79.864    29.993
>
    79.217    30.265
    79.864    29.993
>
    79.322    30.406
    79.864    29.993
>
    79.322    30.406
    79.864    29.993
>
    80.094    29.403
    79.864    29.993
>
    80.094    29.403
    79.864    29.993
>
    79.547    29.355
    79.864    29.993
>
    79.547    29.355
    79.864    29.993
>
    79.457    29.359
    79.864    29.993
>
    80.107    29.330
    79.864    29.993
>
    80.107    29.330
    79.864    29.993
>
    79.049    30.019
    79.864    29.993
>
    79.049    30.019
    79.864    29.993
>
    79.176    30.488
    79.864    29.993
>
    79.176    30.488
    79.864    29.993
>
    78.649    30.579
    78.582    30.708
>
    78.649    30.579
    78.582    30.708
>
    78.436    30.721
    78.582    30.708
>
    78.436    30.721
    78.582    30.708
>
    78.640    30.431
    78.582    30.708
>
    78.640    30.431
    78.582    30.708
>
    78.330    30.574
    78.582    30.708
>
    78.330    30.574
    78.582    30.708
>
    78.377    30.921
    78.582    30.708
>
    78.975    30.639
    78.582    30.708
>
    78.975    30.639
    78.582    30.708
>
    78.429    30.373
    78.582    30.708
>
    78.429    30.373
    78.582    30.708
>
    78.205    30.808
    78.582    30.708
>
    78.205    30.808
    78.582    30.708
>
    78.753    31.036
    78.582    30.708
>
    78.244    30.427
    78.582    30.708
>
    78.074    30.455
    78.582    30.708
>
    78.074    30.455
    78.582    30.708
>
    79.176    30.488
    78.582    30.708
>
    79.176    30.488
    78.582    30.708
>
    78.605    30.144
    78.582    30.708
>
    78.605    30.144
    78.582    30.708
>
    78.768    30.155
    78.582    30.708
>
    78.768    30.155
    78.582    30.708
>
    78.287    30.161
    78.582    30.708
>
    78.287    30.161
    78.582    30.708
>
    77.873    30.691
    78.582    30.708
>
    77.873    30.691
    78.582    30.708
>
    77.843    30.518
    78.582    30.708
>
    77.843    30.518
    78.582    30.708
>
    79.217    30.265
    78.582    30.708
>
    79.217    30.265
    78.582    30.708
>
    79.322    30.406
    78.582    30.708
>
    79.322    30.406
    78.582    30.708
>
    77.845    30.934
    78.582    30.708
>
    77.845    30.934
    78.582    30.708
>
    78.711    29.924
    78.582    30.708
>
    78.711    29.924
    78.582    30.708
>
    79.049    30.019
    78.582    30.708
>
    79.049    30.019
    78.582    30.708
>
    78.975    30.639
    78.857    30.700
>
    78.975    30.639
    78.857    30.700
>
    78.649    30.579
    78.857    30.700
>
    78.649    30.579
    78.857    30.700
>
    78.640    30.431
    78.857    30.700
>
    78.640    30.431
    78.857    30.700
>
    79.176    30.488
    78.857    30.700
>
    79.176    30.488
    78.857    30.700
>
    78.753    31.036
    78.857    30.700
>
    78.753    31.036
    78.857    30.700
>
    78.436    30.721
    78.857    30.700
>
    78.436    30.721
    78.857    30.700
>
    78.605    30.144
    78.857    30.700
>
    79.049    30.019
    78.857    30.700
>
    79.049    30.019
    78.857    30.700
>
    78.918    29.916
    78.857    30.700
>
    78.918    29.916
    78.857    30.700
>
    79.176    30.488
    79.320    30.606
>
    79.176    30.488
    79.320    30.606
>
    79.322    30.406
    79.320    30.606
>
    79.322    30.406
    79.320    30.606
>
    79.566    30.538
    79.320    30.606
>
    79.566    30.538
    79.320    30.606
>
    78.975    30.639
    79.320    30.606
>
    78.975    30.639
    79.320    30.606
>
    79.217    30.265
    79.320    30.606
>
    79.217    30.265
    79.320    30.606
>
    79.416    30.250
    79.320    30.606
>
    79.416    30.250
    79.320    30.606
>
    79.376    30.145
    79.320    30.606
>
    79.376    30.145
    79.320    30.606
>
    79.288    30.051
    79.320    30.606
>
    79.288    30.051
    79.320    30.606
>
    78.649    30.579
    79.320    30.606
>
    78.649    30.579
    79.320    30.606
>
    78.640    30.431
    79.320    30.606
>
    78.640    30.431
    79.320    30.606
>
    79.049    30.019
    79.320    30.606
>
    79.563    30.001
    79.320    30.606
>
    79.563    30.001
    79.320    30.606
>
    78.768    30.155
    79.320    30.606
>
    78.768    30.155
    79.320    30.606
>
    78.918    29.916
    79.320    30.606
>
    78.918    29.916
    79.320    30.606
>
    78.605    30.144
    79.320    30.606
>
    78.605    30.144
    79.320    30.606
>
    79.673    29.887
    79.320    30.606
>
    79.673    29.887
    79.320    30.606
>
    78.436    30.721
    79.320    30.606
>
    78.436    30.721
    79.320    30.606
>
    79.210    29.820
    79.320    30.606
>
    79.210    29.820
    79.320    30.606
>
    79.595    29.852
    79.320    30.606
>
    79.595    29.852
    79.320    30.606
>
    79.176    30.488
    79.320    30.606
>
    79.322    30.406
    79.320    30.606
>
    79.217    30.265
    79.320    30.606
>
    79.416    30.250
    79.320    30.606
>
    79.416    30.250
    79.320    30.606
>
    79.376    30.145
    79.320    30.606
>
    78.649    30.579
    79.320    30.606
>
    78.640    30.431
    79.320    30.606
>
    79.049    30.019
    79.320    30.606
>
    79.563    30.001
    79.320    30.606
>
    78.768    30.155
    79.320    30.606
>
    78.768    30.155
    79.320    30.606
>
    78.918    29.916
    79.320    30.606
>
    78.918    29.916
    79.320    30.606
>
    78.605    30.144
    79.320    30.606
>
    79.673    29.887
    79.320    30.606
>
    79.673    29.887
    79.320    30.606
>
    79.210    29.820
    79.320    30.606
>
    78.436    30.721
    79.320    30.606
>
    79.595    29.852
    79.320    30.606
>
    79.558    30.556
    79.320    30.606
>
    79.558    30.556
    79.320    30.606
>
    78.446    30.730
    79.320    30.606
>
    78.446    30.730
    79.320    30.606
>
    79.322    30.406
    79.319    30.541
>
    79.322    30.406
    79.319    30.541
>
    79.176    30.488
    79.319    30.541
>
    79.176    30.488
    79.319    30.541
>
    79.566    30.538
    79.319    30.541
>
    79.566    30.538
    79.319    30.541
>
    79.217    30.265
    79.319    30.541
>
    79.217    30.265
    79.319    30.541
>
    79.416    30.250
    79.319    30.541
>
    79.416    30.250
    79.319    30.541
>
    78.975    30.639
    79.319    30.541
>
    78.975    30.639
    79.319    30.541
>
    79.376    30.145
    79.319    30.541
>
    79.376    30.145
    79.319    30.541
>
    79.288    30.051
    79.319    30.541
>
    79.288    30.051
    79.319    30.541
>
    79.049    30.019
    79.319    30.541
>
    79.563    30.001
    79.319    30.541
>
    79.563    30.001
    79.319    30.541
>
    78.649    30.579
    79.319    30.541
>
    78.649    30.579
    79.319    30.541
>
    78.640    30.431
    79.319    30.541
>
    78.640    30.431
    79.319    30.541
>
    78.768    30.155
    79.319    30.541
>
    78.768    30.155
    79.319    30.541
>
    78.918    29.916
    79.319    30.541
>
    78.918    29.916
    79.319    30.541
>
    79.673    29.887
    79.319    30.541
>
    79.673    29.887
    79.319    30.541
>
    79.210    29.820
    79.319    30.541
>
    79.210    29.820
    79.319    30.541
>
    79.595    29.852
    79.319    30.541
>
    79.595    29.852
    79.319    30.541
>
    78.605    30.144
    79.319    30.541
>
    78.605    30.144
    79.319    30.541
>
    79.416    29.770
    79.319    30.541
>
    79.416    29.770
    79.319    30.541
>
    78.429    30.373
    79.319    30.541
>
    78.429    30.373
    79.319    30.541
>
    78.436    30.721
    79.319    30.541
>
    78.436    30.721
    79.319    30.541
>
    79.563    30.001
    79.889    30.172
>
    79.563    30.001
    79.889    30.172
>
    80.238    30.066
    79.889    30.172
>
    80.238    30.066
    79.889    30.172
>
    79.673    29.887
    79.889    30.172
>
    79.673    29.887
    79.889    30.172
>
    80.164    29.905
    79.889    30.172
>
    80.164    29.905
    79.889    30.172
>
    79.416    30.250
    79.889    30.172
>
    79.416    30.250
    79.889    30.172
>
    79.595    29.852
    79.889    30.172
>
    79.595    29.852
    79.889    30.172
>
    80.049    29.775
    79.889    30.172
>
    80.049    29.775
    79.889    30.172
>
    79.566    30.538
    79.889    30.172
>
    79.566    30.538
    79.889    30.172
>
    80.248    29.803
    79.889    30.172
>
    80.248    29.803
    79.889    30.172
>
    80.040    29.660
    79.889    30.172
>
    80.040    29.660
    79.889    30.172
>
    79.288    30.051
    79.889    30.172
>
    79.288    30.051
    79.889    30.172
>
    79.416    29.770
    79.889    30.172
>
    79.648    29.592
    79.889    30.172
>
    79.648    29.592
    79.889    30.172
>
    79.210    29.820
    79.889    30.172
>
    79.210    29.820
    79.889    30.172
>
    80.234    29.552
    79.889    30.172
>
    80.234    29.552
    79.889    30.172
>
    79.176    30.488
    79.889    30.172
>
    79.176    30.488
    79.889    30.172
>
    79.049    30.019
    79.889    30.172
>
    79.930    29.407
    79.889    30.172
>
    79.930    29.407
    79.889    30.172
>
    80.094    29.403
    79.889    30.172
>
    80.094    29.403
    79.889    30.172
>
    78.436    30.721
    78.543    30.713
>
    78.649    30.579
    78.543    30.713
>
    78.330    30.574
    78.543    30.713
>
    78.330    30.574
    78.543    30.713
>
    78.377    30.921
    78.543    30.713
>
    78.640    30.431
    78.543    30.713
>
    78.640    30.431
    78.543    30.713
>
    78.205    30.808
    78.543    30.713
>
    78.205    30.808
    78.543    30.713
>
    78.429    30.373
    78.543    30.713
>
    78.429    30.373
    78.543    30.713
>
    78.975    30.639
    78.543    30.713
>
    78.975    30.639
    78.543    30.713
>
    78.074    30.455
    78.543    30.713
>
    78.074    30.455
    78.543    30.713
>
    78.768    30.155
    78.543    30.713
>
    78.768    30.155
    78.543    30.713
>
    79.176    30.488
    78.543    30.713
>
    79.176    30.488
    78.543    30.713
>
    77.873    30.691
    78.543    30.713
>
    77.873    30.691
    78.543    30.713
>
    80.164    29.905
    80.105    30.000
>
    80.164    29.905
    80.105    30.000
>
    80.238    30.066
    80.105    30.000
>
    80.238    30.066
    80.105    30.000
>
    80.049    29.775
    80.105    30.000
>
    80.049    29.775
    80.105    30.000
>
    80.248    29.803
    80.105    30.000
>
    80.248    29.803
    80.105    30.000
>
    80.040    29.660
    80.105    30.000
>
    80.040    29.660
    80.105    30.000
>
    79.673    29.887
    80.105    30.000
>
    79.673    29.887
    80.105    30.000
>
    79.595    29.852
    80.105    30.000
>
    79.595    29.852
    80.105    30.000
>
    79.563    30.001
    80.105    30.000
>
    79.563    30.001
    80.105    30.000
>
    80.234    29.552
    80.105    30.000
>
    80.234    29.552
    80.105    30.000
>
    79.648    29.592
    80.105    30.000
>
    79.648    29.592
    80.105    30.000
>
    80.094    29.403
    80.105    30.000
>
    80.094    29.403
    80.105    30.000
>
    79.930    29.407
    80.105    30.000
>
    79.930    29.407
    80.105    30.000
>
    79.416    29.770
    80.105    30.000
>
    79.416    29.770
    80.105    30.000
>
    80.107    29.330
    80.105    30.000
>
    80.107    29.330
    80.105    30.000
>
    79.288    30.051
    80.105    30.000
>
    79.566    30.538
    80.105    30.000
>
    79.322    30.406
    80.105    30.000
>
    79.210    29.820
    80.105    30.000
>
    77.873    30.691
    77.837    30.798
>
    77.873    30.691
    77.837    30.798
>
    77.845    30.934
    77.837    30.798
>
    77.845    30.934
    77.837    30.798
>
    77.843    30.518
    77.837    30.798
>
    77.843    30.518
    77.837    30.798
>
    78.205    30.808
    77.837    30.798
>
    78.205    30.808
    77.837    30.798
>
    78.074    30.455
    77.837    30.798
>
    78.074    30.455
    77.837    30.798
>
    78.330    30.574
    77.837    30.798
>
    78.330    30.574
    77.837    30.798
>
    78.377    30.921
    77.837    30.798
>
    78.436    30.721
    77.837    30.798
>
    78.436    30.721
    77.837    30.798
>
    78.429    30.373
    77.837    30.798
>
    78.429    30.373
    77.837    30.798
>
    78.649    30.579
    77.837    30.798
>
    78.649    30.579
    77.837    30.798
>
    78.287    30.161
    77.837    30.798
>
    78.287    30.161
    77.837    30.798
>
    78.640    30.431
    77.837    30.798
>
    78.640    30.431
    77.837    30.798
>
    80.164    29.905
    80.188    29.899
>
    80.164    29.905
    80.188    29.899
>
    80.049    29.775
    80.188    29.899
>
    80.049    29.775
    80.188    29.899
>
    80.238    30.066
    80.188    29.899
>
    80.238    30.066
    80.188    29.899
>
    80.040    29.660
    80.188    29.899
>
    80.040    29.660
    80.188    29.899
>
    80.234    29.552
    80.188    29.899
>
    80.234    29.552
    80.188    29.899
>
    79.673    29.887
    80.188    29.899
>
    79.673    29.887
    80.188    29.899
>
    80.094    29.403
    80.188    29.899
>
    80.094    29.403
    80.188    29.899
>
    79.595    29.852
    80.188    29.899
>
    79.595    29.852
    80.188    29.899
>
    79.930    29.407
    80.188    29.899
>
    79.930    29.407
    80.188    29.899
>
    79.563    30.001
    80.188    29.899
>
    79.563    30.001
    80.188    29.899
>
    80.107    29.330
    80.188    29.899
>
    80.107    29.330
    80.188    29.899
>
    80.164    29.905
    79.975    30.050
>
    80.164    29.905
    79.975    30.050
>
    80.238    30.066
    79.975    30.050
>
    80.238    30.066
    79.975    30.050
>
    80.049    29.775
    79.975    30.050
>
    80.049    29.775
    79.975    30.050
>
    79.673    29.887
    79.975    30.050
>
    79.673    29.887
    79.975    30.050
>
    80.248    29.803
    79.975    30.050
>
    80.248    29.803
    79.975    30.050
>
    79.563    30.001
    79.975    30.050
>
    79.563    30.001
    79.975    30.050
>
    79.595    29.852
    79.975    30.050
>
    79.595    29.852
    79.975    30.050
>
    80.040    29.660
    79.975    30.050
>
    80.040    29.660
    79.975    30.050
>
    79.416    30.250
    79.975    30.050
>
    79.416    30.250
    79.975    30.050
>
    79.376    30.145
    79.975    30.050
>
    79.648    29.592
    79.975    30.050
>
    79.416    29.770
    79.975    30.050
>
    79.416    29.770
    79.975    30.050
>
    79.930    29.407
    79.975    30.050
>
    79.930    29.407
    79.975    30.050
>
    80.094    29.403
    79.975    30.050
>
    80.094    29.403
    79.975    30.050
>
    79.217    30.265
    79.975    30.050
>
    79.217    30.265
    79.975    30.050
>
    79.210    29.820
    79.975    30.050
>
    79.210    29.820
    79.975    30.050
>
    80.107    29.330
    79.975    30.050
>
    80.107    29.330
    79.975    30.050
>
    78.918    29.916
    78.770    29.999
>
    78.918    29.916
    78.770    29.999
>
    78.768    30.155
    78.770    29.999
>
    78.768    30.155
    78.770    29.999
>
    78.680    29.839
    78.770    29.999
>
    78.680    29.839
    78.770    29.999
>
    78.605    30.144
    78.770    29.999
>
    78.605    30.144
    78.770    29.999
>
    79.015    29.750
    78.770    29.999
>
    79.210    29.820
    78.770    29.999
>
    79.210    29.820
    78.770    29.999
>
    79.288    30.051
    78.770    29.999
>
    79.288    30.051
    78.770    29.999
>
    78.287    30.161
    78.770    29.999
>
    78.287    30.161
    78.770    29.999
>
    79.217    30.265
    78.770    29.999
>
    79.217    30.265
    78.770    29.999
>
    78.429    30.373
    78.770    29.999
>
    78.429    30.373
    78.770    29.999
>
    79.376    30.145
    78.770    29.999
>
    79.376    30.145
    78.770    29.999
>
    79.176    30.488
    78.770    29.999
>
    79.176    30.488
    78.770    29.999
>
    79.416    29.770
    78.770    29.999
>
    79.416    29.770
    78.770    29.999
>
    79.416    30.250
    78.770    29.999
>
    79.416    30.250
    78.770    29.999
>
    78.975    30.639
    78.770    29.999
>
    78.975    30.639
    78.770    29.999
>
    79.563    30.001
    78.770    29.999
>
    79.563    30.001
    78.770    29.999
>
    78.330    30.574
    78.770    29.999
>
    78.330    30.574
    78.770    29.999
>
    79.595    29.852
    78.770    29.999
>
    79.595    29.852
    78.770    29.999
>
    79.673    29.887
    78.770    29.999
>
    79.673    29.887
    78.770    29.999
>
    78.377    30.921
    78.361    30.851
>
    78.377    30.921
    78.361    30.851
>
    78.436    30.721
    78.361    30.851
>
    78.436    30.721
    78.361    30.851
>
    78.205    30.808
    78.361    30.851
>
    78.205    30.808
    78.361    30.851
>
    77.873    30.691
    78.361    30.851
>
    77.873    30.691
    78.361    30.851
>
    78.429    30.373
    78.361    30.851
>
    78.429    30.373
    78.361    30.851
>
    78.074    30.455
    78.361    30.851
>
    78.074    30.455
    78.361    30.851
>
    77.845    30.934
    78.361    30.851
>
    77.845    30.934
    78.361    30.851
>
    78.975    30.639
    78.361    30.851
>
    78.287    30.161
    78.361    30.851
>
    78.287    30.161
    78.361    30.851
>
    78.605    30.144
    78.361    30.851
>
    78.605    30.144
    78.361    30.851
>
    79.176    30.488
    79.157    30.483
>
    79.176    30.488
    79.157    30.483
>
    79.322    30.406
    79.157    30.483
>
    79.322    30.406
    79.157    30.483
>
    79.217    30.265
    79.157    30.483
>
    79.217    30.265
    79.157    30.483
>
    78.975    30.639
    79.157    30.483
>
    78.975    30.639
    79.157    30.483
>
    79.416    30.250
    79.157    30.483
>
    79.416    30.250
    79.157    30.483
>
    79.566    30.538
    79.157    30.483
>
    79.376    30.145
    79.157    30.483
>
    79.376    30.145
    79.157    30.483
>
    79.288    30.051
    79.157    30.483
>
    79.288    30.051
    79.157    30.483
>
    78.640    30.431
    79.157    30.483
>
    78.640    30.431
    79.157    30.483
>
    78.649    30.579
    79.157    30.483
>
    78.649    30.579
    79.157    30.483
>
    78.768    30.155
    79.157    30.483
>
    78.768    30.155
    79.157    30.483
>
    78.605    30.144
    79.157    30.483
>
    78.605    30.144
    79.157    30.483
>
    78.918    29.916
    79.157    30.483
>
    78.918    29.916
    79.157    30.483
>
    79.563    30.001
    79.157    30.483
>
    78.429    30.373
    79.157    30.483
>
    78.429    30.373
    79.157    30.483
>
    79.210    29.820
    79.157    30.483
>
    79.210    29.820
    79.157    30.483
>
    78.711    29.924
    79.157    30.483
>
    78.711    29.924
    79.157    30.483
>
    78.436    30.721
    79.157    30.483
>
    78.436    30.721
    79.157    30.483
>
    78.330    30.574
    79.157    30.483
>
    78.330    30.574
    79.157    30.483
>
    79.015    29.750
    79.157    30.483
>
    79.015    29.750
    79.157    30.483
>
    79.595    29.852
    79.157    30.483
>
    79.595    29.852
    79.157    30.483
>
    79.416    29.770
    79.157    30.483
>
    79.416    29.770
    79.157    30.483
>
    79.673    29.887
    79.157    30.483
>
    79.673    29.887
    79.157    30.483
>
    78.680    29.839
    79.157    30.483
>
    78.680    29.839
    79.157    30.483
>
    78.975    30.639
    78.842    30.619
>
    78.975    30.639
    78.842    30.619
>
    78.649    30.579
    78.842    30.619
>
    78.640    30.431
    78.842    30.619
>
    78.640    30.431
    78.842    30.619
>
    79.019    30.389
    78.842    30.619
>
    79.019    30.389
    78.842    30.619
>
    79.176    30.488
    78.842    30.619
>
    79.176    30.488
    78.842    30.619
>
    78.436    30.721
    78.842    30.619
>
    78.436    30.721
    78.842    30.619
>
    78.429    30.373
    78.842    30.619
>
    78.429    30.373
    78.842    30.619
>
    78.753    31.036
    78.842    30.619
>
    79.322    30.406
    78.842    30.619
>
    78.768    30.155
    78.842    30.619
>
    78.768    30.155
    78.842    30.619
>
    78.330    30.574
    78.842    30.619
>
    78.330    30.574
    78.842    30.619
>
    79.217    30.265
    78.842    30.619
>
    79.217    30.265
    78.842    30.619
>
    78.605    30.144
    78.842    30.619
>
    78.605    30.144
    78.842    30.619
>
    78.377    30.921
    78.842    30.619
>
    78.205    30.808
    78.842    30.619
>
    79.049    30.019
    78.842    30.619
>
    79.049    30.019
    78.842    30.619
>
    79.416    30.250
    78.842    30.619
>
    79.566    30.538
    78.842    30.619
>
    79.566    30.538
    78.842    30.619
>
    79.376    30.145
    78.842    30.619
>
    79.376    30.145
    78.842    30.619
>
    78.287    30.161
    78.842    30.619
>
    78.287    30.161
    78.842    30.619
>
    79.288    30.051
    78.842    30.619
>
    79.288    30.051
    78.842    30.619
>
    78.918    29.916
    78.842    30.619
>
    78.918    29.916
    78.842    30.619
>
    78.711    29.924
    78.842    30.619
>
    78.711    29.924
    78.842    30.619
>
    78.074    30.455
    78.842    30.619
>
    78.074    30.455
    78.842    30.619
>
    78.680    29.839
    78.842    30.619
>
    78.680    29.839
    78.842    30.619
>
    78.446    30.730
    78.842    30.619
>
    79.558    30.556
    78.842    30.619
>
    79.558    30.556
    78.842    30.619
>
    78.711    29.924
    78.783    29.983
>
    78.918    29.916
    78.783    29.983
>
    78.768    30.155
    78.783    29.983
>
    78.680    29.839
    78.783    29.983
>
    78.680    29.839
    78.783    29.983
>
    78.605    30.144
    78.783    29.983
>
    78.605    30.144
    78.783    29.983
>
    79.015    29.750
    78.783    29.983
>
    79.015    29.750
    78.783    29.983
>
    79.210    29.820
    78.783    29.983
>
    79.217    30.265
    78.783    29.983
>
    79.217    30.265
    78.783    29.983
>
    78.640    30.431
    78.783    29.983
>
    78.640    30.431
    78.783    29.983
>
    78.429    30.373
    78.783    29.983
>
    79.416    29.770
    78.783    29.983
>
    79.416    29.770
    78.783    29.983
>
    79.176    30.488
    78.783    29.983
>
    79.176    30.488
    78.783    29.983
>
    79.416    30.250
    78.783    29.983
>
    79.416    30.250
    78.783    29.983
>
    78.244    30.427
    78.783    29.983
>
    78.244    30.427
    78.783    29.983
>
    79.563    30.001
    78.783    29.983
>
    79.563    30.001
    78.783    29.983
>
    79.595    29.852
    78.783    29.983
>
    79.595    29.852
    78.783    29.983
>
    79.673    29.887
    78.783    29.983
>
    79.673    29.887
    78.783    29.983
>
    79.416    30.250
    79.599    30.227
>
    79.416    30.250
    79.599    30.227
>
    79.376    30.145
    79.599    30.227
>
    79.376    30.145
    79.599    30.227
>
    79.563    30.001
    79.599    30.227
>
    79.563    30.001
    79.599    30.227
>
    79.288    30.051
    79.599    30.227
>
    79.288    30.051
    79.599    30.227
>
    79.566    30.538
    79.599    30.227
>
    79.566    30.538
    79.599    30.227
>
    79.673    29.887
    79.599    30.227
>
    79.673    29.887
    79.599    30.227
>
    79.217    30.265
    79.599    30.227
>
    79.217    30.265
    79.599    30.227
>
    79.595    29.852
    79.599    30.227
>
    79.595    29.852
    79.599    30.227
>
    79.176    30.488
    79.599    30.227
>
    79.176    30.488
    79.599    30.227
>
    79.416    29.770
    79.599    30.227
>
    79.416    29.770
    79.599    30.227
>
    80.238    30.066
    79.599    30.227
>
    80.164    29.905
    79.599    30.227
>
    79.648    29.592
    79.599    30.227
>
    79.648    29.592
    79.599    30.227
>
    79.015    29.750
    79.599    30.227
>
    79.015    29.750
    79.599    30.227
>
    80.248    29.803
    79.599    30.227
>
    80.248    29.803
    79.599    30.227
>
    79.176    30.488
    79.147    30.523
>
    79.019    30.389
    79.147    30.523
>
    79.019    30.389
    79.147    30.523
>
    79.322    30.406
    79.147    30.523
>
    79.322    30.406
    79.147    30.523
>
    79.217    30.265
    79.147    30.523
>
    79.217    30.265
    79.147    30.523
>
    79.416    30.250
    79.147    30.523
>
    79.416    30.250
    79.147    30.523
>
    79.566    30.538
    79.147    30.523
>
    79.566    30.538
    79.147    30.523
>
    79.376    30.145
    79.147    30.523
>
    79.376    30.145
    79.147    30.523
>
    78.640    30.431
    79.147    30.523
>
    78.640    30.431
    79.147    30.523
>
    79.288    30.051
    79.147    30.523
>
    79.288    30.051
    79.147    30.523
>
    78.605    30.144
    79.147    30.523
>
    78.605    30.144
    79.147    30.523
>
    79.563    30.001
    79.147    30.523
>
    78.436    30.721
    79.147    30.523
>
    78.436    30.721
    79.147    30.523
>
    79.595    29.852
    79.147    30.523
>
    79.595    29.852
    79.147    30.523
>
    79.015    29.750
    79.147    30.523
>
    79.015    29.750
    79.147    30.523
>
    79.673    29.887
    79.147    30.523
>
    79.673    29.887
    79.147    30.523
>
    79.416    29.770
    79.147    30.523
>
    78.680    29.839
    79.147    30.523
>
    78.680    29.839
    79.147    30.523
>
    78.244    30.427
    79.147    30.523
>
    78.244    30.427
    79.147    30.523
>
    79.176    30.488
    79.099    30.524
>
    79.322    30.406
    79.099    30.524
>
    79.322    30.406
    79.099    30.524
>
    79.217    30.265
    79.099    30.524
>
    79.217    30.265
    79.099    30.524
>
    79.416    30.250
    79.099    30.524
>
    79.416    30.250
    79.099    30.524
>
    78.649    30.579
    79.099    30.524
>
    78.649    30.579
    79.099    30.524
>
    78.640    30.431
    79.099    30.524
>
    78.640    30.431
    79.099    30.524
>
    79.288    30.051
    79.099    30.524
>
    79.288    30.051
    79.099    30.524
>
    78.605    30.144
    79.099    30.524
>
    78.605    30.144
    79.099    30.524
>
    78.436    30.721
    79.099    30.524
>
    78.436    30.721
    79.099    30.524
>
    79.563    30.001
    79.099    30.524
>
    79.563    30.001
    79.099    30.524
>
    78.330    30.574
    79.099    30.524
>
    78.330    30.574
    79.099    30.524
>
    78.244    30.427
    79.099    30.524
>
    78.244    30.427
    79.099    30.524
>
    78.680    29.839
    79.099    30.524
>
    78.680    29.839
    79.099    30.524
>
    79.015    29.750
    79.099    30.524
>
    79.015    29.750
    79.099    30.524
>
    78.287    30.161
    79.099    30.524
>
    78.287    30.161
    79.099    30.524
>
    79.595    29.852
    79.099    30.524
>
    79.595    29.852
    79.099    30.524
>
    79.416    30.250
    79.475    30.234
>
    79.416    30.250
    79.475    30.234
>
    79.376    30.145
    79.475    30.234
>
    79.376    30.145
    79.475    30.234
>
    79.322    30.406
    79.475    30.234
>
    79.322    30.406
    79.475    30.234
>
    79.217    30.265
    79.475    30.234
>
    79.217    30.265
    79.475    30.234
>
    79.288    30.051
    79.475    30.234
>
    79.288    30.051
    79.475    30.234
>
    79.563    30.001
    79.475    30.234
>
    79.563    30.001
    79.475    30.234
>
    79.566    30.538
    79.475    30.234
>
    79.566    30.538
    79.475    30.234
>
    79.176    30.488
    79.475    30.234
>
    79.176    30.488
    79.475    30.234
>
    79.673    29.887
    79.475    30.234
>
    79.673    29.887
    79.475    30.234
>
    79.595    29.852
    79.475    30.234
>
    79.595    29.852
    79.475    30.234
>
    79.416    29.770
    79.475    30.234
>
    79.416    29.770
    79.475    30.234
>
    79.015    29.750
    79.475    30.234
>
    79.015    29.750
    79.475    30.234
>
    79.648    29.592
    79.475    30.234
>
    79.648    29.592
    79.475    30.234
>
    80.049    29.775
    79.475    30.234
>
    80.049    29.775
    79.475    30.234
>
    80.164    29.905
    79.475    30.234
>
    80.164    29.905
    79.475    30.234
>
    78.640    30.431
    79.475    30.234
>
    78.640    30.431
    79.475    30.234
>
    78.680    29.839
    79.475    30.234
>
    78.680    29.839
    79.475    30.234
>
    80.248    29.803
    79.475    30.234
>
    80.248    29.803
    79.475    30.234
>
    78.918    29.916
    78.844    29.819
>
    78.918    29.916
    78.844    29.819
>
    78.680    29.839
    78.844    29.819
>
    78.680    29.839
    78.844    29.819
>
    78.711    29.924
    78.844    29.819
>
    78.711    29.924
    78.844    29.819
>
    79.015    29.750
    78.844    29.819
>
    79.015    29.750
    78.844    29.819
>
    79.049    30.019
    78.844    29.819
>
    78.768    30.155
    78.844    29.819
>
    78.768    30.155
    78.844    29.819
>
    78.605    30.144
    78.844    29.819
>
    78.605    30.144
    78.844    29.819
>
    79.288    30.051
    78.844    29.819
>
    79.288    30.051
    78.844    29.819
>
    79.416    29.770
    78.844    29.819
>
    79.416    29.770
    78.844    29.819
>
    79.217    30.265
    78.844    29.819
>
    79.217    30.265
    78.844    29.819
>
    79.376    30.145
    78.844    29.819
>
    78.287    30.161
    78.844    29.819
>
    78.287    30.161
    78.844    29.819
>
    78.640    30.431
    78.844    29.819
>
    79.563    30.001
    78.844    29.819
>
    79.563    30.001
    78.844    29.819
>
    79.595    29.852
    78.844    29.819
>
    79.595    29.852
    78.844    29.819
>
    78.429    30.373
    78.844    29.819
>
    79.416    30.250
    78.844    29.819
>
    79.416    30.250
    78.844    29.819
>
    79.457    29.359
    78.844    29.819
>
    79.457    29.359
    78.844    29.819
>
    79.322    30.406
    78.844    29.819
>
    79.322    30.406
    78.844    29.819
>
    79.176    30.488
    78.844    29.819
>
    79.176    30.488
    78.844    29.819
>
    79.673    29.887
    78.844    29.819
>
    79.673    29.887
    78.844    29.819
>
    79.648    29.592
    78.844    29.819
>
    79.648    29.592
    78.844    29.819
>
    78.649    30.579
    78.844    29.819
>
    78.244    30.427
    78.844    29.819
>
    77.873    30.691
    77.972    30.928
>
    77.873    30.691
    77.972    30.928
>
    78.377    30.921
    77.972    30.928
>
    78.377    30.921
    77.972    30.928
>
    78.436    30.721
    77.972    30.928
>
    78.436    30.721
    77.972    30.928
>
    77.843    30.518
    77.972    30.928
>
    77.843    30.518
    77.972    30.928
>
    78.330    30.574
    77.972    30.928
>
    78.330    30.574
    77.972    30.928
>
    78.074    30.455
    77.972    30.928
>
    78.074    30.455
    77.972    30.928
>
    78.649    30.579
    77.972    30.928
>
    78.429    30.373
    77.972    30.928
>
    78.429    30.373
    77.972    30.928
>
    78.753    31.036
    77.972    30.928
>
    78.640    30.431
    77.972    30.928
>
    78.640    30.431
    77.972    30.928
>
    78.205    30.808
    77.972    30.928
>
    78.205    30.808
    77.972    30.928
>
    77.873    30.691
    77.972    30.928
>
    78.377    30.921
    77.972    30.928
>
    78.330    30.574
    77.972    30.928
>
    78.074    30.455
    77.972    30.928
>
    78.649    30.579
    77.972    30.928
>
    78.429    30.373
    77.972    30.928
>
    78.753    31.036
    77.972    30.928
>
    78.446    30.730
    77.972    30.928
>
    78.446    30.730
    77.972    30.928
>
    79.322    30.406
    79.204    30.514
>
    79.217    30.265
    79.204    30.514
>
    79.217    30.265
    79.204    30.514
>
    78.975    30.639
    79.204    30.514
>
    78.975    30.639
    79.204    30.514
>
    79.566    30.538
    79.204    30.514
>
    79.416    30.250
    79.204    30.514
>
    79.416    30.250
    79.204    30.514
>
    79.376    30.145
    79.204    30.514
>
    79.376    30.145
    79.204    30.514
>
    79.288    30.051
    79.204    30.514
>
    78.649    30.579
    79.204    30.514
>
    78.649    30.579
    79.204    30.514
>
    78.640    30.431
    79.204    30.514
>
    78.640    30.431
    79.204    30.514
>
    79.049    30.019
    79.204    30.514
>
    78.768    30.155
    79.204    30.514
>
    78.768    30.155
    79.204    30.514
>
    79.563    30.001
    79.204    30.514
>
    79.563    30.001
    79.204    30.514
>
    78.605    30.144
    79.204    30.514
>
    78.605    30.144
    79.204    30.514
>
    78.918    29.916
    79.204    30.514
>
    78.918    29.916
    79.204    30.514
>
    78.753    31.036
    79.204    30.514
>
    78.429    30.373
    79.204    30.514
>
    78.429    30.373
    79.204    30.514
>
    78.436    30.721
    79.204    30.514
>
    79.595    29.852
    79.204    30.514
>
    79.595    29.852
    79.204    30.514
>
    79.673    29.887
    79.204    30.514
>
    79.673    29.887
    79.204    30.514
>
    79.416    29.770
    79.204    30.514
>
    78.330    30.574
    79.204    30.514
>
    79.015    29.750
    79.204    30.514
>
    80.164    29.905
    79.947    30.066
>
    80.164    29.905
    79.947    30.066
>
    80.238    30.066
    79.947    30.066
>
    80.238    30.066
    79.947    30.066
>
    79.673    29.887
    79.947    30.066
>
    79.673    29.887
    79.947    30.066
>
    79.563    30.001
    79.947    30.066
>
    79.563    30.001
    79.947    30.066
>
    79.595    29.852
    79.947    30.066
>
    79.595    29.852
    79.947    30.066
>
    80.248    29.803
    79.947    30.066
>
    80.248    29.803
    79.947    30.066
>
    79.416    30.250
    79.947    30.066
>
    79.416    30.250
    79.947    30.066
>
    79.376    30.145
    79.947    30.066
>
    79.376    30.145
    79.947    30.066
>
    79.648    29.592
    79.947    30.066
>
    79.648    29.592
    79.947    30.066
>
    79.416    29.770
    79.947    30.066
>
    79.416    29.770
    79.947    30.066
>
    79.288    30.051
    79.947    30.066
>
    79.288    30.051
    79.947    30.066
>
    79.566    30.538
    79.947    30.066
>
    79.566    30.538
    79.947    30.066
>
    80.234    29.552
    79.947    30.066
>
    80.234    29.552
    79.947    30.066
>
    79.217    30.265
    79.947    30.066
>
    79.217    30.265
    79.947    30.066
>
    79.930    29.407
    79.947    30.066
>
    79.930    29.407
    79.947    30.066
>
    80.094    29.403
    79.947    30.066
>
    80.094    29.403
    79.947    30.066
>
    80.107    29.330
    79.947    30.066
>
    80.107    29.330
    79.947    30.066
>
    79.049    30.019
    79.947    30.066
>
    79.049    30.019
    79.947    30.066
>
    80.217    29.550
    79.947    30.066
>
    80.217    29.550
    79.947    30.066
>
    80.246    29.450
    79.947    30.066
>
    80.246    29.450
    79.947    30.066
>
    77.873    30.691
    77.924    30.724
>
    77.873    30.691
    77.924    30.724
>
    77.843    30.518
    77.924    30.724
>
    77.843    30.518
    77.924    30.724
>
    78.103    30.909
    77.924    30.724
>
    78.205    30.808
    77.924    30.724
>
    78.205    30.808
    77.924    30.724
>
    77.845    30.934
    77.924    30.724
>
    77.845    30.934
    77.924    30.724
>
    78.074    30.455
    77.924    30.724
>
    78.074    30.455
    77.924    30.724
>
    78.244    30.427
    77.924    30.724
>
    78.244    30.427
    77.924    30.724
>
    78.436    30.721
    77.924    30.724
>
    78.436    30.721
    77.924    30.724
>
    78.377    30.921
    77.924    30.724
>
    78.377    30.921
    77.924    30.724
>
    78.429    30.373
    77.924    30.724
>
    78.429    30.373
    77.924    30.724
>
    78.649    30.579
    77.924    30.724
>
    78.649    30.579
    77.924    30.724
>
    78.640    30.431
    77.924    30.724
>
    78.640    30.431
    77.924    30.724
>
    79.673    29.887
    79.887    30.106
>
    79.673    29.887
    79.887    30.106
>
    79.563    30.001
    79.887    30.106
>
    79.563    30.001
    79.887    30.106
>
    80.238    30.066
    79.887    30.106
>
    80.238    30.066
    79.887    30.106
>
    79.595    29.852
    79.887    30.106
>
    79.595    29.852
    79.887    30.106
>
    80.049    29.775
    79.887    30.106
>
    80.049    29.775
    79.887    30.106
>
    80.248    29.803
    79.887    30.106
>
    80.248    29.803
    79.887    30.106
>
    80.040    29.660
    79.887    30.106
>
    80.040    29.660
    79.887    30.106
>
    79.566    30.538
    79.887    30.106
>
    79.566    30.538
    79.887    30.106
>
    79.288    30.051
    79.887    30.106
>
    79.288    30.051
    79.887    30.106
>
    79.416    29.770
    79.887    30.106
>
    79.416    29.770
    79.887    30.106
>
    79.648    29.592
    79.887    30.106
>
    80.094    29.403
    79.887    30.106
>
    80.094    29.403
    79.887    30.106
>
    80.107    29.330
    79.887    30.106
>
    80.107    29.330
    79.887    30.106
>
    79.015    29.750
    78.949    29.887
>
    79.015    29.750
    78.949    29.887
>
    78.680    29.839
    78.949    29.887
>
    78.680    29.839
    78.949    29.887
>
    78.605    30.144
    78.949    29.887
>
    78.605    30.144
    78.949    29.887
>
    79.416    29.770
    78.949    29.887
>
    79.019    30.389
    78.949    29.887
>
    79.563    30.001
    78.949    29.887
>
    79.563    30.001
    78.949    29.887
>
    79.595    29.852
    78.949    29.887
>
    79.595    29.852
    78.949    29.887
>
    78.640    30.431
    78.949    29.887
>
    79.673    29.887
    78.949    29.887
>
    79.673    29.887
    78.949    29.887
>
    78.649    30.579
    78.949    29.887
>
    78.378    30.508
    78.949    29.887
>
    78.378    30.508
    78.949    29.887
>
    79.141    30.588
    79.192    30.484
>
    79.141    30.588
    79.192    30.484
>
    79.322    30.406
    79.192    30.484
>
    79.019    30.389
    79.192    30.484
>
    79.019    30.389
    79.192    30.484
>
    78.975    30.639
    79.192    30.484
>
    78.975    30.639
    79.192    30.484
>
    79.566    30.538
    79.192    30.484
>
    79.566    30.538
    79.192    30.484
>
    79.376    30.145
    79.192    30.484
>
    79.049    30.019
    79.192    30.484
>
    79.049    30.019
    79.192    30.484
>
    78.640    30.431
    79.192    30.484
>
    78.640    30.431
    79.192    30.484
>
    78.649    30.579
    79.192    30.484
>
    78.768    30.155
    79.192    30.484
>
    78.768    30.155
    79.192    30.484
>
    79.563    30.001
    79.192    30.484
>
    79.563    30.001
    79.192    30.484
>
    78.918    29.916
    79.192    30.484
>
    78.918    29.916
    79.192    30.484
>
    78.605    30.144
    79.192    30.484
>
    78.605    30.144
    79.192    30.484
>
    79.210    29.820
    79.192    30.484
>
    79.210    29.820
    79.192    30.484
>
    78.429    30.373
    79.192    30.484
>
    78.429    30.373
    79.192    30.484
>
    78.436    30.721
    79.192    30.484
>
    78.378    30.508
    79.192    30.484
>
    78.378    30.508
    79.192    30.484
>
    79.595    29.852
    79.192    30.484
>
    79.673    29.887
    79.192    30.484
>
    79.416    29.770
    79.192    30.484
>
    79.015    29.750
    79.192    30.484
>
    78.330    30.574
    79.192    30.484
>
    78.330    30.574
    79.192    30.484
>
    78.680    29.839
    79.192    30.484
>
    78.680    29.839
    79.192    30.484
>
    79.558    30.556
    79.192    30.484
>
    78.446    30.730
    79.192    30.484
>
    78.446    30.730
    79.192    30.484
>
    79.930    29.407
    79.801    30.007
>
    79.930    29.407
    79.801    30.007
>
    79.673    29.887
    79.801    30.007
>
    79.673    29.887
    79.801    30.007
>
    79.563    30.001
    79.801    30.007
>
    79.563    30.001
    79.801    30.007
>
    79.595    29.852
    79.801    30.007
>
    79.595    29.852
    79.801    30.007
>
    80.049    29.775
    79.801    30.007
>
    80.049    29.775
    79.801    30.007
>
    80.164    29.905
    79.801    30.007
>
    80.164    29.905
    79.801    30.007
>
    80.238    30.066
    79.801    30.007
>
    80.238    30.066
    79.801    30.007
>
    79.376    30.145
    79.801    30.007
>
    79.376    30.145
    79.801    30.007
>
    80.040    29.660
    79.801    30.007
>
    80.040    29.660
    79.801    30.007
>
    79.648    29.592
    79.801    30.007
>
    79.648    29.592
    79.801    30.007
>
    80.248    29.803
    79.801    30.007
>
    79.288    30.051
    79.801    30.007
>
    79.288    30.051
    79.801    30.007
>
    79.210    29.820
    79.801    30.007
>
    79.566    30.538
    79.801    30.007
>
    79.566    30.538
    79.801    30.007
>
    79.322    30.406
    79.801    30.007
>
    80.234    29.552
    79.801    30.007
>
    80.234    29.552
    79.801    30.007
>
    79.049    30.019
    79.801    30.007
>
    79.049    30.019
    79.801    30.007
>
    80.094    29.403
    79.801    30.007
>
    80.094    29.403
    79.801    30.007
>
    80.544    29.849
    79.801    30.007
>
    80.544    29.849
    79.801    30.007
>
    80.107    29.330
    79.801    30.007
>
    80.107    29.330
    79.801    30.007
>
    79.176    30.488
    79.801    30.007
>
    79.176    30.488
    79.801    30.007
>
    79.015    29.750
    79.801    30.007
>
    79.015    29.750
    79.801    30.007
>
    78.918    29.916
    79.801    30.007
>
    78.918    29.916
    79.801    30.007
>
    79.019    30.389
    79.801    30.007
>
    80.217    29.550
    79.801    30.007
>
    80.217    29.550
    79.801    30.007
>
    80.246    29.450
    79.801    30.007
>
    80.246    29.450
    79.801    30.007
>
    79.376    30.145
    79.591    30.245
>
    79.376    30.145
    79.591    30.245
>
    79.563    30.001
    79.591    30.245
>
    79.563    30.001
    79.591    30.245
>
    79.566    30.538
    79.591    30.245
>
    79.566    30.538
    79.591    30.245
>
    79.288    30.051
    79.591    30.245
>
    79.288    30.051
    79.591    30.245
>
    79.673    29.887
    79.591    30.245
>
    79.673    29.887
    79.591    30.245
>
    79.595    29.852
    79.591    30.245
>
    79.595    29.852
    79.591    30.245
>
    79.176    30.488
    79.591    30.245
>
    79.176    30.488
    79.591    30.245
>
    79.049    30.019
    79.591    30.245
>
    79.019    30.389
    79.591    30.245
>
    80.238    30.066
    79.591    30.245
>
    80.164    29.905
    79.591    30.245
>
    80.164    29.905
    79.591    30.245
>
    78.918    29.916
    79.591    30.245
>
    78.975    30.639
    79.591    30.245
>
    79.015    29.750
    79.591    30.245
>
    79.015    29.750
    79.591    30.245
>
    78.768    30.155
    79.591    30.245
>
    78.768    30.155
    79.591    30.245
>
    79.900    29.946
    79.855    30.147
>
    79.563    30.001
    79.855    30.147
>
    79.673    29.887
    79.855    30.147
>
    80.238    30.066
    79.855    30.147
>
    80.238    30.066
    79.855    30.147
>
    79.595    29.852
    79.855    30.147
>
    79.595    29.852
    79.855    30.147
>
    80.164    29.905
    79.855    30.147
>
    80.164    29.905
    79.855    30.147
>
    79.376    30.145
    79.855    30.147
>
    79.376    30.145
    79.855    30.147
>
    80.049    29.775
    79.855    30.147
>
    80.049    29.775
    79.855    30.147
>
    79.566    30.538
    79.855    30.147
>
    79.566    30.538
    79.855    30.147
>
    80.248    29.803
    79.855    30.147
>
    80.248    29.803
    79.855    30.147
>
    79.288    30.051
    79.855    30.147
>
    79.288    30.051
    79.855    30.147
>
    80.040    29.660
    79.855    30.147
>
    80.040    29.660
    79.855    30.147
>
    79.322    30.406
    79.855    30.147
>
    79.322    30.406
    79.855    30.147
>
    79.648    29.592
    79.855    30.147
>
    79.648    29.592
    79.855    30.147
>
    79.210    29.820
    79.855    30.147
>
    79.210    29.820
    79.855    30.147
>
    79.176    30.488
    79.855    30.147
>
    79.176    30.488
    79.855    30.147
>
    80.544    29.849
    79.855    30.147
>
    80.544    29.849
    79.855    30.147
>
    80.234    29.552
    79.855    30.147
>
    80.234    29.552
    79.855    30.147
>
    79.049    30.019
    79.855    30.147
>
    79.049    30.019
    79.855    30.147
>
    79.141    30.588
    79.855    30.147
>
    79.141    30.588
    79.855    30.147
>
    79.019    30.389
    79.855    30.147
>
    79.019    30.389
    79.855    30.147
>
    80.094    29.403
    79.855    30.147
>
    79.322    30.406
    79.345    30.552
>
    79.322    30.406
    79.345    30.552
>
    79.176    30.488
    79.345    30.552
>
    79.176    30.488
    79.345    30.552
>
    79.141    30.588
    79.345    30.552
>
    79.141    30.588
    79.345    30.552
>
    79.566    30.538
    79.345    30.552
>
    79.566    30.538
    79.345    30.552
>
    79.019    30.389
    79.345    30.552
>
    79.019    30.389
    79.345    30.552
>
    78.975    30.639
    79.345    30.552
>
    78.975    30.639
    79.345    30.552
>
    79.376    30.145
    79.345    30.552
>
    79.376    30.145
    79.345    30.552
>
    79.288    30.051
    79.345    30.552
>
    79.563    30.001
    79.345    30.552
>
    79.563    30.001
    79.345    30.552
>
    79.049    30.019
    79.345    30.552
>
    79.049    30.019
    79.345    30.552
>
    78.649    30.579
    79.345    30.552
>
    78.649    30.579
    79.345    30.552
>
    78.640    30.431
    79.345    30.552
>
    78.640    30.431
    79.345    30.552
>
    78.768    30.155
    79.345    30.552
>
    78.768    30.155
    79.345    30.552
>
    79.673    29.887
    79.345    30.552
>
    79.673    29.887
    79.345    30.552
>
    79.595    29.852
    79.345    30.552
>
    79.595    29.852
    79.345    30.552
>
    78.918    29.916
    79.345    30.552
>
    78.918    29.916
    79.345    30.552
>
    78.753    31.036
    79.345    30.552
>
    79.210    29.820
    79.345    30.552
>
    79.210    29.820
    79.345    30.552
>
    78.605    30.144
    79.345    30.552
>
    78.605    30.144
    79.345    30.552
>
    79.900    29.946
    79.345    30.552
>
    79.900    29.946
    79.345    30.552
>
    79.416    29.770
    79.345    30.552
>
    79.416    29.770
    79.345    30.552
>
    79.376    30.145
    79.554    30.246
>
    79.376    30.145
    79.554    30.246
>
    79.563    30.001
    79.554    30.246
>
    79.563    30.001
    79.554    30.246
>
    79.322    30.406
    79.554    30.246
>
    79.288    30.051
    79.554    30.246
>
    79.288    30.051
    79.554    30.246
>
    79.566    30.538
    79.554    30.246
>
    79.673    29.887
    79.554    30.246
>
    79.673    29.887
    79.554    30.246
>
    79.595    29.852
    79.554    30.246
>
    79.595    29.852
    79.554    30.246
>
    79.176    30.488
    79.554    30.246
>
    79.176    30.488
    79.554    30.246
>
    79.900    29.946
    79.554    30.246
>
    79.900    29.946
    79.554    30.246
>
    79.019    30.389
    79.554    30.246
>
    79.019    30.389
    79.554    30.246
>
    79.049    30.019
    79.554    30.246
>
    79.210    29.820
    79.554    30.246
>
    79.210    29.820
    79.554    30.246
>
    78.918    29.916
    79.554    30.246
>
    78.918    29.916
    79.554    30.246
>
    78.975    30.639
    79.554    30.246
>
    78.768    30.155
    79.554    30.246
>
    80.040    29.660
    79.554    30.246
>
    79.322    30.406
    79.356    30.501
>
    79.322    30.406
    79.356    30.501
>
    79.176    30.488
    79.356    30.501
>
    79.176    30.488
    79.356    30.501
>
    79.566    30.538
    79.356    30.501
>
    79.566    30.538
    79.356    30.501
>
    79.141    30.588
    79.356    30.501
>
    79.141    30.588
    79.356    30.501
>
    79.019    30.389
    79.356    30.501
>
    79.019    30.389
    79.356    30.501
>
    79.376    30.145
    79.356    30.501
>
    79.376    30.145
    79.356    30.501
>
    78.975    30.639
    79.356    30.501
>
    78.975    30.639
    79.356    30.501
>
    79.563    30.001
    79.356    30.501
>
    79.563    30.001
    79.356    30.501
>
    79.049    30.019
    79.356    30.501
>
    79.049    30.019
    79.356    30.501
>
    78.768    30.155
    79.356    30.501
>
    78.768    30.155
    79.356    30.501
>
    78.649    30.579
    79.356    30.501
>
    78.640    30.431
    79.356    30.501
>
    78.640    30.431
    79.356    30.501
>
    79.673    29.887
    79.356    30.501
>
    79.673    29.887
    79.356    30.501
>
    79.595    29.852
    79.356    30.501
>
    79.595    29.852
    79.356    30.501
>
    79.210    29.820
    79.356    30.501
>
    79.210    29.820
    79.356    30.501
>
    78.918    29.916
    79.356    30.501
>
    78.605    30.144
    79.356    30.501
>
    78.605    30.144
    79.356    30.501
>
    79.376    30.145
    79.538    30.252
>
    79.376    30.145
    79.538    30.252
>
    79.322    30.406
    79.538    30.252
>
    79.322    30.406
    79.538    30.252
>
    79.563    30.001
    79.538    30.252
>
    79.563    30.001
    79.538    30.252
>
    79.288    30.051
    79.538    30.252
>
    79.288    30.051
    79.538    30.252
>
    79.566    30.538
    79.538    30.252
>
    79.566    30.538
    79.538    30.252
>
    79.673    29.887
    79.538    30.252
>
    79.673    29.887
    79.538    30.252
>
    79.176    30.488
    79.538    30.252
>
    79.176    30.488
    79.538    30.252
>
    79.595    29.852
    79.538    30.252
>
    79.595    29.852
    79.538    30.252
>
    79.900    29.946
    79.538    30.252
>
    79.900    29.946
    79.538    30.252
>
    79.049    30.019
    79.538    30.252
>
    79.049    30.019
    79.538    30.252
>
    79.141    30.588
    79.538    30.252
>
    79.141    30.588
    79.538    30.252
>
    79.210    29.820
    79.538    30.252
>
    78.975    30.639
    79.538    30.252
>
    78.918    29.916
    79.538    30.252
>
    78.918    29.916
    79.538    30.252
>
    80.238    30.066
    79.538    30.252
>
    80.164    29.905
    79.538    30.252
>
    80.164    29.905
    79.538    30.252
>
    80.049    29.775
    79.538    30.252
>
    79.015    29.750
    79.538    30.252
>
    79.015    29.750
    79.538    30.252
>
    78.768    30.155
    79.538    30.252
>
    78.768    30.155
    79.538    30.252
>
    80.040    29.660
    79.538    30.252
>
    80.040    29.660
    79.538    30.252
>
    78.711    29.924
    79.538    30.252
>
    78.640    30.431
    79.538    30.252
>
    78.640    30.431
    79.538    30.252
>
    80.544    29.849
    80.456    29.828
>
    80.544    29.849
    80.456    29.828
>
    80.248    29.803
    80.456    29.828
>
    80.248    29.803
    80.456    29.828
>
    80.164    29.905
    80.456    29.828
>
    80.164    29.905
    80.456    29.828
>
    80.238    30.066
    80.456    29.828
>
    80.238    30.066
    80.456    29.828
>
    80.234    29.552
    80.456    29.828
>
    80.234    29.552
    80.456    29.828
>
    80.049    29.775
    80.456    29.828
>
    80.040    29.660
    80.456    29.828
>
    80.040    29.660
    80.456    29.828
>
    79.900    29.946
    80.456    29.828
>
    80.094    29.403
    80.456    29.828
>
    80.094    29.403
    80.456    29.828
>
    80.107    29.330
    80.456    29.828
>
    80.107    29.330
    80.456    29.828
>
    79.673    29.887
    80.456    29.828
>
    79.673    29.887
    80.456    29.828
>
    79.648    29.592
    80.456    29.828
>
    79.648    29.592
    80.456    29.828
>
    79.595    29.852
    80.456    29.828
>
    79.595    29.852
    80.456    29.828
>
    79.563    30.001
    80.456    29.828
>
    79.563    30.001
    80.456    29.828
>
    77.873    30.691
    77.937    30.632
>
    77.873    30.691
    77.937    30.632
>
    77.843    30.518
    77.937    30.632
>
    77.843    30.518
    77.937    30.632
>
    78.074    30.455
    77.937    30.632
>
    78.074    30.455
    77.937    30.632
>
    78.205    30.808
    77.937    30.632
>
    78.205    30.808
    77.937    30.632
>
    78.244    30.427
    77.937    30.632
>
    78.244    30.427
    77.937    30.632
>
    78.330    30.574
    77.937    30.632
>
    78.330    30.574
    77.937    30.632
>
    78.103    30.909
    77.937    30.632
>
    78.103    30.909
    77.937    30.632
>
    77.845    30.934
    77.937    30.632
>
    77.845    30.934
    77.937    30.632
>
    78.378    30.508
    77.937    30.632
>
    78.378    30.508
    77.937    30.632
>
    78.436    30.721
    77.937    30.632
>
    78.436    30.721
    77.937    30.632
>
    78.377    30.921
    77.937    30.632
>
    78.377    30.921
    77.937    30.632
>
    78.429    30.373
    77.937    30.632
>
    78.287    30.161
    77.937    30.632
>
    78.287    30.161
    77.937    30.632
>
    78.649    30.579
    77.937    30.632
>
    78.649    30.579
    77.937    30.632
>
    78.640    30.431
    77.937    30.632
>
    78.640    30.431
    77.937    30.632
>
    78.605    30.144
    77.937    30.632
>
    78.605    30.144
    77.937    30.632
>
    78.378    30.508
    78.445    30.488
>
    78.378    30.508
    78.445    30.488
>
    78.429    30.373
    78.445    30.488
>
    78.429    30.373
    78.445    30.488
>
    78.330    30.574
    78.445    30.488
>
    78.640    30.431
    78.445    30.488
>
    78.640    30.431
    78.445    30.488
>
    78.649    30.579
    78.445    30.488
>
    78.649    30.579
    78.445    30.488
>
    78.244    30.427
    78.445    30.488
>
    78.244    30.427
    78.445    30.488
>
    78.436    30.721
    78.445    30.488
>
    78.436    30.721
    78.445    30.488
>
    78.074    30.455
    78.445    30.488
>
    78.074    30.455
    78.445    30.488
>
    78.287    30.161
    78.445    30.488
>
    78.287    30.161
    78.445    30.488
>
    78.605    30.144
    78.445    30.488
>
    78.605    30.144
    78.445    30.488
>
    78.205    30.808
    78.445    30.488
>
    78.205    30.808
    78.445    30.488
>
    78.768    30.155
    78.445    30.488
>
    78.768    30.155
    78.445    30.488
>
    78.377    30.921
    78.445    30.488
>
    78.377    30.921
    78.445    30.488
>
    78.975    30.639
    78.445    30.488
>
    78.975    30.639
    78.445    30.488
>
    79.019    30.389
    78.445    30.488
>
    79.019    30.389
    78.445    30.488
>
    78.103    30.909
    78.445    30.488
>
    78.103    30.909
    78.445    30.488
>
    77.873    30.691
    78.445    30.488
>
    77.873    30.691
    78.445    30.488
>
    78.711    29.924
    78.445    30.488
>
    79.141    30.588
    78.445    30.488
>
    79.141    30.588
    78.445    30.488
>
    79.176    30.488
    78.445    30.488
>
    79.176    30.488
    78.445    30.488
>
    78.680    29.839
    78.445    30.488
>
    78.680    29.839
    78.445    30.488
>
    79.049    30.019
    78.445    30.488
>
    79.049    30.019
    78.445    30.488
>
    78.918    29.916
    78.445    30.488
>
    78.918    29.916
    78.445    30.488
>
    77.845    30.934
    78.445    30.488
>
    77.845    30.934
    78.445    30.488
>
    79.322    30.406
    78.445    30.488
>
    78.103    30.909
    78.125    30.983
>
    78.103    30.909
    78.125    30.983
>
    78.205    30.808
    78.125    30.983
>
    78.205    30.808
    78.125    30.983
>
    78.377    30.921
    78.125    30.983
>
    78.377    30.921
    78.125    30.983
>
    77.845    30.934
    78.125    30.983
>
    77.845    30.934
    78.125    30.983
>
    78.436    30.721
    78.125    30.983
>
    78.436    30.721
    78.125    30.983
>
    77.873    30.691
    78.125    30.983
>
    77.873    30.691
    78.125    30.983
>
    78.330    30.574
    78.125    30.983
>
    78.330    30.574
    78.125    30.983
>
    78.378    30.508
    78.125    30.983
>
    78.378    30.508
    78.125    30.983
>
    78.074    30.455
    78.125    30.983
>
    78.074    30.455
    78.125    30.983
>
    78.753    31.036
    78.125    30.983
>
    78.244    30.427
    78.125    30.983
>
    78.244    30.427
    78.125    30.983
>
    78.649    30.579
    78.125    30.983
>
    78.649    30.579
    78.125    30.983
>
    78.429    30.373
    78.125    30.983
>
    78.640    30.431
    78.125    30.983
>
    78.640    30.431
    78.125    30.983
>
    79.930    29.407
    80.411    29.878
>
    79.930    29.407
    80.411    29.878
>
    80.544    29.849
    80.411    29.878
>
    80.544    29.849
    80.411    29.878
>
    80.248    29.803
    80.411    29.878
>
    80.248    29.803
    80.411    29.878
>
    80.164    29.905
    80.411    29.878
>
    80.164    29.905
    80.411    29.878
>
    80.238    30.066
    80.411    29.878
>
    80.238    30.066
    80.411    29.878
>
    80.049    29.775
    80.411    29.878
>
    80.049    29.775
    80.411    29.878
>
    80.234    29.552
    80.411    29.878
>
    80.234    29.552
    80.411    29.878
>
    80.040    29.660
    80.411    29.878
>
    80.040    29.660
    80.411    29.878
>
    79.900    29.946
    80.411    29.878
>
    79.900    29.946
    80.411    29.878
>
    80.094    29.403
    80.411    29.878
>
    80.094    29.403
    80.411    29.878
>
    80.107    29.330
    80.411    29.878
>
    80.107    29.330
    80.411    29.878
>
    79.595    29.852
    80.411    29.878
>
    79.595    29.852
    80.411    29.878
>
    79.648    29.592
    80.411    29.878
>
    79.648    29.592
    80.411    29.878
>
    79.563    30.001
    80.411    29.878
>
    79.563    30.001
    80.411    29.878
>
    80.544    29.849
    80.424    29.885
>
    80.544    29.849
    80.424    29.885
>
    80.248    29.803
    80.424    29.885
>
    80.248    29.803
    80.424    29.885
>
    80.164    29.905
    80.424    29.885
>
    80.164    29.905
    80.424    29.885
>
    80.238    30.066
    80.424    29.885
>
    80.238    30.066
    80.424    29.885
>
    80.234    29.552
    80.424    29.885
>
    80.234    29.552
    80.424    29.885
>
    80.040    29.660
    80.424    29.885
>
    80.040    29.660
    80.424    29.885
>
    80.094    29.403
    80.424    29.885
>
    80.094    29.403
    80.424    29.885
>
    80.107    29.330
    80.424    29.885
>
    80.107    29.330
    80.424    29.885
>
    79.930    29.407
    80.424    29.885
>
    79.930    29.407
    80.424    29.885
>
    79.673    29.887
    80.424    29.885
>
    79.673    29.887
    80.424    29.885
>
    79.595    29.852
    80.424    29.885
>
    79.566    30.538
    79.165    30.497
>
    79.566    30.538
    79.165    30.497
>
    79.376    30.145
    79.165    30.497
>
    79.376    30.145
    79.165    30.497
>
    78.640    30.431
    79.165    30.497
>
    78.640    30.431
    79.165    30.497
>
    78.768    30.155
    79.165    30.497
>
    78.768    30.155
    79.165    30.497
>
    79.049    30.019
    79.165    30.497
>
    79.049    30.019
    79.165    30.497
>
    78.605    30.144
    79.165    30.497
>
    78.605    30.144
    79.165    30.497
>
    79.563    30.001
    79.165    30.497
>
    78.918    29.916
    79.165    30.497
>
    78.918    29.916
    79.165    30.497
>
    78.429    30.373
    79.165    30.497
>
    78.429    30.373
    79.165    30.497
>
    79.210    29.820
    79.165    30.497
>
    79.210    29.820
    79.165    30.497
>
    78.378    30.508
    79.165    30.497
>
    78.378    30.508
    79.165    30.497
>
    78.711    29.924
    79.165    30.497
>
    78.711    29.924
    79.165    30.497
>
    78.330    30.574
    79.165    30.497
>
    78.330    30.574
    79.165    30.497
>
    79.595    29.852
    79.165    30.497
>
    79.595    29.852
    79.165    30.497
>
    79.673    29.887
    79.165    30.497
>
    79.673    29.887
    79.165    30.497
>
    78.680    29.839
    79.165    30.497
>
    78.680    29.839
    79.165    30.497
>
    78.244    30.427
    79.165    30.497
>
    78.244    30.427
    79.165    30.497
>
    78.377    30.921
    79.165    30.497
>
    80.248    29.803
    80.150    29.812
>
    80.248    29.803
    80.150    29.812
>
    80.049    29.775
    80.150    29.812
>
    80.049    29.775
    80.150    29.812
>
    80.164    29.905
    80.150    29.812
>
    80.164    29.905
    80.150    29.812
>
    80.040    29.660
    80.150    29.812
>
    80.040    29.660
    80.150    29.812
>
    79.900    29.946
    80.150    29.812
>
    79.900    29.946
    80.150    29.812
>
    80.234    29.552
    80.150    29.812
>
    80.234    29.552
    80.150    29.812
>
    80.238    30.066
    80.150    29.812
>
    80.238    30.066
    80.150    29.812
>
    80.544    29.849
    80.150    29.812
>
    80.094    29.403
    80.150    29.812
>
    80.094    29.403
    80.150    29.812
>
    79.930    29.407
    80.150    29.812
>
    79.930    29.407
    80.150    29.812
>
    80.107    29.330
    80.150    29.812
>
    80.107    29.330
    80.150    29.812
>
    80.049    29.775
    80.150    29.809
>
    80.049    29.775
    80.150    29.809
>
    80.248    29.803
    80.150    29.809
>
    80.248    29.803
    80.150    29.809
>
    80.164    29.905
    80.150    29.809
>
    80.164    29.905
    80.150    29.809
>
    80.040    29.660
    80.150    29.809
>
    80.040    29.660
    80.150    29.809
>
    79.900    29.946
    80.150    29.809
>
    79.900    29.946
    80.150    29.809
>
    80.234    29.552
    80.150    29.809
>
    80.234    29.552
    80.150    29.809
>
    80.238    30.066
    80.150    29.809
>
    80.238    30.066
    80.150    29.809
>
    80.094    29.403
    80.150    29.809
>
    80.094    29.403
    80.150    29.809
>
    79.930    29.407
    80.150    29.809
>
    79.930    29.407
    80.150    29.809
>
    80.107    29.330
    80.150    29.809
>
    80.107    29.330
    80.150    29.809
>
    79.900    29.946
    79.899    30.169
>
    79.900    29.946
    79.899    30.169
>
    80.238    30.066
    79.899    30.169
>
    80.238    30.066
    79.899    30.169
>
    79.563    30.001
    79.899    30.169
>
    79.563    30.001
    79.899    30.169
>
    79.673    29.887
    79.899    30.169
>
    79.673    29.887
    79.899    30.169
>
    80.164    29.905
    79.899    30.169
>
    80.164    29.905
    79.899    30.169
>
    79.416    30.250
    79.899    30.169
>
    79.416    30.250
    79.899    30.169
>
    80.049    29.775
    79.899    30.169
>
    80.049    29.775
    79.899    30.169
>
    80.248    29.803
    79.899    30.169
>
    80.248    29.803
    79.899    30.169
>
    80.040    29.660
    79.899    30.169
>
    80.040    29.660
    79.899    30.169
>
    79.322    30.406
    79.899    30.169
>
    79.322    30.406
    79.899    30.169
>
    79.416    29.770
    79.899    30.169
>
    80.544    29.849
    79.899    30.169
>
    80.544    29.849
    79.899    30.169
>
    79.210    29.820
    79.899    30.169
>
    79.210    29.820
    79.899    30.169
>
    80.234    29.552
    79.899    30.169
>
    79.049    30.019
    79.899    30.169
>
    79.049    30.019
    79.899    30.169
>
    79.141    30.588
    79.899    30.169
>
    79.141    30.588
    79.899    30.169
>
    79.019    30.389
    79.899    30.169
>
    80.094    29.403
    79.899    30.169
>
    80.094    29.403
    79.899    30.169
>
    79.900    29.946
    79.934    30.049
>
    79.900    29.946
    79.934    30.049
>
    80.164    29.905
    79.934    30.049
>
    80.164    29.905
    79.934    30.049
>
    80.238    30.066
    79.934    30.049
>
    80.238    30.066
    79.934    30.049
>
    79.673    29.887
    79.934    30.049
>
    79.673    29.887
    79.934    30.049
>
    80.049    29.775
    79.934    30.049
>
    80.049    29.775
    79.934    30.049
>
    79.563    30.001
    79.934    30.049
>
    79.563    30.001
    79.934    30.049
>
    79.595    29.852
    79.934    30.049
>
    79.595    29.852
    79.934    30.049
>
    80.248    29.803
    79.934    30.049
>
    80.040    29.660
    79.934    30.049
>
    80.040    29.660
    79.934    30.049
>
    79.416    30.250
    79.934    30.049
>
    79.416    30.250
    79.934    30.049
>
    79.416    29.770
    79.934    30.049
>
    79.416    29.770
    79.934    30.049
>
    80.234    29.552
    79.934    30.049
>
    80.234    29.552
    79.934    30.049
>
    80.094    29.403
    79.934    30.049
>
    80.094    29.403
    79.934    30.049
>
    79.210    29.820
    79.934    30.049
>
    78.205    30.808
    78.318    30.811
>
    78.205    30.808
    78.318    30.811
>
    78.436    30.721
    78.318    30.811
>
    78.436    30.721
    78.318    30.811
>
    78.377    30.921
    78.318    30.811
>
    78.377    30.921
    78.318    30.811
>
    78.103    30.909
    78.318    30.811
>
    78.103    30.909
    78.318    30.811
>
    78.378    30.508
    78.318    30.811
>
    78.378    30.508
    78.318    30.811
>
    78.074    30.455
    78.318    30.811
>
    78.074    30.455
    78.318    30.811
>
    77.873    30.691
    78.318    30.811
>
    77.873    30.691
    78.318    30.811
>
    78.429    30.373
    78.318    30.811
>
    78.429    30.373
    78.318    30.811
>
    77.845    30.934
    78.318    30.811
>
    77.845    30.934
    78.318    30.811
>
    78.640    30.431
    78.318    30.811
>
    78.640    30.431
    78.318    30.811
>
    78.605    30.144
    78.318    30.811
>
    78.605    30.144
    78.318    30.811
>
    79.141    30.588
    78.318    30.811
>
    79.141    30.588
    78.318    30.811
>
    78.436    30.721
    78.322    30.808
>
    78.436    30.721
    78.322    30.808
>
    78.205    30.808
    78.322    30.808
>
    78.205    30.808
    78.322    30.808
>
    78.377    30.921
    78.322    30.808
>
    78.377    30.921
    78.322    30.808
>
    78.330    30.574
    78.322    30.808
>
    78.330    30.574
    78.322    30.808
>
    78.103    30.909
    78.322    30.808
>
    78.103    30.909
    78.322    30.808
>
    78.378    30.508
    78.322    30.808
>
    78.378    30.508
    78.322    30.808
>
    78.649    30.579
    78.322    30.808
>
    78.649    30.579
    78.322    30.808
>
    78.244    30.427
    78.322    30.808
>
    78.244    30.427
    78.322    30.808
>
    78.640    30.431
    78.322    30.808
>
    78.640    30.431
    78.322    30.808
>
    78.975    30.639
    78.322    30.808
>
    78.975    30.639
    78.322    30.808
>
    79.019    30.389
    78.322    30.808
>
    79.019    30.389
    78.322    30.808
>
    78.436    30.721
    78.420    30.830
>
    78.436    30.721
    78.420    30.830
>
    78.377    30.921
    78.420    30.830
>
    78.377    30.921
    78.420    30.830
>
    78.205    30.808
    78.420    30.830
>
    78.205    30.808
    78.420    30.830
>
    78.330    30.574
    78.420    30.830
>
    78.330    30.574
    78.420    30.830
>
    78.649    30.579
    78.420    30.830
>
    78.649    30.579
    78.420    30.830
>
    78.103    30.909
    78.420    30.830
>
    78.103    30.909
    78.420    30.830
>
    78.378    30.508
    78.420    30.830
>
    78.378    30.508
    78.420    30.830
>
    78.753    31.036
    78.420    30.830
>
    78.753    31.036
    78.420    30.830
>
    78.640    30.431
    78.420    30.830
>
    78.640    30.431
    78.420    30.830
>
    78.244    30.427
    78.420    30.830
>
    78.244    30.427
    78.420    30.830
>
    78.429    30.373
    78.420    30.830
>
    78.429    30.373
    78.420    30.830
>
    78.074    30.455
    78.420    30.830
>
    78.074    30.455
    78.420    30.830
>
    78.975    30.639
    78.420    30.830
>
    78.975    30.639
    78.420    30.830
>
    77.873    30.691
    78.420    30.830
>
    77.873    30.691
    78.420    30.830
>
    77.845    30.934
    78.420    30.830
>
    77.845    30.934
    78.420    30.830
>
    77.843    30.518
    78.420    30.830
>
    77.843    30.518
    78.420    30.830
>
    79.141    30.588
    78.420    30.830
>
    79.141    30.588
    78.420    30.830
>
    79.019    30.389
    78.420    30.830
>
    78.605    30.144
    78.420    30.830
>
    78.605    30.144
    78.420    30.830
>
    79.176    30.488
    78.420    30.830
>
    78.768    30.155
    78.420    30.830
>
    78.768    30.155
    78.420    30.830
>
    78.436    30.721
    78.426    30.827
>
    78.436    30.721
    78.426    30.827
>
    78.377    30.921
    78.426    30.827
>
    78.377    30.921
    78.426    30.827
>
    78.205    30.808
    78.426    30.827
>
    78.205    30.808
    78.426    30.827
>
    78.649    30.579
    78.426    30.827
>
    78.649    30.579
    78.426    30.827
>
    78.103    30.909
    78.426    30.827
>
    78.103    30.909
    78.426    30.827
>
    78.378    30.508
    78.426    30.827
>
    78.378    30.508
    78.426    30.827
>
    78.753    31.036
    78.426    30.827
>
    78.753    31.036
    78.426    30.827
>
    78.640    30.431
    78.426    30.827
>
    78.244    30.427
    78.426    30.827
>
    78.244    30.427
    78.426    30.827
>
    78.074    30.455
    78.426    30.827
>
    78.975    30.639
    78.426    30.827
>
    78.975    30.639
    78.426    30.827
>
    77.873    30.691
    78.426    30.827
>
    77.873    30.691
    78.426    30.827
>
    77.845    30.934
    78.426    30.827
>
    77.845    30.934
    78.426    30.827
>
    79.141    30.588
    78.426    30.827
>
    79.141    30.588
    78.426    30.827
>
    78.436    30.721
    78.556    30.707
>
    78.436    30.721
    78.556    30.707
>
    78.330    30.574
    78.556    30.707
>
    78.330    30.574
    78.556    30.707
>
    78.378    30.508
    78.556    30.707
>
    78.378    30.508
    78.556    30.707
>
    78.640    30.431
    78.556    30.707
>
    78.640    30.431
    78.556    30.707
>
    78.377    30.921
    78.556    30.707
>
    78.205    30.808
    78.556    30.707
>
    78.205    30.808
    78.556    30.707
>
    78.975    30.639
    78.556    30.707
>
    78.975    30.639
    78.556    30.707
>
    78.429    30.373
    78.556    30.707
>
    78.429    30.373
    78.556    30.707
>
    78.753    31.036
    78.556    30.707
>
    78.753    31.036
    78.556    30.707
>
    78.244    30.427
    78.556    30.707
>
    78.244    30.427
    78.556    30.707
>
    78.103    30.909
    78.556    30.707
>
    78.103    30.909
    78.556    30.707
>
    79.019    30.389
    78.556    30.707
>
    79.141    30.588
    78.556    30.707
>
    79.141    30.588
    78.556    30.707
>
    78.074    30.455
    78.556    30.707
>
    78.074    30.455
    78.556    30.707
>
    78.605    30.144
    78.556    30.707
>
    78.605    30.144
    78.556    30.707
>
    79.176    30.488
    78.556    30.707
>
    79.176    30.488
    78.556    30.707
>
    78.768    30.155
    78.556    30.707
>
    78.768    30.155
    78.556    30.707
>
    77.873    30.691
    78.556    30.707
>
    77.873    30.691
    78.556    30.707
>
    77.843    30.518
    78.556    30.707
>
    77.843    30.518
    78.556    30.707
>
    77.845    30.934
    78.556    30.707
>
    78.711    29.924
    78.556    30.707
>
    78.711    29.924
    78.556    30.707
>
    79.900    29.946
    79.931    30.131
>
    79.900    29.946
    79.931    30.131
>
    80.164    29.905
    79.931    30.131
>
    80.164    29.905
    79.931    30.131
>
    79.563    30.001
    79.931    30.131
>
    79.563    30.001
    79.931    30.131
>
    80.049    29.775
    79.931    30.131
>
    80.049    29.775
    79.931    30.131
>
    79.595    29.852
    79.931    30.131
>
    79.595    29.852
    79.931    30.131
>
    80.248    29.803
    79.931    30.131
>
    80.248    29.803
    79.931    30.131
>
    80.040    29.660
    79.931    30.131
>
    80.040    29.660
    79.931    30.131
>
    79.566    30.538
    79.931    30.131
>
    79.566    30.538
    79.931    30.131
>
    79.416    29.770
    79.931    30.131
>
    79.416    29.770
    79.931    30.131
>
    79.322    30.406
    79.931    30.131
>
    80.234    29.552
    79.931    30.131
>
    80.234    29.552
    79.931    30.131
>
    79.210    29.820
    79.931    30.131
>
    79.210    29.820
    79.931    30.131
>
    79.930    29.407
    79.931    30.131
>
    79.930    29.407
    79.931    30.131
>
    80.094    29.403
    79.931    30.131
>
    80.094    29.403
    79.931    30.131
>
    79.049    30.019
    79.931    30.131
>
    79.322    30.406
    79.433    30.363
>
    79.322    30.406
    79.433    30.363
>
    79.416    30.250
    79.433    30.363
>
    79.416    30.250
    79.433    30.363
>
    79.176    30.488
    79.433    30.363
>
    79.176    30.488
    79.433    30.363
>
    79.288    30.051
    79.433    30.363
>
    79.288    30.051
    79.433    30.363
>
    79.141    30.588
    79.433    30.363
>
    79.019    30.389
    79.433    30.363
>
    79.019    30.389
    79.433    30.363
>
    79.563    30.001
    79.433    30.363
>
    79.563    30.001
    79.433    30.363
>
    79.049    30.019
    79.433    30.363
>
    79.049    30.019
    79.433    30.363
>
    78.975    30.639
    79.433    30.363
>
    79.595    29.852
    79.433    30.363
>
    79.595    29.852
    79.433    30.363
>
    79.210    29.820
    79.433    30.363
>
    79.210    29.820
    79.433    30.363
>
    79.416    29.770
    79.433    30.363
>
    79.416    29.770
    79.433    30.363
>
    78.768    30.155
    79.433    30.363
>
    78.768    30.155
    79.433    30.363
>
    78.918    29.916
    79.433    30.363
>
    78.918    29.916
    79.433    30.363
>
    79.015    29.750
    79.433    30.363
>
    79.015    29.750
    79.433    30.363
>
    78.605    30.144
    79.433    30.363
>
    78.605    30.144
    79.433    30.363
>
    79.176    30.488
    79.172    30.498
>
    79.176    30.488
    79.172    30.498
>
    79.141    30.588
    79.172    30.498
>
    79.141    30.588
    79.172    30.498
>
    79.322    30.406
    79.172    30.498
>
    79.322    30.406
    79.172    30.498
>
    79.019    30.389
    79.172    30.498
>
    79.019    30.389
    79.172    30.498
>
    78.975    30.639
    79.172    30.498
>
    78.975    30.639
    79.172    30.498
>
    79.416    30.250
    79.172    30.498
>
    79.416    30.250
    79.172    30.498
>
    79.566    30.538
    79.172    30.498
>
    79.566    30.538
    79.172    30.498
>
    79.288    30.051
    79.172    30.498
>
    79.288    30.051
    79.172    30.498
>
    78.649    30.579
    79.172    30.498
>
    78.649    30.579
    79.172    30.498
>
    78.640    30.431
    79.172    30.498
>
    78.640    30.431
    79.172    30.498
>
    78.768    30.155
    79.172    30.498
>
    78.768    30.155
    79.172    30.498
>
    79.049    30.019
    79.172    30.498
>
    79.049    30.019
    79.172    30.498
>
    78.605    30.144
    79.172    30.498
>
    78.605    30.144
    79.172    30.498
>
    79.563    30.001
    79.172    30.498
>
    79.563    30.001
    79.172    30.498
>
    78.918    29.916
    79.172    30.498
>
    78.918    29.916
    79.172    30.498
>
    78.429    30.373
    79.172    30.498
>
    78.429    30.373
    79.172    30.498
>
    79.210    29.820
    79.172    30.498
>
    79.210    29.820
    79.172    30.498
>
    78.436    30.721
    79.172    30.498
>
    78.436    30.721
    79.172    30.498
>
    78.378    30.508
    79.172    30.498
>
    78.378    30.508
    79.172    30.498
>
    79.673    29.887
    79.172    30.498
>
    79.673    29.887
    79.172    30.498
>
    79.015    29.750
    79.172    30.498
>
    79.015    29.750
    79.172    30.498
>
    79.416    29.770
    79.172    30.498
>
    79.416    29.770
    79.172    30.498
>
    78.680    29.839
    79.172    30.498
>
    78.680    29.839
    79.172    30.498
>
    79.141    30.588
    79.300    30.681
>
    79.141    30.588
    79.300    30.681
>
    79.176    30.488
    79.300    30.681
>
    79.176    30.488
    79.300    30.681
>
    79.322    30.406
    79.300    30.681
>
    79.322    30.406
    79.300    30.681
>
    79.566    30.538
    79.300    30.681
>
    79.566    30.538
    79.300    30.681
>
    78.975    30.639
    79.300    30.681
>
    78.975    30.639
    79.300    30.681
>
    79.019    30.389
    79.300    30.681
>
    79.019    30.389
    79.300    30.681
>
    79.416    30.250
    79.300    30.681
>
    79.416    30.250
    79.300    30.681
>
    79.376    30.145
    79.300    30.681
>
    79.376    30.145
    79.300    30.681
>
    78.649    30.579
    79.300    30.681
>
    78.649    30.579
    79.300    30.681
>
    78.753    31.036
    79.300    30.681
>
    78.640    30.431
    79.300    30.681
>
    78.640    30.431
    79.300    30.681
>
    79.049    30.019
    79.300    30.681
>
    79.049    30.019
    79.300    30.681
>
    78.768    30.155
    79.300    30.681
>
    78.768    30.155
    79.300    30.681
>
    79.563    30.001
    79.300    30.681
>
    79.563    30.001
    79.300    30.681
>
    78.436    30.721
    79.300    30.681
>
    79.930    29.407
    79.901    30.096
>
    79.900    29.946
    79.901    30.096
>
    79.900    29.946
    79.901    30.096
>
    79.673    29.887
    79.901    30.096
>
    79.673    29.887
    79.901    30.096
>
    80.164    29.905
    79.901    30.096
>
    80.164    29.905
    79.901    30.096
>
    80.238    30.066
    79.901    30.096
>
    80.238    30.066
    79.901    30.096
>
    79.563    30.001
    79.901    30.096
>
    79.563    30.001
    79.901    30.096
>
    80.049    29.775
    79.901    30.096
>
    80.049    29.775
    79.901    30.096
>
    79.595    29.852
    79.901    30.096
>
    79.595    29.852
    79.901    30.096
>
    80.248    29.803
    79.901    30.096
>
    80.248    29.803
    79.901    30.096
>
    80.040    29.660
    79.901    30.096
>
    79.416    29.770
    79.901    30.096
>
    79.416    29.770
    79.901    30.096
>
    79.288    30.051
    79.901    30.096
>
    79.288    30.051
    79.901    30.096
>
    80.234    29.552
    79.901    30.096
>
    80.234    29.552
    79.901    30.096
>
    79.210    29.820
    79.901    30.096
>
    80.094    29.403
    79.901    30.096
>
    80.094    29.403
    79.901    30.096
>
    80.107    29.330
    79.901    30.096
>
    80.107    29.330
    79.901    30.096
>
    79.930    29.407
    79.901    30.096
>
    79.930    29.407
    79.901    30.096
>
    79.900    29.946
    79.901    30.096
>
    79.900    29.946
    79.901    30.096
>
    79.673    29.887
    79.901    30.096
>
    79.673    29.887
    79.901    30.096
>
    79.563    30.001
    79.901    30.096
>
    79.563    30.001
    79.901    30.096
>
    80.164    29.905
    79.901    30.096
>
    80.164    29.905
    79.901    30.096
>
    80.049    29.775
    79.901    30.096
>
    80.049    29.775
    79.901    30.096
>
    79.595    29.852
    79.901    30.096
>
    79.595    29.852
    79.901    30.096
>
    79.416    30.250
    79.901    30.096
>
    79.416    30.250
    79.901    30.096
>
    79.376    30.145
    79.901    30.096
>
    79.376    30.145
    79.901    30.096
>
    80.040    29.660
    79.901    30.096
>
    80.040    29.660
    79.901    30.096
>
    79.416    29.770
    79.901    30.096
>
    79.416    29.770
    79.901    30.096
>
    79.288    30.051
    79.901    30.096
>
    79.288    30.051
    79.901    30.096
>
    79.566    30.538
    79.901    30.096
>
    79.566    30.538
    79.901    30.096
>
    79.648    29.592
    79.901    30.096
>
    79.648    29.592
    79.901    30.096
>
    79.322    30.406
    79.901    30.096
>
    80.234    29.552
    79.901    30.096
>
    80.234    29.552
    79.901    30.096
>
    80.544    29.849
    79.901    30.096
>
    80.544    29.849
    79.901    30.096
>
    79.210    29.820
    79.901    30.096
>
    79.210    29.820
    79.901    30.096
>
    80.094    29.403
    79.901    30.096
>
    80.094    29.403
    79.901    30.096
>
    79.049    30.019
    79.901    30.096
>
    79.176    30.488
    79.901    30.096
>
    80.107    29.330
    79.901    30.096
>
    80.107    29.330
    79.901    30.096
>
    79.558    30.556
    79.901    30.096
>
    79.558    30.556
    79.901    30.096
>
    80.217    29.550
    79.901    30.096
>
    80.217    29.550
    79.901    30.096
>
    80.246    29.450
    79.901    30.096
>
    80.246    29.450
    79.901    30.096
>
    79.322    30.406
    79.411    30.466
>
    79.322    30.406
    79.411    30.466
>
    79.566    30.538
    79.411    30.466
>
    79.566    30.538
    79.411    30.466
>
    79.176    30.488
    79.411    30.466
>
    79.176    30.488
    79.411    30.466
>
    79.416    30.250
    79.411    30.466
>
    79.416    30.250
    79.411    30.466
>
    79.141    30.588
    79.411    30.466
>
    79.141    30.588
    79.411    30.466
>
    79.376    30.145
    79.411    30.466
>
    79.376    30.145
    79.411    30.466
>
    79.019    30.389
    79.411    30.466
>
    79.019    30.389
    79.411    30.466
>
    79.288    30.051
    79.411    30.466
>
    79.288    30.051
    79.411    30.466
>
    78.975    30.639
    79.411    30.466
>
    78.975    30.639
    79.411    30.466
>
    79.563    30.001
    79.411    30.466
>
    79.563    30.001
    79.411    30.466
>
    79.049    30.019
    79.411    30.466
>
    79.049    30.019
    79.411    30.466
>
    79.673    29.887
    79.411    30.466
>
    79.673    29.887
    79.411    30.466
>
    78.768    30.155
    79.411    30.466
>
    78.768    30.155
    79.411    30.466
>
    79.595    29.852
    79.411    30.466
>
    79.595    29.852
    79.411    30.466
>
    79.210    29.820
    79.411    30.466
>
    79.210    29.820
    79.411    30.466
>
    78.640    30.431
    79.411    30.466
>
    78.640    30.431
    79.411    30.466
>
    78.649    30.579
    79.411    30.466
>
    79.900    29.946
    79.411    30.466
>
    79.900    29.946
    79.411    30.466
>
    78.918    29.916
    79.411    30.466
>
    79.416    29.770
    79.411    30.466
>
    79.416    29.770
    79.411    30.466
>
    78.605    30.144
    79.411    30.466
>
    78.605    30.144
    79.411    30.466
>
    79.015    29.750
    79.411    30.466
>
    79.015    29.750
    79.411    30.466
>
    78.436    30.721
    78.493    30.788
>
    78.436    30.721
    78.493    30.788
>
    78.377    30.921
    78.493    30.788
>
    78.377    30.921
    78.493    30.788
>
    78.649    30.579
    78.493    30.788
>
    78.649    30.579
    78.493    30.788
>
    78.330    30.574
    78.493    30.788
>
    78.330    30.574
    78.493    30.788
>
    78.205    30.808
    78.493    30.788
>
    78.205    30.808
    78.493    30.788
>
    78.378    30.508
    78.493    30.788
>
    78.753    31.036
    78.493    30.788
>
    78.753    31.036
    78.493    30.788
>
    78.640    30.431
    78.493    30.788
>
    78.640    30.431
    78.493    30.788
>
    78.429    30.373
    78.493    30.788
>
    78.429    30.373
    78.493    30.788
>
    78.975    30.639
    78.493    30.788
>
    78.244    30.427
    78.493    30.788
>
    78.244    30.427
    78.493    30.788
>
    78.074    30.455
    78.493    30.788
>
    78.074    30.455
    78.493    30.788
>
    77.873    30.691
    78.493    30.788
>
    77.873    30.691
    78.493    30.788
>
    79.141    30.588
    78.493    30.788
>
    79.141    30.588
    78.493    30.788
>
    79.019    30.389
    78.493    30.788
>
    77.845    30.934
    78.493    30.788
>
    77.845    30.934
    78.493    30.788
>
    77.843    30.518
    78.493    30.788
>
    77.843    30.518
    78.493    30.788
>
    78.605    30.144
    78.493    30.788
>
    78.768    30.155
    78.493    30.788
>
    78.768    30.155
    78.493    30.788
>
    79.930    29.407
    80.392    29.860
>
    79.930    29.407
    80.392    29.860
>
    80.248    29.803
    80.392    29.860
>
    80.248    29.803
    80.392    29.860
>
    80.544    29.849
    80.392    29.860
>
    80.544    29.849
    80.392    29.860
>
    80.164    29.905
    80.392    29.860
>
    80.164    29.905
    80.392    29.860
>
    80.238    30.066
    80.392    29.860
>
    80.238    30.066
    80.392    29.860
>
    80.049    29.775
    80.392    29.860
>
    80.049    29.775
    80.392    29.860
>
    80.234    29.552
    80.392    29.860
>
    80.234    29.552
    80.392    29.860
>
    80.040    29.660
    80.392    29.860
>
    80.040    29.660
    80.392    29.860
>
    80.094    29.403
    80.392    29.860
>
    80.094    29.403
    80.392    29.860
>
    80.107    29.330
    80.392    29.860
>
    80.107    29.330
    80.392    29.860
>
    79.673    29.887
    80.392    29.860
>
    79.673    29.887
    80.392    29.860
>
    79.595    29.852
    80.392    29.860
>
    79.595    29.852
    80.392    29.860
>
    80.164    29.905
    80.082    29.956
>
    80.164    29.905
    80.082    29.956
>
    79.900    29.946
    80.082    29.956
>
    79.900    29.946
    80.082    29.956
>
    80.238    30.066
    80.082    29.956
>
    80.049    29.775
    80.082    29.956
>
    80.049    29.775
    80.082    29.956
>
    80.248    29.803
    80.082    29.956
>
    80.248    29.803
    80.082    29.956
>
    80.040    29.660
    80.082    29.956
>
    80.040    29.660
    80.082    29.956
>
    79.673    29.887
    80.082    29.956
>
    79.673    29.887
    80.082    29.956
>
    79.595    29.852
    80.082    29.956
>
    79.595    29.852
    80.082    29.956
>
    80.234    29.552
    80.082    29.956
>
    80.234    29.552
    80.082    29.956
>
    79.563    30.001
    80.082    29.956
>
    79.648    29.592
    80.082    29.956
>
    80.094    29.403
    80.082    29.956
>
    80.094    29.403
    80.082    29.956
>
    79.416    29.770
    80.082    29.956
>
    79.416    30.250
    80.082    29.956
>
    80.107    29.330
    80.082    29.956
>
    80.107    29.330
    80.082    29.956
>
    79.566    30.538
    80.082    29.956
>
    78.918    29.916
    78.916    29.922
>
    78.918    29.916
    78.916    29.922
>
    79.049    30.019
    78.916    29.922
>
    79.049    30.019
    78.916    29.922
>
    78.711    29.924
    78.916    29.922
>
    78.711    29.924
    78.916    29.922
>
    79.015    29.750
    78.916    29.922
>
    79.015    29.750
    78.916    29.922
>
    78.680    29.839
    78.916    29.922
>
    78.680    29.839
    78.916    29.922
>
    78.768    30.155
    78.916    29.922
>
    78.768    30.155
    78.916    29.922
>
    79.210    29.820
    78.916    29.922
>
    79.210    29.820
    78.916    29.922
>
    78.605    30.144
    78.916    29.922
>
    78.605    30.144
    78.916    29.922
>
    79.376    30.145
    78.916    29.922
>
    79.019    30.389
    78.916    29.922
>
    79.019    30.389
    78.916    29.922
>
    79.416    30.250
    78.916    29.922
>
    79.176    30.488
    78.916    29.922
>
    79.176    30.488
    78.916    29.922
>
    78.975    30.639
    78.916    29.922
>
    79.141    30.588
    79.198    30.479
>
    79.141    30.588
    79.198    30.479
>
    79.322    30.406
    79.198    30.479
>
    79.322    30.406
    79.198    30.479
>
    79.019    30.389
    79.198    30.479
>
    79.019    30.389
    79.198    30.479
>
    78.975    30.639
    79.198    30.479
>
    78.975    30.639
    79.198    30.479
>
    79.416    30.250
    79.198    30.479
>
    79.416    30.250
    79.198    30.479
>
    79.566    30.538
    79.198    30.479
>
    79.566    30.538
    79.198    30.479
>
    79.049    30.019
    79.198    30.479
>
    79.049    30.019
    79.198    30.479
>
    78.640    30.431
    79.198    30.479
>
    78.640    30.431
    79.198    30.479
>
    78.768    30.155
    79.198    30.479
>
    78.768    30.155
    79.198    30.479
>
    79.563    30.001
    79.198    30.479
>
    79.563    30.001
    79.198    30.479
>
    78.918    29.916
    79.198    30.479
>
    78.918    29.916
    79.198    30.479
>
    78.605    30.144
    79.198    30.479
>
    78.605    30.144
    79.198    30.479
>
    79.210    29.820
    79.198    30.479
>
    79.210    29.820
    79.198    30.479
>
    78.429    30.373
    79.198    30.479
>
    78.429    30.373
    79.198    30.479
>
    78.436    30.721
    79.198    30.479
>
    78.436    30.721
    79.198    30.479
>
    78.378    30.508
    79.198    30.479
>
    78.378    30.508
    79.198    30.479
>
    79.595    29.852
    79.198    30.479
>
    79.595    29.852
    79.198    30.479
>
    79.673    29.887
    79.198    30.479
>
    79.673    29.887
    79.198    30.479
>
    79.015    29.750
    79.198    30.479
>
    79.015    29.750
    79.198    30.479
>
    78.680    29.839
    79.198    30.479
>
    78.680    29.839
    79.198    30.479
>
    78.975    30.639
    78.945    30.541
>
    78.975    30.639
    78.945    30.541
>
    79.019    30.389
    78.945    30.541
>
    79.019    30.389
    78.945    30.541
>
    79.141    30.588
    78.945    30.541
>
    79.141    30.588
    78.945    30.541
>
    79.176    30.488
    78.945    30.541
>
    79.176    30.488
    78.945    30.541
>
    78.640    30.431
    78.945    30.541
>
    78.640    30.431
    78.945    30.541
>
    78.605    30.144
    78.945    30.541
>
    78.605    30.144
    78.945    30.541
>
    78.378    30.508
    78.945    30.541
>
    79.049    30.019
    78.945    30.541
>
    79.049    30.019
    78.945    30.541
>
    78.918    29.916
    78.945    30.541
>
    78.918    29.916
    78.945    30.541
>
    78.680    29.839
    78.945    30.541
>
    78.680    29.839
    78.945    30.541
>
    79.416    30.250
    79.472    30.342
>
    79.416    30.250
    79.472    30.342
>
    79.322    30.406
    79.472    30.342
>
    79.322    30.406
    79.472    30.342
>
    79.376    30.145
    79.472    30.342
>
    79.376    30.145
    79.472    30.342
>
    79.566    30.538
    79.472    30.342
>
    79.566    30.538
    79.472    30.342
>
    79.176    30.488
    79.472    30.342
>
    79.176    30.488
    79.472    30.342
>
    79.563    30.001
    79.472    30.342
>
    79.563    30.001
    79.472    30.342
>
    79.141    30.588
    79.472    30.342
>
    79.141    30.588
    79.472    30.342
>
    79.019    30.389
    79.472    30.342
>
    79.019    30.389
    79.472    30.342
>
    79.049    30.019
    79.472    30.342
>
    79.049    30.019
    79.472    30.342
>
    79.673    29.887
    79.472    30.342
>
    79.673    29.887
    79.472    30.342
>
    79.595    29.852
    79.472    30.342
>
    79.595    29.852
    79.472    30.342
>
    78.975    30.639
    79.472    30.342
>
    78.975    30.639
    79.472    30.342
>
    79.900    29.946
    79.472    30.342
>
    79.900    29.946
    79.472    30.342
>
    79.210    29.820
    79.472    30.342
>
    79.210    29.820
    79.472    30.342
>
    79.416    29.770
    79.472    30.342
>
    79.416    29.770
    79.472    30.342
>
    78.918    29.916
    79.472    30.342
>
    78.768    30.155
    79.472    30.342
>
    78.918    29.916
    79.472    30.342
>
    78.768    30.155
    79.472    30.342
>
    79.015    29.750
    79.472    30.342
>
    79.015    29.750
    79.472    30.342
>
    78.640    30.431
    79.472    30.342
>
    78.640    30.431
    79.472    30.342
>
    80.164    29.905
    79.472    30.342
>
    80.049    29.775
    79.472    30.342
>
    80.049    29.775
    79.472    30.342
>
    79.648    29.592
    79.472    30.342
>
    79.648    29.592
    79.472    30.342
>
    78.605    30.144
    79.472    30.342
>
    78.605    30.144
    79.472    30.342
>
    80.544    29.849
    80.407    29.866
>
    80.544    29.849
    80.407    29.866
>
    80.248    29.803
    80.407    29.866
>
    80.248    29.803
    80.407    29.866
>
    80.164    29.905
    80.407    29.866
>
    80.164    29.905
    80.407    29.866
>
    80.238    30.066
    80.407    29.866
>
    80.238    30.066
    80.407    29.866
>
    80.049    29.775
    80.407    29.866
>
    80.049    29.775
    80.407    29.866
>
    80.234    29.552
    80.407    29.866
>
    80.234    29.552
    80.407    29.866
>
    80.040    29.660
    80.407    29.866
>
    80.040    29.660
    80.407    29.866
>
    79.900    29.946
    80.407    29.866
>
    79.900    29.946
    80.407    29.866
>
    80.094    29.403
    80.407    29.866
>
    80.094    29.403
    80.407    29.866
>
    80.107    29.330
    80.407    29.866
>
    80.107    29.330
    80.407    29.866
>
    79.673    29.887
    80.407    29.866
>
    79.673    29.887
    80.407    29.866
>
    79.595    29.852
    80.407    29.866
>
    79.563    30.001
    80.407    29.866
>
    79.563    30.001
    80.407    29.866
>
    78.975    30.639
    78.901    30.589
>
    78.975    30.639
    78.901    30.589
>
    79.141    30.588
    78.901    30.589
>
    79.141    30.588
    78.901    30.589
>
    79.019    30.389
    78.901    30.589
>
    79.019    30.389
    78.901    30.589
>
    78.649    30.579
    78.901    30.589
>
    78.649    30.579
    78.901    30.589
>
    78.640    30.431
    78.901    30.589
>
    78.640    30.431
    78.901    30.589
>
    78.436    30.721
    78.901    30.589
>
    78.436    30.721
    78.901    30.589
>
    78.378    30.508
    78.901    30.589
>
    78.378    30.508
    78.901    30.589
>
    78.330    30.574
    78.901    30.589
>
    78.605    30.144
    78.901    30.589
>
    79.049    30.019
    78.901    30.589
>
    79.288    30.051
    78.901    30.589
>
    78.918    29.916
    78.901    30.589
>
    78.918    29.916
    78.901    30.589
>
    80.544    29.849
    80.460    29.886
>
    80.544    29.849
    80.460    29.886
>
    80.248    29.803
    80.460    29.886
>
    80.248    29.803
    80.460    29.886
>
    80.164    29.905
    80.460    29.886
>
    80.164    29.905
    80.460    29.886
>
    80.238    30.066
    80.460    29.886
>
    80.238    30.066
    80.460    29.886
>
    80.049    29.775
    80.460    29.886
>
    80.049    29.775
    80.460    29.886
>
    80.234    29.552
    80.460    29.886
>
    80.234    29.552
    80.460    29.886
>
    80.040    29.660
    80.460    29.886
>
    80.040    29.660
    80.460    29.886
>
    79.900    29.946
    80.460    29.886
>
    79.900    29.946
    80.460    29.886
>
    80.094    29.403
    80.460    29.886
>
    80.094    29.403
    80.460    29.886
>
    80.107    29.330
    80.460    29.886
>
    80.107    29.330
    80.460    29.886
>
    79.930    29.407
    80.460    29.886
>
    79.930    29.407
    80.460    29.886
>
    79.673    29.887
    80.460    29.886
>
    79.673    29.887
    80.460    29.886
>
    79.595    29.852
    80.460    29.886
>
    79.595    29.852
    80.460    29.886
>
    79.648    29.592
    80.460    29.886
>
    79.648    29.592
    80.460    29.886
>
    79.563    30.001
    80.460    29.886
>
    79.563    30.001
    80.460    29.886
>
    80.544    29.849
    80.467    29.891
>
    80.544    29.849
    80.467    29.891
>
    80.248    29.803
    80.467    29.891
>
    80.164    29.905
    80.467    29.891
>
    80.164    29.905
    80.467    29.891
>
    80.238    30.066
    80.467    29.891
>
    80.238    30.066
    80.467    29.891
>
    80.234    29.552
    80.467    29.891
>
    80.234    29.552
    80.467    29.891
>
    80.040    29.660
    80.467    29.891
>
    80.040    29.660
    80.467    29.891
>
    80.094    29.403
    80.467    29.891
>
    80.094    29.403
    80.467    29.891
>
    80.107    29.330
    80.467    29.891
>
    80.107    29.330
    80.467    29.891
>
    79.930    29.407
    80.467    29.891
>
    79.930    29.407
    80.467    29.891
>
    79.595    29.852
    80.467    29.891
>
    80.164    29.905
    80.333    29.937
>
    80.164    29.905
    80.333    29.937
>
    80.238    30.066
    80.333    29.937
>
    80.238    30.066
    80.333    29.937
>
    80.248    29.803
    80.333    29.937
>
    80.248    29.803
    80.333    29.937
>
    80.544    29.849
    80.333    29.937
>
    80.544    29.849
    80.333    29.937
>
    80.049    29.775
    80.333    29.937
>
    80.049    29.775
    80.333    29.937
>
    79.900    29.946
    80.333    29.937
>
    79.900    29.946
    80.333    29.937
>
    80.040    29.660
    80.333    29.937
>
    80.040    29.660
    80.333    29.937
>
    80.234    29.552
    80.333    29.937
>
    80.234    29.552
    80.333    29.937
>
    79.673    29.887
    80.333    29.937
>
    79.673    29.887
    80.333    29.937
>
    80.094    29.403
    80.333    29.937
>
    80.094    29.403
    80.333    29.937
>
    79.930    29.407
    80.333    29.937
>
    79.930    29.407
    80.333    29.937
>
    79.595    29.852
    80.333    29.937
>
    79.595    29.852
    80.333    29.937
>
    80.107    29.330
    80.333    29.937
>
    80.107    29.330
    80.333    29.937
>
    79.563    30.001
    80.333    29.937
>
    79.563    30.001
    80.333    29.937
>
    79.648    29.592
    80.333    29.937
>
    79.648    29.592
    80.333    29.937
>
    80.217    29.550
    80.333    29.937
>
    80.217    29.550
    80.333    29.937
>
    79.176    30.488
    79.170    30.477
>
    79.176    30.488
    79.170    30.477
>
    79.141    30.588
    79.170    30.477
>
    79.141    30.588
    79.170    30.477
>
    79.019    30.389
    79.170    30.477
>
    79.019    30.389
    79.170    30.477
>
    78.975    30.639
    79.170    30.477
>
    78.975    30.639
    79.170    30.477
>
    79.416    30.250
    79.170    30.477
>
    79.416    30.250
    79.170    30.477
>
    79.566    30.538
    79.170    30.477
>
    79.566    30.538
    79.170    30.477
>
    79.376    30.145
    79.170    30.477
>
    79.376    30.145
    79.170    30.477
>
    78.640    30.431
    79.170    30.477
>
    78.640    30.431
    79.170    30.477
>
    79.049    30.019
    79.170    30.477
>
    79.049    30.019
    79.170    30.477
>
    78.649    30.579
    79.170    30.477
>
    78.649    30.579
    79.170    30.477
>
    78.768    30.155
    79.170    30.477
>
    78.768    30.155
    79.170    30.477
>
    79.563    30.001
    79.170    30.477
>
    78.605    30.144
    79.170    30.477
>
    78.605    30.144
    79.170    30.477
>
    78.918    29.916
    79.170    30.477
>
    78.918    29.916
    79.170    30.477
>
    79.210    29.820
    79.170    30.477
>
    79.210    29.820
    79.170    30.477
>
    78.711    29.924
    79.170    30.477
>
    78.436    30.721
    79.170    30.477
>
    78.436    30.721
    79.170    30.477
>
    78.378    30.508
    79.170    30.477
>
    78.378    30.508
    79.170    30.477
>
    79.595    29.852
    79.170    30.477
>
    79.595    29.852
    79.170    30.477
>
    79.673    29.887
    79.170    30.477
>
    79.673    29.887
    79.170    30.477
>
    79.015    29.750
    79.170    30.477
>
    79.015    29.750
    79.170    30.477
>
    78.330    30.574
    79.170    30.477
>
    78.330    30.574
    79.170    30.477
>
    78.680    29.839
    79.170    30.477
>
    78.680    29.839
    79.170    30.477
>
    78.640    30.431
    78.550    30.322
>
    78.640    30.431
    78.550    30.322
>
    78.429    30.373
    78.550    30.322
>
    78.429    30.373
    78.550    30.322
>
    78.605    30.144
    78.550    30.322
>
    78.605    30.144
    78.550    30.322
>
    78.378    30.508
    78.550    30.322
>
    78.378    30.508
    78.550    30.322
>
    78.649    30.579
    78.550    30.322
>
    78.649    30.579
    78.550    30.322
>
    78.287    30.161
    78.550    30.322
>
    78.287    30.161
    78.550    30.322
>
    78.244    30.427
    78.550    30.322
>
    78.244    30.427
    78.550    30.322
>
    78.330    30.574
    78.550    30.322
>
    78.330    30.574
    78.550    30.322
>
    78.436    30.721
    78.550    30.322
>
    78.436    30.721
    78.550    30.322
>
    78.074    30.455
    78.550    30.322
>
    78.074    30.455
    78.550    30.322
>
    78.975    30.639
    78.550    30.322
>
    78.975    30.639
    78.550    30.322
>
    78.680    29.839
    78.550    30.322
>
    78.680    29.839
    78.550    30.322
>
    78.918    29.916
    78.550    30.322
>
    78.918    29.916
    78.550    30.322
>
    79.176    30.488
    78.550    30.322
>
    79.176    30.488
    78.550    30.322
>
    79.141    30.588
    78.550    30.322
>
    79.141    30.588
    78.550    30.322
>
    78.205    30.808
    78.550    30.322
>
    78.205    30.808
    78.550    30.322
>
    77.873    30.691
    78.550    30.322
>
    79.416    30.250
    78.550    30.322
>
    79.176    30.488
    79.215    30.484
>
    79.176    30.488
    79.215    30.484
>
    79.141    30.588
    79.215    30.484
>
    79.141    30.588
    79.215    30.484
>
    79.019    30.389
    79.215    30.484
>
    79.019    30.389
    79.215    30.484
>
    78.975    30.639
    79.215    30.484
>
    78.975    30.639
    79.215    30.484
>
    79.416    30.250
    79.215    30.484
>
    79.416    30.250
    79.215    30.484
>
    79.566    30.538
    79.215    30.484
>
    79.566    30.538
    79.215    30.484
>
    79.376    30.145
    79.215    30.484
>
    79.376    30.145
    79.215    30.484
>
    78.649    30.579
    79.215    30.484
>
    79.563    30.001
    79.215    30.484
>
    79.563    30.001
    79.215    30.484
>
    78.918    29.916
    79.215    30.484
>
    78.918    29.916
    79.215    30.484
>
    78.605    30.144
    79.215    30.484
>
    78.605    30.144
    79.215    30.484
>
    79.210    29.820
    79.215    30.484
>
    78.429    30.373
    79.215    30.484
>
    78.429    30.373
    79.215    30.484
>
    78.711    29.924
    79.215    30.484
>
    78.711    29.924
    79.215    30.484
>
    79.595    29.852
    79.215    30.484
>
    79.595    29.852
    79.215    30.484
>
    79.673    29.887
    79.215    30.484
>
    79.673    29.887
    79.215    30.484
>
    78.436    30.721
    79.215    30.484
>
    78.378    30.508
    79.215    30.484
>
    78.378    30.508
    79.215    30.484
>
    79.176    30.488
    79.210    30.492
>
    79.176    30.488
    79.210    30.492
>
    79.141    30.588
    79.210    30.492
>
    79.141    30.588
    79.210    30.492
>
    79.019    30.389
    79.210    30.492
>
    79.019    30.389
    79.210    30.492
>
    78.975    30.639
    79.210    30.492
>
    78.975    30.639
    79.210    30.492
>
    79.416    30.250
    79.210    30.492
>
    79.416    30.250
    79.210    30.492
>
    79.566    30.538
    79.210    30.492
>
    79.566    30.538
    79.210    30.492
>
    79.376    30.145
    79.210    30.492
>
    79.376    30.145
    79.210    30.492
>
    79.288    30.051
    79.210    30.492
>
    79.288    30.051
    79.210    30.492
>
    78.649    30.579
    79.210    30.492
>
    78.649    30.579
    79.210    30.492
>
    78.640    30.431
    79.210    30.492
>
    78.640    30.431
    79.210    30.492
>
    79.563    30.001
    79.210    30.492
>
    79.563    30.001
    79.210    30.492
>
    78.918    29.916
    79.210    30.492
>
    78.918    29.916
    79.210    30.492
>
    78.605    30.144
    79.210    30.492
>
    78.605    30.144
    79.210    30.492
>
    78.429    30.373
    79.210    30.492
>
    78.429    30.373
    79.210    30.492
>
    78.711    29.924
    79.210    30.492
>
    78.711    29.924
    79.210    30.492
>
    78.436    30.721
    79.210    30.492
>
    78.436    30.721
    79.210    30.492
>
    79.595    29.852
    79.210    30.492
>
    79.595    29.852
    79.210    30.492
>
    79.673    29.887
    79.210    30.492
>
    79.673    29.887
    79.210    30.492
>
    78.378    30.508
    79.210    30.492
>
    78.378    30.508
    79.210    30.492
>
    78.680    29.839
    79.210    30.492
>
    78.680    29.839
    79.210    30.492
>
    79.416    30.250
    79.562    30.264
>
    79.416    30.250
    79.562    30.264
>
    79.376    30.145
    79.562    30.264
>
    79.376    30.145
    79.562    30.264
>
    79.563    30.001
    79.562    30.264
>
    79.563    30.001
    79.562    30.264
>
    79.566    30.538
    79.562    30.264
>
    79.566    30.538
    79.562    30.264
>
    79.288    30.051
    79.562    30.264
>
    79.288    30.051
    79.562    30.264
>
    79.673    29.887
    79.562    30.264
>
    79.673    29.887
    79.562    30.264
>
    79.176    30.488
    79.562    30.264
>
    79.176    30.488
    79.562    30.264
>
    79.595    29.852
    79.562    30.264
>
    79.595    29.852
    79.562    30.264
>
    79.900    29.946
    79.562    30.264
>
    79.900    29.946
    79.562    30.264
>
    79.019    30.389
    79.562    30.264
>
    78.975    30.639
    79.562    30.264
>
    78.975    30.639
    79.562    30.264
>
    80.164    29.905
    79.562    30.264
>
    80.164    29.905
    79.562    30.264
>
    80.049    29.775
    79.562    30.264
>
    80.049    29.775
    79.562    30.264
>
    78.918    29.916
    79.562    30.264
>
    78.918    29.916
    79.562    30.264
>
    80.040    29.660
    79.562    30.264
>
    80.040    29.660
    79.562    30.264
>
    79.416    30.250
    79.527    30.277
>
    79.416    30.250
    79.527    30.277
>
    79.376    30.145
    79.527    30.277
>
    79.376    30.145
    79.527    30.277
>
    79.566    30.538
    79.527    30.277
>
    79.566    30.538
    79.527    30.277
>
    79.563    30.001
    79.527    30.277
>
    79.563    30.001
    79.527    30.277
>
    79.288    30.051
    79.527    30.277
>
    79.288    30.051
    79.527    30.277
>
    79.176    30.488
    79.527    30.277
>
    79.176    30.488
    79.527    30.277
>
    79.673    29.887
    79.527    30.277
>
    79.673    29.887
    79.527    30.277
>
    79.595    29.852
    79.527    30.277
>
    79.595    29.852
    79.527    30.277
>
    79.019    30.389
    79.527    30.277
>
    79.019    30.389
    79.527    30.277
>
    79.141    30.588
    79.527    30.277
>
    79.141    30.588
    79.527    30.277
>
    79.900    29.946
    79.527    30.277
>
    79.900    29.946
    79.527    30.277
>
    79.210    29.820
    79.527    30.277
>
    79.210    29.820
    79.527    30.277
>
    78.975    30.639
    79.527    30.277
>
    78.975    30.639
    79.527    30.277
>
    78.918    29.916
    79.527    30.277
>
    78.918    29.916
    79.527    30.277
>
    80.238    30.066
    79.527    30.277
>
    80.164    29.905
    79.527    30.277
>
    80.164    29.905
    79.527    30.277
>
    79.015    29.750
    79.527    30.277
>
    79.015    29.750
    79.527    30.277
>
    80.049    29.775
    79.527    30.277
>
    80.049    29.775
    79.527    30.277
>
    79.648    29.592
    79.527    30.277
>
    79.648    29.592
    79.527    30.277
>
    80.040    29.660
    79.527    30.277
>
    80.040    29.660
    79.527    30.277
>
    78.640    30.431
    79.527    30.277
>
    78.640    30.431
    79.527    30.277
>
    78.711    29.924
    79.527    30.277
>
    79.566    30.538
    79.376    30.534
>
    79.566    30.538
    79.376    30.534
>
    79.176    30.488
    79.376    30.534
>
    79.176    30.488
    79.376    30.534
>
    79.141    30.588
    79.376    30.534
>
    79.141    30.588
    79.376    30.534
>
    79.416    30.250
    79.376    30.534
>
    79.416    30.250
    79.376    30.534
>
    79.019    30.389
    79.376    30.534
>
    79.019    30.389
    79.376    30.534
>
    78.975    30.639
    79.376    30.534
>
    78.975    30.639
    79.376    30.534
>
    79.376    30.145
    79.376    30.534
>
    79.376    30.145
    79.376    30.534
>
    78.649    30.579
    79.376    30.534
>
    78.649    30.579
    79.376    30.534
>
    79.595    29.852
    79.376    30.534
>
    79.595    29.852
    79.376    30.534
>
    78.918    29.916
    79.376    30.534
>
    78.918    29.916
    79.376    30.534
>
    78.605    30.144
    79.376    30.534
>
    78.605    30.144
    79.376    30.534
>
    79.416    30.250
    79.438    30.332
>
    79.416    30.250
    79.438    30.332
>
    79.376    30.145
    79.438    30.332
>
    79.376    30.145
    79.438    30.332
>
    79.566    30.538
    79.438    30.332
>
    79.566    30.538
    79.438    30.332
>
    79.176    30.488
    79.438    30.332
>
    79.176    30.488
    79.438    30.332
>
    79.288    30.051
    79.438    30.332
>
    79.288    30.051
    79.438    30.332
>
    79.563    30.001
    79.438    30.332
>
    79.563    30.001
    79.438    30.332
>
    79.019    30.389
    79.438    30.332
>
    79.019    30.389
    79.438    30.332
>
    79.141    30.588
    79.438    30.332
>
    79.141    30.588
    79.438    30.332
>
    79.673    29.887
    79.438    30.332
>
    79.673    29.887
    79.438    30.332
>
    79.595    29.852
    79.438    30.332
>
    78.975    30.639
    79.438    30.332
>
    79.595    29.852
    79.438    30.332
>
    78.975    30.639
    79.438    30.332
>
    79.210    29.820
    79.438    30.332
>
    79.210    29.820
    79.438    30.332
>
    79.900    29.946
    79.438    30.332
>
    79.900    29.946
    79.438    30.332
>
    78.918    29.916
    79.438    30.332
>
    78.918    29.916
    79.438    30.332
>
    78.605    30.144
    79.438    30.332
>
    78.605    30.144
    79.438    30.332
>
    80.164    29.905
    79.438    30.332
>
    80.164    29.905
    79.438    30.332
>
    79.566    30.538
    79.422    30.487
>
    79.566    30.538
    79.422    30.487
>
    79.176    30.488
    79.422    30.487
>
    79.176    30.488
    79.422    30.487
>
    79.141    30.588
    79.422    30.487
>
    79.141    30.588
    79.422    30.487
>
    79.376    30.145
    79.422    30.487
>
    79.376    30.145
    79.422    30.487
>
    79.019    30.389
    79.422    30.487
>
    79.019    30.389
    79.422    30.487
>
    78.975    30.639
    79.422    30.487
>
    78.975    30.639
    79.422    30.487
>
    79.563    30.001
    79.422    30.487
>
    79.563    30.001
    79.422    30.487
>
    79.673    29.887
    79.422    30.487
>
    79.673    29.887
    79.422    30.487
>
    79.595    29.852
    79.422    30.487
>
    79.595    29.852
    79.422    30.487
>
    78.640    30.431
    79.422    30.487
>
    78.640    30.431
    79.422    30.487
>
    79.210    29.820
    79.422    30.487
>
    79.210    29.820
    79.422    30.487
>
    79.900    29.946
    79.422    30.487
>
    79.900    29.946
    79.422    30.487
>
    79.566    30.538
    79.399    30.465
>
    79.566    30.538
    79.399    30.465
>
    79.176    30.488
    79.399    30.465
>
    79.141    30.588
    79.399    30.465
>
    79.141    30.588
    79.399    30.465
>
    79.019    30.389
    79.399    30.465
>
    79.019    30.389
    79.399    30.465
>
    78.975    30.639
    79.399    30.465
>
    78.975    30.639
    79.399    30.465
>
    79.673    29.887
    79.399    30.465
>
    79.673    29.887
    79.399    30.465
>
    79.595    29.852
    79.399    30.465
>
    79.595    29.852
    79.399    30.465
>
    78.640    30.431
    79.399    30.465
>
    78.640    30.431
    79.399    30.465
>
    79.900    29.946
    79.399    30.465
>
    79.900    29.946
    79.399    30.465
>
    78.918    29.916
    79.399    30.465
>
    79.566    30.538
    79.411    30.483
>
    79.566    30.538
    79.411    30.483
>
    79.176    30.488
    79.411    30.483
>
    79.176    30.488
    79.411    30.483
>
    79.416    30.250
    79.411    30.483
>
    79.416    30.250
    79.411    30.483
>
    79.141    30.588
    79.411    30.483
>
    79.141    30.588
    79.411    30.483
>
    79.019    30.389
    79.411    30.483
>
    79.019    30.389
    79.411    30.483
>
    78.975    30.639
    79.411    30.483
>
    78.975    30.639
    79.411    30.483
>
    79.563    30.001
    79.411    30.483
>
    79.563    30.001
    79.411    30.483
>
    79.049    30.019
    79.411    30.483
>
    79.049    30.019
    79.411    30.483
>
    79.673    29.887
    79.411    30.483
>
    79.673    29.887
    79.411    30.483
>
    79.595    29.852
    79.411    30.483
>
    79.595    29.852
    79.411    30.483
>
    79.900    29.946
    79.411    30.483
>
    79.900    29.946
    79.411    30.483
>
    78.918    29.916
    79.411    30.483
>
    78.918    29.916
    79.411    30.483
>
    78.605    30.144
    79.411    30.483
>
    78.605    30.144
    79.411    30.483
>
    79.566    30.538
    79.421    30.488
>
    79.566    30.538
    79.421    30.488
>
    79.176    30.488
    79.421    30.488
>
    79.176    30.488
    79.421    30.488
>
    79.416    30.250
    79.421    30.488
>
    79.416    30.250
    79.421    30.488
>
    79.141    30.588
    79.421    30.488
>
    79.141    30.588
    79.421    30.488
>
    79.376    30.145
    79.421    30.488
>
    79.376    30.145
    79.421    30.488
>
    79.019    30.389
    79.421    30.488
>
    79.019    30.389
    79.421    30.488
>
    78.975    30.639
    79.421    30.488
>
    78.975    30.639
    79.421    30.488
>
    79.288    30.051
    79.421    30.488
>
    79.288    30.051
    79.421    30.488
>
    79.563    30.001
    79.421    30.488
>
    79.563    30.001
    79.421    30.488
>
    79.673    29.887
    79.421    30.488
>
    79.673    29.887
    79.421    30.488
>
    79.595    29.852
    79.421    30.488
>
    79.595    29.852
    79.421    30.488
>
    79.900    29.946
    79.421    30.488
>
    79.900    29.946
    79.421    30.488
>
    78.918    29.916
    79.421    30.488
>
    78.918    29.916
    79.421    30.488
>
    79.416    29.770
    79.421    30.488
>
    79.416    29.770
    79.421    30.488
>
    79.900    29.946
    80.035    30.057
>
    79.900    29.946
    80.035    30.057
>
    80.238    30.066
    80.035    30.057
>
    80.238    30.066
    80.035    30.057
>
    80.164    29.905
    80.035    30.057
>
    80.164    29.905
    80.035    30.057
>
    80.049    29.775
    80.035    30.057
>
    80.049    29.775
    80.035    30.057
>
    80.248    29.803
    80.035    30.057
>
    80.248    29.803
    80.035    30.057
>
    79.673    29.887
    80.035    30.057
>
    79.673    29.887
    80.035    30.057
>
    79.563    30.001
    80.035    30.057
>
    79.563    30.001
    80.035    30.057
>
    80.040    29.660
    80.035    30.057
>
    80.040    29.660
    80.035    30.057
>
    79.595    29.852
    80.035    30.057
>
    79.595    29.852
    80.035    30.057
>
    80.234    29.552
    80.035    30.057
>
    80.234    29.552
    80.035    30.057
>
    79.648    29.592
    80.035    30.057
>
    79.648    29.592
    80.035    30.057
>
    79.288    30.051
    80.035    30.057
>
    79.288    30.051
    80.035    30.057
>
    79.930    29.407
    80.035    30.057
>
    79.930    29.407
    80.035    30.057
>
    80.094    29.403
    80.035    30.057
>
    80.094    29.403
    80.035    30.057
>
    80.107    29.330
    80.035    30.057
>
    80.107    29.330
    80.035    30.057
>
    79.210    29.820
    80.035    30.057
>
    79.210    29.820
    80.035    30.057
>
    79.900    29.946
    79.980    30.015
>
    79.900    29.946
    79.980    30.015
>
    80.164    29.905
    79.980    30.015
>
    80.164    29.905
    79.980    30.015
>
    80.238    30.066
    79.980    30.015
>
    80.238    30.066
    79.980    30.015
>
    80.049    29.775
    79.980    30.015
>
    80.049    29.775
    79.980    30.015
>
    79.673    29.887
    79.980    30.015
>
    79.673    29.887
    79.980    30.015
>
    80.248    29.803
    79.980    30.015
>
    80.248    29.803
    79.980    30.015
>
    79.563    30.001
    79.980    30.015
>
    79.563    30.001
    79.980    30.015
>
    80.040    29.660
    79.980    30.015
>
    80.040    29.660
    79.980    30.015
>
    79.595    29.852
    79.980    30.015
>
    79.595    29.852
    79.980    30.015
>
    79.648    29.592
    79.980    30.015
>
    79.648    29.592
    79.980    30.015
>
    79.416    30.250
    79.980    30.015
>
    79.416    30.250
    79.980    30.015
>
    80.234    29.552
    79.980    30.015
>
    80.234    29.552
    79.980    30.015
>
    80.544    29.849
    79.980    30.015
>
    80.544    29.849
    79.980    30.015
>
    79.376    30.145
    79.980    30.015
>
    79.376    30.145
    79.980    30.015
>
    79.288    30.051
    79.980    30.015
>
    79.288    30.051
    79.980    30.015
>
    79.930    29.407
    79.980    30.015
>
    79.930    29.407
    79.980    30.015
>
    80.094    29.403
    79.980    30.015
>
    80.094    29.403
    79.980    30.015
>
    79.566    30.538
    79.980    30.015
>
    79.566    30.538
    79.980    30.015
>
    79.210    29.820
    79.980    30.015
>
    79.210    29.820
    79.980    30.015
>
    80.107    29.330
    79.980    30.015
>
    80.107    29.330
    79.980    30.015
>
    79.547    29.355
    79.980    30.015
>
    79.547    29.355
    79.980    30.015
>
    80.217    29.550
    79.980    30.015
>
    80.217    29.550
    79.980    30.015
>
    79.558    30.556
    79.980    30.015
>
    79.558    30.556
    79.980    30.015
>
    80.246    29.450
    79.980    30.015
>
    80.544    29.849
    80.476    29.904
>
    80.544    29.849
    80.476    29.904
>
    80.248    29.803
    80.476    29.904
>
    80.248    29.803
    80.476    29.904
>
    80.238    30.066
    80.476    29.904
>
    80.238    30.066
    80.476    29.904
>
    80.164    29.905
    80.476    29.904
>
    80.164    29.905
    80.476    29.904
>
    80.234    29.552
    80.476    29.904
>
    80.234    29.552
    80.476    29.904
>
    80.040    29.660
    80.476    29.904
>
    80.040    29.660
    80.476    29.904
>
    80.094    29.403
    80.476    29.904
>
    80.094    29.403
    80.476    29.904
>
    80.107    29.330
    80.476    29.904
>
    80.107    29.330
    80.476    29.904
>
    79.930    29.407
    80.476    29.904
>
    79.930    29.407
    80.476    29.904
>
    79.900    29.946
    79.988    30.031
>
    79.900    29.946
    79.988    30.031
>
    80.164    29.905
    79.988    30.031
>
    80.164    29.905
    79.988    30.031
>
    80.238    30.066
    79.988    30.031
>
    80.238    30.066
    79.988    30.031
>
    80.049    29.775
    79.988    30.031
>
    79.673    29.887
    79.988    30.031
>
    79.673    29.887
    79.988    30.031
>
    80.248    29.803
    79.988    30.031
>
    80.248    29.803
    79.988    30.031
>
    79.563    30.001
    79.988    30.031
>
    79.563    30.001
    79.988    30.031
>
    80.040    29.660
    79.988    30.031
>
    80.040    29.660
    79.988    30.031
>
    79.595    29.852
    79.988    30.031
>
    79.595    29.852
    79.988    30.031
>
    79.416    30.250
    79.988    30.031
>
    79.416    30.250
    79.988    30.031
>
    80.234    29.552
    79.988    30.031
>
    80.234    29.552
    79.988    30.031
>
    79.648    29.592
    79.988    30.031
>
    79.376    30.145
    79.988    30.031
>
    79.376    30.145
    79.988    30.031
>
    79.288    30.051
    79.988    30.031
>
    79.288    30.051
    79.988    30.031
>
    79.566    30.538
    79.988    30.031
>
    79.566    30.538
    79.988    30.031
>
    79.930    29.407
    79.988    30.031
>
    79.930    29.407
    79.988    30.031
>
    80.094    29.403
    79.988    30.031
>
    80.094    29.403
    79.988    30.031
>
    80.107    29.330
    79.988    30.031
>
    80.107    29.330
    79.988    30.031
>
    79.210    29.820
    79.251    29.644
>
    79.015    29.750
    79.251    29.644
>
    79.015    29.750
    79.251    29.644
>
    79.457    29.359
    79.251    29.644
>
    79.457    29.359
    79.251    29.644
>
    79.648    29.592
    79.251    29.644
>
    79.648    29.592
    79.251    29.644
>
    79.595    29.852
    79.251    29.644
>
    79.595    29.852
    79.251    29.644
>
    78.918    29.916
    79.251    29.644
>
    78.918    29.916
    79.251    29.644
>
    79.288    30.051
    79.251    29.644
>
    79.288    30.051
    79.251    29.644
>
    79.049    30.019
    79.251    29.644
>
    79.049    30.019
    79.251    29.644
>
    79.673    29.887
    79.251    29.644
>
    79.673    29.887
    79.251    29.644
>
    79.563    30.001
    79.251    29.644
>
    79.563    30.001
    79.251    29.644
>
    79.376    30.145
    79.251    29.644
>
    79.376    30.145
    79.251    29.644
>
    78.680    29.839
    79.251    29.644
>
    78.680    29.839
    79.251    29.644
>
    78.711    29.924
    79.251    29.644
>
    78.711    29.924
    79.251    29.644
>
    79.416    30.250
    79.251    29.644
>
    79.416    30.250
    79.251    29.644
>
    79.900    29.946
    79.251    29.644
>
    79.900    29.946
    79.251    29.644
>
    79.930    29.407
    79.251    29.644
>
    79.930    29.407
    79.251    29.644
>
    78.768    30.155
    79.251    29.644
>
    80.040    29.660
    79.251    29.644
>
    80.040    29.660
    79.251    29.644
>
    78.605    30.144
    79.251    29.644
>
    78.605    30.144
    79.251    29.644
>
    79.019    30.389
    79.251    29.644
>
    79.019    30.389
    79.251    29.644
>
    80.094    29.403
    79.251    29.644
>
    80.094    29.403
    79.251    29.644
>
    79.900    29.946
    79.973    30.026
>
    79.900    29.946
    79.973    30.026
>
    80.164    29.905
    79.973    30.026
>
    80.164    29.905
    79.973    30.026
>
    79.673    29.887
    79.973    30.026
>
    79.673    29.887
    79.973    30.026
>
    80.248    29.803
    79.973    30.026
>
    80.248    29.803
    79.973    30.026
>
    79.563    30.001
    79.973    30.026
>
    79.563    30.001
    79.973    30.026
>
    80.040    29.660
    79.973    30.026
>
    80.040    29.660
    79.973    30.026
>
    79.416    30.250
    79.973    30.026
>
    79.416    30.250
    79.973    30.026
>
    80.234    29.552
    79.973    30.026
>
    80.234    29.552
    79.973    30.026
>
    79.930    29.407
    79.973    30.026
>
    79.930    29.407
    79.973    30.026
>
    80.094    29.403
    79.973    30.026
>
    80.094    29.403
    79.973    30.026
>
    79.210    29.820
    79.973    30.026
>
    79.210    29.820
    79.973    30.026
>
    80.107    29.330
    79.973    30.026
>
    80.107    29.330
    79.973    30.026
>
    78.056    30.323
    77.930    30.654
>
    78.056    30.323
    77.930    30.654
>
    78.205    30.808
    78.119    30.940
>
    78.205    30.808
    78.119    30.940
>
    78.377    30.921
    78.119    30.940
>
    78.377    30.921
    78.119    30.940
>
    77.845    30.934
    78.119    30.940
>
    77.845    30.934
    78.119    30.940
>
    77.873    30.691
    78.119    30.940
>
    77.873    30.691
    78.119    30.940
>
    78.436    30.721
    78.119    30.940
>
    78.436    30.721
    78.119    30.940
>
    78.330    30.574
    78.119    30.940
>
    78.330    30.574
    78.119    30.940
>
    78.074    30.455
    78.119    30.940
>
    78.074    30.455
    78.119    30.940
>
    78.244    30.427
    78.119    30.940
>
    78.244    30.427
    78.119    30.940
>
    78.649    30.579
    78.119    30.940
>
    78.429    30.373
    78.119    30.940
>
    78.640    30.431
    78.119    30.940
>
    78.640    30.431
    78.119    30.940
>
    78.918    29.916
    78.907    29.886
>
    78.918    29.916
    78.907    29.886
>
    79.015    29.750
    78.907    29.886
>
    79.015    29.750
    78.907    29.886
>
    78.711    29.924
    78.907    29.886
>
    78.711    29.924
    78.907    29.886
>
    78.680    29.839
    78.907    29.886
>
    78.680    29.839
    78.907    29.886
>
    79.210    29.820
    78.907    29.886
>
    79.288    30.051
    78.907    29.886
>
    79.288    30.051
    78.907    29.886
>
    78.605    30.144
    78.907    29.886
>
    78.605    30.144
    78.907    29.886
>
    79.376    30.145
    78.907    29.886
>
    79.376    30.145
    78.907    29.886
>
    79.019    30.389
    78.907    29.886
>
    79.019    30.389
    78.907    29.886
>
    79.563    30.001
    78.907    29.886
>
    79.563    30.001
    78.907    29.886
>
    79.416    30.250
    78.907    29.886
>
    79.416    30.250
    78.907    29.886
>
    78.640    30.431
    78.907    29.886
>
    78.640    30.431
    78.907    29.886
>
    79.595    29.852
    78.907    29.886
>
    79.595    29.852
    78.907    29.886
>
    79.176    30.488
    78.907    29.886
>
    79.176    30.488
    78.907    29.886
>
    78.429    30.373
    78.907    29.886
>
    78.429    30.373
    78.907    29.886
>
    79.673    29.887
    78.907    29.886
>
    79.673    29.887
    78.907    29.886
>
    79.457    29.359
    78.907    29.886
>
    79.457    29.359
    78.907    29.886
>
    79.648    29.592
    78.907    29.886
>
    79.648    29.592
    78.907    29.886
>
    79.141    30.588
    78.907    29.886
>
    79.141    30.588
    78.907    29.886
>
    78.649    30.579
    78.907    29.886
>
    78.649    30.579
    78.907    29.886
>
    78.244    30.427
    78.907    29.886
>
    78.244    30.427
    78.907    29.886
>
    78.649    30.579
    78.831    30.655
>
    78.649    30.579
    78.831    30.655
>
    79.141    30.588
    78.831    30.655
>
    78.640    30.431
    78.831    30.655
>
    79.019    30.389
    78.831    30.655
>
    79.019    30.389
    78.831    30.655
>
    79.176    30.488
    78.831    30.655
>
    79.176    30.488
    78.831    30.655
>
    78.436    30.721
    78.831    30.655
>
    78.436    30.721
    78.831    30.655
>
    78.429    30.373
    78.831    30.655
>
    78.330    30.574
    78.831    30.655
>
    78.768    30.155
    78.831    30.655
>
    78.768    30.155
    78.831    30.655
>
    78.605    30.144
    78.831    30.655
>
    78.605    30.144
    78.831    30.655
>
    78.244    30.427
    78.831    30.655
>
    78.244    30.427
    78.831    30.655
>
    79.049    30.019
    78.831    30.655
>
    79.049    30.019
    78.831    30.655
>
    78.074    30.455
    78.831    30.655
>
    79.288    30.051
    78.831    30.655
>
    78.918    29.916
    78.831    30.655
>
    78.918    29.916
    78.831    30.655
>
    79.566    30.538
    79.470    30.448
>
    79.566    30.538
    79.470    30.448
>
    79.416    30.250
    79.470    30.448
>
    79.416    30.250
    79.470    30.448
>
    79.176    30.488
    79.470    30.448
>
    79.176    30.488
    79.470    30.448
>
    79.376    30.145
    79.470    30.448
>
    79.376    30.145
    79.470    30.448
>
    79.141    30.588
    79.470    30.448
>
    79.141    30.588
    79.470    30.448
>
    79.019    30.389
    79.470    30.448
>
    79.019    30.389
    79.470    30.448
>
    79.288    30.051
    79.470    30.448
>
    79.288    30.051
    79.470    30.448
>
    79.563    30.001
    79.470    30.448
>
    79.563    30.001
    79.470    30.448
>
    79.673    29.887
    79.470    30.448
>
    79.673    29.887
    79.470    30.448
>
    79.595    29.852
    79.470    30.448
>
    79.595    29.852
    79.470    30.448
>
    79.900    29.946
    79.470    30.448
>
    79.210    29.820
    79.470    30.448
>
    79.210    29.820
    79.470    30.448
>
    78.918    29.916
    79.470    30.448
>
    78.918    29.916
    79.470    30.448
>
    78.640    30.431
    79.470    30.448
>
    78.640    30.431
    79.470    30.448
>
    78.649    30.579
    79.470    30.448
>
    78.649    30.579
    79.470    30.448
>
    79.015    29.750
    79.470    30.448
>
    79.176    30.488
    79.216    30.479
>
    79.176    30.488
    79.216    30.479
>
    79.141    30.588
    79.216    30.479
>
    79.141    30.588
    79.216    30.479
>
    79.019    30.389
    79.216    30.479
>
    79.019    30.389
    79.216    30.479
>
    79.416    30.250
    79.216    30.479
>
    79.416    30.250
    79.216    30.479
>
    79.566    30.538
    79.216    30.479
>
    79.566    30.538
    79.216    30.479
>
    79.376    30.145
    79.216    30.479
>
    79.376    30.145
    79.216    30.479
>
    79.288    30.051
    79.216    30.479
>
    79.288    30.051
    79.216    30.479
>
    79.049    30.019
    79.216    30.479
>
    78.768    30.155
    79.216    30.479
>
    78.640    30.431
    79.216    30.479
>
    78.640    30.431
    79.216    30.479
>
    78.768    30.155
    79.216    30.479
>
    78.649    30.579
    79.216    30.479
>
    78.649    30.579
    79.216    30.479
>
    79.563    30.001
    79.216    30.479
>
    79.563    30.001
    79.216    30.479
>
    78.918    29.916
    79.216    30.479
>
    78.918    29.916
    79.216    30.479
>
    78.605    30.144
    79.216    30.479
>
    78.605    30.144
    79.216    30.479
>
    79.210    29.820
    79.216    30.479
>
    79.210    29.820
    79.216    30.479
>
    78.429    30.373
    79.216    30.479
>
    78.429    30.373
    79.216    30.479
>
    78.753    31.036
    79.216    30.479
>
    78.753    31.036
    79.216    30.479
>
    79.595    29.852
    79.216    30.479
>
    79.595    29.852
    79.216    30.479
>
    78.711    29.924
    79.216    30.479
>
    78.711    29.924
    79.216    30.479
>
    79.673    29.887
    79.216    30.479
>
    79.673    29.887
    79.216    30.479
>
    78.436    30.721
    79.216    30.479
>
    78.436    30.721
    79.216    30.479
>
    79.015    29.750
    79.216    30.479
>
    79.015    29.750
    79.216    30.479
>
    78.330    30.574
    79.216    30.479
>
    78.330    30.574
    79.216    30.479
>
    78.680    29.839
    79.216    30.479
>
    78.680    29.839
    79.216    30.479
>
    79.900    29.946
    79.216    30.479
>
    79.900    29.946
    79.216    30.479
>
    79.176    30.488
    79.212    30.473
>
    79.176    30.488
    79.212    30.473
>
    79.141    30.588
    79.212    30.473
>
    79.141    30.588
    79.212    30.473
>
    79.019    30.389
    79.212    30.473
>
    79.019    30.389
    79.212    30.473
>
    79.416    30.250
    79.212    30.473
>
    79.416    30.250
    79.212    30.473
>
    79.566    30.538
    79.212    30.473
>
    79.566    30.538
    79.212    30.473
>
    79.376    30.145
    79.212    30.473
>
    79.288    30.051
    79.212    30.473
>
    79.049    30.019
    79.212    30.473
>
    79.049    30.019
    79.212    30.473
>
    78.640    30.431
    79.212    30.473
>
    78.640    30.431
    79.212    30.473
>
    78.768    30.155
    79.212    30.473
>
    79.563    30.001
    79.212    30.473
>
    78.918    29.916
    79.212    30.473
>
    78.918    29.916
    79.212    30.473
>
    78.605    30.144
    79.212    30.473
>
    78.605    30.144
    79.212    30.473
>
    79.210    29.820
    79.212    30.473
>
    79.210    29.820
    79.212    30.473
>
    78.429    30.373
    79.212    30.473
>
    78.711    29.924
    79.212    30.473
>
    79.595    29.852
    79.212    30.473
>
    79.595    29.852
    79.212    30.473
>
    79.673    29.887
    79.212    30.473
>
    79.673    29.887
    79.212    30.473
>
    78.436    30.721
    79.212    30.473
>
    79.015    29.750
    79.212    30.473
>
    79.015    29.750
    79.212    30.473
>
    78.330    30.574
    79.212    30.473
>
    79.900    29.946
    79.212    30.473
>
    78.436    30.721
    78.566    30.798
>
    78.436    30.721
    78.566    30.798
>
    78.649    30.579
    78.566    30.798
>
    78.649    30.579
    78.566    30.798
>
    78.377    30.921
    78.566    30.798
>
    78.377    30.921
    78.566    30.798
>
    78.753    31.036
    78.566    30.798
>
    78.753    31.036
    78.566    30.798
>
    78.330    30.574
    78.566    30.798
>
    78.330    30.574
    78.566    30.798
>
    78.205    30.808
    78.566    30.798
>
    78.205    30.808
    78.566    30.798
>
    78.640    30.431
    78.566    30.798
>
    78.640    30.431
    78.566    30.798
>
    78.103    30.909
    78.566    30.798
>
    78.103    30.909
    78.566    30.798
>
    78.429    30.373
    78.566    30.798
>
    78.429    30.373
    78.566    30.798
>
    78.244    30.427
    78.566    30.798
>
    78.244    30.427
    78.566    30.798
>
    79.141    30.588
    78.566    30.798
>
    79.141    30.588
    78.566    30.798
>
    78.074    30.455
    78.566    30.798
>
    79.019    30.389
    78.566    30.798
>
    78.074    30.455
    78.566    30.798
>
    79.019    30.389
    78.566    30.798
>
    77.873    30.691
    78.566    30.798
>
    77.873    30.691
    78.566    30.798
>
    78.605    30.144
    78.566    30.798
>
    78.605    30.144
    78.566    30.798
>
    77.845    30.934
    78.566    30.798
>
    77.845    30.934
    78.566    30.798
>
    79.176    30.488
    79.212    30.467
>
    79.176    30.488
    79.212    30.467
>
    79.141    30.588
    79.212    30.467
>
    79.141    30.588
    79.212    30.467
>
    79.019    30.389
    79.212    30.467
>
    79.019    30.389
    79.212    30.467
>
    79.416    30.250
    79.212    30.467
>
    79.416    30.250
    79.212    30.467
>
    79.288    30.051
    79.212    30.467
>
    79.288    30.051
    79.212    30.467
>
    78.640    30.431
    79.212    30.467
>
    78.640    30.431
    79.212    30.467
>
    79.563    30.001
    79.212    30.467
>
    79.563    30.001
    79.212    30.467
>
    78.605    30.144
    79.212    30.467
>
    78.605    30.144
    79.212    30.467
>
    79.210    29.820
    79.212    30.467
>
    79.210    29.820
    79.212    30.467
>
    79.673    29.887
    79.212    30.467
>
    79.673    29.887
    79.212    30.467
>
    78.436    30.721
    79.212    30.467
>
    78.436    30.721
    79.212    30.467
>
    78.680    29.839
    79.212    30.467
>
    78.680    29.839
    79.212    30.467
>
    79.141    30.588
    78.984    30.597
>
    79.141    30.588
    78.984    30.597
>
    79.176    30.488
    78.984    30.597
>
    79.176    30.488
    78.984    30.597
>
    79.019    30.389
    78.984    30.597
>
    78.649    30.579
    78.984    30.597
>
    78.649    30.579
    78.984    30.597
>
    78.640    30.431
    78.984    30.597
>
    78.640    30.431
    78.984    30.597
>
    78.640    30.431
    78.984    30.597
>
    78.436    30.721
    78.984    30.597
>
    78.436    30.721
    78.984    30.597
>
    78.330    30.574
    78.984    30.597
>
    78.330    30.574
    78.984    30.597
>
    78.918    29.916
    78.984    30.597
>
    78.918    29.916
    78.984    30.597
>
    79.176    30.488
    79.212    30.469
>
    79.176    30.488
    79.212    30.469
>
    79.141    30.588
    79.212    30.469
>
    79.141    30.588
    79.212    30.469
>
    79.019    30.389
    79.212    30.469
>
    79.019    30.389
    79.212    30.469
>
    78.975    30.639
    79.212    30.469
>
    78.975    30.639
    79.212    30.469
>
    79.566    30.538
    79.212    30.469
>
    79.566    30.538
    79.212    30.469
>
    79.376    30.145
    79.212    30.469
>
    79.376    30.145
    79.212    30.469
>
    79.288    30.051
    79.212    30.469
>
    79.288    30.051
    79.212    30.469
>
    78.768    30.155
    79.212    30.469
>
    78.768    30.155
    79.212    30.469
>
    78.649    30.579
    79.212    30.469
>
    78.649    30.579
    79.212    30.469
>
    78.918    29.916
    79.212    30.469
>
    78.918    29.916
    79.212    30.469
>
    79.210    29.820
    79.212    30.469
>
    79.210    29.820
    79.212    30.469
>
    78.429    30.373
    79.212    30.469
>
    78.429    30.373
    79.212    30.469
>
    78.711    29.924
    79.212    30.469
>
    78.711    29.924
    79.212    30.469
>
    79.595    29.852
    79.212    30.469
>
    79.595    29.852
    79.212    30.469
>
    78.436    30.721
    79.212    30.469
>
    78.436    30.721
    79.212    30.469
>
    78.378    30.508
    79.212    30.469
>
    78.378    30.508
    79.212    30.469
>
    79.015    29.750
    79.212    30.469
>
    78.330    30.574
    79.212    30.469
>
    78.330    30.574
    79.212    30.469
>
    78.680    29.839
    79.212    30.469
>
    78.680    29.839
    79.212    30.469
>
    79.900    29.946
    79.212    30.469
>
    79.900    29.946
    79.212    30.469
>
    79.930    29.407
    79.956    30.132
>
    79.930    29.407
    79.956    30.132
>
    79.900    29.946
    79.956    30.132
>
    79.900    29.946
    79.956    30.132
>
    80.238    30.066
    79.956    30.132
>
    80.238    30.066
    79.956    30.132
>
    80.164    29.905
    79.956    30.132
>
    80.164    29.905
    79.956    30.132
>
    79.595    29.852
    79.956    30.132
>
    79.595    29.852
    79.956    30.132
>
    80.248    29.803
    79.956    30.132
>
    80.248    29.803
    79.956    30.132
>
    79.566    30.538
    79.956    30.132
>
    79.566    30.538
    79.956    30.132
>
    79.288    30.051
    79.956    30.132
>
    79.210    29.820
    79.956    30.132
>
    79.210    29.820
    79.956    30.132
>
    80.094    29.403
    79.956    30.132
>
    80.094    29.403
    79.956    30.132
>
    79.176    30.488
    79.956    30.132
>
    79.176    30.488
    79.153    30.487
>
    79.176    30.488
    79.153    30.487
>
    79.141    30.588
    79.153    30.487
>
    79.141    30.588
    79.153    30.487
>
    79.019    30.389
    79.153    30.487
>
    79.019    30.389
    79.153    30.487
>
    78.975    30.639
    79.153    30.487
>
    78.975    30.639
    79.153    30.487
>
    78.649    30.579
    79.153    30.487
>
    78.768    30.155
    79.153    30.487
>
    78.768    30.155
    79.153    30.487
>
    78.605    30.144
    79.153    30.487
>
    78.605    30.144
    79.153    30.487
>
    78.918    29.916
    79.153    30.487
>
    78.918    29.916
    79.153    30.487
>
    78.429    30.373
    79.153    30.487
>
    78.429    30.373
    79.153    30.487
>
    79.210    29.820
    79.153    30.487
>
    79.210    29.820
    79.153    30.487
>
    78.711    29.924
    79.153    30.487
>
    79.595    29.852
    79.153    30.487
>
    79.595    29.852
    79.153    30.487
>
    79.015    29.750
    79.153    30.487
>
    79.015    29.750
    79.153    30.487
>
    78.244    30.427
    79.153    30.487
>
    78.244    30.427
    79.153    30.487
>
    78.975    30.639
    78.845    30.624
>
    78.975    30.639
    78.845    30.624
>
    78.649    30.579
    78.845    30.624
>
    78.649    30.579
    78.845    30.624
>
    79.141    30.588
    78.845    30.624
>
    79.141    30.588
    78.845    30.624
>
    79.019    30.389
    78.845    30.624
>
    79.019    30.389
    78.845    30.624
>
    79.176    30.488
    78.845    30.624
>
    79.176    30.488
    78.845    30.624
>
    78.436    30.721
    78.845    30.624
>
    78.436    30.721
    78.845    30.624
>
    78.378    30.508
    78.845    30.624
>
    78.378    30.508
    78.845    30.624
>
    78.753    31.036
    78.845    30.624
>
    78.753    31.036
    78.845    30.624
>
    78.429    30.373
    78.845    30.624
>
    78.429    30.373
    78.845    30.624
>
    78.330    30.574
    78.845    30.624
>
    78.330    30.574
    78.845    30.624
>
    78.768    30.155
    78.845    30.624
>
    78.768    30.155
    78.845    30.624
>
    78.605    30.144
    78.845    30.624
>
    78.605    30.144
    78.845    30.624
>
    78.377    30.921
    78.845    30.624
>
    78.377    30.921
    78.845    30.624
>
    78.244    30.427
    78.845    30.624
>
    78.244    30.427
    78.845    30.624
>
    78.205    30.808
    78.845    30.624
>
    78.205    30.808
    78.845    30.624
>
    79.566    30.538
    78.845    30.624
>
    79.376    30.145
    78.845    30.624
>
    79.376    30.145
    78.845    30.624
>
    78.287    30.161
    78.845    30.624
>
    78.287    30.161
    78.845    30.624
>
    79.288    30.051
    78.845    30.624
>
    79.288    30.051
    78.845    30.624
>
    78.074    30.455
    78.845    30.624
>
    78.074    30.455
    78.845    30.624
>
    78.918    29.916
    78.845    30.624
>
    78.918    29.916
    78.845    30.624
>
    78.711    29.924
    78.845    30.624
>
    78.711    29.924
    78.845    30.624
>
    78.680    29.839
    78.845    30.624
>
    78.680    29.839
    78.845    30.624
>
    78.446    30.730
    78.845    30.624
>
    78.446    30.730
    78.845    30.624
>
    78.056    30.323
    78.845    30.624
>
    78.056    30.323
    78.845    30.624
>
    79.176    30.488
    79.306    30.571
>
    79.176    30.488
    79.306    30.571
>
    79.141    30.588
    79.306    30.571
>
    79.141    30.588
    79.306    30.571
>
    79.566    30.538
    79.306    30.571
>
    79.566    30.538
    79.306    30.571
>
    78.975    30.639
    79.306    30.571
>
    78.975    30.639
    79.306    30.571
>
    79.019    30.389
    79.306    30.571
>
    79.019    30.389
    79.306    30.571
>
    78.768    30.155
    79.306    30.571
>
    78.768    30.155
    79.306    30.571
>
    78.918    29.916
    79.306    30.571
>
    78.918    29.916
    79.306    30.571
>
    79.210    29.820
    79.306    30.571
>
    79.210    29.820
    79.306    30.571
>
    78.429    30.373
    79.306    30.571
>
    78.429    30.373
    79.306    30.571
>
    79.176    30.488
    79.185    30.471
>
    79.176    30.488
    79.185    30.471
>
    79.141    30.588
    79.185    30.471
>
    79.141    30.588
    79.185    30.471
>
    79.019    30.389
    79.185    30.471
>
    79.019    30.389
    79.185    30.471
>
    78.975    30.639
    79.185    30.471
>
    78.975    30.639
    79.185    30.471
>
    79.288    30.051
    79.185    30.471
>
    79.288    30.051
    79.185    30.471
>
    78.768    30.155
    79.185    30.471
>
    78.768    30.155
    79.185    30.471
>
    78.918    29.916
    79.185    30.471
>
    78.918    29.916
    79.185    30.471
>
    79.210    29.820
    79.185    30.471
>
    79.210    29.820
    79.185    30.471
>
    78.711    29.924
    79.185    30.471
>
    78.711    29.924
    79.185    30.471
>
    78.436    30.721
    79.185    30.471
>
    79.595    29.852
    79.185    30.471
>
    79.595    29.852
    79.185    30.471
>
    78.378    30.508
    79.185    30.471
>
    78.378    30.508
    79.185    30.471
>
    78.918    29.916
    78.889    30.028
>
    78.918    29.916
    78.889    30.028
>
    78.768    30.155
    78.889    30.028
>
    78.768    30.155
    78.889    30.028
>
    78.711    29.924
    78.889    30.028
>
    78.711    29.924
    78.889    30.028
>
    78.680    29.839
    78.889    30.028
>
    78.680    29.839
    78.889    30.028
>
    78.605    30.144
    78.889    30.028
>
    78.605    30.144
    78.889    30.028
>
    79.288    30.051
    78.889    30.028
>
    79.288    30.051
    78.889    30.028
>
    79.210    29.820
    78.889    30.028
>
    79.210    29.820
    78.889    30.028
>
    79.019    30.389
    78.889    30.028
>
    79.019    30.389
    78.889    30.028
>
    79.376    30.145
    78.889    30.028
>
    78.429    30.373
    78.889    30.028
>
    78.287    30.161
    78.889    30.028
>
    78.649    30.579
    78.889    30.028
>
    78.649    30.579
    78.889    30.028
>
    79.141    30.588
    78.889    30.028
>
    79.141    30.588
    78.889    30.028
>
    78.975    30.639
    78.889    30.028
>
    79.595    29.852
    78.889    30.028
>
    79.595    29.852
    78.889    30.028
>
    78.378    30.508
    78.889    30.028
>
    78.378    30.508
    78.889    30.028
>
    78.330    30.574
    78.889    30.028
>
    78.330    30.574
    78.889    30.028
>
    78.436    30.721
    78.889    30.028
>
    78.436    30.721
    78.889    30.028
>
    79.900    29.946
    79.855    30.074
>
    79.900    29.946
    79.855    30.074
>
    79.595    29.852
    79.855    30.074
>
    79.595    29.852
    79.855    30.074
>
    80.164    29.905
    79.855    30.074
>
    80.164    29.905
    79.855    30.074
>
    80.238    30.066
    79.855    30.074
>
    80.238    30.066
    79.855    30.074
>
    79.376    30.145
    79.855    30.074
>
    79.376    30.145
    79.855    30.074
>
    79.288    30.051
    79.855    30.074
>
    79.288    30.051
    79.855    30.074
>
    79.566    30.538
    79.855    30.074
>
    79.566    30.538
    79.855    30.074
>
    79.648    29.592
    79.855    30.074
>
    79.648    29.592
    79.855    30.074
>
    79.210    29.820
    79.855    30.074
>
    79.210    29.820
    79.855    30.074
>
    80.234    29.552
    79.855    30.074
>
    80.234    29.552
    79.855    30.074
>
    80.094    29.403
    79.855    30.074
>
    79.457    29.359
    79.855    30.074
>
    79.457    29.359
    79.855    30.074
>
    79.019    30.389
    79.855    30.074
>
    79.019    30.389
    79.855    30.074
>
    80.107    29.330
    79.855    30.074
>
    80.107    29.330
    79.855    30.074
>
    80.217    29.550
    79.855    30.074
>
    80.217    29.550
    79.855    30.074
>
    78.649    30.579
    78.785    30.663
>
    78.649    30.579
    78.785    30.663
>
    78.975    30.639
    78.785    30.663
>
    78.975    30.639
    78.785    30.663
>
    79.063    30.546
    78.785    30.663
>
    79.063    30.546
    78.785    30.663
>
    79.141    30.588
    78.785    30.663
>
    79.141    30.588
    78.785    30.663
>
    79.019    30.389
    78.785    30.663
>
    79.019    30.389
    78.785    30.663
>
    78.436    30.721
    78.785    30.663
>
    78.436    30.721
    78.785    30.663
>
    79.176    30.488
    78.785    30.663
>
    79.176    30.488
    78.785    30.663
>
    78.378    30.508
    78.785    30.663
>
    78.378    30.508
    78.785    30.663
>
    78.753    31.036
    78.785    30.663
>
    78.753    31.036
    78.785    30.663
>
    78.429    30.373
    78.785    30.663
>
    78.429    30.373
    78.785    30.663
>
    78.377    30.921
    78.785    30.663
>
    78.768    30.155
    78.785    30.663
>
    78.768    30.155
    78.785    30.663
>
    79.322    30.406
    78.785    30.663
>
    79.322    30.406
    78.785    30.663
>
    79.217    30.265
    78.785    30.663
>
    79.217    30.265
    78.785    30.663
>
    78.244    30.427
    78.785    30.663
>
    78.244    30.427
    78.785    30.663
>
    78.605    30.144
    78.785    30.663
>
    78.605    30.144
    78.785    30.663
>
    78.205    30.808
    78.785    30.663
>
    78.205    30.808
    78.785    30.663
>
    78.074    30.455
    78.785    30.663
>
    78.074    30.455
    78.785    30.663
>
    78.103    30.909
    78.785    30.663
>
    78.287    30.161
    78.785    30.663
>
    78.287    30.161
    78.785    30.663
>
    79.049    30.019
    78.785    30.663
>
    79.049    30.019
    78.785    30.663
>
    79.566    30.538
    78.785    30.663
>
    79.416    30.250
    78.785    30.663
>
    79.416    30.250
    78.785    30.663
>
    79.376    30.145
    78.785    30.663
>
    78.711    29.924
    78.785    30.663
>
    78.711    29.924
    78.785    30.663
>
    79.288    30.051
    78.785    30.663
>
    79.288    30.051
    78.785    30.663
>
    78.918    29.916
    78.785    30.663
>
    78.918    29.916
    78.785    30.663
>
    77.873    30.691
    78.785    30.663
>
    77.873    30.691
    78.785    30.663
>
    78.446    30.730
    78.785    30.663
>
    78.446    30.730
    78.785    30.663
>
    79.558    30.556
    78.785    30.663
>
    79.558    30.556
    78.785    30.663
>
    78.056    30.323
    78.785    30.663
>
    78.649    30.579
    78.783    30.667
>
    78.649    30.579
    78.783    30.667
>
    78.975    30.639
    78.783    30.667
>
    78.975    30.639
    78.783    30.667
>
    79.063    30.546
    78.783    30.667
>
    79.063    30.546
    78.783    30.667
>
    79.141    30.588
    78.783    30.667
>
    79.141    30.588
    78.783    30.667
>
    78.436    30.721
    78.783    30.667
>
    78.436    30.721
    78.783    30.667
>
    79.019    30.389
    78.783    30.667
>
    79.019    30.389
    78.783    30.667
>
    79.176    30.488
    78.783    30.667
>
    79.176    30.488
    78.783    30.667
>
    78.378    30.508
    78.783    30.667
>
    78.378    30.508
    78.783    30.667
>
    78.753    31.036
    78.783    30.667
>
    78.753    31.036
    78.783    30.667
>
    78.429    30.373
    78.783    30.667
>
    78.429    30.373
    78.783    30.667
>
    78.377    30.921
    78.783    30.667
>
    78.768    30.155
    78.783    30.667
>
    78.768    30.155
    78.783    30.667
>
    79.322    30.406
    78.783    30.667
>
    78.244    30.427
    78.783    30.667
>
    78.244    30.427
    78.783    30.667
>
    79.217    30.265
    78.783    30.667
>
    79.217    30.265
    78.783    30.667
>
    78.605    30.144
    78.783    30.667
>
    78.205    30.808
    78.783    30.667
>
    78.205    30.808
    78.783    30.667
>
    78.103    30.909
    78.783    30.667
>
    78.074    30.455
    78.783    30.667
>
    78.074    30.455
    78.783    30.667
>
    78.287    30.161
    78.783    30.667
>
    78.287    30.161
    78.783    30.667
>
    79.049    30.019
    78.783    30.667
>
    79.049    30.019
    78.783    30.667
>
    79.566    30.538
    78.783    30.667
>
    79.416    30.250
    78.783    30.667
>
    79.416    30.250
    78.783    30.667
>
    79.376    30.145
    78.783    30.667
>
    78.711    29.924
    78.783    30.667
>
    78.711    29.924
    78.783    30.667
>
    79.288    30.051
    78.783    30.667
>
    79.288    30.051
    78.783    30.667
>
    78.918    29.916
    78.783    30.667
>
    78.918    29.916
    78.783    30.667
>
    77.873    30.691
    78.783    30.667
>
    77.873    30.691
    78.783    30.667
>
    79.558    30.556
    78.783    30.667
>
    79.558    30.556
    78.783    30.667
>
    80.164    29.905
    80.200    29.973
>
    80.164    29.905
    80.200    29.973
>
    80.238    30.066
    80.200    29.973
>
    80.238    30.066
    80.200    29.973
>
    80.049    29.775
    80.200    29.973
>
    80.049    29.775
    80.200    29.973
>
    79.900    29.946
    80.200    29.973
>
    79.900    29.946
    80.200    29.973
>
    80.234    29.552
    80.200    29.973
>
    80.234    29.552
    80.200    29.973
>
    79.673    29.887
    80.200    29.973
>
    79.673    29.887
    80.200    29.973
>
    79.595    29.852
    80.200    29.973
>
    79.595    29.852
    80.200    29.973
>
    79.563    30.001
    80.200    29.973
>
    79.563    30.001
    80.200    29.973
>
    80.094    29.403
    80.200    29.973
>
    80.094    29.403
    80.200    29.973
>
    79.648    29.592
    80.200    29.973
>
    79.648    29.592
    80.200    29.973
>
    79.930    29.407
    80.200    29.973
>
    79.930    29.407
    80.200    29.973
>
    80.107    29.330
    80.200    29.973
>
    80.107    29.330
    80.200    29.973
>
    79.416    30.250
    80.200    29.973
>
    79.413    29.611
    80.200    29.973
>
    79.288    30.051
    80.200    29.973
>
    79.288    30.051
    80.200    29.973
>
    80.217    29.550
    80.200    29.973
>
    80.217    29.550
    80.200    29.973
>
    80.544    29.849
    80.483    29.861
>
    80.544    29.849
    80.483    29.861
>
    80.164    29.905
    80.483    29.861
>
    80.164    29.905
    80.483    29.861
>
    80.238    30.066
    80.483    29.861
>
    80.238    30.066
    80.483    29.861
>
    80.049    29.775
    80.483    29.861
>
    80.049    29.775
    80.483    29.861
>
    80.234    29.552
    80.483    29.861
>
    80.234    29.552
    80.483    29.861
>
    79.900    29.946
    80.483    29.861
>
    79.900    29.946
    80.483    29.861
>
    80.094    29.403
    80.483    29.861
>
    80.094    29.403
    80.483    29.861
>
    80.107    29.330
    80.483    29.861
>
    80.107    29.330
    80.483    29.861
>
    79.930    29.407
    80.483    29.861
>
    79.930    29.407
    80.483    29.861
>
    79.595    29.852
    80.483    29.861
>
    79.595    29.852
    80.483    29.861
>
    79.648    29.592
    80.483    29.861
>
    79.648    29.592
    80.483    29.861
>
    79.176    30.488
    79.217    30.472
>
    79.176    30.488
    79.217    30.472
>
    79.322    30.406
    79.217    30.472
>
    79.322    30.406
    79.217    30.472
>
    79.141    30.588
    79.217    30.472
>
    79.141    30.588
    79.217    30.472
>
    79.019    30.389
    79.217    30.472
>
    79.019    30.389
    79.217    30.472
>
    79.217    30.265
    79.217    30.472
>
    79.217    30.265
    79.217    30.472
>
    78.975    30.639
    79.217    30.472
>
    78.975    30.639
    79.217    30.472
>
    79.416    30.250
    79.217    30.472
>
    79.416    30.250
    79.217    30.472
>
    79.566    30.538
    79.217    30.472
>
    79.566    30.538
    79.217    30.472
>
    79.376    30.145
    79.217    30.472
>
    79.376    30.145
    79.217    30.472
>
    79.049    30.019
    79.217    30.472
>
    79.049    30.019
    79.217    30.472
>
    78.768    30.155
    79.217    30.472
>
    78.768    30.155
    79.217    30.472
>
    78.649    30.579
    79.217    30.472
>
    78.649    30.579
    79.217    30.472
>
    78.918    29.916
    79.217    30.472
>
    78.918    29.916
    79.217    30.472
>
    78.605    30.144
    79.217    30.472
>
    78.605    30.144
    79.217    30.472
>
    79.210    29.820
    79.217    30.472
>
    79.210    29.820
    79.217    30.472
>
    78.429    30.373
    79.217    30.472
>
    78.429    30.373
    79.217    30.472
>
    79.595    29.852
    79.217    30.472
>
    79.595    29.852
    79.217    30.472
>
    78.711    29.924
    79.217    30.472
>
    78.711    29.924
    79.217    30.472
>
    79.673    29.887
    79.217    30.472
>
    79.015    29.750
    79.217    30.472
>
    79.015    29.750
    79.217    30.472
>
    78.680    29.839
    79.217    30.472
>
    78.680    29.839
    79.217    30.472
>
    79.217    30.265
    79.404    30.393
>
    79.217    30.265
    79.404    30.393
>
    79.566    30.538
    79.404    30.393
>
    79.566    30.538
    79.404    30.393
>
    79.176    30.488
    79.404    30.393
>
    79.176    30.488
    79.404    30.393
>
    79.376    30.145
    79.404    30.393
>
    79.376    30.145
    79.404    30.393
>
    79.141    30.588
    79.404    30.393
>
    79.141    30.588
    79.404    30.393
>
    79.019    30.389
    79.404    30.393
>
    79.019    30.389
    79.404    30.393
>
    79.288    30.051
    79.404    30.393
>
    79.288    30.051
    79.404    30.393
>
    79.563    30.001
    79.404    30.393
>
    79.563    30.001
    79.404    30.393
>
    78.975    30.639
    79.404    30.393
>
    78.975    30.639
    79.404    30.393
>
    79.015    29.750
    79.404    30.393
>
    79.015    29.750
    79.404    30.393
>
    80.217    29.550
    80.353    29.978
>
    78.446    30.730
    78.186    30.934
>
    78.446    30.730
    78.186    30.934
>
    80.246    29.450
    80.386    29.886
>
    80.246    29.450
    80.386    29.886
>
    78.446    30.730
    78.458    30.768
>
    78.446    30.730
    78.458    30.768
>
    80.246    29.450
    80.211    30.059
>
    80.246    29.450
    80.211    30.059
>
    79.354    29.888
    80.211    30.059
>
    79.354    29.888
    80.211    30.059
>
    79.558    30.556
    80.211    30.059
>
    79.558    30.556
    80.211    30.059
>
    80.246    29.450
    80.010    30.137
>
    80.246    29.450
    80.010    30.137
>
    78.056    30.323
    78.522    30.763
>
    78.056    30.323
    78.522    30.763
>
    80.246    29.450
    80.220    29.909
>
    80.217    29.550
    80.189    29.987
>
    80.217    29.550
    80.189    29.987
>
    80.246    29.450
    80.189    29.987
>
    79.558    30.556
    80.189    29.987
>
    79.558    30.556
    80.189    29.987
>
    79.558    30.556
    79.119    30.518
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
    78.056    30.323     0.300
    80.217    29.550     0.300
    79.217    30.262     0.300
    78.757    30.526     0.300
    79.321    30.407     0.300
    79.223    30.252     0.300
    79.090    30.510     0.300
    79.042    30.413     0.300
    79.427    30.437     0.300
    79.069    30.426     0.300
    79.319    30.418     0.300
    79.442    30.463     0.300
    79.317    30.383     0.300
    79.561    30.555     0.300
    79.247    30.247     0.300
    79.108    30.296     0.300
    79.320    30.410     0.300
    79.321    30.328     0.300
    78.621    30.305     0.300
    78.430    30.377     0.300
    78.432    30.304     0.300
    79.456    30.251     0.300
    79.263    30.465     0.300
    79.396    30.403     0.300
    78.998    30.631     0.300
    79.334    30.250     0.300
    79.123    30.549     0.300
    78.973    30.291     0.300
    79.416    30.250     0.300
    79.194    30.329     0.300
    78.980    30.284     0.300
    77.167    31.128     0.300
    76.970    31.500     0.300
    80.740    29.480     0.300
    81.200    29.470     0.300
    80.246    29.450     0.300
    79.558    30.556     0.300
    78.250    31.533     0.300
    79.208    30.152     0.300
    78.748    30.527     0.300
    79.003    30.621     0.300
    80.238    30.066     0.300
    80.164    29.905     0.300
    80.049    29.775     0.300
    79.673    29.887     0.300
    79.563    30.001     0.300
    79.648    29.592     0.300
    79.217    30.265     0.300
    80.094    29.403     0.300
    79.322    30.406     0.300
    79.595    29.852     0.300
    79.416    29.770     0.300
    79.019    30.389     0.300
    78.975    30.639     0.300
    80.544    29.849     0.300
    80.234    29.552     0.300
    79.930    29.407     0.300
    80.248    29.803     0.300
    80.107    29.330     0.300
    78.640    30.431     0.300
    79.457    29.359     0.300
    80.040    29.660     0.300
    79.566    30.538     0.300
    79.900    29.946     0.300
    79.376    30.145     0.300
    78.436    30.721     0.300
    78.377    30.921     0.300
    78.330    30.574     0.300
    78.378    30.508     0.300
    78.205    30.808     0.300
    78.429    30.373     0.300
    78.244    30.427     0.300
    78.103    30.909     0.300
    78.074    30.455     0.300
    78.287    30.161     0.300
    79.049    30.019     0.300
    78.711    29.924     0.300
    79.015    29.750     0.300
    77.873    30.691     0.300
    78.753    31.036     0.300
    77.845    30.934     0.300
    78.680    29.839     0.300
    77.843    30.518     0.300
    79.288    30.051     0.300
    79.547    29.355     0.300
    79.176    30.488     0.300
    79.141    30.588     0.300
    78.649    30.579     0.300
    78.768    30.155     0.300
    78.918    29.916     0.300
    79.210    29.820     0.300
    78.446    30.730     0.300
    78.605    30.144     0.300
    79.063    30.546     0.300
    79.413    29.611     0.300
    79.354    29.888     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
    79.317    30.383     0.250
    79.217    30.262     0.250
    79.321    30.328     0.250
    79.319    30.418     0.250
    79.247    30.247     0.250
    79.396    30.403     0.250
    79.334    30.250     0.250
    79.442    30.463     0.250
    79.223    30.252     0.250
    79.427    30.437     0.250
    79.673    29.887     0.250
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
    80.476    29.959     0.200
>
    80.883    29.762     0.200
>
    79.267    30.555     0.200
>
    79.957    30.145     0.200
>
    79.396    30.567     0.200
>
    80.332    30.028     0.200
>
    80.669    29.860     0.200
>
    80.560    29.905     0.200
>
    78.689    30.878     0.200
>
    80.118    29.978     0.200
>
    79.144    30.513     0.200
>
    78.034    31.092     0.200
>
    79.216    30.487     0.200
>
    79.177    30.482     0.200
>
    80.486    29.908     0.200
>
    79.192    30.547     0.200
>
    79.233    30.469     0.200
>
    79.741    30.088     0.200
>
    80.398    29.637     0.200
>
    78.784    30.755     0.200
>
    78.734    30.826     0.200
>
    78.717    30.794     0.200
>
    78.680    30.779     0.200
>
    78.829    30.708     0.200
>
    80.645    29.934     0.200
>
    79.117    30.659     0.200
>
    80.582    29.894     0.200
>
    79.503    30.251     0.200
>
    79.295    30.589     0.200
>
    79.278    30.585     0.200
>
    78.900    30.723     0.200
>
    79.362    30.461     0.200
>
    79.367    30.387     0.200
>
    79.355    30.406     0.200
>
    79.314    30.441     0.200
>
    79.387    30.388     0.200
>
    79.396    30.439     0.200
>
    79.382    30.386     0.200
>
    79.298    30.582     0.200
>
    79.350    30.398     0.200
>
    79.390    30.411     0.200
>
    79.465    30.450     0.200
>
    79.426    30.377     0.200
>
    79.280    30.327     0.200
>
    79.286    30.467     0.200
>
    79.341    30.407     0.200
>
    79.354    30.423     0.200
>
    79.425    30.431     0.200
>
    79.388    30.395     0.200
>
    79.438    30.461     0.200
>
    79.392    30.507     0.200
>
    79.433    30.409     0.200
>
    79.347    30.358     0.200
>
    79.375    30.422     0.200
>
    79.361    30.510     0.200
>
    79.418    30.477     0.200
>
    79.416    30.432     0.200
>
    79.379    30.428     0.200
>
    79.380    30.430     0.200
>
    79.372    30.428     0.200
>
    79.465    30.389     0.200
>
    79.408    30.423     0.200
>
    79.364    30.438     0.200
>
    79.414    30.421     0.200
>
    79.418    30.433     0.200
>
    79.355    30.448     0.200
>
    79.447    30.422     0.200
>
    79.360    30.422     0.200
>
    79.370    30.432     0.200
>
    79.405    30.425     0.200
>
    79.369    30.424     0.200
>
    79.239    30.487     0.200
>
    79.246    30.479     0.200
>
    79.313    30.544     0.200
>
    79.374    30.429     0.200
>
    79.244    30.478     0.200
>
    79.372    30.423     0.200
>
    79.360    30.451     0.200
>
    79.357    30.422     0.200
>
    79.241    30.465     0.200
>
    79.240    30.461     0.200
>
    79.363    30.450     0.200
>
    79.389    30.425     0.200
>
    79.230    30.502     0.200
>
    79.368    30.396     0.200
>
    79.387    30.436     0.200
>
    79.386    30.435     0.200
>
    79.397    30.359     0.200
>
    79.373    30.405     0.200
>
    79.394    30.420     0.200
>
    79.406    30.414     0.200
>
    79.380    30.409     0.200
>
    79.394    30.422     0.200
>
    79.352    30.430     0.200
>
    79.355    30.427     0.200
>
    79.378    30.428     0.200
>
    79.452    30.386     0.200
>
    79.379    30.419     0.200
>
    79.375    30.430     0.200
>
    79.391    30.420     0.200
>
    79.377    30.423     0.200
>
    79.327    30.440     0.200
>
    79.408    30.404     0.200
>
    79.387    30.420     0.200
>
    79.361    30.422     0.200
>
    79.444    30.432     0.200
>
    79.358    30.409     0.200
>
    79.371    30.422     0.200
>
    79.378    30.433     0.200
>
    79.381    30.424     0.200
>
    79.311    30.539     0.200
>
    79.351    30.452     0.200
>
    79.381    30.419     0.200
>
    79.373    30.424     0.200
>
    79.387    30.415     0.200
>
    79.348    30.434     0.200
>
    79.406    30.401     0.200
>
    79.329    30.415     0.200
>
    79.362    30.411     0.200
>
    79.387    30.431     0.200
>
    79.377    30.422     0.200
>
    79.476    30.461     0.200
>
    79.408    30.418     0.200
>
    79.497    30.455     0.200
>
    79.484    30.463     0.200
>
    79.382    30.520     0.200
>
    79.375    30.422     0.200
>
    79.373    30.424     0.200
>
    79.403    30.387     0.200
>
    79.277    30.473     0.200
>
    79.421    30.397     0.200
>
    79.352    30.432     0.200
>
    79.486    30.465     0.200
>
    79.307    30.438     0.200
>
    79.392    30.418     0.200
>
    79.372    30.422     0.200
>
    79.398    30.410     0.200
>
    79.399    30.380     0.200
>
    79.414    30.414     0.200
>
    79.354    30.406     0.200
>
    79.377    30.383     0.200
>
    79.387    30.421     0.200
>
    79.403    30.367     0.200
>
    79.369    30.423     0.200
>
    79.397    30.366     0.200
>
    79.348    30.431     0.200
>
    79.349    30.430     0.200
>
    79.404    30.392     0.200
>
    79.403    30.499     0.200
>
    79.367    30.401     0.200
>
    79.346    30.420     0.200
>
    79.331    30.422     0.200
>
    77.820    31.220     0.200
>
    79.981    30.047     0.200
>
    78.256    30.991     0.200
>
    79.511    30.431     0.200
>
    78.123    30.939     0.200
>
    78.128    31.096     0.200
>
    79.158    30.620     0.200
>
    80.566    29.897     0.200
>
    80.015    30.045     0.200
>
    78.244    30.912     0.200
>
    80.649    29.952     0.200
>
    80.053    30.080     0.200
>
    77.549    30.534     0.200
>
    79.317    30.577     0.200
>
    79.246    30.559     0.200
>
    80.403    30.302     0.200
>
    80.335    30.659     0.200
>
    79.113    30.610     0.200
>
    79.292    30.672     0.200
>
    80.358    30.301     0.200
>
    80.418    29.579     0.200
>
    80.717    29.714     0.200
>
    78.367    30.870     0.200
>
    78.505    30.890     0.200
>
    80.044    30.051     0.200
>
    79.229    30.500     0.200
>
    80.418    30.320     0.200
>
    80.434    30.323     0.200
>
    80.167    29.917     0.200
>
    80.605    29.874     0.200
>
    80.184    29.959     0.200
>
    78.159    30.995     0.200
>
    78.259    30.927     0.200
>
    78.121    30.965     0.200
>
    79.179    30.561     0.200
>
    79.982    30.014     0.200
>
    80.068    30.066     0.200
>
    80.334    30.232     0.200
>
    78.187    30.992     0.200
>
    80.515    29.844     0.200
>
    79.849    30.002     0.200
>
    80.434    29.899     0.200
>
    80.063    30.036     0.200
>
    78.334    30.336     0.200
>
    77.861    31.223     0.200
>
    80.427    29.856     0.200
>
    80.406    29.848     0.200
>
    80.434    29.846     0.200
>
    79.615    30.103     0.200
>
    79.134    30.547     0.200
>
    80.763    29.676     0.200
>
    80.397    30.297     0.200
>
    78.139    31.040     0.200
>
    79.315    30.558     0.200
>
    78.909    29.735     0.200
>
    78.272    30.972     0.200
>
    80.589    29.886     0.200
>
    78.391    30.897     0.200
>
    78.264    30.955     0.200
>
    78.894    30.670     0.200
>
    79.182    30.575     0.200
>
    79.997    30.254     0.200
>
    80.463    30.358     0.200
>
    79.480    30.382     0.200
>
    79.131    30.516     0.200
>
    79.909    30.095     0.200
>
    80.539    29.953     0.200
>
    78.087    30.979     0.200
>
    79.089    30.578     0.200
>
    79.140    30.612     0.200
>
    79.986    30.088     0.200
>
    79.551    30.236     0.200
>
    80.134    30.014     0.200
>
    80.132    30.019     0.200
>
    80.002    30.053     0.200
>
    80.374    29.658     0.200
>
    79.208    30.464     0.200
>
    79.388    30.448     0.200
>
    79.134    30.617     0.200
>
    78.990    30.588     0.200
>
    79.982    30.038     0.200
>
    80.392    29.972     0.200
>
    79.930    30.173     0.200
>
    79.126    30.564     0.200
>
    79.121    30.541     0.200
>
    79.795    30.047     0.200
>
    78.835    30.005     0.200
>
    79.872    30.154     0.200
>
    80.423    29.863     0.200
>
    80.174    30.041     0.200
>
    79.452    30.244     0.200
>
    79.865    30.137     0.200
>
    79.870    30.116     0.200
>
    79.868    30.107     0.200
>
    79.132    30.537     0.200
>
    80.200    29.869     0.200
>
    79.296    30.552     0.200
>
    79.563    30.297     0.200
>
    80.364    29.604     0.200
>
    79.974    30.003     0.200
>
    79.404    30.379     0.200
>
    79.831    30.177     0.200
>
    80.413    29.853     0.200
>
    78.772    30.792     0.200
>
    78.282    30.871     0.200
>
    79.260    30.582     0.200
>
    80.135    30.017     0.200
>
    78.642    30.753     0.200
>
    79.827    30.156     0.200
>
    79.191    30.511     0.200
>
    79.093    30.521     0.200
>
    78.699    30.380     0.200
>
    79.232    30.451     0.200
>
    79.210    30.448     0.200
>
    78.388    30.839     0.200
>
    79.194    30.446     0.200
>
    78.635    30.737     0.200
>
    79.190    30.443     0.200
>
    78.822    29.893     0.200
>
    77.974    30.534     0.200
>
    78.398    30.844     0.200
>
    78.530    30.061     0.200
>
    78.354    30.895     0.200
>
    78.635    30.711     0.200
>
    79.964    30.023     0.200
>
    78.374    30.870     0.200
>
    78.333    30.833     0.200
>
    78.999    30.669     0.200
>
    79.187    30.600     0.200
>
    80.209    29.816     0.200
>
    78.372    30.823     0.200
>
    79.332    30.557     0.200
>
    78.192    30.906     0.200
>
    80.281    30.024     0.200
>
    78.507    30.762     0.200
>
    78.625    30.765     0.200
>
    78.734    30.412     0.200
>
    80.244    29.985     0.200
>
    79.438    30.499     0.200
>
    78.260    30.887     0.200
>
    79.144    30.523     0.200
>
    78.356    30.465     0.200
>
    79.533    30.386     0.200
>
    79.530    30.400     0.200
>
    80.423    29.842     0.200
>
    79.141    30.587     0.200
>
    78.298    30.871     0.200
>
    80.375    29.901     0.200
>
    79.743    29.930     0.200
>
    79.720    29.962     0.200
>
    79.062    30.496     0.200
>
    79.281    30.591     0.200
>
    79.960    30.101     0.200
>
    80.230    29.978     0.200
>
    79.880    30.147     0.200
>
    80.093    29.989     0.200
>
    79.842    30.046     0.200
>
    78.494    30.755     0.200
>
    80.214    30.009     0.200
>
    78.482    30.768     0.200
>
    79.725    30.020     0.200
>
    80.075    30.034     0.200
>
    80.149    30.015     0.200
>
    78.314    30.283     0.200
>
    79.870    30.101     0.200
>
    78.272    30.891     0.200
>
    80.142    29.957     0.200
>
    79.593    30.198     0.200
>
    79.871    29.999     0.200
>
    79.424    30.330     0.200
>
    79.149    30.501     0.200
>
    78.136    30.922     0.200
>
    80.433    29.903     0.200
>
    79.768    29.977     0.200
>
    79.054    30.497     0.200
>
    79.892    30.107     0.200
>
    78.399    30.761     0.200
>
    80.422    29.870     0.200
>
    78.181    30.875     0.200
>
    80.392    29.880     0.200
>
    79.864    30.154     0.200
>
    79.143    30.553     0.200
>
    78.851    30.684     0.200
>
    78.655    30.724     0.200
>
    80.076    30.017     0.200
>
    79.186    30.482     0.200
>
    79.524    30.435     0.200
>
    80.047    29.988     0.200
>
    79.486    30.448     0.200
>
    79.952    30.094     0.200
>
    78.390    30.882     0.200
>
    79.421    30.516     0.200
>
    78.682    30.516     0.200
>
    80.045    30.145     0.200
>
    80.009    30.140     0.200
>
    79.511    30.349     0.200
>
    78.271    30.916     0.200
>
    79.950    30.019     0.200
>
    79.253    30.561     0.200
>
    80.244    30.006     0.200
>
    78.943    30.662     0.200
>
    80.199    30.008     0.200
>
    80.440    29.866     0.200
>
    79.553    30.441     0.200
>
    79.247    30.495     0.200
>
    79.554    30.461     0.200
>
    79.260    30.479     0.200
>
    79.249    30.477     0.200
>
    79.474    30.377     0.200
>
    79.249    30.487     0.200
>
    80.051    30.084     0.200
>
    80.047    29.992     0.200
>
    79.192    30.502     0.200
>
    79.199    30.494     0.200
>
    79.371    30.533     0.200
>
    79.385    30.543     0.200
>
    79.391    30.551     0.200
>
    79.246    30.473     0.200
>
    79.257    30.551     0.200
>
    78.858    30.618     0.200
>
    80.265    29.954     0.200
>
    78.634    30.545     0.200
>
    80.079    30.058     0.200
>
    79.008    30.535     0.200
>
    79.906    30.106     0.200
>
    79.987    29.992     0.200
>
    80.178    29.877     0.200
>
    79.863    30.002     0.200
>
    79.875    29.995     0.200
>
    79.869    29.999     0.200
>
    79.874    29.985     0.200
>
    80.136    29.967     0.200
>
    79.868    29.998     0.200
>
    79.875    29.992     0.200
>
    79.865    29.971     0.200
>
    79.877    29.993     0.200
>
    80.181    29.976     0.200
>
    79.885    29.987     0.200
>
    79.873    29.984     0.200
>
    80.205    30.018     0.200
>
    79.859    29.997     0.200
>
    79.871    29.988     0.200
>
    78.532    30.728     0.200
>
    79.385    30.335     0.200
>
    78.511    30.812     0.200
>
    79.201    30.496     0.200
>
    80.096    30.070     0.200
>
    79.871    30.001     0.200
>
    79.872    29.987     0.200
>
    79.864    30.004     0.200
>
    79.864    29.998     0.200
>
    79.876    30.008     0.200
>
    79.367    30.371     0.200
>
    79.875    29.994     0.200
>
    79.217    30.495     0.200
>
    78.614    30.205     0.200
>
    79.225    30.442     0.200
>
    79.216    30.445     0.200
>
    79.225    30.445     0.200
>
    78.668    30.216     0.200
>
    78.288    30.492     0.200
>
    78.503    30.065     0.200
>
    79.871    30.002     0.200
>
    78.604    30.625     0.200
>
    78.624    30.192     0.200
>
    78.703    30.667     0.200
>
    78.576    30.782     0.200
>
    78.507    30.775     0.200
>
    78.550    30.732     0.200
>
    78.268    30.198     0.200
>
    79.450    30.392     0.200
>
    79.864    29.993     0.200
>
    78.582    30.708     0.200
>
    78.857    30.700     0.200
>
    79.320    30.606     0.200
>
    79.319    30.541     0.200
>
    79.889    30.172     0.200
>
    78.543    30.713     0.200
>
    80.105    30.000     0.200
>
    77.837    30.798     0.200
>
    80.188    29.899     0.200
>
    79.975    30.050     0.200
>
    78.770    29.999     0.200
>
    78.361    30.851     0.200
>
    79.157    30.483     0.200
>
    78.842    30.619     0.200
>
    78.783    29.983     0.200
>
    79.599    30.227     0.200
>
    79.147    30.523     0.200
>
    79.099    30.524     0.200
>
    79.475    30.234     0.200
>
    78.844    29.819     0.200
>
    77.972    30.928     0.200
>
    79.204    30.514     0.200
>
    79.947    30.066     0.200
>
    77.924    30.724     0.200
>
    79.887    30.106     0.200
>
    78.949    29.887     0.200
>
    79.192    30.484     0.200
>
    79.801    30.007     0.200
>
    79.591    30.245     0.200
>
    79.855    30.147     0.200
>
    79.345    30.552     0.200
>
    79.554    30.246     0.200
>
    79.356    30.501     0.200
>
    79.538    30.252     0.200
>
    80.456    29.828     0.200
>
    77.937    30.632     0.200
>
    78.445    30.488     0.200
>
    78.125    30.983     0.200
>
    80.411    29.878     0.200
>
    80.424    29.885     0.200
>
    79.165    30.497     0.200
>
    80.150    29.812     0.200
>
    80.150    29.809     0.200
>
    79.899    30.169     0.200
>
    79.934    30.049     0.200
>
    78.318    30.811     0.200
>
    78.322    30.808     0.200
>
    78.420    30.830     0.200
>
    78.426    30.827     0.200
>
    78.556    30.707     0.200
>
    79.931    30.131     0.200
>
    79.433    30.363     0.200
>
    79.172    30.498     0.200
>
    79.300    30.681     0.200
>
    79.901    30.096     0.200
>
    79.901    30.096     0.200
>
    79.411    30.466     0.200
>
    78.493    30.788     0.200
>
    80.392    29.860     0.200
>
    80.082    29.956     0.200
>
    78.916    29.922     0.200
>
    79.198    30.479     0.200
>
    78.945    30.541     0.200
>
    79.472    30.342     0.200
>
    80.407    29.866     0.200
>
    78.901    30.589     0.200
>
    80.460    29.886     0.200
>
    80.467    29.891     0.200
>
    80.333    29.937     0.200
>
    79.170    30.477     0.200
>
    78.550    30.322     0.200
>
    79.215    30.484     0.200
>
    79.210    30.492     0.200
>
    79.562    30.264     0.200
>
    79.527    30.277     0.200
>
    79.376    30.534     0.200
>
    79.438    30.332     0.200
>
    79.422    30.487     0.200
>
    79.399    30.465     0.200
>
    79.411    30.483     0.200
>
    79.421    30.488     0.200
>
    80.035    30.057     0.200
>
    79.980    30.015     0.200
>
    80.476    29.904     0.200
>
    79.988    30.031     0.200
>
    79.251    29.644     0.200
>
    78.702    30.742     0.200
>
    79.973    30.026     0.200
>
    77.930    30.654     0.200
>
    78.119    30.940     0.200
>
    78.907    29.886     0.200
>
    78.831    30.655     0.200
>
    79.470    30.448     0.200
>
    79.216    30.479     0.200
>
    79.212    30.473     0.200
>
    78.566    30.798     0.200
>
    79.212    30.467     0.200
>
    78.984    30.597     0.200
>
    79.212    30.469     0.200
>
    79.956    30.132     0.200
>
    79.153    30.487     0.200
>
    78.845    30.624     0.200
>
    79.306    30.571     0.200
>
    79.185    30.471     0.200
>
    78.889    30.028     0.200
>
    79.855    30.074     0.200
>
    78.785    30.663     0.200
>
    78.783    30.667     0.200
>
    80.200    29.973     0.200
>
    80.483    29.861     0.200
>
    79.217    30.472     0.200
>
    79.404    30.393     0.200
>
    80.353    29.978     0.200
>
    78.186    30.934     0.200
>
    80.386    29.886     0.200
>
    78.458    30.768     0.200
>
    80.211    30.059     0.200
>
    80.010    30.137     0.200
>
    78.522    30.763     0.200
>
    80.220    29.909     0.200
>
    80.189    29.987     0.200
>
    79.119    30.518     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
    79.399    30.356     0.000   222.000   222.000
    79.399    30.356     0.000   444.000   444.000
EOF
gmt end
