#!/bin/bash
gmt begin chamoli16.22_base pdf,ps
proj=-JM16.0c+
reg=-R77.4/81.0/29.5/31.3
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map chamoli16.22'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    80.476    29.959 1
    80.883    29.762 2
    79.267    30.555 3
    79.957    30.145 4
    79.396    30.567 5
    80.332    30.028 6
    80.669    29.860 7
    80.560    29.905 8
    78.689    30.878 9
    80.118    29.978 10
    79.144    30.513 11
    78.034    31.092 12
    79.216    30.487 13
    79.177    30.482 14
    80.486    29.908 15
    79.192    30.547 16
    79.233    30.469 17
    79.741    30.088 18
    80.398    29.637 19
    78.784    30.755 20
    78.734    30.826 21
    78.717    30.794 22
    78.680    30.779 23
    78.829    30.708 24
    80.645    29.934 25
    79.117    30.659 26
    80.582    29.894 27
    79.503    30.251 28
    79.295    30.589 29
    79.278    30.585 30
    78.900    30.723 31
    79.362    30.461 32
    79.367    30.387 33
    79.355    30.406 34
    79.314    30.441 35
    79.387    30.388 36
    79.396    30.439 37
    79.382    30.386 38
    79.298    30.582 39
    79.350    30.398 40
    79.390    30.411 41
    79.465    30.450 42
    79.426    30.377 43
    79.280    30.327 44
    79.286    30.467 45
    79.341    30.407 46
    79.354    30.423 47
    79.425    30.431 48
    79.388    30.395 49
    79.438    30.461 50
    79.392    30.507 51
    79.433    30.409 52
    79.347    30.358 53
    79.375    30.422 54
    79.361    30.510 55
    79.418    30.477 56
    79.416    30.432 57
    79.379    30.428 58
    79.380    30.430 59
    79.372    30.428 60
    79.465    30.389 61
    79.408    30.423 62
    79.364    30.438 63
    79.414    30.421 64
    79.418    30.433 65
    79.355    30.448 66
    79.447    30.422 67
    79.360    30.422 68
    79.370    30.432 69
    79.405    30.425 70
    79.369    30.424 71
    79.239    30.487 72
    79.246    30.479 73
    79.313    30.544 74
    79.374    30.429 75
    79.244    30.478 76
    79.372    30.423 77
    79.360    30.451 78
    79.357    30.422 79
    79.241    30.465 80
    79.240    30.461 81
    79.363    30.450 82
    79.389    30.425 83
    79.230    30.502 84
    79.368    30.396 85
    79.387    30.436 86
    79.386    30.435 87
    79.397    30.359 88
    79.373    30.405 89
    79.394    30.420 90
    79.406    30.414 91
    79.380    30.409 92
    79.394    30.422 93
    79.352    30.430 94
    79.355    30.427 95
    79.378    30.428 96
    79.452    30.386 97
    79.379    30.419 98
    79.375    30.430 99
    79.391    30.420 100
    79.377    30.423 101
    79.327    30.440 102
    79.408    30.404 103
    79.387    30.420 104
    79.361    30.422 105
    79.444    30.432 106
    79.358    30.409 107
    79.371    30.422 108
    79.378    30.433 109
    79.381    30.424 110
    79.311    30.539 111
    79.351    30.452 112
    79.381    30.419 113
    79.373    30.424 114
    79.387    30.415 115
    79.348    30.434 116
    79.406    30.401 117
    79.329    30.415 118
    79.362    30.411 119
    79.387    30.431 120
    79.377    30.422 121
    79.476    30.461 122
    79.408    30.418 123
    79.497    30.455 124
    79.484    30.463 125
    79.382    30.520 126
    79.375    30.422 127
    79.373    30.424 128
    79.403    30.387 129
    79.277    30.473 130
    79.421    30.397 131
    79.352    30.432 132
    79.486    30.465 133
    79.307    30.438 134
    79.392    30.418 135
    79.372    30.422 136
    79.398    30.410 137
    79.399    30.380 138
    79.414    30.414 139
    79.354    30.406 140
    79.377    30.383 141
    79.387    30.421 142
    79.403    30.367 143
    79.369    30.423 144
    79.397    30.366 145
    79.348    30.431 146
    79.349    30.430 147
    79.404    30.392 148
    79.403    30.499 149
    79.367    30.401 150
    79.346    30.420 151
    79.331    30.422 152
    77.820    31.220 153
    79.981    30.047 154
    78.256    30.991 155
    79.511    30.431 156
    78.123    30.939 157
    78.128    31.096 158
    79.158    30.620 159
    80.566    29.897 160
    80.015    30.045 161
    78.244    30.912 162
    80.649    29.952 163
    80.053    30.080 164
    77.549    30.534 165
    79.317    30.577 166
    79.246    30.559 167
    80.403    30.302 168
    80.335    30.659 169
    79.113    30.610 170
    79.292    30.672 171
    80.358    30.301 172
    80.418    29.579 173
    80.717    29.714 174
    78.367    30.870 175
    78.505    30.890 176
    80.044    30.051 177
    79.229    30.500 178
    80.418    30.320 179
    80.434    30.323 180
    80.167    29.917 181
    80.605    29.874 182
    80.184    29.959 183
    78.159    30.995 184
    78.259    30.927 185
    78.121    30.965 186
    79.179    30.561 187
    79.982    30.014 188
    80.068    30.066 189
    80.334    30.232 190
    78.187    30.992 191
    80.515    29.844 192
    79.849    30.002 193
    80.434    29.899 194
    80.063    30.036 195
    78.334    30.336 196
    77.861    31.223 197
    80.427    29.856 198
    80.406    29.848 199
    80.434    29.846 200
    79.615    30.103 201
    79.134    30.547 202
    80.763    29.676 203
    80.397    30.297 204
    78.139    31.040 205
    79.315    30.558 206
    78.909    29.735 207
    78.272    30.972 208
    80.589    29.886 209
    78.391    30.897 210
    78.264    30.955 211
    78.894    30.670 212
    79.182    30.575 213
    79.997    30.254 214
    80.463    30.358 215
    79.480    30.382 216
    79.131    30.516 217
    79.909    30.095 218
    80.539    29.953 219
    78.087    30.979 220
    79.089    30.578 221
    79.140    30.612 222
    79.986    30.088 223
    79.551    30.236 224
    80.134    30.014 225
    80.132    30.019 226
    80.002    30.053 227
    80.374    29.658 228
    79.208    30.464 229
    79.388    30.448 230
    79.134    30.617 231
    78.990    30.588 232
    79.982    30.038 233
    80.392    29.972 234
    79.930    30.173 235
    79.126    30.564 236
    79.121    30.541 237
    79.795    30.047 238
    78.835    30.005 239
    79.872    30.154 240
    80.423    29.863 241
    80.174    30.041 242
    79.452    30.244 243
    79.865    30.137 244
    79.870    30.116 245
    79.868    30.107 246
    79.132    30.537 247
    80.200    29.869 248
    79.296    30.552 249
    79.563    30.297 250
    80.364    29.604 251
    79.974    30.003 252
    79.404    30.379 253
    79.831    30.177 254
    80.413    29.853 255
    78.772    30.792 256
    78.282    30.871 257
    79.260    30.582 258
    80.135    30.017 259
    78.642    30.753 260
    79.827    30.156 261
    79.191    30.511 262
    79.093    30.521 263
    78.699    30.380 264
    79.232    30.451 265
    79.210    30.448 266
    78.388    30.839 267
    79.194    30.446 268
    78.635    30.737 269
    79.190    30.443 270
    78.822    29.893 271
    77.974    30.534 272
    78.398    30.844 273
    78.530    30.061 274
    78.354    30.895 275
    78.635    30.711 276
    79.964    30.023 277
    78.374    30.870 278
    78.333    30.833 279
    78.999    30.669 280
    79.187    30.600 281
    80.209    29.816 282
    78.372    30.823 283
    79.332    30.557 284
    78.192    30.906 285
    80.281    30.024 286
    78.507    30.762 287
    78.625    30.765 288
    78.734    30.412 289
    80.244    29.985 290
    79.438    30.499 291
    78.260    30.887 292
    79.144    30.523 293
    78.356    30.465 294
    79.533    30.386 295
    79.530    30.400 296
    80.423    29.842 297
    79.141    30.587 298
    78.298    30.871 299
    80.375    29.901 300
    79.743    29.930 301
    79.720    29.962 302
    79.062    30.496 303
    79.281    30.591 304
    79.960    30.101 305
    80.230    29.978 306
    79.880    30.147 307
    80.093    29.989 308
    79.842    30.046 309
    78.494    30.755 310
    80.214    30.009 311
    78.482    30.768 312
    79.725    30.020 313
    80.075    30.034 314
    80.149    30.015 315
    78.314    30.283 316
    79.870    30.101 317
    78.272    30.891 318
    80.142    29.957 319
    79.593    30.198 320
    79.871    29.999 321
    79.424    30.330 322
    79.149    30.501 323
    78.136    30.922 324
    80.433    29.903 325
    79.768    29.977 326
    79.054    30.497 327
    79.892    30.107 328
    78.399    30.761 329
    80.422    29.870 330
    78.181    30.875 331
    80.392    29.880 332
    79.864    30.154 333
    79.143    30.553 334
    78.851    30.684 335
    78.655    30.724 336
    80.076    30.017 337
    79.186    30.482 338
    79.524    30.435 339
    80.047    29.988 340
    79.486    30.448 341
    79.952    30.094 342
    78.390    30.882 343
    79.421    30.516 344
    78.682    30.516 345
    80.045    30.145 346
    80.009    30.140 347
    79.511    30.349 348
    78.271    30.916 349
    79.950    30.019 350
    79.253    30.561 351
    80.244    30.006 352
    78.943    30.662 353
    80.199    30.008 354
    80.440    29.866 355
    79.553    30.441 356
    79.247    30.495 357
    79.554    30.461 358
    79.260    30.479 359
    79.249    30.477 360
    79.474    30.377 361
    79.249    30.487 362
    80.051    30.084 363
    80.047    29.992 364
    79.192    30.502 365
    79.199    30.494 366
    79.371    30.533 367
    79.385    30.543 368
    79.391    30.551 369
    79.246    30.473 370
    79.257    30.551 371
    78.858    30.618 372
    80.265    29.954 373
    78.634    30.545 374
    80.079    30.058 375
    79.008    30.535 376
    79.906    30.106 377
    79.987    29.992 378
    80.178    29.877 379
    79.863    30.002 380
    79.875    29.995 381
    79.869    29.999 382
    79.874    29.985 383
    80.136    29.967 384
    79.868    29.998 385
    79.875    29.992 386
    79.865    29.971 387
    79.877    29.993 388
    80.181    29.976 389
    79.885    29.987 390
    79.873    29.984 391
    80.205    30.018 392
    79.859    29.997 393
    79.871    29.988 394
    78.532    30.728 395
    79.385    30.335 396
    78.511    30.812 397
    79.201    30.496 398
    80.096    30.070 399
    79.871    30.001 400
    79.872    29.987 401
    79.864    30.004 402
    79.864    29.998 403
    79.876    30.008 404
    79.367    30.371 405
    79.875    29.994 406
    79.217    30.495 407
    78.614    30.205 408
    79.225    30.442 409
    79.216    30.445 410
    79.225    30.445 411
    78.668    30.216 412
    78.288    30.492 413
    78.503    30.065 414
    79.871    30.002 415
    78.604    30.625 416
    78.624    30.192 417
    78.703    30.667 418
    78.576    30.782 419
    78.507    30.775 420
    78.550    30.732 421
    78.268    30.198 422
    79.450    30.392 423
    79.864    29.993 424
    78.582    30.708 425
    78.857    30.700 426
    79.320    30.606 427
    79.319    30.541 428
    79.889    30.172 429
    78.543    30.713 430
    80.105    30.000 431
    77.837    30.798 432
    80.188    29.899 433
    79.975    30.050 434
    78.770    29.999 435
    78.361    30.851 436
    79.157    30.483 437
    78.842    30.619 438
    78.783    29.983 439
    79.599    30.227 440
    79.147    30.523 441
    79.099    30.524 442
    79.475    30.234 443
    78.844    29.819 444
    77.972    30.928 445
    79.204    30.514 446
    79.947    30.066 447
    77.924    30.724 448
    79.887    30.106 449
    78.949    29.887 450
    79.192    30.484 451
    79.801    30.007 452
    79.591    30.245 453
    79.855    30.147 454
    79.345    30.552 455
    79.554    30.246 456
    79.356    30.501 457
    79.538    30.252 458
    80.456    29.828 459
    77.937    30.632 460
    78.445    30.488 461
    78.125    30.983 462
    80.411    29.878 463
    80.424    29.885 464
    79.165    30.497 465
    80.150    29.812 466
    80.150    29.809 467
    79.899    30.169 468
    79.934    30.049 469
    78.318    30.811 470
    78.322    30.808 471
    78.420    30.830 472
    78.426    30.827 473
    78.556    30.707 474
    79.931    30.131 475
    79.433    30.363 476
    79.172    30.498 477
    79.300    30.681 478
    79.901    30.096 479
    79.901    30.096 480
    79.411    30.466 481
    78.493    30.788 482
    80.392    29.860 483
    80.082    29.956 484
    78.916    29.922 485
    79.198    30.479 486
    78.945    30.541 487
    79.472    30.342 488
    80.407    29.866 489
    78.901    30.589 490
    80.460    29.886 491
    80.467    29.891 492
    80.333    29.937 493
    79.170    30.477 494
    78.550    30.322 495
    79.215    30.484 496
    79.210    30.492 497
    79.562    30.264 498
    79.527    30.277 499
    79.376    30.534 500
    79.438    30.332 501
    79.422    30.487 502
    79.399    30.465 503
    79.411    30.483 504
    79.421    30.488 505
    80.035    30.057 506
    79.980    30.015 507
    80.476    29.904 508
    79.988    30.031 509
    79.251    29.644 510
    78.702    30.742 511
    79.973    30.026 512
    77.930    30.654 513
    78.119    30.940 514
    78.907    29.886 515
    78.831    30.655 516
    79.470    30.448 517
    79.216    30.479 518
    79.212    30.473 519
    78.566    30.798 520
    79.212    30.467 521
    78.984    30.597 522
    79.212    30.469 523
    79.956    30.132 524
    79.153    30.487 525
    78.845    30.624 526
    79.306    30.571 527
    79.185    30.471 528
    78.889    30.028 529
    79.855    30.074 530
    78.785    30.663 531
    78.783    30.667 532
    80.200    29.973 533
    80.483    29.861 534
    79.217    30.472 535
    79.404    30.393 536
    80.353    29.978 537
    78.186    30.934 538
    80.386    29.886 539
    78.458    30.768 540
    80.211    30.059 541
    80.010    30.137 542
    78.522    30.763 543
    80.220    29.909 544
    80.189    29.987 545
    79.119    30.518 546
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    80.452    29.855
    80.476    29.959
>
    80.849    29.543
    80.883    29.762
>
    79.279    30.369
    79.267    30.555
>
    79.880    29.938
    79.957    30.145
>
    79.362    30.438
    79.396    30.567
>
    80.332    29.963
    80.332    30.028
>
    80.591    29.972
    80.669    29.860
>
    80.565    29.871
    80.560    29.905
>
    78.586    30.432
    78.689    30.878
>
    80.229    29.626
    80.118    29.978
>
    79.142    30.286
    79.144    30.513
>
    78.024    31.063
    78.034    31.092
>
    79.158    30.424
    79.216    30.487
>
    79.153    30.315
    79.177    30.482
>
    80.447    29.707
    80.486    29.908
>
    79.189    30.451
    79.192    30.547
>
    79.180    30.307
    79.233    30.469
>
    79.824    30.143
    79.741    30.088
>
    80.356    29.695
    80.398    29.637
>
    78.791    30.756
    78.784    30.755
>
    78.702    30.702
    78.734    30.826
>
    78.655    30.708
    78.717    30.794
>
    78.739    30.654
    78.680    30.779
>
    78.938    30.495
    78.829    30.708
>
    80.519    29.685
    80.645    29.934
>
    79.139    30.457
    79.117    30.659
>
    80.612    29.817
    80.582    29.894
>
    79.620    30.092
    79.503    30.251
>
    79.230    30.377
    79.295    30.589
>
    79.230    30.413
    79.278    30.585
>
    78.791    30.516
    78.900    30.723
>
    79.335    30.364
    79.362    30.461
>
    79.305    30.318
    79.367    30.387
>
    79.350    30.322
    79.355    30.406
>
    79.338    30.370
    79.314    30.441
>
    79.531    30.386
    79.387    30.388
>
    79.339    30.405
    79.396    30.439
>
    79.406    30.403
    79.382    30.386
>
    79.268    30.472
    79.298    30.582
>
    79.143    30.489
    79.350    30.398
>
    79.356    30.226
    79.390    30.411
>
    79.301    30.365
    79.465    30.450
>
    79.450    30.250
    79.426    30.377
>
    79.348    30.320
    79.280    30.327
>
    79.367    30.295
    79.286    30.467
>
    79.423    30.395
    79.341    30.407
>
    79.359    30.346
    79.354    30.423
>
    79.587    30.392
    79.425    30.431
>
    79.444    30.333
    79.388    30.395
>
    79.375    30.360
    79.438    30.461
>
    79.411    30.370
    79.392    30.507
>
    79.446    30.366
    79.433    30.409
>
    79.382    30.424
    79.347    30.358
>
    79.387    30.396
    79.375    30.422
>
    79.320    30.506
    79.361    30.510
>
    79.180    30.391
    79.418    30.477
>
    79.388    30.323
    79.416    30.432
>
    79.368    30.394
    79.379    30.428
>
    79.339    30.405
    79.380    30.430
>
    79.358    30.397
    79.372    30.428
>
    79.459    30.332
    79.465    30.389
>
    79.395    30.405
    79.408    30.423
>
    79.392    30.384
    79.364    30.438
>
    79.421    30.382
    79.414    30.421
>
    79.356    30.438
    79.418    30.433
>
    79.322    30.402
    79.355    30.448
>
    79.494    30.320
    79.447    30.422
>
    79.367    30.377
    79.360    30.422
>
    79.340    30.427
    79.370    30.432
>
    79.375    30.390
    79.405    30.425
>
    79.355    30.388
    79.369    30.424
>
    79.198    30.468
    79.239    30.487
>
    79.216    30.493
    79.246    30.479
>
    79.275    30.550
    79.313    30.544
>
    79.342    30.403
    79.374    30.429
>
    79.236    30.455
    79.244    30.478
>
    79.311    30.432
    79.372    30.423
>
    79.352    30.446
    79.360    30.451
>
    79.328    30.416
    79.357    30.422
>
    79.246    30.449
    79.241    30.465
>
    79.232    30.475
    79.240    30.461
>
    79.318    30.451
    79.363    30.450
>
    79.332    30.429
    79.389    30.425
>
    79.206    30.483
    79.230    30.502
>
    79.291    30.375
    79.368    30.396
>
    79.363    30.426
    79.387    30.436
>
    79.364    30.435
    79.386    30.435
>
    79.404    30.328
    79.397    30.359
>
    79.354    30.401
    79.373    30.405
>
    79.340    30.417
    79.394    30.420
>
    79.366    30.382
    79.406    30.414
>
    79.334    30.411
    79.380    30.409
>
    79.353    30.416
    79.394    30.422
>
    79.321    30.431
    79.352    30.430
>
    79.321    30.417
    79.355    30.427
>
    79.352    30.426
    79.378    30.428
>
    79.460    30.339
    79.452    30.386
>
    79.413    30.367
    79.379    30.419
>
    79.348    30.426
    79.375    30.430
>
    79.347    30.447
    79.391    30.420
>
    79.346    30.423
    79.377    30.423
>
    79.302    30.425
    79.327    30.440
>
    79.364    30.402
    79.408    30.404
>
    79.346    30.435
    79.387    30.420
>
    79.345    30.418
    79.361    30.422
>
    79.398    30.429
    79.444    30.432
>
    79.303    30.410
    79.358    30.409
>
    79.331    30.419
    79.371    30.422
>
    79.330    30.428
    79.378    30.433
>
    79.348    30.433
    79.381    30.424
>
    79.285    30.513
    79.311    30.539
>
    79.316    30.452
    79.351    30.452
>
    79.424    30.326
    79.381    30.419
>
    79.351    30.420
    79.373    30.424
>
    79.371    30.417
    79.387    30.415
>
    79.313    30.449
    79.348    30.434
>
    79.393    30.378
    79.406    30.401
>
    79.304    30.422
    79.329    30.415
>
    79.349    30.402
    79.362    30.411
>
    79.369    30.436
    79.387    30.431
>
    79.347    30.418
    79.377    30.422
>
    79.431    30.453
    79.476    30.461
>
    79.373    30.441
    79.408    30.418
>
    79.439    30.466
    79.497    30.455
>
    79.413    30.451
    79.484    30.463
>
    79.356    30.533
    79.382    30.520
>
    79.351    30.415
    79.375    30.422
>
    79.344    30.423
    79.373    30.424
>
    79.373    30.385
    79.403    30.387
>
    79.259    30.458
    79.277    30.473
>
    79.396    30.402
    79.421    30.397
>
    79.347    30.412
    79.352    30.432
>
    79.437    30.455
    79.486    30.465
>
    79.283    30.444
    79.307    30.438
>
    79.410    30.388
    79.392    30.418
>
    79.356    30.417
    79.372    30.422
>
    79.402    30.403
    79.398    30.410
>
    79.407    30.325
    79.399    30.380
>
    79.396    30.428
    79.414    30.414
>
    79.337    30.406
    79.354    30.406
>
    79.342    30.386
    79.377    30.383
>
    79.372    30.424
    79.387    30.421
>
    79.357    30.374
    79.403    30.367
>
    79.341    30.423
    79.369    30.423
>
    79.372    30.368
    79.397    30.366
>
    79.324    30.396
    79.348    30.431
>
    79.318    30.423
    79.349    30.430
>
    79.357    30.397
    79.404    30.392
>
    79.351    30.490
    79.403    30.499
>
    79.313    30.404
    79.367    30.401
>
    79.334    30.418
    79.346    30.420
>
    79.363    30.363
    79.331    30.422
>
    77.841    31.034
    77.820    31.220
>
    79.981    29.944
    79.981    30.047
>
    78.258    30.832
    78.256    30.991
>
    79.529    30.336
    79.511    30.431
>
    78.196    30.966
    78.123    30.939
>
    78.208    31.085
    78.128    31.096
>
    79.133    30.460
    79.158    30.620
>
    80.601    29.766
    80.566    29.897
>
    80.027    29.911
    80.015    30.045
>
    78.186    30.826
    78.244    30.912
>
    80.679    29.721
    80.649    29.952
>
    80.026    30.046
    80.053    30.080
>
    77.625    30.522
    77.549    30.534
>
    79.311    30.468
    79.317    30.577
>
    79.324    30.562
    79.246    30.559
>
    80.388    30.240
    80.403    30.302
>
    80.295    30.599
    80.335    30.659
>
    79.262    30.649
    79.113    30.610
>
    79.643    30.810
    79.292    30.672
>
    80.332    30.285
    80.358    30.301
>
    80.437    29.369
    80.418    29.579
>
    80.649    29.575
    80.717    29.714
>
    78.446    30.814
    78.367    30.870
>
    78.471    30.834
    78.505    30.890
>
    80.052    29.931
    80.044    30.051
>
    79.237    30.513
    79.229    30.500
>
    80.361    30.331
    80.418    30.320
>
    80.387    30.222
    80.434    30.323
>
    80.148    29.780
    80.167    29.917
>
    80.542    29.774
    80.605    29.874
>
    80.116    29.912
    80.184    29.959
>
    78.058    30.985
    78.159    30.995
>
    78.284    30.858
    78.259    30.927
>
    78.173    30.958
    78.121    30.965
>
    79.365    30.622
    79.179    30.561
>
    79.990    29.945
    79.982    30.014
>
    80.056    29.981
    80.068    30.066
>
    80.333    30.264
    80.334    30.232
>
    78.259    30.951
    78.187    30.992
>
    80.383    29.756
    80.515    29.844
>
    79.801    29.948
    79.849    30.002
>
    80.469    29.807
    80.434    29.899
>
    80.085    30.011
    80.063    30.036
>
    78.246    30.305
    78.334    30.336
>
    77.857    31.230
    77.861    31.223
>
    80.466    29.877
    80.427    29.856
>
    80.397    29.845
    80.406    29.848
>
    80.428    29.790
    80.434    29.846
>
    79.615    30.009
    79.615    30.103
>
    79.177    30.543
    79.134    30.547
>
    80.729    29.626
    80.763    29.676
>
    80.415    30.216
    80.397    30.297
>
    78.223    31.088
    78.139    31.040
>
    79.319    30.551
    79.315    30.558
>
    78.907    29.717
    78.909    29.735
>
    78.298    30.944
    78.272    30.972
>
    80.599    29.852
    80.589    29.886
>
    78.396    30.896
    78.391    30.897
>
    78.325    30.999
    78.264    30.955
>
    78.939    30.704
    78.894    30.670
>
    79.279    30.444
    79.182    30.575
>
    79.990    30.208
    79.997    30.254
>
    80.524    30.173
    80.463    30.358
>
    79.482    30.375
    79.480    30.382
>
    79.151    30.407
    79.131    30.516
>
    80.093    30.093
    79.909    30.095
>
    80.545    29.936
    80.539    29.953
>
    78.139    30.859
    78.087    30.979
>
    79.079    30.577
    79.089    30.578
>
    79.113    30.569
    79.140    30.612
>
    79.982    30.089
    79.986    30.088
>
    79.544    30.231
    79.551    30.236
>
    80.126    30.016
    80.134    30.014
>
    80.130    30.021
    80.132    30.019
>
    79.999    30.051
    80.002    30.053
>
    80.371    29.659
    80.374    29.658
>
    79.207    30.455
    79.208    30.464
>
    79.375    30.434
    79.388    30.448
>
    79.136    30.568
    79.134    30.617
>
    78.984    30.590
    78.990    30.588
>
    79.976    30.035
    79.982    30.038
>
    80.383    29.961
    80.392    29.972
>
    79.927    30.170
    79.930    30.173
>
    79.121    30.527
    79.126    30.564
>
    79.113    30.526
    79.121    30.541
>
    79.789    30.046
    79.795    30.047
>
    78.854    30.018
    78.835    30.005
>
    79.866    30.154
    79.872    30.154
>
    80.419    29.866
    80.423    29.863
>
    80.160    30.033
    80.174    30.041
>
    79.442    30.232
    79.452    30.244
>
    79.858    30.135
    79.865    30.137
>
    79.864    30.114
    79.870    30.116
>
    79.860    30.099
    79.868    30.107
>
    79.119    30.516
    79.132    30.537
>
    80.194    29.868
    80.200    29.869
>
    79.270    30.521
    79.296    30.552
>
    79.549    30.288
    79.563    30.297
>
    80.354    29.610
    80.364    29.604
>
    79.968    29.999
    79.974    30.003
>
    79.383    30.360
    79.404    30.379
>
    79.817    30.167
    79.831    30.177
>
    80.409    29.853
    80.413    29.853
>
    78.805    30.762
    78.772    30.792
>
    78.299    30.911
    78.282    30.871
>
    79.261    30.567
    79.260    30.582
>
    80.123    30.009
    80.135    30.017
>
    78.656    30.741
    78.642    30.753
>
    79.805    30.151
    79.827    30.156
>
    79.187    30.498
    79.191    30.511
>
    79.089    30.505
    79.093    30.521
>
    78.713    30.371
    78.699    30.380
>
    79.230    30.442
    79.232    30.451
>
    79.212    30.436
    79.210    30.448
>
    78.423    30.831
    78.388    30.839
>
    79.196    30.432
    79.194    30.446
>
    78.652    30.728
    78.635    30.737
>
    79.189    30.432
    79.190    30.443
>
    78.834    29.907
    78.822    29.893
>
    78.004    30.532
    77.974    30.534
>
    78.425    30.831
    78.398    30.844
>
    78.554    30.064
    78.530    30.061
>
    78.409    30.874
    78.354    30.895
>
    78.657    30.700
    78.635    30.711
>
    79.951    30.011
    79.964    30.023
>
    78.397    30.865
    78.374    30.870
>
    78.349    30.836
    78.333    30.833
>
    79.003    30.667
    78.999    30.669
>
    79.184    30.574
    79.187    30.600
>
    80.186    29.815
    80.209    29.816
>
    78.414    30.800
    78.372    30.823
>
    79.324    30.544
    79.332    30.557
>
    78.223    30.889
    78.192    30.906
>
    80.261    30.024
    80.281    30.024
>
    78.529    30.754
    78.507    30.762
>
    78.641    30.746
    78.625    30.765
>
    78.751    30.404
    78.734    30.412
>
    80.252    29.981
    80.244    29.985
>
    79.434    30.485
    79.438    30.499
>
    78.290    30.869
    78.260    30.887
>
    79.138    30.488
    79.144    30.523
>
    78.377    30.478
    78.356    30.465
>
    79.532    30.378
    79.533    30.386
>
    79.529    30.389
    79.530    30.400
>
    80.419    29.835
    80.423    29.842
>
    79.139    30.571
    79.141    30.587
>
    78.328    30.855
    78.298    30.871
>
    80.373    29.898
    80.375    29.901
>
    79.740    29.933
    79.743    29.930
>
    79.718    29.961
    79.720    29.962
>
    79.068    30.483
    79.062    30.496
>
    79.276    30.575
    79.281    30.591
>
    79.955    30.100
    79.960    30.101
>
    80.210    29.978
    80.230    29.978
>
    79.874    30.142
    79.880    30.147
>
    80.088    29.993
    80.093    29.989
>
    79.841    30.043
    79.842    30.046
>
    78.523    30.741
    78.494    30.755
>
    80.203    30.012
    80.214    30.009
>
    78.505    30.761
    78.482    30.768
>
    79.721    30.019
    79.725    30.020
>
    80.058    30.031
    80.075    30.034
>
    80.132    30.007
    80.149    30.015
>
    78.331    30.278
    78.314    30.283
>
    79.870    30.098
    79.870    30.101
>
    78.289    30.888
    78.272    30.891
>
    80.123    29.949
    80.142    29.957
>
    79.580    30.185
    79.593    30.198
>
    79.868    29.997
    79.871    29.999
>
    79.413    30.322
    79.424    30.330
>
    79.171    30.516
    79.149    30.501
>
    78.182    30.899
    78.136    30.922
>
    80.411    29.907
    80.433    29.903
>
    79.766    29.974
    79.768    29.977
>
    79.064    30.491
    79.054    30.497
>
    79.885    30.100
    79.892    30.107
>
    78.423    30.752
    78.399    30.761
>
    80.410    29.869
    80.422    29.870
>
    78.206    30.881
    78.181    30.875
>
    80.382    29.882
    80.392    29.880
>
    79.854    30.148
    79.864    30.154
>
    79.131    30.528
    79.143    30.553
>
    78.857    30.651
    78.851    30.684
>
    78.670    30.711
    78.655    30.724
>
    80.061    30.015
    80.076    30.017
>
    79.184    30.477
    79.186    30.482
>
    79.509    30.425
    79.524    30.435
>
    80.035    29.999
    80.047    29.988
>
    79.451    30.427
    79.486    30.448
>
    79.944    30.088
    79.952    30.094
>
    78.414    30.866
    78.390    30.882
>
    79.416    30.505
    79.421    30.516
>
    78.700    30.510
    78.682    30.516
>
    80.031    30.136
    80.045    30.145
>
    80.002    30.133
    80.009    30.140
>
    79.519    30.354
    79.511    30.349
>
    78.301    30.901
    78.271    30.916
>
    79.944    30.021
    79.950    30.019
>
    79.247    30.552
    79.253    30.561
>
    80.226    30.014
    80.244    30.006
>
    78.942    30.635
    78.943    30.662
>
    80.178    29.997
    80.199    30.008
>
    80.438    29.867
    80.440    29.866
>
    79.529    30.447
    79.553    30.441
>
    79.231    30.473
    79.247    30.495
>
    79.549    30.449
    79.554    30.461
>
    79.260    30.476
    79.260    30.479
>
    79.239    30.468
    79.249    30.477
>
    79.463    30.368
    79.474    30.377
>
    79.246    30.474
    79.249    30.487
>
    80.041    30.086
    80.051    30.084
>
    80.033    29.994
    80.047    29.992
>
    79.188    30.495
    79.192    30.502
>
    79.191    30.484
    79.199    30.494
>
    79.375    30.518
    79.371    30.533
>
    79.368    30.523
    79.385    30.543
>
    79.371    30.521
    79.391    30.551
>
    79.239    30.461
    79.246    30.473
>
    79.247    30.536
    79.257    30.551
>
    78.856    30.588
    78.858    30.618
>
    80.235    29.956
    80.265    29.954
>
    78.646    30.535
    78.634    30.545
>
    80.075    30.057
    80.079    30.058
>
    79.011    30.537
    79.008    30.535
>
    79.904    30.111
    79.906    30.106
>
    79.984    29.989
    79.987    29.992
>
    80.171    29.879
    80.178    29.877
>
    79.853    30.000
    79.863    30.002
>
    79.869    29.997
    79.875    29.995
>
    79.863    30.000
    79.869    29.999
>
    79.873    29.986
    79.874    29.985
>
    80.131    29.969
    80.136    29.967
>
    79.863    29.999
    79.868    29.998
>
    79.871    29.991
    79.875    29.992
>
    79.863    29.963
    79.865    29.971
>
    79.870    29.989
    79.877    29.993
>
    80.175    29.980
    80.181    29.976
>
    79.876    29.989
    79.885    29.987
>
    79.870    29.991
    79.873    29.984
>
    80.203    30.025
    80.205    30.018
>
    79.850    29.997
    79.859    29.997
>
    79.862    29.985
    79.871    29.988
>
    78.553    30.719
    78.532    30.728
>
    79.378    30.333
    79.385    30.335
>
    78.527    30.803
    78.511    30.812
>
    79.201    30.487
    79.201    30.496
>
    80.093    30.078
    80.096    30.070
>
    79.864    30.005
    79.871    30.001
>
    79.866    29.985
    79.872    29.987
>
    79.862    30.004
    79.864    30.004
>
    79.862    29.992
    79.864    29.998
>
    79.871    30.012
    79.876    30.008
>
    79.343    30.361
    79.367    30.371
>
    79.866    29.994
    79.875    29.994
>
    79.214    30.487
    79.217    30.495
>
    78.629    30.205
    78.614    30.205
>
    79.221    30.429
    79.225    30.442
>
    79.219    30.441
    79.216    30.445
>
    79.222    30.437
    79.225    30.445
>
    78.680    30.211
    78.668    30.216
>
    78.319    30.486
    78.288    30.492
>
    78.520    30.063
    78.503    30.065
>
    79.864    30.003
    79.871    30.002
>
    78.614    30.623
    78.604    30.625
>
    78.637    30.190
    78.624    30.192
>
    78.721    30.656
    78.703    30.667
>
    78.596    30.769
    78.576    30.782
>
    78.535    30.767
    78.507    30.775
>
    78.572    30.725
    78.550    30.732
>
    78.307    30.180
    78.268    30.198
>
    79.444    30.382
    79.450    30.392
>
    79.855    29.992
    79.864    29.993
>
    78.603    30.692
    78.582    30.708
>
    78.866    30.690
    78.857    30.700
>
    79.315    30.590
    79.320    30.606
>
    79.315    30.523
    79.319    30.541
>
    79.881    30.169
    79.889    30.172
>
    78.556    30.700
    78.543    30.713
>
    80.090    30.000
    80.105    30.000
>
    77.879    30.787
    77.837    30.798
>
    80.179    29.899
    80.188    29.899
>
    79.965    30.049
    79.975    30.050
>
    78.780    30.001
    78.770    29.999
>
    78.385    30.840
    78.361    30.851
>
    79.151    30.466
    79.157    30.483
>
    78.857    30.602
    78.842    30.619
>
    78.791    29.987
    78.783    29.983
>
    79.599    30.215
    79.599    30.227
>
    79.146    30.498
    79.147    30.523
>
    79.091    30.498
    79.099    30.524
>
    79.468    30.227
    79.475    30.234
>
    78.856    29.829
    78.844    29.819
>
    78.022    30.892
    77.972    30.928
>
    79.200    30.500
    79.204    30.514
>
    79.936    30.065
    79.947    30.066
>
    77.955    30.715
    77.924    30.724
>
    79.882    30.115
    79.887    30.106
>
    78.956    29.897
    78.949    29.887
>
    79.192    30.474
    79.192    30.484
>
    79.798    30.002
    79.801    30.007
>
    79.584    30.233
    79.591    30.245
>
    79.845    30.145
    79.855    30.147
>
    79.341    30.531
    79.345    30.552
>
    79.541    30.234
    79.554    30.246
>
    79.348    30.489
    79.356    30.501
>
    79.533    30.245
    79.538    30.252
>
    80.445    29.829
    80.456    29.828
>
    77.985    30.620
    77.937    30.632
>
    78.466    30.479
    78.445    30.488
>
    78.160    30.957
    78.125    30.983
>
    80.394    29.885
    80.411    29.878
>
    80.408    29.888
    80.424    29.885
>
    79.158    30.479
    79.165    30.497
>
    80.150    29.806
    80.150    29.812
>
    80.145    29.808
    80.150    29.809
>
    79.890    30.173
    79.899    30.169
>
    79.931    30.045
    79.934    30.049
>
    78.336    30.797
    78.318    30.811
>
    78.343    30.799
    78.322    30.808
>
    78.444    30.818
    78.420    30.830
>
    78.448    30.825
    78.426    30.827
>
    78.579    30.699
    78.556    30.707
>
    79.919    30.130
    79.931    30.131
>
    79.411    30.353
    79.433    30.363
>
    79.165    30.485
    79.172    30.498
>
    79.287    30.655
    79.300    30.681
>
    79.895    30.086
    79.901    30.096
>
    79.887    30.091
    79.901    30.096
>
    79.400    30.452
    79.411    30.466
>
    78.519    30.782
    78.493    30.788
>
    80.384    29.858
    80.392    29.860
>
    80.073    29.962
    80.082    29.956
>
    78.921    29.926
    78.916    29.922
>
    79.195    30.471
    79.198    30.479
>
    78.948    30.530
    78.945    30.541
>
    79.465    30.331
    79.472    30.342
>
    80.407    29.858
    80.407    29.866
>
    78.911    30.578
    78.901    30.589
>
    80.448    29.885
    80.460    29.886
>
    80.455    29.894
    80.467    29.891
>
    80.318    29.941
    80.333    29.937
>
    79.168    30.469
    79.170    30.477
>
    78.569    30.313
    78.550    30.322
>
    79.216    30.478
    79.215    30.484
>
    79.211    30.485
    79.210    30.492
>
    79.553    30.255
    79.562    30.264
>
    79.513    30.271
    79.527    30.277
>
    79.377    30.525
    79.376    30.534
>
    79.423    30.326
    79.438    30.332
>
    79.412    30.473
    79.422    30.487
>
    79.399    30.469
    79.399    30.465
>
    79.399    30.482
    79.411    30.483
>
    79.409    30.481
    79.421    30.488
>
    80.017    30.063
    80.035    30.057
>
    79.972    30.018
    79.980    30.015
>
    80.474    29.904
    80.476    29.904
>
    79.982    30.034
    79.988    30.031
>
    79.249    29.654
    79.251    29.644
>
    78.638    30.718
    78.702    30.742
>
    79.965    30.020
    79.973    30.026
>
    78.005    30.594
    77.930    30.654
>
    78.138    30.930
    78.119    30.940
>
    78.916    29.897
    78.907    29.886
>
    78.842    30.634
    78.831    30.655
>
    79.472    30.438
    79.470    30.448
>
    79.217    30.471
    79.216    30.479
>
    79.211    30.470
    79.212    30.473
>
    78.581    30.789
    78.566    30.798
>
    79.212    30.458
    79.212    30.467
>
    78.983    30.578
    78.984    30.597
>
    79.203    30.464
    79.212    30.469
>
    79.950    30.126
    79.956    30.132
>
    79.158    30.473
    79.153    30.487
>
    78.853    30.610
    78.845    30.624
>
    79.306    30.557
    79.306    30.571
>
    79.193    30.464
    79.185    30.471
>
    78.889    30.033
    78.889    30.028
>
    79.849    30.084
    79.855    30.074
>
    78.798    30.645
    78.785    30.663
>
    78.796    30.648
    78.783    30.667
>
    80.181    29.978
    80.200    29.973
>
    80.462    29.865
    80.483    29.861
>
    79.218    30.466
    79.217    30.472
>
    79.395    30.389
    79.404    30.393
>
    80.286    29.814
    80.353    29.978
>
    78.235    30.930
    78.186    30.934
>
    80.397    29.829
    80.386    29.886
>
    78.485    30.757
    78.458    30.768
>
    80.137    29.911
    80.211    30.059
>
    80.133    30.021
    80.010    30.137
>
    78.602    30.778
    78.522    30.763
>
    80.237    29.905
    80.220    29.909
>
    80.188    29.933
    80.189    29.987
>
    79.235    30.353
    79.119    30.518
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    80.473    29.955
    80.476    29.959
>
    80.883    29.763
    80.883    29.762
>
    79.261    30.543
    79.267    30.555
>
    79.954    30.144
    79.957    30.145
>
    79.394    30.565
    79.396    30.567
>
    80.331    30.025
    80.332    30.028
>
    80.669    29.858
    80.669    29.860
>
    80.560    29.904
    80.560    29.905
>
    78.690    30.876
    78.689    30.878
>
    80.120    29.976
    80.118    29.978
>
    79.145    30.510
    79.144    30.513
>
    78.027    31.092
    78.034    31.092
>
    79.217    30.486
    79.216    30.487
>
    79.178    30.478
    79.177    30.482
>
    80.493    29.912
    80.486    29.908
>
    79.191    30.545
    79.192    30.547
>
    79.232    30.465
    79.233    30.469
>
    79.740    30.085
    79.741    30.088
>
    80.398    29.633
    80.398    29.637
>
    78.783    30.750
    78.784    30.755
>
    78.735    30.822
    78.734    30.826
>
    78.717    30.791
    78.717    30.794
>
    78.680    30.778
    78.680    30.779
>
    78.830    30.705
    78.829    30.708
>
    80.644    29.931
    80.645    29.934
>
    79.117    30.656
    79.117    30.659
>
    80.581    29.891
    80.582    29.894
>
    79.504    30.247
    79.503    30.251
>
    79.295    30.588
    79.295    30.589
>
    79.278    30.580
    79.278    30.585
>
    78.899    30.719
    78.900    30.723
>
    79.362    30.458
    79.362    30.461
>
    79.368    30.380
    79.367    30.387
>
    79.354    30.402
    79.355    30.406
>
    79.320    30.441
    79.314    30.441
>
    79.388    30.390
    79.387    30.388
>
    79.403    30.444
    79.396    30.439
>
    79.379    30.380
    79.382    30.386
>
    79.298    30.577
    79.298    30.582
>
    79.350    30.394
    79.350    30.398
>
    79.387    30.406
    79.390    30.411
>
    79.470    30.461
    79.465    30.450
>
    79.428    30.373
    79.426    30.377
>
    79.293    30.337
    79.280    30.327
>
    79.286    30.462
    79.286    30.467
>
    79.340    30.401
    79.341    30.407
>
    79.355    30.417
    79.354    30.423
>
    79.426    30.428
    79.425    30.431
>
    79.389    30.391
    79.388    30.395
>
    79.437    30.457
    79.438    30.461
>
    79.390    30.502
    79.392    30.507
>
    79.442    30.411
    79.433    30.409
>
    79.354    30.363
    79.347    30.358
>
    79.376    30.418
    79.375    30.422
>
    79.362    30.505
    79.361    30.510
>
    79.417    30.473
    79.418    30.477
>
    79.418    30.433
    79.416    30.432
>
    79.379    30.428
    79.379    30.428
>
    79.379    30.426
    79.380    30.430
>
    79.372    30.427
    79.372    30.428
>
    79.467    30.387
    79.465    30.389
>
    79.409    30.420
    79.408    30.423
>
    79.365    30.435
    79.364    30.438
>
    79.414    30.419
    79.414    30.421
>
    79.417    30.432
    79.418    30.433
>
    79.355    30.447
    79.355    30.448
>
    79.448    30.420
    79.447    30.422
>
    79.360    30.421
    79.360    30.422
>
    79.369    30.432
    79.370    30.432
>
    79.405    30.423
    79.405    30.425
>
    79.370    30.422
    79.369    30.424
>
    79.238    30.486
    79.239    30.487
>
    79.245    30.478
    79.246    30.479
>
    79.313    30.544
    79.313    30.544
>
    79.373    30.429
    79.374    30.429
>
    79.242    30.486
    79.244    30.478
>
    79.370    30.423
    79.372    30.423
>
    79.360    30.450
    79.360    30.451
>
    79.357    30.421
    79.357    30.422
>
    79.241    30.464
    79.241    30.465
>
    79.240    30.461
    79.240    30.461
>
    79.363    30.450
    79.363    30.450
>
    79.388    30.424
    79.389    30.425
>
    79.230    30.501
    79.230    30.502
>
    79.368    30.396
    79.368    30.396
>
    79.387    30.436
    79.387    30.436
>
    79.386    30.434
    79.386    30.435
>
    79.404    30.349
    79.397    30.359
>
    79.372    30.405
    79.373    30.405
>
    79.394    30.419
    79.394    30.420
>
    79.405    30.415
    79.406    30.414
>
    79.380    30.409
    79.380    30.409
>
    79.394    30.422
    79.394    30.422
>
    79.351    30.430
    79.352    30.430
>
    79.354    30.427
    79.355    30.427
>
    79.378    30.427
    79.378    30.428
>
    79.454    30.384
    79.452    30.386
>
    79.378    30.414
    79.379    30.419
>
    79.375    30.429
    79.375    30.430
>
    79.391    30.419
    79.391    30.420
>
    79.377    30.422
    79.377    30.423
>
    79.327    30.440
    79.327    30.440
>
    79.408    30.403
    79.408    30.404
>
    79.387    30.420
    79.387    30.420
>
    79.361    30.421
    79.361    30.422
>
    79.443    30.432
    79.444    30.432
>
    79.353    30.408
    79.358    30.409
>
    79.371    30.422
    79.371    30.422
>
    79.378    30.433
    79.378    30.433
>
    79.381    30.423
    79.381    30.424
>
    79.310    30.538
    79.311    30.539
>
    79.351    30.451
    79.351    30.452
>
    79.381    30.418
    79.381    30.419
>
    79.372    30.423
    79.373    30.424
>
    79.386    30.415
    79.387    30.415
>
    79.347    30.433
    79.348    30.434
>
    79.405    30.399
    79.406    30.401
>
    79.328    30.415
    79.329    30.415
>
    79.362    30.411
    79.362    30.411
>
    79.387    30.431
    79.387    30.431
>
    79.376    30.422
    79.377    30.422
>
    79.476    30.460
    79.476    30.461
>
    79.407    30.418
    79.408    30.418
>
    79.497    30.454
    79.497    30.455
>
    79.483    30.463
    79.484    30.463
>
    79.382    30.519
    79.382    30.520
>
    79.370    30.423
    79.375    30.422
>
    79.372    30.424
    79.373    30.424
>
    79.402    30.387
    79.403    30.387
>
    79.276    30.472
    79.277    30.473
>
    79.421    30.397
    79.421    30.397
>
    79.351    30.432
    79.352    30.432
>
    79.485    30.465
    79.486    30.465
>
    79.306    30.437
    79.307    30.438
>
    79.391    30.417
    79.392    30.418
>
    79.372    30.421
    79.372    30.422
>
    79.397    30.409
    79.398    30.410
>
    79.398    30.380
    79.399    30.380
>
    79.413    30.414
    79.414    30.414
>
    79.353    30.406
    79.354    30.406
>
    79.376    30.383
    79.377    30.383
>
    79.386    30.421
    79.387    30.421
>
    79.403    30.365
    79.403    30.367
>
    79.368    30.423
    79.369    30.423
>
    79.396    30.366
    79.397    30.366
>
    79.348    30.431
    79.348    30.431
>
    79.349    30.430
    79.349    30.430
>
    79.404    30.391
    79.404    30.392
>
    79.404    30.498
    79.403    30.499
>
    79.366    30.399
    79.367    30.401
>
    79.347    30.418
    79.346    30.420
>
    79.329    30.424
    79.331    30.422
>
    77.812    31.217
    77.820    31.220
>
    79.983    30.044
    79.981    30.047
>
    78.258    30.989
    78.256    30.991
>
    79.508    30.426
    79.511    30.431
>
    78.126    30.937
    78.123    30.939
>
    78.128    31.094
    78.128    31.096
>
    79.159    30.620
    79.158    30.620
>
    80.567    29.894
    80.566    29.897
>
    80.015    30.041
    80.015    30.045
>
    78.242    30.910
    78.244    30.912
>
    80.656    29.950
    80.649    29.952
>
    80.055    30.078
    80.053    30.080
>
    77.547    30.531
    77.549    30.534
>
    79.317    30.574
    79.317    30.577
>
    79.246    30.558
    79.246    30.559
>
    80.403    30.299
    80.403    30.302
>
    80.335    30.657
    80.335    30.659
>
    79.113    30.608
    79.113    30.610
>
    79.293    30.670
    79.292    30.672
>
    80.358    30.297
    80.358    30.301
>
    80.418    29.574
    80.418    29.579
>
    80.718    29.712
    80.717    29.714
>
    78.365    30.870
    78.367    30.870
>
    78.506    30.887
    78.505    30.890
>
    80.045    30.047
    80.044    30.051
>
    79.230    30.494
    79.229    30.500
>
    80.417    30.314
    80.418    30.320
>
    80.436    30.322
    80.434    30.323
>
    80.167    29.914
    80.167    29.917
>
    80.606    29.871
    80.605    29.874
>
    80.184    29.956
    80.184    29.959
>
    78.159    30.993
    78.159    30.995
>
    78.259    30.924
    78.259    30.927
>
    78.122    30.964
    78.121    30.965
>
    79.179    30.559
    79.179    30.561
>
    79.984    30.012
    79.982    30.014
>
    80.078    30.073
    80.068    30.066
>
    80.336    30.229
    80.334    30.232
>
    78.192    30.993
    78.187    30.992
>
    80.514    29.840
    80.515    29.844
>
    79.849    30.000
    79.849    30.002
>
    80.432    29.898
    80.434    29.899
>
    80.063    30.033
    80.063    30.036
>
    78.335    30.333
    78.334    30.336
>
    77.881    31.219
    77.861    31.223
>
    80.428    29.855
    80.427    29.856
>
    80.410    29.847
    80.406    29.848
>
    80.434    29.843
    80.434    29.846
>
    79.615    30.100
    79.615    30.103
>
    79.136    30.544
    79.134    30.547
>
    80.762    29.672
    80.763    29.676
>
    80.398    30.294
    80.397    30.297
>
    78.137    31.040
    78.139    31.040
>
    79.316    30.555
    79.315    30.558
>
    78.909    29.735
    78.909    29.735
>
    78.274    30.969
    78.272    30.972
>
    80.590    29.884
    80.589    29.886
>
    78.394    30.894
    78.391    30.897
>
    78.265    30.952
    78.264    30.955
>
    78.893    30.666
    78.894    30.670
>
    79.181    30.569
    79.182    30.575
>
    79.999    30.253
    79.997    30.254
>
    80.464    30.356
    80.463    30.358
>
    79.481    30.379
    79.480    30.382
>
    79.132    30.512
    79.131    30.516
>
    79.909    30.093
    79.909    30.095
>
    80.539    29.951
    80.539    29.953
>
    78.053    30.994
    78.087    30.979
>
    79.090    30.576
    79.089    30.578
>
    79.139    30.609
    79.140    30.612
>
    79.986    30.088
    79.986    30.088
>
    79.551    30.236
    79.551    30.236
>
    80.133    30.013
    80.134    30.014
>
    80.132    30.019
    80.132    30.019
>
    80.002    30.053
    80.002    30.053
>
    80.373    29.658
    80.374    29.658
>
    79.208    30.464
    79.208    30.464
>
    79.386    30.451
    79.388    30.448
>
    79.135    30.616
    79.134    30.617
>
    78.990    30.588
    78.990    30.588
>
    79.982    30.037
    79.982    30.038
>
    80.392    29.971
    80.392    29.972
>
    79.930    30.172
    79.930    30.173
>
    79.127    30.563
    79.126    30.564
>
    79.121    30.541
    79.121    30.541
>
    79.795    30.047
    79.795    30.047
>
    78.835    30.004
    78.835    30.005
>
    79.872    30.154
    79.872    30.154
>
    80.423    29.863
    80.423    29.863
>
    80.173    30.040
    80.174    30.041
>
    79.453    30.244
    79.452    30.244
>
    79.865    30.137
    79.865    30.137
>
    79.870    30.116
    79.870    30.116
>
    79.868    30.107
    79.868    30.107
>
    79.133    30.537
    79.132    30.537
>
    80.201    29.868
    80.200    29.869
>
    79.297    30.553
    79.296    30.552
>
    79.563    30.297
    79.563    30.297
>
    80.363    29.604
    80.364    29.604
>
    79.974    30.003
    79.974    30.003
>
    79.404    30.379
    79.404    30.379
>
    79.831    30.177
    79.831    30.177
>
    80.413    29.853
    80.413    29.853
>
    78.772    30.792
    78.772    30.792
>
    78.282    30.870
    78.282    30.871
>
    79.260    30.581
    79.260    30.582
>
    80.135    30.017
    80.135    30.017
>
    78.642    30.753
    78.642    30.753
>
    79.828    30.156
    79.827    30.156
>
    79.190    30.511
    79.191    30.511
>
    79.094    30.521
    79.093    30.521
>
    78.699    30.380
    78.699    30.380
>
    79.232    30.450
    79.232    30.451
>
    79.211    30.448
    79.210    30.448
>
    78.388    30.839
    78.388    30.839
>
    79.193    30.446
    79.194    30.446
>
    78.635    30.737
    78.635    30.737
>
    79.190    30.443
    79.190    30.443
>
    78.822    29.893
    78.822    29.893
>
    77.974    30.533
    77.974    30.534
>
    78.399    30.844
    78.398    30.844
>
    78.531    30.060
    78.530    30.061
>
    78.355    30.894
    78.354    30.895
>
    78.635    30.710
    78.635    30.711
>
    79.964    30.023
    79.964    30.023
>
    78.375    30.870
    78.374    30.870
>
    78.334    30.832
    78.333    30.833
>
    78.999    30.669
    78.999    30.669
>
    79.187    30.600
    79.187    30.600
>
    80.209    29.815
    80.209    29.816
>
    78.372    30.822
    78.372    30.823
>
    79.332    30.557
    79.332    30.557
>
    78.193    30.905
    78.192    30.906
>
    80.282    30.024
    80.281    30.024
>
    78.508    30.761
    78.507    30.762
>
    78.625    30.766
    78.625    30.765
>
    78.734    30.412
    78.734    30.412
>
    80.245    29.985
    80.244    29.985
>
    79.439    30.499
    79.438    30.499
>
    78.261    30.886
    78.260    30.887
>
    79.146    30.529
    79.144    30.523
>
    78.357    30.465
    78.356    30.465
>
    79.533    30.386
    79.533    30.386
>
    79.530    30.400
    79.530    30.400
>
    80.423    29.841
    80.423    29.842
>
    79.142    30.587
    79.141    30.587
>
    78.298    30.870
    78.298    30.871
>
    80.376    29.900
    80.375    29.901
>
    79.743    29.930
    79.743    29.930
>
    79.720    29.962
    79.720    29.962
>
    79.062    30.496
    79.062    30.496
>
    79.282    30.590
    79.281    30.591
>
    79.961    30.100
    79.960    30.101
>
    80.230    29.978
    80.230    29.978
>
    79.880    30.147
    79.880    30.147
>
    80.093    29.989
    80.093    29.989
>
    79.842    30.046
    79.842    30.046
>
    78.495    30.754
    78.494    30.755
>
    80.214    30.009
    80.214    30.009
>
    78.482    30.768
    78.482    30.768
>
    79.725    30.019
    79.725    30.020
>
    80.076    30.033
    80.075    30.034
>
    80.149    30.015
    80.149    30.015
>
    78.314    30.283
    78.314    30.283
>
    79.869    30.100
    79.870    30.101
>
    78.273    30.891
    78.272    30.891
>
    80.142    29.957
    80.142    29.957
>
    79.593    30.198
    79.593    30.198
>
    79.871    29.999
    79.871    29.999
>
    79.424    30.331
    79.424    30.330
>
    79.149    30.499
    79.149    30.501
>
    78.136    30.922
    78.136    30.922
>
    80.434    29.903
    80.433    29.903
>
    79.768    29.976
    79.768    29.977
>
    79.054    30.497
    79.054    30.497
>
    79.892    30.107
    79.892    30.107
>
    78.399    30.761
    78.399    30.761
>
    80.422    29.869
    80.422    29.870
>
    78.183    30.875
    78.181    30.875
>
    80.393    29.880
    80.392    29.880
>
    79.864    30.154
    79.864    30.154
>
    79.143    30.553
    79.143    30.553
>
    78.851    30.684
    78.851    30.684
>
    78.656    30.724
    78.655    30.724
>
    80.076    30.017
    80.076    30.017
>
    79.184    30.481
    79.186    30.482
>
    79.524    30.435
    79.524    30.435
>
    80.047    29.988
    80.047    29.988
>
    79.486    30.448
    79.486    30.448
>
    79.953    30.094
    79.952    30.094
>
    78.390    30.882
    78.390    30.882
>
    79.421    30.516
    79.421    30.516
>
    78.682    30.516
    78.682    30.516
>
    80.045    30.144
    80.045    30.145
>
    80.008    30.140
    80.009    30.140
>
    79.511    30.348
    79.511    30.349
>
    78.272    30.915
    78.271    30.916
>
    79.950    30.018
    79.950    30.019
>
    79.253    30.561
    79.253    30.561
>
    80.245    30.006
    80.244    30.006
>
    78.943    30.662
    78.943    30.662
>
    80.198    30.007
    80.199    30.008
>
    80.440    29.866
    80.440    29.866
>
    79.554    30.441
    79.553    30.441
>
    79.246    30.493
    79.247    30.495
>
    79.555    30.461
    79.554    30.461
>
    79.260    30.479
    79.260    30.479
>
    79.249    30.477
    79.249    30.477
>
    79.474    30.378
    79.474    30.377
>
    79.250    30.486
    79.249    30.487
>
    80.051    30.084
    80.051    30.084
>
    80.047    29.991
    80.047    29.992
>
    79.193    30.502
    79.192    30.502
>
    79.199    30.494
    79.199    30.494
>
    79.370    30.532
    79.371    30.533
>
    79.385    30.543
    79.385    30.543
>
    79.392    30.552
    79.391    30.551
>
    79.246    30.473
    79.246    30.473
>
    79.257    30.551
    79.257    30.551
>
    78.858    30.617
    78.858    30.618
>
    80.265    29.953
    80.265    29.954
>
    78.634    30.545
    78.634    30.545
>
    80.079    30.057
    80.079    30.058
>
    79.008    30.534
    79.008    30.535
>
    79.906    30.106
    79.906    30.106
>
    79.987    29.992
    79.987    29.992
>
    80.178    29.877
    80.178    29.877
>
    79.863    30.001
    79.863    30.002
>
    79.875    29.995
    79.875    29.995
>
    79.869    29.998
    79.869    29.999
>
    79.874    29.984
    79.874    29.985
>
    80.136    29.967
    80.136    29.967
>
    79.870    29.998
    79.868    29.998
>
    79.875    29.991
    79.875    29.992
>
    79.866    29.971
    79.865    29.971
>
    79.877    29.993
    79.877    29.993
>
    80.181    29.976
    80.181    29.976
>
    79.885    29.987
    79.885    29.987
>
    79.873    29.984
    79.873    29.984
>
    80.205    30.018
    80.205    30.018
>
    79.858    29.997
    79.859    29.997
>
    79.871    29.988
    79.871    29.988
>
    78.532    30.728
    78.532    30.728
>
    79.385    30.334
    79.385    30.335
>
    78.511    30.812
    78.511    30.812
>
    79.202    30.495
    79.201    30.496
>
    80.096    30.069
    80.096    30.070
>
    79.871    30.001
    79.871    30.001
>
    79.872    29.987
    79.872    29.987
>
    79.864    30.003
    79.864    30.004
>
    79.864    29.997
    79.864    29.998
>
    79.876    30.008
    79.876    30.008
>
    79.367    30.371
    79.367    30.371
>
    79.875    29.994
    79.875    29.994
>
    79.217    30.495
    79.217    30.495
>
    78.614    30.204
    78.614    30.205
>
    79.226    30.441
    79.225    30.442
>
    79.216    30.445
    79.216    30.445
>
    79.226    30.445
    79.225    30.445
>
    78.669    30.216
    78.668    30.216
>
    78.287    30.492
    78.288    30.492
>
    78.503    30.064
    78.503    30.065
>
    79.872    30.002
    79.871    30.002
>
    78.604    30.625
    78.604    30.625
>
    78.624    30.191
    78.624    30.192
>
    78.703    30.666
    78.703    30.667
>
    78.576    30.781
    78.576    30.782
>
    78.507    30.775
    78.507    30.775
>
    78.551    30.732
    78.550    30.732
>
    78.269    30.198
    78.268    30.198
>
    79.450    30.391
    79.450    30.392
>
    79.864    29.993
    79.864    29.993
>
    78.582    30.708
    78.582    30.708
>
    78.858    30.700
    78.857    30.700
>
    79.320    30.605
    79.320    30.606
>
    79.319    30.541
    79.319    30.541
>
    79.889    30.172
    79.889    30.172
>
    78.544    30.712
    78.543    30.713
>
    80.105    29.999
    80.105    30.000
>
    77.837    30.798
    77.837    30.798
>
    80.188    29.899
    80.188    29.899
>
    79.975    30.050
    79.975    30.050
>
    78.770    29.998
    78.770    29.999
>
    78.362    30.851
    78.361    30.851
>
    79.158    30.482
    79.157    30.483
>
    78.842    30.619
    78.842    30.619
>
    78.784    29.983
    78.783    29.983
>
    79.599    30.227
    79.599    30.227
>
    79.148    30.522
    79.147    30.523
>
    79.099    30.524
    79.099    30.524
>
    79.476    30.234
    79.475    30.234
>
    78.843    29.817
    78.844    29.819
>
    77.971    30.930
    77.972    30.928
>
    79.205    30.514
    79.204    30.514
>
    79.947    30.066
    79.947    30.066
>
    77.924    30.724
    77.924    30.724
>
    79.888    30.106
    79.887    30.106
>
    78.949    29.887
    78.949    29.887
>
    79.192    30.484
    79.192    30.484
>
    79.800    30.006
    79.801    30.007
>
    79.591    30.245
    79.591    30.245
>
    79.856    30.147
    79.855    30.147
>
    79.345    30.551
    79.345    30.552
>
    79.555    30.246
    79.554    30.246
>
    79.357    30.501
    79.356    30.501
>
    79.538    30.252
    79.538    30.252
>
    80.456    29.828
    80.456    29.828
>
    77.939    30.631
    77.937    30.632
>
    78.445    30.488
    78.445    30.488
>
    78.126    30.983
    78.125    30.983
>
    80.410    29.877
    80.411    29.878
>
    80.424    29.885
    80.424    29.885
>
    79.165    30.497
    79.165    30.497
>
    80.150    29.812
    80.150    29.812
>
    80.150    29.809
    80.150    29.809
>
    79.900    30.169
    79.899    30.169
>
    79.934    30.048
    79.934    30.049
>
    78.319    30.810
    78.318    30.811
>
    78.322    30.808
    78.322    30.808
>
    78.420    30.830
    78.420    30.830
>
    78.426    30.827
    78.426    30.827
>
    78.556    30.707
    78.556    30.707
>
    79.931    30.131
    79.931    30.131
>
    79.433    30.363
    79.433    30.363
>
    79.172    30.499
    79.172    30.498
>
    79.300    30.681
    79.300    30.681
>
    79.901    30.095
    79.901    30.096
>
    79.901    30.096
    79.901    30.096
>
    79.411    30.466
    79.411    30.466
>
    78.494    30.788
    78.493    30.788
>
    80.392    29.860
    80.392    29.860
>
    80.082    29.956
    80.082    29.956
>
    78.916    29.922
    78.916    29.922
>
    79.198    30.478
    79.198    30.479
>
    78.945    30.541
    78.945    30.541
>
    79.472    30.342
    79.472    30.342
>
    80.408    29.866
    80.407    29.866
>
    78.901    30.589
    78.901    30.589
>
    80.460    29.886
    80.460    29.886
>
    80.466    29.891
    80.467    29.891
>
    80.333    29.937
    80.333    29.937
>
    79.170    30.477
    79.170    30.477
>
    78.550    30.322
    78.550    30.322
>
    79.215    30.484
    79.215    30.484
>
    79.210    30.491
    79.210    30.492
>
    79.562    30.264
    79.562    30.264
>
    79.527    30.276
    79.527    30.277
>
    79.376    30.534
    79.376    30.534
>
    79.438    30.332
    79.438    30.332
>
    79.422    30.487
    79.422    30.487
>
    79.400    30.465
    79.399    30.465
>
    79.411    30.483
    79.411    30.483
>
    79.421    30.488
    79.421    30.488
>
    80.035    30.057
    80.035    30.057
>
    79.980    30.015
    79.980    30.015
>
    80.476    29.904
    80.476    29.904
>
    79.988    30.031
    79.988    30.031
>
    79.251    29.644
    79.251    29.644
>
    78.703    30.741
    78.702    30.742
>
    79.973    30.025
    79.973    30.026
>
    77.931    30.651
    77.930    30.654
>
    78.119    30.940
    78.119    30.940
>
    78.907    29.886
    78.907    29.886
>
    78.831    30.655
    78.831    30.655
>
    79.470    30.447
    79.470    30.448
>
    79.216    30.478
    79.216    30.479
>
    79.212    30.472
    79.212    30.473
>
    78.566    30.798
    78.566    30.798
>
    79.212    30.467
    79.212    30.467
>
    78.984    30.597
    78.984    30.597
>
    79.212    30.468
    79.212    30.469
>
    79.956    30.131
    79.956    30.132
>
    79.153    30.487
    79.153    30.487
>
    78.845    30.624
    78.845    30.624
>
    79.306    30.571
    79.306    30.571
>
    79.185    30.471
    79.185    30.471
>
    78.889    30.028
    78.889    30.028
>
    79.855    30.074
    79.855    30.074
>
    78.785    30.663
    78.785    30.663
>
    78.783    30.667
    78.783    30.667
>
    80.201    29.973
    80.200    29.973
>
    80.483    29.861
    80.483    29.861
>
    79.217    30.472
    79.217    30.472
>
    79.404    30.393
    79.404    30.393
>
    80.353    29.976
    80.353    29.978
>
    78.184    30.931
    78.186    30.934
>
    80.388    29.883
    80.386    29.886
>
    78.457    30.767
    78.458    30.768
>
    80.201    30.051
    80.211    30.059
>
    80.010    30.135
    80.010    30.137
>
    78.523    30.760
    78.522    30.763
>
    80.220    29.906
    80.220    29.909
>
    80.189    29.985
    80.189    29.987
>
    79.122    30.519
    79.119    30.518
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    80.476    29.959   -29.386     2.312     2.625
    80.883    29.762   -59.242     2.431     4.419
    79.267    30.555    55.225     5.670     7.071
    79.957    30.145   -38.491     2.293     5.137
    79.396    30.567   -44.820     2.263     3.400
    80.332    30.028   -67.538     1.844     2.976
    80.669    29.860   -63.261     2.841     4.622
    80.560    29.905   -57.750     2.149     3.675
    78.689    30.878   -48.908     4.904     8.070
    80.118    29.978   -50.404     4.205     5.422
    79.144    30.513    14.219     3.241     5.877
    78.034    31.092   -61.830     1.562     2.605
    79.216    30.487   -49.907     4.332     7.101
    79.177    30.482   -64.139     2.778     5.300
    80.486    29.908   -50.905     1.811     3.548
    79.192    30.547   -59.963     2.748     5.117
    79.233    30.469   -34.612     2.411     3.096
    79.741    30.088   -61.365     4.021     9.044
    80.398    29.637   -64.583     2.442     4.606
    78.784    30.755   -72.568     1.272     2.242
    78.734    30.826   -55.957     4.134     6.697
    78.717    30.794   -22.385     2.702     3.099
    78.680    30.779   -69.599     3.653     6.360
    78.829    30.708   -64.330     2.931     4.889
    80.645    29.934   -73.179     4.493     5.108
    79.117    30.659   -69.397     3.088     4.262
    80.582    29.894   -71.344     1.990     3.592
    79.503    30.251   -23.934     2.915     5.683
    79.295    30.589   -65.269     2.070     3.357
    79.278    30.585   -60.096     1.576     3.681
    78.900    30.723   -50.762     3.096     4.448
    79.362    30.461   -85.614     1.113     2.378
    79.367    30.387   -89.296     1.125     2.761
    79.355    30.406   -56.851     0.729     1.191
    79.314    30.441   -42.947     1.899     6.224
    79.387    30.388   -64.648     1.721     1.929
    79.396    30.439   -43.151     2.676     9.518
    79.382    30.386   -45.403     2.045     7.407
    79.298    30.582   -78.252     1.508     2.943
    79.350    30.398   -50.151     1.214     2.191
    79.390    30.411   -40.142     2.149     4.215
    79.465    30.450   -32.987     5.773     9.286
    79.426    30.377   -45.067     1.369     4.712
    79.280    30.327   -57.127     3.594     6.840
    79.286    30.467   -72.959     1.390     2.720
    79.341    30.407   -59.150     1.110     1.645
    79.354    30.423   -44.413     2.346     7.123
    79.425    30.431   -86.704     1.805     2.449
    79.388    30.395   -75.442     0.727     1.115
    79.438    30.461   -36.897     1.314     3.893
    79.392    30.507   -45.612     3.641     5.653
    79.433    30.409   -53.231     1.800     4.488
    79.347    30.358   -61.723     3.845     7.237
    79.375    30.422    29.023     1.692     4.278
    79.361    30.510    21.617     2.924     4.206
    79.418    30.477   -63.746     1.154     3.369
    79.416    30.432   -49.906     1.525     4.304
    79.379    30.428   -66.088     0.743     1.098
    79.380    30.430   -60.306     0.730     0.940
    79.372    30.428    71.802     2.005     3.178
    79.465    30.389   -45.880     1.490     2.340
    79.408    30.423   -84.521     0.893     1.084
    79.364    30.438   -77.991     0.921     1.287
    79.414    30.421    82.635     1.707     2.327
    79.418    30.433    67.614     2.250     3.012
    79.355    30.448    86.939     1.281     2.036
    79.447    30.422    84.557     2.760     4.016
    79.360    30.422    74.308     1.362     1.908
    79.370    30.432    67.797     1.137     2.033
    79.405    30.425    88.289     1.280     1.940
    79.369    30.424    48.948     1.377     2.306
    79.239    30.487   -81.577     1.108     2.078
    79.246    30.479   -80.774     1.086     2.289
    79.313    30.544   -86.248     1.204     2.383
    79.374    30.429    54.292     1.512     2.428
    79.244    30.478   -86.946     1.422     2.159
    79.372    30.423    80.119     2.090     3.161
    79.360    30.451    50.845     1.441     1.796
    79.357    30.422   -71.140     1.338     1.724
    79.241    30.465   -66.876     1.042     1.709
    79.240    30.461   -65.488     0.886     1.827
    79.363    30.450    60.172     1.636     2.158
    79.389    30.425   -32.663     0.968     1.149
    79.230    30.502   -68.190     1.164     1.879
    79.368    30.396    54.890     1.267     1.384
    79.387    30.436    81.113     0.990     1.345
    79.386    30.435    81.632     1.427     1.887
    79.397    30.359   -80.623     0.971     1.574
    79.373    30.405    56.001     1.008     1.349
    79.394    30.420   -75.456     1.254     1.721
    79.406    30.414    50.897     1.519     1.883
    79.380    30.409   -20.359     1.770     2.365
    79.394    30.422    55.807     1.235     1.710
    79.352    30.430   -81.226     1.334     1.438
    79.355    30.427    79.995     1.519     1.919
    79.378    30.428    68.473     1.196     1.568
    79.452    30.386    55.699     1.490     1.586
    79.379    30.419   -57.532     0.652     0.932
    79.375    30.430    83.786     1.109     1.401
    79.391    30.420    71.548     0.937     1.140
    79.377    30.423    77.581     1.094     1.263
    79.327    30.440   -64.872     1.215     1.578
    79.408    30.404   -25.707     1.533     1.610
    79.387    30.420    81.878     1.366     1.634
    79.361    30.422    60.385     1.156     1.715
    79.444    30.432    65.818     1.842     2.056
    79.358    30.409    86.163     1.505     1.743
    79.371    30.422   -24.957     1.982     3.500
    79.378    30.433   -88.444     1.219     1.542
    79.381    30.424    82.940     1.062     1.257
    79.311    30.539   -66.016     1.197     1.879
    79.351    30.452   -74.987     0.841     1.049
    79.381    30.419    65.816     1.081     1.316
    79.373    30.424   -70.519     0.904     1.069
    79.387    30.415    64.347     1.712     1.921
    79.348    30.434   -77.476     1.686     1.719
    79.406    30.401   -66.555     1.191     1.394
    79.329    30.415    79.350     1.165     1.416
    79.362    30.411    66.222     1.076     1.363
    79.387    30.431    63.738     1.377     1.786
    79.377    30.422    61.282     1.348     1.693
    79.476    30.461    52.161     1.697     2.481
    79.408    30.418    79.402     0.869     1.064
    79.497    30.455    63.849     2.171     2.577
    79.484    30.463    49.389     1.916     2.764
    79.382    30.520   -49.209     1.570     2.839
    79.375    30.422    49.547     1.054     1.439
    79.373    30.424    59.017     1.118     1.347
    79.403    30.387    44.810     1.431     2.195
    79.277    30.473   -65.488     1.292     2.110
    79.421    30.397    47.529     1.482     1.942
    79.352    30.432   -69.492     1.622     1.718
    79.486    30.465    50.929     2.084     3.030
    79.307    30.438   -77.523     1.312     1.629
    79.392    30.418    49.345     1.240     1.977
    79.372    30.422    86.797     1.099     1.480
    79.398    30.410    78.819     1.700     2.045
    79.399    30.380    86.990     1.414     3.019
    79.414    30.414    70.363     1.351     1.994
    79.354    30.406    66.844     1.698     2.624
    79.377    30.383    53.793     1.614     2.330
    79.387    30.421    67.669     1.666     2.534
    79.403    30.367    77.867     1.124     1.789
    79.369    30.423    66.312     1.571     2.679
    79.397    30.366    52.357     1.231     2.003
    79.348    30.431    67.761     1.525     2.708
    79.349    30.430    65.602     1.133     1.962
    79.404    30.392    52.666     1.789     2.597
    79.403    30.499    78.235     2.032     3.236
    79.367    30.401    61.641     1.170     1.924
    79.346    30.420    50.623     1.532     2.797
    79.331    30.422    62.060     4.140     6.548
    77.820    31.220   -58.859     2.059     6.408
    79.981    30.047   -60.090     5.019     7.089
    78.256    30.991   -53.166     2.856     5.938
    79.511    30.431   -53.093     3.972     5.887
    78.123    30.939   -57.159     2.441     4.636
    78.128    31.096   -57.350     2.855     6.663
    79.158    30.620   -56.228     2.645     4.448
    80.566    29.897   -58.341     1.831     1.950
    80.015    30.045   -63.041     2.810     4.123
    78.244    30.912   -15.158     3.347     6.293
    80.649    29.952    70.468     3.785     4.761
    80.053    30.080   -61.911     1.819     3.151
    77.549    30.534   -29.967     2.658     7.157
    79.317    30.577   -59.463     1.279     1.728
    79.246    30.559    55.184     1.711     2.459
    80.403    30.302   -39.578     2.234     3.054
    80.335    30.659   -60.473     3.252     4.195
    79.113    30.610   -84.992     4.436     5.592
    79.292    30.672    30.852     3.685     6.081
    80.358    30.301   -44.549     3.007     3.570
    80.418    29.579     4.897     5.488     7.014
    80.717    29.714   -63.113     2.051     3.367
    78.367    30.870     6.714     1.892     3.911
    78.505    30.890   -53.924     2.730     3.873
    80.044    30.051   -63.466     2.931     4.281
    79.229    30.500   -77.575     1.752     2.861
    80.418    30.320   -66.137     2.021     3.833
    80.434    30.323   -58.720     3.197     5.308
    80.167    29.917   -56.927     2.192     3.392
    80.605    29.874   -62.193     2.158     4.557
    80.184    29.959   -55.667     2.631     4.941
    78.159    30.995   -19.165     3.659     5.392
    78.259    30.927   -64.101     1.490     2.829
    78.121    30.965   -32.226     3.714     4.863
    79.179    30.561    19.177     3.263     5.606
    79.982    30.014   -56.775     3.040     5.698
    80.068    30.066   -59.481     2.569     5.951
    80.334    30.232   -75.811     2.098     3.172
    78.187    30.992   -45.837     3.935     8.759
    80.515    29.844   -59.710     2.926     7.907
    79.849    30.002   -61.941     1.683     3.401
    80.434    29.899   -68.640     6.077     6.379
    80.063    30.036   -57.931     1.769     3.243
    78.334    30.336   -51.603     2.805     4.386
    77.861    31.223   -58.704     1.804     3.408
    80.427    29.856   -62.288     1.519     2.450
    80.406    29.848   -60.492     1.769     2.796
    80.434    29.846   -66.881     1.290     2.035
    79.615    30.103   -56.949     2.412     4.112
    79.134    30.547   -60.874     3.164     5.816
    80.763    29.676   -59.824     1.085     1.645
    80.397    30.297   -64.484     1.576     2.079
    78.139    31.040    -1.930     4.128     5.085
    79.315    30.558   -59.508     1.622     2.274
    78.909    29.735   -56.154     4.866     6.421
    78.272    30.972   -65.320     1.275     2.007
    80.589    29.886   -66.024     1.638     2.467
    78.391    30.897   -47.588     1.936     3.473
    78.264    30.955   -65.005     1.693     2.723
    78.894    30.670   -62.202     3.666     6.743
    79.182    30.575   -80.967     5.130     7.988
    79.997    30.254   -67.867     2.288     4.827
    80.463    30.358    -6.628     3.279     6.416
    79.480    30.382   -68.436     1.274     2.176
    79.131    30.516   -57.298     2.439     4.801
    79.909    30.095    -8.076     4.183     5.204
    80.539    29.953   -63.486     1.320     1.994
    78.087    30.979   -31.042     5.028     6.226
    79.089    30.578   -66.582     0.928     1.575
    79.140    30.612   -37.960     4.881     7.252
    79.986    30.088   -63.620     1.487     2.288
    79.551    30.236   -52.711     1.610     3.375
    80.134    30.014   -70.039     1.184     1.471
    80.132    30.019    81.522     1.303     1.675
    80.002    30.053   -73.128     0.897     1.331
    80.374    29.658    29.679     1.750     2.435
    79.208    30.464   -55.734     1.172     2.574
    79.388    30.448   -64.537     1.165     2.266
    79.134    30.617   -43.183     0.763     1.128
    78.990    30.588   -50.841     2.597     4.062
    79.982    30.038   -71.265     0.896     1.501
    80.392    29.972   -58.688     1.886     3.163
    79.930    30.173   -61.608     0.980     1.825
    79.126    30.564   -49.905     1.605     2.746
    79.121    30.541   -57.524     1.566     2.683
    79.795    30.047   -64.447     1.307     2.567
    78.835    30.005   -41.141     1.521     3.070
    79.872    30.154   -67.725     1.434     2.690
    80.423    29.863    -7.917     1.574     1.676
    80.174    30.041   -47.857     1.288     2.352
    79.452    30.244   -44.850     1.153     3.573
    79.865    30.137   -52.335     1.278     2.959
    79.870    30.116   -54.151     0.697     1.308
    79.868    30.107   -66.870     1.170     2.210
    79.132    30.537   -49.915     1.702     3.852
    80.200    29.869   -89.850     1.486     2.165
    79.296    30.552   -54.097     1.754     4.097
    79.563    30.297   -47.770     1.499     4.065
    80.364    29.604    36.914     1.413     1.936
    79.974    30.003   -69.353     1.411     2.639
    79.404    30.379   -52.054     1.370     3.563
    79.831    30.177   -62.187     1.470     2.672
    80.413    29.853    84.998     1.779     2.778
    78.772    30.792   -43.446     2.080     3.108
    78.282    30.871   -59.332     5.016     7.051
    79.260    30.582   -66.009     1.278     2.412
    80.135    30.017   -49.574     1.608     3.104
    78.642    30.753   -67.134     1.059     1.830
    79.827    30.156   -26.928     1.275     2.921
    79.191    30.511   -63.337     1.729     4.080
    79.093    30.521   -58.840     1.275     2.337
    78.699    30.380   -62.788     0.989     1.675
    79.232    30.451   -62.798     1.504     2.229
    79.210    30.448   -66.669     1.685     2.197
    78.388    30.839   -71.203     1.891     2.991
    79.194    30.446   -69.556     1.776     2.809
    78.635    30.737   -65.901     1.045     1.725
    79.190    30.443   -52.966     1.864     4.029
    78.822    29.893   -53.144     1.100     2.445
    77.974    30.534   -35.939     1.983     4.604
    78.398    30.844   -86.522     1.626     2.164
    78.530    30.061   -47.075     1.338     3.037
    78.354    30.895    68.269     3.082     3.627
    78.635    30.711   -74.800     1.521     2.554
    79.964    30.023   -55.830     1.517     2.761
    78.374    30.870    81.318     1.873     2.632
    78.333    30.833   -86.867     2.035     2.506
    78.999    30.669   -55.145     2.240     3.601
    79.187    30.600   -67.405     1.298     2.947
    80.209    29.816   -48.352     1.969     2.373
    78.372    30.823   -80.080     1.823     2.480
    79.332    30.557   -60.275     2.090     4.295
    78.192    30.906   -85.773     1.924     2.606
    80.281    30.024   -47.915     1.693     2.420
    78.507    30.762    60.645     2.406     2.762
    78.625    30.765   -79.706     2.166     4.093
    78.734    30.412   -73.149     1.952     3.352
    80.244    29.985     8.004     2.256     3.675
    79.438    30.499   -52.773     1.700     3.366
    78.260    30.887    89.138     2.122     3.386
    79.144    30.523   -59.193     1.928     5.395
    78.356    30.465   -61.475     2.182     3.567
    79.533    30.386   -48.579     1.255     2.242
    79.530    30.400   -51.086     1.126     1.716
    80.423    29.842    35.570     2.464     3.045
    79.141    30.587   -61.211     0.693     1.638
    78.298    30.871   -75.777     1.866     2.821
    80.375    29.901    28.141     2.104     2.217
    79.743    29.930   -87.796     1.184     2.275
    79.720    29.962   -71.677     0.683     1.138
    79.062    30.496   -60.476     0.645     1.343
    79.281    30.591   -62.786     1.039     2.057
    79.960    30.101   -52.003     0.897     1.487
    80.230    29.978   -17.280     1.100     1.575
    79.880    30.147   -48.295     0.998     2.068
    80.093    29.989   -53.641     0.875     1.195
    79.842    30.046   -88.811     1.185     1.734
    78.494    30.755   -70.749     1.172     1.850
    80.214    30.009   -46.390     1.225     1.424
    78.482    30.768   -60.990     1.463     1.856
    79.725    30.020   -57.833     0.847     1.422
    80.075    30.034   -59.208     1.160     1.619
    80.149    30.015   -54.557     1.650     1.964
    78.314    30.283   -45.377     1.251     2.165
    79.870    30.101   -56.600     1.273     2.422
    78.272    30.891    67.327     2.499     2.940
    80.142    29.957   -13.673     2.192     2.626
    79.593    30.198   -48.818     1.780     3.058
    79.871    29.999   -59.655     0.911     1.611
    79.424    30.330   -64.763     1.326     2.087
    79.149    30.501   -57.882     1.180     2.011
    78.136    30.922   -89.311     1.944     2.643
    80.433    29.903   -38.914     2.120     2.350
    79.768    29.977   -70.680     1.843     2.891
    79.054    30.497   -45.978     1.457     1.651
    79.892    30.107   -65.096     1.140     1.880
    78.399    30.761   -76.463     1.089     1.428
    80.422    29.870   -83.678     2.048     2.746
    78.181    30.875    21.925     3.722     5.794
    80.392    29.880   -49.922     1.596     1.691
    79.864    30.154   -57.486     0.701     1.330
    79.143    30.553   -52.426     1.178     2.098
    78.851    30.684   -76.641     1.202     2.393
    78.655    30.724   -69.241     1.147     2.196
    80.076    30.017   -58.489     1.188     1.770
    79.186    30.482   -55.875     1.225     2.133
    79.524    30.435   -56.075     1.219     2.071
    80.047    29.988   -67.725     1.004     1.597
    79.486    30.448   -57.456     1.540     2.877
    79.952    30.094   -62.022     1.604     2.857
    78.390    30.882   -71.722     1.591     2.259
    79.421    30.516   -66.195     1.910     3.432
    78.682    30.516   -64.273     1.294     3.605
    80.045    30.145   -50.464     1.428     2.871
    80.009    30.140   -59.688     1.343     2.476
    79.511    30.349   -58.115     1.186     2.062
    78.271    30.916   -89.879     1.758     2.906
    79.950    30.019   -70.397     1.352     2.189
    79.253    30.561   -61.853     1.247     2.586
    80.244    30.006   -37.257     1.476     2.085
    78.943    30.662   -74.026     1.296     2.490
    80.199    30.008   -43.278     0.992     1.246
    80.440    29.866    30.518     2.060     2.243
    79.553    30.441   -63.749     2.256     3.019
    79.247    30.495   -81.372     1.371     2.146
    79.554    30.461   -64.897     1.263     3.233
    79.260    30.479   -55.599     2.129     3.498
    79.249    30.477   -61.964     1.316     2.311
    79.474    30.377   -56.916     1.342     2.278
    79.249    30.487   -56.713     1.446     1.984
    80.051    30.084   -57.434     0.848     1.428
    80.047    29.992   -67.594     1.115     1.771
    79.192    30.502   -58.603     1.782     2.655
    79.199    30.494   -63.418     0.886     1.528
    79.371    30.533   -38.960     1.254     1.712
    79.385    30.543   -56.899     1.415     2.764
    79.391    30.551   -55.883     1.708     3.632
    79.246    30.473   -49.226     1.401     2.895
    79.257    30.551   -50.187     1.176     2.295
    78.858    30.618   -66.456     2.108     7.018
    80.265    29.954    -8.475     1.833     2.862
    78.634    30.545   -55.323     1.483     3.099
    80.079    30.058    76.371     1.340     1.688
    79.008    30.535   -33.508     2.323     3.001
    79.906    30.106   -59.966     1.242     2.181
    79.987    29.992    83.495     1.217     1.528
    80.178    29.877     9.576     1.144     1.646
    79.863    30.002   -53.673     0.780     1.187
    79.875    29.995   -61.453     0.847     1.557
    79.869    29.999   -59.013     1.170     1.907
    79.874    29.985   -76.760     1.301     2.037
    80.136    29.967   -22.698     1.444     1.575
    79.868    29.998   -72.226     1.232     2.069
    79.875    29.992   -62.319     0.903     1.593
    79.865    29.971   -83.330     1.633     2.431
    79.877    29.993   -60.309     0.881     1.575
    80.181    29.976    -8.729     1.226     1.500
    79.885    29.987   -57.204     0.768     1.360
    79.873    29.984   -62.916     1.311     1.849
    80.205    30.018     1.452     1.952     2.523
    79.859    29.997   -49.885     0.945     1.997
    79.871    29.988   -51.905     0.993     2.072
    78.532    30.728   -76.048     1.373     1.878
    79.385    30.335   -45.912     1.567     2.479
    78.511    30.812    88.613     1.475     1.964
    79.201    30.496   -63.960     1.691     2.893
    80.096    30.070   -57.910     1.173     1.941
    79.871    30.001   -52.786     0.989     1.987
    79.872    29.987   -50.776     1.140     2.057
    79.864    30.004   -59.012     1.050     1.569
    79.864    29.998   -52.859     1.010     1.906
    79.876    30.008   -51.072     0.993     1.786
    79.367    30.371   -48.502     2.333     3.714
    79.875    29.994   -61.941     0.636     1.074
    79.217    30.495   -61.308     1.372     2.310
    78.614    30.205   -15.487     1.605     2.272
    79.225    30.442   -58.860     1.021     1.631
    79.216    30.445   -60.620     0.955     1.687
    79.225    30.445   -70.031     1.178     1.847
    78.668    30.216   -37.128     1.363     1.694
    78.288    30.492   -48.775     1.182     1.849
    78.503    30.065   -35.550     1.487     2.652
    79.871    30.002   -56.498     0.627     1.061
    78.604    30.625   -59.128     1.476     2.310
    78.624    30.192   -55.136     1.536     2.247
    78.703    30.667   -63.746     1.122     1.765
    78.576    30.782   -67.190     1.498     2.271
    78.507    30.775   -68.080     1.471     2.562
    78.550    30.732   -64.559     1.362     2.092
    78.268    30.198   -46.978     1.737     3.328
    79.450    30.392   -59.049     1.132     1.979
    79.864    29.993   -57.331     0.573     0.971
    78.582    30.708   -68.935     1.051     1.713
    78.857    30.700   -47.136     1.417     2.002
    79.320    30.606   -66.226     0.607     1.168
    79.319    30.541   -65.698     0.782     1.549
    79.889    30.172   -56.073     0.741     1.264
    78.543    30.713   -64.612     1.028     1.704
    80.105    30.000   -47.888     0.951     1.206
    77.837    30.798    -5.382     2.123     2.718
    80.188    29.899     9.536     1.304     2.058
    79.975    30.050   -67.663     0.782     1.386
    78.770    29.999   -54.031     1.314     2.257
    78.361    30.851   -63.015     1.817     2.487
    79.157    30.483   -57.753     1.047     1.900
    78.842    30.619   -67.691     0.906     1.446
    78.783    29.983   -57.998     2.225     3.290
    79.599    30.227   -53.422     1.717     2.621
    79.147    30.523   -67.925     1.396     2.671
    79.099    30.524   -65.520     1.235     2.814
    79.475    30.234   -48.697     1.275     2.171
    78.844    29.819   -59.906     1.144     2.107
    77.972    30.928   -58.482     1.654     2.273
    79.204    30.514   -58.336     1.155     2.518
    79.947    30.066   -60.523     0.733     1.254
    77.924    30.724   -27.463     2.350     2.628
    79.887    30.106   -78.643     1.436     2.142
    78.949    29.887   -63.272     1.730     3.802
    79.192    30.484   -62.028     0.905     1.693
    79.801    30.007   -61.004     0.868     1.516
    79.591    30.245   -54.611     1.319     2.179
    79.855    30.147   -55.908     0.716     1.446
    79.345    30.552   -56.971     1.125     2.331
    79.554    30.246   -50.470     1.423     2.857
    79.356    30.501   -57.910     0.944     1.852
    79.538    30.252   -54.062     0.740     1.487
    80.456    29.828    72.731     1.577     1.808
    77.937    30.632   -40.553     2.151     3.242
    78.445    30.488   -54.917     0.867     1.363
    78.125    30.983    89.868     1.962     2.848
    80.411    29.878   -34.883     1.256     1.479
    80.424    29.885   -35.310     1.643     1.865
    79.165    30.497   -70.939     1.212     2.308
    80.150    29.812    11.806     1.525     2.277
    80.150    29.809     7.005     1.596     2.190
    79.899    30.169   -58.750     1.217     2.413
    79.934    30.049   -86.727     1.242     2.032
    78.318    30.811   -50.397     1.561     2.255
    78.322    30.808   -44.310     1.692     2.211
    78.420    30.830   -70.044     1.145     1.535
    78.426    30.827   -71.554     1.547     1.952
    78.556    30.707   -72.017     1.391     1.859
    79.931    30.131   -49.883     1.043     2.194
    79.433    30.363   -40.355     1.774     3.603
    79.172    30.498   -60.177     1.458     2.452
    79.300    30.681   -61.181     1.249     2.342
    79.901    30.096   -88.449     1.148     2.067
    79.901    30.096   -49.472     1.014     1.887
    79.411    30.466   -60.186     1.163     1.994
    78.493    30.788   -73.681     1.410     1.793
    80.392    29.860    72.316     1.883     2.083
    80.082    29.956   -55.417     1.550     2.495
    78.916    29.922   -74.625     2.460     3.031
    79.198    30.479   -58.392     1.507     2.287
    78.945    30.541    48.046     1.491     1.966
    79.472    30.342   -50.538     0.962     1.838
    80.407    29.866   -67.779     1.748     1.871
    78.901    30.589   -71.584     1.469     1.953
    80.460    29.886   -55.843     1.526     1.790
    80.467    29.891   -23.977     1.789     2.074
    80.333    29.937   -27.843     1.588     1.915
    79.170    30.477   -57.579     0.903     1.530
    78.550    30.322   -51.223     1.409     2.083
    79.215    30.484   -58.234     1.286     2.181
    79.210    30.492   -58.119     1.047     1.858
    79.562    30.264   -51.979     1.236     2.502
    79.527    30.277   -52.956     1.066     2.132
    79.376    30.534   -56.065     1.812     2.950
    79.438    30.332   -48.089     1.264     2.238
    79.422    30.487   -51.678     1.373     3.251
    79.399    30.465   -54.436     1.561     3.245
    79.411    30.483   -54.905     1.305     2.586
    79.421    30.488   -48.593     1.302     2.771
    80.035    30.057   -55.099     1.280     1.958
    79.980    30.015   -61.380     0.933     1.485
    80.476    29.904    -6.605     2.233     2.520
    79.988    30.031   -60.541     1.085     1.759
    79.251    29.644   -63.997     1.073     2.329
    78.702    30.742    52.325     2.801     3.569
    79.973    30.026   -65.251     1.475     3.172
    77.930    30.654   -50.097     3.027     3.976
    78.119    30.940   -82.071     2.219     3.383
    78.907    29.886   -60.211     1.034     2.029
    78.831    30.655   -73.640     1.862     4.070
    79.470    30.448   -51.649     1.240     2.354
    79.216    30.479   -49.133     0.784     1.183
    79.212    30.473   -60.715     1.539     2.480
    78.566    30.798   -53.653     1.229     1.537
    79.212    30.467   -57.727     1.328     2.493
    78.984    30.597   -74.573     1.489     2.947
    79.212    30.469   -56.872     1.386     2.413
    79.956    30.132   -70.242     1.753     2.458
    79.153    30.487   -25.597     2.080     2.535
    78.845    30.624   -64.807     1.105     1.756
    79.306    30.571   -77.465     2.400     3.128
    79.185    30.471   -23.339     2.043     3.180
    78.889    30.028   -59.538     1.372     2.176
    79.855    30.074   -66.161     1.221     1.994
    78.785    30.663   -69.334     0.993     1.647
    78.783    30.667   -67.514     0.946     1.559
    80.200    29.973   -16.555     1.528     1.940
    80.483    29.861   -56.515     1.904     2.135
    79.217    30.472   -55.687     1.429     1.968
    79.404    30.393   -20.413     2.125     3.273
    80.353    29.978   -61.039     2.615     3.463
    78.186    30.934   -40.395     2.403     3.763
    80.386    29.886   -56.261     1.446     2.040
    78.458    30.768    11.493     1.949     3.138
    80.211    30.059    -7.191     5.171     6.708
    80.010    30.137    78.177     2.774     4.117
    78.522    30.763   -62.322     2.232     2.835
    80.220    29.909    77.220     1.765     3.062
    80.189    29.987   -52.059     3.823     7.558
    79.119    30.518   -57.662     2.721     5.037
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    80.476    29.959     0.200
    78.784    30.755     0.200
    79.362    30.461     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    77.509    29.528   -72.022     0.644     0.843
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    77.532    29.528   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    77.509    29.528     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    77.509    29.528     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    77.509    29.483   5 km
EOF
gmt end
