#!/bin/bash
gmt begin caleta1.47_xsec_1 pdf,ps
proj=-JX18.0/-8.7
reg=-R-86.9/145.0/0/112.0
gmt basemap $proj $reg -Bxa10f10+l'Distance (km)' -Bya10f10+l'Depth (km)' -BWesN+t'Cross-section caleta1.47'
# Event    1 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.550    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.550    47.000
    -9.550    90.000
EOF
# Event    2 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.867    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.867    33.000
   -38.867    60.000
EOF
# Event    3 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.434    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.434    29.000
   -22.434    57.000
EOF
# Event    4 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -32.803    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -32.803    27.000
   -32.803    37.000
EOF
# Event    5 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.951    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.951    41.000
   -11.951    54.000
EOF
# Event    6 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.904    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.904    34.000
   -43.904    42.000
EOF
# Event    7 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -55.788    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -55.788    16.000
   -55.788    29.000
EOF
# Event    8 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.636    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.636    19.000
   -66.636    34.000
EOF
# Event    9 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.230    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.230    31.000
   -24.230    62.000
EOF
# Event   10 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.131    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.131    25.000
   -44.131    40.000
EOF
# Event   11 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -58.223    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -58.223    20.000
   -58.223    32.000
EOF
# Event   12 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.172    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.172    68.000
    32.172   118.000
EOF
# Event   13 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.580    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.580     9.000
   -69.580    27.000
EOF
# Event   14 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.704    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.704    19.000
   -15.704    33.000
EOF
# Event   15 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.646    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.646    15.000
   -12.646    34.000
EOF
# Event   16 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.547    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.547    57.000
     7.547    64.000
EOF
# Event   17 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.859    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.859    20.000
   -50.859    32.000
EOF
# Event   18 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.296    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.296    19.000
   -23.296    27.000
EOF
# Event   19 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.920    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.920    27.000
   -56.920    46.000
EOF
# Event   20 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.884   107.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.884    95.000
    28.884   116.000
EOF
# Event   21 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.596    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.596    41.000
    -1.596    50.000
EOF
# Event   22 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.061    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.061    52.000
    -7.061    68.000
EOF
# Event   23 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.640    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.640     6.000
   -20.640    14.000
EOF
# Event   24 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.050    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.050    22.000
   -37.050    28.000
EOF
# Event   25 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -52.094    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -52.094    20.000
   -52.094    34.000
EOF
# Event   26 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.834    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.834    19.000
   -48.834    38.000
EOF
# Event   27 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -64.622    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -64.622    14.000
   -64.622    22.000
EOF
# Event   28 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.906    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.906    19.000
   -40.906    28.000
EOF
# Event   29 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.549    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.549    16.000
   -42.549    28.000
EOF
# Event   30 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -53.305    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -53.305    11.000
   -53.305    27.000
EOF
# Event   31 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.311    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.311    16.000
   -51.311    32.000
EOF
# Event   32 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.120    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.120    38.000
   -45.120    46.000
EOF
# Event   33 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.944    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.944    14.000
   -41.944    24.000
EOF
# Event   34 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.708    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.708    61.000
    36.708    71.000
EOF
# Event   35 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.241    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.241    40.000
   -19.241    46.000
EOF
# Event   36 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.668    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.668    44.000
    11.668    84.000
EOF
# Event   37 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.677    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.677    22.000
    -7.677    44.000
EOF
# Event   38 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.021    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.021    48.000
    -3.021    59.000
EOF
# Event   39 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.639    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.639    37.000
   -36.639    45.000
EOF
# Event   40 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.474    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.474    51.000
    -7.474    57.000
EOF
# Event   41 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.849    85.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.849    82.000
    28.849    88.000
EOF
# Event   42 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.794    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.794    44.000
   -21.794    50.000
EOF
# Event   43 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.464    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.464    65.000
    31.464    73.000
EOF
# Event   44 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    34.191    95.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    34.191    92.000
    34.191    98.000
EOF
# Event   45 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.831    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.831    32.000
   -33.831    43.000
EOF
# Event   46 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.208    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.208    17.000
   -42.208    25.000
EOF
# Event   47 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.544    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.544    22.000
   -27.544    30.000
EOF
# Event   48 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.830    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.830    19.000
   -30.830    30.000
EOF
# Event   49 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.566    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.566    16.000
   -42.566    27.000
EOF
# Event   50 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.146    81.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.146    78.000
    28.146    84.000
EOF
# Event   51 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.619    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.619    27.000
   -16.619    32.000
EOF
# Event   52 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.656    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.656    18.000
   -47.656    33.000
EOF
# Event   53 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.018     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.018     2.000
   -56.018    10.000
EOF
# Event   54 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.804    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.804    19.000
   -24.804    31.000
EOF
# Event   55 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.640    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.640    17.000
   -17.640    31.000
EOF
# Event   56 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.908    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.908    15.000
   -25.908    28.000
EOF
# Event   57 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.026    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.026    22.000
   -33.026    30.000
EOF
# Event   58 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.224    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.224    22.000
   -30.224    35.000
EOF
# Event   59 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.840    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.840    26.000
   -33.840    32.000
EOF
# Event   60 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.637    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.637    16.000
   -23.637    20.000
EOF
# Event   61 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    68.679    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    68.679    21.000
    68.679    29.000
EOF
# Event   62 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.987    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.987    26.000
   -22.987    31.000
EOF
# Event   63 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.255    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.255    14.000
   -16.255    29.000
EOF
# Event   64 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -35.712    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -35.712     8.000
   -35.712    16.000
EOF
# Event   65 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.107    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.107    21.000
   -39.107    29.000
EOF
# Event   66 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.289    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.289    43.000
     2.289    51.000
EOF
# Event   67 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.800    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.800    17.000
   -20.800    25.000
EOF
# Event   68 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.164    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.164    17.000
   -29.164    31.000
EOF
# Event   69 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -81.898    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -81.898    21.000
   -81.898    43.000
EOF
# Event   70 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.949    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.949    43.000
   -19.949    51.000
EOF
# Event   71 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.326    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.326    17.000
   -46.326    25.000
EOF
# Event   72 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.597    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.597    16.000
   -44.597    33.000
EOF
# Event   73 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.482    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.482    25.000
     5.482    45.000
EOF
# Event   74 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.923    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.923    20.000
   -51.923    28.000
EOF
# Event   75 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.269    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.269    25.000
   -43.269    31.000
EOF
# Event   76 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    48.800    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    48.800    65.000
    48.800    71.000
EOF
# Event   77 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.107    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.107    18.000
   -51.107    29.000
EOF
# Event   78 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.651    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.651    13.000
   -39.651    21.000
EOF
# Event   79 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.290     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.290     1.000
   -27.290     9.000
EOF
# Event   80 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.446    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.446    47.000
    -9.446    53.000
EOF
# Event   81 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.059    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.059    63.000
    16.059    69.000
EOF
# Event   82 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.354     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.354     0.000
    22.354     7.000
EOF
# Event   83 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.303    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.303    20.000
   -36.303    28.000
EOF
# Event   84 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.485    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.485    51.000
     8.485    57.000
EOF
# Event   85 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.435    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.435    26.000
    -4.435    34.000
EOF
# Event   86 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.860    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.860    46.000
   -15.860    52.000
EOF
# Event   87 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.555    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.555    13.000
   -42.555    21.000
EOF
# Event   88 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.694    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.694    51.000
   -17.694    57.000
EOF
# Event   89 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.537    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.537    43.000
    15.537    51.000
EOF
# Event   90 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.058    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.058    46.000
    -7.058    52.000
EOF
# Event   91 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.918    96.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.918    93.000
    43.918    99.000
EOF
# Event   92 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.528    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.528    55.000
    14.528    61.000
EOF
# Event   93 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.552    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.552    25.000
   -37.552    31.000
EOF
# Event   94 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.553    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.553    12.000
   -39.553    20.000
EOF
# Event   95 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.505    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.505    16.000
   -50.505    22.000
EOF
# Event   96 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.792    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.792    47.000
     4.792    53.000
EOF
# Event   97 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.623    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.623    31.000
   -45.623    37.000
EOF
# Event   98 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.879    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.879    23.000
    12.879    31.000
EOF
# Event   99 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.415    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.415    28.000
    -1.415    36.000
EOF
# Event  100 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.137    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.137    17.000
   -51.137    23.000
EOF
# Event  101 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.619    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.619    17.000
   -56.619    25.000
EOF
# Event  102 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.543    98.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.543    95.000
    42.543   101.000
EOF
# Event  103 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.493    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.493    30.000
    16.493    38.000
EOF
# Event  104 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.835    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.835    24.000
   -19.835    32.000
EOF
# Event  105 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.264    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.264    32.000
    -4.264    38.000
EOF
# Event  106 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.036    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.036    16.000
   -51.036    22.000
EOF
# Event  107 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.623    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.623    14.000
   -13.623    20.000
EOF
# Event  108 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.893    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.893    17.000
   -49.893    25.000
EOF
# Event  109 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.519    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.519    24.000
   -25.519    30.000
EOF
# Event  110 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.223    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.223    31.000
   -21.223    37.000
EOF
# Event  111 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.965    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.965    15.000
   -47.965    21.000
EOF
# Event  112 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.665    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.665    49.000
   -10.665    55.000
EOF
# Event  113 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.115    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.115    19.000
   -50.115    25.000
EOF
# Event  114 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.659    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.659    29.000
   -38.659    35.000
EOF
# Event  115 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.841    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.841    48.000
    22.841    54.000
EOF
# Event  116 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.015    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.015    23.000
   -11.015    31.000
EOF
# Event  117 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.631    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.631    44.000
   -13.631    50.000
EOF
# Event  118 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.014    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.014    49.000
    25.014    55.000
EOF
# Event  119 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.252    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.252    21.000
    11.252    29.000
EOF
# Event  120 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.721     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.721     2.000
    -7.721    10.000
EOF
# Event  121 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.202    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.202    32.000
    16.202    38.000
EOF
# Event  122 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.205    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.205    20.000
   -46.205    26.000
EOF
# Event  123 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.548    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.548    20.000
   -40.548    26.000
EOF
# Event  124 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.718    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.718    67.000
    45.718    73.000
EOF
# Event  125 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    50.208    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    50.208    42.000
    50.208    48.000
EOF
# Event  126 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    67.761    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    67.761     7.000
    67.761    15.000
EOF
# Event  127 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.456    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.456    18.000
   -45.456    24.000
EOF
# Event  128 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    57.474    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    57.474    29.000
    57.474    35.000
EOF
# Event  129 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.279    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.279    40.000
    31.279    46.000
EOF
# Event  130 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.228    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.228    25.000
   -46.228    31.000
EOF
# Event  131 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.347    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.347    12.000
   -42.347    20.000
EOF
# Event  132 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    61.943    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    61.943    57.000
    61.943    63.000
EOF
# Event  133 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.476    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.476    20.000
   -44.476    26.000
EOF
# Event  134 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.704    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.704    23.000
   -47.704    29.000
EOF
# Event  135 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.849    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.849     8.000
   -10.849    14.000
EOF
# Event  136 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.772    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.772    17.000
   -42.772    23.000
EOF
# Event  137 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.414    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.414    45.000
   -15.414    51.000
EOF
# Event  138 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.322    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.322    25.000
   -39.322    33.000
EOF
# Event  139 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    56.049    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    56.049    59.000
    56.049    65.000
EOF
# Event  140 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.530    75.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.530    72.000
    28.530    78.000
EOF
# Event  141 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.811    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.811    29.000
     5.811    35.000
EOF
# Event  142 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.143    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.143    32.000
   -25.143    38.000
EOF
# Event  143 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    83.150    78.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    83.150    75.000
    83.150    81.000
EOF
# Event  144 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.339    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.339    46.000
   -15.339    52.000
EOF
# Event  145 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.294    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.294    13.000
   -26.294    19.000
EOF
# Event  146 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.295    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.295    34.000
   -18.295    40.000
EOF
# Event  147 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.906    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.906    45.000
   -12.906    51.000
EOF
# Event  148 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.845    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.845    19.000
   -19.845    27.000
EOF
# Event  149 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.160    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.160     9.000
    17.160    17.000
EOF
# Event  150 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.597    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.597    41.000
     3.597    47.000
EOF
# Event  151 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.635    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.635    26.000
     9.635    34.000
EOF
# Event  152 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    82.191    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    82.191    67.000
    82.191    73.000
EOF
# Event  153 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.005    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.005    16.000
   -44.005    22.000
EOF
# Event  154 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.015    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.015    19.000
   -51.015    25.000
EOF
# Event  155 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -57.117    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -57.117    13.000
   -57.117    21.000
EOF
# Event  156 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.684    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.684    31.000
   -13.684    37.000
EOF
# Event  157 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.500     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.500     2.000
   -29.500    10.000
EOF
# Event  158 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.724    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.724    11.000
    27.724    19.000
EOF
# Event  159 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.668    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.668    25.000
    -0.668    33.000
EOF
# Event  160 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.948    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.948    39.000
    13.948    45.000
EOF
# Event  161 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.968    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.968    43.000
    23.968    49.000
EOF
# Event  162 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.346    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.346    18.000
    -1.346    26.000
EOF
# Event  163 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   122.075     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   122.075     2.000
   122.075    10.000
EOF
# Event  164 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.112    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.112    19.000
   -12.112    27.000
EOF
# Event  165 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   124.333    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   124.333    18.000
   124.333    24.000
EOF
# Event  166 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.960    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.960    33.000
   -11.960    39.000
EOF
# Event  167 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.986    82.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.986    79.000
    39.986    85.000
EOF
# Event  168 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.049    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.049    44.000
   -16.049    50.000
EOF
# Event  169 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.739    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.739    16.000
   -38.739    22.000
EOF
# Event  170 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.966    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.966    17.000
   -42.966    23.000
EOF
# Event  171 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.820    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.820    17.000
   -38.820    23.000
EOF
# Event  172 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   116.657     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   116.657     0.000
   116.657     4.000
EOF
# Event  173 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.665    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.665    15.000
   -44.665    21.000
EOF
# Event  174 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.730    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.730    23.000
   -49.730    29.000
EOF
# Event  175 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.820    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.820    53.000
    41.820    59.000
EOF
# Event  176 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.227    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.227    32.000
   -42.227    38.000
EOF
# Event  177 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.857    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.857    22.000
   -50.857    28.000
EOF
# Event  178 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.615    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.615    43.000
   -15.615    49.000
EOF
# Event  179 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.331    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.331    31.000
   -14.331    37.000
EOF
# Event  180 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.406    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.406    36.000
    10.406    42.000
EOF
# Event  181 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.842    75.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.842    72.000
    38.842    78.000
EOF
# Event  182 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   127.907     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   127.907     2.000
   127.907     9.000
EOF
# Event  183 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   138.381    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   138.381    21.000
   138.381    27.000
EOF
# Event  184 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.197    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.197    22.000
   -29.197    30.000
EOF
# Event  185 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.863    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.863    18.000
    45.863    26.000
EOF
# Event  186 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.751    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.751    30.000
    20.751    36.000
EOF
# Event  187 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   129.527     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   129.527     0.000
   129.527     8.000
EOF
# Event  188 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   124.509     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   124.509     0.000
   124.509     7.000
EOF
# Event  189 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.999    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.999    28.000
    23.999    36.000
EOF
# Event  190 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.618    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.618    16.000
   -51.618    22.000
EOF
# Event  191 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.972    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.972    21.000
    17.972    29.000
EOF
# Event  192 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.052    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.052    49.000
    13.052    55.000
EOF
# Event  193 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.856    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.856     9.000
    15.856    17.000
EOF
# Event  194 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.983    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.983    44.000
   -10.983    50.000
EOF
# Event  195 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.626    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.626    57.000
    44.626    63.000
EOF
# Event  196 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.243    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.243    28.000
     3.243    36.000
EOF
# Event  197 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.988    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.988    20.000
   -41.988    26.000
EOF
# Event  198 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.963    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.963    51.000
    24.963    57.000
EOF
# Event  199 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.195    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.195    16.000
   -44.195    22.000
EOF
# Event  200 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.014    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.014    20.000
   -38.014    26.000
EOF
# Event  201 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -55.913    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -55.913    10.000
   -55.913    18.000
EOF
# Event  202 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.482    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.482    20.000
   -48.482    26.000
EOF
# Event  203 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.034    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.034    16.000
   -48.034    22.000
EOF
# Event  204 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.683    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.683    21.000
   -33.683    27.000
EOF
# Event  205 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.463    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.463    21.000
   -42.463    27.000
EOF
# Event  206 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -54.317    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -54.317    13.000
   -54.317    21.000
EOF
# Event  207 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.816    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.816    10.000
   -43.816    18.000
EOF
# Event  208 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.352    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.352    15.000
   -45.352    23.000
EOF
# Event  209 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.319    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.319    17.000
   -36.319    31.000
EOF
# Event  210 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.991    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.991     6.000
   -42.991    14.000
EOF
# Event  211 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.671    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.671    12.000
   -44.671    23.000
EOF
# Event  212 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.917    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.917     8.000
   -33.917    16.000
EOF
# Event  213 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.829    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.829     6.000
   -28.829    14.000
EOF
# Event  214 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -53.034    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -53.034    10.000
   -53.034    18.000
EOF
# Event  215 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.820    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.820    22.000
   -45.820    28.000
EOF
# Event  216 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.673    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.673    18.000
   -43.673    24.000
EOF
# Event  217 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.252    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.252    35.000
    -7.252    41.000
EOF
# Event  218 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.242    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.242    20.000
   -22.242    26.000
EOF
# Event  219 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.595    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.595    26.000
   -13.595    32.000
EOF
# Event  220 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.190    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.190    22.000
   -34.190    28.000
EOF
# Event  221 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.147    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.147    27.000
   -42.147    33.000
EOF
# Event  222 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -75.468    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -75.468    13.000
   -75.468    21.000
EOF
# Event  223 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.453    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.453     6.000
   -28.453    14.000
EOF
# Event  224 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.690    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.690    26.000
   -30.690    32.000
EOF
# Event  225 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.750    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.750    67.000
    22.750    73.000
EOF
# Event  226 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.256    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.256    31.000
   -42.256    37.000
EOF
# Event  227 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   122.668     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   122.668     0.000
   122.668     4.000
EOF
# Event  228 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.166    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.166    20.000
   -24.166    28.000
EOF
# Event  229 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   116.505    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   116.505     8.000
   116.505    16.000
EOF
# Event  230 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.927    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.927    18.000
   -30.927    24.000
EOF
# Event  231 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.059    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.059    27.000
   -36.059    33.000
EOF
# Event  232 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   120.973     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   120.973     0.000
   120.973     4.000
EOF
# Event  233 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   122.267     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   122.267     0.000
   122.267     4.000
EOF
# Event  234 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   114.943    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   114.943     6.000
   114.943    14.000
EOF
# Event  235 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   114.062     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   114.062     0.000
   114.062     5.000
EOF
# Event  236 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.160    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.160    29.000
   -39.160    35.000
EOF
# Event  237 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   116.198    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   116.198    14.000
   116.198    22.000
EOF
# Event  238 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   121.950     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   121.950     0.000
   121.950     4.000
EOF
# Event  239 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.616    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.616    19.000
   -27.616    25.000
EOF
# Event  240 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.885    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.885    18.000
    -1.885    26.000
EOF
# Event  241 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.572    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.572    37.000
   -13.572    43.000
EOF
# Event  242 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.241    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.241    26.000
   -24.241    32.000
EOF
# Event  243 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   114.987     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   114.987     0.000
   114.987     7.000
EOF
# Event  244 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.010    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.010    32.000
   -37.010    38.000
EOF
# Event  245 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   122.876     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   122.876     1.000
   122.876     8.000
EOF
# Event  246 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   131.048     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   131.048     0.000
   131.048     4.000
EOF
# Event  247 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.559    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.559    19.000
     0.559    27.000
EOF
# Event  248 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.027    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.027    32.000
   -11.027    38.000
EOF
# Event  249 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   134.379    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   134.379     6.000
   134.379    14.000
EOF
# Event  250 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   131.997    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   131.997     7.000
   131.997    15.000
EOF
# Event  251 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   132.505     2.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   132.505     0.000
   132.505     6.000
EOF
# Event  252 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   133.214    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   133.214     9.000
   133.214    17.000
EOF
# Event  253 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.015    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.015    17.000
    14.015    25.000
EOF
# Event  254 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   120.180     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   120.180     0.000
   120.180     5.000
EOF
# Event  255 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.898    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.898    28.000
   -23.898    36.000
EOF
# Event  256 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   113.697     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   113.697     0.000
   113.697     7.000
EOF
# Event  257 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -60.038    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -60.038    22.000
   -60.038    28.000
EOF
# Event  258 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.461    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.461    10.000
   -22.461    16.000
EOF
# Event  259 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.487    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.487    27.000
   -41.487    56.000
EOF
# Event  260 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    49.033    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    49.033    20.000
    49.033    26.000
EOF
# Event  261 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.615    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.615    15.000
   -29.615    21.000
EOF
# Event  262 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.017    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.017    33.000
   -10.017    39.000
EOF
# Event  263 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   113.578     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   113.578     0.000
   113.578     5.000
EOF
# Event  264 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.200     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.200     2.000
    30.200    10.000
EOF
# Event  265 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   121.251     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   121.251     3.000
   121.251    10.000
EOF
# Event  266 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.507    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.507    29.000
   -23.507    35.000
EOF
# Event  267 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.511    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.511    10.000
    -0.511    18.000
EOF
# Event  268 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.138    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.138    39.000
   -17.138    45.000
EOF
# Event  269 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -71.006     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -71.006     5.000
   -71.006    11.000
EOF
# Event  270 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.291    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.291    23.000
    -0.291    31.000
EOF
# Event  271 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.312    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.312    22.000
   -46.312    28.000
EOF
# Event  272 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.067    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.067    45.000
   -15.067    51.000
EOF
# Event  273 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.167    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.167    62.000
    65.167    68.000
EOF
# Event  274 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.473    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.473    26.000
   -50.473    32.000
EOF
# Event  275 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   139.974     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   139.974     0.000
   139.974     4.000
EOF
# Event  276 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.650    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.650     9.000
     9.650    17.000
EOF
# Event  277 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.890    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.890    24.000
   -44.890    30.000
EOF
# Event  278 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.161    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.161    63.000
    17.161    69.000
EOF
# Event  279 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.096     7.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.096     4.000
   -23.096    10.000
EOF
# Event  280 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -60.607    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -60.607    11.000
   -60.607    19.000
EOF
# Event  281 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.430    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.430    14.000
    24.430    20.000
EOF
# Event  282 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   112.448     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   112.448     0.000
   112.448     4.000
EOF
# Event  283 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -67.819    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -67.819    22.000
   -67.819    28.000
EOF
# Event  284 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   117.167     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   117.167     0.000
   117.167     5.000
EOF
# Event  285 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.670    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.670    14.000
    12.670    22.000
EOF
# Event  286 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.484    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.484    39.000
   -19.484    45.000
EOF
# Event  287 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.367    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.367    43.000
   -18.367    49.000
EOF
# Event  288 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.445    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.445    26.000
    37.445    32.000
EOF
# Event  289 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.095     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.095     5.000
    22.095    13.000
EOF
# Event  290 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.850    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.850    27.000
   -43.850    33.000
EOF
# Event  291 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.528    71.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.528    68.000
    21.528    74.000
EOF
# Event  292 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    59.216    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    59.216    63.000
    59.216    69.000
EOF
# Event  293 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.179    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.179    27.000
   -51.179    33.000
EOF
# Event  294 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    92.512    86.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    92.512    83.000
    92.512    89.000
EOF
# Event  295 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   128.590     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   128.590     0.000
   128.590     4.000
EOF
# Event  296 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    63.187    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    63.187    67.000
    63.187    73.000
EOF
# Event  297 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.820    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.820    36.000
    -6.820    42.000
EOF
# Event  298 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   130.520     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   130.520     0.000
   130.520     5.000
EOF
# Event  299 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.170    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.170    28.000
   -41.170    34.000
EOF
# Event  300 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   128.624    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   128.624    27.000
   128.624    33.000
EOF
# Event  301 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   115.013     2.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   115.013     0.000
   115.013     6.000
EOF
# Event  302 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.760    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.760    58.000
   -12.760    64.000
EOF
# Event  303 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.928    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.928    35.000
    -9.928    41.000
EOF
# Event  304 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.726    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.726    38.000
   -38.726    44.000
EOF
# Event  305 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    54.832    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    54.832    51.000
    54.832    57.000
EOF
# Event  306 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.169    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.169    27.000
    16.169    35.000
EOF
# Event  307 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.713    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.713    12.000
    -2.713    20.000
EOF
# Event  308 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.718    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.718    26.000
    27.718    32.000
EOF
# Event  309 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.223    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.223    20.000
     2.223    26.000
EOF
# Event  310 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.910    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.910    24.000
   -51.910    30.000
EOF
# Event  311 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.976    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.976    40.000
    19.976    46.000
EOF
# Event  312 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.287    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.287    45.000
   -17.287    51.000
EOF
# Event  313 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   120.669    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   120.669    14.000
   120.669    20.000
EOF
# Event  314 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.575    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.575    24.000
     8.575    30.000
EOF
# Event  315 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   135.293     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   135.293     2.000
   135.293    10.000
EOF
# Event  316 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.509    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.509    35.000
   -12.509    43.000
EOF
# Event  317 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.597    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.597    23.000
   -13.597    44.000
EOF
# Event  318 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.283    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.283    25.000
   -18.283    48.000
EOF
# Event  319 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.154    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.154    31.000
   -29.154    39.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p,Helvetica,black+a0.+jBL << EOF
    -9.350    52.000 1
   -38.667    48.000 2
   -22.234    49.000 3
   -32.603    32.000 4
   -11.751    47.000 5
   -43.704    38.000 6
   -55.588    22.000 7
   -66.436    22.000 8
   -24.030    54.000 9
   -43.931    34.000 10
   -58.023    25.000 11
    32.372    72.000 12
   -69.380    20.000 13
   -15.504    30.000 14
   -12.446    28.000 15
     7.747    61.000 16
   -50.659    30.000 17
   -23.096    23.000 18
   -56.720    34.000 19
    29.084   107.000 20
    -1.396    47.000 21
    -6.861    60.000 22
   -20.440    10.000 23
   -36.850    25.000 24
   -51.894    26.000 25
   -48.634    25.000 26
   -64.422    18.000 27
   -40.706    23.000 28
   -42.349    23.000 29
   -53.105    21.000 30
   -51.111    22.000 31
   -44.920    42.000 32
   -41.744    18.000 33
    36.908    66.000 34
   -19.041    43.000 35
    11.868    47.000 36
    -7.477    38.000 37
    -2.821    54.000 38
   -36.439    41.000 39
    -7.274    54.000 40
    29.049    85.000 41
   -21.594    47.000 42
    31.664    69.000 43
    34.391    95.000 44
   -33.631    39.000 45
   -42.007    21.000 46
   -27.344    26.000 47
   -30.630    27.000 48
   -42.366    22.000 49
    28.346    81.000 50
   -16.419    29.000 51
   -47.456    21.000 52
   -55.818     6.000 53
   -24.604    23.000 54
   -17.440    28.000 55
   -25.708    24.000 56
   -32.826    26.000 57
   -30.024    29.000 58
   -33.640    29.000 59
   -23.437    18.000 60
    68.879    25.000 61
   -22.787    29.000 62
   -16.055    17.000 63
   -35.512    12.000 64
   -38.907    25.000 65
     2.489    47.000 66
   -20.600    21.000 67
   -28.964    20.000 68
   -81.698    29.000 69
   -19.749    47.000 70
   -46.126    20.000 71
   -44.397    19.000 72
     5.682    41.000 73
   -51.723    24.000 74
   -43.069    28.000 75
    49.000    68.000 76
   -50.907    24.000 77
   -39.451    17.000 78
   -27.090     5.000 79
    -9.246    50.000 80
    16.259    66.000 81
    22.554     3.000 82
   -36.103    24.000 83
     8.685    54.000 84
    -4.235    30.000 85
   -15.660    49.000 86
   -42.355    17.000 87
   -17.494    54.000 88
    15.737    47.000 89
    -6.858    49.000 90
    44.118    96.000 91
    14.728    58.000 92
   -37.352    28.000 93
   -39.353    16.000 94
   -50.305    19.000 95
     4.992    50.000 96
   -45.423    34.000 97
    13.079    27.000 98
    -1.215    32.000 99
   -50.937    20.000 100
   -56.419    21.000 101
    42.743    98.000 102
    16.693    34.000 103
   -19.635    28.000 104
    -4.064    35.000 105
   -50.836    19.000 106
   -13.423    17.000 107
   -49.693    21.000 108
   -25.319    27.000 109
   -21.023    34.000 110
   -47.765    18.000 111
   -10.465    52.000 112
   -49.915    22.000 113
   -38.459    32.000 114
    23.041    51.000 115
   -10.815    27.000 116
   -13.431    47.000 117
    25.214    52.000 118
    11.452    25.000 119
    -7.521     6.000 120
    16.402    35.000 121
   -46.005    23.000 122
   -40.348    23.000 123
    45.918    70.000 124
    50.408    45.000 125
    67.961    11.000 126
   -45.256    21.000 127
    57.674    32.000 128
    31.479    43.000 129
   -46.028    28.000 130
   -42.147    16.000 131
    62.143    60.000 132
   -44.276    23.000 133
   -47.504    26.000 134
   -10.649    11.000 135
   -42.572    20.000 136
   -15.214    48.000 137
   -39.122    29.000 138
    56.249    62.000 139
    28.730    75.000 140
     6.011    32.000 141
   -24.943    35.000 142
    83.350    78.000 143
   -15.139    49.000 144
   -26.094    16.000 145
   -18.095    37.000 146
   -12.706    48.000 147
   -19.645    23.000 148
    17.360    13.000 149
     3.797    44.000 150
     9.835    30.000 151
    82.391    70.000 152
   -43.805    19.000 153
   -50.815    22.000 154
   -56.917    17.000 155
   -13.484    34.000 156
   -29.300     6.000 157
    27.924    15.000 158
    -0.468    29.000 159
    14.148    42.000 160
    24.168    46.000 161
    -1.146    22.000 162
   122.275     6.000 163
   -11.912    23.000 164
   124.533    21.000 165
   -11.760    36.000 166
    40.186    82.000 167
   -15.849    47.000 168
   -38.539    19.000 169
   -42.766    20.000 170
   -38.620    20.000 171
   116.857     0.000 172
   -44.465    18.000 173
   -49.530    26.000 174
    42.020    56.000 175
   -42.027    35.000 176
   -50.657    25.000 177
   -15.415    46.000 178
   -14.131    34.000 179
    10.606    39.000 180
    39.042    75.000 181
   128.107     5.000 182
   138.581    24.000 183
   -28.997    26.000 184
    46.063    22.000 185
    20.951    33.000 186
   129.727     4.000 187
   124.709     3.000 188
    24.199    32.000 189
   -51.418    19.000 190
    18.172    25.000 191
    13.252    52.000 192
    16.056    13.000 193
   -10.783    47.000 194
    44.826    60.000 195
     3.443    32.000 196
   -41.788    23.000 197
    25.163    54.000 198
   -43.995    19.000 199
   -37.814    23.000 200
   -55.713    14.000 201
   -48.282    23.000 202
   -47.834    19.000 203
   -33.483    24.000 204
   -42.263    24.000 205
   -54.117    17.000 206
   -43.616    14.000 207
   -45.152    19.000 208
   -36.119    24.000 209
   -42.791    10.000 210
   -44.471    15.000 211
   -33.717    12.000 212
   -28.629    10.000 213
   -52.834    14.000 214
   -45.620    25.000 215
   -43.473    21.000 216
    -7.052    38.000 217
   -22.042    23.000 218
   -13.395    29.000 219
   -33.990    25.000 220
   -41.947    30.000 221
   -75.268    17.000 222
   -28.253    10.000 223
   -30.490    29.000 224
    22.950    70.000 225
   -42.056    34.000 226
   122.868     0.000 227
   -23.966    24.000 228
   116.705    12.000 229
   -30.727    21.000 230
   -35.859    30.000 231
   121.173     0.000 232
   122.467     0.000 233
   115.143    10.000 234
   114.262     1.000 235
   -38.960    32.000 236
   116.398    18.000 237
   122.150     0.000 238
   -27.416    22.000 239
    -1.685    22.000 240
   -13.372    40.000 241
   -24.041    29.000 242
   115.187     3.000 243
   -36.810    35.000 244
   123.076     4.000 245
   131.248     0.000 246
     0.759    23.000 247
   -10.827    35.000 248
   134.579    10.000 249
   132.197    11.000 250
   132.705     2.000 251
   133.414    13.000 252
    14.215    21.000 253
   120.380     1.000 254
   -23.698    32.000 255
   113.897     3.000 256
   -59.838    25.000 257
   -22.261    13.000 258
   -41.287    48.000 259
    49.233    23.000 260
   -29.415    18.000 261
    -9.817    36.000 262
   113.778     1.000 263
    30.400     6.000 264
   121.451     6.000 265
   -23.307    32.000 266
    -0.311    14.000 267
   -16.938    42.000 268
   -70.806     8.000 269
    -0.091    27.000 270
   -46.112    25.000 271
   -14.867    48.000 272
    65.367    65.000 273
   -50.273    29.000 274
   140.174     0.000 275
     9.850    13.000 276
   -44.690    27.000 277
    17.361    66.000 278
   -22.896     7.000 279
   -60.407    15.000 280
    24.630    17.000 281
   112.648     0.000 282
   -67.619    25.000 283
   117.367     1.000 284
    12.870    18.000 285
   -19.284    42.000 286
   -18.167    46.000 287
    37.645    29.000 288
    22.295     9.000 289
   -43.650    30.000 290
    21.728    71.000 291
    59.416    66.000 292
   -50.979    30.000 293
    92.712    86.000 294
   128.790     0.000 295
    63.387    70.000 296
    -6.620    39.000 297
   130.720     1.000 298
   -40.970    31.000 299
   128.824    30.000 300
   115.213     2.000 301
   -12.560    61.000 302
    -9.728    38.000 303
   -38.526    41.000 304
    55.032    54.000 305
    16.369    31.000 306
    -2.513    16.000 307
    27.918    29.000 308
     2.423    23.000 309
   -51.710    27.000 310
    20.176    43.000 311
   -17.087    48.000 312
   120.869    17.000 313
     8.775    27.000 314
   135.493     6.000 315
   -12.309    39.000 316
   -13.397    39.000 317
   -18.083    43.000 318
   -28.954    35.000 319
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
   -44.131    34.000     0.300
   -37.050    25.000     0.400
   -42.549    23.000     0.200
   -33.831    39.000     0.300
   -24.804    23.000     0.200
   -39.553    16.000     0.200
    -1.415    32.000     0.200
   -44.671    15.000     0.200
   -12.509    39.000     0.200
EOF

# Azimuth of the projection plane
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
   144.874     0.100 Azimuth =   31
EOF
gmt end
