#!/bin/bash
gmt begin caleta1.47_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases caleta1.47'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    -4.151
     2.500    -4.181
     3.000    -4.211
     3.500    -4.241
     4.000    -4.272
     4.500    -4.302
     5.000    -4.332
     5.500    -4.362
     6.000    -4.392
     6.500    -4.423
     7.000    -4.453
     7.500    -4.483
     8.000    -4.513
     8.500    -4.543
     9.000    -4.574
     9.500    -4.604
    10.000    -4.634
    10.500    -4.664
    11.000    -4.694
    11.500    -4.725
    12.000    -4.755
    12.500    -4.785
    13.000    -4.815
    13.500    -4.845
    14.000    -4.876
    14.500    -4.906
    15.000    -4.936
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000    -1.815 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000    -0.579
     1.500    -4.089
     2.000    -7.599
     2.500   -11.109
     3.000   -14.619
     3.500   -18.134
     4.000   -21.650
     4.500   -25.170
     5.000   -28.693
     5.500   -32.220
     6.000   -35.752
     6.500   -39.287
     7.000   -42.828
     7.500   -46.374
     8.000   -49.926
     8.500   -53.484
     9.000   -57.050
     9.500   -60.622
    10.000   -64.200
    10.500   -67.788
    11.000   -71.384
    11.500   -74.988
    12.000   -78.601
    12.500   -82.224
    13.000   -85.857
    13.500   -89.500
    14.000   -93.155
    14.500   -96.821
    15.000  -100.497
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -82.857 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.909
     1.000     0.044
     1.500    -1.505
     2.000    -3.006
     2.500    -4.492
     3.000    -5.973
     3.500    -7.452
     4.000    -8.930
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -11.930 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     5.117    -8.358     0.200
     4.180    -7.906     0.200
    15.674    -8.585     0.200
    21.975    -3.339     0.200
     3.295    -4.735     0.200
     3.216    -3.561     0.200
    18.884   -24.235     0.200
     3.378    -2.376     0.200
     2.480    -0.891     0.200
     4.163    -4.473     0.200
     4.832    -7.179     0.200
     4.012    -7.171     0.200
     3.695    -3.943     0.200
     2.790    -2.405     0.200
     3.209    -1.705     0.200
     2.926    -0.399     0.200
     2.960    -3.497     0.200
     3.405    -2.093     0.200
    10.975    -7.007     0.200
     2.124    -6.115     0.200
     2.955    -6.882     0.200
     2.239    -5.425     0.200
     2.813    -3.475     0.200
     3.877     3.192     0.200
     2.179    -5.064     0.200
     3.026    -4.580     0.200
     3.186    -2.356     0.200
     2.017    -5.951     0.200
     2.050    -5.113     0.200
     2.362    -6.208     0.200
    11.177    -2.800     0.200
     3.623    -2.598     0.200
     3.759    -0.339     0.200
     3.904    -4.317     0.200
     3.957    -3.471     0.200
     4.179    -0.490     0.200
     4.230    -2.218     0.200
     4.230    -1.378     0.200
     4.298    -2.083     0.200
    11.289    -7.944     0.200
     2.139    -3.670     0.200
     2.767    -5.656     0.200
    11.282    -0.927     0.200
    11.257     2.138     0.200
    11.315    -2.936     0.200
     2.127    -5.826     0.200
    11.308    -2.514     0.200
     2.091    -6.008     0.200
    11.334     2.042     0.200
     2.210    -6.596     0.200
     2.551    -3.547     0.200
     3.426    -2.656     0.200
    11.278    -1.764     0.200
     2.100    -5.442     0.200
     2.462    -5.843     0.200
    11.203    -2.414     0.200
     2.457    -5.067     0.200
     2.828    -5.221     0.200
    10.594    -2.610     0.200
     3.257    -1.957     0.200
     2.115    -4.999     0.200
    11.447    -1.977     0.200
     2.141    -6.005     0.200
    11.150    -6.521     0.200
    11.308    -5.622     0.200
     2.057    -5.607     0.200
     2.057    -3.607     0.200
     3.849    -5.301     0.200
    11.231    -4.304     0.200
     2.486    -3.366     0.200
     2.905    -5.607     0.200
     2.905    -1.957     0.200
     7.926    -7.487     0.200
     8.922   -15.582     0.200
    10.652    -8.434     0.200
    16.373   -11.085     0.200
    18.552     3.214     0.200
    23.271     6.323     0.200
    24.488     6.401     0.200
    31.385     5.701     0.200
    32.216   -15.797     0.200
     2.226    -4.716     0.200
     7.695    -7.449     0.200
    11.242    -1.979     0.200
     2.715    -4.852     0.200
    10.456     4.765     0.200
     2.032    -6.540     0.200
     2.032    -4.540     0.200
     2.072    -4.337     0.200
     3.594   -10.948     0.200
     2.695    -6.791     0.200
     2.148    -5.898     0.200
    11.368    -5.534     0.200
     7.476   -11.098     0.200
    10.918     2.549     0.200
     7.118   -15.696     0.200
    11.271    -7.633     0.200
    17.203     4.746     0.200
    10.765    -4.330     0.200
    16.598   -12.310     0.200
     2.445    -6.121     0.200
    11.261    -5.263     0.200
    12.309   -10.572     0.200
    17.129    -4.495     0.200
     7.904   -10.024     0.200
    10.903    -3.043     0.200
     7.203    -8.097     0.200
     3.038    -8.482     0.200
     3.265    -8.199     0.200
     7.019    -3.936     0.200
    11.363    -4.937     0.200
    24.315     0.906     0.200
    25.243    -8.537     0.200
    32.253    -8.202     0.200
    45.110   -27.133     0.200
     3.856    -6.712     0.200
     4.268    -6.073     0.200
     8.707   -10.564     0.200
    10.714    -1.680     0.200
    13.340    -7.475     0.200
    16.466    -5.247     0.200
    24.151    -3.855     0.200
    24.591     2.529     0.200
     7.466    -9.281     0.200
     8.214    -4.406     0.200
    11.042    -6.243     0.200
    10.751    -1.810     0.200
    13.463    -4.487     0.200
     4.092    -4.897     0.200
     4.768    -3.376     0.200
     7.208    -9.940     0.200
    11.361    -7.261     0.200
     2.439    -4.812     0.200
     2.877    -5.440     0.200
     2.504    -2.526     0.200
     2.901    -3.531     0.200
     2.930    -3.395     0.200
     3.181    -2.752     0.200
     3.724    -2.575     0.200
     3.771    -1.200     0.200
     4.299    -3.023     0.200
     4.405    -2.091     0.200
     4.489    -3.771     0.200
     7.879    -4.268     0.200
     8.230   -12.346     0.200
    11.032    -3.968     0.200
    16.843     4.020     0.200
     9.160   -13.724     0.200
    10.176    -3.967     0.200
    15.874     3.876     0.200
     2.025    -4.657     0.200
     3.326    -3.357     0.200
     3.973    -3.470     0.200
     2.267    -6.005     0.200
     2.934    -5.594     0.200
     7.548    -7.374     0.200
    11.197    -4.264     0.200
    12.157    -3.846     0.200
     2.281    -5.358     0.200
     8.261    -3.984     0.200
    10.984    -3.628     0.200
    16.792     1.053     0.200
     7.968    -7.333     0.200
    10.798    -4.900     0.200
    16.649    -7.555     0.200
     2.410    -1.334     0.200
     2.925    -5.698     0.200
     2.900    -4.291     0.200
     2.391    -7.287     0.200
     8.157    -0.600     0.200
    10.955    -5.650     0.200
     2.838    -7.150     0.200
     2.063    -5.392     0.200
     2.515    -4.258     0.200
     2.841    -3.335     0.200
     3.305    -0.180     0.200
    11.260    -0.805     0.200
     2.111    -5.014     0.200
     2.130    -5.344     0.200
     2.910    -5.710     0.200
     2.910    -7.611     0.200
     7.944    -6.938     0.200
     2.920    -8.877     0.200
     2.709    -5.445     0.200
     3.806    -5.757     0.200
    10.786    -6.907     0.200
     2.159    -5.264     0.200
     2.058    -6.073     0.200
    11.049    -6.678     0.200
     2.029    -6.057     0.200
     2.318    -6.733     0.200
    10.993    -5.934     0.200
    16.818    -2.601     0.200
     2.528    -5.393     0.200
     2.965    -8.542     0.200
     3.283    -9.914     0.200
     3.400   -10.527     0.200
     2.118    -5.494     0.200
     2.155    -4.651     0.200
     2.703    -5.306     0.200
     2.722    -5.778     0.200
     2.854    -3.293     0.200
     2.872    -5.046     0.200
     2.948    -4.852     0.200
    10.183    -1.861     0.200
     2.082    -4.789     0.200
     2.408    -3.041     0.200
     2.604    -4.385     0.200
     3.046    -4.236     0.200
     3.036    -4.774     0.200
     8.096    -8.809     0.200
    11.056    -5.429     0.200
     2.424    -2.266     0.200
     2.434    -4.612     0.200
     2.742    -6.044     0.200
     2.874    -8.921     0.200
     2.137    -6.199     0.200
     2.394    -3.252     0.200
     2.656    -4.916     0.200
     2.414    -4.838     0.200
     2.559    -6.903     0.200
     2.785    -4.610     0.200
    11.429    -0.237     0.200
     2.412    -3.713     0.200
     2.622    -4.585     0.200
     2.017    -4.909     0.200
     2.429    -3.129     0.200
     2.815    -4.631     0.200
     2.197    -4.528     0.200
     8.202    -2.364     0.200
    10.968    -1.254     0.200
    16.784     4.539     0.200
     2.110    -5.596     0.200
     2.991    -7.585     0.200
     2.234    -5.533     0.200
     2.178    -5.507     0.200
     2.568    -2.382     0.200
     7.477    -1.763     0.200
    11.377    -4.457     0.200
     2.000    -6.472     0.200
     2.343    -6.471     0.200
     3.017    -2.398     0.200
     3.387    -3.664     0.200
     2.446    -3.356     0.200
     2.559    -3.619     0.200
     2.801    -8.131     0.200
     2.837    -7.819     0.200
     2.893    -7.687     0.200
     2.096    -4.370     0.200
     2.150    -6.685     0.200
     2.844    -7.648     0.200
     2.906    -9.366     0.200
     2.195    -5.616     0.200
     2.805    -3.986     0.200
     2.080    -5.869     0.200
     2.890    -6.450     0.200
     3.258   -10.196     0.200
     2.139    -5.591     0.200
     2.113    -3.389     0.200
     2.593    -7.879     0.200
     2.798    -8.089     0.200
     2.632    -4.752     0.200
     2.301    -5.482     0.200
     2.353    -6.134     0.200
     2.159    -6.700     0.200
     3.201    -9.824     0.200
     2.630    -4.651     0.200
     2.969    -3.483     0.200
     3.164    -4.566     0.200
     3.259    -4.090     0.200
     2.424    -4.596     0.200
     2.464    -6.824     0.200
     2.614    -5.162     0.200
     3.102    -8.159     0.200
     3.218   -10.220     0.200
     3.249   -10.050     0.200
     2.478    -3.334     0.200
     2.390    -1.724     0.200
     2.855    -3.847     0.200
     8.276    -1.675     0.200
    11.005     0.219     0.200
     2.853    -5.236     0.200
     8.797   -13.650     0.200
    10.777    -3.195     0.200
    16.513    -0.303     0.200
     2.914    -4.736     0.200
     3.264    -3.789     0.200
     3.265    -4.088     0.200
     3.413    -2.886     0.200
     3.518    -6.340     0.200
     3.690    -4.212     0.200
     2.669    -5.024     0.200
     3.003    -7.246     0.200
     2.084    -4.923     0.200
     2.306    -6.342     0.200
     2.754    -4.362     0.200
     6.955    -1.794     0.200
    11.344     1.242     0.200
    11.565    -4.592     0.200
     2.576    -7.082     0.200
     2.213    -3.927     0.200
     2.599    -4.919     0.200
     2.853    -6.278     0.200
     2.913    -7.355     0.200
     2.882    -6.641     0.200
     2.204    -5.826     0.200
     2.036    -4.882     0.200
     2.482    -1.764     0.200
     2.546    -3.855     0.200
     9.890    -0.903     0.200
     2.040    -5.636     0.200
     2.148    -4.529     0.200
    10.789    -4.801     0.200
     2.909    -3.066     0.200
     8.176     0.531     0.200
    10.944     2.721     0.200
     2.439    -2.403     0.200
     2.893    -4.114     0.200
     2.215    -5.893     0.200
    12.277   -13.702     0.200
     2.967    -5.850     0.200
     3.243    -7.028     0.200
     2.041    -5.045     0.200
     2.422    -5.436     0.200
     2.431    -4.191     0.200
     2.792    -4.527     0.200
     3.857    -6.529     0.200
     2.556    -2.315     0.200
     3.005    -5.379     0.200
     3.174    -5.275     0.200
     3.200    -5.031     0.200
     2.176    -5.557     0.200
     2.479    -3.799     0.200
     3.403   -10.568     0.200
     3.553   -11.274     0.200
     3.898    -0.421     0.200
     4.059    -7.720     0.200
     4.095    -4.770     0.200
     2.237    -7.196     0.200
     8.149    -9.271     0.200
    10.727    -3.588     0.200
    16.557   -10.325     0.200
     2.350    -5.252     0.200
     2.226    -4.680     0.200
     2.885    -5.994     0.200
     2.389    -4.298     0.200
    11.274    -6.423     0.200
    17.168   -14.746     0.200
     2.668    -4.424     0.200
     2.572    -3.908     0.200
     2.835    -3.370     0.200
     2.940    -4.925     0.200
     7.065    -5.558     0.200
     2.473    -4.903     0.200
     2.589    -4.290     0.200
     2.617    -5.550     0.200
     2.149    -5.604     0.200
     2.610    -5.089     0.200
     2.814    -6.085     0.200
     7.391    -5.899     0.200
     9.940    -0.602     0.200
     2.830    -5.175     0.200
     3.453    -6.118     0.200
     7.915    -9.421     0.200
    11.224    -7.327     0.200
     2.374    -5.317     0.200
     2.005    -6.432     0.200
     2.733    -8.364     0.200
     2.805    -8.066     0.200
     2.784    -8.372     0.200
     3.100    -8.379     0.200
     3.237    -9.419     0.200
     3.243    -8.979     0.200
     3.274   -10.610     0.200
     3.274    -9.280     0.200
     3.295    -8.659     0.200
     3.429   -10.216     0.200
     3.513   -10.231     0.200
     3.581   -10.425     0.200
     3.678   -11.799     0.200
     2.544    -6.081     0.200
     2.593    -6.800     0.200
     2.847    -1.026     0.200
     2.395    -7.280     0.200
     2.795    -6.652     0.200
     7.712    -6.311     0.200
    10.956    -6.649     0.200
     2.019    -5.468     0.200
     2.673    -7.501     0.200
     2.777    -7.163     0.200
     2.796    -8.802     0.200
     3.146    -9.784     0.200
     3.331   -10.313     0.200
     3.366   -10.702     0.200
     2.137    -5.370     0.200
     3.082    -4.748     0.200
     8.029    -3.643     0.200
    11.062    -4.395     0.200
     3.308    -5.378     0.200
     3.477    -4.933     0.200
     4.132    -1.104     0.200
     4.497    -4.826     0.200
     4.535    -3.708     0.200
     8.648   -12.089     0.200
    10.845    -1.752     0.200
    16.602    -2.873     0.200
     2.391    -4.619     0.200
     2.718    -3.609     0.200
     3.144    -4.093     0.200
     3.570    -5.645     0.200
     4.634    -5.391     0.200
     8.003    -7.857     0.200
    11.141   -13.079     0.200
     2.370    -5.909     0.200
     2.765    -4.470     0.200
     7.953   -10.235     0.200
    11.167    -7.456     0.200
     2.328    -6.036     0.200
     2.336    -5.673     0.200
     3.985    -7.001     0.200
     4.110    -6.274     0.200
     5.580    -8.708     0.200
    11.103    -7.873     0.200
    16.945    -9.212     0.200
     2.340    -4.804     0.200
    10.945    -9.503     0.200
    16.729   -11.666     0.200
    23.752    -3.342     0.200
    24.863    -4.892     0.200
    11.142    -3.286     0.200
    16.989    -3.138     0.200
     2.609    -4.216     0.200
     2.852    -2.994     0.200
     8.024    -8.008     0.200
    11.010    -6.670     0.200
    16.848    -6.456     0.200
     2.638    -6.179     0.200
     2.370    -4.800     0.200
     3.066    -3.637     0.200
     3.946    -5.599     0.200
    11.167    -8.298     0.200
    17.016    -8.911     0.200
    19.523     1.475     0.200
    24.194    -0.315     0.200
    24.846    -3.834     0.200
    25.167    -1.356     0.200
    28.888     0.593     0.200
     2.770    -5.464     0.200
     3.001    -3.375     0.200
     3.434    -5.682     0.200
     3.394    -3.644     0.200
     2.251    -4.264     0.200
     8.514    -3.529     0.200
    16.666    -6.840     0.200
     2.102    -5.128     0.200
     2.623    -5.310     0.200
    11.070    -8.228     0.200
     2.404    -3.245     0.200
     8.113   -10.408     0.200
    11.029    -1.522     0.200
     2.164    -6.093     0.200
     2.346    -5.488     0.200
     2.725    -6.077     0.200
     2.795    -7.372     0.200
     3.446    -9.657     0.200
     2.380    -6.512     0.200
     2.643    -4.367     0.200
     3.522    -5.423     0.200
     2.616    -4.878     0.200
     3.394    -5.666     0.200
     2.016    -4.879     0.200
     2.398    -1.140     0.200
     8.228    -9.519     0.200
    10.871    -2.349     0.200
    16.685    -1.697     0.200
    10.935    -4.792     0.200
     7.926   -11.933     0.200
    11.014    -7.372     0.200
    16.864    -8.931     0.200
     2.496    -4.031     0.200
     2.321    -6.611     0.200
     3.181    -5.376     0.200
     3.325    -6.009     0.200
     7.684    -4.867     0.200
     9.772     3.130     0.200
     2.418    -2.485     0.200
     2.287    -6.280     0.200
     2.827    -3.303     0.200
     3.597    -5.750     0.200
     2.256    -5.207     0.200
     2.616    -4.873     0.200
     2.719    -3.475     0.200
     3.023    -2.848     0.200
     3.120    -4.226     0.200
     2.178    -5.024     0.200
     2.421    -3.968     0.200
     2.395    -4.323     0.200
     2.415    -4.451     0.200
     2.216    -4.999     0.200
     2.458    -4.954     0.200
     2.356    -3.497     0.200
     3.012    -5.840     0.200
     3.233    -7.675     0.200
     3.376    -3.885     0.200
     2.852    -5.909     0.200
     3.007    -4.890     0.200
     2.982    -4.959     0.200
     3.069    -6.341     0.200
     3.172    -7.340     0.200
     3.203    -5.015     0.200
     3.235    -6.940     0.200
     3.278    -5.324     0.200
     7.645    -7.130     0.200
     9.869    -3.616     0.200
     2.071    -6.432     0.200
     2.094    -5.212     0.200
     2.164    -4.895     0.200
     2.417    -3.701     0.200
     3.065    -7.125     0.200
     3.174    -6.415     0.200
     3.212    -5.368     0.200
     3.321    -5.733     0.200
     7.640    -5.377     0.200
     9.806    -0.819     0.200
     2.089    -5.778     0.200
     2.957    -5.509     0.200
     8.014    -2.908     0.200
    10.932    -3.564     0.200
    16.773    -6.174     0.200
     2.157    -5.453     0.200
     2.626    -3.464     0.200
     2.338    -5.003     0.200
     2.856    -3.805     0.200
     3.491    -8.129     0.200
    10.725    -0.279     0.200
     2.053    -5.257     0.200
     8.035   -14.865     0.200
     2.459    -4.546     0.200
     3.106    -5.620     0.200
     3.279    -5.084     0.200
     2.365    -6.189     0.200
     2.515    -3.400     0.200
     2.940    -3.858     0.200
     2.435    -5.104     0.200
     3.013    -5.166     0.200
     3.122    -6.763     0.200
     2.382    -4.581     0.200
     2.861    -6.548     0.200
     2.907    -5.348     0.200
     3.034    -6.061     0.200
     3.155    -7.068     0.200
     3.276    -5.385     0.200
     3.236    -4.946     0.200
     3.283    -5.289     0.200
     2.800    -2.180     0.200
     2.951    -5.415     0.200
     3.159    -2.813     0.200
     3.268    -5.500     0.200
     3.835    -2.032     0.200
     2.180    -7.005     0.200
     2.170    -4.804     0.200
     2.444    -4.667     0.200
     7.551    -4.943     0.200
     9.757     0.395     0.200
    15.702    -4.415     0.200
     2.172    -5.070     0.200
     2.352    -4.360     0.200
     7.572    -2.127     0.200
     9.764    -0.917     0.200
     2.949    -6.749     0.200
     3.098    -5.716     0.200
     7.570    -7.424     0.200
     9.761    -0.177     0.200
    15.703     1.138     0.200
     2.406    -5.197     0.200
     2.431    -5.033     0.200
     3.024    -4.537     0.200
     2.986    -5.321     0.200
    10.861     1.680     0.200
     2.382    -4.454     0.200
     2.439    -5.168     0.200
     2.511    -4.055     0.200
     2.166    -6.620     0.200
     2.044    -4.858     0.200
     2.398    -3.844     0.200
     2.429    -4.294     0.200
     3.107    -5.158     0.200
     3.274    -3.888     0.200
     8.130   -10.289     0.200
    11.178    -8.958     0.200
    16.998   -10.028     0.200
     2.526    -5.362     0.200
     2.215    -5.563     0.200
     7.587    -5.344     0.200
    11.328    -5.815     0.200
    17.209    -9.705     0.200
     2.283    -5.040     0.200
     2.367    -6.494     0.200
     2.139    -5.249     0.200
     2.340    -4.757     0.200
     3.192    -7.423     0.200
     2.445    -4.561     0.200
     2.518    -4.788     0.200
     3.071    -3.714     0.200
     3.118    -4.052     0.200
     2.349    -4.271     0.200
     2.370    -5.447     0.200
     3.221    -4.964     0.200
     2.451    -3.805     0.200
     2.909    -3.233     0.200
     3.246    -5.742     0.200
     2.048    -4.640     0.200
     2.102    -5.013     0.200
     2.405    -5.036     0.200
     2.640    -6.083     0.200
     2.797    -4.958     0.200
     3.110    -5.187     0.200
     2.352    -3.969     0.200
     2.974    -4.573     0.200
     3.381    -3.022     0.200
     3.935    -4.462     0.200
     4.003    -5.907     0.200
     4.378    -3.789     0.200
     4.395    -4.115     0.200
     4.421    -4.915     0.200
     4.486    -4.319     0.200
     4.517    -3.630     0.200
     4.534    -3.529     0.200
     4.586    -4.874     0.200
     4.684    -5.454     0.200
     4.857    -5.995     0.200
     5.058    -4.446     0.200
     8.441    -2.938     0.200
    11.107    -3.569     0.200
     2.088    -4.824     0.200
     2.780    -4.062     0.200
     2.979    -5.359     0.200
     3.451    -5.211     0.200
     2.817    -1.742     0.200
     3.156    -4.847     0.200
     3.116    -4.873     0.200
     2.601    -6.071     0.200
     7.168    -3.336     0.200
     2.236    -5.440     0.200
     2.389    -4.323     0.200
     2.505    -4.432     0.200
     2.773    -5.916     0.200
     2.176    -5.106     0.200
     2.368    -4.996     0.200
     2.693    -8.541     0.200
     2.413    -4.452     0.200
     8.892    -7.559     0.200
    10.760    -1.256     0.200
    16.483     1.195     0.200
     2.430    -3.705     0.200
     2.715    -4.222     0.200
     8.350   -10.604     0.200
    11.127    -4.874     0.200
     2.687    -5.483     0.200
     3.157    -7.815     0.200
     3.239    -6.444     0.200
     2.424    -6.626     0.200
     2.663    -4.762     0.200
     2.011    -4.281     0.200
     2.221    -5.611     0.200
     2.252    -4.705     0.200
     2.913    -6.471     0.200
     2.194    -4.725     0.200
     2.257    -4.876     0.200
     2.367    -6.076     0.200
     2.465    -4.936     0.200
     2.770    -6.540     0.200
     2.817    -8.519     0.200
     8.731    -9.397     0.200
     9.922    -6.793     0.200
     2.064    -4.463     0.200
     2.242    -4.353     0.200
     2.597    -4.533     0.200
     2.287    -7.041     0.200
     2.893    -3.632     0.200
     3.361    -5.691     0.200
     3.501    -3.990     0.200
     4.248    -4.697     0.200
     2.661    -6.992     0.200
     3.005    -5.254     0.200
     3.122    -5.516     0.200
     3.239    -6.030     0.200
     2.172    -5.452     0.200
     2.461    -7.648     0.200
     2.949    -9.017     0.200
     2.179    -6.456     0.200
     2.593    -4.141     0.200
     3.080    -9.188     0.200
     2.159    -5.008     0.200
     2.212    -5.129     0.200
     3.000    -7.054     0.200
     2.097    -5.840     0.200
     2.457    -4.565     0.200
     2.763    -4.988     0.200
     2.724    -2.138     0.200
     2.425    -3.536     0.200
     2.473    -3.194     0.200
     2.487    -2.934     0.200
     2.943    -3.933     0.200
     3.107    -0.921     0.200
     7.625    -9.299     0.200
     9.759    -6.935     0.200
     2.409    -4.881     0.200
     2.711    -6.461     0.200
     2.571    -7.869     0.200
     2.703    -6.959     0.200
     7.103    -3.160     0.200
    10.731    -1.306     0.200
     2.599    -4.892     0.200
     2.913    -0.761     0.200
     2.962    -5.491     0.200
     2.989    -0.399     0.200
     3.221    -1.179     0.200
     3.224    -4.320     0.200
     3.236    -4.602     0.200
     2.498    -3.796     0.200
     2.025    -6.138     0.200
     3.046    -5.127     0.200
     2.096    -4.521     0.200
     2.389    -4.996     0.200
     2.585    -7.228     0.200
     2.632    -5.427     0.200
     2.703    -7.072     0.200
     2.343    -5.669     0.200
     2.275    -4.642     0.200
     2.385    -5.219     0.200
     2.607    -4.948     0.200
     2.147    -5.169     0.200
     2.384    -6.757     0.200
     2.394    -4.709     0.200
     2.409    -4.123     0.200
     2.502    -4.864     0.200
     2.516    -4.362     0.200
     3.047    -6.792     0.200
     3.152    -0.183     0.200
     3.204    -2.502     0.200
     3.387    -3.078     0.200
    10.831     3.026     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.900    -8.398     0.200
     4.208   -21.536     0.200
     6.738   -35.752     0.200
    14.817   -95.865     0.200
    16.481  -112.600     0.200
    18.398  -131.379     0.200
    22.454  -162.192     0.200
     2.365   -12.418     0.200
     2.783   -15.059     0.200
    12.592   -80.024     0.200
    17.252  -120.727     0.200
    21.296  -145.928     0.200
     1.670    -6.137     0.200
     5.386   -37.938     0.200
     6.679   -34.948     0.200
    15.159   -95.741     0.200
    17.169  -115.482     0.200
    23.338  -173.038     0.200
     2.578   -10.336     0.200
     6.257   -32.947     0.200
    13.143   -80.252     0.200
    18.933  -129.792     0.200
     2.654   -10.416     0.200
    15.762  -101.935     0.200
    20.861  -142.586     0.200
    18.603  -131.173     0.200
    23.339  -169.916     0.200
     4.339   -13.207     0.200
    17.983  -125.709     0.200
    21.975  -155.339     0.200
    18.756  -129.352     0.200
    21.383  -147.647     0.200
     3.297   -16.217     0.200
     7.019   -41.017     0.200
    10.109   -65.178     0.200
     2.613   -13.345     0.200
     3.149   -18.556     0.200
     3.882   -26.562     0.200
     6.271   -40.274     0.200
     5.723   -25.026     0.200
    24.213  -176.296     0.200
     3.768   -17.576     0.200
     3.880   -17.108     0.200
     4.781   -30.686     0.200
     3.342   -16.294     0.200
     3.832   -16.826     0.200
     4.062   -21.925     0.200
     4.074   -23.308     0.200
     5.130   -35.794     0.200
     6.265   -41.768     0.200
     3.666   -16.947     0.200
     3.679   -17.882     0.200
     4.722   -30.452     0.200
    10.718   -67.058     0.200
     1.229    -2.620     0.200
     2.722   -12.899     0.200
    21.161  -143.623     0.200
     3.299   -13.835     0.200
     1.973    -4.488     0.200
     3.841   -14.972     0.200
     1.393    -3.730     0.200
     2.340   -19.561     0.200
     2.404   -13.602     0.200
     3.558   -16.174     0.200
     3.612   -18.899     0.200
     4.006   -22.865     0.200
     4.465   -23.432     0.200
     4.757   -28.881     0.200
     5.270   -29.450     0.200
     5.628   -32.294     0.200
     6.360   -35.809     0.200
     1.118     0.293     0.200
     3.432   -20.063     0.200
     3.391   -16.759     0.200
     4.513   -18.732     0.200
     4.889   -32.166     0.200
     4.905   -22.697     0.200
     6.753   -31.756     0.200
     2.412    -8.608     0.200
     3.782   -20.021     0.200
     3.816   -18.619     0.200
     4.110   -18.640     0.200
     4.593   -23.224     0.200
     1.601    -1.117     0.200
     3.031   -10.447     0.200
     3.480   -17.686     0.200
     3.420   -14.802     0.200
     3.770   -18.904     0.200
     6.144   -38.630     0.200
     0.463    11.188     0.200
     2.356    -7.321     0.200
     3.901   -24.486     0.200
     5.987   -41.902     0.200
     7.991   -56.948     0.200
     1.423    -5.135     0.200
     1.682    -3.250     0.200
     2.369   -10.031     0.200
     2.692   -10.274     0.200
     3.122   -17.693     0.200
     3.513   -16.505     0.200
     3.655   -12.504     0.200
     3.679   -18.852     0.200
     3.816   -17.118     0.200
     3.845   -17.712     0.200
     3.852   -15.949     0.200
     4.151   -14.827     0.200
     9.859   -58.458     0.200
    11.196   -72.853     0.200
    19.664  -137.287     0.200
     2.686   -11.770     0.200
     3.116   -14.382     0.200
     3.268   -14.203     0.200
     3.562   -14.616     0.200
     3.699   -18.456     0.200
     3.744   -14.292     0.200
     3.756   -13.671     0.200
     3.865   -16.337     0.200
     3.896   -18.621     0.200
     4.170   -21.294     0.200
     4.203   -17.644     0.200
     1.113    -3.601     0.200
     2.383    -9.462     0.200
     3.064   -12.005     0.200
     3.286   -13.964     0.200
     3.411   -15.527     0.200
     3.486   -18.129     0.200
     3.609   -16.218     0.200
     3.626   -18.466     0.200
     3.935   -19.245     0.200
     1.799    -6.536     0.200
     2.521    -8.927     0.200
     2.951   -14.752     0.200
     3.086   -15.319     0.200
     3.389   -17.830     0.200
     3.539   -17.077     0.200
     3.570   -17.176     0.200
     3.586   -15.169     0.200
     3.693   -15.261     0.200
     3.991   -17.024     0.200
     1.157     1.242     0.200
     2.417   -10.352     0.200
     2.607   -10.874     0.200
     2.846   -13.226     0.200
     3.522   -13.458     0.200
     3.528   -17.458     0.200
     5.114   -23.543     0.200
     5.705   -31.260     0.200
     6.360   -35.554     0.200
     0.553     7.803     0.200
     1.549    -3.645     0.200
     1.860    -5.677     0.200
     2.087    -9.225     0.200
     3.516   -16.489     0.200
     3.750   -17.896     0.200
     3.760   -19.939     0.200
     3.782   -16.769     0.200
     3.792   -18.016     0.200
     3.885   -19.176     0.200
     4.184   -21.313     0.200
     4.249   -19.509     0.200
     4.298   -21.492     0.200
     4.298   -18.072     0.200
     4.564   -18.173     0.200
     5.213   -32.185     0.200
     5.480   -29.502     0.200
     6.396   -38.159     0.200
     6.402   -34.524     0.200
    12.835   -80.454     0.200
    21.893  -161.835     0.200
     1.217    -3.470     0.200
     2.488    -9.825     0.200
     2.667    -9.902     0.200
     2.964   -12.683     0.200
     2.918   -15.097     0.200
     3.046   -10.665     0.200
     3.147   -13.433     0.200
     3.276   -12.666     0.200
     3.437   -16.062     0.200
     3.471   -13.196     0.200
     3.611   -15.236     0.200
     3.887   -15.712     0.200
     3.887   -15.330     0.200
     3.952   -18.292     0.200
     4.280   -18.731     0.200
     5.714   -25.945     0.200
     2.731   -11.132     0.200
     3.296   -13.654     0.200
     3.392   -13.738     0.200
     3.911   -19.174     0.200
     2.965    -7.252     0.200
     4.037   -14.895     0.200
     4.321   -17.653     0.200
     4.338   -17.581     0.200
     4.438   -17.264     0.200
     4.467   -20.861     0.200
     4.588   -18.994     0.200
     4.744   -18.988     0.200
     4.778   -19.290     0.200
     4.781   -19.314     0.200
     4.844   -19.664     0.200
     4.881   -18.355     0.200
     4.935   -19.305     0.200
     5.169   -21.951     0.200
     5.243   -24.586     0.200
     5.271   -23.354     0.200
     5.271   -20.831     0.200
     6.448   -32.049     0.200
     7.259   -38.679     0.200
     2.419    -8.648     0.200
     2.468   -10.567     0.200
     2.746   -12.842     0.200
     2.849   -13.834     0.200
     2.946   -10.634     0.200
     3.064   -12.418     0.200
     3.288   -13.483     0.200
     3.432   -14.097     0.200
     3.469   -14.123     0.200
     3.487   -13.368     0.200
     3.568   -13.287     0.200
     3.627   -16.157     0.200
     3.840   -15.102     0.200
     3.886   -18.102     0.200
     4.562   -23.649     0.200
     4.701   -19.350     0.200
     5.661   -28.757     0.200
     6.069   -29.157     0.200
     6.595   -38.409     0.200
     7.761   -42.161     0.200
    10.135   -60.427     0.200
    19.686  -130.173     0.200
     2.366   -11.753     0.200
     2.795   -15.121     0.200
     2.791   -12.416     0.200
     2.870   -11.824     0.200
     2.985   -10.873     0.200
     3.098   -12.687     0.200
     3.209   -11.917     0.200
     3.354   -12.860     0.200
     3.390   -12.913     0.200
     3.408   -12.429     0.200
     3.489   -14.646     0.200
     3.503   -15.356     0.200
     3.548   -15.277     0.200
     3.761   -17.328     0.200
     3.807   -19.803     0.200
     3.807   -17.291     0.200
     3.807   -15.272     0.200
     3.885   -19.150     0.200
     5.601   -30.365     0.200
     1.108    -1.988     0.200
     2.378    -9.257     0.200
     2.808   -14.349     0.200
     2.788    -9.389     0.200
     2.919   -11.913     0.200
     3.050   -12.073     0.200
     3.166   -12.460     0.200
     3.272   -13.345     0.200
     3.410   -14.333     0.200
     3.452   -14.538     0.200
     3.473   -13.383     0.200
     3.548   -14.135     0.200
     3.569   -14.906     0.200
     3.613   -16.585     0.200
     3.821   -18.926     0.200
     3.864   -17.401     0.200
     3.864   -16.197     0.200
     3.948   -15.651     0.200
     4.522   -23.827     0.200
     6.556   -38.463     0.200
     2.487    -8.952     0.200
     2.487    -8.730     0.200
     2.689   -10.338     0.200
     2.917   -13.377     0.200
     3.038   -11.142     0.200
     3.158   -11.956     0.200
     3.563   -15.469     0.200
     3.582   -15.778     0.200
     3.663   -16.307     0.200
     3.675   -18.751     0.200
     3.722   -15.545     0.200
     3.934   -17.559     0.200
     3.980   -18.537     0.200
     3.980   -18.092     0.200
     3.980   -17.381     0.200
     4.059   -17.802     0.200
     4.634   -23.113     0.200
     5.119   -25.063     0.200
     5.751   -26.449     0.200
     2.404    -8.409     0.200
     2.519   -10.096     0.200
     2.834   -13.031     0.200
     3.094   -12.195     0.200
     3.210   -13.627     0.200
     3.316   -12.248     0.200
     3.452   -15.484     0.200
     3.495   -15.418     0.200
     3.591   -16.182     0.200
     3.613   -14.480     0.200
     3.657   -16.389     0.200
     3.865   -18.012     0.200
     3.907   -18.147     0.200
     3.907   -17.976     0.200
     3.907   -15.905     0.200
     3.992   -18.644     0.200
     4.141   -18.959     0.200
     4.550   -20.011     0.200
     4.754   -21.163     0.200
     5.043   -24.187     0.200
     5.667   -31.235     0.200
     2.453    -8.892     0.200
     2.627   -11.778     0.200
     2.981   -14.678     0.200
     3.092   -12.344     0.200
     3.199   -13.057     0.200
     3.304   -14.233     0.200
     3.714   -16.802     0.200
     3.763   -17.175     0.200
     3.980   -15.852     0.200
     4.029   -15.958     0.200
     4.102   -16.734     0.200
     4.266   -18.070     0.200
     5.171   -28.510     0.200
     5.812   -32.529     0.200
     2.844   -13.361     0.200
     3.558   -15.315     0.200
     3.617   -15.105     0.200
     3.876   -17.253     0.200
     3.876   -14.944     0.200
     4.693   -17.846     0.200
     5.662   -30.758     0.200
    10.373   -63.271     0.200
     1.321    -3.340     0.200
     1.560    -5.338     0.200
     1.908    -6.593     0.200
     2.406    -7.556     0.200
     2.469    -9.132     0.200
     2.662   -11.175     0.200
     2.877   -13.188     0.200
     2.851   -11.932     0.200
     2.851   -11.721     0.200
     2.907   -11.720     0.200
     3.239   -12.195     0.200
     3.326   -13.745     0.200
     3.333   -13.687     0.200
     3.594   -16.126     0.200
     4.494   -22.705     0.200
     4.510   -20.207     0.200
     5.418   -28.051     0.200
     7.101   -37.221     0.200
     1.259    -4.440     0.200
     2.530   -10.468     0.200
     2.960   -16.300     0.200
     3.027   -12.453     0.200
     3.114   -12.126     0.200
     3.344   -14.714     0.200
     3.425   -14.937     0.200
     3.481   -15.606     0.200
     3.503   -15.110     0.200
     3.526   -14.870     0.200
     3.538   -16.966     0.200
     3.633   -14.717     0.200
     3.900   -16.827     0.200
     3.953   -17.669     0.200
     3.953   -16.849     0.200
     4.671   -24.195     0.200
     5.761   -31.640     0.200
     5.768   -35.607     0.200
     6.704   -35.094     0.200
     2.342    -8.636     0.200
     2.772   -12.392     0.200
     2.844    -9.562     0.200
     3.330   -11.450     0.200
     3.366   -12.493     0.200
     3.366   -12.053     0.200
     3.465   -15.462     0.200
     3.481   -15.774     0.200
     5.576   -28.109     0.200
     7.308   -40.823     0.200
     2.190    -7.999     0.200
     2.821    -8.499     0.200
     2.996    -9.686     0.200
     4.339   -23.768     0.200
     6.375   -34.782     0.200
     1.994    -6.351     0.200
     2.634   -13.108     0.200
     2.777   -11.561     0.200
     3.906   -18.703     0.200
     4.268   -21.828     0.200
     4.265   -20.019     0.200
     4.596   -23.198     0.200
     4.667   -24.936     0.200
     5.092   -28.393     0.200
     6.044   -36.554     0.200
     7.096   -39.769     0.200
     1.102    -2.140     0.200
     1.529    -3.284     0.200
     1.762    -3.627     0.200
     1.801    -5.460     0.200
     2.367   -11.261     0.200
     2.785   -12.834     0.200
     2.795   -13.861     0.200
     2.775   -13.010     0.200
     3.240   -14.933     0.200
     4.490   -26.506     0.200
     5.543   -31.182     0.200
     1.853    -5.800     0.200
     2.090    -8.203     0.200
     2.672   -10.488     0.200
     2.668    -9.858     0.200
     3.252   -12.621     0.200
     5.345   -27.268     0.200
     7.091   -42.363     0.200
     1.437    -2.783     0.200
     2.323    -7.200     0.200
     2.461    -7.828     0.200
     2.707   -10.241     0.200
     3.137   -13.732     0.200
     3.199   -14.667     0.200
     3.678   -15.259     0.200
     3.678   -14.087     0.200
     4.055   -16.820     0.200
     4.115   -18.702     0.200
     4.115   -16.319     0.200
     4.115   -16.077     0.200
     4.357   -21.541     0.200
     4.850   -21.625     0.200
     5.266   -27.306     0.200
     5.368   -25.646     0.200
     5.941   -27.758     0.200
     5.949   -28.525     0.200
     1.719    -4.456     0.200
     2.538    -8.798     0.200
     3.230   -16.197     0.200
     3.656   -20.127     0.200
     3.833   -17.017     0.200
     4.139   -18.568     0.200
     4.285   -17.403     0.200
     4.310   -22.881     0.200
     4.323   -19.821     0.200
     4.466   -20.342     0.200
     4.760   -22.283     0.200
     4.760   -20.900     0.200
     4.760   -18.751     0.200
     4.851   -29.073     0.200
     5.861   -36.031     0.200
     6.529   -38.273     0.200
     6.537   -34.934     0.200
     8.277   -47.547     0.200
     1.276    -2.589     0.200
     1.603    -3.838     0.200
     2.267    -8.760     0.200
     2.477   -12.876     0.200
     2.681   -13.463     0.200
     3.111   -17.737     0.200
     3.137   -14.757     0.200
     3.137   -14.429     0.200
     3.420   -15.854     0.200
     3.569   -17.313     0.200
     3.598   -18.082     0.200
     3.598   -14.825     0.200
     3.604   -19.201     0.200
     3.608   -17.061     0.200
     3.748   -18.213     0.200
     4.045   -19.842     0.200
     4.045   -19.217     0.200
     4.045   -18.920     0.200
     4.532   -23.566     0.200
     4.532   -19.738     0.200
     5.301   -28.149     0.200
     5.903   -31.492     0.200
     1.548    -5.986     0.200
     2.390   -10.506     0.200
     2.812   -13.182     0.200
     3.242   -19.441     0.200
     3.832   -17.373     0.200
     3.849   -16.721     0.200
     4.282   -21.948     0.200
     6.075   -37.784     0.200
     6.461   -34.127     0.200
     6.997   -38.899     0.200
     7.818   -47.878     0.200
    10.550   -66.584     0.200
     3.312   -16.326     0.200
     3.312   -18.115     0.200
     3.741   -21.596     0.200
     3.767   -17.728     0.200
     4.180   -15.507     0.200
     4.206   -19.030     0.200
     4.485   -18.318     0.200
     5.456   -28.024     0.200
     5.558   -27.368     0.200
     6.550   -33.623     0.200
     8.276   -46.748     0.200
     1.795    -5.977     0.200
     1.860    -6.261     0.200
     2.200    -8.869     0.200
     2.500   -11.741     0.200
     2.791   -11.969     0.200
     2.870   -12.230     0.200
     2.928   -13.848     0.200
     3.136   -13.042     0.200
     3.288   -13.832     0.200
     3.321   -16.633     0.200
     3.321   -15.383     0.200
     3.321   -13.641     0.200
     3.321   -17.167     0.200
     3.440   -15.964     0.200
     3.464   -19.245     0.200
     3.766   -19.710     0.200
     4.517   -25.570     0.200
     5.659   -30.662     0.200
     5.666   -31.946     0.200
     5.940   -33.860     0.200
     2.887   -10.272     0.200
     3.953   -25.730     0.200
     4.294   -24.265     0.200
     4.351   -22.959     0.200
     4.351   -20.201     0.200
     4.503   -18.789     0.200
     4.617   -20.523     0.200
     4.758   -26.722     0.200
     4.758   -21.605     0.200
     4.797   -25.822     0.200
     5.084   -28.282     0.200
     5.051   -23.665     0.200
     5.185   -27.345     0.200
     5.185   -24.385     0.200
     6.017   -35.502     0.200
     7.582   -37.208     0.200
     1.784    -6.681     0.200
     2.137   -10.723     0.200
     2.522    -8.616     0.200
     3.407   -17.720     0.200
     3.407   -15.720     0.200
     3.768   -20.016     0.200
     3.837   -22.663     0.200
     3.844   -19.803     0.200
     4.156   -19.336     0.200
     4.242   -22.726     0.200
     4.242   -17.828     0.200
     4.242   -17.359     0.200
     4.276   -22.932     0.200
     4.440   -20.578     0.200
     4.713   -23.545     0.200
     5.495   -30.246     0.200
     5.876   -37.782     0.200
     6.631   -40.882     0.200
     6.638   -35.439     0.200
     6.873   -38.957     0.200
     7.004   -36.779     0.200
     7.033   -35.432     0.200
     7.065   -36.600     0.200
     7.496   -41.706     0.200
     7.584   -46.908     0.200
     8.361   -50.120     0.200
     8.475   -50.392     0.200
    15.894  -100.867     0.200
    16.678  -111.474     0.200
    19.447  -130.544     0.200
    19.727  -131.332     0.200
    19.600  -131.746     0.200
    19.924  -132.921     0.200
    19.946  -134.808     0.200
    20.010  -134.387     0.200
    20.158  -139.897     0.200
    20.177  -138.621     0.200
    20.204  -140.639     0.200
    20.301  -141.919     0.200
    20.533  -143.247     0.200
    20.569  -141.960     0.200
    20.581  -143.204     0.200
    20.746  -145.412     0.200
    20.839  -146.511     0.200
    20.891  -144.443     0.200
    21.052  -148.490     0.200
    21.123  -148.370     0.200
    21.192  -149.420     0.200
    21.470  -152.730     0.200
    21.484  -153.118     0.200
    21.483  -152.808     0.200
    21.507  -150.783     0.200
    21.683  -155.301     0.200
    22.282  -160.001     0.200
     0.950     0.755     0.200
     1.488    -5.796     0.200
     1.473    -3.005     0.200
     1.805    -5.287     0.200
     2.543   -11.677     0.200
     2.543   -13.263     0.200
     2.698   -13.923     0.200
     2.830   -14.603     0.200
     2.838   -13.316     0.200
     2.838   -12.831     0.200
     3.115   -15.202     0.200
     3.086   -11.396     0.200
     3.167   -15.601     0.200
     3.167   -18.921     0.200
     3.226   -16.536     0.200
     3.282   -14.944     0.200
     3.317   -14.695     0.200
     3.317   -17.265     0.200
     3.652   -19.295     0.200
     3.652   -16.084     0.200
     3.652   -21.053     0.200
     3.996   -17.449     0.200
     4.857   -26.657     0.200
     5.713   -35.939     0.200
     5.800   -36.322     0.200
     7.409   -46.753     0.200
     7.409   -46.597     0.200
     1.225    -2.436     0.200
     2.720   -10.871     0.200
     3.991   -22.110     0.200
     4.328   -20.923     0.200
     4.382   -23.057     0.200
     4.529   -19.083     0.200
     5.013   -26.015     0.200
     7.926   -43.911     0.200
     8.922   -55.508     0.200
    10.652   -69.358     0.200
    16.373  -108.485     0.200
    20.310  -140.204     0.200
     2.226    -6.626     0.200
     2.697   -10.298     0.200
     3.114   -13.476     0.200
     3.235   -13.180     0.200
     3.349   -16.438     0.200
     3.552   -15.110     0.200
     3.713   -19.169     0.200
     3.735   -17.118     0.200
     4.164   -19.861     0.200
     4.268   -18.106     0.200
     4.844   -24.705     0.200
     4.844   -26.795     0.200
     5.264   -24.421     0.200
     5.953   -31.614     0.200
     6.344   -28.142     0.200
     6.344   -36.814     0.200
     6.879   -40.890     0.200
     2.257    -7.204     0.200
     2.715   -10.852     0.200
     2.755    -7.580     0.200
     3.986   -19.045     0.200
     3.986   -17.045     0.200
     4.271   -20.193     0.200
     4.302   -19.759     0.200
     4.302   -17.759     0.200
     4.601   -22.565     0.200
     4.686   -23.393     0.200
     4.700   -21.525     0.200
     4.880   -25.110     0.200
     4.917   -23.380     0.200
     5.105   -23.448     0.200
     7.150   -39.234     0.200
     7.364   -40.423     0.200
     8.145   -45.809     0.200
     8.204   -44.388     0.200
    10.575   -61.492     0.200
     0.408     3.491     0.200
     1.608    -5.316     0.200
     2.072    -7.337     0.200
     2.878   -13.455     0.200
     2.878   -15.885     0.200
     3.029   -14.136     0.200
     3.187   -15.960     0.200
     3.258   -16.632     0.200
     3.258   -15.452     0.200
     3.306   -16.900     0.200
     3.306   -19.009     0.200
     4.134   -22.450     0.200
     4.134   -20.450     0.200
     4.355   -22.370     0.200
     4.912   -27.421     0.200
     5.007   -28.463     0.200
     6.056   -31.181     0.200
     0.566     4.403     0.200
     1.854    -7.183     0.200
     1.854    -3.303     0.200
     2.853   -13.645     0.200
     2.950   -14.113     0.200
     2.950   -15.493     0.200
     3.178   -16.738     0.200
     3.214   -15.446     0.200
     3.568   -17.320     0.200
     3.619   -18.646     0.200
     3.984   -21.207     0.200
     4.049   -19.794     0.200
     5.056   -27.610     0.200
     5.056   -29.850     0.200
     5.239   -29.911     0.200
     6.058   -36.222     0.200
     6.200   -37.096     0.200
     6.986   -41.879     0.200
     7.074   -43.767     0.200
     7.768   -49.021     0.200
    12.424   -83.172     0.200
    16.440  -119.326     0.200
     2.391    -7.695     0.200
     2.630    -6.855     0.200
     2.695    -8.099     0.200
     2.815   -10.595     0.200
     3.050    -9.601     0.200
     3.251   -10.411     0.200
     3.276   -10.618     0.200
     3.343   -12.837     0.200
     3.622   -13.670     0.200
     4.352   -19.822     0.200
     4.492   -21.837     0.200
     5.505   -26.931     0.200
     6.510   -33.777     0.200
     7.224   -38.851     0.200
     1.760    -5.303     0.200
     2.432    -8.393     0.200
     2.862   -13.966     0.200
     3.010   -11.895     0.200
     0.710     1.466     0.200
     1.349    -5.158     0.200
     1.420    -1.154     0.200
     1.506    -4.207     0.200
     1.795    -4.608     0.200
     2.106    -8.535     0.200
     2.546    -9.690     0.200
     2.610   -12.396     0.200
     2.949   -13.706     0.200
     3.188   -12.520     0.200
     3.375   -15.997     0.200
     3.388   -14.147     0.200
     3.830   -20.063     0.200
     3.863   -17.881     0.200
     4.338   -23.472     0.200
     5.755   -33.962     0.200
     6.748   -38.469     0.200
     7.476   -48.348     0.200
     0.906    -0.651     0.200
     2.175   -10.070     0.200
     4.306   -23.325     0.200
     4.681   -20.314     0.200
     5.381   -28.246     0.200
     6.335   -36.865     0.200
     9.854   -58.821     0.200
    12.544   -77.385     0.200
    20.250  -139.105     0.200
    21.064  -138.939     0.200
     0.249     6.249     0.200
     0.934    -0.081     0.200
     1.941    -9.149     0.200
     1.941    -6.800     0.200
     2.225   -10.640     0.200
     2.780   -14.946     0.200
     2.778   -13.260     0.200
     2.869   -15.992     0.200
     3.573   -19.949     0.200
     1.441    -3.390     0.200
     2.488   -10.813     0.200
     3.359   -13.713     0.200
     4.186   -15.885     0.200
     4.854   -25.950     0.200
    12.699   -76.861     0.200
    13.779   -90.058     0.200
    14.813   -88.340     0.200
     0.286     6.654     0.200
     1.161    -3.214     0.200
     1.192    -2.058     0.200
     1.387    -5.148     0.200
     1.714    -7.605     0.200
     2.081    -9.114     0.200
     2.139    -7.919     0.200
     2.985   -15.502     0.200
     2.979   -15.165     0.200
     3.008   -15.560     0.200
     7.904   -50.074     0.200
     9.528   -61.255     0.200
     0.964    -1.944     0.200
     1.090    -2.157     0.200
     1.664    -3.905     0.200
     1.777    -6.143     0.200
     1.681    -1.056     0.200
     1.885    -5.904     0.200
     2.341   -12.129     0.200
     2.609   -11.848     0.200
     2.596    -9.609     0.200
     2.688   -11.586     0.200
     2.821   -14.442     0.200
     3.142   -14.617     0.200
     3.150   -14.861     0.200
     3.589   -16.290     0.200
     4.720   -25.602     0.200
     7.203   -45.097     0.200
     0.786     0.333     0.200
     1.145    -3.030     0.200
     1.765    -5.066     0.200
     1.869    -4.838     0.200
     1.995    -7.474     0.200
     2.056    -8.123     0.200
     2.068    -8.073     0.200
     2.438    -9.042     0.200
     2.486   -11.056     0.200
     2.575    -9.860     0.200
     2.693   -11.425     0.200
     2.721   -11.927     0.200
     3.077   -13.077     0.200
     3.137   -13.804     0.200
     3.309   -10.923     0.200
     3.470   -16.165     0.200
     3.534   -15.428     0.200
     3.637   -18.135     0.200
     3.673   -18.825     0.200
     0.779     6.067     0.200
     0.794     6.825     0.200
     0.995     4.170     0.200
     1.759    -4.182     0.200
     1.759    -5.951     0.200
     1.961    -6.468     0.200
     1.961    -7.878     0.200
     2.044    -7.043     0.200
     2.044    -6.213     0.200
     2.337    -9.896     0.200
     2.564   -12.735     0.200
     3.193   -15.988     0.200
     3.193   -20.389     0.200
     3.320   -17.788     0.200
     3.791   -20.040     0.200
     4.396   -28.312     0.200
     7.900   -51.260     0.200
     0.943    -0.690     0.200
     1.109    -2.248     0.200
     1.646    -3.650     0.200
     1.691    -4.600     0.200
     1.907    -7.814     0.200
     2.361   -10.092     0.200
     2.631   -11.847     0.200
     2.709   -11.802     0.200
     2.787   -17.066     0.200
     2.800   -13.295     0.200
     7.225   -46.163     0.200
     0.926     1.017     0.200
     2.333    -9.553     0.200
     2.587   -12.330     0.200
     3.203   -13.517     0.200
     4.329   -23.628     0.200
     8.264   -52.824     0.200
     1.531    -2.440     0.200
     1.465    -3.193     0.200
     2.454    -7.633     0.200
     2.733   -11.484     0.200
     4.180   -20.231     0.200
     0.923     0.970     0.200
     8.363   -47.268     0.200
     0.679     1.196     0.200
     1.360    -4.051     0.200
     1.418    -1.753     0.200
     1.493    -2.953     0.200
     1.831    -3.733     0.200
     2.179    -7.906     0.200
     2.530   -10.908     0.200
     2.623   -13.191     0.200
     2.907   -13.721     0.200
     2.978   -13.955     0.200
     3.191   -14.903     0.200
     7.501   -49.054     0.200
     0.599     1.224     0.200
     0.599     1.388     0.200
     1.425    -5.873     0.200
     2.502   -15.215     0.200
     2.537   -10.718     0.200
     3.247   -15.795     0.200
     4.112   -18.848     0.200
     4.171   -20.987     0.200
     5.013   -22.249     0.200
     5.165   -28.945     0.200
     8.707   -57.111     0.200
     0.733     1.506     0.200
     1.358    -3.526     0.200
     2.138    -7.888     0.200
     2.615   -11.412     0.200
     2.872   -12.317     0.200
     2.934   -12.270     0.200
     3.367   -14.843     0.200
     3.930   -18.941     0.200
     4.726   -25.546     0.200
     3.456   -15.961     0.200
     4.712   -27.289     0.200
     5.684   -33.734     0.200
     7.004   -44.422     0.200
     9.418   -55.882     0.200
    18.926  -134.330     0.200
     1.963    -8.285     0.200
     1.983    -5.724     0.200
     4.572   -18.930     0.200
     4.667   -24.003     0.200
     8.214   -45.082     0.200
     1.021     2.324     0.200
     2.543    -9.039     0.200
     2.615    -9.030     0.200
     3.511   -14.956     0.200
     5.293   -28.522     0.200
     0.125    20.838     0.200
     0.361    14.718     0.200
     1.114     3.112     0.200
     1.862    -7.564     0.200
     2.314    -7.742     0.200
     2.592   -10.839     0.200
     2.723   -10.940     0.200
     3.321   -15.556     0.200
     3.967   -25.927     0.200
     4.454   -18.400     0.200
     8.644   -54.806     0.200
    13.336   -89.089     0.200
     1.997    -6.524     0.200
     1.997    -7.364     0.200
     3.336   -15.319     0.200
     4.456   -21.027     0.200
     6.882   -44.714     0.200
     1.462    -4.871     0.200
     1.958    -6.276     0.200
     2.221    -7.756     0.200
     2.630   -11.031     0.200
     3.267   -14.580     0.200
     3.320   -15.773     0.200
     3.659   -17.173     0.200
     3.659   -17.834     0.200
     3.723   -17.441     0.200
     4.046   -19.388     0.200
     2.274    -9.643     0.200
     4.226   -22.820     0.200
     1.051     0.480     0.200
     1.230     1.829     0.200
     1.979    -7.721     0.200
     3.649   -19.438     0.200
     3.807   -14.032     0.200
     4.372   -19.139     0.200
     4.565   -24.394     0.200
     4.682   -26.121     0.200
     4.853   -19.091     0.200
     5.767   -26.811     0.200
     8.230   -51.872     0.200
     1.216    -1.055     0.200
     2.102    -8.573     0.200
     2.605    -9.679     0.200
     3.070   -13.971     0.200
     3.820   -20.793     0.200
     3.960   -17.879     0.200
     9.160   -57.773     0.200
     0.957     1.631     0.200
     1.299    -4.375     0.200
     2.642   -11.429     0.200
     3.518   -16.503     0.200
     4.467   -21.639     0.200
     5.072   -23.108     0.200
     5.307   -27.388     0.200
     5.975   -32.047     0.200
     6.055   -33.118     0.200
     6.522   -31.786     0.200
     7.075   -40.810     0.200
     0.880     0.345     0.200
     1.305    -3.704     0.200
     1.467    -3.353     0.200
     1.585    -3.936     0.200
     2.079    -7.005     0.200
     2.576   -13.822     0.200
     2.588   -12.119     0.200
     3.130   -18.083     0.200
     3.352   -12.720     0.200
     3.423   -15.900     0.200
     3.749   -15.409     0.200
     3.838   -14.568     0.200
     4.108   -22.257     0.200
     4.805   -29.711     0.200
     5.738   -30.929     0.200
     6.751   -42.234     0.200
     0.582     2.333     0.200
     1.344    -5.021     0.200
     2.615   -13.177     0.200
     2.544    -9.357     0.200
     2.984   -12.272     0.200
     4.026   -23.322     0.200
     4.715   -29.002     0.200
     1.169     1.986     0.200
     1.180     1.766     0.200
     1.212     2.060     0.200
     1.226     1.009     0.200
     1.916    -5.333     0.200
     2.500    -8.551     0.200
     3.288   -12.349     0.200
     3.691   -19.560     0.200
     3.847   -16.909     0.200
     3.815   -16.952     0.200
     4.035   -15.670     0.200
     4.153   -25.141     0.200
     4.172   -20.859     0.200
     4.182   -17.086     0.200
     4.203   -19.646     0.200
     4.193   -16.723     0.200
     4.199   -23.869     0.200
     4.221   -19.288     0.200
     4.283   -24.365     0.200
     4.413   -28.713     0.200
     4.309   -21.646     0.200
     4.366   -24.020     0.200
     4.413   -26.422     0.200
     4.413   -21.742     0.200
     4.445   -18.439     0.200
     4.718   -25.465     0.200
     4.666   -22.923     0.200
     5.434   -32.671     0.200
     5.522   -29.207     0.200
     5.820   -35.129     0.200
     6.391   -28.442     0.200
     6.527   -38.531     0.200
     7.309   -47.065     0.200
     7.542   -36.609     0.200
     8.261   -48.234     0.200
    11.210   -76.961     0.200
    11.333   -77.897     0.200
     0.300     6.397     0.200
     0.867     0.323     0.200
     0.953    -1.225     0.200
     1.057    -1.083     0.200
     1.073    -0.461     0.200
     1.077    -1.421     0.200
     1.098     0.973     0.200
     1.120    -1.138     0.200
     1.349    -3.275     0.200
     1.806    -7.895     0.200
     2.122    -8.183     0.200
     2.640   -12.306     0.200
     2.864   -14.819     0.200
     3.076   -16.548     0.200
     3.374   -17.941     0.200
     3.434   -16.559     0.200
     3.857   -14.962     0.200
     4.187   -26.902     0.200
     4.293   -23.165     0.200
     4.280   -23.701     0.200
     4.430   -26.372     0.200
     7.968   -54.012     0.200
     1.049    -0.495     0.200
     1.107    -0.478     0.200
     2.965   -14.454     0.200
     3.173   -17.984     0.200
     3.537   -15.201     0.200
     3.729   -15.804     0.200
     3.716   -14.079     0.200
     3.763   -16.965     0.200
     3.804   -23.440     0.200
     3.818   -15.474     0.200
     3.965   -19.535     0.200
     4.015   -16.742     0.200
     4.177   -22.447     0.200
     4.175   -17.126     0.200
     4.180   -17.389     0.200
     4.187   -17.184     0.200
     4.265   -19.458     0.200
     4.345   -19.609     0.200
     4.426   -21.788     0.200
     4.619   -23.331     0.200
     4.678   -28.374     0.200
     5.761   -31.009     0.200
     8.225   -49.461     0.200
     0.874    -0.563     0.200
     1.929   -10.334     0.200
     1.983    -9.576     0.200
     2.847   -14.696     0.200
     3.200   -17.729     0.200
     3.565   -15.860     0.200
     3.649   -18.245     0.200
     3.605   -16.038     0.200
     3.703   -18.186     0.200
     3.728   -15.284     0.200
     3.871   -19.914     0.200
     3.922   -20.726     0.200
     4.090   -18.325     0.200
     4.473   -20.558     0.200
     4.530   -20.627     0.200
     4.612   -27.142     0.200
     4.974   -29.169     0.200
     5.343   -33.429     0.200
     5.722   -35.098     0.200
     5.973   -32.460     0.200
     0.774     1.000     0.200
     0.875    -0.315     0.200
     1.263    -4.053     0.200
     1.379    -3.458     0.200
     1.490    -2.829     0.200
     1.494    -3.376     0.200
     1.493    -3.105     0.200
     1.513    -2.783     0.200
     1.559    -5.587     0.200
     1.523    -4.105     0.200
     1.618    -4.689     0.200
     1.645    -3.909     0.200
     1.999    -6.812     0.200
     2.507   -14.815     0.200
     2.737   -12.465     0.200
     2.793   -10.952     0.200
     3.024   -16.041     0.200
     3.062   -10.681     0.200
     3.202   -10.955     0.200
     3.225   -15.152     0.200
     3.596   -21.092     0.200
     3.665   -16.447     0.200
     3.699   -17.954     0.200
     3.796   -22.915     0.200
     3.829   -20.627     0.200
     4.135   -25.830     0.200
     4.607   -31.007     0.200
     4.613   -26.809     0.200
     4.936   -27.170     0.200
     5.124   -25.643     0.200
     6.361   -38.326     0.200
     7.330   -47.775     0.200
     0.564     1.852     0.200
     1.005    -1.978     0.200
     1.754    -5.284     0.200
     1.853    -5.460     0.200
     1.957    -6.748     0.200
     2.277    -9.609     0.200
     2.510   -12.462     0.200
     2.840   -12.278     0.200
     3.037   -11.580     0.200
     3.099   -11.915     0.200
     3.143   -13.385     0.200
     3.272   -13.507     0.200
     3.393   -19.382     0.200
     3.319   -17.052     0.200
     3.316   -13.403     0.200
     3.319   -18.536     0.200
     3.396   -13.531     0.200
     3.413   -14.515     0.200
     3.466   -14.241     0.200
     3.559   -14.255     0.200
     3.579   -14.698     0.200
     3.570   -15.473     0.200
     3.587   -16.087     0.200
     3.685   -17.285     0.200
     3.684   -21.733     0.200
     3.707   -16.025     0.200
     3.817   -21.528     0.200
     3.867   -17.868     0.200
     3.865   -14.942     0.200
     4.061   -23.647     0.200
     4.412   -24.852     0.200
     4.379   -27.997     0.200
     4.489   -22.939     0.200
     4.787   -26.671     0.200
     5.432   -33.266     0.200
     5.494   -28.639     0.200
     5.452   -26.688     0.200
     5.807   -24.451     0.200
     6.289   -40.726     0.200
     6.443   -42.256     0.200
     7.232   -46.649     0.200
     0.287     5.571     0.200
     1.770    -8.708     0.200
     2.620    -9.008     0.200
     2.620   -12.957     0.200
     3.041   -18.513     0.200
     2.830    -9.518     0.200
     3.350   -15.997     0.200
     3.350   -16.968     0.200
     3.416   -17.663     0.200
     3.354   -11.271     0.200
     3.844   -21.822     0.200
     4.280   -22.461     0.200
     4.281   -22.502     0.200
     4.404   -25.009     0.200
     4.753   -29.863     0.200
     5.074   -30.037     0.200
     5.172   -31.574     0.200
     5.217   -26.537     0.200
     5.217   -32.097     0.200
     5.529   -32.588     0.200
     7.944   -51.225     0.200
     0.798    -0.201     0.200
     0.906    -0.073     0.200
     1.395    -6.270     0.200
     1.358    -1.207     0.200
     1.362    -3.632     0.200
     1.361    -1.025     0.200
     1.437    -4.929     0.200
     1.391    -0.571     0.200
     1.490    -3.658     0.200
     1.587    -7.081     0.200
     1.661    -5.354     0.200
     2.187   -10.817     0.200
     2.294    -9.306     0.200
     2.540   -13.464     0.200
     2.639   -15.417     0.200
     2.854   -13.398     0.200
     2.898   -10.894     0.200
     3.317   -12.037     0.200
     3.405   -15.662     0.200
     3.915   -23.768     0.200
     3.953   -21.770     0.200
     4.247   -27.237     0.200
     4.198   -18.967     0.200
     4.569   -26.732     0.200
     4.736   -31.167     0.200
     4.733   -27.420     0.200
     4.926   -30.594     0.200
     5.059   -30.405     0.200
     5.231   -30.717     0.200
     5.752   -35.307     0.200
     5.733   -32.521     0.200
     5.733   -32.514     0.200
     6.751   -45.673     0.200
     1.118    -1.934     0.200
     1.314    -3.600     0.200
     2.374    -9.583     0.200
     2.423    -7.756     0.200
     2.736    -9.768     0.200
     2.902   -13.176     0.200
     3.192   -12.642     0.200
     3.708   -16.900     0.200
     3.728   -17.460     0.200
     4.061   -18.870     0.200
     4.381   -26.794     0.200
     4.488   -24.733     0.200
     4.520   -26.284     0.200
     4.834   -31.291     0.200
     5.059   -30.055     0.200
     0.973     2.396     0.200
     1.029     1.860     0.200
     1.074     1.946     0.200
     1.078     1.513     0.200
     1.071     1.720     0.200
     1.097     2.328     0.200
     1.120     1.651     0.200
     1.130     2.635     0.200
     1.788    -4.103     0.200
     1.990    -5.094     0.200
     2.779    -7.811     0.200
     2.803   -10.184     0.200
     2.840    -9.961     0.200
     3.057    -8.631     0.200
     3.319    -9.197     0.200
     3.309   -12.115     0.200
     3.364   -10.107     0.200
     3.498   -17.193     0.200
     3.454   -12.292     0.200
     3.595   -15.761     0.200
     3.644   -10.769     0.200
     3.788   -16.904     0.200
     3.790   -17.247     0.200
     3.790   -16.956     0.200
     3.887   -12.679     0.200
     3.911   -13.644     0.200
     4.010   -12.593     0.200
     4.166   -20.797     0.200
     4.219   -17.084     0.200
     4.218   -17.069     0.200
     4.261   -18.423     0.200
     4.262   -18.464     0.200
     4.263   -17.447     0.200
     4.364   -22.872     0.200
     4.404   -20.650     0.200
     4.428   -20.417     0.200
     4.748   -25.892     0.200
     5.070   -25.146     0.200
     5.183   -28.354     0.200
     5.219   -24.992     0.200
     5.337   -27.501     0.200
     5.436   -27.125     0.200
     5.448   -27.445     0.200
     5.534   -30.730     0.200
     5.737   -31.740     0.200
     6.009   -31.790     0.200
     6.202   -36.679     0.200
     6.222   -33.811     0.200
     6.221   -33.804     0.200
     7.209   -41.403     0.200
     7.942   -46.664     0.200
     1.127    -2.867     0.200
     1.678    -5.458     0.200
     2.427    -8.807     0.200
     2.640   -11.151     0.200
     2.715   -10.698     0.200
     2.901   -15.481     0.200
     2.785   -11.198     0.200
     3.165   -14.119     0.200
     3.610   -15.409     0.200
     3.695   -20.966     0.200
     3.720   -18.628     0.200
     3.601   -13.794     0.200
     1.253    -2.729     0.200
     1.307    -2.326     0.200
     1.665    -5.703     0.200
     1.873    -5.747     0.200
     1.873    -8.276     0.200
     2.079    -8.992     0.200
     2.433    -7.435     0.200
     2.823   -11.926     0.200
     3.044   -12.322     0.200
     3.141   -13.101     0.200
     3.127   -12.461     0.200
     3.628   -17.443     0.200
     3.701   -19.991     0.200
     4.069   -19.415     0.200
     4.080   -21.133     0.200
     4.266   -19.793     0.200
     4.522   -23.275     0.200
     4.523   -23.315     0.200
     4.535   -22.953     0.200
     4.536   -22.969     0.200
     4.574   -24.403     0.200
     4.944   -28.147     0.200
     5.263   -29.886     0.200
     5.288   -26.535     0.200
     5.380   -28.056     0.200
     5.661   -34.805     0.200
     5.676   -30.437     0.200
     5.718   -28.922     0.200
     5.947   -31.337     0.200
     6.177   -29.677     0.200
     6.307   -34.891     0.200
     7.037   -37.032     0.200
     7.322   -40.293     0.200
     8.121   -45.928     0.200
     8.921   -49.539     0.200
     0.922     0.284     0.200
     0.950     0.886     0.200
     1.077     0.471     0.200
     1.109     0.311     0.200
     1.657    -6.796     0.200
     1.887    -7.355     0.200
     2.817   -12.801     0.200
     3.157   -20.188     0.200
     2.971   -14.191     0.200
     3.079   -10.586     0.200
     3.620   -15.623     0.200
     3.611   -14.555     0.200
     4.066   -24.585     0.200
     4.504   -23.920     0.200
     4.505   -23.936     0.200
     4.505   -21.550     0.200
     0.911     0.433     0.200
     0.791     3.868     0.200
     1.017     0.390     0.200
     1.195    -1.036     0.200
     1.262     0.194     0.200
     1.259    -0.550     0.200
     1.269    -0.012     0.200
     1.291    -0.503     0.200
     1.314    -1.738     0.200
     1.310    -1.599     0.200
     1.432    -2.963     0.200
     1.454    -2.889     0.200
     1.508    -5.343     0.200
     1.692    -6.601     0.200
     2.106    -7.987     0.200
     2.165    -7.330     0.200
     2.499   -11.878     0.200
     2.507   -12.682     0.200
     2.724   -15.092     0.200
     2.867   -13.930     0.200
     2.878   -14.518     0.200
     3.118   -17.452     0.200
     3.220   -18.746     0.200
     3.267   -14.370     0.200
     3.693   -16.045     0.200
     3.792   -22.382     0.200
     3.932   -24.228     0.200
     4.243   -25.906     0.200
     4.566   -27.616     0.200
     0.820     0.145     0.200
     1.146    -3.557     0.200
     1.205    -4.082     0.200
     1.537    -4.810     0.200
     1.599    -3.600     0.200
     1.594    -3.583     0.200
     1.607    -3.038     0.200
     1.626    -2.482     0.200
     1.656    -4.214     0.200
     1.763    -7.259     0.200
     1.773    -3.757     0.200
     1.794    -7.424     0.200
     2.394   -12.070     0.200
     2.503   -10.492     0.200
     2.553   -11.542     0.200
     2.881   -12.043     0.200
     3.593   -18.988     0.200
     3.644   -19.735     0.200
     3.912   -18.780     0.200
     1.168     0.451     0.200
     1.976    -6.021     0.200
     2.156    -6.870     0.200
     2.469    -7.411     0.200
     2.502    -6.982     0.200
     2.844    -9.289     0.200
     3.205   -11.824     0.200
     3.243   -11.019     0.200
     3.283   -10.575     0.200
     3.344   -12.092     0.200
     3.423   -12.242     0.200
     3.431   -10.861     0.200
     3.440   -10.703     0.200
     3.516   -19.625     0.200
     3.536   -18.314     0.200
     3.572   -19.235     0.200
     3.614   -20.543     0.200
     3.673   -15.604     0.200
     3.621   -14.600     0.200
     3.844   -18.095     0.200
     3.940   -14.290     0.200
     4.308   -21.316     0.200
     4.587   -19.402     0.200
     4.910   -25.069     0.200
     5.131   -27.578     0.200
     5.195   -25.557     0.200
     5.216   -25.038     0.200
     5.399   -24.569     0.200
     5.484   -32.764     0.200
     5.530   -29.907     0.200
     6.118   -35.198     0.200
     6.224   -33.273     0.200
     6.352   -31.805     0.200
     6.512   -31.211     0.200
     6.846   -38.116     0.200
     7.205   -42.577     0.200
     8.414   -51.450     0.200
     8.783   -45.372     0.200
     9.754   -61.473     0.200
     2.908   -11.306     0.200
     3.116   -13.302     0.200
     3.518   -18.213     0.200
     3.563   -16.896     0.200
     3.602   -16.760     0.200
     3.675   -14.948     0.200
     3.665   -13.971     0.200
     3.851   -19.162     0.200
     3.958   -16.473     0.200
     4.066   -17.368     0.200
     4.073   -24.310     0.200
     4.073   -15.650     0.200
     4.162   -19.868     0.200
     4.170   -22.367     0.200
     4.181   -19.571     0.200
     4.240   -16.913     0.200
     4.230   -22.042     0.200
     4.312   -19.915     0.200
     4.364   -19.216     0.200
     4.524   -24.822     0.200
     4.500   -18.073     0.200
     4.517   -22.724     0.200
     4.540   -25.766     0.200
     4.564   -20.860     0.200
     4.783   -24.391     0.200
     5.262   -21.693     0.200
     5.354   -30.689     0.200
     5.650   -31.385     0.200
     5.636   -33.057     0.200
     5.922   -32.495     0.200
     6.167   -31.505     0.200
     6.281   -38.660     0.200
     6.359   -39.869     0.200
     7.051   -37.318     0.200
     7.297   -43.371     0.200
     7.527   -41.179     0.200
     8.096   -44.278     0.200
     2.451    -9.656     0.200
     2.700   -11.290     0.200
     2.890   -12.688     0.200
     3.166   -13.426     0.200
     3.493   -16.974     0.200
     3.420   -14.344     0.200
     3.861   -23.230     0.200
     3.931   -20.942     0.200
     3.972   -22.289     0.200
     4.022   -22.097     0.200
     4.275   -24.812     0.200
     4.327   -22.614     0.200
     4.424   -23.016     0.200
     4.664   -25.150     0.200
     4.995   -31.110     0.200
     5.087   -35.489     0.200
     5.264   -30.086     0.200
     5.680   -36.275     0.200
     5.909   -42.918     0.200
     5.944   -40.875     0.200
     5.992   -43.074     0.200
     5.814   -33.535     0.200
     6.264   -39.997     0.200
     6.288   -34.875     0.200
     7.001   -43.040     0.200
     0.414     3.550     0.200
     0.901    -1.909     0.200
     1.080    -0.769     0.200
     1.239    -5.071     0.200
     1.611    -6.539     0.200
     1.524    -6.513     0.200
     1.876    -5.375     0.200
     1.901    -6.758     0.200
     1.919    -7.947     0.200
     1.876    -7.935     0.200
     2.116   -11.076     0.200
     2.338    -9.902     0.200
     2.413   -12.013     0.200
     2.623   -12.341     0.200
     2.717   -17.205     0.200
     2.872   -13.625     0.200
     2.891   -12.435     0.200
     3.195   -17.150     0.200
     3.354   -15.929     0.200
     3.063   -14.844     0.200
     3.869   -15.765     0.200
     4.874   -19.866     0.200
     5.306   -22.611     0.200
     5.601   -28.649     0.200
     1.153     1.394     0.200
     1.625    -3.434     0.200
     2.212    -6.371     0.200
     2.198    -7.081     0.200
     2.198    -6.784     0.200
     2.413    -9.096     0.200
     2.873    -9.437     0.200
     2.979   -10.267     0.200
     3.250   -13.041     0.200
     3.430   -13.817     0.200
     3.541   -20.952     0.200
     3.499   -11.942     0.200
     3.479   -14.714     0.200
     3.578   -14.304     0.200
     3.597   -13.411     0.200
     3.603   -18.818     0.200
     3.613   -15.031     0.200
     3.751   -12.887     0.200
     3.857   -15.245     0.200
     3.881   -17.902     0.200
     4.063   -18.650     0.200
     4.563   -19.062     0.200
     4.692   -19.968     0.200
     4.853   -25.299     0.200
     4.970   -26.465     0.200
     5.043   -27.626     0.200
     5.581   -30.357     0.200
     6.089   -30.222     0.200
     7.441   -48.650     0.200
     0.948    -2.219     0.200
     0.923     0.325     0.200
     0.929     2.087     0.200
     0.938     2.377     0.200
     0.947     2.235     0.200
     0.962     2.689     0.200
     0.982     2.380     0.200
     1.020     1.234     0.200
     1.126     0.486     0.200
     1.220    -1.805     0.200
     1.540    -2.641     0.200
     1.859    -7.880     0.200
     1.913    -3.298     0.200
     2.377    -9.587     0.200
     3.063   -12.771     0.200
     3.122   -12.446     0.200
     3.148   -13.096     0.200
     3.467   -16.856     0.200
     3.546   -14.704     0.200
     4.117   -20.787     0.200
     4.501   -19.966     0.200
     4.824   -26.870     0.200
     5.386   -28.469     0.200
     5.451   -36.136     0.200
     0.916     0.596     0.200
     0.959     0.344     0.200
     1.909    -6.516     0.200
     2.426    -7.886     0.200
     2.849   -10.299     0.200
     3.178   -17.037     0.200
     3.560   -16.709     0.200
     3.617   -17.994     0.200
     3.652   -15.333     0.200
     3.736   -17.768     0.200
     3.715   -18.169     0.200
     3.938   -17.350     0.200
     4.100   -25.657     0.200
     4.542   -26.190     0.200
     4.971   -28.037     0.200
     5.291   -30.387     0.200
     5.411   -30.786     0.200
     5.709   -28.439     0.200
     0.980     0.185     0.200
     1.023    -0.274     0.200
     3.043   -10.999     0.200
     3.832   -16.330     0.200
     3.919   -20.874     0.200
     4.075   -20.747     0.200
     4.251   -26.480     0.200
     4.519   -20.971     0.200
     4.562   -21.488     0.200
     4.581   -18.917     0.200
     4.934   -29.371     0.200
     5.252   -32.864     0.200
     5.272   -33.722     0.200
     5.367   -37.585     0.200
     5.663   -36.288     0.200
     5.938   -32.722     0.200
     3.334   -12.354     0.200
     3.682   -13.950     0.200
     3.915   -13.171     0.200
     3.989   -19.470     0.200
     4.185   -18.212     0.200
     4.323   -23.326     0.200
     4.450   -16.950     0.200
     4.557   -17.052     0.200
     4.972   -18.483     0.200
     5.229   -27.880     0.200
     5.268   -24.853     0.200
     5.550   -27.079     0.200
     5.873   -35.116     0.200
     0.901     1.526     0.200
     1.161    -0.292     0.200
     1.153     0.597     0.200
     1.202     2.134     0.200
     1.217     2.292     0.200
     1.219     0.053     0.200
     1.541    -4.231     0.200
     2.173    -8.260     0.200
     3.029   -17.485     0.200
     3.057   -11.285     0.200
     3.238   -17.514     0.200
     3.649   -16.601     0.200
     3.710   -15.188     0.200
     3.752   -15.852     0.200
     3.795   -16.589     0.200
     4.027   -17.423     0.200
     4.118   -17.508     0.200
     4.135   -19.301     0.200
     4.143   -24.254     0.200
     4.197   -20.774     0.200
     4.230   -23.515     0.200
     4.361   -26.537     0.200
     4.381   -16.442     0.200
     4.564   -27.282     0.200
     4.580   -19.714     0.200
     4.602   -18.908     0.200
     4.628   -25.739     0.200
     4.657   -21.455     0.200
     5.006   -28.879     0.200
     5.340   -30.727     0.200
     5.382   -30.906     0.200
     5.464   -28.586     0.200
     5.729   -34.202     0.200
     5.764   -29.885     0.200
     5.613   -26.548     0.200
     5.999   -37.892     0.200
     6.020   -37.011     0.200
     6.160   -30.406     0.200
     6.328   -29.832     0.200
     6.402   -41.568     0.200
     6.469   -39.168     0.200
     6.746   -34.728     0.200
     6.942   -40.647     0.200
     7.249   -44.882     0.200
     7.416   -45.844     0.200
     7.348   -46.936     0.200
     7.855   -41.534     0.200
     7.806   -45.440     0.200
     8.865   -48.924     0.200
     8.828   -44.027     0.200
     9.369   -55.107     0.200
     9.674   -58.134     0.200
     9.636   -54.586     0.200
     9.917   -56.679     0.200
    10.487   -64.307     0.200
    10.941   -60.079     0.200
    12.539   -82.521     0.200
    12.697   -82.368     0.200
    13.443   -82.580     0.200
    14.401   -94.101     0.200
    14.695  -101.296     0.200
     0.318     4.902     0.200
     1.074    -2.580     0.200
     1.152    -0.955     0.200
     1.184    -2.502     0.200
     1.233    -1.415     0.200
     1.199    -1.031     0.200
     1.203    -0.544     0.200
     1.222    -0.938     0.200
     1.259    -2.247     0.200
     1.245    -1.409     0.200
     1.254    -0.728     0.200
     1.363    -4.321     0.200
     1.829    -4.768     0.200
     2.957   -10.401     0.200
     3.351   -12.826     0.200
     4.683   -28.834     0.200
     5.004   -33.597     0.200
     5.451   -35.470     0.200
     1.195    -3.748     0.200
     2.254   -11.786     0.200
     2.459   -13.368     0.200
     2.731   -13.748     0.200
     2.904   -14.152     0.200
     3.045   -13.090     0.200
     3.586   -23.923     0.200
     3.506   -15.002     0.200
     3.541   -14.653     0.200
     3.565   -19.710     0.200
     3.590   -15.451     0.200
     3.613   -17.065     0.200
     3.554   -17.330     0.200
     4.015   -16.499     0.200
    11.377   -68.844     0.200
     0.849     1.849     0.200
     1.111    -1.919     0.200
     1.333    -4.248     0.200
     1.431    -3.392     0.200
     1.350    -2.422     0.200
     1.505    -5.843     0.200
     1.474    -4.100     0.200
     1.481    -2.803     0.200
     1.489    -2.492     0.200
     1.507    -2.306     0.200
     1.527    -3.839     0.200
     1.673    -6.931     0.200
     1.655    -4.616     0.200
     1.693    -6.241     0.200
     1.866    -7.751     0.200
     2.290   -11.769     0.200
     2.405   -13.736     0.200
     2.517   -12.865     0.200
     2.628   -13.691     0.200
     2.636   -10.836     0.200
     2.745   -15.059     0.200
     2.907   -16.078     0.200
     3.030   -14.503     0.200
     3.571   -20.082     0.200
     0.470     7.576     0.200
     0.603     7.081     0.200
     0.604     6.657     0.200
     0.617     6.137     0.200
     0.643     6.134     0.200
     0.655     6.247     0.200
     0.694     4.597     0.200
     0.730     3.350     0.200
     0.728     3.929     0.200
     0.712     3.805     0.200
     1.442    -4.129     0.200
     1.685    -5.704     0.200
     1.780    -7.049     0.200
     2.014    -7.009     0.200
     2.170   -11.426     0.200
     2.365   -12.262     0.200
     2.830   -14.788     0.200
     2.917   -15.783     0.200
     3.082   -16.809     0.200
     3.419   -20.974     0.200
     3.593   -19.308     0.200
     3.591   -18.214     0.200
     3.952   -23.022     0.200
     4.366   -16.709     0.200
     4.504   -28.118     0.200
     4.659   -29.862     0.200
     4.964   -32.649     0.200
     5.287   -35.234     0.200
     5.480   -36.329     0.200
     5.818   -37.171     0.200
     5.924   -38.369     0.200
     0.552     2.460     0.200
     1.550    -6.017     0.200
     2.813   -10.074     0.200
     3.343   -18.203     0.200
     3.562   -13.480     0.200
     3.915   -23.598     0.200
     3.999   -18.482     0.200
     4.137   -25.809     0.200
     4.165   -26.033     0.200
     4.261   -17.127     0.200
     4.479   -27.951     0.200
     4.800   -28.508     0.200
     4.929   -30.233     0.200
     4.953   -28.703     0.200
     0.475     0.769     0.200
     2.338    -8.276     0.200
     2.542   -11.110     0.200
     3.170   -15.336     0.200
     3.609   -17.929     0.200
     3.508   -13.338     0.200
     3.957   -20.242     0.200
     4.154   -22.106     0.200
     4.100   -17.749     0.200
     4.154   -23.291     0.200
     4.218   -17.720     0.200
     4.304   -20.742     0.200
     4.344   -20.389     0.200
     4.360   -23.777     0.200
     4.401   -19.538     0.200
     4.437   -20.050     0.200
     4.486   -18.528     0.200
     4.724   -29.200     0.200
     4.663   -21.673     0.200
     4.755   -24.783     0.200
     4.755   -24.613     0.200
     4.717   -22.252     0.200
     4.784   -22.736     0.200
     4.784   -21.326     0.200
     4.787   -23.850     0.200
     4.968   -29.577     0.200
     5.308   -32.332     0.200
     5.629   -34.701     0.200
     5.743   -35.806     0.200
     5.783   -35.246     0.200
     5.927   -32.581     0.200
     5.984   -29.906     0.200
     6.099   -37.616     0.200
     6.291   -35.593     0.200
     6.529   -42.128     0.200
     8.504   -55.798     0.200
     9.155   -51.793     0.200
     1.198    -0.782     0.200
     1.337    -2.053     0.200
     1.682    -6.224     0.200
     1.846    -6.616     0.200
     1.952    -2.804     0.200
     2.071    -7.609     0.200
     2.101    -6.798     0.200
     2.443    -8.287     0.200
     2.831   -10.302     0.200
     3.289   -16.607     0.200
     3.380   -16.823     0.200
     3.697   -17.922     0.200
     3.856   -20.333     0.200
     3.911   -26.184     0.200
     4.185   -19.810     0.200
     4.507   -30.744     0.200
     4.733   -27.321     0.200
     4.986   -22.021     0.200
     5.091   -32.474     0.200
     5.126   -25.969     0.200
     0.267     5.624     0.200
     1.060    -1.276     0.200
     1.115    -0.505     0.200
     1.120    -0.170     0.200
     1.163    -0.730     0.200
     1.166    -1.543     0.200
     1.171    -1.170     0.200
     1.330    -3.281     0.200
     1.384    -2.277     0.200
     1.786    -3.927     0.200
     1.730    -2.975     0.200
     2.640    -8.826     0.200
     3.057   -16.790     0.200
     3.436   -14.962     0.200
     3.600   -18.055     0.200
     3.865   -17.439     0.200
     4.170   -25.124     0.200
     4.773   -35.190     0.200
     5.094   -35.842     0.200
     5.188   -31.595     0.200
     5.236   -31.214     0.200
     5.547   -32.404     0.200
     2.341    -7.319     0.200
     2.797    -9.397     0.200
     3.193   -13.046     0.200
     3.459   -13.125     0.200
     3.597   -13.675     0.200
     4.069   -22.152     0.200
     4.116   -15.906     0.200
     4.116   -17.819     0.200
     4.347   -20.079     0.200
     4.374   -20.192     0.200
     4.522   -19.327     0.200
     4.611   -19.634     0.200
     4.676   -18.590     0.200
     4.684   -19.415     0.200
     4.730   -22.526     0.200
     4.753   -18.163     0.200
     4.853   -21.257     0.200
     4.870   -20.691     0.200
     4.916   -21.283     0.200
     5.140   -25.371     0.200
     5.140   -21.881     0.200
     5.168   -24.254     0.200
     5.168   -21.964     0.200
     5.169   -25.937     0.200
     5.182   -30.117     0.200
     5.234   -24.562     0.200
     5.409   -28.957     0.200
     5.441   -28.562     0.200
     5.736   -28.871     0.200
     5.966   -29.366     0.200
     6.058   -29.871     0.200
     6.197   -31.710     0.200
     6.199   -32.985     0.200
     6.244   -32.631     0.200
     6.226   -36.903     0.200
     6.259   -29.646     0.200
     6.392   -31.929     0.200
     6.547   -35.201     0.200
     6.709   -39.693     0.200
     7.219   -37.924     0.200
     7.361   -39.691     0.200
     0.684     0.887     0.200
     0.807     0.505     0.200
     1.319    -4.539     0.200
     1.650    -5.221     0.200
     1.726    -4.979     0.200
     1.765    -4.696     0.200
     1.778    -4.172     0.200
     1.816    -6.165     0.200
     1.985    -6.122     0.200
     2.404    -8.409     0.200
     2.390    -8.417     0.200
     3.373   -11.348     0.200
     3.505   -23.949     0.200
     3.804   -23.374     0.200
     3.806   -21.581     0.200
     3.784   -15.140     0.200
     3.819   -14.438     0.200
     3.826   -14.831     0.200
     3.871   -15.761     0.200
     4.184   -31.051     0.200
     0.305     5.425     0.200
     1.016    -1.763     0.200
     1.090    -1.030     0.200
     1.138    -0.588     0.200
     1.197    -1.672     0.200
     1.184    -0.440     0.200
     1.353    -3.634     0.200
     1.773    -4.808     0.200
     3.013   -13.659     0.200
     3.340   -11.609     0.200
     3.555   -13.756     0.200
     3.643   -22.165     0.200
     3.819   -18.684     0.200
     4.126   -25.172     0.200
     4.221   -23.027     0.200
     4.221   -19.896     0.200
     4.252   -20.097     0.200
     4.252   -16.537     0.200
     4.256   -22.369     0.200
     4.312   -19.532     0.200
     4.376   -29.040     0.200
     4.726   -31.046     0.200
     5.144   -35.591     0.200
     5.189   -32.495     0.200
     5.501   -36.393     0.200
     5.718   -36.096     0.200
     6.163   -43.776     0.200
     0.889     0.000     0.200
     1.094    -0.868     0.200
     1.026     1.732     0.200
     2.160   -10.385     0.200
     2.715   -12.708     0.200
     3.282   -18.811     0.200
     3.593   -14.534     0.200
     3.603   -13.198     0.200
     3.992   -15.660     0.200
     4.308   -22.138     0.200
     4.692   -23.361     0.200
     1.205     1.335     0.200
     1.239     2.139     0.200
     1.254     2.209     0.200
     1.560    -2.238     0.200
     2.476   -11.040     0.200
     2.814   -12.139     0.200
     3.088   -10.442     0.200
     3.048    -9.576     0.200
     3.108   -15.702     0.200
     3.336   -15.204     0.200
     3.317   -11.525     0.200
     3.502   -11.740     0.200
     3.648   -18.140     0.200
     3.908   -21.201     0.200
     4.107   -18.487     0.200
     4.142   -20.345     0.200
     4.924   -24.023     0.200
     5.249   -24.342     0.200
     5.422   -27.038     0.200
     0.694     0.252     0.200
     0.858     0.359     0.200
     1.331    -1.124     0.200
     1.173    -2.666     0.200
     1.440    -2.790     0.200
     1.531    -3.690     0.200
     1.444    -2.793     0.200
     1.450    -2.190     0.200
     1.486    -2.309     0.200
     1.500    -2.766     0.200
     1.556    -3.568     0.200
     1.834    -6.262     0.200
     2.595   -11.216     0.200
     2.885   -12.016     0.200
     2.959   -11.660     0.200
     3.128   -16.104     0.200
     3.250   -15.493     0.200
     3.315   -15.558     0.200
     3.404   -17.136     0.200
     3.699   -22.678     0.200
     3.594   -14.396     0.200
     3.810   -17.805     0.200
     3.810   -16.565     0.200
     3.842   -16.410     0.200
     3.842   -16.220     0.200
     3.848   -18.723     0.200
     3.938   -22.676     0.200
     3.959   -21.355     0.200
     3.900   -18.241     0.200
     0.789     1.201     0.200
     0.781     1.192     0.200
     1.268    -3.923     0.200
     1.466    -4.911     0.200
     2.527   -11.787     0.200
     2.801   -11.452     0.200
     2.873   -10.372     0.200
     3.055   -15.416     0.200
     3.318   -12.478     0.200
     3.627   -23.105     0.200
     3.856   -24.462     0.200
     3.880   -21.669     0.200
     4.205   -27.746     0.200
     4.526   -28.343     0.200
     4.642   -27.953     0.200
     4.670   -32.179     0.200
     4.986   -33.916     0.200
     1.101     2.132     0.200
     1.354    -3.329     0.200
     1.371    -2.174     0.200
     1.521    -4.250     0.200
     1.597    -3.363     0.200
     1.606    -2.381     0.200
     1.628    -3.901     0.200
     1.678    -4.417     0.200
     1.719    -9.367     0.200
     1.784    -6.281     0.200
     1.855    -4.947     0.200
     1.793    -2.271     0.200
     2.492    -8.306     0.200
     2.568    -9.083     0.200
     2.895   -15.929     0.200
     2.828   -10.934     0.200
     2.931   -13.538     0.200
     3.182   -11.735     0.200
     3.246   -18.566     0.200
     3.246   -14.488     0.200
     3.311   -17.370     0.200
     3.497   -24.721     0.200
     3.558   -20.765     0.200
     3.635   -24.389     0.200
     3.843   -22.144     0.200
     4.165   -25.478     0.200
     4.381   -26.508     0.200
     4.335   -24.246     0.200
     4.479   -32.420     0.200
     4.735   -30.226     0.200
     4.796   -28.408     0.200
     5.483   -35.929     0.200
     6.459   -45.291     0.200
     1.108     0.314     0.200
     1.185     0.765     0.200
     1.184     0.578     0.200
     1.517    -3.891     0.200
     1.889    -6.110     0.200
     2.035    -6.225     0.200
     2.876   -11.593     0.200
     2.957   -15.044     0.200
     3.305   -15.184     0.200
     3.675   -20.135     0.200
     3.759   -17.303     0.200
     3.809   -16.732     0.200
     4.198   -23.265     0.200
     4.601   -26.257     0.200
     4.637   -21.515     0.200
     4.728   -27.987     0.200
     4.692   -18.729     0.200
     5.084   -26.625     0.200
     5.404   -32.966     0.200
     5.530   -27.275     0.200
     5.831   -31.088     0.200
     6.083   -32.810     0.200
     1.074     0.724     0.200
     1.162    -0.860     0.200
     2.029    -7.689     0.200
     1.915    -6.501     0.200
     2.974   -14.587     0.200
     2.929   -10.812     0.200
     3.297   -16.044     0.200
     3.188   -11.420     0.200
     3.686   -14.943     0.200
     3.857   -17.858     0.200
     3.837   -15.127     0.200
     3.812   -19.422     0.200
     4.007   -16.386     0.200
     4.058   -17.911     0.200
     4.114   -17.004     0.200
     4.195   -16.964     0.200
     4.202   -22.193     0.200
     4.223   -21.239     0.200
     4.217   -19.027     0.200
     4.229   -16.541     0.200
     4.317   -17.659     0.200
     4.330   -16.697     0.200
     4.422   -26.513     0.200
     4.388   -19.229     0.200
     4.468   -18.751     0.200
     4.527   -19.656     0.200
     4.664   -22.653     0.200
     4.703   -19.214     0.200
     4.731   -21.383     0.200
     4.729   -24.165     0.200
     4.547   -19.373     0.200
     5.097   -30.113     0.200
     5.090   -23.865     0.200
     5.416   -32.563     0.200
     5.535   -31.804     0.200
     5.772   -26.079     0.200
     6.082   -33.102     0.200
     6.099   -35.882     0.200
     6.463   -35.020     0.200
     7.326   -45.536     0.200
     7.569   -39.549     0.200
     7.871   -39.817     0.200
     8.276   -55.226     0.200
     8.276   -51.369     0.200
     9.991   -57.396     0.200
    10.143   -64.715     0.200
    11.013   -64.762     0.200
     1.392    -1.938     0.200
     2.220    -6.514     0.200
     2.397    -8.900     0.200
     2.575    -8.241     0.200
     3.362   -11.605     0.200
     3.634   -17.996     0.200
     3.842   -20.293     0.200
     3.759   -18.328     0.200
     4.162   -17.609     0.200
     4.203   -19.703     0.200
     4.401   -24.969     0.200
     4.442   -18.618     0.200
     4.491   -19.178     0.200
     4.620   -20.887     0.200
     4.632   -21.208     0.200
     4.635   -19.149     0.200
     4.640   -20.568     0.200
     4.650   -20.776     0.200
     4.688   -27.954     0.200
     4.741   -22.300     0.200
     4.745   -21.214     0.200
     4.772   -20.363     0.200
     4.823   -25.343     0.200
     4.967   -30.480     0.200
     4.976   -20.911     0.200
     5.086   -22.839     0.200
     5.095   -21.290     0.200
     5.114   -22.195     0.200
     5.115   -23.408     0.200
     5.115   -22.658     0.200
     5.254   -30.336     0.200
     5.231   -29.276     0.200
     5.608   -32.410     0.200
     5.929   -33.577     0.200
     6.300   -33.273     0.200
     6.368   -37.624     0.200
     6.398   -30.487     0.200
     6.600   -42.436     0.200
     6.624   -35.556     0.200
     6.863   -38.028     0.200
     7.007   -46.526     0.200
     7.069   -41.954     0.200
     7.069   -41.947     0.200
     7.836   -47.347     0.200
     8.022   -45.788     0.200
     8.522   -46.369     0.200
     8.797   -53.103     0.200
     8.797   -47.963     0.200
     9.455   -58.861     0.200
    10.678   -70.601     0.200
    11.539   -66.156     0.200
     0.462     2.728     0.200
     1.877    -5.970     0.200
     1.927    -6.675     0.200
     2.158    -8.651     0.200
     2.552   -10.318     0.200
     2.688   -10.656     0.200
     2.709   -12.345     0.200
     2.997   -16.012     0.200
     3.186   -14.346     0.200
     3.276   -17.711     0.200
     3.567   -17.025     0.200
     3.584   -19.359     0.200
     3.949   -18.293     0.200
     3.968   -23.769     0.200
     4.284   -26.137     0.200
     4.297   -25.874     0.200
     4.385   -27.535     0.200
     4.679   -24.163     0.200
     4.950   -26.247     0.200
     4.981   -27.159     0.200
     5.073   -27.150     0.200
     5.316   -33.879     0.200
     5.390   -32.401     0.200
     6.329   -40.417     0.200
     1.147     1.779     0.200
     1.217     2.314     0.200
     1.250     1.368     0.200
     1.223     1.833     0.200
     1.266     1.661     0.200
     1.274     2.708     0.200
     1.762    -5.552     0.200
     3.033   -11.063     0.200
     3.387   -15.783     0.200
     3.471   -16.493     0.200
     3.430   -16.456     0.200
     3.585   -17.967     0.200
     3.529   -17.024     0.200
     3.752   -20.351     0.200
     3.697   -12.036     0.200
     3.915   -17.829     0.200
     4.342   -16.678     0.200
     4.469   -18.154     0.200
     4.796   -24.273     0.200
     5.116   -23.723     0.200
     2.268    -9.521     0.200
     2.554    -8.910     0.200
     2.928   -10.448     0.200
     3.062   -14.206     0.200
     3.519   -21.774     0.200
     3.692   -18.590     0.200
     3.794   -15.596     0.200
     4.032   -23.959     0.200
     4.043   -22.143     0.200
     4.240   -19.850     0.200
     4.465   -20.128     0.200
     4.605   -25.617     0.200
     4.758   -29.073     0.200
     5.061   -27.208     0.200
     5.384   -31.253     0.200
     5.579   -26.626     0.200
     5.612   -28.756     0.200
     5.918   -26.589     0.200
     6.019   -34.858     0.200
     1.204    -2.452     0.200
     1.792    -5.580     0.200
     2.009    -7.208     0.200
     2.020    -6.915     0.200
     2.029    -6.534     0.200
     2.371    -8.573     0.200
     2.450    -9.431     0.200
     2.621    -8.999     0.200
     2.648    -9.367     0.200
     2.874   -10.327     0.200
     2.866   -11.446     0.200
     3.038   -13.169     0.200
     3.120   -17.295     0.200
     3.063   -11.397     0.200
     3.065   -11.893     0.200
     3.082   -11.456     0.200
     3.087   -13.186     0.200
     3.142   -15.064     0.200
     3.090   -15.011     0.200
     3.092   -11.857     0.200
     3.089   -12.410     0.200
     3.161   -12.144     0.200
     3.157   -14.954     0.200
     3.192   -16.954     0.200
     3.235   -12.360     0.200
     3.236   -12.976     0.200
     3.337   -14.570     0.200
     3.387   -16.095     0.200
     3.407   -16.800     0.200
     3.406   -18.178     0.200
     3.381   -16.251     0.200
     3.601   -17.130     0.200
     3.786   -19.285     0.200
     3.772   -18.104     0.200
     3.872   -18.027     0.200
     3.912   -16.424     0.200
     3.928   -16.020     0.200
     4.103   -19.130     0.200
     4.210   -20.456     0.200
     4.326   -21.141     0.200
     4.509   -22.253     0.200
     4.529   -19.868     0.200
     4.799   -21.900     0.200
     4.776   -20.207     0.200
     5.158   -31.556     0.200
     5.216   -27.035     0.200
     5.202   -29.662     0.200
     6.014   -33.171     0.200
     6.168   -38.539     0.200
     6.657   -38.511     0.200
     6.955   -38.318     0.200
     8.669   -51.281     0.200
     9.689   -55.899     0.200
     9.820   -58.592     0.200
    11.565   -67.404     0.200
     0.883    -2.128     0.200
     1.175    -2.381     0.200
     1.108    -3.613     0.200
     1.618    -5.990     0.200
     1.595    -4.492     0.200
     1.582    -3.349     0.200
     1.585    -3.591     0.200
     1.615    -3.404     0.200
     1.707    -4.801     0.200
     1.707    -3.167     0.200
     1.969    -5.927     0.200
     2.429   -13.063     0.200
     2.696   -15.605     0.200
     2.954   -18.665     0.200
     2.836   -14.549     0.200
     3.070   -10.951     0.200
     3.218   -19.263     0.200
     3.334   -16.884     0.200
     3.526   -18.241     0.200
     3.644   -15.587     0.200
     3.650   -12.095     0.200
     3.662   -17.777     0.200
     3.751   -21.068     0.200
     3.775   -20.746     0.200
     4.100   -23.687     0.200
     4.564   -22.659     0.200
     4.881   -33.267     0.200
     0.600     1.070     0.200
     0.880     1.802     0.200
     0.961     0.200     0.200
     0.917     2.178     0.200
     0.997     1.503     0.200
     1.882    -3.099     0.200
     2.657    -8.859     0.200
     3.136   -13.272     0.200
     3.186   -13.735     0.200
     3.332   -21.313     0.200
     3.330   -17.835     0.200
     3.349   -18.046     0.200
     3.208   -14.413     0.200
     3.518   -14.328     0.200
     3.652   -17.137     0.200
     3.733   -18.112     0.200
     4.124   -19.697     0.200
     4.157   -24.104     0.200
     4.155   -20.669     0.200
     4.225   -26.357     0.200
     4.397   -21.987     0.200
     4.443   -21.634     0.200
     4.714   -22.218     0.200
     1.139    -0.910     0.200
     1.166    -1.074     0.200
     1.653    -5.681     0.200
     1.982    -5.439     0.200
     2.232    -9.472     0.200
     2.467   -12.985     0.200
     2.702   -10.097     0.200
     2.712    -9.449     0.200
     2.920   -15.056     0.200
     2.954   -14.955     0.200
     3.202   -14.933     0.200
     3.260   -14.099     0.200
     3.294   -19.359     0.200
     3.455   -20.083     0.200
     3.456   -18.407     0.200
     3.507   -14.667     0.200
     3.578   -15.347     0.200
     3.642   -16.303     0.200
     3.651   -20.707     0.200
     3.653   -15.768     0.200
     3.663   -13.420     0.200
     3.670   -17.430     0.200
     3.685   -21.985     0.200
     3.694   -23.896     0.200
     4.026   -23.743     0.200
     4.112   -18.362     0.200
     4.115   -16.206     0.200
     4.122   -20.577     0.200
     4.258   -21.556     0.200
     4.283   -20.951     0.200
     4.269   -17.655     0.200
     4.602   -27.158     0.200
     4.923   -29.214     0.200
     5.042   -29.421     0.200
     5.073   -29.757     0.200
     5.291   -30.334     0.200
     5.389   -28.070     0.200
     5.591   -35.642     0.200
     6.061   -37.577     0.200
     6.828   -42.503     0.200
     7.796   -50.410     0.200
     1.193     2.328     0.200
     1.197     2.611     0.200
     1.210     2.395     0.200
     1.221     2.059     0.200
     1.348     1.657     0.200
     1.495    -1.091     0.200
     2.009    -3.267     0.200
     2.510   -10.017     0.200
     3.016   -11.035     0.200
     3.048   -12.586     0.200
     2.988    -9.209     0.200
     3.151   -10.805     0.200
     3.092   -10.664     0.200
     4.039   -15.988     0.200
     4.070   -18.613     0.200
     4.150   -14.424     0.200
     4.270   -21.546     0.200
     4.590   -18.731     0.200
     4.858   -26.756     0.200
     5.174   -23.729     0.200
     0.933    -0.186     0.200
     0.993     0.474     0.200
     2.587    -8.689     0.200
     3.321   -13.358     0.200
     3.619   -13.991     0.200
     3.621   -16.881     0.200
     3.622   -13.781     0.200
     3.632   -14.591     0.200
     4.002   -15.878     0.200
     4.341   -21.430     0.200
     4.319   -28.837     0.200
     4.424   -19.787     0.200
     4.720   -26.482     0.200
     5.014   -25.935     0.200
     1.345     0.561     0.200
     2.525   -11.244     0.200
     2.578    -8.612     0.200
     2.742   -15.933     0.200
     2.802   -12.491     0.200
     2.890   -14.331     0.200
     2.920   -13.641     0.200
     2.955   -12.072     0.200
     3.024   -12.452     0.200
     3.007   -13.464     0.200
     3.050   -11.475     0.200
     3.117   -11.000     0.200
     3.157   -14.981     0.200
     3.378   -15.072     0.200
     3.515   -15.158     0.200
     3.536   -18.928     0.200
     3.643   -15.049     0.200
     4.057   -22.740     0.200
     4.093   -23.115     0.200
     4.169   -19.815     0.200
     4.285   -21.882     0.200
     4.605   -24.040     0.200
     4.831   -29.117     0.200
     4.875   -27.985     0.200
     5.051   -29.012     0.200
     5.186   -28.314     0.200
     5.253   -29.806     0.200
     5.842   -36.626     0.200
     6.039   -37.959     0.200
     6.447   -35.112     0.200
     7.473   -39.830     0.200
     0.282     4.027     0.200
     0.918    -1.216     0.200
     0.996    -0.747     0.200
     1.102    -1.279     0.200
     1.099    -0.144     0.200
     1.107    -0.448     0.200
     1.382    -2.942     0.200
     1.370    -2.574     0.200
     1.841    -7.757     0.200
     2.044   -10.580     0.200
     2.109    -8.130     0.200
     3.111   -16.360     0.200
     3.410   -15.925     0.200
     3.362   -15.927     0.200
     3.470   -18.345     0.200
     3.499   -22.117     0.200
     3.521   -11.813     0.200
     3.652   -18.915     0.200
     3.657   -21.711     0.200
     3.708   -19.958     0.200
     3.780   -21.697     0.200
     3.817   -19.965     0.200
     3.892   -23.189     0.200
     3.985   -18.632     0.200
     4.222   -25.898     0.200
     4.292   -21.843     0.200
     4.279   -27.697     0.200
     4.277   -21.167     0.200
     4.327   -26.861     0.200
     4.384   -20.866     0.200
     4.466   -25.171     0.200
     4.439   -25.582     0.200
     4.489   -22.996     0.200
     4.812   -28.368     0.200
     5.133   -29.379     0.200
     5.240   -33.898     0.200
     5.280   -29.117     0.200
     0.051    19.040     0.200
     0.209    15.530     0.200
     0.232    15.168     0.200
     0.521     7.888     0.200
     1.145    -0.861     0.200
     1.231    -2.285     0.200
     1.734    -5.648     0.200
     2.465   -13.267     0.200
     3.494   -20.375     0.200
     4.137   -27.939     0.200
     4.127   -20.901     0.200
     4.266   -27.892     0.200
     4.261   -25.960     0.200
     4.540   -26.097     0.200
     4.908   -27.355     0.200
     4.908   -20.905     0.200
     4.944   -25.800     0.200
     4.955   -26.454     0.200
     5.215   -35.029     0.200
     5.332   -36.475     0.200
     5.612   -38.327     0.200
     5.935   -40.910     0.200
     6.155   -43.755     0.200
     6.217   -42.030     0.200
     6.504   -43.485     0.200
     6.548   -44.618     0.200
     0.242     6.266     0.200
     0.866    -0.896     0.200
     0.966    -0.015     0.200
     1.070    -0.855     0.200
     1.081    -0.214     0.200
     1.088    -0.535     0.200
     1.421    -3.789     0.200
     1.894    -9.266     0.200
     1.988    -9.847     0.200
     2.204    -8.389     0.200
     2.819   -12.065     0.200
     2.865   -11.173     0.200
     3.165   -16.958     0.200
     3.472   -16.266     0.200
     3.533   -17.745     0.200
     3.708   -20.570     0.200
     3.771   -21.051     0.200
     3.955   -20.896     0.200
     4.278   -26.616     0.200
     4.291   -21.558     0.200
     4.339   -22.900     0.200
     4.390   -21.385     0.200
     4.527   -27.039     0.200
     4.548   -20.122     0.200
     4.537   -22.884     0.200
     4.874   -28.750     0.200
     5.195   -31.669     0.200
     5.296   -37.199     0.200
     5.340   -30.143     0.200
     5.563   -29.877     0.200
     5.653   -31.920     0.200
     5.864   -31.477     0.200
     5.917   -31.147     0.200
     1.047     0.761     0.200
     1.142     0.998     0.200
     1.198     1.898     0.200
     3.583   -16.277     0.200
     3.666   -14.015     0.200
     3.775   -15.679     0.200
     4.106   -15.904     0.200
     4.466   -19.137     0.200
     4.546   -23.901     0.200
     4.631   -22.591     0.200
     4.992   -22.287     0.200
     5.312   -31.998     0.200
     5.439   -26.178     0.200
     5.699   -27.135     0.200
     5.741   -33.725     0.200
     5.991   -35.456     0.200
     6.382   -34.373     0.200
     6.444   -31.306     0.200
     7.221   -42.272     0.200
     8.176   -49.432     0.200
     1.063     0.605     0.200
     1.157    -1.187     0.200
     1.220     0.644     0.200
     1.965    -7.325     0.200
     3.235   -16.582     0.200
     3.608   -16.038     0.200
     3.695   -17.945     0.200
     3.792   -21.458     0.200
     4.138   -17.204     0.200
     4.358   -26.768     0.200
     4.498   -22.494     0.200
     4.542   -21.140     0.200
     4.571   -21.777     0.200
     4.660   -26.981     0.200
     4.654   -21.972     0.200
     4.632   -19.305     0.200
     4.690   -24.019     0.200
     4.753   -24.500     0.200
     4.782   -20.994     0.200
     5.338   -33.772     0.200
     5.462   -30.432     0.200
     5.728   -31.868     0.200
     5.762   -30.544     0.200
     6.018   -30.753     0.200
     1.007     0.818     0.200
     2.136    -6.798     0.200
     2.472    -9.726     0.200
     2.508    -8.206     0.200
     2.679   -11.753     0.200
     2.929   -11.526     0.200
     3.095   -13.057     0.200
     3.240   -14.411     0.200
     3.217   -13.137     0.200
     3.260   -12.187     0.200
     3.328   -11.958     0.200
     3.430   -14.189     0.200
     3.570   -15.223     0.200
     3.695   -17.266     0.200
     3.703   -16.689     0.200
     3.716   -16.625     0.200
     3.719   -17.157     0.200
     3.718   -16.871     0.200
     3.719   -17.009     0.200
     3.804   -17.462     0.200
     3.749   -17.461     0.200
     3.747   -17.373     0.200
     3.768   -14.275     0.200
     3.768   -17.442     0.200
     3.805   -17.296     0.200
     3.830   -17.349     0.200
     3.840   -16.422     0.200
     3.870   -16.946     0.200
     3.896   -17.584     0.200
     3.947   -17.964     0.200
     4.121   -20.152     0.200
     4.111   -17.832     0.200
     4.128   -20.144     0.200
     4.145   -18.466     0.200
     4.146   -18.505     0.200
     4.193   -18.450     0.200
     4.232   -19.081     0.200
     4.253   -19.684     0.200
     4.253   -19.666     0.200
     4.565   -20.268     0.200
     4.673   -21.835     0.200
     4.693   -20.085     0.200
     4.827   -26.215     0.200
     4.930   -24.347     0.200
     5.220   -28.831     0.200
     5.246   -26.704     0.200
     5.415   -30.210     0.200
     5.439   -22.319     0.200
     5.521   -27.852     0.200
     5.845   -32.311     0.200
     5.893   -36.058     0.200
     5.935   -32.323     0.200
     5.935   -32.315     0.200
     5.944   -30.808     0.200
     5.964   -33.316     0.200
     6.091   -33.098     0.200
     6.067   -34.440     0.200
     6.327   -31.741     0.200
     6.738   -37.397     0.200
     6.861   -40.942     0.200
     7.504   -39.103     0.200
     7.677   -39.967     0.200
     7.677   -47.670     0.200
     7.677   -46.071     0.200
     9.202   -53.509     0.200
     9.853   -58.682     0.200
    10.607   -66.300     0.200
    10.638   -66.583     0.200
    10.730   -65.440     0.200
    11.227   -68.932     0.200
    11.289   -71.565     0.200
    12.277   -72.528     0.200
    13.102   -82.625     0.200
     1.196     3.043     0.200
     1.339     2.514     0.200
     1.428     1.538     0.200
     1.963    -2.281     0.200
     2.728    -8.247     0.200
     2.869    -8.326     0.200
     3.143   -10.871     0.200
     3.322   -14.971     0.200
     3.366   -10.296     0.200
     3.481   -11.087     0.200
     4.021   -16.656     0.200
     4.040   -13.278     0.200
     4.127   -16.712     0.200
     1.107     1.547     0.200
     1.185     0.845     0.200
     1.512    -2.831     0.200
     2.964    -9.952     0.200
     3.310   -12.620     0.200
     3.682   -15.564     0.200
     3.709   -13.869     0.200
     3.709   -15.677     0.200
     3.765   -14.897     0.200
     3.816   -18.765     0.200
     3.868   -16.491     0.200
     3.982   -14.699     0.200
     4.148   -19.060     0.200
     4.176   -22.597     0.200
     4.205   -19.716     0.200
     4.204   -23.531     0.200
     4.219   -19.908     0.200
     4.307   -21.392     0.200
     4.304   -19.218     0.200
     4.364   -22.461     0.200
     4.434   -19.516     0.200
     2.651    -9.518     0.200
     3.089   -15.723     0.200
     3.086   -12.640     0.200
     3.862   -16.251     0.200
     4.057   -16.451     0.200
     4.215   -19.236     0.200
     4.464   -19.215     0.200
     4.483   -20.332     0.200
     4.489   -21.284     0.200
     4.493   -20.255     0.200
     4.496   -19.601     0.200
     4.533   -22.100     0.200
     4.533   -20.131     0.200
     4.613   -20.140     0.200
     4.671   -22.626     0.200
     4.816   -21.629     0.200
     4.907   -30.324     0.200
     5.237   -25.492     0.200
     5.226   -29.636     0.200
     5.337   -28.835     0.200
     5.630   -24.988     0.200
     5.630   -30.085     0.200
     6.201   -31.145     0.200
     6.256   -41.383     0.200
     0.799     1.394     0.200
     1.010    -2.004     0.200
     1.289    -5.300     0.200
     1.513    -3.575     0.200
     1.475    -4.694     0.200
     1.641    -5.070     0.200
     1.913    -7.131     0.200
     2.367    -9.984     0.200
     2.503   -15.884     0.200
     2.665   -12.500     0.200
     2.695   -11.062     0.200
     3.000   -17.541     0.200
     2.967   -13.962     0.200
     3.057   -15.695     0.200
     3.107   -15.032     0.200
     3.573   -22.466     0.200
     3.507   -18.500     0.200
     3.533   -18.723     0.200
     3.535   -19.395     0.200
     3.537   -18.847     0.200
     3.541   -16.710     0.200
     3.729   -20.646     0.200
     3.776   -22.228     0.200
     4.051   -26.109     0.200
     4.374   -27.788     0.200
     4.576   -32.325     0.200
     4.549   -28.399     0.200
     4.882   -29.076     0.200
     5.030   -29.691     0.200
     1.584    -7.680     0.200
     1.596    -5.255     0.200
     1.694    -4.928     0.200
     1.702    -6.273     0.200
     2.213    -8.196     0.200
     2.229    -9.615     0.200
     2.366    -9.102     0.200
     2.610    -9.963     0.200
     3.083   -15.615     0.200
     3.177   -13.656     0.200
     3.174   -15.324     0.200
     3.241   -13.094     0.200
     3.321   -14.682     0.200
     3.440   -13.808     0.200
     3.695   -16.698     0.200
     3.698   -18.369     0.200
     3.703   -14.721     0.200
     3.726   -14.776     0.200
     3.737   -16.352     0.200
     3.804   -16.194     0.200
     3.819   -19.051     0.200
     3.982   -18.391     0.200
     3.988   -20.865     0.200
     4.075   -19.537     0.200
     4.074   -19.770     0.200
     4.088   -20.600     0.200
     4.098   -22.058     0.200
     4.103   -20.591     0.200
     4.109   -20.617     0.200
     4.117   -16.851     0.200
     4.248   -21.788     0.200
     4.275   -21.942     0.200
     4.461   -19.517     0.200
     4.755   -23.804     0.200
     4.759   -24.186     0.200
     4.777   -24.996     0.200
     4.872   -25.531     0.200
     5.159   -31.616     0.200
     5.203   -28.192     0.200
     5.397   -30.364     0.200
     5.475   -33.404     0.200
     5.778   -31.538     0.200
     5.862   -33.180     0.200
     5.877   -31.387     0.200
     6.094   -27.871     0.200
     7.622   -44.525     0.200
     1.719    -4.681     0.200
     3.838   -16.887     0.200
     4.581   -19.633     0.200
     5.010   -22.283     0.200
     8.186   -48.875     0.200
     0.250     6.049     0.200
     1.118    -1.178     0.200
     1.121     0.059     0.200
     1.383    -4.073     0.200
     1.400    -3.076     0.200
     1.676    -6.527     0.200
     1.839    -9.181     0.200
     2.043    -8.983     0.200
     2.688   -11.813     0.200
     2.895   -16.537     0.200
     2.854    -9.961     0.200
     3.110   -16.455     0.200
     3.398   -11.432     0.200
     3.483   -17.509     0.200
     3.653   -20.723     0.200
     3.839   -14.306     0.200
     3.874   -15.938     0.200
     3.882   -20.213     0.200
     4.004   -13.744     0.200
     4.223   -23.095     0.200
     4.305   -21.291     0.200
     4.308   -19.701     0.200
     4.345   -16.982     0.200
     4.436   -19.761     0.200
     4.474   -26.449     0.200
     4.822   -30.395     0.200
     5.143   -33.161     0.200
     5.241   -33.189     0.200
     5.287   -28.773     0.200
     5.514   -29.989     0.200
     5.599   -30.607     0.200
     5.813   -29.736     0.200
     6.261   -43.028     0.200
     6.290   -41.555     0.200
     6.851   -32.135     0.200
     7.049   -39.099     0.200
     7.269   -46.717     0.200
     7.259   -40.321     0.200
     8.014   -50.850     0.200
     8.014   -45.522     0.200
     8.694   -52.007     0.200
     1.440    -5.992     0.200
     1.530    -5.233     0.200
     1.988    -9.153     0.200
     2.237    -8.118     0.200
     2.818   -10.612     0.200
     2.863   -11.850     0.200
     3.043   -14.328     0.200
     3.259   -17.594     0.200
     3.480   -19.936     0.200
     3.503   -19.496     0.200
     3.496   -15.032     0.200
     3.555   -18.533     0.200
     3.627   -17.521     0.200
     3.778   -20.484     0.200
     3.800   -18.373     0.200
     3.831   -20.186     0.200
     3.933   -23.472     0.200
     3.975   -19.555     0.200
     3.978   -20.734     0.200
     4.083   -23.342     0.200
     4.090   -19.721     0.200
     4.110   -23.474     0.200
     4.162   -22.982     0.200
     4.184   -25.135     0.200
     4.240   -23.491     0.200
     4.240   -20.522     0.200
     4.371   -23.457     0.200
     4.380   -21.880     0.200
     4.379   -21.865     0.200
     4.421   -23.909     0.200
     4.443   -24.603     0.200
     4.449   -26.739     0.200
     4.450   -23.736     0.200
     4.451   -23.919     0.200
     4.451   -25.563     0.200
     4.454   -23.185     0.200
     4.455   -23.227     0.200
     4.612   -27.580     0.200
     4.638   -26.345     0.200
     4.954   -31.110     0.200
     5.276   -31.391     0.200
     5.388   -34.267     0.200
     5.426   -31.629     0.200
     5.623   -28.793     0.200
     5.637   -34.076     0.200
     5.742   -35.804     0.200
     5.941   -35.820     0.200
     5.916   -32.572     0.200
     6.200   -34.031     0.200
     6.408   -38.957     0.200
     6.429   -35.155     0.200
     6.429   -35.148     0.200
     6.732   -34.391     0.200
     7.241   -37.822     0.200
     7.415   -47.277     0.200
     0.488     2.779     0.200
     0.970    -0.901     0.200
     1.201    -0.930     0.200
     1.714    -3.888     0.200
     1.811    -7.892     0.200
     2.006    -9.874     0.200
     2.226   -11.131     0.200
     2.522   -12.479     0.200
     2.618   -12.780     0.200
     2.656    -9.890     0.200
     2.570   -10.834     0.200
     2.661   -11.800     0.200
     2.715   -14.617     0.200
     2.755   -15.359     0.200
     2.746   -11.893     0.200
     2.918   -13.489     0.200
     2.964   -14.597     0.200
     2.930   -14.457     0.200
     3.095   -11.952     0.200
     3.112   -15.037     0.200
     3.113   -13.558     0.200
     3.119   -14.240     0.200
     3.139   -13.800     0.200
     3.221   -12.258     0.200
     3.235   -14.113     0.200
     3.268   -14.263     0.200
     3.289   -13.662     0.200
     3.327   -22.552     0.200
     3.264   -11.989     0.200
     3.307   -15.382     0.200
     3.399   -16.807     0.200
     3.513   -17.216     0.200
     3.521   -13.892     0.200
     3.526   -16.228     0.200
     3.539   -22.381     0.200
     3.531   -13.416     0.200
     3.536   -18.114     0.200
     3.538   -18.153     0.200
     3.571   -22.134     0.200
     3.533   -13.802     0.200
     3.631   -17.188     0.200
     3.673   -17.229     0.200
     3.673   -17.210     0.200
     3.700   -22.539     0.200
     3.725   -18.200     0.200
     3.932   -25.165     0.200
     3.957   -21.217     0.200
     4.342   -25.423     0.200
     4.382   -28.551     0.200
     4.650   -28.571     0.200
     4.934   -29.658     0.200
     5.361   -36.933     0.200
     5.386   -33.441     0.200
     5.386   -33.433     0.200
     5.615   -35.348     0.200
     6.366   -43.135     0.200
     6.294   -39.580     0.200
     7.115   -47.959     0.200
     7.115   -46.674     0.200
     7.127   -43.710     0.200
     7.383   -42.864     0.200
     7.570   -43.567     0.200
     9.000   -61.851     0.200
    10.086   -69.425     0.200
    10.113   -69.731     0.200
    10.208   -68.186     0.200
    13.351   -97.230     0.200
    13.351   -88.945     0.200
     0.870     3.192     0.200
     1.145    -0.468     0.200
     1.136     0.941     0.200
     1.154     0.720     0.200
     1.256    -1.473     0.200
     1.635    -6.089     0.200
     1.635    -2.169     0.200
     1.989    -8.375     0.200
     1.989    -8.804     0.200
     1.907    -6.012     0.200
     2.332    -9.134     0.200
     2.283    -8.231     0.200
     2.589    -9.965     0.200
     2.589   -11.026     0.200
     2.657   -13.827     0.200
     2.672   -12.132     0.200
     2.842   -11.019     0.200
     2.882   -15.021     0.200
     2.869   -11.144     0.200
     2.899   -10.728     0.200
     3.042   -14.854     0.200
     3.037   -14.028     0.200
     3.053   -13.771     0.200
     3.176   -13.543     0.200
     3.229   -12.445     0.200
     3.324   -15.951     0.200
     3.385   -17.784     0.200
     3.356   -15.776     0.200
     3.372   -15.570     0.200
     3.372   -15.787     0.200
     3.379   -15.026     0.200
     3.419   -12.677     0.200
     3.438   -17.996     0.200
     3.478   -16.373     0.200
     3.482   -17.557     0.200
     3.512   -12.081     0.200
     3.561   -17.673     0.200
     3.573   -15.963     0.200
     3.770   -15.041     0.200
     3.831   -18.129     0.200
     3.834   -19.750     0.200
     3.860   -18.415     0.200
     3.861   -19.522     0.200
     3.863   -19.229     0.200
     3.862   -19.488     0.200
     3.863   -17.621     0.200
     3.957   -25.115     0.200
     3.973   -16.807     0.200
     3.973   -21.397     0.200
     4.049   -23.967     0.200
     4.052   -20.821     0.200
     4.108   -24.124     0.200
     4.108   -26.223     0.200
     4.742   -27.203     0.200
     4.928   -30.709     0.200
     4.881   -21.145     0.200
     4.961   -28.276     0.200
     5.071   -29.618     0.200
     5.265   -30.048     0.200
     5.388   -32.398     0.200
     5.392   -24.016     0.200
     5.603   -32.526     0.200
     5.604   -25.701     0.200
     5.924   -35.320     0.200
     5.924   -35.314     0.200
     5.975   -35.037     0.200
     6.636   -39.431     0.200
     6.717   -36.167     0.200
     6.789   -36.224     0.200
     6.968   -44.851     0.200
     7.293   -41.388     0.200
     7.623   -50.019     0.200
     7.623   -46.523     0.200
     8.568   -46.997     0.200
     9.126   -55.231     0.200
     9.335   -61.402     0.200
     9.556   -63.001     0.200
     9.570   -56.392     0.200
    10.374   -67.218     0.200
    10.651   -71.291     0.200
    10.675   -71.584     0.200
    10.773   -73.130     0.200
    11.243   -74.579     0.200
    12.356   -85.416     0.200
    13.674   -93.647     0.200
     1.413     1.573     0.200
     1.559    -1.545     0.200
     1.546    -1.892     0.200
     2.049    -4.314     0.200
     2.999    -8.527     0.200
     3.193   -11.294     0.200
     3.515   -10.723     0.200
     4.048   -19.384     0.200
     4.092   -14.452     0.200
     2.061    -7.957     0.200
     2.177    -8.267     0.200
     2.415   -12.260     0.200
     2.691   -11.460     0.200
     2.751   -10.094     0.200
     2.819   -10.437     0.200
     3.058   -13.891     0.200
     3.410   -15.014     0.200
     3.429   -15.183     0.200
     3.431   -16.506     0.200
     3.442   -16.638     0.200
     3.447   -16.815     0.200
     3.463   -15.940     0.200
     3.505   -13.716     0.200
     3.991   -16.569     0.200
     4.057   -19.031     0.200
     4.523   -17.876     0.200
     4.806   -22.159     0.200
     5.189   -26.572     0.200
     1.224    -3.692     0.200
     2.095    -8.311     0.200
     2.216    -8.012     0.200
     2.494   -12.054     0.200
     2.677   -13.086     0.200
     3.026   -11.628     0.200
     3.051   -13.651     0.200
     3.510   -14.903     0.200
     3.466   -13.410     0.200
     3.617   -21.983     0.200
     3.934   -21.280     0.200
     3.962   -19.209     0.200
     3.963   -19.248     0.200
     4.098   -15.572     0.200
     4.099   -15.591     0.200
     4.316   -24.095     0.200
     4.633   -21.652     0.200
     4.736   -28.306     0.200
     4.700   -21.925     0.200
     5.028   -27.860     0.200
     5.054   -22.154     0.200
     5.658   -28.270     0.200
     5.741   -24.976     0.200
     6.210   -29.057     0.200
     6.544   -43.991     0.200
     7.409   -37.536     0.200
     7.843   -37.216     0.200
     9.197   -50.137     0.200
     9.338   -59.906     0.200
     9.271   -51.961     0.200
     9.845   -52.320     0.200
    10.215   -62.535     0.200
     1.045    -0.376     0.200
     2.496   -12.923     0.200
     3.561   -19.721     0.200
     3.505   -17.024     0.200
     4.350   -25.331     0.200
     4.529   -28.630     0.200
     4.563   -23.066     0.200
     4.864   -25.132     0.200
     5.003   -27.366     0.200
     0.482     3.029     0.200
     0.973    -1.267     0.200
     1.749    -6.824     0.200
     1.807    -6.715     0.200
     1.991    -9.482     0.200
     1.919    -7.733     0.200
     2.213   -12.411     0.200
     2.470   -11.157     0.200
     2.552   -11.338     0.200
     2.732   -14.739     0.200
     2.637   -11.405     0.200
     2.955   -13.999     0.200
     3.013   -18.840     0.200
     3.141   -13.411     0.200
     3.304   -21.469     0.200
     3.422   -14.606     0.200
     3.439   -17.589     0.200
     3.461   -16.367     0.200
     3.545   -19.599     0.200
     4.197   -27.428     0.200
     4.316   -28.832     0.200
     4.338   -25.858     0.200
     4.654   -28.262     0.200
     4.874   -32.711     0.200
     5.334   -35.183     0.200
     5.341   -34.054     0.200
     6.104   -41.336     0.200
     6.336   -44.744     0.200
     7.065   -47.363     0.200
     7.065   -48.902     0.200
     1.284     2.381     0.200
     1.417     1.877     0.200
     1.567    -1.591     0.200
     2.018    -2.952     0.200
     2.179    -5.121     0.200
     2.922    -8.651     0.200
     3.081   -13.342     0.200
     3.089   -11.777     0.200
     3.149   -11.100     0.200
     3.466   -10.338     0.200
     3.492   -14.268     0.200
     4.000   -18.320     0.200
     4.047   -17.148     0.200
     4.115   -17.128     0.200
     4.223   -20.957     0.200
     4.542   -24.084     0.200
     4.589   -16.894     0.200
     4.764   -22.198     0.200
     4.817   -21.598     0.200
     5.001   -23.869     0.200
     5.120   -23.995     0.200
     5.196   -23.266     0.200
     5.781   -29.511     0.200
     5.987   -31.550     0.200
     5.980   -27.721     0.200
     6.240   -28.552     0.200
     1.289     2.705     0.200
     1.584    -0.884     0.200
     2.526    -6.135     0.200
     2.812    -9.856     0.200
     2.918    -9.565     0.200
     3.039   -10.079     0.200
     3.078   -13.284     0.200
     3.162   -10.732     0.200
     3.332   -10.193     0.200
     3.454   -10.985     0.200
     3.459   -13.101     0.200
     3.973   -16.668     0.200
     4.010   -15.862     0.200
     4.085   -16.754     0.200
     4.202   -15.843     0.200
     4.522   -21.936     0.200
     4.629   -19.847     0.200
     4.751   -21.971     0.200
     4.791   -19.474     0.200
     4.967   -22.597     0.200
     5.105   -24.358     0.200
     5.168   -22.791     0.200
     5.758   -26.719     0.200
     5.955   -27.021     0.200
     6.028   -28.298     0.200
     6.415   -28.666     0.200
     0.662     1.536     0.200
     1.153    -2.613     0.200
     1.891    -6.369     0.200
     2.393   -12.493     0.200
     2.626    -9.448     0.200
     2.908   -15.896     0.200
     3.129   -12.777     0.200
     3.481   -20.935     0.200
     3.684   -18.446     0.200
     3.715   -17.839     0.200
     4.026   -23.182     0.200
     1.246    -1.020     0.200
     2.311    -9.448     0.200
     3.160   -11.899     0.200
     3.453   -14.187     0.200
     3.479   -12.139     0.200
     3.531   -14.591     0.200
     3.927   -16.259     0.200
     3.934   -16.314     0.200
     3.938   -16.322     0.200
     3.940   -16.861     0.200
     3.962   -16.908     0.200
     3.965   -16.255     0.200
     3.973   -17.109     0.200
     4.024   -18.706     0.200
     4.032   -15.644     0.200
     4.086   -17.555     0.200
     4.244   -18.986     0.200
     4.352   -20.542     0.200
     4.357   -17.414     0.200
     4.365   -17.613     0.200
     4.367   -19.042     0.200
     4.376   -21.239     0.200
     4.447   -21.047     0.200
     4.453   -18.759     0.200
     4.540   -26.487     0.200
     4.704   -23.447     0.200
     4.749   -23.737     0.200
     4.807   -22.750     0.200
     0.901     1.396     0.200
     2.435   -11.383     0.200
     2.687   -12.651     0.200
     2.754   -12.396     0.200
     2.956   -15.415     0.200
     3.046   -12.923     0.200
     3.198   -14.896     0.200
     3.529   -20.276     0.200
     3.604   -15.478     0.200
     3.625   -15.974     0.200
     3.630   -14.925     0.200
     3.633   -16.935     0.200
     3.636   -15.807     0.200
     3.641   -18.003     0.200
     3.743   -19.148     0.200
     3.771   -19.897     0.200
     4.089   -22.138     0.200
     4.410   -27.255     0.200
     4.541   -27.367     0.200
     4.558   -25.828     0.200
     4.877   -27.926     0.200
     5.082   -34.788     0.200
     5.558   -34.125     0.200
     0.849    -0.268     0.200
     1.211    -3.534     0.200
     1.597    -2.970     0.200
     1.671    -3.991     0.200
     1.722    -2.515     0.200
     1.722    -4.695     0.200
     2.245    -9.337     0.200
     2.335   -12.322     0.200
     2.466   -12.826     0.200
     2.992   -15.029     0.200
     3.025   -11.366     0.200
     3.238   -12.135     0.200
     3.251   -19.243     0.200
     3.245   -13.380     0.200
     3.248   -14.446     0.200
     3.268   -12.873     0.200
     3.269   -12.594     0.200
     3.283   -13.556     0.200
     3.366   -12.897     0.200
     3.564   -20.802     0.200
     3.657   -16.495     0.200
     3.657   -14.495     0.200
     3.683   -18.637     0.200
     3.788   -23.175     0.200
     3.813   -22.184     0.200
     3.758   -19.295     0.200
     3.757   -19.277     0.200
     3.866   -20.419     0.200
     4.137   -25.442     0.200
     4.198   -16.595     0.200
     4.457   -28.680     0.200
     4.577   -29.297     0.200
     4.602   -28.092     0.200
     4.837   -26.655     0.200
     4.919   -30.816     0.200
     4.940   -23.619     0.200
     5.131   -30.968     0.200
     5.596   -39.651     0.200
     5.605   -35.324     0.200
     5.605   -35.317     0.200
     5.594   -24.303     0.200
     6.364   -43.675     0.200
     6.599   -45.803     0.200
     7.066   -39.419     0.200
     7.178   -40.440     0.200
     7.327   -46.695     0.200
     7.327   -50.910     0.200
     7.983   -53.727     0.200
     9.042   -59.075     0.200
     9.224   -61.384     0.200
     9.505   -57.527     0.200
    10.071   -55.047     0.200
    13.515   -94.389     0.200
     1.177     0.698     0.200
     2.100    -6.247     0.200
     2.386    -7.732     0.200
     2.485    -8.601     0.200
     2.624   -11.177     0.200
     2.702   -11.157     0.200
     2.803    -8.022     0.200
     2.961    -9.091     0.200
     3.372   -12.202     0.200
     3.372   -11.762     0.200
     3.386   -13.252     0.200
     3.396   -12.718     0.200
     3.401   -15.385     0.200
     3.381   -11.103     0.200
     3.406   -12.406     0.200
     3.573   -16.074     0.200
     0.458     3.139     0.200
     1.133    -1.677     0.200
     1.285    -2.010     0.200
     1.302    -3.413     0.200
     1.370    -1.838     0.200
     1.394    -2.597     0.200
     1.527    -6.184     0.200
     2.354   -12.385     0.200
     2.582   -13.598     0.200
     2.798    -9.609     0.200
     3.118   -14.417     0.200
     3.106   -11.326     0.200
     3.160   -10.649     0.200
     3.196   -12.986     0.200
     3.340   -16.804     0.200
     3.480   -13.479     0.200
     3.620   -15.938     0.200
     3.620   -12.603     0.200
     3.624   -14.110     0.200
     3.627   -13.316     0.200
     3.643   -15.339     0.200
     3.646   -12.754     0.200
     3.652   -16.959     0.200
     3.626   -13.801     0.200
     3.664   -16.673     0.200
     3.669   -18.839     0.200
     3.708   -18.073     0.200
     3.742   -13.818     0.200
     3.750   -13.409     0.200
     3.810   -22.605     0.200
     3.945   -15.951     0.200
     4.045   -16.778     0.200
     4.045   -14.117     0.200
     4.067   -19.482     0.200
     4.071   -16.283     0.200
     4.074   -19.387     0.200
     4.077   -13.797     0.200
     4.169   -24.428     0.200
     4.105   -20.520     0.200
     4.185   -26.005     0.200
     4.403   -23.120     0.200
     4.438   -23.409     0.200
     4.524   -28.449     0.200
     4.845   -28.622     0.200
     4.929   -31.852     0.200
     4.980   -31.497     0.200
     5.229   -32.526     0.200
     5.289   -32.667     0.200
     5.259   -22.430     0.200
     5.521   -34.783     0.200
     5.829   -32.683     0.200
     5.984   -33.479     0.200
     6.753   -43.505     0.200
     7.057   -34.454     0.200
     7.241   -38.739     0.200
     7.608   -39.535     0.200
     7.712   -50.784     0.200
     9.426   -61.503     0.200
     9.598   -63.497     0.200
    10.453   -66.153     0.200
     0.953    -0.859     0.200
     0.805     2.771     0.200
     1.288    -2.780     0.200
     1.414    -5.647     0.200
     1.408    -4.715     0.200
     1.406    -1.431     0.200
     1.519    -3.415     0.200
     1.486    -4.934     0.200
     2.254   -16.292     0.200
     2.598   -14.549     0.200
     2.628   -17.520     0.200
     2.841    -9.864     0.200
     2.795   -10.953     0.200
     3.067   -12.595     0.200
     3.124   -16.465     0.200
     3.265   -11.338     0.200
     3.265   -15.329     0.200
     4.480   -28.918     0.200
     4.663   -30.804     0.200
     4.698   -30.891     0.200
     4.817   -29.032     0.200
     4.999   -31.225     0.200
     5.659   -37.381     0.200
     7.360   -50.650     0.200
     1.212    -3.891     0.200
     1.510    -4.706     0.200
     1.653    -4.990     0.200
     1.765    -5.930     0.200
     2.384   -10.829     0.200
     2.406   -14.620     0.200
     2.697   -12.027     0.200
     2.769   -15.685     0.200
     2.918   -13.794     0.200
     3.124   -14.130     0.200
     3.261   -12.951     0.200
     3.489   -22.959     0.200
     3.656   -15.607     0.200
     3.680   -15.716     0.200
     3.684   -14.486     0.200
     3.689   -17.974     0.200
     3.741   -22.336     0.200
     3.756   -21.410     0.200
     3.861   -16.756     0.200
     4.101   -26.801     0.200
     4.421   -30.134     0.200
     4.506   -29.541     0.200
     4.552   -25.974     0.200
     4.861   -28.996     0.200
     5.103   -25.004     0.200
     5.556   -34.711     0.200
     1.045    -0.470     0.200
     1.766    -5.350     0.200
     2.732   -14.722     0.200
     3.053   -17.663     0.200
     3.538   -15.623     0.200
     3.611   -19.072     0.200
     3.965   -19.638     0.200
     3.977   -15.355     0.200
     4.106   -16.164     0.200
     4.177   -24.231     0.200
     4.398   -20.737     0.200
     4.419   -27.361     0.200
     4.424   -22.887     0.200
     4.427   -21.661     0.200
     4.430   -23.747     0.200
     4.482   -25.412     0.200
     4.484   -22.253     0.200
     4.852   -28.410     0.200
     5.171   -31.939     0.200
     5.288   -29.048     0.200
     5.570   -26.252     0.200
     5.585   -33.703     0.200
     5.603   -27.352     0.200
     1.057    -1.962     0.200
     1.059    -0.193     0.200
     1.596    -5.092     0.200
     1.841    -7.370     0.200
     2.291   -14.568     0.200
     2.529   -14.106     0.200
     2.527   -12.696     0.200
     2.596   -11.754     0.200
     2.588   -10.170     0.200
     2.665   -12.283     0.200
     2.805   -13.950     0.200
     2.902    -9.976     0.200
     3.038   -11.429     0.200
     3.045   -16.217     0.200
     3.184   -13.348     0.200
     3.378   -18.817     0.200
     3.452   -15.121     0.200
     3.472   -18.958     0.200
     3.481   -19.727     0.200
     3.485   -14.029     0.200
     3.660   -16.224     0.200
     3.929   -28.978     0.200
     4.250   -27.410     0.200
     4.388   -27.219     0.200
     4.399   -28.928     0.200
     4.389   -20.564     0.200
     4.719   -26.610     0.200
     4.923   -27.747     0.200
     1.069     1.908     0.200
     1.968    -5.679     0.200
     2.898   -10.224     0.200
     3.237   -14.556     0.200
     3.701   -16.028     0.200
     3.795   -17.420     0.200
     3.765   -14.741     0.200
     4.145   -18.663     0.200
     4.361   -21.579     0.200
     4.506   -20.013     0.200
     4.585   -21.444     0.200
     4.572   -21.112     0.200
     4.659   -23.072     0.200
     5.023   -27.230     0.200
     5.343   -30.977     0.200
     5.466   -29.098     0.200
     5.766   -30.197     0.200
     6.024   -33.125     0.200
     2.077    -8.442     0.200
     2.762    -9.041     0.200
     2.895   -11.759     0.200
     3.051   -10.640     0.200
     2.998   -11.998     0.200
     3.104   -10.770     0.200
     3.551   -12.926     0.200
     3.660   -18.077     0.200
     3.751   -16.927     0.200
     4.455   -17.257     0.200
     4.521   -19.173     0.200
     4.717   -18.935     0.200
     4.886   -23.908     0.200
     5.206   -22.214     0.200
     5.248   -24.472     0.200
     5.329   -22.285     0.200
     5.593   -25.178     0.200
     5.598   -25.475     0.200
     5.629   -30.084     0.200
     5.705   -34.197     0.200
     6.100   -27.340     0.200
     6.203   -31.065     0.200
     6.267   -35.096     0.200
     6.334   -29.665     0.200
     6.333   -29.657     0.200
     6.343   -37.764     0.200
     7.006   -38.705     0.200
     7.281   -39.070     0.200
     7.461   -36.657     0.200
     7.436   -44.492     0.200
     7.787   -40.202     0.200
     8.067   -48.205     0.200
     8.067   -44.174     0.200
     8.146   -45.684     0.200
     9.782   -51.677     0.200
    11.462   -65.271     0.200
    12.219   -79.010     0.200
    12.792   -75.377     0.200
    13.008   -75.837     0.200
    21.706  -151.102     0.200
    22.019  -155.642     0.200
    22.085  -154.786     0.200
     2.675    -7.415     0.200
     2.756    -8.221     0.200
     3.685   -13.217     0.200
     3.771   -14.930     0.200
     4.012   -13.941     0.200
     4.039   -16.394     0.200
     4.128   -21.530     0.200
     4.366   -22.823     0.200
     4.468   -17.560     0.200
     4.509   -16.186     0.200
     4.514   -22.338     0.200
     4.552   -18.092     0.200
     4.554   -20.107     0.200
     4.619   -19.707     0.200
     4.626   -19.767     0.200
     4.772   -20.027     0.200
     4.809   -20.200     0.200
     4.847   -21.620     0.200
     4.907   -19.041     0.200
     4.907   -19.026     0.200
     4.954   -20.846     0.200
     4.981   -23.920     0.200
     4.982   -23.651     0.200
     4.984   -23.150     0.200
     4.984   -21.998     0.200
     4.987   -21.860     0.200
     4.993   -19.446     0.200
     4.988   -21.901     0.200
     5.103   -27.318     0.200
     5.170   -26.061     0.200
     5.461   -28.112     0.200
     5.782   -32.079     0.200
     5.831   -32.647     0.200
     5.912   -30.437     0.200
     6.159   -31.887     0.200
     6.214   -32.187     0.200
     6.353   -26.618     0.200
     6.456   -34.576     0.200
     6.850   -38.521     0.200
     6.917   -41.602     0.200
     6.917   -41.594     0.200
     8.648   -56.761     0.200
     1.123    -0.969     0.200
     1.826    -6.209     0.200
     2.718   -12.456     0.200
     3.008   -13.694     0.200
     3.136   -13.936     0.200
     3.991   -18.261     0.200
     3.989   -20.041     0.200
     4.134   -23.740     0.200
     4.397   -21.051     0.200
     4.415   -22.586     0.200
     4.422   -22.297     0.200
     4.426   -23.076     0.200
     4.429   -21.306     0.200
     4.451   -24.850     0.200
     4.455   -23.706     0.200
     4.603   -24.094     0.200
     4.793   -25.971     0.200
     1.165    -0.390     0.200
     1.689    -5.021     0.200
     2.251    -7.986     0.200
     2.672    -8.327     0.200
     2.955   -14.493     0.200
     3.185   -13.526     0.200
     3.518   -18.906     0.200
     3.480   -14.963     0.200
     3.891   -15.931     0.200
     3.947   -17.758     0.200
     4.081   -20.684     0.200
     4.400   -21.924     0.200
     4.373   -20.286     0.200
     4.405   -22.198     0.200
     4.380   -20.383     0.200
     4.384   -20.508     0.200
     4.388   -20.638     0.200
     4.394   -20.565     0.200
     4.453   -19.870     0.200
     4.561   -21.682     0.200
     4.652   -20.817     0.200
     4.783   -22.891     0.200
     0.921     0.554     0.200
     1.081    -0.454     0.200
     1.662    -4.646     0.200
     2.033    -6.446     0.200
     2.778   -10.085     0.200
     2.942   -11.714     0.200
     3.140   -15.267     0.200
     3.579   -16.292     0.200
     3.693   -19.020     0.200
     3.702   -14.199     0.200
     4.020   -16.525     0.200
     4.261   -20.709     0.200
     4.424   -19.934     0.200
     4.447   -23.286     0.200
     4.451   -18.697     0.200
     4.453   -21.920     0.200
     4.455   -19.489     0.200
     4.635   -22.193     0.200
     1.105    -1.753     0.200
     1.834    -4.870     0.200
     2.985   -12.318     0.200
     3.476   -12.797     0.200
     3.961   -17.522     0.200
     3.961   -14.862     0.200
     4.793   -29.129     0.200
     5.515   -25.218     0.200
     5.799   -27.275     0.200
     1.386    -4.639     0.200
     2.825   -10.111     0.200
     3.130   -10.856     0.200
     3.257   -13.342     0.200
     3.464   -14.031     0.200
     3.800   -14.996     0.200
     3.864   -15.560     0.200
     3.870   -15.709     0.200
     3.932   -17.334     0.200
     3.911   -18.303     0.200
     4.307   -18.400     0.200
     4.330   -19.421     0.200
     4.338   -20.409     0.200
     4.339   -19.576     0.200
     4.342   -17.688     0.200
     4.341   -21.307     0.200
     4.350   -19.607     0.200
     4.358   -19.084     0.200
     4.366   -19.516     0.200
     4.370   -19.546     0.200
     4.378   -20.200     0.200
     4.384   -20.079     0.200
     4.382   -18.989     0.200
     4.419   -20.170     0.200
     4.452   -20.321     0.200
     4.464   -19.350     0.200
     4.526   -18.967     0.200
     4.563   -18.789     0.200
     4.603   -19.476     0.200
     4.589   -22.469     0.200
     4.669   -21.405     0.200
     4.772   -21.312     0.200
     4.797   -22.397     0.200
     4.800   -23.040     0.200
     4.802   -23.222     0.200
     4.804   -22.398     0.200
     4.808   -21.715     0.200
     4.926   -22.091     0.200
     4.892   -24.416     0.200
     4.896   -21.781     0.200
     4.985   -23.966     0.200
     5.235   -27.289     0.200
     5.482   -29.301     0.200
     5.611   -29.860     0.200
     5.699   -28.207     0.200
     5.870   -28.478     0.200
     5.964   -30.345     0.200
     6.256   -30.499     0.200
     6.297   -33.528     0.200
     6.556   -34.326     0.200
     6.630   -36.076     0.200
     6.704   -35.481     0.200
     6.865   -39.279     0.200
     7.223   -43.056     0.200
     7.595   -43.403     0.200
     7.645   -43.263     0.200
     7.875   -43.116     0.200
     7.842   -44.585     0.200
     8.769   -49.112     0.200
     8.790   -53.149     0.200
    10.153   -60.065     0.200
    11.177   -67.177     0.200
    11.388   -69.211     0.200
    11.418   -69.841     0.200
    11.425   -70.239     0.200
    11.605   -66.579     0.200
    11.824   -71.907     0.200
    11.943   -74.479     0.200
    13.132   -81.859     0.200
    13.354   -81.519     0.200
    13.921   -86.165     0.200
    15.329  -104.201     0.200
    16.285  -108.348     0.200
    16.489  -117.073     0.200
    16.729  -110.916     0.200
    17.870  -119.296     0.200
    18.294  -124.491     0.200
    19.784  -130.419     0.200
     1.157     1.182     0.200
     1.667    -3.223     0.200
     2.261    -7.029     0.200
     2.639    -8.279     0.200
     2.727   -10.367     0.200
     2.934   -11.765     0.200
     3.174   -10.531     0.200
     3.382   -17.544     0.200
     3.446   -12.982     0.200
     3.495   -16.674     0.200
     3.910   -15.332     0.200
     3.860   -13.600     0.200
     4.060   -19.494     0.200
     4.318   -23.090     0.200
     4.337   -17.191     0.200
     4.343   -23.210     0.200
     4.347   -21.344     0.200
     4.351   -19.468     0.200
     4.373   -22.802     0.200
     4.376   -21.783     0.200
     4.411   -16.909     0.200
     4.412   -16.926     0.200
     4.524   -19.820     0.200
     4.623   -18.116     0.200
     4.752   -26.533     0.200
     0.788     1.549     0.200
     0.852     2.179     0.200
     1.874    -5.321     0.200
     2.425    -8.051     0.200
     2.590    -7.858     0.200
     2.691    -9.455     0.200
     3.309   -12.597     0.200
     3.696   -15.923     0.200
     1.003    -0.161     0.200
     1.791    -7.390     0.200
     2.117    -7.783     0.200
     2.719   -11.976     0.200
     3.022   -10.739     0.200
     3.061   -14.392     0.200
     3.523   -19.671     0.200
     3.617   -16.371     0.200
     3.958   -15.382     0.200
     3.971   -16.165     0.200
     4.184   -20.203     0.200
     4.414   -20.067     0.200
     4.425   -19.963     0.200
     4.478   -26.400     0.200
     4.695   -20.369     0.200
     4.843   -23.421     0.200
     5.162   -26.320     0.200
     5.205   -29.706     0.200
     5.285   -28.953     0.200
     5.555   -29.935     0.200
     5.585   -30.879     0.200
     5.734   -30.165     0.200
     5.844   -30.236     0.200
     6.080   -29.559     0.200
     6.224   -40.241     0.200
     6.290   -34.157     0.200
     7.026   -35.024     0.200
     7.238   -43.096     0.200
     7.463   -40.723     0.200
     7.448   -36.828     0.200
     8.024   -44.859     0.200
     8.906   -49.688     0.200
     9.682   -54.535     0.200
     9.738   -52.249     0.200
    10.762   -66.307     0.200
     1.199     1.239     0.200
     1.298     0.334     0.200
     2.747   -10.334     0.200
     3.533   -12.967     0.200
     3.552   -13.085     0.200
     3.624   -13.196     0.200
     4.007   -20.051     0.200
     4.121   -14.355     0.200
     4.190   -26.503     0.200
     4.413   -16.951     0.200
     4.433   -16.265     0.200
     4.442   -16.544     0.200
     4.498   -18.301     0.200
     4.867   -32.008     0.200
     5.211   -24.140     0.200
     5.185   -31.636     0.200
     5.302   -32.293     0.200
     5.599   -32.239     0.200
     5.585   -23.226     0.200
     1.189     0.024     0.200
     1.635    -4.878     0.200
     1.923    -5.825     0.200
     2.295    -7.137     0.200
     2.615    -8.420     0.200
     2.696    -9.182     0.200
     3.423   -15.265     0.200
     3.751   -13.694     0.200
     3.889   -20.062     0.200
     3.894   -17.588     0.200
     3.921   -20.425     0.200
     3.924   -21.860     0.200
     3.932   -18.121     0.200
     3.944   -17.839     0.200
     4.017   -20.799     0.200
     4.015   -18.740     0.200
     4.041   -20.911     0.200
     4.078   -17.439     0.200
     4.028   -18.437     0.200
     4.159   -18.661     0.200
     4.164   -14.842     0.200
     4.205   -18.792     0.200
     4.299   -21.438     0.200
     4.316   -19.331     0.200
     4.324   -20.892     0.200
     4.332   -20.492     0.200
     4.402   -16.726     0.200
     4.348   -20.989     0.200
     4.344   -15.599     0.200
     4.504   -24.624     0.200
     4.644   -18.439     0.200
     4.726   -26.036     0.200
     5.044   -26.513     0.200
     5.050   -26.742     0.200
     5.151   -22.710     0.200
     5.454   -21.905     0.200
     5.443   -26.786     0.200
     5.565   -29.353     0.200
     5.734   -25.748     0.200
     5.922   -36.966     0.200
     6.086   -29.930     0.200
     6.069   -38.545     0.200
     6.156   -28.777     0.200
     6.954   -36.580     0.200
     7.085   -44.680     0.200
     7.456   -49.773     0.200
     7.491   -40.245     0.200
     7.887   -41.164     0.200
     7.897   -46.817     0.200
     8.248   -49.502     0.200
     8.367   -46.429     0.200
     8.566   -47.361     0.200
     9.081   -50.609     0.200
     9.259   -54.802     0.200
     9.611   -57.874     0.200
     9.816   -52.561     0.200
     9.937   -51.228     0.200
    10.867   -58.711     0.200
    11.326   -68.630     0.200
    12.072   -74.267     0.200
    12.441   -86.532     0.200
    12.900   -85.221     0.200
    13.009   -77.633     0.200
    13.534   -85.142     0.200
    14.414  -100.484     0.200
    17.068  -116.663     0.200
    17.921  -126.682     0.200
    18.686  -131.605     0.200
     1.310     0.787     0.200
     1.414    -1.146     0.200
     3.810   -14.172     0.200
     3.819   -14.024     0.200
     4.001   -24.889     0.200
     3.959   -14.621     0.200
     4.001   -14.943     0.200
     4.303   -18.510     0.200
     4.301   -24.027     0.200
     4.434   -16.664     0.200
     4.671   -16.531     0.200
     4.649   -16.582     0.200
     4.990   -24.476     0.200
     5.022   -31.715     0.200
     5.107   -28.471     0.200
     5.405   -31.843     0.200
     5.392   -24.079     0.200
     5.472   -27.037     0.200
     5.676   -29.360     0.200
     6.014   -29.550     0.200
     6.112   -31.529     0.200
     6.900   -41.185     0.200
     7.055   -44.088     0.200
     7.848   -40.312     0.200
     1.136     2.136     0.200
     1.239     0.636     0.200
     2.677    -8.775     0.200
     3.044   -12.075     0.200
     3.596   -17.599     0.200
     4.326   -16.791     0.200
     4.349   -18.157     0.200
     4.353   -18.528     0.200
     4.355   -18.013     0.200
     4.358   -16.663     0.200
     4.363   -18.010     0.200
     4.454   -20.428     0.200
     4.444   -19.639     0.200
     4.448   -17.966     0.200
     4.804   -24.014     0.200
     5.124   -25.484     0.200
     5.184   -23.655     0.200
     5.803   -28.552     0.200
     1.859    -4.041     0.200
     2.663    -9.865     0.200
     2.663    -8.865     0.200
     2.753    -8.642     0.200
     3.340   -16.873     0.200
     3.548   -15.909     0.200
     3.771   -14.191     0.200
     3.995   -16.848     0.200
     4.000   -14.730     0.200
     4.107   -19.790     0.200
     4.383   -17.924     0.200
     4.395   -21.656     0.200
     4.395   -19.274     0.200
     4.401   -18.697     0.200
     4.411   -16.765     0.200
     4.420   -17.162     0.200
     4.420   -18.638     0.200
     4.431   -19.271     0.200
     4.438   -17.656     0.200
     4.472   -18.939     0.200
     4.484   -23.514     0.200
     4.527   -20.069     0.200
     4.582   -19.367     0.200
     4.672   -25.671     0.200
     4.807   -17.699     0.200
     4.808   -17.714     0.200
     4.833   -23.953     0.200
     4.858   -22.737     0.200
     4.861   -20.970     0.200
     4.862   -19.921     0.200
     4.866   -22.006     0.200
     4.868   -22.047     0.200
     4.935   -22.506     0.200
     4.969   -28.353     0.200
     4.969   -30.384     0.200
     5.047   -29.447     0.200
     5.296   -30.386     0.200
     5.329   -29.356     0.200
     5.402   -26.534     0.200
     5.649   -30.471     0.200
     5.694   -29.290     0.200
     5.777   -32.138     0.200
     5.899   -30.727     0.200
     6.032   -32.340     0.200
     6.078   -29.121     0.200
     6.301   -32.823     0.200
     6.326   -29.552     0.200
     6.615   -33.667     0.200
     6.782   -35.822     0.200
     6.782   -35.816     0.200
     6.791   -43.488     0.200
     6.796   -36.905     0.200
     7.144   -42.105     0.200
     7.558   -44.450     0.200
     7.582   -38.000     0.200
     7.728   -44.964     0.200
     7.852   -39.446     0.200
     7.754   -43.631     0.200
     7.754   -39.663     0.200
     8.514   -51.201     0.200
     8.514   -50.076     0.200
     9.175   -54.876     0.200
     9.431   -52.958     0.200
     9.659   -59.174     0.200
    10.229   -60.617     0.200
    11.253   -64.649     0.200
    11.468   -74.785     0.200
    11.498   -69.676     0.200
    13.054   -78.538     0.200
    13.835   -88.893     0.200
    15.251   -93.263     0.200
    15.251   -95.740     0.200
    16.403  -107.680     0.200
     1.033     0.341     0.200
     2.784   -10.299     0.200
     3.097   -12.176     0.200
     3.054   -12.243     0.200
     3.570   -13.777     0.200
     3.594   -13.960     0.200
     3.589   -15.139     0.200
     3.661   -15.133     0.200
     3.823   -15.707     0.200
     4.017   -17.870     0.200
     4.030   -17.657     0.200
     4.037   -18.614     0.200
     4.053   -19.419     0.200
     4.056   -18.316     0.200
     4.062   -18.607     0.200
     4.062   -17.345     0.200
     4.073   -18.291     0.200
     4.079   -19.725     0.200
     4.118   -19.664     0.200
     4.152   -16.543     0.200
     4.159   -18.379     0.200
     4.171   -17.475     0.200
     4.219   -21.118     0.200
     4.222   -21.055     0.200
     4.282   -19.339     0.200
     4.301   -18.493     0.200
     4.352   -21.698     0.200
     4.451   -18.515     0.200
     4.471   -20.499     0.200
     4.476   -20.045     0.200
     4.480   -18.490     0.200
     4.488   -21.551     0.200
     4.510   -22.520     0.200
     4.532   -23.460     0.200
     4.532   -22.590     0.200
     4.659   -24.259     0.200
     4.903   -25.265     0.200
     5.244   -28.806     0.200
     5.622   -29.139     0.200
     5.650   -29.638     0.200
     5.907   -31.544     0.200
     6.168   -32.038     0.200
     6.237   -32.188     0.200
     6.263   -34.123     0.200
     6.342   -34.779     0.200
     7.067   -37.451     0.200
     7.532   -44.272     0.200
     7.859   -43.574     0.200
    10.815   -63.333     0.200
     0.985     0.736     0.200
     8.113   -52.958     0.200
    11.029   -62.846     0.200
     0.327     3.325     0.200
     0.721     0.702     0.200
     0.877     0.725     0.200
     0.983    -0.262     0.200
     1.368    -2.598     0.200
     1.568    -2.650     0.200
     1.951    -5.873     0.200
     2.758   -10.761     0.200
     3.003   -15.048     0.200
     3.220   -18.248     0.200
     3.434   -14.397     0.200
     3.547   -17.780     0.200
     3.561   -16.423     0.200
     3.709   -13.163     0.200
     3.862   -17.384     0.200
     3.906   -19.933     0.200
     3.930   -12.858     0.200
     3.957   -19.605     0.200
     3.951   -20.187     0.200
     4.020   -17.731     0.200
     4.042   -18.431     0.200
     4.112   -20.000     0.200
     4.328   -28.880     0.200
     4.195   -20.379     0.200
     4.308   -23.128     0.200
     4.307   -23.113     0.200
     4.355   -18.342     0.200
     4.383   -17.256     0.200
     4.384   -21.958     0.200
     4.385   -16.639     0.200
     4.388   -16.680     0.200
     4.558   -28.861     0.200
     4.572   -19.921     0.200
     4.896   -32.431     0.200
     5.218   -33.060     0.200
     5.344   -37.191     0.200
     5.373   -32.983     0.200
     5.404   -24.040     0.200
     5.575   -35.691     0.200
     5.691   -36.258     0.200
     5.880   -36.464     0.200
     5.848   -30.164     0.200
     7.179   -40.812     0.200
     8.743   -54.696     0.200
     0.782     1.965     0.200
     1.734    -5.305     0.200
     2.152    -8.321     0.200
     3.729   -14.062     0.200
     3.968   -15.549     0.200
     4.591   -20.510     0.200
     4.620   -27.409     0.200
     4.620   -19.445     0.200
     4.621   -22.797     0.200
     5.129   -30.138     0.200
     5.450   -31.069     0.200
     5.556   -33.929     0.200
     5.600   -38.216     0.200
     5.914   -31.520     0.200
     6.115   -37.455     0.200
     0.755     1.604     0.200
     0.855     0.257     0.200
     1.392    -3.473     0.200
     2.937   -11.650     0.200
     3.453   -18.075     0.200
     3.561   -20.071     0.200
     3.598   -17.330     0.200
     3.679   -14.548     0.200
     3.732   -19.836     0.200
     3.875   -19.441     0.200
     3.934   -17.893     0.200
     3.928   -22.200     0.200
     3.977   -17.539     0.200
     4.022   -22.727     0.200
     4.077   -23.383     0.200
     4.117   -20.250     0.200
     4.130   -27.455     0.200
     4.177   -23.843     0.200
     4.185   -19.782     0.200
     4.210   -18.888     0.200
     4.260   -26.983     0.200
     4.269   -22.669     0.200
     4.454   -23.264     0.200
     4.504   -24.071     0.200
     4.526   -27.049     0.200
     4.531   -26.008     0.200
     4.556   -27.806     0.200
     4.555   -25.262     0.200
     4.556   -24.526     0.200
     4.558   -27.958     0.200
     4.564   -23.089     0.200
     4.744   -22.893     0.200
     5.075   -28.459     0.200
     5.397   -28.441     0.200
     5.522   -37.284     0.200
     5.751   -36.283     0.200
     5.871   -38.310     0.200
     5.933   -36.149     0.200
     6.059   -39.123     0.200
     0.805     1.187     0.200
     0.964     1.436     0.200
     1.058    -0.024     0.200
     1.514    -6.574     0.200
     1.885    -6.712     0.200
     2.825   -13.442     0.200
     2.910   -14.867     0.200
     3.077   -14.489     0.200
     3.288   -17.283     0.200
     3.840   -16.112     0.200
     4.105   -23.725     0.200
     4.114   -24.288     0.200
     4.123   -19.292     0.200
     4.131   -17.685     0.200
     4.131   -17.816     0.200
     4.139   -19.817     0.200
     4.143   -19.329     0.200
     4.148   -25.128     0.200
     4.184   -18.842     0.200
     4.237   -21.995     0.200
     4.292   -24.209     0.200
     4.408   -24.484     0.200
     4.401   -22.033     0.200
     4.541   -20.479     0.200
     4.575   -22.815     0.200
     4.576   -22.856     0.200
     4.685   -23.766     0.200
     4.755   -23.479     0.200
     5.041   -26.585     0.200
     5.361   -33.703     0.200
     5.428   -36.225     0.200
     5.495   -33.543     0.200
     5.523   -27.293     0.200
     5.641   -23.381     0.200
     5.740   -28.740     0.200
     6.036   -28.904     0.200
     6.094   -31.788     0.200
     6.323   -38.433     0.200
     6.499   -33.053     0.200
     6.499   -33.046     0.200
     6.845   -39.375     0.200
     7.418   -39.127     0.200
     7.720   -36.624     0.200
     8.228   -50.570     0.200
     8.228   -53.749     0.200
     8.730   -51.214     0.200
     8.887   -53.386     0.200
     9.581   -58.903     0.200
     9.943   -57.119     0.200
    10.110   -60.149     0.200
    14.397  -100.452     0.200
     2.618    -8.873     0.200
     2.759   -10.059     0.200
     3.083   -15.889     0.200
     3.041   -13.129     0.200
     3.468   -15.385     0.200
     3.539   -15.744     0.200
     3.563   -16.686     0.200
     3.562   -13.972     0.200
     3.632   -16.400     0.200
     3.641   -16.662     0.200
     3.810   -17.264     0.200
     3.795   -19.172     0.200
     3.917   -16.295     0.200
     3.986   -19.407     0.200
     4.207   -22.393     0.200
     4.422   -21.827     0.200
     4.443   -22.865     0.200
     4.448   -22.402     0.200
     4.451   -24.633     0.200
     4.459   -22.937     0.200
     4.477   -22.157     0.200
     4.511   -22.265     0.200
     4.513   -22.448     0.200
     4.631   -27.084     0.200
     4.749   -24.697     0.200
     4.879   -25.973     0.200
     5.198   -28.596     0.200
     5.228   -26.199     0.200
     5.317   -26.592     0.200
     5.616   -26.177     0.200
     5.883   -30.455     0.200
     6.134   -35.869     0.200
     6.248   -33.729     0.200
     6.322   -35.590     0.200
     1.602    -5.546     0.200
     1.702    -5.142     0.200
     1.877    -4.770     0.200
     2.089   -12.406     0.200
     2.556    -9.762     0.200
     2.686    -9.742     0.200
     2.841   -10.938     0.200
     3.027   -12.574     0.200
     3.345   -13.242     0.200
     3.417   -16.350     0.200
     3.469   -16.943     0.200
     3.496   -12.853     0.200
     3.972   -23.500     0.200
     4.359   -23.424     0.200
     5.074   -29.139     0.200
     5.780   -32.054     0.200
     1.712    -4.021     0.200
     2.082    -6.519     0.200
     2.555    -7.218     0.200
     2.710    -8.623     0.200
     3.083   -11.802     0.200
     3.430   -11.931     0.200
     3.511   -16.034     0.200
     3.634   -15.988     0.200
     3.674   -13.239     0.200
     3.950   -14.177     0.200
     4.202   -18.831     0.200
     4.354   -22.255     0.200
     4.377   -20.689     0.200
     4.384   -22.730     0.200
     4.381   -16.350     0.200
     4.390   -15.113     0.200
     4.480   -26.663     0.200
     4.566   -20.448     0.200
     4.631   -18.086     0.200
     4.838   -24.193     0.200
     5.158   -27.809     0.200
     5.222   -32.206     0.200
     5.289   -23.818     0.200
     5.543   -28.732     0.200
     5.594   -27.774     0.200
     5.836   -31.786     0.200
     2.621   -12.373     0.200
     2.760   -13.266     0.200
     2.971   -12.361     0.200
     2.976   -11.134     0.200
     3.417   -15.761     0.200
     3.667   -13.745     0.200
     3.857   -16.432     0.200
     3.857   -21.749     0.200
     3.874   -14.875     0.200
     3.883   -15.259     0.200
     3.889   -16.131     0.200
     3.889   -15.470     0.200
     3.986   -16.547     0.200
     4.108   -16.434     0.200
     4.387   -18.284     0.200
     4.357   -20.319     0.200
     4.489   -19.350     0.200
     4.633   -19.526     0.200
     4.745   -22.715     0.200
     5.064   -34.101     0.200
     5.457   -28.120     0.200
     5.746   -34.762     0.200
     5.746   -29.133     0.200
     6.066   -30.283     0.200
     6.132   -38.932     0.200
     6.021   -27.512     0.200
     6.193   -39.090     0.200
     6.193   -39.082     0.200
     7.145   -47.964     0.200
     7.055   -33.380     0.200
     7.403   -37.093     0.200
     7.747   -45.946     0.200
     7.926   -50.308     0.200
     7.926   -47.929     0.200
     8.931   -50.690     0.200
     9.641   -56.207     0.200
     9.800   -58.237     0.200
    10.665   -65.500     0.200
     0.633     4.472     0.200
     0.966     0.539     0.200
     1.021    -0.136     0.200
     1.101     0.343     0.200
     1.213    -1.297     0.200
     1.907    -9.707     0.200
     2.258   -11.350     0.200
     2.377    -9.788     0.200
     2.697   -16.256     0.200
     2.856   -12.677     0.200
     2.919   -15.868     0.200
     3.012   -13.683     0.200
     3.031   -17.876     0.200
     3.128   -15.512     0.200
     3.160   -15.681     0.200
     3.307   -16.828     0.200
     3.352   -17.719     0.200
     3.300   -17.410     0.200
     3.436   -19.896     0.200
     3.461   -19.500     0.200
     3.489   -21.212     0.200
     3.504   -20.293     0.200
     3.519   -21.252     0.200
     3.528   -22.167     0.200
     3.548   -19.096     0.200
     3.558   -21.968     0.200
     3.611   -20.588     0.200
     3.640   -20.186     0.200
     3.691   -22.331     0.200
     3.713   -23.065     0.200
     3.764   -20.487     0.200
     3.843   -18.184     0.200
     3.916   -20.151     0.200
     3.916   -20.167     0.200
     3.954   -22.393     0.200
     3.971   -21.002     0.200
     4.009   -24.725     0.200
     3.984   -22.558     0.200
     3.983   -19.257     0.200
     3.984   -19.841     0.200
     3.985   -22.682     0.200
     3.987   -22.723     0.200
     4.172   -21.862     0.200
     4.192   -25.441     0.200
     4.154   -19.881     0.200
     4.233   -25.412     0.200
     4.516   -27.997     0.200
     4.838   -29.715     0.200
     5.018   -30.671     0.200
     5.010   -33.187     0.200
     6.035   -40.389     0.200
     6.737   -45.765     0.200
     7.717   -49.594     0.200
     7.717   -48.985     0.200
     8.361   -55.170     0.200
     9.430   -62.234     0.200
    13.803   -95.564     0.200
     1.296    -4.109     0.200
     1.679    -6.969     0.200
     2.644   -10.771     0.200
     2.947   -16.719     0.200
     3.345   -15.761     0.200
     3.507   -18.641     0.200
     3.450   -16.564     0.200
     3.912   -18.471     0.200
     4.072   -22.200     0.200
     4.320   -17.647     0.200
     4.339   -18.346     0.200
     4.385   -24.421     0.200
     4.345   -19.187     0.200
     4.359   -21.051     0.200
     4.408   -21.166     0.200
     4.604   -19.599     0.200
     4.758   -28.269     0.200
     5.093   -30.870     0.200
     5.077   -27.916     0.200
     5.189   -30.822     0.200
     2.207    -4.313     0.200
     2.446    -5.714     0.200
     3.111    -8.403     0.200
     3.221   -10.243     0.200
     3.150    -9.972     0.200
     3.188    -8.736     0.200
     3.223   -15.052     0.200
     3.315   -12.288     0.200
     3.253   -16.503     0.200
     3.269    -8.746     0.200
     3.279   -15.745     0.200
     3.363    -9.659     0.200
     3.358   -15.507     0.200
     3.382   -16.964     0.200
     3.426   -11.790     0.200
     3.382    -8.506     0.200
     3.560   -16.947     0.200
     3.742   -14.363     0.200
     3.736   -10.656     0.200
     4.272   -16.947     0.200
     4.301   -19.956     0.200
     4.383   -19.073     0.200
     4.498   -21.961     0.200
     4.818   -21.660     0.200
     0.808     2.318     0.200
     0.967     2.004     0.200
     1.068     1.723     0.200
     1.939    -6.233     0.200
     2.808   -10.483     0.200
     4.327   -19.345     0.200
     4.432   -19.106     0.200
     4.343   -18.674     0.200
     4.458   -20.724     0.200
     4.460   -20.102     0.200
     4.462   -20.282     0.200
     4.606   -25.339     0.200
     4.467   -19.674     0.200
     4.590   -20.837     0.200
     4.941   -20.960     0.200
     5.347   -31.347     0.200
     5.262   -26.989     0.200
     5.402   -29.736     0.200
     5.711   -32.808     0.200
     5.933   -28.936     0.200
     5.995   -27.080     0.200
     1.229     1.482     0.200
     1.047     2.791     0.200
     1.147     1.719     0.200
     1.182     1.372     0.200
     1.265     0.506     0.200
     2.467    -9.086     0.200
     3.059   -13.666     0.200
     3.160   -15.382     0.200
     3.261   -10.418     0.200
     3.324   -16.302     0.200
     3.239   -16.105     0.200
     4.231   -26.147     0.200
     4.447   -19.534     0.200
     4.735   -21.733     0.200
     4.768   -26.396     0.200
     5.033   -28.298     0.200
     5.352   -24.406     0.200
     5.407   -22.091     0.200
     1.173    -0.576     0.200
     1.744    -6.915     0.200
     2.660   -12.812     0.200
     3.015   -14.338     0.200
     2.981   -10.930     0.200
     3.462   -17.210     0.200
     3.428   -16.416     0.200
     3.568   -20.168     0.200
     3.448   -14.573     0.200
     3.524   -18.414     0.200
     3.699   -20.984     0.200
     3.718   -18.721     0.200
     3.806   -16.566     0.200
     3.873   -21.917     0.200
     3.889   -16.815     0.200
     3.909   -19.897     0.200
     3.933   -14.704     0.200
     4.135   -24.979     0.200
     4.019   -24.739     0.200
     4.078   -21.701     0.200
     4.336   -23.165     0.200
     4.341   -20.605     0.200
     4.344   -24.458     0.200
     4.386   -22.389     0.200
     2.942   -13.974     0.200
     3.323   -15.438     0.200
     3.422   -14.535     0.200
     3.499   -17.360     0.200
     3.875   -16.226     0.200
     4.285   -23.126     0.200
     4.305   -23.798     0.200
     4.368   -22.468     0.200
     4.311   -23.617     0.200
     4.314   -26.416     0.200
     4.366   -22.667     0.200
     4.324   -20.074     0.200
     4.361   -19.389     0.200
     4.493   -22.603     0.200
     4.552   -19.548     0.200
     4.735   -30.006     0.200
     4.676   -19.881     0.200
     5.086   -28.019     0.200
     5.054   -30.485     0.200
     5.454   -27.513     0.200
     5.739   -31.884     0.200
     6.106   -35.632     0.200
     6.177   -33.952     0.200
     6.065   -31.514     0.200
     7.113   -36.772     0.200
     2.929   -13.508     0.200
     3.088   -10.598     0.200
     3.196    -9.017     0.200
     3.287   -12.522     0.200
     3.207   -10.208     0.200
     3.345   -15.692     0.200
     3.333    -9.380     0.200
     3.715   -14.730     0.200
     4.247   -18.226     0.200
     4.476   -22.493     0.200
     4.702   -21.547     0.200
     4.796   -24.851     0.200
     5.066   -23.099     0.200
     5.235   -26.022     0.200
     5.376   -23.936     0.200
     5.442   -29.574     0.200
     6.037   -22.700     0.200
     1.647    -4.050     0.200
     2.387    -6.271     0.200
     3.394   -12.137     0.200
     3.332   -10.964     0.200
     3.782   -18.767     0.200
     4.312   -25.332     0.200
     4.395   -16.832     0.200
     4.511   -19.745     0.200
     4.830   -24.826     0.200
     4.697   -17.891     0.200
     5.102   -24.379     0.200
     5.408   -27.912     0.200
     5.479   -30.964     0.200
     6.039   -31.605     0.200
     1.187     0.980     0.200
     1.227     1.783     0.200
     2.512    -7.404     0.200
     2.996   -10.496     0.200
     3.094   -11.487     0.200
     3.172   -10.939     0.200
     3.267   -11.531     0.200
     3.308   -10.962     0.200
     3.362   -11.103     0.200
     4.149   -18.164     0.200
     4.163   -17.638     0.200
     4.254   -18.063     0.200
     4.385   -18.081     0.200
     4.705   -18.887     0.200
     4.968   -21.272     0.200
     5.128   -24.933     0.200
     1.704    -0.849     0.200
     2.388    -6.144     0.200
     2.485    -7.559     0.200
     3.557    -9.713     0.200
     3.714   -11.229     0.200
     3.725   -16.611     0.200
     3.730   -17.421     0.200
     3.743   -16.522     0.200
     4.757   -18.404     0.200
     4.775   -20.116     0.200
     5.008   -17.066     0.200
     5.196   -24.622     0.200
     6.008   -31.164     0.200
     6.100   -33.267     0.200
     6.190   -34.106     0.200
     6.622   -37.097     0.200
     7.645   -41.525     0.200
     8.248   -45.210     0.200
     8.419   -46.605     0.200
     1.843    -7.494     0.200
     2.358    -8.368     0.200
     2.774   -13.360     0.200
     3.113   -11.375     0.200
     3.487   -14.395     0.200
     3.577   -16.824     0.200
     3.670   -19.619     0.200
     3.759   -15.468     0.200
     4.025   -20.447     0.200
     4.430   -22.437     0.200
     4.452   -23.625     0.200
     4.456   -23.644     0.200
     4.459   -23.366     0.200
     4.467   -22.609     0.200
     4.472   -23.703     0.200
     4.532   -24.524     0.200
     4.640   -26.039     0.200
     4.898   -32.797     0.200
     5.217   -31.042     0.200
     5.257   -33.639     0.200
     5.339   -31.598     0.200
     5.339   -27.549     0.200
     5.639   -36.751     0.200
     5.899   -34.469     0.200
     6.112   -34.769     0.200
     1.170     0.333     0.200
     1.209     0.877     0.200
     1.429    -3.781     0.200
     2.401    -7.743     0.200
     2.487    -9.298     0.200
     2.473    -9.243     0.200
     2.409    -9.234     0.200
     3.282   -17.691     0.200
     3.124   -13.401     0.200
     3.204   -14.147     0.200
     3.291   -15.526     0.200
     3.354   -16.028     0.200
     3.650   -15.877     0.200
     3.682   -17.129     0.200
     3.687   -17.037     0.200
     3.635   -17.163     0.200
     3.700   -17.339     0.200
     4.178   -21.450     0.200
     4.195   -21.375     0.200
     4.413   -22.132     0.200
     4.732   -27.178     0.200
     4.733   -24.938     0.200
     4.997   -26.012     0.200
     5.159   -27.230     0.200
     1.202     2.697     0.200
     1.282     2.395     0.200
     3.268   -13.146     0.200
     3.320   -10.521     0.200
     3.353   -13.191     0.200
     3.695   -15.802     0.200
     3.696   -11.968     0.200
     3.708   -17.089     0.200
     3.713   -15.296     0.200
     3.728   -16.543     0.200
     4.225   -20.812     0.200
     4.253   -19.801     0.200
     4.773   -18.965     0.200
     5.043   -19.052     0.200
     5.214   -25.334     0.200
     5.352   -19.831     0.200
     5.420   -27.318     0.200
     6.205   -28.376     0.200
     6.613   -30.333     0.200
     7.162   -37.590     0.200
     7.640   -47.801     0.200
     9.806   -54.020     0.200
     0.944     0.709     0.200
     1.102     1.168     0.200
     1.803    -5.735     0.200
     2.254    -7.960     0.200
     2.863    -9.629     0.200
     2.959   -11.620     0.200
     3.075   -18.601     0.200
     3.449   -13.080     0.200
     3.459   -12.801     0.200
     3.552   -15.532     0.200
     3.721   -18.408     0.200
     3.828   -15.311     0.200
     3.891   -16.525     0.200
     3.909   -18.132     0.200
     3.914   -20.367     0.200
     3.918   -15.542     0.200
     3.940   -24.846     0.200
     3.931   -21.539     0.200
     3.943   -16.442     0.200
     3.957   -21.188     0.200
     4.045   -20.021     0.200
     4.102   -22.485     0.200
     4.194   -20.390     0.200
     4.152   -21.838     0.200
     4.182   -22.388     0.200
     4.242   -18.337     0.200
     4.344   -19.501     0.200
     4.367   -18.889     0.200
     4.371   -17.786     0.200
     4.373   -17.660     0.200
     4.380   -17.351     0.200
     4.371   -24.263     0.200
     4.404   -18.234     0.200
     4.470   -26.433     0.200
     4.481   -22.182     0.200
     4.555   -20.984     0.200
     4.622   -18.556     0.200
     4.828   -26.131     0.200
     5.149   -29.560     0.200
     5.214   -22.653     0.200
     5.280   -23.362     0.200
     5.533   -29.010     0.200
     5.585   -33.601     0.200
     5.826   -31.800     0.200
     6.284   -36.718     0.200
     6.546   -30.403     0.200
     7.057   -42.050     0.200
     7.245   -48.294     0.200
     8.014   -51.560     0.200
     8.014   -51.786     0.200
     9.729   -51.326     0.200
    16.773  -108.151     0.200
     1.061    -0.025     0.200
     2.993   -12.490     0.200
     3.114   -11.093     0.200
     3.268   -16.022     0.200
     3.356   -12.440     0.200
     3.526   -13.902     0.200
     3.538   -14.586     0.200
     3.549   -14.500     0.200
     3.554   -14.269     0.200
     3.568   -13.815     0.200
     3.725   -18.148     0.200
     3.921   -24.105     0.200
     4.239   -25.541     0.200
     4.286   -24.246     0.200
     4.353   -17.388     0.200
     4.654   -19.741     0.200
     4.655   -21.664     0.200
     4.930   -27.891     0.200
     0.281     4.419     0.200
     0.719     0.535     0.200
     0.877     0.212     0.200
     0.980    -0.053     0.200
     1.432    -5.194     0.200
     2.227    -8.321     0.200
     2.733   -10.585     0.200
     3.252   -17.625     0.200
     3.546   -13.580     0.200
     3.793   -20.913     0.200
     4.014   -17.512     0.200
     4.236   -22.081     0.200
     4.371   -23.800     0.200
     4.412   -17.596     0.200
     4.440   -17.160     0.200
     4.442   -17.222     0.200
     4.445   -20.669     0.200
     4.628   -28.013     0.200
     4.945   -31.050     0.200
     5.267   -35.023     0.200
     5.381   -29.199     0.200
     5.418   -36.945     0.200
     5.467   -25.091     0.200
     5.628   -31.776     0.200
     5.733   -32.855     0.200
     5.932   -32.403     0.200
     5.908   -30.766     0.200
     6.190   -35.297     0.200
     6.400   -39.423     0.200
     7.234   -38.653     0.200
     2.894   -14.868     0.200
     2.912   -10.162     0.200
     3.107   -13.812     0.200
     3.107   -18.171     0.200
     3.441   -13.736     0.200
     3.552   -23.188     0.200
     3.452   -15.700     0.200
     3.515   -13.396     0.200
     3.656   -17.104     0.200
     3.656   -22.452     0.200
     3.919   -19.208     0.200
     3.919   -15.329     0.200
     3.922   -14.928     0.200
     3.949   -18.402     0.200
     3.939   -17.177     0.200
     4.225   -19.197     0.200
     4.352   -19.300     0.200
     4.376   -20.069     0.200
     4.379   -17.508     0.200
     4.381   -20.240     0.200
     4.364   -18.248     0.200
     4.364   -18.232     0.200
     4.507   -21.979     0.200
     4.493   -23.007     0.200
     4.383   -18.154     0.200
     5.168   -29.038     0.200
     5.244   -27.495     0.200
     5.304   -26.664     0.200
     5.547   -28.368     0.200
     5.611   -30.405     0.200
     5.842   -27.258     0.200
     5.981   -25.237     0.200
     6.264   -33.159     0.200
     6.308   -32.576     0.200
     6.307   -32.568     0.200
     7.075   -45.594     0.200
     7.274   -43.004     0.200
     8.035   -51.990     0.200
     8.035   -46.888     0.200
     8.694   -57.643     0.200
     9.750   -54.209     0.200
    10.777   -64.041     0.200
     1.273     1.184     0.200
     3.206   -11.478     0.200
     3.249   -12.349     0.200
     3.387   -11.711     0.200
     3.371   -14.472     0.200
     3.419   -11.557     0.200
     3.713   -14.225     0.200
     4.260   -19.340     0.200
     4.274   -19.038     0.200
     4.366   -19.737     0.200
     4.494   -17.560     0.200
     4.756   -21.172     0.200
     4.815   -18.806     0.200
     5.045   -23.421     0.200
     5.079   -23.193     0.200
     5.239   -21.924     0.200
     5.399   -26.618     0.200
     5.453   -24.479     0.200
     6.100   -31.256     0.200
     6.232   -31.542     0.200
     3.722   -24.619     0.200
     3.670   -18.010     0.200
     3.839   -17.405     0.200
     4.032   -20.195     0.200
     4.036   -19.840     0.200
     4.048   -20.042     0.200
     4.075   -17.577     0.200
     4.163   -19.678     0.200
     4.220   -20.181     0.200
     4.289   -29.573     0.200
     4.269   -21.721     0.200
     4.461   -19.586     0.200
     4.484   -19.611     0.200
     4.488   -21.596     0.200
     4.585   -27.737     0.200
     4.673   -21.178     0.200
     4.940   -29.994     0.200
     5.260   -28.282     0.200
     5.310   -36.390     0.200
     5.386   -32.743     0.200
     5.688   -33.008     0.200
     5.939   -31.509     0.200
     1.214     2.166     0.200
     1.247     2.676     0.200
     1.329     2.013     0.200
     1.620    -2.152     0.200
     3.478   -13.521     0.200
     3.645   -12.849     0.200
     3.645   -11.317     0.200
     4.173   -16.881     0.200
     4.284   -16.424     0.200
     4.400   -15.970     0.200
     4.672   -21.885     0.200
     4.720   -17.207     0.200
     4.944   -21.045     0.200
     4.990   -23.117     0.200
     5.300   -20.974     0.200
     5.368   -34.011     0.200
     1.271     2.738     0.200
     1.348     1.205     0.200
     1.560    -0.706     0.200
     2.192    -4.106     0.200
     2.355    -6.190     0.200
     4.202   -18.840     0.200
     4.249   -21.005     0.200
     4.318   -19.877     0.200
     4.421   -16.035     0.200
     4.606   -20.869     0.200
     4.740   -23.125     0.200
     5.312   -28.833     0.200
     1.808    -7.152     0.200
     1.800    -7.303     0.200
     2.162    -8.948     0.200
     2.617    -9.882     0.200
     2.700   -12.017     0.200
     3.144   -15.479     0.200
     3.271   -13.029     0.200
     3.346   -13.614     0.200
     3.543   -21.406     0.200
     3.549   -15.041     0.200
     3.728   -17.530     0.200
     3.915   -21.641     0.200
     4.350   -24.095     0.200
     4.639   -21.176     0.200
     4.653   -23.109     0.200
     4.646   -26.065     0.200
     4.923   -27.205     0.200
     4.953   -24.210     0.200
     5.308   -35.419     0.200
     5.301   -26.343     0.200
     5.704   -28.638     0.200
     7.090   -37.555     0.200
     1.925    -5.866     0.200
     2.749   -12.826     0.200
     2.825   -12.671     0.200
     3.195   -17.808     0.200
     3.437   -17.295     0.200
     3.486   -18.152     0.200
     3.540   -16.813     0.200
     3.735   -18.835     0.200
     3.955   -21.144     0.200
     4.305   -24.816     0.200
     4.320   -18.118     0.200
     4.382   -20.253     0.200
     4.383   -19.632     0.200
     4.543   -24.389     0.200
     4.568   -26.165     0.200
     4.570   -25.248     0.200
     4.885   -33.466     0.200
     5.207   -33.196     0.200
     5.323   -32.911     0.200
     5.569   -28.310     0.200
     5.872   -38.893     0.200
     1.300    -0.099     0.200
     1.326     1.148     0.200
     1.516    -1.684     0.200
     1.592    -2.307     0.200
     2.404    -9.524     0.200
     2.852   -14.398     0.200
     2.926   -15.889     0.200
     3.016   -12.090     0.200
     3.040   -11.080     0.200
     3.077   -15.069     0.200
     3.106   -17.198     0.200
     3.119   -17.591     0.200
     3.126   -16.337     0.200
     3.211   -16.060     0.200
     3.196   -13.625     0.200
     3.222   -14.362     0.200
     3.234   -13.031     0.200
     3.243   -17.464     0.200
     3.572   -16.914     0.200
     3.591   -13.585     0.200
     3.604   -18.140     0.200
     3.610   -13.245     0.200
     3.626   -19.343     0.200
     3.808   -15.857     0.200
     4.209   -27.293     0.200
     4.211   -20.798     0.200
     4.272   -24.498     0.200
     4.369   -19.634     0.200
     4.569   -25.085     0.200
     4.688   -27.010     0.200
     4.898   -23.959     0.200
     4.969   -25.730     0.200
     5.160   -28.464     0.200
     5.258   -29.045     0.200
     5.273   -21.816     0.200
     5.184   -22.153     0.200
     5.351   -28.894     0.200
     5.930   -28.753     0.200
     5.923   -33.649     0.200
     6.145   -36.242     0.200
     6.085   -25.428     0.200
     6.284   -25.019     0.200
     6.520   -34.495     0.200
     7.551   -43.119     0.200
     7.551   -40.756     0.200
     8.145   -48.907     0.200
     1.124     2.741     0.200
     1.273     0.147     0.200
     1.299     1.655     0.200
     1.570    -2.454     0.200
     2.363    -9.816     0.200
     2.430    -9.252     0.200
     2.453    -9.103     0.200
     2.601    -8.565     0.200
     2.830   -12.689     0.200
     2.876    -9.490     0.200
     2.952   -12.489     0.200
     3.003   -13.482     0.200
     3.025   -14.751     0.200
     3.083   -10.407     0.200
     3.101   -14.963     0.200
     3.130   -13.922     0.200
     3.152   -16.415     0.200
     3.162   -13.568     0.200
     3.221   -15.345     0.200
     3.236   -15.396     0.200
     3.245   -10.235     0.200
     3.251   -15.598     0.200
     3.255   -10.683     0.200
     3.255   -10.694     0.200
     3.259   -16.150     0.200
     3.434   -16.344     0.200
     3.596   -14.207     0.200
     3.613   -16.560     0.200
     3.615   -16.604     0.200
     3.628   -14.561     0.200
     3.649   -14.742     0.200
     3.666   -21.094     0.200
     3.832   -16.102     0.200
     4.066   -15.227     0.200
     4.171   -19.715     0.200
     4.221   -19.682     0.200
     4.238   -17.852     0.200
     4.288   -19.083     0.200
     4.390   -19.042     0.200
     4.592   -17.028     0.200
     4.709   -22.741     0.200
     4.921   -29.988     0.200
     5.175   -31.882     0.200
     5.281   -30.233     0.200
     5.298   -21.383     0.200
     5.368   -27.162     0.200
     5.950   -26.222     0.200
     5.950   -26.217     0.200
     5.943   -30.138     0.200
     6.161   -35.040     0.200
     7.572   -41.299     0.200
     7.572   -37.401     0.200
     1.128     3.593     0.200
     1.574    -0.851     0.200
     2.173    -4.158     0.200
     2.359    -6.084     0.200
     2.425    -6.312     0.200
     2.827   -10.435     0.200
     3.001   -10.041     0.200
     3.123   -13.250     0.200
     3.127    -9.361     0.200
     3.159    -8.683     0.200
     3.216   -12.624     0.200
     3.232   -13.750     0.200
     3.243   -14.148     0.200
     3.251   -10.043     0.200
     3.251   -10.033     0.200
     3.252    -9.466     0.200
     3.256   -13.598     0.200
     3.430   -10.981     0.200
     3.610   -13.675     0.200
     3.612   -13.718     0.200
     3.625   -16.955     0.200
     3.631   -13.129     0.200
     3.646   -14.353     0.200
     3.829   -14.380     0.200
     4.170   -22.618     0.200
     4.221   -19.506     0.200
     4.287   -14.126     0.200
     4.388   -21.809     0.200
     4.588   -22.980     0.200
     4.706   -19.924     0.200
     4.918   -24.324     0.200
     4.986   -25.138     0.200
     5.174   -21.886     0.200
     5.173   -20.989     0.200
     5.278   -30.672     0.200
     5.367   -25.760     0.200
     5.938   -27.568     0.200
     6.160   -31.549     0.200
     1.109     1.478     0.200
     1.310     0.703     0.200
     2.347    -7.957     0.200
     2.996   -10.107     0.200
     3.119   -11.296     0.200
     3.209   -11.566     0.200
     3.237   -11.567     0.200
     3.244   -13.926     0.200
     3.663   -16.127     0.200
     4.165   -17.163     0.200
     4.218   -19.490     0.200
     4.283   -19.224     0.200
     4.383   -23.812     0.200
     4.701   -22.088     0.200
     4.981   -25.301     0.200
     5.272   -23.441     0.200
     5.363   -28.979     0.200
     1.076     0.997     0.200
     2.156    -7.107     0.200
     2.641    -9.961     0.200
     2.892   -12.122     0.200
     2.992   -10.382     0.200
     3.163   -13.708     0.200
     3.165   -15.183     0.200
     3.281   -15.143     0.200
     3.355   -15.228     0.200
     3.381   -13.829     0.200
     3.485   -15.037     0.200
     3.543   -16.505     0.200
     3.737   -21.830     0.200
     3.808   -17.470     0.200
     3.850   -17.347     0.200
     3.951   -20.410     0.200
     3.997   -16.106     0.200
     3.980   -20.163     0.200
     4.201   -16.794     0.200
     4.280   -22.469     0.200
     7.486   -44.787     0.200
     2.141    -4.312     0.200
     3.051    -8.660     0.200
     3.157    -8.547     0.200
     3.247   -10.006     0.200
     3.234   -10.129     0.200
     3.310   -11.299     0.200
     3.331   -13.570     0.200
     3.352   -14.723     0.200
     3.675   -10.605     0.200
     3.718   -10.781     0.200
     4.209   -18.389     0.200
     4.234   -18.187     0.200
     4.319   -19.539     0.200
     4.439   -16.250     0.200
     5.027   -22.489     0.200
     5.196   -20.851     0.200
     5.340   -24.114     0.200
     0.727     2.061     0.200
     2.460   -11.440     0.200
     3.015   -14.900     0.200
     3.458   -15.990     0.200
     3.582   -18.360     0.200
     3.886   -16.058     0.200
     3.890   -23.310     0.200
     3.869   -17.064     0.200
     3.882   -19.922     0.200
     3.892   -15.742     0.200
     3.897   -18.254     0.200
     4.069   -21.671     0.200
     4.044   -15.756     0.200
     4.269   -22.866     0.200
     4.603   -25.470     0.200
     4.586   -29.240     0.200
     4.693   -28.638     0.200
     4.529   -19.430     0.200
     4.673   -19.955     0.200
     4.987   -31.020     0.200
     5.279   -30.315     0.200
     5.925   -31.513     0.200
     1.715    -2.901     0.200
     2.151    -4.207     0.200
     3.205   -10.747     0.200
     3.709   -12.984     0.200
     4.270   -16.888     0.200
     4.365   -19.839     0.200
     4.815   -19.086     0.200
     5.078   -22.478     0.200
     5.237   -27.997     0.200
     5.452   -22.747     0.200
     1.775    -5.904     0.200
     2.521    -9.162     0.200
     2.853   -10.804     0.200
     3.684   -14.984     0.200
     3.945   -18.232     0.200
     4.127   -15.680     0.200
     4.573   -20.567     0.200
     4.535   -19.498     0.200
     4.582   -21.855     0.200
     4.553   -18.982     0.200
     4.560   -21.270     0.200
     4.563   -19.652     0.200
     4.618   -19.777     0.200
     4.741   -23.198     0.200
     4.693   -19.730     0.200
     4.962   -20.416     0.200
     5.383   -25.147     0.200
     5.671   -29.999     0.200
     5.692   -26.521     0.200
     5.766   -27.846     0.200
     5.819   -34.379     0.200
     5.971   -32.576     0.200
     6.287   -32.985     0.200
     6.322   -32.644     0.200
     6.388   -37.163     0.200
     7.190   -39.023     0.200
     7.157   -37.464     0.200
     7.304   -44.201     0.200
     7.984   -42.237     0.200
     8.130   -46.863     0.200
     9.043   -45.630     0.200
     9.845   -56.021     0.200
     9.872   -54.308     0.200
     9.981   -60.925     0.200
    11.179   -67.107     0.200
    11.178   -71.299     0.200
     0.907     1.895     0.200
     1.169     1.104     0.200
     1.181     1.914     0.200
     2.692   -13.291     0.200
     2.919   -11.702     0.200
     3.087   -17.356     0.200
     3.491   -17.191     0.200
     3.635   -16.452     0.200
     3.535   -12.811     0.200
     3.487   -11.345     0.200
     3.620   -18.808     0.200
     4.341   -15.343     0.200
     4.823   -25.810     0.200
     5.144   -26.030     0.200
     5.223   -34.215     0.200
     5.818   -28.938     0.200
     1.469    -5.139     0.200
     1.580    -3.554     0.200
     1.732    -7.311     0.200
     2.368   -12.673     0.200
     2.620   -12.745     0.200
     2.573   -11.697     0.200
     3.137   -20.763     0.200
     3.078   -13.181     0.200
     3.215   -13.728     0.200
     3.267   -15.885     0.200
     3.467   -13.430     0.200
     3.389   -13.488     0.200
     3.475   -15.432     0.200
     3.700   -23.191     0.200
     3.598   -17.657     0.200
     3.633   -19.253     0.200
     3.650   -13.136     0.200
     3.667   -12.897     0.200
     3.669   -14.737     0.200
     3.671   -16.824     0.200
     3.677   -17.761     0.200
     3.682   -14.917     0.200
     3.692   -17.079     0.200
     3.696   -15.495     0.200
     3.696   -16.645     0.200
     3.702   -17.383     0.200
     3.776   -13.604     0.200
     3.792   -17.986     0.200
     3.845   -16.496     0.200
     3.936   -19.405     0.200
     3.959   -20.177     0.200
     3.982   -19.589     0.200
     4.038   -21.721     0.200
     4.045   -19.809     0.200
     4.057   -20.569     0.200
     4.068   -20.276     0.200
     4.073   -20.816     0.200
     4.190   -20.933     0.200
     4.244   -21.306     0.200
     4.225   -20.126     0.200
     4.226   -20.144     0.200
     4.426   -25.551     0.200
     4.722   -28.851     0.200
     4.742   -29.342     0.200
     4.690   -18.676     0.200
     4.837   -28.456     0.200
     5.170   -29.317     0.200
     5.441   -31.635     0.200
     5.741   -34.286     0.200
     6.086   -32.291     0.200
     6.270   -37.610     0.200
     6.653   -39.753     0.200
     6.758   -41.820     0.200
     7.431   -40.167     0.200
     7.587   -46.159     0.200
     7.541   -42.044     0.200
     7.934   -46.348     0.200
     9.432   -59.938     0.200
     9.920   -56.337     0.200
     1.199    -3.265     0.200
     1.280    -2.662     0.200
     2.569    -9.518     0.200
     2.789   -10.448     0.200
     3.370   -16.056     0.200
     3.626   -16.042     0.200
     3.626   -15.582     0.200
     3.790   -16.781     0.200
     4.034   -22.938     0.200
     3.993   -19.915     0.200
     4.067   -19.609     0.200
     4.099   -20.545     0.200
     4.143   -21.422     0.200
     4.157   -17.786     0.200
     4.157   -21.116     0.200
     4.186   -20.054     0.200
     4.227   -21.319     0.200
     4.259   -20.345     0.200
     4.232   -20.910     0.200
     4.279   -20.320     0.200
     4.288   -21.189     0.200
     4.317   -17.561     0.200
     4.344   -21.068     0.200
     4.361   -20.960     0.200
     4.407   -22.120     0.200
     4.423   -22.223     0.200
     4.453   -22.575     0.200
     4.533   -23.577     0.200
     4.460   -20.907     0.200
     4.643   -22.564     0.200
     4.774   -23.403     0.200
     4.806   -27.729     0.200
     4.810   -24.533     0.200
     4.821   -23.558     0.200
     5.006   -24.790     0.200
     5.105   -28.482     0.200
     5.209   -27.481     0.200
     5.282   -27.252     0.200
     5.390   -29.078     0.200
     5.484   -29.159     0.200
     5.542   -31.668     0.200
     5.784   -32.202     0.200
     6.032   -31.862     0.200
     6.104   -34.981     0.200
     6.075   -34.939     0.200
     6.229   -40.484     0.200
     6.384   -36.730     0.200
     6.418   -38.209     0.200
     6.498   -34.659     0.200
     6.686   -35.654     0.200
     6.888   -40.065     0.200
     7.018   -39.152     0.200
     7.115   -43.933     0.200
     8.101   -48.780     0.200
     8.515   -52.588     0.200
     8.629   -52.175     0.200
     8.687   -51.479     0.200
    10.655   -66.891     0.200
     1.186     0.287     0.200
     2.735   -12.131     0.200
     2.944    -9.361     0.200
     3.108   -17.527     0.200
     3.456   -12.533     0.200
     3.483   -15.440     0.200
     3.536   -15.006     0.200
     3.659   -19.568     0.200
     3.587   -13.477     0.200
     3.549   -13.293     0.200
     3.756   -15.051     0.200
     3.975   -18.068     0.200
     4.227   -25.845     0.200
     4.185   -19.221     0.200
     4.379   -19.882     0.200
     4.402   -20.440     0.200
     4.406   -21.137     0.200
     4.408   -18.997     0.200
     4.516   -17.255     0.200
     4.402   -17.011     0.200
     4.505   -24.452     0.200
     4.429   -21.456     0.200
     4.645   -21.106     0.200
     4.864   -27.972     0.200
     5.184   -27.269     0.200
     5.315   -24.489     0.200
     5.620   -32.340     0.200
     5.861   -29.233     0.200
     6.028   -30.846     0.200
     0.300     3.534     0.200
     0.743    -0.135     0.200
     1.006    -0.656     0.200
     1.386    -3.974     0.200
     1.938   -10.406     0.200
     1.943    -7.747     0.200
     2.179   -10.938     0.200
     2.757   -15.163     0.200
     2.750   -11.512     0.200
     2.818   -10.931     0.200
     3.207   -17.388     0.200
     3.441   -18.359     0.200
     3.495   -15.323     0.200
     3.547   -19.144     0.200
     3.473   -15.010     0.200
     3.565   -14.169     0.200
     3.747   -22.356     0.200
     3.716   -17.103     0.200
     3.839   -16.609     0.200
     3.871   -16.457     0.200
     3.915   -18.850     0.200
     3.961   -22.633     0.200
     4.048   -17.802     0.200
     4.100   -22.443     0.200
     4.122   -19.988     0.200
     4.317   -25.981     0.200
     4.320   -19.412     0.200
     4.359   -19.784     0.200
     4.387   -24.517     0.200
     4.388   -27.840     0.200
     4.389   -21.858     0.200
     4.381   -21.934     0.200
     4.493   -24.715     0.200
     4.576   -24.421     0.200
     4.893   -30.184     0.200
     5.368   -32.287     0.200
     5.684   -39.856     0.200
     5.880   -35.388     0.200
     1.269     1.411     0.200
     1.225     1.597     0.200
     1.714    -2.548     0.200
     2.416    -6.368     0.200
     3.094    -8.247     0.200
     3.261   -11.900     0.200
     3.362   -12.156     0.200
     3.267   -10.632     0.200
     3.396   -11.285     0.200
     3.696   -12.307     0.200
     3.741   -12.095     0.200
     4.246   -17.657     0.200
     4.257   -17.841     0.200
     4.482   -16.319     0.200
     1.754    -2.512     0.200
     1.852    -4.545     0.200
     2.670    -8.445     0.200
     3.097   -12.201     0.200
     3.171   -12.667     0.200
     3.264   -10.069     0.200
     3.396    -9.875     0.200
     3.537   -12.223     0.200
     3.675   -12.310     0.200
     3.939   -14.761     0.200
     3.963   -13.604     0.200
     4.044   -18.878     0.200
     4.118   -16.676     0.200
     4.280   -18.109     0.200
     4.342   -18.571     0.200
     4.391   -16.826     0.200
     4.655   -22.959     0.200
     4.977   -22.643     0.200
     5.162   -26.719     0.200
     5.304   -30.830     0.200
     5.497   -27.445     0.200
     5.497   -25.315     0.200
     5.623   -27.184     0.200
     6.203   -35.825     0.200
     1.242     1.837     0.200
     1.253     2.294     0.200
     1.471    -1.387     0.200
     2.201    -6.289     0.200
     2.446    -7.278     0.200
     3.112   -10.810     0.200
     3.192    -9.915     0.200
     3.337   -10.489     0.200
     3.367   -10.998     0.200
     3.391   -13.191     0.200
     3.741   -13.404     0.200
     4.272   -18.906     0.200
     4.383   -19.653     0.200
     4.500   -19.525     0.200
     4.704   -19.911     0.200
     4.820   -23.160     0.200
     5.090   -23.627     0.200
     5.399   -25.011     0.200
     6.055   -27.621     0.200
     0.487     2.275     0.200
     1.438    -5.083     0.200
     2.082    -9.473     0.200
     2.710   -14.999     0.200
     3.076   -16.098     0.200
     3.176   -15.702     0.200
     3.261   -15.944     0.200
     3.309   -13.789     0.200
     3.639   -17.695     0.200
     3.645   -17.173     0.200
     3.829   -22.913     0.200
     3.769   -14.982     0.200
     4.119   -23.248     0.200
     4.155   -19.454     0.200
     4.488   -25.583     0.200
     4.540   -21.335     0.200
     4.548   -20.036     0.200
     4.807   -29.089     0.200
     4.926   -28.218     0.200
     5.226   -31.230     0.200
     5.209   -28.807     0.200
     5.493   -31.066     0.200
     5.869   -34.136     0.200
     5.931   -33.362     0.200
     5.934   -31.063     0.200
     7.363   -39.141     0.200
     2.589    -9.038     0.200
     2.533    -7.334     0.200
     2.738   -11.939     0.200
     3.159   -12.529     0.200
     3.443   -13.904     0.200
     3.442   -15.613     0.200
     3.459   -13.658     0.200
     3.820   -13.896     0.200
     3.905   -16.694     0.200
     4.137   -17.762     0.200
     4.247   -21.796     0.200
     4.323   -16.466     0.200
     4.546   -21.169     0.200
     4.559   -17.827     0.200
     4.712   -18.107     0.200
     4.831   -21.883     0.200
     5.197   -28.110     0.200
     5.252   -25.684     0.200
     0.250     5.475     0.200
     0.736     0.552     0.200
     0.997    -0.422     0.200
     1.460    -5.257     0.200
     1.535    -2.309     0.200
     1.980   -10.315     0.200
     2.254    -9.178     0.200
     2.820   -14.513     0.200
     2.753   -11.033     0.200
     2.887   -13.230     0.200
     3.251   -18.009     0.200
     3.555   -21.234     0.200
     3.540   -15.385     0.200
     3.612   -15.960     0.200
     4.030   -14.865     0.200
     4.364   -24.439     0.200
     4.267   -16.747     0.200
     4.395   -23.041     0.200
     4.429   -18.081     0.200
     4.459   -18.475     0.200
     4.463   -19.747     0.200
     4.611   -26.814     0.200
     4.564   -21.001     0.200
     4.633   -27.783     0.200
     4.645   -23.548     0.200
     4.956   -28.348     0.200
     5.277   -34.674     0.200
     5.425   -30.311     0.200
     5.642   -37.188     0.200
     5.739   -32.109     0.200
     5.940   -29.496     0.200
     1.343     1.077     0.200
     1.950    -3.269     0.200
     3.428   -16.990     0.200
     3.856   -16.049     0.200
     3.997   -19.706     0.200
     4.415   -17.899     0.200
     4.558   -27.391     0.200
     4.893   -20.691     0.200
     5.269   -31.509     0.200
     5.588   -30.835     0.200
     5.695   -28.066     0.200
     5.616   -28.243     0.200
     5.984   -26.273     0.200
     6.276   -38.096     0.200
     6.433   -36.394     0.200
     6.700   -34.932     0.200
     7.028   -41.785     0.200
     7.017   -38.206     0.200
     7.360   -36.626     0.200
     7.616   -43.929     0.200
     7.745   -39.288     0.200
     8.441   -52.399     0.200
     1.325    -4.196     0.200
     1.609    -7.551     0.200
     1.750   -10.308     0.200
     1.796    -5.304     0.200
     2.358   -10.779     0.200
     2.429   -13.769     0.200
     2.681    -9.480     0.200
     2.811   -11.300     0.200
     2.896   -12.644     0.200
     2.793   -13.188     0.200
     3.249   -13.446     0.200
     3.271   -14.525     0.200
     3.351   -16.686     0.200
     3.467   -19.195     0.200
     3.728   -20.449     0.200
     3.740   -17.915     0.200
     3.648   -17.940     0.200
     3.784   -14.571     0.200
     3.862   -16.878     0.200
     4.411   -23.140     0.200
     4.518   -18.544     0.200
     4.537   -20.532     0.200
     1.665    -5.692     0.200
     1.952    -5.777     0.200
     2.214    -9.981     0.200
     2.381   -10.203     0.200
     2.988   -16.014     0.200
     3.550   -19.099     0.200
     3.584   -15.836     0.200
     3.769   -16.937     0.200
     3.864   -16.527     0.200
     3.963   -15.813     0.200
     3.955   -20.342     0.200
     3.952   -17.424     0.200
     4.000   -24.337     0.200
     4.114   -21.616     0.200
     4.083   -20.993     0.200
     4.105   -21.067     0.200
     4.146   -18.479     0.200
     4.429   -21.970     0.200
     4.432   -20.609     0.200
     4.410   -17.786     0.200
     4.457   -19.290     0.200
     4.578   -19.536     0.200
     4.623   -22.343     0.200
     4.771   -20.201     0.200
     4.866   -23.198     0.200
     0.307     5.310     0.200
     0.975    -1.142     0.200
     1.094    -1.140     0.200
     1.164    -2.512     0.200
     1.178    -1.861     0.200
     1.207    -0.101     0.200
     1.237    -2.740     0.200
     1.266    -2.220     0.200
     1.364    -4.125     0.200
     1.360    -2.431     0.200
     1.493    -3.240     0.200
     1.708    -7.687     0.200
     1.636    -4.159     0.200
     1.808    -5.073     0.200
     2.116    -8.993     0.200
     2.174    -9.427     0.200
     2.312    -8.450     0.200
     2.570   -13.768     0.200
     2.838   -10.400     0.200
     2.979   -16.760     0.200
     2.970   -13.613     0.200
     3.368   -15.428     0.200
     3.377   -15.851     0.200
     3.593   -12.918     0.200
     3.665   -15.692     0.200
     3.777   -16.406     0.200
     3.802   -23.028     0.200
     1.261    -0.390     0.200
     0.581     5.199     0.200
     0.656     4.770     0.200
     0.868     2.248     0.200
     1.184    -2.928     0.200
     1.358    -4.365     0.200
     1.268    -1.265     0.200
     1.448    -3.578     0.200
     1.461    -3.674     0.200
     1.472    -2.959     0.200
     1.477    -3.603     0.200
     1.565    -5.900     0.200
     1.549    -4.042     0.200
     1.678    -6.040     0.200
     1.800    -6.534     0.200
     1.856    -9.446     0.200
     1.830    -9.544     0.200
     2.135    -8.161     0.200
     2.442   -12.797     0.200
     2.521   -11.585     0.200
     2.597   -12.287     0.200
     2.592   -11.183     0.200
     2.993   -16.025     0.200
     2.966   -14.556     0.200
     2.974   -14.687     0.200
     3.182   -15.229     0.200
     7.168   -45.036     0.200
     1.554    -2.374     0.200
     1.754    -5.128     0.200
     2.735   -10.568     0.200
     3.019   -15.524     0.200
     3.433   -15.752     0.200
     3.582   -17.083     0.200
     3.542   -16.022     0.200
     1.639    -1.947     0.200
     2.239    -4.442     0.200
     2.429    -5.914     0.200
     2.712    -8.523     0.200
     2.839    -7.597     0.200
     3.085   -10.499     0.200
     3.026    -9.844     0.200
     3.159   -10.161     0.200
     3.159   -11.038     0.200
     3.254   -11.070     0.200
     3.243   -11.157     0.200
     3.307    -9.795     0.200
     3.714   -13.775     0.200
     4.324   -17.931     0.200
     4.411   -18.477     0.200
     5.016   -18.977     0.200
     5.215   -22.423     0.200
     5.400   -27.591     0.200
     1.168     2.232     0.200
     1.300     0.665     0.200
     1.326     1.837     0.200
     1.774    -4.634     0.200
     2.006    -5.684     0.200
     2.125    -7.181     0.200
     2.292   -11.963     0.200
     2.429    -9.913     0.200
     2.531    -9.754     0.200
     2.804    -8.305     0.200
     3.035   -15.849     0.200
     3.198   -10.683     0.200
     3.316   -11.446     0.200
     3.325   -11.308     0.200
     3.562   -15.982     0.200
     3.577   -12.325     0.200
     3.673   -12.142     0.200
     3.949   -14.709     0.200
     4.134   -21.399     0.200
     4.080   -18.315     0.200
     4.138   -15.777     0.200
     4.188   -16.354     0.200
     4.338   -20.630     0.200
     4.373   -23.895     0.200
     4.361   -15.576     0.200
     4.670   -25.995     0.200
     4.992   -32.595     0.200
     5.147   -34.204     0.200
     5.156   -27.221     0.200
     2.414   -11.135     0.200
     3.021   -14.528     0.200
     3.523   -17.380     0.200
     3.582   -19.487     0.200
     3.982   -15.567     0.200
     4.147   -25.001     0.200
     4.389   -16.975     0.200
     4.418   -18.354     0.200
     4.427   -20.567     0.200
     4.833   -22.356     0.200
     0.539     4.199     0.200
     0.760     2.351     0.200
     0.854     1.674     0.200
     0.902     2.222     0.200
     0.912     1.745     0.200
     0.923     1.992     0.200
     0.949     1.222     0.200
     0.989     0.679     0.200
     1.013     0.444     0.200
     1.056     0.814     0.200
     1.131    -0.360     0.200
     1.188    -1.611     0.200
     1.281    -0.189     0.200
     1.341    -1.521     0.200
     1.693    -8.378     0.200
     1.811    -8.816     0.200
     1.869    -9.176     0.200
     2.045   -10.650     0.200
     2.101   -11.619     0.200
     2.388   -14.290     0.200
     2.521   -14.487     0.200
     2.589   -10.627     0.200
     2.867   -14.591     0.200
     3.126   -17.820     0.200
     3.297   -20.266     0.200
     3.268   -18.958     0.200
     3.342   -18.617     0.200
     3.367   -18.929     0.200
     3.358   -11.787     0.200
     3.496   -14.462     0.200
     3.608   -15.960     0.200
     3.646   -20.119     0.200
     3.758   -19.909     0.200
     4.152   -20.370     0.200
     4.182   -15.485     0.200
     4.184   -17.337     0.200
     4.219   -27.247     0.200
     4.405   -28.791     0.200
     4.447   -27.736     0.200
     4.727   -30.650     0.200
     5.050   -33.371     0.200
     5.230   -38.302     0.200
     5.224   -30.733     0.200
     5.388   -31.634     0.200
     5.553   -33.750     0.200
     6.247   -41.855     0.200
     0.986     2.651     0.200
     1.168     1.592     0.200
     1.190     2.834     0.200
     1.236     2.915     0.200
     1.278     1.550     0.200
     1.240     3.199     0.200
     1.383     2.664     0.200
     3.043   -10.276     0.200
     1.272     3.251     0.200
     2.667   -12.194     0.200
     8.892   -53.360     0.200
     1.006     1.045     0.200
     1.646    -3.485     0.200
     1.959    -7.229     0.200
     2.699   -10.951     0.200
     3.015   -13.269     0.200
     3.355   -15.139     0.200
     3.351   -14.297     0.200
     3.695   -17.180     0.200
     3.722   -17.368     0.200
     3.954   -18.797     0.200
     4.105   -19.384     0.200
     4.122   -19.022     0.200
     4.441   -21.480     0.200
     4.469   -22.185     0.200
     4.564   -23.093     0.200
     5.042   -26.639     0.200
     5.189   -27.006     0.200
     5.247   -27.166     0.200
     5.484   -28.849     0.200
     5.807   -30.848     0.200
     6.011   -31.494     0.200
     6.049   -32.470     0.200
     3.271   -11.411     0.200
     1.025     0.029     0.200
     1.896    -5.586     0.200
     2.022   -11.050     0.200
     2.078    -9.968     0.200
     1.560    -3.854     0.200
     1.931    -6.928     0.200
     2.733   -13.423     0.200
     3.066   -14.103     0.200
     3.337   -18.830     0.200
     2.917   -13.965     0.200
     3.018   -11.309     0.200
     3.766   -15.834     0.200
     3.856   -15.400     0.200
     3.872   -18.748     0.200
     3.874   -14.939     0.200
     3.905   -18.193     0.200
     3.933   -16.860     0.200
     4.019   -17.707     0.200
     4.126   -15.654     0.200
     3.954   -16.384     0.200
     4.234   -17.079     0.200
     4.241   -18.799     0.200
     4.250   -19.003     0.200
     4.301   -22.537     0.200
     4.309   -17.114     0.200
     4.315   -21.386     0.200
     4.322   -19.897     0.200
     4.322   -19.404     0.200
     4.322   -18.482     0.200
     4.330   -20.882     0.200
     4.360   -24.661     0.200
     4.406   -22.730     0.200
     4.437   -19.277     0.200
     4.456   -22.379     0.200
     4.466   -25.968     0.200
     4.505   -24.705     0.200
     4.737   -23.481     0.200
     4.766   -24.653     0.200
     4.802   -26.042     0.200
     4.786   -24.473     0.200
     4.814   -25.689     0.200
     4.685   -21.995     0.200
     4.684   -29.490     0.200
     4.945   -21.691     0.200
     4.749   -26.624     0.200
     5.013   -23.165     0.200
     5.180   -29.504     0.200
     5.055   -30.567     0.200
     5.498   -33.288     0.200
     5.488   -31.922     0.200
     5.603   -33.837     0.200
     1.271     2.356     0.200
     1.435     0.561     0.200
     2.127    -3.094     0.200
     1.138     1.680     0.200
     1.160     2.452     0.200
     1.224     1.228     0.200
     1.524    -4.430     0.200
     1.718    -3.826     0.200
     2.128    -6.692     0.200
     2.142    -7.812     0.200
     3.002   -10.599     0.200
     3.227   -13.419     0.200
     3.862   -14.512     0.200
     0.211     5.681     0.200
     0.969    -1.982     0.200
     1.000    -0.646     0.200
     1.072    -1.025     0.200
     1.103    -2.262     0.200
     1.107    -1.439     0.200
     1.118    -1.230     0.200
     1.160    -0.709     0.200
     1.231    -2.910     0.200
     1.274    -1.965     0.200
     1.407    -2.685     0.200
     1.443    -4.350     0.200
     1.539    -3.080     0.200
     1.602    -3.980     0.200
     1.873   -10.638     0.200
     2.536   -14.581     0.200
     2.516    -9.528     0.200
     2.733   -14.625     0.200
     2.854   -11.096     0.200
     3.145   -17.286     0.200
     0.235     6.659     0.200
     0.752     0.490     0.200
     0.883     0.111     0.200
     0.911     0.806     0.200
     0.994    -0.066     0.200
     1.013    -0.332     0.200
     1.032     0.772     0.200
     1.040     0.099     0.200
     1.082    -0.130     0.200
     1.247    -4.337     0.200
     1.205    -1.246     0.200
     1.277    -2.280     0.200
     1.338    -2.006     0.200
     1.466    -5.733     0.200
     1.464    -2.246     0.200
     1.615    -4.328     0.200
     1.968    -5.958     0.200
     2.630   -15.326     0.200
     2.814   -14.041     0.200
     3.240   -13.729     0.200
     3.548   -16.806     0.200
     3.607   -14.803     0.200
     1.130    -1.960     0.200
     1.220    -2.395     0.200
     1.420    -3.530     0.200
     1.627    -4.516     0.200
     1.740    -5.414     0.200
     1.824    -9.055     0.200
     2.403    -8.664     0.200
     2.668   -11.105     0.200
     2.891   -13.686     0.200
     3.406   -18.017     0.200
     3.557   -16.955     0.200
     3.562   -16.589     0.200
     3.626   -18.236     0.200
     3.705   -17.115     0.200
     3.714   -16.371     0.200
     3.806   -17.376     0.200
     3.854   -18.193     0.200
     4.041   -18.618     0.200
     4.051   -18.928     0.200
     4.132   -20.193     0.200
     4.144   -23.401     0.200
     4.177   -22.523     0.200
     4.223   -20.496     0.200
     4.227   -21.640     0.200
     4.252   -21.066     0.200
     4.281   -19.163     0.200
     4.294   -20.875     0.200
     4.333   -21.800     0.200
     4.310   -22.315     0.200
     4.324   -22.147     0.200
     4.324   -21.546     0.200
     4.331   -22.105     0.200
     4.351   -21.726     0.200
     4.388   -22.938     0.200
     4.406   -21.848     0.200
     4.412   -22.034     0.200
     4.464   -21.405     0.200
     4.486   -23.041     0.200
     4.518   -23.423     0.200
     4.542   -21.256     0.200
     4.548   -26.586     0.200
     4.698   -23.923     0.200
     4.716   -25.510     0.200
     4.834   -24.152     0.200
     4.866   -25.155     0.200
     5.121   -28.977     0.200
     5.244   -29.574     0.200
     5.528   -31.707     0.200
     8.731   -51.421     0.200
     1.309     0.260     0.200
     2.576   -10.159     0.200
     2.804   -10.073     0.200
     3.173    -9.628     0.200
     3.666   -11.731     0.200
     2.526    -8.817     0.200
     2.799   -14.221     0.200
     3.335   -13.577     0.200
     3.809   -14.694     0.200
     4.251   -23.865     0.200
     4.346   -20.645     0.200
     4.632   -28.721     0.200
     4.687   -24.774     0.200
     4.746   -19.131     0.200
     4.949   -21.661     0.200
     5.052   -21.614     0.200
     0.074    15.498     0.200
     0.121    14.801     0.200
     0.139    13.808     0.200
     0.205    12.361     0.200
     0.330    10.412     0.200
     0.334     8.642     0.200
     0.354    10.182     0.200
     0.386     9.488     0.200
     0.387     9.458     0.200
     0.532     6.236     0.200
     0.591     5.712     0.200
     0.697     5.048     0.200
     0.755     3.174     0.200
     0.919     0.069     0.200
     0.993    -0.814     0.200
     1.243    -2.174     0.200
     1.292    -0.803     0.200
     1.380    -1.792     0.200
     1.563    -1.588     0.200
     1.578    -3.195     0.200
     1.611    -3.300     0.200
     1.668    -5.595     0.200
     1.894    -5.236     0.200
     1.973   -10.961     0.200
     2.038    -6.544     0.200
     2.700   -15.943     0.200
     2.761   -13.101     0.200
     3.366   -18.118     0.200
     3.957   -26.993     0.200
    10.085   -58.400     0.200
     0.592     5.786     0.200
     0.692     4.254     0.200
     0.901     3.481     0.200
     1.111    -1.468     0.200
     1.381    -3.964     0.200
     1.398    -2.774     0.200
     1.334    -1.277     0.200
     1.395    -1.835     0.200
     1.421    -1.689     0.200
     1.442    -1.826     0.200
     1.451    -5.007     0.200
     1.467    -1.763     0.200
     1.498    -3.497     0.200
     1.619    -4.928     0.200
     1.682    -4.744     0.200
     1.895    -6.396     0.200
     1.981    -8.956     0.200
     2.334    -9.695     0.200
     2.376   -11.951     0.200
     2.561   -12.125     0.200
     2.659   -10.984     0.200
     2.714   -13.810     0.200
     2.918   -11.063     0.200
     3.041   -15.885     0.200
     3.047   -15.762     0.200
     3.611   -21.129     0.200
     3.726   -21.986     0.200
     3.787   -20.793     0.200
     4.030   -22.809     0.200
     4.353   -25.905     0.200
     4.548   -26.572     0.200
     4.607   -29.876     0.200
     4.996   -29.083     0.200
     5.617   -37.383     0.200
     1.614    -5.944     0.200
     2.483   -11.716     0.200
     2.442    -8.474     0.200
     2.657    -9.127     0.200
     3.090   -14.117     0.200
     3.499   -17.097     0.200
     3.604   -17.847     0.200
     3.653   -19.173     0.200
     4.510   -20.412     0.200
     0.204    17.559     0.200
     1.050     0.705     0.200
     1.060     1.758     0.200
     1.100     1.345     0.200
     1.113     0.926     0.200
     1.152     0.429     0.200
     1.152     1.079     0.200
     1.237    -0.608     0.200
     1.321    -0.991     0.200
     1.334    -2.057     0.200
     1.252     2.656     0.200
     1.861    -7.773     0.200
     2.139   -11.832     0.200
     2.440   -12.734     0.200
     2.827   -10.729     0.200
     2.929   -14.486     0.200
     3.005   -17.633     0.200
     2.993   -17.133     0.200
     3.456   -17.127     0.200
     3.613   -19.886     0.200
     3.645   -17.654     0.200
     4.021   -23.913     0.200
     4.055   -24.954     0.200
     4.145   -24.398     0.200
     1.052     4.168     0.200
     1.109     3.696     0.200
     1.359     1.923     0.200
     1.214     2.343     0.200
     2.153    -4.005     0.200
     1.410     1.535     0.200
     2.697    -6.890     0.200
     0.674     5.170     0.200
     0.720     4.862     0.200
     0.932     3.148     0.200
     1.247    -3.303     0.200
     1.241    -3.350     0.200
     1.259    -0.037     0.200
     1.570    -4.634     0.200
     1.564    -3.551     0.200
     1.589    -3.223     0.200
     1.593    -3.615     0.200
     1.611    -3.802     0.200
     1.635    -3.694     0.200
     1.665    -3.654     0.200
     1.742    -7.944     0.200
     1.682    -5.004     0.200
     1.737    -5.725     0.200
     1.791    -5.705     0.200
     1.847    -6.562     0.200
     1.918    -5.964     0.200
     2.077    -9.201     0.200
     2.175    -9.408     0.200
     2.304    -9.214     0.200
     2.403   -11.483     0.200
     2.487   -10.446     0.200
     2.493   -10.929     0.200
     2.446   -10.447     0.200
     2.491    -9.553     0.200
     2.561   -12.078     0.200
     2.538    -9.374     0.200
     2.547   -10.793     0.200
     2.647    -9.904     0.200
     2.753    -9.980     0.200
     2.771   -13.165     0.200
     2.814   -12.532     0.200
     2.799   -11.265     0.200
     2.875   -14.217     0.200
     2.829   -10.942     0.200
     2.833   -13.686     0.200
     2.843   -14.502     0.200
     2.843   -12.080     0.200
     2.844   -13.246     0.200
     2.844   -11.136     0.200
     2.854   -11.452     0.200
     2.886   -13.496     0.200
     2.927   -12.345     0.200
     2.955   -12.049     0.200
     2.970   -10.288     0.200
     3.039   -16.907     0.200
     3.084   -13.807     0.200
     3.285   -14.640     0.200
     3.261   -13.038     0.200
     3.263   -14.841     0.200
     3.315   -18.255     0.200
     3.318   -15.815     0.200
     3.309   -14.175     0.200
     3.327   -13.884     0.200
     3.445   -19.837     0.200
     3.399   -15.722     0.200
     3.399   -14.502     0.200
     3.502   -17.668     0.200
     3.554   -20.015     0.200
     3.615   -20.078     0.200
     3.578   -11.886     0.200
     3.620   -18.123     0.200
     3.746   -16.018     0.200
     3.859   -21.458     0.200
     3.994   -24.381     0.200
     3.960   -16.693     0.200
     4.072   -19.556     0.200
     4.182   -25.640     0.200
     4.135   -19.574     0.200
     4.376   -23.961     0.200
     4.438   -25.943     0.200
     4.513   -24.362     0.200
     4.480   -22.526     0.200
     4.510   -21.518     0.200
     4.588   -23.960     0.200
     4.559   -25.032     0.200
     4.719   -28.676     0.200
     4.828   -27.449     0.200
     5.064   -27.095     0.200
     5.143   -27.228     0.200
     5.369   -33.088     0.200
     5.447   -35.560     0.200
     6.433   -43.027     0.200
     6.640   -37.634     0.200
     7.063   -45.374     0.200
     7.063   -44.813     0.200
    13.137   -90.133     0.200
     0.476     2.412     0.200
     1.085    -2.292     0.200
     1.115    -2.491     0.200
     1.224    -3.337     0.200
     1.266    -3.162     0.200
     1.261    -2.947     0.200
     1.266    -2.280     0.200
     1.287    -1.540     0.200
     1.294    -1.733     0.200
     1.310    -0.859     0.200
     1.334    -1.355     0.200
     1.374    -3.145     0.200
     1.376    -4.033     0.200
     1.452    -2.412     0.200
     1.444    -4.455     0.200
     1.535    -7.300     0.200
     1.576    -4.723     0.200
     1.769    -8.025     0.200
     1.729    -5.676     0.200
     1.982    -8.760     0.200
     2.050   -11.587     0.200
     1.985    -3.561     0.200
     2.196   -11.742     0.200
     2.385    -8.817     0.200
     2.346   -12.592     0.200
     2.361    -9.820     0.200
     2.442   -13.679     0.200
     2.739   -16.673     0.200
     2.741   -13.563     0.200
     2.805   -14.458     0.200
     2.980   -16.851     0.200
     3.111   -16.915     0.200
     3.184   -11.411     0.200
     3.344   -18.620     0.200
     3.623   -19.112     0.200
     3.589   -16.811     0.200
     3.915   -22.798     0.200
     4.028   -17.822     0.200
     4.064   -21.064     0.200
     4.078   -20.329     0.200
     4.115   -18.532     0.200
     4.164   -22.438     0.200
     4.183   -24.349     0.200
     4.366   -20.017     0.200
     4.402   -22.162     0.200
     4.430   -23.031     0.200
     4.516   -26.836     0.200
     4.521   -22.660     0.200
     4.837   -29.538     0.200
     4.932   -29.941     0.200
     4.977   -31.100     0.200
     5.257   -31.163     0.200
     5.288   -31.295     0.200
     5.511   -34.914     0.200
     1.123     3.506     0.200
     1.133     3.733     0.200
     2.345    -7.101     0.200
     2.700   -13.357     0.200
     2.998   -11.297     0.200
     3.117   -14.752     0.200
     3.656   -17.694     0.200
     2.389   -10.844     0.200
     2.366    -8.660     0.200
     2.409    -8.349     0.200
     2.399    -8.891     0.200
     2.675   -13.598     0.200
     2.743   -13.943     0.200
     2.881   -13.659     0.200
     2.984   -14.734     0.200
     3.055   -12.398     0.200
     3.049   -11.430     0.200
     3.172   -12.108     0.200
     3.157   -14.473     0.200
     3.162   -17.991     0.200
     3.222   -16.675     0.200
     3.225   -18.062     0.200
     3.261   -12.367     0.200
     3.291   -13.466     0.200
     3.300   -17.028     0.200
     3.295   -17.640     0.200
     3.311   -16.013     0.200
     3.887   -16.296     0.200
     4.220   -20.977     0.200
     4.441   -23.392     0.200
     4.761   -23.749     0.200
     2.070    -2.947     0.200
     2.346    -6.377     0.200
     2.416    -7.623     0.200
     2.901    -7.507     0.200
     3.092   -11.715     0.200
     3.191   -10.731     0.200
     3.265   -10.953     0.200
     3.256   -10.491     0.200
     0.853     1.633     0.200
     0.912     0.021     0.200
     1.012    -0.743     0.200
     1.145     0.567     0.200
     1.321    -4.250     0.200
     1.423    -4.610     0.200
     1.413    -4.771     0.200
     1.574    -5.005     0.200
     1.624    -4.492     0.200
     1.738    -6.219     0.200
     1.899    -5.995     0.200
     1.892    -6.645     0.200
     1.968    -4.766     0.200
     1.996    -5.795     0.200
     1.920    -6.415     0.200
     2.133    -7.568     0.200
     2.168   -12.032     0.200
     2.183    -9.934     0.200
     2.604   -12.929     0.200
     3.033   -13.439     0.200
     3.198   -15.862     0.200
     3.301   -17.769     0.200
     3.604   -19.563     0.200
     3.654   -16.467     0.200
     3.844   -20.344     0.200
     3.844   -15.049     0.200
     3.986   -24.349     0.200
     4.303   -26.328     0.200
     4.321   -26.238     0.200
     4.406   -32.089     0.200
     4.428   -21.348     0.200
     4.701   -27.037     0.200
     4.730   -22.123     0.200
     4.728   -24.785     0.200
     4.999   -25.236     0.200
     0.298     4.178     0.200
     0.759    -0.029     0.200
     0.882    -0.867     0.200
     0.916    -0.867     0.200
     0.957    -0.394     0.200
     0.978    -0.331     0.200
     0.981    -0.705     0.200
     1.012    -0.932     0.200
     1.022    -1.482     0.200
     1.025    -0.836     0.200
     1.067    -0.662     0.200
     1.161    -2.119     0.200
     1.176    -0.735     0.200
     1.265    -2.376     0.200
     1.310    -2.088     0.200
     1.379    -3.207     0.200
     1.531    -4.393     0.200
     1.597    -5.502     0.200
     1.920    -8.426     0.200
     1.961    -8.159     0.200
     2.153    -8.501     0.200
     2.417   -10.616     0.200
     2.581   -14.829     0.200
     2.740   -14.618     0.200
     2.765   -13.147     0.200
     2.845   -14.155     0.200
     3.189   -18.598     0.200
     0.062     8.908     0.200
     0.883    -1.070     0.200
     1.131    -2.160     0.200
     1.136    -2.150     0.200
     1.148    -1.152     0.200
     1.149    -1.679     0.200
     1.190     0.131     0.200
     1.193    -1.237     0.200
     1.235    -1.162     0.200
     1.414    -4.045     0.200
     1.425    -3.252     0.200
     1.504    -3.288     0.200
     1.583    -4.545     0.200
     1.627    -5.978     0.200
     1.621    -3.565     0.200
     1.784    -6.260     0.200
     1.957    -7.648     0.200
     2.404    -9.359     0.200
     2.468    -9.432     0.200
     2.618   -14.655     0.200
     2.644   -10.037     0.200
     2.872   -12.292     0.200
     3.227   -19.403     0.200
     3.590   -16.369     0.200
     3.673   -15.924     0.200
     4.112   -18.520     0.200
     0.716     2.910     0.200
     0.780     1.431     0.200
     0.992     0.671     0.200
     1.174    -2.446     0.200
     1.227    -2.938     0.200
     1.336    -1.257     0.200
     1.437    -4.552     0.200
     1.539    -4.461     0.200
     1.575    -4.436     0.200
     1.577    -4.610     0.200
     1.594    -4.744     0.200
     7.103   -45.211     0.200
    11.772   -79.363     0.200
     1.238    -4.213     0.200
     1.886    -9.101     0.200
     1.787    -6.958     0.200
     1.902    -5.716     0.200
     2.012    -7.298     0.200
     2.316   -10.152     0.200
     2.490   -11.765     0.200
     2.744   -11.336     0.200
     2.810   -10.979     0.200
     3.013   -14.877     0.200
     3.585   -18.389     0.200
     3.500   -13.816     0.200
     1.506    -5.699     0.200
     1.896    -8.756     0.200
     1.902    -6.433     0.200
     2.118    -8.054     0.200
     2.529   -13.462     0.200
     2.711    -9.194     0.200
     2.798   -12.562     0.200
     2.893   -11.910     0.200
     3.232   -12.693     0.200
     3.642   -13.387     0.200
     3.809   -13.387     0.200
     3.856   -13.777     0.200
     4.387   -19.970     0.200
     4.449   -17.065     0.200
     4.752   -18.778     0.200
     5.020   -19.616     0.200
     5.406   -29.776     0.200
     5.454   -26.936     0.200
     0.692     1.228     0.200
     1.806    -5.774     0.200
     3.656   -19.157     0.200
     0.835     0.262     0.200
     2.079    -7.147     0.200
     3.271   -13.958     0.200
     3.878   -20.843     0.200
     1.859    -6.991     0.200
     2.518   -12.827     0.200
     2.830   -10.764     0.200
     0.906    -1.687     0.200
     0.937    -0.016     0.200
     1.196    -3.395     0.200
     1.183    -1.439     0.200
     1.442    -3.495     0.200
     1.516    -3.688     0.200
     1.544    -3.883     0.200
     1.557    -3.964     0.200
     1.554    -3.603     0.200
     1.590    -3.310     0.200
     1.627    -3.830     0.200
     1.715    -8.607     0.200
     1.690    -4.960     0.200
     1.656    -3.193     0.200
     1.841    -8.782     0.200
     1.767    -5.131     0.200
     1.823    -9.554     0.200
     1.954   -10.566     0.200
     1.938    -6.636     0.200
     1.954    -6.059     0.200
     2.369   -13.250     0.200
     2.687   -11.525     0.200
     2.638   -11.777     0.200
     2.751   -10.397     0.200
     3.038   -13.870     0.200
     3.192   -16.247     0.200
     0.362     4.438     0.200
     1.077    -1.809     0.200
     1.194    -2.987     0.200
     1.178    -2.627     0.200
     1.231    -1.807     0.200
     1.249    -3.104     0.200
     1.273    -2.400     0.200
     1.279    -1.289     0.200
     1.301    -4.367     0.200
     1.339    -2.126     0.200
     1.320    -1.132     0.200
     1.362    -1.698     0.200
     1.448    -2.638     0.200
     1.608    -7.083     0.200
     1.581    -3.632     0.200
     1.841   -11.229     0.200
     1.727    -4.683     0.200
     1.908   -10.062     0.200
     2.118   -13.316     0.200
     2.270   -12.553     0.200
     2.275   -11.754     0.200
     2.491   -10.508     0.200
     2.814   -17.104     0.200
     2.880   -15.236     0.200
     3.067   -11.927     0.200
     3.167   -15.710     0.200
     3.212   -15.452     0.200
     3.426   -18.044     0.200
     3.648   -12.132     0.200
     3.736   -12.246     0.200
     4.262   -25.365     0.200
     4.275   -24.482     0.200
     4.424   -17.034     0.200
     4.619   -28.697     0.200
     4.939   -32.392     0.200
     1.357    -1.501     0.200
     0.964     0.818     0.200
     1.873    -6.026     0.200
     2.403    -9.427     0.200
     2.394    -7.979     0.200
     2.590    -7.663     0.200
     2.685    -8.626     0.200
     2.729    -8.834     0.200
     2.697    -8.801     0.200
     2.830   -11.077     0.200
     2.876    -9.526     0.200
     2.813    -8.637     0.200
     2.940   -12.861     0.200
     3.083   -11.391     0.200
     3.004    -9.811     0.200
     3.264   -12.516     0.200
     3.356   -14.785     0.200
     3.258   -10.885     0.200
     3.388   -13.498     0.200
     3.883   -17.471     0.200
     3.913   -17.946     0.200
     3.992   -18.760     0.200
     4.118   -17.887     0.200
     4.138   -18.653     0.200
     4.178   -17.284     0.200
     4.454   -24.980     0.200
     4.438   -21.241     0.200
     4.419   -17.614     0.200
     4.702   -22.955     0.200
     4.653   -19.760     0.200
     4.871   -28.184     0.200
     5.027   -24.359     0.200
     5.077   -24.403     0.200
     5.097   -23.803     0.200
     0.954     2.600     0.200
     2.189    -7.574     0.200
     2.363    -9.494     0.200
     2.475    -9.319     0.200
     2.969   -14.366     0.200
     2.867    -9.774     0.200
     3.031   -11.001     0.200
     3.218   -14.291     0.200
     3.262   -14.851     0.200
     3.497   -18.090     0.200
     3.674   -17.635     0.200
     4.069   -21.315     0.200
     4.613   -25.946     0.200
     1.099     1.278     0.200
     1.146     3.077     0.200
     1.260     0.575     0.200
     1.299     0.456     0.200
     1.323     1.974     0.200
     1.375     2.172     0.200
     1.390     1.992     0.200
     1.599    -1.710     0.200
     2.348    -6.209     0.200
     2.374    -6.504     0.200
     2.583    -6.770     0.200
     2.658    -8.776     0.200
     2.815    -7.288     0.200
     2.960   -11.597     0.200
     2.932    -8.370     0.200
     2.994    -8.381     0.200
     2.975   -13.828     0.200
     3.006   -14.142     0.200
     3.036    -8.462     0.200
     3.047    -9.960     0.200
     3.084   -16.612     0.200
     3.119   -10.767     0.200
     3.092    -9.761     0.200
     3.125    -9.769     0.200
     3.192   -10.574     0.200
     3.256   -12.369     0.200
     3.231   -11.176     0.200
     3.241   -18.277     0.200
     3.191    -8.851     0.200
     3.413   -11.514     0.200
     3.439   -11.834     0.200
     3.580   -12.412     0.200
     3.598   -12.288     0.200
     3.612   -11.427     0.200
     3.667   -13.121     0.200
     3.856   -16.976     0.200
     3.816   -16.571     0.200
     4.164   -15.389     0.200
     4.221   -19.577     0.200
     4.284   -15.995     0.200
     4.210   -15.782     0.200
     4.379   -18.010     0.200
     4.553   -18.025     0.200
     4.562   -16.576     0.200
     4.698   -20.789     0.200
     4.858   -20.371     0.200
     4.906   -21.162     0.200
     4.980   -22.563     0.200
     5.172   -25.011     0.200
     5.267   -24.637     0.200
     5.279   -26.403     0.200
     5.362   -24.849     0.200
     5.941   -28.392     0.200
     5.914   -25.528     0.200
     6.157   -30.868     0.200
     6.071   -27.672     0.200
     7.108   -39.923     0.200
     7.560   -40.071     0.200
     3.483   -17.163     0.200
     3.504   -13.866     0.200
     3.758   -17.197     0.200
     3.862   -17.483     0.200
     3.941   -15.308     0.200
     3.952   -14.987     0.200
     3.953   -15.673     0.200
     3.958   -19.694     0.200
     3.958   -20.342     0.200
     3.970   -20.617     0.200
     3.979   -20.586     0.200
     3.988   -20.551     0.200
     3.996   -15.186     0.200
     3.999   -20.501     0.200
     4.038   -19.910     0.200
     4.142   -21.160     0.200
     4.216   -22.310     0.200
     4.357   -21.526     0.200
     4.359   -21.689     0.200
     4.432   -22.252     0.200
     4.434   -21.471     0.200
     4.522   -16.550     0.200
     4.619   -24.140     0.200
     4.936   -26.908     0.200
     8.131   -49.230     0.200
     8.117   -52.185     0.200
     8.155   -55.160     0.200
     2.360   -12.015     0.200
     3.643   -17.370     0.200
     4.065   -19.998     0.200
     4.084   -22.915     0.200
     4.102   -23.108     0.200
     4.113   -20.969     0.200
     4.154   -20.851     0.200
     4.161   -21.427     0.200
     4.263   -21.142     0.200
     4.339   -21.448     0.200
     4.358   -23.179     0.200
     4.404   -25.972     0.200
     4.497   -24.682     0.200
     4.548   -27.013     0.200
     4.671   -27.734     0.200
     4.730   -28.246     0.200
     5.023   -28.863     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     3.250    -7.862     0.200
     5.642   -16.709     0.200
     1.421    -0.647     0.200
     4.039    -9.643     0.200
     4.111   -11.601     0.200
     4.121    -9.917     0.200
     6.883   -24.481     0.200
     3.605   -10.179     0.200
     3.019    -8.312     0.200
     0.085     5.570     0.200
     1.880    -4.323     0.200
     6.234   -19.367     0.200
     1.310    -5.687     0.200
     1.401    -0.206     0.200
     4.094    -9.297     0.200
     2.441    -6.991     0.200
     3.331    -9.907     0.200
     1.895    -3.983     0.200
     2.961    -7.466     0.200
     3.465   -11.153     0.200
     1.252     1.040     0.200
     2.448    -7.102     0.200
     1.961    -3.666     0.200
     3.581   -13.441     0.200
     1.451    -2.368     0.200
     3.415   -12.194     0.200
     3.459   -11.978     0.200
     3.558   -11.789     0.200
     3.833   -14.291     0.200
     1.359    -1.147     0.200
     1.468    -2.523     0.200
     2.365    -4.484     0.200
     2.462    -7.254     0.200
     3.490   -10.026     0.200
     1.198    -0.410     0.200
     1.148    -1.143     0.200
     1.094    -0.646     0.200
     1.975    -1.576     0.200
     2.451    -7.057     0.200
     2.050    -3.912     0.200
     2.503    -7.250     0.200
     3.452    -8.078     0.200
     1.219    -0.480     0.200
     3.269    -9.402     0.200
     3.383   -10.702     0.200
     1.136    -0.953     0.200
     1.283    -1.602     0.200
     3.710   -12.197     0.200
     4.029   -14.078     0.200
     1.143    -2.411     0.200
     1.545    -1.497     0.200
     1.846    -2.525     0.200
     2.034    -2.726     0.200
     3.054    -8.586     0.200
     3.830   -13.015     0.200
     4.266   -12.364     0.200
     1.222    -0.165     0.200
     1.287    -1.166     0.200
     2.998   -10.175     0.200
     3.333   -11.777     0.200
     3.333   -10.468     0.200
     1.745    -3.066     0.200
     2.048    -3.797     0.200
     1.070    -1.088     0.200
     1.869    -3.901     0.200
     1.961    -1.508     0.200
     2.027    -3.173     0.200
     3.261    -9.260     0.200
     3.783   -12.777     0.200
     3.783   -12.447     0.200
     0.929     0.434     0.200
     3.408    -9.583     0.200
     0.559     2.724     0.200
     0.820     0.017     0.200
     1.991    -2.387     0.200
     3.642   -12.711     0.200
     1.287    -0.339     0.200
     3.824   -13.439     0.200
     1.983    -5.156     0.200
     1.279    -0.243     0.200
     2.311    -4.421     0.200
     3.969    -8.842     0.200
     4.697   -17.619     0.200
     2.486    -5.507     0.200
     4.485   -15.450     0.200
     1.266    -1.381     0.200
     3.953   -14.441     0.200
     4.382   -15.392     0.200
     0.226     3.651     0.200
     3.991   -12.989     0.200
     4.354   -14.567     0.200
     4.382   -15.338     0.200
     4.719   -15.490     0.200
     4.786   -16.910     0.200
     4.821   -16.316     0.200
     5.183   -17.830     0.200
     0.489     1.522     0.200
     3.235    -7.402     0.200
     3.713    -6.947     0.200
     3.735    -8.836     0.200
     5.953   -14.165     0.200
     0.837     0.901     0.200
     1.174     0.305     0.200
     4.601   -12.565     0.200
     4.700   -13.822     0.200
     0.961     0.675     0.200
     1.149     0.504     0.200
     1.626     2.136     0.200
     2.949    -4.920     0.200
     3.581    -9.619     0.200
     0.753     0.348     0.200
     1.167    -0.819     0.200
     1.038    -0.539     0.200
     1.843    -1.574     0.200
     2.532    -7.271     0.200
     3.130    -6.678     0.200
     3.142    -8.873     0.200
     3.186    -8.045     0.200
     3.596   -11.779     0.200
     3.635   -11.358     0.200
     4.670   -14.547     0.200
     0.483     2.045     0.200
     1.515    -2.251     0.200
     1.573    -0.147     0.200
     2.252    -0.863     0.200
     3.080    -7.153     0.200
     0.434     2.400     0.200
     4.358   -13.567     0.200
     0.452     0.977     0.200
     2.455    -2.131     0.200
     3.052    -8.861     0.200
     7.728   -21.145     0.200
     0.211     2.315     0.200
     1.819    -4.089     0.200
     4.817   -11.598     0.200
     6.629   -13.851     0.200
     0.942    -0.265     0.200
     4.355   -15.207     0.200
     4.526   -17.518     0.200
     4.583   -10.209     0.200
     1.404    -2.348     0.200
     1.502    -2.521     0.200
     0.794     0.106     0.200
     1.368    -0.669     0.200
     1.818    -1.614     0.200
     2.061    -3.470     0.200
     0.081     3.577     0.200
     1.241     0.159     0.200
     0.756     0.887     0.200
     0.756     0.597     0.200
     1.272    -1.848     0.200
     1.272    -0.428     0.200
     1.888    -1.898     0.200
     1.999    -2.740     0.200
     2.122    -3.735     0.200
     2.931    -8.889     0.200
     2.931    -8.009     0.200
     3.339   -11.521     0.200
     3.533   -11.152     0.200
     0.950     0.225     0.200
     0.966     0.536     0.200
     1.038     1.005     0.200
     1.218     1.853     0.200
     1.245    -0.481     0.200
     1.609    -2.826     0.200
     1.989    -2.238     0.200
     3.171    -6.451     0.200
     3.236    -8.284     0.200
     0.089     3.611     0.200
     0.954     0.665     0.200
     1.563    -0.516     0.200
     1.733    -1.540     0.200
     3.246   -10.302     0.200
     3.640    -8.816     0.200
     3.735   -10.596     0.200
     3.826    -9.094     0.200
     4.169    -9.928     0.200
     4.283   -10.450     0.200
     4.626   -15.848     0.200
     6.413   -21.857     0.200
     6.502   -15.956     0.200
     6.795   -23.461     0.200
     7.571   -23.074     0.200
     0.282     0.073     0.200
     3.930    -8.328     0.200
     0.559     0.624     0.200
     0.559     0.898     0.200
     0.655     1.138     0.200
     0.655     1.286     0.200
     0.730     0.421     0.200
     0.957     0.459     0.200
     2.205    -3.173     0.200
     2.294    -4.128     0.200
     3.685    -7.815     0.200
     4.308   -11.087     0.200
     4.317   -12.050     0.200
     4.317   -11.394     0.200
     4.360   -14.441     0.200
     4.653   -10.144     0.200
     5.010   -15.133     0.200
     5.323   -14.013     0.200
     6.337   -15.610     0.200
     6.819   -17.338     0.200
     7.286   -12.854     0.200
     0.612     1.361     0.200
     1.396    -2.179     0.200
     1.435    -2.510     0.200
     1.549    -2.734     0.200
     1.585    -2.385     0.200
     1.587    -2.026     0.200
     1.602    -1.625     0.200
     3.076    -9.047     0.200
     3.113   -10.001     0.200
     3.267    -8.682     0.200
     3.487    -8.931     0.200
     3.556   -10.897     0.200
     4.001   -14.887     0.200
     0.908    -0.531     0.200
     1.342    -0.278     0.200
     1.422    -2.024     0.200
     1.394    -0.607     0.200
     1.495    -2.465     0.200
     1.535    -1.546     0.200
     1.529    -0.820     0.200
     1.530     0.237     0.200
     1.545    -0.311     0.200
     2.051    -4.104     0.200
     3.166    -7.063     0.200
     3.180    -9.146     0.200
     3.250    -6.918     0.200
     3.421   -10.140     0.200
     3.556    -7.648     0.200
     0.108     3.834     0.200
     0.824     0.151     0.200
     0.901     0.971     0.200
     0.997    -0.672     0.200
     1.597    -0.489     0.200
     1.721    -1.405     0.200
     2.020    -0.953     0.200
     2.369    -0.266     0.200
     2.915    -8.279     0.200
     3.160    -7.634     0.200
     3.670   -10.754     0.200
     3.759   -11.285     0.200
     3.712    -7.195     0.200
     4.715   -14.423     0.200
     0.081     4.216     0.200
     0.876    -0.166     0.200
     0.949     0.051     0.200
     1.214     0.559     0.200
     1.225     0.014     0.200
     1.257    -0.869     0.200
     1.271    -0.664     0.200
     1.558    -0.681     0.200
     1.724    -2.221     0.200
     1.976    -4.350     0.200
     1.966    -1.969     0.200
     3.173    -9.261     0.200
     3.243   -10.811     0.200
     3.635    -9.470     0.200
     3.792   -10.291     0.200
     4.072   -14.854     0.200
     4.200   -14.768     0.200
     4.369   -14.491     0.200
     5.046   -19.483     0.200
     5.390   -20.014     0.200
     0.045     7.517     0.200
     0.904     0.551     0.200
     1.029    -0.947     0.200
     1.157     0.105     0.200
     1.166     0.876     0.200
     1.195    -0.151     0.200
     1.211     0.275     0.200
     3.661   -12.895     0.200
     1.642    -2.981     0.200
     1.789    -3.217     0.200
     1.798    -3.919     0.200
     1.799    -3.144     0.200
     1.807    -3.658     0.200
     1.835    -3.225     0.200
     1.909    -2.489     0.200
     2.274    -2.658     0.200
     2.647    -8.402     0.200
     2.767    -7.524     0.200
     2.840    -5.889     0.200
     2.841    -5.605     0.200
     3.190   -10.762     0.200
     3.253   -11.026     0.200
     3.263   -11.183     0.200
     3.393    -8.833     0.200
     3.570    -9.464     0.200
     3.817   -10.298     0.200
     4.489   -11.019     0.200
     4.410   -15.306     0.200
     4.665   -18.064     0.200
     4.997   -18.885     0.200
     5.071   -18.003     0.200
     0.636     0.136     0.200
     1.145     0.332     0.200
     1.512    -1.117     0.200
     1.640    -1.025     0.200
     1.643    -1.973     0.200
     1.644     0.592     0.200
     1.651    -2.222     0.200
     1.667    -2.154     0.200
     1.674     0.033     0.200
     1.690    -1.925     0.200
     1.722    -0.337     0.200
     1.742    -2.846     0.200
     2.655    -7.476     0.200
     4.769   -14.334     0.200
     0.875     2.204     0.200
     1.730     0.086     0.200
     2.091    -3.081     0.200
     2.106    -1.776     0.200
     2.094    -0.936     0.200
     2.185    -1.823     0.200
     3.312    -6.316     0.200
     3.348    -8.906     0.200
     3.406    -7.173     0.200
     3.459    -9.141     0.200
     3.502    -9.211     0.200
     3.593    -7.784     0.200
     3.698   -10.710     0.200
     3.778    -6.124     0.200
     3.787    -6.596     0.200
     3.814    -6.737     0.200
     3.828    -8.642     0.200
     3.900    -8.643     0.200
     3.921    -8.445     0.200
     3.976    -8.326     0.200
     4.052    -9.998     0.200
     4.121    -9.825     0.200
     4.266   -13.249     0.200
     4.446   -13.582     0.200
     4.691   -10.397     0.200
     0.937     1.133     0.200
     1.101     0.163     0.200
     1.507    -0.825     0.200
     1.627    -0.786     0.200
     1.644    -0.714     0.200
     1.630     0.356     0.200
     1.630    -0.664     0.200
     1.660    -0.835     0.200
     1.677    -1.138     0.200
     1.741    -2.200     0.200
     1.914    -5.397     0.200
     4.168   -15.561     0.200
     0.055     5.179     0.200
     0.958    -0.304     0.200
     1.000    -0.179     0.200
     1.120    -1.434     0.200
     1.158    -0.816     0.200
     1.262    -1.127     0.200
     1.291    -1.460     0.200
     1.686    -3.230     0.200
     1.665    -3.412     0.200
     3.020    -8.052     0.200
     3.068    -9.635     0.200
     3.532   -12.513     0.200
     3.653   -12.569     0.200
     3.683   -10.046     0.200
     4.561   -14.687     0.200
     4.794   -18.357     0.200
     0.032     5.334     0.200
     1.200    -1.442     0.200
     1.209    -0.180     0.200
     1.237     1.233     0.200
     1.254    -1.264     0.200
     1.258     0.091     0.200
     1.622    -1.884     0.200
     2.378    -2.748     0.200
     3.531   -12.203     0.200
     3.652   -10.119     0.200
     0.825     1.224     0.200
     0.849     1.397     0.200
     0.837     2.430     0.200
     0.847     1.285     0.200
     0.847     2.675     0.200
     0.858     1.237     0.200
     0.879     2.080     0.200
     0.992     0.919     0.200
     0.934     2.016     0.200
     1.485    -1.236     0.200
     1.485    -0.957     0.200
     1.655    -1.410     0.200
     1.840    -1.074     0.200
     2.505    -3.454     0.200
     2.854    -5.763     0.200
     2.949    -5.305     0.200
     2.948    -8.072     0.200
     3.176    -8.648     0.200
     3.322    -9.345     0.200
     3.418   -10.003     0.200
     3.443    -8.577     0.200
     3.590   -10.597     0.200
     3.575    -9.537     0.200
     3.797   -11.694     0.200
     4.232   -13.990     0.200
     0.075     4.200     0.200
     0.980    -1.046     0.200
     1.266     1.530     0.200
     1.274     0.622     0.200
     1.429    -0.666     0.200
     1.320     1.067     0.200
     1.324     0.662     0.200
     1.710    -2.190     0.200
     2.053    -2.780     0.200
     3.118    -9.934     0.200
     3.580   -11.071     0.200
     3.604   -10.256     0.200
     3.640    -9.562     0.200
     3.900    -8.421     0.200
     4.057   -13.961     0.200
     4.047    -9.940     0.200
     4.918   -17.436     0.200
     5.237   -19.995     0.200
     0.062     8.239     0.200
     0.057     8.279     0.200
     0.070     7.695     0.200
     0.087     7.550     0.200
     0.103     6.959     0.200
     0.308     2.857     0.200
     0.241     3.652     0.200
     0.301     2.625     0.200
     0.676     0.132     0.200
     1.178    -0.093     0.200
     1.139    -1.281     0.200
     1.197     1.962     0.200
     1.223     2.494     0.200
     1.413    -2.208     0.200
     1.539    -1.755     0.200
     1.956    -3.002     0.200
     2.726    -7.701     0.200
     0.130     4.343     0.200
     1.034    -0.351     0.200
     1.063     0.010     0.200
     1.222     0.452     0.200
     1.319    -0.615     0.200
     1.310     0.565     0.200
     1.318     0.623     0.200
     1.345     0.932     0.200
     1.363     0.786     0.200
     1.367     0.451     0.200
     1.765    -1.699     0.200
     2.757    -8.895     0.200
     3.461    -9.023     0.200
     3.563    -8.142     0.200
     3.550   -11.906     0.200
     3.624   -11.540     0.200
     4.592   -17.178     0.200
     0.787     0.781     0.200
     0.781     1.257     0.200
     1.357    -0.084     0.200
     1.670    -2.255     0.200
     1.802    -2.239     0.200
     1.825    -1.949     0.200
     1.866    -2.392     0.200
     1.877    -0.238     0.200
     2.209    -4.343     0.200
     3.022    -7.268     0.200
     3.103    -6.331     0.200
     3.166    -7.674     0.200
     3.335   -10.555     0.200
     3.386   -10.628     0.200
     3.481    -8.378     0.200
     3.525    -7.384     0.200
     3.555    -8.436     0.200
     3.704    -8.020     0.200
     4.108   -11.711     0.200
     0.015     6.189     0.200
     1.118    -1.380     0.200
     1.215     0.661     0.200
     1.224     1.103     0.200
     1.213    -0.093     0.200
     1.254     0.942     0.200
     1.270     0.950     0.200
     1.273     0.828     0.200
     1.645    -1.930     0.200
     2.542    -7.311     0.200
     2.980    -7.710     0.200
     0.078     4.964     0.200
     1.276     0.905     0.200
     1.285     0.740     0.200
     1.277    -0.993     0.200
     1.314    -0.191     0.200
     1.330     0.990     0.200
     1.442    -2.119     0.200
     1.334     0.895     0.200
     1.858    -1.189     0.200
     1.706    -0.732     0.200
     2.063    -4.143     0.200
     2.079    -2.625     0.200
     3.125    -7.150     0.200
     3.521   -10.020     0.200
     3.620    -9.908     0.200
     3.692   -12.507     0.200
     3.686   -11.038     0.200
     4.537   -15.655     0.200
     4.562   -16.365     0.200
     4.804   -17.264     0.200
     0.124     0.785     0.200
     0.306     0.130     0.200
     0.409     0.832     0.200
     0.458     0.593     0.200
     0.587     1.666     0.200
     0.636     2.465     0.200
     0.647     2.511     0.200
     0.651     2.563     0.200
     0.815     1.294     0.200
     0.874    -0.767     0.200
     1.236    -1.539     0.200
     1.776    -0.433     0.200
     2.106    -2.220     0.200
     2.605    -3.524     0.200
     2.646    -3.877     0.200
     3.412    -8.383     0.200
     4.012   -10.777     0.200
     4.151   -13.910     0.200
     4.166   -11.173     0.200
     0.055     4.532     0.200
     0.851    -0.078     0.200
     1.663    -0.599     0.200
     1.581    -0.743     0.200
     1.953    -4.169     0.200
     2.298    -2.162     0.200
     2.352    -2.422     0.200
     2.869    -5.849     0.200
     2.920    -8.372     0.200
     3.610    -9.925     0.200
     3.641   -12.390     0.200
     3.654   -10.504     0.200
     3.697   -10.358     0.200
     3.754    -8.564     0.200
     3.971   -13.321     0.200
     4.114   -13.361     0.200
     4.115   -14.090     0.200
     4.139   -12.536     0.200
     4.157   -14.981     0.200
     4.162   -14.763     0.200
     4.495   -16.189     0.200
     4.781   -18.164     0.200
     6.498   -20.841     0.200
     6.498   -19.122     0.200
     0.729     0.803     0.200
     0.814     1.089     0.200
     1.401    -1.422     0.200
     1.566    -0.472     0.200
     1.615    -3.677     0.200
     1.745    -3.247     0.200
     1.764    -1.647     0.200
     1.766    -0.006     0.200
     1.782    -1.322     0.200
     1.807    -3.191     0.200
     1.818    -0.314     0.200
     3.070    -6.753     0.200
     3.329    -6.350     0.200
     3.438    -9.486     0.200
     3.457   -11.850     0.200
     3.689   -12.117     0.200
     3.711   -12.270     0.200
     3.760   -13.368     0.200
     4.112   -13.198     0.200
     1.082     0.587     0.200
     1.227    -0.739     0.200
     1.238     2.011     0.200
     1.238     1.047     0.200
     1.276     1.612     0.200
     1.338    -1.038     0.200
     1.882    -3.991     0.200
     1.983    -5.239     0.200
     2.343    -4.615     0.200
     2.540    -7.200     0.200
     3.136    -8.893     0.200
     3.336   -10.384     0.200
     5.167   -19.958     0.200
     0.433     1.996     0.200
     0.671     2.079     0.200
     0.752     1.747     0.200
     0.806     2.213     0.200
     0.863     2.045     0.200
     0.865     2.298     0.200
     1.180    -0.935     0.200
     1.550    -0.630     0.200
     1.685    -1.928     0.200
     1.885    -4.001     0.200
     2.517    -8.360     0.200
     3.032    -9.286     0.200
     3.329    -8.488     0.200
     3.651   -11.561     0.200
     0.090     1.234     0.200
     0.534     1.742     0.200
     0.547     1.511     0.200
     0.726     2.131     0.200
     0.720     0.994     0.200
     0.747     2.456     0.200
     0.767     1.553     0.200
     0.782     2.099     0.200
     0.920     0.932     0.200
     1.091    -0.278     0.200
     1.975    -1.317     0.200
     2.033    -2.717     0.200
     4.811   -15.985     0.200
     4.965   -17.760     0.200
     0.487     0.684     0.200
     1.483    -1.587     0.200
     1.910    -2.920     0.200
     1.878    -3.026     0.200
     1.943    -0.977     0.200
     1.944    -0.911     0.200
     1.980    -0.407     0.200
     1.994    -1.261     0.200
     2.040    -3.060     0.200
     1.982    -2.575     0.200
     2.265    -3.761     0.200
     2.720    -6.708     0.200
     3.136    -6.235     0.200
     3.224    -8.135     0.200
     3.638   -10.457     0.200
     3.638    -9.697     0.200
     3.673    -9.731     0.200
     3.673    -9.540     0.200
     3.682   -10.821     0.200
     3.723   -11.570     0.200
     4.402   -16.700     0.200
     0.635     0.943     0.200
     1.246    -0.802     0.200
     1.788    -1.741     0.200
     1.998    -3.438     0.200
     2.971    -7.823     0.200
     3.993    -8.484     0.200
     4.170   -12.486     0.200
     1.126     0.118     0.200
     1.514    -1.902     0.200
     1.502     0.360     0.200
     1.532     0.867     0.200
     1.614    -1.374     0.200
     1.765    -0.891     0.200
     2.074    -3.765     0.200
     3.723   -11.370     0.200
     3.813   -10.724     0.200
     0.121     3.294     0.200
     0.791     0.600     0.200
     1.607    -1.097     0.200
     3.862   -13.386     0.200
     4.026   -13.347     0.200
     0.126     3.687     0.200
     0.829     0.676     0.200
     1.188    -0.083     0.200
     1.246    -0.007     0.200
     1.748    -3.049     0.200
     2.344    -3.160     0.200
     3.090    -8.305     0.200
     3.744   -13.795     0.200
     3.735   -13.023     0.200
     3.740   -13.099     0.200
     3.798   -12.134     0.200
     4.200   -15.637     0.200
     4.204   -14.602     0.200
     4.222   -14.129     0.200
     4.689   -15.913     0.200
     4.863   -14.692     0.200
     0.426     1.711     0.200
     0.659     1.616     0.200
     0.884     0.663     0.200
     1.014    -0.237     0.200
     1.065     0.641     0.200
     1.074     0.669     0.200
     2.034    -2.997     0.200
     3.475    -9.154     0.200
     3.995    -9.924     0.200
     4.438   -10.605     0.200
     4.541   -13.898     0.200
     4.635   -15.291     0.200
     4.659   -16.540     0.200
     4.659   -13.853     0.200
     4.681   -11.680     0.200
     4.832   -14.264     0.200
     4.895   -12.113     0.200
     5.220   -16.266     0.200
     6.064   -18.236     0.200
     6.272   -21.873     0.200
     1.922    -0.287     0.200
     1.957    -2.192     0.200
     2.023    -3.184     0.200
     2.794    -9.108     0.200
     2.828    -7.593     0.200
     3.049    -6.331     0.200
     3.092    -7.645     0.200
     3.162    -8.335     0.200
     3.217    -9.327     0.200
     3.241    -8.781     0.200
     3.368    -9.317     0.200
     3.409    -9.904     0.200
     3.550    -7.787     0.200
     3.609   -13.048     0.200
     3.754    -6.981     0.200
     4.712   -15.997     0.200
     4.879   -11.637     0.200
     1.015     0.043     0.200
     1.497     2.303     0.200
     2.133    -2.997     0.200
     2.250    -0.323     0.200
     4.347   -13.697     0.200
     0.515     2.233     0.200
     0.559     2.151     0.200
     0.569     2.384     0.200
     0.613     0.553     0.200
     0.645    -0.059     0.200
     0.733     1.297     0.200
     1.681    -2.476     0.200
     0.743     0.750     0.200
     1.386     0.306     0.200
     1.813    -1.807     0.200
     2.021    -0.496     0.200
     2.024    -3.714     0.200
     2.055    -0.182     0.200
     2.071    -1.658     0.200
     2.550    -6.034     0.200
     2.809    -8.867     0.200
     2.916    -8.671     0.200
     3.004    -9.635     0.200
     2.995    -8.518     0.200
     3.093    -9.744     0.200
     3.108   -10.548     0.200
     3.332   -11.298     0.200
     4.736   -17.794     0.200
     0.439     2.052     0.200
     1.113    -1.699     0.200
     1.207    -0.522     0.200
     1.219    -0.807     0.200
     1.249    -0.071     0.200
     1.233     1.155     0.200
     3.216   -10.089     0.200
     3.498   -10.325     0.200
     4.097   -12.315     0.200
     4.234   -15.149     0.200
     0.250     0.544     0.200
     1.435     1.005     0.200
     1.659    -0.602     0.200
     5.029   -14.786     0.200
     5.234   -17.095     0.200
     0.499     1.210     0.200
     1.137    -0.928     0.200
     1.827    -2.575     0.200
     1.906    -4.404     0.200
     1.871    -0.970     0.200
     1.872    -1.420     0.200
     1.907    -1.448     0.200
     1.922    -0.127     0.200
     1.974    -2.460     0.200
     1.914    -1.706     0.200
     2.753    -6.543     0.200
     2.716    -8.227     0.200
     3.209    -6.650     0.200
     0.260     2.391     0.200
     1.067     1.502     0.200
     1.214     0.955     0.200
     1.430    -0.642     0.200
     1.591    -0.824     0.200
     1.513    -2.444     0.200
     1.662    -1.279     0.200
     2.163    -2.970     0.200
     2.184    -3.572     0.200
     2.233    -1.809     0.200
     2.861    -9.003     0.200
     2.897    -8.916     0.200
     3.099   -10.255     0.200
     3.159    -9.713     0.200
     3.515   -11.130     0.200
     0.057     4.614     0.200
     1.625    -1.290     0.200
     1.962    -2.961     0.200
     2.272    -3.375     0.200
     2.401    -1.400     0.200
     2.865    -8.228     0.200
     3.019    -9.140     0.200
     3.071    -6.416     0.200
     3.220    -8.804     0.200
     4.083   -11.771     0.200
     4.527   -12.944     0.200
     0.052     4.406     0.200
     0.855    -0.230     0.200
     1.664    -1.655     0.200
     1.957    -2.576     0.200
     4.564   -14.425     0.200
     0.507     1.590     0.200
     1.393    -1.724     0.200
     1.411    -1.027     0.200
     1.515    -2.377     0.200
     1.617    -3.410     0.200
     1.549    -1.722     0.200
     1.621    -3.102     0.200
     1.615    -2.095     0.200
     2.573    -6.230     0.200
     2.834    -7.027     0.200
     2.980    -8.637     0.200
     3.047    -9.434     0.200
     3.324   -10.179     0.200
     3.524   -11.801     0.200
     3.716   -11.974     0.200
     3.729   -13.030     0.200
     0.256     0.821     0.200
     1.656     0.688     0.200
     1.451     0.502     0.200
     1.502     0.628     0.200
     1.638     0.374     0.200
     2.114    -1.470     0.200
     2.262    -1.373     0.200
     2.558    -2.160     0.200
     2.549    -3.543     0.200
     2.857    -3.675     0.200
     2.785    -2.748     0.200
     3.056    -4.490     0.200
     0.127     2.506     0.200
     1.885    -3.423     0.200
     2.837    -7.474     0.200
     3.134    -7.353     0.200
     3.750   -11.100     0.200
     0.122     4.141     0.200
     1.224    -0.150     0.200
     1.320    -0.474     0.200
     1.371     0.297     0.200
     1.412    -2.473     0.200
     1.748    -1.169     0.200
     1.823    -2.481     0.200
     2.120    -4.483     0.200
     3.072   -10.127     0.200
     3.494    -8.068     0.200
     3.588   -11.228     0.200
     3.598    -8.326     0.200
     3.651    -7.476     0.200
     0.580     1.857     0.200
     1.346    -1.320     0.200
     2.585    -5.833     0.200
     3.008    -6.944     0.200
     3.045    -8.758     0.200
     3.061    -8.006     0.200
     3.296    -9.813     0.200
     3.503   -12.640     0.200
     3.605   -11.237     0.200
     3.679   -12.645     0.200
     3.853   -11.094     0.200
     3.974   -13.347     0.200
     4.216   -13.564     0.200
     0.071     5.288     0.200
     1.145    -0.026     0.200
     1.237    -0.409     0.200
     1.305     0.430     0.200
     1.640    -1.283     0.200
     1.933    -3.459     0.200
     2.452    -5.452     0.200
     2.890    -7.205     0.200
     3.598    -8.979     0.200
     3.695    -8.321     0.200
     3.761    -7.233     0.200
     4.136    -9.139     0.200
     4.326    -8.854     0.200
     4.599   -13.174     0.200
     4.639   -12.491     0.200
     5.444   -17.862     0.200
     5.739   -17.930     0.200
     6.014   -19.149     0.200
     6.449   -22.165     0.200
     0.277     4.630     0.200
     0.874     0.938     0.200
     0.977     0.127     0.200
     0.999    -0.021     0.200
     1.527    -2.493     0.200
     1.893    -3.769     0.200
     2.296    -4.402     0.200
     2.334    -3.784     0.200
     3.972    -9.551     0.200
     0.245     0.607     0.200
     1.370     0.101     0.200
     1.454     0.621     0.200
     2.291    -1.713     0.200
     2.459    -3.556     0.200
     2.539    -0.684     0.200
     2.568    -2.806     0.200
     3.139    -8.049     0.200
     3.121    -5.751     0.200
     3.263    -6.961     0.200
     3.536    -9.107     0.200
     0.188     2.641     0.200
     1.329     0.669     0.200
     1.470    -1.043     0.200
     1.552    -1.464     0.200
     2.662    -6.440     0.200
     2.947    -8.726     0.200
     3.090    -6.232     0.200
     3.104    -9.355     0.200
     0.690     0.503     0.200
     1.731    -0.162     0.200
     1.751    -3.931     0.200
     2.901    -9.745     0.200
     3.543   -12.740     0.200
     1.291    -1.819     0.200
     1.539    -0.107     0.200
     1.437     2.023     0.200
     1.655    -3.256     0.200
     1.889    -2.989     0.200
     2.387    -5.863     0.200
     2.644    -6.443     0.200
     2.989    -8.851     0.200
     2.974    -9.551     0.200
     3.076    -8.748     0.200
     3.475   -10.754     0.200
     1.100     0.098     0.200
     1.123     0.540     0.200
     2.655    -7.411     0.200
     2.881    -9.706     0.200
     3.033    -9.636     0.200
     3.450   -12.054     0.200
     3.455   -10.717     0.200
     3.514    -7.830     0.200
     3.627   -13.237     0.200
     3.583   -11.380     0.200
     3.656   -12.677     0.200
     0.195     0.846     0.200
     1.541     0.912     0.200
     1.502     0.980     0.200
     2.338    -3.685     0.200
     2.835    -3.426     0.200
     3.279    -7.132     0.200
     0.183     1.239     0.200
     1.528     0.270     0.200
     1.501     1.485     0.200
     1.968    -1.810     0.200
     2.336    -1.343     0.200
     2.620    -2.267     0.200
     0.969     0.594     0.200
     1.650    -0.662     0.200
     1.611    -1.066     0.200
     1.739    -2.517     0.200
     2.427    -5.160     0.200
     2.659    -6.642     0.200
     2.927    -7.909     0.200
     2.976    -8.426     0.200
     3.114   -10.544     0.200
     3.083    -6.284     0.200
     3.112    -9.798     0.200
     3.243   -10.042     0.200
     3.304   -11.316     0.200
     0.306     1.923     0.200
     0.306     1.033     0.200
     1.389    -0.916     0.200
     1.488    -1.691     0.200
     1.525    -0.047     0.200
     1.671    -2.473     0.200
     1.939    -1.945     0.200
     2.382    -3.256     0.200
     2.905    -6.696     0.200
     3.249   -10.186     0.200
     3.334    -8.925     0.200
     3.470   -10.062     0.200
     3.745   -13.256     0.200
     3.926    -8.476     0.200
     4.060   -11.360     0.200
     4.360   -15.485     0.200
     4.369   -11.111     0.200
     0.699     0.047     0.200
     1.186     0.018     0.200
     1.071     1.121     0.200
     1.586    -0.198     0.200
     1.618    -0.800     0.200
     1.672    -1.094     0.200
     1.698    -2.780     0.200
     1.956    -3.760     0.200
     2.731    -5.479     0.200
     3.048    -9.097     0.200
     0.854     0.037     0.200
     1.678    -2.350     0.200
     1.785    -2.041     0.200
     1.949    -1.361     0.200
     2.033    -2.594     0.200
     0.871     0.693     0.200
     1.120    -1.462     0.200
     1.979    -1.713     0.200
     2.692    -8.018     0.200
     2.784    -7.422     0.200
     2.802    -5.772     0.200
     2.871    -8.112     0.200
     2.873    -7.361     0.200
     3.113    -8.992     0.200
     3.247    -8.590     0.200
     3.414   -10.637     0.200
     3.440   -11.957     0.200
     3.656   -10.256     0.200
     3.673   -13.453     0.200
     0.131     3.466     0.200
     1.204     0.322     0.200
     1.303    -1.293     0.200
     1.345     0.438     0.200
     1.609    -0.430     0.200
     1.784    -1.980     0.200
     2.357    -4.149     0.200
     2.383    -1.194     0.200
     2.645    -6.676     0.200
     3.065    -9.223     0.200
     3.518    -8.781     0.200
     3.544    -8.264     0.200
     3.609   -12.332     0.200
     3.837   -12.260     0.200
     3.803    -8.203     0.200
     3.985   -14.573     0.200
     3.992   -10.596     0.200
     4.068   -10.269     0.200
     4.231   -11.430     0.200
     4.436   -16.235     0.200
     0.053     3.956     0.200
     1.585    -2.178     0.200
     1.673    -2.107     0.200
     1.957    -3.892     0.200
     2.486    -6.073     0.200
     2.448    -5.819     0.200
     2.929    -9.282     0.200
     0.086     4.156     0.200
     1.136    -1.130     0.200
     1.587    -1.452     0.200
     1.834    -2.983     0.200
     2.346    -4.328     0.200
     2.346    -2.434     0.200
     3.565   -12.191     0.200
     3.995   -13.129     0.200
     3.997    -8.020     0.200
     3.997   -12.547     0.200
     4.001   -14.708     0.200
     4.013   -14.476     0.200
     4.042   -13.080     0.200
     4.227   -11.936     0.200
     4.458   -14.600     0.200
     4.459   -14.616     0.200
     4.503   -13.826     0.200
     4.503    -8.365     0.200
     4.521   -12.384     0.200
     4.527   -15.578     0.200
     4.880   -18.452     0.200
     0.503     1.185     0.200
     0.751     0.758     0.200
     0.884     1.992     0.200
     0.945     1.031     0.200
     0.945     0.031     0.200
     1.172    -0.030     0.200
     2.159    -2.381     0.200
     2.416    -2.926     0.200
     2.675    -0.626     0.200
     3.330    -9.668     0.200
     4.471   -14.713     0.200
     4.511   -15.548     0.200
     4.513    -9.752     0.200
     4.526   -11.439     0.200
     4.535   -11.458     0.200
     4.544    -7.765     0.200
     5.111   -17.226     0.200
     0.192     2.846     0.200
     1.282    -1.327     0.200
     1.380    -2.258     0.200
     1.657    -2.203     0.200
     2.198    -3.202     0.200
     0.243     1.912     0.200
     1.324    -0.438     0.200
     1.423    -1.449     0.200
     1.645    -1.103     0.200
     1.879    -1.696     0.200
     0.090     4.056     0.200
     1.180    -0.282     0.200
     1.560    -1.309     0.200
     1.869    -3.399     0.200
     2.524    -7.484     0.200
     3.017   -10.037     0.200
     0.200     3.068     0.200
     1.364    -1.305     0.200
     1.717    -2.897     0.200
     2.677    -6.021     0.200
     3.123    -6.821     0.200
     3.483    -9.508     0.200
     3.476   -12.127     0.200
     3.510    -9.880     0.200
     3.926   -14.424     0.200
     3.926   -13.764     0.200
     3.932   -11.968     0.200
     3.936    -8.753     0.200
     3.936    -8.093     0.200
     3.961   -10.882     0.200
     3.967    -9.088     0.200
     3.985    -9.661     0.200
     4.058   -11.967     0.200
     4.080   -11.994     0.200
     4.123   -12.032     0.200
     4.253   -13.511     0.200
     4.253   -12.181     0.200
     4.421   -15.892     0.200
     4.428   -13.437     0.200
     5.225   -18.004     0.200
     6.137   -21.714     0.200
     6.151   -17.860     0.200
     6.126   -13.714     0.200
     6.230   -19.997     0.200
     7.166   -25.411     0.200
     7.126   -20.222     0.200
     7.509   -16.268     0.200
     0.838     0.988     0.200
     0.987     0.431     0.200
     1.066    -0.006     0.200
     1.834    -2.393     0.200
     2.196    -3.024     0.200
     2.629    -6.733     0.200
     4.768   -11.331     0.200
     1.316    -0.259     0.200
     1.416    -0.756     0.200
     1.605     0.322     0.200
     1.889    -3.297     0.200
     2.329    -3.177     0.200
     2.763    -7.531     0.200
     3.091    -6.576     0.200
     4.742   -16.788     0.200
     1.129    -1.396     0.200
     1.501    -2.599     0.200
     2.087    -3.304     0.200
     3.224   -10.307     0.200
     1.162     0.356     0.200
     1.263    -1.519     0.200
     1.563    -1.495     0.200
     1.746    -1.935     0.200
     3.032    -9.490     0.200
     4.505   -17.065     0.200
     1.755    -1.260     0.200
     1.621    -1.252     0.200
     1.797    -1.853     0.200
     3.061    -7.886     0.200
     3.558    -6.453     0.200
     3.852    -8.470     0.200
     3.980    -7.870     0.200
     3.992    -9.575     0.200
     4.439   -14.440     0.200
     4.445   -15.310     0.200
     4.451   -13.498     0.200
     1.348    -0.164     0.200
     1.450    -0.873     0.200
     1.609    -0.751     0.200
     2.325    -4.088     0.200
     2.797    -6.659     0.200
     2.902    -7.835     0.200
     3.098    -7.550     0.200
     3.206    -9.135     0.200
     3.435    -9.686     0.200
     3.513   -10.817     0.200
     3.879    -9.052     0.200
     3.887   -11.363     0.200
     3.896    -7.334     0.200
     3.898   -11.180     0.200
     3.890   -11.186     0.200
     3.906    -9.986     0.200
     3.924   -13.229     0.200
     3.982   -11.737     0.200
     4.328   -12.381     0.200
     4.759   -16.104     0.200
     6.136   -21.310     0.200
     1.152     0.089     0.200
     1.513    -1.287     0.200
     1.608    -0.674     0.200
     2.297    -3.902     0.200
     2.231    -3.453     0.200
     2.554    -3.749     0.200
     3.161    -8.202     0.200
     3.360    -7.638     0.200
     3.355    -6.397     0.200
     3.439    -9.049     0.200
     3.806    -9.754     0.200
     3.820    -9.459     0.200
     3.840   -10.834     0.200
     3.846   -10.684     0.200
     3.855    -8.282     0.200
     3.938   -12.969     0.200
     4.226   -12.760     0.200
     4.245   -12.702     0.200
     4.252   -14.231     0.200
     4.255   -13.678     0.200
     4.259   -11.799     0.200
     4.265   -11.569     0.200
     4.314   -11.821     0.200
     0.977     1.823     0.200
     1.496     0.531     0.200
     1.752    -0.855     0.200
     1.772    -2.432     0.200
     2.122    -2.515     0.200
     2.593    -2.558     0.200
     2.992    -7.096     0.200
     3.479    -8.266     0.200
     4.326   -12.104     0.200
     4.358   -13.104     0.200
     0.782     0.968     0.200
     0.927     0.763     0.200
     1.001     1.181     0.200
     1.298    -3.166     0.200
     1.670    -0.586     0.200
     2.279    -1.444     0.200
     2.259    -3.658     0.200
     2.663    -4.732     0.200
     3.200    -8.823     0.200
     3.251    -9.529     0.200
     4.396   -14.385     0.200
     4.484   -15.866     0.200
     4.484    -8.069     0.200
     4.969   -12.485     0.200
     0.095     4.674     0.200
     1.192     0.097     0.200
     1.288    -1.127     0.200
     1.651    -2.218     0.200
     1.730    -1.727     0.200
     2.403    -6.434     0.200
     4.029   -14.610     0.200
     4.783   -18.570     0.200
     0.046     5.340     0.200
     1.240    -0.886     0.200
     1.682    -3.143     0.200
     1.643    -2.336     0.200
     2.574    -6.630     0.200
     0.322     1.960     0.200
     0.624     1.118     0.200
     0.876     0.203     0.200
     1.365    -2.181     0.200
     1.571    -0.638     0.200
     2.213    -3.955     0.200
     2.992    -8.956     0.200
     3.423    -9.051     0.200
     3.782   -12.342     0.200
     4.194   -14.649     0.200
     4.624   -14.781     0.200
     0.356     3.094     0.200
     0.596     0.957     0.200
     1.492    -1.511     0.200
     1.758    -3.255     0.200
     2.123    -2.879     0.200
     2.205    -2.997     0.200
     2.302    -2.010     0.200
     2.882    -6.880     0.200
     3.725    -9.759     0.200
     4.738   -15.064     0.200
     5.553   -20.338     0.200
     0.140     4.161     0.200
     1.610    -1.077     0.200
     2.391    -6.042     0.200
     3.041    -9.476     0.200
     3.634   -12.552     0.200
     3.708   -11.122     0.200
     3.663   -11.469     0.200
     3.733   -12.979     0.200
     4.106    -9.371     0.200
     4.533   -16.436     0.200
     4.533   -16.451     0.200
     4.566   -16.856     0.200
     4.569   -16.909     0.200
     4.571   -16.122     0.200
     4.717   -15.645     0.200
     0.101     5.371     0.200
     1.021     0.008     0.200
     1.278    -0.610     0.200
     1.814    -2.782     0.200
     1.736    -3.933     0.200
     2.108    -2.584     0.200
     0.503     2.009     0.200
     0.941     0.773     0.200
     1.100     0.080     0.200
     1.202    -0.166     0.200
     1.502     0.571     0.200
     1.811    -1.817     0.200
     4.429   -14.544     0.200
     0.228     3.784     0.200
     1.051     0.087     0.200
     1.210     0.544     0.200
     1.313    -1.077     0.200
     1.497    -1.657     0.200
     1.828    -3.365     0.200
     2.198    -3.277     0.200
     2.237    -4.596     0.200
     2.668    -8.361     0.200
     3.063    -5.921     0.200
     3.334    -9.219     0.200
     3.424   -11.336     0.200
     3.397    -9.165     0.200
     3.422    -9.945     0.200
     3.525    -8.741     0.200
     3.490   -11.457     0.200
     3.775   -12.505     0.200
     3.731    -9.382     0.200
     3.844    -8.701     0.200
     3.861   -10.262     0.200
     3.864   -12.109     0.200
     3.901   -10.518     0.200
     4.092   -14.916     0.200
     4.046   -12.471     0.200
     4.128   -10.417     0.200
     4.181   -12.085     0.200
     4.280   -15.004     0.200
     4.301   -14.789     0.200
     4.306   -15.653     0.200
     4.309   -16.279     0.200
     4.380   -16.074     0.200
     4.338   -15.865     0.200
     4.493   -16.758     0.200
     4.742   -16.903     0.200
     0.239     4.204     0.200
     1.137     0.425     0.200
     1.397    -0.436     0.200
     1.427     0.518     0.200
     1.594    -2.424     0.200
     2.744    -8.762     0.200
     3.154   -10.509     0.200
     4.349   -15.337     0.200
     0.470     0.443     0.200
     1.023     0.796     0.200
     1.172     1.678     0.200
     1.641     2.306     0.200
     2.313     0.160     0.200
     2.368    -0.971     0.200
     2.390    -1.920     0.200
     1.503    -1.131     0.200
     1.949    -1.817     0.200
     3.211    -8.851     0.200
     3.536    -9.754     0.200
     3.604   -10.252     0.200
     3.758   -10.745     0.200
     4.031   -14.204     0.200
     4.421   -14.968     0.200
     4.617   -17.557     0.200
     0.427     1.084     0.200
     1.682     1.057     0.200
     1.429     0.856     0.200
     2.126    -1.246     0.200
     2.385    -2.108     0.200
     2.379    -3.812     0.200
     0.190     2.646     0.200
     1.014    -0.030     0.200
     1.275    -0.363     0.200
     1.299    -0.203     0.200
     1.507     0.322     0.200
     2.629    -7.678     0.200
     4.524   -16.770     0.200
     0.243     3.730     0.200
     1.106    -0.417     0.200
     1.264     0.466     0.200
     1.367    -0.727     0.200
     1.390     0.679     0.200
     1.672    -2.093     0.200
     1.539    -2.314     0.200
     2.236    -3.093     0.200
     2.270    -3.134     0.200
     3.879   -10.396     0.200
     3.789   -13.881     0.200
     0.450     0.679     0.200
     1.036     2.552     0.200
     1.152     0.612     0.200
     1.180     0.876     0.200
     1.260     0.747     0.200
     1.650     0.394     0.200
     2.336    -3.010     0.200
     2.369    -2.135     0.200
     3.375    -5.542     0.200
     0.483    -0.283     0.200
     1.010     3.139     0.200
     1.137     0.991     0.200
     1.160     1.985     0.200
     1.238     1.616     0.200
     2.343    -1.835     0.200
     2.301     1.177     0.200
     2.736     0.083     0.200
     3.178    -2.577     0.200
     0.372     1.752     0.200
     1.099     2.145     0.200
     1.184     0.907     0.200
     1.313     0.725     0.200
     1.420     0.349     0.200
     2.062    -1.721     0.200
     2.318    -3.233     0.200
     2.430    -2.495     0.200
     2.430    -0.769     0.200
     3.341    -9.484     0.200
     3.497    -6.154     0.200
     3.648    -9.774     0.200
     4.738   -12.727     0.200
     0.438     0.339     0.200
     1.129     1.767     0.200
     1.245     2.626     0.200
     1.251     1.963     0.200
     2.360    -0.534     0.200
     2.366    -1.839     0.200
     2.438    -2.709     0.200
     2.556    -2.618     0.200
     2.704    -2.681     0.200
     3.164    -4.208     0.200
     3.339    -5.116     0.200
     3.366    -5.524     0.200
     3.385    -6.659     0.200
     3.670    -7.516     0.200
     3.694    -8.921     0.200
     4.454   -13.299     0.200
     5.038   -15.588     0.200
     0.075     6.289     0.200
     0.977     0.334     0.200
     1.136     0.266     0.200
     1.235    -0.279     0.200
     1.599    -2.347     0.200
     2.575    -5.845     0.200
     2.998   -10.302     0.200
     4.728   -15.777     0.200
     0.395     2.402     0.200
     1.293     0.079     0.200
     1.679    -0.225     0.200
     3.358   -10.301     0.200
     0.426    -0.007     0.200
     1.173     0.822     0.200
     1.211     0.387     0.200
     1.637     1.369     0.200
     2.359     0.855     0.200
     2.392    -2.247     0.200
     2.415    -2.605     0.200
     0.166     3.217     0.200
     1.205    -0.013     0.200
     2.558    -7.547     0.200
     3.421   -10.866     0.200
     3.500   -11.653     0.200
     3.669   -10.762     0.200
     3.936   -13.979     0.200
     3.943   -11.102     0.200
     0.890    -1.048     0.200
     1.330    -0.207     0.200
     1.742    -2.680     0.200
     1.821    -0.638     0.200
     1.997    -4.336     0.200
     2.507    -5.657     0.200
     2.698    -8.077     0.200
     3.158    -7.554     0.200
     3.547    -9.799     0.200
     3.641    -7.099     0.200
     3.746   -11.198     0.200
     3.856    -7.129     0.200
     1.836    -4.130     0.200
     2.514    -5.969     0.200
     2.930    -8.748     0.200
     3.455    -6.495     0.200
     3.559   -12.456     0.200
     3.629    -9.951     0.200
     3.725   -11.720     0.200
     3.831   -13.746     0.200
     3.891   -11.686     0.200
     3.911   -10.998     0.200
     3.923   -14.592     0.200
     3.947    -8.790     0.200
     3.947    -7.458     0.200
     3.962   -12.598     0.200
     3.965   -11.776     0.200
     4.050   -13.395     0.200
     4.107   -15.190     0.200
     4.150   -13.238     0.200
     4.185   -12.347     0.200
     4.248   -15.689     0.200
     4.387   -16.303     0.200
     4.403   -13.962     0.200
     4.598   -14.701     0.200
     0.474     1.556     0.200
     1.106     1.409     0.200
     1.139     1.836     0.200
     1.221     0.968     0.200
     1.415    -0.058     0.200
     1.705     0.194     0.200
     2.158    -2.212     0.200
     2.334    -2.553     0.200
     2.395    -1.203     0.200
     2.430    -3.608     0.200
     0.055     7.833     0.200
     0.919     0.595     0.200
     1.176    -0.222     0.200
     1.897    -2.557     0.200
     2.012    -2.062     0.200
     2.814    -8.736     0.200
     3.531   -11.125     0.200
     3.567    -8.078     0.200
     3.575   -11.669     0.200
     3.615   -11.549     0.200
     3.946   -10.780     0.200
     4.009   -13.444     0.200
     4.057   -14.419     0.200
     0.374    -0.097     0.200
     1.488     0.824     0.200
     2.124    -2.647     0.200
     2.347    -3.635     0.200
     2.468    -3.349     0.200
     2.476    -2.477     0.200
     2.411    -1.590     0.200
     2.466    -3.070     0.200
     2.441    -3.676     0.200
     2.633    -2.225     0.200
     2.854    -3.581     0.200
     2.910    -1.955     0.200
     3.269    -6.284     0.200
     3.299    -7.110     0.200
     4.203   -10.649     0.200
     0.394    -0.436     0.200
     1.150    -0.514     0.200
     1.247     1.748     0.200
     2.392    -3.304     0.200
     2.424    -0.253     0.200
     2.451    -2.982     0.200
     2.632    -3.262     0.200
     3.464    -8.054     0.200
     3.646    -9.337     0.200
     3.693    -9.732     0.200
     1.734    -2.246     0.200
     1.876    -2.696     0.200
     1.988    -3.090     0.200
     2.501    -6.406     0.200
     2.989    -6.936     0.200
     3.102    -8.987     0.200
     3.628   -12.766     0.200
     0.290     4.526     0.200
     0.758     1.486     0.200
     0.915     1.427     0.200
     1.021     0.415     0.200
     1.027     1.360     0.200
     1.956    -2.959     0.200
     2.382    -3.947     0.200
     2.766    -6.329     0.200
     3.560   -13.048     0.200
     3.486   -10.734     0.200
     4.236   -12.552     0.200
     0.346     0.751     0.200
     1.094     1.658     0.200
     1.094    -0.350     0.200
     1.150     1.802     0.200
     1.403    -0.382     0.200
     2.336    -3.325     0.200
     2.507    -3.250     0.200
     2.983    -8.059     0.200
     3.228    -9.392     0.200
     0.364     0.861     0.200
     1.120     1.058     0.200
     1.120    -0.060     0.200
     1.376    -0.724     0.200
     1.540    -0.990     0.200
     2.423    -3.351     0.200
     2.481    -3.650     0.200
     3.024    -8.054     0.200
     3.302    -9.524     0.200
     3.634   -11.472     0.200
     0.362     0.981     0.200
     1.116     1.076     0.200
     1.277     0.787     0.200
     1.303     0.256     0.200
     1.535     0.339     0.200
     2.351    -3.136     0.200
     2.427    -3.223     0.200
     2.485    -2.214     0.200
     2.873    -2.573     0.200
     3.593    -9.323     0.200
     3.665    -9.577     0.200
     0.358     0.801     0.200
     1.528     0.463     0.200
     1.581    -0.640     0.200
     2.174    -3.407     0.200
     2.821    -7.422     0.200
     3.156    -9.283     0.200
     3.250    -8.606     0.200
     0.721     0.790     0.200
     1.245    -0.588     0.200
     1.385    -1.386     0.200
     1.385    -0.288     0.200
     1.412    -0.152     0.200
     1.496    -2.485     0.200
     1.756    -2.226     0.200
     2.521    -5.821     0.200
     2.892    -6.245     0.200
     2.852    -7.374     0.200
     2.951    -9.102     0.200
     3.140    -8.388     0.200
     3.835   -12.422     0.200
     0.414     0.341     0.200
     1.041     2.572     0.200
     1.207     0.098     0.200
     1.173     1.432     0.200
     1.205     1.499     0.200
     1.286     1.562     0.200
     1.462     0.057     0.200
     1.650     0.120     0.200
     2.373    -2.041     0.200
     2.398    -3.311     0.200
     2.434    -0.735     0.200
     1.437    -0.084     0.200
     1.501    -1.596     0.200
     1.722    -0.991     0.200
     1.762    -2.451     0.200
     2.854    -8.896     0.200
     2.975   -10.220     0.200
     3.128    -9.763     0.200
     3.468   -11.681     0.200
     0.477     0.646     0.200
     0.972     2.319     0.200
     1.099     1.723     0.200
     1.133     1.794     0.200
     1.215     1.131     0.200
     1.279     0.064     0.200
     1.403     0.126     0.200
     2.319    -1.821     0.200
     2.329    -3.050     0.200
     2.470    -2.012     0.200
     3.260    -5.504     0.200
     3.374    -6.503     0.200
     4.259   -10.680     0.200
     4.495   -14.011     0.200
     0.179     3.088     0.200
     1.115    -0.265     0.200
     1.273    -1.234     0.200
     1.365    -1.220     0.200
     1.431    -1.048     0.200
     1.857    -2.385     0.200
     2.681    -5.798     0.200
     3.118    -9.459     0.200
     3.133    -6.400     0.200
     3.246   -10.666     0.200
     3.548    -8.877     0.200
     3.661   -12.852     0.200
     4.130   -13.679     0.200
     4.909   -17.552     0.200
     0.199     1.345     0.200
     1.065    -0.687     0.200
     1.452     1.670     0.200
     1.816    -2.761     0.200
     2.071    -3.380     0.200
     2.219    -3.282     0.200
     3.418   -10.357     0.200
     0.170     3.091     0.200
     0.268     2.389     0.200
     1.440    -0.987     0.200
     1.777    -0.572     0.200
     0.135     2.574     0.200
     0.926     0.689     0.200
     1.517     0.151     0.200
     3.549    -9.863     0.200
     0.465     0.778     0.200
     0.983     1.965     0.200
     1.107     1.358     0.200
     2.063    -0.367     0.200
     2.477    -1.666     0.200
     2.411    -2.654     0.200
     4.257   -10.681     0.200
     0.658     0.534     0.200
     0.793     1.219     0.200
     1.035     0.406     0.200
     1.011     0.803     0.200
     1.812    -1.592     0.200
     2.382    -3.794     0.200
     3.277    -8.853     0.200
     3.288    -5.450     0.200
     3.519    -8.446     0.200
     3.667    -9.595     0.200
     4.058   -12.043     0.200
     4.089   -12.523     0.200
     4.089   -12.773     0.200
     0.473     1.066     0.200
     1.138     0.810     0.200
     1.653    -0.017     0.200
     2.401    -3.833     0.200
     3.311    -5.577     0.200
     1.261    -1.387     0.200
     1.411    -1.753     0.200
     1.499    -0.579     0.200
     1.523    -1.615     0.200
     2.094    -1.621     0.200
     2.370    -3.830     0.200
     2.887    -9.044     0.200
     0.782     0.254     0.200
     1.367     0.384     0.200
     1.723    -1.821     0.200
     1.848    -1.684     0.200
     1.810    -1.353     0.200
     2.876    -6.575     0.200
     3.030    -8.033     0.200
     3.619    -9.372     0.200
     3.736   -12.404     0.200
     0.323     1.341     0.200
     1.484     2.111     0.200
     1.854     0.885     0.200
     2.473    -1.814     0.200
     2.731    -3.532     0.200
     3.154    -6.594     0.200
     3.226    -7.333     0.200
     3.947    -9.206     0.200
     4.206    -6.760     0.200
     4.330    -7.011     0.200
     4.397    -8.748     0.200
     4.403    -9.842     0.200
     4.441    -7.408     0.200
     4.722    -7.624     0.200
     0.880     0.492     0.200
     1.137     1.848     0.200
     1.249    -0.428     0.200
     1.540    -1.126     0.200
     1.647    -0.159     0.200
     1.674    -0.227     0.200
     1.689    -0.399     0.200
     1.721    -0.641     0.200
     1.796    -1.833     0.200
     1.822    -2.608     0.200
     1.973    -4.788     0.200
     1.921    -2.183     0.200
     2.875    -8.677     0.200
     2.889    -8.384     0.200
     3.074   -10.667     0.200
     3.156   -11.076     0.200
     3.687    -9.685     0.200
     3.886   -12.494     0.200
     4.130   -11.887     0.200
     4.315   -14.333     0.200
     0.205     3.044     0.200
     1.126     0.616     0.200
     1.384    -0.481     0.200
     1.372     0.438     0.200
     1.409     0.972     0.200
     1.418     0.880     0.200
     1.441    -0.461     0.200
     1.460     0.171     0.200
     1.579    -0.504     0.200
     1.635    -1.052     0.200
     1.712    -1.832     0.200
     1.842    -2.678     0.200
     2.213    -3.298     0.200
     2.367    -4.257     0.200
     2.694    -6.141     0.200
     2.726    -5.900     0.200
     3.146    -6.566     0.200
     3.501   -12.391     0.200
     3.538   -11.401     0.200
     3.607   -12.197     0.200
     3.663    -6.893     0.200
     3.893   -12.668     0.200
     3.965   -13.009     0.200
     4.049   -14.567     0.200
     4.455   -14.381     0.200
     0.190     3.832     0.200
     1.127     0.167     0.200
     1.361     0.716     0.200
     1.384    -0.266     0.200
     1.381     1.140     0.200
     1.419     1.230     0.200
     1.468     0.344     0.200
     1.480    -1.161     0.200
     1.676    -1.835     0.200
     1.725    -1.625     0.200
     1.821    -1.382     0.200
     1.851    -2.116     0.200
     1.852    -2.641     0.200
     2.719    -8.379     0.200
     3.148   -10.107     0.200
     3.961    -9.795     0.200
     1.460     0.236     0.200
     0.330     2.620     0.200
     0.333    -0.688     0.200
     0.399    -0.352     0.200
     1.037     0.740     0.200
     1.098     1.042     0.200
     1.121     0.803     0.200
     1.140     1.782     0.200
     1.147     2.118     0.200
     1.110     1.533     0.200
     1.206     0.586     0.200
     1.308     0.260     0.200
     2.285    -2.779     0.200
     2.493    -0.034     0.200
     2.602    -1.401     0.200
     0.485     0.792     0.200
     0.857     0.846     0.200
     0.957     0.758     0.200
     0.954     2.435     0.200
     0.986     0.639     0.200
     1.011     0.784     0.200
     1.059     1.062     0.200
     1.113     0.474     0.200
     1.099     1.338     0.200
     1.164     0.938     0.200
     1.453     0.362     0.200
     1.768    -2.594     0.200
     1.944    -0.302     0.200
     2.476    -2.787     0.200
     2.622    -4.614     0.200
     2.964    -8.327     0.200
     3.224    -7.105     0.200
     3.277    -9.827     0.200
     3.363    -8.815     0.200
     3.473    -8.774     0.200
     3.487    -8.277     0.200
     3.597    -7.019     0.200
     3.722    -9.658     0.200
     3.753   -10.665     0.200
     3.778   -11.188     0.200
     3.785   -11.978     0.200
     3.857    -8.121     0.200
     4.152   -13.470     0.200
     4.130    -9.443     0.200
     4.289   -12.931     0.200
     1.096     1.412     0.200
     0.168     3.682     0.200
     1.089     0.255     0.200
     1.223    -0.130     0.200
     1.347    -0.665     0.200
     1.338     0.409     0.200
     1.375    -1.464     0.200
     1.383    -0.005     0.200
     1.425    -0.135     0.200
     1.431    -0.413     0.200
     1.628    -0.885     0.200
     1.679    -2.362     0.200
     1.754    -2.018     0.200
     1.804    -2.000     0.200
     1.808    -1.666     0.200
     1.803    -0.617     0.200
     2.688    -8.841     0.200
     2.717    -7.703     0.200
     3.118    -7.014     0.200
     3.420   -12.058     0.200
     1.418    -0.164     0.200
     0.227     0.577     0.200
     0.969     1.372     0.200
     1.094     1.948     0.200
     1.231     0.399     0.200
     1.442     1.953     0.200
     1.516     1.412     0.200
     1.750    -1.322     0.200
     1.768    -1.871     0.200
     1.612     1.570     0.200
     2.137    -3.412     0.200
     2.197    -2.703     0.200
     2.349    -1.444     0.200
     2.589    -2.648     0.200
     2.637    -3.868     0.200
     0.751     1.097     0.200
     0.753     0.988     0.200
     0.884     0.775     0.200
     0.947     0.008     0.200
     2.540    -3.163     0.200
     0.070     2.410     0.200
     0.195     0.773     0.200
     0.304     2.914     0.200
     0.328     3.009     0.200
     0.361     2.365     0.200
     0.672     1.410     0.200
     0.935     0.152     0.200
     1.362    -1.617     0.200
     1.592    -1.484     0.200
     0.288     0.433     0.200
     0.862     1.390     0.200
     0.909     2.951     0.200
     0.931     0.979     0.200
     0.940     1.920     0.200
     0.966     3.854     0.200
     0.980     1.857     0.200
     1.061     1.543     0.200
     1.090     1.882     0.200
     1.112     0.576     0.200
     1.125     2.261     0.200
     1.208     2.292     0.200
     1.392     0.631     0.200
     2.046    -0.403     0.200
     2.146    -2.026     0.200
     2.317    -0.631     0.200
     2.323    -1.124     0.200
     2.883    -2.811     0.200
     0.992     2.930     0.200
     0.251     2.256     0.200
     1.169     0.475     0.200
     1.177    -0.716     0.200
     1.322     1.111     0.200
     1.258    -0.923     0.200
     1.368    -1.763     0.200
     1.362     2.213     0.200
     1.403     0.192     0.200
     1.683    -2.101     0.200
     1.580    -2.378     0.200
     1.691    -1.845     0.200
     2.053    -3.160     0.200
     2.532    -7.647     0.200
     3.874   -12.978     0.200
     3.948   -13.648     0.200
     3.933   -11.633     0.200
     4.436   -16.514     0.200
     4.564   -15.197     0.200
     1.392     0.174     0.200
     0.242     1.264     0.200
     0.423     0.273     0.200
     0.454     1.030     0.200
     0.971     3.886     0.200
     0.984     1.237     0.200
     1.028     3.019     0.200
     1.041     2.369     0.200
     1.124     1.744     0.200
     1.163    -0.099     0.200
     1.224     0.777     0.200
     1.153     1.471     0.200
     1.170     0.402     0.200
     1.371     0.685     0.200
     1.425     0.221     0.200
     2.108    -1.333     0.200
     2.382    -3.384     0.200
     2.385    -1.881     0.200
     3.055    -4.417     0.200
     3.257    -2.780     0.200
     3.669    -6.477     0.200
     0.877     0.311     0.200
     1.437     0.932     0.200
     1.691    -1.289     0.200
     1.757    -2.259     0.200
     1.864    -1.980     0.200
     1.873    -1.997     0.200
     1.909    -2.985     0.200
     1.946    -1.901     0.200
     2.007    -3.634     0.200
     2.080    -2.072     0.200
     2.253    -2.940     0.200
     2.526    -6.244     0.200
     2.655    -7.443     0.200
     2.789    -5.907     0.200
     2.739    -7.639     0.200
     3.191    -9.966     0.200
     3.357   -10.524     0.200
     0.097     4.921     0.200
     0.042     7.449     0.200
     0.074     6.510     0.200
     0.214     4.168     0.200
     0.206     4.747     0.200
     0.197     4.281     0.200
     0.238     3.843     0.200
     0.260     4.412     0.200
     0.369     1.315     0.200
     0.452     2.325     0.200
     0.593     0.601     0.200
     1.142    -1.195     0.200
     1.447    -1.848     0.200
     1.366    -0.185     0.200
     1.590    -1.142     0.200
     1.945    -4.962     0.200
     3.705   -10.998     0.200
     0.820     1.159     0.200
     0.870     2.218     0.200
     1.010     1.068     0.200
     1.212     1.067     0.200
     1.392     0.422     0.200
     1.411     0.990     0.200
     1.421     0.929     0.200
     1.457     1.601     0.200
     1.494     0.856     0.200
     1.556    -0.578     0.200
     1.638    -0.496     0.200
     1.691    -1.133     0.200
     1.668     0.491     0.200
     1.809    -1.314     0.200
     2.339    -2.704     0.200
     2.533    -0.370     0.200
     2.856    -4.951     0.200
     2.904    -4.710     0.200
     3.093    -5.473     0.200
     3.284    -6.620     0.200
     3.411    -7.131     0.200
     3.686   -10.336     0.200
     3.716    -9.470     0.200
     0.391     2.403     0.200
     1.276    -0.692     0.200
     1.404     0.090     0.200
     1.435    -1.444     0.200
     1.479    -1.065     0.200
     1.419     0.922     0.200
     1.502    -0.188     0.200
     1.538    -2.120     0.200
     1.534     1.293     0.200
     1.548    -1.308     0.200
     1.533    -1.606     0.200
     1.595    -1.561     0.200
     1.789    -1.750     0.200
     1.825    -1.241     0.200
     1.784    -0.858     0.200
     2.026    -2.035     0.200
     1.964    -1.651     0.200
     2.890    -8.854     0.200
     3.217    -6.104     0.200
     3.288    -6.471     0.200
     3.331    -6.980     0.200
     3.925    -7.264     0.200
     0.130     4.808     0.200
     1.074     0.264     0.200
     1.233    -0.063     0.200
     1.328     0.104     0.200
     1.335     0.416     0.200
     1.336    -0.051     0.200
     1.376    -0.133     0.200
     1.381     0.275     0.200
     1.423     0.424     0.200
     1.494    -1.808     0.200
     1.825    -0.741     0.200
     1.686    -1.485     0.200
     1.751    -3.007     0.200
     1.808    -2.814     0.200
     2.123    -1.375     0.200
     2.542    -8.220     0.200
     2.811    -7.552     0.200
     3.077   -10.762     0.200
     0.243     1.498     0.200
     0.364     0.456     0.200
     1.135     1.293     0.200
     1.539     0.037     0.200
     1.062     1.670     0.200
     1.087     2.461     0.200
     1.110     2.822     0.200
     1.251     1.442     0.200
     1.120     3.069     0.200
     1.217     1.474     0.200
     1.039     1.979     0.200
     1.238     1.194     0.200
     1.533     2.999     0.200
     2.467    -2.484     0.200
     3.657    -6.518     0.200
     0.249     1.945     0.200
     0.342     1.034     0.200
     0.357     0.574     0.200
     1.065     1.329     0.200
     1.076    -0.528     0.200
     1.121     0.208     0.200
     1.101     2.107     0.200
     1.222     0.592     0.200
     1.249     0.914     0.200
     1.268     1.616     0.200
     1.374     1.082     0.200
     1.557     0.229     0.200
     1.527     1.536     0.200
     2.480    -3.479     0.200
     0.092     5.852     0.200
     1.007    -0.122     0.200
     1.167    -0.091     0.200
     1.241    -0.768     0.200
     1.265    -1.103     0.200
     1.260     0.207     0.200
     1.298     0.663     0.200
     1.305     0.003     0.200
     1.347     0.063     0.200
     1.407    -0.272     0.200
     1.541    -2.885     0.200
     1.605    -1.337     0.200
     1.611    -1.961     0.200
     1.725    -3.222     0.200
     1.731    -2.117     0.200
     1.779    -0.895     0.200
     2.365    -4.452     0.200
     2.605    -5.800     0.200
     3.035    -9.115     0.200
     3.473   -10.284     0.200
     3.567   -10.622     0.200
     0.287     2.612     0.200
     0.395     3.067     0.200
     0.414     3.469     0.200
     0.938     0.555     0.200
     0.991     0.533     0.200
     1.046    -0.153     0.200
     1.068     1.216     0.200
     1.078    -0.078     0.200
     1.192    -1.999     0.200
     1.219    -1.261     0.200
     1.243    -0.579     0.200
     1.321     0.088     0.200
     1.365     2.527     0.200
     1.537    -2.771     0.200
     1.579    -3.092     0.200
     2.159    -3.020     0.200
     2.195    -2.890     0.200
     2.473    -6.504     0.200
     2.596    -7.456     0.200
     2.657    -6.502     0.200
     2.885    -8.692     0.200
     2.932    -8.823     0.200
     3.008    -9.793     0.200
     3.089    -8.754     0.200
     3.168   -10.081     0.200
     3.490   -12.329     0.200
     3.651    -9.282     0.200
     3.684   -13.637     0.200
     0.273     1.751     0.200
     0.461     0.799     0.200
     0.490     1.829     0.200
     0.932     2.232     0.200
     0.948     0.862     0.200
     0.964     1.483     0.200
     0.989     3.964     0.200
     1.003     1.641     0.200
     1.086     1.613     0.200
     1.116     1.414     0.200
     1.132    -0.435     0.200
     1.233     1.924     0.200
     1.557    -0.087     0.200
     0.847     1.729     0.200
     0.949     2.488     0.200
     1.230     0.910     0.200
     1.395    -0.610     0.200
     1.478     0.666     0.200
     1.506     0.546     0.200
     1.518     0.005     0.200
     1.517     0.204     0.200
     1.552     0.471     0.200
     1.589     0.163     0.200
     1.645    -1.368     0.200
     1.737    -2.387     0.200
     1.907    -2.329     0.200
     2.630    -7.622     0.200
     2.997    -9.994     0.200
     3.251   -11.540     0.200
     1.590    -0.254     0.200
     0.530     1.315     0.200
     0.990    -0.621     0.200
     0.965    -0.358     0.200
     1.223    -1.190     0.200
     1.347     1.157     0.200
     1.644    -2.267     0.200
     1.741    -0.915     0.200
     1.788    -0.104     0.200
     1.777    -0.988     0.200
     1.788    -1.419     0.200
     1.792     2.303     0.200
     1.854     3.839     0.200
     1.824    -1.779     0.200
     1.862    -0.931     0.200
     1.899    -1.651     0.200
     2.021    -2.657     0.200
     2.062    -2.342     0.200
     2.258    -2.436     0.200
     2.189    -4.285     0.200
     2.770    -6.968     0.200
     3.190    -8.547     0.200
     3.214   -10.218     0.200
     3.224    -9.269     0.200
     3.233    -8.093     0.200
     3.236    -6.343     0.200
     3.260    -9.924     0.200
     3.351   -10.298     0.200
     3.552   -11.795     0.200
     3.643   -11.178     0.200
     3.793   -11.567     0.200
     4.012   -13.821     0.200
     4.331   -12.313     0.200
     4.336   -15.256     0.200
     1.862    -1.068     0.200
     0.155     4.776     0.200
     0.260     4.018     0.200
     0.321     3.856     0.200
     0.389     2.384     0.200
     0.399     2.800     0.200
     0.392     3.017     0.200
     0.407     3.298     0.200
     0.409     3.357     0.200
     0.423     3.070     0.200
     0.422     1.448     0.200
     0.611     0.774     0.200
     0.640     0.173     0.200
     0.665     0.513     0.200
     0.969    -0.434     0.200
     1.158    -0.448     0.200
     1.289    -1.893     0.200
     1.247    -0.377     0.200
     1.473    -0.811     0.200
     1.614    -1.995     0.200
     1.697    -2.070     0.200
     1.718    -2.960     0.200
     2.403    -6.277     0.200
     0.393     3.525     0.200
     0.188     3.969     0.200
     0.310     2.573     0.200
     0.322     2.257     0.200
     0.380     1.975     0.200
     0.515     1.392     0.200
     0.494     1.910     0.200
     0.507     2.012     0.200
     0.508     1.965     0.200
     0.537     1.864     0.200
     0.564     2.183     0.200
     0.572     2.010     0.200
     0.881    -0.681     0.200
     0.930     0.510     0.200
     0.944    -1.563     0.200
     1.281    -1.404     0.200
     1.434    -1.359     0.200
     1.697    -1.885     0.200
     2.144    -3.665     0.200
     2.187    -4.358     0.200
     2.143    -3.443     0.200
     2.613    -6.450     0.200
     2.889    -9.196     0.200
     3.342    -9.188     0.200
     0.557     2.190     0.200
     0.108     4.858     0.200
     1.052     0.791     0.200
     1.300    -0.354     0.200
     1.318     1.334     0.200
     1.317     0.563     0.200
     1.304    -0.329     0.200
     1.359     0.122     0.200
     1.363     1.199     0.200
     1.505    -2.568     0.200
     1.404    -0.127     0.200
     1.338     2.390     0.200
     1.595    -2.717     0.200
     1.671    -1.048     0.200
     1.790    -2.305     0.200
     1.718    -3.226     0.200
     2.090    -3.009     0.200
     2.629    -8.034     0.200
     2.802    -8.463     0.200
     1.396     0.243     0.200
     0.104     2.898     0.200
     0.691     1.262     0.200
     1.278    -0.304     0.200
     1.305     0.233     0.200
     1.328     0.874     0.200
     1.334     1.203     0.200
     1.311    -0.744     0.200
     1.417     0.017     0.200
     1.472    -2.139     0.200
     1.490    -0.781     0.200
     1.563     0.048     0.200
     1.682    -1.047     0.200
     1.707    -1.547     0.200
     1.814    -0.939     0.200
     2.060    -3.748     0.200
     2.009    -1.539     0.200
     2.056    -0.733     0.200
     2.263    -3.965     0.200
     2.275    -4.360     0.200
     2.643    -7.284     0.200
     2.475    -4.604     0.200
     2.663    -7.374     0.200
     2.763    -7.365     0.200
     2.757    -7.548     0.200
     2.924    -8.685     0.200
     3.126    -9.398     0.200
     3.390   -11.148     0.200
     3.415    -9.856     0.200
     3.477    -8.352     0.200
     1.363    -0.595     0.200
     0.496     1.783     0.200
     0.923    -0.558     0.200
     1.023     0.257     0.200
     1.049     0.884     0.200
     1.075     2.481     0.200
     1.096     1.277     0.200
     1.122     1.959     0.200
     1.162     0.273     0.200
     1.180    -1.067     0.200
     1.358    -0.628     0.200
     1.513    -1.578     0.200
     1.831    -4.736     0.200
     2.542    -5.250     0.200
     1.160     1.358     0.200
     0.277     0.660     0.200
     1.088     0.703     0.200
     1.101    -0.996     0.200
     1.125     1.838     0.200
     1.149     2.186     0.200
     1.400    -0.480     0.200
     1.510     2.793     0.200
     1.751     2.133     0.200
     1.876    -0.750     0.200
     2.238    -1.158     0.200
     2.383    -2.073     0.200
     2.394    -3.709     0.200
     2.340    -3.492     0.200
     2.435     0.619     0.200
     2.456    -3.623     0.200
     3.023    -0.909     0.200
     3.141    -7.808     0.200
     3.231    -8.781     0.200
     3.237    -7.520     0.200
     4.098   -12.225     0.200
     4.938   -14.936     0.200
     1.168     1.946     0.200
     0.934    -0.201     0.200
     1.031    -0.466     0.200
     1.510    -2.610     0.200
EOF
gmt end
