#!/bin/bash
gmt begin caleta1.47_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional caleta1.47'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    40.373
    14.500    40.095
    15.000    39.816
    15.500    39.534
    16.000    39.249
    16.500    38.957
    17.000    38.659
    17.500    38.352
    18.000    38.034
    18.500    37.703
    19.000    37.357
    19.500    36.993
    20.000    36.610
    20.500    36.206
    21.000    35.777
    21.500    35.321
    22.000    34.838
    22.500    34.324
    23.000    33.778
    23.500    33.090
    24.000    31.825
    24.500    30.551
    25.000    29.268
    25.500    27.973
    26.000    26.668
    26.500    25.352
    27.000    24.021
    27.500    22.675
    28.000    21.307
    28.500    19.926
    29.000    18.535
    29.500    17.134
    30.000    15.726
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    18.307 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     5.218
     1.000     6.379
     1.500     7.540
     2.000     8.701
     2.500     9.852
     3.000    10.996
     3.500    12.131
     4.000    13.254
     4.500    14.364
     5.000    15.459
     5.500    16.538
     6.000    17.598
     6.500    18.639
     7.000    19.657
     7.500    20.654
     8.000    21.644
     8.500    22.633
     9.000    23.616
     9.500    24.594
    10.000    25.564
    10.500    26.527
    11.000    27.482
    11.500    28.426
    12.000    29.360
    12.500    30.284
    13.000    31.196
    13.500    32.089
    14.000    32.957
    14.500    33.805
    15.000    34.635
    15.500    35.407
    16.000    36.071
    16.500    36.598
    17.000    37.055
    17.500    37.418
    18.000    37.746
    18.500    38.016
    19.000    38.228
    19.500    38.382
    20.000    38.478
    20.500    38.515
    21.000    38.492
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    28.196 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     4.621
     1.000     7.058
     1.500     9.692
     2.000    12.355
     2.500    15.028
     3.000    17.704
     3.500    20.380
     4.000    23.058
     4.500    25.735
     5.000    28.411
     5.500    31.086
     6.000    33.760
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.411 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    19.451
     1.500    25.956
     2.000    32.461
     2.500    38.966
     3.000    45.471
     3.500    51.971
     4.000    58.470
     4.500    64.965
     5.000    71.457
     5.500    77.945
     6.000    84.428
     6.500    90.908
     7.000    97.382
     7.500   103.851
     8.000   110.314
     8.500   116.771
     9.000   123.220
     9.500   129.663
    10.000   136.100
    10.500   142.527
    11.000   148.946
    11.500   155.357
    12.000   161.759
    12.500   168.151
    13.000   174.533
    13.500   180.905
    14.000   187.265
    14.500   193.614
    15.000   199.953
    15.500   206.279
    16.000   212.593
    16.500   218.894
    17.000   225.182
    17.500   231.310
    18.000   237.576
    18.500   243.829
    19.000   250.069
    19.500   256.295
    20.000   262.507
    20.500   268.704
    21.000   274.887
    21.500   281.054
    22.000   287.205
    22.500   293.341
    23.000   299.459
    23.500   305.561
    24.000   311.646
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    56.470 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.924
     1.000    20.074
     1.500    28.540
     2.000    37.054
     2.500    45.583
     3.000    54.117
     3.500    62.653
     4.000    71.190
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    60.653 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    35.909
     2.500    45.894
     3.000    55.879
     3.500    65.864
     4.000    75.848
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    57.879 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    16.292   219.721     0.150
    19.795    58.843     0.150
    20.071    57.620     0.150
    20.071   274.620     0.150
    20.898   262.967     0.150
    21.231   267.078     0.150
    21.639   266.326     0.150
    22.938   272.162     0.150
    25.130   279.586     0.150
    25.044   291.587     0.150
    26.459   305.074     0.150
    27.509  -301.028     0.150
    27.509    75.820     0.150
    28.148  -308.484     0.150
    28.148    72.363     0.150
    28.398   211.443     0.150
    29.437  -323.529     0.150
    16.813   233.384     0.150
    17.250    52.289     0.150
    20.429   279.188     0.150
    22.750   285.099     0.150
    23.334   276.285     0.150
    23.406    61.446     0.150
    25.391   299.281     0.150
    25.391   325.281     0.150
    25.584   323.029     0.150
    26.210   306.719     0.150
    26.859  -303.440     0.150
    27.567   326.892     0.150
    27.939  -306.044     0.150
    27.939   214.550     0.150
    28.781   207.718     0.150
    29.175   328.119     0.150
    23.892   465.730     0.150
    26.532   230.918     0.150
    28.127   215.303     0.150
    16.079   223.512     0.150
    17.252    50.825     0.150
    17.989    52.220     0.150
    20.525    52.627     0.150
    23.075   287.862     0.150
    24.147   254.353     0.150
    25.116   245.047     0.150
    25.303   242.864     0.150
    25.543   241.062     0.150
    26.030   299.377     0.150
    26.253   234.785     0.150
    26.253   300.785     0.150
    27.044  -302.505     0.150
    27.044   307.546     0.150
    27.684  -308.470     0.150
    27.684   220.080     0.150
    28.558  -324.772     0.150
    28.558  -319.772     0.150
    28.796   208.105     0.150
    29.366  -329.301     0.150
    20.968    53.600     0.150
    21.470   300.736     0.150
    26.712   228.573     0.150
    28.229  -310.431     0.150
    28.480  -312.160     0.150
    28.834  -322.890     0.150
    28.834  -316.890     0.150
    15.236   212.984     0.150
    16.623   235.798     0.150
    18.246   252.854     0.150
    19.457   272.732     0.150
    20.409   277.614     0.150
    20.321   276.641     0.150
    23.171    62.378     0.150
    24.358    59.530     0.150
    25.284    69.722     0.150
    25.284   301.722     0.150
    27.430   219.679     0.150
    27.638   308.249     0.150
    29.221    69.777     0.150
    29.221   319.777     0.150
    15.478   215.763     0.150
    17.030   234.644     0.150
    18.718   257.955     0.150
    20.835   484.245     0.150
    24.402   292.616     0.150
    24.660   251.602     0.150
    24.660   297.602     0.150
    25.797   302.339     0.150
    25.797   240.339     0.150
    27.226   308.658     0.150
    27.804   220.915     0.150
    29.810   314.511     0.150
    15.560   224.139     0.150
    17.098    51.190     0.150
    17.098   244.190     0.150
    17.691    49.262     0.150
    20.257    51.324     0.150
    21.688   274.625     0.150
    25.824   302.349     0.150
    27.878   218.383     0.150
    29.222   206.699     0.150
    29.907    69.705     0.150
    16.647   242.286     0.150
    19.824    55.214     0.150
    21.234    50.754     0.150
    22.438   277.698     0.150
    28.791   207.558     0.150
    17.024   247.471     0.150
    18.815   257.565     0.150
    25.685   289.400     0.150
    28.497  -321.360     0.150
    29.710  -339.421     0.150
    15.058   210.772     0.150
    16.478   232.199     0.150
    16.529   225.611     0.150
    18.799   254.614     0.150
    21.165   267.505     0.150
    29.885    65.739     0.150
    29.885   319.739     0.150
    15.829   213.620     0.150
    20.930    56.898     0.150
    22.794   275.846     0.150
    23.689   253.892     0.150
    24.636   244.845     0.150
    24.636   334.845     0.150
    15.945   222.196     0.150
    17.376   243.494     0.150
    23.527    63.116     0.150
    16.124   223.042     0.150
    18.747    45.930     0.150
    19.427    55.490     0.150
    21.757   276.303     0.150
    29.165  -331.459     0.150
    20.095   256.855     0.150
    27.527  -312.945     0.150
    17.272    47.517     0.150
    18.189    49.520     0.150
    18.485    49.169     0.150
    18.485    51.068     0.150
    18.485    53.568     0.150
    18.923    50.058     0.150
    18.923    53.456     0.150
    24.242   249.383     0.150
    25.063   241.795     0.150
    25.353   288.412     0.150
    25.317   239.839     0.150
    26.025  -282.214     0.150
    26.025   233.173     0.150
    26.025   287.571     0.150
    26.025   316.571     0.150
    26.994  -292.423     0.150
    26.994    70.261     0.150
    28.091  -305.327     0.150
    28.091    88.458     0.150
    28.091   212.458     0.150
    29.022  -315.992     0.150
    29.945  -326.256     0.150
    17.078   242.178     0.150
    24.184   253.254     0.150
    24.961   246.182     0.150
    28.004   216.673     0.150
    17.485   241.341     0.150
    18.884   259.017     0.150
    24.115   337.480     0.150
    26.015  -293.993     0.150
    26.631   314.614     0.150
    27.172   302.303     0.150
    29.475   319.428     0.150
    18.308   231.678     0.150
    18.330    46.922     0.150
    26.799  -290.747     0.150
    16.813    52.073     0.150
    18.182    46.096     0.150
    18.509    48.981     0.150
    19.968    56.257     0.150
    21.057   280.541     0.150
    21.357    54.043     0.150
    21.766    56.273     0.150
    24.872   246.030     0.150
    25.117   244.166     0.150
    25.826   236.791     0.150
    26.611  -292.545     0.150
    26.611   229.736     0.150
    27.121  -300.006     0.150
    27.904   216.641     0.150
    18.475    45.908     0.150
    18.475   243.908     0.150
    18.956    47.294     0.150
    18.469    49.860     0.150
    18.729   266.833     0.150
    18.547    49.815     0.150
    18.875    48.783     0.150
    18.790    46.973     0.150
    19.895    53.079     0.150
    21.223   502.586     0.150
    26.181   301.731     0.150
    18.927   250.761     0.150
    19.118    47.533     0.150
    21.048   286.008     0.150
    24.461   304.186     0.150
    25.046   464.356     0.150
    26.008   304.924     0.150
    19.020   268.876     0.150
    18.893   261.268     0.150
    25.160   305.431     0.150
    29.656   324.162     0.150
    16.940   239.026     0.150
    18.818   255.114     0.150
    22.666   283.003     0.150
    24.698   295.295     0.150
    24.791   691.404     0.150
    25.751   306.197     0.150
    29.692   324.314     0.150
    18.804   256.884     0.150
    17.197   236.490     0.150
    21.161   488.229     0.150
    17.899    52.363     0.150
    18.130    54.468     0.150
    18.197    51.094     0.150
    18.630    51.939     0.150
    18.497    54.154     0.150
    18.468   245.509     0.150
    26.062  -285.938     0.150
    26.491  -290.650     0.150
    26.870  -295.174     0.150
    28.373  -312.007     0.150
    28.663  -315.605     0.150
    18.613   251.634     0.150
    28.715  -324.200     0.150
    18.107    45.245     0.150
    18.022    49.928     0.150
    18.339    49.932     0.150
    18.342    49.899     0.150
    18.827    51.836     0.150
    20.952    51.035     0.150
    17.973    46.871     0.150
    18.735   260.973     0.150
    19.274   518.885     0.150
    18.500    47.522     0.150
    18.500   246.822     0.150
    19.094    55.755     0.150
    19.629    55.854     0.150
    20.519    54.998     0.150
    20.565    65.945     0.150
    20.737    53.598     0.150
    20.737    65.692     0.150
    20.823    55.124     0.150
    20.984    54.252     0.150
    22.771   261.254     0.150
    24.050   249.248     0.150
    26.221  -287.245     0.150
    26.221   227.216     0.150
    27.053  -293.939     0.150
    27.146  -295.363     0.150
    27.146  -283.918     0.150
    27.146   219.285     0.150
    27.220  -296.421     0.150
    27.633  -301.076     0.150
    27.633   215.431     0.150
    17.800   310.398     0.150
    25.031   240.110     0.150
    26.842  -294.694     0.150
    27.472  -301.545     0.150
    28.133  -306.263     0.150
    17.964   236.732     0.150
    18.293    54.400     0.150
    22.878   257.896     0.150
    23.950   246.480     0.150
    27.050  -293.276     0.150
    27.050   217.060     0.150
    27.461  -297.366     0.150
    24.322   275.824     0.150
    25.392   241.472     0.150
    25.321   241.899     0.150
    25.482   241.013     0.150
    25.482   460.111     0.150
    29.020   210.320     0.150
    16.214   225.661     0.150
    20.901    52.257     0.150
    21.024    51.519     0.150
    21.821   266.025     0.150
    21.821   702.165     0.150
    26.284  -287.476     0.150
    26.317  -288.078     0.150
    26.727  -292.123     0.150
    26.851  -293.948     0.150
    26.983  -294.587     0.150
    27.782  -305.340     0.150
    27.895  -306.831     0.150
    28.577  -314.098     0.150
    28.605  -314.455     0.150
    29.110  -320.849     0.150
    23.673   258.070     0.150
    24.340   252.618     0.150
    24.411   252.041     0.150
    25.006   245.575     0.150
    25.241   243.029     0.150
    26.236   234.321     0.150
    26.287   234.030     0.150
    26.535   231.036     0.150
    26.706   230.273     0.150
    26.719   228.412     0.150
    27.785   219.828     0.150
    28.382   214.620     0.150
    28.782   211.346     0.150
    29.999  -337.539     0.150
    25.306   241.964     0.150
    24.126   293.317     0.150
    24.514   252.015     0.150
    19.893    52.098     0.150
    26.835  -305.412     0.150
    27.894  -317.149     0.150
    28.197  -320.672     0.150
    28.255  -320.780     0.150
    28.926  -329.563     0.150
    17.017    45.769     0.150
    17.178   243.599     0.150
    19.403    48.261     0.150
    26.818  -305.981     0.150
    27.887  -318.176     0.150
    28.186  -321.453     0.150
    28.884  -329.168     0.150
    29.213  -333.562     0.150
    24.406   252.303     0.150
    25.258   243.036     0.150
    28.083  -315.585     0.150
    28.398  -319.350     0.150
    25.586   242.585     0.150
    29.014  -331.565     0.150
    29.133   210.904     0.150
    20.884    50.882     0.150
    25.182   244.179     0.150
    25.241   241.680     0.150
    21.461   279.824     0.150
    23.177   264.330     0.150
    24.577   250.488     0.150
    24.841   247.702     0.150
    25.240   244.107     0.150
    19.144    51.019     0.150
    19.414    51.152     0.150
    24.890   247.493     0.150
    27.585  -313.589     0.150
    27.609  -314.015     0.150
    15.786    54.663     0.150
    25.081   242.509     0.150
    23.309   263.427     0.150
    24.520   250.974     0.150
    26.770   230.523     0.150
    28.398   214.440     0.150
    17.113   232.800     0.150
    17.628   240.434     0.150
    17.755   243.258     0.150
    17.791   242.073     0.150
    17.889   245.428     0.150
    18.037   245.855     0.150
    18.164   247.090     0.150
    18.185   247.947     0.150
    18.415   249.328     0.150
    18.440   248.209     0.150
    18.489   252.438     0.150
    18.543   250.879     0.150
    18.761   251.990     0.150
    18.796   253.698     0.150
    18.875   255.032     0.150
    18.995   255.784     0.150
    19.043   255.861     0.150
    19.049   258.009     0.150
    19.103   259.672     0.150
    20.408   264.839     0.150
    21.877   277.797     0.150
    22.067   279.713     0.150
    22.066   279.473     0.150
    22.149   282.509     0.150
    22.577   284.638     0.150
    22.621   287.065     0.150
    22.668   281.873     0.150
    22.724   284.675     0.150
    22.740   283.809     0.150
    22.779   282.647     0.150
    23.020   283.208     0.150
    23.017   286.695     0.150
    23.041   286.021     0.150
    23.188   285.052     0.150
    23.348   286.332     0.150
    23.370   287.970     0.150
    23.381   287.993     0.150
    23.474   287.918     0.150
    23.497   291.494     0.150
    23.577   287.712     0.150
    23.582   288.533     0.150
    23.740   257.986     0.150
    23.833   291.734     0.150
    23.831   289.770     0.150
    23.914   290.629     0.150
    23.932   291.434     0.150
    23.935   291.568     0.150
    24.042   289.482     0.150
    24.137   289.968     0.150
    24.177   291.987     0.150
    24.216   291.982     0.150
    24.367   293.771     0.150
    24.454   293.128     0.150
    24.473   292.398     0.150
    24.504   294.320     0.150
    24.621   291.422     0.150
    24.670   293.815     0.150
    24.678   294.523     0.150
    24.816   247.128     0.150
    24.816   294.027     0.150
    24.818   293.835     0.150
    24.874   293.345     0.150
    24.914   294.893     0.150
    24.928   293.627     0.150
    25.123   298.362     0.150
    25.196   297.612     0.150
    25.211   299.391     0.150
    25.230   296.687     0.150
    25.390   295.091     0.150
    25.396   296.894     0.150
    25.485   299.022     0.150
    25.543   302.085     0.150
    25.581   303.548     0.150
    25.582   301.749     0.150
    25.854   308.947     0.150
    25.941   300.859     0.150
    26.014  -296.743     0.150
    26.092   306.506     0.150
    26.186   304.289     0.150
    26.189   306.308     0.150
    26.201   302.260     0.150
    26.302   305.754     0.150
    26.437   312.931     0.150
    26.525   308.952     0.150
    26.558   303.232     0.150
    26.959   311.735     0.150
    27.115   301.544     0.150
    27.312   305.154     0.150
    27.362   310.457     0.150
    27.391   308.654     0.150
    27.481   306.588     0.150
    27.633   303.959     0.150
    28.141   308.401     0.150
    28.397   313.350     0.150
    28.429   310.006     0.150
    28.429   313.576     0.150
    28.470   311.327     0.150
    28.726   312.349     0.150
    28.956   302.101     0.150
    29.064   305.764     0.150
    18.465    52.966     0.150
    19.864    50.373     0.150
    20.724    52.647     0.150
    18.552   248.358     0.150
    19.843   254.743     0.150
    20.053    50.935     0.150
    20.997    54.038     0.150
    21.125    52.108     0.150
    23.271   262.989     0.150
    24.488   250.755     0.150
    24.488   286.280     0.150
    24.713   286.561     0.150
    24.767   248.353     0.150
    25.406   241.067     0.150
    25.403   242.078     0.150
    25.526   242.235     0.150
    25.625   240.247     0.150
    25.646   240.582     0.150
    26.343   236.605     0.150
    26.819   231.577     0.150
    27.822   221.455     0.150
    27.973   219.673     0.150
    28.362   214.017     0.150
    29.182   208.196     0.150
    18.946    48.217     0.150
    21.336   281.578     0.150
    21.393   280.699     0.150
    21.481   281.015     0.150
    21.662   279.131     0.150
    21.928   277.549     0.150
    23.836   258.138     0.150
    24.778   248.630     0.150
    25.268   244.315     0.150
    25.996   237.641     0.150
    26.451   233.894     0.150
    26.761   231.787     0.150
    27.745   221.536     0.150
    28.403   215.033     0.150
    29.310   206.741     0.150
    17.847    48.808     0.150
    18.445    57.491     0.150
    19.935    57.433     0.150
    17.057    44.307     0.150
    24.987   242.264     0.150
    17.203   239.197     0.150
    21.698   277.574     0.150
    22.118   273.521     0.150
    22.146   271.125     0.150
    23.306   261.139     0.150
    23.842   256.041     0.150
    24.452   249.322     0.150
    24.559   249.558     0.150
    24.630   249.016     0.150
    24.758   247.173     0.150
    25.371   240.546     0.150
    26.026  -294.521     0.150
    26.369   232.302     0.150
    26.405  -299.155     0.150
    26.405   232.490     0.150
    26.751   229.788     0.150
    27.269   225.248     0.150
    28.296   212.475     0.150
    28.519   212.657     0.150
    28.924  -329.394     0.150
    29.336   203.723     0.150
    29.375  -333.125     0.150
    29.506    82.977     0.150
    29.506   202.797     0.150
    29.619  -337.638     0.150
    29.619  -332.977     0.150
    24.746   245.258     0.150
    25.284   244.137     0.150
    24.912   243.046     0.150
    16.078   335.512     0.150
    21.847   296.810     0.150
    23.536   260.447     0.150
    23.536   260.445     0.150
    24.642   247.878     0.150
    24.642   247.880     0.150
    26.861   225.238     0.150
    27.693   300.155     0.150
    15.822   227.148     0.150
    19.553   302.408     0.150
    20.627   257.530     0.150
    25.243   245.720     0.150
    25.243   244.923     0.150
    26.608   235.276     0.150
    27.604   224.760     0.150
    28.698    79.906     0.150
    28.909    75.689     0.150
    29.790   203.518     0.150
    24.882   246.597     0.150
    18.661   306.776     0.150
    20.092    53.180     0.150
    22.670   284.533     0.150
    22.810   263.905     0.150
    23.362   322.112     0.150
    23.432   259.545     0.150
    23.432   473.373     0.150
    24.591   247.745     0.150
    24.770   294.832     0.150
    24.881   245.591     0.150
    28.116   214.758     0.150
    28.814   207.973     0.150
    29.368   203.971     0.150
    29.749    76.887     0.150
    17.259   236.771     0.150
    19.887   258.501     0.150
    22.629   267.913     0.150
    24.823   244.603     0.150
    25.267   242.862     0.150
    25.429   240.567     0.150
    25.429   240.567     0.150
    25.429   239.807     0.150
    27.241   221.114     0.150
    28.500   211.744     0.150
    28.579   212.245     0.150
    29.424   203.498     0.150
    23.941   256.848     0.150
    24.995   246.109     0.150
    20.033    55.464     0.150
    22.631   260.245     0.150
    24.983   246.765     0.150
    22.773   269.606     0.150
    22.773   269.469     0.150
    23.985   256.283     0.150
    23.985   256.018     0.150
    23.333   263.359     0.150
    24.988   245.423     0.150
    25.245   242.677     0.150
    18.114    50.012     0.150
    24.932   246.676     0.150
    23.864   254.241     0.150
    24.801   243.310     0.150
    14.401   205.918     0.150
    23.887   258.151     0.150
    24.926   246.473     0.150
    24.633   250.118     0.150
    27.185   225.475     0.150
    25.274   244.194     0.150
    19.419    49.921     0.150
    24.813   244.552     0.150
    24.520   249.186     0.150
    25.069   244.030     0.150
    25.237   241.676     0.150
    24.611   242.848     0.150
    24.611   453.856     0.150
    25.329   242.290     0.150
    27.306  -309.812     0.150
    24.297   249.489     0.150
    25.055   240.695     0.150
    24.991   242.664     0.150
    14.236   205.943     0.150
    16.964   232.997     0.150
    18.858    46.851     0.150
    19.026    50.292     0.150
    19.047    51.688     0.150
    19.423   255.910     0.150
    19.807    48.689     0.150
    19.985    50.023     0.150
    21.999   282.668     0.150
    24.362   297.338     0.150
    24.667   299.026     0.150
    23.567   261.357     0.150
    24.728   249.971     0.150
    24.728   249.768     0.150
    25.094   244.968     0.150
    17.330   236.147     0.150
    19.053   256.661     0.150
    19.204    48.712     0.150
    19.219    49.070     0.150
    19.784   258.107     0.150
    23.752   259.569     0.150
    23.752   296.819     0.150
    24.863   247.554     0.150
    24.863   295.784     0.150
    24.161   255.791     0.150
    25.139   245.988     0.150
    25.139   246.258     0.150
    24.996   246.228     0.150
    17.137    50.057     0.150
    17.308    53.865     0.150
    17.310   235.501     0.150
    17.353    52.492     0.150
    17.459    51.711     0.150
    17.502    51.334     0.150
    17.729    51.514     0.150
    18.779   254.216     0.150
    19.222   255.227     0.150
    19.222   258.284     0.150
    21.348   274.973     0.150
    24.194   289.164     0.150
    24.452   284.322     0.150
    25.167   245.889     0.150
    28.888   311.850     0.150
    18.115   247.405     0.150
    23.671   260.362     0.150
    24.380   253.798     0.150
    24.797   249.450     0.150
    24.797   249.067     0.150
    28.357   215.910     0.150
    24.684   243.217     0.150
    24.922   246.120     0.150
    24.922   245.885     0.150
    23.723   257.188     0.150
    24.699   246.548     0.150
    24.720   246.240     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    18.398    35.139     0.200
    20.071    38.620     0.200
    20.898    34.967     0.200
    21.231    33.078     0.200
    21.368    31.489     0.200
    21.639    32.326     0.200
    21.665    29.020     0.200
    22.766    34.169     0.200
    22.938    29.162     0.200
    23.017    29.243     0.200
    23.021    33.188     0.200
    23.238    32.658     0.200
    24.321    32.017     0.200
    24.987    30.253     0.200
    25.215    25.587     0.200
    25.044    29.587     0.200
    25.477    28.530     0.200
    26.060    22.722     0.200
    26.489    25.722     0.200
    27.558    17.244     0.200
    27.509    20.820     0.200
    28.148    19.363     0.200
    28.398    18.443     0.200
    29.437    12.319     0.200
    15.176    38.493     0.200
    15.582    37.256     0.200
    19.429    34.053     0.200
    20.429    36.188     0.200
    21.274    33.323     0.200
    21.274    36.323     0.200
    21.562    31.970     0.200
    21.927    31.707     0.200
    22.454    33.558     0.200
    22.750    31.099     0.200
    22.977    34.056     0.200
    23.002    32.560     0.200
    23.150    33.931     0.200
    23.299    28.696     0.200
    23.334    28.285     0.200
    23.280    33.820     0.200
    23.406    32.548     0.200
    23.618    32.771     0.200
    23.820    32.314     0.200
    24.681    30.670     0.200
    25.045    27.318     0.200
    25.346    25.812     0.200
    25.359    29.660     0.200
    25.378    26.534     0.200
    25.584    28.028     0.200
    26.122    26.055     0.200
    26.210    26.919     0.200
    26.859    25.154     0.200
    27.567    19.092     0.200
    27.939    19.550     0.200
    28.781    17.718     0.200
    29.175    14.119     0.200
    29.681    11.522     0.200
    13.887    35.490     0.200
    15.235    38.757     0.200
    15.591    37.497     0.200
    16.837    38.561     0.200
    17.509    39.017     0.200
    18.651    34.890     0.200
    20.774    35.112     0.200
    21.403    33.278     0.200
    21.646    31.942     0.200
    22.643    33.201     0.200
    23.127    28.860     0.200
    23.023    33.868     0.200
    23.186    29.367     0.200
    23.275    32.723     0.200
    23.383    33.274     0.200
    23.623    33.472     0.200
    23.626    33.337     0.200
    23.892    32.433     0.200
    24.596    30.512     0.200
    24.951    29.366     0.200
    24.788    29.767     0.200
    25.023    30.030     0.200
    26.532    25.418     0.200
    27.174    24.421     0.200
    28.127    19.803     0.200
    29.027    13.798     0.200
    29.136    14.825     0.200
    29.028    16.492     0.200
    15.562    39.539     0.200
    16.079    38.410     0.200
    17.252    40.024     0.200
    17.989    40.021     0.200
    18.859    36.068     0.200
    21.296    37.629     0.200
    21.718    33.400     0.200
    21.870    33.131     0.200
    23.075    34.260     0.200
    23.155    29.532     0.200
    23.330    32.088     0.200
    23.776    34.080     0.200
    24.147    33.752     0.200
    24.099    33.912     0.200
    24.574    33.378     0.200
    25.027    27.592     0.200
    25.116    30.746     0.200
    25.303    30.165     0.200
    25.543    30.062     0.200
    26.030    28.877     0.200
    26.253    28.184     0.200
    26.318    25.025     0.200
    27.044    26.444     0.200
    27.331    21.094     0.200
    27.684    23.479     0.200
    28.558    20.381     0.200
    28.796    18.207     0.200
    29.366    20.055     0.200
    29.499    16.896     0.200
    29.575    14.509     0.200
    15.743    37.080     0.200
    16.926    38.769     0.200
    17.653    39.089     0.200
    18.612    35.095     0.200
    19.290    34.585     0.200
    21.470    34.236     0.200
    21.616    31.645     0.200
    23.002    29.268     0.200
    23.441    33.539     0.200
    23.510    32.034     0.200
    24.043    31.813     0.200
    24.787    30.429     0.200
    24.971    29.278     0.200
    25.214    29.544     0.200
    26.712    25.573     0.200
    27.197    19.610     0.200
    28.229    19.866     0.200
    28.480    16.738     0.200
    28.834    17.204     0.200
    14.655    37.761     0.200
    15.236    37.984     0.200
    16.623    38.598     0.200
    17.169    39.223     0.200
    18.246    40.456     0.200
    19.457    36.130     0.200
    20.409    34.215     0.200
    21.235    36.980     0.200
    21.568    34.091     0.200
    21.701    32.340     0.200
    22.395    34.240     0.200
    22.945    33.723     0.200
    23.078    33.472     0.200
    23.141    35.229     0.200
    23.171    35.480     0.200
    23.399    29.525     0.200
    23.338    33.731     0.200
    23.533    33.662     0.200
    24.057    33.049     0.200
    24.148    32.786     0.200
    24.379    27.980     0.200
    24.358    31.631     0.200
    24.574    31.711     0.200
    25.243    29.202     0.200
    25.284    31.222     0.200
    25.304    30.488     0.200
    26.110    27.191     0.200
    26.388    21.642     0.200
    26.477    21.803     0.200
    27.430    20.179     0.200
    27.638    18.148     0.200
    28.704    18.815     0.200
    29.221    15.777     0.200
    14.187    38.831     0.200
    17.030    41.144     0.200
    17.276    39.776     0.200
    17.642    40.604     0.200
    18.933    37.939     0.200
    19.099    37.106     0.200
    19.633    35.274     0.200
    20.835    39.245     0.200
    21.814    34.821     0.200
    22.822    35.751     0.200
    23.432    31.539     0.200
    23.368    33.882     0.200
    23.535    34.838     0.200
    23.686    36.479     0.200
    24.015    35.040     0.200
    24.402    30.416     0.200
    24.571    33.848     0.200
    24.660    33.602     0.200
    24.709    32.732     0.200
    24.866    32.605     0.200
    25.087    32.726     0.200
    25.295    32.696     0.200
    25.797    31.038     0.200
    25.822    31.045     0.200
    26.031    29.702     0.200
    26.576    25.743     0.200
    27.226    28.158     0.200
    27.263    26.034     0.200
    27.786    21.532     0.200
    27.804    23.014     0.200
    28.928    21.296     0.200
    29.327    16.139     0.200
    29.170    19.569     0.200
    29.810    14.411     0.200
    29.970    21.645     0.200
    15.560    40.139     0.200
    17.098    40.190     0.200
    17.321    40.582     0.200
    17.691    40.762     0.200
    19.026    36.690     0.200
    19.727    36.209     0.200
    20.861    39.267     0.200
    21.688    37.125     0.200
    22.015    33.805     0.200
    22.885    36.149     0.200
    23.529    30.929     0.200
    23.432    34.268     0.200
    23.589    35.229     0.200
    24.060    34.938     0.200
    24.500    31.207     0.200
    24.688    33.314     0.200
    24.897    32.565     0.200
    25.114    32.240     0.200
    26.670    23.981     0.200
    27.878    22.383     0.200
    29.424    16.339     0.200
    29.907    13.806     0.200
    14.193    36.921     0.200
    16.647    37.286     0.200
    18.603    34.250     0.200
    19.342    33.330     0.200
    20.203    34.586     0.200
    21.234    36.254     0.200
    21.483    36.552     0.200
    23.187    29.063     0.200
    23.154    32.851     0.200
    23.340    33.580     0.200
    23.641    31.166     0.200
    24.511    29.718     0.200
    24.739    30.056     0.200
    25.459    28.949     0.200
    26.257    26.132     0.200
    28.470    21.106     0.200
    28.791    17.456     0.200
    16.901    38.114     0.200
    18.815    36.464     0.200
    19.408    33.545     0.200
    19.546    34.543     0.200
    21.352    37.462     0.200
    21.518    36.734     0.200
    21.729    37.264     0.200
    22.005    32.042     0.200
    22.016    36.610     0.200
    21.998    36.023     0.200
    22.079    36.481     0.200
    22.693    34.514     0.200
    22.982    35.047     0.200
    23.105    32.500     0.200
    23.167    34.280     0.200
    23.339    30.272     0.200
    23.255    34.460     0.200
    23.408    33.072     0.200
    23.657    33.061     0.200
    23.574    34.630     0.200
    23.654    33.304     0.200
    23.891    33.327     0.200
    23.976    33.735     0.200
    24.311    28.824     0.200
    24.459    31.902     0.200
    24.548    31.764     0.200
    24.751    30.899     0.200
    24.975    31.287     0.200
    25.193    30.531     0.200
    25.184    31.143     0.200
    25.429    29.593     0.200
    25.508    29.667     0.200
    25.584    30.574     0.200
    25.685    28.900     0.200
    25.697    29.254     0.200
    25.710    31.101     0.200
    26.499    27.194     0.200
    27.104    21.833     0.200
    27.554    21.083     0.200
    28.529    17.415     0.200
    28.497    18.374     0.200
    28.710    21.297     0.200
    29.045    18.587     0.200
    29.348    16.543     0.200
    29.710    15.126     0.200
    16.863    40.715     0.200
    18.799    37.114     0.200
    19.573    35.983     0.200
    21.165    38.505     0.200
    21.392    38.652     0.200
    21.443    38.563     0.200
    22.060    34.759     0.200
    22.278    35.913     0.200
    22.746    32.452     0.200
    22.784    36.605     0.200
    22.927    35.241     0.200
    22.931    37.502     0.200
    23.031    35.730     0.200
    23.200    36.757     0.200
    23.350    35.311     0.200
    23.391    35.731     0.200
    23.574    30.989     0.200
    23.910    34.569     0.200
    24.132    33.985     0.200
    24.336    34.000     0.200
    24.560    29.482     0.200
    24.873    33.433     0.200
    25.047    33.307     0.200
    25.888    30.288     0.200
    28.177    19.781     0.200
    28.541    20.829     0.200
    14.916    41.281     0.200
    15.829    38.120     0.200
    15.935    38.382     0.200
    19.679    35.691     0.200
    20.930    35.398     0.200
    22.055    33.962     0.200
    22.315    32.434     0.200
    22.566    32.499     0.200
    22.802    32.753     0.200
    22.899    32.723     0.200
    23.689    30.091     0.200
    24.105    30.043     0.200
    24.636    29.145     0.200
    27.448    18.431     0.200
    27.951    17.757     0.200
    15.674    40.860     0.200
    17.249    40.280     0.200
    17.376    40.494     0.200
    19.093    36.565     0.200
    21.975    34.620     0.200
    23.527    30.217     0.200
    23.527    32.116     0.200
    23.912    35.924     0.200
    23.996    34.237     0.200
    24.244    34.346     0.200
    24.493    29.943     0.200
    24.325    34.699     0.200
    25.094    32.222     0.200
    25.314    31.863     0.200
    26.024    30.574     0.200
    27.492    25.944     0.200
    28.139    22.386     0.200
    29.126    20.969     0.200
    29.053    22.223     0.200
    29.450    16.389     0.200
    16.124    38.843     0.200
    17.240    39.915     0.200
    17.240    40.816     0.200
    17.568    40.194     0.200
    18.747    35.930     0.200
    18.756    36.327     0.200
    19.427    35.490     0.200
    20.592    34.094     0.200
    20.763    34.904     0.200
    21.383    37.663     0.200
    21.602    33.417     0.200
    21.757    34.803     0.200
    21.995    32.630     0.200
    22.276    32.645     0.200
    22.470    31.783     0.200
    22.881    33.189     0.200
    23.376    32.404     0.200
    23.866    33.885     0.200
    24.235    33.887     0.200
    24.287    31.974     0.200
    24.424    32.184     0.200
    24.563    32.662     0.200
    25.379    30.233     0.200
    25.628    30.127     0.200
    25.734    29.392     0.200
    26.925    22.987     0.200
    27.154    22.618     0.200
    27.222    21.323     0.200
    27.752    24.339     0.200
    28.979    16.723     0.200
    29.165    18.744     0.200
    14.596    42.030     0.200
    15.226    40.574     0.200
    17.796    40.091     0.200
    18.104    38.095     0.200
    18.326    36.902     0.200
    18.652    37.094     0.200
    18.701    36.724     0.200
    18.834    36.970     0.200
    20.497    35.571     0.200
    21.092    35.623     0.200
    21.046    38.765     0.200
    21.182    38.675     0.200
    21.456    37.979     0.200
    22.097    38.690     0.200
    22.362    31.907     0.200
    22.330    35.772     0.200
    22.758    37.276     0.200
    24.054    34.255     0.200
    24.241    29.372     0.200
    24.489    29.880     0.200
    16.322    37.310     0.200
    16.735    38.286     0.200
    16.916    37.872     0.200
    17.272    38.416     0.200
    18.046    31.885     0.200
    18.189    34.918     0.200
    18.485    34.267     0.200
    18.531    36.023     0.200
    18.923    34.757     0.200
    20.224    36.769     0.200
    20.367    32.103     0.200
    20.246    36.816     0.200
    20.599    36.900     0.200
    21.439    33.095     0.200
    22.182    29.821     0.200
    22.240    29.350     0.200
    23.539    30.982     0.200
    23.513    32.191     0.200
    23.771    26.881     0.200
    23.848    25.982     0.200
    23.925    31.582     0.200
    23.972    30.128     0.200
    24.098    30.256     0.200
    24.242    30.684     0.200
    24.810    28.058     0.200
    25.096    25.411     0.200
    25.063    27.994     0.200
    25.353    26.412     0.200
    25.258    28.022     0.200
    25.317    27.941     0.200
    25.409    27.260     0.200
    26.025    26.372     0.200
    26.610    22.551     0.200
    26.717    24.003     0.200
    26.891    20.271     0.200
    26.994    18.460     0.200
    27.141    18.852     0.200
    27.146    19.795     0.200
    27.358    18.120     0.200
    27.540    17.690     0.200
    27.434    21.335     0.200
    28.091    17.958     0.200
    28.332    17.255     0.200
    28.839    17.330     0.200
    29.022    17.894     0.200
    29.945    12.830     0.200
    15.495    39.646     0.200
    15.794    37.961     0.200
    17.078    38.178     0.200
    19.394    36.152     0.200
    21.652    36.295     0.200
    21.564    37.828     0.200
    21.756    37.081     0.200
    22.212    36.263     0.200
    22.733    31.679     0.200
    23.602    34.439     0.200
    23.786    34.895     0.200
    23.864    33.482     0.200
    24.094    33.801     0.200
    24.184    34.153     0.200
    24.340    28.631     0.200
    24.442    28.239     0.200
    24.961    31.182     0.200
    25.129    31.218     0.200
    25.186    31.156     0.200
    25.397    30.296     0.200
    25.896    28.871     0.200
    27.422    21.658     0.200
    27.464    20.769     0.200
    27.354    25.450     0.200
    27.500    21.047     0.200
    27.574    20.585     0.200
    27.605    20.224     0.200
    27.667    20.207     0.200
    27.676    20.193     0.200
    27.890    19.497     0.200
    27.982    19.127     0.200
    28.070    19.199     0.200
    28.004    21.572     0.200
    28.546    19.345     0.200
    28.920    21.978     0.200
    29.284    17.628     0.200
    29.759    14.791     0.200
    16.404    39.457     0.200
    17.485    40.341     0.200
    18.884    37.216     0.200
    19.336    36.944     0.200
    21.678    37.412     0.200
    21.986    36.118     0.200
    22.018    37.042     0.200
    22.566    32.646     0.200
    23.973    29.828     0.200
    24.115    30.280     0.200
    24.530    33.637     0.200
    24.580    32.353     0.200
    24.703    33.307     0.200
    24.850    32.997     0.200
    25.414    31.711     0.200
    25.669    28.739     0.200
    25.671    30.118     0.200
    25.864    30.064     0.200
    25.922    30.284     0.200
    26.015    29.604     0.200
    26.631    29.415     0.200
    27.024    23.023     0.200
    27.172    22.703     0.200
    27.263    25.232     0.200
    27.407    26.658     0.200
    28.042    24.149     0.200
    28.700    20.473     0.200
    29.055    17.229     0.200
    29.241    19.950     0.200
    29.420    19.469     0.200
    29.475    16.229     0.200
    29.592    18.663     0.200
    29.456    23.150     0.200
    21.504    37.743     0.200
    15.050    33.201     0.200
    15.730    33.261     0.200
    16.801    34.562     0.200
    17.186    30.967     0.200
    17.186    32.069     0.200
    18.308    30.777     0.200
    18.432    30.734     0.200
    18.770    30.187     0.200
    18.770    31.386     0.200
    21.044    31.252     0.200
    21.310    30.147     0.200
    21.343    31.264     0.200
    21.902    32.237     0.200
    22.053    26.980     0.200
    23.653    22.806     0.200
    23.895    27.180     0.200
    23.933    25.734     0.200
    24.028    25.927     0.200
    24.187    25.870     0.200
    24.984    22.767     0.200
    25.022    23.727     0.200
    25.225    23.458     0.200
    25.341    23.105     0.200
    26.754    19.719     0.200
    26.799    16.087     0.200
    17.412    38.586     0.200
    18.509    35.681     0.200
    18.642    35.035     0.200
    18.980    34.286     0.200
    20.858    36.864     0.200
    21.057    35.541     0.200
    21.357    35.242     0.200
    21.392    35.832     0.200
    21.766    36.273     0.200
    22.130    35.024     0.200
    22.301    31.023     0.200
    23.723    33.135     0.200
    24.065    32.445     0.200
    24.397    30.572     0.200
    24.608    30.109     0.200
    24.852    26.254     0.200
    24.872    29.730     0.200
    24.988    27.171     0.200
    25.117    29.564     0.200
    25.677    25.932     0.200
    25.826    29.092     0.200
    26.611    25.736     0.200
    26.708    25.600     0.200
    27.121    19.877     0.200
    27.249    23.291     0.200
    27.904    19.540     0.200
    28.515    18.610     0.200
    28.831    19.427     0.200
    15.270    38.311     0.200
    15.394    36.862     0.200
    16.596    37.034     0.200
    17.407    36.473     0.200
    18.956    34.591     0.200
    20.719    35.720     0.200
    21.397    34.800     0.200
    21.436    34.350     0.200
    21.794    35.173     0.200
    21.873    34.749     0.200
    23.379    33.382     0.200
    23.444    31.412     0.200
    23.640    31.026     0.200
    23.748    32.169     0.200
    23.869    30.748     0.200
    23.923    31.226     0.200
    24.348    29.660     0.200
    24.515    29.220     0.200
    24.718    28.847     0.200
    24.762    26.532     0.200
    24.775    29.379     0.200
    24.945    27.796     0.200
    26.282    25.694     0.200
    28.276    18.320     0.200
    17.098    42.863     0.200
    17.617    40.507     0.200
    19.825    40.038     0.200
    21.141    41.675     0.200
    21.244    40.477     0.200
    21.342    42.334     0.200
    21.635    39.911     0.200
    21.670    40.208     0.200
    22.053    40.036     0.200
    22.491    35.927     0.200
    22.415    40.807     0.200
    23.066    33.521     0.200
    25.134    33.286     0.200
    25.274    31.444     0.200
    25.536    32.486     0.200
    25.949    30.267     0.200
    28.804    22.856     0.200
    14.154    41.585     0.200
    17.219    40.312     0.200
    17.222    40.531     0.200
    18.357    37.527     0.200
    18.253    42.351     0.200
    18.671    37.949     0.200
    18.875    37.283     0.200
    18.875    39.880     0.200
    19.342    36.541     0.200
    19.895    40.079     0.200
    20.242    37.931     0.200
    20.194    39.896     0.200
    20.198    38.947     0.200
    20.654    39.231     0.200
    21.127    38.808     0.200
    21.223    37.586     0.200
    21.323    38.420     0.200
    22.131    36.990     0.200
    22.348    36.953     0.200
    22.639    34.565     0.200
    22.561    36.973     0.200
    23.209    32.005     0.200
    23.707    36.102     0.200
    24.234    30.941     0.200
    24.234    30.441     0.200
    24.074    34.311     0.200
    24.140    33.147     0.200
    24.213    32.891     0.200
    24.323    33.907     0.200
    24.440    34.349     0.200
    24.565    32.582     0.200
    24.618    32.763     0.200
    24.984    28.192     0.200
    25.093    27.921     0.200
    24.959    32.284     0.200
    25.044    31.993     0.200
    25.210    30.859     0.200
    25.393    28.717     0.200
    25.414    30.981     0.200
    25.462    30.716     0.200
    25.471    31.111     0.200
    25.630    30.357     0.200
    26.007    29.059     0.200
    26.181    30.731     0.200
    26.977    27.239     0.200
    27.387    22.054     0.200
    27.387    21.656     0.200
    27.618    24.757     0.200
    28.170    23.010     0.200
    28.271    21.034     0.200
    28.804    20.718     0.200
    28.919    20.373     0.200
    29.125    19.762     0.200
    29.194    22.067     0.200
    29.618    17.611     0.200
    29.624    17.142     0.200
    29.991    19.260     0.200
    20.605    39.421     0.200
    21.161    38.939     0.200
    21.171    39.812     0.200
    21.284    38.495     0.200
    21.368    38.522     0.200
    21.808    37.184     0.200
    21.844    36.967     0.200
    22.091    38.080     0.200
    22.308    37.345     0.200
    22.445    38.952     0.200
    22.503    36.269     0.200
    22.764    33.229     0.200
    24.022    34.540     0.200
    24.348    30.738     0.200
    24.096    33.179     0.200
    24.307    33.715     0.200
    24.409    34.126     0.200
    24.515    32.796     0.200
    25.168    30.674     0.200
    25.419    28.343     0.200
    25.422    30.815     0.200
    25.612    29.991     0.200
    26.136    27.178     0.200
    26.938    27.017     0.200
    28.938    20.280     0.200
    17.148    39.721     0.200
    18.413    37.767     0.200
    18.927    37.662     0.200
    20.482    38.613     0.200
    20.858    35.024     0.200
    21.037    39.134     0.200
    21.048    38.008     0.200
    21.163    38.670     0.200
    21.245    37.712     0.200
    21.481    34.360     0.200
    21.713    36.248     0.200
    21.750    36.022     0.200
    21.953    37.045     0.200
    21.969    37.258     0.200
    22.186    37.127     0.200
    22.379    36.472     0.200
    22.402    37.006     0.200
    22.681    32.551     0.200
    22.725    32.535     0.200
    23.342    31.335     0.200
    23.443    34.456     0.200
    23.899    35.138     0.200
    23.974    33.764     0.200
    24.191    33.834     0.200
    24.289    34.382     0.200
    24.393    29.074     0.200
    24.392    33.090     0.200
    24.461    33.186     0.200
    24.441    33.411     0.200
    24.784    32.007     0.200
    25.046    31.556     0.200
    25.242    31.373     0.200
    25.286    31.049     0.200
    25.298    31.606     0.200
    25.316    28.400     0.200
    25.495    30.917     0.200
    25.744    31.306     0.200
    26.008    29.723     0.200
    26.021    29.676     0.200
    26.046    27.885     0.200
    26.816    27.593     0.200
    27.461    25.369     0.200
    27.533    21.135     0.200
    27.531    26.157     0.200
    28.111    21.780     0.200
    28.832    20.171     0.200
    19.020    37.876     0.200
    18.980    41.338     0.200
    19.498    37.291     0.200
    19.716    41.750     0.200
    20.344    41.423     0.200
    20.896    39.975     0.200
    21.037    40.330     0.200
    21.109    39.498     0.200
    21.705    38.737     0.200
    21.842    38.939     0.200
    22.189    38.895     0.200
    22.571    38.429     0.200
    22.818    33.254     0.200
    22.850    33.273     0.200
    23.387    35.611     0.200
    23.620    35.994     0.200
    23.756    36.199     0.200
    23.842    34.904     0.200
    24.096    35.638     0.200
    24.175    35.517     0.200
    24.250    34.335     0.200
    24.582    31.168     0.200
    24.633    28.765     0.200
    24.915    32.674     0.200
    25.102    33.096     0.200
    25.158    32.838     0.200
    25.280    30.123     0.200
    26.157    23.687     0.200
    26.625    27.716     0.200
    26.690    28.665     0.200
    27.540    20.940     0.200
    27.710    20.554     0.200
    28.785    21.616     0.200
    28.899    24.187     0.200
    17.199    41.043     0.200
    17.202    42.274     0.200
    18.088    39.760     0.200
    18.376    38.000     0.200
    18.594    37.556     0.200
    18.893    37.268     0.200
    20.127    36.872     0.200
    20.319    38.225     0.200
    20.890    38.458     0.200
    21.158    39.332     0.200
    21.170    40.198     0.200
    21.274    38.977     0.200
    21.398    34.234     0.200
    21.363    37.942     0.200
    21.785    38.021     0.200
    22.439    36.388     0.200
    22.506    37.609     0.200
    22.614    33.340     0.200
    22.667    33.723     0.200
    24.290    33.592     0.200
    24.283    34.061     0.200
    24.394    34.068     0.200
    24.906    33.595     0.200
    25.160    31.419     0.200
    25.371    29.170     0.200
    25.361    30.981     0.200
    25.564    27.116     0.200
    25.589    30.123     0.200
    26.128    31.832     0.200
    26.928    26.695     0.200
    27.434    21.100     0.200
    27.571    26.802     0.200
    29.540    21.516     0.200
    29.656    16.162     0.200
    16.940    40.426     0.200
    16.976    42.702     0.200
    17.987    38.507     0.200
    18.132    41.117     0.200
    18.306    38.279     0.200
    19.296    37.028     0.200
    19.590    39.098     0.200
    20.520    39.250     0.200
    20.656    37.454     0.200
    20.989    38.776     0.200
    21.519    35.791     0.200
    21.556    37.155     0.200
    21.556    35.956     0.200
    21.715    38.296     0.200
    21.898    38.167     0.200
    22.067    38.196     0.200
    22.121    37.568     0.200
    22.444    36.794     0.200
    22.650    33.186     0.200
    22.650    32.385     0.200
    22.636    36.549     0.200
    22.666    38.503     0.200
    23.319    31.882     0.200
    23.273    36.917     0.200
    23.642    36.219     0.200
    23.719    34.516     0.200
    23.948    34.241     0.200
    24.039    35.175     0.200
    24.134    34.369     0.200
    24.183    34.498     0.200
    24.402    28.546     0.200
    24.527    32.489     0.200
    24.698    31.295     0.200
    24.791    32.304     0.200
    25.103    29.759     0.200
    25.029    32.331     0.200
    25.041    32.283     0.200
    25.251    31.839     0.200
    25.574    30.962     0.200
    25.861    29.213     0.200
    25.751    30.197     0.200
    25.764    30.151     0.200
    26.563    28.028     0.200
    27.097    24.497     0.200
    27.209    25.992     0.200
    27.525    22.496     0.200
    27.856    24.636     0.200
    27.858    23.013     0.200
    28.503    21.985     0.200
    28.613    21.402     0.200
    28.666    21.383     0.200
    28.767    18.299     0.200
    28.819    20.897     0.200
    28.775    22.914     0.200
    29.328    19.861     0.200
    29.692    16.913     0.200
    16.938    40.330     0.200
    18.049    38.960     0.200
    18.889    37.463     0.200
    19.371    37.337     0.200
    21.529    37.851     0.200
    21.567    39.304     0.200
    21.650    38.334     0.200
    21.998    38.283     0.200
    22.041    37.779     0.200
    22.740    32.618     0.200
    23.432    32.138     0.200
    23.566    36.275     0.200
    23.650    34.993     0.200
    23.983    35.317     0.200
    24.724    32.766     0.200
    24.968    33.118     0.200
    25.880    30.272     0.200
    26.498    29.060     0.200
    27.147    25.193     0.200
    27.794    22.837     0.200
    28.599    21.446     0.200
    28.707    24.678     0.200
    16.997    39.967     0.200
    18.383    38.192     0.200
    19.373    37.137     0.200
    21.015    40.771     0.200
    21.580    38.683     0.200
    21.618    37.743     0.200
    21.745    38.254     0.200
    22.094    38.180     0.200
    22.729    33.275     0.200
    23.297    37.141     0.200
    23.398    31.463     0.200
    24.073    35.285     0.200
    24.159    34.083     0.200
    24.820    32.474     0.200
    25.067    32.293     0.200
    25.290    31.088     0.200
    26.593    28.692     0.200
    28.666    21.394     0.200
    16.844    37.762     0.200
    17.983    39.470     0.200
    18.295    35.920     0.200
    18.804    35.583     0.200
    19.287    34.646     0.200
    20.805    34.334     0.200
    21.435    35.182     0.200
    21.566    35.652     0.200
    21.914    35.586     0.200
    22.479    35.401     0.200
    22.662    30.863     0.200
    23.106    32.680     0.200
    23.366    29.643     0.200
    23.814    33.215     0.200
    24.470    27.366     0.200
    24.640    30.476     0.200
    25.002    28.253     0.200
    28.505    19.270     0.200
    17.200    41.602     0.200
    18.382    38.955     0.200
    18.899    38.424     0.200
    18.914    38.754     0.200
    19.834    40.711     0.200
    19.950    40.362     0.200
    20.882    40.181     0.200
    21.149    39.362     0.200
    21.161    39.229     0.200
    21.354    39.568     0.200
    21.408    35.342     0.200
    21.749    36.866     0.200
    21.785    37.851     0.200
    22.074    38.771     0.200
    22.302    38.605     0.200
    22.269    38.598     0.200
    22.430    37.412     0.200
    22.496    38.645     0.200
    22.675    33.455     0.200
    22.802    37.080     0.200
    23.263    32.996     0.200
    23.644    37.049     0.200
    24.012    35.554     0.200
    24.081    34.647     0.200
    24.305    33.541     0.200
    24.297    30.325     0.200
    24.277    34.057     0.200
    24.387    34.678     0.200
    24.504    33.818     0.200
    24.555    33.714     0.200
    24.897    32.626     0.200
    25.152    32.552     0.200
    25.369    30.221     0.200
    25.400    31.261     0.200
    25.410    31.642     0.200
    25.583    31.120     0.200
    25.945    30.801     0.200
    26.120    31.261     0.200
    26.132    30.214     0.200
    26.920    28.614     0.200
    27.127    24.603     0.200
    27.563    25.617     0.200
    28.215    21.808     0.200
    28.760    19.351     0.200
    28.891    21.420     0.200
    29.136    22.461     0.200
    29.555    21.272     0.200
    29.666    18.374     0.200
    16.454    36.532     0.200
    16.623    38.054     0.200
    17.088    37.037     0.200
    17.088    37.836     0.200
    17.899    35.263     0.200
    18.197    35.194     0.200
    18.630    35.138     0.200
    21.141    33.833     0.200
    21.175    33.942     0.200
    21.967    30.192     0.200
    23.260    31.607     0.200
    23.258    32.630     0.200
    23.329    32.800     0.200
    23.695    31.531     0.200
    23.733    30.083     0.200
    23.832    30.424     0.200
    23.991    31.178     0.200
    24.181    29.554     0.200
    24.245    29.712     0.200
    24.579    28.908     0.200
    24.794    26.907     0.200
    24.856    27.876     0.200
    25.084    28.019     0.200
    25.085    27.412     0.200
    25.145    27.608     0.200
    25.626    25.795     0.200
    25.805    25.807     0.200
    26.554    24.162     0.200
    26.766    21.195     0.200
    27.186    21.893     0.200
    27.285    23.827     0.200
    28.344    18.070     0.200
    16.578    38.745     0.200
    17.703    36.922     0.200
    19.035    35.672     0.200
    19.905    34.927     0.200
    20.618    37.406     0.200
    21.167    35.298     0.200
    21.267    32.931     0.200
    21.205    35.551     0.200
    21.346    35.904     0.200
    21.342    36.955     0.200
    22.408    31.813     0.200
    22.422    31.845     0.200
    23.156    29.781     0.200
    23.084    34.627     0.200
    23.273    34.922     0.200
    23.347    33.260     0.200
    23.571    33.940     0.200
    23.815    33.193     0.200
    24.298    27.564     0.200
    24.132    32.098     0.200
    24.480    31.038     0.200
    24.727    29.747     0.200
    25.120    26.765     0.200
    25.153    25.786     0.200
    25.573    24.574     0.200
    25.518    28.222     0.200
    25.641    26.783     0.200
    26.084    25.711     0.200
    27.208    20.194     0.200
    27.383    20.260     0.200
    28.244    20.007     0.200
    29.095    14.974     0.200
    29.647    13.732     0.200
    16.742    37.154     0.200
    16.942    39.818     0.200
    21.201    36.620     0.200
    21.314    38.303     0.200
    21.457    34.926     0.200
    21.490    36.038     0.200
    21.848    35.561     0.200
    22.148    32.559     0.200
    22.211    32.537     0.200
    22.245    35.733     0.200
    22.487    34.606     0.200
    22.768    31.126     0.200
    22.991    35.333     0.200
    23.300    32.917     0.200
    23.564    33.542     0.200
    23.794    28.357     0.200
    23.876    28.199     0.200
    23.985    32.624     0.200
    24.030    30.807     0.200
    24.144    31.868     0.200
    24.296    32.102     0.200
    24.473    30.232     0.200
    24.534    30.721     0.200
    24.752    30.877     0.200
    25.112    26.969     0.200
    25.155    28.876     0.200
    25.318    29.474     0.200
    25.375    28.612     0.200
    25.376    28.891     0.200
    26.062    25.890     0.200
    26.491    24.482     0.200
    26.870    23.857     0.200
    26.854    24.939     0.200
    26.945    20.587     0.200
    28.373    19.922     0.200
    28.663    18.927     0.200
    17.004    39.908     0.200
    17.008    39.570     0.200
    18.316    36.498     0.200
    18.613    36.134     0.200
    20.333    37.860     0.200
    21.098    33.138     0.200
    21.090    37.733     0.200
    21.288    37.419     0.200
    21.536    34.524     0.200
    21.570    34.624     0.200
    21.879    35.527     0.200
    21.995    36.172     0.200
    22.213    36.128     0.200
    22.374    30.842     0.200
    22.360    35.908     0.200
    22.951    30.007     0.200
    22.956    35.449     0.200
    23.343    33.440     0.200
    23.562    33.386     0.200
    23.610    33.123     0.200
    23.802    28.084     0.200
    23.986    27.939     0.200
    24.009    31.670     0.200
    24.443    31.695     0.200
    24.501    30.925     0.200
    24.750    31.614     0.200
    24.846    25.902     0.200
    25.136    29.812     0.200
    25.171    27.302     0.200
    25.265    25.007     0.200
    25.290    29.716     0.200
    25.343    29.596     0.200
    25.847    25.721     0.200
    26.839    26.139     0.200
    26.966    20.159     0.200
    27.133    20.211     0.200
    28.715    19.549     0.200
    16.235    37.782     0.200
    16.239    38.444     0.200
    17.369    37.857     0.200
    17.291    35.761     0.200
    18.022    36.030     0.200
    18.339    35.532     0.200
    18.342    35.499     0.200
    19.754    34.423     0.200
    20.415    32.714     0.200
    20.840    34.845     0.200
    20.975    35.270     0.200
    22.259    30.687     0.200
    22.264    30.726     0.200
    22.485    33.251     0.200
    22.882    34.713     0.200
    22.957    33.347     0.200
    23.425    32.682     0.200
    23.745    32.042     0.200
    24.090    30.822     0.200
    24.270    30.522     0.200
    24.281    31.188     0.200
    24.378    29.061     0.200
    24.241    26.963     0.200
    25.117    24.838     0.200
    16.802    38.429     0.200
    16.806    38.590     0.200
    18.735    35.973     0.200
    20.751    35.852     0.200
    21.388    35.012     0.200
    21.426    36.369     0.200
    21.960    37.336     0.200
    22.588    30.011     0.200
    23.162    33.818     0.200
    23.288    29.846     0.200
    23.482    34.184     0.200
    23.559    32.976     0.200
    24.023    31.764     0.200
    24.367    31.254     0.200
    24.693    30.242     0.200
    24.803    30.159     0.200
    24.881    30.746     0.200
    26.404    26.981     0.200
    27.503    19.251     0.200
    27.503    19.951     0.200
    27.699    20.865     0.200
    28.470    19.774     0.200
    16.669    38.706     0.200
    16.707    36.246     0.200
    17.391    35.765     0.200
    17.672    38.996     0.200
    18.503    35.391     0.200
    19.807    34.463     0.200
    20.496    34.530     0.200
    21.137    32.692     0.200
    21.235    36.012     0.200
    21.275    36.183     0.200
    21.483    34.673     0.200
    21.554    33.130     0.200
    21.738    35.891     0.200
    22.051    30.794     0.200
    22.334    30.456     0.200
    22.969    32.610     0.200
    23.119    33.650     0.200
    24.146    26.735     0.200
    24.660    29.178     0.200
    24.819    29.612     0.200
    25.399    23.706     0.200
    27.915    20.804     0.200
    28.355    18.922     0.200
    15.970    37.182     0.200
    16.947    35.430     0.200
    19.957    34.409     0.200
    20.519    34.326     0.200
    20.565    33.788     0.200
    20.737    34.270     0.200
    20.823    33.366     0.200
    20.984    34.518     0.200
    20.970    34.006     0.200
    21.124    33.260     0.200
    21.560    33.472     0.200
    21.712    32.990     0.200
    21.971    29.663     0.200
    21.980    29.700     0.200
    22.236    31.838     0.200
    22.334    34.391     0.200
    22.352    31.523     0.200
    22.345    32.898     0.200
    22.474    31.499     0.200
    22.712    32.010     0.200
    22.771    32.317     0.200
    22.774    30.911     0.200
    22.870    32.064     0.200
    23.202    30.149     0.200
    23.258    30.592     0.200
    23.686    26.499     0.200
    23.922    28.173     0.200
    23.905    28.581     0.200
    24.050    28.319     0.200
    23.987    25.986     0.200
    24.117    26.563     0.200
    24.830    25.497     0.200
    24.836    22.423     0.200
    24.865    23.269     0.200
    24.861    23.898     0.200
    25.230    24.797     0.200
    25.414    24.792     0.200
    25.611    25.184     0.200
    26.221    20.169     0.200
    27.053    17.912     0.200
    27.146    19.840     0.200
    27.220    17.907     0.200
    27.633    18.330     0.200
    16.525    38.477     0.200
    17.465    38.345     0.200
    17.481    36.259     0.200
    17.697    38.538     0.200
    18.177    35.849     0.200
    19.925    34.759     0.200
    21.048    36.043     0.200
    21.122    35.609     0.200
    21.275    36.057     0.200
    21.369    34.831     0.200
    21.489    36.631     0.200
    21.532    32.690     0.200
    21.602    36.292     0.200
    22.107    36.502     0.200
    22.431    31.146     0.200
    22.439    31.171     0.200
    22.782    33.367     0.200
    22.809    35.198     0.200
    23.014    31.890     0.200
    23.197    30.032     0.200
    23.361    34.799     0.200
    24.047    32.724     0.200
    24.072    28.138     0.200
    24.341    28.138     0.200
    24.388    30.440     0.200
    24.465    29.511     0.200
    24.520    30.761     0.200
    25.206    25.055     0.200
    25.478    25.746     0.200
    25.627    24.470     0.200
    26.099    27.146     0.200
    27.253    20.251     0.200
    27.428    20.754     0.200
    27.644    22.240     0.200
    28.075    20.120     0.200
    15.810    36.118     0.200
    16.583    36.394     0.200
    16.599    34.810     0.200
    16.858    35.375     0.200
    17.103    39.432     0.200
    17.292    35.628     0.200
    17.532    36.318     0.200
    17.800    33.999     0.200
    18.020    34.626     0.200
    20.416    33.472     0.200
    20.712    35.414     0.200
    20.712    35.614     0.200
    20.897    35.525     0.200
    21.358    33.417     0.200
    22.173    33.559     0.200
    22.249    33.479     0.200
    22.378    33.577     0.200
    22.467    29.234     0.200
    22.997    30.751     0.200
    22.997    31.352     0.200
    23.087    28.870     0.200
    23.539    30.689     0.200
    23.604    31.667     0.200
    23.604    31.768     0.200
    23.690    26.764     0.200
    23.622    31.448     0.200
    23.622    31.549     0.200
    23.663    31.112     0.200
    23.675    30.890     0.200
    23.981    30.266     0.200
    23.981    31.165     0.200
    24.095    30.982     0.200
    24.272    30.096     0.200
    24.727    28.555     0.200
    24.727    28.954     0.200
    24.883    23.732     0.200
    24.883    23.834     0.200
    25.031    25.610     0.200
    25.145    26.694     0.200
    25.339    26.567     0.200
    25.376    26.769     0.200
    25.431    26.415     0.200
    25.647    24.582     0.200
    26.022    25.153     0.200
    26.758    18.966     0.200
    26.842    23.677     0.200
    27.472    21.096     0.200
    27.680    19.388     0.200
    28.353    17.951     0.200
    28.589    17.519     0.200
    29.859    15.668     0.200
    17.648    31.501     0.200
    19.606    32.748     0.200
    19.767    31.565     0.200
    20.048    30.477     0.200
    20.332    33.499     0.200
    20.453    32.502     0.200
    20.555    33.561     0.200
    20.647    32.264     0.200
    20.789    33.915     0.200
    20.924    31.841     0.200
    21.385    32.119     0.200
    21.511    33.778     0.200
    22.060    30.713     0.200
    22.863    25.541     0.200
    22.878    30.495     0.200
    23.369    25.138     0.200
    23.594    28.131     0.200
    23.743    27.202     0.200
    23.950    25.380     0.200
    23.950    25.578     0.200
    24.094    27.662     0.200
    24.879    20.495     0.200
    24.779    23.779     0.200
    25.301    21.970     0.200
    26.145    18.121     0.200
    27.050    15.851     0.200
    27.461    17.609     0.200
    28.865    10.496     0.200
    18.804    36.413     0.200
    19.224    35.927     0.200
    20.900    34.938     0.200
    21.006    36.209     0.200
    21.027    37.542     0.200
    21.038    35.933     0.200
    21.172    38.209     0.200
    21.231    37.058     0.200
    21.659    34.867     0.200
    22.296    36.267     0.200
    23.524    34.610     0.200
    24.322    27.926     0.200
    25.078    29.871     0.200
    25.227    27.563     0.200
    27.546    24.032     0.200
    27.587    23.005     0.200
    27.590    22.686     0.200
    27.919    21.995     0.200
    28.108    21.288     0.200
    28.233    21.157     0.200
    28.645    19.447     0.200
    28.759    18.973     0.200
    28.768    18.916     0.200
    28.803    18.855     0.200
    28.965    18.261     0.200
    29.467    16.542     0.200
    20.966    36.989     0.200
    21.104    38.006     0.200
    25.294    29.903     0.200
    21.074    37.638     0.200
    21.792    36.866     0.200
    24.218    29.666     0.200
    25.392    29.472     0.200
    28.934    19.533     0.200
    17.067    40.829     0.200
    18.842    39.614     0.200
    19.246    37.297     0.200
    20.999    37.439     0.200
    21.294    41.346     0.200
    21.736    37.840     0.200
    22.429    37.183     0.200
    23.657    35.767     0.200
    24.911    30.284     0.200
    25.220    30.930     0.200
    25.321    29.501     0.200
    28.859    20.218     0.200
    21.160    37.194     0.200
    21.299    37.917     0.200
    21.456    38.739     0.200
    21.893    37.559     0.200
    22.586    37.476     0.200
    23.816    35.192     0.200
    24.353    30.089     0.200
    25.376    31.152     0.200
    25.482    28.712     0.200
    29.020    20.722     0.200
    15.466    36.175     0.200
    15.624    36.250     0.200
    15.807    36.588     0.200
    16.214    37.313     0.200
    19.758    32.422     0.200
    19.807    33.207     0.200
    20.033    33.295     0.200
    20.077    32.451     0.200
    20.261    31.906     0.200
    20.819    33.561     0.200
    20.853    30.878     0.200
    20.901    33.207     0.200
    21.024    34.229     0.200
    21.306    34.187     0.200
    21.315    33.904     0.200
    21.463    33.404     0.200
    21.821    29.476     0.200
    21.893    31.039     0.200
    22.508    31.533     0.200
    22.759    32.088     0.200
    23.304    27.400     0.200
    23.398    30.550     0.200
    23.457    30.548     0.200
    23.469    31.171     0.200
    23.709    28.463     0.200
    24.198    25.727     0.200
    24.240    28.186     0.200
    24.367    26.608     0.200
    24.766    24.004     0.200
    24.976    26.472     0.200
    25.101    25.409     0.200
    25.202    24.230     0.200
    25.187    22.839     0.200
    25.359    24.387     0.200
    25.394    24.325     0.200
    25.734    26.967     0.200
    25.826    22.532     0.200
    26.284    19.730     0.200
    26.317    22.186     0.200
    26.727    21.341     0.200
    26.851    20.926     0.200
    26.983    17.808     0.200
    27.054    20.177     0.200
    27.127    17.036     0.200
    27.782    18.073     0.200
    27.895    18.092     0.200
    28.170    15.885     0.200
    28.577    13.768     0.200
    28.605    14.969     0.200
    28.832    12.222     0.200
    29.110    13.645     0.200
    29.377    14.407     0.200
    29.634    13.870     0.200
    29.700    12.842     0.200
    14.082    37.921     0.200
    15.912    38.931     0.200
    16.337    40.958     0.200
    16.686    41.584     0.200
    16.872    38.333     0.200
    16.953    40.596     0.200
    17.078    41.927     0.200
    20.105    35.208     0.200
    20.744    36.649     0.200
    20.922    36.548     0.200
    21.061    36.718     0.200
    21.173    34.500     0.200
    21.146    38.559     0.200
    21.733    36.577     0.200
    21.747    38.060     0.200
    21.941    37.288     0.200
    21.945    36.844     0.200
    21.993    36.207     0.200
    22.172    32.970     0.200
    22.227    38.730     0.200
    22.247    37.506     0.200
    22.255    37.035     0.200
    22.289    38.548     0.200
    22.390    37.077     0.200
    22.923    32.723     0.200
    23.090    33.459     0.200
    23.147    35.364     0.200
    23.408    34.686     0.200
    23.611    34.285     0.200
    23.673    33.703     0.200
    23.713    35.429     0.200
    23.807    32.684     0.200
    24.140    30.326     0.200
    24.411    33.815     0.200
    24.566    29.275     0.200
    24.606    31.283     0.200
    24.882    31.268     0.200
    25.006    31.161     0.200
    25.107    30.053     0.200
    25.241    28.309     0.200
    25.241    29.334     0.200
    25.340    27.317     0.200
    25.577    28.676     0.200
    25.557    30.324     0.200
    25.932    30.063     0.200
    25.999    28.243     0.200
    26.085    27.318     0.200
    26.236    27.516     0.200
    26.287    26.944     0.200
    26.535    27.981     0.200
    26.706    25.992     0.200
    26.719    27.318     0.200
    26.756    27.219     0.200
    27.210    22.297     0.200
    27.227    24.366     0.200
    27.354    24.358     0.200
    27.610    24.230     0.200
    27.785    23.641     0.200
    28.085    23.280     0.200
    28.138    24.207     0.200
    28.382    21.354     0.200
    28.665    20.656     0.200
    28.782    20.550     0.200
    29.041    20.789     0.200
    29.112    18.485     0.200
    29.485    17.915     0.200
    29.999    16.312     0.200
    16.746    40.621     0.200
    17.152    41.161     0.200
    18.466    38.038     0.200
    18.921    38.185     0.200
    20.393    36.294     0.200
    20.976    37.454     0.200
    21.466    34.720     0.200
    21.471    34.747     0.200
    21.743    39.397     0.200
    21.833    36.521     0.200
    21.957    37.964     0.200
    22.031    36.851     0.200
    22.164    37.971     0.200
    22.205    37.922     0.200
    23.243    32.641     0.200
    23.304    36.855     0.200
    23.653    36.450     0.200
    23.692    35.599     0.200
    23.841    34.559     0.200
    24.363    34.671     0.200
    24.448    29.205     0.200
    24.535    30.980     0.200
    24.850    29.253     0.200
    25.005    32.681     0.200
    25.306    29.964     0.200
    25.472    31.595     0.200
    25.750    31.201     0.200
    26.141    28.444     0.200
    26.298    28.160     0.200
    26.482    28.660     0.200
    26.653    28.629     0.200
    26.766    26.735     0.200
    27.252    25.592     0.200
    27.521    22.135     0.200
    27.767    24.772     0.200
    27.992    24.478     0.200
    28.439    22.431     0.200
    28.722    21.817     0.200
    28.834    21.399     0.200
    29.545    18.791     0.200
    14.871    42.829     0.200
    15.618    44.577     0.200
    15.778    44.541     0.200
    15.935    41.981     0.200
    16.383    44.415     0.200
    18.451    38.974     0.200
    20.133    40.534     0.200
    20.484    39.635     0.200
    21.139    39.714     0.200
    21.145    39.740     0.200
    21.116    41.338     0.200
    21.170    41.374     0.200
    21.197    41.647     0.200
    22.115    41.071     0.200
    22.269    39.853     0.200
    22.480    39.843     0.200
    22.555    38.671     0.200
    22.751    39.126     0.200
    23.192    38.829     0.200
    23.258    39.068     0.200
    23.763    36.394     0.200
    23.965    36.846     0.200
    24.009    36.586     0.200
    24.292    37.034     0.200
    24.496    34.851     0.200
    24.463    35.646     0.200
    24.635    36.770     0.200
    24.764    32.159     0.200
    24.716    35.329     0.200
    25.299    32.638     0.200
    25.421    31.628     0.200
    25.366    34.201     0.200
    25.460    31.862     0.200
    25.510    33.445     0.200
    26.319    30.375     0.200
    26.725    29.804     0.200
    26.900    30.374     0.200
    26.970    29.383     0.200
    27.114    28.912     0.200
    27.601    26.187     0.200
    27.805    27.646     0.200
    27.816    28.241     0.200
    27.880    26.169     0.200
    27.977    24.871     0.200
    27.938    25.379     0.200
    28.713    23.531     0.200
    15.866    41.930     0.200
    15.887    42.973     0.200
    15.928    40.647     0.200
    16.017    39.292     0.200
    16.030    40.809     0.200
    16.040    44.231     0.200
    16.093    42.097     0.200
    16.120    43.005     0.200
    16.120    42.166     0.200
    16.279    41.145     0.200
    16.289    43.686     0.200
    16.317    42.415     0.200
    16.457    40.804     0.200
    16.694    42.152     0.200
    16.747    42.687     0.200
    16.801    42.559     0.200
    16.820    43.196     0.200
    16.835    42.599     0.200
    16.845    43.387     0.200
    16.868    43.635     0.200
    16.943    43.109     0.200
    17.071    42.524     0.200
    17.184    43.067     0.200
    17.606    43.114     0.200
    18.215    43.486     0.200
    18.785    38.020     0.200
    19.659    38.902     0.200
    20.285    37.686     0.200
    20.391    36.136     0.200
    20.539    37.059     0.200
    20.696    36.962     0.200
    20.842    36.570     0.200
    21.032    36.325     0.200
    21.244    38.669     0.200
    21.241    35.154     0.200
    21.246    35.204     0.200
    21.253    37.103     0.200
    21.275    41.228     0.200
    21.459    39.764     0.200
    21.574    41.628     0.200
    21.624    35.160     0.200
    21.776    41.044     0.200
    21.852    38.792     0.200
    21.852    35.328     0.200
    21.888    34.772     0.200
    22.047    37.462     0.200
    22.051    37.697     0.200
    22.099    37.173     0.200
    22.188    39.494     0.200
    22.242    33.394     0.200
    22.353    38.084     0.200
    22.350    37.823     0.200
    22.492    37.374     0.200
    22.506    37.524     0.200
    22.614    31.829     0.200
    22.832    33.608     0.200
    22.976    31.856     0.200
    23.170    33.497     0.200
    23.253    35.445     0.200
    23.493    36.132     0.200
    23.515    34.992     0.200
    23.714    35.245     0.200
    23.815    35.904     0.200
    23.983    34.383     0.200
    23.982    36.326     0.200
    24.126    33.505     0.200
    24.443    34.481     0.200
    24.497    33.873     0.200
    24.514    34.191     0.200
    24.638    29.979     0.200
    24.854    29.502     0.200
    24.861    29.250     0.200
    24.981    31.506     0.200
    24.971    28.284     0.200
    24.973    27.042     0.200
    25.111    31.821     0.200
    25.103    29.834     0.200
    25.347    29.630     0.200
    25.391    27.361     0.200
    25.636    30.743     0.200
    25.657    31.037     0.200
    25.684    28.108     0.200
    26.007    30.644     0.200
    26.026    27.923     0.200
    26.106    28.412     0.200
    26.394    27.481     0.200
    26.820    28.022     0.200
    26.856    27.922     0.200
    26.910    23.469     0.200
    27.244    26.207     0.200
    27.222    27.915     0.200
    27.268    22.623     0.200
    27.334    24.912     0.200
    27.446    26.422     0.200
    27.460    24.397     0.200
    27.717    24.490     0.200
    27.890    23.904     0.200
    27.839    21.187     0.200
    28.055    23.491     0.200
    28.189    23.844     0.200
    28.210    24.850     0.200
    28.238    24.988     0.200
    28.488    21.759     0.200
    28.772    21.221     0.200
    28.889    20.606     0.200
    29.123    21.387     0.200
    29.230    21.282     0.200
    29.252    21.323     0.200
    29.426    20.080     0.200
    29.591    18.411     0.200
    29.560    21.670     0.200
    17.167    41.024     0.200
    20.327    36.143     0.200
    20.631    35.210     0.200
    20.804    35.832     0.200
    21.174    34.034     0.200
    21.179    34.276     0.200
    21.773    36.272     0.200
    22.043    37.123     0.200
    22.090    35.407     0.200
    22.176    32.119     0.200
    22.359    36.503     0.200
    22.374    36.913     0.200
    23.111    33.434     0.200
    23.514    35.219     0.200
    23.506    34.083     0.200
    24.453    32.989     0.200
    24.517    33.085     0.200
    24.524    33.590     0.200
    25.111    31.216     0.200
    25.317    26.492     0.200
    25.676    30.230     0.200
    26.026    29.840     0.200
    26.097    27.859     0.200
    26.383    26.593     0.200
    26.835    26.975     0.200
    26.874    26.900     0.200
    27.197    22.054     0.200
    27.328    23.781     0.200
    27.894    22.519     0.200
    28.044    22.799     0.200
    28.255    22.458     0.200
    28.759    20.305     0.200
    28.877    20.298     0.200
    29.138    20.749     0.200
    29.577    17.403     0.200
    16.829    41.197     0.200
    17.220    41.711     0.200
    18.307    37.607     0.200
    21.253    34.346     0.200
    21.871    36.257     0.200
    22.251    32.545     0.200
    22.392    37.486     0.200
    23.553    35.375     0.200
    24.555    33.110     0.200
    24.750    33.084     0.200
    28.092    24.375     0.200
    28.808    20.290     0.200
    28.926    19.734     0.200
    14.211    41.947     0.200
    16.008    40.845     0.200
    22.335    37.483     0.200
    22.482    38.266     0.200
    28.784    20.870     0.200
    14.239    39.745     0.200
    16.062    40.564     0.200
    16.494    41.863     0.200
    17.021    38.260     0.200
    20.896    36.054     0.200
    21.289    33.156     0.200
    21.293    34.277     0.200
    22.094    36.973     0.200
    22.098    36.970     0.200
    22.148    35.940     0.200
    22.391    37.304     0.200
    22.393    36.471     0.200
    22.290    31.666     0.200
    22.545    36.295     0.200
    24.485    33.334     0.200
    24.556    33.596     0.200
    25.157    30.506     0.200
    25.397    27.976     0.200
    26.079    27.197     0.200
    27.382    23.979     0.200
    28.538    20.333     0.200
    28.822    19.897     0.200
    28.938    20.024     0.200
    29.641    16.854     0.200
    17.164    39.126     0.200
    21.331    33.514     0.200
    21.829    36.296     0.200
    22.003    36.228     0.200
    22.284    37.103     0.200
    24.375    33.400     0.200
    24.445    34.066     0.200
    24.722    27.691     0.200
    27.293    24.390     0.200
    28.860    20.470     0.200
    16.014    40.173     0.200
    17.877    44.267     0.200
    20.381    37.564     0.200
    20.686    37.273     0.200
    20.834    37.492     0.200
    21.022    36.424     0.200
    21.235    35.603     0.200
    21.060    40.514     0.200
    21.288    40.728     0.200
    21.243    37.664     0.200
    21.841    36.278     0.200
    21.849    39.260     0.200
    22.043    38.195     0.200
    22.047    38.211     0.200
    22.094    37.687     0.200
    22.232    33.984     0.200
    22.190    39.541     0.200
    22.348    38.348     0.200
    22.603    33.550     0.200
    22.490    38.169     0.200
    22.691    33.574     0.200
    22.504    38.279     0.200
    22.822    35.046     0.200
    22.965    32.410     0.200
    22.979    33.314     0.200
    23.510    35.603     0.200
    23.493    37.927     0.200
    23.712    35.911     0.200
    23.775    35.035     0.200
    23.813    36.270     0.200
    24.038    31.019     0.200
    23.979    34.843     0.200
    24.266    31.928     0.200
    24.441    34.813     0.200
    24.511    35.159     0.200
    24.496    34.861     0.200
    24.708    32.365     0.200
    24.850    29.176     0.200
    24.960    28.190     0.200
    24.980    32.854     0.200
    25.247    28.960     0.200
    25.108    32.427     0.200
    25.209    30.820     0.200
    25.379    28.208     0.200
    25.341    30.090     0.200
    25.283    31.609     0.200
    25.716    28.966     0.200
    25.633    31.147     0.200
    25.656    31.546     0.200
    25.903    30.935     0.200
    26.019    28.573     0.200
    26.005    31.341     0.200
    26.389    27.677     0.200
    26.900    23.479     0.200
    26.818    28.507     0.200
    26.854    28.675     0.200
    27.257    22.938     0.200
    27.238    26.749     0.200
    27.329    25.093     0.200
    27.444    27.093     0.200
    27.711    24.889     0.200
    27.887    24.668     0.200
    28.050    23.983     0.200
    28.186    24.321     0.200
    28.208    25.233     0.200
    28.237    25.559     0.200
    28.483    22.268     0.200
    28.766    21.722     0.200
    28.884    21.683     0.200
    29.121    21.852     0.200
    29.213    19.712     0.200
    29.586    18.752     0.200
    16.181    40.508     0.200
    24.120    35.714     0.200
    24.734    32.752     0.200
    16.439    40.004     0.200
    17.097    40.686     0.200
    20.164    35.222     0.200
    20.600    37.443     0.200
    20.951    38.221     0.200
    20.937    36.529     0.200
    21.132    37.130     0.200
    21.233    34.226     0.200
    21.669    38.087     0.200
    21.751    37.967     0.200
    21.756    36.379     0.200
    21.952    36.684     0.200
    22.005    36.622     0.200
    22.242    37.508     0.200
    22.231    32.502     0.200
    22.243    36.949     0.200
    22.240    33.880     0.200
    22.382    36.654     0.200
    22.395    36.564     0.200
    22.611    32.670     0.200
    22.811    32.799     0.200
    22.987    32.404     0.200
    23.143    32.856     0.200
    23.157    35.241     0.200
    23.420    34.273     0.200
    23.607    34.901     0.200
    23.681    34.379     0.200
    23.818    33.122     0.200
    23.887    33.201     0.200
    24.284    31.681     0.200
    24.406    33.653     0.200
    24.624    29.352     0.200
    24.869    30.097     0.200
    24.879    28.604     0.200
    24.985    28.592     0.200
    25.108    27.516     0.200
    25.166    29.469     0.200
    25.241    27.616     0.200
    25.258    29.274     0.200
    25.532    29.709     0.200
    25.592    28.269     0.200
    25.797    30.503     0.200
    25.895    29.360     0.200
    25.927    28.623     0.200
    26.101    26.840     0.200
    26.253    26.973     0.200
    26.529    28.612     0.200
    26.710    26.856     0.200
    26.722    25.570     0.200
    27.237    24.304     0.200
    27.273    21.333     0.200
    27.626    23.797     0.200
    27.829    21.098     0.200
    27.961    22.996     0.200
    28.083    23.160     0.200
    28.398    21.195     0.200
    28.797    20.486     0.200
    29.501    17.451     0.200
    29.707    19.743     0.200
    20.096    37.315     0.200
    21.165    36.123     0.200
    22.053    38.478     0.200
    22.373    38.283     0.200
    24.560    31.004     0.200
    24.538    34.375     0.200
    25.338    30.142     0.200
    16.770    41.753     0.200
    17.034    42.910     0.200
    17.421    42.614     0.200
    18.419    39.586     0.200
    20.265    37.404     0.200
    20.489    38.380     0.200
    20.640    37.799     0.200
    20.859    40.313     0.200
    20.933    39.804     0.200
    21.034    37.692     0.200
    21.105    40.778     0.200
    21.273    38.709     0.200
    21.324    35.823     0.200
    21.328    36.617     0.200
    21.510    40.578     0.200
    22.065    38.130     0.200
    22.110    40.150     0.200
    22.300    39.129     0.200
    22.305    38.761     0.200
    22.347    37.601     0.200
    22.619    38.751     0.200
    22.756    38.390     0.200
    23.013    33.530     0.200
    23.763    35.890     0.200
    23.759    37.213     0.200
    23.977    36.394     0.200
    24.031    35.303     0.200
    24.162    33.721     0.200
    24.234    35.359     0.200
    24.731    30.839     0.200
    24.706    35.124     0.200
    24.777    35.711     0.200
    24.960    32.575     0.200
    25.246    33.974     0.200
    25.368    32.679     0.200
    25.463    31.077     0.200
    25.586    30.835     0.200
    25.897    31.178     0.200
    26.169    32.465     0.200
    26.272    31.729     0.200
    26.435    28.421     0.200
    26.584    28.658     0.200
    26.901    28.971     0.200
    27.085    28.148     0.200
    27.585    25.674     0.200
    27.702    25.782     0.200
    28.451    24.203     0.200
    28.504    25.169     0.200
    28.730    22.629     0.200
    29.014    21.997     0.200
    29.133    22.006     0.200
    14.872    39.207     0.200
    15.570    42.904     0.200
    15.730    39.801     0.200
    15.892    41.492     0.200
    16.333    42.629     0.200
    21.022    38.666     0.200
    21.133    38.537     0.200
    21.207    38.592     0.200
    22.305    36.354     0.200
    23.213    36.629     0.200
    23.280    36.054     0.200
    24.455    32.428     0.200
    14.016    37.661     0.200
    14.031    38.513     0.200
    14.791    37.309     0.200
    16.643    40.860     0.200
    20.543    36.243     0.200
    21.923    36.349     0.200
    22.263    35.535     0.200
    23.378    32.755     0.200
    24.359    31.514     0.200
    24.430    31.381     0.200
    24.998    29.017     0.200
    25.194    26.470     0.200
    21.236    37.453     0.200
    21.614    37.795     0.200
    22.280    37.162     0.200
    22.618    37.477     0.200
    22.792    36.679     0.200
    24.009    34.803     0.200
    24.785    33.699     0.200
    25.355    31.871     0.200
    25.355    32.145     0.200
    25.544    29.369     0.200
    25.544    29.758     0.200
    27.561    24.614     0.200
    28.691    21.030     0.200
    14.077    37.959     0.200
    15.800    39.960     0.200
    16.280    40.586     0.200
    16.361    41.205     0.200
    16.437    40.573     0.200
    16.623    41.239     0.200
    17.025    41.551     0.200
    17.025    41.121     0.200
    20.228    36.296     0.200
    20.554    35.742     0.200
    20.761    37.055     0.200
    21.094    39.735     0.200
    21.301    35.270     0.200
    21.565    35.527     0.200
    21.663    36.205     0.200
    21.698    38.216     0.200
    21.850    37.913     0.200
    21.853    38.597     0.200
    22.277    33.811     0.200
    22.294    33.235     0.200
    22.260    39.133     0.200
    22.552    33.683     0.200
    22.432    39.052     0.200
    22.860    34.866     0.200
    23.083    32.699     0.200
    23.065    37.006     0.200
    23.138    36.918     0.200
    23.183    33.724     0.200
    23.331    35.733     0.200
    23.485    36.829     0.200
    23.560    35.636     0.200
    23.584    35.681     0.200
    23.576    36.805     0.200
    23.690    31.872     0.200
    23.727    36.018     0.200
    23.794    31.835     0.200
    24.211    34.816     0.200
    24.245    35.024     0.200
    24.281    35.568     0.200
    24.496    32.502     0.200
    24.531    32.979     0.200
    24.684    29.381     0.200
    25.024    31.904     0.200
    25.083    29.601     0.200
    25.041    31.806     0.200
    25.182    30.835     0.200
    25.417    31.105     0.200
    25.671    32.033     0.200
    25.904    27.751     0.200
    26.402    29.524     0.200
    26.579    29.356     0.200
    27.292    25.453     0.200
    27.359    22.386     0.200
    27.545    25.625     0.200
    27.673    24.222     0.200
    27.892    22.277     0.200
    28.318    22.684     0.200
    28.601    22.159     0.200
    29.930    17.703     0.200
    29.876    21.036     0.200
    15.710    39.100     0.200
    16.348    39.516     0.200
    16.419    39.322     0.200
    16.507    39.028     0.200
    16.678    38.588     0.200
    17.105    39.723     0.200
    17.105    39.402     0.200
    18.733    36.473     0.200
    19.469    36.327     0.200
    20.726    34.708     0.200
    20.917    35.313     0.200
    21.098    34.695     0.200
    21.538    35.034     0.200
    21.809    33.723     0.200
    21.824    35.974     0.200
    21.817    36.709     0.200
    21.926    35.591     0.200
    22.140    34.717     0.200
    22.076    36.287     0.200
    22.648    32.974     0.200
    22.705    32.696     0.200
    22.791    31.718     0.200
    22.993    31.694     0.200
    23.061    34.863     0.200
    23.123    35.318     0.200
    23.216    31.471     0.200
    23.321    32.118     0.200
    23.338    34.125     0.200
    23.345    34.789     0.200
    23.565    34.045     0.200
    23.619    31.802     0.200
    23.651    30.086     0.200
    24.129    34.082     0.200
    24.228    29.912     0.200
    24.231    30.119     0.200
    24.271    30.513     0.200
    24.294    32.562     0.200
    24.543    31.340     0.200
    25.015    30.492     0.200
    25.241    29.031     0.200
    25.241    29.075     0.200
    25.509    30.350     0.200
    25.656    26.848     0.200
    25.654    30.238     0.200
    25.771    26.808     0.200
    26.070    27.195     0.200
    26.266    26.966     0.200
    26.241    28.163     0.200
    26.393    27.269     0.200
    27.122    25.207     0.200
    27.291    21.836     0.200
    27.587    21.331     0.200
    27.586    24.264     0.200
    27.573    23.578     0.200
    27.707    21.167     0.200
    27.886    20.916     0.200
    27.907    20.316     0.200
    27.832    23.842     0.200
    27.893    23.494     0.200
    28.641    20.608     0.200
    28.814    19.388     0.200
    29.469    18.420     0.200
    29.563    16.186     0.200
    29.779    15.048     0.200
    29.957    16.708     0.200
    24.257    32.298     0.200
    14.125    38.062     0.200
    14.158    38.631     0.200
    15.818    38.984     0.200
    16.339    40.462     0.200
    16.418    40.883     0.200
    17.088    40.997     0.200
    20.869    36.897     0.200
    20.908    38.090     0.200
    21.219    37.632     0.200
    21.461    34.864     0.200
    21.687    35.965     0.200
    21.773    37.274     0.200
    21.817    36.630     0.200
    21.884    38.071     0.200
    21.961    37.342     0.200
    22.197    35.783     0.200
    22.247    39.048     0.200
    22.421    34.824     0.200
    22.452    33.158     0.200
    22.699    33.659     0.200
    22.851    33.197     0.200
    23.011    33.844     0.200
    23.107    36.816     0.200
    23.177    36.769     0.200
    23.329    33.984     0.200
    23.376    35.988     0.200
    23.490    35.993     0.200
    23.571    36.084     0.200
    23.604    35.309     0.200
    23.770    35.299     0.200
    23.855    31.723     0.200
    23.949    32.512     0.200
    24.077    34.509     0.200
    24.225    34.911     0.200
    24.283    34.883     0.200
    24.577    33.038     0.200
    24.709    32.893     0.200
    24.841    29.531     0.200
    25.032    31.849     0.200
    25.065    31.827     0.200
    25.156    28.278     0.200
    25.253    29.036     0.200
    25.240    29.607     0.200
    25.450    28.215     0.200
    25.432    31.476     0.200
    25.560    30.021     0.200
    25.670    31.417     0.200
    25.739    30.968     0.200
    25.989    28.534     0.200
    26.219    28.472     0.200
    26.275    28.571     0.200
    26.402    29.256     0.200
    26.571    28.607     0.200
    26.592    28.529     0.200
    27.179    26.409     0.200
    27.328    22.918     0.200
    27.510    22.768     0.200
    27.526    22.399     0.200
    27.599    25.405     0.200
    27.923    24.772     0.200
    28.051    21.612     0.200
    28.037    22.256     0.200
    28.372    22.750     0.200
    28.872    22.601     0.200
    28.978    20.435     0.200
    28.978    20.194     0.200
    29.416    17.202     0.200
    29.431    20.794     0.200
    29.478    19.257     0.200
    29.757    18.911     0.200
    29.980    17.624     0.200
    29.951    21.320     0.200
    15.392    41.475     0.200
    15.550    41.958     0.200
    15.995    41.854     0.200
    16.327    40.020     0.200
    16.750    42.252     0.200
    20.799    36.529     0.200
    20.984    38.854     0.200
    21.484    37.819     0.200
    21.491    35.946     0.200
    22.360    34.290     0.200
    22.468    33.709     0.200
    23.924    31.819     0.200
    23.932    31.873     0.200
    24.515    34.805     0.200
    24.846    30.225     0.200
    24.890    31.938     0.200
    25.234    28.641     0.200
    25.903    30.022     0.200
    27.585    21.552     0.200
    27.609    21.274     0.200
    16.177    38.744     0.200
    19.909    34.777     0.200
    20.216    34.606     0.200
    20.978    33.504     0.200
    21.326    35.085     0.200
    21.562    35.265     0.200
    21.843    34.811     0.200
    24.227    32.468     0.200
    24.298    32.360     0.200
    24.369    28.936     0.200
    25.081    28.259     0.200
    15.639    42.726     0.200
    18.928    39.821     0.200
    19.840    39.342     0.200
    20.159    37.458     0.200
    20.525    36.008     0.200
    20.543    39.152     0.200
    20.644    38.930     0.200
    20.783    38.990     0.200
    21.154    37.467     0.200
    21.165    39.036     0.200
    21.176    37.511     0.200
    21.251    39.138     0.200
    21.420    34.517     0.200
    21.627    34.299     0.200
    22.074    37.410     0.200
    22.175    38.387     0.200
    22.302    36.498     0.200
    22.359    37.147     0.200
    22.530    37.712     0.200
    22.585    32.367     0.200
    22.577    37.563     0.200
    22.586    35.958     0.200
    22.643    34.835     0.200
    22.806    34.736     0.200
    22.787    35.909     0.200
    22.970    36.260     0.200
    23.073    32.620     0.200
    23.154    34.667     0.200
    23.305    32.664     0.200
    23.292    35.975     0.200
    23.309    36.185     0.200
    23.606    31.248     0.200
    23.666    35.456     0.200
    23.793    33.821     0.200
    24.026    31.832     0.200
    24.021    34.206     0.200
    24.106    30.944     0.200
    24.253    32.498     0.200
    24.509    33.118     0.200
    24.520    32.177     0.200
    24.835    33.170     0.200
    25.326    29.503     0.200
    25.406    28.257     0.200
    25.404    29.611     0.200
    25.404    29.644     0.200
    25.430    29.759     0.200
    25.468    29.290     0.200
    25.560    31.608     0.200
    25.565    31.553     0.200
    25.614    29.211     0.200
    25.679    28.360     0.200
    25.858    28.797     0.200
    25.994    28.263     0.200
    26.153    29.858     0.200
    26.354    27.524     0.200
    26.375    28.313     0.200
    26.770    26.226     0.200
    26.957    26.770     0.200
    27.035    24.826     0.200
    27.144    27.443     0.200
    27.494    24.021     0.200
    27.602    23.733     0.200
    27.597    25.501     0.200
    27.628    24.319     0.200
    27.675    24.998     0.200
    27.861    24.965     0.200
    27.991    22.522     0.200
    27.991    22.381     0.200
    28.398    21.408     0.200
    28.427    23.006     0.200
    28.639    22.491     0.200
    28.739    21.685     0.200
    28.779    19.931     0.200
    28.867    20.236     0.200
    29.286    19.089     0.200
    29.294    21.768     0.200
    29.417    20.059     0.200
    29.560    19.589     0.200
    29.640    20.314     0.200
    29.697    17.268     0.200
    29.835    18.499     0.200
    29.844    19.248     0.200
    29.855    18.373     0.200
    16.678    40.091     0.200
    17.113    39.999     0.200
    17.628    40.231     0.200
    17.755    40.410     0.200
    17.791    40.491     0.200
    17.889    40.310     0.200
    18.037    41.007     0.200
    18.135    40.530     0.200
    18.164    40.406     0.200
    18.185    40.752     0.200
    18.370    37.404     0.200
    18.875    39.145     0.200
    19.043    39.326     0.200
    19.114    36.733     0.200
    19.234    39.047     0.200
    19.600    38.507     0.200
    19.797    38.375     0.200
    19.946    39.137     0.200
    20.142    38.737     0.200
    20.158    38.729     0.200
    20.177    39.170     0.200
    20.301    38.945     0.200
    20.399    35.622     0.200
    20.408    38.667     0.200
    20.469    36.937     0.200
    20.552    36.599     0.200
    20.533    38.873     0.200
    20.581    38.588     0.200
    20.807    35.443     0.200
    20.746    38.753     0.200
    20.764    38.290     0.200
    20.839    38.172     0.200
    20.913    35.673     0.200
    20.891    38.825     0.200
    20.925    38.688     0.200
    21.052    38.276     0.200
    21.123    38.604     0.200
    21.164    38.386     0.200
    21.153    38.104     0.200
    21.192    37.772     0.200
    21.396    36.081     0.200
    21.401    37.625     0.200
    21.489    34.810     0.200
    21.496    35.104     0.200
    21.470    37.855     0.200
    21.484    37.108     0.200
    21.483    37.823     0.200
    21.505    35.516     0.200
    21.507    38.043     0.200
    21.683    37.833     0.200
    21.694    37.612     0.200
    21.877    37.633     0.200
    22.067    36.732     0.200
    22.066    36.770     0.200
    22.149    36.861     0.200
    22.147    37.205     0.200
    22.339    32.578     0.200
    22.282    36.749     0.200
    22.462    32.942     0.200
    22.633    32.654     0.200
    22.577    36.384     0.200
    22.619    36.410     0.200
    22.621    36.424     0.200
    22.646    36.947     0.200
    22.668    36.545     0.200
    22.705    34.707     0.200
    22.724    35.402     0.200
    22.740    36.688     0.200
    22.779    35.589     0.200
    22.910    32.710     0.200
    22.881    34.991     0.200
    22.953    36.619     0.200
    23.020    35.661     0.200
    23.017    36.160     0.200
    23.041    35.548     0.200
    23.081    36.163     0.200
    23.141    35.822     0.200
    23.188    35.330     0.200
    23.257    31.572     0.200
    23.307    34.628     0.200
    23.348    34.453     0.200
    23.370    35.899     0.200
    23.381    35.392     0.200
    23.474    35.317     0.200
    23.497    35.627     0.200
    23.558    35.129     0.200
    23.577    34.618     0.200
    23.582    35.162     0.200
    23.651    35.554     0.200
    23.740    34.935     0.200
    23.792    34.569     0.200
    23.833    33.968     0.200
    23.831    34.606     0.200
    23.929    31.119     0.200
    23.930    31.477     0.200
    23.916    34.553     0.200
    23.914    34.059     0.200
    23.932    33.520     0.200
    23.935    34.400     0.200
    24.042    33.400     0.200
    24.122    31.427     0.200
    24.137    33.507     0.200
    24.177    33.452     0.200
    24.216    33.408     0.200
    24.367    34.009     0.200
    24.383    33.234     0.200
    24.454    32.698     0.200
    24.473    32.382     0.200
    24.473    32.757     0.200
    24.504    32.164     0.200
    24.593    32.622     0.200
    24.621    31.758     0.200
    24.662    31.895     0.200
    24.670    32.085     0.200
    24.678    32.195     0.200
    24.839    28.506     0.200
    24.816    30.331     0.200
    24.808    31.605     0.200
    24.818    32.636     0.200
    24.874    30.974     0.200
    24.901    31.550     0.200
    24.914    31.370     0.200
    24.912    31.257     0.200
    24.915    32.125     0.200
    24.928    31.791     0.200
    25.034    31.322     0.200
    25.123    31.683     0.200
    25.237    27.957     0.200
    25.196    30.624     0.200
    25.211    30.590     0.200
    25.230    30.612     0.200
    25.264    31.127     0.200
    25.429    27.321     0.200
    25.390    29.907     0.200
    25.396    30.226     0.200
    25.485    28.909     0.200
    25.543    30.101     0.200
    25.581    29.208     0.200
    25.582    29.448     0.200
    25.590    30.051     0.200
    25.643    27.819     0.200
    25.636    28.231     0.200
    25.719    28.524     0.200
    25.778    27.784     0.200
    25.780    29.060     0.200
    25.827    29.111     0.200
    25.818    29.118     0.200
    25.835    28.598     0.200
    25.844    28.793     0.200
    25.854    29.553     0.200
    25.914    28.685     0.200
    25.941    28.769     0.200
    25.985    29.150     0.200
    26.014    29.074     0.200
    26.024    28.813     0.200
    26.092    28.186     0.200
    26.186    28.539     0.200
    26.189    28.785     0.200
    26.201    28.604     0.200
    26.240    27.633     0.200
    26.302    28.411     0.200
    26.437    27.361     0.200
    26.525    27.085     0.200
    26.558    27.642     0.200
    26.616    26.491     0.200
    26.788    26.773     0.200
    26.849    25.492     0.200
    26.909    22.944     0.200
    26.894    27.182     0.200
    26.959    26.321     0.200
    27.042    25.068     0.200
    27.115    24.997     0.200
    27.122    25.318     0.200
    27.312    25.857     0.200
    27.415    21.367     0.200
    27.362    24.882     0.200
    27.391    24.373     0.200
    27.471    24.497     0.200
    27.481    23.604     0.200
    27.591    21.271     0.200
    27.617    20.882     0.200
    27.633    24.022     0.200
    27.790    24.185     0.200
    27.794    23.162     0.200
    27.833    23.043     0.200
    27.918    24.163     0.200
    27.936    22.360     0.200
    28.061    21.184     0.200
    28.048    22.103     0.200
    28.053    23.009     0.200
    28.212    22.818     0.200
    28.141    22.670     0.200
    28.149    21.661     0.200
    28.312    22.551     0.200
    28.376    22.129     0.200
    28.397    21.819     0.200
    28.470    20.929     0.200
    28.645    20.710     0.200
    28.726    20.342     0.200
    28.769    19.988     0.200
    28.956    19.753     0.200
    28.957    19.939     0.200
    29.064    19.073     0.200
    29.221    19.884     0.200
    29.680    18.337     0.200
    29.891    14.824     0.200
    29.975    16.023     0.200
    14.743    37.703     0.200
    16.255    36.697     0.200
    16.513    37.869     0.200
    16.513    38.205     0.200
    19.864    34.022     0.200
    20.724    33.819     0.200
    21.149    34.187     0.200
    21.425    34.123     0.200
    21.994    30.446     0.200
    23.152    31.196     0.200
    23.965    30.347     0.200
    23.986    27.810     0.200
    24.680    26.679     0.200
    25.713    24.434     0.200
    26.654    21.780     0.200
    27.827    18.949     0.200
    15.573    38.890     0.200
    15.785    39.644     0.200
    16.373    39.620     0.200
    16.373    39.364     0.200
    16.373    40.194     0.200
    16.658    39.520     0.200
    16.788    40.004     0.200
    17.180    39.577     0.200
    17.270    41.093     0.200
    17.270    41.293     0.200
    17.270    40.765     0.200
    17.361    40.333     0.200
    17.596    40.570     0.200
    17.631    41.346     0.200
    17.692    40.887     0.200
    17.688    41.172     0.200
    17.978    40.673     0.200
    17.991    41.403     0.200
    17.998    41.139     0.200
    17.998    41.573     0.200
    17.965    41.547     0.200
    17.984    41.611     0.200
    18.066    41.285     0.200
    18.089    40.983     0.200
    19.176    37.283     0.200
    19.843    37.583     0.200
    20.127    38.053     0.200
    20.457    36.995     0.200
    20.521    36.254     0.200
    20.997    35.618     0.200
    21.012    38.538     0.200
    21.125    37.608     0.200
    21.142    37.705     0.200
    21.187    38.963     0.200
    21.187    39.098     0.200
    21.212    38.693     0.200
    21.402    35.863     0.200
    21.362    38.324     0.200
    21.482    37.931     0.200
    21.624    34.147     0.200
    21.582    38.063     0.200
    21.647    38.656     0.200
    21.676    38.586     0.200
    21.770    38.068     0.200
    22.036    37.310     0.200
    22.080    38.129     0.200
    22.115    38.379     0.200
    22.138    37.998     0.200
    22.135    37.853     0.200
    22.204    37.417     0.200
    22.268    36.702     0.200
    22.248    38.194     0.200
    22.275    37.387     0.200
    22.325    36.996     0.200
    22.354    36.462     0.200
    22.462    37.049     0.200
    22.492    36.925     0.200
    22.492    37.959     0.200
    22.581    32.719     0.200
    22.552    36.255     0.200
    22.501    37.049     0.200
    22.538    37.619     0.200
    22.531    36.956     0.200
    22.562    36.686     0.200
    22.615    35.803     0.200
    22.678    33.784     0.200
    22.577    37.291     0.200
    22.752    35.923     0.200
    22.820    33.820     0.200
    22.778    35.710     0.200
    22.766    36.108     0.200
    22.854    35.905     0.200
    22.889    36.887     0.200
    22.893    36.582     0.200
    22.936    35.820     0.200
    23.040    33.248     0.200
    22.991    36.015     0.200
    22.965    36.432     0.200
    22.983    36.391     0.200
    23.124    35.418     0.200
    23.105    36.090     0.200
    23.115    36.536     0.200
    23.146    35.556     0.200
    23.142    36.859     0.200
    23.295    32.777     0.200
    23.271    36.288     0.200
    23.289    35.288     0.200
    23.352    36.394     0.200
    23.419    35.388     0.200
    23.422    35.425     0.200
    23.436    35.391     0.200
    23.453    35.451     0.200
    23.491    34.399     0.200
    23.477    35.416     0.200
    23.610    31.403     0.200
    23.590    35.036     0.200
    23.617    34.604     0.200
    23.626    34.822     0.200
    23.690    35.114     0.200
    23.710    34.993     0.200
    23.759    33.343     0.200
    23.774    34.244     0.200
    23.868    35.696     0.200
    23.889    35.676     0.200
    23.914    34.800     0.200
    24.020    32.127     0.200
    23.982    34.066     0.200
    24.013    34.504     0.200
    24.041    33.904     0.200
    24.070    34.059     0.200
    24.090    34.227     0.200
    24.219    32.922     0.200
    24.223    33.168     0.200
    24.206    33.586     0.200
    24.235    34.031     0.200
    24.249    33.703     0.200
    24.297    33.770     0.200
    24.335    34.196     0.200
    24.411    34.012     0.200
    24.444    32.989     0.200
    24.437    33.707     0.200
    24.435    33.664     0.200
    24.489    31.283     0.200
    24.488    31.054     0.200
    24.471    33.355     0.200
    24.508    32.584     0.200
    24.525    33.030     0.200
    24.713    28.987     0.200
    24.648    33.676     0.200
    24.709    32.448     0.200
    24.709    33.226     0.200
    24.733    32.478     0.200
    24.767    31.283     0.200
    24.751    33.189     0.200
    24.751    32.619     0.200
    24.813    32.505     0.200
    24.944    29.139     0.200
    24.944    28.389     0.200
    24.982    29.533     0.200
    24.937    32.340     0.200
    24.950    31.750     0.200
    25.062    32.686     0.200
    25.099    32.672     0.200
    25.157    31.294     0.200
    25.164    30.939     0.200
    25.293    29.764     0.200
    25.282    30.958     0.200
    25.406    28.288     0.200
    25.315    31.251     0.200
    25.372    29.987     0.200
    25.403    29.178     0.200
    25.367    31.597     0.200
    25.380    31.796     0.200
    25.410    30.981     0.200
    25.516    27.381     0.200
    25.486    30.613     0.200
    25.573    27.763     0.200
    25.526    30.864     0.200
    25.625    28.187     0.200
    25.521    30.475     0.200
    25.581    30.782     0.200
    25.607    31.203     0.200
    25.646    28.492     0.200
    25.601    30.837     0.200
    25.690    30.733     0.200
    25.700    30.657     0.200
    25.801    26.889     0.200
    25.723    31.027     0.200
    25.826    26.785     0.200
    25.826    28.329     0.200
    25.839    30.241     0.200
    25.961    28.546     0.200
    26.005    28.388     0.200
    26.074    29.351     0.200
    26.082    30.086     0.200
    26.113    29.942     0.200
    26.113    29.733     0.200
    26.145    30.044     0.200
    26.319    27.282     0.200
    26.319    28.019     0.200
    26.343    28.474     0.200
    26.302    28.641     0.200
    26.378    26.966     0.200
    26.412    27.735     0.200
    26.400    29.180     0.200
    26.482    25.167     0.200
    26.495    28.464     0.200
    26.571    27.718     0.200
    26.576    26.998     0.200
    26.615    27.464     0.200
    26.597    28.058     0.200
    26.647    27.726     0.200
    26.667    27.905     0.200
    26.752    24.882     0.200
    26.733    26.661     0.200
    26.819    27.038     0.200
    26.894    24.884     0.200
    26.822    26.897     0.200
    26.885    28.542     0.200
    26.927    26.592     0.200
    26.923    27.265     0.200
    26.918    27.994     0.200
    26.980    26.785     0.200
    26.980    26.898     0.200
    26.996    25.087     0.200
    26.996    25.202     0.200
    27.111    26.410     0.200
    27.188    25.994     0.200
    27.191    26.112     0.200
    27.354    24.965     0.200
    27.317    24.998     0.200
    27.330    26.443     0.200
    27.336    26.682     0.200
    27.463    23.155     0.200
    27.460    25.149     0.200
    27.602    22.985     0.200
    27.564    24.790     0.200
    27.564    24.694     0.200
    27.577    25.161     0.200
    27.772    23.261     0.200
    27.691    24.333     0.200
    27.731    23.836     0.200
    27.808    22.258     0.200
    27.764    23.459     0.200
    27.792    23.422     0.200
    27.825    23.563     0.200
    27.822    25.086     0.200
    27.904    24.521     0.200
    27.909    23.953     0.200
    27.973    22.923     0.200
    27.935    23.802     0.200
    27.952    22.236     0.200
    27.952    23.096     0.200
    27.971    23.041     0.200
    27.999    22.813     0.200
    28.025    20.826     0.200
    28.161    22.509     0.200
    28.209    23.884     0.200
    28.182    23.069     0.200
    28.314    22.183     0.200
    28.368    21.900     0.200
    28.362    21.458     0.200
    28.388    23.096     0.200
    28.466    21.711     0.200
    28.504    22.020     0.200
    28.533    21.349     0.200
    28.534    21.089     0.200
    28.575    21.311     0.200
    28.588    20.898     0.200
    28.624    21.500     0.200
    28.707    19.797     0.200
    28.707    21.641     0.200
    28.761    20.547     0.200
    28.735    21.789     0.200
    28.828    20.458     0.200
    28.849    20.919     0.200
    28.945    20.170     0.200
    28.946    19.558     0.200
    29.057    21.787     0.200
    29.115    20.268     0.200
    29.155    18.920     0.200
    29.182    19.186     0.200
    29.295    17.567     0.200
    29.252    19.052     0.200
    29.233    20.116     0.200
    29.305    19.319     0.200
    29.318    18.797     0.200
    29.340    18.960     0.200
    29.336    19.380     0.200
    29.337    19.028     0.200
    29.395    18.947     0.200
    29.422    19.378     0.200
    29.422    18.830     0.200
    29.538    18.564     0.200
    29.628    16.236     0.200
    29.622    17.613     0.200
    29.615    18.548     0.200
    29.602    20.563     0.200
    29.613    19.199     0.200
    29.622    19.672     0.200
    29.666    17.585     0.200
    29.621    19.899     0.200
    29.684    17.160     0.200
    29.754    16.981     0.200
    29.766    16.537     0.200
    29.873    17.389     0.200
    29.948    18.014     0.200
    17.006    39.306     0.200
    17.112    41.173     0.200
    17.112    41.493     0.200
    18.397    39.551     0.200
    19.113    38.987     0.200
    19.211    38.499     0.200
    20.642    37.194     0.200
    20.857    37.134     0.200
    21.158    40.034     0.200
    21.336    36.930     0.200
    21.393    35.528     0.200
    21.481    40.336     0.200
    21.662    36.279     0.200
    21.719    40.098     0.200
    21.788    36.595     0.200
    21.852    37.973     0.200
    21.928    39.003     0.200
    21.999    36.961     0.200
    22.093    35.077     0.200
    22.189    38.291     0.200
    22.321    38.343     0.200
    22.358    38.193     0.200
    22.373    35.199     0.200
    22.387    34.128     0.200
    22.647    34.709     0.200
    22.778    33.662     0.200
    22.955    34.632     0.200
    23.147    36.884     0.200
    23.168    33.559     0.200
    23.218    36.798     0.200
    23.265    34.803     0.200
    23.642    34.957     0.200
    23.640    36.552     0.200
    23.663    36.084     0.200
    23.779    31.620     0.200
    23.809    34.707     0.200
    23.836    33.497     0.200
    23.889    32.435     0.200
    23.859    39.459     0.200
    24.348    35.028     0.200
    24.374    31.124     0.200
    24.397    33.163     0.200
    24.614    33.223     0.200
    24.778    30.240     0.200
    25.096    28.580     0.200
    25.105    31.379     0.200
    25.104    31.975     0.200
    25.268    30.365     0.200
    25.292    28.903     0.200
    25.390    28.224     0.200
    25.769    30.773     0.200
    25.996    28.309     0.200
    26.105    28.410     0.200
    26.133    27.349     0.200
    26.179    28.751     0.200
    26.248    28.916     0.200
    26.451    27.414     0.200
    26.634    27.398     0.200
    26.761    27.056     0.200
    26.995    23.964     0.200
    27.142    27.546     0.200
    27.164    26.103     0.200
    27.222    26.007     0.200
    27.377    25.978     0.200
    27.447    22.781     0.200
    27.501    23.908     0.200
    27.630    25.932     0.200
    27.745    25.138     0.200
    27.985    21.737     0.200
    28.023    25.283     0.200
    28.032    24.569     0.200
    28.217    23.329     0.200
    28.399    23.056     0.200
    28.403    23.041     0.200
    29.187    18.347     0.200
    29.183    24.077     0.200
    29.310    19.960     0.200
    29.901    18.385     0.200
    29.908    19.173     0.200
    29.917    19.287     0.200
    29.969    18.310     0.200
    29.958    19.752     0.200
    15.430    43.145     0.200
    15.752    43.108     0.200
    16.193    45.009     0.200
    18.886    42.020     0.200
    18.963    40.051     0.200
    20.252    39.220     0.200
    20.432    42.111     0.200
    20.853    40.891     0.200
    20.937    42.176     0.200
    20.978    40.527     0.200
    21.000    41.515     0.200
    21.415    37.146     0.200
    22.155    37.987     0.200
    22.388    39.583     0.200
    22.596    38.738     0.200
    23.148    38.723     0.200
    23.334    36.218     0.200
    25.210    34.180     0.200
    13.982    38.802     0.200
    13.983    38.746     0.200
    14.615    38.573     0.200
    14.795    39.263     0.200
    15.020    37.471     0.200
    15.182    38.215     0.200
    15.224    40.172     0.200
    15.242    38.266     0.200
    15.265    37.948     0.200
    15.304    39.580     0.200
    15.663    39.141     0.200
    15.653    37.565     0.200
    15.886    38.306     0.200
    15.891    39.148     0.200
    16.149    37.692     0.200
    16.212    37.165     0.200
    16.280    37.921     0.200
    16.326    37.679     0.200
    16.547    39.323     0.200
    16.547    38.301     0.200
    16.677    38.001     0.200
    16.727    37.722     0.200
    17.131    37.639     0.200
    17.154    37.814     0.200
    17.465    37.558     0.200
    17.570    36.648     0.200
    17.741    36.209     0.200
    17.790    36.882     0.200
    17.859    36.054     0.200
    17.873    34.975     0.200
    17.908    37.079     0.200
    18.011    37.042     0.200
    18.112    37.180     0.200
    18.352    36.859     0.200
    18.447    37.162     0.200
    18.476    35.844     0.200
    18.533    35.359     0.200
    18.641    36.567     0.200
    18.732    36.771     0.200
    18.751    36.799     0.200
    18.824    37.337     0.200
    18.893    36.932     0.200
    18.908    36.744     0.200
    18.981    36.910     0.200
    18.997    35.450     0.200
    19.038    35.790     0.200
    19.145    36.606     0.200
    19.157    36.683     0.200
    19.171    36.424     0.200
    19.228    36.880     0.200
    19.228    36.429     0.200
    19.345    35.814     0.200
    19.421    35.728     0.200
    19.563    36.877     0.200
    19.566    36.419     0.200
    19.615    35.298     0.200
    19.709    35.518     0.200
    19.755    36.639     0.200
    19.782    36.269     0.200
    19.805    35.647     0.200
    19.806    35.724     0.200
    19.839    33.400     0.200
    19.900    36.243     0.200
    19.973    35.642     0.200
    20.046    35.425     0.200
    20.058    34.957     0.200
    20.072    35.210     0.200
    20.120    35.539     0.200
    20.154    35.856     0.200
    20.203    33.325     0.200
    20.222    36.220     0.200
    20.235    34.458     0.200
    20.284    33.847     0.200
    20.354    34.661     0.200
    20.368    34.566     0.200
    20.409    35.617     0.200
    20.421    35.689     0.200
    20.451    34.345     0.200
    20.482    34.537     0.200
    20.601    34.522     0.200
    20.682    35.292     0.200
    20.682    35.697     0.200
    20.713    35.455     0.200
    20.769    35.365     0.200
    20.779    34.565     0.200
    20.853    33.753     0.200
    21.177    34.848     0.200
    21.193    35.258     0.200
    21.216    33.655     0.200
    21.286    34.446     0.200
    21.338    33.622     0.200
    21.390    34.270     0.200
    21.448    33.967     0.200
    21.448    34.388     0.200
    21.449    33.343     0.200
    21.606    33.720     0.200
    21.617    34.234     0.200
    21.678    32.386     0.200
    21.739    32.672     0.200
    21.811    33.999     0.200
    21.845    33.305     0.200
    21.848    31.575     0.200
    21.857    35.981     0.200
    21.862    33.701     0.200
    22.128    30.977     0.200
    22.193    33.860     0.200
    22.242    32.593     0.200
    22.322    30.076     0.200
    22.329    34.289     0.200
    22.435    33.192     0.200
    22.522    32.406     0.200
    22.543    32.742     0.200
    22.641    32.400     0.200
    22.661    32.071     0.200
    22.758    29.698     0.200
    22.806    32.566     0.200
    22.826    30.740     0.200
    22.863    32.011     0.200
    22.872    32.058     0.200
    23.123    30.755     0.200
    23.123    32.330     0.200
    23.224    31.505     0.200
    23.333    28.380     0.200
    23.789    28.512     0.200
    23.838    28.774     0.200
    23.857    30.989     0.200
    23.931    27.452     0.200
    23.931    27.207     0.200
    24.289    26.366     0.200
    24.384    26.461     0.200
    24.453    29.734     0.200
    24.480    26.370     0.200
    24.483    30.003     0.200
    24.706    26.686     0.200
    24.706    27.805     0.200
    24.767    25.785     0.200
    24.892    24.838     0.200
    24.923    26.592     0.200
    25.326    25.478     0.200
    25.565    23.728     0.200
    25.690    25.240     0.200
    25.731    24.583     0.200
    25.965    23.343     0.200
    26.454    22.107     0.200
    26.615    22.334     0.200
    27.531    21.032     0.200
    27.844    18.006     0.200
    27.844    19.096     0.200
    27.934    18.979     0.200
    28.022    17.246     0.200
    28.242    17.960     0.200
    28.270    16.947     0.200
    28.514    16.028     0.200
    28.686    14.931     0.200
    28.689    15.918     0.200
    28.854    14.889     0.200
    28.921    14.931     0.200
    29.039    14.528     0.200
    29.148    13.967     0.200
    29.253    13.638     0.200
    14.683    40.682     0.200
    14.990    39.641     0.200
    15.055    40.543     0.200
    15.241    39.576     0.200
    15.306    40.382     0.200
    15.376    40.099     0.200
    15.484    42.975     0.200
    15.507    42.483     0.200
    15.583    41.186     0.200
    15.726    41.761     0.200
    15.872    40.436     0.200
    15.925    41.151     0.200
    15.946    42.784     0.200
    15.951    40.168     0.200
    16.010    42.067     0.200
    16.018    42.623     0.200
    16.103    40.672     0.200
    16.204    40.712     0.200
    16.383    42.225     0.200
    16.631    41.133     0.200
    16.700    41.002     0.200
    17.003    41.037     0.200
    17.096    43.264     0.200
    17.263    40.726     0.200
    17.263    41.251     0.200
    17.317    41.085     0.200
    17.330    41.929     0.200
    17.364    41.605     0.200
    17.421    42.683     0.200
    17.450    42.591     0.200
    17.856    40.801     0.200
    17.882    44.290     0.200
    17.901    42.141     0.200
    17.999    41.753     0.200
    18.185    42.360     0.200
    18.396    39.343     0.200
    18.441    39.796     0.200
    18.886    36.978     0.200
    19.608    39.605     0.200
    20.059    38.207     0.200
    20.144    38.410     0.200
    20.149    39.328     0.200
    20.171    37.899     0.200
    20.258    37.486     0.200
    20.285    37.440     0.200
    20.319    38.128     0.200
    20.355    39.173     0.200
    20.429    38.075     0.200
    20.527    39.167     0.200
    20.696    38.842     0.200
    20.778    37.004     0.200
    20.877    37.135     0.200
    20.938    35.239     0.200
    20.938    35.370     0.200
    20.982    37.435     0.200
    21.035    40.958     0.200
    21.075    37.185     0.200
    21.164    39.101     0.200
    21.206    38.691     0.200
    21.323    37.374     0.200
    21.482    37.266     0.200
    21.577    37.606     0.200
    21.714    36.459     0.200
    21.860    36.896     0.200
    21.874    38.362     0.200
    21.896    38.303     0.200
    21.914    39.232     0.200
    21.922    37.422     0.200
    22.060    36.837     0.200
    22.171    37.468     0.200
    22.293    36.306     0.200
    22.317    38.066     0.200
    22.361    35.868     0.200
    22.388    34.849     0.200
    22.459    38.183     0.200
    22.549    38.224     0.200
    23.018    37.229     0.200
    23.259    35.458     0.200
    23.510    33.673     0.200
    23.846    33.081     0.200
    24.303    29.950     0.200
    24.565    33.393     0.200
    24.673    30.720     0.200
    24.839    29.980     0.200
    24.912    29.488     0.200
    25.378    28.866     0.200
    25.424    28.682     0.200
    25.424    28.810     0.200
    25.944    26.313     0.200
    25.955    28.997     0.200
    26.103    26.683     0.200
    26.237    25.949     0.200
    26.327    26.643     0.200
    26.688    24.945     0.200
    26.917    24.137     0.200
    27.633    24.276     0.200
    27.631    23.541     0.200
    28.067    20.169     0.200
    28.128    24.731     0.200
    28.745    20.069     0.200
    29.412    17.462     0.200
    29.575    15.751     0.200
    29.582    16.813     0.200
    29.975    15.801     0.200
    13.824    36.138     0.200
    13.844    38.222     0.200
    14.234    36.707     0.200
    14.461    38.144     0.200
    14.605    38.648     0.200
    14.816    37.063     0.200
    14.929    36.656     0.200
    15.292    38.007     0.200
    15.420    37.418     0.200
    15.489    37.061     0.200
    15.517    38.824     0.200
    15.563    37.501     0.200
    15.597    38.352     0.200
    15.659    37.214     0.200
    15.763    38.223     0.200
    15.948    38.837     0.200
    16.113    37.692     0.200
    16.157    38.638     0.200
    16.287    38.794     0.200
    16.430    37.912     0.200
    16.585    39.136     0.200
    16.626    39.501     0.200
    16.646    38.172     0.200
    16.786    37.914     0.200
    16.823    39.636     0.200
    16.823    38.222     0.200
    16.823    38.910     0.200
    16.904    39.156     0.200
    16.919    39.111     0.200
    17.008    39.732     0.200
    17.023    38.779     0.200
    17.234    39.025     0.200
    17.277    37.779     0.200
    17.337    39.065     0.200
    17.423    37.249     0.200
    17.454    39.007     0.200
    17.452    38.378     0.200
    17.556    39.382     0.200
    17.783    39.278     0.200
    17.807    39.172     0.200
    17.847    38.308     0.200
    17.974    35.427     0.200
    18.447    34.340     0.200
    18.583    36.462     0.200
    18.646    36.469     0.200
    19.721    36.515     0.200
    19.805    36.075     0.200
    19.833    35.860     0.200
    19.871    36.493     0.200
    19.887    33.933     0.200
    19.909    36.513     0.200
    20.208    33.770     0.200
    20.457    36.053     0.200
    20.482    35.311     0.200
    20.485    34.355     0.200
    20.485    34.699     0.200
    20.529    35.092     0.200
    20.644    36.078     0.200
    20.895    36.014     0.200
    20.959    32.477     0.200
    21.018    36.758     0.200
    21.039    35.260     0.200
    21.061    35.870     0.200
    21.073    34.814     0.200
    21.087    35.018     0.200
    21.153    36.335     0.200
    21.264    36.043     0.200
    21.275    35.650     0.200
    21.416    35.380     0.200
    21.453    36.742     0.200
    21.474    36.442     0.200
    21.474    35.754     0.200
    21.510    35.591     0.200
    21.624    35.798     0.200
    21.631    35.102     0.200
    21.698    35.137     0.200
    21.706    35.061     0.200
    21.744    35.137     0.200
    21.750    35.451     0.200
    21.914    34.679     0.200
    21.953    35.042     0.200
    21.943    34.386     0.200
    22.056    34.727     0.200
    22.196    35.173     0.200
    22.222    31.711     0.200
    22.428    33.540     0.200
    22.466    33.260     0.200
    22.609    34.471     0.200
    22.593    33.641     0.200
    22.672    33.515     0.200
    22.816    33.493     0.200
    22.872    33.088     0.200
    22.986    32.493     0.200
    23.061    32.546     0.200
    23.109    32.586     0.200
    23.137    31.179     0.200
    23.239    30.519     0.200
    23.429    32.837     0.200
    23.476    31.428     0.200
    23.555    31.407     0.200
    23.697    30.170     0.200
    23.770    30.763     0.200
    23.775    29.831     0.200
    23.827    30.144     0.200
    23.940    27.878     0.200
    24.189    31.299     0.200
    24.345    27.072     0.200
    24.393    28.448     0.200
    24.467    28.178     0.200
    24.658    28.199     0.200
    24.768    29.345     0.200
    24.756    28.088     0.200
    24.869    25.830     0.200
    24.907    27.588     0.200
    24.953    27.545     0.200
    24.987    27.326     0.200
    24.987    27.709     0.200
    24.999    27.443     0.200
    25.001    27.181     0.200
    25.140    26.719     0.200
    25.194    26.309     0.200
    25.508    26.347     0.200
    25.583    26.758     0.200
    25.615    25.826     0.200
    25.624    25.879     0.200
    25.631    25.499     0.200
    25.681    26.026     0.200
    25.748    24.418     0.200
    25.884    24.735     0.200
    25.929    24.678     0.200
    25.931    25.223     0.200
    25.937    25.297     0.200
    25.977    24.830     0.200
    26.016    25.363     0.200
    26.108    24.251     0.200
    26.295    23.968     0.200
    26.303    24.362     0.200
    26.404    23.494     0.200
    26.723    22.558     0.200
    27.139    21.205     0.200
    27.197    21.194     0.200
    27.211    21.988     0.200
    27.209    20.984     0.200
    27.450    20.836     0.200
    27.592    20.082     0.200
    27.677    20.422     0.200
    27.698    20.228     0.200
    27.699    19.879     0.200
    27.820    20.100     0.200
    28.045    18.728     0.200
    28.129    19.456     0.200
    28.221    18.748     0.200
    28.245    18.772     0.200
    28.306    18.703     0.200
    28.320    18.980     0.200
    28.437    17.847     0.200
    28.558    18.051     0.200
    28.664    17.024     0.200
    28.720    17.262     0.200
    28.794    16.880     0.200
    28.814    16.535     0.200
    28.964    16.038     0.200
    28.986    15.921     0.200
    29.030    16.388     0.200
    29.138    15.733     0.200
    29.143    16.383     0.200
    29.312    15.678     0.200
    29.342    15.620     0.200
    29.392    15.038     0.200
    29.425    14.477     0.200
    29.477    15.216     0.200
    29.559    14.569     0.200
    29.697    14.777     0.200
    29.719    14.191     0.200
    29.902    13.798     0.200
    29.966    13.685     0.200
    14.039    37.231     0.200
    14.361    37.705     0.200
    14.478    39.304     0.200
    14.499    37.695     0.200
    14.628    38.995     0.200
    14.678    37.876     0.200
    14.671    38.811     0.200
    14.730    40.854     0.200
    14.834    38.350     0.200
    14.876    38.312     0.200
    14.953    39.357     0.200
    15.121    38.498     0.200
    15.142    37.547     0.200
    15.163    41.128     0.200
    15.434    39.016     0.200
    15.527    39.405     0.200
    15.685    40.048     0.200
    15.721    39.350     0.200
    15.756    40.151     0.200
    15.760    39.316     0.200
    15.827    39.580     0.200
    15.836    40.089     0.200
    15.917    38.930     0.200
    15.922    38.344     0.200
    15.916    38.314     0.200
    16.007    40.525     0.200
    16.029    39.239     0.200
    16.056    39.698     0.200
    16.141    38.902     0.200
    16.304    38.261     0.200
    16.337    40.270     0.200
    16.458    40.812     0.200
    16.458    38.710     0.200
    16.468    38.956     0.200
    16.515    40.816     0.200
    16.513    38.727     0.200
    16.558    38.119     0.200
    16.579    41.818     0.200
    16.607    39.118     0.200
    16.655    39.763     0.200
    16.679    40.870     0.200
    16.741    39.204     0.200
    16.823    39.693     0.200
    16.893    41.860     0.200
    16.927    39.540     0.200
    16.979    38.237     0.200
    16.990    39.414     0.200
    17.022    41.860     0.200
    17.161    38.708     0.200
    17.176    39.098     0.200
    17.203    39.966     0.200
    17.203    39.818     0.200
    17.285    40.359     0.200
    17.307    41.605     0.200
    17.355    40.869     0.200
    17.407    40.032     0.200
    17.598    39.458     0.200
    17.626    41.880     0.200
    17.694    39.855     0.200
    17.733    40.314     0.200
    17.753    39.807     0.200
    17.753    38.875     0.200
    17.773    39.429     0.200
    17.807    39.493     0.200
    17.855    40.252     0.200
    17.930    39.861     0.200
    18.210    40.338     0.200
    18.229    40.245     0.200
    18.483    37.892     0.200
    18.663    36.980     0.200
    18.833    36.506     0.200
    19.985    36.046     0.200
    20.134    37.588     0.200
    20.250    35.443     0.200
    20.827    36.996     0.200
    20.855    37.022     0.200
    21.048    36.610     0.200
    21.064    36.912     0.200
    21.107    39.258     0.200
    21.094    37.477     0.200
    21.186    38.745     0.200
    21.380    39.376     0.200
    21.412    36.932     0.200
    21.440    36.960     0.200
    21.446    36.990     0.200
    21.477    36.234     0.200
    21.514    34.561     0.200
    21.553    33.661     0.200
    21.583    33.895     0.200
    21.647    37.540     0.200
    21.668    36.618     0.200
    21.698    37.734     0.200
    21.786    37.232     0.200
    21.810    37.100     0.200
    21.831    37.501     0.200
    21.832    35.090     0.200
    21.832    36.379     0.200
    21.935    37.296     0.200
    21.991    36.704     0.200
    22.058    39.034     0.200
    22.071    37.574     0.200
    22.052    32.723     0.200
    22.096    36.067     0.200
    22.100    36.032     0.200
    22.113    36.411     0.200
    22.118    36.591     0.200
    22.146    35.625     0.200
    22.146    35.789     0.200
    22.157    36.372     0.200
    22.247    36.374     0.200
    22.274    35.832     0.200
    22.309    35.977     0.200
    22.399    36.957     0.200
    22.406    32.900     0.200
    22.466    36.932     0.200
    22.507    37.491     0.200
    22.544    35.181     0.200
    22.554    35.777     0.200
    22.572    35.718     0.200
    22.645    36.909     0.200
    22.645    36.577     0.200
    22.647    35.436     0.200
    22.662    32.781     0.200
    22.785    34.359     0.200
    22.785    35.394     0.200
    22.914    35.527     0.200
    22.926    36.582     0.200
    22.941    36.538     0.200
    22.952    36.017     0.200
    23.000    36.788     0.200
    23.012    33.322     0.200
    23.051    37.035     0.200
    23.046    35.794     0.200
    23.102    35.914     0.200
    23.118    37.002     0.200
    23.251    34.825     0.200
    23.299    36.449     0.200
    23.306    33.486     0.200
    23.301    32.980     0.200
    23.317    34.278     0.200
    23.323    34.406     0.200
    23.367    34.340     0.200
    23.395    31.253     0.200
    23.409    34.221     0.200
    23.496    33.795     0.200
    23.493    34.158     0.200
    23.515    32.728     0.200
    23.540    35.552     0.200
    23.515    33.206     0.200
    23.536    34.540     0.200
    23.563    33.994     0.200
    23.577    31.665     0.200
    23.686    33.312     0.200
    23.794    34.089     0.200
    23.842    33.341     0.200
    23.842    33.666     0.200
    23.847    33.508     0.200
    23.873    33.073     0.200
    23.885    33.362     0.200
    23.922    33.215     0.200
    23.941    33.131     0.200
    23.958    34.780     0.200
    23.985    29.793     0.200
    24.077    32.071     0.200
    24.130    32.446     0.200
    24.132    33.266     0.200
    24.197    31.620     0.200
    24.206    31.675     0.200
    24.396    31.250     0.200
    24.402    30.931     0.200
    24.452    29.123     0.200
    24.487    31.583     0.200
    24.505    32.274     0.200
    24.559    32.449     0.200
    24.541    31.875     0.200
    24.630    31.606     0.200
    24.671    30.864     0.200
    24.691    30.681     0.200
    24.717    28.274     0.200
    24.754    30.471     0.200
    24.757    30.703     0.200
    24.834    30.241     0.200
    24.976    27.776     0.200
    25.033    29.311     0.200
    25.037    30.463     0.200
    25.079    27.708     0.200
    25.102    30.650     0.200
    25.191    29.507     0.200
    25.189    31.213     0.200
    25.196    27.425     0.200
    25.249    29.611     0.200
    25.268    29.200     0.200
    25.286    28.623     0.200
    25.351    29.203     0.200
    25.358    28.746     0.200
    25.371    28.483     0.200
    25.371    28.343     0.200
    25.561    28.153     0.200
    25.643    29.033     0.200
    25.663    28.486     0.200
    25.666    28.501     0.200
    25.732    29.179     0.200
    25.740    26.838     0.200
    25.750    27.539     0.200
    25.790    26.286     0.200
    25.894    27.267     0.200
    25.973    27.715     0.200
    25.997    27.168     0.200
    26.001    26.544     0.200
    26.026    27.854     0.200
    26.027    27.553     0.200
    26.014    26.063     0.200
    26.088    27.352     0.200
    26.192    26.784     0.200
    26.224    26.862     0.200
    26.255    26.780     0.200
    26.297    26.351     0.200
    26.321    26.486     0.200
    26.323    26.326     0.200
    26.327    26.340     0.200
    26.369    26.494     0.200
    26.405    25.931     0.200
    26.486    26.387     0.200
    26.523    26.195     0.200
    26.566    25.038     0.200
    26.652    25.964     0.200
    26.653    25.313     0.200
    26.660    25.974     0.200
    26.691    25.766     0.200
    26.751    25.440     0.200
    26.759    25.017     0.200
    26.765    25.277     0.200
    26.861    25.935     0.200
    26.900    25.297     0.200
    27.048    22.421     0.200
    27.098    24.161     0.200
    27.144    24.995     0.200
    27.169    24.316     0.200
    27.163    23.754     0.200
    27.224    24.048     0.200
    27.228    23.842     0.200
    27.231    25.099     0.200
    27.254    25.298     0.200
    27.263    23.954     0.200
    27.269    24.447     0.200
    27.393    23.525     0.200
    27.393    23.704     0.200
    27.434    24.350     0.200
    27.489    24.013     0.200
    27.508    22.786     0.200
    27.586    23.666     0.200
    27.585    22.702     0.200
    27.585    22.991     0.200
    27.619    23.566     0.200
    27.648    20.484     0.200
    27.732    22.943     0.200
    27.732    23.166     0.200
    27.741    22.488     0.200
    27.748    23.303     0.200
    27.815    21.842     0.200
    27.832    23.025     0.200
    27.827    22.221     0.200
    27.847    23.048     0.200
    28.042    22.223     0.200
    28.062    23.164     0.200
    28.066    21.549     0.200
    28.097    22.325     0.200
    28.211    21.848     0.200
    28.250    22.150     0.200
    28.296    22.295     0.200
    28.304    20.944     0.200
    28.319    21.487     0.200
    28.419    21.564     0.200
    28.423    20.758     0.200
    28.439    19.981     0.200
    28.448    20.350     0.200
    28.519    20.559     0.200
    28.519    20.684     0.200
    28.530    20.520     0.200
    28.604    20.891     0.200
    28.645    20.233     0.200
    28.695    20.374     0.200
    28.725    19.980     0.200
    28.752    19.662     0.200
    28.807    19.399     0.200
    28.881    17.532     0.200
    28.924    19.516     0.200
    28.952    19.728     0.200
    29.002    19.019     0.200
    29.087    19.466     0.200
    29.097    18.937     0.200
    29.147    19.201     0.200
    29.164    19.091     0.200
    29.165    18.191     0.200
    29.177    18.456     0.200
    29.329    17.657     0.200
    29.375    20.598     0.200
    29.377    18.558     0.200
    29.401    21.788     0.200
    29.389    17.827     0.200
    29.417    18.752     0.200
    29.421    17.931     0.200
    29.506    17.156     0.200
    29.507    17.525     0.200
    29.535    17.245     0.200
    29.576    21.365     0.200
    29.619    17.366     0.200
    29.630    17.269     0.200
    29.663    20.117     0.200
    29.687    17.303     0.200
    29.731    17.040     0.200
    29.740    17.400     0.200
    29.736    17.002     0.200
    29.778    19.394     0.200
    29.825    18.832     0.200
    29.767    16.234     0.200
    29.805    16.572     0.200
    29.862    16.583     0.200
    29.884    17.953     0.200
    29.922    16.437     0.200
    29.926    16.457     0.200
    29.948    16.179     0.200
    13.699    36.046     0.200
    13.956    36.496     0.200
    14.053    37.141     0.200
    14.091    36.751     0.200
    14.128    36.567     0.200
    14.162    37.586     0.200
    14.251    37.184     0.200
    14.305    37.061     0.200
    14.323    37.565     0.200
    14.410    37.025     0.200
    14.508    37.100     0.200
    14.698    37.246     0.200
    14.722    36.941     0.200
    14.738    37.015     0.200
    14.750    36.803     0.200
    14.822    37.159     0.200
    14.862    37.022     0.200
    14.914    37.017     0.200
    14.993    37.553     0.200
    15.038    37.938     0.200
    15.105    37.865     0.200
    15.241    37.554     0.200
    15.295    38.170     0.200
    15.292    37.322     0.200
    15.342    38.257     0.200
    15.346    37.928     0.200
    15.386    38.626     0.200
    15.386    37.057     0.200
    15.433    37.864     0.200
    15.459    37.720     0.200
    15.543    37.758     0.200
    15.605    38.078     0.200
    15.700    37.812     0.200
    15.787    37.676     0.200
    15.915    37.489     0.200
    15.914    38.028     0.200
    15.923    37.759     0.200
    15.986    37.488     0.200
    16.472    37.361     0.200
    16.618    37.685     0.200
    16.659    38.250     0.200
    16.691    37.567     0.200
    16.765    38.512     0.200
    16.854    37.783     0.200
    17.209    38.472     0.200
    17.224    38.831     0.200
    17.286    38.178     0.200
    17.345    38.100     0.200
    17.445    37.654     0.200
    17.617    38.619     0.200
    17.804    38.317     0.200
    17.808    37.507     0.200
    17.830    37.522     0.200
    17.833    39.008     0.200
    17.921    38.701     0.200
    18.534    36.479     0.200
    18.552    36.493     0.200
    18.834    36.824     0.200
    19.151    35.743     0.200
    19.200    36.835     0.200
    19.589    36.340     0.200
    19.692    36.821     0.200
    19.858    35.523     0.200
    19.958    35.238     0.200
    19.968    34.396     0.200
    20.141    33.670     0.200
    20.120    36.389     0.200
    20.325    36.267     0.200
    20.333    36.148     0.200
    20.388    35.845     0.200
    20.430    36.305     0.200
    20.500    35.292     0.200
    20.533    33.564     0.200
    20.510    35.314     0.200
    20.549    35.136     0.200
    20.680    35.681     0.200
    20.894    36.086     0.200
    21.190    35.297     0.200
    21.300    33.528     0.200
    21.296    35.177     0.200
    21.513    34.001     0.200
    21.746    34.295     0.200
    22.206    30.066     0.200
    22.411    34.147     0.200
    22.483    33.028     0.200
    22.962    32.388     0.200
    23.111    31.988     0.200
    23.583    30.668     0.200
    23.701    32.977     0.200
    23.770    32.876     0.200
    24.258    28.392     0.200
    24.267    29.012     0.200
    24.746    29.160     0.200
    24.746    29.169     0.200
    24.957    27.848     0.200
    25.433    26.469     0.200
    25.436    26.572     0.200
    25.457    26.716     0.200
    25.674    25.547     0.200
    25.846    23.740     0.200
    26.734    23.204     0.200
    28.647    16.998     0.200
    29.193    15.116     0.200
    29.439    15.214     0.200
    29.611    14.304     0.200
    29.696    14.433     0.200
    29.894    13.886     0.200
    16.382    41.624     0.200
    16.492    41.323     0.200
    16.463    41.732     0.200
    17.129    41.527     0.200
    17.323    42.048     0.200
    17.521    41.840     0.200
    17.621    41.733     0.200
    17.717    42.314     0.200
    17.644    41.751     0.200
    17.727    41.370     0.200
    17.870    41.513     0.200
    18.000    41.756     0.200
    18.150    41.243     0.200
    18.275    41.505     0.200
    18.295    41.020     0.200
    18.307    40.412     0.200
    18.333    40.932     0.200
    18.445    40.798     0.200
    18.423    38.677     0.200
    18.523    41.155     0.200
    18.880    38.481     0.200
    18.880    39.153     0.200
    18.946    40.434     0.200
    19.072    41.075     0.200
    19.069    40.754     0.200
    19.052    41.134     0.200
    19.068    41.058     0.200
    19.093    40.937     0.200
    19.194    40.096     0.200
    19.383    40.315     0.200
    19.406    39.036     0.200
    19.493    40.442     0.200
    19.567    40.232     0.200
    19.566    40.677     0.200
    19.629    39.248     0.200
    19.641    39.682     0.200
    19.718    40.950     0.200
    19.733    38.752     0.200
    19.928    40.515     0.200
    19.891    39.548     0.200
    20.010    40.074     0.200
    20.099    39.652     0.200
    20.102    39.564     0.200
    20.066    39.189     0.200
    20.168    38.581     0.200
    20.189    38.641     0.200
    20.235    39.148     0.200
    20.247    38.568     0.200
    20.284    39.986     0.200
    20.297    39.240     0.200
    20.365    40.387     0.200
    20.347    36.520     0.200
    20.555    39.173     0.200
    20.621    40.212     0.200
    20.634    38.404     0.200
    20.653    39.854     0.200
    20.669    36.716     0.200
    20.827    39.485     0.200
    20.828    38.494     0.200
    20.894    38.866     0.200
    20.894    38.178     0.200
    21.044    39.740     0.200
    20.964    38.167     0.200
    21.035    39.207     0.200
    21.165    38.821     0.200
    21.165    39.086     0.200
    21.111    39.535     0.200
    21.224    40.074     0.200
    21.109    38.655     0.200
    21.212    37.717     0.200
    21.336    38.830     0.200
    21.357    39.074     0.200
    21.486    38.966     0.200
    21.407    40.355     0.200
    21.438    39.004     0.200
    21.444    38.936     0.200
    21.477    38.397     0.200
    21.551    37.129     0.200
    21.549    37.817     0.200
    21.620    36.786     0.200
    21.685    36.110     0.200
    21.734    37.857     0.200
    21.806    37.990     0.200
    21.806    37.217     0.200
    21.792    36.547     0.200
    22.018    38.008     0.200
    21.991    33.353     0.200
    22.082    38.249     0.200
    22.125    38.205     0.200
    22.327    38.145     0.200
    22.327    36.918     0.200
    22.265    36.707     0.200
    22.413    33.919     0.200
    22.499    35.975     0.200
    22.794    37.642     0.200
    22.770    37.521     0.200
    22.805    33.248     0.200
    22.886    37.178     0.200
    22.923    36.191     0.200
    22.981    34.515     0.200
    23.562    36.574     0.200
    23.466    32.893     0.200
    23.676    35.949     0.200
    23.641    34.449     0.200
    24.287    34.666     0.200
    24.356    35.281     0.200
    24.303    31.750     0.200
    24.321    31.836     0.200
    24.401    30.635     0.200
    24.720    31.247     0.200
    24.740    31.274     0.200
    24.788    30.477     0.200
    24.804    30.021     0.200
    24.991    32.045     0.200
    24.991    32.834     0.200
    25.141    30.046     0.200
    25.190    30.851     0.200
    25.186    30.484     0.200
    25.284    30.597     0.200
    25.341    28.909     0.200
    25.367    29.174     0.200
    25.377    29.572     0.200
    25.499    31.257     0.200
    25.676    29.203     0.200
    25.945    28.764     0.200
    25.954    28.777     0.200
    25.956    28.900     0.200
    25.991    28.331     0.200
    26.156    27.508     0.200
    26.199    27.773     0.200
    26.416    27.968     0.200
    26.599    26.754     0.200
    26.599    26.580     0.200
    26.708    27.017     0.200
    26.731    26.920     0.200
    27.152    25.858     0.200
    27.172    25.648     0.200
    27.235    26.333     0.200
    27.189    24.294     0.200
    27.243    24.747     0.200
    27.268    24.485     0.200
    27.339    25.385     0.200
    27.457    24.846     0.200
    27.756    25.303     0.200
    27.752    23.890     0.200
    27.759    24.002     0.200
    27.806    24.064     0.200
    27.829    23.569     0.200
    28.019    23.278     0.200
    28.573    21.239     0.200
    28.571    20.956     0.200
    28.708    21.220     0.200
    28.753    21.368     0.200
    28.910    21.184     0.200
    29.066    19.979     0.200
    29.152    20.032     0.200
    29.186    18.975     0.200
    29.287    19.457     0.200
    29.455    19.000     0.200
    29.711    18.273     0.200
    29.723    18.642     0.200
    29.739    18.573     0.200
    29.802    17.092     0.200
    29.884    18.124     0.200
    13.671    38.118     0.200
    13.709    36.582     0.200
    14.076    38.104     0.200
    14.108    37.142     0.200
    14.176    38.675     0.200
    14.217    37.876     0.200
    14.262    36.317     0.200
    14.267    38.043     0.200
    14.414    37.521     0.200
    14.421    38.148     0.200
    14.454    37.700     0.200
    14.454    36.047     0.200
    14.500    36.834     0.200
    14.638    38.026     0.200
    14.691    37.294     0.200
    14.705    37.576     0.200
    14.774    38.134     0.200
    14.816    36.771     0.200
    14.814    37.863     0.200
    14.844    37.258     0.200
    14.853    37.543     0.200
    14.931    37.635     0.200
    14.993    37.866     0.200
    15.009    35.960     0.200
    15.048    37.393     0.200
    15.091    37.505     0.200
    15.194    37.721     0.200
    15.321    38.185     0.200
    15.330    37.948     0.200
    15.323    37.590     0.200
    15.396    37.214     0.200
    15.452    37.720     0.200
    15.468    37.728     0.200
    15.513    38.252     0.200
    15.540    38.006     0.200
    15.597    37.393     0.200
    15.613    37.569     0.200
    15.625    37.770     0.200
    15.705    37.558     0.200
    15.761    37.412     0.200
    15.879    36.935     0.200
    15.915    37.423     0.200
    16.048    36.529     0.200
    16.077    37.727     0.200
    16.089    36.969     0.200
    16.183    37.127     0.200
    16.209    36.628     0.200
    16.223    37.430     0.200
    16.314    37.801     0.200
    16.351    37.337     0.200
    16.403    37.550     0.200
    16.469    37.566     0.200
    16.469    36.589     0.200
    16.708    38.149     0.200
    16.759    36.865     0.200
    16.795    38.378     0.200
    16.801    37.880     0.200
    16.813    38.378     0.200
    16.953    36.790     0.200
    17.005    36.738     0.200
    17.185    36.488     0.200
    17.183    37.802     0.200
    17.295    38.828     0.200
    17.304    37.943     0.200
    17.464    37.983     0.200
    17.525    36.665     0.200
    17.866    36.768     0.200
    17.931    38.275     0.200
    18.004    35.912     0.200
    18.052    35.848     0.200
    18.052    35.491     0.200
    18.158    36.050     0.200
    18.172    34.224     0.200
    18.264    35.768     0.200
    18.492    35.508     0.200
    18.596    35.027     0.200
    18.596    34.734     0.200
    18.623    35.717     0.200
    18.623    34.963     0.200
    18.900    35.548     0.200
    19.094    35.982     0.200
    19.230    35.726     0.200
    19.263    35.388     0.200
    19.309    35.694     0.200
    19.331    34.506     0.200
    19.397    36.254     0.200
    19.571    35.073     0.200
    19.639    34.185     0.200
    19.836    35.984     0.200
    19.905    35.283     0.200
    19.929    33.786     0.200
    19.966    34.925     0.200
    19.985    33.819     0.200
    20.061    34.489     0.200
    20.104    33.598     0.200
    20.247    35.844     0.200
    20.313    34.125     0.200
    20.331    33.896     0.200
    20.340    32.957     0.200
    20.459    35.300     0.200
    20.474    33.917     0.200
    20.505    32.849     0.200
    20.503    34.680     0.200
    20.546    35.531     0.200
    20.546    34.649     0.200
    20.567    35.029     0.200
    20.622    34.575     0.200
    20.657    34.131     0.200
    20.741    33.179     0.200
    20.893    33.819     0.200
    20.924    32.680     0.200
    21.028    32.932     0.200
    21.043    37.144     0.200
    21.091    35.232     0.200
    21.108    32.500     0.200
    21.136    33.405     0.200
    21.135    35.986     0.200
    21.186    38.595     0.200
    21.214    33.971     0.200
    21.216    33.527     0.200
    21.288    33.100     0.200
    21.293    33.295     0.200
    21.444    35.858     0.200
    21.444    33.605     0.200
    21.504    33.094     0.200
    21.561    34.298     0.200
    21.650    33.342     0.200
    21.635    35.542     0.200
    21.685    34.926     0.200
    21.740    33.235     0.200
    21.744    34.182     0.200
    21.760    33.335     0.200
    21.819    35.315     0.200
    21.878    31.438     0.200
    21.878    30.484     0.200
    21.880    35.240     0.200
    21.899    34.698     0.200
    21.921    33.097     0.200
    21.927    32.502     0.200
    22.118    32.170     0.200
    22.220    32.594     0.200
    22.422    36.383     0.200
    22.521    34.396     0.200
    22.560    34.254     0.200
    22.684    35.035     0.200
    22.763    32.619     0.200
    22.805    33.934     0.200
    22.922    33.120     0.200
    22.995    33.060     0.200
    23.068    30.878     0.200
    23.296    33.240     0.200
    23.296    32.445     0.200
    23.694    29.235     0.200
    23.978    30.815     0.200
    24.235    29.776     0.200
    24.234    26.807     0.200
    24.234    26.347     0.200
    24.251    29.459     0.200
    24.356    29.832     0.200
    24.356    29.334     0.200
    24.592    26.365     0.200
    24.611    28.707     0.200
    24.740    28.640     0.200
    24.840    29.650     0.200
    24.912    26.896     0.200
    25.065    24.989     0.200
    25.106    26.925     0.200
    25.194    24.974     0.200
    25.497    24.570     0.200
    25.553    25.770     0.200
    25.582    26.093     0.200
    25.589    25.647     0.200
    25.745    25.345     0.200
    25.831    25.208     0.200
    25.870    23.326     0.200
    25.870    22.810     0.200
    25.889    25.183     0.200
    25.932    25.757     0.200
    26.748    19.747     0.200
    27.313    18.885     0.200
    28.088    16.132     0.200
    28.988    14.281     0.200
    24.399    30.621     0.200
    13.943    36.873     0.200
    14.739    38.648     0.200
    15.912    38.852     0.200
    16.943    39.213     0.200
    18.178    36.397     0.200
    21.925    36.570     0.200
    22.073    31.991     0.200
    22.579    35.869     0.200
    22.738    33.225     0.200
    22.764    35.745     0.200
    23.413    33.402     0.200
    24.474    26.890     0.200
    24.748    30.180     0.200
    24.748    28.935     0.200
    25.471    26.460     0.200
    26.326    24.526     0.200
    26.398    24.115     0.200
    26.471    24.594     0.200
    26.506    24.441     0.200
    26.667    23.798     0.200
    26.853    22.545     0.200
    13.533    36.156     0.200
    13.538    35.814     0.200
    13.606    33.488     0.200
    13.846    35.777     0.200
    13.873    35.575     0.200
    13.906    34.981     0.200
    13.912    35.379     0.200
    14.128    34.266     0.200
    14.157    35.578     0.200
    14.199    35.179     0.200
    14.270    35.413     0.200
    14.453    34.134     0.200
    14.478    35.072     0.200
    14.628    33.769     0.200
    14.761    34.694     0.200
    14.765    34.897     0.200
    14.845    34.163     0.200
    14.934    35.235     0.200
    14.934    35.118     0.200
    15.025    35.215     0.200
    15.065    34.893     0.200
    15.031    34.341     0.200
    15.031    34.454     0.200
    15.384    34.323     0.200
    15.415    34.498     0.200
    15.465    33.768     0.200
    15.609    33.246     0.200
    15.622    34.548     0.200
    15.682    35.404     0.200
    15.778    34.045     0.200
    15.822    34.369     0.200
    15.810    35.595     0.200
    15.885    33.566     0.200
    15.912    34.507     0.200
    16.009    33.992     0.200
    16.209    34.063     0.200
    16.209    36.683     0.200
    16.257    33.625     0.200
    16.257    34.271     0.200
    16.594    33.487     0.200
    16.599    33.242     0.200
    16.604    33.993     0.200
    16.695    35.577     0.200
    16.816    36.798     0.200
    16.875    33.598     0.200
    16.990    33.394     0.200
    17.063    34.155     0.200
    17.084    33.631     0.200
    17.168    33.334     0.200
    17.168    33.639     0.200
    17.135    36.852     0.200
    17.167    36.788     0.200
    17.354    33.018     0.200
    17.351    31.741     0.200
    17.477    32.884     0.200
    17.573    32.909     0.200
    17.605    32.517     0.200
    17.605    31.697     0.200
    17.689    32.433     0.200
    17.683    32.755     0.200
    17.854    32.814     0.200
    17.854    32.391     0.200
    17.878    32.119     0.200
    18.015    32.581     0.200
    18.015    32.192     0.200
    18.030    31.919     0.200
    18.084    33.050     0.200
    18.174    32.530     0.200
    18.174    32.702     0.200
    18.199    31.895     0.200
    18.333    32.095     0.200
    18.380    31.411     0.200
    18.373    31.673     0.200
    18.373    32.825     0.200
    18.436    32.028     0.200
    18.478    31.935     0.200
    18.677    32.204     0.200
    18.684    31.650     0.200
    18.702    32.422     0.200
    18.700    31.878     0.200
    18.715    32.370     0.200
    18.756    32.233     0.200
    18.746    31.999     0.200
    18.795    32.379     0.200
    18.919    32.176     0.200
    18.961    32.188     0.200
    18.961    31.235     0.200
    18.980    31.718     0.200
    19.001    31.916     0.200
    19.056    31.384     0.200
    19.241    31.432     0.200
    19.269    31.481     0.200
    19.342    31.535     0.200
    19.404    31.003     0.200
    19.441    32.210     0.200
    19.464    31.319     0.200
    19.519    31.107     0.200
    19.530    31.214     0.200
    19.605    31.437     0.200
    19.629    30.994     0.200
    19.756    30.900     0.200
    19.842    30.981     0.200
    19.846    30.794     0.200
    19.878    30.773     0.200
    19.886    31.141     0.200
    19.964    31.195     0.200
    19.964    31.581     0.200
    19.967    32.504     0.200
    19.967    31.326     0.200
    20.003    31.051     0.200
    20.016    30.471     0.200
    20.009    32.758     0.200
    20.058    30.636     0.200
    20.149    31.173     0.200
    20.155    30.601     0.200
    20.198    30.530     0.200
    20.212    30.701     0.200
    20.285    30.341     0.200
    20.340    30.092     0.200
    20.457    29.987     0.200
    20.501    30.197     0.200
    20.525    30.255     0.200
    20.502    32.425     0.200
    20.547    32.324     0.200
    20.548    30.562     0.200
    20.633    31.350     0.200
    20.682    29.889     0.200
    20.693    29.000     0.200
    20.701    29.990     0.200
    20.702    30.376     0.200
    20.775    31.901     0.200
    20.778    30.332     0.200
    20.794    30.401     0.200
    20.794    30.002     0.200
    20.813    35.287     0.200
    20.880    32.338     0.200
    20.973    29.223     0.200
    20.976    32.156     0.200
    21.056    32.717     0.200
    21.096    28.791     0.200
    21.114    29.795     0.200
    21.158    29.943     0.200
    21.183    29.366     0.200
    21.173    30.121     0.200
    21.304    31.924     0.200
    21.341    29.143     0.200
    21.376    28.932     0.200
    21.426    27.759     0.200
    21.497    29.087     0.200
    21.512    28.853     0.200
    21.526    28.737     0.200
    21.530    29.429     0.200
    21.525    32.994     0.200
    21.578    28.668     0.200
    21.550    31.822     0.200
    21.550    32.215     0.200
    21.634    29.494     0.200
    21.670    29.525     0.200
    21.680    28.221     0.200
    21.730    28.749     0.200
    21.789    28.565     0.200
    21.811    28.775     0.200
    21.845    29.334     0.200
    21.865    28.113     0.200
    21.906    31.563     0.200
    21.956    27.625     0.200
    21.997    30.643     0.200
    22.066    28.036     0.200
    22.023    31.774     0.200
    22.067    28.478     0.200
    22.128    28.898     0.200
    22.158    28.196     0.200
    22.217    31.348     0.200
    22.217    30.783     0.200
    22.261    27.806     0.200
    22.324    27.716     0.200
    22.353    27.698     0.200
    22.438    27.572     0.200
    22.469    28.077     0.200
    22.481    27.927     0.200
    22.547    27.212     0.200
    22.578    26.184     0.200
    22.599    27.503     0.200
    22.600    26.885     0.200
    22.685    27.695     0.200
    22.695    27.533     0.200
    22.733    27.623     0.200
    22.733    27.773     0.200
    22.788    28.973     0.200
    22.821    27.061     0.200
    22.929    29.145     0.200
    22.969    26.780     0.200
    22.976    27.025     0.200
    23.020    26.880     0.200
    23.042    26.488     0.200
    23.053    27.230     0.200
    23.099    26.529     0.200
    23.103    27.053     0.200
    23.132    26.474     0.200
    23.145    26.758     0.200
    23.247    26.487     0.200
    23.248    26.236     0.200
    23.287    26.321     0.200
    23.413    26.050     0.200
    23.461    26.324     0.200
    23.492    25.683     0.200
    23.535    25.756     0.200
    23.595    25.778     0.200
    23.591    26.590     0.200
    23.610    25.819     0.200
    23.615    26.607     0.200
    23.635    25.712     0.200
    23.728    24.972     0.200
    23.728    25.092     0.200
    23.725    26.580     0.200
    23.794    26.444     0.200
    23.794    26.591     0.200
    23.860    24.964     0.200
    23.840    26.962     0.200
    23.870    24.915     0.200
    23.873    25.113     0.200
    23.870    25.010     0.200
    23.884    25.005     0.200
    23.910    24.489     0.200
    23.984    26.077     0.200
    24.017    24.313     0.200
    24.049    24.185     0.200
    24.119    24.819     0.200
    24.262    24.200     0.200
    24.334    23.804     0.200
    24.340    24.421     0.200
    24.364    23.966     0.200
    24.368    25.581     0.200
    24.368    24.750     0.200
    24.368    25.389     0.200
    24.399    23.549     0.200
    24.497    23.417     0.200
    24.514    22.900     0.200
    24.500    23.835     0.200
    24.558    23.559     0.200
    24.604    23.114     0.200
    24.645    22.934     0.200
    24.658    22.613     0.200
    24.664    23.218     0.200
    24.651    25.520     0.200
    24.700    23.905     0.200
    24.715    22.672     0.200
    24.788    23.608     0.200
    24.869    22.470     0.200
    24.881    22.825     0.200
    24.921    22.092     0.200
    24.942    23.551     0.200
    25.013    21.245     0.200
    25.013    21.355     0.200
    24.993    23.517     0.200
    25.012    21.467     0.200
    25.082    21.617     0.200
    25.087    22.977     0.200
    25.124    21.682     0.200
    25.185    21.665     0.200
    25.252    23.289     0.200
    25.252    22.057     0.200
    25.312    20.827     0.200
    25.352    22.751     0.200
    25.522    20.478     0.200
    25.636    19.987     0.200
    25.679    19.873     0.200
    26.070    19.880     0.200
    26.170    17.798     0.200
    26.220    18.522     0.200
    26.531    17.685     0.200
    27.090    16.833     0.200
    27.119    13.796     0.200
    27.130    16.230     0.200
    27.605    16.026     0.200
    27.641    15.228     0.200
    27.703    15.085     0.200
    28.005    14.039     0.200
    29.402     9.714     0.200
    29.430     9.702     0.200
    29.499    10.784     0.200
    29.573     9.840     0.200
    29.810     9.094     0.200
    29.810     7.979     0.200
    29.870     9.196     0.200
    14.444    35.708     0.200
    14.966    36.593     0.200
    15.861    36.875     0.200
    16.530    36.790     0.200
    16.652    36.325     0.200
    16.950    38.312     0.200
    16.950    38.198     0.200
    17.666    38.359     0.200
    17.713    36.472     0.200
    17.947    35.149     0.200
    18.329    33.601     0.200
    18.452    35.366     0.200
    18.795    32.317     0.200
    18.856    33.025     0.200
    18.842    36.065     0.200
    19.022    33.814     0.200
    19.030    34.032     0.200
    19.113    34.088     0.200
    19.253    34.673     0.200
    19.346    34.159     0.200
    19.367    35.059     0.200
    19.594    33.875     0.200
    19.617    33.687     0.200
    19.636    34.371     0.200
    19.762    33.402     0.200
    19.822    33.569     0.200
    19.822    33.683     0.200
    19.821    33.639     0.200
    19.933    33.386     0.200
    19.948    33.322     0.200
    20.012    32.835     0.200
    20.113    33.817     0.200
    20.172    33.529     0.200
    20.216    32.770     0.200
    20.230    33.419     0.200
    20.292    33.093     0.200
    20.394    33.364     0.200
    20.444    33.133     0.200
    20.460    32.876     0.200
    20.508    31.968     0.200
    20.540    33.782     0.200
    20.543    34.799     0.200
    20.607    32.927     0.200
    20.618    32.876     0.200
    20.635    33.281     0.200
    20.648    33.073     0.200
    20.661    33.100     0.200
    20.848    33.025     0.200
    20.842    32.901     0.200
    20.852    33.409     0.200
    20.887    32.331     0.200
    21.031    32.939     0.200
    21.053    32.377     0.200
    21.100    33.088     0.200
    21.160    33.788     0.200
    21.221    35.980     0.200
    21.221    35.797     0.200
    21.323    32.597     0.200
    21.349    31.864     0.200
    21.341    35.257     0.200
    21.440    34.061     0.200
    21.487    31.052     0.200
    21.510    32.719     0.200
    21.536    31.488     0.200
    21.570    35.706     0.200
    21.583    34.343     0.200
    21.583    33.507     0.200
    21.632    31.177     0.200
    21.681    31.916     0.200
    21.753    31.725     0.200
    21.821    30.976     0.200
    21.829    32.392     0.200
    21.830    35.497     0.200
    21.889    30.560     0.200
    21.889    30.752     0.200
    21.904    29.684     0.200
    21.903    34.320     0.200
    21.919    32.050     0.200
    21.924    31.874     0.200
    21.924    30.948     0.200
    21.987    31.094     0.200
    22.084    31.431     0.200
    22.141    34.231     0.200
    22.155    33.728     0.200
    22.195    31.684     0.200
    22.295    31.238     0.200
    22.293    31.061     0.200
    22.322    31.777     0.200
    22.319    33.131     0.200
    22.408    29.438     0.200
    22.405    33.425     0.200
    22.448    30.411     0.200
    22.449    30.348     0.200
    22.543    31.894     0.200
    22.557    30.773     0.200
    22.564    30.474     0.200
    22.624    29.317     0.200
    22.669    30.540     0.200
    22.651    33.964     0.200
    22.702    33.288     0.200
    22.715    30.055     0.200
    22.742    30.316     0.200
    22.857    29.430     0.200
    22.888    31.031     0.200
    22.921    29.662     0.200
    22.938    30.187     0.200
    22.983    30.316     0.200
    22.992    31.024     0.200
    23.033    30.461     0.200
    23.049    32.938     0.200
    23.302    29.859     0.200
    23.379    29.472     0.200
    23.382    28.886     0.200
    23.404    28.856     0.200
    23.412    29.044     0.200
    23.427    29.398     0.200
    23.434    29.072     0.200
    23.528    28.658     0.200
    23.556    28.938     0.200
    23.600    28.904     0.200
    23.588    31.345     0.200
    23.621    29.289     0.200
    23.723    28.967     0.200
    23.846    27.760     0.200
    23.846    26.963     0.200
    23.866    28.116     0.200
    23.926    27.916     0.200
    23.971    27.822     0.200
    23.970    28.204     0.200
    24.196    27.421     0.200
    24.177    30.743     0.200
    24.220    27.044     0.200
    24.285    27.292     0.200
    24.285    26.510     0.200
    24.311    26.994     0.200
    24.313    27.517     0.200
    24.313    30.075     0.200
    24.384    29.890     0.200
    24.384    30.511     0.200
    24.503    27.968     0.200
    24.539    27.850     0.200
    24.574    25.953     0.200
    24.628    26.449     0.200
    24.629    27.018     0.200
    24.666    25.757     0.200
    24.767    25.292     0.200
    24.764    26.151     0.200
    24.800    25.358     0.200
    24.806    25.765     0.200
    24.827    26.367     0.200
    24.843    25.592     0.200
    24.843    25.456     0.200
    25.016    29.057     0.200
    25.058    25.097     0.200
    25.072    23.950     0.200
    25.072    25.293     0.200
    25.101    24.576     0.200
    25.118    26.704     0.200
    25.118    25.830     0.200
    25.118    27.115     0.200
    25.118    26.060     0.200
    25.219    24.635     0.200
    25.275    24.118     0.200
    25.308    24.533     0.200
    25.327    26.779     0.200
    25.461    24.531     0.200
    25.461    25.540     0.200
    25.492    24.084     0.200
    25.511    23.874     0.200
    25.609    23.810     0.200
    25.739    22.321     0.200
    25.787    23.564     0.200
    25.815    21.774     0.200
    25.874    22.968     0.200
    25.963    22.599     0.200
    26.095    22.003     0.200
    26.273    23.554     0.200
    26.312    23.411     0.200
    26.373    21.363     0.200
    26.423    22.290     0.200
    26.456    21.224     0.200
    26.506    21.731     0.200
    26.572    20.776     0.200
    26.572    20.654     0.200
    26.695    20.775     0.200
    26.757    20.192     0.200
    26.890    21.925     0.200
    26.914    19.034     0.200
    26.987    20.527     0.200
    27.035    19.898     0.200
    27.037    20.525     0.200
    27.052    19.910     0.200
    27.108    20.252     0.200
    27.139    21.167     0.200
    27.309    18.922     0.200
    27.333    20.621     0.200
    27.612    17.936     0.200
    27.772    19.176     0.200
    27.862    17.866     0.200
    28.148    16.886     0.200
    28.161    16.899     0.200
    28.265    18.796     0.200
    28.265    18.140     0.200
    28.418    15.928     0.200
    28.453    16.040     0.200
    28.670    16.592     0.200
    28.707    15.299     0.200
    28.692    18.153     0.200
    28.908    15.489     0.200
    29.100    14.439     0.200
    29.230    13.973     0.200
    29.241    13.615     0.200
    29.326    13.852     0.200
    29.529    13.933     0.200
    29.576    13.599     0.200
    29.625    12.642     0.200
    29.630    13.827     0.200
    29.869    12.220     0.200
    29.889    11.960     0.200
    14.521    41.001     0.200
    15.108    40.720     0.200
    15.442    42.030     0.200
    15.480    41.490     0.200
    15.668    40.421     0.200
    16.793    41.367     0.200
    16.855    41.219     0.200
    17.428    41.717     0.200
    17.959    42.050     0.200
    18.211    41.285     0.200
    18.306    37.366     0.200
    18.306    36.246     0.200
    18.525    40.507     0.200
    18.526    39.693     0.200
    18.526    39.166     0.200
    18.653    37.336     0.200
    18.653    37.144     0.200
    18.795    40.684     0.200
    18.749    37.063     0.200
    18.772    37.548     0.200
    18.838    38.827     0.200
    18.841    39.506     0.200
    19.057    39.598     0.200
    19.057    39.891     0.200
    19.059    37.594     0.200
    19.074    39.020     0.200
    19.074    39.369     0.200
    19.186    39.455     0.200
    19.316    39.624     0.200
    19.316    40.026     0.200
    19.347    40.813     0.200
    19.383    36.415     0.200
    19.373    37.482     0.200
    19.430    37.268     0.200
    19.629    38.573     0.200
    19.578    37.577     0.200
    19.621    37.399     0.200
    19.621    37.784     0.200
    19.630    37.260     0.200
    19.698    37.792     0.200
    19.691    38.211     0.200
    19.718    37.438     0.200
    19.738    36.723     0.200
    19.752    37.016     0.200
    19.851    35.797     0.200
    19.817    36.945     0.200
    19.969    39.972     0.200
    19.920    36.151     0.200
    19.966    38.969     0.200
    19.953    36.438     0.200
    19.922    38.856     0.200
    20.015    38.867     0.200
    19.977    36.521     0.200
    20.061    39.210     0.200
    20.054    36.668     0.200
    20.154    35.582     0.200
    20.208    38.671     0.200
    20.186    35.657     0.200
    20.180    36.314     0.200
    20.225    36.611     0.200
    20.281    37.957     0.200
    20.228    36.298     0.200
    20.291    37.062     0.200
    20.240    36.722     0.200
    20.327    39.573     0.200
    20.265    36.112     0.200
    20.309    35.999     0.200
    20.325    36.837     0.200
    20.348    36.119     0.200
    20.365    34.763     0.200
    20.365    35.507     0.200
    20.428    38.063     0.200
    20.482    36.152     0.200
    20.534    38.678     0.200
    20.542    38.647     0.200
    20.519    35.459     0.200
    20.547    35.570     0.200
    20.631    37.926     0.200
    20.636    35.819     0.200
    20.658    35.899     0.200
    20.666    35.999     0.200
    20.746    38.452     0.200
    20.700    35.516     0.200
    20.781    38.802     0.200
    20.775    36.200     0.200
    20.799    35.796     0.200
    20.799    35.475     0.200
    20.855    35.173     0.200
    20.839    35.798     0.200
    20.863    35.437     0.200
    20.863    35.171     0.200
    20.971    34.861     0.200
    20.966    35.029     0.200
    21.001    35.330     0.200
    21.124    35.358     0.200
    21.212    37.908     0.200
    21.177    35.499     0.200
    21.200    35.145     0.200
    21.237    38.814     0.200
    21.264    37.937     0.200
    21.274    38.377     0.200
    21.202    35.501     0.200
    21.303    37.487     0.200
    21.259    35.156     0.200
    21.322    37.897     0.200
    21.273    35.555     0.200
    21.263    34.424     0.200
    21.296    34.588     0.200
    21.296    34.909     0.200
    21.385    38.272     0.200
    21.352    35.289     0.200
    21.363    35.141     0.200
    21.383    35.439     0.200
    21.383    35.859     0.200
    21.397    34.696     0.200
    21.475    37.914     0.200
    21.488    38.036     0.200
    21.414    34.904     0.200
    21.460    34.605     0.200
    21.487    35.087     0.200
    21.590    34.916     0.200
    21.603    34.031     0.200
    21.669    37.607     0.200
    21.637    34.663     0.200
    21.666    34.782     0.200
    21.700    34.163     0.200
    21.702    34.696     0.200
    21.714    34.035     0.200
    21.741    34.398     0.200
    21.778    33.904     0.200
    21.847    34.220     0.200
    21.860    37.163     0.200
    21.860    37.059     0.200
    21.939    38.427     0.200
    21.860    34.596     0.200
    21.902    34.118     0.200
    21.928    33.685     0.200
    22.028    33.181     0.200
    22.053    33.702     0.200
    22.088    33.488     0.200
    22.091    33.907     0.200
    22.183    33.951     0.200
    22.181    33.207     0.200
    22.277    36.875     0.200
    22.231    33.936     0.200
    22.240    33.841     0.200
    22.236    33.218     0.200
    22.273    33.054     0.200
    22.273    33.583     0.200
    22.248    33.385     0.200
    22.248    33.557     0.200
    22.363    35.860     0.200
    22.363    36.007     0.200
    22.330    33.334     0.200
    22.381    32.879     0.200
    22.407    32.658     0.200
    22.420    32.831     0.200
    22.427    32.559     0.200
    22.473    34.315     0.200
    22.475    33.141     0.200
    22.526    35.728     0.200
    22.572    33.357     0.200
    22.573    32.615     0.200
    22.722    35.987     0.200
    22.719    32.152     0.200
    22.738    32.634     0.200
    22.726    32.116     0.200
    22.883    32.522     0.200
    22.952    36.043     0.200
    22.918    33.415     0.200
    22.953    31.841     0.200
    23.038    32.367     0.200
    23.034    32.433     0.200
    23.057    33.222     0.200
    23.068    32.851     0.200
    23.122    34.920     0.200
    23.201    32.432     0.200
    23.214    32.166     0.200
    23.288    36.490     0.200
    23.207    31.379     0.200
    23.238    32.346     0.200
    23.294    32.209     0.200
    23.389    31.502     0.200
    23.468    35.894     0.200
    23.406    31.970     0.200
    23.423    31.247     0.200
    23.452    31.611     0.200
    23.536    35.007     0.200
    23.536    35.036     0.200
    23.610    31.426     0.200
    23.689    34.941     0.200
    23.647    31.133     0.200
    23.672    31.737     0.200
    23.682    31.141     0.200
    23.672    30.818     0.200
    23.721    30.839     0.200
    23.797    35.490     0.200
    23.795    31.216     0.200
    23.776    30.597     0.200
    23.828    31.316     0.200
    23.943    34.345     0.200
    23.885    31.854     0.200
    23.939    33.337     0.200
    23.922    30.889     0.200
    23.938    30.498     0.200
    23.932    31.091     0.200
    23.961    31.202     0.200
    24.141    35.054     0.200
    24.167    31.625     0.200
    24.152    30.626     0.200
    24.170    30.334     0.200
    24.265    33.002     0.200
    24.241    30.362     0.200
    24.262    30.141     0.200
    24.336    29.974     0.200
    24.410    32.069     0.200
    24.360    29.476     0.200
    24.500    30.541     0.200
    24.512    29.051     0.200
    24.520    29.324     0.200
    24.520    29.668     0.200
    24.570    29.453     0.200
    24.597    29.438     0.200
    24.642    31.898     0.200
    24.642    31.130     0.200
    24.642    30.468     0.200
    24.713    32.190     0.200
    24.689    28.725     0.200
    24.725    29.502     0.200
    24.862    32.828     0.200
    24.799    28.535     0.200
    24.799    29.271     0.200
    24.835    32.773     0.200
    24.978    28.744     0.200
    25.060    32.444     0.200
    24.956    32.153     0.200
    25.054    27.432     0.200
    25.191    27.496     0.200
    25.253    30.921     0.200
    25.233    28.101     0.200
    25.221    28.295     0.200
    25.221    28.703     0.200
    25.262    27.300     0.200
    25.255    27.227     0.200
    25.383    27.586     0.200
    25.493    29.308     0.200
    25.523    27.903     0.200
    25.649    30.857     0.200
    25.583    27.289     0.200
    25.650    29.200     0.200
    25.636    26.258     0.200
    25.749    26.153     0.200
    25.808    30.351     0.200
    25.806    27.334     0.200
    25.820    25.755     0.200
    25.820    26.124     0.200
    25.979    29.612     0.200
    26.032    25.426     0.200
    26.032    25.657     0.200
    26.265    31.324     0.200
    26.327    23.969     0.200
    26.402    24.550     0.200
    26.813    26.755     0.200
    26.861    24.639     0.200
    26.828    22.916     0.200
    26.828    24.806     0.200
    26.972    26.080     0.200
    27.078    22.312     0.200
    27.106    22.493     0.200
    27.151    22.181     0.200
    27.235    26.083     0.200
    27.229    22.185     0.200
    27.693    24.274     0.200
    28.319    17.855     0.200
    28.512    17.940     0.200
    28.590    17.485     0.200
    28.629    17.909     0.200
    28.889    21.718     0.200
    29.233    16.246     0.200
    29.530    19.036     0.200
    29.548    18.718     0.200
    29.521    15.971     0.200
    29.537    15.619     0.200
    29.569    15.760     0.200
    29.653    18.216     0.200
    29.799    14.551     0.200
    29.995    14.054     0.200
    15.041    40.028     0.200
    15.843    40.258     0.200
    15.843    39.985     0.200
    16.322    40.520     0.200
    16.322    40.525     0.200
    16.341    40.972     0.200
    16.451    41.054     0.200
    16.683    41.424     0.200
    17.088    41.945     0.200
    17.088    41.601     0.200
    17.088    40.648     0.200
    17.088    41.796     0.200
    17.539    41.467     0.200
    17.581    40.931     0.200
    17.958    40.286     0.200
    18.017    42.301     0.200
    18.110    39.533     0.200
    18.114    43.255     0.200
    18.343    39.289     0.200
    18.353    39.671     0.200
    18.393    38.818     0.200
    18.393    38.506     0.200
    18.348    42.367     0.200
    18.348    41.945     0.200
    18.586    39.091     0.200
    18.584    39.252     0.200
    18.599    39.177     0.200
    18.652    38.826     0.200
    18.660    39.016     0.200
    18.718    39.294     0.200
    18.798    38.865     0.200
    18.847    38.519     0.200
    18.984    38.998     0.200
    19.001    39.108     0.200
    19.037    38.702     0.200
    19.044    38.699     0.200
    19.110    38.448     0.200
    19.126    39.100     0.200
    19.160    37.296     0.200
    19.250    38.983     0.200
    19.407    38.547     0.200
    19.426    38.544     0.200
    19.488    38.149     0.200
    19.502    38.838     0.200
    19.501    38.138     0.200
    19.554    38.805     0.200
    19.570    37.410     0.200
    19.553    39.119     0.200
    19.620    38.875     0.200
    19.757    38.791     0.200
    19.790    38.076     0.200
    19.790    38.559     0.200
    19.871    38.062     0.200
    19.893    38.209     0.200
    19.887    39.095     0.200
    19.929    38.228     0.200
    19.979    37.273     0.200
    20.030    38.128     0.200
    20.045    38.116     0.200
    20.048    38.151     0.200
    20.037    38.192     0.200
    20.044    37.409     0.200
    20.108    38.024     0.200
    20.121    37.733     0.200
    20.147    38.538     0.200
    20.259    37.903     0.200
    20.263    37.682     0.200
    20.321    37.233     0.200
    20.321    37.374     0.200
    20.350    37.963     0.200
    20.397    37.582     0.200
    20.433    37.268     0.200
    20.459    36.732     0.200
    20.425    39.412     0.200
    20.488    37.247     0.200
    20.511    36.919     0.200
    20.527    37.593     0.200
    20.539    37.335     0.200
    20.431    41.073     0.200
    20.600    37.297     0.200
    20.624    37.696     0.200
    20.655    37.642     0.200
    20.647    37.216     0.200
    20.647    37.114     0.200
    20.699    36.829     0.200
    20.736    37.525     0.200
    20.765    37.140     0.200
    20.761    38.032     0.200
    20.799    37.207     0.200
    20.841    37.867     0.200
    20.854    38.801     0.200
    20.896    39.033     0.200
    20.920    37.242     0.200
    20.913    37.729     0.200
    20.935    36.974     0.200
    20.990    36.723     0.200
    21.018    37.069     0.200
    21.045    36.381     0.200
    21.004    38.988     0.200
    21.048    36.062     0.200
    21.084    36.814     0.200
    21.078    35.726     0.200
    21.108    36.808     0.200
    21.133    36.213     0.200
    21.143    36.662     0.200
    21.107    40.332     0.200
    21.124    39.899     0.200
    21.124    40.001     0.200
    21.175    36.598     0.200
    21.203    35.658     0.200
    21.178    40.335     0.200
    21.185    40.008     0.200
    21.271    36.721     0.200
    21.253    35.850     0.200
    21.215    39.711     0.200
    21.215    38.641     0.200
    21.307    36.118     0.200
    21.286    35.942     0.200
    21.312    38.636     0.200
    21.295    39.378     0.200
    21.343    36.167     0.200
    21.337    39.255     0.200
    21.325    39.764     0.200
    21.395    36.150     0.200
    21.398    35.772     0.200
    21.388    39.642     0.200
    21.299    40.308     0.200
    21.422    35.756     0.200
    21.469    36.062     0.200
    21.451    39.563     0.200
    21.485    36.306     0.200
    21.476    35.498     0.200
    21.480    34.942     0.200
    21.446    39.015     0.200
    21.474    39.704     0.200
    21.504    35.426     0.200
    21.525    36.307     0.200
    21.492    35.809     0.200
    21.523    35.299     0.200
    21.555    36.770     0.200
    21.563    35.759     0.200
    21.514    39.776     0.200
    21.563    35.322     0.200
    21.594    35.853     0.200
    21.575    38.453     0.200
    21.634    35.538     0.200
    21.650    36.445     0.200
    21.650    36.695     0.200
    21.673    36.336     0.200
    21.651    35.361     0.200
    21.642    39.361     0.200
    21.667    39.462     0.200
    21.667    39.134     0.200
    21.667    38.762     0.200
    21.753    35.905     0.200
    21.765    36.392     0.200
    21.746    35.064     0.200
    21.721    39.229     0.200
    21.766    38.104     0.200
    21.766    37.658     0.200
    21.781    35.937     0.200
    21.763    35.044     0.200
    21.810    39.123     0.200
    21.782    38.675     0.200
    21.713    39.674     0.200
    21.858    35.734     0.200
    21.899    38.183     0.200
    21.928    35.706     0.200
    21.950    35.609     0.200
    21.938    34.579     0.200
    21.928    34.735     0.200
    21.947    34.936     0.200
    21.987    35.088     0.200
    21.975    34.524     0.200
    21.975    34.626     0.200
    21.992    35.440     0.200
    21.967    38.499     0.200
    21.971    37.065     0.200
    22.004    34.911     0.200
    22.022    35.733     0.200
    21.973    36.188     0.200
    22.024    34.300     0.200
    22.062    35.133     0.200
    22.077    35.133     0.200
    22.076    38.043     0.200
    22.061    38.888     0.200
    22.064    38.549     0.200
    22.110    34.570     0.200
    22.110    36.039     0.200
    22.095    38.817     0.200
    22.148    35.177     0.200
    22.134    34.194     0.200
    22.181    35.721     0.200
    22.132    38.440     0.200
    22.157    39.089     0.200
    22.157    38.105     0.200
    22.207    34.144     0.200
    22.269    35.087     0.200
    22.308    34.985     0.200
    22.285    38.082     0.200
    22.323    35.207     0.200
    22.326    34.636     0.200
    22.283    38.190     0.200
    22.287    38.773     0.200
    22.287    38.171     0.200
    22.368    35.290     0.200
    22.368    34.422     0.200
    22.383    34.710     0.200
    22.364    34.197     0.200
    22.356    34.661     0.200
    22.388    34.602     0.200
    22.388    34.086     0.200
    22.368    37.415     0.200
    22.396    35.650     0.200
    22.389    37.726     0.200
    22.449    34.469     0.200
    22.441    38.185     0.200
    22.451    37.580     0.200
    22.451    37.463     0.200
    22.460    33.536     0.200
    22.464    33.294     0.200
    22.488    33.454     0.200
    22.524    34.903     0.200
    22.498    38.248     0.200
    22.529    34.466     0.200
    22.537    35.889     0.200
    22.608    34.950     0.200
    22.645    34.188     0.200
    22.631    33.603     0.200
    22.629    34.962     0.200
    22.665    34.783     0.200
    22.647    37.420     0.200
    22.671    35.364     0.200
    22.682    34.584     0.200
    22.662    34.202     0.200
    22.660    38.102     0.200
    22.700    37.737     0.200
    22.743    34.469     0.200
    22.729    38.157     0.200
    22.767    33.522     0.200
    22.773    33.440     0.200
    22.797    36.355     0.200
    22.797    36.167     0.200
    22.754    38.292     0.200
    22.874    34.595     0.200
    22.882    36.142     0.200
    22.882    37.134     0.200
    22.909    33.786     0.200
    22.918    33.920     0.200
    22.921    34.786     0.200
    22.953    33.814     0.200
    22.957    34.221     0.200
    22.901    38.084     0.200
    22.963    32.764     0.200
    22.983    33.119     0.200
    23.054    34.481     0.200
    23.023    37.320     0.200
    23.023    36.992     0.200
    23.064    34.841     0.200
    23.081    34.184     0.200
    23.071    33.826     0.200
    23.100    34.105     0.200
    23.119    36.517     0.200
    23.151    33.983     0.200
    23.176    33.515     0.200
    23.190    36.974     0.200
    23.219    34.107     0.200
    23.181    37.420     0.200
    23.243    36.624     0.200
    23.207    37.954     0.200
    23.274    33.754     0.200
    23.276    33.763     0.200
    23.341    34.371     0.200
    23.359    33.661     0.200
    23.363    33.161     0.200
    23.389    33.665     0.200
    23.339    36.015     0.200
    23.386    36.361     0.200
    23.418    33.300     0.200
    23.394    36.822     0.200
    23.431    33.741     0.200
    23.417    32.559     0.200
    23.450    33.879     0.200
    23.491    31.872     0.200
    23.509    32.069     0.200
    23.549    34.093     0.200
    23.604    34.622     0.200
    23.604    34.427     0.200
    23.615    35.157     0.200
    23.644    32.988     0.200
    23.635    36.043     0.200
    23.668    33.664     0.200
    23.676    35.417     0.200
    23.756    33.321     0.200
    23.781    35.194     0.200
    23.810    33.091     0.200
    23.812    34.813     0.200
    23.843    33.301     0.200
    23.844    32.714     0.200
    23.854    33.074     0.200
    23.798    37.110     0.200
    23.884    32.635     0.200
    23.888    33.183     0.200
    23.920    33.678     0.200
    23.947    32.756     0.200
    23.965    33.524     0.200
    23.958    36.621     0.200
    24.018    32.792     0.200
    24.041    32.093     0.200
    23.997    35.294     0.200
    23.995    36.146     0.200
    24.087    34.873     0.200
    24.114    33.170     0.200
    24.119    32.903     0.200
    24.120    31.495     0.200
    24.116    34.803     0.200
    24.157    32.265     0.200
    24.119    35.661     0.200
    24.209    33.249     0.200
    24.097    35.144     0.200
    24.097    34.574     0.200
    24.246    35.430     0.200
    24.293    31.852     0.200
    24.296    31.898     0.200
    24.310    32.286     0.200
    24.315    35.459     0.200
    24.315    35.427     0.200
    24.379    31.161     0.200
    24.368    34.144     0.200
    24.396    31.871     0.200
    24.420    31.574     0.200
    24.421    31.771     0.200
    24.363    35.186     0.200
    24.453    32.285     0.200
    24.453    31.954     0.200
    24.435    33.661     0.200
    24.471    31.397     0.200
    24.471    30.000     0.200
    24.483    31.943     0.200
    24.487    31.655     0.200
    24.525    33.470     0.200
    24.549    32.837     0.200
    24.513    34.006     0.200
    24.586    32.927     0.200
    24.578    34.719     0.200
    24.657    30.926     0.200
    24.669    30.663     0.200
    24.680    32.589     0.200
    24.680    32.206     0.200
    24.706    31.100     0.200
    24.710    30.906     0.200
    24.716    32.185     0.200
    24.728    30.616     0.200
    24.673    34.311     0.200
    24.667    35.022     0.200
    24.714    34.374     0.200
    24.764    31.438     0.200
    24.754    32.977     0.200
    24.778    30.718     0.200
    24.752    33.420     0.200
    24.826    30.400     0.200
    24.769    33.299     0.200
    24.823    34.162     0.200
    24.857    31.368     0.200
    24.871    30.551     0.200
    24.817    33.984     0.200
    24.954    30.729     0.200
    24.957    31.044     0.200
    24.895    33.658     0.200
    24.932    34.109     0.200
    25.051    29.894     0.200
    25.071    29.863     0.200
    25.096    30.001     0.200
    25.077    30.772     0.200
    25.101    29.592     0.200
    25.101    29.959     0.200
    25.114    30.361     0.200
    25.124    29.738     0.200
    25.152    30.050     0.200
    25.176    29.732     0.200
    25.202    30.200     0.200
    25.152    32.645     0.200
    25.207    30.025     0.200
    25.195    29.320     0.200
    25.219    29.361     0.200
    25.234    29.311     0.200
    25.253    29.608     0.200
    25.243    30.711     0.200
    25.243    29.367     0.200
    25.243    30.798     0.200
    25.243    30.727     0.200
    25.243    30.384     0.200
    25.120    32.608     0.200
    25.288    29.376     0.200
    25.290    29.074     0.200
    25.307    29.342     0.200
    25.307    28.436     0.200
    25.324    29.837     0.200
    25.377    30.001     0.200
    25.389    29.360     0.200
    25.414    29.671     0.200
    25.415    29.162     0.200
    25.383    32.425     0.200
    25.441    29.056     0.200
    25.458    31.996     0.200
    25.514    29.452     0.200
    25.525    28.521     0.200
    25.573    29.278     0.200
    25.566    29.929     0.200
    25.622    28.082     0.200
    25.622    28.270     0.200
    25.656    28.840     0.200
    25.662    28.327     0.200
    25.691    28.246     0.200
    25.647    32.062     0.200
    25.710    28.138     0.200
    25.757    28.072     0.200
    25.711    32.528     0.200
    25.805    28.639     0.200
    25.838    27.672     0.200
    25.881    27.482     0.200
    25.838    31.509     0.200
    25.904    27.433     0.200
    25.962    27.375     0.200
    25.966    27.325     0.200
    25.976    29.208     0.200
    25.976    28.552     0.200
    26.035    27.423     0.200
    26.077    27.296     0.200
    26.077    26.616     0.200
    26.079    28.910     0.200
    26.054    30.559     0.200
    26.120    27.457     0.200
    26.120    27.183     0.200
    26.130    27.878     0.200
    26.159    26.564     0.200
    26.171    26.603     0.200
    26.153    29.094     0.200
    26.194    27.039     0.200
    26.222    28.659     0.200
    26.270    27.117     0.200
    26.274    26.027     0.200
    26.274    26.651     0.200
    26.265    28.458     0.200
    26.369    26.454     0.200
    26.388    26.117     0.200
    26.392    25.907     0.200
    26.394    26.587     0.200
    26.380    27.998     0.200
    26.347    29.049     0.200
    26.425    27.217     0.200
    26.435    29.858     0.200
    26.491    26.715     0.200
    26.497    25.697     0.200
    26.503    25.789     0.200
    26.551    26.363     0.200
    26.552    26.381     0.200
    26.580    26.450     0.200
    26.528    29.871     0.200
    26.608    27.557     0.200
    26.655    25.133     0.200
    26.665    25.122     0.200
    26.558    29.323     0.200
    26.696    25.151     0.200
    26.741    26.198     0.200
    26.778    28.982     0.200
    26.830    25.271     0.200
    26.893    24.303     0.200
    26.903    24.285     0.200
    26.923    25.025     0.200
    26.937    27.167     0.200
    26.940    27.139     0.200
    26.988    24.545     0.200
    26.939    28.296     0.200
    27.020    24.929     0.200
    27.010    27.055     0.200
    27.068    24.603     0.200
    27.116    27.624     0.200
    27.138    25.427     0.200
    27.173    24.630     0.200
    27.184    23.485     0.200
    27.201    24.177     0.200
    27.214    23.808     0.200
    27.193    26.826     0.200
    27.193    26.521     0.200
    27.239    24.135     0.200
    27.257    23.697     0.200
    27.320    26.822     0.200
    27.348    23.901     0.200
    27.351    25.908     0.200
    27.372    23.562     0.200
    27.389    23.668     0.200
    27.431    23.282     0.200
    27.442    25.805     0.200
    27.453    23.345     0.200
    27.467    23.178     0.200
    27.469    23.614     0.200
    27.471    23.798     0.200
    27.476    24.803     0.200
    27.495    22.839     0.200
    27.478    25.285     0.200
    27.482    26.147     0.200
    27.511    25.859     0.200
    27.569    22.956     0.200
    27.604    25.791     0.200
    27.537    26.129     0.200
    27.720    22.912     0.200
    27.733    22.650     0.200
    27.741    22.476     0.200
    27.714    25.574     0.200
    27.754    22.894     0.200
    27.959    22.026     0.200
    27.968    22.053     0.200
    27.973    22.268     0.200
    27.986    21.385     0.200
    27.986    21.510     0.200
    28.027    21.947     0.200
    28.027    21.627     0.200
    28.000    25.309     0.200
    28.043    21.452     0.200
    27.990    25.072     0.200
    28.073    23.170     0.200
    28.123    22.213     0.200
    28.131    21.293     0.200
    28.134    21.747     0.200
    28.042    24.935     0.200
    28.193    23.000     0.200
    28.220    21.011     0.200
    28.255    21.603     0.200
    28.308    21.164     0.200
    28.308    21.031     0.200
    28.350    20.701     0.200
    28.350    20.873     0.200
    28.358    20.896     0.200
    28.372    23.645     0.200
    28.377    23.199     0.200
    28.377    23.090     0.200
    28.424    23.905     0.200
    28.469    20.644     0.200
    28.434    23.835     0.200
    28.447    22.275     0.200
    28.545    20.436     0.200
    28.551    20.571     0.200
    28.578    20.710     0.200
    28.514    22.948     0.200
    28.656    21.018     0.200
    28.656    21.503     0.200
    28.624    23.225     0.200
    28.698    19.734     0.200
    28.699    20.509     0.200
    28.779    19.802     0.200
    28.772    22.112     0.200
    28.839    19.756     0.200
    28.843    19.578     0.200
    28.862    19.527     0.200
    28.719    22.310     0.200
    28.831    21.589     0.200
    28.913    19.167     0.200
    28.920    22.582     0.200
    28.975    19.188     0.200
    28.982    19.378     0.200
    29.002    19.337     0.200
    29.014    19.227     0.200
    29.037    19.164     0.200
    29.012    20.744     0.200
    29.067    19.098     0.200
    29.028    22.628     0.200
    29.111    18.707     0.200
    29.186    18.953     0.200
    29.202    19.186     0.200
    29.219    18.515     0.200
    29.255    18.939     0.200
    29.270    18.355     0.200
    29.232    21.631     0.200
    29.145    21.443     0.200
    29.280    20.260     0.200
    29.219    23.904     0.200
    29.219    22.935     0.200
    29.346    17.590     0.200
    29.346    18.059     0.200
    29.378    18.329     0.200
    29.381    17.821     0.200
    29.275    21.106     0.200
    29.399    17.657     0.200
    29.439    18.656     0.200
    29.460    17.978     0.200
    29.458    18.356     0.200
    29.437    20.452     0.200
    29.468    17.778     0.200
    29.489    17.370     0.200
    29.482    19.625     0.200
    29.498    17.544     0.200
    29.526    17.029     0.200
    29.516    20.283     0.200
    29.558    17.279     0.200
    29.556    17.676     0.200
    29.614    17.244     0.200
    29.628    18.198     0.200
    29.658    17.092     0.200
    29.544    20.326     0.200
    29.705    17.412     0.200
    29.723    17.239     0.200
    29.777    16.320     0.200
    29.690    19.790     0.200
    29.810    17.575     0.200
    29.810    17.762     0.200
    29.827    16.831     0.200
    29.794    19.659     0.200
    29.790    19.175     0.200
    29.874    16.682     0.200
    29.778    22.596     0.200
    29.876    20.040     0.200
    29.929    16.379     0.200
    29.934    17.133     0.200
    29.954    16.427     0.200
    29.987    15.543     0.200
    29.987    16.902     0.200
    29.883    22.273     0.200
    29.883    21.648     0.200
    29.987    19.985     0.200
    29.967    24.391     0.200
    14.641    39.199     0.200
    14.661    41.399     0.200
    14.661    39.134     0.200
    14.674    41.378     0.200
    15.364    41.688     0.200
    15.588    40.604     0.200
    15.588    39.642     0.200
    15.601    40.787     0.200
    15.601    40.070     0.200
    15.928    41.797     0.200
    15.989    42.740     0.200
    16.002    40.239     0.200
    16.148    42.506     0.200
    16.260    41.149     0.200
    16.260    40.614     0.200
    16.319    40.291     0.200
    16.493    40.056     0.200
    16.493    39.839     0.200
    16.569    40.549     0.200
    16.674    40.905     0.200
    16.745    41.335     0.200
    16.745    40.841     0.200
    17.053    41.915     0.200
    17.106    42.491     0.200
    17.474    40.283     0.200
    17.493    41.149     0.200
    17.686    41.858     0.200
    17.807    42.278     0.200
    18.183    42.806     0.200
    18.219    41.847     0.200
    18.219    42.048     0.200
    18.236    43.212     0.200
    18.320    38.748     0.200
    18.353    38.739     0.200
    18.353    38.854     0.200
    18.436    38.457     0.200
    18.716    38.114     0.200
    18.716    38.008     0.200
    18.771    38.382     0.200
    18.810    38.544     0.200
    18.810    38.306     0.200
    18.814    38.643     0.200
    18.870    37.913     0.200
    18.908    38.552     0.200
    18.908    38.000     0.200
    19.097    42.043     0.200
    19.180    38.247     0.200
    19.196    38.122     0.200
    19.205    38.701     0.200
    19.205    37.844     0.200
    19.300    39.328     0.200
    19.315    37.990     0.200
    19.415    39.075     0.200
    19.462    38.602     0.200
    19.462    38.024     0.200
    19.522    37.621     0.200
    19.551    39.730     0.200
    19.553    38.404     0.200
    19.553    38.043     0.200
    19.611    37.885     0.200
    19.632    38.500     0.200
    19.711    37.423     0.200
    19.711    38.118     0.200
    19.681    37.645     0.200
    19.686    38.966     0.200
    19.686    37.816     0.200
    19.781    37.682     0.200
    19.824    38.726     0.200
    19.824    37.978     0.200
    19.830    37.793     0.200
    19.909    37.271     0.200
    19.973    37.581     0.200
    20.060    37.296     0.200
    20.104    37.405     0.200
    20.111    37.123     0.200
    20.208    39.191     0.200
    20.247    37.071     0.200
    20.259    39.265     0.200
    20.280    38.669     0.200
    20.289    36.708     0.200
    20.311    39.612     0.200
    20.303    36.983     0.200
    20.311    37.138     0.200
    20.312    38.983     0.200
    20.336    36.241     0.200
    20.378    39.177     0.200
    20.382    39.229     0.200
    20.430    38.800     0.200
    20.446    39.218     0.200
    20.459    39.467     0.200
    20.462    37.692     0.200
    20.469    36.617     0.200
    20.486    38.798     0.200
    20.528    39.223     0.200
    20.534    38.057     0.200
    20.603    37.999     0.200
    20.620    37.854     0.200
    20.638    38.555     0.200
    20.671    38.805     0.200
    20.662    36.394     0.200
    20.677    37.251     0.200
    20.677    36.339     0.200
    20.675    36.415     0.200
    20.687    37.010     0.200
    20.687    36.571     0.200
    20.700    38.714     0.200
    20.719    36.461     0.200
    20.741    36.555     0.200
    20.740    36.026     0.200
    20.865    37.032     0.200
    20.865    36.698     0.200
    20.919    36.970     0.200
    20.954    36.906     0.200
    20.986    39.167     0.200
    20.980    38.807     0.200
    20.987    36.589     0.200
    21.005    35.895     0.200
    21.033    38.790     0.200
    21.066    36.405     0.200
    21.109    36.224     0.200
    21.175    39.392     0.200
    21.233    35.851     0.200
    21.267    35.748     0.200
    21.270    36.410     0.200
    21.270    35.345     0.200
    21.334    36.598     0.200
    21.334    35.852     0.200
    21.339    35.807     0.200
    21.343    34.826     0.200
    21.345    35.782     0.200
    21.442    36.582     0.200
    21.463    38.283     0.200
    21.491    35.236     0.200
    21.523    38.789     0.200
    21.533    37.956     0.200
    21.551    35.998     0.200
    21.557    37.753     0.200
    21.613    35.976     0.200
    21.613    35.493     0.200
    21.644    39.404     0.200
    21.644    38.859     0.200
    21.654    34.864     0.200
    21.699    35.722     0.200
    21.699    35.462     0.200
    21.710    36.555     0.200
    21.734    39.409     0.200
    21.734    39.085     0.200
    21.747    39.281     0.200
    21.757    34.437     0.200
    21.774    35.364     0.200
    21.772    36.040     0.200
    21.772    35.280     0.200
    21.780    35.757     0.200
    21.780    34.365     0.200
    21.800    34.917     0.200
    21.925    39.240     0.200
    22.018    35.037     0.200
    22.037    38.660     0.200
    22.023    35.331     0.200
    22.099    37.516     0.200
    22.099    36.505     0.200
    22.120    38.045     0.200
    22.105    35.639     0.200
    22.125    34.445     0.200
    22.152    35.144     0.200
    22.152    34.534     0.200
    22.198    38.904     0.200
    22.204    37.682     0.200
    22.223    34.795     0.200
    22.230    34.964     0.200
    22.258    34.091     0.200
    22.330    38.346     0.200
    22.321    34.274     0.200
    22.360    34.442     0.200
    22.406    34.927     0.200
    22.406    34.476     0.200
    22.475    34.226     0.200
    22.509    34.321     0.200
    22.534    37.815     0.200
    22.534    37.684     0.200
    22.518    34.320     0.200
    22.525    34.088     0.200
    22.555    33.702     0.200
    22.574    36.914     0.200
    22.574    35.418     0.200
    22.644    34.286     0.200
    22.661    34.165     0.200
    22.661    34.203     0.200
    22.699    33.811     0.200
    22.704    34.515     0.200
    22.786    33.654     0.200
    22.949    35.491     0.200
    22.970    34.069     0.200
    23.050    33.394     0.200
    23.160    32.941     0.200
    23.173    33.079     0.200
    23.176    33.122     0.200
    23.203    37.386     0.200
    23.203    36.017     0.200
    23.212    33.655     0.200
    23.212    33.165     0.200
    23.247    32.631     0.200
    23.292    32.577     0.200
    23.299    33.327     0.200
    23.299    32.874     0.200
    23.337    33.835     0.200
    23.337    33.464     0.200
    23.371    35.214     0.200
    23.361    33.142     0.200
    23.423    35.538     0.200
    23.427    32.853     0.200
    23.438    32.343     0.200
    23.438    32.193     0.200
    23.461    33.591     0.200
    23.493    36.971     0.200
    23.516    32.454     0.200
    23.547    36.915     0.200
    23.526    32.778     0.200
    23.552    33.231     0.200
    23.552    32.875     0.200
    23.615    32.667     0.200
    23.654    32.304     0.200
    23.727    35.763     0.200
    23.755    32.364     0.200
    23.795    36.087     0.200
    23.795    36.526     0.200
    23.778    31.889     0.200
    23.810    32.249     0.200
    23.857    32.062     0.200
    23.862    31.776     0.200
    23.940    35.116     0.200
    23.944    32.037     0.200
    23.950    32.076     0.200
    23.989    32.260     0.200
    23.994    32.616     0.200
    24.028    31.625     0.200
    24.085    31.752     0.200
    24.123    31.211     0.200
    24.138    32.273     0.200
    24.138    31.388     0.200
    24.201    34.948     0.200
    24.186    31.379     0.200
    24.228    31.316     0.200
    24.261    31.093     0.200
    24.262    31.453     0.200
    24.311    30.824     0.200
    24.324    31.423     0.200
    24.324    30.954     0.200
    24.370    32.278     0.200
    24.379    31.367     0.200
    24.400    34.970     0.200
    24.396    31.064     0.200
    24.396    30.621     0.200
    24.431    30.856     0.200
    24.466    31.530     0.200
    24.479    30.669     0.200
    24.525    33.427     0.200
    24.506    31.268     0.200
    24.506    31.596     0.200
    24.590    30.818     0.200
    24.610    30.133     0.200
    24.660    33.621     0.200
    24.680    33.867     0.200
    24.678    30.694     0.200
    24.722    30.341     0.200
    24.818    29.810     0.200
    24.818    29.701     0.200
    24.830    29.611     0.200
    24.833    30.418     0.200
    24.846    28.992     0.200
    24.882    32.426     0.200
    24.882    31.566     0.200
    24.882    32.638     0.200
    24.882    31.936     0.200
    24.882    31.626     0.200
    24.902    30.547     0.200
    24.902    29.698     0.200
    24.904    28.835     0.200
    24.935    33.087     0.200
    24.970    32.509     0.200
    25.044    29.379     0.200
    25.121    33.017     0.200
    25.125    28.734     0.200
    25.175    29.485     0.200
    25.205    29.129     0.200
    25.209    29.339     0.200
    25.209    29.199     0.200
    25.255    28.383     0.200
    25.297    29.660     0.200
    25.319    32.135     0.200
    25.325    28.389     0.200
    25.334    28.294     0.200
    25.347    28.292     0.200
    25.363    28.240     0.200
    25.367    28.610     0.200
    25.513    31.256     0.200
    25.529    27.877     0.200
    25.551    27.995     0.200
    25.552    28.144     0.200
    25.679    28.093     0.200
    25.701    29.828     0.200
    25.713    30.222     0.200
    25.713    28.355     0.200
    25.717    28.439     0.200
    25.778    29.642     0.200
    25.788    27.675     0.200
    25.844    29.311     0.200
    25.860    27.494     0.200
    25.874    27.002     0.200
    25.874    26.774     0.200
    25.892    29.855     0.200
    25.909    31.015     0.200
    25.991    28.330     0.200
    26.001    28.354     0.200
    25.993    26.790     0.200
    26.012    26.117     0.200
    26.019    25.398     0.200
    26.051    30.142     0.200
    26.215    25.988     0.200
    26.238    29.777     0.200
    26.324    25.153     0.200
    26.600    24.389     0.200
    26.689    24.828     0.200
    26.695    24.153     0.200
    26.767    26.724     0.200
    26.767    26.302     0.200
    26.864    23.566     0.200
    26.947    26.449     0.200
    26.978    24.689     0.200
    26.978    24.435     0.200
    27.003    23.752     0.200
    27.081    23.805     0.200
    27.081    23.672     0.200
    27.229    26.362     0.200
    27.233    23.009     0.200
    27.364    24.338     0.200
    27.456    22.760     0.200
    27.521    22.472     0.200
    27.653    21.928     0.200
    27.676    21.920     0.200
    27.720    21.109     0.200
    27.949    24.157     0.200
    28.002    22.842     0.200
    28.102    23.113     0.200
    28.418    19.227     0.200
    28.485    19.817     0.200
    28.831    21.195     0.200
    28.927    22.517     0.200
    29.014    21.315     0.200
    29.675    19.509     0.200
    29.785    18.583     0.200
    29.911    18.503     0.200
    29.937    18.521     0.200
    29.962    15.071     0.200
    13.842    36.766     0.200
    14.431    38.047     0.200
    16.839    37.639     0.200
    16.888    37.650     0.200
    17.347    39.337     0.200
    17.791    37.803     0.200
    18.476    35.834     0.200
    18.901    34.664     0.200
    19.097    36.487     0.200
    19.179    34.664     0.200
    19.410    35.591     0.200
    19.446    37.171     0.200
    19.449    36.887     0.200
    19.921    33.039     0.200
    20.243    34.480     0.200
    20.454    35.642     0.200
    20.510    34.098     0.200
    20.524    33.556     0.200
    20.551    35.199     0.200
    20.572    35.016     0.200
    20.574    33.646     0.200
    20.606    36.276     0.200
    20.678    35.073     0.200
    20.685    34.967     0.200
    20.766    36.586     0.200
    20.779    36.584     0.200
    20.795    36.445     0.200
    20.993    33.174     0.200
    21.056    34.588     0.200
    21.241    32.780     0.200
    21.281    34.205     0.200
    21.286    36.091     0.200
    21.762    35.057     0.200
    22.027    34.302     0.200
    23.513    30.782     0.200
    24.122    31.103     0.200
    24.171    30.606     0.200
    24.193    30.653     0.200
    24.193    32.536     0.200
    24.455    30.107     0.200
    24.583    30.313     0.200
    25.002    27.470     0.200
    25.002    27.868     0.200
    25.346    28.769     0.200
    15.020    37.633     0.200
    15.564    37.325     0.200
    15.672    38.440     0.200
    15.672    37.847     0.200
    15.704    38.519     0.200
    15.770    38.438     0.200
    16.466    39.258     0.200
    16.466    39.586     0.200
    16.466    38.946     0.200
    16.570    38.320     0.200
    16.687    38.445     0.200
    16.782    39.214     0.200
    17.154    39.557     0.200
    17.276    40.003     0.200
    17.276    39.277     0.200
    17.437    39.013     0.200
    17.681    38.101     0.200
    17.805    39.776     0.200
    17.854    38.943     0.200
    17.854    39.920     0.200
    17.861    40.106     0.200
    18.132    40.411     0.200
    18.132    40.185     0.200
    18.135    39.711     0.200
    18.143    39.137     0.200
    18.160    40.445     0.200
    18.158    38.406     0.200
    18.255    37.050     0.200
    18.369    36.121     0.200
    18.369    35.934     0.200
    18.661    36.292     0.200
    18.696    36.833     0.200
    18.728    36.973     0.200
    18.781    36.884     0.200
    18.831    37.158     0.200
    18.831    37.009     0.200
    19.033    36.192     0.200
    19.128    37.279     0.200
    19.168    35.758     0.200
    19.385    36.719     0.200
    19.498    36.120     0.200
    19.498    36.401     0.200
    19.575    36.360     0.200
    19.657    36.889     0.200
    19.705    36.106     0.200
    19.735    34.815     0.200
    19.735    36.542     0.200
    19.743    36.647     0.200
    19.853    35.415     0.200
    19.853    36.235     0.200
    19.856    35.191     0.200
    19.926    35.217     0.200
    20.014    37.476     0.200
    20.080    36.656     0.200
    20.092    37.321     0.200
    20.164    35.835     0.200
    20.213    35.204     0.200
    20.235    36.797     0.200
    20.347    37.461     0.200
    20.362    34.342     0.200
    20.362    34.982     0.200
    20.381    34.846     0.200
    20.395    36.212     0.200
    20.395    36.720     0.200
    20.450    35.714     0.200
    20.452    35.088     0.200
    20.490    35.122     0.200
    20.490    35.747     0.200
    20.612    35.141     0.200
    20.620    35.158     0.200
    20.646    37.104     0.200
    20.704    36.316     0.200
    20.696    34.808     0.200
    20.721    36.777     0.200
    20.748    34.951     0.200
    20.748    34.850     0.200
    20.766    35.066     0.200
    20.817    33.834     0.200
    20.819    34.901     0.200
    20.897    34.604     0.200
    20.903    34.607     0.200
    20.932    35.030     0.200
    20.954    34.730     0.200
    20.959    36.680     0.200
    21.050    33.990     0.200
    21.137    37.534     0.200
    21.128    34.175     0.200
    21.155    37.747     0.200
    21.154    37.829     0.200
    21.171    37.804     0.200
    21.174    37.462     0.200
    21.180    34.370     0.200
    21.205    35.744     0.200
    21.205    36.299     0.200
    21.223    33.702     0.200
    21.236    36.063     0.200
    21.259    36.029     0.200
    21.263    34.427     0.200
    21.284    37.557     0.200
    21.284    37.792     0.200
    21.287    34.219     0.200
    21.289    34.183     0.200
    21.308    36.924     0.200
    21.307    34.202     0.200
    21.360    37.718     0.200
    21.346    34.251     0.200
    21.353    33.751     0.200
    21.378    37.384     0.200
    21.362    33.946     0.200
    21.410    34.584     0.200
    21.410    34.358     0.200
    21.411    33.973     0.200
    21.416    32.839     0.200
    21.416    33.972     0.200
    21.485    33.306     0.200
    21.543    37.137     0.200
    21.533    33.696     0.200
    21.538    33.941     0.200
    21.538    34.090     0.200
    21.550    33.321     0.200
    21.553    34.246     0.200
    21.553    33.988     0.200
    21.602    36.676     0.200
    21.608    33.103     0.200
    21.654    35.787     0.200
    21.651    33.878     0.200
    21.660    34.093     0.200
    21.689    35.309     0.200
    21.698    34.436     0.200
    21.715    33.432     0.200
    21.726    33.067     0.200
    21.731    33.365     0.200
    21.750    37.220     0.200
    21.744    33.585     0.200
    21.744    33.750     0.200
    21.797    32.921     0.200
    21.812    35.639     0.200
    21.812    36.193     0.200
    21.822    37.091     0.200
    21.804    31.882     0.200
    21.804    33.249     0.200
    21.810    32.839     0.200
    21.839    37.103     0.200
    21.832    33.199     0.200
    21.833    33.041     0.200
    21.852    34.596     0.200
    21.854    33.566     0.200
    21.863    33.395     0.200
    21.901    33.679     0.200
    21.949    36.772     0.200
    21.972    33.282     0.200
    21.987    34.412     0.200
    22.017    33.556     0.200
    22.019    33.074     0.200
    22.066    32.965     0.200
    22.110    33.448     0.200
    22.114    32.541     0.200
    22.118    33.168     0.200
    22.168    32.979     0.200
    22.184    36.030     0.200
    22.217    32.429     0.200
    22.217    32.772     0.200
    22.222    32.801     0.200
    22.222    32.926     0.200
    22.227    33.288     0.200
    22.242    32.483     0.200
    22.242    33.054     0.200
    22.261    32.399     0.200
    22.282    32.508     0.200
    22.281    32.711     0.200
    22.304    36.662     0.200
    22.295    32.751     0.200
    22.300    31.461     0.200
    22.300    32.343     0.200
    22.316    35.246     0.200
    22.313    33.107     0.200
    22.339    36.253     0.200
    22.330    32.821     0.200
    22.334    32.817     0.200
    22.334    33.083     0.200
    22.354    33.429     0.200
    22.354    33.897     0.200
    22.391    36.035     0.200
    22.372    31.805     0.200
    22.372    32.610     0.200
    22.388    35.930     0.200
    22.448    35.816     0.200
    22.448    32.270     0.200
    22.458    31.848     0.200
    22.465    32.627     0.200
    22.462    33.847     0.200
    22.469    32.126     0.200
    22.479    32.364     0.200
    22.490    31.576     0.200
    22.513    31.939     0.200
    22.552    32.148     0.200
    22.552    32.398     0.200
    22.608    32.497     0.200
    22.637    31.953     0.200
    22.670    31.603     0.200
    22.670    32.751     0.200
    22.670    32.939     0.200
    22.675    31.932     0.200
    22.692    33.868     0.200
    22.705    32.116     0.200
    22.717    31.943     0.200
    22.721    32.130     0.200
    22.721    32.200     0.200
    22.739    31.081     0.200
    22.739    31.893     0.200
    22.763    31.274     0.200
    22.810    31.248     0.200
    22.810    31.600     0.200
    22.834    31.318     0.200
    22.848    31.368     0.200
    22.862    31.990     0.200
    22.879    35.087     0.200
    22.874    31.797     0.200
    22.896    34.282     0.200
    22.944    30.908     0.200
    22.955    31.131     0.200
    22.988    31.561     0.200
    23.055    35.950     0.200
    23.039    31.045     0.200
    23.056    34.407     0.200
    23.095    31.582     0.200
    23.097    32.313     0.200
    23.101    31.720     0.200
    23.123    35.555     0.200
    23.146    31.072     0.200
    23.149    31.714     0.200
    23.178    35.672     0.200
    23.161    31.878     0.200
    23.213    33.468     0.200
    23.220    31.436     0.200
    23.241    31.788     0.200
    23.249    31.495     0.200
    23.249    31.120     0.200
    23.257    31.468     0.200
    23.277    31.777     0.200
    23.284    32.962     0.200
    23.284    32.516     0.200
    23.286    31.204     0.200
    23.326    30.832     0.200
    23.365    34.849     0.200
    23.355    31.009     0.200
    23.353    31.035     0.200
    23.358    30.485     0.200
    23.362    31.018     0.200
    23.375    33.568     0.200
    23.373    30.614     0.200
    23.411    30.141     0.200
    23.432    34.217     0.200
    23.432    35.076     0.200
    23.437    29.799     0.200
    23.437    30.408     0.200
    23.477    31.192     0.200
    23.503    30.599     0.200
    23.512    30.523     0.200
    23.536    30.940     0.200
    23.536    29.847     0.200
    23.617    31.928     0.200
    23.673    30.258     0.200
    23.693    34.240     0.200
    23.684    30.025     0.200
    23.725    30.266     0.200
    23.747    30.782     0.200
    23.777    30.330     0.200
    23.804    33.147     0.200
    23.792    29.727     0.200
    23.799    30.316     0.200
    23.842    33.969     0.200
    23.845    29.701     0.200
    23.876    32.237     0.200
    23.900    29.342     0.200
    23.902    30.314     0.200
    23.902    30.136     0.200
    23.944    29.693     0.200
    23.953    29.723     0.200
    23.962    30.555     0.200
    23.997    29.123     0.200
    23.997    29.959     0.200
    24.033    34.279     0.200
    24.017    29.587     0.200
    24.018    29.582     0.200
    24.029    30.699     0.200
    24.029    30.145     0.200
    24.105    31.114     0.200
    24.103    29.738     0.200
    24.152    32.527     0.200
    24.151    33.123     0.200
    24.176    29.563     0.200
    24.176    29.446     0.200
    24.224    29.879     0.200
    24.229    29.786     0.200
    24.237    29.728     0.200
    24.293    29.013     0.200
    24.341    31.569     0.200
    24.334    29.557     0.200
    24.339    28.321     0.200
    24.349    28.785     0.200
    24.398    28.905     0.200
    24.432    29.308     0.200
    24.444    28.898     0.200
    24.504    29.387     0.200
    24.504    28.887     0.200
    24.517    28.889     0.200
    24.544    28.861     0.200
    24.544    28.603     0.200
    24.569    32.892     0.200
    24.591    30.908     0.200
    24.591    29.768     0.200
    24.591    31.089     0.200
    24.591    30.940     0.200
    24.591    31.925     0.200
    24.597    28.107     0.200
    24.620    31.816     0.200
    24.619    28.012     0.200
    24.619    28.489     0.200
    24.622    28.636     0.200
    24.622    28.878     0.200
    24.665    28.631     0.200
    24.721    27.918     0.200
    24.742    28.312     0.200
    24.742    27.319     0.200
    24.756    32.550     0.200
    24.770    28.840     0.200
    24.811    31.079     0.200
    24.794    28.842     0.200
    24.805    27.708     0.200
    24.850    28.052     0.200
    24.852    28.201     0.200
    24.881    28.802     0.200
    24.881    28.646     0.200
    24.891    30.852     0.200
    24.925    28.355     0.200
    24.925    28.101     0.200
    24.933    27.484     0.200
    24.957    31.497     0.200
    24.977    27.574     0.200
    24.977    28.347     0.200
    25.008    31.148     0.200
    25.008    30.942     0.200
    25.019    27.539     0.200
    25.102    27.573     0.200
    25.118    27.203     0.200
    25.142    30.652     0.200
    25.126    27.041     0.200
    25.126    26.502     0.200
    25.171    26.631     0.200
    25.233    26.248     0.200
    25.248    30.398     0.200
    25.251    27.128     0.200
    25.251    25.808     0.200
    25.249    28.758     0.200
    25.249    27.688     0.200
    25.285    26.468     0.200
    25.320    25.889     0.200
    25.320    26.389     0.200
    25.333    26.472     0.200
    25.338    26.904     0.200
    25.349    26.664     0.200
    25.357    26.593     0.200
    25.402    27.508     0.200
    25.425    26.241     0.200
    25.436    26.094     0.200
    25.457    26.534     0.200
    25.460    27.000     0.200
    25.471    26.292     0.200
    25.471    27.823     0.200
    25.479    28.555     0.200
    25.516    25.421     0.200
    25.543    30.238     0.200
    25.539    25.995     0.200
    25.554    25.701     0.200
    25.565    25.848     0.200
    25.584    27.627     0.200
    25.595    28.207     0.200
    25.620    25.198     0.200
    25.701    27.901     0.200
    25.693    25.392     0.200
    25.703    25.470     0.200
    25.706    26.599     0.200
    25.706    24.770     0.200
    25.708    28.679     0.200
    25.753    27.832     0.200
    25.782    26.471     0.200
    25.782    26.033     0.200
    25.788    25.235     0.200
    25.811    25.529     0.200
    25.822    26.068     0.200
    25.822    27.631     0.200
    25.826    25.987     0.200
    25.868    29.091     0.200
    25.934    26.653     0.200
    25.932    24.862     0.200
    25.932    25.315     0.200
    25.954    25.298     0.200
    26.004    25.653     0.200
    26.002    24.699     0.200
    26.002    25.301     0.200
    26.008    24.289     0.200
    26.056    25.048     0.200
    26.068    26.869     0.200
    26.102    24.637     0.200
    26.102    24.512     0.200
    26.123    25.861     0.200
    26.122    24.619     0.200
    26.123    24.335     0.200
    26.269    25.183     0.200
    26.277    24.983     0.200
    26.313    23.827     0.200
    26.313    23.530     0.200
    26.348    27.532     0.200
    26.348    25.767     0.200
    26.337    23.034     0.200
    26.371    23.464     0.200
    26.445    26.286     0.200
    26.445    26.622     0.200
    26.440    23.353     0.200
    26.449    23.782     0.200
    26.482    27.023     0.200
    26.474    23.703     0.200
    26.578    26.087     0.200
    26.588    22.728     0.200
    26.593    22.851     0.200
    26.676    25.448     0.200
    26.683    25.464     0.200
    26.674    22.669     0.200
    26.745    23.080     0.200
    26.777    25.383     0.200
    26.806    24.397     0.200
    26.827    22.616     0.200
    26.848    24.077     0.200
    26.848    23.623     0.200
    26.881    25.466     0.200
    26.876    22.557     0.200
    26.876    22.416     0.200
    26.882    23.593     0.200
    26.971    22.129     0.200
    26.992    24.471     0.200
    27.025    21.192     0.200
    27.059    23.568     0.200
    27.077    21.421     0.200
    27.123    21.328     0.200
    27.136    25.190     0.200
    27.164    23.477     0.200
    27.167    21.058     0.200
    27.194    21.862     0.200
    27.226    25.400     0.200
    27.226    21.153     0.200
    27.269    20.935     0.200
    27.269    21.209     0.200
    27.348    20.966     0.200
    27.352    21.016     0.200
    27.436    21.377     0.200
    27.483    20.177     0.200
    27.509    23.212     0.200
    27.542    22.551     0.200
    27.561    21.837     0.200
    27.557    19.555     0.200
    27.604    23.553     0.200
    27.601    20.830     0.200
    27.642    21.203     0.200
    27.658    20.042     0.200
    27.703    21.751     0.200
    27.703    22.658     0.200
    27.702    20.086     0.200
    27.714    20.129     0.200
    27.714    19.942     0.200
    27.739    23.373     0.200
    27.779    20.322     0.200
    27.929    22.141     0.200
    27.961    19.860     0.200
    27.968    19.601     0.200
    27.992    22.918     0.200
    27.993    19.863     0.200
    28.104    20.089     0.200
    28.116    20.680     0.200
    28.135    18.633     0.200
    28.135    19.946     0.200
    28.295    20.911     0.200
    28.323    18.502     0.200
    28.359    21.576     0.200
    28.354    18.383     0.200
    28.397    17.596     0.200
    28.497    19.946     0.200
    28.516    17.512     0.200
    28.516    17.887     0.200
    28.612    19.034     0.200
    28.658    20.664     0.200
    28.666    17.595     0.200
    28.814    17.871     0.200
    28.850    17.527     0.200
    28.874    19.711     0.200
    28.872    17.279     0.200
    28.881    18.003     0.200
    28.903    18.964     0.200
    28.903    16.763     0.200
    28.946    16.866     0.200
    29.006    19.630     0.200
    29.045    16.635     0.200
    29.067    16.296     0.200
    29.118    16.440     0.200
    29.137    16.114     0.200
    29.242    15.853     0.200
    29.309    19.013     0.200
    29.309    15.573     0.200
    29.445    17.921     0.200
    29.472    17.363     0.200
    29.484    15.029     0.200
    29.558    17.721     0.200
    29.561    14.822     0.200
    29.579    17.420     0.200
    29.700    14.789     0.200
    29.738    14.953     0.200
    29.749    14.340     0.200
    29.749    14.941     0.200
    29.767    16.432     0.200
    29.761    16.290     0.200
    29.789    16.834     0.200
    29.822    15.102     0.200
    29.833    14.734     0.200
    29.835    14.304     0.200
    29.925    16.945     0.200
    24.166    34.653     0.200
    14.240    37.385     0.200
    14.755    37.761     0.200
    15.287    38.165     0.200
    15.506    39.330     0.200
    15.983    38.868     0.200
    15.983    38.978     0.200
    16.054    39.279     0.200
    16.192    38.887     0.200
    16.192    39.396     0.200
    16.448    39.194     0.200
    16.518    39.854     0.200
    16.864    39.562     0.200
    17.259    40.382     0.200
    17.259    40.237     0.200
    17.259    40.536     0.200
    17.478    38.914     0.200
    18.190    40.614     0.200
    18.190    40.463     0.200
    18.365    36.833     0.200
    18.365    36.633     0.200
    18.556    37.292     0.200
    18.631    37.522     0.200
    18.664    36.990     0.200
    18.664    36.818     0.200
    18.815    36.898     0.200
    18.926    37.072     0.200
    18.926    36.928     0.200
    18.951    37.036     0.200
    19.005    37.070     0.200
    19.198    36.555     0.200
    19.198    37.064     0.200
    19.193    37.117     0.200
    19.242    38.015     0.200
    19.408    36.724     0.200
    19.467    37.042     0.200
    19.467    36.698     0.200
    19.509    36.185     0.200
    19.561    35.929     0.200
    19.558    36.106     0.200
    19.590    36.405     0.200
    19.955    36.139     0.200
    19.955    35.948     0.200
    19.957    35.870     0.200
    19.957    35.699     0.200
    19.959    35.537     0.200
    20.004    35.853     0.200
    19.996    35.822     0.200
    20.034    35.795     0.200
    20.162    35.422     0.200
    20.183    36.505     0.200
    20.204    36.412     0.200
    20.206    35.609     0.200
    20.346    35.740     0.200
    20.417    35.643     0.200
    20.524    35.019     0.200
    20.544    35.108     0.200
    20.544    34.926     0.200
    20.593    34.920     0.200
    20.599    35.452     0.200
    20.608    35.275     0.200
    20.656    34.645     0.200
    20.680    35.882     0.200
    20.680    35.593     0.200
    20.689    35.165     0.200
    20.723    34.718     0.200
    20.733    34.323     0.200
    20.783    37.644     0.200
    20.779    35.067     0.200
    20.797    35.955     0.200
    20.797    35.746     0.200
    20.803    35.482     0.200
    20.833    35.837     0.200
    20.859    35.093     0.200
    20.891    36.604     0.200
    20.891    36.899     0.200
    20.920    34.418     0.200
    20.964    37.155     0.200
    20.928    34.581     0.200
    20.959    34.196     0.200
    20.969    34.722     0.200
    21.002    37.477     0.200
    21.002    37.207     0.200
    21.012    37.161     0.200
    21.013    37.154     0.200
    21.015    37.122     0.200
    20.984    34.096     0.200
    21.034    37.181     0.200
    21.012    34.544     0.200
    21.015    34.481     0.200
    21.050    37.532     0.200
    21.027    35.923     0.200
    21.032    38.644     0.200
    21.076    37.398     0.200
    21.041    35.039     0.200
    21.090    37.547     0.200
    21.127    37.670     0.200
    21.110    37.222     0.200
    21.119    37.000     0.200
    21.126    36.716     0.200
    21.105    35.007     0.200
    21.129    34.279     0.200
    21.196    38.623     0.200
    21.191    37.539     0.200
    21.171    35.708     0.200
    21.174    35.020     0.200
    21.183    34.021     0.200
    21.183    34.436     0.200
    21.252    37.466     0.200
    21.209    34.994     0.200
    21.209    34.250     0.200
    21.263    36.605     0.200
    21.266    36.920     0.200
    21.286    36.974     0.200
    21.340    37.656     0.200
    21.331    34.611     0.200
    21.322    35.290     0.200
    21.322    34.433     0.200
    21.348    35.220     0.200
    21.344    34.315     0.200
    21.408    33.386     0.200
    21.420    35.207     0.200
    21.429    34.536     0.200
    21.466    37.088     0.200
    21.435    35.075     0.200
    21.435    34.800     0.200
    21.453    33.843     0.200
    21.453    33.611     0.200
    21.472    34.451     0.200
    21.483    33.778     0.200
    21.504    34.399     0.200
    21.555    37.755     0.200
    21.525    34.287     0.200
    21.507    34.409     0.200
    21.507    34.146     0.200
    21.531    34.646     0.200
    21.526    33.311     0.200
    21.560    33.549     0.200
    21.573    33.777     0.200
    21.605    33.937     0.200
    21.659    37.549     0.200
    21.620    33.901     0.200
    21.639    33.633     0.200
    21.635    34.247     0.200
    21.725    36.587     0.200
    21.725    36.454     0.200
    21.680    34.369     0.200
    21.735    37.176     0.200
    21.739    32.889     0.200
    21.747    33.351     0.200
    21.790    33.661     0.200
    21.880    35.919     0.200
    21.880    35.812     0.200
    21.904    36.681     0.200
    21.922    33.503     0.200
    21.928    33.806     0.200
    21.931    32.882     0.200
    21.949    33.204     0.200
    21.949    32.562     0.200
    21.968    39.020     0.200
    22.002    36.439     0.200
    21.978    32.654     0.200
    21.994    32.376     0.200
    22.001    32.220     0.200
    22.002    34.887     0.200
    22.002    34.328     0.200
    22.022    33.356     0.200
    22.022    32.930     0.200
    22.027    33.179     0.200
    22.041    32.936     0.200
    22.141    36.304     0.200
    22.141    36.590     0.200
    22.103    33.187     0.200
    22.103    33.333     0.200
    22.095    32.788     0.200
    22.108    32.957     0.200
    22.163    36.020     0.200
    22.192    35.123     0.200
    22.192    33.126     0.200
    22.216    31.088     0.200
    22.216    32.795     0.200
    22.254    32.854     0.200
    22.265    32.953     0.200
    22.330    33.380     0.200
    22.330    33.141     0.200
    22.475    36.049     0.200
    22.489    36.081     0.200
    22.444    31.432     0.200
    22.459    31.705     0.200
    22.459    31.361     0.200
    22.548    37.004     0.200
    22.561    35.992     0.200
    22.513    31.474     0.200
    22.513    32.403     0.200
    22.514    31.897     0.200
    22.539    32.029     0.200
    22.543    31.419     0.200
    22.550    32.182     0.200
    22.623    35.315     0.200
    22.587    30.951     0.200
    22.629    35.243     0.200
    22.629    35.400     0.200
    22.607    32.445     0.200
    22.641    32.454     0.200
    22.738    36.090     0.200
    22.738    35.406     0.200
    22.692    32.104     0.200
    22.692    31.256     0.200
    22.706    32.468     0.200
    22.714    32.935     0.200
    22.714    31.930     0.200
    22.779    31.676     0.200
    22.819    33.996     0.200
    22.819    33.767     0.200
    22.895    32.428     0.200
    22.890    30.825     0.200
    22.906    30.735     0.200
    22.983    35.669     0.200
    22.962    30.980     0.200
    22.965    31.523     0.200
    23.000    35.140     0.200
    23.000    34.143     0.200
    22.982    31.275     0.200
    22.997    32.542     0.200
    23.004    30.310     0.200
    23.013    31.228     0.200
    23.091    35.541     0.200
    23.055    32.146     0.200
    23.078    36.836     0.200
    23.139    35.598     0.200
    23.122    31.747     0.200
    23.144    32.188     0.200
    23.212    35.185     0.200
    23.168    31.650     0.200
    23.170    31.335     0.200
    23.274    35.248     0.200
    23.304    31.343     0.200
    23.347    33.601     0.200
    23.380    35.040     0.200
    23.380    35.202     0.200
    23.353    31.877     0.200
    23.392    31.119     0.200
    23.399    36.561     0.200
    23.399    35.591     0.200
    23.399    32.861     0.200
    23.398    35.732     0.200
    23.399    35.839     0.200
    23.460    34.968     0.200
    23.473    31.729     0.200
    23.471    31.896     0.200
    23.471    30.925     0.200
    23.476    29.443     0.200
    23.479    30.412     0.200
    23.481    29.576     0.200
    23.512    31.203     0.200
    23.534    32.762     0.200
    23.534    32.521     0.200
    23.534    31.606     0.200
    23.551    31.626     0.200
    23.631    34.273     0.200
    23.583    30.713     0.200
    23.605    30.795     0.200
    23.613    34.421     0.200
    23.640    30.915     0.200
    23.643    35.892     0.200
    23.722    33.541     0.200
    23.696    30.676     0.200
    23.749    33.545     0.200
    23.815    33.843     0.200
    23.822    30.841     0.200
    23.841    30.290     0.200
    23.913    33.382     0.200
    23.913    33.009     0.200
    23.955    31.602     0.200
    23.941    29.885     0.200
    23.941    30.220     0.200
    23.962    29.913     0.200
    23.962    30.259     0.200
    23.977    30.509     0.200
    23.972    29.062     0.200
    23.994    30.379     0.200
    24.025    30.383     0.200
    24.054    30.238     0.200
    24.064    29.307     0.200
    24.084    30.568     0.200
    24.080    29.178     0.200
    24.103    29.599     0.200
    24.104    29.715     0.200
    24.144    30.386     0.200
    24.172    29.278     0.200
    24.278    28.860     0.200
    24.289    29.010     0.200
    24.381    32.129     0.200
    24.362    29.445     0.200
    24.360    29.324     0.200
    24.371    28.761     0.200
    24.412    28.834     0.200
    24.455    32.869     0.200
    24.423    29.296     0.200
    24.509    28.790     0.200
    24.507    33.898     0.200
    24.512    28.489     0.200
    24.535    29.545     0.200
    24.535    29.004     0.200
    24.547    28.903     0.200
    24.544    28.571     0.200
    24.559    29.022     0.200
    24.590    28.782     0.200
    24.579    28.182     0.200
    24.598    28.082     0.200
    24.646    32.382     0.200
    24.636    28.795     0.200
    24.667    29.320     0.200
    24.718    31.898     0.200
    24.718    32.226     0.200
    24.676    28.846     0.200
    24.676    28.239     0.200
    24.680    28.331     0.200
    24.739    28.102     0.200
    24.765    28.036     0.200
    24.780    28.314     0.200
    24.802    30.826     0.200
    24.802    29.719     0.200
    24.787    28.459     0.200
    24.787    28.206     0.200
    24.783    29.246     0.200
    24.783    28.576     0.200
    24.823    31.023     0.200
    24.796    28.909     0.200
    24.871    27.904     0.200
    24.912    27.925     0.200
    24.959    27.606     0.200
    24.978    28.198     0.200
    24.978    27.914     0.200
    24.995    27.027     0.200
    25.005    27.411     0.200
    25.003    27.586     0.200
    25.021    27.876     0.200
    25.021    27.360     0.200
    25.039    27.189     0.200
    25.053    28.019     0.200
    25.103    31.261     0.200
    25.098    27.385     0.200
    25.125    26.355     0.200
    25.135    26.794     0.200
    25.143    27.191     0.200
    25.145    26.925     0.200
    25.163    27.253     0.200
    25.225    30.240     0.200
    25.267    30.237     0.200
    25.244    27.269     0.200
    25.292    26.622     0.200
    25.350    30.758     0.200
    25.392    26.663     0.200
    25.391    26.394     0.200
    25.399    26.502     0.200
    25.429    28.516     0.200
    25.429    28.229     0.200
    25.429    28.447     0.200
    25.429    28.497     0.200
    25.429    28.707     0.200
    25.413    26.484     0.200
    25.413    26.145     0.200
    25.422    26.728     0.200
    25.509    29.281     0.200
    25.475    25.803     0.200
    25.497    26.031     0.200
    25.514    26.132     0.200
    25.570    25.795     0.200
    25.613    29.778     0.200
    25.569    26.323     0.200
    25.579    25.865     0.200
    25.635    25.586     0.200
    25.634    25.636     0.200
    25.655    24.822     0.200
    25.682    25.716     0.200
    25.692    25.289     0.200
    25.698    25.654     0.200
    25.719    25.323     0.200
    25.731    25.641     0.200
    25.783    28.194     0.200
    25.769    26.294     0.200
    25.769    25.888     0.200
    25.813    29.172     0.200
    25.805    24.790     0.200
    25.890    24.809     0.200
    25.910    24.717     0.200
    25.934    24.965     0.200
    25.981    25.137     0.200
    26.056    29.323     0.200
    26.030    25.473     0.200
    26.030    25.709     0.200
    26.041    26.995     0.200
    26.041    26.823     0.200
    26.038    24.225     0.200
    26.064    24.619     0.200
    26.073    24.017     0.200
    26.082    24.198     0.200
    26.131    27.403     0.200
    26.091    24.113     0.200
    26.151    24.316     0.200
    26.151    24.129     0.200
    26.148    24.701     0.200
    26.166    24.407     0.200
    26.197    24.469     0.200
    26.212    24.154     0.200
    26.221    24.476     0.200
    26.221    24.316     0.200
    26.285    26.742     0.200
    26.282    24.053     0.200
    26.297    24.052     0.200
    26.357    26.703     0.200
    26.350    24.136     0.200
    26.429    26.180     0.200
    26.464    26.070     0.200
    26.452    23.344     0.200
    26.436    23.341     0.200
    26.486    27.405     0.200
    26.475    23.317     0.200
    26.477    23.159     0.200
    26.541    23.892     0.200
    26.542    23.102     0.200
    26.556    23.168     0.200
    26.587    25.767     0.200
    26.626    25.067     0.200
    26.608    22.845     0.200
    26.639    22.349     0.200
    26.648    21.979     0.200
    26.669    21.601     0.200
    26.715    22.413     0.200
    26.717    23.069     0.200
    26.733    22.629     0.200
    26.769    22.537     0.200
    26.811    25.822     0.200
    26.799    22.560     0.200
    26.824    22.853     0.200
    26.900    22.396     0.200
    26.900    22.104     0.200
    26.933    25.088     0.200
    26.935    22.936     0.200
    26.935    22.577     0.200
    26.946    22.291     0.200
    26.948    22.018     0.200
    26.997    25.531     0.200
    27.002    21.618     0.200
    27.026    21.730     0.200
    27.052    21.925     0.200
    27.084    21.730     0.200
    27.089    21.415     0.200
    27.099    21.940     0.200
    27.111    20.063     0.200
    27.131    21.710     0.200
    27.202    25.048     0.200
    27.202    24.556     0.200
    27.216    21.563     0.200
    27.227    21.086     0.200
    27.241    21.364     0.200
    27.245    21.823     0.200
    27.245    21.559     0.200
    27.250    21.132     0.200
    27.283    21.133     0.200
    27.327    24.949     0.200
    27.309    21.491     0.200
    27.462    23.811     0.200
    27.462    23.093     0.200
    27.429    20.317     0.200
    27.457    21.068     0.200
    27.500    20.641     0.200
    27.519    21.505     0.200
    27.519    20.791     0.200
    27.540    20.835     0.200
    27.538    20.848     0.200
    27.538    20.509     0.200
    27.544    20.829     0.200
    27.558    26.923     0.200
    27.564    20.575     0.200
    27.606    20.402     0.200
    27.640    22.452     0.200
    27.616    20.210     0.200
    27.633    19.463     0.200
    27.710    20.198     0.200
    27.726    20.430     0.200
    27.726    19.350     0.200
    27.750    19.514     0.200
    27.809    23.344     0.200
    27.799    19.908     0.200
    27.809    20.069     0.200
    27.823    20.061     0.200
    27.905    23.101     0.200
    27.859    23.420     0.200
    27.868    20.198     0.200
    27.898    19.249     0.200
    27.919    20.302     0.200
    27.919    19.427     0.200
    27.909    19.649     0.200
    27.909    19.100     0.200
    27.932    19.278     0.200
    27.938    19.565     0.200
    27.938    18.826     0.200
    28.063    22.083     0.200
    28.039    18.969     0.200
    28.065    19.076     0.200
    28.073    19.641     0.200
    28.078    19.479     0.200
    28.114    18.117     0.200
    28.161    22.655     0.200
    28.136    18.507     0.200
    28.136    18.314     0.200
    28.200    19.075     0.200
    28.191    17.609     0.200
    28.219    18.793     0.200
    28.227    18.499     0.200
    28.231    18.949     0.200
    28.257    18.740     0.200
    28.272    18.713     0.200
    28.345    19.292     0.200
    28.336    18.660     0.200
    28.359    20.620     0.200
    28.380    22.201     0.200
    28.378    18.376     0.200
    28.442    21.379     0.200
    28.434    17.893     0.200
    28.434    17.415     0.200
    28.461    18.413     0.200
    28.461    17.605     0.200
    28.489    18.255     0.200
    28.489    17.742     0.200
    28.534    17.839     0.200
    28.529    22.909     0.200
    28.548    17.467     0.200
    28.579    20.725     0.200
    28.579    20.517     0.200
    28.593    20.916     0.200
    28.567    17.104     0.200
    28.605    17.267     0.200
    28.655    17.451     0.200
    28.665    17.666     0.200
    28.696    16.559     0.200
    28.713    17.826     0.200
    28.715    16.383     0.200
    28.758    20.864     0.200
    28.719    16.787     0.200
    28.757    19.096     0.200
    28.741    16.119     0.200
    28.753    17.900     0.200
    28.829    17.066     0.200
    28.870    17.796     0.200
    28.837    16.415     0.200
    28.880    18.536     0.200
    28.841    16.849     0.200
    28.857    17.612     0.200
    28.857    17.232     0.200
    28.875    20.204     0.200
    28.917    17.379     0.200
    28.926    15.963     0.200
    28.930    16.265     0.200
    28.978    16.373     0.200
    28.978    16.757     0.200
    28.981    16.607     0.200
    29.025    19.135     0.200
    29.041    16.291     0.200
    29.059    16.175     0.200
    29.059    16.277     0.200
    29.059    14.783     0.200
    29.084    16.662     0.200
    29.095    22.295     0.200
    29.111    16.574     0.200
    29.162    15.676     0.200
    29.171    15.833     0.200
    29.171    16.036     0.200
    29.296    19.568     0.200
    29.264    20.320     0.200
    29.314    15.511     0.200
    29.219    16.580     0.200
    29.326    15.583     0.200
    29.333    15.218     0.200
    29.334    20.838     0.200
    29.373    19.233     0.200
    29.424    17.558     0.200
    29.402    15.128     0.200
    29.397    21.422     0.200
    29.413    14.782     0.200
    29.437    15.398     0.200
    29.523    16.072     0.200
    29.523    15.295     0.200
    29.535    15.313     0.200
    29.581    17.905     0.200
    29.551    17.635     0.200
    29.621    17.995     0.200
    29.606    14.937     0.200
    29.678    17.173     0.200
    29.669    14.666     0.200
    29.713    19.066     0.200
    29.696    15.213     0.200
    29.696    14.525     0.200
    29.696    14.073     0.200
    29.731    14.167     0.200
    29.740    13.984     0.200
    29.777    17.256     0.200
    29.768    19.086     0.200
    29.794    15.725     0.200
    29.794    15.196     0.200
    29.796    14.684     0.200
    29.796    14.415     0.200
    29.838    14.482     0.200
    29.851    14.285     0.200
    29.889    16.292     0.200
    29.922    13.680     0.200
    29.985    14.364     0.200
    29.991    13.492     0.200
    29.997    13.454     0.200
    18.388    40.711     0.200
    18.454    37.943     0.200
    18.597    41.037     0.200
    18.597    40.908     0.200
    18.848    37.412     0.200
    18.848    38.021     0.200
    18.844    40.495     0.200
    18.930    38.850     0.200
    18.930    38.307     0.200
    18.998    40.907     0.200
    19.253    40.335     0.200
    19.253    41.530     0.200
    19.306    41.785     0.200
    19.416    40.508     0.200
    19.416    40.098     0.200
    19.515    41.100     0.200
    19.515    40.511     0.200
    19.566    38.267     0.200
    19.631    37.764     0.200
    19.645    37.160     0.200
    19.650    40.164     0.200
    19.659    40.108     0.200
    19.754    40.124     0.200
    19.801    37.162     0.200
    19.822    36.676     0.200
    20.079    36.713     0.200
    20.214    39.521     0.200
    20.220    36.324     0.200
    20.310    36.500     0.200
    20.381    38.888     0.200
    20.377    38.153     0.200
    20.397    38.672     0.200
    20.451    39.543     0.200
    20.542    38.827     0.200
    20.546    38.936     0.200
    20.594    39.440     0.200
    20.599    39.469     0.200
    20.603    39.326     0.200
    20.645    39.288     0.200
    20.651    38.793     0.200
    20.660    40.069     0.200
    20.705    38.222     0.200
    20.736    39.986     0.200
    20.736    38.693     0.200
    20.839    35.804     0.200
    20.839    35.941     0.200
    20.935    40.126     0.200
    20.944    37.053     0.200
    21.087    38.034     0.200
    21.163    39.546     0.200
    21.239    35.890     0.200
    21.318    35.293     0.200
    21.331    35.874     0.200
    21.540    35.564     0.200
    21.617    35.093     0.200
    21.609    36.947     0.200
    21.669    36.002     0.200
    21.669    35.155     0.200
    21.673    38.054     0.200
    21.686    37.516     0.200
    21.748    36.773     0.200
    21.748    35.398     0.200
    21.762    36.242     0.200
    21.762    35.718     0.200
    21.789    38.731     0.200
    21.789    38.294     0.200
    21.886    37.577     0.200
    21.886    37.972     0.200
    22.006    34.913     0.200
    22.114    34.568     0.200
    22.119    35.258     0.200
    22.197    34.933     0.200
    22.230    34.770     0.200
    22.270    37.551     0.200
    22.306    34.322     0.200
    22.351    37.815     0.200
    22.351    37.636     0.200
    22.426    34.738     0.200
    22.466    34.353     0.200
    22.506    34.748     0.200
    22.520    34.438     0.200
    22.520    34.594     0.200
    22.620    33.840     0.200
    22.625    33.860     0.200
    22.632    34.054     0.200
    22.674    37.903     0.200
    22.674    37.083     0.200
    22.687    33.661     0.200
    22.679    36.538     0.200
    22.795    33.962     0.200
    23.009    33.960     0.200
    23.043    33.099     0.200
    23.186    33.170     0.200
    23.254    33.170     0.200
    23.316    32.879     0.200
    23.325    32.967     0.200
    23.345    33.117     0.200
    23.401    32.506     0.200
    23.547    33.019     0.200
    23.547    32.683     0.200
    23.580    32.352     0.200
    23.642    36.624     0.200
    23.696    35.943     0.200
    23.759    31.702     0.200
    23.827    31.336     0.200
    23.873    35.894     0.200
    23.937    31.842     0.200
    23.941    35.930     0.200
    23.941    35.926     0.200
    24.111    31.042     0.200
    24.111    31.694     0.200
    24.154    30.711     0.200
    24.191    30.669     0.200
    24.203    34.095     0.200
    24.302    31.028     0.200
    24.302    31.282     0.200
    24.346    34.334     0.200
    24.414    30.727     0.200
    24.484    31.062     0.200
    24.495    30.501     0.200
    24.548    34.250     0.200
    24.566    29.109     0.200
    24.624    33.583     0.200
    24.648    29.790     0.200
    24.691    30.433     0.200
    24.797    29.638     0.200
    24.794    28.964     0.200
    24.832    29.098     0.200
    24.828    33.536     0.200
    24.884    29.137     0.200
    24.900    30.067     0.200
    24.900    29.469     0.200
    24.995    31.016     0.200
    25.083    33.158     0.200
    25.117    28.369     0.200
    25.181    28.887     0.200
    25.181    28.594     0.200
    25.237    27.891     0.200
    25.277    28.288     0.200
    25.268    30.912     0.200
    25.317    27.830     0.200
    25.345    28.318     0.200
    25.496    27.917     0.200
    25.540    28.581     0.200
    25.716    27.145     0.200
    25.805    26.939     0.200
    25.839    26.616     0.200
    25.978    26.544     0.200
    26.002    26.401     0.200
    26.008    28.885     0.200
    26.056    29.956     0.200
    26.180    26.412     0.200
    26.693    24.524     0.200
    26.756    23.163     0.200
    26.780    23.056     0.200
    26.822    23.622     0.200
    26.879    23.445     0.200
    26.895    26.381     0.200
    27.005    22.880     0.200
    27.072    23.204     0.200
    27.164    23.473     0.200
    27.451    22.677     0.200
    27.640    21.807     0.200
    27.648    22.220     0.200
    28.171    21.437     0.200
    28.497    18.798     0.200
    28.931    18.854     0.200
    14.337    39.031     0.200
    14.571    38.580     0.200
    14.571    41.600     0.200
    14.650    41.252     0.200
    14.999    40.515     0.200
    14.999    40.136     0.200
    15.409    39.382     0.200
    15.529    40.311     0.200
    15.650    39.781     0.200
    15.719    41.174     0.200
    16.414    40.073     0.200
    16.483    40.156     0.200
    16.483    40.609     0.200
    16.483    41.652     0.200
    16.694    40.472     0.200
    16.798    38.953     0.200
    16.798    39.875     0.200
    17.272    41.800     0.200
    17.755    41.836     0.200
    17.782    39.043     0.200
    18.102    41.810     0.200
    18.110    41.543     0.200
    18.118    40.964     0.200
    18.118    41.280     0.200
    19.508    36.765     0.200
    19.858    36.520     0.200
    19.864    36.932     0.200
    19.962    39.571     0.200
    20.175    40.153     0.200
    20.239    38.117     0.200
    20.399    39.576     0.200
    20.407    39.889     0.200
    20.465    39.143     0.200
    20.669    37.931     0.200
    20.758    39.767     0.200
    21.020    35.746     0.200
    21.104    39.052     0.200
    21.112    39.423     0.200
    21.137    39.132     0.200
    21.232    38.246     0.200
    21.251    39.781     0.200
    21.251    39.445     0.200
    21.259    37.533     0.200
    21.313    38.286     0.200
    21.313    38.857     0.200
    21.337    37.262     0.200
    21.477    35.381     0.200
    21.488    39.383     0.200
    21.533    34.798     0.200
    21.540    36.411     0.200
    21.600    38.270     0.200
    21.654    37.299     0.200
    21.681    38.264     0.200
    21.707    39.067     0.200
    21.773    39.306     0.200
    21.801    39.266     0.200
    21.825    37.418     0.200
    21.863    35.319     0.200
    21.920    34.664     0.200
    21.895    38.200     0.200
    21.956    35.235     0.200
    21.989    34.437     0.200
    22.159    38.779     0.200
    22.159    38.591     0.200
    22.352    33.703     0.200
    22.338    37.887     0.200
    22.374    33.310     0.200
    22.426    34.443     0.200
    22.587    33.515     0.200
    22.620    34.307     0.200
    22.620    33.522     0.200
    22.824    33.047     0.200
    22.834    33.140     0.200
    22.843    33.278     0.200
    22.871    36.052     0.200
    22.973    32.648     0.200
    23.082    37.168     0.200
    23.136    36.618     0.200
    23.329    36.172     0.200
    23.396    36.757     0.200
    23.396    36.761     0.200
    23.450    31.771     0.200
    23.473    32.278     0.200
    23.480    32.689     0.200
    23.485    32.222     0.200
    23.625    32.570     0.200
    23.625    31.589     0.200
    23.642    32.229     0.200
    23.657    35.696     0.200
    23.809    35.655     0.200
    23.912    31.700     0.200
    24.020    31.090     0.200
    24.027    30.992     0.200
    24.063    31.703     0.200
    24.128    32.978     0.200
    24.134    34.366     0.200
    24.415    30.027     0.200
    24.531    34.187     0.200
    24.557    29.709     0.200
    24.601    32.809     0.200
    24.601    32.805     0.200
    24.644    29.062     0.200
    24.839    29.902     0.200
    24.921    32.626     0.200
    24.962    29.261     0.200
    24.965    29.630     0.200
    25.011    29.303     0.200
    25.022    28.383     0.200
    25.039    29.231     0.200
    25.068    29.444     0.200
    25.226    29.085     0.200
    25.366    29.317     0.200
    25.366    28.712     0.200
    25.461    28.950     0.200
    25.550    29.926     0.200
    25.603    31.268     0.200
    26.438    27.860     0.200
    26.984    23.133     0.200
    27.702    24.440     0.200
    27.710    24.007     0.200
    27.769    20.824     0.200
    27.889    23.007     0.200
    28.295    20.941     0.200
    28.502    19.673     0.200
    28.628    21.860     0.200
    29.037    18.392     0.200
    29.751    18.688     0.200
    13.623    34.994     0.200
    13.623    32.619     0.200
    13.685    35.263     0.200
    13.685    33.216     0.200
    13.755    35.897     0.200
    14.388    33.005     0.200
    14.566    35.265     0.200
    14.959    35.662     0.200
    14.995    33.783     0.200
    15.031    34.459     0.200
    15.118    33.824     0.200
    15.556    34.722     0.200
    15.556    33.996     0.200
    15.715    33.930     0.200
    15.715    35.735     0.200
    16.102    34.844     0.200
    16.586    36.579     0.200
    16.586    36.024     0.200
    16.898    33.474     0.200
    17.571    31.282     0.200
    17.868    32.446     0.200
    17.881    32.827     0.200
    18.028    33.154     0.200
    18.338    32.701     0.200
    18.897    32.795     0.200
    19.411    30.158     0.200
    19.688    31.043     0.200
    20.195    32.140     0.200
    20.335    29.657     0.200
    20.461    34.051     0.200
    20.829    32.782     0.200
    21.077    30.472     0.200
    21.979    27.604     0.200
    22.057    28.249     0.200
    22.455    30.381     0.200
    22.768    25.793     0.200
    22.858    28.312     0.200
    23.060    25.518     0.200
    23.187    25.357     0.200
    23.501    26.530     0.200
    23.854    25.676     0.200
    23.894    23.445     0.200
    24.004    24.244     0.200
    24.100    22.919     0.200
    24.356    22.980     0.200
    24.528    23.333     0.200
    24.604    22.783     0.200
    29.081    12.833     0.200
    29.628    12.185     0.200
    16.456    40.222     0.200
    16.799    40.357     0.200
    23.862    32.703     0.200
    24.700    29.956     0.200
    24.700    30.769     0.200
    25.357    29.186     0.200
    25.357    28.591     0.200
    16.994    39.979     0.200
    19.463    38.296     0.200
    19.558    38.187     0.200
    21.183    37.657     0.200
    21.186    36.341     0.200
    21.750    36.489     0.200
    24.059    31.521     0.200
    24.591    28.797     0.200
    24.664    32.230     0.200
    24.664    32.613     0.200
    25.054    31.126     0.200
    27.838    24.370     0.200
    24.207    35.013     0.200
    15.487    40.631     0.200
    16.843    40.902     0.200
    17.708    41.945     0.200
    17.941    42.256     0.200
    18.321    42.053     0.200
    18.452    37.825     0.200
    18.475    39.665     0.200
    18.583    40.558     0.200
    18.571    38.167     0.200
    18.694    38.747     0.200
    18.727    38.310     0.200
    18.763    38.907     0.200
    18.806    39.023     0.200
    18.812    40.383     0.200
    18.834    40.984     0.200
    18.834    40.368     0.200
    18.843    37.704     0.200
    18.927    38.259     0.200
    18.927    39.030     0.200
    19.044    38.192     0.200
    19.183    39.052     0.200
    19.166    39.851     0.200
    19.233    38.640     0.200
    19.297    38.783     0.200
    19.372    38.889     0.200
    19.376    38.526     0.200
    19.404    39.729     0.200
    19.404    40.179     0.200
    19.409    37.880     0.200
    19.410    38.337     0.200
    19.505    39.523     0.200
    19.505    40.233     0.200
    19.502    38.957     0.200
    19.566    38.291     0.200
    19.564    38.782     0.200
    19.564    37.685     0.200
    19.564    37.747     0.200
    19.647    39.615     0.200
    19.634    37.302     0.200
    19.643    38.097     0.200
    19.819    36.990     0.200
    19.900    38.149     0.200
    20.218    36.724     0.200
    20.311    40.288     0.200
    20.308    36.752     0.200
    20.308    37.057     0.200
    20.365    39.547     0.200
    20.384    38.614     0.200
    20.415    38.483     0.200
    20.437    38.897     0.200
    20.455    36.617     0.200
    20.482    38.894     0.200
    20.487    39.151     0.200
    20.495    39.421     0.200
    20.514    36.525     0.200
    20.585    39.843     0.200
    20.612    38.187     0.200
    20.628    39.284     0.200
    20.654    36.953     0.200
    20.691    38.011     0.200
    20.695    37.825     0.200
    20.695    38.015     0.200
    20.742    39.581     0.200
    20.741    38.849     0.200
    20.738    36.887     0.200
    20.738    36.561     0.200
    20.803    36.724     0.200
    20.841    36.266     0.200
    20.841    36.545     0.200
    20.920    38.418     0.200
    20.932    39.462     0.200
    21.026    39.500     0.200
    21.048    38.878     0.200
    21.093    37.345     0.200
    21.076    38.856     0.200
    21.062    36.658     0.200
    21.090    36.844     0.200
    21.107    38.138     0.200
    21.150    38.674     0.200
    21.239    39.740     0.200
    21.232    36.090     0.200
    21.262    37.756     0.200
    21.310    39.808     0.200
    21.341    38.790     0.200
    21.294    35.838     0.200
    21.440    37.245     0.200
    21.456    37.304     0.200
    21.554    39.125     0.200
    21.554    37.675     0.200
    21.541    35.184     0.200
    21.579    38.554     0.200
    21.560    37.651     0.200
    21.603    35.554     0.200
    21.603    37.253     0.200
    21.636    39.609     0.200
    21.626    35.990     0.200
    21.671    39.101     0.200
    21.670    39.100     0.200
    21.678    37.816     0.200
    21.718    35.088     0.200
    21.773    38.807     0.200
    21.772    37.360     0.200
    21.750    35.318     0.200
    21.763    34.912     0.200
    21.871    38.836     0.200
    21.865    35.957     0.200
    21.947    38.075     0.200
    22.029    38.003     0.200
    22.065    38.306     0.200
    22.075    37.200     0.200
    22.107    34.605     0.200
    22.125    36.126     0.200
    22.157    37.466     0.200
    22.198    37.123     0.200
    22.200    36.482     0.200
    22.254    38.115     0.200
    22.217    34.877     0.200
    22.335    39.195     0.200
    22.335    38.577     0.200
    22.423    34.277     0.200
    22.469    38.511     0.200
    22.520    33.596     0.200
    22.660    37.102     0.200
    22.660    37.554     0.200
    22.668    36.408     0.200
    22.741    35.601     0.200
    22.806    38.298     0.200
    22.796    34.998     0.200
    22.851    37.244     0.200
    23.008    35.098     0.200
    23.037    34.859     0.200
    23.043    33.992     0.200
    23.138    37.310     0.200
    23.207    33.531     0.200
    23.318    36.525     0.200
    23.318    35.957     0.200
    23.319    35.652     0.200
    23.325    33.003     0.200
    23.338    33.518     0.200
    23.404    32.510     0.200
    23.518    33.846     0.200
    23.557    36.789     0.200
    23.568    36.859     0.200
    23.681    37.116     0.200
    23.858    36.161     0.200
    23.879    35.329     0.200
    23.926    36.137     0.200
    23.926    34.660     0.200
    23.938    31.931     0.200
    23.996    32.117     0.200
    24.095    31.738     0.200
    24.115    31.792     0.200
    24.113    31.870     0.200
    24.188    35.082     0.200
    24.295    34.299     0.200
    24.331    35.259     0.200
    24.304    30.904     0.200
    24.385    31.763     0.200
    24.461    32.439     0.200
    24.461    33.519     0.200
    24.533    34.521     0.200
    24.568    30.124     0.200
    24.610    33.238     0.200
    24.660    33.452     0.200
    24.694    30.299     0.200
    24.900    29.415     0.200
    24.900    29.897     0.200
    24.983    31.404     0.200
    24.983    32.926     0.200
    24.983    32.106     0.200
    24.983    32.786     0.200
    25.067    32.028     0.200
    25.184    28.815     0.200
    25.253    33.170     0.200
    25.278    28.015     0.200
    25.278    28.453     0.200
    25.342    28.256     0.200
    25.450    32.292     0.200
    25.496    27.915     0.200
    25.508    28.472     0.200
    25.545    27.600     0.200
    25.569    29.044     0.200
    25.794    29.595     0.200
    25.806    30.508     0.200
    25.842    26.932     0.200
    25.842    27.186     0.200
    25.916    27.236     0.200
    25.996    29.017     0.200
    26.003    26.487     0.200
    26.045    28.637     0.200
    26.045    28.747     0.200
    26.331    26.039     0.200
    26.373    29.413     0.200
    26.340    25.750     0.200
    26.380    26.108     0.200
    26.693    24.304     0.200
    26.803    27.139     0.200
    26.803    28.499     0.200
    27.006    25.749     0.200
    27.081    27.928     0.200
    27.072    23.729     0.200
    27.230    26.200     0.200
    27.354    25.678     0.200
    27.372    22.934     0.200
    27.407    22.951     0.200
    27.499    25.674     0.200
    27.549    22.309     0.200
    27.643    26.352     0.200
    27.651    21.767     0.200
    27.651    21.966     0.200
    27.993    21.153     0.200
    28.072    23.234     0.200
    28.090    24.683     0.200
    28.106    22.955     0.200
    28.106    22.853     0.200
    28.119    20.993     0.200
    28.172    19.618     0.200
    28.431    23.018     0.200
    28.615    21.509     0.200
    28.766    25.169     0.200
    28.790    21.422     0.200
    28.949    20.156     0.200
    29.142    21.318     0.200
    29.109    17.498     0.200
    29.287    18.106     0.200
    29.450    22.885     0.200
    29.516    16.443     0.200
    29.786    18.199     0.200
    29.807    21.294     0.200
    29.917    17.305     0.200
    14.914    39.171     0.200
    15.037    39.172     0.200
    15.169    40.847     0.200
    15.477    38.912     0.200
    15.874    43.759     0.200
    16.296    39.618     0.200
    16.296    39.352     0.200
    16.441    40.216     0.200
    16.646    42.309     0.200
    16.676    43.065     0.200
    17.181    39.259     0.200
    17.317    40.933     0.200
    17.314    40.045     0.200
    17.416    39.546     0.200
    17.500    42.832     0.200
    17.663    39.804     0.200
    17.777    39.571     0.200
    17.803    39.747     0.200
    17.968    41.068     0.200
    17.968    39.953     0.200
    17.999    39.544     0.200
    17.945    40.522     0.200
    18.061    39.148     0.200
    18.175    40.095     0.200
    18.043    42.195     0.200
    18.241    39.908     0.200
    18.064    43.143     0.200
    18.370    39.235     0.200
    18.391    40.119     0.200
    18.581    39.501     0.200
    18.684    40.087     0.200
    18.808    39.205     0.200
    19.555    40.109     0.200
    19.843    38.788     0.200
    19.781    39.558     0.200
    19.890    37.996     0.200
    19.790    39.587     0.200
    19.865    38.828     0.200
    20.009    38.583     0.200
    20.459    37.651     0.200
    20.500    38.703     0.200
    20.502    39.195     0.200
    20.759    36.974     0.200
    20.633    38.073     0.200
    20.626    39.305     0.200
    20.982    37.820     0.200
    20.982    37.484     0.200
    21.155    40.592     0.200
    21.212    38.539     0.200
    21.212    38.198     0.200
    22.015    36.687     0.200
    22.730    35.795     0.200
    22.912    33.713     0.200
    22.773    39.897     0.200
    22.773    38.219     0.200
    23.402    33.988     0.200
    23.985    33.906     0.200
    23.985    35.586     0.200
    24.393    32.406     0.200
    24.639    30.341     0.200
    24.928    29.048     0.200
    24.928    30.212     0.200
    25.105    30.010     0.200
    25.364    30.844     0.200
    25.412    28.895     0.200
    25.817    28.033     0.200
    25.813    28.159     0.200
    25.811    29.114     0.200
    26.251    28.534     0.200
    26.511    26.407     0.200
    26.511    26.769     0.200
    14.682    41.848     0.200
    14.933    39.113     0.200
    15.259    39.935     0.200
    15.466    40.785     0.200
    15.466    39.598     0.200
    15.590    40.699     0.200
    15.649    40.941     0.200
    16.412    39.389     0.200
    16.588    39.195     0.200
    17.203    40.534     0.200
    17.239    40.220     0.200
    17.334    41.575     0.200
    17.334    41.083     0.200
    17.643    39.916     0.200
    17.696    41.102     0.200
    17.754    41.385     0.200
    17.758    40.932     0.200
    18.033    41.529     0.200
    18.039    41.202     0.200
    18.051    41.250     0.200
    18.131    41.431     0.200
    18.432    37.857     0.200
    18.401    36.685     0.200
    18.401    37.935     0.200
    18.652    38.219     0.200
    18.697    37.723     0.200
    18.836    37.009     0.200
    18.859    38.562     0.200
    19.041    38.922     0.200
    19.052    39.023     0.200
    19.400    37.795     0.200
    19.693    36.857     0.200
    19.728    38.472     0.200
    19.811    38.308     0.200
    19.811    38.542     0.200
    19.960    37.752     0.200
    20.178    37.004     0.200
    20.242    36.551     0.200
    20.242    36.379     0.200
    20.365    38.329     0.200
    20.365    38.954     0.200
    20.476    36.734     0.200
    20.476    37.312     0.200
    20.503    36.075     0.200
    20.503    36.684     0.200
    20.652    38.157     0.200
    20.781    36.421     0.200
    20.970    35.570     0.200
    20.970    36.468     0.200
    21.046    39.497     0.200
    21.060    38.371     0.200
    21.068    38.584     0.200
    21.074    38.780     0.200
    21.062    38.781     0.200
    21.188    39.634     0.200
    21.166    36.221     0.200
    21.197    35.726     0.200
    21.253    38.728     0.200
    21.253    39.196     0.200
    21.431    39.088     0.200
    21.412    34.616     0.200
    21.412    36.905     0.200
    21.495    34.476     0.200
    21.587    35.341     0.200
    21.646    38.871     0.200
    21.605    34.664     0.200
    21.714    39.066     0.200
    21.739    38.805     0.200
    21.838    38.674     0.200
    21.858    33.774     0.200
    21.869    35.399     0.200
    22.094    37.436     0.200
    22.094    38.022     0.200
    22.132    34.255     0.200
    22.202    38.415     0.200
    22.280    37.790     0.200
    22.292    34.467     0.200
    22.326    36.333     0.200
    22.364    34.892     0.200
    22.455    33.988     0.200
    22.553    35.817     0.200
    22.563    32.587     0.200
    22.563    33.103     0.200
    22.803    36.319     0.200
    22.814    32.878     0.200
    22.828    33.936     0.200
    22.866    32.798     0.200
    23.075    36.175     0.200
    23.049    32.880     0.200
    23.267    36.486     0.200
    23.284    37.428     0.200
    23.275    34.863     0.200
    23.286    33.255     0.200
    23.333    37.070     0.200
    23.333    36.296     0.200
    23.318    32.721     0.200
    23.315    31.901     0.200
    23.396    32.082     0.200
    23.424    32.341     0.200
    23.542    35.160     0.200
    23.521    32.159     0.200
    23.595    36.352     0.200
    23.578    31.420     0.200
    23.578    31.638     0.200
    23.586    31.864     0.200
    23.694    36.182     0.200
    23.746    35.366     0.200
    23.807    33.899     0.200
    24.047    34.330     0.200
    24.009    31.216     0.200
    24.068    34.949     0.200
    24.068    34.378     0.200
    24.064    32.770     0.200
    24.081    30.651     0.200
    24.179    31.935     0.200
    24.216    34.787     0.200
    24.268    33.460     0.200
    24.411    30.345     0.200
    24.469    33.336     0.200
    24.429    30.542     0.200
    24.530    33.160     0.200
    24.531    33.338     0.200
    24.656    33.677     0.200
    24.687    29.943     0.200
    24.687    29.795     0.200
    24.764    28.453     0.200
    24.859    33.291     0.200
    24.840    29.966     0.200
    24.868    29.506     0.200
    24.914    28.792     0.200
    24.928    29.182     0.200
    24.928    29.604     0.200
    25.316    29.140     0.200
    25.443    31.642     0.200
    25.434    30.526     0.200
    25.480    30.098     0.200
    25.498    28.968     0.200
    25.533    29.809     0.200
    25.638    29.231     0.200
    25.691    29.681     0.200
    25.764    30.176     0.200
    25.799    28.110     0.200
    25.816    26.631     0.200
    25.816    28.366     0.200
    26.138    25.964     0.200
    26.138    26.230     0.200
    26.370    26.648     0.200
    26.370    28.648     0.200
    26.476    28.267     0.200
    26.656    27.179     0.200
    26.721    24.229     0.200
    26.791    26.669     0.200
    26.887    27.030     0.200
    27.061    25.066     0.200
    27.129    23.336     0.200
    27.158    26.235     0.200
    27.517    25.087     0.200
    27.640    25.161     0.200
    27.640    23.872     0.200
    27.827    24.207     0.200
    27.887    25.191     0.200
    28.015    23.030     0.200
    28.015    22.834     0.200
    28.019    23.045     0.200
    28.196    23.628     0.200
    28.223    23.022     0.200
    28.234    20.420     0.200
    28.416    21.846     0.200
    28.564    22.771     0.200
    28.772    22.257     0.200
    28.910    22.417     0.200
    29.208    21.258     0.200
    29.283    18.668     0.200
    29.361    20.353     0.200
    29.393    19.634     0.200
    29.466    20.366     0.200
    29.483    19.777     0.200
    29.615    16.466     0.200
    29.689    19.916     0.200
    29.827    18.812     0.200
    17.085    40.565     0.200
    18.042    40.823     0.200
    18.282    38.394     0.200
    18.537    37.453     0.200
    18.755    37.713     0.200
    18.755    37.198     0.200
    18.774    38.207     0.200
    19.071    40.274     0.200
    19.034    38.022     0.200
    19.218    40.398     0.200
    19.373    37.777     0.200
    19.449    40.588     0.200
    19.455    37.760     0.200
    19.509    36.770     0.200
    19.531    37.368     0.200
    19.685    40.401     0.200
    19.704    38.143     0.200
    19.773    39.878     0.200
    19.882    38.681     0.200
    20.142    40.266     0.200
    20.151    36.899     0.200
    20.204    39.540     0.200
    20.604    35.487     0.200
    20.784    36.578     0.200
    20.817    38.402     0.200
    20.817    37.080     0.200
    21.196    38.544     0.200
    21.526    37.996     0.200
    21.505    38.383     0.200
    21.573    35.163     0.200
    21.749    35.470     0.200
    22.077    34.396     0.200
    22.256    33.482     0.200
    22.258    34.193     0.200
    22.364    38.800     0.200
    22.402    35.854     0.200
    22.451    36.309     0.200
    22.586    37.506     0.200
    22.731    37.257     0.200
    22.834    38.410     0.200
    22.866    34.931     0.200
    22.995    32.818     0.200
    23.020    32.541     0.200
    23.020    32.752     0.200
    23.073    36.077     0.200
    23.125    35.814     0.200
    23.258    32.692     0.200
    23.541    34.113     0.200
    23.662    33.782     0.200
    24.232    30.395     0.200
    24.232    29.489     0.200
    24.309    33.447     0.200
    24.335    29.948     0.200
    24.379    33.366     0.200
    24.648    29.413     0.200
    24.665    30.857     0.200
    24.773    32.369     0.200
    24.836    30.292     0.200
    24.956    29.177     0.200
    24.988    30.849     0.200
    25.245    29.208     0.200
    25.245    29.677     0.200
    25.467    26.989     0.200
    25.528    30.195     0.200
    25.678    26.279     0.200
    25.957    26.142     0.200
    26.051    25.012     0.200
    26.889    23.122     0.200
    27.218    23.600     0.200
    27.473    22.790     0.200
    28.384    21.287     0.200
    28.384    20.987     0.200
    28.782    19.869     0.200
    14.669    42.258     0.200
    14.670    41.673     0.200
    15.581    42.156     0.200
    16.004    41.757     0.200
    16.004    41.904     0.200
    16.462    40.380     0.200
    16.592    40.986     0.200
    16.792    41.333     0.200
    18.421    38.347     0.200
    18.529    40.913     0.200
    18.807    38.168     0.200
    18.807    38.646     0.200
    18.895    38.918     0.200
    19.455    40.030     0.200
    19.455    40.143     0.200
    19.526    37.106     0.200
    19.535    38.725     0.200
    19.597    40.476     0.200
    19.613    38.290     0.200
    20.188    37.364     0.200
    20.311    40.618     0.200
    20.276    37.077     0.200
    20.276    37.180     0.200
    20.666    40.239     0.200
    20.649    37.338     0.200
    20.694    38.237     0.200
    20.775    36.420     0.200
    20.823    36.793     0.200
    20.973    39.452     0.200
    21.187    36.670     0.200
    21.256    39.581     0.200
    21.200    36.120     0.200
    21.518    36.538     0.200
    21.603    39.031     0.200
    21.564    36.241     0.200
    21.719    37.607     0.200
    21.719    38.820     0.200
    21.816    39.023     0.200
    22.147    37.969     0.200
    22.184    35.410     0.200
    22.281    38.751     0.200
    22.392    34.594     0.200
    22.496    33.561     0.200
    22.605    36.774     0.200
    22.605    37.809     0.200
    22.679    33.853     0.200
    22.980    34.895     0.200
    22.988    35.282     0.200
    23.084    35.851     0.200
    23.303    33.520     0.200
    23.351    33.368     0.200
    23.390    33.018     0.200
    23.523    32.650     0.200
    23.871    36.350     0.200
    23.969    32.335     0.200
    24.411    33.308     0.200
    24.556    33.117     0.200
    24.549    30.833     0.200
    24.678    30.418     0.200
    24.932    32.369     0.200
    24.932    32.225     0.200
    25.259    29.421     0.200
    25.259    29.956     0.200
    25.469    28.474     0.200
    25.746    29.372     0.200
    25.827    27.089     0.200
    25.830    29.392     0.200
    26.003    27.900     0.200
    26.003    28.775     0.200
    26.315    25.436     0.200
    26.667    24.647     0.200
    26.828    28.677     0.200
    26.978    24.388     0.200
    27.386    23.341     0.200
    27.633    23.134     0.200
    28.054    24.370     0.200
    29.259    19.188     0.200
    16.649    37.779     0.200
    18.101    35.069     0.200
    18.242    35.876     0.200
    18.515    35.617     0.200
    18.605    37.215     0.200
    18.995    34.895     0.200
    19.289    36.192     0.200
    19.288    34.951     0.200
    19.460    34.599     0.200
    19.479    34.619     0.200
    19.865    33.844     0.200
    20.446    34.031     0.200
    20.461    33.381     0.200
    20.957    32.964     0.200
    21.021    35.752     0.200
    21.169    32.920     0.200
    21.337    34.643     0.200
    21.371    33.350     0.200
    21.387    32.249     0.200
    21.451    35.702     0.200
    21.875    31.925     0.200
    22.075    31.367     0.200
    22.151    31.448     0.200
    22.319    30.858     0.200
    22.576    31.479     0.200
    23.021    29.782     0.200
    23.046    29.971     0.200
    23.178    29.680     0.200
    23.787    29.309     0.200
    23.864    32.452     0.200
    24.189    27.953     0.200
    24.189    27.774     0.200
    24.313    27.683     0.200
    24.801    27.372     0.200
    24.815    27.427     0.200
    24.901    26.635     0.200
    24.952    26.013     0.200
    25.132    25.876     0.200
    14.745    39.380     0.200
    15.484    41.344     0.200
    15.602    40.967     0.200
    15.657    39.723     0.200
    16.083    40.812     0.200
    16.155    40.951     0.200
    16.477    41.219     0.200
    16.634    40.259     0.200
    16.630    40.490     0.200
    16.630    39.728     0.200
    16.748    39.857     0.200
    16.837    41.406     0.200
    17.778    39.539     0.200
    18.444    38.055     0.200
    18.805    39.094     0.200
    18.836    38.547     0.200
    18.828    39.530     0.200
    19.399    39.513     0.200
    19.635    37.646     0.200
    19.736    39.735     0.200
    19.811    36.215     0.200
    19.983    39.541     0.200
    20.210    37.273     0.200
    20.276    37.265     0.200
    20.718    38.937     0.200
    20.833    35.698     0.200
    20.833    36.210     0.200
    20.917    37.127     0.200
    20.930    39.007     0.200
    21.025    38.079     0.200
    21.224    35.515     0.200
    21.308    38.768     0.200
    21.533    35.976     0.200
    21.548    39.214     0.200
    21.655    38.028     0.200
    21.771    38.651     0.200
    21.771    39.159     0.200
    21.869    39.437     0.200
    22.063    38.507     0.200
    22.193    36.670     0.200
    22.252    37.408     0.200
    22.333    38.757     0.200
    22.415    34.039     0.200
    22.512    33.813     0.200
    22.656    37.045     0.200
    22.662    36.678     0.200
    23.396    32.725     0.200
    23.396    32.335     0.200
    23.624    36.293     0.200
    23.923    36.357     0.200
    24.559    30.724     0.200
    24.606    34.837     0.200
    24.686    30.091     0.200
    24.978    30.617     0.200
    24.978    30.440     0.200
    25.270    28.587     0.200
    26.684    24.079     0.200
    26.996    23.795     0.200
    28.101    22.469     0.200
    23.898    34.901     0.200
    24.921    31.903     0.200
    15.309    41.021     0.200
    16.431    41.221     0.200
    24.571    32.159     0.200
    19.317    36.431     0.200
    19.894    35.375     0.200
    20.481    33.805     0.200
    20.475    33.905     0.200
    22.105    31.682     0.200
    22.175    31.791     0.200
    22.339    31.407     0.200
    23.078    30.629     0.200
    23.610    29.669     0.200
    23.821    29.630     0.200
    24.208    28.791     0.200
    24.331    29.133     0.200
    24.437    27.560     0.200
    24.548    27.719     0.200
    24.822    26.575     0.200
    24.845    26.715     0.200
    25.476    25.535     0.200
    16.697    37.506     0.200
    18.036    35.231     0.200
    18.104    35.722     0.200
    18.297    35.589     0.200
    18.403    37.111     0.200
    18.998    36.967     0.200
    19.053    34.816     0.200
    19.221    34.915     0.200
    19.229    35.737     0.200
    19.299    34.478     0.200
    20.067    34.888     0.200
    20.340    34.581     0.200
    20.389    34.537     0.200
    20.813    32.907     0.200
    21.342    33.693     0.200
    22.072    31.226     0.200
    22.325    33.614     0.200
    23.093    30.616     0.200
    23.798    28.704     0.200
    23.908    28.898     0.200
    24.098    31.689     0.200
    24.198    28.130     0.200
    24.405    27.868     0.200
    24.661    29.237     0.200
    24.862    28.321     0.200
    24.862    27.021     0.200
    16.640    43.109     0.200
    17.562    43.890     0.200
    17.924    42.834     0.200
    18.533    40.436     0.200
    18.641    40.215     0.200
    18.753    41.499     0.200
    19.225    40.325     0.200
    19.224    42.281     0.200
    19.263    39.591     0.200
    19.501    40.601     0.200
    19.840    38.515     0.200
    19.791    42.051     0.200
    19.878    38.323     0.200
    20.060    42.002     0.200
    20.202    39.902     0.200
    20.242    39.779     0.200
    20.205    40.298     0.200
    20.310    40.802     0.200
    20.323    40.682     0.200
    20.352    39.109     0.200
    20.354    38.675     0.200
    20.421    38.791     0.200
    20.432    38.659     0.200
    20.438    38.997     0.200
    20.437    40.263     0.200
    20.458    39.269     0.200
    20.479    41.033     0.200
    20.528    39.980     0.200
    20.522    40.873     0.200
    20.880    38.227     0.200
    20.844    41.264     0.200
    20.996    41.222     0.200
    21.141    39.096     0.200
    21.342    39.470     0.200
    21.335    37.932     0.200
    21.326    38.509     0.200
    21.444    40.108     0.200
    21.448    41.067     0.200
    21.935    39.687     0.200
    22.003    39.441     0.200
    22.044    38.033     0.200
    22.290    36.637     0.200
    22.548    36.568     0.200
    22.804    38.403     0.200
    22.857    36.577     0.200
    22.924    36.119     0.200
    22.991    35.576     0.200
    23.867    37.204     0.200
    24.106    33.043     0.200
    24.160    32.689     0.200
    24.160    31.734     0.200
    24.283    33.025     0.200
    24.264    35.945     0.200
    24.388    33.099     0.200
    24.506    33.437     0.200
    24.495    36.604     0.200
    24.495    34.670     0.200
    24.774    32.367     0.200
    24.793    34.475     0.200
    24.793    33.525     0.200
    24.793    32.218     0.200
    24.969    32.630     0.200
    25.106    32.086     0.200
    25.430    30.239     0.200
    25.730    30.035     0.200
    25.778    29.821     0.200
    25.877    28.305     0.200
    25.931    29.355     0.200
    14.680    39.507     0.200
    14.701    39.819     0.200
    14.790    39.682     0.200
    15.543    41.326     0.200
    15.571    39.832     0.200
    15.673    41.005     0.200
    16.062    39.477     0.200
    16.095    40.933     0.200
    16.095    41.248     0.200
    16.119    40.424     0.200
    16.641    39.630     0.200
    16.872    39.995     0.200
    16.872    41.903     0.200
    16.872    40.806     0.200
    16.922    41.210     0.200
    17.013    40.822     0.200
    18.011    40.422     0.200
    18.416    37.779     0.200
    18.416    39.279     0.200
    19.073    38.512     0.200
    19.218    38.690     0.200
    19.309    37.779     0.200
    19.567    38.452     0.200
    19.605    37.629     0.200
    19.790    37.019     0.200
    20.181    36.104     0.200
    20.226    36.157     0.200
    20.347    38.911     0.200
    20.588    36.456     0.200
    20.664    38.485     0.200
    20.736    36.946     0.200
    20.777    38.357     0.200
    20.780    35.587     0.200
    20.840    36.661     0.200
    20.981    38.305     0.200
    21.100    39.330     0.200
    21.104    38.265     0.200
    21.199    35.514     0.200
    21.267    36.649     0.200
    21.314    36.233     0.200
    21.341    38.650     0.200
    21.381    38.679     0.200
    21.418    37.305     0.200
    21.489    36.022     0.200
    21.576    36.349     0.200
    21.588    35.955     0.200
    21.627    38.040     0.200
    21.630    37.884     0.200
    21.695    38.255     0.200
    21.678    35.725     0.200
    21.708    38.038     0.200
    21.726    38.727     0.200
    21.720    38.000     0.200
    21.737    38.770     0.200
    21.745    38.124     0.200
    21.773    38.316     0.200
    21.837    39.210     0.200
    21.943    39.172     0.200
    22.161    35.207     0.200
    22.323    37.303     0.200
    22.402    37.053     0.200
    22.408    36.572     0.200
    22.389    33.359     0.200
    22.470    33.598     0.200
    22.470    34.413     0.200
    22.593    37.692     0.200
    22.718    36.563     0.200
    23.337    33.022     0.200
    23.991    35.063     0.200
    24.507    29.305     0.200
    24.852    29.288     0.200
    24.852    30.013     0.200
    25.017    31.740     0.200
    25.017    31.281     0.200
    25.017    31.331     0.200
    25.017    29.964     0.200
    25.118    30.437     0.200
    25.220    30.049     0.200
    26.121    26.008     0.200
    26.645    24.036     0.200
    26.960    23.492     0.200
    28.119    20.592     0.200
    28.142    22.771     0.200
    29.243    17.969     0.200
    14.667    40.492     0.200
    14.799    40.589     0.200
    14.966    40.523     0.200
    15.183    39.330     0.200
    16.818    39.723     0.200
    16.866    39.128     0.200
    17.704    39.126     0.200
    17.702    40.473     0.200
    17.842    39.874     0.200
    18.364    37.335     0.200
    18.364    38.893     0.200
    18.403    39.800     0.200
    18.557    36.960     0.200
    18.556    37.299     0.200
    18.709    39.465     0.200
    18.797    39.330     0.200
    19.250    38.985     0.200
    19.260    39.780     0.200
    19.267    37.964     0.200
    19.267    40.003     0.200
    19.317    39.303     0.200
    19.387    39.203     0.200
    19.492    36.954     0.200
    19.553    37.810     0.200
    19.716    37.113     0.200
    19.736    37.497     0.200
    19.724    38.367     0.200
    19.761    39.455     0.200
    20.016    35.064     0.200
    19.834    39.598     0.200
    20.025    39.478     0.200
    20.129    36.794     0.200
    20.136    39.610     0.200
    20.147    38.580     0.200
    20.397    39.691     0.200
    20.590    39.292     0.200
    20.622    39.364     0.200
    20.734    35.901     0.200
    20.734    37.373     0.200
    20.712    36.533     0.200
    20.680    38.083     0.200
    20.745    38.934     0.200
    20.745    38.652     0.200
    20.953    39.182     0.200
    21.050    37.801     0.200
    21.146    35.795     0.200
    21.057    38.915     0.200
    21.213    36.619     0.200
    21.148    38.133     0.200
    21.296    39.003     0.200
    21.441    35.371     0.200
    21.338    38.229     0.200
    21.373    38.663     0.200
    21.521    37.915     0.200
    21.521    37.614     0.200
    21.644    34.464     0.200
    21.627    36.489     0.200
    21.660    35.352     0.200
    21.579    37.162     0.200
    21.682    36.902     0.200
    21.791    37.310     0.200
    21.791    37.181     0.200
    21.900    37.885     0.200
    21.900    37.229     0.200
    22.092    35.721     0.200
    22.020    37.443     0.200
    22.133    34.404     0.200
    22.336    33.715     0.200
    22.336    34.875     0.200
    22.280    36.646     0.200
    22.421    33.685     0.200
    22.421    34.857     0.200
    22.592    32.890     0.200
    22.623    34.451     0.200
    22.636    36.164     0.200
    22.670    35.975     0.200
    22.849    33.910     0.200
    22.915    34.507     0.200
    22.947    37.511     0.200
    23.213    33.186     0.200
    23.224    33.375     0.200
    23.249    32.698     0.200
    23.294    32.811     0.200
    23.294    33.983     0.200
    23.303    32.784     0.200
    23.449    32.884     0.200
    23.651    35.916     0.200
    23.706    35.636     0.200
    23.901    32.348     0.200
    23.877    35.674     0.200
    24.005    31.736     0.200
    23.946    35.497     0.200
    23.946    36.251     0.200
    24.038    32.649     0.200
    24.394    31.475     0.200
    24.462    29.571     0.200
    24.348    34.195     0.200
    24.430    32.034     0.200
    24.613    32.458     0.200
    24.731    29.131     0.200
    24.803    28.731     0.200
    24.803    30.364     0.200
    24.963    29.190     0.200
    24.963    31.253     0.200
    24.963    29.191     0.200
    24.963    30.898     0.200
    25.174    29.337     0.200
    25.401    26.932     0.200
    25.415    27.187     0.200
    25.732    27.962     0.200
    25.789    29.237     0.200
    26.320    28.229     0.200
    26.595    23.455     0.200
    26.876    26.567     0.200
    27.304    23.129     0.200
    28.089    22.461     0.200
    29.193    17.721     0.200
    29.910    18.166     0.200
    23.951    29.659     0.200
    16.080    41.300     0.200
    16.794    41.459     0.200
    17.617    41.248     0.200
    17.813    41.463     0.200
    18.551    40.476     0.200
    18.757    39.899     0.200
    18.775    40.157     0.200
    18.864    40.218     0.200
    18.874    41.174     0.200
    19.160    39.167     0.200
    19.659    39.064     0.200
    19.787    40.233     0.200
    19.806    39.253     0.200
    20.253    39.873     0.200
    20.539    40.210     0.200
    20.604    38.844     0.200
    20.736    37.817     0.200
    20.960    39.050     0.200
    21.008    39.291     0.200
    21.042    36.941     0.200
    21.170    38.521     0.200
    21.370    37.237     0.200
    21.454    37.934     0.200
    23.088    35.106     0.200
    23.481    37.255     0.200
    23.812    32.690     0.200
    24.243    35.416     0.200
    27.523    25.983     0.200
    14.744    40.944     0.200
    14.859    40.743     0.200
    15.285    39.711     0.200
    15.475    39.448     0.200
    16.883    43.427     0.200
    18.412    38.535     0.200
    18.819    38.710     0.200
    19.452    38.620     0.200
    19.547    38.453     0.200
    19.537    39.044     0.200
    19.600    38.624     0.200
    19.787    36.858     0.200
    20.176    37.046     0.200
    20.216    36.821     0.200
    20.510    38.487     0.200
    20.712    36.966     0.200
    20.769    36.802     0.200
    20.758    36.147     0.200
    21.195    36.075     0.200
    21.264    37.846     0.200
    21.903    35.719     0.200
    22.183    36.232     0.200
    22.385    34.433     0.200
    22.627    34.331     0.200
    23.249    33.636     0.200
    23.263    33.963     0.200
    23.490    33.002     0.200
    24.010    35.770     0.200
    24.441    31.761     0.200
    24.413    34.285     0.200
    24.619    30.952     0.200
    24.769    29.711     0.200
    25.029    31.227     0.200
    15.256    41.386     0.200
    24.616    34.077     0.200
    25.484    32.474     0.200
    15.442    38.839     0.200
    16.051    40.514     0.200
    16.020    41.441     0.200
    16.784    41.097     0.200
    16.784    40.863     0.200
    17.179    42.238     0.200
    17.656    41.059     0.200
    17.859    39.379     0.200
    17.771    41.284     0.200
    17.906    42.115     0.200
    18.183    41.284     0.200
    18.378    37.990     0.200
    18.378    37.869     0.200
    18.378    38.740     0.200
    18.289    41.330     0.200
    18.313    41.130     0.200
    18.339    40.706     0.200
    18.535    40.858     0.200
    18.585    40.312     0.200
    18.631    41.072     0.200
    18.644    41.364     0.200
    18.770    38.834     0.200
    18.703    39.289     0.200
    18.945    40.149     0.200
    19.138    40.768     0.200
    19.189    39.299     0.200
    19.186    41.212     0.200
    19.196    40.375     0.200
    19.203    40.055     0.200
    19.203    40.371     0.200
    19.203    39.953     0.200
    19.203    41.414     0.200
    19.255    39.727     0.200
    19.348    40.096     0.200
    19.348    40.240     0.200
    19.564    37.918     0.200
    19.564    37.668     0.200
    19.569    38.489     0.200
    19.588    38.815     0.200
    19.603    40.123     0.200
    19.745    36.418     0.200
    19.674    40.501     0.200
    19.701    40.131     0.200
    19.945    40.877     0.200
    19.957    40.250     0.200
    20.144    37.577     0.200
    20.212    37.397     0.200
    20.075    39.608     0.200
    20.169    38.748     0.200
    20.382    35.898     0.200
    20.316    39.020     0.200
    20.333    39.250     0.200
    20.352    39.587     0.200
    20.453    39.911     0.200
    20.629    37.900     0.200
    20.628    38.679     0.200
    20.668    37.384     0.200
    20.729    36.607     0.200
    20.769    36.303     0.200
    20.769    36.772     0.200
    20.684    40.219     0.200
    20.726    40.384     0.200
    20.742    39.817     0.200
    20.894    39.193     0.200
    20.994    38.928     0.200
    21.224    35.909     0.200
    21.208    38.468     0.200
    21.276    38.338     0.200
    21.313    38.567     0.200
    21.492    37.043     0.200
    21.492    38.507     0.200
    21.621    37.641     0.200
    21.639    38.354     0.200
    21.666    38.104     0.200
    21.733    39.077     0.200
    21.837    37.832     0.200
    22.166    34.256     0.200
    22.035    37.482     0.200
    22.140    37.582     0.200
    22.380    35.288     0.200
    22.380    36.179     0.200
    22.218    36.781     0.200
    22.349    34.862     0.200
    22.349    34.300     0.200
    22.349    34.603     0.200
    22.297    37.763     0.200
    22.446    33.674     0.200
    22.446    34.670     0.200
    22.302    37.376     0.200
    22.439    37.312     0.200
    22.625    34.309     0.200
    22.580    34.646     0.200
    22.606    35.988     0.200
    22.723    34.501     0.200
    22.616    37.247     0.200
    22.880    33.766     0.200
    22.769    37.569     0.200
    22.818    37.293     0.200
    23.116    33.566     0.200
    23.198    33.339     0.200
    23.098    36.696     0.200
    23.245    33.355     0.200
    23.333    32.807     0.200
    23.333    31.953     0.200
    23.333    33.557     0.200
    23.268    37.145     0.200
    23.268    35.178     0.200
    23.473    33.144     0.200
    23.447    33.302     0.200
    23.520    36.304     0.200
    23.895    31.767     0.200
    23.887    35.219     0.200
    23.887    35.350     0.200
    24.311    31.934     0.200
    24.241    33.333     0.200
    24.292    33.415     0.200
    24.400    32.812     0.200
    24.400    32.245     0.200
    24.495    31.056     0.200
    24.625    32.635     0.200
    24.826    30.325     0.200
    24.826    29.399     0.200
    24.826    30.096     0.200
    24.926    30.515     0.200
    24.926    31.342     0.200
    24.926    30.873     0.200
    24.926    31.322     0.200
    25.066    30.861     0.200
    25.066    29.254     0.200
    25.052    31.845     0.200
    25.206    28.906     0.200
    25.206    29.057     0.200
    25.206    29.178     0.200
    25.268    28.689     0.200
    25.268    28.124     0.200
    25.500    28.389     0.200
    25.771    27.042     0.200
    25.730    29.711     0.200
    25.730    29.301     0.200
    25.974    27.650     0.200
    25.974    28.310     0.200
    26.087    25.740     0.200
    26.311    25.261     0.200
    26.337    28.997     0.200
    26.619    23.954     0.200
    26.688    26.742     0.200
    26.931    24.137     0.200
    26.931    24.602     0.200
    26.830    27.350     0.200
    26.830    27.500     0.200
    26.932    26.107     0.200
    26.999    23.584     0.200
    27.095    23.478     0.200
    27.142    23.615     0.200
    27.194    24.202     0.200
    27.171    24.510     0.200
    27.310    26.319     0.200
    27.475    22.435     0.200
    27.581    25.333     0.200
    27.579    22.123     0.200
    27.579    22.914     0.200
    27.919    21.243     0.200
    28.045    19.800     0.200
    28.099    19.609     0.200
    28.035    24.538     0.200
    28.050    23.535     0.200
    28.245    19.721     0.200
    28.594    19.145     0.200
    29.035    16.418     0.200
    29.212    18.229     0.200
    29.100    20.821     0.200
    29.246    20.126     0.200
    29.443    16.581     0.200
    29.731    18.118     0.200
    29.736    18.703     0.200
    29.859    18.266     0.200
    29.994    18.257     0.200
    15.489    41.712     0.200
    19.231    37.020     0.200
    16.810    42.861     0.200
    18.448    38.594     0.200
    18.833    37.905     0.200
    18.937    39.803     0.200
    19.173    40.199     0.200
    19.369    39.547     0.200
    19.475    40.352     0.200
    19.552    37.500     0.200
    19.640    37.885     0.200
    19.789    37.540     0.200
    20.087    38.230     0.200
    20.396    38.053     0.200
    20.718    37.242     0.200
    21.227    35.968     0.200
    21.309    35.229     0.200
    21.258    38.283     0.200
    22.419    34.183     0.200
    22.523    34.114     0.200
    23.881    33.680     0.200
    23.881    36.425     0.200
    24.123    31.104     0.200
    24.949    32.483     0.200
    16.513    39.713     0.200
    16.654    41.915     0.200
    18.470    39.183     0.200
    18.719    40.592     0.200
    18.732    38.587     0.200
    19.003    39.552     0.200
    19.042    40.779     0.200
    19.285    41.340     0.200
    19.480    37.680     0.200
    20.120    37.192     0.200
    20.140    38.634     0.200
    20.227    37.556     0.200
    20.367    37.229     0.200
    20.446    37.947     0.200
    20.560    36.617     0.200
    20.566    36.578     0.200
    20.631    39.309     0.200
    21.259    37.033     0.200
    22.205    35.651     0.200
    22.433    34.672     0.200
    22.488    34.359     0.200
    22.620    33.176     0.200
    22.620    33.059     0.200
    23.435    36.204     0.200
    23.435    37.297     0.200
    23.467    32.606     0.200
    23.618    32.318     0.200
    23.618    32.553     0.200
    23.910    35.042     0.200
    24.633    34.227     0.200
    24.988    30.122     0.200
    24.988    30.255     0.200
    25.112    30.985     0.200
    25.362    30.115     0.200
    25.531    29.026     0.200
    26.473    29.278     0.200
    24.689    31.118     0.200
    24.760    32.998     0.200
    25.459    29.429     0.200
    24.786    28.928     0.200
    23.880    35.486     0.200
    24.908    32.099     0.200
    17.118    40.849     0.200
    17.118    40.689     0.200
    17.505    42.857     0.200
    17.505    40.277     0.200
    18.392    39.117     0.200
    18.999    37.991     0.200
    19.195    39.507     0.200
    19.701    37.735     0.200
    19.701    39.075     0.200
    19.709    39.352     0.200
    20.148    36.935     0.200
    20.632    37.233     0.200
    21.659    39.532     0.200
    21.792    36.510     0.200
    22.106    37.521     0.200
    22.379    34.337     0.200
    22.379    34.126     0.200
    22.705    36.480     0.200
    23.157    33.505     0.200
    23.672    34.148     0.200
    24.072    33.411     0.200
    24.359    35.173     0.200
    24.621    32.580     0.200
    25.087    30.327     0.200
    25.274    30.628     0.200
    25.274    30.184     0.200
    26.132    27.741     0.200
    26.132    28.152     0.200
    26.129    26.671     0.200
    26.302    26.684     0.200
    27.230    24.624     0.200
    27.437    23.263     0.200
    29.940    18.516     0.200
    23.966    35.607     0.200
    25.014    30.685     0.200
    15.388    36.561     0.200
    15.388    37.213     0.200
    16.070    38.672     0.200
    16.662    37.729     0.200
    16.662    38.096     0.200
    16.662    38.940     0.200
    17.505    38.979     0.200
    17.872    36.245     0.200
    18.143    35.677     0.200
    18.143    36.068     0.200
    18.552    36.019     0.200
    19.419    37.299     0.200
    19.331    35.532     0.200
    19.518    35.115     0.200
    19.955    34.668     0.200
    20.322    34.622     0.200
    20.511    34.348     0.200
    20.642    35.556     0.200
    21.265    36.376     0.200
    21.354    35.344     0.200
    21.475    35.938     0.200
    21.435    32.604     0.200
    22.116    32.205     0.200
    22.197    31.800     0.200
    22.197    32.179     0.200
    22.401    31.802     0.200
    22.989    31.358     0.200
    23.072    29.845     0.200
    23.188    34.222     0.200
    23.651    29.945     0.200
    23.858    32.596     0.200
    24.146    30.337     0.200
    24.238    28.275     0.200
    24.238    28.693     0.200
    24.363    28.330     0.200
    24.498    28.949     0.200
    24.579    27.472     0.200
    24.579    27.785     0.200
    24.813    28.044     0.200
    24.813    27.900     0.200
    24.853    26.690     0.200
    24.949    26.986     0.200
    25.003    26.426     0.200
    25.578    27.818     0.200
    26.747    21.446     0.200
    27.673    19.047     0.200
    28.034    18.349     0.200
    13.856    37.490     0.200
    14.382    36.665     0.200
    14.416    37.867     0.200
    14.483    37.965     0.200
    14.627    37.040     0.200
    14.873    38.899     0.200
    16.557    40.603     0.200
    16.698    38.571     0.200
    16.698    38.629     0.200
    17.042    38.937     0.200
    17.063    38.343     0.200
    17.045    37.739     0.200
    17.195    38.726     0.200
    17.307    39.003     0.200
    17.377    38.426     0.200
    17.432    38.466     0.200
    17.523    38.355     0.200
    17.703    37.804     0.200
    17.791    37.670     0.200
    18.223    36.834     0.200
    18.221    36.808     0.200
    18.293    37.456     0.200
    18.531    37.744     0.200
    19.312    36.909     0.200
    19.487    36.526     0.200
    19.887    36.295     0.200
    20.092    37.206     0.200
    20.333    36.023     0.200
    20.391    36.757     0.200
    20.415    36.356     0.200
    20.473    35.742     0.200
    20.529    35.533     0.200
    20.900    35.640     0.200
    21.884    34.671     0.200
    22.091    33.879     0.200
    23.721    34.108     0.200
    24.254    30.528     0.200
    24.385    29.939     0.200
    24.574    29.615     0.200
    24.704    30.442     0.200
    24.704    30.662     0.200
    24.704    31.091     0.200
    24.872    28.365     0.200
    25.109    27.974     0.200
    14.528    38.170     0.200
    14.793    39.002     0.200
    14.814    38.822     0.200
    14.899    38.268     0.200
    14.974    37.909     0.200
    15.539    40.930     0.200
    15.686    38.778     0.200
    15.995    39.574     0.200
    16.167    39.834     0.200
    16.204    39.966     0.200
    16.551    39.809     0.200
    16.599    39.814     0.200
    17.065    41.053     0.200
    17.065    40.424     0.200
    17.067    40.394     0.200
    17.067    40.151     0.200
    17.068    40.156     0.200
    17.102    38.765     0.200
    18.205    37.113     0.200
    18.518    36.177     0.200
    18.535    37.183     0.200
    18.826    37.246     0.200
    19.293    36.572     0.200
    19.427    35.465     0.200
    19.693    37.959     0.200
    19.747    35.280     0.200
    19.915    37.521     0.200
    20.590    37.618     0.200
    20.630    35.757     0.200
    20.699    36.936     0.200
    20.666    37.993     0.200
    20.767    36.709     0.200
    20.912    34.384     0.200
    21.185    39.334     0.200
    21.694    35.362     0.200
    22.423    35.271     0.200
    23.475    35.237     0.200
    23.716    33.676     0.200
    23.714    33.048     0.200
    23.791    29.696     0.200
    23.941    33.613     0.200
    24.187    27.943     0.200
    24.319    27.975     0.200
    24.315    31.577     0.200
    24.409    32.229     0.200
    24.520    32.538     0.200
    24.616    29.266     0.200
    25.069    30.007     0.200
    25.237    27.215     0.200
    25.237    28.676     0.200
    25.237    28.164     0.200
    25.589    27.323     0.200
    25.870    27.381     0.200
    26.796    21.732     0.200
    27.266    23.149     0.200
    27.866    22.091     0.200
    29.227    16.994     0.200
    29.438    20.721     0.200
    15.315    35.750     0.200
    15.315    36.269     0.200
    16.447    37.804     0.200
    17.677    35.132     0.200
    18.771    34.563     0.200
    19.122    33.596     0.200
    19.224    33.448     0.200
    19.224    35.095     0.200
    19.363    33.477     0.200
    20.390    34.881     0.200
    20.389    34.360     0.200
    20.426    33.360     0.200
    20.929    32.835     0.200
    21.101    33.928     0.200
    21.181    32.570     0.200
    21.298    32.293     0.200
    21.517    34.749     0.200
    21.579    32.146     0.200
    21.579    32.715     0.200
    21.652    31.205     0.200
    21.696    30.459     0.200
    21.696    30.334     0.200
    21.847    31.076     0.200
    22.039    31.781     0.200
    22.540    29.356     0.200
    23.056    31.562     0.200
    23.833    29.819     0.200
    23.546    32.243     0.200
    23.546    33.063     0.200
    23.982    28.926     0.200
    24.082    27.193     0.200
    24.082    27.011     0.200
    24.431    26.687     0.200
    24.611    26.366     0.200
    25.293    24.874     0.200
    25.293    25.149     0.200
    25.402    23.859     0.200
    26.609    21.925     0.200
    27.187    20.677     0.200
    29.966    11.303     0.200
    14.961    40.232     0.200
    14.994    40.654     0.200
    15.067    39.228     0.200
    15.217    40.460     0.200
    15.455    39.821     0.200
    15.859    39.812     0.200
    15.980    40.289     0.200
    16.101    41.175     0.200
    16.287    41.968     0.200
    16.793    39.579     0.200
    17.042    40.428     0.200
    17.168    41.388     0.200
    17.168    39.943     0.200
    17.168    41.622     0.200
    17.741    40.766     0.200
    18.090    40.640     0.200
    18.324    37.336     0.200
    18.813    38.841     0.200
    18.808    36.961     0.200
    19.095    36.966     0.200
    19.827    39.437     0.200
    20.895    36.354     0.200
    21.218    34.842     0.200
    21.286    34.563     0.200
    21.431    35.913     0.200
    21.481    36.380     0.200
    21.631    35.169     0.200
    21.827    36.813     0.200
    21.827    38.743     0.200
    21.920    35.425     0.200
    21.920    36.441     0.200
    22.285    32.997     0.200
    22.285    32.708     0.200
    22.301    34.038     0.200
    22.301    34.733     0.200
    22.301    34.522     0.200
    22.534    35.857     0.200
    22.570    33.939     0.200
    22.916    32.404     0.200
    22.927    35.767     0.200
    23.031    31.500     0.200
    23.750    34.529     0.200
    23.786    31.810     0.200
    23.655    37.098     0.200
    23.655    38.363     0.200
    24.350    29.947     0.200
    24.349    30.192     0.200
    24.471    33.798     0.200
    24.471    32.923     0.200
    24.478    33.915     0.200
    24.679    28.714     0.200
    24.679    29.120     0.200
    24.679    29.667     0.200
    24.689    31.373     0.200
    24.971    28.299     0.200
    24.977    29.559     0.200
    25.326    30.014     0.200
    25.329    29.438     0.200
    25.329    28.555     0.200
    25.479    28.307     0.200
    25.662    28.647     0.200
    25.855    27.130     0.200
    26.021    26.565     0.200
    26.021    27.894     0.200
    26.021    28.300     0.200
    26.113    25.855     0.200
    26.113    26.855     0.200
    26.113    27.831     0.200
    26.381    25.245     0.200
    26.857    26.866     0.200
    26.943    26.867     0.200
    27.320    21.005     0.200
    27.306    24.805     0.200
    27.853    23.695     0.200
    28.579    17.719     0.200
    29.660    18.707     0.200
    29.660    20.863     0.200
    23.499    38.248     0.200
    24.065    37.789     0.200
    18.919    37.543     0.200
    19.668    38.412     0.200
    20.247    37.856     0.200
    20.782    36.100     0.200
    20.822    37.379     0.200
    23.269    33.801     0.200
    23.533    33.918     0.200
    24.117    32.423     0.200
    24.232    35.751     0.200
    24.232    34.769     0.200
    25.219    31.318     0.200
    25.219    31.697     0.200
    15.197    37.522     0.200
    15.779    37.645     0.200
    16.019    39.179     0.200
    16.442    37.454     0.200
    16.886    38.333     0.200
    16.889    38.714     0.200
    16.889    38.214     0.200
    16.889    40.195     0.200
    17.592    38.452     0.200
    17.610    36.595     0.200
    17.668    36.639     0.200
    17.779    36.021     0.200
    18.186    35.601     0.200
    18.253    36.174     0.200
    18.654    36.084     0.200
    18.683    35.526     0.200
    18.685    35.420     0.200
    18.729    36.694     0.200
    18.882    36.927     0.200
    18.894    35.630     0.200
    19.163    34.572     0.200
    19.357    34.294     0.200
    19.362    35.061     0.200
    19.487    36.594     0.200
    19.685    38.964     0.200
    19.799    34.631     0.200
    19.920    33.860     0.200
    19.937    34.572     0.200
    20.143    33.869     0.200
    20.512    35.323     0.200
    20.530    34.842     0.200
    20.582    36.264     0.200
    20.837    35.376     0.200
    20.846    33.560     0.200
    20.912    33.015     0.200
    21.131    36.626     0.200
    21.273    33.198     0.200
    21.454    33.142     0.200
    21.529    34.315     0.200
    21.529    36.645     0.200
    21.599    35.965     0.200
    21.584    33.259     0.200
    21.584    34.519     0.200
    21.906    31.514     0.200
    21.906    31.143     0.200
    21.906    31.344     0.200
    21.925    32.361     0.200
    21.925    31.742     0.200
    22.193    32.237     0.200
    22.232    34.175     0.200
    22.544    31.267     0.200
    22.662    30.791     0.200
    22.683    32.008     0.200
    22.786    34.414     0.200
    23.515    31.904     0.200
    23.515    32.873     0.200
    23.659    31.940     0.200
    23.659    32.811     0.200
    23.396    35.093     0.200
    24.175    31.102     0.200
    24.260    30.358     0.200
    24.297    31.290     0.200
    24.297    30.889     0.200
    24.300    27.845     0.200
    24.300    27.486     0.200
    24.436    28.895     0.200
    24.601    26.646     0.200
    24.943    28.199     0.200
    25.055    27.044     0.200
    25.055    26.695     0.200
    25.708    25.422     0.200
    25.708    25.852     0.200
    25.708    26.381     0.200
    25.761    24.456     0.200
    25.761    25.156     0.200
    25.870    27.161     0.200
    25.979    25.360     0.200
    26.060    25.769     0.200
    26.345    25.238     0.200
    26.937    23.418     0.200
    27.066    22.424     0.200
    27.172    22.283     0.200
    28.201    19.224     0.200
    29.515    17.135     0.200
    13.903    38.568     0.200
    15.622    37.285     0.200
    15.622    37.007     0.200
    15.622    37.847     0.200
    16.833    38.897     0.200
    16.833    40.518     0.200
    17.733    38.551     0.200
    17.973    38.097     0.200
    18.056    35.815     0.200
    18.129    36.823     0.200
    18.129    35.803     0.200
    18.227    35.841     0.200
    18.270    34.989     0.200
    18.312    35.737     0.200
    18.403    34.754     0.200
    18.519    35.428     0.200
    18.638    35.071     0.200
    18.800    35.659     0.200
    18.850    35.620     0.200
    19.106    35.583     0.200
    19.108    36.010     0.200
    19.321    35.031     0.200
    19.510    34.305     0.200
    19.764    35.112     0.200
    19.868    35.008     0.200
    20.554    35.174     0.200
    20.575    35.545     0.200
    21.003    33.371     0.200
    21.152    32.853     0.200
    21.326    33.073     0.200
    22.069    33.017     0.200
    22.104    32.572     0.200
    22.104    32.150     0.200
    22.143    34.466     0.200
    22.137    31.118     0.200
    22.137    31.427     0.200
    22.137    32.216     0.200
    22.713    34.599     0.200
    22.659    31.383     0.200
    22.742    33.751     0.200
    22.759    30.859     0.200
    22.952    30.794     0.200
    23.092    30.945     0.200
    23.166    30.842     0.200
    23.398    33.245     0.200
    23.539    29.701     0.200
    23.632    30.178     0.200
    24.098    32.836     0.200
    24.110    30.949     0.200
    24.110    31.726     0.200
    23.784    34.562     0.200
    23.784    33.820     0.200
    24.143    28.190     0.200
    24.256    28.650     0.200
    24.419    29.134     0.200
    24.505    30.647     0.200
    24.525    27.519     0.200
    24.525    27.320     0.200
    24.525    27.949     0.200
    24.837    28.744     0.200
    24.861    26.316     0.200
    24.861    26.098     0.200
    24.991    29.817     0.200
    24.991    27.664     0.200
    24.991    27.836     0.200
    25.817    24.022     0.200
    25.847    25.451     0.200
    25.847    24.412     0.200
    25.847    27.021     0.200
    25.973    25.889     0.200
    26.305    22.251     0.200
    26.955    23.477     0.200
    27.843    18.695     0.200
    28.257    17.497     0.200
    24.752    25.888     0.200
    25.176    26.843     0.200
    24.046    34.489     0.200
    25.045    31.902     0.200
    14.152    39.813     0.200
    14.226    40.366     0.200
    14.236    42.736     0.200
    14.466    40.289     0.200
    15.915    39.733     0.200
    16.833    41.083     0.200
    17.920    40.290     0.200
    18.345    38.155     0.200
    19.224    39.143     0.200
    19.303    39.336     0.200
    19.405    39.889     0.200
    19.489    38.889     0.200
    19.423    38.785     0.200
    19.423    39.992     0.200
    19.482    36.109     0.200
    19.533    37.475     0.200
    19.484    38.000     0.200
    19.540    39.547     0.200
    19.636    39.501     0.200
    19.701    36.788     0.200
    20.082    38.570     0.200
    20.149    36.958     0.200
    20.164    36.766     0.200
    20.204    36.241     0.200
    20.229    36.595     0.200
    20.256    39.814     0.200
    20.215    40.505     0.200
    20.291    37.922     0.200
    20.291    37.543     0.200
    20.311    38.195     0.200
    20.393    39.616     0.200
    20.448    35.274     0.200
    20.368    37.293     0.200
    20.510    36.113     0.200
    20.488    39.571     0.200
    20.494    38.912     0.200
    20.467    39.390     0.200
    20.504    39.125     0.200
    20.434    39.034     0.200
    20.530    39.307     0.200
    20.552    37.160     0.200
    20.598    39.576     0.200
    20.592    36.303     0.200
    20.608    37.498     0.200
    20.691    35.170     0.200
    20.655    35.962     0.200
    20.666    37.014     0.200
    20.643    37.754     0.200
    20.672    38.318     0.200
    20.685    38.295     0.200
    20.919    38.040     0.200
    21.011    36.072     0.200
    21.128    34.646     0.200
    21.143    38.492     0.200
    21.146    40.451     0.200
    21.245    37.442     0.200
    21.340    40.309     0.200
    21.418    34.507     0.200
    21.387    37.165     0.200
    21.312    38.894     0.200
    21.330    37.799     0.200
    21.415    38.732     0.200
    21.374    38.631     0.200
    21.407    38.008     0.200
    21.497    41.177     0.200
    21.532    35.987     0.200
    21.532    37.774     0.200
    21.613    34.423     0.200
    21.605    35.307     0.200
    21.613    36.063     0.200
    21.613    37.828     0.200
    21.706    39.798     0.200
    21.706    37.751     0.200
    21.774    37.655     0.200
    21.972    34.665     0.200
    21.889    39.184     0.200
    21.955    37.012     0.200
    21.969    40.625     0.200
    21.979    41.271     0.200
    21.999    39.336     0.200
    21.985    36.961     0.200
    22.117    34.110     0.200
    22.085    38.421     0.200
    22.085    39.300     0.200
    22.085    39.128     0.200
    22.165    37.496     0.200
    22.176    36.425     0.200
    22.280    34.905     0.200
    22.280    34.725     0.200
    22.280    33.799     0.200
    22.280    35.155     0.200
    22.259    36.256     0.200
    22.259    37.697     0.200
    22.198    42.007     0.200
    22.208    39.809     0.200
    22.318    34.573     0.200
    22.318    33.721     0.200
    22.306    41.929     0.200
    22.395    33.410     0.200
    22.395    33.231     0.200
    22.395    33.813     0.200
    22.459    41.036     0.200
    22.403    37.503     0.200
    22.502    40.000     0.200
    22.502    41.390     0.200
    22.530    38.984     0.200
    22.550    41.312     0.200
    22.667    34.139     0.200
    22.647    35.320     0.200
    22.820    34.307     0.200
    22.894    33.445     0.200
    22.844    39.782     0.200
    22.755    39.153     0.200
    22.897    36.112     0.200
    23.059    32.519     0.200
    22.990    36.046     0.200
    23.099    41.123     0.200
    23.095    35.395     0.200
    23.338    36.124     0.200
    23.338    34.842     0.200
    23.377    40.232     0.200
    23.415    35.940     0.200
    23.443    35.817     0.200
    23.557    34.640     0.200
    23.631    39.256     0.200
    23.703    40.055     0.200
    23.801    38.305     0.200
    23.839    35.211     0.200
    23.839    35.356     0.200
    23.845    38.150     0.200
    23.913    37.760     0.200
    23.928    37.240     0.200
    23.910    34.228     0.200
    23.965    35.191     0.200
    23.978    35.362     0.200
    23.978    33.608     0.200
    23.985    35.157     0.200
    24.156    36.761     0.200
    24.105    38.555     0.200
    24.300    33.980     0.200
    24.319    30.407     0.200
    24.311    34.848     0.200
    24.304    33.576     0.200
    24.362    34.666     0.200
    24.421    33.209     0.200
    24.421    33.619     0.200
    24.421    32.869     0.200
    24.156    36.108     0.200
    24.448    36.664     0.200
    24.552    29.701     0.200
    24.541    36.296     0.200
    24.596    35.085     0.200
    24.638    35.118     0.200
    24.667    33.494     0.200
    24.778    29.655     0.200
    24.778    29.284     0.200
    24.778    29.507     0.200
    24.833    29.869     0.200
    24.819    32.567     0.200
    24.849    31.980     0.200
    24.812    32.809     0.200
    24.837    37.036     0.200
    24.871    35.561     0.200
    24.865    34.179     0.200
    24.930    34.877     0.200
    24.977    31.185     0.200
    24.980    30.499     0.200
    24.980    31.249     0.200
    25.008    35.064     0.200
    25.143    28.269     0.200
    25.120    31.682     0.200
    25.113    32.853     0.200
    25.183    32.069     0.200
    25.291    30.264     0.200
    25.405    29.031     0.200
    25.405    30.992     0.200
    25.454    30.618     0.200
    25.740    28.780     0.200
    25.762    28.684     0.200
    25.762    27.762     0.200
    25.762    29.621     0.200
    25.888    29.848     0.200
    25.883    29.129     0.200
    25.988    29.190     0.200
    25.937    30.324     0.200
    25.977    25.999     0.200
    26.080    28.704     0.200
    26.358    29.269     0.200
    26.405    26.931     0.200
    26.443    28.332     0.200
    26.669    26.607     0.200
    26.908    26.948     0.200
    26.796    27.072     0.200
    26.861    27.266     0.200
    26.899    26.485     0.200
    27.025    23.365     0.200
    27.006    26.097     0.200
    27.072    26.297     0.200
    27.317    22.709     0.200
    27.308    25.391     0.200
    27.454    25.534     0.200
    27.393    25.208     0.200
    27.651    23.515     0.200
    27.731    25.746     0.200
    27.917    25.874     0.200
    27.908    27.252     0.200
    27.994    21.631     0.200
    27.936    22.244     0.200
    28.074    21.817     0.200
    28.095    22.881     0.200
    28.427    20.975     0.200
    28.447    23.691     0.200
    28.620    24.766     0.200
    28.776    18.117     0.200
    28.686    25.002     0.200
    28.924    22.122     0.200
    28.924    23.640     0.200
    29.055    24.491     0.200
    29.351    16.697     0.200
    29.324    21.751     0.200
    29.312    21.997     0.200
    29.588    21.091     0.200
    29.588    22.878     0.200
    29.632    16.999     0.200
    29.790    14.228     0.200
    29.918    20.116     0.200
    15.151    40.191     0.200
    15.157    40.199     0.200
    15.157    40.011     0.200
    15.195    41.691     0.200
    15.684    40.595     0.200
    15.700    40.956     0.200
    15.755    40.931     0.200
    15.906    40.476     0.200
    16.500    42.106     0.200
    16.500    41.387     0.200
    16.602    42.261     0.200
    16.602    41.519     0.200
    16.822    41.581     0.200
    17.571    41.858     0.200
    17.761    41.078     0.200
    17.955    41.253     0.200
    18.467    38.959     0.200
    18.506    40.642     0.200
    18.506    42.072     0.200
    18.857    39.631     0.200
    18.854    42.860     0.200
    19.427    39.166     0.200
    19.633    39.461     0.200
    19.795    39.144     0.200
    19.978    38.649     0.200
    19.978    39.321     0.200
    20.005    39.535     0.200
    20.157    42.020     0.200
    20.335    39.203     0.200
    20.990    40.384     0.200
    21.056    41.779     0.200
    21.085    38.887     0.200
    21.085    41.457     0.200
    21.119    41.405     0.200
    21.178    40.191     0.200
    21.339    38.237     0.200
    21.922    40.137     0.200
    22.116    38.848     0.200
    22.433    35.145     0.200
    22.433    34.966     0.200
    22.483    35.077     0.200
    22.483    36.147     0.200
    22.596    33.991     0.200
    22.596    33.632     0.200
    22.665    39.564     0.200
    22.665    39.877     0.200
    22.665    40.236     0.200
    22.698    34.221     0.200
    22.698    36.385     0.200
    23.017    38.551     0.200
    23.032    37.992     0.200
    23.512    34.815     0.200
    23.553    37.578     0.200
    23.567    37.466     0.200
    23.574    37.940     0.200
    23.890    34.069     0.200
    23.935    36.711     0.200
    24.014    35.453     0.200
    24.419    35.977     0.200
    24.725    32.705     0.200
    24.728    34.018     0.200
    24.728    31.682     0.200
    24.728    33.370     0.200
    24.855    29.774     0.200
    24.967    30.301     0.200
    24.967    31.262     0.200
    24.975    32.905     0.200
    24.975    32.280     0.200
    25.016    33.055     0.200
    24.683    36.777     0.200
    25.088    30.703     0.200
    25.248    34.094     0.200
    25.272    30.551     0.200
    25.393    29.223     0.200
    25.393    29.364     0.200
    25.603    30.193     0.200
    25.603    29.951     0.200
    25.715    32.921     0.200
    25.943    28.295     0.200
    25.944    29.815     0.200
    26.447    29.945     0.200
    26.583    29.242     0.200
    26.769    28.664     0.200
    27.018    27.442     0.200
    27.191    27.880     0.200
    27.365    25.031     0.200
    27.841    25.082     0.200
    28.635    22.567     0.200
    29.333    18.824     0.200
    29.509    21.682     0.200
    29.629    24.967     0.200
    29.898    17.541     0.200
    29.898    18.650     0.200
    29.924    18.104     0.200
    24.122    34.877     0.200
    25.125    32.212     0.200
    24.167    35.062     0.200
    25.157    31.258     0.200
    16.945    40.467     0.200
    16.945    39.899     0.200
    16.945    41.698     0.200
    17.769    39.866     0.200
    17.770    40.024     0.200
    17.909    39.856     0.200
    18.566    39.601     0.200
    18.733    39.455     0.200
    18.909    39.842     0.200
    18.914    39.483     0.200
    19.521    38.826     0.200
    19.747    39.397     0.200
    19.875    38.289     0.200
    20.592    38.190     0.200
    20.647    37.860     0.200
    20.650    37.853     0.200
    20.752    38.639     0.200
    20.772    38.187     0.200
    21.184    38.745     0.200
    22.313    36.998     0.200
    22.428    34.713     0.200
    22.699    35.807     0.200
    22.794    35.802     0.200
    22.950    35.999     0.200
    23.573    35.272     0.200
    24.108    34.930     0.200
    24.108    34.094     0.200
    24.813    29.979     0.200
    25.094    31.900     0.200
    25.094    30.250     0.200
    25.094    30.500     0.200
    25.331    30.637     0.200
    25.624    29.999     0.200
    25.863    28.724     0.200
    26.067    28.777     0.200
    26.112    28.763     0.200
    26.200    24.878     0.200
    27.526    21.112     0.200
    27.769    24.095     0.200
    28.233    22.907     0.200
    16.046    42.586     0.200
    16.658    41.181     0.200
    16.729    40.222     0.200
    16.729    40.552     0.200
    17.451    41.676     0.200
    18.200    42.679     0.200
    18.287    40.221     0.200
    18.466    37.907     0.200
    18.847    40.191     0.200
    19.053    39.886     0.200
    19.184    34.670     0.200
    19.279    39.742     0.200
    19.386    39.021     0.200
    19.474    39.490     0.200
    19.720    38.081     0.200
    19.817    38.552     0.200
    19.784    40.191     0.200
    19.784    38.507     0.200
    19.918    40.079     0.200
    19.921    40.353     0.200
    19.950    40.015     0.200
    20.188    39.252     0.200
    20.179    39.836     0.200
    20.173    36.665     0.200
    20.329    36.468     0.200
    20.348    36.822     0.200
    20.320    40.087     0.200
    20.320    40.100     0.200
    20.329    38.754     0.200
    20.468    37.263     0.200
    20.569    39.429     0.200
    20.617    39.100     0.200
    20.683    36.457     0.200
    20.652    38.868     0.200
    20.652    38.073     0.200
    20.652    39.653     0.200
    20.738    36.466     0.200
    20.698    39.383     0.200
    20.757    38.874     0.200
    20.763    39.852     0.200
    20.794    40.203     0.200
    20.864    40.077     0.200
    20.883    39.338     0.200
    20.892    37.999     0.200
    20.898    39.687     0.200
    20.954    39.914     0.200
    20.957    39.888     0.200
    20.959    40.208     0.200
    20.959    39.152     0.200
    20.960    40.207     0.200
    20.962    40.003     0.200
    21.025    34.510     0.200
    21.073    39.414     0.200
    21.279    37.705     0.200
    21.279    37.916     0.200
    21.454    37.917     0.200
    21.505    35.598     0.200
    21.505    40.711     0.200
    21.572    35.262     0.200
    21.702    37.535     0.200
    21.859    39.579     0.200
    21.902    38.199     0.200
    21.902    37.492     0.200
    21.984    38.115     0.200
    22.061    38.267     0.200
    22.248    38.555     0.200
    22.313    37.627     0.200
    22.313    36.408     0.200
    22.435    34.659     0.200
    22.435    34.229     0.200
    22.444    39.436     0.200
    22.444    38.462     0.200
    22.564    33.617     0.200
    22.564    34.187     0.200
    22.535    37.682     0.200
    22.618    35.804     0.200
    22.618    36.074     0.200
    22.889    38.650     0.200
    23.015    33.015     0.200
    23.175    36.245     0.200
    23.489    32.433     0.200
    23.739    37.050     0.200
    23.752    35.319     0.200
    23.752    36.233     0.200
    23.759    37.213     0.200
    24.161    33.989     0.200
    24.197    36.064     0.200
    24.665    33.786     0.200
    24.673    33.646     0.200
    24.719    34.318     0.200
    24.785    32.356     0.200
    24.785    33.826     0.200
    24.785    33.246     0.200
    24.508    36.468     0.200
    24.860    32.872     0.200
    24.863    31.634     0.200
    24.863    31.085     0.200
    24.863    30.765     0.200
    24.827    33.510     0.200
    24.827    33.039     0.200
    24.827    33.250     0.200
    24.940    29.844     0.200
    24.940    29.585     0.200
    24.940    30.133     0.200
    25.027    33.417     0.200
    25.159    30.851     0.200
    25.176    31.377     0.200
    25.256    28.931     0.200
    25.342    28.493     0.200
    25.331    31.957     0.200
    25.417    28.559     0.200
    25.464    30.739     0.200
    25.484    31.658     0.200
    25.547    31.800     0.200
    25.706    29.232     0.200
    25.706    28.892     0.200
    25.706    29.361     0.200
    26.001    26.700     0.200
    26.739    27.787     0.200
    26.723    29.031     0.200
    27.193    26.547     0.200
    27.264    26.519     0.200
    28.098    24.263     0.200
    28.098    26.183     0.200
    28.282    24.836     0.200
    28.556    19.881     0.200
    28.983    24.249     0.200
    29.290    21.974     0.200
    29.694    20.555     0.200
    29.950    20.118     0.200
    29.950    21.487     0.200
    29.950    18.868     0.200
    15.701    40.878     0.200
    16.966    40.216     0.200
    16.989    42.087     0.200
    16.989    41.943     0.200
    16.989    42.451     0.200
    17.788    40.141     0.200
    17.820    40.153     0.200
    17.920    40.020     0.200
    19.254    39.048     0.200
    19.396    39.186     0.200
    19.396    38.127     0.200
    19.489    39.990     0.200
    19.782    38.326     0.200
    20.174    38.002     0.200
    20.174    38.782     0.200
    20.517    37.706     0.200
    20.560    38.225     0.200
    21.680    39.372     0.200
    22.387    35.592     0.200
    22.387    35.713     0.200
    22.436    35.283     0.200
    22.436    35.073     0.200
    22.442    36.064     0.200
    23.263    33.845     0.200
    23.508    36.964     0.200
    23.853    32.596     0.200
    24.148    36.502     0.200
    24.303    36.107     0.200
    24.161    36.400     0.200
    24.168    36.571     0.200
    24.470    34.395     0.200
    24.823    31.162     0.200
    24.823    31.455     0.200
    24.814    32.291     0.200
    25.061    30.477     0.200
    25.167    30.151     0.200
    25.136    33.470     0.200
    25.139    31.340     0.200
    25.139    31.578     0.200
    25.139    32.238     0.200
    25.298    30.908     0.200
    25.454    31.551     0.200
    25.677    31.472     0.200
    25.902    28.793     0.200
    26.107    27.451     0.200
    27.069    28.163     0.200
    27.323    25.890     0.200
    27.370    24.742     0.200
    27.377    25.702     0.200
    27.389    25.423     0.200
    27.376    26.523     0.200
    27.528    23.619     0.200
    27.567    23.511     0.200
    27.475    25.346     0.200
    27.547    25.495     0.200
    27.571    26.319     0.200
    27.740    23.275     0.200
    27.779    22.889     0.200
    27.816    25.022     0.200
    16.513    41.986     0.200
    19.575    38.442     0.200
    23.498    37.568     0.200
    23.498    34.584     0.200
    24.640    33.577     0.200
    25.230    30.579     0.200
    15.548    39.293     0.200
    15.872    40.645     0.200
    16.340    41.767     0.200
    16.848    40.082     0.200
    16.848    41.238     0.200
    17.270    39.425     0.200
    17.318    39.795     0.200
    17.461    40.226     0.200
    17.688    42.658     0.200
    17.884    39.620     0.200
    17.877    40.493     0.200
    18.032    39.593     0.200
    18.216    38.480     0.200
    18.333    38.253     0.200
    18.333    37.901     0.200
    18.381    38.748     0.200
    18.474    37.950     0.200
    18.559    39.197     0.200
    18.922    37.084     0.200
    19.069    38.580     0.200
    19.381    38.876     0.200
    19.422    38.624     0.200
    19.439    38.026     0.200
    19.439    37.791     0.200
    19.520    37.070     0.200
    20.054    37.708     0.200
    20.097    36.398     0.200
    20.490    37.783     0.200
    20.610    38.079     0.200
    20.846    38.167     0.200
    21.118    35.448     0.200
    21.194    37.942     0.200
    21.544    37.832     0.200
    21.544    36.262     0.200
    21.861    35.307     0.200
    21.974    38.426     0.200
    21.954    35.823     0.200
    22.014    37.101     0.200
    22.042    38.343     0.200
    22.247    35.941     0.200
    22.247    35.558     0.200
    22.307    34.369     0.200
    22.307    33.884     0.200
    22.378    34.667     0.200
    22.378    34.331     0.200
    22.378    33.503     0.200
    22.879    34.185     0.200
    23.102    33.219     0.200
    23.335    35.474     0.200
    23.359    34.783     0.200
    23.674    35.366     0.200
    23.861    32.248     0.200
    23.994    33.947     0.200
    24.007    35.239     0.200
    24.007    34.380     0.200
    24.323    33.173     0.200
    24.379    32.532     0.200
    24.408    30.313     0.200
    24.116    37.141     0.200
    24.116    36.008     0.200
    24.761    30.227     0.200
    24.761    29.828     0.200
    24.761    29.187     0.200
    24.993    29.480     0.200
    24.996    30.697     0.200
    24.996    29.908     0.200
    24.996    30.399     0.200
    24.996    29.252     0.200
    25.122    29.029     0.200
    25.771    29.066     0.200
    25.771    28.621     0.200
    25.771    26.902     0.200
    25.977    26.772     0.200
    26.132    25.167     0.200
    26.870    23.459     0.200
    26.920    26.993     0.200
    27.538    22.175     0.200
    27.670    24.318     0.200
    28.753    18.665     0.200
    29.563    18.535     0.200
    29.545    19.032     0.200
    15.731    40.742     0.200
    15.731    40.431     0.200
    16.421    40.910     0.200
    16.528    42.861     0.200
    16.770    41.152     0.200
    16.770    40.802     0.200
    17.015    41.847     0.200
    17.015    41.386     0.200
    17.016    41.919     0.200
    17.016    40.673     0.200
    17.016    41.529     0.200
    17.068    41.842     0.200
    17.310    41.970     0.200
    17.310    40.312     0.200
    17.729    42.104     0.200
    17.953    39.538     0.200
    18.001    39.441     0.200
    18.070    41.718     0.200
    17.876    44.405     0.200
    18.097    43.063     0.200
    18.095    43.334     0.200
    18.176    40.018     0.200
    18.242    40.192     0.200
    18.182    41.224     0.200
    18.423    38.493     0.200
    18.423    38.952     0.200
    18.338    43.363     0.200
    18.686    39.959     0.200
    19.379    38.757     0.200
    20.177    37.946     0.200
    20.169    38.400     0.200
    20.184    37.985     0.200
    20.091    39.000     0.200
    20.092    39.801     0.200
    20.286    38.598     0.200
    20.290    38.195     0.200
    20.355    38.151     0.200
    20.302    39.254     0.200
    20.516    37.655     0.200
    20.500    39.378     0.200
    20.567    37.891     0.200
    20.578    38.316     0.200
    20.580    37.864     0.200
    20.560    39.527     0.200
    20.722    37.525     0.200
    20.654    39.350     0.200
    20.785    37.363     0.200
    20.818    38.363     0.200
    20.812    38.488     0.200
    20.800    38.390     0.200
    20.912    34.484     0.200
    21.139    36.312     0.200
    21.348    39.172     0.200
    21.458    36.027     0.200
    21.454    37.878     0.200
    21.500    39.569     0.200
    21.635    35.805     0.200
    21.520    37.771     0.200
    21.661    35.647     0.200
    21.645    36.055     0.200
    21.532    38.988     0.200
    21.623    38.515     0.200
    21.706    37.871     0.200
    21.706    37.711     0.200
    21.856    36.476     0.200
    21.824    37.120     0.200
    21.883    40.539     0.200
    21.883    40.338     0.200
    22.129    37.466     0.200
    22.129    35.357     0.200
    22.229    34.475     0.200
    22.397    35.348     0.200
    22.442    34.418     0.200
    22.535    38.319     0.200
    22.756    34.720     0.200
    22.758    35.709     0.200
    22.849    34.058     0.200
    22.959    33.929     0.200
    22.874    37.056     0.200
    22.969    33.953     0.200
    23.069    33.687     0.200
    23.136    33.371     0.200
    23.209    33.771     0.200
    23.234    33.656     0.200
    23.262    32.662     0.200
    23.539    36.068     0.200
    23.636    38.078     0.200
    24.157    35.688     0.200
    24.112    36.420     0.200
    24.157    36.094     0.200
    24.194    35.588     0.200
    24.280    35.650     0.200
    24.280    34.160     0.200
    24.280    35.410     0.200
    24.280    34.420     0.200
    24.335    31.835     0.200
    24.267    35.565     0.200
    24.267    33.885     0.200
    24.267    35.415     0.200
    24.452    31.773     0.200
    24.452    31.193     0.200
    24.466    35.595     0.200
    24.499    33.430     0.200
    24.616    34.344     0.200
    24.675    33.915     0.200
    24.721    32.049     0.200
    24.829    30.842     0.200
    24.829    30.451     0.200
    24.846    33.181     0.200
    24.978    33.452     0.200
    25.041    33.364     0.200
    25.056    33.429     0.200
    25.170    29.544     0.200
    25.164    30.943     0.200
    25.167    30.561     0.200
    25.277    29.689     0.200
    25.329    29.983     0.200
    25.484    30.214     0.200
    25.619    29.049     0.200
    25.863    29.062     0.200
    25.926    29.068     0.200
    25.926    28.349     0.200
    25.953    27.981     0.200
    26.106    27.270     0.200
    26.162    30.991     0.200
    26.782    26.455     0.200
    27.099    26.979     0.200
    27.328    27.265     0.200
    27.603    25.895     0.200
    27.706    27.178     0.200
    27.722    27.998     0.200
    28.422    25.721     0.200
    28.730    23.831     0.200
    29.140    23.242     0.200
    29.096    24.252     0.200
    29.330    23.327     0.200
    29.389    23.492     0.200
    29.389    23.242     0.200
    29.758    21.030     0.200
    29.824    21.263     0.200
    29.970    22.362     0.200
    29.985    21.283     0.200
    15.251    42.293     0.200
    15.588    45.296     0.200
    16.364    41.325     0.200
    16.364    40.974     0.200
    16.364    41.145     0.200
    16.403    43.123     0.200
    16.666    41.738     0.200
    16.666    42.324     0.200
    17.099    41.435     0.200
    17.383    41.345     0.200
    18.115    42.210     0.200
    18.369    42.597     0.200
    18.358    40.747     0.200
    18.410    38.717     0.200
    18.414    40.366     0.200
    18.449    38.873     0.200
    18.499    38.799     0.200
    18.733    38.649     0.200
    19.211    39.954     0.200
    19.344    39.275     0.200
    19.362    38.793     0.200
    19.510    37.621     0.200
    19.733    38.305     0.200
    19.868    40.063     0.200
    19.868    39.954     0.200
    19.868    42.172     0.200
    19.868    40.012     0.200
    19.868    38.777     0.200
    20.021    42.407     0.200
    20.121    39.487     0.200
    20.159    38.217     0.200
    20.351    37.876     0.200
    20.358    39.184     0.200
    20.397    38.951     0.200
    20.639    37.726     0.200
    20.919    37.185     0.200
    21.101    36.527     0.200
    21.095    40.603     0.200
    21.342    38.807     0.200
    21.404    36.595     0.200
    21.394    38.529     0.200
    21.628    35.816     0.200
    21.830    39.171     0.200
    21.826    35.561     0.200
    21.981    39.205     0.200
    22.147    39.853     0.200
    22.197    36.839     0.200
    22.375    37.001     0.200
    22.417    34.919     0.200
    22.529    39.880     0.200
    22.529    39.599     0.200
    22.522    38.139     0.200
    22.560    34.433     0.200
    22.560    34.207     0.200
    22.608    37.835     0.200
    22.608    37.295     0.200
    22.608    36.545     0.200
    22.608    37.999     0.200
    22.679    38.028     0.200
    23.101    37.570     0.200
    23.274    36.210     0.200
    23.316    33.470     0.200
    23.502    33.327     0.200
    23.671    37.174     0.200
    24.000    33.028     0.200
    24.049    36.343     0.200
    24.073    31.759     0.200
    24.091    34.324     0.200
    24.282    35.745     0.200
    24.380    35.048     0.200
    24.401    31.603     0.200
    24.731    34.237     0.200
    24.757    34.399     0.200
    24.804    34.660     0.200
    24.794    32.378     0.200
    24.797    32.200     0.200
    24.797    32.856     0.200
    24.797    32.138     0.200
    24.850    34.259     0.200
    24.850    33.314     0.200
    24.910    33.543     0.200
    24.910    33.308     0.200
    24.910    33.816     0.200
    24.933    30.263     0.200
    25.111    33.965     0.200
    25.091    31.797     0.200
    25.090    32.191     0.200
    25.250    32.409     0.200
    25.345    29.418     0.200
    25.395    32.472     0.200
    25.549    31.973     0.200
    25.627    32.092     0.200
    25.651    30.176     0.200
    25.651    29.942     0.200
    25.651    29.278     0.200
    25.651    29.567     0.200
    25.829    32.262     0.200
    25.962    27.236     0.200
    26.263    26.264     0.200
    26.666    29.170     0.200
    26.805    29.199     0.200
    27.109    26.664     0.200
    27.114    27.656     0.200
    27.870    25.706     0.200
    27.913    24.685     0.200
    28.179    25.134     0.200
    28.364    26.301     0.200
    28.724    22.621     0.200
    29.066    23.607     0.200
    29.306    18.587     0.200
    29.372    22.044     0.200
    18.147    38.175     0.200
    18.417    37.954     0.200
    18.532    37.864     0.200
    18.826    37.363     0.200
    19.604    37.298     0.200
    19.793    37.093     0.200
    20.181    37.219     0.200
    20.216    36.453     0.200
    20.276    36.756     0.200
    20.574    36.338     0.200
    20.768    35.171     0.200
    20.762    36.233     0.200
    20.704    38.291     0.200
    20.827    38.070     0.200
    22.189    34.719     0.200
    22.390    33.421     0.200
    22.464    33.519     0.200
    22.627    33.606     0.200
    23.322    32.561     0.200
    23.492    33.041     0.200
    23.898    31.749     0.200
    23.923    30.816     0.200
    24.028    35.367     0.200
    24.496    30.554     0.200
    24.618    30.639     0.200
    24.770    29.264     0.200
    25.044    32.324     0.200
    25.044    30.042     0.200
    20.159    37.562     0.200
    21.183    39.040     0.200
    21.407    38.665     0.200
    21.786    37.716     0.200
    22.681    36.685     0.200
    23.979    36.029     0.200
    14.860    39.888     0.200
    14.372    38.421     0.200
    16.465    42.308     0.200
    24.608    31.805     0.200
    16.685    41.363     0.200
    16.741    39.208     0.200
    18.296    38.359     0.200
    18.304    38.617     0.200
    18.457    38.531     0.200
    18.439    38.653     0.200
    18.520    38.197     0.200
    18.614    37.468     0.200
    18.928    38.626     0.200
    19.116    37.819     0.200
    19.489    38.100     0.200
    19.506    37.987     0.200
    19.638    37.881     0.200
    20.705    36.557     0.200
    21.004    36.760     0.200
    21.076    35.593     0.200
    21.056    36.085     0.200
    21.188    38.416     0.200
    21.401    37.875     0.200
    21.613    36.465     0.200
    22.267    34.258     0.200
    22.374    34.169     0.200
    23.796    35.714     0.200
    23.846    31.862     0.200
    23.942    31.835     0.200
    23.978    31.318     0.200
    24.234    30.951     0.200
    24.431    30.998     0.200
    24.467    33.203     0.200
    24.275    35.852     0.200
    24.752    30.058     0.200
    24.828    30.447     0.200
    26.819    23.995     0.200
    27.516    23.211     0.200
    15.009    40.980     0.200
    15.669    39.939     0.200
    15.850    39.745     0.200
    16.080    41.102     0.200
    16.140    39.683     0.200
    16.381    41.611     0.200
    16.570    40.038     0.200
    17.023    41.508     0.200
    17.307    41.882     0.200
    17.307    41.229     0.200
    17.306    41.227     0.200
    17.364    40.688     0.200
    17.527    41.344     0.200
    17.593    39.987     0.200
    17.724    40.431     0.200
    18.116    41.348     0.200
    18.321    41.360     0.200
    18.629    39.004     0.200
    19.152    39.181     0.200
    19.369    38.018     0.200
    19.421    39.070     0.200
    19.892    39.074     0.200
    19.954    38.998     0.200
    20.102    38.522     0.200
    20.574    37.277     0.200
    20.881    37.743     0.200
    21.120    36.907     0.200
    21.145    39.063     0.200
    21.232    39.569     0.200
    21.498    37.073     0.200
    21.549    38.890     0.200
    21.646    39.501     0.200
    21.692    39.183     0.200
    21.823    38.858     0.200
    21.863    38.276     0.200
    21.946    36.904     0.200
    22.002    38.869     0.200
    22.153    38.491     0.200
    22.495    34.468     0.200
    22.638    38.199     0.200
    22.659    37.910     0.200
    22.666    38.045     0.200
    22.684    35.433     0.200
    23.144    37.023     0.200
    23.305    36.288     0.200
    23.439    36.764     0.200
    23.499    34.291     0.200
    24.195    33.122     0.200
    24.425    32.701     0.200
    24.437    34.857     0.200
    24.437    35.025     0.200
    24.548    33.530     0.200
    24.810    32.106     0.200
    24.841    33.795     0.200
    25.001    31.380     0.200
    25.101    30.302     0.200
    25.262    32.743     0.200
    25.309    30.229     0.200
    25.455    31.732     0.200
    25.455    31.283     0.200
    25.455    31.277     0.200
    25.650    31.244     0.200
    27.860    24.919     0.200
    23.946    35.757     0.200
    24.923    32.588     0.200
    15.590    39.738     0.200
    16.861    39.532     0.200
    18.037    38.891     0.200
    18.290    38.360     0.200
    18.290    37.469     0.200
    18.374    37.877     0.200
    18.355    37.340     0.200
    18.414    37.449     0.200
    18.416    37.042     0.200
    18.445    37.123     0.200
    18.486    36.989     0.200
    18.465    36.965     0.200
    18.504    37.011     0.200
    18.515    37.517     0.200
    18.558    36.542     0.200
    18.668    37.852     0.200
    18.708    37.271     0.200
    18.711    38.016     0.200
    18.716    37.237     0.200
    18.763    37.465     0.200
    18.768    36.583     0.200
    18.821    37.745     0.200
    18.828    37.771     0.200
    18.884    36.951     0.200
    18.882    37.913     0.200
    18.903    36.729     0.200
    18.926    36.610     0.200
    18.978    36.675     0.200
    19.018    36.321     0.200
    19.081    36.317     0.200
    19.127    37.051     0.200
    19.254    38.126     0.200
    19.345    35.422     0.200
    19.392    37.686     0.200
    19.450    37.244     0.200
    19.474    36.765     0.200
    19.505    36.833     0.200
    19.657    35.698     0.200
    19.674    35.888     0.200
    19.811    37.129     0.200
    20.052    36.508     0.200
    20.066    35.903     0.200
    20.143    36.922     0.200
    20.152    36.875     0.200
    20.431    36.037     0.200
    20.525    37.407     0.200
    20.528    37.237     0.200
    20.615    35.708     0.200
    20.630    35.653     0.200
    20.649    35.684     0.200
    20.693    36.021     0.200
    21.076    34.898     0.200
    21.228    36.255     0.200
    21.326    34.974     0.200
    21.341    34.006     0.200
    21.500    35.004     0.200
    21.527    34.156     0.200
    21.548    34.313     0.200
    21.544    34.938     0.200
    21.553    35.787     0.200
    21.679    34.512     0.200
    21.727    35.426     0.200
    21.830    35.353     0.200
    22.068    34.571     0.200
    22.264    32.874     0.200
    22.264    33.745     0.200
    22.322    33.730     0.200
    22.323    34.270     0.200
    22.475    33.524     0.200
    22.492    34.851     0.200
    22.546    34.135     0.200
    22.589    33.441     0.200
    22.727    34.651     0.200
    22.737    33.108     0.200
    22.831    33.779     0.200
    22.829    34.239     0.200
    22.879    34.105     0.200
    22.962    33.198     0.200
    23.098    32.892     0.200
    23.118    33.290     0.200
    23.163    31.996     0.200
    23.163    32.906     0.200
    23.175    32.962     0.200
    23.242    32.538     0.200
    23.351    32.324     0.200
    23.401    32.993     0.200
    23.746    31.301     0.200
    23.789    31.971     0.200
    23.810    32.277     0.200
    23.925    31.827     0.200
    23.988    31.650     0.200
    24.043    36.125     0.200
    24.056    34.922     0.200
    24.056    32.762     0.200
    24.125    30.786     0.200
    24.019    35.416     0.200
    24.319    30.072     0.200
    24.344    29.889     0.200
    24.457    29.597     0.200
    24.462    30.378     0.200
    24.624    29.351     0.200
    24.707    30.013     0.200
    24.707    29.146     0.200
    24.707    30.576     0.200
    24.711    29.035     0.200
    24.836    29.469     0.200
    24.956    28.979     0.200
    25.015    30.384     0.200
    25.015    29.036     0.200
    25.017    28.931     0.200
    25.059    28.167     0.200
    25.059    28.655     0.200
    25.096    28.745     0.200
    25.184    28.785     0.200
    25.311    27.062     0.200
    25.330    27.279     0.200
    25.604    27.150     0.200
    25.958    28.156     0.200
    27.461    24.803     0.200
    15.353    36.026     0.200
    15.353    35.886     0.200
    15.353    36.167     0.200
    16.524    37.412     0.200
    16.524    36.880     0.200
    16.524    38.302     0.200
    17.816    35.184     0.200
    18.971    35.005     0.200
    19.187    35.959     0.200
    21.187    33.574     0.200
    21.791    31.288     0.200
    21.842    31.722     0.200
    22.692    29.968     0.200
    23.268    28.270     0.200
    23.858    30.209     0.200
    23.858    29.677     0.200
    23.983    30.427     0.200
    24.045    28.672     0.200
    24.228    27.506     0.200
    24.228    27.033     0.200
    24.228    27.897     0.200
    24.581    26.689     0.200
    24.682    29.097     0.200
    24.684    26.416     0.200
    24.684    25.936     0.200
    24.684    27.569     0.200
    25.388    23.912     0.200
    25.520    24.207     0.200
    25.614    23.681     0.200
    25.637    22.719     0.200
    26.389    20.286     0.200
    26.665    21.868     0.200
    27.225    20.663     0.200
    28.211    16.080     0.200
    23.239    40.913     0.200
    20.764    41.384     0.200
    21.225    40.131     0.200
    23.326    40.772     0.200
    23.967    38.445     0.200
    23.967    36.825     0.200
    23.284    41.069     0.200
    23.907    38.869     0.200
    18.254    38.719     0.200
    18.254    38.446     0.200
    18.378    40.781     0.200
    18.371    38.016     0.200
    18.450    39.544     0.200
    18.667    37.770     0.200
    18.739    38.821     0.200
    18.743    38.643     0.200
    18.775    40.272     0.200
    18.818    37.658     0.200
    18.840    37.143     0.200
    18.871    37.512     0.200
    18.924    37.462     0.200
    19.003    40.091     0.200
    19.070    36.712     0.200
    19.151    39.443     0.200
    19.249    40.772     0.200
    19.282    41.375     0.200
    19.282    39.797     0.200
    19.282    40.216     0.200
    19.350    38.635     0.200
    19.397    37.212     0.200
    19.441    37.227     0.200
    19.575    37.664     0.200
    19.613    36.551     0.200
    19.631    37.194     0.200
    20.018    35.764     0.200
    20.114    36.416     0.200
    20.367    36.825     0.200
    20.425    38.238     0.200
    20.416    35.911     0.200
    20.554    38.423     0.200
    20.583    36.689     0.200
    20.599    35.785     0.200
    20.600    36.665     0.200
    20.608    35.878     0.200
    21.038    36.098     0.200
    21.303    39.269     0.200
    21.379    38.890     0.200
    21.561    38.770     0.200
    21.878    34.716     0.200
    22.027    34.264     0.200
    22.145    37.623     0.200
    22.227    34.650     0.200
    22.293    34.533     0.200
    22.301    34.463     0.200
    22.301    34.803     0.200
    22.301    35.416     0.200
    22.382    38.494     0.200
    22.466    33.889     0.200
    22.512    34.379     0.200
    22.626    35.922     0.200
    22.801    34.533     0.200
    22.955    32.618     0.200
    23.032    33.232     0.200
    23.088    33.373     0.200
    23.164    33.553     0.200
    23.291    36.304     0.200
    23.329    33.240     0.200
    23.949    33.813     0.200
    23.949    34.786     0.200
    24.178    31.536     0.200
    24.253    34.055     0.200
    24.336    30.663     0.200
    24.081    37.624     0.200
    24.081    35.296     0.200
    24.458    30.740     0.200
    24.608    30.091     0.200
    24.684    30.564     0.200
    24.684    30.146     0.200
    24.684    31.006     0.200
    24.892    32.461     0.200
    24.922    30.569     0.200
    24.922    31.577     0.200
    25.049    29.893     0.200
    25.049    29.643     0.200
    25.096    28.509     0.200
    25.176    31.171     0.200
    25.169    28.453     0.200
    25.284    27.934     0.200
    25.753    27.247     0.200
    25.896    27.488     0.200
    26.851    26.804     0.200
    29.835    18.079     0.200
    29.895    17.194     0.200
    24.703    30.689     0.200
    19.409    37.445     0.200
    19.577    37.544     0.200
    21.081    38.376     0.200
    21.074    35.347     0.200
    21.333    38.021     0.200
    22.194    33.836     0.200
    22.194    33.406     0.200
    22.273    33.816     0.200
    22.273    33.425     0.200
    23.064    32.362     0.200
    23.144    32.953     0.200
    23.144    32.063     0.200
    23.163    32.243     0.200
    23.244    36.447     0.200
    23.244    35.056     0.200
    23.713    30.964     0.200
    23.835    34.965     0.200
    23.903    34.383     0.200
    23.903    34.817     0.200
    24.206    32.936     0.200
    24.087    34.826     0.200
    24.087    35.107     0.200
    24.656    29.348     0.200
    24.656    29.106     0.200
    24.876    28.715     0.200
    24.876    30.524     0.200
    25.024    28.364     0.200
    27.310    24.313     0.200
    25.346    28.076     0.200
    15.702    43.344     0.200
    19.205    41.242     0.200
    19.606    41.590     0.200
    20.694    41.172     0.200
    20.690    41.311     0.200
    20.748    41.378     0.200
    21.074    40.148     0.200
    21.080    41.202     0.200
    22.269    38.934     0.200
    23.041    37.508     0.200
    23.294    37.815     0.200
    23.127    41.051     0.200
    23.873    37.408     0.200
    15.706    43.242     0.200
    21.192    38.390     0.200
    22.931    36.284     0.200
    23.066    36.444     0.200
    23.877    35.520     0.200
    16.593    41.216     0.200
    17.064    41.619     0.200
    18.010    41.509     0.200
    19.222    40.669     0.200
    19.222    41.462     0.200
    20.073    40.905     0.200
    21.056    40.050     0.200
    23.061    37.987     0.200
    23.287    37.757     0.200
    23.546    37.925     0.200
    23.874    37.164     0.200
    16.998    41.033     0.200
    19.919    37.135     0.200
    20.531    39.007     0.200
    20.868    35.875     0.200
    20.889    35.815     0.200
    20.893    35.672     0.200
    21.313    36.713     0.200
    21.327    34.714     0.200
    22.516    34.453     0.200
    22.591    34.912     0.200
    22.752    33.642     0.200
    22.978    35.387     0.200
    23.012    33.589     0.200
    23.394    35.403     0.200
    23.375    32.699     0.200
    23.390    33.964     0.200
    23.444    32.605     0.200
    23.481    33.684     0.200
    23.486    32.708     0.200
    23.619    32.224     0.200
    24.023    31.382     0.200
    24.050    31.884     0.200
    24.092    35.920     0.200
    24.092    33.745     0.200
    24.497    32.875     0.200
    24.468    30.485     0.200
    24.621    29.140     0.200
    24.957    29.886     0.200
    24.974    29.370     0.200
    25.140    29.812     0.200
    25.140    30.572     0.200
    25.377    28.598     0.200
    25.810    28.763     0.200
    26.247    25.364     0.200
    27.083    23.403     0.200
    27.140    22.990     0.200
    27.705    20.746     0.200
    28.782    20.025     0.200
    29.367    17.233     0.200
    18.427    34.140     0.200
    19.812    35.896     0.200
    19.812    35.698     0.200
    19.803    35.746     0.200
    20.103    34.354     0.200
    20.181    34.464     0.200
    20.296    33.132     0.200
    20.637    34.062     0.200
    20.748    34.816     0.200
    21.019    34.132     0.200
    21.368    34.891     0.200
    21.220    32.742     0.200
    21.315    32.861     0.200
    21.405    32.340     0.200
    21.554    33.863     0.200
    21.592    32.303     0.200
    22.403    32.465     0.200
    22.403    31.096     0.200
    22.398    30.811     0.200
    22.398    31.271     0.200
    22.625    34.031     0.200
    22.642    34.718     0.200
    23.772    31.555     0.200
    23.776    34.013     0.200
    23.776    35.344     0.200
    24.455    31.863     0.200
    24.468    30.467     0.200
    24.505    29.178     0.200
    24.791    27.454     0.200
    24.791    27.084     0.200
    25.095    26.646     0.200
    25.367    27.024     0.200
    25.367    28.623     0.200
    25.601    24.170     0.200
    26.103    23.001     0.200
    26.133    23.389     0.200
    26.194    23.373     0.200
    27.329    21.678     0.200
    27.861    20.416     0.200
    29.184    20.392     0.200
    17.385    40.913     0.200
    19.492    39.769     0.200
    19.948    38.729     0.200
    23.083    35.592     0.200
    18.620    38.952     0.200
    19.174    40.483     0.200
    19.433    41.444     0.200
    19.433    40.644     0.200
    20.866    38.618     0.200
    21.733    37.614     0.200
    21.953    36.556     0.200
    22.377    38.284     0.200
    22.589    35.136     0.200
    22.674    36.712     0.200
    22.709    34.979     0.200
    22.709    35.628     0.200
    22.643    39.024     0.200
    23.617    33.537     0.200
    23.869    38.890     0.200
    23.883    36.979     0.200
    24.170    32.814     0.200
    24.771    31.791     0.200
    24.560    38.388     0.200
    24.560    36.158     0.200
    24.902    31.373     0.200
    25.018    32.712     0.200
    25.018    33.032     0.200
    25.086    31.226     0.200
    25.086    31.786     0.200
    25.086    31.686     0.200
    25.390    30.504     0.200
    25.479    29.680     0.200
    25.546    29.656     0.200
    25.868    31.356     0.200
    26.887    29.202     0.200
    27.331    28.075     0.200
    28.492    21.957     0.200
    15.538    41.590     0.200
    15.986    40.876     0.200
    16.482    41.066     0.200
    18.651    41.456     0.200
    21.286    39.765     0.200
    22.660    34.043     0.200
    23.374    37.844     0.200
    23.374    38.364     0.200
    23.492    32.827     0.200
    23.520    33.890     0.200
    23.673    33.088     0.200
    24.598    34.073     0.200
    25.004    30.545     0.200
    24.897    35.391     0.200
    19.241    43.858     0.200
    22.812    36.356     0.200
    22.949    32.270     0.200
    23.996    29.069     0.200
    16.637    37.951     0.200
    19.625    36.690     0.200
    24.193    29.106     0.200
    24.809    24.991     0.200
    14.626    40.784     0.200
    15.253    41.701     0.200
    15.515    40.266     0.200
    16.267    40.726     0.200
    16.354    43.165     0.200
    17.135    39.918     0.200
    18.127    40.109     0.200
    18.273    39.756     0.200
    19.366    37.060     0.200
    19.728    39.943     0.200
    22.319    38.305     0.200
    24.438    30.985     0.200
    24.549    33.414     0.200
    24.549    33.653     0.200
    25.302    29.926     0.200
    25.302    29.703     0.200
    25.795    28.802     0.200
    29.109    20.019     0.200
    15.258    38.107     0.200
    16.552    40.330     0.200
    16.552    39.892     0.200
    16.552    39.224     0.200
    16.614    40.338     0.200
    17.459    40.387     0.200
    19.061    39.805     0.200
    19.060    39.049     0.200
    19.061    39.454     0.200
    19.472    36.745     0.200
    19.551    39.071     0.200
    19.560    37.080     0.200
    19.700    40.006     0.200
    20.048    38.473     0.200
    20.133    38.419     0.200
    20.194    38.746     0.200
    20.198    38.711     0.200
    20.176    36.245     0.200
    20.276    35.884     0.200
    20.329    37.817     0.200
    20.350    38.224     0.200
    20.301    35.728     0.200
    20.368    38.725     0.200
    20.375    37.396     0.200
    20.385    37.280     0.200
    20.418    36.385     0.200
    20.404    36.346     0.200
    20.457    35.536     0.200
    20.632    39.022     0.200
    21.154    37.151     0.200
    21.756    34.697     0.200
    22.076    33.565     0.200
    22.162    32.976     0.200
    22.178    32.403     0.200
    22.178    32.286     0.200
    22.178    32.583     0.200
    22.324    34.123     0.200
    22.998    37.182     0.200
    23.723    34.137     0.200
    23.723    34.457     0.200
    24.428    32.039     0.200
    24.577    31.740     0.200
    24.557    29.153     0.200
    24.557    28.811     0.200
    24.557    28.956     0.200
    24.699    29.298     0.200
    24.793    28.037     0.200
    24.944    27.478     0.200
    25.481    27.500     0.200
    25.706    25.497     0.200
    25.706    25.872     0.200
    25.935    28.153     0.200
    26.625    25.592     0.200
    26.618    25.661     0.200
    26.618    25.448     0.200
    27.129    24.358     0.200
    27.828    22.241     0.200
    29.710    19.326     0.200
    29.847    15.646     0.200
    14.502    37.309     0.200
    14.893    36.651     0.200
    15.280    36.909     0.200
    15.673    38.684     0.200
    15.673    38.943     0.200
    15.752    37.235     0.200
    15.748    38.623     0.200
    15.918    39.451     0.200
    15.988    39.110     0.200
    15.988    39.848     0.200
    16.330    38.329     0.200
    16.571    39.596     0.200
    16.572    39.275     0.200
    16.572    38.470     0.200
    16.607    37.357     0.200
    16.607    37.236     0.200
    16.700    38.682     0.200
    16.920    37.871     0.200
    17.312    38.047     0.200
    17.390    38.336     0.200
    17.435    37.768     0.200
    17.481    37.987     0.200
    17.669    38.302     0.200
    17.704    37.729     0.200
    17.823    38.531     0.200
    17.811    38.223     0.200
    17.831    37.425     0.200
    17.862    38.220     0.200
    17.728    40.406     0.200
    17.974    37.423     0.200
    18.175    37.933     0.200
    18.116    36.894     0.200
    18.151    37.094     0.200
    18.234    38.308     0.200
    18.221    37.763     0.200
    18.234    37.376     0.200
    18.289    37.454     0.200
    18.391    36.530     0.200
    18.492    37.069     0.200
    18.511    36.856     0.200
    18.708    37.031     0.200
    19.082    40.027     0.200
    19.152    36.580     0.200
    19.234    35.988     0.200
    19.375    38.208     0.200
    19.463    35.516     0.200
    19.484    36.213     0.200
    19.533    38.120     0.200
    19.533    38.515     0.200
    19.568    36.421     0.200
    19.920    35.965     0.200
    20.052    38.306     0.200
    20.110    37.522     0.200
    20.216    36.865     0.200
    20.220    37.233     0.200
    20.235    37.814     0.200
    20.334    37.337     0.200
    20.350    36.935     0.200
    20.404    36.427     0.200
    20.591    35.914     0.200
    20.614    36.455     0.200
    20.638    36.337     0.200
    20.790    36.325     0.200
    20.922    37.209     0.200
    21.016    36.250     0.200
    21.078    36.141     0.200
    21.176    36.390     0.200
    21.254    36.375     0.200
    21.270    36.882     0.200
    21.382    35.452     0.200
    21.424    35.280     0.200
    21.523    36.434     0.200
    21.550    36.580     0.200
    21.772    35.180     0.200
    22.087    32.913     0.200
    22.161    33.552     0.200
    22.238    36.250     0.200
    22.603    34.853     0.200
    22.841    34.896     0.200
    23.178    33.617     0.200
    23.239    34.655     0.200
    23.547    32.707     0.200
    23.745    33.089     0.200
    23.745    33.753     0.200
    23.820    32.683     0.200
    24.145    33.043     0.200
    24.146    30.185     0.200
    24.180    31.363     0.200
    24.417    31.796     0.200
    24.566    28.590     0.200
    24.720    30.060     0.200
    24.720    29.190     0.200
    24.720    30.522     0.200
    24.950    27.405     0.200
    25.737    27.971     0.200
    26.589    25.848     0.200
    26.824    24.740     0.200
    27.395    23.907     0.200
    29.689    15.978     0.200
    29.692    19.296     0.200
    29.867    15.458     0.200
    14.418    36.341     0.200
    14.408    39.209     0.200
    14.567    38.257     0.200
    14.915    37.935     0.200
    15.010    38.663     0.200
    15.025    39.254     0.200
    15.226    38.420     0.200
    15.315    39.708     0.200
    15.385    37.626     0.200
    15.560    38.657     0.200
    15.709    39.265     0.200
    15.782    39.403     0.200
    15.959    39.263     0.200
    16.354    38.469     0.200
    16.365    38.938     0.200
    16.459    37.876     0.200
    16.588    37.558     0.200
    16.588    36.855     0.200
    16.588    38.788     0.200
    16.640    36.752     0.200
    16.640    37.619     0.200
    16.734    39.148     0.200
    16.839    38.886     0.200
    16.956    38.108     0.200
    17.342    37.951     0.200
    17.432    38.218     0.200
    17.481    38.666     0.200
    17.516    37.810     0.200
    17.639    36.961     0.200
    17.739    37.779     0.200
    17.713    38.306     0.200
    17.847    39.750     0.200
    17.846    38.353     0.200
    17.867    37.158     0.200
    17.984    39.060     0.200
    18.009    37.577     0.200
    18.156    36.107     0.200
    18.156    36.267     0.200
    18.187    36.895     0.200
    18.259    37.297     0.200
    18.269    36.816     0.200
    18.367    37.535     0.200
    18.323    36.942     0.200
    18.432    35.437     0.200
    18.565    39.398     0.200
    18.547    36.565     0.200
    18.742    36.705     0.200
    18.795    36.009     0.200
    18.895    36.264     0.200
    18.938    36.554     0.200
    19.077    39.017     0.200
    19.160    37.882     0.200
    19.241    38.486     0.200
    19.269    35.846     0.200
    19.392    37.715     0.200
    19.348    35.638     0.200
    19.500    35.248     0.200
    19.522    35.130     0.200
    19.612    35.910     0.200
    19.923    34.761     0.200
    19.968    34.241     0.200
    20.011    34.943     0.200
    20.002    34.566     0.200
    20.223    34.051     0.200
    20.382    34.540     0.200
    20.450    34.686     0.200
    20.509    35.281     0.200
    20.716    33.750     0.200
    20.929    36.537     0.200
    20.936    34.163     0.200
    20.999    33.732     0.200
    21.258    33.843     0.200
    21.424    32.232     0.200
    21.469    32.938     0.200
    21.479    32.423     0.200
    21.805    33.603     0.200
    21.948    35.618     0.200
    21.947    34.713     0.200
    21.846    32.241     0.200
    21.920    32.736     0.200
    21.972    31.719     0.200
    22.127    32.274     0.200
    22.127    32.012     0.200
    22.205    32.489     0.200
    22.230    31.591     0.200
    22.210    32.886     0.200
    22.417    32.342     0.200
    22.476    32.684     0.200
    22.509    30.634     0.200
    22.662    32.570     0.200
    22.669    31.549     0.200
    22.909    31.012     0.200
    22.941    29.980     0.200
    22.994    30.704     0.200
    23.038    31.739     0.200
    23.035    31.443     0.200
    23.088    31.466     0.200
    23.676    31.276     0.200
    23.744    32.227     0.200
    23.744    31.422     0.200
    23.651    29.824     0.200
    23.686    29.517     0.200
    23.703    30.569     0.200
    23.818    29.936     0.200
    23.800    30.187     0.200
    23.834    29.704     0.200
    24.144    31.250     0.200
    24.091    28.792     0.200
    24.186    29.519     0.200
    24.287    28.436     0.200
    24.402    27.260     0.200
    24.425    27.563     0.200
    24.461    30.666     0.200
    24.461    30.319     0.200
    24.560    27.667     0.200
    24.609    27.360     0.200
    24.609    27.829     0.200
    24.735    29.592     0.200
    24.735    28.920     0.200
    24.905    26.819     0.200
    24.996    27.317     0.200
    24.996    26.778     0.200
    25.061    26.179     0.200
    25.141    26.047     0.200
    25.203    26.216     0.200
    25.255    26.015     0.200
    25.307    26.906     0.200
    25.620    27.003     0.200
    25.610    25.092     0.200
    25.694    24.242     0.200
    25.715    25.176     0.200
    25.867    24.772     0.200
    25.892    24.019     0.200
    25.978    23.438     0.200
    26.055    23.855     0.200
    26.061    23.985     0.200
    26.129    23.159     0.200
    26.489    22.169     0.200
    26.776    22.438     0.200
    26.634    22.399     0.200
    26.675    22.131     0.200
    26.654    25.925     0.200
    26.741    22.395     0.200
    26.712    21.297     0.200
    26.784    21.588     0.200
    26.891    21.283     0.200
    27.080    20.742     0.200
    27.406    21.494     0.200
    27.354    20.310     0.200
    27.372    20.506     0.200
    27.437    19.984     0.200
    27.701    19.321     0.200
    27.862    20.926     0.200
    27.851    21.276     0.200
    28.022    19.170     0.200
    28.190    20.695     0.200
    28.252    20.450     0.200
    28.212    17.369     0.200
    28.208    18.475     0.200
    28.211    17.988     0.200
    28.328    17.678     0.200
    28.469    19.590     0.200
    28.379    16.719     0.200
    28.638    17.316     0.200
    29.130    14.932     0.200
    29.210    15.180     0.200
    29.249    15.540     0.200
    29.255    14.948     0.200
    29.407    13.737     0.200
    29.524    14.331     0.200
    29.914    13.021     0.200
    29.963    12.303     0.200
    15.004    39.957     0.200
    15.093    39.740     0.200
    15.120    39.758     0.200
    15.412    39.839     0.200
    15.654    39.784     0.200
    18.251    36.314     0.200
    18.638    36.530     0.200
    19.444    35.657     0.200
    20.019    35.401     0.200
    20.107    35.517     0.200
    21.579    34.520     0.200
    22.222    32.723     0.200
    22.329    31.640     0.200
    22.769    32.056     0.200
    23.009    32.020     0.200
    23.094    31.298     0.200
    23.135    31.620     0.200
    23.138    31.551     0.200
    23.751    30.418     0.200
    23.786    29.604     0.200
    23.897    30.751     0.200
    23.934    29.727     0.200
    24.281    29.835     0.200
    24.387    29.249     0.200
    24.501    27.889     0.200
    24.525    28.040     0.200
    24.708    28.421     0.200
    24.793    30.896     0.200
    25.005    27.136     0.200
    25.096    26.623     0.200
    25.161    26.836     0.200
    25.301    26.565     0.200
    26.161    24.368     0.200
    26.774    22.736     0.200
    27.019    22.806     0.200
    27.799    20.129     0.200
    28.479    18.053     0.200
    18.352    37.665     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.900     7.669     0.200
     7.068    23.363     0.200
    13.195    32.865     0.200
    13.327    37.322     0.200
    14.817    33.928     0.200
    14.940    36.504     0.200
    14.938    38.522     0.200
    15.278    33.559     0.200
    16.292    35.721     0.200
    16.481    34.514     0.200
    19.795    38.843     0.200
     4.180    13.316     0.200
    14.342    32.721     0.200
    14.387    32.693     0.200
    15.320    35.207     0.200
    16.673    38.017     0.200
    17.250    38.289     0.200
    20.171    38.896     0.200
     3.057    10.265     0.200
     3.776    11.487     0.200
     7.502    23.401     0.200
    16.801    33.082     0.200
    20.057    36.984     0.200
    20.391    38.386     0.200
     3.524    12.032     0.200
     7.035    22.458     0.200
    13.411    36.542     0.200
    13.574    33.743     0.200
    15.562    36.539     0.200
    17.059    35.180     0.200
    19.263    39.454     0.200
    20.525    39.127     0.200
    20.909    39.644     0.200
     1.693     9.538     0.200
     3.543    12.945     0.200
     5.819    18.889     0.200
     7.240    22.610     0.200
    13.625    35.291     0.200
    16.789    33.970     0.200
    20.626    37.894     0.200
    20.968    36.600     0.200
    20.968    39.600     0.200
     4.307    14.521     0.200
     4.307    14.529     0.200
     5.386    12.938     0.200
     6.679    17.841     0.200
     7.136    21.506     0.200
     8.100    21.263     0.200
     9.636    31.336     0.200
    14.484    33.257     0.200
    14.484    35.757     0.200
    15.236    36.785     0.200
    16.818    34.920     0.200
    19.742    38.399     0.200
    20.080    38.056     0.200
    20.321    38.442     0.200
     2.578    10.303     0.200
     3.351    13.286     0.200
     4.030    15.860     0.200
     6.257    17.373     0.200
    13.143    37.007     0.200
    14.025    37.712     0.200
    15.478    36.263     0.200
    17.070    36.685     0.200
    18.718    43.055     0.200
    20.204    39.113     0.200
    20.815    40.482     0.200
     1.363     6.815     0.200
     1.433     8.998     0.200
     2.654    11.746     0.200
     3.446    14.001     0.200
     6.295    20.751     0.200
    14.065    37.679     0.200
    15.762    37.777     0.200
    17.159    35.375     0.200
    18.767    39.706     0.200
    20.257    40.824     0.200
     3.525     9.420     0.200
     7.807    20.453     0.200
    10.899    30.862     0.200
    12.376    32.629     0.200
    15.341    35.523     0.200
    18.719    39.607     0.200
    19.824    37.214     0.200
    20.489    36.453     0.200
     3.532    12.418     0.200
     4.004    15.414     0.200
     4.011    14.338     0.200
     6.277    17.883     0.200
    10.796    30.151     0.200
    12.600    33.702     0.200
    14.070    33.948     0.200
    15.592    36.782     0.200
    18.969    38.375     0.200
    20.231    37.944     0.200
    20.376    39.560     0.200
    20.724    38.297     0.200
    12.521    33.679     0.200
    14.821    36.640     0.200
    15.058    37.272     0.200
    16.529    39.611     0.200
    18.662    41.320     0.200
    19.660    39.871     0.200
    19.746    41.265     0.200
    20.081    40.151     0.200
    20.416    39.343     0.200
    20.709    39.726     0.200
     2.607    15.120     0.200
    11.367    33.691     0.200
    11.710    32.696     0.200
    12.797    32.104     0.200
    17.925    38.368     0.200
     7.508    20.154     0.200
    13.726    32.987     0.200
    15.945    38.798     0.200
    21.062    40.485     0.200
     3.295    12.559     0.200
     9.950    29.091     0.200
    13.287    30.950     0.200
    15.503    36.292     0.200
    15.594    35.125     0.200
    19.230    38.691     0.200
     7.337    22.750     0.200
    13.209    31.215     0.200
    14.145    35.893     0.200
    14.465    36.256     0.200
    15.226    34.777     0.200
    15.939    36.859     0.200
    16.111    35.555     0.200
    16.884    39.128     0.200
    19.522    40.540     0.200
     2.820    11.377     0.200
     2.868    10.811     0.200
     3.283    12.971     0.200
     3.372    12.437     0.200
     3.528    13.112     0.200
     4.021    13.360     0.200
     5.627    17.623     0.200
     7.019    20.975     0.200
     9.045    23.732     0.200
    10.109    27.810     0.200
    12.370    32.427     0.200
    13.058    31.098     0.200
    13.407    34.328     0.200
    13.540    33.975     0.200
    15.799    37.310     0.200
    16.322    33.911     0.200
    16.735    35.486     0.200
    18.485    36.466     0.200
    18.372    38.378     0.200
    18.716    37.868     0.200
    18.923    36.155     0.200
    19.302    41.334     0.200
    19.850    41.440     0.200
     1.537     9.546     0.200
     2.613    10.987     0.200
     3.449    12.722     0.200
     3.455    13.152     0.200
     3.910    15.343     0.200
     3.915    14.789     0.200
     3.925    14.670     0.200
     4.003    13.762     0.200
     4.154    14.997     0.200
     4.635    16.392     0.200
     6.123    20.017     0.200
     6.142    19.801     0.200
     7.516    21.265     0.200
     9.584    26.628     0.200
    10.630    29.920     0.200
    12.589    34.161     0.200
    15.495    35.646     0.200
    18.277    40.179     0.200
     2.253    10.904     0.200
     3.151    12.619     0.200
     3.216    12.862     0.200
     5.220    18.475     0.200
     6.589    20.504     0.200
    12.787    33.168     0.200
    12.963    35.818     0.200
    18.980    41.097     0.200
    19.218    43.421     0.200
    19.353    42.748     0.200
     3.039    12.025     0.200
     3.605    13.024     0.200
     3.758    12.630     0.200
     3.841     9.962     0.200
     4.266    15.306     0.200
     3.112     9.718     0.200
     3.115    10.485     0.200
     3.192     9.188     0.200
     3.361     8.709     0.200
     4.009    11.850     0.200
    10.007    22.058     0.200
    12.171    27.098     0.200
    18.308    32.578     0.200
    18.330    35.422     0.200
    18.432    33.035     0.200
     3.083    13.604     0.200
     3.122    10.145     0.200
     3.149    10.828     0.200
     3.507    15.049     0.200
     3.521    12.194     0.200
     3.581    13.892     0.200
     3.757    12.636     0.200
     4.262    14.538     0.200
     4.399    14.644     0.200
     5.428    17.741     0.200
     5.890    20.040     0.200
    12.333    31.358     0.200
    12.678    32.331     0.200
    13.123    30.433     0.200
    16.813    36.073     0.200
    18.182    39.096     0.200
    18.949    39.145     0.200
    19.542    38.232     0.200
    19.968    38.558     0.200
    19.969    41.244     0.200
    20.871    37.712     0.200
    20.957    37.719     0.200
     1.241     7.022     0.200
     3.378    12.687     0.200
     3.483    12.655     0.200
     3.816    12.970     0.200
     3.820    13.432     0.200
     3.824    13.882     0.200
     3.859    12.470     0.200
     3.882    12.201     0.200
     4.068    15.232     0.200
     4.596    14.874     0.200
     4.678    15.518     0.200
     5.235    13.912     0.200
     5.746    17.750     0.200
     6.271    17.829     0.200
     6.278    17.749     0.200
    10.750    27.550     0.200
    10.750    29.455     0.200
    12.260    31.437     0.200
    12.656    33.810     0.200
    13.155    30.992     0.200
    17.852    38.175     0.200
    18.475    35.408     0.200
    19.200    38.448     0.200
    19.312    37.137     0.200
    19.958    37.601     0.200
    20.515    37.093     0.200
    20.527    36.954     0.200
    20.628    36.777     0.200
     3.027    14.066     0.200
     3.019    13.162     0.200
     3.496    15.600     0.200
     4.635    16.304     0.200
     5.723    20.607     0.200
     7.104    23.490     0.200
    11.203    34.452     0.200
    18.729    40.233     0.200
    19.194    39.897     0.200
    19.930    45.811     0.200
    20.259    40.570     0.200
     1.880    11.324     0.200
     3.095    11.137     0.200
     3.138    11.635     0.200
     3.275    10.534     0.200
     3.591    13.857     0.200
     3.595    14.803     0.200
     3.610    13.633     0.200
     3.708    13.981     0.200
     4.291    14.178     0.200
     4.646    13.339     0.200
     5.763    18.008     0.200
    11.333    32.003     0.200
    11.648    32.823     0.200
    11.833    35.161     0.200
    12.036    32.798     0.200
    12.343    32.217     0.200
    12.476    30.658     0.200
    12.685    30.220     0.200
    12.716    33.364     0.200
    12.760    34.349     0.200
    12.806    29.818     0.200
    13.207    36.034     0.200
    18.547    40.815     0.200
    18.875    38.584     0.200
    18.875    39.681     0.200
    18.730    41.474     0.200
    19.299    41.036     0.200
    19.356    43.067     0.200
    19.502    41.170     0.200
    19.531    40.827     0.200
    19.768    42.568     0.200
    19.894    42.896     0.200
    19.899    42.933     0.200
    19.937    44.589     0.200
    19.948    42.461     0.200
     3.265    11.784     0.200
     3.311    10.743     0.200
     3.764    11.956     0.200
     3.880    13.605     0.200
     4.781    14.084     0.200
     5.916    17.345     0.200
     7.284    20.875     0.200
    11.382    31.357     0.200
    12.808    33.418     0.200
    17.249    37.586     0.200
    18.507    40.904     0.200
    19.846    40.281     0.200
     1.484     5.319     0.200
     3.358    12.458     0.200
     3.820    14.565     0.200
     3.826    13.492     0.200
     3.832    14.924     0.200
     3.918    13.616     0.200
     7.388    22.417     0.200
    11.290    31.891     0.200
    12.742    32.046     0.200
    17.834    38.717     0.200
    18.111    38.681     0.200
    19.123    40.471     0.200
    19.723    40.475     0.200
    20.012    42.096     0.200
    20.193    42.484     0.200
    20.489    38.335     0.200
    20.775    39.397     0.200
     1.310     7.450     0.200
     3.595    13.385     0.200
     3.597    14.362     0.200
     4.062    14.434     0.200
     4.074    14.793     0.200
     4.072    15.811     0.200
     5.130    16.965     0.200
     6.265    19.722     0.200
    11.291    32.067     0.200
    12.811    35.432     0.200
    17.119    40.052     0.200
    17.198    36.836     0.200
    17.943    38.436     0.200
    18.189    39.573     0.200
     3.172    10.730     0.200
     3.207    11.826     0.200
     3.661    15.027     0.200
     3.666    13.474     0.200
     3.679    14.313     0.200
     4.366    14.801     0.200
     4.722    12.139     0.200
     5.841    16.081     0.200
    10.733    28.495     0.200
    11.321    32.136     0.200
    11.683    30.408     0.200
    11.945    34.858     0.200
    12.114    32.384     0.200
    12.236    34.457     0.200
    12.291    32.314     0.200
    12.438    32.097     0.200
    12.725    32.746     0.200
    17.788    38.367     0.200
    18.498    41.377     0.200
    19.246    42.651     0.200
    19.320    39.284     0.200
    19.843    42.679     0.200
    19.843    43.682     0.200
    20.024    42.570     0.200
    19.958    41.342     0.200
    20.273    41.662     0.200
    20.602    39.830     0.200
     1.401     7.961     0.200
     2.205     9.978     0.200
     3.471    12.710     0.200
     3.515    11.696     0.200
     3.941    14.723     0.200
     3.949    14.636     0.200
     4.013    13.881     0.200
     4.677    14.635     0.200
     6.231    18.804     0.200
    10.718    28.631     0.200
    11.102    32.358     0.200
    11.102    32.159     0.200
    11.135    30.464     0.200
    11.191    32.111     0.200
    12.400    33.009     0.200
    12.609    34.062     0.200
    12.516    33.353     0.200
    12.590    33.034     0.200
    12.615    36.847     0.200
    12.638    33.735     0.200
    12.694    33.579     0.200
    12.820    34.100     0.200
    12.843    34.442     0.200
    13.279    33.746     0.200
    13.431    34.974     0.200
    13.991    35.442     0.200
    18.290    43.727     0.200
    18.596    43.376     0.200
    18.773    38.529     0.200
    18.782    41.530     0.200
    18.866    41.553     0.200
    19.466    40.548     0.200
    20.254    41.847     0.200
    20.386    42.111     0.200
    20.780    40.211     0.200
    20.791    40.088     0.200
    20.909    39.702     0.200
     1.299     8.838     0.200
     2.098     9.511     0.200
     3.623    14.709     0.200
     3.670    13.171     0.200
     4.094    16.713     0.200
     4.163    19.412     0.200
     4.832    18.605     0.200
    12.668    35.163     0.200
    14.134    37.145     0.200
    18.823    39.132     0.200
    18.790    42.713     0.200
    19.393    42.679     0.200
    19.524    41.143     0.200
    20.706    39.353     0.200
    20.716    39.240     0.200
    20.846    40.726     0.200
    20.918    41.883     0.200
     4.012    13.197     0.200
    18.890    41.577     0.200
    19.491    41.556     0.200
    19.620    41.060     0.200
    20.805    40.225     0.200
     1.229     5.988     0.200
     3.605     9.955     0.200
     3.675     9.934     0.200
     4.078    11.731     0.200
     4.084    15.669     0.200
     4.115    11.701     0.200
     4.137    15.044     0.200
     4.826    13.508     0.200
     5.310    14.857     0.200
     6.405    16.585     0.200
     7.786    21.960     0.200
    11.025    31.364     0.200
    14.168    33.590     0.200
    18.709    40.991     0.200
    19.311    41.968     0.200
    19.440    39.459     0.200
    20.071    38.097     0.200
    20.368    37.631     0.200
    20.625    37.638     0.200
    20.635    37.521     0.200
    20.761    37.048     0.200
    20.835    37.180     0.200
     1.799     9.479     0.200
     3.222    13.574     0.200
     3.680    14.225     0.200
     3.681    14.819     0.200
     3.695    15.060     0.200
     3.789    14.459     0.200
     4.382    16.040     0.200
     4.737    15.890     0.200
     5.838    17.041     0.200
     5.857    18.921     0.200
    11.321    33.162     0.200
    13.606    35.898     0.200
    17.197    40.490     0.200
    18.093    39.526     0.200
    19.237    41.683     0.200
    19.858    42.433     0.200
    20.039    43.324     0.200
    20.288    43.417     0.200
    20.336    39.860     0.200
    12.041    31.328     0.200
    13.484    34.693     0.200
    17.679    35.539     0.200
    18.130    37.968     0.200
    18.234    35.960     0.200
    20.067    36.361     0.200
     0.728     5.524     0.200
     3.534    14.280     0.200
     3.565    14.912     0.200
     3.673    13.657     0.200
     4.013    15.188     0.200
     4.043    15.329     0.200
     4.072    14.991     0.200
     4.786    16.664     0.200
     4.893    20.720     0.200
     5.276    18.646     0.200
     5.405    17.938     0.200
     6.453    20.704     0.200
     6.460    19.623     0.200
     7.846    23.450     0.200
     9.582    26.497     0.200
     9.758    25.143     0.200
     9.947    27.936     0.200
    10.040    26.848     0.200
    11.204    32.271     0.200
    16.728    36.302     0.200
    18.550    36.537     0.200
    19.096    41.166     0.200
    19.217    40.754     0.200
    19.855    39.306     0.200
    20.411    38.822     0.200
    20.422    37.694     0.200
    20.536    38.366     0.200
     2.790    13.474     0.200
     2.862    12.532     0.200
     3.209    16.078     0.200
     3.299    13.535     0.200
     3.735    16.142     0.200
     5.548    19.786     0.200
     5.801    23.042     0.200
     6.694    24.617     0.200
    17.948    36.683     0.200
    18.174    36.646     0.200
    18.468    36.806     0.200
    18.930    36.119     0.200
    19.802    41.946     0.200
    19.891    37.901     0.200
    20.557    40.132     0.200
     1.973    10.346     0.200
     2.926    12.005     0.200
     2.960    10.601     0.200
     2.988    12.282     0.200
     3.405    12.612     0.200
     3.498    14.524     0.200
     3.644    14.822     0.200
     3.841    13.028     0.200
     5.699    18.345     0.200
     5.994    17.405     0.200
     6.120    19.730     0.200
    19.181    39.010     0.200
    19.773    39.103     0.200
    20.529    38.273     0.200
     2.415    10.614     0.200
     3.732    13.995     0.200
     3.742    13.387     0.200
     3.930    14.183     0.200
     4.055    13.224     0.200
     4.194    16.112     0.200
     4.696    17.248     0.200
    16.485    34.675     0.200
    19.465    37.396     0.200
    20.020    37.913     0.200
    20.146    36.443     0.200
    20.227    35.496     0.200
     0.949     4.538     0.200
     1.393     7.363     0.200
     2.404    10.056     0.200
     3.558    11.892     0.200
     3.612    10.957     0.200
     4.006    16.368     0.200
     4.449    17.691     0.200
     4.465    15.105     0.200
     4.757    17.100     0.200
     5.270    13.911     0.200
     5.628    17.535     0.200
     6.360    18.488     0.200
     7.738    20.316     0.200
    10.975    30.630     0.200
    18.706    41.319     0.200
    19.274    38.985     0.200
    19.306    40.312     0.200
    19.431    37.853     0.200
    19.871    38.317     0.200
    20.066    37.447     0.200
    20.620    37.976     0.200
    20.631    36.854     0.200
    20.751    37.454     0.200
    20.829    39.539     0.200
     0.926     6.111     0.200
     1.118     7.879     0.200
     1.273     8.361     0.200
     2.124    10.132     0.200
     3.432    10.573     0.200
     3.391    12.154     0.200
     3.444    13.635     0.200
     4.219    15.493     0.200
     4.513    14.359     0.200
     5.387    17.954     0.200
     5.659    18.184     0.200
     6.176    18.646     0.200
     6.353    18.588     0.200
     7.563    19.462     0.200
    17.989    36.490     0.200
    18.463    38.864     0.200
    18.500    35.721     0.200
    19.301    40.080     0.200
     0.194    11.545     0.200
     0.572     9.132     0.200
     0.795     7.528     0.200
     2.247    12.381     0.200
     2.955    12.916     0.200
     4.083    16.161     0.200
     4.571    17.958     0.200
     4.603    18.092     0.200
     4.889    15.355     0.200
     4.905    18.762     0.200
     5.787    21.168     0.200
     6.753    23.602     0.200
     8.156    23.626     0.200
    17.001    32.606     0.200
    17.181    35.944     0.200
    17.704    33.877     0.200
    18.410    34.566     0.200
    19.094    36.365     0.200
    19.629    35.628     0.200
     0.965     5.600     0.200
     1.126     7.220     0.200
     2.412    10.709     0.200
     3.462    13.954     0.200
     3.660    14.643     0.200
     3.782    13.227     0.200
     3.816    12.623     0.200
     4.110    12.900     0.200
     4.110    14.891     0.200
     4.175    11.635     0.200
     4.593    15.765     0.200
     5.382    16.650     0.200
     6.574    19.945     0.200
    11.318    29.782     0.200
    16.629    35.876     0.200
    16.717    35.870     0.200
    18.452    38.629     0.200
    19.001    39.484     0.200
    19.566    38.039     0.200
    20.099    38.172     0.200
    20.446    37.409     0.200
     1.601     8.142     0.200
     1.559     8.427     0.200
     1.706     9.213     0.200
     2.633     8.500     0.200
     2.757    10.251     0.200
     3.031    10.755     0.200
     3.480    11.712     0.200
     3.770    12.518     0.200
     4.641    14.859     0.200
     6.144    19.324     0.200
     9.316    21.900     0.200
    10.188    27.531     0.200
    10.922    27.666     0.200
    10.922    28.064     0.200
    10.922    28.468     0.200
    16.521    33.790     0.200
    17.791    35.903     0.200
    18.312    34.717     0.200
    18.391    35.497     0.200
     0.099    13.219     0.200
     0.463    10.169     0.200
     2.356    11.678     0.200
     2.652    10.626     0.200
     2.884    12.817     0.200
     3.901    13.051     0.200
     4.030    14.448     0.200
     4.160    14.831     0.200
     4.222    15.912     0.200
     4.257    14.696     0.200
     4.291    14.900     0.200
     4.311    14.863     0.200
     4.436    15.309     0.200
     4.569    15.352     0.200
     4.716    17.141     0.200
     4.750    16.945     0.200
     4.690    14.642     0.200
     5.054    17.802     0.200
     5.935    19.116     0.200
     5.987    18.211     0.200
     6.933    22.370     0.200
     7.899    20.198     0.200
     7.991    22.618     0.200
    10.018    26.671     0.200
    15.999    32.305     0.200
    17.084    34.504     0.200
    17.806    33.978     0.200
    17.964    33.432     0.200
    18.293    37.200     0.200
    18.464    33.507     0.200
    19.302    37.924     0.200
    19.422    34.717     0.200
    19.721    33.968     0.200
    19.743    33.705     0.200
     1.423     6.891     0.200
     1.682     9.139     0.200
     2.239    10.851     0.200
     2.369    10.105     0.200
     2.692    10.123     0.200
     3.122    11.358     0.200
     3.206    12.309     0.200
     3.237    12.530     0.200
     3.279    13.284     0.200
     3.513    13.807     0.200
     3.655    14.362     0.200
     3.679    13.514     0.200
     3.696    14.427     0.200
     3.705    14.250     0.200
     3.816    14.393     0.200
     3.845    14.297     0.200
     3.852    14.545     0.200
     4.129    15.461     0.200
     4.151    14.470     0.200
     5.277    18.654     0.200
     5.944    20.077     0.200
     6.063    18.763     0.200
     6.871    20.836     0.200
     7.147    21.162     0.200
     8.028    21.339     0.200
     9.154    27.457     0.200
     9.859    28.012     0.200
    10.655    30.504     0.200
    11.196    30.303     0.200
    17.755    37.867     0.200
    17.992    36.398     0.200
    19.103    39.456     0.200
    19.664    38.685     0.200
    19.664    39.271     0.200
    20.851    38.137     0.200
     1.421     8.565     0.200
     2.309    11.876     0.200
     2.441    11.662     0.200
     2.686    11.898     0.200
     3.116    13.677     0.200
     3.237    13.103     0.200
     3.268    12.752     0.200
     3.331    14.705     0.200
     3.562    16.274     0.200
     3.699    15.376     0.200
     3.744    15.198     0.200
     3.756    15.128     0.200
     3.865    15.402     0.200
     3.896    15.260     0.200
     4.170    17.147     0.200
     4.203    16.111     0.200
     4.835    17.399     0.200
     5.314    19.787     0.200
     5.956    22.196     0.200
     6.113    20.550     0.200
    11.268    32.088     0.200
    18.881    38.548     0.200
    19.710    40.769     0.200
     1.113     6.510     0.200
     2.130    11.590     0.200
     2.383     9.852     0.200
     2.512    12.777     0.200
     2.813    12.907     0.200
     2.961    12.640     0.200
     3.064    14.192     0.200
     3.286    16.089     0.200
     3.411    14.600     0.200
     3.465    13.754     0.200
     3.486    16.845     0.200
     3.609    14.574     0.200
     3.626    15.182     0.200
     3.877    16.208     0.200
     5.013    21.187     0.200
     5.641    20.638     0.200
    11.325    33.430     0.200
    18.866    41.029     0.200
    19.921    40.915     0.200
     1.252     7.413     0.200
     1.799    10.722     0.200
     2.179    11.786     0.200
     2.448    11.494     0.200
     2.521    10.326     0.200
     2.951    11.889     0.200
     3.086    12.231     0.200
     3.162    14.131     0.200
     3.389    14.544     0.200
     3.522    14.676     0.200
     3.539    13.742     0.200
     3.570    13.336     0.200
     3.586    14.873     0.200
     3.693    15.328     0.200
     3.720    15.100     0.200
     3.726    15.121     0.200
     3.991    16.461     0.200
     4.034    15.062     0.200
     4.274    14.727     0.200
     5.133    16.198     0.200
     5.778    20.978     0.200
     6.203    20.108     0.200
    10.486    31.321     0.200
    17.076    37.225     0.200
    17.776    39.053     0.200
    18.014    39.474     0.200
    19.808    40.683     0.200
     1.157     6.139     0.200
     1.961    11.026     0.200
     2.265    11.369     0.200
     2.417     9.383     0.200
     2.607    11.734     0.200
     2.846    11.396     0.200
     3.026    12.354     0.200
     3.055    12.698     0.200
     3.186    12.501     0.200
     3.522    14.536     0.200
     3.528    13.091     0.200
     3.581    14.792     0.200
     3.607    14.599     0.200
     3.721    15.313     0.200
     3.985    15.694     0.200
     4.055    14.999     0.200
     4.263    16.874     0.200
     4.567    14.852     0.200
     5.114    18.900     0.200
     5.705    20.228     0.200
    11.427    32.032     0.200
    18.151    38.868     0.200
    19.963    39.919     0.200
     0.553     8.347     0.200
     1.549     8.315     0.200
     1.860     8.719     0.200
     2.017    10.090     0.200
     2.087     8.885     0.200
     3.338    13.363     0.200
     3.516    13.057     0.200
     3.600    13.921     0.200
     3.750    14.414     0.200
     3.760    12.765     0.200
     3.782    14.203     0.200
     3.792    14.268     0.200
     3.792    14.778     0.200
     3.885    14.354     0.200
     4.184    15.792     0.200
     4.249    15.308     0.200
     4.298    15.800     0.200
     4.298    15.930     0.200
     4.298    16.201     0.200
     4.564    16.953     0.200
     5.213    16.123     0.200
     5.429    16.612     0.200
     5.480    19.286     0.200
     6.396    20.397     0.200
     6.402    20.775     0.200
     7.439    22.303     0.200
    10.364    28.791     0.200
    12.835    29.426     0.200
    13.255    33.504     0.200
    18.833    36.903     0.200
    19.646    35.527     0.200
    19.908    34.789     0.200
    20.036    33.852     0.200
     1.217     6.889     0.200
     1.451     8.302     0.200
     2.362    10.729     0.200
     2.488    10.297     0.200
     2.667    10.382     0.200
     2.964    11.851     0.200
     2.918    11.019     0.200
     2.995    13.024     0.200
     3.046    13.001     0.200
     3.147    13.821     0.200
     3.276    13.233     0.200
     3.415    14.845     0.200
     3.437    14.156     0.200
     3.459    13.074     0.200
     3.459    15.387     0.200
     3.471    15.147     0.200
     3.558    15.222     0.200
     3.611    15.646     0.200
     3.833    17.491     0.200
     3.887    15.596     0.200
     3.887    16.455     0.200
     3.887    17.549     0.200
     3.952    14.818     0.200
     4.128    16.190     0.200
     4.280    18.993     0.200
     5.035    16.231     0.200
     5.714    20.258     0.200
    11.177    31.457     0.200
    11.177    32.794     0.200
    12.540    34.554     0.200
    19.775    40.544     0.200
    20.515    38.813     0.200
    20.738    39.647     0.200
    20.835    38.269     0.200
    20.961    38.031     0.200
     1.359     7.297     0.200
     2.365    11.753     0.200
     2.476    12.056     0.200
     2.462    11.058     0.200
     2.731    11.162     0.200
     3.160    11.975     0.200
     3.296    12.319     0.200
     3.392    14.505     0.200
     3.490    13.627     0.200
     3.623    16.703     0.200
     3.703    15.084     0.200
     3.805    17.587     0.200
     3.817    16.558     0.200
     3.911    17.153     0.200
     4.179    18.192     0.200
     4.230    15.823     0.200
     4.298    14.709     0.200
     4.468    17.463     0.200
     4.621    19.359     0.200
     5.373    18.802     0.200
     6.009    19.166     0.200
    11.289    32.932     0.200
    11.289    32.251     0.200
    12.737    35.894     0.200
    14.184    38.138     0.200
    15.895    39.252     0.200
    16.405    39.365     0.200
    16.485    38.694     0.200
    18.972    42.296     0.200
    19.697    40.961     0.200
    20.584    40.398     0.200
     2.139    12.461     0.200
     2.767    14.356     0.200
     4.037    17.685     0.200
     4.321    18.085     0.200
     4.338    19.106     0.200
     4.467    17.795     0.200
     4.588    19.328     0.200
     4.702    20.358     0.200
     4.744    20.540     0.200
     4.782    20.131     0.200
     4.778    20.610     0.200
     4.781    18.638     0.200
     4.844    20.210     0.200
     4.881    18.317     0.200
     4.935    21.456     0.200
     5.169    20.006     0.200
     5.243    18.864     0.200
     5.271    21.410     0.200
     5.271    21.754     0.200
     5.532    23.485     0.200
     6.448    21.513     0.200
     7.259    24.424     0.200
    10.672    33.188     0.200
    10.672    34.479     0.200
    11.720    35.558     0.200
    12.453    37.538     0.200
    13.520    38.332     0.200
    13.592    37.243     0.200
    18.534    44.477     0.200
    20.269    41.335     0.200
    21.007    40.907     0.200
    21.010    41.092     0.200
    20.976    41.872     0.200
     1.148     6.872     0.200
     2.045    11.846     0.200
     2.111    10.918     0.200
     2.419    11.611     0.200
     2.468    11.041     0.200
     2.746    11.288     0.200
     2.849    11.084     0.200
     2.946    13.751     0.200
     3.064    12.990     0.200
     3.176    13.258     0.200
     3.288    14.573     0.200
     3.432    15.764     0.200
     3.469    13.358     0.200
     3.469    15.178     0.200
     3.469    15.358     0.200
     3.487    13.823     0.200
     3.568    16.210     0.200
     3.582    13.954     0.200
     3.627    15.521     0.200
     3.840    16.017     0.200
     3.886    15.504     0.200
     3.886    15.832     0.200
     3.886    16.164     0.200
     3.965    14.912     0.200
     4.122    14.249     0.200
     4.562    16.033     0.200
     4.701    16.632     0.200
     5.026    15.910     0.200
     5.661    19.868     0.200
     5.668    20.510     0.200
     6.069    20.691     0.200
     6.595    20.699     0.200
     7.761    24.391     0.200
     9.584    28.992     0.200
    10.135    29.077     0.200
    10.379    31.091     0.200
    11.282    32.053     0.200
    11.825    35.640     0.200
    12.065    37.121     0.200
    12.236    37.240     0.200
    12.635    33.214     0.200
    13.354    32.269     0.200
    13.692    31.869     0.200
    16.968    36.846     0.200
    18.292    36.779     0.200
    18.796    42.861     0.200
    18.912    42.858     0.200
    19.074    40.919     0.200
    19.288    42.764     0.200
    19.416    44.005     0.200
    19.439    44.859     0.200
    19.686    43.031     0.200
    19.720    41.442     0.200
    19.875    40.747     0.200
    19.818    42.277     0.200
    19.819    42.402     0.200
    20.117    41.917     0.200
    20.476    41.381     0.200
    20.841    39.724     0.200
     1.094     5.724     0.200
     1.975    11.184     0.200
     2.366     9.241     0.200
     2.451    10.945     0.200
     2.795     9.747     0.200
     2.791    11.883     0.200
     2.870    11.799     0.200
     2.985    12.753     0.200
     3.098    13.460     0.200
     3.209    12.435     0.200
     3.354    13.106     0.200
     3.390    14.380     0.200
     3.408    14.747     0.200
     3.489    13.915     0.200
     3.503    13.440     0.200
     3.548    13.882     0.200
     3.761    13.882     0.200
     3.807    13.987     0.200
     3.807    14.507     0.200
     3.807    14.929     0.200
     3.885    13.856     0.200
     4.044    14.796     0.200
     4.505    14.948     0.200
     4.948    15.014     0.200
     5.601    17.479     0.200
    11.257    32.513     0.200
    11.257    31.422     0.200
    12.591    33.654     0.200
    14.164    36.802     0.200
    16.585    35.780     0.200
    16.924    37.162     0.200
    19.073    41.169     0.200
    19.893    40.497     0.200
     1.108     6.482     0.200
     2.050    11.080     0.200
     2.378     9.743     0.200
     2.503    11.697     0.200
     2.808    10.822     0.200
     2.788    12.904     0.200
     2.919    12.175     0.200
     3.050    14.488     0.200
     3.166    12.715     0.200
     3.272    14.407     0.200
     3.410    13.486     0.200
     3.452    14.812     0.200
     3.452    15.452     0.200
     3.473    13.676     0.200
     3.548    14.374     0.200
     3.569    14.721     0.200
     3.613    13.590     0.200
     3.821    16.381     0.200
     3.864    15.105     0.200
     3.864    15.723     0.200
     3.948    14.945     0.200
     4.099    15.032     0.200
     4.522    15.568     0.200
     5.001    16.227     0.200
     5.633    19.854     0.200
     6.556    20.292     0.200
    11.315    31.346     0.200
    11.315    32.051     0.200
    16.992    37.294     0.200
    19.918    40.395     0.200
     1.219     7.943     0.200
     2.127    10.688     0.200
     2.487    12.331     0.200
     2.487    11.581     0.200
     2.689    12.600     0.200
     2.917    11.560     0.200
     3.038    14.304     0.200
     3.158    13.650     0.200
     3.269    15.419     0.200
     3.383    14.583     0.200
     3.563    14.922     0.200
     3.563    15.516     0.200
     3.582    14.133     0.200
     3.663    14.763     0.200
     3.675    15.783     0.200
     3.722    15.632     0.200
     3.934    15.928     0.200
     3.980    15.153     0.200
     3.980    16.880     0.200
     4.059    14.301     0.200
     4.634    16.621     0.200
     5.119    16.722     0.200
     5.751    19.487     0.200
    11.308    31.581     0.200
     1.136     6.174     0.200
     2.091    10.118     0.200
     2.404    10.396     0.200
     2.519     9.990     0.200
     2.834    11.651     0.200
     3.094    12.815     0.200
     3.210    12.312     0.200
     3.316    12.898     0.200
     3.452    12.825     0.200
     3.495    14.206     0.200
     3.495    15.444     0.200
     3.591    13.404     0.200
     3.613    15.196     0.200
     3.657    13.922     0.200
     3.865    17.236     0.200
     3.907    15.121     0.200
     3.907    15.550     0.200
     3.992    13.908     0.200
     4.141    15.967     0.200
     4.550    15.355     0.200
     4.754    16.773     0.200
     5.043    17.871     0.200
     5.667    18.770     0.200
    11.334    34.385     0.200
    11.334    31.538     0.200
    13.404    33.735     0.200
    18.343    39.290     0.200
    19.120    41.523     0.200
    19.914    39.540     0.200
     1.283     5.952     0.200
     2.210    10.661     0.200
     2.453    10.780     0.200
     2.551    12.831     0.200
     2.627    10.531     0.200
     2.981    10.297     0.200
     3.092    13.905     0.200
     3.199    13.570     0.200
     3.304    14.311     0.200
     3.426    16.616     0.200
     3.623    16.302     0.200
     3.710    15.702     0.200
     3.714    17.453     0.200
     3.763    15.508     0.200
     3.980    13.433     0.200
     4.029    18.663     0.200
     4.102    16.057     0.200
     4.266    18.285     0.200
     5.171    17.730     0.200
     5.812    20.192     0.200
    11.278    33.390     0.200
    11.278    32.852     0.200
    12.671    33.850     0.200
    17.003    37.790     0.200
     1.143     7.402     0.200
     1.545     9.773     0.200
     2.462    12.115     0.200
     2.844    11.431     0.200
     3.054    13.399     0.200
     3.165    14.330     0.200
     3.459    12.994     0.200
     3.477    15.742     0.200
     3.571    15.884     0.200
     3.617    15.167     0.200
     3.830    17.792     0.200
     3.876    16.224     0.200
     3.876    16.712     0.200
     3.954    17.689     0.200
     4.112    15.865     0.200
     4.693    17.966     0.200
     5.016    15.747     0.200
     5.662    20.835     0.200
    10.373    33.880     0.200
    11.275    33.374     0.200
    11.275    32.701     0.200
    12.626    34.517     0.200
    13.344    34.104     0.200
    14.181    35.978     0.200
    18.775    39.448     0.200
    18.792    43.018     0.200
    18.868    41.718     0.200
    18.907    44.473     0.200
    19.070    42.160     0.200
    19.181    43.044     0.200
    19.783    42.068     0.200
    19.813    42.085     0.200
    19.812    42.943     0.200
    19.815    41.907     0.200
    19.955    42.688     0.200
    19.874    42.157     0.200
    20.112    42.666     0.200
    20.839    41.766     0.200
     1.222     7.236     0.200
     1.321     6.515     0.200
     1.908     8.768     0.200
     2.406    11.529     0.200
     2.469    10.861     0.200
     2.662    11.431     0.200
     2.769    12.681     0.200
     2.877    10.422     0.200
     2.851    13.839     0.200
     2.907    14.118     0.200
     2.998    14.310     0.200
     3.239    12.614     0.200
     3.326    13.752     0.200
     3.333    14.580     0.200
     3.594    13.942     0.200
     4.494    15.960     0.200
     4.510    16.673     0.200
     5.418    16.682     0.200
     7.101    22.862     0.200
     1.259     6.249     0.200
     1.745    10.584     0.200
     2.048    11.399     0.200
     2.113    11.589     0.200
     2.382    10.443     0.200
     2.530     9.670     0.200
     2.960    10.195     0.200
     3.027    12.744     0.200
     3.114    14.219     0.200
     3.215    12.671     0.200
     3.344    14.294     0.200
     3.425    13.610     0.200
     3.481    13.577     0.200
     3.503    14.730     0.200
     3.526    14.397     0.200
     3.538    14.955     0.200
     3.633    13.910     0.200
     3.900    15.438     0.200
     3.953    13.989     0.200
     3.953    15.309     0.200
     3.953    16.819     0.200
     4.019    14.809     0.200
     4.671    14.735     0.200
     5.100    18.234     0.200
     5.761    18.638     0.200
     5.768    19.931     0.200
     6.147    19.923     0.200
     6.704    20.533     0.200
     7.499    21.801     0.200
    10.485    31.889     0.200
    11.203    30.675     0.200
    11.203    32.806     0.200
    12.582    33.632     0.200
    13.329    33.853     0.200
    14.106    36.597     0.200
    15.913    38.739     0.200
    16.354    38.680     0.200
    16.914    38.149     0.200
    18.264    39.887     0.200
    18.973    41.178     0.200
     1.070     7.458     0.200
     1.869    10.780     0.200
     1.961    12.465     0.200
     2.342    11.336     0.200
     2.457    11.792     0.200
     2.772    12.503     0.200
     2.844    14.463     0.200
     3.366    14.524     0.200
     4.019    15.804     0.200
     4.923    19.655     0.200
     5.576    20.016     0.200
     7.308    20.779     0.200
    11.261    34.875     0.200
    16.920    38.393     0.200
    19.084    43.261     0.200
     2.190    10.173     0.200
     2.110    11.972     0.200
     2.124    13.072     0.200
     2.191    12.577     0.200
     2.619    12.391     0.200
     2.706    12.854     0.200
     2.821    13.390     0.200
     2.996    11.984     0.200
     3.408    15.590     0.200
     3.442    15.896     0.200
     3.582    15.933     0.200
     3.795    16.029     0.200
     3.795    16.990     0.200
     4.339    15.542     0.200
     4.915    18.493     0.200
     5.471    19.626     0.200
     5.479    19.142     0.200
     7.221    23.104     0.200
    11.506    35.092     0.200
    11.506    34.630     0.200
    12.812    34.873     0.200
    13.473    34.464     0.200
    16.277    40.564     0.200
    16.683    40.235     0.200
    16.840    41.409     0.200
    17.145    39.738     0.200
    19.330    42.630     0.200
     1.994     9.993     0.200
     2.634    10.961     0.200
     2.777    11.738     0.200
     3.906    13.003     0.200
     4.268    15.033     0.200
     4.265    15.811     0.200
     4.336    14.926     0.200
     4.667    15.864     0.200
     5.092    15.551     0.200
     5.092    20.926     0.200
     5.353    15.573     0.200
    10.594    31.745     0.200
    10.594    31.106     0.200
    12.332    33.024     0.200
    13.438    30.907     0.200
    15.570    38.240     0.200
     1.102     6.768     0.200
     1.529     8.754     0.200
     1.762     8.967     0.200
     1.801     9.157     0.200
     2.367     9.611     0.200
     2.315    10.899     0.200
     2.785    10.478     0.200
     2.795    10.267     0.200
     2.775    10.985     0.200
     2.844    12.370     0.200
     3.075    11.917     0.200
     3.157    12.136     0.200
     3.215    12.643     0.200
     3.240    12.288     0.200
     3.257    16.230     0.200
     3.257    11.223     0.200
     3.268    16.375     0.200
     3.356    14.598     0.200
     3.367    13.552     0.200
     3.408    12.679     0.200
     3.689    13.370     0.200
     3.689    15.386     0.200
     3.750    12.972     0.200
     4.513    15.061     0.200
     4.840    16.757     0.200
     5.543    18.480     0.200
     5.550    18.311     0.200
     7.273    21.290     0.200
    11.107    31.466     0.200
    11.107    31.566     0.200
    18.958    39.900     0.200
    19.625    37.540     0.200
     1.853     9.348     0.200
     2.090     9.511     0.200
     1.991    11.516     0.200
     2.115    11.029     0.200
     2.520    11.402     0.200
     2.672    12.113     0.200
     2.668    11.333     0.200
     3.071    11.054     0.200
     3.140    13.109     0.200
     3.184    13.404     0.200
     3.252    14.007     0.200
     3.252    15.264     0.200
     3.287    17.883     0.200
     3.333    17.078     0.200
     3.397    12.801     0.200
     3.642    14.831     0.200
     3.642    12.659     0.200
     3.753    14.612     0.200
     4.764    17.528     0.200
     5.345    18.669     0.200
     5.353    18.751     0.200
     7.091    22.224     0.200
    11.447    35.304     0.200
    11.447    32.883     0.200
    17.049    38.907     0.200
    19.315    42.129     0.200
    19.967    39.058     0.200
    20.901    39.945     0.200
     1.437     8.883     0.200
     1.639     9.877     0.200
     2.141    12.371     0.200
     2.323    11.047     0.200
     2.461    10.998     0.200
     2.707    12.029     0.200
     3.137    13.263     0.200
     3.199    13.814     0.200
     3.494    16.097     0.200
     3.640    15.627     0.200
     3.678    14.585     0.200
     3.678    15.647     0.200
     3.684    14.475     0.200
     3.792    14.806     0.200
     4.055    16.245     0.200
     4.115    17.036     0.200
     4.115    17.286     0.200
     4.115    17.927     0.200
     4.850    17.836     0.200
     5.266    18.354     0.200
     5.368    18.638     0.200
     5.941    21.377     0.200
     5.949    20.329     0.200
     6.015    17.276     0.200
     7.679    24.107     0.200
    11.150    32.791     0.200
    11.150    33.011     0.200
    11.433    33.855     0.200
    12.557    36.078     0.200
    13.373    35.397     0.200
    14.049    36.404     0.200
    14.839    38.051     0.200
    18.301    40.044     0.200
    18.869    42.826     0.200
    19.018    40.073     0.200
    19.069    44.133     0.200
    19.652    41.049     0.200
    19.628    43.595     0.200
    20.067    42.049     0.200
    20.459    40.596     0.200
    20.521    40.565     0.200
    20.855    39.454     0.200
    20.981    39.843     0.200
     1.211     5.204     0.200
     1.983     6.803     0.200
     2.538     9.598     0.200
     2.728    11.830     0.200
     3.230     9.909     0.200
     3.656    11.140     0.200
     3.833    12.703     0.200
     4.139    14.779     0.200
     4.225    16.011     0.200
     4.285    13.972     0.200
     4.310    14.701     0.200
     4.323    14.418     0.200
     4.323    16.589     0.200
     4.466    14.656     0.200
     4.760    14.244     0.200
     4.760    15.365     0.200
     4.760    17.283     0.200
     4.851    15.820     0.200
     5.861    14.607     0.200
     5.908    17.903     0.200
     6.529    20.021     0.200
     6.537    19.858     0.200
     8.277    23.296     0.200
     8.799    23.869     0.200
    11.308    29.984     0.200
    11.308    30.501     0.200
    12.898    32.057     0.200
    13.826    32.655     0.200
    14.185    35.779     0.200
    14.232    35.473     0.200
    14.573    32.518     0.200
    14.996    36.338     0.200
    17.220    36.267     0.200
    18.816    40.551     0.200
    19.422    40.389     0.200
    19.538    39.768     0.200
    19.774    37.887     0.200
    20.273    38.923     0.200
     1.276     6.591     0.200
     1.276     6.318     0.200
     1.603     7.275     0.200
     2.057     9.294     0.200
     2.267     8.939     0.200
     2.477     9.160     0.200
     2.681    11.986     0.200
     3.111     9.895     0.200
     3.137    10.219     0.200
     3.137    12.195     0.200
     3.420    12.442     0.200
     3.420    15.833     0.200
     3.507    13.296     0.200
     3.569    13.565     0.200
     3.598    13.242     0.200
     3.598    14.351     0.200
     3.604    13.665     0.200
     3.604    13.923     0.200
     3.608    12.449     0.200
     3.608    15.410     0.200
     3.748    13.997     0.200
     3.748    16.575     0.200
     4.045    14.160     0.200
     4.045    14.957     0.200
     4.045    16.839     0.200
     4.532    14.059     0.200
     4.532    17.520     0.200
     5.301    15.797     0.200
     5.895    16.677     0.200
     5.903    20.138     0.200
     5.903    19.099     0.200
     7.630    20.447     0.200
    11.093    31.932     0.200
     1.279     7.150     0.200
     1.548     7.388     0.200
     1.680     9.202     0.200
     2.407    12.026     0.200
     2.390    11.563     0.200
     2.812     9.141     0.200
     3.242    12.691     0.200
     3.750    13.901     0.200
     3.832    14.346     0.200
     3.849    13.891     0.200
     3.849    14.191     0.200
     3.849    18.051     0.200
     4.282    15.625     0.200
     4.282    16.595     0.200
     4.522    16.776     0.200
     4.697    18.019     0.200
     5.429    17.673     0.200
     5.532    19.462     0.200
     6.075    20.183     0.200
     6.083    21.014     0.200
     6.461    20.550     0.200
     7.296    22.325     0.200
     7.818    23.436     0.200
    10.550    29.057     0.200
    11.231    31.369     0.200
    13.522    34.580     0.200
    13.740    36.926     0.200
    14.920    38.101     0.200
    17.028    37.551     0.200
    19.048    40.946     0.200
    19.167    39.158     0.200
    19.614    41.075     0.200
    20.069    41.051     0.200
    20.413    39.901     0.200
    20.575    38.891     0.200
    20.962    39.628     0.200
     2.171    10.668     0.200
     2.486    12.947     0.200
     3.312    12.391     0.200
     3.741    12.845     0.200
     3.741    13.345     0.200
     3.767    13.596     0.200
     4.180    17.224     0.200
     4.206    15.532     0.200
     4.206    18.602     0.200
     4.485    18.357     0.200
     4.645    18.798     0.200
     5.558    18.039     0.200
     6.543    22.164     0.200
     6.550    21.571     0.200
     8.276    25.386     0.200
    10.944    31.215     0.200
    13.411    37.109     0.200
    15.550    36.013     0.200
    16.750    37.705     0.200
    16.855    37.869     0.200
    19.144    42.815     0.200
    19.414    41.692     0.200
    19.618    42.420     0.200
     1.795    10.538     0.200
     1.860     9.397     0.200
     2.200    10.106     0.200
     2.500     9.640     0.200
     2.791    11.189     0.200
     2.870    11.848     0.200
     2.928    12.185     0.200
     3.136    12.773     0.200
     3.288    12.171     0.200
     3.321    12.093     0.200
     3.321    12.734     0.200
     3.321    13.890     0.200
     3.321    13.033     0.200
     3.440    13.141     0.200
     3.464    12.974     0.200
     3.766    12.004     0.200
     3.766    13.949     0.200
     3.766    14.223     0.200
     4.517    15.922     0.200
     4.620    13.504     0.200
     5.659    19.025     0.200
     5.666    20.631     0.200
     5.940    19.248     0.200
    12.347    30.438     0.200
    15.786    35.015     0.200
    16.528    37.121     0.200
    16.679    36.683     0.200
    18.012    36.950     0.200
     2.106     9.960     0.200
     2.887    13.365     0.200
     4.294    13.372     0.200
     4.382    16.388     0.200
     4.351    16.292     0.200
     4.694    17.260     0.200
     4.694    19.979     0.200
     4.758    16.999     0.200
     5.051    15.982     0.200
     5.185    18.068     0.200
     6.017    16.912     0.200
     6.378    18.344     0.200
     7.164    20.237     0.200
     7.171    22.343     0.200
     7.582    23.029     0.200
     7.967    22.522     0.200
     7.967    25.968     0.200
     8.128    24.924     0.200
     8.889    26.527     0.200
    12.436    34.307     0.200
    13.553    33.761     0.200
    14.913    37.695     0.200
    15.608    37.361     0.200
    15.639    38.711     0.200
    15.702    39.243     0.200
    15.799    39.707     0.200
    15.959    39.700     0.200
    16.345    37.992     0.200
    16.403    39.831     0.200
    16.403    40.206     0.200
    16.737    37.710     0.200
    18.033    40.300     0.200
    18.591    41.470     0.200
    20.272    40.958     0.200
     1.784     7.768     0.200
     2.137     8.336     0.200
     2.128    10.647     0.200
     2.522    12.484     0.200
     2.580    11.373     0.200
     3.407    11.610     0.200
     3.768    13.368     0.200
     3.837    12.696     0.200
     3.837    13.567     0.200
     3.844    14.296     0.200
     4.156    15.871     0.200
     4.242    15.506     0.200
     4.242    15.647     0.200
     4.276    14.377     0.200
     4.362    18.028     0.200
     4.381    16.470     0.200
     4.628    18.556     0.200
     4.713    16.979     0.200
     4.713    18.878     0.200
     4.713    17.479     0.200
     5.495    17.865     0.200
     5.876    18.903     0.200
     6.631    19.579     0.200
     6.638    20.514     0.200
     6.873    20.573     0.200
     7.004    20.932     0.200
     7.033    21.370     0.200
     7.065    21.584     0.200
     7.496    21.947     0.200
     7.584    22.861     0.200
     8.361    23.102     0.200
     8.475    23.066     0.200
     8.475    26.332     0.200
     8.683    26.266     0.200
    12.496    31.846     0.200
    13.341    35.727     0.200
    13.474    33.340     0.200
    15.305    38.173     0.200
    15.535    37.309     0.200
    15.895    38.246     0.200
    15.894    38.616     0.200
    16.235    38.118     0.200
    16.499    36.358     0.200
    16.678    38.443     0.200
    16.814    37.254     0.200
    18.403    40.390     0.200
    18.415    40.593     0.200
    18.440    39.557     0.200
    18.489    41.059     0.200
    18.543    39.988     0.200
    18.761    40.447     0.200
    18.796    39.999     0.200
    18.995    40.003     0.200
    19.049    40.173     0.200
    19.049    40.762     0.200
    19.103    39.692     0.200
    19.447    40.158     0.200
    19.727    38.819     0.200
    19.792    40.170     0.200
    19.924    39.576     0.200
    20.010    39.470     0.200
    20.204    39.247     0.200
    20.569    39.357     0.200
     0.950     6.349     0.200
     1.488     7.546     0.200
     1.488     7.429     0.200
     1.473     9.816     0.200
     1.473     9.714     0.200
     1.805     8.876     0.200
     2.543    10.563     0.200
     2.543     8.813     0.200
     2.698    10.249     0.200
     2.830    11.049     0.200
     2.838    11.461     0.200
     2.838    11.789     0.200
     3.115    10.912     0.200
     3.115    11.592     0.200
     3.086    11.965     0.200
     3.167    13.082     0.200
     3.167    15.535     0.200
     3.226    12.720     0.200
     3.282    12.140     0.200
     3.652    11.963     0.200
     3.652    15.783     0.200
     3.996    14.058     0.200
     4.528    16.179     0.200
     4.857    15.841     0.200
     5.713    18.850     0.200
     5.719    19.708     0.200
     5.800    19.913     0.200
     7.409    22.105     0.200
     7.409    21.879     0.200
    11.923    33.434     0.200
    13.155    33.599     0.200
    15.434    35.906     0.200
    17.608    34.634     0.200
    18.465    37.021     0.200
    19.133    38.088     0.200
     2.096    10.175     0.200
     2.720     9.988     0.200
     2.905    13.649     0.200
     3.991    13.500     0.200
     3.991    15.550     0.200
     4.328    13.257     0.200
     4.382    15.849     0.200
     4.421    16.045     0.200
     4.529    17.356     0.200
     4.719    18.559     0.200
     4.786    19.269     0.200
     4.821    18.321     0.200
     5.013    19.101     0.200
     5.183    20.625     0.200
     5.212    19.805     0.200
     6.050    22.478     0.200
     7.206    23.539     0.200
     7.206    22.539     0.200
     7.926    23.348     0.200
     8.166    25.402     0.200
     8.922    25.709     0.200
     8.922    26.730     0.200
    10.652    29.478     0.200
    10.652    30.924     0.200
    12.419    35.008     0.200
    13.052    34.842     0.200
    14.877    38.122     0.200
    15.022    35.432     0.200
    15.451    38.409     0.200
    16.322    37.633     0.200
    16.719    37.723     0.200
    18.324    41.203     0.200
    18.320    41.164     0.200
    18.364    41.274     0.200
    18.546    41.082     0.200
    18.552    41.134     0.200
    18.552    41.583     0.200
    18.552    41.274     0.200
    18.552    41.409     0.200
    18.580    40.605     0.200
    18.615    41.163     0.200
    18.896    39.452     0.200
    18.896    39.971     0.200
    18.942    41.195     0.200
    19.073    39.958     0.200
    19.140    40.592     0.200
    19.274    40.761     0.200
    19.297    41.315     0.200
    19.441    40.640     0.200
    19.490    40.450     0.200
    19.492    40.103     0.200
    19.644    39.940     0.200
    19.675    40.442     0.200
    19.731    40.246     0.200
    19.808    38.825     0.200
    19.811    40.193     0.200
    19.838    40.125     0.200
    19.884    40.189     0.200
    19.963    39.813     0.200
    20.050    40.054     0.200
    20.060    39.798     0.200
    20.053    39.399     0.200
    20.274    39.612     0.200
    20.283    39.407     0.200
    20.308    39.148     0.200
    20.310    38.919     0.200
    20.310    39.552     0.200
    20.340    39.391     0.200
    20.375    39.438     0.200
    20.507    39.539     0.200
    20.543    39.290     0.200
    20.633    39.438     0.200
    20.632    39.831     0.200
    20.725    39.396     0.200
    20.747    39.215     0.200
    21.008    38.568     0.200
    20.979    38.984     0.200
    20.987    39.166     0.200
    20.989    39.002     0.200
     2.226    11.691     0.200
     2.414    11.218     0.200
     2.414    10.218     0.200
     2.697    12.586     0.200
     3.114    13.048     0.200
     3.235    13.448     0.200
     3.349    14.046     0.200
     3.552    14.699     0.200
     3.713    14.837     0.200
     3.713    15.169     0.200
     3.735    15.376     0.200
     3.856    15.755     0.200
     4.164    15.805     0.200
     4.164    17.614     0.200
     4.164    16.676     0.200
     4.268    18.303     0.200
     4.844    18.488     0.200
     5.264    18.726     0.200
     5.953    18.771     0.200
     5.953    19.689     0.200
     5.961    20.331     0.200
     6.079    19.057     0.200
     6.344    20.961     0.200
     6.879    22.288     0.200
     7.695    22.714     0.200
    10.428    30.306     0.200
    11.242    32.755     0.200
    12.676    34.981     0.200
    13.762    36.917     0.200
    13.975    33.267     0.200
    15.526    39.388     0.200
    15.873    37.851     0.200
    16.787    38.707     0.200
    18.946    42.924     0.200
    19.702    41.819     0.200
    19.688    41.413     0.200
    19.688    42.030     0.200
    19.742    39.831     0.200
    19.742    43.202     0.200
    20.857    42.731     0.200
     2.257    11.829     0.200
     2.715    11.796     0.200
     2.715    13.796     0.200
     2.755    14.272     0.200
     3.986    15.035     0.200
     3.986    17.035     0.200
     4.271    15.611     0.200
     4.302    15.737     0.200
     4.416    17.845     0.200
     4.601    17.535     0.200
     4.601    20.535     0.200
     4.686    17.337     0.200
     4.686    20.915     0.200
     4.700    18.178     0.200
     4.700    20.327     0.200
     4.880    17.428     0.200
     4.917    18.662     0.200
     7.150    24.924     0.200
     7.230    26.483     0.200
     7.364    23.091     0.200
     7.860    27.830     0.200
     8.204    26.835     0.200
     8.862    27.675     0.200
    10.456    30.791     0.200
    10.575    29.608     0.200
    11.610    34.028     0.200
    12.029    35.252     0.200
    12.207    36.609     0.200
    12.867    37.823     0.200
    13.334    36.049     0.200
    14.903    38.472     0.200
    15.388    38.840     0.200
    15.494    42.267     0.200
    15.589    41.846     0.200
    16.119    40.685     0.200
    16.508    39.700     0.200
    18.195    41.121     0.200
    18.445    44.358     0.200
    18.445    43.178     0.200
    18.724    43.687     0.200
    19.635    44.272     0.200
    19.935    42.925     0.200
    19.956    42.744     0.200
     0.408     5.462     0.200
     1.608     6.915     0.200
     1.608     5.743     0.200
     2.032     9.861     0.200
     2.032    10.861     0.200
     2.072     8.390     0.200
     2.878    10.324     0.200
     3.029    10.238     0.200
     3.187    11.766     0.200
     3.258    12.535     0.200
     3.258    13.105     0.200
     3.306    10.469     0.200
     3.803    14.895     0.200
     4.134    14.324     0.200
     4.134    15.324     0.200
     4.155    16.052     0.200
     4.355    15.395     0.200
     4.912    15.262     0.200
     5.007    14.647     0.200
     5.290    18.512     0.200
     0.566     6.154     0.200
     1.854     8.565     0.200
     1.854     9.395     0.200
     2.853    10.858     0.200
     2.950    10.468     0.200
     2.950    10.248     0.200
     3.178    10.892     0.200
     3.214    11.343     0.200
     3.568    13.227     0.200
     3.619    13.026     0.200
     3.984    13.633     0.200
     4.049    14.665     0.200
     5.056    14.872     0.200
     5.239    16.793     0.200
     6.058    18.923     0.200
     6.200    18.207     0.200
     6.986    20.170     0.200
     7.074    20.107     0.200
     7.768    21.585     0.200
     9.482    24.144     0.200
     9.684    26.065     0.200
    10.667    29.342     0.200
    10.772    29.406     0.200
    10.795    29.412     0.200
    10.923    30.265     0.200
    11.421    31.047     0.200
    12.032    31.518     0.200
    12.112    30.695     0.200
    12.163    32.111     0.200
    12.241    32.042     0.200
    12.424    32.947     0.200
    12.658    32.992     0.200
    12.685    33.465     0.200
    12.814    31.744     0.200
    12.960    32.587     0.200
    13.195    33.069     0.200
    13.408    33.580     0.200
    13.524    34.376     0.200
    13.567    34.824     0.200
    13.587    34.070     0.200
    13.633    34.401     0.200
    13.937    34.797     0.200
    13.982    33.540     0.200
    14.049    34.709     0.200
    14.154    34.562     0.200
    14.189    35.164     0.200
    14.271    35.254     0.200
    14.490    35.172     0.200
    14.518    35.121     0.200
    14.602    33.776     0.200
    14.764    35.563     0.200
    14.781    35.840     0.200
    14.910    35.846     0.200
    15.202    36.836     0.200
    15.265    34.548     0.200
    15.294    36.596     0.200
    15.327    36.557     0.200
    15.358    36.280     0.200
    15.387    36.676     0.200
    15.392    36.040     0.200
    15.489    36.515     0.200
    15.567    36.537     0.200
    15.803    36.975     0.200
    15.866    35.821     0.200
    15.971    37.369     0.200
    15.977    36.797     0.200
    15.998    36.939     0.200
    16.335    36.913     0.200
    16.357    35.973     0.200
    16.374    36.965     0.200
    16.440    36.056     0.200
    16.519    36.857     0.200
    16.570    36.324     0.200
    16.597    36.960     0.200
    16.655    36.906     0.200
    16.707    36.780     0.200
    17.008    37.448     0.200
    17.148    36.454     0.200
    17.160    37.360     0.200
    17.198    36.454     0.200
    17.209    36.372     0.200
    17.285    36.946     0.200
    17.392    37.545     0.200
    17.429    37.646     0.200
    17.503    37.618     0.200
    17.845    37.678     0.200
    18.110    37.528     0.200
    18.211    38.826     0.200
    18.416    37.399     0.200
    18.416    39.226     0.200
    19.145    37.158     0.200
    19.193    37.402     0.200
     1.626    12.811     0.200
     2.391    13.282     0.200
     2.630    13.406     0.200
     2.695    14.282     0.200
     2.815    13.683     0.200
     2.949    16.335     0.200
     3.050    15.444     0.200
     3.251    15.905     0.200
     3.276    16.427     0.200
     3.343    15.929     0.200
     3.581    19.602     0.200
     3.622    16.986     0.200
     4.352    17.936     0.200
     4.492    17.787     0.200
     5.505    20.651     0.200
     6.510    23.717     0.200
     7.224    24.330     0.200
     1.760     8.228     0.200
     1.773     9.542     0.200
     2.148     9.565     0.200
     2.432    11.537     0.200
     2.548    12.334     0.200
     2.862    12.164     0.200
     3.010    13.235     0.200
     7.445    23.206     0.200
    11.368    34.127     0.200
    11.629    34.492     0.200
    12.126    35.639     0.200
    12.154    34.616     0.200
    12.170    35.107     0.200
    12.716    36.932     0.200
    12.722    36.324     0.200
    12.858    36.328     0.200
    13.526    36.719     0.200
    13.676    34.775     0.200
    13.909    37.033     0.200
    14.271    38.316     0.200
    14.302    36.902     0.200
    14.356    38.313     0.200
    14.675    37.116     0.200
    15.302    37.232     0.200
    16.076    39.231     0.200
    16.563    39.748     0.200
    17.272    39.752     0.200
    18.532    41.680     0.200
    18.728    39.903     0.200
    18.835    40.717     0.200
    18.930    40.944     0.200
    19.137    40.988     0.200
    19.356    40.283     0.200
    19.450    39.956     0.200
    19.616    39.780     0.200
    19.630    40.799     0.200
    19.697    39.736     0.200
    19.743    40.763     0.200
    19.795    40.544     0.200
    19.865    40.151     0.200
    19.865    39.737     0.200
    19.878    41.308     0.200
    19.878    40.310     0.200
    20.285    41.505     0.200
    20.290    39.562     0.200
    20.389    41.133     0.200
    20.772    41.817     0.200
    20.766    42.447     0.200
    20.789    39.948     0.200
     0.710     5.494     0.200
     1.349     6.690     0.200
     1.506     7.603     0.200
     1.795     8.095     0.200
     2.106     9.654     0.200
     2.546    11.174     0.200
     2.610     9.770     0.200
     2.949    11.909     0.200
     3.037    10.687     0.200
     3.188    11.759     0.200
     3.189    14.000     0.200
     3.294    14.928     0.200
     3.357    13.223     0.200
     3.375    14.436     0.200
     3.388    13.640     0.200
     3.490    15.353     0.200
     3.830    12.809     0.200
     3.860    16.809     0.200
     3.863    13.637     0.200
     4.338    14.585     0.200
     4.725    15.396     0.200
     5.755    18.921     0.200
     5.945    15.328     0.200
     6.748    20.550     0.200
     7.088    20.874     0.200
     7.476    21.835     0.200
     7.476    22.039     0.200
     9.374    25.973     0.200
    10.918    29.738     0.200
    11.017    31.257     0.200
    11.182    32.007     0.200
    11.678    33.050     0.200
    11.702    32.278     0.200
    12.264    33.626     0.200
    12.274    33.737     0.200
    12.407    34.057     0.200
    12.510    34.604     0.200
    12.911    34.777     0.200
    12.918    34.316     0.200
    13.042    32.131     0.200
    13.082    35.121     0.200
    13.235    35.372     0.200
    13.468    33.565     0.200
    13.468    35.511     0.200
    13.661    35.690     0.200
    13.860    35.772     0.200
    14.224    35.714     0.200
    15.498    36.092     0.200
    16.433    35.907     0.200
    16.430    35.990     0.200
    16.617    36.527     0.200
    17.544    34.377     0.200
    17.945    37.766     0.200
    17.992    38.047     0.200
    18.082    38.772     0.200
    18.287    38.335     0.200
    18.415    38.589     0.200
    18.494    38.781     0.200
    18.669    38.608     0.200
    18.715    37.240     0.200
    18.718    38.135     0.200
    18.729    39.646     0.200
    18.729    38.631     0.200
    18.916    37.700     0.200
    19.043    38.781     0.200
    19.156    37.586     0.200
    19.203    37.693     0.200
    19.201    37.920     0.200
    19.247    37.395     0.200
    19.267    38.453     0.200
    19.296    37.926     0.200
    19.409    38.633     0.200
    19.432    38.584     0.200
    19.432    37.764     0.200
    19.431    38.020     0.200
    19.431    37.005     0.200
    19.462    37.904     0.200
    19.600    38.315     0.200
    19.617    37.076     0.200
    19.712    36.843     0.200
    19.719    37.197     0.200
    19.871    37.506     0.200
    19.982    38.355     0.200
    19.994    36.844     0.200
    20.021    37.417     0.200
    20.077    37.137     0.200
    20.270    36.555     0.200
    20.349    36.751     0.200
    20.409    37.187     0.200
    20.456    36.588     0.200
    20.577    37.520     0.200
    20.664    37.162     0.200
    20.789    36.451     0.200
     0.906     5.096     0.200
     1.038     5.032     0.200
     2.175     8.518     0.200
     2.532    12.127     0.200
     2.976    12.571     0.200
     3.130    14.106     0.200
     3.142    14.060     0.200
     3.596    16.109     0.200
     3.635    15.223     0.200
     4.306    14.687     0.200
     4.681    16.767     0.200
     5.381    18.421     0.200
     6.335    19.719     0.200
     6.335    19.371     0.200
     7.118    21.335     0.200
     9.854    28.768     0.200
    10.805    30.292     0.200
    11.271    31.685     0.200
    11.364    32.234     0.200
    11.365    32.038     0.200
    11.384    30.957     0.200
    11.544    32.450     0.200
    11.597    31.201     0.200
    11.988    33.172     0.200
    12.038    33.429     0.200
    12.042    32.799     0.200
    12.070    33.186     0.200
    12.184    32.916     0.200
    12.491    34.358     0.200
    12.544    30.982     0.200
    12.544    32.630     0.200
    12.593    33.634     0.200
    12.631    34.592     0.200
    12.635    35.180     0.200
    12.682    34.754     0.200
    12.751    34.867     0.200
    12.884    34.924     0.200
    12.934    34.197     0.200
    13.193    30.613     0.200
    13.266    35.069     0.200
    13.274    34.909     0.200
    13.302    34.804     0.200
    13.348    34.614     0.200
    13.399    32.874     0.200
    13.439    34.772     0.200
    13.454    35.517     0.200
    13.615    36.659     0.200
    13.845    34.906     0.200
    13.845    36.105     0.200
    13.905    35.121     0.200
    13.949    35.184     0.200
    14.155    36.914     0.200
    14.182    32.994     0.200
    14.238    36.843     0.200
    14.491    36.234     0.200
    14.516    36.313     0.200
    14.564    36.722     0.200
    14.586    36.893     0.200
    14.672    35.891     0.200
    14.962    33.199     0.200
    15.174    37.463     0.200
    15.192    36.628     0.200
    15.202    36.997     0.200
    15.220    36.875     0.200
    15.291    37.468     0.200
    15.292    36.175     0.200
    15.366    36.734     0.200
    15.691    35.397     0.200
    16.111    37.554     0.200
    16.344    37.844     0.200
    16.624    37.390     0.200
    16.741    37.622     0.200
    16.877    36.316     0.200
    17.106    37.718     0.200
    17.624    37.209     0.200
    18.139    36.992     0.200
    18.281    38.967     0.200
    18.287    39.268     0.200
    18.343    38.889     0.200
    18.432    39.548     0.200
    18.447    39.274     0.200
    18.483    39.056     0.200
    18.480    40.177     0.200
    18.502    39.484     0.200
    18.650    38.833     0.200
    18.667    40.085     0.200
    18.882    41.471     0.200
    18.910    38.393     0.200
    18.960    38.505     0.200
    18.965    38.443     0.200
    19.021    38.132     0.200
    19.039    41.238     0.200
    19.054    38.834     0.200
    19.076    40.934     0.200
    19.076    38.866     0.200
    19.080    38.136     0.200
    19.151    39.966     0.200
    19.151    41.357     0.200
    19.169    40.922     0.200
    19.294    39.741     0.200
    19.319    40.601     0.200
    19.397    39.987     0.200
    19.473    41.189     0.200
    19.475    41.801     0.200
    19.490    40.900     0.200
    19.493    38.359     0.200
    19.596    38.588     0.200
    19.654    38.962     0.200
    19.711    41.287     0.200
    19.821    41.925     0.200
    19.825    38.015     0.200
    19.825    41.163     0.200
    19.845    40.689     0.200
    20.047    41.508     0.200
    20.067    37.988     0.200
    20.097    38.691     0.200
    20.169    37.748     0.200
    20.226    38.181     0.200
    20.273    38.405     0.200
    20.302    40.147     0.200
    20.383    39.349     0.200
    20.416    39.577     0.200
    20.465    39.539     0.200
    20.450    39.012     0.200
    20.674    38.060     0.200
    20.731    39.046     0.200
    20.730    38.846     0.200
    20.956    40.117     0.200
     0.249     5.167     0.200
     0.934     5.885     0.200
     1.941     7.310     0.200
     1.941     8.463     0.200
     2.225     9.173     0.200
     2.780     9.784     0.200
     2.778    10.123     0.200
     2.869     9.350     0.200
     3.573    10.962     0.200
    10.594    29.396     0.200
    10.765    30.764     0.200
    10.877    30.619     0.200
    10.915    30.159     0.200
    11.006    30.896     0.200
    11.111    30.460     0.200
    11.382    30.517     0.200
    11.507    31.782     0.200
    11.572    31.905     0.200
    11.585    32.175     0.200
    11.702    32.378     0.200
    11.847    31.982     0.200
    11.947    31.997     0.200
    12.109    32.935     0.200
    12.109    33.976     0.200
    12.157    33.139     0.200
    12.270    33.542     0.200
    12.308    32.475     0.200
    12.305    33.350     0.200
    12.340    33.262     0.200
    12.344    33.165     0.200
    12.691    33.639     0.200
    12.751    34.515     0.200
    12.806    34.194     0.200
    12.882    34.119     0.200
    12.956    33.990     0.200
    12.962    34.246     0.200
    12.983    35.112     0.200
    13.016    34.049     0.200
    13.191    33.417     0.200
    13.254    31.212     0.200
    13.445    35.360     0.200
    13.447    34.604     0.200
    13.518    35.114     0.200
    13.547    35.086     0.200
    13.598    34.971     0.200
    13.614    34.091     0.200
    13.644    35.250     0.200
    13.903    35.556     0.200
    14.141    35.849     0.200
    14.245    34.993     0.200
    14.394    36.243     0.200
    14.528    36.626     0.200
    14.773    36.876     0.200
    15.905    36.572     0.200
    15.979    34.127     0.200
    15.967    37.035     0.200
    15.985    37.052     0.200
    15.998    36.463     0.200
    16.304    36.560     0.200
    16.352    37.014     0.200
    16.359    37.110     0.200
    18.062    38.692     0.200
    18.082    37.813     0.200
    18.249    39.410     0.200
    18.386    38.883     0.200
    18.471    37.802     0.200
    18.551    37.834     0.200
    18.570    38.141     0.200
    18.580    37.996     0.200
    18.600    37.718     0.200
    18.612    37.542     0.200
    18.693    37.980     0.200
    18.768    37.712     0.200
    19.025    37.494     0.200
    19.030    37.449     0.200
    19.089    37.948     0.200
    19.091    37.978     0.200
    19.106    39.691     0.200
    19.120    38.562     0.200
    19.173    37.743     0.200
    19.308    37.147     0.200
    19.401    37.546     0.200
    19.472    38.229     0.200
    19.569    37.454     0.200
    19.699    37.341     0.200
    19.720    37.438     0.200
    19.742    37.286     0.200
    19.784    36.941     0.200
     1.441     7.140     0.200
     1.515     7.775     0.200
     1.573     9.867     0.200
     2.488    10.017     0.200
     2.252    12.464     0.200
     2.445    10.371     0.200
     2.433    13.158     0.200
     3.080    14.017     0.200
     3.359    13.731     0.200
     4.186    16.118     0.200
     4.854    15.866     0.200
    10.972    31.481     0.200
    11.261    31.965     0.200
    11.366    33.232     0.200
    11.391    33.482     0.200
    11.513    34.197     0.200
    11.516    33.646     0.200
    12.012    35.303     0.200
    12.043    35.016     0.200
    12.065    35.332     0.200
    12.064    35.052     0.200
    12.136    35.117     0.200
    12.309    33.250     0.200
    12.257    35.046     0.200
    12.337    34.889     0.200
    12.560    35.806     0.200
    12.611    36.065     0.200
    12.628    35.618     0.200
    12.699    35.639     0.200
    12.699    34.959     0.200
    12.758    35.835     0.200
    12.755    36.449     0.200
    12.777    36.559     0.200
    12.826    36.176     0.200
    13.085    35.731     0.200
    13.251    36.824     0.200
    13.281    36.930     0.200
    13.401    36.316     0.200
    13.397    36.408     0.200
    13.397    36.256     0.200
    13.411    35.981     0.200
    13.543    36.708     0.200
    13.587    35.771     0.200
    13.779    37.080     0.200
    13.880    37.342     0.200
    13.913    38.425     0.200
    14.020    37.578     0.200
    14.017    37.217     0.200
    14.029    37.322     0.200
    14.113    38.038     0.200
    14.096    36.823     0.200
    14.182    38.058     0.200
    14.171    37.792     0.200
    14.476    38.447     0.200
    14.504    38.369     0.200
    14.521    37.180     0.200
    14.556    38.406     0.200
    14.575    39.014     0.200
    14.577    38.671     0.200
    14.596    38.491     0.200
    14.639    38.917     0.200
    14.706    38.428     0.200
    14.774    38.878     0.200
    14.744    37.721     0.200
    14.735    38.765     0.200
    14.813    38.230     0.200
    14.813    37.683     0.200
    15.082    38.810     0.200
    15.195    37.516     0.200
    15.189    38.219     0.200
    15.191    39.082     0.200
    15.210    37.604     0.200
    15.259    38.102     0.200
    15.263    38.093     0.200
    15.336    38.728     0.200
    15.382    38.534     0.200
    15.446    38.177     0.200
    15.412    37.273     0.200
    15.539    39.393     0.200
    15.508    37.661     0.200
    15.580    37.988     0.200
    15.792    37.272     0.200
    15.777    37.375     0.200
    15.790    37.022     0.200
    15.852    39.057     0.200
    15.884    39.660     0.200
    15.811    37.088     0.200
    15.836    38.275     0.200
    15.861    38.353     0.200
    15.861    37.290     0.200
    15.895    39.665     0.200
    15.870    37.763     0.200
    15.978    40.059     0.200
    16.029    39.051     0.200
    16.072    39.444     0.200
    16.240    40.257     0.200
    16.194    38.904     0.200
    16.371    39.666     0.200
    16.420    39.896     0.200
    16.462    40.711     0.200
    16.437    39.959     0.200
    16.460    39.378     0.200
    16.541    41.177     0.200
    16.537    41.089     0.200
    16.608    41.011     0.200
    16.729    40.409     0.200
    16.726    38.688     0.200
    16.808    39.967     0.200
    16.906    41.126     0.200
    16.953    40.364     0.200
    16.995    40.719     0.200
    17.046    40.732     0.200
    17.129    40.395     0.200
    17.162    41.006     0.200
    17.157    40.874     0.200
    17.243    40.481     0.200
    17.291    40.346     0.200
    17.277    40.497     0.200
    17.581    41.021     0.200
    17.648    41.183     0.200
    17.700    39.319     0.200
    17.737    41.146     0.200
    17.790    40.949     0.200
    17.803    41.002     0.200
    17.869    40.013     0.200
    18.388    41.930     0.200
    18.360    42.164     0.200
    18.593    42.034     0.200
    18.786    41.039     0.200
    18.830    41.761     0.200
    18.788    42.673     0.200
    18.923    41.995     0.200
    18.958    42.223     0.200
    18.958    42.122     0.200
    19.140    41.686     0.200
    19.223    41.347     0.200
    19.311    42.019     0.200
    19.694    41.263     0.200
    19.694    41.459     0.200
    19.739    40.751     0.200
    19.718    41.239     0.200
    19.760    41.470     0.200
    20.176    40.276     0.200
     0.286     5.488     0.200
     1.161     5.639     0.200
     1.192     6.685     0.200
     1.387     6.132     0.200
     1.714     7.287     0.200
     2.139     9.239     0.200
     2.985    10.308     0.200
     2.979    10.521     0.200
     3.008    11.886     0.200
     7.904    22.118     0.200
     8.212    25.809     0.200
     9.528    28.094     0.200
     9.657    28.376     0.200
     9.816    28.302     0.200
    10.244    28.240     0.200
    10.441    29.913     0.200
    10.534    29.373     0.200
    10.670    29.367     0.200
    10.842    29.776     0.200
    10.903    28.474     0.200
    11.193    31.119     0.200
    11.201    30.908     0.200
    11.460    31.329     0.200
    11.572    31.500     0.200
    11.703    32.777     0.200
    11.754    31.551     0.200
    11.807    32.132     0.200
    11.858    31.221     0.200
    11.940    32.122     0.200
    12.030    32.109     0.200
    12.190    31.919     0.200
    12.223    33.312     0.200
    12.313    31.834     0.200
    12.324    31.458     0.200
    12.391    32.921     0.200
    12.391    32.296     0.200
    12.435    33.125     0.200
    12.449    34.263     0.200
    12.617    32.790     0.200
    12.776    33.686     0.200
    12.823    33.355     0.200
    13.072    35.094     0.200
    13.078    35.287     0.200
    13.109    33.871     0.200
    13.256    30.635     0.200
    13.277    35.076     0.200
    13.394    33.175     0.200
    13.411    33.912     0.200
    13.411    32.960     0.200
    13.550    35.903     0.200
    13.603    32.790     0.200
    13.785    33.933     0.200
    14.081    31.337     0.200
    14.500    33.481     0.200
    14.705    34.390     0.200
    15.321    35.749     0.200
    15.513    34.382     0.200
    15.503    34.162     0.200
    16.032    35.122     0.200
    16.719    34.777     0.200
    16.759    35.970     0.200
    16.841    36.300     0.200
    17.420    34.817     0.200
    17.545    36.481     0.200
    17.574    36.070     0.200
    17.621    36.247     0.200
    17.750    35.925     0.200
    17.959    37.448     0.200
    18.191    37.641     0.200
    18.271    37.425     0.200
    18.577    39.375     0.200
    18.577    38.798     0.200
    18.599    36.987     0.200
    18.674    36.905     0.200
    18.711    38.401     0.200
    18.715    38.358     0.200
    18.721    36.736     0.200
    19.065    36.359     0.200
    19.159    38.365     0.200
    19.343    37.722     0.200
    19.343    36.954     0.200
    19.365    39.003     0.200
    19.397    38.318     0.200
    19.409    36.776     0.200
    19.559    38.065     0.200
    19.800    36.971     0.200
    19.820    36.708     0.200
    19.870    39.213     0.200
    20.180    37.841     0.200
    20.789    36.878     0.200
     0.964     5.015     0.200
     1.090     5.955     0.200
     1.664     8.317     0.200
     1.777     8.496     0.200
     1.681     9.304     0.200
     1.885     9.022     0.200
     2.341     8.896     0.200
     2.609     9.880     0.200
     2.596    11.733     0.200
     2.688    10.140     0.200
     2.821    10.507     0.200
     3.142    12.549     0.200
     3.150    12.129     0.200
     3.589    13.817     0.200
     4.720    15.169     0.200
     7.203    21.113     0.200
    11.028    29.004     0.200
     0.786     5.504     0.200
     1.145     5.857     0.200
     1.765     7.431     0.200
     1.869     8.121     0.200
     1.995     9.098     0.200
     2.056     8.417     0.200
     2.068     8.281     0.200
     2.459    13.084     0.200
     2.438    10.503     0.200
     2.486     9.648     0.200
     2.575    10.965     0.200
     2.693    11.213     0.200
     2.721    10.945     0.200
     3.038    11.555     0.200
     3.095    10.594     0.200
     3.077    11.230     0.200
     3.137    11.170     0.200
     3.265    14.844     0.200
     3.309    14.081     0.200
     3.470    12.776     0.200
     3.534    14.025     0.200
     3.637    12.198     0.200
     3.673    12.299     0.200
     3.754    12.371     0.200
     4.599    12.518     0.200
     7.019    20.300     0.200
     9.110    27.423     0.200
    11.363    29.132     0.200
    11.364    31.671     0.200
    12.610    35.354     0.200
    13.229    31.592     0.200
    16.821    36.196     0.200
    17.302    36.930     0.200
     0.779     8.977     0.200
     0.794     9.111     0.200
     0.995     8.837     0.200
     1.759     8.874     0.200
     1.759     8.003     0.200
     1.961     9.044     0.200
     2.044     9.295     0.200
     2.337     9.225     0.200
     2.564    10.164     0.200
     3.193    11.479     0.200
     3.320    11.829     0.200
     3.584    13.261     0.200
     3.791    12.249     0.200
     4.396    14.547     0.200
     6.722    17.951     0.200
     7.900    21.699     0.200
     8.307    24.579     0.200
     9.858    24.546     0.200
    10.333    27.756     0.200
    10.332    25.805     0.200
    10.652    26.744     0.200
    11.804    28.795     0.200
    11.804    28.428     0.200
    12.857    31.033     0.200
    12.857    31.190     0.200
    13.873    30.063     0.200
    13.912    31.029     0.200
    14.181    32.555     0.200
    14.761    31.482     0.200
    15.148    31.341     0.200
    15.636    32.516     0.200
    15.945    30.832     0.200
    16.001    32.613     0.200
    16.131    31.969     0.200
    16.131    32.774     0.200
    16.231    31.540     0.200
    16.256    31.461     0.200
    16.295    31.487     0.200
    16.310    32.865     0.200
    16.353    32.084     0.200
    16.612    32.882     0.200
    16.866    32.730     0.200
    16.939    32.525     0.200
    16.948    32.910     0.200
    16.948    31.915     0.200
    16.990    32.769     0.200
    17.019    32.597     0.200
    17.153    32.782     0.200
    17.217    32.670     0.200
    17.280    32.688     0.200
    17.425    33.617     0.200
    17.492    33.192     0.200
    17.979    35.702     0.200
    18.119    33.308     0.200
    18.149    34.910     0.200
    18.453    32.936     0.200
    18.603    33.334     0.200
    18.617    35.869     0.200
    18.836    32.909     0.200
    18.807    34.459     0.200
    18.807    34.338     0.200
    18.834    34.340     0.200
    18.834    33.571     0.200
    18.912    32.902     0.200
    19.007    34.589     0.200
    19.007    34.735     0.200
    19.051    33.034     0.200
    19.201    35.926     0.200
    19.452    35.380     0.200
    19.549    33.500     0.200
     0.943     6.373     0.200
     1.109     7.125     0.200
     1.691     9.363     0.200
     1.907     9.082     0.200
     2.361     9.786     0.200
     2.709    11.022     0.200
     2.800    10.215     0.200
     4.424    15.241     0.200
     7.225    21.674     0.200
    11.023    29.140     0.200
    11.022    30.102     0.200
    12.319    30.686     0.200
    12.319    29.217     0.200
    13.592    34.971     0.200
    13.592    33.807     0.200
    14.306    31.786     0.200
    14.306    30.556     0.200
    14.426    34.649     0.200
    14.444    34.762     0.200
    15.073    33.282     0.200
    15.583    35.351     0.200
    15.583    34.703     0.200
    15.861    35.957     0.200
    16.214    35.795     0.200
    16.501    35.730     0.200
    16.501    35.187     0.200
    16.652    35.340     0.200
    16.900    33.514     0.200
    17.243    32.858     0.200
    17.947    36.016     0.200
    17.958    38.634     0.200
    17.965    38.011     0.200
    18.828    36.266     0.200
    18.827    38.892     0.200
    18.898    38.829     0.200
    19.071    35.748     0.200
    19.542    36.514     0.200
    19.542    36.682     0.200
    19.571    36.680     0.200
    19.571    36.547     0.200
    19.740    36.231     0.200
    19.740    36.747     0.200
    19.774    37.582     0.200
    19.777    37.258     0.200
    19.777    37.778     0.200
    19.805    36.975     0.200
    20.050    37.111     0.200
    20.221    37.081     0.200
    20.612    36.037     0.200
    20.770    36.007     0.200
     1.574     6.029     0.200
     2.333     9.370     0.200
     2.587    12.871     0.200
     3.203    12.715     0.200
     3.746    15.565     0.200
     4.329    15.513     0.200
     7.444    22.808     0.200
     8.264    25.529     0.200
     8.535    26.792     0.200
     8.531    25.212     0.200
    10.732    30.092     0.200
    10.732    30.092     0.200
    10.732    30.368     0.200
    13.176    35.321     0.200
    13.176    35.493     0.200
    13.165    34.859     0.200
    13.602    33.941     0.200
    13.726    36.217     0.200
    14.395    38.107     0.200
    15.376    37.946     0.200
    15.376    39.443     0.200
    15.668    37.265     0.200
    15.751    38.195     0.200
    15.849    41.205     0.200
    15.910    39.018     0.200
    15.900    40.169     0.200
    16.078    38.322     0.200
    16.365    39.513     0.200
    16.365    39.755     0.200
    16.509    39.858     0.200
    16.509    40.747     0.200
    16.509    40.223     0.200
    16.569    40.265     0.200
    17.238    40.383     0.200
    18.045    37.992     0.200
    18.064    38.362     0.200
    18.211    40.609     0.200
    18.202    38.197     0.200
    18.525    40.696     0.200
    18.834    40.633     0.200
    18.841    40.852     0.200
    19.323    42.328     0.200
    19.851    40.127     0.200
    20.181    40.243     0.200
    20.275    41.068     0.200
    20.377    42.250     0.200
    20.407    41.047     0.200
    20.674    40.676     0.200
    20.730    41.211     0.200
     1.531     9.911     0.200
     1.465     8.243     0.200
     2.234    12.689     0.200
     2.454    11.935     0.200
     2.455     9.925     0.200
     2.733    11.384     0.200
     3.052    14.533     0.200
     3.263    14.159     0.200
     3.298    15.267     0.200
     3.500    15.918     0.200
     3.500    15.590     0.200
     3.739    15.534     0.200
     3.758    16.728     0.200
     4.180    16.220     0.200
     4.674    17.856     0.200
     4.880    16.923     0.200
     4.880    17.048     0.200
     5.987    21.242     0.200
     6.369    20.359     0.200
     6.915    22.196     0.200
     7.505    24.308     0.200
     7.630    24.170     0.200
     7.657    23.811     0.200
     7.659    23.232     0.200
     7.728    23.912     0.200
     7.693    23.836     0.200
     7.697    22.537     0.200
     9.167    28.487     0.200
     9.167    28.589     0.200
     9.131    28.039     0.200
    10.695    31.650     0.200
    11.221    32.186     0.200
    11.220    32.293     0.200
    12.330    32.650     0.200
    12.583    34.794     0.200
    12.663    35.103     0.200
    12.663    35.431     0.200
    12.753    31.909     0.200
    13.135    33.818     0.200
    13.465    34.272     0.200
    13.541    35.587     0.200
    13.738    37.167     0.200
    13.738    34.769     0.200
    13.873    37.199     0.200
    14.010    37.614     0.200
    14.002    33.061     0.200
    14.117    37.355     0.200
    14.147    37.045     0.200
    14.435    37.501     0.200
    14.702    37.107     0.200
    14.777    37.661     0.200
    14.777    35.763     0.200
    15.262    36.446     0.200
    15.400    37.018     0.200
    15.532    37.122     0.200
    15.633    36.942     0.200
    15.560    39.918     0.200
    15.777    37.003     0.200
    15.822    38.804     0.200
    15.822    37.164     0.200
    15.878    36.880     0.200
    15.967    37.148     0.200
    16.066    37.381     0.200
    16.171    36.945     0.200
    16.180    37.310     0.200
    16.348    37.378     0.200
    16.421    38.503     0.200
    16.434    38.117     0.200
    16.499    38.371     0.200
    16.560    37.735     0.200
    16.553    38.430     0.200
    16.663    38.025     0.200
    16.748    38.272     0.200
    16.762    38.244     0.200
    16.770    38.956     0.200
    16.770    37.550     0.200
    16.978    37.143     0.200
    16.993    38.636     0.200
    16.993    38.409     0.200
    17.005    38.461     0.200
    17.043    38.087     0.200
    17.051    38.215     0.200
    17.192    38.145     0.200
    17.291    38.727     0.200
    17.362    38.566     0.200
    17.471    38.406     0.200
    17.600    39.299     0.200
    17.631    38.699     0.200
    17.653    39.127     0.200
    17.755    38.732     0.200
    17.852    39.226     0.200
    17.872    38.394     0.200
    17.981    38.945     0.200
    17.981    38.469     0.200
    17.999    39.116     0.200
    18.017    38.153     0.200
    18.052    38.970     0.200
    18.056    38.950     0.200
    18.150    39.176     0.200
    18.199    39.168     0.200
    18.186    39.504     0.200
    18.239    38.976     0.200
    18.384    43.065     0.200
    18.396    42.384     0.200
    18.422    42.966     0.200
    18.431    43.156     0.200
    18.432    43.147     0.200
    18.466    43.152     0.200
    18.488    43.199     0.200
    18.493    43.898     0.200
    18.642    39.336     0.200
    18.612    43.388     0.200
    18.629    43.424     0.200
    18.646    42.757     0.200
    18.746    41.738     0.200
    18.669    42.904     0.200
    18.745    42.527     0.200
    18.672    43.217     0.200
    18.830    39.554     0.200
    18.708    42.463     0.200
    18.790    42.021     0.200
    18.847    39.574     0.200
    18.881    39.750     0.200
    18.916    42.207     0.200
    18.916    42.028     0.200
    18.832    43.288     0.200
    18.841    43.186     0.200
    18.879    42.741     0.200
    19.029    40.927     0.200
    19.029    40.575     0.200
    19.010    41.611     0.200
    19.069    39.603     0.200
    19.091    41.260     0.200
    19.101    42.037     0.200
    19.160    39.421     0.200
    19.053    42.583     0.200
    19.145    41.486     0.200
    19.109    42.301     0.200
    19.303    39.193     0.200
    19.185    44.221     0.200
    19.190    42.049     0.200
    19.381    41.703     0.200
    19.476    39.279     0.200
    19.494    41.649     0.200
    19.494    40.563     0.200
    19.577    39.187     0.200
    19.594    39.177     0.200
    19.615    41.572     0.200
    19.561    41.548     0.200
    19.676    40.956     0.200
    19.676    40.363     0.200
    19.652    40.448     0.200
    19.654    41.617     0.200
    19.654    40.563     0.200
    19.720    40.545     0.200
    19.720    39.678     0.200
    19.603    45.016     0.200
    19.699    41.491     0.200
    19.887    41.142     0.200
    19.921    42.051     0.200
    20.061    40.970     0.200
    20.059    40.963     0.200
    20.101    41.726     0.200
    20.136    40.943     0.200
    20.133    41.012     0.200
    20.228    41.185     0.200
    20.291    41.423     0.200
    20.395    40.906     0.200
    20.427    40.933     0.200
    20.515    40.447     0.200
    20.642    39.796     0.200
    20.635    40.292     0.200
    20.627    40.515     0.200
    20.778    40.076     0.200
    20.765    40.269     0.200
    20.784    40.436     0.200
    20.779    40.199     0.200
    20.788    40.477     0.200
    20.787    40.349     0.200
    20.898    40.085     0.200
    20.932    39.793     0.200
    20.977    40.809     0.200
    21.052    39.210     0.200
    21.040    39.423     0.200
    21.053    40.428     0.200
     1.819     7.800     0.200
     2.123     8.406     0.200
     2.566    12.689     0.200
     2.566    12.820     0.200
     3.054    11.884     0.200
     3.391    13.325     0.200
     3.767    15.568     0.200
     4.268    18.956     0.200
     4.268    18.706     0.200
     4.510    17.314     0.200
     4.701    16.844     0.200
     4.817    15.598     0.200
     5.523    17.229     0.200
     6.629    21.631     0.200
     7.562    23.984     0.200
     7.901    26.834     0.200
     8.363    24.787     0.200
     8.515    26.057     0.200
     8.778    27.717     0.200
    10.654    30.068     0.200
    10.654    31.345     0.200
    10.951    31.330     0.200
    10.951    31.329     0.200
    10.951    32.287     0.200
    11.101    32.450     0.200
    12.566    36.924     0.200
    12.566    35.917     0.200
    12.979    34.543     0.200
    13.409    36.298     0.200
    13.409    37.017     0.200
    13.642    38.653     0.200
    13.827    38.232     0.200
    13.979    37.799     0.200
    14.674    38.489     0.200
    15.364    38.672     0.200
    16.569    39.639     0.200
    16.745    39.649     0.200
    16.844    39.360     0.200
    16.844    39.259     0.200
    16.884    39.100     0.200
    16.884    38.866     0.200
    17.111    39.222     0.200
    17.435    39.424     0.200
    17.474    38.457     0.200
    17.720    39.344     0.200
    17.720    38.985     0.200
    17.759    39.860     0.200
    17.881    39.120     0.200
    17.923    39.617     0.200
    17.925    39.299     0.200
    18.008    38.892     0.200
    18.008    38.513     0.200
    18.117    39.003     0.200
    18.180    38.628     0.200
    18.210    39.422     0.200
    18.422    40.835     0.200
    18.465    41.427     0.200
    18.495    41.486     0.200
    18.523    41.275     0.200
    18.538    41.984     0.200
    18.604    41.780     0.200
    18.749    42.375     0.200
    18.749    42.078     0.200
    18.850    41.084     0.200
    18.924    41.712     0.200
    18.924    42.314     0.200
    19.053    41.535     0.200
    19.089    41.486     0.200
    19.097    41.894     0.200
    19.100    42.060     0.200
    19.100    41.599     0.200
    19.155    41.393     0.200
    19.300    40.172     0.200
    19.415    40.139     0.200
    19.497    41.689     0.200
    19.551    40.775     0.200
    19.582    43.027     0.200
    19.606    40.929     0.200
    19.602    40.757     0.200
    19.977    40.894     0.200
    20.228    40.733     0.200
    20.258    41.144     0.200
    20.316    40.219     0.200
    20.440    40.865     0.200
    20.426    40.127     0.200
    20.463    39.760     0.200
    20.474    40.510     0.200
    20.528    40.785     0.200
    20.586    40.688     0.200
    20.586    40.286     0.200
    20.618    40.670     0.200
    20.603    40.120     0.200
    20.792    39.529     0.200
    20.801    39.744     0.200
    20.890    39.475     0.200
    20.928    40.778     0.200
     0.679     5.416     0.200
     1.360     6.714     0.200
     1.493     7.663     0.200
     1.831     9.587     0.200
     1.831     9.829     0.200
     2.179     9.487     0.200
     2.530     9.135     0.200
     2.623     9.706     0.200
     2.907    12.508     0.200
     2.978    11.529     0.200
     3.095    10.401     0.200
     3.191    11.155     0.200
     3.961    13.670     0.200
     4.360    14.336     0.200
     6.032    16.749     0.200
     7.119    20.486     0.200
     7.501    21.695     0.200
     8.529    27.026     0.200
    10.938    29.950     0.200
    10.938    29.938     0.200
    10.938    29.951     0.200
    12.312    30.392     0.200
    13.778    35.310     0.200
    14.261    36.455     0.200
    14.331    36.425     0.200
    15.140    36.236     0.200
    15.519    36.193     0.200
    15.687    34.969     0.200
    16.098    35.204     0.200
    16.184    37.240     0.200
    16.453    37.339     0.200
    16.644    35.864     0.200
    17.387    36.833     0.200
    18.263    37.811     0.200
    18.631    39.113     0.200
    18.746    38.726     0.200
    19.414    38.478     0.200
    19.634    37.369     0.200
    20.427    37.185     0.200
     0.599     3.515     0.200
     1.917     9.463     0.200
     2.394     9.517     0.200
     2.502     7.488     0.200
     2.537     9.933     0.200
     2.738    11.005     0.200
     2.738    12.239     0.200
     3.247    13.149     0.200
     3.379    11.370     0.200
     3.773    10.711     0.200
     4.112    12.956     0.200
     4.171    13.689     0.200
     4.176    15.710     0.200
     4.186    16.099     0.200
     4.355    14.850     0.200
     4.355    15.225     0.200
     4.475    16.023     0.200
     4.526    15.764     0.200
     4.583    15.202     0.200
     4.631    16.182     0.200
     4.633    16.197     0.200
     4.719    19.082     0.200
     4.869    16.582     0.200
     4.983    17.190     0.200
     5.013    16.847     0.200
     5.165    13.965     0.200
     5.443    18.926     0.200
     6.200    18.660     0.200
     6.982    21.335     0.200
     7.158    20.015     0.200
     7.158    20.343     0.200
     7.519    21.631     0.200
     8.123    22.951     0.200
     8.123    23.123     0.200
     8.481    25.426     0.200
     8.707    25.096     0.200
     8.707    22.135     0.200
     9.013    23.543     0.200
    10.545    28.562     0.200
    10.545    29.109     0.200
    10.714    29.263     0.200
    10.714    29.166     0.200
    11.450    30.051     0.200
    11.610    29.781     0.200
    12.422    33.588     0.200
    13.138    34.801     0.200
    13.138    33.707     0.200
    13.340    31.472     0.200
    13.435    33.975     0.200
    13.435    33.741     0.200
    13.494    32.241     0.200
    13.576    35.862     0.200
    13.633    31.664     0.200
    13.646    34.309     0.200
    14.334    36.478     0.200
    14.397    36.290     0.200
    14.504    35.616     0.200
    14.504    35.272     0.200
    14.567    33.804     0.200
    14.567    35.344     0.200
    14.827    32.820     0.200
    15.366    36.341     0.200
    15.366    35.865     0.200
    15.551    35.109     0.200
    15.864    35.136     0.200
    16.028    35.860     0.200
    16.364    36.861     0.200
    16.364    37.009     0.200
    16.730    36.706     0.200
    17.681    36.758     0.200
    17.711    36.336     0.200
    17.875    37.056     0.200
    18.158    36.429     0.200
    18.234    40.139     0.200
    18.484    39.962     0.200
    18.501    38.911     0.200
    18.543    39.801     0.200
    18.698    39.134     0.200
    18.722    40.325     0.200
    18.725    40.253     0.200
    18.725    40.378     0.200
    18.725    39.847     0.200
    18.739    39.047     0.200
    18.784    40.212     0.200
    19.002    38.691     0.200
    19.118    39.600     0.200
    19.153    38.928     0.200
    19.153    38.795     0.200
    19.220    38.928     0.200
    19.240    39.480     0.200
    19.266    39.367     0.200
    19.274    39.315     0.200
    19.459    39.246     0.200
    19.469    40.097     0.200
    19.608    39.036     0.200
    19.675    38.983     0.200
    19.825    37.427     0.200
    19.850    38.731     0.200
    19.894    38.779     0.200
    19.913    38.180     0.200
    19.918    37.928     0.200
    19.958    38.000     0.200
    19.981    38.909     0.200
    19.978    38.023     0.200
    19.983    37.882     0.200
    20.061    39.020     0.200
    20.094    37.850     0.200
    20.092    38.680     0.200
    20.092    38.876     0.200
    20.099    38.328     0.200
    20.123    38.466     0.200
    20.126    37.729     0.200
    20.128    37.738     0.200
    20.133    37.993     0.200
    20.148    37.496     0.200
    20.160    37.963     0.200
    20.187    37.680     0.200
    20.196    38.348     0.200
    20.217    37.687     0.200
    20.217    39.077     0.200
    20.222    38.036     0.200
    20.226    37.817     0.200
    20.228    37.528     0.200
    20.238    39.030     0.200
    20.240    38.628     0.200
    20.303    37.630     0.200
    20.371    37.523     0.200
    20.402    37.538     0.200
    20.436    38.281     0.200
    20.436    37.547     0.200
    20.514    37.973     0.200
    20.556    37.820     0.200
    20.591    37.694     0.200
    20.705    38.311     0.200
    20.721    38.230     0.200
    20.803    38.035     0.200
    20.816    37.868     0.200
     1.358     6.884     0.200
     1.404     8.648     0.200
     1.502     8.416     0.200
     1.759     9.167     0.200
     2.138    10.056     0.200
     2.615     9.818     0.200
     2.872    12.005     0.200
     2.934    12.520     0.200
     3.367    13.416     0.200
     3.930    14.645     0.200
     4.726    15.104     0.200
     7.466    22.251     0.200
     0.794     5.381     0.200
     1.154     5.229     0.200
     1.737     9.577     0.200
     2.059     8.818     0.200
     2.061     8.784     0.200
     2.419    11.168     0.200
     2.548    11.691     0.200
     2.802    12.732     0.200
     3.044    13.051     0.200
     3.410    14.284     0.200
     3.456    14.031     0.200
     3.500    14.938     0.200
     3.728    13.807     0.200
     4.190    14.423     0.200
     4.712    16.945     0.200
     5.684    18.254     0.200
     6.219    19.651     0.200
     7.004    21.161     0.200
     7.004    21.036     0.200
     8.349    22.973     0.200
     8.354    23.575     0.200
     8.382    24.482     0.200
     8.384    23.436     0.200
     8.417    23.649     0.200
     8.421    23.249     0.200
     9.096    27.675     0.200
     9.418    27.969     0.200
     9.701    26.746     0.200
     9.701    26.037     0.200
     9.739    27.139     0.200
     9.739    27.028     0.200
     9.990    28.223     0.200
     9.990    27.813     0.200
    10.236    28.791     0.200
    10.451    26.181     0.200
    10.537    29.669     0.200
    10.537    29.563     0.200
    11.318    31.439     0.200
    11.318    31.438     0.200
    11.319    30.613     0.200
    11.319    31.963     0.200
    11.615    30.114     0.200
    12.063    29.526     0.200
    12.063    26.856     0.200
    12.560    33.119     0.200
    12.560    32.965     0.200
    13.097    33.738     0.200
    13.177    32.495     0.200
    13.297    30.521     0.200
    13.341    33.608     0.200
    13.341    33.456     0.200
    13.565    35.592     0.200
    13.900    35.837     0.200
    13.900    35.715     0.200
    14.231    37.217     0.200
    14.518    34.925     0.200
    14.689    35.870     0.200
    14.689    35.341     0.200
    14.846    37.378     0.200
    14.846    37.018     0.200
    14.943    36.177     0.200
    15.243    35.165     0.200
    15.865    36.527     0.200
    15.898    37.757     0.200
    16.440    36.854     0.200
    16.773    37.475     0.200
    16.773    37.869     0.200
    16.892    36.768     0.200
    16.892    36.620     0.200
    17.319    36.760     0.200
    17.319    36.181     0.200
    17.557    37.100     0.200
    17.589    37.382     0.200
    17.589    37.272     0.200
    18.126    36.709     0.200
    18.126    36.278     0.200
    18.289    40.570     0.200
    18.334    38.782     0.200
    18.368    40.980     0.200
    18.783    40.352     0.200
    19.121    38.963     0.200
    19.161    40.013     0.200
    19.214    41.954     0.200
    19.226    40.236     0.200
    19.247    40.414     0.200
    19.406    39.317     0.200
    19.570    39.291     0.200
    19.581    39.864     0.200
    19.801    40.098     0.200
    19.841    38.505     0.200
    19.841    38.693     0.200
    19.887    38.360     0.200
    19.887    38.662     0.200
    19.911    38.896     0.200
    19.975    38.888     0.200
    20.013    39.292     0.200
    20.047    38.805     0.200
    20.047    38.627     0.200
    20.110    39.541     0.200
    20.110    39.152     0.200
    20.139    39.080     0.200
    20.286    40.661     0.200
    20.528    38.717     0.200
    20.554    39.115     0.200
    20.846    38.265     0.200
    20.859    38.131     0.200
    20.892    37.969     0.200
    20.929    38.115     0.200
     1.241     8.134     0.200
     1.963     8.075     0.200
     1.983    10.090     0.200
     4.572    16.156     0.200
     4.667    16.548     0.200
     6.783    20.771     0.200
     7.573    23.810     0.200
     8.214    23.502     0.200
     8.896    27.377     0.200
    10.950    30.290     0.200
    11.043    31.823     0.200
    11.042    31.434     0.200
    12.617    34.713     0.200
    12.824    32.031     0.200
    13.514    36.211     0.200
    13.514    35.363     0.200
    14.708    36.716     0.200
    14.708    36.208     0.200
    14.717    36.350     0.200
    14.762    38.361     0.200
    15.502    39.691     0.200
    15.502    39.316     0.200
    15.612    38.253     0.200
    15.672    39.020     0.200
    15.672    38.492     0.200
    15.798    37.708     0.200
    16.074    40.278     0.200
    16.645    39.074     0.200
    16.854    38.351     0.200
    16.854    39.042     0.200
    16.854    38.703     0.200
    16.939    38.515     0.200
    16.939    38.120     0.200
    17.628    39.947     0.200
    17.726    37.786     0.200
    17.828    41.591     0.200
     1.349     5.719     0.200
     2.543    10.800     0.200
     2.615     9.998     0.200
     3.511    13.511     0.200
     5.293    19.591     0.200
     7.297    22.800     0.200
     7.620    24.777     0.200
     8.491    24.251     0.200
    10.596    30.250     0.200
    10.752    29.422     0.200
    10.751    32.082     0.200
    11.551    28.576     0.200
    12.197    31.409     0.200
    12.494    34.061     0.200
    13.463    33.379     0.200
    13.594    33.764     0.200
    13.607    37.348     0.200
    13.633    35.983     0.200
    14.965    37.499     0.200
    16.039    38.585     0.200
    16.414    36.687     0.200
    16.650    39.039     0.200
    17.137    39.882     0.200
    17.272    39.031     0.200
    17.303    39.886     0.200
    18.445    41.749     0.200
    18.533    40.783     0.200
    18.670    40.569     0.200
    18.678    40.919     0.200
    18.678    41.865     0.200
    18.741    41.576     0.200
    18.776    39.473     0.200
    18.922    39.757     0.200
    19.010    41.243     0.200
    19.010    41.008     0.200
    19.068    40.832     0.200
    19.179    40.340     0.200
    19.179    40.172     0.200
    19.292    40.274     0.200
    19.566    41.532     0.200
    19.595    38.608     0.200
    19.800    40.925     0.200
    19.858    39.489     0.200
    19.856    40.854     0.200
    20.104    40.415     0.200
    20.175    40.442     0.200
    20.184    40.711     0.200
    20.545    40.078     0.200
    20.629    40.048     0.200
    20.694    39.800     0.200
    20.723    39.486     0.200
     0.125    12.592     0.200
     0.361    10.440     0.200
     1.114     9.126     0.200
     1.309     7.618     0.200
     2.314    10.989     0.200
     2.592    10.665     0.200
     2.723    10.935     0.200
     3.321    12.161     0.200
     3.536    11.630     0.200
     3.625    13.917     0.200
     3.764    14.091     0.200
     3.967    13.476     0.200
     4.092    14.134     0.200
     4.138    15.136     0.200
     4.322    14.658     0.200
     4.347    15.353     0.200
     4.454    15.046     0.200
     4.768    16.453     0.200
     7.768    21.965     0.200
     7.755    21.195     0.200
     8.644    22.793     0.200
     9.733    25.256     0.200
     9.733    24.842     0.200
     9.923    25.189     0.200
     9.923    25.293     0.200
     9.923    24.670     0.200
    11.396    27.355     0.200
    11.604    30.344     0.200
    11.604    28.899     0.200
    12.377    29.960     0.200
    12.377    29.686     0.200
    12.796    30.965     0.200
    12.987    33.152     0.200
    13.336    30.218     0.200
    13.755    30.405     0.200
    14.508    29.676     0.200
    15.911    32.807     0.200
    16.833    32.479     0.200
    17.471    35.830     0.200
    17.571    35.735     0.200
    18.205    35.431     0.200
    18.208    33.858     0.200
    18.275    35.419     0.200
    18.383    35.140     0.200
    18.520    36.018     0.200
    18.612    36.076     0.200
    18.881    33.874     0.200
    19.236    35.234     0.200
    19.256    34.006     0.200
    19.286    34.203     0.200
    19.251    33.792     0.200
    19.353    34.437     0.200
    19.358    34.062     0.200
    19.401    34.539     0.200
    19.401    34.579     0.200
    19.405    33.973     0.200
    19.422    34.377     0.200
    19.434    35.200     0.200
    19.462    34.906     0.200
    19.491    35.540     0.200
    19.499    34.290     0.200
    19.503    34.317     0.200
    19.577    34.807     0.200
    19.612    33.397     0.200
    19.648    33.698     0.200
    19.675    33.533     0.200
    19.676    33.706     0.200
    19.838    34.746     0.200
    20.033    33.605     0.200
    20.052    34.088     0.200
    20.195    33.398     0.200
     0.756     6.151     0.200
     1.997     8.200     0.200
     2.399     9.670     0.200
     2.931    13.491     0.200
     2.931    13.961     0.200
     3.336    12.161     0.200
     3.339    12.344     0.200
     3.533    14.712     0.200
     4.456    15.080     0.200
     4.620    14.789     0.200
     6.882    19.524     0.200
    11.231    31.280     0.200
    11.231    28.444     0.200
    11.231    28.698     0.200
    12.434    32.507     0.200
    13.825    33.075     0.200
    14.146    35.586     0.200
    14.566    34.655     0.200
    15.090    37.713     0.200
    16.665    38.437     0.200
    17.976    39.649     0.200
    19.718    40.779     0.200
     1.462     6.877     0.200
     1.720     9.117     0.200
     1.958     8.908     0.200
     1.985     9.453     0.200
     2.221    10.079     0.200
     2.630    10.631     0.200
     3.091    13.481     0.200
     3.267    11.441     0.200
     3.320    12.997     0.200
     3.320    13.439     0.200
     3.659    12.977     0.200
     3.659    13.688     0.200
     3.723    13.847     0.200
     3.851    15.760     0.200
     4.046    13.489     0.200
     4.766    15.414     0.200
     7.208    22.335     0.200
    11.362    32.345     0.200
    11.361    29.246     0.200
    11.361    31.938     0.200
    11.362    28.331     0.200
    19.879    39.553     0.200
     1.609     5.703     0.200
     1.989    10.092     0.200
     2.274     9.428     0.200
     2.877     9.012     0.200
     3.236    13.708     0.200
     3.415    11.902     0.200
     4.226    13.852     0.200
     4.312    14.806     0.200
     8.292    26.001     0.200
    10.860    31.797     0.200
    10.860    31.792     0.200
     1.230     8.506     0.200
     1.733     9.899     0.200
     1.979     9.823     0.200
     2.504    13.046     0.200
     2.504    10.606     0.200
     2.930    11.692     0.200
     3.181    14.407     0.200
     3.246    12.768     0.200
     3.735    15.018     0.200
     3.724    15.463     0.200
     3.771    16.300     0.200
     3.807    13.639     0.200
     3.799    18.450     0.200
     3.826    16.065     0.200
     4.182    12.902     0.200
     4.372    15.130     0.200
     4.565    15.296     0.200
     4.626    16.774     0.200
     4.625    18.310     0.200
     4.683    16.921     0.200
     4.682    16.297     0.200
     4.853    18.212     0.200
     5.767    19.617     0.200
     6.055    19.473     0.200
     6.233    20.989     0.200
     6.413    18.763     0.200
     6.795    22.463     0.200
     7.429    22.930     0.200
     7.571    20.666     0.200
     8.230    23.867     0.200
     8.230    23.502     0.200
     8.883    25.002     0.200
    10.561    27.504     0.200
    10.687    29.704     0.200
    10.966    32.698     0.200
    10.966    28.069     0.200
    11.033    28.657     0.200
    11.033    29.140     0.200
    11.032    31.587     0.200
    12.611    33.234     0.200
    12.734    33.010     0.200
    13.503    36.556     0.200
    13.503    33.651     0.200
    14.038    33.960     0.200
    14.098    35.205     0.200
    14.704    34.688     0.200
    14.704    36.450     0.200
    14.711    36.691     0.200
    14.711    35.619     0.200
    14.749    38.129     0.200
    14.749    36.385     0.200
    15.322    37.057     0.200
    15.487    37.787     0.200
    15.532    37.083     0.200
    15.610    36.262     0.200
    15.610    36.670     0.200
    15.663    37.409     0.200
    15.663    37.892     0.200
    16.005    37.662     0.200
    16.059    39.669     0.200
    16.059    38.515     0.200
    16.071    38.273     0.200
    16.062    39.861     0.200
    16.062    38.079     0.200
    16.485    37.549     0.200
    16.637    38.054     0.200
    16.637    38.867     0.200
    16.641    38.186     0.200
    16.721    38.034     0.200
    16.756    38.620     0.200
    16.843    40.653     0.200
    16.843    38.928     0.200
    16.933    37.352     0.200
    16.933    38.474     0.200
    17.029    38.798     0.200
    17.185    39.365     0.200
    17.221    39.373     0.200
    17.457    38.414     0.200
    17.614    39.760     0.200
    17.708    39.779     0.200
    17.725    37.582     0.200
    17.763    38.992     0.200
    17.813    39.846     0.200
    17.785    39.085     0.200
    17.899    39.247     0.200
    17.933    39.307     0.200
    18.003    38.709     0.200
    18.086    39.121     0.200
    18.087    39.265     0.200
    18.136    38.299     0.200
    18.136    39.093     0.200
    18.188    39.002     0.200
    18.259    39.050     0.200
    18.372    41.771     0.200
    18.390    40.919     0.200
    18.543    40.782     0.200
    18.583    42.230     0.200
    18.676    42.823     0.200
    18.739    41.717     0.200
    18.982    41.137     0.200
    19.063    40.432     0.200
    19.180    41.611     0.200
    19.230    42.668     0.200
    19.229    40.618     0.200
    19.237    42.140     0.200
    19.237    42.663     0.200
    19.237    40.920     0.200
    19.290    41.508     0.200
    19.410    40.287     0.200
    19.566    41.265     0.200
    19.634    40.589     0.200
    19.722    41.080     0.200
    19.738    41.010     0.200
    19.984    40.530     0.200
    20.111    40.783     0.200
    20.365    40.216     0.200
    20.390    40.321     0.200
    20.488    40.552     0.200
    20.578    40.256     0.200
    20.646    40.540     0.200
    20.720    40.033     0.200
    20.720    39.827     0.200
    20.756    40.022     0.200
    20.759    39.467     0.200
    20.768    40.083     0.200
     1.216     7.437     0.200
     1.734    11.952     0.200
     2.102     9.712     0.200
     2.605    11.656     0.200
     2.925    11.685     0.200
     3.070    11.068     0.200
     3.930    18.587     0.200
     3.960    13.954     0.200
     4.823    15.744     0.200
     5.643    19.000     0.200
     6.867    22.582     0.200
     7.480    25.967     0.200
     7.875    23.395     0.200
     9.160    26.118     0.200
    10.225    26.291     0.200
    10.176    28.945     0.200
    10.176    29.224     0.200
    10.176    29.476     0.200
    10.176    29.392     0.200
    10.954    29.979     0.200
    11.576    29.646     0.200
    11.911    27.818     0.200
    12.008    31.643     0.200
    12.008    32.232     0.200
    12.557    36.876     0.200
    12.557    32.800     0.200
    13.090    34.563     0.200
    13.005    34.760     0.200
    13.226    33.097     0.200
    13.884    34.963     0.200
    13.715    33.491     0.200
    13.715    35.659     0.200
    14.069    35.525     0.200
    14.069    36.308     0.200
    14.204    36.340     0.200
    14.204    36.234     0.200
    14.370    38.455     0.200
    14.370    37.982     0.200
    14.843    38.400     0.200
    14.843    37.661     0.200
    14.905    37.719     0.200
    15.071    37.674     0.200
    15.108    38.477     0.200
    15.273    37.288     0.200
    15.273    37.925     0.200
    15.057    40.373     0.200
    15.862    38.954     0.200
    15.862    38.478     0.200
    15.874    39.015     0.200
    15.874    38.781     0.200
    16.099    38.874     0.200
    16.028    38.269     0.200
    16.280    37.915     0.200
    16.147    40.374     0.200
    16.345    39.000     0.200
    16.508    40.162     0.200
    17.200    39.436     0.200
    17.594    38.884     0.200
    17.490    39.810     0.200
    17.490    40.638     0.200
    17.478    40.863     0.200
    18.318    38.866     0.200
    18.398    39.431     0.200
    18.507    39.438     0.200
    18.730    39.757     0.200
    19.208    39.338     0.200
    19.514    42.438     0.200
    19.722    39.045     0.200
    19.622    41.416     0.200
    19.826    39.904     0.200
    19.780    41.301     0.200
    20.635    41.364     0.200
    20.669    41.434     0.200
    20.961    40.636     0.200
     1.299     6.202     0.200
     2.642     9.950     0.200
     3.518    12.956     0.200
     3.685    16.160     0.200
     4.156    17.253     0.200
     4.180    17.973     0.200
     4.252    13.339     0.200
     4.317    19.694     0.200
     4.360    17.427     0.200
     4.360    15.263     0.200
     4.467    14.197     0.200
     5.010    18.964     0.200
     5.307    16.073     0.200
     5.307    15.347     0.200
     5.323    19.295     0.200
     6.055    18.884     0.200
     6.819    23.392     0.200
     7.075    22.117     0.200
     7.122    20.632     0.200
     7.384    24.993     0.200
     7.783    24.431     0.200
     7.999    26.288     0.200
     8.420    26.014     0.200
     8.420    26.577     0.200
     8.847    27.690     0.200
     8.847    24.104     0.200
    10.564    28.120     0.200
    10.681    31.967     0.200
    10.681    30.639     0.200
    10.681    29.674     0.200
    10.681    29.786     0.200
    10.736    29.092     0.200
    12.427    33.893     0.200
    12.427    31.862     0.200
    13.089    34.834     0.200
    13.566    34.105     0.200
    14.268    36.708     0.200
    14.268    37.075     0.200
    14.503    36.812     0.200
    14.503    36.625     0.200
    14.586    35.458     0.200
    14.586    36.481     0.200
    14.933    38.245     0.200
    15.339    36.601     0.200
    15.339    37.163     0.200
    15.712    37.910     0.200
    15.870    36.771     0.200
    16.343    37.490     0.200
    16.343    38.357     0.200
    16.412    37.218     0.200
    16.498    38.768     0.200
    16.542    38.601     0.200
    16.730    36.692     0.200
    16.730    38.255     0.200
    16.857    38.981     0.200
    17.552    37.857     0.200
    17.686    38.508     0.200
    17.914    39.011     0.200
    17.915    37.077     0.200
    18.082    37.657     0.200
    18.383    40.550     0.200
    18.432    41.404     0.200
    18.462    40.602     0.200
    18.611    41.598     0.200
    18.605    39.773     0.200
    18.618    42.493     0.200
    18.618    41.000     0.200
    18.618    41.750     0.200
    18.680    41.654     0.200
    18.697    39.918     0.200
    18.711    39.456     0.200
    18.859    39.437     0.200
    19.009    40.679     0.200
    19.108    39.722     0.200
    19.108    40.019     0.200
    19.139    40.942     0.200
    19.344    41.101     0.200
    19.505    41.102     0.200
    19.561    41.046     0.200
    19.534    39.261     0.200
    19.610    39.244     0.200
    19.742    40.763     0.200
    19.794    41.487     0.200
    19.951    40.347     0.200
    19.984    39.785     0.200
    20.124    40.666     0.200
    20.114    40.738     0.200
    20.114    40.574     0.200
    20.128    40.826     0.200
    20.279    39.913     0.200
    20.337    40.135     0.200
    20.343    39.110     0.200
    20.406    39.642     0.200
    20.611    40.299     0.200
    20.611    40.072     0.200
    20.627    39.184     0.200
    20.698    39.728     0.200
     1.305     6.612     0.200
     1.396     7.790     0.200
     1.467     7.174     0.200
     1.435     8.067     0.200
     1.549     8.697     0.200
     1.585     7.913     0.200
     2.079    10.328     0.200
     2.079    11.027     0.200
     2.267     9.872     0.200
     2.576     9.835     0.200
     2.979    11.298     0.200
     2.962    11.748     0.200
     2.934    11.965     0.200
     3.076    12.585     0.200
     3.130    11.489     0.200
     3.113    14.844     0.200
     3.178    14.247     0.200
     3.267    12.563     0.200
     3.352    14.210     0.200
     3.423    14.491     0.200
     3.487    16.474     0.200
     3.550    13.885     0.200
     3.556    16.759     0.200
     3.570    15.791     0.200
     3.571    17.041     0.200
     3.593    17.426     0.200
     3.602    15.430     0.200
     3.697    12.579     0.200
     3.749    16.564     0.200
     3.838    17.350     0.200
     3.843    13.901     0.200
     4.000    15.273     0.200
     4.001    14.951     0.200
     4.001    14.584     0.200
     4.001    15.583     0.200
     4.108    16.450     0.200
     4.376    15.318     0.200
     4.548    15.410     0.200
     4.628    15.974     0.200
     4.718    15.749     0.200
     4.694    16.389     0.200
     4.805    14.906     0.200
     5.101    17.942     0.200
     5.088    23.306     0.200
     5.106    19.120     0.200
     5.385    18.003     0.200
     5.738    16.951     0.200
     5.748    22.533     0.200
     5.810    17.539     0.200
     5.810    19.676     0.200
     5.944    20.274     0.200
     6.117    19.473     0.200
     6.605    19.592     0.200
     6.751    20.281     0.200
     7.321    25.633     0.200
     7.548    22.644     0.200
     7.548    22.047     0.200
     8.216    22.904     0.200
     8.636    27.300     0.200
    10.520    29.447     0.200
    10.608    30.601     0.200
    11.197    30.272     0.200
    11.197    32.311     0.200
    11.197    32.300     0.200
    12.157    32.090     0.200
    12.590    33.819     0.200
    12.590    34.561     0.200
    13.732    33.501     0.200
    13.732    37.177     0.200
    14.473    36.853     0.200
    14.610    37.113     0.200
    14.708    35.291     0.200
    14.708    37.108     0.200
    15.058    37.808     0.200
    15.058    39.612     0.200
    15.388    34.533     0.200
    15.416    37.651     0.200
    15.785    38.132     0.200
    15.889    39.691     0.200
    16.426    39.064     0.200
    16.517    40.423     0.200
    16.723    38.658     0.200
    16.985    39.347     0.200
    17.085    39.072     0.200
    18.869    41.391     0.200
    19.184    41.084     0.200
    20.869    40.389     0.200
     0.908     5.678     0.200
     1.344     6.211     0.200
     2.281    10.060     0.200
     2.615     9.478     0.200
     2.544    11.267     0.200
     2.984    10.871     0.200
     3.089    13.526     0.200
     3.166    11.458     0.200
     4.029    12.800     0.200
     4.026    14.371     0.200
     4.005    15.877     0.200
     4.396    15.195     0.200
     4.755    14.905     0.200
     4.715    16.258     0.200
     1.169     8.469     0.200
     1.180     8.322     0.200
     1.212     8.511     0.200
     1.226     8.756     0.200
     1.721    10.235     0.200
     2.020     7.920     0.200
     2.500    12.194     0.200
     2.915    12.146     0.200
     3.288    11.098     0.200
     3.691    10.797     0.200
     3.759    14.893     0.200
     3.712    12.764     0.200
     4.035    16.188     0.200
     4.182    13.280     0.200
     4.182    12.789     0.200
     4.203    16.004     0.200
     4.413    20.092     0.200
     4.445    16.134     0.200
     4.523    16.885     0.200
     4.718    17.065     0.200
     4.643    19.853     0.200
     4.715    16.475     0.200
     4.627    18.542     0.200
     5.080    17.420     0.200
     5.434    17.864     0.200
     5.400    18.151     0.200
     5.522    19.330     0.200
     5.820    19.468     0.200
     6.081    19.720     0.200
     6.391    20.200     0.200
     6.527    19.683     0.200
     6.944    22.297     0.200
     7.542    23.904     0.200
     7.845    26.631     0.200
     7.995    25.348     0.200
     8.261    24.089     0.200
     8.261    24.370     0.200
     8.831    26.949     0.200
    10.651    27.626     0.200
    10.985    31.548     0.200
    10.984    32.415     0.200
    10.984    31.841     0.200
    10.985    31.836     0.200
    11.210    31.807     0.200
    11.240    31.991     0.200
    11.333    32.496     0.200
    12.572    33.605     0.200
    13.453    35.618     0.200
    13.453    37.017     0.200
    14.044    35.609     0.200
    14.697    37.326     0.200
    15.617    37.993     0.200
    15.617    40.513     0.200
    16.036    39.003     0.200
    16.592    39.902     0.200
    16.724    39.869     0.200
    16.792    41.065     0.200
    16.792    40.469     0.200
    16.893    38.653     0.200
    17.167    40.153     0.200
    17.758    41.048     0.200
    17.905    39.013     0.200
    18.114    39.295     0.200
    18.529    42.280     0.200
    18.785    42.451     0.200
    19.183    41.163     0.200
    19.352    41.593     0.200
    19.684    41.802     0.200
    20.336    42.098     0.200
    20.641    41.165     0.200
     0.300     5.488     0.200
     0.867     5.604     0.200
     0.953     5.657     0.200
     1.057     5.965     0.200
     1.073     7.201     0.200
     1.077     7.231     0.200
     1.098     7.134     0.200
     1.349     6.998     0.200
     1.806     7.620     0.200
     2.122     9.939     0.200
     2.122    10.196     0.200
     2.640    10.891     0.200
     2.864    10.189     0.200
     3.076    10.666     0.200
     3.374    12.367     0.200
     3.434    13.548     0.200
     3.821    13.868     0.200
     3.857    14.257     0.200
     4.187    12.171     0.200
     4.293    15.021     0.200
     4.280    13.317     0.200
     4.280    12.013     0.200
     4.430    14.327     0.200
     4.430    13.077     0.200
     7.968    22.048     0.200
     8.107    24.980     0.200
    10.359    26.158     0.200
    10.713    27.819     0.200
    10.798    27.127     0.200
    10.798    26.568     0.200
    12.303    30.733     0.200
    13.190    32.203     0.200
    13.220    32.570     0.200
    13.690    32.897     0.200
    14.373    33.746     0.200
    14.409    34.698     0.200
    14.592    33.634     0.200
    14.975    34.413     0.200
    15.254    35.192     0.200
    15.411    35.698     0.200
    15.679    36.899     0.200
    15.835    35.452     0.200
    15.900    36.393     0.200
    16.370    36.885     0.200
    16.629    36.216     0.200
    16.649    36.373     0.200
    16.714    36.653     0.200
    17.448    37.054     0.200
    17.802    36.167     0.200
    18.179    37.812     0.200
     1.724     9.719     0.200
     1.976     8.828     0.200
     1.966    11.416     0.200
     2.496    12.745     0.200
     2.496    12.405     0.200
     2.925    11.603     0.200
     2.965    12.220     0.200
     3.243    13.176     0.200
     3.537    16.696     0.200
     3.635    14.328     0.200
     3.729    12.779     0.200
     3.716    16.425     0.200
     3.804    14.253     0.200
     3.818    15.347     0.200
     4.072    16.957     0.200
     4.162    13.270     0.200
     4.177    15.246     0.200
     4.175    17.488     0.200
     4.180    17.455     0.200
     4.200    18.309     0.200
     4.265    17.722     0.200
     4.369    15.221     0.200
     4.345    19.255     0.200
     4.558    17.643     0.200
     4.619    19.228     0.200
     4.678    16.658     0.200
     4.678    16.526     0.200
     5.046    15.715     0.200
     5.390    17.003     0.200
     5.761    19.242     0.200
     8.046    27.153     0.200
     8.225    23.780     0.200
    10.961    29.566     0.200
    11.027    27.821     0.200
    11.026    32.236     0.200
    11.026    28.857     0.200
    12.604    36.576     0.200
    13.498    37.112     0.200
    14.697    38.427     0.200
    14.703    37.514     0.200
    15.602    38.865     0.200
    16.008    37.256     0.200
    16.837    39.668     0.200
    16.926    38.654     0.200
    18.622    40.236     0.200
    18.674    40.757     0.200
    18.980    40.667     0.200
    19.228    40.628     0.200
    19.235    41.417     0.200
    19.235    41.167     0.200
    19.235    40.280     0.200
    19.288    40.513     0.200
    19.399    40.618     0.200
    19.499    40.573     0.200
    19.499    42.041     0.200
    19.626    41.206     0.200
    19.633    41.047     0.200
    19.642    40.022     0.200
    20.109    39.815     0.200
    20.196    40.550     0.200
    20.363    40.415     0.200
    20.387    40.930     0.200
    20.685    40.385     0.200
    20.689    39.812     0.200
     0.874     5.479     0.200
     1.929     7.555     0.200
     1.983     8.238     0.200
     2.391    12.207     0.200
     2.847    11.306     0.200
     2.924    12.285     0.200
     3.200    10.705     0.200
     3.067    12.399     0.200
     3.565    13.293     0.200
     3.649    12.702     0.200
     3.609    13.108     0.200
     3.661    15.387     0.200
     3.703    13.678     0.200
     3.728    14.697     0.200
     3.922    17.889     0.200
     4.064    17.342     0.200
     4.090    14.263     0.200
     4.473    16.218     0.200
     4.612    15.933     0.200
     5.343    16.514     0.200
     5.722    18.820     0.200
     5.973    16.978     0.200
     8.157    23.266     0.200
     8.666    22.698     0.200
    10.955    32.050     0.200
    12.777    33.927     0.200
    16.776    38.855     0.200
     0.774     5.653     0.200
     0.875     4.977     0.200
     1.263     6.164     0.200
     1.379     6.982     0.200
     1.490     7.813     0.200
     1.494     7.812     0.200
     1.493     7.612     0.200
     1.513     7.678     0.200
     1.559     6.584     0.200
     1.618     7.594     0.200
     1.645     8.820     0.200
     1.999     8.545     0.200
     2.507    10.234     0.200
     2.666    11.984     0.200
     2.737    11.660     0.200
     2.793    11.599     0.200
     3.024    11.763     0.200
     3.062    13.713     0.200
     3.225    12.274     0.200
     3.596    12.031     0.200
     3.665    14.226     0.200
     3.699    14.181     0.200
     3.796    13.457     0.200
     3.829    13.695     0.200
     4.135    14.135     0.200
     4.607    14.648     0.200
     4.613    15.628     0.200
     4.936    16.423     0.200
     5.124    16.501     0.200
     6.361    18.172     0.200
     7.330    20.566     0.200
     7.982    20.390     0.200
     1.005     6.081     0.200
     1.642     8.836     0.200
     1.754     8.022     0.200
     1.853     8.783     0.200
     1.853     8.893     0.200
     1.835     9.751     0.200
     1.957     9.301     0.200
     2.063     9.653     0.200
     1.909    11.831     0.200
     1.909    10.912     0.200
     2.277     9.856     0.200
     2.277     9.686     0.200
     2.510     9.657     0.200
     2.680    13.022     0.200
     2.647    11.649     0.200
     2.824    10.701     0.200
     2.767    12.533     0.200
     2.767    11.852     0.200
     2.840    13.368     0.200
     2.840    13.519     0.200
     3.099    15.063     0.200
     3.143    14.805     0.200
     3.211    12.687     0.200
     3.190    14.803     0.200
     3.253    12.883     0.200
     3.253    12.713     0.200
     3.263    13.756     0.200
     3.292    15.947     0.200
     3.393    12.792     0.200
     3.393    12.243     0.200
     3.319    15.650     0.200
     3.396    15.489     0.200
     3.413    15.562     0.200
     3.579    14.798     0.200
     3.587    13.910     0.200
     3.685    14.160     0.200
     3.684    13.567     0.200
     3.684    14.008     0.200
     3.705    15.893     0.200
     3.707    15.019     0.200
     3.817    14.787     0.200
     3.867    13.709     0.200
     3.865    16.008     0.200
     4.061    13.714     0.200
     4.412    14.865     0.200
     4.379    15.607     0.200
     4.489    16.257     0.200
     4.489    14.317     0.200
     4.410    18.446     0.200
     4.787    16.708     0.200
     4.665    17.329     0.200
     4.665    17.029     0.200
     4.997    16.905     0.200
     5.071    16.027     0.200
     5.071    15.857     0.200
     5.432    17.686     0.200
     5.494    18.435     0.200
     5.494    18.438     0.200
     5.452    16.707     0.200
     5.807    20.481     0.200
     5.807    19.619     0.200
     6.289    19.079     0.200
     6.443    18.723     0.200
     6.443    20.313     0.200
     7.232    21.454     0.200
     7.309    23.428     0.200
     7.900    22.547     0.200
     8.947    23.815     0.200
     8.899    27.395     0.200
    10.178    29.207     0.200
    10.207    29.206     0.200
    10.301    29.557     0.200
    11.260    34.975     0.200
     0.287     4.932     0.200
     1.770     6.937     0.200
     2.111    10.695     0.200
     2.130    10.414     0.200
     2.130    10.103     0.200
     2.620     9.783     0.200
     3.041    10.187     0.200
     2.830    10.558     0.200
     2.830    11.776     0.200
     2.910    10.864     0.200
     3.350    11.841     0.200
     3.416    12.272     0.200
     3.354    11.737     0.200
     3.813    14.496     0.200
     3.844    13.619     0.200
     4.280    15.606     0.200
     4.281    15.591     0.200
     4.404    16.156     0.200
     4.404    14.806     0.200
     4.320    14.493     0.200
     4.753    15.464     0.200
     5.074    16.408     0.200
     5.172    15.611     0.200
     5.217    16.970     0.200
     5.529    17.739     0.200
     7.944    21.975     0.200
     8.148    25.804     0.200
     8.758    26.606     0.200
     8.764    25.656     0.200
    10.841    29.119     0.200
    10.841    29.462     0.200
    10.841    28.476     0.200
     0.798     5.039     0.200
     0.906     6.226     0.200
     0.978     7.927     0.200
     1.248     7.847     0.200
     1.395     6.361     0.200
     1.437     6.798     0.200
     1.490     8.210     0.200
     1.587     6.508     0.200
     1.661    10.520     0.200
     2.109     9.397     0.200
     2.187     8.198     0.200
     2.294    10.233     0.200
     2.540     9.859     0.200
     2.639    10.316     0.200
     2.477    11.845     0.200
     2.854    11.255     0.200
     2.898    11.465     0.200
     2.920     9.736     0.200
     3.285    14.181     0.200
     3.317    12.855     0.200
     3.405    13.909     0.200
     3.915    14.347     0.200
     3.953    14.282     0.200
     4.247    14.894     0.200
     4.198    14.855     0.200
     4.198    15.585     0.200
     4.569    15.938     0.200
     4.736    14.886     0.200
     4.733    16.154     0.200
     4.926    16.990     0.200
     5.059    17.149     0.200
     5.231    17.486     0.200
     5.752    17.604     0.200
     5.733    18.320     0.200
     5.733    18.323     0.200
     6.751    19.797     0.200
     7.445    21.841     0.200
     8.494    24.530     0.200
     8.826    24.836     0.200
    10.785    26.213     0.200
    10.784    25.946     0.200
    10.784    30.249     0.200
    11.139    28.533     0.200
    12.137    30.789     0.200
    12.986    31.823     0.200
    13.691    32.276     0.200
    13.709    33.073     0.200
    13.899    31.391     0.200
    14.257    32.208     0.200
    15.135    33.701     0.200
    15.359    34.602     0.200
    15.789    35.530     0.200
    15.958    35.699     0.200
    16.143    35.039     0.200
    16.469    35.084     0.200
     1.118     6.361     0.200
     1.314     6.758     0.200
     2.374     9.928     0.200
     2.655    11.148     0.200
     2.902    11.552     0.200
     3.192    14.576     0.200
     3.708    15.231     0.200
     3.728    15.189     0.200
     4.061    14.584     0.200
     4.381    16.537     0.200
     4.488    16.718     0.200
     4.520    15.927     0.200
     4.834    17.774     0.200
     5.059    15.169     0.200
     1.325     9.012     0.200
     1.319     8.559     0.200
     1.788    10.401     0.200
     1.730    11.305     0.200
     1.990    10.768     0.200
     2.091    12.233     0.200
     2.091    12.024     0.200
     2.106    11.266     0.200
     2.094    12.457     0.200
     2.185    12.366     0.200
     2.779    15.463     0.200
     2.803    15.410     0.200
     2.840    13.377     0.200
     3.057    13.479     0.200
     3.312    16.131     0.200
     3.319    16.294     0.200
     3.309    15.931     0.200
     3.348    15.263     0.200
     3.364    16.471     0.200
     3.406    15.215     0.200
     3.406    15.586     0.200
     3.459    16.461     0.200
     3.454    16.822     0.200
     3.502    14.780     0.200
     3.593    15.987     0.200
     3.595    15.164     0.200
     3.644    16.244     0.200
     3.698    18.512     0.200
     3.788    18.108     0.200
     3.790    17.679     0.200
     3.790    17.147     0.200
     3.790    18.089     0.200
     3.806    17.676     0.200
     3.814    15.881     0.200
     3.828    16.764     0.200
     3.887    17.877     0.200
     3.900    16.180     0.200
     3.921    17.234     0.200
     3.976    18.927     0.200
     4.121    18.986     0.200
     4.166    16.373     0.200
     4.219    18.458     0.200
     4.218    18.463     0.200
     4.261    18.775     0.200
     4.262    18.760     0.200
     4.266    17.992     0.200
     4.263    17.559     0.200
     4.263    17.139     0.200
     4.404    18.131     0.200
     4.428    18.103     0.200
     4.446    19.732     0.200
     4.748    18.948     0.200
     5.070    19.858     0.200
     5.183    18.995     0.200
     5.219    20.199     0.200
     5.337    21.623     0.200
     5.436    20.415     0.200
     5.448    20.685     0.200
     5.534    20.938     0.200
     5.737    21.077     0.200
     5.829    22.751     0.200
     6.009    21.478     0.200
     6.202    21.852     0.200
     6.222    21.695     0.200
     6.221    21.698     0.200
     6.975    22.968     0.200
     7.209    23.024     0.200
     7.942    25.266     0.200
     8.121    30.304     0.200
     8.714    28.314     0.200
     8.729    27.781     0.200
     9.436    27.060     0.200
    10.182    28.453     0.200
    10.337    29.788     0.200
    10.687    31.915     0.200
    10.786    32.645     0.200
    10.786    32.638     0.200
    10.786    32.500     0.200
    10.786    32.009     0.200
    11.426    31.625     0.200
    11.533    34.608     0.200
    11.504    33.799     0.200
    11.622    32.853     0.200
    11.821    33.385     0.200
    12.159    33.621     0.200
    12.283    33.040     0.200
    12.341    36.331     0.200
    12.483    33.544     0.200
    12.822    34.076     0.200
    13.246    33.762     0.200
    13.292    35.239     0.200
    13.559    35.259     0.200
    13.679    36.841     0.200
    13.787    36.807     0.200
    13.910    37.958     0.200
    13.980    36.921     0.200
    14.082    36.959     0.200
    14.351    37.484     0.200
    14.390    36.331     0.200
    14.587    40.133     0.200
    14.951    38.096     0.200
    14.989    38.412     0.200
    15.232    37.920     0.200
    15.397    37.756     0.200
    15.389    40.864     0.200
    15.657    39.758     0.200
    15.719    41.833     0.200
    15.744    38.784     0.200
    15.828    40.315     0.200
    15.872    39.435     0.200
    15.892    38.581     0.200
    16.020    39.291     0.200
    16.354    39.906     0.200
    16.385    39.980     0.200
    16.640    41.085     0.200
    17.551    40.462     0.200
    17.504    42.283     0.200
    18.080    42.154     0.200
    18.222    41.252     0.200
    18.303    41.674     0.200
    18.347    40.916     0.200
    18.472    41.089     0.200
    18.461    42.070     0.200
    18.657    43.613     0.200
    19.215    44.009     0.200
    19.279    43.129     0.200
    19.606    44.233     0.200
     0.641     4.321     0.200
     1.127     5.683     0.200
     1.914     8.787     0.200
     2.159    10.713     0.200
     2.427    10.267     0.200
     2.640    11.800     0.200
     2.715    12.569     0.200
     2.901    10.806     0.200
     2.785    11.787     0.200
     3.165    12.572     0.200
     3.610    15.246     0.200
     3.695    13.277     0.200
     3.720    13.621     0.200
     3.601    15.342     0.200
     4.044    14.154     0.200
     1.120     6.731     0.200
     1.455     7.191     0.200
     1.686     7.820     0.200
     1.665     9.290     0.200
     1.873     7.365     0.200
     2.058     9.286     0.200
     2.079     8.848     0.200
     2.433    11.264     0.200
     2.823    11.428     0.200
     3.020    12.532     0.200
     3.044    13.151     0.200
     3.068    15.891     0.200
     3.141    12.558     0.200
     3.127    15.859     0.200
     3.532    14.520     0.200
     3.628    15.377     0.200
     3.653    16.584     0.200
     3.701    14.325     0.200
     3.683    15.595     0.200
     4.069    15.269     0.200
     4.069    17.291     0.200
     4.080    14.451     0.200
     4.266    14.119     0.200
     4.523    16.388     0.200
     4.535    16.463     0.200
     4.536    16.457     0.200
     4.561    16.920     0.200
     4.561    15.170     0.200
     4.574    15.506     0.200
     4.574    15.836     0.200
     4.794    19.116     0.200
     4.944    16.304     0.200
     5.263    17.373     0.200
     5.288    16.150     0.200
     5.380    17.947     0.200
     5.661    19.648     0.200
     5.676    18.547     0.200
     5.718    15.592     0.200
     5.947    18.794     0.200
     6.177    20.124     0.200
     6.307    19.262     0.200
     6.385    20.235     0.200
     6.385    20.237     0.200
     7.037    24.400     0.200
     7.322    21.054     0.200
     7.451    23.203     0.200
     7.533    23.151     0.200
     7.854    22.620     0.200
     8.121    22.951     0.200
     8.135    24.554     0.200
     8.921    26.355     0.200
     8.921    28.985     0.200
     9.774    28.991     0.200
    10.664    29.650     0.200
    10.664    31.269     0.200
    11.049    31.044     0.200
    11.049    30.190     0.200
    11.049    32.127     0.200
    11.403    31.778     0.200
    11.713    32.151     0.200
    11.710    30.843     0.200
    11.827    31.881     0.200
    12.085    32.039     0.200
    12.598    33.108     0.200
    12.598    35.907     0.200
    12.802    33.496     0.200
    12.782    35.255     0.200
    13.083    34.304     0.200
    13.507    34.613     0.200
    13.530    35.549     0.200
    13.530    37.702     0.200
    13.529    33.959     0.200
    13.566    33.723     0.200
    13.839    34.338     0.200
    13.933    37.226     0.200
    13.974    37.479     0.200
    14.120    37.262     0.200
    14.150    33.741     0.200
    14.176    37.378     0.200
    14.680    37.098     0.200
    14.701    36.981     0.200
    14.723    38.196     0.200
    14.790    37.297     0.200
    14.855    38.254     0.200
    15.238    39.110     0.200
    15.294    38.833     0.200
    15.512    38.017     0.200
    15.543    38.556     0.200
    15.558    38.655     0.200
    15.571    39.117     0.200
    15.673    38.319     0.200
    15.983    38.553     0.200
    16.047    36.494     0.200
    16.095    39.345     0.200
    16.922    38.839     0.200
    17.683    37.109     0.200
    17.793    36.524     0.200
    17.953    37.883     0.200
    18.089    39.473     0.200
    18.082    39.673     0.200
    18.445    39.406     0.200
    18.468    40.307     0.200
    18.601    40.843     0.200
    18.634    39.628     0.200
    18.634    41.515     0.200
    18.689    41.171     0.200
    18.751    41.204     0.200
    18.729    40.764     0.200
    18.808    41.463     0.200
    18.794    40.582     0.200
    18.821    39.618     0.200
    18.841    40.689     0.200
    18.852    41.477     0.200
    19.241    39.936     0.200
    19.302    40.767     0.200
    19.309    41.443     0.200
    19.309    41.117     0.200
    19.360    42.061     0.200
    19.440    40.200     0.200
    19.440    42.134     0.200
    19.676    41.439     0.200
    19.709    40.490     0.200
    19.806    40.802     0.200
    20.180    40.603     0.200
    20.194    39.196     0.200
    20.439    40.145     0.200
    20.456    40.297     0.200
    20.508    39.873     0.200
    20.559    39.907     0.200
    20.706    40.430     0.200
    20.736    40.657     0.200
    20.789    40.072     0.200
    20.832    39.509     0.200
     1.109     7.669     0.200
     1.657     7.581     0.200
     1.887     7.398     0.200
     2.029     8.549     0.200
     2.817    10.727     0.200
     3.157    11.938     0.200
     2.971    12.594     0.200
     3.079     9.551     0.200
     3.531    16.312     0.200
     3.620    13.177     0.200
     4.049    12.472     0.200
     4.066    14.493     0.200
     4.504    17.652     0.200
     4.505    17.646     0.200
     4.505    14.984     0.200
     4.505    16.625     0.200
     8.102    24.307     0.200
     8.869    23.574     0.200
     9.722    24.230     0.200
    10.609    27.098     0.200
    10.993    28.198     0.200
    10.993    27.722     0.200
    10.993    31.105     0.200
    11.347    31.322     0.200
    11.658    30.597     0.200
    11.773    28.524     0.200
    12.029    29.730     0.200
    12.543    31.209     0.200
    12.726    34.802     0.200
    12.894    31.210     0.200
    13.028    31.957     0.200
    13.455    32.927     0.200
    13.511    32.571     0.200
    13.476    35.089     0.200
    13.476    33.648     0.200
    13.703    33.601     0.200
    13.783    30.916     0.200
    13.919    32.659     0.200
    14.626    32.577     0.200
    14.626    34.980     0.200
    14.645    33.253     0.200
    14.645    35.112     0.200
    14.667    33.581     0.200
    14.738    34.953     0.200
    14.738    35.871     0.200
    14.799    35.971     0.200
    14.966    34.644     0.200
    15.087    36.372     0.200
    15.238    37.707     0.200
    15.420    34.986     0.200
    15.456    35.955     0.200
    15.519    34.292     0.200
    15.519    37.358     0.200
    15.503    36.166     0.200
    15.617    36.365     0.200
    15.890    35.802     0.200
    16.006    34.405     0.200
    15.994    34.349     0.200
    16.079    35.276     0.200
    16.079    38.787     0.200
    16.566    35.006     0.200
    16.586    39.197     0.200
    16.586    38.682     0.200
    16.670    35.932     0.200
    16.818    39.516     0.200
    16.866    37.842     0.200
    16.958    38.450     0.200
    17.618    40.017     0.200
    17.738    36.747     0.200
    17.702    38.934     0.200
    18.033    37.840     0.200
    18.490    40.208     0.200
    18.584    40.227     0.200
    18.584    40.039     0.200
    18.643    40.281     0.200
    18.766    39.381     0.200
    18.797    40.201     0.200
    18.765    40.267     0.200
    19.267    41.796     0.200
    19.387    39.828     0.200
    19.524    38.499     0.200
    19.622    40.024     0.200
    20.236    40.007     0.200
    20.356    39.017     0.200
    20.452    39.167     0.200
     0.911     5.920     0.200
     0.791     7.219     0.200
     1.017     6.916     0.200
     1.195     7.135     0.200
     1.262     7.967     0.200
     1.259     7.847     0.200
     1.269     7.940     0.200
     1.291     8.084     0.200
     1.314     7.558     0.200
     1.310     7.997     0.200
     1.432     6.864     0.200
     1.454     7.701     0.200
     1.508     7.110     0.200
     2.106     9.495     0.200
     2.165     7.785     0.200
     2.507     8.465     0.200
     2.724     9.937     0.200
     2.867    11.976     0.200
     2.878    11.498     0.200
     2.974    10.815     0.200
     3.209    11.686     0.200
     3.267    14.231     0.200
     3.693    14.001     0.200
     3.792    12.788     0.200
     3.932    14.148     0.200
     4.004    15.011     0.200
     4.243    14.890     0.200
     4.566    15.253     0.200
    10.594    25.890     0.200
     0.820     4.495     0.200
     1.146     4.894     0.200
     1.205     5.283     0.200
     1.537     6.630     0.200
     1.599     7.963     0.200
     1.594     8.118     0.200
     1.607     7.883     0.200
     1.626     8.279     0.200
     1.656     7.931     0.200
     1.646     8.219     0.200
     1.763     7.361     0.200
     1.773     7.872     0.200
     1.794     7.529     0.200
     2.394    10.603     0.200
     2.503     9.997     0.200
     2.528    10.698     0.200
     2.553    11.283     0.200
     2.881    10.559     0.200
     2.847    11.470     0.200
     2.965    13.154     0.200
     3.400    13.053     0.200
     3.593    12.339     0.200
     3.644    13.083     0.200
     3.912    14.665     0.200
     1.485     8.935     0.200
     1.655    11.043     0.200
     1.840    11.259     0.200
     1.976    10.389     0.200
     2.156    10.300     0.200
     2.118    11.458     0.200
     2.155    12.008     0.200
     2.469    11.742     0.200
     2.502    13.538     0.200
     2.505    11.854     0.200
     2.844    12.745     0.200
     2.949    13.158     0.200
     2.948    15.120     0.200
     2.948    13.640     0.200
     3.176    13.489     0.200
     3.205    15.262     0.200
     3.243    15.189     0.200
     3.226    15.527     0.200
     3.283    16.275     0.200
     3.418    16.137     0.200
     3.421    14.095     0.200
     3.431    14.834     0.200
     3.440    16.129     0.200
     3.443    16.342     0.200
     3.486    16.764     0.200
     3.516    13.026     0.200
     3.565    17.135     0.200
     3.536    17.433     0.200
     3.572    14.853     0.200
     3.614    16.998     0.200
     3.655    14.738     0.200
     3.621    14.144     0.200
     3.621    14.644     0.200
     3.724    13.525     0.200
     3.789    18.127     0.200
     3.844    18.590     0.200
     3.940    18.746     0.200
     4.308    14.810     0.200
     4.308    18.071     0.200
     4.587    16.984     0.200
     4.910    18.199     0.200
     5.131    20.042     0.200
     5.195    21.205     0.200
     5.216    19.125     0.200
     5.171    18.451     0.200
     5.399    19.743     0.200
     5.484    20.911     0.200
     5.530    21.166     0.200
     6.045    22.678     0.200
     6.118    22.507     0.200
     6.224    21.488     0.200
     6.352    25.557     0.200
     6.512    21.128     0.200
     6.846    22.664     0.200
     7.205    24.425     0.200
     8.414    24.386     0.200
     8.783    30.128     0.200
     9.498    25.549     0.200
     9.754    30.406     0.200
    10.183    28.806     0.200
    13.921    34.110     0.200
    14.549    36.598     0.200
    14.556    36.662     0.200
    14.568    37.905     0.200
    14.774    38.287     0.200
    14.955    36.680     0.200
    15.074    35.773     0.200
    15.717    38.874     0.200
    15.943    38.100     0.200
    16.080    39.979     0.200
    16.662    40.086     0.200
    16.765    40.540     0.200
    16.872    39.439     0.200
    17.253    40.110     0.200
    17.545    40.345     0.200
    17.640    38.245     0.200
    17.797    39.735     0.200
    17.815    39.815     0.200
    18.229    40.695     0.200
    18.293    39.285     0.200
    18.885    44.364     0.200
     1.266     8.397     0.200
     1.271     7.514     0.200
     1.274     8.508     0.200
     1.429     7.465     0.200
     1.303     8.516     0.200
     1.320     8.600     0.200
     1.324     8.520     0.200
     1.710     9.134     0.200
     2.053     8.112     0.200
     2.082    11.710     0.200
     2.408    12.530     0.200
     2.604    11.733     0.200
     2.799    11.830     0.200
     2.799    11.449     0.200
     3.116    11.402     0.200
     3.518    12.271     0.200
     3.604    14.406     0.200
     3.602    14.893     0.200
     3.675    13.190     0.200
     3.640    13.254     0.200
     3.665    16.003     0.200
     3.851    17.920     0.200
     3.814    15.167     0.200
     3.900    16.704     0.200
     3.958    13.735     0.200
     4.027    15.881     0.200
     4.046    13.432     0.200
     4.057    15.948     0.200
     4.047    13.078     0.200
     4.066    16.238     0.200
     4.085    17.144     0.200
     4.162    13.825     0.200
     4.170    15.937     0.200
     4.240    14.564     0.200
     4.312    17.241     0.200
     4.364    16.179     0.200
     4.524    12.648     0.200
     4.500    17.901     0.200
     4.549    13.988     0.200
     4.549    16.398     0.200
     4.517    17.739     0.200
     4.540    16.014     0.200
     4.564    14.475     0.200
     4.564    16.914     0.200
     4.783    14.483     0.200
     5.262    17.284     0.200
     5.650    17.972     0.200
     5.636    18.626     0.200
     5.922    17.388     0.200
     6.167    20.191     0.200
     6.281    19.667     0.200
     7.051    24.415     0.200
     7.297    19.810     0.200
     7.527    22.036     0.200
     8.096    23.851     0.200
     8.096    23.632     0.200
     8.158    25.078     0.200
    11.057    28.677     0.200
    11.056    28.501     0.200
    11.056    32.456     0.200
    12.092    30.583     0.200
    14.953    37.292     0.200
    15.019    34.848     0.200
    15.297    39.206     0.200
    15.516    37.426     0.200
    15.565    36.737     0.200
    15.680    36.638     0.200
    16.923    36.667     0.200
    17.022    37.789     0.200
     2.195     9.228     0.200
     2.890     9.063     0.200
     2.726    12.999     0.200
     3.166    14.709     0.200
     3.493    13.517     0.200
     4.022    13.346     0.200
     4.119    12.038     0.200
     4.424    15.244     0.200
     4.664    16.091     0.200
     4.995    16.500     0.200
     5.087    15.480     0.200
     5.264    18.618     0.200
     5.358    17.629     0.200
     5.909    19.035     0.200
     5.944    18.330     0.200
     6.264    20.706     0.200
     0.414     4.590     0.200
     0.901     4.972     0.200
     1.080     5.531     0.200
     1.239     4.861     0.200
     1.611     8.063     0.200
     1.524     9.123     0.200
     1.778     8.080     0.200
     1.871     8.419     0.200
     1.869     8.638     0.200
     1.876     8.461     0.200
     1.901     8.860     0.200
     1.965     8.141     0.200
     1.919     8.827     0.200
     1.876    10.818     0.200
     2.020     8.740     0.200
     2.116     8.039     0.200
     2.338    10.359     0.200
     2.413    10.700     0.200
     2.434    12.806     0.200
     2.623     9.903     0.200
     2.717     9.061     0.200
     2.742    13.419     0.200
     2.872    11.956     0.200
     2.874    11.335     0.200
     2.891    12.415     0.200
     3.071    11.085     0.200
     3.195    10.940     0.200
     3.354    13.856     0.200
     1.222     7.139     0.200
     2.394    11.146     0.200
     2.656    12.345     0.200
     3.461    13.817     0.200
     3.624    16.488     0.200
     3.869    13.573     0.200
     5.193    15.553     0.200
     5.306    15.919     0.200
     1.357     7.209     0.200
     1.625     8.782     0.200
     1.670     8.767     0.200
     1.802     8.862     0.200
     1.822    10.459     0.200
     1.825    10.352     0.200
     1.841    10.523     0.200
     1.866    10.657     0.200
     1.877    10.483     0.200
     1.887     9.843     0.200
     2.212    10.245     0.200
     2.198    11.683     0.200
     2.413    10.103     0.200
     2.414    10.521     0.200
     2.559    13.878     0.200
     2.873    11.906     0.200
     2.979    13.936     0.200
     3.250    14.153     0.200
     3.335    15.036     0.200
     3.541    13.406     0.200
     3.499    17.622     0.200
     3.479    14.822     0.200
     3.479    16.572     0.200
     3.578    15.419     0.200
     3.597    14.241     0.200
     3.751    17.402     0.200
     3.894    18.148     0.200
     4.063    15.788     0.200
     4.563    16.216     0.200
     4.692    18.466     0.200
     4.853    17.569     0.200
     4.853    21.140     0.200
     4.970    17.799     0.200
     5.581    18.546     0.200
     6.089    21.028     0.200
     7.572    23.007     0.200
    11.429    32.610     0.200
    11.429    33.764     0.200
    11.429    35.811     0.200
    19.237    43.714     0.200
     0.948     4.434     0.200
     0.923     5.926     0.200
     0.929     6.709     0.200
     0.938     6.794     0.200
     0.947     6.924     0.200
     0.962     7.093     0.200
     0.982     6.913     0.200
     1.020     7.180     0.200
     1.126     7.166     0.200
     1.220     6.854     0.200
     1.540     8.488     0.200
     1.859     6.140     0.200
     1.913     9.991     0.200
     2.377     9.236     0.200
     3.063    10.750     0.200
     3.122    13.407     0.200
     3.148    11.728     0.200
     3.546    13.102     0.200
     4.117    12.805     0.200
     4.501    15.106     0.200
     4.824    15.847     0.200
     5.386    17.298     0.200
     5.451    17.353     0.200
     2.426    11.414     0.200
     2.542    12.239     0.200
     2.849    13.711     0.200
     2.980    13.973     0.200
     3.560    12.465     0.200
     3.617    13.245     0.200
     3.715    14.381     0.200
     4.542    17.745     0.200
     4.971    18.680     0.200
     0.980     6.099     0.200
     1.858     8.124     0.200
     2.429    12.106     0.200
     3.521    14.850     0.200
     3.620    15.226     0.200
     3.692    16.790     0.200
     3.686    14.970     0.200
     3.832    14.028     0.200
     3.919    16.773     0.200
     4.562    15.690     0.200
     4.562    16.296     0.200
     4.581    18.476     0.200
     4.934    14.468     0.200
     5.252    17.260     0.200
     5.367    19.639     0.200
     5.663    17.983     0.200
     5.938    16.518     0.200
     1.236     7.397     0.200
     3.412    16.231     0.200
     3.682    17.690     0.200
     3.915    14.383     0.200
     4.151    18.078     0.200
     4.166    14.533     0.200
     4.323    19.839     0.200
     4.450    18.533     0.200
     4.557    19.888     0.200
     5.022    18.854     0.200
     5.229    20.534     0.200
     5.873    20.105     0.200
     1.541     8.244     0.200
     1.663     9.210     0.200
     1.581     6.717     0.200
     1.968     8.292     0.200
     2.173    10.093     0.200
     3.029    13.521     0.200
     2.869    12.613     0.200
     3.057    14.235     0.200
     2.920    12.246     0.200
     3.238    12.456     0.200
     3.610    13.953     0.200
     3.649    15.349     0.200
     3.654    15.702     0.200
     3.654    15.962     0.200
     3.697    15.756     0.200
     3.710    15.652     0.200
     3.752    15.424     0.200
     3.795    15.011     0.200
     3.754    15.443     0.200
     3.971    16.263     0.200
     4.027    16.581     0.200
     4.114    17.048     0.200
     4.118    16.226     0.200
     4.118    17.255     0.200
     4.129    17.808     0.200
     4.135    16.570     0.200
     4.139    15.723     0.200
     4.143    16.772     0.200
     4.157    17.495     0.200
     4.162    15.972     0.200
     4.197    13.466     0.200
     4.230    16.028     0.200
     4.361    14.935     0.200
     4.564    17.486     0.200
     4.580    17.274     0.200
     4.495    15.503     0.200
     4.495    17.303     0.200
     4.602    16.835     0.200
     4.657    16.576     0.200
     4.657    16.755     0.200
     4.781    18.501     0.200
     5.020    17.461     0.200
     5.340    18.221     0.200
     5.382    17.448     0.200
     5.464    18.591     0.200
     5.685    20.226     0.200
     5.729    19.137     0.200
     5.764    19.477     0.200
     5.613    16.250     0.200
     6.020    19.342     0.200
     6.160    20.677     0.200
     6.328    19.212     0.200
     6.402    20.479     0.200
     6.469    21.465     0.200
     6.746    21.836     0.200
     6.942    23.800     0.200
     7.249    21.853     0.200
     7.416    22.574     0.200
     7.497    23.928     0.200
     7.855    21.370     0.200
     7.806    25.593     0.200
     8.202    23.905     0.200
     8.202    24.026     0.200
     8.028    25.595     0.200
     8.028    25.726     0.200
     8.642    26.431     0.200
     8.865    24.883     0.200
     8.828    24.685     0.200
     8.828    27.796     0.200
     8.940    28.772     0.200
     9.369    29.193     0.200
     9.674    29.565     0.200
     9.734    27.370     0.200
     9.636    28.588     0.200
     9.917    28.924     0.200
    10.074    29.749     0.200
    10.613    28.501     0.200
    10.613    30.797     0.200
    10.941    32.648     0.200
    10.941    31.308     0.200
    10.968    31.970     0.200
    10.968    31.536     0.200
    10.968    32.305     0.200
    11.341    33.159     0.200
    11.668    33.929     0.200
    11.642    33.939     0.200
    11.770    31.959     0.200
    11.841    34.165     0.200
    11.774    34.153     0.200
    11.754    34.651     0.200
    12.004    35.376     0.200
    12.539    36.353     0.200
    12.539    35.058     0.200
    12.539    34.463     0.200
    12.497    35.299     0.200
    12.697    34.056     0.200
    12.978    34.198     0.200
    13.002    34.052     0.200
    13.244    34.991     0.200
    13.244    35.741     0.200
    13.473    32.818     0.200
    13.473    30.929     0.200
    13.473    34.988     0.200
    13.483    34.022     0.200
    13.483    34.717     0.200
    13.443    36.031     0.200
    13.443    35.929     0.200
    13.510    33.642     0.200
    13.691    32.490     0.200
    13.764    36.197     0.200
    13.988    33.984     0.200
    14.050    35.242     0.200
    14.085    37.491     0.200
    14.401    33.629     0.200
    14.401    34.367     0.200
    14.401    35.010     0.200
    14.631    35.344     0.200
    14.631    35.666     0.200
    14.639    36.329     0.200
    14.673    37.264     0.200
    14.695    38.302     0.200
    14.695    38.454     0.200
    14.695    36.923     0.200
    14.784    36.829     0.200
    14.881    37.365     0.200
    14.971    36.449     0.200
    15.138    37.907     0.200
    15.074    38.715     0.200
    15.230    37.538     0.200
    15.458    36.530     0.200
    15.444    37.058     0.200
    15.536    38.203     0.200
    15.536    36.630     0.200
    15.442    38.130     0.200
    15.442    38.548     0.200
    15.442    38.281     0.200
    15.597    37.782     0.200
    15.597    37.277     0.200
    16.004    38.081     0.200
    16.004    39.367     0.200
    16.004    40.162     0.200
    16.020    39.757     0.200
    16.020    39.312     0.200
    16.569    38.138     0.200
    16.784    40.273     0.200
    16.742    40.884     0.200
    16.861    37.605     0.200
    16.861    38.137     0.200
    16.957    39.008     0.200
    17.147    40.713     0.200
    17.651    37.987     0.200
    17.567    40.742     0.200
    17.712    38.292     0.200
    17.656    40.819     0.200
    17.929    38.635     0.200
    18.063    38.091     0.200
    18.059    39.661     0.200
    18.535    41.508     0.200
    18.513    42.012     0.200
    18.689    39.218     0.200
    18.770    40.545     0.200
    19.033    41.629     0.200
    19.203    41.572     0.200
    19.443    40.487     0.200
     0.318     4.690     0.200
     1.074     5.596     0.200
     1.152     6.934     0.200
     1.184     6.334     0.200
     1.233     5.921     0.200
     1.199     7.302     0.200
     1.203     7.228     0.200
     1.222     7.138     0.200
     1.259     6.690     0.200
     1.245     7.487     0.200
     1.254     7.313     0.200
     1.363     6.941     0.200
     1.686     6.332     0.200
     1.829     8.106     0.200
     2.110     9.715     0.200
     2.552    10.052     0.200
     2.957    10.231     0.200
     2.991    13.294     0.200
     3.351    10.184     0.200
     3.501    10.943     0.200
     3.787    12.209     0.200
     4.071    12.778     0.200
     4.227    13.690     0.200
     4.330    12.922     0.200
     4.683    14.706     0.200
     5.004    15.770     0.200
     5.451    17.696     0.200
     1.195     5.885     0.200
     1.615     7.922     0.200
     1.745     8.956     0.200
     2.234    10.061     0.200
     2.459     9.431     0.200
     2.731    10.761     0.200
     2.904    12.531     0.200
     3.045    12.606     0.200
     3.586    12.216     0.200
     3.541    12.864     0.200
     3.590    15.162     0.200
     3.554    14.882     0.200
     3.928    13.804     0.200
     4.015    17.660     0.200
     4.803    18.343     0.200
    11.377    35.179     0.200
    19.340    39.367     0.200
    19.514    38.174     0.200
     0.849     6.108     0.200
     1.111     5.782     0.200
     1.333     6.862     0.200
     1.431     7.368     0.200
     1.350     8.287     0.200
     1.505     6.479     0.200
     1.474     8.075     0.200
     1.481     8.183     0.200
     1.481     8.362     0.200
     1.489     8.247     0.200
     1.507     8.294     0.200
     1.527     7.871     0.200
     1.673     6.765     0.200
     1.655     8.016     0.200
     1.693     7.933     0.200
     1.866     8.903     0.200
     2.000     9.293     0.200
     2.405     8.149     0.200
     2.517     8.948     0.200
     2.628    10.481     0.200
     2.636    10.781     0.200
     2.745     8.894     0.200
     3.030    11.447     0.200
     3.571    12.194     0.200
     0.470     7.119     0.200
     0.603     7.752     0.200
     0.617     8.106     0.200
     0.643     8.059     0.200
     0.655     7.932     0.200
     0.694     6.970     0.200
     0.730     6.558     0.200
     0.728     6.775     0.200
     0.712     7.326     0.200
     1.442     6.528     0.200
     1.780     7.627     0.200
     2.014    10.351     0.200
     2.170     8.795     0.200
     2.365     8.806     0.200
     2.389     9.124     0.200
     2.830    11.060     0.200
     2.917    11.185     0.200
     3.082    11.757     0.200
     3.419    11.642     0.200
     3.593    12.821     0.200
     3.591    12.591     0.200
     3.952    14.017     0.200
     4.366    16.046     0.200
     4.504    14.402     0.200
     4.659    15.575     0.200
     4.964    16.328     0.200
     5.287    17.310     0.200
     5.480    17.883     0.200
     5.818    18.566     0.200
     5.924    18.681     0.200
     1.550     6.620     0.200
     2.343    10.879     0.200
     2.813     9.321     0.200
     3.562    14.871     0.200
     3.915    14.969     0.200
     3.999    15.432     0.200
     4.137    13.891     0.200
     4.165    16.119     0.200
     4.800    16.033     0.200
     4.953    16.457     0.200
     0.433     4.160     0.200
     0.475     3.677     0.200
     1.180     5.848     0.200
     1.550     7.965     0.200
     1.885     8.209     0.200
     2.338     8.834     0.200
     2.542     9.411     0.200
     3.032    13.795     0.200
     3.170    11.879     0.200
     3.609    13.124     0.200
     3.508    14.489     0.200
     3.651    13.423     0.200
     3.957    12.342     0.200
     4.154    11.403     0.200
     4.100    15.145     0.200
     4.154    16.979     0.200
     4.218    15.732     0.200
     4.344    13.379     0.200
     4.360    17.239     0.200
     4.437    18.263     0.200
     4.724    14.563     0.200
     4.663    15.650     0.200
     4.755    16.151     0.200
     4.717    18.777     0.200
     4.787    17.927     0.200
     4.848    17.108     0.200
     4.968    17.201     0.200
     5.308    15.122     0.200
     5.629    18.027     0.200
     5.743    17.338     0.200
     5.783    18.522     0.200
     5.722    16.589     0.200
     5.927    17.032     0.200
     6.099    17.211     0.200
     6.291    18.513     0.200
     6.529    18.453     0.200
     7.532    20.382     0.200
     8.504    24.430     0.200
     9.155    24.147     0.200
     1.198     6.685     0.200
     1.337     7.754     0.200
     1.682     6.499     0.200
     1.846     6.664     0.200
     1.952    10.355     0.200
     2.071     8.349     0.200
     2.101     9.679     0.200
     2.443    12.319     0.200
     2.801    12.053     0.200
     2.837    10.773     0.200
     2.896    13.289     0.200
     2.831    11.573     0.200
     2.893    12.913     0.200
     3.289    13.469     0.200
     3.380    12.983     0.200
     3.697    13.931     0.200
     3.856    13.065     0.200
     3.911    14.011     0.200
     4.185    15.107     0.200
     4.507    15.393     0.200
     4.733    16.325     0.200
     5.091    16.472     0.200
     5.126    16.858     0.200
     0.267     4.827     0.200
     1.115     6.942     0.200
     1.120     6.947     0.200
     1.163     7.317     0.200
     1.166     6.535     0.200
     1.171     7.247     0.200
     1.384     8.174     0.200
     1.786     6.548     0.200
     1.730     8.998     0.200
     2.150     9.808     0.200
     2.640    10.377     0.200
     2.844    12.639     0.200
     3.057     9.733     0.200
     3.600    13.672     0.200
     3.865    14.795     0.200
     4.170    12.920     0.200
     4.267    16.687     0.200
     4.302    17.775     0.200
     4.773    15.203     0.200
     5.094    14.949     0.200
     5.188    15.206     0.200
     5.236    16.321     0.200
     5.547    16.378     0.200
     2.033    10.593     0.200
     2.195    10.229     0.200
     2.797    12.091     0.200
     2.805    13.142     0.200
     3.193    14.334     0.200
     3.459    12.458     0.200
     3.597    14.525     0.200
     3.718    13.338     0.200
     4.069    16.303     0.200
     4.116    17.695     0.200
     4.374    18.449     0.200
     4.522    16.384     0.200
     4.611    16.840     0.200
     4.753    18.791     0.200
     4.811    20.473     0.200
     4.965    18.877     0.200
     5.140    18.717     0.200
     5.140    19.767     0.200
     5.168    17.356     0.200
     5.169    17.016     0.200
     5.182    18.133     0.200
     5.234    19.930     0.200
     5.409    19.556     0.200
     6.058    18.024     0.200
     6.197    19.962     0.200
     6.244    24.080     0.200
     6.392    22.327     0.200
     6.547    20.938     0.200
     0.684     4.901     0.200
     0.807     4.575     0.200
     1.114     5.703     0.200
     1.319     6.429     0.200
     1.650     6.563     0.200
     1.726     8.201     0.200
     1.765     8.452     0.200
     1.778     8.228     0.200
     1.816     8.481     0.200
     2.080     8.324     0.200
     1.985     9.489     0.200
     2.385     8.040     0.200
     2.404    11.617     0.200
     2.390    11.096     0.200
     2.937    10.483     0.200
     2.890    12.967     0.200
     3.258    15.763     0.200
     3.373    15.383     0.200
     3.505    11.460     0.200
     3.804    13.633     0.200
     3.806    13.287     0.200
     3.784    14.741     0.200
     3.784    17.151     0.200
     3.819    16.137     0.200
     3.819    16.614     0.200
     3.872    13.286     0.200
     4.184    13.776     0.200
     0.305     4.839     0.200
     1.016     5.355     0.200
     1.090     6.418     0.200
     1.138     7.211     0.200
     1.197     6.525     0.200
     1.184     7.433     0.200
     1.194     7.285     0.200
     1.285     7.672     0.200
     1.353     6.709     0.200
     1.743     6.937     0.200
     1.773     6.837     0.200
     2.139     7.537     0.200
     2.113     9.966     0.200
     2.593     9.939     0.200
     2.798    14.116     0.200
     2.930    10.925     0.200
     3.013     8.799     0.200
     3.389    12.195     0.200
     3.562    11.924     0.200
     3.819    13.418     0.200
     4.126    13.257     0.200
     4.221    13.827     0.200
     4.256    13.773     0.200
     4.233    14.320     0.200
     4.312    13.165     0.200
     4.376    15.130     0.200
     4.726    15.404     0.200
     5.144    15.848     0.200
     5.189    16.615     0.200
     5.501    17.825     0.200
     5.718    19.082     0.200
     6.163    18.581     0.200
     1.910    10.062     0.200
     2.160    10.038     0.200
     2.715    12.177     0.200
     3.282    10.779     0.200
     3.224    15.277     0.200
     3.593    15.214     0.200
     3.603    14.744     0.200
     3.673    12.460     0.200
     3.682    16.140     0.200
     3.723    12.123     0.200
     3.992    16.684     0.200
     4.308    16.291     0.200
     4.402    16.088     0.200
     4.692    15.208     0.200
     1.246     7.993     0.200
     1.560     7.887     0.200
     1.998    10.793     0.200
     2.301    12.405     0.200
     2.353    12.049     0.200
     2.476    13.038     0.200
     2.814    13.898     0.200
     3.088    13.278     0.200
     3.048    13.229     0.200
     3.336    13.634     0.200
     3.908    14.869     0.200
     3.932    18.444     0.200
     3.993    13.430     0.200
     4.107    16.314     0.200
     4.142    15.385     0.200
     4.924    19.142     0.200
     5.422    21.974     0.200
     0.694     4.291     0.200
     0.858     5.740     0.200
     1.331     5.684     0.200
     1.173     6.041     0.200
     1.440     5.715     0.200
     1.531     6.361     0.200
     1.450     7.899     0.200
     1.486     7.838     0.200
     1.500     7.799     0.200
     1.556     7.607     0.200
     1.834     9.553     0.200
     2.159     8.237     0.200
     2.595    11.571     0.200
     2.558    11.553     0.200
     2.885    10.102     0.200
     2.959    12.888     0.200
     3.128    11.900     0.200
     3.315    14.034     0.200
     3.699    11.632     0.200
     3.594    14.643     0.200
     3.810    14.311     0.200
     3.810    15.150     0.200
     3.842    13.727     0.200
     3.848    16.434     0.200
     3.938    10.706     0.200
     3.959    13.163     0.200
     3.900    14.284     0.200
     4.384    13.504     0.200
     0.781     5.927     0.200
     1.268     6.745     0.200
     1.466     5.608     0.200
     2.074     9.823     0.200
     2.527     9.690     0.200
     2.873    11.581     0.200
     3.055    11.844     0.200
     3.318    13.355     0.200
     3.627    11.051     0.200
     3.761    15.252     0.200
     3.856    14.630     0.200
     3.880    14.185     0.200
     3.813    14.964     0.200
     4.205    14.506     0.200
     4.526    15.554     0.200
     4.670    16.842     0.200
     4.986    17.568     0.200
     5.200    17.361     0.200
     0.554     7.117     0.200
     0.919     6.128     0.200
     1.101     8.337     0.200
     1.354     5.595     0.200
     1.371     6.258     0.200
     1.521     7.949     0.200
     1.597     8.429     0.200
     1.606     8.687     0.200
     1.628     8.432     0.200
     1.719     8.645     0.200
     1.784     8.258     0.200
     1.855     7.573     0.200
     2.253    10.975     0.200
     2.481     8.035     0.200
     2.424    10.936     0.200
     2.464    11.056     0.200
     2.492    10.773     0.200
     2.568     9.293     0.200
     2.614    13.838     0.200
     2.860    11.408     0.200
     2.895     9.306     0.200
     2.828    11.915     0.200
     3.102    10.271     0.200
     3.218    13.978     0.200
     3.246    12.967     0.200
     3.246    13.146     0.200
     3.249    14.688     0.200
     3.311    12.676     0.200
     3.497    12.224     0.200
     3.558    13.186     0.200
     3.635    12.615     0.200
     3.843    13.947     0.200
     4.165    14.289     0.200
     4.381    15.526     0.200
     4.335    14.880     0.200
     4.406    15.504     0.200
     4.479    14.267     0.200
     4.735    15.972     0.200
     4.796    16.284     0.200
     4.989    13.571     0.200
     5.483    16.058     0.200
     1.517     6.767     0.200
     1.889     9.672     0.200
     2.035     7.966     0.200
     2.478    10.303     0.200
     2.957    11.670     0.200
     3.305    13.021     0.200
     3.759    15.083     0.200
     3.862    14.268     0.200
     3.746    14.963     0.200
     3.809    17.845     0.200
     4.026    18.641     0.200
     4.198    18.188     0.200
     4.637    18.602     0.200
     4.728    18.983     0.200
     5.084    16.963     0.200
     5.404    16.321     0.200
     5.530    18.558     0.200
     2.029     8.478     0.200
     1.915     7.961     0.200
     2.526    12.237     0.200
     2.526    12.976     0.200
     2.974    11.693     0.200
     2.855    15.078     0.200
     2.929    11.785     0.200
     3.297    12.118     0.200
     3.699    15.009     0.200
     3.686    14.166     0.200
     3.735    15.718     0.200
     3.857    14.145     0.200
     3.740    15.168     0.200
     3.798    16.825     0.200
     3.837    16.585     0.200
     3.812    14.948     0.200
     4.007    16.023     0.200
     4.058    17.046     0.200
     4.200    18.407     0.200
     4.195    18.833     0.200
     4.223    16.594     0.200
     4.217    18.162     0.200
     4.222    16.249     0.200
     4.229    17.134     0.200
     4.317    15.737     0.200
     4.330    18.747     0.200
     4.422    15.063     0.200
     4.388    17.509     0.200
     4.468    17.351     0.200
     4.527    18.334     0.200
     4.664    18.166     0.200
     4.731    16.186     0.200
     4.729    16.517     0.200
     4.547    18.216     0.200
     4.547    15.135     0.200
     4.689    16.025     0.200
     4.863    17.561     0.200
     5.097    16.959     0.200
     5.416    18.203     0.200
     5.444    17.222     0.200
     5.535    18.601     0.200
     5.833    19.734     0.200
     5.810    17.937     0.200
     5.772    17.628     0.200
     5.927    21.375     0.200
     6.082    17.902     0.200
     6.099    18.547     0.200
     6.241    19.912     0.200
     6.463    20.466     0.200
     6.413    19.402     0.200
     6.540    22.144     0.200
     6.960    23.882     0.200
     7.326    20.229     0.200
     7.569    21.769     0.200
     8.276    23.700     0.200
     8.848    26.966     0.200
     8.848    25.016     0.200
     9.991    27.265     0.200
    10.143    25.684     0.200
    11.013    29.524     0.200
    11.005    30.527     0.200
    11.005    32.532     0.200
    11.006    29.813     0.200
    11.396    30.348     0.200
    12.527    34.961     0.200
    12.597    34.015     0.200
    12.766    33.749     0.200
    13.039    34.588     0.200
    13.570    35.210     0.200
    13.741    35.270     0.200
    14.695    35.575     0.200
    14.831    36.489     0.200
    14.931    37.245     0.200
    15.034    36.519     0.200
    15.198    37.369     0.200
    15.282    37.836     0.200
    15.317    36.406     0.200
    15.445    39.845     0.200
    15.493    37.876     0.200
    15.568    37.647     0.200
    15.638    38.660     0.200
    15.850    37.807     0.200
    15.878    38.894     0.200
    15.902    39.802     0.200
    16.014    40.167     0.200
    16.062    38.495     0.200
    16.054    40.224     0.200
    16.917    38.545     0.200
    17.003    39.037     0.200
    17.016    39.621     0.200
    17.573    40.578     0.200
    17.769    40.231     0.200
    18.006    38.179     0.200
    18.100    40.371     0.200
    18.543    41.025     0.200
    19.190    42.063     0.200
     1.392     6.698     0.200
     2.034    11.096     0.200
     2.220    11.884     0.200
     2.575    11.144     0.200
     2.853    12.895     0.200
     2.853    13.176     0.200
     3.362    16.021     0.200
     3.475    14.034     0.200
     3.842    13.238     0.200
     3.759    15.142     0.200
     3.995    13.128     0.200
     4.162    19.030     0.200
     4.203    16.631     0.200
     4.401    16.301     0.200
     4.438    18.526     0.200
     4.442    15.172     0.200
     4.442    16.602     0.200
     4.442    15.750     0.200
     4.491    19.579     0.200
     4.635    14.760     0.200
     4.635    20.026     0.200
     4.640    19.853     0.200
     4.688    17.575     0.200
     4.741    15.934     0.200
     4.745    17.803     0.200
     4.772    19.478     0.200
     4.823    16.759     0.200
     4.967    17.477     0.200
     5.086    21.260     0.200
     5.047    18.541     0.200
     5.095    20.381     0.200
     5.114    20.623     0.200
     5.115    21.148     0.200
     5.115    19.928     0.200
     5.175    17.425     0.200
     5.254    17.825     0.200
     5.254    18.661     0.200
     5.231    15.358     0.200
     5.608    18.843     0.200
     5.929    20.100     0.200
     6.064    20.137     0.200
     6.272    21.544     0.200
     6.368    20.464     0.200
     6.398    19.864     0.200
     6.600    21.395     0.200
     6.624    23.535     0.200
     6.863    22.033     0.200
     7.007    21.364     0.200
     7.069    19.690     0.200
     7.268    20.653     0.200
     7.624    23.369     0.200
     7.836    24.200     0.200
     8.093    25.219     0.200
     8.522    25.583     0.200
     8.522    26.075     0.200
     8.522    26.294     0.200
     8.797    24.087     0.200
     8.797    26.377     0.200
     9.455    26.458     0.200
     9.603    28.472     0.200
    10.678    30.708     0.200
    10.777    28.933     0.200
    10.777    31.324     0.200
    10.777    28.804     0.200
    11.291    30.252     0.200
    11.539    31.423     0.200
    11.539    29.517     0.200
    11.789    33.761     0.200
    11.781    30.815     0.200
    11.882    33.639     0.200
    11.814    31.826     0.200
    12.253    32.157     0.200
    12.509    31.161     0.200
    12.626    31.041     0.200
    12.803    32.639     0.200
    12.821    32.214     0.200
    13.189    34.668     0.200
    13.189    32.800     0.200
    13.499    32.931     0.200
    13.598    35.006     0.200
    13.843    35.313     0.200
    14.370    37.424     0.200
    14.592    36.427     0.200
    14.623    36.449     0.200
    14.588    34.239     0.200
    14.665    35.465     0.200
    14.713    35.939     0.200
    14.783    33.890     0.200
    14.996    34.366     0.200
    15.037    35.600     0.200
    15.037    37.913     0.200
    15.814    38.358     0.200
    15.947    37.452     0.200
    16.513    37.901     0.200
    16.513    38.956     0.200
    16.654    37.110     0.200
    16.814    37.989     0.200
    17.702    39.253     0.200
    18.719    40.381     0.200
    18.719    42.545     0.200
     1.877     8.052     0.200
     1.927     8.771     0.200
     1.922     9.118     0.200
     1.874     7.441     0.200
     1.957     9.125     0.200
     1.971     9.057     0.200
     1.945     8.047     0.200
     2.023     8.730     0.200
     2.158     8.983     0.200
     2.552    11.456     0.200
     2.688    10.764     0.200
     2.794    11.808     0.200
     2.709    11.034     0.200
     2.828    13.294     0.200
     3.049    11.809     0.200
     2.997    10.745     0.200
     3.186    11.960     0.200
     3.241    11.765     0.200
     3.264    14.722     0.200
     3.265    12.899     0.200
     3.368    14.994     0.200
     3.276    11.713     0.200
     3.409    15.570     0.200
     3.550    14.011     0.200
     3.600    13.193     0.200
     3.609    12.903     0.200
     3.567    12.598     0.200
     3.621    12.763     0.200
     3.773    15.327     0.200
     3.968    14.101     0.200
     4.284    15.040     0.200
     4.297    14.346     0.200
     4.385    15.720     0.200
     4.712    14.482     0.200
     4.679    16.567     0.200
     4.879    16.227     0.200
     4.950    15.013     0.200
     4.981    16.558     0.200
     5.073    17.002     0.200
     5.316    17.258     0.200
     5.390    17.849     0.200
     5.832    16.982     0.200
     6.329    17.393     0.200
     7.132    20.703     0.200
     1.266    10.349     0.200
     1.274    10.036     0.200
     1.762    10.187     0.200
     3.033    15.568     0.200
     3.529    18.025     0.200
     3.697    18.104     0.200
     4.796    18.889     0.200
     5.116    20.287     0.200
     1.681     9.722     0.200
     2.306    11.642     0.200
     2.268    11.877     0.200
     2.554    11.382     0.200
     2.928    14.319     0.200
     3.062    14.501     0.200
     3.190    14.196     0.200
     3.519    11.308     0.200
     3.692    17.055     0.200
     3.794    14.545     0.200
     4.032    12.520     0.200
     4.043    15.287     0.200
     4.240    17.761     0.200
     4.465    18.047     0.200
     4.605    14.200     0.200
     4.758    18.901     0.200
     5.384    19.378     0.200
     5.579    19.079     0.200
     5.918    22.616     0.200
     6.019    19.692     0.200
     1.204     7.604     0.200
     1.694     9.666     0.200
     1.792     8.550     0.200
     1.813    11.017     0.200
     2.009     8.841     0.200
     2.371    11.102     0.200
     2.450    10.499     0.200
     2.550    10.724     0.200
     2.621    11.827     0.200
     2.648    13.516     0.200
     2.754    13.552     0.200
     2.809     9.125     0.200
     2.866    14.176     0.200
     3.004    13.458     0.200
     3.038    14.417     0.200
     3.120    11.816     0.200
     3.063    12.853     0.200
     3.065    13.329     0.200
     3.072    12.942     0.200
     3.142    12.401     0.200
     3.092    15.829     0.200
     3.089    14.181     0.200
     3.192    10.092     0.200
     3.235    12.126     0.200
     3.236    11.919     0.200
     3.337    13.997     0.200
     3.387    14.211     0.200
     3.407    12.972     0.200
     3.406    10.943     0.200
     3.381    12.636     0.200
     3.461    15.094     0.200
     3.601    13.088     0.200
     3.786    13.142     0.200
     3.928    15.172     0.200
     4.103    15.427     0.200
     4.210    15.161     0.200
     4.326    17.377     0.200
     4.509    16.686     0.200
     4.529    17.707     0.200
     4.736    15.252     0.200
     4.799    16.863     0.200
     4.776    16.696     0.200
     4.923    18.255     0.200
     5.158    17.611     0.200
     5.216    17.979     0.200
     5.202    20.725     0.200
     5.646    15.800     0.200
     6.014    18.222     0.200
     6.168    19.700     0.200
     6.955    21.895     0.200
     7.265    21.839     0.200
     7.624    22.615     0.200
     7.618    26.995     0.200
     7.732    27.086     0.200
     9.900    28.122     0.200
     9.929    28.243     0.200
    10.023    28.309     0.200
    11.344    31.489     0.200
    11.565    32.119     0.200
     0.883     4.476     0.200
     1.175     4.813     0.200
     1.108     6.727     0.200
     1.618     7.219     0.200
     1.595     7.763     0.200
     1.582     7.689     0.200
     1.585     7.841     0.200
     1.615     8.213     0.200
     1.632     7.924     0.200
     1.707     8.257     0.200
     1.707     9.381     0.200
     1.969     7.479     0.200
     2.429    10.909     0.200
     2.696    13.507     0.200
     2.732    11.086     0.200
     2.954     9.642     0.200
     2.836    12.901     0.200
     3.070    12.993     0.200
     3.218    13.096     0.200
     3.751    13.376     0.200
     4.100    16.411     0.200
     4.564    15.658     0.200
     0.600     4.247     0.200
     0.880     6.330     0.200
     0.881     5.995     0.200
     0.917     6.712     0.200
     0.931     6.632     0.200
     0.997     6.362     0.200
     1.885     8.162     0.200
     1.882    11.344     0.200
     3.136    12.212     0.200
     3.186    13.268     0.200
     3.332    13.261     0.200
     3.330    14.269     0.200
     3.349    12.600     0.200
     3.208    10.395     0.200
     3.518    16.762     0.200
     4.124    13.973     0.200
     4.157    12.884     0.200
     4.225    11.660     0.200
     4.397    16.241     0.200
     4.443    13.931     0.200
     4.714    16.688     0.200
     1.113     6.649     0.200
     1.653     7.676     0.200
     2.232     9.030     0.200
     2.467    11.339     0.200
     2.712    12.303     0.200
     2.920    11.910     0.200
     2.954    11.196     0.200
     3.202    13.133     0.200
     3.260    14.135     0.200
     3.244    11.116     0.200
     3.456    15.369     0.200
     3.507    15.545     0.200
     3.498    14.066     0.200
     3.578    16.134     0.200
     3.642    16.506     0.200
     3.651    17.052     0.200
     3.653    15.424     0.200
     3.670    15.384     0.200
     3.685    15.604     0.200
     3.694    14.264     0.200
     4.026    13.920     0.200
     4.112    17.505     0.200
     4.115    17.718     0.200
     4.097    16.466     0.200
     4.258    15.860     0.200
     4.283    15.907     0.200
     4.269    14.761     0.200
     4.602    16.629     0.200
     4.923    17.540     0.200
     5.042    16.612     0.200
     5.073    17.983     0.200
     5.291    17.360     0.200
     5.389    18.690     0.200
     5.591    19.352     0.200
     6.061    19.423     0.200
     6.075    19.745     0.200
     6.828    22.058     0.200
     7.796    23.207     0.200
     8.449    23.911     0.200
     1.550     8.497     0.200
     1.495     9.563     0.200
     2.009    10.975     0.200
     2.213    12.125     0.200
     2.599    13.848     0.200
     2.913    15.130     0.200
     2.882    14.021     0.200
     3.048    14.198     0.200
     3.151    12.200     0.200
     3.092    15.375     0.200
     4.039    15.313     0.200
     4.070    16.594     0.200
     4.150    17.465     0.200
     4.590    19.627     0.200
     4.858    21.145     0.200
     2.204    10.568     0.200
     2.587    12.415     0.200
     2.753    12.243     0.200
     3.209    13.435     0.200
     3.621    14.293     0.200
     4.002    13.671     0.200
     4.341    16.389     0.200
     4.319    14.461     0.200
     4.424    15.312     0.200
     4.720    17.310     0.200
     1.345     8.284     0.200
     2.163     9.952     0.200
     2.482    12.373     0.200
     2.525    10.865     0.200
     2.578    11.918     0.200
     2.742    12.970     0.200
     2.802    13.564     0.200
     2.861    14.010     0.200
     2.920    13.475     0.200
     3.024    11.799     0.200
     3.050    12.246     0.200
     3.157    14.554     0.200
     3.515    13.353     0.200
     3.643    11.413     0.200
     4.057    17.002     0.200
     4.169    15.466     0.200
     4.831    14.499     0.200
     4.875    19.267     0.200
     5.051    17.162     0.200
     5.186    21.027     0.200
     5.842    17.678     0.200
     7.473    23.409     0.200
     9.890    31.583     0.200
     0.282     3.944     0.200
     0.918     5.308     0.200
     0.996     6.223     0.200
     1.102     6.231     0.200
     1.099     7.086     0.200
     1.107     6.969     0.200
     1.382     7.050     0.200
     1.370     7.462     0.200
     1.841     7.480     0.200
     2.044     8.050     0.200
     2.040     7.849     0.200
     2.109     6.905     0.200
     2.148    10.675     0.200
     3.111     9.244     0.200
     3.410    10.795     0.200
     3.382    10.820     0.200
     3.362    13.853     0.200
     3.470    13.549     0.200
     3.499    15.870     0.200
     3.521    12.925     0.200
     3.657    12.980     0.200
     3.708    15.135     0.200
     3.892    13.571     0.200
     4.222    13.376     0.200
     4.292    15.800     0.200
     4.292    16.022     0.200
     4.279    14.653     0.200
     4.277    13.280     0.200
     4.327    15.599     0.200
     4.466    14.550     0.200
     4.439    13.663     0.200
     4.489    15.251     0.200
     4.812    13.309     0.200
     5.133    16.631     0.200
     5.240    16.201     0.200
     5.280    17.623     0.200
    10.789    30.750     0.200
     0.051    11.147     0.200
     0.209    10.402     0.200
     0.232    10.173     0.200
     0.521     7.434     0.200
     1.145     7.207     0.200
     1.231     7.060     0.200
     1.734     8.554     0.200
     2.465    11.078     0.200
     2.890    10.076     0.200
     2.862    12.570     0.200
     3.494    12.340     0.200
     4.137    13.246     0.200
     4.228    12.898     0.200
     4.266    14.022     0.200
     4.540    14.472     0.200
     4.643    14.114     0.200
     4.908    16.497     0.200
     4.908    19.197     0.200
     4.944    16.132     0.200
     4.955    17.086     0.200
     5.215    15.806     0.200
     5.332    17.249     0.200
     5.401    17.197     0.200
     5.612    17.512     0.200
     5.935    18.369     0.200
     6.155    19.131     0.200
     6.217    18.271     0.200
     6.504    19.966     0.200
     6.548    19.686     0.200
     7.229    20.767     0.200
     0.242     5.025     0.200
     0.866     5.429     0.200
     0.966     6.095     0.200
     1.070     6.408     0.200
     1.081     7.167     0.200
     1.088     6.983     0.200
     1.438     6.185     0.200
     1.421     7.130     0.200
     1.894     6.866     0.200
     1.988     7.358     0.200
     2.204     9.449     0.200
     2.819    10.181     0.200
     2.865    11.430     0.200
     3.165    10.951     0.200
     3.533    14.437     0.200
     3.708    12.703     0.200
     3.955    13.385     0.200
     4.278    13.511     0.200
     4.291    15.093     0.200
     4.339    15.603     0.200
     4.390    15.145     0.200
     4.527    15.706     0.200
     4.537    16.782     0.200
     4.874    14.860     0.200
     5.195    16.272     0.200
     5.296    15.719     0.200
     5.340    16.901     0.200
     5.563    17.821     0.200
     5.653    18.313     0.200
     5.864    18.825     0.200
     5.917    17.972     0.200
     1.047     7.641     0.200
     1.142     7.789     0.200
     1.198     9.010     0.200
     1.625    10.121     0.200
     1.962    10.377     0.200
     2.401    12.924     0.200
     2.865    11.823     0.200
     2.909    12.595     0.200
     3.019    15.273     0.200
     3.583    13.240     0.200
     3.666    15.463     0.200
     3.775    14.094     0.200
     4.106    16.418     0.200
     4.342    14.809     0.200
     4.466    15.903     0.200
     4.527    18.175     0.200
     4.546    16.436     0.200
     4.992    17.359     0.200
     5.312    18.107     0.200
     5.439    17.591     0.200
     5.699    17.674     0.200
     5.991    19.893     0.200
     6.382    19.197     0.200
     7.221    20.162     0.200
     8.176    23.749     0.200
    10.944    32.373     0.200
     1.664     8.170     0.200
     1.957    10.118     0.200
     1.965     9.803     0.200
     2.893    11.695     0.200
     3.235    11.206     0.200
     3.608    14.657     0.200
     3.695    14.865     0.200
     3.792    13.834     0.200
     4.138    17.126     0.200
     4.498    18.355     0.200
     4.564    18.495     0.200
     4.660    16.397     0.200
     4.654    18.510     0.200
     5.338    16.404     0.200
     1.393     7.373     0.200
     1.411     6.786     0.200
     1.515     8.754     0.200
     1.617     7.888     0.200
     1.549     9.362     0.200
     1.621     9.142     0.200
     2.136     9.855     0.200
     2.215    12.034     0.200
     2.215    12.194     0.200
     2.472    11.993     0.200
     2.508     9.773     0.200
     2.573    13.316     0.200
     2.679    10.368     0.200
     2.834    15.975     0.200
     2.929    11.800     0.200
     2.980    13.142     0.200
     3.095    13.808     0.200
     3.047    14.173     0.200
     3.240    12.660     0.200
     3.217    11.830     0.200
     3.260    12.642     0.200
     3.324    13.447     0.200
     3.328    15.408     0.200
     3.430    13.851     0.200
     3.524    14.323     0.200
     3.570    15.242     0.200
     3.695    15.012     0.200
     3.703    15.323     0.200
     3.716    14.406     0.200
     3.716    17.945     0.200
     3.719    15.610     0.200
     3.719    13.809     0.200
     3.718    15.200     0.200
     3.719    16.196     0.200
     3.729    18.470     0.200
     3.804    13.243     0.200
     3.749    15.641     0.200
     3.768    14.020     0.200
     3.805    17.291     0.200
     3.830    15.317     0.200
     3.840    16.788     0.200
     3.870    14.498     0.200
     3.896    17.837     0.200
     3.947    15.921     0.200
     4.121    14.354     0.200
     4.111    14.015     0.200
     4.128    15.099     0.200
     4.128    14.429     0.200
     4.145    16.502     0.200
     4.146    16.488     0.200
     4.232    15.587     0.200
     4.253    16.580     0.200
     4.253    16.587     0.200
     4.673    16.203     0.200
     4.693    17.066     0.200
     4.693    17.765     0.200
     4.693    18.015     0.200
     4.827    17.124     0.200
     4.930    16.959     0.200
     5.220    17.029     0.200
     5.246    17.110     0.200
     5.415    19.135     0.200
     5.439    20.978     0.200
     5.521    18.266     0.200
     5.845    18.316     0.200
     5.935    19.996     0.200
     5.935    19.999     0.200
     6.091    18.980     0.200
     6.067    20.211     0.200
     6.327    20.629     0.200
     6.738    20.035     0.200
     7.504    23.720     0.200
     7.677    22.977     0.200
     7.677    21.989     0.200
     7.677    24.047     0.200
     8.571    27.910     0.200
     8.571    24.619     0.200
     9.202    27.633     0.200
     9.202    25.383     0.200
     9.202    28.181     0.200
     9.763    25.838     0.200
     9.853    28.043     0.200
    10.607    30.902     0.200
    10.638    30.548     0.200
    10.730    30.970     0.200
    10.702    29.118     0.200
    11.227    31.177     0.200
    11.227    27.626     0.200
    11.289    30.304     0.200
    11.289    28.505     0.200
    11.245    32.064     0.200
    11.245    30.935     0.200
    11.246    29.780     0.200
    11.860    30.283     0.200
    11.877    31.190     0.200
    12.277    34.677     0.200
    12.279    34.295     0.200
    12.674    33.969     0.200
    12.815    32.071     0.200
    12.809    34.196     0.200
    12.902    32.535     0.200
    13.102    34.663     0.200
    13.180    32.887     0.200
    13.473    36.368     0.200
    13.462    32.280     0.200
    13.462    36.972     0.200
    13.629    32.727     0.200
    13.626    33.778     0.200
    13.768    35.709     0.200
    13.855    35.090     0.200
    13.957    33.983     0.200
    15.883    38.798     0.200
    15.883    38.937     0.200
    17.005    39.653     0.200
    18.999    43.424     0.200
    18.999    41.071     0.200
    19.701    40.055     0.200
     1.656    10.832     0.200
     1.451     9.994     0.200
     1.502    10.306     0.200
     1.963    11.764     0.200
     2.558    14.872     0.200
     2.785    15.154     0.200
     3.366    14.595     0.200
     3.481    17.697     0.200
     4.021    20.030     0.200
     4.040    15.154     0.200
     4.127    18.787     0.200
     1.107     8.015     0.200
     1.512     7.919     0.200
     2.041     7.602     0.200
     2.485    11.833     0.200
     2.964    11.473     0.200
     3.310    13.908     0.200
     3.682    15.100     0.200
     3.709    14.160     0.200
     3.765    16.053     0.200
     3.750    15.135     0.200
     3.816    14.344     0.200
     3.868    15.410     0.200
     4.148    15.278     0.200
     4.205    16.726     0.200
     4.219    14.959     0.200
     4.307    14.933     0.200
     4.434    16.815     0.200
     1.412     7.640     0.200
     1.823     7.894     0.200
     3.089    11.460     0.200
     3.651    11.249     0.200
     3.857    15.547     0.200
     3.862    15.945     0.200
     4.057    14.836     0.200
     4.215    13.066     0.200
     4.493    19.877     0.200
     4.533    15.214     0.200
     4.613    18.746     0.200
     4.816    14.166     0.200
     4.907    15.020     0.200
     5.237    16.923     0.200
     5.226    17.204     0.200
     5.630    18.531     0.200
     5.913    22.100     0.200
     6.201    20.019     0.200
     0.799     5.888     0.200
     1.010     5.264     0.200
     1.289     6.311     0.200
     1.513     8.262     0.200
     1.475     8.525     0.200
     1.641     7.700     0.200
     1.913     8.997     0.200
     2.367     9.675     0.200
     2.503     9.241     0.200
     2.665    10.633     0.200
     2.714    10.847     0.200
     2.695    10.784     0.200
     3.000    10.680     0.200
     2.967    11.631     0.200
     3.057    10.874     0.200
     3.107    11.512     0.200
     3.573    12.034     0.200
     3.535    14.164     0.200
     3.536    16.015     0.200
     3.537    13.387     0.200
     3.541    16.330     0.200
     3.729    14.482     0.200
     3.776    13.709     0.200
     4.051    14.276     0.200
     4.374    14.847     0.200
     4.576    14.485     0.200
     4.549    15.698     0.200
     4.882    16.522     0.200
     5.030    16.071     0.200
     0.580     5.154     0.200
     1.346     6.216     0.200
     1.584     5.937     0.200
     1.694     8.801     0.200
     1.702     7.774     0.200
     2.229     9.125     0.200
     2.366    10.141     0.200
     2.610     7.901     0.200
     3.008    12.384     0.200
     3.061    12.842     0.200
     3.177    12.852     0.200
     3.174    12.242     0.200
     3.241    13.880     0.200
     3.296    14.743     0.200
     3.503    13.607     0.200
     3.605    16.418     0.200
     3.679    16.054     0.200
     3.698    14.956     0.200
     3.726    14.256     0.200
     3.737    12.343     0.200
     3.804    15.090     0.200
     3.819    14.311     0.200
     3.974    13.862     0.200
     4.075    16.653     0.200
     4.074    12.577     0.200
     4.098    14.988     0.200
     4.103    17.513     0.200
     4.109    15.013     0.200
     4.117    15.028     0.200
     4.216    16.742     0.200
     4.461    14.153     0.200
     4.755    15.622     0.200
     4.759    14.450     0.200
     4.777    14.056     0.200
     4.872    16.038     0.200
     5.159    15.972     0.200
     5.203    14.487     0.200
     5.397    18.301     0.200
     5.475    18.080     0.200
     5.778    16.425     0.200
     5.862    16.378     0.200
     6.094    17.707     0.200
    11.313    32.584     0.200
     1.719     8.094     0.200
     1.640     8.390     0.200
     1.933     8.244     0.200
     2.012     9.055     0.200
     2.484    11.320     0.200
     2.452    10.933     0.200
     2.556    13.139     0.200
     2.890    12.275     0.200
     3.005    13.328     0.200
     3.174    12.850     0.200
     3.838    12.974     0.200
     3.761    13.229     0.200
     4.136    14.337     0.200
     4.326    13.362     0.200
     4.581    17.314     0.200
     4.599    14.514     0.200
     4.639    14.446     0.200
     5.010    16.299     0.200
     5.328    16.930     0.200
     5.444    18.535     0.200
     5.728    19.823     0.200
     6.014    19.445     0.200
     6.449    22.184     0.200
     8.186    21.899     0.200
     8.186    22.059     0.200
    11.056    32.484     0.200
     0.250     4.765     0.200
     1.118     6.557     0.200
     1.121     7.340     0.200
     1.383     6.753     0.200
     1.400     7.154     0.200
     1.676     7.080     0.200
     1.839     7.308     0.200
     2.043     7.801     0.200
     2.176    10.276     0.200
     2.176     9.909     0.200
     2.479    11.551     0.200
     2.688    10.456     0.200
     2.895    11.214     0.200
     2.854    11.368     0.200
     3.110    10.232     0.200
     3.419    13.112     0.200
     3.403    13.335     0.200
     3.398    13.166     0.200
     3.483    11.875     0.200
     3.517    15.584     0.200
     3.553    12.596     0.200
     3.653    11.077     0.200
     3.677    14.866     0.200
     3.839    14.904     0.200
     3.862    16.913     0.200
     3.873    15.349     0.200
     3.874    13.361     0.200
     3.874    15.342     0.200
     3.874    17.639     0.200
     3.882    12.216     0.200
     3.984    13.569     0.200
     4.004    18.105     0.200
     4.059    15.200     0.200
     4.223    13.573     0.200
     4.305    14.199     0.200
     4.308    13.951     0.200
     4.308    14.779     0.200
     4.345    15.903     0.200
     4.351    14.863     0.200
     4.436    16.050     0.200
     4.474    15.473     0.200
     4.474    14.933     0.200
     4.822    15.703     0.200
     5.143    16.414     0.200
     5.241    15.859     0.200
     5.287    17.196     0.200
     5.514    15.039     0.200
     5.599    17.525     0.200
     5.589    14.850     0.200
     5.813    18.662     0.200
     5.905    17.712     0.200
     6.261    18.614     0.200
     6.290    19.300     0.200
     6.851    21.801     0.200
     7.049    20.195     0.200
     7.269    19.005     0.200
     7.259    20.394     0.200
     8.014    22.369     0.200
     8.014    21.233     0.200
     8.694    25.468     0.200
     8.728    22.855     0.200
     8.728    27.386     0.200
    10.757    30.407     0.200
    10.818    29.574     0.200
    10.818    27.898     0.200
    10.818    28.053     0.200
    11.467    28.613     0.200
    12.678    32.888     0.200
    12.814    31.281     0.200
    12.854    31.178     0.200
    13.233    31.547     0.200
    13.316    32.416     0.200
    13.316    34.869     0.200
    13.301    31.561     0.200
    14.165    30.563     0.200
    15.297    34.714     0.200
    16.396    36.186     0.200
    16.450    35.685     0.200
    18.369    36.761     0.200
    18.465    37.614     0.200
    19.198    38.580     0.200
    19.198    38.998     0.200
    19.241    38.249     0.200
     0.977     5.992     0.200
     1.440     5.895     0.200
     1.530     6.702     0.200
     1.988     7.461     0.200
     2.051     9.890     0.200
     2.237     9.661     0.200
     2.237     9.513     0.200
     2.296    11.006     0.200
     2.818    10.784     0.200
     2.863    11.778     0.200
     3.259    11.171     0.200
     3.480    13.829     0.200
     3.503    14.107     0.200
     3.496    10.639     0.200
     3.555    13.590     0.200
     3.608    13.624     0.200
     3.627    13.814     0.200
     3.778    14.543     0.200
     3.800    12.323     0.200
     3.831    14.399     0.200
     3.933    14.208     0.200
     3.975    12.034     0.200
     3.978    13.422     0.200
     4.083    14.732     0.200
     4.090    15.632     0.200
     4.162    15.769     0.200
     4.184    15.311     0.200
     4.240    13.973     0.200
     4.240    14.923     0.200
     4.371    13.549     0.200
     4.380    13.698     0.200
     4.379    13.704     0.200
     4.421    13.959     0.200
     4.443    15.395     0.200
     4.449    16.901     0.200
     4.450    14.111     0.200
     4.451    13.887     0.200
     4.451    15.897     0.200
     4.454    16.109     0.200
     4.455    16.094     0.200
     4.612    15.645     0.200
     4.612    16.165     0.200
     4.638    16.006     0.200
     4.954    16.198     0.200
     5.276    17.028     0.200
     5.388    16.302     0.200
     5.426    17.660     0.200
     5.623    18.439     0.200
     5.637    18.147     0.200
     5.742    18.348     0.200
     5.916    19.113     0.200
     6.200    17.441     0.200
     6.429    20.017     0.200
     6.429    20.019     0.200
     6.732    24.438     0.200
     7.241    22.245     0.200
     7.415    20.388     0.200
     8.149    25.251     0.200
    10.230    24.928     0.200
    10.354    25.201     0.200
    10.727    30.013     0.200
    10.727    26.872     0.200
    10.727    26.536     0.200
    10.894    26.969     0.200
    11.391    28.561     0.200
    12.281    34.142     0.200
    12.265    34.339     0.200
    12.302    34.045     0.200
    12.731    35.167     0.200
    12.762    34.862     0.200
    13.094    32.864     0.200
    13.094    33.469     0.200
    13.213    35.085     0.200
    13.251    34.820     0.200
    13.438    35.417     0.200
    13.613    34.164     0.200
    13.725    35.638     0.200
    14.273    34.289     0.200
    14.532    36.362     0.200
    14.879    36.574     0.200
    14.974    36.297     0.200
    15.191    37.160     0.200
    15.247    35.522     0.200
    15.280    35.126     0.200
    15.351    36.042     0.200
    15.630    35.399     0.200
    15.657    35.615     0.200
    15.746    35.240     0.200
    15.948    36.559     0.200
    16.319    36.404     0.200
    16.555    36.012     0.200
    16.554    36.353     0.200
    16.555    36.581     0.200
    16.555    36.241     0.200
    16.557    36.236     0.200
    17.707    38.337     0.200
    18.120    37.204     0.200
    18.135    37.444     0.200
    18.151    36.972     0.200
    18.511    37.900     0.200
    18.535    37.975     0.200
     0.488     4.659     0.200
     0.970     6.918     0.200
     1.201     8.125     0.200
     1.714     9.831     0.200
     1.714     9.448     0.200
     1.811     8.825     0.200
     2.006     9.319     0.200
     2.226     9.520     0.200
     2.522    11.068     0.200
     2.618    10.882     0.200
     2.656    11.881     0.200
     2.570    12.142     0.200
     2.661    11.842     0.200
     2.715    11.617     0.200
     2.755    11.160     0.200
     2.746    11.409     0.200
     2.918    12.228     0.200
     2.964    13.383     0.200
     3.095    12.901     0.200
     3.112    12.993     0.200
     3.112    12.860     0.200
     3.113    12.192     0.200
     3.119    12.724     0.200
     3.221    13.101     0.200
     3.235    12.964     0.200
     3.268    12.792     0.200
     3.289    13.140     0.200
     3.327    12.195     0.200
     3.307    15.075     0.200
     3.399    14.294     0.200
     3.513    13.407     0.200
     3.521    13.786     0.200
     3.526    13.995     0.200
     3.539    13.675     0.200
     3.531    13.955     0.200
     3.536    14.019     0.200
     3.538    14.004     0.200
     3.571    13.845     0.200
     3.571    14.024     0.200
     3.533    14.841     0.200
     3.631    13.546     0.200
     3.673    13.194     0.200
     3.673    13.201     0.200
     3.700    13.817     0.200
     3.725    14.761     0.200
     3.932    14.578     0.200
     3.957    11.466     0.200
     4.342    14.758     0.200
     4.382    15.873     0.200
     4.529    16.663     0.200
     4.529    16.300     0.200
     4.650    16.220     0.200
     4.934    16.651     0.200
     5.361    17.570     0.200
     5.386    18.515     0.200
     5.386    18.517     0.200
     5.615    17.878     0.200
     6.366    19.797     0.200
     7.115    20.554     0.200
     7.115    21.159     0.200
     7.127    20.917     0.200
     7.383    27.194     0.200
     7.570    22.971     0.200
     8.830    24.108     0.200
     9.000    25.771     0.200
     9.222    27.618     0.200
     9.397    25.515     0.200
     9.856    26.114     0.200
    10.086    29.082     0.200
    10.113    29.638     0.200
    11.040    29.441     0.200
    11.133    28.372     0.200
    11.133    31.145     0.200
    11.133    30.909     0.200
    11.246    29.892     0.200
    11.574    29.861     0.200
    11.670    29.968     0.200
    11.677    31.273     0.200
    12.401    30.393     0.200
    12.438    30.328     0.200
    12.681    31.451     0.200
    12.749    33.169     0.200
    13.351    28.831     0.200
    13.351    31.929     0.200
    13.351    31.230     0.200
    13.333    33.151     0.200
    13.384    35.094     0.200
    13.370    33.347     0.200
    13.538    34.203     0.200
    13.667    35.495     0.200
    13.699    35.434     0.200
    13.709    34.479     0.200
    13.745    35.646     0.200
    13.880    35.300     0.200
    13.973    37.232     0.200
    14.044    37.545     0.200
    14.055    37.351     0.200
    14.126    35.768     0.200
    14.950    37.688     0.200
    15.843    38.180     0.200
    16.906    37.299     0.200
    17.068    37.726     0.200
    17.390    35.803     0.200
    17.409    36.603     0.200
    17.524    36.658     0.200
    17.842    36.711     0.200
    17.870    37.547     0.200
    18.366    40.773     0.200
    18.648    39.324     0.200
    19.029    39.168     0.200
    19.376    39.696     0.200
    19.604    39.108     0.200
    19.643    39.334     0.200
    19.732    39.009     0.200
    19.915    39.150     0.200
    19.915    40.373     0.200
    19.981    39.262     0.200
    20.181    38.986     0.200
     0.870     7.535     0.200
     1.145     7.692     0.200
     1.136     8.318     0.200
     1.154     8.172     0.200
     1.256     7.574     0.200
     1.651     6.872     0.200
     1.635     7.644     0.200
     1.635     9.603     0.200
     1.989     7.740     0.200
     1.989     7.932     0.200
     1.907     8.647     0.200
     2.332     9.399     0.200
     2.283     9.578     0.200
     2.350    10.641     0.200
     2.589    11.447     0.200
     2.657     9.567     0.200
     2.672    10.081     0.200
     2.842    10.801     0.200
     2.882     9.653     0.200
     2.869    12.123     0.200
     2.899    11.862     0.200
     3.042    11.455     0.200
     3.037    12.794     0.200
     3.053    11.785     0.200
     3.176    12.655     0.200
     3.189    12.315     0.200
     3.229    12.963     0.200
     3.324    13.412     0.200
     3.385    11.694     0.200
     3.356    13.066     0.200
     3.372    10.249     0.200
     3.372    12.370     0.200
     3.372    14.370     0.200
     3.372    13.514     0.200
     3.379    13.074     0.200
     3.419    13.305     0.200
     3.438    12.981     0.200
     3.478    13.435     0.200
     3.482    13.239     0.200
     3.512    13.153     0.200
     3.561    12.778     0.200
     3.573    13.037     0.200
     3.770    13.971     0.200
     3.770    13.966     0.200
     3.831    14.627     0.200
     3.834    14.088     0.200
     3.860    14.630     0.200
     3.861    14.583     0.200
     3.863    13.642     0.200
     3.862    14.650     0.200
     3.861    13.834     0.200
     3.863    13.819     0.200
     3.957    12.525     0.200
     3.973    13.968     0.200
     3.973    13.497     0.200
     4.049    13.918     0.200
     4.052    13.980     0.200
     4.108    12.770     0.200
     4.108    14.260     0.200
     4.742    15.895     0.200
     4.928    16.064     0.200
     4.881    16.647     0.200
     4.961    15.188     0.200
     5.013    16.492     0.200
     5.071    16.832     0.200
     5.265    17.046     0.200
     5.388    17.372     0.200
     5.392    17.025     0.200
     5.603    16.280     0.200
     5.924    18.928     0.200
     5.924    18.930     0.200
     5.975    17.917     0.200
     6.636    19.192     0.200
     6.717    21.588     0.200
     6.789    20.416     0.200
     6.968    20.236     0.200
     7.183    18.955     0.200
     7.155    21.682     0.200
     7.293    21.603     0.200
     7.623    21.110     0.200
     7.623    21.456     0.200
     8.568    25.628     0.200
     8.849    26.002     0.200
     9.043    22.048     0.200
     9.126    25.268     0.200
     9.335    24.987     0.200
     9.556    26.377     0.200
     9.570    27.448     0.200
     9.972    25.029     0.200
    10.374    24.116     0.200
    10.546    27.502     0.200
    10.546    25.789     0.200
    10.547    25.226     0.200
    10.651    28.875     0.200
    10.675    29.174     0.200
    10.656    24.346     0.200
    10.773    28.368     0.200
    10.766    25.156     0.200
    11.140    26.092     0.200
    11.147    26.293     0.200
    11.243    26.186     0.200
    11.243    29.235     0.200
    11.358    30.800     0.200
    11.310    26.023     0.200
    11.943    28.640     0.200
    12.103    29.371     0.200
    12.095    28.360     0.200
    12.136    28.514     0.200
    12.221    28.149     0.200
    12.221    31.711     0.200
    12.175    27.813     0.200
    12.356    30.182     0.200
    12.755    29.467     0.200
    12.755    30.397     0.200
    13.092    33.038     0.200
    13.674    29.493     0.200
    16.447    34.769     0.200
    16.447    35.853     0.200
    17.336    35.048     0.200
    19.057    36.983     0.200
    19.224    36.425     0.200
    20.366    35.079     0.200
     1.559     9.638     0.200
     1.593     8.992     0.200
     1.546     9.839     0.200
     2.049    11.000     0.200
     2.226    12.231     0.200
     2.459    10.414     0.200
     2.581    12.643     0.200
     2.885    14.808     0.200
     2.999    15.677     0.200
     3.139    14.856     0.200
     3.193    14.434     0.200
     3.121    14.863     0.200
     3.263    15.741     0.200
     3.515    16.985     0.200
     3.536    17.456     0.200
     4.048    17.273     0.200
     4.092    16.400     0.200
     2.691    12.450     0.200
     2.751    11.371     0.200
     2.819    10.175     0.200
     2.947    13.454     0.200
     3.058    11.778     0.200
     3.090    14.402     0.200
     3.104    13.903     0.200
     3.410    15.106     0.200
     3.429    14.315     0.200
     3.431    14.733     0.200
     3.442    14.470     0.200
     3.447    15.019     0.200
     3.463    15.008     0.200
     3.505    15.653     0.200
     4.057    14.732     0.200
     4.523    15.344     0.200
     4.806    18.375     0.200
     5.189    17.846     0.200
     1.224     6.742     0.200
     1.479     8.346     0.200
     2.095    10.551     0.200
     2.095    11.317     0.200
     2.216    10.038     0.200
     2.307     9.508     0.200
     2.494    10.033     0.200
     2.677    10.388     0.200
     2.901    14.046     0.200
     3.026    12.369     0.200
     3.051    11.932     0.200
     3.116    13.772     0.200
     3.510    13.737     0.200
     3.466    13.534     0.200
     3.543    13.175     0.200
     3.543    15.229     0.200
     3.617    13.557     0.200
     3.934    14.121     0.200
     3.934    15.090     0.200
     3.962    16.116     0.200
     3.963    16.102     0.200
     4.098    17.196     0.200
     4.316    15.782     0.200
     4.638    15.522     0.200
     4.633    16.700     0.200
     4.736    16.947     0.200
     4.700    17.222     0.200
     5.028    18.046     0.200
     5.658    18.686     0.200
     5.741    19.611     0.200
     5.741    19.614     0.200
     6.210    18.488     0.200
     6.544    20.556     0.200
     7.409    24.928     0.200
     7.440    22.602     0.200
     7.843    24.881     0.200
     9.338    26.208     0.200
     9.271    28.740     0.200
     9.271    26.724     0.200
     9.337    26.425     0.200
     9.704    26.892     0.200
     9.845    30.119     0.200
    10.215    26.884     0.200
    10.215    28.150     0.200
    10.598    29.359     0.200
    11.274    30.639     0.200
    11.274    31.706     0.200
    11.479    30.602     0.200
    11.842    31.252     0.200
    11.866    31.512     0.200
    11.975    31.332     0.200
    12.306    33.001     0.200
    12.649    32.123     0.200
    12.751    32.050     0.200
    12.831    34.141     0.200
    12.859    33.136     0.200
    13.237    35.027     0.200
    13.770    32.644     0.200
    13.781    35.976     0.200
    13.814    35.539     0.200
    13.885    35.609     0.200
    14.101    36.187     0.200
    14.125    36.666     0.200
    15.634    38.448     0.200
    15.980    39.289     0.200
    17.127    38.061     0.200
    17.168    39.341     0.200
    17.868    37.874     0.200
    17.994    37.941     0.200
    18.015    36.898     0.200
    18.128    38.180     0.200
    18.141    37.558     0.200
    18.194    42.883     0.200
    18.905    40.442     0.200
    19.769    39.915     0.200
    19.827    39.999     0.200
    20.189    40.465     0.200
     1.291     7.537     0.200
     2.387    10.375     0.200
     2.496    10.538     0.200
     2.732    12.889     0.200
     2.989    14.379     0.200
     3.475    13.000     0.200
     3.561    13.838     0.200
     3.505    13.315     0.200
     4.350    14.786     0.200
     4.529    17.131     0.200
     4.563    15.954     0.200
     4.864    16.891     0.200
     5.003    19.595     0.200
     1.749     8.843     0.200
     1.621    10.026     0.200
     1.991     7.771     0.200
     2.213     9.244     0.200
     2.470    10.305     0.200
     2.598    11.720     0.200
     2.552    10.824     0.200
     2.732    10.768     0.200
     2.955    12.549     0.200
     2.881    14.836     0.200
     3.013    12.388     0.200
     3.033    14.335     0.200
     3.304    12.143     0.200
     3.422    14.460     0.200
     3.439    15.267     0.200
     3.446    14.393     0.200
     3.450    14.126     0.200
     3.455    14.012     0.200
     3.461    14.405     0.200
     3.627    12.240     0.200
     3.583    13.449     0.200
     3.656    14.339     0.200
     4.197    15.167     0.200
     4.316    14.552     0.200
     4.338    15.793     0.200
     4.585    13.353     0.200
     4.654    16.554     0.200
     4.874    16.698     0.200
     5.334    17.333     0.200
     5.341    17.996     0.200
     6.104    17.950     0.200
     6.336    18.878     0.200
     7.065    20.368     0.200
     8.959    24.898     0.200
    11.069    31.068     0.200
     1.567     9.509     0.200
     2.018    11.594     0.200
     2.179    12.320     0.200
     2.473    13.679     0.200
     2.835    15.038     0.200
     3.081    14.556     0.200
     3.089    15.234     0.200
     3.149    16.053     0.200
     3.279    15.109     0.200
     3.468    14.856     0.200
     3.478    14.744     0.200
     3.483    15.245     0.200
     3.492    16.162     0.200
     4.000    17.911     0.200
     4.047    16.526     0.200
     4.115    17.625     0.200
     4.223    18.816     0.200
     4.542    18.347     0.200
     4.589    19.446     0.200
     4.817    18.768     0.200
     5.001    20.400     0.200
     5.120    20.813     0.200
     5.781    20.641     0.200
     5.987    18.548     0.200
     5.980    20.500     0.200
     6.240    24.992     0.200
     1.528    10.193     0.200
     1.968    11.698     0.200
     2.149    12.652     0.200
     2.526    12.464     0.200
     2.610    14.371     0.200
     2.814    15.436     0.200
     2.918    13.642     0.200
     3.039    12.336     0.200
     3.078    13.538     0.200
     3.162    15.751     0.200
     3.332    15.708     0.200
     3.454    16.817     0.200
     3.459    16.986     0.200
     3.460    17.825     0.200
     4.010    18.457     0.200
     4.085    16.783     0.200
     4.202    17.745     0.200
     4.522    17.484     0.200
     4.629    17.521     0.200
     4.751    17.388     0.200
     4.791    18.013     0.200
     4.967    19.051     0.200
     5.105    19.739     0.200
     6.028    21.033     0.200
     6.289    27.167     0.200
     7.391    25.848     0.200
     9.940    30.853     0.200
     2.393     9.057     0.200
     2.427    10.875     0.200
     2.626    10.072     0.200
     2.782    11.509     0.200
     2.908    10.230     0.200
     3.481    12.699     0.200
     3.572    15.407     0.200
     3.684    12.693     0.200
     3.715    15.031     0.200
     4.026    13.332     0.200
     1.246     7.518     0.200
     1.389     9.373     0.200
     1.488     8.403     0.200
     1.525     9.494     0.200
     1.642     7.980     0.200
     1.671     9.198     0.200
     1.939     8.569     0.200
     2.311    11.233     0.200
     2.382    12.489     0.200
     2.644    11.756     0.200
     2.830    13.553     0.200
     2.905    12.745     0.200
     3.160    12.476     0.200
     3.249    13.465     0.200
     3.334    13.765     0.200
     3.453    14.676     0.200
     3.470    14.049     0.200
     3.926    15.350     0.200
     3.934    18.923     0.200
     3.940    13.106     0.200
     3.962    18.543     0.200
     4.024    17.627     0.200
     4.032    13.864     0.200
     4.060    14.926     0.200
     4.086    16.669     0.200
     4.357    16.732     0.200
     4.360    18.029     0.200
     4.365    19.308     0.200
     4.367    14.052     0.200
     4.367    16.453     0.200
     4.376    17.277     0.200
     4.447    16.351     0.200
     4.453    17.539     0.200
     4.704    15.346     0.200
     4.704    16.976     0.200
     4.749    16.873     0.200
     7.915    23.397     0.200
    11.224    32.412     0.200
    11.225    27.760     0.200
    11.531    29.318     0.200
    11.934    30.309     0.200
    12.259    32.707     0.200
    12.774    31.122     0.200
    13.678    32.086     0.200
    13.900    33.751     0.200
    14.115    34.109     0.200
    14.190    34.769     0.200
    15.304    36.772     0.200
    15.429    37.351     0.200
    15.657    37.089     0.200
    17.858    37.939     0.200
     1.186     7.030     0.200
     1.956    10.121     0.200
     2.435    10.092     0.200
     2.687    11.842     0.200
     2.754    12.352     0.200
     2.731    10.788     0.200
     2.956     9.497     0.200
     3.046    14.574     0.200
     3.198    13.619     0.200
     3.529    13.107     0.200
     3.604    15.453     0.200
     3.625    15.439     0.200
     3.630    13.470     0.200
     3.633    15.042     0.200
     3.636    14.477     0.200
     3.641    15.534     0.200
     3.743    14.972     0.200
     3.771    14.983     0.200
     4.089    15.530     0.200
     4.410    16.483     0.200
     4.541    15.676     0.200
     4.558    16.911     0.200
     4.877    17.651     0.200
     5.082    18.032     0.200
     5.558    18.391     0.200
     0.849     5.845     0.200
     1.211     6.469     0.200
     1.722     9.739     0.200
     1.722     9.499     0.200
     2.005     8.970     0.200
     2.335     9.100     0.200
     2.466     9.490     0.200
     2.694    10.213     0.200
     2.598    10.579     0.200
     2.733    10.556     0.200
     2.805    10.796     0.200
     2.784     9.515     0.200
     2.834    12.063     0.200
     2.868    12.070     0.200
     2.992    10.936     0.200
     3.025    13.611     0.200
     3.052    12.738     0.200
     3.100    12.744     0.200
     3.238    12.185     0.200
     3.251    11.973     0.200
     3.237    13.179     0.200
     3.243    12.124     0.200
     3.248    13.692     0.200
     3.248    13.361     0.200
     3.248    12.762     0.200
     3.268    13.057     0.200
     3.303    10.243     0.200
     3.269    12.391     0.200
     3.274    11.767     0.200
     3.283    12.322     0.200
     3.331    12.428     0.200
     3.366    11.342     0.200
     3.429    14.608     0.200
     3.564    12.510     0.200
     3.513    14.953     0.200
     3.559    13.813     0.200
     3.581    12.884     0.200
     3.657    13.693     0.200
     3.657    14.052     0.200
     3.678    13.903     0.200
     3.683    12.111     0.200
     3.689    12.587     0.200
     3.693    13.956     0.200
     3.695    13.941     0.200
     3.788    14.850     0.200
     3.788    14.091     0.200
     3.813    14.374     0.200
     3.758    12.114     0.200
     3.757    12.121     0.200
     3.866    14.065     0.200
     4.137    14.694     0.200
     4.198    15.086     0.200
     4.378    14.511     0.200
     4.378    14.671     0.200
     4.378    15.140     0.200
     4.457    15.572     0.200
     4.577    15.050     0.200
     4.602    15.581     0.200
     4.837    14.997     0.200
     4.919    16.547     0.200
     4.940    14.247     0.200
     5.131    17.149     0.200
     5.596    14.629     0.200
     5.605    16.947     0.200
     5.605    16.950     0.200
     5.594    16.784     0.200
     5.868    17.392     0.200
     6.364    18.538     0.200
     6.599    19.649     0.200
     7.066    20.900     0.200
     7.327    21.673     0.200
     7.327    21.389     0.200
     7.479    20.503     0.200
     7.983    21.962     0.200
     8.675    26.421     0.200
     8.675    27.162     0.200
     9.042    24.389     0.200
     9.024    24.760     0.200
     9.024    27.279     0.200
     9.224    24.714     0.200
     9.331    24.092     0.200
    10.071    23.678     0.200
    10.970    30.469     0.200
    12.671    33.984     0.200
    13.011    32.439     0.200
    13.515    32.064     0.200
    13.515    32.191     0.200
    13.532    34.110     0.200
    15.334    37.170     0.200
    15.404    35.469     0.200
    15.538    35.516     0.200
    15.612    35.114     0.200
    15.719    33.763     0.200
    15.779    36.334     0.200
    15.779    37.426     0.200
    15.743    35.163     0.200
    16.257    35.445     0.200
    16.399    37.648     0.200
    16.452    36.010     0.200
    16.462    35.996     0.200
    16.627    36.187     0.200
    16.627    37.228     0.200
    16.682    35.947     0.200
    16.784    36.233     0.200
    16.960    36.070     0.200
    17.069    36.378     0.200
    17.168    35.364     0.200
    17.948    35.532     0.200
    19.506    37.718     0.200
    19.593    37.280     0.200
    19.685    38.689     0.200
    19.874    37.351     0.200
     2.100    10.121     0.200
     2.624    12.416     0.200
     2.702    12.139     0.200
     3.372    15.908     0.200
     3.372    16.078     0.200
     3.396    16.037     0.200
     3.401    16.749     0.200
     3.406    15.683     0.200
     3.573    15.862     0.200
     0.458     4.797     0.200
     1.133     6.342     0.200
     1.285     7.370     0.200
     1.302     7.088     0.200
     1.370     8.011     0.200
     1.394     7.364     0.200
     1.527     7.152     0.200
     2.017     9.245     0.200
     2.017    10.221     0.200
     2.017    10.112     0.200
     2.354     8.208     0.200
     2.395    10.479     0.200
     2.582    10.218     0.200
     2.798    10.305     0.200
     2.795    10.868     0.200
     3.118    14.011     0.200
     3.106    11.042     0.200
     3.160    11.446     0.200
     3.196    11.977     0.200
     3.255    13.004     0.200
     3.340    11.682     0.200
     3.480    12.365     0.200
     3.620    13.388     0.200
     3.620    12.062     0.200
     3.624    14.667     0.200
     3.627    16.319     0.200
     3.627    14.049     0.200
     3.627    12.811     0.200
     3.643    11.786     0.200
     3.646    13.091     0.200
     3.652    15.001     0.200
     3.626    12.715     0.200
     3.664    15.535     0.200
     3.742    11.967     0.200
     4.045    14.413     0.200
     4.045    16.402     0.200
     4.067    14.158     0.200
     4.071    15.433     0.200
     4.074    14.739     0.200
     4.077    16.031     0.200
     4.169    15.153     0.200
     4.169    14.692     0.200
     4.105    14.068     0.200
     4.185    14.510     0.200
     4.255    14.619     0.200
     4.403    14.780     0.200
     4.403    13.870     0.200
     4.403    15.171     0.200
     4.438    12.825     0.200
     4.524    15.274     0.200
     4.845    16.188     0.200
     4.929    15.459     0.200
     4.980    16.498     0.200
     5.229    13.804     0.200
     5.289    17.270     0.200
     5.259    15.855     0.200
     5.521    17.120     0.200
     5.829    16.347     0.200
     5.984    18.760     0.200
     6.753    18.341     0.200
     6.957    19.039     0.200
     7.057    21.586     0.200
     7.241    19.663     0.200
     7.608    21.474     0.200
     7.712    22.028     0.200
     7.712    21.739     0.200
     8.371    22.639     0.200
     8.383    26.378     0.200
     8.383    26.226     0.200
     8.923    26.598     0.200
     8.923    25.579     0.200
     8.923    27.321     0.200
     9.426    24.579     0.200
     9.496    22.536     0.200
     9.598    27.723     0.200
    10.340    25.366     0.200
    10.453    29.327     0.200
    10.453    26.026     0.200
    10.424    24.635     0.200
    10.956    26.835     0.200
    10.956    28.479     0.200
    10.956    28.822     0.200
    10.956    31.595     0.200
    11.989    29.952     0.200
    12.391    30.268     0.200
    12.528    32.226     0.200
    12.614    31.654     0.200
    12.932    32.473     0.200
    13.205    30.847     0.200
    13.481    34.175     0.200
    13.481    33.937     0.200
    13.595    32.830     0.200
    13.601    32.927     0.200
    13.810    34.913     0.200
    13.903    32.627     0.200
    13.903    31.826     0.200
    14.432    34.042     0.200
    14.798    35.546     0.200
    15.284    34.422     0.200
    15.848    35.088     0.200
    15.913    34.526     0.200
    16.280    37.491     0.200
    16.385    35.248     0.200
    16.443    35.643     0.200
    16.794    36.094     0.200
    16.833    36.659     0.200
    16.833    36.967     0.200
    17.026    35.991     0.200
    17.141    35.591     0.200
    17.160    36.524     0.200
    17.261    36.390     0.200
    17.444    36.428     0.200
    17.524    35.964     0.200
    17.560    35.555     0.200
    17.762    35.513     0.200
    17.818    35.645     0.200
    17.897    36.100     0.200
    18.212    38.375     0.200
    19.106    38.552     0.200
    19.108    37.951     0.200
    19.427    38.259     0.200
    19.466    37.226     0.200
     0.953     5.854     0.200
     0.805     6.831     0.200
     1.288     7.062     0.200
     1.414     6.942     0.200
     1.408     7.463     0.200
     1.406     8.034     0.200
     1.519     7.481     0.200
     1.486     8.799     0.200
     2.019     9.071     0.200
     2.254     7.855     0.200
     2.598     8.573     0.200
     2.628     9.655     0.200
     2.673    13.046     0.200
     2.777    10.991     0.200
     2.841    11.443     0.200
     2.795    11.201     0.200
     2.796    12.594     0.200
     2.999    13.236     0.200
     3.124    11.337     0.200
     3.146    13.316     0.200
     3.278    14.106     0.200
     3.331    14.717     0.200
     4.157    14.671     0.200
     4.480    15.597     0.200
     4.663    16.163     0.200
     4.698    15.028     0.200
     4.817    15.470     0.200
     4.999    16.848     0.200
     5.659    18.835     0.200
     7.360    20.899     0.200
    10.659    27.363     0.200
    16.584    35.501     0.200
     1.120     7.148     0.200
     1.212     5.997     0.200
     1.510     7.813     0.200
     1.653     8.367     0.200
     1.765     8.664     0.200
     1.794     8.696     0.200
     1.979     8.637     0.200
     2.384     9.448     0.200
     2.406     8.736     0.200
     2.692    12.432     0.200
     2.697    10.516     0.200
     2.784    10.639     0.200
     2.802    13.132     0.200
     2.871    12.636     0.200
     2.918    11.189     0.200
     2.873    11.880     0.200
     3.124    12.945     0.200
     3.113    12.249     0.200
     3.247    13.255     0.200
     3.414    13.195     0.200
     3.489    11.764     0.200
     3.656    13.796     0.200
     3.656    15.125     0.200
     3.673    15.595     0.200
     3.680    13.509     0.200
     3.689    14.739     0.200
     3.698    13.599     0.200
     3.741    13.678     0.200
     3.756    13.403     0.200
     3.861    16.723     0.200
     4.101    14.545     0.200
     4.421    15.475     0.200
     4.506    15.162     0.200
     4.552    16.068     0.200
     4.861    17.039     0.200
     5.103    16.130     0.200
     5.556    18.211     0.200
    11.090    28.582     0.200
     1.204     8.027     0.200
     1.303     7.803     0.200
     1.784     7.700     0.200
     1.766     7.753     0.200
     2.732    10.889     0.200
     2.645    12.995     0.200
     3.053    12.262     0.200
     3.065    14.389     0.200
     3.518    16.499     0.200
     3.609    14.119     0.200
     3.992    16.822     0.200
     4.177    13.693     0.200
     4.231    16.827     0.200
     4.398    18.860     0.200
     4.424    17.228     0.200
     4.430    19.814     0.200
     4.484    16.463     0.200
     5.171    17.163     0.200
     5.288    17.838     0.200
     5.570    17.605     0.200
     5.585    19.172     0.200
     5.603    16.432     0.200
     5.856    19.379     0.200
     8.029    24.387     0.200
    11.062    32.178     0.200
     1.057     5.650     0.200
     1.059     6.964     0.200
     1.596     7.375     0.200
     1.590     9.309     0.200
     1.797     8.667     0.200
     1.841     8.065     0.200
     2.291     8.688     0.200
     2.529     8.105     0.200
     2.527    10.466     0.200
     2.596    11.021     0.200
     2.588    11.156     0.200
     2.805    10.355     0.200
     2.885     8.936     0.200
     2.902    13.398     0.200
     3.045    10.895     0.200
     3.184    12.692     0.200
     3.378    11.514     0.200
     3.430    11.731     0.200
     3.452    15.613     0.200
     3.472    13.725     0.200
     3.481    13.282     0.200
     3.485    15.195     0.200
     3.929    13.129     0.200
     4.250    15.255     0.200
     4.388    14.441     0.200
     4.399    15.713     0.200
     4.719    16.406     0.200
     4.923    15.014     0.200
     1.968    10.139     0.200
     1.957    10.382     0.200
     2.898    13.175     0.200
     2.929    13.135     0.200
     3.701    15.420     0.200
     3.795    14.895     0.200
     3.765    15.450     0.200
     4.145    16.930     0.200
     4.361    16.516     0.200
     4.506    17.717     0.200
     4.585    16.975     0.200
     4.572    17.189     0.200
     4.663    18.984     0.200
     4.659    16.641     0.200
     5.023    17.550     0.200
     5.466    17.549     0.200
     5.766    19.412     0.200
     6.024    19.000     0.200
     1.834    10.020     0.200
     1.706    10.440     0.200
     2.077    11.252     0.200
     2.346    10.827     0.200
     2.578    13.192     0.200
     2.762    11.909     0.200
     2.895    14.402     0.200
     3.051    14.087     0.200
     2.998    13.003     0.200
     3.104    12.887     0.200
     3.660    14.418     0.200
     3.751    15.666     0.200
     3.995    18.640     0.200
     3.997    16.182     0.200
     3.997    17.701     0.200
     4.013    16.138     0.200
     4.227    14.525     0.200
     4.458    17.223     0.200
     4.459    17.217     0.200
     4.455    20.109     0.200
     4.503    17.012     0.200
     4.503    15.754     0.200
     4.503    13.742     0.200
     4.503    18.914     0.200
     4.503    17.293     0.200
     4.521    16.100     0.200
     4.521    18.408     0.200
     4.521    16.354     0.200
     4.628    18.165     0.200
     4.717    18.832     0.200
     4.886    17.142     0.200
     5.206    18.262     0.200
     5.248    17.141     0.200
     5.248    17.821     0.200
     5.598    20.522     0.200
     5.598    18.834     0.200
     5.705    18.680     0.200
     5.705    18.230     0.200
     5.887    19.249     0.200
     6.100    21.023     0.200
     6.203    21.531     0.200
     6.267    20.484     0.200
     6.334    20.508     0.200
     6.333    20.510     0.200
     6.343    22.339     0.200
     7.006    24.580     0.200
     7.281    23.424     0.200
     7.461    23.697     0.200
     7.461    24.279     0.200
     7.289    20.935     0.200
     7.324    20.998     0.200
     7.787    25.775     0.200
     8.067    23.561     0.200
     8.067    24.186     0.200
     8.067    22.279     0.200
     8.146    27.694     0.200
     8.146    27.397     0.200
     8.146    25.034     0.200
     8.146    25.784     0.200
     8.888    28.246     0.200
     8.888    27.285     0.200
     8.888    27.875     0.200
     9.782    29.307     0.200
     9.782    26.822     0.200
    10.487    30.875     0.200
    10.597    28.082     0.200
    10.806    29.250     0.200
    10.806    30.594     0.200
    10.806    30.813     0.200
    11.001    32.510     0.200
    11.001    30.483     0.200
    11.001    32.034     0.200
    11.020    31.663     0.200
    11.198    30.499     0.200
    11.462    28.242     0.200
    11.659    33.254     0.200
    11.762    33.401     0.200
    11.819    31.841     0.200
    11.964    33.688     0.200
    12.141    30.512     0.200
    12.141    31.118     0.200
    12.291    36.227     0.200
    12.219    33.727     0.200
    12.446    36.495     0.200
    12.535    34.498     0.200
    12.541    34.189     0.200
    12.575    35.142     0.200
    12.724    34.728     0.200
    12.792    34.391     0.200
    12.792    35.309     0.200
    12.956    33.925     0.200
    12.997    35.348     0.200
    13.002    34.940     0.200
    13.036    35.451     0.200
    13.008    31.754     0.200
    13.169    34.048     0.200
    13.300    36.419     0.200
    13.363    36.069     0.200
    13.369    35.877     0.200
    13.434    33.287     0.200
    13.434    32.897     0.200
    13.434    32.030     0.200
    13.461    34.393     0.200
    13.489    34.433     0.200
    14.613    37.081     0.200
    15.523    38.998     0.200
    15.523    38.131     0.200
    15.523    39.209     0.200
    15.915    39.190     0.200
    15.906    37.607     0.200
    16.011    35.892     0.200
    16.142    38.340     0.200
    16.112    38.640     0.200
    16.118    38.341     0.200
    16.220    37.060     0.200
    16.860    37.697     0.200
    16.833    38.415     0.200
    16.833    39.095     0.200
    16.833    39.622     0.200
    16.798    39.200     0.200
    16.964    38.946     0.200
    16.964    37.595     0.200
    17.505    39.282     0.200
    17.645    38.708     0.200
    17.857    38.849     0.200
    18.050    37.093     0.200
    18.738    44.717     0.200
    18.825    44.535     0.200
    18.844    45.716     0.200
    18.843    43.379     0.200
    18.843    46.434     0.200
    18.847    46.505     0.200
    18.880    46.353     0.200
    19.015    41.489     0.200
    19.039    42.621     0.200
    19.050    43.546     0.200
    19.058    44.391     0.200
    19.077    42.407     0.200
    19.100    44.250     0.200
    19.111    45.181     0.200
    19.202    42.011     0.200
    19.224    43.285     0.200
    19.291    43.787     0.200
    19.320    41.919     0.200
    19.330    41.801     0.200
    19.332    41.777     0.200
    19.303    41.253     0.200
    19.303    41.792     0.200
    19.422    41.912     0.200
    19.423    40.652     0.200
    19.423    41.187     0.200
    19.522    43.912     0.200
    19.559    41.366     0.200
    19.588    41.731     0.200
    19.598    42.322     0.200
    19.680    41.250     0.200
    19.751    43.000     0.200
    19.805    41.234     0.200
    19.868    41.519     0.200
    19.931    40.427     0.200
    19.958    41.523     0.200
    19.958    41.403     0.200
    19.968    41.402     0.200
    20.054    40.407     0.200
    20.065    44.270     0.200
    20.101    43.029     0.200
    20.109    43.751     0.200
    20.186    41.451     0.200
    20.237    44.373     0.200
    20.274    43.240     0.200
    20.291    41.040     0.200
    20.320    43.286     0.200
    20.338    43.198     0.200
    20.367    42.623     0.200
    20.374    40.898     0.200
    20.383    42.078     0.200
    20.393    42.503     0.200
    20.433    41.031     0.200
    20.440    42.716     0.200
    20.504    41.946     0.200
    20.504    40.676     0.200
    20.523    45.027     0.200
    20.537    40.635     0.200
    20.584    41.965     0.200
    20.596    42.058     0.200
    20.598    40.631     0.200
    20.598    40.277     0.200
    20.600    41.190     0.200
    20.711    40.598     0.200
     1.944    10.239     0.200
     2.675    12.447     0.200
     2.756    13.686     0.200
     2.756    13.318     0.200
     3.308    15.088     0.200
     3.330    13.540     0.200
     3.685    13.157     0.200
     3.771    17.646     0.200
     4.012    16.132     0.200
     4.039    17.814     0.200
     4.244    17.201     0.200
     4.366    18.741     0.200
     4.471    17.874     0.200
     4.471    14.616     0.200
     4.471    17.272     0.200
     4.471    17.546     0.200
     4.468    20.584     0.200
     4.497    20.674     0.200
     4.511    19.906     0.200
     4.511    15.015     0.200
     4.511    20.171     0.200
     4.511    20.452     0.200
     4.514    20.107     0.200
     4.535    19.763     0.200
     4.554    20.330     0.200
     4.619    19.642     0.200
     4.626    20.261     0.200
     4.718    18.851     0.200
     4.772    18.109     0.200
     4.809    17.148     0.200
     4.847    19.144     0.200
     4.907    20.533     0.200
     4.954    20.000     0.200
     4.981    19.273     0.200
     4.982    20.590     0.200
     4.984    19.736     0.200
     4.987    20.646     0.200
     4.993    19.524     0.200
     4.988    20.631     0.200
     5.103    16.079     0.200
     5.103    17.165     0.200
     5.111    17.483     0.200
     5.170    20.070     0.200
     5.461    18.791     0.200
     5.782    19.553     0.200
     5.831    19.533     0.200
     5.912    19.584     0.200
     6.159    22.448     0.200
     6.214    21.655     0.200
     6.353    20.758     0.200
     6.456    21.567     0.200
     6.722    24.723     0.200
     6.850    20.401     0.200
     6.917    23.217     0.200
     6.917    23.220     0.200
     7.629    27.958     0.200
     7.629    27.817     0.200
     8.618    28.368     0.200
     8.618    28.158     0.200
     8.648    24.544     0.200
    10.845    32.258     0.200
    10.845    31.773     0.200
    10.846    31.738     0.200
    11.388    31.449     0.200
    11.388    33.863     0.200
    11.738    35.250     0.200
    11.738    34.906     0.200
    11.883    33.854     0.200
    13.273    37.446     0.200
    13.273    36.235     0.200
    13.522    37.095     0.200
    13.586    33.696     0.200
    13.586    35.399     0.200
    13.586    36.602     0.200
    13.639    33.930     0.200
    15.157    36.308     0.200
    15.157    38.659     0.200
    15.328    36.854     0.200
    15.388    35.940     0.200
    15.495    36.925     0.200
    15.644    36.563     0.200
    16.491    37.031     0.200
    16.602    39.902     0.200
    16.847    38.805     0.200
    16.847    39.110     0.200
    16.847    37.610     0.200
    18.315    39.616     0.200
    18.506    42.478     0.200
    18.857    43.037     0.200
    18.857    42.804     0.200
    18.857    43.279     0.200
    19.140    41.686     0.200
    19.320    41.614     0.200
    19.374    42.569     0.200
    19.427    47.413     0.200
    19.452    42.891     0.200
    19.607    40.734     0.200
    19.624    41.767     0.200
    19.683    41.781     0.200
    19.915    42.072     0.200
    20.005    41.692     0.200
    20.005    44.285     0.200
    20.080    43.840     0.200
    20.225    39.778     0.200
    20.262    41.539     0.200
     1.123     6.863     0.200
     1.380     7.849     0.200
     1.742     7.956     0.200
     1.826     8.497     0.200
     2.391    11.774     0.200
     2.718    11.693     0.200
     2.718    13.323     0.200
     3.008    10.305     0.200
     3.136    13.156     0.200
     3.570    13.200     0.200
     4.134    14.500     0.200
     4.415    16.372     0.200
     4.422    16.294     0.200
     4.451    14.964     0.200
     4.455    16.044     0.200
     4.603    17.308     0.200
     4.831    16.946     0.200
     8.003    23.451     0.200
    11.141    29.177     0.200
     1.165     7.301     0.200
     1.324     8.652     0.200
     1.423     8.143     0.200
     1.689     8.069     0.200
     1.645     9.994     0.200
     1.879    11.352     0.200
     2.672    11.969     0.200
     2.765    13.362     0.200
     3.185    13.581     0.200
     3.518    14.494     0.200
     3.480    15.093     0.200
     3.891    17.226     0.200
     3.947    16.076     0.200
     4.400    15.182     0.200
     4.373    15.954     0.200
     4.405    16.557     0.200
     4.380    17.439     0.200
     4.384    16.864     0.200
     4.388    16.696     0.200
     4.394    20.353     0.200
     4.561    16.340     0.200
     4.652    18.419     0.200
     4.783    17.130     0.200
     7.953    23.947     0.200
    11.167    32.981     0.200
     1.869     7.463     0.200
     2.778    11.281     0.200
     2.942    12.485     0.200
     3.017    11.978     0.200
     3.140    12.568     0.200
     3.693    12.069     0.200
     3.702    15.124     0.200
     4.261    16.158     0.200
     4.424    18.946     0.200
     4.447    18.676     0.200
     4.451    18.632     0.200
     4.453    18.481     0.200
     4.455    18.929     0.200
     4.635    16.926     0.200
     1.105     6.722     0.200
     1.364     7.657     0.200
     1.717     7.367     0.200
     1.834     9.726     0.200
     2.206    11.916     0.200
     2.336    11.950     0.200
     2.336    11.469     0.200
     2.677    10.945     0.200
     2.709    12.787     0.200
     2.985    11.047     0.200
     3.082    14.692     0.200
     3.123    12.582     0.200
     3.483    14.296     0.200
     3.476    15.646     0.200
     3.545    14.196     0.200
     3.830    15.435     0.200
     3.926    17.036     0.200
     3.943    14.394     0.200
     3.941    15.479     0.200
     3.961    16.632     0.200
     3.967    17.886     0.200
     3.977    18.433     0.200
     4.110    12.639     0.200
     4.193    14.577     0.200
     4.388    16.104     0.200
     4.421    15.635     0.200
     4.421    15.205     0.200
     4.428    16.995     0.200
     4.590    16.040     0.200
     4.590    16.761     0.200
     4.590    17.081     0.200
     4.738    16.287     0.200
     4.793    16.148     0.200
     5.112    17.210     0.200
     5.131    16.491     0.200
     5.225    17.606     0.200
     5.515    17.972     0.200
     5.580    19.338     0.200
     5.799    18.473     0.200
     6.151    16.613     0.200
     6.126    19.709     0.200
     6.230    19.536     0.200
     7.166    22.417     0.200
     7.509    22.276     0.200
     7.850    23.662     0.200
     9.005    29.352     0.200
     9.683    28.485     0.200
    10.562    26.707     0.200
    10.704    28.982     0.200
    10.704    29.361     0.200
    11.103    28.706     0.200
    11.103    32.766     0.200
    11.103    32.047     0.200
    11.103    28.892     0.200
    11.109    34.404     0.200
    11.694    29.854     0.200
    11.750    30.376     0.200
    12.020    30.262     0.200
    12.138    30.769     0.200
    12.611    32.225     0.200
    12.650    32.287     0.200
    12.810    34.471     0.200
    13.098    32.547     0.200
    13.479    34.134     0.200
    13.574    33.971     0.200
    13.784    34.333     0.200
    14.087    34.794     0.200
    14.250    34.676     0.200
    14.718    36.125     0.200
    14.877    35.956     0.200
    15.200    37.470     0.200
    15.272    37.745     0.200
    15.267    36.628     0.200
    15.317    37.690     0.200
    15.543    36.930     0.200
    15.719    37.403     0.200
    15.816    37.498     0.200
    15.983    37.522     0.200
    16.020    36.960     0.200
    16.072    37.369     0.200
    16.187    38.139     0.200
    16.890    38.774     0.200
    16.937    38.074     0.200
    16.924    37.726     0.200
    17.022    38.551     0.200
    17.046    37.683     0.200
    17.376    38.493     0.200
    17.371    38.139     0.200
    18.016    39.433     0.200
    19.435    40.709     0.200
    20.385    41.588     0.200
    20.518    39.798     0.200
     1.386     7.410     0.200
     1.758     8.138     0.200
     1.834    10.541     0.200
     2.196     9.455     0.200
     2.340    12.741     0.200
     2.629    13.524     0.200
     2.825    12.440     0.200
     3.130    12.714     0.200
     3.257    12.438     0.200
     3.464    12.635     0.200
     3.800    15.634     0.200
     3.864    15.826     0.200
     3.870    16.426     0.200
     3.932    15.213     0.200
     3.911    15.080     0.200
     4.307    17.490     0.200
     4.330    17.356     0.200
     4.338    16.677     0.200
     4.339    17.485     0.200
     4.342    16.827     0.200
     4.341    17.627     0.200
     4.341    17.888     0.200
     4.341    17.437     0.200
     4.350    17.545     0.200
     4.358    17.691     0.200
     4.366    16.487     0.200
     4.366    17.458     0.200
     4.370    16.640     0.200
     4.378    17.466     0.200
     4.384    17.086     0.200
     4.382    17.638     0.200
     4.419    16.924     0.200
     4.452    17.351     0.200
     4.464    17.565     0.200
     4.521    16.923     0.200
     4.521    17.603     0.200
     4.526    17.593     0.200
     4.563    16.316     0.200
     4.603    18.202     0.200
     4.589    15.750     0.200
     4.669    18.030     0.200
     4.768    17.836     0.200
     4.772    18.579     0.200
     4.797    17.717     0.200
     4.800    17.641     0.200
     4.802    17.794     0.200
     4.804    18.047     0.200
     4.808    18.422     0.200
     4.926    18.902     0.200
     4.892    17.689     0.200
     4.892    17.880     0.200
     4.896    17.664     0.200
     4.985    18.127     0.200
     5.235    17.701     0.200
     5.256    18.221     0.200
     5.482    18.306     0.200
     5.482    17.327     0.200
     5.611    19.410     0.200
     5.611    18.529     0.200
     5.699    19.812     0.200
     5.870    20.664     0.200
     5.964    20.384     0.200
     5.964    20.273     0.200
     6.256    20.526     0.200
     6.297    21.173     0.200
     6.556    21.357     0.200
     6.630    21.081     0.200
     6.704    22.124     0.200
     6.865    23.822     0.200
     6.923    21.095     0.200
     6.952    20.559     0.200
     7.223    21.688     0.200
     7.595    24.055     0.200
     7.595    23.846     0.200
     7.645    23.453     0.200
     7.875    25.733     0.200
     7.842    26.459     0.200
     7.842    23.858     0.200
     8.757    28.192     0.200
     8.757    27.362     0.200
     8.757    28.091     0.200
     8.790    25.321     0.200
     9.821    28.837     0.200
    10.153    28.066     0.200
    10.537    31.312     0.200
    10.675    31.054     0.200
    10.945    31.371     0.200
    10.945    31.524     0.200
    10.946    31.730     0.200
    10.946    31.949     0.200
    10.951    31.686     0.200
    11.177    31.022     0.200
    11.177    31.543     0.200
    11.394    32.866     0.200
    11.388    32.528     0.200
    11.418    33.012     0.200
    11.425    33.074     0.200
    11.605    32.687     0.200
    11.646    33.001     0.200
    11.751    33.406     0.200
    11.824    29.694     0.200
    11.943    33.633     0.200
    11.943    32.844     0.200
    11.982    32.052     0.200
    12.071    31.873     0.200
    12.453    34.878     0.200
    12.513    32.873     0.200
    13.132    36.707     0.200
    13.256    36.000     0.200
    13.295    36.191     0.200
    13.346    35.926     0.200
    13.395    36.068     0.200
    13.543    36.807     0.200
    13.554    35.390     0.200
    13.559    35.102     0.200
    13.572    33.894     0.200
    13.572    32.655     0.200
    13.572    34.194     0.200
    13.572    34.339     0.200
    13.608    36.220     0.200
    13.682    36.113     0.200
    13.693    36.364     0.200
    13.921    36.675     0.200
    14.029    34.599     0.200
    14.253    37.347     0.200
    14.862    38.891     0.200
    15.329    38.309     0.200
    15.329    38.690     0.200
    15.329    39.395     0.200
    16.285    39.670     0.200
    16.285    39.818     0.200
    16.285    39.939     0.200
    16.489    39.194     0.200
    16.729    39.953     0.200
    16.729    39.722     0.200
    16.729    39.052     0.200
    16.897    38.265     0.200
    17.169    40.415     0.200
    17.330    39.647     0.200
    17.870    38.640     0.200
    18.257    38.054     0.200
    18.294    42.441     0.200
    19.053    41.160     0.200
    19.053    41.779     0.200
    19.053    42.234     0.200
    19.053    42.740     0.200
    19.099    44.835     0.200
    19.153    42.439     0.200
    19.205    41.488     0.200
    19.206    44.103     0.200
    19.209    41.264     0.200
    19.231    43.817     0.200
    19.239    42.673     0.200
    19.377    41.410     0.200
    19.400    43.960     0.200
    19.403    41.635     0.200
    19.412    41.347     0.200
    19.417    46.759     0.200
    19.439    42.103     0.200
    19.463    41.293     0.200
    19.474    40.631     0.200
    19.564    41.874     0.200
    19.586    41.793     0.200
    19.600    41.978     0.200
    19.650    45.096     0.200
    19.684    41.703     0.200
    19.692    41.782     0.200
    19.694    41.588     0.200
    19.782    41.618     0.200
    19.784    40.556     0.200
    19.784    40.451     0.200
    19.784    41.207     0.200
    19.784    41.507     0.200
    19.859    42.299     0.200
    19.883    40.616     0.200
    19.908    40.503     0.200
    19.967    40.144     0.200
    19.959    40.782     0.200
    20.041    41.233     0.200
    20.111    42.008     0.200
    20.167    40.821     0.200
    20.230    40.797     0.200
    20.292    40.604     0.200
    20.416    41.092     0.200
    20.462    41.255     0.200
    20.545    40.633     0.200
    20.635    40.476     0.200
    20.681    40.459     0.200
    20.706    41.749     0.200
    20.728    40.977     0.200
    20.835    41.832     0.200
    20.835    41.476     0.200
    20.850    40.250     0.200
    20.864    40.270     0.200
    20.881    40.591     0.200
    20.945    40.192     0.200
    20.957    40.577     0.200
     1.416     9.134     0.200
     1.667     8.653     0.200
     1.889     8.740     0.200
     2.261    13.348     0.200
     2.639    12.371     0.200
     2.727    11.689     0.200
     2.763    14.096     0.200
     2.934    10.716     0.200
     3.174    14.011     0.200
     3.446    14.630     0.200
     3.495    13.557     0.200
     3.910    16.101     0.200
     3.915    12.760     0.200
     3.860    16.750     0.200
     4.060    15.511     0.200
     4.318    18.549     0.200
     4.337    17.119     0.200
     4.343    17.347     0.200
     4.347    17.334     0.200
     4.351    17.776     0.200
     4.373    17.423     0.200
     4.376    15.546     0.200
     4.376    17.136     0.200
     4.411    18.663     0.200
     4.412    18.657     0.200
     4.524    17.586     0.200
     4.623    18.080     0.200
     4.623    18.548     0.200
     4.623    15.298     0.200
     4.623    19.459     0.200
     4.752    17.923     0.200
     4.742    19.183     0.200
     8.333    28.971     0.200
     8.333    26.022     0.200
     9.052    30.181     0.200
     9.052    24.380     0.200
     9.775    25.631     0.200
    10.589    26.762     0.200
    10.659    27.957     0.200
    10.687    26.609     0.200
    11.142    33.675     0.200
    11.142    29.054     0.200
    11.143    28.369     0.200
    11.143    34.068     0.200
    11.148    34.106     0.200
    11.380    28.222     0.200
    11.713    28.868     0.200
    11.785    30.062     0.200
    11.995    29.661     0.200
    12.039    29.541     0.200
    12.177    30.424     0.200
    12.638    31.556     0.200
    12.693    32.154     0.200
    12.713    32.164     0.200
    12.842    32.207     0.200
    13.135    32.929     0.200
    13.179    33.484     0.200
    13.501    33.153     0.200
    13.493    35.728     0.200
    13.493    31.670     0.200
    13.490    33.726     0.200
    13.516    33.333     0.200
    13.599    33.029     0.200
    13.642    37.597     0.200
    13.642    33.808     0.200
    13.749    33.612     0.200
    13.818    33.294     0.200
    13.918    33.193     0.200
    13.945    34.883     0.200
    14.141    33.985     0.200
    14.747    36.297     0.200
    14.923    36.485     0.200
    14.924    36.889     0.200
    15.226    36.033     0.200
    15.290    35.727     0.200
    15.348    36.285     0.200
    15.316    37.888     0.200
    15.448    36.593     0.200
    15.559    36.866     0.200
    15.576    36.138     0.200
    15.575    36.641     0.200
    15.701    40.167     0.200
    15.701    37.277     0.200
    15.756    36.112     0.200
    15.836    36.248     0.200
    16.007    37.360     0.200
    16.099    37.478     0.200
    16.065    37.170     0.200
    16.202    36.249     0.200
    16.172    37.511     0.200
    16.295    37.370     0.200
    16.302    39.072     0.200
    16.391    37.947     0.200
    16.646    37.472     0.200
    16.673    37.472     0.200
    16.714    37.655     0.200
    16.494    41.907     0.200
    16.989    39.880     0.200
    17.036    38.689     0.200
    17.078    39.114     0.200
    17.202    39.963     0.200
    17.402    39.585     0.200
    17.424    40.080     0.200
    17.579    39.582     0.200
    17.664    39.000     0.200
    18.412    39.433     0.200
    19.254    42.227     0.200
    19.489    42.459     0.200
    19.489    41.539     0.200
    19.567    42.884     0.200
     1.874     8.954     0.200
     2.425     9.878     0.200
     2.590    12.336     0.200
     2.691    10.492     0.200
     2.691    12.672     0.200
     3.224    14.437     0.200
     3.309    14.114     0.200
     3.696    13.841     0.200
     4.373    14.115     0.200
     4.466    13.808     0.200
     5.093    15.586     0.200
    10.751    27.932     0.200
    10.751    26.861     0.200
    11.473    28.453     0.200
    18.795    42.103     0.200
     1.003     6.535     0.200
     1.162     7.482     0.200
     1.263     7.593     0.200
     1.563     9.121     0.200
     1.746     7.606     0.200
     1.791     7.287     0.200
     2.316    10.554     0.200
     2.316     9.523     0.200
     2.316    11.804     0.200
     2.609    12.689     0.200
     2.719    10.773     0.200
     2.852    14.392     0.200
     3.022    12.154     0.200
     3.061    11.156     0.200
     3.032    12.184     0.200
     3.523    13.233     0.200
     3.958    13.534     0.200
     3.958    13.190     0.200
     3.958    15.096     0.200
     3.971    15.623     0.200
     4.184    13.816     0.200
     4.414    15.842     0.200
     4.425    14.365     0.200
     4.478    14.903     0.200
     4.505    13.877     0.200
     4.505    15.823     0.200
     4.505    15.448     0.200
     4.505    14.971     0.200
     4.695    17.269     0.200
     4.843    15.235     0.200
     5.585    18.313     0.200
     5.844    15.971     0.200
     6.080    18.433     0.200
     6.290    16.818     0.200
     7.026    25.716     0.200
     7.238    19.886     0.200
     7.463    21.964     0.200
     8.024    22.504     0.200
     8.024    21.473     0.200
     8.184    25.198     0.200
     8.184    23.894     0.200
     8.906    25.246     0.200
     8.906    24.379     0.200
     9.693    23.915     0.200
    10.484    30.959     0.200
    10.591    30.768     0.200
    10.762    26.308     0.200
    10.762    26.519     0.200
    11.010    30.884     0.200
    11.291    32.388     0.200
    11.629    32.920     0.200
    11.663    31.983     0.200
    11.757    32.006     0.200
    11.954    33.568     0.200
    12.046    33.557     0.200
    12.533    34.311     0.200
    12.554    33.733     0.200
    12.584    34.501     0.200
    12.726    34.602     0.200
    12.822    35.295     0.200
    13.005    35.330     0.200
    13.009    35.448     0.200
    13.308    31.880     0.200
    13.368    32.180     0.200
    13.381    34.231     0.200
    13.420    36.337     0.200
    13.420    33.478     0.200
    13.453    34.246     0.200
    13.503    33.232     0.200
    13.503    32.388     0.200
    13.498    31.910     0.200
    13.616    32.397     0.200
    13.670    35.523     0.200
    13.697    35.856     0.200
    13.704    33.852     0.200
    13.793    36.423     0.200
    13.994    36.325     0.200
    14.009    35.981     0.200
    14.606    34.291     0.200
    14.638    36.273     0.200
    14.777    36.671     0.200
    14.803    33.828     0.200
    15.096    36.764     0.200
    15.125    35.315     0.200
    15.166    36.930     0.200
    15.207    36.092     0.200
    15.235    36.197     0.200
    15.458    36.543     0.200
    15.485    37.121     0.200
    15.548    37.262     0.200
    15.548    36.598     0.200
    15.506    35.910     0.200
    15.629    36.781     0.200
    15.749    37.643     0.200
    15.872    39.239     0.200
    15.922    39.031     0.200
    15.911    38.164     0.200
    15.949    38.215     0.200
    15.995    37.991     0.200
    16.028    37.375     0.200
    16.141    37.702     0.200
    16.148    37.375     0.200
    16.128    36.922     0.200
    16.242    38.538     0.200
    16.549    37.112     0.200
    16.573    37.497     0.200
    16.592    37.483     0.200
    16.641    37.763     0.200
    16.760    39.264     0.200
    16.822    38.902     0.200
    16.815    37.839     0.200
    16.847    38.684     0.200
    16.847    38.926     0.200
    16.848    38.238     0.200
    16.848    39.418     0.200
    16.848    39.293     0.200
    16.848    38.340     0.200
    16.858    38.333     0.200
    16.858    37.825     0.200
    16.925    37.391     0.200
    16.946    38.526     0.200
    16.963    38.038     0.200
    17.171    38.161     0.200
    17.297    38.490     0.200
    17.304    38.539     0.200
    17.304    38.020     0.200
    17.475    38.216     0.200
    17.568    37.524     0.200
    17.669    37.403     0.200
    17.683    35.894     0.200
    17.722    38.134     0.200
    17.832    36.770     0.200
    17.877    39.454     0.200
    17.943    37.500     0.200
    18.000    37.058     0.200
    18.028    37.484     0.200
    18.055    38.099     0.200
    18.068    38.571     0.200
    18.092    37.901     0.200
    17.999    40.458     0.200
    18.291    40.822     0.200
    18.632    40.653     0.200
    19.335    39.651     0.200
    19.335    40.856     0.200
    19.335    42.612     0.200
    19.381    40.282     0.200
    19.381    42.977     0.200
    20.461    39.685     0.200
     2.127    10.805     0.200
     1.621     9.720     0.200
     1.797    10.501     0.200
     2.638    14.182     0.200
     2.370    12.951     0.200
     2.747    12.273     0.200
     4.190    15.545     0.200
     4.433    20.046     0.200
     4.442    21.273     0.200
     4.451    20.022     0.200
     4.497    15.807     0.200
     5.185    17.439     0.200
     5.302    18.978     0.200
     5.599    19.205     0.200
     1.189     7.878     0.200
     1.348     8.583     0.200
     1.450     8.791     0.200
     1.635     8.621     0.200
     1.923     8.411     0.200
     2.295     9.310     0.200
     2.615    12.061     0.200
     2.696    11.310     0.200
     2.797    13.712     0.200
     2.902    11.552     0.200
     3.206    13.478     0.200
     3.435    15.296     0.200
     3.423    14.013     0.200
     3.481    15.463     0.200
     3.513    15.011     0.200
     3.751    16.319     0.200
     3.879    16.127     0.200
     3.889    16.337     0.200
     3.887    16.528     0.200
     3.894    16.889     0.200
     3.896    17.501     0.200
     3.898    17.114     0.200
     3.898    17.255     0.200
     3.898    16.903     0.200
     3.898    16.733     0.200
     3.890    15.928     0.200
     3.921    16.870     0.200
     3.919    16.914     0.200
     3.924    16.418     0.200
     3.924    16.928     0.200
     3.932    15.200     0.200
     3.944    15.516     0.200
     4.017    16.695     0.200
     4.015    16.755     0.200
     4.041    15.696     0.200
     4.078    17.432     0.200
     4.028    14.672     0.200
     4.159    15.682     0.200
     4.164    17.132     0.200
     4.205    17.515     0.200
     4.299    18.029     0.200
     4.316    17.376     0.200
     4.324    17.381     0.200
     4.328    17.693     0.200
     4.332    17.186     0.200
     4.402    17.175     0.200
     4.348    17.060     0.200
     4.348    16.441     0.200
     4.344    16.797     0.200
     4.504    16.054     0.200
     4.644    17.716     0.200
     4.644    17.515     0.200
     4.644    17.155     0.200
     4.726    17.769     0.200
     5.044    18.400     0.200
     5.050    17.879     0.200
     5.050    17.629     0.200
     5.151    19.024     0.200
     5.454    19.760     0.200
     5.454    19.260     0.200
     5.443    19.804     0.200
     5.565    19.655     0.200
     5.734    19.982     0.200
     5.922    19.599     0.200
     5.922    18.169     0.200
     6.086    20.369     0.200
     6.136    21.697     0.200
     6.069    20.313     0.200
     6.156    21.315     0.200
     6.954    21.402     0.200
     7.085    22.559     0.200
     7.204    24.690     0.200
     7.535    24.472     0.200
     7.535    24.261     0.200
     7.456    22.051     0.200
     7.462    24.051     0.200
     7.489    24.860     0.200
     7.491    22.765     0.200
     7.650    23.371     0.200
     7.887    25.184     0.200
     7.897    23.652     0.200
     8.248    25.454     0.200
     8.248    24.114     0.200
     8.367    27.860     0.200
     8.367    27.530     0.200
     8.367    26.579     0.200
     8.367    27.299     0.200
     8.566    25.436     0.200
     9.081    28.828     0.200
     9.081    28.510     0.200
     9.081    29.090     0.200
     9.081    28.248     0.200
     9.259    26.571     0.200
     9.611    30.046     0.200
     9.611    27.677     0.200
     9.787    28.227     0.200
     9.816    29.154     0.200
     9.937    29.978     0.200
    10.606    30.851     0.200
    10.630    30.241     0.200
    10.630    29.693     0.200
    10.702    30.968     0.200
    10.831    31.910     0.200
    10.867    32.352     0.200
    11.167    31.134     0.200
    11.167    32.835     0.200
    11.168    33.379     0.200
    11.168    31.920     0.200
    11.326    31.832     0.200
    11.326    29.861     0.200
    11.393    33.426     0.200
    11.724    33.754     0.200
    11.807    34.189     0.200
    11.966    33.013     0.200
    12.051    32.532     0.200
    12.072    32.752     0.200
    12.202    34.598     0.200
    12.441    34.825     0.200
    12.441    34.585     0.200
    12.441    34.213     0.200
    12.656    34.652     0.200
    12.720    36.061     0.200
    12.737    35.672     0.200
    12.862    35.734     0.200
    12.900    33.261     0.200
    12.900    31.421     0.200
    12.968    36.570     0.200
    13.009    35.990     0.200
    13.009    35.830     0.200
    13.158    36.640     0.200
    13.157    36.971     0.200
    13.204    36.362     0.200
    13.461    35.963     0.200
    13.503    33.533     0.200
    13.503    32.633     0.200
    13.503    34.674     0.200
    13.503    34.213     0.200
    13.503    32.232     0.200
    13.512    36.419     0.200
    13.470    36.523     0.200
    13.556    34.807     0.200
    13.542    35.891     0.200
    13.616    35.130     0.200
    13.534    37.566     0.200
    13.670    37.003     0.200
    13.670    36.003     0.200
    13.775    37.000     0.200
    13.825    37.178     0.200
    13.842    36.544     0.200
    13.840    36.363     0.200
    13.857    36.389     0.200
    13.919    37.612     0.200
    13.941    36.396     0.200
    13.967    37.222     0.200
    14.025    37.340     0.200
    14.150    37.158     0.200
    14.166    36.786     0.200
    14.304    36.932     0.200
    14.331    37.219     0.200
    14.414    35.330     0.200
    14.713    36.895     0.200
    14.765    37.566     0.200
    14.944    37.395     0.200
    14.953    38.764     0.200
    14.948    38.457     0.200
    15.242    36.787     0.200
    15.301    36.974     0.200
    15.367    37.881     0.200
    15.347    39.401     0.200
    15.454    37.158     0.200
    15.568    37.331     0.200
    15.568    36.940     0.200
    15.584    36.352     0.200
    15.596    37.411     0.200
    15.779    37.792     0.200
    15.733    39.806     0.200
    15.733    38.636     0.200
    15.733    39.306     0.200
    15.849    37.705     0.200
    16.021    37.718     0.200
    16.116    38.362     0.200
    16.093    39.275     0.200
    16.121    39.718     0.200
    16.211    37.835     0.200
    16.336    39.259     0.200
    16.661    37.969     0.200
    16.689    37.398     0.200
    16.736    39.020     0.200
    16.528    41.221     0.200
    16.984    38.597     0.200
    17.006    39.870     0.200
    17.098    39.253     0.200
    17.225    38.934     0.200
    17.137    39.428     0.200
    17.293    39.078     0.200
    17.417    38.690     0.200
    17.422    39.164     0.200
    17.597    39.114     0.200
    17.673    37.636     0.200
    17.796    39.094     0.200
    17.805    39.100     0.200
    17.812    39.068     0.200
    17.836    38.963     0.200
    17.890    39.135     0.200
    17.926    38.754     0.200
    18.042    38.832     0.200
    18.055    38.991     0.200
    18.071    38.694     0.200
    18.171    39.047     0.200
    18.499    39.888     0.200
    18.555    39.864     0.200
    18.559    39.652     0.200
    18.779    41.347     0.200
    19.222    42.835     0.200
    19.222    41.983     0.200
    19.222    42.684     0.200
    19.523    41.487     0.200
    19.523    41.547     0.200
    19.595    40.467     0.200
    20.091    42.240     0.200
    20.434    41.092     0.200
    20.683    39.792     0.200
    20.673    40.150     0.200
    20.785    39.662     0.200
     1.608     9.610     0.200
     2.554    12.208     0.200
     2.878    13.054     0.200
     3.161    14.003     0.200
     3.360    14.404     0.200
     3.434    14.893     0.200
     3.394    15.835     0.200
     3.810    17.618     0.200
     3.806    17.634     0.200
     3.819    18.092     0.200
     4.001    15.473     0.200
     4.252    19.772     0.200
     4.255    18.398     0.200
     4.265    18.139     0.200
     4.303    16.513     0.200
     4.301    16.364     0.200
     4.314    16.419     0.200
     4.434    18.312     0.200
     4.671    17.985     0.200
     4.990    18.047     0.200
     5.022    16.746     0.200
     5.107    17.703     0.200
     5.405    20.504     0.200
     5.472    21.480     0.200
     5.676    20.600     0.200
     6.014    21.772     0.200
     6.900    22.776     0.200
     7.848    22.988     0.200
     1.772     9.929     0.200
     2.122    11.919     0.200
     2.593    14.038     0.200
     2.677    13.839     0.200
     2.992    11.450     0.200
     3.044    13.679     0.200
     3.479    16.344     0.200
     3.596    14.301     0.200
     4.326    18.609     0.200
     4.349    19.694     0.200
     4.353    18.196     0.200
     4.355    18.164     0.200
     4.358    19.229     0.200
     4.454    17.498     0.200
     4.444    18.522     0.200
     4.448    18.479     0.200
     4.804    16.407     0.200
     1.298     7.640     0.200
     1.670     8.415     0.200
     1.859    11.310     0.200
     2.279    10.087     0.200
     2.259    13.015     0.200
     2.663    13.264     0.200
     2.663    14.115     0.200
     2.663    12.842     0.200
     2.663    13.951     0.200
     2.753    12.702     0.200
     3.200    13.349     0.200
     3.251    14.799     0.200
     3.340    12.326     0.200
     3.548    12.113     0.200
     3.771    16.161     0.200
     3.995    15.416     0.200
     4.000    16.802     0.200
     4.107    15.088     0.200
     4.383    21.164     0.200
     4.396    20.642     0.200
     4.395    17.497     0.200
     4.395    18.786     0.200
     4.395    20.013     0.200
     4.411    20.432     0.200
     4.420    18.327     0.200
     4.420    19.218     0.200
     4.431    17.802     0.200
     4.438    20.237     0.200
     4.472    18.292     0.200
     4.484    18.098     0.200
     4.484    17.613     0.200
     4.484    17.332     0.200
     4.484    16.895     0.200
     4.527    20.373     0.200
     4.582    19.612     0.200
     4.672    16.512     0.200
     4.807    18.507     0.200
     4.808    18.502     0.200
     4.833    19.158     0.200
     4.858    18.149     0.200
     4.861    19.426     0.200
     4.862    18.810     0.200
     4.866    19.162     0.200
     4.868    19.147     0.200
     4.935    19.429     0.200
     4.969    18.171     0.200
     4.969    18.343     0.200
     5.047    18.611     0.200
     5.329    19.043     0.200
     5.402    17.898     0.200
     5.649    19.941     0.200
     5.694    19.038     0.200
     5.777    20.395     0.200
     5.899    21.382     0.200
     6.032    20.315     0.200
     6.078    21.134     0.200
     6.301    21.763     0.200
     6.326    21.289     0.200
     6.615    22.191     0.200
     6.713    21.640     0.200
     6.782    22.910     0.200
     6.782    22.912     0.200
     6.791    19.081     0.200
     6.796    25.075     0.200
     7.558    23.069     0.200
     7.582    24.960     0.200
     7.728    24.267     0.200
     7.852    26.628     0.200
     7.754    27.250     0.200
     7.754    26.921     0.200
     7.754    26.656     0.200
     7.754    27.367     0.200
     8.514    25.800     0.200
     8.689    28.885     0.200
     8.689    25.830     0.200
     8.689    27.752     0.200
     8.689    26.408     0.200
     8.689    28.431     0.200
     8.838    24.912     0.200
     9.175    26.554     0.200
     9.659    31.636     0.200
     9.804    28.959     0.200
    10.229    29.428     0.200
    10.229    29.780     0.200
    10.388    31.382     0.200
    10.388    29.937     0.200
    10.505    31.293     0.200
    10.649    30.541     0.200
    10.891    31.738     0.200
    10.891    29.714     0.200
    10.891    31.094     0.200
    10.891    30.734     0.200
    11.253    33.097     0.200
    11.253    32.190     0.200
    11.253    29.362     0.200
    11.253    32.456     0.200
    11.372    31.302     0.200
    11.468    33.390     0.200
    11.498    33.992     0.200
    11.600    32.469     0.200
    11.733    31.781     0.200
    11.800    33.371     0.200
    11.856    34.994     0.200
    11.856    34.603     0.200
    11.856    34.072     0.200
    11.856    34.736     0.200
    11.928    34.270     0.200
    12.392    34.125     0.200
    12.476    35.558     0.200
    12.476    35.882     0.200
    12.533    31.985     0.200
    12.546    34.996     0.200
    12.589    32.898     0.200
    12.692    35.765     0.200
    12.855    35.245     0.200
    12.906    35.158     0.200
    12.919    35.390     0.200
    13.299    36.686     0.200
    13.333    37.108     0.200
    13.333    36.709     0.200
    13.527    35.940     0.200
    13.531    35.504     0.200
    13.560    35.769     0.200
    13.560    36.316     0.200
    13.560    35.199     0.200
    13.560    34.129     0.200
    13.560    34.668     0.200
    13.560    37.527     0.200
    13.664    35.761     0.200
    13.708    36.682     0.200
    13.752    38.017     0.200
    14.110    36.949     0.200
    14.907    37.768     0.200
    15.156    37.258     0.200
    15.251    39.489     0.200
    15.251    39.208     0.200
    15.251    39.926     0.200
    15.251    38.333     0.200
    15.574    38.162     0.200
    15.656    38.104     0.200
    15.804    40.634     0.200
    15.837    37.796     0.200
    16.666    40.699     0.200
    16.666    39.824     0.200
    16.861    38.407     0.200
    16.861    38.743     0.200
    16.913    39.123     0.200
    16.928    40.971     0.200
    17.490    39.819     0.200
    17.885    39.464     0.200
    17.996    41.077     0.200
    18.043    39.963     0.200
    18.784    41.012     0.200
    18.969    42.840     0.200
    18.969    41.520     0.200
    18.969    42.035     0.200
    18.968    42.326     0.200
    18.969    43.356     0.200
    19.211    41.079     0.200
    19.290    41.335     0.200
    19.868    42.485     0.200
    19.868    40.774     0.200
    19.868    42.860     0.200
    20.736    42.345     0.200
    20.948    40.828     0.200
     1.829     7.810     0.200
     1.730    10.549     0.200
     2.102     9.755     0.200
     2.623    13.067     0.200
     2.784    11.076     0.200
     3.119    13.614     0.200
     3.097    12.883     0.200
     3.054    13.029     0.200
     3.570    16.232     0.200
     3.594    14.520     0.200
     3.589    14.186     0.200
     3.661    16.588     0.200
     3.657    13.587     0.200
     3.823    14.677     0.200
     4.017    14.728     0.200
     4.030    16.450     0.200
     4.029    15.375     0.200
     4.037    14.620     0.200
     4.037    11.690     0.200
     4.044    15.449     0.200
     4.053    14.923     0.200
     4.056    14.957     0.200
     4.062    14.841     0.200
     4.062    16.540     0.200
     4.073    18.780     0.200
     4.079    15.615     0.200
     4.118    17.263     0.200
     4.152    15.070     0.200
     4.159    16.806     0.200
     4.171    16.005     0.200
     4.219    16.088     0.200
     4.222    14.584     0.200
     4.301    14.809     0.200
     4.451    16.316     0.200
     4.471    16.079     0.200
     4.476    16.015     0.200
     4.480    16.046     0.200
     4.488    17.118     0.200
     4.510    16.986     0.200
     4.532    13.247     0.200
     4.532    16.075     0.200
     4.532    16.518     0.200
     4.575    14.225     0.200
     4.659    16.722     0.200
     4.783    19.325     0.200
     4.903    16.658     0.200
     5.244    16.695     0.200
     5.622    18.666     0.200
     5.650    19.042     0.200
     5.907    19.200     0.200
     6.168    21.005     0.200
     6.237    20.000     0.200
     6.263    19.388     0.200
     6.342    19.722     0.200
     7.067    23.430     0.200
     7.278    20.335     0.200
     7.532    23.378     0.200
     7.859    24.270     0.200
     9.775    23.815     0.200
     9.943    27.500     0.200
    10.815    28.190     0.200
    11.070    31.454     0.200
    11.070    28.931     0.200
    11.730    29.117     0.200
    12.105    28.944     0.200
    13.574    33.136     0.200
    13.555    34.424     0.200
    13.662    29.629     0.200
    14.049    30.388     0.200
    14.870    34.557     0.200
    15.201    34.296     0.200
    15.290    33.822     0.200
    15.307    34.233     0.200
    15.527    37.355     0.200
    19.348    39.784     0.200
     1.682     7.948     0.200
     1.643     8.856     0.200
     1.870     9.517     0.200
     2.055    10.843     0.200
     2.404    12.620     0.200
     2.404    10.890     0.200
     2.574    12.728     0.200
     2.812    10.249     0.200
     3.006    12.806     0.200
     3.139    12.311     0.200
     3.104    14.892     0.200
     3.617    15.018     0.200
     3.698    16.342     0.200
     3.791    16.398     0.200
     4.054    16.578     0.200
     4.054    18.696     0.200
     4.066    17.497     0.200
     4.263    15.202     0.200
     4.472    17.195     0.200
     4.493    15.947     0.200
     4.498    19.147     0.200
     4.501    16.354     0.200
     4.566    15.183     0.200
     4.540    17.572     0.200
     4.682    17.756     0.200
     8.113    21.373     0.200
    10.529    28.432     0.200
    11.029    32.104     0.200
    11.029    29.663     0.200
    11.029    29.318     0.200
    14.834    39.062     0.200
    15.273    39.439     0.200
    15.491    39.400     0.200
    20.657    41.451     0.200
     0.327     3.695     0.200
     0.721     5.032     0.200
     0.877     6.098     0.200
     0.983     6.007     0.200
     1.368     7.197     0.200
     1.568     6.931     0.200
     1.951     7.020     0.200
     1.931     9.737     0.200
     2.164     9.602     0.200
     2.346    11.737     0.200
     2.758    11.448     0.200
     2.725    10.922     0.200
     3.220    10.071     0.200
     3.434    11.857     0.200
     3.561    14.363     0.200
     3.709    11.961     0.200
     3.906    13.202     0.200
     3.906    13.011     0.200
     3.957    14.945     0.200
     4.042    14.027     0.200
     4.328    13.946     0.200
     4.195    14.731     0.200
     4.195    12.762     0.200
     4.308    12.682     0.200
     4.307    12.688     0.200
     4.355    18.269     0.200
     4.383    18.003     0.200
     4.384    16.417     0.200
     4.385    17.534     0.200
     4.388    13.400     0.200
     4.558    15.208     0.200
     4.585    15.666     0.200
     4.896    15.882     0.200
     5.218    16.545     0.200
     5.344    15.076     0.200
     5.373    17.652     0.200
     5.404    15.444     0.200
     5.575    17.628     0.200
     5.691    18.028     0.200
     5.880    16.352     0.200
     6.363    17.885     0.200
     7.121    17.970     0.200
     7.179    19.630     0.200
     8.594    22.639     0.200
     8.743    24.736     0.200
    10.693    28.396     0.200
    10.693    28.614     0.200
    14.333    35.014     0.200
    14.465    35.485     0.200
    14.490    34.167     0.200
    14.827    35.126     0.200
    15.218    35.854     0.200
    15.313    37.454     0.200
    15.634    36.723     0.200
     1.365     7.559     0.200
     1.734     8.977     0.200
     2.152     8.557     0.200
     2.992    12.102     0.200
     3.423    13.458     0.200
     3.423    14.397     0.200
     4.194    17.054     0.200
     4.591    17.629     0.200
     4.620    19.281     0.200
     4.621    17.277     0.200
     4.624    16.152     0.200
     4.786    15.858     0.200
     5.129    17.597     0.200
     5.450    17.336     0.200
     5.556    17.284     0.200
     5.600    18.358     0.200
     5.914    19.653     0.200
     6.115    20.783     0.200
     1.392     6.884     0.200
     1.492     8.827     0.200
     1.758     7.541     0.200
     2.123     8.440     0.200
     2.205    11.644     0.200
     2.302    11.561     0.200
     2.616    12.407     0.200
     2.882    13.590     0.200
     2.937    11.743     0.200
     3.394    11.599     0.200
     3.453    13.699     0.200
     3.598    15.680     0.200
     3.679    11.745     0.200
     3.725    15.174     0.200
     3.732    17.438     0.200
     3.875    15.432     0.200
     3.934    14.649     0.200
     3.928    17.264     0.200
     4.022    13.872     0.200
     4.077    17.421     0.200
     4.117    13.879     0.200
     4.130    17.258     0.200
     4.185    18.304     0.200
     4.454    16.740     0.200
     4.504    13.223     0.200
     4.526    17.326     0.200
     4.556    17.546     0.200
     4.555    16.731     0.200
     4.556    17.801     0.200
     4.558    18.290     0.200
     4.738    14.452     0.200
     5.075    17.060     0.200
     5.397    18.437     0.200
     5.522    17.618     0.200
     5.751    19.516     0.200
     5.871    19.367     0.200
     5.933    19.985     0.200
     6.059    20.053     0.200
     6.541    19.443     0.200
     8.272    24.416     0.200
    10.649    32.009     0.200
     1.514     6.217     0.200
     1.885     6.965     0.200
     2.016     8.298     0.200
     2.398    10.214     0.200
     2.391    11.937     0.200
     2.825    11.578     0.200
     3.041    14.373     0.200
     3.288    11.151     0.200
     3.634    15.178     0.200
     3.663    15.112     0.200
     3.840    12.854     0.200
     4.139    16.634     0.200
     4.408    14.788     0.200
     4.401    15.564     0.200
     4.541    20.015     0.200
     4.533    18.200     0.200
     4.533    18.195     0.200
     4.566    17.753     0.200
     4.569    17.572     0.200
     4.571    18.158     0.200
     4.685    16.818     0.200
     4.717    18.615     0.200
     4.755    14.920     0.200
     5.041    17.476     0.200
     5.361    18.557     0.200
     5.428    17.291     0.200
     5.495    18.903     0.200
     5.523    15.598     0.200
     5.641    18.004     0.200
     5.740    18.355     0.200
     6.036    19.932     0.200
     6.094    21.097     0.200
     6.323    22.614     0.200
     6.448    20.061     0.200
     6.499    21.210     0.200
     6.499    21.213     0.200
     6.845    23.485     0.200
     7.268    21.696     0.200
     7.256    22.643     0.200
     7.460    22.090     0.200
     7.418    22.873     0.200
     7.720    25.306     0.200
     7.954    25.388     0.200
     8.228    24.038     0.200
     8.228    24.208     0.200
     8.228    24.411     0.200
     8.730    23.136     0.200
     8.730    23.905     0.200
     8.887    24.919     0.200
     9.581    30.667     0.200
     9.943    27.446     0.200
    10.110    25.825     0.200
    10.526    28.181     0.200
    10.871    32.478     0.200
    10.871    29.398     0.200
    10.871    29.054     0.200
    11.193    31.398     0.200
    11.222    30.564     0.200
    11.236    29.441     0.200
    11.369    33.113     0.200
    11.586    33.953     0.200
    11.908    30.706     0.200
    11.907    31.114     0.200
    12.028    30.087     0.200
    12.305    28.060     0.200
    12.399    31.945     0.200
    12.448    32.355     0.200
    12.449    31.899     0.200
    12.621    31.488     0.200
    12.608    30.955     0.200
    12.970    28.362     0.200
    13.248    33.780     0.200
    13.345    33.175     0.200
    13.395    32.564     0.200
    13.421    33.151     0.200
    13.597    32.732     0.200
    13.667    33.303     0.200
    13.955    33.705     0.200
    14.544    35.245     0.200
    14.547    34.652     0.200
    14.598    35.910     0.200
    14.689    35.401     0.200
    15.049    35.232     0.200
    15.136    36.517     0.200
    15.314    33.162     0.200
    15.349    36.394     0.200
    15.486    35.141     0.200
    15.500    35.993     0.200
    15.756    36.759     0.200
    15.844    37.616     0.200
    15.914    37.159     0.200
    16.086    35.100     0.200
    16.101    36.407     0.200
    16.480    36.673     0.200
    16.473    36.786     0.200
    16.499    36.258     0.200
    16.599    36.323     0.200
    16.685    37.970     0.200
    16.770    37.568     0.200
    16.830    37.503     0.200
    16.858    38.055     0.200
    16.957    37.339     0.200
    17.087    37.418     0.200
    17.095    38.121     0.200
    17.207    38.303     0.200
    17.234    37.615     0.200
    17.392    38.399     0.200
    18.361    39.671     0.200
    18.396    39.241     0.200
    18.404    38.897     0.200
    18.403    39.461     0.200
    19.116    41.096     0.200
     2.370    11.292     0.200
     2.759    10.629     0.200
     3.083     9.289     0.200
     3.041    13.401     0.200
     3.468    14.605     0.200
     3.539    14.920     0.200
     3.563    13.630     0.200
     3.562    12.959     0.200
     3.632    14.756     0.200
     3.641    15.562     0.200
     3.810    15.885     0.200
     3.795    14.945     0.200
     3.986    15.983     0.200
     4.016    14.479     0.200
     4.207    13.911     0.200
     4.422    16.502     0.200
     4.443    15.840     0.200
     4.448    16.758     0.200
     4.451    16.100     0.200
     4.459    16.424     0.200
     4.477    16.951     0.200
     4.511    15.495     0.200
     4.513    15.972     0.200
     4.548    16.588     0.200
     4.631    15.752     0.200
     4.631    16.322     0.200
     4.749    18.801     0.200
     4.879    15.982     0.200
     5.198    17.099     0.200
     5.228    16.372     0.200
     5.317    17.579     0.200
     5.616    18.724     0.200
     5.883    18.614     0.200
     6.134    19.859     0.200
     6.248    18.373     0.200
     6.322    18.631     0.200
     1.602     7.610     0.200
     2.556    10.413     0.200
     2.686    12.072     0.200
     2.841    13.180     0.200
     3.027    12.709     0.200
     3.345    13.685     0.200
     3.417    13.234     0.200
     3.496    14.698     0.200
     3.972    12.722     0.200
     4.181    16.086     0.200
     4.359    16.466     0.200
     4.992    17.029     0.200
     5.074    18.235     0.200
     5.148    17.703     0.200
     5.780    18.828     0.200
    11.466    33.527     0.200
    11.466    30.962     0.200
    12.501    33.331     0.200
    13.915    33.950     0.200
    14.144    34.807     0.200
    14.449    36.538     0.200
    15.247    36.170     0.200
    15.541    36.850     0.200
    15.899    37.174     0.200
    16.318    37.408     0.200
    17.400    39.577     0.200
    17.696    39.984     0.200
    18.001    39.255     0.200
    18.353    39.036     0.200
    18.885    39.650     0.200
    19.082    41.783     0.200
    19.661    40.888     0.200
    19.730    39.484     0.200
    20.109    40.814     0.200
    20.938    39.454     0.200
     1.712     8.849     0.200
     1.811    10.053     0.200
     2.082     9.648     0.200
     2.555    13.458     0.200
     2.710    13.496     0.200
     3.083    14.084     0.200
     3.511    15.954     0.200
     3.634    15.802     0.200
     3.674    14.548     0.200
     3.950    18.461     0.200
     4.202    15.382     0.200
     4.354    16.367     0.200
     4.377    18.398     0.200
     4.381    15.584     0.200
     4.384    19.015     0.200
     4.429    19.776     0.200
     4.381    18.904     0.200
     4.390    20.924     0.200
     4.631    17.200     0.200
     4.838    17.600     0.200
     5.158    18.622     0.200
     5.594    21.055     0.200
     5.836    21.657     0.200
    10.935    30.813     0.200
     1.497     8.959     0.200
     1.700     6.810     0.200
     1.828     8.191     0.200
     2.198    10.830     0.200
     2.237    12.104     0.200
     2.237    11.752     0.200
     2.621    10.164     0.200
     2.976    12.178     0.200
     3.063    11.481     0.200
     3.334    12.435     0.200
     3.424    14.845     0.200
     3.397    13.025     0.200
     3.422    14.070     0.200
     3.525    12.079     0.200
     3.490    13.938     0.200
     3.667    13.863     0.200
     3.775    15.267     0.200
     3.731    14.280     0.200
     3.844    13.794     0.200
     3.857    14.972     0.200
     3.857    13.641     0.200
     3.861    16.587     0.200
     3.874    14.718     0.200
     3.864    12.141     0.200
     3.880    13.367     0.200
     3.883    16.670     0.200
     3.889    16.592     0.200
     3.901    15.125     0.200
     4.092    13.227     0.200
     4.280    14.972     0.200
     4.301    14.558     0.200
     4.306    15.030     0.200
     4.309    14.994     0.200
     4.387    14.434     0.200
     4.380    15.843     0.200
     4.338    16.609     0.200
     4.357    13.786     0.200
     4.493    17.251     0.200
     4.493    14.462     0.200
     4.493    13.094     0.200
     4.493    17.571     0.200
     4.633    14.722     0.200
     4.745    15.592     0.200
     5.064    16.551     0.200
     5.113    15.407     0.200
     5.188    16.392     0.200
     5.457    16.386     0.200
     5.490    18.013     0.200
     5.483    19.587     0.200
     5.746    18.916     0.200
     5.786    18.850     0.200
     6.066    20.808     0.200
     6.132    17.995     0.200
     6.021    19.209     0.200
     6.193    18.375     0.200
     6.193    18.378     0.200
     7.055    25.001     0.200
     7.403    22.222     0.200
     7.747    23.925     0.200
     7.926    22.202     0.200
     7.926    22.803     0.200
     8.589    22.625     0.200
     8.931    25.636     0.200
     8.931    23.328     0.200
     9.652    23.938     0.200
     9.800    26.260     0.200
    10.665    26.942     0.200
    10.560    25.223     0.200
    11.015    27.086     0.200
    11.014    30.219     0.200
    11.020    34.803     0.200
    11.656    27.986     0.200
    11.915    28.100     0.200
    12.049    29.263     0.200
    12.510    30.016     0.200
    12.567    30.627     0.200
    12.585    30.074     0.200
    12.713    30.534     0.200
    12.874    31.619     0.200
    13.004    31.232     0.200
    13.051    30.930     0.200
    13.361    31.740     0.200
    13.373    30.951     0.200
    13.472    31.305     0.200
    13.517    36.987     0.200
    13.517    32.647     0.200
    13.672    32.093     0.200
    13.689    32.930     0.200
    13.692    32.294     0.200
    13.789    32.294     0.200
    13.815    32.424     0.200
    14.013    32.744     0.200
    14.138    29.947     0.200
    14.186    32.883     0.200
    14.573    32.754     0.200
    14.618    34.055     0.200
    14.794    33.867     0.200
    14.803    35.137     0.200
    15.098    34.565     0.200
    15.167    34.346     0.200
    15.199    34.586     0.200
    15.219    34.457     0.200
    15.438    34.494     0.200
    15.446    35.714     0.200
    15.457    34.604     0.200
    15.590    35.660     0.200
    15.627    35.883     0.200
    15.712    34.773     0.200
    15.880    35.240     0.200
    15.941    36.181     0.200
    15.971    35.118     0.200
    16.049    37.121     0.200
    16.082    34.806     0.200
    16.519    36.937     0.200
    16.546    37.351     0.200
    16.585    37.728     0.200
    16.601    36.561     0.200
    16.787    36.973     0.200
    16.837    38.921     0.200
    16.864    39.102     0.200
    16.907    37.027     0.200
    16.920    37.194     0.200
    16.949    37.960     0.200
    17.147    37.370     0.200
    17.276    37.968     0.200
    17.278    36.959     0.200
    17.546    37.400     0.200
    17.551    38.112     0.200
    17.693    37.277     0.200
    17.708    38.241     0.200
    17.930    37.812     0.200
    17.913    37.721     0.200
    17.965    38.002     0.200
    18.027    37.424     0.200
    18.029    37.179     0.200
    18.090    38.091     0.200
    18.177    37.159     0.200
    18.188    37.308     0.200
    19.289    38.723     0.200
    19.392    40.068     0.200
    19.392    40.101     0.200
     0.633     6.409     0.200
     0.966     6.921     0.200
     1.021     6.720     0.200
     1.101     7.603     0.200
     1.213     7.413     0.200
     1.669     7.869     0.200
     1.785     9.575     0.200
     1.785     9.696     0.200
     1.907     7.637     0.200
     2.258     8.281     0.200
     2.377    10.182     0.200
     2.496     9.649     0.200
     2.566    11.012     0.200
     2.697     9.505     0.200
     2.856    10.185     0.200
     2.919    10.789     0.200
     3.012    11.352     0.200
     3.031    12.670     0.200
     3.128    11.654     0.200
     3.158    12.451     0.200
     3.160    13.646     0.200
     3.307    13.033     0.200
     3.300    11.613     0.200
     3.436    12.490     0.200
     3.410    14.306     0.200
     3.461    13.064     0.200
     3.489    14.638     0.200
     3.504    12.516     0.200
     3.504    14.286     0.200
     3.507    13.864     0.200
     3.519    14.498     0.200
     3.528    16.664     0.200
     3.548    14.002     0.200
     3.558    13.731     0.200
     3.611    14.106     0.200
     3.640    14.838     0.200
     3.691    15.686     0.200
     3.713    12.121     0.200
     3.764    13.142     0.200
     3.843    14.773     0.200
     3.916    13.637     0.200
     3.916    13.632     0.200
     3.954    15.289     0.200
     3.971    15.263     0.200
     4.009    13.628     0.200
     3.984    14.832     0.200
     3.983    14.945     0.200
     3.984    15.115     0.200
     3.985    14.882     0.200
     3.987    14.867     0.200
     4.078    13.376     0.200
     4.078    13.165     0.200
     4.172    15.051     0.200
     4.192    15.167     0.200
     4.192    14.855     0.200
     4.154    14.561     0.200
     4.233    15.083     0.200
     4.516    15.434     0.200
     4.838    16.340     0.200
     5.018    15.877     0.200
     5.010    17.022     0.200
     5.032    16.633     0.200
     5.730    17.967     0.200
     6.009    19.561     0.200
     6.009    19.563     0.200
     6.035    18.806     0.200
     6.737    19.682     0.200
     7.033    20.564     0.200
     7.717    21.146     0.200
     7.717    22.419     0.200
     8.361    23.026     0.200
     8.628    25.376     0.200
     8.628    23.954     0.200
     8.628    25.145     0.200
     9.181    23.984     0.200
     9.430    22.036     0.200
    10.101    24.868     0.200
    10.637    26.599     0.200
    10.637    28.080     0.200
    10.637    28.555     0.200
    10.637    29.196     0.200
    10.643    29.433     0.200
    10.789    26.670     0.200
    11.118    28.857     0.200
    11.245    27.943     0.200
    11.669    29.478     0.200
    12.065    30.306     0.200
    12.198    30.413     0.200
    12.216    31.054     0.200
    12.897    31.438     0.200
    12.897    33.328     0.200
    13.171    33.182     0.200
    13.276    31.584     0.200
    13.803    32.299     0.200
    14.111    31.937     0.200
    16.394    34.382     0.200
    16.524    35.619     0.200
    19.125    36.143     0.200
    19.235    35.957     0.200
     1.679     7.111     0.200
     2.245    10.446     0.200
     2.321    11.192     0.200
     2.644    10.852     0.200
     2.947    10.494     0.200
     3.154    12.918     0.200
     3.345    12.313     0.200
     3.507    12.428     0.200
     3.450    12.570     0.200
     3.912    14.443     0.200
     4.072    12.686     0.200
     4.339    16.358     0.200
     4.385    13.965     0.200
     4.345    15.562     0.200
     4.359    16.749     0.200
     4.408    16.165     0.200
     4.604    17.114     0.200
     4.758    15.853     0.200
     5.093    16.226     0.200
     5.077    16.739     0.200
     5.189    16.254     0.200
     2.207    11.842     0.200
     2.446    13.446     0.200
     2.723    14.936     0.200
     2.948    15.613     0.200
     3.111    15.162     0.200
     3.221    15.178     0.200
     3.223    16.612     0.200
     3.315    14.966     0.200
     3.253    17.582     0.200
     3.279    16.724     0.200
     3.358    17.979     0.200
     3.382    18.273     0.200
     3.742    17.452     0.200
     3.717    18.899     0.200
     3.736    18.745     0.200
     3.749    16.686     0.200
     3.754    17.992     0.200
     3.769    17.979     0.200
     3.952    18.152     0.200
     4.272    18.174     0.200
     4.301    18.502     0.200
     4.383    18.276     0.200
     4.498    18.670     0.200
     4.818    19.389     0.200
     7.684    25.001     0.200
     9.772    32.466     0.200
     1.068     6.660     0.200
     1.503     7.110     0.200
     1.949    10.199     0.200
     1.939     7.205     0.200
     2.418    11.818     0.200
     2.287    10.275     0.200
     2.827    12.351     0.200
     3.211    14.171     0.200
     3.536    15.382     0.200
     3.758    15.903     0.200
     3.597    11.399     0.200
     4.031    15.027     0.200
     4.432    18.719     0.200
     4.458    18.747     0.200
     4.460    17.561     0.200
     4.462    17.621     0.200
     4.467    17.523     0.200
     4.590    16.932     0.200
     4.421    15.453     0.200
     5.402    18.496     0.200
     2.467    12.073     0.200
     3.059    14.827     0.200
     3.160    12.667     0.200
     3.261    13.853     0.200
     3.363    16.167     0.200
     3.324    13.987     0.200
     3.671    16.586     0.200
     4.447    18.645     0.200
     4.735    19.554     0.200
     4.768    18.471     0.200
     5.033    20.515     0.200
     5.352    17.732     0.200
     1.744     8.288     0.200
     2.154    11.112     0.200
     2.660    11.788     0.200
     3.015    12.491     0.200
     3.375    15.190     0.200
     3.462    15.539     0.200
     3.428    16.112     0.200
     3.568    14.097     0.200
     3.448    15.701     0.200
     3.699    14.901     0.200
     3.718    15.574     0.200
     3.873    11.798     0.200
     3.909    15.415     0.200
     4.135    14.815     0.200
     4.314    19.067     0.200
     4.341    16.109     0.200
     4.344    17.135     0.200
     4.386    19.951     0.200
     4.524    17.125     0.200
     1.672     7.069     0.200
     2.236    10.183     0.200
     2.616    10.751     0.200
     2.942    11.247     0.200
     3.023    11.977     0.200
     3.120    12.874     0.200
     3.323    11.859     0.200
     3.499    13.801     0.200
     3.879    16.680     0.200
     3.789    15.328     0.200
     4.285    17.221     0.200
     4.305    16.872     0.200
     4.311    15.743     0.200
     4.314    17.013     0.200
     4.366    14.232     0.200
     4.324    15.957     0.200
     4.361    17.357     0.200
     4.552    17.240     0.200
     4.735    15.842     0.200
     4.676    17.512     0.200
     5.086    16.117     0.200
     5.054    17.110     0.200
     5.172    17.557     0.200
     5.470    18.380     0.200
     5.739    18.524     0.200
     6.106    17.307     0.200
     6.177    17.119     0.200
     6.065    20.695     0.200
     7.113    24.239     0.200
     7.454    22.399     0.200
     1.468     9.333     0.200
     2.178    11.472     0.200
     2.421    13.676     0.200
     2.336    13.693     0.200
     2.395    12.973     0.200
     2.415    13.439     0.200
     3.088    16.360     0.200
     3.196    17.025     0.200
     3.287    15.286     0.200
     3.207    15.088     0.200
     3.345    14.809     0.200
     3.375    15.726     0.200
     3.333    13.868     0.200
     3.715    16.702     0.200
     4.247    19.252     0.200
     4.476    19.704     0.200
     4.702    20.230     0.200
     4.796    19.262     0.200
     5.066    19.944     0.200
     5.235    20.023     0.200
     5.376    21.867     0.200
     5.442    20.281     0.200
     1.647     9.536     0.200
     2.216    11.759     0.200
     2.458    13.370     0.200
     2.343    13.646     0.200
     2.961    15.200     0.200
     3.123    16.412     0.200
     3.233    15.531     0.200
     3.326    16.400     0.200
     3.178    15.671     0.200
     3.394    16.757     0.200
     3.332    14.009     0.200
     4.284    19.576     0.200
     4.395    20.040     0.200
     4.697    20.914     0.200
     5.051    20.087     0.200
     5.102    20.772     0.200
     5.408    22.136     0.200
     5.479    22.751     0.200
     2.505    12.461     0.200
     3.094    13.744     0.200
     3.172    13.221     0.200
     3.267    13.925     0.200
     3.341    15.116     0.200
     3.308    14.886     0.200
     3.497    16.039     0.200
     3.648    15.558     0.200
     4.149    15.384     0.200
     4.385    19.167     0.200
     4.738    16.608     0.200
     5.128    17.862     0.200
     1.407     9.909     0.200
     1.704    10.446     0.200
     2.117    12.216     0.200
     2.388    13.637     0.200
     2.360    13.895     0.200
     2.366    13.343     0.200
     2.438    12.268     0.200
     2.485    11.541     0.200
     2.704    16.596     0.200
     2.919    14.557     0.200
     2.982    18.021     0.200
     3.069    16.527     0.200
     3.066    15.946     0.200
     3.172    15.537     0.200
     3.172    13.606     0.200
     3.164    15.823     0.200
     3.236    14.955     0.200
     3.278    13.992     0.200
     3.278    14.362     0.200
     3.334    13.864     0.200
     3.339    18.965     0.200
     3.395    14.651     0.200
     3.694    17.882     0.200
     3.714    18.879     0.200
     3.725    17.510     0.200
     3.730    19.454     0.200
     3.743    17.969     0.200
     4.218    18.077     0.200
     4.218    16.316     0.200
     4.231    15.766     0.200
     4.394    16.357     0.200
     4.454    18.743     0.200
     4.775    18.763     0.200
     5.008    20.336     0.200
     5.038    20.637     0.200
     5.196    18.783     0.200
     5.361    21.474     0.200
     5.411    23.763     0.200
     5.411    21.607     0.200
     6.008    21.104     0.200
     6.100    20.063     0.200
     6.190    22.522     0.200
     6.622    23.132     0.200
     7.151    24.107     0.200
     7.645    25.583     0.200
     7.645    25.244     0.200
     7.964    25.701     0.200
     8.248    26.906     0.200
     9.869    30.661     0.200
     9.869    29.591     0.200
    13.829    37.967     0.200
    15.023    39.778     0.200
    15.701    40.196     0.200
    16.004    40.002     0.200
    17.418    41.427     0.200
    18.809    42.639     0.200
     2.774    11.523     0.200
     2.998    13.755     0.200
     3.487    12.223     0.200
     3.670    14.524     0.200
     3.759    15.271     0.200
     4.025    14.235     0.200
     4.236    12.974     0.200
     4.430    16.758     0.200
     4.452    16.865     0.200
     4.456    18.799     0.200
     4.459    15.966     0.200
     4.467    17.916     0.200
     4.472    14.901     0.200
     4.532    15.187     0.200
     4.510    15.357     0.200
     4.640    16.206     0.200
     4.728    18.109     0.200
     4.898    15.651     0.200
     4.898    16.423     0.200
     5.217    15.824     0.200
     5.217    16.594     0.200
     5.257    17.649     0.200
     5.339    16.759     0.200
     5.339    17.298     0.200
     5.899    18.257     0.200
     6.112    19.312     0.200
     2.401    10.654     0.200
     2.487    11.984     0.200
     2.473    11.455     0.200
     3.282    14.401     0.200
     3.124    15.010     0.200
     3.358    12.356     0.200
     3.291    13.851     0.200
     3.354    14.434     0.200
     4.178    15.871     0.200
     4.195    15.335     0.200
     4.413    17.065     0.200
     4.732    16.935     0.200
     4.733    18.847     0.200
     4.997    18.154     0.200
     1.478     9.135     0.200
     2.164    11.576     0.200
     2.415    12.322     0.200
     3.065    15.978     0.200
     3.174    13.743     0.200
     3.268    14.677     0.200
     3.212    16.109     0.200
     3.321    16.195     0.200
     3.353    14.458     0.200
     3.695    16.003     0.200
     3.676    18.741     0.200
     3.696    18.022     0.200
     3.708    18.849     0.200
     3.713    18.948     0.200
     3.728    18.779     0.200
     3.911    17.357     0.200
     4.253    18.202     0.200
     4.453    18.862     0.200
     4.453    19.122     0.200
     4.773    17.903     0.200
     5.043    20.897     0.200
     5.214    20.708     0.200
     5.352    20.931     0.200
     5.420    22.140     0.200
     6.205    20.261     0.200
     6.613    23.315     0.200
     7.640    25.854     0.200
     7.640    25.710     0.200
     8.239    26.738     0.200
     9.806    33.463     0.200
     1.492    10.213     0.200
     1.803     8.264     0.200
     2.089    11.611     0.200
     2.254    11.360     0.200
     2.254    13.372     0.200
     2.254    12.989     0.200
     2.558    13.125     0.200
     2.863    15.069     0.200
     2.959    12.964     0.200
     2.957    12.265     0.200
     3.075    11.575     0.200
     3.421    13.772     0.200
     3.449    17.099     0.200
     3.500    14.370     0.200
     3.552    17.187     0.200
     3.626    12.837     0.200
     3.669    15.486     0.200
     3.721    17.873     0.200
     3.828    16.181     0.200
     3.891    17.283     0.200
     3.909    18.895     0.200
     3.914    17.713     0.200
     3.918    14.475     0.200
     3.918    18.128     0.200
     3.940    15.622     0.200
     3.931    18.260     0.200
     3.957    17.286     0.200
     4.045    15.370     0.200
     4.102    17.267     0.200
     4.194    14.678     0.200
     4.182    14.270     0.200
     4.344    17.361     0.200
     4.367    17.418     0.200
     4.371    16.554     0.200
     4.373    17.426     0.200
     4.380    18.156     0.200
     4.371    18.025     0.200
     4.404    19.329     0.200
     4.470    16.392     0.200
     4.470    16.674     0.200
     4.481    16.722     0.200
     4.425    16.955     0.200
     4.425    15.526     0.200
     4.425    16.365     0.200
     4.425    17.436     0.200
     4.555    18.698     0.200
     4.622    15.073     0.200
     4.828    17.063     0.200
     5.149    18.339     0.200
     5.214    17.485     0.200
     5.280    18.754     0.200
     5.533    19.432     0.200
     5.585    19.360     0.200
     5.678    17.953     0.200
     5.826    18.333     0.200
     6.234    19.413     0.200
     6.284    20.335     0.200
     6.546    22.270     0.200
     7.057    21.738     0.200
     8.014    24.163     0.200
     8.147    27.710     0.200
     8.674    24.842     0.200
     9.613    24.807     0.200
     9.729    29.361     0.200
    10.403    27.043     0.200
    10.755    28.423     0.200
    10.932    31.613     0.200
    10.938    29.521     0.200
    11.583    31.054     0.200
    11.968    32.507     0.200
    12.452    31.278     0.200
    12.479    32.655     0.200
    12.505    32.156     0.200
    12.926    31.938     0.200
    12.968    33.380     0.200
    13.304    33.333     0.200
    13.417    32.987     0.200
    13.428    36.796     0.200
    13.428    33.996     0.200
    13.591    33.650     0.200
    13.617    32.690     0.200
    13.624    32.004     0.200
    13.684    34.528     0.200
    13.713    34.589     0.200
    13.742    33.476     0.200
    13.916    35.027     0.200
    14.083    37.878     0.200
    14.201    34.360     0.200
    14.201    34.821     0.200
    14.525    34.664     0.200
    14.557    34.920     0.200
    14.706    37.119     0.200
    14.723    35.457     0.200
    15.044    34.384     0.200
    15.128    34.763     0.200
    15.154    35.931     0.200
    15.377    37.186     0.200
    15.406    35.223     0.200
    15.428    35.404     0.200
    15.550    36.353     0.200
    15.830    34.945     0.200
    15.849    37.725     0.200
    15.876    38.026     0.200
    15.914    35.974     0.200
    15.955    38.271     0.200
    16.512    37.877     0.200
    16.773    40.877     0.200
    16.773    37.646     0.200
    16.777    38.749     0.200
    16.777    37.042     0.200
    16.844    37.762     0.200
    16.882    37.957     0.200
    17.223    36.474     0.200
    17.641    37.139     0.200
    17.639    43.386     0.200
    17.824    40.358     0.200
    17.862    36.855     0.200
    17.919    36.722     0.200
    17.973    37.519     0.200
    18.013    36.914     0.200
    18.135    37.286     0.200
     2.993    12.451     0.200
     3.268    12.751     0.200
     3.547    11.883     0.200
     3.526    16.051     0.200
     3.538    16.625     0.200
     3.549    14.478     0.200
     3.554    15.913     0.200
     3.568    13.466     0.200
     3.746    14.233     0.200
     3.856    14.862     0.200
     4.239    15.346     0.200
     4.353    15.227     0.200
     4.654    16.767     0.200
     4.930    16.433     0.200
     0.281     4.051     0.200
     0.719     4.966     0.200
     0.877     6.010     0.200
     0.980     6.122     0.200
     1.432     5.911     0.200
     1.900     8.233     0.200
     1.981     6.490     0.200
     2.338    12.172     0.200
     2.227    10.678     0.200
     2.733    10.290     0.200
     2.856    14.081     0.200
     3.252    12.600     0.200
     3.491    10.818     0.200
     3.546    15.642     0.200
     3.793    13.108     0.200
     4.014    15.458     0.200
     4.236    15.460     0.200
     4.371    13.166     0.200
     4.412    14.921     0.200
     4.440    14.592     0.200
     4.441    14.584     0.200
     4.442    15.905     0.200
     4.445    14.661     0.200
     4.603    16.078     0.200
     4.945    14.431     0.200
     5.267    15.929     0.200
     5.418    17.377     0.200
     5.932    16.204     0.200
     5.908    17.572     0.200
     6.400    17.204     0.200
     8.140    23.904     0.200
    10.725    30.121     0.200
     1.836     8.934     0.200
     2.053    10.574     0.200
     2.241    12.142     0.200
     2.241    11.142     0.200
     2.514    12.399     0.200
     2.894    10.667     0.200
     2.912    11.253     0.200
     3.107    11.513     0.200
     3.441    13.010     0.200
     3.452    15.571     0.200
     3.515    13.309     0.200
     3.656    12.844     0.200
     3.656    11.833     0.200
     3.559    16.977     0.200
     3.629    15.282     0.200
     3.725    15.708     0.200
     3.831    17.792     0.200
     3.891    16.424     0.200
     3.911    16.189     0.200
     3.919    16.760     0.200
     3.919    17.100     0.200
     3.922    16.442     0.200
     3.922    16.942     0.200
     3.949    15.402     0.200
     3.932    16.608     0.200
     3.939    16.529     0.200
     3.962    15.600     0.200
     4.050    15.905     0.200
     4.107    17.893     0.200
     4.225    14.026     0.200
     4.185    14.332     0.200
     4.352    16.954     0.200
     4.376    15.620     0.200
     4.379    15.763     0.200
     4.381    16.198     0.200
     4.386    16.873     0.200
     4.387    16.858     0.200
     4.364    17.395     0.200
     4.364    17.401     0.200
     4.493    14.850     0.200
     4.565    15.008     0.200
     4.598    17.528     0.200
     4.847    16.750     0.200
     5.168    16.350     0.200
     5.244    17.597     0.200
     5.547    18.326     0.200
     6.264    18.877     0.200
     6.308    21.116     0.200
     6.307    21.118     0.200
     6.551    21.771     0.200
     6.910    23.399     0.200
     7.075    19.250     0.200
     7.337    23.159     0.200
     7.662    25.117     0.200
     8.035    21.705     0.200
     8.694    22.822     0.200
    10.777    26.410     0.200
    11.923    34.013     0.200
    12.461    35.689     0.200
    14.209    33.673     0.200
    15.439    37.928     0.200
    16.727    35.868     0.200
    17.825    38.550     0.200
    18.332    40.681     0.200
    18.520    41.801     0.200
    18.694    40.975     0.200
    19.237    40.534     0.200
    19.237    39.102     0.200
    19.422    40.023     0.200
    20.502    41.714     0.200
     1.415     9.349     0.200
     2.158    12.103     0.200
     2.395    13.814     0.200
     2.459    13.058     0.200
     3.249    14.750     0.200
     3.279    16.284     0.200
     3.387    14.320     0.200
     3.371    14.886     0.200
     3.419    14.847     0.200
     3.713    18.646     0.200
     4.260    19.200     0.200
     4.274    16.798     0.200
     4.366    20.343     0.200
     4.494    17.823     0.200
     4.756    18.060     0.200
     4.815    19.031     0.200
     5.079    18.775     0.200
     5.239    19.020     0.200
     5.399    20.165     0.200
     5.453    21.816     0.200
     1.897     7.731     0.200
     2.940    10.921     0.200
     3.531    13.469     0.200
     3.567    15.532     0.200
     3.575    14.106     0.200
     3.615    13.065     0.200
     3.722    12.125     0.200
     3.839    16.337     0.200
     4.009    16.361     0.200
     4.057    13.475     0.200
     4.048    14.528     0.200
     4.163    17.217     0.200
     4.220    15.212     0.200
     4.289    13.008     0.200
     4.269    15.315     0.200
     4.461    18.613     0.200
     4.484    18.345     0.200
     4.488    18.068     0.200
     4.585    14.280     0.200
     4.578    15.598     0.200
     4.673    14.524     0.200
     4.940    15.833     0.200
     5.260    17.181     0.200
     5.310    15.686     0.200
     5.386    17.495     0.200
     5.688    19.211     0.200
     5.939    18.592     0.200
     1.620     9.359     0.200
     1.488     9.583     0.200
     2.124    12.141     0.200
     2.347    11.109     0.200
     2.435    13.762     0.200
     2.441    13.429     0.200
     2.854    15.155     0.200
     3.013    13.635     0.200
     3.122    16.562     0.200
     3.269    16.069     0.200
     3.299    16.557     0.200
     4.173    17.587     0.200
     4.203    17.966     0.200
     4.284    17.550     0.200
     4.720    16.977     0.200
     4.990    19.192     0.200
     5.300    20.102     0.200
     5.368    20.581     0.200
     1.348    10.192     0.200
     1.560     9.931     0.200
     2.192    11.980     0.200
     2.382    13.132     0.200
     2.861    14.881     0.200
     3.034    15.673     0.200
     3.276    16.554     0.200
     3.464    18.461     0.200
     3.693    17.301     0.200
     4.421    19.021     0.200
     1.808     9.007     0.200
     1.800    10.153     0.200
     2.700    12.161     0.200
     2.761    13.379     0.200
     3.102    14.126     0.200
     3.271    12.465     0.200
     3.543    14.224     0.200
     3.549    14.128     0.200
     3.670    14.886     0.200
     3.835    15.920     0.200
     3.915    14.845     0.200
     4.288    14.642     0.200
     4.350    16.284     0.200
     4.653    17.734     0.200
     4.646    15.935     0.200
     4.923    17.476     0.200
     4.953    14.090     0.200
     5.308    17.731     0.200
     5.301    16.079     0.200
     5.355    17.667     0.200
     5.704    20.517     0.200
     7.090    21.057     0.200
     7.090    21.409     0.200
    11.243    33.501     0.200
     1.390     6.578     0.200
     1.925     6.511     0.200
     2.180     9.975     0.200
     2.749    11.380     0.200
     2.766    11.780     0.200
     3.195    13.180     0.200
     3.486    13.524     0.200
     3.560    14.901     0.200
     3.735    13.423     0.200
     3.955    16.910     0.200
     4.382    17.342     0.200
     4.383    18.661     0.200
     4.543    16.156     0.200
     4.568    13.867     0.200
     4.499    17.760     0.200
     4.885    13.737     0.200
     5.207    16.005     0.200
     5.323    16.831     0.200
     5.358    16.589     0.200
     5.674    18.533     0.200
     5.872    17.588     0.200
     1.403     9.512     0.200
     1.592     9.778     0.200
     2.170    11.804     0.200
     2.336    13.391     0.200
     2.404    13.670     0.200
     2.353    13.599     0.200
     2.444    13.724     0.200
     2.468    12.194     0.200
     2.507    13.823     0.200
     2.807    13.589     0.200
     2.936    11.889     0.200
     2.983    15.781     0.200
     3.004    14.739     0.200
     3.040    12.089     0.200
     3.040    16.101     0.200
     3.077    15.183     0.200
     3.108    15.368     0.200
     3.119    13.864     0.200
     3.211    13.231     0.200
     3.154    13.758     0.200
     3.154    15.199     0.200
     3.196    13.558     0.200
     3.222    14.461     0.200
     3.228    16.033     0.200
     3.234    12.963     0.200
     3.243    14.455     0.200
     3.572    15.006     0.200
     3.591    15.453     0.200
     3.604    14.156     0.200
     3.610    13.929     0.200
     3.626    18.381     0.200
     3.654    16.995     0.200
     3.808    16.115     0.200
     4.153    14.707     0.200
     4.153    15.289     0.200
     4.209    17.664     0.200
     4.211    17.383     0.200
     4.272    17.751     0.200
     4.369    18.203     0.200
     4.569    17.822     0.200
     4.688    17.527     0.200
     4.898    18.977     0.200
     4.969    19.929     0.200
     5.160    19.998     0.200
     5.258    21.052     0.200
     5.273    16.551     0.200
     5.351    21.353     0.200
     5.930    21.781     0.200
     6.145    18.741     0.200
     6.085    22.932     0.200
     6.284    25.415     0.200
     6.520    21.225     0.200
     7.096    24.953     0.200
     7.551    23.846     0.200
     7.551    22.623     0.200
     7.895    24.466     0.200
     8.145    27.069     0.200
     8.174    23.512     0.200
     8.914    24.968     0.200
     9.757    30.179     0.200
     9.757    27.197     0.200
    10.309    28.083     0.200
    11.380    31.184     0.200
    18.758    44.361     0.200
    19.183    41.245     0.200
    19.878    41.386     0.200
     1.540    10.621     0.200
     1.570     9.984     0.200
     2.352    12.649     0.200
     2.363    12.896     0.200
     2.430    12.728     0.200
     2.423    13.902     0.200
     2.453    11.583     0.200
     2.481    13.104     0.200
     2.830    14.236     0.200
     2.961    11.853     0.200
     3.003    13.691     0.200
     3.029    12.182     0.200
     3.065    12.383     0.200
     3.144    14.676     0.200
     3.162    13.404     0.200
     3.162    14.267     0.200
     3.251    15.487     0.200
     3.434    13.414     0.200
     3.596    15.745     0.200
     3.613    17.763     0.200
     3.615    17.747     0.200
     3.634    15.004     0.200
     3.832    17.601     0.200
     4.171    16.924     0.200
     4.171    15.451     0.200
     4.238    16.329     0.200
     4.390    19.011     0.200
     4.592    17.938     0.200
     4.709    17.133     0.200
     5.175    17.711     0.200
     5.281    16.396     0.200
     5.368    19.372     0.200
     5.943    18.877     0.200
     6.161    22.563     0.200
     6.542    20.659     0.200
     7.572    24.515     0.200
     7.572    25.507     0.200
     8.167    23.493     0.200
     9.764    30.544     0.200
     9.764    26.726     0.200
    10.131    27.718     0.200
    10.320    27.830     0.200
    15.570    38.513     0.200
    15.835    38.382     0.200
    15.865    38.622     0.200
    16.254    37.870     0.200
    16.472    39.025     0.200
    16.590    38.957     0.200
    16.750    41.024     0.200
    16.923    40.581     0.200
    16.963    40.486     0.200
    17.068    40.584     0.200
    19.223    42.442     0.200
     1.535    10.934     0.200
     1.574    10.528     0.200
     2.173    13.136     0.200
     2.351    13.909     0.200
     2.359    13.606     0.200
     2.425    13.497     0.200
     2.454    13.342     0.200
     2.827    14.635     0.200
     3.001    16.343     0.200
     3.061    13.710     0.200
     3.123    16.739     0.200
     3.159    14.509     0.200
     3.159    13.521     0.200
     3.252    14.812     0.200
     3.593    17.799     0.200
     3.610    17.306     0.200
     3.612    17.290     0.200
     3.631    18.468     0.200
     3.646    18.286     0.200
     3.665    18.412     0.200
     3.829    16.206     0.200
     4.170    16.430     0.200
     4.170    18.489     0.200
     4.221    16.885     0.200
     4.287    18.418     0.200
     4.388    17.508     0.200
     4.588    19.020     0.200
     4.706    18.096     0.200
     4.918    16.384     0.200
     4.986    21.465     0.200
     5.278    20.124     0.200
     5.938    20.667     0.200
     7.570    24.694     0.200
     7.892    24.083     0.200
     8.011    25.116     0.200
     9.761    30.116     0.200
    14.075    37.868     0.200
    14.224    36.969     0.200
    14.721    37.196     0.200
    15.074    37.354     0.200
    15.241    37.878     0.200
    15.279    38.535     0.200
    15.348    39.490     0.200
    15.703    39.703     0.200
    16.083    40.878     0.200
    16.234    40.727     0.200
    16.250    40.866     0.200
    16.468    40.612     0.200
    16.746    41.122     0.200
    16.754    40.429     0.200
    18.338    40.927     0.200
    18.587    41.484     0.200
    18.749    45.736     0.200
    19.166    41.902     0.200
    19.202    42.341     0.200
     1.388     9.314     0.200
     1.528    10.432     0.200
     1.581     9.620     0.200
     2.174    11.900     0.200
     2.347    12.261     0.200
     2.431    14.911     0.200
     2.821    15.201     0.200
     2.996    13.070     0.200
     3.024    15.500     0.200
     3.119    13.805     0.200
     3.156    14.821     0.200
     3.209    17.417     0.200
     3.237    15.265     0.200
     4.701    15.961     0.200
     4.981    17.515     0.200
     5.363    19.645     0.200
     1.076     9.122     0.200
     1.385     7.776     0.200
     2.521    12.546     0.200
     2.641    10.480     0.200
     2.892    13.540     0.200
     3.165    11.923     0.200
     3.140    13.385     0.200
     3.381    15.183     0.200
     3.737    13.394     0.200
     3.850    11.957     0.200
     3.951    15.746     0.200
     3.997    17.000     0.200
     3.980    15.887     0.200
     4.201    15.119     0.200
     4.280    15.684     0.200
     7.486    23.813     0.200
     1.462     9.485     0.200
     2.141    11.994     0.200
     2.382    13.511     0.200
     2.373    13.919     0.200
     2.439    13.944     0.200
     2.398    13.345     0.200
     3.051    16.245     0.200
     3.247    16.876     0.200
     3.234    14.670     0.200
     3.310    16.399     0.200
     3.331    16.799     0.200
     3.352    16.440     0.200
     3.675    14.266     0.200
     4.234    17.790     0.200
     5.027    18.851     0.200
     5.340    21.082     0.200
     1.189     4.396     0.200
     2.166     8.805     0.200
     2.460     8.272     0.200
     2.703    11.037     0.200
     3.015     9.871     0.200
     3.886    13.950     0.200
     3.890    14.850     0.200
     3.869    16.905     0.200
     3.882    15.451     0.200
     3.892    15.518     0.200
     3.897    15.460     0.200
     4.069    17.878     0.200
     4.269    16.887     0.200
     4.586    14.941     0.200
     4.693    18.058     0.200
     4.529    18.040     0.200
     4.987    15.613     0.200
     5.279    18.953     0.200
     5.925    20.893     0.200
     1.403     9.363     0.200
     1.715    10.108     0.200
     2.151    12.166     0.200
     2.429    13.594     0.200
     3.274    16.083     0.200
     3.374    13.748     0.200
     3.709    17.862     0.200
     3.769    15.197     0.200
     3.782    16.910     0.200
     4.259    18.662     0.200
     4.270    15.104     0.200
     5.452    20.695     0.200
     1.365     8.247     0.200
     1.857     7.230     0.200
     1.775     8.384     0.200
     2.521    10.295     0.200
     2.521    11.585     0.200
     2.853    10.838     0.200
     3.118    10.477     0.200
     3.133    12.967     0.200
     3.246    14.530     0.200
     3.548    11.990     0.200
     3.684    12.484     0.200
     3.945    14.180     0.200
     4.127    16.234     0.200
     4.130    17.728     0.200
     4.130    13.258     0.200
     4.246    13.388     0.200
     4.573    15.472     0.200
     4.535    19.751     0.200
     4.582    14.850     0.200
     4.582    15.040     0.200
     4.560    19.049     0.200
     4.563    19.764     0.200
     4.618    16.670     0.200
     4.693    13.709     0.200
     4.693    16.029     0.200
     4.962    15.774     0.200
     4.909    17.087     0.200
     5.268    16.214     0.200
     5.383    16.446     0.200
     5.671    18.550     0.200
     5.692    16.186     0.200
     5.766    18.480     0.200
     5.819    16.660     0.200
     6.287    18.655     0.200
     6.322    19.064     0.200
     6.388    17.065     0.200
     7.190    19.869     0.200
     7.157    24.909     0.200
     7.659    22.480     0.200
     7.984    23.792     0.200
     8.130    21.388     0.200
     8.130    22.899     0.200
     8.206    25.538     0.200
     8.801    23.365     0.200
     9.043    26.593     0.200
     9.043    24.943     0.200
     9.981    28.377     0.200
    10.683    26.215     0.200
    11.056    30.267     0.200
    11.087    30.937     0.200
    11.178    30.451     0.200
    11.178    29.161     0.200
    11.179    28.336     0.200
    11.497    28.140     0.200
    11.845    30.155     0.200
    11.959    29.402     0.200
    12.162    29.757     0.200
    12.214    31.278     0.200
    12.301    30.948     0.200
    12.710    31.034     0.200
    12.730    30.729     0.200
    12.833    31.952     0.200
    12.915    31.425     0.200
    12.955    31.236     0.200
    13.178    32.871     0.200
    13.542    32.695     0.200
    13.549    31.918     0.200
    13.698    32.168     0.200
    14.811    35.120     0.200
    14.833    35.090     0.200
    14.910    35.702     0.200
    14.987    36.236     0.200
    15.081    35.651     0.200
    15.287    37.046     0.200
    15.325    36.237     0.200
    15.653    37.184     0.200
    15.804    35.805     0.200
    16.998    38.969     0.200
    19.403    41.417     0.200
     2.071    11.150     0.200
     2.526    13.252     0.200
     2.692    14.026     0.200
     2.919    11.793     0.200
     3.087    11.423     0.200
     3.635    14.444     0.200
     3.487    14.900     0.200
     3.620    15.814     0.200
     4.823    17.073     0.200
     5.223    18.669     0.200
     5.281    18.918     0.200
     5.818    19.885     0.200
     1.580     6.583     0.200
     2.215     9.297     0.200
     2.215     9.606     0.200
     2.215     9.097     0.200
     2.334     7.846     0.200
     2.620     7.899     0.200
     2.573     8.739     0.200
     3.137    11.269     0.200
     3.078    11.012     0.200
     3.144    11.371     0.200
     3.215    11.098     0.200
     3.267    13.904     0.200
     3.467    10.036     0.200
     3.389    12.266     0.200
     3.475    12.132     0.200
     3.700    10.588     0.200
     3.633    10.562     0.200
     3.667    14.326     0.200
     3.669    13.600     0.200
     3.669    11.810     0.200
     3.669    13.050     0.200
     3.677    12.696     0.200
     3.682    13.896     0.200
     3.826    15.836     0.200
     3.845    16.293     0.200
     3.936    13.176     0.200
     3.957    13.455     0.200
     3.982    13.347     0.200
     4.038    12.775     0.200
     4.045    13.494     0.200
     4.057    13.181     0.200
     4.068    12.650     0.200
     4.073    13.219     0.200
     4.190    13.318     0.200
     4.244    12.323     0.200
     4.225    15.264     0.200
     4.226    15.257     0.200
     4.426    13.337     0.200
     4.690    14.251     0.200
     4.837    14.909     0.200
     5.170    16.514     0.200
     5.441    16.070     0.200
     6.086    18.113     0.200
     6.270    17.884     0.200
     6.653    17.910     0.200
     7.431    21.320     0.200
     7.587    19.791     0.200
     7.587    19.564     0.200
     7.541    20.096     0.200
     8.684    23.704     0.200
     9.299    24.756     0.200
     9.299    21.626     0.200
     9.299    25.616     0.200
     9.299    27.436     0.200
     9.803    27.468     0.200
     9.920    28.900     0.200
    11.328    29.280     0.200
    11.328    29.878     0.200
    11.328    30.493     0.200
    11.328    30.953     0.200
    11.930    30.279     0.200
    12.360    32.065     0.200
    12.732    31.344     0.200
    12.903    31.235     0.200
    13.494    30.962     0.200
    13.681    32.104     0.200
    13.892    32.227     0.200
    15.410    35.349     0.200
    15.989    37.565     0.200
    17.064    35.787     0.200
    17.209    35.428     0.200
    17.209    36.324     0.200
     1.199     6.631     0.200
     1.280     6.377     0.200
     1.440     8.925     0.200
     1.523    10.522     0.200
     1.777     9.268     0.200
     2.329    12.192     0.200
     2.329    11.392     0.200
     2.329    11.812     0.200
     2.569    12.645     0.200
     2.789    10.738     0.200
     3.370    13.589     0.200
     3.626    13.664     0.200
     3.626    13.855     0.200
     3.790    18.364     0.200
     4.034    13.556     0.200
     3.993    14.218     0.200
     4.067    15.352     0.200
     4.099    14.881     0.200
     4.143    16.947     0.200
     4.157    15.641     0.200
     4.157    14.307     0.200
     4.186    15.116     0.200
     4.227    15.369     0.200
     4.259    16.929     0.200
     4.279    14.218     0.200
     4.288    16.848     0.200
     4.317    15.416     0.200
     4.344    14.154     0.200
     4.361    17.900     0.200
     4.407    17.870     0.200
     4.423    14.171     0.200
     4.453    15.654     0.200
     4.533    16.395     0.200
     4.643    16.608     0.200
     4.774    17.967     0.200
     4.806    16.537     0.200
     4.810    17.831     0.200
     4.821    16.471     0.200
     5.006    16.365     0.200
     5.105    17.002     0.200
     5.209    19.818     0.200
     5.282    16.890     0.200
     5.390    17.419     0.200
     5.484    18.635     0.200
     5.542    18.165     0.200
     6.032    21.590     0.200
     6.104    18.650     0.200
     6.075    21.447     0.200
     6.229    18.979     0.200
     6.384    22.252     0.200
     6.418    20.345     0.200
     6.498    21.423     0.200
     7.018    21.556     0.200
     7.018    21.558     0.200
     7.115    23.574     0.200
     8.101    24.777     0.200
     8.515    26.942     0.200
     8.629    27.624     0.200
     8.687    26.954     0.200
    10.655    31.806     0.200
    11.756    31.173     0.200
    11.778    32.814     0.200
    11.877    32.604     0.200
    15.629    37.956     0.200
    15.629    38.756     0.200
    15.630    38.938     0.200
    16.423    40.047     0.200
    16.946    38.964     0.200
     2.735    11.500     0.200
     2.944    11.521     0.200
     3.108    11.877     0.200
     3.456    14.442     0.200
     3.483    15.242     0.200
     3.536    15.359     0.200
     3.659    14.413     0.200
     3.587    16.391     0.200
     3.975    15.692     0.200
     4.227    13.733     0.200
     4.402    19.642     0.200
     4.516    18.630     0.200
     4.505    15.528     0.200
     4.429    19.757     0.200
     4.645    18.589     0.200
     4.864    16.471     0.200
     5.184    16.446     0.200
     5.315    20.378     0.200
     6.028    19.899     0.200
     0.300     4.052     0.200
     0.743     5.108     0.200
     1.006     6.205     0.200
     1.386     7.352     0.200
     1.938     7.145     0.200
     1.943     8.029     0.200
     2.179    11.263     0.200
     2.367    12.160     0.200
     2.757    11.271     0.200
     2.750    11.425     0.200
     2.818    11.296     0.200
     3.207     9.438     0.200
     3.441    14.717     0.200
     3.495    13.983     0.200
     3.465    15.025     0.200
     3.473    13.234     0.200
     3.565    15.226     0.200
     3.747    13.946     0.200
     3.716    16.644     0.200
     3.871    16.117     0.200
     3.915    16.695     0.200
     3.961    14.569     0.200
     4.048    16.762     0.200
     4.100    12.631     0.200
     4.317    12.996     0.200
     4.320    16.331     0.200
     4.359    14.592     0.200
     4.387    16.062     0.200
     4.388    16.384     0.200
     4.389    14.840     0.200
     4.381    17.350     0.200
     4.493    13.903     0.200
     4.576    18.029     0.200
     4.893    15.432     0.200
     5.368    17.318     0.200
     5.684    16.443     0.200
     5.880    17.433     0.200
     5.870    16.241     0.200
     1.714    10.419     0.200
     2.139    12.257     0.200
     2.416    13.750     0.200
     2.477    13.769     0.200
     2.411    13.002     0.200
     3.094    16.255     0.200
     3.192    16.494     0.200
     3.261    15.685     0.200
     3.267    14.232     0.200
     3.417    17.292     0.200
     3.696    17.346     0.200
     3.741    16.772     0.200
     4.246    19.127     0.200
     4.257    18.489     0.200
     4.482    19.882     0.200
     1.754    10.519     0.200
     1.852    10.256     0.200
     2.445    11.828     0.200
     2.518    13.548     0.200
     2.670    13.536     0.200
     3.097    13.698     0.200
     3.171    13.659     0.200
     3.537    18.008     0.200
     3.667    15.946     0.200
     3.939    18.809     0.200
     3.963    16.986     0.200
     4.044    17.922     0.200
     4.118    19.489     0.200
     4.280    20.036     0.200
     4.391    18.213     0.200
     4.655    18.821     0.200
     4.977    19.625     0.200
     5.162    20.036     0.200
     5.304    20.874     0.200
     5.497    21.432     0.200
     5.497    20.650     0.200
     5.623    21.657     0.200
     1.471     9.130     0.200
     2.201    12.533     0.200
     3.112    15.760     0.200
     3.192    15.319     0.200
     3.367    16.349     0.200
     3.741    18.335     0.200
     4.272    15.596     0.200
     4.383    17.840     0.200
     4.500    15.986     0.200
     4.704    18.277     0.200
     4.820    18.364     0.200
     5.090    19.202     0.200
     5.399    18.917     0.200
     6.055    21.896     0.200
     1.438     6.584     0.200
     2.082     8.386     0.200
     2.370    10.207     0.200
     2.451     9.504     0.200
     2.710    10.242     0.200
     2.887    13.503     0.200
     3.076    13.117     0.200
     2.909    11.651     0.200
     3.176    13.306     0.200
     3.261    11.095     0.200
     3.309    15.294     0.200
     3.246    12.996     0.200
     3.639    14.863     0.200
     3.829    13.421     0.200
     4.119    11.833     0.200
     4.155    15.493     0.200
     4.488    14.180     0.200
     4.540    17.827     0.200
     4.548    18.559     0.200
     4.807    16.599     0.200
     4.926    16.740     0.200
     5.226    17.868     0.200
     5.209    16.255     0.200
     5.493    17.145     0.200
     5.869    17.981     0.200
     5.931    16.302     0.200
     5.934    20.565     0.200
     7.363    21.600     0.200
     1.723     9.563     0.200
     2.048     9.807     0.200
     2.589    12.423     0.200
     2.533    12.916     0.200
     2.738    12.182     0.200
     2.797    13.967     0.200
     3.030    14.533     0.200
     3.159    12.900     0.200
     3.103    13.317     0.200
     3.443    15.006     0.200
     3.442    14.748     0.200
     3.459    16.391     0.200
     3.619    14.613     0.200
     3.820    15.075     0.200
     4.137    16.103     0.200
     4.247    15.903     0.200
     4.546    17.248     0.200
     4.831    16.418     0.200
     5.197    17.458     0.200
     5.252    20.995     0.200
     0.250     4.751     0.200
     0.736     4.967     0.200
     0.997     6.030     0.200
     1.460     7.038     0.200
     1.535     7.364     0.200
     1.980     6.593     0.200
     2.352    12.295     0.200
     2.820     9.873     0.200
     2.753     8.591     0.200
     3.540    11.928     0.200
     3.794    10.640     0.200
     4.030    15.449     0.200
     4.364    13.580     0.200
     4.395    15.508     0.200
     4.429    15.133     0.200
     4.459    17.290     0.200
     4.463    17.897     0.200
     4.611    16.797     0.200
     4.564    16.691     0.200
     5.277    14.428     0.200
     5.642    20.120     0.200
     5.944    19.381     0.200
     5.940    17.544     0.200
     6.402    18.521     0.200
     1.484     8.645     0.200
     1.950    10.574     0.200
     1.854     9.402     0.200
     2.169    10.016     0.200
     2.473    13.826     0.200
     2.731    13.398     0.200
     2.731    14.168     0.200
     2.731    13.178     0.200
     2.974    12.476     0.200
     3.154    13.274     0.200
     3.226    14.091     0.200
     3.428    14.903     0.200
     3.935    16.843     0.200
     4.003    18.017     0.200
     3.997    17.054     0.200
     4.206    19.188     0.200
     4.378    20.738     0.200
     4.397    20.062     0.200
     4.403    16.514     0.200
     4.415    20.731     0.200
     4.534    18.467     0.200
     4.558    16.657     0.200
     4.684    18.347     0.200
     4.684    19.387     0.200
     4.893    17.833     0.200
     5.058    16.832     0.200
     5.269    19.929     0.200
     5.588    19.486     0.200
     5.695    20.517     0.200
     6.433    21.046     0.200
     6.598    22.177     0.200
     7.028    23.293     0.200
     7.017    24.921     0.200
     7.360    21.687     0.200
     7.616    22.673     0.200
     7.938    27.664     0.200
     8.441    25.303     0.200
     8.911    28.064     0.200
     8.911    30.254     0.200
    11.107    31.392     0.200
    11.107    33.622     0.200
    11.107    31.630     0.200
    11.107    31.276     0.200
    11.809    33.197     0.200
    12.144    33.843     0.200
    12.612    34.472     0.200
    12.742    34.303     0.200
    12.897    34.997     0.200
    13.553    35.978     0.200
    13.720    36.315     0.200
    13.845    36.610     0.200
    14.679    36.761     0.200
    14.679    36.370     0.200
    14.679    36.531     0.200
    14.835    39.579     0.200
    14.954    38.236     0.200
    15.060    37.978     0.200
    15.469    39.965     0.200
    16.886    40.922     0.200
    16.886    40.108     0.200
    17.059    39.524     0.200
    19.174    43.933     0.200
    19.174    42.878     0.200
     1.033     6.484     0.200
     1.092     6.388     0.200
     1.325     7.080     0.200
     1.609     7.365     0.200
     1.750     8.054     0.200
     1.796     8.745     0.200
     1.973     9.451     0.200
     2.358    10.429     0.200
     2.429    11.000     0.200
     2.780    12.286     0.200
     2.896    10.674     0.200
     2.979    14.301     0.200
     3.249    13.288     0.200
     3.271    15.433     0.200
     3.351    15.161     0.200
     3.467    11.944     0.200
     3.728    15.864     0.200
     3.648    15.942     0.200
     3.862    17.690     0.200
     3.886    15.636     0.200
     4.092    15.265     0.200
     4.411    16.260     0.200
     4.484    15.091     0.200
     4.537    16.599     0.200
     4.537    16.534     0.200
     4.844    17.231     0.200
     5.096    15.724     0.200
     1.721     8.196     0.200
     1.952     8.452     0.200
     2.214     8.958     0.200
     2.817    13.443     0.200
     3.156    14.689     0.200
     3.146    13.226     0.200
     3.550    13.423     0.200
     3.584    16.690     0.200
     3.607    12.148     0.200
     4.114    14.127     0.200
     4.083    14.301     0.200
     4.105    17.679     0.200
     4.429    14.736     0.200
     4.432    17.294     0.200
     4.410    19.232     0.200
     4.455    18.950     0.200
     4.866    19.564     0.200
     0.307     4.994     0.200
     0.975     5.598     0.200
     1.094     6.391     0.200
     1.164     6.299     0.200
     1.155     6.632     0.200
     1.178     6.872     0.200
     1.207     7.177     0.200
     1.237     6.586     0.200
     1.266     7.627     0.200
     1.364     6.882     0.200
     1.360     7.470     0.200
     1.493     8.045     0.200
     1.708     7.107     0.200
     1.636     8.758     0.200
     1.808     6.972     0.200
     1.941     7.755     0.200
     2.116    10.114     0.200
     2.219     8.124     0.200
     2.174     9.053     0.200
     2.312     9.111     0.200
     2.570     9.885     0.200
     2.601    12.145     0.200
     2.838    11.028     0.200
     2.979    10.343     0.200
     2.970    10.461     0.200
     3.297    11.268     0.200
     3.368    12.801     0.200
     3.377    15.341     0.200
     3.523    10.517     0.200
     3.593    13.579     0.200
     3.665    12.793     0.200
     3.777    14.746     0.200
     3.802    13.532     0.200
     1.261     7.654     0.200
     0.581     7.117     0.200
     0.656     7.034     0.200
     0.868     6.877     0.200
     1.184     5.822     0.200
     1.358     6.844     0.200
     1.268     8.201     0.200
     1.448     7.868     0.200
     1.461     7.477     0.200
     1.472     8.044     0.200
     1.477     8.024     0.200
     1.565     7.357     0.200
     1.549     8.488     0.200
     1.619     7.856     0.200
     1.678     8.190     0.200
     1.800     8.007     0.200
     1.856     7.512     0.200
     1.830     9.200     0.200
     2.194     8.462     0.200
     2.135     9.231     0.200
     2.442     7.951     0.200
     2.521     9.455     0.200
     2.502    10.883     0.200
     2.597     9.733     0.200
     2.777     9.748     0.200
     2.817    11.109     0.200
     2.966    12.473     0.200
     2.974    12.880     0.200
     3.144    10.688     0.200
     3.182    11.183     0.200
     1.554     8.525     0.200
     1.754     8.009     0.200
     2.411    10.354     0.200
     2.735    11.670     0.200
     3.019    11.669     0.200
     3.148    13.937     0.200
     3.433    14.885     0.200
     3.582    14.014     0.200
     3.542    13.608     0.200
     1.398    10.221     0.200
     1.639     9.847     0.200
     2.285    12.688     0.200
     2.239    11.913     0.200
     2.406    14.135     0.200
     2.389    13.387     0.200
     2.505    13.899     0.200
     2.602    12.839     0.200
     2.712    12.935     0.200
     2.773    13.667     0.200
     2.839    14.062     0.200
     3.085    13.201     0.200
     3.159    14.075     0.200
     3.159    16.794     0.200
     3.254    14.475     0.200
     3.243    15.208     0.200
     3.307    16.428     0.200
     4.324    18.052     0.200
     5.016    19.031     0.200
     1.774     9.298     0.200
     1.768     9.668     0.200
     2.006     9.829     0.200
     2.125    10.576     0.200
     2.429    10.922     0.200
     2.531    12.933     0.200
     2.804    13.508     0.200
     3.035    13.682     0.200
     3.198    15.144     0.200
     3.277    14.766     0.200
     3.316    15.723     0.200
     3.562    16.827     0.200
     3.577    15.663     0.200
     3.722    16.328     0.200
     3.857    17.464     0.200
     4.134    14.640     0.200
     4.138    15.692     0.200
     4.152    16.810     0.200
     4.338    18.160     0.200
     4.289    19.138     0.200
     4.361    19.183     0.200
     4.670    16.436     0.200
     4.992    19.558     0.200
     5.147    18.487     0.200
     5.156    19.962     0.200
     1.096     8.868     0.200
     1.754     7.853     0.200
     1.804     8.785     0.200
     2.414     9.623     0.200
     2.717    11.870     0.200
     3.021    13.291     0.200
     3.118    13.670     0.200
     3.420    12.842     0.200
     3.582    14.970     0.200
     3.982    16.572     0.200
     4.427    13.594     0.200
     4.597    19.090     0.200
     4.833    14.674     0.200
     0.539     5.638     0.200
     0.760     6.303     0.200
     0.854     6.883     0.200
     0.902     7.100     0.200
     0.912     6.804     0.200
     0.923     7.454     0.200
     0.949     7.587     0.200
     0.989     7.555     0.200
     1.013     6.852     0.200
     1.056     7.293     0.200
     1.131     7.220     0.200
     1.188     7.548     0.200
     1.281     8.187     0.200
     1.341     7.736     0.200
     1.693     6.933     0.200
     1.811     7.932     0.200
     1.869     7.517     0.200
     1.989     8.354     0.200
     2.045     7.679     0.200
     2.101     8.247     0.200
     2.388     8.444     0.200
     2.521     9.146     0.200
     2.589     9.959     0.200
     2.693    10.141     0.200
     2.867    11.738     0.200
     3.126     9.927     0.200
     3.219    11.703     0.200
     3.297    10.617     0.200
     3.268    11.849     0.200
     3.342    11.835     0.200
     3.367    11.782     0.200
     3.358    12.796     0.200
     3.496    12.783     0.200
     3.608    13.360     0.200
     3.646    12.427     0.200
     3.758    13.863     0.200
     4.031    13.502     0.200
     4.077    13.654     0.200
     4.152    15.361     0.200
     4.151    15.452     0.200
     4.182    15.443     0.200
     4.184    15.600     0.200
     4.219    13.449     0.200
     4.405    14.873     0.200
     4.447    15.131     0.200
     4.727    15.561     0.200
     5.050    16.411     0.200
     5.230    15.832     0.200
     5.224    16.886     0.200
     5.388    17.530     0.200
     5.553    17.837     0.200
     5.618    17.630     0.200
     5.702    17.841     0.200
     6.223    19.570     0.200
     6.247    18.654     0.200
     0.986     7.711     0.200
     1.236     9.879     0.200
     1.278    10.162     0.200
     1.240     9.447     0.200
     1.768     9.154     0.200
     1.612     9.586     0.200
     1.272    10.372     0.200
     1.983    10.660     0.200
     2.109    11.393     0.200
     2.540    11.636     0.200
     2.667    10.312     0.200
     2.931    13.634     0.200
     3.569    14.523     0.200
     3.780    17.844     0.200
     3.936    15.581     0.200
     4.236    15.936     0.200
     4.250    15.969     0.200
     4.298    15.780     0.200
     4.363    16.344     0.200
     4.382    20.356     0.200
     4.452    17.113     0.200
     4.495    14.698     0.200
     4.526    16.633     0.200
     4.672    21.049     0.200
     4.723    17.637     0.200
     4.779    19.204     0.200
     4.830    18.742     0.200
     4.916    18.749     0.200
     4.982    18.720     0.200
     5.065    18.970     0.200
     5.061    17.698     0.200
     5.090    20.249     0.200
     5.118    15.349     0.200
     5.208    18.808     0.200
     5.349    18.742     0.200
     5.360    19.043     0.200
     5.702    18.984     0.200
     6.023    21.142     0.200
     6.082    21.158     0.200
     6.159    20.404     0.200
     6.393    21.136     0.200
     6.463    22.408     0.200
     6.588    23.260     0.200
     6.694    23.910     0.200
     7.101    23.220     0.200
     7.930    26.061     0.200
     8.116    24.209     0.200
     8.488    25.460     0.200
     8.892    25.963     0.200
     9.607    31.595     0.200
    10.484    29.590     0.200
    10.760    33.118     0.200
    10.760    32.380     0.200
    10.761    31.356     0.200
    12.228    32.584     0.200
    12.297    32.801     0.200
    12.354    29.984     0.200
    12.518    31.577     0.200
    12.626    32.201     0.200
    12.748    28.724     0.200
    12.785    30.844     0.200
    12.810    32.967     0.200
    13.083    31.863     0.200
    13.085    33.906     0.200
    13.161    33.226     0.200
    13.205    31.706     0.200
    13.347    33.207     0.200
    13.423    35.013     0.200
    13.511    33.573     0.200
    13.552    34.482     0.200
    13.592    32.902     0.200
    13.602    32.914     0.200
    13.622    34.996     0.200
    13.621    35.317     0.200
    14.593    37.632     0.200
    14.660    34.709     0.200
    14.680    35.534     0.200
    15.140    36.931     0.200
    15.338    36.810     0.200
    15.420    35.517     0.200
    15.555    38.286     0.200
    15.686    35.397     0.200
    16.428    37.838     0.200
    16.482    39.004     0.200
    16.483    38.176     0.200
    16.483    38.058     0.200
    16.593    39.649     0.200
    17.407    38.594     0.200
    10.884    27.531     0.200
    11.270    28.722     0.200
     7.658    26.428     0.200
     7.356    23.322     0.200
     3.015    11.777     0.200
     3.695    13.572     0.200
     3.722    13.823     0.200
     3.954    16.450     0.200
     4.105    15.377     0.200
     4.122    15.705     0.200
     4.441    15.692     0.200
     4.469    15.281     0.200
     4.564    16.709     0.200
     5.042    16.974     0.200
     5.189    17.296     0.200
     5.247    17.593     0.200
     5.484    17.846     0.200
     5.807    18.813     0.200
     6.011    19.230     0.200
     6.049    19.143     0.200
     2.146    12.035     0.200
     2.430    13.353     0.200
     2.715    13.407     0.200
     3.271    15.076     0.200
     1.683     9.146     0.200
     1.896     9.893     0.200
     2.022     8.979     0.200
     2.078     8.827     0.200
     1.560     8.595     0.200
     1.931     9.401     0.200
     2.733    10.607     0.200
     2.668    11.412     0.200
     3.066    12.260     0.200
     3.337    12.489     0.200
     2.917    13.457     0.200
     3.018    13.002     0.200
     3.766    13.765     0.200
     3.856    16.256     0.200
     3.872    14.973     0.200
     3.905    14.028     0.200
     3.948    16.608     0.200
     3.933    15.238     0.200
     4.241    17.682     0.200
     4.250    13.711     0.200
     4.301    14.917     0.200
     4.315    13.670     0.200
     4.330    15.769     0.200
     4.437    17.129     0.200
     4.456    16.291     0.200
     4.466    15.533     0.200
     4.737    18.666     0.200
     4.766    18.162     0.200
     4.802    17.039     0.200
     4.685    18.127     0.200
     5.013    18.010     0.200
     5.180    17.570     0.200
     5.055    20.757     0.200
     5.498    18.609     0.200
     5.488    17.953     0.200
     5.603    19.093     0.200
     8.350    21.380     0.200
    11.127    32.731     0.200
     1.435     9.351     0.200
     2.127    12.325     0.200
     2.382    13.714     0.200
     2.687    13.104     0.200
     1.524     8.327     0.200
     2.128    10.017     0.200
     2.142    10.315     0.200
     2.526    12.857     0.200
     2.789    13.936     0.200
     3.002    13.017     0.200
     3.030    14.155     0.200
     3.227    13.612     0.200
     3.191    15.023     0.200
     3.357    14.793     0.200
     3.862    16.834     0.200
     0.211     4.721     0.200
     0.842     5.275     0.200
     0.969     6.048     0.200
     1.000     6.109     0.200
     1.072     6.606     0.200
     1.103     6.419     0.200
     1.107     6.998     0.200
     1.118     7.196     0.200
     1.160     7.216     0.200
     1.231     6.352     0.200
     1.407     7.942     0.200
     1.443     7.031     0.200
     1.539     8.701     0.200
     1.602     8.218     0.200
     1.873     7.585     0.200
     2.221    10.562     0.200
     2.252     9.350     0.200
     2.536     9.295     0.200
     2.516    10.467     0.200
     2.733    10.224     0.200
     2.854     8.636     0.200
     2.913    12.892     0.200
     0.235     5.349     0.200
     0.752     5.152     0.200
     0.883     5.968     0.200
     0.911     6.408     0.200
     0.994     6.252     0.200
     1.013     6.318     0.200
     1.032     6.837     0.200
     1.040     6.978     0.200
     1.082     6.969     0.200
     1.247     6.076     0.200
     1.205     6.922     0.200
     1.277     7.384     0.200
     1.338     7.637     0.200
     1.464     8.426     0.200
     1.615     8.612     0.200
     1.968     7.433     0.200
     2.194     9.756     0.200
     2.257     9.621     0.200
     2.367    11.550     0.200
     2.630     9.187     0.200
     2.814    12.567     0.200
     3.548    14.322     0.200
     1.220     6.812     0.200
     1.740     8.736     0.200
     1.824     8.628     0.200
     2.403    11.174     0.200
     2.668    12.162     0.200
     3.406    13.301     0.200
     3.562    15.162     0.200
     3.626    16.228     0.200
     3.705    12.557     0.200
     3.705    16.432     0.200
     3.714    15.586     0.200
     3.806    13.548     0.200
     3.854    13.712     0.200
     4.041    15.497     0.200
     4.051    16.367     0.200
     4.132    14.637     0.200
     4.144    14.892     0.200
     4.177    14.188     0.200
     4.223    14.126     0.200
     4.227    14.831     0.200
     4.252    13.758     0.200
     4.281    14.654     0.200
     4.286    17.027     0.200
     4.294    14.035     0.200
     4.333    14.914     0.200
     4.310    15.692     0.200
     4.324    14.948     0.200
     4.331    14.320     0.200
     4.351    15.204     0.200
     4.388    15.388     0.200
     4.412    14.694     0.200
     4.464    15.713     0.200
     4.486    17.229     0.200
     4.518    16.436     0.200
     4.542    15.594     0.200
     4.548    15.687     0.200
     4.716    15.411     0.200
     4.834    19.834     0.200
     4.866    18.035     0.200
     5.121    16.728     0.200
     5.244    17.648     0.200
     5.528    18.244     0.200
     8.731    26.489     0.200
     9.922    26.973     0.200
     1.330     8.389     0.200
     1.848     9.585     0.200
     2.064    11.388     0.200
     2.576    11.563     0.200
     2.856    14.284     0.200
     3.284    15.775     0.200
     3.666    16.438     0.200
     3.686    16.451     0.200
     3.716    18.356     0.200
     2.526    10.532     0.200
     2.799    10.284     0.200
     3.335    12.133     0.200
     4.251    13.483     0.200
     4.687    16.816     0.200
     4.746    16.365     0.200
     4.949    16.567     0.200
     0.074     9.471     0.200
     0.121     9.280     0.200
     0.139     9.135     0.200
     0.205     8.547     0.200
     0.330     8.281     0.200
     0.334     8.007     0.200
     0.354     8.368     0.200
     0.386     8.221     0.200
     0.387     8.140     0.200
     0.532     6.910     0.200
     0.591     7.024     0.200
     0.697     6.783     0.200
     0.755     6.958     0.200
     0.919     6.618     0.200
     0.993     6.462     0.200
     1.243     7.136     0.200
     1.292     7.801     0.200
     1.380     8.152     0.200
     1.563     9.749     0.200
     1.578     7.891     0.200
     1.611     8.709     0.200
     1.668     6.708     0.200
     1.894     8.959     0.200
     1.973     8.826     0.200
     2.038    10.237     0.200
     2.434    11.907     0.200
     2.700     9.578     0.200
     2.761    11.598     0.200
     3.366    11.949     0.200
     3.957    13.558     0.200
    10.085    27.702     0.200
     0.592     6.719     0.200
     0.692     6.941     0.200
     0.901     7.015     0.200
     1.111     5.923     0.200
     1.381     6.782     0.200
     1.398     7.286     0.200
     1.334     8.047     0.200
     1.395     7.748     0.200
     1.421     8.007     0.200
     1.442     7.972     0.200
     1.451     7.756     0.200
     1.467     8.323     0.200
     1.498     8.126     0.200
     1.580     7.901     0.200
     1.619     7.711     0.200
     1.682     7.859     0.200
     1.759     7.933     0.200
     1.895     8.690     0.200
     1.981     8.079     0.200
     2.334     9.718     0.200
     2.376     9.594     0.200
     2.561     9.356     0.200
     2.659    10.532     0.200
     2.661    10.515     0.200
     2.714    11.878     0.200
     2.918    12.147     0.200
     3.041    11.796     0.200
     3.047    13.158     0.200
     3.611    11.991     0.200
     3.726    13.566     0.200
     3.787    13.575     0.200
     4.030    14.147     0.200
     4.353    14.919     0.200
     4.548    15.715     0.200
     4.607    14.474     0.200
     4.996    16.476     0.200
     5.617    16.950     0.200
     1.494     8.220     0.200
     1.614     7.271     0.200
     2.483     9.443     0.200
     2.442    11.483     0.200
     2.657    12.435     0.200
     2.811    12.191     0.200
     3.090    11.971     0.200
     3.077    13.469     0.200
     3.499    12.292     0.200
     3.604    12.134     0.200
     3.653    15.073     0.200
     4.510    17.684     0.200
     0.204    11.251     0.200
     1.050     8.345     0.200
     1.060     8.675     0.200
     1.079     8.430     0.200
     1.100     8.673     0.200
     1.113     8.816     0.200
     1.152     7.728     0.200
     1.136     8.596     0.200
     1.159     8.234     0.200
     1.152     8.164     0.200
     1.237     6.905     0.200
     1.297     7.874     0.200
     1.321     7.908     0.200
     1.334     8.178     0.200
     1.252     9.514     0.200
     1.861     8.088     0.200
     2.139     7.874     0.200
     2.444     8.493     0.200
     2.440     9.222     0.200
     2.527    10.538     0.200
     2.929    11.748     0.200
     3.005    10.612     0.200
     2.993    11.703     0.200
     3.456    12.653     0.200
     3.613    14.503     0.200
     3.645    11.587     0.200
     4.021    13.308     0.200
     4.055    14.436     0.200
     4.145    14.581     0.200
     1.539     9.938     0.200
     1.039     9.787     0.200
     1.359    10.137     0.200
     1.214     9.206     0.200
     2.153    12.536     0.200
     1.410    10.943     0.200
     2.697    13.315     0.200
     3.239    17.113     0.200
     0.674     7.286     0.200
     0.720     7.483     0.200
     0.932     8.324     0.200
     1.247     6.569     0.200
     1.241     5.507     0.200
     1.259     9.032     0.200
     1.570     7.599     0.200
     1.564     8.168     0.200
     1.589     8.556     0.200
     1.593     8.294     0.200
     1.611     8.529     0.200
     1.622     8.152     0.200
     1.635     8.818     0.200
     1.665     8.791     0.200
     1.742     7.206     0.200
     1.682     8.460     0.200
     1.737     8.625     0.200
     1.829     7.966     0.200
     1.791     8.250     0.200
     1.847     8.511     0.200
     1.918     8.766     0.200
     2.077     8.288     0.200
     2.175     8.707     0.200
     2.304     9.310     0.200
     2.403     9.271     0.200
     2.487    10.807     0.200
     2.493    11.087     0.200
     2.461    11.502     0.200
     2.446    10.275     0.200
     2.491    11.597     0.200
     2.561     9.654     0.200
     2.538    11.001     0.200
     2.547     8.198     0.200
     2.647    11.075     0.200
     2.753    11.603     0.200
     2.771    11.021     0.200
     2.814    11.494     0.200
     2.875    10.638     0.200
     2.829    12.005     0.200
     2.833    10.292     0.200
     2.843    11.652     0.200
     2.843    12.333     0.200
     2.844    13.167     0.200
     2.844    13.487     0.200
     2.854    12.630     0.200
     2.886     8.951     0.200
     2.927    11.592     0.200
     2.970    12.061     0.200
     3.039    10.567     0.200
     3.084    11.578     0.200
     3.285    14.163     0.200
     3.261    11.016     0.200
     3.263    12.746     0.200
     3.315    14.251     0.200
     3.318    14.130     0.200
     3.327    13.301     0.200
     3.445    12.120     0.200
     3.399    12.203     0.200
     3.399    13.123     0.200
     3.502    12.453     0.200
     3.554    13.770     0.200
     3.615    13.785     0.200
     3.620    12.564     0.200
     3.746    12.527     0.200
     3.859    14.436     0.200
     3.994    13.536     0.200
     3.960    14.260     0.200
     4.072    13.731     0.200
     4.182    15.339     0.200
     4.135    14.473     0.200
     4.376    15.842     0.200
     4.438    14.392     0.200
     4.513    15.910     0.200
     4.480    15.449     0.200
     4.510    15.027     0.200
     4.588    16.178     0.200
     4.559    15.566     0.200
     4.719    16.505     0.200
     4.828    16.783     0.200
     5.064    16.401     0.200
     5.143    16.950     0.200
     5.369    17.517     0.200
     5.447    16.907     0.200
     6.433    19.667     0.200
     6.640    19.996     0.200
     7.063    20.730     0.200
     7.063    21.046     0.200
     7.082    21.923     0.200
    10.682    29.403     0.200
    13.137    31.575     0.200
     0.476     4.198     0.200
     1.085     6.027     0.200
     1.115     5.846     0.200
     1.224     6.764     0.200
     1.266     6.744     0.200
     1.261     6.865     0.200
     1.266     7.043     0.200
     1.287     7.037     0.200
     1.294     7.319     0.200
     1.310     7.485     0.200
     1.334     7.675     0.200
     1.374     7.813     0.200
     1.376     6.870     0.200
     1.452     8.752     0.200
     1.444     7.574     0.200
     1.535     6.754     0.200
     1.575     7.736     0.200
     1.576     7.970     0.200
     1.769     7.449     0.200
     1.729     8.453     0.200
     1.982     7.095     0.200
     2.050     7.652     0.200
     1.985    10.082     0.200
     2.196     8.404     0.200
     2.179     4.820     0.200
     2.385     9.946     0.200
     2.346    10.902     0.200
     2.361     8.441     0.200
     2.442     9.185     0.200
     2.593    10.475     0.200
     2.739    10.540     0.200
     2.741    11.737     0.200
     2.805    10.000     0.200
     2.980    10.303     0.200
     3.111    11.083     0.200
     3.080    11.716     0.200
     3.218    12.002     0.200
     3.344    11.516     0.200
     3.589    11.975     0.200
     3.915    12.736     0.200
     4.028    16.499     0.200
     4.064    14.583     0.200
     4.078    14.360     0.200
     4.115    14.605     0.200
     4.183    14.326     0.200
     4.366    12.449     0.200
     4.402    15.457     0.200
     4.430    14.380     0.200
     4.516    15.275     0.200
     4.521    15.508     0.200
     4.837    15.924     0.200
     4.932    14.234     0.200
     4.977    16.915     0.200
     5.217    18.256     0.200
     5.257    14.883     0.200
     5.288    17.318     0.200
     1.374    10.246     0.200
     1.557    10.259     0.200
     2.159     9.915     0.200
     2.345    13.544     0.200
     2.700    13.477     0.200
     2.998    15.080     0.200
     2.389     9.586     0.200
     2.366    11.513     0.200
     2.409     9.496     0.200
     2.473     8.784     0.200
     2.473     9.014     0.200
     2.596     9.677     0.200
     2.675     9.459     0.200
     2.881     8.925     0.200
     3.049    11.989     0.200
     3.089    14.184     0.200
     3.107    12.422     0.200
     3.172    13.564     0.200
     3.162    11.521     0.200
     3.222    10.770     0.200
     3.225    11.661     0.200
     3.261    13.539     0.200
     3.291    11.830     0.200
     3.300    11.630     0.200
     3.295    11.494     0.200
     4.220    15.902     0.200
     4.441    16.909     0.200
     4.761    18.184     0.200
     1.415     9.316     0.200
     2.070    12.341     0.200
     2.146    11.791     0.200
     2.346    12.909     0.200
     2.416    12.681     0.200
     2.409    13.490     0.200
     3.092    14.461     0.200
     3.191    15.370     0.200
     3.265    16.561     0.200
     3.256    14.741     0.200
     0.853     6.284     0.200
     0.912     5.735     0.200
     1.012     4.934     0.200
     1.145     6.021     0.200
     1.423     6.250     0.200
     1.413     6.107     0.200
     1.574     7.212     0.200
     1.624     7.995     0.200
     1.738     7.749     0.200
     1.839     7.971     0.200
     1.882     8.786     0.200
     1.899     8.917     0.200
     1.892     8.310     0.200
     1.929     9.147     0.200
     1.968     9.325     0.200
     1.996     8.584     0.200
     1.920     9.013     0.200
     2.133     8.587     0.200
     2.168     7.090     0.200
     2.183     8.691     0.200
     2.571    12.143     0.200
     2.604     8.156     0.200
     2.703    11.695     0.200
     2.971     9.459     0.200
     3.033    10.465     0.200
     3.198    11.719     0.200
     3.301    11.090     0.200
     3.604    12.793     0.200
     3.844    12.635     0.200
     3.986    13.576     0.200
     4.303    14.359     0.200
     4.321    14.225     0.200
     4.406    15.800     0.200
     4.428    16.531     0.200
     4.701    15.789     0.200
     4.730    15.717     0.200
     4.728    18.446     0.200
     4.999    16.645     0.200
     0.298     4.156     0.200
     0.759     4.969     0.200
     0.882     5.924     0.200
     0.916     6.190     0.200
     0.957     6.246     0.200
     0.978     6.433     0.200
     0.981     6.649     0.200
     1.012     6.742     0.200
     1.022     6.085     0.200
     1.025     6.970     0.200
     1.067     7.002     0.200
     1.161     6.639     0.200
     1.176     6.633     0.200
     1.265     7.348     0.200
     1.310     7.725     0.200
     1.379     7.385     0.200
     1.531     8.896     0.200
     1.597     6.963     0.200
     1.920     7.506     0.200
     1.961    10.209     0.200
     2.153     9.274     0.200
     2.417    10.121     0.200
     2.581     9.182     0.200
     2.740    11.814     0.200
     2.765    10.573     0.200
     2.845    11.495     0.200
     0.062     5.537     0.200
     0.883     5.226     0.200
     1.131     6.642     0.200
     1.136     6.625     0.200
     1.148     6.983     0.200
     1.149     6.635     0.200
     1.193     7.181     0.200
     1.235     7.354     0.200
     1.414     6.609     0.200
     1.425     7.598     0.200
     1.504     8.219     0.200
     1.583     9.349     0.200
     1.627     7.366     0.200
     1.621     8.622     0.200
     1.784     8.851     0.200
     1.957     7.923     0.200
     1.955    10.001     0.200
     2.404    10.688     0.200
     2.468    11.149     0.200
     2.618     9.200     0.200
     2.644    11.985     0.200
     2.872    10.892     0.200
     3.227    13.156     0.200
     3.590    12.446     0.200
     3.673    14.774     0.200
     0.716     6.020     0.200
     0.780     6.066     0.200
     0.992     6.958     0.200
     1.174     5.363     0.200
     1.227     6.354     0.200
     1.336     7.869     0.200
     1.437     6.521     0.200
     1.539     7.263     0.200
     1.548     7.936     0.200
     1.575     8.177     0.200
     1.577     7.894     0.200
     1.594     8.030     0.200
     1.597     7.487     0.200
     7.103    20.713     0.200
    10.731    27.673     0.200
    11.772    29.536     0.200
     1.238     6.598     0.200
     1.886     8.252     0.200
     1.787     8.812     0.200
     2.012     9.960     0.200
     2.316     9.743     0.200
     2.490     9.779     0.200
     2.744    11.080     0.200
     2.810    12.158     0.200
     3.013    12.319     0.200
     3.585    12.289     0.200
     3.500    13.912     0.200
     1.223     7.643     0.200
     1.506     8.256     0.200
     1.649     8.937     0.200
     1.896     9.520     0.200
     1.854     8.750     0.200
     1.902     9.139     0.200
     2.041    11.673     0.200
     2.021    10.409     0.200
     2.258    10.567     0.200
     2.189    11.682     0.200
     2.433    11.989     0.200
     2.529    11.160     0.200
     2.724    12.342     0.200
     2.770    13.471     0.200
     2.893    12.140     0.200
     2.962    14.481     0.200
     2.989    14.083     0.200
     3.030    13.164     0.200
     3.142    16.719     0.200
     3.190    13.821     0.200
     3.205    15.985     0.200
     3.214    15.565     0.200
     3.224    14.321     0.200
     3.260    16.219     0.200
     3.257    18.018     0.200
     3.306    16.787     0.200
     3.347    15.920     0.200
     3.351    14.821     0.200
     3.382    16.339     0.200
     3.383    15.781     0.200
     3.399    18.136     0.200
     3.552    15.236     0.200
     3.642    15.073     0.200
     3.630    16.276     0.200
     3.641    15.677     0.200
     3.643    15.663     0.200
     3.751    16.477     0.200
     3.746    17.175     0.200
     3.802    15.020     0.200
     3.792    16.196     0.200
     3.793    16.189     0.200
     3.809    15.789     0.200
     4.012    17.508     0.200
     4.174    16.930     0.200
     4.331    16.753     0.200
     4.387    15.923     0.200
     4.336    17.087     0.200
     4.621    18.643     0.200
     4.752    17.797     0.200
     4.674    18.321     0.200
     5.020    18.402     0.200
     5.406    18.834     0.200
     5.454    18.483     0.200
     5.454    18.485     0.200
     7.189    22.280     0.200
     9.276    28.598     0.200
    11.209    30.328     0.200
    11.209    31.771     0.200
    11.209    32.224     0.200
    12.500    37.452     0.200
    13.435    36.336     0.200
    13.759    37.522     0.200
    14.022    34.850     0.200
    15.054    35.238     0.200
    16.442    36.705     0.200
    17.135    42.032     0.200
     0.969     6.021     0.200
     1.158     3.183     0.200
     1.289     7.045     0.200
     1.697     8.245     0.200
     1.806     8.520     0.200
     2.403    10.180     0.200
     1.281     7.464     0.200
     2.079     8.347     0.200
     2.613     9.845     0.200
     3.271    12.345     0.200
     3.342    14.527     0.200
     3.878    14.078     0.200
     1.505     7.565     0.200
     1.595     8.485     0.200
     1.859     8.953     0.200
     1.718     8.784     0.200
     2.025     9.447     0.200
     2.518     9.959     0.200
     2.830    12.367     0.200
     2.629    11.466     0.200
     2.802    12.457     0.200
     0.906     4.634     0.200
     0.937     5.769     0.200
     1.196     6.222     0.200
     1.183     6.686     0.200
     1.442     7.072     0.200
     1.526     7.203     0.200
     1.516     7.338     0.200
     1.544     7.447     0.200
     1.557     7.757     0.200
     1.554     8.364     0.200
     1.590     8.452     0.200
     1.715     7.069     0.200
     1.690     7.613     0.200
     1.656     8.791     0.200
     1.841     7.567     0.200
     1.767     8.711     0.200
     1.823     6.620     0.200
     1.938     8.269     0.200
     1.954     8.468     0.200
     2.369     7.888     0.200
     2.687    10.634     0.200
     2.726     8.761     0.200
     2.638    10.290     0.200
     2.751    11.212     0.200
     3.038    11.805     0.200
     3.192    12.368     0.200
     3.545    12.054     0.200
     0.362     4.798     0.200
     1.077     5.826     0.200
     1.194     6.528     0.200
     1.178     6.361     0.200
     1.231     6.771     0.200
     1.249     6.998     0.200
     1.273     7.188     0.200
     1.279     7.451     0.200
     1.301     7.528     0.200
     1.339     6.788     0.200
     1.320     7.707     0.200
     1.362     7.827     0.200
     1.448     7.739     0.200
     1.608     7.078     0.200
     1.581     8.128     0.200
     1.841     7.668     0.200
     1.727     8.575     0.200
     1.908     7.143     0.200
     2.118     7.941     0.200
     2.270     8.764     0.200
     2.096     9.995     0.200
     2.275     7.934     0.200
     2.514     9.130     0.200
     2.389    10.076     0.200
     2.491     9.788     0.200
     2.585    11.191     0.200
     2.632    12.261     0.200
     2.703    11.114     0.200
     2.814    10.780     0.200
     2.880    10.036     0.200
     2.853    10.940     0.200
     3.067    11.364     0.200
     3.167    11.626     0.200
     3.212    11.160     0.200
     3.292    11.774     0.200
     3.426    11.242     0.200
     3.343    12.757     0.200
     3.647    13.204     0.200
     3.648    12.939     0.200
     3.736    13.455     0.200
     3.995    12.152     0.200
     4.141    13.074     0.200
     4.170    14.708     0.200
     4.178    14.831     0.200
     4.262    14.195     0.200
     4.275    14.289     0.200
     4.194    15.004     0.200
     4.351    13.977     0.200
     4.419    14.860     0.200
     4.424    15.011     0.200
     4.483    15.321     0.200
     4.619    15.109     0.200
     4.610    14.827     0.200
     4.939    16.185     0.200
     5.014    15.635     0.200
     5.072    16.963     0.200
     5.397    16.569     0.200
     5.363    16.856     0.200
     5.439    16.842     0.200
     5.506    16.607     0.200
     5.926    12.386     0.200
     1.357     7.755     0.200
     1.472     8.621     0.200
     2.060     9.358     0.200
     2.343     9.575     0.200
     2.275    11.938     0.200
     2.643    11.552     0.200
     2.590    12.318     0.200
     2.685    12.935     0.200
     2.663    12.627     0.200
     2.729    12.495     0.200
     2.697    11.945     0.200
     2.876    11.899     0.200
     2.763    12.322     0.200
     2.757    13.955     0.200
     2.813    13.778     0.200
     2.940    13.233     0.200
     2.924    13.934     0.200
     3.083    11.666     0.200
     3.004    12.605     0.200
     3.126    14.329     0.200
     3.264    13.435     0.200
     3.356    13.101     0.200
     3.258    14.673     0.200
     3.388    15.166     0.200
     3.415    15.452     0.200
     3.477    16.114     0.200
     3.992    15.014     0.200
     4.118    14.971     0.200
     4.138    12.391     0.200
     4.178    18.561     0.200
     4.454    15.340     0.200
     4.438    15.903     0.200
     4.419    18.414     0.200
     4.702    17.208     0.200
     4.653    15.074     0.200
     5.027    17.363     0.200
     5.077    17.806     0.200
     5.097    19.145     0.200
     2.189     9.691     0.200
     2.475    10.347     0.200
     2.969    11.216     0.200
     3.031    13.820     0.200
     3.218    12.300     0.200
     3.262    12.718     0.200
     3.497    12.309     0.200
     3.674    13.976     0.200
     4.069    13.663     0.200
     4.613    15.146     0.200
     1.599     9.962     0.200
     2.374    12.219     0.200
     2.340    12.494     0.200
     2.502    13.420     0.200
     2.658    12.067     0.200
     2.960    13.808     0.200
     2.932    15.690     0.200
     2.943    14.231     0.200
     2.994    14.971     0.200
     2.975    15.189     0.200
     3.006    14.831     0.200
     3.047    15.091     0.200
     3.084    13.921     0.200
     3.119    16.292     0.200
     3.092    13.162     0.200
     3.099    14.412     0.200
     3.126    15.410     0.200
     3.125    14.101     0.200
     3.192    12.690     0.200
     3.256    16.267     0.200
     3.231    14.693     0.200
     3.141    15.788     0.200
     3.231    16.144     0.200
     3.191    15.830     0.200
     3.237    16.781     0.200
     3.413    15.401     0.200
     3.580    16.920     0.200
     3.598    16.489     0.200
     3.612    16.198     0.200
     3.667    15.986     0.200
     3.816    17.136     0.200
     4.164    15.931     0.200
     4.098    17.030     0.200
     4.221    17.223     0.200
     4.284    17.857     0.200
     4.210    19.380     0.200
     4.379    17.408     0.200
     4.553    18.030     0.200
     4.562    17.924     0.200
     4.698    17.331     0.200
     4.858    18.464     0.200
     4.906    18.119     0.200
     4.938    18.187     0.200
     4.980    18.671     0.200
     5.172    19.082     0.200
     5.267    16.628     0.200
     5.279    16.212     0.200
     5.362    19.363     0.200
     5.941    21.610     0.200
     5.914    20.570     0.200
     6.157    20.841     0.200
     6.071    23.723     0.200
     7.108    22.391     0.200
     7.560    25.863     0.200
     1.540     8.076     0.200
     2.216    11.838     0.200
     3.030    11.733     0.200
     3.483    14.288     0.200
     3.504    15.208     0.200
     3.862    13.916     0.200
     3.941    16.329     0.200
     3.952    14.797     0.200
     3.953    15.588     0.200
     3.955    16.638     0.200
     3.955    16.050     0.200
     3.958    17.793     0.200
     3.958    12.648     0.200
     3.970    12.577     0.200
     3.979    12.634     0.200
     3.988    12.520     0.200
     3.996    14.580     0.200
     3.999    17.241     0.200
     4.031    17.773     0.200
     4.038    15.311     0.200
     4.142    16.640     0.200
     4.216    16.712     0.200
     4.229    16.037     0.200
     4.357    14.619     0.200
     4.359    16.781     0.200
     4.432    17.613     0.200
     4.434    17.558     0.200
     4.522    17.348     0.200
     4.595    16.669     0.200
     4.595    16.467     0.200
     4.619    16.742     0.200
     4.936    17.215     0.200
     5.258    18.232     0.200
     5.374    17.375     0.200
     5.374    16.996     0.200
     5.453    16.352     0.200
     5.410    18.610     0.200
     5.618    19.873     0.200
     5.618    19.423     0.200
     5.726    19.352     0.200
     5.923    19.472     0.200
     5.898    20.004     0.200
     6.108    15.223     0.200
     6.393    19.952     0.200
     6.412    21.019     0.200
     6.730    23.360     0.200
     7.162    21.394     0.200
     7.224    23.181     0.200
     7.400    22.459     0.200
     7.532    24.907     0.200
     8.131    23.816     0.200
     8.431    24.500     0.200
     8.553    26.577     0.200
     8.610    27.216     0.200
     8.610    27.370     0.200
     8.798    26.049     0.200
     8.783    24.288     0.200
     9.408    28.957     0.200
     9.461    26.655     0.200
     9.846    28.289     0.200
    10.032    29.322     0.200
    10.222    29.739     0.200
    10.214    28.968     0.200
    10.340    29.471     0.200
    10.604    30.757     0.200
    10.720    31.588     0.200
    10.720    31.828     0.200
    10.719    30.070     0.200
    10.719    31.124     0.200
    10.877    30.586     0.200
    10.877    31.428     0.200
    10.952    31.424     0.200
    11.048    31.785     0.200
    11.119    31.232     0.200
    11.395    32.694     0.200
    11.464    28.934     0.200
    11.464    29.403     0.200
    11.925    33.473     0.200
    11.993    33.037     0.200
    11.993    32.906     0.200
    12.541    34.426     0.200
    13.059    35.861     0.200
    12.967    32.943     0.200
    13.201    33.036     0.200
    13.201    32.536     0.200
    14.253    33.729     0.200
    14.253    32.594     0.200
    14.253    31.571     0.200
    16.592    36.594     0.200
     7.224    22.870     0.200
     2.215    11.053     0.200
     3.947    15.992     0.200
     4.246    15.567     0.200
     4.580    16.131     0.200
     8.117    23.621     0.200
     9.472    24.084     0.200
    10.225    26.870     0.200
    10.237    26.098     0.200
    10.354    25.676     0.200
    10.618    26.983     0.200
    10.738    31.265     0.200
    10.739    31.553     0.200
    10.862    29.345     0.200
    10.965    28.360     0.200
    11.060    29.488     0.200
    11.774    28.818     0.200
    12.197    31.375     0.200
    12.564    31.438     0.200
    12.696    32.003     0.200
    12.740    33.267     0.200
    13.038    35.837     0.200
    13.047    33.826     0.200
    13.107    35.438     0.200
    13.102    32.999     0.200
    13.228    33.804     0.200
    13.211    33.798     0.200
    13.211    33.158     0.200
    13.253    34.270     0.200
    13.343    35.935     0.200
    13.398    36.167     0.200
    13.433    35.406     0.200
    13.490    34.550     0.200
    13.525    34.737     0.200
    13.555    34.159     0.200
    13.601    35.048     0.200
    13.737    34.521     0.200
    14.243    36.034     0.200
    14.371    35.314     0.200
    14.540    35.768     0.200
    14.582    35.987     0.200
    14.881    34.916     0.200
    15.197    35.455     0.200
    15.360    36.268     0.200
     2.264    10.368     0.200
     3.994    13.659     0.200
     4.275    15.024     0.200
     4.404    15.067     0.200
     4.574    16.018     0.200
     4.617    15.471     0.200
     4.638    15.670     0.200
     4.653    15.853     0.200
     4.962    16.238     0.200
     5.283    17.168     0.200
     5.430    17.546     0.200
     5.505    18.168     0.200
     5.645    17.971     0.200
     5.649    18.131     0.200
     5.744    17.981     0.200
     5.950    18.462     0.200
     5.951    18.579     0.200
     6.217    19.018     0.200
     6.406    19.422     0.200
     8.155    21.816     0.200
     9.512    24.891     0.200
    10.270    28.300     0.200
    10.390    26.417     0.200
    10.653    28.041     0.200
    10.760    28.972     0.200
    10.760    26.097     0.200
    10.761    27.338     0.200
    10.900    28.286     0.200
    11.768    29.131     0.200
    12.314    27.115     0.200
    12.235    27.163     0.200
    12.336    28.282     0.200
    12.720    29.556     0.200
    12.765    29.347     0.200
    12.747    28.085     0.200
    12.914    27.525     0.200
    13.062    29.007     0.200
    13.129    29.621     0.200
    13.253    33.390     0.200
    13.328    27.425     0.200
    13.883    30.857     0.200
    14.290    31.553     0.200
     1.510     8.369     0.200
     2.360    11.071     0.200
     3.619    13.274     0.200
     3.985    14.056     0.200
     4.065    13.383     0.200
     4.077    13.940     0.200
     4.077    14.453     0.200
     4.084    13.093     0.200
     4.093    13.110     0.200
     4.102    16.135     0.200
     4.113    15.686     0.200
     4.161    15.287     0.200
     4.263    14.190     0.200
     4.339    16.012     0.200
     4.358    15.818     0.200
     4.404    15.688     0.200
     4.497    15.647     0.200
     4.674    15.764     0.200
     4.671    16.976     0.200
     4.730    14.838     0.200
     5.023    15.885     0.200
     5.344    15.263     0.200
     5.423    15.890     0.200
     5.483    17.628     0.200
     5.602    17.394     0.200
     5.733    18.193     0.200
     6.050    18.542     0.200
     6.443    19.869     0.200
     6.487    20.699     0.200
     7.251    20.812     0.200
     9.607    26.044     0.200
    10.358    28.008     0.200
    10.831    30.371     0.200
    10.831    30.840     0.200
    10.831    31.026     0.200
    12.361    34.203     0.200
     7.373    20.767     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.542    16.351     0.200
     2.950    26.625     0.200
     3.145    21.255     0.200
     3.649    23.329     0.200
     6.522    45.368     0.200
     2.887    22.251     0.200
     3.305    28.508     0.200
     2.872    19.249     0.200
    10.183    71.964     0.200
     3.166    20.680     0.200
     2.857    19.653     0.200
     2.637    17.719     0.200
     2.948    20.570     0.200
     2.980    20.556     0.200
     3.310    22.940     0.200
     3.544    23.510     0.200
     3.477    24.626     0.200
     4.544    31.062     0.200
     2.955    19.632     0.200
     4.080    26.544     0.200
     3.846    25.842     0.200
     3.938    26.090     0.200
     3.561    23.592     0.200
     3.430    23.229     0.200
     2.999    20.524     0.200
     2.929    21.625     0.200
     2.996    19.940     0.200
     3.641    23.817     0.200
     3.628    24.448     0.200
     2.876    19.222     0.200
     2.622    19.689     0.200
     3.000    20.224     0.200
     3.651    23.767     0.200
     3.046    19.922     0.200
     3.023    23.074     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     4.111    19.243     0.200
     4.121    20.627     0.200
     0.731     5.864     0.200
     0.085     4.518     0.200
     3.768    18.905     0.200
     3.342    16.642     0.200
     1.220     8.481     0.200
     2.480    12.777     0.200
     1.271     8.689     0.200
     4.004    19.795     0.200
     4.489    24.889     0.200
     1.744    11.366     0.200
     4.454    21.412     0.200
     6.360    34.026     0.200
     2.050    11.224     0.200
     3.358    17.137     0.200
     3.459    16.574     0.200
     3.566    16.818     0.200
     1.198     7.930     0.200
     2.965    16.353     0.200
     3.016    17.365     0.200
     5.675    30.535     0.200
     3.864    19.457     0.200
     3.980    18.771     0.200
     3.907    19.820     0.200
     4.029    19.603     0.200
     1.846    11.105     0.200
     2.034    11.907     0.200
     2.100    11.920     0.200
     3.354    16.495     0.200
     3.876    19.134     0.200
     4.266    22.076     0.200
     2.851    14.781     0.200
     3.333    15.912     0.200
     3.526    16.486     0.200
     3.526    18.597     0.200
     2.027    12.934     0.200
     3.330    17.712     0.200
     3.366    19.553     0.200
     3.783    18.682     0.200
     0.929     7.107     0.200
     3.025    18.194     0.200
     3.233    17.372     0.200
     3.408    17.223     0.200
     0.559     5.088     0.200
     2.828    17.056     0.200
     0.820     6.182     0.200
     1.287     9.047     0.200
     4.357    20.619     0.200
     2.311    12.421     0.200
     2.390    12.983     0.200
     3.808    18.030     0.200
     3.969    19.801     0.200
     3.997    21.037     0.200
     0.674     5.669     0.200
     2.682    16.158     0.200
     3.953    19.231     0.200
     0.226     3.628     0.200
     4.242    20.416     0.200
     4.440    24.628     0.200
     2.720    16.439     0.200
     2.905    18.088     0.200
     4.354    20.314     0.200
     0.489     4.176     0.200
     2.697    17.597     0.200
     3.235    18.636     0.200
     3.735    19.626     0.200
     0.837     6.260     0.200
     1.174     8.077     0.200
     0.961     7.333     0.200
     1.149     8.731     0.200
     0.753     5.769     0.200
     1.167     7.994     0.200
     1.843     9.944     0.200
     3.186    15.694     0.200
     0.483     4.021     0.200
     0.434     4.109     0.200
     0.926     6.314     0.200
     4.358    22.884     0.200
     0.452     4.079     0.200
     2.234    13.181     0.200
     3.135    20.402     0.200
     0.211     2.912     0.200
     0.923     6.211     0.200
     1.140     8.124     0.200
     3.856    19.351     0.200
     4.510    23.054     0.200
     4.817    25.899     0.200
     0.942     6.742     0.200
     5.129    26.093     0.200
     0.733     5.598     0.200
     1.368     9.068     0.200
     1.818    11.260     0.200
     0.081     2.880     0.200
     0.701     5.349     0.200
     1.021     7.422     0.200
     1.888    11.860     0.200
     1.999    12.376     0.200
     2.122    12.745     0.200
     0.950     6.416     0.200
     0.966     6.685     0.200
     2.907    14.101     0.200
     0.442     5.004     0.200
     1.038     7.047     0.200
     1.218     8.486     0.200
     1.245     7.548     0.200
     3.171    17.307     0.200
     0.089     2.827     0.200
     0.954     6.620     0.200
     1.051     6.684     0.200
     1.563     9.735     0.200
     1.966    11.610     0.200
     2.901    15.643     0.200
     3.640    19.073     0.200
     4.565    24.676     0.200
     0.282     2.427     0.200
     0.282     2.167     0.200
     0.559     3.867     0.200
     0.559     4.227     0.200
     0.655     4.639     0.200
     0.655     5.099     0.200
     0.730     5.079     0.200
     0.957     7.074     0.200
     2.025    12.073     0.200
     2.294    12.705     0.200
     3.326    19.394     0.200
     3.973    20.273     0.200
     4.653    26.547     0.200
     6.337    34.686     0.200
     0.612     5.062     0.200
     0.880     5.962     0.200
     0.582     5.305     0.200
     1.342     8.628     0.200
     1.422     8.508     0.200
     1.394     8.440     0.200
     1.495    10.301     0.200
     1.535     9.244     0.200
     1.529    10.343     0.200
     1.530    10.093     0.200
     1.545    10.389     0.200
     2.051    12.132     0.200
     3.180    17.498     0.200
     3.250    20.290     0.200
     3.421    19.474     0.200
     0.108     2.855     0.200
     0.824     5.384     0.200
     0.901     6.372     0.200
     0.997     6.385     0.200
     1.058     7.470     0.200
     1.597     9.978     0.200
     2.369    15.394     0.200
     3.160    19.337     0.200
     3.670    18.498     0.200
     3.815    19.603     0.200
     4.182    21.491     0.200
     0.081     3.308     0.200
     0.876     5.991     0.200
     0.949     6.464     0.200
     1.049     6.638     0.200
     1.107     7.370     0.200
     1.214     8.254     0.200
     1.225     8.294     0.200
     1.257     8.410     0.200
     1.558     9.741     0.200
     2.900    15.838     0.200
     3.173    17.247     0.200
     3.763    23.174     0.200
     3.792    21.283     0.200
     4.015    20.109     0.200
     4.426    24.818     0.200
     0.045     4.904     0.200
     0.904     6.658     0.200
     1.029     6.654     0.200
     1.157     8.165     0.200
     1.166     8.363     0.200
     1.195     8.450     0.200
     1.211     7.613     0.200
     0.564     4.711     0.200
     1.798    10.559     0.200
     1.799    10.547     0.200
     2.274    12.688     0.200
     2.515    14.350     0.200
     2.841    16.955     0.200
     2.841    16.384     0.200
     3.037    17.903     0.200
     3.037    17.554     0.200
     3.272    17.076     0.200
     3.316    18.212     0.200
     3.466    17.512     0.200
     3.579    17.589     0.200
     0.636     4.576     0.200
     0.915     6.875     0.200
     1.145     7.680     0.200
     1.512     9.611     0.200
     1.640    10.081     0.200
     1.643    10.985     0.200
     1.644    11.028     0.200
     1.651     9.716     0.200
     1.667     9.811     0.200
     1.674    11.253     0.200
     1.690    11.305     0.200
     1.722    11.303     0.200
     1.742    10.568     0.200
     2.423    12.506     0.200
     2.736    14.903     0.200
     2.783    15.147     0.200
     1.029     8.768     0.200
     1.074     9.215     0.200
     1.078     9.202     0.200
     1.097     9.111     0.200
     1.120     9.462     0.200
     1.130     9.359     0.200
     2.709    16.510     0.200
     3.778    21.306     0.200
     3.787    21.738     0.200
     3.911    22.885     0.200
     4.010    22.956     0.200
     4.052    21.918     0.200
     4.691    26.350     0.200
     0.937     6.829     0.200
     1.101     7.537     0.200
     1.507     9.544     0.200
     1.627    10.286     0.200
     1.644    11.245     0.200
     1.630    10.114     0.200
     1.630    10.708     0.200
     1.660    10.248     0.200
     1.677    11.494     0.200
     1.741    10.421     0.200
     1.678     9.514     0.200
     3.692    23.201     0.200
     4.168    22.806     0.200
     0.055     3.464     0.200
     0.958     6.036     0.200
     1.000     6.812     0.200
     1.158     7.538     0.200
     1.253     8.473     0.200
     1.262     8.461     0.200
     1.291     8.541     0.200
     1.307     8.649     0.200
     1.311     8.665     0.200
     0.032     3.384     0.200
     0.922     5.999     0.200
     0.950     6.987     0.200
     1.077     6.940     0.200
     1.200     8.722     0.200
     1.209     8.654     0.200
     1.237     8.739     0.200
     1.254     8.966     0.200
     1.258     8.866     0.200
     1.622     9.569     0.200
     2.318    15.322     0.200
     2.378    13.996     0.200
     3.611    18.205     0.200
     0.825     6.975     0.200
     0.849     6.492     0.200
     0.837     6.893     0.200
     0.847     7.149     0.200
     0.858     7.485     0.200
     0.879     7.406     0.200
     0.992     7.368     0.200
     0.934     7.495     0.200
     1.168     8.198     0.200
     2.156    17.814     0.200
     2.703    16.789     0.200
     2.854    18.069     0.200
     2.854    16.839     0.200
     2.872    17.568     0.200
     3.322    17.243     0.200
     3.344    17.466     0.200
     3.421    18.734     0.200
     3.423    18.152     0.200
     3.575    17.997     0.200
     3.789    21.586     0.200
     0.075     3.091     0.200
     3.046    15.528     0.200
     3.036    17.279     0.200
     3.507    18.099     0.200
     3.640    20.814     0.200
     3.958    20.935     0.200
     4.047    21.458     0.200
     4.181    22.158     0.200
     4.230    24.646     0.200
     4.291    21.970     0.200
     0.062     5.624     0.200
     0.057     5.362     0.200
     0.070     5.304     0.200
     0.087     5.392     0.200
     0.103     4.934     0.200
     0.308     4.087     0.200
     0.241     3.769     0.200
     0.301     3.563     0.200
     0.676     4.891     0.200
     1.178     8.197     0.200
     1.139     6.957     0.200
     1.197     8.235     0.200
     1.223     9.669     0.200
     1.413     8.541     0.200
     1.539     9.651     0.200
     1.956    10.961     0.200
     2.451    13.422     0.200
     2.424    15.568     0.200
     3.420    16.598     0.200
     3.861    18.043     0.200
     0.130     3.909     0.200
     1.034     6.589     0.200
     1.063     7.127     0.200
     1.319     8.213     0.200
     1.310     9.017     0.200
     1.318     9.054     0.200
     1.345     9.134     0.200
     1.363     9.259     0.200
     1.367     9.012     0.200
     1.765    10.737     0.200
     1.796    11.482     0.200
     2.137    12.553     0.200
     2.757    15.257     0.200
     3.563    18.682     0.200
     0.787     5.968     0.200
     0.781     6.294     0.200
     1.153     7.050     0.200
     2.209    14.219     0.200
     2.785    17.000     0.200
     3.022    16.480     0.200
     3.103    18.885     0.200
     3.386    18.336     0.200
     3.430    18.876     0.200
     3.481    18.882     0.200
     3.525    19.371     0.200
     3.555    19.685     0.200
     3.603    21.421     0.200
     3.613    21.222     0.200
     0.015     3.756     0.200
     0.916     6.255     0.200
     0.959     6.500     0.200
     1.215     8.517     0.200
     1.224     8.480     0.200
     1.213     7.561     0.200
     1.254     8.444     0.200
     1.270     8.779     0.200
     1.273     8.738     0.200
     1.645     9.215     0.200
     2.017    10.991     0.200
     3.652    17.602     0.200
     0.078     3.812     0.200
     1.023     6.849     0.200
     1.276     8.623     0.200
     1.285     8.550     0.200
     1.277     7.933     0.200
     1.314     8.763     0.200
     1.330     8.931     0.200
     1.334     8.875     0.200
     1.706    10.292     0.200
     2.079    11.138     0.200
     3.125    18.175     0.200
     4.519    24.081     0.200
     0.124     1.262     0.200
     0.306     2.325     0.200
     0.409     2.973     0.200
     0.458     3.312     0.200
     0.587     4.814     0.200
     0.606     5.114     0.200
     0.636     5.092     0.200
     0.647     5.295     0.200
     0.651     5.410     0.200
     0.815     6.026     0.200
     0.874     5.206     0.200
     1.776    11.701     0.200
     2.106    12.214     0.200
     2.197    12.548     0.200
     2.605    16.863     0.200
     2.646    15.916     0.200
     3.334    16.988     0.200
     4.972    24.303     0.200
     0.055     3.026     0.200
     0.851     5.313     0.200
     0.901     6.359     0.200
     1.161     8.547     0.200
     1.153     7.533     0.200
     1.202     8.604     0.200
     1.217     8.820     0.200
     1.219     8.678     0.200
     2.298    13.965     0.200
     2.352    15.973     0.200
     2.439    12.637     0.200
     4.115    20.354     0.200
     4.381    21.311     0.200
     0.729     5.447     0.200
     0.814     5.827     0.200
     1.401     8.850     0.200
     1.764    10.837     0.200
     1.766    10.918     0.200
     1.782    10.920     0.200
     1.807    11.110     0.200
     1.818    10.982     0.200
     2.254    13.531     0.200
     2.178    11.363     0.200
     2.178    11.781     0.200
     2.568    14.659     0.200
     3.070    17.020     0.200
     3.329    18.190     0.200
     3.438    17.965     0.200
     3.457    17.861     0.200
     3.565    20.190     0.200
     3.613    17.152     0.200
     3.689    21.183     0.200
     0.552     4.979     0.200
     1.082     7.187     0.200
     1.227     7.766     0.200
     1.238     8.316     0.200
     1.238     8.521     0.200
     1.276     9.155     0.200
     1.289     9.117     0.200
     1.338     8.386     0.200
     1.882    10.115     0.200
     1.983    11.125     0.200
     2.343    12.846     0.200
     2.540    14.806     0.200
     3.017    18.004     0.200
     0.671     5.355     0.200
     0.752     5.484     0.200
     0.806     6.301     0.200
     0.863     6.465     0.200
     0.865     6.673     0.200
     1.685    10.447     0.200
     2.446    13.634     0.200
     2.517    13.782     0.200
     2.505    13.703     0.200
     0.090     1.165     0.200
     0.534     4.517     0.200
     0.726     6.202     0.200
     0.747     6.121     0.200
     0.767     6.230     0.200
     0.920     6.684     0.200
     1.091     7.316     0.200
     1.975    12.310     0.200
     0.487     3.734     0.200
     0.889     6.052     0.200
     1.094     8.056     0.200
     1.026     7.438     0.200
     1.483     9.490     0.200
     1.878    11.124     0.200
     1.943    11.869     0.200
     1.944    12.021     0.200
     1.980    12.126     0.200
     1.994    12.133     0.200
     2.040    11.872     0.200
     1.982    11.820     0.200
     2.265    15.953     0.200
     2.632    14.624     0.200
     2.720    13.579     0.200
     3.000    16.249     0.200
     3.136    18.790     0.200
     3.638    18.611     0.200
     3.638    18.960     0.200
     3.673    17.540     0.200
     0.635     5.127     0.200
     1.205     8.975     0.200
     1.239     9.185     0.200
     1.254     9.861     0.200
     1.788    12.855     0.200
     2.971    17.223     0.200
     5.116    26.699     0.200
     0.789     6.009     0.200
     1.126     8.008     0.200
     1.502     9.964     0.200
     1.532     9.947     0.200
     1.547     9.938     0.200
     1.614     9.610     0.200
     1.765    10.057     0.200
     2.630    13.563     0.200
     3.164    15.559     0.200
     3.303    16.263     0.200
     3.259    19.715     0.200
     3.347    17.602     0.200
     3.578    18.761     0.200
     3.723    18.571     0.200
     3.723    19.360     0.200
     0.121     2.610     0.200
     0.791     5.231     0.200
     1.108     7.317     0.200
     1.185     8.713     0.200
     1.184     8.759     0.200
     1.607    10.426     0.200
     2.876    17.066     0.200
     0.126     2.914     0.200
     0.829     5.251     0.200
     1.074     7.567     0.200
     1.162     7.388     0.200
     1.188     8.289     0.200
     1.245     8.543     0.200
     1.246     8.560     0.200
     1.748    10.308     0.200
     2.344    14.481     0.200
     2.390    15.015     0.200
     3.188    18.526     0.200
     3.740    19.958     0.200
     4.114    19.430     0.200
     4.202    20.987     0.200
     4.204    20.228     0.200
     0.426     3.710     0.200
     0.659     5.298     0.200
     0.884     6.275     0.200
     1.014     7.599     0.200
     1.065     7.661     0.200
     1.074     7.861     0.200
     2.397    13.064     0.200
     3.995    24.269     0.200
     4.620    22.675     0.200
     0.462     4.757     0.200
     2.888    17.276     0.200
     2.914    14.931     0.200
     3.092    15.027     0.200
     3.208    19.572     0.200
     3.217    15.863     0.200
     3.518    17.776     0.200
     3.690    21.132     0.200
     3.754    19.089     0.200
     1.015     7.352     0.200
     1.147     8.879     0.200
     1.217     9.990     0.200
     1.250     9.358     0.200
     1.223    10.071     0.200
     2.133    12.712     0.200
     2.250    16.105     0.200
     2.669    15.685     0.200
     3.003    18.803     0.200
     3.387    19.541     0.200
     3.471    20.808     0.200
     3.585    22.298     0.200
     3.752    19.866     0.200
     3.915    20.286     0.200
     4.347    23.063     0.200
     0.515     4.529     0.200
     0.559     5.235     0.200
     0.569     5.025     0.200
     0.613     4.683     0.200
     0.645     4.595     0.200
     0.733     5.779     0.200
     2.084    14.116     0.200
     0.743     5.714     0.200
     1.386     9.859     0.200
     2.029    11.679     0.200
     2.024    12.143     0.200
     2.055    12.208     0.200
     2.071    12.013     0.200
     2.874    16.918     0.200
     2.916    15.700     0.200
     2.995    16.630     0.200
     3.087    16.370     0.200
     3.090    16.162     0.200
     3.161    16.428     0.200
     0.439     4.062     0.200
     1.139     7.129     0.200
     1.166     8.658     0.200
     1.167     8.632     0.200
     1.207     8.967     0.200
     1.219     8.818     0.200
     1.249     8.324     0.200
     1.233     9.028     0.200
     1.982    11.923     0.200
     3.294    16.215     0.200
     0.250     2.261     0.200
     1.066     7.798     0.200
     1.193     9.398     0.200
     1.197     9.755     0.200
     1.210     9.492     0.200
     1.221     9.851     0.200
     1.348     9.367     0.200
     1.435    10.327     0.200
     1.659    11.015     0.200
     2.510    15.975     0.200
     2.853    15.424     0.200
     2.988    16.496     0.200
     0.499     4.185     0.200
     0.933     6.148     0.200
     0.993     6.978     0.200
     1.827    11.045     0.200
     1.906    10.405     0.200
     1.871    11.602     0.200
     1.872    11.627     0.200
     1.907    12.045     0.200
     1.922    11.726     0.200
     1.974    11.631     0.200
     1.914    11.611     0.200
     2.716    14.070     0.200
     3.622    19.689     0.200
     3.632    18.164     0.200
     0.260     2.921     0.200
     1.067     8.344     0.200
     1.189     8.191     0.200
     1.214     8.027     0.200
     1.430     8.912     0.200
     1.591    10.109     0.200
     1.513     9.346     0.200
     1.578    10.497     0.200
     1.662     9.911     0.200
     2.036    12.200     0.200
     2.184    12.317     0.200
     2.233    13.565     0.200
     2.546    14.238     0.200
     2.890    15.189     0.200
     2.897    15.700     0.200
     3.007    15.981     0.200
     3.117    15.121     0.200
     3.221    16.481     0.200
     3.378    17.110     0.200
     3.535    17.173     0.200
     3.536    18.205     0.200
     0.057     3.144     0.200
     1.949    12.113     0.200
     2.272    14.411     0.200
     3.220    17.606     0.200
     3.485    19.079     0.200
     0.052     3.081     0.200
     0.855     5.635     0.200
     1.063     7.523     0.200
     1.157     7.434     0.200
     1.220     8.514     0.200
     2.439    13.642     0.200
     0.507     4.226     0.200
     1.007     6.787     0.200
     0.256     2.567     0.200
     1.083     8.391     0.200
     1.196     9.992     0.200
     1.339    10.382     0.200
     1.428    10.541     0.200
     1.638    11.460     0.200
     2.262    14.128     0.200
     2.549    15.913     0.200
     2.728    16.501     0.200
     2.869    16.112     0.200
     2.967    17.110     0.200
     3.143    18.192     0.200
     3.243    19.956     0.200
     3.056    17.062     0.200
     3.322    19.321     0.200
     0.127     2.477     0.200
     1.185     8.891     0.200
     1.885    10.574     0.200
     2.422    13.292     0.200
     2.837    16.170     0.200
     0.122     3.649     0.200
     1.224     7.881     0.200
     1.320     8.175     0.200
     1.371     8.982     0.200
     1.748    10.811     0.200
     2.120    13.005     0.200
     2.431    14.020     0.200
     2.651    13.955     0.200
     2.792    15.100     0.200
     3.072    15.351     0.200
     3.086    16.044     0.200
     3.598    18.261     0.200
     4.464    21.406     0.200
     4.489    21.658     0.200
     4.496    21.488     0.200
     4.533    24.981     0.200
     2.213    11.610     0.200
     2.585    13.665     0.200
     3.853    19.049     0.200
     3.982    19.346     0.200
     4.248    23.467     0.200
     4.275    20.042     0.200
     0.071     3.806     0.200
     1.145     7.371     0.200
     1.237     7.779     0.200
     1.305     8.498     0.200
     0.277     4.321     0.200
     0.874     6.324     0.200
     1.527     8.703     0.200
     1.893     9.892     0.200
     2.334    12.778     0.200
     3.043    16.860     0.200
     3.972    18.185     0.200
     3.975    18.405     0.200
     0.245     2.373     0.200
     1.041     7.887     0.200
     1.236     9.917     0.200
     1.370    10.165     0.200
     1.454    10.584     0.200
     2.291    13.846     0.200
     2.504    16.570     0.200
     2.539    15.088     0.200
     2.568    14.965     0.200
     2.724    17.718     0.200
     2.781    18.401     0.200
     0.188     3.291     0.200
     0.942     8.434     0.200
     1.329     9.162     0.200
     1.470     9.427     0.200
     1.552     9.691     0.200
     2.061    11.037     0.200
     2.177    13.131     0.200
     2.415    14.152     0.200
     2.389    13.251     0.200
     2.662    14.336     0.200
     0.690     5.708     0.200
     2.974    16.722     0.200
     0.802     5.370     0.200
     1.045     7.527     0.200
     1.539    10.592     0.200
     1.437     8.813     0.200
     1.655     9.964     0.200
     1.889    10.943     0.200
     2.668    15.211     0.200
     2.974    14.516     0.200
     0.482     4.551     0.200
     0.973     6.729     0.200
     1.123     8.597     0.200
     1.807    11.476     0.200
     1.831    11.744     0.200
     1.919    11.435     0.200
     2.572    15.987     0.200
     2.835    15.408     0.200
     2.940    16.539     0.200
     3.264    15.721     0.200
     3.514    20.383     0.200
     3.545    18.587     0.200
     0.195     1.615     0.200
     0.995     7.761     0.200
     1.284    10.097     0.200
     1.417    11.001     0.200
     1.541    11.679     0.200
     1.502    10.601     0.200
     2.338    14.167     0.200
     2.589    17.025     0.200
     2.617    15.837     0.200
     2.922    16.541     0.200
     3.466    18.231     0.200
     0.183     1.756     0.200
     1.004     7.614     0.200
     1.289     9.844     0.200
     1.501    10.616     0.200
     1.584    11.476     0.200
     2.311    15.951     0.200
     2.336    14.334     0.200
     2.620    15.980     0.200
     2.727    16.724     0.200
     2.819    17.207     0.200
     0.662     5.204     0.200
     0.969     7.190     0.200
     1.153     6.888     0.200
     1.031     9.150     0.200
     1.650    10.598     0.200
     1.611    11.569     0.200
     1.739    10.300     0.200
     1.891    10.283     0.200
     2.688    15.001     0.200
     2.659    15.261     0.200
     2.927    15.332     0.200
     2.976    15.298     0.200
     3.114    18.625     0.200
     3.129    16.088     0.200
     3.083    14.662     0.200
     3.112    16.185     0.200
     3.243    16.121     0.200
     3.304    18.641     0.200
     3.635    17.166     0.200
     0.306     3.485     0.200
     3.479    19.973     0.200
     3.531    18.429     0.200
     3.745    19.498     0.200
     3.927    20.819     0.200
     3.938    19.481     0.200
     3.940    21.387     0.200
     3.965    22.342     0.200
     3.973    20.935     0.200
     4.352    22.113     0.200
     4.369    21.254     0.200
     4.540    23.244     0.200
     0.699     5.003     0.200
     0.901     6.630     0.200
     1.071     8.464     0.200
     1.586    10.215     0.200
     1.618    10.287     0.200
     1.672    11.312     0.200
     1.698    10.088     0.200
     2.374    13.796     0.200
     3.048    14.754     0.200
     0.854     5.910     0.200
     1.177     8.734     0.200
     1.213    10.115     0.200
     1.678    10.516     0.200
     1.785    11.453     0.200
     1.662    12.656     0.200
     1.949    12.912     0.200
     2.033    12.785     0.200
     2.386    13.024     0.200
     2.485    13.551     0.200
     2.544    15.099     0.200
     2.593    15.776     0.200
     2.803    16.876     0.200
     2.847    17.336     0.200
     2.961    15.955     0.200
     3.386    17.386     0.200
     3.381    17.105     0.200
     0.871     6.297     0.200
     3.261    18.229     0.200
     0.131     3.115     0.200
     1.045     6.965     0.200
     1.345     8.674     0.200
     1.609     9.946     0.200
     2.357    12.665     0.200
     3.082    15.452     0.200
     3.611    19.723     0.200
     3.837    20.754     0.200
     3.803    19.760     0.200
     3.965    23.240     0.200
     3.977    21.115     0.200
     4.427    21.180     0.200
     0.053     2.556     0.200
     1.069     7.996     0.200
     1.585     9.203     0.200
     1.673     9.592     0.200
     2.486    13.295     0.200
     2.448    13.229     0.200
     0.086     2.965     0.200
     0.977     7.230     0.200
     1.136     8.281     0.200
     1.235     8.096     0.200
     1.587     9.876     0.200
     2.346    12.936     0.200
     3.546    17.793     0.200
     3.551    17.176     0.200
     3.851    22.566     0.200
     3.974    22.689     0.200
     3.989    22.206     0.200
     3.992    22.098     0.200
     4.001    20.249     0.200
     4.012    21.865     0.200
     4.016    22.288     0.200
     4.023    22.905     0.200
     4.023    22.179     0.200
     4.038    22.617     0.200
     4.036    23.119     0.200
     4.042    21.029     0.200
     4.078    22.849     0.200
     4.112    23.170     0.200
     4.129    23.361     0.200
     4.181    22.002     0.200
     4.236    21.716     0.200
     4.262    23.111     0.200
     4.317    23.760     0.200
     0.503     3.822     0.200
     0.751     5.896     0.200
     0.884     7.069     0.200
     0.945     7.012     0.200
     1.172     7.311     0.200
     2.159    12.369     0.200
     2.416    15.106     0.200
     4.513    21.989     0.200
     4.526    24.099     0.200
     4.535    25.622     0.200
     0.192     3.245     0.200
     1.282     8.444     0.200
     1.657     9.612     0.200
     2.198    12.612     0.200
     3.144    19.792     0.200
     3.526    17.704     0.200
     3.877    23.159     0.200
     3.991    19.021     0.200
     4.634    23.572     0.200
     4.793    27.223     0.200
     0.243     2.975     0.200
     0.090     3.404     0.200
     0.921     6.480     0.200
     1.081     7.721     0.200
     1.180     7.482     0.200
     1.662     9.976     0.200
     1.560     9.297     0.200
     2.033    11.566     0.200
     2.328    12.508     0.200
     2.524    13.162     0.200
     3.579    17.742     0.200
     4.020    19.108     0.200
     0.200     3.200     0.200
     3.510    20.559     0.200
     3.932    19.625     0.200
     3.936    20.242     0.200
     3.941    18.947     0.200
     3.961    19.288     0.200
     4.058    21.476     0.200
     4.123    21.380     0.200
     4.253    21.856     0.200
     0.838     6.188     0.200
     0.987     7.249     0.200
     1.066     7.446     0.200
     1.157     8.167     0.200
     1.316     9.221     0.200
     1.605    10.729     0.200
     2.329    13.932     0.200
     2.329    13.733     0.200
     3.091    16.852     0.200
     3.382    17.360     0.200
     0.788     6.461     0.200
     0.852     6.428     0.200
     1.129     6.804     0.200
     1.501     9.829     0.200
     2.087    12.104     0.200
     2.117    11.469     0.200
     1.040     7.924     0.200
     1.199     9.236     0.200
     1.298     8.968     0.200
     1.755    11.056     0.200
     3.061    17.993     0.200
     3.066    18.147     0.200
     3.533    20.595     0.200
     3.552    19.358     0.200
     3.624    18.862     0.200
     3.852    22.848     0.200
     4.413    21.613     0.200
     4.439    23.301     0.200
     4.445    22.568     0.200
     1.609    10.259     0.200
     2.325    12.698     0.200
     2.325    12.938     0.200
     3.906    20.757     0.200
     3.946    23.609     0.200
     4.759    24.076     0.200
     1.152     8.650     0.200
     1.310     9.409     0.200
     1.414     9.502     0.200
     1.513    10.220     0.200
     2.297    13.063     0.200
     2.231    13.187     0.200
     2.770    15.474     0.200
     3.001    16.525     0.200
     3.355    18.935     0.200
     3.439    17.959     0.200
     4.226    21.396     0.200
     4.259    21.016     0.200
     5.392    26.949     0.200
     0.977     7.579     0.200
     1.136     8.068     0.200
     1.239     8.466     0.200
     1.496    10.078     0.200
     1.752    11.179     0.200
     2.251    12.860     0.200
     0.782     6.090     0.200
     0.927     7.004     0.200
     1.001     7.274     0.200
     1.001     7.157     0.200
     0.095     3.556     0.200
     1.033     7.024     0.200
     1.192     8.018     0.200
     1.288     8.011     0.200
     1.651     9.547     0.200
     2.403    12.429     0.200
     0.046     3.278     0.200
     0.985     6.719     0.200
     1.240     7.713     0.200
     0.322     3.516     0.200
     0.624     5.010     0.200
     0.782     5.880     0.200
     0.876     5.889     0.200
     1.571     9.929     0.200
     2.213    11.685     0.200
     2.380    14.425     0.200
     2.643    15.949     0.200
     3.522    17.718     0.200
     0.356     4.035     0.200
     0.596     5.008     0.200
     0.755     6.118     0.200
     0.855     5.947     0.200
     4.210    20.083     0.200
     4.531    23.795     0.200
     0.140     3.222     0.200
     0.805     6.243     0.200
     0.964     7.071     0.200
     1.058     7.017     0.200
     1.610    10.487     0.200
     2.910    16.914     0.200
     3.708    20.438     0.200
     4.015    20.487     0.200
     4.095    21.671     0.200
     4.105    23.058     0.200
     4.106    20.179     0.200
     4.114    21.924     0.200
     4.123    22.984     0.200
     4.131    22.529     0.200
     4.148    22.093     0.200
     4.237    21.427     0.200
     4.292    24.589     0.200
     4.576    22.565     0.200
     0.101     4.215     0.200
     1.021     6.773     0.200
     1.278     8.190     0.200
     1.814    10.508     0.200
     1.736    10.700     0.200
     2.108    12.529     0.200
     2.618    13.527     0.200
     0.503     4.044     0.200
     3.373    19.817     0.200
     0.941     7.438     0.200
     1.100     8.316     0.200
     1.202     8.721     0.200
     1.502    10.867     0.200
     2.264    13.813     0.200
     0.228     3.680     0.200
     1.051     7.058     0.200
     1.210     8.211     0.200
     2.760    14.817     0.200
     2.668    13.609     0.200
     4.181    23.147     0.200
     0.239     4.318     0.200
     1.137     7.760     0.200
     1.397     8.889     0.200
     1.427     9.733     0.200
     1.594     9.392     0.200
     2.744    14.133     0.200
     4.320    24.270     0.200
     4.349    22.527     0.200
     0.470     3.694     0.200
     1.023     8.340     0.200
     1.147     8.473     0.200
     1.246     9.750     0.200
     1.172     8.973     0.200
     1.249     9.083     0.200
     1.641    12.124     0.200
     2.355    14.507     0.200
     2.313    16.626     0.200
     2.557    17.396     0.200
     2.368    14.793     0.200
     2.390    15.715     0.200
     3.085    20.435     0.200
     3.077    19.629     0.200
     3.153    18.137     0.200
     3.188    17.729     0.200
     3.269    20.867     0.200
     3.363    18.295     0.200
     3.382    19.373     0.200
     3.181    18.387     0.200
     3.325    18.941     0.200
     3.560    20.465     0.200
     0.808     5.532     0.200
     0.967     6.843     0.200
     1.105     7.761     0.200
     3.604    17.095     0.200
     4.343    23.921     0.200
     0.427     3.971     0.200
     1.229     9.104     0.200
     1.047     8.131     0.200
     1.147     8.380     0.200
     1.182     8.243     0.200
     1.265     8.909     0.200
     1.682    10.235     0.200
     1.429     9.538     0.200
     2.126    13.248     0.200
     2.385    14.326     0.200
     2.379    14.360     0.200
     3.239    17.473     0.200
     0.190     2.973     0.200
     1.014     6.851     0.200
     1.173     8.031     0.200
     1.275     7.981     0.200
     1.299     9.106     0.200
     1.507    10.274     0.200
     2.256    12.942     0.200
     2.629    13.237     0.200
     3.524    17.150     0.200
     0.243     3.977     0.200
     1.106     7.280     0.200
     1.264     7.759     0.200
     1.367     8.661     0.200
     1.390     9.585     0.200
     1.539     8.829     0.200
     2.270    11.766     0.200
     2.719    13.316     0.200
     0.450     3.643     0.200
     1.036     8.184     0.200
     1.152     8.726     0.200
     1.180     9.570     0.200
     1.234     9.335     0.200
     1.260     9.309     0.200
     1.650    12.061     0.200
     2.369    14.408     0.200
     3.196    19.025     0.200
     0.483     3.393     0.200
     1.010     8.019     0.200
     1.137     8.122     0.200
     1.238     8.856     0.200
     1.258     9.126     0.200
     2.301    16.750     0.200
     2.356    14.735     0.200
     2.387    15.919     0.200
     2.736    17.536     0.200
     3.376    18.804     0.200
     3.782    20.538     0.200
     0.372     3.569     0.200
     1.099     8.554     0.200
     1.184     8.642     0.200
     1.187     9.142     0.200
     1.227     9.702     0.200
     1.313     9.307     0.200
     1.420     9.769     0.200
     2.062    12.902     0.200
     2.318    14.172     0.200
     2.430    14.310     0.200
     2.430    13.901     0.200
     2.496    13.948     0.200
     2.512    15.277     0.200
     2.852    15.134     0.200
     2.917    17.471     0.200
     3.362    18.006     0.200
     0.438     3.000     0.200
     1.129     8.366     0.200
     1.251     8.882     0.200
     3.203    19.610     0.200
     0.075     4.696     0.200
     0.977     6.824     0.200
     1.136     8.007     0.200
     1.235     8.110     0.200
     1.599     9.659     0.200
     1.843    10.651     0.200
     2.071    10.754     0.200
     2.358    13.594     0.200
     2.575    13.555     0.200
     3.113    19.728     0.200
     0.395     4.168     0.200
     1.170     7.967     0.200
     1.209     8.367     0.200
     1.293     8.330     0.200
     1.429     9.512     0.200
     1.679    11.374     0.200
     2.094    13.076     0.200
     2.409    13.179     0.200
     2.876    16.054     0.200
     3.024    16.057     0.200
     3.204    17.057     0.200
     3.635    20.042     0.200
     0.426     3.067     0.200
     1.173     8.728     0.200
     1.202     9.249     0.200
     1.211     8.972     0.200
     1.282     9.452     0.200
     1.637    12.782     0.200
     2.359    14.922     0.200
     2.392    14.965     0.200
     2.417    15.707     0.200
     3.320    19.429     0.200
     0.166     3.079     0.200
     0.944     6.808     0.200
     1.102     7.969     0.200
     1.205     8.069     0.200
     0.890     5.997     0.200
     1.061     7.675     0.200
     1.330     8.945     0.200
     1.742    10.906     0.200
     1.821    12.213     0.200
     1.997    11.589     0.200
     2.157    12.565     0.200
     2.507    13.924     0.200
     2.626    13.484     0.200
     2.698    14.505     0.200
     3.114    15.478     0.200
     3.158    15.495     0.200
     3.356    18.229     0.200
     0.898     6.390     0.200
     1.056     7.290     0.200
     1.159     7.468     0.200
     3.455    20.188     0.200
     4.248    24.221     0.200
     0.474     3.652     0.200
     1.106     8.168     0.200
     1.139     8.892     0.200
     1.221     9.028     0.200
     1.273    10.188     0.200
     1.705    11.741     0.200
     2.334    14.720     0.200
     2.430    14.139     0.200
     3.106    17.252     0.200
     3.206    18.415     0.200
     0.055     5.326     0.200
     0.919     6.467     0.200
     1.176     7.711     0.200
     2.012    11.116     0.200
     2.365    12.007     0.200
     2.515    12.874     0.200
     0.374     2.629     0.200
     1.214     9.163     0.200
     1.247     9.347     0.200
     1.329     9.602     0.200
     2.468    16.644     0.200
     2.476    16.457     0.200
     2.411    16.540     0.200
     2.466    15.007     0.200
     2.633    16.604     0.200
     2.910    19.025     0.200
     3.645    21.119     0.200
     0.394     2.680     0.200
     1.150     8.004     0.200
     1.247     9.568     0.200
     1.271    10.582     0.200
     2.355    14.936     0.200
     2.451    14.825     0.200
     2.632    16.889     0.200
     3.155    18.467     0.200
     3.236    18.615     0.200
     3.283    20.199     0.200
     3.646    21.696     0.200
     4.202    22.168     0.200
     0.896     6.035     0.200
     1.064     7.398     0.200
     1.734    11.013     0.200
     1.876    11.133     0.200
     1.988    12.180     0.200
     2.162    13.265     0.200
     2.501    14.089     0.200
     2.617    14.600     0.200
     2.800    15.903     0.200
     2.951    16.223     0.200
     3.144    18.237     0.200
     3.159    16.983     0.200
     3.268    17.587     0.200
     3.346    16.629     0.200
     3.728    22.741     0.200
     6.317    31.833     0.200
     0.290     4.368     0.200
     0.758     5.728     0.200
     0.915     6.654     0.200
     1.021     7.104     0.200
     1.027     7.785     0.200
     1.956    10.451     0.200
     2.382    13.202     0.200
     3.540    17.109     0.200
     4.236    21.264     0.200
     0.346     2.955     0.200
     1.094     8.159     0.200
     1.094     8.671     0.200
     1.150     8.955     0.200
     1.300     8.823     0.200
     1.326     8.949     0.200
     1.516    10.709     0.200
     2.852    17.476     0.200
     3.016    17.761     0.200
     3.408    17.937     0.200
     7.551    45.545     0.200
     0.364     3.197     0.200
     1.120     7.591     0.200
     1.124     8.771     0.200
     1.120     7.981     0.200
     1.273     9.035     0.200
     1.299     9.928     0.200
     1.376     9.538     0.200
     2.601    16.540     0.200
     2.952    17.062     0.200
     3.101    18.962     0.200
     3.125    17.396     0.200
     3.130    19.231     0.200
     3.221    18.614     0.200
     3.236    19.331     0.200
     3.255    19.475     0.200
     3.255    19.471     0.200
     3.628    20.859     0.200
     3.666    20.111     0.200
     0.362     3.504     0.200
     1.116     8.883     0.200
     1.128     9.537     0.200
     1.277     9.633     0.200
     1.303    10.138     0.200
     1.380    10.250     0.200
     2.427    14.701     0.200
     2.485    14.582     0.200
     2.873    18.048     0.200
     2.949    18.591     0.200
     3.061    18.811     0.200
     3.216    19.029     0.200
     3.243    18.058     0.200
     3.251    18.039     0.200
     3.251    18.043     0.200
     3.430    18.457     0.200
     3.625    19.445     0.200
     0.358     2.950     0.200
     1.109     8.549     0.200
     1.135     8.413     0.200
     1.285     8.545     0.200
     1.310     9.040     0.200
     0.721     5.543     0.200
     1.245     8.227     0.200
     1.385     9.241     0.200
     1.412    10.068     0.200
     1.496     9.247     0.200
     1.756    12.409     0.200
     2.156    11.705     0.200
     2.892    14.581     0.200
     2.852    14.286     0.200
     2.951    15.630     0.200
     2.992    15.587     0.200
     3.163    16.985     0.200
     3.281    17.189     0.200
     0.414     3.249     0.200
     1.041     8.666     0.200
     1.207     8.742     0.200
     1.173     8.768     0.200
     1.205     9.512     0.200
     1.286     9.368     0.200
     1.650    11.491     0.200
     2.434    15.953     0.200
     3.157    17.929     0.200
     3.667    21.741     0.200
     0.727     5.976     0.200
     1.437     9.025     0.200
     1.501     9.414     0.200
     1.722    11.571     0.200
     1.762    10.504     0.200
     2.044    13.099     0.200
     2.975    15.209     0.200
     3.128    15.462     0.200
     0.477     3.771     0.200
     0.972     8.883     0.200
     1.099     8.414     0.200
     1.133     8.761     0.200
     1.215     8.325     0.200
     1.279     9.713     0.200
     2.319    16.722     0.200
     2.329    14.185     0.200
     2.398    16.201     0.200
     2.470    15.267     0.200
     3.107    17.675     0.200
     0.179     3.412     0.200
     1.115     7.175     0.200
     1.273     8.541     0.200
     1.431     8.882     0.200
     2.681    13.783     0.200
     3.661    17.751     0.200
     0.199     2.267     0.200
     0.907     7.061     0.200
     1.065     7.786     0.200
     1.169     8.196     0.200
     1.181     9.591     0.200
     1.452    11.213     0.200
     1.816    11.675     0.200
     2.219    12.602     0.200
     3.491    18.088     0.200
     0.170     2.951     0.200
     0.268     3.100     0.200
     4.232    22.717     0.200
     0.135     2.642     0.200
     0.926     6.516     0.200
     1.186     7.719     0.200
     1.517    10.025     0.200
     2.283    12.333     0.200
     3.549    18.129     0.200
     3.549    18.258     0.200
     3.756    18.664     0.200
     4.406    21.238     0.200
     0.465     3.809     0.200
     0.983     8.536     0.200
     1.269     8.977     0.200
     1.107     8.221     0.200
     1.225     8.920     0.200
     2.063    13.149     0.200
     2.340    13.964     0.200
     0.658     4.988     0.200
     0.793     6.172     0.200
     1.035     7.426     0.200
     1.011     7.739     0.200
     1.812    12.157     0.200
     2.099    12.415     0.200
     2.382    14.449     0.200
     3.071    19.194     0.200
     3.118    18.180     0.200
     3.277    18.207     0.200
     3.264    18.336     0.200
     3.288    18.954     0.200
     3.396    17.709     0.200
     3.519    19.141     0.200
     3.675    21.537     0.200
     4.058    20.605     0.200
     0.473     4.854     0.200
     0.991     8.307     0.200
     1.138     8.485     0.200
     1.242     9.144     0.200
     1.253    10.359     0.200
     1.653    11.830     0.200
     2.349    15.075     0.200
     2.370    13.928     0.200
     2.401    14.431     0.200
     2.446    14.177     0.200
     3.221    18.567     0.200
     3.311    17.403     0.200
     3.337    19.178     0.200
     3.391    17.899     0.200
     0.487     4.749     0.200
     1.411     8.510     0.200
     1.499     9.728     0.200
     2.094    10.792     0.200
     0.782     6.335     0.200
     1.167     8.529     0.200
     1.367    10.166     0.200
     1.848    12.104     0.200
     1.810    11.777     0.200
     2.102    12.610     0.200
     2.405    12.914     0.200
     2.640    15.435     0.200
     2.876    16.348     0.200
     3.110    16.577     0.200
     0.999     7.241     0.200
     3.381    19.171     0.200
     3.856    21.445     0.200
     3.947    21.266     0.200
     3.960    21.059     0.200
     4.313    22.058     0.200
     4.395    26.548     0.200
     4.403    22.974     0.200
     4.421    23.839     0.200
     4.441    23.080     0.200
     4.486    26.430     0.200
     4.684    24.237     0.200
     0.880     6.726     0.200
     1.137     8.032     0.200
     1.249     8.736     0.200
     1.540     9.746     0.200
     1.637    10.790     0.200
     1.647    10.315     0.200
     1.674    10.545     0.200
     1.689    10.681     0.200
     1.721    11.319     0.200
     1.759    11.511     0.200
     1.796    10.775     0.200
     1.822    10.627     0.200
     1.921    10.857     0.200
     2.088    11.630     0.200
     2.681    14.459     0.200
     2.811    14.156     0.200
     2.875    15.119     0.200
     2.889    15.554     0.200
     3.074    16.533     0.200
     3.156    15.860     0.200
     3.451    20.159     0.200
     3.784    19.039     0.200
     0.205     3.485     0.200
     1.126     7.319     0.200
     1.260     8.329     0.200
     1.384     8.303     0.200
     1.372     8.921     0.200
     1.409     9.124     0.200
     1.418     9.727     0.200
     1.441     9.118     0.200
     1.460     9.765     0.200
     1.635     9.455     0.200
     1.712    10.447     0.200
     1.842    10.694     0.200
     2.213    13.813     0.200
     2.381    14.565     0.200
     2.367    13.572     0.200
     2.988    17.426     0.200
     3.116    19.850     0.200
     3.501    18.406     0.200
     3.538    17.577     0.200
     3.607    22.007     0.200
     3.769    19.307     0.200
     0.190     3.824     0.200
     1.127     7.742     0.200
     1.263     8.468     0.200
     1.361     8.887     0.200
     1.384     8.668     0.200
     1.381     9.099     0.200
     1.419     9.498     0.200
     1.468     9.612     0.200
     1.480     8.810     0.200
     1.676     9.890     0.200
     1.725    10.535     0.200
     1.821    10.557     0.200
     1.851    11.598     0.200
     1.852    11.027     0.200
     2.193    11.381     0.200
     2.719    13.884     0.200
     1.460     9.874     0.200
     0.330     3.936     0.200
     0.333     2.296     0.200
     0.399     2.880     0.200
     1.037     8.731     0.200
     1.098     8.724     0.200
     1.121     9.116     0.200
     1.140     9.453     0.200
     1.147     9.659     0.200
     1.110     8.875     0.200
     1.206     9.599     0.200
     1.263     9.849     0.200
     1.308     9.633     0.200
     1.476    12.437     0.200
     2.236    13.649     0.200
     2.415    17.415     0.200
     2.493    15.847     0.200
     0.485     4.195     0.200
     0.857     6.624     0.200
     0.957     7.458     0.200
     0.954     8.182     0.200
     0.986     7.939     0.200
     1.011     7.959     0.200
     1.059     8.626     0.200
     1.113     7.990     0.200
     1.099     8.818     0.200
     1.164     9.431     0.200
     1.300     9.601     0.200
     1.326    10.643     0.200
     1.453    10.408     0.200
     1.944    13.368     0.200
     2.476    15.353     0.200
     2.964    15.521     0.200
     3.177    17.574     0.200
     3.224    19.351     0.200
     3.325    16.733     0.200
     3.363    16.875     0.200
     3.473    18.370     0.200
     3.487    18.771     0.200
     3.597    17.819     0.200
     3.673    19.313     0.200
     3.753    19.107     0.200
     3.785    18.672     0.200
     4.130    21.346     0.200
     0.168     3.627     0.200
     1.089     7.655     0.200
     1.223     8.299     0.200
     1.318     9.214     0.200
     1.347     8.453     0.200
     1.338     8.522     0.200
     1.383     9.570     0.200
     1.425     9.690     0.200
     1.431     9.148     0.200
     1.628     9.440     0.200
     1.679    10.598     0.200
     1.808    10.968     0.200
     1.803    11.723     0.200
     2.176    12.982     0.200
     2.368    13.520     0.200
     2.688    13.886     0.200
     3.523    18.091     0.200
     4.389    25.550     0.200
     4.418    25.442     0.200
     1.418     9.569     0.200
     0.227     2.137     0.200
     0.969     7.454     0.200
     1.094     8.504     0.200
     1.168     8.961     0.200
     1.190     9.373     0.200
     1.231     9.003     0.200
     1.383     9.781     0.200
     1.442    11.232     0.200
     1.516    10.963     0.200
     1.750    11.770     0.200
     2.137    12.540     0.200
     2.197    13.420     0.200
     2.349    15.835     0.200
     2.589    15.219     0.200
     2.637    15.409     0.200
     3.043    17.639     0.200
     0.751     5.889     0.200
     0.753     5.680     0.200
     0.878     7.350     0.200
     0.884     6.357     0.200
     0.947     6.044     0.200
     3.419    19.439     0.200
     0.070     1.927     0.200
     0.195     1.659     0.200
     0.304     3.412     0.200
     0.328     3.555     0.200
     0.361     3.820     0.200
     0.672     5.192     0.200
     0.935     6.436     0.200
     1.006     7.525     0.200
     1.254     8.056     0.200
     1.362     9.743     0.200
     1.592    11.048     0.200
     1.646    12.030     0.200
     1.959    12.087     0.200
     0.346     3.780     0.200
     0.288     2.354     0.200
     0.482     3.135     0.200
     0.862     6.583     0.200
     0.909     7.530     0.200
     0.931     6.463     0.200
     0.940     7.237     0.200
     0.966     8.057     0.200
     0.980     7.661     0.200
     1.061     8.049     0.200
     1.090     8.269     0.200
     1.112     7.642     0.200
     1.286    11.330     0.200
     1.208     8.783     0.200
     2.046    13.230     0.200
     2.317    15.424     0.200
     2.323    14.724     0.200
     2.883    17.843     0.200
     0.992     7.809     0.200
     0.251     3.689     0.200
     1.025     7.122     0.200
     1.169     8.079     0.200
     1.177     7.947     0.200
     1.322     8.607     0.200
     1.258     8.143     0.200
     1.368     8.976     0.200
     1.362     9.016     0.200
     1.403     9.253     0.200
     1.580     9.425     0.200
     1.691     9.918     0.200
     1.791    10.172     0.200
     2.053    12.507     0.200
     2.570    14.113     0.200
     2.532    13.556     0.200
     3.874    20.613     0.200
     3.954    19.731     0.200
     1.392     9.416     0.200
     0.242     2.423     0.200
     0.423     3.509     0.200
     0.454     3.599     0.200
     0.971     8.185     0.200
     0.984     7.519     0.200
     1.028     8.672     0.200
     1.041     8.291     0.200
     1.124     8.634     0.200
     1.163     8.164     0.200
     1.224     8.554     0.200
     1.153     8.407     0.200
     1.170     8.318     0.200
     1.271     8.922     0.200
     1.371    10.282     0.200
     1.425    10.335     0.200
     2.108    13.426     0.200
     2.385    14.772     0.200
     3.157    19.376     0.200
     3.239    21.107     0.200
     3.357    19.956     0.200
     0.877     6.141     0.200
     1.138     8.097     0.200
     1.160     9.240     0.200
     1.224     9.554     0.200
     1.437    10.415     0.200
     1.718     9.805     0.200
     1.691    11.064     0.200
     1.757    11.227     0.200
     1.864    11.916     0.200
     1.873    12.146     0.200
     1.909    12.231     0.200
     1.946    12.255     0.200
     2.007    12.163     0.200
     2.080    12.476     0.200
     2.253    12.875     0.200
     2.424    12.882     0.200
     2.655    13.745     0.200
     2.663    15.897     0.200
     2.739    15.094     0.200
     0.097     3.927     0.200
     0.042     4.530     0.200
     0.074     4.471     0.200
     0.214     4.270     0.200
     0.206     4.232     0.200
     0.197     3.852     0.200
     0.238     4.229     0.200
     0.260     4.410     0.200
     0.369     3.450     0.200
     0.452     4.441     0.200
     0.547     4.489     0.200
     0.593     4.275     0.200
     1.130     7.542     0.200
     1.142     7.419     0.200
     1.447     8.839     0.200
     1.420     9.103     0.200
     1.366     9.254     0.200
     1.590    10.284     0.200
     1.627    11.361     0.200
     1.945    10.169     0.200
     2.793    16.113     0.200
     2.891    14.657     0.200
     3.557    16.879     0.200
     0.820     6.390     0.200
     0.870     7.491     0.200
     1.010     8.828     0.200
     1.212     9.587     0.200
     1.309     9.244     0.200
     1.392    10.112     0.200
     1.411    10.393     0.200
     1.421    10.624     0.200
     1.457    10.926     0.200
     1.494    11.067     0.200
     1.556    10.661     0.200
     1.638    11.092     0.200
     1.691    10.665     0.200
     1.668    11.339     0.200
     1.809    11.715     0.200
     2.242    13.981     0.200
     2.597    16.069     0.200
     2.533    16.162     0.200
     2.904    18.160     0.200
     3.093    18.260     0.200
     3.173    19.936     0.200
     3.411    19.349     0.200
     0.391     4.488     0.200
     1.276     8.059     0.200
     1.404     9.200     0.200
     1.435    10.131     0.200
     1.479     9.668     0.200
     1.419     8.404     0.200
     1.502     9.539     0.200
     1.538     9.279     0.200
     1.534    10.454     0.200
     1.548     9.614     0.200
     1.533     9.625     0.200
     1.590    10.226     0.200
     1.595    10.732     0.200
     1.789    10.509     0.200
     1.825    10.978     0.200
     1.784    11.297     0.200
     2.026    12.288     0.200
     1.964    12.158     0.200
     2.287    11.858     0.200
     2.890    14.461     0.200
     2.893    17.892     0.200
     3.217    17.981     0.200
     3.288    20.616     0.200
     3.331    18.390     0.200
     3.361    19.639     0.200
     3.501    20.472     0.200
     3.809    19.277     0.200
     4.346    26.601     0.200
     5.052    26.633     0.200
     0.130     4.145     0.200
     1.074     7.372     0.200
     1.233     7.892     0.200
     1.328     8.530     0.200
     1.335     8.970     0.200
     1.336     8.798     0.200
     1.376     9.102     0.200
     1.381     9.370     0.200
     1.423     9.600     0.200
     1.825    11.440     0.200
     1.686    10.304     0.200
     1.751     9.623     0.200
     1.808    10.385     0.200
     2.123    13.472     0.200
     0.243     2.545     0.200
     0.364     2.612     0.200
     1.135     8.373     0.200
     1.062     8.370     0.200
     1.052     8.705     0.200
     1.087     8.628     0.200
     1.110     8.962     0.200
     1.109     9.265     0.200
     1.251     9.418     0.200
     1.533    11.889     0.200
     3.005    18.909     0.200
     2.467    15.954     0.200
     3.122    17.547     0.200
     3.657    19.267     0.200
     0.249     2.985     0.200
     0.342     3.144     0.200
     0.357     2.754     0.200
     1.048     7.567     0.200
     1.065     8.756     0.200
     1.076     8.460     0.200
     1.101     8.863     0.200
     1.123     9.155     0.200
     1.133     9.392     0.200
     1.232     9.024     0.200
     1.222     8.776     0.200
     1.249     8.730     0.200
     1.268     9.676     0.200
     1.527    11.080     0.200
     2.212    14.192     0.200
     2.480    15.715     0.200
     3.240    19.036     0.200
     0.092     4.597     0.200
     1.007     6.935     0.200
     1.241     8.273     0.200
     1.265     8.101     0.200
     1.260     8.707     0.200
     1.298     9.123     0.200
     1.305     9.259     0.200
     1.347     9.319     0.200
     1.407     9.378     0.200
     1.541     9.469     0.200
     1.605    10.111     0.200
     1.611     9.983     0.200
     1.725     9.764     0.200
     1.731    10.472     0.200
     1.779    11.286     0.200
     2.097    11.154     0.200
     2.365    13.217     0.200
     2.457    15.125     0.200
     2.605    13.714     0.200
     2.763    14.080     0.200
     3.035    14.600     0.200
     3.473    18.761     0.200
     3.567    19.525     0.200
     0.287     3.934     0.200
     0.395     5.396     0.200
     0.414     5.254     0.200
     0.991     7.518     0.200
     1.046     7.528     0.200
     1.068     8.087     0.200
     1.078     7.882     0.200
     1.180     8.356     0.200
     1.219     8.041     0.200
     1.243     7.682     0.200
     1.321     8.899     0.200
     1.365    10.973     0.200
     1.579     9.708     0.200
     2.159    12.704     0.200
     2.195    12.528     0.200
     2.425    14.023     0.200
     2.399    12.636     0.200
     2.487    12.632     0.200
     2.657    13.578     0.200
     2.743    14.363     0.200
     2.885    14.457     0.200
     2.943    17.462     0.200
     2.932    15.130     0.200
     3.008    15.373     0.200
     3.055    15.574     0.200
     3.168    16.194     0.200
     3.490    16.490     0.200
     3.684    23.393     0.200
     3.887    19.836     0.200
     0.273     2.990     0.200
     0.461     3.646     0.200
     0.490     4.640     0.200
     0.932     7.643     0.200
     0.938     7.323     0.200
     0.948     7.755     0.200
     0.964     7.412     0.200
     0.989     8.987     0.200
     1.086     8.283     0.200
     1.116     8.254     0.200
     1.132     7.897     0.200
     1.233     8.846     0.200
     1.557    10.807     0.200
     2.901    17.544     0.200
     0.847     6.097     0.200
     0.949     8.091     0.200
     1.230     8.655     0.200
     1.395     9.185     0.200
     1.478     9.792     0.200
     1.506     9.805     0.200
     1.518    10.160     0.200
     1.517    10.281     0.200
     1.552    10.515     0.200
     1.589    10.440     0.200
     1.645    10.081     0.200
     1.737    10.323     0.200
     1.907    10.405     0.200
     2.997    14.262     0.200
     3.251    15.315     0.200
     1.590    10.524     0.200
     0.530     4.211     0.200
     0.990     7.204     0.200
     0.965     7.355     0.200
     1.347     9.755     0.200
     1.644    10.687     0.200
     1.741    11.609     0.200
     1.750    11.732     0.200
     1.777    11.732     0.200
     1.788    11.973     0.200
     1.792    12.165     0.200
     1.824    12.327     0.200
     1.862    12.272     0.200
     2.062    12.015     0.200
     2.118    13.649     0.200
     2.599    16.305     0.200
     2.711    14.641     0.200
     2.798    17.337     0.200
     2.822    16.573     0.200
     2.922    15.678     0.200
     2.865    14.949     0.200
     2.913    18.430     0.200
     2.962    15.551     0.200
     3.081    16.098     0.200
     3.131    15.779     0.200
     3.152    16.434     0.200
     3.224    16.360     0.200
     3.224    18.383     0.200
     3.224    18.406     0.200
     3.232    15.994     0.200
     3.233    16.498     0.200
     3.236    16.750     0.200
     3.247    20.800     0.200
     3.252    20.744     0.200
     3.601    17.546     0.200
     3.856    19.834     0.200
     1.862    12.264     0.200
     0.155     3.911     0.200
     0.260     3.856     0.200
     0.321     4.035     0.200
     0.389     3.870     0.200
     0.399     4.454     0.200
     0.392     4.157     0.200
     0.407     4.418     0.200
     0.409     4.458     0.200
     0.423     4.475     0.200
     0.447     4.306     0.200
     0.422     3.627     0.200
     0.611     3.126     0.200
     0.640     4.508     0.200
     0.665     4.714     0.200
     0.692     4.917     0.200
     1.247     7.995     0.200
     1.473     9.723     0.200
     1.614     9.974     0.200
     1.718     9.199     0.200
     0.393     4.459     0.200
     0.310     3.641     0.200
     0.322     3.876     0.200
     0.380     3.714     0.200
     0.515     4.468     0.200
     0.494     4.714     0.200
     0.507     4.487     0.200
     0.508     4.620     0.200
     0.537     4.875     0.200
     0.564     4.943     0.200
     0.572     5.008     0.200
     0.721     4.740     0.200
     0.835     5.745     0.200
     0.881     5.873     0.200
     0.930     5.982     0.200
     0.944     5.819     0.200
     1.434     8.753     0.200
     1.697    10.152     0.200
     2.144    11.346     0.200
     2.143    11.455     0.200
     2.498    14.321     0.200
     2.889    14.983     0.200
     0.108     3.630     0.200
     1.052     7.327     0.200
     1.191     7.987     0.200
     1.300     8.459     0.200
     1.318     8.648     0.200
     1.317     8.693     0.200
     1.304     8.398     0.200
     1.359     9.168     0.200
     1.363     9.221     0.200
     1.404     9.322     0.200
     1.338     8.911     0.200
     1.671    10.246     0.200
     1.790    10.277     0.200
     2.090    13.290     0.200
     0.104     3.057     0.200
     0.691     6.416     0.200
     0.964     7.779     0.200
     1.278     8.854     0.200
     1.278     9.074     0.200
     1.305     9.122     0.200
     1.328     9.397     0.200
     1.334     9.523     0.200
     1.311     8.480     0.200
     1.417     9.539     0.200
     1.408     9.809     0.200
     1.516    10.243     0.200
     1.490     9.436     0.200
     1.563    10.223     0.200
     1.682    11.178     0.200
     1.873    11.997     0.200
     1.707     9.815     0.200
     2.056    12.800     0.200
     2.263    13.523     0.200
     2.275    13.094     0.200
     2.394    13.472     0.200
     2.385    12.686     0.200
     2.475    14.032     0.200
     2.607    14.324     0.200
     2.830    14.562     0.200
     2.821    15.802     0.200
     4.737    27.328     0.200
     1.363     9.496     0.200
     0.496     4.528     0.200
     0.923     6.303     0.200
     0.954     8.029     0.200
     1.023     7.351     0.200
     1.049     7.325     0.200
     1.075     7.532     0.200
     1.096     7.854     0.200
     1.122     8.179     0.200
     1.162     8.333     0.200
     1.180     7.560     0.200
     1.358     9.076     0.200
     1.513     9.709     0.200
     1.831    10.085     0.200
     2.147    12.023     0.200
     2.384    12.738     0.200
     2.542    14.156     0.200
     1.160     8.390     0.200
     0.277     2.976     0.200
     1.011     6.201     0.200
     1.059     8.690     0.200
     1.088     8.869     0.200
     1.101     8.523     0.200
     1.099     9.221     0.200
     1.125     8.768     0.200
     1.149     9.123     0.200
     1.146     9.286     0.200
     1.260     9.421     0.200
     1.231     9.669     0.200
     1.299     9.304     0.200
     1.323     9.669     0.200
     1.400     9.894     0.200
     1.375    11.439     0.200
     1.390    10.877     0.200
     1.510    12.165     0.200
     1.501    11.900     0.200
     1.751    12.024     0.200
     1.876    12.816     0.200
     2.238    13.981     0.200
     2.348    14.054     0.200
     2.383    14.375     0.200
     2.394    14.004     0.200
     2.409    13.827     0.200
     2.435    14.935     0.200
     2.456    14.264     0.200
     2.516    14.240     0.200
     2.583    14.449     0.200
     2.815    16.391     0.200
     3.036    17.137     0.200
     3.047    18.294     0.200
     3.152    19.767     0.200
     3.204    18.493     0.200
     3.387    17.995     0.200
     1.168     9.373     0.200
     0.934     6.919     0.200
     1.031     7.209     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.900    29.669     0.200
     4.208    62.744     0.200
     6.738    99.214     0.200
    14.817   200.928     0.200
    16.481   217.514     0.200
    18.398   237.139     0.200
    22.454   287.558     0.200
     2.365    34.950     0.200
     2.783    40.678     0.200
    12.592   172.200     0.200
    17.252   224.825     0.200
    21.296   280.629     0.200
     1.670    27.305     0.200
     5.386    69.938     0.200
     6.679    98.841     0.200
    15.159   207.887     0.200
    17.169   228.422     0.200
    23.338   294.430     0.200
     2.578    41.303     0.200
     6.257    92.373     0.200
    13.143   183.007     0.200
    18.933   249.439     0.200
     2.654    42.746     0.200
    15.762   213.777     0.200
    20.861   275.267     0.200
    18.603   241.453     0.200
    23.339   297.569     0.200
     4.339    73.709     0.200
    17.983   234.488     0.200
    21.975   284.823     0.200
    18.756   246.327     0.200
    21.383   280.663     0.200
     3.297    49.814     0.200
     7.019    99.573     0.200
    10.109   137.310     0.200
     2.613    38.987     0.200
     3.149    44.527     0.200
     3.882    51.201     0.200
     6.271    85.329     0.200
     5.723    89.607     0.200
    24.213   308.692     0.200
     3.768    57.905     0.200
     3.880    60.605     0.200
     4.781    65.084     0.200
     3.342    50.642     0.200
     3.832    59.924     0.200
     4.062    59.434     0.200
     4.074    58.293     0.200
     5.130    66.965     0.200
     6.265    83.722     0.200
     3.666    56.474     0.200
     3.679    55.813     0.200
     4.722    64.139     0.200
    10.718   147.631     0.200
     1.229    21.988     0.200
     2.722    41.614     0.200
    21.161   280.229     0.200
     3.299    52.238     0.200
     1.973    35.027     0.200
     3.841    61.958     0.200
     1.393    24.163     0.200
     2.340    27.307     0.200
     2.404    34.556     0.200
     3.558    55.092     0.200
     3.612    53.457     0.200
     4.006    57.368     0.200
     4.465    66.005     0.200
     4.757    66.400     0.200
     5.270    76.111     0.200
     5.628    80.435     0.200
     6.360    91.588     0.200
     1.118    22.680     0.200
     3.432    48.675     0.200
     3.391    51.154     0.200
     4.513    71.660     0.200
     4.889    65.754     0.200
     4.905    75.559     0.200
     6.753   103.501     0.200
     2.412    39.709     0.200
     3.782    55.727     0.200
     3.816    57.823     0.200
     4.110    63.691     0.200
     4.593    68.765     0.200
     1.601    30.942     0.200
     3.031    50.255     0.200
     3.480    52.013     0.200
     3.420    53.706     0.200
     3.770    56.619     0.200
     6.144    84.426     0.200
     0.463    20.470     0.200
     2.356    39.878     0.200
     3.901    53.652     0.200
     5.987    78.012     0.200
     7.991   103.118     0.200
     1.423    23.359     0.200
     1.682    30.436     0.200
     2.369    37.418     0.200
     2.692    43.647     0.200
     3.122    44.835     0.200
     3.513    53.862     0.200
     3.655    60.706     0.200
     3.679    54.834     0.200
     3.816    59.323     0.200
     3.845    59.297     0.200
     3.852    61.209     0.200
     4.151    68.321     0.200
     9.859   139.012     0.200
    11.196   151.404     0.200
    19.664   256.583     0.200
     2.686    42.038     0.200
     3.116    48.027     0.200
     3.268    51.252     0.200
     3.562    56.724     0.200
     3.699    55.626     0.200
     3.744    60.698     0.200
     3.756    61.558     0.200
     3.865    61.082     0.200
     3.896    59.420     0.200
     4.170    62.227     0.200
     4.203    66.541     0.200
     1.113    18.700     0.200
     2.383    38.272     0.200
     3.064    49.373     0.200
     3.286    51.849     0.200
     3.411    52.790     0.200
     3.486    51.706     0.200
     3.609    56.074     0.200
     3.626    54.172     0.200
     3.935    59.572     0.200
     1.799    29.503     0.200
     2.521    41.576     0.200
     2.951    44.358     0.200
     3.086    46.489     0.200
     3.389    50.052     0.200
     3.539    53.804     0.200
     3.570    54.336     0.200
     3.586    56.654     0.200
     3.693    58.703     0.200
     3.991    62.921     0.200
     1.157    24.409     0.200
     2.417    38.055     0.200
     2.607    41.343     0.200
     2.846    43.775     0.200
     3.522    57.086     0.200
     3.528    53.212     0.200
     5.114    78.900     0.200
     5.705    83.009     0.200
     6.360    91.835     0.200
     0.553    18.887     0.200
     1.549    27.386     0.200
     1.860    31.578     0.200
     2.087    32.585     0.200
     3.516    53.928     0.200
     3.750    57.214     0.200
     3.760    55.375     0.200
     3.782    58.993     0.200
     3.792    57.928     0.200
     3.885    58.644     0.200
     4.184    62.483     0.200
     4.249    65.599     0.200
     4.298    64.590     0.200
     4.298    68.010     0.200
     4.564    73.243     0.200
     5.213    72.224     0.200
     5.480    80.256     0.200
     6.396    89.947     0.200
     6.402    93.705     0.200
    12.835   176.625     0.200
    21.893   276.692     0.200
     1.217    20.897     0.200
     2.488    40.016     0.200
     2.667    43.522     0.200
     2.964    46.679     0.200
     2.918    43.347     0.200
     3.046    50.345     0.200
     3.147    49.602     0.200
     3.276    52.960     0.200
     3.437    52.781     0.200
     3.471    56.319     0.200
     3.611    57.083     0.200
     3.887    62.151     0.200
     3.887    62.533     0.200
     3.952    60.865     0.200
     4.280    66.993     0.200
     5.714    88.501     0.200
     2.731    43.563     0.200
     3.296    52.358     0.200
     3.392    54.204     0.200
     3.911    59.153     0.200
     2.965    52.134     0.200
     4.037    65.966     0.200
     4.321    68.905     0.200
     4.338    69.317     0.200
     4.438    71.630     0.200
     4.467    68.608     0.200
     4.588    72.899     0.200
     4.744    76.040     0.200
     4.778    76.423     0.200
     4.781    76.458     0.200
     4.844    77.366     0.200
     4.881    79.403     0.200
     4.935    79.542     0.200
     5.169    81.584     0.200
     5.243    80.426     0.200
     5.271    82.223     0.200
     5.271    84.746     0.200
     6.448    97.099     0.200
     7.259   106.713     0.200
     2.419    39.802     0.200
     2.468    38.862     0.200
     2.746    42.151     0.200
     2.849    43.225     0.200
     2.946    48.372     0.200
     3.064    48.959     0.200
     3.288    52.385     0.200
     3.432    54.654     0.200
     3.469    55.358     0.200
     3.487    56.483     0.200
     3.568    58.186     0.200
     3.627    56.497     0.200
     3.840    61.810     0.200
     3.886    59.731     0.200
     4.562    67.724     0.200
     4.701    74.804     0.200
     5.661    84.629     0.200
     6.069    92.398     0.200
     6.595    93.699     0.200
     7.761   113.290     0.200
    10.135   142.577     0.200
    19.686   264.129     0.200
     2.366    35.631     0.200
     2.795    40.868     0.200
     2.791    43.493     0.200
     2.870    45.658     0.200
     2.985    48.921     0.200
     3.098    49.358     0.200
     3.209    52.364     0.200
     3.354    54.325     0.200
     3.390    54.982     0.200
     3.408    55.836     0.200
     3.489    55.247     0.200
     3.503    54.803     0.200
     3.548    55.792     0.200
     3.761    57.999     0.200
     3.807    56.456     0.200
     3.807    58.968     0.200
     3.807    60.987     0.200
     3.885    58.676     0.200
     5.601    81.831     0.200
     1.108    20.208     0.200
     2.378    38.384     0.200
     2.808    41.900     0.200
     2.788    46.451     0.200
     2.919    46.558     0.200
     3.050    49.027     0.200
     3.166    50.957     0.200
     3.272    52.196     0.200
     3.410    53.970     0.200
     3.452    54.601     0.200
     3.473    56.176     0.200
     3.548    56.936     0.200
     3.569    56.588     0.200
     3.613    55.777     0.200
     3.821    57.616     0.200
     3.864    60.004     0.200
     3.864    61.207     0.200
     3.948    63.437     0.200
     4.522    66.755     0.200
     6.556    92.862     0.200
     2.487    40.871     0.200
     2.487    41.081     0.200
     2.689    43.529     0.200
     2.917    45.052     0.200
     3.038    49.710     0.200
     3.158    51.306     0.200
     3.563    55.907     0.200
     3.582    55.961     0.200
     3.663    57.059     0.200
     3.675    54.861     0.200
     3.722    58.999     0.200
     3.934    61.249     0.200
     3.980    61.185     0.200
     3.980    61.630     0.200
     3.980    62.341     0.200
     4.059    63.504     0.200
     4.634    69.699     0.200
     5.119    77.472     0.200
     5.751    88.745     0.200
     2.404    39.747     0.200
     2.519    40.353     0.200
     2.834    43.733     0.200
     3.094    49.784     0.200
     3.210    50.671     0.200
     3.316    54.168     0.200
     3.452    53.665     0.200
     3.495    54.593     0.200
     3.591    55.748     0.200
     3.613    57.895     0.200
     3.657    56.852     0.200
     3.865    59.396     0.200
     3.907    60.109     0.200
     3.907    60.281     0.200
     3.907    62.351     0.200
     3.992    61.318     0.200
     4.141    63.987     0.200
     4.550    71.125     0.200
     4.754    74.050     0.200
     5.043    76.824     0.200
     5.667    82.278     0.200
     2.453    40.251     0.200
     2.627    40.831     0.200
     2.981    45.027     0.200
     3.092    49.595     0.200
     3.199    51.019     0.200
     3.304    51.951     0.200
     3.714    57.583     0.200
     3.763    58.198     0.200
     3.980    63.873     0.200
     4.029    64.743     0.200
     4.102    65.437     0.200
     4.266    67.384     0.200
     5.171    75.060     0.200
     5.812    83.892     0.200
     2.844    43.611     0.200
     3.558    55.959     0.200
     3.617    57.339     0.200
     3.876    60.384     0.200
     3.876    62.693     0.200
     4.693    76.157     0.200
     5.662    82.644     0.200
    10.373   144.501     0.200
     1.321    23.117     0.200
     1.560    25.906     0.200
     1.908    31.632     0.200
     2.406    40.627     0.200
     2.469    40.318     0.200
     2.662    42.138     0.200
     2.877    44.430     0.200
     2.851    45.171     0.200
     2.851    45.382     0.200
     2.907    46.501     0.200
     3.239    52.677     0.200
     3.326    52.881     0.200
     3.333    53.080     0.200
     3.594    55.853     0.200
     4.494    67.319     0.200
     4.510    70.122     0.200
     5.418    80.471     0.200
     7.101   105.011     0.200
     1.259    20.769     0.200
     2.530    40.210     0.200
     2.960    42.985     0.200
     3.027    48.174     0.200
     3.114    50.240     0.200
     3.344    52.263     0.200
     3.425    53.660     0.200
     3.481    54.127     0.200
     3.503    55.049     0.200
     3.526    55.757     0.200
     3.538    53.905     0.200
     3.633    58.050     0.200
     3.900    61.299     0.200
     3.953    61.519     0.200
     3.953    62.339     0.200
     4.671    69.365     0.200
     5.761    83.748     0.200
     5.768    79.931     0.200
     6.704    99.183     0.200
     2.342    38.276     0.200
     2.772    43.124     0.200
     2.844    47.413     0.200
     3.330    55.242     0.200
     3.366    54.934     0.200
     3.366    55.374     0.200
     3.465    53.948     0.200
     3.481    53.947     0.200
     5.576    83.577     0.200
     7.308   105.548     0.200
     2.190    35.861     0.200
     2.821    48.008     0.200
     2.996    50.320     0.200
     4.339    63.144     0.200
     6.375    92.919     0.200
     1.994    33.579     0.200
     2.634    39.656     0.200
     2.777    44.066     0.200
     3.906    59.534     0.200
     4.268    63.666     0.200
     4.265    65.413     0.200
     4.596    68.858     0.200
     4.667    68.544     0.200
     5.092    73.590     0.200
     6.044    84.511     0.200
     7.096   102.367     0.200
     1.102    19.940     0.200
     1.529    27.348     0.200
     1.762    31.670     0.200
     1.801    30.610     0.200
     2.367    36.150     0.200
     2.785    42.946     0.200
     2.795    42.119     0.200
     2.775    42.571     0.200
     3.240    49.968     0.200
     4.490    63.434     0.200
     5.543    79.840     0.200
     1.853    31.309     0.200
     2.090    33.668     0.200
     2.672    43.035     0.200
     2.668    43.583     0.200
     3.252    52.522     0.200
     5.345    79.794     0.200
     7.091    99.670     0.200
     1.437    25.993     0.200
     2.323    39.329     0.200
     2.461    41.467     0.200
     2.707    43.990     0.200
     3.137    49.107     0.200
     3.199    49.400     0.200
     3.678    58.413     0.200
     3.678    59.585     0.200
     4.055    64.409     0.200
     4.115    63.716     0.200
     4.115    66.099     0.200
     4.115    66.341     0.200
     4.357    65.736     0.200
     4.850    75.524     0.200
     5.266    78.166     0.200
     5.368    81.873     0.200
     5.941    91.244     0.200
     5.949    90.626     0.200
     1.719    29.977     0.200
     2.538    42.028     0.200
     3.230    48.491     0.200
     3.656    53.108     0.200
     3.833    59.765     0.200
     4.139    64.330     0.200
     4.285    68.429     0.200
     4.310    63.451     0.200
     4.323    66.769     0.200
     4.466    69.117     0.200
     4.760    73.053     0.200
     4.760    74.436     0.200
     4.760    76.584     0.200
     4.851    68.090     0.200
     5.861    81.357     0.200
     6.529    92.497     0.200
     6.537    95.995     0.200
     8.277   118.245     0.200
     1.276    22.974     0.200
     1.603    28.275     0.200
     2.267    36.642     0.200
     2.477    36.731     0.200
     2.681    40.236     0.200
     3.111    44.567     0.200
     3.137    48.078     0.200
     3.137    48.406     0.200
     3.420    52.645     0.200
     3.569    54.167     0.200
     3.598    53.992     0.200
     3.598    57.250     0.200
     3.604    52.993     0.200
     3.608    55.207     0.200
     3.748    56.856     0.200
     4.045    61.183     0.200
     4.045    61.808     0.200
     4.045    62.105     0.200
     4.532    67.207     0.200
     4.532    71.035     0.200
     5.301    78.024     0.200
     5.903    86.740     0.200
     1.548    25.018     0.200
     2.390    37.363     0.200
     2.812    43.152     0.200
     3.242    45.491     0.200
     3.832    59.377     0.200
     3.849    60.381     0.200
     4.282    63.815     0.200
     6.075    83.904     0.200
     6.461    95.291     0.200
     6.997   101.249     0.200
     7.818   108.716     0.200
    10.550   144.727     0.200
     3.312    50.008     0.200
     3.312    48.219     0.200
     3.741    53.345     0.200
     3.767    57.721     0.200
     4.180    68.224     0.200
     4.206    65.219     0.200
     4.485    71.514     0.200
     5.456    81.269     0.200
     5.558    83.968     0.200
     6.550    97.571     0.200
     8.276   119.011     0.200
     1.795    29.975     0.200
     1.860    30.991     0.200
     2.200    35.199     0.200
     2.500    38.343     0.200
     2.791    43.931     0.200
     2.870    45.262     0.200
     2.928    44.794     0.200
     3.136    49.781     0.200
     3.288    52.022     0.200
     3.321    49.890     0.200
     3.321    51.140     0.200
     3.321    52.882     0.200
     3.321    49.353     0.200
     3.440    52.945     0.200
     3.464    50.138     0.200
     3.766    55.723     0.200
     4.517    64.914     0.200
     5.659    82.697     0.200
     5.666    81.552     0.200
     5.940    85.123     0.200
     2.887    47.552     0.200
     3.953    53.442     0.200
     4.294    61.747     0.200
     4.351    64.182     0.200
     4.351    66.940     0.200
     4.503    71.414     0.200
     4.617    71.960     0.200
     4.758    68.577     0.200
     4.758    73.695     0.200
     4.797    70.271     0.200
     5.084    73.557     0.200
     5.051    77.498     0.200
     5.185    76.513     0.200
     5.185    79.474     0.200
     6.017    85.022     0.200
     7.582   114.654     0.200
     1.784    29.049     0.200
     2.137    32.086     0.200
     2.522    41.902     0.200
     3.407    50.532     0.200
     3.407    52.532     0.200
     3.768    55.450     0.200
     3.837    54.196     0.200
     3.844    57.194     0.200
     4.156    63.914     0.200
     4.242    62.237     0.200
     4.242    67.135     0.200
     4.242    67.604     0.200
     4.276    62.716     0.200
     4.440    68.359     0.200
     4.713    70.851     0.200
     5.495    79.826     0.200
     5.876    79.915     0.200
     6.631    91.927     0.200
     6.638    97.514     0.200
     6.873    98.702     0.200
     7.004   103.510     0.200
     7.033   105.440     0.200
     7.065   104.904     0.200
     7.496   108.439     0.200
     7.584   105.001     0.200
     8.361   117.352     0.200
     8.475   119.367     0.200
    15.894   217.480     0.200
    16.678   222.591     0.200
    19.447   258.974     0.200
    19.727   263.796     0.200
    19.600   260.847     0.200
    19.924   266.158     0.200
    19.946   264.716     0.200
    20.010   266.415     0.200
    20.158   263.866     0.200
    20.177   265.533     0.200
    20.204   264.040     0.200
    20.301   264.707     0.200
    20.533   268.033     0.200
    20.569   270.033     0.200
    20.581   269.029     0.200
    20.746   270.132     0.200
    20.839   270.894     0.200
    20.891   274.001     0.200
    21.052   273.175     0.200
    21.123   274.729     0.200
    21.192   275.061     0.200
    21.470   277.316     0.200
    21.484   277.210     0.200
    21.483   277.499     0.200
    21.507   280.004     0.200
    21.683   279.012     0.200
    22.282   286.303     0.200
     0.950    19.787     0.200
     1.488    24.014     0.200
     1.473    26.503     0.200
     1.805    30.876     0.200
     2.543    39.250     0.200
     2.543    37.664     0.200
     2.698    40.117     0.200
     2.830    42.088     0.200
     2.838    43.539     0.200
     2.838    44.023     0.200
     3.115    47.194     0.200
     3.086    50.426     0.200
     3.167    47.832     0.200
     3.167    44.511     0.200
     3.226    48.080     0.200
     3.282    50.789     0.200
     3.317    51.744     0.200
     3.317    49.174     0.200
     3.652    53.862     0.200
     3.652    57.072     0.200
     3.652    52.104     0.200
     3.996    62.597     0.200
     4.857    70.630     0.200
     5.713    78.483     0.200
     5.800    79.843     0.200
     7.409   101.652     0.200
     7.409   101.809     0.200
     1.225    22.106     0.200
     2.720    43.618     0.200
     3.991    57.830     0.200
     4.328    65.767     0.200
     4.382    64.710     0.200
     4.529    71.625     0.200
     5.013    74.400     0.200
     7.926   114.848     0.200
     8.922   123.209     0.200
    10.652   144.002     0.200
    16.373   219.464     0.200
    20.310   266.603     0.200
     2.226    37.953     0.200
     2.697    43.715     0.200
     3.114    48.888     0.200
     3.235    51.608     0.200
     3.349    50.648     0.200
     3.552    56.046     0.200
     3.713    55.196     0.200
     3.735    57.697     0.200
     4.164    63.536     0.200
     4.268    67.373     0.200
     4.844    72.316     0.200
     4.844    70.227     0.200
     5.264    81.015     0.200
     5.953    87.631     0.200
     6.344    98.930     0.200
     6.344    90.258     0.200
     6.879    96.897     0.200
     2.257    38.009     0.200
     2.715    43.523     0.200
     2.755    47.601     0.200
     3.986    60.800     0.200
     3.986    62.800     0.200
     4.271    65.353     0.200
     4.302    66.417     0.200
     4.302    68.417     0.200
     4.601    69.590     0.200
     4.686    70.469     0.200
     4.700    72.623     0.200
     4.880    72.646     0.200
     4.917    75.100     0.200
     5.105    78.806     0.200
     7.150   103.971     0.200
     7.364   107.083     0.200
     8.145   117.332     0.200
     8.204   119.929     0.200
    10.575   150.335     0.200
     0.408    11.669     0.200
     1.608    26.884     0.200
     2.072    34.171     0.200
     2.878    44.184     0.200
     2.878    41.754     0.200
     3.029    46.535     0.200
     3.187    47.867     0.200
     3.258    48.625     0.200
     3.258    49.804     0.200
     3.306    49.328     0.200
     3.306    47.219     0.200
     4.134    60.351     0.200
     4.134    62.351     0.200
     4.355    64.856     0.200
     4.912    70.969     0.200
     5.007    71.819     0.200
     6.056    90.115     0.200
     0.566    15.734     0.200
     1.854    29.945     0.200
     1.854    33.825     0.200
     2.853    43.508     0.200
     2.950    44.978     0.200
     2.950    43.598     0.200
     3.178    46.912     0.200
     3.214    48.923     0.200
     3.568    54.147     0.200
     3.619    53.836     0.200
     3.984    58.593     0.200
     4.049    61.305     0.200
     5.056    73.662     0.200
     5.056    71.422     0.200
     5.239    75.033     0.200
     6.058    85.113     0.200
     6.200    87.097     0.200
     6.986    98.050     0.200
     7.074    97.917     0.200
     7.768   106.575     0.200
    12.424   165.683     0.200
    16.440   209.976     0.200
     2.391    40.200     0.200
     2.630    45.823     0.200
     2.695    45.884     0.200
     2.815    45.792     0.200
     3.050    51.487     0.200
     3.251    54.713     0.200
     3.276    54.997     0.200
     3.343    54.129     0.200
     3.622    58.884     0.200
     4.352    67.354     0.200
     4.492    68.135     0.200
     5.505    83.335     0.200
     6.510    96.616     0.200
     7.224   105.850     0.200
     1.760    29.958     0.200
     2.432    40.326     0.200
     2.862    43.355     0.200
     3.010    48.395     0.200
     0.710    15.690     0.200
     1.349    21.870     0.200
     1.420    27.298     0.200
     1.506    25.962     0.200
     1.795    31.353     0.200
     2.106    33.654     0.200
     2.546    41.315     0.200
     2.610    39.879     0.200
     2.949    45.370     0.200
     3.188    51.345     0.200
     3.375    51.600     0.200
     3.388    53.718     0.200
     3.830    56.644     0.200
     3.863    59.496     0.200
     4.338    63.421     0.200
     5.755    81.304     0.200
     6.748    96.690     0.200
     7.476   101.406     0.200
     0.906    17.487     0.200
     2.175    33.486     0.200
     4.306    62.917     0.200
     4.681    73.447     0.200
     5.381    79.531     0.200
     6.335    90.032     0.200
     9.854   138.550     0.200
    12.544   173.880     0.200
    20.250   266.505     0.200
    21.064   282.982     0.200
     0.249    11.245     0.200
     0.934    18.635     0.200
     1.941    29.721     0.200
     1.941    32.084     0.200
     2.225    33.923     0.200
     2.780    40.737     0.200
     2.778    42.392     0.200
     2.869    41.482     0.200
     3.573    51.614     0.200
     1.441    25.468     0.200
     2.488    39.025     0.200
     3.359    53.567     0.200
     4.186    67.962     0.200
     4.854    71.281     0.200
    12.699   177.499     0.200
    13.779   185.939     0.200
    14.813   208.371     0.200
     0.286    12.378     0.200
     1.161    20.049     0.200
     1.192    21.815     0.200
     1.387    22.642     0.200
     1.714    26.717     0.200
     2.081    32.562     0.200
     2.139    34.929     0.200
     2.985    44.288     0.200
     2.979    44.501     0.200
     3.008    44.696     0.200
     7.904   108.243     0.200
     9.528   129.589     0.200
     0.964    17.365     0.200
     1.090    19.676     0.200
     1.664    29.426     0.200
     1.777    29.455     0.200
     1.681    32.605     0.200
     1.885    31.862     0.200
     2.341    34.765     0.200
     2.609    40.409     0.200
     2.596    42.384     0.200
     2.688    42.249     0.200
     2.821    42.058     0.200
     3.142    48.318     0.200
     3.150    48.229     0.200
     3.589    55.588     0.200
     4.720    68.948     0.200
     7.203    99.187     0.200
     0.786    16.074     0.200
     1.145    19.897     0.200
     1.765    30.281     0.200
     1.869    32.602     0.200
     1.995    32.478     0.200
     2.056    33.066     0.200
     2.068    33.350     0.200
     2.438    39.793     0.200
     2.486    38.728     0.200
     2.575    41.715     0.200
     2.693    42.523     0.200
     2.721    42.566     0.200
     3.077    48.550     0.200
     3.137    49.040     0.200
     3.309    55.352     0.200
     3.470    53.346     0.200
     3.534    55.355     0.200
     3.637    54.719     0.200
     3.673    54.748     0.200
     0.779    21.678     0.200
     0.794    22.721     0.200
     0.995    24.106     0.200
     1.759    31.053     0.200
     1.759    29.284     0.200
     1.961    32.815     0.200
     1.961    31.405     0.200
     2.044    33.905     0.200
     2.044    34.735     0.200
     2.337    36.905     0.200
     2.564    38.615     0.200
     3.193    47.969     0.200
     3.193    43.569     0.200
     3.320    48.709     0.200
     3.791    55.898     0.200
     4.396    59.746     0.200
     7.900   106.975     0.200
     0.943    18.193     0.200
     1.109    19.965     0.200
     1.646    29.316     0.200
     1.691    29.265     0.200
     1.907    30.383     0.200
     2.361    37.208     0.200
     2.631    40.846     0.200
     2.709    42.460     0.200
     2.787    38.760     0.200
     2.800    42.781     0.200
     7.225    98.557     0.200
     0.926    19.574     0.200
     2.333    37.179     0.200
     2.587    39.480     0.200
     3.203    50.644     0.200
     4.329    63.072     0.200
     8.264   112.696     0.200
     1.531    28.231     0.200
     1.465    26.157     0.200
     2.454    41.529     0.200
     2.733    43.251     0.200
     4.180    63.493     0.200
     0.923    19.451     0.200
     8.363   120.236     0.200
     0.679    14.791     0.200
     1.360    23.191     0.200
     1.418    26.658     0.200
     1.493    26.952     0.200
     1.831    32.939     0.200
     2.179    35.737     0.200
     2.530    39.775     0.200
     2.623    39.354     0.200
     2.907    44.500     0.200
     2.978    45.693     0.200
     3.191    49.007     0.200
     7.501   101.195     0.200
     0.599    13.226     0.200
     0.599    13.390     0.200
     1.425    22.663     0.200
     2.502    34.902     0.200
     2.537    40.097     0.200
     3.247    49.251     0.200
     4.112    63.519     0.200
     4.171    62.564     0.200
     5.013    78.152     0.200
     5.165    74.512     0.200
     8.707   117.284     0.200
     0.733    16.178     0.200
     1.358    23.683     0.200
     2.138    34.935     0.200
     2.615    40.968     0.200
     2.872    45.216     0.200
     2.934    46.491     0.200
     3.367    52.608     0.200
     3.930    59.774     0.200
     4.726    69.114     0.200
     3.456    53.261     0.200
     4.712    67.086     0.200
     5.684    80.124     0.200
     7.004    95.865     0.200
     9.418   132.768     0.200
    18.926   244.762     0.200
     1.963    31.029     0.200
     1.983    33.993     0.200
     4.572    72.648     0.200
     4.667    69.477     0.200
     8.214   119.451     0.200
     1.021    22.773     0.200
     2.543    41.897     0.200
     2.615    43.350     0.200
     3.511    55.370     0.200
     5.293    77.489     0.200
     0.125    23.349     0.200
     0.361    21.940     0.200
     1.114    25.423     0.200
     1.862    29.727     0.200
     2.314    38.606     0.200
     2.592    41.079     0.200
     2.723    43.599     0.200
     3.321    50.958     0.200
     3.967    53.523     0.200
     4.454    70.812     0.200
     8.644   118.325     0.200
    13.336   178.022     0.200
     1.997    33.480     0.200
     1.997    32.640     0.200
     3.336    51.511     0.200
     4.456    68.220     0.200
     6.882    93.124     0.200
     1.462    24.404     0.200
     1.958    32.936     0.200
     2.221    36.740     0.200
     2.630    41.650     0.200
     3.267    50.851     0.200
     3.320    50.728     0.200
     3.659    56.126     0.200
     3.659    55.466     0.200
     3.723    57.128     0.200
     4.046    61.649     0.200
     2.274    35.897     0.200
     4.226    61.825     0.200
     1.051    21.534     0.200
     1.230    26.466     0.200
     1.979    31.923     0.200
     3.649    53.649     0.200
     3.807    62.229     0.200
     4.372    68.431     0.200
     4.565    67.046     0.200
     4.682    67.667     0.200
     4.853    78.122     0.200
     5.767    88.707     0.200
     8.230   112.967     0.200
     1.216    23.296     0.200
     2.102    33.533     0.200
     2.605    42.496     0.200
     3.070    47.520     0.200
     3.820    55.711     0.200
     3.960    61.434     0.200
     9.160   125.692     0.200
     0.957    20.800     0.200
     1.299    21.640     0.200
     2.642    41.489     0.200
     3.518    53.956     0.200
     4.467    67.837     0.200
     5.072    78.488     0.200
     5.307    78.901     0.200
     5.975    87.632     0.200
     6.055    88.165     0.200
     6.522    98.845     0.200
     7.075   100.898     0.200
     0.880    17.962     0.200
     1.305    22.432     0.200
     1.467    26.037     0.200
     1.585    27.812     0.200
     2.079    34.637     0.200
     2.576    37.777     0.200
     2.588    39.724     0.200
     3.130    44.617     0.200
     3.352    54.421     0.200
     3.423    52.663     0.200
     3.749    59.686     0.200
     3.838    62.303     0.200
     4.108    60.020     0.200
     4.805    66.527     0.200
     5.738    83.998     0.200
     6.751    92.992     0.200
     0.582    13.985     0.200
     1.344    21.891     0.200
     2.615    39.209     0.200
     2.544    41.595     0.200
     2.984    47.492     0.200
     4.026    57.313     0.200
     4.715    65.438     0.200
     1.169    25.398     0.200
     1.180    25.393     0.200
     1.212    26.341     0.200
     1.226    25.557     0.200
     1.916    33.035     0.200
     2.500    41.524     0.200
     3.288    53.508     0.200
     3.691    54.367     0.200
     3.847    60.151     0.200
     3.815    59.472     0.200
     4.035    65.156     0.200
     4.153    58.049     0.200
     4.172    62.709     0.200
     4.182    66.670     0.200
     4.203    64.533     0.200
     4.193    67.272     0.200
     4.199    60.243     0.200
     4.221    65.259     0.200
     4.283    61.431     0.200
     4.413    59.672     0.200
     4.309    64.663     0.200
     4.366    63.429     0.200
     4.413    61.963     0.200
     4.413    66.643     0.200
     4.445    70.595     0.200
     4.718    69.045     0.200
     4.666    70.530     0.200
     5.434    76.173     0.200
     5.522    81.391     0.200
     5.820    81.448     0.200
     6.391    99.579     0.200
     6.527    92.195     0.200
     7.309    99.340     0.200
     7.542   114.455     0.200
     8.261   117.239     0.200
    11.210   147.577     0.200
    11.333   149.096     0.200
     0.300    12.410     0.200
     0.867    17.697     0.200
     0.953    17.868     0.200
     1.057    20.083     0.200
     1.073    21.037     0.200
     1.077    20.160     0.200
     1.098    22.962     0.200
     1.120    21.296     0.200
     1.349    23.748     0.200
     1.806    28.277     0.200
     2.122    34.321     0.200
     2.640    40.579     0.200
     2.864    42.556     0.200
     3.076    45.064     0.200
     3.374    49.641     0.200
     3.434    52.228     0.200
     3.857    62.304     0.200
     4.187    56.960     0.200
     4.293    62.818     0.200
     4.280    62.028     0.200
     4.430    62.358     0.200
     7.968   105.595     0.200
     1.049    20.509     0.200
     1.107    21.690     0.200
     2.965    44.939     0.200
     3.173    45.567     0.200
     3.537    55.653     0.200
     3.729    58.881     0.200
     3.716    60.343     0.200
     3.763    58.417     0.200
     3.804    52.753     0.200
     3.818    61.007     0.200
     3.965    59.885     0.200
     4.015    63.679     0.200
     4.177    61.226     0.200
     4.175    66.507     0.200
     4.180    66.334     0.200
     4.187    66.681     0.200
     4.265    65.972     0.200
     4.345    67.427     0.200
     4.426    66.857     0.200
     4.619    69.197     0.200
     4.678    65.318     0.200
     5.761    84.390     0.200
     8.225   115.280     0.200
     0.874    16.952     0.200
     1.929    28.305     0.200
     1.983    30.136     0.200
     2.847    42.337     0.200
     3.200    46.357     0.200
     3.565    55.543     0.200
     3.649    54.843     0.200
     3.605    56.174     0.200
     3.703    55.975     0.200
     3.728    59.389     0.200
     3.871    57.627     0.200
     3.922    57.827     0.200
     4.090    63.603     0.200
     4.473    69.030     0.200
     4.530    70.115     0.200
     4.612    65.234     0.200
     4.974    70.458     0.200
     5.343    73.585     0.200
     5.722    79.511     0.200
     5.973    87.181     0.200
     0.774    16.500     0.200
     0.875    17.204     0.200
     1.263    21.243     0.200
     1.379    24.154     0.200
     1.490    27.020     0.200
     1.494    26.554     0.200
     1.493    26.792     0.200
     1.513    27.518     0.200
     1.559    25.646     0.200
     1.523    26.399     0.200
     1.618    27.727     0.200
     1.645    29.031     0.200
     1.999    33.224     0.200
     2.507    35.402     0.200
     2.737    42.359     0.200
     2.793    44.989     0.200
     3.024    44.525     0.200
     3.062    50.642     0.200
     3.202    53.183     0.200
     3.225    49.446     0.200
     3.596    50.942     0.200
     3.665    56.969     0.200
     3.699    56.142     0.200
     3.796    53.129     0.200
     3.829    56.074     0.200
     4.135    56.994     0.200
     4.607    61.269     0.200
     4.613    65.588     0.200
     4.936    71.693     0.200
     5.124    76.982     0.200
     6.361    89.082     0.200
     7.330    99.055     0.200
     0.564    13.152     0.200
     1.005    18.161     0.200
     1.754    29.840     0.200
     1.853    31.653     0.200
     1.957    32.461     0.200
     2.277    35.995     0.200
     2.510    37.808     0.200
     2.840    44.599     0.200
     3.037    49.253     0.200
     3.099    50.152     0.200
     3.143    49.574     0.200
     3.272    52.025     0.200
     3.393    48.574     0.200
     3.319    49.431     0.200
     3.316    53.011     0.200
     3.319    47.950     0.200
     3.396    54.499     0.200
     3.413    53.853     0.200
     3.466    55.192     0.200
     3.559    57.031     0.200
     3.579    56.989     0.200
     3.570    56.033     0.200
     3.587    55.769     0.200
     3.685    56.529     0.200
     3.684    52.067     0.200
     3.707    58.218     0.200
     3.817    54.916     0.200
     3.867    59.587     0.200
     3.865    62.479     0.200
     4.061    57.694     0.200
     4.412    63.525     0.200
     4.379    59.706     0.200
     4.489    66.978     0.200
     4.787    69.218     0.200
     5.432    75.535     0.200
     5.494    81.409     0.200
     5.452    82.506     0.200
     5.807    91.860     0.200
     6.289    85.249     0.200
     6.443    86.803     0.200
     7.232    98.214     0.200
     0.287    11.323     0.200
     1.770    26.746     0.200
     2.620    43.463     0.200
     2.620    39.513     0.200
     3.041    42.396     0.200
     2.830    47.167     0.200
     3.350    51.100     0.200
     3.350    50.130     0.200
     3.416    50.752     0.200
     3.354    55.917     0.200
     3.844    55.180     0.200
     4.280    63.266     0.200
     4.281    63.251     0.200
     4.404    63.207     0.200
     4.753    65.343     0.200
     5.074    71.598     0.200
     5.172    72.012     0.200
     5.217    77.961     0.200
     5.217    72.400     0.200
     5.529    78.159     0.200
     7.944   107.900     0.200
     0.798    15.779     0.200
     0.906    18.076     0.200
     1.395    21.670     0.200
     1.358    25.999     0.200
     1.362    23.653     0.200
     1.361    26.236     0.200
     1.437    23.857     0.200
     1.391    27.294     0.200
     1.490    26.189     0.200
     1.587    24.708     0.200
     1.661    27.909     0.200
     2.187    32.988     0.200
     2.294    36.634     0.200
     2.540    37.409     0.200
     2.639    37.436     0.200
     2.854    43.765     0.200
     2.898    47.144     0.200
     3.317    54.395     0.200
     3.405    52.548     0.200
     3.915    54.657     0.200
     3.953    57.402     0.200
     4.247    57.835     0.200
     4.198    65.125     0.200
     4.569    64.788     0.200
     4.736    63.686     0.200
     4.733    67.384     0.200
     4.926    68.080     0.200
     5.059    70.929     0.200
     5.231    74.056     0.200
     5.752    79.904     0.200
     5.733    82.320     0.200
     5.733    82.323     0.200
     6.751    89.547     0.200
     1.118    20.460     0.200
     1.314    22.728     0.200
     2.374    37.978     0.200
     2.423    40.786     0.200
     2.736    45.043     0.200
     2.902    44.951     0.200
     3.192    51.296     0.200
     3.708    57.361     0.200
     3.728    57.218     0.200
     4.061    62.474     0.200
     4.381    60.966     0.200
     4.488    65.169     0.200
     4.520    64.257     0.200
     4.834    65.535     0.200
     5.059    71.278     0.200
     0.973    21.881     0.200
     1.029    22.479     0.200
     1.074    23.465     0.200
     1.078    23.103     0.200
     1.071    23.167     0.200
     1.097    24.300     0.200
     1.120    24.083     0.200
     1.130    25.260     0.200
     1.788    31.702     0.200
     1.990    34.768     0.200
     2.779    47.851     0.200
     2.803    45.960     0.200
     2.840    46.927     0.200
     3.057    52.598     0.200
     3.319    57.274     0.200
     3.309    54.171     0.200
     3.364    57.280     0.200
     3.498    52.871     0.200
     3.454    56.892     0.200
     3.595    56.253     0.200
     3.644    62.224     0.200
     3.788    58.967     0.200
     3.790    58.657     0.200
     3.790    58.948     0.200
     3.887    65.185     0.200
     3.911    64.685     0.200
     4.010    67.726     0.200
     4.166    62.652     0.200
     4.219    67.419     0.200
     4.218    67.424     0.200
     4.261    66.926     0.200
     4.262    66.911     0.200
     4.263    67.948     0.200
     4.364    64.535     0.200
     4.404    67.571     0.200
     4.428    68.282     0.200
     4.748    69.217     0.200
     5.070    76.399     0.200
     5.183    75.464     0.200
     5.219    79.539     0.200
     5.337    79.393     0.200
     5.436    81.755     0.200
     5.448    81.675     0.200
     5.534    80.118     0.200
     5.737    83.177     0.200
     6.009    88.568     0.200
     6.202    87.552     0.200
     6.222    90.806     0.200
     6.221    90.809     0.200
     7.209   102.992     0.200
     7.942   112.417     0.200
     1.127    19.715     0.200
     1.678    28.162     0.200
     2.427    39.806     0.200
     2.640    41.729     0.200
     2.715    43.678     0.200
     2.901    42.626     0.200
     2.785    44.588     0.200
     3.165    49.276     0.200
     3.610    56.906     0.200
     3.695    53.046     0.200
     3.720    55.879     0.200
     3.601    58.342     0.200
     1.253    22.372     0.200
     1.307    23.860     0.200
     1.665    27.640     0.200
     1.873    31.775     0.200
     1.873    29.246     0.200
     2.079    32.647     0.200
     2.433    41.296     0.200
     2.823    44.627     0.200
     3.044    48.651     0.200
     3.141    49.818     0.200
     3.127    50.167     0.200
     3.628    55.227     0.200
     3.701    54.143     0.200
     4.069    62.089     0.200
     4.080    60.592     0.200
     4.266    65.660     0.200
     4.522    67.303     0.200
     4.523    67.288     0.200
     4.535    67.883     0.200
     4.536    67.877     0.200
     4.574    67.217     0.200
     4.944    70.874     0.200
     5.263    75.523     0.200
     5.288    79.378     0.200
     5.380    79.697     0.200
     5.661    78.577     0.200
     5.676    83.256     0.200
     5.718    85.602     0.200
     5.947    87.784     0.200
     6.177    94.044     0.200
     6.307    91.442     0.200
     7.037   103.929     0.200
     7.322   106.374     0.200
     8.121   116.742     0.200
     8.921   129.155     0.200
     0.922    18.757     0.200
     0.950    19.909     0.200
     1.077    22.049     0.200
     1.109    22.521     0.200
     1.657    26.401     0.200
     1.887    30.445     0.200
     2.817    43.625     0.200
     3.157    43.048     0.200
     2.971    45.312     0.200
     3.079    51.082     0.200
     3.620    56.884     0.200
     3.611    57.784     0.200
     4.066    56.853     0.200
     4.504    66.304     0.200
     4.505    66.298     0.200
     4.505    68.687     0.200
     0.911    18.678     0.200
     0.791    19.711     0.200
     1.017    20.755     0.200
     1.195    22.896     0.200
     1.262    25.479     0.200
     1.259    24.667     0.200
     1.269    25.408     0.200
     1.291    25.354     0.200
     1.314    24.578     0.200
     1.310    24.634     0.200
     1.432    25.712     0.200
     1.454    26.232     0.200
     1.508    24.867     0.200
     1.692    27.280     0.200
     2.106    34.206     0.200
     2.165    36.035     0.200
     2.499    38.169     0.200
     2.507    37.528     0.200
     2.724    39.476     0.200
     2.867    43.488     0.200
     2.878    43.119     0.200
     3.118    45.003     0.200
     3.220    45.751     0.200
     3.267    51.059     0.200
     3.693    57.931     0.200
     3.792    53.569     0.200
     3.932    54.538     0.200
     4.243    59.089     0.200
     4.566    63.843     0.200
     0.820    16.566     0.200
     1.146    19.406     0.200
     1.205    20.052     0.200
     1.537    25.970     0.200
     1.599    28.431     0.200
     1.594    28.336     0.200
     1.607    29.144     0.200
     1.626    30.087     0.200
     1.656    28.951     0.200
     1.763    28.052     0.200
     1.773    31.755     0.200
     1.794    28.510     0.200
     2.394    35.872     0.200
     2.503    39.637     0.200
     2.553    39.604     0.200
     2.881    45.669     0.200
     3.593    52.987     0.200
     3.644    53.263     0.200
     3.912    59.567     0.200
     1.168    23.848     0.200
     1.976    33.559     0.200
     2.156    36.311     0.200
     2.469    42.051     0.200
     2.502    43.138     0.200
     2.844    47.685     0.200
     3.205    52.363     0.200
     3.243    53.929     0.200
     3.283    55.185     0.200
     3.344    54.886     0.200
     3.423    56.322     0.200
     3.431    57.854     0.200
     3.440    58.209     0.200
     3.516    50.805     0.200
     3.536    52.513     0.200
     3.572    52.313     0.200
     3.614    51.838     0.200
     3.673    57.959     0.200
     3.621    57.925     0.200
     3.844    58.900     0.200
     3.940    64.635     0.200
     4.308    64.981     0.200
     4.587    72.484     0.200
     4.910    73.279     0.200
     5.131    75.193     0.200
     5.195    78.495     0.200
     5.216    79.445     0.200
     5.399    83.573     0.200
     5.484    77.081     0.200
     5.530    80.856     0.200
     6.118    87.337     0.200
     6.224    91.389     0.200
     6.352    95.416     0.200
     6.512    99.218     0.200
     6.846    99.014     0.200
     7.205   101.744     0.200
     8.414   117.086     0.200
     8.783   130.558     0.200
     9.754   133.906     0.200
     2.908    46.943     0.200
     3.116    49.102     0.200
     3.518    52.261     0.200
     3.563    54.471     0.200
     3.602    55.393     0.200
     3.675    58.669     0.200
     3.665    59.434     0.200
     3.851    57.971     0.200
     3.958    62.815     0.200
     4.066    64.078     0.200
     4.073    57.270     0.200
     4.073    65.930     0.200
     4.162    63.506     0.200
     4.170    61.157     0.200
     4.181    64.177     0.200
     4.240    68.024     0.200
     4.230    62.686     0.200
     4.312    66.451     0.200
     4.364    68.200     0.200
     4.524    65.789     0.200
     4.500    72.071     0.200
     4.517    67.749     0.200
     4.540    65.163     0.200
     4.564    70.565     0.200
     4.783    71.413     0.200
     5.262    83.704     0.200
     5.354    76.550     0.200
     5.650    81.791     0.200
     5.636    79.836     0.200
     5.922    86.128     0.200
     6.167    92.021     0.200
     6.281    87.157     0.200
     6.359    87.502     0.200
     7.051   103.915     0.200
     7.297   102.780     0.200
     7.527   109.596     0.200
     8.096   117.882     0.200
     2.451    39.441     0.200
     2.700    42.781     0.200
     2.890    45.192     0.200
     3.166    49.990     0.200
     3.493    52.986     0.200
     3.420    54.149     0.200
     3.861    54.113     0.200
     3.931    57.792     0.200
     3.972    57.266     0.200
     4.022    58.455     0.200
     4.275    60.822     0.200
     4.327    64.065     0.200
     4.424    65.603     0.200
     4.664    68.263     0.200
     4.995    68.949     0.200
     5.087    66.402     0.200
     5.264    75.349     0.200
     5.680    77.498     0.200
     5.909    75.445     0.200
     5.944    78.181     0.200
     5.992    76.942     0.200
     5.814    82.917     0.200
     6.264    85.468     0.200
     6.288    91.075     0.200
     7.001    97.192     0.200
     0.414    11.840     0.200
     0.901    16.142     0.200
     1.080    20.871     0.200
     1.239    19.742     0.200
     1.611    25.723     0.200
     1.524    24.013     0.200
     1.876    32.211     0.200
     1.901    31.309     0.200
     1.919    30.487     0.200
     1.876    29.638     0.200
     2.116    31.299     0.200
     2.338    36.920     0.200
     2.413    36.319     0.200
     2.623    40.192     0.200
     2.717    37.219     0.200
     2.872    43.895     0.200
     2.891    45.464     0.200
     3.195    46.850     0.200
     3.354    51.256     0.200
     3.063    46.513     0.200
     3.869    61.724     0.200
     4.874    77.761     0.200
     5.306    83.669     0.200
     5.601    83.537     0.200
     1.153    24.480     0.200
     1.625    29.110     0.200
     2.212    37.941     0.200
     2.198    36.949     0.200
     2.198    37.246     0.200
     2.413    39.228     0.200
     2.873    48.117     0.200
     2.979    49.405     0.200
     3.250    52.052     0.200
     3.430    54.876     0.200
     3.541    49.969     0.200
     3.499    58.138     0.200
     3.479    54.970     0.200
     3.578    57.372     0.200
     3.597    58.639     0.200
     3.603    53.351     0.200
     3.613    57.332     0.200
     3.751    62.238     0.200
     3.857    62.012     0.200
     3.881    59.844     0.200
     4.063    62.733     0.200
     4.563    72.326     0.200
     4.692    74.021     0.200
     4.853    71.905     0.200
     4.970    73.080     0.200
     5.043    73.393     0.200
     5.581    81.437     0.200
     6.089    91.739     0.200
     7.441   100.401     0.200
     0.948    16.766     0.200
     0.923    18.809     0.200
     0.929    20.689     0.200
     0.938    21.161     0.200
     0.947    21.205     0.200
     0.962    21.953     0.200
     0.982    22.053     0.200
     1.020    21.656     0.200
     1.126    23.037     0.200
     1.220    22.623     0.200
     1.540    28.199     0.200
     1.859    29.358     0.200
     1.913    35.022     0.200
     2.377    38.025     0.200
     3.063    48.582     0.200
     3.122    50.079     0.200
     3.148    49.958     0.200
     3.467    52.592     0.200
     3.546    56.329     0.200
     4.117    61.672     0.200
     4.501    70.196     0.200
     4.824    69.757     0.200
     5.386    79.419     0.200
     5.451    73.045     0.200
     0.916    18.944     0.200
     0.959    19.559     0.200
     1.909    31.719     0.200
     2.426    40.705     0.200
     2.849    46.760     0.200
     3.178    46.612     0.200
     3.560    54.606     0.200
     3.617    54.455     0.200
     3.652    57.823     0.200
     3.736    57.072     0.200
     3.715    56.241     0.200
     3.938    61.535     0.200
     4.100    56.474     0.200
     4.542    64.795     0.200
     4.971    71.539     0.200
     5.291    75.584     0.200
     5.411    77.591     0.200
     5.709    85.912     0.200
     0.980    19.810     0.200
     1.023    20.210     0.200
     3.043    49.959     0.200
     3.832    60.419     0.200
     3.919    57.633     0.200
     4.075    60.871     0.200
     4.251    58.659     0.200
     4.519    69.540     0.200
     4.562    69.886     0.200
     4.581    72.836     0.200
     4.934    69.449     0.200
     5.252    72.340     0.200
     5.272    71.879     0.200
     5.367    69.920     0.200
     5.663    77.133     0.200
     5.938    86.217     0.200
     3.334    54.417     0.200
     3.682    59.802     0.200
     3.915    65.245     0.200
     3.989    60.429     0.200
     4.185    65.606     0.200
     4.323    63.268     0.200
     4.450    72.194     0.200
     4.557    74.228     0.200
     4.972    81.113     0.200
     5.229    76.864     0.200
     5.268    80.658     0.200
     5.550    84.091     0.200
     5.873    82.515     0.200
     0.901    19.579     0.200
     1.161    22.967     0.200
     1.153    23.691     0.200
     1.202    26.203     0.200
     1.217    26.660     0.200
     1.219    24.477     0.200
     1.541    26.634     0.200
     2.173    35.273     0.200
     3.029    43.181     0.200
     3.057    49.944     0.200
     3.238    47.335     0.200
     3.649    56.478     0.200
     3.710    59.123     0.200
     3.752    59.295     0.200
     3.795    59.422     0.200
     4.027    63.241     0.200
     4.118    64.966     0.200
     4.135    63.529     0.200
     4.143    58.723     0.200
     4.197    63.296     0.200
     4.230    61.219     0.200
     4.361    60.814     0.200
     4.381    71.311     0.200
     4.564    64.135     0.200
     4.580    72.014     0.200
     4.602    73.265     0.200
     4.628    66.959     0.200
     4.657    71.816     0.200
     5.006    71.382     0.200
     5.340    76.231     0.200
     5.382    76.898     0.200
     5.464    80.861     0.200
     5.729    80.557     0.200
     5.764    85.577     0.200
     5.613    85.888     0.200
     5.999    82.269     0.200
     6.020    83.573     0.200
     6.160    92.986     0.200
     6.328    96.913     0.200
     6.402    86.659     0.200
     6.469    90.404     0.200
     6.746   100.386     0.200
     6.942    98.410     0.200
     7.249   100.313     0.200
     7.416   102.695     0.200
     7.348   100.240     0.200
     7.855   115.800     0.200
     7.806   110.913     0.200
     8.865   128.643     0.200
     8.828   132.796     0.200
     9.369   132.552     0.200
     9.674   135.646     0.200
     9.636   138.418     0.200
     9.917   141.963     0.200
    10.487   145.745     0.200
    10.941   159.068     0.200
    12.539   168.642     0.200
    12.697   171.947     0.200
    13.443   186.679     0.200
    14.401   194.349     0.200
    14.695   193.052     0.200
     0.318    11.268     0.200
     1.074    18.924     0.200
     1.152    22.114     0.200
     1.184    21.209     0.200
     1.233    23.273     0.200
     1.199    22.990     0.200
     1.203    23.549     0.200
     1.222    23.537     0.200
     1.259    22.971     0.200
     1.245    23.527     0.200
     1.254    24.399     0.200
     1.363    22.973     0.200
     1.829    31.872     0.200
     2.957    48.833     0.200
     3.351    54.293     0.200
     4.683    64.971     0.200
     5.004    66.629     0.200
     5.451    73.719     0.200
     1.195    20.197     0.200
     2.254    33.363     0.200
     2.459    35.888     0.200
     2.731    40.949     0.200
     2.904    44.011     0.200
     3.045    47.895     0.200
     3.586    47.908     0.200
     3.506    55.222     0.200
     3.541    56.274     0.200
     3.565    51.702     0.200
     3.590    56.459     0.200
     3.613    55.304     0.200
     3.554    53.854     0.200
     4.015    63.922     0.200
    11.377   159.031     0.200
     0.849    18.858     0.200
     1.111    20.333     0.200
     1.333    22.452     0.200
     1.431    25.269     0.200
     1.350    24.627     0.200
     1.505    24.310     0.200
     1.474    25.425     0.200
     1.481    26.862     0.200
     1.489    27.337     0.200
     1.507    27.874     0.200
     1.527    26.740     0.200
     1.673    26.576     0.200
     1.655    28.528     0.200
     1.693    27.664     0.200
     1.866    29.622     0.200
     2.290    34.108     0.200
     2.405    34.440     0.200
     2.517    37.559     0.200
     2.628    38.942     0.200
     2.636    41.970     0.200
     2.745    39.923     0.200
     2.907    42.151     0.200
     3.030    46.187     0.200
     3.571    51.444     0.200
     0.470    16.986     0.200
     0.603    19.158     0.200
     0.604    18.746     0.200
     0.617    18.505     0.200
     0.643    19.012     0.200
     0.655    19.370     0.200
     0.694    18.501     0.200
     0.730    17.973     0.200
     0.728    18.502     0.200
     0.712    18.076     0.200
     1.442    24.747     0.200
     1.685    28.037     0.200
     1.780    28.603     0.200
     2.014    33.327     0.200
     2.170    32.037     0.200
     2.365    35.111     0.200
     2.830    41.896     0.200
     2.917    42.646     0.200
     3.082    44.914     0.200
     3.419    47.517     0.200
     3.593    52.657     0.200
     3.591    53.716     0.200
     3.952    56.142     0.200
     4.366    70.733     0.200
     4.504    62.105     0.200
     4.659    63.458     0.200
     4.964    66.781     0.200
     5.287    70.662     0.200
     5.480    73.438     0.200
     5.818    79.362     0.200
     5.924    80.299     0.200
     0.552    13.519     0.200
     1.550    25.020     0.200
     2.813    46.261     0.200
     3.343    48.753     0.200
     3.562    57.871     0.200
     3.915    54.810     0.200
     3.999    61.622     0.200
     4.137    57.061     0.200
     4.165    57.389     0.200
     4.261    68.212     0.200
     4.479    61.763     0.200
     4.800    67.643     0.200
     4.929    68.499     0.200
     4.953    70.497     0.200
     0.475    10.287     0.200
     2.338    38.544     0.200
     2.542    39.801     0.200
     3.170    48.159     0.200
     3.609    54.364     0.200
     3.508    56.919     0.200
     3.957    59.022     0.200
     4.154    61.103     0.200
     4.100    64.375     0.200
     4.154    59.909     0.200
     4.218    66.762     0.200
     4.304    65.466     0.200
     4.344    66.619     0.200
     4.360    63.559     0.200
     4.401    68.620     0.200
     4.437    68.823     0.200
     4.486    71.323     0.200
     4.724    65.423     0.200
     4.663    71.720     0.200
     4.755    70.461     0.200
     4.755    70.631     0.200
     4.717    72.227     0.200
     4.784    73.091     0.200
     4.784    74.501     0.200
     4.787    72.037     0.200
     4.968    69.941     0.200
     5.308    73.982     0.200
     5.629    78.057     0.200
     5.743    79.217     0.200
     5.783    80.592     0.200
     5.927    86.142     0.200
     5.984    89.945     0.200
     6.099    84.541     0.200
     6.291    90.423     0.200
     6.529    88.643     0.200
     8.504   114.540     0.200
     9.155   131.577     0.200
     1.198    23.205     0.200
     1.337    24.734     0.200
     1.682    27.470     0.200
     1.846    30.364     0.200
     1.952    36.304     0.200
     2.071    33.878     0.200
     2.101    35.289     0.200
     2.443    40.649     0.200
     2.831    46.403     0.200
     3.289    49.269     0.200
     3.380    50.883     0.200
     3.697    56.121     0.200
     3.856    56.895     0.200
     3.911    52.150     0.200
     4.185    64.006     0.200
     4.507    59.532     0.200
     4.733    67.484     0.200
     4.986    77.858     0.200
     5.091    69.492     0.200
     5.126    76.708     0.200
     0.267    10.976     0.200
     1.060    19.955     0.200
     1.115    21.831     0.200
     1.120    22.257     0.200
     1.163    22.557     0.200
     1.166    21.815     0.200
     1.171    22.288     0.200
     1.330    23.368     0.200
     1.384    25.443     0.200
     1.786    31.837     0.200
     1.730    31.670     0.200
     2.640    44.049     0.200
     3.057    44.434     0.200
     3.436    53.865     0.200
     3.600    54.053     0.200
     3.865    59.985     0.200
     4.170    58.401     0.200
     4.773    60.414     0.200
     5.094    66.189     0.200
     5.188    72.327     0.200
     5.236    73.661     0.200
     5.547    78.708     0.200
     2.341    39.567     0.200
     2.797    46.631     0.200
     3.193    50.904     0.200
     3.459    56.158     0.200
     3.597    58.375     0.200
     4.069    59.343     0.200
     4.116    66.545     0.200
     4.116    64.622     0.200
     4.347    66.999     0.200
     4.374    67.419     0.200
     4.522    71.244     0.200
     4.611    72.730     0.200
     4.676    75.079     0.200
     4.684    74.409     0.200
     4.730    72.209     0.200
     4.753    77.031     0.200
     4.853    75.955     0.200
     4.870    76.852     0.200
     4.916    77.184     0.200
     5.140    77.587     0.200
     5.140    81.077     0.200
     5.168    79.256     0.200
     5.168    81.546     0.200
     5.169    77.606     0.200
     5.182    73.673     0.200
     5.234    80.280     0.200
     5.409    79.376     0.200
     5.441    80.419     0.200
     5.736    86.017     0.200
     5.966    90.138     0.200
     6.058    91.474     0.200
     6.197    92.422     0.200
     6.199    91.188     0.200
     6.244    92.430     0.200
     6.226    87.799     0.200
     6.259    95.721     0.200
     6.392    96.106     0.200
     6.547    95.938     0.200
     6.709    94.695     0.200
     7.219   106.663     0.200
     7.361   107.750     0.200
     0.684    14.593     0.200
     0.807    16.676     0.200
     1.319    21.871     0.200
     1.650    27.825     0.200
     1.726    29.600     0.200
     1.765    30.652     0.200
     1.778    31.439     0.200
     1.816    30.200     0.200
     1.985    33.641     0.200
     2.404    39.750     0.200
     2.390    39.456     0.200
     3.373    56.215     0.200
     3.505    46.249     0.200
     3.804    52.824     0.200
     3.806    54.647     0.200
     3.784    60.663     0.200
     3.819    62.047     0.200
     3.826    61.801     0.200
     3.871    61.780     0.200
     4.184    52.745     0.200
     0.305    11.528     0.200
     1.016    18.593     0.200
     1.090    20.797     0.200
     1.138    22.211     0.200
     1.197    22.304     0.200
     1.184    23.282     0.200
     1.353    23.459     0.200
     1.773    30.698     0.200
     3.013    46.698     0.200
     3.340    55.300     0.200
     3.555    57.461     0.200
     3.643    50.808     0.200
     3.819    57.809     0.200
     4.126    57.466     0.200
     4.221    61.516     0.200
     4.221    64.647     0.200
     4.252    65.066     0.200
     4.252    68.626     0.200
     4.256    62.884     0.200
     4.312    66.835     0.200
     4.376    58.620     0.200
     4.726    63.613     0.200
     5.144    67.438     0.200
     5.189    71.445     0.200
     5.501    73.795     0.200
     5.718    78.441     0.200
     6.163    79.671     0.200
     0.889    17.802     0.200
     1.094    21.046     0.200
     1.026    22.288     0.200
     2.160    32.878     0.200
     2.715    41.677     0.200
     3.282    46.918     0.200
     3.593    57.433     0.200
     3.603    58.974     0.200
     3.992    64.305     0.200
     4.308    64.150     0.200
     4.692    70.618     0.200
     1.205    25.475     0.200
     1.239    26.950     0.200
     1.254    27.322     0.200
     1.560    29.012     0.200
     2.476    38.562     0.200
     2.814    44.234     0.200
     3.088    51.419     0.200
     3.048    51.471     0.200
     3.108    46.550     0.200
     3.336    51.611     0.200
     3.317    54.910     0.200
     3.502    58.410     0.200
     3.648    54.933     0.200
     3.908    57.080     0.200
     4.107    63.775     0.200
     4.142    62.627     0.200
     4.924    74.611     0.200
     5.249    80.793     0.200
     5.422    81.567     0.200
     0.694    14.161     0.200
     0.858    17.549     0.200
     1.331    25.533     0.200
     1.173    20.821     0.200
     1.440    26.045     0.200
     1.531    26.971     0.200
     1.444    26.139     0.200
     1.450    26.860     0.200
     1.486    27.448     0.200
     1.500    27.280     0.200
     1.556    27.597     0.200
     1.834    30.473     0.200
     2.595    40.762     0.200
     2.885    45.762     0.200
     2.959    47.618     0.200
     3.128    46.551     0.200
     3.250    49.600     0.200
     3.315    50.833     0.200
     3.404    51.055     0.200
     3.699    51.422     0.200
     3.594    57.593     0.200
     3.810    58.511     0.200
     3.810    59.751     0.200
     3.842    60.547     0.200
     3.842    60.737     0.200
     3.848    58.344     0.200
     3.938    56.206     0.200
     3.959    57.943     0.200
     3.900    59.873     0.200
     0.789    16.999     0.200
     0.781    16.837     0.200
     1.268    21.476     0.200
     1.466    24.448     0.200
     2.527    38.831     0.200
     2.801    44.659     0.200
     2.873    47.181     0.200
     3.055    45.786     0.200
     3.318    53.976     0.200
     3.627    49.551     0.200
     3.856    52.780     0.200
     3.880    56.045     0.200
     4.205    56.486     0.200
     4.526    62.314     0.200
     4.642    65.023     0.200
     4.670    61.363     0.200
     4.986    65.949     0.200
     1.101    24.188     0.200
     1.354    23.782     0.200
     1.371    25.289     0.200
     1.521    26.222     0.200
     1.597    28.632     0.200
     1.606    29.789     0.200
     1.628    28.705     0.200
     1.678    29.202     0.200
     1.719    25.074     0.200
     1.784    29.454     0.200
     1.855    32.206     0.200
     1.793    33.650     0.200
     2.492    41.617     0.200
     2.568    42.348     0.200
     2.895    42.063     0.200
     2.828    45.704     0.200
     2.931    45.180     0.200
     3.182    52.004     0.200
     3.246    46.459     0.200
     3.246    50.537     0.200
     3.311    48.957     0.200
     3.497    45.333     0.200
     3.558    50.507     0.200
     3.635    48.427     0.200
     3.843    54.822     0.200
     4.165    57.953     0.200
     4.381    61.237     0.200
     4.335    62.583     0.200
     4.479    57.298     0.200
     4.735    64.612     0.200
     4.796    67.651     0.200
     5.483    73.886     0.200
     6.459    84.089     0.200
     1.108    22.505     0.200
     1.185    24.510     0.200
     1.184    24.290     0.200
     1.517    26.486     0.200
     1.889    31.723     0.200
     2.035    34.536     0.200
     2.876    46.007     0.200
     2.957    44.194     0.200
     3.305    51.009     0.200
     3.675    53.478     0.200
     3.759    57.981     0.200
     3.809    59.564     0.200
     4.198    60.816     0.200
     4.601    65.900     0.200
     4.637    71.363     0.200
     4.728    66.725     0.200
     4.692    75.245     0.200
     5.084    75.213     0.200
     5.404    75.278     0.200
     5.530    83.492     0.200
     5.831    85.707     0.200
     6.083    89.036     0.200
     1.074    22.237     0.200
     1.162    22.418     0.200
     2.029    32.958     0.200
     1.915    31.860     0.200
     2.974    44.983     0.200
     2.929    47.864     0.200
     3.297    49.988     0.200
     3.188    52.436     0.200
     3.686    58.886     0.200
     3.857    59.405     0.200
     3.837    61.724     0.200
     3.812    56.927     0.200
     4.007    63.883     0.200
     4.058    63.366     0.200
     4.114    65.400     0.200
     4.195    67.064     0.200
     4.202    61.966     0.200
     4.223    63.354     0.200
     4.217    65.432     0.200
     4.229    68.174     0.200
     4.317    68.817     0.200
     4.330    70.037     0.200
     4.422    62.063     0.200
     4.388    68.669     0.200
     4.468    70.740     0.200
     4.527    71.013     0.200
     4.664    70.776     0.200
     4.703    74.993     0.200
     4.731    73.386     0.200
     4.729    70.567     0.200
     4.547    71.706     0.200
     5.097    71.979     0.200
     5.090    78.089     0.200
     5.416    75.923     0.200
     5.535    79.071     0.200
     5.772    89.539     0.200
     6.082    88.722     0.200
     6.099    86.277     0.200
     6.463    94.436     0.200
     7.326   101.199     0.200
     7.569   112.060     0.200
     7.871   117.837     0.200
     8.276   110.549     0.200
     8.276   114.406     0.200
     9.991   142.725     0.200
    10.143   138.444     0.200
    11.013   155.835     0.200
     1.392    25.948     0.200
     2.220    37.962     0.200
     2.397    39.103     0.200
     2.575    43.339     0.200
     3.362    55.740     0.200
     3.634    54.799     0.200
     3.842    56.668     0.200
     3.759    56.962     0.200
     4.162    65.757     0.200
     4.203    64.482     0.200
     4.401    63.176     0.200
     4.442    70.352     0.200
     4.491    70.782     0.200
     4.620    71.644     0.200
     4.632    71.580     0.200
     4.635    73.690     0.200
     4.640    72.369     0.200
     4.650    72.356     0.200
     4.688    65.942     0.200
     4.741    72.669     0.200
     4.745    73.819     0.200
     4.772    75.228     0.200
     4.823    71.267     0.200
     4.967    69.001     0.200
     4.976    78.753     0.200
     5.086    79.026     0.200
     5.095    80.756     0.200
     5.114    80.240     0.200
     5.115    79.039     0.200
     5.115    79.803     0.200
     5.254    74.903     0.200
     5.231    75.491     0.200
     5.608    79.921     0.200
     5.929    85.178     0.200
     6.300    92.916     0.200
     6.368    89.932     0.200
     6.398    97.669     0.200
     6.600    89.770     0.200
     6.624    97.121     0.200
     6.863    99.439     0.200
     7.007    93.833     0.200
     7.069    99.633     0.200
     7.069    99.636     0.200
     7.836   109.598     0.200
     8.022   114.887     0.200
     8.522   124.333     0.200
     8.797   123.103     0.200
     8.797   128.244     0.200
     9.455   130.521     0.200
    10.678   143.279     0.200
    11.539   164.962     0.200
     0.462    11.988     0.200
     1.877    31.634     0.200
     1.927    31.927     0.200
     2.158    34.577     0.200
     2.552    40.800     0.200
     2.688    43.178     0.200
     2.709    41.909     0.200
     2.997    44.010     0.200
     3.186    49.476     0.200
     3.276    47.916     0.200
     3.567    54.418     0.200
     3.584    52.419     0.200
     3.949    60.798     0.200
     3.968    55.702     0.200
     4.284    59.673     0.200
     4.297    60.189     0.200
     4.385    60.298     0.200
     4.679    69.552     0.200
     4.950    72.911     0.200
     4.981    72.620     0.200
     5.073    74.455     0.200
     5.316    72.609     0.200
     5.390    75.567     0.200
     6.329    86.354     0.200
     1.147    24.759     0.200
     1.217    26.682     0.200
     1.250    26.409     0.200
     1.223    26.321     0.200
     1.266    27.029     0.200
     1.274    28.216     0.200
     1.762    29.738     0.200
     3.033    49.697     0.200
     3.387    52.060     0.200
     3.471    53.038     0.200
     3.430    52.255     0.200
     3.585    53.847     0.200
     3.529    53.663     0.200
     3.752    54.796     0.200
     3.697    62.014     0.200
     3.915    60.595     0.200
     4.342    70.296     0.200
     4.469    71.351     0.200
     4.796    71.789     0.200
     5.116    78.746     0.200
     2.268    35.916     0.200
     2.554    42.251     0.200
     2.928    48.200     0.200
     3.062    47.132     0.200
     3.519    48.718     0.200
     3.692    55.356     0.200
     3.794    60.394     0.200
     4.032    56.811     0.200
     4.043    58.838     0.200
     4.240    65.072     0.200
     4.465    69.297     0.200
     4.605    66.620     0.200
     4.758    66.231     0.200
     5.061    74.166     0.200
     5.384    76.587     0.200
     5.579    85.128     0.200
     5.612    83.649     0.200
     5.918    91.946     0.200
     6.019    85.712     0.200
     1.204    21.667     0.200
     1.792    30.324     0.200
     2.009    33.037     0.200
     2.020    33.554     0.200
     2.029    34.109     0.200
     2.371    38.922     0.200
     2.450    39.648     0.200
     2.621    43.499     0.200
     2.648    43.665     0.200
     2.874    47.231     0.200
     2.866    45.965     0.200
     3.038    47.690     0.200
     3.120    45.199     0.200
     3.063    49.947     0.200
     3.065    49.493     0.200
     3.082    50.276     0.200
     3.087    48.652     0.200
     3.142    47.861     0.200
     3.090    46.889     0.200
     3.092    50.079     0.200
     3.089    49.470     0.200
     3.161    51.163     0.200
     3.157    48.272     0.200
     3.192    46.983     0.200
     3.235    52.431     0.200
     3.236    51.848     0.200
     3.337    52.279     0.200
     3.387    51.742     0.200
     3.407    51.433     0.200
     3.406    50.052     0.200
     3.381    51.472     0.200
     3.601    54.994     0.200
     3.786    56.556     0.200
     3.772    57.459     0.200
     3.872    59.536     0.200
     3.912    61.933     0.200
     3.928    62.664     0.200
     4.103    63.060     0.200
     4.210    63.880     0.200
     4.326    65.518     0.200
     4.509    68.061     0.200
     4.529    70.839     0.200
     4.799    74.223     0.200
     4.776    75.453     0.200
     5.158    71.759     0.200
     5.216    77.432     0.200
     5.202    74.530     0.200
     6.014    87.292     0.200
     6.168    85.005     0.200
     6.657    94.834     0.200
     6.955   100.981     0.200
     8.669   122.357     0.200
     9.689   138.171     0.200
     9.820   138.098     0.200
    11.565   164.236     0.200
     0.883    15.566     0.200
     1.175    21.153     0.200
     1.108    18.577     0.200
     1.618    26.409     0.200
     1.595    27.453     0.200
     1.582    28.329     0.200
     1.585    28.152     0.200
     1.615    28.953     0.200
     1.707    29.387     0.200
     1.707    31.031     0.200
     1.969    33.509     0.200
     2.429    35.589     0.200
     2.696    38.388     0.200
     2.954    40.503     0.200
     2.836    42.252     0.200
     3.070    50.533     0.200
     3.218    45.186     0.200
     3.334    49.903     0.200
     3.526    52.386     0.200
     3.644    57.407     0.200
     3.650    61.012     0.200
     3.662    55.577     0.200
     3.751    54.056     0.200
     3.775    54.863     0.200
     4.100    58.431     0.200
     4.564    68.768     0.200
     4.881    64.496     0.200
     0.600    13.090     0.200
     0.880    19.432     0.200
     0.961    19.439     0.200
     0.917    20.548     0.200
     0.997    21.464     0.200
     1.882    34.594     0.200
     2.657    44.365     0.200
     3.136    49.548     0.200
     3.186    50.088     0.200
     3.332    45.433     0.200
     3.330    48.870     0.200
     3.349    49.030     0.200
     3.208    49.849     0.200
     3.518    56.129     0.200
     3.652    56.013     0.200
     3.733    56.652     0.200
     4.124    62.910     0.200
     4.157    59.165     0.200
     4.155    62.552     0.200
     4.225    58.261     0.200
     4.397    66.085     0.200
     4.443    67.360     0.200
     4.714    72.195     0.200
     1.139    21.909     0.200
     1.166    22.279     0.200
     1.653    27.426     0.200
     1.982    34.263     0.200
     2.232    35.229     0.200
     2.467    36.419     0.200
     2.702    44.023     0.200
     2.712    44.874     0.200
     2.920    43.429     0.200
     2.954    44.205     0.200
     3.202    49.193     0.200
     3.260    51.206     0.200
     3.294    46.616     0.200
     3.455    49.116     0.200
     3.456    50.821     0.200
     3.507    55.584     0.200
     3.578    56.313     0.200
     3.642    56.656     0.200
     3.651    52.431     0.200
     3.653    57.402     0.200
     3.663    59.947     0.200
     3.670    56.083     0.200
     3.685    51.835     0.200
     3.694    50.094     0.200
     4.026    56.900     0.200
     4.112    64.005     0.200
     4.115    66.208     0.200
     4.122    61.982     0.200
     4.258    63.739     0.200
     4.283    64.846     0.200
     4.269    67.860     0.200
     4.602    65.020     0.200
     4.923    69.399     0.200
     5.042    71.572     0.200
     5.073    71.854     0.200
     5.291    75.641     0.200
     5.389    79.880     0.200
     5.591    76.352     0.200
     6.061    83.824     0.200
     6.828    94.267     0.200
     7.796   105.739     0.200
     1.193    26.228     0.200
     1.197    26.585     0.200
     1.210    26.633     0.200
     1.221    26.521     0.200
     1.348    28.666     0.200
     1.495    28.861     0.200
     2.009    36.963     0.200
     2.510    40.254     0.200
     3.016    49.376     0.200
     3.048    48.458     0.200
     2.988    50.636     0.200
     3.151    52.311     0.200
     3.092    51.276     0.200
     4.039    64.922     0.200
     4.070    62.914     0.200
     4.150    68.695     0.200
     4.270    63.982     0.200
     4.590    73.207     0.200
     4.858    70.543     0.200
     5.174    79.898     0.200
     0.933    18.497     0.200
     0.993    20.358     0.200
     2.587    43.125     0.200
     3.321    53.171     0.200
     3.619    58.492     0.200
     3.621    55.653     0.200
     3.622    58.759     0.200
     3.632    58.164     0.200
     4.002    64.280     0.200
     4.341    65.528     0.200
     4.319    57.671     0.200
     4.424    68.832     0.200
     4.720    68.060     0.200
     5.014    74.498     0.200
     1.345    27.503     0.200
     2.525    39.326     0.200
     2.578    43.020     0.200
     2.742    38.989     0.200
     2.802    43.630     0.200
     2.890    43.548     0.200
     2.920    44.846     0.200
     2.955    47.121     0.200
     3.024    48.120     0.200
     3.007    46.762     0.200
     3.050    49.617     0.200
     3.117    51.441     0.200
     3.157    48.257     0.200
     3.378    52.590     0.200
     3.515    55.244     0.200
     3.536    51.896     0.200
     3.643    57.913     0.200
     4.057    58.529     0.200
     4.093    58.865     0.200
     4.169    63.696     0.200
     4.285    63.952     0.200
     4.605    68.200     0.200
     4.831    67.652     0.200
     4.875    69.665     0.200
     5.051    72.150     0.200
     5.186    75.566     0.200
     5.253    75.402     0.200
     5.842    80.385     0.200
     6.039    83.009     0.200
     6.447    94.024     0.200
     7.473   109.858     0.200
     0.282     9.667     0.200
     0.918    17.175     0.200
     0.996    19.199     0.200
     1.102    20.798     0.200
     1.099    21.867     0.200
     1.107    21.730     0.200
     1.382    24.729     0.200
     1.370    24.872     0.200
     1.841    29.113     0.200
     2.044    30.359     0.200
     2.109    34.104     0.200
     3.111    45.955     0.200
     3.410    52.385     0.200
     3.362    51.404     0.200
     3.470    51.158     0.200
     3.499    47.968     0.200
     3.521    58.707     0.200
     3.652    54.233     0.200
     3.657    51.531     0.200
     3.708    54.318     0.200
     3.780    54.019     0.200
     3.817    56.495     0.200
     3.892    54.770     0.200
     3.985    61.194     0.200
     4.222    58.677     0.200
     4.292    64.132     0.200
     4.279    58.020     0.200
     4.277    64.499     0.200
     4.327    59.806     0.200
     4.384    66.942     0.200
     4.466    64.289     0.200
     4.439    63.323     0.200
     4.489    66.911     0.200
     4.812    68.008     0.200
     5.133    73.432     0.200
     5.240    71.060     0.200
     5.280    76.643     0.200
     0.051    20.067     0.200
     0.209    19.722     0.200
     0.232    19.823     0.200
     0.521    18.325     0.200
     1.145    22.067     0.200
     1.231    22.370     0.200
     1.734    29.094     0.200
     2.465    36.108     0.200
     3.494    49.610     0.200
     4.137    54.926     0.200
     4.127    61.756     0.200
     4.266    57.553     0.200
     4.261    59.395     0.200
     4.540    64.842     0.200
     4.908    70.957     0.200
     4.908    77.407     0.200
     4.944    73.222     0.200
     4.955    72.786     0.200
     5.215    69.427     0.200
     5.332    70.328     0.200
     5.612    74.083     0.200
     5.935    77.959     0.200
     6.155    79.521     0.200
     6.217    82.500     0.200
     6.504    86.786     0.200
     6.548    86.546     0.200
     0.242    11.103     0.200
     0.866    16.449     0.200
     0.966    19.325     0.200
     1.070    20.576     0.200
     1.081    21.444     0.200
     1.088    21.264     0.200
     1.421    24.677     0.200
     1.894    28.663     0.200
     1.988    29.979     0.200
     2.204    35.761     0.200
     2.819    44.392     0.200
     2.865    46.211     0.200
     3.165    46.431     0.200
     3.472    53.271     0.200
     3.533    53.015     0.200
     3.708    53.696     0.200
     3.771    54.479     0.200
     3.955    58.327     0.200
     4.278    59.070     0.200
     4.291    64.382     0.200
     4.339    64.002     0.200
     4.390    66.544     0.200
     4.527    63.636     0.200
     4.548    70.970     0.200
     4.537    68.001     0.200
     4.874    68.868     0.200
     5.195    72.381     0.200
     5.296    68.879     0.200
     5.340    76.823     0.200
     5.563    81.551     0.200
     5.653    81.313     0.200
     5.864    85.973     0.200
     5.917    87.371     0.200
     1.047    21.731     0.200
     1.142    23.878     0.200
     1.198    25.890     0.200
     3.583    55.500     0.200
     3.666    59.422     0.200
     3.775    59.934     0.200
     4.106    66.348     0.200
     4.466    70.314     0.200
     4.546    67.157     0.200
     4.631    70.166     0.200
     4.992    77.709     0.200
     5.312    74.405     0.200
     5.439    82.772     0.200
     5.699    87.014     0.200
     5.741    81.276     0.200
     5.991    84.544     0.200
     6.382    93.467     0.200
     6.444    97.767     0.200
     7.221   102.362     0.200
     8.176   114.335     0.200
     1.063    21.906     0.200
     1.157    21.984     0.200
     1.220    25.085     0.200
     1.965    32.034     0.200
     3.235    48.206     0.200
     3.608    56.235     0.200
     3.695    56.064     0.200
     3.792    54.494     0.200
     4.138    65.676     0.200
     4.358    60.524     0.200
     4.498    67.597     0.200
     4.542    69.833     0.200
     4.571    69.786     0.200
     4.660    66.350     0.200
     4.654    71.252     0.200
     4.632    73.478     0.200
     4.690    69.923     0.200
     4.753    70.706     0.200
     4.782    74.796     0.200
     5.338    73.142     0.200
     5.462    78.965     0.200
     5.728    82.855     0.200
     5.762    84.865     0.200
     6.018    89.791     0.200
     1.007    20.986     0.200
     2.136    35.995     0.200
     2.472    39.782     0.200
     2.508    42.023     0.200
     2.679    41.899     0.200
     2.929    47.151     0.200
     3.095    48.937     0.200
     3.240    50.480     0.200
     3.217    51.291     0.200
     3.260    53.113     0.200
     3.328    54.706     0.200
     3.430    54.511     0.200
     3.570    56.291     0.200
     3.695    56.752     0.200
     3.703    57.483     0.200
     3.716    57.816     0.200
     3.719    57.329     0.200
     3.718    57.599     0.200
     3.719    57.485     0.200
     3.804    58.733     0.200
     3.749    57.641     0.200
     3.747    57.680     0.200
     3.768    61.202     0.200
     3.768    58.040     0.200
     3.805    58.922     0.200
     3.830    59.356     0.200
     3.840    60.487     0.200
     3.870    60.566     0.200
     3.896    60.458     0.200
     3.947    61.102     0.200
     4.121    62.393     0.200
     4.111    64.505     0.200
     4.128    62.548     0.200
     4.145    64.563     0.200
     4.146    64.549     0.200
     4.193    65.541     0.200
     4.232    65.689     0.200
     4.253    65.510     0.200
     4.253    65.517     0.200
     4.565    71.166     0.200
     4.673    71.764     0.200
     4.693    73.906     0.200
     4.827    70.473     0.200
     4.930    74.391     0.200
     5.220    75.728     0.200
     5.246    78.369     0.200
     5.415    78.254     0.200
     5.439    86.618     0.200
     5.521    82.736     0.200
     5.845    84.765     0.200
     5.893    81.984     0.200
     5.935    86.555     0.200
     5.935    86.558     0.200
     5.944    88.257     0.200
     5.964    86.146     0.200
     6.091    88.912     0.200
     6.067    87.090     0.200
     6.327    94.991     0.200
     6.738    97.565     0.200
     6.861    96.481     0.200
     7.504   111.210     0.200
     7.677   113.801     0.200
     7.677   106.098     0.200
     7.677   107.698     0.200
     9.202   130.803     0.200
     9.853   138.674     0.200
    10.607   146.162     0.200
    10.638   146.487     0.200
    10.730   149.480     0.200
    11.227   155.947     0.200
    11.289   154.554     0.200
    12.277   173.376     0.200
    13.102   179.813     0.200
     1.196    27.002     0.200
     1.339    29.341     0.200
     1.428    30.150     0.200
     1.963    37.035     0.200
     2.728    46.401     0.200
     2.869    49.134     0.200
     3.143    52.083     0.200
     3.322    51.571     0.200
     3.366    57.115     0.200
     3.481    58.638     0.200
     4.021    63.879     0.200
     4.040    67.644     0.200
     4.127    65.956     0.200
     1.107    23.726     0.200
     1.185    24.579     0.200
     1.512    27.458     0.200
     2.964    49.423     0.200
     3.310    53.685     0.200
     3.682    58.182     0.200
     3.709    60.430     0.200
     3.709    58.619     0.200
     3.765    60.526     0.200
     3.816    57.672     0.200
     3.868    60.981     0.200
     3.982    65.066     0.200
     4.148    64.028     0.200
     4.176    61.057     0.200
     4.205    64.507     0.200
     4.204    60.677     0.200
     4.219    64.607     0.200
     4.307    64.883     0.200
     4.304    66.996     0.200
     4.364    64.951     0.200
     4.434    69.295     0.200
     2.651    43.575     0.200
     3.089    46.150     0.200
     3.086    49.174     0.200
     3.862    61.095     0.200
     4.057    64.806     0.200
     4.215    65.196     0.200
     4.464    70.196     0.200
     4.483    69.468     0.200
     4.489    68.638     0.200
     4.493    69.737     0.200
     4.496    70.458     0.200
     4.533    68.704     0.200
     4.533    70.661     0.200
     4.613    72.256     0.200
     4.671    70.943     0.200
     4.816    74.836     0.200
     4.907    67.970     0.200
     5.237    79.403     0.200
     5.226    75.035     0.200
     5.337    78.066     0.200
     5.630    87.791     0.200
     5.630    82.686     0.200
     6.201    93.068     0.200
     6.256    83.928     0.200
     0.799    17.388     0.200
     1.010    18.221     0.200
     1.289    20.522     0.200
     1.513    26.723     0.200
     1.475    24.845     0.200
     1.641    27.809     0.200
     1.913    31.177     0.200
     2.367    37.425     0.200
     2.503    34.241     0.200
     2.665    40.883     0.200
     2.695    42.917     0.200
     3.000    42.559     0.200
     2.967    45.463     0.200
     3.057    45.546     0.200
     3.107    47.192     0.200
     3.573    49.093     0.200
     3.507    51.735     0.200
     3.533    52.046     0.200
     3.535    51.406     0.200
     3.537    52.000     0.200
     3.541    54.221     0.200
     3.729    54.053     0.200
     3.776    53.409     0.200
     4.051    55.038     0.200
     4.374    59.815     0.200
     4.576    59.332     0.200
     4.549    62.718     0.200
     4.882    68.713     0.200
     5.030    71.051     0.200
     1.584    24.046     0.200
     1.596    26.716     0.200
     1.694    29.004     0.200
     1.702    27.813     0.200
     2.213    36.133     0.200
     2.229    35.024     0.200
     2.366    38.298     0.200
     2.610    42.315     0.200
     3.083    46.128     0.200
     3.177    49.969     0.200
     3.174    48.250     0.200
     3.241    51.825     0.200
     3.321    51.843     0.200
     3.440    55.092     0.200
     3.695    57.305     0.200
     3.698    55.698     0.200
     3.703    59.450     0.200
     3.726    59.849     0.200
     3.737    58.499     0.200
     3.804    60.004     0.200
     3.819    57.451     0.200
     3.982    61.362     0.200
     3.988    59.020     0.200
     4.075    62.090     0.200
     4.074    61.827     0.200
     4.088    61.284     0.200
     4.098    60.027     0.200
     4.103    61.599     0.200
     4.109    61.693     0.200
     4.117    65.606     0.200
     4.248    63.295     0.200
     4.275    63.683     0.200
     4.461    69.833     0.200
     4.755    71.434     0.200
     4.759    71.130     0.200
     4.777    70.689     0.200
     4.872    72.062     0.200
     5.159    71.722     0.200
     5.203    76.033     0.200
     5.397    77.747     0.200
     5.475    76.252     0.200
     5.778    84.190     0.200
     5.862    84.238     0.200
     5.877    86.339     0.200
     6.094    94.199     0.200
     7.622   108.150     0.200
     1.719    29.746     0.200
     3.838    59.986     0.200
     4.581    72.123     0.200
     5.010    78.061     0.200
     8.186   115.098     0.200
     0.250    11.058     0.200
     1.118    21.217     0.200
     1.121    22.519     0.200
     1.383    23.632     0.200
     1.400    24.974     0.200
     1.676    27.053     0.200
     1.839    27.648     0.200
     2.043    31.941     0.200
     2.688    42.026     0.200
     2.895    41.445     0.200
     2.854    47.208     0.200
     3.110    45.834     0.200
     3.398    56.623     0.200
     3.483    52.258     0.200
     3.653    52.445     0.200
     3.839    62.592     0.200
     3.874    61.650     0.200
     3.882    57.537     0.200
     4.004    66.464     0.200
     4.223    61.491     0.200
     4.305    64.930     0.200
     4.308    66.591     0.200
     4.345    70.043     0.200
     4.436    69.089     0.200
     4.474    63.164     0.200
     4.822    66.191     0.200
     5.143    69.855     0.200
     5.241    71.792     0.200
     5.287    77.125     0.200
     5.514    80.456     0.200
     5.599    81.544     0.200
     5.813    86.705     0.200
     6.261    82.372     0.200
     6.290    84.437     0.200
     6.851   105.094     0.200
     7.049   102.093     0.200
     7.269    98.884     0.200
     7.259   105.074     0.200
     8.014   109.666     0.200
     8.014   114.994     0.200
     8.694   122.132     0.200
     1.440    22.856     0.200
     1.530    25.409     0.200
     1.988    30.672     0.200
     2.237    36.681     0.200
     2.818    45.823     0.200
     2.863    45.500     0.200
     3.043    46.629     0.200
     3.259    47.683     0.200
     3.480    49.770     0.200
     3.503    50.665     0.200
     3.496    54.987     0.200
     3.555    52.668     0.200
     3.627    55.134     0.200
     3.778    55.191     0.200
     3.800    57.745     0.200
     3.831    56.540     0.200
     3.933    55.298     0.200
     3.975    60.065     0.200
     3.978    58.942     0.200
     4.083    58.443     0.200
     4.090    62.203     0.200
     4.110    58.849     0.200
     4.162    60.390     0.200
     4.184    58.662     0.200
     4.240    61.434     0.200
     4.240    64.403     0.200
     4.371    64.088     0.200
     4.380    65.851     0.200
     4.379    65.856     0.200
     4.421    64.647     0.200
     4.443    64.387     0.200
     4.449    62.381     0.200
     4.450    65.400     0.200
     4.451    65.238     0.200
     4.451    63.596     0.200
     4.454    66.019     0.200
     4.455    66.004     0.200
     4.612    64.794     0.200
     4.638    66.556     0.200
     4.954    68.120     0.200
     5.276    74.278     0.200
     5.388    73.661     0.200
     5.426    77.059     0.200
     5.623    83.841     0.200
     5.637    78.838     0.200
     5.742    79.199     0.200
     5.941    83.179     0.200
     5.916    85.925     0.200
     6.200    90.152     0.200
     6.408    89.387     0.200
     6.429    93.618     0.200
     6.429    93.620     0.200
     6.732   100.457     0.200
     7.241   107.206     0.200
     7.415   101.247     0.200
     0.488    12.549     0.200
     0.970    18.535     0.200
     1.201    23.125     0.200
     1.714    30.440     0.200
     1.811    28.384     0.200
     2.006    30.308     0.200
     2.226    33.461     0.200
     2.522    38.037     0.200
     2.618    39.651     0.200
     2.656    43.314     0.200
     2.570    40.634     0.200
     2.661    41.490     0.200
     2.715    39.765     0.200
     2.755    39.828     0.200
     2.746    43.100     0.200
     2.918    44.959     0.200
     2.964    44.765     0.200
     2.930    44.235     0.200
     3.095    50.041     0.200
     3.112    47.301     0.200
     3.113    48.793     0.200
     3.119    48.232     0.200
     3.139    49.077     0.200
     3.221    52.261     0.200
     3.235    50.675     0.200
     3.268    51.195     0.200
     3.289    52.211     0.200
     3.327    44.085     0.200
     3.264    53.397     0.200
     3.307    50.864     0.200
     3.399    51.275     0.200
     3.513    53.146     0.200
     3.521    56.638     0.200
     3.526    54.393     0.200
     3.539    48.515     0.200
     3.531    57.307     0.200
     3.536    52.722     0.200
     3.538    52.707     0.200
     3.571    49.395     0.200
     3.533    56.962     0.200
     3.631    55.546     0.200
     3.673    56.350     0.200
     3.673    56.357     0.200
     3.700    51.579     0.200
     3.725    56.409     0.200
     3.932    53.586     0.200
     3.957    58.036     0.200
     4.342    61.547     0.200
     4.382    59.221     0.200
     4.650    64.560     0.200
     4.934    69.170     0.200
     5.361    70.441     0.200
     5.386    74.444     0.200
     5.386    74.447     0.200
     5.615    77.116     0.200
     6.366    84.379     0.200
     6.294    86.490     0.200
     7.115    94.554     0.200
     7.115    95.839     0.200
     7.127    99.046     0.200
     7.383   105.026     0.200
     7.570   108.060     0.200
     9.000   118.419     0.200
    10.086   132.590     0.200
    10.113   132.838     0.200
    10.208   136.277     0.200
    13.351   170.183     0.200
    13.351   178.468     0.200
     0.870    20.615     0.200
     1.145    22.471     0.200
     1.136    23.697     0.200
     1.154    23.830     0.200
     1.256    23.693     0.200
     1.635    26.664     0.200
     1.635    30.584     0.200
     1.989    31.471     0.200
     1.989    31.041     0.200
     1.907    32.176     0.200
     2.332    37.579     0.200
     2.283    37.488     0.200
     2.589    41.886     0.200
     2.589    40.825     0.200
     2.657    39.397     0.200
     2.672    41.392     0.200
     2.842    45.902     0.200
     2.882    42.704     0.200
     2.869    46.324     0.200
     2.899    47.343     0.200
     3.042    46.076     0.200
     3.037    46.804     0.200
     3.053    47.385     0.200
     3.176    50.065     0.200
     3.229    52.233     0.200
     3.324    50.632     0.200
     3.385    50.014     0.200
     3.356    51.455     0.200
     3.372    51.980     0.200
     3.372    51.754     0.200
     3.379    52.654     0.200
     3.419    55.805     0.200
     3.438    50.872     0.200
     3.478    53.296     0.200
     3.482    52.190     0.200
     3.512    58.262     0.200
     3.561    53.656     0.200
     3.573    55.608     0.200
     3.770    60.477     0.200
     3.831    58.607     0.200
     3.834    57.037     0.200
     3.860    58.900     0.200
     3.861    57.823     0.200
     3.863    58.152     0.200
     3.862    57.861     0.200
     3.863    59.748     0.200
     3.957    54.147     0.200
     3.973    62.778     0.200
     3.973    58.188     0.200
     4.049    57.127     0.200
     4.052    60.339     0.200
     4.108    58.151     0.200
     4.108    56.051     0.200
     4.742    67.783     0.200
     4.928    68.003     0.200
     4.881    76.617     0.200
     4.961    71.098     0.200
     5.071    71.963     0.200
     5.265    75.406     0.200
     5.388    75.533     0.200
     5.392    83.996     0.200
     5.603    79.700     0.200
     5.604    86.541     0.200
     5.924    83.348     0.200
     5.924    83.350     0.200
     5.975    84.645     0.200
     6.636    93.491     0.200
     6.717    98.377     0.200
     6.789    99.765     0.200
     6.968    94.725     0.200
     7.293   104.695     0.200
     7.623   102.669     0.200
     7.623   106.165     0.200
     8.568   124.618     0.200
     9.126   127.559     0.200
     9.335   125.577     0.200
     9.556   128.407     0.200
     9.570   135.288     0.200
    10.374   140.565     0.200
    10.651   142.055     0.200
    10.675   142.244     0.200
    10.773   142.648     0.200
    11.243   150.626     0.200
    12.356   162.072     0.200
    13.674   180.247     0.200
     1.413    29.877     0.200
     1.559    29.677     0.200
     1.546    29.065     0.200
     2.049    36.719     0.200
     2.999    51.552     0.200
     3.193    52.660     0.200
     3.515    59.688     0.200
     4.048    61.702     0.200
     4.092    67.502     0.200
     2.061    33.326     0.200
     2.177    35.342     0.200
     2.415    36.121     0.200
     2.691    42.450     0.200
     2.751    45.011     0.200
     2.819    46.023     0.200
     3.058    47.368     0.200
     3.410    53.285     0.200
     3.429    53.494     0.200
     3.431    52.225     0.200
     3.442    52.302     0.200
     3.447    52.237     0.200
     3.463    53.418     0.200
     3.505    56.493     0.200
     3.991    63.360     0.200
     4.057    62.232     0.200
     4.523    72.723     0.200
     4.806    74.098     0.200
     5.189    77.358     0.200
     1.224    20.820     0.200
     2.095    33.653     0.200
     2.216    36.374     0.200
     2.494    37.892     0.200
     2.677    40.529     0.200
     3.026    48.978     0.200
     3.051    47.464     0.200
     3.510    55.409     0.200
     3.466    56.018     0.200
     3.617    50.463     0.200
     3.934    57.519     0.200
     3.962    60.148     0.200
     3.963    60.133     0.200
     4.098    66.517     0.200
     4.099    66.510     0.200
     4.316    62.352     0.200
     4.633    71.145     0.200
     4.736    66.548     0.200
     4.700    72.214     0.200
     5.028    72.843     0.200
     5.054    79.075     0.200
     5.658    85.053     0.200
     5.741    90.017     0.200
     6.210    95.332     0.200
     6.544    87.080     0.200
     7.409   110.866     0.200
     7.843   119.889     0.200
     9.197   134.073     0.200
     9.338   127.130     0.200
     9.271   133.732     0.200
     9.845   144.885     0.200
    10.215   142.072     0.200
     1.045    20.550     0.200
     2.496    37.069     0.200
     3.561    51.612     0.200
     3.505    53.182     0.200
     4.350    61.793     0.200
     4.529    62.085     0.200
     4.563    68.329     0.200
     4.864    72.298     0.200
     5.003    72.852     0.200
     0.482    12.676     0.200
     0.973    18.213     0.200
     1.749    28.202     0.200
     1.807    29.476     0.200
     1.991    30.388     0.200
     1.919    30.701     0.200
     2.213    31.916     0.200
     2.470    38.321     0.200
     2.552    39.785     0.200
     2.732    39.979     0.200
     2.637    41.414     0.200
     2.955    45.198     0.200
     3.013    41.505     0.200
     3.141    49.507     0.200
     3.304    44.714     0.200
     3.422    53.929     0.200
     3.439    51.291     0.200
     3.461    52.960     0.200
     3.545    51.415     0.200
     4.197    56.628     0.200
     4.316    57.622     0.200
     4.338    61.027     0.200
     4.654    64.960     0.200
     4.874    64.916     0.200
     5.334    71.653     0.200
     5.341    72.918     0.200
     6.104    80.934     0.200
     6.336    82.167     0.200
     7.065    94.142     0.200
     7.065    92.603     0.200
     1.284    28.107     0.200
     1.417    30.260     0.200
     1.567    29.798     0.200
     2.018    37.473     0.200
     2.179    38.519     0.200
     2.922    49.871     0.200
     3.081    48.377     0.200
     3.089    50.103     0.200
     3.149    51.983     0.200
     3.466    59.080     0.200
     3.492    55.681     0.200
     4.000    61.792     0.200
     4.047    63.916     0.200
     4.115    65.295     0.200
     4.223    63.626     0.200
     4.542    66.898     0.200
     4.589    75.017     0.200
     4.764    73.222     0.200
     4.817    74.877     0.200
     5.001    76.291     0.200
     5.120    78.563     0.200
     5.196    80.809     0.200
     5.781    86.282     0.200
     5.987    88.368     0.200
     5.980    92.059     0.200
     6.240    96.441     0.200
     1.289    28.524     0.200
     1.584    30.836     0.200
     2.526    44.464     0.200
     2.812    46.464     0.200
     2.918    48.884     0.200
     3.039    50.785     0.200
     3.078    48.366     0.200
     3.162    52.611     0.200
     3.332    56.556     0.200
     3.454    58.199     0.200
     3.459    56.174     0.200
     3.973    62.917     0.200
     4.010    64.465     0.200
     4.085    65.072     0.200
     4.202    68.327     0.200
     4.522    68.644     0.200
     4.629    72.881     0.200
     4.751    73.197     0.200
     4.791    76.493     0.200
     4.967    76.891     0.200
     5.105    77.899     0.200
     5.168    80.732     0.200
     5.758    88.618     0.200
     5.955    92.266     0.200
     6.028    92.435     0.200
     6.415    99.818     0.200
     0.662    14.803     0.200
     1.153    20.479     0.200
     1.891    31.512     0.200
     2.393    35.438     0.200
     2.626    43.143     0.200
     2.908    42.361     0.200
     3.129    49.897     0.200
     3.481    48.789     0.200
     3.684    55.341     0.200
     3.715    56.570     0.200
     4.026    57.453     0.200
     1.246    23.928     0.200
     2.311    36.842     0.200
     3.160    51.396     0.200
     3.453    54.977     0.200
     3.479    57.544     0.200
     3.531    56.129     0.200
     3.927    62.409     0.200
     3.934    62.483     0.200
     3.938    62.550     0.200
     3.940    62.067     0.200
     3.962    62.441     0.200
     3.965    63.163     0.200
     3.973    62.474     0.200
     4.024    61.886     0.200
     4.032    65.125     0.200
     4.086    64.288     0.200
     4.244    66.018     0.200
     4.352    66.632     0.200
     4.357    69.863     0.200
     4.365    69.808     0.200
     4.367    68.423     0.200
     4.376    66.408     0.200
     4.447    68.033     0.200
     4.453    70.429     0.200
     4.540    64.443     0.200
     4.704    70.775     0.200
     4.749    71.383     0.200
     4.807    73.535     0.200
     0.901    19.443     0.200
     2.435    37.389     0.200
     2.687    41.163     0.200
     2.754    42.774     0.200
     2.956    43.798     0.200
     3.046    48.082     0.200
     3.198    49.158     0.200
     3.529    50.400     0.200
     3.604    56.703     0.200
     3.625    56.627     0.200
     3.630    57.778     0.200
     3.633    55.831     0.200
     3.636    57.016     0.200
     3.641    54.932     0.200
     3.743    55.831     0.200
     3.771    55.632     0.200
     4.089    59.760     0.200
     4.410    61.073     0.200
     4.541    63.586     0.200
     4.558    65.473     0.200
     4.877    69.761     0.200
     5.082    67.000     0.200
     5.558    77.211     0.200
     0.849    16.733     0.200
     1.211    20.719     0.200
     1.597    29.027     0.200
     1.671    29.472     0.200
     1.722    31.968     0.200
     1.722    29.788     0.200
     2.245    35.637     0.200
     2.335    34.449     0.200
     2.466    36.570     0.200
     2.992    44.895     0.200
     3.025    49.220     0.200
     3.238    52.716     0.200
     3.251    45.871     0.200
     3.245    51.620     0.200
     3.248    50.602     0.200
     3.268    52.576     0.200
     3.269    52.882     0.200
     3.283    52.193     0.200
     3.366    54.533     0.200
     3.564    50.581     0.200
     3.657    56.753     0.200
     3.657    58.753     0.200
     3.683    55.131     0.200
     3.788    52.702     0.200
     3.813    54.185     0.200
     3.758    55.976     0.200
     3.757    55.982     0.200
     3.866    57.014     0.200
     4.137    57.415     0.200
     4.198    67.496     0.200
     4.457    60.601     0.200
     4.577    62.389     0.200
     4.602    64.091     0.200
     4.837    70.237     0.200
     4.919    67.707     0.200
     4.940    75.336     0.200
     5.131    71.809     0.200
     5.596    72.428     0.200
     5.605    76.947     0.200
     5.605    76.950     0.200
     5.594    87.753     0.200
     6.364    83.800     0.200
     6.599    86.377     0.200
     7.066   102.111     0.200
     7.178   103.327     0.200
     7.327   100.073     0.200
     7.327    95.858     0.200
     7.983   106.182     0.200
     9.042   122.038     0.200
     9.224   123.374     0.200
     9.505   132.857     0.200
    10.071   146.678     0.200
    13.515   176.314     0.200
     1.177    24.264     0.200
     2.100    35.811     0.200
     2.386    40.053     0.200
     2.485    41.180     0.200
     2.624    41.376     0.200
     2.702    42.969     0.200
     2.803    48.117     0.200
     2.961    50.225     0.200
     3.372    55.348     0.200
     3.372    55.788     0.200
     3.386    54.576     0.200
     3.396    55.297     0.200
     3.401    52.729     0.200
     3.381    56.625     0.200
     3.406    55.823     0.200
     3.573    55.502     0.200
     0.458    12.317     0.200
     1.133    21.021     0.200
     1.285    23.730     0.200
     1.302    22.670     0.200
     1.370    25.612     0.200
     1.394    25.333     0.200
     1.527    24.410     0.200
     2.354    34.759     0.200
     2.582    38.128     0.200
     2.798    46.434     0.200
     3.118    48.031     0.200
     3.106    50.881     0.200
     3.160    52.649     0.200
     3.196    51.035     0.200
     3.340    50.104     0.200
     3.480    56.225     0.200
     3.620    56.576     0.200
     3.620    59.901     0.200
     3.624    58.488     0.200
     3.627    59.330     0.200
     3.643    57.638     0.200
     3.646    60.270     0.200
     3.652    56.200     0.200
     3.626    58.836     0.200
     3.664    56.722     0.200
     3.669    54.649     0.200
     3.708    56.207     0.200
     3.742    61.135     0.200
     3.750    61.703     0.200
     3.810    53.704     0.200
     3.945    63.067     0.200
     4.045    64.242     0.200
     4.045    66.902     0.200
     4.067    61.975     0.200
     4.071    65.265     0.200
     4.074    62.220     0.200
     4.077    67.859     0.200
     4.169    59.075     0.200
     4.105    61.709     0.200
     4.185    57.811     0.200
     4.403    65.073     0.200
     4.438    65.485     0.200
     4.524    62.176     0.200
     4.845    68.419     0.200
     4.929    66.869     0.200
     4.980    68.256     0.200
     5.229    72.207     0.200
     5.289    73.278     0.200
     5.259    82.906     0.200
     5.521    75.811     0.200
     5.829    84.078     0.200
     5.984    86.381     0.200
     6.753    91.751     0.200
     7.057   106.906     0.200
     7.241   106.296     0.200
     7.608   112.845     0.200
     7.712   103.681     0.200
     9.426   127.309     0.200
     9.598   128.742     0.200
    10.453   143.225     0.200
     0.953    18.234     0.200
     0.805    18.901     0.200
     1.288    23.011     0.200
     1.414    22.683     0.200
     1.408    23.494     0.200
     1.406    26.725     0.200
     1.519    27.011     0.200
     1.486    24.828     0.200
     2.254    28.855     0.200
     2.598    37.484     0.200
     2.628    35.126     0.200
     2.841    47.043     0.200
     2.795    45.031     0.200
     3.067    48.837     0.200
     3.124    46.116     0.200
     3.265    54.051     0.200
     3.265    50.067     0.200
     4.480    60.817     0.200
     4.663    62.593     0.200
     4.698    63.218     0.200
     4.817    67.460     0.200
     4.999    68.908     0.200
     5.659    75.975     0.200
     7.360    96.774     0.200
     1.212    20.377     0.200
     1.510    25.543     0.200
     1.653    28.117     0.200
     1.765    29.414     0.200
     2.384    36.918     0.200
     2.406    33.576     0.200
     2.697    41.987     0.200
     2.769    39.768     0.200
     2.918    44.660     0.200
     3.124    48.435     0.200
     3.261    52.369     0.200
     3.489    46.934     0.200
     3.656    57.615     0.200
     3.680    57.998     0.200
     3.684    59.311     0.200
     3.689    55.910     0.200
     3.741    52.598     0.200
     3.756    53.823     0.200
     3.861    60.573     0.200
     4.101    55.346     0.200
     4.421    58.416     0.200
     4.506    60.713     0.200
     4.552    65.198     0.200
     4.861    68.369     0.200
     5.103    77.200     0.200
     5.556    76.571     0.200
     1.045    20.455     0.200
     1.766    30.013     0.200
     2.732    40.009     0.200
     3.053    43.482     0.200
     3.538    55.234     0.200
     3.611    53.263     0.200
     3.965    59.790     0.200
     3.977    64.305     0.200
     4.106    66.086     0.200
     4.177    59.433     0.200
     4.398    67.360     0.200
     4.419    61.143     0.200
     4.424    65.728     0.200
     4.427    67.020     0.200
     4.430    64.994     0.200
     4.482    64.368     0.200
     4.484    67.553     0.200
     4.852    68.775     0.200
     5.171    71.633     0.200
     5.288    76.868     0.200
     5.570    85.315     0.200
     5.585    78.162     0.200
     5.603    84.872     0.200
     1.057    19.201     0.200
     1.059    21.015     0.200
     1.596    26.883     0.200
     1.841    29.507     0.200
     2.291    31.317     0.200
     2.529    36.554     0.200
     2.527    37.915     0.200
     2.596    40.251     0.200
     2.588    41.676     0.200
     2.665    41.093     0.200
     2.805    42.242     0.200
     2.902    48.148     0.200
     3.038    49.415     0.200
     3.045    44.781     0.200
     3.184    50.418     0.200
     3.378    48.842     0.200
     3.452    54.031     0.200
     3.472    50.584     0.200
     3.481    50.005     0.200
     3.485    55.773     0.200
     3.660    57.087     0.200
     3.929    49.719     0.200
     4.250    57.716     0.200
     4.388    60.679     0.200
     4.399    59.186     0.200
     4.389    67.349     0.200
     4.719    67.918     0.200
     4.923    70.853     0.200
     1.069    23.316     0.200
     1.968    33.733     0.200
     2.898    47.831     0.200
     3.237    50.280     0.200
     3.701    58.100     0.200
     3.795    58.590     0.200
     3.765    60.677     0.200
     4.145    64.352     0.200
     4.361    65.766     0.200
     4.506    70.248     0.200
     4.585    70.397     0.200
     4.572    70.470     0.200
     4.659    70.242     0.200
     5.023    73.386     0.200
     5.343    76.040     0.200
     5.466    80.385     0.200
     5.766    85.287     0.200
     6.024    87.531     0.200
     2.077    33.163     0.200
     2.762    46.288     0.200
     2.895    46.222     0.200
     3.051    50.470     0.200
     2.998    48.042     0.200
     3.104    51.407     0.200
     3.551    58.196     0.200
     3.660    55.238     0.200
     3.751    58.209     0.200
     4.455    71.968     0.200
     4.521    71.389     0.200
     4.717    75.539     0.200
     4.886    73.963     0.200
     5.206    82.055     0.200
     5.248    80.641     0.200
     5.329    84.448     0.200
     5.593    86.846     0.200
     5.598    86.655     0.200
     5.629    82.662     0.200
     5.705    80.082     0.200
     6.100    94.851     0.200
     6.203    93.184     0.200
     6.267    90.441     0.200
     6.334    97.199     0.200
     6.333    97.202     0.200
     6.343    89.288     0.200
     7.006   101.631     0.200
     7.281   106.771     0.200
     7.461   112.779     0.200
     7.436   104.447     0.200
     7.787   115.763     0.200
     8.067   113.385     0.200
     8.067   117.416     0.200
     8.146   117.487     0.200
     9.782   144.260     0.200
    11.462   164.320     0.200
    12.219   165.739     0.200
    12.792   180.844     0.200
    13.008   184.723     0.200
    21.706   283.661     0.200
    22.019   285.395     0.200
    22.085   287.582     0.200
     2.675    46.166     0.200
     2.756    46.975     0.200
     3.685    60.586     0.200
     3.771    60.607     0.200
     4.012    66.421     0.200
     4.039    64.501     0.200
     4.128    61.154     0.200
     4.366    64.632     0.200
     4.468    71.936     0.200
     4.509    74.135     0.200
     4.514    68.083     0.200
     4.552    73.082     0.200
     4.554    71.111     0.200
     4.619    72.814     0.200
     4.626    72.886     0.200
     4.772    75.554     0.200
     4.809    76.132     0.200
     4.847    75.456     0.200
     4.907    79.254     0.200
     4.907    79.260     0.200
     4.954    78.382     0.200
     4.981    75.844     0.200
     4.982    76.145     0.200
     4.984    76.685     0.200
     4.984    77.830     0.200
     4.987    78.029     0.200
     4.993    80.571     0.200
     4.988    78.014     0.200
     5.103    74.899     0.200
     5.170    77.484     0.200
     5.461    81.276     0.200
     5.782    83.725     0.200
     5.831    84.143     0.200
     5.912    87.982     0.200
     6.159    91.487     0.200
     6.214    92.280     0.200
     6.353   100.633     0.200
     6.456    94.747     0.200
     6.850    98.690     0.200
     6.917    96.944     0.200
     6.917    96.947     0.200
     8.648   116.450     0.200
     1.123    21.523     0.200
     1.826    30.367     0.200
     2.718    41.994     0.200
     3.008    46.555     0.200
     3.136    48.886     0.200
     3.991    61.681     0.200
     3.989    59.857     0.200
     4.134    59.070     0.200
     4.397    67.017     0.200
     4.415    65.851     0.200
     4.422    66.273     0.200
     4.426    65.570     0.200
     4.429    67.416     0.200
     4.451    64.304     0.200
     4.455    65.534     0.200
     4.603    68.108     0.200
     4.793    70.033     0.200
     1.165    22.941     0.200
     1.689    28.819     0.200
     2.251    37.098     0.200
     2.672    45.199     0.200
     2.955    44.692     0.200
     3.185    50.261     0.200
     3.518    51.553     0.200
     3.480    54.742     0.200
     3.891    62.007     0.200
     3.947    61.296     0.200
     4.081    61.066     0.200
     4.400    66.201     0.200
     4.373    67.303     0.200
     4.405    66.037     0.200
     4.380    67.349     0.200
     4.384    67.303     0.200
     4.388    67.256     0.200
     4.394    67.453     0.200
     4.453    69.314     0.200
     4.561    69.670     0.200
     4.652    72.358     0.200
     4.783    72.909     0.200
     0.921    19.010     0.200
     1.081    21.191     0.200
     1.662    28.646     0.200
     2.033    34.276     0.200
     2.778    45.561     0.200
     2.942    47.205     0.200
     3.140    47.628     0.200
     3.579    55.402     0.200
     3.693    54.960     0.200
     3.702    59.944     0.200
     4.020    63.998     0.200
     4.261    64.637     0.200
     4.424    68.676     0.200
     4.447    65.787     0.200
     4.451    70.452     0.200
     4.453    67.281     0.200
     4.455    69.750     0.200
     4.635    70.656     0.200
     1.105    20.373     0.200
     1.834    31.875     0.200
     2.985    47.477     0.200
     3.476    56.835     0.200
     3.961    61.811     0.200
     3.961    64.472     0.200
     4.793    66.878     0.200
     5.515    85.251     0.200
     5.799    88.874     0.200
     1.386    23.121     0.200
     2.825    46.469     0.200
     3.130    51.843     0.200
     3.257    51.889     0.200
     3.464    55.344     0.200
     3.800    61.125     0.200
     3.864    61.826     0.200
     3.870    61.816     0.200
     3.932    61.414     0.200
     3.911    60.039     0.200
     4.307    67.871     0.200
     4.330    67.305     0.200
     4.338    66.486     0.200
     4.339    67.337     0.200
     4.342    69.276     0.200
     4.341    65.638     0.200
     4.350    67.514     0.200
     4.358    68.201     0.200
     4.366    67.927     0.200
     4.370    67.980     0.200
     4.378    67.486     0.200
     4.384    67.727     0.200
     4.382    68.779     0.200
     4.419    68.344     0.200
     4.452    68.851     0.200
     4.464    70.055     0.200
     4.526    71.693     0.200
     4.563    72.605     0.200
     4.603    72.731     0.200
     4.589    69.450     0.200
     4.669    72.110     0.200
     4.772    74.280     0.200
     4.797    73.678     0.200
     4.800    73.100     0.200
     4.802    72.964     0.200
     4.804    73.816     0.200
     4.808    74.592     0.200
     4.926    76.572     0.200
     4.892    73.579     0.200
     4.896    76.293     0.200
     4.985    75.887     0.200
     5.235    77.570     0.200
     5.482    80.507     0.200
     5.611    82.519     0.200
     5.699    85.952     0.200
     5.870    89.093     0.200
     5.964    89.115     0.200
     6.256    94.807     0.200
     6.297    92.593     0.200
     6.556    96.987     0.200
     6.630    96.722     0.200
     6.704    98.806     0.200
     6.865    98.222     0.200
     7.223   101.628     0.200
     7.595   108.715     0.200
     7.645   109.873     0.200
     7.875   114.621     0.200
     7.842   112.489     0.200
     8.769   126.524     0.200
     8.790   122.921     0.200
    10.153   143.306     0.200
    11.177   156.692     0.200
    11.388   158.887     0.200
    11.418   158.851     0.200
    11.425   158.604     0.200
    11.605   165.879     0.200
    11.824   164.934     0.200
    11.943   164.733     0.200
    13.132   181.168     0.200
    13.354   185.963     0.200
    13.921   192.675     0.200
    15.329   202.830     0.200
    16.285   217.840     0.200
    16.489   213.206     0.200
    16.729   224.172     0.200
    17.870   238.640     0.200
    18.294   241.941     0.200
    19.784   265.851     0.200
     1.157    24.347     0.200
     1.667    30.165     0.200
     2.261    38.259     0.200
     2.639    44.574     0.200
     2.727    44.259     0.200
     2.934    47.005     0.200
     3.174    53.050     0.200
     3.382    50.192     0.200
     3.446    56.040     0.200
     3.495    53.331     0.200
     3.910    62.992     0.200
     3.860    63.718     0.200
     4.060    61.820     0.200
     4.318    63.408     0.200
     4.337    69.670     0.200
     4.343    63.789     0.200
     4.347    65.732     0.200
     4.351    67.686     0.200
     4.373    64.791     0.200
     4.376    65.874     0.200
     4.411    71.452     0.200
     4.412    71.446     0.200
     4.524    70.805     0.200
     4.623    74.478     0.200
     4.752    68.642     0.200
     0.788    17.332     0.200
     0.852    19.237     0.200
     1.874    32.223     0.200
     2.425    40.519     0.200
     2.590    44.028     0.200
     2.691    44.449     0.200
     3.309    53.676     0.200
     3.696    58.099     0.200
     1.003    19.933     0.200
     1.791    28.482     0.200
     2.117    34.617     0.200
     2.719    42.492     0.200
     3.022    49.794     0.200
     3.061    46.929     0.200
     3.523    50.890     0.200
     3.617    56.078     0.200
     3.958    63.901     0.200
     3.971    63.381     0.200
     4.184    63.597     0.200
     4.414    68.342     0.200
     4.425    68.662     0.200
     4.478    63.286     0.200
     4.695    73.676     0.200
     4.843    73.579     0.200
     5.162    77.078     0.200
     5.205    74.543     0.200
     5.285    76.904     0.200
     5.555    81.340     0.200
     5.585    80.993     0.200
     5.734    84.696     0.200
     5.844    86.822     0.200
     6.080    92.230     0.200
     6.224    84.432     0.200
     6.290    91.826     0.200
     7.026   105.709     0.200
     7.238   101.878     0.200
     7.463   108.769     0.200
     7.448   112.355     0.200
     8.024   115.856     0.200
     8.906   128.699     0.200
     9.682   139.395     0.200
     9.738   142.813     0.200
    10.762   149.253     0.200
     1.199    25.265     0.200
     1.298    26.328     0.200
     2.747    44.693     0.200
     3.533    57.795     0.200
     3.552    58.068     0.200
     3.624    59.391     0.200
     4.007    60.204     0.200
     4.121    68.190     0.200
     4.190    57.425     0.200
     4.413    71.443     0.200
     4.433    72.536     0.200
     4.442    72.433     0.200
     4.498    71.786     0.200
     4.867    65.470     0.200
     5.211    80.246     0.200
     5.185    72.229     0.200
     5.302    73.908     0.200
     5.599    79.905     0.200
     5.585    88.639     0.200
     1.189    23.847     0.200
     1.635    27.881     0.200
     1.923    32.700     0.200
     2.295    38.840     0.200
     2.615    43.959     0.200
     2.696    44.810     0.200
     3.423    53.294     0.200
     3.751    61.429     0.200
     3.889    57.827     0.200
     3.894    60.419     0.200
     3.921    58.110     0.200
     3.924    56.748     0.200
     3.932    60.640     0.200
     3.944    61.167     0.200
     4.017    59.654     0.200
     4.015    61.675     0.200
     4.041    60.036     0.200
     4.078    64.252     0.200
     4.028    62.242     0.200
     4.159    64.643     0.200
     4.164    68.564     0.200
     4.205    65.435     0.200
     4.299    64.669     0.200
     4.316    67.126     0.200
     4.324    65.711     0.200
     4.332    66.275     0.200
     4.402    71.447     0.200
     4.348    66.111     0.200
     4.344    71.406     0.200
     4.504    65.595     0.200
     4.644    74.575     0.200
     4.726    68.619     0.200
     5.044    74.509     0.200
     5.050    74.400     0.200
     5.151    80.465     0.200
     5.454    87.340     0.200
     5.443    82.244     0.200
     5.565    82.114     0.200
     5.734    89.103     0.200
     5.922    81.650     0.200
     6.086    91.980     0.200
     6.069    83.014     0.200
     6.156    94.533     0.200
     6.954   102.712     0.200
     7.085    97.228     0.200
     7.456    99.581     0.200
     7.491   109.804     0.200
     7.887   116.815     0.200
     7.897   111.353     0.200
     8.248   115.704     0.200
     8.367   121.170     0.200
     8.566   124.208     0.200
     9.081   131.289     0.200
     9.259   130.661     0.200
     9.611   134.636     0.200
     9.816   144.054     0.200
     9.937   147.818     0.200
    10.867   158.952     0.200
    11.326   158.232     0.200
    12.072   167.543     0.200
    12.441   162.655     0.200
    12.900   173.171     0.200
    13.009   182.941     0.200
    13.534   185.944     0.200
    14.414   188.221     0.200
    17.068   225.211     0.200
    17.921   232.278     0.200
    18.686   242.680     0.200
     1.310    27.018     0.200
     1.414    27.170     0.200
     3.810    62.138     0.200
     3.819    62.471     0.200
     4.001    55.243     0.200
     3.959    64.685     0.200
     4.001    65.191     0.200
     4.303    67.681     0.200
     4.301    62.125     0.200
     4.434    72.140     0.200
     4.671    77.036     0.200
     4.649    76.543     0.200
     4.990    75.476     0.200
     5.022    68.867     0.200
     5.107    73.821     0.200
     5.405    76.415     0.200
     5.392    83.918     0.200
     5.472    82.570     0.200
     5.676    84.331     0.200
     6.014    90.901     0.200
     6.112    90.893     0.200
     6.900    97.026     0.200
     7.055    97.226     0.200
     7.848   116.890     0.200
     1.136    24.889     0.200
     1.239    25.447     0.200
     2.677    44.850     0.200
     3.044    48.898     0.200
     3.596    54.422     0.200
     4.326    69.859     0.200
     4.349    68.944     0.200
     4.353    68.657     0.200
     4.355    69.227     0.200
     4.358    70.620     0.200
     4.363    69.378     0.200
     4.454    68.779     0.200
     4.444    69.373     0.200
     4.448    71.120     0.200
     4.804    72.215     0.200
     5.124    77.154     0.200
     5.184    80.177     0.200
     5.803    87.682     0.200
     1.859    33.201     0.200
     2.663    43.467     0.200
     2.663    44.467     0.200
     2.753    46.499     0.200
     3.340    50.029     0.200
     3.548    55.152     0.200
     3.771    61.333     0.200
     3.995    63.174     0.200
     4.000    65.380     0.200
     4.107    62.471     0.200
     4.383    69.867     0.200
     4.395    66.380     0.200
     4.395    68.763     0.200
     4.401    69.463     0.200
     4.411    71.596     0.200
     4.420    71.367     0.200
     4.420    69.890     0.200
     4.431    69.489     0.200
     4.438    71.229     0.200
     4.472    70.643     0.200
     4.484    66.293     0.200
     4.527    70.607     0.200
     4.582    72.401     0.200
     4.672    67.918     0.200
     4.807    78.593     0.200
     4.808    78.587     0.200
     4.833    72.845     0.200
     4.858    74.571     0.200
     4.861    76.387     0.200
     4.862    77.474     0.200
     4.866    75.467     0.200
     4.868    75.452     0.200
     4.935    76.335     0.200
     4.969    71.171     0.200
     4.969    69.140     0.200
     5.047    71.642     0.200
     5.296    75.685     0.200
     5.329    77.387     0.200
     5.402    81.664     0.200
     5.649    82.683     0.200
     5.694    84.756     0.200
     5.777    83.575     0.200
     5.899    87.421     0.200
     6.032    88.471     0.200
     6.078    92.618     0.200
     6.301    93.388     0.200
     6.326    97.164     0.200
     6.615    98.823     0.200
     6.782   100.019     0.200
     6.782   100.022     0.200
     6.791    92.542     0.200
     6.796    99.216     0.200
     7.144   100.989     0.200
     7.558   106.928     0.200
     7.582   113.874     0.200
     7.728   109.829     0.200
     7.852   117.824     0.200
     7.754   111.687     0.200
     7.754   115.656     0.200
     8.514   119.331     0.200
     8.514   120.456     0.200
     9.175   128.898     0.200
     9.431   135.952     0.200
     9.659   134.300     0.200
    10.229   144.264     0.200
    11.253   160.753     0.200
    11.468   154.929     0.200
    11.498   160.625     0.200
    13.054   182.943     0.200
    13.835   188.229     0.200
    15.251   212.215     0.200
    15.251   209.739     0.200
    16.403   220.873     0.200
     1.033    21.024     0.200
     2.784    45.466     0.200
     3.097    49.855     0.200
     3.054    48.920     0.200
     3.570    57.732     0.200
     3.594    58.032     0.200
     3.589    56.756     0.200
     3.661    58.205     0.200
     3.823    60.876     0.200
     4.017    62.588     0.200
     4.030    63.059     0.200
     4.037    62.237     0.200
     4.053    61.771     0.200
     4.056    62.918     0.200
     4.062    62.759     0.200
     4.062    64.020     0.200
     4.073    63.299     0.200
     4.079    61.974     0.200
     4.118    62.826     0.200
     4.152    66.621     0.200
     4.159    64.916     0.200
     4.171    66.075     0.200
     4.219    63.389     0.200
     4.222    63.513     0.200
     4.282    66.421     0.200
     4.301    67.660     0.200
     4.352    65.481     0.200
     4.451    70.629     0.200
     4.471    69.052     0.200
     4.476    69.616     0.200
     4.480    71.238     0.200
     4.488    68.349     0.200
     4.510    67.807     0.200
     4.532    67.318     0.200
     4.532    68.186     0.200
     4.659    69.062     0.200
     4.903    72.940     0.200
     5.244    76.222     0.200
     5.622    83.467     0.200
     5.650    83.530     0.200
     5.907    86.778     0.200
     6.168    91.505     0.200
     6.237    92.738     0.200
     6.263    91.325     0.200
     6.342    92.253     0.200
     7.067   104.109     0.200
     7.532   106.589     0.200
     7.859   113.841     0.200
    10.815   153.300     0.200
     0.985    20.461     0.200
     8.113   109.549     0.200
    11.029   158.065     0.200
     0.327     9.883     0.200
     0.721    15.142     0.200
     0.877    18.297     0.200
     0.983    19.437     0.200
     1.368    24.807     0.200
     1.568    28.752     0.200
     1.951    33.200     0.200
     2.758    44.487     0.200
     3.003    45.096     0.200
     3.220    46.243     0.200
     3.434    54.376     0.200
     3.547    53.264     0.200
     3.561    54.894     0.200
     3.709    61.129     0.200
     3.862    59.975     0.200
     3.906    58.304     0.200
     3.930    65.862     0.200
     3.957    59.656     0.200
     3.951    58.944     0.200
     4.020    62.785     0.200
     4.042    62.527     0.200
     4.112    62.371     0.200
     4.328    57.809     0.200
     4.195    63.641     0.200
     4.308    63.155     0.200
     4.307    63.161     0.200
     4.355    68.878     0.200
     4.383    70.542     0.200
     4.384    65.847     0.200
     4.385    71.186     0.200
     4.388    71.208     0.200
     4.558    62.427     0.200
     4.572    71.659     0.200
     4.896    65.632     0.200
     5.218    71.447     0.200
     5.344    69.857     0.200
     5.373    74.640     0.200
     5.404    84.194     0.200
     5.575    75.968     0.200
     5.691    77.739     0.200
     5.880    81.321     0.200
     5.848    86.970     0.200
     7.179   102.978     0.200
     8.743   120.424     0.200
     0.782    17.630     0.200
     1.734    29.417     0.200
     2.152    34.777     0.200
     3.729    60.630     0.200
     3.968    63.931     0.200
     4.591    71.449     0.200
     4.620    65.131     0.200
     4.620    73.099     0.200
     4.621    69.767     0.200
     5.129    72.587     0.200
     5.450    78.095     0.200
     5.556    77.365     0.200
     5.600    73.947     0.200
     5.914    86.933     0.200
     6.115    85.033     0.200
     0.755    16.728     0.200
     0.855    17.377     0.200
     1.392    24.416     0.200
     2.937    47.188     0.200
     3.453    51.082     0.200
     3.561    51.256     0.200
     3.598    54.743     0.200
     3.679    59.143     0.200
     3.732    54.906     0.200
     3.875    58.166     0.200
     3.934    60.899     0.200
     3.928    56.475     0.200
     3.977    62.120     0.200
     4.022    57.840     0.200
     4.077    58.280     0.200
     4.117    62.223     0.200
     4.130    55.266     0.200
     4.177    59.829     0.200
     4.185    64.054     0.200
     4.210    65.434     0.200
     4.260    58.342     0.200
     4.269    62.833     0.200
     4.454    65.951     0.200
     4.504    66.152     0.200
     4.526    63.600     0.200
     4.531    64.748     0.200
     4.556    63.444     0.200
     4.555    65.981     0.200
     4.556    66.730     0.200
     4.558    63.344     0.200
     4.564    68.331     0.200
     4.744    72.140     0.200
     5.075    73.200     0.200
     5.397    79.664     0.200
     5.522    73.313     0.200
     5.751    78.914     0.200
     5.871    79.289     0.200
     5.933    82.681     0.200
     6.059    82.233     0.200
     0.805    17.313     0.200
     0.964    20.741     0.200
     1.058    21.177     0.200
     1.514    23.756     0.200
     1.885    31.055     0.200
     2.825    43.148     0.200
     2.910    43.414     0.200
     3.077    47.135     0.200
     3.288    48.571     0.200
     3.840    60.805     0.200
     4.105    58.507     0.200
     4.114    58.123     0.200
     4.123    63.293     0.200
     4.131    65.060     0.200
     4.131    64.929     0.200
     4.139    63.093     0.200
     4.143    63.652     0.200
     4.148    57.954     0.200
     4.184    64.968     0.200
     4.237    62.866     0.200
     4.292    61.761     0.200
     4.408    63.807     0.200
     4.401    66.125     0.200
     4.541    70.476     0.200
     4.575    68.820     0.200
     4.576    68.805     0.200
     4.685    70.068     0.200
     4.755    71.760     0.200
     5.041    74.377     0.200
     5.361    73.676     0.200
     5.428    72.502     0.200
     5.495    76.522     0.200
     5.523    83.328     0.200
     5.641    89.615     0.200
     5.740    86.227     0.200
     6.036    91.991     0.200
     6.094    90.267     0.200
     6.323    88.225     0.200
     6.499    97.130     0.200
     6.499    97.133     0.200
     6.845    97.735     0.200
     7.418   109.453     0.200
     7.720   118.007     0.200
     8.228   114.237     0.200
     8.228   111.057     0.200
     8.730   123.655     0.200
     8.887   124.618     0.200
     9.581   133.007     0.200
     9.943   142.036     0.200
    10.110   142.354     0.200
    14.397   187.920     0.200
     2.618    43.557     0.200
     2.759    45.199     0.200
     3.083    45.858     0.200
     3.041    47.791     0.200
     3.468    54.075     0.200
     3.539    55.150     0.200
     3.563    54.689     0.200
     3.562    57.369     0.200
     3.632    56.355     0.200
     3.641    56.272     0.200
     3.810    59.045     0.200
     3.795    56.845     0.200
     3.917    62.169     0.200
     3.986    60.423     0.200
     4.207    61.871     0.200
     4.422    66.742     0.200
     4.443    66.120     0.200
     4.448    66.688     0.200
     4.451    64.521     0.200
     4.459    66.384     0.200
     4.477    67.512     0.200
     4.511    68.084     0.200
     4.513    67.941     0.200
     4.631    65.672     0.200
     4.749    70.431     0.200
     4.879    71.762     0.200
     5.198    75.529     0.200
     5.228    78.521     0.200
     5.317    79.900     0.200
     5.616    86.314     0.200
     5.883    87.374     0.200
     6.134    86.998     0.200
     6.248    91.413     0.200
     6.322    91.032     0.200
     1.602    26.550     0.200
     1.702    28.955     0.200
     1.877    32.826     0.200
     2.089    29.446     0.200
     2.556    41.433     0.200
     2.686    44.062     0.200
     2.841    45.960     0.200
     3.027    48.049     0.200
     3.345    53.756     0.200
     3.417    52.093     0.200
     3.469    52.532     0.200
     3.496    57.178     0.200
     3.972    56.052     0.200
     4.359    63.876     0.200
     5.074    72.495     0.200
     5.780    83.718     0.200
     1.712    30.278     0.200
     2.082    35.191     0.200
     2.555    43.950     0.200
     2.710    45.656     0.200
     3.083    49.951     0.200
     3.430    56.780     0.200
     3.511    54.282     0.200
     3.634    56.802     0.200
     3.674    60.349     0.200
     3.950    64.950     0.200
     4.202    65.339     0.200
     4.354    64.957     0.200
     4.377    66.988     0.200
     4.384    65.074     0.200
     4.381    71.404     0.200
     4.390    72.827     0.200
     4.480    63.063     0.200
     4.566    71.006     0.200
     4.631    74.669     0.200
     4.838    72.717     0.200
     5.158    75.513     0.200
     5.222    72.396     0.200
     5.289    82.126     0.200
     5.543    82.294     0.200
     5.594    84.278     0.200
     5.836    85.106     0.200
     2.621    40.125     0.200
     2.760    42.024     0.200
     2.971    47.153     0.200
     2.976    48.479     0.200
     3.417    52.682     0.200
     3.667    59.711     0.200
     3.857    60.819     0.200
     3.857    55.500     0.200
     3.874    62.725     0.200
     3.883    62.510     0.200
     3.889    61.772     0.200
     3.889    62.432     0.200
     3.986    63.300     0.200
     4.108    65.856     0.200
     4.387    69.586     0.200
     4.357    66.946     0.200
     4.489    70.571     0.200
     4.633    73.273     0.200
     4.745    72.318     0.200
     5.064    67.332     0.200
     5.457    81.186     0.200
     5.746    80.326     0.200
     5.746    85.955     0.200
     6.066    91.218     0.200
     6.132    83.897     0.200
     6.021    93.080     0.200
     6.193    84.957     0.200
     6.193    84.960     0.200
     7.145    95.149     0.200
     7.055   107.923     0.200
     7.403   111.199     0.200
     7.747   109.218     0.200
     7.926   108.452     0.200
     7.926   110.830     0.200
     8.931   128.195     0.200
     9.641   136.901     0.200
     9.800   138.049     0.200
    10.665   148.114     0.200
     0.633    17.159     0.200
     0.966    19.882     0.200
     1.021    20.310     0.200
     1.101    22.399     0.200
     1.213    23.002     0.200
     1.907    28.489     0.200
     2.258    33.879     0.200
     2.377    37.823     0.200
     2.697    37.767     0.200
     2.856    44.537     0.200
     2.919    42.609     0.200
     3.012    46.645     0.200
     3.031    42.838     0.200
     3.128    47.146     0.200
     3.160    47.607     0.200
     3.307    49.404     0.200
     3.352    49.417     0.200
     3.300    48.684     0.200
     3.436    48.931     0.200
     3.461    49.822     0.200
     3.489    48.681     0.200
     3.504    49.883     0.200
     3.519    49.229     0.200
     3.528    48.492     0.200
     3.548    51.975     0.200
     3.558    49.294     0.200
     3.611    51.746     0.200
     3.640    52.716     0.200
     3.691    51.603     0.200
     3.713    51.309     0.200
     3.764    54.911     0.200
     3.843    58.792     0.200
     3.916    58.278     0.200
     3.916    58.272     0.200
     3.954    56.801     0.200
     3.971    58.545     0.200
     4.009    55.570     0.200
     3.984    57.234     0.200
     3.983    60.527     0.200
     3.984    59.959     0.200
     3.985    57.144     0.200
     3.987    57.129     0.200
     4.172    61.711     0.200
     4.192    58.515     0.200
     4.154    63.331     0.200
     4.233    59.372     0.200
     4.516    62.454     0.200
     4.838    67.192     0.200
     5.018    69.846     0.200
     5.010    67.170     0.200
     6.035    80.485     0.200
     6.737    89.174     0.200
     7.717   104.970     0.200
     7.717   105.579     0.200
     8.361   112.307     0.200
     9.430   126.645     0.200
    13.803   180.901     0.200
     1.296    21.841     0.200
     1.679    26.658     0.200
     2.644    42.180     0.200
     2.947    42.306     0.200
     3.345    51.243     0.200
     3.507    51.599     0.200
     3.450    52.547     0.200
     3.912    59.896     0.200
     4.072    59.357     0.200
     4.320    68.887     0.200
     4.339    68.561     0.200
     4.385    63.402     0.200
     4.345    67.852     0.200
     4.359    66.257     0.200
     4.408    67.118     0.200
     4.604    72.622     0.200
     4.758    67.040     0.200
     5.093    71.148     0.200
     5.077    73.771     0.200
     5.189    73.105     0.200
     2.207    39.903     0.200
     2.446    43.286     0.200
     3.111    53.902     0.200
     3.221    54.268     0.200
     3.150    53.116     0.200
     3.188    55.120     0.200
     3.223    49.502     0.200
     3.315    54.115     0.200
     3.253    48.652     0.200
     3.269    56.727     0.200
     3.279    49.923     0.200
     3.363    57.705     0.200
     3.358    51.749     0.200
     3.382    50.783     0.200
     3.426    56.839     0.200
     3.382    59.242     0.200
     3.560    54.366     0.200
     3.742    60.593     0.200
     3.736    64.175     0.200
     4.272    68.613     0.200
     4.301    66.191     0.200
     4.383    68.715     0.200
     4.498    68.139     0.200
     4.818    74.841     0.200
     0.808    18.501     0.200
     0.967    21.375     0.200
     1.068    23.110     0.200
     1.939    32.604     0.200
     2.808    45.754     0.200
     4.327    67.332     0.200
     4.432    69.668     0.200
     4.343    68.312     0.200
     4.458    68.567     0.200
     4.460    69.233     0.200
     4.462    69.090     0.200
     4.606    66.924     0.200
     4.467    69.800     0.200
     4.590    71.092     0.200
     4.941    78.002     0.200
     5.347    75.746     0.200
     5.262    78.399     0.200
     5.402    78.457     0.200
     5.711    81.583     0.200
     5.933    89.910     0.200
     5.995    93.000     0.200
     1.229    26.104     0.200
     1.047    23.760     0.200
     1.147    24.693     0.200
     1.182    25.051     0.200
     1.265    25.851     0.200
     2.467    40.335     0.200
     3.059    47.608     0.200
     3.160    47.917     0.200
     3.261    54.896     0.200
     3.324    50.276     0.200
     3.239    48.781     0.200
     4.231    58.601     0.200
     4.447    69.548     0.200
     4.735    73.104     0.200
     4.768    69.100     0.200
     5.033    72.507     0.200
     5.352    82.790     0.200
     5.407    86.215     0.200
     1.173    22.911     0.200
     1.744    28.008     0.200
     2.660    40.458     0.200
     3.015    46.051     0.200
     2.981    48.784     0.200
     3.462    52.140     0.200
     3.428    52.243     0.200
     3.568    51.297     0.200
     3.448    54.482     0.200
     3.524    52.170     0.200
     3.699    53.101     0.200
     3.718    55.754     0.200
     3.806    59.669     0.200
     3.873    55.658     0.200
     3.889    61.087     0.200
     3.909    58.404     0.200
     3.933    64.076     0.200
     4.135    57.854     0.200
     4.019    55.763     0.200
     4.078    59.990     0.200
     4.336    63.684     0.200
     4.341    66.339     0.200
     4.344    62.545     0.200
     4.386    65.461     0.200
     2.942    44.957     0.200
     3.323    51.129     0.200
     3.422    54.001     0.200
     3.499    52.721     0.200
     3.875    61.397     0.200
     4.285    62.711     0.200
     4.305    62.432     0.200
     4.368    65.026     0.200
     4.311    62.733     0.200
     4.314    60.003     0.200
     4.366    64.782     0.200
     4.324    66.527     0.200
     4.361    67.967     0.200
     4.493    67.396     0.200
     4.552    71.630     0.200
     4.735    64.842     0.200
     4.676    73.782     0.200
     5.086    73.857     0.200
     5.054    70.750     0.200
     5.454    81.733     0.200
     5.739    83.074     0.200
     6.106    86.668     0.200
     6.177    89.769     0.200
     6.065    89.965     0.200
     7.113   105.709     0.200
     2.929    45.165     0.200
     3.088    51.260     0.200
     3.196    54.995     0.200
     3.287    53.307     0.200
     3.207    54.038     0.200
     3.345    51.299     0.200
     3.333    57.389     0.200
     3.715    59.671     0.200
     4.247    66.852     0.200
     4.476    67.164     0.200
     4.702    72.630     0.200
     4.796    71.211     0.200
     5.066    78.365     0.200
     5.235    78.843     0.200
     5.376    83.737     0.200
     5.442    79.431     0.200
     6.037    98.213     0.200
     1.647    28.946     0.200
     2.387    41.549     0.200
     3.394    55.837     0.200
     3.332    55.770     0.200
     3.782    56.979     0.200
     4.312    61.045     0.200
     4.395    71.200     0.200
     4.511    70.608     0.200
     4.830    71.928     0.200
     4.697    76.193     0.200
     5.102    77.811     0.200
     5.408    80.416     0.200
     5.479    78.780     0.200
     6.039    89.362     0.200
     1.187    24.752     0.200
     1.227    26.351     0.200
     2.512    42.902     0.200
     2.996    49.518     0.200
     3.094    50.486     0.200
     3.172    52.589     0.200
     3.267    53.901     0.200
     3.308    55.300     0.200
     3.362    56.241     0.200
     4.149    64.931     0.200
     4.163    65.746     0.200
     4.254    67.150     0.200
     4.385    69.745     0.200
     4.705    75.357     0.200
     4.968    78.230     0.200
     5.128    77.776     0.200
     1.704    33.287     0.200
     2.388    41.688     0.200
     2.485    42.222     0.200
     3.557    61.534     0.200
     3.714    63.169     0.200
     3.725    58.010     0.200
     3.730    57.294     0.200
     3.743    58.459     0.200
     4.757    76.874     0.200
     4.775    75.523     0.200
     5.008    83.237     0.200
     5.196    79.463     0.200
     6.008    89.173     0.200
     6.100    88.924     0.200
     6.190    89.872     0.200
     6.622    95.532     0.200
     7.645   111.613     0.200
     8.248   120.006     0.200
     8.419   122.033     0.200
     1.843    29.420     0.200
     2.358    38.873     0.200
     2.774    42.205     0.200
     3.113    50.978     0.200
     3.487    55.452     0.200
     3.577    54.830     0.200
     3.670    53.883     0.200
     3.759    59.822     0.200
     4.025    60.174     0.200
     4.430    66.299     0.200
     4.452    65.545     0.200
     4.456    65.620     0.200
     4.459    65.956     0.200
     4.467    66.867     0.200
     4.472    65.870     0.200
     4.532    66.256     0.200
     4.640    66.905     0.200
     4.898    65.302     0.200
     5.217    73.455     0.200
     5.257    71.659     0.200
     5.339    75.349     0.200
     5.339    79.397     0.200
     5.639    76.200     0.200
     5.899    83.687     0.200
     6.112    87.651     0.200
     1.170    23.768     0.200
     1.209    25.086     0.200
     1.429    24.833     0.200
     2.401    40.346     0.200
     2.487    40.511     0.200
     2.473    40.287     0.200
     2.409    39.019     0.200
     3.282    48.050     0.200
     3.124    49.182     0.200
     3.204    50.038     0.200
     3.291    50.401     0.200
     3.354    51.152     0.200
     3.650    57.243     0.200
     3.682    56.628     0.200
     3.687    56.815     0.200
     3.635    55.651     0.200
     3.700    56.781     0.200
     4.178    62.242     0.200
     4.195    62.655     0.200
     4.413    66.256     0.200
     4.732    67.595     0.200
     4.733    69.866     0.200
     4.997    74.084     0.200
     5.159    76.113     0.200
     1.202    26.778     0.200
     1.282    28.082     0.200
     3.268    52.318     0.200
     3.320    55.970     0.200
     3.353    53.970     0.200
     3.695    58.202     0.200
     3.696    62.053     0.200
     3.708    57.179     0.200
     3.713    59.077     0.200
     3.728    58.119     0.200
     4.225    63.814     0.200
     4.253    65.393     0.200
     4.773    76.631     0.200
     5.043    81.958     0.200
     5.214    79.108     0.200
     5.352    87.370     0.200
     5.420    81.240     0.200
     6.205    95.901     0.200
     6.613   102.125     0.200
     7.162   105.861     0.200
     7.640   105.229     0.200
     9.806   142.387     0.200
     0.944    19.609     0.200
     1.102    23.246     0.200
     1.803    30.385     0.200
     2.254    37.180     0.200
     2.863    47.717     0.200
     2.959    47.644     0.200
     3.075    42.993     0.200
     3.449    56.009     0.200
     3.459    56.484     0.200
     3.552    55.617     0.200
     3.721    56.131     0.200
     3.828    61.360     0.200
     3.891    61.412     0.200
     3.909    60.164     0.200
     3.914    58.033     0.200
     3.918    62.936     0.200
     3.940    54.071     0.200
     3.931    57.189     0.200
     3.943    62.541     0.200
     3.957    58.079     0.200
     4.045    60.991     0.200
     4.102    59.684     0.200
     4.194    63.615     0.200
     4.152    61.320     0.200
     4.182    61.372     0.200
     4.242    66.622     0.200
     4.344    67.501     0.200
     4.367    68.578     0.200
     4.371    69.757     0.200
     4.373    69.934     0.200
     4.380    70.379     0.200
     4.371    63.283     0.200
     4.404    69.970     0.200
     4.470    63.103     0.200
     4.481    67.581     0.200
     4.555    70.260     0.200
     4.622    74.022     0.200
     4.828    70.582     0.200
     5.149    73.565     0.200
     5.214    81.782     0.200
     5.280    82.395     0.200
     5.533    81.811     0.200
     5.585    78.270     0.200
     5.826    84.891     0.200
     6.284    89.155     0.200
     6.546   100.711     0.200
     7.057    99.296     0.200
     7.245    96.827     0.200
     8.014   108.963     0.200
     8.014   108.737     0.200
     9.729   143.545     0.200
    16.773   227.818     0.200
     1.061    21.222     0.200
     2.993    47.466     0.200
     3.114    51.283     0.200
     3.268    49.439     0.200
     3.356    54.776     0.200
     3.526    56.731     0.200
     3.538    56.281     0.200
     3.549    56.579     0.200
     3.554    56.921     0.200
     3.568    57.661     0.200
     3.725    56.456     0.200
     3.921    54.431     0.200
     4.239    59.362     0.200
     4.286    61.610     0.200
     4.353    69.797     0.200
     4.654    73.478     0.200
     4.655    71.570     0.200
     4.930    70.862     0.200
     0.281    10.043     0.200
     0.719    14.927     0.200
     0.877    17.775     0.200
     0.980    19.583     0.200
     1.432    23.481     0.200
     2.227    36.295     0.200
     2.733    44.149     0.200
     3.252    47.506     0.200
     3.546    57.446     0.200
     3.793    55.053     0.200
     4.014    62.880     0.200
     4.236    62.773     0.200
     4.371    63.745     0.200
     4.412    70.772     0.200
     4.440    71.772     0.200
     4.442    71.749     0.200
     4.445    68.372     0.200
     4.628    64.676     0.200
     4.945    68.001     0.200
     5.267    70.468     0.200
     5.381    78.575     0.200
     5.418    71.572     0.200
     5.467    84.417     0.200
     5.628    80.954     0.200
     5.733    81.983     0.200
     5.932    86.415     0.200
     5.908    87.580     0.200
     6.190    88.696     0.200
     6.400    88.767     0.200
     7.234   106.249     0.200
     2.894    43.108     0.200
     2.912    48.170     0.200
     3.107    48.431     0.200
     3.107    44.072     0.200
     3.441    55.190     0.200
     3.552    47.956     0.200
     3.452    53.442     0.200
     3.515    57.008     0.200
     3.656    56.122     0.200
     3.656    50.774     0.200
     3.919    59.291     0.200
     3.919    63.170     0.200
     3.922    63.622     0.200
     3.949    60.699     0.200
     3.939    61.720     0.200
     4.225    65.424     0.200
     4.352    67.864     0.200
     4.376    67.581     0.200
     4.379    70.205     0.200
     4.381    67.518     0.200
     4.364    69.172     0.200
     4.364    69.178     0.200
     4.507    68.292     0.200
     4.493    66.979     0.200
     4.383    69.631     0.200
     5.168    74.471     0.200
     5.244    77.546     0.200
     5.304    79.565     0.200
     5.547    82.736     0.200
     5.611    81.987     0.200
     5.842    89.765     0.200
     5.981    94.554     0.200
     6.264    92.307     0.200
     6.308    93.768     0.200
     6.307    93.771     0.200
     7.075    96.121     0.200
     7.274   102.704     0.200
     8.035   108.955     0.200
     8.035   114.057     0.200
     8.694   116.490     0.200
     9.750   141.084     0.200
    10.777   151.820     0.200
     1.273    26.688     0.200
     3.206    52.736     0.200
     3.249    52.726     0.200
     3.387    56.140     0.200
     3.371    53.050     0.200
     3.419    56.917     0.200
     3.713    60.146     0.200
     4.260    65.989     0.200
     4.274    66.564     0.200
     4.366    67.718     0.200
     4.494    72.464     0.200
     4.756    74.091     0.200
     4.815    77.633     0.200
     5.045    77.627     0.200
     5.079    78.540     0.200
     5.239    83.020     0.200
     5.399    81.524     0.200
     5.453    84.746     0.200
     6.100    90.919     0.200
     6.232    93.292     0.200
     3.722    49.936     0.200
     3.670    55.496     0.200
     3.839    59.497     0.200
     4.032    60.568     0.200
     4.036    61.003     0.200
     4.048    61.048     0.200
     4.075    64.053     0.200
     4.163    63.697     0.200
     4.220    64.352     0.200
     4.289    56.338     0.200
     4.269    63.785     0.200
     4.461    69.771     0.200
     4.484    70.204     0.200
     4.488    68.299     0.200
     4.585    64.110     0.200
     4.673    72.414     0.200
     4.940    68.954     0.200
     5.260    77.072     0.200
     5.310    69.967     0.200
     5.386    75.145     0.200
     5.688    80.930     0.200
     5.939    87.453     0.200
     1.214    26.483     0.200
     1.247    27.657     0.200
     1.329    28.632     0.200
     1.620    30.290     0.200
     3.478    56.149     0.200
     3.645    60.156     0.200
     3.645    61.699     0.200
     4.173    66.696     0.200
     4.284    69.379     0.200
     4.400    72.169     0.200
     4.672    71.704     0.200
     4.720    77.337     0.200
     4.944    77.978     0.200
     4.990    76.842     0.200
     5.300    85.182     0.200
     5.368    73.501     0.200
     1.271    28.191     0.200
     1.348    28.202     0.200
     1.560    30.531     0.200
     2.192    39.800     0.200
     2.355    40.985     0.200
     4.202    65.318     0.200
     4.249    64.104     0.200
     4.318    66.617     0.200
     4.421    72.511     0.200
     4.606    71.389     0.200
     4.740    71.810     0.200
     5.312    77.562     0.200
     1.808    29.054     0.200
     1.800    28.747     0.200
     2.162    34.351     0.200
     2.617    42.537     0.200
     2.700    42.067     0.200
     3.144    47.487     0.200
     3.271    52.481     0.200
     3.346    53.411     0.200
     3.543    49.560     0.200
     3.549    56.050     0.200
     3.728    57.147     0.200
     3.915    56.774     0.200
     4.350    63.034     0.200
     4.639    71.750     0.200
     4.653    70.086     0.200
     4.646    66.998     0.200
     4.923    71.406     0.200
     4.953    74.997     0.200
     5.308    70.895     0.200
     5.301    79.829     0.200
     5.704    85.619     0.200
     7.090   104.456     0.200
     1.925    32.693     0.200
     2.749    42.230     0.200
     2.825    43.905     0.200
     3.195    46.190     0.200
     3.437    51.555     0.200
     3.486    51.675     0.200
     3.540    54.088     0.200
     3.735    55.972     0.200
     3.955    58.080     0.200
     4.305    61.423     0.200
     4.320    68.413     0.200
     4.382    67.512     0.200
     4.383    68.152     0.200
     4.543    66.615     0.200
     4.568    65.336     0.200
     4.570    66.299     0.200
     4.885    64.386     0.200
     5.207    71.095     0.200
     5.323    73.702     0.200
     5.569    83.230     0.200
     5.872    78.728     0.200
     1.300    25.944     0.200
     1.326    27.699     0.200
     1.516    28.678     0.200
     1.592    29.579     0.200
     2.404    38.631     0.200
     2.852    42.726     0.200
     2.926    42.727     0.200
     3.016    48.319     0.200
     3.040    49.812     0.200
     3.077    46.554     0.200
     3.106    45.012     0.200
     3.119    44.888     0.200
     3.126    46.270     0.200
     3.211    48.262     0.200
     3.196    50.390     0.200
     3.222    50.183     0.200
     3.234    51.752     0.200
     3.243    47.487     0.200
     3.572    54.639     0.200
     3.591    58.336     0.200
     3.604    54.055     0.200
     3.610    59.065     0.200
     3.626    53.284     0.200
     3.808    60.424     0.200
     4.209    57.004     0.200
     4.211    63.551     0.200
     4.272    61.071     0.200
     4.369    67.887     0.200
     4.569    66.423     0.200
     4.688    66.894     0.200
     4.898    74.149     0.200
     4.969    73.800     0.200
     5.160    74.896     0.200
     5.258    76.282     0.200
     5.273    83.801     0.200
     5.184    81.680     0.200
     5.351    78.282     0.200
     5.930    90.031     0.200
     5.923    84.986     0.200
     6.145    86.850     0.200
     6.085    96.456     0.200
     6.284   100.845     0.200
     6.520    96.092     0.200
     7.551   108.119     0.200
     7.551   110.482     0.200
     8.145   114.230     0.200
     1.124    25.259     0.200
     1.273    25.645     0.200
     1.299    27.666     0.200
     1.570    28.984     0.200
     2.363    37.509     0.200
     2.430    39.427     0.200
     2.453    40.032     0.200
     2.601    43.528     0.200
     2.830    43.994     0.200
     2.876    48.124     0.200
     2.952    46.640     0.200
     3.003    46.672     0.200
     3.025    45.839     0.200
     3.083    51.351     0.200
     3.101    47.146     0.200
     3.130    48.778     0.200
     3.152    46.718     0.200
     3.162    49.775     0.200
     3.221    49.165     0.200
     3.236    49.413     0.200
     3.245    54.768     0.200
     3.251    49.526     0.200
     3.255    54.514     0.200
     3.255    54.510     0.200
     3.259    49.128     0.200
     3.434    52.438     0.200
     3.596    57.823     0.200
     3.613    55.814     0.200
     3.615    55.798     0.200
     3.628    58.109     0.200
     3.649    58.354     0.200
     3.666    52.330     0.200
     3.832    60.652     0.200
     4.066    66.224     0.200
     4.171    63.834     0.200
     4.221    64.868     0.200
     4.238    67.040     0.200
     4.288    66.814     0.200
     4.390    68.882     0.200
     4.592    74.958     0.200
     4.709    71.571     0.200
     4.921    68.575     0.200
     5.175    71.770     0.200
     5.281    75.536     0.200
     5.298    84.740     0.200
     5.368    80.364     0.200
     5.950    92.955     0.200
     5.950    92.957     0.200
     5.943    88.897     0.200
     6.161    88.364     0.200
     7.572   110.366     0.200
     7.572   114.265     0.200
     1.128    26.185     0.200
     1.574    30.680     0.200
     2.173    39.375     0.200
     2.359    41.176     0.200
     2.425    42.267     0.200
     2.827    46.194     0.200
     3.001    50.074     0.200
     3.123    49.309     0.200
     3.127    53.276     0.200
     3.159    54.599     0.200
     3.216    51.791     0.200
     3.232    50.996     0.200
     3.243    50.800     0.200
     3.251    55.078     0.200
     3.251    55.082     0.200
     3.252    55.663     0.200
     3.256    51.615     0.200
     3.430    57.727     0.200
     3.610    58.638     0.200
     3.612    58.622     0.200
     3.625    55.656     0.200
     3.631    59.597     0.200
     3.646    58.685     0.200
     3.829    62.315     0.200
     4.170    60.899     0.200
     4.221    65.034     0.200
     4.287    71.746     0.200
     4.388    66.074     0.200
     4.588    68.911     0.200
     4.706    74.346     0.200
     4.918    74.184     0.200
     4.986    74.727     0.200
     5.174    81.749     0.200
     5.173    82.617     0.200
     5.278    75.046     0.200
     5.367    81.737     0.200
     5.938    91.378     0.200
     6.160    91.833     0.200
     1.109    23.700     0.200
     1.310    26.940     0.200
     2.347    39.062     0.200
     2.996    49.910     0.200
     3.119    51.184     0.200
     3.209    52.708     0.200
     3.237    53.265     0.200
     3.244    51.050     0.200
     3.663    57.241     0.200
     4.165    66.268     0.200
     4.218    64.994     0.200
     4.283    66.570     0.200
     4.383    63.971     0.200
     4.701    72.080     0.200
     4.981    74.474     0.200
     5.272    82.166     0.200
     5.363    78.434     0.200
     1.076    22.551     0.200
     2.156    36.080     0.200
     2.641    42.933     0.200
     2.892    45.815     0.200
     2.992    49.556     0.200
     3.163    49.649     0.200
     3.165    48.213     0.200
     3.281    50.572     0.200
     3.355    51.967     0.200
     3.381    53.894     0.200
     3.485    54.768     0.200
     3.543    54.469     0.200
     3.737    53.027     0.200
     3.808    58.803     0.200
     3.850    59.777     0.200
     3.951    58.723     0.200
     3.997    63.946     0.200
     3.980    59.559     0.200
     4.201    67.345     0.200
     4.280    63.262     0.200
     7.486   105.165     0.200
     2.141    38.574     0.200
     3.051    52.454     0.200
     3.157    54.689     0.200
     3.247    55.036     0.200
     3.234    54.649     0.200
     3.310    55.008     0.200
     3.331    53.149     0.200
     3.352    52.421     0.200
     3.675    63.004     0.200
     3.718    63.686     0.200
     4.209    65.920     0.200
     4.234    66.620     0.200
     4.319    66.963     0.200
     4.439    72.666     0.200
     5.027    78.211     0.200
     5.196    83.224     0.200
     5.340    82.851     0.200
     0.727    16.624     0.200
     2.460    37.842     0.200
     3.015    45.488     0.200
     3.458    53.267     0.200
     3.582    53.381     0.200
     3.886    61.786     0.200
     3.890    54.600     0.200
     3.869    60.429     0.200
     3.882    57.841     0.200
     3.892    62.214     0.200
     3.897    59.803     0.200
     4.069    59.839     0.200
     4.044    65.254     0.200
     4.269    62.637     0.200
     4.603    66.718     0.200
     4.586    62.620     0.200
     4.693    65.355     0.200
     4.529    71.282     0.200
     4.673    73.641     0.200
     4.987    68.871     0.200
     5.279    75.429     0.200
     5.925    87.167     0.200
     1.715    31.459     0.200
     2.151    38.877     0.200
     3.205    53.440     0.200
     3.709    61.311     0.200
     4.270    68.645     0.200
     4.365    67.583     0.200
     4.815    77.364     0.200
     5.078    79.243     0.200
     5.237    76.895     0.200
     5.452    86.454     0.200
     1.775    29.654     0.200
     2.521    41.325     0.200
     2.853    46.338     0.200
     3.684    58.814     0.200
     3.945    60.790     0.200
     4.127    66.974     0.200
     4.573    71.032     0.200
     4.535    71.331     0.200
     4.582    69.920     0.200
     4.553    72.210     0.200
     4.560    70.059     0.200
     4.563    71.754     0.200
     4.618    72.720     0.200
     4.741    71.757     0.200
     4.693    74.279     0.200
     4.962    78.973     0.200
     5.383    82.666     0.200
     5.671    83.590     0.200
     5.692    87.486     0.200
     5.766    87.650     0.200
     5.819    82.180     0.200
     5.971    87.027     0.200
     6.287    92.936     0.200
     6.322    93.984     0.200
     6.388    90.785     0.200
     7.190   104.999     0.200
     7.157   105.889     0.200
     7.304   102.107     0.200
     7.984   117.692     0.200
     8.130   115.989     0.200
     9.043   135.493     0.200
     9.845   141.165     0.200
     9.872   143.432     0.200
     9.981   138.987     0.200
    11.179   156.804     0.200
    11.178   152.600     0.200
     0.907    20.061     0.200
     1.169    24.516     0.200
     1.181    25.572     0.200
     2.692    40.636     0.200
     2.919    46.762     0.200
     3.087    44.485     0.200
     3.491    52.728     0.200
     3.635    56.354     0.200
     3.535    57.993     0.200
     3.487    58.501     0.200
     3.620    53.693     0.200
     4.341    71.607     0.200
     4.823    70.804     0.200
     5.144    77.005     0.200
     5.223    70.408     0.200
     5.818    87.604     0.200
     1.469    24.287     0.200
     1.580    28.093     0.200
     1.732    27.374     0.200
     2.368    34.763     0.200
     2.620    39.729     0.200
     2.573    39.850     0.200
     3.137    42.078     0.200
     3.078    48.471     0.200
     3.215    50.659     0.200
     3.267    49.555     0.200
     3.467    56.006     0.200
     3.389    54.386     0.200
     3.475    54.182     0.200
     3.700    50.928     0.200
     3.598    54.412     0.200
     3.633    53.521     0.200
     3.650    59.982     0.200
     3.667    60.556     0.200
     3.669    58.760     0.200
     3.671    56.703     0.200
     3.677    55.897     0.200
     3.682    58.827     0.200
     3.692    56.881     0.200
     3.696    58.545     0.200
     3.696    57.394     0.200
     3.702    56.769     0.200
     3.776    62.021     0.200
     3.792    57.975     0.200
     3.845    60.514     0.200
     3.936    59.436     0.200
     3.959    59.120     0.200
     3.982    60.177     0.200
     4.038    59.165     0.200
     4.045    61.215     0.200
     4.057    60.702     0.200
     4.068    61.201     0.200
     4.073    60.768     0.200
     4.190    62.988     0.200
     4.244    63.703     0.200
     4.225    64.504     0.200
     4.226    64.497     0.200
     4.426    63.107     0.200
     4.722    65.734     0.200
     4.742    65.648     0.200
     4.690    75.261     0.200
     4.837    68.419     0.200
     5.170    74.244     0.200
     5.441    77.340     0.200
     5.741    80.712     0.200
     6.086    89.603     0.200
     6.270    87.973     0.200
     6.653    93.509     0.200
     6.758    93.544     0.200
     7.431   108.680     0.200
     7.587   105.804     0.200
     7.541   109.006     0.200
     7.934   112.571     0.200
     9.432   128.994     0.200
     9.920   142.351     0.200
     1.199    20.761     0.200
     1.280    22.966     0.200
     2.569    41.945     0.200
     2.789    45.419     0.200
     3.370    51.449     0.200
     3.626    56.584     0.200
     3.626    57.044     0.200
     3.790    59.124     0.200
     4.034    57.856     0.200
     3.993    60.068     0.200
     4.067    61.862     0.200
     4.099    61.561     0.200
     4.143    61.567     0.200
     4.157    65.471     0.200
     4.157    62.147     0.200
     4.186    63.795     0.200
     4.227    63.349     0.200
     4.259    64.958     0.200
     4.232    63.847     0.200
     4.279    65.378     0.200
     4.288    64.698     0.200
     4.317    68.916     0.200
     4.344    65.944     0.200
     4.361    66.400     0.200
     4.407    66.150     0.200
     4.423    66.371     0.200
     4.453    66.614     0.200
     4.533    67.225     0.200
     4.460    68.423     0.200
     4.643    70.428     0.200
     4.774    72.217     0.200
     4.806    68.527     0.200
     4.810    71.802     0.200
     4.821    73.001     0.200
     5.006    75.485     0.200
     5.105    73.772     0.200
     5.209    76.858     0.200
     5.282    78.541     0.200
     5.390    78.879     0.200
     5.484    80.695     0.200
     5.542    79.335     0.200
     5.784    83.656     0.200
     6.032    88.950     0.200
     6.104    87.290     0.200
     6.075    86.737     0.200
     6.229    84.279     0.200
     6.384    91.133     0.200
     6.418    90.335     0.200
     6.498    95.503     0.200
     6.686    98.264     0.200
     6.888    97.904     0.200
     7.018   101.418     0.200
     7.115    98.584     0.200
     8.101   113.487     0.200
     8.515   117.962     0.200
     8.629   120.654     0.200
     8.687   122.515     0.200
    10.655   146.526     0.200
     1.186    24.049     0.200
     2.735    42.660     0.200
     2.944    49.601     0.200
     3.108    44.717     0.200
     3.456    56.692     0.200
     3.483    54.332     0.200
     3.536    55.818     0.200
     3.659    53.722     0.200
     3.587    58.372     0.200
     3.549    57.789     0.200
     3.756    60.174     0.200
     3.975    61.554     0.200
     4.227    58.823     0.200
     4.185    64.598     0.200
     4.379    67.823     0.200
     4.402    67.732     0.200
     4.406    67.109     0.200
     4.408    69.299     0.200
     4.516    73.200     0.200
     4.402    71.168     0.200
     4.505    65.787     0.200
     4.429    67.257     0.200
     4.645    71.929     0.200
     4.864    69.452     0.200
     5.184    76.566     0.200
     5.315    81.968     0.200
     5.620    80.221     0.200
     5.861    88.170     0.200
     6.028    89.889     0.200
     0.300     9.552     0.200
     0.743    14.747     0.200
     1.006    19.484     0.200
     1.386    23.792     0.200
     1.938    28.407     0.200
     1.943    31.180     0.200
     2.179    32.703     0.200
     2.757    40.050     0.200
     2.750    43.574     0.200
     2.818    45.507     0.200
     3.207    46.858     0.200
     3.441    50.557     0.200
     3.495    54.682     0.200
     3.547    51.898     0.200
     3.473    54.564     0.200
     3.565    57.236     0.200
     3.747    52.686     0.200
     3.716    57.325     0.200
     3.839    60.294     0.200
     3.871    61.076     0.200
     3.915    59.576     0.200
     3.961    56.698     0.200
     4.048    63.272     0.200
     4.100    59.681     0.200
     4.122    62.582     0.200
     4.317    60.496     0.200
     4.320    67.122     0.200
     4.359    67.522     0.200
     4.387    63.353     0.200
     4.388    60.045     0.200
     4.389    66.051     0.200
     4.381    65.821     0.200
     4.493    65.284     0.200
     4.576    67.230     0.200
     4.893    67.832     0.200
     5.368    75.228     0.200
     5.684    74.002     0.200
     5.880    82.382     0.200
     1.269    26.837     0.200
     1.225    26.141     0.200
     1.714    31.781     0.200
     2.416    42.019     0.200
     3.094    53.724     0.200
     3.261    53.416     0.200
     3.362    55.179     0.200
     3.267    54.812     0.200
     3.396    56.739     0.200
     3.696    61.727     0.200
     3.741    62.841     0.200
     4.246    67.397     0.200
     4.257    67.430     0.200
     4.482    73.463     0.200
     1.754    32.628     0.200
     1.852    32.561     0.200
     2.670    45.036     0.200
     3.097    49.839     0.200
     3.171    50.847     0.200
     3.264    55.313     0.200
     3.396    58.139     0.200
     3.537    58.617     0.200
     3.675    61.310     0.200
     3.939    64.145     0.200
     3.963    65.775     0.200
     4.044    62.126     0.200
     4.118    65.809     0.200
     4.280    67.621     0.200
     4.342    68.399     0.200
     4.391    71.134     0.200
     4.655    70.274     0.200
     4.977    77.055     0.200
     5.162    76.684     0.200
     5.304    75.413     0.200
     5.497    82.666     0.200
     5.497    84.798     0.200
     5.623    85.438     0.200
     6.203    88.413     0.200
     1.242    26.706     0.200
     1.253    27.398     0.200
     1.471    28.071     0.200
     2.201    37.791     0.200
     2.446    41.716     0.200
     3.112    51.533     0.200
     3.192    54.030     0.200
     3.337    56.358     0.200
     3.367    56.447     0.200
     3.391    54.731     0.200
     3.741    61.527     0.200
     4.272    66.667     0.200
     4.383    68.129     0.200
     4.500    70.615     0.200
     4.704    74.309     0.200
     4.820    73.384     0.200
     5.090    78.331     0.200
     5.399    83.128     0.200
     6.055    93.654     0.200
     0.487    12.038     0.200
     1.438    23.724     0.200
     2.082    32.237     0.200
     2.710    39.281     0.200
     3.076    45.516     0.200
     3.176    47.923     0.200
     3.261    49.384     0.200
     3.309    52.497     0.200
     3.639    55.191     0.200
     3.645    55.842     0.200
     3.829    53.788     0.200
     3.769    60.509     0.200
     4.119    59.263     0.200
     4.155    63.774     0.200
     4.488    64.312     0.200
     4.540    69.608     0.200
     4.548    71.059     0.200
     4.807    67.193     0.200
     4.926    70.450     0.200
     5.226    73.454     0.200
     5.209    75.521     0.200
     5.493    78.949     0.200
     5.869    83.427     0.200
     5.931    85.434     0.200
     5.934    87.792     0.200
     7.363   108.335     0.200
     2.589    42.813     0.200
     2.533    43.409     0.200
     2.738    42.913     0.200
     3.159    50.739     0.200
     3.443    55.069     0.200
     3.442    53.326     0.200
     3.459    55.633     0.200
     3.820    62.614     0.200
     3.905    61.528     0.200
     4.137    65.103     0.200
     4.247    63.263     0.200
     4.323    70.122     0.200
     4.546    69.889     0.200
     4.559    73.496     0.200
     4.712    76.281     0.200
     4.831    74.891     0.200
     5.197    75.977     0.200
     5.252    79.506     0.200
     0.250    10.482     0.200
     0.736    15.299     0.200
     0.997    19.553     0.200
     1.460    23.991     0.200
     1.535    28.442     0.200
     1.980    29.343     0.200
     2.254    35.967     0.200
     2.820    41.970     0.200
     2.753    44.110     0.200
     2.887    44.592     0.200
     3.251    47.110     0.200
     3.555    49.974     0.200
     3.540    55.518     0.200
     3.612    56.395     0.200
     4.030    65.859     0.200
     4.364    62.979     0.200
     4.267    68.723     0.200
     4.395    64.996     0.200
     4.429    70.633     0.200
     4.459    70.841     0.200
     4.463    69.647     0.200
     4.611    65.547     0.200
     4.564    70.410     0.200
     4.633    65.020     0.200
     4.645    69.499     0.200
     4.956    70.916     0.200
     5.277    71.026     0.200
     5.425    78.351     0.200
     5.642    75.819     0.200
     5.739    82.838     0.200
     5.940    89.474     0.200
     1.343    27.979     0.200
     1.950    35.794     0.200
     3.428    51.683     0.200
     3.856    61.185     0.200
     3.997    60.344     0.200
     4.415    70.531     0.200
     4.558    63.897     0.200
     4.893    77.313     0.200
     5.269    74.039     0.200
     5.588    81.086     0.200
     5.695    85.997     0.200
     5.616    84.245     0.200
     5.984    93.582     0.200
     6.276    87.612     0.200
     6.433    92.466     0.200
     6.700    99.266     0.200
     7.028    98.993     0.200
     7.017   102.351     0.200
     7.360   110.787     0.200
     7.616   108.623     0.200
     7.745   115.854     0.200
     8.441   116.678     0.200
     1.325    22.340     0.200
     1.609    24.675     0.200
     1.750    24.753     0.200
     1.796    30.665     0.200
     2.358    36.459     0.200
     2.429    34.891     0.200
     2.681    44.229     0.200
     2.811    45.005     0.200
     2.896    45.364     0.200
     2.793    42.750     0.200
     3.249    51.628     0.200
     3.271    51.003     0.200
     3.351    50.441     0.200
     3.467    50.244     0.200
     3.728    54.225     0.200
     3.740    56.990     0.200
     3.648    55.123     0.200
     3.784    61.228     0.200
     3.862    60.480     0.200
     4.411    65.220     0.200
     4.518    71.954     0.200
     4.537    70.344     0.200
     1.665    27.651     0.200
     1.952    33.312     0.200
     2.214    34.368     0.200
     2.381    37.483     0.200
     2.988    43.837     0.200
     3.550    52.001     0.200
     3.584    55.952     0.200
     3.769    58.565     0.200
     3.864    60.866     0.200
     3.963    63.575     0.200
     3.955    58.886     0.200
     3.952    61.730     0.200
     4.000    55.792     0.200
     4.114    60.787     0.200
     4.083    60.782     0.200
     4.105    61.159     0.200
     4.146    64.575     0.200
     4.429    66.736     0.200
     4.432    68.165     0.200
     4.410    70.544     0.200
     4.457    69.983     0.200
     4.578    72.156     0.200
     4.623    70.249     0.200
     4.771    75.371     0.200
     4.866    74.263     0.200
     0.307    11.462     0.200
     0.975    18.387     0.200
     1.094    20.770     0.200
     1.164    20.810     0.200
     1.178    21.731     0.200
     1.207    24.080     0.200
     1.237    22.047     0.200
     1.266    23.147     0.200
     1.364    23.191     0.200
     1.360    24.802     0.200
     1.493    26.658     0.200
     1.708    26.517     0.200
     1.636    28.606     0.200
     1.808    31.132     0.200
     2.116    33.392     0.200
     2.174    34.123     0.200
     2.312    37.869     0.200
     2.570    37.706     0.200
     2.838    46.446     0.200
     2.979    42.905     0.200
     2.970    45.883     0.200
     3.368    52.032     0.200
     3.377    51.782     0.200
     3.593    59.048     0.200
     3.665    57.723     0.200
     3.777    59.254     0.200
     3.802    53.134     0.200
     1.261    24.877     0.200
     0.581    16.827     0.200
     0.656    17.913     0.200
     0.868    19.627     0.200
     1.184    20.792     0.200
     1.358    22.834     0.200
     1.268    24.140     0.200
     1.448    25.418     0.200
     1.461    25.597     0.200
     1.472    26.524     0.200
     1.477    25.984     0.200
     1.565    25.448     0.200
     1.549    26.979     0.200
     1.678    27.569     0.200
     1.800    29.517     0.200
     1.856    27.731     0.200
     1.830    27.120     0.200
     2.135    34.611     0.200
     2.442    36.121     0.200
     2.521    38.905     0.200
     2.597    39.733     0.200
     2.592    40.740     0.200
     2.993    43.924     0.200
     2.966    44.862     0.200
     2.974    44.890     0.200
     3.182    48.513     0.200
     7.168    98.540     0.200
     1.554    28.755     0.200
     1.754    29.999     0.200
     2.735    44.210     0.200
     3.019    44.938     0.200
     3.433    53.005     0.200
     3.582    54.664     0.200
     3.542    54.927     0.200
     1.639    30.886     0.200
     2.239    40.413     0.200
     2.429    42.734     0.200
     2.712    45.802     0.200
     2.839    49.273     0.200
     3.085    51.294     0.200
     3.026    50.775     0.200
     3.159    53.122     0.200
     3.159    52.231     0.200
     3.254    54.115     0.200
     3.243    53.802     0.200
     3.307    56.436     0.200
     3.714    60.613     0.200
     4.324    68.670     0.200
     4.411    69.875     0.200
     5.016    81.484     0.200
     5.215    82.042     0.200
     5.400    80.564     0.200
     1.168    25.635     0.200
     1.300    26.701     0.200
     1.326    28.403     0.200
     1.774    30.898     0.200
     2.006    34.499     0.200
     2.125    35.376     0.200
     2.292    33.944     0.200
     2.429    38.743     0.200
     2.531    40.943     0.200
     2.804    47.858     0.200
     3.035    44.942     0.200
     3.198    53.364     0.200
     3.316    54.973     0.200
     3.325    55.283     0.200
     3.562    55.357     0.200
     3.577    59.313     0.200
     3.673    61.433     0.200
     3.949    64.381     0.200
     4.134    61.400     0.200
     4.080    63.401     0.200
     4.138    67.103     0.200
     4.188    67.541     0.200
     4.338    66.270     0.200
     4.373    63.704     0.200
     4.361    71.783     0.200
     4.670    67.536     0.200
     4.992    67.388     0.200
     5.147    68.887     0.200
     5.156    76.051     0.200
     2.414    37.213     0.200
     3.021    45.991     0.200
     3.523    53.181     0.200
     3.582    52.260     0.200
     3.982    64.192     0.200
     4.147    58.059     0.200
     4.389    70.940     0.200
     4.418    70.142     0.200
     4.427    68.114     0.200
     4.833    74.444     0.200
     0.539    15.005     0.200
     0.760    17.573     0.200
     0.854    18.770     0.200
     0.902    20.280     0.200
     0.912    20.003     0.200
     0.923    20.474     0.200
     0.949    20.227     0.200
     0.989    20.484     0.200
     1.013    20.731     0.200
     1.056    21.973     0.200
     1.131    22.298     0.200
     1.188    22.181     0.200
     1.281    25.464     0.200
     1.341    25.334     0.200
     1.693    25.535     0.200
     1.811    27.452     0.200
     1.869    28.267     0.200
     2.045    30.308     0.200
     2.101    30.458     0.200
     2.388    33.542     0.200
     2.521    36.017     0.200
     2.589    41.229     0.200
     2.867    42.828     0.200
     3.126    44.786     0.200
     3.297    45.774     0.200
     3.268    46.509     0.200
     3.342    48.316     0.200
     3.367    48.504     0.200
     3.358    55.468     0.200
     3.496    55.564     0.200
     3.608    56.301     0.200
     3.646    52.919     0.200
     3.758    55.371     0.200
     4.152    62.791     0.200
     4.182    68.286     0.200
     4.184    66.459     0.200
     4.219    57.258     0.200
     4.405    59.444     0.200
     4.447    61.330     0.200
     4.727    64.041     0.200
     5.050    67.778     0.200
     5.230    66.449     0.200
     5.224    73.906     0.200
     5.388    76.291     0.200
     5.553    77.477     0.200
     6.247    83.263     0.200
     0.986    22.410     0.200
     1.168    24.981     0.200
     1.190    26.664     0.200
     1.236    27.679     0.200
     1.278    27.151     0.200
     1.240    28.036     0.200
     1.383    30.361     0.200
     3.043    50.669     0.200
     1.272    28.732     0.200
     2.667    41.234     0.200
     8.892   124.744     0.200
     1.006    21.197     0.200
     1.646    29.491     0.200
     1.959    32.017     0.200
     2.699    43.106     0.200
     3.015    47.120     0.200
     3.355    52.069     0.