#!/bin/bash
gmt begin caleta1.47_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance caleta1.47'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    11.053
     0.600    12.452
     0.700    13.851
     0.800    15.250
     0.900    16.650
     1.000    18.049
     1.100    19.448
     1.200    20.848
     1.300    22.247
     1.400    23.646
     1.500    25.045
     1.600    26.445
     1.700    27.844
     1.800    29.243
     1.900    30.642
     2.000    32.041
     2.100    33.438
     2.200    34.835
     2.300    36.233
     2.400    37.630
     2.500    39.027
     2.600    40.424
     2.700    41.820
     2.800    43.215
     2.900    44.611
     3.000    46.006
     3.100    47.401
     3.200    48.796
     3.300    50.189
     3.400    51.583
     3.500    52.976
     3.600    54.369
     3.700    55.760
     3.800    57.152
     3.900    58.544
     4.000    59.934
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.369 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.398
     0.200     6.265
     0.300     7.487
     0.400     8.914
     0.500    10.456
     0.600    12.062
     0.700    13.704
     0.800    15.368
     0.900    17.044
     1.000    18.728
     1.100    20.416
     1.200    22.109
     1.300    23.803
     1.400    25.499
     1.500    27.197
     1.600    28.895
     1.700    30.594
     1.800    32.294
     1.900    33.994
     2.000    35.695
     2.100    37.396
     2.200    39.097
     2.300    40.799
     2.400    42.501
     2.500    44.203
     2.600    45.905
     2.700    47.607
     2.800    49.309
     2.900    51.011
     3.000    52.714
     3.100    54.416
     3.200    56.118
     3.300    57.821
     3.400    59.523
     3.500    61.225
     3.600    62.928
     3.700    64.631
     3.800    66.333
     3.900    68.035
     4.000    69.738
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.928 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.600    21.249
     0.700    23.717
     0.800    26.185
     0.900    28.653
     1.000    31.121
     1.100    33.589
     1.200    36.057
     1.300    38.525
     1.400    40.993
     1.500    43.461
     1.600    45.929
     1.700    48.397
     1.800    50.865
     1.900    53.333
     2.000    55.801
     2.100    58.269
     2.200    60.737
     2.300    63.205
     2.400    65.673
     2.500    68.141
     2.600    70.609
     2.700    73.077
     2.800    75.546
     2.900    78.014
     3.000    80.481
     3.100    82.949
     3.200    85.415
     3.300    87.882
     3.400    90.349
     3.500    92.816
     3.600    95.283
     3.700    97.750
     3.800   100.216
     3.900   102.683
     4.000   105.150
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    93.283 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     9.177
     0.200    10.651
     0.300    12.726
     0.400    15.146
     0.500    17.759
     0.600    20.478
     0.700    23.256
     0.800    26.068
     0.900    28.900
     1.000    31.744
     1.100    34.596
     1.200    37.454
     1.300    40.315
     1.400    43.179
     1.500    46.045
     1.600    48.913
     1.700    51.782
     1.800    54.652
     1.900    57.523
     2.000    60.394
     2.100    63.266
     2.200    66.139
     2.300    69.012
     2.400    71.885
     2.500    74.758
     2.600    77.631
     2.700    80.505
     2.800    83.379
     2.900    86.253
     3.000    89.127
     3.100    92.001
     3.200    94.875
     3.300    97.749
     3.400   100.624
     3.500   103.498
     3.600   106.372
     3.700   109.246
     3.800   112.121
     3.900   114.995
     4.000   117.870
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   105.372 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    59.249
     2.100    62.413
     2.200    65.577
     2.300    68.741
     2.400    71.905
     2.500    75.069
     2.600    78.233
     2.700    81.397
     2.800    84.561
     2.900    87.725
     3.000    90.889
     3.100    94.053
     3.200    97.217
     3.300   100.381
     3.400   103.545
     3.500   106.709
     3.600   109.873
     3.700   113.037
     3.800   116.200
     3.900   119.364
     4.000   122.528
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   111.873 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    18.532
     0.900    19.931
     1.000    21.330
     1.100    22.730
     1.200    24.129
     1.300    25.528
     1.400    26.927
     1.500    28.327
     1.600    29.726
     1.700    31.125
     1.800    32.524
     1.900    33.924
     2.000    35.323
     2.100    36.722
     2.200    38.121
     2.300    39.520
     2.400    40.918
     2.500    42.315
     2.600    43.712
     2.700    45.109
     2.800    46.507
     2.900    47.904
     3.000    49.300
     3.100    50.696
     3.200    52.091
     3.300    53.486
     3.400    54.882
     3.500    56.276
     3.600    57.670
     3.700    59.063
     3.800    60.457
     3.900    61.850
     4.000    63.241
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.502
     0.700    13.419
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    23.005
     1.300    24.922
     1.400    26.839
     1.500    28.712
     1.600    30.417
     1.700    32.122
     1.800    33.827
     1.900    35.533
     2.000    37.238
     2.100    38.943
     2.200    40.648
     2.300    42.354
     2.400    44.059
     2.500    45.764
     2.600    47.469
     2.700    49.174
     2.800    50.879
     2.900    52.584
     3.000    54.289
     3.100    55.994
     3.200    57.699
     3.300    59.404
     3.400    61.109
     3.500    62.814
     3.600    64.519
     3.700    66.223
     3.800    67.928
     3.900    69.633
     4.000    71.337
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    33.915
     1.000    36.383
     1.100    38.851
     1.200    41.319
     1.300    43.787
     1.400    46.255
     1.500    48.723
     1.600    51.191
     1.700    53.659
     1.800    56.127
     1.900    58.595
     2.000    61.063
     2.100    63.532
     2.200    66.000
     2.300    68.468
     2.400    70.936
     2.500    73.404
     2.600    75.872
     2.700    78.340
     2.800    80.808
     2.900    83.276
     3.000    85.744
     3.100    88.212
     3.200    90.680
     3.300    93.148
     3.400    95.616
     3.500    98.083
     3.600   100.550
     3.700   103.017
     3.800   105.483
     3.900   107.950
     4.000   110.417
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.270
     0.200     6.541
     0.300     9.811
     0.400    13.081
     0.500    16.351
     0.600    19.622
     0.700    22.892
     0.800    26.162
     0.900    29.433
     1.000    32.703
     1.100    35.973
     1.200    39.243
     1.300    42.514
     1.400    45.784
     1.500    48.736
     1.600    51.615
     1.700    54.494
     1.800    57.373
     1.900    60.252
     2.000    63.131
     2.100    66.010
     2.200    68.889
     2.300    71.768
     2.400    74.647
     2.500    77.525
     2.600    80.404
     2.700    83.282
     2.800    86.161
     2.900    89.039
     3.000    91.918
     3.100    94.797
     3.200    97.676
     3.300   100.554
     3.400   103.432
     3.500   106.311
     3.600   109.189
     3.700   112.067
     3.800   114.945
     3.900   117.823
     4.000   120.701
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    14.822
     0.200    15.049
     0.300    15.420
     0.400    15.924
     0.500    16.548
     0.600    17.277
     0.700    18.099
     0.800    18.999
     0.900    19.966
     1.000    20.990
     1.100    22.061
     1.200    23.173
     1.300    24.317
     1.400    25.491
     1.500    26.688
     1.600    27.906
     1.700    29.141
     1.800    30.391
     1.900    31.653
     2.000    32.926
     2.100    34.209
     2.200    35.500
     2.300    36.797
     2.400    38.101
     2.500    39.411
     2.600    40.725
     2.700    42.043
     2.800    43.365
     2.900    44.690
     3.000    46.019
     3.100    47.350
     3.200    48.683
     3.300    50.018
     3.400    51.355
     3.500    52.694
     3.600    54.034
     3.700    55.376
     3.800    56.719
     3.900    58.063
     4.000    59.408
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    25.954
     0.200    26.355
     0.300    27.008
     0.400    27.896
     0.500    28.996
     0.600    30.283
     0.700    31.733
     0.800    33.323
     0.900    35.034
     1.000    36.845
     1.100    38.742
     1.200    40.712
     1.300    42.743
     1.400    44.825
     1.500    46.952
     1.600    49.116
     1.700    51.312
     1.800    53.536
     1.900    55.782
     2.000    58.049
     2.100    60.334
     2.200    62.634
     2.300    64.948
     2.400    67.273
     2.500    69.609
     2.600    71.953
     2.700    74.306
     2.800    76.666
     2.900    79.033
     3.000    81.405
     3.100    83.782
     3.200    86.164
     3.300    88.551
     3.400    90.941
     3.500    93.335
     3.600    95.732
     3.700    98.131
     3.800   100.534
     3.900   102.938
     4.000   105.345
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.900    29.848     0.200
     7.068   105.848     0.200
    13.195   186.848     0.200
    13.327   192.848     0.200
    14.817   206.848     0.200
    14.940   210.848     0.200
    14.938   212.848     0.200
    15.278   211.848     0.200
    16.292   225.848     0.200
    16.481   226.848     0.200
    19.795   269.848     0.200
     4.180    62.094     0.200
    14.342   200.094     0.200
    14.387   200.594     0.200
    15.320   213.992     0.200
    16.673   232.594     0.200
    17.250   239.594     0.200
    20.171   274.293     0.200
     3.057    45.945     0.200
     3.776    55.547     0.200
     7.502   110.945     0.200
    16.801   229.148     0.200
    20.057   271.047     0.200
    20.391   276.344     0.200
     3.524    53.152     0.200
     7.035   104.551     0.200
    13.411   193.051     0.200
    13.574   192.152     0.200
    15.562   218.152     0.200
    17.059   234.254     0.200
    19.263   264.254     0.200
    20.525   278.652     0.200
    20.909   283.652     0.200
     1.693    29.297     0.200
     3.543    54.297     0.200
     5.819    86.797     0.200
     7.240   107.098     0.200
    13.625   194.297     0.200
    16.789   229.898     0.200
    20.626   278.598     0.200
    20.968   281.297     0.200
    20.968   284.297     0.200
     4.307    64.789     0.200
     4.307    64.789     0.200
     5.386    75.789     0.200
     6.679    95.789     0.200
     7.136   104.789     0.200
     8.100   115.789     0.200
     9.636   143.789     0.200
    14.484   202.289     0.200
    14.484   204.789     0.200
    15.236   214.590     0.200
    16.818   231.188     0.200
    19.742   268.789     0.200
    20.080   272.391     0.200
    20.321   275.590     0.200
     2.578    40.389     0.200
     3.351    52.389     0.200
     4.030    62.889     0.200
     6.257    90.389     0.200
    13.143   190.389     0.200
    14.025   201.389     0.200
    15.478   216.889     0.200
    17.070   235.889     0.200
    18.718   261.488     0.200
    20.204   274.889     0.200
    20.815   283.389     0.200
     1.363    22.719     0.200
     1.433    25.719     0.200
     2.654    42.719     0.200
     3.446    54.219     0.200
     6.295    94.219     0.200
    14.065   201.820     0.200
    15.762   221.719     0.200
    17.159   235.617     0.200
    18.767   258.719     0.200
    20.257   277.219     0.200
     3.525    50.555     0.200
     7.807   111.555     0.200
    10.899   158.055     0.200
    12.376   177.055     0.200
    15.341   214.555     0.200
    18.719   258.055     0.200
    19.824   268.555     0.200
    20.489   275.555     0.200
     3.532    53.641     0.200
     4.004    62.141     0.200
     4.011    61.141     0.200
     6.277    91.141     0.200
    10.796   156.141     0.200
    12.600   180.742     0.200
    14.070   198.141     0.200
    15.592   218.742     0.200
    18.969   259.742     0.200
    20.231   274.039     0.200
    20.376   277.344     0.200
    20.724   280.141     0.200
    12.521   179.801     0.200
    14.821   209.602     0.200
    15.058   213.000     0.200
    16.529   232.500     0.200
    18.662   259.102     0.200
    19.660   269.301     0.200
    19.746   271.699     0.200
    20.081   274.500     0.200
    20.416   277.602     0.200
    20.709   281.398     0.200
     2.607    45.547     0.200
    11.367   166.348     0.200
    11.710   169.348     0.200
    12.797   181.449     0.200
    17.925   247.547     0.200
     7.508   107.773     0.200
    13.726   193.172     0.200
    15.945   224.875     0.200
    21.062   286.273     0.200
     3.295    51.008     0.200
     9.950   145.207     0.200
    13.287   186.008     0.200
    15.503   217.207     0.200
    15.594   217.105     0.200
    19.230   263.105     0.200
     7.337   108.367     0.200
    13.209   185.367     0.200
    14.145   200.969     0.200
    14.465   205.066     0.200
    15.226   212.469     0.200
    15.939   222.867     0.200
    16.111   223.566     0.200
    16.884   236.168     0.200
    19.522   268.367     0.200
     2.820    44.285     0.200
     2.868    44.285     0.200
     3.283    51.285     0.200
     3.372    51.785     0.200
     3.528    54.285     0.200
     4.021    60.285     0.200
     5.627    83.285     0.200
     7.019   102.887     0.200
     9.045   129.285     0.200
    10.109   145.785     0.200
    12.370   176.785     0.200
    13.058   183.484     0.200
    13.407   190.785     0.200
    13.540   191.984     0.200
    15.799   221.684     0.200
    16.322   224.387     0.200
    16.735   230.785     0.200
    18.485   252.184     0.200
    18.372   252.785     0.200
    18.716   256.285     0.200
    18.923   256.984     0.200
    19.302   266.586     0.200
    19.850   273.086     0.200
     1.537    27.477     0.200
     2.613    41.477     0.200
     3.449    52.977     0.200
     3.455    53.477     0.200
     3.910    60.977     0.200
     3.915    60.477     0.200
     3.925    60.477     0.200
     4.003    60.477     0.200
     4.154    63.477     0.200
     4.635    70.477     0.200
     6.123    91.477     0.200
     6.142    91.477     0.200
     7.516   108.977     0.200
     9.584   138.477     0.200
    10.630   153.977     0.200
    12.589   181.078     0.200
    15.495   216.477     0.200
    18.277   253.477     0.200
     2.253    37.197     0.200
     3.151    49.396     0.200
     3.216    50.396     0.200
     5.220    79.396     0.200
     6.589    97.396     0.200
    12.787   182.396     0.200
    12.963   187.096     0.200
    18.980   262.596     0.200
    19.218   267.697     0.200
    19.353   268.596     0.200
     3.039    47.491     0.200
     3.605    55.092     0.200
     3.758    56.491     0.200
     3.841    54.791     0.200
     4.266    65.092     0.200
     3.112    46.033     0.200
     3.115    46.834     0.200
     3.192    46.434     0.200
     3.361    47.934     0.200
     4.009    58.635     0.200
    10.007   138.834     0.200
    12.171   169.135     0.200
    18.308   246.234     0.200
    18.330   249.334     0.200
    18.432   248.135     0.200
     3.083    49.582     0.200
     3.122    46.582     0.200
     3.149    47.582     0.200
     3.507    55.980     0.200
     3.521    53.281     0.200
     3.581    55.680     0.200
     3.757    56.480     0.200
     4.262    64.281     0.200
     4.399    65.980     0.200
     5.428    81.082     0.200
     5.890    88.781     0.200
    12.333   175.281     0.200
    12.678   180.281     0.200
    13.123   183.582     0.200
    16.813   232.281     0.200
    18.182   251.281     0.200
    18.949   260.281     0.200
    19.542   266.281     0.200
    19.968   271.582     0.200
    19.969   274.281     0.200
    20.871   281.281     0.200
    20.957   282.281     0.200
     1.241    21.508     0.200
     3.378    52.109     0.200
     3.483    53.305     0.200
     3.816    57.508     0.200
     3.820    58.008     0.200
     3.824    58.508     0.200
     3.859    57.508     0.200
     3.882    57.508     0.200
     4.068    62.711     0.200
     4.596    68.508     0.200
     4.678    70.109     0.200
     5.235    75.008     0.200
     5.746    84.805     0.200
     6.271    91.008     0.200
     6.278    91.008     0.200
    10.750   153.008     0.200
    10.750   154.906     0.200
    12.260   174.508     0.200
    12.656   181.508     0.200
    13.155   184.508     0.200
    17.852   246.508     0.200
    18.475   251.008     0.200
    19.200   262.508     0.200
    19.312   262.508     0.200
    19.958   270.508     0.200
    20.515   276.508     0.200
    20.527   276.508     0.200
    20.628   277.508     0.200
     3.027    49.396     0.200
     3.019    48.396     0.200
     3.496    56.396     0.200
     4.635    70.396     0.200
     5.723    87.396     0.200
     7.104   106.396     0.200
    11.203   165.195     0.200
    18.729   258.796     0.200
    19.194   263.896     0.200
    19.930   278.396     0.200
    20.259   276.995     0.200
     1.880    33.258     0.200
     3.095    47.258     0.200
     3.138    48.258     0.200
     3.275    48.758     0.200
     3.591    55.758     0.200
     3.595    56.758     0.200
     3.610    55.758     0.200
     3.708    57.258     0.200
     4.291    64.258     0.200
     4.646    67.559     0.200
     5.763    85.258     0.200
    11.333   164.258     0.200
    11.648   168.758     0.200
    11.833   173.258     0.200
    12.036   173.258     0.200
    12.343   176.258     0.200
    12.476   176.258     0.200
    12.685   178.258     0.200
    12.716   181.758     0.200
    12.760   183.258     0.200
    12.806   179.258     0.200
    13.207   190.156     0.200
    18.547   257.258     0.200
    18.875   258.859     0.200
    18.875   259.957     0.200
    18.730   260.059     0.200
    19.299   266.258     0.200
    19.356   268.957     0.200
    19.502   268.758     0.200
    19.531   268.758     0.200
    19.768   273.258     0.200
    19.894   275.059     0.200
    19.899   275.156     0.200
    19.937   277.258     0.200
    19.948   275.258     0.200
     3.265    49.883     0.200
     3.311    49.383     0.200
     3.764    55.883     0.200
     3.880    58.883     0.200
     4.781    69.883     0.200
     5.916    86.383     0.200
     7.284   105.883     0.200
    11.382   164.180     0.200
    12.808   182.883     0.200
    17.249   238.883     0.200
    18.507   256.883     0.200
    19.846   271.883     0.200
     1.484    22.641     0.200
     3.358    51.641     0.200
     3.820    59.141     0.200
     3.826    58.141     0.200
     3.832    59.641     0.200
     3.918    59.340     0.200
     7.388   108.641     0.200
    11.290   163.641     0.200
    12.742   180.740     0.200
    17.834   246.840     0.200
    18.111   250.041     0.200
    19.123   263.641     0.200
    19.723   270.641     0.200
    20.012   275.641     0.200
    20.193   278.141     0.200
    20.489   277.441     0.200
    20.775   281.840     0.200
     1.310    22.736     0.200
     3.595    55.336     0.200
     3.597    56.336     0.200
     4.062    61.836     0.200
     4.074    62.336     0.200
     4.072    63.336     0.200
     5.130    76.836     0.200
     6.265    92.836     0.200
    11.291   163.836     0.200
    12.811   184.936     0.200
    17.119   239.836     0.200
    17.198   237.535     0.200
    17.943   247.836     0.200
    18.189   251.836     0.200
     3.172    47.750     0.200
     3.207    49.250     0.200
     3.661    57.750     0.200
     3.666    56.250     0.200
     3.679    57.250     0.200
     4.366    65.750     0.200
     4.722    67.250     0.200
     5.841    84.250     0.200
    10.733   153.750     0.200
    11.321   164.250     0.200
    11.683   166.750     0.200
    11.945   174.250     0.200
    12.114   173.750     0.200
    12.236   177.250     0.200
    12.291   175.750     0.200
    12.438   177.250     0.200
    12.725   181.250     0.200
    17.788   245.949     0.200
    18.498   257.250     0.200
    19.246   267.250     0.200
    19.320   264.750     0.200
    19.843   274.250     0.200
    19.843   275.250     0.200
    20.024   276.250     0.200
    19.958   274.250     0.200
    20.273   278.250     0.200
    20.602   280.250     0.200
     1.401    24.314     0.200
     2.205    35.715     0.200
     3.471    53.215     0.200
     3.515    52.715     0.200
     3.941    60.715     0.200
     3.949    60.715     0.200
     4.013    60.715     0.200
     4.677    69.215     0.200
     6.231    91.516     0.200
    10.718   153.715     0.200
    11.102   161.914     0.200
    11.102   161.715     0.200
    11.135   160.414     0.200
    11.191   162.715     0.200
    12.400   177.715     0.200
    12.609   181.215     0.200
    12.516   179.414     0.200
    12.590   179.965     0.200
    12.615   184.064     0.200
    12.638   181.215     0.200
    12.694   181.715     0.200
    12.820   183.715     0.200
    12.843   184.314     0.200
    13.279   188.715     0.200
    13.431   191.715     0.200
    13.991   198.715     0.200
    18.290   257.176     0.200
    18.596   260.395     0.200
    18.773   257.615     0.200
    18.782   260.715     0.200
    18.866   261.715     0.200
    19.466   267.715     0.200
    20.254   278.215     0.200
    20.386   280.016     0.200
    20.780   282.715     0.200
    20.791   282.715     0.200
    20.909   283.715     0.200
     1.299    23.994     0.200
     2.098    33.994     0.200
     3.623    56.994     0.200
     3.670    55.994     0.200
     4.094    64.494     0.200
     4.163    67.994     0.200
     4.832    74.994     0.200
    12.668   182.994     0.200
    14.134   202.094     0.200
    18.823   258.795     0.200
    18.790   261.994     0.200
    19.393   268.994     0.200
    19.524   268.994     0.200
    20.706   280.994     0.200
    20.716   280.994     0.200
    20.846   283.994     0.200
    20.918   285.994     0.200
     4.012    60.021     0.200
    18.890   262.021     0.200
    19.491   269.021     0.200
    19.620   270.021     0.200
    20.805   283.021     0.200
     1.229    20.326     0.200
     3.605    52.025     0.200
     3.675    52.826     0.200
     4.078    59.326     0.200
     4.084    63.326     0.200
     4.115    59.727     0.200
     4.137    63.326     0.200
     4.826    69.826     0.200
     5.310    76.826     0.200
     6.405    91.326     0.200
     7.786   112.826     0.200
    11.025   160.025     0.200
    14.168   198.926     0.200
    18.709   259.326     0.200
    19.311   267.326     0.200
    19.440   266.326     0.200
    20.071   272.326     0.200
    20.368   275.326     0.200
    20.625   278.326     0.200
    20.635   278.326     0.200
    20.761   279.326     0.200
    20.835   280.326     0.200
     1.799    30.477     0.200
     3.222    51.176     0.200
     3.680    57.176     0.200
     3.681    57.775     0.200
     3.695    58.176     0.200
     3.789    58.676     0.200
     4.382    67.176     0.200
     4.737    71.176     0.200
     5.838    85.176     0.200
     5.857    87.275     0.200
    11.321   165.275     0.200
    13.606   194.676     0.200
    17.197   241.176     0.200
    18.093   250.676     0.200
    19.237   266.176     0.200
    19.858   274.176     0.200
    20.039   277.176     0.200
    20.288   280.176     0.200
    20.336   277.176     0.200
    12.041   171.850     0.200
    13.484   192.049     0.200
    17.679   241.850     0.200
    18.130   249.549     0.200
    18.234   248.748     0.200
    20.067   270.549     0.200
     0.728    14.016     0.200
     3.534    55.516     0.200
     3.565    56.516     0.200
     3.673    56.516     0.200
     4.013    62.016     0.200
     4.043    62.516     0.200
     4.072    62.516     0.200
     4.786    72.516     0.200
     4.893    77.816     0.200
     5.276    80.215     0.200
     5.405    81.016     0.200
     6.453    96.016     0.200
     6.460    95.016     0.200
     7.846   115.016     0.200
     9.582   138.316     0.200
     9.758   139.016     0.200
     9.947   144.016     0.200
    10.040   144.016     0.200
    11.204   163.016     0.200
    16.728   231.516     0.200
    18.550   253.016     0.200
    19.096   264.016     0.200
    19.217   265.016     0.200
    19.855   271.016     0.200
    20.411   277.016     0.200
    20.422   276.016     0.200
    20.536   278.016     0.200
     2.790    46.031     0.200
     2.862    45.930     0.200
     3.209    53.531     0.200
     3.299    52.031     0.200
     3.735    59.734     0.200
     5.548    84.531     0.200
     5.801    90.734     0.200
     6.694   102.734     0.200
    17.948   246.133     0.200
    18.174   248.734     0.200
    18.468   252.328     0.200
    18.930   257.031     0.200
    19.802   273.031     0.200
    19.891   270.031     0.200
    20.557   280.031     0.200
     1.973    33.369     0.200
     2.926    46.149     0.200
     2.960    45.149     0.200
     2.988    47.149     0.200
     3.405    52.350     0.200
     3.498    55.340     0.200
     3.644    57.350     0.200
     3.841    57.850     0.200
     5.699    84.850     0.200
     5.994    87.350     0.200
     6.120    91.149     0.200
    19.181   262.850     0.200
    19.773   269.850     0.200
    20.529   277.850     0.200
     2.415    38.801     0.200
     3.732    57.551     0.200
     3.742    57.051     0.200
     3.930    60.051     0.200
     4.055    60.551     0.200
     4.194    65.051     0.200
     4.696    72.051     0.200
    16.485   227.051     0.200
    19.465   264.551     0.200
    20.020   271.551     0.200
    20.146   271.551     0.200
    20.227   271.551     0.200
     0.949    15.613     0.200
     1.393    23.613     0.200
     2.404    38.113     0.200
     3.558    53.413     0.200
     3.612    53.113     0.200
     4.006    63.113     0.200
     4.449    69.613     0.200
     4.465    67.213     0.200
     4.757    72.613     0.200
     5.270    75.413     0.200
     5.628    83.213     0.200
     6.360    92.713     0.200
     7.738   110.613     0.200
    10.975   158.713     0.200
    18.706   259.613     0.200
    19.274   263.913     0.200
    19.306   265.613     0.200
    19.431   264.613     0.200
    19.871   270.213     0.200
    20.066   271.613     0.200
    20.620   278.613     0.200
    20.631   277.613     0.200
    20.751   279.613     0.200
    20.829   282.613     0.200
     0.926    16.922     0.200
     1.118    20.922     0.200
     1.273    23.223     0.200
     2.124    34.922     0.200
     3.432    50.621     0.200
     3.391    51.723     0.200
     3.444    53.824     0.200
     4.219    64.723     0.200
     4.513    67.023     0.200
     5.387    80.824     0.200
     5.659    84.223     0.200
     6.176    90.723     0.200
     6.353    92.723     0.200
     7.563   107.723     0.200
    17.989   246.422     0.200
    18.463   254.324     0.200
    18.500   251.621     0.200
    19.301   265.324     0.200
     0.194    13.805     0.200
     0.572    15.805     0.200
     0.795    16.805     0.200
     2.247    38.602     0.200
     2.955    47.406     0.200
     4.083    63.805     0.200
     4.571    71.305     0.200
     4.603    71.805     0.200
     4.889    72.406     0.200
     4.905    76.008     0.200
     5.787    88.703     0.200
     6.753   102.406     0.200
     8.156   118.805     0.200
    17.001   231.008     0.200
    17.181   236.445     0.200
    17.704   240.484     0.200
    18.410   249.406     0.200
    19.094   259.195     0.200
    19.629   264.695     0.200
     0.965    16.859     0.200
     1.126    20.359     0.200
     2.412    38.859     0.200
     3.462    54.359     0.200
     3.660    57.359     0.200
     3.782    57.359     0.200
     3.816    57.160     0.200
     4.110    60.859     0.200
     4.110    62.859     0.200
     4.175    60.359     0.200
     4.593    69.359     0.200
     5.382    79.461     0.200
     6.574    96.660     0.200
    11.318   161.859     0.200
    16.629   229.938     0.200
    16.717   230.961     0.200
    18.452   253.961     0.200
    19.001   261.230     0.200
    19.566   266.379     0.200
    20.099   272.730     0.200
    20.446   276.008     0.200
     1.601    26.820     0.200
     1.559    26.621     0.200
     1.706    29.121     0.200
     2.633    39.223     0.200
     2.757    42.422     0.200
     3.031    46.121     0.200
     3.480    52.320     0.200
     3.770    56.520     0.200
     4.641    69.020     0.200
     6.144    91.020     0.200
     9.316   130.621     0.200
    10.188   146.422     0.200
    10.922   155.121     0.200
    10.922   155.520     0.200
    10.922   155.922     0.200
    16.521   226.590     0.200
    17.791   243.520     0.200
    18.312   248.422     0.200
    18.391   250.121     0.200
     0.099    14.377     0.200
     0.463    15.576     0.200
     2.356    39.178     0.200
     2.652    41.576     0.200
     2.884    46.477     0.200
     3.901    58.576     0.200
     4.030    61.477     0.200
     4.160    63.377     0.200
     4.222    65.178     0.200
     4.257    64.377     0.200
     4.291    64.977     0.200
     4.311    65.178     0.200
     4.436    67.076     0.200
     4.569    68.678     0.200
     4.716    72.178     0.200
     4.750    72.377     0.200
     4.690    69.377     0.200
     5.054    76.777     0.200
     5.935    88.377     0.200
     5.987    88.076     0.200
     6.933   103.277     0.200
     7.899   112.377     0.200
     7.991   115.877     0.200
    10.018   143.576     0.200
    15.999   219.018     0.200
    17.084   233.877     0.200
    17.806   241.777     0.200
    17.964   243.076     0.200
    18.293   250.678     0.200
    18.464   248.977     0.200
    19.302   263.178     0.200
    19.422   261.367     0.200
    19.721   264.107     0.200
    19.743   264.107     0.200
     1.423    23.492     0.200
     1.682    28.766     0.200
     2.239    36.984     0.200
     2.369    37.750     0.200
     2.692    41.539     0.200
     3.122    47.789     0.200
     3.206    49.719     0.200
     3.237    50.305     0.200
     3.279    51.555     0.200
     3.513    54.805     0.200
     3.655    57.016     0.200
     3.679    56.445     0.200
     3.696    57.562     0.200
     3.705    57.484     0.200
     3.816    58.930     0.200
     3.845    59.164     0.200
     3.852    59.500     0.200
     4.129    63.641     0.200
     4.151    62.914     0.200
     5.277    80.234     0.200
     5.944    89.445     0.200
     6.063    89.523     0.200
     6.871   101.023     0.200
     7.147   104.562     0.200
     8.028   115.031     0.200
     9.154   134.281     0.200
     9.859   143.062     0.200
    10.655   154.852     0.200
    11.196   160.961     0.200
    17.755   245.062     0.200
    17.992   246.359     0.200
    19.103   262.391     0.200
    19.664   268.164     0.200
    19.664   268.750     0.200
    20.851   281.469     0.200
     1.421    25.148     0.200
     2.309    38.818     0.200
     2.441    40.148     0.200
     2.686    43.248     0.200
     3.116    50.039     0.200
     3.237    50.878     0.200
     3.268    50.888     0.200
     3.331    53.578     0.200
     3.562    57.839     0.200
     3.699    58.539     0.200
     3.744    58.888     0.200
     3.756    58.958     0.200
     3.865    60.508     0.200
     3.896    60.729     0.200
     4.170    65.808     0.200
     4.203    65.159     0.200
     4.835    73.818     0.200
     5.314    81.798     0.200
     5.956    91.708     0.200
     6.113    91.888     0.200
    11.268   163.589     0.200
    18.881   258.888     0.200
    19.710   270.789     0.200
     1.113    19.503     0.200
     2.130    36.453     0.200
     2.383    37.663     0.200
     2.512    42.093     0.200
     2.813    45.733     0.200
     2.961    47.193     0.200
     3.064    49.953     0.200
     3.286    54.433     0.200
     3.411    54.403     0.200
     3.465    54.193     0.200
     3.486    57.533     0.200
     3.609    56.693     0.200
     3.626    57.503     0.200
     3.877    61.453     0.200
     5.013    79.693     0.200
     5.641    86.473     0.200
    11.325   165.593     0.200
    18.866   261.193     0.200
    19.921   273.393     0.200
     1.252    22.023     0.200
     1.799    31.719     0.200
     2.179    37.211     0.200
     2.448    40.062     0.200
     2.521    39.750     0.200
     2.951    46.328     0.200
     3.086    48.242     0.200
     3.162    51.031     0.200
     3.389    54.094     0.200
     3.522    55.773     0.200
     3.539    55.039     0.200
     3.570    55.000     0.200
     3.586    56.719     0.200
     3.693    58.422     0.200
     3.720    58.508     0.200
     3.726    58.602     0.200
     3.991    63.039     0.200
     4.034    62.133     0.200
     4.274    64.609     0.200
     5.133    76.102     0.200
     5.778    88.406     0.200
     6.203    92.500     0.200
    10.486   153.688     0.200
    17.076   236.500     0.200
    17.776   246.500     0.200
    18.014   249.703     0.200
    19.808   271.844     0.200
     1.157    19.637     0.200
     1.961    33.906     0.200
     2.265    37.805     0.200
     2.417    37.586     0.200
     2.607    42.156     0.200
     2.846    44.605     0.200
     3.026    47.664     0.200
     3.055    48.355     0.200
     3.186    49.676     0.200
     3.522    55.637     0.200
     3.528    54.266     0.200
     3.581    56.586     0.200
     3.607    56.688     0.200
     3.721    58.734     0.200
     3.985    62.195     0.200
     4.055    62.324     0.200
     4.263    66.625     0.200
     4.567    68.145     0.200
     5.114    78.586     0.200
     5.705    86.805     0.200
    11.427   165.387     0.200
    18.151   250.688     0.200
    19.963   272.887     0.200
     0.553    14.805     0.200
     1.549    26.395     0.200
     1.860    30.425     0.200
     2.017    33.624     0.200
     2.087    33.244     0.200
     3.338    52.314     0.200
     3.516    54.084     0.200
     3.600    55.935     0.200
     3.750    58.175     0.200
     3.760    56.645     0.200
     3.782    58.345     0.200
     3.792    58.515     0.200
     3.792    59.024     0.200
     3.885    59.694     0.200
     4.184    64.614     0.200
     4.249    64.895     0.200
     4.298    65.954     0.200
     4.298    66.084     0.200
     4.298    66.354     0.200
     4.564    70.215     0.200
     5.213    76.954     0.200
     5.429    79.965     0.200
     5.480    83.234     0.200
     6.396    95.034     0.200
     6.402    95.484     0.200
     7.439   109.114     0.200
    10.364   149.734     0.200
    12.835   179.207     0.200
    13.255   188.185     0.200
    18.833   256.680     0.200
    19.646   264.794     0.200
    19.908   267.114     0.200
    20.036   267.675     0.200
     1.217    21.086     0.200
     1.451    25.234     0.200
     2.362    38.289     0.200
     2.488    39.336     0.200
     2.667    41.508     0.200
     2.964    46.438     0.200
     2.918    45.070     0.200
     2.995    47.977     0.200
     3.046    48.547     0.200
     3.147    50.547     0.200
     3.276    51.469     0.200
     3.415    54.695     0.200
     3.437    54.266     0.200
     3.459    53.438     0.200
     3.459    55.750     0.200
     3.471    55.648     0.200
     3.558    56.750     0.200
     3.611    57.781     0.200
     3.833    62.227     0.200
     3.887    60.961     0.200
     3.887    61.820     0.200
     3.887    62.914     0.200
     3.952    60.938     0.200
     4.128    64.359     0.200
     4.280    68.938     0.200
     5.035    74.984     0.200
     5.714    86.938     0.200
    11.177   161.898     0.200
    11.177   163.234     0.200
    12.540   180.898     0.200
    19.775   271.320     0.200
    20.515   278.219     0.200
    20.738   281.664     0.200
    20.835   281.414     0.200
    20.961   282.648     0.200
     1.359    23.158     0.200
     2.365    39.350     0.200
     2.476    40.949     0.200
     2.462    39.789     0.200
     2.731    43.029     0.200
     3.160    48.850     0.200
     3.296    50.779     0.200
     3.392    54.090     0.200
     3.490    54.359     0.200
     3.623    58.979     0.200
     3.703    58.299     0.200
     3.805    61.988     0.200
     3.817    61.100     0.200
     3.911    62.789     0.200
     4.179    66.959     0.200
     4.230    65.189     0.200
     4.298    64.869     0.200
     4.468    69.609     0.200
     4.621    73.289     0.200
     5.373    81.510     0.200
     6.009    89.289     0.200
    11.289   164.670     0.200
    11.289   163.988     0.200
    12.737   184.529     0.200
    14.184   203.670     0.200
    15.895   224.750     0.200
    16.405   230.809     0.200
    16.485   231.068     0.200
    18.972   263.699     0.200
    19.697   270.824     0.200
    20.584   280.619     0.200
     2.139    37.422     0.200
     2.767    46.648     0.200
     4.037    64.797     0.200
     4.321    68.516     0.200
     4.338    69.734     0.200
     4.467    69.922     0.200
     4.588    72.867     0.200
     4.702    75.234     0.200
     4.744    75.906     0.200
     4.782    75.938     0.200
     4.778    76.375     0.200
     4.781    74.438     0.200
     4.844    76.742     0.200
     4.881    75.273     0.200
     4.935    79.047     0.200
     5.169    80.328     0.200
     5.243    80.047     0.200
     5.271    82.922     0.200
     5.271    83.266     0.200
     5.532    88.039     0.200
     6.448    96.758     0.200
     7.259   109.133     0.200
    10.672   157.727     0.200
    10.672   159.016     0.200
    11.720   172.328     0.200
    12.453   182.859     0.200
    13.520   196.109     0.200
    13.592   195.859     0.200
    18.534   260.773     0.200
    20.269   277.875     0.200
    21.007   286.062     0.200
    21.010   286.273     0.200
    20.976   286.656     0.200
     1.148    20.270     0.200
     2.045    35.711     0.200
     2.111    35.551     0.200
     2.419    39.840     0.200
     2.468    39.840     0.200
     2.746    43.328     0.200
     2.849    44.328     0.200
     2.946    48.129     0.200
     3.064    48.750     0.200
     3.176    50.320     0.200
     3.288    52.949     0.200
     3.432    55.820     0.200
     3.469    53.840     0.200
     3.469    55.660     0.200
     3.469    55.840     0.200
     3.487    54.520     0.200
     3.568    57.852     0.200
     3.582    55.750     0.200
     3.627    57.852     0.200
     3.840    60.828     0.200
     3.886    60.852     0.200
     3.886    61.180     0.200
     3.886    61.512     0.200
     3.965    61.180     0.200
     4.122    62.352     0.200
     4.562    69.270     0.200
     4.701    71.488     0.200
     5.026    74.559     0.200
     5.661    85.930     0.200
     5.668    86.660     0.200
     6.069    91.512     0.200
     6.595    97.668     0.200
     7.761   114.961     0.200
     9.584   140.840     0.200
    10.135   147.352     0.200
    10.379   152.211     0.200
    11.282   163.715     0.200
    11.825   173.641     0.200
    12.065   177.918     0.200
    12.236   180.031     0.200
    12.635   180.668     0.200
    13.354   188.109     0.200
    13.692   191.648     0.200
    16.968   234.859     0.200
    18.292   250.250     0.200
    18.796   262.211     0.200
    18.912   263.559     0.200
    19.074   263.512     0.200
    19.288   267.859     0.200
    19.416   270.590     0.200
    19.439   271.711     0.200
    19.686   272.762     0.200
    19.720   271.570     0.200
    19.875   272.691     0.200
    19.818   273.551     0.200
    19.819   273.691     0.200
    20.117   276.680     0.200
    20.476   280.340     0.200
    20.841   282.941     0.200
     1.094    18.488     0.200
     1.975    34.238     0.200
     2.366    36.848     0.200
     2.451    39.547     0.200
     2.795    42.367     0.200
     2.791    44.457     0.200
     2.870    45.289     0.200
     2.985    47.590     0.200
     3.098    49.609     0.200
     3.209    49.887     0.200
     3.354    52.250     0.200
     3.390    53.938     0.200
     3.408    54.520     0.200
     3.489    54.637     0.200
     3.503    54.316     0.200
     3.548    55.289     0.200
     3.761    57.770     0.200
     3.807    58.418     0.200
     3.807    58.938     0.200
     3.807    59.359     0.200
     3.885    59.199     0.200
     4.044    61.988     0.200
     4.505    67.520     0.200
     4.948    72.758     0.200
     5.601    82.848     0.200
    11.257   163.887     0.200
    11.257   162.797     0.200
    12.591   180.590     0.200
    14.164   202.098     0.200
    16.585   229.328     0.200
    16.924   234.660     0.200
    19.073   263.750     0.200
    19.893   272.648     0.200
     1.108    19.414     0.200
     2.050    35.000     0.200
     2.378    37.500     0.200
     2.503    40.906     0.200
     2.808    43.594     0.200
     2.788    45.438     0.200
     2.919    46.242     0.200
     3.050    50.086     0.200
     3.166    49.664     0.200
     3.272    52.594     0.200
     3.410    53.281     0.200
     3.452    55.094     0.200
     3.452    55.734     0.200
     3.473    54.203     0.200
     3.548    55.781     0.200
     3.569    56.375     0.200
     3.613    55.750     0.200
     3.821    60.977     0.200
     3.864    60.203     0.200
     3.864    60.820     0.200
     3.948    61.023     0.200
     4.099    62.867     0.200
     4.522    68.344     0.200
     5.001    74.594     0.200
     5.633    85.594     0.200
     6.556    96.805     0.200
    11.315   163.391     0.200
    11.315   164.094     0.200
    16.992   235.586     0.200
    19.918   272.836     0.200
     1.219    22.172     0.200
     2.127    35.508     0.200
     2.487    41.359     0.200
     2.487    40.602     0.200
     2.689    43.984     0.200
     2.917    45.602     0.200
     3.038    49.758     0.200
     3.158    50.508     0.200
     3.269    53.562     0.200
     3.383    54.062     0.200
     3.563    56.508     0.200
     3.563    57.102     0.200
     3.582    55.930     0.200
     3.663    57.508     0.200
     3.675    58.672     0.200
     3.722    59.062     0.200
     3.934    61.844     0.200
     3.980    61.602     0.200
     3.980    63.328     0.200
     4.059    61.672     0.200
     4.634    70.695     0.200
     5.119    76.461     0.200
     5.751    86.602     0.200
    11.308   163.547     0.200
     1.136    19.426     0.200
     2.091    34.516     0.200
     2.404    38.453     0.200
     2.519    39.383     0.200
     2.834    44.723     0.200
     3.094    48.926     0.200
     3.210    49.773     0.200
     3.316    51.594     0.200
     3.452    53.113     0.200
     3.495    54.996     0.200
     3.495    56.234     0.200
     3.591    55.312     0.200
     3.613    57.363     0.200
     3.657    56.594     0.200
     3.865    62.336     0.200
     3.907    60.715     0.200
     3.907    61.145     0.200
     3.992    60.496     0.200
     4.141    64.293     0.200
     4.550    68.453     0.200
     4.754    72.246     0.200
     5.043    76.723     0.200
     5.667    84.906     0.200
    11.334   166.656     0.200
    11.334   163.809     0.200
    13.404   190.164     0.200
    18.343   253.355     0.200
    19.120   264.656     0.200
    19.914   271.938     0.200
     1.283    20.922     0.200
     2.210    36.452     0.200
     2.453    39.412     0.200
     2.551    42.602     0.200
     2.627    41.182     0.200
     2.981    45.082     0.200
     3.092    49.992     0.200
     3.199    50.902     0.200
     3.304    52.872     0.200
     3.426    56.602     0.200
     3.623    58.582     0.200
     3.710    59.002     0.200
     3.714    60.792     0.200
     3.763    59.422     0.200
     3.980    59.882     0.200
     4.029    65.682     0.200
     4.102    63.932     0.200
     4.266    68.072     0.200
     5.171    78.072     0.200
     5.812    88.022     0.200
    11.278   165.002     0.200
    11.278   164.462     0.200
    12.671   181.722     0.200
    17.003   236.212     0.200
     1.143    20.746     0.200
     1.545    27.805     0.200
     2.462    40.844     0.200
     2.844    44.625     0.200
     3.054    49.035     0.200
     3.165    51.266     0.200
     3.459    53.355     0.200
     3.477    56.316     0.200
     3.571    57.555     0.200
     3.617    57.375     0.200
     3.830    62.484     0.200
     3.876    61.457     0.200
     3.876    61.945     0.200
     3.954    63.836     0.200
     4.112    63.855     0.200
     4.693    72.734     0.200
     5.016    74.285     0.200
     5.662    86.906     0.200
    10.373   154.934     0.200
    11.275   164.957     0.200
    11.275   164.285     0.200
    12.626   181.867     0.200
    13.344   189.824     0.200
    14.181   201.465     0.200
    18.775   258.555     0.200
    18.792   262.316     0.200
    18.868   261.906     0.200
    18.907   265.117     0.200
    19.070   264.707     0.200
    19.181   266.887     0.200
    19.783   272.934     0.200
    19.813   273.305     0.200
    19.812   274.145     0.200
    19.815   273.145     0.200
    19.955   275.566     0.200
    19.874   274.086     0.200
    20.112   277.375     0.200
    20.839   284.957     0.200
     1.222    21.500     0.200
     1.321    21.930     0.200
     1.908    31.039     0.200
     2.406    39.602     0.200
     2.469    39.672     0.200
     2.662    42.492     0.200
     2.769    44.992     0.200
     2.877    43.992     0.200
     2.851    47.109     0.200
     2.907    48.039     0.200
     2.998    49.301     0.200
     3.239    50.410     0.200
     3.326    52.570     0.200
     3.333    53.480     0.200
     3.594    55.879     0.200
     4.494    68.410     0.200
     4.510    69.301     0.200
     5.418    79.910     0.200
     7.101   105.730     0.200
     1.259    20.937     0.200
     1.745    30.946     0.200
     2.048    35.296     0.200
     2.113    36.246     0.200
     2.382    38.246     0.200
     2.530    39.196     0.200
     2.960    44.736     0.200
     3.027    48.066     0.200
     3.114    50.556     0.200
     3.215    50.187     0.200
     3.344    53.316     0.200
     3.425    53.576     0.200
     3.481    54.206     0.200
     3.503    55.606     0.200
     3.526    55.546     0.200
     3.538    56.246     0.200
     3.633    56.306     0.200
     3.900    60.956     0.200
     3.953    60.126     0.200
     3.953    61.446     0.200
     3.953    62.956     0.200
     4.019    61.716     0.200
     4.671    69.246     0.200
     5.100    77.746     0.200
     5.761    85.866     0.200
     5.768    87.246     0.200
     6.147    91.656     0.200
     6.704    98.766     0.200
     7.499   109.316     0.200
    10.485   154.246     0.200
    11.203   161.416     0.200
    11.203   163.546     0.200
    12.582   180.466     0.200
    13.329   189.406     0.200
    14.106   201.216     0.200
    15.913   224.446     0.200
    16.354   229.536     0.200
    16.914   235.536     0.200
    18.264   253.026     0.200
    18.973   262.596     0.200
     1.070    19.947     0.200
     1.869    32.588     0.200
     1.961    35.348     0.200
     2.342    38.668     0.200
     2.457    40.469     0.200
     2.772    44.848     0.200
     2.844    47.658     0.200
     3.366    53.809     0.200
     4.019    62.707     0.200
     4.923    77.107     0.200
     5.576    85.088     0.200
     7.308   106.059     0.200
    11.261   166.287     0.200
    16.920   235.848     0.200
    19.084   265.969     0.200
     2.190    35.727     0.200
     2.110    36.594     0.200
     2.124    37.859     0.200
     2.191    38.141     0.200
     2.619    42.953     0.200
     2.706    44.430     0.200
     2.821    46.312     0.200
     2.996    46.945     0.200
     3.408    55.359     0.200
     3.442    56.070     0.200
     3.582    57.734     0.200
     3.795    60.320     0.200
     3.795    61.281     0.200
     4.339    66.180     0.200
     4.915    75.852     0.200
     5.471    83.477     0.200
     5.479    83.086     0.200
     7.221   107.375     0.200
    11.506   169.367     0.200
    11.506   168.906     0.200
    12.812   184.391     0.200
    13.473   191.695     0.200
    16.277   230.516     0.200
    16.683   234.922     0.200
    16.840   237.930     0.200
    17.145   239.820     0.200
    19.330   268.211     0.200
     1.994    33.258     0.200
     2.634    41.703     0.200
     2.777    44.148     0.200
     3.906    58.586     0.200
     4.268    64.844     0.200
     4.265    65.586     0.200
     4.336    65.523     0.200
     4.667    70.328     0.200
     5.092    74.969     0.200
     5.092    80.344     0.200
     5.353    78.047     0.200
    10.594   155.375     0.200
    10.594   154.734     0.200
    12.332   176.938     0.200
    13.438   187.734     0.200
    15.570   219.945     0.200
     1.102    19.633     0.200
     1.529    26.602     0.200
     1.762    29.531     0.200
     1.801    30.172     0.200
     2.367    37.234     0.200
     2.315    37.914     0.200
     2.785    42.977     0.200
     2.795    42.883     0.200
     2.775    43.367     0.200
     2.844    45.555     0.200
     3.075    47.797     0.200
     3.157    48.977     0.200
     3.215    50.164     0.200
     3.240    50.102     0.200
     3.257    54.242     0.200
     3.257    49.234     0.200
     3.268    54.516     0.200
     3.356    53.766     0.200
     3.367    52.844     0.200
     3.408    52.453     0.200
     3.689    56.422     0.200
     3.689    58.438     0.200
     3.750    56.734     0.200
     4.513    67.727     0.200
     4.840    73.234     0.200
     5.543    83.164     0.200
     5.550    83.078     0.200
     7.273   106.164     0.200
    11.107   161.086     0.200
    11.107   161.188     0.200
    18.958   261.141     0.200
    19.625   266.562     0.200
     1.853    30.969     0.200
     2.090    33.906     0.200
     1.991    34.750     0.200
     2.115    35.711     0.200
     2.520    40.812     0.200
     2.672    43.297     0.200
     2.668    42.469     0.200
     3.071    46.898     0.200
     3.140    49.750     0.200
     3.184    50.562     0.200
     3.252    51.961     0.200
     3.252    53.219     0.200
     3.287    56.242     0.200
     3.333    55.969     0.200
     3.397    52.445     0.200
     3.642    57.328     0.200
     3.642    55.156     0.200
     3.753    58.406     0.200
     4.764    73.125     0.200
     5.345    81.047     0.200
     5.353    81.219     0.200
     7.091   104.977     0.200
    11.447   168.891     0.200
    11.447   166.469     0.200
    17.049   237.867     0.200
    19.315   267.539     0.200
    19.967   272.078     0.200
    20.901   283.859     0.200
     1.437    25.648     0.200
     1.639    29.008     0.200
     2.141    37.352     0.200
     2.323    38.156     0.200
     2.461    39.719     0.200
     2.707    43.625     0.200
     3.137    49.875     0.200
     3.199    51.141     0.200
     3.494    56.875     0.200
     3.640    58.102     0.200
     3.678    57.508     0.200
     3.678    58.570     0.200
     3.684    57.469     0.200
     3.792    59.055     0.200
     4.055    63.570     0.200
     4.115    65.055     0.200
     4.115    65.305     0.200
     4.115    65.945     0.200
     4.850    74.438     0.200
     5.266    79.805     0.200
     5.368    81.281     0.200
     5.941    90.711     0.200
     5.949    89.750     0.200
     6.015    87.477     0.200
     7.679   113.719     0.200
    11.150   162.914     0.200
    11.150   163.133     0.200
    11.433   167.281     0.200
    12.557   182.617     0.200
    13.373   191.461     0.200
    14.049   200.352     0.200
    14.839   211.219     0.200
    18.301   253.617     0.200
    18.869   263.031     0.200
    19.018   262.008     0.200
    19.069   266.664     0.200
    19.652   270.391     0.200
    19.628   272.656     0.200
    20.067   276.227     0.200
    20.459   279.352     0.200
    20.521   280.039     0.200
    20.855   282.836     0.200
    20.981   284.688     0.200
     1.211    19.340     0.200
     1.983    29.949     0.200
     2.538    39.211     0.200
     2.728    43.668     0.200
     3.230    47.598     0.200
     3.656    53.809     0.200
     3.833    57.438     0.200
     4.139    63.078     0.200
     4.225    65.320     0.200
     4.285    63.980     0.200
     4.310    65.000     0.200
     4.323    64.867     0.200
     4.323    67.039     0.200
     4.466    66.777     0.200
     4.760    69.789     0.200
     4.760    70.910     0.200
     4.760    72.828     0.200
     4.851    72.430     0.200
     5.861    83.000     0.200
     5.908    86.848     0.200
     6.529    96.211     0.200
     6.537    96.141     0.200
     8.277   119.891     0.200
     8.799   126.551     0.200
    11.308   161.949     0.200
    11.308   162.465     0.200
    12.898   182.578     0.200
    13.826   194.000     0.200
    14.185   201.320     0.200
    14.232   201.559     0.200
    14.573   202.590     0.200
    14.996   211.340     0.200
    17.220   237.219     0.200
    18.816   260.129     0.200
    19.422   267.039     0.200
    19.538   267.781     0.200
    19.774   268.648     0.200
    20.273   275.508     0.200
     1.276    21.484     0.200
     1.276    21.211     0.200
     1.603    25.984     0.200
     2.057    33.297     0.200
     2.267    35.391     0.200
     2.477    38.062     0.200
     2.681    43.273     0.200
     3.111    46.195     0.200
     3.137    46.828     0.200
     3.137    48.805     0.200
     3.420    52.352     0.200
     3.420    55.742     0.200
     3.507    54.227     0.200
     3.569    55.211     0.200
     3.598    55.234     0.200
     3.598    56.344     0.200
     3.604    55.727     0.200
     3.604    55.984     0.200
     3.608    54.555     0.200
     3.608    57.516     0.200
     3.748    57.734     0.200
     3.748    60.312     0.200
     4.045    61.367     0.200
     4.045    62.164     0.200
     4.045    64.047     0.200
     4.532    66.945     0.200
     4.532    70.406     0.200
     5.301    77.656     0.200
     5.895    85.477     0.200
     5.903    89.023     0.200
     5.903    87.984     0.200
     7.630   109.484     0.200
    11.093   161.383     0.200
     1.279    22.072     0.200
     1.548    25.452     0.200
     1.680    28.812     0.200
     2.407    40.112     0.200
     2.390    39.452     0.200
     2.812    41.962     0.200
     3.242    50.522     0.200
     3.750    57.662     0.200
     3.832    59.062     0.200
     3.849    58.812     0.200
     3.849    59.112     0.200
     3.849    62.973     0.200
     4.282    65.593     0.200
     4.282    66.562     0.200
     4.522    69.553     0.200
     4.697    72.832     0.200
     5.429    81.032     0.200
     5.532    84.022     0.200
     6.075    91.082     0.200
     6.083    92.002     0.200
     6.461    95.952     0.200
     7.296   107.473     0.200
     7.818   114.672     0.200
    10.550   152.172     0.200
    11.231   162.438     0.200
    13.522   192.382     0.200
    13.740   197.272     0.200
    14.920   212.223     0.200
    17.028   236.263     0.200
    19.048   263.232     0.200
    19.167   262.832     0.200
    19.614   269.973     0.200
    20.069   275.252     0.200
    20.413   278.122     0.200
    20.575   279.002     0.200
    20.962   284.252     0.200
     2.171    36.008     0.200
     2.486    41.961     0.200
     3.312    51.039     0.200
     3.741    56.508     0.200
     3.741    57.008     0.200
     3.767    57.555     0.200
     4.180    66.008     0.200
     4.206    64.617     0.200
     4.206    67.688     0.200
     4.485    70.695     0.200
     4.645    73.008     0.200
     5.558    82.906     0.200
     6.543    98.516     0.200
     6.550    98.008     0.200
     8.276   121.961     0.200
    10.944   158.930     0.200
    13.411   193.617     0.200
    15.550   217.484     0.200
    16.750   233.180     0.200
    16.855   234.570     0.200
    19.144   266.227     0.200
    19.414   268.250     0.200
    19.618   271.367     0.200
     1.795    31.484     0.200
     1.860    31.102     0.200
     2.200    35.781     0.200
     2.500    38.820     0.200
     2.791    43.758     0.200
     2.870    45.344     0.200
     2.928    46.352     0.200
     3.136    49.375     0.200
     3.288    50.539     0.200
     3.321    50.852     0.200
     3.321    51.492     0.200
     3.321    52.648     0.200
     3.321    51.789     0.200
     3.440    53.289     0.200
     3.464    53.398     0.200
     3.766    55.953     0.200
     3.766    57.898     0.200
     3.766    58.172     0.200
     4.517    68.641     0.200
     4.620    67.414     0.200
     5.659    85.070     0.200
     5.666    86.758     0.200
     5.940    88.570     0.200
    12.347   174.523     0.200
    15.786   219.242     0.200
    16.528   230.008     0.200
    16.679   231.328     0.200
    18.012   247.148     0.200
     2.106    34.531     0.200
     2.887    47.055     0.200
     4.294    63.484     0.200
     4.382    67.531     0.200
     4.351    67.062     0.200
     4.694    72.039     0.200
     4.694    74.758     0.200
     4.758    72.523     0.200
     5.051    74.922     0.200
     5.185    78.578     0.200
     6.017    87.133     0.200
     6.378    92.781     0.200
     7.164   103.844     0.200
     7.171   106.031     0.200
     7.582   111.508     0.200
     7.967   115.492     0.200
     7.967   118.938     0.200
     8.128   119.781     0.200
     8.889   130.258     0.200
    12.436   179.430     0.200
    13.553   191.930     0.200
    14.913   211.734     0.200
    15.608   219.508     0.200
    15.639   221.219     0.200
    15.702   222.484     0.200
    15.799   224.078     0.200
    15.959   225.938     0.200
    16.345   228.734     0.200
    16.403   231.258     0.200
    16.403   231.633     0.200
    16.737   233.031     0.200
    18.033   250.750     0.200
    18.591   258.430     0.200
    20.272   277.531     0.200
     1.784    28.586     0.200
     2.137    33.277     0.200
     2.128    35.477     0.200
     2.522    41.918     0.200
     2.580    41.477     0.200
     3.407    51.375     0.200
     3.768    57.336     0.200
     3.837    57.477     0.200
     3.837    58.348     0.200
     3.844    59.156     0.200
     4.156    64.375     0.200
     4.242    65.008     0.200
     4.242    65.148     0.200
     4.276    64.277     0.200
     4.362    68.938     0.200
     4.381    67.598     0.200
     4.628    72.566     0.200
     4.713    71.977     0.200
     4.713    73.875     0.200
     4.713    72.477     0.200
     5.495    81.996     0.200
     5.876    87.477     0.200
     6.631    96.957     0.200
     6.638    97.977     0.200
     6.873   100.777     0.200
     7.004   102.668     0.200
     7.033   103.445     0.200
     7.065   104.027     0.200
     7.496   109.426     0.200
     7.584   111.367     0.200
     8.361   120.676     0.200
     8.475   121.973     0.200
     8.475   125.238     0.200
     8.683   127.598     0.200
    12.496   177.676     0.200
    13.341   191.418     0.200
    13.474   190.578     0.200
    15.305   216.777     0.200
    15.535   218.605     0.200
    15.895   223.738     0.200
    15.894   224.094     0.200
    16.235   227.582     0.200
    16.499   228.898     0.200
    16.678   233.078     0.200
    16.814   233.477     0.200
    18.403   255.156     0.200
    18.415   255.492     0.200
    18.440   254.746     0.200
    18.489   256.820     0.200
    18.543   256.387     0.200
    18.761   259.383     0.200
    18.796   259.348     0.200
    18.995   261.680     0.200
    19.049   262.477     0.200
    19.049   263.066     0.200
    19.103   262.625     0.200
    19.447   267.102     0.200
    19.727   269.031     0.200
    19.792   271.141     0.200
    19.924   272.090     0.200
    20.010   272.988     0.200
    20.204   275.023     0.200
    20.569   279.395     0.200
     0.950    17.438     0.200
     1.488    24.914     0.200
     1.488    24.797     0.200
     1.473    27.008     0.200
     1.473    26.906     0.200
     1.805    29.945     0.200
     2.543    40.234     0.200
     2.543    38.484     0.200
     2.698    41.734     0.200
     2.830    44.078     0.200
     2.838    44.586     0.200
     2.838    44.914     0.200
     3.115    47.266     0.200
     3.115    47.945     0.200
     3.086    47.984     0.200
     3.167    50.039     0.200
     3.167    52.492     0.200
     3.226    50.367     0.200
     3.282    50.438     0.200
     3.652    54.586     0.200
     3.652    58.406     0.200
     3.996    60.695     0.200
     4.528    69.023     0.200
     4.857    72.523     0.200
     5.713    85.516     0.200
     5.719    86.445     0.200
     5.800    87.594     0.200
     7.409   108.570     0.200
     7.409   108.344     0.200
    11.923   172.578     0.200
    13.155   187.117     0.200
    15.434   216.016     0.200
    17.608   240.117     0.200
    18.465   252.508     0.200
    19.133   261.375     0.200
     2.096    34.635     0.200
     2.720    41.734     0.200
     2.905    47.555     0.200
     3.991    60.074     0.200
     3.991    62.125     0.200
     4.328    63.766     0.200
     4.382    66.984     0.200
     4.421    67.635     0.200
     4.529    70.205     0.200
     4.719    73.635     0.200
     4.786    75.125     0.200
     4.821    74.584     0.200
     5.013    77.605     0.200
     5.183    81.115     0.200
     5.212    80.635     0.200
     6.050    93.084     0.200
     7.206   107.635     0.200
     7.206   106.635     0.200
     7.926   115.846     0.200
     8.166   120.695     0.200
     8.922   129.834     0.200
     8.922   130.855     0.200
    10.652   153.787     0.200
    10.652   155.234     0.200
    12.419   179.936     0.200
    13.052   187.154     0.200
    14.877   211.734     0.200
    15.022   210.744     0.200
    15.451   218.723     0.200
    16.322   228.105     0.200
    16.719   232.834     0.200
    18.324   255.045     0.200
    18.320   254.955     0.200
    18.364   255.584     0.200
    18.546   257.514     0.200
    18.552   257.635     0.200
    18.552   258.084     0.200
    18.552   257.775     0.200
    18.552   257.910     0.200
    18.580   257.439     0.200
    18.615   258.400     0.200
    18.896   259.965     0.200
    18.896   260.484     0.200
    18.942   262.248     0.200
    19.073   262.535     0.200
    19.140   263.951     0.200
    19.274   265.689     0.200
    19.297   266.506     0.200
    19.441   267.516     0.200
    19.490   267.900     0.200
    19.492   267.580     0.200
    19.644   269.189     0.200
    19.675   270.047     0.200
    19.731   270.512     0.200
    19.808   269.984     0.200
    19.811   271.389     0.200
    19.838   271.635     0.200
    19.884   272.234     0.200
    19.963   272.777     0.200
    20.050   274.035     0.200
    20.060   273.900     0.200
    20.053   273.420     0.200
    20.274   276.215     0.200
    20.283   276.105     0.200
    20.308   276.143     0.200
    20.310   275.936     0.200
    20.310   276.568     0.200
    20.340   276.754     0.200
    20.375   277.211     0.200
    20.507   278.855     0.200
    20.543   279.029     0.200
    20.633   280.223     0.200
    20.632   280.605     0.200
    20.725   281.260     0.200
    20.747   281.334     0.200
    21.008   283.734     0.200
    20.979   283.805     0.200
    20.987   284.086     0.200
    20.989   283.945     0.200
     2.226    37.664     0.200
     2.414    39.395     0.200
     2.414    38.395     0.200
     2.697    44.055     0.200
     3.114    49.383     0.200
     3.235    51.195     0.200
     3.349    53.133     0.200
     3.552    56.156     0.200
     3.713    58.164     0.200
     3.713    58.496     0.200
     3.735    58.965     0.200
     3.856    60.754     0.200
     4.164    64.395     0.200
     4.164    66.203     0.200
     4.164    65.266     0.200
     4.268    68.105     0.200
     4.844    75.016     0.200
     5.264    80.156     0.200
     5.953    88.246     0.200
     5.953    89.164     0.200
     5.961    89.895     0.200
     6.079    90.004     0.200
     6.344    94.996     0.200
     6.879   102.566     0.200
     7.695   112.520     0.200
    10.428   151.996     0.200
    11.242   163.945     0.200
    12.676   182.906     0.200
    13.762   197.523     0.200
    13.975   196.355     0.200
    15.526   220.574     0.200
    15.873   223.094     0.200
    16.787   234.613     0.200
    18.946   264.023     0.200
    19.702   271.746     0.200
    19.688   271.176     0.200
    19.688   271.793     0.200
    19.742   270.223     0.200
    19.742   273.594     0.200
    20.857   286.133     0.200
     2.257    38.172     0.200
     2.715    43.477     0.200
     2.715    45.477     0.200
     2.755    46.422     0.200
     3.986    61.555     0.200
     3.986    63.555     0.200
     4.271    65.453     0.200
     4.302    65.945     0.200
     4.416    69.375     0.200
     4.601    71.227     0.200
     4.601    74.227     0.200
     4.686    72.023     0.200
     4.686    75.602     0.200
     4.700    73.031     0.200
     4.700    75.180     0.200
     4.880    74.383     0.200
     4.917    76.039     0.200
     7.150   108.359     0.200
     7.230   110.859     0.200
     7.364   109.031     0.200
     7.860   119.555     0.200
     8.204   122.570     0.200
     8.862   131.094     0.200
    10.456   152.812     0.200
    10.575   153.023     0.200
    11.610   169.516     0.200
    12.029   175.633     0.200
    12.207   179.062     0.200
    12.867   187.984     0.200
    13.334   191.656     0.200
    14.903   212.391     0.200
    15.388   218.414     0.200
    15.494   223.086     0.200
    15.589   223.773     0.200
    16.119   228.789     0.200
    16.508   232.352     0.200
    18.195   253.453     0.200
    18.445   259.609     0.200
    18.445   258.430     0.200
    18.724   262.195     0.200
    19.635   273.414     0.200
    19.935   275.562     0.200
    19.956   275.633     0.200
     0.408    10.227     0.200
     1.608    25.676     0.200
     1.608    24.504     0.200
     2.032    33.574     0.200
     2.032    34.574     0.200
     2.072    32.574     0.200
     2.878    43.906     0.200
     3.029    45.586     0.200
     3.187    48.953     0.200
     3.258    50.555     0.200
     3.258    51.125     0.200
     3.306    49.055     0.200
     3.803    59.273     0.200
     4.134    62.566     0.200
     4.134    63.566     0.200
     4.155    64.543     0.200
     4.355    66.215     0.200
     4.912    72.586     0.200
     5.007    73.074     0.200
     5.290    80.246     0.200
     0.566    12.756     0.200
     1.854    30.196     0.200
     1.854    31.026     0.200
     2.853    44.156     0.200
     2.950    44.896     0.200
     2.950    44.676     0.200
     3.178    47.976     0.200
     3.214    48.846     0.200
     3.568    54.866     0.200
     3.619    55.256     0.200
     3.984    60.126     0.200
     4.049    61.916     0.200
     5.056    73.876     0.200
     5.239    77.936     0.200
     6.058    89.616     0.200
     6.200    90.566     0.200
     6.986   101.696     0.200
     7.074   102.656     0.200
     7.768   112.240     0.200
     9.482   134.796     0.200
     9.684   139.076     0.200
    10.667   153.831     0.200
    10.772   155.113     0.200
    10.795   155.391     0.200
    10.923   157.733     0.200
    11.421   164.331     0.200
    12.032   171.935     0.200
    12.112   172.036     0.200
    12.163   174.057     0.200
    12.241   174.891     0.200
    12.424   177.937     0.200
    12.658   180.716     0.200
    12.685   181.494     0.200
    12.814   181.286     0.200
    12.960   183.836     0.200
    13.195   187.056     0.200
    13.408   190.048     0.200
    13.524   192.206     0.200
    13.567   193.146     0.200
    13.587   192.631     0.200
    13.633   193.500     0.200
    13.937   197.444     0.200
    13.982   196.708     0.200
    14.049   198.659     0.200
    14.154   199.734     0.200
    14.189   200.748     0.200
    14.271   201.798     0.200
    14.490   204.272     0.200
    14.518   204.548     0.200
    14.602   204.183     0.200
    14.764   207.858     0.200
    14.781   208.333     0.200
    14.910   209.840     0.200
    15.202   214.248     0.200
    15.265   212.693     0.200
    15.294   215.081     0.200
    15.327   215.417     0.200
    15.358   215.506     0.200
    15.387   216.245     0.200
    15.392   215.659     0.200
    15.489   217.270     0.200
    15.567   218.204     0.200
    15.803   221.396     0.200
    15.866   220.981     0.200
    15.971   223.751     0.200
    15.977   223.252     0.200
    15.998   223.635     0.200
    16.335   227.547     0.200
    16.357   226.861     0.200
    16.374   228.047     0.200
    16.440   227.916     0.200
    16.519   229.637     0.200
    16.570   229.691     0.200
    16.597   230.646     0.200
    16.655   231.267     0.200
    16.707   231.752     0.200
    17.008   235.937     0.200
    17.148   236.574     0.200
    17.160   237.614     0.200
    17.198   237.155     0.200
    17.209   237.206     0.200
    17.285   238.666     0.200
    17.392   240.510     0.200
    17.429   241.046     0.200
    17.503   241.876     0.200
    17.845   245.934     0.200
    18.110   248.868     0.200
    18.211   251.351     0.200
    18.416   252.309     0.200
    18.416   254.136     0.200
    19.145   260.576     0.200
    19.193   261.387     0.200
     1.626    31.785     0.200
     2.391    41.188     0.200
     2.630    44.098     0.200
     2.695    45.734     0.200
     2.815    46.535     0.200
     2.949    50.746     0.200
     3.050    51.035     0.200
     3.251    53.848     0.200
     3.276    54.656     0.200
     3.343    54.945     0.200
     3.581    61.395     0.200
     3.622    59.258     0.200
     4.352    68.727     0.200
     4.492    70.207     0.200
     5.505    84.895     0.200
     6.510    99.688     0.200
     7.224   108.637     0.200
     1.760    28.771     0.200
     1.773    30.230     0.200
     2.148    34.631     0.200
     2.432    39.922     0.200
     2.548    42.072     0.200
     2.862    45.561     0.200
     3.010    48.361     0.200
     7.445   110.086     0.200
    11.368   166.787     0.200
    11.629   170.199     0.200
    12.126   177.146     0.200
    12.154   176.453     0.200
    12.170   177.131     0.200
    12.716   185.330     0.200
    12.722   184.793     0.200
    12.858   186.383     0.200
    13.526   194.564     0.200
    13.676   194.371     0.200
    13.909   199.355     0.200
    14.271   204.861     0.200
    14.302   203.803     0.200
    14.356   205.848     0.200
    14.675   208.371     0.200
    15.302   215.803     0.200
    16.076   226.832     0.200
    16.563   233.039     0.200
    17.272   241.312     0.200
    18.532   257.949     0.200
    18.728   258.453     0.200
    18.835   260.523     0.200
    18.930   261.861     0.200
    19.137   264.322     0.200
    19.356   266.170     0.200
    19.450   266.939     0.200
    19.616   268.699     0.200
    19.630   269.881     0.200
    19.697   269.596     0.200
    19.743   271.168     0.200
    19.795   271.547     0.200
    19.865   271.980     0.200
    19.865   271.566     0.200
    19.878   273.281     0.200
    19.878   272.283     0.200
    20.285   278.227     0.200
    20.290   276.342     0.200
    20.389   279.076     0.200
    20.772   284.225     0.200
    20.766   284.791     0.200
    20.789   282.553     0.200
     0.710    13.781     0.200
     1.349    22.438     0.200
     1.506    25.180     0.200
     1.795    29.047     0.200
     2.106    34.234     0.200
     2.546    40.891     0.200
     2.610    40.227     0.200
     2.949    46.328     0.200
     3.037    46.125     0.200
     3.188    48.969     0.200
     3.189    51.211     0.200
     3.294    53.367     0.200
     3.357    52.398     0.200
     3.375    53.820     0.200
     3.388    53.180     0.200
     3.490    56.086     0.200
     3.830    57.500     0.200
     3.860    61.859     0.200
     3.863    58.719     0.200
     4.338    65.211     0.200
     4.725    70.539     0.200
     5.755    86.078     0.200
     5.945    84.711     0.200
     6.748    99.297     0.200
     7.088   103.586     0.200
     7.476   109.086     0.200
     7.476   109.289     0.200
     9.374   135.367     0.200
    10.918   157.156     0.200
    11.017   159.828     0.200
    11.182   162.500     0.200
    11.678   169.336     0.200
    11.702   168.836     0.200
    12.264   176.742     0.200
    12.274   176.977     0.200
    12.407   178.852     0.200
    12.510   180.602     0.200
    12.911   185.453     0.200
    12.918   185.070     0.200
    13.042   184.328     0.200
    13.082   187.789     0.200
    13.235   189.828     0.200
    13.468   190.734     0.200
    13.468   192.680     0.200
    13.661   195.117     0.200
    13.860   197.523     0.200
    14.224   201.703     0.200
    15.498   216.953     0.200
    16.433   227.680     0.200
    16.430   227.727     0.200
    16.617   230.445     0.200
    17.544   239.117     0.200
    17.945   247.180     0.200
    17.992   248.016     0.200
    18.082   249.789     0.200
    18.287   251.750     0.200
    18.415   253.492     0.200
    18.494   254.609     0.200
    18.669   256.477     0.200
    18.715   255.648     0.200
    18.718   256.578     0.200
    18.729   258.211     0.200
    18.729   257.195     0.200
    18.916   258.445     0.200
    19.043   261.016     0.200
    19.156   261.141     0.200
    19.203   261.789     0.200
    19.201   261.992     0.200
    19.247   262.008     0.200
    19.267   263.297     0.200
    19.296   263.109     0.200
    19.409   265.133     0.200
    19.432   265.359     0.200
    19.432   264.539     0.200
    19.431   264.781     0.200
    19.431   263.766     0.200
    19.462   265.023     0.200
    19.600   267.047     0.200
    19.617   266.008     0.200
    19.712   266.883     0.200
    19.719   267.320     0.200
    19.871   269.398     0.200
    19.982   271.547     0.200
    19.994   270.172     0.200
    20.021   271.062     0.200
    20.077   271.438     0.200
    20.270   273.109     0.200
    20.349   274.227     0.200
    20.409   275.359     0.200
    20.456   275.312     0.200
    20.577   277.648     0.200
    20.664   278.312     0.200
    20.789   279.062     0.200
     0.906    15.664     0.200
     1.038    17.145     0.200
     2.175    33.895     0.200
     2.532    41.672     0.200
     2.976    47.305     0.200
     3.130    50.633     0.200
     3.142    50.723     0.200
     3.596    58.074     0.200
     3.635    57.645     0.200
     4.306    64.934     0.200
     4.681    71.395     0.200
     5.381    81.215     0.200
     6.335    93.652     0.200
     6.335    93.305     0.200
     7.118   104.402     0.200
     9.854   143.762     0.200
    10.805   156.391     0.200
    11.271   163.223     0.200
    11.364   164.848     0.200
    11.365   164.668     0.200
    11.384   163.809     0.200
    11.544   167.172     0.200
    11.597   166.539     0.200
    11.988   173.066     0.200
    12.038   173.914     0.200
    12.042   173.328     0.200
    12.070   174.043     0.200
    12.184   175.098     0.200
    12.491   180.125     0.200
    12.544   177.375     0.200
    12.544   179.023     0.200
    12.593   180.590     0.200
    12.631   181.996     0.200
    12.635   182.625     0.200
    12.682   182.758     0.200
    12.751   183.676     0.200
    12.884   185.285     0.200
    12.934   185.133     0.200
    13.193   184.574     0.200
    13.266   189.879     0.200
    13.274   189.812     0.200
    13.302   190.043     0.200
    13.348   190.387     0.200
    13.399   189.242     0.200
    13.439   191.605     0.200
    13.454   192.520     0.200
    13.615   195.543     0.200
    13.845   196.473     0.200
    13.845   197.672     0.200
    13.905   197.398     0.200
    13.949   197.969     0.200
    14.155   202.102     0.200
    14.182   198.504     0.200
    14.238   203.000     0.200
    14.491   205.340     0.200
    14.516   205.719     0.200
    14.564   206.684     0.200
    14.586   207.113     0.200
    14.672   207.109     0.200
    14.962   207.805     0.200
    15.174   214.547     0.200
    15.192   213.914     0.200
    15.202   214.406     0.200
    15.220   214.496     0.200
    15.291   215.914     0.200
    15.292   214.629     0.200
    15.366   216.059     0.200
    15.691   218.512     0.200
    16.111   225.574     0.200
    16.344   228.582     0.200
    16.624   231.395     0.200
    16.741   232.992     0.200
    16.877   233.273     0.200
    17.106   237.344     0.200
    17.624   242.883     0.200
    18.139   248.672     0.200
    18.281   252.309     0.200
    18.287   252.672     0.200
    18.343   252.949     0.200
    18.432   254.648     0.200
    18.447   254.551     0.200
    18.483   254.758     0.200
    18.480   255.836     0.200
    18.502   255.398     0.200
    18.650   256.473     0.200
    18.667   257.930     0.200
    18.882   261.824     0.200
    18.910   259.074     0.200
    18.960   259.766     0.200
    18.965   259.770     0.200
    19.021   260.102     0.200
    19.039   263.422     0.200
    19.054   261.199     0.200
    19.076   263.547     0.200
    19.076   261.484     0.200
    19.080   260.797     0.200
    19.151   263.453     0.200
    19.151   264.844     0.200
    19.169   264.625     0.200
    19.294   264.898     0.200
    19.319   266.059     0.200
    19.397   266.352     0.200
    19.473   268.434     0.200
    19.475   269.070     0.200
    19.490   268.348     0.200
    19.493   265.848     0.200
    19.596   267.273     0.200
    19.654   268.324     0.200
    19.711   271.316     0.200
    19.821   273.234     0.200
    19.825   269.375     0.200
    19.825   272.523     0.200
    19.845   272.285     0.200
    20.047   275.457     0.200
    20.067   272.172     0.200
    20.097   273.223     0.200
    20.169   273.125     0.200
    20.226   274.223     0.200
    20.273   274.988     0.200
    20.302   277.074     0.200
    20.383   277.223     0.200
    20.416   277.832     0.200
    20.465   278.367     0.200
    20.450   277.668     0.200
    20.674   279.324     0.200
    20.731   280.973     0.200
    20.730   280.762     0.200
    20.956   284.668     0.200
     0.249     8.078     0.200
     0.934    16.789     0.200
     1.941    29.957     0.200
     1.941    31.117     0.200
     2.225    35.137     0.200
     2.780    42.227     0.200
     2.778    42.547     0.200
     2.869    42.836     0.200
     3.573    52.656     0.200
    10.594   153.023     0.200
    10.765   156.387     0.200
    10.877   157.559     0.200
    10.915   157.543     0.200
    11.006   159.340     0.200
    11.111   160.121     0.200
    11.382   163.344     0.200
    11.507   166.074     0.200
    11.572   166.945     0.200
    11.585   167.375     0.200
    11.702   168.945     0.200
    11.847   170.234     0.200
    11.947   171.418     0.200
    12.109   174.246     0.200
    12.109   175.285     0.200
    12.157   175.016     0.200
    12.270   176.730     0.200
    12.308   176.113     0.200
    12.305   176.953     0.200
    12.340   177.270     0.200
    12.344   177.219     0.200
    12.691   181.742     0.200
    12.751   183.316     0.200
    12.806   183.641     0.200
    12.882   184.449     0.200
    12.956   185.191     0.200
    12.962   185.516     0.200
    12.983   186.621     0.200
    13.016   185.941     0.200
    13.191   187.355     0.200
    13.254   185.887     0.200
    13.445   192.262     0.200
    13.447   191.531     0.200
    13.518   192.867     0.200
    13.547   193.180     0.200
    13.598   193.664     0.200
    13.614   192.961     0.200
    13.644   194.480     0.200
    13.903   197.805     0.200
    14.141   200.879     0.200
    14.245   201.227     0.200
    14.394   204.223     0.200
    14.528   206.164     0.200
    14.773   209.273     0.200
    15.905   222.184     0.200
    15.979   220.598     0.200
    15.967   223.371     0.200
    15.985   223.594     0.200
    15.998   223.156     0.200
    16.304   226.828     0.200
    16.352   227.848     0.200
    16.359   228.020     0.200
    18.062   249.477     0.200
    18.082   248.832     0.200
    18.249   252.371     0.200
    18.386   253.449     0.200
    18.471   253.359     0.200
    18.551   254.328     0.200
    18.570   254.848     0.200
    18.580   254.828     0.200
    18.600   254.781     0.200
    18.612   254.746     0.200
    18.693   256.129     0.200
    18.768   256.730     0.200
    19.025   259.516     0.200
    19.030   259.531     0.200
    19.089   260.715     0.200
    19.091   260.766     0.200
    19.106   262.656     0.200
    19.120   261.688     0.200
    19.173   261.488     0.200
    19.308   262.469     0.200
    19.401   263.957     0.200
    19.472   265.473     0.200
    19.569   265.828     0.200
    19.699   267.227     0.200
    19.720   267.566     0.200
    19.742   267.680     0.200
    19.784   267.824     0.200
     1.441    23.953     0.200
     1.515    25.461     0.200
     1.573    28.219     0.200
     2.488    39.055     0.200
     2.252    38.750     0.200
     2.445    38.906     0.200
     2.433    41.555     0.200
     3.080    49.961     0.200
     3.359    52.930     0.200
     4.186    64.969     0.200
     4.854    72.516     0.200
    10.972   159.523     0.200
    11.261   163.375     0.200
    11.366   165.875     0.200
    11.391   166.414     0.200
    11.513   168.555     0.200
    11.516   168.039     0.200
    12.012   175.484     0.200
    12.043   175.562     0.200
    12.065   176.133     0.200
    12.064   175.844     0.200
    12.136   176.742     0.200
    12.309   176.891     0.200
    12.257   178.086     0.200
    12.337   178.867     0.200
    12.560   182.375     0.200
    12.611   183.234     0.200
    12.628   182.992     0.200
    12.699   183.836     0.200
    12.699   183.156     0.200
    12.758   184.719     0.200
    12.755   185.305     0.200
    12.777   185.672     0.200
    12.826   185.859     0.200
    13.085   188.430     0.200
    13.251   191.461     0.200
    13.281   191.914     0.200
    13.401   192.703     0.200
    13.397   192.750     0.200
    13.397   192.602     0.200
    13.411   192.492     0.200
    13.543   194.758     0.200
    13.587   194.336     0.200
    13.779   197.883     0.200
    13.880   199.320     0.200
    13.913   200.789     0.200
    14.020   201.195     0.200
    14.017   200.797     0.200
    14.029   201.039     0.200
    14.113   202.734     0.200
    14.096   201.328     0.200
    14.182   203.562     0.200
    14.171   203.164     0.200
    14.476   207.383     0.200
    14.504   207.633     0.200
    14.521   206.641     0.200
    14.556   208.273     0.200
    14.575   209.109     0.200
    14.577   208.781     0.200
    14.596   208.828     0.200
    14.639   209.750     0.200
    14.706   210.047     0.200
    14.774   211.289     0.200
    14.744   209.781     0.200
    14.735   210.727     0.200
    14.813   211.102     0.200
    14.813   210.555     0.200
    15.082   214.820     0.200
    15.195   214.844     0.200
    15.189   215.469     0.200
    15.191   216.359     0.200
    15.210   215.109     0.200
    15.259   216.180     0.200
    15.263   216.211     0.200
    15.336   217.695     0.200
    15.382   218.039     0.200
    15.446   218.438     0.200
    15.412   217.133     0.200
    15.539   220.734     0.200
    15.508   218.641     0.200
    15.580   219.812     0.200
    15.792   221.562     0.200
    15.777   221.492     0.200
    15.790   221.297     0.200
    15.852   224.055     0.200
    15.884   225.023     0.200
    15.811   221.602     0.200
    15.836   223.078     0.200
    15.861   223.453     0.200
    15.861   222.391     0.200
    15.895   225.156     0.200
    15.870   222.969     0.200
    15.978   226.523     0.200
    16.029   226.109     0.200
    16.072   227.000     0.200
    16.240   229.773     0.200
    16.194   227.891     0.200
    16.371   230.711     0.200
    16.420   231.523     0.200
    16.462   232.820     0.200
    16.437   231.773     0.200
    16.460   231.469     0.200
    16.541   234.211     0.200
    16.537   234.078     0.200
    16.608   234.828     0.200
    16.729   235.633     0.200
    16.726   233.875     0.200
    16.808   236.117     0.200
    16.906   238.422     0.200
    16.953   238.203     0.200
    16.995   239.047     0.200
    17.046   239.664     0.200
    17.129   240.289     0.200
    17.162   241.281     0.200
    17.157   241.094     0.200
    17.243   241.703     0.200
    17.291   242.133     0.200
    17.277   242.117     0.200
    17.581   246.188     0.200
    17.648   247.133     0.200
    17.700   245.883     0.200
    17.737   248.141     0.200
    17.790   248.555     0.200
    17.803   248.758     0.200
    17.869   248.539     0.200
    18.388   256.516     0.200
    18.360   256.422     0.200
    18.593   259.016     0.200
    18.786   260.273     0.200
    18.830   261.508     0.200
    18.788   261.930     0.200
    18.923   262.828     0.200
    18.958   263.461     0.200
    18.958   263.359     0.200
    19.140   265.055     0.200
    19.223   265.680     0.200
    19.311   267.375     0.200
    19.694   271.094     0.200
    19.694   271.289     0.200
    19.739   271.109     0.200
    19.718   271.344     0.200
    19.760   272.070     0.200
    20.176   275.734     0.200
     0.286     8.823     0.200
     1.161    19.193     0.200
     1.192    20.594     0.200
     1.387    22.323     0.200
     1.714    27.283     0.200
     2.139    34.203     0.200
     2.985    45.143     0.200
     2.979    45.283     0.200
     3.008    46.994     0.200
     7.904   114.358     0.200
     8.212   121.643     0.200
     9.528   139.285     0.200
     9.657   141.070     0.200
     9.816   142.852     0.200
    10.244   147.790     0.200
    10.441   151.760     0.200
    10.534   152.308     0.200
    10.670   153.890     0.200
    10.842   156.301     0.200
    10.903   155.715     0.200
    11.193   161.740     0.200
    11.201   161.621     0.200
    11.460   165.067     0.200
    11.572   166.549     0.200
    11.703   169.349     0.200
    11.754   168.716     0.200
    11.807   169.920     0.200
    11.858   169.603     0.200
    11.940   171.456     0.200
    12.030   172.497     0.200
    12.190   174.180     0.200
    12.223   175.948     0.200
    12.313   175.525     0.200
    12.324   175.276     0.200
    12.391   177.528     0.200
    12.391   176.903     0.200
    12.435   178.245     0.200
    12.449   179.538     0.200
    12.617   180.026     0.200
    12.776   182.776     0.200
    12.823   183.001     0.200
    13.072   187.650     0.200
    13.078   187.904     0.200
    13.109   186.848     0.200
    13.256   185.333     0.200
    13.277   190.018     0.200
    13.394   189.479     0.200
    13.411   190.415     0.200
    13.411   189.464     0.200
    13.550   194.036     0.200
    13.603   191.534     0.200
    13.785   194.808     0.200
    14.081   195.663     0.200
    14.500   202.693     0.200
    14.705   205.994     0.200
    15.321   214.543     0.200
    15.513   215.423     0.200
    15.503   215.083     0.200
    16.032   222.214     0.200
    16.719   229.883     0.200
    16.759   231.543     0.200
    16.841   232.829     0.200
    17.420   238.103     0.200
    17.545   241.230     0.200
    17.574   241.161     0.200
    17.621   241.890     0.200
    17.750   243.070     0.200
    17.959   247.025     0.200
    18.191   249.932     0.200
    18.271   250.650     0.200
    18.577   256.170     0.200
    18.577   255.593     0.200
    18.599   254.032     0.200
    18.674   254.828     0.200
    18.711   256.755     0.200
    18.715   256.761     0.200
    18.721   255.208     0.200
    19.065   258.843     0.200
    19.159   261.946     0.200
    19.343   263.452     0.200
    19.343   262.683     0.200
    19.365   264.993     0.200
    19.397   264.678     0.200
    19.409   263.274     0.200
    19.559   266.322     0.200
    19.800   268.034     0.200
    19.820   268.006     0.200
    19.870   271.099     0.200
    20.180   273.341     0.200
    20.789   279.489     0.200
     0.964    16.266     0.200
     1.090    18.676     0.200
     1.664    27.736     0.200
     1.777    29.236     0.200
     1.681    28.916     0.200
     1.885    31.025     0.200
     2.341    36.217     0.200
     2.609    40.326     0.200
     2.596    42.025     0.200
     2.688    41.506     0.200
     2.821    43.426     0.200
     3.142    49.217     0.200
     3.150    48.887     0.200
     3.589    55.695     0.200
     4.720    70.256     0.200
     7.203   105.176     0.200
    11.028   157.705     0.200
     0.786    14.675     0.200
     1.145    19.215     0.200
     1.765    28.024     0.200
     1.869    29.935     0.200
     1.995    32.375     0.200
     2.056    32.415     0.200
     2.068    32.415     0.200
     2.459    41.784     0.200
     2.438    38.955     0.200
     2.486    38.654     0.200
     2.575    41.015     0.200
     2.693    42.645     0.200
     2.721    42.694     0.200
     3.038    47.005     0.200
     3.095    46.715     0.200
     3.077    47.135     0.200
     3.137    47.784     0.200
     3.265    52.944     0.200
     3.309    52.694     0.200
     3.470    53.274     0.200
     3.534    55.265     0.200
     3.637    54.645     0.200
     3.673    55.165     0.200
     3.754    56.185     0.200
     4.599    66.185     0.200
     7.019   102.209     0.200
     9.110   133.734     0.200
    11.363   161.739     0.200
    11.364   164.284     0.200
    12.610   182.515     0.200
    13.229   185.975     0.200
    16.821   232.495     0.200
    17.302   238.840     0.200
     0.779    18.072     0.200
     0.794    18.372     0.200
     0.995    20.452     0.200
     1.759    29.402     0.200
     1.759    28.532     0.200
     1.961    31.932     0.200
     2.044    33.152     0.200
     2.337    36.492     0.200
     2.564    40.082     0.200
     3.193    48.742     0.200
     3.320    50.572     0.200
     3.584    55.082     0.200
     3.791    56.492     0.200
     4.396    65.853     0.200
     6.722    96.402     0.200
     7.900   113.891     0.200
     8.307   121.522     0.200
     9.858   139.594     0.200
    10.333   148.342     0.200
    10.332   146.385     0.200
    10.652   151.052     0.200
    11.804   166.549     0.200
    11.804   166.182     0.200
    12.857   181.076     0.200
    12.857   181.232     0.200
    13.873   191.962     0.200
    13.912   193.382     0.200
    14.181   198.052     0.200
    14.761   203.742     0.200
    15.148   208.120     0.200
    15.636   214.985     0.200
    15.945   216.912     0.200
    16.001   219.340     0.200
    16.131   220.218     0.200
    16.131   221.022     0.200
    16.231   220.954     0.200
    16.256   221.170     0.200
    16.295   221.651     0.200
    16.310   223.199     0.200
    16.353   222.922     0.200
    16.612   226.746     0.200
    16.866   229.558     0.200
    16.939   230.202     0.200
    16.948   230.696     0.200
    16.948   229.702     0.200
    16.990   231.042     0.200
    17.019   231.211     0.200
    17.153   232.954     0.200
    17.217   233.591     0.200
    17.280   234.351     0.200
    17.425   236.967     0.200
    17.492   237.318     0.200
    17.979   245.512     0.200
    18.119   244.754     0.200
    18.149   246.712     0.200
    18.453   248.282     0.200
    18.603   250.437     0.200
    18.617   253.135     0.200
    18.836   252.723     0.200
    18.807   253.933     0.200
    18.807   253.812     0.200
    18.834   254.131     0.200
    18.834   253.362     0.200
    18.912   253.604     0.200
    19.007   256.396     0.200
    19.007   256.542     0.200
    19.051   255.357     0.200
    19.201   260.004     0.200
    19.452   262.390     0.200
    19.549   261.633     0.200
     0.943    17.375     0.200
     1.109    20.066     0.200
     1.691    29.094     0.200
     1.907    31.336     0.200
     2.361    37.344     0.200
     2.709    42.637     0.200
     2.800    42.887     0.200
     4.424    66.863     0.200
     7.225   105.992     0.200
    11.023   157.773     0.200
    11.022   158.730     0.200
    12.319   174.445     0.200
    12.319   172.977     0.200
    13.592   193.590     0.200
    13.592   192.426     0.200
    14.306   198.734     0.200
    14.306   197.504     0.200
    14.426   202.996     0.200
    14.444   203.320     0.200
    15.073   209.184     0.200
    15.583   217.203     0.200
    15.583   216.555     0.200
    15.861   221.055     0.200
    16.214   225.016     0.200
    16.501   228.297     0.200
    16.501   227.754     0.200
    16.652   229.664     0.200
    16.900   230.734     0.200
    17.243   234.078     0.200
    17.947   245.461     0.200
    17.958   248.203     0.200
    17.965   247.656     0.200
    18.828   255.984     0.200
    18.827   258.605     0.200
    18.898   259.367     0.200
    19.071   258.305     0.200
    19.542   264.566     0.200
    19.542   264.734     0.200
    19.571   265.078     0.200
    19.571   264.945     0.200
    19.740   266.598     0.200
    19.740   267.113     0.200
    19.774   268.344     0.200
    19.777   268.055     0.200
    19.777   268.574     0.200
    19.805   268.105     0.200
    20.050   271.094     0.200
    20.221   273.059     0.200
    20.612   276.578     0.200
    20.770   278.395     0.200
     1.574    24.396     0.200
     2.333    36.597     0.200
     2.587    43.057     0.200
     3.203    50.097     0.200
     3.746    59.276     0.200
     4.329    66.026     0.200
     7.444   109.677     0.200
     8.264   121.966     0.200
     8.535   126.396     0.200
     8.531   124.766     0.200
    10.732   155.336     0.200
    10.732   155.335     0.200
    10.732   155.616     0.200
    13.176   189.083     0.200
    13.176   189.256     0.200
    13.165   188.496     0.200
    13.602   192.677     0.200
    13.726   196.396     0.200
    14.395   206.099     0.200
    15.376   217.390     0.200
    15.376   218.887     0.200
    15.668   220.116     0.200
    15.751   222.006     0.200
    15.849   226.158     0.200
    15.910   224.687     0.200
    15.900   225.728     0.200
    16.078   225.956     0.200
    16.365   230.495     0.200
    16.365   230.736     0.200
    16.509   232.521     0.200
    16.509   233.410     0.200
    16.509   232.887     0.200
    16.569   233.622     0.200
    17.238   241.546     0.200
    18.045   248.578     0.200
    18.064   249.166     0.200
    18.211   253.131     0.200
    18.202   250.618     0.200
    18.525   256.886     0.200
    18.834   260.425     0.200
    18.841   260.726     0.200
    19.323   267.827     0.200
    19.851   271.786     0.200
    20.181   275.757     0.200
    20.275   277.677     0.200
    20.377   280.046     0.200
    20.407   279.196     0.200
    20.674   281.937     0.200
    20.730   283.136     0.200
     1.531    27.781     0.200
     1.465    25.344     0.200
     2.234    38.758     0.200
     2.454    40.578     0.200
     2.455    38.570     0.200
     2.733    43.273     0.200
     3.052    50.148     0.200
     3.263    52.242     0.200
     3.298    53.750     0.200
     3.500    56.758     0.200
     3.500    56.430     0.200
     3.739    59.164     0.200
     3.758    60.578     0.200
     4.180    65.000     0.200
     4.674    72.398     0.200
     4.880    73.867     0.200
     4.880    73.992     0.200
     5.987    91.109     0.200
     6.369    94.680     0.200
     6.915   102.891     0.200
     7.505   111.891     0.200
     7.630   113.211     0.200
     7.657   113.172     0.200
     7.659   112.617     0.200
     7.728   114.102     0.200
     7.693   113.617     0.200
     7.697   112.359     0.200
     9.167   135.469     0.200
     9.167   135.570     0.200
     9.131   134.602     0.200
    10.695   156.461     0.200
    11.221   163.133     0.200
    11.220   163.234     0.200
    12.330   176.539     0.200
    12.583   181.633     0.200
    12.663   182.883     0.200
    12.663   183.211     0.200
    12.753   180.734     0.200
    13.135   187.102     0.200
    13.465   191.414     0.200
    13.541   193.609     0.200
    13.738   197.492     0.200
    13.738   195.094     0.200
    13.873   199.102     0.200
    14.010   201.109     0.200
    14.002   196.461     0.200
    14.117   202.102     0.200
    14.147   202.141     0.200
    14.435   205.953     0.200
    14.702   208.680     0.200
    14.777   210.109     0.200
    14.777   208.211     0.200
    15.262   214.555     0.200
    15.400   216.742     0.200
    15.532   218.375     0.200
    15.633   219.383     0.200
    15.560   221.508     0.200
    15.777   221.117     0.200
    15.822   223.445     0.200
    15.822   221.805     0.200
    15.878   222.180     0.200
    15.967   223.484     0.200
    16.066   224.867     0.200
    16.171   225.656     0.200
    16.180   226.125     0.200
    16.348   228.156     0.200
    16.421   230.141     0.200
    16.434   229.906     0.200
    16.499   230.914     0.200
    16.560   230.992     0.200
    16.553   231.609     0.200
    16.663   232.484     0.200
    16.748   233.719     0.200
    16.762   233.859     0.200
    16.770   234.656     0.200
    16.770   233.250     0.200
    16.978   235.281     0.200
    16.993   236.945     0.200
    16.993   236.719     0.200
    17.005   236.914     0.200
    17.043   236.977     0.200
    17.051   237.203     0.200
    17.192   238.773     0.200
    17.291   240.516     0.200
    17.362   241.180     0.200
    17.471   242.289     0.200
    17.600   244.688     0.200
    17.631   244.453     0.200
    17.653   245.133     0.200
    17.755   245.930     0.200
    17.852   247.562     0.200
    17.872   246.961     0.200
    17.981   248.781     0.200
    17.981   248.305     0.200
    17.999   249.164     0.200
    18.017   248.414     0.200
    18.052   249.633     0.200
    18.056   249.664     0.200
    18.150   250.984     0.200
    18.199   251.555     0.200
    18.186   251.734     0.200
    18.239   251.820     0.200
    18.384   257.602     0.200
    18.396   257.070     0.200
    18.422   257.953     0.200
    18.431   258.250     0.200
    18.432   258.250     0.200
    18.466   258.648     0.200
    18.488   258.953     0.200
    18.493   259.711     0.200
    18.642   256.883     0.200
    18.612   260.594     0.200
    18.629   260.820     0.200
    18.646   260.352     0.200
    18.746   260.500     0.200
    18.669   260.773     0.200
    18.745   261.281     0.200
    18.672   261.117     0.200
    18.830   259.305     0.200
    18.708   260.781     0.200
    18.790   261.305     0.200
    18.847   259.516     0.200
    18.881   260.094     0.200
    18.916   262.961     0.200
    18.916   262.781     0.200
    18.832   263.062     0.200
    18.841   263.062     0.200
    18.879   263.062     0.200
    19.029   262.992     0.200
    19.029   262.641     0.200
    19.010   263.453     0.200
    19.069   262.141     0.200
    19.091   264.055     0.200
    19.101   264.945     0.200
    19.160   263.016     0.200
    19.053   264.930     0.200
    19.145   264.914     0.200
    19.109   265.305     0.200
    19.303   264.461     0.200
    19.185   268.109     0.200
    19.190   265.992     0.200
    19.381   267.875     0.200
    19.476   266.562     0.200
    19.494   269.148     0.200
    19.494   268.062     0.200
    19.577   267.648     0.200
    19.594   267.844     0.200
    19.615   270.477     0.200
    19.561   269.820     0.200
    19.676   270.578     0.200
    19.676   269.984     0.200
    19.652   269.781     0.200
    19.654   270.984     0.200
    19.654   269.930     0.200
    19.720   270.672     0.200
    19.720   269.805     0.200
    19.603   273.789     0.200
    19.699   271.383     0.200
    19.887   273.227     0.200
    19.921   274.531     0.200
    20.061   275.078     0.200
    20.059   275.055     0.200
    20.101   276.305     0.200
    20.136   275.930     0.200
    20.133   275.961     0.200
    20.228   277.250     0.200
    20.291   278.219     0.200
    20.395   278.914     0.200
    20.427   279.312     0.200
    20.515   279.859     0.200
    20.642   280.688     0.200
    20.635   281.102     0.200
    20.627   281.234     0.200
    20.778   282.555     0.200
    20.765   282.602     0.200
    20.784   282.984     0.200
    20.779   282.688     0.200
    20.788   283.070     0.200
    20.787   282.930     0.200
    20.898   283.969     0.200
    20.932   284.070     0.200
    20.977   285.609     0.200
    21.052   284.883     0.200
    21.040   284.961     0.200
    21.053   286.117     0.200
     1.819    29.029     0.200
     2.123    33.180     0.200
     2.566    42.639     0.200
     2.566    42.770     0.200
     3.054    47.529     0.200
     3.391    52.898     0.200
     3.767    59.529     0.200
     4.268    68.770     0.200
     4.268    68.520     0.200
     4.510    69.949     0.200
     4.701    71.709     0.200
     4.817    71.809     0.200
     5.523    81.680     0.200
     6.629    98.988     0.200
     7.562   112.229     0.200
     7.901   119.039     0.200
     8.363   122.379     0.200
     8.515   125.430     0.200
     8.778   130.158     0.200
    10.654   154.398     0.200
    10.654   155.676     0.200
    10.951   159.129     0.200
    10.951   159.127     0.200
    10.951   160.090     0.200
    11.101   161.998     0.200
    12.566   183.568     0.200
    12.566   182.561     0.200
    12.979   186.010     0.200
    13.409   192.779     0.200
    13.409   193.498     0.200
    13.642   197.859     0.200
    13.827   199.590     0.200
    13.979   200.939     0.200
    14.674   209.730     0.200
    15.364   217.969     0.200
    16.569   232.998     0.200
    16.745   235.068     0.200
    16.844   235.930     0.200
    16.844   235.828     0.200
    16.884   236.139     0.200
    16.884   235.904     0.200
    17.111   238.910     0.200
    17.435   242.895     0.200
    17.474   242.373     0.200
    17.720   246.139     0.200
    17.720   245.779     0.200
    17.759   247.109     0.200
    17.881   247.797     0.200
    17.923   248.783     0.200
    17.925   248.479     0.200
    18.008   249.049     0.200
    18.008   248.670     0.200
    18.117   250.434     0.200
    18.180   250.789     0.200
    18.210   251.938     0.200
    18.422   255.818     0.200
    18.465   256.908     0.200
    18.495   257.326     0.200
    18.523   257.439     0.200
    18.538   258.326     0.200
    18.604   258.893     0.200
    18.749   261.180     0.200
    18.749   260.883     0.200
    18.850   261.062     0.200
    18.924   262.557     0.200
    18.924   263.158     0.200
    19.053   263.879     0.200
    19.089   264.260     0.200
    19.097   264.760     0.200
    19.100   264.959     0.200
    19.100   264.498     0.200
    19.155   264.938     0.200
    19.300   265.398     0.200
    19.415   266.709     0.200
    19.497   269.213     0.200
    19.551   268.939     0.200
    19.582   271.549     0.200
    19.606   269.730     0.200
    19.602   269.510     0.200
    19.977   274.027     0.200
    20.228   276.789     0.200
    20.258   277.557     0.200
    20.316   277.309     0.200
    20.440   279.398     0.200
    20.426   278.498     0.200
    20.463   278.568     0.200
    20.474   279.439     0.200
    20.528   280.350     0.200
    20.586   280.930     0.200
    20.586   280.527     0.200
    20.618   281.281     0.200
    20.603   280.559     0.200
    20.792   282.170     0.200
    20.801   282.488     0.200
    20.890   283.258     0.200
    20.928   285.010     0.200
     0.679    13.336     0.200
     1.360    22.586     0.200
     1.493    25.086     0.200
     1.831    30.953     0.200
     1.831    31.195     0.200
     2.179    34.914     0.200
     2.530    38.664     0.200
     2.623    40.320     0.200
     2.907    46.430     0.200
     2.978    46.281     0.200
     3.095    46.523     0.200
     3.191    48.391     0.200
     3.961    59.898     0.200
     4.360    65.219     0.200
     6.032    87.141     0.200
     7.119   103.562     0.200
     7.501   109.234     0.200
     8.529   126.562     0.200
    10.938   157.594     0.200
    10.938   157.586     0.200
    10.938   157.594     0.200
    12.312   174.070     0.200
    13.778   196.094     0.200
    14.261   202.883     0.200
    14.331   203.664     0.200
    15.140   212.922     0.200
    15.519   217.305     0.200
    15.687   218.031     0.200
    16.098   223.070     0.200
    16.184   226.109     0.200
    16.453   229.344     0.200
    16.644   230.094     0.200
    17.387   239.742     0.200
    18.263   250.945     0.200
    18.631   256.539     0.200
    18.746   257.492     0.200
    19.414   265.039     0.200
    19.634   266.492     0.200
    20.427   275.562     0.200
     0.599    10.508     0.200
     1.917    31.836     0.200
     2.394    37.453     0.200
     2.502    36.688     0.200
     2.537    39.539     0.200
     2.738    42.953     0.200
     2.738    44.188     0.200
     3.247    51.047     0.200
     3.379    50.805     0.200
     3.773    54.742     0.200
     4.112    60.945     0.200
     4.171    62.367     0.200
     4.176    64.445     0.200
     4.186    64.945     0.200
     4.355    65.672     0.200
     4.355    66.047     0.200
     4.475    68.242     0.200
     4.526    68.578     0.200
     4.583    68.688     0.200
     4.631    70.227     0.200
     4.633    70.266     0.200
     4.719    74.148     0.200
     4.869    73.398     0.200
     4.983    75.336     0.200
     5.013    75.344     0.200
     5.165    74.242     0.200
     5.443    82.445     0.200
     6.200    91.016     0.200
     6.982   102.812     0.200
     7.158   103.555     0.200
     7.158   103.883     0.200
     7.519   109.375     0.200
     8.123   117.742     0.200
     8.123   117.914     0.200
     8.481   124.398     0.200
     8.707   126.703     0.200
     8.707   123.742     0.200
     9.013   128.719     0.200
    10.545   151.625     0.200
    10.545   152.172     0.200
    10.714   154.297     0.200
    10.714   154.195     0.200
    11.450   163.672     0.200
    11.610   165.273     0.200
    12.422   178.555     0.200
    13.138   188.117     0.200
    13.138   187.023     0.200
    13.340   187.148     0.200
    13.435   190.758     0.200
    13.435   190.523     0.200
    13.494   189.719     0.200
    13.576   194.289     0.200
    13.633   190.758     0.200
    13.646   193.562     0.200
    14.334   203.758     0.200
    14.397   204.305     0.200
    14.504   204.875     0.200
    14.504   204.531     0.200
    14.567   203.805     0.200
    14.567   205.344     0.200
    14.827   205.852     0.200
    15.366   215.664     0.200
    15.366   215.188     0.200
    15.551   216.594     0.200
    15.864   220.266     0.200
    16.028   222.906     0.200
    16.364   227.828     0.200
    16.364   227.977     0.200
    16.730   231.945     0.200
    17.681   243.094     0.200
    17.711   243.023     0.200
    17.875   245.656     0.200
    18.158   248.328     0.200
    18.234   252.930     0.200
    18.484   255.664     0.200
    18.501   254.820     0.200
    18.543   256.203     0.200
    18.698   257.344     0.200
    18.722   258.812     0.200
    18.725   258.773     0.200
    18.725   258.898     0.200
    18.725   258.367     0.200
    18.739   257.727     0.200
    18.784   259.422     0.200
    19.002   260.445     0.200
    19.118   262.711     0.200
    19.153   262.445     0.200
    19.153   262.312     0.200
    19.220   263.227     0.200
    19.240   264.008     0.200
    19.266   264.195     0.200
    19.274   264.242     0.200
    19.459   266.328     0.200
    19.469   267.297     0.200
    19.608   267.859     0.200
    19.675   268.586     0.200
    19.825   268.781     0.200
    19.850   270.383     0.200
    19.894   270.938     0.200
    19.913   270.562     0.200
    19.918   270.375     0.200
    19.958   270.914     0.200
    19.981   272.086     0.200
    19.978   271.172     0.200
    19.983   271.078     0.200
    20.061   273.133     0.200
    20.094   272.352     0.200
    20.092   273.148     0.200
    20.092   273.344     0.200
    20.099   272.883     0.200
    20.123   273.297     0.200
    20.126   272.602     0.200
    20.128   272.633     0.200
    20.133   272.945     0.200
    20.148   272.625     0.200
    20.160   273.227     0.200
    20.187   273.266     0.200
    20.196   274.039     0.200
    20.217   273.617     0.200
    20.217   275.008     0.200
    20.222   274.023     0.200
    20.226   273.852     0.200
    20.228   273.594     0.200
    20.238   275.211     0.200
    20.240   274.828     0.200
    20.303   274.562     0.200
    20.371   275.258     0.200
    20.402   275.625     0.200
    20.436   276.773     0.200
    20.436   276.039     0.200
    20.514   277.367     0.200
    20.556   277.711     0.200
    20.591   277.992     0.200
    20.705   279.938     0.200
    20.721   280.047     0.200
    20.803   280.805     0.200
    20.816   280.789     0.200
     1.358    22.736     0.200
     1.404    25.035     0.200
     1.502    25.945     0.200
     1.759    29.695     0.200
     2.138    35.006     0.200
     2.615    40.336     0.200
     2.872    45.525     0.200
     2.934    46.756     0.200
     3.367    52.715     0.200
     3.930    60.506     0.200
     4.726    70.256     0.200
     7.466   109.385     0.200
     0.794    14.641     0.200
     1.154    18.691     0.200
     1.737    29.851     0.200
     2.059    32.841     0.200
     2.061    32.831     0.200
     2.419    39.401     0.200
     2.548    41.421     0.200
     2.802    45.431     0.200
     3.044    48.571     0.200
     3.410    54.081     0.200
     3.456    54.361     0.200
     3.500    55.781     0.200
     3.728    57.311     0.200
     4.190    63.321     0.200
     4.712    71.931     0.200
     5.684    84.591     0.200
     6.219    92.231     0.200
     7.004   102.896     0.200
     7.004   102.771     0.200
     8.349   120.411     0.200
     8.354   121.072     0.200
     8.382   122.302     0.200
     8.384   121.281     0.200
     8.417   121.880     0.200
     8.421   121.521     0.200
     9.096   133.821     0.200
     9.418   137.881     0.200
     9.701   139.960     0.200
     9.701   139.251     0.200
     9.739   140.791     0.200
     9.739   140.681     0.200
     9.990   144.811     0.200
     9.990   144.401     0.200
    10.236   148.251     0.200
    10.451   148.141     0.200
    10.537   152.641     0.200
    10.537   152.536     0.200
    11.318   163.521     0.200
    11.318   163.521     0.200
    11.319   162.701     0.200
    11.319   164.051     0.200
    11.615   165.666     0.200
    12.063   170.301     0.200
    12.063   167.631     0.200
    12.560   179.691     0.200
    12.560   179.537     0.200
    13.097   186.581     0.200
    13.177   186.271     0.200
    13.297   185.701     0.200
    13.341   189.301     0.200
    13.341   189.148     0.200
    13.565   193.901     0.200
    13.900   198.051     0.200
    13.900   197.929     0.200
    14.231   203.291     0.200
    14.518   204.351     0.200
    14.689   207.291     0.200
    14.689   206.762     0.200
    14.846   210.631     0.200
    14.846   210.271     0.200
    14.943   210.561     0.200
    15.243   213.051     0.200
    15.865   221.671     0.200
    15.898   223.291     0.200
    16.440   228.711     0.200
    16.773   233.211     0.200
    16.773   233.605     0.200
    16.892   233.901     0.200
    16.892   233.752     0.200
    17.319   238.871     0.200
    17.319   238.292     0.200
    17.557   241.991     0.200
    17.589   242.651     0.200
    17.589   242.540     0.200
    18.126   248.241     0.200
    18.126   247.809     0.200
    18.289   253.997     0.200
    18.334   252.741     0.200
    18.368   255.332     0.200
    18.783   259.550     0.200
    19.121   262.101     0.200
    19.161   263.620     0.200
    19.214   266.176     0.200
    19.226   264.602     0.200
    19.247   265.028     0.200
    19.406   265.786     0.200
    19.570   267.676     0.200
    19.581   268.380     0.200
    19.801   271.173     0.200
    19.841   270.051     0.200
    19.841   270.239     0.200
    19.887   270.441     0.200
    19.887   270.743     0.200
    19.911   271.261     0.200
    19.975   272.001     0.200
    20.013   272.842     0.200
    20.047   272.751     0.200
    20.047   272.573     0.200
    20.110   274.226     0.200
    20.110   273.837     0.200
    20.139   274.103     0.200
    20.286   277.401     0.200
    20.528   278.278     0.200
    20.554   278.986     0.200
    20.846   281.540     0.200
    20.859   281.561     0.200
    20.892   281.781     0.200
    20.929   282.351     0.200
     1.241    22.621     0.200
     1.963    30.980     0.200
     1.983    33.230     0.200
     4.572    69.512     0.200
     4.667    71.012     0.200
     6.783    99.934     0.200
     7.573   112.184     0.200
     8.214   119.363     0.200
     8.896   131.191     0.200
    10.950   158.082     0.200
    11.043   160.691     0.200
    11.042   160.297     0.200
    12.617   181.953     0.200
    12.824   181.691     0.200
    13.514   193.922     0.200
    13.514   193.074     0.200
    14.708   208.363     0.200
    14.708   207.855     0.200
    14.717   208.094     0.200
    14.762   210.637     0.200
    15.502   220.594     0.200
    15.502   220.219     0.200
    15.612   220.441     0.200
    15.672   221.914     0.200
    15.672   221.387     0.200
    15.798   222.070     0.200
    16.074   227.863     0.200
    16.645   233.324     0.200
    16.854   235.039     0.200
    16.854   235.730     0.200
    16.854   235.391     0.200
    16.939   236.191     0.200
    16.939   235.797     0.200
    17.628   245.664     0.200
    17.726   244.652     0.200
    17.828   249.641     0.200
     1.349    21.465     0.200
     2.543    40.477     0.200
     2.615    40.516     0.200
     3.511    54.484     0.200
     5.293    81.355     0.200
     7.297   107.957     0.200
     7.620   113.707     0.200
     8.491   123.336     0.200
    10.596   153.906     0.200
    10.752   154.895     0.200
    10.751   157.551     0.200
    11.551   163.375     0.200
    12.197   173.754     0.200
    12.494   179.867     0.200
    13.463   190.492     0.200
    13.594   192.406     0.200
    13.607   196.137     0.200
    13.633   195.086     0.200
    14.965   212.145     0.200
    16.039   225.766     0.200
    16.414   228.234     0.200
    16.650   233.344     0.200
    17.137   239.867     0.200
    17.272   240.594     0.200
    17.303   241.816     0.200
    18.445   257.000     0.200
    18.533   257.062     0.200
    18.670   258.445     0.200
    18.678   258.887     0.200
    18.678   259.832     0.200
    18.741   260.277     0.200
    18.776   258.594     0.200
    18.922   260.574     0.200
    19.010   263.086     0.200
    19.010   262.852     0.200
    19.068   263.352     0.200
    19.179   264.156     0.200
    19.179   263.988     0.200
    19.292   265.410     0.200
    19.566   269.871     0.200
    19.595   267.281     0.200
    19.800   271.996     0.200
    19.858   271.227     0.200
    19.856   272.578     0.200
    20.104   275.027     0.200
    20.175   275.887     0.200
    20.184   276.254     0.200
    20.545   279.844     0.200
    20.629   280.785     0.200
    20.694   281.305     0.200
    20.723   281.324     0.200
     0.125    14.055     0.200
     0.361    14.648     0.200
     1.114    22.125     0.200
     1.309    22.898     0.200
     2.314    37.992     0.200
     2.592    40.914     0.200
     2.723    42.711     0.200
     3.321    50.914     0.200
     3.536    52.898     0.200
     3.625    56.219     0.200
     3.764    58.016     0.200
     3.967    59.766     0.200
     4.092    61.891     0.200
     4.138    63.422     0.200
     4.322    65.094     0.200
     4.347    66.078     0.200
     4.454    67.023     0.200
     4.768    72.094     0.200
     7.768   112.617     0.200
     7.755   111.695     0.200
     8.644   123.664     0.200
     9.733   138.836     0.200
     9.733   138.422     0.200
     9.923   140.992     0.200
     9.923   141.094     0.200
     9.923   140.469     0.200
    11.396   160.352     0.200
    11.604   165.758     0.200
    11.604   164.312     0.200
    12.377   174.398     0.200
    12.377   174.125     0.200
    12.796   180.289     0.200
    12.987   184.711     0.200
    13.336   185.844     0.200
    13.755   190.922     0.200
    14.508   198.984     0.200
    15.911   218.492     0.200
    16.833   228.922     0.200
    17.471   239.711     0.200
    17.571   240.789     0.200
    18.205   247.883     0.200
    18.208   246.344     0.200
    18.275   248.688     0.200
    18.383   249.664     0.200
    18.520   252.148     0.200
    18.612   253.281     0.200
    18.881   254.211     0.200
    19.236   259.719     0.200
    19.256   258.719     0.200
    19.286   259.266     0.200
    19.251   258.445     0.200
    19.353   260.289     0.200
    19.358   259.969     0.200
    19.401   260.945     0.200
    19.401   260.992     0.200
    19.405   260.430     0.200
    19.422   261.031     0.200
    19.434   262.000     0.200
    19.462   262.023     0.200
    19.491   263.000     0.200
    19.499   261.844     0.200
    19.503   261.922     0.200
    19.577   263.273     0.200
    19.612   262.273     0.200
    19.648   262.984     0.200
    19.675   263.141     0.200
    19.676   263.320     0.200
    19.838   266.250     0.200
    20.033   267.391     0.200
    20.052   268.094     0.200
    20.195   269.070     0.200
     0.756    14.967     0.200
     1.997    31.508     0.200
     2.399    37.667     0.200
     2.931    47.698     0.200
     2.931    48.167     0.200
     3.336    51.097     0.200
     3.339    51.307     0.200
     3.533    55.948     0.200
     4.456    67.078     0.200
     4.620    68.707     0.200
     6.882    99.832     0.200
    11.231   162.344     0.200
    11.231   159.508     0.200
    11.231   159.768     0.200
    12.434   177.617     0.200
    13.825   194.417     0.200
    14.146   200.667     0.200
    14.566   204.638     0.200
    15.090   213.818     0.200
    16.665   232.917     0.200
    17.976   249.427     0.200
    19.718   270.888     0.200
     1.462    23.934     0.200
     1.720    29.191     0.200
     1.958    31.754     0.200
     1.985    32.613     0.200
     2.221    36.004     0.200
     2.630    41.324     0.200
     3.091    49.555     0.200
     3.267    49.562     0.200
     3.320    51.742     0.200
     3.320    52.184     0.200
     3.659    55.684     0.200
     3.659    56.395     0.200
     3.723    57.293     0.200
     3.851    60.703     0.200
     4.046    60.703     0.200
     4.766    71.031     0.200
     7.208   106.453     0.200
    11.362   164.934     0.200
    11.361   161.832     0.200
    11.361   164.523     0.200
    11.362   160.922     0.200
    19.879   271.543     0.200
     1.609    24.480     0.200
     1.989    33.309     0.200
     2.274    35.961     0.200
     2.877    42.590     0.200
     3.236    51.469     0.200
     3.415    51.750     0.200
     4.226    63.168     0.200
     4.312    65.129     0.200
     8.292   122.770     0.200
    10.860   158.531     0.200
    10.860   158.531     0.200
     1.230    22.861     0.200
     1.733    30.121     0.200
     1.979    32.921     0.200
     2.504    42.271     0.200
     2.504    39.831     0.200
     2.930    45.891     0.200
     3.181    51.531     0.200
     3.246    50.651     0.200
     3.735    58.601     0.200
     3.724    58.921     0.200
     3.771    60.311     0.200
     3.807    58.071     0.200
     3.799    62.781     0.200
     3.826    60.711     0.200
     4.182    61.701     0.200
     4.372    66.151     0.200
     4.565    68.571     0.200
     4.626    70.761     0.200
     4.625    72.281     0.200
     4.683    71.571     0.200
     4.682    70.941     0.200
     4.853    74.851     0.200
     5.767    86.921     0.200
     6.055    90.131     0.200
     6.233    93.731     0.200
     6.413    93.601     0.200
     6.795   101.761     0.200
     7.429   109.621     0.200
     7.571   109.021     0.200
     8.230   119.906     0.200
     8.230   119.541     0.200
     8.883   128.671     0.200
    10.561   150.751     0.200
    10.687   154.416     0.200
    10.966   160.671     0.200
    10.966   156.041     0.200
    11.033   157.411     0.200
    11.033   157.891     0.200
    11.032   160.336     0.200
    12.611   180.408     0.200
    12.734   181.621     0.200
    13.503   194.136     0.200
    13.503   191.231     0.200
    14.038   197.781     0.200
    14.098   199.731     0.200
    14.704   206.289     0.200
    14.704   208.051     0.200
    14.711   208.363     0.200
    14.711   207.291     0.200
    14.749   210.255     0.200
    14.749   208.511     0.200
    15.322   215.861     0.200
    15.487   218.521     0.200
    15.532   218.341     0.200
    15.610   218.433     0.200
    15.610   218.841     0.200
    15.663   220.198     0.200
    15.663   220.681     0.200
    16.005   224.441     0.200
    16.059   227.075     0.200
    16.059   225.921     0.200
    16.071   225.821     0.200
    16.062   227.303     0.200
    16.062   225.521     0.200
    16.485   229.931     0.200
    16.637   232.208     0.200
    16.637   233.021     0.200
    16.641   232.391     0.200
    16.721   233.171     0.200
    16.756   234.161     0.200
    16.843   237.206     0.200
    16.843   235.481     0.200
    16.933   234.959     0.200
    16.933   236.081     0.200
    17.029   237.531     0.200
    17.185   239.911     0.200
    17.221   240.341     0.200
    17.457   242.141     0.200
    17.614   245.311     0.200
    17.708   246.431     0.200
    17.725   244.436     0.200
    17.763   246.291     0.200
    17.813   247.721     0.200
    17.785   246.641     0.200
    17.899   248.131     0.200
    17.933   248.591     0.200
    18.003   248.801     0.200
    18.086   250.181     0.200
    18.087   250.341     0.200
    18.136   249.947     0.200
    18.136   250.741     0.200
    18.188   251.251     0.200
    18.259   252.131     0.200
    18.372   256.175     0.200
    18.390   255.531     0.200
    18.543   257.181     0.200
    18.583   259.093     0.200
    18.676   260.773     0.200
    18.739   260.397     0.200
    18.982   262.662     0.200
    19.063   262.898     0.200
    19.180   265.441     0.200
    19.230   267.077     0.200
    19.229   265.021     0.200
    19.237   266.631     0.200
    19.237   267.154     0.200
    19.237   265.411     0.200
    19.290   266.625     0.200
    19.410   266.801     0.200
    19.566   269.605     0.200
    19.634   269.721     0.200
    19.722   271.231     0.200
    19.738   271.357     0.200
    19.984   273.748     0.200
    20.111   275.478     0.200
    20.365   277.875     0.200
    20.390   278.271     0.200
    20.488   279.647     0.200
    20.578   280.401     0.200
    20.646   281.481     0.200
    20.720   281.837     0.200
    20.720   281.631     0.200
    20.756   282.249     0.200
    20.759   281.721     0.200
    20.768   282.446     0.200
     1.216    21.625     0.200
     1.734    32.186     0.200
     2.102    34.244     0.200
     2.605    42.055     0.200
     2.925    45.824     0.200
     3.070    46.895     0.200
     3.930    64.455     0.200
     3.960    60.164     0.200
     4.823    72.025     0.200
     5.643    84.855     0.200
     6.867   102.725     0.200
     7.480   113.260     0.200
     7.875   115.295     0.200
     9.160   133.010     0.200
    10.225   145.615     0.200
    10.176   147.695     0.200
    10.176   147.973     0.200
    10.176   148.225     0.200
    10.176   148.145     0.200
    10.954   157.814     0.200
    11.576   164.734     0.200
    11.911   166.814     0.200
    12.008   171.775     0.200
    12.008   172.365     0.200
    12.557   183.414     0.200
    12.557   179.338     0.200
    13.090   187.324     0.200
    13.005   186.525     0.200
    13.226   187.445     0.200
    13.884   196.984     0.200
    13.715   193.545     0.200
    13.715   195.713     0.200
    14.069   199.705     0.200
    14.069   200.488     0.200
    14.204   202.105     0.200
    14.204   202.000     0.200
    14.370   206.154     0.200
    14.370   205.682     0.200
    14.843   211.615     0.200
    14.843   210.877     0.200
    14.905   211.664     0.200
    15.071   213.555     0.200
    15.108   214.785     0.200
    15.273   215.525     0.200
    15.273   216.162     0.200
    15.057   216.084     0.200
    15.862   224.064     0.200
    15.862   223.588     0.200
    15.874   224.266     0.200
    15.874   224.031     0.200
    16.099   226.754     0.200
    16.028   225.314     0.200
    16.280   227.904     0.200
    16.147   228.814     0.200
    16.345   229.744     0.200
    16.508   232.805     0.200
    17.200   240.160     0.200
    17.594   244.205     0.200
    17.490   243.914     0.200
    17.490   244.742     0.200
    17.478   244.826     0.200
    18.318   252.635     0.200
    18.398   254.135     0.200
    18.507   255.416     0.200
    18.730   258.334     0.200
    19.208   263.490     0.200
    19.514   270.164     0.200
    19.722   269.205     0.200
    19.622   270.404     0.200
    19.826   271.275     0.200
    19.780   272.135     0.200
    20.635   282.176     0.200
    20.669   282.645     0.200
    20.961   285.254     0.200
     1.299    21.359     0.200
     2.642    40.781     0.200
     3.518    54.008     0.200
     3.685    59.164     0.200
     4.156    65.750     0.200
     4.180    66.750     0.200
     4.252    62.961     0.200
     4.317    70.078     0.200
     4.360    68.312     0.200
     4.360    66.148     0.200
     4.467    66.328     0.200
     5.010    77.430     0.200
     5.307    78.000     0.200
     5.307    77.273     0.200
     5.323    81.414     0.200
     6.055    89.547     0.200
     6.819   102.969     0.200
     7.075   104.680     0.200
     7.122   103.750     0.200
     7.384   111.164     0.200
     7.783   115.258     0.200
     7.999   119.641     0.200
     8.420   124.281     0.200
     8.420   124.844     0.200
     8.847   130.930     0.200
     8.847   127.344     0.200
    10.564   151.398     0.200
    10.681   156.609     0.200
    10.681   155.281     0.200
    10.681   154.320     0.200
    10.681   154.430     0.200
    10.736   154.383     0.200
    12.427   178.914     0.200
    12.427   176.883     0.200
    13.089   187.578     0.200
    13.566   192.422     0.200
    14.268   203.211     0.200
    14.268   203.578     0.200
    14.503   206.062     0.200
    14.503   205.875     0.200
    14.586   205.672     0.200
    14.586   206.695     0.200
    14.933   212.516     0.200
    15.339   215.602     0.200
    15.339   216.164     0.200
    15.712   221.273     0.200
    15.870   221.969     0.200
    16.343   228.219     0.200
    16.343   229.086     0.200
    16.412   228.750     0.200
    16.498   231.297     0.200
    16.542   231.648     0.200
    16.730   231.930     0.200
    16.730   233.492     0.200
    16.857   235.703     0.200
    17.552   242.688     0.200
    17.686   244.898     0.200
    17.914   248.062     0.200
    17.915   246.148     0.200
    18.082   248.680     0.200
    18.383   255.078     0.200
    18.432   256.508     0.200
    18.462   256.055     0.200
    18.611   258.789     0.200
    18.605   256.898     0.200
    18.618   259.766     0.200
    18.618   258.273     0.200
    18.618   259.023     0.200
    18.680   259.648     0.200
    18.697   258.109     0.200
    18.711   257.812     0.200
    18.859   259.523     0.200
    19.009   262.516     0.200
    19.108   262.711     0.200
    19.108   263.008     0.200
    19.139   264.297     0.200
    19.344   266.844     0.200
    19.505   268.727     0.200
    19.561   269.328     0.200
    19.534   267.227     0.200
    19.610   268.094     0.200
    19.742   271.148     0.200
    19.794   272.484     0.200
    19.951   273.180     0.200
    19.984   273.000     0.200
    20.124   275.508     0.200
    20.114   275.469     0.200
    20.114   275.305     0.200
    20.128   275.719     0.200
    20.279   276.570     0.200
    20.337   277.469     0.200
    20.343   276.508     0.200
    20.406   277.781     0.200
    20.611   280.828     0.200
    20.611   280.602     0.200
    20.627   279.898     0.200
    20.698   281.273     0.200
     1.305    21.840     0.200
     1.396    24.078     0.200
     1.467    24.297     0.200
     1.435    24.816     0.200
     1.549    26.777     0.200
     1.585    26.410     0.200
     2.079    34.590     0.200
     2.079    35.289     0.200
     2.267    36.328     0.200
     2.576    39.898     0.200
     2.979    46.066     0.200
     2.962    46.316     0.200
     2.934    46.199     0.200
     3.076    48.477     0.200
     3.130    48.020     0.200
     3.113    51.168     0.200
     3.178    51.328     0.200
     3.267    50.688     0.200
     3.352    53.328     0.200
     3.423    54.438     0.200
     3.487    57.168     0.200
     3.550    55.316     0.200
     3.556    58.258     0.200
     3.570    57.457     0.200
     3.571    58.719     0.200
     3.593    59.359     0.200
     3.602    57.469     0.200
     3.697    55.727     0.200
     3.749    60.316     0.200
     3.838    62.137     0.200
     3.843    58.750     0.200
     4.000    61.949     0.200
     4.001    61.637     0.200
     4.001    61.270     0.200
     4.001    62.270     0.200
     4.108    64.387     0.200
     4.376    66.387     0.200
     4.548    68.488     0.200
     4.628    69.988     0.200
     4.718    70.809     0.200
     4.694    71.168     0.200
     4.805    70.977     0.200
     5.101    77.469     0.200
     5.088    82.688     0.200
     5.106    78.707     0.200
     5.385    80.840     0.200
     5.738    83.910     0.200
     5.748    89.609     0.200
     5.810    85.340     0.200
     5.810    87.477     0.200
     5.944    89.637     0.200
     6.117    90.859     0.200
     6.605    96.668     0.200
     6.751    99.066     0.200
     7.321   111.066     0.200
     7.548   110.734     0.200
     7.548   110.137     0.200
     8.216   118.789     0.200
     8.636   128.078     0.200
    10.520   152.219     0.200
    10.608   154.395     0.200
    11.197   160.938     0.200
    11.197   162.977     0.200
    11.197   162.969     0.200
    12.157   173.965     0.200
    12.590   180.738     0.200
    12.590   181.480     0.200
    13.732   193.758     0.200
    13.732   197.434     0.200
    14.473   205.750     0.200
    14.610   207.609     0.200
    14.708   206.930     0.200
    14.708   208.746     0.200
    15.058   213.539     0.200
    15.058   215.344     0.200
    15.388   214.109     0.200
    15.416   217.551     0.200
    15.785   222.348     0.200
    15.889   225.121     0.200
    16.426   230.750     0.200
    16.517   233.172     0.200
    16.723   233.816     0.200
    16.985   237.566     0.200
    17.085   238.457     0.200
    18.869   261.598     0.200
    19.184   264.961     0.200
    20.869   283.934     0.200
     0.908    16.273     0.200
     1.344    21.891     0.200
     2.281    36.684     0.200
     2.615    40.000     0.200
     2.544    40.953     0.200
     2.984    45.691     0.200
     3.089    49.570     0.200
     3.166    48.410     0.200
     4.029    59.820     0.200
     4.026    61.352     0.200
     4.005    62.613     0.200
     4.396    66.500     0.200
     4.755    70.391     0.200
     4.715    71.281     0.200
     1.169    22.109     0.200
     1.180    22.088     0.200
     1.212    22.658     0.200
     1.226    23.059     0.200
     1.721    30.318     0.200
     2.020    31.488     0.200
     2.500    41.369     0.200
     2.915    46.168     0.200
     3.288    49.469     0.200
     3.691    53.869     0.200
     3.759    58.758     0.200
     3.712    56.088     0.200
     4.035    63.279     0.200
     4.182    62.078     0.200
     4.182    61.588     0.200
     4.203    65.049     0.200
     4.413    71.588     0.200
     4.445    68.008     0.200
     4.523    69.668     0.200
     4.718    72.129     0.200
     4.643    74.039     0.200
     4.715    71.498     0.200
     4.627    72.539     0.200
     5.080    76.709     0.200
     5.434    81.279     0.200
     5.400    81.168     0.200
     5.522    83.768     0.200
     5.820    87.389     0.200
     6.081    90.689     0.200
     6.391    94.789     0.200
     6.527    95.848     0.200
     6.944   103.328     0.200
     7.542   111.918     0.200
     7.845   118.178     0.200
     7.995   118.648     0.200
     8.261   120.498     0.200
     8.261   120.779     0.200
     8.831   130.008     0.200
    10.651   151.918     0.200
    10.985   159.738     0.200
    10.984   160.604     0.200
    10.984   160.029     0.200
    10.985   160.029     0.200
    11.210   162.629     0.200
    11.240   163.158     0.200
    11.333   164.748     0.200
    12.572   180.318     0.200
    13.453   192.609     0.200
    13.453   194.008     0.200
    14.044   199.508     0.200
    14.697   208.838     0.200
    15.617   220.238     0.200
    15.617   222.758     0.200
    16.036   226.148     0.200
    16.592   233.529     0.200
    16.724   235.039     0.200
    16.792   237.023     0.200
    16.792   236.428     0.200
    16.893   235.789     0.200
    17.167   240.498     0.200
    17.758   248.289     0.200
    17.905   247.959     0.200
    18.114   250.689     0.200
    18.529   258.516     0.200
    18.785   261.676     0.200
    19.183   265.023     0.200
    19.352   267.428     0.200
    19.684   271.516     0.200
    20.336   279.414     0.200
    20.641   282.051     0.200
     0.300     8.992     0.200
     0.867    15.727     0.200
     0.953    16.781     0.200
     1.057    18.297     0.200
     1.073    19.727     0.200
     1.077    19.805     0.200
     1.098    19.945     0.200
     1.349    22.742     0.200
     1.806    28.695     0.200
     2.122    34.703     0.200
     2.122    34.961     0.200
     2.640    41.703     0.200
     2.864    43.617     0.200
     3.076    46.562     0.200
     3.374    51.742     0.200
     3.434    53.625     0.200
     3.821    58.453     0.200
     3.857    59.273     0.200
     4.187    61.031     0.200
     4.293    65.117     0.200
     4.280    63.266     0.200
     4.280    61.961     0.200
     4.430    66.023     0.200
     4.430    64.773     0.200
     7.968   115.039     0.200
     8.107   119.594     0.200
    10.359   147.047     0.200
    10.713   152.836     0.200
    10.798   153.141     0.200
    10.798   152.586     0.200
    12.303   174.305     0.200
    13.190   186.125     0.200
    13.220   186.852     0.200
    13.690   192.656     0.200
    14.373   201.484     0.200
    14.409   202.852     0.200
    14.592   203.922     0.200
    14.975   209.172     0.200
    15.254   213.203     0.200
    15.411   215.547     0.200
    15.679   219.867     0.200
    15.835   220.250     0.200
    15.900   221.945     0.200
    16.370   227.922     0.200
    16.629   230.273     0.200
    16.649   230.664     0.200
    16.714   231.711     0.200
    17.448   240.672     0.200
    17.802   243.914     0.200
    18.179   249.961     0.200
     1.724    29.844     0.200
     1.976    31.887     0.200
     1.966    34.363     0.200
     2.496    41.875     0.200
     2.496    41.535     0.200
     2.925    45.734     0.200
     2.965    46.824     0.200
     3.243    51.023     0.200
     3.537    57.977     0.200
     3.635    56.746     0.200
     3.729    56.293     0.200
     3.716    59.785     0.200
     3.804    58.645     0.200
     3.818    59.906     0.200
     4.072    64.477     0.200
     4.162    61.836     0.200
     4.177    63.996     0.200
     4.175    66.215     0.200
     4.180    66.234     0.200
     4.200    67.324     0.200
     4.265    67.496     0.200
     4.369    66.203     0.200
     4.345    69.965     0.200
     4.558    70.836     0.200
     4.619    73.137     0.200
     4.678    71.246     0.200
     4.678    71.113     0.200
     5.046    74.605     0.200
     5.390    79.906     0.200
     5.761    86.477     0.200
     8.046   121.055     0.200
     8.225   119.762     0.200
    10.961   157.484     0.200
    11.027   156.504     0.200
    11.026   160.914     0.200
    11.026   157.535     0.200
    12.604   183.664     0.200
    13.498   194.629     0.200
    14.697   209.938     0.200
    14.703   209.102     0.200
    15.602   220.941     0.200
    16.008   224.066     0.200
    16.837   236.160     0.200
    16.926   236.176     0.200
    18.622   257.559     0.200
    18.674   258.688     0.200
    18.980   262.164     0.200
    19.228   265.016     0.200
    19.235   265.887     0.200
    19.235   265.637     0.200
    19.235   264.750     0.200
    19.288   265.605     0.200
    19.399   267.004     0.200
    19.499   268.125     0.200
    19.499   269.594     0.200
    19.626   270.242     0.200
    19.633   270.160     0.200
    19.642   269.246     0.200
    20.109   274.484     0.200
    20.196   276.242     0.200
    20.363   278.055     0.200
    20.387   278.852     0.200
    20.685   281.777     0.200
    20.689   281.254     0.200
     0.874    15.684     0.200
     1.929    30.066     0.200
     1.983    31.375     0.200
     2.391    40.113     0.200
     2.847    44.535     0.200
     2.924    46.414     0.200
     3.200    48.043     0.200
     3.067    48.195     0.200
     3.565    54.895     0.200
     3.649    55.285     0.200
     3.609    55.227     0.200
     3.661    58.113     0.200
     3.703    56.887     0.200
     3.728    58.203     0.200
     3.922    63.656     0.200
     4.064    64.773     0.200
     4.090    61.996     0.200
     4.473    68.414     0.200
     4.612    69.754     0.200
     5.343    78.863     0.200
     5.722    85.594     0.200
     5.973    86.684     0.200
     8.157   118.461     0.200
     8.666   123.836     0.200
    10.955   159.891     0.200
    12.777   183.039     0.200
    16.776   234.637     0.200
     0.774    14.684     0.200
     0.875    15.184     0.200
     1.263    20.902     0.200
     1.379    23.070     0.200
     1.490    25.203     0.200
     1.494    25.250     0.200
     1.493    25.031     0.200
     1.513    25.332     0.200
     1.559    24.781     0.200
     1.618    26.480     0.200
     1.645    28.012     0.200
     1.999    31.871     0.200
     2.507    39.492     0.200
     2.666    43.102     0.200
     2.737    43.602     0.200
     2.793    44.191     0.200
     3.024    47.051     0.200
     3.062    49.441     0.200
     3.225    49.910     0.200
     3.596    54.000     0.200
     3.665    57.000     0.200
     3.699    57.352     0.200
     3.796    57.762     0.200
     3.829    58.383     0.200
     4.135    62.391     0.200
     4.607    68.410     0.200
     4.613    69.461     0.200
     4.936    74.023     0.200
     5.124    76.293     0.200
     6.361    92.402     0.200
     7.330   106.113     0.200
     7.982   113.543     0.200
     1.005    17.814     0.200
     1.642    27.996     0.200
     1.754    28.486     0.200
     1.853    30.406     0.200
     1.853    30.516     0.200
     1.835    31.166     0.200
     1.957    32.145     0.200
     2.063    33.725     0.200
     1.909    34.105     0.200
     1.909    33.186     0.200
     2.277    36.426     0.200
     2.277    36.256     0.200
     2.510    38.945     0.200
     2.680    44.295     0.200
     2.647    42.535     0.200
     2.824    43.656     0.200
     2.767    44.826     0.200
     2.767    44.145     0.200
     2.840    46.506     0.200
     2.840    46.656     0.200
     3.099    51.225     0.200
     3.143    51.486     0.200
     3.211    50.156     0.200
     3.190    52.035     0.200
     3.253    50.846     0.200
     3.253    50.676     0.200
     3.263    51.836     0.200
     3.292    54.365     0.200
     3.393    52.385     0.200
     3.393    51.836     0.200
     3.319    54.385     0.200
     3.396    55.125     0.200
     3.413    55.395     0.200
     3.579    56.564     0.200
     3.587    55.775     0.200
     3.685    57.166     0.200
     3.684    56.564     0.200
     3.684    57.006     0.200
     3.705    59.135     0.200
     3.707    58.275     0.200
     3.817    59.326     0.200
     3.867    58.836     0.200
     3.865    61.115     0.200
     4.061    61.105     0.200
     4.412    66.355     0.200
     4.379    66.705     0.200
     4.489    68.645     0.200
     4.489    66.705     0.200
     4.410    69.916     0.200
     4.787    72.576     0.200
     4.665    71.766     0.200
     4.665    71.465     0.200
     4.997    75.215     0.200
     5.071    75.205     0.200
     5.071    75.035     0.200
     5.432    81.076     0.200
     5.494    82.555     0.200
     5.494    82.555     0.200
     5.452    80.326     0.200
     5.807    88.246     0.200
     5.807    87.385     0.200
     6.289    92.475     0.200
     6.443    93.916     0.200
     6.443    95.506     0.200
     7.232   105.855     0.200
     7.309   108.725     0.200
     7.900   114.746     0.200
     8.947   128.225     0.200
     8.899   131.246     0.200
    10.178   147.986     0.200
    10.207   148.326     0.200
    10.301   149.766     0.200
    11.260   166.375     0.200
     0.287     8.283     0.200
     1.770    27.594     0.200
     2.111    35.334     0.200
     2.130    35.273     0.200
     2.130    34.963     0.200
     2.620    40.354     0.200
     3.041    45.674     0.200
     2.830    43.584     0.200
     2.830    44.803     0.200
     2.910    44.822     0.200
     3.350    50.934     0.200
     3.416    52.133     0.200
     3.354    50.883     0.200
     3.813    58.992     0.200
     3.844    58.482     0.200
     4.280    65.553     0.200
     4.281    65.553     0.200
     4.404    67.553     0.200
     4.404    66.203     0.200
     4.320    64.902     0.200
     4.753    70.934     0.200
     5.074    75.623     0.200
     5.172    75.963     0.200
     5.217    77.854     0.200
     5.529    82.264     0.200
     7.944   114.686     0.200
     8.148   120.893     0.200
     8.758   128.807     0.200
     8.764   127.934     0.200
    10.841   155.633     0.200
    10.841   155.973     0.200
    10.841   154.992     0.200
     0.798    14.350     0.200
     0.906    16.800     0.200
     0.978    19.340     0.200
     1.248    22.409     0.200
     1.395    22.640     0.200
     1.437    23.569     0.200
     1.490    25.600     0.200
     1.587    25.029     0.200
     1.661    29.899     0.200
     2.109    34.010     0.200
     2.187    33.720     0.200
     2.294    36.999     0.200
     2.540    39.499     0.200
     2.639    41.109     0.200
     2.477    40.749     0.200
     2.854    44.560     0.200
     2.898    45.279     0.200
     2.920    43.810     0.200
     3.285    52.520     0.200
     3.317    51.560     0.200
     3.405    53.649     0.200
     3.915    60.039     0.200
     3.953    60.409     0.200
     4.247    64.459     0.200
     4.198    63.850     0.200
     4.198    64.579     0.200
     4.569    69.260     0.200
     4.736    70.149     0.200
     4.733    71.390     0.200
     4.926    74.479     0.200
     5.059    76.189     0.200
     5.231    78.529     0.200
     5.752    84.729     0.200
     5.733    85.229     0.200
     5.733    85.229     0.200
     6.751    98.579     0.200
     7.445   108.729     0.200
     8.494   123.659     0.200
     8.826   127.840     0.200
    10.785   152.069     0.200
    10.784   151.800     0.200
    10.784   156.100     0.200
    11.139   158.520     0.200
    12.137   172.430     0.200
    12.986   183.369     0.200
    13.691   192.050     0.200
    13.709   193.060     0.200
    13.899   193.590     0.200
    14.257   198.590     0.200
    15.135   210.329     0.200
    15.359   213.840     0.200
    15.789   219.789     0.200
    15.958   221.930     0.200
    16.143   223.430     0.200
    16.469   227.279     0.200
     1.118    19.408     0.200
     1.314    22.098     0.200
     2.374    37.638     0.200
     2.655    42.128     0.200
     2.902    45.418     0.200
     3.192    51.828     0.200
     3.708    58.498     0.200
     3.728    58.698     0.200
     4.061    61.978     0.200
     4.381    67.668     0.200
     4.488    69.098     0.200
     4.520    68.678     0.200
     4.834    74.188     0.200
     5.059    74.208     0.200
     1.325    24.471     0.200
     1.319    23.951     0.200
     1.788    31.262     0.200
     1.730    31.492     0.200
     1.990    33.992     0.200
     2.091    36.631     0.200
     2.091    36.422     0.200
     2.106    35.842     0.200
     2.094    36.893     0.200
     2.185    37.861     0.200
     2.779    47.893     0.200
     2.803    48.121     0.200
     2.840    46.521     0.200
     3.057    49.152     0.200
     3.312    54.781     0.200
     3.319    55.021     0.200
     3.309    54.551     0.200
     3.348    54.332     0.200
     3.364    55.732     0.200
     3.406    54.961     0.200
     3.406    55.332     0.200
     3.459    56.832     0.200
     3.454    57.131     0.200
     3.502    55.652     0.200
     3.593    57.912     0.200
     3.595    57.121     0.200
     3.644    58.771     0.200
     3.698    61.662     0.200
     3.788    62.312     0.200
     3.790    61.902     0.200
     3.790    61.371     0.200
     3.790    62.312     0.200
     3.806    62.092     0.200
     3.814    60.393     0.200
     3.828    61.432     0.200
     3.887    63.242     0.200
     3.900    61.691     0.200
     3.921    62.992     0.200
     3.976    65.322     0.200
     4.121    67.082     0.200
     4.166    64.992     0.200
     4.219    67.691     0.200
     4.218    67.691     0.200
     4.261    68.502     0.200
     4.262    68.502     0.200
     4.266    67.771     0.200
     4.263    67.312     0.200
     4.263    66.893     0.200
     4.404    69.531     0.200
     4.428    69.781     0.200
     4.446    71.611     0.200
     4.748    74.361     0.200
     5.070    79.021     0.200
     5.183    79.482     0.200
     5.219    81.102     0.200
     5.337    83.902     0.200
     5.436    83.852     0.200
     5.448    84.262     0.200
     5.534    85.521     0.200
     5.737    88.031     0.200
     5.829    90.771     0.200
     6.009    91.602     0.200
     6.202    94.232     0.200
     6.222    94.301     0.200
     6.221    94.301     0.200
     6.975   104.361     0.200
     7.209   107.152     0.200
     7.942   117.951     0.200
     8.121   125.072     0.200
     8.714   130.002     0.200
     8.729   129.652     0.200
     9.436   137.182     0.200
    10.182   147.281     0.200
    10.337   150.422     0.200
    10.687   156.631     0.200
    10.786   158.521     0.200
    10.786   158.512     0.200
    10.786   158.371     0.200
    10.786   157.881     0.200
    11.426   164.961     0.200
    11.533   169.201     0.200
    11.504   168.051     0.200
    11.622   168.482     0.200
    11.821   171.332     0.200
    12.159   175.512     0.200
    12.283   176.381     0.200
    12.341   180.352     0.200
    12.483   179.221     0.200
    12.822   183.711     0.200
    13.246   188.342     0.200
    13.292   190.361     0.200
    13.559   193.492     0.200
    13.679   196.471     0.200
    13.787   197.701     0.200
    13.910   200.291     0.200
    13.980   200.062     0.200
    14.082   201.301     0.200
    14.351   204.961     0.200
    14.390   204.262     0.200
    14.587   210.361     0.200
    14.951   212.572     0.200
    14.989   213.332     0.200
    15.232   215.682     0.200
    15.397   217.441     0.200
    15.389   220.451     0.200
    15.657   222.471     0.200
    15.719   225.271     0.200
    15.744   222.521     0.200
    15.828   225.031     0.200
    15.872   224.662     0.200
    15.892   224.041     0.200
    16.020   226.242     0.200
    16.354   230.762     0.200
    16.385   231.191     0.200
    16.640   235.277     0.200
    17.551   245.281     0.200
    17.504   246.551     0.200
    18.080   253.143     0.200
    18.222   253.902     0.200
    18.303   255.271     0.200
    18.347   255.021     0.200
    18.472   256.652     0.200
    18.461   257.512     0.200
    18.657   261.342     0.200
    19.215   268.250     0.200
    19.279   268.111     0.200
    19.606   273.031     0.200
     0.641    11.801     0.200
     1.127    18.840     0.200
     1.914    31.121     0.200
     2.159    35.910     0.200
     2.427    38.590     0.200
     2.640    42.609     0.200
     2.715    44.250     0.200
     2.901    44.660     0.200
     2.785    44.289     0.200
     3.165    49.508     0.200
     3.610    57.379     0.200
     3.695    56.398     0.200
     3.720    57.031     0.200
     3.601    57.371     0.200
     4.044    61.352     0.200
     1.120    19.797     0.200
     1.455    24.166     0.200
     1.686    27.496     0.200
     1.665    28.717     0.200
     1.873    29.227     0.200
     2.058    33.307     0.200
     2.079    33.107     0.200
     2.433    39.656     0.200
     2.823    44.377     0.200
     3.020    47.777     0.200
     3.044    48.676     0.200
     3.068    51.697     0.200
     3.141    49.217     0.200
     3.127    52.348     0.200
     3.532    55.736     0.200
     3.628    57.717     0.200
     3.653    59.217     0.200
     3.701    57.518     0.200
     3.683    58.576     0.200
     4.069    62.756     0.200
     4.069    64.777     0.200
     4.080    62.066     0.200
     4.266    63.906     0.200
     4.523    69.176     0.200
     4.535    69.387     0.200
     4.536    69.387     0.200
     4.561    70.146     0.200
     4.561    68.396     0.200
     4.574    68.887     0.200
     4.574    69.217     0.200
     4.794    75.057     0.200
     4.944    73.996     0.200
     5.263    78.787     0.200
     5.288    77.857     0.200
     5.380    80.727     0.200
     5.661    85.707     0.200
     5.676    84.787     0.200
     5.718    82.316     0.200
     5.947    88.197     0.200
     6.177    92.207     0.200
     6.307    92.867     0.200
     6.385    94.746     0.200
     6.385    94.746     0.200
     7.037   106.527     0.200
     7.322   106.506     0.200
     7.451   110.156     0.200
     7.533   111.057     0.200
     7.854   114.277     0.200
     8.121   117.727     0.200
     8.135   119.486     0.200
     8.921   130.467     0.200
     8.921   133.098     0.200
     9.774   143.057     0.200
    10.664   154.098     0.200
    10.664   155.717     0.200
    11.049   159.986     0.200
    11.049   159.127     0.200
    11.049   161.064     0.200
    11.403   164.848     0.200
    11.713   168.848     0.200
    11.710   167.496     0.200
    11.827   169.906     0.200
    12.085   173.066     0.200
    12.598   180.127     0.200
    12.598   182.926     0.200
    12.802   182.896     0.200
    12.782   184.426     0.200
    13.083   186.986     0.200
    13.507   192.236     0.200
    13.530   193.447     0.200
    13.530   195.600     0.200
    13.529   191.848     0.200
    13.566   192.037     0.200
    13.839   195.836     0.200
    13.933   199.826     0.200
    13.974   200.557     0.200
    14.120   202.047     0.200
    14.150   198.867     0.200
    14.176   202.807     0.200
    14.680   208.416     0.200
    14.701   208.537     0.200
    14.723   210.018     0.200
    14.790   209.896     0.200
    14.855   211.607     0.200
    15.238   216.938     0.200
    15.294   217.316     0.200
    15.512   219.047     0.200
    15.543   219.947     0.200
    15.558   220.217     0.200
    15.571   220.826     0.200
    15.673   221.227     0.200
    15.983   225.076     0.200
    16.047   223.768     0.200
    16.095   227.176     0.200
    16.922   236.316     0.200
    17.683   243.467     0.200
    17.793   244.166     0.200
    17.953   247.396     0.200
    18.089   250.566     0.200
    18.082   250.688     0.200
    18.445   254.658     0.200
    18.468   255.826     0.200
    18.601   257.916     0.200
    18.634   257.086     0.200
    18.634   258.973     0.200
    18.689   259.270     0.200
    18.751   260.023     0.200
    18.729   259.326     0.200
    18.808   260.955     0.200
    18.794   259.906     0.200
    18.821   259.256     0.200
    18.841   260.566     0.200
    18.852   261.484     0.200
    19.241   264.477     0.200
    19.302   266.023     0.200
    19.309   266.781     0.200
    19.309   266.455     0.200
    19.360   267.998     0.200
    19.440   267.066     0.200
    19.440   269.000     0.200
    19.676   271.061     0.200
    19.709   270.492     0.200
    19.806   271.934     0.200
    20.180   276.104     0.200
    20.194   274.857     0.200
    20.439   278.668     0.200
    20.456   279.021     0.200
    20.508   279.197     0.200
    20.559   279.826     0.200
    20.706   282.068     0.200
    20.736   282.648     0.200
    20.789   282.682     0.200
    20.832   282.617     0.200
     1.109    20.609     0.200
     1.657    26.922     0.200
     1.887    29.422     0.200
     2.029    32.230     0.200
     2.817    43.602     0.200
     3.157    48.781     0.200
     2.971    47.262     0.200
     3.079    45.480     0.200
     3.531    57.520     0.200
     3.620    55.422     0.200
     4.049    59.719     0.200
     4.066    61.941     0.200
     4.504    70.219     0.200
     4.505    70.219     0.200
     4.505    67.559     0.200
     4.505    69.199     0.200
     8.102   118.852     0.200
     8.869   127.070     0.200
     9.722   137.680     0.200
    10.609   150.910     0.200
    10.993   156.492     0.200
    10.993   156.012     0.200
    10.993   159.395     0.200
    11.347   163.742     0.200
    11.658   166.641     0.200
    11.773   165.910     0.200
    12.029   170.109     0.200
    12.543   177.582     0.200
    12.726   183.320     0.200
    12.894   181.680     0.200
    13.028   183.992     0.200
    13.455   189.949     0.200
    13.511   190.242     0.200
    13.476   192.352     0.200
    13.476   190.910     0.200
    13.703   193.520     0.200
    13.783   191.762     0.200
    13.919   195.090     0.200
    14.626   203.262     0.200
    14.626   205.664     0.200
    14.645   204.160     0.200
    14.645   206.020     0.200
    14.667   204.750     0.200
    14.738   206.941     0.200
    14.738   207.859     0.200
    14.799   208.672     0.200
    14.966   209.301     0.200
    15.087   212.441     0.200
    15.238   215.539     0.200
    15.420   214.941     0.200
    15.456   216.332     0.200
    15.519   215.398     0.200
    15.519   218.465     0.200
    15.503   217.090     0.200
    15.617   218.621     0.200
    15.890   221.242     0.200
    16.006   221.199     0.200
    15.994   221.000     0.200
    16.079   222.922     0.200
    16.079   226.434     0.200
    16.566   228.332     0.200
    16.586   232.750     0.200
    16.586   232.234     0.200
    16.670   230.469     0.200
    16.818   235.785     0.200
    16.866   234.672     0.200
    16.958   236.352     0.200
    17.618   245.621     0.200
    17.738   243.750     0.200
    17.702   245.512     0.200
    18.033   248.281     0.200
    18.490   255.992     0.200
    18.584   257.102     0.200
    18.584   256.914     0.200
    18.643   257.844     0.200
    18.766   258.383     0.200
    18.797   259.562     0.200
    18.765   259.250     0.200
    19.267   266.641     0.200
    19.387   266.074     0.200
    19.524   266.344     0.200
    19.622   269.012     0.200
    20.236   276.160     0.200
    20.356   276.574     0.200
    20.452   277.840     0.200
     0.911    16.551     0.200
     0.791    16.449     0.200
     1.017    18.781     0.200
     1.195    21.078     0.200
     1.262    22.699     0.200
     1.259    22.539     0.200
     1.269    22.750     0.200
     1.291    23.148     0.200
     1.314    22.891     0.200
     1.310    23.281     0.200
     1.432    23.570     0.200
     1.454    24.668     0.200
     1.508    24.711     0.200
     2.106    34.078     0.200
     2.165    33.051     0.200
     2.507    37.719     0.200
     2.724    41.730     0.200
     2.867    45.430     0.200
     2.878    45.078     0.200
     2.974    45.520     0.200
     3.209    49.141     0.200
     3.267    52.352     0.200
     3.693    57.102     0.200
     3.792    57.039     0.200
     3.932    60.039     0.200
     4.004    61.738     0.200
     4.243    64.410     0.200
     4.566    68.539     0.200
    10.594   149.520     0.200
     0.820    14.062     0.200
     1.146    18.273     0.200
     1.205    19.344     0.200
     1.537    24.562     0.200
     1.599    26.625     0.200
     1.594    26.715     0.200
     1.607    26.633     0.200
     1.626    27.254     0.200
     1.656    27.254     0.200
     1.646    27.422     0.200
     1.763    27.934     0.200
     1.773    28.562     0.200
     1.794    28.465     0.200
     2.394    38.535     0.200
     2.503    39.203     0.200
     2.528    40.203     0.200
     2.553    41.082     0.200
     2.881    44.184     0.200
     2.847    44.695     0.200
     2.965    47.754     0.200
     3.400    52.734     0.200
     3.593    54.273     0.200
     3.644    55.613     0.200
     3.912    60.312     0.200
     1.485    26.270     0.200
     1.655    30.359     0.200
     1.840    32.729     0.200
     1.976    33.449     0.200
     2.156    35.459     0.200
     2.118    36.180     0.200
     2.155    37.159     0.200
     2.469    40.560     0.200
     2.502    42.739     0.200
     2.505    41.089     0.200
     2.844    45.939     0.200
     2.949    47.569     0.200
     2.948    49.520     0.200
     2.948    48.039     0.200
     3.176    50.549     0.200
     3.205    52.659     0.200
     3.243    53.029     0.200
     3.226    53.180     0.200
     3.283    54.589     0.200
     3.418    56.029     0.200
     3.421    54.020     0.200
     3.431    54.869     0.200
     3.440    56.279     0.200
     3.443    56.520     0.200
     3.486    57.449     0.200
     3.516    54.060     0.200
     3.565    58.739     0.200
     3.536    58.699     0.200
     3.572    56.539     0.200
     3.614    59.169     0.200
     3.655    57.390     0.200
     3.621    56.399     0.200
     3.621    56.899     0.200
     3.724    56.989     0.200
     3.789    62.339     0.200
     3.844    63.449     0.200
     3.940    64.729     0.200
     4.308    65.089     0.200
     4.308    68.350     0.200
     4.587    70.520     0.200
     4.910    75.499     0.200
     5.131    79.919     0.200
     5.195    81.829     0.200
     5.216    79.999     0.200
     5.171    78.799     0.200
     5.399    82.749     0.200
     5.484    84.909     0.200
     5.530    85.699     0.200
     6.045    93.220     0.200
     6.118    93.899     0.200
     6.224    94.119     0.200
     6.352    99.680     0.200
     6.512    97.119     0.200
     6.846   102.560     0.200
     7.205   108.510     0.200
     8.414   122.579     0.200
     8.783   132.629     0.200
     9.498   136.390     0.200
     9.754   144.239     0.200
    10.183   147.646     0.200
    13.921   196.569     0.200
    14.549   206.390     0.200
    14.556   206.529     0.200
    14.568   207.909     0.200
    14.774   210.699     0.200
    14.955   211.209     0.200
    15.074   211.689     0.200
    15.717   222.289     0.200
    15.943   224.159     0.200
    16.080   227.629     0.200
    16.662   234.529     0.200
    16.765   236.189     0.200
    16.872   236.339     0.200
    17.253   241.449     0.200
    17.545   245.100     0.200
    17.640   244.109     0.200
    17.797   247.430     0.200
    17.815   247.720     0.200
    18.229   253.430     0.200
    18.293   252.770     0.200
    18.885   264.748     0.200
     1.266    23.171     0.200
     1.271    22.341     0.200
     1.274    23.381     0.200
     1.429    24.141     0.200
     1.303    23.721     0.200
     1.320    24.001     0.200
     1.324    23.971     0.200
     1.710    29.091     0.200
     2.053    32.070     0.200
     2.082    36.011     0.200
     2.408    40.631     0.200
     2.604    42.121     0.200
     2.799    44.491     0.200
     2.799    44.110     0.200
     3.116    47.761     0.200
     3.518    53.331     0.200
     3.604    56.461     0.200
     3.602    56.931     0.200
     3.675    56.081     0.200
     3.640    55.730     0.200
     3.665    58.771     0.200
     3.851    62.860     0.200
     3.814    59.681     0.200
     3.900    62.221     0.200
     3.958    59.931     0.200
     4.027    62.871     0.200
     4.046    60.650     0.200
     4.057    63.291     0.200
     4.047    60.311     0.200
     4.066    63.690     0.200
     4.085    64.811     0.200
     4.162    62.400     0.200
     4.170    64.601     0.200
     4.240    64.051     0.200
     4.312    67.561     0.200
     4.364    67.110     0.200
     4.524    65.440     0.200
     4.500    70.421     0.200
     4.549    67.070     0.200
     4.549    69.480     0.200
     4.517    70.451     0.200
     4.540    68.991     0.200
     4.564    67.741     0.200
     4.564    70.181     0.200
     4.783    70.301     0.200
     5.262    78.690     0.200
     5.650    83.911     0.200
     5.636    84.400     0.200
     5.922    86.501     0.200
     6.167    92.161     0.200
     6.281    92.971     0.200
     7.051   106.701     0.200
     7.297   104.961     0.200
     7.527   109.881     0.200
     8.096   118.330     0.200
     8.096   118.110     0.200
     8.158   120.280     0.200
    11.057   157.711     0.200
    11.056   157.530     0.200
    11.056   161.485     0.200
    12.092   171.701     0.200
    14.953   211.791     0.200
    15.019   210.121     0.200
    15.297   217.721     0.200
    15.516   218.501     0.200
    15.565   218.381     0.200
    15.680   219.621     0.200
    16.923   234.161     0.200
    17.022   236.440     0.200
     2.195    34.844     0.200
     2.890    42.785     0.200
     2.726    44.816     0.200
     3.166    51.656     0.200
     3.493    54.277     0.200
     4.022    60.277     0.200
     4.119    60.105     0.200
     4.424    66.875     0.200
     4.664    70.516     0.200
     4.995    74.797     0.200
     5.087    74.844     0.200
     5.264    80.047     0.200
     5.358    80.156     0.200
     5.909    87.996     0.200
     5.944    87.695     0.200
     6.264    93.805     0.200
     0.414     9.420     0.200
     0.901    15.488     0.200
     1.080    18.139     0.200
     1.239    19.318     0.200
     1.611    26.859     0.200
     1.524    26.908     0.200
     1.778    28.830     0.200
     1.871    30.250     0.200
     1.869    30.449     0.200
     1.876    30.359     0.200
     1.901    31.039     0.200
     1.965    31.068     0.200
     1.919    31.219     0.200
     1.876    32.709     0.200
     2.020    32.309     0.200
     2.116    32.729     0.200
     2.338    37.639     0.200
     2.413    38.859     0.200
     2.434    41.209     0.200
     2.623    40.510     0.200
     2.717    40.770     0.200
     2.742    45.420     0.200
     2.872    45.469     0.200
     2.874    44.879     0.200
     2.891    46.148     0.200
     3.071    46.930     0.200
     3.195    48.229     0.200
     3.354    53.000     0.200
     1.222    21.400     0.200
     2.394    39.081     0.200
     2.656    43.341     0.200
     3.461    54.211     0.200
     3.624    58.780     0.200
     3.869    58.721     0.200
     5.193    76.150     0.200
     5.306    77.841     0.200
     1.357    23.047     0.200
     1.625    27.742     0.200
     1.670    28.258     0.200
     1.802    29.891     0.200
     1.822    31.727     0.200
     1.825    31.648     0.200
     1.841    32.008     0.200
     1.866    32.430     0.200
     1.877    32.383     0.200
     1.887    31.867     0.200
     2.212    36.062     0.200
     2.198    37.336     0.200
     2.413    38.258     0.200
     2.414    38.688     0.200
     2.559    43.742     0.200
     2.873    45.438     0.200
     2.979    48.703     0.200
     3.250    52.078     0.200
     3.335    53.961     0.200
     3.541    54.727     0.200
     3.499    58.453     0.200
     3.479    55.422     0.200
     3.479    57.172     0.200
     3.578    57.180     0.200
     3.597    56.219     0.200
     3.751    61.172     0.200
     3.894    63.586     0.200
     4.063    63.203     0.200
     4.563    69.461     0.200
     4.692    73.227     0.200
     4.853    74.203     0.200
     4.853    77.773     0.200
     4.970    75.797     0.200
     5.581    83.680     0.200
     6.089    92.086     0.200
     7.572   111.367     0.200
    11.429   165.992     0.200
    11.429   167.141     0.200
    11.429   169.188     0.200
    19.237   268.211     0.200
     0.948    15.496     0.200
     0.923    16.695     0.200
     0.929    17.547     0.200
     0.938    17.738     0.200
     0.947    17.977     0.200
     0.962    18.316     0.200
     0.982    18.375     0.200
     1.020    19.078     0.200
     1.126    20.305     0.200
     1.220    21.086     0.200
     1.540    26.457     0.200
     1.859    27.836     0.200
     1.913    32.316     0.200
     2.377    36.977     0.200
     3.063    46.496     0.200
     3.122    49.836     0.200
     3.148    48.465     0.200
     3.546    54.488     0.200
     4.117    60.848     0.200
     4.501    67.637     0.200
     4.824    72.145     0.200
     5.386    80.156     0.200
     5.451    80.965     0.200
     2.426    39.725     0.200
     2.542    41.905     0.200
     2.849    46.955     0.200
     2.980    48.745     0.200
     3.560    54.015     0.200
     3.617    55.455     0.200
     3.715    57.734     0.200
     4.542    70.755     0.200
     4.971    76.695     0.200
     0.980    17.533     0.200
     1.858    29.805     0.200
     2.429    40.453     0.200
     3.521    55.943     0.200
     3.620    57.475     0.200
     3.692    59.873     0.200
     3.686    57.984     0.200
     3.832    58.744     0.200
     3.919    62.514     0.200
     4.562    68.934     0.200
     4.562    69.533     0.200
     4.581    71.934     0.200
     4.934    72.043     0.200
     5.252    78.555     0.200
     5.367    82.273     0.200
     5.663    84.064     0.200
     5.938    85.814     0.200
     1.236    21.820     0.200
     3.412    56.051     0.200
     3.682    60.660     0.200
     3.915    60.070     0.200
     4.151    66.521     0.200
     4.166    63.150     0.200
     4.323    70.291     0.200
     4.450    70.471     0.200
     4.557    73.070     0.200
     5.022    77.461     0.200
     5.229    81.561     0.200
     5.873    88.641     0.200
     1.541    26.227     0.200
     1.663    28.617     0.200
     1.581    25.168     0.200
     1.968    31.258     0.200
     2.173    35.457     0.200
     3.029    48.867     0.200
     2.869    46.098     0.200
     3.057    49.908     0.200
     2.920    46.328     0.200
     3.238    50.238     0.200
     3.610    56.088     0.200
     3.649    57.928     0.200
     3.654    58.348     0.200
     3.654    58.607     0.200
     3.697    58.896     0.200
     3.710    58.947     0.200
     3.752    59.207     0.200
     3.795    59.297     0.200
     3.754    59.248     0.200
     3.971    62.607     0.200
     4.027    63.578     0.200
     4.114    65.057     0.200
     4.118    64.277     0.200
     4.118    65.307     0.200
     4.129    65.998     0.200
     4.135    64.828     0.200
     4.139    64.027     0.200
     4.143    65.117     0.200
     4.157    66.008     0.200
     4.162    64.537     0.200
     4.197    62.447     0.200
     4.230    65.396     0.200
     4.361    65.828     0.200
     4.564    70.748     0.200
     4.580    70.717     0.200
     4.495    67.957     0.200
     4.495    69.758     0.200
     4.602    70.537     0.200
     4.657    70.918     0.200
     4.657    71.098     0.200
     4.781    74.297     0.200
     5.020    76.047     0.200
     5.340    80.537     0.200
     5.382    80.258     0.200
     5.464    82.357     0.200
     5.685    86.568     0.200
     5.729    85.998     0.200
     5.764    86.748     0.200
     5.613    81.758     0.200
     6.020    89.598     0.200
     6.160    92.568     0.200
     6.328    93.057     0.200
     6.402    95.188     0.200
     6.469    96.957     0.200
     6.746   100.557     0.200
     6.942   104.818     0.200
     7.249   106.447     0.200
     7.416   109.117     0.200
     7.497   111.418     0.200
     7.855   113.037     0.200
     7.806   116.688     0.200
     8.202   119.627     0.200
     8.202   119.748     0.200
     8.028   119.287     0.200
     8.028   119.418     0.200
     8.642   127.277     0.200
     8.865   128.338     0.200
     8.828   127.707     0.200
     8.828   130.818     0.200
     8.940   133.098     0.200
     9.369   138.527     0.200
     9.674   142.467     0.200
     9.734   140.967     0.200
     9.636   141.037     0.200
     9.917   144.658     0.200
    10.074   147.318     0.200
    10.613   152.357     0.200
    10.613   154.654     0.200
    10.941   160.328     0.200
    10.941   158.988     0.200
    10.968   159.967     0.200
    10.968   159.533     0.200
    10.968   160.307     0.200
    11.341   165.508     0.200
    11.668   170.098     0.200
    11.642   169.797     0.200
    11.770   169.318     0.200
    11.841   172.348     0.200
    11.774   171.557     0.200
    11.754   171.818     0.200
    12.004   175.467     0.200
    12.539   182.688     0.200
    12.539   181.393     0.200
    12.539   180.797     0.200
    12.497   181.137     0.200
    12.697   182.227     0.200
    12.978   185.646     0.200
    13.002   185.787     0.200
    13.244   189.547     0.200
    13.244   190.297     0.200
    13.473   190.047     0.200
    13.473   188.158     0.200
    13.473   192.217     0.200
    13.483   191.367     0.200
    13.483   192.062     0.200
    13.443   192.908     0.200
    13.443   192.807     0.200
    13.510   191.307     0.200
    13.691   192.268     0.200
    13.764   196.818     0.200
    13.988   197.227     0.200
    14.050   199.207     0.200
    14.085   201.867     0.200
    14.401   201.688     0.200
    14.401   202.426     0.200
    14.401   203.068     0.200
    14.631   206.088     0.200
    14.631   206.410     0.200
    14.639   207.168     0.200
    14.673   208.498     0.200
    14.695   209.797     0.200
    14.695   209.949     0.200
    14.695   208.418     0.200
    14.784   209.357     0.200
    14.881   211.027     0.200
    14.971   211.158     0.200
    15.138   214.568     0.200
    15.074   214.627     0.200
    15.230   215.268     0.200
    15.458   216.928     0.200
    15.444   217.287     0.200
    15.536   219.508     0.200
    15.536   217.936     0.200
    15.442   218.338     0.200
    15.442   218.756     0.200
    15.442   218.488     0.200
    15.597   219.797     0.200
    15.597   219.291     0.200
    16.004   224.848     0.200
    16.004   226.137     0.200
    16.004   226.932     0.200
    16.020   226.713     0.200
    16.020   226.268     0.200
    16.569   231.498     0.200
    16.784   236.137     0.200
    16.742   236.258     0.200
    16.861   234.377     0.200
    16.861   234.908     0.200
    16.957   236.896     0.200
    17.147   240.818     0.200
    17.651   243.977     0.200
    17.567   245.748     0.200
    17.712   244.988     0.200
    17.656   246.867     0.200
    17.929   247.867     0.200
    18.063   248.885     0.200
    18.059   250.408     0.200
    18.535   257.807     0.200
    18.513   258.057     0.200
    18.689   257.318     0.200
    18.770   259.596     0.200
    19.033   263.744     0.200
    19.203   265.676     0.200
    19.443   267.383     0.200
     0.318     8.398     0.200
     1.074    18.125     0.200
     1.152    20.375     0.200
     1.184    20.148     0.200
     1.233    20.305     0.200
     1.199    21.297     0.200
     1.203    21.266     0.200
     1.222    21.398     0.200
     1.259    21.383     0.200
     1.245    22.016     0.200
     1.254    21.953     0.200
     1.363    22.844     0.200
     1.686    26.008     0.200
     1.829    29.453     0.200
     2.110    34.344     0.200
     2.552    39.836     0.200
     2.957    44.742     0.200
     2.991    48.195     0.200
     3.351    49.289     0.200
     3.501    51.805     0.200
     3.787    56.406     0.200
     4.071    60.289     0.200
     4.227    63.016     0.200
     4.330    63.453     0.200
     4.683    69.359     0.200
     5.004    74.164     0.200
     5.451    81.312     0.200
     1.195    19.836     0.200
     1.615    26.766     0.200
     1.745    29.316     0.200
     2.234    36.137     0.200
     2.459    38.129     0.200
     2.731    42.629     0.200
     2.904    46.418     0.200
     3.045    48.137     0.200
     3.586    54.066     0.200
     3.541    54.188     0.200
     3.590    57.059     0.200
     3.554    56.355     0.200
     3.928    59.648     0.200
     4.015    64.516     0.200
     4.803    74.398     0.200
    11.377   167.945     0.200
    19.340   265.066     0.200
    19.514   265.898     0.200
     0.849    16.018     0.200
     1.111    18.746     0.200
     1.333    22.418     0.200
     1.431    24.066     0.200
     1.350    24.047     0.200
     1.505    24.047     0.200
     1.474    25.277     0.200
     1.481    25.467     0.200
     1.481    25.646     0.200
     1.489    25.627     0.200
     1.507    25.877     0.200
     1.527    25.688     0.200
     1.673    26.287     0.200
     1.655    27.326     0.200
     1.693    27.688     0.200
     1.866    30.678     0.200
     2.000    32.637     0.200
     2.405    36.217     0.200
     2.517    38.326     0.200
     2.628    41.146     0.200
     2.636    41.547     0.200
     2.745    40.928     0.200
     3.030    46.807     0.200
     3.571    53.867     0.200
     0.470    12.602     0.200
     0.603    14.789     0.200
     0.617    15.312     0.200
     0.643    15.562     0.200
     0.655    15.578     0.200
     0.694    15.070     0.200
     0.730    15.078     0.200
     0.728    15.266     0.200
     0.712    15.641     0.200
     1.442    23.352     0.200
     1.780    28.398     0.200
     2.014    33.852     0.200
     2.170    34.117     0.200
     2.365    36.406     0.200
     2.389    37.008     0.200
     2.830    44.086     0.200
     2.917    45.227     0.200
     3.082    47.719     0.200
     3.419    51.547     0.200
     3.593    54.750     0.200
     3.591    54.500     0.200
     3.952    60.141     0.200
     4.366    66.992     0.200
     4.504    66.969     0.200
     4.659    69.945     0.200
     4.964    74.258     0.200
     5.287    79.008     0.200
     5.480    81.836     0.200
     5.818    86.461     0.200
     5.924    87.820     0.200
     1.550    24.703     0.200
     2.343    38.223     0.200
     2.813    42.143     0.200
     3.562    56.442     0.200
     3.915    60.652     0.200
     3.999    62.103     0.200
     4.137    62.173     0.200
     4.165    64.723     0.200
     4.800    72.053     0.200
     4.953    74.253     0.200
     0.433     9.213     0.200
     0.475     9.223     0.200
     1.180    19.623     0.200
     1.550    26.053     0.200
     1.885    30.203     0.200
     2.338    36.113     0.200
     2.542    39.073     0.200
     3.032    49.173     0.200
     3.170    48.873     0.200
     3.609    55.243     0.200
     3.508    55.423     0.200
     3.651    56.033     0.200
     3.957    58.523     0.200
     4.154    59.883     0.200
     4.100    62.993     0.200
     4.154    65.453     0.200
     4.218    64.953     0.200
     4.344    64.073     0.200
     4.360    68.123     0.200
     4.437    70.043     0.200
     4.724    69.693     0.200
     4.663    70.063     0.200
     4.755    71.643     0.200
     4.717    73.823     0.200
     4.787    73.793     0.200
     4.848    73.683     0.200
     4.968    75.183     0.200
     5.308    77.063     0.200
     5.629    83.723     0.200
     5.743    84.353     0.200
     5.783    86.013     0.200
     5.722    83.363     0.200
     5.927    86.203     0.200
     6.099    88.383     0.200
     6.291    91.933     0.200
     6.529    94.643     0.200
     7.532   108.283     0.200
     8.504   123.673     0.200
     9.155   130.983     0.200
     1.198    20.660     0.200
     1.337    23.360     0.200
     1.682    26.130     0.200
     1.846    28.210     0.200
     1.952    33.141     0.200
     2.071    32.521     0.200
     2.101    34.200     0.200
     2.443    40.830     0.200
     2.801    44.740     0.200
     2.837    43.880     0.200
     2.896    47.080     0.200
     2.831    44.610     0.200
     2.893    46.670     0.200
     3.289    51.851     0.200
     3.380    52.431     0.200
     3.697    57.070     0.200
     3.856    58.061     0.200
     3.911    59.650     0.200
     4.185    63.940     0.200
     4.507    67.990     0.200
     4.733    71.561     0.200
     5.091    75.880     0.200
     5.126    76.681     0.200
     0.267     7.945     0.200
     1.115    19.955     0.200
     1.120    20.014     0.200
     1.163    20.885     0.200
     1.166    20.145     0.200
     1.171    20.914     0.200
     1.384    24.324     0.200
     1.786    27.385     0.200
     1.730    29.184     0.200
     2.150    34.904     0.200
     2.640    41.184     0.200
     2.844    45.824     0.200
     3.057    45.404     0.200
     3.600    55.684     0.200
     3.865    59.904     0.200
     4.170    61.584     0.200
     4.267    66.484     0.200
     4.302    67.984     0.200
     4.773    70.904     0.200
     5.094    74.395     0.200
     5.188    75.754     0.200
     5.236    77.424     0.200
     5.547    81.115     0.200
     2.033    34.323     0.200
     2.195    35.844     0.200
     2.797    44.734     0.200
     2.805    45.874     0.200
     3.193    51.594     0.200
     3.459    52.823     0.200
     3.597    56.504     0.200
     3.718    56.724     0.200
     4.069    63.784     0.200
     4.116    65.734     0.200
     4.374    69.494     0.200
     4.522    69.154     0.200
     4.611    70.654     0.200
     4.753    74.254     0.200
     4.811    76.614     0.200
     4.965    76.823     0.200
     5.140    78.703     0.200
     5.140    79.754     0.200
     5.168    77.664     0.200
     5.169    77.344     0.200
     5.182    78.604     0.200
     5.234    81.014     0.200
     5.409    82.674     0.200
     6.058    88.724     0.200
     6.197    92.284     0.200
     6.244    96.943     0.200
     6.392    96.924     0.200
     6.547    97.344     0.200
     0.684    12.887     0.200
     0.807    13.996     0.200
     1.114    18.699     0.200
     1.319    21.816     0.200
     1.650    25.816     0.200
     1.726    28.348     0.200
     1.765    29.047     0.200
     1.778    28.977     0.200
     1.816    29.668     0.200
     2.080    32.598     0.200
     1.985    32.656     0.200
     2.385    35.879     0.200
     2.404    39.676     0.200
     2.390    38.988     0.200
     2.937    44.758     0.200
     2.890    46.688     0.200
     3.258    53.789     0.200
     3.373    54.746     0.200
     3.505    52.359     0.200
     3.804    58.027     0.200
     3.806    57.699     0.200
     3.784    58.906     0.200
     3.784    61.316     0.200
     3.819    60.699     0.200
     3.819    61.176     0.200
     3.872    58.469     0.200
     4.184    62.598     0.200
     0.305     8.395     0.200
     1.016    17.215     0.200
     1.090    19.135     0.200
     1.138    20.494     0.200
     1.197    20.494     0.200
     1.184    21.254     0.200
     1.194    21.215     0.200
     1.285    22.674     0.200
     1.353    22.494     0.200
     1.743    27.273     0.200
     1.773    27.523     0.200
     2.139    32.494     0.200
     2.113    34.625     0.200
     2.593    40.193     0.200
     2.798    46.764     0.200
     2.930    45.113     0.200
     3.013    43.965     0.200
     3.389    51.744     0.200
     3.562    53.494     0.200
     3.819    57.984     0.200
     4.126    61.404     0.200
     4.221    63.084     0.200
     4.256    63.443     0.200
     4.233    63.715     0.200
     4.312    63.484     0.200
     4.376    66.203     0.200
     4.726    70.555     0.200
     5.144    75.875     0.200
     5.189    77.174     0.200
     5.501    82.023     0.200
     5.718    85.814     0.200
     6.163    90.504     0.200
     1.910    32.354     0.200
     2.160    35.244     0.200
     2.715    43.863     0.200
     3.282    49.074     0.200
     3.224    52.904     0.200
     3.593    57.145     0.200
     3.603    56.793     0.200
     3.673    55.324     0.200
     3.682    59.104     0.200
     3.723    55.564     0.200
     3.992    63.273     0.200
     4.308    66.564     0.200
     4.402    67.463     0.200
     4.692    69.963     0.200
     1.246    22.539     0.200
     1.560    26.094     0.200
     1.998    34.109     0.200
     2.301    39.258     0.200
     2.353    39.508     0.200
     2.476    41.938     0.200
     2.814    46.742     0.200
     3.088    49.320     0.200
     3.048    48.797     0.200
     3.336    52.562     0.200
     3.908    60.477     0.200
     3.932    64.328     0.200
     3.993    60.031     0.200
     4.107    64.242     0.200
     4.142    63.727     0.200
     4.924    76.609     0.200
     5.422    85.250     0.200
     0.694    12.395     0.200
     0.858    15.755     0.200
     1.331    21.215     0.200
     1.173    19.725     0.200
     1.440    22.515     0.200
     1.531    24.225     0.200
     1.450    24.824     0.200
     1.486    25.175     0.200
     1.500    25.305     0.200
     1.556    25.765     0.200
     1.834    30.955     0.200
     2.159    33.435     0.200
     2.595    41.854     0.200
     2.558    41.404     0.200
     2.885    43.765     0.200
     2.959    47.425     0.200
     3.128    48.404     0.200
     3.315    52.715     0.200
     3.699    54.805     0.200
     3.594    56.585     0.200
     3.810    58.774     0.200
     3.810    59.614     0.200
     3.842    58.564     0.200
     3.848    61.335     0.200
     3.938    56.665     0.200
     3.959    59.364     0.200
     3.900    59.795     0.200
     4.384    64.665     0.200
     0.781    15.043     0.200
     1.268    21.543     0.200
     1.466    22.713     0.200
     2.074    34.023     0.200
     2.527    39.182     0.200
     2.873    45.113     0.200
     3.055    47.502     0.200
     3.318    52.072     0.200
     3.627    53.383     0.200
     3.761    59.143     0.200
     3.856    59.633     0.200
     3.880    59.463     0.200
     3.813    59.463     0.200
     4.205    63.582     0.200
     4.526    68.373     0.200
     4.670    71.342     0.200
     4.986    75.752     0.200
     5.200    78.043     0.200
     0.554    13.578     0.200
     0.919    16.852     0.200
     1.101    21.188     0.200
     1.354    21.391     0.200
     1.371    22.258     0.200
     1.521    25.703     0.200
     1.597    27.070     0.200
     1.606    27.430     0.200
     1.628    27.430     0.200
     1.719    28.711     0.200
     1.784    29.078     0.200
     1.855    29.219     0.200
     2.253    37.273     0.200
     2.481    36.992     0.200
     2.424    39.227     0.200
     2.464    39.812     0.200
     2.492    39.859     0.200
     2.568    39.258     0.200
     2.614    44.344     0.200
     2.860    44.781     0.200
     2.895    43.094     0.200
     2.828    44.914     0.200
     3.102    46.477     0.200
     3.218    51.531     0.200
     3.246    50.852     0.200
     3.246    51.031     0.200
     3.249    52.602     0.200
     3.311    51.320     0.200
     3.497    53.039     0.200
     3.558    54.711     0.200
     3.635    55.039     0.200
     3.843    58.789     0.200
     4.165    62.898     0.200
     4.381    66.648     0.200
     4.335    65.469     0.200
     4.406    66.922     0.200
     4.479    66.539     0.200
     4.735    71.227     0.200
     4.796    72.250     0.200
     4.989    71.789     0.200
     5.483    80.039     0.200
     1.517    24.465     0.200
     1.889    31.715     0.200
     2.035    31.715     0.200
     2.478    39.227     0.200
     2.957    46.184     0.200
     3.305    51.586     0.200
     3.759    58.945     0.200
     3.862    59.336     0.200
     3.746    58.684     0.200
     3.809    62.297     0.200
     4.026    65.625     0.200
     4.198    67.176     0.200
     4.637    72.715     0.200
     4.728    74.164     0.200
     5.084    76.297     0.200
     5.404    79.387     0.200
     5.530    83.094     0.200
     2.029    32.160     0.200
     1.915    30.311     0.200
     2.526    41.721     0.200
     2.526    42.460     0.200
     2.974    46.400     0.200
     2.855    48.391     0.200
     2.929    45.971     0.200
     3.297    50.590     0.200
     3.699    58.181     0.200
     3.686    57.181     0.200
     3.735    59.311     0.200
     3.857    59.160     0.200
     3.740    58.811     0.200
     3.798    61.150     0.200
     3.837    61.360     0.200
     3.812    59.431     0.200
     4.007    62.790     0.200
     4.058    64.400     0.200
     4.200    67.420     0.200
     4.195    67.790     0.200
     4.223    65.880     0.200
     4.217    67.370     0.200
     4.222    65.521     0.200
     4.229    66.490     0.200
     4.317    66.120     0.200
     4.330    69.280     0.200
     4.422    66.670     0.200
     4.388    68.721     0.200
     4.468    69.490     0.200
     4.527    71.160     0.200
     4.664    72.601     0.200
     4.731    71.400     0.200
     4.729    71.710     0.200
     4.547    71.280     0.200
     4.547    68.200     0.200
     4.689    70.750     0.200
     4.863    74.311     0.200
     5.097    76.440     0.200
     5.416    81.410     0.200
     5.444    80.750     0.200
     5.535    83.200     0.200
     5.833    87.800     0.200
     5.810    85.740     0.200
     5.772    84.990     0.200
     5.927    90.540     0.200
     6.082    88.880     0.200
     6.099    89.721     0.200
     6.241    92.740     0.200
     6.463    95.891     0.200
     6.413    94.240     0.200
     6.540    98.471     0.200
     6.960   105.101     0.200
     7.326   105.721     0.200
     7.569   110.101     0.200
     8.276   120.284     0.200
     8.848   130.221     0.200
     8.848   128.271     0.200
     9.991   143.860     0.200
    10.143   144.050     0.200
    11.013   158.050     0.200
    11.005   158.960     0.200
    11.005   160.965     0.200
    11.006   158.250     0.200
    11.396   163.340     0.200
    12.527   181.150     0.200
    12.597   181.021     0.200
    12.766   182.730     0.200
    13.039   186.750     0.200
    13.570   193.570     0.200
    13.741   195.630     0.200
    14.695   207.061     0.200
    14.831   209.570     0.200
    14.931   211.490     0.200
    15.034   211.971     0.200
    15.198   214.730     0.200
    15.282   216.181     0.200
    15.317   215.150     0.200
    15.445   220.090     0.200
    15.493   218.681     0.200
    15.568   219.330     0.200
    15.638   221.160     0.200
    15.850   222.780     0.200
    15.878   224.190     0.200
    15.902   225.380     0.200
    16.014   227.050     0.200
    16.062   225.940     0.200
    16.054   227.580     0.200
    16.917   235.971     0.200
    17.003   237.460     0.200
    17.016   238.200     0.200
    17.573   245.650     0.200
    17.769   247.601     0.200
    18.006   248.311     0.200
    18.100   251.601     0.200
    18.543   257.420     0.200
    19.190   266.009     0.200
     1.392    22.945     0.200
     2.034    34.828     0.200
     2.220    37.797     0.200
     2.575    41.195     0.200
     2.853    46.195     0.200
     2.853    46.477     0.200
     3.362    55.258     0.200
     3.475    54.586     0.200
     3.842    58.078     0.200
     3.759    59.008     0.200
     3.995    59.750     0.200
     4.162    67.602     0.200
     4.203    65.680     0.200
     4.401    67.656     0.200
     4.438    70.320     0.200
     4.442    67.008     0.200
     4.442    68.438     0.200
     4.442    67.586     0.200
     4.491    71.992     0.200
     4.635    68.852     0.200
     4.635    74.117     0.200
     4.640    74.000     0.200
     4.688    72.281     0.200
     4.741    71.266     0.200
     4.745    73.172     0.200
     4.772    75.172     0.200
     4.823    73.047     0.200
     4.967    75.438     0.200
     5.086    80.609     0.200
     5.047    77.445     0.200
     5.095    79.836     0.200
     5.114    80.305     0.200
     5.115    80.836     0.200
     5.115    79.625     0.200
     5.175    77.820     0.200
     5.254    79.141     0.200
     5.254    79.977     0.200
     5.231    76.398     0.200
     5.608    84.289     0.200
     5.929    89.289     0.200
     6.064    90.906     0.200
     6.272    94.742     0.200
     6.368    94.781     0.200
     6.398    94.531     0.200
     6.600    98.422     0.200
     6.624   100.836     0.200
     6.863   102.125     0.200
     7.007   103.141     0.200
     7.069   102.180     0.200
     7.268   105.469     0.200
     7.624   112.336     0.200
     7.836   115.641     0.200
     8.093   119.664     0.200
     8.522   125.039     0.200
     8.522   125.531     0.200
     8.522   125.750     0.200
     8.797   126.750     0.200
     8.797   129.039     0.200
     9.455   136.797     0.200
     9.603   140.539     0.200
    10.678   155.320     0.200
    10.777   154.695     0.200
    10.777   157.086     0.200
    10.777   154.570     0.200
    11.291   162.016     0.200
    11.539   166.078     0.200
    11.539   164.172     0.200
    11.789   171.336     0.200
    11.781   168.297     0.200
    11.882   172.305     0.200
    11.814   169.695     0.200
    12.253   175.148     0.200
    12.509   177.141     0.200
    12.626   178.391     0.200
    12.803   182.047     0.200
    12.821   181.836     0.200
    13.189   188.578     0.200
    13.189   186.711     0.200
    13.499   190.461     0.200
    13.598   193.695     0.200
    13.843   196.859     0.200
    14.370   205.125     0.200
    14.592   206.711     0.200
    14.623   207.102     0.200
    14.588   204.477     0.200
    14.665   206.609     0.200
    14.713   207.641     0.200
    14.783   206.406     0.200
    14.996   209.367     0.200
    15.037   211.078     0.200
    15.037   213.391     0.200
    15.814   222.906     0.200
    15.947   223.555     0.200
    16.513   230.609     0.200
    16.513   231.664     0.200
    16.654   231.461     0.200
    16.814   234.211     0.200
    17.702   245.836     0.200
    18.719   258.828     0.200
    18.719   260.992     0.200
     1.877    29.961     0.200
     1.927    31.262     0.200
     1.922    31.543     0.200
     1.874    29.312     0.200
     1.957    31.961     0.200
     1.971    32.062     0.200
     1.945    30.750     0.200
     2.023    32.340     0.200
     2.158    34.168     0.200
     2.552    41.238     0.200
     2.688    42.129     0.200
     2.794    44.418     0.200
     2.709    42.645     0.200
     2.828    46.293     0.200
     3.049    47.395     0.200
     2.997    45.715     0.200
     3.186    49.145     0.200
     3.241    49.590     0.200
     3.264    52.809     0.200
     3.265    51.004     0.200
     3.368    54.293     0.200
     3.276    49.949     0.200
     3.409    55.355     0.200
     3.550    55.441     0.200
     3.600    55.199     0.200
     3.609    55.020     0.200
     3.567    54.223     0.200
     3.621    55.020     0.200
     3.773    59.363     0.200
     3.968    60.402     0.200
     4.284    65.035     0.200
     4.297    64.488     0.200
     4.385    66.895     0.200
     4.712    69.473     0.200
     4.679    71.168     0.200
     4.879    73.168     0.200
     4.950    72.785     0.200
     4.981    74.691     0.200
     5.073    76.199     0.200
     5.316    79.301     0.200
     5.390    80.754     0.200
     5.832    85.043     0.200
     6.329    91.254     0.200
     7.132   103.934     0.200
     1.266    25.129     0.200
     1.274    24.898     0.200
     1.762    30.748     0.200
     3.033    50.969     0.200
     3.529    59.209     0.200
     3.697    61.248     0.200
     4.796    74.857     0.200
     5.116    79.988     0.200
     1.681    29.338     0.200
     2.306    38.549     0.200
     2.268    38.350     0.200
     2.554    41.189     0.200
     2.928    48.488     0.200
     3.062    50.238     0.200
     3.190    51.428     0.200
     3.519    52.379     0.200
     3.692    60.139     0.200
     3.794    58.818     0.200
     4.032    59.578     0.200
     4.043    62.469     0.200
     4.240    67.238     0.200
     4.465    70.148     0.200
     4.605    67.939     0.200
     4.758    74.428     0.200
     5.384    82.209     0.200
     5.579    84.189     0.200
     5.918    91.678     0.200
     6.019    89.939     0.200
     1.204    21.656     0.200
     1.694    29.430     0.200
     1.792    29.469     0.200
     1.813    32.180     0.200
     2.009    32.289     0.200
     2.371    38.773     0.200
     2.450    39.094     0.200
     2.550    40.484     0.200
     2.621    42.414     0.200
     2.648    44.414     0.200
     2.754    45.688     0.200
     2.809    41.906     0.200
     2.866    47.625     0.200
     3.004    48.516     0.200
     3.038    49.875     0.200
     3.120    48.227     0.200
     3.063    48.594     0.200
     3.065    49.094     0.200
     3.072    48.789     0.200
     3.142    49.062     0.200
     3.092    51.914     0.200
     3.089    50.234     0.200
     3.192    47.344     0.200
     3.235    49.875     0.200
     3.236    49.688     0.200
     3.337    52.945     0.200
     3.387    53.734     0.200
     3.407    52.727     0.200
     3.406    50.695     0.200
     3.381    52.094     0.200
     3.461    55.484     0.200
     3.601    55.109     0.200
     3.786    57.328     0.200
     3.928    61.016     0.200
     4.103    63.312     0.200
     4.210    64.297     0.200
     4.326    67.867     0.200
     4.509    69.305     0.200
     4.529    70.555     0.200
     4.736    70.523     0.200
     4.799    72.867     0.200
     4.776    72.430     0.200
     4.923    75.703     0.200
     5.158    77.805     0.200
     5.216    78.844     0.200
     5.202    81.430     0.200
     5.646    81.688     0.200
     6.014    88.406     0.200
     6.168    91.680     0.200
     6.955   103.055     0.200
     7.265   106.625     0.200
     7.624   111.586     0.200
     7.618   115.898     0.200
     7.732   117.312     0.200
     9.900   143.656     0.200
     9.929   144.117     0.200
    10.023   145.273     0.200
    11.344   163.875     0.200
    11.565   167.078     0.200
     0.883    14.785     0.200
     1.175    18.525     0.200
     1.108    19.655     0.200
     1.618    26.096     0.200
     1.595    26.375     0.200
     1.582    26.146     0.200
     1.585    26.335     0.200
     1.615    27.065     0.200
     1.632    26.965     0.200
     1.707    28.176     0.200
     1.707    29.306     0.200
     1.969    30.455     0.200
     2.429    39.255     0.200
     2.696    44.965     0.200
     2.732    42.965     0.200
     2.954    44.115     0.200
     2.836    45.995     0.200
     3.070    48.815     0.200
     3.218    50.646     0.200
     3.751    57.146     0.200
     4.100    64.255     0.200
     4.564    68.926     0.200
     0.600    11.250     0.200
     0.880    16.602     0.200
     0.881    16.281     0.200
     0.917    17.414     0.200
     0.931    17.500     0.200
     0.997    17.992     0.200
     1.885    30.164     0.200
     1.882    33.305     0.200
     3.136    48.812     0.200
     3.186    50.453     0.200
     3.332    52.148     0.200
     3.330    53.133     0.200
     3.349    51.680     0.200
     3.208    47.836     0.200
     3.518    57.812     0.200
     4.124    62.102     0.200
     4.157    61.398     0.200
     4.225    60.961     0.200
     4.397    67.555     0.200
     4.443    65.781     0.200
     4.714    71.695     0.200
     1.113    19.635     0.200
     1.653    26.965     0.200
     2.232    35.074     0.200
     2.467    40.123     0.200
     2.712    43.953     0.200
     2.920    45.984     0.200
     2.954    45.664     0.200
     3.202    50.494     0.200
     3.260    52.184     0.200
     3.244    48.975     0.200
     3.456    55.703     0.200
     3.507    56.475     0.200
     3.498    54.885     0.200
     3.578    57.885     0.200
     3.642    59.014     0.200
     3.651    59.664     0.200
     3.653    58.055     0.200
     3.670    58.215     0.200
     3.685    58.613     0.200
     3.694    57.373     0.200
     4.026    60.904     0.200
     4.112    65.494     0.200
     4.115    65.734     0.200
     4.097    64.283     0.200
     4.258    65.555     0.200
     4.283    65.895     0.200
     4.269    64.584     0.200
     4.602    70.334     0.200
     4.923    74.994     0.200
     5.042    75.453     0.200
     5.073    77.184     0.200
     5.291    79.104     0.200
     5.389    81.584     0.200
     5.591    84.604     0.200
     6.061    90.154     0.200
     6.075    90.645     0.200
     6.828   101.744     0.200
     7.796   114.184     0.200
     8.449   122.514     0.200
     1.550    26.584     0.200
     1.495    27.014     0.200
     2.009    34.414     0.200
     2.213    37.953     0.200
     2.599    44.184     0.200
     2.913    49.123     0.200
     2.882    47.652     0.200
     3.048    49.764     0.200
     3.151    48.973     0.200
     3.092    51.463     0.200
     4.039    62.453     0.200
     4.070    64.094     0.200
     4.150    65.893     0.200
     4.590    73.193     0.200
     4.858    77.834     0.200
     2.204    36.293     0.200
     2.587    42.603     0.200
     2.753    44.373     0.200
     3.209    50.883     0.200
     3.621    56.553     0.200
     4.002    60.373     0.200
     4.341    67.053     0.200
     4.319    64.863     0.200
     4.424    66.943     0.200
     4.720    72.393     0.200
     1.345    23.980     0.200
     2.163    35.191     0.200
     2.482    41.340     0.200
     2.525    40.328     0.200
     2.578    42.000     0.200
     2.742    44.969     0.200
     2.802    46.262     0.200
     2.861    47.398     0.200
     2.920    47.551     0.200
     3.024    47.090     0.200
     3.050    47.840     0.200
     3.157    51.398     0.200
     3.515    54.371     0.200
     3.643    53.922     0.200
     4.057    64.352     0.200
     4.169    64.121     0.200
     4.831    70.879     0.200
     4.875    76.160     0.200
     5.051    76.102     0.200
     5.186    81.551     0.200
     5.842    85.852     0.200
     7.473   110.621     0.200
     9.890   146.996     0.200
     0.282     7.230     0.200
     0.918    16.023     0.200
     0.996    17.844     0.200
     1.102    19.094     0.200
     1.099    19.910     0.200
     1.107    19.891     0.200
     1.382    23.172     0.200
     1.370    23.453     0.200
     1.841    28.961     0.200
     2.044    31.902     0.200
     2.040    31.660     0.200
     2.109    31.512     0.200
     2.148    35.742     0.200
     3.111    45.551     0.200
     3.410    50.594     0.200
     3.382    50.293     0.200
     3.362    53.082     0.200
     3.470    54.043     0.200
     3.499    56.703     0.200
     3.521    54.012     0.200
     3.657    55.652     0.200
     3.708    58.410     0.200
     3.892    58.992     0.200
     4.222    62.652     0.200
     4.292    65.891     0.200
     4.292    66.113     0.200
     4.279    64.594     0.200
     4.277    63.191     0.200
     4.327    66.094     0.200
     4.466    66.672     0.200
     4.439    65.461     0.200
     4.489    67.633     0.200
     4.812    69.461     0.200
     5.133    76.531     0.200
     5.240    77.352     0.200
     5.280    79.242     0.200
    10.789   156.656     0.200
     0.051    11.745     0.200
     0.209    12.845     0.200
     0.232    12.885     0.200
     0.521    13.515     0.200
     1.145    20.565     0.200
     1.231    21.425     0.200
     1.734    28.795     0.200
     2.465    39.845     0.200
     2.890    43.805     0.200
     2.862    45.976     0.200
     3.494    53.115     0.200
     4.137    61.525     0.200
     4.228    62.235     0.200
     4.266    63.805     0.200
     4.540    67.455     0.200
     4.643    68.295     0.200
     4.908    73.775     0.200
     4.908    76.476     0.200
     4.944    73.825     0.200
     4.955    74.905     0.200
     5.215    76.665     0.200
     5.332    79.476     0.200
     5.401    80.226     0.200
     5.612    83.005     0.200
     5.935    87.625     0.200
     6.155    90.955     0.200
     6.217    90.825     0.200
     6.504    95.865     0.200
     6.548    96.105     0.200
     7.229   105.135     0.200
     0.242     7.844     0.200
     0.866    15.535     0.200
     0.966    17.363     0.200
     1.070    18.895     0.200
     1.081    19.785     0.200
     1.088    19.684     0.200
     1.438    22.965     0.200
     1.421    23.715     0.200
     1.894    28.965     0.200
     1.988    30.562     0.200
     2.204    35.172     0.200
     2.819    43.074     0.200
     2.865    44.863     0.200
     3.165    47.883     0.200
     3.533    55.664     0.200
     3.708    55.973     0.200
     3.955    59.543     0.200
     4.278    63.434     0.200
     4.291    65.164     0.200
     4.339    66.234     0.200
     4.390    66.375     0.200
     4.527    68.535     0.200
     4.537    69.734     0.200
     4.874    71.734     0.200
     5.195    76.895     0.200
     5.296    77.523     0.200
     5.340    79.223     0.200
     5.563    82.742     0.200
     5.653    84.285     0.200
     5.864    87.254     0.200
     5.917    87.023     0.200
     1.047    19.859     0.200
     1.142    21.119     0.200
     1.198    22.988     0.200
     1.625    29.080     0.200
     1.962    33.279     0.200
     2.401    40.939     0.200
     2.865    45.260     0.200
     2.909    46.539     0.200
     3.019    50.500     0.200
     3.583    55.059     0.200
     3.666    58.250     0.200
     3.775    58.148     0.200
     4.106    64.340     0.200
     4.342    65.479     0.200
     4.466    68.020     0.200
     4.527    71.000     0.200
     4.546    69.488     0.200
     4.992    75.619     0.200
     5.312    80.100     0.200
     5.439    81.068     0.200
     5.699    84.180     0.200
     5.991    89.809     0.200
     6.382    93.680     0.200
     7.221   104.430     0.200
     8.176   119.164     0.200
    10.944   160.094     0.200
     1.664    27.586     0.200
     1.957    32.953     0.200
     1.965    32.734     0.200
     2.893    45.453     0.200
     3.235    48.953     0.200
     3.608    56.766     0.200
     3.695    57.984     0.200
     3.792    58.086     0.200
     4.138    65.414     0.200
     4.498    70.844     0.200
     4.564    71.754     0.200
     4.660    70.773     0.200
     4.654    72.824     0.200
     5.338    78.695     0.200
     1.393    23.627     0.200
     1.411    23.258     0.200
     1.515    26.438     0.200
     1.617    26.758     0.200
     1.549    27.438     0.200
     1.621    28.057     0.200
     2.136    34.787     0.200
     2.215    37.877     0.200
     2.215    38.037     0.200
     2.472    40.838     0.200
     2.508    39.037     0.200
     2.573    43.348     0.200
     2.679    41.627     0.200
     2.834    49.047     0.200
     2.929    45.986     0.200
     2.980    47.918     0.200
     3.095    49.928     0.200
     3.047    49.736     0.200
     3.240    50.467     0.200
     3.217    49.367     0.200
     3.260    50.688     0.200
     3.324    52.236     0.200
     3.328    54.248     0.200
     3.430    53.877     0.200
     3.524    55.447     0.200
     3.570    56.908     0.200
     3.695    58.137     0.200
     3.703    58.537     0.200
     3.716    57.777     0.200
     3.716    61.316     0.200
     3.719    59.008     0.200
     3.719    57.207     0.200
     3.718    58.588     0.200
     3.719    59.598     0.200
     3.729    61.986     0.200
     3.804    57.637     0.200
     3.749    59.396     0.200
     3.768    57.998     0.200
     3.805    61.697     0.200
     3.830    60.008     0.200
     3.840    61.598     0.200
     3.870    59.658     0.200
     3.896    63.307     0.200
     3.947    61.986     0.200
     4.121    62.447     0.200
     4.111    61.986     0.200
     4.128    63.277     0.200
     4.128    62.607     0.200
     4.145    64.877     0.200
     4.146    64.877     0.200
     4.232    64.977     0.200
     4.253    66.217     0.200
     4.253    66.217     0.200
     4.673    70.736     0.200
     4.693    71.828     0.200
     4.693    72.527     0.200
     4.693    72.777     0.200
     4.827    73.457     0.200
     4.930    74.486     0.200
     5.220    77.947     0.200
     5.246    78.328     0.200
     5.415    82.328     0.200
     5.439    84.447     0.200
     5.521    82.697     0.200
     5.845    86.527     0.200
     5.935    89.258     0.200
     5.935    89.258     0.200
     6.091    90.066     0.200
     6.067    91.018     0.200
     6.327    94.467     0.200
     6.738    98.668     0.200
     7.504   111.297     0.200
     7.677   112.566     0.200
     7.677   111.578     0.200
     7.677   113.637     0.200
     8.571   127.938     0.200
     8.571   124.646     0.200
     9.202   135.018     0.200
     9.202   132.768     0.200
     9.202   135.566     0.200
     9.763   139.777     0.200
     9.853   143.027     0.200
    10.607   154.688     0.200
    10.638   154.688     0.200
    10.730   156.188     0.200
    10.702   154.008     0.200
    11.227   162.197     0.200
    11.227   158.646     0.200
    11.289   162.047     0.200
    11.289   160.248     0.200
    11.245   163.297     0.200
    11.245   162.168     0.200
    11.246   161.018     0.200
    11.860   168.688     0.200
    11.877   169.797     0.200
    12.277   177.947     0.200
    12.279   177.588     0.200
    12.674   181.877     0.200
    12.815   181.617     0.200
    12.809   183.678     0.200
    12.902   183.098     0.200
    13.102   187.566     0.200
    13.180   186.697     0.200
    13.473   193.598     0.200
    13.462   189.387     0.200
    13.462   194.078     0.200
    13.629   191.777     0.200
    13.626   192.797     0.200
    13.768   196.377     0.200
    13.855   196.777     0.200
    13.957   196.867     0.200
    15.883   224.158     0.200
    15.883   224.297     0.200
    17.005   238.098     0.200
    18.999   265.141     0.200
    18.999   262.787     0.200
    19.701   269.967     0.200
     1.656    30.160     0.200
     1.451    26.932     0.200
     1.502    27.830     0.200
     1.963    34.670     0.200
     2.558    44.721     0.200
     2.785    47.660     0.200
     3.366    53.871     0.200
     3.481    58.320     0.200
     4.021    66.951     0.200
     4.040    62.301     0.200
     4.127    66.951     0.200
     1.107    20.938     0.200
     1.512    25.566     0.200
     2.041    31.418     0.200
     2.485    40.836     0.200
     2.964    46.066     0.200
     3.310    52.539     0.200
     3.682    58.066     0.200
     3.709    57.449     0.200
     3.765    59.996     0.200
     3.750    58.898     0.200
     3.816    58.879     0.200
     3.868    60.547     0.200
     4.148    63.688     0.200
     4.205    65.797     0.200
     4.219    64.199     0.200
     4.307    65.199     0.200
     4.434    68.559     0.200
     1.412    24.119     0.200
     1.823    29.168     0.200
     3.089    47.509     0.200
     3.651    53.859     0.200
     3.857    60.559     0.200
     3.862    61.009     0.200
     4.057    62.179     0.200
     4.215    62.259     0.200
     4.493    72.309     0.200
     4.533    68.119     0.200
     4.613    72.579     0.200
     4.816    70.369     0.200
     4.907    72.289     0.200
     5.237    78.039     0.200
     5.226    78.188     0.200
     5.630    84.239     0.200
     5.913    91.109     0.200
     6.201    92.389     0.200
     0.799    15.207     0.200
     1.010    17.047     0.200
     1.289    21.355     0.200
     1.513    25.914     0.200
     1.475    25.734     0.200
     1.641    26.855     0.200
     1.913    31.316     0.200
     2.367    37.297     0.200
     2.503    38.445     0.200
     2.665    41.734     0.200
     2.714    42.516     0.200
     2.695    42.234     0.200
     3.000    45.695     0.200
     2.967    46.254     0.200
     3.057    46.555     0.200
     3.107    47.766     0.200
     3.573    53.727     0.200
     3.535    55.414     0.200
     3.536    57.285     0.200
     3.537    54.664     0.200
     3.541    57.656     0.200
     3.729    58.004     0.200
     3.776    57.777     0.200
     4.051    61.555     0.200
     4.374    65.887     0.200
     4.576    67.887     0.200
     4.549    68.785     0.200
     4.882    73.496     0.200
     5.030    74.766     0.200
     0.580    11.922     0.200
     1.346    21.922     0.200
     1.584    24.422     0.200
     1.694    28.570     0.200
     1.702    27.633     0.200
     2.229    35.133     0.200
     2.366    37.758     0.200
     2.610    38.359     0.200
     3.008    47.492     0.200
     3.061    48.562     0.200
     3.177    49.922     0.200
     3.174    49.281     0.200
     3.241    51.703     0.200
     3.296    53.211     0.200
     3.503    54.484     0.200
     3.605    58.484     0.200
     3.679    58.984     0.200
     3.698    58.109     0.200
     3.726    57.734     0.200
     3.737    55.953     0.200
     3.804    59.484     0.200
     3.819    58.883     0.200
     3.974    60.234     0.200
     4.075    64.211     0.200
     4.074    60.117     0.200
     4.098    62.812     0.200
     4.103    65.398     0.200
     4.109    62.969     0.200
     4.117    63.070     0.200
     4.216    65.938     0.200
     4.461    66.211     0.200
     4.755    71.109     0.200
     4.759    69.984     0.200
     4.777    69.805     0.200
     4.872    72.898     0.200
     5.159    76.180     0.200
     5.203    75.211     0.200
     5.397    81.289     0.200
     5.475    81.969     0.200
     5.778    83.852     0.200
     5.862    84.789     0.200
     6.094    88.828     0.200
    11.313   164.609     0.200
     1.719    28.152     0.200
     1.640    27.523     0.200
     1.933    30.805     0.200
     2.012    32.535     0.200
     2.484    40.305     0.200
     2.452    39.543     0.200
     2.556    42.965     0.200
     2.890    46.004     0.200
     3.005    48.395     0.200
     3.174    49.895     0.200
     3.838    57.762     0.200
     3.761    57.125     0.200
     4.136    62.602     0.200
     4.326    63.844     0.200
     4.581    70.773     0.200
     4.599    68.184     0.200
     4.639    68.582     0.200
     5.010    74.762     0.200
     5.328    79.113     0.200
     5.444    82.062     0.200
     5.728    86.664     0.200
     6.014    89.625     0.200
     6.449    97.441     0.200
     8.186   117.434     0.200
     8.186   117.594     0.200
    11.056   161.512     0.200
     0.250     7.684     0.200
     1.118    19.605     0.200
     1.121    20.426     0.200
     1.383    22.895     0.200
     1.400    23.496     0.200
     1.676    26.645     0.200
     1.839    28.766     0.200
     2.043    31.645     0.200
     2.176    35.664     0.200
     2.176    35.297     0.200
     2.479    40.477     0.200
     2.688    41.824     0.200
     2.895    44.996     0.200
     2.854    44.676     0.200
     3.110    46.523     0.200
     3.419    53.016     0.200
     3.403    53.047     0.200
     3.398    52.816     0.200
     3.483    52.523     0.200
     3.517    56.625     0.200
     3.553    54.055     0.200
     3.653    53.707     0.200
     3.677    57.773     0.200
     3.839    59.707     0.200
     3.862    61.984     0.200
     3.873    60.547     0.200
     3.874    58.566     0.200
     3.874    60.547     0.200
     3.874    62.844     0.200
     3.882    57.516     0.200
     3.984    60.066     0.200
     4.004    64.836     0.200
     4.059    62.574     0.200
     4.223    62.855     0.200
     4.305    64.434     0.200
     4.308    64.227     0.200
     4.308    65.055     0.200
     4.345    66.605     0.200
     4.351    65.637     0.200
     4.436    67.816     0.200
     4.474    67.684     0.200
     4.474    67.145     0.200
     4.822    71.977     0.200
     5.143    76.434     0.200
     5.241    77.023     0.200
     5.287    78.895     0.200
     5.514    79.387     0.200
     5.599    82.867     0.200
     5.589    80.074     0.200
     5.813    86.504     0.200
     5.905    86.625     0.200
     6.261    91.676     0.200
     6.290    92.707     0.200
     6.851   101.754     0.200
     7.049   102.457     0.200
     7.269   103.836     0.200
     7.259   105.105     0.200
     8.014   115.891     0.200
     8.014   114.754     0.200
     8.694   126.926     0.200
     8.728   124.707     0.200
     8.728   129.238     0.200
    10.757   155.945     0.200
    10.818   155.820     0.200
    10.818   154.145     0.200
    10.818   154.305     0.200
    11.467   162.434     0.200
    12.678   180.836     0.200
    12.814   180.816     0.200
    12.854   181.184     0.200
    13.233   185.973     0.200
    13.316   187.816     0.200
    13.316   190.270     0.200
    13.301   186.785     0.200
    14.165   195.871     0.200
    15.297   213.227     0.200
    16.396   227.523     0.200
    16.450   227.656     0.200
    18.369   251.125     0.200
    18.465   253.105     0.200
    19.198   262.625     0.200
    19.198   263.043     0.200
    19.241   262.797     0.200
     0.977    17.395     0.200
     1.440    22.703     0.200
     1.530    24.555     0.200
     1.988    30.664     0.200
     2.051    33.824     0.200
     2.237    35.762     0.200
     2.237    35.613     0.200
     2.296    37.805     0.200
     2.818    43.664     0.200
     2.863    45.191     0.200
     3.259    49.203     0.200
     3.480    54.441     0.200
     3.503    54.984     0.200
     3.496    51.434     0.200
     3.555    55.074     0.200
     3.608    55.734     0.200
     3.627    56.145     0.200
     3.778    58.633     0.200
     3.800    56.672     0.200
     3.831    59.102     0.200
     3.933    60.102     0.200
     3.975    58.422     0.200
     3.978    59.844     0.200
     4.083    62.383     0.200
     4.090    63.363     0.200
     4.162    64.344     0.200
     4.184    64.133     0.200
     4.240    63.453     0.200
     4.240    64.402     0.200
     4.371    64.555     0.200
     4.380    64.812     0.200
     4.379    64.812     0.200
     4.421    65.555     0.200
     4.443    67.242     0.200
     4.449    68.824     0.200
     4.450    66.043     0.200
     4.451    65.832     0.200
     4.451    67.844     0.200
     4.454    68.082     0.200
     4.455    68.082     0.200
     4.612    69.465     0.200
     4.612    69.984     0.200
     4.638    70.133     0.200
     4.954    74.012     0.200
     5.276    78.594     0.200
     5.388    79.184     0.200
     5.426    80.984     0.200
     5.623    84.062     0.200
     5.637    83.934     0.200
     5.742    85.352     0.200
     5.916    88.152     0.200
     6.200    89.793     0.200
     6.429    95.043     0.200
     6.429    95.043     0.200
     6.732   103.004     0.200
     7.241   106.742     0.200
     7.415   106.922     0.200
     8.149   120.348     0.200
    10.230   144.312     0.200
    10.354   146.031     0.200
    10.727   155.195     0.200
    10.727   152.055     0.200
    10.727   151.723     0.200
    10.894   154.102     0.200
    11.391   161.492     0.200
    12.281   177.465     0.200
    12.265   177.473     0.200
    12.302   177.613     0.200
    12.731   183.734     0.200
    12.762   183.793     0.200
    13.094   185.672     0.200
    13.094   186.273     0.200
    13.213   189.281     0.200
    13.251   189.465     0.200
    13.438   192.234     0.200
    13.613   193.023     0.200
    13.725   195.812     0.200
    14.273   200.852     0.200
    14.532   205.953     0.200
    14.879   210.215     0.200
    14.974   211.043     0.200
    15.191   214.434     0.200
    15.247   213.453     0.200
    15.280   213.441     0.200
    15.351   215.184     0.200
    15.630   217.805     0.200
    15.657   218.332     0.200
    15.746   218.992     0.200
    15.948   222.672     0.200
    16.319   226.844     0.200
    16.555   229.203     0.200
    16.554   229.543     0.200
    16.555   229.781     0.200
    16.555   229.441     0.200
    16.557   229.453     0.200
    17.707   244.973     0.200
    18.120   248.664     0.200
    18.135   249.082     0.200
    18.151   248.793     0.200
    18.511   253.922     0.200
    18.535   254.273     0.200
     0.488    10.352     0.200
     0.970    18.242     0.200
     1.201    22.141     0.200
     1.714    29.832     0.200
     1.714    29.449     0.200
     1.811    29.961     0.200
     2.006    32.730     0.200
     2.226    35.500     0.200
     2.522    40.500     0.200
     2.618    41.430     0.200
     2.656    42.879     0.200
     2.570    42.129     0.200
     2.661    42.891     0.200
     2.715    43.301     0.200
     2.755    43.312     0.200
     2.746    43.449     0.200
     2.918    46.281     0.200
     2.964    47.969     0.200
     3.095    49.020     0.200
     3.112    49.312     0.200
     3.112    49.180     0.200
     3.113    48.520     0.200
     3.119    49.121     0.200
     3.221    50.691     0.200
     3.235    50.711     0.200
     3.268    50.930     0.200
     3.289    51.520     0.200
     3.327    51.020     0.200
     3.307    53.672     0.200
     3.399    53.961     0.200
     3.513    54.402     0.200
     3.521    54.879     0.200
     3.526    55.141     0.200
     3.539    54.980     0.200
     3.531    55.160     0.200
     3.536    55.289     0.200
     3.538    55.289     0.200
     3.571    55.520     0.200
     3.571    55.699     0.200
     3.533    56.070     0.200
     3.631    55.922     0.200
     3.673    56.062     0.200
     3.673    56.062     0.200
     3.700    57.000     0.200
     3.725    58.230     0.200
     3.932    60.461     0.200
     3.957    57.641     0.200
     4.342    65.430     0.200
     4.382    67.012     0.200
     4.529    69.520     0.200
     4.529    69.156     0.200
     4.650    70.480     0.200
     4.934    74.230     0.200
     5.361    80.129     0.200
     5.386    81.371     0.200
     5.386    81.371     0.200
     5.615    83.402     0.200
     6.366    94.090     0.200
     7.115   103.586     0.200
     7.115   104.191     0.200
     7.127   104.090     0.200
     7.383   113.359     0.200
     7.570   111.312     0.200
     8.830   127.152     0.200
     9.000   130.801     0.200
     9.222   135.242     0.200
     9.397   135.180     0.200
     9.856   141.129     0.200
    10.086   146.781     0.200
    10.113   147.660     0.200
    11.040   158.281     0.200
    11.133   158.289     0.200
    11.133   161.062     0.200
    11.133   160.832     0.200
    11.246   161.129     0.200
    11.574   164.930     0.200
    11.670   166.160     0.200
    11.677   167.539     0.200
    12.401   175.109     0.200
    12.438   175.480     0.200
    12.681   179.441     0.200
    12.749   181.949     0.200
    13.351   184.633     0.200
    13.351   187.730     0.200
    13.351   187.031     0.200
    13.333   188.742     0.200
    13.384   191.289     0.200
    13.370   189.371     0.200
    13.538   192.191     0.200
    13.667   194.992     0.200
    13.699   195.301     0.200
    13.709   194.469     0.200
    13.745   196.051     0.200
    13.880   197.281     0.200
    13.973   200.301     0.200
    14.044   201.441     0.200
    14.055   201.371     0.200
    14.126   200.621     0.200
    14.950   212.160     0.200
    15.843   223.070     0.200
    16.906   234.590     0.200
    17.068   236.910     0.200
    17.390   238.750     0.200
    17.409   239.770     0.200
    17.524   241.160     0.200
    17.842   244.922     0.200
    17.870   246.090     0.200
    18.366   255.102     0.200
    18.648   256.941     0.200
    19.029   261.230     0.200
    19.376   265.812     0.200
    19.604   267.891     0.200
    19.643   268.562     0.200
    19.732   269.281     0.200
    19.915   271.562     0.200
    19.915   272.785     0.200
    19.981   272.441     0.200
    20.181   274.500     0.200
     0.870    17.686     0.200
     1.145    21.057     0.200
     1.136    21.576     0.200
     1.154    21.637     0.200
     1.256    22.236     0.200
     1.651    26.137     0.200
     1.635    26.727     0.200
     1.635    28.686     0.200
     1.989    30.955     0.200
     1.989    31.146     0.200
     1.907    30.896     0.200
     2.332    36.615     0.200
     2.283    36.215     0.200
     2.350    38.066     0.200
     2.589    41.656     0.200
     2.657    40.576     0.200
     2.672    41.266     0.200
     2.842    43.965     0.200
     2.882    43.285     0.200
     2.869    45.605     0.200
     2.899    45.695     0.200
     3.042    46.955     0.200
     3.037    48.236     0.200
     3.053    47.416     0.200
     3.176    49.715     0.200
     3.189    49.525     0.200
     3.229    50.646     0.200
     3.324    52.205     0.200
     3.385    51.195     0.200
     3.356    52.236     0.200
     3.372    49.605     0.200
     3.372    51.727     0.200
     3.372    53.727     0.200
     3.372    52.865     0.200
     3.379    52.506     0.200
     3.419    53.205     0.200
     3.438    53.105     0.200
     3.478    54.025     0.200
     3.482    53.875     0.200
     3.512    54.137     0.200
     3.561    54.336     0.200
     3.573    54.736     0.200
     3.770    57.965     0.200
     3.770    57.965     0.200
     3.831    59.336     0.200
     3.834    58.826     0.200
     3.860    59.676     0.200
     3.861    59.646     0.200
     3.863    58.727     0.200
     3.862    59.715     0.200
     3.861    58.896     0.200
     3.863    58.896     0.200
     3.957    58.705     0.200
     3.973    60.336     0.200
     3.973    59.865     0.200
     4.049    61.166     0.200
     4.052    61.266     0.200
     4.108    60.705     0.200
     4.108    62.195     0.200
     4.742    71.236     0.200
     4.928    73.576     0.200
     4.881    73.605     0.200
     4.961    73.086     0.200
     5.013    74.996     0.200
     5.071    76.016     0.200
     5.265    78.486     0.200
     5.388    80.256     0.200
     5.392    79.955     0.200
     5.603    81.666     0.200
     5.924    88.066     0.200
     5.924    88.066     0.200
     5.975    87.646     0.200
     6.636    96.637     0.200
     6.717    99.977     0.200
     6.789    99.646     0.200
     6.968   101.557     0.200
     7.183   102.785     0.200
     7.155   105.186     0.200
     7.293   106.715     0.200
     7.623   110.070     0.200
     7.623   110.416     0.200
     8.568   125.615     0.200
     8.849   129.268     0.200
     9.043   127.586     0.200
     9.126   131.766     0.200
     9.335   133.926     0.200
     9.556   137.896     0.200
     9.570   139.125     0.200
     9.972   141.406     0.200
    10.374   145.176     0.200
    10.546   150.578     0.200
    10.546   148.865     0.200
    10.547   148.307     0.200
    10.651   153.176     0.200
    10.675   153.756     0.200
    10.656   148.705     0.200
    10.773   154.086     0.200
    10.766   150.795     0.200
    11.140   156.096     0.200
    11.147   156.375     0.200
    11.243   157.396     0.200
    11.243   160.445     0.200
    11.358   163.346     0.200
    11.310   158.006     0.200
    11.943   168.016     0.200
    12.103   170.615     0.200
    12.095   169.506     0.200
    12.136   170.137     0.200
    12.221   170.766     0.200
    12.221   174.328     0.200
    12.175   169.896     0.200
    12.356   174.375     0.200
    12.755   178.316     0.200
    12.755   179.246     0.200
    13.092   185.826     0.200
    13.674   189.070     0.200
    16.447   226.711     0.200
    16.447   227.795     0.200
    17.336   237.355     0.200
    19.057   259.375     0.200
    19.224   260.771     0.200
    20.366   272.756     0.200
     1.559    27.828     0.200
     1.593    27.586     0.200
     1.546    27.875     0.200
     2.049    34.906     0.200
     2.226    38.211     0.200
     2.459    39.109     0.200
     2.581    42.766     0.200
     2.885    48.477     0.200
     2.999    50.680     0.200
     3.139    51.492     0.200
     3.193    51.695     0.200
     3.121    51.289     0.200
     3.263    53.820     0.200
     3.515    58.008     0.200
     3.536    58.719     0.200
     4.048    64.516     0.200
     4.092    64.148     0.200
     2.691    43.859     0.200
     2.751    43.477     0.200
     2.819    43.070     0.200
     2.947    47.848     0.200
     3.058    47.469     0.200
     3.090    50.457     0.200
     3.104    50.129     0.200
     3.410    54.898     0.200
     3.429    54.328     0.200
     3.431    54.777     0.200
     3.442    54.637     0.200
     3.447    55.250     0.200
     3.463    55.418     0.200
     3.505    56.559     0.200
     4.057    62.078     0.200
     4.523    68.129     0.200
     4.806    74.457     0.200
     5.189    78.398     0.200
     1.224    21.023     0.200
     1.479    25.602     0.200
     2.095    35.000     0.200
     2.095    35.766     0.200
     2.216    35.898     0.200
     2.307    36.430     0.200
     2.494    39.133     0.200
     2.677    41.625     0.200
     2.901    47.898     0.200
     3.026    47.680     0.200
     3.051    47.539     0.200
     3.116    50.133     0.200
     3.510    54.703     0.200
     3.466    53.984     0.200
     3.543    54.523     0.200
     3.543    56.578     0.200
     3.617    55.766     0.200
     3.934    60.031     0.200
     3.934    61.000     0.200
     3.962    62.352     0.200
     3.963    62.352     0.200
     4.098    65.023     0.200
     4.316    66.148     0.200
     4.638    69.648     0.200
     4.633    70.766     0.200
     4.736    72.211     0.200
     4.700    72.070     0.200
     5.028    76.719     0.200
     5.658    84.711     0.200
     5.741    86.609     0.200
     5.741    86.609     0.200
     6.210    90.961     0.200
     6.544    96.922     0.200
     7.409   111.391     0.200
     7.440   109.430     0.200
     7.843   116.414     0.200
     9.338   135.180     0.200
     9.271   136.930     0.200
     9.271   134.914     0.200
     9.337   135.391     0.200
     9.704   140.141     0.200
     9.845   145.016     0.200
    10.215   146.094     0.200
    10.215   147.359     0.200
    10.598   153.039     0.200
    11.274   162.211     0.200
    11.274   163.273     0.200
    11.479   164.562     0.200
    11.842   169.445     0.200
    11.866   169.984     0.200
    11.975   171.078     0.200
    12.306   176.609     0.200
    12.649   179.742     0.200
    12.751   180.859     0.200
    12.831   183.883     0.200
    12.859   183.195     0.200
    13.237   189.500     0.200
    13.770   193.344     0.200
    13.781   196.805     0.200
    13.814   196.750     0.200
    13.885   197.648     0.200
    14.101   200.750     0.200
    14.125   201.500     0.200
    15.634   220.898     0.200
    15.980   225.781     0.200
    17.127   237.930     0.200
    17.168   239.688     0.200
    17.868   246.398     0.200
    17.994   247.930     0.200
    18.015   247.133     0.200
    18.128   249.734     0.200
    18.141   249.266     0.200
    18.194   255.203     0.200
    18.905   261.062     0.200
    19.769   270.625     0.200
    19.827   271.375     0.200
    20.189   276.070     0.200
     1.291    22.602     0.200
     2.387    38.234     0.200
     2.496    39.664     0.200
     2.732    44.773     0.200
     2.989    49.266     0.200
     3.475    53.555     0.200
     3.561    55.398     0.200
     3.505    54.219     0.200
     4.350    65.547     0.200
     4.529    69.984     0.200
     4.563    69.203     0.200
     4.864    73.656     0.200
     5.003    77.984     0.200
     1.749    29.250     0.200
     1.621    28.938     0.200
     1.991    31.000     0.200
     2.213    35.070     0.200
     2.470    39.133     0.200
     2.598    42.039     0.200
     2.552    40.609     0.200
     2.732    42.648     0.200
     2.955    47.039     0.200
     2.881    48.461     0.200
     3.013    47.547     0.200
     3.033    49.727     0.200
     3.304    50.703     0.200
     3.422    54.391     0.200
     3.439    55.398     0.200
     3.446    54.609     0.200
     3.450    54.391     0.200
     3.455    54.328     0.200
     3.461    54.797     0.200
     3.627    54.562     0.200
     3.583    55.258     0.200
     3.656    57.008     0.200
     4.197    64.141     0.200
     4.316    64.922     0.200
     4.338    66.414     0.200
     4.585    66.859     0.200
     4.654    70.867     0.200
     4.874    73.578     0.200
     5.334    79.578     0.200
     5.341    80.320     0.200
     6.104    89.188     0.200
     6.336    92.820     0.200
     7.065   102.812     0.200
     8.959   129.453     0.200
    11.069   160.242     0.200
     1.567    27.797     0.200
     2.018    35.146     0.200
     2.179    37.746     0.200
     2.473    42.537     0.200
     2.835    48.127     0.200
     3.081    50.516     0.200
     3.089    51.287     0.200
     3.149    52.807     0.200
     3.279    53.377     0.200
     3.468    55.326     0.200
     3.478    55.326     0.200
     3.483    55.887     0.200
     3.492    56.916     0.200
     4.000    64.586     0.200
     4.047    63.756     0.200
     4.115    65.646     0.200
     4.223    68.096     0.200
     4.542    71.355     0.200
     4.589    72.996     0.200
     4.817    74.977     0.200
     5.001    78.756     0.200
     5.120    80.566     0.200
     5.781    88.105     0.200
     5.987    88.416     0.200
     5.980    90.287     0.200
     6.240    97.816     0.200
     1.528    28.027     0.200
     1.968    34.668     0.200
     2.149    37.727     0.200
     2.526    41.945     0.200
     2.610    44.828     0.200
     2.814    48.277     0.200
     2.918    47.695     0.200
     3.039    47.797     0.200
     3.078    49.457     0.200
     3.162    52.656     0.200
     3.332    54.598     0.200
     3.454    57.125     0.200
     3.459    57.348     0.200
     3.460    58.207     0.200
     4.010    65.258     0.200
     4.085    64.457     0.200
     4.202    66.785     0.200
     4.522    70.258     0.200
     4.629    71.547     0.200
     4.751    72.836     0.200
     4.791    73.926     0.200
     4.967    77.016     0.200
     5.105    79.316     0.200
     6.028    91.375     0.200
     6.289   100.555     0.200
     7.391   112.102     0.200
     9.940   146.855     0.200
     2.393    36.982     0.200
     2.427    39.193     0.200
     2.626    40.713     0.200
     2.782    43.973     0.200
     2.908    44.172     0.200
     3.481    53.322     0.200
     3.572    57.092     0.200
     3.684    55.684     0.200
     3.715    58.383     0.200
     4.026    60.312     0.200
     1.246    22.053     0.200
     1.389    25.582     0.200
     1.488    25.773     0.200
     1.525    27.293     0.200
     1.642    27.143     0.200
     1.671    28.693     0.200
     1.939    31.193     0.200
     2.311    38.203     0.200
     2.382    40.283     0.200
     2.644    42.613     0.200
     2.830    46.582     0.200
     2.905    46.643     0.200
     3.160    49.354     0.200
     3.249    51.383     0.200
     3.334    52.672     0.200
     3.453    54.973     0.200
     3.470    54.543     0.200
     3.926    61.172     0.200
     3.934    64.832     0.200
     3.940    59.092     0.200
     3.962    64.773     0.200
     4.024    64.582     0.200
     4.032    60.922     0.200
     4.060    62.303     0.200
     4.086    64.354     0.200
     4.357    67.582     0.200
     4.360    68.912     0.200
     4.365    70.242     0.200
     4.367    65.012     0.200
     4.367    67.412     0.200
     4.376    68.342     0.200
     4.447    68.252     0.200
     4.453    69.502     0.200
     4.704    70.242     0.200
     4.704    71.873     0.200
     4.749    72.293     0.200
     7.915   115.768     0.200
    11.224   163.398     0.200
    11.225   158.752     0.200
    11.531   163.883     0.200
    11.934   169.582     0.200
    12.259   175.773     0.200
    12.774   180.193     0.200
    13.678   191.713     0.200
    13.900   195.963     0.200
    14.115   198.832     0.200
    14.190   200.367     0.200
    15.304   215.373     0.200
    15.429   217.402     0.200
    15.657   219.803     0.200
    17.858   246.342     0.200
     1.186    20.867     0.200
     1.956    32.945     0.200
     2.435    38.508     0.200
     2.687    43.195     0.200
     2.754    44.496     0.200
     2.731    42.656     0.200
     2.956    43.996     0.200
     3.046    50.117     0.200
     3.198    50.938     0.200
     3.529    54.285     0.200
     3.604    57.508     0.200
     3.625    57.738     0.200
     3.630    55.828     0.200
     3.633    57.438     0.200
     3.636    56.906     0.200
     3.641    58.027     0.200
     3.743    58.656     0.200
     3.771    58.988     0.200
     4.089    63.246     0.200
     4.410    67.945     0.200
     4.541    68.668     0.200
     4.558    70.105     0.200
     4.877    74.566     0.200
     5.082    77.336     0.200
     5.558    83.258     0.200
     0.849    15.750     0.200
     1.211    20.600     0.200
     1.722    29.830     0.200
     1.722    29.590     0.200
     2.005    32.369     0.200
     2.335    36.350     0.200
     2.466    38.270     0.200
     2.694    41.650     0.200
     2.598    40.900     0.200
     2.733    42.449     0.200
     2.805    43.529     0.200
     2.784    42.000     0.200
     2.834    45.139     0.200
     2.868    45.539     0.200
     2.992    45.850     0.200
     3.025    48.910     0.200
     3.052    48.350     0.200
     3.100    48.920     0.200
     3.238    49.969     0.200
     3.251    49.910     0.200
     3.237    50.949     0.200
     3.243    49.969     0.200
     3.248    51.590     0.200
     3.248    51.260     0.200
     3.248    50.660     0.200
     3.268    51.189     0.200
     3.303    48.789     0.200
     3.269    50.539     0.200
     3.274    49.969     0.200
     3.283    50.629     0.200
     3.331    51.299     0.200
     3.366    50.629     0.200
     3.429    54.619     0.200
     3.564    54.100     0.200
     3.513    55.949     0.200
     3.559    55.350     0.200
     3.581    54.670     0.200
     3.657    56.369     0.200
     3.657    56.729     0.200
     3.678    56.820     0.200
     3.683    55.090     0.200
     3.689    55.639     0.200
     3.693    57.059     0.200
     3.695    57.059     0.200
     3.788    59.059     0.200
     3.788    58.299     0.200
     3.813    58.869     0.200
     3.758    55.969     0.200
     3.757    55.969     0.200
     3.866    59.180     0.200
     4.137    62.969     0.200
     4.198    64.080     0.200
     4.378    65.600     0.200
     4.378    65.760     0.200
     4.378    66.229     0.200
     4.457    67.590     0.200
     4.577    68.469     0.200
     4.602    69.289     0.200
     4.837    71.449     0.200
     4.919    73.949     0.200
     4.940    71.900     0.200
     5.131    77.029     0.200
     5.596    79.930     0.200
     5.605    82.359     0.200
     5.605    82.359     0.200
     5.594    82.070     0.200
     5.868    85.869     0.200
     6.364    92.809     0.200
     6.599    96.660     0.200
     7.066   103.359     0.200
     7.327   107.184     0.200
     7.327   106.900     0.200
     7.479   107.789     0.200
     7.983   115.129     0.200
     8.675   127.660     0.200
     8.675   128.400     0.200
     9.042   129.910     0.200
     9.024   130.070     0.200
     9.024   132.590     0.200
     9.224   132.359     0.200
     9.331   132.990     0.200
    10.071   141.209     0.200
    10.970   158.490     0.200
    12.671   181.850     0.200
    13.011   184.279     0.200
    13.515   189.783     0.200
    13.515   189.910     0.200
    13.532   192.029     0.200
    15.334   216.119     0.200
    15.404   215.229     0.200
    15.538   216.850     0.200
    15.612   217.309     0.200
    15.719   217.209     0.200
    15.779   220.479     0.200
    15.779   221.570     0.200
    15.743   218.889     0.200
    16.257   225.170     0.200
    16.399   229.020     0.200
    16.452   228.000     0.200
    16.462   228.109     0.200
    16.627   230.229     0.200
    16.627   231.270     0.200
    16.682   230.629     0.200
    16.784   232.100     0.200
    16.960   233.990     0.200
    17.069   235.570     0.200
    17.168   235.719     0.200
    17.948   244.990     0.200
    19.506   265.350     0.200
    19.593   265.930     0.200
    19.685   268.410     0.200
    19.874   269.279     0.200
     2.100    34.625     0.200
     2.624    43.035     0.200
     2.702    43.674     0.200
     3.372    55.265     0.200
     3.372    55.435     0.200
     3.396    55.665     0.200
     3.401    56.435     0.200
     3.406    55.435     0.200
     3.573    57.564     0.200
     0.458    10.145     0.200
     1.133    19.566     0.200
     1.285    22.367     0.200
     1.302    22.285     0.200
     1.370    24.004     0.200
     1.394    23.637     0.200
     1.527    24.977     0.200
     2.017    32.777     0.200
     2.017    33.754     0.200
     2.017    33.645     0.200
     2.354    35.676     0.200
     2.395    38.434     0.200
     2.582    40.355     0.200
     2.798    42.957     0.200
     2.795    43.484     0.200
     3.118    50.395     0.200
     3.106    47.285     0.200
     3.160    48.324     0.200
     3.196    49.277     0.200
     3.255    50.984     0.200
     3.340    50.664     0.200
     3.480    52.977     0.200
     3.620    55.637     0.200
     3.620    54.305     0.200
     3.624    56.965     0.200
     3.627    58.645     0.200
     3.627    56.375     0.200
     3.627    55.137     0.200
     3.643    54.305     0.200
     3.646    55.637     0.200
     3.652    57.625     0.200
     3.626    55.035     0.200
     3.664    58.297     0.200
     3.742    55.637     0.200
     4.045    61.617     0.200
     4.045    63.605     0.200
     4.067    61.617     0.200
     4.071    62.945     0.200
     4.074    62.285     0.200
     4.077    63.605     0.200
     4.169    63.805     0.200
     4.169    63.344     0.200
     4.105    61.977     0.200
     4.185    63.344     0.200
     4.255    64.277     0.200
     4.403    66.164     0.200
     4.403    65.254     0.200
     4.403    66.555     0.200
     4.438    64.617     0.200
     4.524    68.074     0.200
     4.845    72.727     0.200
     4.929    72.977     0.200
     4.980    74.617     0.200
     5.229    74.824     0.200
     5.289    78.996     0.200
     5.259    77.227     0.200
     5.521    81.555     0.200
     5.829    84.375     0.200
     5.984    88.594     0.200
     6.753    97.145     0.200
     6.957   100.227     0.200
     7.057   103.945     0.200
     7.241   104.164     0.200
     7.608   110.254     0.200
     7.712   112.023     0.200
     7.712   111.734     0.200
     8.371   120.324     0.200
     8.383   124.207     0.200
     8.383   124.055     0.200
     8.923   130.734     0.200
     8.923   129.715     0.200
     8.923   131.457     0.200
     9.426   134.586     0.200
     9.496   133.355     0.200
     9.598   139.727     0.200
    10.340   146.035     0.200
    10.453   151.316     0.200
    10.453   148.016     0.200
    10.424   146.285     0.200
    10.956   154.691     0.200
    10.956   156.336     0.200
    10.956   156.684     0.200
    10.956   159.457     0.200
    11.989   169.867     0.200
    12.391   174.867     0.200
    12.528   178.426     0.200
    12.614   178.855     0.200
    12.932   183.387     0.200
    13.205   184.945     0.200
    13.481   191.504     0.200
    13.481   191.266     0.200
    13.595   191.484     0.200
    13.601   191.656     0.200
    13.810   196.074     0.200
    13.903   194.875     0.200
    13.903   194.074     0.200
    14.432   202.465     0.200
    14.798   208.234     0.200
    15.284   212.785     0.200
    15.848   220.035     0.200
    15.913   220.234     0.200
    16.280   227.484     0.200
    16.385   226.457     0.200
    16.443   227.535     0.200
    16.794   232.074     0.200
    16.833   233.098     0.200
    16.833   233.406     0.200
    17.026   234.684     0.200
    17.141   235.625     0.200
    17.160   236.785     0.200
    17.261   237.824     0.200
    17.444   239.996     0.200
    17.524   240.465     0.200
    17.560   240.484     0.200
    17.762   242.797     0.200
    17.818   243.586     0.200
    17.897   244.957     0.200
    18.212   250.914     0.200
    19.106   261.523     0.200
    19.108   260.945     0.200
    19.427   264.977     0.200
    19.466   264.398     0.200
     0.953    16.979     0.200
     0.805    16.229     0.200
     1.288    22.089     0.200
     1.414    23.448     0.200
     1.408    23.898     0.200
     1.406    24.438     0.200
     1.519    25.208     0.200
     1.486    26.139     0.200
     2.019    32.639     0.200
     2.254    34.158     0.200
     2.598    38.889     0.200
     2.628    40.328     0.200
     2.673    44.238     0.200
     2.777    43.398     0.200
     2.841    44.599     0.200
     2.795    43.818     0.200
     2.796    45.219     0.200
     2.999    48.238     0.200
     3.124    47.799     0.200
     3.146    50.028     0.200
     3.278    52.358     0.200
     3.331    53.589     0.200
     4.157    63.188     0.200
     4.480    67.879     0.200
     4.663    70.578     0.200
     4.698    69.858     0.200
     4.817    71.688     0.200
     4.999    75.188     0.200
     5.659    84.879     0.200
     7.360   106.792     0.200
    10.659   151.748     0.200
    16.584   229.042     0.200
     1.120    20.217     0.200
     1.212    20.137     0.200
     1.510    25.437     0.200
     1.653    27.656     0.200
     1.765    29.257     0.200
     1.794    29.637     0.200
     1.979    31.727     0.200
     2.384    37.267     0.200
     2.406    36.816     0.200
     2.692    43.847     0.200
     2.697    41.986     0.200
     2.784    43.127     0.200
     2.802    45.826     0.200
     2.871    46.137     0.200
     2.918    45.246     0.200
     2.873    45.406     0.200
     3.124    49.396     0.200
     3.113    48.576     0.200
     3.247    51.146     0.200
     3.414    53.036     0.200
     3.489    52.486     0.200
     3.656    56.457     0.200
     3.656    57.786     0.200
     3.673    58.457     0.200
     3.680    56.457     0.200
     3.689    57.786     0.200
     3.698    56.757     0.200
     3.741    57.337     0.200
     3.756    57.236     0.200
     3.861    61.776     0.200
     4.101    62.406     0.200
     4.421    67.066     0.200
     4.506    67.746     0.200
     4.552    69.187     0.200
     4.861    73.767     0.200
     5.103    75.677     0.200
     5.556    83.047     0.200
    11.090   158.002     0.200
     1.204    22.077     0.200
     1.303    23.007     0.200
     1.784    28.517     0.200
     1.766    28.357     0.200
     2.732    42.777     0.200
     2.645    43.857     0.200
     3.053    47.887     0.200
     3.065    50.157     0.200
     3.518    57.557     0.200
     3.609    56.237     0.200
     3.992    63.407     0.200
     4.177    62.437     0.200
     4.231    66.197     0.200
     4.398    70.187     0.200
     4.424    68.857     0.200
     4.430    71.517     0.200
     4.484    68.787     0.200
     5.171    77.507     0.200
     5.288    79.547     0.200
     5.570    82.607     0.200
     5.585    84.347     0.200
     5.603    81.817     0.200
     5.856    87.717     0.200
     8.029   118.091     0.200
    11.062   161.272     0.200
     1.057    17.980     0.200
     1.059    19.320     0.200
     1.596    26.004     0.200
     1.590    27.863     0.200
     1.797    29.633     0.200
     1.841    29.551     0.200
     2.291    35.422     0.200
     2.529    37.621     0.200
     2.527    39.953     0.200
     2.596    41.320     0.200
     2.588    41.363     0.200
     2.805    43.094     0.200
     2.885    42.602     0.200
     2.902    47.262     0.200
     3.045    46.434     0.200
     3.184    49.844     0.200
     3.378    50.934     0.200
     3.430    51.762     0.200
     3.452    55.902     0.200
     3.472    54.242     0.200
     3.481    53.910     0.200
     3.485    55.863     0.200
     3.929    58.980     0.200
     4.250    64.852     0.200
     4.388    65.652     0.200
     4.399    67.051     0.200
     4.719    71.480     0.200
     4.923    72.461     0.200
     1.968    33.102     0.200
     1.957    33.219     0.200
     2.898    47.000     0.200
     2.929    47.320     0.200
     3.701    58.609     0.200
     3.795    59.180     0.200
     3.765    59.391     0.200
     4.145    65.297     0.200
     4.361    67.406     0.200
     4.506    70.305     0.200
     4.585    70.484     0.200
     4.572    70.547     0.200
     4.663    73.406     0.200
     4.659    71.008     0.200
     5.023    76.172     0.200
     5.466    81.336     0.200
     5.766    86.695     0.200
     6.024    89.297     0.200
     1.834    31.422     0.200
     1.706    30.344     0.200
     2.077    35.492     0.200
     2.346    38.203     0.200
     2.578    43.273     0.200
     2.762    44.145     0.200
     2.895    48.184     0.200
     3.051    49.691     0.200
     2.998    47.984     0.200
     3.104    49.113     0.200
     3.660    57.133     0.200
     3.751    59.441     0.200
     3.995    65.262     0.200
     3.997    62.832     0.200
     3.997    64.352     0.200
     4.013    62.965     0.200
     4.227    63.852     0.200
     4.458    69.254     0.200
     4.459    69.254     0.200
     4.455    72.094     0.200
     4.503    69.562     0.200
     4.503    68.305     0.200
     4.503    66.293     0.200
     4.503    71.465     0.200
     4.503    69.844     0.200
     4.521    68.863     0.200
     4.521    71.172     0.200
     4.521    69.117     0.200
     4.628    72.172     0.200
     4.717    73.875     0.200
     4.886    74.164     0.200
     5.206    79.012     0.200
     5.248    78.383     0.200
     5.248    79.062     0.200
     5.598    85.852     0.200
     5.598    84.164     0.200
     5.705    85.262     0.200
     5.705    84.812     0.200
     5.887    87.953     0.200
     6.100    92.215     0.200
     6.203    93.922     0.200
     6.267    93.625     0.200
     6.334    94.422     0.200
     6.333    94.422     0.200
     6.343    96.363     0.200
     7.006   106.344     0.200
     7.281   108.395     0.200
     7.461   110.762     0.200
     7.461   111.344     0.200
     7.289   105.992     0.200
     7.324   106.473     0.200
     7.787   116.645     0.200
     8.067   117.707     0.200
     8.067   118.332     0.200
     8.067   116.426     0.200
     8.146   122.762     0.200
     8.146   122.465     0.200
     8.146   120.102     0.200
     8.146   120.852     0.200
     8.888   131.965     0.200
     8.888   131.004     0.200
     8.888   131.594     0.200
     9.782   143.465     0.200
     9.782   140.980     0.200
    10.487   153.262     0.200
    10.597   151.754     0.200
    10.806   155.352     0.200
    10.806   156.695     0.200
    10.806   156.914     0.200
    11.001   160.895     0.200
    11.001   158.863     0.200
    11.001   160.414     0.200
    11.020   160.262     0.200
    11.198   161.180     0.200
    11.462   162.008     0.200
    11.659   169.312     0.200
    11.762   170.664     0.200
    11.819   169.770     0.200
    11.964   173.305     0.200
    12.141   172.203     0.200
    12.141   172.809     0.200
    12.291   179.660     0.200
    12.219   176.324     0.200
    12.446   181.742     0.200
    12.535   180.785     0.200
    12.541   180.543     0.200
    12.575   181.895     0.200
    12.724   183.223     0.200
    12.792   183.672     0.200
    12.792   184.590     0.200
    12.956   185.125     0.200
    12.997   187.023     0.200
    13.002   186.672     0.200
    13.036   187.582     0.200
    13.008   183.562     0.200
    13.169   187.727     0.200
    13.300   191.633     0.200
    13.363   192.012     0.200
    13.369   191.895     0.200
    13.434   190.062     0.200
    13.434   189.672     0.200
    13.434   188.805     0.200
    13.461   191.484     0.200
    13.489   191.852     0.200
    14.613   207.613     0.200
    15.523   220.152     0.200
    15.523   219.285     0.200
    15.523   220.363     0.200
    15.915   224.922     0.200
    15.906   223.234     0.200
    16.011   222.742     0.200
    16.142   226.715     0.200
    16.112   226.672     0.200
    16.118   226.434     0.200
    16.220   226.352     0.200
    16.860   234.453     0.200
    16.833   234.855     0.200
    16.833   235.535     0.200
    16.833   236.062     0.200
    16.798   235.234     0.200
    16.964   236.914     0.200
    16.964   235.562     0.200
    17.505   243.562     0.200
    17.645   244.625     0.200
    17.857   247.242     0.200
    18.050   247.734     0.200
    18.738   263.395     0.200
    18.825   264.219     0.200
    18.844   265.629     0.200
    18.843   263.277     0.200
    18.843   266.332     0.200
    18.847   266.449     0.200
    18.880   266.684     0.200
    19.015   263.395     0.200
    19.039   264.805     0.200
    19.050   265.863     0.200
    19.058   266.801     0.200
    19.077   265.039     0.200
    19.100   267.152     0.200
    19.111   268.211     0.200
    19.202   266.098     0.200
    19.224   267.625     0.200
    19.291   268.914     0.200
    19.320   267.387     0.200
    19.330   267.387     0.200
    19.332   267.387     0.200
    19.303   266.523     0.200
    19.303   267.062     0.200
    19.422   268.562     0.200
    19.423   267.324     0.200
    19.423   267.859     0.200
    19.522   271.734     0.200
    19.559   269.621     0.200
    19.588   270.324     0.200
    19.598   271.027     0.200
    19.680   270.910     0.200
    19.751   273.496     0.200
    19.805   272.363     0.200
    19.868   273.379     0.200
    19.931   273.023     0.200
    19.958   274.434     0.200
    19.958   274.316     0.200
    19.968   274.434     0.200
    20.054   274.434     0.200
    20.065   278.426     0.200
    20.101   277.605     0.200
    20.109   278.426     0.200
    20.186   277.016     0.200
    20.237   280.539     0.200
    20.274   279.836     0.200
    20.291   277.840     0.200
    20.320   280.422     0.200
    20.338   280.539     0.200
    20.367   280.305     0.200
    20.374   278.660     0.200
    20.383   279.953     0.200
    20.393   280.492     0.200
    20.433   279.480     0.200
    20.440   281.246     0.200
    20.504   281.223     0.200
    20.504   279.953     0.200
    20.523   284.531     0.200
    20.537   280.305     0.200
    20.584   282.184     0.200
    20.596   282.418     0.200
    20.598   281.008     0.200
    20.598   280.656     0.200
    20.600   281.598     0.200
    20.711   282.301     0.200
     1.944    32.922     0.200
     2.675    43.664     0.200
     2.756    45.844     0.200
     2.756    45.477     0.200
     3.308    53.695     0.200
     3.330    52.406     0.200
     3.685    56.156     0.200
     3.771    61.656     0.200
     4.012    62.953     0.200
     4.039    64.945     0.200
     4.244    66.727     0.200
     4.366    69.695     0.200
     4.471    70.047     0.200
     4.471    66.789     0.200
     4.471    69.445     0.200
     4.471    69.719     0.200
     4.468    72.727     0.200
     4.497    73.156     0.200
     4.511    72.547     0.200
     4.511    67.656     0.200
     4.511    72.812     0.200
     4.511    73.094     0.200
     4.514    72.789     0.200
     4.535    72.688     0.200
     4.554    73.477     0.200
     4.619    73.547     0.200
     4.626    74.242     0.200
     4.718    73.906     0.200
     4.772    73.797     0.200
     4.809    73.273     0.200
     4.847    75.703     0.200
     4.907    77.797     0.200
     4.954    77.812     0.200
     4.981    77.398     0.200
     4.982    78.734     0.200
     4.984    77.898     0.200
     4.987    78.844     0.200
     4.993    77.797     0.200
     4.988    78.844     0.200
     5.103    75.633     0.200
     5.103    76.719     0.200
     5.111    77.133     0.200
     5.170    80.398     0.200
     5.461    82.523     0.200
     5.782    87.023     0.200
     5.831    87.578     0.200
     5.912    88.578     0.200
     6.159    94.328     0.200
     6.214    94.172     0.200
     6.353    94.898     0.200
     6.456    96.914     0.200
     6.722   103.172     0.200
     6.850   100.344     0.200
     6.917   103.938     0.200
     6.917   103.938     0.200
     7.629   116.984     0.200
     7.629   116.844     0.200
     8.618   128.945     0.200
     8.618   128.734     0.200
     8.648   125.461     0.200
    10.845   158.820     0.200
    10.845   158.336     0.200
    10.846   158.305     0.200
    11.388   164.344     0.200
    11.388   166.758     0.200
    11.738   172.234     0.200
    11.738   171.891     0.200
    11.883   172.523     0.200
    13.273   192.344     0.200
    13.273   191.133     0.200
    13.522   194.898     0.200
    13.586   192.242     0.200
    13.586   193.945     0.200
    13.586   195.148     0.200
    13.639   193.102     0.200
    15.157   213.195     0.200
    15.157   215.547     0.200
    15.328   215.734     0.200
    15.388   215.516     0.200
    15.495   217.758     0.200
    15.644   219.133     0.200
    16.491   229.477     0.200
    16.602   233.648     0.200
    16.847   235.414     0.200
    16.847   235.719     0.200
    16.847   234.219     0.200
    18.315   253.352     0.200
    18.506   258.438     0.200
    18.857   263.102     0.200
    18.857   262.867     0.200
    18.857   263.344     0.200
    19.140   265.047     0.200
    19.320   267.078     0.200
    19.374   268.664     0.200
    19.427   274.125     0.200
    19.452   269.898     0.200
    19.607   269.547     0.200
    19.624   270.773     0.200
    19.683   271.484     0.200
    19.915   274.477     0.200
    20.005   275.148     0.200
    20.005   277.742     0.200
    20.080   278.172     0.200
    20.225   275.805     0.200
    20.262   277.992     0.200
     1.123    19.967     0.200
     1.380    23.957     0.200
     1.742    28.287     0.200
     1.826    29.808     0.200
     2.391    39.678     0.200
     2.718    43.417     0.200
     2.718    45.048     0.200
     3.008    45.407     0.200
     3.136    49.758     0.200
     3.570    54.867     0.200
     4.134    62.747     0.200
     4.415    67.897     0.200
     4.422    67.897     0.200
     4.451    66.907     0.200
     4.455    68.037     0.200
     4.603    71.027     0.200
     4.831    73.327     0.200
     8.003   116.852     0.200
    11.141   159.189     0.200
     1.165    20.895     0.200
     1.324    24.104     0.200
     1.423    24.755     0.200
     1.689    27.785     0.200
     1.645    29.195     0.200
     1.879    33.275     0.200
     2.672    43.155     0.200
     2.765    45.635     0.200
     3.185    50.745     0.200
     3.518    55.545     0.200
     3.480    55.705     0.200
     3.891    62.635     0.200
     3.947    62.135     0.200
     4.400    66.525     0.200
     4.373    66.985     0.200
     4.405    67.965     0.200
     4.380    68.555     0.200
     4.384    68.025     0.200
     4.388    67.905     0.200
     4.394    71.635     0.200
     4.561    69.564     0.200
     4.652    72.705     0.200
     4.783    72.945     0.200
     7.953   116.764     0.200
    11.167   163.295     0.200
     1.869    29.272     0.200
     2.778    43.702     0.200
     2.942    46.812     0.200
     3.017    47.183     0.200
     3.140    49.212     0.200
     3.693    55.172     0.200
     3.702    58.322     0.200
     4.261    65.883     0.200
     4.424    70.572     0.200
     4.447    70.572     0.200
     4.451    70.572     0.200
     4.453    70.452     0.200
     4.455    70.922     0.200
     4.635    71.022     0.200
     1.105    19.613     0.200
     1.364    23.574     0.200
     1.717    27.404     0.200
     1.834    31.135     0.200
     2.206    37.664     0.200
     2.336    39.205     0.200
     2.336    38.725     0.200
     2.677    42.184     0.200
     2.709    44.404     0.200
     2.985    45.885     0.200
     3.082    50.654     0.200
     3.123    49.033     0.200
     3.483    54.943     0.200
     3.476    56.215     0.200
     3.545    55.564     0.200
     3.830    60.135     0.200
     3.926    62.854     0.200
     3.943    60.404     0.200
     3.941    61.475     0.200
     3.961    62.854     0.200
     3.967    64.184     0.200
     3.977    64.844     0.200
     4.110    60.604     0.200
     4.193    63.514     0.200
     4.388    67.314     0.200
     4.421    67.225     0.200
     4.421    66.795     0.200
     4.428    68.674     0.200
     4.590    69.604     0.200
     4.590    70.324     0.200
     4.590    70.645     0.200
     4.738    71.574     0.200
     4.793    72.084     0.200
     5.112    76.863     0.200
     5.131    76.375     0.200
     5.225    78.584     0.200
     5.515    82.334     0.200
     5.580    84.455     0.200
     5.799    86.145     0.200
     6.151    88.395     0.200
     6.126    91.193     0.200
     6.230    92.244     0.200
     7.166   106.045     0.200
     7.509   109.904     0.200
     7.850   115.273     0.200
     9.005   134.443     0.200
     9.683   141.484     0.200
    10.562   149.965     0.200
    10.704   153.895     0.200
    10.704   154.273     0.200
    11.103   158.283     0.200
    11.103   162.344     0.200
    11.103   161.619     0.200
    11.103   158.465     0.200
    11.109   164.045     0.200
    11.694   166.324     0.200
    11.750   167.504     0.200
    12.020   170.533     0.200
    12.138   172.424     0.200
    12.611   179.395     0.200
    12.650   179.914     0.200
    12.810   183.965     0.200
    13.098   185.404     0.200
    13.479   191.434     0.200
    13.574   192.375     0.200
    13.784   195.193     0.200
    14.087   199.184     0.200
    14.250   200.975     0.200
    14.718   207.885     0.200
    14.877   209.564     0.200
    15.200   214.854     0.200
    15.272   215.965     0.200
    15.267   214.795     0.200
    15.317   216.443     0.200
    15.543   218.314     0.200
    15.719   220.844     0.200
    15.816   222.074     0.200
    15.983   224.045     0.200
    16.020   223.914     0.200
    16.072   224.934     0.200
    16.187   227.045     0.200
    16.890   235.875     0.200
    16.937   235.734     0.200
    16.924   235.225     0.200
    17.022   237.193     0.200
    17.046   236.613     0.200
    17.376   241.273     0.200
    17.371   240.854     0.200
    18.016   249.684     0.200
    19.435   267.514     0.200
    20.385   279.484     0.200
    20.518   279.244     0.200
     1.386    23.584     0.200
     1.758    28.654     0.200
     1.834    31.943     0.200
     2.196    35.084     0.200
     2.340    40.045     0.200
     2.629    44.203     0.200
     2.825    45.404     0.200
     3.130    49.244     0.200
     3.257    50.443     0.200
     3.464    53.055     0.200
     3.800    59.984     0.200
     3.864    60.914     0.200
     3.870    61.594     0.200
     3.932    61.094     0.200
     3.911    60.725     0.200
     4.307    67.754     0.200
     4.330    67.885     0.200
     4.338    67.305     0.200
     4.339    68.123     0.200
     4.342    67.494     0.200
     4.341    68.283     0.200
     4.341    68.545     0.200
     4.341    68.094     0.200
     4.350    68.305     0.200
     4.358    68.545     0.200
     4.366    67.434     0.200
     4.366    68.404     0.200
     4.370    67.635     0.200
     4.378    68.555     0.200
     4.384    68.244     0.200
     4.382    68.773     0.200
     4.419    68.494     0.200
     4.452    69.305     0.200
     4.464    69.654     0.200
     4.521    69.684     0.200
     4.521    70.363     0.200
     4.526    70.414     0.200
     4.563    69.564     0.200
     4.603    71.924     0.200
     4.589    69.305     0.200
     4.669    72.514     0.200
     4.768    73.475     0.200
     4.772    74.273     0.200
     4.797    73.693     0.200
     4.800    73.654     0.200
     4.802    73.834     0.200
     4.804    74.104     0.200
     4.808    74.533     0.200
     4.926    76.385     0.200
     4.892    74.783     0.200
     4.892    74.975     0.200
     4.896    74.805     0.200
     4.985    76.305     0.200
     5.235    78.795     0.200
     5.256    79.564     0.200
     5.482    82.283     0.200
     5.482    81.305     0.200
     5.611    84.885     0.200
     5.611    84.004     0.200
     5.699    86.324     0.200
     5.870    89.164     0.200
     5.964    89.984     0.200
     5.964    89.873     0.200
     6.256    93.533     0.200
     6.297    94.654     0.200
     6.556    97.863     0.200
     6.630    98.453     0.200
     6.704   100.363     0.200
     6.865   103.934     0.200
     6.923   101.885     0.200
     6.952   101.684     0.200
     7.223   105.984     0.200
     7.595   112.684     0.200
     7.595   112.475     0.200
     7.645   112.674     0.200
     7.875   117.635     0.200
     7.842   117.975     0.200
     7.842   115.373     0.200
     8.757   130.385     0.200
     8.757   129.555     0.200
     8.757   130.283     0.200
     8.790   127.904     0.200
     9.821   143.443     0.200
    10.153   146.555     0.200
    10.537   154.283     0.200
    10.675   155.635     0.200
    10.945   159.102     0.200
    10.945   159.254     0.200
    10.946   159.465     0.200
    10.946   159.684     0.200
    10.951   159.484     0.200
    11.177   161.453     0.200
    11.177   161.975     0.200
    11.394   165.834     0.200
    11.388   165.424     0.200
    11.418   166.254     0.200
    11.425   166.404     0.200
    11.605   168.123     0.200
    11.646   168.914     0.200
    11.751   170.545     0.200
    11.824   167.684     0.200
    11.943   173.004     0.200
    11.943   172.215     0.200
    11.982   171.885     0.200
    12.071   172.744     0.200
    12.453   180.203     0.200
    12.513   178.895     0.200
    13.132   189.953     0.200
    13.256   190.703     0.200
    13.295   191.344     0.200
    13.346   191.674     0.200
    13.395   192.385     0.200
    13.543   194.854     0.200
    13.554   193.564     0.200
    13.559   193.334     0.200
    13.572   192.283     0.200
    13.572   191.045     0.200
    13.572   192.584     0.200
    13.572   192.729     0.200
    13.608   195.023     0.200
    13.682   195.783     0.200
    13.693   196.164     0.200
    13.921   199.135     0.200
    14.029   198.314     0.200
    14.253   203.674     0.200
    14.862   212.334     0.200
    15.329   217.193     0.200
    15.329   217.574     0.200
    15.329   218.279     0.200
    16.285   229.715     0.200
    16.285   229.863     0.200
    16.285   229.984     0.200
    16.489   231.623     0.200
    16.729   235.184     0.200
    16.729   234.953     0.200
    16.729   234.283     0.200
    16.897   235.453     0.200
    17.169   240.781     0.200
    17.330   241.885     0.200
    17.870   247.184     0.200
    18.257   251.113     0.200
    18.294   255.934     0.200
    19.053   263.504     0.200
    19.053   264.123     0.200
    19.053   264.578     0.200
    19.053   265.084     0.200
    19.099   267.721     0.200
    19.153   265.957     0.200
    19.205   265.605     0.200
    19.206   268.242     0.200
    19.209   265.430     0.200
    19.231   268.248     0.200
    19.239   267.191     0.200
    19.377   267.537     0.200
    19.400   270.361     0.200
    19.403   268.066     0.200
    19.412   267.891     0.200
    19.417   273.354     0.200
    19.439   268.953     0.200
    19.463   268.424     0.200
    19.474   267.893     0.200
    19.564   270.180     0.200
    19.586   270.357     0.200
    19.600   270.709     0.200
    19.650   274.406     0.200
    19.684   271.414     0.200
    19.692   271.590     0.200
    19.694   271.418     0.200
    19.782   272.473     0.200
    19.784   271.434     0.200
    19.784   271.328     0.200
    19.784   272.084     0.200
    19.784   272.385     0.200
    19.859   274.055     0.200
    19.883   272.648     0.200
    19.908   272.828     0.200
    19.967   273.164     0.200
    19.959   273.707     0.200
    20.041   275.109     0.200
    20.111   276.699     0.200
    20.167   276.166     0.200
    20.230   276.875     0.200
    20.292   277.406     0.200
    20.416   279.342     0.200
    20.462   280.049     0.200
    20.545   280.396     0.200
    20.635   281.281     0.200
    20.681   281.805     0.200
    20.706   283.393     0.200
    20.728   282.867     0.200
    20.835   284.980     0.200
    20.835   284.623     0.200
    20.850   283.566     0.200
    20.864   283.748     0.200
    20.881   284.275     0.200
    20.945   284.619     0.200
    20.957   285.150     0.200
     1.416    25.664     0.200
     1.667    28.105     0.200
     1.889    30.785     0.200
     2.261    39.734     0.200
     2.639    43.164     0.200
     2.727    43.516     0.200
     2.763    46.344     0.200
     2.934    44.957     0.200
     3.174    51.055     0.200
     3.446    54.844     0.200
     3.495    54.344     0.200
     3.910    61.734     0.200
     3.915    58.445     0.200
     3.860    61.797     0.200
     4.060    62.887     0.200
     4.318    68.945     0.200
     4.337    67.727     0.200
     4.343    68.035     0.200
     4.347    68.066     0.200
     4.351    68.555     0.200
     4.373    68.457     0.200
     4.376    66.617     0.200
     4.376    68.207     0.200
     4.411    70.145     0.200
     4.412    70.145     0.200
     4.524    70.387     0.200
     4.623    72.027     0.200
     4.623    72.496     0.200
     4.623    69.246     0.200
     4.623    73.406     0.200
     4.752    73.375     0.200
     4.742    74.527     0.200
     8.333   126.215     0.200
     8.333   123.266     0.200
     9.052   135.816     0.200
     9.052   130.016     0.200
     9.775   139.707     0.200
    10.589   150.336     0.200
    10.659   152.344     0.200
    10.687   151.324     0.200
    11.142   163.707     0.200
    11.142   159.086     0.200
    11.143   158.406     0.200
    11.143   164.105     0.200
    11.148   164.207     0.200
    11.380   161.027     0.200
    11.713   165.555     0.200
    11.785   167.594     0.200
    11.995   169.637     0.200
    12.039   170.035     0.200
    12.177   172.535     0.200
    12.638   179.047     0.200
    12.693   180.277     0.200
    12.713   180.527     0.200
    12.842   182.074     0.200
    13.135   186.215     0.200
    13.179   187.277     0.200
    13.501   190.707     0.200
    13.493   193.195     0.200
    13.493   189.137     0.200
    13.490   191.156     0.200
    13.516   191.066     0.200
    13.599   191.734     0.200
    13.642   196.805     0.200
    13.642   193.016     0.200
    13.749   194.066     0.200
    13.818   194.555     0.200
    13.918   195.617     0.200
    13.945   197.617     0.200
    14.141   199.016     0.200
    14.747   208.395     0.200
    14.923   210.637     0.200
    14.924   211.047     0.200
    15.226   213.715     0.200
    15.290   214.156     0.200
    15.348   215.395     0.200
    15.316   216.625     0.200
    15.448   216.875     0.200
    15.559   218.434     0.200
    15.576   217.906     0.200
    15.575   218.406     0.200
    15.701   223.395     0.200
    15.701   220.504     0.200
    15.756   219.984     0.200
    15.836   221.055     0.200
    16.007   224.156     0.200
    16.099   225.355     0.200
    16.065   224.645     0.200
    16.202   225.324     0.200
    16.172   226.234     0.200
    16.295   227.535     0.200
    16.302   229.316     0.200
    16.391   229.227     0.200
    16.646   231.734     0.200
    16.673   232.047     0.200
    16.714   232.707     0.200
    16.494   234.395     0.200
    16.989   238.137     0.200
    17.036   237.496     0.200
    17.078   238.414     0.200
    17.202   240.715     0.200
    17.402   242.664     0.200
    17.424   243.414     0.200
    17.579   244.734     0.200
    17.664   245.145     0.200
    18.412   254.305     0.200
    19.254   266.926     0.200
    19.489   269.895     0.200
    19.489   268.973     0.200
    19.567   271.227     0.200
     1.874    30.828     0.200
     2.425    38.176     0.200
     2.590    42.566     0.200
     2.691    41.898     0.200
     2.691    44.078     0.200
     3.224    52.059     0.200
     3.309    52.727     0.200
     3.696    56.969     0.200
     4.373    65.148     0.200
     4.466    65.926     0.200
     5.093    75.016     0.200
    10.751   153.395     0.200
    10.751   152.328     0.200
    11.473   162.348     0.200
    18.795   261.438     0.200
     1.003    18.242     0.200
     1.162    21.047     0.200
     1.263    22.328     0.200
     1.563    27.359     0.200
     1.746    27.977     0.200
     1.791    28.188     0.200
     2.316    37.578     0.200
     2.316    36.547     0.200
     2.316    38.828     0.200
     2.609    43.141     0.200
     2.719    42.508     0.200
     2.852    47.672     0.200
     3.022    47.422     0.200
     3.061    46.883     0.200
     3.032    47.570     0.200
     3.523    54.344     0.200
     3.958    59.727     0.200
     3.958    59.383     0.200
     3.958    61.289     0.200
     3.971    61.969     0.200
     4.184    62.641     0.200
     4.414    67.352     0.200
     4.425    66.000     0.200
     4.478    67.156     0.200
     4.505    66.453     0.200
     4.505    68.398     0.200
     4.505    68.023     0.200
     4.505    67.547     0.200
     4.695    72.062     0.200
     4.843    71.750     0.200
     5.585    83.492     0.200
     5.844    84.172     0.200
     6.080    89.391     0.200
     6.290    90.219     0.200
     7.026   107.711     0.200
     7.238   104.352     0.200
     7.463   109.062     0.200
     8.024   116.141     0.200
     8.024   115.109     0.200
     8.184   120.703     0.200
     8.184   119.398     0.200
     8.906   129.180     0.200
     8.906   128.312     0.200
     9.693   137.031     0.200
    10.484   153.312     0.200
    10.591   154.367     0.200
    10.762   151.898     0.200
    10.762   152.109     0.200
    11.010   159.375     0.200
    11.291   164.148     0.200
    11.629   168.633     0.200
    11.663   168.094     0.200
    11.757   169.211     0.200
    11.954   173.070     0.200
    12.046   174.133     0.200
    12.533   180.570     0.200
    12.554   180.242     0.200
    12.584   181.352     0.200
    12.726   183.117     0.200
    12.822   184.922     0.200
    13.005   187.094     0.200
    13.009   187.258     0.200
    13.308   187.188     0.200
    13.368   188.180     0.200
    13.381   190.383     0.200
    13.420   192.953     0.200
    13.420   190.094     0.200
    13.453   191.242     0.200
    13.503   190.812     0.200
    13.503   189.969     0.200
    13.498   189.430     0.200
    13.616   191.297     0.200
    13.670   195.047     0.200
    13.697   195.703     0.200
    13.704   193.781     0.200
    13.793   197.383     0.200
    13.994   199.641     0.200
    14.009   199.469     0.200
    14.606   204.742     0.200
    14.638   207.102     0.200
    14.777   209.117     0.200
    14.803   206.578     0.200
    15.096   212.930     0.200
    15.125   211.820     0.200
    15.166   213.922     0.200
    15.207   213.562     0.200
    15.235   213.992     0.200
    15.458   216.938     0.200
    15.485   217.828     0.200
    15.548   218.711     0.200
    15.548   218.047     0.200
    15.506   216.867     0.200
    15.629   219.172     0.200
    15.749   221.438     0.200
    15.872   224.461     0.200
    15.922   224.844     0.200
    15.911   223.844     0.200
    15.949   224.344     0.200
    15.995   224.656     0.200
    16.028   224.422     0.200
    16.141   226.070     0.200
    16.148   225.820     0.200
    16.128   225.141     0.200
    16.242   228.078     0.200
    16.549   230.242     0.200
    16.573   230.906     0.200
    16.592   231.109     0.200
    16.641   231.969     0.200
    16.760   234.852     0.200
    16.822   235.219     0.200
    16.815   234.070     0.200
    16.847   235.289     0.200
    16.847   235.531     0.200
    16.848   234.852     0.200
    16.848   236.031     0.200
    16.848   235.906     0.200
    16.848   234.953     0.200
    16.858   235.070     0.200
    16.858   234.562     0.200
    16.925   234.906     0.200
    16.946   236.281     0.200
    16.963   235.992     0.200
    17.171   238.547     0.200
    17.297   240.344     0.200
    17.304   240.477     0.200
    17.304   239.961     0.200
    17.475   242.148     0.200
    17.568   242.539     0.200
    17.669   243.602     0.200
    17.683   242.258     0.200
    17.722   244.953     0.200
    17.832   244.867     0.200
    17.877   248.078     0.200
    17.943   246.898     0.200
    18.000   247.117     0.200
    18.028   247.867     0.200
    18.055   248.797     0.200
    18.068   249.422     0.200
    18.092   249.031     0.200
    17.999   250.508     0.200
    18.291   254.281     0.200
    18.632   258.094     0.200
    19.335   265.289     0.200
    19.335   266.492     0.200
    19.335   268.250     0.200
    19.381   266.453     0.200
    19.381   269.148     0.200
    20.461   278.461     0.200
     2.127    35.623     0.200
     1.621    28.633     0.200
     1.797    31.473     0.200
     2.638    44.963     0.200
     2.370    40.604     0.200
     2.747    44.333     0.200
     4.190    64.443     0.200
     4.433    71.783     0.200
     4.442    73.113     0.200
     4.451    71.963     0.200
     4.497    68.283     0.200
     5.185    77.953     0.200
     5.302    80.854     0.200
     5.599    84.543     0.200
     1.189    21.758     0.200
     1.348    24.318     0.200
     1.450    25.707     0.200
     1.635    27.707     0.200
     1.923    30.857     0.200
     2.295    36.098     0.200
     2.615    42.578     0.200
     2.696    42.768     0.200
     2.797    46.357     0.200
     2.902    45.418     0.200
     3.206    50.896     0.200
     3.435    55.387     0.200
     3.423    53.957     0.200
     3.481    56.088     0.200
     3.513    56.008     0.200
     3.751    60.088     0.200
     3.879    61.396     0.200
     3.889    61.717     0.200
     3.887    61.887     0.200
     3.894    62.338     0.200
     3.896    62.967     0.200
     3.898    62.607     0.200
     3.898    62.748     0.200
     3.898    62.396     0.200
     3.898    62.227     0.200
     3.890    61.328     0.200
     3.921    62.627     0.200
     3.919    62.646     0.200
     3.924    62.217     0.200
     3.924    62.727     0.200
     3.932    61.088     0.200
     3.944    61.547     0.200
     4.017    63.568     0.200
     4.015    63.607     0.200
     4.041    62.857     0.200
     4.078    65.027     0.200
     4.028    61.678     0.200
     4.159    64.217     0.200
     4.164    65.727     0.200
     4.205    66.588     0.200
     4.299    68.197     0.200
     4.316    67.748     0.200
     4.324    67.838     0.200
     4.328    68.197     0.200
     4.332    67.738     0.200
     4.402    68.547     0.200
     4.348    67.807     0.200
     4.348    67.188     0.200
     4.344    67.488     0.200
     4.504    68.617     0.200
     4.644    71.908     0.200
     4.644    71.707     0.200
     4.644    71.348     0.200
     4.726    72.918     0.200
     5.044    77.258     0.200
     5.050    76.807     0.200
     5.050    76.557     0.200
     5.151    79.137     0.200
     5.454    83.408     0.200
     5.454    82.908     0.200
     5.443    83.328     0.200
     5.565    84.598     0.200
     5.734    86.896     0.200
     5.922    88.707     0.200
     5.922    87.277     0.200
     6.086    91.396     0.200
     6.136    93.307     0.200
     6.069    91.137     0.200
     6.156    93.158     0.200
     6.954   102.557     0.200
     7.085   105.238     0.200
     7.204   108.758     0.200
     7.535   112.408     0.200
     7.535   112.197     0.200
     7.456   109.068     0.200
     7.462   111.127     0.200
     7.489   112.258     0.200
     7.491   110.188     0.200
     7.650   112.646     0.200
     7.887   117.227     0.200
     7.897   115.807     0.200
     8.248   121.707     0.200
     8.248   120.367     0.200
     8.367   125.508     0.200
     8.367   125.178     0.200
     8.367   124.227     0.200
     8.367   124.947     0.200
     8.566   125.396     0.200
     9.081   134.807     0.200
     9.081   134.488     0.200
     9.081   135.068     0.200
     9.081   134.227     0.200
     9.259   134.627     0.200
     9.611   142.207     0.200
     9.611   139.838     0.200
     9.787   142.438     0.200
     9.816   143.707     0.200
     9.937   145.947     0.200
    10.606   154.627     0.200
    10.630   154.297     0.200
    10.630   153.748     0.200
    10.702   155.857     0.200
    10.831   158.307     0.200
    10.867   159.168     0.200
    11.167   161.457     0.200
    11.167   163.158     0.200
    11.168   163.707     0.200
    11.168   162.248     0.200
    11.326   164.008     0.200
    11.326   162.037     0.200
    11.393   166.387     0.200
    11.724   170.578     0.200
    11.807   171.977     0.200
    11.966   172.658     0.200
    12.051   173.168     0.200
    12.072   173.637     0.200
    12.202   176.998     0.200
    12.441   180.008     0.200
    12.441   179.768     0.200
    12.441   179.396     0.200
    12.656   182.348     0.200
    12.720   184.498     0.200
    12.737   184.318     0.200
    12.862   185.838     0.200
    12.900   183.807     0.200
    12.900   181.967     0.200
    12.968   187.908     0.200
    13.009   187.807     0.200
    13.009   187.646     0.200
    13.158   190.197     0.200
    13.157   190.508     0.200
    13.204   190.447     0.200
    13.461   193.057     0.200
    13.503   191.107     0.200
    13.503   190.207     0.200
    13.503   192.248     0.200
    13.503   191.787     0.200
    13.503   189.807     0.200
    13.512   194.107     0.200
    13.470   193.717     0.200
    13.556   193.008     0.200
    13.542   193.928     0.200
    13.616   194.027     0.200
    13.534   195.508     0.200
    13.670   196.527     0.200
    13.670   195.527     0.200
    13.775   197.748     0.200
    13.825   198.518     0.200
    13.842   198.078     0.200
    13.840   197.877     0.200
    13.857   198.098     0.200
    13.919   200.047     0.200
    13.941   199.088     0.200
    13.967   200.217     0.200
    14.025   201.008     0.200
    14.150   202.287     0.200
    14.166   202.107     0.200
    14.304   203.857     0.200
    14.331   204.467     0.200
    14.414   203.537     0.200
    14.713   208.598     0.200
    14.765   209.877     0.200
    14.944   211.797     0.200
    14.953   213.268     0.200
    14.948   212.896     0.200
    15.242   214.658     0.200
    15.301   215.537     0.200
    15.367   217.217     0.200
    15.347   218.498     0.200
    15.454   217.508     0.200
    15.568   219.008     0.200
    15.568   218.617     0.200
    15.584   218.217     0.200
    15.596   219.418     0.200
    15.779   221.938     0.200
    15.733   223.408     0.200
    15.733   222.238     0.200
    15.733   222.908     0.200
    15.849   222.658     0.200
    16.021   224.688     0.200
    16.116   226.438     0.200
    16.093   227.078     0.200
    16.121   227.848     0.200
    16.211   227.018     0.200
    16.336   229.896     0.200
    16.661   232.408     0.200
    16.689   232.158     0.200
    16.736   234.328     0.200
    16.528   234.107     0.200
    16.984   236.797     0.200
    17.006   238.328     0.200
    17.098   238.787     0.200
    17.225   239.947     0.200
    17.137   239.418     0.200
    17.293   240.887     0.200
    17.417   241.947     0.200
    17.422   242.477     0.200
    17.597   244.467     0.200
    17.673   243.877     0.200
    17.796   246.768     0.200
    17.805   246.887     0.200
    17.812   246.938     0.200
    17.836   247.107     0.200
    17.890   247.908     0.200
    17.926   247.947     0.200
    18.042   249.387     0.200
    18.055   249.697     0.200
    18.071   249.588     0.200
    18.171   251.098     0.200
    18.499   255.768     0.200
    18.555   256.396     0.200
    18.559   256.238     0.200
    18.779   260.498     0.200
    19.222   267.158     0.200
    19.222   266.307     0.200
    19.222   267.008     0.200
    19.523   269.318     0.200
    19.523   269.377     0.200
    19.595   269.146     0.200
    20.091   276.697     0.200
    20.434   279.557     0.200
    20.683   281.158     0.200
    20.673   281.408     0.200
    20.785   282.227     0.200
     1.608    28.371     0.200
     2.554    42.008     0.200
     2.878    46.641     0.200
     3.161    50.891     0.200
     3.360    53.609     0.200
     3.434    54.969     0.200
     3.394    55.441     0.200
     3.810    62.078     0.200
     3.806    62.051     0.200
     3.819    62.660     0.200
     4.001    62.160     0.200
     4.252    69.391     0.200
     4.255    68.059     0.200
     4.265    67.910     0.200
     4.303    66.730     0.200
     4.301    66.559     0.200
     4.314    66.758     0.200
     4.434    70.051     0.200
     4.671    72.500     0.200
     4.990    76.281     0.200
     5.022    75.348     0.200
     5.107    77.301     0.200
     5.405    83.578     0.200
     5.472    85.340     0.200
     5.676    86.840     0.200
     6.014    91.949     0.200
     6.900   103.301     0.200
     7.848   114.578     0.200
     1.772    30.613     0.200
     2.122    36.684     0.200
     2.593    44.293     0.200
     2.677    45.082     0.200
     2.992    46.363     0.200
     3.044    49.203     0.200
     3.479    56.941     0.200
     3.596    56.262     0.200
     4.326    69.094     0.200
     4.349    70.441     0.200
     4.353    68.992     0.200
     4.355    68.992     0.200
     4.358    70.082     0.200
     4.454    69.473     0.200
     4.444    70.383     0.200
     4.448    70.383     0.200
     4.804    72.473     0.200
     1.298    22.789     0.200
     1.670    27.906     0.200
     1.859    33.008     0.200
     2.279    36.688     0.200
     2.259    39.375     0.200
     2.663    44.336     0.200
     2.663    45.188     0.200
     2.663    43.914     0.200
     2.663    45.023     0.200
     2.753    44.828     0.200
     3.200    50.695     0.200
     3.251    52.742     0.200
     3.340    51.305     0.200
     3.548    53.516     0.200
     3.771    60.164     0.200
     3.995    62.039     0.200
     4.000    63.477     0.200
     4.107    63.016     0.200
     4.383    72.312     0.200
     4.396    71.938     0.200
     4.395    68.789     0.200
     4.395    70.078     0.200
     4.395    71.305     0.200
     4.411    71.914     0.200
     4.420    69.906     0.200
     4.420    70.797     0.200
     4.431    69.516     0.200
     4.438    72.023     0.200
     4.472    70.484     0.200
     4.484    70.422     0.200
     4.484    69.938     0.200
     4.484    69.656     0.200
     4.484    69.219     0.200
     4.527    73.203     0.200
     4.582    73.078     0.200
     4.672    71.039     0.200
     4.807    74.609     0.200
     4.808    74.609     0.200
     4.833    75.555     0.200
     4.858    74.844     0.200
     4.861    76.148     0.200
     4.862    75.555     0.200
     4.866    75.953     0.200
     4.868    75.953     0.200
     4.935    77.016     0.200
     4.969    76.156     0.200
     4.969    76.328     0.200
     5.047    77.508     0.200
     5.329    81.234     0.200
     5.402    80.938     0.200
     5.649    85.867     0.200
     5.694    85.484     0.200
     5.777    87.812     0.200
     5.899    90.219     0.200
     6.032    90.703     0.200
     6.078    92.062     0.200
     6.301    95.297     0.200
     6.326    95.117     0.200
     6.615    99.383     0.200
     6.713    99.984     0.200
     6.782   102.055     0.200
     6.782   102.055     0.200
     6.791    98.336     0.200
     6.796   104.383     0.200
     7.558   111.266     0.200
     7.582   113.445     0.200
     7.728   114.453     0.200
     7.852   118.258     0.200
     7.754   117.742     0.200
     7.754   117.414     0.200
     7.754   117.148     0.200
     7.754   117.859     0.200
     8.514   125.156     0.200
     8.689   130.289     0.200
     8.689   127.234     0.200
     8.689   129.156     0.200
     8.689   127.812     0.200
     8.689   129.836     0.200
     8.838   128.055     0.200
     9.175   133.625     0.200
     9.659   144.359     0.200
     9.804   143.367     0.200
    10.229   148.797     0.200
    10.229   149.148     0.200
    10.388   152.609     0.200
    10.388   151.164     0.200
    10.505   153.883     0.200
    10.649   154.812     0.200
    10.891   158.836     0.200
    10.891   156.812     0.200
    10.891   158.188     0.200
    10.891   157.828     0.200
    11.253   164.422     0.200
    11.253   163.516     0.200
    11.253   160.688     0.200
    11.253   163.781     0.200
    11.372   164.008     0.200
    11.468   167.227     0.200
    11.498   168.172     0.200
    11.600   167.844     0.200
    11.733   168.703     0.200
    11.800   171.078     0.200
    11.856   173.359     0.200
    11.856   172.969     0.200
    11.856   172.438     0.200
    11.856   173.102     0.200
    11.928   173.469     0.200
    12.392   178.742     0.200
    12.476   181.156     0.200
    12.476   181.477     0.200
    12.533   178.242     0.200
    12.546   181.414     0.200
    12.589   179.812     0.200
    12.692   183.883     0.200
    12.855   185.258     0.200
    12.906   185.766     0.200
    12.919   186.156     0.200
    13.299   191.883     0.200
    13.333   192.703     0.200
    13.333   192.305     0.200
    13.527   193.805     0.200
    13.531   193.406     0.200
    13.560   194.016     0.200
    13.560   194.562     0.200
    13.560   193.445     0.200
    13.560   192.375     0.200
    13.560   192.914     0.200
    13.560   195.773     0.200
    13.664   195.219     0.200
    13.708   196.656     0.200
    13.752   198.508     0.200
    14.110   201.617     0.200
    14.907   211.734     0.200
    15.156   214.133     0.200
    15.251   217.469     0.200
    15.251   217.188     0.200
    15.251   217.906     0.200
    15.251   216.312     0.200
    15.574   219.906     0.200
    15.656   220.812     0.200
    15.804   225.062     0.200
    15.837   222.617     0.200
    16.666   235.188     0.200
    16.666   234.312     0.200
    16.861   235.172     0.200
    16.861   235.508     0.200
    16.913   236.492     0.200
    16.928   238.516     0.200
    17.490   243.922     0.200
    17.885   248.188     0.200
    17.996   251.086     0.200
    18.043   250.523     0.200
    18.784   260.219     0.200
    18.969   264.203     0.200
    18.969   262.883     0.200
    18.969   263.398     0.200
    18.968   263.688     0.200
    18.969   264.719     0.200
    19.211   265.273     0.200
    19.290   266.453     0.200
    19.868   274.344     0.200
    19.868   272.633     0.200
    19.868   274.719     0.200
    20.736   284.336     0.200
    20.948   285.289     0.200
     1.829    29.156     0.200
     1.730    30.734     0.200
     2.102    34.285     0.200
     2.623    43.676     0.200
     2.784    43.566     0.200
     3.119    50.016     0.200
     3.097    49.023     0.200
     3.054    48.664     0.200
     3.570    57.895     0.200
     3.594    56.465     0.200
     3.589    56.074     0.200
     3.661    59.316     0.200
     3.657    56.266     0.200
     3.823    59.297     0.200
     4.017    61.605     0.200
     4.030    63.477     0.200
     4.029    62.395     0.200
     4.037    61.727     0.200
     4.037    58.797     0.200
     4.044    62.645     0.200
     4.053    62.227     0.200
     4.056    62.285     0.200
     4.062    62.246     0.200
     4.062    63.945     0.200
     4.073    66.316     0.200
     4.079    63.215     0.200
     4.118    65.324     0.200
     4.152    63.523     0.200
     4.159    65.336     0.200
     4.171    64.684     0.200
     4.219    65.324     0.200
     4.222    63.855     0.200
     4.301    65.004     0.200
     4.451    68.254     0.200
     4.471    68.254     0.200
     4.476    68.254     0.200
     4.480    68.324     0.200
     4.488    69.496     0.200
     4.510    69.613     0.200
     4.532    66.137     0.200
     4.532    68.965     0.200
     4.532    69.406     0.200
     4.575    67.613     0.200
     4.659    71.094     0.200
     4.783    75.145     0.200
     4.903    73.875     0.200
     5.244    77.887     0.200
     5.622    84.273     0.200
     5.650    84.977     0.200
     5.907    88.137     0.200
     6.168    92.984     0.200
     6.237    92.785     0.200
     6.263    92.477     0.200
     6.342    93.734     0.200
     7.067   105.906     0.200
     7.278   105.273     0.200
     7.532   111.273     0.200
     7.859   115.984     0.200
     9.775   137.895     0.200
     9.943   143.535     0.200
    10.815   154.406     0.200
    11.070   160.637     0.200
    11.070   158.113     0.200
    11.730   166.004     0.200
    12.105   170.215     0.200
    13.574   191.547     0.200
    13.555   192.613     0.200
    13.662   189.066     0.200
    14.049   194.344     0.200
    14.870   208.094     0.200
    15.201   211.695     0.200
    15.290   212.254     0.200
    15.307   212.863     0.200
    15.527   218.555     0.200
    19.348   265.578     0.200
     1.682    27.582     0.200
     1.643    28.031     0.200
     1.870    31.340     0.200
     2.055    34.820     0.200
     2.404    40.672     0.200
     2.404    38.941     0.200
     2.574    42.762     0.200
     2.812    43.070     0.200
     3.006    47.883     0.200
     3.139    48.941     0.200
     3.104    51.121     0.200
     3.617    57.223     0.200
     3.698    59.492     0.200
     3.791    60.641     0.200
     4.054    63.883     0.200
     4.054    66.000     0.200
     4.066    64.953     0.200
     4.263    64.953     0.200
     4.472    69.383     0.200
     4.493    68.383     0.200
     4.498    71.641     0.200
     4.501    68.883     0.200
     4.566    68.473     0.200
     4.540    70.551     0.200
     4.682    72.391     0.200
     8.113   116.055     0.200
    10.529   151.301     0.200
    11.029   160.812     0.200
    11.029   158.371     0.200
    11.029   158.031     0.200
    14.834   212.172     0.200
    15.273   217.672     0.200
    15.491   220.184     0.200
    20.657   282.523     0.200
     0.327     7.516     0.200
     0.721    13.445     0.200
     0.877    16.336     0.200
     0.983    17.484     0.200
     1.368    23.164     0.200
     1.568    25.227     0.200
     1.951    29.785     0.200
     1.931    32.273     0.200
     2.164    34.855     0.200
     2.346    39.113     0.200
     2.758    43.637     0.200
     2.725    42.727     0.200
     3.220    47.645     0.200
     3.434    51.926     0.200
     3.561    55.914     0.200
     3.709    55.246     0.200
     3.906    58.785     0.200
     3.906    58.594     0.200
     3.957    61.125     0.200
     4.042    61.195     0.200
     4.328    64.453     0.200
     4.195    63.684     0.200
     4.195    61.715     0.200
     4.308    62.953     0.200
     4.307    62.953     0.200
     4.355    69.086     0.200
     4.383    69.156     0.200
     4.384    67.574     0.200
     4.385    68.703     0.200
     4.388    64.605     0.200
     4.558    68.395     0.200
     4.585    69.176     0.200
     4.896    73.016     0.200
     5.218    77.434     0.200
     5.344    77.445     0.200
     5.373    80.355     0.200
     5.404    78.504     0.200
     5.575    82.684     0.200
     5.691    84.445     0.200
     5.880    84.977     0.200
     6.363    92.145     0.200
     7.121   101.066     0.200
     7.179   103.406     0.200
     8.594   122.926     0.200
     8.743   126.766     0.200
    10.693   153.184     0.200
    10.693   153.406     0.200
    14.333   202.285     0.200
    14.465   204.297     0.200
    14.490   203.266     0.200
    14.827   208.156     0.200
    15.218   213.445     0.200
    15.313   216.156     0.200
    15.634   219.176     0.200
     1.365    23.487     0.200
     1.734    29.207     0.200
     2.152    33.667     0.200
     2.992    47.018     0.200
     3.423    53.407     0.200
     3.423    54.347     0.200
     4.194    65.997     0.200
     4.591    71.207     0.200
     4.620    73.197     0.200
     4.621    71.207     0.200
     4.624    70.117     0.200
     4.786    71.707     0.200
     5.129    77.447     0.200
     5.450    80.938     0.200
     5.556    82.127     0.200
     5.600    83.707     0.200
     5.914    88.667     0.200
     6.115    92.147     0.200
     1.392    23.133     0.200
     1.492    26.234     0.200
     1.758    28.055     0.200
     2.123    33.219     0.200
     2.205    37.375     0.200
     2.302    38.422     0.200
     2.616    42.938     0.200
     2.882    47.219     0.200
     2.937    46.023     0.200
     3.394    51.203     0.200
     3.453    53.992     0.200
     3.598    57.672     0.200
     3.679    54.680     0.200
     3.725    58.641     0.200
     3.732    60.984     0.200
     3.875    60.648     0.200
     3.934    60.555     0.200
     3.928    63.102     0.200
     4.022    60.812     0.200
     4.077    65.000     0.200
     4.117    61.930     0.200
     4.130    65.453     0.200
     4.185    67.148     0.200
     4.454    68.719     0.200
     4.504    65.789     0.200
     4.526    70.141     0.200
     4.556    70.711     0.200
     4.555    69.891     0.200
     4.556    70.969     0.200
     4.558    71.484     0.200
     4.738    69.742     0.200
     5.075    76.289     0.200
     5.397    81.422     0.200
     5.522    82.055     0.200
     5.751    86.633     0.200
     5.871    87.883     0.200
     5.933    89.219     0.200
     6.059    90.758     0.200
     6.541    95.773     0.200
     8.272   120.953     0.200
    10.649   156.281     0.200
     1.514    23.889     0.200
     1.885    28.969     0.200
     2.016    31.828     0.200
     2.398    38.199     0.200
     2.391    39.838     0.200
     2.825    44.549     0.200
     3.041    49.859     0.200
     3.288    49.520     0.200
     3.634    57.588     0.200
     3.663    57.859     0.200
     3.840    57.668     0.200
     4.139    64.939     0.200
     4.408    66.229     0.200
     4.401    66.928     0.200
     4.541    73.008     0.200
     4.533    71.100     0.200
     4.533    71.100     0.200
     4.566    71.039     0.200
     4.569    70.889     0.200
     4.571    71.498     0.200
     4.685    71.488     0.200
     4.717    73.668     0.200
     4.755    70.408     0.200
     5.041    76.299     0.200
     5.361    81.119     0.200
     5.428    80.639     0.200
     5.495    83.029     0.200
     5.523    80.049     0.200
     5.641    83.838     0.200
     5.740    85.338     0.200
     6.036    90.369     0.200
     6.094    92.209     0.200
     6.323    96.408     0.200
     6.448    95.309     0.200
     6.499    97.059     0.200
     6.499    97.059     0.200
     6.845   103.369     0.200
     7.268   106.520     0.200
     7.256   107.318     0.200
     7.460   109.148     0.200
     7.418   109.439     0.200
     7.720   115.398     0.200
     7.954   118.209     0.200
     8.228   120.059     0.200
     8.228   120.229     0.200
     8.228   120.432     0.200
     8.730   125.020     0.200
     8.730   125.789     0.200
     8.887   128.629     0.200
     9.581   142.479     0.200
     9.943   143.479     0.200
    10.110   143.809     0.200
    10.526   151.020     0.200
    10.871   159.338     0.200
    10.871   156.258     0.200
    10.871   155.918     0.200
    11.193   162.020     0.200
    11.222   161.520     0.200
    11.236   160.568     0.200
    11.369   165.783     0.200
    11.586   169.158     0.200
    11.908   169.668     0.200
    11.907   170.068     0.200
    12.028   170.459     0.200
    12.305   171.658     0.200
    12.399   176.639     0.200
    12.448   177.629     0.200
    12.449   177.178     0.200
    12.621   178.779     0.200
    12.608   178.088     0.200
    12.970   179.719     0.200
    13.248   188.389     0.200
    13.345   188.908     0.200
    13.395   188.879     0.200
    13.421   189.770     0.200
    13.597   191.408     0.200
    13.667   192.799     0.200
    13.955   196.559     0.200
    14.544   204.979     0.200
    14.547   204.418     0.200
    14.598   206.270     0.200
    14.689   206.818     0.200
    15.049   210.850     0.200
    15.136   213.158     0.200
    15.314   211.879     0.200
    15.349   215.520     0.200
    15.486   215.859     0.200
    15.500   216.879     0.200
    15.756   220.629     0.200
    15.844   222.520     0.200
    15.914   222.869     0.200
    16.086   222.818     0.200
    16.101   224.309     0.200
    16.480   228.998     0.200
    16.473   229.029     0.200
    16.499   228.799     0.200
    16.599   230.039     0.200
    16.685   232.689     0.200
    16.770   233.270     0.200
    16.830   233.908     0.200
    16.858   234.789     0.200
    16.957   235.229     0.200
    17.087   236.828     0.200
    17.095   237.619     0.200
    17.207   239.109     0.200
    17.234   238.738     0.200
    17.392   241.359     0.200
    18.361   253.939     0.200
    18.396   253.928     0.200
    18.404   253.668     0.200
    18.403   254.229     0.200
    19.116   264.184     0.200
     2.370    38.944     0.200
     2.759    42.824     0.200
     3.083    45.265     0.200
     3.041    48.895     0.200
     3.468    55.074     0.200
     3.539    56.225     0.200
     3.563    55.215     0.200
     3.562    54.524     0.200
     3.632    57.145     0.200
     3.641    58.055     0.200
     3.810    60.345     0.200
     3.795    59.234     0.200
     3.986    62.494     0.200
     4.016    61.345     0.200
     4.207    63.005     0.200
     4.422    68.104     0.200
     4.443    67.685     0.200
     4.448    68.664     0.200
     4.451    68.044     0.200
     4.459    68.465     0.200
     4.477    69.194     0.200
     4.511    68.135     0.200
     4.513    68.635     0.200
     4.548    69.664     0.200
     4.631    69.794     0.200
     4.631    70.364     0.200
     4.749    74.225     0.200
     4.879    72.925     0.200
     5.198    77.765     0.200
     5.228    77.385     0.200
     5.317    79.624     0.200
     5.616    84.265     0.200
     5.883    87.265     0.200
     6.134    91.444     0.200
     6.248    91.284     0.200
     6.322    92.404     0.200
     1.602    26.310     0.200
     2.556    40.240     0.200
     2.686    43.420     0.200
     2.841    46.330     0.200
     3.027    48.030     0.200
     3.345    52.720     0.200
     3.417    53.110     0.200
     3.496    55.500     0.200
     3.972    59.070     0.200
     4.181    64.880     0.200
     4.359    67.330     0.200
     4.992    75.290     0.200
     5.074    77.450     0.200
     5.148    77.780     0.200
     5.780    86.280     0.200
    11.466   167.335     0.200
    11.466   164.770     0.200
    12.501   179.220     0.200
    13.915   196.340     0.200
    14.144   199.870     0.200
    14.449   205.160     0.200
    15.247   214.100     0.200
    15.541   218.210     0.200
    15.899   222.710     0.200
    16.318   227.840     0.200
    17.400   242.640     0.200
    17.696   246.500     0.200
    18.001   249.330     0.200
    18.353   253.210     0.200
    18.885   260.040     0.200
    19.082   264.470     0.200
    19.661   270.330     0.200
    19.730   269.729     0.200
    20.109   275.490     0.200
    20.938   283.800     0.200
     1.712    28.832     0.200
     1.811    31.191     0.200
     2.082    33.949     0.200
     2.555    43.270     0.200
     2.710    45.121     0.200
     3.083    50.062     0.200
     3.511    56.922     0.200
     3.634    58.211     0.200
     3.674    57.422     0.200
     3.950    64.562     0.200
     4.202    64.422     0.200
     4.354    67.180     0.200
     4.377    69.480     0.200
     4.381    66.711     0.200
     4.384    70.172     0.200
     4.429    71.461     0.200
     4.381    70.031     0.200
     4.390    72.160     0.200
     4.631    71.242     0.200
     4.838    74.062     0.200
     5.158    78.820     0.200
     5.594    86.340     0.200
     5.836    89.762     0.200
    10.935   158.426     0.200
     1.497    26.430     0.200
     1.700    26.648     0.200
     1.828    29.520     0.200
     2.198    36.480     0.200
     2.237    38.211     0.200
     2.237    37.859     0.200
     2.621    40.750     0.200
     2.976    46.910     0.200
     3.063    47.230     0.200
     3.334    51.348     0.200
     3.424    54.809     0.200
     3.397    52.668     0.200
     3.422    54.000     0.200
     3.525    53.211     0.200
     3.490    54.668     0.200
     3.667    56.660     0.200
     3.775    59.320     0.200
     3.731    57.820     0.200
     3.844    58.648     0.200
     3.857    59.980     0.200
     3.857    58.648     0.200
     3.861    61.648     0.200
     3.874    59.930     0.200
     3.864    57.230     0.200
     3.880    58.648     0.200
     3.883    61.980     0.200
     3.889    61.980     0.200
     3.901    60.648     0.200
     4.092    60.980     0.200
     4.280    64.918     0.200
     4.301    64.750     0.200
     4.306    65.281     0.200
     4.309    65.281     0.200
     4.387    65.629     0.200
     4.380    66.961     0.200
     4.338    67.230     0.200
     4.357    64.629     0.200
     4.493    69.688     0.200
     4.493    66.898     0.200
     4.493    65.531     0.200
     4.493    70.008     0.200
     4.633    68.789     0.200
     4.745    70.961     0.200
     5.064    75.648     0.200
     5.113    75.070     0.200
     5.188    76.938     0.200
     5.457    80.070     0.200
     5.490    82.078     0.200
     5.483    83.570     0.200
     5.746    85.969     0.200
     5.786    86.371     0.200
     6.066    91.598     0.200
     6.132    89.559     0.200
     6.021    89.469     0.200
     6.193    90.648     0.200
     6.193    90.648     0.200
     7.055   107.328     0.200
     7.403   108.621     0.200
     7.747   114.328     0.200
     7.926   114.699     0.200
     7.926   115.301     0.200
     8.589   122.859     0.200
     8.931   129.859     0.200
     8.931   127.551     0.200
     9.652   136.578     0.200
     9.800   140.621     0.200
    10.665   151.398     0.200
    10.560   148.461     0.200
    11.015   155.629     0.200
    11.014   158.758     0.200
    11.020   163.410     0.200
    11.656   164.008     0.200
    11.915   167.148     0.200
    12.049   169.879     0.200
    12.510   176.008     0.200
    12.567   177.281     0.200
    12.585   176.938     0.200
    12.713   178.891     0.200
    12.874   181.859     0.200
    13.004   182.988     0.200
    13.051   183.230     0.200
    13.361   187.660     0.200
    13.373   187.020     0.200
    13.472   188.520     0.200
    13.517   194.730     0.200
    13.517   190.391     0.200
    13.672   191.648     0.200
    13.689   192.680     0.200
    13.692   192.078     0.200
    13.789   193.211     0.200
    13.815   193.648     0.200
    14.013   196.281     0.200
    14.138   194.938     0.200
    14.186   198.430     0.200
    14.573   202.820     0.200
    14.618   204.648     0.200
    14.794   206.508     0.200
    14.803   207.891     0.200
    15.098   210.758     0.200
    15.167   211.340     0.200
    15.199   211.961     0.200
    15.219   212.059     0.200
    15.438   214.660     0.200
    15.446   215.969     0.200
    15.457   214.988     0.200
    15.590   217.590     0.200
    15.627   218.250     0.200
    15.712   218.129     0.200
    15.880   220.559     0.200
    15.941   222.211     0.200
    15.971   221.500     0.200
    16.049   224.410     0.200
    16.082   222.480     0.200
    16.519   229.719     0.200
    16.546   230.438     0.200
    16.585   231.270     0.200
    16.601   230.289     0.200
    16.787   232.879     0.200
    16.837   235.410     0.200
    16.864   235.902     0.200
    16.907   234.328     0.200
    16.920   234.648     0.200
    16.949   235.750     0.200
    17.147   237.480     0.200
    17.276   239.578     0.200
    17.278   238.590     0.200
    17.546   242.160     0.200
    17.551   242.930     0.200
    17.693   243.758     0.200
    17.708   244.891     0.200
    17.930   247.051     0.200
    17.913   246.770     0.200
    17.965   247.648     0.200
    18.027   247.801     0.200
    18.029   247.578     0.200
    18.090   249.199     0.200
    18.177   249.289     0.200
    18.188   249.559     0.200
    19.289   263.828     0.200
    19.392   266.371     0.200
    19.392   266.402     0.200
     0.633    13.801     0.200
     0.966    18.191     0.200
     1.021    18.633     0.200
     1.101    20.453     0.200
     1.213    21.570     0.200
     1.669    27.352     0.200
     1.785    30.410     0.200
     1.785    30.531     0.200
     1.907    29.891     0.200
     2.258    34.633     0.200
     2.377    37.922     0.200
     2.496    38.781     0.200
     2.566    40.953     0.200
     2.697    40.980     0.200
     2.856    43.520     0.200
     2.919    44.859     0.200
     3.012    46.500     0.200
     3.031    48.043     0.200
     3.128    48.160     0.200
     3.158    49.301     0.200
     3.160    50.520     0.200
     3.307    51.621     0.200
     3.300    50.121     0.200
     3.436    52.590     0.200
     3.410    54.102     0.200
     3.461    53.453     0.200
     3.489    55.359     0.200
     3.504    53.402     0.200
     3.504    55.172     0.200
     3.507    54.793     0.200
     3.519    55.562     0.200
     3.528    57.832     0.200
     3.548    55.410     0.200
     3.558    55.250     0.200
     3.611    56.250     0.200
     3.640    57.312     0.200
     3.691    58.762     0.200
     3.713    55.453     0.200
     3.764    57.070     0.200
     3.843    59.621     0.200
     3.916    59.332     0.200
     3.916    59.332     0.200
     3.954    61.430     0.200
     3.971    61.609     0.200
     4.009    60.410     0.200
     3.984    61.320     0.200
     3.983    61.430     0.200
     3.984    61.609     0.200
     3.985    61.391     0.200
     3.987    61.391     0.200
     4.078    60.961     0.200
     4.078    60.750     0.200
     4.172    63.742     0.200
     4.192    64.082     0.200
     4.192    63.770     0.200
     4.154    63.043     0.200
     4.233    64.480     0.200
     4.516    68.133     0.200
     4.838    72.801     0.200
     5.018    74.441     0.200
     5.010    75.492     0.200
     5.032    75.352     0.200
     5.730    84.840     0.200
     6.009    89.691     0.200
     6.009    89.691     0.200
     6.035    89.230     0.200
     6.737    98.301     0.200
     7.033   102.641     0.200
     7.717   111.199     0.200
     7.717   112.473     0.200
     8.361   120.602     0.200
     8.628   126.062     0.200
     8.628   124.641     0.200
     8.628   125.832     0.200
     9.181   131.121     0.200
     9.430   132.082     0.200
    10.101   142.750     0.200
    10.637   150.730     0.200
    10.637   152.211     0.200
    10.637   152.691     0.200
    10.637   153.332     0.200
    10.643   153.633     0.200
    10.789   152.582     0.200
    11.118   158.609     0.200
    11.245   159.172     0.200
    11.669   165.660     0.200
    12.065   171.102     0.200
    12.198   172.762     0.200
    12.216   173.609     0.200
    12.897   181.941     0.200
    12.897   183.832     0.200
    13.171   186.883     0.200
    13.276   186.512     0.200
    13.803   193.375     0.200
    14.111   196.609     0.200
    16.394   225.703     0.200
    16.524   228.449     0.200
    19.125   259.332     0.200
    19.235   260.426     0.200
     1.679    26.703     0.200
     2.245    36.641     0.200
     2.321    38.273     0.200
     2.644    41.703     0.200
     2.947    44.883     0.200
     3.154    49.727     0.200
     3.345    51.352     0.200
     3.507    53.352     0.200
     3.450    52.836     0.200
     3.912    60.102     0.200
     4.072    60.203     0.200
     4.339    66.992     0.200
     4.385    65.133     0.200
     4.345    66.273     0.200
     4.359    67.617     0.200
     4.408    67.602     0.200
     4.604    70.844     0.200
     4.758    71.383     0.200
     5.093    75.664     0.200
     5.077    75.984     0.200
     5.189    76.805     0.200
     2.207    37.604     0.200
     2.446    41.994     0.200
     2.723    46.713     0.200
     2.948    50.014     0.200
     3.111    51.463     0.200
     3.221    52.764     0.200
     3.223    54.223     0.200
     3.315    53.654     0.200
     3.253    55.543     0.200
     3.279    54.984     0.200
     3.358    57.164     0.200
     3.382    57.744     0.200
     3.742    61.123     0.200
     3.717    62.273     0.200
     3.736    62.344     0.200
     3.749    60.434     0.200
     3.754    61.803     0.200
     3.769    61.963     0.200
     3.952    64.273     0.200
     4.272    68.023     0.200
     4.301    68.693     0.200
     4.383    69.424     0.200
     4.498    71.164     0.200
     4.818    75.613     0.200
     7.684   114.678     0.200
     9.772   146.508     0.200
     1.068    19.121     0.200
     1.503    24.652     0.200
     1.949    32.941     0.200
     1.939    29.832     0.200
     2.418    40.031     0.200
     2.287    36.969     0.200
     2.827    45.340     0.200
     3.211    51.641     0.200
     3.536    56.652     0.200
     3.758    59.762     0.200
     3.597    53.371     0.200
     4.031    62.070     0.200
     4.432    70.441     0.200
     4.458    70.770     0.200
     4.460    69.609     0.200
     4.462    69.691     0.200
     4.467    69.652     0.200
     4.590    70.492     0.200
     4.421    67.051     0.200
     5.402    81.531     0.200
     2.467    40.867     0.200
     3.059    50.527     0.200
     3.160    49.547     0.200
     3.261    51.906     0.200
     3.363    55.418     0.200
     3.324    52.777     0.200
     3.671    59.426     0.200
     4.447    70.547     0.200
     4.735    74.809     0.200
     4.768    74.109     0.200
     5.033    79.246     0.200
     5.352    80.188     0.200
     1.744    28.635     0.200
     2.154    36.255     0.200
     2.660    42.825     0.200
     3.015    47.675     0.200
     3.375    54.575     0.200
     3.462    55.944     0.200
     3.428    56.114     0.200
     3.568    55.734     0.200
     3.448    55.935     0.200
     3.699    58.064     0.200
     3.718    58.965     0.200
     3.873    56.995     0.200
     3.909    61.035     0.200
     4.135    63.075     0.200
     4.314    69.415     0.200
     4.341    66.765     0.200
     4.344    67.825     0.200
     4.386    71.135     0.200
     4.524    69.925     0.200
     1.672    26.582     0.200
     2.236    36.282     0.200
     2.616    41.282     0.200
     2.942    45.582     0.200
     3.023    47.252     0.200
     3.120    49.282     0.200
     3.323    50.642     0.200
     3.499    54.632     0.200
     3.879    61.942     0.200
     3.789    59.542     0.200
     4.285    67.232     0.200
     4.305    67.112     0.200
     4.311    66.052     0.200
     4.314    67.362     0.200
     4.366    65.182     0.200
     4.324    66.412     0.200
     4.361    68.252     0.200
     4.552    70.362     0.200
     4.735    71.102     0.200
     4.676    72.082     0.200
     5.086    75.472     0.200
     5.054    76.092     0.200
     5.172    77.912     0.200
     5.470    82.212     0.200
     5.739    85.502     0.200
     6.106    88.562     0.200
     6.177    89.202     0.200
     6.065    91.472     0.200
     7.113   107.252     0.200
     7.454   109.392     0.200
     1.468    26.470     0.200
     2.178    36.890     0.200
     2.421    41.930     0.200
     2.336    40.950     0.200
     2.395    40.920     0.200
     2.415    41.620     0.200
     3.088    52.400     0.200
     3.196    54.320     0.200
     3.287    53.640     0.200
     3.207    52.520     0.200
     3.345    53.840     0.200
     3.375    55.110     0.200
     3.333    52.770     0.200
     3.715    60.050     0.200
     4.247    68.820     0.200
     4.476    71.940     0.200
     4.702    75.100     0.200
     4.796    75.230     0.200
     5.066    79.060     0.200
     5.235    81.120     0.200
     5.376    84.600     0.200
     5.442    83.790     0.200
     1.647    28.760     0.200
     2.216    37.620     0.200
     2.458    42.061     0.200
     2.343    40.990     0.200
     2.961    49.750     0.200
     3.123    52.860     0.200
     3.233    53.260     0.200
     3.326    55.210     0.200
     3.178    52.760     0.200
     3.394    56.360     0.200
     3.332    52.890     0.200
     4.284    69.570     0.200
     4.395    71.330     0.200
     4.697    75.730     0.200
     5.051    79.030     0.200
     5.102    80.311     0.200
     5.408    85.250     0.200
     5.479    86.690     0.200
     2.505    41.695     0.200
     3.094    49.852     0.200
     3.172    50.234     0.200
     3.267    52.047     0.200
     3.341    54.102     0.200
     3.308    53.492     0.200
     3.497    56.844     0.200
     3.648    58.133     0.200
     4.149    63.797     0.200
     4.385    70.336     0.200
     4.738    71.898     0.200
     5.128    77.703     0.200
     1.407    26.335     0.200
     1.704    30.335     0.200
     2.117    36.926     0.200
     2.388    41.505     0.200
     2.360    41.436     0.200
     2.366    40.955     0.200
     2.438    40.716     0.200
     2.485    40.545     0.200
     2.704    48.155     0.200
     2.919    48.625     0.200
     2.982    52.815     0.200
     3.069    52.346     0.200
     3.066    51.726     0.200
     3.172    52.556     0.200
     3.172    50.625     0.200
     3.164    52.745     0.200
     3.236    52.716     0.200
     3.278    52.245     0.200
     3.278    52.615     0.200
     3.334    52.775     0.200
     3.339    57.926     0.200
     3.395    54.266     0.200
     3.694    60.985     0.200
     3.714    62.226     0.200
     3.725    60.985     0.200
     3.730    62.985     0.200
     3.743    61.655     0.200
     4.218    67.306     0.200
     4.218    65.545     0.200
     4.231    65.136     0.200
     4.394    67.636     0.200
     4.454    70.726     0.200
     4.775    74.485     0.200
     5.008    78.775     0.200
     5.038    79.426     0.200
     5.196    79.426     0.200
     5.361    84.035     0.200
     5.411    86.905     0.200
     5.411    84.755     0.200
     6.008    91.216     0.200
     6.100    91.255     0.200
     6.190    94.755     0.200
     6.622   100.405     0.200
     7.151   107.556     0.200
     7.645   114.805     0.200
     7.645   114.466     0.200
     7.964   118.636     0.200
     8.248   123.165     0.200
     9.869   145.835     0.200
     9.869   144.766     0.200
    13.829   199.355     0.200
    15.023   215.096     0.200
    15.701   223.426     0.200
    16.004   226.766     0.200
    17.418   244.695     0.200
    18.809   262.136     0.200
     2.774    43.896     0.200
     2.998    48.738     0.200
     3.487    52.918     0.200
     3.670    57.348     0.200
     3.759    59.137     0.200
     4.025    61.207     0.200
     4.236    62.408     0.200
     4.430    68.457     0.200
     4.452    68.818     0.200
     4.456    70.807     0.200
     4.459    68.008     0.200
     4.467    70.047     0.200
     4.472    67.088     0.200
     4.532    68.078     0.200
     4.510    67.988     0.200
     4.640    70.357     0.200
     4.728    73.287     0.200
     4.898    72.807     0.200
     4.898    73.578     0.200
     5.217    76.707     0.200
     5.217    77.477     0.200
     5.257    78.998     0.200
     5.339    79.068     0.200
     5.339    79.607     0.200
     5.899    87.098     0.200
     6.112    90.637     0.200
     2.401    38.672     0.200
     2.487    41.004     0.200
     2.473    40.312     0.200
     3.282    52.703     0.200
     3.124    51.473     0.200
     3.358    51.543     0.200
     3.291    52.262     0.200
     3.354    53.574     0.200
     4.178    64.633     0.200
     4.195    64.293     0.200
     4.413    68.562     0.200
     4.732    72.152     0.200
     4.733    74.082     0.200
     4.997    76.473     0.200
     1.478    26.379     0.200
     2.164    36.828     0.200
     2.415    40.508     0.200
     3.065    51.748     0.200
     3.174    50.779     0.200
     3.268    52.818     0.200
     3.212    53.588     0.200
     3.321    54.949     0.200
     3.353    53.588     0.200
     3.695    59.119     0.200
     3.676    61.639     0.200
     3.696    61.148     0.200
     3.708    62.119     0.200
     3.713    62.279     0.200
     3.728    62.279     0.200
     3.911    62.998     0.200
     4.253    67.838     0.200
     4.453    70.828     0.200
     4.453    71.088     0.200
     4.773    73.600     0.200
     5.043    79.748     0.200
     5.214    81.559     0.200
     5.352    83.389     0.200
     5.420    85.389     0.200
     6.205    92.668     0.200
     6.613   100.488     0.200
     7.640   115.014     0.200
     7.640   114.869     0.200
     8.239   122.889     0.200
     9.806   147.895     0.200
     1.492    27.629     0.200
     1.803    29.309     0.200
     2.089    35.992     0.200
     2.254    37.660     0.200
     2.254    39.672     0.200
     2.254    39.289     0.200
     2.558    42.980     0.200
     2.863    48.480     0.200
     2.959    47.492     0.200
     2.957    46.770     0.200
     3.075    47.461     0.200
     3.421    53.691     0.200
     3.449    57.352     0.200
     3.500    55.219     0.200
     3.552    58.641     0.200
     3.626    55.148     0.200
     3.669    58.301     0.200
     3.721    61.301     0.200
     3.828    60.852     0.200
     3.891    62.691     0.200
     3.909    64.512     0.200
     3.914    63.391     0.200
     3.918    60.199     0.200
     3.918    63.852     0.200
     3.940    61.602     0.200
     3.931    64.129     0.200
     3.957    63.469     0.200
     4.045    62.570     0.200
     4.102    65.141     0.200
     4.194    63.621     0.200
     4.182    63.070     0.200
     4.344    68.051     0.200
     4.367    68.379     0.200
     4.371    67.559     0.200
     4.373    68.461     0.200
     4.380    69.270     0.200
     4.371    69.031     0.200
     4.404    70.719     0.200
     4.470    68.559     0.200
     4.470    68.840     0.200
     4.481    69.020     0.200
     4.425    68.590     0.200
     4.425    67.160     0.200
     4.425    68.000     0.200
     4.425    69.070     0.200
     4.555    71.859     0.200
     4.622    69.012     0.200
     4.828    73.410     0.200
     5.149    78.422     0.200
     5.214    78.332     0.200
     5.280    80.371     0.200
     5.533    84.000     0.200
     5.585    84.539     0.200
     5.678    84.211     0.200
     5.826    86.320     0.200
     6.234    92.160     0.200
     6.284    93.672     0.200
     6.546    98.660     0.200
     7.057   104.090     0.200
     8.014   117.688     0.200
     8.147   122.781     0.200
     8.674   126.070     0.200
     9.613   136.992     0.200
     9.729   142.898     0.200
    10.403   148.449     0.200
    10.755   153.930     0.200
    10.932   159.195     0.200
    10.938   157.172     0.200
    11.583   166.230     0.200
    11.968   172.172     0.200
    12.452   176.590     0.200
    12.479   178.281     0.200
    12.505   178.090     0.200
    12.926   182.781     0.200
    12.968   184.719     0.200
    13.304   188.590     0.200
    13.417   189.559     0.200
    13.428   193.500     0.200
    13.428   190.699     0.200
    13.591   192.262     0.200
    13.617   191.602     0.200
    13.624   190.992     0.200
    13.684   194.219     0.200
    13.713   194.621     0.200
    13.742   193.840     0.200
    13.916   197.430     0.200
    14.083   202.230     0.200
    14.201   200.090     0.200
    14.201   200.551     0.200
    14.525   204.172     0.200
    14.557   204.801     0.200
    14.706   208.742     0.200
    14.723   207.270     0.200
    15.044   209.941     0.200
    15.128   211.301     0.200
    15.154   212.781     0.200
    15.377   216.641     0.200
    15.406   215.012     0.200
    15.428   215.449     0.200
    15.550   217.820     0.200
    15.830   219.680     0.200
    15.849   222.680     0.200
    15.876   223.301     0.200
    15.914   221.691     0.200
    15.955   224.469     0.200
    16.512   230.570     0.200
    16.773   236.621     0.200
    16.773   233.391     0.200
    16.777   234.539     0.200
    16.777   232.832     0.200
    16.844   234.332     0.200
    16.882   234.969     0.200
    17.223   237.469     0.200
    17.641   243.012     0.200
    17.639   249.230     0.200
    17.824   248.359     0.200
    17.862   245.309     0.200
    17.919   245.840     0.200
    17.973   247.270     0.200
    18.013   247.121     0.200
    18.135   248.922     0.200
     2.993    47.383     0.200
     3.268    50.891     0.200
     3.547    53.273     0.200
     3.526    57.203     0.200
     3.538    57.914     0.200
     3.549    55.891     0.200
     3.554    57.391     0.200
     3.568    55.109     0.200
     3.746    57.953     0.200
     3.856    59.859     0.200
     4.239    64.812     0.200
     4.353    66.023     0.200
     4.654    71.078     0.200
     4.930    73.969     0.200
     0.281     7.328     0.200
     0.719    13.352     0.200
     0.877    16.242     0.200
     0.980    17.562     0.200
     1.432    22.617     0.200
     1.900    30.406     0.200
     1.981    29.609     0.200
     2.338    39.453     0.200
     2.227    36.672     0.200
     2.733    42.180     0.200
     2.856    47.406     0.200
     3.252    50.547     0.200
     3.491    51.562     0.200
     3.546    57.023     0.200
     3.793    57.367     0.200
     4.014    62.297     0.200
     4.236    64.898     0.200
     4.371    64.172     0.200
     4.412    66.406     0.200
     4.440    66.406     0.200
     4.441    66.406     0.200
     4.442    67.742     0.200
     4.445    66.539     0.200
     4.603    69.797     0.200
     4.945    72.141     0.200
     5.267    77.391     0.200
     5.418    80.602     0.200
     5.932    85.430     0.200
     5.908    86.523     0.200
     6.400    91.891     0.200
     8.140   118.898     0.200
    10.725   155.281     0.200
     1.836    30.355     0.200
     2.053    34.527     0.200
     2.241    38.297     0.200
     2.241    37.297     0.200
     2.514    41.738     0.200
     2.894    44.445     0.200
     2.912    45.238     0.200
     3.107    47.777     0.200
     3.441    53.168     0.200
     3.452    55.855     0.200
     3.515    54.328     0.200
     3.656    55.508     0.200
     3.656    54.496     0.200
     3.559    58.516     0.200
     3.629    57.629     0.200
     3.725    59.176     0.200
     3.831    62.496     0.200
     3.891    61.836     0.200
     3.911    61.836     0.200
     3.919    62.496     0.200
     3.919    62.836     0.200
     3.922    62.207     0.200
     3.922    62.707     0.200
     3.949    61.488     0.200
     3.932    62.496     0.200
     3.939    62.496     0.200
     3.962    61.836     0.200
     4.050    63.168     0.200
     4.107    65.816     0.200
     4.225    63.328     0.200
     4.185    63.168     0.200
     4.352    67.738     0.200
     4.376    66.688     0.200
     4.379    66.867     0.200
     4.381    67.328     0.200
     4.386    68.059     0.200
     4.387    68.059     0.200
     4.364    68.328     0.200
     4.364    68.328     0.200
     4.493    67.277     0.200
     4.565    68.277     0.200
     4.598    71.188     0.200
     4.847    73.316     0.200
     5.168    76.656     0.200
     5.244    78.797     0.200
     5.547    83.059     0.200
     6.264    91.977     0.200
     6.308    94.727     0.200
     6.307    94.727     0.200
     6.551    98.219     0.200
     6.910   104.035     0.200
     7.075   101.816     0.200
     7.337   108.777     0.200
     7.662   114.535     0.200
     8.035   115.477     0.200
     8.694   124.277     0.200
    10.777   152.176     0.200
    11.923   173.156     0.200
    12.461   181.105     0.200
    14.209   199.488     0.200
    15.439   218.098     0.200
    16.727   231.074     0.200
    17.825   246.566     0.200
    18.332   254.617     0.200
    18.520   257.926     0.200
    18.694   259.129     0.200
    19.237   265.035     0.200
    19.237   263.602     0.200
    19.422   266.676     0.200
    20.502   280.977     0.200
     1.415    25.859     0.200
     2.158    37.289     0.200
     2.395    41.758     0.200
     2.459    41.750     0.200
     3.249    52.664     0.200
     3.279    54.547     0.200
     3.387    53.852     0.200
     3.371    54.227     0.200
     3.419    54.742     0.200
     3.713    61.977     0.200
     4.260    68.914     0.200
     4.274    66.672     0.200
     4.366    71.297     0.200
     4.494    70.273     0.200
     4.756    73.562     0.200
     4.815    75.219     0.200
     5.079    78.047     0.200
     5.239    80.164     0.200
     5.399    83.172     0.200
     5.453    85.453     0.200
     1.897    29.863     0.200
     2.940    45.232     0.200
     3.531    54.674     0.200
     3.567    57.162     0.200
     3.575    55.832     0.200
     3.615    55.254     0.200
     3.722    55.562     0.200
     3.839    61.143     0.200
     4.009    63.143     0.200
     4.057    60.822     0.200
     4.048    61.773     0.200
     4.163    65.793     0.200
     4.220    64.463     0.200
     4.289    63.062     0.200
     4.269    65.133     0.200
     4.461    70.674     0.200
     4.484    70.674     0.200
     4.488    70.443     0.200
     4.585    67.793     0.200
     4.578    69.023     0.200
     4.673    69.053     0.200
     4.940    73.482     0.200
     5.260    78.562     0.200
     5.310    77.652     0.200
     5.386    80.354     0.200
     5.688    85.594     0.200
     5.939    87.902     0.200
     1.620    28.261     0.200
     1.488    26.951     0.200
     2.124    36.931     0.200
     2.347    38.501     0.200
     2.435    42.181     0.200
     2.441    41.911     0.200
     2.854    48.461     0.200
     3.013    48.791     0.200
     3.122    52.991     0.200
     3.269    54.221     0.200
     3.299    55.061     0.200
     4.173    66.281     0.200
     4.203    67.021     0.200
     4.284    67.541     0.200
     4.720    72.061     0.200
     4.990    77.431     0.200
     5.300    81.951     0.200
     5.368    83.221     0.200
     1.348    25.921     0.200
     1.560    28.131     0.200
     2.192    37.561     0.200
     2.382    40.931     0.200
     2.861    48.271     0.200
     3.034    51.081     0.200
     3.276    54.791     0.200
     3.464    58.881     0.200
     3.693    60.400     0.200
     4.421    70.610     0.200
     1.808    30.102     0.200
     1.800    31.156     0.200
     2.700    43.672     0.200
     2.761    45.602     0.200
     3.102    50.328     0.200
     3.271    50.633     0.200
     3.543    55.570     0.200
     3.549    55.547     0.200
     3.670    57.719     0.200
     3.835    60.672     0.200
     3.915    60.531     0.200
     4.288    64.688     0.200
     4.350    67.047     0.200
     4.653    72.031     0.200
     4.646    70.156     0.200
     4.923    74.930     0.200
     4.953    71.891     0.200
     5.308    79.672     0.200
     5.301    77.938     0.200
     5.355    80.156     0.200
     5.704    87.086     0.200
     7.090   103.797     0.200
     7.090   104.148     0.200
    11.243   164.703     0.200
     1.390    22.797     0.200
     1.925    28.977     0.200
     2.180    35.418     0.200
     2.749    43.457     0.200
     2.766    44.057     0.200
     3.195    50.467     0.200
     3.486    54.207     0.200
     3.560    56.447     0.200
     3.735    57.008     0.200
     3.955    63.068     0.200
     4.382    68.477     0.200
     4.383    69.807     0.200
     4.543    69.178     0.200
     4.568    67.178     0.200
     4.499    70.268     0.200
     4.885    70.748     0.200
     5.207    76.768     0.200
     5.323    78.947     0.200
     5.358    79.117     0.200
     5.674    84.748     0.200
     5.872    86.117     0.200
     1.403    25.887     0.200
     1.592    28.355     0.200
     2.170    37.129     0.200
     2.336    40.656     0.200
     2.404    41.727     0.200
     2.353    41.059     0.200
     2.444    42.246     0.200
     2.468    40.996     0.200
     2.507    43.078     0.200
     2.807    46.348     0.200
     2.936    46.156     0.200
     2.983    50.598     0.200
     3.004    49.797     0.200
     3.040    47.566     0.200
     3.040    51.578     0.200
     3.077    51.086     0.200
     3.108    51.637     0.200
     3.119    50.266     0.200
     3.211    50.707     0.200
     3.154    50.566     0.200
     3.154    52.008     0.200
     3.196    50.855     0.200
     3.222    52.066     0.200
     3.228    53.707     0.200
     3.234    50.707     0.200
     3.243    52.297     0.200
     3.572    56.695     0.200
     3.591    57.355     0.200
     3.604    56.219     0.200
     3.610    56.059     0.200
     3.626    60.695     0.200
     3.654    59.637     0.200
     3.808    60.559     0.200
     4.153    63.176     0.200
     4.153    63.758     0.200
     4.209    66.777     0.200
     4.211    66.527     0.200
     4.272    67.605     0.200
     4.369    69.195     0.200
     4.569    71.137     0.200
     4.688    72.238     0.200
     4.898    76.137     0.200
     4.969    77.918     0.200
     5.160    80.219     0.200
     5.258    82.418     0.200
     5.273    78.086     0.200
     5.351    83.797     0.200
     5.930    90.988     0.200
     6.145    90.457     0.200
     6.085    93.945     0.200
     6.284    98.746     0.200
     6.520    97.309     0.200
     7.096   107.766     0.200
     7.551   111.961     0.200
     7.551   110.738     0.200
     7.895   116.598     0.200
     8.145   122.117     0.200
     8.174   118.898     0.200
     8.914   128.996     0.200
     9.757   144.043     0.200
     9.757   141.066     0.200
    10.309   148.387     0.200
    11.380   163.988     0.200
    18.758   263.262     0.200
    19.183   265.105     0.200
    19.878   273.367     0.200
     1.540    28.590     0.200
     1.570    28.301     0.200
     2.352    40.102     0.200
     2.363    40.469     0.200
     2.430    41.090     0.200
     2.423    42.180     0.200
     2.453    40.211     0.200
     2.481    42.059     0.200
     2.830    47.262     0.200
     2.961    46.410     0.200
     3.003    48.738     0.200
     3.029    47.531     0.200
     3.065    48.148     0.200
     3.144    51.371     0.200
     3.162    50.309     0.200
     3.162    51.172     0.200
     3.251    53.430     0.200
     3.434    53.488     0.200
     3.596    57.711     0.200
     3.613    59.930     0.200
     3.615    59.930     0.200
     3.634    57.410     0.200
     3.832    62.320     0.200
     4.171    65.602     0.200
     4.171    64.129     0.200
     4.238    65.789     0.200
     4.390    70.238     0.200
     4.592    71.531     0.200
     4.709    72.082     0.200
     5.175    78.102     0.200
     5.281    78.020     0.200
     5.368    82.020     0.200
     5.943    88.230     0.200
     6.161    94.461     0.200
     6.542    97.000     0.200
     7.572   112.879     0.200
     7.572   113.871     0.200
     8.167   118.801     0.200
     9.764   144.484     0.200
     9.764   140.672     0.200
    10.131   145.941     0.200
    10.320   148.270     0.200
    15.570   220.211     0.200
    15.835   223.172     0.200
    15.865   223.770     0.200
    16.254   227.559     0.200
    16.472   231.250     0.200
    16.590   232.559     0.200
    16.750   236.500     0.200
    16.923   238.070     0.200
    16.963   238.441     0.200
    17.068   239.770     0.200
    19.223   266.777     0.200
     1.535    28.848     0.200
     1.574    28.898     0.200
     2.173    38.500     0.200
     2.351    41.348     0.200
     2.359    41.141     0.200
     2.425    41.801     0.200
     2.454    41.980     0.200
     2.827    47.629     0.200
     3.001    51.367     0.200
     3.061    49.438     0.200
     3.123    53.188     0.200
     3.159    51.379     0.200
     3.159    50.391     0.200
     3.252    52.758     0.200
     3.593    59.730     0.200
     3.610    59.438     0.200
     3.612    59.438     0.200
     3.631    60.840     0.200
     3.646    60.840     0.200
     3.665    61.188     0.200
     3.829    60.891     0.200
     4.170    65.090     0.200
     4.170    67.148     0.200
     4.221    66.141     0.200
     4.287    68.449     0.200
     4.388    68.711     0.200
     4.588    72.559     0.200
     4.706    73.020     0.200
     4.918    73.777     0.200
     4.986    79.648     0.200
     5.278    81.719     0.200
     5.938    89.969     0.200
     7.570   113.031     0.200
     7.892   116.188     0.200
     8.011   118.609     0.200
     9.761   144.023     0.200
    14.075   202.129     0.200
    14.224   202.961     0.200
    14.721   208.988     0.200
    15.074   213.270     0.200
    15.241   215.738     0.200
    15.279   216.840     0.200
    15.348   218.598     0.200
    15.703   222.961     0.200
    16.083   228.570     0.200
    16.234   230.180     0.200
    16.250   230.508     0.200
    16.468   232.789     0.200
    16.746   236.551     0.200
    16.754   235.949     0.200
    18.338   254.938     0.200
    18.587   258.398     0.200
    18.749   264.531     0.200
    19.166   265.570     0.200
    19.202   266.430     0.200
     1.388    25.506     0.200
     1.528    28.266     0.200
     1.581    28.066     0.200
     2.174    37.266     0.200
     2.347    39.656     0.200
     2.431    43.275     0.200
     2.821    48.127     0.200
     2.996    48.037     0.200
     3.024    50.787     0.200
     3.119    50.207     0.200
     3.156    51.656     0.200
     3.209    54.865     0.200
     3.237    53.037     0.200
     4.701    70.826     0.200
     4.981    75.646     0.200
     5.363    82.227     0.200
     1.076    21.680     0.200
     1.385    23.938     0.200
     2.521    41.969     0.200
     2.641    41.297     0.200
     2.892    47.289     0.200
     3.165    48.859     0.200
     3.140    50.031     0.200
     3.381    54.641     0.200
     3.737    57.008     0.200
     3.850    56.891     0.200
     3.951    61.852     0.200
     3.997    63.641     0.200
     3.980    62.336     0.200
     4.201    64.141     0.200
     4.280    65.633     0.200
     7.486   111.180     0.200
     1.462    26.551     0.200
     2.141    36.980     0.200
     2.382    41.311     0.200
     2.373    41.611     0.200
     2.439    42.412     0.200
     2.398    41.332     0.200
     3.051    51.852     0.200
     3.247    54.771     0.200
     3.234    52.412     0.200
     3.310    55.031     0.200
     3.331    55.672     0.200
     3.352    55.561     0.200
     3.675    57.152     0.200
     4.234    67.201     0.200
     5.027    77.521     0.200
     5.340    83.402     0.200
     1.189    18.273     0.200
     2.166    34.078     0.200
     2.460    36.984     0.200
     2.703    42.578     0.200
     3.015    45.055     0.200
     3.886    59.305     0.200
     3.890    60.242     0.200
     3.869    62.055     0.200
     3.882    60.758     0.200
     3.892    60.938     0.200
     3.897    60.938     0.200
     4.069    65.367     0.200
     4.269    66.703     0.200
     4.586    68.461     0.200
     4.693    72.820     0.200
     4.529    70.891     0.200
     4.987    73.812     0.200
     5.279    80.562     0.200
     5.925    90.039     0.200
     1.403    25.738     0.200
     1.715    30.127     0.200
     2.151    37.268     0.200
     2.429    41.938     0.200
     3.274    54.287     0.200
     3.374    53.117     0.200
     3.709    61.148     0.200
     3.769    59.178     0.200
     3.782    61.049     0.200
     4.259    68.367     0.200
     4.270    64.938     0.200
     5.452    84.318     0.200
     1.365    24.180     0.200
     1.857    28.900     0.200
     1.775    29.100     0.200
     2.521    39.710     0.200
     2.521    41.000     0.200
     2.853    44.130     0.200
     3.118    46.860     0.200
     3.133    49.530     0.200
     3.246    52.410     0.200
     3.548    53.390     0.200
     3.684    55.480     0.200
     3.945    60.220     0.200
     4.127    64.390     0.200
     4.130    65.920     0.200
     4.130    61.450     0.200
     4.246    62.940     0.200
     4.573    68.840     0.200
     4.535    72.670     0.200
     4.582    68.320     0.200
     4.582    68.510     0.200
     4.560    72.260     0.200
     4.563    73.020     0.200
     4.618    70.560     0.200
     4.693    68.480     0.200
     4.693    70.800     0.200
     4.962    73.680     0.200
     4.909    74.370     0.200
     5.268    77.690     0.200
     5.383    79.260     0.200
     5.671    84.730     0.200
     5.692    82.610     0.200
     5.766    85.770     0.200
     5.819    84.570     0.200
     6.287    92.020     0.200
     6.322    92.840     0.200
     6.388    91.610     0.200
     7.190   103.780     0.200
     7.157   108.430     0.200
     7.659   111.860     0.200
     7.984   116.970     0.200
     8.130   116.269     0.200
     8.130   117.780     0.200
     8.206   121.300     0.200
     8.801   126.070     0.200
     9.043   132.120     0.200
     9.043   130.470     0.200
     9.981   144.850     0.200
    10.683   150.880     0.200
    11.056   159.290     0.200
    11.087   160.320     0.200
    11.178   160.900     0.200
    11.178   159.610     0.200
    11.179   158.790     0.200
    11.497   162.310     0.200
    11.845   168.390     0.200
    11.959   168.960     0.200
    12.162   171.690     0.200
    12.214   173.820     0.200
    12.301   174.500     0.200
    12.710   179.360     0.200
    12.730   179.290     0.200
    12.833   181.710     0.200
    12.915   182.140     0.200
    12.955   182.420     0.200
    13.178   186.660     0.200
    13.542   190.730     0.200
    13.549   190.030     0.200
    13.698   192.020     0.200
    14.811   207.960     0.200
    14.833   208.190     0.200
    14.910   209.700     0.200
    14.987   211.130     0.200
    15.081   211.650     0.200
    15.287   215.450     0.200
    15.325   215.080     0.200
    15.653   219.850     0.200
    15.804   220.240     0.200
    16.998   237.330     0.200
    19.403   267.844     0.200
     2.071    35.316     0.200
     2.526    42.727     0.200
     2.692    45.445     0.200
     2.919    45.855     0.200
     3.087    47.453     0.200
     3.635    56.863     0.200
     3.487    55.594     0.200
     3.620    58.055     0.200
     4.823    73.363     0.200
     5.223    79.625     0.200
     5.281    80.543     0.200
     5.818    87.785     0.200
     1.580    25.021     0.200
     2.215    35.142     0.200
     2.215    35.451     0.200
     2.215    34.941     0.200
     2.334    35.082     0.200
     2.620    38.472     0.200
     2.573    38.771     0.200
     3.137    47.882     0.200
     3.078    46.932     0.200
     3.144    48.062     0.200
     3.215    48.611     0.200
     3.267    52.031     0.200
     3.467    50.491     0.200
     3.389    51.812     0.200
     3.475    52.691     0.200
     3.700    53.771     0.200
     3.633    52.962     0.200
     3.667    57.121     0.200
     3.669    56.422     0.200
     3.669    54.632     0.200
     3.669    55.871     0.200
     3.677    55.611     0.200
     3.682    56.861     0.200
     3.826    60.491     0.200
     3.845    61.161     0.200
     3.936    59.111     0.200
     3.957    59.632     0.200
     3.982    59.821     0.200
     4.038    59.901     0.200
     4.045    60.701     0.200
     4.057    60.531     0.200
     4.068    60.121     0.200
     4.073    60.752     0.200
     4.190    62.212     0.200
     4.244    61.852     0.200
     4.225    64.571     0.200
     4.226    64.571     0.200
     4.426    64.991     0.200
     4.690    68.981     0.200
     4.837    71.352     0.200
     5.170    76.852     0.200
     5.441    79.562     0.200
     6.086    89.132     0.200
     6.270    91.052     0.200
     6.653    95.552     0.200
     7.431   108.042     0.200
     7.587   108.329     0.200
     7.587   108.102     0.200
     7.541   108.102     0.200
     8.684   125.052     0.200
     9.299   133.271     0.200
     9.299   130.142     0.200
     9.299   134.132     0.200
     9.299   135.951     0.200
     9.803   141.871     0.200
     9.920   144.661     0.200
    11.328   161.474     0.200
    11.328   162.071     0.200
    11.328   162.691     0.200
    11.328   163.151     0.200
    11.930   169.502     0.200
    12.360   176.312     0.200
    12.732   179.932     0.200
    12.903   181.812     0.200
    13.494   188.432     0.200
    13.681   191.762     0.200
    13.892   194.342     0.200
    15.410   215.182     0.200
    15.989   224.151     0.200
    17.064   234.922     0.200
    17.209   236.252     0.200
    17.209   237.147     0.200
     1.199    20.629     0.200
     1.280    21.309     0.200
     1.440    25.729     0.200
     1.523    28.299     0.200
     1.777    30.009     0.200
     2.329    39.368     0.200
     2.329    38.568     0.200
     2.329    38.988     0.200
     2.569    42.629     0.200
     2.789    43.288     0.200
     3.370    52.919     0.200
     3.626    55.979     0.200
     3.626    56.169     0.200
     3.790    62.589     0.200
     4.034    60.629     0.200
     3.993    60.818     0.200
     4.067    62.818     0.200
     4.099    62.719     0.200
     4.143    65.299     0.200
     4.157    64.148     0.200
     4.157    62.818     0.200
     4.186    63.969     0.200
     4.227    64.698     0.200
     4.259    66.629     0.200
     4.279    64.148     0.200
     4.288    66.889     0.200
     4.317    65.799     0.200
     4.344    64.849     0.200
     4.361    68.799     0.200
     4.407    69.299     0.200
     4.423    65.788     0.200
     4.453    67.618     0.200
     4.533    69.299     0.200
     4.643    70.788     0.200
     4.774    73.679     0.200
     4.806    72.618     0.200
     4.810    73.958     0.200
     4.821    72.729     0.200
     5.006    74.788     0.200
     5.105    76.578     0.200
     5.209    80.608     0.200
     5.282    78.528     0.200
     5.390    80.318     0.200
     5.484    82.639     0.200
     5.542    82.839     0.200
     6.032    91.979     0.200
     6.104    89.889     0.200
     6.075    92.339     0.200
     6.229    91.669     0.200
     6.384    96.748     0.200
     6.418    95.238     0.200
     6.498    97.259     0.200
     7.018   103.458     0.200
     7.018   103.458     0.200
     7.115   106.608     0.200
     8.101   119.318     0.200
     8.515   126.309     0.200
     8.629   128.318     0.200
     8.687   128.328     0.200
    10.655   156.148     0.200
    11.756   168.368     0.200
    11.778   170.259     0.200
    11.877   171.208     0.200
    15.629   220.349     0.200
    15.629   221.148     0.200
    15.630   221.339     0.200
    16.423   231.698     0.200
    16.946   236.719     0.200
     2.735    43.422     0.200
     2.944    45.873     0.200
     3.108    48.143     0.200
     3.456    54.773     0.200
     3.483    55.893     0.200
     3.536    56.623     0.200
     3.659    57.113     0.200
     3.587    58.252     0.200
     3.975    62.082     0.200
     4.227    63.062     0.200
     4.402    71.014     0.200
     4.516    71.332     0.200
     4.505    68.104     0.200
     4.429    71.443     0.200
     4.645    72.793     0.200
     4.864    73.232     0.200
     5.184    76.943     0.200
     5.315    82.402     0.200
     6.028    90.242     0.200
     0.300     7.559     0.200
     0.743    13.779     0.200
     1.006    17.939     0.200
     1.386    23.529     0.200
     1.938    29.758     0.200
     1.943    30.709     0.200
     2.179    36.689     0.200
     2.367    39.779     0.200
     2.757    43.439     0.200
     2.750    43.520     0.200
     2.818    44.178     0.200
     3.207    46.869     0.200
     3.441    54.869     0.200
     3.495    54.770     0.200
     3.465    55.459     0.200
     3.473    53.770     0.200
     3.565    56.828     0.200
     3.747    57.668     0.200
     3.716    60.008     0.200
     3.871    61.289     0.200
     3.915    62.389     0.200
     3.961    60.789     0.200
     4.048    63.998     0.200
     4.100    60.479     0.200
     4.317    63.379     0.200
     4.320    66.748     0.200
     4.359    65.459     0.200
     4.387    67.258     0.200
     4.388    67.588     0.200
     4.389    66.059     0.200
     4.381    68.479     0.200
     4.493    66.338     0.200
     4.576    71.428     0.200
     4.893    72.539     0.200
     5.368    79.959     0.200
     5.684    82.779     0.200
     5.880    86.049     0.200
     5.870    84.748     0.200
     1.714    30.420     0.200
     2.139    37.221     0.200
     2.416    41.941     0.200
     2.477    42.670     0.200
     2.411    41.141     0.200
     3.094    52.361     0.200
     3.192    53.740     0.200
     3.261    53.740     0.200
     3.267    52.361     0.200
     3.417    57.170     0.200
     3.696    60.480     0.200
     3.741    60.432     0.200
     4.246    68.682     0.200
     4.257    68.170     0.200
     4.482    72.191     0.200
     1.754    30.992     0.200
     1.852    31.875     0.200
     2.445    40.367     0.200
     2.518    42.930     0.200
     2.670    44.695     0.200
     3.097    49.844     0.200
     3.171    50.664     0.200
     3.537    59.281     0.200
     3.667    58.742     0.200
     3.939    64.781     0.200
     3.963    63.234     0.200
     4.044    65.117     0.200
     4.118    67.547     0.200
     4.280    69.984     0.200
     4.391    69.461     0.200
     4.655    73.141     0.200
     4.977    77.711     0.200
     5.162    80.281     0.200
     5.304    82.773     0.200
     5.497    85.586     0.200
     5.497    84.805     0.200
     5.623    87.273     0.200
     1.471    26.293     0.200
     2.201    38.215     0.200
     3.112    52.082     0.200
     3.192    52.574     0.200
     3.367    55.645     0.200
     3.741    61.992     0.200
     4.272    65.453     0.200
     4.383    68.984     0.200
     4.500    68.504     0.200
     4.704    73.172     0.200
     4.820    74.613     0.200
     5.090    78.605     0.200
     5.399    81.922     0.200
     6.055    92.555     0.200
     1.438    23.367     0.200
     2.082    32.688     0.200
     2.370    37.867     0.200
     2.451    38.109     0.200
     2.710    41.867     0.200
     2.887    47.195     0.200
     3.076    49.016     0.200
     2.909    45.594     0.200
     3.176    50.375     0.200
     3.261    49.156     0.200
     3.309    53.914     0.200
     3.246    50.883     0.200
     3.639    57.328     0.200
     3.829    58.109     0.200
     4.119    59.906     0.200
     4.155    63.984     0.200
     4.488    66.555     0.200
     4.540    70.812     0.200
     4.548    71.633     0.200
     4.807    72.695     0.200
     4.926    74.227     0.200
     5.226    78.859     0.200
     5.209    77.039     0.200
     5.493    81.242     0.200
     5.869    86.477     0.200
     5.931    85.516     0.200
     5.934    89.812     0.200
     7.363   107.523     0.200
     1.723    29.672     0.200
     2.048    33.711     0.200
     2.589    42.633     0.200
     2.533    42.480     0.200
     2.738    44.141     0.200
     2.797    46.613     0.200
     3.030    49.891     0.200
     3.159    49.762     0.200
     3.103    49.523     0.200
     3.443    55.191     0.200
     3.442    54.914     0.200
     3.459    56.762     0.200
     3.619    56.852     0.200
     3.820    59.652     0.200
     4.137    64.383     0.200
     4.247    65.461     0.200
     4.546    70.301     0.200
     4.831    72.801     0.200
     5.197    78.102     0.200
     5.252    82.281     0.200
     0.250     7.668     0.200
     0.736    13.559     0.200
     0.997    17.668     0.200
     1.460    24.078     0.200
     1.535    25.281     0.200
     1.980    29.699     0.200
     2.352    39.738     0.200
     2.820    42.781     0.200
     2.753    40.719     0.200
     3.540    53.238     0.200
     3.794    54.918     0.200
     4.030    62.480     0.200
     4.364    64.512     0.200
     4.395    66.801     0.200
     4.429    66.820     0.200
     4.459    69.328     0.200
     4.463    69.980     0.200
     4.611    70.609     0.200
     4.564    69.949     0.200
     5.277    76.012     0.200
     5.642    85.961     0.200
     5.944    88.750     0.200
     5.940    86.859     0.200
     6.402    93.230     0.200
     1.484    25.963     0.200
     1.950    33.333     0.200
     1.854    31.033     0.200
     2.169    35.333     0.200
     2.473    42.683     0.200
     2.731    45.273     0.200
     2.731    46.043     0.200
     2.731    45.053     0.200
     2.974    47.183     0.200
     3.154    50.083     0.200
     3.226    51.743     0.200
     3.428    54.913     0.200
     3.935    62.763     0.200
     4.003    64.733     0.200
     3.997    63.693     0.200
     4.206    68.273     0.200
     4.378    71.833     0.200
     4.397    71.373     0.200
     4.403    67.893     0.200
     4.415    72.253     0.200
     4.534    71.373     0.200
     4.558    69.843     0.200
     4.684    73.003     0.200
     4.684    74.043     0.200
     4.893    74.933     0.200
     5.058    75.863     0.200
     5.269    81.423     0.200
     5.588    84.693     0.200
     5.695    86.973     0.200
     6.433    96.123     0.200
     6.598    99.173     0.200
     7.028   105.313     0.200
     7.017   106.813     0.200
     7.360   107.573     0.200
     7.616   111.553     0.200
     7.938   120.303     0.200
     8.441   123.812     0.200
     8.911   132.053     0.200
     8.911   134.243     0.200
    11.107   161.013     0.200
    11.107   163.243     0.200
    11.107   161.247     0.200
    11.107   160.893     0.200
    11.809   171.013     0.200
    12.144   175.563     0.200
    12.612   181.653     0.200
    12.742   183.003     0.200
    12.897   185.503     0.200
    13.553   194.143     0.200
    13.720   196.423     0.200
    13.845   198.183     0.200
    14.679   208.063     0.200
    14.679   207.672     0.200
    14.679   207.833     0.200
    14.835   212.703     0.200
    14.954   212.753     0.200
    15.060   213.723     0.200
    15.469   220.483     0.200
    16.886   237.987     0.200
    16.886   237.173     0.200
    17.059   238.603     0.200
    19.174   267.693     0.200
    19.174   266.637     0.200
     1.033    18.541     0.200
     1.092    19.131     0.200
     1.325    22.541     0.200
     1.609    26.141     0.200
     1.750    28.481     0.200
     1.796    29.701     0.200
     1.973    32.481     0.200
     2.358    37.951     0.200
     2.429    39.351     0.200
     2.780    44.731     0.200
     2.896    44.471     0.200
     2.979    49.071     0.200
     3.249    51.201     0.200
     3.271    53.611     0.200
     3.351    54.271     0.200
     3.467    52.401     0.200
     3.728    59.371     0.200
     3.648    58.511     0.200
     3.862    62.761     0.200
     3.886    60.981     0.200
     4.092    63.021     0.200
     4.411    67.741     0.200
     4.484    67.421     0.200
     4.537    69.551     0.200
     4.537    69.481     0.200
     4.844    73.761     0.200
     5.096    75.191     0.200
     1.721    28.285     0.200
     1.952    31.227     0.200
     2.214    34.797     0.200
     2.817    46.316     0.200
     3.156    51.516     0.200
     3.146    49.938     0.200
     3.550    54.848     0.200
     3.584    58.516     0.200
     3.607    54.246     0.200
     4.114    62.137     0.200
     4.083    61.945     0.200
     4.105    65.586     0.200
     4.429    66.418     0.200
     4.432    69.016     0.200
     4.410    70.695     0.200
     4.455    70.938     0.200
     4.866    76.348     0.200
     0.307     8.578     0.200
     0.975    16.977     0.200
     1.094    19.156     0.200
     1.164    19.887     0.200
     1.155    20.105     0.200
     1.178    20.617     0.200
     1.207    21.266     0.200
     1.237    21.027     0.200
     1.266    22.406     0.200
     1.364    22.797     0.200
     1.360    23.336     0.200
     1.493    25.465     0.200
     1.708    27.035     0.200
     1.636    27.848     0.200
     1.808    28.066     0.200
     1.941    30.406     0.200
     2.116    34.809     0.200
     2.219    34.016     0.200
     2.174    34.426     0.200
     2.312    36.098     0.200
     2.570    39.875     0.200
     2.601    42.496     0.200
     2.838    44.148     0.200
     2.979    45.105     0.200
     2.970    45.125     0.200
     3.297    49.738     0.200
     3.368    52.105     0.200
     3.377    54.746     0.200
     3.523    51.625     0.200
     3.593    55.508     0.200
     3.665    55.566     0.200
     3.777    58.828     0.200
     3.802    57.906     0.200
     1.261    22.375     0.200
     0.581    13.892     0.200
     0.656    14.691     0.200
     0.868    17.002     0.200
     1.184    19.642     0.200
     1.358    22.691     0.200
     1.268    23.002     0.200
     1.448    24.762     0.200
     1.461    24.531     0.200
     1.472    25.222     0.200
     1.477    25.262     0.200
     1.565    25.621     0.200
     1.549    26.562     0.200
     1.619    26.752     0.200
     1.678    27.771     0.200
     1.800    29.012     0.200
     1.856    29.172     0.200
     1.830    30.562     0.200
     2.194    34.062     0.200
     2.135    34.151     0.200
     2.442    36.451     0.200
     2.521    38.871     0.200
     2.502    40.081     0.200
     2.597    40.041     0.200
     2.777    42.161     0.200
     2.817    43.981     0.200
     2.966    47.092     0.200
     2.974    47.592     0.200
     3.144    47.382     0.200
     3.182    48.321     0.200
     1.554    26.661     0.200
     1.754    28.475     0.200
     2.411    38.485     0.200
     2.735    43.585     0.200
     3.019    46.896     0.200
     3.148    50.675     0.200
     3.433    54.945     0.200
     3.582    55.815     0.200
     3.542    54.945     0.200
     1.398    26.539     0.200
     1.639    28.977     0.200
     2.285    39.352     0.200
     2.239    38.047     0.200
     2.406    42.219     0.200
     2.389    41.266     0.200
     2.505    43.133     0.200
     2.602    43.203     0.200
     2.712    44.586     0.200
     2.773    46.023     0.200
     2.839    47.195     0.200
     3.085    49.203     0.200
     3.159    50.945     0.200
     3.159    53.656     0.200
     3.254    52.453     0.200
     3.243    53.055     0.200
     3.307    55.016     0.200
     4.324    68.508     0.200
     5.016    77.562     0.200
     1.774    30.000     0.200
     1.768    30.301     0.200
     2.006    33.240     0.200
     2.125    35.371     0.200
     2.429    39.271     0.200
     2.531    42.470     0.200
     2.804    46.230     0.200
     3.035    49.101     0.200
     3.198    52.460     0.200
     3.277    53.010     0.200
     3.316    54.420     0.200
     3.562    58.391     0.200
     3.577    57.400     0.200
     3.722    59.760     0.200
     3.857    62.480     0.200
     4.134    62.881     0.200
     4.138    63.980     0.200
     4.152    65.260     0.200
     4.338    68.791     0.200
     4.289    69.190     0.200
     4.361    70.081     0.200
     4.670    70.930     0.200
     4.992    77.811     0.200
     5.147    78.551     0.200
     5.156    80.131     0.200
     1.096    21.660     0.200
     1.754    28.322     0.200
     1.804    29.832     0.200
     2.414    37.792     0.200
     2.717    43.572     0.200
     3.021    48.552     0.200
     3.118    50.052     0.200
     3.420    52.752     0.200
     3.582    56.772     0.200
     3.982    63.042     0.200
     4.427    65.262     0.200
     4.597    72.732     0.200
     4.833    71.072     0.200
     0.539    11.934     0.200
     0.760    15.172     0.200
     0.854    16.844     0.200
     0.902    17.621     0.200
     0.912    17.441     0.200
     0.923    18.223     0.200
     0.949    18.660     0.200
     0.989    19.094     0.200
     1.013    18.672     0.200
     1.056    19.621     0.200
     1.131    20.422     0.200
     1.188    21.410     0.200
     1.281    23.133     0.200
     1.341    23.383     0.200
     1.693    26.691     0.200
     1.811    29.062     0.200
     1.869    29.332     0.200
     1.989    31.570     0.200
     2.045    31.543     0.200
     2.101    32.762     0.200
     2.388    36.312     0.200
     2.521    38.570     0.200
     2.589    40.172     0.200
     2.693    41.570     0.200
     2.867    45.191     0.200
     3.126    46.402     0.200
     3.219    49.273     0.200
     3.297    49.094     0.200
     3.268    49.992     0.200
     3.342    50.832     0.200
     3.367    51.070     0.200
     3.358    51.980     0.200
     3.496    53.582     0.200
     3.608    55.461     0.200
     3.646    54.980     0.200
     3.758    57.723     0.200
     4.031    60.543     0.200
     4.077    61.230     0.200
     4.152    63.812     0.200
     4.151    63.891     0.200
     4.182    64.250     0.200
     4.184    64.422     0.200
     4.219    62.684     0.200
     4.405    66.281     0.200
     4.447    67.023     0.200
     4.727    70.730     0.200
     5.050    75.344     0.200
     5.230    76.863     0.200
     5.224    77.852     0.200
     5.388    80.410     0.200
     5.553    82.641     0.200
     5.618    83.191     0.200
     5.702    84.383     0.200
     6.223    92.191     0.200
     6.247    91.551     0.200
     0.986    19.223     0.200
     1.236    24.308     0.200
     1.278    25.078     0.200
     1.240    23.917     0.200
     1.768    29.788     0.200
     1.612    28.397     0.200
     1.272    25.217     0.200
     1.983    33.801     0.200
     2.109    36.004     0.200
     2.540    41.281     0.200
     2.667    41.441     0.200
     2.931    47.844     0.200
     3.569    56.172     0.200
     3.780    61.953     0.200
     3.936    61.512     0.200
     4.236    65.371     0.200
     4.250    65.562     0.200
     4.298    65.934     0.200
     4.363    67.262     0.200
     4.382    71.492     0.200
     4.452    69.070     0.200
     4.495    67.152     0.200
     4.526    69.453     0.200
     4.672    75.570     0.200
     4.723    72.754     0.200
     4.779    74.973     0.200
     4.830    75.113     0.200
     4.916    76.113     0.200
     4.982    76.863     0.200
     5.065    78.082     0.200
     5.061    76.754     0.200
     5.090    79.652     0.200
     5.118    75.082     0.200
     5.208    79.582     0.200
     5.349    81.164     0.200
     5.360    81.594     0.200
     5.702    85.531     0.200
     6.023    91.434     0.200
     6.082    92.133     0.200
     6.159    92.281     0.200
     6.393    95.742     0.200
     6.463    97.832     0.200
     6.588   100.141     0.200
     6.694   102.031     0.200
     7.101   106.094     0.200
     7.930   118.602     0.200
     8.116   118.922     0.200
     8.488   124.512     0.200
     8.892   129.730     0.200
     9.607   143.703     0.200
    10.484   151.941     0.200
    10.760   158.691     0.200
    10.760   157.953     0.200
    10.761   156.934     0.200
    12.228   175.281     0.200
    12.297   176.312     0.200
    12.354   174.152     0.200
    12.518   177.664     0.200
    12.626   179.551     0.200
    12.748   177.492     0.200
    12.785   180.043     0.200
    12.810   182.461     0.200
    13.083   184.543     0.200
    13.085   186.613     0.200
    13.161   186.820     0.200
    13.205   185.812     0.200
    13.347   188.961     0.200
    13.423   191.664     0.200
    13.511   191.242     0.200
    13.552   192.633     0.200
    13.592   191.523     0.200
    13.602   191.652     0.200
    13.622   193.961     0.200
    13.621   194.273     0.200
    14.593   207.934     0.200
    14.660   205.793     0.200
    14.680   206.844     0.200
    15.140   213.613     0.200
    15.338   215.801     0.200
    15.420   215.473     0.200
    15.555   219.812     0.200
    15.686   218.453     0.200
    16.428   229.551     0.200
    16.482   231.352     0.200
    16.483   230.531     0.200
    16.483   230.414     0.200
    16.593   233.293     0.200
    17.407   241.730     0.200
    10.884   154.551     0.200
    11.270   160.242     0.200
     7.658   115.801     0.200
     7.356   109.164     0.200
     3.015    46.961     0.200
     3.695    56.688     0.200
     3.722    57.258     0.200
     3.954    62.594     0.200
     4.105    63.281     0.200
     4.122    63.812     0.200
     4.441    67.523     0.200
     4.469    67.438     0.200
     4.564    69.977     0.200
     5.042    75.812     0.200
     5.189    77.852     0.200
     5.247    78.828     0.200
     5.484    81.844     0.200
     5.807    86.578     0.200
     6.011    89.375     0.200
     6.049    89.734     0.200
     2.146    37.082     0.200
     2.430    41.711     0.200
     2.715    45.094     0.200
     3.271    53.254     0.200
     1.683    28.781     0.200
     1.896    32.016     0.200
     2.022    32.578     0.200
     2.078    33.078     0.200
     1.560    26.805     0.200
     1.931    31.938     0.200
     2.733    42.500     0.200
     2.668    42.547     0.200
     3.066    48.039     0.200
     3.337    51.438     0.200
     2.917    47.500     0.200
     3.018    48.227     0.200
     3.766    57.711     0.200
     3.856    61.250     0.200
     3.872    60.164     0.200
     3.905    59.602     0.200
     3.948    62.680     0.200
     3.933    61.141     0.200
     4.241    67.180     0.200
     4.250    63.305     0.200
     4.301    65.109     0.200
     4.315    64.031     0.200
     4.330    66.305     0.200
     4.437    68.914     0.200
     4.456    68.289     0.200
     4.466    67.656     0.200
     4.737    73.945     0.200
     4.766    73.781     0.200
     4.802    73.078     0.200
     4.685    72.797     0.200
     5.013    76.516     0.200
     5.180    78.016     0.200
     5.055    79.750     0.200
     5.498    82.766     0.200
     5.488    82.000     0.200
     5.603    84.484     0.200
     8.350   118.828     0.200
    11.127   162.586     0.200
     1.435    26.102     0.200
     2.127    37.145     0.200
     2.382    41.512     0.200
     2.687    44.465     0.200
     1.524    26.113     0.200
     2.128    34.854     0.200
     2.142    35.313     0.200
     2.526    42.333     0.200
     2.789    46.483     0.200
     3.002    48.054     0.200
     3.030    49.514     0.200
     3.227    51.273     0.200
     3.191    52.264     0.200
     3.357    53.974     0.200
     3.862    61.903     0.200
     0.211     7.186     0.200
     0.842    15.096     0.200
     0.969    17.355     0.200
     1.000    17.775     0.200
     1.072    19.115     0.200
     1.103    19.295     0.200
     1.107    19.914     0.200
     1.118    20.244     0.200
     1.160    20.754     0.200
     1.231    20.715     0.200
     1.407    24.365     0.200
     1.443    23.875     0.200
     1.539    26.664     0.200
     1.602    26.914     0.200
     1.873    29.445     0.200
     2.221    36.484     0.200
     2.252    35.635     0.200
     2.536    38.885     0.200
     2.516    39.834     0.200
     2.733    42.115     0.200
     2.854    41.945     0.200
     2.913    46.885     0.200
     0.235     8.094     0.200
     0.752    13.934     0.200
     0.883    16.273     0.200
     0.911    17.043     0.200
     0.994    17.855     0.200
     1.013    18.145     0.200
     1.032    18.875     0.200
     1.040    19.113     0.200
     1.082    19.594     0.200
     1.247    20.625     0.200
     1.205    20.984     0.200
     1.277    22.285     0.200
     1.338    23.254     0.200
     1.464    25.516     0.200
     1.615    27.465     0.200
     1.968    30.402     0.200
     2.194    35.355     0.200
     2.257    35.965     0.200
     2.367    39.176     0.200
     2.630    39.883     0.200
     2.814    45.402     0.200
     3.548    55.723     0.200
     1.220    21.047     0.200
     1.740    29.047     0.200
     1.824    29.914     0.200
     2.403    39.219     0.200
     2.668    43.297     0.200
     3.406    53.055     0.200
     3.562    56.734     0.200
     3.626    58.539     0.200
     3.705    55.789     0.200
     3.705    59.664     0.200
     3.714    58.930     0.200
     3.806    57.961     0.200
     3.854    58.688     0.200
     4.041    62.656     0.200
     4.051    63.641     0.200
     4.132    62.859     0.200
     4.144    63.258     0.200
     4.177    62.938     0.200
     4.223    63.406     0.200
     4.227    64.164     0.200
     4.252    63.375     0.200
     4.281    64.617     0.200
     4.286    67.047     0.200
     4.294    64.148     0.200
     4.333    65.477     0.200
     4.310    65.984     0.200
     4.324    65.414     0.200
     4.331    64.859     0.200
     4.351    65.984     0.200
     4.388    66.594     0.200
     4.412    66.180     0.200
     4.464    67.805     0.200
     4.486    69.586     0.200
     4.518    69.164     0.200
     4.542    68.594     0.200
     4.548    68.766     0.200
     4.716    70.445     0.200
     4.834    76.250     0.200
     4.866    74.820     0.200
     5.121    76.484     0.200
     5.244    78.844     0.200
     5.528    82.750     0.200
     8.731   128.383     0.200
     9.922   142.766     0.200
     1.330    23.906     0.200
     1.848    31.156     0.200
     2.064    35.477     0.200
     2.576    41.625     0.200
     2.856    47.617     0.200
     3.284    54.094     0.200
     3.666    59.219     0.200
     3.686    59.469     0.200
     3.716    61.719     0.200
     2.526    40.013     0.200
     2.799    42.942     0.200
     3.335    51.053     0.200
     4.251    63.093     0.200
     4.687    71.513     0.200
     4.746    71.753     0.200
     4.949    74.322     0.200
     0.074    10.336     0.200
     0.121    10.688     0.200
     0.139    10.758     0.200
     0.205    10.945     0.200
     0.330    12.137     0.200
     0.334    11.906     0.200
     0.354    12.496     0.200
     0.386    12.727     0.200
     0.387    12.656     0.200
     0.532    13.117     0.200
     0.591    13.918     0.200
     0.697    14.918     0.200
     0.755    15.766     0.200
     0.919    17.348     0.200
     0.993    18.055     0.200
     1.243    21.637     0.200
     1.292    22.875     0.200
     1.380    24.258     0.200
     1.563    27.984     0.200
     1.578    26.305     0.200
     1.611    27.508     0.200
     1.668    26.168     0.200
     1.894    31.066     0.200
     1.973    31.848     0.200
     2.038    34.016     0.200
     2.434    40.316     0.200
     2.700    41.086     0.200
     2.761    43.824     0.200
     3.366    51.227     0.200
     3.957    59.734     0.200
    10.085   145.395     0.200
     0.592    13.625     0.200
     0.692    15.016     0.200
     0.901    17.527     0.200
     1.111    18.887     0.200
     1.381    22.895     0.200
     1.398    23.605     0.200
     1.334    23.617     0.200
     1.395    24.027     0.200
     1.421    24.594     0.200
     1.442    24.797     0.200
     1.451    24.688     0.200
     1.467    25.438     0.200
     1.498    25.605     0.200
     1.580    26.336     0.200
     1.619    26.605     0.200
     1.682    27.484     0.200
     1.759    28.465     0.200
     1.895    30.805     0.200
     1.981    31.195     0.200
     2.334    36.957     0.200
     2.376    37.324     0.200
     2.561    39.246     0.200
     2.659    41.566     0.200
     2.661    41.566     0.200
     2.714    43.547     0.200
     2.918    46.195     0.200
     3.041    47.285     0.200
     3.047    48.715     0.200
     3.611    54.137     0.200
     3.726    57.047     0.200
     3.787    57.766     0.200
     4.030    61.176     0.200
     4.353    65.715     0.200
     4.548    68.785     0.200
     4.607    68.234     0.200
     4.996    74.777     0.200
     5.617    82.496     0.200
     1.494    25.656     0.200
     1.614    26.109     0.200
     2.483    38.422     0.200
     2.442    39.984     0.200
     2.657    43.445     0.200
     2.811    45.000     0.200
     3.090    48.031     0.200
     3.077    49.375     0.200
     3.499    53.125     0.200
     3.604    54.195     0.200
     3.653    57.703     0.200
     4.510    70.312     0.200
     0.204    13.629     0.200
     1.050    20.598     0.200
     1.060    21.049     0.200
     1.079    21.018     0.200
     1.100    21.508     0.200
     1.113    21.809     0.200
     1.152    21.168     0.200
     1.136    21.857     0.200
     1.159    21.758     0.200
     1.152    21.607     0.200
     1.237    21.338     0.200
     1.297    23.008     0.200
     1.321    23.318     0.200
     1.334    23.748     0.200
     1.252    24.119     0.200
     1.861    29.809     0.200
     2.139    32.838     0.200
     2.444    37.018     0.200
     2.440    37.699     0.200
     2.527    40.027     0.200
     2.929    45.928     0.200
     3.005    45.678     0.200
     2.993    46.629     0.200
     3.456    52.988     0.200
     3.613    56.668     0.200
     3.645    54.119     0.200
     4.021    60.238     0.200
     4.055    61.758     0.200
     4.145    62.949     0.200
     1.539    27.900     0.200
     1.039    21.910     0.200
     1.359    26.000     0.200
     1.214    23.371     0.200
     2.153    37.660     0.200
     1.410    27.400     0.200
     2.697    44.791     0.200
     3.239    54.910     0.200
     0.674    15.155     0.200
     0.720    15.885     0.200
     0.932    19.205     0.200
     1.247    21.125     0.200
     1.241    19.995     0.200
     1.259    23.725     0.200
     1.570    25.925     0.200
     1.564    26.415     0.200
     1.589    27.095     0.200
     1.593    26.885     0.200
     1.611    27.325     0.200
     1.622    27.085     0.200
     1.635    27.895     0.200
     1.665    28.225     0.200
     1.742    27.535     0.200
     1.682    28.085     0.200
     1.737    28.895     0.200
     1.829    29.315     0.200
     1.791    29.145     0.200
     1.847    30.065     0.200
     1.918    31.145     0.200
     2.077    32.525     0.200
     2.175    34.095     0.200
     2.304    36.195     0.200
     2.403    37.315     0.200
     2.487    39.835     0.200
     2.493    40.175     0.200
     2.461    40.225     0.200
     2.446    38.825     0.200
     2.491    40.665     0.200
     2.561    39.545     0.200
     2.538    40.625     0.200
     2.547    37.925     0.200
     2.647    41.965     0.200
     2.753    43.725     0.200
     2.771    43.355     0.200
     2.814    44.335     0.200
     2.875    44.195     0.200
     2.829    45.015     0.200
     2.833    43.355     0.200
     2.843    44.835     0.200
     2.843    45.515     0.200
     2.844    46.355     0.200
     2.844    46.675     0.200
     2.854    45.935     0.200
     2.886    42.625     0.200
     2.927    45.755     0.200
     2.970    46.715     0.200
     3.039    46.035     0.200
     3.084    47.565     0.200
     3.285    52.495     0.200
     3.261    49.075     0.200
     3.263    50.825     0.200
     3.315    52.935     0.200
     3.318    52.855     0.200
     3.327    52.125     0.200
     3.445    52.325     0.200
     3.399    51.865     0.200
     3.399    52.785     0.200
     3.502    53.325     0.200
     3.554    55.245     0.200
     3.615    55.975     0.200
     3.620    54.815     0.200
     3.746    56.245     0.200
     3.859    59.475     0.200
     3.994    60.145     0.200
     3.960    60.475     0.200
     4.072    61.255     0.200
     4.182    64.145     0.200
     4.135    62.725     0.200
     4.376    66.905     0.200
     4.438    66.185     0.200
     4.513    68.575     0.200
     4.480    67.725     0.200
     4.510    67.665     0.200
     4.588    69.715     0.200
     4.559    68.765     0.200
     4.719    71.575     0.200
     4.828    73.125     0.200
     5.064    75.495     0.200
     5.143    76.965     0.200
     5.369    80.175     0.200
     5.447    80.475     0.200
     6.433    94.735     0.200
     6.640    97.485     0.200
     7.063   103.159     0.200
     7.063   103.475     0.200
     7.082   104.565     0.200
    10.682   154.065     0.200
    13.137   184.884     0.200
     0.476     9.750     0.200
     1.085    18.691     0.200
     1.115    18.859     0.200
     1.224    21.043     0.200
     1.266    21.520     0.200
     1.261    21.582     0.200
     1.266    21.812     0.200
     1.287    22.051     0.200
     1.294    22.422     0.200
     1.310    22.770     0.200
     1.334    23.242     0.200
     1.374    23.852     0.200
     1.376    22.922     0.200
     1.452    25.691     0.200
     1.444    24.430     0.200
     1.535    24.672     0.200
     1.575    26.121     0.200
     1.576    26.359     0.200
     1.769    28.090     0.200
     1.729    28.633     0.200
     1.982    30.223     0.200
     2.050    31.570     0.200
     1.985    33.242     0.200
     2.196    34.031     0.200
     2.179    30.250     0.200
     2.385    37.781     0.200
     2.346    38.281     0.200
     2.361    35.992     0.200
     2.442    37.680     0.200
     2.593    40.730     0.200
     2.739    42.500     0.200
     2.741    43.723     0.200
     2.805    42.730     0.200
     2.980    45.082     0.200
     3.111    47.391     0.200
     3.080    47.660     0.200
     3.218    49.551     0.200
     3.344    50.543     0.200
     3.589    53.859     0.200
     3.915    58.422     0.200
     4.028    63.500     0.200
     4.064    62.012     0.200
     4.078    61.949     0.200
     4.115    62.633     0.200
     4.183    63.141     0.200
     4.366    63.402     0.200
     4.402    66.832     0.200
     4.430    66.082     0.200
     4.516    67.980     0.200
     4.521    68.270     0.200
     4.837    72.371     0.200
     4.932    71.793     0.200
     4.977    74.992     0.200
     5.217    79.133     0.200
     5.257    76.230     0.200
     5.288    79.031     0.200
     1.374    26.277     0.200
     1.557    28.426     0.200
     2.159    35.105     0.200
     2.345    40.906     0.200
     2.700    44.988     0.200
     2.998    50.066     0.200
     2.389    37.470     0.200
     2.366    39.120     0.200
     2.409    37.610     0.200
     2.473    37.640     0.200
     2.473    37.870     0.200
     2.596    39.970     0.200
     2.675    40.680     0.200
     2.881    42.550     0.200
     3.049    47.570     0.200
     3.089    50.230     0.200
     3.107    48.680     0.200
     3.172    50.580     0.200
     3.162    48.420     0.200
     3.222    48.370     0.200
     3.225    49.300     0.200
     3.261    51.600     0.200
     3.291    50.240     0.200
     3.300    50.140     0.200
     3.295    49.950     0.200
     4.220    65.150     0.200
     4.441    68.740     0.200
     4.761    73.740     0.200
     1.415    25.831     0.200
     2.070    36.501     0.200
     2.146    36.831     0.200
     2.346    40.291     0.200
     2.416    40.871     0.200
     2.409    41.602     0.200
     3.092    50.541     0.200
     3.191    52.611     0.200
     3.265    54.661     0.200
     3.256    52.741     0.200
     0.853    16.242     0.200
     0.912    16.375     0.200
     1.012    16.742     0.200
     1.145    19.383     0.200
     1.423    22.852     0.200
     1.413    22.594     0.200
     1.574    25.582     0.200
     1.624    26.953     0.200
     1.738    28.031     0.200
     1.839    29.434     0.200
     1.882    30.754     0.200
     1.899    31.074     0.200
     1.892    30.395     0.200
     1.929    31.664     0.200
     1.968    32.293     0.200
     1.996    31.875     0.200
     1.920    31.414     0.200
     2.133    33.484     0.200
     2.168    32.395     0.200
     2.183    34.172     0.200
     2.571    42.145     0.200
     2.604    38.543     0.200
     2.703    43.234     0.200
     2.971    44.125     0.200
     3.033    45.863     0.200
     3.198    49.043     0.200
     3.301    49.613     0.200
     3.604    54.852     0.200
     3.844    57.492     0.200
     3.986    60.094     0.200
     4.303    64.574     0.200
     4.321    64.652     0.200
     4.406    67.223     0.200
     4.428    68.203     0.200
     4.701    70.652     0.200
     4.730    70.914     0.200
     4.728    73.625     0.200
     4.999    74.984     0.200
     0.298     7.639     0.200
     0.759    13.829     0.200
     0.882    16.219     0.200
     0.916    16.879     0.200
     0.957    17.409     0.200
     0.978    17.849     0.200
     0.981    18.099     0.200
     1.012    18.549     0.200
     1.022    18.009     0.200
     1.025    18.929     0.200
     1.067    19.449     0.200
     1.161    20.189     0.200
     1.176    20.359     0.200
     1.265    22.109     0.200
     1.310    23.009     0.200
     1.379    23.479     0.200
     1.531    26.759     0.200
     1.597    25.599     0.200
     1.920    29.909     0.200
     1.961    33.099     0.200
     2.153    34.399     0.200
     2.417    38.329     0.200
     2.581    39.299     0.200
     2.740    43.789     0.200
     2.765    42.839     0.200
     2.845    44.699     0.200
     0.062     6.266     0.200
     0.883    15.525     0.200
     1.131    19.846     0.200
     1.136    19.887     0.200
     1.148    20.375     0.200
     1.149    20.045     0.200
     1.193    21.105     0.200
     1.235    21.766     0.200
     1.414    23.105     0.200
     1.425    24.227     0.200
     1.504    25.766     0.200
     1.583    27.826     0.200
     1.627    26.355     0.200
     1.621    27.545     0.200
     1.784    29.676     0.200
     1.957    30.756     0.200
     1.955    32.816     0.200
     2.404    38.746     0.200
     2.468    39.955     0.200
     2.618    39.756     0.200
     2.644    42.836     0.200
     2.872    44.406     0.200
     3.227    50.816     0.200
     3.590    54.346     0.200
     3.673    57.637     0.200
     0.716    14.379     0.200
     0.780    15.168     0.200
     0.992    18.539     0.200
     1.174    19.066     0.200
     1.227    20.668     0.200
     1.336    23.457     0.200
     1.437    23.289     0.200
     1.539    25.227     0.200
     1.548    25.996     0.200
     1.575    26.559     0.200
     1.577    26.297     0.200
     1.594    26.629     0.200
     1.597    26.129     0.200
     7.103   103.609     0.200
    10.731   152.906     0.200
    11.772   166.918     0.200
     1.238    21.043     0.200
     1.886    30.266     0.200
     1.787    29.664     0.200
     2.012    33.445     0.200
     2.316    36.773     0.200
     2.490    38.836     0.200
     2.744    43.105     0.200
     2.810    44.953     0.200
     3.013    47.477     0.200
     3.585    54.125     0.200
     3.500    54.754     0.200
     1.223    21.914     0.200
     1.506    25.832     0.200
     1.649    28.184     0.200
     1.896    31.641     0.200
     1.854    30.383     0.200
     1.902    31.332     0.200
     2.041    35.492     0.200
     2.021    33.992     0.200
     2.258    36.914     0.200
     2.189    37.223     0.200
     2.433    40.383     0.200
     2.529    40.672     0.200
     2.724    44.133     0.200
     2.770    45.801     0.200
     2.893    45.902     0.200
     2.962    49.051     0.200
     2.989    48.961     0.200
     3.030    48.523     0.200
     3.142    53.383     0.200
     3.190    51.051     0.200
     3.205    53.383     0.200
     3.214    53.074     0.200
     3.224    51.941     0.200
     3.260    54.262     0.200
     3.257    56.031     0.200
     3.306    55.371     0.200
     3.347    54.980     0.200
     3.351    53.922     0.200
     3.382    55.812     0.200
     3.383    55.262     0.200
     3.399    57.801     0.200
     3.552    56.691     0.200
     3.642    57.574     0.200
     3.630    58.633     0.200
     3.641    58.172     0.200
     3.643    58.172     0.200
     3.751    60.254     0.200
     3.746    60.891     0.200
     3.802    59.391     0.200
     3.792    60.453     0.200
     3.793    60.453     0.200
     3.809    60.242     0.200
     4.012    64.332     0.200
     4.174    65.641     0.200
     4.331    67.293     0.200
     4.387    67.113     0.200
     4.336    67.691     0.200
     4.621    72.574     0.200
     4.752    73.254     0.200
     4.674    72.863     0.200
     5.020    76.980     0.200
     5.406    81.922     0.200
     5.454    82.133     0.200
     5.454    82.133     0.200
     7.189   106.172     0.200
     9.276   136.844     0.200
    11.209   161.141     0.200
    11.209   162.578     0.200
    11.209   163.031     0.200
    12.500   183.332     0.200
    13.435   193.121     0.200
    13.759   198.094     0.200
    14.022   198.492     0.200
    15.054   210.914     0.200
    16.442   228.582     0.200
    17.135   241.996     0.200
     0.969    17.332     0.200
     1.158    16.701     0.200
     1.289    22.092     0.200
     1.697    28.051     0.200
     1.806    29.602     0.200
     2.403    38.221     0.200
     1.281    22.408     0.200
     2.079    32.609     0.200
     2.613    40.338     0.200
     3.271    50.520     0.200
     3.342    53.529     0.200
     3.878    59.338     0.200
     1.505    25.133     0.200
     1.595    27.094     0.200
     1.859    30.652     0.200
     1.718    28.832     0.200
     2.025    33.082     0.200
     2.518    39.344     0.200
     2.830    45.391     0.200
     2.629    42.152     0.200
     2.802    45.160     0.200
     0.906    15.209     0.200
     0.937    16.709     0.200
     1.196    20.180     0.200
     1.183    20.490     0.200
     1.442    23.900     0.200
     1.526    25.010     0.200
     1.516    25.029     0.200
     1.544    25.469     0.200
     1.557    25.930     0.200
     1.554    26.500     0.200
     1.590    27.010     0.200
     1.715    27.080     0.200
     1.690    27.330     0.200
     1.656    28.119     0.200
     1.841    29.049     0.200
     1.767    29.330     0.200
     1.823    27.900     0.200
     1.938    30.889     0.200
     1.954    31.270     0.200
     2.369    35.539     0.200
     2.687    41.990     0.200
     2.726    40.570     0.200
     2.638    41.080     0.200
     2.751    43.320     0.200
     3.038    47.260     0.200
     3.192    49.619     0.200
     3.545    53.420     0.200
     0.362     9.023     0.200
     1.077    18.391     0.200
     1.194    20.461     0.200
     1.178    20.109     0.200
     1.231    21.141     0.200
     1.249    21.578     0.200
     1.273    22.047     0.200
     1.279    22.375     0.200
     1.301    22.711     0.200
     1.339    22.414     0.200
     1.320    23.117     0.200
     1.362    23.719     0.200
     1.448    24.641     0.200
     1.608    25.844     0.200
     1.581    26.578     0.200
     1.841    29.156     0.200
     1.727    28.734     0.200
     1.908    29.406     0.200
     2.118    32.656     0.200
     2.270    35.258     0.200
     2.096    34.461     0.200
     2.275    34.484     0.200
     2.514    38.469     0.200
     2.389    37.961     0.200
     2.491    38.859     0.200
     2.585    41.359     0.200
     2.632    42.977     0.200
     2.703    42.656     0.200
     2.814    43.617     0.200
     2.880    43.641     0.200
     2.853    44.234     0.200
     3.067    47.156     0.200
     3.167    48.586     0.200
     3.212    48.641     0.200
     3.292    50.195     0.200
     3.426    51.219     0.200
     3.343    51.766     0.200
     3.647    55.766     0.200
     3.648    55.516     0.200
     3.736    57.055     0.200
     3.995    58.773     0.200
     4.141    61.398     0.200
     4.170    63.375     0.200
     4.178    63.586     0.200
     4.262    63.930     0.200
     4.275    64.180     0.200
     4.194    63.945     0.200
     4.351    64.758     0.200
     4.419    66.430     0.200
     4.424    66.641     0.200
     4.483    67.641     0.200
     4.619    69.016     0.200
     4.610    68.625     0.200
     4.939    73.828     0.200
     5.014    74.148     0.200
     5.072    76.156     0.200
     5.397    79.555     0.200
     5.363    79.445     0.200
     5.439    80.320     0.200
     5.506    80.867     0.200
     5.926    81.547     0.200
     1.357    23.594     0.200
     1.472    25.805     0.200
     2.060    33.398     0.200
     2.343    36.914     0.200
     2.275    38.484     0.200
     2.643    42.391     0.200
     2.590    42.539     0.200
     2.685    44.273     0.200
     2.663    43.703     0.200
     2.729    44.344     0.200
     2.697    43.414     0.200
     2.876    45.461     0.200
     2.763    44.570     0.200
     2.757    46.133     0.200
     2.813    46.602     0.200
     2.940    47.539     0.200
     2.924    48.055     0.200
     3.083    47.648     0.200
     3.004    47.664     0.200
     3.126    50.812     0.200
     3.264    51.523     0.200
     3.356    52.266     0.200
     3.258    52.695     0.200
     3.388    54.703     0.200
     3.415    55.305     0.200
     3.477    56.695     0.200
     3.992    61.602     0.200
     4.118    63.023     0.200
     4.138    60.680     0.200
     4.178    67.320     0.200
     4.454    67.320     0.200
     4.438    67.695     0.200
     4.419    69.984     0.200
     4.702    72.078     0.200
     4.653    69.375     0.200
     5.027    76.023     0.200
     5.077    77.055     0.200
     5.097    78.625     0.200
     2.189    35.236     0.200
     2.475    39.226     0.200
     2.969    45.866     0.200
     3.031    49.186     0.200
     3.218    49.856     0.200
     3.262    50.786     0.200
     3.497    53.116     0.200
     3.674    56.846     0.200
     4.069    61.146     0.200
     4.613    68.976     0.200
     1.599    28.625     0.200
     2.374    39.926     0.200
     2.340    39.805     0.200
     2.502    42.617     0.200
     2.658    43.086     0.200
     2.960    48.348     0.200
     2.932    49.906     0.200
     2.943    48.574     0.200
     2.994    49.906     0.200
     2.975    49.906     0.200
     3.006    49.906     0.200
     3.047    50.645     0.200
     3.084    49.906     0.200
     3.119    52.695     0.200
     3.092    49.246     0.200
     3.099    50.574     0.200
     3.126    51.895     0.200
     3.125    50.574     0.200
     3.192    49.945     0.200
     3.256    54.266     0.200
     3.231    52.395     0.200
     3.141    52.445     0.200
     3.231    53.848     0.200
     3.191    53.066     0.200
     3.237    54.555     0.200
     3.413    55.227     0.200
     3.580    58.695     0.200
     3.598    58.477     0.200
     3.612    58.348     0.200
     3.667    58.777     0.200
     3.816    61.668     0.200
     4.164    64.527     0.200
     4.098    64.855     0.200
     4.221    66.484     0.200
     4.284    67.848     0.200
     4.210    68.516     0.200
     4.379    68.516     0.200
     4.553    71.168     0.200
     4.562    71.168     0.200
     4.698    72.156     0.200
     4.858    75.156     0.200
     4.906    75.375     0.200
     4.938    75.816     0.200
     4.980    76.785     0.200
     5.172    79.445     0.200
     5.267    78.098     0.200
     5.279    77.816     0.200
     5.362    81.938     0.200
     5.941    90.938     0.200
     5.914    89.586     0.200
     6.157    92.695     0.200
     6.071    94.574     0.200
     7.108   105.336     0.200
     7.560   114.086     0.200
     1.540    26.051     0.200
     2.216    37.701     0.200
     3.030    47.090     0.200
     3.483    54.939     0.200
     3.504    56.100     0.200
     3.862    58.980     0.200
     3.941    62.320     0.200
     3.952    60.920     0.200
     3.953    61.721     0.200
     3.955    62.791     0.200
     3.955    62.203     0.200
     3.958    63.980     0.200
     3.958    58.840     0.200
     3.970    58.910     0.200
     3.979    59.070     0.200
     3.988    59.061     0.200
     3.996    61.211     0.200
     3.999    63.910     0.200
     4.031    64.811     0.200
     4.038    62.439     0.200
     4.142    64.980     0.200
     4.216    65.910     0.200
     4.229    65.391     0.200
     4.357    65.461     0.200
     4.359    67.650     0.200
     4.432    69.330     0.200
     4.434    69.301     0.200
     4.522    70.121     0.200
     4.595    70.291     0.200
     4.595    70.090     0.200
     4.619    70.641     0.200
     4.936    74.820     0.200
     5.258    79.590     0.200
     5.374    80.090     0.200
     5.374    79.711     0.200
     5.453    79.990     0.200
     5.410    81.740     0.200
     5.618    85.439     0.200
     5.618    84.990     0.200
     5.726    86.170     0.200
     5.923    88.590     0.200
     5.898    88.830     0.200
     6.108    86.500     0.200
     6.393    94.561     0.200
     6.412    95.850     0.200
     6.730   101.900     0.200
     7.162   104.971     0.200
     7.224   107.490     0.200
     7.400   108.820     0.200
     7.532   112.811     0.200
     8.131   118.709     0.200
     8.431   122.891     0.200
     8.553   126.391     0.200
     8.610   127.689     0.200
     8.610   127.844     0.200
     8.798   128.721     0.200
     8.783   126.791     0.200
     9.408   138.750     0.200
     9.461   137.061     0.200
     9.846   143.189     0.200
    10.032   146.391     0.200
    10.222   149.029     0.200
    10.214   148.166     0.200
    10.340   150.141     0.200
    10.604   154.500     0.200
    10.720   156.689     0.200
    10.720   156.930     0.200
    10.719   155.166     0.200
    10.719   156.221     0.200
    10.877   157.518     0.200
    10.877   158.359     0.200
    10.952   159.230     0.200
    11.048   160.711     0.200
    11.119   160.990     0.200
    11.395   165.670     0.200
    11.464   162.721     0.200
    11.464   163.189     0.200
    11.925   172.641     0.200
    11.993   172.990     0.200
    11.993   172.859     0.200
    12.541   180.785     0.200
    13.059   188.260     0.200
    12.967   184.270     0.200
    13.201   187.090     0.200
    13.201   186.590     0.200
    14.253   200.059     0.200
    14.253   198.924     0.200
    14.253   197.900     0.200
    16.592   230.221     0.200
     7.224   107.180     0.200
     2.215    36.902     0.200
     3.947    62.055     0.200
     4.246    65.113     0.200
     4.580    69.574     0.200
     8.117   118.344     0.200
     9.472   134.625     0.200
    10.225   146.195     0.200
    10.237   145.562     0.200
    10.354   146.504     0.200
    10.618   150.895     0.200
    10.738   156.582     0.200
    10.739   156.875     0.200
    10.862   156.102     0.200
    10.965   156.324     0.200
    11.060   158.562     0.200
    11.774   166.223     0.200
    12.197   173.715     0.200
    12.564   178.055     0.200
    12.696   180.164     0.200
    12.740   181.945     0.200
    13.038   187.992     0.200
    13.047   186.082     0.200
    13.107   188.395     0.200
    13.102   185.902     0.200
    13.228   188.172     0.200
    13.211   187.973     0.200
    13.211   187.332     0.200
    13.253   188.934     0.200
    13.343   191.652     0.200
    13.398   192.523     0.200
    13.433   192.172     0.200
    13.490   191.973     0.200
    13.525   192.574     0.200
    13.555   192.352     0.200
    13.601   193.773     0.200
    13.737   194.832     0.200
    14.243   202.254     0.200
    14.371   203.023     0.200
    14.540   205.445     0.200
    14.582   206.164     0.200
    14.881   208.574     0.200
    15.197   212.805     0.200
    15.360   215.523     0.200
     2.264    36.785     0.200
     3.994    60.266     0.200
     4.275    64.918     0.200
     4.404    66.465     0.200
     4.574    69.395     0.200
     4.617    69.348     0.200
     4.638    69.797     0.200
     4.653    70.156     0.200
     4.962    74.145     0.200
     5.283    78.824     0.200
     5.430    80.918     0.200
     5.505    82.406     0.200
     5.645    83.848     0.200
     5.649    84.055     0.200
     5.744    85.008     0.200
     5.950    87.895     0.200
     5.951    88.027     0.200
     6.217    91.566     0.200
     6.406    94.176     0.200
     8.155   116.988     0.200
     9.512   135.895     0.200
    10.270   148.156     0.200
    10.390   147.668     0.200
    10.653   152.355     0.200
    10.760   154.547     0.200
    10.760   151.672     0.200
    10.761   152.918     0.200
    10.900   155.484     0.200
    11.768   166.465     0.200
    12.314   170.816     0.200
    12.235   169.945     0.200
    12.336   172.246     0.200
    12.720   177.996     0.200
    12.765   178.316     0.200
    12.747   176.848     0.200
    12.914   178.227     0.200
    13.062   181.438     0.200
    13.129   182.836     0.200
    13.253   188.047     0.200
    13.328   182.957     0.200
    13.883   192.875     0.200
    14.290   198.316     0.200
     1.510    25.988     0.200
     2.360    38.609     0.200
     3.619    55.508     0.200
     3.985    60.559     0.200
     4.065    60.820     0.200
     4.077    61.520     0.200
     4.077    62.031     0.200
     4.084    60.750     0.200
     4.093    60.879     0.200
     4.102    64.000     0.200
     4.113    63.680     0.200
     4.161    63.840     0.200
     4.263    63.941     0.200
     4.339    66.648     0.200
     4.358    66.680     0.200
     4.404    67.078     0.200
     4.497    68.129     0.200
     4.674    70.309     0.200
     4.671    71.488     0.200
     4.730    70.031     0.200
     5.023    74.508     0.200
     5.344    77.629     0.200
     5.423    79.180     0.200
     5.483    81.609     0.200
     5.602    82.770     0.200
     5.733    85.098     0.200
     6.050    89.141     0.200
     6.443    95.059     0.200
     6.487    96.398     0.200
     7.251   105.430     0.200
     9.607   138.160     0.200
    10.358   148.891     0.200
    10.831   156.770     0.200
    10.831   157.238     0.200
    10.831   157.430     0.200
    12.361   178.461     0.200
     7.373   106.809     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.542    46.021     0.200
     2.950    61.047     0.200
     3.145    57.961     0.200
     3.649    65.911     0.200
     6.522   121.477     0.200
     2.887    55.945     0.200
     3.305    67.076     0.200
     2.872    52.770     0.200
    10.183   190.805     0.200
     3.166    57.633     0.200
     2.857    52.990     0.200
     2.637    48.492     0.200
     2.948    54.977     0.200
     2.980    55.328     0.200
     3.310    61.566     0.200
     3.544    64.867     0.200
     3.477    65.203     0.200
     4.544    84.094     0.200
     2.955    54.115     0.200
     4.080    74.154     0.200
     3.846    70.719     0.200
     3.938    72.051     0.200
     3.561    65.148     0.200
     3.430    63.262     0.200
     2.999    55.523     0.200
     2.929    55.810     0.200
     2.996    54.906     0.200
     3.641    66.305     0.200
     3.628    66.781     0.200
     2.876    52.789     0.200
     2.622    50.291     0.200
     3.000    55.238     0.200
     3.651    66.380     0.200
     3.046    55.473     0.200
     3.023    58.348     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     4.111    67.219     0.200
     4.121    68.719     0.200
     0.731    14.396     0.200
     0.085     5.508     0.200
     3.768    62.883     0.200
     3.342    55.641     0.200
     1.220    22.715     0.200
     2.480    41.715     0.200
     1.271    23.521     0.200
     4.004    66.521     0.200
     4.489    77.275     0.200
     1.744    31.719     0.200
     4.454    73.388     0.200
     6.360   108.246     0.200
     2.050    35.148     0.200
     3.358    56.320     0.200
     3.459    56.938     0.200
     3.566    58.438     0.200
     1.198    21.906     0.200
     2.965    50.953     0.200
     3.016    52.562     0.200
     5.675    96.766     0.200
     3.864    64.555     0.200
     3.980    65.219     0.200
     3.907    65.414     0.200
     4.029    66.622     0.200
     1.846    32.645     0.200
     2.034    35.645     0.200
     2.100    36.426     0.200
     3.354    55.637     0.200
     3.876    64.367     0.200
     4.266    71.855     0.200
     2.851    48.051     0.200
     3.333    54.812     0.200
     3.526    57.636     0.200
     3.526    59.746     0.200
     2.027    36.588     0.200
     3.330    56.568     0.200
     3.366    58.838     0.200
     3.783    62.828     0.200
     0.929    17.945     0.200
     3.025    53.500     0.200
     3.233    55.102     0.200
     3.408    56.992     0.200
     0.559    11.609     0.200
     2.828    50.062     0.200
     0.820    15.750     0.200
     1.287    24.070     0.200
     4.357    71.469     0.200
     2.311    39.393     0.200
     2.390    40.872     0.200
     3.808    62.473     0.200
     3.969    66.122     0.200
     3.997    67.683     0.200
     0.674    13.531     0.200
     2.682    47.461     0.200
     3.953    65.359     0.200
     0.226     6.266     0.200
     4.242    69.918     0.200
     4.440    76.445     0.200
     2.720    48.186     0.200
     2.905    51.994     0.200
     4.354    71.125     0.200
     0.489     9.883     0.200
     2.697    49.066     0.200
     3.235    56.383     0.200
     3.735    63.215     0.200
     0.837    16.023     0.200
     1.174    21.781     0.200
     0.961    18.547     0.200
     1.149    22.137     0.200
     0.753    14.561     0.200
     1.167    21.611     0.200
     1.843    31.453     0.200
     3.186    52.875     0.200
     0.483     9.656     0.200
     0.434     9.177     0.200
     0.926    17.126     0.200
     4.358    73.736     0.200
     0.452     9.359     0.200
     2.234    39.250     0.200
     3.135    56.992     0.200
     0.211     5.369     0.200
     0.923    16.979     0.200
     1.140    21.430     0.200
     3.856    64.350     0.200
     4.510    75.689     0.200
     4.817    82.109     0.200
     0.942    17.734     0.200
     5.129    85.945     0.200
     0.733    14.146     0.200
     1.368    25.031     0.200
     1.818    32.471     0.200
     0.081     3.820     0.200
     0.701    13.527     0.200
     1.021    19.336     0.200
     1.888    33.888     0.200
     1.999    35.707     0.200
     2.122    37.508     0.200
     0.950    17.504     0.200
     0.966    17.953     0.200
     2.907    48.031     0.200
     0.442    10.168     0.200
     1.038    19.160     0.200
     1.218    22.699     0.200
     1.245    22.078     0.200
     3.171    54.309     0.200
     0.089     3.861     0.200
     0.954    17.751     0.200
     1.051    18.951     0.200
     1.563    27.971     0.200
     1.966    34.551     0.200
     2.901    49.501     0.200
     3.640    61.551     0.200
     4.565    77.951     0.200
     0.282     5.715     0.200
     0.282     5.455     0.200
     0.559    10.391     0.200
     0.559    10.750     0.200
     0.655    12.281     0.200
     0.655    12.742     0.200
     0.730    13.602     0.200
     0.957    18.242     0.200
     2.025    35.703     0.200
     2.294    39.477     0.200
     3.326    58.203     0.200
     3.973    66.633     0.200
     4.653    80.852     0.200
     6.337   108.633     0.200
     0.612    12.207     0.200
     0.880    16.227     0.200
     0.582    12.094     0.200
     1.342    24.293     0.200
     1.422    25.102     0.200
     1.394    24.703     0.200
     1.495    27.750     0.200
     1.535    27.160     0.200
     1.529    28.184     0.200
     1.530    27.953     0.200
     1.545    28.422     0.200
     2.051    36.070     0.200
     3.180    54.613     0.200
     3.250    58.223     0.200
     3.421    59.402     0.200
     0.108     4.119     0.200
     0.824    14.998     0.200
     0.901    16.889     0.200
     0.997    18.018     0.200
     1.058    19.818     0.200
     1.597    28.619     0.200
     2.369    43.039     0.200
     3.160    56.219     0.200
     3.670    61.328     0.200
     3.815    64.129     0.200
     4.182    70.289     0.200
     0.081     4.254     0.200
     0.876    16.215     0.200
     0.949    17.543     0.200
     1.049    18.875     0.200
     1.107    20.285     0.200
     1.214    22.426     0.200
     1.225    22.586     0.200
     1.257    23.074     0.200
     1.558    27.926     0.200
     2.900    49.676     0.200
     3.173    54.273     0.200
     3.763    67.094     0.200
     3.792    65.535     0.200
     4.015    66.965     0.200
     4.426    76.465     0.200
     0.045     5.426     0.200
     0.904    17.203     0.200
     1.029    18.664     0.200
     1.157    21.664     0.200
     1.166    21.965     0.200
     1.195    22.395     0.200
     1.211    21.746     0.200
     0.564    11.295     0.200
     1.798    31.545     0.200
     1.799    31.545     0.200
     2.274    39.225     0.200
     2.515    43.695     0.200
     2.841    50.105     0.200
     2.841    49.535     0.200
     3.037    53.346     0.200
     3.037    52.996     0.200
     3.272    55.256     0.200
     3.316    56.906     0.200
     3.466    57.965     0.200
     3.579    59.355     0.200
     0.636    11.998     0.200
     0.915    17.558     0.200
     1.145    21.038     0.200
     1.512    27.258     0.200
     1.640    29.218     0.200
     1.643    30.158     0.200
     1.644    30.218     0.200
     1.651    28.988     0.200
     1.667    29.268     0.200
     1.674    30.788     0.200
     1.690    31.027     0.200
     1.722    31.397     0.200
     1.742    30.897     0.200
     2.423    40.788     0.200
     2.736    46.838     0.200
     2.783    47.628     0.200
     1.029    20.781     0.200
     1.074    21.752     0.200
     1.078    21.781     0.200
     1.097    21.912     0.200
     1.120    22.531     0.200
     1.130    22.541     0.200
     2.709    48.121     0.200
     3.778    65.393     0.200
     3.787    65.932     0.200
     3.911    68.521     0.200
     4.010    69.752     0.200
     4.052    69.201     0.200
     4.691    81.092     0.200
     0.937    17.770     0.200
     1.101    20.391     0.200
     1.507    27.129     0.200
     1.627    29.270     0.200
     1.644    30.430     0.200
     1.630    29.141     0.200
     1.630    29.730     0.200
     1.660    29.621     0.200
     1.677    31.059     0.200
     1.741    30.738     0.200
     1.678    29.102     0.200
     3.692    66.289     0.200
     4.168    71.441     0.200
     0.055     4.107     0.200
     0.958    17.217     0.200
     1.000    18.477     0.200
     1.158    21.057     0.200
     1.253    23.098     0.200
     1.262    23.188     0.200
     1.291    23.607     0.200
     1.307    23.906     0.200
     1.311    23.967     0.200
     0.032     3.762     0.200
     0.922    16.762     0.200
     0.950    18.070     0.200
     1.077    19.512     0.200
     1.200    22.730     0.200
     1.209    22.762     0.200
     1.237    23.180     0.200
     1.254    23.602     0.200
     1.258    23.551     0.200
     1.622    28.492     0.200
     2.318    42.371     0.200
     2.378    41.742     0.200
     3.611    60.352     0.200
     0.825    16.600     0.200
     0.849    16.399     0.200
     0.837    16.659     0.200
     0.847    17.039     0.200
     0.858    17.499     0.200
     0.879    17.669     0.200
     0.992    18.949     0.200
     0.934    18.390     0.200
     1.168    21.829     0.200
     2.156    42.970     0.200
     2.703    48.329     0.200
     2.854    51.379     0.200
     2.854    50.149     0.200
     2.872    51.089     0.200
     3.322    56.010     0.200
     3.344    56.489     0.200
     3.421    58.659     0.200
     3.423    58.100     0.200
     3.575    59.720     0.200
     3.789    65.799     0.200
     0.075     3.971     0.200
     3.046    51.070     0.200
     3.036    52.711     0.200
     3.507    59.021     0.200
     3.640    63.291     0.200
     3.958    67.131     0.200
     4.047    68.690     0.200
     4.181    70.951     0.200
     4.230    74.011     0.200
     4.291    72.041     0.200
     0.062     6.344     0.200
     0.057     6.027     0.200
     0.070     6.125     0.200
     0.087     6.406     0.200
     0.103     6.137     0.200
     0.308     7.676     0.200
     0.241     6.586     0.200
     0.301     7.074     0.200
     0.676    12.777     0.200
     1.178    21.945     0.200
     1.139    20.246     0.200
     1.197    22.207     0.200
     1.223    23.938     0.200
     1.413    25.027     0.200
     1.539    27.605     0.200
     1.956    33.785     0.200
     2.451    42.027     0.200
     2.424    43.855     0.200
     3.420    56.504     0.200
     3.861    63.105     0.200
     0.130     5.421     0.200
     1.034    18.661     0.200
     1.063    19.530     0.200
     1.319    23.610     0.200
     1.310    24.301     0.200
     1.318    24.431     0.200
     1.345    24.831     0.200
     1.363    25.161     0.200
     1.367    24.971     0.200
     1.765    31.331     0.200
     1.796    32.440     0.200
     2.137    37.491     0.200
     2.757    47.431     0.200
     3.563    60.261     0.200
     0.787    15.148     0.200
     0.781    15.406     0.200
     1.153    20.500     0.200
     2.209    40.000     0.200
     2.785    49.500     0.200
     3.022    51.750     0.200
     3.103    55.102     0.200
     3.386    57.852     0.200
     3.430    58.898     0.200
     3.481    59.508     0.200
     3.525    60.508     0.200
     3.555    61.172     0.200
     3.603    63.469     0.200
     3.613    63.383     0.200
     0.015     3.935     0.200
     0.916    16.945     0.200
     0.959    17.695     0.200
     1.215    22.695     0.200
     1.224    22.765     0.200
     1.213    21.715     0.200
     1.254    23.075     0.200
     1.270    23.595     0.200
     1.273    23.595     0.200
     1.645    28.415     0.200
     2.017    34.535     0.200
     3.652    60.225     0.200
     0.078     4.725     0.200
     1.023    18.783     0.200
     1.276    23.514     0.200
     1.285    23.543     0.200
     1.277    22.834     0.200
     1.314    24.094     0.200
     1.330    24.453     0.200
     1.334    24.443     0.200
     1.706    30.203     0.200
     2.079    35.395     0.200
     3.125    54.645     0.200
     4.519    76.814     0.200
     0.124     2.711     0.200
     0.306     5.900     0.200
     0.409     7.740     0.200
     0.458     8.660     0.200
     0.587    11.660     0.200
     0.606    12.182     0.200
     0.636    12.512     0.200
     0.647    12.842     0.200
     0.651    13.012     0.200
     0.815    15.541     0.200
     0.874    15.410     0.200
     1.776    32.422     0.200
     2.106    36.791     0.200
     2.197    38.182     0.200
     2.605    47.262     0.200
     2.646    46.791     0.200
     3.334    55.891     0.200
     4.972    82.330     0.200
     0.055     3.668     0.200
     0.851    15.248     0.200
     0.901    16.877     0.200
     1.161    22.098     0.200
     1.153    20.988     0.200
     1.202    22.627     0.200
     1.217    23.018     0.200
     1.219    22.908     0.200
     2.298    40.787     0.200
     2.352    43.418     0.200
     2.439    41.098     0.200
     4.115    68.377     0.200
     4.381    72.438     0.200
     0.729    13.957     0.200
     0.814    15.328     0.200
     1.401    25.195     0.200
     1.764    31.418     0.200
     1.766    31.527     0.200
     1.782    31.719     0.200
     1.807    32.195     0.200
     1.818    32.195     0.200
     2.254    39.836     0.200
     2.178    36.777     0.200
     2.178    37.195     0.200
     2.568    44.629     0.200
     3.070    52.848     0.200
     3.329    57.035     0.200
     3.438    58.086     0.200
     3.457    58.207     0.200
     3.565    61.797     0.200
     3.613    59.316     0.200
     3.689    64.238     0.200
     0.552    11.423     0.200
     1.082    19.812     0.200
     1.227    22.083     0.200
     1.238    22.763     0.200
     1.238    22.973     0.200
     1.276    24.043     0.200
     1.289    24.163     0.200
     1.338    24.003     0.200
     1.882    32.083     0.200
     1.983    34.263     0.200
     2.343    40.183     0.200
     2.540    44.453     0.200
     3.017    53.213     0.200
     0.671    13.183     0.200
     0.752    14.263     0.200
     0.806    15.703     0.200
     0.863    16.533     0.200
     0.865    16.773     0.200
     1.685    30.113     0.200
     2.446    42.183     0.200
     2.517    43.153     0.200
     2.505    42.933     0.200
     0.090     2.214     0.200
     0.534    10.754     0.200
     0.726    14.674     0.200
     0.747    14.833     0.200
     0.767    15.183     0.200
     0.920    17.424     0.200
     1.091    20.044     0.200
     1.975    35.364     0.200
     0.487     9.414     0.200
     0.889    16.424     0.200
     1.094    20.824     0.200
     1.026    19.414     0.200
     1.483    26.793     0.200
     1.878    33.043     0.200
     1.943    34.543     0.200
     1.944    34.703     0.200
     1.980    35.234     0.200
     1.994    35.404     0.200
     2.040    35.674     0.200
     1.982    34.953     0.200
     2.265    42.383     0.200
     2.632    45.344     0.200
     2.720    45.324     0.200
     3.000    51.264     0.200
     3.136    55.383     0.200
     3.638    61.064     0.200
     3.638    61.414     0.200
     3.673    60.404     0.200
     0.635    12.539     0.200
     1.205    23.039     0.200
     1.239    23.641     0.200
     1.254    24.492     0.200
     1.788    33.727     0.200
     2.971    51.898     0.200
     5.116    86.406     0.200
     0.789    15.213     0.200
     1.126    21.152     0.200
     1.502    27.492     0.200
     1.532    27.822     0.200
     1.547    27.992     0.200
     1.614    28.443     0.200
     1.765    30.652     0.200
     2.630    44.252     0.200
     3.164    52.482     0.200
     3.303    54.803     0.200
     3.259    57.752     0.200
     3.347    56.662     0.200
     3.578    60.512     0.200
     3.723    62.023     0.200
     3.723    62.812     0.200
     0.121     4.027     0.200
     0.791    14.465     0.200
     1.108    20.246     0.200
     1.185    22.547     0.200
     1.184    22.574     0.200
     1.607    29.184     0.200
     2.876    50.625     0.200
     0.126     4.380     0.200
     0.829    14.931     0.200
     1.074    20.101     0.200
     1.162    20.950     0.200
     1.188    22.150     0.200
     1.245    23.070     0.200
     1.246    23.101     0.200
     1.748    30.710     0.200
     2.344    41.830     0.200
     2.390    42.910     0.200
     3.188    55.730     0.200
     3.740    63.601     0.200
     4.114    67.440     0.200
     4.202    70.021     0.200
     4.204    69.290     0.200
     0.426     8.680     0.200
     0.659    12.992     0.200
     0.884    16.586     0.200
     1.014    19.430     0.200
     1.065    20.086     0.200
     1.074    20.398     0.200
     2.397    41.031     0.200
     3.995    70.891     0.200
     4.620    76.586     0.200
     0.462    10.152     0.200
     2.888    50.980     0.200
     2.914    48.934     0.200
     3.092    51.113     0.200
     3.208    57.012     0.200
     3.217    53.402     0.200
     3.518    58.832     0.200
     3.690    64.191     0.200
     3.754    62.895     0.200
     1.015    19.197     0.200
     1.147    22.268     0.200
     1.217    24.188     0.200
     1.250    23.947     0.200
     1.223    24.338     0.200
     2.133    37.607     0.200
     2.250    42.357     0.200
     2.669    46.838     0.200
     3.003    53.848     0.200
     3.387    59.068     0.200
     3.471    61.318     0.200
     3.585    64.139     0.200
     3.752    63.648     0.200
     3.915    65.979     0.200
     4.347    73.787     0.200
     0.515    10.539     0.200
     0.559    11.758     0.200
     0.569    11.668     0.200
     0.613    11.838     0.200
     0.645    12.119     0.200
     0.733    14.328     0.200
     2.084    38.439     0.200
     0.743    14.383     0.200
     1.386    26.039     0.200
     2.029    35.359     0.200
     2.024    35.766     0.200
     2.055    36.195     0.200
     2.071    36.188     0.200
     2.874    50.453     0.200
     2.916    49.727     0.200
     2.995    51.578     0.200
     3.087    52.398     0.200
     3.090    52.227     0.200
     3.161    53.312     0.200
     0.439     9.184     0.200
     1.139    20.424     0.200
     1.166    22.264     0.200
     1.167    22.254     0.200
     1.207    23.055     0.200
     1.219    23.043     0.200
     1.249    22.904     0.200
     1.233    23.414     0.200
     1.982    35.055     0.200
     3.294    54.654     0.200
     0.250     5.184     0.200
     1.066    20.242     0.200
     1.193    23.322     0.200
     1.197    23.723     0.200
     1.210    23.613     0.200
     1.221    24.104     0.200
     1.348    25.104     0.200
     1.435    27.072     0.200
     1.659    30.373     0.200
     2.510    45.264     0.200
     2.853    48.723     0.200
     2.988    51.363     0.200
     0.499    10.013     0.200
     0.933    17.033     0.200
     0.993    18.563     0.200
     1.827    32.363     0.200
     1.906    32.643     0.200
     1.871    33.433     0.200
     1.872    33.473     0.200
     1.907    34.303     0.200
     1.922    34.153     0.200
     1.974    34.663     0.200
     1.914    33.953     0.200
     2.716    45.763     0.200
     3.622    61.953     0.200
     3.632    60.553     0.200
     0.260     5.961     0.200
     1.067    20.801     0.200
     1.189    22.070     0.200
     1.214    22.191     0.200
     1.430    25.602     0.200
     1.591    28.680     0.200
     1.513    27.000     0.200
     1.578    28.910     0.200
     1.662    29.301     0.200
     2.036    35.961     0.200
     2.184    37.809     0.200
     2.233    39.621     0.200
     2.546    43.949     0.200
     2.890    48.910     0.200
     2.897    49.512     0.200
     3.007    51.070     0.200
     3.117    51.500     0.200
     3.221    54.070     0.200
     3.378    56.531     0.200
     3.535    58.430     0.200
     3.536    59.469     0.200
     0.057     3.809     0.200
     1.949    34.859     0.200
     2.272    40.930     0.200
     3.220    55.180     0.200
     3.485    59.750     0.200
     0.052     3.684     0.200
     0.855    15.613     0.200
     1.063    19.934     0.200
     1.157    20.934     0.200
     1.220    22.754     0.200
     2.439    42.105     0.200
     0.507    10.137     0.200
     1.007    18.537     0.200
     0.256     5.561     0.200
     1.083    21.031     0.200
     1.196    23.951     0.200
     1.339    26.012     0.200
     1.428    27.211     0.200
     1.638    30.580     0.200
     2.262    40.521     0.200
     2.549    45.660     0.200
     2.728    48.340     0.200
     2.869    49.590     0.200
     2.967    51.730     0.200
     3.143    54.871     0.200
     3.243    57.801     0.200
     3.056    52.721     0.200
     3.322    58.090     0.200
     0.127     3.957     0.200
     1.185    22.719     0.200
     1.885    32.566     0.200
     2.422    41.559     0.200
     2.837    49.277     0.200
     0.122     5.069     0.200
     1.224    22.168     0.200
     1.320    23.579     0.200
     1.371    24.979     0.200
     1.748    31.208     0.200
     2.120    37.749     0.200
     2.431    42.389     0.200
     2.651    44.889     0.200
     2.792    47.679     0.200
     3.072    51.199     0.200
     3.086    52.059     0.200
     3.598    60.249     0.200
     4.464    73.499     0.200
     4.489    74.049     0.200
     4.496    73.958     0.200
     4.533    77.879     0.200
     2.213    37.438     0.200
     2.585    43.828     0.200
     3.853    64.008     0.200
     3.982    65.812     0.200
     4.248    73.039     0.200
     4.275    69.930     0.200
     0.071     4.633     0.200
     1.145    20.734     0.200
     1.237    22.215     0.200
     1.305    23.723     0.200
     0.277     7.555     0.200
     0.874    16.523     0.200
     1.527    26.523     0.200
     1.893    31.984     0.200
     2.334    40.012     0.200
     3.043    52.375     0.200
     3.972    64.543     0.200
     3.975    64.793     0.200
     0.245     5.227     0.200
     1.041    20.039     0.200
     1.236    24.336     0.200
     1.370    26.156     0.200
     1.454    27.555     0.200
     2.291    40.586     0.200
     2.504    45.789     0.200
     2.539    44.719     0.200
     2.568    44.938     0.200
     2.724    49.508     0.200
     2.781    50.852     0.200
     0.188     5.488     0.200
     0.942    19.430     0.200
     1.329    24.668     0.200
     1.470    26.578     0.200
     1.552    27.797     0.200
     2.061    35.090     0.200
     2.177    38.539     0.200
     2.415    42.340     0.200
     2.389    41.137     0.200
     2.662    45.398     0.200
     0.690    13.766     0.200
     2.974    51.430     0.200
     0.802    14.727     0.200
     1.045    19.719     0.200
     1.539    28.555     0.200
     1.437    25.578     0.200
     1.655    29.273     0.200
     1.889    32.984     0.200
     2.668    46.352     0.200
     2.974    49.227     0.200
     0.482    10.172     0.200
     0.973    18.078     0.200
     1.123    21.703     0.200
     1.807    32.562     0.200
     1.831    33.109     0.200
     1.919    33.828     0.200
     2.572    46.000     0.200
     2.835    48.492     0.200
     2.940    50.852     0.200
     3.264    53.812     0.200
     3.514    61.391     0.200
     3.545    59.961     0.200
     0.195     3.887     0.200
     0.995    19.377     0.200
     1.284    25.086     0.200
     1.417    27.537     0.200
     1.541    29.656     0.200
     1.502    28.127     0.200
     2.338    41.457     0.200
     2.589    47.236     0.200
     2.617    46.377     0.200
     2.922    50.637     0.200
     3.466    58.676     0.200
     0.183     3.887     0.200
     1.004    19.328     0.200
     1.289    24.887     0.200
     1.501    28.137     0.200
     1.584    29.957     0.200
     2.311    42.918     0.200
     2.336    41.598     0.200
     2.620    46.555     0.200
     2.727    48.547     0.200
     2.819    50.105     0.200
     0.662    12.934     0.200
     0.969    18.502     0.200
     1.153    20.342     0.200
     1.031    21.184     0.200
     1.650    29.854     0.200
     1.611    30.373     0.200
     1.739    30.592     0.200
     1.891    32.354     0.200
     2.688    46.373     0.200
     2.659    46.293     0.200
     2.927    49.492     0.200
     2.976    50.023     0.200
     3.114    54.963     0.200
     3.129    52.604     0.200
     3.083    50.643     0.200
     3.112    52.502     0.200
     3.243    53.963     0.200
     3.304    57.203     0.200
     3.635    59.592     0.200
     0.306     7.053     0.200
     3.479    60.572     0.200
     3.531    59.633     0.200
     3.745    63.203     0.200
     3.927    66.652     0.200
     3.938    65.434     0.200
     3.940    67.373     0.200
     3.965    68.613     0.200
     3.973    67.303     0.200
     4.352    72.902     0.200
     4.369    72.242     0.200
     4.540    76.223     0.200
     0.699    13.156     0.200
     0.901    17.145     0.200
     1.071    20.965     0.200
     1.586    28.727     0.200
     1.618    29.168     0.200
     1.672    30.828     0.200
     1.698    29.906     0.200
     2.374    41.496     0.200
     3.048    50.328     0.200
     0.854    15.875     0.200
     1.177    22.464     0.200
     1.213    24.274     0.200
     1.678    30.095     0.200
     1.785    32.285     0.200
     1.662    32.055     0.200
     1.949    35.654     0.200
     2.033    36.515     0.200
     2.386    40.865     0.200
     2.485    42.555     0.200
     2.544    44.785     0.200
     2.593    46.035     0.200
     2.803    49.584     0.200
     2.847    50.564     0.200
     2.961    50.515     0.200
     3.386    56.904     0.200
     3.381    56.564     0.200
     0.871    16.467     0.200
     3.261    56.286     0.200
     0.131     4.647     0.200
     1.045    19.157     0.200
     1.345    24.367     0.200
     1.609    28.727     0.200
     2.357    40.167     0.200
     3.082    51.417     0.200
     3.611    61.867     0.200
     3.837    65.537     0.200
     3.803    64.147     0.200
     3.965    69.517     0.200
     3.977    67.527     0.200
     4.427    72.847     0.200
     0.053     3.180     0.200
     1.069    20.469     0.200
     1.585    27.695     0.200
     1.673    29.117     0.200
     2.486    42.305     0.200
     2.448    41.797     0.200
     0.086     3.973     0.200
     0.977    18.633     0.200
     1.136    21.543     0.200
     1.235    22.512     0.200
     1.587    28.395     0.200
     2.346    40.312     0.200
     3.546    59.172     0.200
     3.551    58.613     0.200
     3.851    67.504     0.200
     3.974    69.062     0.200
     3.989    68.762     0.200
     3.992    68.684     0.200
     4.001    66.941     0.200
     4.012    68.684     0.200
     4.016    69.152     0.200
     4.023    69.852     0.200
     4.023    69.125     0.200
     4.038    69.742     0.200
     4.036    70.215     0.200
     4.042    68.203     0.200
     4.078    70.441     0.200
     4.112    71.152     0.200
     4.129    71.543     0.200
     4.181    70.793     0.200
     4.236    71.152     0.200
     4.262    72.844     0.200
     4.317    74.145     0.200
     0.503     9.688     0.200
     0.751    14.656     0.200
     0.884    17.383     0.200
     0.945    18.039     0.200
     1.172    20.992     0.200
     2.159    37.562     0.200
     2.416    43.305     0.200
     4.513    74.656     0.200
     4.526    76.922     0.200
     4.535    78.547     0.200
     0.192     5.487     0.200
     1.282    23.407     0.200
     1.657    28.947     0.200
     2.198    38.268     0.200
     3.144    56.478     0.200
     3.526    58.848     0.200
     3.877    68.397     0.200
     3.991    65.598     0.200
     4.634    77.647     0.200
     4.793    83.157     0.200
     0.243     5.814     0.200
     0.090     4.452     0.200
     0.921    17.232     0.200
     1.081    20.332     0.200
     1.180    21.252     0.200
     1.662    29.372     0.200
     1.560    27.502     0.200
     2.033    35.292     0.200
     2.328    39.672     0.200
     2.524    42.622     0.200
     3.579    59.513     0.200
     4.020    66.022     0.200
     0.200     5.533     0.200
     3.510    61.523     0.200
     3.932    65.514     0.200
     3.936    66.174     0.200
     3.941    64.943     0.200
     3.961    65.514     0.200
     4.058    68.834     0.200
     4.123    69.494     0.200
     4.253    71.494     0.200
     0.838    15.965     0.200
     0.987    18.773     0.200
     1.066    19.885     0.200
     1.157    21.664     0.200
     1.316    24.574     0.200
     1.605    29.465     0.200
     2.329    41.105     0.200
     2.329    40.906     0.200
     3.091    52.926     0.200
     3.382    56.824     0.200
     0.788    15.656     0.200
     0.852    16.367     0.200
     1.129    19.977     0.200
     1.501    27.348     0.200
     2.087    36.457     0.200
     2.117    36.172     0.200
     1.040    20.063     0.200
     1.199    23.233     0.200
     1.298    24.113     0.200
     1.755    31.533     0.200
     3.061    53.713     0.200
     3.066    53.923     0.200
     3.533    61.823     0.200
     3.552    60.813     0.200
     3.624    61.153     0.200
     3.852    67.803     0.200
     4.413    73.113     0.200
     4.439    75.104     0.200
     4.445    74.443     0.200
     1.609    29.037     0.200
     2.325    39.828     0.200
     2.325    40.068     0.200
     3.906    66.338     0.200
     3.946    69.658     0.200
     4.759    79.617     0.200
     1.152    22.090     0.200
     1.310    24.691     0.200
     1.414    26.000     0.200
     1.513    27.871     0.200
     2.297    39.871     0.200
     2.231    39.219     0.200
     2.770    47.801     0.200
     3.001    51.551     0.200
     3.355    58.090     0.200
     3.439    58.090     0.200
     4.226    70.719     0.200
     4.259    70.719     0.200
     5.392    89.871     0.200
     0.977    18.984     0.200
     1.136    21.324     0.200
     1.239    22.922     0.200
     1.496    27.531     0.200
     1.752    31.625     0.200
     2.251    39.125     0.200
     0.782    15.219     0.200
     0.927    17.828     0.200
     1.001    18.953     0.200
     1.001    18.836     0.200
     0.095     4.664     0.200
     1.033    19.074     0.200
     1.192    21.926     0.200
     1.288    23.047     0.200
     1.651    28.816     0.200
     2.403    40.477     0.200
     0.046     3.820     0.200
     0.985    18.211     0.200
     1.240    22.184     0.200
     0.322     7.277     0.200
     0.624    12.287     0.200
     0.782    15.007     0.200
     0.876    16.117     0.200
     1.571    28.268     0.200
     2.213    37.507     0.200
     2.380    42.197     0.200
     2.643    46.797     0.200
     3.522    58.817     0.200
     0.356     8.188     0.200
     0.596    11.961     0.200
     0.755    14.930     0.200
     0.855    15.922     0.200
     4.210    69.211     0.200
     4.531    76.672     0.200
     0.140     4.859     0.200
     0.805    15.639     0.200
     0.964    18.318     0.200
     1.058    19.369     0.200
     1.610    29.279     0.200
     2.910    50.869     0.200
     3.708    63.709     0.200
     4.015    67.338     0.200
     4.095    69.459     0.200
     4.105    70.969     0.200
     4.106    68.100     0.200
     4.114    69.939     0.200
     4.123    71.100     0.200
     4.131    70.738     0.200
     4.148    70.498     0.200
     4.237    70.869     0.200
     4.292    74.678     0.200
     4.576    75.969     0.200
     0.101     5.395     0.200
     1.021    18.685     0.200
     1.278    23.104     0.200
     1.814    31.675     0.200
     1.736    30.954     0.200
     2.108    37.124     0.200
     2.618    44.074     0.200
     0.503     9.920     0.200
     3.373    59.180     0.200
     0.941    18.422     0.200
     1.100    21.152     0.200
     1.202    22.750     0.200
     1.502    28.391     0.200
     2.264    40.230     0.200
     0.228     6.340     0.200
     1.051    19.328     0.200
     1.210    22.328     0.200
     2.760    47.031     0.200
     2.668    44.750     0.200
     4.181    71.938     0.200
     0.239     7.102     0.200
     1.137    21.023     0.200
     1.397    25.188     0.200
     1.427    26.391     0.200
     1.594    27.992     0.200
     2.744    46.156     0.200
     4.320    74.688     0.200
     4.349    73.281     0.200
     0.470     9.184     0.200
     1.023    20.273     0.200
     1.147    21.863     0.200
     1.246    24.293     0.200
     1.172    22.645     0.200
     1.249    23.664     0.200
     1.641    31.273     0.200
     2.355    41.994     0.200
     2.313    43.623     0.200
     2.557    47.234     0.200
     2.368    42.424     0.200
     2.390    43.604     0.200
     3.085    56.434     0.200
     3.077    55.543     0.200
     3.153    54.934     0.200
     3.188    54.934     0.200
     3.269    59.014     0.200
     3.363    57.543     0.200
     3.382    58.844     0.200
     3.181    55.514     0.200
     3.325    57.744     0.200
     3.560    62.014     0.200
     0.808    14.961     0.200
     0.967    18.129     0.200
     1.105    20.660     0.200
     3.604    59.152     0.200
     4.343    74.602     0.200
     0.427     8.957     0.200
     1.229    23.449     0.200
     1.047    20.348     0.200
     1.147    21.766     0.200
     1.182    22.039     0.200
     1.265    23.676     0.200
     1.682    29.867     0.200
     1.429    26.219     0.200
     2.126    38.059     0.200
     2.385    42.156     0.200
     2.379    42.129     0.200
     3.239    55.277     0.200
     0.190     5.185     0.200
     1.014    18.685     0.200
     1.173    21.715     0.200
     1.275    22.864     0.200
     1.299    24.265     0.200
     1.507    27.864     0.200
     2.256    39.265     0.200
     2.629    43.915     0.200
     3.524    58.274     0.200
     0.243     6.812     0.200
     1.106    20.182     0.200
     1.264    22.512     0.200
     1.367    24.612     0.200
     1.390    25.802     0.200
     1.539    26.792     0.200
     2.270    38.252     0.200
     2.719    45.052     0.200
     0.450     8.890     0.200
     1.036    20.270     0.200
     1.152    22.170     0.200
     1.180    23.340     0.200
     1.234    23.740     0.200
     1.260    24.010     0.200
     1.650    31.320     0.200
     2.369    42.050     0.200
     3.196    56.320     0.200
     0.483     9.030     0.200
     1.010    19.811     0.200
     1.137    21.390     0.200
     1.238    23.300     0.200
     1.258    23.811     0.200
     2.301    43.600     0.200
     2.356    42.230     0.200
     2.387    43.780     0.200
     2.736    49.460     0.200
     3.376    58.200     0.200
     3.782    64.670     0.200
     0.372     7.914     0.200
     1.099    21.383     0.200
     1.184    22.461     0.200
     1.187    22.992     0.200
     1.227    24.016     0.200
     1.313    24.625     0.200
     1.420    26.336     0.200
     2.062    36.961     0.200
     2.318    41.227     0.200
     2.430    42.672     0.200
     2.430    42.258     0.200
     2.496    43.078     0.200
     2.512    44.586     0.200
     2.852    48.414     0.200
     2.917    51.508     0.200
     3.362    57.242     0.200
     0.438     8.115     0.200
     1.129    21.545     0.200
     1.251    23.476     0.200
     3.203    56.995     0.200
     0.075     5.568     0.200
     0.977    18.227     0.200
     1.136    21.268     0.200
     1.235    22.518     0.200
     1.599    28.318     0.200
     1.843    32.158     0.200
     2.071    34.918     0.200
     2.358    41.117     0.200
     2.575    43.607     0.200
     3.113    56.057     0.200
     0.395     8.781     0.200
     1.170    21.621     0.200
     1.209    22.473     0.200
     1.293    23.422     0.200
     1.429    26.184     0.200
     1.679    30.965     0.200
     2.094    37.512     0.200
     2.409    41.293     0.200
     2.876    49.621     0.200
     3.024    51.352     0.200
     3.204    54.453     0.200
     3.635    62.465     0.200
     0.426     8.039     0.200
     1.173    22.418     0.200
     1.202    23.279     0.200
     1.211    23.109     0.200
     1.282    24.418     0.200
     1.637    31.889     0.200
     2.359    42.449     0.200
     2.392    42.879     0.200
     2.417    43.918     0.200
     3.320    58.168     0.200
     0.166     5.012     0.200
     0.944    17.820     0.200
     1.102    20.832     0.200
     1.205    22.129     0.200
     0.890    16.383     0.200
     1.061    20.055     0.200
     1.330    24.469     0.200
     1.742    31.234     0.200
     1.821    33.469     0.200
     1.997    34.891     0.200
     2.157    37.742     0.200
     2.507    43.180     0.200
     2.626    44.133     0.200
     2.698    45.992     0.200
     3.114    51.820     0.200
     3.158    52.352     0.200
     3.356    57.391     0.200
     0.898    16.867     0.200
     1.056    19.617     0.200
     1.159    20.996     0.200
     3.455    60.508     0.200
     4.248    73.797     0.200
     0.474     9.188     0.200
     1.106    21.078     0.200
     1.139    22.180     0.200
     1.221    23.273     0.200
     1.273    25.047     0.200
     1.705    31.633     0.200
     2.334    41.953     0.200
     2.430    42.500     0.200
     3.106    53.500     0.200
     3.206    55.828     0.200
     0.055     5.963     0.200
     0.919    17.193     0.200
     1.176    21.434     0.200
     2.012    34.594     0.200
     2.365    39.604     0.200
     2.515    42.223     0.200
     0.374     6.991     0.200
     1.214    23.331     0.200
     1.247    23.901     0.200
     1.329    25.111     0.200
     2.468    45.451     0.200
     2.476    45.351     0.200
     2.411    44.681     0.200
     2.466    43.781     0.200
     2.633    47.331     0.200
     2.910    52.981     0.200
     3.645    63.661     0.200
     0.394     7.280     0.200
     1.150    21.421     0.200
     1.247    24.121     0.200
     1.271    25.411     0.200
     2.355    42.421     0.200
     2.451    43.431     0.200
     2.632    47.601     0.200
     3.155    55.280     0.200
     3.236    56.381     0.200
     3.283    58.511     0.200
     3.646    64.241     0.200
     4.202    71.201     0.200
     0.896    16.492     0.200
     1.064    19.812     0.200
     1.734    31.250     0.200
     1.876    33.031     0.200
     1.988    35.383     0.200
     2.162    38.492     0.200
     2.501    43.281     0.200
     2.617    45.141     0.200
     2.800    48.578     0.200
     2.951    50.656     0.200
     3.144    54.922     0.200
     3.159    53.852     0.200
     3.268    55.727     0.200
     3.346    55.680     0.200
     3.728    66.250     0.200
     6.317   105.547     0.200
     0.290     7.748     0.200
     0.758    14.578     0.200
     0.915    17.338     0.200
     1.021    19.018     0.200
     1.027    19.768     0.200
     1.956    33.277     0.200
     2.382    40.998     0.200
     3.540    58.418     0.200
     4.236    70.697     0.200
     0.346     6.996     0.200
     1.094    20.926     0.200
     1.094    21.438     0.200
     1.150    22.379     0.200
     1.300    23.996     0.200
     1.326    24.418     0.200
     1.516    28.398     0.200
     2.852    50.758     0.200
     3.016    52.957     0.200
     3.408    57.707     0.200
     7.551   133.660     0.200
     0.364     7.441     0.200
     1.120    20.660     0.200
     1.124    21.891     0.200
     1.120    21.051     0.200
     1.273    23.891     0.200
     1.299    25.082     0.200
     1.376    25.602     0.200
     2.601    46.891     0.200
     2.952    51.512     0.200
     3.101    55.148     0.200
     3.125    53.859     0.200
     3.130    55.762     0.200
     3.221    56.199     0.200
     3.236    57.090     0.200
     3.255    57.461     0.200
     3.255    57.461     0.200
     3.628    63.199     0.200
     3.666    62.891     0.200
     0.362     7.730     0.200
     1.116    21.910     0.200
     1.128    22.699     0.200
     1.277    24.539     0.200
     1.303    25.340     0.200
     1.380    26.359     0.200
     2.427    43.020     0.200
     2.485    43.578     0.200
     2.873    51.578     0.200
     2.949    53.000     0.200
     3.061    54.539     0.200
     3.216    56.559     0.200
     3.243    55.898     0.200
     3.251    55.980     0.200
     3.251    55.980     0.200
     3.430    58.488     0.200
     3.625    61.750     0.200
     0.358     7.127     0.200
     1.109    21.496     0.200
     1.135    21.656     0.200
     1.285    23.537     0.200
     1.310    24.326     0.200
     0.721    13.961     0.200
     1.245    22.758     0.200
     1.385    25.398     0.200
     1.412    26.547     0.200
     1.496    26.711     0.200
     1.756    32.906     0.200
     2.156    36.867     0.200
     2.892    48.336     0.200
     2.852    47.570     0.200
     2.951    50.062     0.200
     2.992    50.508     0.200
     3.163    53.898     0.200
     3.281    55.477     0.200
     0.414     8.082     0.200
     1.041    20.811     0.200
     1.207    22.832     0.200
     1.173    22.451     0.200
     1.205    23.572     0.200
     1.286    24.381     0.200
     1.650    30.742     0.200
     2.434    44.361     0.200
     3.157    54.771     0.200
     3.667    64.531     0.200
     0.727    14.461     0.200
     1.437    25.789     0.200
     1.501    26.930     0.200
     1.722    31.672     0.200
     1.762    31.070     0.200
     2.044    36.953     0.200
     2.975    49.930     0.200
     3.128    51.961     0.200
     0.477     9.338     0.200
     0.972    20.229     0.200
     1.099    21.238     0.200
     1.133    21.979     0.200
     1.215    22.508     0.200
     1.279    24.639     0.200
     2.319    43.787     0.200
     2.329    41.367     0.200
     2.398    44.188     0.200
     2.470    44.088     0.200
     3.107    53.928     0.200
     0.179     5.500     0.200
     1.115    20.190     0.200
     1.273    23.400     0.200
     1.431    25.580     0.200
     2.681    45.070     0.200
     3.661    60.470     0.200
     0.199     4.586     0.200
     0.907    17.645     0.200
     1.065    20.215     0.200
     1.169    21.836     0.200
     1.181    23.375     0.200
     1.452    28.156     0.200
     1.816    32.863     0.200
     2.219    38.496     0.200
     3.491    58.824     0.200
     0.170     4.938     0.200
     0.268     6.229     0.200
     4.232    72.099     0.200
     0.135     4.213     0.200
     0.926    17.322     0.200
     1.186    21.562     0.200
     1.517    27.732     0.200
     2.283    38.973     0.200
     3.549    59.543     0.200
     3.549    59.672     0.200
     3.756    62.492     0.200
     4.406    72.652     0.200
     0.465     9.240     0.200
     0.983    20.010     0.200
     1.269    23.791     0.200
     1.107    21.141     0.200
     1.225    23.221     0.200
     2.063    37.221     0.200
     2.340    41.271     0.200
     0.658    12.672     0.200
     0.793    15.430     0.200
     1.035    19.500     0.200
     1.011    19.531     0.200
     1.812    33.305     0.200
     2.099    36.906     0.200
     2.382    42.242     0.200
     3.071    55.031     0.200
     3.118    54.570     0.200
     3.277    56.445     0.200
     3.264    56.430     0.200
     3.288    57.320     0.200
     3.396    57.336     0.200
     3.519    60.203     0.200
     3.675    64.430     0.200
     4.058    67.961     0.200
     0.473    10.375     0.200
     0.991    19.875     0.200
     1.138    21.762     0.200
     1.242    23.633     0.200
     1.253    24.984     0.200
     1.653    31.125     0.200
     2.349    42.484     0.200
     2.370    41.582     0.200
     2.401    42.453     0.200
     2.446    42.723     0.200
     3.221    56.152     0.200
     3.311    56.043     0.200
     3.337    58.125     0.200
     3.391    57.473     0.200
     0.487    10.438     0.200
     1.411    24.977     0.200
     1.499    27.227     0.200
     2.094    35.234     0.200
     0.782    15.461     0.200
     1.167    22.152     0.200
     1.367    26.113     0.200
     1.848    33.672     0.200
     1.810    32.902     0.200
     2.102    37.141     0.200
     2.405    40.980     0.200
     2.640    46.242     0.200
     2.876    49.914     0.200
     3.110    52.871     0.200
     0.999    18.893     0.200
     3.381    58.623     0.200
     3.856    66.443     0.200
     3.947    67.323     0.200
     3.960    67.273     0.200
     4.313    72.393     0.200
     4.395    77.833     0.200
     4.403    74.353     0.200
     4.421    75.433     0.200
     4.441    74.903     0.200
     4.486    78.783     0.200
     4.684    78.893     0.200
     0.880    17.001     0.200
     1.137    21.301     0.200
     1.249    23.311     0.200
     1.540    27.721     0.200
     1.637    29.891     0.200
     1.647    29.531     0.200
     1.674    30.081     0.200
     1.689    30.391     0.200
     1.721    31.401     0.200
     1.759    32.041     0.200
     1.796    31.731     0.200
     1.822    31.891     0.200
     1.921    33.271     0.200
     2.088    35.991     0.200
     2.681    45.751     0.200
     2.811    46.961     0.200
     2.875    48.671     0.200
     2.889    49.271     0.200
     3.074    52.411     0.200
     3.156    52.691     0.200
     3.451    60.431     0.200
     3.784    63.201     0.200
     0.205     5.875     0.200
     1.126    20.457     0.200
     1.260    23.027     0.200
     1.384    24.457     0.200
     1.372    24.938     0.200
     1.409    25.566     0.200
     1.418    26.277     0.200
     1.441    25.938     0.200
     1.460    26.805     0.200
     1.635    28.535     0.200
     1.712    30.426     0.200
     1.842    32.188     0.200
     2.213    39.637     0.200
     2.381    42.348     0.200
     2.367    41.195     0.200
     2.988    52.297     0.200
     3.116    56.215     0.200
     3.501    59.258     0.200
     3.538    58.867     0.200
     3.607    64.105     0.200
     3.769    63.297     0.200
     0.190     6.045     0.200
     1.127    20.896     0.200
     1.263    23.205     0.200
     1.361    24.775     0.200
     1.384    24.815     0.200
     1.381    25.215     0.200
     1.419    26.055     0.200
     1.468    26.745     0.200
     1.480    26.085     0.200
     1.676    29.445     0.200
     1.725    30.665     0.200
     1.821    31.805     0.200
     1.851    33.205     0.200
     1.852    32.635     0.200
     2.193    36.975     0.200
     2.719    45.615     0.200
     1.460    26.915     0.200
     0.330     7.789     0.200
     0.333     6.188     0.200
     0.399     7.539     0.200
     1.037    20.828     0.200
     1.098    21.539     0.200
     1.121    22.203     0.200
     1.140    22.758     0.200
     1.147    23.047     0.200
     1.110    21.828     0.200
     1.206    23.672     0.200
     1.263    24.586     0.200
     1.308    24.898     0.200
     1.476    29.664     0.200
     2.236    39.742     0.200
     2.415    45.594     0.200
     2.493    44.945     0.200
     0.485     9.861     0.200
     0.857    16.621     0.200
     0.957    18.621     0.200
     0.954    19.321     0.200
     0.986    19.440     0.200
     1.011    19.760     0.200
     1.059    20.980     0.200
     1.113    20.980     0.200
     1.099    21.641     0.200
     1.164    23.021     0.200
     1.300    24.771     0.200
     1.326    26.121     0.200
     1.453    27.361     0.200
     1.944    36.051     0.200
     2.476    44.250     0.200
     2.964    50.111     0.200
     3.177    54.650     0.200
     3.224    56.980     0.200
     3.325    55.531     0.200
     3.363    56.121     0.200
     3.473    58.900     0.200
     3.487    59.460     0.200
     3.597    59.791     0.200
     3.673    62.180     0.200
     3.753    62.910     0.200
     3.785    62.841     0.200
     4.130    69.541     0.200
     0.168     5.582     0.200
     1.089    20.362     0.200
     1.223    22.572     0.200
     1.318    24.592     0.200
     1.347    24.172     0.200
     1.338    24.132     0.200
     1.383    25.712     0.200
     1.425    26.322     0.200
     1.431    25.852     0.200
     1.628    28.442     0.200
     1.679    30.192     0.200
     1.808    32.062     0.200
     1.803    32.762     0.200
     2.176    38.372     0.200
     2.368    41.152     0.200
     2.688    45.252     0.200
     3.523    59.202     0.200
     4.389    76.772     0.200
     4.418    77.002     0.200
     1.418    26.112     0.200
     0.227     4.788     0.200
     0.969    18.757     0.200
     1.094    21.268     0.200
     1.168    22.587     0.200
     1.190    23.257     0.200
     1.231    23.368     0.200
     1.383    25.917     0.200
     1.442    28.058     0.200
     1.516    28.658     0.200
     1.750    32.197     0.200
     2.137    37.478     0.200
     2.197    39.058     0.200
     2.349    43.248     0.200
     2.589    45.438     0.200
     2.637    46.188     0.200
     3.043    53.147     0.200
     0.751    14.652     0.200
     0.753    14.473     0.200
     0.878    17.594     0.200
     0.884    16.672     0.200
     0.947    17.094     0.200
     3.419    59.344     0.200
     0.070     2.742     0.200
     0.195     3.938     0.200
     0.304     6.961     0.200
     0.328     7.383     0.200
     0.361     8.031     0.200
     0.672    13.031     0.200
     0.935    17.344     0.200
     1.006    19.266     0.200
     1.254    22.688     0.200
     1.362    25.633     0.200
     1.592    29.625     0.200
     1.646    31.242     0.200
     1.959    34.953     0.200
     0.346     7.812     0.200
     0.288     5.711     0.200
     0.482     8.762     0.200
     0.862    16.641     0.200
     0.909    18.141     0.200
     0.931    17.332     0.200
     0.940    18.211     0.200
     0.966    19.332     0.200
     0.980    19.102     0.200
     1.061    20.434     0.200
     1.090    20.992     0.200
     1.112    20.621     0.200
     1.286    26.344     0.200
     1.208    22.883     0.200
     2.046    37.102     0.200
     2.317    42.461     0.200
     2.323    41.832     0.200
     2.883    51.492     0.200
     0.992    19.391     0.200
     0.251     6.617     0.200
     1.025    19.078     0.200
     1.169    21.727     0.200
     1.177    21.680     0.200
     1.322    24.031     0.200
     1.258    22.820     0.200
     1.368    24.945     0.200
     1.362    24.914     0.200
     1.403    25.625     0.200
     1.580    27.867     0.200
     1.691    29.648     0.200
     1.791    31.070     0.200
     2.053    36.469     0.200
     2.570    44.102     0.200
     2.532    43.102     0.200
     3.874    65.820     0.200
     3.954    65.875     0.200
     1.392    25.656     0.200
     0.242     5.242     0.200
     0.423     8.441     0.200
     0.454     8.895     0.200
     0.971    19.512     0.200
     0.984    19.004     0.200
     1.028    20.664     0.200
     1.041    20.441     0.200
     1.124    21.754     0.200
     1.163    21.734     0.200
     1.224    22.832     0.200
     1.153    21.863     0.200
     1.170    21.973     0.200
     1.271    23.754     0.200
     1.371    26.281     0.200
     1.425    26.965     0.200
     2.108    38.031     0.200
     2.385    42.602     0.200
     3.157    56.223     0.200
     3.239    58.902     0.200
     3.357    59.133     0.200
     0.877    16.373     0.200
     1.138    21.373     0.200
     1.160    22.773     0.200
     1.224    23.844     0.200
     1.437    27.184     0.200
     1.718    29.854     0.200
     1.691    30.793     0.200
     1.757    31.733     0.200
     1.864    33.663     0.200
     1.873    34.003     0.200
     1.909    34.514     0.200
     1.946    34.963     0.200
     2.007    35.583     0.200
     2.080    36.753     0.200
     2.253    39.173     0.200
     2.424    41.173     0.200
     2.655    44.733     0.200
     2.663    46.974     0.200
     2.739    47.063     0.200
     0.097     5.055     0.200
     0.042     5.023     0.200
     0.074     5.336     0.200
     0.214     6.766     0.200
     0.206     6.641     0.200
     0.197     6.156     0.200
     0.238     7.008     0.200
     0.260     7.445     0.200
     0.369     7.758     0.200
     0.452     9.711     0.200
     0.547    10.867     0.200
     0.593    11.195     0.200
     1.130    20.734     0.200
     1.142    20.750     0.200
     1.447    25.727     0.200
     1.420    25.680     0.200
     1.366    25.195     0.200
     1.590    28.844     0.200
     1.627    30.344     0.200
     1.945    32.867     0.200
     2.793    48.711     0.200
     2.891    48.398     0.200
     3.557    58.391     0.200
     0.820    15.961     0.200
     0.870    17.641     0.200
     1.010    20.609     0.200
     1.212    23.727     0.200
     1.309    24.523     0.200
     1.392    26.359     0.200
     1.411    26.859     0.200
     1.421    27.211     0.200
     1.457    27.930     0.200
     1.494    28.500     0.200
     1.556    28.820     0.200
     1.638    30.211     0.200
     1.691    30.398     0.200
     1.668    30.805     0.200
     1.809    32.820     0.200
     2.242    40.148     0.200
     2.597    46.375     0.200
     2.533    45.727     0.200
     2.904    52.055     0.200
     3.093    54.359     0.200
     3.173    56.961     0.200
     3.411    59.156     0.200
     0.391     9.053     0.200
     1.276    22.952     0.200
     1.404    25.583     0.200
     1.435    26.873     0.200
     1.479    26.933     0.200
     1.419    24.963     0.200
     1.502    27.062     0.200
     1.538    27.223     0.200
     1.534    28.353     0.200
     1.548    27.683     0.200
     1.533    27.513     0.200
     1.590    28.782     0.200
     1.595    29.343     0.200
     1.789    31.383     0.200
     1.825    32.272     0.200
     1.784    32.112     0.200
     2.026    35.933     0.200
     1.964    35.083     0.200
     2.287    38.553     0.200
     2.890    48.192     0.200
     2.893    51.652     0.200
     3.217    55.522     0.200
     3.288    58.992     0.200
     3.331    57.263     0.200
     3.361    58.862     0.200
     3.501    61.333     0.200
     3.809    63.732     0.200
     4.346    77.322     0.200
     5.052    85.593     0.200
     0.130     5.656     0.200
     1.074    19.906     0.200
     1.233    22.281     0.200
     1.328    24.031     0.200
     1.335    24.555     0.200
     1.336    24.391     0.200
     1.376    25.156     0.200
     1.381    25.484     0.200
     1.423    26.203     0.200
     1.825    32.734     0.200
     1.686    29.977     0.200
     1.751    30.055     0.200
     1.808    31.484     0.200
     2.123    38.250     0.200
     0.243     5.381     0.200
     0.364     6.861     0.200
     1.135    21.621     0.200
     1.062    20.762     0.200
     1.052    20.980     0.200
     1.087    21.311     0.200
     1.110    21.920     0.200
     1.109    22.211     0.200
     1.251    24.021     0.200
     1.533    29.781     0.200
     3.005    53.980     0.200
     2.467    44.740     0.200
     3.122    53.980     0.200
     3.657    61.941     0.200
     0.249     5.887     0.200
     0.342     7.137     0.200
     0.357     6.926     0.200
     1.048    19.797     0.200
     1.065    21.188     0.200
     1.076    21.016     0.200
     1.101    21.707     0.200
     1.123    22.258     0.200
     1.133    22.617     0.200
     1.232    23.398     0.200
     1.222    23.039     0.200
     1.249    23.309     0.200
     1.268    24.469     0.200
     1.527    28.898     0.200
     2.212    40.008     0.200
     2.480    44.656     0.200
     3.240    56.848     0.200
     0.092     5.672     0.200
     1.007    18.691     0.200
     1.241    22.751     0.200
     1.265    22.861     0.200
     1.260    23.411     0.200
     1.298    24.271     0.200
     1.305    24.491     0.200
     1.347    25.042     0.200
     1.407    25.802     0.200
     1.541    27.451     0.200
     1.605    28.841     0.200
     1.611    28.781     0.200
     1.725    29.891     0.200
     1.731    30.672     0.200
     1.779    32.052     0.200
     2.097    35.621     0.200
     2.365    40.821     0.200
     2.457    43.802     0.200
     2.605    44.111     0.200
     2.763    46.321     0.200
     3.035    50.021     0.200
     3.473    59.292     0.200
     3.567    61.151     0.200
     0.287     7.280     0.200
     0.395    10.010     0.200
     0.414    10.080     0.200
     0.991    19.080     0.200
     1.046    19.740     0.200
     1.068    20.550     0.200
     1.078    20.460     0.200
     1.180    22.130     0.200
     1.219    22.270     0.200
     1.243    22.190     0.200
     1.321    24.310     0.200
     1.365    26.900     0.200
     1.579    28.130     0.200
     2.159    37.900     0.200
     2.195    38.140     0.200
     2.425    42.320     0.200
     2.399    40.630     0.200
     2.487    41.650     0.200
     2.657    44.580     0.200
     2.743    46.370     0.200
     2.885    48.120     0.200
     2.943    51.810     0.200
     2.932    49.350     0.200
     3.008    50.480     0.200
     3.055    51.220     0.200
     3.168    53.170     0.200
     3.490    57.220     0.200
     3.684    66.380     0.200
     3.887    65.200     0.200
     0.273     6.182     0.200
     0.461     9.021     0.200
     0.490    10.361     0.200
     0.932    18.521     0.200
     0.938    18.271     0.200
     0.948    18.821     0.200
     0.964    18.661     0.200
     0.989    20.531     0.200
     1.086    20.961     0.200
     1.116    21.281     0.200
     1.132    21.111     0.200
     1.233    23.231     0.200
     1.557    28.981     0.200
     2.901    51.401     0.200
     0.847    15.984     0.200
     0.949    19.164     0.200
     1.230    23.004     0.200
     1.395    25.465     0.200
     1.478    27.035     0.200
     1.506    27.375     0.200
     1.518    27.875     0.200
     1.517    27.984     0.200
     1.552    28.625     0.200
     1.589    28.984     0.200
     1.645    29.273     0.200
     1.737    30.594     0.200
     1.907    32.656     0.200
     2.997    49.234     0.200
     3.251    53.254     0.200
     1.590    29.074     0.200
     0.530    10.391     0.200
     0.990    18.754     0.200
     0.965    18.613     0.200
     1.347    25.473     0.200
     1.644    29.871     0.200
     1.741    31.922     0.200
     1.750    32.152     0.200
     1.777    32.473     0.200
     1.788    32.844     0.200
     1.792    33.074     0.200
     1.824    33.613     0.200
     1.862    34.004     0.200
     2.062    36.074     0.200
     2.118    38.371     0.200
     2.599    46.641     0.200
     2.711    46.273     0.200
     2.798    49.992     0.200
     2.822    49.504     0.200
     2.922    49.781     0.200
     2.865    48.383     0.200
     2.913    52.422     0.200
     2.962    50.121     0.200
     3.081    52.051     0.200
     3.131    52.312     0.200
     3.152    53.223     0.200
     3.224    53.980     0.200
     3.224    56.004     0.200
     3.224    56.031     0.200
     3.232    53.711     0.200
     3.233    54.230     0.200
     3.236    54.512     0.200
     3.247    58.691     0.200
     3.252    58.691     0.200
     3.601    59.574     0.200
     3.856    64.832     0.200
     1.862    33.992     0.200
     0.155     5.721     0.200
     0.260     6.891     0.200
     0.321     7.781     0.200
     0.389     8.412     0.200
     0.399     9.111     0.200
     0.392     8.730     0.200
     0.407     9.172     0.200
     0.409     9.230     0.200
     0.423     9.412     0.200
     0.447     9.521     0.200
     0.422     8.551     0.200
     0.611    10.252     0.200
     0.640    11.980     0.200
     0.665    12.471     0.200
     0.692    12.992     0.200
     1.247    22.551     0.200
     1.473    26.912     0.200
     1.614    28.811     0.200
     1.718    29.252     0.200
     0.393     9.041     0.200
     0.310     7.258     0.200
     0.322     7.639     0.200
     0.380     8.148     0.200
     0.515    10.479     0.200
     0.494    10.479     0.200
     0.507    10.398     0.200
     0.508    10.549     0.200
     0.537    11.139     0.200
     0.564    11.520     0.200
     0.572    11.678     0.200
     0.721    13.158     0.200
     0.835    15.488     0.200
     0.881    16.158     0.200
     0.930    16.838     0.200
     0.944    16.838     0.200
     1.434    25.488     0.200
     1.697    29.959     0.200
     2.144    36.369     0.200
     2.143    36.459     0.200
     2.498    43.469     0.200
     2.889    48.699     0.200
     0.108     4.891     0.200
     1.052    19.602     0.200
     1.191    21.883     0.200
     1.300    23.633     0.200
     1.318    24.031     0.200
     1.317    24.062     0.200
     1.304    23.621     0.200
     1.359    25.023     0.200
     1.363    25.121     0.200
     1.404    25.711     0.200
     1.338    24.531     0.200
     1.671    29.742     0.200
     1.790    31.172     0.200
     2.090    37.684     0.200
     0.104     4.266     0.200
     0.691    14.484     0.200
     0.964    19.031     0.200
     1.278    23.766     0.200
     1.278    23.992     0.200
     1.305    24.352     0.200
     1.328    24.891     0.200
     1.334    25.094     0.200
     1.311    23.781     0.200
     1.417    26.070     0.200
     1.408    26.242     0.200
     1.516    27.930     0.200
     1.490    26.828     0.200
     1.563    28.469     0.200
     1.682    30.805     0.200
     1.873    33.859     0.200
     1.707    29.734     0.200
     2.056    36.789     0.200
     2.263    39.930     0.200
     2.275    39.641     0.200
     2.394    41.414     0.200
     2.385    40.516     0.200
     2.475    42.914     0.200
     2.607    44.742     0.200
     2.830    47.594     0.200
     2.821    48.719     0.200
     4.737    82.609     0.200
     1.363    25.398     0.200
     0.496    10.316     0.200
     0.923    17.076     0.200
     0.954    19.156     0.200
     1.023    19.286     0.200
     1.049    19.566     0.200
     1.075    20.076     0.200
     1.096    20.646     0.200
     1.122    21.276     0.200
     1.162    21.896     0.200
     1.180    21.326     0.200
     1.358    24.926     0.200
     1.513    27.366     0.200
     1.831    31.456     0.200
     2.147    37.076     0.200
     2.384    40.556     0.200
     2.542    43.826     0.200
     1.160    21.926     0.200
     0.277     6.207     0.200
     1.011    17.996     0.200
     1.059    21.047     0.200
     1.088    21.566     0.200
     1.101    21.367     0.200
     1.099    22.047     0.200
     1.125    21.895     0.200
     1.149    22.527     0.200
     1.146    22.656     0.200
     1.260    24.125     0.200
     1.231    24.035     0.200
     1.299    24.465     0.200
     1.323    25.105     0.200
     1.400    26.227     0.200
     1.375    27.484     0.200
     1.390    27.098     0.200
     1.510    29.785     0.200
     1.501    29.418     0.200
     1.751    32.457     0.200
     1.876    34.715     0.200
     2.238    40.098     0.200
     2.348    41.457     0.200
     2.383    42.188     0.200
     2.394    41.938     0.200
     2.409    41.938     0.200
     2.435    43.348     0.200
     2.456    42.926     0.200
     2.516    43.605     0.200
     2.583    44.598     0.200
     2.815    49.246     0.200
     3.036    52.566     0.200
     3.047    53.848     0.200
     3.152    56.555     0.200
     3.204    55.887     0.200
     3.387    57.527     0.200
     1.168    23.008     0.200
     0.934    17.820     0.200
     1.031    19.238     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.900    51.848     0.200
     4.208   111.848     0.200
     6.738   177.848     0.200
    14.817   373.848     0.200
    16.481   409.848     0.200
    18.398   451.848     0.200
    22.454   549.594     0.200
     2.365    62.547     0.200
     2.783    73.152     0.200
    12.592   319.152     0.200
    17.252   426.152     0.200
    21.296   529.152     0.200
     1.670    46.789     0.200
     5.386   132.789     0.200
     6.679   176.789     0.200
    15.159   384.789     0.200
    17.169   428.789     0.200
    23.338   566.789     0.200
     2.578    71.389     0.200
     6.257   165.389     0.200
    13.143   336.389     0.200
    18.933   470.389     0.200
     2.654    73.719     0.200
    15.762   397.719     0.200
    20.861   518.719     0.200
    18.603   458.555     0.200
    23.339   569.938     0.200
     4.339   124.348     0.200
    17.983   444.348     0.200
    21.975   541.273     0.200
    18.756   465.207     0.200
    21.383   530.207     0.200
     3.297    88.285     0.200
     7.019   181.484     0.200
    10.109   255.285     0.200
     2.613    69.477     0.200
     3.149    81.281     0.200
     3.882    96.508     0.200
     6.271   158.508     0.200
     5.723   156.396     0.200
    24.213   591.258     0.200
     3.768   101.883     0.200
     3.880   105.883     0.200
     4.781   120.883     0.200
     3.342    89.641     0.200
     3.832   104.641     0.200
     4.062   106.836     0.200
     4.074   105.836     0.200
     5.130   126.836     0.200
     6.265   156.836     0.200
     3.666    99.250     0.200
     3.679    98.750     0.200
     4.722   119.250     0.200
    10.718   272.715     0.200
     1.229    36.326     0.200
     2.722    73.375     0.200
    21.161   527.176     0.200
     3.299    90.734     0.200
     1.973    58.050     0.200
     3.841   106.779     0.200
     1.393    40.413     0.200
     2.340    54.613     0.200
     2.404    62.613     0.200
     3.558    96.613     0.200
     3.612    95.613     0.200
     4.006   104.113     0.200
     4.465   118.113     0.200
     4.757   121.913     0.200
     5.270   137.613     0.200
     5.628   146.113     0.200
     6.360   165.813     0.200
     1.118    35.723     0.200
     3.432    88.723     0.200
     3.391    90.723     0.200
     4.513   124.324     0.200
     4.889   122.805     0.200
     4.905   132.805     0.200
     6.753   182.305     0.200
     2.412    67.859     0.200
     3.782    99.859     0.200
     3.816   102.359     0.200
     4.110   111.660     0.200
     4.593   122.359     0.200
     1.601    49.621     0.200
     3.031    85.621     0.200
     3.480    92.621     0.200
     3.420    93.621     0.200
     3.770   100.621     0.200
     6.144   156.121     0.200
     0.463    25.877     0.200
     2.356    67.377     0.200
     3.901    99.178     0.200
     5.987   147.877     0.200
     7.991   196.377     0.200
     1.423    39.961     0.200
     1.682    50.062     0.200
     2.369    65.062     0.200
     2.692    75.062     0.200
     3.122    81.266     0.200
     3.513    94.859     0.200
     3.655   103.359     0.200
     3.679    97.766     0.200
     3.816   103.859     0.200
     3.845   104.164     0.200
     3.852   106.164     0.200
     4.151   116.766     0.200
     9.859   254.062     0.200
    11.196   282.062     0.200
    19.664   486.062     0.200
     2.686    73.388     0.200
     3.116    84.388     0.200
     3.268    89.388     0.200
     3.562    98.289     0.200
     3.699    98.789     0.200
     3.744   104.388     0.200
     3.756   105.388     0.200
     3.865   106.188     0.200
     3.896   104.888     0.200
     4.170   110.888     0.200
     4.203   115.589     0.200
     1.113    31.693     0.200
     2.383    66.083     0.200
     3.064    85.133     0.200
     3.286    90.193     0.200
     3.411    92.593     0.200
     3.486    92.393     0.200
     3.609    98.193     0.200
     3.626    96.493     0.200
     3.935   105.493     0.200
     1.799    50.500     0.200
     2.521    71.000     0.200
     2.951    78.797     0.200
     3.086    82.500     0.200
     3.389    89.602     0.200
     3.539    95.102     0.200
     3.570    96.000     0.200
     3.586    98.500     0.200
     3.693   101.797     0.200
     3.991   109.500     0.200
     1.157    37.906     0.200
     2.417    66.258     0.200
     2.607    71.766     0.200
     2.846    76.984     0.200
     3.522    98.188     0.200
     3.528    94.387     0.200
     5.114   138.586     0.200
     5.705   149.586     0.200
     6.360   166.055     0.200
     0.553    25.345     0.200
     1.549    45.465     0.200
     1.860    53.284     0.200
     2.087    56.944     0.200
     3.516    94.954     0.200
     3.750   100.975     0.200
     3.760    99.255     0.200
     3.782   103.135     0.200
     3.792   102.175     0.200
     3.885   103.984     0.200
     4.184   111.305     0.200
     4.249   115.185     0.200
     4.298   114.744     0.200
     4.298   118.164     0.200
     4.564   126.505     0.200
     5.213   133.055     0.200
     5.480   144.204     0.200
     6.396   164.584     0.200
     6.402   168.414     0.200
    12.835   326.405     0.200
    21.893   532.188     0.200
     1.217    35.094     0.200
     2.488    69.055     0.200
     2.667    74.648     0.200
     2.964    81.266     0.200
     2.918    77.398     0.200
     3.046    85.891     0.200
     3.147    86.328     0.200
     3.276    91.195     0.200
     3.437    92.891     0.200
     3.471    96.820     0.200
     3.611    99.219     0.200
     3.887   107.516     0.200
     3.887   107.898     0.200
     3.952   106.984     0.200
     4.280   116.938     0.200
     5.714   155.180     0.200
     2.731    75.430     0.200
     3.296    90.818     0.200
     3.392    93.789     0.200
     3.911   104.789     0.200
     2.965    86.734     0.200
     4.037   113.078     0.200
     4.321   119.336     0.200
     4.338   119.945     0.200
     4.438   123.422     0.200
     4.467   120.734     0.200
     4.588   126.438     0.200
     4.744   131.406     0.200
     4.778   132.188     0.200
     4.781   132.258     0.200
     4.844   133.898     0.200
     4.881   136.359     0.200
     4.935   137.133     0.200
     5.169   141.906     0.200
     5.243   141.609     0.200
     5.271   143.734     0.200
     5.271   146.258     0.200
     6.448   172.344     0.200
     7.259   191.422     0.200
     2.419    68.031     0.200
     2.468    67.660     0.200
     2.746    74.191     0.200
     2.849    76.469     0.200
     2.946    82.750     0.200
     3.064    84.719     0.200
     3.288    90.762     0.200
     3.432    94.711     0.200
     3.469    95.840     0.200
     3.487    97.180     0.200
     3.568    99.828     0.200
     3.627    98.828     0.200
     3.840   106.621     0.200
     3.886   105.078     0.200
     4.562   120.961     0.200
     4.701   129.660     0.200
     5.661   150.691     0.200
     6.069   163.219     0.200
     6.595   170.668     0.200
     7.761   203.859     0.200
    10.135   260.852     0.200
    19.686   493.859     0.200
     2.366    63.238     0.200
     2.795    73.488     0.200
     2.791    76.066     0.200
     2.870    79.148     0.200
     2.985    83.758     0.200
     3.098    85.508     0.200
     3.209    89.816     0.200
     3.354    93.469     0.200
     3.390    94.539     0.200
     3.408    95.609     0.200
     3.489    95.969     0.200
     3.503    95.680     0.200
     3.548    97.199     0.200
     3.761   101.887     0.200
     3.807   100.887     0.200
     3.807   103.398     0.200
     3.807   105.418     0.200
     3.885   104.020     0.200
     5.601   147.199     0.200
     1.108    33.141     0.200
     2.378    66.141     0.200
     2.808    74.672     0.200
     2.788    78.984     0.200
     2.919    80.625     0.200
     3.050    84.625     0.200
     3.166    87.906     0.200
     3.272    90.383     0.200
     3.410    93.766     0.200
     3.452    94.883     0.200
     3.473    96.703     0.200
     3.548    98.344     0.200
     3.569    98.242     0.200
     3.613    97.938     0.200
     3.821   102.211     0.200
     3.864   105.102     0.200
     3.864   106.305     0.200
     3.948   109.516     0.200
     4.522   119.531     0.200
     6.556   169.375     0.200
     2.487    69.898     0.200
     2.487    70.102     0.200
     2.689    74.914     0.200
     2.917    79.094     0.200
     3.038    85.164     0.200
     3.158    88.164     0.200
     3.563    97.492     0.200
     3.582    97.758     0.200
     3.663    99.805     0.200
     3.675    97.750     0.200
     3.722   102.430     0.200
     3.934   107.164     0.200
     3.980   107.633     0.200
     3.980   108.078     0.200
     3.980   108.789     0.200
     4.059   110.875     0.200
     4.634   123.773     0.200
     5.119   137.211     0.200
     5.751   155.859     0.200
     2.404    67.805     0.200
     2.519    69.746     0.200
     2.834    76.805     0.200
     3.094    85.895     0.200
     3.210    88.133     0.200
     3.316    92.863     0.200
     3.452    93.953     0.200
     3.495    95.383     0.200
     3.591    97.656     0.200
     3.613   100.062     0.200
     3.657    99.523     0.200
     3.865   104.496     0.200
     3.907   105.703     0.200
     3.907   105.875     0.200
     3.907   107.945     0.200
     3.992   107.906     0.200
     4.141   112.312     0.200
     4.550   124.223     0.200
     4.754   129.523     0.200
     5.043   135.676     0.200
     5.667   148.414     0.200
     2.453    68.882     0.200
     2.627    71.482     0.200
     2.981    79.812     0.200
     3.092    85.682     0.200
     3.199    88.352     0.200
     3.304    90.512     0.200
     3.714   100.922     0.200
     3.763   102.112     0.200
     3.980   110.322     0.200
     4.029   111.762     0.200
     4.102   113.312     0.200
     4.266   117.172     0.200
     5.171   135.402     0.200
     5.812   151.722     0.200
     2.844    76.805     0.200
     3.558    97.484     0.200
     3.617    99.547     0.200
     3.876   105.617     0.200
     3.876   107.926     0.200
     4.693   130.926     0.200
     5.662   148.715     0.200
    10.373   265.555     0.200
     1.321    38.531     0.200
     1.560    44.109     0.200
     1.908    53.902     0.200
     2.406    68.699     0.200
     2.469    69.129     0.200
     2.662    73.199     0.200
     2.877    78.000     0.200
     2.851    78.441     0.200
     2.851    78.652     0.200
     2.907    80.422     0.200
     3.239    90.473     0.200
     3.326    91.699     0.200
     3.333    91.980     0.200
     3.594    97.789     0.200
     4.494   119.770     0.200
     4.510   122.750     0.200
     5.418   143.699     0.200
     7.101   187.879     0.200
     1.259    35.456     0.200
     2.530    69.736     0.200
     2.960    77.526     0.200
     3.027    83.496     0.200
     3.114    86.576     0.200
     3.344    91.286     0.200
     3.425    93.626     0.200
     3.481    94.756     0.200
     3.503    95.926     0.200
     3.526    96.906     0.200
     3.538    95.196     0.200
     3.633   100.446     0.200
     3.900   106.816     0.200
     3.953   107.656     0.200
     3.953   108.477     0.200
     4.671   123.876     0.200
     5.761   150.977     0.200
     5.768   147.246     0.200
     6.704   177.416     0.200
     2.342    65.607     0.200
     2.772    75.469     0.200
     2.844    80.607     0.200
     3.330    94.098     0.200
     3.366    94.219     0.200
     3.366    94.658     0.200
     3.465    94.389     0.200
     3.481    94.568     0.200
     5.576   148.648     0.200
     7.308   190.828     0.200
     2.190    61.414     0.200
     2.821    80.930     0.200
     2.996    85.281     0.200
     4.339   113.781     0.200
     6.375   167.320     0.200
     1.994    56.844     0.200
     2.634    70.398     0.200
     2.777    76.477     0.200
     3.906   105.117     0.200
     4.268   113.477     0.200
     4.265   115.188     0.200
     4.596   122.492     0.200
     4.667   123.008     0.200
     5.092   133.008     0.200
     6.044   155.047     0.200
     7.096   185.180     0.200
     1.102    32.805     0.200
     1.529    45.195     0.200
     1.762    52.234     0.200
     1.801    51.625     0.200
     2.367    63.773     0.200
     2.785    75.445     0.200
     2.795    74.734     0.200
     2.775    74.953     0.200
     3.240    87.781     0.200
     4.490   115.836     0.200
     5.543   144.523     0.200
     1.853    52.930     0.200
     2.090    58.062     0.200
     2.672    74.219     0.200
     2.668    74.719     0.200
     3.252    90.477     0.200
     5.345   142.172     0.200
     7.091   182.422     0.200
     1.437    42.758     0.200
     2.323    66.438     0.200
     2.461    70.188     0.200
     2.707    75.586     0.200
     3.137    85.719     0.200
     3.199    86.727     0.200
     3.678   101.336     0.200
     3.678   102.508     0.200
     4.055   111.734     0.200
     4.115   111.734     0.200
     4.115   114.117     0.200
     4.115   114.359     0.200
     4.357   116.586     0.200
     4.850   132.125     0.200
     5.266   139.617     0.200
     5.368   144.516     0.200
     5.941   160.578     0.200
     5.949   160.047     0.200
     1.719    50.039     0.200
     2.538    71.641     0.200
     3.230    86.180     0.200
     3.656    95.777     0.200
     3.833   104.500     0.200
     4.139   112.629     0.200
     4.285   118.438     0.200
     4.310   113.750     0.200
     4.323   117.219     0.200
     4.466   121.238     0.200
     4.760   128.598     0.200
     4.760   129.980     0.200
     4.760   132.129     0.200
     4.851   124.699     0.200
     5.861   149.750     0.200
     6.529   168.688     0.200
     6.537   172.277     0.200
     8.277   214.840     0.200
     1.276    37.867     0.200
     1.603    46.984     0.200
     2.267    63.094     0.200
     2.477    65.633     0.200
     2.681    71.523     0.200
     3.111    80.867     0.200
     3.137    84.688     0.200
     3.137    85.016     0.200
     3.420    92.555     0.200
     3.569    95.812     0.200
     3.598    95.984     0.200
     3.598    99.242     0.200
     3.604    95.055     0.200
     3.608    97.312     0.200
     3.748   100.594     0.200
     4.045   108.391     0.200
     4.045   109.016     0.200
     4.045   109.312     0.200
     4.532   120.094     0.200
     4.532   123.922     0.200
     5.301   139.883     0.200
     5.903   155.625     0.200
     1.548    43.082     0.200
     2.390    65.252     0.200
     2.812    75.973     0.200
     3.242    83.322     0.200
     3.832   104.093     0.200
     3.849   105.303     0.200
     4.282   113.782     0.200
     6.075   154.803     0.200
     6.461   170.692     0.200
     6.997   182.902     0.200
     7.818   199.952     0.200
    10.550   267.843     0.200
     3.312    88.656     0.200
     3.312    86.867     0.200
     3.741    97.008     0.200
     3.767   101.680     0.200
     4.180   117.008     0.200
     4.206   114.305     0.200
     4.485   123.852     0.200
     5.456   144.945     0.200
     5.558   148.836     0.200
     6.550   174.008     0.200
     8.276   215.586     0.200
     1.795    50.922     0.200
     1.860    52.695     0.200
     2.200    60.875     0.200
     2.500    67.523     0.200
     2.791    76.500     0.200
     2.870    78.758     0.200
     2.928    78.961     0.200
     3.136    86.383     0.200
     3.288    90.391     0.200
     3.321    88.648     0.200
     3.321    89.898     0.200
     3.321    91.641     0.200
     3.321    88.109     0.200
     3.440    93.094     0.200
     3.464    90.562     0.200
     3.766    99.672     0.200
     4.517   117.633     0.200
     5.659   148.742     0.200
     5.666   147.680     0.200
     5.940   154.445     0.200
     2.887    81.242     0.200
     3.953    99.570     0.200
     4.294   111.859     0.200
     4.351   114.953     0.200
     4.351   117.711     0.200
     4.503   123.969     0.200
     4.617   125.844     0.200
     4.758   124.102     0.200
     4.758   129.219     0.200
     4.797   126.258     0.200
     5.084   132.891     0.200
     5.051   136.438     0.200
     5.185   137.023     0.200
     5.185   139.984     0.200
     6.017   155.242     0.200
     7.582   203.133     0.200
     1.784    49.867     0.200
     2.137    57.027     0.200
     2.522    71.336     0.200
     3.407    90.297     0.200
     3.407    92.297     0.200
     3.768    99.418     0.200
     3.837    98.977     0.200
     3.844   102.055     0.200
     4.156   112.418     0.200
     4.242   111.738     0.200
     4.242   116.637     0.200
     4.242   117.105     0.200
     4.276   112.617     0.200
     4.440   120.176     0.200
     4.713   125.848     0.200
     5.495   143.957     0.200
     5.876   148.488     0.200
     6.631   169.305     0.200
     6.638   174.977     0.200
     6.873   178.906     0.200
     7.004   185.246     0.200
     7.033   187.516     0.200
     7.065   187.348     0.200
     7.496   195.918     0.200
     7.584   193.508     0.200
     8.361   214.926     0.200
     8.475   218.273     0.200
    15.894   402.957     0.200
    16.678   417.227     0.200
    19.447   485.918     0.200
    19.727   494.008     0.200
    19.600   489.582     0.200
    19.924   498.672     0.200
    19.946   497.488     0.200
    20.010   499.934     0.200
    20.158   499.109     0.200
    20.177   501.004     0.200
    20.204   499.816     0.200
    20.301   501.617     0.200
    20.533   507.656     0.200
    20.569   510.070     0.200
    20.581   509.207     0.200
    20.746   512.238     0.200
    20.839   514.086     0.200
    20.891   517.797     0.200
    21.052   518.848     0.200
    21.123   521.238     0.200
    21.192   522.375     0.200
    21.470   527.871     0.200
    21.484   527.930     0.200
    21.483   528.207     0.200
    21.507   530.992     0.200
    21.683   532.055     0.200
    22.282   546.332     0.200
     0.950    30.875     0.200
     1.488    41.383     0.200
     1.473    43.695     0.200
     1.805    51.945     0.200
     2.543    68.922     0.200
     2.543    67.336     0.200
     2.698    71.602     0.200
     2.830    75.117     0.200
     2.838    76.664     0.200
     2.838    77.148     0.200
     3.115    83.547     0.200
     3.086    86.445     0.200
     3.167    84.789     0.200
     3.167    81.469     0.200
     3.226    85.727     0.200
     3.282    89.086     0.200
     3.317    90.453     0.200
     3.317    87.883     0.200
     3.652    96.484     0.200
     3.652    99.695     0.200
     3.652    94.727     0.200
     3.996   109.234     0.200
     4.857   127.312     0.200
     5.713   145.148     0.200
     5.800   147.523     0.200
     7.409   188.117     0.200
     7.409   188.273     0.200
     1.225    36.404     0.200
     2.720    75.365     0.200
     3.991   104.404     0.200
     4.328   116.275     0.200
     4.382   115.846     0.200
     4.529   124.475     0.200
     5.013   132.904     0.200
     7.926   207.346     0.200
     8.922   227.334     0.200
    10.652   268.311     0.200
    16.373   410.535     0.200
    20.310   503.619     0.200
     2.226    63.926     0.200
     2.697    75.184     0.200
     3.114    85.223     0.200
     3.235    89.355     0.200
     3.349    89.734     0.200
     3.552    97.504     0.200
     3.713    98.523     0.200
     3.735   101.285     0.200
     4.164   112.125     0.200
     4.268   117.176     0.200
     4.844   128.844     0.200
     4.844   126.754     0.200
     5.264   142.445     0.200
     5.953   157.105     0.200
     6.344   172.965     0.200
     6.344   164.293     0.200
     6.879   177.176     0.200
     2.257    64.352     0.200
     2.715    75.203     0.200
     2.755    79.750     0.200
     3.986   107.320     0.200
     3.986   109.320     0.200
     4.271   115.195     0.200
     4.302   116.625     0.200
     4.302   118.625     0.200
     4.601   123.281     0.200
     4.686   125.156     0.200
     4.700   127.477     0.200
     4.880   129.602     0.200
     4.917   132.477     0.200
     5.105   138.383     0.200
     7.150   187.406     0.200
     7.364   193.023     0.200
     8.145   212.383     0.200
     8.204   215.664     0.200
    10.575   273.750     0.200
     0.408    16.434     0.200
     1.608    45.645     0.200
     2.072    58.355     0.200
     2.878    77.766     0.200
     2.878    75.336     0.200
     3.029    81.883     0.200
     3.187    85.055     0.200
     3.258    86.645     0.200
     3.258    87.824     0.200
     3.306    87.914     0.200
     3.306    85.805     0.200
     4.134   108.594     0.200
     4.134   110.594     0.200
     4.355   115.676     0.200
     4.912   128.293     0.200
     5.007   130.246     0.200
     6.056   160.785     0.200
     0.566    22.336     0.200
     1.854    51.576     0.200
     1.854    55.456     0.200
     2.853    76.806     0.200
     2.950    79.406     0.200
     2.950    78.026     0.200
     3.178    83.996     0.200
     3.214    86.426     0.200
     3.568    95.786     0.200
     3.619    96.066     0.200
     3.984   105.086     0.200
     4.049   108.556     0.200
     5.056   132.666     0.200
     5.056   130.426     0.200
     5.239   136.176     0.200
     6.058   155.806     0.200
     6.200   159.456     0.200
     6.986   179.576     0.200
     7.074   180.466     0.200
     7.768   197.230     0.200
    12.424   310.673     0.200
    16.440   401.836     0.200
     2.391    68.105     0.200
     2.630    76.516     0.200
     2.695    77.336     0.200
     2.815    78.645     0.200
     3.050    87.078     0.200
     3.251    92.656     0.200
     3.276    93.227     0.200
     3.343    93.145     0.200
     3.622   101.156     0.200
     4.352   118.145     0.200
     4.492   120.555     0.200
     5.505   147.578     0.200
     6.510   172.586     0.200
     7.224   190.156     0.200
     1.760    50.502     0.200
     2.432    68.711     0.200
     2.862    76.752     0.200
     3.010    83.521     0.200
     0.710    23.977     0.200
     1.349    37.617     0.200
     1.420    43.875     0.200
     1.506    43.539     0.200
     1.795    52.305     0.200
     2.106    58.234     0.200
     2.546    71.031     0.200
     2.610    70.336     0.200
     2.949    79.789     0.200
     3.188    88.555     0.200
     3.375    90.984     0.200
     3.388    93.258     0.200
     3.830   101.336     0.200
     3.863   104.578     0.200
     4.338   114.047     0.200
     5.755   148.461     0.200
     6.748   175.438     0.200
     7.476   188.656     0.200
     0.906    28.055     0.200
     2.175    58.863     0.200
     4.306   113.164     0.200
     4.681   128.074     0.200
     5.381   142.324     0.200
     6.335   163.965     0.200
     9.854   253.543     0.200
    12.544   320.273     0.200
    20.250   502.824     0.200
    21.064   528.805     0.200
     0.249    14.156     0.200
     0.934    29.539     0.200
     1.941    52.367     0.200
     1.941    54.738     0.200
     2.225    59.887     0.200
     2.780    73.180     0.200
     2.778    74.816     0.200
     2.869    74.969     0.200
     3.573    93.309     0.200
     1.441    42.281     0.200
     2.488    68.062     0.200
     3.359    92.766     0.200
     4.186   116.812     0.200
     4.854   127.930     0.200
    12.699   325.695     0.200
    13.779   346.742     0.200
    14.813   381.242     0.200
     0.286    15.714     0.200
     1.161    33.603     0.200
     1.192    35.724     0.200
     1.387    38.833     0.200
     1.714    46.714     0.200
     2.081    56.843     0.200
     2.139    59.893     0.200
     2.985    79.123     0.200
     2.979    79.264     0.200
     3.008    79.803     0.200
     7.904   200.483     0.200
     9.528   240.780     0.200
     0.964    28.615     0.200
     1.090    32.396     0.200
     1.664    48.846     0.200
     1.777    50.195     0.200
     1.681    52.217     0.200
     1.885    53.865     0.200
     2.341    62.086     0.200
     2.609    70.855     0.200
     2.596    72.676     0.200
     2.688    73.615     0.200
     2.821    74.977     0.200
     3.142    84.986     0.200
     3.150    84.986     0.200
     3.589    97.467     0.200
     4.720   124.035     0.200
     7.203   183.250     0.200
     0.786    25.245     0.200
     1.145    33.255     0.200
     1.765    50.875     0.200
     1.869    54.415     0.200
     1.995    55.755     0.200
     2.056    57.064     0.200
     2.068    57.484     0.200
     2.438    68.245     0.200
     2.486    67.734     0.200
     2.575    71.765     0.200
     2.693    73.955     0.200
     2.721    74.314     0.200
     3.077    84.455     0.200
     3.137    85.654     0.200
     3.309    93.965     0.200
     3.470    93.845     0.200
     3.534    96.595     0.200
     3.637    97.165     0.200
     3.673    97.614     0.200
     0.779    30.772     0.200
     0.794    31.982     0.200
     0.995    35.722     0.200
     1.759    51.582     0.200
     1.759    49.812     0.200
     1.961    55.702     0.200
     1.961    54.292     0.200
     2.044    57.762     0.200
     2.044    58.592     0.200
     2.337    64.172     0.200
     2.564    68.532     0.200
     3.193    85.232     0.200
     3.193    80.832     0.200
     3.320    87.452     0.200
     3.791   100.142     0.200
     4.396   111.052     0.200
     7.900   199.166     0.200
     0.943    29.195     0.200
     1.109    32.906     0.200
     1.646    48.523     0.200
     1.691    48.996     0.200
     1.907    52.637     0.200
     2.361    64.766     0.200
     2.631    71.547     0.200
     2.709    74.074     0.200
     2.787    71.285     0.200
     2.800    75.453     0.200
     7.225   182.875     0.200
     0.926    30.387     0.200
     2.333    64.406     0.200
     2.587    69.666     0.200
     3.203    88.026     0.200
     4.329   113.586     0.200
     8.264   209.133     0.200
     1.531    46.102     0.200
     1.465    43.258     0.200
     2.454    70.172     0.200
     2.733    75.141     0.200
     4.180   112.273     0.200
     0.923    30.219     0.200
     8.363   217.828     0.200
     0.679    22.711     0.200
     1.360    39.062     0.200
     1.418    43.211     0.200
     1.493    44.375     0.200
     1.831    54.305     0.200
     2.179    61.164     0.200
     2.530    69.305     0.200
     2.623    69.969     0.200
     2.907    78.422     0.200
     2.978    80.445     0.200
     3.191    86.242     0.200
     7.501   188.734     0.200
     0.599    20.219     0.200
     0.599    20.383     0.200
     1.425    39.289     0.200
     2.502    64.102     0.200
     2.537    69.703     0.200
     3.247    87.148     0.200
     4.112   111.508     0.200
     4.171   111.242     0.200
     5.013   136.648     0.200
     5.165   134.789     0.200
     8.707   218.891     0.200
     0.733    24.727     0.200
     1.358    39.535     0.200
     2.138    59.885     0.200
     2.615    71.486     0.200
     2.872    78.736     0.200
     2.934    80.727     0.200
     3.367    91.906     0.200
     3.930   105.635     0.200
     4.726   124.266     0.200
     3.456    93.591     0.200
     4.712   122.071     0.200
     5.684   146.461     0.200
     7.004   177.599     0.200
     9.418   242.681     0.200
    18.926   465.631     0.200
     1.963    53.934     0.200
     1.983    57.133     0.200
     4.572   126.004     0.200
     4.667   123.941     0.200
     8.214   215.312     0.200
     1.021    34.688     0.200
     2.543    71.574     0.200
     2.615    73.867     0.200
     3.511    96.344     0.200
     5.293   139.254     0.200
     0.125    24.812     0.200
     0.361    26.148     0.200
     1.114    38.422     0.200
     1.862    51.453     0.200
     2.314    65.609     0.200
     2.592    71.328     0.200
     2.723    75.375     0.200
     3.321    89.711     0.200
     3.967    99.812     0.200
     4.454   122.789     0.200
     8.644   219.195     0.200
    13.336   333.648     0.200
     1.997    56.787     0.200
     1.997    55.948     0.200
     3.336    90.448     0.200
     4.456   120.217     0.200
     6.882   173.432     0.200
     1.462    41.461     0.200
     1.958    55.781     0.200
     2.221    62.664     0.200
     2.630    72.344     0.200
     3.267    88.973     0.200
     3.320    89.473     0.200
     3.659    98.832     0.200
     3.659    98.172     0.200
     3.723   100.574     0.200
     4.046   108.863     0.200
     2.274    62.430     0.200
     4.226   111.141     0.200
     1.051    33.801     0.200
     1.230    40.821     0.200
     1.979    55.021     0.200
     3.649    96.231     0.200
     3.807   106.661     0.200
     4.372   119.451     0.200
     4.565   120.321     0.200
     4.682   122.311     0.200
     4.853   134.761     0.200
     5.767   156.011     0.200
     8.230   209.006     0.200
     1.216    37.484     0.200
     2.102    58.064     0.200
     2.605    72.895     0.200
     3.070    83.346     0.200
     3.820   100.285     0.200
     3.960   107.645     0.200
     9.160   232.584     0.200
     0.957    31.969     0.200
     1.299    36.797     0.200
     2.642    72.320     0.200
     3.518    95.008     0.200
     4.467   119.969     0.200
     5.072   137.680     0.200
     5.307   140.828     0.200
     5.975   157.359     0.200
     6.055   158.828     0.200
     6.522   174.953     0.200
     7.075   183.461     0.200
     0.880    28.227     0.200
     1.305    37.660     0.200
     1.467    43.160     0.200
     1.585    46.309     0.200
     2.079    58.898     0.200
     2.576    67.840     0.200
     2.588    69.930     0.200
     3.130    81.148     0.200
     3.352    93.539     0.200
     3.423    92.609     0.200
     3.749   103.438     0.200
     3.838   107.090     0.200
     4.108   107.957     0.200
     4.805   122.598     0.200
     5.738   150.957     0.200
     6.751   171.777     0.200
     0.582    20.773     0.200
     1.344    37.570     0.200
     2.615    69.730     0.200
     2.544    71.281     0.200
     2.984    82.312     0.200
     4.026   104.293     0.200
     4.715   120.461     0.200
     1.169    39.039     0.200
     1.180    39.158     0.200
     1.212    40.488     0.200
     1.226    39.859     0.200
     1.916    55.389     0.200
     2.500    70.699     0.200
     3.288    91.879     0.200
     3.691    97.439     0.200
     3.847   105.049     0.200
     3.815   103.998     0.200
     4.035   112.248     0.200
     4.153   106.518     0.200
     4.172   111.398     0.200
     4.182   115.469     0.200
     4.203   113.578     0.200
     4.193   116.209     0.200
     4.199   109.248     0.200
     4.221   114.518     0.200
     4.283   111.418     0.200
     4.413   111.168     0.200
     4.309   114.949     0.200
     4.366   114.379     0.200
     4.413   113.459     0.200
     4.413   118.139     0.200
     4.445   122.469     0.200
     4.718   124.109     0.200
     4.666   124.979     0.200
     5.434   139.588     0.200
     5.522   145.828     0.200
     5.820   149.369     0.200
     6.391   174.168     0.200
     6.527   168.359     0.200
     7.309   184.639     0.200
     7.542   202.469     0.200
     8.261   213.648     0.200
    11.210   278.398     0.200
    11.333   281.348     0.200
     0.300    15.914     0.200
     0.867    27.820     0.200
     0.953    28.992     0.200
     1.057    32.414     0.200
     1.073    33.562     0.200
     1.077    32.734     0.200
     1.098    35.773     0.200
     1.120    34.367     0.200
     1.349    39.492     0.200
     1.806    49.352     0.200
     2.122    59.086     0.200
     2.640    71.391     0.200
     2.864    75.984     0.200
     3.076    80.961     0.200
     3.374    89.016     0.200
     3.434    92.305     0.200
     3.857   107.320     0.200
     4.187   105.820     0.200
     4.293   112.914     0.200
     4.280   111.977     0.200
     4.430   114.055     0.200
     7.968   198.586     0.200
     1.049    32.746     0.200
     1.107    34.605     0.200
     2.965    79.543     0.200
     3.173    82.594     0.200
     3.537    96.934     0.200
     3.729   102.395     0.200
     3.716   103.703     0.200
     3.763   102.336     0.200
     3.804    97.145     0.200
     3.818   105.566     0.200
     3.965   106.156     0.200
     4.015   110.535     0.200
     4.177   109.977     0.200
     4.175   115.234     0.200
     4.180   115.113     0.200
     4.187   115.543     0.200
     4.265   115.746     0.200
     4.345   118.137     0.200
     4.426   118.504     0.200
     4.619   123.105     0.200
     4.678   119.906     0.200
     5.761   151.625     0.200
     8.225   211.262     0.200
     0.874    27.156     0.200
     1.929    50.816     0.200
     1.983    53.273     0.200
     2.847    75.566     0.200
     3.200    83.695     0.200
     3.565    97.145     0.200
     3.649    97.426     0.200
     3.605    98.246     0.200
     3.703    99.184     0.200
     3.728   102.895     0.200
     3.871   102.805     0.200
     3.922   103.594     0.200
     4.090   111.336     0.200
     4.473   121.227     0.200
     4.530   122.984     0.200
     4.612   119.055     0.200
     4.974   128.504     0.200
     5.343   135.934     0.200
     5.722   146.285     0.200
     5.973   156.887     0.200
     0.774    25.531     0.200
     0.875    27.410     0.200
     1.263    35.980     0.200
     1.379    40.242     0.200
     1.490    44.410     0.200
     1.494    43.992     0.200
     1.493    44.211     0.200
     1.513    45.172     0.200
     1.559    43.844     0.200
     1.523    44.172     0.200
     1.618    46.613     0.200
     1.645    48.223     0.200
     1.999    56.551     0.200
     2.507    64.660     0.200
     2.737    74.301     0.200
     2.793    77.582     0.200
     3.024    79.812     0.200
     3.062    86.371     0.200
     3.202    90.551     0.200
     3.225    87.082     0.200
     3.596    92.910     0.200
     3.665    99.742     0.200
     3.699    99.312     0.200
     3.796    97.434     0.200
     3.829   100.762     0.200
     4.135   105.250     0.200
     4.607   115.031     0.200
     4.613   119.422     0.200
     4.936   129.293     0.200
     5.124   136.773     0.200
     6.361   163.312     0.200
     7.330   184.602     0.200
     0.564    19.736     0.200
     1.005    29.895     0.200
     1.754    50.305     0.200
     1.853    53.275     0.200
     1.957    55.305     0.200
     2.277    62.564     0.200
     2.510    67.096     0.200
     2.840    77.736     0.200
     3.037    84.695     0.200
     3.099    86.314     0.200
     3.143    86.256     0.200
     3.272    90.205     0.200
     3.393    88.166     0.200
     3.319    88.166     0.200
     3.316    91.705     0.200
     3.319    86.686     0.200
     3.396    94.135     0.200
     3.413    93.686     0.200
     3.466    95.645     0.200
     3.559    98.564     0.200
     3.579    98.756     0.200
     3.570    97.695     0.200
     3.587    97.635     0.200
     3.685    99.535     0.200
     3.684    95.064     0.200
     3.707   101.475     0.200
     3.817    99.455     0.200
     3.867   104.715     0.200
     3.865   107.586     0.200
     4.061   105.086     0.200
     4.412   115.016     0.200
     4.379   110.805     0.200
     4.489   119.365     0.200
     4.787   125.086     0.200
     5.432   138.926     0.200
     5.494   145.525     0.200
     5.452   146.125     0.200
     5.807   159.625     0.200
     6.289   158.645     0.200
     6.443   161.996     0.200
     7.232   182.615     0.200
     0.287    14.674     0.200
     1.770    47.402     0.200
     2.620    74.033     0.200
     2.620    70.084     0.200
     3.041    77.883     0.200
     2.830    80.193     0.200
     3.350    90.193     0.200
     3.350    89.223     0.200
     3.416    90.613     0.200
     3.354    95.062     0.200
     3.844   100.043     0.200
     4.280   113.213     0.200
     4.281   113.213     0.200
     4.404   114.604     0.200
     4.753   120.812     0.200
     5.074   130.812     0.200
     5.172   132.363     0.200
     5.217   138.844     0.200
     5.217   133.283     0.200
     5.529   142.684     0.200
     7.944   200.611     0.200
     0.798    25.090     0.200
     0.906    28.649     0.200
     1.395    37.949     0.200
     1.358    41.850     0.200
     1.362    39.550     0.200
     1.361    42.119     0.200
     1.437    40.629     0.200
     1.391    43.529     0.200
     1.490    43.579     0.200
     1.587    43.229     0.200
     1.661    47.289     0.200
     2.187    58.510     0.200
     2.294    63.399     0.200
     2.540    67.050     0.200
     2.639    68.229     0.200
     2.854    77.069     0.200
     2.898    80.959     0.200
     3.317    93.100     0.200
     3.405    92.289     0.200
     3.915   100.350     0.200
     3.953   103.529     0.200
     4.247   107.399     0.200
     4.198   114.119     0.200
     4.569   118.109     0.200
     4.736   118.949     0.200
     4.733   122.619     0.200
     4.926   125.569     0.200
     5.059   129.970     0.200
     5.231   135.100     0.200
     5.752   147.029     0.200
     5.733   149.229     0.200
     5.733   149.229     0.200
     6.751   168.329     0.200
     1.118    33.508     0.200
     1.314    38.067     0.200
     2.374    65.688     0.200
     2.423    69.067     0.200
     2.736    76.978     0.200
     2.902    78.817     0.200
     3.192    88.548     0.200
     3.708   100.628     0.200
     3.728   100.728     0.200
     4.061   109.868     0.200
     4.381   112.098     0.200
     4.488   117.548     0.200
     4.520   117.008     0.200
     4.834   121.948     0.200
     5.059   130.317     0.200
     0.973    33.232     0.200
     1.029    34.492     0.200
     1.074    36.002     0.200
     1.078    35.682     0.200
     1.071    35.662     0.200
     1.097    37.102     0.200
     1.120    37.152     0.200
     1.130    38.441     0.200
     1.788    52.562     0.200
     1.990    57.992     0.200
     2.779    80.281     0.200
     2.803    78.672     0.200
     2.840    80.072     0.200
     3.057    88.271     0.200
     3.319    96.002     0.200
     3.309    92.791     0.200
     3.364    96.541     0.200
     3.498    93.691     0.200
     3.454    97.201     0.200
     3.595    98.211     0.200
     3.644   104.752     0.200
     3.788   103.172     0.200
     3.790   102.881     0.200
     3.790   103.172     0.200
     3.887   110.551     0.200
     3.911   110.322     0.200
     4.010   114.521     0.200
     4.166   111.271     0.200
     4.219   116.652     0.200
     4.218   116.652     0.200
     4.261   116.652     0.200
     4.262   116.652     0.200
     4.263   117.701     0.200
     4.364   115.461     0.200
     4.404   118.971     0.200
     4.428   119.961     0.200
     4.748   124.631     0.200
     5.070   135.562     0.200
     5.183   135.951     0.200
     5.219   140.441     0.200
     5.337   141.672     0.200
     5.436   145.191     0.200
     5.448   145.252     0.200
     5.534   144.701     0.200
     5.737   150.131     0.200
     6.009   158.691     0.200
     6.202   159.932     0.200
     6.222   163.412     0.200
     6.221   163.412     0.200
     7.209   187.121     0.200
     7.942   205.102     0.200
     1.127    32.871     0.200
     1.678    47.750     0.200
     2.427    68.129     0.200
     2.640    72.539     0.200
     2.715    75.359     0.200
     2.901    76.480     0.200
     2.785    77.090     0.200
     3.165    86.211     0.200
     3.610    99.039     0.200
     3.695    96.168     0.200
     3.720    99.289     0.200
     3.601   100.371     0.200
     1.253    36.996     0.200
     1.307    39.117     0.200
     1.665    47.066     0.200
     1.873    53.637     0.200
     1.873    51.107     0.200
     2.079    56.906     0.200
     2.433    69.688     0.200
     2.823    77.576     0.200
     3.044    84.176     0.200
     3.141    86.477     0.200
     3.127    86.656     0.200
     3.628    97.566     0.200
     3.701    97.336     0.200
     4.069   109.576     0.200
     4.080   108.207     0.200
     4.266   115.447     0.200
     4.522   120.076     0.200
     4.523   120.076     0.200
     4.535   120.807     0.200
     4.536   120.807     0.200
     4.574   120.598     0.200
     4.944   128.566     0.200
     5.263   136.938     0.200
     5.288   141.086     0.200
     5.380   142.477     0.200
     5.661   144.637     0.200
     5.676   149.496     0.200
     5.718   152.326     0.200
     5.947   157.188     0.200
     6.177   166.127     0.200
     6.307   165.047     0.200
     7.037   186.057     0.200
     7.322   191.826     0.200
     8.121   211.518     0.200
     8.921   233.268     0.200
     0.922    29.520     0.200
     0.950    30.992     0.200
     1.077    34.621     0.200
     1.109    35.461     0.200
     1.657    45.742     0.200
     1.887    52.469     0.200
     2.817    76.500     0.200
     3.157    79.891     0.200
     2.971    79.980     0.200
     3.079    87.012     0.200
     3.620    99.129     0.200
     3.611    99.930     0.200
     4.066   104.301     0.200
     4.504   118.871     0.200
     4.505   118.871     0.200
     4.505   121.262     0.200
     0.911    29.309     0.200
     0.791    28.941     0.200
     1.017    32.621     0.200
     1.195    36.840     0.200
     1.262    40.211     0.200
     1.259    39.359     0.200
     1.269    40.219     0.200
     1.291    40.418     0.200
     1.314    39.910     0.200
     1.310    39.918     0.200
     1.432    42.418     0.200
     1.454    43.199     0.200
     1.508    42.469     0.200
     1.692    47.020     0.200
     2.106    58.789     0.200
     2.165    61.301     0.200
     2.499    67.328     0.200
     2.507    66.781     0.200
     2.724    71.270     0.200
     2.867    76.941     0.200
     2.878    76.699     0.200
     3.118    81.391     0.200
     3.220    83.328     0.200
     3.267    89.180     0.200
     3.693   101.031     0.200
     3.792    97.820     0.200
     3.932   100.430     0.200
     4.243   108.609     0.200
     4.566   117.129     0.200
     0.820    26.133     0.200
     1.146    32.785     0.200
     1.205    34.113     0.200
     1.537    43.902     0.200
     1.599    47.094     0.200
     1.594    46.934     0.200
     1.607    47.895     0.200
     1.626    49.062     0.200
     1.656    48.273     0.200
     1.763    48.625     0.200
     1.773    52.445     0.200
     1.794    49.445     0.200
     2.394    63.805     0.200
     2.503    68.844     0.200
     2.553    69.402     0.200
     2.881    79.293     0.200
     3.593    94.922     0.200
     3.644    95.793     0.200
     3.912   105.215     0.200
     1.168    37.479     0.200
     1.976    56.619     0.200
     2.156    61.470     0.200
     2.469    70.869     0.200
     2.502    72.339     0.200
     2.844    80.879     0.200
     3.205    89.760     0.200
     3.243    91.770     0.200
     3.283    93.499     0.200
     3.344    93.909     0.200
     3.423    96.270     0.200
     3.431    97.890     0.200
     3.440    98.359     0.200
     3.516    91.839     0.200
     3.536    93.779     0.200
     3.572    93.999     0.200
     3.614    94.010     0.200
     3.673   100.819     0.200
     3.621   100.180     0.200
     3.844   103.760     0.200
     3.940   110.619     0.200
     4.308   115.260     0.200
     4.587   126.020     0.200
     4.910   130.579     0.200
     5.131   135.069     0.200
     5.195   139.119     0.200
     5.216   140.319     0.200
     5.399   146.579     0.200
     5.484   141.079     0.200
     5.530   145.390     0.200
     6.118   158.729     0.200
     6.224   164.020     0.200
     6.352   169.539     0.200
     6.512   175.209     0.200
     6.846   178.909     0.200
     7.205   185.829     0.200
     8.414   215.279     0.200
     8.783   233.060     0.200
     9.754   247.739     0.200
     2.908    80.881     0.200
     3.116    85.461     0.200
     3.518    93.320     0.200
     3.563    96.051     0.200
     3.602    97.431     0.200
     3.675   101.561     0.200
     3.665   102.201     0.200
     3.851   102.911     0.200
     3.958   109.011     0.200
     4.066   111.530     0.200
     4.073   104.801     0.200
     4.073   113.461     0.200
     4.162   112.081     0.200
     4.170   109.820     0.200
     4.181   112.971     0.200
     4.240   117.511     0.200
     4.230   112.051     0.200
     4.312   116.771     0.200
     4.364   119.131     0.200
     4.524   118.581     0.200
     4.500   124.591     0.200
     4.517   120.461     0.200
     4.540   118.141     0.200
     4.564   123.831     0.200
     4.783   127.230     0.200
     5.262   145.110     0.200
     5.354   139.030     0.200
     5.650   147.730     0.200
     5.636   145.610     0.200
     5.922   155.241     0.200
     6.167   163.991     0.200
     6.281   160.461     0.200
     6.359   161.711     0.200
     7.051   186.201     0.200
     7.297   187.931     0.200
     7.527   197.440     0.200
     8.096   212.360     0.200
     2.451    68.047     0.200
     2.700    74.285     0.200
     2.890    78.914     0.200
     3.166    86.938     0.200
     3.493    93.746     0.200
     3.420    94.055     0.200
     3.861    99.176     0.200
     3.931   103.664     0.200
     3.972   103.617     0.200
     4.022   105.387     0.200
     4.275   110.715     0.200
     4.327   114.566     0.200
     4.424   117.234     0.200
     4.664   122.688     0.200
     4.995   127.246     0.200
     5.087   125.766     0.200
     5.264   136.777     0.200
     5.680   143.785     0.200
     5.909   144.406     0.200
     5.944   147.547     0.200
     5.992   146.867     0.200
     5.814   150.766     0.200
     6.264   158.566     0.200
     6.288   164.457     0.200
     7.001   178.895     0.200
     0.414    16.670     0.200
     0.901    26.658     0.200
     1.080    33.479     0.200
     1.239    34.199     0.200
     1.611    44.520     0.200
     1.524    41.799     0.200
     1.876    54.109     0.200
     1.901    53.488     0.200
     1.919    52.879     0.200
     1.876    51.529     0.200
     2.116    55.988     0.200
     2.338    64.199     0.200
     2.413    64.479     0.200
     2.623    70.799     0.200
     2.717    68.928     0.200
     2.872    77.408     0.200
     2.891    79.197     0.200
     3.195    84.139     0.200
     3.354    90.400     0.200
     3.063    82.261     0.200
     3.869   106.871     0.200
     4.874   134.641     0.200
     5.306   145.591     0.200
     5.601   148.900     0.200
     1.153    37.930     0.200
     1.625    48.070     0.200
     2.212    63.758     0.200
     2.198    62.602     0.200
     2.198    62.898     0.200
     2.413    67.383     0.200
     2.873    81.648     0.200
     2.979    84.172     0.200
     3.250    89.977     0.200
     3.430    94.898     0.200
     3.541    91.289     0.200
     3.499    98.969     0.200
     3.479    95.570     0.200
     3.578    99.133     0.200
     3.597   100.617     0.200
     3.603    95.398     0.200
     3.613    99.492     0.200
     3.751   106.008     0.200
     3.857   107.023     0.200
     3.881   105.141     0.200
     4.063   110.148     0.200
     4.563   125.570     0.200
     4.692   128.781     0.200
     4.853   128.539     0.200
     4.970   131.078     0.200
     5.043   132.250     0.200
     5.581   146.570     0.200
     6.089   162.797     0.200
     7.441   187.242     0.200
     0.948    27.828     0.200
     0.923    29.578     0.200
     0.929    31.527     0.200
     0.938    32.105     0.200
     0.947    32.258     0.200
     0.962    33.176     0.200
     0.982    33.516     0.200
     1.020    33.555     0.200
     1.126    36.176     0.200
     1.220    36.855     0.200
     1.540    46.168     0.200
     1.859    51.055     0.200
     1.913    57.348     0.200
     2.377    65.766     0.200
     3.063    84.328     0.200
     3.122    86.508     0.200
     3.148    86.695     0.200
     3.467    93.055     0.200
     3.546    97.715     0.200
     4.117   109.715     0.200
     4.501   122.727     0.200
     4.824   126.055     0.200
     5.386   142.277     0.200
     5.451   136.656     0.200
     0.916    29.635     0.200
     0.959    30.755     0.200
     1.909    53.995     0.200
     2.426    69.015     0.200
     2.849    80.005     0.200
     3.178    83.695     0.200
     3.560    96.155     0.200
     3.617    96.665     0.200
     3.652   100.445     0.200
     3.736   100.675     0.200
     3.715    99.595     0.200
     3.938   107.495     0.200
     4.100   104.325     0.200
     4.542   117.805     0.200
     4.971   129.555     0.200
     5.291   137.325     0.200
     5.411   140.734     0.200
     5.709   152.535     0.200
     0.980    31.244     0.200
     1.023    32.145     0.200
     3.043    85.475     0.200
     3.832   105.135     0.200
     3.919   103.373     0.200
     4.075   108.424     0.200
     4.251   108.264     0.200
     4.519   122.273     0.200
     4.562   123.123     0.200
     4.581   126.293     0.200
     4.934   127.023     0.200
     5.252   133.635     0.200
     5.272   133.404     0.200
     5.367   132.555     0.200
     5.663   143.215     0.200
     5.938   155.514     0.200
     3.334    93.320     0.200
     3.682   102.771     0.200
     3.915   110.932     0.200
     3.989   106.980     0.200
     4.185   114.441     0.200
     4.323   113.721     0.200
     4.450   124.131     0.200
     4.557   127.410     0.200
     4.972   139.141     0.200
     5.229   137.891     0.200
     5.268   142.131     0.200
     5.550   148.861     0.200
     5.873   151.051     0.200
     0.901    30.098     0.200
     1.161    36.518     0.200
     1.153    37.146     0.200
     1.202    40.227     0.200
     1.217    40.857     0.200
     1.219    38.707     0.200
     1.541    44.617     0.200
     2.173    60.637     0.200
     3.029    78.527     0.200
     3.057    85.617     0.200
     3.238    85.117     0.200
     3.649    99.057     0.200
     3.710   102.418     0.200
     3.752   103.078     0.200
     3.795   103.707     0.200
     4.027   110.238     0.200
     4.118   113.018     0.200
     4.135   111.787     0.200
     4.143   107.068     0.200
     4.197   112.277     0.200
     4.230   110.588     0.200
     4.361   111.707     0.200
     4.381   122.438     0.200
     4.564   117.396     0.200
     4.580   125.457     0.200
     4.602   126.967     0.200
     4.628   120.967     0.200
     4.657   126.158     0.200
     5.006   129.797     0.200
     5.340   138.547     0.200
     5.382   139.707     0.200
     5.464   144.627     0.200
     5.729   147.418     0.200
     5.764   152.848     0.200
     5.613   151.396     0.200
     5.999   152.277     0.200
     6.020   153.828     0.200
     6.160   164.877     0.200
     6.328   170.758     0.200
     6.402   161.367     0.200
     6.469   165.896     0.200
     6.746   179.107     0.200
     6.942   179.428     0.200
     7.249   184.908     0.200
     7.416   189.238     0.200
     7.348   185.988     0.200
     7.855   207.467     0.200
     7.806   202.008     0.200
     8.865   232.098     0.200
     8.828   235.818     0.200
     9.369   241.887     0.200
     9.674   248.547     0.200
     9.636   250.867     0.200
     9.917   257.697     0.200
    10.487   268.127     0.200
    10.941   286.748     0.200
    12.539   314.977     0.200
    12.697   320.117     0.200
    13.443   343.557     0.200
    14.401   362.408     0.200
    14.695   364.547     0.200
     0.318    14.977     0.200
     1.074    31.453     0.200
     1.152    35.555     0.200
     1.184    35.023     0.200
     1.233    37.656     0.200
     1.199    36.984     0.200
     1.203    37.586     0.200
     1.222    37.797     0.200
     1.259    37.664     0.200
     1.245    38.055     0.200
     1.254    39.039     0.200
     1.363    38.875     0.200
     1.829    53.219     0.200
     2.957    83.344     0.200
     3.351    93.398     0.200
     4.683   119.625     0.200
     5.004   125.023     0.200
     5.451   137.336     0.200
     1.195    34.148     0.200
     2.254    59.668     0.200
     2.459    64.586     0.200
     2.731    72.816     0.200
     2.904    77.898     0.200
     3.045    83.426     0.200
     3.586    89.758     0.200
     3.506    96.137     0.200
     3.541    97.598     0.200
     3.565    93.309     0.200
     3.590    98.355     0.200
     3.613    97.469     0.200
     3.554    95.328     0.200
     4.015   110.777     0.200
    11.377   291.797     0.200
     0.849    28.768     0.200
     1.111    33.297     0.200
     1.333    38.008     0.200
     1.431    41.967     0.200
     1.350    40.387     0.200
     1.505    41.877     0.200
     1.474    42.627     0.200
     1.481    44.146     0.200
     1.489    44.717     0.200
     1.507    45.457     0.200
     1.527    44.557     0.200
     1.673    46.098     0.200
     1.655    47.838     0.200
     1.693    47.418     0.200
     1.866    51.396     0.200
     2.290    60.838     0.200
     2.405    62.508     0.200
     2.517    66.938     0.200
     2.628    69.607     0.200
     2.636    72.736     0.200
     2.745    71.957     0.200
     2.907    76.076     0.200
     3.030    81.547     0.200
     3.571    93.117     0.200
     0.470    22.469     0.200
     0.603    26.195     0.200
     0.604    25.789     0.200
     0.617    25.711     0.200
     0.643    26.516     0.200
     0.655    27.016     0.200
     0.694    26.602     0.200
     0.730    26.492     0.200
     0.728    26.992     0.200
     0.712    26.391     0.200
     1.442    41.570     0.200
     1.685    47.695     0.200
     1.780    49.375     0.200
     2.014    56.828     0.200
     2.170    57.359     0.200
     2.365    62.711     0.200
     2.830    74.922     0.200
     2.917    76.688     0.200
     3.082    80.875     0.200
     3.419    87.422     0.200
     3.593    94.586     0.200
     3.591    95.625     0.200
     3.952   102.266     0.200
     4.366   121.680     0.200
     4.504   114.672     0.200
     4.659   117.828     0.200
     4.964   124.711     0.200
     5.287   132.359     0.200
     5.480   137.391     0.200
     5.818   147.258     0.200
     5.924   149.438     0.200
     0.552    19.963     0.200
     1.550    43.103     0.200
     2.813    79.083     0.200
     3.343    87.763     0.200
     3.562    99.442     0.200
     3.915   100.493     0.200
     3.999   108.293     0.200
     4.137   105.343     0.200
     4.165   105.993     0.200
     4.261   117.933     0.200
     4.479   114.032     0.200
     4.800   123.663     0.200
     4.929   126.022     0.200
     4.953   128.293     0.200
     0.475    15.833     0.200
     2.338    65.823     0.200
     2.542    69.463     0.200
     3.170    85.153     0.200
     3.609    96.483     0.200
     3.508    97.853     0.200
     3.957   105.203     0.200
     4.154   109.583     0.200
     4.100   112.223     0.200
     4.154   108.383     0.200
     4.218   115.983     0.200
     4.304   115.693     0.200
     4.344   117.313     0.200
     4.360   114.443     0.200
     4.401   119.983     0.200
     4.437   120.603     0.200
     4.486   123.673     0.200
     4.724   120.553     0.200
     4.663   126.133     0.200
     4.755   125.953     0.200
     4.755   126.123     0.200
     4.717   127.273     0.200
     4.784   128.923     0.200
     4.784   130.333     0.200
     4.787   127.903     0.200
     4.968   127.923     0.200
     5.308   135.923     0.200
     5.629   143.753     0.200
     5.743   146.233     0.200
     5.783   148.083     0.200
     5.927   155.313     0.200
     5.984   159.773     0.200
     6.099   155.713     0.200
     6.291   163.843     0.200
     6.529   164.833     0.200
     8.504   213.783     0.200
     9.155   238.413     0.200
     1.198    37.181     0.200
     1.337    40.340     0.200
     1.682    47.101     0.200
     1.846    51.910     0.200
     1.952    59.090     0.200
     2.071    58.050     0.200
     2.101    59.811     0.200
     2.443    69.160     0.200
     2.831    79.440     0.200
     3.289    87.650     0.200
     3.380    90.330     0.200
     3.697    99.260     0.200
     3.856   101.891     0.200
     3.911    97.790     0.200
     4.185   112.840     0.200
     4.507   112.130     0.200
     4.733   122.720     0.200
     4.986   136.050     0.200
     5.091   128.900     0.200
     5.126   136.530     0.200
     0.267    14.094     0.200
     1.060    32.324     0.200
     1.115    34.844     0.200
     1.120    35.324     0.200
     1.163    36.125     0.200
     1.166    35.424     0.200
     1.171    35.955     0.200
     1.330    38.895     0.200
     1.384    41.594     0.200
     1.786    52.674     0.200
     1.730    51.855     0.200
     2.640    74.855     0.200
     3.057    80.105     0.200
     3.436    93.965     0.200
     3.600    96.064     0.200
     3.865   105.094     0.200
     4.170   107.064     0.200
     4.773   116.115     0.200
     5.094   125.635     0.200
     5.188   132.875     0.200
     5.236   134.764     0.200
     5.547   143.445     0.200
     2.341    66.884     0.200
     2.797    79.274     0.200
     3.193    88.164     0.200
     3.459    96.524     0.200
     3.597   100.354     0.200
     4.069   106.823     0.200
     4.116   114.583     0.200
     4.116   112.654     0.200
     4.347   117.734     0.200
     4.374   118.464     0.200
     4.522   124.014     0.200
     4.611   126.544     0.200
     4.676   129.654     0.200
     4.684   129.073     0.200
     4.730   127.404     0.200
     4.753   132.494     0.200
     4.853   132.594     0.200
     4.870   133.683     0.200
     4.916   134.554     0.200
     5.140   137.573     0.200
     5.140   141.063     0.200
     5.168   139.563     0.200
     5.168   141.854     0.200
     5.169   137.933     0.200
     5.182   134.144     0.200
     5.234   141.364     0.200
     5.409   142.494     0.200
     5.441   143.914     0.200
     5.736   152.953     0.200
     5.966   159.764     0.200
     6.058   162.174     0.200
     6.197   164.744     0.200
     6.199   163.534     0.200
     6.244   165.294     0.200
     6.226   160.453     0.200
     6.259   168.764     0.200
     6.392   170.703     0.200
     6.547   172.344     0.200
     6.709   172.994     0.200
     7.219   190.904     0.200
     7.361   193.654     0.200
     0.684    22.578     0.200
     0.807    26.098     0.200
     1.319    37.258     0.200
     1.650    47.078     0.200
     1.726    49.746     0.200
     1.765    51.246     0.200
     1.778    52.188     0.200
     1.816    51.387     0.200
     1.985    56.809     0.200
     2.404    67.809     0.200
     2.390    67.348     0.200
     3.373    95.578     0.200
     3.505    87.148     0.200
     3.804    97.219     0.200
     3.806    99.059     0.200
     3.784   104.828     0.200
     3.819   106.609     0.200
     3.826   106.449     0.200
     3.871   106.957     0.200
     4.184   101.566     0.200
     0.305    15.084     0.200
     1.016    30.453     0.200
     1.090    33.514     0.200
     1.138    35.494     0.200
     1.197    36.273     0.200
     1.184    37.104     0.200
     1.353    39.244     0.200
     1.773    51.385     0.200
     3.013    81.863     0.200
     3.340    94.283     0.200
     3.555    98.953     0.200
     3.643    93.324     0.200
     3.819   102.375     0.200
     4.126   105.613     0.200
     4.221   110.773     0.200
     4.221   113.904     0.200
     4.252   114.684     0.200
     4.252   118.244     0.200
     4.256   112.555     0.200
     4.312   117.154     0.200
     4.376   109.693     0.200
     4.726   118.764     0.200
     5.144   127.465     0.200
     5.189   132.004     0.200
     5.501   137.994     0.200
     5.718   145.174     0.200
     6.163   151.594     0.200
     0.889    28.174     0.200
     1.094    33.814     0.200
     1.026    34.264     0.200
     2.160    58.084     0.200
     2.715    73.363     0.200
     3.282    85.213     0.200
     3.593    99.363     0.200
     3.603   101.023     0.200
     3.992   110.895     0.200
     4.308   114.424     0.200
     4.692   125.373     0.200
     1.205    39.539     0.200
     1.239    41.406     0.200
     1.254    41.953     0.200
     1.560    47.219     0.200
     2.476    67.461     0.200
     2.814    77.078     0.200
     3.088    87.461     0.200
     3.048    87.039     0.200
     3.108    82.820     0.200
     3.336    90.539     0.200
     3.317    93.617     0.200
     3.502    99.281     0.200
     3.648    97.508     0.200
     3.908   102.688     0.200
     4.107   111.703     0.200
     4.142   110.969     0.200
     4.924   132.078     0.200
     5.249   142.047     0.200
     5.422   144.844     0.200
     0.694    22.265     0.200
     0.858    27.564     0.200
     1.331    41.064     0.200
     1.173    34.505     0.200
     1.440    42.845     0.200
     1.531    44.835     0.200
     1.444    42.995     0.200
     1.450    43.785     0.200
     1.486    44.785     0.200
     1.500    44.785     0.200
     1.556    45.755     0.200
     1.834    51.875     0.200
     2.595    71.045     0.200
     2.885    79.425     0.200
     2.959    82.154     0.200
     3.128    83.055     0.200
     3.250    87.524     0.200
     3.315    89.515     0.200
     3.404    90.785     0.200
     3.699    94.595     0.200
     3.594    99.535     0.200
     3.810   102.975     0.200
     3.810   104.215     0.200
     3.842   105.385     0.200
     3.842   105.574     0.200
     3.848   103.245     0.200
     3.938   102.165     0.200
     3.959   104.145     0.200
     3.900   105.385     0.200
     0.789    26.203     0.200
     0.781    25.953     0.200
     1.268    36.273     0.200
     1.466    41.553     0.200
     2.527    68.322     0.200
     2.801    77.352     0.200
     2.873    80.713     0.200
     3.055    81.443     0.200
     3.318    92.693     0.200
     3.627    91.883     0.200
     3.856    97.783     0.200
     3.880   101.322     0.200
     4.205   105.562     0.200
     4.526   115.133     0.200
     4.642   119.193     0.200
     4.670   115.863     0.200
     4.986   124.133     0.200
     1.101    37.039     0.200
     1.354    39.578     0.200
     1.371    41.289     0.200
     1.521    43.977     0.200
     1.597    47.273     0.200
     1.606    48.531     0.200
     1.628    47.703     0.200
     1.678    48.789     0.200
     1.719    45.141     0.200
     1.784    50.273     0.200
     1.855    53.852     0.200
     1.793    54.578     0.200
     2.492    70.703     0.200
     2.568    72.312     0.200
     2.895    75.852     0.200
     2.828    78.703     0.200
     2.931    79.391     0.200
     3.182    89.141     0.200
     3.246    84.344     0.200
     3.246    88.422     0.200
     3.311    87.602     0.200
     3.497    86.148     0.200
     3.558    92.031     0.200
     3.635    90.852     0.200
     3.843    99.664     0.200
     4.165   106.562     0.200
     4.381   112.359     0.200
     4.335   113.172     0.200
     4.479   109.570     0.200
     4.735   119.867     0.200
     4.796   123.617     0.200
     5.483   137.867     0.200
     6.459   159.469     0.200
     1.108    35.434     0.200
     1.185    38.344     0.200
     1.184    38.105     0.200
     1.517    44.184     0.200
     1.889    53.766     0.200
     2.035    58.285     0.200
     2.876    79.566     0.200
     2.957    78.707     0.200
     3.305    89.574     0.200
     3.675    96.367     0.200
     3.759   101.844     0.200
     3.809   104.016     0.200
     4.198   109.805     0.200
     4.601   119.594     0.200
     4.637   125.477     0.200
     4.728   121.906     0.200
     4.692   129.996     0.200
     5.084   134.547     0.200
     5.404   138.344     0.200
     5.530   148.027     0.200
     5.831   153.754     0.200
     6.083   160.027     0.200
     1.074    34.771     0.200
     1.162    35.980     0.200
     2.029    56.641     0.200
     1.915    54.210     0.200
     2.974    79.690     0.200
     2.929    82.050     0.200
     3.297    88.460     0.200
     3.188    89.641     0.200
     3.686   101.900     0.200
     3.857   104.420     0.200
     3.837   106.500     0.200
     3.812   101.410     0.200
     4.007   110.650     0.200
     4.058   110.721     0.200
     4.114   113.410     0.200
     4.195   116.021     0.200
     4.202   111.000     0.200
     4.223   112.641     0.200
     4.217   114.641     0.200
     4.229   117.530     0.200
     4.317   119.200     0.200
     4.330   120.570     0.200
     4.422   113.670     0.200
     4.388   119.880     0.200
     4.468   122.880     0.200
     4.527   123.840     0.200
     4.664   125.210     0.200
     4.703   129.880     0.200
     4.731   128.601     0.200
     4.729   125.760     0.200
     4.547   124.771     0.200
     5.097   131.460     0.200
     5.090   137.490     0.200
     5.416   139.130     0.200
     5.535   143.670     0.200
     5.772   156.900     0.200
     6.082   159.700     0.200
     6.099   157.450     0.200
     6.463   169.860     0.200
     7.326   186.690     0.200
     7.569   200.391     0.200
     7.871   209.690     0.200
     8.276   207.134     0.200
     8.276   210.990     0.200
     9.991   259.320     0.200
    10.143   256.811     0.200
    11.013   284.360     0.200
     1.392    42.195     0.200
     2.220    63.875     0.200
     2.397    67.070     0.200
     2.575    73.391     0.200
     3.362    94.977     0.200
     3.634    97.211     0.200
     3.842   101.508     0.200
     3.759   100.828     0.200
     4.162   114.328     0.200
     4.203   113.531     0.200
     4.401   114.531     0.200
     4.442   122.188     0.200
     4.491   123.195     0.200
     4.620   125.555     0.200
     4.632   125.641     0.200
     4.635   127.781     0.200
     4.640   126.516     0.200
     4.650   126.617     0.200
     4.688   120.648     0.200
     4.741   128.000     0.200
     4.745   129.188     0.200
     4.772   130.922     0.200
     4.823   127.555     0.200
     4.967   126.961     0.200
     4.976   136.820     0.200
     5.086   138.375     0.200
     5.095   140.211     0.200
     5.114   139.922     0.200
     5.115   138.727     0.200
     5.115   139.500     0.200
     5.254   136.219     0.200
     5.231   136.531     0.200
     5.608   145.367     0.200
     5.929   154.367     0.200
     6.300   166.438     0.200
     6.368   164.250     0.200
     6.398   172.336     0.200
     6.600   166.797     0.200
     6.624   174.422     0.200
     6.863   179.531     0.200
     7.007   175.609     0.200
     7.069   182.125     0.200
     7.069   182.125     0.200
     7.836   201.039     0.200
     8.022   208.500     0.200
     8.522   223.789     0.200
     8.797   225.766     0.200
     8.797   230.906     0.200
     9.455   240.859     0.200
    10.678   267.891     0.200
    11.539   299.617     0.200
     0.462    17.383     0.200
     1.877    53.543     0.200
     1.927    54.418     0.200
     2.158    59.762     0.200
     2.552    70.582     0.200
     2.688    74.543     0.200
     2.709    73.520     0.200
     2.997    78.980     0.200
     3.186    86.660     0.200
     3.276    86.152     0.200
     3.567    96.043     0.200
     3.584    94.238     0.200
     3.949   106.879     0.200
     3.968   102.004     0.200
     4.284   109.668     0.200
     4.297   110.332     0.200
     4.385   111.473     0.200
     4.679   124.152     0.200
     4.950   130.684     0.200
     4.981   130.754     0.200
     5.073   133.652     0.200
     5.316   134.652     0.200
     5.390   138.473     0.200
     6.329   160.215     0.200
     1.147    38.148     0.200
     1.217    40.879     0.200
     1.250    40.998     0.200
     1.223    40.588     0.200
     1.266    41.809     0.200
     1.274    43.078     0.200
     1.762    50.299     0.200
     3.033    85.098     0.200
     3.387    91.588     0.200
     3.471    93.549     0.200
     3.430    92.287     0.200
     3.585    95.688     0.200
     3.529    94.848     0.200
     3.752    98.578     0.200
     3.697   105.158     0.200
     3.915   106.287     0.200
     4.342   120.969     0.200
     4.469   123.498     0.200
     4.796   127.758     0.200
     5.116   138.447     0.200
     2.268    62.389     0.200
     2.554    72.059     0.200
     2.928    82.369     0.200
     3.062    82.869     0.200
     3.519    89.789     0.200
     3.692    98.439     0.200
     3.794   104.668     0.200
     4.032   103.869     0.200
     4.043   106.020     0.200
     4.240   114.549     0.200
     4.465   121.398     0.200
     4.605   120.359     0.200
     4.758   121.758     0.200
     5.061   133.229     0.200
     5.384   139.418     0.200
     5.579   150.238     0.200
     5.612   149.139     0.200
     5.918   161.008     0.200
     6.019   155.959     0.200
     1.204    35.719     0.200
     1.792    51.242     0.200
     2.009    56.484     0.200
     2.020    57.133     0.200
     2.029    57.789     0.200
     2.371    66.594     0.200
     2.450    68.242     0.200
     2.621    74.086     0.200
     2.648    74.562     0.200
     2.874    80.766     0.200
     2.866    79.414     0.200
     3.038    83.148     0.200
     3.120    81.609     0.200
     3.063    85.688     0.200
     3.065    85.258     0.200
     3.082    86.242     0.200
     3.087    84.680     0.200
     3.142    84.523     0.200
     3.090    82.953     0.200
     3.092    86.164     0.200
     3.089    85.523     0.200
     3.161    88.047     0.200
     3.157    85.109     0.200
     3.192    84.234     0.200
     3.235    90.180     0.200
     3.236    89.617     0.200
     3.337    91.227     0.200
     3.387    91.266     0.200
     3.407    91.188     0.200
     3.406    89.805     0.200
     3.381    90.930     0.200
     3.601    97.016     0.200
     3.786   100.742     0.200
     3.772   101.484     0.200
     3.872   104.727     0.200
     3.912   107.586     0.200
     3.928   108.508     0.200
     4.103   110.945     0.200
     4.210   113.016     0.200
     4.326   116.008     0.200
     4.509   120.680     0.200
     4.529   123.688     0.200
     4.799   130.227     0.200
     4.776   131.188     0.200
     5.158   131.953     0.200
     5.216   138.297     0.200
     5.202   135.234     0.200
     6.014   157.477     0.200
     6.168   156.984     0.200
     6.657   172.523     0.200
     6.955   182.141     0.200
     8.669   223.523     0.200
     9.689   251.242     0.200
     9.820   252.695     0.200
    11.565   299.195     0.200
     0.883    25.875     0.200
     1.175    34.865     0.200
     1.108    31.505     0.200
     1.618    45.285     0.200
     1.595    46.065     0.200
     1.582    46.785     0.200
     1.585    46.646     0.200
     1.615    47.806     0.200
     1.707    49.306     0.200
     1.707    50.955     0.200
     1.969    56.485     0.200
     2.429    63.936     0.200
     2.696    69.846     0.200
     2.954    74.976     0.200
     2.836    75.346     0.200
     3.070    86.355     0.200
     3.218    82.735     0.200
     3.334    88.815     0.200
     3.526    93.535     0.200
     3.644    99.936     0.200
     3.650   103.605     0.200
     3.662    98.315     0.200
     3.751    97.825     0.200
     3.775    98.915     0.200
     4.100   106.275     0.200
     4.564   122.035     0.200
     4.881   121.455     0.200
     0.600    20.094     0.200
     0.880    29.703     0.200
     0.961    30.648     0.200
     0.917    31.250     0.200
     0.997    33.094     0.200
     1.882    56.555     0.200
     2.657    75.375     0.200
     3.136    86.148     0.200
     3.186    87.273     0.200
     3.332    84.320     0.200
     3.330    87.734     0.200
     3.349    88.109     0.200
     3.208    87.289     0.200
     3.518    97.180     0.200
     3.652    98.633     0.200
     3.733   100.211     0.200
     4.124   111.039     0.200
     4.157   107.680     0.200
     4.155   111.039     0.200
     4.225   107.562     0.200
     4.397   117.398     0.200
     4.443   119.211     0.200
     4.714   127.203     0.200
     1.139    35.203     0.200
     1.166    35.885     0.200
     1.653    46.715     0.200
     1.982    57.395     0.200
     2.232    61.273     0.200
     2.467    65.203     0.200
     2.702    75.555     0.200
     2.712    76.523     0.200
     2.920    77.504     0.200
     2.954    78.674     0.200
     3.202    86.555     0.200
     3.260    89.254     0.200
     3.294    85.055     0.200
     3.455    89.434     0.200
     3.456    91.154     0.200
     3.507    96.514     0.200
     3.578    98.064     0.200
     3.642    99.164     0.200
     3.651    95.043     0.200
     3.653   100.033     0.200
     3.663   102.693     0.200
     3.670    98.914     0.200
     3.685    94.844     0.200
     3.694    93.203     0.200
     4.026   103.885     0.200
     4.112   111.994     0.200
     4.115   114.225     0.200
     4.122   110.084     0.200
     4.258   113.434     0.200
     4.283   114.834     0.200
     4.269   117.684     0.200
     4.602   118.725     0.200
     4.923   126.854     0.200
     5.042   130.414     0.200
     5.073   131.055     0.200
     5.291   137.385     0.200
     5.389   142.773     0.200
     5.591   141.604     0.200
     6.061   154.555     0.200
     6.828   173.953     0.200
     7.796   196.715     0.200
     1.193    40.152     0.200
     1.197    40.553     0.200
     1.210    40.754     0.200
     1.221    40.773     0.200
     1.348    44.402     0.200
     1.495    46.312     0.200
     2.009    60.402     0.200
     2.510    69.543     0.200
     3.016    84.572     0.200
     3.048    84.023     0.200
     2.988    85.504     0.200
     3.151    89.084     0.200
     3.092    87.363     0.200
     4.039   112.062     0.200
     4.070   110.414     0.200
     4.150   117.123     0.200
     4.270   113.812     0.200
     4.590   126.773     0.200
     4.858   127.232     0.200
     5.174   140.273     0.200
     0.933    29.383     0.200
     0.993    31.943     0.200
     2.587    73.313     0.200
     3.321    91.933     0.200
     3.619   100.723     0.200
     3.621    97.913     0.200
     3.622   101.023     0.200
     3.632   100.553     0.200
     4.002   110.983     0.200
     4.341   116.193     0.200
     4.319   108.073     0.200
     4.424   120.463     0.200
     4.720   123.143     0.200
     5.014   133.013     0.200
     1.345    43.199     0.200
     2.525    68.789     0.200
     2.578    73.102     0.200
     2.742    70.988     0.200
     2.802    76.328     0.200
     2.890    77.270     0.200
     2.920    78.922     0.200
     2.955    81.609     0.200
     3.024    83.410     0.200
     3.007    81.852     0.200
     3.050    85.211     0.200
     3.117    87.820     0.200
     3.157    85.102     0.200
     3.378    92.012     0.200
     3.515    96.262     0.200
     3.536    93.160     0.200
     3.643   100.422     0.200
     4.057   105.879     0.200
     4.093   106.629     0.200
     4.169   112.352     0.200
     4.285   113.961     0.200
     4.605   121.941     0.200
     4.831   124.031     0.200
     4.875   126.559     0.200
     5.051   131.090     0.200
     5.186   136.090     0.200
     5.253   136.699     0.200
     5.842   148.559     0.200
     6.039   153.488     0.200
     6.447   169.262     0.200
     7.473   197.070     0.200
     0.282    12.953     0.200
     0.918    27.891     0.200
     0.996    30.820     0.200
     1.102    33.660     0.200
     1.099    34.691     0.200
     1.107    34.652     0.200
     1.382    40.852     0.200
     1.370    40.863     0.200
     1.841    50.594     0.200
     2.044    54.211     0.200
     2.109    58.711     0.200
     3.111    82.262     0.200
     3.410    92.184     0.200
     3.362    90.633     0.200
     3.470    91.652     0.200
     3.499    88.801     0.200
     3.521    99.793     0.200
     3.652    96.852     0.200
     3.657    94.203     0.200
     3.708    97.594     0.200
     3.780    98.133     0.200
     3.817   101.043     0.200
     3.892   100.191     0.200
     3.985   107.703     0.200
     4.222   107.953     0.200
     4.292   114.223     0.200
     4.279   107.961     0.200
     4.277   114.410     0.200
     4.327   110.301     0.200
     4.384   118.102     0.200
     4.466   116.410     0.200
     4.439   115.121     0.200
     4.489   119.293     0.200
     4.812   124.160     0.200
     5.133   133.332     0.200
     5.240   132.211     0.200
     5.280   138.262     0.200
     0.051    20.665     0.200
     0.209    22.165     0.200
     0.232    22.535     0.200
     0.521    24.405     0.200
     1.145    35.425     0.200
     1.231    36.735     0.200
     1.734    49.335     0.200
     2.465    64.875     0.200
     3.494    90.385     0.200
     4.137   103.205     0.200
     4.127   109.915     0.200
     4.266   107.335     0.200
     4.261   109.125     0.200
     4.540   117.825     0.200
     4.908   128.235     0.200
     4.908   134.686     0.200
     4.944   130.915     0.200
     4.955   130.605     0.200
     5.215   130.285     0.200
     5.332   132.555     0.200
     5.612   139.575     0.200
     5.935   147.215     0.200
     6.155   151.345     0.200
     6.217   155.055     0.200
     6.504   162.686     0.200
     6.548   162.965     0.200
     0.242    13.922     0.200
     0.866    26.555     0.200
     0.966    30.594     0.200
     1.070    33.062     0.200
     1.081    34.062     0.200
     1.088    33.965     0.200
     1.421    41.262     0.200
     1.894    50.762     0.200
     1.988    53.184     0.200
     2.204    61.484     0.200
     2.819    77.285     0.200
     2.865    79.645     0.200
     3.165    83.363     0.200
     3.472    93.785     0.200
     3.533    94.242     0.200
     3.708    96.965     0.200
     3.771    98.484     0.200
     3.955   104.484     0.200
     4.278   108.992     0.200
     4.291   114.453     0.200
     4.339   114.633     0.200
     4.390   117.773     0.200
     4.527   116.465     0.200
     4.548   124.043     0.200
     4.537   120.953     0.200
     4.874   125.742     0.200
     5.195   133.004     0.200
     5.296   130.684     0.200
     5.340   139.145     0.200
     5.563   146.473     0.200
     5.653   147.285     0.200
     5.864   154.402     0.200
     5.917   156.422     0.200
     1.047    33.949     0.200
     1.142    37.209     0.200
     1.198    39.869     0.200
     3.583    97.318     0.200
     3.666   102.209     0.200
     3.775   103.988     0.200
     4.106   114.270     0.200
     4.466   122.430     0.200
     4.546   120.209     0.200
     4.631   124.209     0.200
     4.992   135.969     0.200
     5.312   136.398     0.200
     5.439   146.250     0.200
     5.699   153.520     0.200
     5.741   148.279     0.200
     5.991   154.459     0.200
     6.382   167.949     0.200
     6.444   172.969     0.200
     7.221   186.629     0.200
     8.176   209.750     0.200
     1.063    34.316     0.200
     1.157    35.484     0.200
     1.220    39.324     0.200
     1.965    54.965     0.200
     3.235    85.953     0.200
     3.608    98.344     0.200
     3.695    99.184     0.200
     3.792    98.746     0.200
     4.138   113.965     0.200
     4.358   111.383     0.200
     4.498   120.086     0.200
     4.542   122.836     0.200
     4.571   123.133     0.200
     4.660   120.727     0.200
     4.654   125.566     0.200
     4.632   127.535     0.200
     4.690   124.656     0.200
     4.753   126.176     0.200
     4.782   130.605     0.200
     5.338   135.434     0.200
     5.462   142.703     0.200
     5.728   149.695     0.200
     5.762   152.105     0.200
     6.018   160.023     0.200
     1.007    32.736     0.200
     2.136    60.928     0.200
     2.472    68.627     0.200
     2.508    71.287     0.200
     2.679    73.158     0.200
     2.929    81.338     0.200
     3.095    85.057     0.200
     3.240    88.287     0.200
     3.217    88.828     0.200
     3.260    91.158     0.200
     3.328    93.547     0.200
     3.430    94.537     0.200
     3.570    97.957     0.200
     3.695    99.877     0.200
     3.703   100.697     0.200
     3.716   101.188     0.200
     3.719   100.727     0.200
     3.718   100.986     0.200
     3.719   100.887     0.200
     3.804   103.127     0.200
     3.749   101.396     0.200
     3.747   101.408     0.200
     3.768   105.178     0.200
     3.768   102.018     0.200
     3.805   103.328     0.200
     3.830   104.047     0.200
     3.840   105.297     0.200
     3.870   105.727     0.200
     3.896   105.928     0.200
     3.947   107.168     0.200
     4.121   110.486     0.200
     4.111   112.477     0.200
     4.128   110.727     0.200
     4.145   112.938     0.200
     4.146   112.938     0.200
     4.193   114.477     0.200
     4.232   115.078     0.200
     4.253   115.146     0.200
     4.253   115.146     0.200
     4.565   124.438     0.200
     4.673   126.297     0.200
     4.693   128.668     0.200
     4.827   126.807     0.200
     4.930   131.918     0.200
     5.220   136.646     0.200
     5.246   139.588     0.200
     5.415   141.447     0.200
     5.439   150.088     0.200
     5.521   147.168     0.200
     5.845   152.977     0.200
     5.893   150.758     0.200
     5.935   155.816     0.200
     5.935   155.816     0.200
     5.944   157.627     0.200
     5.964   155.748     0.200
     6.091   159.998     0.200
     6.067   157.896     0.200
     6.327   168.828     0.200
     6.738   176.197     0.200
     6.861   176.547     0.200
     7.504   198.787     0.200
     7.677   203.391     0.200
     7.677   195.688     0.200
     7.677   197.287     0.200
     9.202   238.188     0.200
     9.853   253.658     0.200
    10.607   269.947     0.200
    10.638   270.627     0.200
    10.730   274.697     0.200
    11.227   286.967     0.200
    11.289   286.297     0.200
    12.277   316.646     0.200
    13.102   332.717     0.200
     1.196    40.961     0.200
     1.339    44.971     0.200
     1.428    46.820     0.200
     1.963    59.941     0.200
     2.728    78.240     0.200
     2.869    82.611     0.200
     3.143    88.762     0.200
     3.322    90.340     0.200
     3.366    96.391     0.200
     3.481    99.262     0.200
     4.021   110.801     0.200
     4.040   114.791     0.200
     4.127   114.121     0.200
     1.107    36.648     0.200
     1.185    38.406     0.200
     1.512    45.105     0.200
     2.964    84.016     0.200
     3.310    92.316     0.200
     3.682   101.148     0.200
     3.709   103.719     0.200
     3.709   101.906     0.200
     3.765   104.469     0.200
     3.816   102.207     0.200
     3.868   106.117     0.200
     3.982   111.539     0.200
     4.148   112.438     0.200
     4.176   109.797     0.200
     4.205   113.578     0.200
     4.204   109.738     0.200
     4.219   113.848     0.200
     4.307   115.148     0.200
     4.304   117.227     0.200
     4.364   115.879     0.200
     4.434   121.039     0.200
     2.651    74.509     0.200
     3.089    82.199     0.200
     3.086    85.188     0.200
     3.862   106.159     0.200
     4.057   112.149     0.200
     4.215   114.389     0.200
     4.464   122.289     0.200
     4.483   121.789     0.200
     4.489   121.029     0.200
     4.493   122.168     0.200
     4.496   122.929     0.200
     4.533   121.609     0.200
     4.533   123.559     0.200
     4.613   126.089     0.200
     4.671   125.458     0.200
     4.816   131.039     0.200
     4.907   125.239     0.200
     5.237   140.519     0.200
     5.226   136.019     0.200
     5.337   140.349     0.200
     5.630   153.499     0.200
     5.630   148.389     0.200
     6.201   165.438     0.200
     6.256   156.938     0.200
     0.799    26.707     0.200
     1.010    30.004     0.200
     1.289    35.566     0.200
     1.513    44.375     0.200
     1.475    42.055     0.200
     1.641    46.965     0.200
     1.913    53.496     0.200
     2.367    65.047     0.200
     2.503    63.445     0.200
     2.665    71.984     0.200
     2.695    74.367     0.200
     3.000    77.574     0.200
     2.967    80.086     0.200
     3.057    81.227     0.200
     3.107    83.445     0.200
     3.573    90.785     0.200
     3.507    92.656     0.200
     3.533    93.277     0.200
     3.535    92.656     0.200
     3.537    93.277     0.200
     3.541    95.547     0.200
     3.729    97.574     0.200
     3.776    97.477     0.200
     4.051   102.316     0.200
     4.374   110.855     0.200
     4.576   112.734     0.200
     4.549   115.805     0.200
     4.882   125.688     0.200
     5.030   129.746     0.200
     1.584    42.531     0.200
     1.596    45.344     0.200
     1.694    48.773     0.200
     1.702    47.672     0.200
     2.213    61.961     0.200
     2.229    61.031     0.200
     2.366    65.914     0.200
     2.610    72.773     0.200
     3.083    82.102     0.200
     3.177    87.039     0.200
     3.174    85.289     0.200
     3.241    89.648     0.200
     3.321    90.602     0.200
     3.440    95.234     0.200
     3.695   100.422     0.200
     3.698    98.852     0.200
     3.703   102.664     0.200
     3.726   103.328     0.200
     3.737   102.109     0.200
     3.804   104.398     0.200
     3.819   102.023     0.200
     3.982   107.828     0.200
     3.988   105.562     0.200
     4.075   109.648     0.200
     4.074   109.367     0.200
     4.088   108.992     0.200
     4.098   107.852     0.200
     4.103   109.484     0.200
     4.109   109.648     0.200
     4.117   113.648     0.200
     4.248   112.867     0.200
     4.275   113.570     0.200
     4.461   121.891     0.200
     4.755   126.922     0.200
     4.759   126.664     0.200
     4.777   126.438     0.200
     4.872   128.922     0.200
     5.159   131.930     0.200
     5.203   136.758     0.200
     5.397   140.734     0.200
     5.475   140.141     0.200
     5.778   151.617     0.200
     5.862   152.648     0.200
     5.877   154.930     0.200
     6.094   165.320     0.200
     7.622   197.102     0.200
     1.719    49.805     0.200
     3.838   104.773     0.200
     4.581   125.582     0.200
     5.010   136.523     0.200
     8.186   210.633     0.200
     0.250    13.977     0.200
     1.118    34.266     0.200
     1.121    35.605     0.200
     1.383    39.773     0.200
     1.400    41.316     0.200
     1.676    46.617     0.200
     1.839    49.105     0.200
     2.043    55.785     0.200
     2.688    73.395     0.200
     2.895    75.227     0.200
     2.854    80.516     0.200
     3.110    82.125     0.200
     3.398    96.273     0.200
     3.483    92.906     0.200
     3.653    95.074     0.200
     3.839   107.395     0.200
     3.874   106.855     0.200
     3.882   102.836     0.200
     4.004   113.195     0.200
     4.223   110.773     0.200
     4.305   115.164     0.200
     4.308   116.867     0.200
     4.345   120.746     0.200
     4.436   120.855     0.200
     4.474   115.375     0.200
     4.822   122.465     0.200
     5.143   129.875     0.200
     5.241   132.957     0.200
     5.287   138.824     0.200
     5.514   144.805     0.200
     5.599   146.887     0.200
     5.813   154.547     0.200
     6.261   155.434     0.200
     6.290   157.844     0.200
     6.851   185.047     0.200
     7.049   184.355     0.200
     7.269   183.715     0.200
     7.259   189.785     0.200
     8.014   203.188     0.200
     8.014   208.516     0.200
     8.694   223.590     0.200
     1.440    39.664     0.200
     1.530    43.262     0.200
     1.988    53.875     0.200
     2.237    62.781     0.200
     2.818    78.703     0.200
     2.863    78.914     0.200
     3.043    82.145     0.200
     3.259    85.715     0.200
     3.480    90.383     0.200
     3.503    91.543     0.200
     3.496    95.781     0.200
     3.555    94.152     0.200
     3.627    97.465     0.200
     3.778    99.281     0.200
     3.800   102.094     0.200
     3.831   101.242     0.200
     3.933   101.191     0.200
     3.975   106.453     0.200
     3.978   105.363     0.200
     4.083   106.094     0.200
     4.090   109.934     0.200
     4.110   106.812     0.200
     4.162   108.965     0.200
     4.184   107.484     0.200
     4.240   110.914     0.200
     4.240   113.883     0.200
     4.371   115.094     0.200
     4.380   116.965     0.200
     4.379   116.965     0.200
     4.421   116.242     0.200
     4.443   116.234     0.200
     4.449   114.305     0.200
     4.450   117.332     0.200
     4.451   117.184     0.200
     4.451   115.543     0.200
     4.454   117.992     0.200
     4.455   117.992     0.200
     4.612   118.613     0.200
     4.638   120.684     0.200
     4.954   125.934     0.200
     5.276   135.844     0.200
     5.388   136.543     0.200
     5.426   140.383     0.200
     5.623   149.465     0.200
     5.637   144.625     0.200
     5.742   146.203     0.200
     5.941   152.512     0.200
     5.916   154.965     0.200
     6.200   162.504     0.200
     6.408   164.164     0.200
     6.429   168.645     0.200
     6.429   168.645     0.200
     6.732   179.023     0.200
     7.241   191.703     0.200
     7.415   187.781     0.200
     0.488    18.242     0.200
     0.970    29.859     0.200
     1.201    37.141     0.200
     1.714    50.441     0.200
     1.811    49.520     0.200
     2.006    53.719     0.200
     2.226    59.441     0.200
     2.522    67.469     0.200
     2.618    70.199     0.200
     2.656    74.312     0.200
     2.570    70.621     0.200
     2.661    72.539     0.200
     2.715    71.449     0.200
     2.755    71.980     0.200
     2.746    75.141     0.200
     2.918    79.012     0.200
     2.964    79.352     0.200
     2.930    78.430     0.200
     3.095    86.160     0.200
     3.112    83.621     0.200
     3.113    85.121     0.200
     3.119    84.629     0.200
     3.139    85.711     0.200
     3.221    89.852     0.200
     3.235    88.422     0.200
     3.268    89.332     0.200
     3.289    90.590     0.200
     3.327    82.910     0.200
     3.264    91.492     0.200
     3.307    89.461     0.200
     3.399    90.941     0.200
     3.513    94.141     0.200
     3.521    97.730     0.200
     3.526    95.539     0.200
     3.539    89.820     0.200
     3.531    98.512     0.200
     3.536    93.992     0.200
     3.538    93.992     0.200
     3.571    91.070     0.200
     3.533    98.191     0.200
     3.631    97.922     0.200
     3.673    99.219     0.200
     3.673    99.219     0.200
     3.700    94.762     0.200
     3.725    99.879     0.200
     3.932    99.469     0.200
     3.957   104.211     0.200
     4.342   112.219     0.200
     4.382   110.359     0.200
     4.650   118.820     0.200
     4.934   126.750     0.200
     5.361   133.000     0.200
     5.386   137.301     0.200
     5.386   137.301     0.200
     5.615   142.641     0.200
     6.366   158.672     0.200
     6.294   159.941     0.200
     7.115   177.586     0.200
     7.115   178.871     0.200
     7.127   182.219     0.200
     7.383   191.191     0.200
     7.570   196.402     0.200
     9.000   223.449     0.200
    10.086   250.289     0.200
    10.113   250.859     0.200
    10.208   255.402     0.200
    13.351   325.984     0.200
    13.351   334.270     0.200
     0.870    30.766     0.200
     1.145    35.836     0.200
     1.136    36.955     0.200
     1.154    37.295     0.200
     1.256    38.355     0.200
     1.635    45.746     0.200
     1.635    49.666     0.200
     1.989    54.686     0.200
     1.989    54.256     0.200
     1.907    54.426     0.200
     2.332    64.795     0.200
     2.283    64.125     0.200
     2.589    72.096     0.200
     2.589    71.035     0.200
     2.657    70.406     0.200
     2.672    72.576     0.200
     2.842    79.066     0.200
     2.882    76.336     0.200
     2.869    79.807     0.200
     2.899    81.176     0.200
     3.042    81.576     0.200
     3.037    82.246     0.200
     3.053    83.016     0.200
     3.176    87.125     0.200
     3.229    89.916     0.200
     3.324    89.426     0.200
     3.385    89.516     0.200
     3.356    90.625     0.200
     3.372    91.336     0.200
     3.372    91.105     0.200
     3.379    92.086     0.200
     3.419    95.705     0.200
     3.438    90.996     0.200
     3.478    93.887     0.200
     3.482    92.826     0.200
     3.512    99.246     0.200
     3.561    95.215     0.200
     3.573    97.307     0.200
     3.770   104.477     0.200
     3.831   103.316     0.200
     3.834   101.775     0.200
     3.860   103.945     0.200
     3.861   102.887     0.200
     3.863   103.236     0.200
     3.862   102.926     0.200
     3.863   104.826     0.200
     3.957   100.326     0.200
     3.973   109.146     0.200
     3.973   104.557     0.200
     4.049   104.375     0.200
     4.052   107.625     0.200
     4.108   106.086     0.200
     4.108   103.986     0.200
     4.742   123.125     0.200
     4.928   125.516     0.200
     4.881   133.576     0.200
     4.961   128.996     0.200
     5.071   131.146     0.200
     5.265   136.846     0.200
     5.388   138.416     0.200
     5.392   146.926     0.200
     5.603   145.086     0.200
     5.604   151.936     0.200
     5.924   152.486     0.200
     5.924   152.486     0.200
     5.975   154.375     0.200
     6.636   170.936     0.200
     6.717   176.766     0.200
     6.789   178.996     0.200
     6.968   176.045     0.200
     7.293   189.807     0.200
     7.623   191.629     0.200
     7.623   195.125     0.200
     8.568   224.605     0.200
     9.126   234.057     0.200
     9.335   234.516     0.200
     9.556   239.926     0.200
     9.570   246.965     0.200
    10.374   261.625     0.200
    10.651   266.355     0.200
    10.675   266.826     0.200
    10.773   268.365     0.200
    11.243   281.836     0.200
    12.356   306.266     0.200
    13.674   339.824     0.200
     1.413    46.367     0.200
     1.559    47.867     0.200
     1.546    47.102     0.200
     2.049    60.625     0.200
     2.999    86.555     0.200
     3.193    89.922     0.200
     3.515   100.711     0.200
     4.048   108.945     0.200
     4.092   115.250     0.200
     2.061    57.379     0.200
     2.177    60.750     0.200
     2.415    64.309     0.200
     2.691    73.859     0.200
     2.751    77.117     0.200
     2.819    78.918     0.200
     3.058    83.059     0.200
     3.410    93.078     0.200
     3.429    93.508     0.200
     3.431    92.270     0.200
     3.442    92.469     0.200
     3.447    92.469     0.200
     3.463    93.828     0.200
     3.505    97.398     0.200
     3.991   109.930     0.200
     4.057   109.578     0.200
     4.523   125.508     0.200
     4.806   130.180     0.200
     5.189   137.910     0.200
     1.224    35.102     0.200
     2.095    58.102     0.200
     2.216    62.234     0.200
     2.494    66.992     0.200
     2.677    71.766     0.200
     3.026    84.289     0.200
     3.051    83.070     0.200
     3.510    96.375     0.200
     3.466    96.469     0.200
     3.617    92.672     0.200
     3.934   103.430     0.200
     3.962   106.383     0.200
     3.963   106.383     0.200
     4.098   114.344     0.200
     4.099   114.344     0.200
     4.316   112.719     0.200
     4.633   125.211     0.200
     4.736   121.812     0.200
     4.700   127.062     0.200
     5.028   131.516     0.200
     5.054   138.055     0.200
     5.658   151.078     0.200
     5.741   157.016     0.200
     6.210   167.805     0.200
     6.544   163.445     0.200
     7.409   197.328     0.200
     7.843   211.422     0.200
     9.197   241.398     0.200
     9.338   236.102     0.200
     9.271   241.922     0.200
     9.845   259.781     0.200
    10.215   261.281     0.200
     1.045    32.742     0.200
     2.496    66.195     0.200
     3.561    93.172     0.200
     3.505    94.086     0.200
     4.350   112.555     0.200
     4.529   114.938     0.200
     4.563   121.578     0.200
     4.864   129.062     0.200
     5.003   131.242     0.200
     0.482    18.297     0.200
     0.973    29.562     0.200
     1.749    48.609     0.200
     1.807    50.562     0.200
     1.991    53.617     0.200
     1.919    53.094     0.200
     2.213    57.742     0.200
     2.470    67.148     0.200
     2.552    69.570     0.200
     2.732    71.859     0.200
     2.637    72.188     0.200
     2.955    79.688     0.200
     3.013    76.664     0.200
     3.141    86.164     0.200
     3.304    83.273     0.200
     3.422    93.859     0.200
     3.439    91.422     0.200
     3.461    93.352     0.200
     3.545    92.789     0.200
     4.197   105.602     0.200
     4.316   107.992     0.200
     4.338   111.648     0.200
     4.654   119.273     0.200
     4.874   121.797     0.200
     5.334   133.898     0.200
     5.341   135.242     0.200
     6.104   152.172     0.200
     6.336   156.109     0.200
     7.065   176.586     0.200
     7.065   175.047     0.200
     1.284    43.096     0.200
     1.417    46.797     0.200
     1.567    48.086     0.200
     2.018    61.025     0.200
     2.179    63.945     0.200
     2.922    83.967     0.200
     3.081    84.336     0.200
     3.089    86.156     0.200
     3.149    88.736     0.200
     3.466    99.525     0.200
     3.492    96.436     0.200
     4.000   108.467     0.200
     4.047   111.146     0.200
     4.115   113.316     0.200
     4.223   112.906     0.200
     4.542   119.906     0.200
     4.589   128.566     0.200
     4.764   128.816     0.200
     4.817   131.086     0.200
     5.001   134.646     0.200
     5.120   138.316     0.200
     5.196   141.445     0.200
     5.781   153.746     0.200
     5.987   158.236     0.200
     5.980   161.846     0.200
     6.240   169.266     0.200
     1.289    43.566     0.200
     1.584    49.316     0.200
     2.526    73.945     0.200
     2.812    79.277     0.200
     2.918    82.938     0.200
     3.039    86.246     0.200
     3.078    84.285     0.200
     3.162    89.516     0.200
     3.332    95.445     0.200
     3.454    98.508     0.200
     3.459    96.535     0.200
     3.973   109.285     0.200
     4.010   111.266     0.200
     4.085   112.746     0.200
     4.202   117.367     0.200
     4.522   121.418     0.200
     4.629   126.906     0.200
     4.751   128.645     0.200
     4.791   132.406     0.200
     4.967   134.855     0.200
     5.105   137.477     0.200
     5.168   141.047     0.200
     5.758   155.816     0.200
     5.955   161.766     0.200
     6.028   162.777     0.200
     6.415   174.676     0.200
     0.662    22.533     0.200
     1.153    33.934     0.200
     1.891    53.582     0.200
     2.393    63.363     0.200
     2.626    73.783     0.200
     2.908    76.303     0.200
     3.129    86.412     0.200
     3.481    89.412     0.200
     3.684    98.332     0.200
     3.715    99.922     0.200
     4.026   104.434     0.200
     1.246    38.463     0.200
     2.311    63.812     0.200
     3.160    88.273     0.200
     3.453    95.273     0.200
     3.479    98.143     0.200
     3.531    97.332     0.200
     3.927   108.242     0.200
     3.934   108.393     0.200
     3.938   108.502     0.200
     3.940   108.053     0.200
     3.962   108.672     0.200
     3.965   109.434     0.200
     3.973   108.842     0.200
     4.024   108.842     0.200
     4.032   112.184     0.200
     4.086   111.973     0.200
     4.244   115.543     0.200
     4.352   117.422     0.200
     4.357   120.713     0.200
     4.365   120.742     0.200
     4.367   119.383     0.200
     4.376   117.473     0.200
     4.447   119.934     0.200
     4.453   122.393     0.200
     4.540   117.422     0.200
     4.704   125.672     0.200
     4.749   126.803     0.200
     4.807   129.633     0.200
     0.901    29.957     0.200
     2.435    65.805     0.200
     2.687    72.516     0.200
     2.754    74.918     0.200
     2.956    78.297     0.200
     3.046    83.625     0.200
     3.198    86.477     0.200
     3.529    91.578     0.200
     3.604    98.758     0.200
     3.625    98.926     0.200
     3.630   100.137     0.200
     3.633    98.227     0.200
     3.636    99.445     0.200
     3.641    97.426     0.200
     3.743    99.516     0.200
     3.771    99.637     0.200
     4.089   107.477     0.200
     4.410   112.535     0.200
     4.541   116.578     0.200
     4.558   118.668     0.200
     4.877   126.676     0.200
     5.082   126.305     0.200
     5.558   142.078     0.200
     0.849    26.639     0.200
     1.211    34.850     0.200
     1.597    47.670     0.200
     1.671    48.969     0.200
     1.722    52.059     0.200
     1.722    49.879     0.200
     2.245    61.840     0.200
     2.335    61.699     0.200
     2.466    65.350     0.200
     2.992    79.809     0.200
     3.025    84.520     0.200
     3.238    90.500     0.200
     3.251    83.809     0.200
     3.245    89.490     0.200
     3.248    88.500     0.200
     3.268    90.709     0.200
     3.269    91.029     0.200
     3.283    90.500     0.200
     3.366    93.820     0.200
     3.564    92.170     0.200
     3.657    99.430     0.200
     3.657   101.430     0.200
     3.683    98.109     0.200
     3.788    96.910     0.200
     3.813    98.680     0.200
     3.758    99.830     0.200
     3.757    99.830     0.200
     3.866   102.129     0.200
     4.137   105.689     0.200
     4.198   116.490     0.200
     4.457   112.619     0.200
     4.577   115.809     0.200
     4.602   117.799     0.200
     4.837   126.689     0.200
     4.919   125.109     0.200
     4.940   132.990     0.200
     5.131   131.689     0.200
     5.596   137.729     0.200
     5.605   142.359     0.200
     5.605   142.359     0.200
     5.594   153.039     0.200
     6.364   158.070     0.200
     6.599   163.389     0.200
     7.066   184.570     0.200
     7.178   187.090     0.200
     7.327   185.584     0.200
     7.327   181.369     0.200
     7.983   199.350     0.200
     9.042   227.559     0.200
     9.224   231.020     0.200
     9.505   243.779     0.200
    10.071   264.209     0.200
    13.515   334.033     0.200
     1.177    37.995     0.200
     2.100    60.314     0.200
     2.386    67.895     0.200
     2.485    70.185     0.200
     2.624    71.995     0.200
     2.702    74.504     0.200
     2.803    80.825     0.200
     2.961    84.785     0.200
     3.372    94.705     0.200
     3.372    95.145     0.200
     3.386    94.095     0.200
     3.396    94.924     0.200
     3.401    92.415     0.200
     3.381    96.084     0.200
     3.406    95.575     0.200
     3.573    97.205     0.200
     0.458    17.664     0.200
     1.133    34.246     0.200
     1.285    38.727     0.200
     1.302    37.867     0.200
     1.370    41.605     0.200
     1.394    41.605     0.200
     1.527    42.234     0.200
     2.354    62.227     0.200
     2.582    68.266     0.200
     2.798    79.086     0.200
     3.118    84.414     0.200
     3.106    87.125     0.200
     3.160    89.527     0.200
     3.196    88.336     0.200
     3.340    89.086     0.200
     3.480    96.836     0.200
     3.620    98.824     0.200
     3.620   102.145     0.200
     3.624   100.785     0.200
     3.627   101.656     0.200
     3.643   100.156     0.200
     3.646   102.816     0.200
     3.652    98.824     0.200
     3.626   101.156     0.200
     3.664    99.484     0.200
     3.669    97.465     0.200
     3.708    99.484     0.200
     3.742   104.805     0.200
     3.750   105.465     0.200
     3.810    98.164     0.200
     3.945   109.105     0.200
     4.045   111.445     0.200
     4.045   114.105     0.200
     4.067   109.434     0.200
     4.071   112.777     0.200
     4.074   109.766     0.200
     4.077   115.434     0.200
     4.169   107.727     0.200
     4.105   109.617     0.200
     4.185   106.645     0.200
     4.403   116.457     0.200
     4.438   117.277     0.200
     4.524   114.977     0.200
     4.845   124.957     0.200
     4.929   124.387     0.200
     4.980   126.375     0.200
     5.229   133.227     0.200
     5.289   135.004     0.200
     5.259   144.277     0.200
     5.521   140.246     0.200
     5.829   152.105     0.200
     5.984   156.215     0.200
     6.753   170.555     0.200
     7.057   189.266     0.200
     7.241   190.797     0.200
     7.608   201.625     0.200
     7.712   193.676     0.200
     9.426   237.316     0.200
     9.598   240.746     0.200
    10.453   265.215     0.200
     0.953    29.358     0.200
     0.805    28.299     0.200
     1.288    38.038     0.200
     1.414    39.188     0.200
     1.408    39.929     0.200
     1.406    43.129     0.200
     1.519    44.738     0.200
     1.486    42.168     0.200
     2.254    55.158     0.200
     2.598    67.799     0.200
     2.628    65.799     0.200
     2.841    80.198     0.200
     2.795    77.648     0.200
     3.067    84.629     0.200
     3.124    82.578     0.200
     3.265    92.148     0.200
     3.265    88.168     0.200
     4.480   113.099     0.200
     4.663   117.009     0.200
     4.698   118.049     0.200
     4.817   123.679     0.200
     4.999   127.248     0.200
     5.659   142.019     0.200
     7.360   182.667     0.200
     1.212    34.517     0.200
     1.510    43.167     0.200
     1.653    47.406     0.200
     1.765    50.007     0.200
     2.384    64.736     0.200
     2.406    61.656     0.200
     2.697    73.457     0.200
     2.769    72.076     0.200
     2.918    78.717     0.200
     3.124    84.887     0.200
     3.261    90.427     0.200
     3.489    87.656     0.200
     3.656   100.276     0.200
     3.680   100.946     0.200
     3.684   102.307     0.200
     3.689    98.957     0.200
     3.741    96.257     0.200
     3.756    97.656     0.200
     3.861   105.627     0.200
     4.101   103.207     0.200
     4.421   110.007     0.200
     4.506   113.297     0.200
     4.552   118.316     0.200
     4.861   125.097     0.200
     5.103   136.746     0.200
     5.556   141.406     0.200
     1.045    32.647     0.200
     1.766    50.617     0.200
     2.732    71.897     0.200
     3.053    79.107     0.200
     3.538    96.517     0.200
     3.611    95.407     0.200
     3.965   106.067     0.200
     3.977   110.717     0.200
     4.106   114.007     0.200
     4.177   108.177     0.200
     4.398   118.687     0.200
     4.419   112.707     0.200
     4.424   117.357     0.200
     4.427   118.687     0.200
     4.430   116.697     0.200
     4.482   116.677     0.200
     4.484   119.877     0.200
     4.852   125.397     0.200
     5.171   131.977     0.200
     5.288   138.577     0.200
     5.570   150.317     0.200
     5.585   143.337     0.200
     5.603   150.257     0.200
     1.057    31.531     0.200
     1.059    33.371     0.200
     1.596    45.512     0.200
     1.841    50.992     0.200
     2.291    58.051     0.200
     2.529    66.070     0.200
     2.527    67.402     0.200
     2.596    70.551     0.200
     2.588    71.883     0.200
     2.665    72.191     0.200
     2.805    74.980     0.200
     2.902    82.012     0.200
     3.038    84.863     0.200
     3.045    80.320     0.200
     3.184    87.570     0.200
     3.378    88.262     0.200
     3.452    94.320     0.200
     3.472    91.102     0.200
     3.481    90.633     0.200
     3.485    96.441     0.200
     3.660    99.801     0.200
     3.929    95.570     0.200
     4.250   107.312     0.200
     4.388   111.891     0.200
     4.399   110.523     0.200
     4.389   118.570     0.200
     4.719   122.992     0.200
     4.923   128.301     0.200
     1.069    35.789     0.200
     1.968    56.695     0.200
     2.898    81.656     0.200
     3.237    88.055     0.200
     3.701   101.289     0.200
     3.795   102.875     0.200
     3.765   104.617     0.200
     4.145   112.719     0.200
     4.361   116.656     0.200
     4.506   122.836     0.200
     4.585   123.906     0.200
     4.572   123.828     0.200
     4.659   124.609     0.200
     5.023   132.008     0.200
     5.343   138.391     0.200
     5.466   144.172     0.200
     5.766   152.570     0.200
     6.024   157.828     0.200
     2.077    57.402     0.200
     2.762    78.523     0.200
     2.895    80.004     0.200
     3.051    86.074     0.200
     2.998    83.023     0.200
     3.104    87.633     0.200
     3.551    99.633     0.200
     3.660    97.953     0.200
     3.751   101.984     0.200
     4.455   123.953     0.200
     4.521   124.152     0.200
     4.717   130.582     0.200
     4.886   130.984     0.200
     5.206   142.805     0.200
     5.248   141.883     0.200
     5.329   146.633     0.200
     5.593   152.113     0.200
     5.598   151.984     0.200
     5.629   148.352     0.200
     5.705   146.664     0.200
     6.100   166.043     0.200
     6.203   165.574     0.200
     6.267   163.582     0.200
     6.334   171.113     0.200
     6.333   171.113     0.200
     6.343   163.312     0.200
     7.006   183.395     0.200
     7.281   191.742     0.200
     7.461   199.844     0.200
     7.436   191.223     0.200
     7.787   206.633     0.200
     8.067   207.531     0.200
     8.067   211.562     0.200
     8.146   212.555     0.200
     9.782   258.418     0.200
    11.462   298.086     0.200
    12.219   308.336     0.200
    12.792   330.125     0.200
    13.008   336.531     0.200
    21.706   536.965     0.200
    22.019   542.355     0.200
    22.085   545.316     0.200
     2.675    77.383     0.200
     2.756    79.133     0.200
     3.685   103.586     0.200
     3.771   104.617     0.200
     4.012   113.242     0.200
     4.039   111.633     0.200
     4.128   109.328     0.200
     4.366   115.586     0.200
     4.468   124.078     0.200
     4.509   126.758     0.200
     4.514   120.766     0.200
     4.552   126.203     0.200
     4.554   124.258     0.200
     4.619   126.719     0.200
     4.626   126.867     0.200
     4.772   131.242     0.200
     4.809   132.258     0.200
     4.847   132.016     0.200
     4.907   136.523     0.200
     4.907   136.523     0.200
     4.954   136.195     0.200
     4.981   133.969     0.200
     4.982   134.289     0.200
     4.984   134.852     0.200
     4.984   135.992     0.200
     4.987   136.227     0.200
     4.993   138.844     0.200
     4.988   136.227     0.200
     5.103   134.453     0.200
     5.170   137.812     0.200
     5.461   145.008     0.200
     5.782   151.195     0.200
     5.831   152.188     0.200
     5.912   156.977     0.200
     6.159   163.367     0.200
     6.214   164.797     0.200
     6.353   174.773     0.200
     6.456   170.094     0.200
     6.850   178.633     0.200
     6.917   177.664     0.200
     6.917   177.664     0.200
     8.648   217.367     0.200
     1.123    34.627     0.200
     1.826    51.678     0.200
     2.718    73.718     0.200
     3.008    81.657     0.200
     3.136    85.487     0.200
     3.991   108.258     0.200
     3.989   106.407     0.200
     4.134   107.317     0.200
     4.397   118.327     0.200
     4.415   117.377     0.200
     4.422   117.877     0.200
     4.426   117.218     0.200
     4.429   119.107     0.200
     4.451   116.247     0.200
     4.455   117.527     0.200
     4.603   121.827     0.200
     4.793   125.968     0.200
     1.165    36.535     0.200
     1.689    48.535     0.200
     2.251    63.365     0.200
     2.672    76.385     0.200
     2.955    79.175     0.200
     3.185    87.425     0.200
     3.518    92.604     0.200
     3.480    95.354     0.200
     3.891   107.415     0.200
     3.947   107.354     0.200
     4.081   108.695     0.200
     4.400   117.545     0.200
     4.373   118.335     0.200
     4.405   117.445     0.200
     4.380   118.465     0.200
     4.384   118.465     0.200
     4.388   118.465     0.200
     4.394   118.735     0.200
     4.453   121.275     0.200
     4.561   122.895     0.200
     4.652   126.645     0.200
     4.783   128.725     0.200
     0.921    29.763     0.200
     1.081    33.803     0.200
     1.662    48.042     0.200
     2.033    58.002     0.200
     2.778    77.982     0.200
     2.942    81.532     0.200
     3.140    84.272     0.200
     3.579    97.172     0.200
     3.693    98.062     0.200
     3.702   103.143     0.200
     4.020   110.912     0.200
     4.261   114.362     0.200
     4.424   120.303     0.200
     4.447   117.683     0.200
     4.451   122.393     0.200
     4.453   119.252     0.200
     4.455   121.742     0.200
     4.635   124.752     0.200
     1.105    33.264     0.200
     1.834    53.283     0.200
     2.985    82.314     0.200
     3.476    97.404     0.200
     3.961   108.033     0.200
     3.961   110.693     0.200
     4.793   122.814     0.200
     5.515   149.613     0.200
     5.799   156.545     0.200
     1.386    39.295     0.200
     2.825    79.434     0.200
     3.130    88.373     0.200
     3.257    89.895     0.200
     3.464    95.764     0.200
     3.800   105.475     0.200
     3.864   106.914     0.200
     3.870   106.984     0.200
     3.932   107.295     0.200
     3.911   105.684     0.200
     4.307   118.135     0.200
     4.330   117.834     0.200
     4.338   117.113     0.200
     4.339   117.975     0.200
     4.342   119.943     0.200
     4.341   116.295     0.200
     4.350   118.273     0.200
     4.358   119.055     0.200
     4.366   118.873     0.200
     4.370   118.975     0.200
     4.378   118.574     0.200
     4.384   118.885     0.200
     4.382   119.914     0.200
     4.419   119.914     0.200
     4.452   120.805     0.200
     4.464   122.145     0.200
     4.526   124.514     0.200
     4.563   125.854     0.200
     4.603   126.453     0.200
     4.589   123.004     0.200
     4.669   126.594     0.200
     4.772   129.975     0.200
     4.797   129.654     0.200
     4.800   129.113     0.200
     4.802   129.004     0.200
     4.804   129.873     0.200
     4.808   130.703     0.200
     4.926   134.055     0.200
     4.892   130.674     0.200
     4.896   133.434     0.200
     4.985   134.064     0.200
     5.235   138.664     0.200
     5.482   144.484     0.200
     5.611   147.994     0.200
     5.699   152.465     0.200
     5.870   157.594     0.200
     5.964   158.715     0.200
     6.256   167.814     0.200
     6.297   166.074     0.200
     6.556   173.494     0.200
     6.630   174.094     0.200
     6.704   177.045     0.200
     6.865   178.334     0.200
     7.223   185.924     0.200
     7.595   197.344     0.200
     7.645   199.094     0.200
     7.875   206.523     0.200
     7.842   204.004     0.200
     8.769   228.854     0.200
     8.790   225.504     0.200
    10.153   261.795     0.200
    11.177   287.123     0.200
    11.388   291.783     0.200
    11.418   292.094     0.200
    11.425   291.934     0.200
    11.605   301.314     0.200
    11.824   302.924     0.200
    11.943   304.104     0.200
    13.132   334.414     0.200
    13.354   341.805     0.200
    13.921   355.135     0.200
    15.329   381.715     0.200
    16.285   407.885     0.200
    16.489   405.635     0.200
    16.729   419.402     0.200
    17.870   447.184     0.200
    18.294   455.434     0.200
    19.784   496.729     0.200
     1.157    37.844     0.200
     1.667    49.617     0.200
     2.261    64.645     0.200
     2.639    75.367     0.200
     2.727    76.086     0.200
     2.934    81.246     0.200
     3.174    90.094     0.200
     3.382    89.656     0.200
     3.446    96.254     0.200
     3.495    94.117     0.200
     3.910   108.625     0.200
     3.860   108.766     0.200
     4.060   109.195     0.200
     4.318   113.805     0.200
     4.337   120.277     0.200
     4.343   114.477     0.200
     4.347   116.465     0.200
     4.351   118.465     0.200
     4.373   115.824     0.200
     4.376   116.945     0.200
     4.411   122.934     0.200
     4.412   122.934     0.200
     4.524   123.605     0.200
     4.623   128.426     0.200
     4.752   124.094     0.200
     0.788    26.527     0.200
     0.852    29.176     0.200
     1.874    54.098     0.200
     2.425    68.816     0.200
     2.590    74.258     0.200
     2.691    75.855     0.200
     3.309    92.289     0.200
     3.696   101.227     0.200
     1.003    31.641     0.200
     1.791    49.383     0.200
     2.117    59.320     0.200
     2.719    74.227     0.200
     3.022    85.062     0.200
     3.061    82.656     0.200
     3.523    92.000     0.200
     3.617    98.289     0.200
     3.958   110.094     0.200
     3.971   109.727     0.200
     4.184   112.422     0.200
     4.414   119.852     0.200
     4.425   120.297     0.200
     4.478   115.539     0.200
     4.695   128.469     0.200
     4.843   130.094     0.200
     5.162   137.320     0.200
     5.205   135.281     0.200
     5.285   138.578     0.200
     5.555   146.172     0.200
     5.585   146.172     0.200
     5.734   151.617     0.200
     5.844   155.023     0.200
     6.080   163.188     0.200
     6.224   157.070     0.200
     6.290   165.227     0.200
     7.026   187.703     0.200
     7.238   186.344     0.200
     7.463   195.867     0.200
     7.448   199.273     0.200
     8.024   209.492     0.200
     8.906   232.633     0.200
     9.682   252.383     0.200
     9.738   256.461     0.200
    10.762   274.844     0.200
     1.199    39.263     0.200
     1.298    41.473     0.200
     2.747    76.753     0.200
     3.533    99.023     0.200
     3.552    99.523     0.200
     3.624   101.683     0.200
     4.007   106.963     0.200
     4.121   116.283     0.200
     4.190   106.323     0.200
     4.413   122.943     0.200
     4.433   124.273     0.200
     4.442   124.273     0.200
     4.498   124.273     0.200
     4.867   122.263     0.200
     5.211   141.063     0.200
     5.185   132.743     0.200
     5.302   135.783     0.200
     5.599   145.243     0.200
     5.585   153.813     0.200
     1.189    37.727     0.200
     1.635    46.967     0.200
     1.923    55.146     0.200
     2.295    65.627     0.200
     2.615    74.477     0.200
     2.696    76.268     0.200
     3.423    93.238     0.200
     3.751   105.197     0.200
     3.889   103.207     0.200
     3.894   105.867     0.200
     3.921   103.867     0.200
     3.924   102.547     0.200
     3.932   106.527     0.200
     3.944   107.197     0.200
     4.017   106.527     0.200
     4.015   108.527     0.200
     4.041   107.197     0.200
     4.078   111.848     0.200
     4.028   109.248     0.200
     4.159   113.178     0.200
     4.164   117.158     0.200
     4.205   114.508     0.200
     4.299   114.838     0.200
     4.316   117.498     0.200
     4.324   116.168     0.200
     4.332   116.828     0.200
     4.402   122.818     0.200
     4.348   116.857     0.200
     4.344   122.098     0.200
     4.504   118.158     0.200
     4.644   128.768     0.200
     4.726   123.768     0.200
     5.044   133.367     0.200
     5.050   133.328     0.200
     5.151   140.578     0.200
     5.454   150.988     0.200
     5.443   145.768     0.200
     5.565   147.057     0.200
     5.734   156.018     0.200
     5.922   150.758     0.200
     6.086   163.008     0.200
     6.069   153.838     0.200
     6.156   166.377     0.200
     6.954   183.867     0.200
     7.085   179.908     0.200
     7.456   186.598     0.200
     7.491   197.227     0.200
     7.887   208.857     0.200
     7.897   203.508     0.200
     8.248   211.957     0.200
     8.367   218.818     0.200
     8.566   224.168     0.200
     9.081   237.268     0.200
     9.259   238.717     0.200
     9.611   246.797     0.200
     9.816   258.607     0.200
     9.937   263.787     0.200
    10.867   285.768     0.200
    11.326   290.408     0.200
    12.072   308.428     0.200
    12.441   307.838     0.200
    12.900   323.717     0.200
    13.009   334.758     0.200
    13.534   343.887     0.200
    14.414   356.428     0.200
    17.068   424.396     0.200
    17.921   441.418     0.200
    18.686   460.748     0.200
     1.310    42.301     0.200
     1.414    43.668     0.200
     3.810   106.598     0.200
     3.819   107.039     0.200
     4.001   101.930     0.200
     3.959   110.891     0.200
     4.001   111.879     0.200
     4.303   117.898     0.200
     4.301   112.320     0.200
     4.434   123.879     0.200
     4.671   131.551     0.200
     4.649   130.801     0.200
     4.990   133.711     0.200
     5.022   127.469     0.200
     5.107   133.418     0.200
     5.405   139.488     0.200
     5.392   146.840     0.200
     5.472   146.430     0.200
     5.676   150.570     0.200
     6.014   161.078     0.200
     6.112   162.219     0.200
     6.900   177.551     0.200
     7.055   179.559     0.200
     7.848   208.480     0.200
     1.136    38.145     0.200
     1.239    39.902     0.200
     2.677    76.094     0.200
     3.044    84.422     0.200
     3.596    96.383     0.200
     4.326   120.344     0.200
     4.349   119.691     0.200
     4.353   119.453     0.200
     4.355   120.055     0.200
     4.358   121.473     0.200
     4.363   120.293     0.200
     4.454   120.754     0.200
     4.444   121.234     0.200
     4.448   123.023     0.200
     4.804   128.281     0.200
     5.124   136.953     0.200
     5.184   140.672     0.200
     5.803   155.402     0.200
     1.859    54.898     0.200
     2.663    74.539     0.200
     2.663    75.539     0.200
     2.753    78.625     0.200
     3.340    89.008     0.200
     3.548    96.555     0.200
     3.771   105.336     0.200
     3.995   109.797     0.200
     4.000   112.055     0.200
     4.107   110.398     0.200
     4.383   121.016     0.200
     4.395   117.672     0.200
     4.395   120.055     0.200
     4.401   120.828     0.200
     4.411   123.078     0.200
     4.420   122.945     0.200
     4.420   121.469     0.200
     4.431   121.203     0.200
     4.438   123.016     0.200
     4.472   122.836     0.200
     4.484   118.617     0.200
     4.527   123.438     0.200
     4.582   125.867     0.200
     4.672   122.445     0.200
     4.807   134.695     0.200
     4.808   134.695     0.200
     4.833   129.242     0.200
     4.858   131.266     0.200
     4.861   133.109     0.200
     4.862   134.219     0.200
     4.866   132.258     0.200
     4.868   132.258     0.200
     4.935   133.922     0.200
     4.969   129.156     0.200
     4.969   127.125     0.200
     5.047   130.539     0.200
     5.296   137.484     0.200
     5.329   139.578     0.200
     5.402   144.703     0.200
     5.649   148.609     0.200
     5.694   151.203     0.200
     5.777   150.992     0.200
     5.899   156.258     0.200
     6.032   158.859     0.200
     6.078   163.547     0.200
     6.301   166.922     0.200
     6.326   170.992     0.200
     6.615   176.016     0.200
     6.782   179.164     0.200
     6.782   179.164     0.200
     6.791   171.797     0.200
     6.796   178.523     0.200
     7.144   184.359     0.200
     7.558   195.125     0.200
     7.582   202.359     0.200
     7.728   200.016     0.200
     7.852   209.453     0.200
     7.754   202.180     0.200
     7.754   206.148     0.200
     8.514   218.688     0.200
     8.514   219.812     0.200
     9.175   235.969     0.200
     9.431   246.016     0.200
     9.659   247.023     0.200
    10.229   263.633     0.200
    11.253   292.078     0.200
    11.468   288.766     0.200
    11.498   294.805     0.200
    13.054   335.289     0.200
    13.835   349.688     0.200
    15.251   390.195     0.200
    15.251   387.719     0.200
    16.403   412.297     0.200
     1.033    33.074     0.200
     2.784    77.957     0.200
     3.097    85.996     0.200
     3.054    84.555     0.200
     3.570    99.395     0.200
     3.594    99.977     0.200
     3.589    98.645     0.200
     3.661   100.934     0.200
     3.823   105.496     0.200
     4.017   109.465     0.200
     4.030   110.086     0.200
     4.037   109.344     0.200
     4.053   109.074     0.200
     4.056   110.246     0.200
     4.062   110.164     0.200
     4.062   111.426     0.200
     4.073   110.836     0.200
     4.079   109.574     0.200
     4.118   110.887     0.200
     4.152   115.074     0.200
     4.159   113.445     0.200
     4.171   114.754     0.200
     4.219   112.625     0.200
     4.222   112.785     0.200
     4.282   116.387     0.200
     4.301   117.855     0.200
     4.352   116.273     0.200
     4.451   122.566     0.200
     4.471   121.227     0.200
     4.476   121.855     0.200
     4.480   123.516     0.200
     4.488   120.727     0.200
     4.510   120.434     0.200
     4.532   120.207     0.200
     4.532   121.074     0.200
     4.659   123.434     0.200
     4.903   130.156     0.200
     5.244   137.414     0.200
     5.622   149.074     0.200
     5.650   149.465     0.200
     5.907   155.715     0.200
     6.168   163.484     0.200
     6.237   165.523     0.200
     6.263   164.414     0.200
     6.342   166.266     0.200
     7.067   186.586     0.200
     7.532   194.484     0.200
     7.859   205.555     0.200
    10.815   279.516     0.200
     0.985    31.953     0.200
     8.113   204.230     0.200
    11.029   286.773     0.200
     0.327    13.703     0.200
     0.721    23.555     0.200
     0.877    28.535     0.200
     0.983    30.914     0.200
     1.368    40.773     0.200
     1.568    47.047     0.200
     1.951    55.965     0.200
     2.758    76.676     0.200
     3.003    80.137     0.200
     3.220    83.816     0.200
     3.434    94.445     0.200
     3.547    94.656     0.200
     3.561    96.445     0.200
     3.709   104.414     0.200
     3.862   105.047     0.200
     3.906   103.887     0.200
     3.930   111.727     0.200
     3.957   105.836     0.200
     3.951   105.047     0.200
     4.020   109.695     0.200
     4.042   109.695     0.200
     4.112   110.363     0.200
     4.328   108.316     0.200
     4.195   112.594     0.200
     4.308   113.426     0.200
     4.307   113.426     0.200
     4.355   119.695     0.200
     4.383   121.695     0.200
     4.384   117.004     0.200
     4.385   122.355     0.200
     4.388   122.414     0.200
     4.558   115.613     0.200
     4.572   125.016     0.200
     4.896   122.766     0.200
     5.218   132.336     0.200
     5.344   132.227     0.200
     5.373   137.344     0.200
     5.404   147.254     0.200
     5.575   141.023     0.200
     5.691   144.156     0.200
     5.880   149.945     0.200
     5.848   155.215     0.200
     7.179   186.754     0.200
     8.743   222.453     0.200
     0.782    26.757     0.200
     1.734    49.647     0.200
     2.152    59.887     0.200
     3.729   104.147     0.200
     3.968   110.237     0.200
     4.591   125.027     0.200
     4.620   119.047     0.200
     4.620   127.018     0.200
     4.621   123.697     0.200
     5.129   132.438     0.200
     5.450   141.697     0.200
     5.556   142.207     0.200
     5.600   139.297     0.200
     5.914   155.947     0.200
     6.115   156.397     0.200
     0.755    25.539     0.200
     0.855    27.352     0.200
     1.392    40.664     0.200
     2.937    81.469     0.200
     3.453    91.375     0.200
     3.561    92.812     0.200
     3.598    96.734     0.200
     3.679   102.078     0.200
     3.732    98.453     0.200
     3.875   103.383     0.200
     3.934   106.805     0.200
     3.928   102.312     0.200
     3.977   108.531     0.200
     4.022   104.781     0.200
     4.077   105.859     0.200
     4.117   110.273     0.200
     4.130   103.461     0.200
     4.177   108.578     0.200
     4.185   112.898     0.200
     4.210   114.562     0.200
     4.260   108.055     0.200
     4.269   112.648     0.200
     4.454   117.930     0.200
     4.504   118.719     0.200
     4.526   116.414     0.200
     4.531   117.625     0.200
     4.556   116.609     0.200
     4.555   119.141     0.200
     4.556   119.898     0.200
     4.558   116.539     0.200
     4.564   121.594     0.200
     4.744   127.508     0.200
     5.075   132.430     0.200
     5.397   142.648     0.200
     5.522   137.750     0.200
     5.751   146.031     0.200
     5.871   147.805     0.200
     5.933   151.914     0.200
     6.059   152.938     0.200
     0.805    26.709     0.200
     0.964    31.988     0.200
     1.058    33.529     0.200
     1.514    41.428     0.200
     1.885    53.059     0.200
     2.825    76.119     0.200
     2.910    77.369     0.200
     3.077    83.039     0.200
     3.288    86.939     0.200
     3.840   105.619     0.200
     4.105   106.418     0.200
     4.114   106.139     0.200
     4.123   111.408     0.200
     4.131   113.270     0.200
     4.131   113.139     0.200
     4.139   111.398     0.200
     4.143   111.998     0.200
     4.148   106.359     0.200
     4.184   113.799     0.200
     4.237   112.309     0.200
     4.292   111.850     0.200
     4.408   115.248     0.200
     4.401   117.488     0.200
     4.541   123.469     0.200
     4.575   122.209     0.200
     4.576   122.209     0.200
     4.685   124.738     0.200
     4.755   127.248     0.200
     5.041   133.199     0.200
     5.361   136.238     0.200
     5.428   135.850     0.200
     5.495   140.648     0.200
     5.523   147.779     0.200
     5.641   155.449     0.200
     5.740   153.209     0.200
     6.036   162.428     0.200
     6.094   161.379     0.200
     6.323   162.020     0.200
     6.499   172.979     0.200
     6.499   172.979     0.200
     6.845   177.619     0.200
     7.418   196.020     0.200
     7.720   208.100     0.200
     8.228   210.258     0.200
     8.228   207.078     0.200
     8.730   225.539     0.200
     8.887   228.328     0.200
     9.581   244.818     0.200
     9.943   258.068     0.200
    10.110   260.338     0.200
    14.397   355.934     0.200
     2.618    74.104     0.200
     2.759    77.395     0.200
     3.083    81.834     0.200
     3.041    83.284     0.200
     3.468    94.544     0.200
     3.539    96.454     0.200
     3.563    96.274     0.200
     3.562    98.935     0.200
     3.632    98.744     0.200
     3.641    98.765     0.200
     3.810   103.505     0.200
     3.795   101.135     0.200
     3.917   107.885     0.200
     3.986   106.935     0.200
     4.207   110.965     0.200
     4.422   118.345     0.200
     4.443   117.965     0.200
     4.448   118.595     0.200
     4.451   116.465     0.200
     4.459   118.425     0.200
     4.477   119.755     0.200
     4.511   120.725     0.200
     4.513   120.604     0.200
     4.631   119.715     0.200
     4.749   125.854     0.200
     4.879   128.704     0.200
     5.198   136.194     0.200
     5.228   139.534     0.200
     5.317   141.944     0.200
     5.616   151.854     0.200
     5.883   156.024     0.200
     6.134   158.584     0.200
     6.248   164.324     0.200
     6.322   164.805     0.200
     1.602    45.250     0.200
     1.702    48.820     0.200
     1.877    54.729     0.200
     2.089    53.830     0.200
     2.556    71.260     0.200
     2.686    75.410     0.200
     2.841    79.110     0.200
     3.027    83.370     0.200
     3.345    92.790     0.200
     3.417    91.970     0.200
     3.469    93.010     0.200
     3.496    97.979     0.200
     3.972   102.400     0.200
     4.359   114.740     0.200
     5.074   131.710     0.200
     5.780   151.170     0.200
     1.712    50.262     0.200
     2.082    59.492     0.200
     2.555    73.762     0.200
     2.710    77.281     0.200
     3.083    85.930     0.200
     3.430    96.812     0.200
     3.511    95.250     0.200
     3.634    99.211     0.200
     3.674   103.223     0.200
     3.950   111.051     0.200
     4.202   114.379     0.200
     4.354   115.770     0.200
     4.377   118.070     0.200
     4.384   116.230     0.200
     4.381   122.531     0.200
     4.390   124.062     0.200
     4.480   115.340     0.200
     4.566   124.289     0.200
     4.631   128.711     0.200
     4.838   129.180     0.200
     5.158   135.711     0.200
     5.222   133.340     0.200
     5.289   143.852     0.200
     5.543   146.980     0.200
     5.594   149.562     0.200
     5.836   153.211     0.200
     2.621    70.711     0.200
     2.760    74.238     0.200
     2.971    81.828     0.200
     2.976    83.211     0.200
     3.417    92.559     0.200
     3.667   102.508     0.200
     3.857   105.828     0.200
     3.857   100.508     0.200
     3.874   107.938     0.200
     3.883   107.820     0.200
     3.889   107.160     0.200
     3.889   107.820     0.200
     3.986   109.820     0.200
     4.108   113.801     0.200
     4.387   120.781     0.200
     4.357   117.789     0.200
     4.489   122.961     0.200
     4.633   127.340     0.200
     4.745   127.688     0.200
     5.064   126.430     0.200
     5.457   144.871     0.200
     5.746   147.379     0.200
     5.746   153.008     0.200
     6.066   162.008     0.200
     6.132   155.461     0.200
     6.021   163.340     0.200
     6.193   157.230     0.200
     6.193   157.230     0.200
     7.145   178.531     0.200
     7.055   190.250     0.200
     7.403   197.598     0.200
     7.747   199.621     0.200
     7.926   200.949     0.200
     7.926   203.328     0.200
     8.931   232.418     0.200
     9.641   249.410     0.200
     9.800   252.410     0.200
    10.665   272.570     0.200
     0.633    24.551     0.200
     0.966    31.152     0.200
     1.021    32.223     0.200
     1.101    35.250     0.200
     1.213    37.160     0.200
     1.907    50.742     0.200
     2.258    60.230     0.200
     2.377    65.562     0.200
     2.697    69.242     0.200
     2.856    77.871     0.200
     2.919    76.680     0.200
     3.012    81.793     0.200
     3.031    78.211     0.200
     3.128    83.652     0.200
     3.160    84.480     0.200
     3.307    87.992     0.200
     3.352    88.531     0.200
     3.300    87.191     0.200
     3.436    89.031     0.200
     3.461    90.211     0.200
     3.489    89.402     0.200
     3.504    90.770     0.200
     3.519    90.293     0.200
     3.528    89.660     0.200
     3.548    93.383     0.200
     3.558    90.812     0.200
     3.611    93.891     0.200
     3.640    95.191     0.200
     3.691    94.680     0.200
     3.713    94.641     0.200
     3.764    98.840     0.200
     3.843   103.641     0.200
     3.916   103.973     0.200
     3.916   103.973     0.200
     3.954   102.941     0.200
     3.971   104.891     0.200
     4.009   102.352     0.200
     3.984   103.723     0.200
     3.983   107.012     0.200
     3.984   106.453     0.200
     3.985   103.652     0.200
     3.987   103.652     0.200
     4.172   110.402     0.200
     4.192   107.430     0.200
     4.154   111.812     0.200
     4.233   108.770     0.200
     4.516   115.152     0.200
     4.838   123.652     0.200
     5.018   128.410     0.200
     5.010   125.641     0.200
     6.035   150.910     0.200
     6.737   167.793     0.200
     7.717   195.023     0.200
     7.717   195.633     0.200
     8.361   209.883     0.200
     9.430   236.691     0.200
    13.803   341.977     0.200
     1.296    36.961     0.200
     1.679    46.250     0.200
     2.644    73.031     0.200
     2.947    76.695     0.200
     3.345    90.281     0.200
     3.507    92.523     0.200
     3.450    92.812     0.200
     3.912   105.555     0.200
     4.072   106.875     0.200
     4.320   119.305     0.200
     4.339   119.195     0.200
     4.385   114.570     0.200
     4.345   118.562     0.200
     4.359   117.125     0.200
     4.408   118.555     0.200
     4.604   126.352     0.200
     4.758   122.570     0.200
     5.093   130.586     0.200
     5.077   133.016     0.200
     5.189   133.656     0.200
     2.207    65.664     0.200
     2.446    71.834     0.200
     3.111    90.203     0.200
     3.221    91.854     0.200
     3.150    89.873     0.200
     3.188    92.324     0.200
     3.223    87.113     0.200
     3.315    92.803     0.200
     3.253    86.613     0.200
     3.269    94.873     0.200
     3.279    88.184     0.200
     3.363    96.953     0.200
     3.358    90.934     0.200
     3.382    90.254     0.200
     3.426    96.824     0.200
     3.382    98.713     0.200
     3.560    95.914     0.200
     3.742   104.264     0.200
     3.736   107.773     0.200
     4.272   118.463     0.200
     4.301   116.383     0.200
     4.383   119.863     0.200
     4.498   120.633     0.200
     4.818   131.064     0.200
     0.808    27.930     0.200
     0.967    32.660     0.200
     1.068    35.570     0.200
     1.939    55.230     0.200
     2.808    78.520     0.200
     4.327   117.832     0.200
     4.432   121.391     0.200
     4.343   118.992     0.200
     4.458   120.590     0.200
     4.460   121.281     0.200
     4.462   121.160     0.200
     4.606   120.680     0.200
     4.467   121.930     0.200
     4.590   124.652     0.200
     4.941   135.660     0.200
     5.347   138.141     0.200
     5.262   139.801     0.200
     5.402   141.492     0.200
     5.711   148.230     0.200
     5.933   159.152     0.200
     5.995   162.961     0.200
     1.229    40.449     0.200
     1.047    35.977     0.200
     1.147    38.078     0.200
     1.182    38.848     0.200
     1.265    40.617     0.200
     2.467    69.129     0.200
     3.059    83.309     0.200
     3.160    84.797     0.200
     3.261    92.949     0.200
     3.324    89.066     0.200
     3.239    86.586     0.200
     4.231   107.977     0.200
     4.447   121.449     0.200
     4.735   128.359     0.200
     4.768   124.738     0.200
     5.033   131.238     0.200
     5.352   145.246     0.200
     5.407   149.316     0.200
     1.173    36.595     0.200
     1.744    48.354     0.200
     2.660    71.495     0.200
     3.015    81.234     0.200
     2.981    83.575     0.200
     3.462    92.545     0.200
     3.428    92.245     0.200
     3.568    92.935     0.200
     3.448    94.715     0.200
     3.524    93.295     0.200
     3.699    96.265     0.200
     3.718    99.145     0.200
     3.806   104.085     0.200
     3.873   100.854     0.200
     3.889   106.475     0.200
     3.909   104.024     0.200
     3.933   109.975     0.200
     4.135   106.114     0.200
     4.019   102.665     0.200
     4.078   107.585     0.200
     4.336   114.285     0.200
     4.341   116.995     0.200
     4.344   113.234     0.200
     4.386   116.645     0.200
     2.942    79.292     0.200
     3.323    89.912     0.200
     3.422    93.932     0.200
     3.499    93.552     0.200
     3.875   106.622     0.200
     4.285   112.722     0.200
     4.305   112.672     0.200
     4.368   116.002     0.200
     4.311   113.042     0.200
     4.314   110.352     0.200
     4.366   115.732     0.200
     4.324   116.982     0.200
     4.361   118.862     0.200
     4.493   119.832     0.200
     4.552   124.752     0.200
     4.735   120.102     0.200
     4.676   128.352     0.200
     5.086   133.212     0.200
     5.054   129.732     0.200
     5.454   145.382     0.200
     5.739   150.052     0.200
     6.106   157.922     0.200
     6.177   161.852     0.200
     6.065   160.742     0.200
     7.113   188.722     0.200
     2.929    79.350     0.200
     3.088    87.300     0.200
     3.196    92.290     0.200
     3.287    91.660     0.200
     3.207    91.470     0.200
     3.345    90.330     0.200
     3.333    96.290     0.200
     3.715   103.020     0.200
     4.247   116.420     0.200
     4.476   119.400     0.200
     4.702   127.500     0.200
     4.796   127.180     0.200
     5.066   137.480     0.200
     5.235   139.940     0.200
     5.376   146.470     0.200
     5.442   142.940     0.200
     6.037   168.660     0.200
     1.647    48.170     0.200
     2.387    69.410     0.200
     3.394    95.440     0.200
     3.332    94.650     0.200
     3.782   101.110     0.200
     4.312   111.370     0.200
     4.395   122.490     0.200
     4.511   123.250     0.200
     4.830   128.300     0.200
     4.697   131.010     0.200
     5.102   137.350     0.200
     5.408   143.530     0.200
     5.479   142.720     0.200
     6.039   159.840     0.200
     1.187    38.602     0.200
     1.227    40.664     0.200
     2.512    72.211     0.200
     2.996    84.484     0.200
     3.094    86.594     0.200
     3.172    89.602     0.200
     3.267    92.023     0.200
     3.308    93.906     0.200
     3.362    95.477     0.200
     4.149   113.344     0.200
     4.163   114.328     0.200
     4.254   116.797     0.200
     4.385   120.914     0.200
     4.705   130.266     0.200
     4.968   136.203     0.200
     5.128   137.617     0.200
     1.704    53.176     0.200
     2.388    69.556     0.200
     2.485    71.226     0.200
     3.557   103.045     0.200
     3.714   106.516     0.200
     3.725   101.485     0.200
     3.730   100.825     0.200
     3.743   102.146     0.200
     4.757   132.386     0.200
     4.775   131.245     0.200
     5.008   141.676     0.200
     5.196   140.105     0.200
     6.008   159.285     0.200
     6.100   160.115     0.200
     6.190   162.105     0.200
     6.622   172.806     0.200
     7.645   200.835     0.200
     8.248   216.266     0.200
     8.419   220.285     0.200
     1.843    50.928     0.200
     2.358    66.396     0.200
     2.774    74.578     0.200
     3.113    87.307     0.200
     3.487    96.146     0.200
     3.577    96.578     0.200
     3.670    96.707     0.200
     3.759   103.688     0.200
     4.025   107.146     0.200
     4.430   117.998     0.200
     4.452   117.498     0.200
     4.456   117.627     0.200
     4.459   117.998     0.200
     4.467   118.998     0.200
     4.472   118.057     0.200
     4.532   119.146     0.200
     4.640   121.057     0.200
     4.898   122.457     0.200
     5.217   134.338     0.200
     5.257   133.008     0.200
     5.339   137.658     0.200
     5.339   141.707     0.200
     5.639   142.008     0.200
     5.899   152.527     0.200
     6.112   158.977     0.200
     1.170    37.422     0.200
     1.209    39.191     0.200
     1.429    41.504     0.200
     2.401    68.363     0.200
     2.487    69.531     0.200
     2.473    69.145     0.200
     2.409    67.133     0.200
     3.282    86.352     0.200
     3.124    85.645     0.200
     3.204    87.434     0.200
     3.291    88.812     0.200
     3.354    90.293     0.200
     3.650    99.844     0.200
     3.682    99.602     0.200
     3.687    99.844     0.200
     3.635    98.074     0.200
     3.700    99.965     0.200
     4.178   111.004     0.200
     4.195   111.613     0.200
     4.413   117.754     0.200
     4.732   122.812     0.200
     4.733   125.102     0.200
     4.997   132.402     0.200
     5.159   136.324     0.200
     1.202    40.809     0.200
     1.282    43.049     0.200
     3.268    90.459     0.200
     3.320    94.709     0.200
     3.353    93.100     0.200
     3.695   101.318     0.200
     3.696   105.180     0.200
     3.708   100.449     0.200
     3.713   102.408     0.200
     3.728   101.619     0.200
     4.225   113.119     0.200
     4.253   115.029     0.200
     4.773   132.328     0.200
     5.043   140.809     0.200
     5.214   139.959     0.200
     5.352   149.828     0.200
     5.420   144.488     0.200
     6.205   168.309     0.200
     6.613   179.299     0.200
     7.162   189.439     0.200
     7.640   194.389     0.200
     9.806   256.818     0.200
     0.944    30.621     0.200
     1.102    36.109     0.200
     1.803    51.430     0.200
     2.254    63.480     0.200
     2.863    81.129     0.200
     2.959    82.172     0.200
     3.075    78.879     0.200
     3.449    96.262     0.200
     3.459    96.852     0.200
     3.552    97.070     0.200
     3.721    99.559     0.200
     3.828   106.031     0.200
     3.891   106.820     0.200
     3.909   105.781     0.200
     3.914   103.711     0.200
     3.918   108.660     0.200
     3.940   100.051     0.200
     3.931   103.059     0.200
     3.943   108.559     0.200
     3.957   104.262     0.200
     4.045   108.191     0.200
     4.102   107.559     0.200
     4.194   112.559     0.200
     4.152   109.770     0.200
     4.182   110.172     0.200
     4.242   116.121     0.200
     4.344   118.191     0.200
     4.367   119.539     0.200
     4.371   120.762     0.200
     4.373   120.969     0.200
     4.380   121.492     0.200
     4.371   114.289     0.200
     4.404   121.359     0.200
     4.470   115.270     0.200
     4.481   119.879     0.200
     4.555   123.422     0.200
     4.622   127.961     0.200
     4.828   126.930     0.200
     5.149   133.648     0.200
     5.214   142.629     0.200
     5.280   144.012     0.200
     5.533   146.379     0.200
     5.585   143.449     0.200
     5.826   152.879     0.200
     6.284   162.492     0.200
     6.546   177.102     0.200
     7.057   181.648     0.200
     7.245   181.379     0.200
     8.014   202.488     0.200
     8.014   202.262     0.200
     9.729   257.082     0.200
    16.773   423.562     0.200
     1.061    33.602     0.200
     2.993    82.398     0.200
     3.114    87.625     0.200
     3.268    87.578     0.200
     3.356    93.938     0.200
     3.526    97.883     0.200
     3.538    97.570     0.200
     3.549    97.992     0.200
     3.554    98.398     0.200
     3.568    99.305     0.200
     3.725    99.922     0.200
     3.921   100.188     0.200
     4.239   108.828     0.200
     4.286   111.633     0.200
     4.353   120.594     0.200
     4.654   127.789     0.200
     4.655   125.891     0.200
     4.930   128.398     0.200
     0.281    13.320     0.200
     0.719    23.312     0.200
     0.877    28.008     0.200
     0.980    31.023     0.200
     1.432    40.188     0.200
     2.227    62.289     0.200
     2.733    76.039     0.200
     3.252    85.453     0.200
     3.546    98.828     0.200
     3.793    99.312     0.200
     4.014   109.719     0.200
     4.236   112.211     0.200
     4.371   114.750     0.200
     4.412   122.258     0.200
     4.440   123.586     0.200
     4.442   123.586     0.200
     4.445   120.250     0.200
     4.628   118.680     0.200
     4.945   125.711     0.200
     5.267   131.930     0.200
     5.381   141.367     0.200
     5.418   134.797     0.200
     5.467   148.219     0.200
     5.628   146.633     0.200
     5.733   148.891     0.200
     5.932   155.641     0.200
     5.908   156.531     0.200
     6.190   160.938     0.200
     6.400   163.453     0.200
     7.234   190.672     0.200
     2.894    76.887     0.200
     2.912    82.156     0.200
     3.107    84.695     0.200
     3.107    80.336     0.200
     3.441    95.348     0.200
     3.552    89.406     0.200
     3.452    93.727     0.200
     3.515    98.027     0.200
     3.656    98.785     0.200
     3.656    93.438     0.200
     3.919   105.027     0.200
     3.919   108.906     0.200
     3.922   109.387     0.200
     3.949   106.785     0.200
     3.939   107.688     0.200
     4.225   114.727     0.200
     4.352   118.648     0.200
     4.376   118.648     0.200
     4.379   121.309     0.200
     4.381   118.648     0.200
     4.364   120.105     0.200
     4.364   120.105     0.200
     4.507   120.887     0.200
     4.493   119.406     0.200
     4.383   120.777     0.200
     5.168   134.777     0.200
     5.244   138.746     0.200
     5.304   141.457     0.200
     5.547   147.469     0.200
     5.611   147.469     0.200
     5.842   157.945     0.200
     5.981   164.348     0.200
     6.264   165.406     0.200
     6.308   167.379     0.200
     6.307   167.379     0.200
     7.075   178.688     0.200
     7.274   187.598     0.200
     8.035   202.727     0.200
     8.035   207.828     0.200
     8.694   217.945     0.200
     9.750   254.867     0.200
    10.777   277.586     0.200
     1.273    41.547     0.200
     3.206    90.148     0.200
     3.249    90.641     0.200
     3.387    95.672     0.200
     3.371    92.391     0.200
     3.419    96.812     0.200
     3.713   103.477     0.200
     4.260   115.703     0.200
     4.274   116.438     0.200
     4.366   118.672     0.200
     4.494   124.914     0.200
     4.756   129.594     0.200
     4.815   133.820     0.200
     5.045   136.500     0.200
     5.079   137.812     0.200
     5.239   144.164     0.200
     5.399   144.531     0.200
     5.453   148.383     0.200
     6.100   162.102     0.200
     6.232   166.023     0.200
     3.722    93.373     0.200
     3.670    98.322     0.200
     3.839   104.303     0.200
     4.032   107.623     0.200
     4.036   108.104     0.200
     4.048   108.293     0.200
     4.075   111.613     0.200
     4.163   112.273     0.200
     4.220   113.604     0.200
     4.289   106.393     0.200
     4.269   113.604     0.200
     4.461   121.832     0.200
     4.484   122.533     0.200
     4.488   120.674     0.200
     4.585   117.623     0.200
     4.673   126.943     0.200
     4.940   126.604     0.200
     5.260   138.453     0.200
     5.310   131.934     0.200
     5.386   138.004     0.200
     5.688   147.312     0.200
     5.939   156.764     0.200
     1.214    40.651     0.200
     1.247    42.211     0.200
     1.329    44.141     0.200
     1.620    49.191     0.200
     3.478    96.741     0.200
     3.645   102.691     0.200
     3.645   104.241     0.200
     4.173   115.391     0.200
     4.284   119.371     0.200
     4.400   123.521     0.200
     4.672   126.231     0.200
     4.720   132.421     0.200
     4.944   135.671     0.200
     4.990   135.081     0.200
     5.300   147.031     0.200
     5.368   136.141     0.200
     1.271    43.021     0.200
     1.348    43.931     0.200
     1.560    48.730     0.200
     2.192    65.381     0.200
     2.355    68.471     0.200
     4.202   114.351     0.200
     4.249   113.690     0.200
     4.318   117.011     0.200
     4.421   124.101     0.200
     4.606   125.141     0.200
     4.740   127.121     0.200
     5.312   139.551     0.200
     1.808    50.148     0.200
     1.800    49.750     0.200
     2.162    59.578     0.200
     2.617    73.078     0.200
     2.700    73.578     0.200
     3.144    84.172     0.200
     3.271    90.648     0.200
     3.346    92.461     0.200
     3.543    90.906     0.200
     3.549    97.469     0.200
     3.728   100.656     0.200
     3.915   102.461     0.200
     4.350   113.797     0.200
     4.639   125.891     0.200
     4.653   124.383     0.200
     4.646   121.219     0.200
     4.923   128.859     0.200
     4.953   132.797     0.200
     5.308   132.836     0.200
     5.301   141.688     0.200
     5.704   152.188     0.200
     7.090   187.195     0.200
     1.925    55.158     0.200
     2.749    74.307     0.200
     2.825    76.867     0.200
     3.195    83.477     0.200
     3.437    91.668     0.200
     3.486    92.357     0.200
     3.540    95.396     0.200
     3.735    99.557     0.200
     3.955   104.238     0.200
     4.305   111.668     0.200
     4.320   118.828     0.200
     4.382   118.646     0.200
     4.383   119.297     0.200
     4.543   119.637     0.200
     4.568   118.646     0.200
     4.570   119.637     0.200
     4.885   121.396     0.200
     5.207   131.857     0.200
     5.323   135.818     0.200
     5.569   148.217     0.200
     5.872   147.258     0.200
     1.300    41.117     0.200
     1.326    43.168     0.200
     1.516    46.367     0.200
     1.592    48.156     0.200
     2.404    66.688     0.200
     2.852    76.008     0.200
     2.926    76.879     0.200
     3.016    83.516     0.200
     3.040    85.289     0.200
     3.077    82.457     0.200
     3.106    81.258     0.200
     3.119    81.289     0.200
     3.126    82.746     0.200
     3.211    85.738     0.200
     3.196    87.688     0.200
     3.222    87.789     0.200
     3.234    89.496     0.200
     3.243    85.328     0.200
     3.572    96.328     0.200
     3.591   100.238     0.200
     3.604    96.117     0.200
     3.610   101.195     0.200
     3.626    95.598     0.200
     3.808   104.867     0.200
     4.209   106.117     0.200
     4.211   112.695     0.200
     4.272   110.926     0.200
     4.369   118.879     0.200
     4.569   119.738     0.200
     4.688   121.605     0.200
     4.898   131.309     0.200
     4.969   131.789     0.200
     5.160   135.117     0.200
     5.258   137.648     0.200
     5.273   145.336     0.200
     5.184   142.176     0.200
     5.351   140.727     0.200
     5.930   159.238     0.200
     5.923   154.105     0.200
     6.145   158.566     0.200
     6.085   167.469     0.200
     6.284   174.176     0.200
     6.520   172.176     0.200
     7.551   196.234     0.200
     7.551   198.598     0.200
     8.145   209.277     0.200
     1.124    38.379     0.200
     1.273    40.500     0.200
     1.299    42.820     0.200
     1.570    47.301     0.200
     2.363    65.082     0.200
     2.430    67.789     0.200
     2.453    68.660     0.200
     2.601    73.879     0.200
     2.830    77.020     0.200
     2.876    81.691     0.200
     2.952    81.090     0.200
     3.003    81.719     0.200
     3.025    81.141     0.200
     3.083    87.332     0.200
     3.101    83.332     0.200
     3.130    85.309     0.200
     3.152    83.500     0.200
     3.162    86.680     0.200
     3.221    86.750     0.200
     3.236    87.172     0.200
     3.245    92.641     0.200
     3.251    87.469     0.200
     3.255    92.500     0.200
     3.255    92.500     0.200
     3.259    87.160     0.200
     3.434    92.512     0.200
     3.596    99.789     0.200
     3.613    97.980     0.200
     3.615    97.980     0.200
     3.628   100.449     0.200
     3.649   100.941     0.200
     3.666    95.109     0.200
     3.832   105.371     0.200
     4.066   113.680     0.200
     4.171   112.512     0.200
     4.221   114.129     0.200
     4.238   116.500     0.200
     4.288   116.859     0.200
     4.390   120.109     0.200
     4.592   128.551     0.200
     4.709   126.520     0.200
     4.921   126.000     0.200
     5.175   132.160     0.200
     5.281   137.160     0.200
     5.298   146.570     0.200
     5.368   143.012     0.200
     5.950   162.391     0.200
     5.950   162.391     0.200
     5.943   158.250     0.200
     6.161   160.262     0.200
     7.572   198.730     0.200
     7.572   202.629     0.200
     1.128    39.348     0.200
     1.574    49.051     0.200
     2.173    64.738     0.200
     2.359    68.711     0.200
     2.425    70.570     0.200
     2.827    79.188     0.200
     3.001    85.098     0.200
     3.123    85.758     0.200
     3.127    89.770     0.200
     3.159    91.469     0.200
     3.216    89.320     0.200
     3.232    88.719     0.200
     3.243    88.641     0.200
     3.251    93.020     0.200
     3.251    93.020     0.200
     3.252    93.609     0.200
     3.256    89.609     0.200
     3.430    97.758     0.200
     3.610   100.770     0.200
     3.612   100.770     0.200
     3.625    97.961     0.200
     3.631   101.969     0.200
     3.646   101.238     0.200
     3.829   107.000     0.200
     4.170   109.559     0.200
     4.221   114.289     0.200
     4.287   121.777     0.200
     4.388   117.277     0.200
     4.588   122.449     0.200
     4.706   129.270     0.200
     4.918   131.578     0.200
     4.986   132.910     0.200
     5.174   142.129     0.200
     5.173   142.980     0.200
     5.278   136.641     0.200
     5.367   144.367     0.200
     5.938   160.680     0.200
     6.160   163.719     0.200
     1.109    36.646     0.200
     1.310    42.227     0.200
     2.347    66.457     0.200
     2.996    84.877     0.200
     3.119    87.586     0.200
     3.209    90.156     0.200
     3.237    91.037     0.200
     3.244    88.906     0.200
     3.663    99.986     0.200
     4.165   114.877     0.200
     4.218   114.217     0.200
     4.283   116.557     0.200
     4.383   115.115     0.200
     4.701   126.945     0.200
     4.981   132.605     0.200
     5.272   143.695     0.200
     5.363   141.016     0.200
     1.076    35.109     0.200
     2.156    61.242     0.200
     2.641    73.750     0.200
     2.892    79.570     0.200
     2.992    84.477     0.200
     3.163    86.562     0.200
     3.165    85.148     0.200
     3.281    88.859     0.200
     3.355    91.117     0.200
     3.381    93.352     0.200
     3.485    95.438     0.200
     3.543    95.820     0.200
     3.737    96.641     0.200
     3.808   103.242     0.200
     3.850   104.711     0.200
     3.951   104.828     0.200
     3.997   110.586     0.200
     3.980   106.008     0.200
     4.201   116.367     0.200
     4.280   113.211     0.200
     7.486   192.531     0.200
     2.141    63.561     0.200
     3.051    88.061     0.200
     3.157    91.531     0.200
     3.247    92.932     0.200
     3.234    92.391     0.200
     3.310    93.641     0.200
     3.331    92.021     0.200
     3.352    91.541     0.200
     3.675   105.891     0.200
     3.718   107.072     0.200
     4.209   115.041     0.200
     4.234   116.031     0.200
     4.319   117.361     0.200
     4.439   124.471     0.200
     5.027   136.881     0.200
     5.196   143.861     0.200
     5.340   145.172     0.200
     0.727    25.109     0.200
     2.460    66.555     0.200
     3.015    80.672     0.200
     3.458    93.617     0.200
     3.582    95.180     0.200
     3.886   107.141     0.200
     3.890    99.992     0.200
     3.869   105.578     0.200
     3.882   103.148     0.200
     3.892   107.633     0.200
     3.897   105.281     0.200
     4.069   107.328     0.200
     4.044   112.453     0.200
     4.269   112.453     0.200
     4.603   120.430     0.200
     4.586   116.141     0.200
     4.693   120.117     0.200
     4.529   124.133     0.200
     4.673   128.172     0.200
     4.987   127.070     0.200
     5.279   137.039     0.200
     5.925   156.312     0.200
     1.715    51.479     0.200
     2.151    63.979     0.200
     3.205    90.838     0.200
     3.709   104.598     0.200
     4.270   118.479     0.200
     4.365   118.518     0.200
     4.815   133.559     0.200
     5.078   138.508     0.200
     5.237   138.008     0.200
     5.452   150.078     0.200
     1.775    50.370     0.200
     2.521    70.740     0.200
     2.853    79.630     0.200
     3.684   101.810     0.200
     3.945   106.830     0.200
     4.127   115.130     0.200
     4.573   124.400     0.200
     4.535   124.250     0.200
     4.582   123.390     0.200
     4.553   125.340     0.200
     4.560   123.270     0.200
     4.563   125.010     0.200
     4.618   126.610     0.200
     4.741   127.080     0.200
     4.693   129.050     0.200
     4.962   136.880     0.200
     5.383   145.480     0.200
     5.671   149.770     0.200
     5.692   153.910     0.200
     5.766   154.940     0.200
     5.819   150.090     0.200
     5.971   156.710     0.200
     6.287   166.300     0.200
     6.322   167.760     0.200
     6.388   165.330     0.200
     7.190   188.910     0.200
     7.157   189.410     0.200
     7.304   187.350     0.200
     7.984   210.870     0.200
     8.130   210.870     0.200
     9.043   241.020     0.200
     9.845   256.050     0.200
     9.872   258.640     0.200
     9.981   255.460     0.200
    11.179   287.260     0.200
    11.178   283.050     0.200
     0.907    30.645     0.200
     1.169    38.156     0.200
     1.181    39.355     0.200
     2.692    72.055     0.200
     2.919    80.824     0.200
     3.087    80.516     0.200
     3.491    93.465     0.200
     3.635    98.773     0.200
     3.535    99.246     0.200
     3.487    99.195     0.200
     3.620    95.934     0.200
     4.341   122.266     0.200
     4.823   127.094     0.200
     5.144   137.035     0.200
     5.223   131.363     0.200
     5.818   155.504     0.200
     1.469    41.432     0.200
     1.580    46.531     0.200
     1.732    47.582     0.200
     2.368    62.401     0.200
     2.620    70.302     0.200
     2.573    69.882     0.200
     3.137    78.691     0.200
     3.078    84.392     0.200
     3.215    88.172     0.200
     3.267    87.682     0.200
     3.467    96.462     0.200
     3.389    93.932     0.200
     3.475    94.741     0.200
     3.700    94.111     0.200
     3.598    96.401     0.200
     3.633    95.922     0.200
     3.650   102.582     0.200
     3.667   103.352     0.200
     3.669   101.582     0.200
     3.671    99.542     0.200
     3.677    98.812     0.200
     3.682   101.792     0.200
     3.692    99.972     0.200
     3.696   101.682     0.200
     3.696   100.531     0.200
     3.702    99.972     0.200
     3.776   106.082     0.200
     3.792   102.231     0.200
     3.845   105.382     0.200
     3.936   105.371     0.200
     3.959   105.321     0.200
     3.982   106.651     0.200
     4.038   106.292     0.200
     4.045   108.422     0.200
     4.057   108.052     0.200
     4.068   108.672     0.200
     4.073   108.302     0.200
     4.190   111.882     0.200
     4.244   113.231     0.200
     4.225   113.812     0.200
     4.226   113.812     0.200
     4.426   114.762     0.200
     4.722   120.842     0.200
     4.742   120.991     0.200
     4.690   129.991     0.200
     4.837   124.861     0.200
     5.170   134.582     0.200
     5.441   140.832     0.200
     5.741   147.712     0.200
     6.086   160.621     0.200
     6.270   161.142     0.200
     6.653   171.151     0.200
     6.758   172.411     0.200
     7.431   195.401     0.200
     7.587   194.342     0.200
     7.541   197.012     0.200
     7.934   205.161     0.200
     9.432   239.071     0.200
     9.920   258.111     0.200
     1.199    34.759     0.200
     1.280    37.898     0.200
     2.569    71.929     0.200
     2.789    77.969     0.200
     3.370    90.778     0.200
     3.626    98.898     0.200
     3.626    99.358     0.200
     3.790   103.349     0.200
     4.034   104.929     0.200
     3.993   106.669     0.200
     4.067   109.328     0.200
     4.099   109.398     0.200
     4.143   109.919     0.200
     4.157   113.979     0.200
     4.157   110.658     0.200
     4.186   112.648     0.200
     4.227   112.679     0.200
     4.259   114.658     0.200
     4.232   113.229     0.200
     4.279   115.309     0.200
     4.288   114.738     0.200
     4.317   119.299     0.200
     4.344   116.639     0.200
     4.361   117.299     0.200
     4.407   117.578     0.200
     4.423   117.988     0.200
     4.453   118.578     0.200
     4.533   120.129     0.200
     4.460   120.469     0.200
     4.643   124.608     0.200
     4.774   127.929     0.200
     4.806   124.608     0.200
     4.810   127.929     0.200
     4.821   129.259     0.200
     5.006   133.908     0.200
     5.105   133.349     0.200
     5.209   137.648     0.200
     5.282   140.179     0.200
     5.390   141.778     0.200
     5.484   144.698     0.200
     5.542   144.009     0.200
     5.784   151.158     0.200
     6.032   159.339     0.200
     6.104   158.528     0.200
     6.075   157.629     0.200
     6.229   156.969     0.200
     6.384   165.629     0.200
     6.418   165.229     0.200
     6.498   171.339     0.200
     6.686   176.288     0.200
     6.888   178.288     0.200
     7.018   183.318     0.200
     7.115   181.618     0.200
     8.101   208.028     0.200
     8.515   217.328     0.200
     8.629   221.349     0.200
     8.687   223.889     0.200
    10.655   270.868     0.200
     1.186    37.893     0.200
     2.735    74.582     0.200
     2.944    83.953     0.200
     3.108    80.982     0.200
     3.456    97.023     0.200
     3.483    94.982     0.200
     3.536    97.082     0.200
     3.659    96.422     0.200
     3.587   100.232     0.200
     3.549    99.203     0.200
     3.756   104.002     0.200
     3.975   107.943     0.200
     4.227   108.152     0.200
     4.185   113.434     0.200
     4.379   118.922     0.200
     4.402   119.104     0.200
     4.406   118.523     0.200
     4.408   120.742     0.200
     4.516   125.902     0.200
     4.402   122.543     0.200
     4.505   118.363     0.200
     4.429   118.943     0.200
     4.645   126.133     0.200
     4.864   126.213     0.200
     5.184   137.062     0.200
     5.315   143.992     0.200
     5.620   145.803     0.200
     5.861   156.572     0.200
     6.028   160.232     0.200
     0.300    13.059     0.200
     0.743    23.418     0.200
     1.006    31.219     0.200
     1.386    39.969     0.200
     1.938    51.020     0.200
     1.943    53.859     0.200
     2.179    58.129     0.200
     2.757    72.219     0.200
     2.750    75.668     0.200
     2.818    78.389     0.200
     3.207    84.289     0.200
     3.441    90.709     0.200
     3.495    95.469     0.200
     3.547    93.289     0.200
     3.473    95.100     0.200
     3.565    98.838     0.200
     3.747    96.408     0.200
     3.716   100.689     0.200
     3.839   105.100     0.200
     3.871   106.248     0.200
     3.915   105.270     0.200
     3.961   102.918     0.200
     4.048   110.508     0.200
     4.100   107.529     0.200
     4.122   110.689     0.200
     4.317   110.879     0.200
     4.320   117.539     0.200
     4.359   118.389     0.200
     4.387   114.549     0.200
     4.388   111.248     0.200
     4.389   117.270     0.200
     4.381   116.949     0.200
     4.493   117.719     0.200
     4.576   120.629     0.200
     4.893   124.939     0.200
     5.368   137.869     0.200
     5.684   140.338     0.200
     5.880   150.998     0.200
     1.269    41.650     0.200
     1.225    40.441     0.200
     1.714    51.781     0.200
     2.416    70.211     0.200
     3.094    89.830     0.200
     3.261    91.471     0.200
     3.362    94.410     0.200
     3.267    92.941     0.200
     3.396    96.371     0.200
     3.696   104.861     0.200
     3.741   106.500     0.200
     4.246   116.951     0.200
     4.257   117.111     0.200
     4.482   125.771     0.200
     1.754    53.102     0.200
     1.852    54.180     0.200
     2.670    76.195     0.200
     3.097    85.984     0.200
     3.171    87.852     0.200
     3.264    93.406     0.200
     3.396    97.766     0.200
     3.537    99.891     0.200
     3.675   104.203     0.200
     3.939   110.117     0.200
     3.963   112.023     0.200
     4.044   109.320     0.200
     4.118   113.867     0.200
     4.280   117.570     0.200
     4.342   119.070     0.200
     4.391   122.383     0.200
     4.655   124.594     0.200
     4.977   135.141     0.200
     5.162   136.930     0.200
     5.304   137.312     0.200
     5.497   146.820     0.200
     5.497   148.953     0.200
     5.623   151.055     0.200
     6.203   160.797     0.200
     1.242    41.195     0.200
     1.253    42.023     0.200
     1.471    45.234     0.200
     2.201    63.473     0.200
     2.446    70.262     0.200
     3.112    87.855     0.200
     3.192    91.285     0.200
     3.337    95.305     0.200
     3.367    95.742     0.200
     3.391    94.305     0.200
     3.741   105.184     0.200
     4.272   116.523     0.200
     4.383   119.273     0.200
     4.500   123.133     0.200
     4.704   129.203     0.200
     4.820   129.633     0.200
     5.090   137.734     0.200
     5.399   146.133     0.200
     6.055   164.312     0.200
     0.487    17.727     0.200
     1.438    40.508     0.200
     2.082    56.539     0.200
     2.710    70.906     0.200
     3.076    81.414     0.200
     3.176    84.992     0.200
     3.261    87.445     0.200
     3.309    91.117     0.200
     3.639    97.656     0.200
     3.645    98.383     0.200
     3.829    98.477     0.200
     3.769   104.492     0.200
     4.119   107.336     0.200
     4.155   112.266     0.200
     4.488   116.688     0.200
     4.540   122.594     0.200
     4.548   124.133     0.200
     4.807   123.289     0.200
     4.926   127.938     0.200
     5.226   134.445     0.200
     5.209   136.305     0.200
     5.493   143.047     0.200
     5.869   151.922     0.200
     5.931   154.648     0.200
     5.934   157.039     0.200
     7.363   194.258     0.200
     2.589    73.023     0.200
     2.533    72.973     0.200
     2.738    74.871     0.200
     3.159    87.602     0.200
     3.443    95.254     0.200
     3.442    93.492     0.200
     3.459    96.004     0.200
     3.820   107.191     0.200
     3.905   107.102     0.200
     4.137   113.383     0.200
     4.247   112.820     0.200
     4.323   120.570     0.200
     4.546   122.941     0.200
     4.559   126.703     0.200
     4.712   131.273     0.200
     4.831   131.273     0.200
     5.197   136.621     0.200
     5.252   140.793     0.200
     0.250    13.398     0.200
     0.736    23.891     0.200
     0.997    31.191     0.200
     1.460    41.031     0.200
     1.535    46.359     0.200
     1.980    52.449     0.200
     2.254    62.270     0.200
     2.820    74.879     0.200
     2.753    76.238     0.200
     2.887    78.281     0.200
     3.251    85.051     0.200
     3.555    91.461     0.200
     3.540    96.828     0.200
     3.612    98.551     0.200
     4.030   112.891     0.200
     4.364   113.910     0.200
     4.267   118.520     0.200
     4.395   116.289     0.200
     4.429   122.320     0.200
     4.459   122.879     0.200
     4.463   121.730     0.200
     4.611   119.359     0.200
     4.564   123.668     0.200
     4.633   119.090     0.200
     4.645   123.711     0.200
     4.956   128.750     0.200
     5.277   132.609     0.200
     5.425   141.660     0.200
     5.642   141.660     0.200
     5.739   149.809     0.200
     5.940   158.789     0.200
     1.343    43.653     0.200
     1.950    58.553     0.200
     3.428    91.693     0.200
     3.856   106.183     0.200
     3.997   106.983     0.200
     4.415   122.053     0.200
     4.558   117.083     0.200
     4.893   134.413     0.200
     5.269   135.533     0.200
     5.588   146.293     0.200
     5.695   152.453     0.200
     5.616   149.783     0.200
     5.984   163.413     0.200
     6.276   160.853     0.200
     6.433   167.543     0.200
     6.700   177.453     0.200
     7.028   181.013     0.200
     7.017   184.243     0.200
     7.360   196.673     0.200
     7.616   197.503     0.200
     7.745   206.243     0.200
     8.441   215.187     0.200
     1.325    37.801     0.200
     1.609    43.451     0.200
     1.750    45.181     0.200
     1.796    51.621     0.200
     2.358    63.981     0.200
     2.429    63.241     0.200
     2.681    75.521     0.200
     2.811    77.811     0.200
     2.896    79.161     0.200
     2.793    75.341     0.200
     3.249    89.541     0.200
     3.271    89.181     0.200
     3.351    89.551     0.200
     3.467    90.701     0.200
     3.728    97.731     0.200
     3.740   100.631     0.200
     3.648    97.691     0.200
     3.784   105.391     0.200
     3.862   105.551     0.200
     4.411   116.701     0.200
     4.518   124.681     0.200
     4.537   123.291     0.200
     1.665    47.078     0.200
     1.952    56.086     0.200
     2.214    60.207     0.200
     2.381    65.266     0.200
     2.988    78.707     0.200
     3.550    93.426     0.200
     3.584    97.777     0.200
     3.769   102.555     0.200
     3.864   105.957     0.200
     3.963   109.828     0.200
     3.955   105.047     0.200
     3.952   107.848     0.200
     4.000   102.477     0.200
     4.114   108.797     0.200
     4.083   108.426     0.200
     4.105   109.066     0.200
     4.146   112.965     0.200
     4.429   118.418     0.200
     4.432   119.887     0.200
     4.410   122.008     0.200
     4.457   121.996     0.200
     4.578   125.578     0.200
     4.623   124.195     0.200
     4.771   131.055     0.200
     4.866   131.047     0.200
     0.307    15.047     0.200
     0.975    29.766     0.200
     1.094    33.535     0.200
     1.164    34.398     0.200
     1.178    35.477     0.200
     1.207    38.168     0.200
     1.237    36.488     0.200
     1.266    37.926     0.200
     1.364    39.105     0.200
     1.360    40.668     0.200
     1.493    44.078     0.200
     1.708    46.445     0.200
     1.636    47.695     0.200
     1.808    52.227     0.200
     2.116    58.086     0.200
     2.174    59.496     0.200
     2.312    64.855     0.200
     2.570    67.695     0.200
     2.838    79.566     0.200
     2.979    77.668     0.200
     2.970    80.547     0.200
     3.368    91.336     0.200
     3.377    91.188     0.200
     3.593   100.977     0.200
     3.665   100.496     0.200
     3.777   103.336     0.200
     3.802    97.508     0.200
     1.261    39.598     0.200
     0.581    23.602     0.200
     0.656    25.571     0.200
     0.868    29.752     0.200
     1.184    34.611     0.200
     1.358    38.682     0.200
     1.268    38.941     0.200
     1.448    42.312     0.200
     1.461    42.651     0.200
     1.472    43.701     0.200
     1.477    43.222     0.200
     1.565    43.712     0.200
     1.549    45.052     0.200
     1.678    47.151     0.200
     1.800    50.521     0.200
     1.856    49.392     0.200
     1.830    48.481     0.200
     2.135    59.531     0.200
     2.442    64.621     0.200
     2.521    68.321     0.200
     2.597    70.041     0.200
     2.592    70.991     0.200
     2.993    78.852     0.200
     2.966    79.481     0.200
     2.974    79.602     0.200
     3.182    85.651     0.200
     7.168   182.190     0.200
     1.554    46.892     0.200
     1.754    50.465     0.200
     2.735    76.125     0.200
     3.019    80.165     0.200
     3.433    93.065     0.200
     3.582    96.465     0.200
     3.542    96.265     0.200
     1.639    50.016     0.200
     2.239    66.547     0.200
     2.429    71.078     0.200
     2.712    77.453     0.200
     2.839    82.406     0.200
     3.085    87.297     0.200
     3.026    86.094     0.200
     3.159    89.992     0.200
     3.159    89.094     0.200
     3.254    92.094     0.200
     3.243    91.648     0.200
     3.307    95.023     0.200
     3.714   103.953     0.200
     4.324   119.125     0.200
     4.411   121.352     0.200
     5.016   140.016     0.200
     5.215   142.906     0.200
     5.400   143.578     0.200
     1.168    39.271     0.200
     1.300    41.871     0.200
     1.326    43.881     0.200
     1.774    51.601     0.200
     2.006    57.910     0.200
     2.125    60.170     0.200
     2.292    60.690     0.200
     2.429    67.091     0.200
     2.531    70.480     0.200
     2.804    80.581     0.200
     3.035    80.361     0.200
     3.198    90.680     0.200
     3.316    93.670     0.200
     3.325    94.081     0.200
     3.562    96.920     0.200
     3.577   101.051     0.200
     3.673   104.301     0.200
     3.949   110.460     0.200
     4.134   109.641     0.200
     4.080   111.010     0.200
     4.138   115.391     0.200
     4.188   116.420     0.200
     4.338   116.900     0.200
     4.373   114.740     0.200
     4.361   122.680     0.200
     4.670   122.031     0.200
     4.992   125.641     0.200
     5.147   128.950     0.200
     5.156   136.220     0.200
     2.414    65.382     0.200
     3.021    81.252     0.200
     3.523    94.292     0.200
     3.582    94.062     0.200
     3.982   110.662     0.200
     4.147   106.452     0.200
     4.389   122.162     0.200
     4.418   121.702     0.200
     4.427   119.782     0.200
     4.833   130.842     0.200
     0.539    21.301     0.200
     0.760    26.441     0.200
     0.854    28.730     0.200
     0.902    30.801     0.200
     0.912    30.641     0.200
     0.923    31.242     0.200
     0.949    31.301     0.200
     0.989    32.023     0.200
     1.013    32.551     0.200
     1.056    34.301     0.200
     1.131    35.500     0.200
     1.188    36.043     0.200
     1.281    40.410     0.200
     1.341    40.980     0.200
     1.693    45.293     0.200
     1.811    48.582     0.200
     1.869    50.082     0.200
     2.045    54.172     0.200
     2.101    54.973     0.200
     2.388    61.410     0.200
     2.521    65.441     0.200
     2.589    71.441     0.200
     2.867    76.281     0.200
     3.126    81.262     0.200
     3.297    84.250     0.200
     3.268    84.652     0.200
     3.342    87.312     0.200
     3.367    87.793     0.200
     3.358    94.652     0.200
     3.496    96.363     0.200
     3.608    98.402     0.200
     3.646    95.473     0.200
     3.758    99.230     0.200
     4.152   111.242     0.200
     4.182   117.094     0.200
     4.184   115.281     0.200
     4.219   106.492     0.200
     4.405   110.852     0.200
     4.447   113.223     0.200
     4.727   119.211     0.200
     5.050   126.711     0.200
     5.230   127.480     0.200
     5.224   134.871     0.200
     5.388   139.172     0.200
     5.553   142.281     0.200
     6.247   156.160     0.200
     0.986    33.922     0.200
     1.168    38.607     0.200
     1.190    40.547     0.200
     1.236    42.107     0.200
     1.278    42.067     0.200
     1.240    42.507     0.200
     1.383    46.498     0.200
     3.043    86.178     0.200
     1.272    43.578     0.200
     2.667    72.363     0.200
     8.892   228.512     0.200
     1.006    32.938     0.200
     1.646    48.703     0.200
     1.959    54.883     0.200
     2.699    74.602     0.200
     3.015    82.305     0.200
     3.355    91.227     0.200
     3.351    91.922     0.200
     3.695    99.938     0.200
     3.722   100.617     0.200
     3.954   106.547     0.200
     4.105   110.742     0.200
     4.122   111.656     0.200
     4.441   119.312     0.200
     4.469   119.492     0.200
     4.564   121.602     0.200
     5.042   133.188     0.200
     5.189   137.484     0.200
     5.247   139.172     0.200
     5.484   144.992     0.200
     5.807   153.227     0.200
     6.011   159.047     0.200
     6.049   159.281     0.200
     3.271    92.293     0.200
     1.025    32.508     0.200
     1.896    54.508     0.200
     2.022    53.055     0.200
     2.078    55.906     0.200
     1.560    45.609     0.200
     1.931    54.289     0.200
     2.733    73.211     0.200
     3.066    83.086     0.200
     3.337    86.969     0.200
     2.917    78.508     0.200
     3.018    84.375     0.200
     3.766   103.539     0.200
     3.856   106.820     0.200
     3.872   104.008     0.200
     3.874   107.859     0.200
     3.905   105.602     0.200
     3.933   107.828     0.200
     4.019   109.688     0.200
     4.126   115.141     0.200
     3.954   108.961     0.200
     4.234   117.125     0.200
     4.241   115.656     0.200
     4.250   115.711     0.200
     4.301   113.805     0.200
     4.309   119.477     0.200
     4.315   115.414     0.200
     4.322   117.125     0.200
     4.322   117.617     0.200
     4.322   118.539     0.200
     4.330   116.391     0.200
     4.360   113.539     0.200
     4.406   116.938     0.200
     4.437   121.391     0.200
     4.456   118.867     0.200
     4.466   115.617     0.200
     4.505   118.109     0.200
     4.737   126.680     0.200
     4.766   126.430     0.200
     4.802   126.180     0.200
     4.786   127.258     0.200
     4.814   126.914     0.200
     4.685   126.508     0.200
     4.684   119.008     0.200
     4.945   135.070     0.200
     4.749   123.914     0.200
     5.013   135.758     0.200
     5.180   134.688     0.200
     5.055   129.680     0.200
     5.498   140.984     0.200
     5.488   142.055     0.200
     5.603   143.789     0.200
     1.271    42.645     0.200
     1.435    46.062     0.200
     2.127    64.324     0.200
     1.138    37.743     0.200
     1.160    39.213     0.200
     1.224    40.043     0.200
     1.524    43.884     0.200
     1.718    50.634     0.200
     2.128    60.773     0.200
     2.142    60.094     0.200
     3.002    84.573     0.200
     3.227    88.884     0.200
     3.862   107.913     0.200
     0.211    12.375     0.200
     0.969    28.734     0.200
     1.000    31.045     0.200
     1.072    32.955     0.200
     1.103    32.715     0.200
     1.107    33.645     0.200
     1.118    34.215     0.200
     1.160    36.064     0.200
     1.231    36.105     0.200
     1.274    38.414     0.200
     1.407    41.926     0.200
     1.443    41.404     0.200
     1.539    45.715     0.200
     1.602    46.805     0.200
     1.873    48.744     0.200
     2.536    65.795     0.200
     2.516    70.244     0.200
     2.733    72.004     0.200
     2.854    79.385     0.200
     3.145    82.404     0.200
     0.235    14.113     0.200
     0.752    24.344     0.200
     0.883    28.105     0.200
     0.911    29.695     0.200
     0.994    31.453     0.200
     1.013    31.793     0.200
     1.032    33.473     0.200
     1.040    33.062     0.200
     1.082    34.164     0.200
     1.247    35.184     0.200
     1.205    36.953     0.200
     1.277    38.195     0.200
     1.338    40.414     0.200
     1.466    40.734     0.200
     1.464    44.176     0.200
     1.615    46.883     0.200
     1.968    56.434     0.200
     2.630    68.055     0.200
     2.814    75.152     0.200
     3.240    88.965     0.200
     3.548    95.652     0.200
     3.607    99.535     0.200
     1.130    33.875     0.200
     1.220    36.273     0.200
     1.420    41.500     0.200
     1.627    47.047     0.200
     1.740    49.758     0.200
     1.824    48.766     0.200
     2.403    67.516     0.200
     2.668    73.469     0.200
     2.891    77.969     0.200
     3.406    89.969     0.200
     3.557    95.805     0.200
     3.562    96.336     0.200
     3.626    96.695     0.200
     3.705   100.320     0.200
     3.714   101.367     0.200
     3.806   103.266     0.200
     3.854   103.977     0.200
     4.041   109.484     0.200
     4.051   109.484     0.200
     4.132   110.797     0.200
     4.144   107.977     0.200
     4.177   109.898     0.200
     4.223   113.367     0.200
     4.227   112.367     0.200
     4.252   113.711     0.200
     4.281   116.555     0.200
     4.294   115.250     0.200
     4.333   115.547     0.200
     4.310   114.297     0.200
     4.324   114.938     0.200
     4.324   115.539     0.200
     4.331   115.180     0.200
     4.351   116.211     0.200
     4.388   116.156     0.200
     4.406   117.820     0.200
     4.412   117.820     0.200
     4.464   120.094     0.200
     4.486   119.180     0.200
     4.518   119.805     0.200
     4.542   122.711     0.200
     4.548   117.594     0.200
     4.698   125.016     0.200
     4.716   123.984     0.200
     4.834   129.094     0.200
     4.866   129.094     0.200
     5.121   133.344     0.200
     5.244   136.656     0.200
     5.528   143.516     0.200
     8.731   225.359     0.200
     1.309    41.766     0.200
     2.576    71.500     0.200
     2.804    78.828     0.200
     3.173    90.945     0.200
     3.666   104.477     0.200
     2.526    71.263     0.200
     2.799    74.492     0.200
     3.335    92.143     0.200
     3.809   106.062     0.200
     4.251   110.893     0.200
     4.346   117.133     0.200
     4.632   118.103     0.200
     4.687   123.803     0.200
     4.746   131.322     0.200
     4.949   135.223     0.200
     5.052   138.543     0.200
     0.074    17.848     0.200
     0.121    18.625     0.200
     0.139    18.215     0.200
     0.205    18.875     0.200
     0.330    20.887     0.200
     0.334    19.234     0.200
     0.354    21.395     0.200
     0.386    21.727     0.200
     0.387    21.727     0.200
     0.532    23.098     0.200
     0.591    24.438     0.200
     0.697    27.145     0.200
     0.755    27.098     0.200
     0.919    29.215     0.200
     0.993    30.676     0.200
     1.243    37.215     0.200
     1.292    40.145     0.200
     1.380    41.957     0.200
     1.563    47.945     0.200
     1.578    46.824     0.200
     1.611    47.766     0.200
     1.668    47.266     0.200
     1.894    54.816     0.200
     1.973    51.574     0.200
     2.038    58.047     0.200
     2.700    69.645     0.200
     2.761    74.438     0.200
     3.366    88.574     0.200
     3.957    98.438     0.200
    10.085   261.297     0.200
     0.592    24.547     0.200
     0.692    26.188     0.200
     0.901    32.035     0.200
     1.111    33.746     0.200
     1.381    39.805     0.200
     1.398    41.555     0.200
     1.334    41.016     0.200
     1.395    42.387     0.200
     1.421    43.367     0.200
     1.442    43.875     0.200
     1.451    40.984     0.200
     1.467    44.727     0.200
     1.498    43.984     0.200
     1.619    46.395     0.200
     1.682    48.566     0.200
     1.895    53.676     0.200
     1.981    53.836     0.200
     2.334    64.297     0.200
     2.376    63.375     0.200
     2.561    69.066     0.200
     2.659    73.316     0.200
     2.714    72.215     0.200
     2.918    81.426     0.200
     3.041    80.516     0.200
     3.047    80.824     0.200
     3.611    93.355     0.200
     3.726    96.125     0.200
     3.787    99.246     0.200
     4.030   104.938     0.200
     4.353   112.074     0.200
     4.548   117.586     0.200
     4.607   116.156     0.200
     4.996   129.285     0.200
     5.617   140.664     0.200
     1.614    45.227     0.200
     2.483    67.000     0.200
     2.442    68.945     0.200
     2.657    75.109     0.200
     3.090    83.836     0.200
     3.499    93.820     0.200
     3.604    96.406     0.200
     3.653    96.625     0.200
     4.510   122.547     0.200
     0.204    24.018     0.200
     1.050    33.988     0.200
     1.060    35.369     0.200
     1.100    36.209     0.200
     1.113    36.219     0.200
     1.152    36.938     0.200
     1.152    37.598     0.200
     1.237    38.598     0.200
     1.321    40.869     0.200
     1.334    40.238     0.200
     1.252    42.328     0.200
     1.861    51.229     0.200
     2.139    55.979     0.200
     2.440    64.619     0.200
     2.827    78.898     0.200
     2.929    78.357     0.200
     3.005    77.619     0.200
     2.993    77.738     0.200
     3.456    92.438     0.200
     3.613    94.648     0.200
     3.645    97.879     0.200
     4.021   103.568     0.200
     4.055   103.588     0.200
     4.145   106.988     0.200
     1.052    37.512     0.200
     1.109    38.861     0.200
     1.359    45.012     0.200
     1.214    40.820     0.200
     2.153    64.240     0.200
     1.410    46.240     0.200
     2.697    78.611     0.200
     0.674    26.545     0.200
     0.720    27.685     0.200
     0.932    32.705     0.200
     1.247    36.235     0.200
     1.241    36.005     0.200
     1.259    39.875     0.200
     1.570    45.145     0.200
     1.564    46.015     0.200
     1.589    47.135     0.200
     1.593    46.885     0.200
     1.611    47.255     0.200
     1.635    48.125     0.200
     1.665    49.135     0.200
     1.742    47.275     0.200
     1.682    48.305     0.200
     1.737    49.335     0.200
     1.791    51.055     0.200
     1.847    51.985     0.200
     1.918    54.825     0.200
     2.077    56.635     0.200
     2.175    59.555     0.200
     2.304    63.815     0.200
     2.403    64.695     0.200
     2.487    68.405     0.200
     2.493    68.085     0.200
     2.446    67.105     0.200
     2.491    69.405     0.200
     2.561    69.115     0.200
     2.538    71.095     0.200
     2.547    69.955     0.200
     2.647    74.005     0.200
     2.753    77.275     0.200
     2.771    74.665     0.200
     2.814    76.675     0.200
     2.799    77.475     0.200
     2.875    76.935     0.200
     2.829    78.725     0.200
     2.833    76.125     0.200
     2.843    75.635     0.200
     2.843    78.055     0.200
     2.844    76.905     0.200
     2.844    79.015     0.200
     2.854    79.015     0.200
     2.886    77.975     0.200
     2.927    80.455     0.200
     2.955    81.635     0.200
     2.970    83.845     0.200
     3.039    79.435     0.200
     3.084    83.945     0.200
     3.285    89.485     0.200
     3.261    90.345     0.200
     3.263    88.595     0.200
     3.315    86.825     0.200
     3.318    89.375     0.200
     3.309    90.735     0.200
     3.327    91.575     0.200
     3.445    89.375     0.200
     3.399    92.015     0.200
     3.399    93.235     0.200
     3.502    93.355     0.200
     3.554    92.645     0.200
     3.615    94.525     0.200
     3.578   101.535     0.200
     3.620    96.645     0.200
     3.746   102.735     0.200
     3.859   100.885     0.200
     3.994   102.225     0.200
     3.960   108.845     0.200
     4.072   109.535     0.200
     4.182   106.935     0.200
     4.135   111.495     0.200
     4.376   114.745     0.200
     4.438   114.745     0.200
     4.513   118.695     0.200
     4.480   119.475     0.200
     4.510   121.465     0.200
     4.588   121.465     0.200
     4.559   119.475     0.200
     4.719   120.915     0.200
     4.828   125.595     0.200
     5.064   133.425     0.200
     5.143   135.795     0.200
     5.369   137.115     0.200
     5.447   137.115     0.200
     6.433   160.885     0.200
     6.640   172.855     0.200
     7.063   178.534     0.200
     7.063   179.095     0.200
    13.137   326.309     0.200
     0.476    17.492     0.200
     1.085    32.109     0.200
     1.115    32.859     0.200
     1.224    35.449     0.200
     1.266    36.973     0.200
     1.261    37.031     0.200
     1.266    37.840     0.200
     1.287    39.242     0.200
     1.294    39.293     0.200
     1.310    40.660     0.200
     1.334    40.930     0.200
     1.374    40.422     0.200
     1.376    39.570     0.200
     1.452    43.602     0.200
     1.444    41.332     0.200
     1.535    41.371     0.200
     1.576    45.230     0.200
     1.769    48.043     0.200
     1.729    49.141     0.200
     1.982    54.062     0.200
     2.050    53.383     0.200
     1.985    59.352     0.200
     2.196    57.871     0.200
     2.385    66.793     0.200
     2.346    61.781     0.200
     2.361    65.020     0.200
     2.442    63.723     0.200
     2.739    70.141     0.200
     2.741    73.320     0.200
     2.805    74.449     0.200
     2.980    77.621     0.200
     3.111    81.711     0.200
     3.184    89.531     0.200
     3.344    87.391     0.200
     3.623    95.750     0.200
     3.589    96.961     0.200
     3.915   101.301     0.200
     4.028   109.852     0.200
     4.064   107.770     0.200
     4.078   108.941     0.200
     4.115   111.930     0.200
     4.164   109.570     0.200
     4.183   108.250     0.200
     4.366   118.391     0.200
     4.402   117.391     0.200
     4.430   117.410     0.200
     4.516   116.332     0.200
     4.521   120.660     0.200
     4.837   123.793     0.200
     4.932   126.410     0.200
     4.977   126.660     0.200
     5.257   135.480     0.200
     5.288   136.340     0.200
     5.511   139.793     0.200
     1.123    39.098     0.200
     1.133    39.656     0.200
     2.345    67.227     0.200
     2.700    72.238     0.200
     2.998    83.738     0.200
     3.117    84.066     0.200
     3.656    98.195     0.200
     2.389    64.900     0.200
     2.366    66.330     0.200
     2.409    68.020     0.200
     2.399    67.150     0.200
     2.675    71.210     0.200
     2.743    73.000     0.200
     2.881    77.680     0.200
     2.984    79.870     0.200
     3.055    84.430     0.200
     3.049    85.220     0.200
     3.172    88.440     0.200
     3.157    85.590     0.200
     3.162    82.240     0.200
     3.222    85.460     0.200
     3.225    84.180     0.200
     3.261    91.020     0.200
     3.291    90.870     0.200
     3.300    87.580     0.200
     3.295    86.820     0.200
     3.311    88.930     0.200
     3.887   106.930     0.200
     4.220   112.800     0.200
     4.441   117.400     0.200
     4.761   127.160     0.200
     2.070    62.682     0.200
     2.346    68.001     0.200
     2.416    68.951     0.200
     2.901    84.461     0.200
     3.092    86.291     0.200
     3.191    90.432     0.200
     3.265    92.541     0.200
     3.256    92.731     0.200
     0.853    28.684     0.200
     0.912    28.922     0.200
     1.012    31.332     0.200
     1.145    36.863     0.200
     1.321    37.633     0.200
     1.423    40.484     0.200
     1.413    40.012     0.200
     1.574    44.895     0.200
     1.624    47.004     0.200
     1.738    48.875     0.200
     1.899    54.191     0.200
     1.892    53.344     0.200
     1.968    57.625     0.200
     1.996    57.473     0.200
     1.920    54.434     0.200
     2.133    60.062     0.200
     2.168    56.703     0.200
     2.183    59.281     0.200
     2.604    69.613     0.200
     3.033    82.715     0.200
     3.198    85.523     0.200
     3.301    86.875     0.200
     3.604    94.684     0.200
     3.654    99.363     0.200
     3.844   101.504     0.200
     3.844   106.812     0.200
     3.986   102.012     0.200
     4.303   110.074     0.200
     4.321   110.742     0.200
     4.406   107.594     0.200
     4.428   119.012     0.200
     4.701   121.992     0.200
     4.730   127.812     0.200
     4.728   125.102     0.200
     4.999   133.234     0.200
     0.298    13.639     0.200
     0.759    24.039     0.200
     0.882    27.099     0.200
     0.916    28.169     0.200
     0.957    29.929     0.200
     0.978    30.679     0.200
     0.981    30.399     0.200
     1.012    31.139     0.200
     1.022    30.909     0.200
     1.025    31.649     0.200
     1.067    33.149     0.200
     1.161    34.689     0.200
     1.176    36.549     0.200
     1.265    37.719     0.200
     1.310    39.429     0.200
     1.379    40.509     0.200
     1.531    44.129     0.200
     1.597    45.119     0.200
     1.920    52.429     0.200
     1.961    54.019     0.200
     2.153    59.749     0.200
     2.417    66.009     0.200
     2.581    66.979     0.200
     2.740    72.239     0.200
     2.765    74.499     0.200
     2.845    76.039     0.200
     3.189    82.509     0.200
     0.062    10.887     0.200
     0.883    26.906     0.200
     1.131    33.705     0.200
     1.136    33.875     0.200
     1.148    35.227     0.200
     1.149    34.746     0.200
     1.190    37.855     0.200
     1.193    36.586     0.200
     1.235    37.986     0.200
     1.414    40.766     0.200
     1.425    41.916     0.200
     1.504    44.375     0.200
     1.583    45.646     0.200
     1.627    45.605     0.200
     1.621    47.836     0.200
     1.784    50.307     0.200
     1.957    54.375     0.200
     2.404    66.855     0.200
     2.468    68.816     0.200
     2.618    68.346     0.200
     2.644    73.766     0.200
     2.872    78.746     0.200
     3.227    82.896     0.200
     3.590    97.445     0.200
     3.673   100.506     0.200
     4.112   111.846     0.200
     0.716    25.617     0.200
     0.780    26.156     0.200
     0.992    32.129     0.200
     1.174    34.777     0.200
     1.227    35.945     0.200
     1.336    41.086     0.200
     1.437    40.996     0.200
     1.539    44.336     0.200
     1.575    45.496     0.200
     1.577    45.379     0.200
     1.594    45.777     0.200
     7.103   179.965     0.200
    11.772   293.816     0.200
     1.238    35.023     0.200
     1.886    50.695     0.200
     1.787    49.684     0.200
     1.902    54.566     0.200
     2.012    56.496     0.200
     2.316    63.273     0.200
     2.490    67.164     0.200
     2.744    75.656     0.200
     2.810    78.105     0.200
     3.013    80.625     0.200
     3.585    95.254     0.200
     3.500    97.125     0.200
     1.506    42.043     0.200
     1.896    51.332     0.200
     1.902    53.852     0.200
     2.118    59.102     0.200
     2.529    66.703     0.200
     2.711    76.730     0.200
     2.798    76.141     0.200
     2.893    79.801     0.200
     3.232    89.762     0.200
     3.642   102.062     0.200
     3.809   107.363     0.200
     3.856   108.453     0.200
     4.387   119.082     0.200
     4.449   123.973     0.200
     4.752   131.863     0.200
     5.020   139.504     0.200
     5.406   141.594     0.200
     5.454   145.953     0.200
     0.692    23.162     0.200
     1.806    51.492     0.200
     3.656    96.742     0.200
     0.835    26.729     0.200
     2.079    58.758     0.200
     3.271    89.738     0.200
     3.878   102.100     0.200
     1.859    51.953     0.200
     2.518    66.992     0.200
     2.830    78.941     0.200
     0.906    27.039     0.200
     0.937    29.699     0.200
     1.196    34.520     0.200
     1.183    36.059     0.200
     1.442    42.219     0.200
     1.516    44.369     0.200
     1.544    45.070     0.200
     1.557    45.400     0.200
     1.554    45.660     0.200
     1.590    47.100     0.200
     1.627    47.740     0.200
     1.715    45.750     0.200
     1.690    48.600     0.200
     1.656    49.309     0.200
     1.841    49.570     0.200
     1.767    50.879     0.200
     1.823    48.250     0.200
     1.954    51.389     0.200
     1.938    54.809     0.200
     1.954    55.879     0.200
     2.369    61.859     0.200
     2.687    73.650     0.200
     2.638    71.859     0.200
     2.751    76.820     0.200
     3.038    82.439     0.200
     3.192    84.939     0.200
     0.362    15.914     0.200
     1.077    32.320     0.200
     1.194    34.859     0.200
     1.178    34.719     0.200
     1.231    37.227     0.200
     1.249    36.500     0.200
     1.273    37.961     0.200
     1.279    39.250     0.200
     1.301    36.875     0.200
     1.339    40.320     0.200
     1.320    40.727     0.200
     1.362    41.469     0.200
     1.448    43.273     0.200
     1.608    43.891     0.200
     1.581    46.484     0.200
     1.841    47.141     0.200
     1.727    50.078     0.200
     1.908    50.414     0.200
     2.118    53.820     0.200
     2.270    59.414     0.200
     2.275    60.367     0.200
     2.491    68.461     0.200
     2.814    72.094     0.200
     2.880    76.047     0.200
     3.067    85.297     0.200
     3.167    84.688     0.200
     3.212    86.359     0.200
     3.426    90.547     0.200
     3.648   103.523     0.200
     3.736   106.188     0.200
     4.262   109.734     0.200
     4.275   111.039     0.200
     4.424   123.211     0.200
     4.619   117.734     0.200
     4.939   124.188     0.200
     1.357    41.523     0.200
     0.964    31.383     0.200
     1.873    53.359     0.200
     2.403    66.742     0.200
     2.394    67.922     0.200
     2.590    74.430     0.200
     2.685    76.500     0.200
     2.729    77.680     0.200
     2.697    76.680     0.200
     2.830    78.648     0.200
     2.876    81.641     0.200
     2.813    80.523     0.200
     2.940    80.328     0.200
     3.083    86.352     0.200
     3.004    85.422     0.200
     3.264    90.945     0.200
     3.356    91.602     0.200
     3.258    92.398     0.200
     3.388    93.898     0.200
     3.883   105.625     0.200
     3.913   106.094     0.200
     3.992   107.789     0.200
     4.118   112.641     0.200
     4.138   112.516     0.200
     4.178   115.164     0.200
     4.454   116.219     0.200
     4.438   119.445     0.200
     4.419   122.469     0.200
     4.702   126.094     0.200
     4.653   127.742     0.200
     4.871   126.234     0.200
     5.027   134.984     0.200
     5.077   136.539     0.200
     5.097   137.766     0.200
     0.954    32.826     0.200
     2.189    61.816     0.200
     2.363    65.416     0.200
     2.475    69.126     0.200
     2.969    79.756     0.200
     2.867    81.096     0.200
     3.031    85.066     0.200
     3.218    87.726     0.200
     3.262    88.556     0.200
     3.497    92.756     0.200
     3.674    98.816     0.200
     4.069   107.666     0.200
     4.613   120.276     0.200
     1.099    36.117     0.200
     1.146    39.395     0.200
     1.260    40.516     0.200
     1.299    41.637     0.200
     1.323    43.906     0.200
     1.375    45.758     0.200
     1.390    46.055     0.200
     1.599    48.984     0.200
     2.348    68.227     0.200
     2.374    68.758     0.200
     2.583    75.125     0.200
     2.658    75.484     0.200
     2.815    81.957     0.200
     2.960    82.227     0.200
     2.932    84.574     0.200
     2.994    86.516     0.200
     2.975    80.477     0.200
     3.006    81.137     0.200
     3.036    87.777     0.200
     3.047    86.617     0.200
     3.084    81.137     0.200
     3.119    88.117     0.200
     3.092    88.258     0.200
     3.125    89.305     0.200
     3.192    90.625     0.200
     3.256    90.848     0.200
     3.231    91.234     0.200
     3.241    84.457     0.200
     3.191    92.297     0.200
     3.413    96.668     0.200
     3.439    97.188     0.200
     3.580   101.066     0.200
     3.598   101.766     0.200
     3.612   103.066     0.200
     3.667   103.117     0.200
     3.856   105.258     0.200
     3.816   104.395     0.200
     4.164   116.617     0.200
     4.221   114.234     0.200
     4.284   119.797     0.200
     4.210   117.688     0.200
     4.379   120.816     0.200
     4.553   126.316     0.200
     4.562   128.055     0.200
     4.698   128.137     0.200
     4.858   133.625     0.200
     4.906   134.367     0.200
     4.980   135.297     0.200
     5.172   138.957     0.200
     5.267   142.336     0.200
     5.279   140.938     0.200
     5.362   145.125     0.200
     5.941   159.926     0.200
     5.914   161.945     0.200
     6.157   164.316     0.200
     6.071   164.785     0.200
     7.108   185.387     0.200
     7.560   199.574     0.200
     3.483    93.260     0.200
     3.504    97.211     0.200
     3.758   101.930     0.200
     3.862   104.930     0.200
     3.941   109.621     0.200
     3.952   110.301     0.200
     3.953   109.641     0.200
     3.958   105.770     0.200
     3.958   105.131     0.200
     3.970   105.240     0.200
     3.979   105.551     0.200
     3.988   105.871     0.200
     3.996   111.480     0.200
     3.999   106.270     0.200
     4.038   108.109     0.200
     4.142   110.150     0.200
     4.216   111.330     0.200
     4.357   116.580     0.200
     4.359   116.490     0.200
     4.432   118.230     0.200
     4.434   119.080     0.200
     4.522   126.801     0.200
     4.619   122.270     0.200
     4.936   129.570     0.200
     8.131   208.535     0.200
     8.117   205.117     0.200
     8.155   203.363     0.200
     2.360    62.789     0.200
     3.643    98.098     0.200
     4.065   108.859     0.200
     4.084   106.539     0.200
     4.102   106.910     0.200
     4.113   109.398     0.200
     4.154   110.840     0.200
     4.161   110.461     0.200
     4.263   114.000     0.200
     4.339   116.098     0.200
     4.358   114.980     0.200
     4.404   113.621     0.200
     4.497   117.879     0.200
     4.548   117.168     0.200
     4.671   120.340     0.200
     4.730   121.680     0.200
     5.023   130.379     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     3.250    95.152     0.200
     5.642   162.152     0.200
     1.421    44.389     0.200
     4.039   118.389     0.200
     4.111   118.719     0.200
     4.121   120.719     0.200
     6.883   193.719     0.200
     3.605   104.092     0.200
     3.019    87.396     0.200
     0.085     8.258     0.200
     1.880    55.258     0.200
     6.234   178.258     0.200
     1.310    35.836     0.200
     1.401    44.215     0.200
     4.094   120.494     0.200
     2.441    70.388     0.200
     3.331    95.688     0.200
     1.895    56.093     0.200
     2.961    86.393     0.200
     3.465    98.693     0.200
     1.252    40.727     0.200
     2.448    70.500     0.200
     1.961    58.484     0.200
     3.581   100.086     0.200
     1.451    43.625     0.200
     3.415    96.055     0.200
     3.459    97.664     0.200
     3.558   101.016     0.200
     3.833   107.227     0.200
     1.359    41.939     0.200
     1.468    44.020     0.200
     2.365    70.479     0.200
     2.462    70.789     0.200
     3.490   100.619     0.200
     1.198    37.555     0.200
     1.148    35.250     0.200
     1.094    34.027     0.200
     1.975    61.047     0.200
     2.451    70.637     0.200
     2.050    61.062     0.200
     2.503    72.094     0.200
     3.452   101.344     0.200
     1.219    38.172     0.200
     3.269    94.211     0.200
     3.383    96.539     0.200
     1.136    35.043     0.200
     1.283    39.062     0.200
     3.710   105.422     0.200
     4.029   113.642     0.200
     1.143    33.836     0.200
     1.545    47.484     0.200
     1.846    55.984     0.200
     2.034    61.754     0.200
     3.054    88.215     0.200
     3.830   108.387     0.200
     4.266   122.855     0.200
     1.222    38.582     0.200
     1.287    39.629     0.200
     2.998    84.871     0.200
     3.333    93.891     0.200
     3.333    95.199     0.200
     1.745    52.246     0.200
     2.048    61.116     0.200
     1.070    32.838     0.200
     1.869    55.338     0.200
     1.961    60.648     0.200
     2.027    61.078     0.200
     3.261    94.127     0.200
     3.783   107.139     0.200
     3.783   107.469     0.200
     0.929    29.875     0.200
     3.408    98.445     0.200
     0.559    20.438     0.200
     0.820    26.008     0.200
     1.991    60.727     0.200
     3.642   102.727     0.200
     1.287    40.469     0.200
     3.824   107.781     0.200
     1.983    57.719     0.200
     1.279    40.292     0.200
     2.311    68.843     0.200
     3.969   116.982     0.200
     4.697   131.272     0.200
     2.486    73.305     0.200
     4.485   126.719     0.200
     1.266    38.742     0.200
     3.953   110.859     0.200
     4.382   123.531     0.200
     0.226    10.816     0.200
     3.991   113.525     0.200
     4.354   123.455     0.200
     4.382   123.564     0.200
     4.719   134.115     0.200
     4.786   134.814     0.200
     4.821   136.516     0.200
     5.183   146.484     0.200
     0.489    17.023     0.200
     3.235    95.133     0.200
     3.713   110.746     0.200
     3.735   109.566     0.200
     5.953   174.555     0.200
     0.837    27.422     0.200
     1.174    37.531     0.200
     4.601   133.281     0.200
     4.700   135.180     0.200
     0.961    31.137     0.200
     1.149    36.918     0.200
     1.626    53.676     0.200
     2.949    88.555     0.200
     3.581   103.906     0.200
     0.753    24.230     0.200
     1.167    36.172     0.200
     1.038    32.363     0.200
     1.843    56.852     0.200
     2.532    72.984     0.200
     3.130    92.543     0.200
     3.142    90.715     0.200
     3.186    92.953     0.200
     3.596   102.215     0.200
     3.635   103.875     0.200
     4.670   133.484     0.200
     0.483    17.352     0.200
     1.515    45.789     0.200
     1.573    49.703     0.200
     2.252    70.539     0.200
     3.080    90.484     0.200
     0.434    16.166     0.200
     4.358   124.566     0.200
     0.452    15.320     0.200
     2.455    75.680     0.200
     3.052    87.883     0.200
     7.728   223.844     0.200
     0.211     8.988     0.200
     1.819    53.578     0.200
     4.817   141.090     0.200
     6.629   196.279     0.200
     0.942    29.594     0.200
     4.355   122.844     0.200
     4.526   125.945     0.200
     4.583   135.078     0.200
     1.404    42.166     0.200
     1.502    45.096     0.200
     0.794    25.261     0.200
     1.368    42.691     0.200
     1.818    56.001     0.200
     2.061    61.851     0.200
     0.081     6.133     0.200
     1.241    39.512     0.200
     0.756    24.837     0.200
     0.756    24.547     0.200
     1.272    38.467     0.200
     1.272    39.888     0.200
     1.888    57.938     0.200
     1.999    60.638     0.200
     2.122    63.527     0.200
     2.931    84.027     0.200
     2.931    84.907     0.200
     3.339    94.318     0.200
     3.533   100.857     0.200
     0.950    30.344     0.200
     0.966    31.145     0.200
     1.038    33.910     0.200
     1.218    40.461     0.200
     1.245    38.988     0.200
     1.609    48.180     0.200
     1.989    60.828     0.200
     3.171    94.059     0.200
     3.236    94.289     0.200
     0.089     6.421     0.200
     0.954    30.901     0.200
     1.563    49.021     0.200
     1.733    53.391     0.200
     3.246    92.601     0.200
     3.640   106.571     0.200
     3.735   107.791     0.200
     3.826   112.181     0.200
     4.169   122.221     0.200
     4.283   125.311     0.200
     4.626   130.801     0.200
     6.413   181.431     0.200
     6.502   190.171     0.200
     6.795   191.941     0.200
     7.571   216.931     0.200
     0.282     9.004     0.200
     3.930   116.266     0.200
     0.559    18.344     0.200
     0.559    18.617     0.200
     0.655    21.898     0.200
     0.655    22.047     0.200
     0.730    23.570     0.200
     0.957    30.797     0.200
     2.205    66.727     0.200
     2.294    68.594     0.200
     3.685   109.000     0.200
     4.308   125.492     0.200
     4.317   124.812     0.200
     4.317   125.469     0.200
     4.360   123.781     0.200
     4.653   137.367     0.200
     5.010   143.680     0.200
     5.323   154.727     0.200
     6.337   185.258     0.200
     6.819   198.820     0.200
     7.286   218.109     0.200
     0.612    20.770     0.200
     1.396    42.066     0.200
     1.435    42.988     0.200
     1.549    46.379     0.200
     1.585    47.859     0.200
     1.587    48.277     0.200
     1.602    49.160     0.200
     3.076    88.449     0.200
     3.113    88.668     0.200
     3.267    94.879     0.200
     3.487   101.609     0.200
     3.556   101.828     0.200
     4.001   111.930     0.200
     0.908    28.250     0.200
     1.342    42.273     0.200
     1.422    43.051     0.200
     1.394    43.570     0.200
     1.495    44.934     0.200
     1.535    47.121     0.200
     1.529    47.641     0.200
     1.530    48.750     0.200
     1.545    48.672     0.200
     2.051    60.922     0.200
     3.166    93.312     0.200
     3.180    91.672     0.200
     3.250    96.121     0.200
     3.421    98.320     0.200
     3.556   105.082     0.200
     0.108     7.268     0.200
     0.824    26.268     0.200
     0.901    29.539     0.200
     0.997    30.928     0.200
     1.597    50.148     0.200
     1.721    53.148     0.200
     2.020    63.068     0.200
     2.369    74.828     0.200
     2.915    84.139     0.200
     3.160    92.549     0.200
     3.670   105.588     0.200
     3.759   107.869     0.200
     3.712   110.488     0.200
     4.715   135.039     0.200
     0.081     6.785     0.200
     0.876    27.605     0.200
     0.949    30.145     0.200
     1.214    39.055     0.200
     1.225    38.836     0.200
     1.257    38.965     0.200
     1.271    39.613     0.200
     1.558    48.715     0.200
     1.724    52.445     0.200
     1.976    58.285     0.200
     1.966    60.363     0.200
     3.173    91.316     0.200
     3.243    91.996     0.200
     3.635   105.754     0.200
     3.792   109.914     0.200
     4.072   114.227     0.200
     4.200   118.375     0.200
     4.369   123.996     0.200
     5.046   140.484     0.200
     5.390   150.855     0.200
     0.045     8.934     0.200
     0.904    29.195     0.200
     1.029    31.676     0.200
     1.157    36.773     0.200
     1.166    37.824     0.200
     1.195    37.727     0.200
     1.211    38.664     0.200
     3.661   103.164     0.200
     1.642    49.064     0.200
     1.789    53.486     0.200
     1.798    53.086     0.200
     1.799    53.895     0.200
     1.807    53.625     0.200
     1.835    54.945     0.200
     1.909    58.016     0.200
     2.274    69.426     0.200
     2.647    75.496     0.200
     2.767    80.195     0.200
     2.840    84.125     0.200
     2.841    84.445     0.200
     3.190    90.375     0.200
     3.253    92.096     0.200
     3.263    92.256     0.200
     3.393    98.715     0.200
     3.570   103.705     0.200
     3.817   110.686     0.200
     4.489   131.285     0.200
     4.410   124.506     0.200
     4.665   129.805     0.200
     4.997   139.506     0.200
     5.071   142.746     0.200
     0.636    20.298     0.200
     1.145    36.618     0.200
     1.512    46.817     0.200
     1.640    50.958     0.200
     1.643    50.107     0.200
     1.644    52.718     0.200
     1.651    50.128     0.200
     1.667    50.698     0.200
     1.674    53.098     0.200
     1.690    51.647     0.200
     1.722    54.248     0.200
     1.742    52.378     0.200
     2.655    76.678     0.200
     4.769   136.848     0.200
     0.875    29.951     0.200
     1.730    54.922     0.200
     2.091    63.191     0.200
     2.106    64.982     0.200
     2.094    65.441     0.200
     2.185    67.432     0.200
     3.312    98.672     0.200
     3.348    97.221     0.200
     3.406   100.791     0.200
     3.459   100.521     0.200
     3.502   101.812     0.200
     3.593   106.102     0.200
     3.698   106.502     0.200
     3.778   113.631     0.200
     3.787   113.451     0.200
     3.814   114.172     0.200
     3.828   112.691     0.200
     3.900   114.982     0.200
     3.921   115.852     0.200
     3.976   117.701     0.200
     4.052   118.441     0.200
     4.121   120.822     0.200
     4.266   121.971     0.200
     4.446   127.342     0.200
     4.691   138.301     0.200
     0.937    30.852     0.200
     1.101    35.078     0.200
     1.507    46.941     0.200
     1.627    50.781     0.200
     1.644    51.398     0.200
     1.630    52.039     0.200
     1.630    51.008     0.200
     1.660    51.789     0.200
     1.677    52.008     0.200
     1.741    52.988     0.200
     1.914    55.270     0.200
     4.168   116.551     0.200
     0.055     6.926     0.200
     0.958    30.066     0.200
     1.000    31.506     0.200
     1.120    34.057     0.200
     1.158    35.906     0.200
     1.262    38.877     0.200
     1.291    39.467     0.200
     1.686    50.217     0.200
     1.665    49.357     0.200
     3.020    87.688     0.200
     3.068    87.627     0.200
     3.532    99.447     0.200
     3.653   103.236     0.200
     3.683   106.707     0.200
     4.561   129.896     0.200
     4.794   133.598     0.200
     0.032     6.359     0.200
     1.200    36.609     0.200
     1.209    38.141     0.200
     1.237    40.461     0.200
     1.254    38.492     0.200
     1.258    39.980     0.200
     1.622    49.520     0.200
     2.378    72.621     0.200
     3.531    99.730     0.200
     3.652   105.641     0.200
     0.825    27.369     0.200
     0.849    28.310     0.200
     0.837    28.959     0.200
     0.847    28.149     0.200
     0.847    29.539     0.200
     0.858    28.439     0.200
     0.879    29.959     0.200
     0.992    32.379     0.200
     0.934    31.609     0.200
     1.485    45.850     0.200
     1.485    46.129     0.200
     1.655    51.060     0.200
     1.840    57.249     0.200
     2.505    75.959     0.200
     2.854    84.720     0.200
     2.949    88.169     0.200
     2.948    85.369     0.200
     3.176    92.020     0.200
     3.322    95.959     0.200
     3.418    98.359     0.200
     3.443   100.560     0.200
     3.590   103.220     0.200
     3.575   103.799     0.200
     3.797   108.669     0.200
     4.232   120.180     0.200
     0.075     6.591     0.200
     0.980    30.030     0.200
     1.266    41.661     0.200
     1.274    41.021     0.200
     1.429    44.631     0.200
     1.320    42.900     0.200
     1.324    42.631     0.200
     1.710    52.021     0.200
     2.053    62.301     0.200
     3.118    88.900     0.200
     3.580   102.431     0.200
     3.604   103.980     0.200
     3.640   105.820     0.200
     3.900   115.221     0.200
     4.057   114.641     0.200
     4.047   118.360     0.200
     4.918   138.480     0.200
     5.237   146.030     0.200
     0.062    10.195     0.200
     0.057    10.086     0.200
     0.070     9.926     0.200
     0.087    10.305     0.200
     0.103    10.227     0.200
     0.308    12.605     0.200
     0.241    11.305     0.200
     0.301    12.164     0.200
     0.676    21.555     0.200
     1.178    37.254     0.200
     1.139    34.816     0.200
     1.197    39.914     0.200
     1.223    41.254     0.200
     1.413    42.574     0.200
     1.539    47.016     0.200
     1.956    58.996     0.200
     2.726    78.727     0.200
     0.130     8.451     0.200
     1.034    32.440     0.200
     1.063    33.701     0.200
     1.222    39.190     0.200
     1.319    41.211     0.200
     1.310    42.081     0.200
     1.318    42.391     0.200
     1.345    43.570     0.200
     1.363    43.980     0.200
     1.367    43.801     0.200
     1.765    54.241     0.200
     2.757    78.501     0.200
     3.461   100.701     0.200
     3.563   104.801     0.200
     3.550   100.631     0.200
     3.624   103.341     0.200
     4.592   128.381     0.200
     0.787    25.719     0.200
     0.781    26.008     0.200
     1.357    42.938     0.200
     1.670    50.688     0.200
     1.802    54.883     0.200
     1.825    55.898     0.200
     1.866    56.750     0.200
     1.877    59.250     0.200
     2.209    65.688     0.200
     3.022    88.539     0.200
     3.103    92.047     0.200
     3.166    92.703     0.200
     3.335    95.180     0.200
     3.386    96.711     0.200
     3.481   101.977     0.200
     3.525   104.359     0.200
     3.555   104.258     0.200
     3.704   109.398     0.200
     4.108   118.508     0.200
     0.015     6.675     0.200
     1.118    34.064     0.200
     1.215    39.175     0.200
     1.224    39.905     0.200
     1.213    38.354     0.200
     1.254    40.685     0.200
     1.270    41.195     0.200
     1.273    41.185     0.200
     1.645    50.225     0.200
     2.542    73.274     0.200
     2.980    86.745     0.200
     0.078     7.443     0.200
     1.276    41.354     0.200
     1.285    41.465     0.200
     1.277    39.484     0.200
     1.314    41.453     0.200
     1.330    43.154     0.200
     1.442    43.594     0.200
     1.334    43.184     0.200
     1.858    57.703     0.200
     1.706    53.354     0.200
     2.063    61.264     0.200
     2.079    63.264     0.200
     3.125    91.914     0.200
     3.521   101.604     0.200
     3.620   104.854     0.200
     3.692   104.523     0.200
     3.686   105.805     0.200
     4.537   128.184     0.200
     4.562   128.264     0.200
     4.804   135.023     0.200
     0.124     4.721     0.200
     0.306     9.842     0.200
     0.409    13.781     0.200
     0.458    15.121     0.200
     0.587    20.262     0.200
     0.636    22.621     0.200
     0.647    23.012     0.200
     0.651    23.211     0.200
     0.815    27.141     0.200
     0.874    26.951     0.200
     1.236    37.641     0.200
     1.776    55.852     0.200
     2.106    64.541     0.200
     2.605    79.051     0.200
     2.646    79.990     0.200
     3.412    99.781     0.200
     4.012   116.391     0.200
     4.151   117.682     0.200
     4.166   120.891     0.200
     0.055     6.277     0.200
     0.851    26.908     0.200
     1.663    52.117     0.200
     1.581    49.377     0.200
     1.953    57.748     0.200
     2.298    70.697     0.200
     2.352    72.127     0.200
     2.869    85.107     0.200
     2.920    84.207     0.200
     3.610   104.527     0.200
     3.641   103.018     0.200
     3.654   105.338     0.200
     3.697   106.828     0.200
     3.754   110.428     0.200
     3.971   112.568     0.200
     4.114   117.047     0.200
     4.115   116.357     0.200
     4.139   118.678     0.200
     4.157   116.797     0.200
     4.162   117.158     0.200
     4.495   126.297     0.200
     4.781   133.396     0.200
     6.498   185.158     0.200
     6.498   186.877     0.200
     0.729    23.918     0.200
     0.814    26.898     0.200
     1.401    42.977     0.200
     1.566    49.176     0.200
     1.615    47.508     0.200
     1.745    52.059     0.200
     1.764    54.258     0.200
     1.766    55.977     0.200
     1.782    55.176     0.200
     1.807    54.086     0.200
     1.818    57.309     0.200
     3.070    90.566     0.200
     3.329    99.168     0.200
     3.438    99.496     0.200
     3.457    97.746     0.200
     3.689   104.836     0.200
     3.711   105.379     0.200
     3.760   105.836     0.200
     4.112   117.168     0.200
     1.082    34.883     0.200
     1.227    38.152     0.200
     1.238    41.253     0.200
     1.238    40.303     0.200
     1.276    42.053     0.200
     1.338    41.383     0.200
     1.882    55.683     0.200
     1.983    57.612     0.200
     2.343    69.643     0.200
     2.540    73.333     0.200
     3.136    90.532     0.200
     3.336    95.362     0.200
     5.167   143.833     0.200
     0.433    15.723     0.200
     0.671    23.343     0.200
     0.752    25.593     0.200
     0.806    27.753     0.200
     0.863    29.393     0.200
     0.865    29.733     0.200
     1.180    36.483     0.200
     1.550    48.503     0.200
     1.685    51.493     0.200
     1.885    55.743     0.200
     2.517    71.423     0.200
     3.032    86.813     0.200
     3.329    97.043     0.200
     3.651   104.183     0.200
     0.090     4.083     0.200
     0.534    18.683     0.200
     0.547    18.844     0.200
     0.726    25.144     0.200
     0.720    23.823     0.200
     0.747    26.124     0.200
     0.767    25.874     0.200
     0.782    26.904     0.200
     0.920    30.104     0.200
     1.091    34.294     0.200
     1.975    61.304     0.200
     2.033    61.744     0.200
     4.811   136.514     0.200
     4.965   139.644     0.200
     0.487    16.113     0.200
     1.483    45.414     0.200
     1.910    57.633     0.200
     1.878    56.514     0.200
     1.943    60.613     0.200
     1.944    60.703     0.200
     1.980    62.363     0.200
     1.994    61.953     0.200
     2.040    61.594     0.200
     1.982    60.264     0.200
     2.265    68.033     0.200
     2.720    79.523     0.200
     3.136    93.164     0.200
     3.224    94.074     0.200
     3.638   104.863     0.200
     3.638   105.623     0.200
     3.673   106.703     0.200
     3.673   106.895     0.200
     3.682   105.883     0.200
     3.723   106.434     0.200
     4.402   122.854     0.200
     0.635    21.078     0.200
     1.246    38.711     0.200
     1.788    54.953     0.200
     1.998    59.898     0.200
     2.971    86.367     0.200
     3.993   118.102     0.200
     4.170   119.719     0.200
     1.126    35.822     0.200
     1.514    46.092     0.200
     1.502    47.973     0.200
     1.532    49.422     0.200
     1.614    49.783     0.200
     1.765    55.053     0.200
     2.074    61.973     0.200
     3.723   106.662     0.200
     3.813   110.152     0.200
     0.121     7.145     0.200
     0.791    25.684     0.200
     1.607    49.855     0.200
     3.862   109.035     0.200
     4.026   114.277     0.200
     0.126     7.670     0.200
     0.829    26.971     0.200
     1.188    37.570     0.200
     1.246    39.490     0.200
     1.748    52.370     0.200
     2.344    71.130     0.200
     3.090    89.641     0.200
     3.744   104.900     0.200
     3.735   105.391     0.200
     3.740   105.450     0.200
     3.798   108.271     0.200
     4.200   117.500     0.200
     4.204   118.670     0.200
     4.222   119.710     0.200
     4.689   132.740     0.200
     4.863   139.460     0.200
     0.426    15.211     0.200
     0.659    22.516     0.200
     0.884    28.672     0.200
     1.014    31.898     0.200
     1.065    34.391     0.200
     1.074    34.727     0.200
     2.034    61.469     0.200
     3.475   101.000     0.200
     3.995   116.719     0.200
     4.438   130.086     0.200
     4.541   130.047     0.200
     4.635   131.641     0.200
     4.659   131.148     0.200
     4.659   133.836     0.200
     4.681   136.695     0.200
     4.832   138.898     0.200
     4.895   143.055     0.200
     5.220   149.211     0.200
     6.064   174.000     0.200
     6.272   176.961     0.200
     1.922    60.629     0.200
     1.957    59.840     0.200
     2.023    60.949     0.200
     2.794    79.473     0.200
     2.828    82.043     0.200
     3.049    90.332     0.200
     3.092    90.379     0.200
     3.162    91.910     0.200
     3.217    92.645     0.200
     3.241    93.965     0.200
     3.368    97.434     0.200
     3.409    98.168     0.200
     3.550   104.754     0.200
     3.609   101.355     0.200
     3.754   112.012     0.200
     4.712   133.379     0.200
     4.879   143.035     0.200
     1.015    32.219     0.200
     1.497    49.748     0.200
     2.133    64.629     0.200
     2.250    70.988     0.200
     4.347   124.088     0.200
     0.515    18.559     0.200
     0.559    19.869     0.200
     0.569    20.428     0.200
     0.613    19.988     0.200
     0.645    20.379     0.200
     0.733    24.520     0.200
     1.681    50.809     0.200
     0.743    24.297     0.200
     1.386    44.258     0.200
     1.813    55.680     0.200
     2.021    63.578     0.200
     2.024    60.453     0.200
     2.055    64.977     0.200
     2.071    64.008     0.200
     2.550    74.805     0.200
     2.809    80.180     0.200
     2.916    83.758     0.200
     3.004    85.594     0.200
     2.995    86.414     0.200
     3.093    88.289     0.200
     3.108    87.977     0.200
     3.332    94.312     0.200
     4.736   132.344     0.200
     0.439    15.965     0.200
     1.113    33.574     0.200
     1.207    37.744     0.200
     1.219    37.834     0.200
     1.249    39.533     0.200
     1.233    40.234     0.200
     3.216    91.863     0.200
     3.498   100.555     0.200
     4.097   117.574     0.200
     4.234   119.055     0.200
     0.250     8.482     0.200
     1.435    46.492     0.200
     1.659    51.982     0.200
     5.029   144.643     0.200
     5.234   148.822     0.200
     0.499    17.043     0.200
     1.137    35.113     0.200
     1.827    55.333     0.200
     1.906    56.003     0.200
     1.871    58.333     0.200
     1.872    57.923     0.200
     1.907    59.013     0.200
     1.922    60.793     0.200
     1.974    60.103     0.200
     1.914    58.983     0.200
     2.753    80.733     0.200
     2.716    77.863     0.200
     3.209    95.073     0.200
     0.260    10.648     0.200
     1.067    35.340     0.200
     1.214    39.430     0.200
     1.430    44.691     0.200
     1.591    49.621     0.200
     1.513    45.512     0.200
     1.662    51.391     0.200
     2.163    65.590     0.200
     2.184    65.672     0.200
     2.233    68.969     0.200
     2.861    81.691     0.200
     2.897    82.930     0.200
     3.099    87.980     0.200
     3.159    90.430     0.200
     3.515   100.289     0.200
     0.057     6.420     0.200
     1.625    50.209     0.200
     1.962    59.250     0.200
     2.272    68.658     0.200
     2.401    74.699     0.200
     2.865    82.600     0.200
     3.019    86.549     0.200
     3.071    90.920     0.200
     3.220    93.260     0.200
     4.083   117.648     0.200
     4.527   130.549     0.200
     0.052     6.043     0.200
     0.855    26.875     0.200
     1.664    51.086     0.200
     1.957    59.453     0.200
     4.564   130.246     0.200
     0.507    17.646     0.200
     1.393    42.428     0.200
     1.411    43.717     0.200
     1.515    45.658     0.200
     1.617    47.848     0.200
     1.549    47.377     0.200
     1.621    48.277     0.200
     1.615    49.088     0.200
     2.573    75.348     0.200
     2.834    82.807     0.200
     2.980    85.828     0.200
     3.047    87.168     0.200
     3.324    95.188     0.200
     3.524    99.908     0.200
     3.716   105.838     0.200
     3.729   105.178     0.200
     0.256     8.951     0.200
     1.656    53.191     0.200
     1.451    46.512     0.200
     1.502    48.230     0.200
     1.638    52.311     0.200
     2.114    65.531     0.200
     2.262    70.320     0.200
     2.558    78.920     0.200
     2.549    77.262     0.200
     2.857    86.881     0.200
     2.785    85.551     0.200
     3.056    92.371     0.200
     0.127     6.527     0.200
     1.885    56.316     0.200
     2.837    82.457     0.200
     3.134    92.008     0.200
     3.750   107.777     0.200
     0.122     7.999     0.200
     1.224    38.659     0.200
     1.320    41.369     0.200
     1.371    43.749     0.200
     1.412    42.289     0.200
     1.748    54.239     0.200
     1.823    55.309     0.200
     2.120    62.729     0.200
     3.072    87.249     0.200
     3.494   102.699     0.200
     3.588   102.499     0.200
     3.598   105.729     0.200
     3.651   108.269     0.200
     0.580    20.242     0.200
     1.346    41.344     0.200
     2.585    76.102     0.200
     3.008    88.422     0.200
     3.045    87.773     0.200
     3.061    89.023     0.200
     3.296    94.680     0.200
     3.503    98.398     0.200
     3.605   103.031     0.200
     3.679   103.969     0.200
     3.853   111.031     0.200
     3.974   112.617     0.200
     4.216   120.070     0.200
     0.071     7.535     0.200
     1.145    36.273     0.200
     1.237    38.805     0.200
     1.305    41.785     0.200
     1.640    50.691     0.200
     1.933    57.824     0.200
     2.452    72.262     0.200
     2.890    84.414     0.200
     3.598   105.062     0.200
     3.695   108.812     0.200
     3.761   112.004     0.200
     4.136   121.965     0.200
     4.326   128.273     0.200
     4.599   132.613     0.200
     4.639   134.562     0.200
     5.444   154.703     0.200
     5.739   163.992     0.200
     6.014   171.484     0.200
     6.449   182.262     0.200
     0.277    13.414     0.200
     0.874    28.645     0.200
     0.977    31.102     0.200
     0.999    31.645     0.200
     1.527    45.914     0.200
     1.893    56.242     0.200
     2.296    68.395     0.200
     2.334    70.191     0.200
     3.972   116.375     0.200
     0.245     8.359     0.200
     1.370    43.539     0.200
     1.454    46.719     0.200
     2.291    70.922     0.200
     2.459    74.391     0.200
     2.539    79.805     0.200
     2.568    78.609     0.200
     3.139    91.469     0.200
     3.121    93.195     0.200
     3.263    96.477     0.200
     3.536   102.977     0.200
     0.188     8.609     0.200
     1.329    42.789     0.200
     1.470    45.547     0.200
     1.552    47.719     0.200
     2.662    77.938     0.200
     2.947    84.699     0.200
     3.090    91.707     0.200
     3.104    89.047     0.200
     0.690    22.391     0.200
     1.731    54.719     0.200
     1.751    51.578     0.200
     2.901    82.211     0.200
     3.543    99.578     0.200
     1.291    39.102     0.200
     1.539    48.688     0.200
     1.437    47.562     0.200
     1.655    49.195     0.200
     1.889    56.883     0.200
     2.387    69.812     0.200
     2.644    77.367     0.200
     2.989    85.914     0.200
     2.974    84.734     0.200
     3.076    88.758     0.200
     3.475    99.406     0.200
     1.100    34.969     0.200
     1.123    36.141     0.200
     2.655    76.750     0.200
     2.881    81.633     0.200
     3.033    86.500     0.200
     3.450    97.320     0.200
     3.455    98.797     0.200
     3.514   103.562     0.200
     3.627   101.727     0.200
     3.583   102.188     0.200
     3.656   103.227     0.200
     0.195     7.016     0.200
     1.541    49.746     0.200
     1.502    48.586     0.200
     2.338    70.445     0.200
     2.835    86.457     0.200
     3.279    96.816     0.200
     0.183     7.027     0.200
     1.528    48.715     0.200
     1.501    49.078     0.200
     1.968    60.586     0.200
     2.336    72.715     0.200
     2.620    80.785     0.200
     0.969    31.322     0.200
     1.650    51.643     0.200
     1.611    50.014     0.200
     1.739    52.604     0.200
     2.427    71.764     0.200
     2.659    77.652     0.200
     2.927    84.883     0.200
     2.976    85.902     0.200
     3.114    88.162     0.200
     3.083    91.453     0.200
     3.112    88.854     0.200
     3.243    92.752     0.200
     3.304    93.434     0.200
     0.306    11.613     0.200
     0.306    10.723     0.200
     1.389    43.113     0.200
     1.488    45.492     0.200
     1.525    48.303     0.200
     1.671    50.482     0.200
     1.939    59.512     0.200
     2.382    72.242     0.200
     2.905    85.383     0.200
     3.249    92.812     0.200
     3.334    96.762     0.200
     3.470    99.934     0.200
     3.745   105.463     0.200
     3.926   115.992     0.200
     4.060   117.332     0.200
     4.360   122.732     0.200
     4.369   127.393     0.200
     0.699    22.195     0.200
     1.186    37.605     0.200
     1.071    35.078     0.200
     1.586    50.086     0.200
     1.618    50.488     0.200
     1.672    51.918     0.200
     1.698    51.055     0.200
     1.956    58.238     0.200
     2.731    81.086     0.200
     3.048    87.535     0.200
     0.854    27.104     0.200
     1.678    50.834     0.200
     1.785    54.544     0.200
     1.949    60.415     0.200
     2.033    61.865     0.200
     0.871    28.316     0.200
     1.120    34.036     0.200
     1.979    61.007     0.200
     2.692    77.316     0.200
     2.784    80.826     0.200
     2.802    83.036     0.200
     2.871    82.887     0.200
     2.873    83.707     0.200
     3.113    89.687     0.200
     3.247    94.337     0.200
     3.414    97.587     0.200
     3.440    97.076     0.200
     3.656   105.627     0.200
     3.673   102.977     0.200
     0.131     7.627     0.200
     1.204    38.487     0.200
     1.303    40.007     0.200
     1.345    43.067     0.200
     1.609    50.587     0.200
     1.784    54.567     0.200
     2.357    70.557     0.200
     2.383    74.347     0.200
     2.645    77.157     0.200
     3.065    87.937     0.200
     3.518   102.747     0.200
     3.544   104.077     0.200
     3.609   102.077     0.200
     3.837   109.387     0.200
     3.803   112.367     0.200
     3.985   111.737     0.200
     3.992   115.947     0.200
     4.068   118.687     0.200
     4.231   122.677     0.200
     4.436   124.387     0.200
     0.053     5.648     0.200
     1.585    48.055     0.200
     1.673    50.930     0.200
     1.957    58.141     0.200
     2.486    72.727     0.200
     2.448    71.781     0.200
     2.929    83.578     0.200
     0.086     6.895     0.200
     1.136    34.895     0.200
     1.587    48.852     0.200
     1.834    55.152     0.200
     2.346    70.035     0.200
     2.346    71.930     0.200
     3.565   100.832     0.200
     3.995   113.512     0.200
     3.997   118.699     0.200
     3.997   114.172     0.200
     4.001   112.125     0.200
     4.013   112.723     0.200
     4.042   115.062     0.200
     4.227   122.055     0.200
     4.458   126.734     0.200
     4.459   126.734     0.200
     4.503   128.922     0.200
     4.503   134.383     0.200
     4.521   130.941     0.200
     4.527   127.914     0.200
     4.880   136.234     0.200
     0.503    17.117     0.200
     0.751    24.555     0.200
     0.884    30.008     0.200
     0.945    30.984     0.200
     0.945    29.984     0.200
     1.172    37.133     0.200
     2.159    66.055     0.200
     2.416    73.672     0.200
     2.675    84.172     0.200
     3.330    95.906     0.200
     4.471   127.008     0.200
     4.511   127.445     0.200
     4.513   133.312     0.200
     4.526   132.047     0.200
     4.535   132.305     0.200
     4.544   136.289     0.200
     5.111   144.805     0.200
     0.192     8.938     0.200
     1.282    39.317     0.200
     1.380    41.497     0.200
     1.657    50.317     0.200
     2.198    66.487     0.200
     0.243     9.625     0.200
     1.324    41.535     0.200
     1.423    43.675     0.200
     1.645    51.055     0.200
     1.879    57.854     0.200
     0.090     6.902     0.200
     1.180    37.122     0.200
     1.560    48.143     0.200
     1.869    55.843     0.200
     2.524    72.542     0.200
     3.017    85.593     0.200
     0.200     9.404     0.200
     1.364    41.934     0.200
     1.717    51.533     0.200
     2.677    78.834     0.200
     3.123    92.193     0.200
     3.483   100.904     0.200
     3.476    98.074     0.200
     3.510   101.395     0.200
     3.926   110.033     0.200
     3.926   110.693     0.200
     3.932   112.684     0.200
     3.936   116.014     0.200
     3.936   116.674     0.200
     3.961   114.684     0.200
     3.967   116.674     0.200
     3.985   116.674     0.200
     4.058   116.674     0.200
     4.080   117.334     0.200
     4.123   118.664     0.200
     4.253   121.324     0.200
     4.253   122.654     0.200
     4.421   124.244     0.200
     4.428   126.943     0.200
     5.225   147.635     0.200
     6.137   172.824     0.200
     6.151   177.125     0.200
     6.126   180.465     0.200
     6.230   177.504     0.200
     7.166   201.754     0.200
     7.126   205.674     0.200
     7.509   221.764     0.200
     0.838    27.545     0.200
     0.987    31.734     0.200
     1.066    33.783     0.200
     1.834    55.744     0.200
     2.196    66.594     0.200
     2.629    76.604     0.200
     4.768   139.805     0.200
     1.316    41.445     0.200
     1.416    44.145     0.200
     1.605    51.215     0.200
     1.889    56.586     0.200
     2.329    70.637     0.200
     2.763    80.066     0.200
     3.091    91.414     0.200
     4.742   133.547     0.200
     1.129    34.387     0.200
     1.501    44.988     0.200
     2.087    62.848     0.200
     3.224    91.887     0.200
     1.162    37.203     0.200
     1.263    38.508     0.200
     1.563    48.047     0.200
     1.746    53.398     0.200
     3.032    86.633     0.200
     4.505   125.750     0.200
     1.755    54.363     0.200
     1.621    50.123     0.200
     1.797    55.113     0.200
     3.061    89.143     0.200
     3.558   106.333     0.200
     3.852   113.643     0.200
     3.980   118.293     0.200
     3.992   116.963     0.200
     4.439   126.273     0.200
     4.445   125.604     0.200
     4.451   127.593     0.200
     1.348    42.578     0.200
     1.450    45.078     0.200
     1.609    50.258     0.200
     2.325    69.607     0.200
     2.797    82.018     0.200
     2.902    84.158     0.200
     3.098    90.646     0.200
     3.206    92.508     0.200
     3.435    99.217     0.200
     3.513   100.547     0.200
     3.879   113.918     0.200
     3.887   111.848     0.200
     3.896   116.168     0.200
     3.898   112.396     0.200
     3.890   112.137     0.200
     3.906   113.828     0.200
     3.924   111.178     0.200
     3.982   114.508     0.200
     4.328   124.807     0.200
     4.759   134.768     0.200
     6.136   173.207     0.200
     1.152    36.598     0.200
     1.513    46.660     0.200
     1.608    50.289     0.200
     2.297    68.918     0.200
     2.231    67.258     0.200
     2.554    77.199     0.200
     3.161    92.000     0.200
     3.360    98.859     0.200
     3.355    99.961     0.200
     3.439    99.961     0.200
     3.806   110.898     0.200
     3.820   111.621     0.200
     3.840   110.891     0.200
     3.846   111.219     0.200
     3.855   113.910     0.200
     3.938   111.879     0.200
     4.226   121.219     0.200
     4.245   121.879     0.200
     4.252   120.551     0.200
     4.255   121.219     0.200
     4.259   123.211     0.200
     4.265   123.629     0.200
     4.314   124.918     0.200
     0.977    32.805     0.200
     1.496    47.941     0.200
     1.752    54.684     0.200
     1.772    53.754     0.200
     2.122    64.754     0.200
     2.593    79.625     0.200
     2.992    87.742     0.200
     3.479   102.012     0.200
     4.326   125.031     0.200
     4.358   125.031     0.200
     0.782    25.766     0.200
     0.927    30.164     0.200
     1.001    32.906     0.200
     1.298    37.984     0.200
     1.670    52.359     0.200
     2.279    70.812     0.200
     2.259    67.945     0.200
     2.663    79.672     0.200
     3.200    92.625     0.200
     3.251    93.539     0.200
     4.396   124.953     0.200
     4.484   126.266     0.200
     4.484   134.062     0.200
     4.969   145.023     0.200
     0.095     7.684     0.200
     1.192    37.875     0.200
     1.288    39.715     0.200
     1.651    50.125     0.200
     1.730    53.105     0.200
     2.403    69.754     0.200
     4.029   113.113     0.200
     4.783   133.055     0.200
     0.046     6.812     0.200
     1.240    38.422     0.200
     1.682    50.191     0.200
     1.643    49.750     0.200
     2.574    74.953     0.200
     0.322    12.177     0.200
     0.624    20.887     0.200
     0.876    27.987     0.200
     1.365    41.087     0.200
     1.571    49.177     0.200
     2.213    66.188     0.200
     2.992    85.887     0.200
     3.423    99.467     0.200
     3.782   107.557     0.200
     4.194   118.297     0.200
     4.624   131.807     0.200
     0.356    14.375     0.200
     0.596    19.844     0.200
     1.492    45.773     0.200
     1.758    52.469     0.200
     2.123    64.430     0.200
     2.205    66.898     0.200
     2.302    70.953     0.200
     2.882    84.469     0.200
     3.725   108.312     0.200
     4.738   135.125     0.200
     5.553   155.703     0.200
     0.140     8.609     0.200
     1.610    49.969     0.200
     2.391    69.748     0.200
     3.041    86.918     0.200
     3.634   102.648     0.200
     3.708   106.418     0.200
     3.663   104.648     0.200
     3.733   105.369     0.200
     4.106   120.799     0.200
     4.533   127.258     0.200
     4.533   127.258     0.200
     4.566   127.889     0.200
     4.569   127.918     0.200
     4.571   128.770     0.200
     4.717   133.898     0.200
     0.101     8.574     0.200
     1.021    32.364     0.200
     1.278    39.904     0.200
     1.814    54.715     0.200
     1.736    51.084     0.200
     2.108    64.225     0.200
     0.503    17.970     0.200
     0.941    30.609     0.200
     1.100    34.949     0.200
     1.202    37.941     0.200
     1.502    48.172     0.200
     1.811    55.602     0.200
     4.429   125.852     0.200
     0.228    11.008     0.200
     1.051    33.418     0.200
     1.210    38.891     0.200
     1.313    40.551     0.200
     1.497    45.801     0.200
     1.828    54.570     0.200
     2.198    66.398     0.200
     2.237    66.320     0.200
     2.668    76.230     0.200
     3.063    91.188     0.200
     3.334    96.480     0.200
     3.424    97.219     0.200
     3.397    98.520     0.200
     3.422    98.520     0.200
     3.525   102.988     0.200
     3.490    99.180     0.200
     3.775   107.160     0.200
     3.731   108.891     0.200
     3.844   113.141     0.200
     3.861   112.141     0.200
     3.864   110.371     0.200
     3.901   113.141     0.200
     4.092   114.801     0.200
     4.046   115.801     0.200
     4.128   120.449     0.200
     4.181   120.449     0.200
     4.280   120.668     0.200
     4.301   121.551     0.200
     4.306   120.848     0.200
     4.309   120.320     0.200
     4.380   122.781     0.200
     4.338   121.641     0.200
     4.493   125.680     0.200
     4.742   133.410     0.200
     0.239    11.766     0.200
     1.137    36.453     0.200
     1.397    43.836     0.200
     1.427    45.766     0.200
     1.594    48.102     0.200
     2.744    78.227     0.200
     3.154    89.477     0.200
     4.349   122.531     0.200
     0.470    15.354     0.200
     1.023    33.213     0.200
     1.172    38.814     0.200
     1.641    54.324     0.200
     2.313    73.494     0.200
     2.368    74.084     0.200
     2.390    73.834     0.200
     1.503    46.520     0.200
     1.949    59.961     0.200
     3.211    92.930     0.200
     3.536   102.352     0.200
     3.604   103.992     0.200
     3.758   108.391     0.200
     4.031   113.582     0.200
     4.421   125.191     0.200
     4.617   128.789     0.200
     0.427    14.629     0.200
     1.682    54.387     0.200
     1.429    46.168     0.200
     2.126    66.148     0.200
     2.385    73.488     0.200
     2.379    71.617     0.200
     0.190     8.654     0.200
     1.014    32.114     0.200
     1.275    40.064     0.200
     1.299    40.975     0.200
     1.507    48.104     0.200
     2.629    75.654     0.200
     4.524   126.654     0.200
     0.243    11.432     0.200
     1.106    34.632     0.200
     1.264    40.542     0.200
     1.367    42.602     0.200
     1.390    44.732     0.200
     1.672    50.912     0.200
     1.539    46.482     0.200
     2.236    67.802     0.200
     2.270    68.812     0.200
     3.879   112.552     0.200
     3.789   106.222     0.200
     0.450    14.930     0.200
     1.036    35.380     0.200
     1.152    37.130     0.200
     1.180    38.280     0.200
     1.260    40.680     0.200
     1.650    52.710     0.200
     2.336    71.030     0.200
     2.369    72.950     0.200
     3.375   101.440     0.200
     0.483    15.030     0.200
     1.010    35.170     0.200
     1.137    37.030     0.200
     1.160    38.760     0.200
     1.238    40.850     0.200
     2.343    72.440     0.200
     2.301    74.110     0.200
     2.736    86.800     0.200
     3.178    98.170     0.200
     0.372    13.555     0.200
     1.099    36.992     0.200
     1.184    38.445     0.200
     1.313    42.336     0.200
     1.420    45.352     0.200
     2.062    63.633     0.200
     2.318    70.258     0.200
     2.430    74.547     0.200
     2.430    76.258     0.200
     3.341    96.414     0.200
     3.497   104.688     0.200
     3.648   105.875     0.200
     4.738   137.461     0.200
     0.438    14.235     0.200
     1.129    37.565     0.200
     1.245    42.096     0.200
     1.251    41.605     0.200
     2.360    74.275     0.200
     2.366    73.165     0.200
     2.438    74.565     0.200
     2.556    78.396     0.200
     2.704    83.045     0.200
     3.164    96.085     0.200
     3.339   100.716     0.200
     3.366   101.186     0.200
     3.385   100.655     0.200
     3.670   108.815     0.200
     3.694   108.165     0.200
     4.454   127.905     0.200
     5.038   144.105     0.200
     0.075     8.658     0.200
     0.977    31.307     0.200
     1.136    36.287     0.200
     1.235    38.857     0.200
     1.599    48.338     0.200
     2.575    75.787     0.200
     2.998    84.727     0.200
     4.728   134.107     0.200
     0.395    14.934     0.200
     1.293    41.074     0.200
     1.679    52.992     0.200
     3.358    96.145     0.200
     0.426    13.498     0.200
     1.173    38.008     0.200
     1.211    38.789     0.200
     1.637    53.270     0.200
     2.359    75.629     0.200
     2.392    73.578     0.200
     2.415    73.959     0.200
     0.166     8.469     0.200
     1.205    38.180     0.200
     2.558    73.551     0.200
     3.421    97.570     0.200
     3.500    99.309     0.200
     3.669   105.539     0.200
     3.936   110.789     0.200
     3.943   113.898     0.200
     0.890    27.164     0.200
     1.330    41.961     0.200
     1.742    52.539     0.200
     1.821    57.102     0.200
     1.997    58.961     0.200
     2.507    73.812     0.200
     2.698    77.453     0.200
     3.158    92.562     0.200
     3.547   102.633     0.200
     3.641   108.312     0.200
     3.746   107.562     0.200
     3.856   115.102     0.200
     1.836    54.059     0.200
     2.514    73.727     0.200
     2.930    84.137     0.200
     3.455   103.027     0.200
     3.559   100.379     0.200
     3.629   105.078     0.200
     3.725   106.355     0.200
     3.831   107.688     0.200
     3.891   111.668     0.200
     3.911   112.996     0.200
     3.923   109.777     0.200
     3.947   116.316     0.200
     3.947   117.648     0.200
     3.962   112.996     0.200
     3.965   113.918     0.200
     4.050   114.988     0.200
     4.107   114.988     0.200
     4.150   118.316     0.200
     4.185   120.309     0.200
     4.248   118.977     0.200
     4.387   122.777     0.200
     4.403   125.629     0.200
     4.598   131.059     0.200
     0.474    16.594     0.200
     1.106    36.477     0.200
     1.139    37.930     0.200
     1.221    39.664     0.200
     1.415    44.789     0.200
     1.705    54.227     0.200
     2.158    66.203     0.200
     2.334    71.422     0.200
     2.395    74.703     0.200
     2.430    73.430     0.200
     0.055     9.562     0.200
     0.919    29.732     0.200
     1.176    37.053     0.200
     1.897    57.562     0.200
     2.012    61.713     0.200
     2.814    80.453     0.200
     3.531   100.803     0.200
     3.567   105.004     0.200
     3.575   101.674     0.200
     3.615   103.053     0.200
     3.946   114.303     0.200
     4.009   113.633     0.200
     4.057   114.193     0.200
     0.374    11.751     0.200
     1.488    48.001     0.200
     2.124    64.691     0.200
     2.347    70.771     0.200
     2.468    74.901     0.200
     2.476    76.011     0.200
     2.411    74.851     0.200
     2.466    75.091     0.200
     2.441    73.691     0.200
     2.633    81.241     0.200
     2.854    86.891     0.200
     2.910    90.281     0.200
     3.269    97.351     0.200
     3.299    97.481     0.200
     4.203   122.601     0.200
     0.394    12.061     0.200
     1.150    35.931     0.200
     1.247    41.280     0.200
     2.392    72.521     0.200
     2.424    76.591     0.200
     2.451    74.721     0.200
     2.632    80.161     0.200
     3.464   101.741     0.200
     3.646   106.230     0.200
     3.693   107.341     0.200
     1.734    52.727     0.200
     1.876    56.789     0.200
     1.988    59.938     0.200
     2.501    72.891     0.200
     2.989    87.828     0.200
     3.102    89.352     0.200
     3.628   102.227     0.200
     0.290    13.707     0.200
     0.758    25.527     0.200
     0.915    30.447     0.200
     1.021    32.777     0.200
     1.027    33.908     0.200
     1.956    59.047     0.200
     2.382    71.557     0.200
     2.766    81.348     0.200
     3.560    99.807     0.200
     3.486    99.768     0.200
     4.236   121.727     0.200
     0.346    11.727     0.200
     1.094    36.336     0.200
     1.094    34.328     0.200
     1.150    38.266     0.200
     1.403    44.098     0.200
     2.336    70.738     0.200
     2.507    76.219     0.200
     2.983    86.516     0.200
     3.228    92.945     0.200
     0.364    12.391     0.200
     1.120    36.559     0.200
     1.120    35.441     0.200
     1.376    42.910     0.200
     1.540    47.820     0.200
     2.423    73.461     0.200
     2.481    75.000     0.200
     3.024    87.820     0.200
     3.302    95.148     0.200
     3.634   103.719     0.200
     0.362    12.461     0.200
     1.116    36.461     0.200
     1.277    41.277     0.200
     1.303    41.551     0.200
     1.535    49.000     0.200
     2.351    71.398     0.200
     2.427    73.699     0.200
     2.485    76.551     0.200
     2.873    88.508     0.200
     3.593   104.578     0.200
     3.665   106.617     0.200
     0.358    12.146     0.200
     1.528    48.906     0.200
     1.581    49.467     0.200
     2.174    65.496     0.200
     2.821    82.016     0.200
     3.156    90.775     0.200
     3.250    94.416     0.200
     0.721    23.656     0.200
     1.245    38.883     0.200
     1.385    42.516     0.200
     1.385    43.602     0.200
     1.412    44.609     0.200
     1.496    44.953     0.200
     1.756    53.453     0.200
     2.521    74.102     0.200
     2.892    85.430     0.200
     2.852    83.039     0.200
     2.951    84.430     0.200
     3.140    91.156     0.200
     3.835   109.156     0.200
     0.414    13.471     0.200
     1.041    35.561     0.200
     1.207    38.371     0.200
     1.173    38.602     0.200
     1.205    39.691     0.200
     1.286    42.342     0.200
     1.462    46.412     0.200
     1.650    52.412     0.200
     2.373    73.182     0.200
     2.398    72.711     0.200
     2.434    76.432     0.200
     1.437    45.453     0.200
     1.501    45.984     0.200
     1.722    53.609     0.200
     1.762    53.414     0.200
     2.854    81.578     0.200
     2.975    84.094     0.200
     3.128    89.383     0.200
     3.468    98.242     0.200
     0.477    15.768     0.200
     0.972    33.139     0.200
     1.099    36.559     0.200
     1.133    37.697     0.200
     1.215    39.658     0.200
     1.279    40.607     0.200
     1.403    44.607     0.200
     2.319    71.697     0.200
     2.329    70.787     0.200
     2.470    76.277     0.200
     3.260    97.828     0.200
     3.374   100.438     0.200
     4.259   124.338     0.200
     4.495   128.479     0.200
     0.179     8.760     0.200
     1.115    35.090     0.200
     1.273    39.130     0.200
     1.365    42.060     0.200
     1.431    44.310     0.200
     1.857    56.480     0.200
     2.681    79.190     0.200
     3.118    89.370     0.200
     3.133    92.920     0.200
     3.246    92.230     0.200
     3.548   103.580     0.200
     3.661   103.190     0.200
     4.130   117.230     0.200
     4.909   138.050     0.200
     0.199     7.645     0.200
     1.065    33.074     0.200
     1.452    47.695     0.200
     1.816    54.793     0.200
     2.071    62.266     0.200
     2.219    67.055     0.200
     3.418    97.984     0.200
     0.170     8.488     0.200
     0.268    10.889     0.200
     1.440    44.658     0.200
     1.777    55.769     0.200
     0.135     6.842     0.200
     0.926    30.043     0.200
     1.517    48.252     0.200
     3.549   102.633     0.200
     0.465    15.531     0.200
     0.983    33.131     0.200
     1.107    36.451     0.200
     2.063    65.021     0.200
     2.477    76.840     0.200
     2.411    73.781     0.200
     4.257   124.271     0.200
     0.658    21.406     0.200
     0.793    26.367     0.200
     1.035    33.203     0.200
     1.011    32.836     0.200
     1.812    55.852     0.200
     2.382    71.703     0.200
     3.277    95.016     0.200
     3.288    98.766     0.200
     3.519   103.094     0.200
     3.667   106.656     0.200
     4.058   116.594     0.200
     4.089   117.086     0.200
     4.089   116.836     0.200
     0.473    16.062     0.200
     1.138    36.875     0.200
     1.653    52.395     0.200
     2.401    72.285     0.200
     3.311    99.383     0.200
     1.261    38.578     0.200
     1.411    42.977     0.200
     1.499    46.953     0.200
     1.523    46.664     0.200
     2.094    64.773     0.200
     2.370    71.305     0.200
     2.887    82.477     0.200
     0.782    25.043     0.200
     1.367    43.703     0.200
     1.723    52.801     0.200
     1.848    56.902     0.200
     1.810    56.031     0.200
     2.876    84.602     0.200
     3.030    88.012     0.200
     3.619   105.363     0.200
     3.736   106.023     0.200
     0.323    11.573     0.200
     1.484    49.153     0.200
     1.854    59.643     0.200
     2.473    76.573     0.200
     2.731    83.053     0.200
     3.154    93.393     0.200
     3.226    94.943     0.200
     3.947   115.903     0.200
     4.206   126.573     0.200
     4.330   130.243     0.200
     4.397   130.633     0.200
     4.403   129.723     0.200
     4.441   133.363     0.200
     4.722   142.053     0.200
     0.880    28.401     0.200
     1.137    37.891     0.200
     1.249    39.161     0.200
     1.540    47.701     0.200
     1.647    52.041     0.200
     1.674    52.841     0.200
     1.689    53.141     0.200
     1.721    53.911     0.200
     1.796    55.091     0.200
     1.822    55.151     0.200
     1.973    57.771     0.200
     1.921    58.701     0.200
     2.875    82.461     0.200
     2.889    83.201     0.200
     3.074    86.791     0.200
     3.156    88.971     0.200
     3.687   107.191     0.200
     3.886   110.681     0.200
     4.130   119.031     0.200
     4.315   122.451     0.200
     0.205     9.535     0.200
     1.126    36.305     0.200
     1.384    43.398     0.200
     1.372    43.945     0.200
     1.409    45.637     0.200
     1.418    45.836     0.200
     1.441    45.227     0.200
     1.460    46.457     0.200
     1.579    49.535     0.200
     1.635    50.777     0.200
     1.712    52.438     0.200
     1.842    55.707     0.200
     2.213    66.848     0.200
     2.367    70.777     0.200
     2.694    79.246     0.200
     2.726    80.508     0.200
     3.146    93.156     0.200
     3.501    98.578     0.200
     3.538   100.758     0.200
     3.607   102.156     0.200
     3.663   109.227     0.200
     3.893   110.738     0.200
     3.965   112.695     0.200
     4.049   113.777     0.200
     4.455   126.836     0.200
     0.190     9.865     0.200
     1.127    35.896     0.200
     1.361    43.875     0.200
     1.384    43.595     0.200
     1.381    44.915     0.200
     1.419    46.205     0.200
     1.468    46.885     0.200
     1.480    45.765     0.200
     1.676    51.285     0.200
     1.725    53.055     0.200
     1.821    56.335     0.200
     1.851    56.575     0.200
     1.852    56.055     0.200
     2.719    77.815     0.200
     3.148    89.686     0.200
     3.961   115.775     0.200
     1.460    46.525     0.200
     0.330    13.086     0.200
     0.333     9.883     0.200
     0.399    12.305     0.200
     1.037    33.602     0.200
     1.098    35.852     0.200
     1.121    36.352     0.200
     1.140    37.922     0.200
     1.147    38.484     0.200
     1.110    36.719     0.200
     1.206    38.812     0.200
     1.308    41.727     0.200
     2.285    69.648     0.200
     2.493    79.008     0.200
     2.602    81.078     0.200
     0.485    16.180     0.200
     0.857    28.000     0.200
     0.957    31.081     0.200
     0.954    32.690     0.200
     0.986    31.881     0.200
     1.011    32.841     0.200
     1.059    34.621     0.200
     1.113    35.760     0.200
     1.099    36.170     0.200
     1.164    37.851     0.200
     1.453    46.410     0.200
     1.768    53.450     0.200
     1.944    61.311     0.200
     2.476    75.710     0.200
     2.622    78.510     0.200
     2.964    85.631     0.200
     3.224    95.111     0.200
     3.277    94.061     0.200
     3.363    97.791     0.200
     3.473   101.321     0.200
     3.487   102.250     0.200
     3.597   106.990     0.200
     3.722   108.321     0.200
     3.753   108.321     0.200
     3.778   108.571     0.200
     3.785   108.000     0.200
     3.857   114.160     0.200
     4.152   118.141     0.200
     4.130   121.470     0.200
     4.289   123.031     0.200
     1.096    36.160     0.200
     0.168     8.992     0.200
     1.089    34.772     0.200
     1.223    38.642     0.200
     1.347    42.032     0.200
     1.338    42.812     0.200
     1.375    42.112     0.200
     1.383    43.842     0.200
     1.425    45.042     0.200
     1.431    44.962     0.200
     1.628    50.732     0.200
     1.679    50.862     0.200
     1.754    53.582     0.200
     1.804    55.172     0.200
     1.808    55.632     0.200
     1.803    56.532     0.200
     2.688    76.362     0.200
     2.717    78.412     0.200
     3.118    91.812     0.200
     3.420    96.352     0.200
     1.418    44.772     0.200
     0.227     7.777     0.200
     0.969    32.078     0.200
     1.094    36.618     0.200
     1.231    39.417     0.200
     1.442    47.658     0.200
     1.516    49.478     0.200
     1.750    54.167     0.200
     1.768    54.178     0.200
     1.612    52.667     0.200
     2.137    64.328     0.200
     2.197    66.938     0.200
     2.349    73.018     0.200
     2.589    79.438     0.200
     2.637    79.737     0.200
     0.751    24.902     0.200
     0.753    24.871     0.200
     0.884    28.793     0.200
     0.947    30.023     0.200
     2.540    77.363     0.200
     0.070     4.625     0.200
     0.195     6.961     0.200
     0.304    12.555     0.200
     0.328    13.406     0.200
     0.361    13.805     0.200
     0.672    22.703     0.200
     0.935    29.781     0.200
     1.362    41.547     0.200
     1.592    48.977     0.200
     0.288     9.551     0.200
     0.862    28.711     0.200
     0.909    31.773     0.200
     0.931    30.504     0.200
     0.940    31.730     0.200
     0.966    34.480     0.200
     0.980    32.934     0.200
     1.061    35.184     0.200
     1.090    36.441     0.200
     1.112    35.832     0.200
     1.125    37.922     0.200
     1.208    40.594     0.200
     1.392    44.762     0.200
     2.046    64.441     0.200
     2.146    66.012     0.200
     2.317    72.812     0.200
     2.323    72.512     0.200
     2.883    88.594     0.200
     0.992    34.391     0.200
     0.251    10.211     0.200
     1.169    37.547     0.200
     1.177    36.586     0.200
     1.322    43.008     0.200
     1.258    38.945     0.200
     1.368    41.617     0.200
     1.362    45.398     0.200
     1.403    44.664     0.200
     1.683    51.234     0.200
     1.580    47.719     0.200
     1.691    51.750     0.200
     2.053    61.930     0.200
     2.532    72.609     0.200
     3.874   109.820     0.200
     3.948   111.500     0.200
     3.933   113.055     0.200
     4.436   124.117     0.200
     4.564   129.484     0.200
     1.392    44.289     0.200
     0.242     8.922     0.200
     0.423    13.672     0.200
     0.454    15.414     0.200
     0.971    34.652     0.200
     0.984    32.434     0.200
     1.028    35.594     0.200
     1.041    35.375     0.200
     1.124    37.383     0.200
     1.163    36.762     0.200
     1.224    39.562     0.200
     1.153    38.023     0.200
     1.170    37.492     0.200
     1.371    44.145     0.200
     1.425    45.395     0.200
     2.108    65.504     0.200
     2.382    72.125     0.200
     2.385    73.715     0.200
     3.055    92.441     0.200
     3.257   100.473     0.200
     3.669   109.844     0.200
     0.877    28.104     0.200
     1.437    46.483     0.200
     1.691    52.304     0.200
     1.757    53.443     0.200
     1.864    57.094     0.200
     1.873    57.373     0.200
     1.909    57.543     0.200
     1.946    59.783     0.200
     2.007    59.983     0.200
     2.080    63.873     0.200
     2.253    68.493     0.200
     2.526    73.823     0.200
     2.655    76.733     0.200
     2.789    82.503     0.200
     2.739    79.203     0.200
     3.191    91.193     0.200
     3.357    95.903     0.200
     0.097     7.984     0.200
     0.042     8.789     0.200
     0.074     8.859     0.200
     0.214    10.945     0.200
     0.206    11.289     0.200
     0.197    10.539     0.200
     0.238    11.391     0.200
     0.260    12.656     0.200
     0.369    13.016     0.200
     0.452    16.641     0.200
     0.593    19.398     0.200
     1.142    35.016     0.200
     1.447    44.023     0.200
     1.366    43.117     0.200
     1.590    49.273     0.200
     1.945    56.695     0.200
     3.705   106.438     0.200
     0.820    27.156     0.200
     0.870    29.789     0.200
     1.010    33.070     0.200
     1.212    39.477     0.200
     1.392    44.555     0.200
     1.411    45.719     0.200
     1.421    45.984     0.200
     1.457    47.789     0.200
     1.494    48.211     0.200
     1.556    48.750     0.200
     1.638    51.438     0.200
     1.691    52.469     0.200
     1.668    53.367     0.200
     1.809    56.016     0.200
     2.339    71.430     0.200
     2.533    79.938     0.200
     2.856    85.594     0.200
     2.904    87.359     0.200
     3.093    92.586     0.200
     3.284    97.469     0.200
     3.411   101.000     0.200
     3.686   106.516     0.200
     3.716   108.320     0.200
     0.391    14.803     0.200
     1.276    39.763     0.200
     1.404    44.593     0.200
     1.435    44.032     0.200
     1.479    45.833     0.200
     1.419    45.902     0.200
     1.502    47.412     0.200
     1.538    46.623     0.200
     1.534    49.912     0.200
     1.548    47.772     0.200
     1.533    46.982     0.200
     1.595    48.992     0.200
     1.789    54.952     0.200
     1.825    56.603     0.200
     1.784    55.683     0.200
     2.026    62.192     0.200
     1.964    60.623     0.200
     2.890    82.772     0.200
     3.217    95.873     0.200
     3.288    97.772     0.200
     3.331    98.612     0.200
     3.925   117.152     0.200
     0.130     8.914     0.200
     1.074    34.312     0.200
     1.233    39.023     0.200
     1.328    42.211     0.200
     1.335    42.750     0.200
     1.336    42.305     0.200
     1.376    43.477     0.200
     1.381    44.047     0.200
     1.423    45.523     0.200
     1.494    45.555     0.200
     1.825    57.102     0.200
     1.686    51.953     0.200
     1.751    52.492     0.200
     1.808    54.500     0.200
     2.123    65.930     0.200
     2.542    72.375     0.200
     2.811    81.570     0.200
     3.077    86.773     0.200
     0.243     9.201     0.200
     0.364    12.000     0.200
     1.135    37.281     0.200
     1.539    48.830     0.200
     1.062    35.330     0.200
     1.087    36.910     0.200
     1.110    38.021     0.200
     1.251    41.111     0.200
     1.120    38.580     0.200
     1.217    40.041     0.200
     1.039    34.910     0.200
     1.238    40.441     0.200
     1.533    51.602     0.200
     2.467    75.711     0.200
     3.657   109.400     0.200
     0.249     9.828     0.200
     0.342    11.879     0.200
     0.357    11.906     0.200
     1.065    35.098     0.200
     1.076    33.578     0.200
     1.121    35.758     0.200
     1.101    36.996     0.200
     1.222    39.336     0.200
     1.249    40.516     0.200
     1.268    41.797     0.200
     1.374    44.629     0.200
     1.557    49.578     0.200
     1.527    49.938     0.200
     2.480    75.137     0.200
     0.092     8.771     0.200
     1.007    31.811     0.200
     1.167    36.891     0.200
     1.241    38.561     0.200
     1.265    38.991     0.200
     1.260    40.151     0.200
     1.298    41.811     0.200
     1.305    41.381     0.200
     1.347    42.771     0.200
     1.407    44.341     0.200
     1.541    45.961     0.200
     1.605    49.542     0.200
     1.611    49.101     0.200
     1.725    51.451     0.200
     1.731    52.751     0.200
     1.779    55.511     0.200
     2.365    70.531     0.200
     2.605    76.771     0.200
     3.035    87.101     0.200
     3.473    99.811     0.200
     3.567   102.451     0.200
     0.287    11.700     0.200
     0.395    15.600     0.200
     0.414    16.580     0.200
     0.938    30.290     0.200
     0.991    31.940     0.200
     1.046    33.020     0.200
     1.068    35.070     0.200
     1.078    34.090     0.200
     1.192    35.800     0.200
     1.219    37.390     0.200
     1.243    38.830     0.200
     1.321    41.950     0.200
     1.365    45.790     0.200
     1.537    45.960     0.200
     1.579    46.950     0.200
     2.159    65.420     0.200
     2.195    66.680     0.200
     2.473    71.880     0.200
     2.596    74.830     0.200
     2.657    77.710     0.200
     2.885    82.750     0.200
     2.932    84.130     0.200
     3.008    85.570     0.200
     3.089    89.160     0.200
     3.168    90.360     0.200
     3.490    98.310     0.200
     3.651   106.470     0.200
     3.684   103.130     0.200
     0.273    10.421     0.200
     0.461    15.401     0.200
     0.490    17.371     0.200
     0.932    31.781     0.200
     0.948    30.921     0.200
     0.964    32.041     0.200
     0.989    35.321     0.200
     1.003    33.432     0.200
     1.086    36.051     0.200
     1.116    36.801     0.200
     1.132    35.461     0.200
     1.233    41.001     0.200
     1.557    49.281     0.200
     0.847    28.586     0.200
     0.949    32.566     0.200
     1.230    39.887     0.200
     1.395    43.613     0.200
     1.478    47.504     0.200
     1.506    48.273     0.200
     1.518    48.125     0.200
     1.517    48.293     0.200
     1.552    49.664     0.200
     1.589    50.535     0.200
     1.645    50.766     0.200
     1.737    52.676     0.200
     1.907    58.113     0.200
     2.630    75.734     0.200
     2.997    85.004     0.200
     3.251    91.516     0.200
     1.590    50.137     0.200
     0.530    18.102     0.200
     0.990    30.754     0.200
     0.965    30.223     0.200
     1.223    37.574     0.200
     1.347    43.852     0.200
     1.644    49.844     0.200
     1.741    54.262     0.200
     1.788    56.574     0.200
     1.777    55.352     0.200
     1.788    55.273     0.200
     1.792    59.102     0.200
     1.854    62.602     0.200
     1.824    56.043     0.200
     1.862    58.102     0.200
     1.899    58.562     0.200
     2.021    61.402     0.200
     2.062    63.012     0.200
     2.258    69.133     0.200
     2.189    65.094     0.200
     2.770    80.852     0.200
     3.190    92.582     0.200
     3.214    91.672     0.200
     3.224    92.922     0.200
     3.233    94.402     0.200
     3.236    96.230     0.200
     3.260    93.414     0.200
     3.351    95.914     0.200
     3.552   100.812     0.200
     3.643   104.293     0.200
     3.793   108.672     0.200
     4.012   113.371     0.200
     4.331   124.973     0.200
     4.336   122.203     0.200
     1.862    57.953     0.200
     0.155     9.691     0.200
     0.260    12.262     0.200
     0.321    14.031     0.200
     0.389    14.721     0.200
     0.399    15.451     0.200
     0.392    15.441     0.200
     0.407    16.211     0.200
     0.409    16.322     0.200
     0.423    16.480     0.200
     0.422    14.822     0.200
     0.611    20.131     0.200
     0.640    20.471     0.200
     0.665    21.582     0.200
     0.969    30.291     0.200
     1.158    36.271     0.200
     1.289    38.980     0.200
     1.247    39.162     0.200
     1.473    45.881     0.200
     1.614    49.172     0.200
     1.697    51.730     0.200
     1.718    51.512     0.200
     2.403    69.891     0.200
     0.393    15.971     0.200
     0.188     9.939     0.200
     0.310    12.398     0.200
     0.322    12.479     0.200
     0.380    14.020     0.200
     0.515    17.719     0.200
     0.494    17.568     0.200
     0.507    18.068     0.200
     0.508    18.068     0.200
     0.537    18.879     0.200
     0.564    20.049     0.200
     0.572    20.129     0.200
     0.881    27.258     0.200
     0.930    29.998     0.200
     0.944    28.369     0.200
     1.281    39.189     0.200
     1.434    44.100     0.200
     1.697    51.918     0.200
     2.144    64.309     0.200
     2.187    64.979     0.200
     2.143    64.479     0.200
     2.613    76.379     0.200
     2.889    82.389     0.200
     3.342    96.758     0.200
     0.557    19.838     0.200
     0.108     8.281     0.200
     1.052    34.133     0.200
     1.300    40.863     0.200
     1.318    43.121     0.200
     1.317    42.312     0.200
     1.304    41.023     0.200
     1.359    43.191     0.200
     1.363    44.391     0.200
     1.505    45.152     0.200
     1.404    44.391     0.200
     1.338    44.820     0.200
     1.595    47.832     0.200
     1.671    51.910     0.200
     1.790    54.453     0.200
     1.718    51.230     0.200
     2.090    63.254     0.200
     2.629    75.320     0.200
     2.802    80.371     0.200
     1.396    44.480     0.200
     0.104     6.180     0.200
     0.691    23.180     0.200
     1.278    40.219     0.200
     1.305    41.602     0.200
     1.328    42.961     0.200
     1.334    43.500     0.200
     1.311    40.820     0.200
     1.417    44.922     0.200
     1.472    44.539     0.200
     1.490    46.461     0.200
     1.563    49.609     0.200
     1.682    52.266     0.200
     1.707    52.562     0.200
     1.814    56.570     0.200
     2.060    61.555     0.200
     2.009    62.141     0.200
     2.056    64.430     0.200
     2.263    67.766     0.200
     2.275    67.750     0.200
     2.643    76.484     0.200
     2.475    73.852     0.200
     2.663    77.039     0.200
     2.763    80.234     0.200
     2.757    79.859     0.200
     2.924    84.000     0.200
     3.126    89.703     0.200
     3.390    96.328     0.200
     3.415    98.398     0.200
     3.477   101.883     0.200
     1.363    42.602     0.200
     0.496    17.506     0.200
     0.923    28.706     0.200
     1.023    32.676     0.200
     1.049    34.136     0.200
     1.075    36.556     0.200
     1.096    36.026     0.200
     1.122    37.536     0.200
     1.162    37.116     0.200
     1.180    36.326     0.200
     1.358    42.426     0.200
     1.513    46.386     0.200
     1.831    53.316     0.200
     2.542    75.346     0.200
     1.160    38.126     0.200
     0.277     9.438     0.200
     1.088    35.195     0.200
     1.101    33.895     0.200
     1.125    37.496     0.200
     1.149    38.598     0.200
     1.400    43.887     0.200
     1.510    50.656     0.200
     1.751    57.637     0.200
     1.876    58.734     0.200
     2.238    69.785     0.200
     2.383    73.477     0.200
     2.394    72.168     0.200
     2.340    70.695     0.200
     2.435    77.797     0.200
     2.456    74.234     0.200
     3.023    94.906     0.200
     3.141    91.766     0.200
     3.231    93.637     0.200
     3.237    95.086     0.200
     4.098   117.688     0.200
     4.938   141.605     0.200
     1.168    38.984     0.200
     0.934    29.410     0.200
     1.031    32.211     0.200
     1.510    45.250     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     5.117   153.848     0.200
     4.180   124.594     0.200
    15.674   488.273     0.200
    21.975   693.273     0.200
     3.295    99.707     0.200
     3.216    98.396     0.200
    18.884   574.396     0.200
     3.378   104.711     0.200
     2.480    77.715     0.200
     4.163   127.494     0.200
     4.832   145.994     0.200
     4.012   120.021     0.200
     3.695   113.176     0.200
     2.790    86.031     0.200
     3.209   100.031     0.200
     2.926    92.350     0.200
     2.960    90.350     0.200
     3.405   105.850     0.200
    10.975   340.913     0.200
     2.124    61.223     0.200
     2.955    86.805     0.200
     2.239    65.562     0.200
     2.813    85.693     0.200
     3.877   126.093     0.200
     2.179    64.000     0.200
     3.026    91.336     0.200
     3.186    98.625     0.200
     2.017    57.975     0.200
     2.050    59.875     0.200
     2.362    68.656     0.200
    11.177   351.523     0.200
     3.623   112.238     0.200
     3.759   118.828     0.200
     3.904   119.430     0.200
     3.957   121.959     0.200
     4.179   131.979     0.200
     4.230   131.879     0.200
     4.230   132.719     0.200
     4.298   134.170     0.200
    11.289   349.902     0.200
     2.139    64.133     0.200
     2.767    82.062     0.200
    11.282   356.715     0.200
    11.257   358.996     0.200
    11.315   355.742     0.200
     2.127    61.594     0.200
    11.308   355.953     0.200
     2.091    60.266     0.200
    11.334   361.336     0.200
     2.210    63.462     0.200
     2.551    77.322     0.200
     3.426   105.962     0.200
    11.278   355.737     0.200
     2.100    61.125     0.200
     2.462    72.195     0.200
    11.203   352.723     0.200
     2.457    72.828     0.200
     2.828    84.438     0.200
    10.594   333.211     0.200
     3.257   101.297     0.200
     2.115    62.047     0.200
    11.447   360.891     0.200
     2.141    61.852     0.200
    11.150   346.938     0.200
    11.308   352.840     0.200
     2.057    59.594     0.200
     2.057    61.594     0.200
     3.849   116.723     0.200
    11.231   351.726     0.200
     2.486    75.445     0.200
     2.905    86.494     0.200
     2.905    90.145     0.200
     7.926   243.770     0.200
     8.922   267.260     0.200
    10.652   329.234     0.200
    16.373   507.936     0.200
    18.552   591.311     0.200
    23.271   744.010     0.200
    24.488   782.686     0.200
    31.385  1000.609     0.200
    32.216  1005.459     0.200
     2.226    65.836     0.200
     7.695   236.496     0.200
    11.242   354.383     0.200
     2.715    81.203     0.200
    10.456   336.219     0.200
     2.032    57.875     0.200
     2.032    59.875     0.200
     2.072    61.355     0.200
     3.594   102.996     0.200
     2.695    78.645     0.200
     2.148    62.191     0.200
    11.368   354.820     0.200
     7.476   225.906     0.200
    10.918   348.664     0.200
     7.118   209.945     0.200
    11.271   349.672     0.200
    17.203   550.074     0.200
    10.765   336.906     0.200
    16.598   513.859     0.200
     2.445    71.391     0.200
    11.261   351.695     0.200
    12.309   379.609     0.200
    17.129   538.492     0.200
     7.904   240.532     0.200
    10.903   342.590     0.200
     7.203   220.250     0.200
     3.038    87.814     0.200
     3.265    95.295     0.200
     7.019   218.559     0.200
    11.363   355.272     0.200
    24.315   771.703     0.200
    25.243   791.664     0.200
    32.253  1014.211     0.200
    45.110  1402.859     0.200
     3.856   115.520     0.200
     4.268   129.238     0.200
     8.707   265.438     0.200
    10.714   337.945     0.200
    13.340   415.398     0.200
    16.466   516.719     0.200
    24.151   761.742     0.200
    24.591   782.055     0.200
     7.466   227.406     0.200
     8.214   255.988     0.200
    11.042   343.797     0.200
    10.751   339.008     0.200
    13.463   422.289     0.200
     4.092   124.828     0.200
     4.768   147.766     0.200
     7.208   218.555     0.200
    11.361   352.891     0.200
     2.439    72.520     0.200
     2.877    85.770     0.200
     2.504    76.861     0.200
     2.901    88.441     0.200
     2.930    89.501     0.200
     3.181    98.091     0.200
     3.724   115.471     0.200
     3.771   118.351     0.200
     4.299   133.261     0.200
     4.405   137.561     0.200
     4.489   138.531     0.200
     7.879   245.511     0.200
     8.230   248.531     0.200
    11.032   345.761     0.200
    16.843   537.931     0.200
     9.160   276.633     0.200
    10.176   318.598     0.200
    15.874   507.084     0.200
     2.025    59.531     0.200
     3.326   102.062     0.200
     3.973   122.461     0.200
     2.267    65.859     0.200
     2.934    87.398     0.200
     7.548   231.910     0.200
    11.197   350.672     0.200
    12.157   381.539     0.200
     2.281    66.961     0.200
     8.261   257.898     0.200
    10.984   344.578     0.200
    16.792   533.348     0.200
     7.968   245.266     0.200
    10.798   337.398     0.200
    16.649   520.211     0.200
     2.410    75.074     0.200
     2.925    87.016     0.200
     2.900    87.625     0.200
     2.391    68.516     0.200
     8.157   257.984     0.200
    10.955   341.613     0.200
     2.838    82.801     0.200
     2.063    59.996     0.200
     2.515    75.455     0.200
     2.841    86.715     0.200
     3.305   104.586     0.200
    11.260   356.125     0.200
     2.111    61.914     0.200
     2.130    62.184     0.200
     2.910    86.533     0.200
     2.910    84.633     0.200
     7.944   244.898     0.200
     2.920    83.680     0.200
     2.709    80.422     0.200
     3.806   114.893     0.200
    10.786   335.006     0.200
     2.159    63.180     0.200
     2.058    59.176     0.200
    11.049   343.562     0.200
     2.029    58.270     0.200
     2.318    66.742     0.200
    10.993   342.547     0.200
    16.818   530.539     0.200
     2.528    74.754     0.200
     2.965    85.445     0.200
     3.283    94.152     0.200
     3.400    97.262     0.200
     2.118    61.659     0.200
     2.155    63.669     0.200
     2.703    80.369     0.200
     2.722    80.510     0.200
     2.854    87.189     0.200
     2.872    86.010     0.200
     2.948    88.589     0.200
    10.183   320.954     0.200
     2.082    61.221     0.200
     2.408    73.291     0.200
     2.604    78.161     0.200
     3.046    92.311     0.200
     3.036    91.471     0.200
     8.096   247.830     0.200
    11.056   345.061     0.200
     2.424    74.574     0.200
     2.434    72.541     0.200
     2.742    80.881     0.200
     2.874    82.197     0.200
     2.137    61.541     0.200
     2.394    72.631     0.200
     2.656    79.280     0.200
     2.414    71.672     0.200
     2.559    74.219     0.200
     2.785    83.672     0.200
    11.429   362.062     0.200
     2.412    72.758     0.200
     2.622    78.535     0.200
     2.017    59.045     0.200
     2.429    73.873     0.200
     2.815    84.604     0.200
     2.197    65.102     0.200
     8.202   257.652     0.200
    10.968   346.432     0.200
    16.784   536.576     0.200
     2.110    61.305     0.200
     2.991    87.219     0.200
     2.234    65.297     0.200
     2.178    63.527     0.200
     2.568    79.027     0.200
     7.477   235.250     0.200
    11.377   356.184     0.200
     2.000    56.938     0.200
     2.343    67.803     0.200
     3.017    93.243     0.200
     3.387   103.692     0.200
     2.446    74.193     0.200
     2.559    77.500     0.200
     2.801    80.660     0.200
     2.837    82.110     0.200
     2.893    84.010     0.200
     2.096    62.084     0.200
     2.150    61.484     0.200
     2.844    82.494     0.200
     2.906    82.744     0.200
     2.195    63.964     0.200
     2.805    84.924     0.200
     2.080    60.066     0.200
     2.890    85.148     0.200
     3.258    93.098     0.200
     2.139    62.203     0.200
     2.113    63.594     0.200
     2.593    74.305     0.200
     2.798    80.594     0.200
     2.632    78.693     0.200
     2.301    67.461     0.200
     2.353    68.453     0.200
     2.159    61.745     0.200
     3.201    91.645     0.200
     2.630    78.713     0.200
     2.969    90.623     0.200
     3.164    95.732     0.200
     3.259    99.232     0.200
     2.424    72.250     0.200
     2.464    71.289     0.200
     2.614    77.703     0.200
     3.102    90.188     0.200
     3.218    91.789     0.200
     3.249    92.938     0.200
     2.478    75.234     0.200
     2.390    74.050     0.200
     2.855    86.641     0.200
     8.276   260.685     0.200
    11.005   349.090     0.200
     2.853    85.219     0.200
     8.797   265.219     0.200
    10.777   338.422     0.200
    16.513   523.164     0.200
     2.914    87.629     0.200
     3.264    99.668     0.200
     3.265    99.418     0.200
     3.413   105.293     0.200
     3.518   105.184     0.200
     3.690   112.754     0.200
     2.669    79.598     0.200
     3.003    87.947     0.200
     2.084    61.148     0.200
     2.306    66.748     0.200
     2.754    82.930     0.200
     6.955   218.664     0.200
    11.344   360.852     0.200
    11.565   362.008     0.200
     2.576    74.570     0.200
     2.213    66.232     0.200
     2.599    77.482     0.200
     2.853    84.174     0.200
     2.913    84.982     0.200
     2.882    84.713     0.200
     2.204    64.053     0.200
     2.036    59.660     0.200
     2.482    76.922     0.200
     2.546    76.852     0.200
     9.890   312.602     0.200
     2.040    59.043     0.200
     2.148    63.562     0.200
    10.789   337.207     0.200
     2.909    89.139     0.200
     8.176   259.713     0.200
    10.944   349.656     0.200
     2.439    74.914     0.200
     2.893    87.586     0.200
     2.215    64.307     0.200
    12.277   375.473     0.200
     2.967    88.191     0.200
     3.243    95.771     0.200
     2.041    59.648     0.200
     2.422    71.348     0.200
     2.431    72.869     0.200
     2.792    83.969     0.200
     3.857   115.739     0.200
     2.556    78.703     0.200
     3.005    89.875     0.200
     3.174    95.352     0.200
     3.200    96.402     0.200
     2.176    63.406     0.200
     2.479    74.773     0.200
     3.403    97.305     0.200
     3.553   101.344     0.200
     3.898   123.156     0.200
     4.059   120.965     0.200
     4.095   125.055     0.200
     2.237    63.703     0.200
     8.149   249.047     0.200
    10.727   336.453     0.200
    16.557   514.523     0.200
     2.350    69.246     0.200
     2.226    65.891     0.200
     2.885    85.461     0.200
     2.389    71.449     0.200
    11.274   350.961     0.200
    17.168   529.469     0.200
     2.668    80.164     0.200
     2.572    77.617     0.200
     2.835    86.500     0.200
     2.940    88.281     0.200
     7.065   218.391     0.200
     2.473    73.486     0.200
     2.589    77.775     0.200
     2.617    77.406     0.200
     2.149    62.508     0.200
     2.610    77.645     0.200
     2.814    83.125     0.200
     7.391   228.398     0.200
     9.940   314.504     0.200
     2.830    84.543     0.200
     3.453   103.342     0.200
     7.915   241.492     0.200
    11.224   348.480     0.200
     2.374    69.926     0.200
     2.005    57.129     0.200
     2.733    78.270     0.200
     2.805    80.850     0.200
     2.784    79.869     0.200
     3.100    89.889     0.200
     3.237    93.180     0.200
     3.243    93.820     0.200
     3.274    93.160     0.200
     3.274    94.490     0.200
     3.295    95.779     0.200
     3.429    98.469     0.200
     3.513   101.129     0.200
     3.581   103.080     0.200
     3.678   104.779     0.200
     2.544    74.555     0.200
     2.593    75.395     0.200
     2.847    89.234     0.200
     2.395    68.656     0.200
     2.795    81.945     0.200
     7.712   238.148     0.200
    10.956   340.656     0.200
     2.019    58.549     0.200
     2.673    77.229     0.200
     2.777    80.868     0.200
     2.796    79.818     0.200
     3.146    89.938     0.200
     3.331    95.278     0.200
     3.366    95.988     0.200
     2.137    62.387     0.200
     3.082    92.947     0.200
     8.029   250.891     0.200
    11.062   346.272     0.200
     3.308    99.492     0.200
     3.477   105.289     0.200
     4.132   129.883     0.200
     4.497   137.734     0.200
     4.535   140.055     0.200
     8.648   262.039     0.200
    10.845   342.039     0.200
    16.602   523.414     0.200
     2.391    71.178     0.200
     2.718    82.567     0.200
     3.144    95.558     0.200
     3.570   107.537     0.200
     4.634   141.497     0.200
     8.003   245.852     0.200
    11.141   340.082     0.200
     2.370    69.205     0.200
     2.765    83.195     0.200
     7.953   241.889     0.200
    11.167   346.525     0.200
     2.328    67.752     0.200
     2.336    68.363     0.200
     3.985   119.334     0.200
     4.110   124.014     0.200
     5.580   168.174     0.200
    11.103   344.094     0.200
    16.945   527.938     0.200
     2.340    69.363     0.200
    10.945   337.459     0.200
    16.729   518.652     0.200
    23.752   749.609     0.200
    24.863   783.260     0.200
    11.142   349.930     0.200
    16.989   535.398     0.200
     2.609    78.500     0.200
     2.852    87.406     0.200
     8.024   246.344     0.200
    11.010   342.359     0.200
    16.848   527.617     0.200
     2.638    77.433     0.200
     2.370    70.313     0.200
     3.066    93.543     0.200
     3.946   119.488     0.200
    11.167   345.707     0.200
    17.016   530.502     0.200
    19.523   620.346     0.200
    24.194   766.633     0.200
    24.846   783.783     0.200
    25.167   796.432     0.200
    28.888   916.346     0.200
     2.770    82.348     0.200
     3.001    91.770     0.200
     3.434   103.180     0.200
     3.394   103.941     0.200
     2.251    67.082     0.200
     8.514   266.359     0.200
    16.666   521.461     0.200
     2.102    61.504     0.200
     2.623    77.836     0.200
    11.070   342.680     0.200
     2.404    72.953     0.200
     8.113   246.781     0.200
    11.029   348.098     0.200
     2.164    62.504     0.200
     2.346    68.875     0.200
     2.725    80.316     0.200
     2.795    81.234     0.200
     3.446    99.574     0.200
     2.380    68.927     0.200
     2.643    79.427     0.200
     3.522   106.217     0.200
     2.616    78.055     0.200
     3.394   101.914     0.200
     2.016    59.039     0.200
     2.398    74.879     0.200
     8.228   251.309     0.200
    10.871   342.248     0.200
    16.685   527.232     0.200
    10.935   341.852     0.200
     7.926   239.324     0.200
    11.014   341.785     0.200
    16.864   525.652     0.200
     2.496    75.102     0.200
     2.321    66.953     0.200
     3.181    95.473     0.200
     3.325    99.395     0.200
     7.684   238.729     0.200
     9.772   312.908     0.200
     2.418    74.152     0.200
     2.287    66.230     0.200
     2.827    86.309     0.200
     3.597   108.262     0.200
     2.256    66.295     0.200
     2.616    78.062     0.200
     2.719    82.732     0.200
     3.023    92.972     0.200
     3.120    94.672     0.200
     2.178    64.020     0.200
     2.421    72.780     0.200
     2.395    71.590     0.200
     2.415    72.100     0.200
     2.216    65.250     0.200
     2.458    72.980     0.200
     2.356    71.190     0.200
     3.012    89.630     0.200
     3.233    94.811     0.200
     3.376   103.130     0.200
     2.852    84.492     0.200
     3.007    90.438     0.200
     2.982    89.556     0.200
     3.069    90.955     0.200
     3.172    93.216     0.200
     3.203    96.535     0.200
     3.235    95.605     0.200
     3.278    98.585     0.200
     7.645   235.229     0.200
     9.869   309.239     0.200
     2.071    59.207     0.200
     2.094    61.164     0.200
     2.164    63.699     0.200
     2.417    72.930     0.200
     3.065    90.039     0.200
     3.174    94.189     0.200
     3.212    96.439     0.200
     3.321    99.539     0.200
     7.640   236.812     0.200
     9.806   310.020     0.200
     2.089    60.449     0.200
     2.957    88.219     0.200
     8.014   251.141     0.200
    10.932   342.996     0.200
    16.773   525.539     0.200
     2.157    62.938     0.200
     2.626    79.789     0.200
     2.338    69.102     0.200
     2.856    86.719     0.200
     3.491   102.547     0.200
    10.725   339.703     0.200
     2.053    59.809     0.200
     8.035   239.852     0.200
     2.459    73.391     0.200
     3.106    92.844     0.200
     3.279    98.852     0.200
     2.365    68.773     0.200
     2.515    76.322     0.200
     2.940    89.344     0.200
     2.435    72.091     0.200
     3.013    90.331     0.200
     3.122    92.191     0.200
     2.382    70.931     0.200
     2.861    84.150     0.200
     2.907    86.811     0.200
     3.034    90.121     0.200
     3.155    92.931     0.200
     3.276    98.480     0.200
     3.236    97.641     0.200
     3.283    98.780     0.200
     2.800    86.578     0.200
     2.951    88.117     0.200
     3.159    97.336     0.200
     3.268    98.102     0.200
     3.835   119.531     0.200
     2.180    62.107     0.200
     2.170    63.988     0.200
     2.444    72.809     0.200
     7.551   234.410     0.200
     9.757   309.691     0.200
    15.702   493.336     0.200
     2.172    63.781     0.200
     2.352    70.211     0.200
     7.572   237.902     0.200
     9.764   308.586     0.200
     2.949    86.719     0.200
     3.098    92.480     0.200
     7.570   232.531     0.200
     9.761   309.238     0.200
    15.703   498.934     0.200
     2.406    71.066     0.200
     2.431    72.016     0.200
     3.024    91.316     0.200
     2.986    89.328     0.200
    10.861   345.961     0.200
     2.382    71.061     0.200
     2.439    72.162     0.200
     2.511    75.531     0.200
     2.166    62.031     0.200
     2.044    59.938     0.200
     2.398    72.178     0.200
     2.429    72.697     0.200
     3.107    93.318     0.200
     3.274    99.889     0.200
     8.130   247.444     0.200
    11.178   345.391     0.200
    16.998   528.794     0.200
     2.526    74.703     0.200
     2.215    64.642     0.200
     7.587   235.157     0.200
    11.328   353.271     0.200
    17.209   535.806     0.200
     2.283    67.322     0.200
     2.367    68.529     0.200
     2.139    62.561     0.200
     2.340    69.420     0.200
     3.192    93.750     0.200
     2.445    72.961     0.200
     2.518    75.023     0.200
     3.071    93.633     0.200
     3.118    94.797     0.200
     2.349    70.184     0.200
     2.370    69.672     0.200
     3.221    97.133     0.200
     2.451    73.898     0.200
     2.909    88.969     0.200
     3.246    97.172     0.200
     2.048    60.293     0.200
     2.102    61.621     0.200
     2.405    71.203     0.200
     2.640    77.602     0.200
     2.797    83.723     0.200
     3.110    93.402     0.200
     2.352    70.578     0.200
     2.974    89.703     0.200
     3.381   104.143     0.200
     3.935   120.273     0.200
     4.003   120.993     0.200
     4.378   135.003     0.200
     4.395   135.193     0.200
     4.421   135.233     0.200
     4.486   137.893     0.200
     4.517   139.553     0.200
     4.534   140.183     0.200
     4.586   140.503     0.200
     4.684   143.013     0.200
     4.857   147.973     0.200
     5.058   155.903     0.200
     8.441   264.648     0.200
    11.107   348.518     0.200
     2.088    61.351     0.200
     2.780    84.071     0.200
     2.979    89.091     0.200
     3.451   104.181     0.200
     2.817    87.555     0.200
     3.156    95.188     0.200
     3.116    93.906     0.200
     2.601    76.375     0.200
     7.168   223.891     0.200
     2.236    65.438     0.200
     2.389    71.406     0.200
     2.505    74.977     0.200
     2.773    81.977     0.200
     2.176    63.862     0.200
     2.368    70.062     0.200
     2.693    76.832     0.200
     2.413    72.038     0.200
     8.892   274.312     0.200
    10.760   339.848     0.200
    16.483   523.703     0.200
     2.430    73.324     0.200
     2.715    81.852     0.200
     8.350   254.102     0.200
    11.127   347.859     0.200
     2.687    79.703     0.200
     3.157    92.273     0.200
     3.239    96.223     0.200
     2.424    70.224     0.200
     2.663    79.653     0.200
     2.011    59.455     0.200
     2.221    64.805     0.200
     2.252    66.695     0.200
     2.913    85.865     0.200
     2.194    64.812     0.200
     2.257    66.684     0.200
     2.367    68.965     0.200
     2.465    73.195     0.200
     2.770    81.254     0.200
     2.817    80.785     0.200
     8.731   267.383     0.200
     9.922   307.742     0.200
     2.064    60.969     0.200
     2.242    66.727     0.200
     2.597    77.789     0.200
     2.287    65.473     0.200
     2.893    88.072     0.200
     3.361   100.853     0.200
     3.501   107.003     0.200
     4.248   129.952     0.200
     2.661    77.355     0.200
     3.005    90.012     0.200
     3.122    93.451     0.200
     3.239    96.641     0.200
     2.172    63.415     0.200
     2.461    70.375     0.200
     2.949    84.455     0.200
     2.179    62.621     0.200
     2.593    78.043     0.200
     3.080    88.449     0.200
     2.159    63.418     0.200
     2.212    64.996     0.200
     3.000    88.059     0.200
     2.097    60.621     0.200
     2.457    73.331     0.200
     2.763    82.591     0.200
     2.724    84.211     0.200
     2.425    73.330     0.200
     2.473    75.190     0.200
     2.487    75.890     0.200
     2.943    89.370     0.200
     3.107    97.570     0.200
     7.625   232.414     0.200
     9.759   302.420     0.200
     2.409    71.481     0.200
     2.711    79.472     0.200
     2.571    73.625     0.200
     2.703    78.715     0.200
     7.103   222.016     0.200
    10.731   338.875     0.200
     2.599    77.512     0.200
     2.913    91.574     0.200
     2.962    88.414     0.200
     2.989    94.344     0.200
     3.221   100.941     0.200
     3.224    97.871     0.200
     3.236    97.992     0.200
     2.498    75.379     0.200
     2.025    58.062     0.200
     3.046    91.441     0.200
     2.096    61.938     0.200
     2.389    70.750     0.200
     2.585    74.719     0.200
     2.632    78.008     0.200
     2.703    78.609     0.200
     2.343    68.594     0.200
     2.275    67.469     0.200
     2.385    70.375     0.200
     2.607    77.680     0.200
     2.147    62.886     0.200
     2.384    68.806     0.200
     2.394    71.168     0.200
     2.409    72.234     0.200
     2.502    74.445     0.200
     2.516    75.406     0.200
     3.047    89.785     0.200
     3.152    99.746     0.200
     3.204    99.074     0.200
     3.387   104.305     0.200
    10.831   346.371     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     3.250    95.152     0.200
     5.642   162.152     0.200
     1.421    44.389     0.200
     4.039   118.389     0.200
     4.111   118.719     0.200
     4.121   120.719     0.200
     6.883   193.719     0.200
     3.605   104.092     0.200
     3.019    87.396     0.200
     0.085     8.258     0.200
     1.880    55.258     0.200
     6.234   178.258     0.200
     1.310    35.836     0.200
     1.401    44.215     0.200
     4.094   120.494     0.200
     2.441    70.388     0.200
     3.331    95.688     0.200
     1.895    56.093     0.200
     2.961    86.393     0.200
     3.465    98.693     0.200
     1.252    40.727     0.200
     2.448    70.500     0.200
     1.961    58.484     0.200
     3.581   100.086     0.200
     1.451    43.625     0.200
     3.415    96.055     0.200
     3.459    97.664     0.200
     3.558   101.016     0.200
     3.833   107.227     0.200
     1.359    41.939     0.200
     1.468    44.020     0.200
     2.365    70.479     0.200
     2.462    70.789     0.200
     3.490   100.619     0.200
     1.198    37.555     0.200
     1.148    35.250     0.200
     1.094    34.027     0.200
     1.975    61.047     0.200
     2.451    70.637     0.200
     2.050    61.062     0.200
     2.503    72.094     0.200
     3.452   101.344     0.200
     1.219    38.172     0.200
     3.269    94.211     0.200
     3.383    96.539     0.200
     1.136    35.043     0.200
     1.283    39.062     0.200
     3.710   105.422     0.200
     4.029   113.642     0.200
     1.143    33.836     0.200
     1.545    47.484     0.200
     1.846    55.984     0.200
     2.034    61.754     0.200
     3.054    88.215     0.200
     3.830   108.387     0.200
     4.266   122.855     0.200
     1.222    38.582     0.200
     1.287    39.629     0.200
     2.998    84.871     0.200
     3.333    93.891     0.200
     3.333    95.199     0.200
     1.745    52.246     0.200
     2.048    61.116     0.200
     1.070    32.838     0.200
     1.869    55.338     0.200
     1.961    60.648     0.200
     2.027    61.078     0.200
     3.261    94.127     0.200
     3.783   107.139     0.200
     3.783   107.469     0.200
     0.929    29.875     0.200
     3.408    98.445     0.200
     0.559    20.438     0.200
     0.820    26.008     0.200
     1.991    60.727     0.200
     3.642   102.727     0.200
     1.287    40.469     0.200
     3.824   107.781     0.200
     1.983    57.719     0.200
     1.279    40.292     0.200
     2.311    68.843     0.200
     3.969   116.982     0.200
     4.697   131.272     0.200
     2.486    73.305     0.200
     4.485   126.719     0.200
     1.266    38.742     0.200
     3.953   110.859     0.200
     4.382   123.531     0.200
     0.226    10.816     0.200
     3.991   113.525     0.200
     4.354   123.455     0.200
     4.382   123.564     0.200
     4.719   134.115     0.200
     4.786   134.814     0.200
     4.821   136.516     0.200
     5.183   146.484     0.200
     0.489    17.023     0.200
     3.235    95.133     0.200
     3.713   110.746     0.200
     3.735   109.566     0.200
     5.953   174.555     0.200
     0.837    27.422     0.200
     1.174    37.531     0.200
     4.601   133.281     0.200
     4.700   135.180     0.200
     0.961    31.137     0.200
     1.149    36.918     0.200
     1.626    53.676     0.200
     2.949    88.555     0.200
     3.581   103.906     0.200
     0.753    24.230     0.200
     1.167    36.172     0.200
     1.038    32.363     0.200
     1.843    56.852     0.200
     2.532    72.984     0.200
     3.130    92.543     0.200
     3.142    90.715     0.200
     3.186    92.953     0.200
     3.596   102.215     0.200
     3.635   103.875     0.200
     4.670   133.484     0.200
     0.483    17.352     0.200
     1.515    45.789     0.200
     1.573    49.703     0.200
     2.252    70.539     0.200
     3.080    90.484     0.200
     0.434    16.166     0.200
     4.358   124.566     0.200
     0.452    15.320     0.200
     2.455    75.680     0.200
     3.052    87.883     0.200
     7.728   223.844     0.200
     0.211     8.988     0.200
     1.819    53.578     0.200
     4.817   141.090     0.200
     6.629   196.279     0.200
     0.942    29.594     0.200
     4.355   122.844     0.200
     4.526   125.945     0.200
     4.583   135.078     0.200
     1.404    42.166     0.200
     1.502    45.096     0.200
     0.794    25.261     0.200
     1.368    42.691     0.200
     1.818    56.001     0.200
     2.061    61.851     0.200
     0.081     6.133     0.200
     1.241    39.512     0.200
     0.756    24.837     0.200
     0.756    24.547     0.200
     1.272    38.467     0.200
     1.272    39.888     0.200
     1.888    57.938     0.200
     1.999    60.638     0.200
     2.122    63.527     0.200
     2.931    84.027     0.200
     2.931    84.907     0.200
     3.339    94.318     0.200
     3.533   100.857     0.200
     0.950    30.344     0.200
     0.966    31.145     0.200
     1.038    33.910     0.200
     1.218    40.461     0.200
     1.245    38.988     0.200
     1.609    48.180     0.200
     1.989    60.828     0.200
     3.171    94.059     0.200
     3.236    94.289     0.200
     0.089     6.421     0.200
     0.954    30.901     0.200
     1.563    49.021     0.200
     1.733    53.391     0.200
     3.246    92.601     0.200
     3.640   106.571     0.200
     3.735   107.791     0.200
     3.826   112.181     0.200
     4.169   122.221     0.200
     4.283   125.311     0.200
     4.626   130.801     0.200
     6.413   181.431     0.200
     6.502   190.171     0.200
     6.795   191.941     0.200
     7.571   216.931     0.200
     0.282     9.004     0.200
     3.930   116.266     0.200
     0.559    18.344     0.200
     0.559    18.617     0.200
     0.655    21.898     0.200
     0.655    22.047     0.200
     0.730    23.570     0.200
     0.957    30.797     0.200
     2.205    66.727     0.200
     2.294    68.594     0.200
     3.685   109.000     0.200
     4.308   125.492     0.200
     4.317   124.812     0.200
     4.317   125.469     0.200
     4.360   123.781     0.200
     4.653   137.367     0.200
     5.010   143.680     0.200
     5.323   154.727     0.200
     6.337   185.258     0.200
     6.819   198.820     0.200
     7.286   218.109     0.200
     0.612    20.770     0.200
     1.396    42.066     0.200
     1.435    42.988     0.200
     1.549    46.379     0.200
     1.585    47.859     0.200
     1.587    48.277     0.200
     1.602    49.160     0.200
     3.076    88.449     0.200
     3.113    88.668     0.200
     3.267    94.879     0.200
     3.487   101.609     0.200
     3.556   101.828     0.200
     4.001   111.930     0.200
     0.908    28.250     0.200
     1.342    42.273     0.200
     1.422    43.051     0.200
     1.394    43.570     0.200
     1.495    44.934     0.200
     1.535    47.121     0.200
     1.529    47.641     0.200
     1.530    48.750     0.200
     1.545    48.672     0.200
     2.051    60.922     0.200
     3.166    93.312     0.200
     3.180    91.672     0.200
     3.250    96.121     0.200
     3.421    98.320     0.200
     3.556   105.082     0.200
     0.108     7.268     0.200
     0.824    26.268     0.200
     0.901    29.539     0.200
     0.997    30.928     0.200
     1.597    50.148     0.200
     1.721    53.148     0.200
     2.020    63.068     0.200
     2.369    74.828     0.200
     2.915    84.139     0.200
     3.160    92.549     0.200
     3.670   105.588     0.200
     3.759   107.869     0.200
     3.712   110.488     0.200
     4.715   135.039     0.200
     0.081     6.785     0.200
     0.876    27.605     0.200
     0.949    30.145     0.200
     1.214    39.055     0.200
     1.225    38.836     0.200
     1.257    38.965     0.200
     1.271    39.613     0.200
     1.558    48.715     0.200
     1.724    52.445     0.200
     1.976    58.285     0.200
     1.966    60.363     0.200
     3.173    91.316     0.200
     3.243    91.996     0.200
     3.635   105.754     0.200
     3.792   109.914     0.200
     4.072   114.227     0.200
     4.200   118.375     0.200
     4.369   123.996     0.200
     5.046   140.484     0.200
     5.390   150.855     0.200
     0.045     8.934     0.200
     0.904    29.195     0.200
     1.029    31.676     0.200
     1.157    36.773     0.200
     1.166    37.824     0.200
     1.195    37.727     0.200
     1.211    38.664     0.200
     3.661   103.164     0.200
     1.642    49.064     0.200
     1.789    53.486     0.200
     1.798    53.086     0.200
     1.799    53.895     0.200
     1.807    53.625     0.200
     1.835    54.945     0.200
     1.909    58.016     0.200
     2.274    69.426     0.200
     2.647    75.496     0.200
     2.767    80.195     0.200
     2.840    84.125     0.200
     2.841    84.445     0.200
     3.190    90.375     0.200
     3.253    92.096     0.200
     3.263    92.256     0.200
     3.393    98.715     0.200
     3.570   103.705     0.200
     3.817   110.686     0.200
     4.489   131.285     0.200
     4.410   124.506     0.200
     4.665   129.805     0.200
     4.997   139.506     0.200
     5.071   142.746     0.200
     0.636    20.298     0.200
     1.145    36.618     0.200
     1.512    46.817     0.200
     1.640    50.958     0.200
     1.643    50.107     0.200
     1.644    52.718     0.200
     1.651    50.128     0.200
     1.667    50.698     0.200
     1.674    53.098     0.200
     1.690    51.647     0.200
     1.722    54.248     0.200
     1.742    52.378     0.200
     2.655    76.678     0.200
     4.769   136.848     0.200
     0.875    29.951     0.200
     1.730    54.922     0.200
     2.091    63.191     0.200
     2.106    64.982     0.200
     2.094    65.441     0.200
     2.185    67.432     0.200
     3.312    98.672     0.200
     3.348    97.221     0.200
     3.406   100.791     0.200
     3.459   100.521     0.200
     3.502   101.812     0.200
     3.593   106.102     0.200
     3.698   106.502     0.200
     3.778   113.631     0.200
     3.787   113.451     0.200
     3.814   114.172     0.200
     3.828   112.691     0.200
     3.900   114.982     0.200
     3.921   115.852     0.200
     3.976   117.701     0.200
     4.052   118.441     0.200
     4.121   120.822     0.200
     4.266   121.971     0.200
     4.446   127.342     0.200
     4.691   138.301     0.200
     0.937    30.852     0.200
     1.101    35.078     0.200
     1.507    46.941     0.200
     1.627    50.781     0.200
     1.644    51.398     0.200
     1.630    52.039     0.200
     1.630    51.008     0.200
     1.660    51.789     0.200
     1.677    52.008     0.200
     1.741    52.988     0.200
     1.914    55.270     0.200
     4.168   116.551     0.200
     0.055     6.926     0.200
     0.958    30.066     0.200
     1.000    31.506     0.200
     1.120    34.057     0.200
     1.158    35.906     0.200
     1.262    38.877     0.200
     1.291    39.467     0.200
     1.686    50.217     0.200
     1.665    49.357     0.200
     3.020    87.688     0.200
     3.068    87.627     0.200
     3.532    99.447     0.200
     3.653   103.236     0.200
     3.683   106.707     0.200
     4.561   129.896     0.200
     4.794   133.598     0.200
     0.032     6.359     0.200
     1.200    36.609     0.200
     1.209    38.141     0.200
     1.237    40.461     0.200
     1.254    38.492     0.200
     1.258    39.980     0.200
     1.622    49.520     0.200
     2.378    72.621     0.200
     3.531    99.730     0.200
     3.652   105.641     0.200
     0.825    27.369     0.200
     0.849    28.310     0.200
     0.837    28.959     0.200
     0.847    28.149     0.200
     0.847    29.539     0.200
     0.858    28.439     0.200
     0.879    29.959     0.200
     0.992    32.379     0.200
     0.934    31.609     0.200
     1.485    45.850     0.200
     1.485    46.129     0.200
     1.655    51.060     0.200
     1.840    57.249     0.200
     2.505    75.959     0.200
     2.854    84.720     0.200
     2.949    88.169     0.200
     2.948    85.369     0.200
     3.176    92.020     0.200
     3.322    95.959     0.200
     3.418    98.359     0.200
     3.443   100.560     0.200
     3.590   103.220     0.200
     3.575   103.799     0.200
     3.797   108.669     0.200
     4.232   120.180     0.200
     0.075     6.591     0.200
     0.980    30.030     0.200
     1.266    41.661     0.200
     1.274    41.021     0.200
     1.429    44.631     0.200
     1.320    42.900     0.200
     1.324    42.631     0.200
     1.710    52.021     0.200
     2.053    62.301     0.200
     3.118    88.900     0.200
     3.580   102.431     0.200
     3.604   103.980     0.200
     3.640   105.820     0.200
     3.900   115.221     0.200
     4.057   114.641     0.200
     4.047   118.360     0.200
     4.918   138.480     0.200
     5.237   146.030     0.200
     0.062    10.195     0.200
     0.057    10.086     0.200
     0.070     9.926     0.200
     0.087    10.305     0.200
     0.103    10.227     0.200
     0.308    12.605     0.200
     0.241    11.305     0.200
     0.301    12.164     0.200
     0.676    21.555     0.200
     1.178    37.254     0.200
     1.139    34.816     0.200
     1.197    39.914     0.200
     1.223    41.254     0.200
     1.413    42.574     0.200
     1.539    47.016     0.200
     1.956    58.996     0.200
     2.726    78.727     0.200
     0.130     8.451     0.200
     1.034    32.440     0.200
     1.063    33.701     0.200
     1.222    39.190     0.200
     1.319    41.211     0.200
     1.310    42.081     0.200
     1.318    42.391     0.200
     1.345    43.570     0.200
     1.363    43.980     0.200
     1.367    43.801     0.200
     1.765    54.241     0.200
     2.757    78.501     0.200
     3.461   100.701     0.200
     3.563   104.801     0.200
     3.550   100.631     0.200
     3.624   103.341     0.200
     4.592   128.381     0.200
     0.787    25.719     0.200
     0.781    26.008     0.200
     1.357    42.938     0.200
     1.670    50.688     0.200
     1.802    54.883     0.200
     1.825    55.898     0.200
     1.866    56.750     0.200
     1.877    59.250     0.200
     2.209    65.688     0.200
     3.022    88.539     0.200
     3.103    92.047     0.200
     3.166    92.703     0.200
     3.335    95.180     0.200
     3.386    96.711     0.200
     3.481   101.977     0.200
     3.525   104.359     0.200
     3.555   104.258     0.200
     3.704   109.398     0.200
     4.108   118.508     0.200
     0.015     6.675     0.200
     1.118    34.064     0.200
     1.215    39.175     0.200
     1.224    39.905     0.200
     1.213    38.354     0.200
     1.254    40.685     0.200
     1.270    41.195     0.200
     1.273    41.185     0.200
     1.645    50.225     0.200
     2.542    73.274     0.200
     2.980    86.745     0.200
     0.078     7.443     0.200
     1.276    41.354     0.200
     1.285    41.465     0.200
     1.277    39.484     0.200
     1.314    41.453     0.200
     1.330    43.154     0.200
     1.442    43.594     0.200
     1.334    43.184     0.200
     1.858    57.703     0.200
     1.706    53.354     0.200
     2.063    61.264     0.200
     2.079    63.264     0.200
     3.125    91.914     0.200
     3.521   101.604     0.200
     3.620   104.854     0.200
     3.692   104.523     0.200
     3.686   105.805     0.200
     4.537   128.184     0.200
     4.562   128.264     0.200
     4.804   135.023     0.200
     0.124     4.721     0.200
     0.306     9.842     0.200
     0.409    13.781     0.200
     0.458    15.121     0.200
     0.587    20.262     0.200
     0.636    22.621     0.200
     0.647    23.012     0.200
     0.651    23.211     0.200
     0.815    27.141     0.200
     0.874    26.951     0.200
     1.236    37.641     0.200
     1.776    55.852     0.200
     2.106    64.541     0.200
     2.605    79.051     0.200
     2.646    79.990     0.200
     3.412    99.781     0.200
     4.012   116.391     0.200
     4.151   117.682     0.200
     4.166   120.891     0.200
     0.055     6.277     0.200
     0.851    26.908     0.200
     1.663    52.117     0.200
     1.581    49.377     0.200
     1.953    57.748     0.200
     2.298    70.697     0.200
     2.352    72.127     0.200
     2.869    85.107     0.200
     2.920    84.207     0.200
     3.610   104.527     0.200
     3.641   103.018     0.200
     3.654   105.338     0.200
     3.697   106.828     0.200
     3.754   110.428     0.200
     3.971   112.568     0.200
     4.114   117.047     0.200
     4.115   116.357     0.200
     4.139   118.678     0.200
     4.157   116.797     0.200
     4.162   117.158     0.200
     4.495   126.297     0.200
     4.781   133.396     0.200
     6.498   185.158     0.200
     6.498   186.877     0.200
     0.729    23.918     0.200
     0.814    26.898     0.200
     1.401    42.977     0.200
     1.566    49.176     0.200
     1.615    47.508     0.200
     1.745    52.059     0.200
     1.764    54.258     0.200
     1.766    55.977     0.200
     1.782    55.176     0.200
     1.807    54.086     0.200
     1.818    57.309     0.200
     3.070    90.566     0.200
     3.329    99.168     0.200
     3.438    99.496     0.200
     3.457    97.746     0.200
     3.689   104.836     0.200
     3.711   105.379     0.200
     3.760   105.836     0.200
     4.112   117.168     0.200
     1.082    34.883     0.200
     1.227    38.152     0.200
     1.238    41.253     0.200
     1.238    40.303     0.200
     1.276    42.053     0.200
     1.338    41.383     0.200
     1.882    55.683     0.200
     1.983    57.612     0.200
     2.343    69.643     0.200
     2.540    73.333     0.200
     3.136    90.532     0.200
     3.336    95.362     0.200
     5.167   143.833     0.200
     0.433    15.723     0.200
     0.671    23.343     0.200
     0.752    25.593     0.200
     0.806    27.753     0.200
     0.863    29.393     0.200
     0.865    29.733     0.200
     1.180    36.483     0.200
     1.550    48.503     0.200
     1.685    51.493     0.200
     1.885    55.743     0.200
     2.517    71.423     0.200
     3.032    86.813     0.200
     3.329    97.043     0.200
     3.651   104.183     0.200
     0.090     4.083     0.200
     0.534    18.683     0.200
     0.547    18.844     0.200
     0.726    25.144     0.200
     0.720    23.823     0.200
     0.747    26.124     0.200
     0.767    25.874     0.200
     0.782    26.904     0.200
     0.920    30.104     0.200
     1.091    34.294     0.200
     1.975    61.304     0.200
     2.033    61.744     0.200
     4.811   136.514     0.200
     4.965   139.644     0.200
     0.487    16.113     0.200
     1.483    45.414     0.200
     1.910    57.633     0.200
     1.878    56.514     0.200
     1.943    60.613     0.200
     1.944    60.703     0.200
     1.980    62.363     0.200
     1.994    61.953     0.200
     2.040    61.594     0.200
     1.982    60.264     0.200
     2.265    68.033     0.200
     2.720    79.523     0.200
     3.136    93.164     0.200
     3.224    94.074     0.200
     3.638   104.863     0.200
     3.638   105.623     0.200
     3.673   106.703     0.200
     3.673   106.895     0.200
     3.682   105.883     0.200
     3.723   106.434     0.200
     4.402   122.854     0.200
     0.635    21.078     0.200
     1.246    38.711     0.200
     1.788    54.953     0.200
     1.998    59.898     0.200
     2.971    86.367     0.200
     3.993   118.102     0.200
     4.170   119.719     0.200
     1.126    35.822     0.200
     1.514    46.092     0.200
     1.502    47.973     0.200
     1.532    49.422     0.200
     1.614    49.783     0.200
     1.765    55.053     0.200
     2.074    61.973     0.200
     3.723   106.662     0.200
     3.813   110.152     0.200
     0.121     7.145     0.200
     0.791    25.684     0.200
     1.607    49.855     0.200
     3.862   109.035     0.200
     4.026   114.277     0.200
     0.126     7.670     0.200
     0.829    26.971     0.200
     1.188    37.570     0.200
     1.246    39.490     0.200
     1.748    52.370     0.200
     2.344    71.130     0.200
     3.090    89.641     0.200
     3.744   104.900     0.200
     3.735   105.391     0.200
     3.740   105.450     0.200
     3.798   108.271     0.200
     4.200   117.500     0.200
     4.204   118.670     0.200
     4.222   119.710     0.200
     4.689   132.740     0.200
     4.863   139.460     0.200
     0.426    15.211     0.200
     0.659    22.516     0.200
     0.884    28.672     0.200
     1.014    31.898     0.200
     1.065    34.391     0.200
     1.074    34.727     0.200
     2.034    61.469     0.200
     3.475   101.000     0.200
     3.995   116.719     0.200
     4.438   130.086     0.200
     4.541   130.047     0.200
     4.635   131.641     0.200
     4.659   131.148     0.200
     4.659   133.836     0.200
     4.681   136.695     0.200
     4.832   138.898     0.200
     4.895   143.055     0.200
     5.220   149.211     0.200
     6.064   174.000     0.200
     6.272   176.961     0.200
     1.922    60.629     0.200
     1.957    59.840     0.200
     2.023    60.949     0.200
     2.794    79.473     0.200
     2.828    82.043     0.200
     3.049    90.332     0.200
     3.092    90.379     0.200
     3.162    91.910     0.200
     3.217    92.645     0.200
     3.241    93.965     0.200
     3.368    97.434     0.200
     3.409    98.168     0.200
     3.550   104.754     0.200
     3.609   101.355     0.200
     3.754   112.012     0.200
     4.712   133.379     0.200
     4.879   143.035     0.200
     1.015    32.219     0.200
     1.497    49.748     0.200
     2.133    64.629     0.200
     2.250    70.988     0.200
     4.347   124.088     0.200
     0.515    18.559     0.200
     0.559    19.869     0.200
     0.569    20.428     0.200
     0.613    19.988     0.200
     0.645    20.379     0.200
     0.733    24.520     0.200
     1.681    50.809     0.200
     0.743    24.297     0.200
     1.386    44.258     0.200
     1.813    55.680     0.200
     2.021    63.578     0.200
     2.024    60.453     0.200
     2.055    64.977     0.200
     2.071    64.008     0.200
     2.550    74.805     0.200
     2.809    80.180     0.200
     2.916    83.758     0.200
     3.004    85.594     0.200
     2.995    86.414     0.200
     3.093    88.289     0.200
     3.108    87.977     0.200
     3.332    94.312     0.200
     4.736   132.344     0.200
     0.439    15.965     0.200
     1.113    33.574     0.200
     1.207    37.744     0.200
     1.219    37.834     0.200
     1.249    39.533     0.200
     1.233    40.234     0.200
     3.216    91.863     0.200
     3.498   100.555     0.200
     4.097   117.574     0.200
     4.234   119.055     0.200
     0.250     8.482     0.200
     1.435    46.492     0.200
     1.659    51.982     0.200
     5.029   144.643     0.200
     5.234   148.822     0.200
     0.499    17.043     0.200
     1.137    35.113     0.200
     1.827    55.333     0.200
     1.906    56.003     0.200
     1.871    58.333     0.200
     1.872    57.923     0.200
     1.907    59.013     0.200
     1.922    60.793     0.200
     1.974    60.103     0.200
     1.914    58.983     0.200
     2.753    80.733     0.200
     2.716    77.863     0.200
     3.209    95.073     0.200
     0.260    10.648     0.200
     1.067    35.340     0.200
     1.214    39.430     0.200
     1.430    44.691     0.200
     1.591    49.621     0.200
     1.513    45.512     0.200
     1.662    51.391     0.200
     2.163    65.590     0.200
     2.184    65.672     0.200
     2.233    68.969     0.200
     2.861    81.691     0.200
     2.897    82.930     0.200
     3.099    87.980     0.200
     3.159    90.430     0.200
     3.515   100.289     0.200
     0.057     6.420     0.200
     1.625    50.209     0.200
     1.962    59.250     0.200
     2.272    68.658     0.200
     2.401    74.699     0.200
     2.865    82.600     0.200
     3.019    86.549     0.200
     3.071    90.920     0.200
     3.220    93.260     0.200
     4.083   117.648     0.200
     4.527   130.549     0.200
     0.052     6.043     0.200
     0.855    26.875     0.200
     1.664    51.086     0.200
     1.957    59.453     0.200
     4.564   130.246     0.200
     0.507    17.646     0.200
     1.393    42.428     0.200
     1.411    43.717     0.200
     1.515    45.658     0.200
     1.617    47.848     0.200
     1.549    47.377     0.200
     1.621    48.277     0.200
     1.615    49.088     0.200
     2.573    75.348     0.200
     2.834    82.807     0.200
     2.980    85.828     0.200
     3.047    87.168     0.200
     3.324    95.188     0.200
     3.524    99.908     0.200
     3.716   105.838     0.200
     3.729   105.178     0.200
     0.256     8.951     0.200
     1.656    53.191     0.200
     1.451    46.512     0.200
     1.502    48.230     0.200
     1.638    52.311     0.200
     2.114    65.531     0.200
     2.262    70.320     0.200
     2.558    78.920     0.200
     2.549    77.262     0.200
     2.857    86.881     0.200
     2.785    85.551     0.200
     3.056    92.371     0.200
     0.127     6.527     0.200
     1.885    56.316     0.200
     2.837    82.457     0.200
     3.134    92.008     0.200
     3.750   107.777     0.200
     0.122     7.999     0.200
     1.224    38.659     0.200
     1.320    41.369     0.200
     1.371    43.749     0.200
     1.412    42.289     0.200
     1.748    54.239     0.200
     1.823    55.309     0.200
     2.120    62.729     0.200
     3.072    87.249     0.200
     3.494   102.699     0.200
     3.588   102.499     0.200
     3.598   105.729     0.200
     3.651   108.269     0.200
     0.580    20.242     0.200
     1.346    41.344     0.200
     2.585    76.102     0.200
     3.008    88.422     0.200
     3.045    87.773     0.200
     3.061    89.023     0.200
     3.296    94.680     0.200
     3.503    98.398     0.200
     3.605   103.031     0.200
     3.679   103.969     0.200
     3.853   111.031     0.200
     3.974   112.617     0.200
     4.216   120.070     0.200
     0.071     7.535     0.200
     1.145    36.273     0.200
     1.237    38.805     0.200
     1.305    41.785     0.200
     1.640    50.691     0.200
     1.933    57.824     0.200
     2.452    72.262     0.200
     2.890    84.414     0.200
     3.598   105.062     0.200
     3.695   108.812     0.200
     3.761   112.004     0.200
     4.136   121.965     0.200
     4.326   128.273     0.200
     4.599   132.613     0.200
     4.639   134.562     0.200
     5.444   154.703     0.200
     5.739   163.992     0.200
     6.014   171.484     0.200
     6.449   182.262     0.200
     0.277    13.414     0.200
     0.874    28.645     0.200
     0.977    31.102     0.200
     0.999    31.645     0.200
     1.527    45.914     0.200
     1.893    56.242     0.200
     2.296    68.395     0.200
     2.334    70.191     0.200
     3.972   116.375     0.200
     0.245     8.359     0.200
     1.370    43.539     0.200
     1.454    46.719     0.200
     2.291    70.922     0.200
     2.459    74.391     0.200
     2.539    79.805     0.200
     2.568    78.609     0.200
     3.139    91.469     0.200
     3.121    93.195     0.200
     3.263    96.477     0.200
     3.536   102.977     0.200
     0.188     8.609     0.200
     1.329    42.789     0.200
     1.470    45.547     0.200
     1.552    47.719     0.200
     2.662    77.938     0.200
     2.947    84.699     0.200
     3.090    91.707     0.200
     3.104    89.047     0.200
     0.690    22.391     0.200
     1.731    54.719     0.200
     1.751    51.578     0.200
     2.901    82.211     0.200
     3.543    99.578     0.200
     1.291    39.102     0.200
     1.539    48.688     0.200
     1.437    47.562     0.200
     1.655    49.195     0.200
     1.889    56.883     0.200
     2.387    69.812     0.200
     2.644    77.367     0.200
     2.989    85.914     0.200
     2.974    84.734     0.200
     3.076    88.758     0.200
     3.475    99.406     0.200
     1.100    34.969     0.200
     1.123    36.141     0.200
     2.655    76.750     0.200
     2.881    81.633     0.200
     3.033    86.500     0.200
     3.450    97.320     0.200
     3.455    98.797     0.200
     3.514   103.562     0.200
     3.627   101.727     0.200
     3.583   102.188     0.200
     3.656   103.227     0.200
     0.195     7.016     0.200
     1.541    49.746     0.200
     1.502    48.586     0.200
     2.338    70.445     0.200
     2.835    86.457     0.200
     3.279    96.816     0.200
     0.183     7.027     0.200
     1.528    48.715     0.200
     1.501    49.078     0.200
     1.968    60.586     0.200
     2.336    72.715     0.200
     2.620    80.785     0.200
     0.969    31.322     0.200
     1.650    51.643     0.200
     1.611    50.014     0.200
     1.739    52.604     0.200
     2.427    71.764     0.200
     2.659    77.652     0.200
     2.927    84.883     0.200
     2.976    85.902     0.200
     3.114    88.162     0.200
     3.083    91.453     0.200
     3.112    88.854     0.200
     3.243    92.752     0.200
     3.304    93.434     0.200
     0.306    11.613     0.200
     0.306    10.723     0.200
     1.389    43.113     0.200
     1.488    45.492     0.200
     1.525    48.303     0.200
     1.671    50.482     0.200
     1.939    59.512     0.200
     2.382    72.242     0.200
     2.905    85.383     0.200
     3.249    92.812     0.200
     3.334    96.762     0.200
     3.470    99.934     0.200
     3.745   105.463     0.200
     3.926   115.992     0.200
     4.060   117.332     0.200
     4.360   122.732     0.200
     4.369   127.393     0.200
     0.699    22.195     0.200
     1.186    37.605     0.200
     1.071    35.078     0.200
     1.586    50.086     0.200
     1.618    50.488     0.200
     1.672    51.918     0.200
     1.698    51.055     0.200
     1.956    58.238     0.200
     2.731    81.086     0.200
     3.048    87.535     0.200
     0.854    27.104     0.200
     1.678    50.834     0.200
     1.785    54.544     0.200
     1.949    60.415     0.200
     2.033    61.865     0.200
     0.871    28.316     0.200
     1.120    34.036     0.200
     1.979    61.007     0.200
     2.692    77.316     0.200
     2.784    80.826     0.200
     2.802    83.036     0.200
     2.871    82.887     0.200
     2.873    83.707     0.200
     3.113    89.687     0.200
     3.247    94.337     0.200
     3.414    97.587     0.200
     3.440    97.076     0.200
     3.656   105.627     0.200
     3.673   102.977     0.200
     0.131     7.627     0.200
     1.204    38.487     0.200
     1.303    40.007     0.200
     1.345    43.067     0.200
     1.609    50.587     0.200
     1.784    54.567     0.200
     2.357    70.557     0.200
     2.383    74.347     0.200
     2.645    77.157     0.200
     3.065    87.937     0.200
     3.518   102.747     0.200
     3.544   104.077     0.200
     3.609   102.077     0.200
     3.837   109.387     0.200
     3.803   112.367     0.200
     3.985   111.737     0.200
     3.992   115.947     0.200
     4.068   118.687     0.200
     4.231   122.677     0.200
     4.436   124.387     0.200
     0.053     5.648     0.200
     1.585    48.055     0.200
     1.673    50.930     0.200
     1.957    58.141     0.200
     2.486    72.727     0.200
     2.448    71.781     0.200
     2.929    83.578     0.200
     0.086     6.895     0.200
     1.136    34.895     0.200
     1.587    48.852     0.200
     1.834    55.152     0.200
     2.346    70.035     0.200
     2.346    71.930     0.200
     3.565   100.832     0.200
     3.995   113.512     0.200
     3.997   118.699     0.200
     3.997   114.172     0.200
     4.001   112.125     0.200
     4.013   112.723     0.200
     4.042   115.062     0.200
     4.227   122.055     0.200
     4.458   126.734     0.200
     4.459   126.734     0.200
     4.503   128.922     0.200
     4.503   134.383     0.200
     4.521   130.941     0.200
     4.527   127.914     0.200
     4.880   136.234     0.200
     0.503    17.117     0.200
     0.751    24.555     0.200
     0.884    30.008     0.200
     0.945    30.984     0.200
     0.945    29.984     0.200
     1.172    37.133     0.200
     2.159    66.055     0.200
     2.416    73.672     0.200
     2.675    84.172     0.200
     3.330    95.906     0.200
     4.471   127.008     0.200
     4.511   127.445     0.200
     4.513   133.312     0.200
     4.526   132.047     0.200
     4.535   132.305     0.200
     4.544   136.289     0.200
     5.111   144.805     0.200
     0.192     8.938     0.200
     1.282    39.317     0.200
     1.380    41.497     0.200
     1.657    50.317     0.200
     2.198    66.487     0.200
     0.243     9.625     0.200
     1.324    41.535     0.200
     1.423    43.675     0.200
     1.645    51.055     0.200
     1.879    57.854     0.200
     0.090     6.902     0.200
     1.180    37.122     0.200
     1.560    48.143     0.200
     1.869    55.843     0.200
     2.524    72.542     0.200
     3.017    85.593     0.200
     0.200     9.404     0.200
     1.364    41.934     0.200
     1.717    51.533     0.200
     2.677    78.834     0.200
     3.123    92.193     0.200
     3.483   100.904     0.200
     3.476    98.074     0.200
     3.510   101.395     0.200
     3.926   110.033     0.200
     3.926   110.693     0.200
     3.932   112.684     0.200
     3.936   116.014     0.200
     3.936   116.674     0.200
     3.961   114.684     0.200
     3.967   116.674     0.200
     3.985   116.674     0.200
     4.058   116.674     0.200
     4.080   117.334     0.200
     4.123   118.664     0.200
     4.253   121.324     0.200
     4.253   122.654     0.200
     4.421   124.244     0.200
     4.428   126.943     0.200
     5.225   147.635     0.200
     6.137   172.824     0.200
     6.151   177.125     0.200
     6.126   180.465     0.200
     6.230   177.504     0.200
     7.166   201.754     0.200
     7.126   205.674     0.200
     7.509   221.764     0.200
     0.838    27.545     0.200
     0.987    31.734     0.200
     1.066    33.783     0.200
     1.834    55.744     0.200
     2.196    66.594     0.200
     2.629    76.604     0.200
     4.768   139.805     0.200
     1.316    41.445     0.200
     1.416    44.145     0.200
     1.605    51.215     0.200
     1.889    56.586     0.200
     2.329    70.637     0.200
     2.763    80.066     0.200
     3.091    91.414     0.200
     4.742   133.547     0.200
     1.129    34.387     0.200
     1.501    44.988     0.200
     2.087    62.848     0.200
     3.224    91.887     0.200
     1.162    37.203     0.200
     1.263    38.508     0.200
     1.563    48.047     0.200
     1.746    53.398     0.200
     3.032    86.633     0.200
     4.505   125.750     0.200
     1.755    54.363     0.200
     1.621    50.123     0.200
     1.797    55.113     0.200
     3.061    89.143     0.200
     3.558   106.333     0.200
     3.852   113.643     0.200
     3.980   118.293     0.200
     3.992   116.963     0.200
     4.439   126.273     0.200
     4.445   125.604     0.200
     4.451   127.593     0.200
     1.348    42.578     0.200
     1.450    45.078     0.200
     1.609    50.258     0.200
     2.325    69.607     0.200
     2.797    82.018     0.200
     2.902    84.158     0.200
     3.098    90.646     0.200
     3.206    92.508     0.200
     3.435    99.217     0.200
     3.513   100.547     0.200
     3.879   113.918     0.200
     3.887   111.848     0.200
     3.896   116.168     0.200
     3.898   112.396     0.200
     3.890   112.137     0.200
     3.906   113.828     0.200
     3.924   111.178     0.200
     3.982   114.508     0.200
     4.328   124.807     0.200
     4.759   134.768     0.200
     6.136   173.207     0.200
     1.152    36.598     0.200
     1.513    46.660     0.200
     1.608    50.289     0.200
     2.297    68.918     0.200
     2.231    67.258     0.200
     2.554    77.199     0.200
     3.161    92.000     0.200
     3.360    98.859     0.200
     3.355    99.961     0.200
     3.439    99.961     0.200
     3.806   110.898     0.200
     3.820   111.621     0.200
     3.840   110.891     0.200
     3.846   111.219     0.200
     3.855   113.910     0.200
     3.938   111.879     0.200
     4.226   121.219     0.200
     4.245   121.879     0.200
     4.252   120.551     0.200
     4.255   121.219     0.200
     4.259   123.211     0.200
     4.265   123.629     0.200
     4.314   124.918     0.200
     0.977    32.805     0.200
     1.496    47.941     0.200
     1.752    54.684     0.200
     1.772    53.754     0.200
     2.122    64.754     0.200
     2.593    79.625     0.200
     2.992    87.742     0.200
     3.479   102.012     0.200
     4.326   125.031     0.200
     4.358   125.031     0.200
     0.782    25.766     0.200
     0.927    30.164     0.200
     1.001    32.906     0.200
     1.298    37.984     0.200
     1.670    52.359     0.200
     2.279    70.812     0.200
     2.259    67.945     0.200
     2.663    79.672     0.200
     3.200    92.625     0.200
     3.251    93.539     0.200
     4.396   124.953     0.200
     4.484   126.266     0.200
     4.484   134.062     0.200
     4.969   145.023     0.200
     0.095     7.684     0.200
     1.192    37.875     0.200
     1.288    39.715     0.200
     1.651    50.125     0.200
     1.730    53.105     0.200
     2.403    69.754     0.200
     4.029   113.113     0.200
     4.783   133.055     0.200
     0.046     6.812     0.200
     1.240    38.422     0.200
     1.682    50.191     0.200
     1.643    49.750     0.200
     2.574    74.953     0.200
     0.322    12.177     0.200
     0.624    20.887     0.200
     0.876    27.987     0.200
     1.365    41.087     0.200
     1.571    49.177     0.200
     2.213    66.188     0.200
     2.992    85.887     0.200
     3.423    99.467     0.200
     3.782   107.557     0.200
     4.194   118.297     0.200
     4.624   131.807     0.200
     0.356    14.375     0.200
     0.596    19.844     0.200
     1.492    45.773     0.200
     1.758    52.469     0.200
     2.123    64.430     0.200
     2.205    66.898     0.200
     2.302    70.953     0.200
     2.882    84.469     0.200
     3.725   108.312     0.200
     4.738   135.125     0.200
     5.553   155.703     0.200
     0.140     8.609     0.200
     1.610    49.969     0.200
     2.391    69.748     0.200
     3.041    86.918     0.200
     3.634   102.648     0.200
     3.708   106.418     0.200
     3.663   104.648     0.200
     3.733   105.369     0.200
     4.106   120.799     0.200
     4.533   127.258     0.200
     4.533   127.258     0.200
     4.566   127.889     0.200
     4.569   127.918     0.200
     4.571   128.770     0.200
     4.717   133.898     0.200
     0.101     8.574     0.200
     1.021    32.364     0.200
     1.278    39.904     0.200
     1.814    54.715     0.200
     1.736    51.084     0.200
     2.108    64.225     0.200
     0.503    17.970     0.200
     0.941    30.609     0.200
     1.100    34.949     0.200
     1.202    37.941     0.200
     1.502    48.172     0.200
     1.811    55.602     0.200
     4.429   125.852     0.200
     0.228    11.008     0.200
     1.051    33.418     0.200
     1.210    38.891     0.200
     1.313    40.551     0.200
     1.497    45.801     0.200
     1.828    54.570     0.200
     2.198    66.398     0.200
     2.237    66.320     0.200
     2.668    76.230     0.200
     3.063    91.188     0.200
     3.334    96.480     0.200
     3.424    97.219     0.200
     3.397    98.520     0.200
     3.422    98.520     0.200
     3.525   102.988     0.200
     3.490    99.180     0.200
     3.775   107.160     0.200
     3.731   108.891     0.200
     3.844   113.141     0.200
     3.861   112.141     0.200
     3.864   110.371     0.200
     3.901   113.141     0.200
     4.092   114.801     0.200
     4.046   115.801     0.200
     4.128   120.449     0.200
     4.181   120.449     0.200
     4.280   120.668     0.200
     4.301   121.551     0.200
     4.306   120.848     0.200
     4.309   120.320     0.200
     4.380   122.781     0.200
     4.338   121.641     0.200
     4.493   125.680     0.200
     4.742   133.410     0.200
     0.239    11.766     0.200
     1.137    36.453     0.200
     1.397    43.836     0.200
     1.427    45.766     0.200
     1.594    48.102     0.200
     2.744    78.227     0.200
     3.154    89.477     0.200
     4.349   122.531     0.200
     0.470    15.354     0.200
     1.023    33.213     0.200
     1.172    38.814     0.200
     1.641    54.324     0.200
     2.313    73.494     0.200
     2.368    74.084     0.200
     2.390    73.834     0.200
     1.503    46.520     0.200
     1.949    59.961     0.200
     3.211    92.930     0.200
     3.536   102.352     0.200
     3.604   103.992     0.200
     3.758   108.391     0.200
     4.031   113.582     0.200
     4.421   125.191     0.200
     4.617   128.789     0.200
     0.427    14.629     0.200
     1.682    54.387     0.200
     1.429    46.168     0.200
     2.126    66.148     0.200
     2.385    73.488     0.200
     2.379    71.617     0.200
     0.190     8.654     0.200
     1.014    32.114     0.200
     1.275    40.064     0.200
     1.299    40.975     0.200
     1.507    48.104     0.200
     2.629    75.654     0.200
     4.524   126.654     0.200
     0.243    11.432     0.200
     1.106    34.632     0.200
     1.264    40.542     0.200
     1.367    42.602     0.200
     1.390    44.732     0.200
     1.672    50.912     0.200
     1.539    46.482     0.200
     2.236    67.802     0.200
     2.270    68.812     0.200
     3.879   112.552     0.200
     3.789   106.222     0.200
     0.450    14.930     0.200
     1.036    35.380     0.200
     1.152    37.130     0.200
     1.180    38.280     0.200
     1.260    40.680     0.200
     1.650    52.710     0.200
     2.336    71.030     0.200
     2.369    72.950     0.200
     3.375   101.440     0.200
     0.483    15.030     0.200
     1.010    35.170     0.200
     1.137    37.030     0.200
     1.160    38.760     0.200
     1.238    40.850     0.200
     2.343    72.440     0.200
     2.301    74.110     0.200
     2.736    86.800     0.200
     3.178    98.170     0.200
     0.372    13.555     0.200
     1.099    36.992     0.200
     1.184    38.445     0.200
     1.313    42.336     0.200
     1.420    45.352     0.200
     2.062    63.633     0.200
     2.318    70.258     0.200
     2.430    74.547     0.200
     2.430    76.258     0.200
     3.341    96.414     0.200
     3.497   104.688     0.200
     3.648   105.875     0.200
     4.738   137.461     0.200
     0.438    14.235     0.200
     1.129    37.565     0.200
     1.245    42.096     0.200
     1.251    41.605     0.200
     2.360    74.275     0.200
     2.366    73.165     0.200
     2.438    74.565     0.200
     2.556    78.396     0.200
     2.704    83.045     0.200
     3.164    96.085     0.200
     3.339   100.716     0.200
     3.366   101.186     0.200
     3.385   100.655     0.200
     3.670   108.815     0.200
     3.694   108.165     0.200
     4.454   127.905     0.200
     5.038   144.105     0.200
     0.075     8.658     0.200
     0.977    31.307     0.200
     1.136    36.287     0.200
     1.235    38.857     0.200
     1.599    48.338     0.200
     2.575    75.787     0.200
     2.998    84.727     0.200
     4.728   134.107     0.200
     0.395    14.934     0.200
     1.293    41.074     0.200
     1.679    52.992     0.200
     3.358    96.145     0.200
     0.426    13.498     0.200
     1.173    38.008     0.200
     1.211    38.789     0.200
     1.637    53.270     0.200
     2.359    75.629     0.200
     2.392    73.578     0.200
     2.415    73.959     0.200
     0.166     8.469     0.200
     1.205    38.180     0.200
     2.558    73.551     0.200
     3.421    97.570     0.200
     3.500    99.309     0.200
     3.669   105.539     0.200
     3.936   110.789     0.200
     3.943   113.898     0.200
     0.890    27.164     0.200
     1.330    41.961     0.200
     1.742    52.539     0.200
     1.821    57.102     0.200
     1.997    58.961     0.200
     2.507    73.812     0.200
     2.698    77.453     0.200
     3.158    92.562     0.200
     3.547   102.633     0.200
     3.641   108.312     0.200
     3.746   107.562     0.200
     3.856   115.102     0.200
     1.836    54.059     0.200
     2.514    73.727     0.200
     2.930    84.137     0.200
     3.455   103.027     0.200
     3.559   100.379     0.200
     3.629   105.078     0.200
     3.725   106.355     0.200
     3.831   107.688     0.200
     3.891   111.668     0.200
     3.911   112.996     0.200
     3.923   109.777     0.200
     3.947   116.316     0.200
     3.947   117.648     0.200
     3.962   112.996     0.200
     3.965   113.918     0.200
     4.050   114.988     0.200
     4.107   114.988     0.200
     4.150   118.316     0.200
     4.185   120.309     0.200
     4.248   118.977     0.200
     4.387   122.777     0.200
     4.403   125.629     0.200
     4.598   131.059     0.200
     0.474    16.594     0.200
     1.106    36.477     0.200
     1.139    37.930     0.200
     1.221    39.664     0.200
     1.415    44.789     0.200
     1.705    54.227     0.200
     2.158    66.203     0.200
     2.334    71.422     0.200
     2.395    74.703     0.200
     2.430    73.430     0.200
     0.055     9.562     0.200
     0.919    29.732     0.200
     1.176    37.053     0.200
     1.897    57.562     0.200
     2.012    61.713     0.200
     2.814    80.453     0.200
     3.531   100.803     0.200
     3.567   105.004     0.200
     3.575   101.674     0.200
     3.615   103.053     0.200
     3.946   114.303     0.200
     4.009   113.633     0.200
     4.057   114.193     0.200
     0.374    11.751     0.200
     1.488    48.001     0.200
     2.124    64.691     0.200
     2.347    70.771     0.200
     2.468    74.901     0.200
     2.476    76.011     0.200
     2.411    74.851     0.200
     2.466    75.091     0.200
     2.441    73.691     0.200
     2.633    81.241     0.200
     2.854    86.891     0.200
     2.910    90.281     0.200
     3.269    97.351     0.200
     3.299    97.481     0.200
     4.203   122.601     0.200
     0.394    12.061     0.200
     1.150    35.931     0.200
     1.247    41.280     0.200
     2.392    72.521     0.200
     2.424    76.591     0.200
     2.451    74.721     0.200
     2.632    80.161     0.200
     3.464   101.741     0.200
     3.646   106.230     0.200
     3.693   107.341     0.200
     1.734    52.727     0.200
     1.876    56.789     0.200
     1.988    59.938     0.200
     2.501    72.891     0.200
     2.989    87.828     0.200
     3.102    89.352     0.200
     3.628   102.227     0.200
     0.290    13.707     0.200
     0.758    25.527     0.200
     0.915    30.447     0.200
     1.021    32.777     0.200
     1.027    33.908     0.200
     1.956    59.047     0.200
     2.382    71.557     0.200
     2.766    81.348     0.200
     3.560    99.807     0.200
     3.486    99.768     0.200
     4.236   121.727     0.200
     0.346    11.727     0.200
     1.094    36.336     0.200
     1.094    34.328     0.200
     1.150    38.266     0.200
     1.403    44.098     0.200
     2.336    70.738     0.200
     2.507    76.219     0.200
     2.983    86.516     0.200
     3.228    92.945     0.200
     0.364    12.391     0.200
     1.120    36.559     0.200
     1.120    35.441     0.200
     1.376    42.910     0.200
     1.540    47.820     0.200
     2.423    73.461     0.200
     2.481    75.000     0.200
     3.024    87.820     0.200
     3.302    95.148     0.200
     3.634   103.719     0.200
     0.362    12.461     0.200
     1.116    36.461     0.200
     1.277    41.277     0.200
     1.303    41.551     0.200
     1.535    49.000     0.200
     2.351    71.398     0.200
     2.427    73.699     0.200
     2.485    76.551     0.200
     2.873    88.508     0.200
     3.593   104.578     0.200
     3.665   106.617     0.200
     0.358    12.146     0.200
     1.528    48.906     0.200
     1.581    49.467     0.200
     2.174    65.496     0.200
     2.821    82.016     0.200
     3.156    90.775     0.200
     3.250    94.416     0.200
     0.721    23.656     0.200
     1.245    38.883     0.200
     1.385    42.516     0.200
     1.385    43.602     0.200
     1.412    44.609     0.200
     1.496    44.953     0.200
     1.756    53.453     0.200
     2.521    74.102     0.200
     2.892    85.430     0.200
     2.852    83.039     0.200
     2.951    84.430     0.200
     3.140    91.156     0.200
     3.835   109.156     0.200
     0.414    13.471     0.200
     1.041    35.561     0.200
     1.207    38.371     0.200
     1.173    38.602     0.200
     1.205    39.691     0.200
     1.286    42.342     0.200
     1.462    46.412     0.200
     1.650    52.412     0.200
     2.373    73.182     0.200
     2.398    72.711     0.200
     2.434    76.432     0.200
     1.437    45.453     0.200
     1.501    45.984     0.200
     1.722    53.609     0.200
     1.762    53.414     0.200
     2.854    81.578     0.200
     2.975    84.094     0.200
     3.128    89.383     0.200
     3.468    98.242     0.200
     0.477    15.768     0.200
     0.972    33.139     0.200
     1.099    36.559     0.200
     1.133    37.697     0.200
     1.215    39.658     0.200
     1.279    40.607     0.200
     1.403    44.607     0.200
     2.319    71.697     0.200
     2.329    70.787     0.200
     2.470    76.277     0.200
     3.260    97.828     0.200
     3.374   100.438     0.200
     4.259   124.338     0.200
     4.495   128.479     0.200
     0.179     8.760     0.200
     1.115    35.090     0.200
     1.273    39.130     0.200
     1.365    42.060     0.200
     1.431    44.310     0.200
     1.857    56.480     0.200
     2.681    79.190     0.200
     3.118    89.370     0.200
     3.133    92.920     0.200
     3.246    92.230     0.200
     3.548   103.580     0.200
     3.661   103.190     0.200
     4.130   117.230     0.200
     4.909   138.050     0.200
     0.199     7.645     0.200
     1.065    33.074     0.200
     1.452    47.695     0.200
     1.816    54.793     0.200
     2.071    62.266     0.200
     2.219    67.055     0.200
     3.418    97.984     0.200
     0.170     8.488     0.200
     0.268    10.889     0.200
     1.440    44.658     0.200
     1.777    55.769     0.200
     0.135     6.842     0.200
     0.926    30.043     0.200
     1.517    48.252     0.200
     3.549   102.633     0.200
     0.465    15.531     0.200
     0.983    33.131     0.200
     1.107    36.451     0.200
     2.063    65.021     0.200
     2.477    76.840     0.200
     2.411    73.781     0.200
     4.257   124.271     0.200
     0.658    21.406     0.200
     0.793    26.367     0.200
     1.035    33.203     0.200
     1.011    32.836     0.200
     1.812    55.852     0.200
     2.382    71.703     0.200
     3.277    95.016     0.200
     3.288    98.766     0.200
     3.519   103.094     0.200
     3.667   106.656     0.200
     4.058   116.594     0.200
     4.089   117.086     0.200
     4.089   116.836     0.200
     0.473    16.062     0.200
     1.138    36.875     0.200
     1.653    52.395     0.200
     2.401    72.285     0.200
     3.311    99.383     0.200
     1.261    38.578     0.200
     1.411    42.977     0.200
     1.499    46.953     0.200
     1.523    46.664     0.200
     2.094    64.773     0.200
     2.370    71.305     0.200
     2.887    82.477     0.200
     0.782    25.043     0.200
     1.367    43.703     0.200
     1.723    52.801     0.200
     1.848    56.902     0.200
     1.810    56.031     0.200
     2.876    84.602     0.200
     3.030    88.012     0.200
     3.619   105.363     0.200
     3.736   106.023     0.200
     0.323    11.573     0.200
     1.484    49.153     0.200
     1.854    59.643     0.200
     2.473    76.573     0.200
     2.731    83.053     0.200
     3.154    93.393     0.200
     3.226    94.943     0.200
     3.947   115.903     0.200
     4.206   126.573     0.200
     4.330   130.243     0.200
     4.397   130.633     0.200
     4.403   129.723     0.200
     4.441   133.363     0.200
     4.722   142.053     0.200
     0.880    28.401     0.200
     1.137    37.891     0.200
     1.249    39.161     0.200
     1.540    47.701     0.200
     1.647    52.041     0.200
     1.674    52.841     0.200
     1.689    53.141     0.200
     1.721    53.911     0.200
     1.796    55.091     0.200
     1.822    55.151     0.200
     1.973    57.771     0.200
     1.921    58.701     0.200
     2.875    82.461     0.200
     2.889    83.201     0.200
     3.074    86.791     0.200
     3.156    88.971     0.200
     3.687   107.191     0.200
     3.886   110.681     0.200
     4.130   119.031     0.200
     4.315   122.451     0.200
     0.205     9.535     0.200
     1.126    36.305     0.200
     1.384    43.398     0.200
     1.372    43.945     0.200
     1.409    45.637     0.200
     1.418    45.836     0.200
     1.441    45.227     0.200
     1.460    46.457     0.200
     1.579    49.535     0.200
     1.635    50.777     0.200
     1.712    52.438     0.200
     1.842    55.707     0.200
     2.213    66.848     0.200
     2.367    70.777     0.200
     2.694    79.246     0.200
     2.726    80.508     0.200
     3.146    93.156     0.200
     3.501    98.578     0.200
     3.538   100.758     0.200
     3.607   102.156     0.200
     3.663   109.227     0.200
     3.893   110.738     0.200
     3.965   112.695     0.200
     4.049   113.777     0.200
     4.455   126.836     0.200
     0.190     9.865     0.200
     1.127    35.896     0.200
     1.361    43.875     0.200
     1.384    43.595     0.200
     1.381    44.915     0.200
     1.419    46.205     0.200
     1.468    46.885     0.200
     1.480    45.765     0.200
     1.676    51.285     0.200
     1.725    53.055     0.200
     1.821    56.335     0.200
     1.851    56.575     0.200
     1.852    56.055     0.200
     2.719    77.815     0.200
     3.148    89.686     0.200
     3.961   115.775     0.200
     1.460    46.525     0.200
     0.330    13.086     0.200
     0.333     9.883     0.200
     0.399    12.305     0.200
     1.037    33.602     0.200
     1.098    35.852     0.200
     1.121    36.352     0.200
     1.140    37.922     0.200
     1.147    38.484     0.200
     1.110    36.719     0.200
     1.206    38.812     0.200
     1.308    41.727     0.200
     2.285    69.648     0.200
     2.493    79.008     0.200
     2.602    81.078     0.200
     0.485    16.180     0.200
     0.857    28.000     0.200
     0.957    31.081     0.200
     0.954    32.690     0.200
     0.986    31.881     0.200
     1.011    32.841     0.200
     1.059    34.621     0.200
     1.113    35.760     0.200
     1.099    36.170     0.200
     1.164    37.851     0.200
     1.453    46.410     0.200
     1.768    53.450     0.200
     1.944    61.311     0.200
     2.476    75.710     0.200
     2.622    78.510     0.200
     2.964    85.631     0.200
     3.224    95.111     0.200
     3.277    94.061     0.200
     3.363    97.791     0.200
     3.473   101.321     0.200
     3.487   102.250     0.200
     3.597   106.990     0.200
     3.722   108.321     0.200
     3.753   108.321     0.200
     3.778   108.571     0.200
     3.785   108.000     0.200
     3.857   114.160     0.200
     4.152   118.141     0.200
     4.130   121.470     0.200
     4.289   123.031     0.200
     1.096    36.160     0.200
     0.168     8.992     0.200
     1.089    34.772     0.200
     1.223    38.642     0.200
     1.347    42.032     0.200
     1.338    42.812     0.200
     1.375    42.112     0.200
     1.383    43.842     0.200
     1.425    45.042     0.200
     1.431    44.962     0.200
     1.628    50.732     0.200
     1.679    50.862     0.200
     1.754    53.582     0.200
     1.804    55.172     0.200
     1.808    55.632     0.200
     1.803    56.532     0.200
     2.688    76.362     0.200
     2.717    78.412     0.200
     3.118    91.812     0.200
     3.420    96.352     0.200
     1.418    44.772     0.200
     0.227     7.777     0.200
     0.969    32.078     0.200
     1.094    36.618     0.200
     1.231    39.417     0.200
     1.442    47.658     0.200
     1.516    49.478     0.200
     1.750    54.167     0.200
     1.768    54.178     0.200
     1.612    52.667     0.200
     2.137    64.328     0.200
     2.197    66.938     0.200
     2.349    73.018     0.200
     2.589    79.438     0.200
     2.637    79.737     0.200
     0.751    24.902     0.200
     0.753    24.871     0.200
     0.884    28.793     0.200
     0.947    30.023     0.200
     2.540    77.363     0.200
     0.070     4.625     0.200
     0.195     6.961     0.200
     0.304    12.555     0.200
     0.328    13.406     0.200
     0.361    13.805     0.200
     0.672    22.703     0.200
     0.935    29.781     0.200
     1.362    41.547     0.200
     1.592    48.977     0.200
     0.288     9.551     0.200
     0.862    28.711     0.200
     0.909    31.773     0.200
     0.931    30.504     0.200
     0.940    31.730     0.200
     0.966    34.480     0.200
     0.980    32.934     0.200
     1.061    35.184     0.200
     1.090    36.441     0.200
     1.112    35.832     0.200
     1.125    37.922     0.200
     1.208    40.594     0.200
     1.392    44.762     0.200
     2.046    64.441     0.200
     2.146    66.012     0.200
     2.317    72.812     0.200
     2.323    72.512     0.200
     2.883    88.594     0.200
     0.992    34.391     0.200
     0.251    10.211     0.200
     1.169    37.547     0.200
     1.177    36.586     0.200
     1.322    43.008     0.200
     1.258    38.945     0.200
     1.368    41.617     0.200
     1.362    45.398     0.200
     1.403    44.664     0.200
     1.683    51.234     0.200
     1.580    47.719     0.200
     1.691    51.750     0.200
     2.053    61.930     0.200
     2.532    72.609     0.200
     3.874   109.820     0.200
     3.948   111.500     0.200
     3.933   113.055     0.200
     4.436   124.117     0.200
     4.564   129.484     0.200
     1.392    44.289     0.200
     0.242     8.922     0.200
     0.423    13.672     0.200
     0.454    15.414     0.200
     0.971    34.652     0.200
     0.984    32.434     0.200
     1.028    35.594     0.200
     1.041    35.375     0.200
     1.124    37.383     0.200
     1.163    36.762     0.200
     1.224    39.562     0.200
     1.153    38.023     0.200
     1.170    37.492     0.200
     1.371    44.145     0.200
     1.425    45.395     0.200
     2.108    65.504     0.200
     2.382    72.125     0.200
     2.385    73.715     0.200
     3.055    92.441     0.200
     3.257   100.473     0.200
     3.669   109.844     0.200
     0.877    28.104     0.200
     1.437    46.483     0.200
     1.691    52.304     0.200
     1.757    53.443     0.200
     1.864    57.094     0.200
     1.873    57.373     0.200
     1.909    57.543     0.200
     1.946    59.783     0.200
     2.007    59.983     0.200
     2.080    63.873     0.200
     2.253    68.493     0.200
     2.526    73.823     0.200
     2.655    76.733     0.200
     2.789    82.503     0.200
     2.739    79.203     0.200
     3.191    91.193     0.200
     3.357    95.903     0.200
     0.097     7.984     0.200
     0.042     8.789     0.200
     0.074     8.859     0.200
     0.214    10.945     0.200
     0.206    11.289     0.200
     0.197    10.539     0.200
     0.238    11.391     0.200
     0.260    12.656     0.200
     0.369    13.016     0.200
     0.452    16.641     0.200
     0.593    19.398     0.200
     1.142    35.016     0.200
     1.447    44.023     0.200
     1.366    43.117     0.200
     1.590    49.273     0.200
     1.945    56.695     0.200
     3.705   106.438     0.200
     0.820    27.156     0.200
     0.870    29.789     0.200
     1.010    33.070     0.200
     1.212    39.477     0.200
     1.392    44.555     0.200
     1.411    45.719     0.200
     1.421    45.984     0.200
     1.457    47.789     0.200
     1.494    48.211     0.200
     1.556    48.750     0.200
     1.638    51.438     0.200
     1.691    52.469     0.200
     1.668    53.367     0.200
     1.809    56.016     0.200
     2.339    71.430     0.200
     2.533    79.938     0.200
     2.856    85.594     0.200
     2.904    87.359     0.200
     3.093    92.586     0.200
     3.284    97.469     0.200
     3.411   101.000     0.200
     3.686   106.516     0.200
     3.716   108.320     0.200
     0.391    14.803     0.200
     1.276    39.763     0.200
     1.404    44.593     0.200
     1.435    44.032     0.200
     1.479    45.833     0.200
     1.419    45.902     0.200
     1.502    47.412     0.200
     1.538    46.623     0.200
     1.534    49.912     0.200
     1.548    47.772     0.200
     1.533    46.982     0.200
     1.595    48.992     0.200
     1.789    54.952     0.200
     1.825    56.603     0.200
     1.784    55.683     0.200
     2.026    62.192     0.200
     1.964    60.623     0.200
     2.890    82.772     0.200
     3.217    95.873     0.200
     3.288    97.772     0.200
     3.331    98.612     0.200
     3.925   117.152     0.200
     0.130     8.914     0.200
     1.074    34.312     0.200
     1.233    39.023     0.200
     1.328    42.211     0.200
     1.335    42.750     0.200
     1.336    42.305     0.200
     1.376    43.477     0.200
     1.381    44.047     0.200
     1.423    45.523     0.200
     1.494    45.555     0.200
     1.825    57.102     0.200
     1.686    51.953     0.200
     1.751    52.492     0.200
     1.808    54.500     0.200
     2.123    65.930     0.200
     2.542    72.375     0.200
     2.811    81.570     0.200
     3.077    86.773     0.200
     0.243     9.201     0.200
     0.364    12.000     0.200
     1.135    37.281     0.200
     1.539    48.830     0.200
     1.062    35.330     0.200
     1.087    36.910     0.200
     1.110    38.021     0.200
     1.251    41.111     0.200
     1.120    38.580     0.200
     1.217    40.041     0.200
     1.039    34.910     0.200
     1.238    40.441     0.200
     1.533    51.602     0.200
     2.467    75.711     0.200
     3.657   109.400     0.200
     0.249     9.828     0.200
     0.342    11.879     0.200
     0.357    11.906     0.200
     1.065    35.098     0.200
     1.076    33.578     0.200
     1.121    35.758     0.200
     1.101    36.996     0.200
     1.222    39.336     0.200
     1.249    40.516     0.200
     1.268    41.797     0.200
     1.374    44.629     0.200
     1.557    49.578     0.200
     1.527    49.938     0.200
     2.480    75.137     0.200
     0.092     8.771     0.200
     1.007    31.811     0.200
     1.167    36.891     0.200
     1.241    38.561     0.200
     1.265    38.991     0.200
     1.260    40.151     0.200
     1.298    41.811     0.200
     1.305    41.381     0.200
     1.347    42.771     0.200
     1.407    44.341     0.200
     1.541    45.961     0.200
     1.605    49.542     0.200
     1.611    49.101     0.200
     1.725    51.451     0.200
     1.731    52.751     0.200
     1.779    55.511     0.200
     2.365    70.531     0.200
     2.605    76.771     0.200
     3.035    87.101     0.200
     3.473    99.811     0.200
     3.567   102.451     0.200
     0.287    11.700     0.200
     0.395    15.600     0.200
     0.414    16.580     0.200
     0.938    30.290     0.200
     0.991    31.940     0.200
     1.046    33.020     0.200
     1.068    35.070     0.200
     1.078    34.090     0.200
     1.192    35.800     0.200
     1.219    37.390     0.200
     1.243    38.830     0.200
     1.321    41.950     0.200
     1.365    45.790     0.200
     1.537    45.960     0.200
     1.579    46.950     0.200
     2.159    65.420     0.200
     2.195    66.680     0.200
     2.473    71.880     0.200
     2.596    74.830     0.200
     2.657    77.710     0.200
     2.885    82.750     0.200
     2.932    84.130     0.200
     3.008    85.570     0.200
     3.089    89.160     0.200
     3.168    90.360     0.200
     3.490    98.310     0.200
     3.651   106.470     0.200
     3.684   103.130     0.200
     0.273    10.421     0.200
     0.461    15.401     0.200
     0.490    17.371     0.200
     0.932    31.781     0.200
     0.948    30.921     0.200
     0.964    32.041     0.200
     0.989    35.321     0.200
     1.003    33.432     0.200
     1.086    36.051     0.200
     1.116    36.801     0.200
     1.132    35.461     0.200
     1.233    41.001     0.200
     1.557    49.281     0.200
     0.847    28.586     0.200
     0.949    32.566     0.200
     1.230    39.887     0.200
     1.395    43.613     0.200
     1.478    47.504     0.200
     1.506    48.273     0.200
     1.518    48.125     0.200
     1.517    48.293     0.200
     1.552    49.664     0.200
     1.589    50.535     0.200
     1.645    50.766     0.200
     1.737    52.676     0.200
     1.907    58.113     0.200
     2.630    75.734     0.200
     2.997    85.004     0.200
     3.251    91.516     0.200
     1.590    50.137     0.200
     0.530    18.102     0.200
     0.990    30.754     0.200
     0.965    30.223     0.200
     1.223    37.574     0.200
     1.347    43.852     0.200
     1.644    49.844     0.200
     1.741    54.262     0.200
     1.788    56.574     0.200
     1.777    55.352     0.200
     1.788    55.273     0.200
     1.792    59.102     0.200
     1.854    62.602     0.200
     1.824    56.043     0.200
     1.862    58.102     0.200
     1.899    58.562     0.200
     2.021    61.402     0.200
     2.062    63.012     0.200
     2.258    69.133     0.200
     2.189    65.094     0.200
     2.770    80.852     0.200
     3.190    92.582     0.200
     3.214    91.672     0.200
     3.224    92.922     0.200
     3.233    94.402     0.200
     3.236    96.230     0.200
     3.260    93.414     0.200
     3.351    95.914     0.200
     3.552   100.812     0.200
     3.643   104.293     0.200
     3.793   108.672     0.200
     4.012   113.371     0.200
     4.331   124.973     0.200
     4.336   122.203     0.200
     1.862    57.953     0.200
     0.155     9.691     0.200
     0.260    12.262     0.200
     0.321    14.031     0.200
     0.389    14.721     0.200
     0.399    15.451     0.200
     0.392    15.441     0.200
     0.407    16.211     0.200
     0.409    16.322     0.200
     0.423    16.480     0.200
     0.422    14.822     0.200
     0.611    20.131     0.200
     0.640    20.471     0.200
     0.665    21.582     0.200
     0.969    30.291     0.200
     1.158    36.271     0.200
     1.289    38.980     0.200
     1.247    39.162     0.200
     1.473    45.881     0.200
     1.614    49.172     0.200
     1.697    51.730     0.200
     1.718    51.512     0.200
     2.403    69.891     0.200
     0.393    15.971     0.200
     0.188     9.939     0.200
     0.310    12.398     0.200
     0.322    12.479     0.200
     0.380    14.020     0.200
     0.515    17.719     0.200
     0.494    17.568     0.200
     0.507    18.068     0.200
     0.508    18.068     0.200
     0.537    18.879     0.200
     0.564    20.049     0.200
     0.572    20.129     0.200
     0.881    27.258     0.200
     0.930    29.998     0.200
     0.944    28.369     0.200
     1.281    39.189     0.200
     1.434    44.100     0.200
     1.697    51.918     0.200
     2.144    64.309     0.200
     2.187    64.979     0.200
     2.143    64.479     0.200
     2.613    76.379     0.200
     2.889    82.389     0.200
     3.342    96.758     0.200
     0.557    19.838     0.200
     0.108     8.281     0.200
     1.052    34.133     0.200
     1.300    40.863     0.200
     1.318    43.121     0.200
     1.317    42.312     0.200
     1.304    41.023     0.200
     1.359    43.191     0.200
     1.363    44.391     0.200
     1.505    45.152     0.200
     1.404    44.391     0.200
     1.338    44.820     0.200
     1.595    47.832     0.200
     1.671    51.910     0.200
     1.790    54.453     0.200
     1.718    51.230     0.200
     2.090    63.254     0.200
     2.629    75.320     0.200
     2.802    80.371     0.200
     1.396    44.480     0.200
     0.104     6.180     0.200
     0.691    23.180     0.200
     1.278    40.219     0.200
     1.305    41.602     0.200
     1.328    42.961     0.200
     1.334    43.500     0.200
     1.311    40.820     0.200
     1.417    44.922     0.200
     1.472    44.539     0.200
     1.490    46.461     0.200
     1.563    49.609     0.200
     1.682    52.266     0.200
     1.707    52.562     0.200
     1.814    56.570     0.200
     2.060    61.555     0.200
     2.009    62.141     0.200
     2.056    64.430     0.200
     2.263    67.766     0.200
     2.275    67.750     0.200
     2.643    76.484     0.200
     2.475    73.852     0.200
     2.663    77.039     0.200
     2.763    80.234     0.200
     2.757    79.859     0.200
     2.924    84.000     0.200
     3.126    89.703     0.200
     3.390    96.328     0.200
     3.415    98.398     0.200
     3.477   101.883     0.200
     1.363    42.602     0.200
     0.496    17.506     0.200
     0.923    28.706     0.200
     1.023    32.676     0.200
     1.049    34.136     0.200
     1.075    36.556     0.200
     1.096    36.026     0.200
     1.122    37.536     0.200
     1.162    37.116     0.200
     1.180    36.326     0.200
     1.358    42.426     0.200
     1.513    46.386     0.200
     1.831    53.316     0.200
     2.542    75.346     0.200
     1.160    38.126     0.200
     0.277     9.438     0.200
     1.088    35.195     0.200
     1.101    33.895     0.200
     1.125    37.496     0.200
     1.149    38.598     0.200
     1.400    43.887     0.200
     1.510    50.656     0.200
     1.751    57.637     0.200
     1.876    58.734     0.200
     2.238    69.785     0.200
     2.383    73.477     0.200
     2.394    72.168     0.200
     2.340    70.695     0.200
     2.435    77.797     0.200
     2.456    74.234     0.200
     3.023    94.906     0.200
     3.141    91.766     0.200
     3.231    93.637     0.200
     3.237    95.086     0.200
     4.098   117.688     0.200
     4.938   141.605     0.200
     1.168    38.984     0.200
     0.934    29.410     0.200
     1.031    32.211     0.200
     1.510    45.250     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
