#!/bin/bash
gmt begin caleta1.47_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source caleta1.47'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.731     0.284     0.200
     0.085     1.002     0.200
     0.929     0.036     0.200
     0.559     0.372     0.200
     0.820     0.199     0.200
     0.674     0.381     0.200
     0.226    -0.017     0.200
     0.489     0.069     0.200
     0.837    -0.033     0.200
     0.961     0.121     0.200
     0.753     0.116     0.200
     0.483    -0.045     0.200
     0.434    -0.099     0.200
     0.926    -0.490     0.200
     0.452     0.264     0.200
     0.211     0.169     0.200
     0.923    -0.450     0.200
     0.942    -0.294     0.200
     0.733     0.000     0.200
     0.081     0.032     0.200
     0.701     0.003     0.200
     0.950    -0.334     0.200
     0.966    -0.149     0.200
     0.442     0.282     0.200
     0.089     0.162     0.200
     0.954    -0.226     0.200
     0.282    -0.477     0.200
     0.282    -0.737     0.200
     0.559    -0.761     0.200
     0.559    -0.402     0.200
     0.655    -0.524     0.200
     0.655    -0.063     0.200
     0.730    -0.424     0.200
     0.957     0.181     0.200
     0.612     0.076     0.200
     0.880    -0.398     0.200
     0.582     0.145     0.200
     0.108     0.377     0.200
     0.824    -0.779     0.200
     0.901    -0.269     0.200
     0.997    -0.753     0.200
     0.081     0.186     0.200
     0.876    -0.301     0.200
     0.949    -0.284     0.200
     0.045     0.057     0.200
     0.904    -0.012     0.200
     0.564    -0.032     0.200
     0.636    -0.471     0.200
     0.915     0.349     0.200
     0.937    -0.033     0.200
     0.055     0.051     0.200
     0.958    -0.701     0.200
     1.000    -0.211     0.200
     0.032    -0.206     0.200
     0.922    -0.547     0.200
     0.950     0.231     0.200
     0.825     0.632     0.200
     0.849     0.007     0.200
     0.837     0.465     0.200
     0.847     0.646     0.200
     0.858     0.877     0.200
     0.879     0.648     0.200
     0.992    -0.156     0.200
     0.934     0.394     0.200
     0.075     0.083     0.200
     0.062     0.534     0.200
     0.057     0.262     0.200
     0.070     0.320     0.200
     0.087     0.340     0.200
     0.103     0.025     0.200
     0.308    -0.156     0.200
     0.241    -0.394     0.200
     0.301    -0.752     0.200
     0.676    -0.591     0.200
     0.130     0.153     0.200
     0.787    -0.145     0.200
     0.781     0.208     0.200
     0.015     0.003     0.200
     0.916    -0.257     0.200
     0.959    -0.308     0.200
     0.078     0.106     0.200
     0.124    -0.339     0.200
     0.306    -0.314     0.200
     0.409    -0.337     0.200
     0.458    -0.379     0.200
     0.587     0.199     0.200
     0.606     0.361     0.200
     0.636     0.098     0.200
     0.647     0.216     0.200
     0.651     0.325     0.200
     0.815    -0.193     0.200
     0.874    -1.453     0.200
     0.055     0.052     0.200
     0.851    -0.841     0.200
     0.901    -0.127     0.200
     0.729    -0.187     0.200
     0.814    -0.235     0.200
     0.552     0.054     0.200
     0.671    -0.293     0.200
     0.752    -0.613     0.200
     0.806    -0.103     0.200
     0.863    -0.289     0.200
     0.865    -0.116     0.200
     0.090    -1.049     0.200
     0.534     0.127     0.200
     0.726     0.425     0.200
     0.747     0.196     0.200
     0.767     0.131     0.200
     0.920    -0.152     0.200
     0.487    -0.494     0.200
     0.889    -0.311     0.200
     0.635     0.167     0.200
     0.789     0.050     0.200
     0.121     0.001     0.200
     0.791    -0.679     0.200
     0.126    -0.075     0.200
     0.829    -0.791     0.200
     0.426     0.011     0.200
     0.659     0.031     0.200
     0.884    -0.400     0.200
     0.462     0.055     0.200
     0.515     0.247     0.200
     0.559     0.608     0.200
     0.569     0.339     0.200
     0.613    -0.244     0.200
     0.645    -0.497     0.200
     0.733     0.062     0.200
     0.743     0.014     0.200
     0.439     0.100     0.200
     0.250     0.212     0.200
     0.499    -0.109     0.200
     0.933    -0.451     0.200
     0.993     0.056     0.200
     0.260    -0.339     0.200
     0.057     0.346     0.200
     0.052     0.086     0.200
     0.855    -0.540     0.200
     0.507    -0.072     0.200
     0.256     0.642     0.200
     0.127     0.008     0.200
     0.122     0.135     0.200
     0.071     0.201     0.200
     0.277     0.005     0.200
     0.874    -0.239     0.200
     0.245     0.407     0.200
     0.188    -0.119     0.200
     0.942     1.619     0.200
     0.690     0.351     0.200
     0.802    -0.517     0.200
     0.482    -0.149     0.200
     0.973    -0.248     0.200
     0.195     0.039     0.200
     0.995     0.268     0.200
     0.183     0.305     0.200
     0.662    -0.208     0.200
     0.969     0.252     0.200
     0.306     0.341     0.200
     0.699    -0.371     0.200
     0.901     0.181     0.200
     0.854    -0.632     0.200
     0.871    -0.142     0.200
     0.131     0.011     0.200
     0.053    -0.263     0.200
     0.086    -0.273     0.200
     0.977     0.327     0.200
     0.503    -0.238     0.200
     0.751     0.052     0.200
     0.884     0.270     0.200
     0.945    -0.227     0.200
     0.192     0.151     0.200
     0.243     0.114     0.200
     0.090     0.043     0.200
     0.921    -0.132     0.200
     0.200    -0.004     0.200
     0.838    -0.189     0.200
     0.987     0.085     0.200
     0.788     0.527     0.200
     0.852     0.082     0.200
     0.977     0.166     0.200
     0.782     0.018     0.200
     0.927    -0.071     0.200
     0.095     0.078     0.200
     0.046     0.100     0.200
     0.985    -0.218     0.200
     0.322     0.058     0.200
     0.624    -0.005     0.200
     0.782     0.042     0.200
     0.876    -0.526     0.200
     0.356     0.040     0.200
     0.596    -0.042     0.200
     0.755     0.307     0.200
     0.855    -0.449     0.200
     0.140    -0.117     0.200
     0.805     0.238     0.200
     0.964     0.243     0.200
     0.101     0.062     0.200
     0.503    -0.159     0.200
     0.941     0.292     0.200
     0.228    -0.073     0.200
     0.239     0.001     0.200
     0.470     0.164     0.200
     0.808    -0.474     0.200
     0.967     0.007     0.200
     0.427     0.442     0.200
     0.190     0.079     0.200
     0.243     0.108     0.200
     0.450     0.269     0.200
     0.483    -0.233     0.200
     0.372     0.505     0.200
     0.438    -0.299     0.200
     0.075     0.089     0.200
     0.977    -0.220     0.200
     0.395     0.489     0.200
     0.426    -0.131     0.200
     0.166     0.110     0.200
     0.944     0.091     0.200
     0.890    -0.366     0.200
     0.898    -0.176     0.200
     0.474     0.061     0.200
     0.055     0.111     0.200
     0.919    -0.374     0.200
     0.374    -0.236     0.200
     0.394    -0.279     0.200
     0.896    -0.366     0.200
     0.290    -0.062     0.200
     0.758    -0.340     0.200
     0.915    -0.146     0.200
     0.346     0.067     0.200
     0.364     0.143     0.200
     0.362     0.763     0.200
     0.358    -0.177     0.200
     0.721     0.087     0.200
     0.414     0.131     0.200
     0.727     0.250     0.200
     0.477     0.161     0.200
     0.972     1.561     0.200
     0.179     0.109     0.200
     0.199     0.163     0.200
     0.907     0.109     0.200
     0.170    -0.322     0.200
     0.268    -0.250     0.200
     0.135     0.170     0.200
     0.926    -0.258     0.200
     0.465     0.308     0.200
     0.983     1.148     0.200
     0.658     0.011     0.200
     0.793     0.180     0.200
     0.473     1.214     0.200
     0.991     0.809     0.200
     0.487     0.086     0.200
     0.782     0.291     0.200
     0.999    -0.301     0.200
     0.880     0.357     0.200
     0.205     0.172     0.200
     0.190     0.062     0.200
     0.330     1.457     0.200
     0.333    -0.208     0.200
     0.399    -0.117     0.200
     0.485     0.294     0.200
     0.857     0.039     0.200
     0.957     0.130     0.200
     0.954     0.749     0.200
     0.986     0.400     0.200
     0.168     0.082     0.200
     0.227     0.268     0.200
     0.969     0.146     0.200
     0.751     0.013     0.200
     0.753    -0.186     0.200
     0.878     0.603     0.200
     0.884    -0.474     0.200
     0.947    -1.034     0.200
     0.070    -0.615     0.200
     0.195    -0.973     0.200
     0.304     0.295     0.200
     0.328     0.212     0.200
     0.361     0.252     0.200
     0.672    -0.231     0.200
     0.935    -0.420     0.200
     0.346     0.329     0.200
     0.288     0.195     0.200
     0.482    -0.484     0.200
     0.862     0.115     0.200
     0.909     0.706     0.200
     0.931    -0.526     0.200
     0.940     0.179     0.200
     0.966     0.804     0.200
     0.980     0.299     0.200
     0.992     0.357     0.200
     0.251     0.305     0.200
     0.242     0.591     0.200
     0.423     0.328     0.200
     0.454     0.183     0.200
     0.971     0.896     0.200
     0.984     0.130     0.200
     0.877    -0.303     0.200
     0.097    -0.341     0.200
     0.042     0.024     0.200
     0.074     0.173     0.200
     0.214     0.082     0.200
     0.206     0.229     0.200
     0.197    -0.016     0.200
     0.238    -0.048     0.200
     0.260     0.355     0.200
     0.369    -0.733     0.200
     0.452    -0.041     0.200
     0.547    -0.414     0.200
     0.593    -0.883     0.200
     0.820     0.172     0.200
     0.870     0.860     0.200
     0.391     0.306     0.200
     0.130     0.119     0.200
     0.243     0.720     0.200
     0.364    -0.122     0.200
     0.249     1.100     0.200
     0.342     0.563     0.200
     0.357     0.061     0.200
     0.092     0.249     0.200
     0.287    -0.266     0.200
     0.395     0.964     0.200
     0.414     0.824     0.200
     0.991     0.375     0.200
     0.273     0.899     0.200
     0.461     0.170     0.200
     0.490     0.938     0.200
     0.932     0.636     0.200
     0.938     0.276     0.200
     0.948     0.631     0.200
     0.964     0.168     0.200
     0.989     1.546     0.200
     0.847    -0.191     0.200
     0.949     1.092     0.200
     0.530    -0.117     0.200
     0.990    -0.005     0.200
     0.965     0.280     0.200
     0.155    -0.121     0.200
     0.260     0.005     0.200
     0.321     0.047     0.200
     0.389    -0.317     0.200
     0.399     0.093     0.200
     0.392     0.048     0.200
     0.407    -0.081     0.200
     0.409    -0.124     0.200
     0.423     0.064     0.200
     0.447    -0.162     0.200
     0.422    -0.733     0.200
     0.611    -2.052     0.200
     0.640    -0.874     0.200
     0.665    -0.745     0.200
     0.692    -0.552     0.200
     0.393    -0.018     0.200
     0.310     0.176     0.200
     0.322     0.340     0.200
     0.380    -0.125     0.200
     0.515     0.091     0.200
     0.494     0.266     0.200
     0.507     0.028     0.200
     0.508     0.127     0.200
     0.537     0.120     0.200
     0.564     0.133     0.200
     0.572     0.011     0.200
     0.721    -0.838     0.200
     0.835    -0.332     0.200
     0.881    -0.587     0.200
     0.930    -0.626     0.200
     0.944    -1.016     0.200
     0.108    -0.069     0.200
     0.104     0.393     0.200
     0.691     0.865     0.200
     0.964     0.631     0.200
     0.496     0.103     0.200
     0.923    -0.357     0.200
     0.954     1.088     0.200
     0.277     0.721     0.200
     0.934     0.026     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.728    -0.054     0.200
     0.949    -1.487     0.200
     0.926    -0.152     0.200
     0.194     1.284     0.200
     0.572     0.623     0.200
     0.795    -0.325     0.200
     0.965    -0.451     0.200
     0.099     0.863     0.200
     0.463     0.264     0.200
     0.553     0.317     0.200
     0.950    -0.439     0.200
     0.408    -0.028     0.200
     0.566    -0.460     0.200
     0.710    -0.355     0.200
     0.906    -1.135     0.200
     0.249    -0.569     0.200
     0.934    -0.225     0.200
     0.286    -0.612     0.200
     0.964    -1.027     0.200
     0.786    -0.251     0.200
     0.779     0.181     0.200
     0.794     0.046     0.200
     0.995     0.239     0.200
     0.943     0.045     0.200
     0.679    -0.210     0.200
     0.599    -1.741     0.200
     0.794    -0.414     0.200
     0.125    -0.117     0.200
     0.361    -0.159     0.200
     0.756     0.616     0.200
     0.908    -0.202     0.200
     0.300    -0.375     0.200
     0.867    -0.505     0.200
     0.953    -0.494     0.200
     0.874    -0.518     0.200
     0.774    -0.152     0.200
     0.875    -0.996     0.200
     0.287    -0.485     0.200
     0.798    -0.842     0.200
     0.906     0.166     0.200
     0.978     1.517     0.200
     0.641    -0.852     0.200
     0.911    -0.942     0.200
     0.791     0.171     0.200
     0.820    -1.430     0.200
     0.414    -0.409     0.200
     0.901    -0.874     0.200
     0.948    -1.996     0.200
     0.923    -0.556     0.200
     0.929     0.022     0.200
     0.938     0.118     0.200
     0.947     0.244     0.200
     0.962     0.248     0.200
     0.982     0.070     0.200
     0.980    -0.670     0.200
     0.318    -0.750     0.200
     0.849    -0.290     0.200
     0.470    -0.588     0.200
     0.603     0.141     0.200
     0.617     0.481     0.200
     0.643     0.340     0.200
     0.655     0.266     0.200
     0.694    -0.245     0.200
     0.730    -0.599     0.200
     0.728    -0.465     0.200
     0.712    -0.057     0.200
     0.433    -0.545     0.200
     0.475    -1.120     0.200
     0.267    -0.838     0.200
     0.684    -0.375     0.200
     0.807    -0.997     0.200
     0.305    -0.631     0.200
     0.694    -1.141     0.200
     0.858    -0.020     0.200
     0.781    -0.015     0.200
     0.554    -0.098     0.200
     0.919    -0.753     0.200
     0.883    -1.309     0.200
     0.600    -1.110     0.200
     0.880     0.208     0.200
     0.881    -0.121     0.200
     0.917     0.385     0.200
     0.931     0.307     0.200
     0.997     0.089     0.200
     0.282    -0.563     0.200
     0.918    -0.524     0.200
     0.996     0.138     0.200
     0.051    -0.214     0.200
     0.209     0.241     0.200
     0.232     0.142     0.200
     0.521    -0.697     0.200
     0.242    -0.531     0.200
     0.866    -0.423     0.200
     0.966    -0.035     0.200
     0.799    -0.164     0.200
     0.580     0.112     0.200
     0.250    -0.659     0.200
     0.977    -0.241     0.200
     0.488    -0.230     0.200
     0.970     0.962     0.200
     0.870     0.166     0.200
     0.849    -0.117     0.200
     0.458    -0.467     0.200
     0.953    -0.572     0.200
     0.805     0.352     0.200
     0.327    -0.961     0.200
     0.721    -0.454     0.200
     0.877     0.282     0.200
     0.983    -0.157     0.200
     0.633    -0.454     0.200
     0.966    -0.087     0.200
     0.281    -0.769     0.200
     0.719    -0.542     0.200
     0.877     0.179     0.200
     0.980    -0.048     0.200
     0.300    -0.464     0.200
     0.743    -0.419     0.200
     0.250    -0.297     0.200
     0.736    -0.616     0.200
     0.997    -0.197     0.200
     0.307    -0.468     0.200
     0.975    -0.600     0.200
     0.581     0.249     0.200
     0.656     0.303     0.200
     0.868     0.004     0.200
     0.539    -1.015     0.200
     0.760    -0.363     0.200
     0.854     0.169     0.200
     0.902     0.207     0.200
     0.912    -0.152     0.200
     0.923     0.495     0.200
     0.949     0.471     0.200
     0.989     0.303     0.200
     0.986     0.527     0.200
     0.211    -0.428     0.200
     0.842    -0.532     0.200
     0.969    -0.039     0.200
     1.000    -0.017     0.200
     0.235    -0.131     0.200
     0.752    -0.565     0.200
     0.883    -0.003     0.200
     0.911     0.409     0.200
     0.994    -0.075     0.200
     0.074    -0.159     0.200
     0.121     0.090     0.200
     0.139     0.073     0.200
     0.205    -0.119     0.200
     0.330     0.278     0.200
     0.334     0.076     0.200
     0.354     0.248     0.200
     0.386     0.116     0.200
     0.387     0.321     0.200
     0.532    -0.391     0.200
     0.591    -0.186     0.200
     0.697    -0.365     0.200
     0.755    -0.238     0.200
     0.919    -0.331     0.200
     0.993    -0.534     0.200
     0.592    -0.217     0.200
     0.692     0.150     0.200
     0.901     0.064     0.200
     0.204     0.672     0.200
     0.674     0.111     0.200
     0.720     0.419     0.200
     0.932     1.134     0.200
     0.476    -0.673     0.200
     0.853    -0.059     0.200
     0.912    -0.676     0.200
     0.298    -0.497     0.200
     0.759    -0.605     0.200
     0.882     0.068     0.200
     0.916     0.285     0.200
     0.957     0.132     0.200
     0.978     0.232     0.200
     0.981     0.404     0.200
     0.062    -0.369     0.200
     0.883    -0.661     0.200
     0.716    -0.157     0.200
     0.780    -0.102     0.200
     0.992     0.388     0.200
     0.969    -0.455     0.200
     0.906    -1.216     0.200
     0.937    -0.444     0.200
     0.362    -0.574     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.085     0.586     0.200
     0.929    -0.676     0.200
     0.559     1.345     0.200
     0.820    -0.378     0.200
     0.226     0.131     0.200
     0.489     0.283     0.200
     0.837     0.029     0.200
     0.961    -0.298     0.200
     0.753    -0.285     0.200
     0.483     0.803     0.200
     0.434     0.400     0.200
     0.452    -0.195     0.200
     0.211     0.117     0.200
     0.942    -0.955     0.200
     0.794    -0.704     0.200
     0.081    -0.329     0.200
     0.756    -0.188     0.200
     0.756    -0.478     0.200
     0.950     0.101     0.200
     0.966     0.455     0.200
     0.089     0.111     0.200
     0.954     0.416     0.200
     0.282    -1.552     0.200
     0.559    -0.612     0.200
     0.559    -0.339     0.200
     0.655     0.153     0.200
     0.655     0.301     0.200
     0.730    -0.240     0.200
     0.957     0.183     0.200
     0.612     0.167     0.200
     0.908    -1.034     0.200
     0.108     0.885     0.200
     0.824    -0.513     0.200
     0.901     0.432     0.200
     0.997    -0.904     0.200
     0.081    -0.148     0.200
     0.876    -0.409     0.200
     0.949    -0.080     0.200
     0.045    -0.191     0.200
     0.904     0.011     0.200
     0.636    -0.881     0.200
     0.875     1.242     0.200
     0.937     0.675     0.200
     0.055     0.015     0.200
     0.958    -0.314     0.200
     1.000    -0.171     0.200
     0.032    -0.401     0.200
     0.825     0.142     0.200
     0.849     0.349     0.200
     0.837     1.343     0.200
     0.847     0.192     0.200
     0.847     1.582     0.200
     0.858     0.093     0.200
     0.879     0.927     0.200
     0.992    -0.213     0.200
     0.934     0.910     0.200
     0.075    -0.038     0.200
     0.980    -0.979     0.200
     0.062     0.330     0.200
     0.057     0.294     0.200
     0.070     0.068     0.200
     0.087     0.006     0.200
     0.103    -0.149     0.200
     0.308    -0.697     0.200
     0.241    -0.553     0.200
     0.301    -1.126     0.200
     0.676    -1.131     0.200
     0.130    -0.510     0.200
     0.787    -0.258     0.200
     0.781     0.192     0.200
     0.015    -0.023     0.200
     0.078    -0.417     0.200
     0.124    -0.481     0.200
     0.306    -0.744     0.200
     0.409     0.017     0.200
     0.458    -0.254     0.200
     0.587     0.797     0.200
     0.636     1.528     0.200
     0.647     1.558     0.200
     0.651     1.627     0.200
     0.815     0.300     0.200
     0.874    -1.815     0.200
     0.055     0.109     0.200
     0.851    -0.386     0.200
     0.729    -0.083     0.200
     0.814     0.499     0.200
     0.433    -0.829     0.200
     0.671     0.484     0.200
     0.752     0.369     0.200
     0.806     0.961     0.200
     0.863     0.887     0.200
     0.865     1.115     0.200
     0.090    -1.481     0.200
     0.534     0.568     0.200
     0.547     0.290     0.200
     0.726     0.905     0.200
     0.720    -0.176     0.200
     0.747     1.021     0.200
     0.767     0.072     0.200
     0.782     0.631     0.200
     0.920     0.273     0.200
     0.487    -0.740     0.200
     0.635    -0.024     0.200
     0.121     0.277     0.200
     0.791    -0.020     0.200
     0.126     0.077     0.200
     0.829     0.297     0.200
     0.426     0.424     0.200
     0.659     0.407     0.200
     0.884    -0.148     0.200
     0.515     1.048     0.200
     0.559     0.927     0.200
     0.569     1.177     0.200
     0.613    -0.580     0.200
     0.645    -1.141     0.200
     0.733     0.185     0.200
     0.743    -0.085     0.200
     0.439     0.503     0.200
     0.250     0.052     0.200
     0.499    -0.172     0.200
     0.260    -0.079     0.200
     0.057     0.513     0.200
     0.052    -0.094     0.200
     0.855    -0.527     0.200
     0.507     0.281     0.200
     0.256     0.474     0.200
     0.127    -0.210     0.200
     0.122    -0.399     0.200
     0.580    -0.087     0.200
     0.071    -0.010     0.200
     0.277     0.590     0.200
     0.874     0.226     0.200
     0.977    -0.344     0.200
     0.999    -0.660     0.200
     0.245     0.218     0.200
     0.188    -0.929     0.200
     0.690    -0.384     0.200
     0.195     0.533     0.200
     0.183     0.939     0.200
     0.969     0.387     0.200
     0.306     0.165     0.200
     0.306    -0.726     0.200
     0.699    -0.771     0.200
     0.854    -1.054     0.200
     0.871     0.154     0.200
     0.131    -0.272     0.200
     0.053    -0.223     0.200
     0.086    -0.338     0.200
     0.503     0.187     0.200
     0.751    -0.317     0.200
     0.884     0.880     0.200
     0.945    -0.017     0.200
     0.945    -1.017     0.200
     0.192    -0.154     0.200
     0.243    -0.099     0.200
     0.090    -0.607     0.200
     0.200    -0.025     0.200
     0.838     0.126     0.200
     0.987     0.036     0.200
     0.977     0.695     0.200
     0.782    -0.132     0.200
     0.927    -0.222     0.200
     0.095    -0.124     0.200
     0.046     0.470     0.200
     0.322    -0.117     0.200
     0.624     0.009     0.200
     0.876    -0.235     0.200
     0.356     0.525     0.200
     0.596    -0.533     0.200
     0.140     0.137     0.200
     0.101    -0.493     0.200
     0.503     0.777     0.200
     0.941    -0.324     0.200
     0.228     0.103     0.200
     0.239    -0.296     0.200
     0.470    -0.119     0.200
     0.427     0.142     0.200
     0.190    -0.050     0.200
     0.243     0.035     0.200
     0.450     0.138     0.200
     0.483    -0.857     0.200
     0.372     0.958     0.200
     0.438    -0.192     0.200
     0.075    -0.655     0.200
     0.977     0.042     0.200
     0.395     0.811     0.200
     0.426    -0.525     0.200
     0.166     0.115     0.200
     0.890    -1.244     0.200
     0.474     0.975     0.200
     0.055    -0.379     0.200
     0.919    -0.043     0.200
     0.374    -0.600     0.200
     0.394    -0.921     0.200
     0.290     0.444     0.200
     0.758     0.229     0.200
     0.915     0.810     0.200
     0.346    -0.054     0.200
     0.364    -0.024     0.200
     0.362     0.519     0.200
     0.358    -0.284     0.200
     0.721     0.102     0.200
     0.414    -0.165     0.200
     0.477     0.062     0.200
     0.972     1.170     0.200
     0.179    -0.418     0.200
     0.199     0.101     0.200
     0.170    -0.465     0.200
     0.268    -0.140     0.200
     0.135    -0.054     0.200
     0.926     0.222     0.200
     0.465     0.220     0.200
     0.983     0.806     0.200
     0.658    -0.192     0.200
     0.793     0.333     0.200
     0.473     0.431     0.200
     0.782    -0.833     0.200
     0.323     0.762     0.200
     0.880     0.173     0.200
     0.205    -0.172     0.200
     0.190    -0.309     0.200
     0.330     2.169     0.200
     0.333    -1.147     0.200
     0.399    -0.842     0.200
     0.485    -0.137     0.200
     0.857    -0.271     0.200
     0.957    -0.310     0.200
     0.954     1.169     0.200
     0.986    -0.435     0.200
     0.168    -0.365     0.200
     0.227     0.069     0.200
     0.969     0.309     0.200
     0.751    -0.038     0.200
     0.753    -0.133     0.200
     0.884    -0.312     0.200
     0.947    -0.745     0.200
     0.070    -1.097     0.200
     0.195    -1.403     0.200
     0.304     1.205     0.200
     0.328     1.214     0.200
     0.361     0.587     0.200
     0.672     0.125     0.200
     0.935    -0.358     0.200
     0.288     0.020     0.200
     0.862     0.445     0.200
     0.909     1.920     0.200
     0.931    -0.048     0.200
     0.940     0.877     0.200
     0.966     2.711     0.200
     0.980     0.660     0.200
     0.992     1.748     0.200
     0.251    -0.532     0.200
     0.242     0.895     0.200
     0.423    -0.242     0.200
     0.454     0.453     0.200
     0.971     2.794     0.200
     0.984     0.158     0.200
     0.877    -0.193     0.200
     0.097    -1.186     0.200
     0.042     0.288     0.200
     0.074     0.082     0.200
     0.214    -0.403     0.200
     0.206     0.395     0.200
     0.197     0.046     0.200
     0.238    -0.586     0.200
     0.260     0.611     0.200
     0.369    -1.409     0.200
     0.452     0.079     0.200
     0.593    -1.098     0.200
     0.820     0.221     0.200
     0.870     1.142     0.200
     0.391    -0.060     0.200
     0.130    -0.501     0.200
     0.243     1.129     0.200
     0.364     0.001     0.200
     0.249     1.569     0.200
     0.342     0.569     0.200
     0.357     0.124     0.200
     0.092    -0.446     0.200
     0.287    -1.115     0.200
     0.395     0.241     0.200
     0.414     0.863     0.200
     0.938     0.125     0.200
     0.991     0.242     0.200
     0.273     1.343     0.200
     0.461     0.240     0.200
     0.490     1.212     0.200
     0.932     1.179     0.200
     0.948    -0.182     0.200
     0.964     0.417     0.200
     0.989     2.800     0.200
     0.847     1.154     0.200
     0.949     1.941     0.200
     0.530     0.176     0.200
     0.990    -1.073     0.200
     0.965    -0.887     0.200
     0.155    -0.237     0.200
     0.260     0.558     0.200
     0.321     0.888     0.200
     0.389    -0.112     0.200
     0.399     0.136     0.200
     0.392     0.684     0.200
     0.407     0.503     0.200
     0.409     0.447     0.200
     0.423     0.605     0.200
     0.422    -0.947     0.200
     0.611    -0.752     0.200
     0.640    -1.340     0.200
     0.665    -0.841     0.200
     0.969    -0.542     0.200
     0.393     0.594     0.200
     0.188     0.760     0.200
     0.310     0.342     0.200
     0.322     0.056     0.200
     0.380    -0.055     0.200
     0.515     0.056     0.200
     0.494     0.213     0.200
     0.507     0.442     0.200
     0.508     0.356     0.200
     0.537     0.165     0.200
     0.564     0.707     0.200
     0.572     0.324     0.200
     0.881    -1.136     0.200
     0.930     0.386     0.200
     0.944    -1.893     0.200
     0.557     0.524     0.200
     0.108    -0.158     0.200
     0.104    -0.412     0.200
     0.691    -0.113     0.200
     0.496     0.150     0.200
     0.923    -0.850     0.200
     0.277     0.167     0.200
     0.934    -0.750     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.463    -0.832     0.200
     0.553     0.114     0.200
     0.950    -0.226     0.200
     0.408    -1.201     0.200
     0.566    -0.560     0.200
     0.710    -0.460     0.200
     0.906    -0.847     0.200
     0.249    -0.658     0.200
     0.934     0.101     0.200
     0.286    -0.529     0.200
     0.964    -1.326     0.200
     0.786    -0.531     0.200
     0.779    -0.501     0.200
     0.794    -0.058     0.200
     0.995     0.302     0.200
     0.943    -0.886     0.200
     0.926     0.284     0.200
     0.923    -0.762     0.200
     0.679    -0.661     0.200
     0.599    -0.718     0.200
     0.599    -0.554     0.200
     0.733    -0.307     0.200
     0.125     0.097     0.200
     0.361     0.273     0.200
     0.957     0.179     0.200
     0.880    -0.428     0.200
     0.582     0.391     0.200
     0.300    -0.183     0.200
     0.867    -0.249     0.200
     0.953    -0.945     0.200
     0.874    -0.732     0.200
     0.774    -0.096     0.200
     0.875    -0.594     0.200
     0.564    -1.128     0.200
     0.287    -0.356     0.200
     0.798    -1.182     0.200
     0.906    -0.148     0.200
     0.973    -1.373     0.200
     0.922    -0.751     0.200
     0.950    -0.106     0.200
     0.911    -1.131     0.200
     0.791     0.683     0.200
     0.820    -0.564     0.200
     0.414    -0.144     0.200
     0.901    -1.598     0.200
     0.948    -2.523     0.200
     0.923    -0.363     0.200
     0.929     1.143     0.200
     0.938     1.548     0.200
     0.947     1.501     0.200
     0.962     1.853     0.200
     0.982     1.771     0.200
     0.916    -0.482     0.200
     0.959    -0.581     0.200
     0.980    -0.046     0.200
     0.901    -0.207     0.200
     0.318    -0.727     0.200
     0.849     0.492     0.200
     0.470    -0.447     0.200
     0.603     0.766     0.200
     0.604     0.334     0.200
     0.617    -0.031     0.200
     0.643     0.102     0.200
     0.655     0.438     0.200
     0.694    -0.001     0.200
     0.730    -0.804     0.200
     0.728    -0.387     0.200
     0.712    -0.904     0.200
     0.552     0.051     0.200
     0.475    -1.778     0.200
     0.267    -0.976     0.200
     0.684    -0.204     0.200
     0.807     0.264     0.200
     0.305    -0.400     0.200
     0.889    -1.246     0.200
     0.694    -1.044     0.200
     0.858     0.324     0.200
     0.789     0.194     0.200
     0.781     0.117     0.200
     0.462    -0.035     0.200
     0.883    -1.925     0.200
     0.600    -1.146     0.200
     0.880     1.415     0.200
     0.961     0.829     0.200
     0.917     1.865     0.200
     0.997     2.121     0.200
     0.933    -1.124     0.200
     0.993    -0.057     0.200
     0.282    -0.288     0.200
     0.918    -0.678     0.200
     0.996     0.229     0.200
     0.051    -0.088     0.200
     0.209     0.256     0.200
     0.232     0.387     0.200
     0.521    -0.306     0.200
     0.242    -0.414     0.200
     0.866    -1.029     0.200
     0.966     0.498     0.200
     0.799     0.113     0.200
     0.250    -0.304     0.200
     0.488     0.155     0.200
     0.970    -0.005     0.200
     0.870     0.281     0.200
     0.482     0.273     0.200
     0.973    -0.594     0.200
     0.662    -0.088     0.200
     0.901     0.495     0.200
     0.849    -0.824     0.200
     0.458    -0.567     0.200
     0.953    -1.116     0.200
     0.805     0.821     0.200
     0.921    -0.502     0.200
     0.788    -1.126     0.200
     0.852    -0.214     0.200
     0.985    -0.278     0.200
     0.327    -0.723     0.200
     0.721    -0.324     0.200
     0.877     0.854     0.200
     0.983     0.450     0.200
     0.782    -0.156     0.200
     0.755     0.095     0.200
     0.855    -0.717     0.200
     0.805    -0.552     0.200
     0.964     0.855     0.200
     0.633    -0.192     0.200
     0.966    -0.661     0.200
     0.808     0.467     0.200
     0.967     1.314     0.200
     0.944    -0.458     0.200
     0.281    -0.475     0.200
     0.719    -0.563     0.200
     0.877     0.303     0.200
     0.980     0.608     0.200
     0.727     0.868     0.200
     0.907    -1.142     0.200
     0.300    -0.566     0.200
     0.743    -0.979     0.200
     0.487    -0.594     0.200
     0.250    -0.187     0.200
     0.736    -0.493     0.200
     0.997     0.319     0.200
     0.307    -0.478     0.200
     0.975    -0.648     0.200
     0.581     0.019     0.200
     0.656     0.673     0.200
     0.868     0.285     0.200
     0.539    -1.112     0.200
     0.760    -0.514     0.200
     0.854    -0.223     0.200
     0.902     0.575     0.200
     0.912     0.099     0.200
     0.923     0.474     0.200
     0.949    -0.262     0.200
     0.989    -0.584     0.200
     0.986     1.471     0.200
     0.211    -0.617     0.200
     0.969    -1.321     0.200
     1.000     0.280     0.200
     0.235     0.049     0.200
     0.752    -0.635     0.200
     0.883     0.001     0.200
     0.911     0.953     0.200
     0.994     0.457     0.200
     0.074    -0.339     0.200
     0.121     0.294     0.200
     0.139    -0.275     0.200
     0.205    -0.266     0.200
     0.330     0.360     0.200
     0.334    -1.251     0.200
     0.354     0.211     0.200
     0.386    -0.077     0.200
     0.387     0.372     0.200
     0.532    -0.303     0.200
     0.591    -0.016     0.200
     0.697     0.634     0.200
     0.755    -0.664     0.200
     0.919    -1.569     0.200
     0.993    -1.672     0.200
     0.592     0.608     0.200
     0.692     0.444     0.200
     0.901     1.742     0.200
     0.204     1.475     0.200
     0.674     0.473     0.200
     0.720     0.866     0.200
     0.932     1.316     0.200
     0.476    -0.326     0.200
     0.853     0.402     0.200
     0.912    -0.678     0.200
     0.298    -0.204     0.200
     0.759    -0.782     0.200
     0.882    -0.747     0.200
     0.916    -0.466     0.200
     0.957     0.116     0.200
     0.978     0.271     0.200
     0.981    -0.139     0.200
     0.062    -0.416     0.200
     0.883    -1.011     0.200
     0.716     0.550     0.200
     0.780    -0.210     0.200
     0.992     0.707     0.200
     0.692    -0.649     0.200
     0.835    -1.364     0.200
     0.906    -1.348     0.200
     0.937     0.103     0.200
     0.362    -0.569     0.200
     0.964    -1.248     0.200
     0.954     1.899     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.025
 1.00    0.025
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.210
 1.00   -0.210
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 1.00    0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.2
 1.00   -0.2
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.2 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.2 (dashed green line)
EOF
gmt end
