#!/bin/bash
gmt begin caleta1.47_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic caleta1.47'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.473
   135.500     1.555
   136.000     1.641
   136.500     1.729
   137.000     1.821
   137.500     1.916
   138.000     2.014
   138.500     2.115
   139.000     2.221
   139.500     2.330
   140.000     2.443
   140.500     2.560
   141.000     2.681
   141.500     2.807
   142.000     2.937
   142.500     3.072
   143.000     3.212
   143.500     3.358
   144.000     3.509
   144.500     3.665
   145.000     3.828
   145.500     3.996
   146.000     4.171
   146.500     4.353
   147.000     4.542
   147.500     4.738
   148.000     4.941
   148.500     5.152
   149.000     5.372
   149.500     5.600
   150.000     5.839
   150.500     6.087
   151.000     6.346
   151.500     6.615
   152.000     6.894
   152.500     7.182
   153.000     7.482
   153.500     7.792
   154.000     8.112
   154.500     8.443
   155.000     8.786
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.640
   145.500     0.330
   146.000     1.360
   146.500     2.432
   147.000     3.538
   147.500     4.674
   148.000     5.836
   148.500     7.024
   149.000     8.235
   149.500     9.470
   150.000    10.726
   150.500    12.003
   151.000    13.301
   151.500    14.618
   152.000    15.954
   152.500    17.308
   153.000    18.681
   153.500    20.071
   154.000    21.478
   154.500    22.904
   155.000    24.346
   155.500    25.805
   156.000    27.281
   156.500    28.774
   157.000    30.283
   157.500    31.810
   158.000    33.353
   158.500    34.912
   159.000    36.488
   159.500    38.080
   160.000    39.688
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.648
   145.500     0.110
   146.000     0.800
   146.500     1.439
   147.000     2.035
   147.500     2.593
   148.000     3.116
   148.500     3.607
   149.000     4.071
   149.500     4.516
   150.000     4.946
   150.500     5.362
   151.000     5.768
   151.500     6.165
   152.000     6.553
   152.500     6.934
   153.000     7.309
   153.500     7.680
   154.000     8.048
   154.500     8.415
   155.000     8.779
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   139.802    -1.954     0.200
   143.252    -2.134     0.200
   143.562    -2.259     0.200
   151.977     3.410     0.200
   143.272    -2.667     0.200
   151.672     4.457     0.200
   135.014    -3.233     0.200
   140.393    -3.139     0.200
   144.299    -1.184     0.200
   137.416    -1.453     0.200
   139.992    -3.171     0.200
   141.905    -2.618     0.200
   143.498    -1.441     0.200
   144.674    -0.494     0.200
   144.748    -0.292     0.200
   143.129    -2.793     0.200
   144.295    -0.335     0.200
   151.472     2.882     0.200
   137.707    -6.402     0.200
   138.761    -6.338     0.200
   139.513    -3.712     0.200
   140.620    -3.720     0.200
   144.544    -0.680     0.200
   146.378     1.575     0.200
   147.879     2.169     0.200
   151.721     3.591     0.200
   139.483    -4.674     0.200
   144.226    -1.146     0.200
   151.419     4.028     0.200
   144.883    -0.277     0.200
   145.190     1.193     0.200
   152.056     5.074     0.200
   136.621    -1.940     0.200
   136.607    -1.914     0.200
   142.583    -1.783     0.200
   143.488    -1.381     0.200
   144.772    -0.621     0.200
   145.094    -0.178     0.200
   148.574    -0.017     0.200
   148.726     4.236     0.200
   149.072     3.176     0.200
   151.924     2.738     0.200
   153.631     2.239     0.200
   145.816     2.439     0.200
   147.493     0.616     0.200
   148.645     3.022     0.200
   136.777    -2.182     0.200
   138.807    -3.422     0.200
   139.303    -5.828     0.200
   143.193    -1.811     0.200
   143.259     1.072     0.200
   144.461    -0.531     0.200
   144.256     0.927     0.200
   148.266     1.938     0.200
   150.315     1.759     0.200
   137.951    -3.428     0.200
   138.726    -5.551     0.200
   143.513    -1.555     0.200
   144.707    -0.239     0.200
   148.531     1.323     0.200
   150.070     1.657     0.200
   151.037     1.353     0.200
   151.880     3.074     0.200
   139.415    -1.961     0.200
   144.983     0.132     0.200
   146.503     3.538     0.200
   148.778     0.868     0.200
   143.818    -0.563     0.200
   145.076     0.950     0.200
   148.885     0.976     0.200
   150.314     1.489     0.200
   141.110    -2.831     0.200
   142.440    -2.210     0.200
   143.162    -1.987     0.200
   143.995     0.850     0.200
   143.986     0.065     0.200
   144.401    -1.657     0.200
   148.210     1.599     0.200
   150.089     1.681     0.200
   151.110     1.296     0.200
   151.560     3.611     0.200
   152.052     2.871     0.200
   144.224    -0.520     0.200
   148.049     0.597     0.200
   144.668    -0.500     0.200
   136.914    -0.198     0.200
   137.403    -2.100     0.200
   138.339     0.074     0.200
   139.694     0.698     0.200
   139.886     0.349     0.200
   141.569    -0.587     0.200
   142.040     0.469     0.200
   142.410    -1.990     0.200
   142.294    -2.983     0.200
   143.557    -1.416     0.200
   143.946     0.101     0.200
   144.134    -0.126     0.200
   144.797    -0.378     0.200
   144.801    -0.385     0.200
   144.953     1.251     0.200
   146.560     2.608     0.200
   147.660     2.968     0.200
   148.613     1.506     0.200
   148.440     4.986     0.200
   150.079     1.458     0.200
   151.963     2.465     0.200
   144.871     0.272     0.200
   144.854     0.301     0.200
   147.578     3.387     0.200
   148.671     1.388     0.200
   143.554    -1.828     0.200
   143.957     0.465     0.200
   144.764     0.062     0.200
   144.792     0.013     0.200
   147.453     2.796     0.200
   148.583     2.335     0.200
   144.825    -1.957     0.200
   143.558    -2.033     0.200
   144.791    -0.483     0.200
   144.791     1.017     0.200
   144.798    -1.693     0.200
   144.875     1.174     0.200
   147.597     2.060     0.200
   148.606     2.402     0.200
   151.956     2.661     0.200
   136.218    -4.756     0.200
   136.509    -3.296     0.200
   138.215     0.054     0.200
   138.581    -0.216     0.200
   140.840    -2.227     0.200
   140.781    -3.120     0.200
   141.976    -1.266     0.200
   142.007    -3.322     0.200
   142.934    -0.967     0.200
   142.934    -0.467     0.200
   143.898     0.338     0.200
   143.565    -1.080     0.200
   144.576    -0.844     0.200
   144.628    -1.935     0.200
   145.558     2.463     0.200
   149.933     2.239     0.200
   150.907     2.719     0.200
   151.750     3.435     0.200
   152.416     5.441     0.200
   144.590    -0.396     0.200
   144.639    -0.800     0.200
   144.569    -0.522     0.200
   142.348    -2.269     0.200
   143.561    -1.514     0.200
   144.792    -0.060     0.200
   144.800     0.426     0.200
   148.607     0.324     0.200
   151.957     1.782     0.200
   147.966     2.214     0.200
   137.088    -5.745     0.200
   143.066    -2.378     0.200
   144.228    -0.815     0.200
   148.058     1.991     0.200
   151.406     2.084     0.200
   144.472    -0.234     0.200
   144.276     0.412     0.200
   148.275    -0.355     0.200
   150.384     1.168     0.200
   144.565    -0.484     0.200
   144.448    -0.647     0.200
   144.287    -0.154     0.200
   143.628    -1.599     0.200
   144.184    -0.702     0.200
   144.271    -1.053     0.200
   148.017     1.794     0.200
   143.061    -2.756     0.200
   143.562    -1.638     0.200
   144.359    -0.332     0.200
   148.157     1.742     0.200
   148.721     0.622     0.200
   137.365    -2.563     0.200
   137.356    -0.688     0.200
   137.509     0.531     0.200
   140.858    -5.183     0.200
   140.973    -1.790     0.200
   140.995    -1.830     0.200
   142.056    -4.232     0.200
   142.887    -3.207     0.200
   143.446    -1.694     0.200
   144.669    -0.827     0.200
   144.741    -0.764     0.200
   144.787    -0.272     0.200
   137.948     0.341     0.200
   140.984    -4.387     0.200
   143.495    -2.559     0.200
   144.738    -0.728     0.200
   144.941     0.921     0.200
   147.537     2.522     0.200
   148.550     1.856     0.200
   144.893    -0.175     0.200
   143.838    -0.740     0.200
   143.388    -2.627     0.200
   144.641    -0.215     0.200
   144.762    -0.400     0.200
   136.671    -1.970     0.200
   136.698     0.479     0.200
   137.705     0.568     0.200
   138.968    -1.010     0.200
   139.809    -1.235     0.200
   141.234    -6.209     0.200
   142.421    -4.432     0.200
   143.081    -4.102     0.200
   143.013    -0.534     0.200
   143.487    -1.817     0.200
   143.759    -2.294     0.200
   144.727    -1.481     0.200
   144.745    -1.012     0.200
   145.049    -0.538     0.200
   148.960     0.917     0.200
   149.513     0.330     0.200
   150.348     1.212     0.200
   150.842     1.046     0.200
   150.908     0.242     0.200
   138.019     0.453     0.200
   144.776     0.341     0.200
   144.775    -0.344     0.200
   138.050    -0.048     0.200
   144.719     0.246     0.200
   144.737     0.214     0.200
   142.377    -4.631     0.200
   144.670     0.443     0.200
   144.921    -1.106     0.200
   144.960     0.326     0.200
   144.560    -0.480     0.200
   144.890     0.310     0.200
   142.243    -2.611     0.200
   144.622    -0.591     0.200
   144.639    -1.120     0.200
   144.773     0.057     0.200
   144.706    -0.631     0.200
   144.463    -0.935     0.200
   145.963     2.521     0.200
   148.999     1.950     0.200
   144.345    -0.417     0.200
   135.523    -0.389     0.200
   138.347     0.375     0.200
   140.696    -0.413     0.200
   143.133     0.405     0.200
   144.073    -1.396     0.200
   145.923     2.073     0.200
   153.816     1.902     0.200
   144.715    -0.380     0.200
   150.212     1.953     0.200
   137.684     0.454     0.200
   144.714    -1.454     0.200
   144.187    -1.171     0.200
   137.504    -0.191     0.200
   143.014    -0.432     0.200
   143.200    -0.110     0.200
   143.342     0.663     0.200
   143.894     0.772     0.200
   144.072     0.071     0.200
   144.607     0.030     0.200
   144.692    -0.774     0.200
   144.694    -1.199     0.200
   144.694    -0.457     0.200
   145.223     1.348     0.200
   145.543     1.542     0.200
   145.706     1.777     0.200
   145.941     1.722     0.200
   146.650     1.005     0.200
   147.065     2.652     0.200
   147.179     0.523     0.200
   147.436     2.650     0.200
   148.209     2.342     0.200
   148.309     2.404     0.200
   148.309     1.302     0.200
   148.890    -0.362     0.200
   149.655    -1.113     0.200
   149.867     1.591     0.200
   150.176     1.518     0.200
   150.169     0.060     0.200
   150.251     0.986     0.200
   150.609     2.630     0.200
   151.327     0.956     0.200
   151.387     1.834     0.200
   151.634     4.256     0.200
   152.105     1.604     0.200
   153.516    -0.040     0.200
   153.579     0.729     0.200
   144.414    -1.200     0.200
   138.136    -0.239     0.200
   144.155    -0.698     0.200
   147.289     0.607     0.200
   149.160     0.995     0.200
   136.750    -2.047     0.200
   137.677    -0.163     0.200
   138.178    -0.655     0.200
   140.193    -3.745     0.200
   140.398    -5.215     0.200
   141.026    -0.150     0.200
   144.751     0.166     0.200
   145.586     0.669     0.200
   146.438     0.109     0.200
   146.655     2.074     0.200
   147.022     0.346     0.200
   147.682     2.179     0.200
   147.685     1.853     0.200
   148.000     1.353     0.200
   148.912     2.265     0.200
   149.017     1.375     0.200
   148.991     0.278     0.200
   150.161    -0.436     0.200
   150.467     0.215     0.200
   150.736     1.057     0.200
   150.777    -0.426     0.200
   150.909     2.591     0.200
   151.916     1.530     0.200
   152.044     1.869     0.200
   152.665     2.498     0.200
   153.415     1.198     0.200
   153.425     0.293     0.200
   153.599    -0.465     0.200
   154.408     5.391     0.200
   154.682     1.543     0.200
   154.682     1.350     0.200
   136.796    -0.137     0.200
   137.872     0.192     0.200
   144.665    -0.364     0.200
   144.632     1.600     0.200
   144.438    -0.683     0.200
   137.328     0.389     0.200
   144.012     0.957     0.200
   135.993    -1.711     0.200
   137.464    -2.140     0.200
   138.898    -0.167     0.200
   139.523     0.052     0.200
   139.523    -2.722     0.200
   139.523    -4.847     0.200
   140.639     0.957     0.200
   142.395    -4.582     0.200
   142.604     0.539     0.200
   142.604    -1.273     0.200
   144.474     0.325     0.200
   147.062     1.908     0.200
   151.581     5.136     0.200
   151.580     5.263     0.200
   153.221     4.271     0.200
   153.769     6.202     0.200
   155.197     6.246     0.200
   135.591     0.308     0.200
   139.232    -0.647     0.200
   144.327     0.374     0.200
   137.493     0.540     0.200
   147.100     2.041     0.200
   135.109    -1.508     0.200
   137.481     0.193     0.200
   137.568    -0.777     0.200
   137.673    -1.976     0.200
   137.777    -1.541     0.200
   138.426    -1.671     0.200
   143.821    -2.073     0.200
   144.642    -0.503     0.200
   144.686    -0.342     0.200
   144.784     0.270     0.200
   146.456     2.010     0.200
   146.532     0.284     0.200
   146.532     1.843     0.200
   148.828     1.859     0.200
   151.384     2.500     0.200
   151.395     2.317     0.200
   151.866    -0.077     0.200
   153.635     5.130     0.200
   154.485     1.859     0.200
   154.485     1.119     0.200
   155.145     5.420     0.200
   137.353     0.505     0.200
   138.833    -4.606     0.200
   140.640    -3.517     0.200
   140.902    -3.610     0.200
   141.041    -4.513     0.200
   141.056    -3.461     0.200
   141.902    -3.029     0.200
   142.091    -2.890     0.200
   142.321    -3.705     0.200
   146.060    -0.258     0.200
   152.939     3.201     0.200
   154.576     3.621     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   148.372     3.859     0.200
   152.612     6.179     0.200
   147.462     2.746     0.200
   147.534     3.079     0.200
   145.430     1.633     0.200
   145.228     1.318     0.200
   145.379     1.066     0.200
   145.430     1.002     0.200
   145.348     0.198     0.200
   145.216     0.304     0.200
   145.216     0.945     0.200
   149.461     3.934     0.200
   153.116     6.877     0.200
   145.107     0.722     0.200
   145.136     0.920     0.200
   147.965     2.996     0.200
   151.527     3.053     0.200
   151.693     3.829     0.200
   151.663     3.225     0.200
   152.090     3.880     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   148.541     6.789     0.200
   153.443    18.055     0.200
   149.336     7.752     0.200
   147.533     4.549     0.200
   148.529     6.110     0.200
   149.755     7.955     0.200
   151.413    10.627     0.200
   151.398    13.690     0.200
   147.572     6.115     0.200
   148.145    10.669     0.200
   150.680    15.420     0.200
   146.562     2.791     0.200
   150.018     9.241     0.200
   148.401     6.101     0.200
   149.616    12.740     0.200
   147.586     4.801     0.200
   147.648     5.474     0.200
   147.585     5.887     0.200
   148.977     6.765     0.200
   149.064     6.929     0.200
   149.310     7.128     0.200
   147.589     5.001     0.200
   147.659     5.463     0.200
   147.680     5.328     0.200
   152.318    19.702     0.200
   152.415    20.059     0.200
   152.687    21.259     0.200
   152.795    21.201     0.200
   152.969    21.646     0.200
   148.594     7.323     0.200
   147.620     5.384     0.200
   147.590     4.487     0.200
   146.555     2.875     0.200
   147.170     3.730     0.200
   145.512     0.391     0.200
   146.167     2.094     0.200
   146.484     2.487     0.200
   147.134     3.740     0.200
   147.201     3.635     0.200
   148.209     5.365     0.200
   149.093     8.787     0.200
   151.247    13.085     0.200
   146.123     2.086     0.200
   147.289     3.350     0.200
   146.417     2.075     0.200
   147.022     2.457     0.200
   147.682     4.939     0.200
   147.685     4.603     0.200
   150.777    14.044     0.200
   151.581    11.089     0.200
   146.291     2.179     0.200
   145.466     0.605     0.200
   148.442     6.862     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   137.521     4.646     0.200
   139.383     4.231     0.200
   135.515     1.832     0.200
   137.608     2.950     0.200
   147.459     5.036     0.200
   137.359     5.153     0.200
   135.148     3.089     0.200
   151.926     7.521     0.200
   148.124     4.178     0.200
   135.124     7.391     0.200
   137.455     6.062     0.200
   138.139     5.803     0.200
   138.761     4.662     0.200
   138.867     5.468     0.200
   141.956     5.583     0.200
   146.384     7.166     0.200
   152.316     9.700     0.200
   137.908     3.711     0.200
   147.124     6.404     0.200
   148.720     5.773     0.200
   147.210     5.205     0.200
   152.787    10.941     0.200
   148.707     5.301     0.200
   136.131     3.969     0.200
   139.177     5.356     0.200
   150.160     6.547     0.200
   150.837     6.047     0.200
   149.983     7.279     0.200
   151.349     7.864     0.200
   151.616     7.260     0.200
   151.793     9.095     0.200
   143.886     5.191     0.200
   147.222     4.982     0.200
   152.332    10.298     0.200
   138.112     3.425     0.200
   138.112     2.425     0.200
   144.983     7.632     0.200
   145.076     7.950     0.200
   150.344     7.754     0.200
   150.661     7.262     0.200
   148.122     5.200     0.200
   136.529     1.548     0.200
   145.690     3.122     0.200
   149.761     6.397     0.200
   145.327     3.073     0.200
   146.911     4.885     0.200
   146.980     4.769     0.200
   136.436     6.189     0.200
   136.908     7.314     0.200
   137.429     0.850     0.200
   137.639     2.463     0.200
   138.229     3.377     0.200
   138.307     2.235     0.200
   138.993     6.176     0.200
   139.769     2.562     0.200
   141.260     3.765     0.200
   141.553     1.341     0.200
   141.243     1.897     0.200
   143.087     2.611     0.200
   144.801     5.416     0.200
   151.387     7.334     0.200
   144.854     6.801     0.200
   145.944     3.431     0.200
   150.318     7.058     0.200
   152.021     6.656     0.200
   137.544     2.522     0.200
   145.819     3.248     0.200
   147.350     5.867     0.200
   151.165     7.055     0.200
   148.592     4.708     0.200
   150.012     6.932     0.200
   151.941     8.466     0.200
   144.791     7.318     0.200
   147.504     4.715     0.200
   150.337     6.139     0.200
   152.032     6.347     0.200
   135.041     1.938     0.200
   135.308     3.240     0.200
   137.269     5.298     0.200
   137.292     1.057     0.200
   139.270     2.523     0.200
   140.965     1.548     0.200
   143.392     8.425     0.200
   143.660     1.454     0.200
   147.091     5.168     0.200
   147.192     4.698     0.200
   150.241     5.254     0.200
   144.590     7.104     0.200
   145.465     2.595     0.200
   147.091     4.341     0.200
   149.832     7.371     0.200
   145.572     3.092     0.200
   147.201     4.738     0.200
   149.942     6.378     0.200
   145.391     3.060     0.200
   146.916     4.872     0.200
   147.021     4.496     0.200
   148.326     4.636     0.200
   149.762     6.425     0.200
   151.675     8.864     0.200
   137.644     3.264     0.200
   145.945     3.460     0.200
   147.491     5.660     0.200
   150.325     6.080     0.200
   152.048     8.245     0.200
   150.116     6.952     0.200
   151.316     8.096     0.200
   137.088     2.653     0.200
   145.203     2.998     0.200
   146.763     4.543     0.200
   146.846     4.403     0.200
   149.585     6.616     0.200
   144.434     3.035     0.200
   151.625     8.262     0.200
   148.373     4.889     0.200
   145.398     2.912     0.200
   148.277     4.582     0.200
   151.625     8.103     0.200
   151.458     8.372     0.200
   135.440     1.073     0.200
   136.333     2.319     0.200
   146.296     4.801     0.200
   149.471     6.371     0.200
   149.550     6.549     0.200
   149.614     6.948     0.200
   149.640     6.805     0.200
   149.825     6.910     0.200
   150.809     7.975     0.200
   152.261    10.381     0.200
   152.528     9.486     0.200
   152.639    10.721     0.200
   152.814    10.668     0.200
   145.100     2.911     0.200
   146.740     4.719     0.200
   137.837     2.381     0.200
   151.024     8.485     0.200
   151.392     8.822     0.200
   151.570     8.654     0.200
   151.507     9.249     0.200
   136.438     2.724     0.200
   144.472     3.035     0.200
   137.759     0.670     0.200
   137.811     1.372     0.200
   139.500     0.878     0.200
   141.171     2.252     0.200
   143.955     1.915     0.200
   144.993     1.713     0.200
   146.425     3.870     0.200
   147.371     5.181     0.200
   147.459     4.729     0.200
   148.485     4.242     0.200
   151.464     8.752     0.200
   151.582     8.768     0.200
   151.807     8.132     0.200
   151.943     8.724     0.200
   152.124     7.658     0.200
   148.559     4.811     0.200
   138.054     2.487     0.200
   145.132     2.592     0.200
   151.299     9.017     0.200
   151.418     9.336     0.200
   151.641     9.201     0.200
   151.778     9.392     0.200
   151.959     9.222     0.200
   138.106     2.172     0.200
   137.905     2.218     0.200
   137.852     1.292     0.200
   136.715     1.693     0.200
   136.197     4.409     0.200
   138.008     1.509     0.200
   138.008     2.611     0.200
   138.279     1.403     0.200
   143.013     5.107     0.200
   144.745     3.988     0.200
   144.716     8.952     0.200
   138.050     3.843     0.200
   137.990     2.165     0.200
   137.938     1.029     0.200
   138.006     3.129     0.200
   138.006     1.426     0.200
   137.900     2.233     0.200
   151.831     7.764     0.200
   138.272     2.083     0.200
   151.125     7.718     0.200
   151.664     8.898     0.200
   136.748     2.235     0.200
   144.622     8.409     0.200
   137.598     2.034     0.200
   137.771     2.910     0.200
   144.706     8.369     0.200
   136.471     3.142     0.200
   146.135     3.558     0.200
   146.257     3.718     0.200
   148.999     5.653     0.200
   144.345     7.583     0.200
   146.477     3.836     0.200
   135.134     0.947     0.200
   136.432     1.519     0.200
   136.709     2.356     0.200
   138.308     3.905     0.200
   138.308     3.607     0.200
   140.334     1.581     0.200
   140.403     1.161     0.200
   144.073     7.104     0.200
   146.094     3.576     0.200
   152.811     9.272     0.200
   153.816     9.652     0.200
   150.212     6.305     0.200
   138.125     1.150     0.200
   150.632     5.577     0.200
   137.259     2.549     0.200
   137.846     2.904     0.200
   137.878     2.328     0.200
   137.012     1.549     0.200
   137.012     1.555     0.200
   135.150     2.663     0.200
   135.195     2.869     0.200
   137.426     1.959     0.200
   137.500     3.613     0.200
   137.504     4.082     0.200
   137.806     2.057     0.200
   137.829     1.858     0.200
   138.281     1.292     0.200
   138.928     1.395     0.200
   140.962     1.372     0.200
   141.455     1.228     0.200
   143.026     2.517     0.200
   143.226     2.078     0.200
   145.706     2.762     0.200
   145.986     2.472     0.200
   145.941     3.159     0.200
   147.812     4.519     0.200
   148.272     4.019     0.200
   149.245     6.479     0.200
   149.655     5.457     0.200
   150.176     7.104     0.200
   150.169     7.318     0.200
   150.169     6.029     0.200
   150.459     5.762     0.200
   150.978     7.163     0.200
   150.983     6.553     0.200
   151.222     7.687     0.200
   151.247     6.257     0.200
   151.327     8.081     0.200
   152.105     9.354     0.200
   152.105     8.596     0.200
   152.717    10.346     0.200
   149.554     5.613     0.200
   136.900     2.095     0.200
   144.800     2.478     0.200
   144.928     1.756     0.200
   145.759     2.831     0.200
   146.026     3.071     0.200
   149.160     6.003     0.200
   151.088     7.990     0.200
   136.332     3.246     0.200
   136.750     3.376     0.200
   137.816     2.401     0.200
   137.907     1.514     0.200
   137.907     1.234     0.200
   137.998     3.367     0.200
   138.212     2.224     0.200
   138.212     1.605     0.200
   138.235     1.580     0.200
   138.722     3.836     0.200
   138.745     1.255     0.200
   146.331     3.360     0.200
   146.430     2.992     0.200
   146.445     3.068     0.200
   148.000     4.443     0.200
   148.912     5.217     0.200
   149.017     4.795     0.200
   150.161     5.743     0.200
   150.736     6.398     0.200
   150.777     5.754     0.200
   150.909     7.965     0.200
   151.916     6.901     0.200
   152.044     8.209     0.200
   152.665     9.008     0.200
   136.240     2.186     0.200
   136.796     2.925     0.200
   137.872     1.469     0.200
   144.665     8.136     0.200
   137.369     0.797     0.200
   136.897     1.421     0.200
   149.124     5.691     0.200
   149.122     5.693     0.200
   137.348     1.377     0.200
   149.739     6.536     0.200
   138.014     1.826     0.200
   150.551     7.239     0.200
   149.870     5.803     0.200
   149.870     6.289     0.200
   137.965     2.181     0.200
   152.311     8.912     0.200
   137.792     2.911     0.200
   137.604     1.705     0.200
   147.296     4.323     0.200
   150.035     5.641     0.200
   135.028     3.080     0.200
   135.314     3.577     0.200
   135.314     4.569     0.200
   135.453     3.661     0.200
   135.667     3.902     0.200
   135.792     5.178     0.200
   135.759     0.536     0.200
   136.377     4.598     0.200
   136.353     0.572     0.200
   136.848     6.780     0.200
   137.116     5.931     0.200
   137.232     1.366     0.200
   137.464     0.977     0.200
   137.464     1.485     0.200
   137.601     7.442     0.200
   137.296     7.067     0.200
   137.659     3.897     0.200
   138.290     7.534     0.200
   138.898     7.583     0.200
   141.800     7.690     0.200
   141.978     6.107     0.200
   143.301     4.376     0.200
   143.635     3.055     0.200
   144.474     4.090     0.200
   144.538     4.441     0.200
   144.673     1.815     0.200
   144.893     3.145     0.200
   144.940     4.854     0.200
   144.950     6.016     0.200
   144.958     5.439     0.200
   145.369     3.145     0.200
   145.388     3.074     0.200
   146.310     4.714     0.200
   146.317     6.241     0.200
   146.317     4.881     0.200
   151.580     7.817     0.200
   151.970     9.152     0.200
   152.036     9.654     0.200
   153.769     7.905     0.200
   135.141     2.141     0.200
   137.034     0.576     0.200
   137.034     1.771     0.200
   144.290     3.402     0.200
   152.546     7.885     0.200
   152.615    10.090     0.200
   154.059    11.304     0.200
   135.420     1.416     0.200
   136.273     1.500     0.200
   136.293     1.462     0.200
   136.926     1.007     0.200
   136.926     3.486     0.200
   137.226     1.445     0.200
   137.226     1.633     0.200
   137.226     3.174     0.200
   137.272     1.989     0.200
   137.278     1.677     0.200
   137.990     2.114     0.200
   137.990     3.864     0.200
   138.146     1.816     0.200
   138.662     2.591     0.200
   144.404     3.139     0.200
   144.327     1.708     0.200
   144.675     4.668     0.200
   146.093     5.085     0.200
   147.697     3.653     0.200
   152.341     8.485     0.200
   152.407     9.847     0.200
   153.116     8.568     0.200
   154.193     9.570     0.200
   137.647     2.283     0.200
   137.493     1.220     0.200
   151.993    10.157     0.200
   135.606     0.869     0.200
   135.662     1.525     0.200
   135.961     2.388     0.200
   136.176     2.893     0.200
   136.176     0.526     0.200
   136.563     0.760     0.200
   136.677     1.710     0.200
   137.568     3.396     0.200
   137.681     2.988     0.200
   138.802     2.953     0.200
   140.657     4.849     0.200
   140.990     1.129     0.200
   141.865     4.979     0.200
   142.034     4.732     0.200
   142.677     7.382     0.200
   144.642     4.895     0.200
   135.006     1.815     0.200
   136.843     3.421     0.200
   137.143     1.445     0.200
   137.356     2.199     0.200
   138.037     2.820     0.200
   139.280     4.690     0.200
   146.012     3.328     0.200
   146.664     4.263     0.200
   151.334     8.899     0.200
   152.028     9.226     0.200
   152.029     9.327     0.200
   152.414     9.175     0.200
   152.482    10.247     0.200
   153.051     8.037     0.200
   153.051     8.787     0.200
   137.392     3.313     0.200
   135.027     2.718     0.200
   135.333     2.046     0.200
   136.487     3.599     0.200
   136.911     2.433     0.200
   136.911     2.964     0.200
   137.213     2.156     0.200
   137.589     3.406     0.200
   139.918     2.947     0.200
   141.056     2.709     0.200
   144.809     2.588     0.200
   145.254     2.612     0.200
   145.482     3.149     0.200
   146.510     3.719     0.200
   149.066     6.200     0.200
   150.730     7.469     0.200
   137.235     1.498     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
