#!/bin/bash
gmt begin caleta1.47_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P caleta1.47'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.647
    79.000     8.477
    80.000     7.391
    81.000     6.391
    82.000     5.477
    83.000     4.646
    84.000     3.899
    85.000     3.241
    86.000     2.667
    87.000     2.171
    88.000     1.782
    89.000     1.484
    90.000     1.228
    91.000     1.003
    92.000     0.803
    93.000     0.622
    94.000     0.457
    95.000     0.313
    96.000     0.195
    97.000     0.103
    98.000     0.039
    99.000     0.005
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    18.398    -0.845     0.200
    20.071     3.883     0.200
    20.898     0.937     0.200
    21.231    -0.648     0.200
    21.368    -2.109     0.200
    21.639    -1.010     0.200
    21.665    -4.290     0.200
    22.766     2.016     0.200
    22.938    -2.795     0.200
    23.017    -2.624     0.200
    23.021     1.327     0.200
    23.238     1.059     0.200
    24.321     3.166     0.200
    24.987     3.112     0.200
    25.215    -0.963     0.200
    25.044     2.593     0.200
    25.477     2.661     0.200
    26.060    -1.620     0.200
    26.489     2.513     0.200
    27.558    -3.089     0.200
    27.509     0.352     0.200
    28.148     0.652     0.200
    28.398     0.425     0.200
    29.437    -2.796     0.200
    30.503    -2.221     0.200
    30.706    -3.011     0.200
    31.656     0.626     0.200
    31.978     5.797     0.200
    33.078     1.169     0.200
    33.683    -1.105     0.200
    33.729     1.502     0.200
    35.483    -0.648     0.200
    36.415    -2.621     0.200
    41.518    -0.273     0.200
    42.078    -1.841     0.200
    41.416     6.561     0.200
    45.570    -1.871     0.200
    47.165     6.619     0.200
    48.700     6.754     0.200
    54.594     0.781     0.200
    60.712     4.808     0.200
    65.721    -1.349     0.200
    71.088    -0.874     0.200
    84.185     0.179     0.200
    84.389     0.145     0.200
    84.542     0.373     0.200
    85.209     1.024     0.200
    86.652    -1.107     0.200
    86.972     0.332     0.200
    88.367    -2.336     0.200
    90.688    -0.203     0.200
    90.978    -0.551     0.200
    15.176     4.477     0.200
    15.582     2.730     0.200
    19.429    -1.490     0.200
    20.429     1.442     0.200
    21.274    -0.672     0.200
    21.274     2.328     0.200
    21.562    -1.752     0.200
    21.927    -1.655     0.200
    22.454     0.745     0.200
    22.750    -1.389     0.200
    22.977     1.824     0.200
    23.002     0.357     0.200
    23.150     1.900     0.200
    23.299    -3.120     0.200
    23.334    -3.442     0.200
    23.280     1.955     0.200
    23.406     1.002     0.200
    23.618     1.760     0.200
    23.820     1.815     0.200
    24.681     2.368     0.200
    25.045    -0.045     0.200
    25.346    -0.773     0.200
    25.359     3.109     0.200
    25.378     0.034     0.200
    25.584     2.065     0.200
    26.122     1.500     0.200
    26.210     2.598     0.200
    26.859     2.554     0.200
    27.567    -1.596     0.200
    27.939    -0.117     0.200
    28.781     0.387     0.200
    29.175    -2.110     0.200
    29.681    -3.287     0.200
    30.959    -2.878     0.200
    31.317    -2.427     0.200
    32.036     1.847     0.200
    33.886    -2.505     0.200
    35.577    -0.097     0.200
    36.652    -1.783     0.200
    37.496     1.553     0.200
    37.484    -1.040     0.200
    39.162    -1.639     0.200
    39.176    -2.558     0.200
    39.852    -1.388     0.200
    40.601    -1.586     0.200
    42.276    -2.111     0.200
    43.143    -2.136     0.200
    44.683    -0.494     0.200
    45.843    -1.684     0.200
    49.183     0.394     0.200
    49.952     0.537     0.200
    54.986     0.070     0.200
    56.484    -2.460     0.200
    58.438    -0.218     0.200
    66.079    -1.345     0.200
    80.110     1.798     0.200
    80.681     0.729     0.200
    80.768     1.266     0.200
    83.343     0.667     0.200
    83.458     0.176     0.200
    83.705     0.908     0.200
    84.481    -0.034     0.200
    84.859    -0.143     0.200
    85.369     1.510     0.200
    85.426     0.723     0.200
    86.974    -1.397     0.200
    87.276    -0.861     0.200
    87.381     1.030     0.200
    88.201     0.225     0.200
    88.629     0.706     0.200
    88.655    -1.217     0.200
    89.511    -0.434     0.200
    89.584    -0.880     0.200
    90.988    -0.318     0.200
    91.225    -0.418     0.200
    92.329    -1.528     0.200
    92.760     0.984     0.200
    97.929    -1.090     0.200
    13.887     3.518     0.200
    15.235     4.705     0.200
    15.591     3.004     0.200
    16.837     2.852     0.200
    17.509     2.824     0.200
    18.651    -1.143     0.200
    20.774     0.740     0.200
    21.403    -0.519     0.200
    21.646    -1.621     0.200
    22.643     0.673     0.200
    23.127    -3.119     0.200
    23.023     1.769     0.200
    23.186    -2.543     0.200
    23.275     0.940     0.200
    23.383     1.761     0.200
    23.623     2.565     0.200
    23.626     2.438     0.200
    23.892     2.209     0.200
    24.596     2.085     0.200
    24.951     1.853     0.200
    24.788     1.835     0.200
    25.023     2.702     0.200
    26.532     2.042     0.200
    27.174     2.764     0.200
    28.127     0.751     0.200
    29.027    -2.750     0.200
    29.136    -1.418     0.200
    29.028    -0.054     0.200
    30.798    -3.414     0.200
    31.109    -2.153     0.200
    33.658    -1.475     0.200
    34.980     0.587     0.200
    35.264    -2.358     0.200
    35.750    -0.528     0.200
    36.346    -1.622     0.200
    39.603     1.937     0.200
    44.834    -0.635     0.200
    46.205    -2.479     0.200
    48.350     2.840     0.200
    48.743     0.819     0.200
    50.090    -0.455     0.200
    51.102    -2.081     0.200
    55.236     0.128     0.200
    56.556    -1.918     0.200
    58.566    -0.049     0.200
    58.577    -0.524     0.200
    61.513    -0.141     0.200
    66.130    -1.610     0.200
    83.299     0.266     0.200
    84.287     1.219     0.200
    84.385     1.020     0.200
    84.681     0.626     0.200
    84.807     0.094     0.200
    85.082     0.112     0.200
    85.202     1.412     0.200
    85.397     0.537     0.200
    87.197    -1.209     0.200
    87.517     0.047     0.200
    87.651     0.204     0.200
    88.546    -0.934     0.200
    90.638     0.377     0.200
    90.900    -0.839     0.200
    91.051     0.459     0.200
    95.599     1.323     0.200
    95.861     1.333     0.200
    15.562     4.189     0.200
    16.079     2.425     0.200
    17.252     2.940     0.200
    17.989     2.434     0.200
    18.859    -1.220     0.200
    21.296     2.289     0.200
    21.718    -1.543     0.200
    21.870    -1.665     0.200
    23.075     0.740     0.200
    23.155    -3.897     0.200
    23.330    -1.139     0.200
    23.776     1.874     0.200
    24.147     2.486     0.200
    24.099     2.525     0.200
    24.574     3.200     0.200
    25.027    -1.421     0.200
    25.116     1.964     0.200
    25.303     1.866     0.200
    25.543     2.387     0.200
    26.030     2.474     0.200
    26.253     2.365     0.200
    26.318    -0.622     0.200
    27.044     2.728     0.200
    27.331    -1.851     0.200
    27.684     1.492     0.200
    28.558     0.802     0.200
    28.796    -0.710     0.200
    29.366     2.731     0.200
    29.499    -0.053     0.200
    29.575    -2.227     0.200
    30.512    -3.207     0.200
    30.883    -3.286     0.200
    30.892     5.631     0.200
    31.134    -2.198     0.200
    31.703    -0.108     0.200
    32.457     0.376     0.200
    32.789     1.268     0.200
    33.655    -1.588     0.200
    34.163     0.502     0.200
    34.695    -1.605     0.200
    34.616     0.583     0.200
    35.331    -3.085     0.200
    35.307     2.123     0.200
    36.031    -1.887     0.200
    36.168    -0.658     0.200
    36.521    -1.775     0.200
    36.689    -1.706     0.200
    37.305    -1.143     0.200
    37.932    -0.247     0.200
    38.974    -1.605     0.200
    39.639    -1.550     0.200
    40.065     1.807     0.200
    40.170     4.543     0.200
    40.441    -1.405     0.200
    40.500    -0.690     0.200
    41.790    -2.293     0.200
    43.037    -1.439     0.200
    45.233    -1.829     0.200
    45.827    -1.130     0.200
    45.920     4.338     0.200
    46.525    -2.218     0.200
    47.818     3.700     0.200
    48.261     3.080     0.200
    49.781     3.939     0.200
    50.479    -0.159     0.200
    51.303    -1.053     0.200
    52.073     3.799     0.200
    55.708     0.039     0.200
    56.887    -2.571     0.200
    58.946    -0.306     0.200
    59.266     3.276     0.200
    61.965    -1.019     0.200
    66.440    -1.957     0.200
    71.743    -0.350     0.200
    77.486     1.443     0.200
    80.628     0.949     0.200
    80.647     1.042     0.200
    80.976     1.788     0.200
    81.077     1.248     0.200
    81.686     1.022     0.200
    82.797     2.210     0.200
    83.067     1.610     0.200
    83.511    -0.279     0.200
    83.534     0.406     0.200
    84.099    -0.484     0.200
    84.287     1.460     0.200
    84.389     1.443     0.200
    84.515     1.307     0.200
    84.684     1.250     0.200
    85.009    -0.184     0.200
    85.214     0.891     0.200
    85.320     0.761     0.200
    85.626    -0.261     0.200
    86.261     1.898     0.200
    86.859     1.765     0.200
    87.143    -0.615     0.200
    87.152    -0.159     0.200
    87.371    -0.619     0.200
    87.516     0.684     0.200
    87.652     0.326     0.200
    87.930     1.106     0.200
    88.053     0.920     0.200
    88.685    -1.063     0.200
    88.831    -0.649     0.200
    88.977     0.063     0.200
    89.461     0.892     0.200
    89.719    -0.916     0.200
    90.053     0.326     0.200
    90.239     0.759     0.200
    90.216     0.665     0.200
    90.451    -0.227     0.200
    90.690     0.661     0.200
    91.063    -0.674     0.200
    91.112     0.700     0.200
    92.553     0.733     0.200
    92.637     0.644     0.200
    92.785     0.959     0.200
    94.435     0.568     0.200
    94.715     1.086     0.200
    95.042     0.589     0.200
    95.252     0.729     0.200
    95.480    -0.412     0.200
    96.056     0.967     0.200
    15.743     2.322     0.200
    16.926     2.885     0.200
    17.653     2.696     0.200
    18.612    -1.114     0.200
    19.290    -1.138     0.200
    21.470     0.349     0.200
    21.616    -2.103     0.200
    23.002    -3.016     0.200
    23.441     1.989     0.200
    23.510     0.658     0.200
    24.043     1.788     0.200
    24.787     2.308     0.200
    24.971     1.632     0.200
    25.214     2.526     0.200
    26.712     2.487     0.200
    27.197    -2.175     0.200
    28.229     0.906     0.200
    28.480    -1.526     0.200
    28.834    -0.074     0.200
    31.373     0.286     0.200
    32.123     1.492     0.200
    32.726    -0.189     0.200
    33.828     0.607     0.200
    34.727     0.627     0.200
    35.842    -0.759     0.200
    35.940     1.405     0.200
    39.731     2.424     0.200
    39.986     1.303     0.200
    41.558    -1.747     0.200
    44.912    -1.709     0.200
    45.627    -1.374     0.200
    46.231    -2.434     0.200
    48.131     3.870     0.200
    48.573     3.663     0.200
    50.161     0.549     0.200
    55.372     0.285     0.200
    56.589    -2.614     0.200
    57.029     0.268     0.200
    58.631    -0.964     0.200
    58.642    -0.341     0.200
    84.250     1.321     0.200
    84.468     1.617     0.200
    84.546     1.421     0.200
    84.766     0.511     0.200
    85.006    -0.091     0.200
    85.119    -0.656     0.200
    85.371     2.086     0.200
    86.210     2.033     0.200
    86.895    -0.428     0.200
    87.016    -0.616     0.200
    87.142    -0.928     0.200
    87.380     0.221     0.200
    87.515     0.072     0.200
    89.480    -0.704     0.200
    90.839    -1.040     0.200
    92.470     0.410     0.200
    94.878     0.336     0.200
    95.350     1.078     0.200
    14.655     4.116     0.200
    15.236     3.491     0.200
    16.623     2.510     0.200
    17.169     2.676     0.200
    18.246     3.326     0.200
    19.457    -0.147     0.200
    20.409    -1.311     0.200
    21.235     2.174     0.200
    21.568    -0.404     0.200
    21.701    -2.027     0.200
    22.395     0.575     0.200
    22.945     0.657     0.200
    23.078     0.557     0.200
    23.141     2.386     0.200
    23.171     2.672     0.200
    23.399    -2.967     0.200
    23.338     1.118     0.200
    23.533     1.508     0.200
    24.057     2.221     0.200
    24.148     2.190     0.200
    24.379    -2.025     0.200
    24.358     1.572     0.200
    24.574     2.203     0.200
    25.243     1.418     0.200
    25.284     3.545     0.200
    25.304     2.863     0.200
    26.110     1.668     0.200
    26.388    -3.147     0.200
    26.477    -2.751     0.200
    27.430    -1.823     0.200
    27.638    -3.287     0.200
    28.704     0.320     0.200
    29.221    -1.273     0.200
    30.821    -1.920     0.200
    30.872     0.128     0.200
    31.381    -3.356     0.200
    31.706    -0.213     0.200
    31.994    -0.747     0.200
    31.985     4.335     0.200
    32.423    -0.507     0.200
    33.000    -2.553     0.200
    33.387     1.067     0.200
    33.619    -0.954     0.200
    33.957    -1.888     0.200
    35.492    -2.141     0.200
    35.551    -1.145     0.200
    36.236    -1.509     0.200
    36.329    -1.307     0.200
    38.874     1.276     0.200
    39.293     1.669     0.200
    39.454     0.931     0.200
    40.076    -0.343     0.200
    40.662    -1.688     0.200
    40.864    -1.055     0.200
    40.838     0.762     0.200
    41.198     4.895     0.200
    41.523    -0.664     0.200
    41.713    -3.328     0.200
    44.636    -0.933     0.200
    45.884    -0.827     0.200
    46.127    -2.741     0.200
    46.945     1.944     0.200
    48.862     1.609     0.200
    49.305     2.818     0.200
    49.908    -0.970     0.200
    50.445    -1.039     0.200
    51.176    -1.540     0.200
    52.970     2.123     0.200
    53.107     1.810     0.200
    53.532     1.291     0.200
    54.849     0.794     0.200
    54.849     0.396     0.200
    54.907     0.477     0.200
    54.907     0.278     0.200
    56.460    -2.161     0.200
    58.397    -0.809     0.200
    58.408    -0.885     0.200
    59.280     1.060     0.200
    61.222     0.276     0.200
    64.653     1.281     0.200
    65.273     1.245     0.200
    66.062    -0.140     0.200
    71.428    -0.554     0.200
    71.523     1.876     0.200
    76.744     1.426     0.200
    77.746    -0.190     0.200
    80.001     3.435     0.200
    80.803     1.231     0.200
    80.822     1.026     0.200
    81.764     0.032     0.200
    81.866     3.497     0.200
    81.898     1.325     0.200
    82.232     0.574     0.200
    82.473     1.318     0.200
    83.120    -0.040     0.200
    83.120     1.960     0.200
    83.355     0.146     0.200
    83.393    -0.450     0.200
    84.576     0.422     0.200
    84.670     0.550     0.200
    84.875     1.518     0.200
    84.967     0.956     0.200
    85.082     1.177     0.200
    85.232     0.128     0.200
    85.306    -0.139     0.200
    85.332     2.230     0.200
    85.434     2.323     0.200
    85.455     1.117     0.200
    86.207     1.091     0.200
    86.632     1.303     0.200
    86.815     1.210     0.200
    86.986    -0.624     0.200
    87.299    -1.641     0.200
    87.441     0.373     0.200
    87.692     0.170     0.200
    87.807    -0.177     0.200
    87.938     0.199     0.200
    88.259     0.877     0.200
    88.340     2.096     0.200
    88.364    -1.618     0.200
    88.636     0.200     0.200
    88.683    -0.523     0.200
    88.687    -1.543     0.200
    89.430     0.970     0.200
    89.602    -0.334     0.200
    89.703    -0.308     0.200
    90.447     1.523     0.200
    90.875     0.231     0.200
    91.014    -0.414     0.200
    91.278     0.360     0.200
    91.799     1.949     0.200
    91.951     1.246     0.200
    92.711     0.734     0.200
    92.750     1.554     0.200
    94.686     0.651     0.200
    94.743     2.191     0.200
    94.776     1.738     0.200
    95.231     1.160     0.200
    95.912     1.054     0.200
    96.201     0.738     0.200
    96.160     0.625     0.200
    96.242     0.555     0.200
    97.854    -0.236     0.200
    99.301    -1.211     0.200
    14.187     4.855     0.200
    17.030     3.192     0.200
    17.276     1.623     0.200
    17.642     2.179     0.200
    18.933    -0.474     0.200
    19.099    -1.191     0.200
    19.633    -2.632     0.200
    20.835     2.304     0.200
    21.814    -1.226     0.200
    22.822     0.741     0.200
    23.432    -2.780     0.200
    23.368    -0.512     0.200
    23.535     0.724     0.200
    23.686     2.744     0.200
    24.015     2.138     0.200
    24.402    -1.499     0.200
    24.571     2.363     0.200
    24.660     2.346     0.200
    24.709     1.602     0.200
    24.866     1.877     0.200
    25.087     2.566     0.200
    25.295     3.075     0.200
    25.797     2.721     0.200
    25.822     2.794     0.200
    26.031     1.999     0.200
    26.576    -0.525     0.200
    27.226     3.623     0.200
    27.263     1.596     0.200
    27.786    -1.487     0.200
    27.804     0.046     0.200
    28.928     1.436     0.200
    29.327    -2.606     0.200
    29.170     0.385     0.200
    29.810    -2.979     0.200
    29.970     4.705     0.200
    30.823    -1.838     0.200
    31.439    -0.069     0.200
    31.497     5.826     0.200
    32.158    -0.589     0.200
    32.431     1.616     0.200
    32.833     0.502     0.200
    33.061    -2.896     0.200
    33.082     0.423     0.200
    33.747    -1.474     0.200
    33.848     0.650     0.200
    34.504    -0.044     0.200
    35.203     0.325     0.200
    35.567    -2.205     0.200
    35.663     1.969     0.200
    35.939    -1.396     0.200
    35.920     1.765     0.200
    35.987     0.191     0.200
    36.338    -1.303     0.200
    36.580    -1.868     0.200
    37.443    -1.207     0.200
    37.584    -1.200     0.200
    37.831     1.512     0.200
    38.522    -0.412     0.200
    39.296    -2.797     0.200
    39.753     1.396     0.200
    40.437    -0.076     0.200
    40.709    -1.525     0.200
    40.676     3.743     0.200
    41.165    -2.284     0.200
    41.111    -0.737     0.200
    41.899    -2.297     0.200
    42.347    -0.953     0.200
    43.273    -2.462     0.200
    45.035    -1.586     0.200
    45.673     1.355     0.200
    46.009    -1.293     0.200
    46.449    -2.757     0.200
    46.424     3.245     0.200
    48.340     3.132     0.200
    48.783     2.823     0.200
    50.298    -0.432     0.200
    50.443    -1.528     0.200
    51.385     0.389     0.200
    52.453     2.527     0.200
    53.432     3.002     0.200
    53.607     1.921     0.200
    53.857     1.892     0.200
    54.015     1.231     0.200
    55.318     0.682     0.200
    55.358     0.695     0.200
    55.376     0.161     0.200
    56.519     0.682     0.200
    56.795    -2.079     0.200
    57.027     1.278     0.200
    57.608     4.772     0.200
    57.742     4.234     0.200
    58.779    -0.018     0.200
    59.681     2.242     0.200
    59.941     2.451     0.200
    60.417     3.091     0.200
    66.378    -1.748     0.200
    68.030     1.574     0.200
    69.481     0.832     0.200
    70.161    -0.455     0.200
    71.674     1.059     0.200
    71.718     0.094     0.200
    74.690     3.542     0.200
    77.022     1.426     0.200
    80.516     1.024     0.200
    80.874     0.406     0.200
    80.894     1.001     0.200
    81.701     1.217     0.200
    81.991     2.191     0.200
    82.174     1.228     0.200
    82.749     0.228     0.200
    83.249     1.441     0.200
    83.578     1.248     0.200
    83.833    -1.357     0.200
    84.592     1.685     0.200
    84.677     0.457     0.200
    84.690     1.989     0.200
    84.954     0.959     0.200
    84.986     1.800     0.200
    85.088    -0.313     0.200
    85.185     1.802     0.200
    85.377     0.442     0.200
    85.391     1.775     0.200
    85.499     0.237     0.200
    86.451     0.926     0.200
    86.695     1.832     0.200
    87.026    -0.885     0.200
    87.210    -0.876     0.200
    87.485    -1.108     0.200
    87.822     0.680     0.200
    87.956     0.942     0.200
    88.295    -0.366     0.200
    88.316     1.037     0.200
    88.327     3.484     0.200
    88.572    -0.471     0.200
    88.840    -1.834     0.200
    88.876    -0.104     0.200
    89.808    -0.672     0.200
    89.973     0.258     0.200
    90.038    -0.849     0.200
    90.213     1.135     0.200
    90.942     1.244     0.200
    91.190    -0.707     0.200
    91.354    -0.268     0.200
    92.187    -1.523     0.200
    92.782    -0.270     0.200
    92.811     0.995     0.200
    92.885     1.254     0.200
    93.751    -0.736     0.200
    94.996     0.555     0.200
    95.709     0.301     0.200
    95.832     1.539     0.200
    96.288     0.667     0.200
    15.560     3.799     0.200
    17.098     2.181     0.200
    17.321     2.393     0.200
    17.691     2.303     0.200
    19.026    -1.659     0.200
    19.727    -1.627     0.200
    20.861     2.349     0.200
    21.688     0.956     0.200
    22.015    -2.046     0.200
    22.885     1.208     0.200
    23.529    -3.200     0.200
    23.432    -0.051     0.200
    23.589     1.252     0.200
    24.060     2.152     0.200
    24.500    -0.460     0.200
    24.688     2.129     0.200
    24.897     1.918     0.200
    25.114     2.150     0.200
    26.670    -2.039     0.200
    27.878    -0.383     0.200
    29.424    -2.134     0.200
    29.907    -3.310     0.200
    31.524     6.220     0.200
    32.214     1.249     0.200
    32.478     0.939     0.200
    33.843    -2.981     0.200
    33.901     1.515     0.200
    34.551     0.880     0.200
    35.270     0.677     0.200
    35.664    -1.710     0.200
    36.005    -0.628     0.200
    36.658    -1.209     0.200
    36.869    -2.207     0.200
    39.807     1.279     0.200
    40.663     5.184     0.200
    41.993    -2.733     0.200
    43.370    -1.917     0.200
    46.105    -1.722     0.200
    46.531    -2.068     0.200
    48.331     3.933     0.200
    48.774     3.922     0.200
    50.540    -0.931     0.200
    53.644     1.777     0.200
    53.906     1.857     0.200
    54.060     0.635     0.200
    55.409     1.057     0.200
    55.427     0.027     0.200
    56.561    -0.381     0.200
    58.852    -1.192     0.200
    58.863    -0.667     0.200
    71.804     0.409     0.200
    77.109     0.069     0.200
    80.972    -0.186     0.200
    83.670     1.307     0.200
    84.689     1.224     0.200
    84.787     1.528     0.200
    84.771     0.209     0.200
    85.047     0.827     0.200
    85.084     1.438     0.200
    85.181    -0.548     0.200
    85.473     0.695     0.200
    85.595     1.791     0.200
    86.541     0.117     0.200
    86.787     1.710     0.200
    87.122    -0.719     0.200
    87.301    -0.892     0.200
    87.579    -1.028     0.200
    87.919     0.449     0.200
    88.053     0.813     0.200
    88.935    -1.053     0.200
    89.901    -0.576     0.200
    91.284    -0.413     0.200
    92.983     0.634     0.200
    14.193     4.530     0.200
    16.647     1.988     0.200
    18.603    -1.443     0.200
    19.342    -1.826     0.200
    20.203     0.109     0.200
    21.234     2.685     0.200
    21.483     3.220     0.200
    23.187    -2.445     0.200
    23.154     1.304     0.200
    23.340     2.422     0.200
    23.641     0.769     0.200
    24.511     1.537     0.200
    24.739     2.462     0.200
    25.459     3.219     0.200
    26.257     2.497     0.200
    28.470     3.478     0.200
    28.791     0.723     0.200
    31.056     0.097     0.200
    31.777     0.460     0.200
    32.057     1.001     0.200
    32.449     0.562     0.200
    33.467     1.672     0.200
    35.243    -0.481     0.200
    35.555    -1.366     0.200
    36.045    12.941     0.200
    36.511    -3.238     0.200
    39.372     2.354     0.200
    40.802    -0.487     0.200
    40.999     5.894     0.200
    44.652    -0.679     0.200
    46.080    -0.980     0.200
    49.023     3.990     0.200
    53.243     1.955     0.200
    53.328    -0.069     0.200
    53.642     1.132     0.200
    54.939     0.601     0.200
    54.998    -0.222     0.200
    56.423    -1.430     0.200
    59.792     3.022     0.200
    60.214     0.526     0.200
    64.236     1.220     0.200
    65.457     0.279     0.200
    67.549     1.922     0.200
    69.837     2.679     0.200
    71.359    -0.581     0.200
    80.629     0.860     0.200
    83.242     0.735     0.200
    83.449    -0.127     0.200
    84.358     1.239     0.200
    84.454     0.959     0.200
    84.813     1.741     0.200
    85.203     1.092     0.200
    85.331    -0.645     0.200
    86.013     1.973     0.200
    86.548     1.338     0.200
    86.874    -0.548     0.200
    87.165    -1.367     0.200
    88.242    -1.104     0.200
    89.525     1.161     0.200
    16.901     1.524     0.200
    18.815    -0.620     0.200
    19.408    -3.112     0.200
    19.546    -2.012     0.200
    21.352     2.412     0.200
    21.518     1.838     0.200
    21.729     2.570     0.200
    22.005    -2.379     0.200
    22.016     2.199     0.200
    21.998     1.594     0.200
    22.079     2.133     0.200
    22.693     0.810     0.200
    22.982     1.662     0.200
    23.105    -0.745     0.200
    23.167     1.106     0.200
    23.339    -2.702     0.200
    23.255     1.387     0.200
    23.408     0.195     0.200
    23.657     0.812     0.200
    23.574     2.172     0.200
    23.654     1.047     0.200
    23.891     1.672     0.200
    23.976     2.295     0.200
    24.311    -1.763     0.200
    24.459     1.692     0.200
    24.548     1.782     0.200
    24.751     1.436     0.200
    24.975     2.400     0.200
    25.193     2.209     0.200
    25.184     2.796     0.200
    25.429     1.879     0.200
    25.508     2.160     0.200
    25.584     3.265     0.200
    25.685     1.853     0.200
    25.697     2.240     0.200
    25.710     4.122     0.200
    26.499     2.287     0.200
    27.104    -1.462     0.200
    27.554    -0.996     0.200
    28.529    -1.982     0.200
    28.497    -1.110     0.200
    28.710     2.404     0.200
    29.045     0.627     0.200
    29.348    -0.566     0.200
    29.710    -0.967     0.200
    30.439     2.882     0.200
    31.322     1.095     0.200
    31.466     0.833     0.200
    31.557     4.027     0.200
    32.031     0.863     0.200
    32.423     0.427     0.200
    32.317     0.354     0.200
    32.308     1.231     0.200
    32.597     1.902     0.200
    32.703    -1.027     0.200
    33.721     0.089     0.200
    34.381     1.368     0.200
    35.468    -1.208     0.200
    35.810    -0.642     0.200
    35.950     1.858     0.200
    36.451    -1.216     0.200
    36.674    -1.724     0.200
    38.566     1.680     0.200
    39.719    -4.954     0.200
    39.743     3.846     0.200
    40.449     2.492     0.200
    41.039    -1.375     0.200
    41.135    -0.665     0.200
    44.905    -1.371     0.200
    45.902    -1.460     0.200
    46.322    -1.363     0.200
    46.526     2.133     0.200
    48.438     1.175     0.200
    48.881     1.272     0.200
    50.357    -0.872     0.200
    51.267    -1.319     0.200
    51.415     7.574     0.200
    51.415     7.570     0.200
    52.562     1.531     0.200
    53.019     2.658     0.200
    53.488     1.911     0.200
    53.583     0.308     0.200
    53.893     1.451     0.200
    54.716     5.259     0.200
    54.782     5.777     0.200
    55.192     0.711     0.200
    55.251     0.889     0.200
    54.934     5.680     0.200
    56.398     0.671     0.200
    56.666    -1.838     0.200
    57.356     0.180     0.200
    57.360     1.853     0.200
    57.949     0.419     0.200
    57.679     5.107     0.200
    57.863     6.819     0.200
    58.649    -0.677     0.200
    59.375    -0.709     0.200
    59.551     2.075     0.200
    59.798     1.375     0.200
    60.059     3.086     0.200
    60.465     0.806     0.200
    60.998    -0.024     0.200
    61.725     4.263     0.200
    64.063     0.221     0.200
    64.126     3.305     0.200
    65.685     0.161     0.200
    66.250    -1.172     0.200
    67.801     1.179     0.200
    69.419     1.483     0.200
    70.046    -0.567     0.200
    71.125     0.149     0.200
    71.563     1.503     0.200
    76.898     1.821     0.200
    77.685     1.014     0.200
    78.977     4.975     0.200
    79.896    -0.131     0.200
    80.143     0.534     0.200
    80.320     0.581     0.200
    80.405     1.124     0.200
    80.795     1.234     0.200
    80.863     0.671     0.200
    81.628     0.612     0.200
    81.837     1.508     0.200
    81.922     0.959     0.200
    82.036     1.261     0.200
    82.160     1.814     0.200
    82.121     1.517     0.200
    82.640     1.305     0.200
    83.142     1.706     0.200
    83.459     0.674     0.200
    83.704    -0.186     0.200
    84.503     2.146     0.200
    84.600     2.359     0.200
    84.897     2.163     0.200
    84.970     1.193     0.200
    85.150     1.496     0.200
    85.318     0.657     0.200
    85.359     0.452     0.200
    85.391     0.994     0.200
    85.552    -1.008     0.200
    85.607     1.919     0.200
    85.765     1.430     0.200
    85.766     4.223     0.200
    86.597     1.332     0.200
    86.634     2.151     0.200
    86.688     0.887     0.200
    86.809     1.593     0.200
    86.813     0.674     0.200
    86.931     0.097     0.200
    87.090    -0.678     0.200
    87.121     0.275     0.200
    87.156     1.106     0.200
    87.201     0.785     0.200
    87.370    -0.432     0.200
    87.579     1.063     0.200
    87.733     0.622     0.200
    87.867     0.792     0.200
    88.059     0.678     0.200
    88.218     2.227     0.200
    88.220     0.719     0.200
    88.233     5.452     0.200
    88.449     1.435     0.200
    88.687     1.312     0.200
    88.729    -0.786     0.200
    88.755     0.992     0.200
    89.068     0.519     0.200
    89.351     0.195     0.200
    89.413     0.402     0.200
    89.439     0.779     0.200
    89.485     0.364     0.200
    89.612    -0.529     0.200
    89.650     1.294     0.200
    89.830     0.952     0.200
    89.778     1.196     0.200
    90.021     3.060     0.200
    90.398     0.098     0.200
    90.535     2.663     0.200
    90.701    -0.107     0.200
    90.845     0.726     0.200
    91.076    -1.249     0.200
    91.102     0.532     0.200
    91.106     1.113     0.200
    91.221     0.877     0.200
    91.255     0.421     0.200
    91.272     1.740     0.200
    91.660    -3.056     0.200
    91.989    -0.373     0.200
    92.206     0.918     0.200
    92.684     0.712     0.200
    92.715     0.569     0.200
    92.787     0.532     0.200
    93.636    -0.677     0.200
    93.989     4.904     0.200
    94.629     1.060     0.200
    94.710     0.598     0.200
    94.743     0.445     0.200
    95.169    -0.706     0.200
    95.199     0.953     0.200
    95.607    -0.708     0.200
    95.875     2.674     0.200
    95.996     1.524     0.200
    96.067     0.198     0.200
    96.052     0.269     0.200
    95.996     7.525     0.200
    96.650     0.553     0.200
    96.863     1.691     0.200
    96.866     1.677     0.200
    98.188    -0.385     0.200
    16.863     3.222     0.200
    18.799    -1.039     0.200
    19.573    -1.614     0.200
    21.165     2.211     0.200
    21.392     2.565     0.200
    21.443     2.523     0.200
    22.060    -0.687     0.200
    22.278     0.688     0.200
    22.746    -2.279     0.200
    22.784     1.915     0.200
    22.927     0.708     0.200
    22.931     2.974     0.200
    23.031     1.313     0.200
    23.200     2.532     0.200
    23.350     1.259     0.200
    23.391     1.727     0.200
    23.574    -2.637     0.200
    23.910     1.792     0.200
    24.132     1.770     0.200
    24.336     2.306     0.200
    24.560    -1.640     0.200
    24.873     3.113     0.200
    25.047     3.435     0.200
    25.888     2.599     0.200
    28.177    -1.771     0.200
    28.541     0.284     0.200
    31.302     4.951     0.200
    31.560     1.180     0.200
    31.771     0.821     0.200
    31.851     0.623     0.200
    32.323     0.475     0.200
    32.223     2.353     0.200
    33.231     1.530     0.200
    33.346     0.529     0.200
    33.846     1.177     0.200
    35.416    -0.997     0.200
    35.642    -3.334     0.200
    35.879    -0.370     0.200
    36.196    -1.581     0.200
    36.685    -0.255     0.200
    39.137     1.942     0.200
    39.296     1.715     0.200
    40.088     3.127     0.200
    40.408     1.481     0.200
    40.859    -1.949     0.200
    45.013     1.910     0.200
    46.104    -1.822     0.200
    47.216     5.769     0.200
    49.143     2.086     0.200
    49.586     2.503     0.200
    51.239    -0.996     0.200
    52.485     1.914     0.200
    52.895     1.485     0.200
    53.153    -0.116     0.200
    53.345     0.872     0.200
    53.220     4.289     0.200
    54.682     0.609     0.200
    54.739     0.496     0.200
    55.829     0.340     0.200
    56.426    -2.926     0.200
    56.804     0.289     0.200
    57.432    -0.056     0.200
    58.322    -0.097     0.200
    59.339     0.635     0.200
    59.927     1.082     0.200
    60.662     4.554     0.200
    61.141     3.904     0.200
    65.017     0.468     0.200
    66.044    -1.466     0.200
    67.269     0.112     0.200
    68.798     0.510     0.200
    70.039    -0.163     0.200
    71.030    -1.107     0.200
    76.754     0.387     0.200
    79.486     5.037     0.200
    79.758     1.663     0.200
    80.625    -0.015     0.200
    80.971    -0.261     0.200
    81.537     1.135     0.200
    81.986    -0.130     0.200
    82.788     3.577     0.200
    83.260     0.137     0.200
    83.406     1.183     0.200
    84.756     1.708     0.200
    84.775     1.412     0.200
    84.848     1.849     0.200
    84.932     0.622     0.200
    85.145     1.756     0.200
    85.334     1.611     0.200
    85.429     0.137     0.200
    85.474     1.715     0.200
    85.479     1.189     0.200
    85.554     3.014     0.200
    85.878     1.405     0.200
    86.228     1.679     0.200
    86.506     1.813     0.200
    86.999    -0.602     0.200
    87.037    -0.783     0.200
    87.063     2.086     0.200
    87.082     1.194     0.200
    87.096    -0.172     0.200
    87.440     0.961     0.200
    87.489     0.423     0.200
    87.498     0.181     0.200
    87.780     0.132     0.200
    87.924    -0.052     0.200
    87.987     0.048     0.200
    88.117    -0.364     0.200
    88.122     2.010     0.200
    88.312     0.011     0.200
    88.416     3.119     0.200
    88.552     2.977     0.200
    88.675     2.400     0.200
    88.705    -0.245     0.200
    88.786     1.175     0.200
    89.257     0.664     0.200
    89.301     0.457     0.200
    89.585    -0.974     0.200
    89.646     0.340     0.200
    89.664     0.558     0.200
    89.709     0.547     0.200
    89.870     3.791     0.200
    90.274    -0.093     0.200
    90.896     5.015     0.200
    91.027     1.408     0.200
    91.098     2.078     0.200
    91.424    -0.437     0.200
    92.860    -0.074     0.200
    92.905     0.219     0.200
    92.964     0.448     0.200
    94.896     1.567     0.200
    95.122     1.035     0.200
    95.360    -0.555     0.200
    95.383     0.343     0.200
    96.268     3.310     0.200
    96.707     0.320     0.200
    97.026     0.878     0.200
    97.038     1.821     0.200
    97.850    -0.840     0.200
    14.916     8.575     0.200
    15.829     4.434     0.200
    15.935     4.598     0.200
    19.679     2.150     0.200
    20.930     2.934     0.200
    22.055     2.613     0.200
    22.315     1.364     0.200
    22.566     1.707     0.200
    22.802     2.230     0.200
    22.899     2.313     0.200
    23.689     1.484     0.200
    24.105     2.494     0.200
    24.636     2.959     0.200
    27.448    -0.320     0.200
    27.951     0.392     0.200
    30.939     0.337     0.200
    31.225    -0.185     0.200
    31.217     1.889     0.200
    31.339     0.017     0.200
    31.630     0.253     0.200
    32.628     1.511     0.200
    34.733    -0.159     0.200
    34.842    -0.900     0.200
    35.436    -0.801     0.200
    36.071    -1.740     0.200
    40.072    -0.883     0.200
    43.840    -0.580     0.200
    45.330    -1.437     0.200
    51.927     1.756     0.200
    52.498    -0.271     0.200
    52.803     0.475     0.200
    54.099    -0.016     0.200
    54.158     0.256     0.200
    55.313    -0.398     0.200
    54.991     6.025     0.200
    55.051     5.992     0.200
    55.207     6.169     0.200
    55.273     6.093     0.200
    56.267    -0.220     0.200
    57.598    -0.023     0.200
    57.963     5.418     0.200
    57.977     6.321     0.200
    58.095     5.494     0.200
    58.154     5.082     0.200
    58.232     5.542     0.200
    64.661     0.204     0.200
    70.224    -0.792     0.200
    84.118     0.725     0.200
    84.613     0.425     0.200
    84.665     0.566     0.200
    84.665     1.167     0.200
    86.224    -1.190     0.200
    86.545     0.238     0.200
    86.559    -0.931     0.200
    87.970    -1.229     0.200
    90.281     0.532     0.200
    90.622    -0.055     0.200
    91.356    -0.063     0.200
    92.059    -0.715     0.200
    94.131     0.740     0.200
    96.271     0.468     0.200
    15.674     4.169     0.200
    17.249     1.938     0.200
    17.376     2.053     0.200
    19.093    -1.972     0.200
    21.975    -1.510     0.200
    23.527    -4.177     0.200
    23.527    -2.279     0.200
    23.912     2.502     0.200
    23.996     1.029     0.200
    24.244     1.767     0.200
    24.493    -2.002     0.200
    24.325     2.326     0.200
    25.094     1.821     0.200
    25.314     2.029     0.200
    26.024     2.590     0.200
    27.492     1.864     0.200
    28.139     0.076     0.200
    29.126     1.400     0.200
    29.053     2.448     0.200
    29.450    -2.275     0.200
    30.217     0.240     0.200
    30.282     4.063     0.200
    31.324     4.372     0.200
    32.477    -2.765     0.200
    32.385    -0.954     0.200
    32.661     1.026     0.200
    33.051    -0.786     0.200
    34.075     1.294     0.200
    34.734     0.593     0.200
    35.677    -2.033     0.200
    35.791    -3.505     0.200
    36.781    -1.970     0.200
    36.877    -2.781     0.200
    39.980     2.122     0.200
    45.251    -2.188     0.200
    46.138    -1.696     0.200
    46.645    -3.679     0.200
    48.370     2.311     0.200
    48.567     3.396     0.200
    50.522    -0.513     0.200
    51.528    -1.080     0.200
    53.935     1.124     0.200
    53.836     1.949     0.200
    54.245     1.262     0.200
    55.546     0.445     0.200
    55.605     1.024     0.200
    55.787     0.716     0.200
    59.654     0.533     0.200
    60.179     3.721     0.200
    60.818     0.958     0.200
    63.712     1.574     0.200
    66.571    -1.384     0.200
    68.154     1.987     0.200
    70.315     0.204     0.200
    71.420    -0.512     0.200
    80.104     0.830     0.200
    80.530     0.542     0.200
    80.686     0.704     0.200
    80.698     1.640     0.200
    80.925     0.426     0.200
    81.001     0.817     0.200
    80.742     1.404     0.200
    81.061     0.704     0.200
    81.189     0.020     0.200
    84.057    -0.409     0.200
    84.677     0.844     0.200
    84.777     0.741     0.200
    85.073     0.754     0.200
    85.248     0.874     0.200
    85.603     0.411     0.200
    85.629     2.280     0.200
    85.841     1.128     0.200
    85.835     3.158     0.200
    86.679     2.298     0.200
    86.721     2.089     0.200
    86.880     0.015     0.200
    87.176     0.976     0.200
    87.373     0.021     0.200
    87.635    -0.742     0.200
    88.978     0.007     0.200
    89.887     0.646     0.200
    91.047     0.344     0.200
    91.336     1.300     0.200
    91.463     0.415     0.200
    92.196     0.226     0.200
    92.541     2.432     0.200
    92.914     0.505     0.200
    92.992     0.147     0.200
    97.073     1.696     0.200
    97.912     0.912     0.200
    16.124     2.604     0.200
    17.240     2.629     0.200
    17.240     3.531     0.200
    17.568     2.667     0.200
    18.747    -1.672     0.200
    18.756    -1.268     0.200
    19.427    -1.625     0.200
    20.592    -2.102     0.200
    20.763    -1.148     0.200
    21.383     2.164     0.200
    21.602    -1.877     0.200
    21.757    -0.342     0.200
    21.995    -2.282     0.200
    22.276    -1.982     0.200
    22.470    -2.641     0.200
    22.881    -0.792     0.200
    23.376    -1.011     0.200
    23.866     1.647     0.200
    24.235     2.584     0.200
    24.287     0.805     0.200
    24.424     1.363     0.200
    24.563     2.196     0.200
    25.379     1.871     0.200
    25.628     2.412     0.200
    25.734     1.953     0.200
    26.925    -1.309     0.200
    27.154    -1.065     0.200
    27.222    -2.177     0.200
    27.752     2.276     0.200
    28.979    -1.946     0.200
    29.165     0.597     0.200
    30.271     0.508     0.200
    32.473     0.529     0.200
    32.753     0.078     0.200
    33.035     0.107     0.200
    34.185     0.599     0.200
    34.402    -0.277     0.200
    36.156    -1.372     0.200
    36.358    -3.595     0.200
    37.719     1.543     0.200
    39.041     2.229     0.200
    39.847    -3.493     0.200
    40.086     2.522     0.200
    40.063     4.716     0.200
    45.209    -1.056     0.200
    45.814     3.155     0.200
    47.945     0.695     0.200
    48.145     2.455     0.200
    49.943    -0.816     0.200
    52.004     3.690     0.200
    51.834     2.955     0.200
    52.264     3.755     0.200
    53.968    -0.790     0.200
    55.289     4.625     0.200
    55.735     0.718     0.200
    55.360     4.515     0.200
    55.508     4.647     0.200
    55.587     4.679     0.200
    56.826    -1.559     0.200
    56.745     2.816     0.200
    58.235     3.913     0.200
    58.239     4.191     0.200
    58.370     3.977     0.200
    58.426     3.986     0.200
    58.910    -0.984     0.200
    58.511     3.895     0.200
    59.301    -0.797     0.200
    58.930     2.880     0.200
    59.225     2.833     0.200
    59.518     1.310     0.200
    59.912     3.599     0.200
    66.368    -2.226     0.200
    66.372     0.446     0.200
    67.469     1.269     0.200
    68.308     1.991     0.200
    69.936     0.897     0.200
    71.115    -2.098     0.200
    71.380     0.200     0.200
    76.941     1.665     0.200
    79.593     0.993     0.200
    79.845     1.623     0.200
    80.020     1.680     0.200
    80.173     0.853     0.200
    80.192     0.753     0.200
    80.290     1.224     0.200
    80.412     0.566     0.200
    80.484     1.578     0.200
    80.549     0.832     0.200
    81.013     0.353     0.200
    81.013     0.853     0.200
    81.125     1.155     0.200
    81.060     1.601     0.200
    81.391     1.746     0.200
    81.395     0.521     0.200
    82.351     0.093     0.200
    82.693     1.512     0.200
    82.693     2.012     0.200
    83.398     1.065     0.200
    84.110     0.724     0.200
    84.119     0.276     0.200
    84.100    -0.728     0.200
    84.212     0.700     0.200
    84.310     1.704     0.200
    84.508     0.602     0.200
    84.813     1.662     0.200
    84.892     1.367     0.200
    85.161     0.417     0.200
    85.174     1.351     0.200
    85.157     1.938     0.200
    85.194     1.254     0.200
    86.035     2.673     0.200
    86.058     1.462     0.200
    86.341     1.064     0.200
    86.378     1.279     0.200
    86.401     0.771     0.200
    86.735    -1.470     0.200
    86.767     2.279     0.200
    86.822     0.104     0.200
    86.975     1.663     0.200
    87.030    -0.305     0.200
    87.089     0.405     0.200
    87.240     0.676     0.200
    87.244    -0.244     0.200
    87.338     0.300     0.200
    87.357     1.110     0.200
    87.475     0.435     0.200
    87.664     0.329     0.200
    87.743     0.755     0.200
    87.886     1.376     0.200
    87.939     1.323     0.200
    88.546    -0.047     0.200
    88.695     0.549     0.200
    89.121     0.350     0.200
    89.289     0.956     0.200
    90.163    -0.628     0.200
    90.268     0.383     0.200
    90.525     0.686     0.200
    90.806     0.880     0.200
    90.950     0.313     0.200
    91.682     0.015     0.200
    92.386     0.361     0.200
    92.473     0.659     0.200
    92.875     1.705     0.200
    93.685     0.574     0.200
    94.384     1.258     0.200
    94.418     2.207     0.200
    94.543     0.632     0.200
    94.838    -0.720     0.200
    94.877    -0.295     0.200
    95.321     0.070     0.200
    94.856     1.199     0.200
    95.264     0.934     0.200
    95.579     1.895     0.200
    95.896     0.452     0.200
    96.563     1.423     0.200
    98.641    -0.140     0.200
    14.596     7.803     0.200
    15.226     5.290     0.200
    17.796     2.199     0.200
    18.104     0.013     0.200
    18.326    -1.220     0.200
    18.652    -0.808     0.200
    18.701    -1.144     0.200
    18.834    -0.806     0.200
    20.497    -0.943     0.200
    21.092    -0.378     0.200
    21.046     2.723     0.200
    21.182     2.754     0.200
    21.456     2.309     0.200
    22.097     3.641     0.200
    22.362    -2.872     0.200
    22.330     0.961     0.200
    22.758     2.920     0.200
    24.054     2.234     0.200
    24.241    -2.175     0.200
    24.489    -1.033     0.200
    31.663    -0.963     0.200
    31.647     4.675     0.200
    31.736     2.394     0.200
    32.404     1.524     0.200
    32.682     3.596     0.200
    34.008     1.331     0.200
    35.628    -1.954     0.200
    36.924     5.975     0.200
    40.956     3.223     0.200
    41.993     4.621     0.200
    47.741     3.968     0.200
    49.897     2.113     0.200
    50.095     3.112     0.200
    50.737     1.059     0.200
    55.861    -0.607     0.200
    65.142     1.052     0.200
    70.514    -1.369     0.200
    72.658     1.313     0.200
    16.322     2.641     0.200
    16.735     3.280     0.200
    16.916     2.731     0.200
    17.272     3.031     0.200
    18.046    -3.669     0.200
    18.189    -0.540     0.200
    18.485    -0.988     0.200
    18.531     0.801     0.200
    18.923    -0.186     0.200
    20.224     2.843     0.200
    20.367    -1.703     0.200
    20.246     2.908     0.200
    20.599     3.294     0.200
    21.439     0.264     0.200
    22.182    -2.257     0.200
    22.240    -2.666     0.200
    23.539     0.976     0.200
    23.513     2.119     0.200
    23.771    -2.538     0.200
    23.848    -3.242     0.200
    23.925     2.555     0.200
    23.972     1.222     0.200
    24.098     1.671     0.200
    24.242     2.465     0.200
    24.810     1.297     0.200
    25.096    -0.609     0.200
    25.063     1.889     0.200
    25.353     1.060     0.200
    25.258     2.422     0.200
    25.317     2.493     0.200
    25.409     2.053     0.200
    26.025     2.779     0.200
    26.610     0.506     0.200
    26.717     2.243     0.200
    26.891    -1.022     0.200
    26.994    -2.555     0.200
    27.141    -1.767     0.200
    27.146    -0.811     0.200
    27.358    -1.911     0.200
    27.540    -1.843     0.200
    27.434     1.510     0.200
    28.091    -0.059     0.200
    28.332    -0.095     0.200
    28.839     1.394     0.200
    29.022     2.470     0.200
    29.945     0.002     0.200
    30.001     4.502     0.200
    30.673     2.570     0.200
    30.938     5.635     0.200
    31.876    -1.517     0.200
    31.804     0.216     0.200
    32.132     0.545     0.200
    32.145     0.122     0.200
    32.503     1.288     0.200
    32.712     0.659     0.200
    33.541     0.736     0.200
    34.481     0.591     0.200
    34.474     1.352     0.200
    35.833    -0.730     0.200
    36.327    -0.555     0.200
    37.915     1.488     0.200
    39.759     1.863     0.200
    40.432    -0.706     0.200
    40.840    -0.873     0.200
    44.888    -1.117     0.200
    44.920    -0.169     0.200
    45.462    -1.663     0.200
    46.114     3.202     0.200
    48.237     2.680     0.200
    48.437     3.443     0.200
    49.092     1.122     0.200
    53.204     2.307     0.200
    53.642    -0.202     0.200
    53.754     1.581     0.200
    54.096     0.684     0.200
    55.408    -0.204     0.200
    55.942     0.770     0.200
    56.522    -1.662     0.200
    57.064     3.606     0.200
    57.565    -0.029     0.200
    58.111    -0.352     0.200
    58.594    -0.418     0.200
    59.043    -0.836     0.200
    59.524     2.842     0.200
    60.231     4.395     0.200
    61.360     0.528     0.200
    61.502     3.374     0.200
    62.227     1.202     0.200
    63.400     1.410     0.200
    66.071    -0.976     0.200
    66.067    -0.044     0.200
    67.981     0.708     0.200
    70.843    -1.750     0.200
    70.929     1.527     0.200
    71.151     0.686     0.200
    76.658     0.114     0.200
    79.400     0.117     0.200
    79.651     1.353     0.200
    79.826     0.705     0.200
    79.981     0.669     0.200
    79.996     1.388     0.200
    80.097     0.643     0.200
    80.220     0.681     0.200
    80.294     0.783     0.200
    80.356     0.950     0.200
    80.527     0.733     0.200
    80.711    -0.251     0.200
    80.748     1.553     0.200
    81.437     2.792     0.200
    82.172     2.133     0.200
    82.370     0.195     0.200
    82.708     0.235     0.200
    83.137     1.018     0.200
    83.774    -0.252     0.200
    83.949     1.455     0.200
    83.961     1.494     0.200
    84.050     1.642     0.200
    84.235     1.904     0.200
    84.346     1.442     0.200
    84.636     0.980     0.200
    84.929     2.702     0.200
    84.955     0.375     0.200
    84.994     0.179     0.200
    85.041     1.342     0.200
    85.251     0.792     0.200
    85.934     2.504     0.200
    85.977     1.188     0.200
    86.233     0.630     0.200
    86.248     0.658     0.200
    86.510    -0.429     0.200
    86.592     1.168     0.200
    86.602     0.219     0.200
    86.624     0.613     0.200
    86.668     0.295     0.200
    86.680     0.740     0.200
    86.769    -0.896     0.200
    86.935     0.192     0.200
    86.999    -0.420     0.200
    87.041     1.278     0.200
    87.060     1.388     0.200
    87.107     0.262     0.200
    87.179     0.210     0.200
    87.192    -0.453     0.200
    87.193     1.741     0.200
    87.220     0.715     0.200
    87.314     0.457     0.200
    87.505     0.043     0.200
    87.558    -0.516     0.200
    87.614     0.719     0.200
    88.317    -0.812     0.200
    88.508     2.483     0.200
    88.527     0.092     0.200
    88.763    -0.217     0.200
    88.872    -0.128     0.200
    88.904     0.019     0.200
    89.268    -0.387     0.200
    89.995     0.017     0.200
    89.941    -0.034     0.200
    90.234     0.400     0.200
    90.338     0.915     0.200
    90.591     1.437     0.200
    90.692    -0.230     0.200
    90.758     0.762     0.200
    91.491     0.461     0.200
    92.182     0.869     0.200
    92.203     0.271     0.200
    92.285     0.393     0.200
    93.264    -0.626     0.200
    94.200     0.573     0.200
    94.233     0.920     0.200
    94.655     0.085     0.200
    94.674     1.297     0.200
    95.124    -0.158     0.200
    95.328     0.909     0.200
    96.370     0.771     0.200
    98.314    -0.099     0.200
    98.995    -0.147     0.200
    15.495     4.187     0.200
    15.794     2.114     0.200
    17.078     1.022     0.200
    19.394    -0.987     0.200
    21.652     1.050     0.200
    21.564     2.498     0.200
    21.756     1.935     0.200
    22.212     1.570     0.200
    22.733    -2.463     0.200
    23.602     1.532     0.200
    23.786     2.453     0.200
    23.864     1.238     0.200
    24.094     2.140     0.200
    24.184     2.720     0.200
    24.340    -2.404     0.200
    24.442    -2.536     0.200
    24.961     1.739     0.200
    25.129     2.209     0.200
    25.186     2.294     0.200
    25.397     1.980     0.200
    25.896     1.856     0.200
    27.422    -1.302     0.200
    27.464    -2.077     0.200
    27.354     2.306     0.200
    27.500    -1.702     0.200
    27.574    -1.964     0.200
    27.605    -2.240     0.200
    27.667    -2.089     0.200
    27.676    -2.077     0.200
    27.890    -2.187     0.200
    27.982    -2.306     0.200
    28.070    -1.990     0.200
    28.004     0.199     0.200
    28.546    -0.529     0.200
    28.920     3.145     0.200
    29.284    -0.187     0.200
    29.759    -1.690     0.200
    30.052     0.313     0.200
    30.724    -1.518     0.200
    31.052    -3.016     0.200
    31.098    -2.717     0.200
    34.496    -0.523     0.200
    35.076    -0.431     0.200
    35.516    -2.617     0.200
    36.604    -0.921     0.200
    36.718    -1.891     0.200
    39.873    -1.340     0.200
    41.176    -0.601     0.200
    45.079    -1.254     0.200
    45.970    -1.807     0.200
    48.471     3.406     0.200
    50.374    -0.816     0.200
    53.696     1.768     0.200
    53.769    -1.066     0.200
    54.095     0.947     0.200
    54.746     4.616     0.200
    54.814     4.323     0.200
    54.965     4.534     0.200
    55.041     4.486     0.200
    55.449     0.344     0.200
    55.449    -0.156     0.200
    56.121     4.427     0.200
    56.816    -2.020     0.200
    57.150     2.810     0.200
    57.700     4.240     0.200
    57.705     4.800     0.200
    57.890     4.503     0.200
    57.973     4.422     0.200
    58.816    -0.563     0.200
    59.590     2.583     0.200
    59.851     2.789     0.200
    59.893     2.496     0.200
    61.521     2.915     0.200
    66.392    -1.112     0.200
    66.884     2.249     0.200
    71.242    -0.795     0.200
    80.526     0.927     0.200
    80.536     1.669     0.200
    80.641     0.909     0.200
    80.765     1.248     0.200
    80.841     0.936     0.200
    80.900     1.326     0.200
    83.273     2.278     0.200
    83.565     1.278     0.200
    84.527     1.178     0.200
    84.540     0.912     0.200
    84.625     1.078     0.200
    84.860     2.198     0.200
    84.922     1.388     0.200
    85.072     2.030     0.200
    85.309     1.950     0.200
    85.461     1.088     0.200
    85.625     1.175     0.200
    86.601     2.056     0.200
    86.822     0.478     0.200
    86.831     0.233     0.200
    87.006    -0.522     0.200
    86.996     1.328     0.200
    87.155     1.053     0.200
    87.189     0.190     0.200
    87.196    -0.544     0.200
    87.214     0.271     0.200
    87.251     0.091     0.200
    87.276     0.669     0.200
    87.462    -0.927     0.200
    87.518     0.104     0.200
    87.593     0.243     0.200
    87.618     1.124     0.200
    87.757    -0.040     0.200
    87.771    -0.509     0.200
    87.816     0.980     0.200
    87.891     0.020     0.200
    88.082    -0.887     0.200
    88.138    -0.349     0.200
    88.807    -1.010     0.200
    89.098    -0.175     0.200
    89.321     0.780     0.200
    89.443    -0.292     0.200
    89.471    -0.227     0.200
    89.711    -0.648     0.200
    90.888    -0.234     0.200
    91.147     1.169     0.200
    91.164    -0.312     0.200
    91.200     0.620     0.200
    91.303    -0.157     0.200
    92.036     0.449     0.200
    92.357     0.465     0.200
    92.756     1.122     0.200
    92.832     0.770     0.200
    94.752     0.046     0.200
    95.210     0.850     0.200
    95.225     1.780     0.200
    95.660    -0.205     0.200
    95.933     0.855     0.200
    96.694     1.097     0.200
    96.912     1.310     0.200
    16.404     2.200     0.200
    17.485     2.133     0.200
    18.884    -1.114     0.200
    19.336    -1.064     0.200
    21.678     1.354     0.200
    21.986     0.359     0.200
    22.018     1.314     0.200
    22.566    -2.519     0.200
    23.973    -3.049     0.200
    24.115    -2.237     0.200
    24.530     2.176     0.200
    24.580     1.021     0.200
    24.703     2.292     0.200
    24.850     2.358     0.200
    25.414     2.529     0.200
    25.669     0.219     0.200
    25.671     1.602     0.200
    25.864     2.053     0.200
    25.922     2.425     0.200
    26.015     1.988     0.200
    26.631     3.421     0.200
    27.024    -1.923     0.200
    27.172    -1.848     0.200
    27.263     0.927     0.200
    27.407     2.740     0.200
    28.042     1.964     0.200
    28.700     0.107     0.200
    29.055    -2.147     0.200
    29.241     1.096     0.200
    29.420     1.114     0.200
    29.475    -1.971     0.200
    29.592     0.791     0.200
    29.456     4.896     0.200
    32.051     2.492     0.200
    32.278    -1.499     0.200
    32.375     4.650     0.200
    32.737     0.484     0.200
    33.107     1.246     0.200
    33.277     0.165     0.200
    34.453     0.541     0.200
    34.867     1.961     0.200
    35.228    -2.147     0.200
    36.401    -0.202     0.200
    36.840    -1.445     0.200
    38.833    -1.183     0.200
    45.443    -1.176     0.200
    47.847     3.486     0.200
    49.951    -0.957     0.200
    51.602     2.912     0.200
    54.219    -0.210     0.200
    54.362     1.551     0.200
    54.700     1.195     0.200
    55.342     9.958     0.200
    56.006     0.590     0.200
    56.006     0.491     0.200
    57.023    -1.549     0.200
    58.709     0.117     0.200
    59.133    -0.128     0.200
    63.380     0.421     0.200
    65.849     0.696     0.200
    66.554    -1.724     0.200
    66.668    -0.554     0.200
    68.582     1.264     0.200
    71.473     1.620     0.200
    77.105     1.014     0.200
    78.763     0.098     0.200
    78.834     0.713     0.200
    79.203     0.486     0.200
    79.295     0.585     0.200
    79.373     0.259     0.200
    80.340     0.924     0.200
    80.511     1.203     0.200
    80.531     0.495     0.200
    81.133     0.882     0.200
    81.133     1.282     0.200
    81.354     1.706     0.200
    81.568     3.573     0.200
    83.005     2.055     0.200
    83.530     0.548     0.200
    84.124     0.210     0.200
    84.230     0.274     0.200
    84.317     0.929     0.200
    84.353    -0.852     0.200
    84.353    -0.352     0.200
    84.525     0.179     0.200
    84.783     0.977     0.200
    85.019     1.789     0.200
    85.201     0.179     0.200
    85.249     0.840     0.200
    85.255     1.608     0.200
    85.659     0.395     0.200
    86.375     1.359     0.200
    86.379     0.038     0.200
    86.409    -0.208     0.200
    86.477    -0.748     0.200
    86.487    -0.547     0.200
    86.714    -0.906     0.200
    86.754    -0.103     0.200
    86.769    -0.176     0.200
    86.823    -0.941     0.200
    86.806    -0.058     0.200
    86.831     0.019     0.200
    86.989    -0.352     0.200
    87.099     0.216     0.200
    87.162    -0.290     0.200
    87.162     0.210     0.200
    87.256     0.252     0.200
    87.269     1.689     0.200
    87.353    -0.015     0.200
    87.363    -0.165     0.200
    87.407     0.426     0.200
    87.491    -0.082     0.200
    87.552    -0.174     0.200
    87.679    -0.085     0.200
    87.729    -0.223     0.200
    87.720     0.523     0.200
    88.499     0.830     0.200
    88.718     0.795     0.200
    88.865     1.102     0.200
    89.063     0.374     0.200
    89.644    -0.551     0.200
    90.539     1.174     0.200
    90.568     1.139     0.200
    90.998     0.140     0.200
    91.037    -1.038     0.200
    91.730     0.147     0.200
    92.023     0.291     0.200
    92.426    -0.470     0.200
    92.518     0.603     0.200
    92.518     1.103     0.200
    93.624     0.007     0.200
    94.902     1.340     0.200
    95.082     0.515     0.200
    95.377    -0.031     0.200
    96.613     0.347     0.200
    97.463     0.501     0.200
    21.504     2.834     0.200
    32.264     2.368     0.200
    45.520    -0.195     0.200
    48.080     3.490     0.200
    50.230     1.540     0.200
    54.221     0.401     0.200
    54.240     1.465     0.200
    54.616     0.734     0.200
    55.950     0.724     0.200
    58.650    -0.132     0.200
    62.552     1.876     0.200
    79.100     0.047     0.200
    79.168     0.379     0.200
    79.540     0.251     0.200
    79.631     0.054     0.200
    79.710     0.126     0.200
    79.964     0.449     0.200
    80.391     0.748     0.200
    80.544     0.526     0.200
    80.563     0.626     0.200
    80.661     0.500     0.200
    80.783     0.646     0.200
    80.855     0.861     0.200
    83.755     1.304     0.200
    84.477     1.130     0.200
    84.487     0.982     0.200
    84.581     1.407     0.200
    84.876     1.220     0.200
    85.252    -0.662     0.200
    85.544     0.779     0.200
    85.560     0.900     0.200
    85.589     0.855     0.200
    85.872     1.252     0.200
    86.743     1.066     0.200
    86.760    -0.206     0.200
    86.767     0.799     0.200
    86.767     0.848     0.200
    86.992    -1.199     0.200
    87.104    -0.592     0.200
    87.116     0.147     0.200
    87.136     1.250     0.200
    87.134     0.262     0.200
    87.189     0.094     0.200
    87.387    -0.862     0.200
    87.456     0.104     0.200
    87.598     1.023     0.200
    87.608    -0.925     0.200
    87.620     0.720     0.200
    87.627     0.385     0.200
    87.706    -0.193     0.200
    87.718    -0.349     0.200
    87.843     0.053     0.200
    88.032    -0.044     0.200
    88.084    -0.489     0.200
    88.914    -1.304     0.200
    89.064     0.188     0.200
    89.409    -0.127     0.200
    89.444     0.207     0.200
    89.882    -0.741     0.200
    91.144     1.185     0.200
    91.297    -0.324     0.200
    92.757     0.426     0.200
    92.844     0.724     0.200
    15.050     1.895     0.200
    15.730     1.372     0.200
    16.801     1.954     0.200
    17.186    -1.781     0.200
    17.186    -0.679     0.200
    18.308    -1.200     0.200
    18.432    -1.153     0.200
    18.770    -1.448     0.200
    18.770    -0.248     0.200
    21.044     1.584     0.200
    21.310     0.745     0.200
    21.343     1.895     0.200
    21.902     3.458     0.200
    22.053    -1.633     0.200
    23.653    -2.664     0.200
    23.895     2.327     0.200
    23.933     0.980     0.200
    24.028     1.415     0.200
    24.187     1.767     0.200
    24.984     0.725     0.200
    25.022     1.783     0.200
    25.225     2.044     0.200
    25.341     1.994     0.200
    26.754     2.360     0.200
    26.799    -1.148     0.200
    30.909     3.409     0.200
    31.700    -0.548     0.200
    32.051     0.880     0.200
    32.206     2.522     0.200
    32.594    -0.368     0.200
    33.769     1.419     0.200
    35.717    -0.341     0.200
    36.182     0.094     0.200
    46.128     2.311     0.200
    48.241     1.224     0.200
    48.441     1.883     0.200
    68.012     1.740     0.200
    84.046     2.219     0.200
    85.742     2.731     0.200
    86.222    -3.737     0.200
    95.176     1.338     0.200
    17.412     2.347     0.200
    18.509    -0.600     0.200
    18.642    -1.154     0.200
    18.980    -1.663     0.200
    20.858     2.413     0.200
    21.057     1.269     0.200
    21.357     1.248     0.200
    21.392     1.871     0.200
    21.766     2.672     0.200
    22.130     1.791     0.200
    22.301    -2.031     0.200
    23.723     2.297     0.200
    24.065     2.475     0.200
    24.397     1.449     0.200
    24.608     1.526     0.200
    24.852    -1.700     0.200
    24.872     1.825     0.200
    24.988    -0.432     0.200
    25.117     2.294     0.200
    25.677     0.117     0.200
    25.826     3.667     0.200
    26.611     2.381     0.200
    26.708     2.505     0.200
    27.121    -2.112     0.200
    27.249     1.645     0.200
    27.904    -0.316     0.200
    28.515     0.444     0.200
    28.831     2.140     0.200
    30.281    -2.405     0.200
    30.248     2.991     0.200
    30.655    -2.006     0.200
    31.195     4.638     0.200
    31.231     4.819     0.200
    31.897    -2.538     0.200
    32.012    -0.549     0.200
    32.564     1.814     0.200
    32.613    -0.816     0.200
    33.046     6.399     0.200
    33.718     1.549     0.200
    34.729    -0.408     0.200
    35.070    -2.150     0.200
    35.171    -1.718     0.200
    35.516     0.823     0.200
    35.729    -0.806     0.200
    36.270    -1.432     0.200
    36.274    -1.467     0.200
    39.944     0.333     0.200
    40.815    -1.559     0.200
    44.798    -1.823     0.200
    44.815    -1.654     0.200
    44.830    -0.772     0.200
    45.534    -1.157     0.200
    48.461     0.911     0.200
    48.660     1.781     0.200
    49.921    -1.146     0.200
    50.943    -2.363     0.200
    52.408     2.711     0.200
    54.214    -0.551     0.200
    54.336     1.757     0.200
    55.262     0.359     0.200
    56.153     1.976     0.200
    57.249     1.199     0.200
    58.517    -1.191     0.200
    58.689     1.517     0.200
    59.070    -0.528     0.200
    59.376     2.357     0.200
    59.704     1.499     0.200
    59.966     1.799     0.200
    59.995     1.602     0.200
    60.015     1.959     0.200
    60.046     2.850     0.200
    60.174     1.376     0.200
    60.360     2.103     0.200
    60.415     2.725     0.200
    61.873     0.852     0.200
    63.650     0.927     0.200
    65.858     0.852     0.200
    66.039    -2.313     0.200
    67.829     0.716     0.200
    67.965     0.256     0.200
    68.278     0.596     0.200
    68.312     4.081     0.200
    68.954     0.982     0.200
    69.738    -0.264     0.200
    70.850    -2.558     0.200
    71.173     1.483     0.200
    75.213     3.655     0.200
    76.649     1.774     0.200
    78.725     0.409     0.200
    79.102     0.240     0.200
    80.394     0.841     0.200
    80.363     1.206     0.200
    80.549     1.008     0.200
    80.669     0.366     0.200
    82.197     1.284     0.200
    82.197     1.784     0.200
    83.656    -1.269     0.200
    84.074     0.598     0.200
    84.087     0.332     0.200
    84.173     0.896     0.200
    84.417     1.357     0.200
    84.457     0.658     0.200
    84.664     0.812     0.200
    85.058     0.735     0.200
    85.077     0.536     0.200
    85.172     0.262     0.200
    85.266     0.594     0.200
    86.101     2.751     0.200
    86.158     1.171     0.200
    86.236     0.209     0.200
    86.274     0.996     0.200
    86.336     1.295     0.200
    86.369     0.532     0.200
    86.378     0.689     0.200
    86.459    -0.072     0.200
    86.574    -0.273     0.200
    86.705     1.588     0.200
    86.736     0.232     0.200
    86.760     1.015     0.200
    86.792    -0.240     0.200
    86.798     0.634     0.200
    86.823     0.512     0.200
    87.145     1.345     0.200
    87.186     0.644     0.200
    87.241     0.478     0.200
    87.304     0.471     0.200
    87.319     0.201     0.200
    87.362     1.190     0.200
    87.439     0.725     0.200
    87.522     0.722     0.200
    87.630     0.407     0.200
    87.685     0.347     0.200
    88.377    -0.038     0.200
    88.646     0.594     0.200
    88.871     0.137     0.200
    88.991     0.574     0.200
    89.020     0.539     0.200
    89.300     0.123     0.200
    89.801    -0.521     0.200
    89.794    -0.488     0.200
    90.441     1.798     0.200
    90.698     1.001     0.200
    90.741     0.601     0.200
    90.856    -0.135     0.200
    91.589     0.466     0.200
    92.080     0.494     0.200
    92.308     1.643     0.200
    92.308     1.745     0.200
    92.385    -0.214     0.200
    92.362     1.891     0.200
    92.362     2.590     0.200
    95.572     0.352     0.200
    95.894    -0.714     0.200
    96.246     1.083     0.200
    96.465     2.088     0.200
    96.466     0.086     0.200
    97.305     1.790     0.200
    98.178     0.359     0.200
    99.040    -0.498     0.200
    99.040     0.002     0.200
    15.270     4.674     0.200
    15.394     3.079     0.200
    16.596     2.085     0.200
    17.407     0.949     0.200
    18.956    -0.402     0.200
    20.719     2.144     0.200
    21.397     1.851     0.200
    21.436     1.439     0.200
    21.794     2.615     0.200
    21.873     2.272     0.200
    23.379     2.879     0.200
    23.444     1.074     0.200
    23.640     1.183     0.200
    23.748     2.599     0.200
    23.869     1.487     0.200
    23.923     2.101     0.200
    24.348     1.620     0.200
    24.515     1.607     0.200
    24.718     1.757     0.200
    24.762    -0.444     0.200
    24.775     2.437     0.200
    24.945     1.292     0.200
    26.282     2.686     0.200
    28.276     0.721     0.200
    30.635     3.535     0.200
    31.586     5.164     0.200
    31.854    -1.697     0.200
    35.142    -2.278     0.200
    35.508    -0.927     0.200
    36.123    -0.690     0.200
    44.596    -0.668     0.200
    44.627    -0.016     0.200
    45.568    -1.377     0.200
    48.830     1.748     0.200
    49.028     1.726     0.200
    49.302     2.639     0.200
    50.050    -2.046     0.200
    50.911     0.458     0.200
    53.291    -0.209     0.200
    54.603     1.119     0.200
    54.697     3.335     0.200
    54.985     0.457     0.200
    65.917    -1.572     0.200
    67.293     1.154     0.200
    68.662     1.965     0.200
    69.343     1.549     0.200
    84.191     0.234     0.200
    84.206     0.155     0.200
    84.287     0.450     0.200
    84.571     0.413     0.200
    84.629     0.618     0.200
    85.077     0.767     0.200
    85.211     0.600     0.200
    86.477    -1.060     0.200
    86.503     0.811     0.200
    86.504     0.504     0.200
    86.749    -0.394     0.200
    86.867     0.431     0.200
    86.896     0.495     0.200
    86.922     0.165     0.200
    86.936     1.493     0.200
    86.969     0.536     0.200
    87.030    -0.863     0.200
    87.188    -0.230     0.200
    87.215     0.139     0.200
    87.374     0.274     0.200
    87.421     0.249     0.200
    87.508     1.534     0.200
    87.554    -0.286     0.200
    87.746    -0.508     0.200
    88.392    -1.262     0.200
    89.271    -0.200     0.200
    89.783    -0.288     0.200
    90.737     0.165     0.200
    95.902     0.601     0.200
    17.098     3.342     0.200
    17.617     0.575     0.200
    19.825     0.625     0.200
    21.141     3.340     0.200
    21.244     2.234     0.200
    21.342     4.178     0.200
    21.635     2.026     0.200
    21.670     2.355     0.200
    22.053     2.553     0.200
    22.491    -1.112     0.200
    22.415     3.690     0.200
    23.066    -2.900     0.200
    25.134     1.470     0.200
    25.274    -0.008     0.200
    25.536     1.712     0.200
    25.949     0.569     0.200
    28.804     0.859     0.200
    32.303     0.354     0.200
    33.432    -2.521     0.200
    36.540    -1.338     0.200
    45.080    -1.771     0.200
    45.111    -0.821     0.200
    48.193     0.824     0.200
    48.392     1.288     0.200
    51.160     0.219     0.200
    53.815    -0.470     0.200
    58.794    -0.901     0.200
    66.295    -2.122     0.200
    66.707     1.142     0.200
    80.548    -0.088     0.200
    84.200     0.720     0.200
    84.212     0.562     0.200
    84.301     0.607     0.200
    84.584     0.672     0.200
    85.246    -0.252     0.200
    85.291     0.721     0.200
    86.482     0.523     0.200
    86.498     0.144     0.200
    86.852     0.311     0.200
    86.918     1.084     0.200
    86.927     0.644     0.200
    87.185     0.284     0.200
    87.430     1.102     0.200
    87.566     1.348     0.200
    14.154     7.950     0.200
    17.219     2.519     0.200
    17.222     2.736     0.200
    18.357    -0.926     0.200
    18.253     3.864     0.200
    18.671    -0.293     0.200
    18.875    -0.818     0.200
    18.875     1.780     0.200
    19.342    -1.227     0.200
    19.895     2.727     0.200
    20.242     0.853     0.200
    20.194     2.780     0.200
    20.198     1.834     0.200
    20.654     2.492     0.200
    21.127     2.480     0.200
    21.223     1.345     0.200
    21.323     2.269     0.200
    22.131     1.615     0.200
    22.348     1.800     0.200
    22.639    -0.283     0.200
    22.561     2.043     0.200
    23.209    -2.209     0.200
    23.707     2.810     0.200
    24.234    -1.012     0.200
    24.234    -1.512     0.200
    24.074     1.951     0.200
    24.140     0.953     0.200
    24.213     0.883     0.200
    24.323     2.180     0.200
    24.440     2.919     0.200
    24.565     1.473     0.200
    24.618     1.790     0.200
    24.984    -1.841     0.200
    25.093    -1.831     0.200
    24.959     2.186     0.200
    25.044     2.114     0.200
    25.210     1.408     0.200
    25.393    -0.258     0.200
    25.414     2.058     0.200
    25.462     1.918     0.200
    25.471     2.337     0.200
    25.630     1.996     0.200
    26.007     1.682     0.200
    26.181     3.810     0.200
    26.977     2.427     0.200
    27.387    -1.657     0.200
    27.387    -2.055     0.200
    27.618     1.674     0.200
    28.170     1.441     0.200
    28.271    -0.257     0.200
    28.804     0.905     0.200
    28.919     0.881     0.200
    29.125     0.846     0.200
    29.194     3.342     0.200
    29.618     0.077     0.200
    29.624    -0.375     0.200
    29.991     2.777     0.200
    30.595    -1.360     0.200
    30.922    -2.148     0.200
    30.970    -1.970     0.200
    30.991     4.945     0.200
    31.185    -0.198     0.200
    31.808     0.453     0.200
    31.966     2.370     0.200
    32.042     2.700     0.200
    32.082     2.647     0.200
    32.266    -2.267     0.200
    32.412     2.453     0.200
    32.424     1.945     0.200
    32.412     0.453     0.200
    32.412     1.453     0.200
    32.734     1.052     0.200
    32.921     1.499     0.200
    33.019    -0.261     0.200
    33.575    -1.712     0.200
    33.710    -2.388     0.200
    33.835     1.027     0.200
    34.115     0.595     0.200
    34.714    -0.392     0.200
    34.925     1.590     0.200
    35.192    -2.710     0.200
    35.375    -1.284     0.200
    35.466    -2.765     0.200
    35.409     0.425     0.200
    36.135    -0.602     0.200
    36.233    -0.640     0.200
    36.375     1.141     0.200
    36.567    -2.493     0.200
    36.676    -1.319     0.200
    38.028     1.619     0.200
    38.140     1.669     0.200
    38.916     1.857     0.200
    39.026    -0.764     0.200
    39.328    -0.361     0.200
    39.498     0.291     0.200
    39.581    -0.916     0.200
    39.822     0.795     0.200
    39.939     1.121     0.200
    39.984     4.117     0.200
    40.144    -1.678     0.200
    40.153     6.748     0.200
    40.215     1.132     0.200
    40.198     6.771     0.200
    41.049     2.834     0.200
    45.236     0.397     0.200
    45.862    -1.657     0.200
    45.974     3.862     0.200
    46.000     2.059     0.200
    48.145     1.115     0.200
    48.145     1.564     0.200
    48.344     1.783     0.200
    50.180    -1.256     0.200
    53.441     1.823     0.200
    53.377     3.194     0.200
    53.932     0.227     0.200
    53.951     1.686     0.200
    54.036     0.665     0.200
    54.007     2.276     0.200
    55.657     0.330     0.200
    55.657     0.224     0.200
    55.657    -0.370     0.200
    55.815     0.198     0.200
    56.844     0.360     0.200
    57.172     7.641     0.200
    57.790    -0.420     0.200
    58.358    -0.291     0.200
    58.971     5.544     0.200
    59.004     7.714     0.200
    59.025     2.166     0.200
    59.086     2.144     0.200
    59.330     2.453     0.200
    59.592     3.647     0.200
    59.594     4.630     0.200
    59.620     3.455     0.200
    59.639     0.322     0.200
    59.800     2.216     0.200
    61.922    -1.411     0.200
    63.497     0.684     0.200
    66.199     0.692     0.200
    66.722     1.151     0.200
    67.086     4.233     0.200
    67.600     0.277     0.200
    68.003     1.041     0.200
    68.220     0.977     0.200
    68.142     7.363     0.200
    68.782     1.267     0.200
    69.966     4.441     0.200
    71.227    -1.146     0.200
    71.550     2.510     0.200
    71.814    -1.180     0.200
    78.639     0.538     0.200
    79.499     1.024     0.200
    79.745     1.094     0.200
    79.794     1.123     0.200
    79.799     0.496     0.200
    80.050     0.939     0.200
    80.225     0.892     0.200
    80.380     0.861     0.200
    80.395     0.977     0.200
    80.496     0.833     0.200
    80.619     0.976     0.200
    80.673     0.885     0.200
    80.693     0.580     0.200
    80.804     1.186     0.200
    80.748     1.087     0.200
    80.938     2.071     0.200
    81.068     0.377     0.200
    81.068     0.877     0.200
    81.386     0.689     0.200
    81.659     1.247     0.200
    81.787     0.574     0.200
    82.576     1.039     0.200
    83.162     3.402     0.200
    83.537     1.366     0.200
    83.528     1.914     0.200
    83.551     1.695     0.200
    83.800     1.118     0.200
    83.895     2.832     0.200
    84.060    -0.707     0.200
    84.342     1.359     0.200
    84.353     0.905     0.200
    84.443     0.244     0.200
    84.726     1.314     0.200
    84.750     2.299     0.200
    84.855     0.766     0.200
    85.028     1.002     0.200
    85.075     1.164     0.200
    85.312     1.581     0.200
    85.336     0.361     0.200
    85.355     1.066     0.200
    85.394     0.072     0.200
    85.432     0.780     0.200
    85.639     2.050     0.200
    86.321     2.379     0.200
    86.336     1.402     0.200
    86.460     1.193     0.200
    86.483     1.181     0.200
    86.560     1.301     0.200
    86.578     1.613     0.200
    86.171     6.217     0.200
    86.621     1.204     0.200
    86.638     0.119     0.200
    86.649     0.170     0.200
    86.909    -0.103     0.200
    86.988     1.212     0.200
    86.992     0.296     0.200
    87.002     2.144     0.200
    87.012     0.492     0.200
    87.059     0.166     0.200
    87.065     0.640     0.200
    87.159    -0.321     0.200
    87.207     0.448     0.200
    87.326    -0.129     0.200
    87.358    -0.184     0.200
    87.396    -0.765     0.200
    87.439     0.024     0.200
    87.474     0.856     0.200
    87.496     0.054     0.200
    87.571    -0.111     0.200
    87.584    -0.373     0.200
    87.590     1.498     0.200
    87.605     0.328     0.200
    87.707     0.136     0.200
    87.749     3.737     0.200
    87.897    -0.365     0.200
    87.951     0.682     0.200
    88.102     1.864     0.200
    88.201     4.592     0.200
    88.202     2.887     0.200
    88.448     1.227     0.200
    88.922     0.094     0.200
    89.160     0.975     0.200
    89.267    -0.126     0.200
    89.299    -0.079     0.200
    89.317     0.742     0.200
    89.513     3.222     0.200
    89.661     0.026     0.200
    89.744     0.938     0.200
    90.132     1.228     0.200
    90.157    -0.289     0.200
    90.272     0.976     0.200
    90.188     0.168     0.200
    90.320     1.150     0.200
    90.389     1.429     0.200
    90.425     2.164     0.200
    90.433     0.528     0.200
    90.736     0.513     0.200
    90.783     2.397     0.200
    90.917     0.476     0.200
    90.989     1.341     0.200
    91.058     0.219     0.200
    91.057     1.223     0.200
    91.067    -0.024     0.200
    91.071     1.760     0.200
    91.089     0.074     0.200
    91.157    -0.440     0.200
    91.320     0.806     0.200
    91.366     0.592     0.200
    91.820     1.486     0.200
    91.890    -0.034     0.200
    92.200     0.631     0.200
    92.263     1.441     0.200
    92.486     0.410     0.200
    92.573     1.007     0.200
    92.580    -0.024     0.200
    92.600     0.882     0.200
    92.701     4.418     0.200
    92.959    -0.275     0.200
    93.530     0.597     0.200
    93.661    -0.008     0.200
    94.397     0.114     0.200
    94.487     0.897     0.200
    94.536     5.975     0.200
    94.867     0.456     0.200
    95.053    -0.393     0.200
    95.072     1.621     0.200
    95.516    -0.007     0.200
    95.523     0.159     0.200
    95.576     1.017     0.200
    95.742     1.461     0.200
    95.959     1.575     0.200
    96.099     0.337     0.200
    96.402    -0.541     0.200
    96.454     4.225     0.200
    96.542     1.826     0.200
    96.765     2.419     0.200
    97.612     0.991     0.200
    98.147    -0.418     0.200
    98.062     1.964     0.200
    99.090     0.362     0.200
    20.605     2.760     0.200
    21.161     2.760     0.200
    21.171     3.643     0.200
    21.284     2.428     0.200
    21.368     2.531     0.200
    21.808     1.609     0.200
    21.844     1.427     0.200
    22.091     2.785     0.200
    22.308     2.270     0.200
    22.445     4.020     0.200
    22.503     1.398     0.200
    22.764    -1.363     0.200
    24.022     2.178     0.200
    24.348    -0.795     0.200
    24.096     1.004     0.200
    24.307     2.078     0.200
    24.409     2.749     0.200
    24.515     1.688     0.200
    25.168     1.245     0.200
    25.419    -0.436     0.200
    25.422     2.042     0.200
    25.612     1.713     0.200
    26.136     0.269     0.200
    26.938     2.232     0.200
    28.938     0.971     0.200
    33.664    -1.927     0.200
    36.163    -0.787     0.200
    36.738    -1.191     0.200
    45.274     0.559     0.200
    45.992    -1.118     0.200
    50.334    -1.659     0.200
    53.448     3.136     0.200
    53.952    -0.553     0.200
    55.654     0.120     0.200
    66.857     1.257     0.200
    71.325    -1.169     0.200
    79.940     0.304     0.200
    80.190     0.648     0.200
    80.366     0.805     0.200
    80.637     0.450     0.200
    80.760     0.893     0.200
    80.835     0.892     0.200
    84.494     0.463     0.200
    84.505     0.405     0.200
    84.595     0.455     0.200
    84.878     0.426     0.200
    85.238     1.620     0.200
    85.520     0.918     0.200
    85.586     0.285     0.200
    86.008     2.296     0.200
    86.777     0.514     0.200
    86.792     0.236     0.200
    87.147     0.416     0.200
    87.168     0.710     0.200
    87.213     0.392     0.200
    87.223     1.742     0.200
    87.480     0.305     0.200
    87.511     0.452     0.200
    87.723     0.231     0.200
    87.859     0.390     0.200
    88.049    -0.013     0.200
    90.425     0.033     0.200
    95.216     1.536     0.200
    96.102     0.798     0.200
    17.148     1.985     0.200
    18.413    -0.650     0.200
    18.927    -0.403     0.200
    20.482     1.731     0.200
    20.858    -1.540     0.200
    21.037     2.727     0.200
    21.048     1.611     0.200
    21.163     2.375     0.200
    21.245     1.490     0.200
    21.481    -1.645     0.200
    21.713     0.462     0.200
    21.750     0.271     0.200
    21.953     1.493     0.200
    21.969     1.722     0.200
    22.186     1.808     0.200
    22.379     1.351     0.200
    22.402     1.909     0.200
    22.681    -2.251     0.200
    22.725    -2.219     0.200
    23.342    -2.726     0.200
    23.443     0.514     0.200
    23.899     2.333     0.200
    23.974     1.149     0.200
    24.191     1.770     0.200
    24.289     2.569     0.200
    24.393    -2.475     0.200
    24.392     1.538     0.200
    24.461     1.809     0.200
    24.441     1.986     0.200
    24.784     1.460     0.200
    25.046     1.681     0.200
    25.242     2.004     0.200
    25.286     1.795     0.200
    25.298     2.385     0.200
    25.316    -0.776     0.200
    25.495     2.205     0.200
    25.744     3.242     0.200
    26.008     2.350     0.200
    26.021     2.336     0.200
    26.046     0.610     0.200
    26.816     2.354     0.200
    27.461     1.860     0.200
    27.533    -2.181     0.200
    27.531     2.837     0.200
    28.111     0.049     0.200
    28.832     0.436     0.200
    32.309    -1.259     0.200
    32.314    -2.304     0.200
    32.605     0.943     0.200
    32.677     2.417     0.200
    32.950    -0.377     0.200
    33.594    -1.898     0.200
    33.641    -0.006     0.200
    34.005     0.936     0.200
    34.585     1.409     0.200
    34.797     1.073     0.200
    34.962    -0.347     0.200
    35.492    -1.908     0.200
    35.591    -2.457     0.200
    36.061    -0.390     0.200
    36.652    -1.339     0.200
    36.690    -1.857     0.200
    45.145    -1.596     0.200
    45.161    -0.825     0.200
    45.958    -1.228     0.200
    48.349     2.129     0.200
    48.546     1.907     0.200
    48.819     2.711     0.200
    50.331    -1.012     0.200
    50.500     1.012     0.200
    53.315     2.432     0.200
    53.572     3.341     0.200
    53.846    -0.064     0.200
    54.171     1.362     0.200
    54.192     1.409     0.200
    54.285     0.637     0.200
    55.540     0.554     0.200
    55.540     0.753     0.200
    56.003     1.235     0.200
    57.657     0.503     0.200
    58.239     0.222     0.200
    58.876     0.180     0.200
    59.484     1.974     0.200
    63.644     1.201     0.200
    66.431    -1.413     0.200
    66.969     0.757     0.200
    68.096     1.539     0.200
    68.225     1.127     0.200
    69.030     1.505     0.200
    71.135     1.296     0.200
    71.262    -1.673     0.200
    79.919     0.531     0.200
    80.344     1.038     0.200
    80.500     0.699     0.200
    80.611     1.403     0.200
    80.795     0.718     0.200
    80.815     1.312     0.200
    80.923     1.234     0.200
    81.561     1.149     0.200
    81.841     0.670     0.200
    84.487     1.810     0.200
    84.499     1.546     0.200
    84.586     1.905     0.200
    84.870     1.776     0.200
    85.250     2.171     0.200
    85.450     0.976     0.200
    85.478     2.536     0.200
    85.482     0.714     0.200
    85.582     1.617     0.200
    86.487     2.245     0.200
    86.530     1.831     0.200
    86.609     1.444     0.200
    86.692     1.039     0.200
    86.776     0.931     0.200
    86.788     1.169     0.200
    87.122     0.944     0.200
    87.144     0.533     0.200
    87.167     0.623     0.200
    87.208     0.325     0.200
    87.209    -0.679     0.200
    87.226     0.839     0.200
    87.464    -0.614     0.200
    87.475     0.234     0.200
    87.505     0.288     0.200
    87.564     0.805     0.200
    87.604     0.113     0.200
    87.649     0.199     0.200
    87.716     0.077     0.200
    87.721     0.256     0.200
    87.766     0.540     0.200
    87.851     0.235     0.200
    88.042    -0.071     0.200
    88.217     0.699     0.200
    88.801    -2.056     0.200
    89.061     0.523     0.200
    89.406     0.204     0.200
    90.069     0.006     0.200
    90.222    -0.409     0.200
    90.587     0.394     0.200
    90.861     0.319     0.200
    91.071    -0.557     0.200
    91.117     1.631     0.200
    91.211    -1.007     0.200
    91.221    -0.955     0.200
    91.277     1.084     0.200
    92.010     0.792     0.200
    92.327     1.225     0.200
    92.442     0.094     0.200
    92.702     0.793     0.200
    92.727     0.680     0.200
    92.805     0.718     0.200
    93.279     0.137     0.200
    93.664     0.665     0.200
    94.533     0.372     0.200
    95.180     0.908     0.200
    95.197     0.733     0.200
    95.638    -0.879     0.200
    95.822     0.581     0.200
    96.083     1.691     0.200
    96.215    -0.307     0.200
    96.316     1.537     0.200
    96.886     1.650     0.200
    19.020    -0.995     0.200
    18.980     2.440     0.200
    19.498    -1.235     0.200
    19.716     3.387     0.200
    20.344     3.551     0.200
    20.896     2.565     0.200
    21.037     3.042     0.200
    21.109     2.273     0.200
    21.705     2.060     0.200
    21.842     2.393     0.200
    22.189     2.692     0.200
    22.571     2.621     0.200
    22.818    -2.290     0.200
    22.850    -2.235     0.200
    23.387     0.708     0.200
    23.620     1.531     0.200
    23.756     2.081     0.200
    23.842     1.002     0.200
    24.096     2.380     0.200
    24.175     2.460     0.200
    24.250     1.469     0.200
    24.582    -0.852     0.200
    24.633    -3.123     0.200
    24.915     1.509     0.200
    25.102     2.412     0.200
    25.158     2.300     0.200
    25.280    -0.102     0.200
    26.157    -4.253     0.200
    26.625     1.013     0.200
    26.690     2.132     0.200
    27.540    -3.313     0.200
    27.710    -3.237     0.200
    28.785     0.788     0.200
    28.899     3.676     0.200
    33.933     0.789     0.200
    35.644    -1.488     0.200
    36.670    -0.869     0.200
    36.847    -1.773     0.200
    46.090    -1.569     0.200
    48.723     1.440     0.200
    50.679     1.144     0.200
    53.800    -0.642     0.200
    54.086     1.066     0.200
    58.869    -0.600     0.200
    71.336    -1.370     0.200
    80.970     0.420     0.200
    84.662     1.350     0.200
    84.676     1.082     0.200
    84.761     1.354     0.200
    85.044     1.429     0.200
    86.960     1.256     0.200
    87.352     1.353     0.200
    87.416     1.344     0.200
    87.654     0.097     0.200
    88.026    -0.075     0.200
    17.199     3.056     0.200
    17.202     4.285     0.200
    18.088     1.152     0.200
    18.376    -0.676     0.200
    18.594    -0.973     0.200
    18.893    -1.056     0.200
    20.127    -0.535     0.200
    20.319     0.973     0.200
    20.890     1.684     0.200
    21.158     2.794     0.200
    21.170     3.670     0.200
    21.274     2.544     0.200
    21.398    -2.087     0.200
    21.363     1.590     0.200
    21.785     2.065     0.200
    22.439     1.089     0.200
    22.506     2.380     0.200
    22.614    -1.774     0.200
    22.667    -1.334     0.200
    24.290     1.519     0.200
    24.283     1.973     0.200
    24.394     2.263     0.200
    24.906     3.100     0.200
    25.160     1.579     0.200
    25.371    -0.125     0.200
    25.361     1.662     0.200
    25.564    -1.677     0.200
    25.589     1.395     0.200
    26.128     4.513     0.200
    26.928     1.493     0.200
    27.434    -2.745     0.200
    27.571     3.328     0.200
    29.540     3.499     0.200
    29.656    -1.528     0.200
    30.062     3.881     0.200
    30.909     2.400     0.200
    31.608     2.244     0.200
    32.283    -0.685     0.200
    32.381    -0.552     0.200
    32.503     1.488     0.200
    32.696     1.200     0.200
    34.082     2.606     0.200
    35.413    -0.884     0.200
    36.114    -1.395     0.200
    36.607    -1.107     0.200
    36.670    -1.648     0.200
    38.107     1.980     0.200
    39.900     0.667     0.200
    45.188    -1.801     0.200
    45.204    -1.131     0.200
    45.219    -0.948     0.200
    45.894    -1.385     0.200
    48.207     1.655     0.200
    48.678     2.425     0.200
    50.229    -1.905     0.200
    50.357     0.518     0.200
    51.326    -0.173     0.200
    53.436     3.272     0.200
    53.907    -1.276     0.200
    53.906     1.232     0.200
    54.113    -0.283     0.200
    54.264     1.120     0.200
    54.285     0.968     0.200
    54.859     1.797     0.200
    55.623     0.292     0.200
    55.623     0.601     0.200
    55.623     0.394     0.200
    55.872     0.503     0.200
    56.802    -0.328     0.200
    58.323    -0.134     0.200
    58.911    -0.929     0.200
    59.050     3.102     0.200
    59.077     1.915     0.200
    59.376     1.744     0.200
    59.684     2.325     0.200
    68.183     0.915     0.200
    68.859     1.794     0.200
    71.240     0.482     0.200
    78.648     2.185     0.200
    79.543    -0.110     0.200
    79.788    -0.241     0.200
    79.838    -0.113     0.200
    80.733     0.568     0.200
    80.707     1.006     0.200
    80.707     1.206     0.200
    81.442     1.793     0.200
    84.034    -0.377     0.200
    84.389     0.521     0.200
    84.400     0.365     0.200
    84.489     0.412     0.200
    84.653     2.483     0.200
    84.773     0.381     0.200
    85.047     1.504     0.200
    85.131     2.082     0.200
    85.386     1.307     0.200
    85.423     0.022     0.200
    85.480     0.839     0.200
    85.654     2.475     0.200
    85.712     2.083     0.200
    86.362     3.472     0.200
    86.398     2.796     0.200
    86.671     0.459     0.200
    86.687    -0.119     0.200
    86.939    -1.749     0.200
    87.031     1.698     0.200
    87.041     0.254     0.200
    87.062     0.447     0.200
    87.107     0.029     0.200
    87.116     0.387     0.200
    87.177     0.292     0.200
    87.374    -0.164     0.200
    87.405    -0.217     0.200
    87.419    -1.078     0.200
    87.480     0.525     0.200
    87.516    -0.150     0.200
    87.545    -0.088     0.200
    87.618    -0.337     0.200
    87.631     0.298     0.200
    87.632     1.293     0.200
    87.754    -0.185     0.200
    87.944    -0.590     0.200
    87.998     0.155     0.200
    88.127     1.440     0.200
    88.967    -0.823     0.200
    89.312    -0.339     0.200
    89.344    -0.488     0.200
    89.682     0.128     0.200
    90.153    -0.272     0.200
    90.319     0.651     0.200
    90.777     0.522     0.200
    91.114     0.455     0.200
    91.929     1.180     0.200
    92.474     1.359     0.200
    92.620     1.488     0.200
    92.723     1.013     0.200
    93.200     1.314     0.200
    93.573     1.093     0.200
    94.638     1.400     0.200
    95.113     1.831     0.200
    95.561     0.985     0.200
    95.561     0.883     0.200
    95.653     0.562     0.200
    96.000     1.985     0.200
    96.137     1.361     0.200
    96.237     2.509     0.200
    96.743     4.111     0.200
    16.940     2.657     0.200
    16.976     4.901     0.200
    17.987    -0.039     0.200
    18.132     2.485     0.200
    18.306    -0.443     0.200
    19.296    -1.009     0.200
    19.590     1.278     0.200
    20.520     2.162     0.200
    20.656     0.480     0.200
    20.989     2.088     0.200
    21.519    -0.417     0.200
    21.556     0.982     0.200
    21.556    -0.218     0.200
    21.715     2.273     0.200
    21.898     2.321     0.200
    22.067     2.517     0.200
    22.121     1.943     0.200
    22.444     1.500     0.200
    22.650    -1.890     0.200
    22.650    -2.690     0.200
    22.636     1.459     0.200
    22.666     3.444     0.200
    23.319    -2.448     0.200
    23.273     2.534     0.200
    23.642     2.503     0.200
    23.719     0.996     0.200
    23.948     1.301     0.200
    24.039     2.467     0.200
    24.134     1.901     0.200
    24.183     2.154     0.200
    24.402    -3.241     0.200
    24.527     1.021     0.200
    24.698     0.265     0.200
    24.791     1.514     0.200
    25.103    -0.227     0.200
    25.029     2.152     0.200
    25.041     2.136     0.200
    25.251     2.233     0.200
    25.574     2.195     0.200
    25.861     1.195     0.200
    25.751     1.891     0.200
    25.764     1.878     0.200
    26.563     1.854     0.200
    27.097    -0.255     0.200
    27.209     1.540     0.200
    27.525    -1.102     0.200
    27.856     1.940     0.200
    27.858     0.323     0.200
    28.503     1.074     0.200
    28.613     0.795     0.200
    28.666     0.924     0.200
    28.767    -1.878     0.200
    28.819     0.863     0.200
    28.775     2.757     0.200
    29.328     1.249     0.200
    29.692    -0.678     0.200
    30.323     3.941     0.200
    30.652    -2.269     0.200
    30.476     2.184     0.200
    30.981    -3.071     0.200
    31.025    -2.664     0.200
    31.259     2.777     0.200
    31.314     1.791     0.200
    31.386     3.657     0.200
    31.478     3.350     0.200
    31.899     5.646     0.200
    32.080    -0.443     0.200
    32.199    -0.790     0.200
    32.364     1.238     0.200
    32.364     1.383     0.200
    32.742    -1.249     0.200
    32.899     2.679     0.200
    33.134    -2.676     0.200
    33.454    -0.854     0.200
    33.391     2.282     0.200
    33.725    -2.426     0.200
    33.772     0.765     0.200
    34.557     2.163     0.200
    35.449    -2.331     0.200
    35.557    -1.361     0.200
    35.850    -0.676     0.200
    35.873     2.631     0.200
    36.477    -1.334     0.200
    36.654    -2.542     0.200
    37.765     1.529     0.200
    38.452     1.133     0.200
    38.489     1.428     0.200
    39.141    -3.039     0.200
    39.141    -2.238     0.200
    39.327     2.810     0.200
    39.647     2.740     0.200
    39.930     1.389     0.200
    40.039     1.478     0.200
    40.375     2.195     0.200
    41.102     0.900     0.200
    41.503     3.004     0.200
    41.574     4.626     0.200
    44.942    -1.385     0.200
    44.959    -0.202     0.200
    45.605     2.256     0.200
    45.891    -1.098     0.200
    46.454     2.666     0.200
    48.610     1.919     0.200
    48.610     0.526     0.200
    49.080     1.210     0.200
    50.328    -1.689     0.200
    50.312     2.328     0.200
    51.493     5.039     0.200
    52.494     2.387     0.200
    53.074     2.099     0.200
    53.550     1.204     0.200
    53.628     0.034     0.200
    53.929     0.930     0.200
    53.949     0.779     0.200
    53.949     1.078     0.200
    54.520     0.219     0.200
    54.462     1.140     0.200
    54.761     4.972     0.200
    54.828     4.788     0.200
    55.304     0.609     0.200
    55.304     0.384     0.200
    55.304     0.349     0.200
    54.979     5.092     0.200
    55.054     5.052     0.200
    56.263     4.973     0.200
    56.457     0.188     0.200
    57.413     0.314     0.200
    57.600     2.996     0.200
    58.002    -0.027     0.200
    57.716     4.878     0.200
    59.378    -0.102     0.200
    59.378    -0.399     0.200
    59.388     1.927     0.200
    59.411     1.570     0.200
    59.436     1.397     0.200
    59.736     1.832     0.200
    59.997     2.039     0.200
    60.023     1.860     0.200
    60.039     1.445     0.200
    60.204     1.614     0.200
    61.594    -0.532     0.200
    62.142     1.785     0.200
    63.984     0.851     0.200
    64.007     1.699     0.200
    66.271    -1.596     0.200
    67.523     2.434     0.200
    67.856     1.033     0.200
    68.070     0.987     0.200
    67.881     6.175     0.200
    68.483     0.400     0.200
    68.483     0.700     0.200
    69.374     0.865     0.200
    69.265     1.739     0.200
    69.265     3.639     0.200
    69.329     3.343     0.200
    69.987     3.985     0.200
    70.059    -0.355     0.200
    69.951     2.208     0.200
    69.951     5.208     0.200
    70.549    -0.952     0.200
    71.134    -1.714     0.200
    71.556     1.238     0.200
    71.556     2.439     0.200
    71.374    -3.661     0.200
    71.392     1.730     0.200
    76.912     1.321     0.200
    77.659     2.131     0.200
    78.526     1.122     0.200
    79.611    -0.119     0.200
    79.853    -0.531     0.200
    79.877     0.241     0.200
    79.907    -0.422     0.200
    80.125     0.502     0.200
    80.301     0.748     0.200
    80.459     0.999     0.200
    80.468     0.950     0.200
    80.366     1.303     0.200
    80.574     0.880     0.200
    80.472     2.732     0.200
    80.698     0.717     0.200
    80.756     0.208     0.200
    80.773     2.417     0.200
    80.881     0.540     0.200
    80.887     1.511     0.200
    81.128     1.425     0.200
    81.589     0.280     0.200
    81.881     1.343     0.200
    81.996     1.937     0.200
    82.181     1.264     0.200
    82.574     1.114     0.200
    82.709     0.911     0.200
    83.037     0.708     0.200
    83.136     2.197     0.200
    83.270     4.505     0.200
    83.463     1.911     0.200
    83.750    -0.960     0.200
    84.026     2.129     0.200
    84.113     1.689     0.200
    84.476    -0.455     0.200
    84.573    -0.648     0.200
    84.790     2.256     0.200
    84.848     1.466     0.200
    84.857    -0.479     0.200
    84.948     1.464     0.200
    85.077     1.319     0.200
    85.279     0.806     0.200
    85.381     1.398     0.200
    85.381     0.640     0.200
    85.406     0.074     0.200
    85.494     2.236     0.200
    85.559     0.413     0.200
    85.696     0.128     0.200
    85.716     1.630     0.200
    86.069     1.882     0.200
    86.527     2.829     0.200
    86.576     1.389     0.200
    86.588     1.830     0.200
    86.584     1.050     0.200
    86.665     2.052     0.200
    86.703     1.066     0.200
    86.742     1.773     0.200
    86.777     0.401     0.200
    86.783     0.572     0.200
    86.833     2.128     0.200
    86.923    -0.609     0.200
    87.086     0.897     0.200
    87.097     1.143     0.200
    87.095    -0.446     0.200
    87.144     0.617     0.200
    87.170     0.991     0.200
    87.202     0.531     0.200
    87.456     0.507     0.200
    87.498     0.306     0.200
    87.529     0.253     0.200
    87.575     0.532     0.200
    87.649     0.677     0.200
    87.692     0.971     0.200
    87.706     0.208     0.200
    87.721    -0.067     0.200
    87.776     1.674     0.200
    87.839     0.469     0.200
    88.031     0.059     0.200
    88.087    -0.007     0.200
    88.175    -0.223     0.200
    88.182     0.743     0.200
    88.193     0.495     0.200
    88.198    -0.032     0.200
    88.407     2.580     0.200
    88.673     0.326     0.200
    88.731     0.654     0.200
    88.722    -0.706     0.200
    88.722    -0.605     0.200
    88.762    -0.293     0.200
    89.043     0.487     0.200
    89.260     0.370     0.200
    89.361    -0.705     0.200
    89.388     0.469     0.200
    89.415     0.342     0.200
    89.521     0.144     0.200
    89.584     0.650     0.200
    89.614    -1.090     0.200
    89.856    -0.220     0.200
    89.832     0.492     0.200
    89.986     0.768     0.200
    90.099     0.241     0.200
    90.123    -0.166     0.200
    89.932     1.424     0.200
    90.265     1.368     0.200
    90.410     0.493     0.200
    90.437     0.867     0.200
    90.509     1.634     0.200
    90.587     1.871     0.200
    90.761     1.061     0.200
    90.824    -0.734     0.200
    90.914     2.149     0.200
    91.085     1.057     0.200
    91.084     0.508     0.200
    91.084     0.736     0.200
    91.073    -0.889     0.200
    91.121     0.890     0.200
    91.180     1.616     0.200
    91.190     1.669     0.200
    91.210     0.774     0.200
    91.222     0.520     0.200
    91.236    -0.247     0.200
    91.448     1.273     0.200
    91.620     2.075     0.200
    91.867     1.431     0.200
    91.941     1.689     0.200
    91.970     0.457     0.200
    92.119    -4.733     0.200
    92.295     0.553     0.200
    92.250    -0.341     0.200
    92.274     1.247     0.200
    92.664    -0.252     0.200
    92.700     0.581     0.200
    92.767     0.272     0.200
    93.034     1.243     0.200
    93.113     0.078     0.200
    93.163    -1.055     0.200
    93.235     0.118     0.200
    93.575     0.650     0.200
    93.639     0.658     0.200
    93.635    -0.725     0.200
    93.762    -0.008     0.200
    94.058    -0.670     0.200
    94.103    -0.379     0.200
    94.511     0.250     0.200
    94.572    -0.029     0.200
    94.604     0.821     0.200
    94.665     2.545     0.200
    94.666    -0.462     0.200
    94.689     0.935     0.200
    94.370     1.199     0.200
    95.148    -0.065     0.200
    95.161     0.673     0.200
    95.253     1.352     0.200
    95.295     0.662     0.200
    95.590     0.114     0.200
    95.660    -0.502     0.200
    95.852     0.623     0.200
    96.002     0.438     0.200
    95.983     1.227     0.200
    96.047     2.233     0.200
    96.169     0.678     0.200
    96.271     0.916     0.200
    96.414     0.566     0.200
    96.502     2.168     0.200
    96.033     3.298     0.200
    96.630     0.588     0.200
    97.168     0.153     0.200
    97.807     0.271     0.200
    98.842    -3.371     0.200
    98.842    -3.070     0.200
    99.025    -1.090     0.200
    99.181    -1.886     0.200
    16.938     2.355     0.200
    18.049     0.163     0.200
    18.889    -1.099     0.200
    19.371    -0.882     0.200
    21.529     1.413     0.200
    21.567     2.901     0.200
    21.650     2.010     0.200
    21.998     2.295     0.200
    22.041     1.833     0.200
    22.740    -2.602     0.200
    23.432    -2.302     0.200
    23.566     2.110     0.200
    23.650     1.040     0.200
    23.983     2.205     0.200
    24.724     1.544     0.200
    24.968     2.522     0.200
    25.880     2.042     0.200
    26.498     2.454     0.200
    27.147     0.314     0.200
    27.794    -0.290     0.200
    28.599     0.537     0.200
    28.707     4.071     0.200
    32.055     1.792     0.200
    33.505    -0.594     0.200
    33.743     2.039     0.200
    35.288    -0.329     0.200
    35.554    -2.617     0.200
    35.666    -2.280     0.200
    36.503    -0.740     0.200
    36.761    -1.845     0.200
    44.945    -0.898     0.200
    44.961    -0.223     0.200
    48.707     2.171     0.200
    48.905     0.656     0.200
    49.177     2.671     0.200
    51.325     0.302     0.200
    53.614    -0.663     0.200
    55.269     0.301     0.200
    69.405     1.965     0.200
    71.193    -1.178     0.200
    80.882     0.524     0.200
    84.593     1.138     0.200
    84.690     1.249     0.200
    84.974     1.320     0.200
    85.043    -0.027     0.200
    85.494     0.218     0.200
    85.621    -0.913     0.200
    85.698     1.008     0.200
    86.205     2.197     0.200
    86.661     3.053     0.200
    86.727     2.130     0.200
    86.900     0.789     0.200
    86.903     0.971     0.200
    87.162    -0.186     0.200
    87.209     1.883     0.200
    87.265     0.213     0.200
    87.292     0.382     0.200
    87.322     0.539     0.200
    87.361     0.646     0.200
    87.446    -0.763     0.200
    87.575    -0.083     0.200
    87.771     0.680     0.200
    87.823     0.030     0.200
    87.839    -0.046     0.200
    87.956     0.198     0.200
    88.149    -0.114     0.200
    89.686    -0.442     0.200
    90.198    -0.137     0.200
    91.153     0.721     0.200
    16.997     2.044     0.200
    18.383    -0.597     0.200
    19.373    -0.962     0.200
    21.015     3.987     0.200
    21.580     2.412     0.200
    21.618     1.508     0.200
    21.745     2.141     0.200
    22.094     2.409     0.200
    22.729    -1.837     0.200
    23.297     2.665     0.200
    23.398    -2.895     0.200
    24.073     2.532     0.200
    24.159     1.549     0.200
    24.820     1.628     0.200
    25.067     2.082     0.200
    25.290     1.453     0.200
    26.593     2.468     0.200
    28.666     0.803     0.200
    32.128     0.807     0.200
    33.526    -1.521     0.200
    33.819     1.536     0.200
    35.528    -2.240     0.200
    35.637    -1.868     0.200
    36.543    -1.924     0.200
    36.733    -2.044     0.200
    45.001    -1.182     0.200
    45.017    -0.710     0.200
    49.068     0.566     0.200
    53.680     0.013     0.200
    55.348    -0.103     0.200
    66.340    -1.375     0.200
    69.289     1.153     0.200
    71.209    -1.299     0.200
    84.555     1.206     0.200
    84.569     1.035     0.200
    84.652     1.312     0.200
    84.936     1.284     0.200
    85.049     0.116     0.200
    85.484     0.141     0.200
    85.656     1.286     0.200
    86.145     2.368     0.200
    86.856     1.377     0.200
    87.176     0.717     0.200
    87.222     0.796     0.200
    87.248     1.071     0.200
    87.281    -0.490     0.200
    87.314     0.550     0.200
    87.446    -0.786     0.200
    87.534    -0.213     0.200
    87.785    -0.210     0.200
    87.918    -0.046     0.200
    88.110    -0.256     0.200
    16.844     1.684     0.200
    17.983     2.602     0.200
    18.295    -0.879     0.200
    18.804    -0.866     0.200
    19.287    -1.455     0.200
    20.805    -0.548     0.200
    21.435     0.872     0.200
    21.566     1.467     0.200
    21.914     1.742     0.200
    22.479     2.141     0.200
    22.662    -2.199     0.200
    23.106     0.117     0.200
    23.366    -2.560     0.200
    23.814     2.144     0.200
    24.470    -2.036     0.200
    24.640     1.510     0.200
    25.002     0.219     0.200
    28.505     0.603     0.200
    31.962     0.453     0.200
    33.415    -1.956     0.200
    36.409    -1.064     0.200
    44.881     0.055     0.200
    45.907    -2.066     0.200
    48.779     1.599     0.200
    48.976     1.784     0.200
    49.249     1.403     0.200
    50.181     2.714     0.200
    50.931     0.757     0.200
    53.520     0.036     0.200
    53.794     1.527     0.200
    53.815     1.177     0.200
    55.178    -0.016     0.200
    55.178     0.484     0.200
    57.278     0.606     0.200
    57.875     0.407     0.200
    58.599    -0.250     0.200
    61.478    -0.382     0.200
    61.747     1.201     0.200
    67.385     1.007     0.200
    68.659     0.606     0.200
    71.105    -0.217     0.200
    80.811    -0.319     0.200
    84.529     1.559     0.200
    84.545     1.281     0.200
    84.626     1.672     0.200
    84.910     1.542     0.200
    85.534     0.725     0.200
    85.636     1.318     0.200
    86.157     2.340     0.200
    86.839     0.792     0.200
    86.841     1.085     0.200
    87.076    -0.858     0.200
    87.204     0.321     0.200
    87.232     0.686     0.200
    87.259     0.451     0.200
    87.304     0.839     0.200
    87.363    -1.250     0.200
    87.513     0.230     0.200
    87.734     2.272     0.200
    87.760     0.151     0.200
    87.776    -0.427     0.200
    87.893     0.219     0.200
    88.085    -0.094     0.200
    89.601     0.176     0.200
    90.115    -0.124     0.200
    91.072    -0.675     0.200
    95.199     0.313     0.200
    17.200     3.039     0.200
    18.382    -0.351     0.200
    18.899    -0.530     0.200
    18.914    -0.191     0.200
    19.834     2.438     0.200
    19.950     2.178     0.200
    20.882     2.758     0.200
    21.149     2.173     0.200
    21.161     2.050     0.200
    21.354     2.565     0.200
    21.408    -1.613     0.200
    21.749     0.230     0.200
    21.785     1.250     0.200
    22.074     2.453     0.200
    22.302     2.518     0.200
    22.269     2.476     0.200
    22.430     1.457     0.200
    22.496     2.758     0.200
    22.675    -2.242     0.200
    22.802     1.519     0.200
    23.263    -2.049     0.200
    23.644     2.647     0.200
    24.012     2.084     0.200
    24.081     1.352     0.200
    24.305     0.814     0.200
    24.297    -2.421     0.200
    24.277     1.260     0.200
    24.387     2.161     0.200
    24.504     1.599     0.200
    24.555     1.627     0.200
    24.897     1.415     0.200
    25.152     1.997     0.200
    25.369     0.227     0.200
    25.400     1.347     0.200
    25.410     1.754     0.200
    25.583     1.682     0.200
    25.945     2.306     0.200
    26.120     3.224     0.200
    26.132     2.210     0.200
    26.920     2.695     0.200
    27.127    -0.764     0.200
    27.563     1.424     0.200
    28.215    -0.599     0.200
    28.760    -1.547     0.200
    28.891     0.887     0.200
    29.136     2.612     0.200
    29.555     2.596     0.200
    29.666     0.011     0.200
    30.968    -3.393     0.200
    31.239    -2.523     0.200
    31.601     1.528     0.200
    32.288    -1.512     0.200
    32.377     0.706     0.200
    32.518     2.172     0.200
    32.690     1.629     0.200
    33.587    -1.666     0.200
    34.078     0.866     0.200
    34.881     1.914     0.200
    35.423    -2.750     0.200
    35.503    14.556     0.200
    35.517    -2.157     0.200
    36.112    -0.660     0.200
    36.617    -1.377     0.200
    36.672    -1.442     0.200
    38.095     1.494     0.200
    45.187    -2.089     0.200
    45.203    -1.120     0.200
    45.218    -1.138     0.200
    45.902    -1.751     0.200
    48.219     1.967     0.200
    48.417     2.138     0.200
    48.689     2.038     0.200
    50.240    -1.298     0.200
    50.369     0.830     0.200
    50.636     2.711     0.200
    51.332    -1.025     0.200
    53.899     1.875     0.200
    53.904    -1.065     0.200
    54.128    -0.802     0.200
    54.258     1.353     0.200
    54.279     0.900     0.200
    55.618     0.816     0.200
    55.618     0.613     0.200
    55.618     0.615     0.200
    55.882     2.618     0.200
    57.745     0.500     0.200
    58.318     0.186     0.200
    58.910    -0.744     0.200
    59.460    -0.146     0.200
    62.214     1.213     0.200
    63.495     1.385     0.200
    63.583     1.104     0.200
    66.438    -0.960     0.200
    66.813     1.146     0.200
    67.696     2.049     0.200
    68.084     0.910     0.200
    68.178     1.518     0.200
    68.874     1.071     0.200
    69.201     1.141     0.200
    69.550     2.779     0.200
    70.148    -1.200     0.200
    70.124    -0.052     0.200
    71.245    -1.080     0.200
    71.586     1.160     0.200
    77.047     1.957     0.200
    77.595     0.885     0.200
    78.653     0.320     0.200
    79.554     0.687     0.200
    79.799     0.858     0.200
    79.849    -0.614     0.200
    79.848     0.788     0.200
    80.098     1.034     0.200
    80.274     0.488     0.200
    80.429     1.054     0.200
    80.443     1.076     0.200
    80.545     1.129     0.200
    80.668     1.070     0.200
    80.723     0.577     0.200
    80.743     0.670     0.200
    80.701     1.197     0.200
    80.853     1.284     0.200
    80.842     0.442     0.200
    81.005     1.571     0.200
    81.068     1.734     0.200
    81.455    -0.019     0.200
    82.526     0.556     0.200
    82.526     0.856     0.200
    82.893     1.643     0.200
    83.044     1.362     0.200
    83.083     1.659     0.200
    83.083     2.258     0.200
    83.148     1.925     0.200
    83.201     1.752     0.200
    83.551     1.649     0.200
    83.593     1.332     0.200
    83.936    -0.523     0.200
    84.031    -0.209     0.200
    84.412     0.758     0.200
    84.501     0.906     0.200
    84.667     2.064     0.200
    84.784     0.777     0.200
    85.053    -0.375     0.200
    85.144     1.168     0.200
    85.395     1.716     0.200
    85.395     1.056     0.200
    85.492     0.631     0.200
    85.522     1.283     0.200
    85.659    -1.202     0.200
    85.720     0.495     0.200
    85.914     1.335     0.200
    86.376     2.557     0.200
    86.412     1.878     0.200
    86.534     1.277     0.200
    86.614    -0.112     0.200
    86.683     1.150     0.200
    86.698     0.574     0.200
    86.947    -0.740     0.200
    87.042     1.096     0.200
    87.053     0.645     0.200
    87.074     0.941     0.200
    87.119    -0.378     0.200
    87.129     0.176     0.200
    87.183    -0.288     0.200
    87.372    -0.707     0.200
    87.417    -0.621     0.200
    87.426    -0.565     0.200
    87.490     0.625     0.200
    87.527     0.448     0.200
    87.630    -0.644     0.200
    87.643    -0.909     0.200
    87.643     1.090     0.200
    87.669     0.568     0.200
    87.765    -0.493     0.200
    87.955    -0.697     0.200
    88.009    -1.052     0.200
    88.127    -3.714     0.200
    88.138     1.037     0.200
    88.154     2.263     0.200
    88.668     1.033     0.200
    88.752    -0.665     0.200
    88.864    -0.889     0.200
    88.864    -0.190     0.200
    88.978    -0.327     0.200
    89.323    -0.445     0.200
    89.354    -0.392     0.200
    89.688    -0.354     0.200
    90.190     0.902     0.200
    90.148     0.899     0.200
    90.186    -0.481     0.200
    90.331     0.045     0.200
    90.313     0.329     0.200
    90.376     0.437     0.200
    90.445     0.513     0.200
    90.787     0.122     0.200
    90.841     2.070     0.200
    91.045    -0.075     0.200
    91.098     0.678     0.200
    91.113     1.506     0.200
    91.129    -1.165     0.200
    91.127     1.143     0.200
    91.122     0.167     0.200
    91.137     1.896     0.200
    91.206    -0.126     0.200
    91.377     1.185     0.200
    91.496    -0.770     0.200
    91.876     1.169     0.200
    91.939     0.181     0.200
    92.048    -0.223     0.200
    92.252     0.935     0.200
    92.474     0.607     0.200
    92.652     0.987     0.200
    92.648     0.504     0.200
    92.648     0.905     0.200
    92.733     0.612     0.200
    93.099     0.926     0.200
    93.209     0.915     0.200
    93.584     0.491     0.200
    93.693    -0.312     0.200
    93.714     0.592     0.200
    94.045     0.568     0.200
    94.543     0.485     0.200
    94.642    -0.668     0.200
    94.649     0.800     0.200
    95.123     1.129     0.200
    95.123     1.430     0.200
    95.215     0.209     0.200
    95.576     0.762     0.200
    95.570     0.686     0.200
    95.669     0.935     0.200
    96.440     0.130     0.200
    96.593     1.438     0.200
    98.542    -1.347     0.200
    98.542    -0.447     0.200
    16.454     2.004     0.200
    16.623     3.393     0.200
    17.088     2.044     0.200
    17.088     2.843     0.200
    17.899    -0.019     0.200
    18.197     0.111     0.200
    18.630     0.357     0.200
    21.141     1.104     0.200
    21.175     1.245     0.200
    21.967    -1.719     0.200
    23.260     1.358     0.200
    23.258     2.377     0.200
    23.329     2.726     0.200
    23.695     2.382     0.200
    23.733     1.032     0.200
    23.832     1.625     0.200
    23.991     2.781     0.200
    24.181     1.644     0.200
    24.245     1.964     0.200
    24.579     2.018     0.200
    24.794     0.569     0.200
    24.856     1.700     0.200
    25.084     2.433     0.200
    25.085     1.827     0.200
    25.145     2.180     0.200
    25.626     1.620     0.200
    25.805     2.101     0.200
    26.554     2.437     0.200
    26.766     0.035     0.200
    27.186     1.864     0.200
    27.285     4.069     0.200
    28.344     1.227     0.200
    30.155     4.883     0.200
    31.863    -0.160     0.200
    33.579     0.351     0.200
    35.540    -0.573     0.200
    36.027    -0.744     0.200
    39.563     3.146     0.200
    44.592    -0.990     0.200
    44.624    -0.643     0.200
    46.328     3.792     0.200
    48.439     2.405     0.200
    48.640     2.863     0.200
    50.628    -0.251     0.200
    50.581     2.103     0.200
    52.933     1.892     0.200
    53.352    -0.490     0.200
    53.499     1.533     0.200
    53.806     1.088     0.200
    54.334     2.747     0.200
    55.132     0.078     0.200
    55.136     3.548     0.200
    56.367     0.234     0.200
    57.298     0.048     0.200
    57.835    -0.525     0.200
    61.365    -0.602     0.200
    65.772    -1.940     0.200
    65.843     0.400     0.200
    68.778     2.850     0.200
    70.550    -1.850     0.200
    84.723     0.280     0.200
    84.961     1.088     0.200
    86.012     0.163     0.200
    86.022     0.012     0.200
    86.380     0.053     0.200
    86.442    -0.152     0.200
    86.481    -1.244     0.200
    86.466     0.231     0.200
    86.695    -0.793     0.200
    86.738    -0.802     0.200
    86.949    -0.327     0.200
    87.083    -0.182     0.200
    87.274    -0.305     0.200
    89.480    -0.329     0.200
    16.578     2.948     0.200
    17.703     0.276     0.200
    19.035    -0.537     0.200
    19.905    -0.627     0.200
    20.618     2.439     0.200
    21.167     0.817     0.200
    21.267    -1.458     0.200
    21.205     1.105     0.200
    21.346     1.588     0.200
    21.342     2.635     0.200
    22.408    -1.444     0.200
    22.422    -1.396     0.200
    23.156    -2.644     0.200
    23.084     2.119     0.200
    23.273     2.634     0.200
    23.347     1.101     0.200
    23.571     2.347     0.200
    23.815     2.217     0.200
    24.298    -2.184     0.200
    24.132     1.927     0.200
    24.480     1.754     0.200
    24.727     1.099     0.200
    25.120    -0.871     0.200
    25.153    -1.766     0.200
    25.573    -1.885     0.200
    25.518     1.619     0.200
    25.641     0.501     0.200
    26.084     0.591     0.200
    27.208    -1.937     0.200
    27.383    -1.399     0.200
    28.244     0.711     0.200
    29.095    -1.954     0.200
    29.647    -1.646     0.200
    31.987     1.124     0.200
    32.839    -1.138     0.200
    33.151    -1.369     0.200
    33.398     0.684     0.200
    33.578    -1.785     0.200
    35.139    -2.095     0.200
    35.380    -1.765     0.200
    35.487    -0.883     0.200
    36.141    -1.484     0.200
    36.385    -1.573     0.200
    37.302    -1.268     0.200
    38.979    -1.291     0.200
    39.461    -0.009     0.200
    39.669    -1.241     0.200
    39.894    -0.611     0.200
    44.615    -0.835     0.200
    48.960     2.505     0.200
    49.158     3.487     0.200
    49.431     3.404     0.200
    50.985    -1.361     0.200
    52.698     2.183     0.200
    53.174     1.767     0.200
    53.259    -0.153     0.200
    53.572     1.247     0.200
    54.780     0.957     0.200
    54.928     0.182     0.200
    56.081     0.501     0.200
    57.036     0.407     0.200
    57.626     0.050     0.200
    58.331    -0.689     0.200
    61.221    -0.651     0.200
    61.506     1.126     0.200
    64.200     2.210     0.200
    65.391     0.156     0.200
    67.480     1.609     0.200
    68.810     2.266     0.200
    69.520     2.472     0.200
    70.272     3.355     0.200
    70.844    -1.432     0.200
    81.020     0.469     0.200
    81.805     0.616     0.200
    82.159     0.758     0.200
    83.380    -0.577     0.200
    83.380    -0.077     0.200
    83.649     1.039     0.200
    84.325     1.097     0.200
    84.341     0.912     0.200
    84.420     1.217     0.200
    84.704     1.283     0.200
    84.702    -0.109     0.200
    84.848     1.858     0.200
    85.120     0.495     0.200
    85.274    -0.177     0.200
    85.436     1.217     0.200
    85.465     0.371     0.200
    85.680     2.200     0.200
    86.012     1.661     0.200
    86.092     2.264     0.200
    86.227     2.297     0.200
    86.277     2.052     0.200
    86.300     2.240     0.200
    86.351    -1.710     0.200
    86.460     2.156     0.200
    86.461     1.949     0.200
    86.532     2.101     0.200
    86.572     1.706     0.200
    86.641     1.068     0.200
    86.644     0.753     0.200
    86.742     1.874     0.200
    86.819    -0.500     0.200
    86.929     0.964     0.200
    87.007     0.284     0.200
    87.037     0.536     0.200
    87.059     0.031     0.200
    87.114     0.762     0.200
    87.113    -0.932     0.200
    87.312    -0.094     0.200
    87.347     0.633     0.200
    87.351    -0.285     0.200
    87.401     0.373     0.200
    87.513     0.134     0.200
    87.519     0.507     0.200
    87.555    -0.068     0.200
    87.573    -0.553     0.200
    87.687     0.200     0.200
    87.880    -0.418     0.200
    87.939    -0.394     0.200
    88.024     1.004     0.200
    88.073     0.170     0.200
    88.486    -1.484     0.200
    88.882     0.049     0.200
    89.347    -0.629     0.200
    89.455     0.964     0.200
    89.863    -0.641     0.200
    90.641    -0.868     0.200
    90.907     0.897     0.200
    91.781     0.846     0.200
    91.900     0.692     0.200
    91.907     0.259     0.200
    91.907     0.458     0.200
    92.514     0.457     0.200
    92.514     1.258     0.200
    92.581     0.145     0.200
    94.979     1.227     0.200
    95.864     1.087     0.200
    95.868     0.869     0.200
    96.092     0.850     0.200
    16.742     1.418     0.200
    16.942     3.921     0.200
    21.201     2.479     0.200
    21.314     4.267     0.200
    21.457     1.025     0.200
    21.490     2.170     0.200
    21.848     2.042     0.200
    22.148    -0.655     0.200
    22.211    -0.612     0.200
    22.245     2.620     0.200
    22.487     1.750     0.200
    22.768    -1.421     0.200
    22.991     3.037     0.200
    23.300     1.011     0.200
    23.564     2.301     0.200
    23.794    -2.301     0.200
    23.876    -2.252     0.200
    23.985     2.451     0.200
    24.030     0.748     0.200
    24.144     2.100     0.200
    24.296     2.720     0.200
    24.473     1.303     0.200
    24.534     1.949     0.200
    24.752     2.665     0.200
    25.112    -0.313     0.200
    25.155     1.703     0.200
    25.318     2.723     0.200
    25.375     2.010     0.200
    25.376     2.293     0.200
    26.062     1.085     0.200
    26.491     0.810     0.200
    26.870     1.194     0.200
    26.854     2.234     0.200
    26.945    -1.876     0.200
    28.373     1.361     0.200
    28.663     1.173     0.200
    32.548     1.106     0.200
    32.919     1.458     0.200
    33.896     0.750     0.200
    35.858    -0.663     0.200
    36.335    -1.040     0.200
    44.909    -0.953     0.200
    44.941    -0.206     0.200
    48.369     2.971     0.200
    48.643     3.363     0.200
    50.896     0.744     0.200
    53.247     2.064     0.200
    53.671     0.159     0.200
    53.805     1.475     0.200
    54.141     0.932     0.200
    55.448     0.171     0.200
    56.678     0.289     0.200
    57.611     0.005     0.200
    58.151    -0.284     0.200
    58.610    -1.084     0.200
    66.072    -1.475     0.200
    80.253     0.350     0.200
    83.102     1.334     0.200
    83.900     0.837     0.200
    83.911     0.577     0.200
    84.001     0.922     0.200
    84.284     0.577     0.200
    84.964     0.557     0.200
    84.990     1.020     0.200
    85.437     2.191     0.200
    85.516     2.100     0.200
    85.649     2.141     0.200
    85.705     2.161     0.200
    85.724     2.462     0.200
    85.754     1.618     0.200
    85.883     1.780     0.200
    85.911     2.137     0.200
    86.180     0.414     0.200
    86.197     0.229     0.200
    86.189     1.767     0.200
    86.367    -0.310     0.200
    86.550     0.290     0.200
    86.617     0.366     0.200
    86.871     0.127     0.200
    86.916     0.705     0.200
    87.129     0.169     0.200
    87.265    -0.388     0.200
    87.455    -0.609     0.200
    88.480    -0.772     0.200
    94.631     1.098     0.200
    95.759     1.648     0.200
    17.004     3.492     0.200
    17.008     3.151     0.200
    18.316    -0.585     0.200
    18.613    -0.748     0.200
    20.333     2.271     0.200
    21.098    -1.793     0.200
    21.090     2.795     0.200
    21.288     2.662     0.200
    21.536    -0.001     0.200
    21.570     0.132     0.200
    21.879     1.334     0.200
    21.995     2.094     0.200
    22.213     2.273     0.200
    22.374    -2.845     0.200
    22.360     2.206     0.200
    22.951    -3.052     0.200
    22.956     2.396     0.200
    23.343     0.832     0.200
    23.562     1.305     0.200
    23.610     1.164     0.200
    23.802    -3.390     0.200
    23.986    -3.070     0.200
    24.009     0.720     0.200
    24.443     1.853     0.200
    24.501     1.230     0.200
    24.750     2.559     0.200
    24.846    -2.908     0.200
    25.136     1.751     0.200
    25.171    -0.668     0.200
    25.265    -2.720     0.200
    25.290     2.054     0.200
    25.343     2.071     0.200
    25.847    -0.492     0.200
    26.839     2.548     0.200
    26.966    -3.094     0.200
    27.133    -2.594     0.200
    28.715     1.085     0.200
    32.563     1.324     0.200
    32.802    -0.168     0.200
    33.319    -2.482     0.200
    35.921    -0.257     0.200
    48.427     1.416     0.200
    50.374     1.460     0.200
    51.044    -2.488     0.200
    53.267     2.198     0.200
    53.725    -0.165     0.200
    53.801     2.077     0.200
    54.155     1.295     0.200
    55.237     3.755     0.200
    55.306     3.460     0.200
    55.475     0.441     0.200
    55.456     3.680     0.200
    55.533     3.628     0.200
    56.684     0.308     0.200
    57.623    -0.030     0.200
    58.177    -0.114     0.200
    58.193     3.775     0.200
    58.693    -0.313     0.200
    61.726    -0.565     0.200
    63.425     1.099     0.200
    70.968    -1.709     0.200
    80.432     0.173     0.200
    84.088     0.458     0.200
    84.099     0.400     0.200
    84.508     0.925     0.200
    84.835     1.679     0.200
    84.893     2.486     0.200
    85.010     1.199     0.200
    85.129     0.803     0.200
    85.179     0.452     0.200
    85.599     1.859     0.200
    85.635     1.283     0.200
    85.713     1.896     0.200
    85.846     2.234     0.200
    85.902     1.960     0.200
    85.949     1.726     0.200
    86.080     2.080     0.200
    86.085     1.553     0.200
    86.371     0.847     0.200
    86.385     1.375     0.200
    86.386     0.572     0.200
    86.730     0.983     0.200
    86.740     0.634     0.200
    86.762     0.529     0.200
    86.806     0.511     0.200
    86.817     1.460     0.200
    87.060     0.576     0.200
    87.105     0.260     0.200
    87.131    -0.870     0.200
    87.317     0.231     0.200
    87.331     0.065     0.200
    87.453     0.276     0.200
    87.643     0.063     0.200
    88.666    -0.181     0.200
    89.893    -0.235     0.200
    90.476     0.146     0.200
    90.730     0.969     0.200
    91.629     0.096     0.200
    92.341     1.405     0.200
    92.423     1.027     0.200
    94.812     0.635     0.200
    95.077     1.784     0.200
    95.699     1.484     0.200
    16.235     2.844     0.200
    16.239     3.503     0.200
    17.369     2.029     0.200
    17.291    -0.016     0.200
    18.022    -0.059     0.200
    18.339    -0.344     0.200
    18.342    -0.375     0.200
    19.754    -0.417     0.200
    20.415    -1.586     0.200
    20.840     0.917     0.200
    20.975     1.463     0.200
    22.259    -1.860     0.200
    22.264    -1.815     0.200
    22.485     0.947     0.200
    22.882     2.851     0.200
    22.957     1.570     0.200
    23.425     1.739     0.200
    23.745     1.910     0.200
    24.090     1.566     0.200
    24.270     1.724     0.200
    24.281     2.420     0.200
    24.378     0.540     0.200
    24.241    -1.909     0.200
    25.117    -1.781     0.200
    44.277    -2.285     0.200
    45.513    -1.514     0.200
    49.344     2.737     0.200
    49.543     2.224     0.200
    49.816     2.347     0.200
    52.902    -0.937     0.200
    54.300    -0.168     0.200
    54.553    -0.405     0.200
    56.654     0.024     0.200
    57.250    -0.390     0.200
    58.003    -1.084     0.200
    64.556     1.923     0.200
    70.762     1.325     0.200
    16.802     2.335     0.200
    16.806     2.493     0.200
    18.735    -0.599     0.200
    20.751     0.846     0.200
    21.388     0.581     0.200
    21.426     1.973     0.200
    21.960     3.459     0.200
    22.588    -3.211     0.200
    23.162     1.239     0.200
    23.288    -2.586     0.200
    23.482     2.179     0.200
    23.559     1.167     0.200
    24.023     1.130     0.200
    24.367     1.496     0.200
    24.693     1.321     0.200
    24.803     1.520     0.200
    24.881     2.308     0.200
    26.404     2.515     0.200
    27.503    -2.269     0.200
    27.503    -1.569     0.200
    27.699    -0.121     0.200
    28.470     0.913     0.200
    31.932    -0.089     0.200
    32.605     0.013     0.200
    33.622     1.132     0.200
    36.356    -0.625     0.200
    45.833    -1.294     0.200
    48.769     1.062     0.200
    48.966     0.846     0.200
    49.239     1.461     0.200
    50.919     0.525     0.200
    52.921     2.724     0.200
    53.484    -0.521     0.200
    53.746    -0.439     0.200
    53.795     1.508     0.200
    54.763     1.660     0.200
    55.152     1.048     0.200
    56.301     0.915     0.200
    57.258     0.626     0.200
    57.850     0.362     0.200
    61.728     1.513     0.200
    64.743     0.045     0.200
    67.343     1.148     0.200
    71.040    -0.950     0.200
    79.077     0.424     0.200
    79.462     0.224     0.200
    80.734     0.666     0.200
    80.734    -0.234     0.200
    83.744     1.024     0.200
    84.450     1.129     0.200
    84.465     0.952     0.200
    84.547     1.341     0.200
    84.831     1.211     0.200
    84.889     0.716     0.200
    84.945     1.935     0.200
    85.232     0.600     0.200
    85.232    -0.201     0.200
    85.278     1.869     0.200
    85.342     0.452     0.200
    85.410     1.310     0.200
    85.427     1.726     0.200
    85.468     1.224     0.200
    85.556     1.284     0.200
    85.633     0.803     0.200
    85.633     1.403     0.200
    86.380     1.813     0.200
    86.524     2.605     0.200
    86.548     1.888     0.200
    86.604     2.612     0.200
    86.760     0.751     0.200
    86.762    -0.158     0.200
    86.818     1.868     0.200
    86.859    -0.633     0.200
    87.008    -0.360     0.200
    87.125     0.376     0.200
    87.152     0.241     0.200
    87.180     0.006     0.200
    87.224     0.495     0.200
    87.293    -0.539     0.200
    87.433    -0.118     0.200
    87.474    -0.214     0.200
    87.489     1.313     0.200
    87.539     0.074     0.200
    87.539     0.874     0.200
    87.631     0.035     0.200
    87.656    -0.787     0.200
    87.681    -0.203     0.200
    87.697    -0.380     0.200
    87.814    -0.036     0.200
    88.006    -0.249     0.200
    88.656     0.378     0.200
    89.013     0.201     0.200
    89.358    -0.018     0.200
    90.386    -0.120     0.200
    90.512    -0.905     0.200
    90.784     1.831     0.200
    91.000     0.825     0.200
    91.047     1.310     0.200
    91.047     1.409     0.200
    91.193    -0.069     0.200
    91.191    -0.562     0.200
    91.204     0.082     0.200
    91.564     0.013     0.200
    91.927     0.534     0.200
    92.655     1.669     0.200
    92.726     1.342     0.200
    92.875     0.252     0.200
    92.875     0.652     0.200
    94.213     1.194     0.200
    95.121     1.037     0.200
    96.007     1.699     0.200
    16.669     3.390     0.200
    16.707     0.899     0.200
    17.391    -0.078     0.200
    17.672     2.980     0.200
    18.503    -0.371     0.200
    19.807    -0.335     0.200
    20.496     0.301     0.200
    21.137    -0.967     0.200
    21.235     2.445     0.200
    21.275     2.653     0.200
    21.483     1.341     0.200
    21.554    -0.133     0.200
    21.738     2.809     0.200
    22.051    -1.970     0.200
    22.334    -2.012     0.200
    22.969     0.847     0.200
    23.119     2.063     0.200
    24.146    -2.377     0.200
    24.660     1.381     0.200
    24.819     2.225     0.200
    25.399    -2.180     0.200
    27.915     1.640     0.200
    28.355     0.974     0.200
    34.315    -0.011     0.200
    48.723     1.461     0.200
    49.195     2.346     0.200
    50.871     1.351     0.200
    51.543     7.320     0.200
    54.609     1.024     0.200
    54.692     0.779     0.200
    55.073    -0.517     0.200
    56.251    -0.217     0.200
    57.199    -0.101     0.200
    58.398     0.228     0.200
    70.152     0.619     0.200
    78.748     0.020     0.200
    78.807    -0.302     0.200
    80.466     0.298     0.200
    84.175     0.435     0.200
    84.190     0.360     0.200
    84.272     0.541     0.200
    84.556     0.508     0.200
    85.089     0.330     0.200
    85.280     0.377     0.200
    86.848     0.344     0.200
    86.904     0.369     0.200
    87.158     0.237     0.200
    87.406     0.238     0.200
    87.539     0.301     0.200
    87.731     0.182     0.200
    90.755     1.593     0.200
    15.970     4.007     0.200
    16.947     1.549     0.200
    19.957     2.077     0.200
    20.519     2.482     0.200
    20.565     1.986     0.200
    20.737     2.624     0.200
    20.823     1.800     0.200
    20.984     3.103     0.200
    20.970     2.579     0.200
    21.124     1.979     0.200
    21.560     2.623     0.200
    21.712     2.297     0.200
    21.971    -0.759     0.200
    21.980    -0.713     0.200
    22.236     1.704     0.200
    22.334     4.364     0.200
    22.352     1.517     0.200
    22.345     2.884     0.200
    22.474     1.630     0.200
    22.712     2.415     0.200
    22.771     2.790     0.200
    22.774     1.388     0.200
    22.870     2.654     0.200
    23.202     1.510     0.200
    23.258     2.091     0.200
    23.686    -0.916     0.200
    23.922     1.360     0.200
    23.905     1.723     0.200
    24.050     1.833     0.200
    23.987    -0.661     0.200
    24.117     0.248     0.200
    24.830     1.016     0.200
    24.836    -2.042     0.200
    24.865    -1.120     0.200
    24.861    -0.502     0.200
    25.230     1.357     0.200
    25.414     1.831     0.200
    25.611     2.739     0.200
    26.221    -0.668     0.200
    27.053    -0.694     0.200
    27.146     1.487     0.200
    27.220    -0.245     0.200
    27.633     1.310     0.200
    31.069     0.905     0.200
    31.385     1.175     0.200
    31.772     0.708     0.200
    32.421     0.916     0.200
    33.365     1.468     0.200
    33.409     3.805     0.200
    33.981     2.046     0.200
    33.870     3.604     0.200
    34.777    -0.933     0.200
    34.996    -0.949     0.200
    34.909     0.430     0.200
    34.963     0.568     0.200
    36.938    -0.899     0.200
    39.285     2.038     0.200
    40.278     0.452     0.200
    40.330    -1.067     0.200
    40.448    -0.644     0.200
    40.672    -0.990     0.200
    40.797     1.838     0.200
    40.905     1.030     0.200
    41.817     0.092     0.200
    41.839    -2.580     0.200
    47.344     5.563     0.200
    49.474     4.306     0.200
    49.947     5.011     0.200
    51.639     1.629     0.200
    51.620     1.057     0.200
    52.094     2.732     0.200
    52.862     1.049     0.200
    53.976     0.994     0.200
    54.060     0.749     0.200
    54.321    -0.455     0.200
    55.485     0.198     0.200
    56.437     0.160     0.200
    57.020    -0.340     0.200
    57.167     5.051     0.200
    57.729    -0.098     0.200
    58.247     4.279     0.200
    60.695     3.941     0.200
    69.272     3.451     0.200
    70.306    -0.893     0.200
    78.505    -0.235     0.200
    78.556     0.087     0.200
    78.947     0.443     0.200
    80.189    -0.088     0.200
    83.385     1.026     0.200
    83.708     0.871     0.200
    83.976     1.007     0.200
    83.996     0.704     0.200
    84.067     1.044     0.200
    84.352     0.899     0.200
    84.573     0.986     0.200
    84.710    -0.102     0.200
    84.743     1.129     0.200
    84.749     1.001     0.200
    85.025     1.616     0.200
    85.051     1.790     0.200
    85.100     0.742     0.200
    85.713     1.197     0.200
    85.754     1.592     0.200
    85.998     0.991     0.200
    86.192     1.436     0.200
    86.304    -0.217     0.200
    86.320     0.307     0.200
    86.326     2.277     0.200
    86.351     1.050     0.200
    86.481     1.414     0.200
    86.554     1.558     0.200
    86.619    -1.157     0.200
    86.677    -0.045     0.200
    86.713     0.084     0.200
    86.720    -0.251     0.200
    86.718     1.461     0.200
    86.807     0.222     0.200
    86.972    -0.379     0.200
    87.018     0.399     0.200
    87.008    -0.452     0.200
    87.119     0.910     0.200
    87.207    -0.413     0.200
    87.227    -0.711     0.200
    87.336    -0.239     0.200
    87.531    -0.572     0.200
    87.563     0.777     0.200
    87.648     0.871     0.200
    88.519    -0.147     0.200
    88.849     1.402     0.200
    89.833    -0.908     0.200
    90.244     0.177     0.200
    90.518     1.107     0.200
    90.642    -0.175     0.200
    91.376     1.319     0.200
    92.122     0.469     0.200
    92.181    -0.304     0.200
    92.345     0.143     0.200
    94.583     0.943     0.200
    95.794     0.875     0.200
    95.929     1.081     0.200
    96.256     0.619     0.200
    96.151     1.175     0.200
    98.622    -1.138     0.200
    16.525     2.929     0.200
    17.465     2.071     0.200
    17.481    -0.024     0.200
    17.697     2.118     0.200
    18.177    -0.657     0.200
    19.925    -0.475     0.200
    21.048     1.762     0.200
    21.122     1.396     0.200
    21.275     1.985     0.200
    21.369     0.847     0.200
    21.489     2.762     0.200
    21.532    -1.139     0.200
    21.602     2.531     0.200
    22.107     3.246     0.200
    22.431    -1.770     0.200
    22.439    -1.736     0.200
    22.782     0.836     0.200
    22.809     2.696     0.200
    23.014    -0.379     0.200
    23.197    -2.025     0.200
    23.361     3.046     0.200
    24.047     2.708     0.200
    24.072    -1.814     0.200
    24.341    -1.128     0.200
    24.388     1.295     0.200
    24.465     0.563     0.200
    24.520     1.953     0.200
    25.206    -1.984     0.200
    25.478    -0.586     0.200
    25.627    -1.474     0.200
    26.099     2.438     0.200
    27.253    -1.384     0.200
    27.428    -0.405     0.200
    27.644     1.669     0.200
    28.075     0.736     0.200
    33.243     2.556     0.200
    33.724     2.572     0.200
    34.437     0.891     0.200
    35.414    -2.385     0.200
    37.341    -1.080     0.200
    41.157    -1.497     0.200
    49.065     2.460     0.200
    49.263     2.946     0.200
    49.535     2.967     0.200
    53.087     1.773     0.200
    53.377     1.094     0.200
    53.493     1.116     0.200
    54.449     1.387     0.200
    54.576     0.897     0.200
    54.611     1.441     0.200
    54.854     0.306     0.200
    55.997     0.634     0.200
    56.326    -0.682     0.200
    56.956     0.271     0.200
    57.551     0.040     0.200
    64.313     0.252     0.200
    64.401     0.676     0.200
    67.402     1.183     0.200
    78.919     0.025     0.200
    78.974    -0.577     0.200
    79.361     0.403     0.200
    80.620     0.209     0.200
    81.720     1.369     0.200
    81.765     0.631     0.200
    82.214     1.273     0.200
    83.316    -0.343     0.200
    83.708     1.044     0.200
    84.011     0.997     0.200
    84.367     0.991     0.200
    84.384     0.904     0.200
    84.461     1.213     0.200
    84.701    -0.096     0.200
    84.746     1.178     0.200
    84.904     1.680     0.200
    85.057     1.218     0.200
    85.138     1.309     0.200
    85.188    -0.040     0.200
    85.267     1.168     0.200
    85.348     2.261     0.200
    85.374     1.632     0.200
    85.481     1.000     0.200
    85.878     1.131     0.200
    86.335     0.877     0.200
    86.499     1.571     0.200
    86.655     1.305     0.200
    86.686     0.760     0.200
    86.691     0.530     0.200
    86.715    -0.586     0.200
    86.801     1.593     0.200
    86.965     1.595     0.200
    87.031     1.472     0.200
    87.053     0.169     0.200
    87.084     0.318     0.200
    87.103    -0.074     0.200
    87.118    -0.550     0.200
    87.165     0.525     0.200
    87.356    -0.099     0.200
    87.379     1.288     0.200
    87.395    -0.286     0.200
    87.436     0.516     0.200
    87.471     0.846     0.200
    87.562     2.410     0.200
    87.598    -0.261     0.200
    87.616    -0.545     0.200
    87.729     0.010     0.200
    87.923    -0.308     0.200
    88.060     0.540     0.200
    88.067     0.510     0.200
    88.922    -0.022     0.200
    90.335    -0.832     0.200
    90.672     0.297     0.200
    90.831     0.560     0.200
    90.831     0.259     0.200
    90.940     1.554     0.200
    91.810     0.622     0.200
    91.811     1.019     0.200
    91.855    -0.186     0.200
    92.547     0.118     0.200
    95.010     1.093     0.200
    95.895     0.956     0.200
    95.969     1.320     0.200
    96.193     1.103     0.200
    97.794    -0.634     0.200
    15.810     2.307     0.200
    16.583     1.919     0.200
    16.599     0.323     0.200
    16.858     0.699     0.200
    17.103     4.590     0.200
    17.292     0.667     0.200
    17.532     1.217     0.200
    17.800    -1.128     0.200
    18.020    -0.354     0.200
    20.416     0.318     0.200
    20.712     2.522     0.200
    20.712     2.721     0.200
    20.897     2.801     0.200
    21.358     1.127     0.200
    22.173     2.100     0.200
    22.249     2.101     0.200
    22.378     2.340     0.200
    22.467    -1.904     0.200
    22.997     0.217     0.200
    22.997     0.819     0.200
    23.087    -1.536     0.200
    23.539     1.423     0.200
    23.604     2.565     0.200
    23.604     2.666     0.200
    23.690    -2.120     0.200
    23.622     2.393     0.200
    23.622     2.495     0.200
    23.663     2.161     0.200
    23.675     1.969     0.200
    23.981     2.123     0.200
    23.981     3.021     0.200
    24.095     3.130     0.200
    24.272     2.697     0.200
    24.727     2.325     0.200
    24.727     2.723     0.200
    24.883    -2.095     0.200
    24.883    -1.993     0.200
    25.031     0.165     0.200
    25.145     1.546     0.200
    25.339     1.921     0.200
    25.376     2.221     0.200
    25.431     2.010     0.200
    25.647     0.742     0.200
    26.022     2.299     0.200
    26.758    -1.934     0.200
    26.842     3.003     0.200
    27.472     2.128     0.200
    27.680     0.991     0.200
    28.353     1.416     0.200
    28.589     1.640     0.200
    29.859     3.356     0.200
    31.934     2.662     0.200
    31.968     0.480     0.200
    32.116     0.518     0.200
    32.141    -2.039     0.200
    32.119     0.426     0.200
    32.380     2.557     0.200
    32.506     0.674     0.200
    32.578    -2.763     0.200
    32.597     1.088     0.200
    32.883     2.030     0.200
    33.079     0.504     0.200
    33.544     0.571     0.200
    33.726     0.880     0.200
    44.846    -1.033     0.200
    45.740     2.395     0.200
    45.816     1.798     0.200
    48.149     0.619     0.200
    48.139     1.597     0.200
    48.342     1.534     0.200
    51.092     1.462     0.200
    52.041     0.471     0.200
    53.202     2.503     0.200
    53.594    -0.069     0.200
    53.781     1.020     0.200
    53.890     0.726     0.200
    54.099     1.745     0.200
    54.100     0.834     0.200
    55.003     0.495     0.200
    55.205     1.122     0.200
    55.240     1.305     0.200
    55.395     0.876     0.200
    55.625     3.421     0.200
    55.694     3.327     0.200
    55.844     3.355     0.200
    55.921     3.607     0.200
    56.644    -0.352     0.200
    57.571     0.070     0.200
    58.099    -0.099     0.200
    58.506    -0.312     0.200
    58.576     3.198     0.200
    61.617     0.099     0.200
    62.040     1.158     0.200
    62.314    -0.171     0.200
    63.230     0.939     0.200
    65.828     0.898     0.200
    66.138     0.069     0.200
    70.681    -1.138     0.200
    77.647     0.711     0.200
    80.071    -1.067     0.200
    80.311     0.646     0.200
    81.013     0.876     0.200
    81.447     0.913     0.200
    82.912     1.310     0.200
    83.179     1.272     0.200
    83.713     0.418     0.200
    83.724     0.562     0.200
    83.815     0.298     0.200
    83.907     2.129     0.200
    84.098     0.158     0.200
    84.123     1.589     0.200
    84.233     1.263     0.200
    84.257     2.051     0.200
    84.341     1.726     0.200
    84.395     1.953     0.200
    84.505     2.724     0.200
    84.580     0.818     0.200
    84.627     1.150     0.200
    84.748     1.809     0.200
    84.802    -0.099     0.200
    84.792     0.851     0.200
    84.836     0.528     0.200
    84.840    -0.489     0.200
    85.081     1.304     0.200
    85.212     1.107     0.200
    85.277     2.146     0.200
    85.564     1.785     0.200
    85.581     2.132     0.200
    85.674     2.100     0.200
    85.722     2.716     0.200
    85.825     1.675     0.200
    85.992     0.081     0.200
    85.999     1.835     0.200
    86.009    -0.306     0.200
    86.010     1.993     0.200
    86.218     2.038     0.200
    86.307     0.227     0.200
    86.362     0.258     0.200
    86.362     1.362     0.200
    86.383     0.457     0.200
    86.380     2.472     0.200
    86.430    -0.075     0.200
    86.436     0.097     0.200
    86.684     0.086     0.200
    86.730     1.849     0.200
    86.729    -0.037     0.200
    86.816     0.838     0.200
    86.849     0.178     0.200
    86.866     0.094     0.200
    86.943    -0.175     0.200
    86.956    -0.539     0.200
    87.071     1.527     0.200
    87.077     1.174     0.200
    87.079     0.062     0.200
    87.116     2.082     0.200
    87.153     1.003     0.200
    87.268    -0.254     0.200
    87.306     1.391     0.200
    87.322    -0.510     0.200
    87.367     2.170     0.200
    87.450     1.969     0.200
    87.457     0.538     0.200
    87.515     1.262     0.200
    87.688     1.136     0.200
    87.958     1.155     0.200
    87.971     1.492     0.200
    88.117    -0.500     0.200
    88.174     1.434     0.200
    88.294    -0.039     0.200
    88.352    -0.010     0.200
    88.352     0.290     0.200
    88.428     0.688     0.200
    88.639    -0.262     0.200
    88.672     0.672     0.200
    88.836     1.010     0.200
    88.873     0.639     0.200
    89.355     0.658     0.200
    89.503     0.283     0.200
    89.643     0.128     0.200
    89.693    -0.105     0.200
    89.928     1.597     0.200
    90.037    -0.611     0.200
    90.114     1.034     0.200
    90.155     1.143     0.200
    90.288    -0.378     0.200
    90.364     1.463     0.200
    90.405    -0.127     0.200
    90.429    -0.132     0.200
    90.429     0.462     0.200
    90.438    -0.977     0.200
    90.500    -0.065     0.200
    90.536     0.567     0.200
    90.691     0.345     0.200
    90.829     0.803     0.200
    90.868     0.722     0.200
    91.193     1.517     0.200
    91.268     1.167     0.200
    91.976     0.089     0.200
    92.061     0.898     0.200
    92.194     0.781     0.200
    92.194     0.980     0.200
    92.627     1.085     0.200
    93.248     0.313     0.200
    93.550     1.329     0.200
    93.801     0.977     0.200
    94.089     0.352     0.200
    94.449     0.902     0.200
    94.725     0.278     0.200
    94.735     0.395     0.200
    94.854     0.628     0.200
    94.870    -0.328     0.200
    94.905    -0.184     0.200
    95.079     0.639     0.200
    95.336     1.246     0.200
    95.471     2.029     0.200
    95.579     0.937     0.200
    96.993     0.623     0.200
    98.287    -0.902     0.200
    98.806    -0.524     0.200
    17.648    -1.818     0.200
    19.606     0.878     0.200
    19.767    -0.172     0.200
    20.048    -1.022     0.200
    20.332     2.248     0.200
    20.453     1.360     0.200
    20.555     2.512     0.200
    20.647     1.299     0.200
    20.789     3.082     0.200
    20.924     1.137     0.200
    21.385     1.867     0.200
    21.511     3.653     0.200
    22.060     1.169     0.200
    22.863    -3.034     0.200
    22.878     1.958     0.200
    23.369    -2.158     0.200
    23.594     1.406     0.200
    23.743     0.856     0.200
    23.950    -0.438     0.200
    23.950    -0.240     0.200
    24.094     2.212     0.200
    24.879    -2.930     0.200
    24.779     0.093     0.200
    25.301    -0.357     0.200
    26.145    -1.984     0.200
    27.050    -1.825     0.200
    27.461     1.055     0.200
    28.865    -2.157     0.200
    31.524    -1.596     0.200
    32.727    -1.755     0.200
    45.159    -0.629     0.200
    52.669     0.505     0.200
    53.747     0.095     0.200
    63.846     0.868     0.200
    64.796     2.071     0.200
    64.811     1.770     0.200
    67.160     3.221     0.200
    69.472     2.356     0.200
    70.021     1.431     0.200
    70.204    -1.286     0.200
    77.081    -0.324     0.200
    84.415     0.110     0.200
    84.941     1.668     0.200
    85.069    -0.572     0.200
    94.551     0.336     0.200
    95.915    -0.170     0.200
    96.051    -0.008     0.200
    96.059    -0.844     0.200
    95.970     1.262     0.200
    96.273    -0.052     0.200
    18.804    -0.261     0.200
    19.224    -0.447     0.200
    20.900    -0.092     0.200
    21.006     1.274     0.200
    21.027     2.625     0.200
    21.038     1.026     0.200
    21.172     3.423     0.200
    21.231     2.325     0.200
    21.659     0.538     0.200
    22.296     2.577     0.200
    23.524     2.526     0.200
    24.322    -2.133     0.200
    25.078     1.754     0.200
    25.227    -0.169     0.200
    27.546     2.439     0.200
    27.587     1.524     0.200
    27.590     1.212     0.200
    27.919     1.424     0.200
    28.108     1.236     0.200
    28.233     1.450     0.200
    28.645     0.883     0.200
    28.759     0.726     0.200
    28.768     0.694     0.200
    28.803     0.731     0.200
    28.965     0.590     0.200
    29.467     0.277     0.200
    30.191     4.013     0.200
    30.720     0.010     0.200
    30.718     1.720     0.200
    30.778     2.620     0.200
    31.001     0.118     0.200
    31.018     2.707     0.200
    31.069    -0.910     0.200
    31.090     2.759     0.200
    31.154     3.300     0.200
    31.184     7.250     0.200
    31.225    -0.386     0.200
    31.300     1.865     0.200
    32.211     2.858     0.200
    32.549    -1.941     0.200
    32.649     2.998     0.200
    32.658     1.991     0.200
    33.167    -2.539     0.200
    33.458     2.963     0.200
    33.476    -1.940     0.200
    33.791     1.503     0.200
    34.282     2.166     0.200
    34.358     1.009     0.200
    34.429     2.720     0.200
    34.532     2.205     0.200
    34.833     0.197     0.200
    34.857     0.693     0.200
    38.755     2.246     0.200
    38.802     2.375     0.200
    39.002     0.071     0.200
    39.420     2.485     0.200
    39.649     1.579     0.200
    39.912     0.690     0.200
    40.208     2.222     0.200
    40.312     2.045     0.200
    40.368     1.253     0.200
    40.423     4.834     0.200
    40.811     1.888     0.200
    41.130     1.089     0.200
    45.090    -1.875     0.200
    45.795     3.813     0.200
    45.812    -1.184     0.200
    46.150     1.593     0.200
    46.199     3.064     0.200
    48.354     1.994     0.200
    48.545     0.826     0.200
    50.244     2.362     0.200
    51.156     1.093     0.200
    51.610     3.089     0.200
    51.609     2.995     0.200
    51.756     3.300     0.200
    51.790     3.759     0.200
    53.763     1.217     0.200
    53.939     0.291     0.200
    54.035     0.393     0.200
    54.143     0.512     0.200
    54.913     1.354     0.200
    55.049     1.015     0.200
    55.020     4.247     0.200
    55.093     0.118     0.200
    55.269     0.920     0.200
    55.246     4.308     0.200
    55.487     0.033     0.200
    56.660    -0.124     0.200
    57.013     1.613     0.200
    57.609    -0.298     0.200
    57.779     1.996     0.200
    57.908     4.090     0.200
    58.037     4.089     0.200
    58.182    -0.827     0.200
    59.139    -0.340     0.200
    59.193     2.142     0.200
    59.358     1.697     0.200
    59.519     2.086     0.200
    59.808     2.098     0.200
    59.827     1.775     0.200
    59.863     2.825     0.200
    59.989     2.062     0.200
    60.174     1.795     0.200
    60.238     2.357     0.200
    60.314     0.937     0.200
    60.348     2.307     0.200
    60.377     3.109     0.200
    60.553     1.998     0.200
    61.755    -0.734     0.200
    62.511     0.529     0.200
    63.592     0.972     0.200
    63.607     1.321     0.200
    66.001     0.421     0.200
    66.343    -0.997     0.200
    66.936     3.660     0.200
    66.936     3.863     0.200
    67.505    -1.550     0.200
    67.829     2.509     0.200
    68.078     3.414     0.200
    68.078     7.946     0.200
    68.969     1.987     0.200
    69.047     2.002     0.200
    69.047     4.298     0.200
    69.104    -0.250     0.200
    69.104     4.446     0.200
    69.290     2.003     0.200
    69.290     1.542     0.200
    70.175     1.549     0.200
    70.175     0.807     0.200
    70.765     1.744     0.200
    71.143    -0.844     0.200
    71.202     1.834     0.200
    74.459     3.887     0.200
    75.022     3.391     0.200
    76.938     1.364     0.200
    76.938     1.504     0.200
    77.414     1.845     0.200
    77.541     1.542     0.200
    78.685     2.000     0.200
    79.309     2.581     0.200
    79.492     0.616     0.200
    79.492     0.483     0.200
    79.719     1.389     0.200
    79.783     0.800     0.200
    79.792     1.351     0.200
    80.033     0.951     0.200
    80.204     0.434     0.200
    80.208     0.908     0.200
    80.364     0.663     0.200
    80.377     0.797     0.200
    80.480     1.041     0.200
    80.509     0.590     0.200
    80.527     1.093     0.200
    80.555     0.843     0.200
    80.604     0.583     0.200
    80.621    -0.213     0.200
    80.638     0.601     0.200
    80.659     0.863     0.200
    80.659     0.597     0.200
    80.679    -0.821     0.200
    80.679     0.851     0.200
    80.708     3.024     0.200
    80.788     1.200     0.200
    80.848     1.276     0.200
    80.970     0.922     0.200
    81.074     0.973     0.200
    81.097     2.152     0.200
    81.167     1.296     0.200
    81.173     0.844     0.200
    81.274     1.252     0.200
    81.343     0.850     0.200
    81.646     0.943     0.200
    81.651     3.815     0.200
    81.670     1.018     0.200
    81.726     1.220     0.200
    81.761     1.360     0.200
    81.790     2.079     0.200
    81.936     3.721     0.200
    81.969     1.442     0.200
    81.979     1.190     0.200
    82.025     0.938     0.200
    82.059     0.792     0.200
    82.060     1.068     0.200
    82.081     0.856     0.200
    82.107     1.219     0.200
    82.360     2.092     0.200
    82.361     0.828     0.200
    82.368     1.956     0.200
    82.407     1.051     0.200
    82.441     1.965     0.200
    82.562     1.561     0.200
    82.557     1.667     0.200
    82.621     0.941     0.200
    82.646     1.908     0.200
    82.853     0.831     0.200
    82.867     1.558     0.200
    82.870     0.993     0.200
    82.967     2.114     0.200
    82.950     0.225     0.200
    83.059    -0.236     0.200
    83.062     1.263     0.200
    83.068     1.321     0.200
    83.069     2.011     0.200
    83.071     1.897     0.200
    83.095     1.331     0.200
    83.102     1.416     0.200
    83.106     1.313     0.200
    83.122     1.884     0.200
    83.174     3.067     0.200
    83.332    -0.346     0.200
    83.519     1.584     0.200
    83.576     1.202     0.200
    83.680     1.367     0.200
    83.848     1.404     0.200
    83.858     2.307     0.200
    83.921     1.774     0.200
    83.969     1.640     0.200
    83.991     2.527     0.200
    84.350     1.057     0.200
    84.449     0.255     0.200
    84.449     0.552     0.200
    84.543     1.578     0.200
    84.550     1.743     0.200
    84.578     1.900     0.200
    84.609     3.698     0.200
    84.653     1.521     0.200
    84.733     1.122     0.200
    84.786     1.652     0.200
    84.901     1.273     0.200
    84.902     1.472     0.200
    84.958     1.488     0.200
    85.006     1.092     0.200
    85.006     1.498     0.200
    85.013     1.664     0.200
    85.023     3.520     0.200
    85.048     2.141     0.200
    85.055     0.894     0.200
    85.079     3.880     0.200
    85.176     2.192     0.200
    85.244     0.556     0.200
    85.284     1.743     0.200
    85.317     0.863     0.200
    85.317     1.933     0.200
    85.317     1.543     0.200
    85.320    -0.320     0.200
    85.351     0.822     0.200
    85.445     0.557     0.200
    85.559     0.384     0.200
    85.640     0.482     0.200
    85.723     1.487     0.200
    85.766     1.118     0.200
    85.880     1.396     0.200
    85.946     2.030     0.200
    85.991    -0.053     0.200
    86.225     1.090     0.200
    86.251     1.910     0.200
    86.343     1.971     0.200
    86.494     2.228     0.200
    86.524     0.323     0.200
    86.556     1.068     0.200
    86.625     1.127     0.200
    86.632     1.594     0.200
    86.638     0.662     0.200
    86.665     1.636     0.200
    86.774     0.205     0.200
    86.885     1.809     0.200
    86.985     0.720     0.200
    86.988     1.953     0.200
    86.988     0.125     0.200
    87.034     1.804     0.200
    87.071    -0.049     0.200
    87.071    -0.447     0.200
    87.089     0.467     0.200
    87.116     0.232     0.200
    87.254    -0.452     0.200
    87.385     1.492     0.200
    87.428     1.323     0.200
    87.442     1.556     0.200
    87.468     0.835     0.200
    87.474     0.345     0.200
    87.474     0.470     0.200
    87.512     0.422     0.200
    87.579    -0.300     0.200
    87.579    -0.902     0.200
    87.584     1.855     0.200
    87.593    -0.571     0.200
    87.593    -0.969     0.200
    87.714    -0.250     0.200
    87.714    -0.547     0.200
    87.738     1.761     0.200
    87.752    -1.328     0.200
    87.795     0.671     0.200
    87.810     0.249     0.200
    87.810     0.577     0.200
    87.856    -3.425     0.200
    87.879     0.059     0.200
    87.879     0.598     0.200
    87.959    -0.611     0.200
    87.959    -0.713     0.200
    87.965     1.861     0.200
    88.027     0.695     0.200
    88.081     0.673     0.200
    88.090     0.566     0.200
    88.098    -0.664     0.200
    88.126     0.460     0.200
    88.141     0.893     0.200
    88.155     0.362     0.200
    88.158     0.643     0.200
    88.171     0.847     0.200
    88.211     0.594     0.200
    88.237     0.177     0.200
    88.240     2.355     0.200
    88.242     0.416     0.200
    88.251     1.383     0.200
    88.255     0.077     0.200
    88.269     0.284     0.200
    88.287    -0.756     0.200
    88.297     0.839     0.200
    88.297     0.469     0.200
    88.305     0.177     0.200
    88.382    -0.899     0.200
    88.401    -0.309     0.200
    88.406     0.354     0.200
    88.406     0.486     0.200
    88.406     0.751     0.200
    88.407    -0.471     0.200
    88.412     0.264     0.200
    88.415    -0.125     0.200
    88.420     0.068     0.200
    88.436     0.258     0.200
    88.452     0.170     0.200
    88.451     0.272     0.200
    88.499     0.213     0.200
    88.555    -0.645     0.200
    88.558     0.801     0.200
    88.582    -0.858     0.200
    88.593     1.591     0.200
    88.592     0.452     0.200
    88.596     1.278     0.200
    88.597     0.125     0.200
    88.605     0.939     0.200
    88.609    -0.082     0.200
    88.634     0.690     0.200
    88.669     1.136     0.200
    88.687     0.281     0.200
    88.704    -0.268     0.200
    88.704     0.119     0.200
    88.707    -0.519     0.200
    88.793     0.068     0.200
    88.794     0.447     0.200
    88.794     1.346     0.200
    88.794    -0.560     0.200
    88.803     0.688     0.200
    88.822    -1.254     0.200
    88.822     0.216     0.200
    88.838     0.591     0.200
    88.848     0.162     0.200
    88.865    -0.760     0.200
    88.871    -0.471     0.200
    88.875     0.583     0.200
    88.910     0.222     0.200
    88.924     0.031     0.200
    88.924    -0.266     0.200
    88.932    -0.560     0.200
    88.949    -0.556     0.200
    88.949    -0.226     0.200
    88.972    -0.091     0.200
    88.984    -0.368     0.200
    88.988     0.832     0.200
    89.066    -0.909     0.200
    89.081     1.699     0.200
    89.153     0.736     0.200
    89.153     0.455     0.200
    89.171     0.643     0.200
    89.210    -0.381     0.200
    89.223     0.118     0.200
    89.234     0.483     0.200
    89.283     0.790     0.200
    89.299     0.974     0.200
    89.312    -0.385     0.200
    89.317    -0.908     0.200
    89.317     0.077     0.200
    89.345    -1.239     0.200
    89.354    -0.385     0.200
    89.361     1.583     0.200
    89.376     0.215     0.200
    89.387     0.391     0.200
    89.406     0.833     0.200
    89.454     0.438     0.200
    89.454     0.883     0.200
    89.466    -1.103     0.200
    89.504     0.911     0.200
    89.536     0.390     0.200
    89.612     1.008     0.200
    89.645     1.153     0.200
    89.698     0.347     0.200
    89.730     0.684     0.200
    89.735     0.263     0.200
    89.736    -0.564     0.200
    89.752    -0.004     0.200
    89.755     0.529     0.200
    89.755     0.154     0.200
    89.761     0.266     0.200
    89.773     0.319     0.200
    89.775     0.107     0.200
    89.776     0.821     0.200
    89.778     0.263     0.200
    89.781     0.195     0.200
    89.792     0.606     0.200
    89.800     0.551     0.200
    89.815     0.250     0.200
    89.867     0.613     0.200
    89.889     0.511     0.200
    89.962    -0.164     0.200
    89.977     0.905     0.200
    89.983     0.378     0.200
    90.002     0.482     0.200
    90.009     1.653     0.200
    90.012     0.935     0.200
    90.081     0.921     0.200
    90.118     0.646     0.200
    90.127     2.707     0.200
    90.139     0.843     0.200
    90.261     0.774     0.200
    90.264     0.256     0.200
    90.282     0.984     0.200
    90.282     1.383     0.200
    90.321     0.599     0.200
    90.321     0.404     0.200
    90.334     1.241     0.200
    90.339    -1.484     0.200
    90.352    -1.648     0.200
    90.390     0.481     0.200
    90.402    -0.176     0.200
    90.432     1.388     0.200
    90.433     1.473     0.200
    90.433     0.966     0.200
    90.467    -1.685     0.200
    90.481     1.453     0.200
    90.540     2.087     0.200
    90.547     0.747     0.200
    90.556    -1.096     0.200
    90.560    -0.310     0.200
    90.563     1.885     0.200
    90.590     1.050     0.200
    90.637     0.331     0.200
    90.725     0.618     0.200
    90.747    -0.488     0.200
    90.747     0.567     0.200
    90.762     1.357     0.200
    90.773     2.395     0.200
    90.790     1.019     0.200
    90.899     0.918     0.200
    90.932    -0.939     0.200
    90.933    -1.148     0.200
    90.955     1.867     0.200
    90.980     1.032     0.200
    90.980     1.088     0.200
    90.992     1.399     0.200
    90.994     1.069     0.200
    91.000     1.189     0.200
    91.036     0.876     0.200
    91.035    -0.300     0.200
    91.035    -1.417     0.200
    91.040     0.653     0.200
    91.060     1.061     0.200
    91.074     0.700     0.200
    91.077     1.085     0.200
    91.084     0.652     0.200
    91.142     0.283     0.200
    91.146    -1.036     0.200
    91.164     0.890     0.200
    91.207     2.510     0.200
    91.262    -1.273     0.200
    91.276     1.987     0.200
    91.283     0.938     0.200
    91.321     1.153     0.200
    91.325     0.637     0.200
    91.372     0.114     0.200
    91.374     1.136     0.200
    91.385    -0.948     0.200
    91.443     0.987     0.200
    91.450     0.956     0.200
    91.455     0.660     0.200
    91.462    -0.200     0.200
    91.477     0.517     0.200
    91.484     0.983     0.200
    91.497     0.619     0.200
    91.500     1.124     0.200
    91.529     0.761     0.200
    91.538     0.843     0.200
    91.543     0.953     0.200
    91.558     0.988     0.200
    91.586     0.575     0.200
    91.630     1.465     0.200
    91.723     1.533     0.200
    91.769     0.976     0.200
    91.769     0.726     0.200
    91.788     1.130     0.200
    91.822     1.027     0.200
    91.849     1.450     0.200
    91.996     1.225     0.200
    92.074     1.362     0.200
    92.191     1.128     0.200
    92.191     0.894     0.200
    92.198     1.494     0.200
    92.252     0.649     0.200
    92.263     1.990     0.200
    92.313     0.566     0.200
    92.774     0.435     0.200
    92.358     1.356     0.200
    92.429     1.629     0.200
    92.515     1.733     0.200
    92.567     0.791     0.200
    92.578     1.637     0.200
    92.591     0.180     0.200
    92.591     0.477     0.200
    92.670     0.316     0.200
    92.670    -0.262     0.200
    92.806    -0.455     0.200
    92.810     0.873     0.200
    92.810     0.373     0.200
    92.924     1.543     0.200
    93.045     0.985     0.200
    93.070     0.471     0.200
    93.143     1.132     0.200
    93.191    -0.720     0.200
    93.250    -0.702     0.200
    93.373     1.073     0.200
    93.433     0.448     0.200
    93.433     0.667     0.200
    93.433     0.792     0.200
    93.443     1.750     0.200
    93.443     1.953     0.200
    93.469     0.633     0.200
    93.493     0.920     0.200
    93.547     4.274     0.200
    93.604     0.010     0.200
    93.655     1.277     0.200
    93.749     2.531     0.200
    93.841     2.458     0.200
    93.903     2.197     0.200
    93.929     1.719     0.200
    93.948     2.532     0.200
    94.037     2.567     0.200
    94.025     2.576     0.200
    94.159     0.664     0.200
    94.174     1.252     0.200
    94.236     1.606     0.200
    94.279    -0.803     0.200
    94.406     0.530     0.200
    94.406     0.694     0.200
    94.488     1.653     0.200
    94.575     2.549     0.200
    94.587     0.597     0.200
    94.638    -1.216     0.200
    94.692     1.115     0.200
    94.727     0.852     0.200
    94.751     0.504     0.200
    94.758     2.611     0.200
    94.765     0.884     0.200
    94.793     1.350     0.200
    95.061     0.928     0.200
    95.126     0.730     0.200
    95.166     0.847     0.200
    95.261     1.411     0.200
    95.332     0.688     0.200
    95.359     1.236     0.200
    95.487     1.334     0.200
    95.505     0.009     0.200
    95.528     0.398     0.200
    95.685     2.081     0.200
    95.713     0.945     0.200
    95.740     0.831     0.200
    95.832     2.809     0.200
    95.832     3.012     0.200
    95.868     1.247     0.200
    95.948     1.283     0.200
    96.072     1.617     0.200
    96.180     1.326     0.200
    96.248     2.818     0.200
    96.359     0.411     0.200
    96.596     1.838     0.200
    96.596     2.041     0.200
    96.750     1.537     0.200
    96.750     1.951     0.200
    97.294     0.782     0.200
    97.592     0.837     0.200
    98.161     1.075     0.200
    98.407    -0.326     0.200
    99.335    -0.634     0.200
    20.966     0.042     0.200
    21.104     1.181     0.200
    25.294     0.150     0.200
    32.625    -2.412     0.200
    33.242    -3.105     0.200
    45.160    -1.613     0.200
    45.888    -1.378     0.200
    51.315    -2.430     0.200
    53.838    -0.314     0.200
    55.153     0.034     0.200
    63.593     2.318     0.200
    85.310     1.832     0.200
    85.397     0.497     0.200
    85.717     0.606     0.200
    87.786     0.405     0.200
    91.009    -0.316     0.200
    21.074     1.382     0.200
    21.792     1.277     0.200
    24.218    -2.198     0.200
    25.392     0.622     0.200
    28.934     0.214     0.200
    32.614    -2.251     0.200
    45.236    -1.830     0.200
    45.770    -0.157     0.200
    55.298     0.286     0.200
    63.301     1.761     0.200
    80.602    -0.049     0.200
    84.241     0.655     0.200
    84.343     0.638     0.200
    84.626     0.506     0.200
    85.092     0.863     0.200
    85.343     1.908     0.200
    86.390     0.820     0.200
    86.515     0.004     0.200
    86.956     0.048     0.200
    86.956     0.249     0.200
    87.470    -0.940     0.200
    87.606     0.404     0.200
    17.067     3.368     0.200
    18.842     1.726     0.200
    19.246    -0.304     0.200
    20.999     1.237     0.200
    21.294     5.408     0.200
    21.736     2.316     0.200
    22.429     2.354     0.200
    23.657     2.609     0.200
    24.911     0.322     0.200
    25.220     1.764     0.200
    25.321     0.598     0.200
    28.859     0.820     0.200
    32.589    -1.591     0.200
    33.138    -2.691     0.200
    39.266     1.737     0.200
    39.758    -1.863     0.200
    45.174    -1.101     0.200
    45.793    -0.694     0.200
    46.044     4.225     0.200
    48.195     2.846     0.200
    48.386     0.775     0.200
    51.277     1.341     0.200
    53.384     2.361     0.200
    53.871     0.495     0.200
    54.063     1.258     0.200
    54.163     0.887     0.200
    54.268     0.935     0.200
    55.045     1.291     0.200
    55.179     0.659     0.200
    55.209     0.176     0.200
    56.789     0.068     0.200
    57.735    -0.006     0.200
    58.300     0.610     0.200
    58.861    -0.475     0.200
    62.204     1.010     0.200
    62.352     1.097     0.200
    63.422     2.068     0.200
    68.799     2.291     0.200
    68.880     2.286     0.200
    70.597     2.108     0.200
    71.033     2.274     0.200
    78.113     0.375     0.200
    79.997     1.259     0.200
    80.161     1.874     0.200
    80.172     1.211     0.200
    80.327     1.174     0.200
    80.444     0.955     0.200
    80.566     0.890     0.200
    80.641     0.406     0.200
    80.854     2.052     0.200
    80.895     1.609     0.200
    81.296     0.806     0.200
    81.597     1.633     0.200
    82.012     1.129     0.200
    82.032     2.164     0.200
    82.326     0.880     0.200
    82.475     0.502     0.200
    82.690     0.678     0.200
    82.795     0.536     0.200
    83.000     1.270     0.200
    83.274     0.253     0.200
    83.496     1.240     0.200
    83.761     1.777     0.200
    84.294     0.844     0.200
    84.395     0.925     0.200
    84.489     2.149     0.200
    84.555     1.815     0.200
    84.678     0.900     0.200
    84.707     1.259     0.200
    84.816     1.183     0.200
    84.840     3.382     0.200
    85.087     1.366     0.200
    85.164     0.755     0.200
    85.212     1.869     0.200
    85.299     1.089     0.200
    85.337     1.290     0.200
    85.337     0.689     0.200
    85.384     0.654     0.200
    85.410     0.529     0.200
    85.626    -0.048     0.200
    85.637     1.607     0.200
    85.696     1.058     0.200
    85.796     1.225     0.200
    85.921     0.987     0.200
    86.149     0.511     0.200
    86.257     1.860     0.200
    86.407    -0.300     0.200
    86.454     0.859     0.200
    86.575     0.472     0.200
    86.583     1.550     0.200
    86.726    -0.072     0.200
    86.801     1.450     0.200
    87.012    -0.367     0.200
    87.020     0.392     0.200
    87.069    -0.144     0.200
    87.310    -0.517     0.200
    87.314     1.377     0.200
    87.363     2.148     0.200
    87.388     1.311     0.200
    87.429     0.633     0.200
    87.449    -0.282     0.200
    87.523    -0.638     0.200
    87.536    -0.905     0.200
    87.655     1.057     0.200
    87.659    -0.391     0.200
    87.700     1.913     0.200
    87.891     1.503     0.200
    87.902    -0.857     0.200
    87.951     3.114     0.200
    88.170    -0.219     0.200
    88.230    -0.112     0.200
    88.546     1.098     0.200
    88.558     0.846     0.200
    88.597     0.591     0.200
    88.648     0.180     0.200
    88.659    -0.730     0.200
    88.748     1.449     0.200
    88.765     0.732     0.200
    88.839     0.540     0.200
    88.873    -0.534     0.200
    88.949     0.272     0.200
    89.109     1.050     0.200
    89.115     0.733     0.200
    89.173     0.055     0.200
    89.249    -0.608     0.200
    89.261    -0.763     0.200
    89.267    -0.792     0.200
    89.295    -0.321     0.200
    89.306     1.329     0.200
    89.414     1.119     0.200
    89.415     0.489     0.200
    89.452     0.944     0.200
    89.497     0.335     0.200
    89.599     1.151     0.200
    89.815    -0.296     0.200
    89.839     0.532     0.200
    89.923    -0.159     0.200
    89.927     0.926     0.200
    89.939     1.664     0.200
    90.061     1.300     0.200
    90.083     1.390     0.200
    90.131     1.076     0.200
    90.204     0.531     0.200
    90.224     0.538     0.200
    90.270     0.822     0.200
    90.276     1.992     0.200
    90.279     1.781     0.200
    90.288     1.435     0.200
    90.340     1.602     0.200
    90.339     1.004     0.200
    90.375    -0.061     0.200
    90.376     1.830     0.200
    90.404    -0.604     0.200
    90.434     1.256     0.200
    90.492     1.393     0.200
    90.495     1.175     0.200
    90.541     0.758     0.200
    90.561    -0.132     0.200
    90.577    -0.005     0.200
    90.684     1.496     0.200
    90.735     2.263     0.200
    90.870    -0.172     0.200
    90.932     0.145     0.200
    90.937     1.219     0.200
    90.938     0.614     0.200
    90.980     0.918     0.200
    91.008     1.392     0.200
    91.011    -0.428     0.200
    91.021    -0.473     0.200
    91.031    -1.317     0.200
    91.085     1.036     0.200
    91.104     0.342     0.200
    91.191     1.440     0.200
    91.201     0.692     0.200
    91.271     1.821     0.200
    91.272     1.165     0.200
    91.317    -0.441     0.200
    91.324     1.220     0.200
    91.389    -0.578     0.200
    91.400     1.369     0.200
    91.487     2.171     0.200
    91.771     1.550     0.200
    91.837     1.650     0.200
    92.026     0.779     0.200
    92.149     1.107     0.200
    92.310     0.966     0.200
    92.381     1.731     0.200
    92.848    -0.021     0.200
    92.549     0.658     0.200
    92.549     0.416     0.200
    92.663     2.129     0.200
    92.767     0.650     0.200
    92.767     0.150     0.200
    92.993     0.007     0.200
    93.007    -0.557     0.200
    93.434     2.074     0.200
    93.610     0.063     0.200
    94.179     0.852     0.200
    94.369     0.676     0.200
    94.386     0.621     0.200
    94.544     1.821     0.200
    94.657     1.256     0.200
    94.716     0.687     0.200
    95.020     1.194     0.200
    95.070     0.467     0.200
    95.108    -0.168     0.200
    95.212     1.268     0.200
    95.339     1.165     0.200
    95.468     0.045     0.200
    95.566     1.297     0.200
    95.637     0.876     0.200
    95.807     2.205     0.200
    95.907     2.647     0.200
    96.037     0.656     0.200
    96.536    -0.008     0.200
    96.712     1.695     0.200
    97.899     0.667     0.200
    98.519    -0.545     0.200
    21.160     0.539     0.200
    21.299     1.387     0.200
    21.456     2.352     0.200
    21.893     1.589     0.200
    22.586     2.211     0.200
    23.816     1.788     0.200
    24.353    -1.953     0.200
    25.376     1.739     0.200
    25.482    -0.425     0.200
    29.020     1.118     0.200
    32.733    -2.127     0.200
    33.242    -2.976     0.200
    45.333    -1.354     0.200
    48.052     2.431     0.200
    51.375    -0.947     0.200
    54.429     1.116     0.200
    55.371     0.497     0.200
    56.949    -0.668     0.200
    57.895    -0.089     0.200
    58.462    -0.110     0.200
    63.303     0.373     0.200
    65.507     1.850     0.200
    68.703     2.254     0.200
    78.254     0.753     0.200
    80.737     0.307     0.200
    82.875     0.971     0.200
    83.079     0.914     0.200
    83.355     0.794     0.200
    84.375     1.380     0.200
    84.477     1.461     0.200
    84.760     1.032     0.200
    85.222     1.212     0.200
    85.450     0.874     0.200
    85.469     1.182     0.200
    85.462     1.316     0.200
    85.739     1.638     0.200
    85.911     2.284     0.200
    85.990     1.297     0.200
    86.212     1.802     0.200
    86.523     1.672     0.200
    86.640     2.018     0.200
    86.649     0.355     0.200
    86.814     0.346     0.200
    86.856     1.664     0.200
    87.089     0.706     0.200
    87.090     0.202     0.200
    87.157     0.473     0.200
    87.390     0.048     0.200
    87.524     0.200     0.200
    87.604     0.016     0.200
    87.617    -0.342     0.200
    87.983    -0.290     0.200
    88.242     0.484     0.200
    88.958     0.209     0.200
    89.201     1.370     0.200
    89.250     0.736     0.200
    89.346    -0.113     0.200
    89.403     0.122     0.200
    90.001     0.425     0.200
    90.284     0.903     0.200
    90.304     0.012     0.200
    90.656     0.574     0.200
    91.030     1.434     0.200
    91.096     0.228     0.200
    92.860     0.269     0.200
    95.184     1.041     0.200
    95.310     1.009     0.200
    95.330     0.425     0.200
    95.537     1.110     0.200
    15.466     3.263     0.200
    15.624     3.187     0.200
    15.807     3.357     0.200
    16.214     3.739     0.200
    19.758    -0.377     0.200
    19.807     0.449     0.200
    20.033     0.724     0.200
    20.077    -0.081     0.200
    20.261    -0.469     0.200
    20.819     1.686     0.200
    20.853    -0.967     0.200
    20.901     1.407     0.200
    21.024     2.546     0.200
    21.306     2.775     0.200
    21.315     2.500     0.200
    21.463     2.147     0.200
    21.821    -1.415     0.200
    21.893     0.223     0.200
    22.508     1.387     0.200
    22.759     2.230     0.200
    23.304    -1.353     0.200
    23.398     2.036     0.200
    23.457     2.184     0.200
    23.469     2.836     0.200
    23.709     0.737     0.200
    24.198    -0.752     0.200
    24.240     1.816     0.200
    24.367     0.565     0.200
    24.766    -1.012     0.200
    24.976     1.999     0.200
    25.101     1.260     0.200
    25.202     0.344     0.200
    25.187    -1.085     0.200
    25.359     0.910     0.200
    25.394     0.941     0.200
    25.734     4.473     0.200
    25.826     0.281     0.200
    26.284    -1.312     0.200
    26.317     1.232     0.200
    26.727     1.481     0.200
    26.851     1.399     0.200
    26.983    -1.363     0.200
    27.054     1.199     0.200
    27.127    -1.745     0.200
    27.782     1.089     0.200
    27.895     1.418     0.200
    28.170    -0.028     0.200
    28.577    -1.010     0.200
    28.605     0.269     0.200
    28.832    -1.844     0.200
    29.110     0.358     0.200
    29.377     1.871     0.200
    29.634     2.058     0.200
    29.700     1.218     0.200
    30.441     0.915     0.200
    30.460    -1.273     0.200
    30.615    -1.732     0.200
    31.114     2.737     0.200
    31.295     2.323     0.200
    31.345     2.239     0.200
    31.355     1.046     0.200
    31.376     0.563     0.200
    31.690     1.533     0.200
    31.785     2.273     0.200
    31.783    -1.125     0.200
    32.049     1.630     0.200
    32.271     0.902     0.200
    32.699    -1.480     0.200
    32.925     0.896     0.200
    32.983     1.136     0.200
    33.454     2.000     0.200
    35.069     0.073     0.200
    36.299    -0.874     0.200
    44.241    -0.748     0.200
    45.232    -0.724     0.200
    49.124     2.968     0.200
    52.397     2.292     0.200
    52.911     1.725     0.200
    53.280     0.670     0.200
    54.225     1.084     0.200
    54.252     1.023     0.200
    54.620     0.628     0.200
    55.801     0.638     0.200
    56.746     0.395     0.200
    57.315    -0.421     0.200
    63.286     2.054     0.200
    64.236     2.886     0.200
    64.251     2.835     0.200
    66.656     3.186     0.200
    80.444     1.304     0.200
    80.636     0.679     0.200
    80.750    -0.228     0.200
    81.325     0.520     0.200
    81.775     0.844     0.200
    82.103     0.426     0.200
    82.238     0.624     0.200
    83.024     0.093     0.200
    83.272     0.963     0.200
    83.580     1.282     0.200
    83.920     1.249     0.200
    84.014     0.871     0.200
    84.298     0.330     0.200
    84.613     0.066     0.200
    84.625     1.183     0.200
    84.703     1.133     0.200
    84.746     0.372     0.200
    84.746     0.647     0.200
    84.919     1.905     0.200
    84.933     1.636     0.200
    84.938     0.411     0.200
    84.938     0.411     0.200
    85.035     0.226     0.200
    85.446     1.377     0.200
    85.593     1.247     0.200
    85.674     1.945     0.200
    85.896     1.446     0.200
    85.979     1.938     0.200
    86.067     1.603     0.200
    86.163     1.633     0.200
    86.188     1.912     0.200
    86.225     1.230     0.200
    86.246     0.323     0.200
    86.307     0.524     0.200
    86.366     1.433     0.200
    86.565     2.163     0.200
    86.598     1.599     0.200
    86.608     0.252     0.200
    86.657     0.113     0.200
    86.722     0.594     0.200
    86.931     1.076     0.200
    86.948    -0.207     0.200
    87.029     0.999     0.200
    87.067     1.317     0.200
    87.115     0.085     0.200
    87.125     1.638     0.200
    87.151    -0.989     0.200
    87.169    -0.976     0.200
    87.260     0.684     0.200
    87.282    -0.422     0.200
    87.384     0.387     0.200
    87.402     1.399     0.200
    87.446     0.891     0.200
    87.535    -0.434     0.200
    87.612     1.138     0.200
    87.627     0.628     0.200
    87.687     1.441     0.200
    87.739     1.294     0.200
    87.753     0.728     0.200
    87.859     0.325     0.200
    88.318     0.815     0.200
    88.474     0.119     0.200
    88.634     0.262     0.200
    88.714     0.188     0.200
    88.828    -0.445     0.200
    88.841    -0.707     0.200
    88.861     0.195     0.200
    89.839     0.721     0.200
    89.859     0.025     0.200
    89.877     0.412     0.200
    89.902    -1.276     0.200
    90.164    -0.796     0.200
    90.223     0.527     0.200
    90.280    -0.163     0.200
    90.492     1.378     0.200
    90.977     1.621     0.200
    91.362     0.537     0.200
    92.320     0.635     0.200
    94.562     0.193     0.200
    96.427     1.844     0.200
    14.082     4.796     0.200
    15.912     2.839     0.200
    16.337     4.386     0.200
    16.686     4.667     0.200
    16.872     1.247     0.200
    16.953     3.440     0.200
    17.078     4.666     0.200
    20.105    -1.505     0.200
    20.744     0.462     0.200
    20.922     0.515     0.200
    21.061     0.808     0.200
    21.173    -1.309     0.200
    21.146     2.725     0.200
    21.733     1.289     0.200
    21.747     2.785     0.200
    21.941     2.203     0.200
    21.945     1.762     0.200
    21.993     1.173     0.200
    22.172    -1.883     0.200
    22.227     3.932     0.200
    22.247     2.729     0.200
    22.255     2.266     0.200
    22.289     3.815     0.200
    22.390     2.448     0.200
    22.923    -1.332     0.200
    23.090    -0.408     0.200
    23.147     1.562     0.200
    23.408     1.187     0.200
    23.611     1.270     0.200
    23.673     0.844     0.200
    23.713     2.672     0.200
    23.807     0.165     0.200
    24.140    -1.348     0.200
    24.411     2.831     0.200
    24.566    -1.312     0.200
    24.606     0.799     0.200
    24.882     1.492     0.200
    25.006     1.703     0.200
    25.107     0.856     0.200
    25.241    -0.542     0.200
    25.241     0.483     0.200
    25.340    -1.277     0.200
    25.577     0.699     0.200
    25.557     2.295     0.200
    25.932     3.011     0.200
    25.999     1.368     0.200
    26.085     0.669     0.200
    26.236     1.264     0.200
    26.287     0.826     0.200
    26.535     2.516     0.200
    26.706     0.981     0.200
    26.719     2.341     0.200
    26.756     2.341     0.200
    27.210    -1.367     0.200
    27.227     0.749     0.200
    27.354     1.082     0.200
    27.610     1.648     0.200
    27.785     1.537     0.200
    28.085     2.000     0.200
    28.138     3.073     0.200
    28.382     0.894     0.200
    28.665     0.982     0.200
    28.782     1.201     0.200
    29.041     2.162     0.200
    29.112     0.058     0.200
    29.485     0.531     0.200
    29.999     0.376     0.200
    30.641     1.206     0.200
    31.078    -1.517     0.200
    31.163     1.891     0.200
    31.243     2.458     0.200
    31.379     0.714     0.200
    31.548     1.501     0.200
    31.601     2.222     0.200
    32.046     2.485     0.200
    32.269     0.886     0.200
    32.283     0.333     0.200
    32.479    -1.299     0.200
    32.442     2.146     0.200
    32.621     1.475     0.200
    33.011    -1.658     0.200
    32.985     1.794     0.200
    33.909     0.621     0.200
    34.331     0.684     0.200
    34.388     1.859     0.200
    36.512    -0.917     0.200
    39.285     2.299     0.200
    42.045     2.290     0.200
    45.086    -0.920     0.200
    45.667    -1.213     0.200
    48.204     2.052     0.200
    52.606     2.025     0.200
    53.326     2.209     0.200
    54.213     1.007     0.200
    55.146     0.599     0.200
    55.190     1.117     0.200
    55.290     0.914     0.200
    55.542     0.602     0.200
    56.739     0.247     0.200
    57.680     0.315     0.200
    58.238     0.420     0.200
    62.150     1.206     0.200
    62.363     0.668     0.200
    63.398     1.626     0.200
    63.414     1.084     0.200
    65.721     1.602     0.200
    66.130     0.144     0.200
    71.076    -0.476     0.200
    77.182     0.039     0.200
    78.454    -0.424     0.200
    78.835    -0.985     0.200
    79.214     0.347     0.200
    80.325    -0.356     0.200
    80.656    -0.157     0.200
    80.640     1.430     0.200
    80.768     1.322     0.200
    80.870     1.162     0.200
    80.824     1.944     0.200
    81.470     1.552     0.200
    81.905     1.577     0.200
    82.643     1.457     0.200
    83.369     1.815     0.200
    83.636     1.688     0.200
    83.913    -0.691     0.200
    84.165    -0.178     0.200
    84.549    -0.126     0.200
    84.690     1.147     0.200
    84.880     1.332     0.200
    84.962     2.457     0.200
    85.038     1.721     0.200
    85.038     1.893     0.200
    85.084     2.309     0.200
    85.172     1.186     0.200
    85.211     0.352     0.200
    85.211     1.102     0.200
    85.218     0.512     0.200
    85.256     0.128     0.200
    85.568     2.831     0.200
    85.734     2.248     0.200
    86.022     2.221     0.200
    86.039     2.280     0.200
    86.132     2.578     0.200
    86.327    -0.078     0.200
    86.446    -0.370     0.200
    86.457     2.158     0.200
    86.597    -0.312     0.200
    86.675     2.610     0.200
    86.883    -0.407     0.200
    86.892    -0.152     0.200
    86.940    -0.184     0.200
    87.182    -0.561     0.200
    87.187     2.039     0.200
    87.394    -0.489     0.200
    87.408    -0.155     0.200
    87.530    -0.245     0.200
    87.774    -0.707     0.200
    88.042    -0.083     0.200
    88.744    -0.000     0.200
    88.725    -0.513     0.200
    88.836     0.168     0.200
    89.121    -0.467     0.200
    89.795    -0.123     0.200
    89.924     3.826     0.200
    90.068     0.194     0.200
    90.449     0.123     0.200
    90.438    -1.531     0.200
    90.809     1.448     0.200
    90.809    -0.254     0.200
    90.976     0.069     0.200
    91.709     0.672     0.200
    92.420     1.985     0.200
    92.639     1.102     0.200
    94.154     0.950     0.200
    94.892     1.414     0.200
    95.509     1.400     0.200
    98.450    -1.006     0.200
    99.210    -1.503     0.200
    16.746     2.819     0.200
    17.152     3.003     0.200
    18.466    -0.812     0.200
    18.921    -0.355     0.200
    20.393    -1.136     0.200
    20.976     0.516     0.200
    21.466    -1.777     0.200
    21.471    -1.745     0.200
    21.743     3.161     0.200
    21.833     0.372     0.200
    21.957     1.936     0.200
    22.031     0.897     0.200
    22.164     2.148     0.200
    22.205     2.142     0.200
    23.243    -2.018     0.200
    23.304     2.266     0.200
    23.653     2.504     0.200
    23.692     1.752     0.200
    23.841     1.087     0.200
    24.363     2.526     0.200
    24.448    -2.724     0.200
    24.535    -0.728     0.200
    24.850    -1.647     0.200
    25.005     2.180     0.200
    25.306     0.242     0.200
    25.472     2.301     0.200
    25.750     2.632     0.200
    26.141     0.897     0.200
    26.298     1.027     0.200
    26.482     2.012     0.200
    26.653     2.433     0.200
    26.766     0.838     0.200
    27.252     0.995     0.200
    27.521    -1.734     0.200
    27.767     1.570     0.200
    27.992     1.895     0.200
    28.439     1.082     0.200
    28.722     1.250     0.200
    28.834     1.144     0.200
    29.545     0.524     0.200
    30.049     0.484     0.200
    30.293     2.078     0.200
    31.142     2.509     0.200
    31.199     2.636     0.200
    31.289    -1.823     0.200
    31.350     1.566     0.200
    32.032     2.947     0.200
    32.218     2.264     0.200
    32.269     2.357     0.200
    32.610     1.253     0.200
    32.657    -2.212     0.200
    32.719     1.743     0.200
    33.291    -2.987     0.200
    33.646     1.223     0.200
    33.849     1.028     0.200
    33.910     1.073     0.200
    34.364     2.638     0.200
    34.369     1.925     0.200
    34.589     1.660     0.200
    42.023     1.496     0.200
    45.176    -1.338     0.200
    45.936    -1.651     0.200
    48.346     1.741     0.200
    53.319     1.493     0.200
    53.807     1.418     0.200
    53.848     0.017     0.200
    54.197     1.007     0.200
    55.154     0.673     0.200
    55.161     1.306     0.200
    55.201     0.871     0.200
    55.549     0.781     0.200
    56.709     0.188     0.200
    57.662    -0.343     0.200
    62.501     0.407     0.200
    63.616     0.185     0.200
    65.743     1.558     0.200
    73.675     0.919     0.200
    79.070    -1.085     0.200
    79.134    -1.033     0.200
    79.514    -1.007     0.200
    83.963    -0.029     0.200
    84.475     1.327     0.200
    84.575     1.423     0.200
    84.859     1.296     0.200
    85.368     1.243     0.200
    85.435     0.283     0.200
    85.473     0.218     0.200
    85.473     0.304     0.200
    86.649     0.808     0.200
    86.899     0.386     0.200
    87.197     0.038     0.200
    87.214     1.455     0.200
    87.494    -0.196     0.200
    87.705    -0.209     0.200
    87.719    -0.577     0.200
    87.840     0.147     0.200
    88.362     1.372     0.200
    88.936    -1.333     0.200
    89.050    -0.169     0.200
    89.425     0.971     0.200
    89.438    -0.291     0.200
    89.502     0.911     0.200
    91.052    -0.538     0.200
    91.106     1.036     0.200
    92.541     0.094     0.200
    92.935     0.442     0.200
    94.284     0.669     0.200
    14.871     5.631     0.200
    15.618     6.192     0.200
    15.778     5.940     0.200
    15.935     3.175     0.200
    16.383     5.074     0.200
    18.451    -1.979     0.200
    20.133     0.791     0.200
    20.484     0.174     0.200
    21.139     0.808     0.200
    21.145     0.839     0.200
    21.116     2.411     0.200
    21.170     2.494     0.200
    21.197     2.792     0.200
    22.115     3.077     0.200
    22.269     2.013     0.200
    22.480     2.219     0.200
    22.555     1.124     0.200
    22.751     1.787     0.200
    23.192     1.975     0.200
    23.258     2.289     0.200
    23.763     0.475     0.200
    23.965     1.440     0.200
    24.009     1.288     0.200
    24.292     2.456     0.200
    24.496     0.792     0.200
    24.463     1.504     0.200
    24.635     3.066     0.200
    24.764    -1.214     0.200
    24.716     1.833     0.200
    25.299     0.641     0.200
    25.421    -0.053     0.200
    25.366     2.379     0.200
    25.460     0.284     0.200
    25.510     1.996     0.200
    26.319     1.038     0.200
    26.725     1.540     0.200
    26.900     2.575     0.200
    26.970     1.769     0.200
    27.114     1.684     0.200
    27.601     0.269     0.200
    27.805     2.285     0.200
    27.816     2.910     0.200
    27.880     1.011     0.200
    27.977    -0.020     0.200
    27.938     0.381     0.200
    28.713     0.671     0.200
    31.021    -1.584     0.200
    32.243    -1.786     0.200
    33.402    -0.978     0.200
    44.426    -0.863     0.200
    45.964    -0.923     0.200
    49.616     3.315     0.200
    52.296     2.066     0.200
    53.153     0.831     0.200
    54.168     0.438     0.200
    54.276     0.669     0.200
    54.559     0.237     0.200
    56.611     0.336     0.200
    57.247    -0.216     0.200
    63.765     2.404     0.200
    64.930     3.125     0.200
    66.812     3.776     0.200
    70.976    -0.327     0.200
    79.344     0.137     0.200
    79.736    -1.998     0.200
    83.080    -0.625     0.200
    84.776     0.508     0.200
    84.866     0.556     0.200
    85.170    -0.267     0.200
    85.445     0.460     0.200
    85.445     0.460     0.200
    85.865     1.773     0.200
    85.904     0.273     0.200
    87.061     1.292     0.200
    87.127     0.771     0.200
    87.483     0.450     0.200
    87.523     0.158     0.200
    87.617    -0.102     0.200
    87.811    -0.721     0.200
    88.007    -0.657     0.200
    88.028    -1.458     0.200
    88.136    -0.869     0.200
    89.070     0.749     0.200
    89.675    -1.313     0.200
    89.703    -1.039     0.200
    90.919    -0.103     0.200
    91.302     0.812     0.200
    93.129     1.071     0.200
    96.489     0.099     0.200
    15.866     5.291     0.200
    15.887     6.308     0.200
    15.928     3.931     0.200
    16.017     2.469     0.200
    16.030     3.970     0.200
    16.040     7.380     0.200
    16.093     5.185     0.200
    16.120     6.061     0.200
    16.120     5.222     0.200
    16.279     4.022     0.200
    16.289     6.552     0.200
    16.317     5.250     0.200
    16.457     3.493     0.200
    16.694     4.607     0.200
    16.747     5.092     0.200
    16.801     4.914     0.200
    16.820     5.534     0.200
    16.835     4.924     0.200
    16.845     5.702     0.200
    16.868     5.929     0.200
    16.943     5.337     0.200
    17.071     4.643     0.200
    17.184     5.092     0.200
    17.606     4.820     0.200
    18.215     4.805     0.200
    18.785    -0.378     0.200
    19.659     1.134     0.200
    20.285     0.406     0.200
    20.391    -1.058     0.200
    20.539    -0.013     0.200
    20.696     0.022     0.200
    20.842    -0.245     0.200
    21.032    -0.325     0.200
    21.244     2.208     0.200
    21.241    -1.309     0.200
    21.246    -1.255     0.200
    21.253     0.649     0.200
    21.275     4.795     0.200
    21.459     3.500     0.200
    21.574     5.471     0.200
    21.624    -0.950     0.200
    21.776     5.080     0.200
    21.852     2.901     0.200
    21.852    -0.563     0.200
    21.888    -1.085     0.200
    22.047     1.763     0.200
    22.051     2.002     0.200
    22.099     1.526     0.200
    22.188     3.937     0.200
    22.242    -2.108     0.200
    22.353     2.696     0.200
    22.350     2.431     0.200
    22.492     2.130     0.200
    22.506     2.295     0.200
    22.614    -3.286     0.200
    22.832    -1.271     0.200
    22.976    -2.865     0.200
    23.170    -1.004     0.200
    23.253     1.039     0.200
    23.493     2.043     0.200
    23.515     0.957     0.200
    23.714     1.713     0.200
    23.815     2.626     0.200
    23.983     1.532     0.200
    23.982     3.470     0.200
    24.126     1.017     0.200
    24.443     2.800     0.200
    24.497     2.329     0.200
    24.514     2.690     0.200
    24.638    -1.204     0.200
    24.854    -1.126     0.200
    24.861    -1.360     0.200
    24.981     1.204     0.200
    24.971    -2.043     0.200
    24.973    -3.280     0.200
    25.111     1.855     0.200
    25.103    -0.154     0.200
    25.347     0.273     0.200
    25.391    -1.883     0.200
    25.636     2.138     0.200
    25.657     2.484     0.200
    25.684    -0.373     0.200
    26.007     3.006     0.200
    26.026     0.336     0.200
    26.106     1.035     0.200
    26.394     0.862     0.200
    26.820     2.531     0.200
    26.856     2.526     0.200
    26.910    -1.781     0.200
    27.244     1.849     0.200
    27.222     3.501     0.200
    27.268    -1.670     0.200
    27.334     0.798     0.200
    27.446     2.609     0.200
    27.460     0.624     0.200
    27.717     1.413     0.200
    27.890     1.301     0.200
    27.839    -1.554     0.200
    28.055     1.341     0.200
    28.189     2.064     0.200
    28.210     3.128     0.200
    28.238     3.345     0.200
    28.488     0.807     0.200
    28.772     1.056     0.200
    28.889     0.767     0.200
    29.123     2.201     0.200
    29.230     2.394     0.200
    29.252     2.498     0.200
    29.426     1.743     0.200
    29.591     0.537     0.200
    29.560     3.711     0.200
    30.065     0.884     0.200
    30.105     0.445     0.200
    30.416     1.372     0.200
    30.631     1.705     0.200
    30.745     1.456     0.200
    30.910     6.981     0.200
    30.954    -1.661     0.200
    31.171    -1.337     0.200
    31.268     2.014     0.200
    31.304     5.008     0.200
    31.346     2.527     0.200
    31.282    -5.100     0.200
    31.424     1.869     0.200
    31.538     1.728     0.200
    31.557     0.692     0.200
    31.631     2.303     0.200
    31.704     2.273     0.200
    31.842     1.932     0.200
    31.969     2.300     0.200
    32.151     2.556     0.200
    32.305     1.731     0.200
    32.329     1.927     0.200
    32.377     1.806     0.200
    32.376     0.459     0.200
    32.390    -0.076     0.200
    32.546     2.170     0.200
    32.568     1.828     0.200
    32.580     1.960     0.200
    32.583     1.874     0.200
    32.576    -1.645     0.200
    32.627     1.367     0.200
    32.755     1.866     0.200
    32.819     1.806     0.200
    32.874     1.532     0.200
    33.049    -2.253     0.200
    33.083    -2.877     0.200
    33.278     1.522     0.200
    33.349    -1.427     0.200
    33.555     1.984     0.200
    33.609     2.121     0.200
    33.592    -2.347     0.200
    33.764     0.906     0.200
    33.958     0.649     0.200
    34.097     1.011     0.200
    34.437     0.716     0.200
    34.597     0.890     0.200
    35.161    -2.022     0.200
    35.967    -1.770     0.200
    36.615    -1.186     0.200
    36.646    -1.228     0.200
    38.492     2.218     0.200
    38.529     3.874     0.200
    38.788     0.533     0.200
    39.103     0.405     0.200
    39.190     1.808     0.200
    39.212     0.991     0.200
    39.383     0.061     0.200
    39.540     0.402     0.200
    39.648    -1.146     0.200
    39.941     1.539     0.200
    40.045     0.863     0.200
    40.101     1.721     0.200
    40.495    -0.670     0.200
    45.093     1.991     0.200
    45.192    -1.197     0.200
    45.743    -1.660     0.200
    45.965     2.837     0.200
    48.113     2.013     0.200
    49.959     3.102     0.200
    52.066     2.580     0.200
    53.431     2.299     0.200
    53.900     0.064     0.200
    53.956     2.054     0.200
    53.973     1.830     0.200
    54.016     1.878     0.200
    54.215     1.294     0.200
    54.305    -0.272     0.200
    54.318     1.376     0.200
    54.383     1.522     0.200
    55.252     1.360     0.200
    55.294     1.633     0.200
    55.648     0.272     0.200
    56.462     2.180     0.200
    56.843     0.272     0.200
    56.813     0.008     0.200
    57.154     2.968     0.200
    57.222     1.366     0.200
    57.785     0.560     0.200
    58.344    -0.284     0.200
    59.103    -0.275     0.200
    60.276     1.381     0.200
    61.162     1.217     0.200
    61.726     0.805     0.200
    62.255     1.353     0.200
    62.271     0.604     0.200
    63.139     0.410     0.200
    63.825     1.007     0.200
    65.616     1.964     0.200
    66.227    -0.016     0.200
    66.384    -0.798     0.200
    66.530     3.570     0.200
    66.591     2.482     0.200
    66.709     1.925     0.200
    66.753     1.749     0.200
    66.877     1.655     0.200
    66.998     2.691     0.200
    67.004     1.248     0.200
    67.052     1.644     0.200
    67.609     1.015     0.200
    67.668     1.948     0.200
    68.692     1.919     0.200
    69.105     1.961     0.200
    69.383     2.232     0.200
    69.898     2.785     0.200
    70.113     0.566     0.200
    71.169    -0.997     0.200
    72.386     0.508     0.200
    72.386     0.785     0.200
    73.783     1.028     0.200
    74.350     1.453     0.200
    76.955     1.374     0.200
    76.955     1.554     0.200
    76.924     2.476     0.200
    77.199     1.433     0.200
    77.324     1.731     0.200
    77.422     1.282     0.200
    77.422     0.801     0.200
    77.744     0.591     0.200
    77.981     0.594     0.200
    78.091     1.266     0.200
    78.109     0.592     0.200
    78.243     1.990     0.200
    78.452     0.596     0.200
    78.646     0.836     0.200
    78.651     0.600     0.200
    78.657     0.587     0.200
    78.671     0.851     0.200
    78.691     0.861     0.200
    78.811     0.857     0.200
    78.826     0.561     0.200
    78.900     1.392     0.200
    78.900     0.951     0.200
    78.997     1.300     0.200
    79.024     0.883     0.200
    79.170     0.859     0.200
    79.246     0.867     0.200
    79.267     0.600     0.200
    79.278     1.222     0.200
    79.278     0.702     0.200
    79.300     0.954     0.200
    79.313     0.860     0.200
    79.352     0.815     0.200
    79.381     0.477     0.200
    79.435     1.154     0.200
    79.473     1.147     0.200
    79.568     0.802     0.200
    79.572     0.591     0.200
    79.580     1.296     0.200
    79.687     1.197     0.200
    79.687     0.884     0.200
    79.719     0.800     0.200
    79.738     0.806     0.200
    79.844     1.234     0.200
    79.868     0.875     0.200
    79.874     0.811     0.200
    79.875     0.806     0.200
    79.938     1.335     0.200
    80.074     0.858     0.200
    80.098     1.567     0.200
    80.098     1.247     0.200
    80.113     1.288     0.200
    80.113     1.178     0.200
    80.172     1.171     0.200
    80.267     1.456     0.200
    80.267     0.815     0.200
    80.284     1.369     0.200
    80.284     0.888     0.200
    80.294     1.113     0.200
    80.345     0.800     0.200
    80.358     0.880     0.200
    80.384     1.431     0.200
    80.384     0.810     0.200
    80.396     0.822     0.200
    80.417     1.450     0.200
    80.417     0.880     0.200
    80.418     0.645     0.200
    80.418     0.817     0.200
    80.438     0.877     0.200
    80.507     1.569     0.200
    80.507     0.811     0.200
    80.508     0.820     0.200
    80.510     1.352     0.200
    80.510     0.825     0.200
    80.530     1.245     0.200
    80.530     0.827     0.200
    80.560     1.183     0.200
    80.560     0.812     0.200
    80.584     0.826     0.200
    80.622     0.872     0.200
    80.644     1.232     0.200
    80.644     0.880     0.200
    80.653     0.875     0.200
    80.683     0.826     0.200
    80.678     2.453     0.200
    80.692     1.679     0.200
    80.692     1.507     0.200
    80.690     1.006     0.200
    80.689     2.021     0.200
    80.689     2.224     0.200
    80.716     0.874     0.200
    80.725     1.000     0.200
    80.767     1.116     0.200
    80.800     0.819     0.200
    80.808     1.179     0.200
    80.815     0.756     0.200
    80.840     1.173     0.200
    80.923     1.240     0.200
    80.842     1.384     0.200
    80.865     0.878     0.200
    80.869     0.879     0.200
    80.898     1.155     0.200
    80.916     1.283     0.200
    80.935     0.969     0.200
    80.963     0.966     0.200
    80.973     1.248     0.200
    80.970     0.975     0.200
    80.974     0.969     0.200
    80.977     0.975     0.200
    81.014     0.971     0.200
    81.022     1.416     0.200
    81.022     1.045     0.200
    81.027     0.975     0.200
    81.091     0.725     0.200
    81.114     1.404     0.200
    81.145     0.969     0.200
    81.244     1.632     0.200
    81.244     1.324     0.200
    81.279     1.155     0.200
    81.485     0.457     0.200
    81.518     1.162     0.200
    81.518     0.961     0.200
    81.533     1.404     0.200
    81.533     1.165     0.200
    81.533     0.962     0.200
    81.534     1.198     0.200
    81.620     1.165     0.200
    81.637     1.553     0.200
    81.717     1.170     0.200
    81.764     1.784     0.200
    81.831     0.733     0.200
    81.866     1.646     0.200
    81.865     0.652     0.200
    81.896     0.986     0.200
    81.945     1.528     0.200
    81.945     1.169     0.200
    81.951     1.035     0.200
    81.968     1.407     0.200
    81.968     1.177     0.200
    82.186     1.368     0.200
    82.189     1.951     0.200
    82.225     1.559     0.200
    82.243     1.166     0.200
    82.243     1.345     0.200
    82.357     1.973     0.200
    82.377     2.139     0.200
    82.393     0.683     0.200
    82.410     0.396     0.200
    82.434     1.670     0.200
    82.575     2.235     0.200
    82.615     2.027     0.200
    82.747     1.007     0.200
    82.697     0.996     0.200
    82.724     1.058     0.200
    82.832     2.098     0.200
    82.898     2.543     0.200
    82.929     1.094     0.200
    82.999     2.802     0.200
    83.002     2.889     0.200
    82.998     2.835     0.200
    83.002     1.913     0.200
    83.037     1.575     0.200
    83.057     2.521     0.200
    83.159    -0.296     0.200
    83.204     1.173     0.200
    83.413     1.454     0.200
    83.437     0.681     0.200
    83.444     1.336     0.200
    83.675     1.728     0.200
    83.876     1.052     0.200
    83.919     1.994     0.200
    84.020    -0.213     0.200
    84.223     1.351     0.200
    84.223     1.660     0.200
    84.325     1.335     0.200
    84.416     1.571     0.200
    84.608     1.301     0.200
    84.766     1.607     0.200
    84.905     1.608     0.200
    84.919     2.018     0.200
    85.000     2.827     0.200
    85.032    -0.483     0.200
    85.081     0.921     0.200
    85.081     0.671     0.200
    85.133     0.923     0.200
    85.245     0.723     0.200
    85.253     0.661     0.200
    85.290     0.677     0.200
    85.290     0.736     0.200
    85.309     0.134     0.200
    85.499     1.336     0.200
    85.552     1.931     0.200
    85.618     0.960     0.200
    85.774     2.110     0.200
    86.006     0.517     0.200
    86.068     1.550     0.200
    86.078     2.225     0.200
    86.172     1.981     0.200
    86.213     0.900     0.200
    86.321     1.525     0.200
    86.377     1.491     0.200
    86.400     2.376     0.200
    86.429     1.336     0.200
    86.500     1.083     0.200
    86.499     1.229     0.200
    86.543     1.072     0.200
    86.660     0.704     0.200
    86.717     1.523     0.200
    86.781     1.309     0.200
    86.828     0.882     0.200
    86.871     0.670     0.200
    86.940     0.433     0.200
    86.943     0.919     0.200
    87.003     0.824     0.200
    87.136     2.070     0.200
    87.024     1.521     0.200
    87.239     0.281     0.200
    87.236     1.512     0.200
    87.281     1.934     0.200
    87.287     0.944     0.200
    87.332     0.500     0.200
    87.365     0.829     0.200
    87.453     0.349     0.200
    87.465     0.185     0.200
    87.483     0.701     0.200
    87.571     0.697     0.200
    87.589     0.490     0.200
    87.662     0.739     0.200
    87.709     0.567     0.200
    87.832     0.131     0.200
    87.872     1.639     0.200
    87.871     1.072     0.200
    87.957     1.535     0.200
    87.967     0.289     0.200
    87.978    -0.002     0.200
    88.024     0.917     0.200
    88.038     0.951     0.200
    88.077     1.927     0.200
    88.094     0.584     0.200
    88.197     0.596     0.200
    88.263     0.587     0.200
    88.315     0.740     0.200
    88.325     0.992     0.200
    88.465     0.829     0.200
    88.490     0.211     0.200
    88.515     0.797     0.200
    88.587     1.858     0.200
    88.632    -0.658     0.200
    88.684     0.151     0.200
    88.817    -0.125     0.200
    88.839     0.269     0.200
    88.881     0.672     0.200
    88.936     1.114     0.200
    89.045     0.898     0.200
    89.100     0.942     0.200
    89.193     0.206     0.200
    89.200    -0.127     0.200
    89.228     0.143     0.200
    89.240     0.386     0.200
    89.251     0.434     0.200
    89.347     0.286     0.200
    89.355     0.850     0.200
    89.383     0.314     0.200
    89.395     0.760     0.200
    89.537     0.514     0.200
    89.609    -0.046     0.200
    89.719     0.243     0.200
    89.747    -0.499     0.200
    89.846    -0.251     0.200
    89.851     0.727     0.200
    89.859     0.488     0.200
    89.865     0.660     0.200
    89.907     0.267     0.200
    89.990     0.578     0.200
    90.022    -0.072     0.200
    90.083     0.743     0.200
    90.174     1.167     0.200
    90.133     1.212     0.200
    90.153     1.414     0.200
    90.203    -0.019     0.200
    90.202     0.587     0.200
    90.210     0.951     0.200
    90.214     0.132     0.200
    90.222    -0.345     0.200
    90.266     0.790     0.200
    90.271     0.165     0.200
    90.303     1.587     0.200
    90.306     1.002     0.200
    90.306     1.103     0.200
    90.330     0.192     0.200
    90.412     1.850     0.200
    90.417     0.483     0.200
    90.427     0.343     0.200
    90.432     1.805     0.200
    90.439     0.384     0.200
    90.459     0.490     0.200
    90.505     0.875     0.200
    90.528     0.372     0.200
    90.574     0.755     0.200
    90.614     0.266     0.200
    90.623     1.328     0.200
    90.633     1.640     0.200
    90.665     1.234     0.200
    90.722     1.969     0.200
    90.741    -0.395     0.200
    90.823     1.376     0.200
    90.866     2.730     0.200
    90.874     0.950     0.200
    90.874     0.359     0.200
    90.874     0.359     0.200
    90.893    -0.404     0.200
    90.885     0.478     0.200
    90.911     0.887     0.200
    90.938     0.466     0.200
    90.940     0.554     0.200
    91.011     0.323     0.200
    91.021     0.675     0.200
    91.044    -0.030     0.200
    91.072     0.542     0.200
    91.075     2.057     0.200
    91.118     0.725     0.200
    91.128     0.379     0.200
    91.144     0.099     0.200
    91.202     0.140     0.200
    91.236     0.380     0.200
    91.248     0.625     0.200
    91.252     0.305     0.200
    91.258     1.076     0.200
    91.335     1.900     0.200
    91.316     0.409     0.200
    91.327     0.357     0.200
    91.338     0.505     0.200
    91.379     0.717     0.200
    91.412     0.705     0.200
    91.419     1.131     0.200
    91.422     1.219     0.200
    91.497     0.162     0.200
    91.590     0.036     0.200
    91.606     0.574     0.200
    91.657     0.925     0.200
    91.657     0.240     0.200
    91.720     0.309     0.200
    91.760     1.051     0.200
    91.777     1.274     0.200
    91.959     0.330     0.200
    92.082     0.760     0.200
    92.185     0.484     0.200
    92.243     0.617     0.200
    92.314     0.687     0.200
    92.455     0.939     0.200
    92.467     1.784     0.200
    92.486     0.696     0.200
    92.570     0.708     0.200
    92.734     0.549     0.200
    92.704     0.791     0.200
    92.704     1.212     0.200
    92.925     0.349     0.200
    93.049     0.198     0.200
    93.245    -0.444     0.200
    93.328     1.353     0.200
    93.337     1.073     0.200
    93.361     0.662     0.200
    93.363    -0.239     0.200
    93.414     0.116     0.200
    93.546     0.308     0.200
    93.566    -0.284     0.200
    93.766     0.599     0.200
    93.971    -0.274     0.200
    94.044     0.715     0.200
    94.059    -0.052     0.200
    94.053     1.477     0.200
    94.109     1.221     0.200
    94.251     1.017     0.200
    94.280     0.435     0.200
    94.310     0.728     0.200
    94.370     1.520     0.200
    94.417     0.107     0.200
    94.482     1.111     0.200
    94.483    -0.100     0.200
    94.568    -0.686     0.200
    94.586    -0.072     0.200
    94.597     0.779     0.200
    94.647    -1.048     0.200
    94.650     0.637     0.200
    94.958     0.826     0.200
    94.999     0.829     0.200
    95.037     0.448     0.200
    95.122     0.577     0.200
    95.242     0.928     0.200
    95.250     0.263     0.200
    95.396     0.605     0.200
    95.446     0.498     0.200
    95.572     1.423     0.200
    95.581    -0.940     0.200
    95.626     1.076     0.200
    95.913     0.847     0.200
    96.047     0.962     0.200
    96.428     1.627     0.200
    96.464     0.606     0.200
    97.093     0.114     0.200
    97.093     0.536     0.200
    97.344    -0.940     0.200
    97.539    -0.597     0.200
    98.410     0.687     0.200
    98.557    -0.471     0.200
    99.180    -0.858     0.200
    99.294    -0.963     0.200
    99.582     1.558     0.200
    17.167     3.586     0.200
    20.327    -0.510     0.200
    20.631    -1.192     0.200
    20.804    -0.422     0.200
    21.174    -1.894     0.200
    21.179    -1.648     0.200
    21.773     0.903     0.200
    22.043     2.020     0.200
    22.090     0.351     0.200
    22.176    -2.850     0.200
    22.359     1.722     0.200
    22.374     2.147     0.200
    23.111    -0.530     0.200
    23.514     1.831     0.200
    23.506     0.674     0.200
    24.453     1.984     0.200
    24.517     2.243     0.200
    24.524     2.767     0.200
    25.111     1.901     0.200
    25.317    -2.292     0.200
    25.676     2.379     0.200
    26.026     2.903     0.200
    26.097     1.109     0.200
    26.383     0.598     0.200
    26.835     2.176     0.200
    26.874     2.206     0.200
    27.197    -1.777     0.200
    27.328     0.304     0.200
    27.894     0.582     0.200
    28.044     1.277     0.200
    28.255     1.518     0.200
    28.759     0.759     0.200
    28.877     1.082     0.200
    29.138     2.262     0.200
    29.577     0.147     0.200
    30.094     0.046     0.200
    32.383     0.131     0.200
    32.535    -1.801     0.200
    45.089     2.030     0.200
    45.171    -1.201     0.200
    45.681    -1.166     0.200
    51.162    -1.238     0.200
    53.432     2.135     0.200
    53.887     0.104     0.200
    54.321     1.339     0.200
    55.250     0.610     0.200
    55.301     1.525     0.200
    55.395     0.983     0.200
    55.645     0.665     0.200
    56.849     0.674     0.200
    57.789     0.126     0.200
    62.240    -0.135     0.200
    65.612     1.453     0.200
    78.051     0.534     0.200
    80.513     0.566     0.200
    82.653     1.511     0.200
    82.857     1.649     0.200
    83.132     1.526     0.200
    84.152     1.995     0.200
    84.254     2.078     0.200
    84.537     1.941     0.200
    85.005     1.536     0.200
    85.230     0.164     0.200
    85.230     0.305     0.200
    85.259    -1.259     0.200
    86.303     1.541     0.200
    86.590     2.129     0.200
    86.869     1.267     0.200
    86.934     1.251     0.200
    88.021     1.320     0.200
    88.768    -0.409     0.200
    89.180     0.957     0.200
    16.829     3.631     0.200
    17.220     3.812     0.200
    18.307    -0.997     0.200
    21.253    -1.988     0.200
    21.871     0.504     0.200
    22.251    -2.828     0.200
    22.392     2.258     0.200
    23.553     1.565     0.200
    24.555     1.846     0.200
    24.750     2.319     0.200
    28.092     2.460     0.200
    28.808     0.359     0.200
    28.926     0.129     0.200
    32.602    -2.107     0.200
    45.226    -1.679     0.200
    48.069     1.890     0.200
    54.358     1.025     0.200
    55.292    -0.413     0.200
    62.228     0.336     0.200
    65.576     1.971     0.200
    80.587     0.842     0.200
    84.226     0.740     0.200
    84.328     0.823     0.200
    84.611     0.586     0.200
    85.329     1.246     0.200
    86.375     1.102     0.200
    86.501     0.682     0.200
    86.872     0.466     0.200
    86.942     0.830     0.200
    86.941     0.526     0.200
    87.241     0.470     0.200
    87.455     0.340     0.200
    87.468    -0.025     0.200
    87.591     0.582     0.200
    88.094    -0.207     0.200
    90.214     1.931     0.200
    14.211     8.292     0.200
    16.008     4.335     0.200
    22.335     2.436     0.200
    22.482     3.372     0.200
    28.784     1.131     0.200
    32.621    -2.009     0.200
    45.213    -1.545     0.200
    48.154     1.663     0.200
    55.251     0.549     0.200
    62.312     0.416     0.200
    65.626     2.440     0.200
    78.144     0.140     0.200
    80.658     0.707     0.200
    83.013     1.364     0.200
    84.307     0.326     0.200
    84.408     0.516     0.200
    84.691     0.382     0.200
    85.171     2.380     0.200
    85.365     1.000     0.200
    85.359     0.397     0.200
    86.464     0.666     0.200
    86.586     0.270     0.200
    87.024    -0.073     0.200
    87.029     0.502     0.200
    87.323    -1.124     0.200
    87.536    -0.153     0.200
    87.672    -0.805     0.200
    87.915    -1.159     0.200
    88.180     0.483     0.200
    14.239     6.311     0.200
    16.062     4.295     0.200
    16.494     5.131     0.200
    17.021     1.047     0.200
    20.896    -0.002     0.200
    21.289    -2.549     0.200
    21.293    -1.424     0.200
    22.094     2.041     0.200
    22.098     2.042     0.200
    22.148     1.062     0.200
    22.391     2.676     0.200
    22.393     1.845     0.200
    22.290    -3.066     0.200
    22.545     1.829     0.200
    24.485     2.540     0.200
    24.556     2.982     0.200
    25.157     1.440     0.200
    25.397    -0.469     0.200
    26.079     0.530     0.200
    27.382     0.778     0.200
    28.538     0.307     0.200
    28.822     0.659     0.200
    28.938     1.111     0.200
    29.641    -0.090     0.200
    30.155     0.351     0.200
    45.244    -1.097     0.200
    45.793    -1.040     0.200
    48.081     1.319     0.200
    55.299     0.742     0.200
    65.572     2.101     0.200
    82.973     0.043     0.200
    83.248     0.322     0.200
    84.268     0.499     0.200
    84.370     0.682     0.200
    84.653     0.551     0.200
    85.361     0.371     0.200
    86.418     0.866     0.200
    86.543     0.554     0.200
    86.914     0.438     0.200
    86.983    -0.500     0.200
    86.984     0.694     0.200
    87.283     0.449     0.200
    87.497    -0.584     0.200
    87.633     0.659     0.200
    87.876     0.703     0.200
    88.136     0.767     0.200
    88.933     0.810     0.200
    89.895     1.204     0.200
    17.164     1.796     0.200
    21.331    -2.153     0.200
    21.829     1.101     0.200
    22.003     1.204     0.200
    22.284     2.364     0.200
    24.375     2.324     0.200
    24.445     3.169     0.200
    24.722    -2.497     0.200
    27.293     0.950     0.200
    28.860     1.338     0.200
    32.604    -1.372     0.200
    45.179    -0.958     0.200
    45.819    -1.392     0.200
    55.205     0.822     0.200
    62.372     0.388     0.200
    65.675     1.623     0.200
    84.325     0.437     0.200
    84.426     0.526     0.200
    84.709     0.295     0.200
    85.356     0.200     0.200
    85.362     0.423     0.200
    85.362     0.361     0.200
    86.487     0.753     0.200
    86.607     0.267     0.200
    86.977     0.259     0.200
    87.053     1.191     0.200
    87.342    -1.010     0.200
    87.554     0.366     0.200
    16.014     2.796     0.200
    17.877     5.208     0.200
    20.381    -0.278     0.200
    20.686    -0.316     0.200
    20.834     0.028     0.200
    21.022    -0.878     0.200
    21.235    -1.509     0.200
    21.060     3.247     0.200
    21.288     3.664     0.200
    21.243     0.560     0.200
    21.841    -0.268     0.200
    21.849     2.721     0.200
    22.043     1.845     0.200
    22.047     1.866     0.200
    22.094     1.389     0.200
    22.232    -2.176     0.200
    22.190     3.339     0.200
    22.348     2.307     0.200
    22.603    -2.225     0.200
    22.490     2.275     0.200
    22.691    -2.107     0.200
    22.504     2.401     0.200
    22.822    -0.493     0.200
    22.965    -2.973     0.200
    22.979    -2.052     0.200
    23.510     0.864     0.200
    23.493     3.149     0.200
    23.712     1.680     0.200
    23.775     0.963     0.200
    23.813     2.294     0.200
    24.038    -2.385     0.200
    23.979     1.288     0.200
    24.266    -0.896     0.200
    24.441     2.433     0.200
    24.511     2.959     0.200
    24.496     2.621     0.200
    24.708     0.669     0.200
    24.850    -2.156     0.200
    24.960    -2.859     0.200
    24.980     1.855     0.200
    25.247    -1.349     0.200
    25.108     1.758     0.200
    25.209     0.411     0.200
    25.379    -1.758     0.200
    25.341     0.025     0.200
    25.283     1.392     0.200
    25.716    -0.127     0.200
    25.633     1.839     0.200
    25.656     2.296     0.200
    25.903     2.332     0.200
    26.019     0.272     0.200
    26.005     3.005     0.200
    26.389     0.349     0.200
    26.900    -2.494     0.200
    26.818     2.315     0.200
    26.854     2.580     0.200
    27.257    -2.080     0.200
    27.238     1.680     0.200
    27.329     0.270     0.200
    27.444     2.579     0.200
    27.711     1.099     0.200
    27.887     1.359     0.200
    28.050     1.122     0.200
    28.186     1.835     0.200
    28.208     2.808     0.200
    28.237     3.214     0.200
    28.483     0.602     0.200
    28.766     0.843     0.200
    28.884     1.130     0.200
    29.121     1.962     0.200
    29.213     0.078     0.200
    29.586     0.163     0.200
    30.100    -0.022     0.200
    31.161    -2.050     0.200
    31.265     2.336     0.200
    31.344     2.754     0.200
    31.965     2.573     0.200
    32.148     2.637     0.200
    32.265     0.501     0.200
    32.568    -1.155     0.200
    32.576     2.354     0.200
    32.602     2.167     0.200
    32.723     1.249     0.200
    32.870     1.781     0.200
    33.073    -2.097     0.200
    33.443     1.990     0.200
    34.588     0.328     0.200
    36.607    -1.814     0.200
    41.127    -1.660     0.200
    45.089     0.643     0.200
    45.186    -1.005     0.200
    45.733    -1.809     0.200
    48.112     2.304     0.200
    52.708     0.932     0.200
    53.428     2.505     0.200
    53.895    -0.941     0.200
    53.954     1.140     0.200
    54.013     2.655     0.200
    54.212     1.686     0.200
    54.314     1.261     0.200
    55.248     0.804     0.200
    55.292     1.413     0.200
    55.325     1.367     0.200
    55.392     0.878     0.200
    55.644    -0.391     0.200
    56.840     0.467     0.200
    57.782     0.939     0.200
    60.275     0.870     0.200
    62.270     0.814     0.200
    63.320     1.481     0.200
    63.336     2.021     0.200
    65.619     1.922     0.200
    66.226     0.239     0.200
    68.687     2.315     0.200
    71.160    -1.285     0.200
    73.779     0.202     0.200
    78.082    -2.045     0.200
    80.549     0.836     0.200
    80.804     2.304     0.200
    80.904     1.935     0.200
    80.741     1.459     0.200
    81.507     1.886     0.200
    81.940     2.197     0.200
    82.744     2.296     0.200
    83.193    -1.226     0.200
    83.427     1.563     0.200
    83.664     2.797     0.200
    84.014     0.658     0.200
    84.314    -0.469     0.200
    84.615     2.829     0.200
    84.908     2.834     0.200
    84.989     2.546     0.200
    85.070     1.616     0.200
    85.070     1.538     0.200
    85.239     1.944     0.200
    85.280     1.170     0.200
    85.299     1.110     0.200
    85.299     0.442     0.200
    85.607     1.639     0.200
    85.763     2.585     0.200
    86.057     2.275     0.200
    86.067     2.906     0.200
    86.366    -0.316     0.200
    86.488     2.555     0.200
    86.649    -0.503     0.200
    86.706     2.489     0.200
    86.817    -0.528     0.200
    86.929    -0.773     0.200
    86.932     0.713     0.200
    86.992    -0.383     0.200
    87.225     2.977     0.200
    87.228    -0.825     0.200
    87.270     3.457     0.200
    87.442    -0.859     0.200
    87.455    -1.125     0.200
    87.578    -0.515     0.200
    87.821    -1.176     0.200
    88.879     0.218     0.200
    89.182    -0.603     0.200
    90.142    -0.797     0.200
    90.170     1.274     0.200
    90.612     1.514     0.200
    90.711     2.553     0.200
    90.785    -1.492     0.200
    90.863     1.548     0.200
    90.883     1.157     0.200
    91.305    -0.705     0.200
    92.475     1.982     0.200
    92.559     0.596     0.200
    92.693     1.226     0.200
    94.049     0.132     0.200
    94.098     1.507     0.200
    94.251     1.856     0.200
    94.471    -1.006     0.200
    94.947     2.510     0.200
    95.095     0.629     0.200
    95.221     0.769     0.200
    95.448     0.716     0.200
    16.181     3.697     0.200
    24.120     3.470     0.200
    24.734     2.076     0.200
    44.536    -0.329     0.200
    54.736     0.470     0.200
    16.439     3.327     0.200
    17.097     3.411     0.200
    20.164    -1.444     0.200
    20.600     1.135     0.200
    20.951     2.214     0.200
    20.937     0.510     0.200
    21.132     1.284     0.200
    21.233    -1.529     0.200
    21.669     2.738     0.200
    21.751     2.696     0.200
    21.756     1.113     0.200
    21.952     1.610     0.200
    22.005     1.600     0.200
    22.242     2.725     0.200
    22.231    -2.291     0.200
    22.243     2.168     0.200
    22.240    -0.903     0.200
    22.382     2.017     0.200
    22.395     1.940     0.200
    22.611    -1.725     0.200
    22.811    -1.378     0.200
    22.987    -1.579     0.200
    23.143    -0.950     0.200
    23.157     1.451     0.200
    23.420     0.789     0.200
    23.607     1.878     0.200
    23.681     1.542     0.200
    23.818     0.631     0.200
    23.887     0.886     0.200
    24.284     0.374     0.200
    24.406     2.657     0.200
    24.624    -1.086     0.200
    24.869     0.287     0.200
    24.879    -1.179     0.200
    24.985    -0.919     0.200
    25.108    -1.678     0.200
    25.166     0.425     0.200
    25.241    -1.235     0.200
    25.258     0.468     0.200
    25.532     1.613     0.200
    25.592     0.330     0.200
    25.797     3.098     0.200
    25.895     2.212     0.200
    25.927     1.559     0.200
    26.101     0.231     0.200
    26.253     0.764     0.200
    26.529     3.132     0.200
    26.710     1.857     0.200
    26.722     0.602     0.200
    27.237     0.712     0.200
    27.273    -2.161     0.200
    27.626     1.257     0.200
    27.829    -0.887     0.200
    27.961     1.376     0.200
    28.083     1.874     0.200
    28.398     0.778     0.200
    28.797     1.179     0.200
    29.501     0.113     0.200
    29.707     2.985     0.200
    30.013     0.026     0.200
    30.404     0.001     0.200
    31.123    -2.075     0.200
    31.239     3.077     0.200
    31.434     2.381     0.200
    31.527     2.703     0.200
    31.546     1.723     0.200
    31.738     2.345     0.200
    32.048     2.669     0.200
    32.179     0.453     0.200
    32.294     0.794     0.200
    32.517    -0.906     0.200
    32.624     0.984     0.200
    32.774     1.941     0.200
    33.068    -1.874     0.200
    33.690     0.308     0.200
    34.678     0.107     0.200
    34.814     2.066     0.200
    35.121     0.008     0.200
    36.644    -0.589     0.200
    41.074    -0.995     0.200
    45.109    -1.199     0.200
    45.722    -0.594     0.200
    45.983     0.966     0.200
    48.227     1.661     0.200
    53.329     1.988     0.200
    53.809    -0.259     0.200
    53.849     1.668     0.200
    53.908     0.813     0.200
    54.111     1.067     0.200
    54.214     1.020     0.200
    55.153     0.709     0.200
    55.294     0.767     0.200
    56.738     0.063     0.200
    56.744    -2.245     0.200
    57.681     0.067     0.200
    58.244    -0.096     0.200
    60.164     0.379     0.200
    63.437     1.979     0.200
    63.453     1.039     0.200
    65.720     1.509     0.200
    67.697     0.865     0.200
    68.248     0.112     0.200
    68.248     2.445     0.200
    68.248     4.778     0.200
    72.274     0.570     0.200
    73.681     1.593     0.200
    78.831    -2.251     0.200
    78.896    -2.107     0.200
    79.275    -1.281     0.200
    80.552    -0.962     0.200
    80.572     1.611     0.200
    80.833    -0.137     0.200
    81.507     1.125     0.200
    81.535    -0.004     0.200
    81.918     1.454     0.200
    81.970     0.262     0.200
    82.266     0.732     0.200
    82.429     1.978     0.200
    82.479     1.018     0.200
    82.640     1.180     0.200
    82.724     1.340     0.200
    83.395     1.322     0.200
    83.435     1.325     0.200
    83.928     0.543     0.200
    84.228     0.715     0.200
    84.329     0.903     0.200
    84.612     0.770     0.200
    84.646     1.055     0.200
    84.757     1.059     0.200
    84.947     1.483     0.200
    85.104     1.748     0.200
    85.104    -0.053     0.200
    85.149     0.850     0.200
    85.228     0.975     0.200
    85.266     0.887     0.200
    85.266     0.688     0.200
    85.265     0.281     0.200
    85.319     0.618     0.200
    85.578     0.749     0.200
    85.736     1.223     0.200
    85.801     1.825     0.200
    85.858     0.938     0.200
    86.087     0.726     0.200
    86.105     2.159     0.200
    86.198     1.839     0.200
    86.391     0.909     0.200
    86.510     0.825     0.200
    86.523     1.824     0.200
    86.658     0.899     0.200
    86.742     1.412     0.200
    86.880     0.615     0.200
    86.946     0.591     0.200
    86.956     0.844     0.200
    87.001    -0.076     0.200
    87.245     0.444     0.200
    87.457     0.417     0.200
    87.471    -0.048     0.200
    87.593     0.764     0.200
    87.837     0.200     0.200
    88.106     0.821     0.200
    88.770     0.487     0.200
    88.900     1.275     0.200
    89.108     1.099     0.200
    89.183    -0.651     0.200
    89.194    -0.706     0.200
    89.858    -0.413     0.200
    90.074     0.718     0.200
    90.489    -0.755     0.200
    90.616     1.153     0.200
    90.806     0.071     0.200
    90.860    -0.505     0.200
    90.869     1.575     0.200
    90.869     1.575     0.200
    90.947    -0.283     0.200
    90.956    -0.428     0.200
    91.259     0.769     0.200
    91.283     1.154     0.200
    91.324    -0.634     0.200
    91.768     1.107     0.200
    91.959     1.227     0.200
    92.082     0.957     0.200
    92.562     0.438     0.200
    92.622     1.161     0.200
    92.699     0.907     0.200
    92.942     0.585     0.200
    93.327     0.710     0.200
    93.542     1.120     0.200
    94.052     0.479     0.200
    94.114     1.193     0.200
    94.138     1.932     0.200
    94.415     0.809     0.200
    94.952     1.750     0.200
    95.042     0.036     0.200
    95.230     0.478     0.200
    95.403     0.588     0.200
    95.570     1.227     0.200
    98.460    -0.339     0.200
    99.262    -1.322     0.200
    20.096    -0.897     0.200
    21.165    -1.194     0.200
    22.053     1.996     0.200
    22.373     2.125     0.200
    24.560    -1.224     0.200
    24.538     2.093     0.200
    25.338    -0.083     0.200
    45.176    -1.699     0.200
    55.260     0.393     0.200
    63.252     1.532     0.200
    65.600     1.167     0.200
    85.252     0.899     0.200
    16.770     2.788     0.200
    17.034     3.704     0.200
    17.421     3.090     0.200
    18.419    -0.542     0.200
    20.265    -1.384     0.200
    20.489    -0.225     0.200
    20.640    -0.682     0.200
    20.859     2.018     0.200
    20.933     1.572     0.200
    21.034    -0.452     0.200
    21.105     2.695     0.200
    21.273     0.776     0.200
    21.324    -2.063     0.200
    21.328    -1.266     0.200
    21.510     2.861     0.200
    22.065     0.944     0.200
    22.110     3.009     0.200
    22.300     2.180     0.200
    22.305     1.816     0.200
    22.347     0.700     0.200
    22.619     2.132     0.200
    22.756     1.918     0.200
    23.013    -2.661     0.200
    23.763     0.880     0.200
    23.759     2.192     0.200
    23.977     1.925     0.200
    24.031     0.972     0.200
    24.162    -0.277     0.200
    24.234     1.541     0.200
    24.731    -1.707     0.200
    24.706     2.513     0.200
    24.777     3.281     0.200
    24.960     0.616     0.200
    25.246     2.751     0.200
    25.368     1.773     0.200
    25.463     0.418     0.200
    25.586     0.495     0.200
    25.897     1.646     0.200
    26.169     3.646     0.200
    26.272     3.180     0.200
    26.435     0.301     0.200
    26.584     0.932     0.200
    26.901     2.087     0.200
    27.085     1.754     0.200
    27.585     0.628     0.200
    27.702     1.053     0.200
    28.451     1.533     0.200
    28.504     2.644     0.200
    28.730     0.734     0.200
    29.014     0.893     0.200
    29.133     1.232     0.200
    30.350     0.193     0.200
    31.798     2.128     0.200
    32.411     2.837     0.200
    32.514     0.230     0.200
    32.762    -1.150     0.200
    32.863     2.251     0.200
    32.985     1.095     0.200
    33.074     1.798     0.200
    33.180    -2.526     0.200
    33.869     4.116     0.200
    45.422    -0.450     0.200
    45.652    -0.323     0.200
    45.853    -1.299     0.200
    47.851     1.249     0.200
    51.362    -2.292     0.200
    54.142    -0.782     0.200
    54.220     1.586     0.200
    54.476     1.197     0.200
    54.572     1.521     0.200
    54.577     0.884     0.200
    55.507     0.857     0.200
    55.589     0.618     0.200
    55.652     0.968     0.200
    55.903     0.922     0.200
    57.104     0.060     0.200
    58.045     0.265     0.200
    58.599    -0.290     0.200
    78.272     0.122     0.200
    80.660     1.331     0.200
    81.542     0.830     0.200
    84.276     0.458     0.200
    84.380     0.526     0.200
    84.641     1.226     0.200
    84.662     1.197     0.200
    85.093     1.534     0.200
    85.358     1.309     0.200
    85.406     0.772     0.200
    85.406     0.694     0.200
    85.466     0.129     0.200
    85.774     2.239     0.200
    86.406     1.513     0.200
    86.508     1.381     0.200
    86.540     1.356     0.200
    86.721     2.209     0.200
    86.725     1.449     0.200
    86.987     1.271     0.200
    87.505     1.161     0.200
    87.642     1.398     0.200
    88.129     1.581     0.200
    90.430     1.050     0.200
    90.947     1.480     0.200
    91.027    -1.289     0.200
    92.777     0.259     0.200
    14.872     4.164     0.200
    15.570     6.848     0.200
    15.730     3.535     0.200
    15.892     5.022     0.200
    16.333     5.652     0.200
    21.022     2.245     0.200
    21.133     2.215     0.200
    21.207     2.336     0.200
    22.305     1.157     0.200
    23.213     2.419     0.200
    23.280     1.921     0.200
    24.455     1.036     0.200
    44.031     1.642     0.200
    44.376    -1.174     0.200
    52.957     0.062     0.200
    54.163     0.220     0.200
    56.227    -0.552     0.200
    56.621     0.065     0.200
    80.810     1.184     0.200
    85.054     0.115     0.200
    85.304     0.246     0.200
    85.304     0.347     0.200
    90.788     0.125     0.200
    92.969     0.508     0.200
    14.016     5.406     0.200
    14.031     6.228     0.200
    14.791     3.786     0.200
    16.643     5.208     0.200
    20.543     1.517     0.200
    21.923     2.906     0.200
    22.263     2.441     0.200
    23.378     1.046     0.200
    24.359     2.294     0.200
    24.430     2.344     0.200
    24.998     1.439     0.200
    25.194    -0.601     0.200
    44.968     0.885     0.200
    45.025    -1.970     0.200
    45.025    -1.829     0.200
    53.752    -0.525     0.200
    55.132     0.208     0.200
    77.880    -0.408     0.200
    85.084    -0.051     0.200
    21.236     0.747     0.200
    21.614     1.437     0.200
    22.280     1.458     0.200
    22.618     2.126     0.200
    22.792     1.515     0.200
    24.009     1.758     0.200
    24.785     2.632     0.200
    25.355     2.275     0.200
    25.355     2.549     0.200
    25.544     0.263     0.200
    25.544     0.653     0.200
    27.561     0.852     0.200
    28.691     0.379     0.200
    32.614     0.154     0.200
    33.046    -2.884     0.200
    45.324     2.095     0.200
    45.369    -1.335     0.200
    51.249    -0.826     0.200
    54.104    -0.054     0.200
    54.104     0.454     0.200
    55.489     0.797     0.200
    65.362     1.372     0.200
    78.174     0.308     0.200
    84.226    -0.727     0.200
    85.357     0.689     0.200
    14.077     4.015     0.200
    15.800     3.104     0.200
    16.280     3.157     0.200
    16.361     3.686     0.200
    16.437     2.974     0.200
    16.623     3.451     0.200
    17.025     3.395     0.200
    17.025     2.965     0.200
    20.228    -1.386     0.200
    20.554    -1.674     0.200
    20.761    -0.187     0.200
    21.094     2.783     0.200
    21.301    -1.498     0.200
    21.565    -0.997     0.200
    21.663    -0.227     0.200
    21.698     1.817     0.200
    21.850     1.660     0.200
    21.853     2.348     0.200
    22.277    -2.017     0.200
    22.294    -2.575     0.200
    22.260     3.288     0.200
    22.552    -1.859     0.200
    22.432     3.384     0.200
    22.860    -0.344     0.200
    23.083    -2.264     0.200
    23.065     2.024     0.200
    23.138     2.018     0.200
    23.183    -1.125     0.200
    23.331     1.054     0.200
    23.485     2.330     0.200
    23.560     1.326     0.200
    23.584     1.431     0.200
    23.576     2.534     0.200
    23.690    -2.110     0.200
    23.727     2.129     0.200
    23.794    -1.884     0.200
    24.211     2.153     0.200
    24.245     2.448     0.200
    24.281     3.085     0.200
    24.496     0.565     0.200
    24.531     1.133     0.200
    24.684    -2.074     0.200
    25.024     1.323     0.200
    25.083    -0.828     0.200
    25.041     1.269     0.200
    25.182     0.661     0.200
    25.417     1.540     0.200
    25.671     3.127     0.200
    25.904    -0.547     0.200
    26.402     2.535     0.200
    26.579     2.833     0.200
    27.292     0.832     0.200
    27.359    -2.053     0.200
    27.545     1.689     0.200
    27.673     0.633     0.200
    27.892    -0.712     0.200
    28.318     0.867     0.200
    28.601     1.125     0.200
    29.930     0.388     0.200
    29.876     3.570     0.200
    30.115     5.800     0.200
    30.414    -2.301     0.200
    30.916     4.270     0.200
    31.489     5.553     0.200
    32.200     2.500     0.200
    32.502    -1.852     0.200
    32.502    -2.032     0.200
    33.075     1.980     0.200
    33.126    -2.431     0.200
    41.055    -1.590     0.200
    44.897     2.536     0.200
    45.045    -1.016     0.200
    45.111    -1.233     0.200
    45.770    -1.788     0.200
    45.770    -1.983     0.200
    48.384     2.564     0.200
    48.384     1.814     0.200
    52.380     3.349     0.200
    53.728    -0.625     0.200
    53.728    -0.469     0.200
    54.438     0.797     0.200
    55.051     0.799     0.200
    55.445    -0.158     0.200
    55.445     1.108     0.200
    56.620     1.298     0.200
    56.712    -2.265     0.200
    58.140    -0.606     0.200
    62.540     1.435     0.200
    62.540     1.092     0.200
    66.297    -1.100     0.200
    66.297    -1.303     0.200
    69.875     1.703     0.200
    73.575     1.880     0.200
    76.892     0.319     0.200
    80.673     1.359     0.200
    80.937     0.878     0.200
    81.041     0.263     0.200
    81.574     1.146     0.200
    81.620     1.974     0.200
    81.849    -0.165     0.200
    81.967     1.746     0.200
    81.993     1.711     0.200
    82.027     1.625     0.200
    82.074    -0.138     0.200
    82.331     1.735     0.200
    82.375     1.303     0.200
    82.375     0.553     0.200
    82.496     0.074     0.200
    82.535     1.274     0.200
    82.518     1.548     0.200
    82.518     2.157     0.200
    82.580     0.539     0.200
    82.590     1.284     0.200
    82.839     1.587     0.200
    83.023     0.238     0.200
    83.150    -0.297     0.200
    83.277     1.083     0.200
    83.295    -0.271     0.200
    83.303     2.188     0.200
    83.818     1.052     0.200
    84.313     0.524     0.200
    84.412     1.620     0.200
    84.696     1.485     0.200
    84.718     1.272     0.200
    84.871     1.244     0.200
    85.212     1.781     0.200
    85.212     1.273     0.200
    85.274     0.681     0.200
    85.308     0.717     0.200
    85.308     0.412     0.200
    85.408     1.513     0.200
    85.692     1.210     0.200
    85.541     4.249     0.200
    85.849     0.996     0.200
    85.915     2.149     0.200
    85.957     0.686     0.200
    86.192     1.095     0.200
    86.220     1.716     0.200
    86.312     1.636     0.200
    86.490     0.762     0.200
    86.502     0.966     0.200
    86.603     0.505     0.200
    86.735     0.458     0.200
    86.824     0.306     0.200
    86.854     2.176     0.200
    86.951     1.023     0.200
    86.983     1.279     0.200
    87.035     0.295     0.200
    87.054     0.700     0.200
    87.078    -0.212     0.200
    87.332     0.158     0.200
    87.330     1.518     0.200
    87.476     0.562     0.200
    87.481     1.236     0.200
    87.542     0.142     0.200
    87.557    -0.232     0.200
    87.677     0.393     0.200
    87.891     0.579     0.200
    87.923     0.021     0.200
    88.202     0.697     0.200
    88.886     0.467     0.200
    88.992     1.172     0.200
    89.198     0.911     0.200
    89.261     0.411     0.200
    89.275    -0.450     0.200
    89.339     0.648     0.200
    89.947     0.406     0.200
    89.971    -0.089     0.200
    89.971     1.193     0.200
    90.158     0.014     0.200
    90.245     0.311     0.200
    90.515    -1.746     0.200
    90.601     0.554     0.200
    90.685     0.558     0.200
    90.888     0.741     0.200
    90.941     0.868     0.200
    90.941     0.868     0.200
    91.038     0.920     0.200
    91.048     0.371     0.200
    91.414     0.480     0.200
    91.835     0.828     0.200
    92.481     1.022     0.200
    92.481     0.147     0.200
    93.034     0.094     0.200
    94.119     0.608     0.200
    94.366    -0.087     0.200
    95.018     2.175     0.200
    95.022     1.556     0.200
    95.021     1.158     0.200
    95.908     2.418     0.200
    96.711     1.773     0.200
    96.711     0.749     0.200
    96.951     1.083     0.200
    98.364    -1.089     0.200
    99.291    -0.527     0.200
    15.710     3.260     0.200
    16.348     2.932     0.200
    16.419     2.665     0.200
    16.507     2.283     0.200
    16.678     1.678     0.200
    17.105     2.440     0.200
    17.105     2.120     0.200
    18.733    -1.256     0.200
    19.469    -0.875     0.200
    20.726    -1.494     0.200
    20.917    -0.724     0.200
    21.098    -1.182     0.200
    21.538    -0.440     0.200
    21.809    -1.491     0.200
    21.824     0.775     0.200
    21.817     1.502     0.200
    21.926     0.491     0.200
    22.140    -0.169     0.200
    22.076     1.336     0.200
    22.648    -1.382     0.200
    22.705    -1.597     0.200
    22.791    -2.482     0.200
    22.993    -2.283     0.200
    23.061     0.963     0.200
    23.123     1.489     0.200
    23.216    -2.252     0.200
    23.321    -1.483     0.200
    23.338     0.544     0.200
    23.345     1.217     0.200
    23.565     0.915     0.200
    23.619    -1.191     0.200
    23.651    -2.826     0.200
    24.129     2.380     0.200
    24.228    -1.539     0.200
    24.231    -1.324     0.200
    24.271    -0.826     0.200
    24.294     1.282     0.200
    24.543     0.695     0.200
    25.015     1.059     0.200
    25.241     0.182     0.200
    25.241     0.226     0.200
    25.509     2.195     0.200
    25.656    -0.925     0.200
    25.654     2.460     0.200
    25.771    -0.664     0.200
    26.070     0.505     0.200
    26.266     0.791     0.200
    26.241     1.921     0.200
    26.393     1.428     0.200
    27.122     1.307     0.200
    27.291    -1.610     0.200
    27.587    -1.313     0.200
    27.586     1.616     0.200
    27.573     0.897     0.200
    27.707    -1.150     0.200
    27.886    -0.911     0.200
    27.907    -1.454     0.200
    27.832     1.867     0.200
    27.893     1.685     0.200
    28.641     0.866     0.200
    28.814     0.128     0.200
    29.469     0.993     0.200
    29.563    -0.977     0.200
    29.779    -1.508     0.200
    29.957     0.654     0.200
    30.293     3.035     0.200
    30.405    -0.008     0.200
    30.615     4.208     0.200
    30.919    -1.681     0.200
    31.409     2.244     0.200
    31.560    -1.587     0.200
    31.662     3.216     0.200
    31.833     3.413     0.200
    32.001     4.041     0.200
    32.037     3.563     0.200
    32.098     2.676     0.200
    32.330     2.581     0.200
    32.425     1.175     0.200
    32.561     1.724     0.200
    32.609     1.826     0.200
    32.776    -1.150     0.200
    33.019     2.374     0.200
    33.607    -1.450     0.200
    33.648    -1.482     0.200
    33.743     1.059     0.200
    34.228    -1.165     0.200
    34.413     1.803     0.200
    35.485     0.170     0.200
    35.485     1.025     0.200
    35.724    -1.347     0.200
    35.748    -1.606     0.200
    35.766     0.652     0.200
    36.209    -1.631     0.200
    44.859     1.741     0.200
    45.144    -0.503     0.200
    45.211    -0.776     0.200
    46.225    -0.813     0.200
    48.717     1.567     0.200
    48.717     0.934     0.200
    52.077     0.914     0.200
    53.760     0.210     0.200
    53.880     0.866     0.200
    53.991     1.431     0.200
    54.004     0.941     0.200
    54.947     0.794     0.200
    54.996     0.554     0.200
    54.996     0.814     0.200
    55.388     0.902     0.200
    55.388     0.203     0.200
    56.495     0.281     0.200
    56.921    -1.164     0.200
    61.933     0.056     0.200
    62.865     0.706     0.200
    62.865    -0.431     0.200
    64.071     0.515     0.200
    70.377     0.581     0.200
    71.450     0.168     0.200
    73.499     1.157     0.200
    79.485     0.265     0.200
    82.370     1.579     0.200
    82.370     0.892     0.200
    82.966     0.721     0.200
    83.179     0.280     0.200
    83.841     0.779     0.200
    84.855     1.337     0.200
    84.952     1.651     0.200
    85.236     1.229     0.200
    85.619     0.892     0.200
    85.746     1.088     0.200
    85.746     0.815     0.200
    85.803     1.521     0.200
    85.960     1.130     0.200
    87.061     1.625     0.200
    87.162     0.538     0.200
    87.260     2.161     0.200
    87.584     1.098     0.200
    87.623     1.312     0.200
    88.219     1.483     0.200
    89.419     1.135     0.200
    89.880     0.679     0.200
    89.906     0.456     0.200
    91.287    -0.068     0.200
    91.454     1.056     0.200
    91.454     1.056     0.200
    91.860     0.780     0.200
    92.334     0.785     0.200
    93.062     2.023     0.200
    93.133     0.496     0.200
    93.283     0.097     0.200
    93.637     0.581     0.200
    93.889     1.119     0.200
    95.147     1.051     0.200
    95.529     2.609     0.200
    96.300     1.399     0.200
    24.257     2.819     0.200
    44.858     1.449     0.200
    44.991    -0.960     0.200
    53.682     0.083     0.200
    55.014     1.304     0.200
    62.542     0.159     0.200
    14.125     4.022     0.200
    14.158     4.526     0.200
    15.818     2.105     0.200
    16.339     2.967     0.200
    16.418     3.304     0.200
    17.088     2.787     0.200
    20.869    -0.253     0.200
    20.908     0.974     0.200
    21.219     0.791     0.200
    21.461    -1.757     0.200
    21.687    -0.444     0.200
    21.773     0.948     0.200
    21.817     0.345     0.200
    21.884     1.852     0.200
    21.961     1.199     0.200
    22.197    -0.126     0.200
    22.247     3.190     0.200
    22.421    -0.854     0.200
    22.452    -2.489     0.200
    22.699    -1.727     0.200
    22.851    -2.023     0.200
    23.011    -1.199     0.200
    23.107     1.880     0.200
    23.177     1.913     0.200
    23.329    -0.697     0.200
    23.376     1.361     0.200
    23.490     1.506     0.200
    23.571     1.802     0.200
    23.604     1.110     0.200
    23.770     1.518     0.200
    23.855    -1.842     0.200
    23.949    -0.817     0.200
    24.077     1.507     0.200
    24.225     2.283     0.200
    24.283     2.403     0.200
    24.577     1.309     0.200
    24.709     1.501     0.200
    24.841    -1.522     0.200
    25.032     1.288     0.200
    25.065     1.350     0.200
    25.156    -1.964     0.200
    25.253    -0.954     0.200
    25.240    -0.416     0.200
    25.450    -1.266     0.200
    25.432     1.950     0.200
    25.560     0.825     0.200
    25.670     2.508     0.200
    25.739     2.239     0.200
    25.989     0.458     0.200
    26.219     1.001     0.200
    26.275     1.247     0.200
    26.402     2.264     0.200
    26.571     2.064     0.200
    26.592     2.040     0.200
    27.179     1.486     0.200
    27.328    -1.606     0.200
    27.510    -1.263     0.200
    27.526    -1.590     0.200
    27.599     1.615     0.200
    27.923     1.867     0.200
    28.051    -0.943     0.200
    28.037    -0.337     0.200
    28.372     1.082     0.200
    28.872     2.320     0.200
    28.978     0.450     0.200
    28.978     0.208     0.200
    29.416    -1.558     0.200
    29.431     2.077     0.200
    29.478     0.671     0.200
    29.757     1.109     0.200
    29.980     0.452     0.200
    29.951     4.064     0.200
    30.061    -2.136     0.200
    30.065     0.399     0.200
    30.033     5.192     0.200
    30.094     2.315     0.200
    30.217     4.763     0.200
    30.519     1.006     0.200
    30.631     2.592     0.200
    30.980    -2.133     0.200
    30.963     5.280     0.200
    30.963     5.452     0.200
    31.016     2.943     0.200
    31.195    -1.082     0.200
    31.241     4.008     0.200
    31.272     0.718     0.200
    31.279     1.282     0.200
    31.433     1.634     0.200
    31.596     4.766     0.200
    31.745    -1.269     0.200
    32.149     0.090     0.200
    32.215     1.283     0.200
    32.240     0.957     0.200
    32.613    -1.243     0.200
    32.613    -1.887     0.200
    32.629     2.154     0.200
    32.645     1.437     0.200
    32.885     1.884     0.200
    32.900     1.839     0.200
    33.104     0.884     0.200
    33.117     1.568     0.200
    33.286    -1.375     0.200
    33.598     0.700     0.200
    33.773     0.766     0.200
    33.834     1.257     0.200
    34.035     0.893     0.200
    34.292     1.796     0.200
    34.532     1.018     0.200
    34.720     1.500     0.200
    34.725     1.083     0.200
    35.008     0.000     0.200
    35.361    -2.295     0.200
    35.392    -2.251     0.200
    35.677    -1.984     0.200
    35.787     1.716     0.200
    36.598    -0.897     0.200
    44.930     1.991     0.200
    45.114    -1.263     0.200
    45.180    -0.918     0.200
    45.920    -1.294     0.200
    45.920    -1.464     0.200
    48.432     1.594     0.200
    48.432     1.999     0.200
    52.145     0.849     0.200
    52.410     3.583     0.200
    53.243     2.338     0.200
    53.780    -0.143     0.200
    53.917     1.196     0.200
    54.111     1.176     0.200
    54.120     0.633     0.200
    54.455     0.577     0.200
    55.080     0.694     0.200
    55.212     0.988     0.200
    55.474    -0.698     0.200
    55.474    -0.037     0.200
    56.631    -0.368     0.200
    56.808    -1.368     0.200
    58.168    -0.513     0.200
    62.054     1.247     0.200
    62.587     0.507     0.200
    62.587     0.811     0.200
    63.375     0.882     0.200
    63.700     0.522     0.200
    65.353    -0.072     0.200
    67.838     1.455     0.200
    71.247    -0.832     0.200
    73.599     1.344     0.200
    73.599     1.004     0.200
    77.008     0.453     0.200
    78.145     0.832     0.200
    79.069    -1.298     0.200
    79.131    -1.339     0.200
    79.512    -1.520     0.200
    80.538     1.737     0.200
    80.654     0.616     0.200
    80.779     0.315     0.200
    80.791     1.553     0.200
    80.799     0.190     0.200
    81.108     1.418     0.200
    81.213     1.753     0.200
    81.746     0.523     0.200
    82.020     0.427     0.200
    82.140     1.440     0.200
    82.165     0.709     0.200
    82.200     1.028     0.200
    82.246     1.726     0.200
    82.503     2.043     0.200
    82.505     1.332     0.200
    82.548     1.209     0.200
    82.522     0.541     0.200
    82.668     0.281     0.200
    82.706     1.782     0.200
    82.753     1.140     0.200
    82.763     1.190     0.200
    82.983     1.046     0.200
    83.013     1.390     0.200
    83.190     0.378     0.200
    83.321     0.680     0.200
    83.433     0.465     0.200
    83.450     0.565     0.200
    83.462     1.175     0.200
    83.894    -0.139     0.200
    83.894    -0.319     0.200
    83.992     0.582     0.200
    84.479     1.586     0.200
    84.570     0.203     0.200
    84.578     1.685     0.200
    84.861     1.556     0.200
    84.892     0.674     0.200
    84.925     1.595     0.200
    85.237     1.864     0.200
    85.320     1.796     0.200
    85.385     0.972     0.200
    85.385     1.074     0.200
    85.385     1.504     0.200
    85.402     0.323     0.200
    85.402     0.508     0.200
    85.425     0.684     0.200
    85.433     1.405     0.200
    85.455     0.784     0.200
    85.455     0.409     0.200
    85.576     1.483     0.200
    85.865     1.535     0.200
    85.896     0.842     0.200
    86.022     1.411     0.200
    86.089     1.619     0.200
    86.364     1.325     0.200
    86.394     1.699     0.200
    86.486     1.656     0.200
    86.660     1.430     0.200
    86.676     1.604     0.200
    86.772     0.685     0.200
    86.806     2.318     0.200
    86.899     0.565     0.200
    87.027     1.979     0.200
    87.064     2.160     0.200
    87.139     0.493     0.200
    87.154     1.241     0.200
    87.202     0.290     0.200
    87.224     0.882     0.200
    87.241     0.701     0.200
    87.307     2.080     0.200
    87.498     0.057     0.200
    87.503     1.515     0.200
    87.556     0.935     0.200
    87.597     0.659     0.200
    87.644     0.254     0.200
    87.652     1.517     0.200
    87.709     0.048     0.200
    87.723    -0.321     0.200
    87.764     0.784     0.200
    87.904     1.515     0.200
    87.926     0.213     0.200
    88.018     1.568     0.200
    88.055     0.299     0.200
    88.089    -0.262     0.200
    88.205     0.268     0.200
    88.228     0.879     0.200
    88.290     0.789     0.200
    88.370    -0.229     0.200
    88.371     0.503     0.200
    88.462     0.777     0.200
    88.523     0.789     0.200
    89.051     0.202     0.200
    89.161     0.886     0.200
    89.366     0.526     0.200
    89.425     0.148     0.200
    89.439    -0.120     0.200
    89.505     0.274     0.200
    89.573     0.954     0.200
    89.592     0.264     0.200
    89.998     0.369     0.200
    89.998     1.269     0.200
    90.087     0.352     0.200
    90.103     0.477     0.200
    90.114     0.527     0.200
    90.326     0.938     0.200
    90.391     1.034     0.200
    90.412     1.239     0.200
    90.464     0.098     0.200
    90.768     0.682     0.200
    90.845     1.122     0.200
    91.027    -1.299     0.200
    91.103     1.427     0.200
    91.103     1.427     0.200
    91.206     0.147     0.200
    91.217     0.197     0.200
    91.261    -0.307     0.200
    91.279     0.611     0.200
    91.384     0.021     0.200
    91.501    -0.021     0.200
    91.513     1.024     0.200
    91.582     0.106     0.200
    91.594     0.351     0.200
    91.603     0.106     0.200
    91.745     0.991     0.200
    91.994     0.999     0.200
    92.457     1.057     0.200
    92.713     1.378     0.200
    92.790     0.522     0.200
    92.932     0.867     0.200
    92.932     0.129     0.200
    93.202     0.120     0.200
    93.299     1.075     0.200
    93.551     1.314     0.200
    94.183     0.518     0.200
    94.524     0.592     0.200
    94.993     0.896     0.200
    95.182     2.032     0.200
    95.657     0.613     0.200
    95.959     1.089     0.200
    96.068     1.491     0.200
    96.870     1.753     0.200
    96.870     1.523     0.200
    98.401    -0.644     0.200
    15.392     5.042     0.200
    15.550     5.306     0.200
    15.995     4.628     0.200
    16.327     2.410     0.200
    16.750     4.213     0.200
    20.799    -0.822     0.200
    20.984     1.662     0.200
    21.484     1.077     0.200
    21.491    -0.789     0.200
    22.360    -1.596     0.200
    22.468    -2.065     0.200
    23.924    -1.722     0.200
    23.932    -1.650     0.200
    24.515     2.765     0.200
    24.846    -0.966     0.200
    24.890     0.861     0.200
    25.234    -1.551     0.200
    25.903     1.569     0.200
    27.585    -2.428     0.200
    27.609    -2.639     0.200
    48.933     2.260     0.200
    53.571     0.729     0.200
    54.642     0.957     0.200
    54.670     1.051     0.200
    54.687     0.735     0.200
    63.086     0.994     0.200
    66.258     2.289     0.200
    84.553     0.346     0.200
    84.648     1.364     0.200
    84.932     1.231     0.200
    85.257    -0.229     0.200
    85.401    -0.117     0.200
    85.401     0.531     0.200
    85.536     1.099     0.200
    86.245     1.302     0.200
    86.778     1.583     0.200
    86.870     1.236     0.200
    86.947     1.256     0.200
    87.233     0.071     0.200
    87.286     0.909     0.200
    87.339     1.254     0.200
    87.800     0.741     0.200
    87.915    -0.111     0.200
    92.964    -0.118     0.200
    16.177     3.236     0.200
    19.909    -0.926     0.200
    20.216    -0.850     0.200
    20.978    -1.303     0.200
    21.326     0.596     0.200
    21.562     0.998     0.200
    21.843     0.818     0.200
    24.227     2.353     0.200
    24.298     2.427     0.200
    24.369    -0.817     0.200
    25.081     0.335     0.200
    32.288    -1.268     0.200
    32.336     0.741     0.200
    40.847    -1.136     0.200
    44.918    -0.956     0.200
    44.985    -0.665     0.200
    47.351    -0.421     0.200
    48.268     1.850     0.200
    48.268     1.553     0.200
    50.929    -0.556     0.200
    53.637    -0.151     0.200
    55.008     0.631     0.200
    56.527    -0.826     0.200
    57.553     0.307     0.200
    62.429     0.796     0.200
    63.413     0.661     0.200
    65.847     1.758     0.200
    67.794     1.211     0.200
    73.543     0.153     0.200
    85.021     0.465     0.200
    86.645     2.041     0.200
    92.444     0.928     0.200
    15.639     6.479     0.200
    18.928     1.640     0.200
    19.840     1.829     0.200
    20.159     0.195     0.200
    20.525    -0.957     0.200
    20.543     2.202     0.200
    20.644     2.064     0.200
    20.783     2.243     0.200
    21.154     1.043     0.200
    21.165     2.623     0.200
    21.176     1.108     0.200
    21.251     2.802     0.200
    21.420    -1.664     0.200
    21.627    -1.688     0.200
    22.074     1.857     0.200
    22.175     2.937     0.200
    22.302     1.176     0.200
    22.359     1.885     0.200
    22.530     2.629     0.200
    22.585    -2.658     0.200
    22.577     2.529     0.200
    22.586     0.934     0.200
    22.643    -0.128     0.200
    22.806    -0.050     0.200
    22.787     1.101     0.200
    22.970     1.654     0.200
    23.073    -1.870     0.200
    23.154     0.269     0.200
    23.305    -1.561     0.200
    23.292     1.735     0.200
    23.309     1.965     0.200
    23.606    -2.427     0.200
    23.666     1.931     0.200
    23.793     0.617     0.200
    24.026    -0.781     0.200
    24.021     1.580     0.200
    24.106    -1.467     0.200
    24.253     0.463     0.200
    24.509     1.734     0.200
    24.520     0.823     0.200
    24.835     2.622     0.200
    25.326     0.222     0.200
    25.406    -0.816     0.200
    25.404     0.531     0.200
    25.404     0.565     0.200
    25.430     0.749     0.200
    25.468     0.377     0.200
    25.560     2.935     0.200
    25.565     2.893     0.200
    25.614     0.678     0.200
    25.679    -0.004     0.200
    25.858     0.901     0.200
    25.994     0.721     0.200
    26.153     2.734     0.200
    26.354     0.928     0.200
    26.375     1.773     0.200
    26.770     0.733     0.200
    26.957     1.775     0.200
    27.035     0.040     0.200
    27.144     2.950     0.200
    27.494     0.470     0.200
    27.602     0.474     0.200
    27.597     2.230     0.200
    27.628     1.132     0.200
    27.675     1.940     0.200
    27.861     2.414     0.200
    27.991     0.327     0.200
    27.991     0.186     0.200
    28.398     0.337     0.200
    28.427     2.016     0.200
    28.639     2.087     0.200
    28.739     1.560     0.200
    28.779    -0.083     0.200
    28.867     0.466     0.200
    29.286     0.490     0.200
    29.294     3.193     0.200
    29.417     1.827     0.200
    29.560     1.760     0.200
    29.640     2.711     0.200
    29.697    -0.177     0.200
    29.835     1.445     0.200
    29.844     2.218     0.200
    29.855     1.374     0.200
    30.150     2.335     0.200
    30.436     4.165     0.200
    30.302     1.845     0.200
    30.331     1.211     0.200
    30.379     1.513     0.200
    30.408     1.810     0.200
    30.478     2.111     0.200
    30.497     0.729     0.200
    30.507     2.300     0.200
    30.524     2.683     0.200
    30.856     2.390     0.200
    31.102     0.243     0.200
    31.360     4.829     0.200
    31.305     2.064     0.200
    31.574     3.840     0.200
    31.391     1.963     0.200
    31.420     2.163     0.200
    31.420     1.413     0.200
    31.483     1.783     0.200
    31.538     2.300     0.200
    31.607     2.672     0.200
    31.626     1.201     0.200
    31.639     1.380     0.200
    31.726     1.930     0.200
    31.736     2.849     0.200
    31.775     1.647     0.200
    31.820     1.882     0.200
    31.999     1.513     0.200
    32.369     3.931     0.200
    32.233     2.100     0.200
    32.238    -1.628     0.200
    32.238    -1.745     0.200
    32.609     4.196     0.200
    32.752     3.956     0.200
    32.845     1.439     0.200
    32.883     0.768     0.200
    32.952     1.152     0.200
    33.145     1.181     0.200
    33.363    -2.424     0.200
    33.363     2.453     0.200
    33.579     0.926     0.200
    33.649     1.182     0.200
    34.695     3.536     0.200
    35.284    -0.658     0.200
    35.576    -1.325     0.200
    35.960     0.359     0.200
    35.960     0.632     0.200
    36.042    -1.826     0.200
    36.081    -1.201     0.200
    38.438     1.505     0.200
    39.045     1.327     0.200
    44.446    -1.428     0.200
    45.930    -0.855     0.200
    48.762    -0.893     0.200
    49.545     2.059     0.200
    49.545     1.606     0.200
    51.250     2.087     0.200
    51.300     0.733     0.200
    51.604     0.565     0.200
    51.963     1.190     0.200
    53.017     0.155     0.200
    53.069     1.091     0.200
    53.198     1.238     0.200
    54.319     0.842     0.200
    54.600     0.200     0.200
    54.600     0.091     0.200
    55.659     0.351     0.200
    56.657    -0.076     0.200
    57.291     0.033     0.200
    63.695     1.615     0.200
    64.848     0.776     0.200
    65.954    -0.703     0.200
    70.964    -1.126     0.200
    72.702     1.041     0.200
    72.702     0.799     0.200
    74.359     1.873     0.200
    76.653     1.279     0.200
    76.653     1.537     0.200
    76.653     1.803     0.200
    77.795    -0.481     0.200
    79.135     0.833     0.200
    79.249    -1.184     0.200
    79.552     0.444     0.200
    79.567     1.372     0.200
    79.691    -1.887     0.200
    80.017     1.033     0.200
    80.041     1.259     0.200
    80.134     1.405     0.200
    80.288     1.291     0.200
    80.370     0.853     0.200
    80.421     0.928     0.200
    80.421     1.443     0.200
    80.602     1.345     0.200
    80.711     1.282     0.200
    80.716     1.591     0.200
    80.841     1.317     0.200
    80.907     0.793     0.200
    80.907     0.567     0.200
    80.994     1.156     0.200
    81.021     1.532     0.200
    81.078     1.320     0.200
    81.555     1.323     0.200
    81.549     1.656     0.200
    81.687     1.024     0.200
    81.960     1.287     0.200
    82.035     1.404     0.200
    82.137     0.961     0.200
    82.124     1.391     0.200
    82.145     1.607     0.200
    82.146     1.142     0.200
    82.217     1.642     0.200
    82.257     1.628     0.200
    82.334     1.258     0.200
    82.382     0.978     0.200
    82.451     1.810     0.200
    82.544     1.514     0.200
    82.574     0.282     0.200
    82.581     1.743     0.200
    82.822     1.755     0.200
    82.971     1.014     0.200
    82.971     0.623     0.200
    82.984     2.150     0.200
    83.061    -0.137     0.200
    83.101     1.137     0.200
    83.112    -0.418     0.200
    83.148     0.451     0.200
    83.196     1.055     0.200
    83.178     1.794     0.200
    83.178     2.122     0.200
    83.179     2.409     0.200
    83.243     0.311     0.200
    83.321    -0.222     0.200
    83.420     0.991     0.200
    83.457     0.709     0.200
    83.480     1.684     0.200
    83.512     1.322     0.200
    83.682     0.131     0.200
    83.720     0.054     0.200
    83.883     1.494     0.200
    83.924     1.331     0.200
    83.915     0.369     0.200
    83.920     1.291     0.200
    83.968     1.324     0.200
    84.140     0.911     0.200
    84.112     2.444     0.200
    84.332     2.106     0.200
    84.458     1.377     0.200
    84.727     1.440     0.200
    84.817     1.687     0.200
    84.924     1.718     0.200
    84.956     2.105     0.200
    85.102     1.257     0.200
    85.156     0.910     0.200
    85.156     0.613     0.200
    85.329     2.319     0.200
    85.369     2.093     0.200
    85.377    -0.407     0.200
    85.384     1.347     0.200
    85.418     1.149     0.200
    85.418     0.782     0.200
    85.418     1.266     0.200
    85.415    -0.012     0.200
    85.415     0.262     0.200
    85.448     2.132     0.200
    85.686     1.641     0.200
    85.803     2.864     0.200
    85.805     1.342     0.200
    85.805     1.163     0.200
    85.853     1.119     0.200
    85.882     1.522     0.200
    86.241     1.725     0.200
    86.291     2.149     0.200
    86.323     1.092     0.200
    86.467     1.988     0.200
    86.472     0.462     0.200
    86.554     2.664     0.200
    86.662     2.533     0.200
    86.859     2.430     0.200
    86.945     2.445     0.200
    87.006     0.752     0.200
    87.074     0.522     0.200
    87.090     0.543     0.200
    87.123     2.226     0.200
    87.236     2.031     0.200
    87.299     0.922     0.200
    87.406     1.708     0.200
    87.431     0.089     0.200
    87.428     0.304     0.200
    87.472     2.196     0.200
    87.472     0.094     0.200
    87.562     0.558     0.200
    87.564     1.666     0.200
    87.587     2.559     0.200
    87.649     1.744     0.200
    87.700     0.571     0.200
    87.760     0.010     0.200
    87.767    -0.039     0.200
    87.826     2.274     0.200
    87.940     0.461     0.200
    87.958    -0.032     0.200
    87.987     3.034     0.200
    87.978     0.279     0.200
    88.042     1.750     0.200
    88.068     0.852     0.200
    88.087     0.263     0.200
    88.099     1.000     0.200
    88.201     0.517     0.200
    88.204     0.403     0.200
    88.243     1.525     0.200
    88.270     0.489     0.200
    88.344     0.241     0.200
    88.375     2.276     0.200
    88.393     0.609     0.200
    88.455     1.397     0.200
    88.611     0.581     0.200
    88.694     0.295     0.200
    88.899     1.430     0.200
    88.950     0.188     0.200
    89.112     0.928     0.200
    89.267     0.396     0.200
    89.441     0.684     0.200
    89.629     0.305     0.200
    89.647     0.321     0.200
    89.656     0.076     0.200
    89.669     0.912     0.200
    89.698     0.777     0.200
    89.747     0.353     0.200
    90.011     0.517     0.200
    90.286     0.034     0.200
    90.312     0.912     0.200
    90.387     0.265     0.200
    90.573     0.397     0.200
    90.618     0.590     0.200
    90.649     0.844     0.200
    90.669     0.951     0.200
    90.896    -0.806     0.200
    90.896    -0.977     0.200
    90.896    -0.500     0.200
    90.983     0.392     0.200
    90.983     0.697     0.200
    91.039     0.438     0.200
    91.259     0.814     0.200
    91.259     0.814     0.200
    91.378     0.059     0.200
    91.462     0.171     0.200
    91.498     0.105     0.200
    91.513     0.135     0.200
    91.544    -2.404     0.200
    91.563     0.505     0.200
    91.584     0.908     0.200
    91.596     0.750     0.200
    91.652     0.391     0.200
    91.708     0.849     0.200
    91.766     0.863     0.200
    91.773     0.434     0.200
    91.863    -0.086     0.200
    92.112     0.060     0.200
    92.112     0.162     0.200
    92.468     0.822     0.200
    92.634     0.146     0.200
    92.750     1.020     0.200
    92.863     0.898     0.200
    92.919     0.538     0.200
    93.086     0.666     0.200
    93.086     0.478     0.200
    93.205    -0.486     0.200
    93.409     0.577     0.200
    93.661     0.320     0.200
    93.816     0.406     0.200
    93.838     0.711     0.200
    93.945     0.643     0.200
    94.842     0.557     0.200
    94.986    -0.085     0.200
    95.314     1.338     0.200
    95.322     1.301     0.200
    95.568    -1.322     0.200
    96.080     1.251     0.200
    96.569     1.078     0.200
    96.992     1.411     0.200
    97.026     1.058     0.200
    97.202     0.962     0.200
    97.336     0.255     0.200
    97.554    -0.828     0.200
    97.597     0.180     0.200
    16.678     3.078     0.200
    17.113     2.606     0.200
    17.628     2.450     0.200
    17.755     2.545     0.200
    17.791     2.602     0.200
    17.889     2.358     0.200
    18.037     2.965     0.200
    18.135     2.430     0.200
    18.164     2.290     0.200
    18.185     2.624     0.200
    18.370    -0.689     0.200
    18.875     1.398     0.200
    19.043     1.697     0.200
    19.114    -0.845     0.200
    19.234     1.555     0.200
    19.600     1.285     0.200
    19.797     1.303     0.200
    19.946     2.180     0.200
    20.142     1.935     0.200
    20.158     1.940     0.200
    20.177     2.396     0.200
    20.301     2.270     0.200
    20.399    -0.972     0.200
    20.408     2.079     0.200
    20.469     0.400     0.200
    20.552     0.131     0.200
    20.533     2.390     0.200
    20.581     2.144     0.200
    20.807    -0.808     0.200
    20.746     2.449     0.200
    20.764     2.002     0.200
    20.839     1.948     0.200
    20.913    -0.487     0.200
    20.891     2.646     0.200
    20.925     2.539     0.200
    21.052     2.239     0.200
    21.123     2.631     0.200
    21.164     2.449     0.200
    21.153     2.157     0.200
    21.192     1.860     0.200
    21.396     0.356     0.200
    21.401     1.904     0.200
    21.489    -0.830     0.200
    21.496    -0.529     0.200
    21.470     2.198     0.200
    21.484     1.464     0.200
    21.483     2.179     0.200
    21.505    -0.108     0.200
    21.507     2.421     0.200
    21.683     2.377     0.200
    21.694     2.167     0.200
    21.877     2.365     0.200
    22.067     1.653     0.200
    22.066     1.690     0.200
    22.149     1.864     0.200
    22.147     2.207     0.200
    22.339    -2.224     0.200
    22.282     1.888     0.200
    22.462    -1.731     0.200
    22.633    -1.838     0.200
    22.577     1.832     0.200
    22.619     1.903     0.200
    22.621     1.920     0.200
    22.646     2.469     0.200
    22.668     2.090     0.200
    22.705     0.293     0.200
    22.724     1.008     0.200
    22.740     2.311     0.200
    22.779     1.255     0.200
    22.910    -1.480     0.200
    22.881     0.769     0.200
    22.953     2.477     0.200
    23.020     1.594     0.200
    23.017     2.090     0.200
    23.041     1.506     0.200
    23.081     2.165     0.200
    23.141     1.892     0.200
    23.188     1.454     0.200
    23.257    -2.224     0.200
    23.307     0.889     0.200
    23.348     0.763     0.200
    23.370     2.234     0.200
    23.381     1.740     0.200
    23.474     1.827     0.200
    23.497     2.196     0.200
    23.558     1.852     0.200
    23.577     1.390     0.200
    23.582     1.946     0.200
    23.651     2.513     0.200
    23.740     2.117     0.200
    23.792     1.883     0.200
    23.833     1.385     0.200
    23.831     2.018     0.200
    23.929    -1.219     0.200
    23.930    -0.860     0.200
    23.916     2.181     0.200
    23.914     1.682     0.200
    23.932     1.188     0.200
    23.935     2.076     0.200
    24.042     1.348     0.200
    24.122    -0.423     0.200
    24.137     1.697     0.200
    24.177     1.741     0.200
    24.216     1.797     0.200
    24.367     2.784     0.200
    24.383     2.049     0.200
    24.454     1.694     0.200
    24.473     1.426     0.200
    24.473     1.801     0.200
    24.504     1.289     0.200
    24.593     1.973     0.200
    24.621     1.181     0.200
    24.662     1.423     0.200
    24.670     1.635     0.200
    24.678     1.764     0.200
    24.839    -1.511     0.200
    24.816     0.254     0.200
    24.808     1.508     0.200
    24.818     2.564     0.200
    24.874     1.048     0.200
    24.901     1.692     0.200
    24.914     1.547     0.200
    24.912     1.427     0.200
    24.915     2.304     0.200
    24.928     2.002     0.200
    25.034     1.808     0.200
    25.123     2.397     0.200
    25.237    -1.033     0.200
    25.196     1.526     0.200
    25.211     1.533     0.200
    25.230     1.604     0.200
    25.264     2.206     0.200
    25.429    -1.172     0.200
    25.390     1.312     0.200
    25.396     1.649     0.200
    25.485     0.562     0.200
    25.543     1.904     0.200
    25.581     1.111     0.200
    25.582     1.353     0.200
    25.590     1.976     0.200
    25.643    -0.116     0.200
    25.636     0.275     0.200
    25.719     0.786     0.200
    25.778     0.201     0.200
    25.780     1.480     0.200
    25.827     1.653     0.200
    25.818     1.637     0.200
    25.835     1.162     0.200
    25.844     1.381     0.200
    25.854     2.168     0.200
    25.914     1.456     0.200
    25.941     1.610     0.200
    25.985     2.107     0.200
    26.014     2.106     0.200
    26.024     1.871     0.200
    26.092     1.424     0.200
    26.186     2.023     0.200
    26.189     2.276     0.200
    26.201     2.127     0.200
    26.240     1.261     0.200
    26.302     2.200     0.200
    26.437     1.508     0.200
    26.525     1.464     0.200
    26.558     2.108     0.200
    26.616     1.110     0.200
    26.788     1.850     0.200
    26.849     0.730     0.200
    26.909    -1.656     0.200
    26.894     2.542     0.200
    26.959     1.854     0.200
    27.042     0.822     0.200
    27.115     0.947     0.200
    27.122     1.286     0.200
    27.312     2.338     0.200
    27.415    -1.874     0.200
    27.362     1.496     0.200
    27.391     1.068     0.200
    27.471     1.406     0.200
    27.481     0.542     0.200
    27.591    -1.493     0.200
    27.617    -1.810     0.200
    27.633     1.371     0.200
    27.790     1.965     0.200
    27.794     0.951     0.200
    27.833     0.941     0.200
    27.918     2.293     0.200
    27.936     0.540     0.200
    28.061    -0.293     0.200
    28.048     0.589     0.200
    28.053     1.509     0.200
    28.212     1.756     0.200
    28.141     1.412     0.200
    28.149     0.426     0.200
    28.312     1.768     0.200
    28.376     1.522     0.200
    28.397     1.270     0.200
    28.470     0.580     0.200
    28.645     0.848     0.200
    28.726     0.706     0.200
    28.769     0.473     0.200
    28.956     0.758     0.200
    28.957     0.947     0.200
    29.064     0.380     0.200
    29.221     1.629     0.200
    29.680     1.370     0.200
    29.891    -1.547     0.200
    29.975    -0.113     0.200
    30.058     1.495     0.200
    30.083     1.341     0.200
    30.098     1.006     0.200
    30.411     1.451     0.200
    30.489     1.365     0.200
    30.640     1.584     0.200
    30.690     2.102     0.200
    31.033     3.508     0.200
    31.055    -0.002     0.200
    31.067    -1.325     0.200
    31.032     1.499     0.200
    31.167     2.217     0.200
    31.557     3.334     0.200
    31.557     2.272     0.200
    31.557     3.662     0.200
    31.615     2.942     0.200
    31.593     1.603     0.200
    31.826     2.133     0.200
    31.768    -0.957     0.200
    32.208     1.473     0.200
    32.361    -1.214     0.200
    32.452     1.495     0.200
    32.558     1.741     0.200
    32.762     1.449     0.200
    33.100     1.380     0.200
    33.304     3.018     0.200
    33.304     2.835     0.200
    33.267    -1.961     0.200
    33.338    -1.269     0.200
    33.267     0.994     0.200
    33.389     0.135     0.200
    33.752     0.816     0.200
    33.993     0.750     0.200
    34.001     0.873     0.200
    34.150     2.570     0.200
    35.479     1.012     0.200
    35.479     0.379     0.200
    38.520     2.085     0.200
    38.834     0.810     0.200
    44.717    -0.951     0.200
    48.222    -0.798     0.200
    51.663     0.957     0.200
    52.345     1.647     0.200
    52.995     2.751     0.200
    53.241     2.352     0.200
    53.337     0.721     0.200
    53.337     0.382     0.200
    53.482     1.458     0.200
    53.602     1.179     0.200
    54.707     1.320     0.200
    54.978     0.361     0.200
    56.077     0.659     0.200
    57.064     0.546     0.200
    57.673    -0.241     0.200
    60.453     2.661     0.200
    62.858     0.761     0.200
    63.185     0.899     0.200
    64.305     1.807     0.200
    64.305     1.577     0.200
    65.186     0.543     0.200
    66.348     1.759     0.200
    66.348     1.434     0.200
    73.093     1.950     0.200
    73.093     1.700     0.200
    74.386     0.365     0.200
    76.770     0.281     0.200
    78.916     1.810     0.200
    79.852     0.997     0.200
    80.080     1.870     0.200
    81.260     0.716     0.200
    81.278     2.332     0.200
    81.733     1.314     0.200
    81.977     1.729     0.200
    81.981     1.509     0.200
    82.109     1.049     0.200
    82.323     1.416     0.200
    82.331     1.276     0.200
    82.371     1.667     0.200
    82.709     1.605     0.200
    82.721     1.240     0.200
    82.721     1.693     0.200
    82.825    -0.178     0.200
    82.864     1.496     0.200
    82.941     1.398     0.200
    83.125     0.689     0.200
    83.125     0.857     0.200
    83.158     1.180     0.200
    83.211     0.909     0.200
    83.372     0.436     0.200
    83.461    -0.404     0.200
    83.621     0.867     0.200
    83.652     1.617     0.200
    83.911     0.449     0.200
    84.188     0.470     0.200
    84.557     1.428     0.200
    84.652     1.650     0.200
    84.706     1.126     0.200
    84.936     1.419     0.200
    85.088     1.759     0.200
    85.095     1.884     0.200
    85.220    -0.352     0.200
    85.220     0.047     0.200
    85.264     2.178     0.200
    85.368     0.259     0.200
    85.381     0.693     0.200
    85.381     0.943     0.200
    85.527     1.670     0.200
    85.557     1.584     0.200
    85.557     1.280     0.200
    85.557     1.440     0.200
    85.620     1.641     0.200
    85.670     2.254     0.200
    86.017     1.407     0.200
    86.058     1.036     0.200
    86.207     1.698     0.200
    86.258    -0.053     0.200
    86.285     2.314     0.200
    86.448     2.616     0.200
    86.590     1.536     0.200
    86.679     2.079     0.200
    86.863    -0.326     0.200
    86.879     1.503     0.200
    86.947     0.571     0.200
    86.983     1.196     0.200
    87.213     1.981     0.200
    87.242     0.340     0.200
    87.297     1.504     0.200
    87.287     0.721     0.200
    87.293     0.094     0.200
    87.319    -3.934     0.200
    87.350     0.897     0.200
    87.352     0.710     0.200
    87.437     1.898     0.200
    87.585     0.186     0.200
    87.579     0.661     0.200
    87.634     0.233     0.200
    87.677     1.542     0.200
    87.749     0.101     0.200
    87.788     0.015     0.200
    87.808     1.761     0.200
    87.806    -0.467     0.200
    87.890     0.729     0.200
    87.920     0.190     0.200
    87.947     0.659     0.200
    88.032     1.755     0.200
    88.080     0.127     0.200
    88.116     0.355     0.200
    88.172     0.995     0.200
    88.199     0.514     0.200
    88.252     0.415     0.200
    88.490     0.388     0.200
    88.516     0.264     0.200
    88.615    -1.321     0.200
    88.797    -0.155     0.200
    89.113     0.259     0.200
    89.121     0.421     0.200
    89.268     0.731     0.200
    89.310     0.230     0.200
    89.462     0.420     0.200
    89.480     0.236     0.200
    89.501    -0.063     0.200
    89.525     1.427     0.200
    89.527    -0.182     0.200
    89.497     1.656     0.200
    89.497     1.016     0.200
    89.586     0.642     0.200
    89.653    -0.773     0.200
    89.890     0.420     0.200
    90.057    -1.962     0.200
    90.140    -0.244     0.200
    90.161     0.355     0.200
    90.206     0.444     0.200
    90.429     0.808     0.200
    90.433     0.586     0.200
    90.475     0.992     0.200
    90.496     1.296     0.200
    90.526    -2.145     0.200
    90.859     0.708     0.200
    90.865     0.476     0.200
    90.865     0.976     0.200
    90.905    -0.585     0.200
    91.053     0.508     0.200
    91.133     1.036     0.200
    91.133     1.036     0.200
    91.270    -0.101     0.200
    91.270     0.200     0.200
    91.345     0.454     0.200
    91.402     0.586     0.200
    91.446     0.580     0.200
    91.466     0.688     0.200
    91.475     0.748     0.200
    91.534     1.578     0.200
    91.580    -2.236     0.200
    91.643     0.867     0.200
    91.663     0.379     0.200
    91.937     1.006     0.200
    91.879     0.379     0.200
    91.879     1.438     0.200
    92.003     0.201     0.200
    92.003     0.822     0.200
    92.342     0.838     0.200
    92.525     1.392     0.200
    92.739     1.505     0.200
    92.805     1.299     0.200
    92.961     0.484     0.200
    92.961     0.855     0.200
    93.304     1.800     0.200
    93.375     1.472     0.200
    93.557     1.336     0.200
    93.700     1.874     0.200
    94.530     0.665     0.200
    94.813     1.266     0.200
    95.203     1.584     0.200
    95.621    -0.720     0.200
    95.970     1.188     0.200
    96.106     0.794     0.200
    96.106     0.591     0.200
    96.674     1.993     0.200
    96.784     1.567     0.200
    96.854     0.275     0.200
    96.882     1.749     0.200
    97.504     0.442     0.200
    97.819    -1.277     0.200
    14.743     5.050     0.200
    16.255     2.435     0.200
    16.513     3.397     0.200
    16.513     3.733     0.200
    19.864     0.329     0.200
    20.724     0.860     0.200
    21.149     1.620     0.200
    21.425     1.821     0.200
    21.994    -1.280     0.200
    23.152     0.861     0.200
    23.965     2.072     0.200
    23.986    -0.413     0.200
    24.680     0.235     0.200
    25.713     0.675     0.200
    26.654     0.509     0.200
    27.827     0.865     0.200
    31.863    -1.097     0.200
    32.427    -2.269     0.200
    44.508    -1.767     0.200
    45.073    -1.065     0.200
    53.240    -0.424     0.200
    53.462     0.665     0.200
    62.687     0.504     0.200
    66.204     1.179     0.200
    79.942     0.637     0.200
    84.602    -0.861     0.200
    84.613    -0.436     0.200
    84.613    -0.162     0.200
    92.075    -0.869     0.200
    15.573     2.731     0.200
    15.785     3.208     0.200
    16.373     2.498     0.200
    16.373     2.242     0.200
    16.373     3.073     0.200
    16.658     2.112     0.200
    16.788     2.474     0.200
    17.180     1.710     0.200
    17.270     3.155     0.200
    17.270     3.354     0.200
    17.270     2.827     0.200
    17.361     2.324     0.200
    17.596     2.389     0.200
    17.631     3.140     0.200
    17.692     2.640     0.200
    17.688     2.927     0.200
    17.978     2.239     0.200
    17.991     2.961     0.200
    17.998     2.693     0.200
    17.998     3.127     0.200
    17.965     3.121     0.200
    17.984     3.174     0.200
    18.066     2.798     0.200
    18.089     2.482     0.200
    19.176    -0.723     0.200
    19.843     0.073     0.200
    20.127     0.765     0.200
    20.457    -0.025     0.200
    20.521    -0.715     0.200
    20.997    -0.944     0.200
    21.012     1.989     0.200
    21.125     1.159     0.200
    21.142     1.271     0.200
    21.187     2.570     0.200
    21.187     2.705     0.200
    21.212     2.322     0.200
    21.402    -0.334     0.200
    21.362     2.090     0.200
    21.482     1.808     0.200
    21.624    -1.842     0.200
    21.582     2.033     0.200
    21.647     2.688     0.200
    21.676     2.645     0.200
    21.770     2.217     0.200
    22.036     1.721     0.200
    22.080     2.583     0.200
    22.115     2.868     0.200
    22.138     2.511     0.200
    22.135     2.362     0.200
    22.204     1.995     0.200
    22.268     1.346     0.200
    22.248     2.818     0.200
    22.275     2.038     0.200
    22.325     1.698     0.200
    22.354     1.195     0.200
    22.462     1.895     0.200
    22.492     1.802     0.200
    22.492     2.835     0.200
    22.581    -2.311     0.200
    22.552     1.195     0.200
    22.501     1.935     0.200
    22.538     2.544     0.200
    22.531     1.874     0.200
    22.562     1.636     0.200
    22.615     0.809     0.200
    22.678    -1.142     0.200
    22.577     2.258     0.200
    22.752     1.077     0.200
    22.820    -0.952     0.200
    22.778     0.893     0.200
    22.766     1.278     0.200
    22.854     1.170     0.200
    22.889     2.192     0.200
    22.893     1.890     0.200
    22.936     1.177     0.200
    23.040    -1.279     0.200
    22.991     1.433     0.200
    22.965     1.821     0.200
    22.983     1.799     0.200
    23.124     0.985     0.200
    23.105     1.636     0.200
    23.115     2.093     0.200
    23.146     1.148     0.200
    23.142     2.446     0.200
    23.295    -1.459     0.200
    23.271     2.024     0.200
    23.289     1.045     0.200
    23.352     2.223     0.200
    23.419     1.296     0.200
    23.422     1.336     0.200
    23.436     1.319     0.200
    23.453     1.399     0.200
    23.491     0.433     0.200
    23.477     1.416     0.200
    23.610    -2.261     0.200
    23.590     1.321     0.200
    23.617     0.955     0.200
    23.626     1.197     0.200
    23.690     1.652     0.200
    23.710     1.579     0.200
    23.759     0.055     0.200
    23.774     0.993     0.200
    23.868     2.683     0.200
    23.889     2.716     0.200
    23.914     1.903     0.200
    24.020    -0.502     0.200
    23.982     1.342     0.200
    24.013     1.858     0.200
    24.041     1.330     0.200
    24.070     1.559     0.200
    24.090     1.777     0.200
    24.219     0.799     0.200
    24.223     1.055     0.200
    24.206     1.431     0.200
    24.235     1.951     0.200
    24.249     1.658     0.200
    24.297     1.845     0.200
    24.335     2.371     0.200
    24.411     2.378     0.200
    24.444     1.440     0.200
    24.437     2.140     0.200
    24.435     2.092     0.200
    24.489    -0.152     0.200
    24.488    -0.382     0.200
    24.471     1.876     0.200
    24.508     1.198     0.200
    24.525     1.687     0.200
    24.713    -1.874     0.200
    24.648     2.649     0.200
    24.709     1.576     0.200
    24.709     2.355     0.200
    24.733     1.670     0.200
    24.767     0.561     0.200
    24.751     2.426     0.200
    24.751     1.856     0.200
    24.813     1.902     0.200
    24.944    -1.128     0.200
    24.944    -1.878     0.200
    24.982    -0.636     0.200
    24.937     2.056     0.200
    24.950     1.498     0.200
    25.062     2.722     0.200
    25.099     2.803     0.200
    25.157     1.576     0.200
    25.164     1.238     0.200
    25.293     0.398     0.200
    25.282     1.564     0.200
    25.406    -0.786     0.200
    25.315     1.940     0.200
    25.372     0.825     0.200
    25.403     0.097     0.200
    25.367     2.424     0.200
    25.380     2.655     0.200
    25.410     1.917     0.200
    25.516    -1.407     0.200
    25.486     1.747     0.200
    25.573    -0.876     0.200
    25.526     2.102     0.200
    25.625    -0.317     0.200
    25.521     1.700     0.200
    25.581     2.164     0.200
    25.607     2.652     0.200
    25.646     0.043     0.200
    25.601     2.271     0.200
    25.690     2.398     0.200
    25.700     2.346     0.200
    25.801    -1.157     0.200
    25.723     2.777     0.200
    25.826    -1.195     0.200
    25.826     0.348     0.200
    25.839     2.296     0.200
    25.961     0.920     0.200
    26.005     0.876     0.200
    26.074     2.019     0.200
    26.082     2.775     0.200
    26.113     2.714     0.200
    26.113     2.505     0.200
    26.145     2.899     0.200
    26.319     0.595     0.200
    26.319     1.331     0.200
    26.343     1.850     0.200
    26.302     1.909     0.200
    26.378     0.434     0.200
    26.412     1.292     0.200
    26.400     2.708     0.200
    26.482    -1.089     0.200
    26.495     2.241     0.200
    26.571     1.697     0.200
    26.576     0.991     0.200
    26.615     1.559     0.200
    26.597     2.105     0.200
    26.647     1.905     0.200
    26.667     2.138     0.200
    26.752    -0.660     0.200
    26.733     1.069     0.200
    26.819     1.675     0.200
    26.894    -0.280     0.200
    26.822     1.542     0.200
    26.885     3.354     0.200
    26.927     1.517     0.200
    26.923     2.180     0.200
    26.918     2.894     0.200
    26.980     1.852     0.200
    26.980     1.965     0.200
    26.996     0.197     0.200
    26.996     0.312     0.200
    27.111     1.827     0.200
    27.188     1.618     0.200
    27.191     1.745     0.200
    27.354     1.035     0.200
    27.317     0.970     0.200
    27.330     2.449     0.200
    27.336     2.705     0.200
    27.463    -0.481     0.200
    27.460     1.506     0.200
    27.602    -0.272     0.200
    27.564     1.429     0.200
    27.564     1.333     0.200
    27.577     1.837     0.200
    27.772     0.466     0.200
    27.691     1.318     0.200
    27.731     0.930     0.200
    27.808    -0.438     0.200
    27.764     0.641     0.200
    27.792     0.681     0.200
    27.825     0.915     0.200
    27.822     2.428     0.200
    27.904     2.088     0.200
    27.909     1.534     0.200
    27.973     0.679     0.200
    27.935     1.456     0.200
    27.952    -0.065     0.200
    27.952     0.795     0.200
    27.971     0.792     0.200
    27.999     0.642     0.200
    28.025    -1.275     0.200
    28.161     0.785     0.200
    28.209     2.290     0.200
    28.182     1.401     0.200
    28.314     0.880     0.200
    28.368     0.745     0.200
    28.362     0.288     0.200
    28.388     1.997     0.200
    28.466     0.829     0.200
    28.504     1.241     0.200
    28.533     0.653     0.200
    28.534     0.394     0.200
    28.575     0.732     0.200
    28.588     0.353     0.200
    28.624     1.057     0.200
    28.707    -0.418     0.200
    28.707     1.427     0.200
    28.761     0.483     0.200
    28.735     1.654     0.200
    28.828     0.582     0.200
    28.849     1.100     0.200
    28.945     0.619     0.200
    28.946     0.009     0.200
    29.057     2.549     0.200
    29.115     1.192     0.200
    29.155    -0.046     0.200
    29.182     0.296     0.200
    29.295    -1.007     0.200
    29.252     0.359     0.200
    29.233     1.369     0.200
    29.305     0.775     0.200
    29.318     0.290     0.200
    29.340     0.513     0.200
    29.336     0.921     0.200
    29.337     0.573     0.200
    29.395     0.654     0.200
    29.422     1.162     0.200
    29.422     0.613     0.200
    29.538     0.673     0.200
    29.628    -1.402     0.200
    29.622    -0.043     0.200
    29.615     0.874     0.200
    29.602     2.851     0.200
    29.613     1.519     0.200
    29.622     2.018     0.200
    29.666     0.053     0.200
    29.621     2.240     0.200
    29.684    -0.321     0.200
    29.754    -0.304     0.200
    29.766    -0.714     0.200
    29.873     0.440     0.200
    29.948     1.277     0.200
    30.057    -0.228     0.200
    30.039     1.072     0.200
    30.099     0.259     0.200
    30.109    -0.576     0.200
    30.143     1.113     0.200
    30.171     0.828     0.200
    30.198     0.716     0.200
    30.223     1.664     0.200
    30.333    -0.820     0.200
    30.342     1.961     0.200
    30.375     0.687     0.200
    30.386    -0.628     0.200
    30.409     0.595     0.200
    30.439    -0.209     0.200
    30.441     1.550     0.200
    30.441     1.370     0.200
    30.461     0.060     0.200
    30.474     3.986     0.200
    30.507     1.504     0.200
    30.584     0.698     0.200
    30.648    -0.327     0.200
    30.718    -2.124     0.200
    30.716     0.137     0.200
    30.732     1.349     0.200
    30.828    -0.015     0.200
    30.838     0.362     0.200
    30.821     1.893     0.200
    30.988    -1.359     0.200
    31.009     1.360     0.200
    31.031     0.599     0.200
    31.105     1.885     0.200
    31.151     0.834     0.200
    31.178     1.410     0.200
    31.134     3.522     0.200
    31.219     4.633     0.200
    31.269     1.855     0.200
    31.297     1.047     0.200
    31.307     0.926     0.200
    31.343     0.798     0.200
    31.414    -1.542     0.200
    31.385     0.544     0.200
    31.385     1.219     0.200
    31.398     4.623     0.200
    31.412     1.217     0.200
    31.389     3.917     0.200
    31.445     0.196     0.200
    31.452     2.893     0.200
    31.521     0.298     0.200
    31.614     3.815     0.200
    31.609     1.325     0.200
    31.627     0.741     0.200
    31.618     1.783     0.200
    31.631     2.984     0.200
    31.739     1.595     0.200
    31.768     0.800     0.200
    31.823     0.673     0.200
    31.818     0.757     0.200
    31.812     1.706     0.200
    31.860     1.680     0.200
    32.022     1.545     0.200
    32.118     0.913     0.200
    32.113     1.640     0.200
    32.158     0.071     0.200
    32.216    -1.786     0.200
    32.216    -1.616     0.200
    32.140     3.991     0.200
    32.140     5.028     0.200
    32.199     1.287     0.200
    32.269     1.021     0.200
    32.338     0.667     0.200
    32.406     3.769     0.200
    32.442     0.381     0.200
    32.458     0.561     0.200
    32.627     0.313     0.200
    32.652     0.688     0.200
    32.657     0.953     0.200
    32.648     3.057     0.200
    32.790     3.389     0.200
    32.834     0.698     0.200
    32.966     0.461     0.200
    32.966     0.502     0.200
    32.966     0.527     0.200
    33.057     0.338     0.200
    33.318     0.774     0.200
    33.490    -1.007     0.200
    33.461     0.454     0.200
    33.569     0.791     0.200
    33.583     0.912     0.200
    33.613     0.463     0.200
    33.646     1.820     0.200
    33.785     1.677     0.200
    33.875     2.532     0.200
    35.041     1.153     0.200
    35.252    -0.684     0.200
    35.573    -1.227     0.200
    36.055    -1.574     0.200
    36.218     1.928     0.200
    36.218     0.439     0.200
    36.267     0.751     0.200
    36.553     1.058     0.200
    37.893    -0.318     0.200
    38.796     1.714     0.200
    40.131     1.492     0.200
    40.189     0.827     0.200
    40.413     0.834     0.200
    40.587     0.930     0.200
    40.732    -1.303     0.200
    40.616     2.331     0.200
    40.886     1.047     0.200
    41.061    -0.113     0.200
    44.044     1.690     0.200
    44.416    -1.583     0.200
    44.483    -0.974     0.200
    44.831     2.058     0.200
    45.921    -1.355     0.200
    45.921    -1.891     0.200
    46.585     1.089     0.200
    49.586     2.002     0.200
    49.586     1.723     0.200
    51.213     1.337     0.200
    51.264     0.852     0.200
    51.567     1.316     0.200
    51.927     1.761     0.200
    52.312     0.204     0.200
    52.767     1.899     0.200
    52.984     0.102     0.200
    52.964     1.369     0.200
    53.031     1.274     0.200
    53.031     1.005     0.200
    53.161     1.018     0.200
    53.161     0.817     0.200
    53.525     3.426     0.200
    54.282     0.810     0.200
    54.282     0.649     0.200
    54.563     0.265     0.200
    54.563    -0.154     0.200
    55.621     0.428     0.200
    56.287    -1.141     0.200
    56.287    -2.061     0.200
    57.255    -0.291     0.200
    57.377     0.958     0.200
    58.914     1.284     0.200
    62.418     0.484     0.200
    65.930    -1.344     0.200
    68.897     1.357     0.200
    70.946    -0.604     0.200
    71.451     2.334     0.200
    72.665     1.164     0.200
    72.665     0.865     0.200
    76.632     2.265     0.200
    76.632     1.534     0.200
    77.773     0.419     0.200
    78.792     1.578     0.200
    78.971     0.852     0.200
    79.106     0.602     0.200
    79.129     0.499     0.200
    79.246     0.636     0.200
    79.290     2.687     0.200
    79.599     0.715     0.200
    79.605     0.860     0.200
    79.559     1.231     0.200
    79.568     1.283     0.200
    79.568     1.734     0.200
    79.688     0.631     0.200
    79.735     0.694     0.200
    79.792     0.826     0.200
    79.837     0.822     0.200
    79.903     0.683     0.200
    80.012     0.427     0.200
    80.032     0.516     0.200
    80.054     0.857     0.200
    80.127     1.204     0.200
    80.229     0.784     0.200
    80.280     1.690     0.200
    80.363     0.741     0.200
    80.478     1.097     0.200
    80.597     0.947     0.200
    80.651     0.844     0.200
    80.710     1.040     0.200
    80.795     0.799     0.200
    80.820     0.702     0.200
    80.836     1.008     0.200
    80.902     0.594     0.200
    80.902     0.844     0.200
    80.902     1.094     0.200
    80.989    -0.061     0.200
    80.992     0.586     0.200
    81.015     1.152     0.200
    81.178     1.524     0.200
    81.354     0.740     0.200
    81.375     1.779     0.200
    81.495     1.342     0.200
    81.593     1.198     0.200
    81.511     0.959     0.200
    81.604     1.467     0.200
    81.683     0.599     0.200
    81.987     0.611     0.200
    82.032     0.827     0.200
    82.122     0.523     0.200
    82.143     0.711     0.200
    82.144     1.328     0.200
    82.262     1.406     0.200
    82.338     0.933     0.200
    82.448     1.140     0.200
    82.540     1.437     0.200
    82.579     1.556     0.200
    82.607     1.269     0.200
    82.624     0.917     0.200
    82.636     1.758     0.200
    82.970     2.423     0.200
    82.992     1.510     0.200
    83.010     1.593     0.200
    83.065     1.691     0.200
    83.106     1.119     0.200
    83.169     2.115     0.200
    83.202     1.024     0.200
    83.219     0.937     0.200
    83.243     1.014     0.200
    83.304    -0.002     0.200
    83.427     1.164     0.200
    83.457     1.210     0.200
    83.487     1.354     0.200
    83.685     1.447     0.200
    83.720     0.960     0.200
    83.890     1.122     0.200
    83.902     0.309     0.200
    83.932     1.626     0.200
    84.172     1.319     0.200
    84.328     0.858     0.200
    84.465     1.698     0.200
    84.726     1.348     0.200
    84.816     1.496     0.200
    84.927     1.225     0.200
    85.138    -1.309     0.200
    85.138     0.769     0.200
    85.247     3.131     0.200
    85.334     2.002     0.200
    85.377     2.045     0.200
    85.366     0.340     0.200
    85.404     0.148     0.200
    85.404     0.447     0.200
    85.408     1.270     0.200
    85.408     0.930     0.200
    85.576     1.610     0.200
    85.576     1.392     0.200
    85.784     1.859     0.200
    85.810     1.319     0.200
    85.810     0.821     0.200
    85.811     2.526     0.200
    85.853     1.218     0.200
    85.888     1.523     0.200
    86.244     1.909     0.200
    86.250     1.858     0.200
    86.299     1.586     0.200
    86.330     1.761     0.200
    86.473     1.959     0.200
    86.475     1.351     0.200
    86.561     2.030     0.200
    86.664     1.221     0.200
    86.758     2.364     0.200
    86.781     1.049     0.200
    86.854     0.275     0.200
    86.866     1.938     0.200
    86.924    -1.232     0.200
    86.936     0.384     0.200
    86.952     2.017     0.200
    87.008     0.743     0.200
    87.075     0.320     0.200
    87.087     0.358     0.200
    87.130     1.661     0.200
    87.233     1.531     0.200
    87.242     1.608     0.200
    87.296     0.836     0.200
    87.334     0.165     0.200
    87.379     1.246     0.200
    87.379     1.047     0.200
    87.409     1.600     0.200
    87.425     0.420     0.200
    87.432     0.091     0.200
    87.472    -0.204     0.200
    87.478     1.765     0.200
    87.523     1.561     0.200
    87.565     0.349     0.200
    87.567     1.240     0.200
    87.594     2.742     0.200
    87.652     1.634     0.200
    87.695     0.587     0.200
    87.730     0.593     0.200
    87.760    -0.184     0.200
    87.763     0.401     0.200
    87.876    -0.537     0.200
    87.933     1.551     0.200
    87.941     0.158     0.200
    87.957    -0.321     0.200
    87.977    -0.619     0.200
    88.046     1.567     0.200
    88.057     0.705     0.200
    88.070     0.841     0.200
    88.075     1.120     0.200
    88.086     0.068     0.200
    88.102     0.894     0.200
    88.200     0.629     0.200
    88.201     0.020     0.200
    88.245     1.414     0.200
    88.268     0.106     0.200
    88.343    -0.451     0.200
    88.378     1.232     0.200
    88.390     0.826     0.200
    88.461     1.423     0.200
    88.496     0.327     0.200
    88.573     0.463     0.200
    88.566     1.897     0.200
    88.611    -1.013     0.200
    88.611    -0.615     0.200
    88.695     0.189     0.200
    88.734     0.088     0.200
    88.737     0.874     0.200
    88.816     1.001     0.200
    88.867     2.091     0.200
    88.879     0.523     0.200
    88.896     1.445     0.200
    88.948     0.998     0.200
    89.090     1.431     0.200
    89.076     1.000     0.200
    89.076     0.699     0.200
    89.222    -0.589     0.200
    89.265     0.011     0.200
    89.437     0.805     0.200
    89.462     0.388     0.200
    89.516     1.204     0.200
    89.623     0.836     0.200
    89.626     0.020     0.200
    89.647     0.221     0.200
    89.649     0.715     0.200
    89.654    -0.110     0.200
    89.666     1.133     0.200
    89.671     0.910     0.200
    89.693     1.009     0.200
    89.746     0.059     0.200
    89.804     0.686     0.200
    89.832     1.459     0.200
    89.855     0.651     0.200
    89.862     1.178     0.200
    89.938     1.162     0.200
    90.283     0.154     0.200
    90.309    -0.071     0.200
    90.387     0.169     0.200
    90.502     1.032     0.200
    90.570     0.515     0.200
    90.648     0.852     0.200
    90.669     0.958     0.200
    90.829     0.410     0.200
    90.882    -1.094     0.200
    90.882    -1.025     0.200
    90.978     0.219     0.200
    90.978     0.920     0.200
    91.039     0.438     0.200
    91.143    -0.045     0.200
    91.255     1.237     0.200
    91.255     1.235     0.200
    91.255     1.235     0.200
    91.372     0.091     0.200
    91.372    -0.010     0.200
    91.457     0.699     0.200
    91.359     0.951     0.200
    91.499     0.006     0.200
    91.514    -0.066     0.200
    91.515     0.828     0.200
    91.558     0.828     0.200
    91.580     1.030     0.200
    91.592     0.972     0.200
    91.647     0.715     0.200
    91.667     0.623     0.200
    91.674     1.094     0.200
    91.706     1.016     0.200
    91.762     1.087     0.200
    91.767     0.461     0.200
    91.793     0.943     0.200
    91.863    -0.183     0.200
    91.878     0.548     0.200
    91.882     0.731     0.200
    92.073     0.748     0.200
    92.106     0.392     0.200
    92.106     0.033     0.200
    92.395     1.271     0.200
    92.434    -0.121     0.200
    92.464     1.143     0.200
    92.520     1.271     0.200
    92.629     0.478     0.200
    92.675     1.898     0.200
    92.747     1.473     0.200
    92.810    -0.856     0.200
    92.858     0.721     0.200
    92.845     1.283     0.200
    93.082     0.791     0.200
    93.082     0.078     0.200
    93.357     0.520     0.200
    93.403     0.712     0.200
    93.497    -0.220     0.200
    93.506     2.133     0.200
    93.655     0.548     0.200
    93.835     1.073     0.200
    93.848     1.559     0.200
    93.941     0.885     0.200
    94.399     1.032     0.200
    94.521     0.191     0.200
    94.629     0.876     0.200
    94.629     1.475     0.200
    94.629     0.136     0.200
    94.738    -0.024     0.200
    94.789     1.194     0.200
    94.839     0.648     0.200
    94.910     0.293     0.200
    94.982     0.628     0.200
    94.950     0.406     0.200
    95.082     0.641     0.200
    95.095     0.334     0.200
    95.309     1.468     0.200
    95.314     0.841     0.200
    95.317     1.229     0.200
    95.743     0.648     0.200
    95.803     0.931     0.200
    95.847     0.432     0.200
    96.075     0.776     0.200
    96.582     0.872     0.200
    96.761     0.461     0.200
    96.783     1.365     0.200
    96.952     0.897     0.200
    96.987     1.639     0.200
    96.987     1.488     0.200
    96.987     1.340     0.200
    97.030     0.692     0.200
    97.518    -0.261     0.200
    97.891    -0.238     0.200
    99.576    -0.463     0.200
    17.006     0.776     0.200
    17.112     2.552     0.200
    17.112     2.872     0.200
    18.397     0.114     0.200
    19.113     0.041     0.200
    19.211    -0.377     0.200
    20.642    -0.575     0.200
    20.857    -0.453     0.200
    21.158     2.711     0.200
    21.336    -0.233     0.200
    21.393    -1.584     0.200
    21.481     3.305     0.200
    21.662    -0.581     0.200
    21.719     3.291     0.200
    21.788    -0.145     0.200
    21.852     1.294     0.200
    21.928     2.398     0.200
    21.999     0.425     0.200
    22.093    -1.365     0.200
    22.189     1.945     0.200
    22.321     2.131     0.200
    22.358     2.019     0.200
    22.373    -0.959     0.200
    22.387    -2.016     0.200
    22.647    -1.162     0.200
    22.778    -2.068     0.200
    22.955    -0.905     0.200
    23.147     1.561     0.200
    23.168    -1.738     0.200
    23.218     1.557     0.200
    23.265    -0.384     0.200
    23.642     0.400     0.200
    23.640     1.989     0.200
    23.663     1.579     0.200
    23.779    -2.591     0.200
    23.809     0.570     0.200
    23.836    -0.570     0.200
    23.889    -1.500     0.200
    23.859     5.450     0.200
    24.348     2.259     0.200
    24.374    -1.579     0.200
    24.397     0.519     0.200
    24.614     1.133     0.200
    24.778    -1.430     0.200
    25.096    -2.270     0.200
    25.105     0.551     0.200
    25.104     1.144     0.200
    25.268    -0.041     0.200
    25.292    -1.440     0.200
    25.390    -1.867     0.200
    25.769     1.667     0.200
    25.996    -0.204     0.200
    26.105     0.183     0.200
    26.133    -0.804     0.200
    26.179     0.720     0.200
    26.248     1.066     0.200
    26.451     0.096     0.200
    26.634     0.565     0.200
    26.761     0.560     0.200
    26.995    -1.908     0.200
    27.142     2.066     0.200
    27.164     0.682     0.200
    27.222     0.741     0.200
    27.377     1.130     0.200
    27.447    -1.878     0.200
    27.501    -0.605     0.200
    27.630     1.770     0.200
    27.745     1.289     0.200
    27.985    -1.455     0.200
    28.023     2.196     0.200
    28.032     1.507     0.200
    28.217     0.777     0.200
    28.399     1.005     0.200
    28.403     1.001     0.200
    29.187    -1.510     0.200
    29.183     4.207     0.200
    29.310     0.444     0.200
    29.901     0.533     0.200
    29.908     1.337     0.200
    29.917     1.478     0.200
    29.969     0.646     0.200
    29.958     2.059     0.200
    30.014     0.407     0.200
    30.103     4.278     0.200
    30.231     0.752     0.200
    30.265     1.520     0.200
    30.270     1.871     0.200
    30.263     2.024     0.200
    30.278     1.161     0.200
    30.292    -0.024     0.200
    30.347     0.189     0.200
    30.341     1.356     0.200
    30.319     3.573     0.200
    30.405     0.162     0.200
    30.405     0.869     0.200
    30.478     0.638     0.200
    30.474     1.719     0.200
    30.481     2.429     0.200
    30.524     1.538     0.200
    30.571     1.836     0.200
    30.696    -1.056     0.200
    30.692     1.854     0.200
    30.876     2.082     0.200
    30.847     5.246     0.200
    30.902     1.858     0.200
    31.012     2.280     0.200
    31.051     0.527     0.200
    31.076     1.646     0.200
    31.157     1.722     0.200
    31.183     2.631     0.200
    31.226    -1.826     0.200
    31.123     3.951     0.200
    31.244     1.829     0.200
    31.294     1.946     0.200
    31.372     2.306     0.200
    31.351     3.731     0.200
    31.560     1.653     0.200
    31.616     1.736     0.200
    31.685     2.129     0.200
    31.738     2.512     0.200
    31.826     2.533     0.200
    32.052     1.613     0.200
    32.093     2.566     0.200
    32.171     1.072     0.200
    32.182    -0.023     0.200
    32.245     2.508     0.200
    32.412     2.317     0.200
    32.486     1.352     0.200
    32.599    -2.048     0.200
    32.599    -1.618     0.200
    32.586     1.733     0.200
    32.655     2.448     0.200
    32.682     2.427     0.200
    32.618     2.325     0.200
    32.724     1.451     0.200
    32.731     1.273     0.200
    33.052     0.912     0.200
    33.140     2.285     0.200
    33.320     1.584     0.200
    33.355     1.246     0.200
    33.437     3.545     0.200
    33.812     1.495     0.200
    33.825     1.131     0.200
    33.835     1.092     0.200
    33.932     1.535     0.200
    33.937     1.726     0.200
    33.945     1.056     0.200
    34.321     2.067     0.200
    34.551     1.776     0.200
    34.552     1.635     0.200
    34.886     0.199     0.200
    35.116    -0.975     0.200
    36.023    -0.949     0.200
    36.599    -1.089     0.200
    41.151    -1.379     0.200
    44.975     1.916     0.200
    45.134    -1.503     0.200
    45.865    -1.717     0.200
    45.865    -0.971     0.200
    48.340     1.510     0.200
    48.340     0.565     0.200
    52.189     0.598     0.200
    53.238     0.631     0.200
    53.812    -0.116     0.200
    54.066     1.117     0.200
    54.175     0.685     0.200
    55.264     0.974     0.200
    55.522     0.110     0.200
    56.668     0.140     0.200
    56.806    -1.772     0.200
    57.641    -0.093     0.200
    58.220    -0.477     0.200
    63.430     0.714     0.200
    63.590     1.223     0.200
    64.605     0.449     0.200
    65.764     1.463     0.200
    66.021    -0.889     0.200
    67.767     0.262     0.200
    73.650     0.792     0.200
    73.650     1.132     0.200
    80.596     1.309     0.200
    80.712     0.690     0.200
    81.020     1.284     0.200
    81.656     0.954     0.200
    81.877     1.035     0.200
    82.108     1.293     0.200
    82.456     0.973     0.200
    82.586     0.993     0.200
    82.602     1.407     0.200
    82.659     0.615     0.200
    82.670     1.357     0.200
    82.875     1.589     0.200
    82.904     1.037     0.200
    83.110     0.271     0.200
    83.101     2.318     0.200
    83.383     1.062     0.200
    83.496     1.385     0.200
    83.896     1.543     0.200
    83.928    -0.458     0.200
    84.401     1.464     0.200
    84.501     1.458     0.200
    84.784     1.527     0.200
    84.796     1.791     0.200
    84.835     1.734     0.200
    85.055     1.347     0.200
    85.293     1.439     0.200
    85.293     0.564     0.200
    85.334     1.883     0.200
    85.339     1.508     0.200
    85.372     0.333     0.200
    85.370     1.191     0.200
    85.404     0.525     0.200
    85.404     0.525     0.200
    85.496     0.965     0.200
    85.811     0.970     0.200
    85.928     1.668     0.200
    85.994     2.331     0.200
    86.041     0.757     0.200
    86.275     1.595     0.200
    86.299     2.329     0.200
    86.391     2.361     0.200
    86.574     1.633     0.200
    86.582     2.967     0.200
    86.689     0.672     0.200
    86.713     1.913     0.200
    86.826     1.403     0.200
    87.058     0.270     0.200
    87.122     0.158     0.200
    87.133     1.745     0.200
    87.168     0.536     0.200
    87.491     1.425     0.200
    87.563     2.088     0.200
    87.631    -0.099     0.200
    87.766     0.157     0.200
    88.287     0.581     0.200
    89.285     0.384     0.200
    89.351     0.074     0.200
    89.364     0.614     0.200
    90.034     0.481     0.200
    90.047    -0.080     0.200
    90.245     0.299     0.200
    90.313     0.982     0.200
    90.333     0.888     0.200
    90.612    -1.714     0.200
    90.985    -0.269     0.200
    91.033     0.833     0.200
    91.033     0.833     0.200
    91.125     0.504     0.200
    91.194     0.282     0.200
    91.694    -2.532     0.200
    91.927     0.586     0.200
    92.537     0.480     0.200
    92.537     0.968     0.200
    92.643     0.578     0.200
    92.722     0.315     0.200
    92.862     0.955     0.200
    93.485     0.798     0.200
    95.113     1.725     0.200
    95.518     0.276     0.200
    95.536     0.395     0.200
    95.536     0.868     0.200
    95.892     1.072     0.200
    96.086     0.591     0.200
    96.616     1.381     0.200
    96.783     0.925     0.200
    96.803     1.934     0.200
    97.044     1.445     0.200
    99.420    -0.965     0.200
    15.430     4.898     0.200
    15.752     4.415     0.200
    16.193     5.759     0.200
    18.886     1.220     0.200
    18.963    -0.696     0.200
    20.252    -0.571     0.200
    20.432     2.465     0.200
    20.853     1.595     0.200
    20.937     2.951     0.200
    20.978     1.338     0.200
    21.000     2.344     0.200
    21.415    -1.656     0.200
    22.155    -0.110     0.200
    22.388     1.721     0.200
    22.596     1.091     0.200
    23.148     1.675     0.200
    23.334    -0.619     0.200
    25.210     1.803     0.200
    30.776    -2.159     0.200
    44.235    -0.242     0.200
    45.707    -1.647     0.200
    52.817    -1.036     0.200
    82.915    -1.130     0.200
    84.927    -0.674     0.200
    13.982     7.136     0.200
    13.983     7.079     0.200
    14.615     6.010     0.200
    14.795     6.464     0.200
    15.020     4.388     0.200
    15.182     4.938     0.200
    15.224     6.846     0.200
    15.242     4.918     0.200
    15.265     4.573     0.200
    15.304     6.160     0.200
    15.663     5.333     0.200
    15.653     3.768     0.200
    15.886     4.279     0.200
    15.891     5.116     0.200
    16.149     3.423     0.200
    16.212     2.840     0.200
    16.280     3.538     0.200
    16.326     3.257     0.200
    16.547     4.721     0.200
    16.547     3.699     0.200
    16.677     3.299     0.200
    16.727     2.983     0.200
    17.131     2.617     0.200
    17.154     2.777     0.200
    17.465     2.329     0.200
    17.570     1.360     0.200
    17.741     0.828     0.200
    17.790     1.528     0.200
    17.859     0.745     0.200
    17.873    -0.325     0.200
    17.908     1.802     0.200
    18.011     1.834     0.200
    18.112     2.040     0.200
    18.352     1.884     0.200
    18.447     2.253     0.200
    18.476     0.955     0.200
    18.533     0.510     0.200
    18.641     1.794     0.200
    18.732     2.064     0.200
    18.751     2.105     0.200
    18.824     2.696     0.200
    18.893     2.341     0.200
    18.908     2.164     0.200
    18.981     2.384     0.200
    18.997     0.936     0.200
    19.038     1.306     0.200
    19.145     2.201     0.200
    19.157     2.288     0.200
    19.171     2.039     0.200
    19.228     2.538     0.200
    19.228     2.087     0.200
    19.345     1.561     0.200
    19.421     1.534     0.200
    19.563     2.793     0.200
    19.566     2.338     0.200
    19.615     1.254     0.200
    19.709     1.550     0.200
    19.755     2.706     0.200
    19.782     2.359     0.200
    19.805     1.755     0.200
    19.806     1.833     0.200
    19.839    -0.465     0.200
    19.900     2.428     0.200
    19.973     1.887     0.200
    20.046     1.730     0.200
    20.058     1.271     0.200
    20.072     1.536     0.200
    20.120     1.905     0.200
    20.154     2.251     0.200
    20.203    -0.239     0.200
    20.222     2.671     0.200
    20.235     0.921     0.200
    20.284     0.352     0.200
    20.354     1.225     0.200
    20.368     1.142     0.200
    20.409     2.228     0.200
    20.421     2.311     0.200
    20.451     0.992     0.200
    20.482     1.212     0.200
    20.601     1.301     0.200
    20.682     2.143     0.200
    20.682     2.548     0.200
    20.713     2.334     0.200
    20.769     2.293     0.200
    20.779     1.503     0.200
    20.853     0.758     0.200
    21.177     2.153     0.200
    21.193     2.579     0.200
    21.216     0.997     0.200
    21.286     1.855     0.200
    21.338     1.080     0.200
    21.390     1.780     0.200
    21.448     1.532     0.200
    21.448     1.953     0.200
    21.449     0.910     0.200
    21.606     1.442     0.200
    21.617     1.966     0.200
    21.678     0.179     0.200
    21.739     0.527     0.200
    21.811     1.927     0.200
    21.845     1.268     0.200
    21.848    -0.460     0.200
    21.857     3.956     0.200
    21.862     1.681     0.200
    22.128    -0.765     0.200
    22.193     2.187     0.200
    22.242     0.973     0.200
    22.322    -1.458     0.200
    22.329     2.762     0.200
    22.435     1.780     0.200
    22.522     1.091     0.200
    22.543     1.450     0.200
    22.641     1.218     0.200
    22.661     0.911     0.200
    22.758    -1.352     0.200
    22.806     1.572     0.200
    22.826    -0.231     0.200
    22.863     1.082     0.200
    22.872     1.139     0.200
    23.123     0.161     0.200
    23.123     1.736     0.200
    23.224     1.165     0.200
    23.333    -1.684     0.200
    23.789    -0.398     0.200
    23.838    -0.012     0.200
    23.857     2.254     0.200
    23.931    -1.095     0.200
    23.931    -1.340     0.200
    24.289    -1.269     0.200
    24.384    -0.929     0.200
    24.453     2.520     0.200
    24.480    -0.775     0.200
    24.483     2.865     0.200
    24.706     0.123     0.200
    24.706     1.242     0.200
    24.767    -0.621     0.200
    24.892    -1.246     0.200
    24.923     0.590     0.200
    25.326     0.521     0.200
    25.565    -0.605     0.200
    25.690     1.233     0.200
    25.731     0.684     0.200
    25.965     0.059     0.200
    26.454     0.116     0.200
    26.615     0.771     0.200
    27.531     1.943     0.200
    27.844    -0.222     0.200
    27.844     0.868     0.200
    27.934     0.999     0.200
    28.022    -0.492     0.200
    28.242     0.834     0.200
    28.270    -0.104     0.200
    28.514    -0.343     0.200
    28.686    -0.961     0.200
    28.689     0.035     0.200
    28.854    -0.532     0.200
    28.921    -0.303     0.200
    29.039    -0.376     0.200
    29.148    -0.633     0.200
    29.253    -0.667     0.200
    30.126    -0.643     0.200
    30.163     4.110     0.200
    30.668    -1.654     0.200
    30.883    -0.570     0.200
    32.028    -1.077     0.200
    32.733     2.129     0.200
    34.822     0.300     0.200
    35.388     0.373     0.200
    44.564    -0.915     0.200
    45.355    -1.527     0.200
    48.727     1.877     0.200
    52.698     0.593     0.200
    53.359     1.158     0.200
    54.595     0.413     0.200
    55.095     0.986     0.200
    62.888     1.013     0.200
    80.798     1.658     0.200
    82.297    -0.530     0.200
    82.676     0.999     0.200
    84.057     0.502     0.200
    84.341     0.963     0.200
    84.816     0.295     0.200
    84.816     0.320     0.200
    84.884     0.727     0.200
    84.884     1.252     0.200
    84.916     0.719     0.200
    85.065     0.023     0.200
    85.635     0.183     0.200
    86.168     0.649     0.200
    86.267     0.362     0.200
    86.367     1.071     0.200
    86.632     0.272     0.200
    86.689    -0.105     0.200
    86.730     0.395     0.200
    86.984     0.760     0.200
    87.191    -0.143     0.200
    87.324    -0.587     0.200
    87.873     0.493     0.200
    88.656    -0.109     0.200
    88.856     0.752     0.200
    90.255     0.506     0.200
    90.447    -0.588     0.200
    14.683     5.915     0.200
    14.990     4.313     0.200
    15.055     5.118     0.200
    15.241     3.877     0.200
    15.306     4.592     0.200
    15.376     4.210     0.200
    15.484     6.937     0.200
    15.507     6.413     0.200
    15.583     5.013     0.200
    15.726     5.400     0.200
    15.872     3.891     0.200
    15.925     4.540     0.200
    15.946     6.148     0.200
    15.951     3.526     0.200
    16.010     5.353     0.200
    16.018     5.900     0.200
    16.103     3.849     0.200
    16.204     3.773     0.200
    16.383     5.093     0.200
    16.631     3.752     0.200
    16.700     3.554     0.200
    17.003     3.317     0.200
    17.096     5.466     0.200
    17.263     2.792     0.200
    17.263     3.318     0.200
    17.317     3.109     0.200
    17.330     3.944     0.200
    17.364     3.594     0.200
    17.421     4.629     0.200
    17.450     4.515     0.200
    17.856     2.444     0.200
    17.882     5.916     0.200
    17.901     3.755     0.200
    17.999     3.306     0.200
    18.185     3.803     0.200
    18.396     0.798     0.200
    18.441     1.282     0.200
    18.886    -1.233     0.200
    19.608     1.916     0.200
    20.059     0.865     0.200
    20.144     1.136     0.200
    20.149     2.058     0.200
    20.171     0.646     0.200
    20.258     0.303     0.200
    20.285     0.278     0.200
    20.319     0.994     0.200
    20.355     2.068     0.200
    20.429     1.030     0.200
    20.527     2.204     0.200
    20.696     2.021     0.200
    20.778     0.252     0.200
    20.877     0.468     0.200
    20.938    -1.375     0.200
    20.938    -1.244     0.200
    20.982     0.860     0.200
    21.035     4.430     0.200
    21.075     0.692     0.200
    21.164     2.687     0.200
    21.206     2.314     0.200
    21.323     1.104     0.200
    21.482     1.142     0.200
    21.577     1.571     0.200
    21.714     0.555     0.200
    21.860     1.133     0.200
    21.874     2.612     0.200
    21.896     2.576     0.200
    21.914     3.522     0.200
    21.922     1.719     0.200
    22.060     1.271     0.200
    22.171     2.013     0.200
    22.293     0.976     0.200
    22.317     2.761     0.200
    22.361     0.607     0.200
    22.388    -0.383     0.200
    22.459     3.025     0.200
    22.549     3.161     0.200
    23.018     2.677     0.200
    23.259     1.180     0.200
    23.510    -0.244     0.200
    23.846     0.012     0.200
    24.303    -1.960     0.200
    24.565     2.152     0.200
    24.673    -0.244     0.200
    24.839    -0.557     0.200
    24.912    -0.862     0.200
    25.378    -0.279     0.200
    25.424    -0.343     0.200
    25.424    -0.216     0.200
    25.944    -1.358     0.200
    25.955     1.354     0.200
    26.103    -0.571     0.200
    26.237    -0.955     0.200
    26.327    -0.023     0.200
    26.688    -0.767     0.200
    26.917    -0.965     0.200
    27.633     1.102     0.200
    27.631     0.362     0.200
    28.067    -1.816     0.200
    28.128     2.913     0.200
    28.745    -0.040     0.200
    29.412    -0.783     0.200
    29.575    -2.036     0.200
    29.582    -0.956     0.200
    29.975    -0.859     0.200
    30.649    -0.549     0.200
    32.673    -2.010     0.200
    36.705    -1.462     0.200
    45.274    -1.793     0.200
    55.317    -0.010     0.200
    59.308     2.847     0.200
    81.485     0.598     0.200
    85.410     1.058     0.200
    13.824     4.361     0.200
    13.844     6.405     0.200
    14.234     4.253     0.200
    14.461     5.354     0.200
    14.605     5.649     0.200
    14.816     3.768     0.200
    14.929     3.207     0.200
    15.292     4.088     0.200
    15.420     3.344     0.200
    15.489     2.905     0.200
    15.517     4.636     0.200
    15.563     3.260     0.200
    15.597     4.072     0.200
    15.659     2.864     0.200
    15.763     3.757     0.200
    15.948     4.179     0.200
    16.113     2.870     0.200
    16.157     3.774     0.200
    16.287     3.808     0.200
    16.430     2.798     0.200
    16.585     3.890     0.200
    16.626     4.221     0.200
    16.646     2.875     0.200
    16.786     2.505     0.200
    16.823     4.198     0.200
    16.823     2.783     0.200
    16.823     3.472     0.200
    16.904     3.656     0.200
    16.919     3.599     0.200
    17.008     4.153     0.200
    17.023     3.190     0.200
    17.234     3.287     0.200
    17.277     2.012     0.200
    17.337     3.258     0.200
    17.423     1.385     0.200
    17.454     3.124     0.200
    17.452     2.496     0.200
    17.556     3.435     0.200
    17.783     3.199     0.200
    17.807     3.080     0.200
    17.847     2.193     0.200
    17.974    -0.694     0.200
    18.447    -1.462     0.200
    18.583     0.754     0.200
    18.646     0.806     0.200
    19.721     1.649     0.200
    19.805     1.276     0.200
    19.833     1.083     0.200
    19.871     1.746     0.200
    19.887    -0.801     0.200
    19.909     1.797     0.200
    20.208    -0.702     0.200
    20.457     1.790     0.200
    20.482     1.070     0.200
    20.485     0.116     0.200
    20.485     0.459     0.200
    20.529     0.891     0.200
    20.644     1.976     0.200
    20.895     2.135     0.200
    20.959    -1.344     0.200
    21.018     2.990     0.200
    21.039     1.511     0.200
    21.061     2.141     0.200
    21.073     1.096     0.200
    21.087     1.314     0.200
    21.153     2.691     0.200
    21.264     2.503     0.200
    21.275     2.120     0.200
    21.416     1.984     0.200
    21.453     3.381     0.200
    21.474     3.102     0.200
    21.474     2.414     0.200
    21.510     2.285     0.200
    21.624     2.604     0.200
    21.631     1.914     0.200
    21.698     2.015     0.200
    21.706     1.948     0.200
    21.744     2.061     0.200
    21.750     2.381     0.200
    21.914     1.774     0.200
    21.953     2.177     0.200
    21.943     1.511     0.200
    22.056     1.968     0.200
    22.196     2.560     0.200
    22.222    -0.875     0.200
    22.428     1.173     0.200
    22.466     0.935     0.200
    22.609     2.302     0.200
    22.593     1.454     0.200
    22.672     1.417     0.200
    22.816     1.556     0.200
    22.872     1.214     0.200
    22.986     0.750     0.200
    23.061     0.890     0.200
    23.109     0.986     0.200
    23.137    -0.387     0.200
    23.239    -0.892     0.200
    23.429     1.904     0.200
    23.476     0.616     0.200
    23.555     0.792     0.200
    23.697    -0.083     0.200
    23.770     0.695     0.200
    23.775    -0.225     0.200
    23.827     0.220     0.200
    23.940    -1.760     0.200
    24.189     2.296     0.200
    24.345    -1.533     0.200
    24.393    -0.035     0.200
    24.467    -0.114     0.200
    24.658     0.396     0.200
    24.768     1.825     0.200
    24.756     0.536     0.200
    24.869    -1.428     0.200
    24.907     0.428     0.200
    24.953     0.504     0.200
    24.987     0.371     0.200
    24.987     0.754     0.200
    24.999     0.521     0.200
    25.001     0.263     0.200
    25.140     0.160     0.200
    25.194    -0.110     0.200
    25.508     0.745     0.200
    25.583     1.352     0.200
    25.615     0.503     0.200
    25.624     0.579     0.200
    25.631     0.219     0.200
    25.681     0.875     0.200
    25.748    -0.557     0.200
    25.884     0.116     0.200
    25.929     0.177     0.200
    25.931     0.728     0.200
    25.937     0.818     0.200
    25.977     0.457     0.200
    26.016     1.092     0.200
    26.108     0.223     0.200
    26.295     0.433     0.200
    26.303     0.848     0.200
    26.404     0.246     0.200
    26.723     0.159     0.200
    27.139    -0.077     0.200
    27.197     0.067     0.200
    27.211     0.900     0.200
    27.209    -0.109     0.200
    27.450     0.395     0.200
    27.592     0.032     0.200
    27.677     0.604     0.200
    27.698     0.468     0.200
    27.699     0.120     0.200
    27.820     0.674     0.200
    28.045    -0.078     0.200
    28.129     0.883     0.200
    28.221     0.428     0.200
    28.245     0.519     0.200
    28.306     0.620     0.200
    28.320     0.935     0.200
    28.437     0.126     0.200
    28.558     0.668     0.200
    28.664    -0.065     0.200
    28.720     0.331     0.200
    28.794     0.154     0.200
    28.814    -0.137     0.200
    28.964    -0.213     0.200
    28.986    -0.269     0.200
    29.030     0.321     0.200
    29.138    -0.031     0.200
    29.143     0.632     0.200
    29.312     0.402     0.200
    29.342     0.430     0.200
    29.392    -0.012     0.200
    29.425    -0.482     0.200
    29.477     0.403     0.200
    29.559    -0.012     0.200
    29.697     0.583     0.200
    29.719     0.062     0.200
    29.902     0.183     0.200
    29.966     0.252     0.200
    30.013    -0.267     0.200
    30.042     0.423     0.200
    30.109    -0.281     0.200
    30.221     0.547     0.200
    30.252     0.232     0.200
    30.314    -0.660     0.200
    30.409     0.654     0.200
    30.410    -0.118     0.200
    30.473    -0.056     0.200
    30.544     0.010     0.200
    30.699    -0.226     0.200
    30.829    -0.195     0.200
    30.826    -1.833     0.200
    30.909    -0.020     0.200
    30.995    -0.223     0.200
    31.157    -0.176     0.200
    31.407     0.183     0.200
    31.575    -0.076     0.200
    31.720    -0.040     0.200
    31.914     0.249     0.200
    32.221    -1.485     0.200
    44.743     1.254     0.200
    44.829    -1.085     0.200
    45.437    -1.302     0.200
    47.460     0.089     0.200
    48.381     2.429     0.200
    51.954     0.588     0.200
    53.002     0.391     0.200
    53.301     1.041     0.200
    53.332     0.680     0.200
    53.541    -0.458     0.200
    54.905     0.257     0.200
    55.051     0.206     0.200
    55.412     0.300     0.200
    63.231     1.171     0.200
    64.913    -0.194     0.200
    70.824    -1.539     0.200
    81.138     1.645     0.200
    84.869     1.322     0.200
    84.968     0.418     0.200
    84.978     0.322     0.200
    84.978     0.971     0.200
    92.428     0.462     0.200
    14.039     4.284     0.200
    14.361     4.124     0.200
    14.478     5.494     0.200
    14.499     3.842     0.200
    14.628     4.891     0.200
    14.678     3.674     0.200
    14.671     4.621     0.200
    14.730     6.549     0.200
    14.834     3.843     0.200
    14.876     3.741     0.200
    14.953     4.669     0.200
    15.121     3.561     0.200
    15.142     2.581     0.200
    15.163     6.131     0.200
    15.434     3.639     0.200
    15.527     3.903     0.200
    15.685     4.340     0.200
    15.721     3.595     0.200
    15.756     4.352     0.200
    15.760     3.512     0.200
    15.827     3.692     0.200
    15.836     4.191     0.200
    15.917     2.933     0.200
    15.922     2.340     0.200
    15.916     2.318     0.200
    16.007     4.421     0.200
    16.029     3.110     0.200
    16.056     3.536     0.200
    16.141     2.644     0.200
    16.304     1.827     0.200
    16.337     3.800     0.200
    16.458     4.218     0.200
    16.458     2.116     0.200
    16.468     2.353     0.200
    16.515     4.165     0.200
    16.513     2.079     0.200
    16.558     1.427     0.200
    16.579     5.106     0.200
    16.607     2.378     0.200
    16.655     2.978     0.200
    16.679     4.062     0.200
    16.741     2.339     0.200
    16.823     2.755     0.200
    16.893     4.860     0.200
    16.927     2.511     0.200
    16.979     1.164     0.200
    16.990     2.332     0.200
    17.022     4.750     0.200
    17.161     1.486     0.200
    17.176     1.863     0.200
    17.203     2.710     0.200
    17.203     2.562     0.200
    17.285     3.039     0.200
    17.307     4.268     0.200
    17.355     3.496     0.200
    17.407     2.620     0.200
    17.598     1.910     0.200
    17.626     4.313     0.200
    17.694     2.241     0.200
    17.733     2.675     0.200
    17.753     2.155     0.200
    17.753     1.222     0.200
    17.773     1.764     0.200
    17.807     1.806     0.200
    17.855     2.535     0.200
    17.930     2.096     0.200
    18.210     2.410     0.200
    18.229     2.307     0.200
    18.483     0.111     0.200
    18.663    -0.680     0.200
    18.833    -1.036     0.200
    19.985    -0.644     0.200
    20.134     1.015     0.200
    20.250    -1.036     0.200
    20.827     0.999     0.200
    20.855     1.050     0.200
    21.048     0.808     0.200
    21.064     1.124     0.200
    21.107     3.508     0.200
    21.094     1.716     0.200
    21.186     3.066     0.200
    21.380     3.874     0.200
    21.412     1.460     0.200
    21.440     1.513     0.200
    21.446     1.549     0.200
    21.477     0.822     0.200
    21.514    -0.816     0.200
    21.553    -1.680     0.200
    21.583    -1.416     0.200
    21.647     2.290     0.200
    21.668     1.387     0.200
    21.698     2.532     0.200
    21.786     2.115     0.200
    21.810     2.006     0.200
    21.831     2.428     0.200
    21.832     0.018     0.200
    21.832     1.307     0.200
    21.935     2.324     0.200
    21.991     1.788     0.200
    22.058     4.185     0.200
    22.071     2.739     0.200
    22.052    -2.131     0.200
    22.096     1.257     0.200
    22.100     1.226     0.200
    22.113     1.618     0.200
    22.118     1.803     0.200
    22.146     0.866     0.200
    22.146     1.030     0.200
    22.157     1.624     0.200
    22.247     1.718     0.200
    22.274     1.203     0.200
    22.309     1.384     0.200
    22.399     2.457     0.200
    22.406    -1.592     0.200
    22.466     2.503     0.200
    22.507     3.106     0.200
    22.544     0.835     0.200
    22.554     1.441     0.200
    22.572     1.401     0.200
    22.645     2.670     0.200
    22.645     2.338     0.200
    22.647     1.200     0.200
    22.662    -1.439     0.200
    22.785     0.273     0.200
    22.785     1.308     0.200
    22.914     1.584     0.200
    22.926     2.652     0.200
    22.941     2.625     0.200
    22.952     2.116     0.200
    23.000     2.940     0.200
    23.012    -0.512     0.200
    23.051     3.245     0.200
    23.046     1.998     0.200
    23.102     2.182     0.200
    23.118     3.288     0.200
    23.251     1.264     0.200
    23.299     2.944     0.200
    23.306    -0.010     0.200
    23.301    -0.523     0.200
    23.317     0.793     0.200
    23.323     0.929     0.200
    23.367     0.914     0.200
    23.395    -2.140     0.200
    23.409     0.844     0.200
    23.496     0.620     0.200
    23.493     0.977     0.200
    23.515    -0.397     0.200
    23.540     2.487     0.200
    23.515     0.079     0.200
    23.536     1.465     0.200
    23.563     0.988     0.200
    23.577    -1.306     0.200
    23.686     0.616     0.200
    23.794     1.667     0.200
    23.842     1.041     0.200
    23.842     1.365     0.200
    23.847     1.220     0.200
    23.873     0.852     0.200
    23.885     1.171     0.200
    23.922     1.117     0.200
    23.941     1.082     0.200
    23.958     2.775     0.200
    23.985    -2.145     0.200
    24.077     0.366     0.200
    24.130     0.877     0.200
    24.132     1.702     0.200
    24.197     0.221     0.200
    24.206     0.299     0.200
    24.396     0.358     0.200
    24.402     0.054     0.200
    24.452    -1.627     0.200
    24.487     0.925     0.200
    24.505     1.661     0.200
    24.559     1.975     0.200
    24.541     1.355     0.200
    24.630     1.314     0.200
    24.671     0.675     0.200
    24.691     0.544     0.200
    24.717    -1.795     0.200
    24.754     0.496     0.200
    24.757     0.735     0.200
    24.834     0.472     0.200
    24.976    -1.629     0.200
    25.033     0.055     0.200
    25.037     1.217     0.200
    25.079    -1.431     0.200
    25.102     1.571     0.200
    25.191     0.658     0.200
    25.189     2.360     0.200
    25.196    -1.411     0.200
    25.249     0.911     0.200
    25.268     0.549     0.200
    25.286     0.020     0.200
    25.351     0.767     0.200
    25.358     0.329     0.200
    25.371     0.100     0.200
    25.371    -0.040     0.200
    25.561     0.263     0.200
    25.643     1.356     0.200
    25.663     0.861     0.200
    25.666     0.885     0.200
    25.732     1.735     0.200
    25.740    -0.585     0.200
    25.750     0.143     0.200
    25.790    -1.008     0.200
    25.894     0.246     0.200
    25.973     0.902     0.200
    25.997     0.415     0.200
    26.001    -0.197     0.200
    26.026     1.179     0.200
    26.027     0.880     0.200
    26.014    -0.643     0.200
    26.088     0.839     0.200
    26.192     0.546     0.200
    26.224     0.709     0.200
    26.255     0.706     0.200
    26.297     0.388     0.200
    26.321     0.586     0.200
    26.323     0.431     0.200
    26.327     0.456     0.200
    26.369     0.720     0.200
    26.405     0.253     0.200
    26.486     0.922     0.200
    26.523     0.829     0.200
    26.566    -0.214     0.200
    26.652     0.940     0.200
    26.653     0.291     0.200
    26.660     0.973     0.200
    26.691     0.846     0.200
    26.751     0.680     0.200
    26.759     0.278     0.200
    26.765     0.555     0.200
    26.861     1.466     0.200
    26.900     0.934     0.200
    27.048    -1.546     0.200
    27.098     0.328     0.200
    27.144     1.284     0.200
    27.169     0.672     0.200
    27.163     0.096     0.200
    27.224     0.552     0.200
    27.228     0.358     0.200
    27.231     1.623     0.200
    27.254     1.883     0.200
    27.263     0.565     0.200
    27.269     1.072     0.200
    27.393     0.484     0.200
    27.393     0.664     0.200
    27.434     1.421     0.200
    27.489     1.234     0.200
    27.508     0.059     0.200
    27.586     1.151     0.200
    27.585     0.185     0.200
    27.585     0.474     0.200
    27.619     1.139     0.200
    27.648    -1.864     0.200
    27.732     0.825     0.200
    27.732     1.048     0.200
    27.741     0.395     0.200
    27.748     1.230     0.200
    27.815    -0.050     0.200
    27.832     1.181     0.200
    27.827     0.364     0.200
    27.847     1.247     0.200
    28.042     0.956     0.200
    28.062     1.952     0.200
    28.066     0.349     0.200
    28.097     1.209     0.200
    28.211     1.048     0.200
    28.250     1.456     0.200
    28.296     1.728     0.200
    28.304     0.401     0.200
    28.319     0.985     0.200
    28.419     1.339     0.200
    28.423     0.542     0.200
    28.439    -0.190     0.200
    28.448     0.204     0.200
    28.519     0.610     0.200
    28.519     0.735     0.200
    28.530     0.602     0.200
    28.604     1.178     0.200
    28.645     0.635     0.200
    28.695     0.916     0.200
    28.725     0.603     0.200
    28.752     0.361     0.200
    28.807     0.250     0.200
    28.881    -1.410     0.200
    28.924     0.695     0.200
    28.952     0.984     0.200
    29.002     0.415     0.200
    29.087     1.098     0.200
    29.097     0.600     0.200
    29.147     1.003     0.200
    29.164     0.938     0.200
    29.165     0.042     0.200
    29.177     0.340     0.200
    29.329    -0.033     0.200
    29.375     3.037     0.200
    29.377     1.002     0.200
    29.401     4.300     0.200
    29.389     0.306     0.200
    29.417     1.309     0.200
    29.421     0.499     0.200
    29.506    -0.036     0.200
    29.507     0.336     0.200
    29.535     0.135     0.200
    29.576     4.368     0.200
    29.619     0.492     0.200
    29.630     0.424     0.200
    29.663     3.366     0.200
    29.687     0.619     0.200
    29.731     0.480     0.200
    29.740     0.864     0.200
    29.736     0.457     0.200
    29.778     2.966     0.200
    29.825     2.538     0.200
    29.767    -0.226     0.200
    29.805     0.221     0.200
    29.862     0.392     0.200
    29.884     1.825     0.200
    29.922     0.415     0.200
    29.926     0.446     0.200
    29.948     0.230     0.200
    30.087     0.302     0.200
    30.088     0.488     0.200
    30.142     0.363     0.200
    30.239     0.624     0.200
    30.281     0.422     0.200
    30.292     0.989     0.200
    30.349     0.787     0.200
    30.362     0.176     0.200
    30.380     2.636     0.200
    30.383     0.659     0.200
    30.482     0.167     0.200
    30.482     0.514     0.200
    30.508    -0.216     0.200
    30.512     0.790     0.200
    30.621     0.085     0.200
    30.637     0.148     0.200
    30.745    -1.285     0.200
    30.795     0.653     0.200
    30.845     0.461     0.200
    30.883    -0.580     0.200
    30.922     0.097     0.200
    30.946     3.734     0.200
    30.959     2.578     0.200
    30.972     0.725     0.200
    30.991     2.148     0.200
    31.061     0.581     0.200
    31.059    -0.032     0.200
    31.060     0.708     0.200
    31.061    -1.827     0.200
    31.176     0.069     0.200
    31.212    -0.057     0.200
    31.215    -0.545     0.200
    31.212     0.073     0.200
    31.296    -0.090     0.200
    31.366     0.016     0.200
    31.405    -0.723     0.200
    31.463     0.997     0.200
    31.533    -0.028     0.200
    31.702     0.280     0.200
    31.785     0.041     0.200
    31.803     0.210     0.200
    31.962    -0.024     0.200
    32.052     1.236     0.200
    32.304     0.305     0.200
    32.308     0.968     0.200
    32.445    -0.052     0.200
    32.445    -0.310     0.200
    32.498    -2.256     0.200
    32.629     1.058     0.200
    32.814     1.211     0.200
    32.841    -1.811     0.200
    32.900    -2.791     0.200
    34.304     0.887     0.200
    34.404     3.919     0.200
    35.853    -0.951     0.200
    36.574    -0.868     0.200
    45.194    -2.179     0.200
    45.260    -1.358     0.200
    45.572    -1.671     0.200
    47.021    -0.470     0.200
    47.928     1.487     0.200
    47.928     0.722     0.200
    51.963     2.205     0.200
    52.240     1.311     0.200
    52.852    -0.232     0.200
    53.095     1.162     0.200
    53.657     1.105     0.200
    53.753     1.146     0.200
    54.130     0.394     0.200
    54.199     1.392     0.200
    54.407     0.376     0.200
    55.322     0.305     0.200
    55.424     1.027     0.200
    55.474     1.062     0.200
    55.718     0.002     0.200
    55.836     0.642     0.200
    55.876     1.258     0.200
    56.762    -1.890     0.200
    56.921     0.013     0.200
    59.224     1.307     0.200
    60.423    -0.636     0.200
    62.089    -0.063     0.200
    63.088     1.225     0.200
    63.658     1.089     0.200
    64.855    -0.677     0.200
    65.127    -0.262     0.200
    65.127    -0.430     0.200
    65.523     1.292     0.200
    66.319    -1.346     0.200
    67.459     0.758     0.200
    69.625     2.246     0.200
    71.061    -1.403     0.200
    73.861     0.915     0.200
    78.003    -0.008     0.200
    80.382     0.564     0.200
    80.840     1.343     0.200
    81.272     2.144     0.200
    81.535     1.952     0.200
    81.588     1.171     0.200
    81.649     1.047     0.200
    81.874     1.762     0.200
    82.104     0.850     0.200
    82.147     1.028     0.200
    82.186     0.421     0.200
    82.502     0.871     0.200
    82.706     0.911     0.200
    82.738     2.544     0.200
    82.982     1.579     0.200
    84.003     1.330     0.200
    84.107     1.305     0.200
    84.389     1.068     0.200
    84.834     1.575     0.200
    85.087     0.957     0.200
    85.125     0.464     0.200
    85.125     1.112     0.200
    85.191     0.137     0.200
    85.608     1.456     0.200
    86.141     1.618     0.200
    86.271     1.276     0.200
    86.450     1.297     0.200
    86.545     2.827     0.200
    86.582     0.988     0.200
    86.607     1.223     0.200
    86.708     1.232     0.200
    86.716     0.992     0.200
    86.789     2.038     0.200
    86.794     0.412     0.200
    87.016     0.827     0.200
    87.232     0.778     0.200
    87.244     0.619     0.200
    87.370     1.013     0.200
    87.595     0.229     0.200
    87.610     0.557     0.200
    87.711    -0.024     0.200
    87.798     2.061     0.200
    87.862     1.359     0.200
    87.978     0.401     0.200
    88.590     0.111     0.200
    88.661     0.873     0.200
    88.874     0.973     0.200
    88.970    -0.080     0.200
    88.978    -0.118     0.200
    88.987     0.745     0.200
    89.032     0.131     0.200
    89.626     0.445     0.200
    89.931     1.220     0.200
    90.246    -0.051     0.200
    90.281     0.588     0.200
    90.381    -1.876     0.200
    90.718     0.252     0.200
    90.748    -0.834     0.200
    91.089     1.131     0.200
    91.090     1.127     0.200
    91.482    -2.295     0.200
    91.580     0.925     0.200
    92.283     1.705     0.200
    92.371     0.800     0.200
    92.500     0.549     0.200
    92.889     0.606     0.200
    93.141     1.245     0.200
    93.861     0.862     0.200
    94.114     0.769     0.200
    94.403     1.142     0.200
    94.938     0.590     0.200
    94.957     0.323     0.200
    95.543     1.327     0.200
    96.706     0.838     0.200
    98.857    -0.140     0.200
    13.699     4.441     0.200
    13.956     4.389     0.200
    14.053     4.844     0.200
    14.091     4.381     0.200
    14.128     4.123     0.200
    14.162     5.077     0.200
    14.251     4.537     0.200
    14.305     4.330     0.200
    14.323     4.807     0.200
    14.410     4.134     0.200
    14.508     4.063     0.200
    14.698     3.930     0.200
    14.722     3.591     0.200
    14.738     3.641     0.200
    14.750     3.413     0.200
    14.822     3.666     0.200
    14.862     3.473     0.200
    14.914     3.396     0.200
    14.993     3.822     0.200
    15.038     4.147     0.200
    15.105     3.984     0.200
    15.241     3.493     0.200
    15.295     4.041     0.200
    15.292     3.196     0.200
    15.342     4.068     0.200
    15.346     3.734     0.200
    15.386     4.382     0.200
    15.386     2.812     0.200
    15.433     3.562     0.200
    15.459     3.386     0.200
    15.543     3.321     0.200
    15.605     3.568     0.200
    15.700     3.192     0.200
    15.787     2.957     0.200
    15.915     2.631     0.200
    15.914     3.171     0.200
    15.923     2.893     0.200
    15.986     2.556     0.200
    16.472     1.959     0.200
    16.618     2.155     0.200
    16.659     2.686     0.200
    16.691     1.976     0.200
    16.765     2.861     0.200
    16.854     2.060     0.200
    17.209     2.482     0.200
    17.224     2.830     0.200
    17.286     2.134     0.200
    17.345     2.016     0.200
    17.445     1.503     0.200
    17.617     2.358     0.200
    17.804     1.944     0.200
    17.808     1.133     0.200
    17.830     1.135     0.200
    17.833     2.619     0.200
    17.921     2.263     0.200
    18.534     0.365     0.200
    18.552     0.392     0.200
    18.834     0.920     0.200
    19.151     0.068     0.200
    19.200     1.196     0.200
    19.589     0.994     0.200
    19.692     1.554     0.200
    19.858     0.387     0.200
    19.958     0.182     0.200
    19.968    -0.653     0.200
    20.141    -1.238     0.200
    20.120     1.464     0.200
    20.325     1.511     0.200
    20.333     1.398     0.200
    20.388     1.141     0.200
    20.430     1.637     0.200
    20.500     0.683     0.200
    20.533    -1.017     0.200
    20.510     0.714     0.200
    20.549     0.569     0.200
    20.680     1.228     0.200
    20.894     1.821     0.200
    21.190     1.301     0.200
    21.300    -0.366     0.200
    21.296     1.280     0.200
    21.513     0.310     0.200
    21.746     0.831     0.200
    22.206    -2.931     0.200
    22.411     1.368     0.200
    22.483     0.327     0.200
    22.962     0.219     0.200
    23.111    -0.009     0.200
    23.583    -0.338     0.200
    23.701     2.269     0.200
    23.770     2.342     0.200
    24.258    -0.899     0.200
    24.267    -0.256     0.200
    24.746     1.119     0.200
    24.746     1.128     0.200
    24.957     0.351     0.200
    25.433     0.206     0.200
    25.436     0.315     0.200
    25.457     0.514     0.200
    25.674    -0.088     0.200
    25.846    -1.444     0.200
    26.734     0.367     0.200
    28.647    -0.612     0.200
    29.193    -0.969     0.200
    29.439    -0.180     0.200
    29.611    -0.607     0.200
    29.696    -0.238     0.200
    29.894    -0.227     0.200
    31.087    -1.335     0.200
    31.327    -0.764     0.200
    31.463    -1.047     0.200
    45.631    -1.941     0.200
    48.052    -0.597     0.200
    48.915     2.139     0.200
    52.685     0.861     0.200
    52.909     2.663     0.200
    52.983     1.005     0.200
    53.273     1.596     0.200
    54.569     0.909     0.200
    55.054     0.530     0.200
    77.743     0.493     0.200
    80.670     1.869     0.200
    82.574     0.723     0.200
    82.656     0.299     0.200
    84.286     0.529     0.200
    84.382     0.643     0.200
    84.666     0.412     0.200
    85.027    -0.473     0.200
    85.150     0.483     0.200
    85.150     0.042     0.200
    85.269     0.735     0.200
    86.510     0.947     0.200
    86.603     0.695     0.200
    86.683     0.701     0.200
    86.966     0.320     0.200
    87.019     1.164     0.200
    87.071     1.109     0.200
    87.517     0.758     0.200
    87.534     0.677     0.200
    87.649     0.625     0.200
    88.228     0.478     0.200
    88.991     0.482     0.200
    89.214     1.736     0.200
    89.310     0.685     0.200
    16.382     3.697     0.200
    16.492     3.281     0.200
    16.463     3.720     0.200
    17.129     2.892     0.200
    17.323     3.255     0.200
    17.521     2.897     0.200
    17.621     2.716     0.200
    17.717     3.230     0.200
    17.644     2.719     0.200
    17.727     2.280     0.200
    17.870     2.326     0.200
    18.000     2.486     0.200
    18.150     1.882     0.200
    18.275     2.072     0.200
    18.295     1.576     0.200
    18.307     0.961     0.200
    18.333     1.466     0.200
    18.445     1.393     0.200
    18.423    -0.743     0.200
    18.523     1.802     0.200
    18.880    -0.628     0.200
    18.880     0.044     0.200
    18.946     1.371     0.200
    19.072     2.100     0.200
    19.069     1.777     0.200
    19.052     2.145     0.200
    19.068     2.081     0.200
    19.093     1.977     0.200
    19.194     1.207     0.200
    19.383     1.563     0.200
    19.406     0.301     0.200
    19.493     1.771     0.200
    19.567     1.616     0.200
    19.566     2.060     0.200
    19.629     0.677     0.200
    19.641     1.121     0.200
    19.718     2.446     0.200
    19.733     0.260     0.200
    19.928     2.172     0.200
    19.891     1.177     0.200
    20.010     1.794     0.200
    20.099     1.442     0.200
    20.102     1.357     0.200
    20.066     0.954     0.200
    20.168     0.426     0.200
    20.189     0.503     0.200
    20.235     1.047     0.200
    20.247     0.476     0.200
    20.284     1.924     0.200
    20.297     1.188     0.200
    20.365     2.391     0.200
    20.347    -1.491     0.200
    20.555     1.332     0.200
    20.621     2.426     0.200
    20.634     0.629     0.200
    20.653     2.095     0.200
    20.669    -1.030     0.200
    20.827     1.873     0.200
    20.828     0.883     0.200
    20.894     1.311     0.200
    20.894     0.623     0.200
    21.044     2.316     0.200
    20.964     0.674     0.200
    21.035     1.776     0.200
    21.165     1.503     0.200
    21.165     1.769     0.200
    21.111     2.171     0.200
    21.224     2.809     0.200
    21.109     1.288     0.200
    21.212     0.443     0.200
    21.336     1.667     0.200
    21.357     1.931     0.200
    21.486     1.940     0.200
    21.407     3.257     0.200
    21.438     1.934     0.200
    21.444     1.872     0.200
    21.477     1.363     0.200
    21.551     0.164     0.200
    21.549     0.850     0.200
    21.620    -0.115     0.200
    21.685    -0.728     0.200
    21.734     1.065     0.200
    21.806     1.267     0.200
    21.806     0.493     0.200
    21.792    -0.190     0.200
    22.018     1.491     0.200
    21.991    -3.190     0.200
    22.082     1.796     0.200
    22.125     1.795     0.200
    22.327     1.939     0.200
    22.327     0.712     0.200
    22.265     0.438     0.200
    22.413    -2.197     0.200
    22.499    -0.052     0.200
    22.794     1.929     0.200
    22.770     1.781     0.200
    22.805    -2.453     0.200
    22.886     1.566     0.200
    22.923     0.619     0.200
    22.981    -0.993     0.200
    23.562     1.813     0.200
    23.466    -2.060     0.200
    23.676     1.477     0.200
    23.641    -0.111     0.200
    24.287     1.742     0.200
    24.356     2.533     0.200
    24.303    -1.132     0.200
    24.321    -1.000     0.200
    24.401    -1.999     0.200
    24.720    -0.570     0.200
    24.740    -0.492     0.200
    24.788    -1.167     0.200
    24.804    -1.581     0.200
    24.991     0.925     0.200
    24.991     1.714     0.200
    25.141    -0.688     0.200
    25.190     0.243     0.200
    25.186    -0.135     0.200
    25.284     0.233     0.200
    25.341    -1.310     0.200
    25.367    -0.976     0.200
    25.377    -0.552     0.200
    25.499     1.450     0.200
    25.676    -0.147     0.200
    25.945     0.119     0.200
    25.954     0.155     0.200
    25.956     0.282     0.200
    25.991    -0.194     0.200
    26.156    -0.585     0.200
    26.199    -0.207     0.200
    26.416     0.559     0.200
    26.599    -0.172     0.200
    26.599    -0.345     0.200
    26.708     0.382     0.200
    26.731     0.344     0.200
    27.152     0.404     0.200
    27.172     0.249     0.200
    27.235     1.103     0.200
    27.189    -1.060     0.200
    27.243    -0.461     0.200
    27.268    -0.656     0.200
    27.339     0.435     0.200
    27.457     0.216     0.200
    27.756     1.483     0.200
    27.752     0.058     0.200
    27.759     0.192     0.200
    27.806     0.382     0.200
    27.829    -0.052     0.200
    28.019     0.179     0.200
    28.573    -0.329     0.200
    28.571    -0.617     0.200
    28.708     0.026     0.200
    28.753     0.299     0.200
    28.910     0.552     0.200
    29.066    -0.218     0.200
    29.152     0.075     0.200
    29.186    -0.886     0.200
    29.287    -0.122     0.200
    29.455    -0.107     0.200
    29.711    -0.116     0.200
    29.723     0.289     0.200
    29.739     0.262     0.200
    29.802    -1.041     0.200
    29.884     0.223     0.200
    30.029     0.681     0.200
    30.037     0.369     0.200
    30.421     0.693     0.200
    30.421     0.490     0.200
    30.557     0.298     0.200
    30.729     0.332     0.200
    30.718    -1.107     0.200
    30.967     0.474     0.200
    31.728     3.008     0.200
    32.021     2.681     0.200
    32.294     0.373     0.200
    32.365     2.029     0.200
    32.452     1.863     0.200
    32.598     1.876     0.200
    32.621    -1.993     0.200
    32.705     2.062     0.200
    36.620    -1.039     0.200
    44.988     2.222     0.200
    44.988     1.245     0.200
    45.151    -1.527     0.200
    45.891    -1.536     0.200
    47.514    -0.884     0.200
    52.202     0.530     0.200
    53.251     0.783     0.200
    53.827     0.090     0.200
    55.151     1.209     0.200
    55.140     0.581     0.200
    55.275     0.818     0.200
    55.534     0.973     0.200
    55.630     0.878     0.200
    56.237     0.054     0.200
    57.671     1.535     0.200
    58.219    -0.065     0.200
    58.232    -0.392     0.200
    65.344    -0.393     0.200
    78.153     0.644     0.200
    80.758     0.211     0.200
    81.884     1.435     0.200
    82.369     1.388     0.200
    82.435     2.147     0.200
    82.482     1.299     0.200
    82.603     0.872     0.200
    82.685     0.446     0.200
    82.882     1.320     0.200
    82.930     1.570     0.200
    84.428     1.496     0.200
    84.528     1.592     0.200
    84.811     1.560     0.200
    85.320     0.931     0.200
    85.396     0.107     0.200
    85.430     0.861     0.200
    85.430     0.259     0.200
    85.523     1.397     0.200
    86.068     1.496     0.200
    86.601     1.771     0.200
    86.716     0.708     0.200
    86.852     0.440     0.200
    87.085     0.308     0.200
    87.106     1.666     0.200
    87.149     0.098     0.200
    87.166     1.517     0.200
    87.793     0.193     0.200
    88.314     1.524     0.200
    92.889    -0.755     0.200
    95.538     1.350     0.200
    13.671     6.638     0.200
    13.709     5.028     0.200
    14.076     5.892     0.200
    14.108     4.881     0.200
    14.176     6.310     0.200
    14.217     5.448     0.200
    14.262     3.821     0.200
    14.267     5.540     0.200
    14.414     4.799     0.200
    14.421     5.415     0.200
    14.454     4.920     0.200
    14.454     3.267     0.200
    14.500     3.986     0.200
    14.638     4.980     0.200
    14.691     4.173     0.200
    14.705     4.436     0.200
    14.774     4.896     0.200
    14.816     3.476     0.200
    14.814     4.570     0.200
    14.844     3.924     0.200
    14.853     4.197     0.200
    14.931     4.183     0.200
    14.993     4.331     0.200
    15.009     2.404     0.200
    15.048     3.786     0.200
    15.091     3.842     0.200
    15.194     3.925     0.200
    15.321     4.231     0.200
    15.330     3.983     0.200
    15.323     3.633     0.200
    15.396     3.169     0.200
    15.452     3.607     0.200
    15.468     3.598     0.200
    15.513     4.068     0.200
    15.540     3.791     0.200
    15.597     3.112     0.200
    15.613     3.271     0.200
    15.625     3.458     0.200
    15.705     3.156     0.200
    15.761     2.950     0.200
    15.879     2.347     0.200
    15.915     2.798     0.200
    16.048     1.771     0.200
    16.077     2.939     0.200
    16.089     2.170     0.200
    16.183     2.238     0.200
    16.209     1.715     0.200
    16.223     2.504     0.200
    16.314     2.790     0.200
    16.351     2.293     0.200
    16.403     2.460     0.200
    16.469     2.418     0.200
    16.469     1.441     0.200
    16.708     2.802     0.200
    16.759     1.477     0.200
    16.795     2.961     0.200
    16.801     2.458     0.200
    16.813     2.947     0.200
    16.953     1.252     0.200
    17.005     1.162     0.200
    17.185     0.783     0.200
    17.183     2.099     0.200
    17.295     3.048     0.200
    17.304     2.157     0.200
    17.464     2.094     0.200
    17.525     0.737     0.200
    17.866     0.642     0.200
    17.931     2.125     0.200
    18.004    -0.188     0.200
    18.052    -0.221     0.200
    18.052    -0.578     0.200
    18.158     0.052     0.200
    18.172    -1.765     0.200
    18.264    -0.159     0.200
    18.492    -0.263     0.200
    18.596    -0.671     0.200
    18.596    -0.964     0.200
    18.623     0.038     0.200
    18.623    -0.716     0.200
    18.900     0.065     0.200
    19.094     0.640     0.200
    19.230     0.485     0.200
    19.263     0.172     0.200
    19.309     0.512     0.200
    19.331    -0.659     0.200
    19.397     1.138     0.200
    19.571     0.091     0.200
    19.639    -0.744     0.200
    19.836     1.210     0.200
    19.905     0.563     0.200
    19.929    -0.915     0.200
    19.966     0.255     0.200
    19.985    -0.837     0.200
    20.061    -0.104     0.200
    20.104    -0.960     0.200
    20.247     1.403     0.200
    20.313    -0.260     0.200
    20.331    -0.475     0.200
    20.340    -1.406     0.200
    20.459     1.038     0.200
    20.474    -0.332     0.200
    20.505    -1.373     0.200
    20.503     0.456     0.200
    20.546     1.344     0.200
    20.546     0.462     0.200
    20.567     0.860     0.200
    20.622     0.454     0.200
    20.657     0.041     0.200
    20.741    -0.838     0.200
    20.893    -0.062     0.200
    20.924    -1.172     0.200
    21.028    -0.827     0.200
    21.043     3.399     0.200
    21.091     1.531     0.200
    21.108    -1.186     0.200
    21.136    -0.255     0.200
    21.135     2.325     0.200
    21.186     4.982     0.200
    21.214     0.384     0.200
    21.216    -0.058     0.200
    21.288    -0.418     0.200
    21.293    -0.218     0.200
    21.444     2.488     0.200
    21.444     0.235     0.200
    21.504    -0.218     0.200
    21.561     1.042     0.200
    21.650     0.173     0.200
    21.635     2.358     0.200
    21.685     1.792     0.200
    21.740     0.156     0.200
    21.744     1.106     0.200
    21.760     0.275     0.200
    21.819     2.313     0.200
    21.878    -1.503     0.200
    21.878    -2.457     0.200
    21.880     2.300     0.200
    21.899     1.778     0.200
    21.921     0.200     0.200
    21.927    -0.389     0.200
    22.118    -0.525     0.200
    22.220     0.006     0.200
    22.422     4.011     0.200
    22.521     2.131     0.200
    22.560     2.031     0.200
    22.684     2.950     0.200
    22.763     0.622     0.200
    22.805     1.984     0.200
    22.922     1.304     0.200
    22.995     1.327     0.200
    23.068    -0.770     0.200
    23.296     1.973     0.200
    23.296     1.178     0.200
    23.694    -1.027     0.200
    23.978     1.274     0.200
    24.235     0.891     0.200
    24.234    -2.082     0.200
    24.234    -2.542     0.200
    24.251     0.613     0.200
    24.356     1.256     0.200
    24.356     0.758     0.200
    24.592    -1.607     0.200
    24.611     0.783     0.200
    24.740     1.048     0.200
    24.840     2.316     0.200
    24.912    -0.254     0.200
    25.065    -1.762     0.200
    25.106     0.279     0.200
    25.194    -1.443     0.200
    25.497    -1.060     0.200
    25.553     0.286     0.200
    25.582     0.684     0.200
    25.589     0.256     0.200
    25.745     0.363     0.200
    25.831     0.450     0.200
    25.870    -1.329     0.200
    25.870    -1.845     0.200
    25.889     0.577     0.200
    25.932     1.264     0.200
    26.748    -2.586     0.200
    27.313    -1.926     0.200
    28.088    -2.556     0.200
    28.988    -1.903     0.200
    30.398    -1.224     0.200
    30.398    -1.478     0.200
    30.952    -2.382     0.200
    36.273    -1.433     0.200
    44.784    -1.527     0.200
    45.656    -1.826     0.200
    52.871     0.506     0.200
    54.759     0.262     0.200
    55.249     0.535     0.200
    63.896     2.277     0.200
    65.056    -0.767     0.200
    65.056    -0.507     0.200
    70.942    -1.705     0.200
    80.888     1.771     0.200
    85.102     0.183     0.200
    85.184     0.346     0.200
    85.184    -0.229     0.200
    85.210     0.990     0.200
    86.881     1.261     0.200
    87.154     0.107     0.200
    87.476     1.254     0.200
    90.742    -1.047     0.200
    92.696     0.602     0.200
    96.442     1.624     0.200
    96.442     1.379     0.200
    99.484     1.338     0.200
    24.399     1.503     0.200
    55.080    -0.405     0.200
    13.943     4.790     0.200
    14.739     5.272     0.200
    15.912     3.998     0.200
    16.943     3.420     0.200
    18.178     0.041     0.200
    21.925     3.285     0.200
    22.073    -1.143     0.200
    22.579     3.271     0.200
    22.738     0.803     0.200
    22.764     3.352     0.200
    23.413     1.967     0.200
    24.474    -1.849     0.200
    24.748     2.143     0.200
    24.748     0.898     0.200
    25.471     0.295     0.200
    26.326     0.605     0.200
    26.398     0.385     0.200
    26.471     1.055     0.200
    26.506     0.995     0.200
    26.667     0.781     0.200
    26.853     0.023     0.200
    30.655    -1.259     0.200
    45.288    -1.832     0.200
    47.806     0.708     0.200
    13.533     6.172     0.200
    13.538     5.823     0.200
    13.606     3.402     0.200
    13.846     5.369     0.200
    13.873     5.132     0.200
    13.906     4.495     0.200
    13.912     4.885     0.200
    14.128     3.497     0.200
    14.157     4.772     0.200
    14.199     4.321     0.200
    14.270     4.468     0.200
    14.453     2.971     0.200
    14.478     3.880     0.200
    14.628     2.406     0.200
    14.761     3.184     0.200
    14.765     3.383     0.200
    14.845     2.564     0.200
    14.934     3.542     0.200
    14.934     3.425     0.200
    15.025     3.431     0.200
    15.065     3.068     0.200
    15.031     2.550     0.200
    15.031     2.664     0.200
    15.384     2.193     0.200
    15.415     2.340     0.200
    15.465     1.565     0.200
    15.609     0.916     0.200
    15.622     2.207     0.200
    15.682     3.013     0.200
    15.778     1.573     0.200
    15.822     1.861     0.200
    15.810     3.096     0.200
    15.885     1.008     0.200
    15.912     1.928     0.200
    16.009     1.336     0.200
    16.209     1.258     0.200
    16.209     3.878     0.200
    16.257     0.784     0.200
    16.257     1.431     0.200
    16.594     0.416     0.200
    16.599     0.169     0.200
    16.604     0.916     0.200
    16.695     2.442     0.200
    16.816     3.589     0.200
    16.875     0.354     0.200
    16.990     0.084     0.200
    17.063     0.804     0.200
    17.084     0.268     0.200
    17.168    -0.074     0.200
    17.168     0.231     0.200
    17.135     3.462     0.200
    17.167     3.380     0.200
    17.354    -0.421     0.200
    17.351    -1.701     0.200
    17.477    -0.475     0.200
    17.573    -0.386     0.200
    17.605    -0.756     0.200
    17.605    -1.577     0.200
    17.689    -0.784     0.200
    17.683    -0.466     0.200
    17.854    -0.292     0.200
    17.854    -0.715     0.200
    17.878    -0.969     0.200
    18.015    -0.414     0.200
    18.015    -0.802     0.200
    18.030    -1.065     0.200
    18.084     0.104     0.200
    18.174    -0.353     0.200
    18.174    -0.181     0.200
    18.199    -0.970     0.200
    18.333    -0.675     0.200
    18.380    -1.325     0.200
    18.373    -1.068     0.200
    18.373     0.084     0.200
    18.436    -0.668     0.200
    18.478    -0.729     0.200
    18.677    -0.316     0.200
    18.684    -0.864     0.200
    18.702    -0.079     0.200
    18.700    -0.624     0.200
    18.715    -0.121     0.200
    18.756    -0.228     0.200
    18.746    -0.469     0.200
    18.795    -0.053     0.200
    18.919    -0.161     0.200
    18.961    -0.117     0.200
    18.961    -1.071     0.200
    18.980    -0.573     0.200
    19.001    -0.359     0.200
    19.056    -0.849     0.200
    19.241    -0.656     0.200
    19.269    -0.585     0.200
    19.342    -0.473     0.200
    19.404    -0.956     0.200
    19.441     0.281     0.200
    19.464    -0.592     0.200
    19.519    -0.759     0.200
    19.530    -0.644     0.200
    19.605    -0.358     0.200
    19.629    -0.782     0.200
    19.756    -0.772     0.200
    19.842    -0.618     0.200
    19.846    -0.802     0.200
    19.878    -0.796     0.200
    19.886    -0.421     0.200
    19.964    -0.301     0.200
    19.964     0.085     0.200
    19.967     1.011     0.200
    19.967    -0.167     0.200
    20.003    -0.412     0.200
    20.016    -0.981     0.200
    20.009     1.301     0.200
    20.058    -0.779     0.200
    20.149    -0.163     0.200
    20.155    -0.730     0.200
    20.198    -0.763     0.200
    20.212    -0.581     0.200
    20.285    -0.875     0.200
    20.340    -1.076     0.200
    20.457    -1.075     0.200
    20.501    -0.825     0.200
    20.525    -0.745     0.200
    20.502     1.403     0.200
    20.547     1.344     0.200
    20.548    -0.417     0.200
    20.633     0.449     0.200
    20.682    -0.967     0.200
    20.693    -1.846     0.200
    20.701    -0.848     0.200
    20.702    -0.461     0.200
    20.775     1.131     0.200
    20.778    -0.434     0.200
    20.794    -0.350     0.200
    20.794    -0.749     0.200
    20.813     4.553     0.200
    20.880     1.668     0.200
    20.973    -1.359     0.200
    20.976     1.578     0.200
    21.056     2.216     0.200
    21.096    -1.671     0.200
    21.114    -0.649     0.200
    21.158    -0.458     0.200
    21.183    -1.011     0.200
    21.173    -0.266     0.200
    21.304     1.668     0.200
    21.341    -1.076     0.200
    21.376    -1.252     0.200
    21.426    -2.375     0.200
    21.497    -0.974     0.200
    21.512    -1.193     0.200
    21.526    -1.294     0.200
    21.530    -0.598     0.200
    21.525     2.962     0.200
    21.578    -1.310     0.200
    21.550     1.815     0.200
    21.550     2.208     0.200
    21.634    -0.426     0.200
    21.670    -0.357     0.200
    21.680    -1.651     0.200
    21.730    -1.071     0.200
    21.789    -1.192     0.200
    21.811    -0.958     0.200
    21.845    -0.364     0.200
    21.865    -1.564     0.200
    21.906     1.930     0.200
    21.956    -1.954     0.200
    21.997     1.108     0.200
    22.066    -1.423     0.200
    22.023     2.269     0.200
    22.067    -0.980     0.200
    22.128    -0.493     0.200
    22.158    -1.162     0.200
    22.217     2.055     0.200
    22.217     1.491     0.200
    22.261    -1.436     0.200
    22.324    -1.456     0.200
    22.353    -1.442     0.200
    22.438    -1.471     0.200
    22.469    -0.931     0.200
    22.481    -1.067     0.200
    22.547    -1.705     0.200
    22.578    -2.697     0.200
    22.599    -1.354     0.200
    22.600    -1.971     0.200
    22.685    -1.060     0.200
    22.695    -1.212     0.200
    22.733    -1.077     0.200
    22.733    -0.927     0.200
    22.788     0.339     0.200
    22.821    -1.529     0.200
    22.929     0.830     0.200
    22.969    -1.436     0.200
    22.976    -1.172     0.200
    23.020    -1.206     0.200
    23.042    -1.544     0.200
    23.053    -0.773     0.200
    23.099    -1.358     0.200
    23.103    -0.825     0.200
    23.132    -1.329     0.200
    23.145    -1.013     0.200
    23.247    -1.028     0.200
    23.248    -1.276     0.200
    23.287    -1.092     0.200
    23.413    -1.042     0.200
    23.461    -0.648     0.200
    23.492    -1.209     0.200
    23.535    -1.027     0.200
    23.595    -0.853     0.200
    23.591    -0.051     0.200
    23.610    -0.774     0.200
    23.615     0.027     0.200
    23.635    -0.816     0.200
    23.728    -1.322     0.200
    23.728    -1.202     0.200
    23.725     0.280     0.200
    23.794     0.321     0.200
    23.794     0.468     0.200
    23.860    -0.991     0.200
    23.840     0.955     0.200
    23.870    -1.015     0.200
    23.873    -0.809     0.200
    23.870    -0.920     0.200
    23.884    -0.888     0.200
    23.910    -1.338     0.200
    23.984     0.438     0.200
    24.017    -1.240     0.200
    24.049    -1.287     0.200
    24.119    -0.474     0.200
    24.262    -0.726     0.200
    24.334    -0.939     0.200
    24.340    -0.306     0.200
    24.364    -0.699     0.200
    24.368     0.926     0.200
    24.368     0.095     0.200
    24.368     0.735     0.200
    24.399    -1.026     0.200
    24.497    -0.904     0.200
    24.514    -1.379     0.200
    24.500    -0.478     0.200
    24.558    -0.606     0.200
    24.604    -0.931     0.200
    24.645    -1.006     0.200
    24.658    -1.294     0.200
    24.664    -0.674     0.200
    24.651     1.595     0.200
    24.700     0.107     0.200
    24.715    -1.086     0.200
    24.788     0.038     0.200
    24.869    -0.889     0.200
    24.881    -0.503     0.200
    24.921    -1.133     0.200
    24.942     0.382     0.200
    25.013    -1.742     0.200
    25.013    -1.632     0.200
    24.993     0.479     0.200
    25.012    -1.520     0.200
    25.082    -1.188     0.200
    25.087     0.185     0.200
    25.124    -1.014     0.200
    25.185    -0.872     0.200
    25.252     0.927     0.200
    25.252    -0.305     0.200
    25.312    -1.379     0.200
    25.352     0.650     0.200
    25.522    -1.177     0.200
    25.636    -1.371     0.200
    25.679    -1.372     0.200
    26.070    -0.330     0.200
    26.170    -2.148     0.200
    26.220    -1.293     0.200
    26.531    -1.297     0.200
    27.090    -0.641     0.200
    27.119    -3.600     0.200
    27.130    -1.135     0.200
    27.605    -0.038     0.200
    27.641    -0.736     0.200
    27.703    -0.707     0.200
    28.005    -0.918     0.200
    29.402    -1.333     0.200
    29.430    -1.266     0.200
    29.499     0.011     0.200
    29.573    -0.725     0.200
    29.810    -0.800     0.200
    29.810    -1.915     0.200
    29.870    -0.527     0.200
    30.366    -1.494     0.200
    32.874     2.450     0.200
    32.874     0.141     0.200
    44.227    -0.103     0.200
    46.518     1.679     0.200
    48.033    -1.766     0.200
    52.917    -0.651     0.200
    54.261    -0.596     0.200
    83.035    -0.531     0.200
    84.516    -0.846     0.200
    84.755    -0.039     0.200
    14.444     3.085     0.200
    14.966     3.253     0.200
    15.861     2.493     0.200
    16.530     1.793     0.200
    16.652     1.229     0.200
    16.950     2.987     0.200
    16.950     2.874     0.200
    17.666     2.570     0.200
    17.713     0.656     0.200
    17.947    -0.693     0.200
    18.329    -1.984     0.200
    18.452    -0.134     0.200
    18.795    -2.943     0.200
    18.856    -2.190     0.200
    18.842     0.840     0.200
    19.022    -1.281     0.200
    19.030    -1.057     0.200
    19.113    -0.939     0.200
    19.253    -0.251     0.200
    19.346    -0.694     0.200
    19.367     0.222     0.200
    19.594    -0.788     0.200
    19.617    -0.958     0.200
    19.636    -0.259     0.200
    19.762    -1.129     0.200
    19.822    -0.914     0.200
    19.822    -0.801     0.200
    19.821    -0.845     0.200
    19.933    -1.008     0.200
    19.948    -1.060     0.200
    20.012    -1.495     0.200
    20.113    -0.430     0.200
    20.172    -0.668     0.200
    20.216    -1.392     0.200
    20.230    -0.730     0.200
    20.292    -1.005     0.200
    20.394    -0.647     0.200
    20.444    -0.836     0.200
    20.460    -1.079     0.200
    20.508    -1.945     0.200
    20.540    -0.104     0.200
    20.543     0.915     0.200
    20.607    -0.900     0.200
    20.618    -0.942     0.200
    20.635    -0.523     0.200
    20.648    -0.718     0.200
    20.661    -0.680     0.200
    20.848    -0.589     0.200
    20.842    -0.719     0.200
    20.852    -0.202     0.200
    20.887    -1.247     0.200
    21.031    -0.509     0.200
    21.053    -1.051     0.200
    21.100    -0.296     0.200
    21.160     0.460     0.200
    21.221     2.709     0.200
    21.221     2.525     0.200
    21.323    -0.578     0.200
    21.349    -1.285     0.200
    21.341     2.099     0.200
    21.440     0.998     0.200
    21.487    -1.964     0.200
    21.510    -0.276     0.200
    21.536    -1.481     0.200
    21.570     2.770     0.200
    21.583     1.419     0.200
    21.583     0.583     0.200
    21.632    -1.698     0.200
    21.681    -0.910     0.200
    21.753    -1.030     0.200
    21.821    -1.710     0.200
    21.829    -0.286     0.200
    21.830     2.819     0.200
    21.889    -2.057     0.200
    21.889    -1.866     0.200
    21.904    -2.919     0.200
    21.903     1.717     0.200
    21.919    -0.537     0.200
    21.924    -0.707     0.200
    21.924    -1.633     0.200
    21.987    -1.423     0.200
    22.084    -0.986     0.200
    22.141     1.875     0.200
    22.155     1.386     0.200
    22.195    -0.616     0.200
    22.295    -0.956     0.200
    22.293    -1.136     0.200
    22.322    -0.388     0.200
    22.319     0.963     0.200
    22.408    -2.633     0.200
    22.405     1.350     0.200
    22.448    -1.618     0.200
    22.449    -1.680     0.200
    22.543    -0.031     0.200
    22.557    -1.137     0.200
    22.564    -1.427     0.200
    22.624    -2.518     0.200
    22.669    -1.245     0.200
    22.651     2.159     0.200
    22.702     1.540     0.200
    22.715    -1.678     0.200
    22.742    -1.386     0.200
    22.857    -2.142     0.200
    22.888    -0.506     0.200
    22.921    -1.837     0.200
    22.938    -1.292     0.200
    22.983    -1.111     0.200
    22.992    -0.393     0.200
    23.033    -0.907     0.200
    23.049     1.588     0.200
    23.302    -1.023     0.200
    23.379    -1.216     0.200
    23.382    -1.794     0.200
    23.404    -1.768     0.200
    23.412    -1.561     0.200
    23.427    -1.169     0.200
    23.434    -1.478     0.200
    23.528    -1.653     0.200
    23.556    -1.303     0.200
    23.600    -1.225     0.200
    23.588     1.185     0.200
    23.621    -0.788     0.200
    23.723    -0.851     0.200
    23.846    -1.746     0.200
    23.846    -2.543     0.200
    23.866    -1.340     0.200
    23.926    -1.387     0.200
    23.971    -1.366     0.200
    23.970    -0.986     0.200
    24.196    -1.193     0.200
    24.177     2.082     0.200
    24.220    -1.510     0.200
    24.285    -1.096     0.200
    24.285    -1.877     0.200
    24.311    -1.326     0.200
    24.313    -0.798     0.200
    24.313     1.759     0.200
    24.384     1.757     0.200
    24.384     2.378     0.200
    24.503     0.140     0.200
    24.539     0.114     0.200
    24.574    -1.694     0.200
    24.628    -1.060     0.200
    24.629    -0.487     0.200
    24.666    -1.653     0.200
    24.767    -1.857     0.200
    24.764    -1.007     0.200
    24.800    -1.707     0.200
    24.806    -1.286     0.200
    24.827    -0.627     0.200
    24.843    -1.361     0.200
    24.843    -1.498     0.200
    25.016     2.550     0.200
    25.058    -1.302     0.200
    25.072    -2.412     0.200
    25.072    -1.068     0.200
    25.101    -1.711     0.200
    25.118     0.460     0.200
    25.118    -0.414     0.200
    25.118     0.871     0.200
    25.118    -0.184     0.200
    25.219    -1.345     0.200
    25.275    -1.718     0.200
    25.308    -1.217     0.200
    25.327     1.077     0.200
    25.461    -0.821     0.200
    25.461     0.188     0.200
    25.492    -1.187     0.200
    25.511    -1.347     0.200
    25.609    -1.155     0.200
    25.739    -2.304     0.200
    25.787    -0.935     0.200
    25.815    -2.653     0.200
    25.874    -1.302     0.200
    25.963    -1.440     0.200
    26.095    -1.687     0.200
    26.273     0.333     0.200
    26.312     0.296     0.200
    26.373    -1.593     0.200
    26.423    -0.534     0.200
    26.456    -1.511     0.200
    26.506    -0.871     0.200
    26.572    -1.652     0.200
    26.572    -1.773     0.200
    26.695    -1.324     0.200
    26.757    -1.740     0.200
    26.890     0.349     0.200
    26.914    -2.477     0.200
    26.987    -0.791     0.200
    27.035    -1.289     0.200
    27.037    -0.656     0.200
    27.052    -1.232     0.200
    27.108    -0.737     0.200
    27.139     0.259     0.200
    27.309    -1.525     0.200
    27.333     0.240     0.200
    27.612    -1.683     0.200
    27.772    -0.004     0.200
    27.862    -1.067     0.200
    28.148    -1.258     0.200
    28.161    -1.207     0.200
    28.265     0.978     0.200
    28.265     0.321     0.200
    28.418    -1.466     0.200
    28.453    -1.258     0.200
    28.670    -0.100     0.200
    28.707    -1.291     0.200
    28.692     1.520     0.200
    28.908    -0.541     0.200
    29.100    -1.053     0.200
    29.230    -1.155     0.200
    29.241    -1.481     0.200
    29.326    -1.005     0.200
    29.529    -0.352     0.200
    29.576    -0.554     0.200
    29.625    -1.375     0.200
    29.630    -0.175     0.200
    29.869    -1.108     0.200
    29.889    -1.311     0.200
    30.088    -0.454     0.200
    30.161    -1.389     0.200
    30.183    -1.447     0.200
    30.230     0.681     0.200
    30.358    -0.713     0.200
    30.358    -0.873     0.200
    30.362    -0.891     0.200
    30.368    -1.165     0.200
    30.372    -0.854     0.200
    30.459    -1.579     0.200
    30.492     0.797     0.200
    30.569    -1.712     0.200
    30.717    -0.709     0.200
    30.727    -1.027     0.200
    30.769    -0.990     0.200
    30.817    -1.298     0.200
    30.844    -1.162     0.200
    31.050    -0.973     0.200
    32.178     1.904     0.200
    32.268    -2.059     0.200
    32.268    -1.844     0.200
    36.331    -0.914     0.200
    44.943    -0.920     0.200
    45.009    -1.322     0.200
    45.394    -1.985     0.200
    45.766     0.346     0.200
    47.212    -1.392     0.200
    48.149     3.048     0.200
    53.678    -0.011     0.200
    53.678    -0.398     0.200
    53.883     0.822     0.200
    54.756     1.142     0.200
    55.013     0.845     0.200
    55.069     0.442     0.200
    55.069     0.461     0.200
    55.069     0.383     0.200
    55.583     1.021     0.200
    55.607     0.810     0.200
    56.522    -1.379     0.200
    58.185     0.380     0.200
    62.312     1.242     0.200
    64.918    -0.418     0.200
    77.779     0.051     0.200
    80.226     0.542     0.200
    80.589     1.216     0.200
    81.348     1.650     0.200
    82.607     1.416     0.200
    83.800     0.088     0.200
    83.800    -0.104     0.200
    84.736     1.356     0.200
    84.773     0.747     0.200
    84.942     0.066     0.200
    84.979     0.507     0.200
    90.551    -0.625     0.200
    92.350    -0.213     0.200
    14.521     6.922     0.200
    15.108     5.608     0.200
    15.442     6.445     0.200
    15.480     5.852     0.200
    15.668     4.534     0.200
    16.793     4.248     0.200
    16.855     4.045     0.200
    17.428     4.080     0.200
    17.959     4.054     0.200
    18.211     3.143     0.200
    18.306    -0.769     0.200
    18.306    -1.889     0.200
    18.525     2.519     0.200
    18.526     1.706     0.200
    18.526     1.178     0.200
    18.653    -0.565     0.200
    18.653    -0.757     0.200
    18.795     2.881     0.200
    18.749    -0.773     0.200
    18.772    -0.271     0.200
    18.838     1.053     0.200
    18.841     1.735     0.200
    19.057     1.979     0.200
    19.057     2.272     0.200
    19.059    -0.024     0.200
    19.074     1.413     0.200
    19.074     1.762     0.200
    19.186     1.928     0.200
    19.316     2.191     0.200
    19.316     2.594     0.200
    19.347     3.403     0.200
    19.383    -0.969     0.200
    19.373     0.092     0.200
    19.430    -0.082     0.200
    19.629     1.373     0.200
    19.578     0.338     0.200
    19.621     0.192     0.200
    19.621     0.577     0.200
    19.630     0.060     0.200
    19.698     0.644     0.200
    19.691     1.058     0.200
    19.718     0.305     0.200
    19.738    -0.394     0.200
    19.752    -0.091     0.200
    19.851    -1.234     0.200
    19.817    -0.112     0.200
    19.969     3.032     0.200
    19.920    -0.827     0.200
    19.966     2.028     0.200
    19.953    -0.514     0.200
    19.922     1.880     0.200
    20.015     1.964     0.200
    19.977    -0.412     0.200
    20.061     2.344     0.200
    20.054    -0.204     0.200
    20.154    -1.211     0.200
    20.208     1.921     0.200
    20.186    -1.111     0.200
    20.180    -0.458     0.200
    20.225    -0.125     0.200
    20.281     1.267     0.200
    20.228    -0.436     0.200
    20.291     0.380     0.200
    20.240    -0.001     0.200
    20.327     2.920     0.200
    20.265    -0.592     0.200
    20.309    -0.668     0.200
    20.325     0.182     0.200
    20.348    -0.517     0.200
    20.365    -1.860     0.200
    20.365    -1.115     0.200
    20.428     1.492     0.200
    20.482    -0.374     0.200
    20.534     2.195     0.200
    20.542     2.170     0.200
    20.519    -1.036     0.200
    20.547    -0.901     0.200
    20.631     1.524     0.200
    20.636    -0.578     0.200
    20.658    -0.479     0.200
    20.666    -0.372     0.200
    20.746     2.148     0.200
    20.700    -0.826     0.200
    20.781     2.529     0.200
    20.775    -0.078     0.200
    20.799    -0.463     0.200
    20.799    -0.783     0.200
    20.855    -1.037     0.200
    20.839    -0.426     0.200
    20.863    -0.765     0.200
    20.863    -1.032     0.200
    20.971    -1.248     0.200
    20.966    -1.084     0.200
    21.001    -0.752     0.200
    21.124    -0.615     0.200
    21.212     2.014     0.200
    21.177    -0.427     0.200
    21.200    -0.760     0.200
    21.237     2.942     0.200
    21.264     2.090     0.200
    21.274     2.540     0.200
    21.202    -0.402     0.200
    21.303     1.676     0.200
    21.259    -0.695     0.200
    21.322     2.103     0.200
    21.273    -0.283     0.200
    21.263    -1.424     0.200
    21.296    -1.229     0.200
    21.296    -0.909     0.200
    21.385     2.537     0.200
    21.352    -0.478     0.200
    21.363    -0.615     0.200
    21.383    -0.298     0.200
    21.383     0.122     0.200
    21.397    -1.029     0.200
    21.475     2.262     0.200
    21.488     2.396     0.200
    21.414    -0.805     0.200
    21.460    -1.061     0.200
    21.487    -0.554     0.200
    21.590    -0.629     0.200
    21.603    -1.501     0.200
    21.669     2.138     0.200
    21.637    -0.836     0.200
    21.666    -0.690     0.200
    21.700    -1.276     0.200
    21.702    -0.741     0.200
    21.714    -1.391     0.200
    21.741    -1.002     0.200
    21.778    -1.460     0.200
    21.847    -1.077     0.200
    21.860     1.879     0.200
    21.860     1.775     0.200
    21.939     3.220     0.200
    21.860    -0.688     0.200
    21.902    -1.125     0.200
    21.928    -1.533     0.200
    22.028    -1.938     0.200
    22.053    -1.392     0.200
    22.088    -1.570     0.200
    22.091    -1.148     0.200
    22.183    -1.012     0.200
    22.181    -1.757     0.200
    22.277     2.009     0.200
    22.231    -0.978     0.200
    22.240    -1.063     0.200
    22.236    -1.690     0.200
    22.273    -1.817     0.200
    22.273    -1.287     0.200
    22.248    -1.510     0.200
    22.248    -1.338     0.200
    22.363     1.083     0.200
    22.363     1.230     0.200
    22.330    -1.477     0.200
    22.381    -1.880     0.200
    22.407    -2.073     0.200
    22.420    -1.887     0.200
    22.427    -2.151     0.200
    22.473    -0.347     0.200
    22.475    -1.520     0.200
    22.526     1.122     0.200
    22.572    -1.201     0.200
    22.573    -1.942     0.200
    22.722     1.591     0.200
    22.719    -2.247     0.200
    22.738    -1.745     0.200
    22.726    -2.276     0.200
    22.883    -1.698     0.200
    22.952     1.901     0.200
    22.918    -0.766     0.200
    22.953    -2.300     0.200
    23.038    -1.680     0.200
    23.034    -1.618     0.200
    23.057    -0.803     0.200
    23.068    -1.161     0.200
    23.122     0.969     0.200
    23.201    -1.428     0.200
    23.214    -1.680     0.200
    23.288     2.729     0.200
    23.207    -2.474     0.200
    23.238    -1.473     0.200
    23.294    -1.544     0.200
    23.389    -2.140     0.200
    23.468     2.390     0.200
    23.406    -1.652     0.200
    23.423    -2.355     0.200
    23.452    -1.934     0.200
    23.536     1.673     0.200
    23.536     1.703     0.200
    23.610    -1.720     0.200
    23.689     1.995     0.200
    23.647    -1.921     0.200
    23.672    -1.253     0.200
    23.682    -1.824     0.200
    23.672    -2.172     0.200
    23.721    -2.027     0.200
    23.797     2.817     0.200
    23.795    -1.462     0.200
    23.776    -2.131     0.200
    23.828    -1.278     0.200
    23.943     2.041     0.200
    23.885    -0.598     0.200
    23.939     1.023     0.200
    23.922    -1.468     0.200
    23.938    -1.819     0.200
    23.932    -1.241     0.200
    23.961    -1.056     0.200
    24.141     3.252     0.200
    24.167    -0.111     0.200
    24.152    -1.147     0.200
    24.170    -1.395     0.200
    24.265     1.517     0.200
    24.241    -1.185     0.200
    24.262    -1.353     0.200
    24.336    -1.332     0.200
    24.410     0.954     0.200
    24.360    -1.767     0.200
    24.500    -0.346     0.200
    24.512    -1.804     0.200
    24.520    -1.511     0.200
    24.520    -1.167     0.200
    24.570    -1.254     0.200
    24.597    -1.199     0.200
    24.642     1.374     0.200
    24.642     0.607     0.200
    24.642    -0.055     0.200
    24.713     1.849     0.200
    24.689    -1.677     0.200
    24.725    -0.808     0.200
    24.862     2.870     0.200
    24.799    -1.585     0.200
    24.799    -0.848     0.200
    24.835     2.745     0.200
    24.978    -0.914     0.200
    25.060     2.996     0.200
    24.956     2.436     0.200
    25.054    -2.030     0.200
    25.191    -1.615     0.200
    25.253     1.972     0.200
    25.233    -0.901     0.200
    25.221    -0.736     0.200
    25.221    -0.328     0.200
    25.262    -1.626     0.200
    25.255    -1.718     0.200
    25.383    -1.026     0.200
    25.493     0.980     0.200
    25.523    -0.347     0.200
    25.649     2.938     0.200
    25.583    -0.805     0.200
    25.650     1.282     0.200
    25.636    -1.698     0.200
    25.749    -1.506     0.200
    25.808     2.846     0.200
    25.806    -0.179     0.200
    25.820    -1.719     0.200
    25.820    -1.350     0.200
    25.979     2.553     0.200
    26.032    -1.495     0.200
    26.032    -1.264     0.200
    26.265     5.016     0.200
    26.327    -2.177     0.200
    26.402    -1.395     0.200
    26.813     1.899     0.200
    26.861    -0.090     0.200
    26.828    -1.902     0.200
    26.828    -0.011     0.200
    26.972     1.648     0.200
    27.078    -1.836     0.200
    27.106    -1.581     0.200
    27.151    -1.773     0.200
    27.235     2.356     0.200
    27.229    -1.558     0.200
    27.693     1.787     0.200
    28.319    -2.909     0.200
    28.512    -2.290     0.200
    28.590    -2.530     0.200
    28.629    -1.996     0.200
    28.889     2.537     0.200
    29.233    -1.974     0.200
    29.530     1.646     0.200
    29.548     1.381     0.200
    29.521    -1.442     0.200
    29.537    -1.750     0.200
    29.569    -1.517     0.200
    29.653     1.173     0.200
    29.799    -2.081     0.200
    29.995    -2.024     0.200
    30.060    -1.521     0.200
    30.141    -1.761     0.200
    30.084     4.367     0.200
    30.130     2.269     0.200
    30.199    -1.318     0.200
    30.348    -1.507     0.200
    30.348    -1.208     0.200
    30.371    -1.294     0.200
    30.453    -2.179     0.200
    30.420     1.396     0.200
    30.679     2.476     0.200
    30.751    -1.713     0.200
    30.739    -1.759     0.200
    30.813    -2.528     0.200
    30.820    -1.986     0.200
    30.766     3.878     0.200
    30.766     3.419     0.200
    30.847    -1.599     0.200
    30.864    -2.031     0.200
    30.838     5.363     0.200
    30.846     4.154     0.200
    30.890     2.802     0.200
    30.893     3.011     0.200
    30.964    -2.185     0.200
    30.964    -1.786     0.200
    31.048    -1.589     0.200
    31.071     4.105     0.200
    31.170     2.513     0.200
    31.242     0.911     0.200
    32.151     4.025     0.200
    32.238    -2.015     0.200
    32.238    -1.771     0.200
    32.269     2.988     0.200
    32.385     4.385     0.200
    32.399     3.362     0.200
    32.841     3.770     0.200
    33.482     3.101     0.200
    33.482     2.601     0.200
    35.017     1.639     0.200
    35.614     0.964     0.200
    35.614     1.185     0.200
    35.614     0.585     0.200
    35.873     0.739     0.200
    36.130    -1.113     0.200
    36.716     1.198     0.200
    38.525     0.093     0.200
    39.792    -0.248     0.200
    40.024     1.210     0.200
    40.767    -1.191     0.200
    44.550    -1.900     0.200
    44.550    -1.905     0.200
    49.243     2.451     0.200
    50.241     2.227     0.200
    50.655     2.495     0.200
    52.077     2.124     0.200
    52.521     0.414     0.200
    52.723     0.864     0.200
    52.797     1.058     0.200
    52.908     1.493     0.200
    53.051     1.213     0.200
    53.157    -0.275     0.200
    53.193     1.752     0.200
    53.203     1.034     0.200
    53.403     1.037     0.200
    53.418     1.157     0.200
    53.558     1.007     0.200
    53.992     1.476     0.200
    54.297     0.947     0.200
    54.391    -0.027     0.200
    54.392    -0.090     0.200
    54.392     0.502     0.200
    54.397     1.095     0.200
    54.511     0.980     0.200
    54.578     0.764     0.200
    54.631     0.761     0.200
    54.634    -0.001     0.200
    54.861     0.777     0.200
    54.965     0.262     0.200
    54.975     0.754     0.200
    55.156     0.161     0.200
    55.307     0.989     0.200
    55.472     0.079     0.200
    55.531     0.021     0.200
    55.875     0.133     0.200
    55.886     0.434     0.200
    56.936     1.095     0.200
    57.568     0.340     0.200
    57.568     0.604     0.200
    63.396     1.245     0.200
    63.815     0.988     0.200
    65.089    -0.030     0.200
    65.089     0.300     0.200
    66.549     1.917     0.200
    69.906    -0.367     0.200
    70.938    -1.270     0.200
    77.794     0.266     0.200
    77.794     0.262     0.200
    79.810     0.662     0.200
    80.393     1.048     0.200
    80.394     1.045     0.200
    80.776     0.184     0.200
    81.777     0.851     0.200
    82.261     1.113     0.200
    82.649     1.085     0.200
    82.740     0.911     0.200
    82.874     0.819     0.200
    82.962     1.460     0.200
    82.972     1.610     0.200
    83.030     1.499     0.200
    83.154     0.970     0.200
    83.183     1.621     0.200
    83.183     1.162     0.200
    83.260    -0.979     0.200
    83.231     1.574     0.200
    83.811     1.792     0.200
    84.921     3.965     0.200
    85.118    -0.171     0.200
    85.118    -0.171     0.200
    85.158     0.575     0.200
    85.306     0.906     0.200
    85.306     0.637     0.200
    85.314     0.299     0.200
    85.314     0.270     0.200
    85.314     0.275     0.200
    85.340     1.749     0.200
    85.575     1.049     0.200
    85.575     1.568     0.200
    85.612     0.765     0.200
    86.832    -0.791     0.200
    89.302     0.740     0.200
    90.822    -0.304     0.200
    90.822    -0.304     0.200
    92.928     0.501     0.200
    92.928     0.501     0.200
    92.933     0.230     0.200
    94.360     1.551     0.200
    95.161     1.245     0.200
    95.522    -1.904     0.200
    95.932     0.930     0.200
    96.800     0.391     0.200
    96.800     1.461     0.200
    96.844     0.921     0.200
    15.041     3.733     0.200
    15.843     2.841     0.200
    15.843     2.567     0.200
    16.322     2.530     0.200
    16.322     2.535     0.200
    16.341     2.962     0.200
    16.451     2.926     0.200
    16.683     3.061     0.200
    17.088     3.214     0.200
    17.088     2.870     0.200
    17.088     1.917     0.200
    17.088     3.066     0.200
    17.539     2.379     0.200
    17.581     1.812     0.200
    17.958     0.910     0.200
    18.017     2.888     0.200
    18.110     0.064     0.200
    18.114     3.783     0.200
    18.343    -0.315     0.200
    18.353     0.064     0.200
    18.393    -0.763     0.200
    18.393    -1.075     0.200
    18.348     2.761     0.200
    18.348     2.339     0.200
    18.586    -0.361     0.200
    18.584    -0.200     0.200
    18.599    -0.266     0.200
    18.652    -0.580     0.200
    18.660    -0.385     0.200
    18.718    -0.068     0.200
    18.798    -0.442     0.200
    18.847    -0.754     0.200
    18.984    -0.180     0.200
    19.001    -0.058     0.200
    19.037    -0.439     0.200
    19.044    -0.437     0.200
    19.110    -0.641     0.200
    19.126     0.022     0.200
    19.160    -1.758     0.200
    19.250    -0.007     0.200
    19.407    -0.329     0.200
    19.426    -0.317     0.200
    19.488    -0.667     0.200
    19.502     0.032     0.200
    19.501    -0.668     0.200
    19.554     0.037     0.200
    19.570    -1.346     0.200
    19.553     0.351     0.200
    19.620     0.157     0.200
    19.757     0.176     0.200
    19.790    -0.514     0.200
    19.790    -0.031     0.200
    19.871    -0.466     0.200
    19.893    -0.302     0.200
    19.887     0.579     0.200
    19.929    -0.255     0.200
    19.979    -1.172     0.200
    20.030    -0.277     0.200
    20.045    -0.277     0.200
    20.048    -0.240     0.200
    20.037    -0.208     0.200
    20.044    -0.985     0.200
    20.108    -0.320     0.200
    20.121    -0.600     0.200
    20.147     0.224     0.200
    20.259    -0.321     0.200
    20.263    -0.539     0.200
    20.321    -0.941     0.200
    20.321    -0.801     0.200
    20.350    -0.187     0.200
    20.397    -0.531     0.200
    20.433    -0.816     0.200
    20.459    -1.330     0.200
    20.425     1.322     0.200
    20.488    -0.792     0.200
    20.511    -1.101     0.200
    20.527    -0.414     0.200
    20.539    -0.660     0.200
    20.431     2.988     0.200
    20.600    -0.649     0.200
    20.624    -0.230     0.200
    20.655    -0.259     0.200
    20.647    -0.690     0.200
    20.647    -0.792     0.200
    20.699    -1.033     0.200
    20.736    -0.306     0.200
    20.765    -0.667     0.200
    20.761     0.221     0.200
    20.799    -0.571     0.200
    20.841     0.125     0.200
    20.854     1.070     0.200
    20.896     1.338     0.200
    20.920    -0.432     0.200
    20.913     0.049     0.200
    20.935    -0.688     0.200
    20.990    -0.890     0.200
    21.018    -0.520     0.200
    21.045    -1.185     0.200
    21.004     1.387     0.200
    21.048    -1.501     0.200
    21.084    -0.717     0.200
    21.078    -1.810     0.200
    21.108    -0.702     0.200
    21.133    -1.275     0.200
    21.143    -0.816     0.200
    21.107     2.821     0.200
    21.124     2.404     0.200
    21.124     2.505     0.200
    21.175    -0.853     0.200
    21.203    -1.767     0.200
    21.178     2.887     0.200
    21.185     2.566     0.200
    21.271    -0.643     0.200
    21.253    -1.531     0.200
    21.215     2.296     0.200
    21.215     1.226     0.200
    21.307    -1.214     0.200
    21.286    -1.409     0.200
    21.312     1.309     0.200
    21.295     2.035     0.200
    21.343    -1.132     0.200
    21.337     1.950     0.200
    21.325     2.449     0.200
    21.395    -1.102     0.200
    21.398    -1.477     0.200
    21.388     2.384     0.200
    21.299     2.969     0.200
    21.422    -1.471     0.200
    21.469    -1.122     0.200
    21.451     2.362     0.200
    21.485    -0.863     0.200
    21.476    -1.680     0.200
    21.480    -2.232     0.200
    21.446     1.810     0.200
    21.474     2.525     0.200
    21.504    -1.726     0.200
    21.525    -0.824     0.200
    21.492    -1.353     0.200
    21.523    -1.834     0.200
    21.555    -0.334     0.200
    21.563    -1.337     0.200
    21.514     2.634     0.200
    21.563    -1.775     0.200
    21.594    -1.214     0.200
    21.575     1.368     0.200
    21.634    -1.492     0.200
    21.650    -0.570     0.200
    21.650    -0.320     0.200
    21.673    -0.657     0.200
    21.651    -1.653     0.200
    21.642     2.338     0.200
    21.667     2.464     0.200
    21.667     2.136     0.200
    21.667     1.763     0.200
    21.753    -1.013     0.200
    21.765    -0.513     0.200
    21.746    -1.859     0.200
    21.721     2.282     0.200
    21.766     1.199     0.200
    21.766     0.754     0.200
    21.781    -0.954     0.200
    21.763    -1.864     0.200
    21.810     2.260     0.200
    21.782     1.785     0.200
    21.713     2.719     0.200
    21.858    -1.082     0.200
    21.899     1.408     0.200
    21.928    -1.042     0.200
    21.950    -1.117     0.200
    21.938    -2.159     0.200
    21.928    -2.012     0.200
    21.947    -1.794     0.200
    21.987    -1.602     0.200
    21.975    -2.178     0.200
    21.975    -2.077     0.200
    21.992    -1.245     0.200
    21.967     1.789     0.200
    21.971     0.359     0.200
    22.004    -1.763     0.200
    22.022    -0.922     0.200
    21.973    -0.516     0.200
    22.024    -2.354     0.200
    22.062    -1.484     0.200
    22.077    -1.468     0.200
    22.076     1.440     0.200
    22.061     2.271     0.200
    22.064     1.935     0.200
    22.110    -1.998     0.200
    22.110    -0.530     0.200
    22.095     2.234     0.200
    22.148    -1.354     0.200
    22.134    -2.350     0.200
    22.181    -0.776     0.200
    22.132     1.893     0.200
    22.157     2.568     0.200
    22.157     1.583     0.200
    22.207    -2.327     0.200
    22.269    -1.321     0.200
    22.308    -1.383     0.200
    22.285     1.690     0.200
    22.323    -1.146     0.200
    22.326    -1.714     0.200
    22.283     1.796     0.200
    22.287     2.383     0.200
    22.287     1.781     0.200
    22.368    -1.017     0.200
    22.368    -1.884     0.200
    22.383    -1.582     0.200
    22.364    -2.113     0.200
    22.356    -1.658     0.200
    22.388    -1.685     0.200
    22.388    -2.200     0.200
    22.368     1.108     0.200
    22.396    -0.628     0.200
    22.389     1.440     0.200
    22.449    -1.754     0.200
    22.441     1.954     0.200
    22.451     1.359     0.200
    22.451     1.242     0.200
    22.460    -2.675     0.200
    22.464    -2.914     0.200
    22.488    -2.728     0.200
    22.524    -1.242     0.200
    22.498     2.076     0.200
    22.529    -1.673     0.200
    22.537    -0.242     0.200
    22.608    -1.105     0.200
    22.645    -1.828     0.200
    22.631    -2.429     0.200
    22.629    -1.072     0.200
    22.665    -1.213     0.200
    22.647     1.405     0.200
    22.671    -0.624     0.200
    22.682    -1.394     0.200
    22.662    -1.796     0.200
    22.660     2.101     0.200
    22.700     1.779     0.200
    22.743    -1.443     0.200
    22.729     2.230     0.200
    22.767    -2.363     0.200
    22.773    -2.439     0.200
    22.797     0.501     0.200
    22.797     0.314     0.200
    22.754     2.393     0.200
    22.874    -1.174     0.200
    22.882     0.381     0.200
    22.882     1.374     0.200
    22.909    -1.945     0.200
    22.918    -1.801     0.200
    22.921    -0.932     0.200
    22.953    -1.869     0.200
    22.957    -1.457     0.200
    22.901     2.344     0.200
    22.963    -2.908     0.200
    22.983    -2.530     0.200
    23.054    -1.089     0.200
    23.023     1.715     0.200
    23.023     1.387     0.200
    23.064    -0.718     0.200
    23.081    -1.356     0.200
    23.071    -1.725     0.200
    23.100    -1.414     0.200
    23.119     1.020     0.200
    23.151    -1.478     0.200
    23.176    -1.917     0.200
    23.190     1.557     0.200
    23.219    -1.277     0.200
    23.181     1.993     0.200
    23.243     1.267     0.200
    23.207     2.556     0.200
    23.274    -1.567     0.200
    23.276    -1.555     0.200
    23.341    -0.873     0.200
    23.359    -1.561     0.200
    23.363    -2.057     0.200
    23.389    -1.524     0.200
    23.339     0.769     0.200
    23.386     1.169     0.200
    23.418    -1.854     0.200
    23.394     1.639     0.200
    23.431    -1.398     0.200
    23.417    -2.596     0.200
    23.450    -1.238     0.200
    23.491    -3.196     0.200
    23.509    -2.977     0.200
    23.549    -0.852     0.200
    23.604    -0.182     0.200
    23.604    -0.378     0.200
    23.615     0.379     0.200
    23.644    -1.717     0.200
    23.635     1.315     0.200
    23.668    -0.979     0.200
    23.676     0.792     0.200
    23.756    -1.100     0.200
    23.781     0.836     0.200
    23.810    -1.194     0.200
    23.812     0.534     0.200
    23.843    -0.901     0.200
    23.844    -1.484     0.200
    23.854    -1.101     0.200
    23.798     2.794     0.200
    23.884    -1.462     0.200
    23.888    -0.905     0.200
    23.920    -0.330     0.200
    23.947    -1.182     0.200
    23.965    -0.369     0.200
    23.958     2.711     0.200
    24.018    -0.968     0.200
    24.041    -1.606     0.200
    23.997     1.483     0.200
    23.995     2.330     0.200
    24.087     1.289     0.200
    24.114    -0.344     0.200
    24.119    -0.599     0.200
    24.120    -2.005     0.200
    24.116     1.293     0.200
    24.157    -1.140     0.200
    24.119     2.159     0.200
    24.209    -0.023     0.200
    24.097     1.585     0.200
    24.097     1.015     0.200
    24.246     2.251     0.200
    24.293    -1.208     0.200
    24.296    -1.153     0.200
    24.310    -0.730     0.200
    24.315     2.456     0.200
    24.315     2.424     0.200
    24.379    -1.680     0.200
    24.368     1.276     0.200
    24.396    -0.925     0.200
    24.420    -1.162     0.200
    24.421    -0.962     0.200
    24.363     2.306     0.200
    24.453    -0.367     0.200
    24.453    -0.698     0.200
    24.435     0.964     0.200
    24.471    -1.208     0.200
    24.471    -2.606     0.200
    24.483    -0.631     0.200
    24.487    -0.911     0.200
    24.525     1.003     0.200
    24.549     0.429     0.200
    24.513     1.507     0.200
    24.586     0.616     0.200
    24.578     2.385     0.200
    24.657    -1.205     0.200
    24.669    -1.435     0.200
    24.680     0.516     0.200
    24.680     0.134     0.200
    24.706    -0.906     0.200
    24.710    -1.088     0.200
    24.716     0.206     0.200
    24.728    -1.333     0.200
    24.673     2.223     0.200
    24.667     2.916     0.200
    24.714     2.388     0.200
    24.764    -0.418     0.200
    24.754     1.095     0.200
    24.778    -1.103     0.200
    24.752     1.532     0.200
    24.826    -1.297     0.200
    24.769     1.457     0.200
    24.823     2.458     0.200
    24.857    -0.250     0.200
    24.871    -1.031     0.200
    24.817     2.265     0.200
    24.954    -0.639     0.200
    24.957    -0.317     0.200
    24.895     2.137     0.200
    24.932     2.683     0.200
    25.051    -1.226     0.200
    25.071    -1.205     0.200
    25.096    -1.001     0.200
    25.077    -0.279     0.200
    25.101    -1.399     0.200
    25.101    -1.032     0.200
    25.114    -0.596     0.200
    25.124    -1.192     0.200
    25.152    -0.807     0.200
    25.176    -1.063     0.200
    25.202    -0.530     0.200
    25.152     1.786     0.200
    25.207    -0.690     0.200
    25.195    -1.428     0.200
    25.219    -1.324     0.200
    25.234    -1.334     0.200
    25.253    -0.989     0.200
    25.243     0.088     0.200
    25.243    -1.256     0.200
    25.243     0.174     0.200
    25.243     0.104     0.200
    25.243    -0.240     0.200
    25.120     1.667     0.200
    25.288    -1.131     0.200
    25.290    -1.427     0.200
    25.307    -1.115     0.200
    25.307    -2.021     0.200
    25.324    -0.577     0.200
    25.377    -0.274     0.200
    25.389    -0.886     0.200
    25.414    -0.508     0.200
    25.415    -1.016     0.200
    25.383     2.165     0.200
    25.441    -1.055     0.200
    25.458     1.930     0.200
    25.514    -0.469     0.200
    25.525    -1.372     0.200
    25.573    -0.491     0.200
    25.566     0.144     0.200
    25.622    -1.559     0.200
    25.622    -1.372     0.200
    25.656    -0.711     0.200
    25.662    -1.209     0.200
    25.691    -1.215     0.200
    25.647     2.486     0.200
    25.710    -1.274     0.200
    25.757    -1.217     0.200
    25.711     3.119     0.200
    25.805    -0.525     0.200
    25.838    -1.405     0.200
    25.881    -1.485     0.200
    25.838     2.432     0.200
    25.904    -1.474     0.200
    25.962    -1.378     0.200
    25.966    -1.419     0.200
    25.976     0.490     0.200
    25.976    -0.166     0.200
    26.035    -1.139     0.200
    26.077    -1.157     0.200
    26.077    -1.837     0.200
    26.079     0.463     0.200
    26.054     2.046     0.200
    26.120    -0.884     0.200
    26.120    -1.157     0.200
    26.130    -0.436     0.200
    26.159    -1.674     0.200
    26.171    -1.603     0.200
    26.153     0.842     0.200
    26.194    -1.105     0.200
    26.222     0.588     0.200
    26.270    -0.829     0.200
    26.274    -1.909     0.200
    26.274    -1.283     0.200
    26.265     0.499     0.200
    26.369    -1.231     0.200
    26.388    -1.517     0.200
    26.392    -1.718     0.200
    26.394    -1.033     0.200
    26.380     0.342     0.200
    26.347     1.307     0.200
    26.425    -0.321     0.200
    26.435     2.348     0.200
    26.491    -0.650     0.200
    26.497    -1.649     0.200
    26.503    -1.542     0.200
    26.551    -0.840     0.200
    26.552    -0.821     0.200
    26.580    -0.677     0.200
    26.528     2.606     0.200
    26.608     0.503     0.200
    26.655    -1.797     0.200
    26.665    -1.781     0.200
    26.558     2.138     0.200
    26.696    -1.669     0.200
    26.741    -0.503     0.200
    26.778     2.380     0.200
    26.830    -1.192     0.200
    26.893    -1.995     0.200
    26.903    -1.985     0.200
    26.923    -1.191     0.200
    26.937     0.988     0.200
    26.940     0.968     0.200
    26.988    -1.499     0.200
    26.939     2.121     0.200
    27.020    -1.029     0.200
    27.010     1.070     0.200
    27.068    -1.227     0.200
    27.116     1.923     0.200
    27.138    -0.214     0.200
    27.173    -0.918     0.200
    27.184    -2.035     0.200
    27.201    -1.297     0.200
    27.214    -1.632     0.200
    27.193     1.332     0.200
    27.193     1.027     0.200
    27.239    -1.236     0.200
    27.257    -1.627     0.200
    27.320     1.669     0.200
    27.348    -1.178     0.200
    27.351     0.838     0.200
    27.372    -1.451     0.200
    27.389    -1.299     0.200
    27.431    -1.573     0.200
    27.442     0.981     0.200
    27.453    -1.450     0.200
    27.467    -1.579     0.200
    27.469    -1.138     0.200
    27.471    -0.946     0.200
    27.476     0.072     0.200
    27.495    -1.841     0.200
    27.478     0.558     0.200
    27.482     1.432     0.200
    27.511     1.222     0.200
    27.569    -1.524     0.200
    27.604     1.406     0.200
    27.537     1.561     0.200
    27.720    -1.159     0.200
    27.733    -1.383     0.200
    27.741    -1.537     0.200
    27.714     1.488     0.200
    27.754    -1.084     0.200
    27.959    -1.389     0.200
    27.968    -1.339     0.200
    27.973    -1.110     0.200
    27.986    -1.956     0.200
    27.986    -1.831     0.200
    28.027    -1.282     0.200
    28.027    -1.602     0.200
    28.000     2.006     0.200
    28.043    -1.732     0.200
    27.990     1.740     0.200
    28.073     0.067     0.200
    28.123    -0.751     0.200
    28.131    -1.649     0.200
    28.134    -1.188     0.200
    28.042     1.746     0.200
    28.193     0.226     0.200
    28.220    -1.686     0.200
    28.255    -0.999     0.200
    28.308    -1.292     0.200
    28.308    -1.425     0.200
    28.350    -1.638     0.200
    28.350    -1.466     0.200
    28.358    -1.420     0.200
    28.372     1.368     0.200
    28.377     0.935     0.200
    28.377     0.826     0.200
    28.424     1.770     0.200
    28.469    -1.364     0.200
    28.434     1.729     0.200
    28.447     0.204     0.200
    28.545    -1.364     0.200
    28.551    -1.211     0.200
    28.578    -0.999     0.200
    28.514     1.062     0.200
    28.656    -0.472     0.200
    28.656     0.012     0.200
    28.624     1.645     0.200
    28.698    -1.640     0.200
    28.699    -0.862     0.200
    28.779    -1.347     0.200
    28.772     0.943     0.200
    28.839    -1.227     0.200
    28.843    -1.394     0.200
    28.862    -1.392     0.200
    28.719     0.994     0.200
    28.831     0.584     0.200
    28.913    -1.610     0.200
    28.920     1.825     0.200
    28.975    -1.415     0.200
    28.982    -1.207     0.200
    29.002    -1.191     0.200
    29.014    -1.268     0.200
    29.037    -1.265     0.200
    29.012     0.243     0.200
    29.067    -1.248     0.200
    29.028     2.172     0.200
    29.111    -1.517     0.200
    29.186    -1.061     0.200
    29.202    -0.785     0.200
    29.219    -1.407     0.200
    29.255    -0.883     0.200
    29.270    -1.424     0.200
    29.232     1.747     0.200
    29.145     1.315     0.200
    29.280     0.510     0.200
    29.219     3.982     0.200
    29.219     3.013     0.200
    29.346    -1.975     0.200
    29.346    -1.507     0.200
    29.378    -1.147     0.200
    29.381    -1.648     0.200
    29.275     1.342     0.200
    29.399    -1.761     0.200
    29.439    -0.652     0.200
    29.460    -1.267     0.200
    29.458    -0.896     0.200
    29.437     1.141     0.200
    29.468    -1.448     0.200
    29.489    -1.795     0.200
    29.482     0.440     0.200
    29.498    -1.598     0.200
    29.526    -2.033     0.200
    29.516     1.193     0.200
    29.558    -1.693     0.200
    29.556    -1.302     0.200
    29.614    -1.569     0.200
    29.628    -0.576     0.200
    29.658    -1.598     0.200
    29.544     1.314     0.200
    29.705    -1.147     0.200
    29.723    -1.270     0.200
    29.777    -2.036     0.200
    29.690     1.189     0.200
    29.810    -0.688     0.200
    29.810    -0.500     0.200
    29.827    -1.386     0.200
    29.794     1.350     0.200
    29.790     0.854     0.200
    29.874    -1.401     0.200
    29.778     4.243     0.200
    29.876     1.961     0.200
    29.929    -1.550     0.200
    29.934    -0.782     0.200
    29.954    -1.430     0.200
    29.987    -2.221     0.200
    29.987    -0.862     0.200
    30.014    -1.157     0.200
    29.883     4.216     0.200
    29.883     3.591     0.200
    29.987     2.220     0.200
    30.074     0.418     0.200
    29.967     6.570     0.200
    30.104    -1.587     0.200
    30.122    -1.172     0.200
    30.126    -1.934     0.200
    30.075    -0.065     0.200
    30.030     2.291     0.200
    30.013     3.030     0.200
    30.170    -1.452     0.200
    30.130     2.618     0.200
    30.186    -1.592     0.200
    30.210    -1.603     0.200
    30.211    -1.417     0.200
    30.085     2.391     0.200
    30.112     2.151     0.200
    30.255    -1.142     0.200
    30.264    -1.352     0.200
    30.241     0.357     0.200
    30.139     3.676     0.200
    30.248     0.989     0.200
    30.188     2.649     0.200
    30.435    -1.787     0.200
    30.289     2.353     0.200
    30.404     1.778     0.200
    30.444     1.126     0.200
    30.492    -1.588     0.200
    30.492    -1.346     0.200
    30.361     3.473     0.200
    30.394     1.421     0.200
    30.508    -2.078     0.200
    30.565    -1.638     0.200
    30.566    -0.631     0.200
    30.539     1.292     0.200
    30.470     1.915     0.200
    30.461     3.172     0.200
    30.608    -1.567     0.200
    30.526     1.420     0.200
    30.678    -0.931     0.200
    30.675    -1.934     0.200
    30.675    -2.059     0.200
    30.681    -0.638     0.200
    30.699    -0.811     0.200
    30.665     1.714     0.200
    30.727    -1.116     0.200
    30.748    -1.369     0.200
    30.748    -1.119     0.200
    30.803     1.563     0.200
    30.846    -1.549     0.200
    30.873    -1.526     0.200
    30.845     1.169     0.200
    30.915    -2.157     0.200
    30.915    -1.750     0.200
    30.999    -1.518     0.200
    31.023    -1.891     0.200
    30.883     4.947     0.200
    30.883     5.119     0.200
    31.014     0.102     0.200
    31.019    -0.228     0.200
    31.057    -2.000     0.200
    31.063    -1.025     0.200
    30.939     3.170     0.200
    30.939     2.482     0.200
    31.044     1.161     0.200
    31.095    -1.798     0.200
    31.115    -1.478     0.200
    31.121    -0.903     0.200
    30.982     1.502     0.200
    31.125    -2.333     0.200
    31.125    -1.614     0.200
    31.139    -1.642     0.200
    31.121     1.406     0.200
    31.126     1.385     0.200
    31.195    -1.179     0.200
    31.215    -1.426     0.200
    31.221    -1.000     0.200
    31.159     2.895     0.200
    31.313    -0.185     0.200
    31.377    -0.831     0.200
    31.360     1.656     0.200
    31.302     2.798     0.200
    31.397     0.277     0.200
    31.449    -1.647     0.200
    31.467    -1.507     0.200
    31.463     1.891     0.200
    31.388     1.451     0.200
    31.579    -2.016     0.200
    31.516     3.854     0.200
    31.673    -1.317     0.200
    31.731    -1.202     0.200
    31.754    -0.352     0.200
    31.787    -1.244     0.200
    31.813    -1.534     0.200
    31.790     2.619     0.200
    31.932     1.364     0.200
    31.967     5.268     0.200
    32.155     0.477     0.200
    32.196    -2.156     0.200
    32.191    -0.276     0.200
    32.253     0.467     0.200
    32.253    -1.072     0.200
    32.362     2.163     0.200
    32.393     1.865     0.200
    32.411     2.041     0.200
    32.465    -2.133     0.200
    32.364    -0.078     0.200
    32.508     1.617     0.200
    32.545     1.346     0.200
    32.571    -1.502     0.200
    32.571    -1.861     0.200
    32.584    -1.602     0.200
    32.557     1.545     0.200
    32.630    -1.274     0.200
    32.664     1.272     0.200
    32.682     2.271     0.200
    32.652     2.535     0.200
    32.652     0.917     0.200
    32.911     1.878     0.200
    32.986     1.629     0.200
    33.109     2.135     0.200
    33.182    -1.064     0.200
    33.219    -2.227     0.200
    33.217    -1.650     0.200
    33.217    -2.400     0.200
    33.384    -1.120     0.200
    33.473     2.556     0.200
    33.624    -1.990     0.200
    33.776    -1.570     0.200
    33.776    -1.203     0.200
    33.795     0.713     0.200
    33.824     1.480     0.200
    33.903     0.765     0.200
    33.906     2.038     0.200
    33.915     0.766     0.200
    33.949     1.352     0.200
    33.969    -1.167     0.200
    34.017    -0.379     0.200
    34.321     0.800     0.200
    34.460    -1.906     0.200
    34.521     1.481     0.200
    34.558    -1.349     0.200
    34.748     1.383     0.200
    34.908    -1.495     0.200
    34.915     0.374     0.200
    34.915     0.882     0.200
    34.915     0.030     0.200
    35.177     0.556     0.200
    35.292    -1.646     0.200
    35.324    -1.784     0.200
    35.452    -1.281     0.200
    35.525    -2.160     0.200
    35.525    -2.824     0.200
    35.766    -2.336     0.200
    35.809     0.866     0.200
    35.998    -0.401     0.200
    36.069    -2.355     0.200
    36.022     0.185     0.200
    36.151    -1.470     0.200
    36.214    -1.730     0.200
    36.219    -1.752     0.200
    36.295    -0.954     0.200
    36.263     0.309     0.200
    36.386    -1.324     0.200
    36.540    -0.893     0.200
    36.567    -1.546     0.200
    36.580    -0.874     0.200
    36.815    -1.264     0.200
    36.815    -0.896     0.200
    37.180    -1.360     0.200
    37.721     0.009     0.200
    37.721    -1.085     0.200
    37.830    -0.258     0.200
    37.888     2.098     0.200
    38.345    -0.465     0.200
    38.943    -1.238     0.200
    38.943    -0.691     0.200
    39.094    -0.142     0.200
    39.107     0.570     0.200
    39.305    -1.964     0.200
    39.371     1.563     0.200
    39.759    -1.281     0.200
    39.950    -0.302     0.200
    39.969    -1.652     0.200
    40.214     0.817     0.200
    40.341    -0.491     0.200
    40.341    -0.194     0.200
    40.455    -1.147     0.200
    41.135    -1.015     0.200
    41.908     1.920     0.200
    41.908     2.045     0.200
    41.979     4.685     0.200
    43.801     1.863     0.200
    44.946     1.982     0.200
    45.110    -1.164     0.200
    45.368     2.427     0.200
    45.467     4.907     0.200
    45.797     0.297     0.200
    45.863    -1.218     0.200
    46.193     1.328     0.200
    46.710     1.621     0.200
    47.518     0.894     0.200
    47.545     0.041     0.200
    48.243     1.312     0.200
    48.376     1.875     0.200
    48.376     2.422     0.200
    49.257     1.218     0.200
    49.483     1.312     0.200
    49.607     3.047     0.200
    49.613     3.341     0.200
    49.702     3.046     0.200
    49.804     2.134     0.200
    50.847     2.612     0.200
    51.159     1.928     0.200
    51.282    -1.132     0.200
    51.393     2.397     0.200
    51.669     2.253     0.200
    51.805     0.827     0.200
    51.741     2.178     0.200
    51.742     2.602     0.200
    51.742     2.329     0.200
    51.986     2.105     0.200
    52.161     0.898     0.200
    52.196     2.217     0.200
    52.039     2.570     0.200
    52.541     1.934     0.200
    52.811     2.008     0.200
    52.864     1.575     0.200
    53.061     1.841     0.200
    53.209     0.789     0.200
    53.246     2.002     0.200
    53.432     1.253     0.200
    53.516     0.962     0.200
    53.557     1.330     0.200
    53.613     1.581     0.200
    53.761     1.718     0.200
    53.786     0.312     0.200
    53.818     1.700     0.200
    53.919     1.759     0.200
    53.941     1.086     0.200
    53.955     1.524     0.200
    54.129     1.128     0.200
    54.145     0.669     0.200
    54.240     1.658     0.200
    54.282     0.895     0.200
    54.225     2.533     0.200
    54.739     1.115     0.200
    54.905     0.629     0.200
    55.022     1.343     0.200
    55.098     0.683     0.200
    55.098     0.620     0.200
    55.098     0.675     0.200
    55.110     1.173     0.200
    55.149     0.714     0.200
    55.018     2.227     0.200
    55.233     1.145     0.200
    55.344     0.377     0.200
    55.345     0.256     0.200
    55.185     5.344     0.200
    55.493     0.510     0.200
    55.589     1.257     0.200
    55.660     1.167     0.200
    55.674     0.403     0.200
    55.885     0.624     0.200
    56.044     1.071     0.200
    55.956     2.059     0.200
    56.196     0.526     0.200
    56.185     0.602     0.200
    56.264     0.281     0.200
    56.159     1.817     0.200
    56.218     2.006     0.200
    56.375     1.654     0.200
    56.601     0.801     0.200
    56.636     0.490     0.200
    56.788    -1.401     0.200
    56.700     2.277     0.200
    56.995     0.879     0.200
    57.377     1.883     0.200
    57.606    -0.165     0.200
    57.629     1.425     0.200
    57.619     1.645     0.200
    57.790     4.996     0.200
    58.170    -0.274     0.200
    57.988     4.905     0.200
    58.033     5.391     0.200
    58.246     0.917     0.200
    58.494     0.798     0.200
    58.827    -1.056     0.200
    58.827    -0.806     0.200
    58.913     1.903     0.200
    59.182    -1.212     0.200
    59.182    -1.313     0.200
    59.158     2.640     0.200
    59.226     2.054     0.200
    59.446     2.484     0.200
    59.524     2.313     0.200
    59.606     2.116     0.200
    60.047     0.556     0.200
    60.125    -1.013     0.200
    60.022     2.184     0.200
    60.169     2.029     0.200
    60.414     2.029     0.200
    60.648     1.941     0.200
    61.022    -0.686     0.200
    60.880     2.025     0.200
    61.388     1.801     0.200
    61.640    -0.511     0.200
    62.531     1.100     0.200
    62.531     1.202     0.200
    63.526    -0.917     0.200
    64.574     1.052     0.200
    64.770     0.350     0.200
    64.770     0.732     0.200
    65.310     0.218     0.200
    65.310    -0.446     0.200
    65.795     2.235     0.200
    65.795     2.704     0.200
    66.774    -4.190     0.200
    66.835     1.515     0.200
    66.997     1.687     0.200
    67.247     0.893     0.200
    67.294     0.800     0.200
    67.911     1.406     0.200
    67.800     1.572     0.200
    68.183     0.766     0.200
    69.190     0.520     0.200
    69.244     1.783     0.200
    69.344     2.963     0.200
    69.351     1.213     0.200
    69.376     1.366     0.200
    69.629     1.302     0.200
    69.764     0.768     0.200
    69.813     0.168     0.200
    70.078    -0.266     0.200
    70.225     0.462     0.200
    70.805     5.067     0.200
    71.210    -0.662     0.200
    73.620     0.864     0.200
    74.483     1.060     0.200
    76.929     2.022     0.200
    76.975     2.082     0.200
    76.975     1.871     0.200
    77.184     2.892     0.200
    77.219     2.695     0.200
    77.583     1.561     0.200
    78.117     0.619     0.200
    78.117     0.423     0.200
    78.117     0.673     0.200
    78.417     0.334     0.200
    78.585     1.474     0.200
    78.585     1.193     0.200
    78.816     0.673     0.200
    79.190     0.553     0.200
    79.379     0.284     0.200
    79.401     0.679     0.200
    79.457     0.336     0.200
    79.513     0.343     0.200
    79.547     0.556     0.200
    79.555     0.740     0.200
    79.837     0.733     0.200
    79.871     0.728     0.200
    80.025     0.817     0.200
    80.200    -0.403     0.200
    80.285     1.054     0.200
    80.431     0.981     0.200
    80.534     1.003     0.200
    80.581     0.410     0.200
    80.565     1.277     0.200
    80.565     1.426     0.200
    80.641     0.835     0.200
    80.673     0.777     0.200
    80.682     1.064     0.200
    80.714     0.949     0.200
    80.714    -0.449     0.200
    80.733     0.554     0.200
    80.697     1.742     0.200
    80.697     1.321     0.200
    80.776     1.089     0.200
    80.798     0.769     0.200
    80.842     1.077     0.200
    80.997     0.855     0.200
    81.114     1.099     0.200
    81.223    -0.314     0.200
    81.228     0.517     0.200
    81.219     2.107     0.200
    81.219     1.263     0.200
    81.219     1.505     0.200
    81.320     1.145     0.200
    81.482    -0.338     0.200
    81.484     2.129     0.200
    81.489     1.205     0.200
    81.546     1.193     0.200
    81.598     1.126     0.200
    81.736     1.104     0.200
    81.734     1.611     0.200
    81.766     0.789     0.200
    81.786     0.541     0.200
    81.829     0.127     0.200
    81.869     1.699     0.200
    81.886     0.990     0.200
    82.000     1.407     0.200
    82.024     0.422     0.200
    82.051     0.603     0.200
    82.058     1.203     0.200
    82.068     0.761     0.200
    82.068     1.448     0.200
    82.116     1.128     0.200
    82.119     1.182     0.200
    82.155     1.438     0.200
    82.258     0.116     0.200
    82.355     1.047     0.200
    82.406     1.283     0.200
    82.422     1.402     0.200
    82.448     1.314     0.200
    82.462     1.014     0.200
    82.467     0.768     0.200
    82.467     1.135     0.200
    82.463     1.585     0.200
    82.463     1.382     0.200
    82.491     1.415     0.200
    82.547     0.716     0.200
    82.547     1.545     0.200
    82.588     1.748     0.200
    82.554     1.628     0.200
    82.617     0.022     0.200
    82.613     1.201     0.200
    82.627     1.628     0.200
    82.690     1.369     0.200
    82.671     1.502     0.200
    82.681     1.150     0.200
    82.868     1.277     0.200
    82.888     1.173     0.200
    82.921     0.599     0.200
    82.917     1.622     0.200
    82.931     1.450     0.200
    83.018     1.310     0.200
    83.085     1.393     0.200
    83.122     1.070     0.200
    83.114     2.100     0.200
    83.158     0.186     0.200
    83.172     1.677     0.200
    83.229     1.609     0.200
    83.341     1.384     0.200
    83.388     0.971     0.200
    83.392     1.345     0.200
    83.437     1.043     0.200
    83.497     0.946     0.200
    83.508     1.670     0.200
    83.722     0.887     0.200
    83.900     1.273     0.200
    83.909     1.798     0.200
    83.901    -0.046     0.200
    83.933     0.423     0.200
    83.968     1.588     0.200
    84.015     1.188     0.200
    84.015     1.796     0.200
    84.042     2.212     0.200
    84.162     0.436     0.200
    84.236     0.234     0.200
    84.600     1.030     0.200
    84.869     1.640     0.200
    84.942     1.496     0.200
    85.066     1.768     0.200
    85.090     1.187     0.200
    85.093     0.345     0.200
    85.219     0.059     0.200
    85.243     0.647     0.200
    85.304     1.467     0.200
    85.304     1.420     0.200
    85.356     0.349     0.200
    85.342     1.200     0.200
    85.361    -0.169     0.200
    85.361    -0.396     0.200
    85.362     0.604     0.200
    85.362    -0.365     0.200
    85.368     1.190     0.200
    85.368    -0.170     0.200
    85.368     1.354     0.200
    85.374     1.075     0.200
    85.400     0.888     0.200
    85.400     0.638     0.200
    85.429    -0.661     0.200
    85.511     1.641     0.200
    85.575    -0.664     0.200
    85.601     0.388     0.200
    85.461     4.779     0.200
    85.461     3.185     0.200
    85.690     0.766     0.200
    85.728     1.465     0.200
    86.611     0.220     0.200
    86.677     0.881     0.200
    86.687     0.253     0.200
    86.916    -0.600     0.200
    87.316     0.442     0.200
    87.370     0.408     0.200
    87.490     0.773     0.200
    87.529     0.513     0.200
    87.640     0.460     0.200
    88.136     0.878     0.200
    88.648     1.531     0.200
    88.721     0.482     0.200
    88.805    -1.014     0.200
    88.862    -0.369     0.200
    88.862    -1.283     0.200
    89.029    -0.576     0.200
    89.373     0.310     0.200
    90.018     0.234     0.200
    90.018     0.703     0.200
    90.017     1.165     0.200
    90.017     1.009     0.200
    90.154    -0.127     0.200
    90.319     0.859     0.200
    90.491     1.201     0.200
    90.485     0.727     0.200
    90.608     0.555     0.200
    90.979    -0.044     0.200
    90.978    -0.910     0.200
    91.035     1.381     0.200
    91.196     0.424     0.200
    91.196    -0.865     0.200
    91.447     0.963     0.200
    91.499     1.026     0.200
    91.929     0.756     0.200
    92.067     0.778     0.200
    92.314    -0.649     0.200
    92.414     0.911     0.200
    92.450     0.824     0.200
    92.502     1.020     0.200
    92.502     0.879     0.200
    92.621     0.830     0.200
    92.646     0.919     0.200
    92.659    -1.746     0.200
    92.724     0.557     0.200
    92.865     0.455     0.200
    92.865     0.580     0.200
    92.869     0.184     0.200
    92.898     0.951     0.200
    92.955    -0.213     0.200
    93.197     0.517     0.200
    93.234     0.799     0.200
    93.246    -0.756     0.200
    93.486     0.840     0.200
    93.616     0.743     0.200
    93.776     0.974     0.200
    93.776     1.294     0.200
    93.990     0.390     0.200
    93.995     0.500     0.200
    94.009     1.201     0.200
    94.009     1.779     0.200
    94.213     1.296     0.200
    94.256     0.307     0.200
    94.460     1.266     0.200
    94.460     0.055     0.200
    94.629     1.192     0.200
    94.689    -0.927     0.200
    94.689    -0.615     0.200
    94.746     0.757     0.200
    94.687     1.074     0.200
    94.687     1.722     0.200
    94.750     0.488     0.200
    94.777     0.348     0.200
    94.821     0.720     0.200
    94.849     0.146     0.200
    94.912     0.121     0.200
    95.099     0.838     0.200
    95.112     1.677     0.200
    95.116     2.262     0.200
    95.115     0.965     0.200
    95.148    -1.080     0.200
    95.386    -0.026     0.200
    95.386     0.653     0.200
    95.389    -1.138     0.200
    95.418    -0.222     0.200
    95.538     1.028     0.200
    95.607    -0.093     0.200
    95.564     0.894     0.200
    95.564     1.386     0.200
    95.687    -2.246     0.200
    95.746    -2.719     0.200
    95.772     0.971     0.200
    95.847     2.028     0.200
    95.893     1.018     0.200
    96.125     1.089     0.200
    96.232     0.877     0.200
    96.409    -0.528     0.200
    96.540     1.573     0.200
    96.533     0.807     0.200
    96.585     0.970     0.200
    96.617     1.528     0.200
    96.805     2.177     0.200
    96.805     0.677     0.200
    96.805     1.669     0.200
    97.096     2.157     0.200
    97.645    -0.722     0.200
    98.415    -1.785     0.200
    98.873    -0.132     0.200
    99.007    -4.228     0.200
    99.263    -2.471     0.200
    99.381    -1.038     0.200
    99.444    -0.528     0.200
    99.535    -3.478     0.200
    14.641     4.025     0.200
    14.661     6.187     0.200
    14.661     3.921     0.200
    14.674     6.139     0.200
    15.364     5.295     0.200
    15.588     3.901     0.200
    15.588     2.938     0.200
    15.601     4.066     0.200
    15.601     3.349     0.200
    15.928     4.654     0.200
    15.989     5.522     0.200
    16.002     3.004     0.200
    16.148     5.098     0.200
    16.260     3.612     0.200
    16.260     3.077     0.200
    16.319     2.690     0.200
    16.493     2.271     0.200
    16.493     2.054     0.200
    16.569     2.687     0.200
    16.674     2.939     0.200
    16.745     3.301     0.200
    16.745     2.807     0.200
    17.053     3.605     0.200
    17.106     4.136     0.200
    17.474     1.637     0.200
    17.493     2.489     0.200
    17.686     3.059     0.200
    17.807     3.396     0.200
    18.183     3.691     0.200
    18.219     2.711     0.200
    18.219     2.912     0.200
    18.236     4.066     0.200
    18.320    -0.444     0.200
    18.353    -0.446     0.200
    18.353    -0.330     0.200
    18.436    -0.672     0.200
    18.716    -0.826     0.200
    18.716    -0.932     0.200
    18.771    -0.521     0.200
    18.810    -0.331     0.200
    18.810    -0.570     0.200
    18.814    -0.230     0.200
    18.870    -0.921     0.200
    18.908    -0.255     0.200
    18.908    -0.808     0.200
    19.097     3.368     0.200
    19.180    -0.369     0.200
    19.196    -0.482     0.200
    19.205     0.103     0.200
    19.205    -0.754     0.200
    19.300     0.798     0.200
    19.315    -0.529     0.200
    19.415     0.629     0.200
    19.462     0.192     0.200
    19.462    -0.386     0.200
    19.522    -0.746     0.200
    19.551     1.385     0.200
    19.553     0.061     0.200
    19.553    -0.301     0.200
    19.611    -0.415     0.200
    19.632     0.215     0.200
    19.711    -0.802     0.200
    19.711    -0.107     0.200
    19.681    -0.603     0.200
    19.686     0.722     0.200
    19.686    -0.428     0.200
    19.781    -0.491     0.200
    19.824     0.586     0.200
    19.824    -0.162     0.200
    19.830    -0.342     0.200
    19.909    -0.803     0.200
    19.973    -0.444     0.200
    20.060    -0.660     0.200
    20.104    -0.517     0.200
    20.111    -0.794     0.200
    20.208     1.351     0.200
    20.247    -0.737     0.200
    20.259     1.466     0.200
    20.280     0.887     0.200
    20.289    -1.066     0.200
    20.311     1.855     0.200
    20.303    -0.780     0.200
    20.311    -0.619     0.200
    20.312     1.227     0.200
    20.336    -1.496     0.200
    20.378     1.475     0.200
    20.382     1.530     0.200
    20.430     1.139     0.200
    20.446     1.571     0.200
    20.459     1.830     0.200
    20.462     0.058     0.200
    20.469    -1.011     0.200
    20.486     1.184     0.200
    20.528     1.643     0.200
    20.534     0.482     0.200
    20.603     0.482     0.200
    20.620     0.351     0.200
    20.638     1.067     0.200
    20.671     1.345     0.200
    20.662    -1.073     0.200
    20.677    -0.205     0.200
    20.677    -1.117     0.200
    20.675    -1.041     0.200
    20.687    -0.436     0.200
    20.687    -0.876     0.200
    20.700     1.278     0.200
    20.719    -0.958     0.200
    20.741    -0.847     0.200
    20.740    -1.376     0.200
    20.865    -0.263     0.200
    20.865    -0.597     0.200
    20.919    -0.278     0.200
    20.954    -0.311     0.200
    20.986     1.976     0.200
    20.980     1.612     0.200
    20.987    -0.601     0.200
    21.005    -1.279     0.200
    21.033     1.641     0.200
    21.066    -0.715     0.200
    21.109    -0.858     0.200
    21.175     2.369     0.200
    21.233    -1.121     0.200
    21.267    -1.193     0.200
    21.270    -0.529     0.200
    21.270    -1.593     0.200
    21.334    -0.282     0.200
    21.334    -1.028     0.200
    21.339    -1.069     0.200
    21.343    -2.045     0.200
    21.345    -1.088     0.200
    21.442    -0.199     0.200
    21.463     1.522     0.200
    21.491    -1.500     0.200
    21.523     2.084     0.200
    21.533     1.260     0.200
    21.551    -0.682     0.200
    21.557     1.079     0.200
    21.613    -0.646     0.200
    21.613    -1.128     0.200
    21.644     2.812     0.200
    21.644     2.267     0.200
    21.654    -1.719     0.200
    21.699    -0.818     0.200
    21.699    -1.078     0.200
    21.710     0.025     0.200
    21.734     2.903     0.200
    21.734     2.579     0.200
    21.747     2.787     0.200
    21.757    -2.048     0.200
    21.774    -1.105     0.200
    21.772    -0.430     0.200
    21.772    -1.190     0.200
    21.780    -0.705     0.200
    21.780    -2.098     0.200
    21.800    -1.526     0.200
    21.925     2.918     0.200
    22.018    -1.194     0.200
    22.037     2.448     0.200
    22.023    -0.895     0.200
    22.099     1.366     0.200
    22.099     0.354     0.200
    22.120     1.916     0.200
    22.105    -0.506     0.200
    22.125    -1.678     0.200
    22.152    -0.953     0.200
    22.152    -1.563     0.200
    22.198     2.853     0.200
    22.204     1.637     0.200
    22.223    -1.230     0.200
    22.230    -1.054     0.200
    22.258    -1.898     0.200
    22.330     2.430     0.200
    22.321    -1.651     0.200
    22.360    -1.444     0.200
    22.406    -0.910     0.200
    22.406    -1.361     0.200
    22.475    -1.540     0.200
    22.509    -1.409     0.200
    22.534     2.111     0.200
    22.534     1.980     0.200
    22.518    -1.400     0.200
    22.525    -1.625     0.200
    22.555    -1.979     0.200
    22.574     1.252     0.200
    22.574    -0.244     0.200
    22.644    -1.302     0.200
    22.661    -1.404     0.200
    22.661    -1.366     0.200
    22.699    -1.717     0.200
    22.704    -1.008     0.200
    22.786    -1.781     0.200
    22.949     0.236     0.200
    22.970    -1.164     0.200
    23.050    -1.749     0.200
    23.160    -2.079     0.200
    23.173    -1.925     0.200
    23.176    -1.880     0.200
    23.203     2.416     0.200
    23.203     1.047     0.200
    23.212    -1.305     0.200
    23.212    -1.795     0.200
    23.247    -2.290     0.200
    23.292    -2.291     0.200
    23.299    -1.533     0.200
    23.299    -1.986     0.200
    23.337    -0.981     0.200
    23.337    -1.352     0.200
    23.371     0.437     0.200
    23.361    -1.647     0.200
    23.423     0.822     0.200
    23.427    -1.858     0.200
    23.438    -2.355     0.200
    23.438    -2.505     0.200
    23.461    -1.081     0.200
    23.493     2.339     0.200
    23.516    -2.120     0.200
    23.547     2.420     0.200
    23.526    -1.768     0.200
    23.552    -1.252     0.200
    23.552    -1.608     0.200
    23.615    -1.656     0.200
    23.654    -1.922     0.200
    23.727     1.723     0.200
    23.755    -1.606     0.200
    23.795     2.217     0.200
    23.795     2.656     0.200
    23.778    -2.022     0.200
    23.810    -1.581     0.200
    23.857    -1.651     0.200
    23.862    -1.924     0.200
    23.940     1.615     0.200
    23.944    -1.455     0.200
    23.950    -1.401     0.200
    23.989    -1.118     0.200
    23.994    -0.748     0.200
    24.028    -1.655     0.200
    24.085    -1.383     0.200
    24.123    -1.828     0.200
    24.138    -0.727     0.200
    24.138    -1.612     0.200
    24.201     2.110     0.200
    24.186    -1.498     0.200
    24.228    -1.453     0.200
    24.261    -1.593     0.200
    24.262    -1.231     0.200
    24.311    -1.735     0.200
    24.324    -1.104     0.200
    24.324    -1.573     0.200
    24.370    -0.131     0.200
    24.379    -1.019     0.200
    24.400     2.637     0.200
    24.396    -1.280     0.200
    24.396    -1.723     0.200
    24.431    -1.397     0.200
    24.466    -0.633     0.200
    24.479    -1.463     0.200
    24.525     1.413     0.200
    24.506    -0.795     0.200
    24.506    -0.467     0.200
    24.590    -1.029     0.200
    24.610    -1.664     0.200
    24.660     1.952     0.200
    24.680     2.252     0.200
    24.678    -0.929     0.200
    24.722    -1.168     0.200
    24.818    -1.452     0.200
    24.818    -1.562     0.200
    24.830    -1.621     0.200
    24.833    -0.807     0.200
    24.846    -2.200     0.200
    24.882     1.327     0.200
    24.882     0.468     0.200
    24.882     1.539     0.200
    24.882     0.838     0.200
    24.882     0.527     0.200
    24.902    -0.499     0.200
    24.902    -1.349     0.200
    24.904    -2.207     0.200
    24.935     2.124     0.200
    24.970     1.637     0.200
    25.044    -1.302     0.200
    25.121     2.534     0.200
    25.125    -1.739     0.200
    25.175    -0.858     0.200
    25.205    -1.137     0.200
    25.209    -0.916     0.200
    25.209    -1.057     0.200
    25.255    -1.755     0.200
    25.297    -0.367     0.200
    25.319     2.164     0.200
    25.325    -1.567     0.200
    25.334    -1.638     0.200
    25.347    -1.606     0.200
    25.363    -1.617     0.200
    25.367    -1.238     0.200
    25.513     1.786     0.200
    25.529    -1.549     0.200
    25.551    -1.375     0.200
    25.552    -1.224     0.200
    25.679    -0.943     0.200
    25.701     0.849     0.200
    25.713     1.273     0.200
    25.713    -0.594     0.200
    25.717    -0.498     0.200
    25.778     0.862     0.200
    25.788    -1.077     0.200
    25.844     0.704     0.200
    25.860    -1.070     0.200
    25.874    -1.526     0.200
    25.874    -1.755     0.200
    25.892     1.375     0.200
    25.909     2.577     0.200
    25.991     0.109     0.200
    26.001     0.158     0.200
    25.993    -1.427     0.200
    26.012    -2.051     0.200
    26.019    -2.752     0.200
    26.051     2.078     0.200
    26.215    -1.647     0.200
    26.238     2.204     0.200
    26.324    -2.195     0.200
    26.600    -2.229     0.200
    26.689    -1.555     0.200
    26.695    -2.214     0.200
    26.767     0.549     0.200
    26.767     0.128     0.200
    26.864    -2.352     0.200
    26.947     0.753     0.200
    26.978    -0.925     0.200
    26.978    -1.179     0.200
    27.003    -1.795     0.200
    27.081    -1.534     0.200
    27.081    -1.667     0.200
    27.229     1.422     0.200
    27.233    -1.923     0.200
    27.364    -0.239     0.200
    27.456    -1.571     0.200
    27.521    -1.683     0.200
    27.653    -1.867     0.200
    27.676    -1.813     0.200
    27.720    -2.503     0.200
    27.949     1.170     0.200
    28.002     0.001     0.200
    28.102     0.549     0.200
    28.418    -2.465     0.200
    28.485    -1.690     0.200
    28.831     0.647     0.200
    28.927     2.239     0.200
    29.014     1.278     0.200
    29.675     1.324     0.200
    29.785     0.707     0.200
    29.911     0.981     0.200
    29.937     1.073     0.200
    29.962    -2.304     0.200
    30.042    -0.711     0.200
    30.042    -0.131     0.200
    30.064     0.512     0.200
    30.064    -1.248     0.200
    30.154     1.662     0.200
    30.145    -2.120     0.200
    30.287     0.991     0.200
    30.538    -0.789     0.200
    30.538    -1.481     0.200
    30.832    -1.949     0.200
    30.858    -1.829     0.200
    31.228     1.708     0.200
    32.083     1.701     0.200
    32.218     0.608     0.200
    32.431    -1.125     0.200
    32.776    -1.997     0.200
    33.222     0.511     0.200
    33.300     2.251     0.200
    33.399    -1.670     0.200
    33.443     0.596     0.200
    37.421    -1.399     0.200
    44.507     1.980     0.200
    44.784    -0.243     0.200
    48.196     0.033     0.200
    48.993     1.000     0.200
    48.993     2.291     0.200
    51.509     1.586     0.200
    51.712     1.748     0.200
    51.725     0.881     0.200
    52.062     1.538     0.200
    52.122     2.049     0.200
    52.334     1.973     0.200
    52.444     1.029     0.200
    52.594     0.028     0.200
    52.651     0.385     0.200
    52.773     0.452     0.200
    52.978     1.449     0.200
    53.053     1.228     0.200
    53.080     1.900     0.200
    53.162     1.575     0.200
    53.306     1.532     0.200
    53.391     1.890     0.200
    53.402    -0.017     0.200
    53.402     0.378     0.200
    53.451     1.195     0.200
    53.460     0.999     0.200
    53.639     1.189     0.200
    53.660     1.022     0.200
    53.675     1.243     0.200
    53.814     1.196     0.200
    54.249     1.319     0.200
    54.449     0.654     0.200
    54.449     0.420     0.200
    54.553     1.108     0.200
    54.646     0.395     0.200
    54.646     0.526     0.200
    54.646     0.494     0.200
    54.767     1.035     0.200
    54.836     1.059     0.200
    54.886     0.313     0.200
    54.889    -0.097     0.200
    55.039     0.809     0.200
    55.042     0.083     0.200
    55.117     1.084     0.200
    55.208     0.838     0.200
    55.220     0.483     0.200
    55.227     1.122     0.200
    55.563     1.018     0.200
    55.728     0.318     0.200
    55.788     0.355     0.200
    56.141     0.715     0.200
    57.189     1.529     0.200
    57.712    -0.324     0.200
    57.819     0.799     0.200
    57.819     0.483     0.200
    61.851     0.651     0.200
    63.145     0.104     0.200
    63.145     0.973     0.200
    65.256     0.293     0.200
    71.116    -1.302     0.200
    77.984     0.358     0.200
    80.651     1.461     0.200
    80.653     1.704     0.200
    80.653     1.454     0.200
    80.653     1.704     0.200
    82.182     1.453     0.200
    82.298     1.242     0.200
    82.774     0.763     0.200
    82.774     1.122     0.200
    82.912     1.347     0.200
    83.507     0.463     0.200
    85.290     0.758     0.200
    85.290     0.762     0.200
    85.290     1.328     0.200
    85.374     1.682     0.200
    85.434     2.169     0.200
    85.448     0.251     0.200
    85.448     0.620     0.200
    85.448     0.626     0.200
    85.609     1.421     0.200
    85.647     1.190     0.200
    92.207     0.142     0.200
    93.023     0.405     0.200
    96.034     0.877     0.200
    96.945     1.310     0.200
    13.842     4.896     0.200
    14.431     5.160     0.200
    16.839     1.979     0.200
    16.888     1.952     0.200
    17.347     3.305     0.200
    17.791     1.495     0.200
    18.476    -0.245     0.200
    18.901    -1.117     0.200
    19.097     0.848     0.200
    19.179    -0.915     0.200
    19.410     0.184     0.200
    19.446     1.791     0.200
    19.449     1.510     0.200
    19.921    -1.971     0.200
    20.243    -0.268     0.200
    20.454     1.070     0.200
    20.510    -0.426     0.200
    20.524    -0.956     0.200
    20.551     0.710     0.200
    20.572     0.546     0.200
    20.574    -0.823     0.200
    20.606     1.835     0.200
    20.678     0.694     0.200
    20.685     0.595     0.200
    20.766     2.284     0.200
    20.779     2.294     0.200
    20.795     2.169     0.200
    20.993    -0.925     0.200
    21.056     0.547     0.200
    21.241    -1.091     0.200
    21.281     0.371     0.200
    21.286     2.262     0.200
    21.762     1.687     0.200
    22.027     1.200     0.200
    23.513    -0.309     0.200
    24.122     1.558     0.200
    24.171     1.185     0.200
    24.193     1.288     0.200
    24.193     3.171     0.200
    24.455     1.412     0.200
    24.583     1.945     0.200
    25.002     0.182     0.200
    25.002     0.580     0.200
    25.346     2.372     0.200
    32.246    -1.684     0.200
    44.847    -1.450     0.200
    53.310     0.333     0.200
    53.555    -0.623     0.200
    54.914     0.366     0.200
    54.915     0.396     0.200
    54.915     0.920     0.200
    55.420     0.652     0.200
    80.415     1.487     0.200
    81.137     1.365     0.200
    81.139     1.365     0.200
    83.676    -0.154     0.200
    84.997    -1.650     0.200
    15.020     3.237     0.200
    15.564     2.171     0.200
    15.672     3.147     0.200
    15.672     2.553     0.200
    15.704     3.186     0.200
    15.770     3.021     0.200
    16.466     3.068     0.200
    16.466     3.396     0.200
    16.466     2.756     0.200
    16.570     2.029     0.200
    16.687     2.044     0.200
    16.782     2.728     0.200
    17.154     2.759     0.200
    17.276     3.110     0.200
    17.276     2.384     0.200
    17.437     2.001     0.200
    17.681     0.921     0.200
    17.805     2.515     0.200
    17.854     1.651     0.200
    17.854     2.628     0.200
    17.861     2.810     0.200
    18.132     2.955     0.200
    18.132     2.729     0.200
    18.135     2.252     0.200
    18.143     1.674     0.200
    18.160     2.973     0.200
    18.158     0.936     0.200
    18.255    -0.415     0.200
    18.369    -1.267     0.200
    18.369    -1.455     0.200
    18.661    -0.899     0.200
    18.696    -0.333     0.200
    18.728    -0.171     0.200
    18.781    -0.223     0.200
    18.831     0.085     0.200
    18.831    -0.063     0.200
    19.033    -0.737     0.200
    19.128     0.418     0.200
    19.168    -1.075     0.200
    19.385     0.044     0.200
    19.498    -0.471     0.200
    19.498    -0.189     0.200
    19.575    -0.173     0.200
    19.657     0.419     0.200
    19.705    -0.328     0.200
    19.735    -1.596     0.200
    19.735     0.131     0.200
    19.743     0.242     0.200
    19.853    -0.905     0.200
    19.853    -0.085     0.200
    19.856    -1.126     0.200
    19.926    -1.046     0.200
    20.014     1.282     0.200
    20.080     0.515     0.200
    20.092     1.189     0.200
    20.164    -0.239     0.200
    20.213    -0.830     0.200
    20.235     0.780     0.200
    20.347     1.536     0.200
    20.362    -1.572     0.200
    20.362    -0.931     0.200
    20.381    -1.052     0.200
    20.395     0.326     0.200
    20.395     0.834     0.200
    20.450    -0.127     0.200
    20.452    -0.752     0.200
    20.490    -0.686     0.200
    20.490    -0.061     0.200
    20.612    -0.564     0.200
    20.620    -0.540     0.200
    20.646     1.428     0.200
    20.704     0.690     0.200
    20.696    -0.826     0.200
    20.721     1.165     0.200
    20.748    -0.637     0.200
    20.748    -0.739     0.200
    20.766    -0.507     0.200
    20.817    -1.695     0.200
    20.819    -0.627     0.200
    20.897    -0.855     0.200
    20.903    -0.848     0.200
    20.932    -0.399     0.200
    20.954    -0.680     0.200
    20.959     1.275     0.200
    21.050    -1.334     0.200
    21.137     2.288     0.200
    21.128    -1.080     0.200
    21.155     2.516     0.200
    21.154     2.598     0.200
    21.171     2.588     0.200
    21.174     2.249     0.200
    21.180    -0.838     0.200
    21.205     0.559     0.200
    21.205     1.114     0.200
    21.223    -1.467     0.200
    21.236     0.906     0.200
    21.259     0.893     0.200
    21.263    -0.706     0.200
    21.284     2.445     0.200
    21.284     2.679     0.200
    21.287    -0.891     0.200
    21.289    -0.925     0.200
    21.308     1.833     0.200
    21.307    -0.889     0.200
    21.360     2.675     0.200
    21.346    -0.805     0.200
    21.353    -1.299     0.200
    21.378     2.358     0.200
    21.362    -1.095     0.200
    21.410    -0.412     0.200
    21.410    -0.639     0.200
    21.411    -1.023     0.200
    21.416    -2.152     0.200
    21.416    -1.020     0.200
    21.485    -1.620     0.200
    21.543     2.266     0.200
    21.533    -1.186     0.200
    21.538    -0.935     0.200
    21.538    -0.787     0.200
    21.550    -1.544     0.200
    21.553    -0.617     0.200
    21.553    -0.874     0.200
    21.602     1.861     0.200
    21.608    -1.707     0.200
    21.654     1.022     0.200
    21.651    -0.890     0.200
    21.660    -0.667     0.200
    21.689     0.577     0.200
    21.698    -0.287     0.200
    21.715    -1.275     0.200
    21.726    -1.630     0.200
    21.731    -1.328     0.200
    21.750     2.547     0.200
    21.744    -1.093     0.200
    21.744    -0.929     0.200
    21.797    -1.706     0.200
    21.812     1.026     0.200
    21.812     1.581     0.200
    21.822     2.487     0.200
    21.804    -2.739     0.200
    21.804    -1.371     0.200
    21.810    -1.775     0.200
    21.839     2.516     0.200
    21.832    -1.395     0.200
    21.833    -1.551     0.200
    21.852     0.023     0.200
    21.854    -1.006     0.200
    21.863    -1.168     0.200
    21.901    -0.847     0.200
    21.949     2.294     0.200
    21.972    -1.173     0.200
    21.987    -0.028     0.200
    22.017    -0.854     0.200
    22.019    -1.334     0.200
    22.066    -1.396     0.200
    22.110    -0.868     0.200
    22.114    -1.771     0.200
    22.118    -1.140     0.200
    22.168    -1.279     0.200
    22.184     1.790     0.200
    22.217    -1.778     0.200
    22.217    -1.435     0.200
    22.222    -1.401     0.200
    22.222    -1.276     0.200
    22.227    -0.910     0.200
    22.242    -1.698     0.200
    22.242    -1.128     0.200
    22.261    -1.762     0.200
    22.282    -1.633     0.200
    22.281    -1.430     0.200
    22.304     2.545     0.200
    22.295    -1.376     0.200
    22.300    -2.661     0.200
    22.300    -1.778     0.200
    22.316     1.141     0.200
    22.313    -1.001     0.200
    22.339     2.172     0.200
    22.330    -1.270     0.200
    22.334    -1.269     0.200
    22.334    -1.004     0.200
    22.354    -0.637     0.200
    22.354    -0.168     0.200
    22.391     2.008     0.200
    22.372    -2.242     0.200
    22.372    -1.437     0.200
    22.388     1.900     0.200
    22.448     1.849     0.200
    22.448    -1.697     0.200
    22.458    -2.108     0.200
    22.465    -1.322     0.200
    22.462    -0.104     0.200
    22.469    -1.818     0.200
    22.479    -1.570     0.200
    22.490    -2.346     0.200
    22.513    -1.959     0.200
    22.552    -1.707     0.200
    22.552    -1.457     0.200
    22.608    -1.300     0.200
    22.637    -1.813     0.200
    22.670    -2.127     0.200
    22.670    -0.979     0.200
    22.670    -0.791     0.200
    22.675    -1.792     0.200
    22.692     0.163     0.200
    22.705    -1.575     0.200
    22.717    -1.736     0.200
    22.721    -1.544     0.200
    22.721    -1.473     0.200
    22.739    -2.573     0.200
    22.739    -1.761     0.200
    22.763    -2.354     0.200
    22.810    -2.328     0.200
    22.810    -1.976     0.200
    22.834    -2.231     0.200
    22.848    -2.167     0.200
    22.862    -1.529     0.200
    22.879     1.587     0.200
    22.874    -1.708     0.200
    22.896     0.801     0.200
    22.944    -2.519     0.200
    22.955    -2.284     0.200
    22.988    -1.816     0.200
    23.055     2.647     0.200
    23.039    -2.274     0.200
    23.056     1.106     0.200
    23.095    -1.675     0.200
    23.097    -0.941     0.200
    23.101    -1.530     0.200
    23.123     2.331     0.200
    23.146    -2.126     0.200
    23.149    -1.480     0.200
    23.178     2.510     0.200
    23.161    -1.303     0.200
    23.213     0.347     0.200
    23.220    -1.677     0.200
    23.241    -1.301     0.200
    23.249    -1.584     0.200
    23.249    -1.959     0.200
    23.257    -1.602     0.200
    23.277    -1.270     0.200
    23.284    -0.077     0.200
    23.284    -0.522     0.200
    23.286    -1.832     0.200
    23.326    -2.157     0.200
    23.365     1.905     0.200
    23.355    -1.946     0.200
    23.353    -1.923     0.200
    23.358    -2.467     0.200
    23.362    -1.929     0.200
    23.375     0.636     0.200
    23.373    -2.321     0.200
    23.411    -2.727     0.200
    23.432     1.400     0.200
    23.432     2.259     0.200
    23.437    -3.004     0.200
    23.437    -2.395     0.200
    23.477    -1.512     0.200
    23.503    -2.038     0.200
    23.512    -2.092     0.200
    23.536    -1.614     0.200
    23.536    -2.708     0.200
    23.617    -0.422     0.200
    23.673    -1.950     0.200
    23.693     2.083     0.200
    23.684    -2.156     0.200
    23.725    -1.810     0.200
    23.747    -1.240     0.200
    23.777    -1.616     0.200
    23.804     1.271     0.200
    23.792    -2.179     0.200
    23.799    -1.575     0.200
    23.842     2.187     0.200
    23.845    -2.072     0.200
    23.876     0.542     0.200
    23.900    -2.291     0.200
    23.902    -1.315     0.200
    23.902    -1.493     0.200
    23.944    -1.828     0.200
    23.953    -1.776     0.200
    23.962    -0.921     0.200
    23.997    -2.264     0.200
    23.997    -1.428     0.200
    24.033     2.982     0.200
    24.017    -1.750     0.200
    24.018    -1.752     0.200
    24.029    -0.607     0.200
    24.029    -1.162     0.200
    24.105    -0.000     0.200
    24.103    -1.381     0.200
    24.152     1.534     0.200
    24.151     2.127     0.200
    24.176    -1.370     0.200
    24.176    -1.487     0.200
    24.224    -0.930     0.200
    24.229    -1.011     0.200
    24.237    -1.048     0.200
    24.293    -1.621     0.200
    24.341     1.058     0.200
    24.334    -0.973     0.200
    24.339    -2.196     0.200
    24.349    -1.707     0.200
    24.398    -1.461     0.200
    24.432    -0.972     0.200
    24.444    -1.350     0.200
    24.504    -0.708     0.200
    24.504    -1.208     0.200
    24.517    -1.173     0.200
    24.544    -1.132     0.200
    24.544    -1.390     0.200
    24.569     2.964     0.200
    24.591     1.035     0.200
    24.591    -0.106     0.200
    24.591     1.215     0.200
    24.591     1.066     0.200
    24.591     2.051     0.200
    24.597    -1.750     0.200
    24.620     2.018     0.200
    24.619    -1.790     0.200
    24.619    -1.313     0.200
    24.622    -1.158     0.200
    24.622    -0.915     0.200
    24.665    -1.053     0.200
    24.721    -1.622     0.200
    24.742    -1.175     0.200
    24.742    -2.167     0.200
    24.756     3.100     0.200
    24.770    -0.574     0.200
    24.811     1.769     0.200
    24.794    -0.510     0.200
    24.805    -1.615     0.200
    24.850    -1.158     0.200
    24.852    -1.003     0.200
    24.881    -0.326     0.200
    24.881    -0.482     0.200
    24.891     1.751     0.200
    24.925    -0.661     0.200
    24.925    -0.914     0.200
    24.933    -1.511     0.200
    24.957     2.563     0.200
    24.977    -1.308     0.200
    24.977    -0.534     0.200
    25.008     2.347     0.200
    25.008     2.142     0.200
    25.019    -1.233     0.200
    25.102    -0.987     0.200
    25.118    -1.315     0.200
    25.142     2.195     0.200
    25.126    -1.455     0.200
    25.126    -1.994     0.200
    25.171    -1.750     0.200
    25.233    -1.972     0.200
    25.248     2.218     0.200
    25.251    -1.046     0.200
    25.251    -2.366     0.200
    25.249     0.580     0.200
    25.249    -0.491     0.200
    25.285    -1.616     0.200
    25.320    -2.106     0.200
    25.320    -1.606     0.200
    25.333    -1.489     0.200
    25.338    -1.044     0.200
    25.349    -1.256     0.200
    25.357    -1.306     0.200
    25.402    -0.275     0.200
    25.425    -1.481     0.200
    25.436    -1.600     0.200
    25.457    -1.105     0.200
    25.460    -0.632     0.200
    25.471    -1.311     0.200
    25.471     0.220     0.200
    25.479     0.974     0.200
    25.516    -2.065     0.200
    25.543     2.823     0.200
    25.539    -1.430     0.200
    25.554    -1.686     0.200
    25.565    -1.509     0.200
    25.584     0.319     0.200
    25.595     0.928     0.200
    25.620    -2.018     0.200
    25.701     0.898     0.200
    25.693    -1.631     0.200
    25.703    -1.527     0.200
    25.706    -0.393     0.200
    25.706    -2.221     0.200
    25.708     1.694     0.200
    25.753     0.965     0.200
    25.782    -0.322     0.200
    25.782    -0.760     0.200
    25.788    -1.542     0.200
    25.811    -1.188     0.200
    25.822    -0.619     0.200
    25.822     0.944     0.200
    25.826    -0.691     0.200
    25.868     2.523     0.200
    25.934     0.257     0.200
    25.932    -1.539     0.200
    25.932    -1.086     0.200
    25.954    -1.045     0.200
    26.004    -0.557     0.200
    26.002    -1.516     0.200
    26.002    -0.914     0.200
    26.008    -1.913     0.200
    26.056    -1.026     0.200
    26.068     0.825     0.200
    26.102    -1.318     0.200
    26.102    -1.443     0.200
    26.123    -0.039     0.200
    26.122    -1.283     0.200
    26.123    -1.565     0.200
    26.269    -0.332     0.200
    26.277    -0.509     0.200
    26.313    -1.572     0.200
    26.313    -1.869     0.200
    26.348     2.225     0.200
    26.348     0.459     0.200
    26.337    -2.301     0.200
    26.371    -1.780     0.200
    26.445     1.236     0.200
    26.445     1.572     0.200
    26.440    -1.711     0.200
    26.449    -1.258     0.200
    26.482     2.070     0.200
    26.474    -1.270     0.200
    26.578     1.390     0.200
    26.588    -1.942     0.200
    26.593    -1.808     0.200
    26.676     1.010     0.200
    26.683     1.044     0.200
    26.674    -1.774     0.200
    26.745    -1.174     0.200
    26.777     1.215     0.200
    26.806     0.304     0.200
    26.827    -1.420     0.200
    26.848     0.098     0.200
    26.848    -0.355     0.200
    26.881     1.573     0.200
    26.876    -1.350     0.200
    26.876    -1.490     0.200
    26.882    -0.297     0.200
    26.971    -1.524     0.200
    26.992     0.876     0.200
    27.025    -2.314     0.200
    27.059     0.152     0.200
    27.077    -1.948     0.200
    27.123    -1.916     0.200
    27.136     1.980     0.200
    27.164     0.344     0.200
    27.167    -2.069     0.200
    27.194    -1.191     0.200
    27.226     2.434     0.200
    27.226    -1.815     0.200
    27.269    -1.916     0.200
    27.269    -1.643     0.200
    27.348    -1.672     0.200
    27.352    -1.610     0.200
    27.436    -1.023     0.200
    27.483    -2.095     0.200
    27.509     1.010     0.200
    27.542     0.438     0.200
    27.561    -0.225     0.200
    27.557    -2.515     0.200
    27.604     1.610     0.200
    27.601    -1.120     0.200
    27.642    -0.637     0.200
    27.658    -1.754     0.200
    27.703     0.079     0.200
    27.703     0.985     0.200
    27.702    -1.590     0.200
    27.714    -1.513     0.200
    27.714    -1.701     0.200
    27.739     1.798     0.200
    27.779    -1.144     0.200
    27.929     1.089     0.200
    27.961    -1.106     0.200
    27.968    -1.346     0.200
    27.992     2.038     0.200
    27.993    -1.016     0.200
    28.104    -0.483     0.200
    28.116     0.142     0.200
    28.135    -1.853     0.200
    28.135    -0.541     0.200
    28.295     0.867     0.200
    28.323    -1.465     0.200
    28.359     1.710     0.200
    28.354    -1.499     0.200
    28.397    -2.166     0.200
    28.497     0.461     0.200
    28.516    -1.920     0.200
    28.516    -1.545     0.200
    28.612    -0.132     0.200
    28.658     1.626     0.200
    28.666    -1.419     0.200
    28.814    -0.734     0.200
    28.850    -0.978     0.200
    28.874     1.275     0.200
    28.872    -1.164     0.200
    28.881    -0.413     0.200
    28.903     0.608     0.200
    28.903    -1.592     0.200
    28.946    -1.370     0.200
    29.006     1.563     0.200
    29.045    -1.325     0.200
    29.067    -1.602     0.200
    29.118    -1.316     0.200
    29.137    -1.588     0.200
    29.242    -1.554     0.200
    29.309     1.792     0.200
    29.309    -1.647     0.200
    29.445     1.083     0.200
    29.472     0.599     0.200
    29.484    -1.702     0.200
    29.558     1.200     0.200
    29.561    -1.692     0.200
    29.579     0.956     0.200
    29.700    -1.334     0.200
    29.738    -1.060     0.200
    29.749    -1.643     0.200
    29.749    -1.041     0.200
    29.767     0.499     0.200
    29.761     0.341     0.200
    29.789     0.962     0.200
    29.822    -0.676     0.200
    29.833    -1.011     0.200
    29.835    -1.436     0.200
    29.925     1.458     0.200
    30.099    -1.244     0.200
    30.192     0.371     0.200
    30.243    -1.529     0.200
    30.246    -1.014     0.200
    30.291     0.892     0.200
    30.284    -1.797     0.200
    30.300     0.558     0.200
    30.288    -1.241     0.200
    30.312     0.129     0.200
    30.360    -0.577     0.200
    30.421    -1.062     0.200
    30.470     1.888     0.200
    30.514     3.379     0.200
    30.597     0.996     0.200
    30.600     0.091     0.200
    30.642    -1.655     0.200
    30.828    -2.027     0.200
    30.855     0.974     0.200
    30.880     1.975     0.200
    30.923     1.717     0.200
    30.923     3.249     0.200
    30.923     2.163     0.200
    30.973     0.078     0.200
    30.994    -1.392     0.200
    30.994    -1.845     0.200
    31.062     2.404     0.200
    31.075    -0.514     0.200
    31.076    -2.093     0.200
    31.209    -1.099     0.200
    31.232     2.065     0.200
    31.334     1.559     0.200
    31.406     2.478     0.200
    31.427     0.467     0.200
    31.422    -0.919     0.200
    31.510     0.839     0.200
    31.510     0.574     0.200
    31.660    -1.192     0.200
    31.734     0.886     0.200
    31.869     1.722     0.200
    31.965    -1.412     0.200
    32.131    -0.963     0.200
    32.187     1.790     0.200
    32.251     0.912     0.200
    32.247    -1.332     0.200
    32.247    -1.527     0.200
    32.325     2.906     0.200
    32.391     1.647     0.200
    32.393    -1.130     0.200
    32.459     0.872     0.200
    32.590    -1.558     0.200
    32.605    -1.612     0.200
    32.618    -1.189     0.200
    32.875     0.842     0.200
    33.105     0.555     0.200
    33.107     0.393     0.200
    33.300    -0.827     0.200
    33.300    -1.882     0.200
    33.411    -1.622     0.200
    33.511     1.803     0.200
    33.658     2.417     0.200
    33.658     0.917     0.200
    33.711     1.051     0.200
    33.700    -1.235     0.200
    33.701    -2.027     0.200
    33.731    -1.829     0.200
    33.930    -0.415     0.200
    34.102    -0.655     0.200
    34.189    -1.709     0.200
    34.370    -1.281     0.200
    34.600    -1.771     0.200
    34.674    -1.915     0.200
    34.829    -1.405     0.200
    34.898    -1.506     0.200
    34.899    -1.488     0.200
    35.029     1.289     0.200
    35.160    -1.362     0.200
    35.364    -0.260     0.200
    35.627    -1.704     0.200
    35.786     0.237     0.200
    36.045    -0.429     0.200
    36.066     0.981     0.200
    36.115    -1.187     0.200
    36.115    -0.648     0.200
    36.194    -1.856     0.200
    36.352     0.294     0.200
    36.682    -1.366     0.200
    36.887     0.462     0.200
    37.138    -0.208     0.200
    37.359    -1.738     0.200
    37.562    -1.373     0.200
    38.358    -0.976     0.200
    39.178    -1.156     0.200
    40.771    -0.800     0.200
    41.063    -0.519     0.200
    42.977     0.270     0.200
    44.177     2.157     0.200
    44.508    -1.103     0.200
    44.508    -1.658     0.200
    44.575    -0.989     0.200
    45.879    -0.455     0.200
    45.879    -0.900     0.200
    47.226     1.088     0.200
    47.226     0.970     0.200
    48.443    -1.035     0.200
    49.386     0.936     0.200
    49.386     0.686     0.200
    49.386     2.038     0.200
    50.346     2.175     0.200
    50.376     0.322     0.200
    50.790     1.039     0.200
    51.122    -0.053     0.200
    51.362     0.662     0.200
    51.396     1.018     0.200
    51.714    -0.072     0.200
    51.988     0.501     0.200
    52.067     0.732     0.200
    52.251     0.883     0.200
    52.335     0.991     0.200
    52.335    -0.220     0.200
    52.444     0.781     0.200
    52.641     1.573     0.200
    52.646     1.407     0.200
    52.733     1.833     0.200
    52.826     1.627     0.200
    52.931     0.474     0.200
    52.931     1.818     0.200
    52.941     1.922     0.200
    52.969     1.694     0.200
    53.094     1.584     0.200
    53.097     0.248     0.200
    53.112     1.348     0.200
    53.287     1.586     0.200
    53.310     1.256     0.200
    53.326     1.359     0.200
    53.337     0.697     0.200
    53.337     1.048     0.200
    53.471     0.168     0.200
    53.898     1.493     0.200
    54.112    -0.296     0.200
    54.112     0.259     0.200
    54.210     1.455     0.200
    54.310     0.559     0.200
    54.310     0.660     0.200
    54.310     0.808     0.200
    54.319     1.620     0.200
    54.425     1.070     0.200
    54.548    -0.429     0.200
    54.702    -0.845     0.200
    54.702     0.561     0.200
    54.702     0.819     0.200
    54.705     0.776     0.200
    54.705     0.333     0.200
    54.773     1.081     0.200
    54.883    -0.349     0.200
    54.899     1.392     0.200
    55.215     0.945     0.200
    55.442     0.604     0.200
    55.777     0.393     0.200
    55.802     0.797     0.200
    56.344    -1.679     0.200
    56.858     1.503     0.200
    57.144     2.054     0.200
    57.373    -0.400     0.200
    57.495     0.962     0.200
    57.495     0.852     0.200
    58.004     0.623     0.200
    58.523     0.477     0.200
    59.095     0.417     0.200
    60.680    -1.393     0.200
    61.134     0.470     0.200
    61.240     1.091     0.200
    61.513     0.742     0.200
    62.725     0.221     0.200
    63.475    -0.665     0.200
    63.537     0.268     0.200
    63.537     0.463     0.200
    63.537     1.244     0.200
    63.716     0.985     0.200
    64.672     0.814     0.200
    65.014    -1.030     0.200
    65.123     0.449     0.200
    66.647     1.613     0.200
    66.647     2.207     0.200
    67.022     0.699     0.200
    67.413     1.434     0.200
    67.527     1.436     0.200
    67.752     1.334     0.200
    68.723     1.092     0.200
    69.219    -0.753     0.200
    69.949     0.832     0.200
    70.961    -0.250     0.200
    72.809     1.299     0.200
    72.809     1.159     0.200
    77.942    -1.318     0.200
    78.560    -0.329     0.200
    78.560     0.265     0.200
    78.914     1.086     0.200
    79.208    -1.556     0.200
    79.366     1.191     0.200
    79.713     1.365     0.200
    79.713     1.013     0.200
    79.720     0.229     0.200
    79.744     0.698     0.200
    80.271     1.243     0.200
    80.272     1.236     0.200
    80.536     1.608     0.200
    80.649     1.514     0.200
    80.775     1.438     0.200
    80.839    -0.930     0.200
    80.859     1.248     0.200
    80.906     1.534     0.200
    81.407     1.785     0.200
    81.650     1.017     0.200
    81.673     0.771     0.200
    81.673     1.498     0.200
    81.676     1.905     0.200
    81.860     1.089     0.200
    82.023     1.041     0.200
    82.069     1.126     0.200
    82.110     0.979     0.200
    82.162     2.007     0.200
    82.168     1.818     0.200
    82.193     1.216     0.200
    82.235     1.576     0.200
    82.272     1.630     0.200
    82.309     1.808     0.200
    82.379     1.173     0.200
    82.469     1.606     0.200
    82.480     1.905     0.200
    82.509     1.088     0.200
    82.631     1.762     0.200
    82.773     1.317     0.200
    82.781     1.724     0.200
    82.841     1.070     0.200
    82.861     1.362     0.200
    82.861     0.214     0.200
    82.866     1.037     0.200
    82.915     2.085     0.200
    82.915     0.944     0.200
    82.936     1.983     0.200
    82.993     1.281     0.200
    82.995     1.370     0.200
    82.995     0.948     0.200
    82.995     1.565     0.200
    83.057     1.630     0.200
    83.084     1.206     0.200
    83.107     1.651     0.200
    83.130     0.971     0.200
    83.130     1.228     0.200
    83.156     0.640     0.200
    83.156     1.412     0.200
    83.164     2.498     0.200
    83.277     1.315     0.200
    83.307     1.364     0.200
    83.307     1.114     0.200
    83.345     1.633     0.200
    83.561     1.652     0.200
    83.598     1.944     0.200
    83.672     1.487     0.200
    83.672     2.432     0.200
    83.878     1.809     0.200
    83.920     1.939     0.200
    83.981     1.994     0.200
    84.000     3.576     0.200
    84.062     2.262     0.200
    84.733     1.189     0.200
    84.765     4.937     0.200
    85.018     1.064     0.200
    85.064     0.229     0.200
    85.101     2.133     0.200
    85.121     2.445     0.200
    85.146     0.780     0.200
    85.146     0.249     0.200
    85.146     0.780     0.200
    85.181     2.646     0.200
    85.194     0.268     0.200
    85.220     2.349     0.200
    85.334    -0.502     0.200
    85.343    -0.055     0.200
    85.370     0.840     0.200
    85.370     1.840     0.200
    85.373     0.584     0.200
    85.373    -0.611     0.200
    85.373     0.569     0.200
    85.373     0.561     0.200
    85.372     1.752     0.200
    85.401    -0.705     0.200
    85.461     1.858     0.200
    85.545    -1.811     0.200
    85.581     2.650     0.200
    85.666     1.227     0.200
    85.666     1.407     0.200
    85.695     1.505     0.200
    85.695     1.552     0.200
    85.721     1.907     0.200
    85.732     1.196     0.200
    85.763     0.948     0.200
    85.781     1.984     0.200
    85.941     2.852     0.200
    85.945     2.805     0.200
    85.986     2.781     0.200
    86.013     2.948     0.200
    86.365     0.682     0.200
    86.373     1.336     0.200
    86.527     2.948     0.200
    86.599     2.624     0.200
    86.703    -0.681     0.200
    86.733     0.970     0.200
    86.782     0.183     0.200
    86.906     1.420     0.200
    86.981     1.059     0.200
    87.013     1.103     0.200
    87.283     2.076     0.200
    87.339    -0.080     0.200
    87.352     1.164     0.200
    87.383    -0.394     0.200
    87.595     2.268     0.200
    87.630     0.960     0.200
    87.673    -0.480     0.200
    87.693     0.345     0.200
    87.806     0.388     0.200
    87.848     0.086     0.200
    87.872    -0.430     0.200
    87.892    -0.826     0.200
    88.002    -0.249     0.200
    88.302    -0.668     0.200
    88.317     0.769     0.200
    88.577    -1.968     0.200
    88.615     0.478     0.200
    89.187    -0.231     0.200
    89.217     1.125     0.200
    89.368     0.716     0.200
    89.550    -0.230     0.200
    89.575     0.451     0.200
    89.575    -0.450     0.200
    89.675    -0.017     0.200
    89.663     0.742     0.200
    90.013    -0.303     0.200
    90.208     1.197     0.200
    90.298     0.775     0.200
    90.482     2.272     0.200
    90.562     0.547     0.200
    90.575    -0.216     0.200
    90.583     0.748     0.200
    90.868     0.125     0.200
    90.868    -0.282     0.200
    90.868     0.125     0.200
    90.914     0.107     0.200
    91.000    -2.690     0.200
    91.312     0.463     0.200
    91.312     0.361     0.200
    91.543     0.995     0.200
    91.583     1.809     0.200
    91.947     0.874     0.200
    92.046     0.003     0.200
    92.189     1.513     0.200
    92.264     1.621     0.200
    92.320     1.394     0.200
    92.396     1.243     0.200
    92.443    -1.371     0.200
    92.445     1.434     0.200
    92.600     1.183     0.200
    92.672     1.585     0.200
    92.792    -0.114     0.200
    92.792     0.917     0.200
    92.851     0.949     0.200
    93.033     1.233     0.200
    93.014     0.890     0.200
    93.019     0.767     0.200
    93.344     1.271     0.200
    93.453     1.182     0.200
    93.596     1.108     0.200
    93.699     2.138     0.200
    93.748     1.116     0.200
    93.762     1.223     0.200
    93.762     1.848     0.200
    93.871     1.102     0.200
    94.337     1.307     0.200
    94.337     1.206     0.200
    94.371     0.752     0.200
    94.371     0.252     0.200
    94.446     0.431     0.200
    94.570    -0.364     0.200
    94.570     0.441     0.200
    94.722     1.465     0.200
    94.766     0.693     0.200
    94.912     0.865     0.200
    94.951     0.312     0.200
    95.175     2.370     0.200
    95.245     1.751     0.200
    95.246     2.248     0.200
    95.247     1.248     0.200
    95.554    -1.162     0.200
    95.663     0.945     0.200
    95.745     1.173     0.200
    95.953     2.321     0.200
    96.014     1.146     0.200
    96.136     1.792     0.200
    96.210     0.956     0.200
    96.255     0.751     0.200
    96.311     0.192     0.200
    96.387     0.950     0.200
    96.400     0.343     0.200
    96.400     0.695     0.200
    96.400     1.109     0.200
    96.422     0.996     0.200
    96.422     0.098     0.200
    96.444    -1.807     0.200
    96.442     0.827     0.200
    96.611     0.936     0.200
    96.719     1.555     0.200
    96.719     1.945     0.200
    96.918     0.003     0.200
    96.918     1.347     0.200
    96.926     1.797     0.200
    96.926     1.110     0.200
    96.926     1.625     0.200
    97.264     0.122     0.200
    97.284    -2.327     0.200
    97.842    -0.022     0.200
    24.166     2.787     0.200
    44.796    -1.747     0.200
    54.877     0.587     0.200
    14.240     4.227     0.200
    14.755     3.593     0.200
    15.287     3.188     0.200
    15.506     4.055     0.200
    15.983     2.993     0.200
    15.983     3.103     0.200
    16.054     3.323     0.200
    16.192     2.775     0.200
    16.192     3.285     0.200
    16.448     2.816     0.200
    16.518     3.406     0.200
    16.864     2.796     0.200
    17.259     3.292     0.200
    17.259     3.147     0.200
    17.259     3.446     0.200
    17.478     1.662     0.200
    18.190     2.911     0.200
    18.190     2.761     0.200
    18.365    -0.794     0.200
    18.365    -0.993     0.200
    18.556    -0.205     0.200
    18.631     0.076     0.200
    18.664    -0.433     0.200
    18.664    -0.605     0.200
    18.815    -0.421     0.200
    18.926    -0.169     0.200
    18.926    -0.313     0.200
    18.951    -0.187     0.200
    19.005    -0.115     0.200
    19.198    -0.491     0.200
    19.198     0.018     0.200
    19.193     0.066     0.200
    19.242     1.000     0.200
    19.408    -0.169     0.200
    19.467     0.192     0.200
    19.467    -0.151     0.200
    19.509    -0.633     0.200
    19.561    -0.850     0.200
    19.558    -0.676     0.200
    19.590    -0.353     0.200
    19.955    -0.338     0.200
    19.955    -0.529     0.200
    19.957    -0.605     0.200
    19.957    -0.776     0.200
    19.959    -0.937     0.200
    20.004    -0.586     0.200
    19.996    -0.622     0.200
    20.034    -0.620     0.200
    20.162    -0.891     0.200
    20.183     0.209     0.200
    20.204     0.132     0.200
    20.206    -0.669     0.200
    20.346    -0.424     0.200
    20.417    -0.462     0.200
    20.524    -0.997     0.200
    20.544    -0.892     0.200
    20.544    -1.073     0.200
    20.593    -1.039     0.200
    20.599    -0.502     0.200
    20.608    -0.671     0.200
    20.656    -1.260     0.200
    20.680    -0.003     0.200
    20.680    -0.292     0.200
    20.689    -0.712     0.200
    20.723    -1.130     0.200
    20.733    -1.517     0.200
    20.783     1.847     0.200
    20.779    -0.733     0.200
    20.797     0.171     0.200
    20.797    -0.038     0.200
    20.803    -0.297     0.200
    20.833     0.084     0.200
    20.859    -0.637     0.200
    20.891     0.901     0.200
    20.891     1.197     0.200
    20.920    -1.259     0.200
    20.964     1.516     0.200
    20.928    -1.089     0.200
    20.959    -1.446     0.200
    20.969    -0.913     0.200
    21.002     1.872     0.200
    21.002     1.602     0.200
    21.012     1.564     0.200
    21.013     1.558     0.200
    21.015     1.529     0.200
    20.984    -1.525     0.200
    21.034     1.604     0.200
    21.012    -1.052     0.200
    21.015    -1.113     0.200
    21.050     1.970     0.200
    21.027     0.340     0.200
    21.032     3.065     0.200
    21.076     1.859     0.200
    21.041    -0.532     0.200
    21.090     2.020     0.200
    21.127     2.176     0.200
    21.110     1.712     0.200
    21.119     1.499     0.200
    21.126     1.221     0.200
    21.105    -0.507     0.200
    21.129    -1.213     0.200
    21.196     3.191     0.200
    21.191     2.103     0.200
    21.171     0.254     0.200
    21.174    -0.431     0.200
    21.183    -1.423     0.200
    21.183    -1.008     0.200
    21.252     2.085     0.200
    21.209    -0.426     0.200
    21.209    -1.170     0.200
    21.263     1.235     0.200
    21.266     1.552     0.200
    21.286     1.625     0.200
    21.340     2.356     0.200
    21.331    -0.698     0.200
    21.322    -0.026     0.200
    21.322    -0.884     0.200
    21.348    -0.073     0.200
    21.344    -0.981     0.200
    21.408    -1.852     0.200
    21.420    -0.019     0.200
    21.429    -0.682     0.200
    21.466     1.904     0.200
    21.435    -0.137     0.200
    21.435    -0.412     0.200
    21.453    -1.352     0.200
    21.453    -1.584     0.200
    21.472    -0.727     0.200
    21.483    -1.389     0.200
    21.504    -0.749     0.200
    21.555     2.655     0.200
    21.525    -0.841     0.200
    21.507    -0.736     0.200
    21.507    -0.999     0.200
    21.531    -0.476     0.200
    21.526    -1.816     0.200
    21.560    -1.546     0.200
    21.573    -1.305     0.200
    21.605    -1.115     0.200
    21.659     2.549     0.200
    21.620    -1.137     0.200
    21.639    -1.386     0.200
    21.635    -0.775     0.200
    21.725     1.650     0.200
    21.725     1.518     0.200
    21.680    -0.611     0.200
    21.735     2.249     0.200
    21.739    -2.034     0.200
    21.747    -1.564     0.200
    21.790    -1.212     0.200
    21.880     1.134     0.200
    21.880     1.027     0.200
    21.904     1.918     0.200
    21.922    -1.242     0.200
    21.928    -0.932     0.200
    21.931    -1.854     0.200
    21.949    -1.514     0.200
    21.949    -2.156     0.200
    21.968     4.322     0.200
    22.002     1.774     0.200
    21.978    -2.035     0.200
    21.994    -2.297     0.200
    22.001    -2.446     0.200
    22.002     0.222     0.200
    22.002    -0.337     0.200
    22.022    -1.289     0.200
    22.022    -1.715     0.200
    22.027    -1.461     0.200
    22.041    -1.690     0.200
    22.141     1.779     0.200
    22.141     2.065     0.200
    22.103    -1.376     0.200
    22.103    -1.230     0.200
    22.095    -1.783     0.200
    22.108    -1.601     0.200
    22.163     1.517     0.200
    22.192     0.650     0.200
    22.192    -1.347     0.200
    22.216    -3.360     0.200
    22.216    -1.653     0.200
    22.254    -1.555     0.200
    22.265    -1.444     0.200
    22.330    -0.951     0.200
    22.330    -1.190     0.200
    22.475     1.870     0.200
    22.489     1.917     0.200
    22.444    -2.780     0.200
    22.459    -2.491     0.200
    22.459    -2.835     0.200
    22.548     2.903     0.200
    22.561     1.904     0.200
    22.513    -2.664     0.200
    22.513    -1.735     0.200
    22.514    -2.241     0.200
    22.539    -2.082     0.200
    22.543    -2.688     0.200
    22.550    -1.917     0.200
    22.623     1.294     0.200
    22.587    -3.108     0.200
    22.629     1.228     0.200
    22.629     1.385     0.200
    22.607    -1.594     0.200
    22.641    -1.548     0.200
    22.738     2.193     0.200
    22.738     1.510     0.200
    22.692    -1.842     0.200
    22.692    -2.690     0.200
    22.706    -1.463     0.200
    22.714    -0.987     0.200
    22.714    -1.992     0.200
    22.779    -2.175     0.200
    22.819     0.188     0.200
    22.819    -0.041     0.200
    22.895    -1.296     0.200
    22.890    -2.904     0.200
    22.906    -2.976     0.200
    22.983     2.043     0.200
    22.962    -2.668     0.200
    22.965    -2.122     0.200
    23.000     1.534     0.200
    23.000     0.537     0.200
    22.982    -2.350     0.200
    22.997    -1.067     0.200
    23.004    -3.291     0.200
    23.013    -2.363     0.200
    23.091     2.038     0.200
    23.055    -1.398     0.200
    23.078     3.318     0.200
    23.139     2.150     0.200
    23.122    -1.721     0.200
    23.144    -1.254     0.200
    23.212     1.821     0.200
    23.168    -1.765     0.200
    23.170    -2.078     0.200
    23.274     1.955     0.200
    23.304    -1.914     0.200
    23.347     0.394     0.200
    23.380     1.872     0.200
    23.380     2.035     0.200
    23.353    -1.323     0.200
    23.392    -2.035     0.200
    23.399     3.416     0.200
    23.399     2.445     0.200
    23.399    -0.284     0.200
    23.398     2.585     0.200
    23.399     2.692     0.200
    23.460     1.963     0.200
    23.473    -1.243     0.200
    23.471    -1.082     0.200
    23.471    -2.053     0.200
    23.476    -3.522     0.200
    23.479    -2.545     0.200
    23.481    -3.376     0.200
    23.512    -1.672     0.200
    23.534    -0.058     0.200
    23.534    -0.298     0.200
    23.534    -1.214     0.200
    23.551    -1.149     0.200
    23.631     1.697     0.200
    23.583    -1.982     0.200
    23.605    -1.844     0.200
    23.613     1.801     0.200
    23.640    -1.637     0.200
    23.643     3.349     0.200
    23.722     1.197     0.200
    23.696    -1.733     0.200
    23.749     1.268     0.200
    23.815     1.733     0.200
    23.822    -1.249     0.200
    23.841    -1.752     0.200
    23.913     1.520     0.200
    23.913     1.147     0.200
    23.955    -0.151     0.200
    23.941    -1.905     0.200
    23.941    -1.570     0.200
    23.962    -1.823     0.200
    23.962    -1.477     0.200
    23.977    -1.189     0.200
    23.972    -2.650     0.200
    23.994    -1.278     0.200
    24.025    -1.192     0.200
    24.054    -1.266     0.200
    24.064    -2.171     0.200
    24.084    -0.858     0.200
    24.080    -2.258     0.200
    24.103    -1.780     0.200
    24.104    -1.659     0.200
    24.144    -0.888     0.200
    24.172    -1.926     0.200
    24.278    -2.073     0.200
    24.289    -1.895     0.200
    24.381     1.459     0.200
    24.362    -1.274     0.200
    24.360    -1.400     0.200
    24.371    -1.934     0.200
    24.412    -1.757     0.200
    24.455     2.389     0.200
    24.423    -1.267     0.200
    24.509    -1.554     0.200
    24.507     3.549     0.200
    24.512    -1.846     0.200
    24.535    -0.731     0.200
    24.535    -1.272     0.200
    24.547    -1.343     0.200
    24.544    -1.681     0.200
    24.559    -1.194     0.200
    24.590    -1.353     0.200
    24.579    -1.984     0.200
    24.598    -2.032     0.200
    24.646     2.390     0.200
    24.636    -1.222     0.200
    24.667    -0.619     0.200
    24.718     2.089     0.200
    24.718     2.417     0.200
    24.676    -1.070     0.200
    24.676    -1.677     0.200
    24.680    -1.574     0.200
    24.739    -1.651     0.200
    24.765    -1.649     0.200
    24.780    -1.334     0.200
    24.802     1.236     0.200
    24.802     0.128     0.200
    24.787    -1.172     0.200
    24.787    -1.425     0.200
    24.783    -0.395     0.200
    24.783    -1.065     0.200
    24.823     1.486     0.200
    24.796    -0.697     0.200
    24.871    -1.512     0.200
    24.912    -1.384     0.200
    24.959    -1.582     0.200
    24.978    -0.941     0.200
    24.978    -1.225     0.200
    24.995    -2.067     0.200
    25.005    -1.658     0.200
    25.003    -1.489     0.200
    25.021    -1.152     0.200
    25.021    -1.668     0.200
    25.039    -1.792     0.200
    25.053    -0.926     0.200
    25.103     2.444     0.200
    25.098    -1.444     0.200
    25.125    -2.405     0.200
    25.135    -1.941     0.200
    25.143    -1.521     0.200
    25.145    -1.784     0.200
    25.163    -1.409     0.200
    25.225     1.740     0.200
    25.267     1.844     0.200
    25.244    -1.183     0.200
    25.292    -1.704     0.200
    25.350     2.580     0.200
    25.392    -1.404     0.200
    25.391    -1.677     0.200
    25.399    -1.549     0.200
    25.429     0.544     0.200
    25.429     0.257     0.200
    25.429     0.474     0.200
    25.429     0.524     0.200
    25.429     0.734     0.200
    25.413    -1.531     0.200
    25.413    -1.869     0.200
    25.422    -1.262     0.200
    25.509     1.516     0.200
    25.475    -2.051     0.200
    25.497    -1.764     0.200
    25.514    -1.620     0.200
    25.570    -1.810     0.200
    25.613     2.284     0.200
    25.569    -1.286     0.200
    25.579    -1.719     0.200
    25.635    -1.852     0.200
    25.634    -1.803     0.200
    25.655    -2.564     0.200
    25.682    -1.598     0.200
    25.692    -1.999     0.200
    25.698    -1.618     0.200
    25.719    -1.894     0.200
    25.731    -1.543     0.200
    25.783     1.144     0.200
    25.769    -0.792     0.200
    25.769    -1.199     0.200
    25.813     2.200     0.200
    25.805    -2.202     0.200
    25.890    -1.963     0.200
    25.910    -2.001     0.200
    25.934    -1.690     0.200
    25.981    -1.396     0.200
    26.056     2.986     0.200
    26.030    -0.931     0.200
    26.030    -0.695     0.200
    26.041     0.620     0.200
    26.041     0.447     0.200
    26.038    -2.159     0.200
    26.064    -1.695     0.200
    26.073    -2.274     0.200
    26.082    -2.069     0.200
    26.131     1.264     0.200
    26.091    -2.129     0.200
    26.151    -1.769     0.200
    26.151    -1.956     0.200
    26.148    -1.393     0.200
    26.166    -1.641     0.200
    26.197    -1.495     0.200
    26.212    -1.772     0.200
    26.221    -1.427     0.200
    26.221    -1.587     0.200
    26.285     1.009     0.200
    26.282    -1.689     0.200
    26.297    -1.648     0.200
    26.357     1.160     0.200
    26.350    -1.427     0.200
    26.429     0.827     0.200
    26.464     0.811     0.200
    26.452    -1.949     0.200
    26.436    -1.995     0.200
    26.486     2.203     0.200
    26.475    -1.916     0.200
    26.477    -2.068     0.200
    26.541    -1.166     0.200
    26.542    -1.951     0.200
    26.556    -1.849     0.200
    26.587     0.833     0.200
    26.626     0.235     0.200
    26.608    -2.034     0.200
    26.639    -2.449     0.200
    26.648    -2.795     0.200
    26.669    -3.117     0.200
    26.715    -2.182     0.200
    26.717    -1.519     0.200
    26.733    -1.918     0.200
    26.769    -1.915     0.200
    26.811     1.483     0.200
    26.799    -1.813     0.200
    26.824    -1.450     0.200
    26.900    -1.706     0.200
    26.900    -1.998     0.200
    26.933     1.072     0.200
    26.935    -1.073     0.200
    26.935    -1.431     0.200
    26.946    -1.690     0.200
    26.948    -1.957     0.200
    26.997     1.687     0.200
    27.002    -2.212     0.200
    27.026    -2.036     0.200
    27.052    -1.771     0.200
    27.084    -1.879     0.200
    27.089    -2.182     0.200
    27.099    -1.631     0.200
    27.111    -3.474     0.200
    27.131    -1.773     0.200
    27.202     1.757     0.200
    27.202     1.264     0.200
    27.216    -1.692     0.200
    27.227    -2.141     0.200
    27.241    -1.823     0.200
    27.245    -1.355     0.200
    27.245    -1.618     0.200
    27.250    -2.033     0.200
    27.283    -1.943     0.200
    27.327     1.992     0.200
    27.309    -1.513     0.200
    27.462     1.220     0.200
    27.462     0.501     0.200
    27.429    -2.364     0.200
    27.457    -1.537     0.200
    27.500    -1.847     0.200
    27.519    -0.932     0.200
    27.519    -1.645     0.200
    27.540    -1.545     0.200
    27.538    -1.536     0.200
    27.538    -1.875     0.200
    27.544    -1.540     0.200
    27.558     4.594     0.200
    27.564    -1.739     0.200
    27.606    -1.799     0.200
    27.640     0.345     0.200
    27.616    -1.962     0.200
    27.633    -2.664     0.200
    27.710    -1.718     0.200
    27.726    -1.442     0.200
    27.726    -2.523     0.200
    27.750    -2.293     0.200
    27.809     1.698     0.200
    27.799    -1.763     0.200
    27.809    -1.576     0.200
    27.823    -1.545     0.200
    27.905     1.719     0.200
    27.859     1.911     0.200
    27.868    -1.285     0.200
    27.898    -2.151     0.200
    27.919    -1.040     0.200
    27.919    -1.915     0.200
    27.909    -1.721     0.200
    27.909    -2.269     0.200
    27.932    -2.029     0.200
    27.938    -1.727     0.200
    27.938    -2.465     0.200
    28.063     1.136     0.200
    28.039    -2.045     0.200
    28.065    -1.867     0.200
    28.073    -1.278     0.200
    28.078    -1.426     0.200
    28.114    -2.689     0.200
    28.161     1.978     0.200
    28.136    -2.240     0.200
    28.136    -2.433     0.200
    28.200    -1.494     0.200
    28.191    -2.987     0.200
    28.219    -1.724     0.200
    28.227    -1.996     0.200
    28.231    -1.533     0.200
    28.257    -1.672     0.200
    28.272    -1.657     0.200
    28.345    -0.877     0.200
    28.336    -1.535     0.200
    28.359     0.491     0.200
    28.380     2.128     0.200
    28.378    -1.701     0.200
    28.442     1.480     0.200
    28.434    -2.028     0.200
    28.434    -2.506     0.200
    28.461    -1.434     0.200
    28.461    -2.243     0.200
    28.489    -1.514     0.200
    28.489    -2.028     0.200
    28.534    -1.806     0.200
    28.529     3.250     0.200
    28.548    -2.140     0.200
    28.579     1.205     0.200
    28.579     0.997     0.200
    28.593     1.434     0.200
    28.567    -2.448     0.200
    28.605    -2.181     0.200
    28.655    -1.857     0.200
    28.665    -1.613     0.200
    28.696    -2.636     0.200
    28.713    -1.321     0.200
    28.715    -2.759     0.200
    28.758     1.842     0.200
    28.719    -2.343     0.200
    28.757     0.072     0.200
    28.741    -2.950     0.200
    28.753    -1.135     0.200
    28.829    -1.757     0.200
    28.870    -0.913     0.200
    28.837    -2.387     0.200
    28.880    -0.145     0.200
    28.841    -1.942     0.200
    28.857    -1.135     0.200
    28.857    -1.515     0.200
    28.875     1.507     0.200
    28.917    -1.199     0.200
    28.926    -2.590     0.200
    28.930    -2.279     0.200
    28.978    -2.035     0.200
    28.978    -1.651     0.200
    28.981    -1.794     0.200
    29.025     0.858     0.200
    29.041    -1.941     0.200
    29.059    -2.007     0.200
    29.059    -1.906     0.200
    29.059    -3.401     0.200
    29.084    -1.450     0.200
    29.095     4.213     0.200
    29.111    -1.463     0.200
    29.162    -2.218     0.200
    29.171    -2.037     0.200
    29.171    -1.833     0.200
    29.296     2.048     0.200
    29.264     2.711     0.200
    29.314    -1.958     0.200
    29.219    -1.156     0.200
    29.326    -1.852     0.200
    29.333    -2.198     0.200
    29.334     3.424     0.200
    29.373     1.928     0.200
    29.424     0.398     0.200
    29.402    -2.094     0.200
    29.397     4.185     0.200
    29.413    -2.411     0.200
    29.437    -1.727     0.200
    29.523    -0.811     0.200
    29.523    -1.589     0.200
    29.535    -1.536     0.200
    29.581     1.185     0.200
    29.551     0.830     0.200
    29.621     1.387     0.200
    29.606    -1.713     0.200
    29.678     0.728     0.200
    29.669    -1.806     0.200
    29.713     2.717     0.200
    29.696    -1.181     0.200
    29.696    -1.869     0.200
    29.696    -2.322     0.200
    29.731    -2.129     0.200
    29.740    -2.286     0.200
    29.777     1.088     0.200
    29.768     2.894     0.200
    29.794    -0.395     0.200
    29.794    -0.923     0.200
    29.796    -1.431     0.200
    29.796    -1.700     0.200
    29.838    -1.514     0.200
    29.851    -1.674     0.200
    29.889     0.439     0.200
    29.922    -2.080     0.200
    29.985    -1.216     0.200
    29.991    -2.073     0.200
    29.997    -2.093     0.200
    30.078    -1.313     0.200
    30.071    -1.850     0.200
    30.156     1.864     0.200
    30.191     0.520     0.200
    30.193     0.729     0.200
    30.168    -2.053     0.200
    30.189     2.452     0.200
    30.205    -2.608     0.200
    30.198     5.485     0.200
    30.198     5.730     0.200
    30.260     1.703     0.200
    30.240    -1.841     0.200
    30.265     3.813     0.200
    30.302     0.559     0.200
    30.302     0.372     0.200
    30.281    -2.668     0.200
    30.285    -2.016     0.200
    30.329    -1.703     0.200
    30.366    -1.466     0.200
    30.388     0.419     0.200
    30.388     0.143     0.200
    30.375    -1.999     0.200
    30.450    -1.449     0.200
    30.467    -1.356     0.200
    30.467    -1.659     0.200
    30.458     3.432     0.200
    30.526     0.563     0.200
    30.535     0.628     0.200
    30.535     0.330     0.200
    30.518    -0.764     0.200
    30.518    -3.334     0.200
    30.565     0.969     0.200
    30.539    -2.561     0.200
    30.612     0.380     0.200
    30.572    -1.026     0.200
    30.604    -0.739     0.200
    30.604    -0.848     0.200
    30.643    -2.979     0.200
    30.657    -1.851     0.200
    30.704    -1.753     0.200
    30.764     1.413     0.200
    30.736     3.639     0.200
    30.757    -1.688     0.200
    30.752    -2.162     0.200
    30.747     3.540     0.200
    30.779    -1.985     0.200
    30.825     0.882     0.200
    30.837    -2.182     0.200
    30.843     4.030     0.200
    30.902    -2.280     0.200
    30.910    -1.662     0.200
    30.977    -2.585     0.200
    31.022    -0.789     0.200
    31.022    -1.140     0.200
    31.086     1.836     0.200
    31.068    -1.818     0.200
    31.062    -1.913     0.200
    31.098    -2.980     0.200
    31.104    -1.672     0.200
    31.185     1.625     0.200
    31.195     1.122     0.200
    31.200    -1.644     0.200
    31.228    -1.326     0.200
    31.248    -2.156     0.200
    31.311     0.039     0.200
    31.297    -2.892     0.200
    31.410     1.271     0.200
    31.384    -1.566     0.200
    31.444     1.374     0.200
    31.416    -2.164     0.200
    31.430    -1.579     0.200
    31.474     0.910     0.200
    31.490    -1.933     0.200
    31.535     0.277     0.200
    31.532    -1.510     0.200
    31.573    -2.310     0.200
    31.630    -2.143     0.200
    31.709     0.440     0.200
    31.740     2.011     0.200
    31.738    -3.375     0.200
    31.742    -1.244     0.200
    31.756    -2.027     0.200
    31.843     1.841     0.200
    31.853    -2.529     0.200
    31.868    -2.230     0.200
    31.937    -1.999     0.200
    31.936     1.689     0.200
    31.936     2.754     0.200
    31.936     1.824     0.200
    31.964    -2.555     0.200
    31.985    -2.400     0.200
    32.051     2.126     0.200
    32.051     0.256     0.200
    32.058    -2.714     0.200
    32.080    -2.836     0.200
    32.102    -1.783     0.200
    32.104    -2.076     0.200
    32.134    -0.947     0.200
    32.134    -1.486     0.200
    32.186    -1.139     0.200
    32.303     1.490     0.200
    32.296    -1.646     0.200
    32.326    -2.577     0.200
    32.365     0.822     0.200
    32.342    -1.365     0.200
    32.408    -1.787     0.200
    32.417    -2.197     0.200
    32.433    -3.047     0.200
    32.471     0.298     0.200
    32.450    -3.161     0.200
    32.513    -0.331     0.200
    32.513     0.444     0.200
    32.513     0.128     0.200
    32.487    -2.520     0.200
    32.517    -1.506     0.200
    32.640    -2.264     0.200
    32.732    -1.123     0.200
    32.798    -2.068     0.200
    32.801    -1.921     0.200
    32.816    -1.528     0.200
    32.861     1.245     0.200
    32.866     0.752     0.200
    32.892     1.577     0.200
    32.872    -2.335     0.200
    32.903    -1.602     0.200
    32.989     1.763     0.200
    33.049     1.064     0.200
    33.213    -2.522     0.200
    33.243    -2.103     0.200
    33.311     0.782     0.200
    33.318     1.964     0.200
    33.326    -1.901     0.200
    33.367    -2.081     0.200
    33.378    -1.931     0.200
    33.381    -2.479     0.200
    33.380    -2.439     0.200
    33.466     2.004     0.200
    33.455    -2.865     0.200
    33.499     0.859     0.200
    33.518    -1.773     0.200
    33.541    -2.220     0.200
    33.629    -0.568     0.200
    33.652    -2.509     0.200
    33.702    -2.429     0.200
    33.782    -1.907     0.200
    33.772     0.686     0.200
    34.043     0.548     0.200
    34.016    -1.871     0.200
    34.096    -2.658     0.200
    34.105    -1.030     0.200
    34.214     0.831     0.200
    34.236     0.387     0.200
    34.197     0.734     0.200
    34.197     1.565     0.200
    34.215    -2.247     0.200
    34.214    -2.466     0.200
    34.257     1.947     0.200
    34.261    -2.159     0.200
    34.301     2.671     0.200
    34.426    -2.443     0.200
    34.457    -2.306     0.200
    34.459     1.015     0.200
    34.492    -1.988     0.200
    34.478     0.951     0.200
    34.754    -1.944     0.200
    34.764     1.411     0.200
    34.843     0.932     0.200
    34.841    -1.458     0.200
    35.009    -1.350     0.200
    35.014    -2.112     0.200
    35.023    -1.962     0.200
    35.079     0.621     0.200
    35.133    -2.187     0.200
    35.185    -2.260     0.200
    35.312    -1.148     0.200
    35.305     0.935     0.200
    35.545     2.269     0.200
    35.623    -0.696     0.200
    35.631    -2.395     0.200
    35.686    -3.377     0.200
    35.702    -1.330     0.200
    35.769    -1.003     0.200
    35.791    -2.205     0.200
    35.872    -0.787     0.200
    35.975    -1.221     0.200
    36.101     1.010     0.200
    36.397    -0.594     0.200
    36.397    -1.601     0.200
    36.570     0.281     0.200
    36.608    -0.903     0.200
    37.030    -1.729     0.200
    37.265     0.197     0.200
    37.879    -1.883     0.200
    37.915    -1.775     0.200
    38.387     2.720     0.200
    38.521    -0.893     0.200
    38.521    -1.445     0.200
    38.820    -1.813     0.200
    38.924     1.959     0.200
    38.924     2.424     0.200
    38.982     1.181     0.200
    39.126     2.258     0.200
    39.250     0.646     0.200
    39.318    -1.584     0.200
    39.424     3.678     0.200
    39.487     1.391     0.200
    39.615     0.515     0.200
    39.704     0.816     0.200
    39.727     3.030     0.200
    39.820     4.660     0.200
    39.904    -1.252     0.200
    40.752     5.288     0.200
    41.085    -1.053     0.200
    41.254     6.729     0.200
    41.498    -0.906     0.200
    41.694    -0.028     0.200
    42.264     1.928     0.200
    42.264     1.439     0.200
    43.357    -0.600     0.200
    44.519     1.648     0.200
    45.227     2.324     0.200
    45.243    -0.969     0.200
    45.310    -1.150     0.200
    45.442     2.181     0.200
    45.498     1.040     0.200
    45.498     1.460     0.200
    45.498     1.241     0.200
    45.551    -1.098     0.200
    45.551    -1.198     0.200
    46.127     2.194     0.200
    46.629     1.844     0.200
    47.020     1.748     0.200
    47.821     1.899     0.200
    47.824     1.806     0.200
    48.531     1.546     0.200
    48.868     1.942     0.200
    49.291     0.257     0.200
    49.518     2.355     0.200
    49.557     2.499     0.200
    50.106     0.534     0.200
    50.085     1.484     0.200
    50.142     1.190     0.200
    50.142     1.684     0.200
    50.148     1.518     0.200
    50.150     0.053     0.200
    50.157     1.355     0.200
    50.158     1.354     0.200
    50.162     0.861     0.200
    50.164     0.705     0.200
    50.172     1.825     0.200
    50.177     1.356     0.200
    50.180     1.191     0.200
    50.203     1.513     0.200
    50.251     1.998     0.200
    50.326     2.781     0.200
    50.352     2.262     0.200
    50.343     1.229     0.200
    50.421     1.847     0.200
    50.448     2.008     0.200
    50.471     1.511     0.200
    50.497     1.029     0.200
    50.645    -0.278     0.200
    50.710     0.376     0.200
    50.904     1.896     0.200
    51.045     1.508     0.200
    51.083    -1.003     0.200
    51.480     2.159     0.200
    51.494     1.494     0.200
    51.563    -0.195     0.200
    51.810     1.835     0.200
    51.866     2.659     0.200
    51.866     1.119     0.200
    52.421     1.829     0.200
    52.456     1.315     0.200
    52.456     2.155     0.200
    52.435     1.182     0.200
    52.536     1.357     0.200
    52.875     2.162     0.200
    53.141     2.250     0.200
    53.169     1.225     0.200
    53.298     1.105     0.200
    53.298     0.913     0.200
    53.378     2.151     0.200
    53.483     0.929     0.200
    53.730     1.788     0.200
    53.828     1.175     0.200
    53.889     1.564     0.200
    53.907     1.914     0.200
    53.991     0.261     0.200
    54.062     1.684     0.200
    54.040     0.093     0.200
    54.115     1.534     0.200
    54.216     1.022     0.200
    54.216     1.422     0.200
    54.323     1.780     0.200
    54.325     1.804     0.200
    54.478     1.447     0.200
    54.486     0.120     0.200
    54.510    -1.065     0.200
    54.599     1.334     0.200
    54.914     2.074     0.200
    55.087     1.568     0.200
    55.205     0.971     0.200
    55.205     0.726     0.200
    55.341     1.414     0.200
    55.377     1.314     0.200
    55.395     1.038     0.200
    55.395     0.687     0.200
    55.395     1.007     0.200
    55.477     1.238     0.200
    55.549     1.458     0.200
    55.646     0.282     0.200
    55.648     0.725     0.200
    55.772     1.779     0.200
    55.785     0.806     0.200
    55.791     0.848     0.200
    55.791     0.638     0.200
    55.795     0.472     0.200
    55.786     1.858     0.200
    55.786     2.088     0.200
    55.912     1.164     0.200
    55.930     1.443     0.200
    55.973     0.378     0.200
    55.984     0.820     0.200
    56.380     1.113     0.200
    56.514     0.501     0.200
    56.593     0.335     0.200
    56.615     0.356     0.200
    56.664     1.683     0.200
    56.791    -1.353     0.200
    57.003     0.429     0.200
    57.441    -0.124     0.200
    57.908     1.569     0.200
    58.365     1.532     0.200
    58.507     0.863     0.200
    58.512     0.011     0.200
    58.950     0.742     0.200
    58.952    -0.276     0.200
    59.122     0.963     0.200
    59.133     1.641     0.200
    59.508     0.600     0.200
    60.072     1.144     0.200
    60.518     0.335     0.200
    60.719     1.317     0.200
    60.947    -0.758     0.200
    61.516    -1.300     0.200
    61.986     0.441     0.200
    61.986     0.691     0.200
    62.974     1.592     0.200
    62.974     1.282     0.200
    63.151     0.844     0.200
    63.173     0.316     0.200
    63.184     1.016     0.200
    63.252    -1.116     0.200
    64.719     0.322     0.200
    64.752     1.952     0.200
    64.937     0.956     0.200
    64.957    -0.466     0.200
    65.127    -0.557     0.200
    65.127     0.303     0.200
    65.362     0.986     0.200
    65.444     1.449     0.200
    65.444     1.619     0.200
    65.726     1.443     0.200
    65.804     1.520     0.200
    65.817     1.240     0.200
    66.169     1.015     0.200
    66.259     1.849     0.200
    66.259     1.102     0.200
    66.377     1.244     0.200
    66.421     0.965     0.200
    66.485     0.265     0.200
    66.546     0.163     0.200
    66.774     0.139     0.200
    66.901     1.758     0.200
    66.942     1.598     0.200
    66.994     1.560     0.200
    67.369     0.601     0.200
    67.369     0.921     0.200
    67.424     1.385     0.200
    67.574     1.076     0.200
    68.318     0.860     0.200
    68.317     1.542     0.200
    68.362     1.743     0.200
    68.611     2.074     0.200
    68.663     2.000     0.200
    68.763     3.378     0.200
    68.771     1.331     0.200
    68.926     1.224     0.200
    69.116     2.377     0.200
    69.509     2.434     0.200
    69.509     1.874     0.200
    69.610     1.451     0.200
    69.854    -0.882     0.200
    70.159     1.556     0.200
    70.502     1.589     0.200
    71.067    -0.877     0.200
    76.878     0.924     0.200
    76.878     1.154     0.200
    76.878     0.614     0.200
    77.164     0.247     0.200
    77.347     0.718     0.200
    78.017     0.738     0.200
    78.017     0.638     0.200
    78.017     0.988     0.200
    78.020     0.470     0.200
    78.074     1.346     0.200
    78.471     1.474     0.200
    78.471     0.325     0.200
    79.110     0.531     0.200
    79.133     0.534     0.200
    79.133     1.424     0.200
    79.367     1.060     0.200
    79.457     0.487     0.200
    79.487     0.875     0.200
    79.623     1.246     0.200
    79.631     0.664     0.200
    79.857     0.627     0.200
    80.037     1.104     0.200
    80.057     0.944     0.200
    80.154     1.183     0.200
    80.172     1.015     0.200
    80.172     0.614     0.200
    80.276     0.955     0.200
    80.285     0.857     0.200
    80.327     1.071     0.200
    80.327     1.561     0.200
    80.387     1.146     0.200
    80.437     0.480     0.200
    80.450     0.709     0.200
    80.462     1.524     0.200
    80.538     1.106     0.200
    80.815     0.652     0.200
    80.920     1.484     0.200
    80.920     1.384     0.200
    80.887     1.508     0.200
    80.953     2.107     0.200
    80.966     1.641     0.200
    81.162     0.944     0.200
    81.157     1.475     0.200
    81.211     1.738     0.200
    81.214     0.479     0.200
    81.329     2.108     0.200
    81.349     1.602     0.200
    81.392     1.176     0.200
    81.466     1.082     0.200
    81.473     1.848     0.200
    81.521     0.383     0.200
    81.521     1.792     0.200
    81.557     1.803     0.200
    81.578     1.960     0.200
    81.627     1.785     0.200
    81.629     1.510     0.200
    81.680     1.132     0.200
    81.682     1.814     0.200
    81.682     1.120     0.200
    81.682     0.544     0.200
    81.752     1.836     0.200
    81.808     0.379     0.200
    81.850     1.856     0.200
    81.899     2.297     0.200
    81.899     1.888     0.200
    81.922     1.592     0.200
    81.932     1.527     0.200
    81.932     1.408     0.200
    81.985     0.516     0.200
    82.027     1.717     0.200
    82.038     1.442     0.200
    82.085     1.921     0.200
    82.105     1.616     0.200
    82.142     1.625     0.200
    82.188     2.194     0.200
    82.208     1.437     0.200
    82.327     1.935     0.200
    82.325     1.068     0.200
    82.340     0.689     0.200
    82.340     1.149     0.200
    82.359     2.191     0.200
    82.454     0.892     0.200
    82.476     1.906     0.200
    82.522     2.151     0.200
    82.657     0.937     0.200
    82.703     0.556     0.200
    82.735     1.610     0.200
    82.806     1.761     0.200
    82.806     1.491     0.200
    82.837     1.589     0.200
    82.856     1.790     0.200
    82.867     1.996     0.200
    82.869     1.764     0.200
    82.940     1.387     0.200
    82.940     0.468     0.200
    82.940     0.968     0.200
    82.934     0.798     0.200
    82.947     1.599     0.200
    83.129     1.780     0.200
    83.155     2.103     0.200
    83.242     1.796     0.200
    83.312     1.546     0.200
    83.312     1.016     0.200
    83.317     1.199     0.200
    83.591     2.349     0.200
    83.660     2.067     0.200
    83.713     1.937     0.200
    83.719     2.223     0.200
    83.726     2.310     0.200
    83.782     1.481     0.200
    83.812     2.079     0.200
    83.956     1.341     0.200
    83.999     0.665     0.200
    84.060     1.411     0.200
    84.115     0.182     0.200
    84.115     0.034     0.200
    84.115    -0.166     0.200
    84.106     2.698     0.200
    84.116     5.895     0.200
    84.126     1.830     0.200
    84.181     1.979     0.200
    84.319     1.695     0.200
    84.343     1.275     0.200
    84.396     1.828     0.200
    84.537     2.012     0.200
    84.531     2.035     0.200
    84.771     1.315     0.200
    84.771     1.735     0.200
    84.778     1.146     0.200
    84.801    -0.005     0.200
    84.910     0.524     0.200
    84.924     1.365     0.200
    84.923     2.490     0.200
    84.964     2.564     0.200
    84.985     2.515     0.200
    85.037     1.076     0.200
    85.056     1.704     0.200
    85.056     2.084     0.200
    85.056     1.444     0.200
    85.060     2.563     0.200
    85.082     1.071     0.200
    85.106     0.930     0.200
    85.106     0.830     0.200
    85.106     0.905     0.200
    85.135     1.354     0.200
    85.193     0.198     0.200
    85.193     0.198     0.200
    85.193     0.318     0.200
    85.193     0.817     0.200
    85.193     0.118     0.200
    85.199     2.753     0.200
    85.284     1.063     0.200
    85.368     0.730     0.200
    85.394     0.483     0.200
    85.394     0.123     0.200
    85.394     2.093     0.200
    85.422     1.513     0.200
    85.438    -0.129     0.200
    85.552     1.507     0.200
    85.874     1.136     0.200
    86.031     1.122     0.200
    86.032     5.293     0.200
    86.131     6.040     0.200
    86.084     2.268     0.200
    86.197     0.833     0.200
    86.197     0.283     0.200
    86.219     1.105     0.200
    86.270     0.882     0.200
    86.332     0.850     0.200
    86.331     1.872     0.200
    86.408     0.375     0.200
    86.599     5.503     0.200
    86.621     1.830     0.200
    86.621     0.970     0.200
    86.652     0.577     0.200
    86.667     0.906     0.200
    86.752     1.287     0.200
    86.866    -0.070     0.200
    86.901     0.472     0.200
    86.959     0.537     0.200
    86.968    -0.865     0.200
    87.094     0.658     0.200
    87.095     0.114     0.200
    87.185    -1.220     0.200
    87.196    -1.275     0.200
    87.228     0.280     0.200
    87.323     0.012     0.200
    87.562    -0.542     0.200
    87.610     4.600     0.200
    87.662     8.709     0.200
    87.717     0.911     0.200
    87.717     1.161     0.200
    87.807     0.088     0.200
    88.251    -0.416     0.200
    88.546    -0.208     0.200
    88.565     0.642     0.200
    88.645     0.627     0.200
    88.648    -0.089     0.200
    88.709    -0.026     0.200
    88.801     1.091     0.200
    88.824     1.383     0.200
    88.927    -0.203     0.200
    88.934    -0.336     0.200
    88.943     0.572     0.200
    88.985     0.025     0.200
    88.989     1.109     0.200
    88.999     2.158     0.200
    89.088     0.740     0.200
    89.122     0.782     0.200
    89.515     0.639     0.200
    89.577     1.051     0.200
    89.592     0.379     0.200
    89.592     0.779     0.200
    89.813     1.245     0.200
    89.847     1.289     0.200
    89.863     0.813     0.200
    89.883     0.919     0.200
    89.900     1.068     0.200
    89.912    -0.117     0.200
    90.031     1.480     0.200
    90.232     0.392     0.200
    90.319     0.683     0.200
    90.386     1.175     0.200
    90.631     0.891     0.200
    90.632     0.860     0.200
    90.666    -0.032     0.200
    90.738    -0.413     0.200
    90.738    -0.664     0.200
    90.738    -0.194     0.200
    90.738    -0.413     0.200
    90.813     0.817     0.200
    90.904     1.164     0.200
    91.002     1.231     0.200
    91.053     1.073     0.200
    91.052     1.176     0.200
    91.060     1.560     0.200
    91.143     1.352     0.200
    91.433     1.161     0.200
    91.545     0.890     0.200
    91.549     1.294     0.200
    91.638     0.975     0.200
    91.705     1.121     0.200
    91.828     1.061     0.200
    91.843     1.211     0.200
    91.990     1.074     0.200
    92.061     1.254     0.200
    92.065     1.283     0.200
    92.245     0.112     0.200
    92.245     0.452     0.200
    92.335     0.638     0.200
    92.462     1.130     0.200
    92.462     0.796     0.200
    92.466     0.530     0.200
    92.490    -0.280     0.200
    92.509     1.335     0.200
    92.575     0.752     0.200
    92.795    -1.266     0.200
    92.822     1.089     0.200
    92.838     1.244     0.200
    92.855     1.337     0.200
    92.981     1.167     0.200
    92.981     0.657     0.200
    92.982    -0.448     0.200
    93.107     0.774     0.200
    93.163     0.590     0.200
    93.163     1.517     0.200
    93.224     0.635     0.200
    93.300     1.065     0.200
    93.567     0.913     0.200
    93.825     1.168     0.200
    93.825     1.068     0.200
    93.851     0.948     0.200
    94.080     0.739     0.200
    94.080     1.398     0.200
    94.080     1.199     0.200
    94.169     1.195     0.200
    94.198    -0.157     0.200
    94.360     0.318     0.200
    94.370    -0.287     0.200
    94.369     0.870     0.200
    94.419     0.439     0.200
    94.432     0.053     0.200
    94.510     1.473     0.200
    94.564     1.475     0.200
    94.664     2.118     0.200
    94.729     1.559     0.200
    94.697     1.168     0.200
    94.708     0.848     0.200
    94.706     0.624     0.200
    94.719     0.568     0.200
    94.720     0.662     0.200
    94.724     2.342     0.200
    94.724     2.042     0.200
    94.833     0.545     0.200
    94.852     0.718     0.200
    95.019     0.934     0.200
    95.019     0.753     0.200
    95.059     0.609     0.200
    95.111     0.720     0.200
    95.207     2.036     0.200
    95.469     2.237     0.200
    95.507     0.962     0.200
    95.608     2.303     0.200
    95.753     1.271     0.200
    96.011     0.796     0.200
    96.011     0.388     0.200
    96.115     0.195     0.200
    96.191     2.551     0.200
    96.418     1.409     0.200
    96.418     1.852     0.200
    96.418     1.119     0.200
    96.537    -0.420     0.200
    96.670     1.296     0.200
    96.670     1.575     0.200
    96.874     1.221     0.200
    96.874     1.121     0.200
    97.275    -0.062     0.200
    97.427    -0.447     0.200
    97.750     0.409     0.200
    97.750     0.097     0.200
    98.681    -0.281     0.200
    98.756     0.105     0.200
    98.760    -0.365     0.200
    98.760     0.088     0.200
    99.028    -1.731     0.200
    99.331    -0.580     0.200
    99.341    -0.528     0.200
    18.388     1.690     0.200
    18.454    -1.033     0.200
    18.597     2.157     0.200
    18.597     2.028     0.200
    18.848    -1.296     0.200
    18.848    -0.687     0.200
    18.844     1.784     0.200
    18.930     0.199     0.200
    18.930    -0.344     0.200
    18.998     2.304     0.200
    19.253     1.912     0.200
    19.253     3.108     0.200
    19.306     3.402     0.200
    19.416     2.204     0.200
    19.416     1.794     0.200
    19.515     2.870     0.200
    19.515     2.280     0.200
    19.566     0.074     0.200
    19.631    -0.381     0.200
    19.645    -0.974     0.200
    19.650     2.035     0.200
    19.659     1.985     0.200
    19.754     2.073     0.200
    19.801    -0.853     0.200
    19.822    -1.323     0.200
    20.079    -1.087     0.200
    20.214     1.828     0.200
    20.220    -1.364     0.200
    20.310    -1.115     0.200
    20.381     1.330     0.200
    20.377     0.592     0.200
    20.397     1.127     0.200
    20.451     2.042     0.200
    20.542     1.401     0.200
    20.546     1.513     0.200
    20.594     2.058     0.200
    20.599     2.091     0.200
    20.603     1.951     0.200
    20.645     1.948     0.200
    20.651     1.458     0.200
    20.660     2.741     0.200
    20.705     0.932     0.200
    20.736     2.723     0.200
    20.736     1.430     0.200
    20.839    -1.371     0.200
    20.839    -1.235     0.200
    20.935     3.033     0.200
    20.944    -0.032     0.200
    21.087     1.075     0.200
    21.163     2.655     0.200
    21.239    -0.933     0.200
    21.318    -1.459     0.200
    21.331    -0.867     0.200
    21.540    -0.983     0.200
    21.617    -1.381     0.200
    21.609     0.464     0.200
    21.669    -0.423     0.200
    21.669    -1.271     0.200
    21.673     1.632     0.200
    21.686     1.106     0.200
    21.748     0.422     0.200
    21.748    -0.953     0.200
    21.762    -0.096     0.200
    21.762    -0.619     0.200
    21.789     2.420     0.200
    21.789     1.982     0.200
    21.886     1.361     0.200
    21.886     1.755     0.200
    22.006    -1.186     0.200
    22.114    -1.424     0.200
    22.119    -0.729     0.200
    22.197    -0.975     0.200
    22.230    -1.105     0.200
    22.270     1.716     0.200
    22.306    -1.476     0.200
    22.351     2.064     0.200
    22.351     1.884     0.200
    22.426    -0.936     0.200
    22.466    -1.278     0.200
    22.506    -0.842     0.200
    22.520    -1.138     0.200
    22.520    -0.982     0.200
    22.620    -1.630     0.200
    22.625    -1.604     0.200
    22.632    -1.403     0.200
    22.674     2.491     0.200
    22.674     1.671     0.200
    22.687    -1.737     0.200
    22.679     1.131     0.200
    22.795    -1.319     0.200
    23.009    -1.086     0.200
    23.043    -1.908     0.200
    23.186    -1.677     0.200
    23.254    -1.598     0.200
    23.316    -1.818     0.200
    23.325    -1.720     0.200
    23.345    -1.546     0.200
    23.401    -2.093     0.200
    23.547    -1.324     0.200
    23.547    -1.660     0.200
    23.580    -1.907     0.200
    23.642     2.519     0.200
    23.696     1.977     0.200
    23.759    -2.106     0.200
    23.827    -2.300     0.200
    23.873     2.374     0.200
    23.937    -1.515     0.200
    23.941     2.582     0.200
    23.941     2.578     0.200
    24.111    -1.875     0.200
    24.111    -1.223     0.200
    24.154    -2.097     0.200
    24.191    -2.046     0.200
    24.203     1.412     0.200
    24.302    -1.403     0.200
    24.302    -1.149     0.200
    24.346     2.016     0.200
    24.414    -1.417     0.200
    24.484    -0.905     0.200
    24.495    -1.437     0.200
    24.548     2.448     0.200
    24.566    -2.649     0.200
    24.624     1.973     0.200
    24.648    -1.756     0.200
    24.691    -1.003     0.200
    24.797    -1.527     0.200
    24.794    -2.208     0.200
    24.832    -1.978     0.200
    24.828     2.449     0.200
    24.884    -1.804     0.200
    24.900    -0.833     0.200
    24.900    -1.431     0.200
    24.995     0.360     0.200
    25.083     2.727     0.200
    25.117    -1.974     0.200
    25.181    -1.288     0.200
    25.181    -1.581     0.200
    25.237    -2.140     0.200
    25.277    -1.641     0.200
    25.268     0.961     0.200
    25.317    -1.995     0.200
    25.345    -1.436     0.200
    25.496    -1.443     0.200
    25.540    -0.667     0.200
    25.716    -1.643     0.200
    25.805    -1.618     0.200
    25.839    -1.853     0.200
    25.978    -1.560     0.200
    26.002    -1.640     0.200
    26.008     0.860     0.200
    26.056     2.056     0.200
    26.180    -1.161     0.200
    26.693    -1.697     0.200
    26.756    -2.890     0.200
    26.780    -2.933     0.200
    26.822    -2.256     0.200
    26.879    -2.281     0.200
    26.895     0.697     0.200
    27.005    -2.509     0.200
    27.072    -2.008     0.200
    27.164    -1.492     0.200
    27.451    -1.513     0.200
    27.640    -1.872     0.200
    27.648    -1.436     0.200
    28.171    -0.785     0.200
    28.497    -2.524     0.200
    28.931    -1.261     0.200
    30.602    -0.919     0.200
    30.736    -2.251     0.200
    31.190    -1.545     0.200
    32.498    -0.525     0.200
    32.566    -2.038     0.200
    32.601    -2.235     0.200
    44.637     2.417     0.200
    46.690     0.806     0.200
    46.690     2.236     0.200
    48.830     2.013     0.200
    48.830     1.127     0.200
    51.855     0.344     0.200
    52.262     1.534     0.200
    52.540     0.800     0.200
    52.776     0.744     0.200
    52.776    -0.034     0.200
    52.903     0.784     0.200
    53.111     1.606     0.200
    53.188     1.272     0.200
    53.295     1.488     0.200
    53.440     1.370     0.200
    53.521     0.337     0.200
    53.800     0.551     0.200
    54.390     1.258     0.200
    54.583     1.065     0.200
    54.583     0.889     0.200
    54.690     1.048     0.200
    54.752     1.572     0.200
    54.779     0.451     0.200
    54.779     0.502     0.200
    54.903     0.701     0.200
    55.021    -0.015     0.200
    55.023    -0.594     0.200
    55.173     0.367     0.200
    55.702     0.762     0.200
    55.864     0.621     0.200
    56.277     0.361     0.200
    57.262     0.609     0.200
    57.320     1.298     0.200
    57.947     0.539     0.200
    62.983     0.951     0.200
    62.983     2.193     0.200
    80.806     1.569     0.200
    80.807     1.563     0.200
    85.338     0.998     0.200
    85.466     0.809     0.200
    85.466     0.656     0.200
    85.466     0.656     0.200
    85.561     1.164     0.200
    14.337     4.667     0.200
    14.571     3.756     0.200
    14.571     6.775     0.200
    14.650     6.273     0.200
    14.999     4.879     0.200
    14.999     4.500     0.200
    15.409     3.150     0.200
    15.529     3.914     0.200
    15.650     3.220     0.200
    15.719     4.523     0.200
    16.414     2.602     0.200
    16.483     2.613     0.200
    16.483     3.066     0.200
    16.483     4.109     0.200
    16.694     2.720     0.200
    16.798     1.103     0.200
    16.798     2.025     0.200
    17.272     3.545     0.200
    17.755     3.227     0.200
    17.782     0.416     0.200
    18.102     2.981     0.200
    18.110     2.710     0.200
    18.118     2.125     0.200
    18.118     2.441     0.200
    19.508    -1.352     0.200
    19.858    -1.333     0.200
    19.864    -0.917     0.200
    19.962     1.798     0.200
    20.175     2.548     0.200
    20.239     0.563     0.200
    20.399     2.151     0.200
    20.407     2.471     0.200
    20.465     1.773     0.200
    20.669     0.730     0.200
    20.758     2.641     0.200
    21.020    -1.152     0.200
    21.104     2.228     0.200
    21.112     2.605     0.200
    21.137     2.336     0.200
    21.232     1.536     0.200
    21.251     3.088     0.200
    21.251     2.752     0.200
    21.259     0.847     0.200
    21.313     1.649     0.200
    21.313     2.219     0.200
    21.337     0.647     0.200
    21.477    -1.106     0.200
    21.488     2.907     0.200
    21.533    -1.636     0.200
    21.540    -0.017     0.200
    21.600     1.898     0.200
    21.654     0.979     0.200
    21.681     1.970     0.200
    21.707     2.797     0.200
    21.773     3.100     0.200
    21.801     3.086     0.200
    21.825     1.262     0.200
    21.863    -0.801     0.200
    21.920    -1.400     0.200
    21.895     2.111     0.200
    21.956    -0.794     0.200
    21.989    -1.559     0.200
    22.159     2.952     0.200
    22.159     2.765     0.200
    22.352    -1.927     0.200
    22.338     2.242     0.200
    22.374    -2.298     0.200
    22.426    -1.111     0.200
    22.587    -1.869     0.200
    22.620    -1.042     0.200
    22.620    -1.828     0.200
    22.824    -2.082     0.200
    22.834    -1.978     0.200
    22.843    -1.830     0.200
    22.871     0.975     0.200
    22.973    -2.316     0.200
    23.082     2.325     0.200
    23.136     1.837     0.200
    23.329     1.612     0.200
    23.396     2.275     0.200
    23.396     2.278     0.200
    23.450    -2.647     0.200
    23.473    -2.114     0.200
    23.480    -1.694     0.200
    23.485    -2.148     0.200
    23.625    -1.446     0.200
    23.625    -2.427     0.200
    23.642    -1.744     0.200
    23.657     1.761     0.200
    23.809     2.103     0.200
    23.912    -1.590     0.200
    24.020    -1.927     0.200
    24.027    -2.007     0.200
    24.063    -1.205     0.200
    24.128     0.234     0.200
    24.134     1.639     0.200
    24.415    -1.985     0.200
    24.531     2.471     0.200
    24.557    -1.942     0.200
    24.601     1.272     0.200
    24.601     1.268     0.200
    24.644    -2.366     0.200
    24.839    -1.024     0.200
    24.921     1.910     0.200
    24.962    -1.349     0.200
    24.965    -0.972     0.200
    25.011    -1.182     0.200
    25.022    -2.073     0.200
    25.039    -1.183     0.200
    25.068    -0.893     0.200
    25.226    -0.846     0.200
    25.366    -0.249     0.200
    25.366    -0.855     0.200
    25.461    -0.371     0.200
    25.550     0.835     0.200
    25.603     2.315     0.200
    26.438     1.096     0.200
    26.984    -2.181     0.200
    27.702     1.062     0.200
    27.710     0.650     0.200
    27.769    -2.372     0.200
    27.889     0.139     0.200
    28.295    -0.808     0.200
    28.502    -1.504     0.200
    28.628     1.032     0.200
    29.037    -1.298     0.200
    29.751     1.001     0.200
    30.419    -0.993     0.200
    31.725     0.985     0.200
    31.761    -1.573     0.200
    32.176    -1.739     0.200
    32.852     0.579     0.200
    34.002    -2.261     0.200
    34.295    -2.593     0.200
    34.775    -1.531     0.200
    44.164     0.916     0.200
    44.526    -0.972     0.200
    44.526    -0.975     0.200
    52.331    -0.580     0.200
    53.100     0.426     0.200
    54.293     0.943     0.200
    54.293     1.212     0.200
    54.462     0.835     0.200
    55.784     1.052     0.200
    57.485     0.021     0.200
    77.865     1.016     0.200
    77.865     1.020     0.200
    80.217     0.691     0.200
    80.218     0.681     0.200
    85.216     0.230     0.200
    85.820     1.672     0.200
    13.623     4.958     0.200
    13.623     2.583     0.200
    13.685     5.142     0.200
    13.685     3.095     0.200
    13.755     5.684     0.200
    14.388     2.000     0.200
    14.566     4.055     0.200
    14.959     4.033     0.200
    14.995     2.119     0.200
    15.031     2.758     0.200
    15.118     2.038     0.200
    15.556     2.536     0.200
    15.556     1.809     0.200
    15.715     1.609     0.200
    15.715     3.413     0.200
    16.102     2.220     0.200
    16.586     3.620     0.200
    16.586     3.065     0.200
    16.898     0.324     0.200
    17.571    -1.868     0.200
    17.868    -0.502     0.200
    17.881    -0.113     0.200
    18.028     0.316     0.200
    18.338     0.082     0.200
    18.897     0.589     0.200
    19.411    -1.646     0.200
    19.688    -0.534     0.200
    20.195     0.995     0.200
    20.335    -1.363     0.200
    20.461     3.144     0.200
    20.829     2.217     0.200
    21.077     0.145     0.200
    21.979    -1.794     0.200
    22.057    -1.064     0.200
    22.455     1.516     0.200
    22.768    -2.706     0.200
    22.858     0.002     0.200
    23.060    -2.285     0.200
    23.187    -2.125     0.200
    23.501    -0.155     0.200
    23.854    -0.110     0.200
    23.894    -2.239     0.200
    24.004    -1.158     0.200
    24.100    -2.239     0.200
    24.356    -1.521     0.200
    24.528    -0.723     0.200
    24.604    -1.077     0.200
    29.081     1.071     0.200
    29.628     1.965     0.200
    30.511     1.033     0.200
    30.942     2.527     0.200
    31.067     3.213     0.200
    31.116     3.749     0.200
    31.120     0.956     0.200
    31.182     3.331     0.200
    31.209     1.962     0.200
    31.433    -1.013     0.200
    31.589     2.713     0.200
    32.628     2.033     0.200
    33.618     0.886     0.200
    33.618     1.472     0.200
    35.392     1.559     0.200
    43.753    -1.244     0.200
    45.083    -2.453     0.200
    52.380    -1.385     0.200
    67.251     0.864     0.200
    16.456     4.042     0.200
    16.799     3.856     0.200
    23.862     0.974     0.200
    24.700     0.362     0.200
    24.700     1.175     0.200
    25.357     1.287     0.200
    25.357     0.692     0.200
    55.347     0.390     0.200
    55.347     0.164     0.200
    55.871     0.591     0.200
    58.428    -0.626     0.200
    98.599    -0.808     0.200
    16.994     2.684     0.200
    19.463     0.972     0.200
    19.558     0.933     0.200
    21.183     1.737     0.200
    21.186     0.424     0.200
    21.750     1.098     0.200
    24.059    -0.487     0.200
    24.591    -1.856     0.200
    24.664     1.764     0.200
    24.664     2.147     0.200
    25.054     1.662     0.200
    27.838     2.279     0.200
    45.279    -1.874     0.200
    54.005    -0.215     0.200
    54.005    -0.586     0.200
    55.379     0.426     0.200
    55.887     1.237     0.200
    24.207     4.288     0.200
    15.487     4.066     0.200
    16.843     2.778     0.200
    17.708     3.131     0.200
    17.941     3.287     0.200
    18.321     2.860     0.200
    18.452    -1.293     0.200
    18.475     0.562     0.200
    18.583     1.527     0.200
    18.571    -0.871     0.200
    18.694    -0.208     0.200
    18.727    -0.622     0.200
    18.763    -0.001     0.200
    18.806     0.145     0.200
    18.812     1.509     0.200
    18.834     2.125     0.200
    18.834     1.509     0.200
    18.843    -1.148     0.200
    18.927    -0.535     0.200
    18.927     0.236     0.200
    19.044    -0.520     0.200
    19.183     0.438     0.200
    19.166     1.225     0.200
    19.233     0.062     0.200
    19.297     0.252     0.200
    19.372     0.412     0.200
    19.376     0.052     0.200
    19.404     1.275     0.200
    19.404     1.725     0.200
    19.409    -0.570     0.200
    19.410    -0.112     0.200
    19.505     1.143     0.200
    19.505     1.853     0.200
    19.502     0.575     0.200
    19.566    -0.043     0.200
    19.564     0.446     0.200
    19.564    -0.650     0.200
    19.564    -0.588     0.200
    19.647     1.342     0.200
    19.634    -0.981     0.200
    19.643    -0.180     0.200
    19.819    -1.153     0.200
    19.900     0.068     0.200
    20.218    -1.107     0.200
    20.311     2.531     0.200
    20.308    -1.007     0.200
    20.308    -0.702     0.200
    20.365     1.833     0.200
    20.384     0.917     0.200
    20.415     0.811     0.200
    20.437     1.242     0.200
    20.455    -1.022     0.200
    20.482     1.277     0.200
    20.487     1.538     0.200
    20.495     1.815     0.200
    20.514    -1.066     0.200
    20.585     2.311     0.200
    20.612     0.677     0.200
    20.628     1.787     0.200
    20.654    -0.521     0.200
    20.691     0.567     0.200
    20.695     0.385     0.200
    20.695     0.576     0.200
    20.742     2.181     0.200
    20.741     1.448     0.200
    20.738    -0.517     0.200
    20.738    -0.842     0.200
    20.803    -0.623     0.200
    20.841    -1.050     0.200
    20.841    -0.771     0.200
    20.920     1.170     0.200
    20.932     2.225     0.200
    21.026     2.345     0.200
    21.048     1.743     0.200
    21.093     0.249     0.200
    21.076     1.745     0.200
    21.062    -0.465     0.200
    21.090    -0.255     0.200
    21.107     1.053     0.200
    21.150     1.628     0.200
    21.239     2.775     0.200
    21.232    -0.882     0.200
    21.262     0.811     0.200
    21.310     2.906     0.200
    21.341     1.916     0.200
    21.294    -1.078     0.200
    21.440     0.463     0.200
    21.456     0.536     0.200
    21.554     2.448     0.200
    21.554     0.998     0.200
    21.541    -1.504     0.200
    21.579     1.901     0.200
    21.560     0.979     0.200
    21.603    -1.077     0.200
    21.603     0.622     0.200
    21.636     3.009     0.200
    21.626    -0.619     0.200
    21.671     2.534     0.200
    21.670     2.533     0.200
    21.678     1.256     0.200
    21.718    -1.434     0.200
    21.773     2.338     0.200
    21.772     0.890     0.200
    21.750    -1.173     0.200
    21.763    -1.567     0.200
    21.871     2.461     0.200
    21.865    -0.424     0.200
    21.947     1.774     0.200
    22.029     1.784     0.200
    22.065     2.122     0.200
    22.075     1.026     0.200
    22.107    -1.537     0.200
    22.125     0.001     0.200
    22.157     1.374     0.200
    22.198     1.073     0.200
    22.200     0.434     0.200
    22.254     2.122     0.200
    22.217    -1.155     0.200
    22.335     3.284     0.200
    22.335     2.666     0.200
    22.423    -1.543     0.200
    22.469     2.740     0.200
    22.520    -2.122     0.200
    22.660     1.531     0.200
    22.660     1.983     0.200
    22.668     0.847     0.200
    22.741     0.118     0.200
    22.806     2.885     0.200
    22.796    -0.426     0.200
    22.851     1.880     0.200
    23.008    -0.092     0.200
    23.037    -0.299     0.200
    23.043    -1.160     0.200
    23.138     2.265     0.200
    23.207    -1.435     0.200
    23.318     1.687     0.200
    23.318     1.119     0.200
    23.319     0.815     0.200
    23.325    -1.827     0.200
    23.338    -1.298     0.200
    23.404    -2.228     0.200
    23.518    -0.723     0.200
    23.557     2.318     0.200
    23.568     2.418     0.200
    23.681     2.959     0.200
    23.858     2.451     0.200
    23.879     1.673     0.200
    23.926     2.598     0.200
    23.926     1.121     0.200
    23.938    -1.575     0.200
    23.996    -1.243     0.200
    24.095    -1.370     0.200
    24.115    -1.266     0.200
    24.113    -1.192     0.200
    24.188     2.209     0.200
    24.295     1.698     0.200
    24.331     2.751     0.200
    24.304    -1.673     0.200
    24.385    -0.606     0.200
    24.461     0.262     0.200
    24.461     1.342     0.200
    24.533     2.528     0.200
    24.568    -1.780     0.200
    24.610     1.440     0.200
    24.660     1.784     0.200
    24.694    -1.282     0.200
    24.900    -1.637     0.200
    24.900    -1.155     0.200
    24.983     0.566     0.200
    24.983     2.088     0.200
    24.983     1.268     0.200
    24.983     1.948     0.200
    25.067     1.406     0.200
    25.184    -1.506     0.200
    25.253     3.028     0.200
    25.278    -2.061     0.200
    25.278    -1.624     0.200
    25.342    -1.656     0.200
    25.450     2.659     0.200
    25.496    -1.598     0.200
    25.508    -1.009     0.200
    25.545    -1.785     0.200
    25.569    -0.280     0.200
    25.794     0.859     0.200
    25.806     1.802     0.200
    25.842    -1.680     0.200
    25.842    -1.426     0.200
    25.916    -1.181     0.200
    25.996     0.808     0.200
    26.003    -1.704     0.200
    26.045     0.556     0.200
    26.045     0.666     0.200
    26.331    -1.291     0.200
    26.373     2.194     0.200
    26.340    -1.555     0.200
    26.380    -1.092     0.200
    26.693    -2.070     0.200
    26.803     1.059     0.200
    26.803     2.419     0.200
    27.006     0.210     0.200
    27.081     2.589     0.200
    27.072    -1.633     0.200
    27.230     1.262     0.200
    27.354     1.073     0.200
    27.372    -1.624     0.200
    27.407    -1.511     0.200
    27.499     1.462     0.200
    27.549    -1.770     0.200
    27.643     2.531     0.200
    27.651    -2.035     0.200
    27.651    -1.835     0.200
    27.993    -1.712     0.200
    28.072     0.585     0.200
    28.090     2.084     0.200
    28.106     0.400     0.200
    28.106     0.299     0.200
    28.119    -1.526     0.200
    28.172    -2.755     0.200
    28.431     1.360     0.200
    28.615     0.363     0.200
    28.766     4.442     0.200
    28.790     0.761     0.200
    28.949    -0.062     0.200
    29.142     1.638     0.200
    29.109    -2.275     0.200
    29.287    -1.168     0.200
    29.450     4.067     0.200
    29.516    -2.189     0.200
    29.786     0.325     0.200
    29.807     3.481     0.200
    29.917    -0.197     0.200
    30.009     2.428     0.200
    30.037     1.394     0.200
    30.139     0.176     0.200
    30.139     0.352     0.200
    30.148    -1.758     0.200
    30.196    -1.667     0.200
    30.215    -2.618     0.200
    30.286     1.093     0.200
    30.277    -2.127     0.200
    30.417     1.361     0.200
    30.525    -1.305     0.200
    30.595    -1.110     0.200
    30.652     4.360     0.200
    30.664    -2.215     0.200
    30.785     0.933     0.200
    30.811    -1.400     0.200
    30.961     1.851     0.200
    31.052    -2.249     0.200
    31.180    -1.402     0.200
    31.298    -1.894     0.200
    31.307    -1.608     0.200
    31.352     1.613     0.200
    31.944     1.748     0.200
    32.698     1.004     0.200
    32.755    -1.642     0.200
    32.918    -2.505     0.200
    33.332    -2.356     0.200
    33.371    -2.253     0.200
    33.384    -2.130     0.200
    34.499    -2.435     0.200
    34.643    -2.402     0.200
    34.711    -2.263     0.200
    34.880    -2.698     0.200
    35.124    -2.542     0.200
    35.292    -2.032     0.200
    35.462    -1.343     0.200
    35.526    -1.840     0.200
    35.530    -2.903     0.200
    35.580    -2.852     0.200
    35.673    -2.425     0.200
    35.777    -2.447     0.200
    35.891    -2.452     0.200
    35.924    -2.238     0.200
    35.950    -1.825     0.200
    35.987    -2.306     0.200
    36.194    -2.965     0.200
    36.260    -2.097     0.200
    36.375    -1.924     0.200
    36.421    -0.055     0.200
    36.422    -1.632     0.200
    36.489    -0.719     0.200
    36.642    -1.862     0.200
    36.714    -1.993     0.200
    36.969    -1.246     0.200
    36.984    -1.694     0.200
    37.134    -1.462     0.200
    37.149    -1.422     0.200
    37.424    -1.853     0.200
    37.628    -1.447     0.200
    37.639    -1.636     0.200
    37.687    -1.745     0.200
    37.810    -2.012     0.200
    38.142    -1.906     0.200
    38.198    -0.935     0.200
    38.355    -1.675     0.200
    38.375    -2.407     0.200
    38.375    -1.727     0.200
    38.487    -1.811     0.200
    38.828    -1.392     0.200
    38.839    -1.707     0.200
    39.062    -1.876     0.200
    39.063    -1.336     0.200
    39.099    -2.655     0.200
    39.114    -2.167     0.200
    39.234    -2.271     0.200
    39.429    -1.842     0.200
    39.452    -1.646     0.200
    39.462    -2.245     0.200
    39.677    -2.332     0.200
    39.720    -1.891     0.200
    39.720    -1.103     0.200
    39.945    -1.304     0.200
    39.993    -1.926     0.200
    39.993    -1.112     0.200
    40.074    -1.783     0.200
    40.125    -2.304     0.200
    40.247    -2.373     0.200
    40.247    -1.199     0.200
    40.248    -1.702     0.200
    40.594    -1.755     0.200
    40.762    -1.578     0.200
    42.136    -1.169     0.200
    43.447     1.052     0.200
    44.623     2.039     0.200
    44.879    -1.551     0.200
    47.916     1.023     0.200
    48.847     0.944     0.200
    48.922     1.845     0.200
    49.415     2.129     0.200
    50.392     2.556     0.200
    50.916     2.295     0.200
    50.936     1.272     0.200
    51.287     2.030     0.200
    51.350     1.833     0.200
    51.619     2.604     0.200
    51.632     1.050     0.200
    51.632     0.483     0.200
    51.836     1.585     0.200
    51.841     0.646     0.200
    51.936     1.394     0.200
    51.948     1.337     0.200
    52.018     2.125     0.200
    52.018     1.114     0.200
    52.247     1.583     0.200
    52.451     1.343     0.200
    52.458     1.571     0.200
    52.458     1.199     0.200
    52.526     1.164     0.200
    52.676     1.507     0.200
    52.716     1.588     0.200
    52.763     0.749     0.200
    52.763     0.612     0.200
    52.889     0.421     0.200
    52.889     1.136     0.200
    52.918     1.474     0.200
    52.918     1.824     0.200
    53.097     1.000     0.200
    53.128     0.776     0.200
    53.174     1.414     0.200
    53.281     1.401     0.200
    53.281     1.091     0.200
    53.415     0.854     0.200
    53.426     1.300     0.200
    53.426     1.754     0.200
    53.456     1.479     0.200
    53.523     1.105     0.200
    53.508     0.003     0.200
    53.508    -0.532     0.200
    53.508     0.668     0.200
    53.580     1.416     0.200
    53.584     0.734     0.200
    53.789     0.351     0.200
    53.800     0.783     0.200
    54.238     0.749     0.200
    54.500     1.256     0.200
    54.574     1.112     0.200
    54.569     0.113     0.200
    54.569     1.205     0.200
    54.674     1.026     0.200
    54.674     0.682     0.200
    54.675     1.892     0.200
    54.737     1.218     0.200
    54.765     0.982     0.200
    54.765     0.612     0.200
    54.765     0.892     0.200
    54.769     1.182     0.200
    54.769     1.535     0.200
    54.855     0.852     0.200
    54.889     0.617     0.200
    54.889     1.295     0.200
    54.961     0.841     0.200
    54.961     1.052     0.200
    55.006     0.175     0.200
    55.159     0.637     0.200
    55.159     0.982     0.200
    55.240     0.860     0.200
    55.240     1.240     0.200
    55.329     0.276     0.200
    55.339     0.813     0.200
    55.342     1.090     0.200
    55.424     0.329     0.200
    55.424     0.846     0.200
    55.535     1.021     0.200
    55.561     0.731     0.200
    55.656     0.674     0.200
    55.688     1.008     0.200
    55.688     1.237     0.200
    55.707     0.849     0.200
    55.738     1.159     0.200
    55.841     0.633     0.200
    55.841     1.338     0.200
    55.850     0.363     0.200
    55.850    -0.506     0.200
    56.110     0.792     0.200
    56.220     0.788     0.200
    56.237    -0.001     0.200
    56.262     0.766     0.200
    56.262     0.176     0.200
    56.289     0.362     0.200
    56.432     0.129     0.200
    56.660     0.285     0.200
    56.787     0.629     0.200
    57.084    -0.336     0.200
    57.330     0.053     0.200
    57.832     0.303     0.200
    57.934     0.754     0.200
    57.934     0.637     0.200
    61.970     1.116     0.200
    62.999     0.819     0.200
    63.814    -1.279     0.200
    64.201     1.408     0.200
    64.486    -0.354     0.200
    71.163    -1.106     0.200
    71.587    -0.138     0.200
    80.791     1.214     0.200
    81.990     1.860     0.200
    82.136     2.092     0.200
    82.257     1.462     0.200
    82.342     1.215     0.200
    82.381     1.214     0.200
    82.629     1.116     0.200
    82.687     2.014     0.200
    82.730     1.292     0.200
    82.730     1.182     0.200
    82.870     1.667     0.200
    82.949     1.357     0.200
    83.002     1.683     0.200
    83.138     1.380     0.200
    83.162     1.553     0.200
    83.201     2.251     0.200
    83.212     1.397     0.200
    83.514     1.837     0.200
    83.616    -0.032     0.200
    85.333    -0.747     0.200
    85.330     1.532     0.200
    85.464    -0.129     0.200
    85.464     0.196     0.200
    85.566     0.988     0.200
    85.566     1.493     0.200
    85.567     1.490     0.200
    91.002    -0.924     0.200
    91.186     0.870     0.200
    91.329    -0.194     0.200
    92.063     0.631     0.200
    92.239    -0.259     0.200
    92.295     0.336     0.200
    92.299     0.013     0.200
    93.014     0.767     0.200
    93.014     0.607     0.200
    93.865     0.334     0.200
    94.350     0.870     0.200
    94.382     0.626     0.200
    94.591     0.479     0.200
    94.591     0.869     0.200
    94.906     1.126     0.200
    95.188     1.832     0.200
    95.254     2.334     0.200
    14.914     3.221     0.200
    15.037     3.008     0.200
    15.169     4.486     0.200
    15.477     2.109     0.200
    15.874     6.428     0.200
    16.296     1.785     0.200
    16.296     1.520     0.200
    16.441     2.227     0.200
    16.646     4.113     0.200
    16.676     4.838     0.200
    17.181     0.580     0.200
    17.317     2.145     0.200
    17.314     1.259     0.200
    17.416     0.681     0.200
    17.500     3.905     0.200
    17.663     0.758     0.200
    17.777     0.446     0.200
    17.803     0.605     0.200
    17.968     1.818     0.200
    17.968     0.703     0.200
    17.999     0.275     0.200
    17.945     1.287     0.200
    18.061    -0.160     0.200
    18.175     0.719     0.200
    18.043     2.899     0.200
    18.241     0.494     0.200
    18.064     3.834     0.200
    18.370    -0.220     0.200
    18.391     0.678     0.200
    18.581     0.187     0.200
    18.684     0.842     0.200
    18.808     0.046     0.200
    19.555     1.484     0.200
    19.843     0.380     0.200
    19.781     1.103     0.200
    19.890    -0.376     0.200
    19.790     1.138     0.200
    19.865     0.436     0.200
    20.009     0.302     0.200
    20.459    -0.270     0.200
    20.500     0.816     0.200
    20.502     1.310     0.200
    20.759    -0.696     0.200
    20.633     0.297     0.200
    20.626     1.524     0.200
    20.982     0.343     0.200
    20.982     0.007     0.200
    21.155     3.266     0.200
    21.212     1.265     0.200
    21.212     0.923     0.200
    22.015     0.167     0.200
    22.730     0.013     0.200
    22.912    -1.871     0.200
    22.773     4.160     0.200
    22.773     2.483     0.200
    23.402    -1.041     0.200
    23.985     0.216     0.200
    23.985     1.896     0.200
    24.393    -0.247     0.200
    24.639    -1.684     0.200
    24.928    -2.236     0.200
    24.928    -1.072     0.200
    25.105    -0.818     0.200
    25.364     0.684     0.200
    25.412    -1.139     0.200
    25.817    -0.948     0.200
    25.813    -0.832     0.200
    25.811     0.116     0.200
    26.251     0.689     0.200
    26.511    -0.752     0.200
    26.511    -0.391     0.200
    30.569    -1.231     0.200
    30.877     1.934     0.200
    53.664     0.951     0.200
    54.995    -0.456     0.200
    79.613     1.390     0.200
    79.613     1.249     0.200
    84.715    -0.662     0.200
    14.682     6.806     0.200
    14.933     3.580     0.200
    15.259     3.916     0.200
    15.466     4.474     0.200
    15.466     3.286     0.200
    15.590     4.219     0.200
    15.649     4.382     0.200
    16.412     1.919     0.200
    16.588     1.546     0.200
    17.203     2.334     0.200
    17.239     1.991     0.200
    17.334     3.271     0.200
    17.334     2.779     0.200
    17.643     1.384     0.200
    17.696     2.533     0.200
    17.754     2.777     0.200
    17.758     2.321     0.200
    18.033     2.742     0.200
    18.039     2.411     0.200
    18.051     2.451     0.200
    18.131     2.585     0.200
    18.432    -1.017     0.200
    18.401    -2.208     0.200
    18.401    -0.958     0.200
    18.652    -0.506     0.200
    18.697    -0.972     0.200
    18.836    -1.590     0.200
    18.859    -0.021     0.200
    19.041     0.467     0.200
    19.052     0.576     0.200
    19.400    -0.402     0.200
    19.693    -1.122     0.200
    19.728     0.520     0.200
    19.811     0.418     0.200
    19.811     0.653     0.200
    19.960    -0.023     0.200
    20.178    -0.599     0.200
    20.242    -1.001     0.200
    20.242    -1.173     0.200
    20.365     0.876     0.200
    20.365     1.501     0.200
    20.476    -0.628     0.200
    20.476    -0.049     0.200
    20.503    -1.265     0.200
    20.503    -0.655     0.200
    20.652     0.943     0.200
    20.781    -0.685     0.200
    20.970    -1.373     0.200
    20.970    -0.475     0.200
    21.046     2.620     0.200
    21.060     1.507     0.200
    21.068     1.728     0.200
    21.074     1.929     0.200
    21.062     1.919     0.200
    21.188     2.884     0.200
    21.166    -0.549     0.200
    21.197    -1.016     0.200
    21.253     2.036     0.200
    21.253     2.505     0.200
    21.431     2.559     0.200
    21.412    -1.931     0.200
    21.412     0.358     0.200
    21.495    -1.993     0.200
    21.587    -1.043     0.200
    21.646     2.543     0.200
    21.605    -1.703     0.200
    21.714     2.803     0.200
    21.739     2.565     0.200
    21.838     2.530     0.200
    21.858    -2.351     0.200
    21.869    -0.715     0.200
    22.094     1.544     0.200
    22.094     2.130     0.200
    22.132    -1.599     0.200
    22.202     2.632     0.200
    22.280     2.086     0.200
    22.292    -1.225     0.200
    22.326     0.677     0.200
    22.364    -0.726     0.200
    22.455    -1.535     0.200
    22.553     0.397     0.200
    22.563    -2.822     0.200
    22.563    -2.307     0.200
    22.803     1.167     0.200
    22.814    -2.262     0.200
    22.828    -1.188     0.200
    22.866    -2.285     0.200
    23.075     1.325     0.200
    23.049    -2.000     0.200
    23.267     1.854     0.200
    23.284     2.815     0.200
    23.275     0.240     0.200
    23.286    -1.355     0.200
    23.333     2.514     0.200
    23.333     1.741     0.200
    23.318    -1.852     0.200
    23.315    -2.675     0.200
    23.396    -2.401     0.200
    23.424    -2.108     0.200
    23.542     0.933     0.200
    23.521    -2.120     0.200
    23.595     2.259     0.200
    23.578    -2.715     0.200
    23.578    -2.496     0.200
    23.586    -2.252     0.200
    23.694     2.338     0.200
    23.746     1.654     0.200
    23.807     0.342     0.200
    24.047     1.381     0.200
    24.009    -1.830     0.200
    24.068     2.052     0.200
    24.068     1.482     0.200
    24.064    -0.135     0.200
    24.081    -2.213     0.200
    24.179    -0.677     0.200
    24.216     2.268     0.200
    24.268     1.073     0.200
    24.411    -1.677     0.200
    24.469     1.461     0.200
    24.429    -1.434     0.200
    24.530     1.440     0.200
    24.531     1.622     0.200
    24.656     2.281     0.200
    24.687    -1.374     0.200
    24.687    -1.523     0.200
    24.764    -2.666     0.200
    24.859     2.414     0.200
    24.840    -0.960     0.200
    24.868    -1.346     0.200
    24.914    -1.942     0.200
    24.928    -1.516     0.200
    24.928    -1.094     0.200
    25.316    -0.557     0.200
    25.443     2.274     0.200
    25.434     1.135     0.200
    25.480     0.827     0.200
    25.498    -0.257     0.200
    25.533     0.675     0.200
    25.638     0.369     0.200
    25.691     0.957     0.200
    25.764     1.643     0.200
    25.799    -0.331     0.200
    25.816    -1.767     0.200
    25.816    -0.033     0.200
    26.138    -1.589     0.200
    26.138    -1.323     0.200
    26.370    -0.296     0.200
    26.370     1.704     0.200
    26.476     1.603     0.200
    26.656     0.990     0.200
    26.721    -1.787     0.200
    26.791     0.840     0.200
    26.887     1.457     0.200
    27.061    -0.043     0.200
    27.129    -1.589     0.200
    27.158     1.387     0.200
    27.517     1.206     0.200
    27.640     1.613     0.200
    27.640     0.325     0.200
    27.827     1.171     0.200
    27.887     2.319     0.200
    28.015     0.510     0.200
    28.015     0.314     0.200
    28.019     0.534     0.200
    28.196     1.607     0.200
    28.223     1.074     0.200
    28.234    -1.497     0.200
    28.416     0.431     0.200
    28.564     1.765     0.200
    28.772     1.832     0.200
    28.910     2.374     0.200
    29.208     2.048     0.200
    29.283    -0.333     0.200
    29.361     1.570     0.200
    29.393     0.941     0.200
    29.466     1.879     0.200
    29.483     1.338     0.200
    29.615    -1.602     0.200
    29.689     2.054     0.200
    29.827     1.340     0.200
    30.201     0.822     0.200
    30.205     0.966     0.200
    30.350    -0.709     0.200
    30.350    -0.568     0.200
    30.791     1.917     0.200
    30.756    -1.479     0.200
    30.836    -1.424     0.200
    30.881    -1.891     0.200
    30.881    -1.540     0.200
    30.997    -1.859     0.200
    30.997    -1.398     0.200
    31.057     2.311     0.200
    31.349     0.224     0.200
    31.391    -2.151     0.200
    31.391    -1.783     0.200
    31.436     0.323     0.200
    31.436     0.963     0.200
    31.658     1.237     0.200
    31.779     1.229     0.200
    32.171     0.451     0.200
    32.234    -1.268     0.200
    32.234    -1.667     0.200
    32.370     1.110     0.200
    33.022     0.956     0.200
    33.021     0.297     0.200
    33.469    -1.203     0.200
    33.469    -1.578     0.200
    33.946    -2.036     0.200
    35.640    -2.029     0.200
    35.731    -1.692     0.200
    35.918     1.049     0.200
    35.918     0.111     0.200
    36.018    -2.038     0.200
    36.050    -0.581     0.200
    36.083    -1.988     0.200
    36.484     0.515     0.200
    40.226    -0.409     0.200
    40.309    -0.909     0.200
    40.324    -0.299     0.200
    43.307     1.654     0.200
    44.097     1.523     0.200
    44.455    -0.447     0.200
    44.888     1.707     0.200
    45.913    -0.615     0.200
    46.145     1.672     0.200
    46.640     1.299     0.200
    46.640     1.464     0.200
    47.384     1.294     0.200
    47.843     1.792     0.200
    48.119     1.449     0.200
    48.382     1.968     0.200
    48.724     0.221     0.200
    48.763     1.252     0.200
    48.862     1.488     0.200
    49.144     2.307     0.200
    49.421     0.670     0.200
    49.624     1.888     0.200
    49.839     1.218     0.200
    49.841     1.933     0.200
    49.977     2.329     0.200
    50.070     1.458     0.200
    50.075     1.919     0.200
    50.261     1.494     0.200
    50.359     1.794     0.200
    50.366     1.366     0.200
    50.369     2.760     0.200
    50.379     1.209     0.200
    50.644     1.643     0.200
    50.734     1.256     0.200
    50.734     1.990     0.200
    50.796     1.136     0.200
    50.869     1.459     0.200
    50.958     0.934     0.200
    50.958     1.738     0.200
    51.065     1.409     0.200
    51.073     1.698     0.200
    51.272     1.872     0.200
    51.317     0.446     0.200
    51.317     0.961     0.200
    51.380     1.222     0.200
    51.380     1.371     0.200
    51.399     0.919     0.200
    51.411     1.596     0.200
    51.411     1.362     0.200
    51.463     2.092     0.200
    51.463     1.944     0.200
    51.487     1.739     0.200
    51.682     1.303     0.200
    51.899     1.558     0.200
    51.899     1.262     0.200
    51.909     0.657     0.200
    51.909     1.438     0.200
    52.003     1.453     0.200
    52.003     1.234     0.200
    52.145     1.573     0.200
    52.145     1.737     0.200
    52.165     1.304     0.200
    52.262     0.355     0.200
    52.262     0.925     0.200
    52.363     1.812     0.200
    52.365     0.582     0.200
    52.495     0.762     0.200
    52.552     1.050     0.200
    52.558     1.075     0.200
    52.626     1.085     0.200
    52.626     1.195     0.200
    52.644     1.698     0.200
    52.744     1.045     0.200
    52.744     1.170     0.200
    52.830     1.411     0.200
    52.850     1.453     0.200
    52.850     1.187     0.200
    52.867     0.794     0.200
    52.885     1.336     0.200
    52.922     1.493     0.200
    52.875     1.763     0.200
    52.999     0.983     0.200
    53.022     0.729     0.200
    53.022     1.042     0.200
    53.030    -0.165     0.200
    53.030     0.390     0.200
    53.064     1.483     0.200
    53.195     0.780     0.200
    53.195     1.569     0.200
    53.220     1.025     0.200
    53.220     1.548     0.200
    53.233     0.801     0.200
    53.616     0.992     0.200
    53.683     1.047     0.200
    53.806     1.186     0.200
    53.806     1.467     0.200
    53.847     1.807     0.200
    53.918     1.778     0.200
    53.988     1.129     0.200
    53.988     1.559     0.200
    54.028     0.094     0.200
    54.028     0.399     0.200
    54.112     1.128     0.200
    54.123     0.999     0.200
    54.157     0.965     0.200
    54.227     0.839     0.200
    54.227     0.323     0.200
    54.227     0.761     0.200
    54.239     1.352     0.200
    54.281     1.182     0.200
    54.339     0.749     0.200
    54.394     1.099     0.200
    54.394     0.857     0.200
    54.463     0.172     0.200
    54.467    -0.117     0.200
    54.618     0.310     0.200
    54.618     0.646     0.200
    54.622     0.019     0.200
    54.622     0.386     0.200
    54.622     0.839     0.200
    54.685     1.039     0.200
    54.724    -0.202     0.200
    54.799    -0.251     0.200
    54.821     0.915     0.200
    54.879     0.170     0.200
    54.879     0.350     0.200
    54.973     0.091     0.200
    54.973     0.802     0.200
    54.980     0.214     0.200
    55.002     0.555     0.200
    55.002     0.922     0.200
    55.075     0.596     0.200
    55.075     0.697     0.200
    55.125     0.890     0.200
    55.193     0.608     0.200
    55.205     0.951     0.200
    55.205     1.115     0.200
    55.298     0.066     0.200
    55.313     1.084     0.200
    55.300     0.702     0.200
    55.537     1.242     0.200
    55.537     0.890     0.200
    55.598     0.434     0.200
    55.717     0.450     0.200
    55.717     0.192     0.200
    55.752     0.409     0.200
    55.752     0.737     0.200
    55.860     0.929     0.200
    55.860     0.304     0.200
    56.098     0.102     0.200
    56.098     0.399     0.200
    56.241     0.718     0.200
    56.241     0.265     0.200
    56.527    -0.205     0.200
    56.527     0.365     0.200
    56.778     0.792     0.200
    56.778     1.011     0.200
    57.288    -0.258     0.200
    57.418     0.738     0.200
    57.418     0.840     0.200
    60.426     0.068     0.200
    61.429     0.535     0.200
    62.477     0.675     0.200
    63.689    -0.588     0.200
    64.249    -0.665     0.200
    65.129     0.731     0.200
    66.741     2.046     0.200
    71.325    -0.024     0.200
    82.107     1.768     0.200
    82.188     3.042     0.200
    82.299     1.860     0.200
    82.354     1.777     0.200
    82.857     1.354     0.200
    82.942     1.313     0.200
    82.953     2.160     0.200
    83.072     1.640     0.200
    83.126     0.193     0.200
    83.166     1.355     0.200
    83.181     1.573     0.200
    83.242     1.345     0.200
    83.242     1.860     0.200
    83.359     1.359     0.200
    83.390     1.402     0.200
    83.443     2.026     0.200
    83.449     1.691     0.200
    83.647     2.378     0.200
    84.021     1.765     0.200
    85.148     0.171     0.200
    85.148    -0.087     0.200
    85.400     0.410     0.200
    85.400     0.301     0.200
    85.541     0.451     0.200
    85.775     1.172     0.200
    85.775     0.320     0.200
    85.776     0.176     0.200
    89.132     0.588     0.200
    90.884    -0.444     0.200
    91.238     1.274     0.200
    91.358     0.599     0.200
    91.901     1.006     0.200
    92.092     0.662     0.200
    92.655     1.779     0.200
    93.065     0.788     0.200
    93.065     0.429     0.200
    93.923     1.290     0.200
    94.772     1.513     0.200
    96.972     0.448     0.200
    17.085     3.089     0.200
    18.042     2.670     0.200
    18.282     0.126     0.200
    18.537    -0.645     0.200
    18.755    -0.235     0.200
    18.755    -0.751     0.200
    18.774     0.272     0.200
    19.071     2.547     0.200
    19.034     0.268     0.200
    19.218     2.777     0.200
    19.373     0.268     0.200
    19.449     3.135     0.200
    19.455     0.311     0.200
    19.509    -0.639     0.200
    19.531    -0.024     0.200
    19.685     3.124     0.200
    19.704     0.881     0.200
    19.773     2.669     0.200
    19.882     1.555     0.200
    20.142     3.345     0.200
    20.151    -0.015     0.200
    20.204     2.668     0.200
    20.604    -1.056     0.200
    20.784     0.188     0.200
    20.817     2.041     0.200
    20.817     0.719     0.200
    21.196     2.517     0.200
    21.526     2.271     0.200
    21.505     2.639     0.200
    21.573    -0.517     0.200
    21.749    -0.042     0.200
    22.077    -0.793     0.200
    22.256    -1.526     0.200
    22.258    -0.812     0.200
    22.364     3.904     0.200
    22.402     0.997     0.200
    22.451     1.503     0.200
    22.586     2.844     0.200
    22.731     2.751     0.200
    22.834     4.016     0.200
    22.866     0.572     0.200
    22.995    -1.398     0.200
    23.020    -1.646     0.200
    23.020    -1.435     0.200
    23.073     1.950     0.200
    23.125     1.745     0.200
    23.258    -1.223     0.200
    23.541     0.662     0.200
    23.662     0.637     0.200
    24.232    -1.304     0.200
    24.232    -2.210     0.200
    24.309     1.943     0.200
    24.335    -1.489     0.200
    24.379     2.040     0.200
    24.648    -1.223     0.200
    24.665     0.264     0.200
    24.773     2.052     0.200
    24.836     0.137     0.200
    24.956    -0.668     0.200
    24.988     1.087     0.200
    25.245     0.109     0.200
    25.245     0.578     0.200
    25.467    -1.536     0.200
    25.528     1.830     0.200
    25.678    -1.698     0.200
    25.957    -1.103     0.200
    26.051    -1.987     0.200
    26.889    -1.663     0.200
    27.218    -0.303     0.200
    27.473    -0.426     0.200
    28.384     0.571     0.200
    28.384     0.270     0.200
    28.782     0.258     0.200
    30.374     0.616     0.200
    30.455     1.558     0.200
    30.616    -1.048     0.200
    30.744     1.642     0.200
    31.133    -1.209     0.200
    31.755     2.111     0.200
    32.522    -1.817     0.200
    32.522    -1.505     0.200
    32.750     2.112     0.200
    45.099    -1.213     0.200
    45.099    -0.783     0.200
    45.496    -1.657     0.200
    45.496    -0.130     0.200
    45.743    -1.642     0.200
    45.743    -1.165     0.200
    47.259     0.732     0.200
    47.282    -0.223     0.200
    48.265     1.897     0.200
    48.265     1.159     0.200
    48.671     1.196     0.200
    48.971     1.120     0.200
    49.179     1.275     0.200
    49.268     0.858     0.200
    49.292     2.087     0.200
    50.053     2.369     0.200
    50.302     0.860     0.200
    50.770     0.852     0.200
    50.986     0.940     0.200
    51.460     2.794     0.200
    51.431     0.435     0.200
    51.655     1.100     0.200
    51.873     1.375     0.200
    52.089    -0.022     0.200
    52.089     0.842     0.200
    52.269     0.806     0.200
    52.269     2.556     0.200
    52.188     0.451     0.200
    52.303     0.830     0.200
    52.302     0.926     0.200
    52.315     0.957     0.200
    52.409     1.495     0.200
    52.823     1.115     0.200
    53.012    -0.102     0.200
    53.072     1.325     0.200
    53.078     0.194     0.200
    53.554     0.604     0.200
    53.646     1.494     0.200
    53.795    -0.521     0.200
    53.836     1.247     0.200
    54.180     0.584     0.200
    54.191     0.500     0.200
    54.378     0.754     0.200
    54.322     0.842     0.200
    54.548    -0.233     0.200
    54.630     0.347     0.200
    54.940     0.372     0.200
    55.132     0.471     0.200
    55.318     2.452     0.200
    55.273     0.036     0.200
    55.453    -0.722     0.200
    55.453    -0.858     0.200
    55.525     0.766     0.200
    55.630     0.592     0.200
    55.630     0.771     0.200
    55.742     0.884     0.200
    55.799     0.397     0.200
    55.819     1.227     0.200
    56.041     0.463     0.200
    56.084     0.911     0.200
    56.084     1.040     0.200
    56.089     0.645     0.200
    56.097     0.821     0.200
    56.212     0.460     0.200
    56.527     1.741     0.200
    56.576     0.718     0.200
    56.629     0.254     0.200
    56.638     0.512     0.200
    56.847     1.300     0.200
    56.847     0.656     0.200
    57.347     1.097     0.200
    57.505     1.411     0.200
    57.658     0.454     0.200
    57.658    -0.097     0.200
    57.658     1.269     0.200
    57.658     0.492     0.200
    57.705    -0.035     0.200
    58.270     0.503     0.200
    58.270     0.050     0.200
    58.792     0.630     0.200
    58.905     1.431     0.200
    58.945     1.020     0.200
    59.978     0.763     0.200
    59.978     1.111     0.200
    60.132     2.216     0.200
    60.373     0.989     0.200
    60.666     1.493     0.200
    61.358     1.971     0.200
    61.383     0.750     0.200
    61.529     1.449     0.200
    61.758    -0.128     0.200
    61.758    -0.323     0.200
    62.127     0.741     0.200
    62.423     0.768     0.200
    62.423     0.413     0.200
    63.481     1.285     0.200
    63.481     0.406     0.200
    63.652     1.566     0.200
    64.396     2.310     0.200
    64.495     1.003     0.200
    64.489    -1.070     0.200
    64.610     1.725     0.200
    65.060     1.660     0.200
    65.060     0.867     0.200
    65.221    -0.674     0.200
    65.221     0.487     0.200
    65.745     2.330     0.200
    65.745     2.541     0.200
    65.745     1.349     0.200
    65.849     1.248     0.200
    66.333     1.634     0.200
    66.546     1.454     0.200
    67.417     1.789     0.200
    67.649     1.131     0.200
    67.727     1.584     0.200
    67.803     4.035     0.200
    67.994     2.211     0.200
    68.102     1.656     0.200
    68.087     1.750     0.200
    68.393     1.582     0.200
    68.393     1.313     0.200
    68.397     1.807     0.200
    68.762     0.216     0.200
    68.813     1.403     0.200
    68.903     2.270     0.200
    69.529     1.831     0.200
    69.680     2.712     0.200
    69.844     1.882     0.200
    70.305     1.612     0.200
    70.523     1.849     0.200
    70.597     2.188     0.200
    70.831     2.404     0.200
    71.012     1.190     0.200
    71.152     1.590     0.200
    71.130    -1.929     0.200
    71.613     1.176     0.200
    71.615    -1.187     0.200
    81.301     1.288     0.200
    81.301     0.444     0.200
    81.703     1.487     0.200
    81.837     1.482     0.200
    81.954     0.964     0.200
    82.188     1.240     0.200
    82.293     0.589     0.200
    82.302     1.342     0.200
    82.450     1.571     0.200
    82.516     1.027     0.200
    82.550     1.452     0.200
    83.913    -0.272     0.200
    85.140     0.592     0.200
    85.140     0.006     0.200
    85.276    -0.046     0.200
    85.285    -0.137     0.200
    85.647     4.201     0.200
    86.921     0.588     0.200
    87.771     4.747     0.200
    92.472     0.325     0.200
    92.726     0.827     0.200
    14.669     6.908     0.200
    14.670     6.322     0.200
    15.581     5.336     0.200
    16.004     4.392     0.200
    16.004     4.538     0.200
    16.462     2.499     0.200
    16.592     2.971     0.200
    16.792     3.126     0.200
    18.421    -0.934     0.200
    18.529     1.705     0.200
    18.807    -0.851     0.200
    18.807    -0.372     0.200
    18.895    -0.039     0.200
    19.455     1.472     0.200
    19.455     1.585     0.200
    19.526    -1.399     0.200
    19.535     0.226     0.200
    19.597     2.024     0.200
    19.613    -0.150     0.200
    20.188    -0.633     0.200
    20.311     2.720     0.200
    20.276    -0.850     0.200
    20.276    -0.746     0.200
    20.666     2.633     0.200
    20.649    -0.283     0.200
    20.694     0.655     0.200
    20.775    -1.095     0.200
    20.823    -0.680     0.200
    20.973     2.108     0.200
    21.187    -0.484     0.200
    21.256     2.488     0.200
    21.200    -1.023     0.200
    21.518    -0.315     0.200
    21.603     2.258     0.200
    21.564    -0.569     0.200
    21.719     0.943     0.200
    21.719     2.156     0.200
    21.816     2.453     0.200
    22.147     1.724     0.200
    22.184    -0.798     0.200
    22.281     2.641     0.200
    22.392    -1.401     0.200
    22.496    -2.326     0.200
    22.605     1.002     0.200
    22.605     2.037     0.200
    22.679    -1.840     0.200
    22.980    -0.470     0.200
    22.988    -0.075     0.200
    23.084     0.601     0.200
    23.303    -1.479     0.200
    23.351    -1.575     0.200
    23.390    -1.880     0.200
    23.523    -2.058     0.200
    23.871     2.523     0.200
    23.969    -1.244     0.200
    24.411     0.852     0.200
    24.556     1.031     0.200
    24.549    -1.270     0.200
    24.678    -1.356     0.200
    24.932     1.247     0.200
    24.932     1.103     0.200
    25.259    -0.859     0.200
    25.259    -0.323     0.200
    25.469    -1.260     0.200
    25.746     0.359     0.200
    25.827    -1.714     0.200
    25.830     0.597     0.200
    26.003    -0.442     0.200
    26.003     0.433     0.200
    26.315    -2.088     0.200
    26.667    -1.945     0.200
    26.828     2.512     0.200
    26.978    -1.378     0.200
    27.386    -1.329     0.200
    27.633    -0.867     0.200
    28.054     1.520     0.200
    29.259    -0.316     0.200
    30.088     0.330     0.200
    30.098    -0.049     0.200
    30.232     1.620     0.200
    30.553    -1.242     0.200
    31.141    -2.216     0.200
    31.141    -2.064     0.200
    44.829    -0.572     0.200
    45.916    -1.586     0.200
    46.592     1.487     0.200
    48.295     1.728     0.200
    48.581    -0.394     0.200
    48.770     1.473     0.200
    48.873     0.613     0.200
    48.873     1.329     0.200
    49.630     2.302     0.200
    50.559     1.798     0.200
    51.129     1.491     0.200
    51.446     1.503     0.200
    51.446     1.720     0.200
    51.787     0.929     0.200
    51.872     1.741     0.200
    51.894     1.128     0.200
    51.964     2.142     0.200
    52.397     1.273     0.200
    52.395     0.039     0.200
    52.622     1.627     0.200
    52.622     1.901     0.200
    52.710     0.716     0.200
    52.836     0.593     0.200
    52.864     1.921     0.200
    52.864     2.120     0.200
    53.120     0.925     0.200
    53.227     1.336     0.200
    53.372     1.371     0.200
    53.424     1.679     0.200
    53.456     0.216     0.200
    53.530     0.901     0.200
    53.731     0.823     0.200
    53.735     1.088     0.200
    53.739     0.779     0.200
    54.098     0.836     0.200
    54.184     0.798     0.200
    54.217     0.997     0.200
    54.620     1.136     0.200
    54.711     0.310     0.200
    54.801     0.906     0.200
    55.108     0.982     0.200
    55.174    -0.376     0.200
    55.253     0.287     0.200
    55.370     0.585     0.200
    55.601     0.294     0.200
    55.601     0.831     0.200
    55.634     1.096     0.200
    55.654     0.280     0.200
    55.684     1.248     0.200
    55.787     0.752     0.200
    55.796     0.905     0.200
    55.857    -0.521     0.200
    55.857     0.282     0.200
    56.056     0.940     0.200
    56.112     0.608     0.200
    56.166     0.867     0.200
    56.183     0.134     0.200
    56.235     0.665     0.200
    56.377     0.768     0.200
    56.606     0.420     0.200
    56.733     0.475     0.200
    57.030     0.172     0.200
    57.193     0.206     0.200
    57.253     1.206     0.200
    57.276     0.409     0.200
    57.881     0.721     0.200
    71.123    -1.841     0.200
    80.737     0.443     0.200
    85.294    -1.261     0.200
    85.433     0.126     0.200
    85.433     0.249     0.200
    85.555     0.892     0.200
    90.967    -0.240     0.200
    92.246    -0.137     0.200
    16.649     2.377     0.200
    18.101    -1.116     0.200
    18.242    -0.214     0.200
    18.515    -0.287     0.200
    18.605     1.374     0.200
    18.995    -0.668     0.200
    19.289     0.844     0.200
    19.288    -0.397     0.200
    19.460    -0.618     0.200
    19.479    -0.585     0.200
    19.865    -1.059     0.200
    20.446    -0.394     0.200
    20.461    -1.031     0.200
    20.957    -1.013     0.200
    21.021     1.833     0.200
    21.169    -0.864     0.200
    21.337     1.016     0.200
    21.371    -0.244     0.200
    21.387    -1.330     0.200
    21.451     2.184     0.200
    21.875    -1.176     0.200
    22.075    -1.530     0.200
    22.151    -1.370     0.200
    22.319    -1.783     0.200
    22.576    -0.884     0.200
    23.021    -2.080     0.200
    23.046    -1.861     0.200
    23.178    -1.998     0.200
    23.787    -0.902     0.200
    23.864     2.435     0.200
    24.189    -1.237     0.200
    24.189    -1.417     0.200
    24.313    -1.190     0.200
    24.801    -0.249     0.200
    24.815    -0.158     0.200
    24.901    -0.728     0.200
    24.952    -1.218     0.200
    25.132    -0.888     0.200
    32.417     2.022     0.200
    39.430    -1.377     0.200
    45.589     0.180     0.200
    46.017     0.403     0.200
    46.995     0.793     0.200
    47.920     0.005     0.200
    48.795     2.300     0.200
    48.795     1.925     0.200
    51.538     2.308     0.200
    52.608     0.950     0.200
    54.645    -0.343     0.200
    54.645     0.696     0.200
    55.484     0.901     0.200
    55.613     0.922     0.200
    56.144     0.427     0.200
    56.981     0.255     0.200
    57.215     0.360     0.200
    62.953     1.125     0.200
    63.989     2.167     0.200
    66.248     1.368     0.200
    80.776     1.659     0.200
    85.114     0.636     0.200
    85.182    -0.118     0.200
    14.745     4.308     0.200
    15.484     5.107     0.200
    15.602     4.570     0.200
    15.657     3.253     0.200
    16.083     3.810     0.200
    16.155     3.865     0.200
    16.477     3.784     0.200
    16.634     2.668     0.200
    16.630     2.902     0.200
    16.630     2.141     0.200
    16.748     2.157     0.200
    16.837     3.625     0.200
    17.778     1.021     0.200
    18.444    -0.693     0.200
    18.805     0.591     0.200
    18.836     0.066     0.200
    18.828     1.044     0.200
    19.399     1.433     0.200
    19.635    -0.259     0.200
    19.736     1.907     0.200
    19.811    -1.556     0.200
    19.983     1.903     0.200
    20.210    -0.186     0.200
    20.276    -0.141     0.200
    20.718     1.896     0.200
    20.833    -1.245     0.200
    20.833    -0.733     0.200
    20.917     0.257     0.200
    20.930     2.148     0.200
    21.025     1.303     0.200
    21.224    -1.083     0.200
    21.308     2.246     0.200
    21.533    -0.338     0.200
    21.548     2.914     0.200
    21.655     1.828     0.200
    21.771     2.561     0.200
    21.771     3.069     0.200
    21.869     3.443     0.200
    22.063     2.704     0.200
    22.193     0.998     0.200
    22.252     1.795     0.200
    22.333     3.227     0.200
    22.415    -1.406     0.200
    22.512    -1.531     0.200
    22.656     1.855     0.200
    22.662     1.495     0.200
    23.396    -1.636     0.200
    23.396    -2.027     0.200
    23.624     2.403     0.200
    23.923     3.224     0.200
    24.559    -0.790     0.200
    24.606     3.442     0.200
    24.686    -1.099     0.200
    24.978     0.178     0.200
    24.978     0.001     0.200
    25.270    -1.099     0.200
    26.684    -1.904     0.200
    26.996    -1.356     0.200
    28.101     0.316     0.200
    43.853     1.273     0.200
    44.620     1.158     0.200
    45.678     1.566     0.200
    46.903     1.424     0.200
    47.178     1.087     0.200
    48.228     0.359     0.200
    48.396     1.352     0.200
    48.918     0.316     0.200
    48.922     0.591     0.200
    48.931     1.697     0.200
    49.231     0.968     0.200
    49.412     1.011     0.200
    49.680     1.179     0.200
    49.838     2.729     0.200
    50.391     1.935     0.200
    50.609     1.621     0.200
    50.912     1.659     0.200
    51.179     1.243     0.200
    51.497     0.557     0.200
    51.629     1.746     0.200
    51.833     0.971     0.200
    51.922     1.634     0.200
    51.944     0.861     0.200
    52.015     0.923     0.200
    52.201    -0.041     0.200
    52.444     0.068     0.200
    52.447     0.513     0.200
    52.566     0.261     0.200
    52.652     1.322     0.200
    52.672     1.148     0.200
    52.712     0.498     0.200
    52.758     0.361     0.200
    52.885     1.453     0.200
    52.914     1.226     0.200
    53.060     0.581     0.200
    53.125     1.652     0.200
    53.170     1.169     0.200
    53.200     0.535     0.200
    53.277     0.806     0.200
    53.333     1.055     0.200
    53.412     1.636     0.200
    53.422     1.594     0.200
    53.473     2.025     0.200
    53.504     0.054     0.200
    53.504    -0.075     0.200
    53.521     1.404     0.200
    53.581     0.188     0.200
    53.593     0.727     0.200
    53.762     0.226     0.200
    53.782     0.886     0.200
    53.785     0.844     0.200
    53.789     0.799     0.200
    53.869     0.734     0.200
    53.933     0.483     0.200
    53.999     0.692     0.200
    54.139     0.764     0.200
    54.148     1.099     0.200
    54.268     0.867     0.200
    54.372     1.580     0.200
    54.565     1.410     0.200
    54.571     1.216     0.200
    54.761     1.081     0.200
    54.765     1.110     0.200
    54.852     0.539     0.200
    54.885     0.440     0.200
    55.152     0.303     0.200
    55.155     1.436     0.200
    55.158     1.411     0.200
    55.223     1.000     0.200
    55.236     1.092     0.200
    55.332     1.355     0.200
    55.384     0.934     0.200
    55.420     0.391     0.200
    55.558     0.567     0.200
    55.570     0.929     0.200
    55.653     0.923     0.200
    55.685     1.481     0.200
    55.733     1.326     0.200
    55.734     1.263     0.200
    55.752     0.947     0.200
    55.837     0.362     0.200
    55.846     0.067     0.200
    55.908     0.089     0.200
    56.107     0.819     0.200
    56.121     0.603     0.200
    56.123     1.082     0.200
    56.163     0.401     0.200
    56.217     0.848     0.200
    56.234     0.096     0.200
    56.258     0.811     0.200
    56.285     0.534     0.200
    56.395     0.806     0.200
    56.429     0.118     0.200
    56.440     1.056     0.200
    56.657     0.517     0.200
    56.749     0.256     0.200
    56.783     0.962     0.200
    56.793     0.873     0.200
    56.937     0.512     0.200
    56.950     1.021     0.200
    56.952     0.375     0.200
    57.081     0.374     0.200
    57.244     0.176     0.200
    57.268     0.911     0.200
    57.327     0.609     0.200
    57.440     1.294     0.200
    57.930     1.209     0.200
    58.015     0.462     0.200
    58.019     0.172     0.200
    58.329    -0.194     0.200
    58.372     1.137     0.200
    58.395     0.670     0.200
    58.448     1.599     0.200
    58.933     0.474     0.200
    80.193     1.338     0.200
    85.325    -0.047     0.200
    85.456     1.225     0.200
    85.558     1.718     0.200
    23.898     3.002     0.200
    24.921     2.617     0.200
    15.309     5.521     0.200
    16.431     4.346     0.200
    24.571     1.324     0.200
    55.280     1.605     0.200
    19.317     0.729     0.200
    19.894     0.116     0.200
    20.481    -0.974     0.200
    20.475    -0.878     0.200
    22.105    -1.577     0.200
    22.175    -1.395     0.200
    22.339    -1.607     0.200
    23.078    -1.566     0.200
    23.610    -1.456     0.200
    23.821    -0.959     0.200
    24.208    -0.813     0.200
    24.331    -0.159     0.200
    24.437    -1.459     0.200
    24.548    -1.017     0.200
    24.822    -1.455     0.200
    24.845    -1.257     0.200
    25.476    -0.803     0.200
    44.720    -1.966     0.200
    53.385    -0.107     0.200
    53.514     1.594     0.200
    54.330     0.873     0.200
    54.691     0.559     0.200
    55.070    -0.911     0.200
    55.181     1.250     0.200
    55.530     0.857     0.200
    55.622     0.664     0.200
    56.228     0.398     0.200
    57.027     0.599     0.200
    80.525     0.067     0.200
    85.052     0.286     0.200
    85.052     0.437     0.200
    85.143    -0.008     0.200
    16.697     2.065     0.200
    18.036    -0.997     0.200
    18.104    -0.461     0.200
    18.297    -0.464     0.200
    18.403     1.130     0.200
    18.998     1.405     0.200
    19.053    -0.706     0.200
    19.221    -0.483     0.200
    19.229     0.345     0.200
    19.299    -0.861     0.200
    20.067     0.148     0.200
    20.340     0.066     0.200
    20.389     0.063     0.200
    20.813    -1.199     0.200
    21.342     0.071     0.200
    22.072    -1.673     0.200
    22.325     0.980     0.200
    23.093    -1.162     0.200
    23.798    -1.479     0.200
    23.908    -1.008     0.200
    24.098     2.269     0.200
    24.198    -1.037     0.200
    24.405    -0.768     0.200
    24.661     1.257     0.200
    24.862     0.857     0.200
    24.862    -0.442     0.200
    44.698    -0.992     0.200
    45.288    -1.548     0.200
    54.795     0.057     0.200
    55.054    -1.401     0.200
    62.600     0.460     0.200
    84.737    -0.272     0.200
    84.819    -1.134     0.200
    84.828    -0.369     0.200
    16.640     3.495     0.200
    17.562     3.472     0.200
    17.924     2.161     0.200
    18.533    -0.462     0.200
    18.641    -0.611     0.200
    18.753     0.749     0.200
    19.225    -0.096     0.200
    19.224     1.860     0.200
    19.263    -0.803     0.200
    19.501     0.379     0.200
    19.840    -1.453     0.200
    19.791     2.045     0.200
    19.878    -1.617     0.200
    20.060     2.203     0.200
    20.202     0.214     0.200
    20.242     0.122     0.200
    20.205     0.612     0.200
    20.310     1.200     0.200
    20.323     1.090     0.200
    20.352    -0.461     0.200
    20.354    -0.893     0.200
    20.421    -0.723     0.200
    20.432    -0.845     0.200
    20.438    -0.502     0.200
    20.437     0.763     0.200
    20.458    -0.214     0.200
    20.479     1.567     0.200
    20.528     0.554     0.200
    20.522     1.442     0.200
    20.880    -0.905     0.200
    20.844     2.102     0.200
    20.996     2.190     0.200
    21.141     0.191     0.200
    21.342     0.745     0.200
    21.335    -0.800     0.200
    21.326    -0.232     0.200
    21.444     1.475     0.200
    21.448     2.437     0.200
    21.935     1.516     0.200
    22.003     1.336     0.200
    22.044    -0.031     0.200
    22.290    -1.182     0.200
    22.548    -0.986     0.200
    22.804     1.121     0.200
    22.857    -0.647     0.200
    22.924    -1.033     0.200
    22.991    -1.503     0.200
    23.867     1.548     0.200
    24.106    -2.007     0.200
    24.160    -2.226     0.200
    24.160    -3.181     0.200
    24.283    -1.575     0.200
    24.264     1.295     0.200
    24.388    -1.233     0.200
    24.506    -0.596     0.200
    24.495     2.543     0.200
    24.495     0.610     0.200
    24.774    -0.980     0.200
    24.793     1.177     0.200
    24.793     0.227     0.200
    24.793    -1.080     0.200
    24.969    -0.216     0.200
    25.106    -0.408     0.200
    25.430    -1.419     0.200
    25.730    -0.844     0.200
    25.778    -0.931     0.200
    25.877    -2.189     0.200
    25.931    -0.999     0.200
    30.802     0.131     0.200
    30.845    -1.710     0.200
    46.001    -0.369     0.200
    47.902    -1.014     0.200
    80.782     0.328     0.200
    14.680     4.654     0.200
    14.701     4.926     0.200
    14.790     4.614     0.200
    15.543     5.107     0.200
    15.571     3.577     0.200
    15.673     4.613     0.200
    16.062     2.601     0.200
    16.095     4.018     0.200
    16.095     4.332     0.200
    16.119     3.480     0.200
    16.641     2.135     0.200
    16.872     2.286     0.200
    16.872     4.194     0.200
    16.872     3.096     0.200
    16.922     3.456     0.200
    17.013     2.989     0.200
    18.011     1.861     0.200
    18.416    -0.869     0.200
    18.416     0.631     0.200
    19.073     0.315     0.200
    19.218     0.597     0.200
    19.309    -0.249     0.200
    19.567     0.615     0.200
    19.605    -0.181     0.200
    19.790    -0.650     0.200
    20.181    -1.259     0.200
    20.226    -1.170     0.200
    20.347     1.681     0.200
    20.588    -0.575     0.200
    20.664     1.518     0.200
    20.736     0.040     0.200
    20.777     1.486     0.200
    20.780    -1.283     0.200
    20.840    -0.156     0.200
    20.981     1.611     0.200
    21.100     2.740     0.200
    21.104     1.678     0.200
    21.199    -0.987     0.200
    21.267     0.209     0.200
    21.314    -0.164     0.200
    21.341     2.277     0.200
    21.381     2.343     0.200
    21.418     1.003     0.200
    21.489    -0.214     0.200
    21.576     0.195     0.200
    21.588    -0.189     0.200
    21.627     1.933     0.200
    21.630     1.780     0.200
    21.695     2.213     0.200
    21.678    -0.333     0.200
    21.708     2.008     0.200
    21.726     2.714     0.200
    21.720     1.981     0.200
    21.737     2.767     0.200
    21.745     2.129     0.200
    21.773     2.348     0.200
    21.837     3.304     0.200
    21.943     3.370     0.200
    22.161    -0.378     0.200
    22.323     1.884     0.200
    22.402     1.715     0.200
    22.408     1.240     0.200
    22.389    -1.992     0.200
    22.470    -1.668     0.200
    22.470    -0.854     0.200
    22.593     2.556     0.200
    22.718     1.560     0.200
    23.337    -1.287     0.200
    23.991     2.232     0.200
    24.507    -2.212     0.200
    24.852    -1.344     0.200
    24.852    -0.620     0.200
    25.017     1.531     0.200
    25.017     1.072     0.200
    25.017     1.121     0.200
    25.017    -0.246     0.200
    25.118     0.489     0.200
    25.220     0.364     0.200
    26.121    -1.329     0.200
    26.645    -1.920     0.200
    26.960    -1.627     0.200
    28.119    -1.380     0.200
    28.142     0.862     0.200
    29.243    -0.880     0.200
    30.168     0.046     0.200
    30.164    -1.579     0.200
    31.990    -0.379     0.200
    33.328    -1.519     0.200
    33.910    -2.405     0.200
    43.975     0.154     0.200
    44.672     2.009     0.200
    45.513     0.080     0.200
    45.813     0.130     0.200
    46.488     0.309     0.200
    46.687     1.073     0.200
    46.776     0.182     0.200
    46.956     0.195     0.200
    47.233     0.944     0.200
    48.393     1.801     0.200
    48.393     0.504     0.200
    48.451     0.538     0.200
    48.681     0.122     0.200
    48.861     0.499     0.200
    48.873     1.327     0.200
    48.974     0.492     0.200
    48.973     0.892     0.200
    48.988     1.493     0.200
    49.285     1.795     0.200
    49.357     1.942     0.200
    49.470     1.084     0.200
    49.735     2.125     0.200
    49.895     1.870     0.200
    50.000     1.935     0.200
    50.444     1.892     0.200
    50.665     1.060     0.200
    50.810     1.450     0.200
    50.971     1.002     0.200
    50.990     0.975     0.200
    51.152     1.446     0.200
    51.341     1.620     0.200
    51.344     0.631     0.200
    51.553     1.019     0.200
    51.845     0.980     0.200
    51.894     0.811     0.200
    51.979     1.448     0.200
    51.988     1.362     0.200
    52.000     0.997     0.200
    52.074     1.883     0.200
    52.263     0.868     0.200
    52.503     0.965     0.200
    52.514     1.141     0.200
    52.627     1.341     0.200
    52.726     1.665     0.200
    52.770     1.822     0.200
    52.805     1.510     0.200
    52.900     1.372     0.200
    52.973     0.895     0.200
    53.142     1.264     0.200
    53.188     1.041     0.200
    53.227     1.781     0.200
    53.260     1.799     0.200
    53.332     1.734     0.200
    53.473     1.301     0.200
    53.493     1.618     0.200
    53.527     1.161     0.200
    53.546     0.873     0.200
    53.518     0.950     0.200
    53.642     1.126     0.200
    53.645     1.262     0.200
    53.760     1.071     0.200
    53.843     1.148     0.200
    53.844     0.503     0.200
    53.845     0.545     0.200
    53.925     0.410     0.200
    53.922     0.471     0.200
    53.991     1.001     0.200
    54.049     0.716     0.200
    54.202     0.770     0.200
    54.329     1.712     0.200
    54.434     0.883     0.200
    54.487     0.910     0.200
    54.621     0.957     0.200
    54.637     1.018     0.200
    54.731     0.529     0.200
    54.817     0.691     0.200
    54.818     1.528     0.200
    54.916     0.714     0.200
    54.943     0.949     0.200
    55.025     0.269     0.200
    55.203     1.176     0.200
    55.290     0.805     0.200
    55.293     1.007     0.200
    55.295     0.880     0.200
    55.431     1.348     0.200
    55.439     0.724     0.200
    55.476     0.671     0.200
    55.625     0.957     0.200
    55.632     1.148     0.200
    55.717     0.758     0.200
    55.745     0.707     0.200
    55.785     1.051     0.200
    55.788     0.912     0.200
    55.802     0.960     0.200
    55.893     0.998     0.200
    55.904     0.517     0.200
    55.968     0.263     0.200
    56.170     1.356     0.200
    56.172     1.277     0.200
    56.176     1.248     0.200
    56.225     1.008     0.200
    56.282     0.714     0.200
    56.293     0.592     0.200
    56.315     1.171     0.200
    56.324     0.373     0.200
    56.340     1.064     0.200
    56.340     0.906     0.200
    56.442     0.730     0.200
    56.462     1.353     0.200
    56.491     0.752     0.200
    56.489     1.034     0.200
    56.602     0.668     0.200
    56.717    -0.135     0.200
    56.803     0.221     0.200
    56.801     0.915     0.200
    56.840     0.478     0.200
    56.861     0.986     0.200
    57.004     1.644     0.200
    57.007     1.018     0.200
    57.140     0.314     0.200
    57.267     0.560     0.200
    57.281     0.018     0.200
    57.306    -0.533     0.200
    57.319     0.631     0.200
    57.355     0.167     0.200
    57.383     0.111     0.200
    57.489     0.419     0.200
    57.506     0.513     0.200
    57.565    -0.266     0.200
    57.610     0.687     0.200
    57.627     0.529     0.200
    57.652     1.290     0.200
    57.798     0.628     0.200
    57.827     0.362     0.200
    57.935     0.426     0.200
    57.980     0.596     0.200
    58.050     0.535     0.200
    58.070     0.312     0.200
    58.149     0.786     0.200
    58.170     0.771     0.200
    58.286     0.734     0.200
    58.375     0.899     0.200
    58.378     0.591     0.200
    58.426     0.762     0.200
    58.455     0.414     0.200
    58.469     0.135     0.200
    58.498     0.826     0.200
    58.644     0.135     0.200
    58.680     0.310     0.200
    58.766     0.357     0.200
    58.982     0.209     0.200
    59.078     0.198     0.200
    59.099     0.429     0.200
    59.158     0.232     0.200
    59.170     0.222     0.200
    59.201     0.203     0.200
    59.358     0.142     0.200
    59.402     0.681     0.200
    59.624     0.837     0.200
    59.712     0.810     0.200
    59.715     0.856     0.200
    59.809     0.446     0.200
    60.439     0.289     0.200
    60.967     0.259     0.200
    61.478     0.642     0.200
    62.022     0.327     0.200
    80.821     0.221     0.200
    80.867     0.722     0.200
    85.316     0.715     0.200
    85.493     0.941     0.200
    14.667     5.664     0.200
    14.799     5.503     0.200
    14.966     5.132     0.200
    15.183     3.618     0.200
    16.818     2.062     0.200
    16.866     1.423     0.200
    17.704     0.764     0.200
    17.702     2.113     0.200
    17.842     1.420     0.200
    18.364    -1.349     0.200
    18.364     0.210     0.200
    18.403     1.142     0.200
    18.557    -1.594     0.200
    18.556    -1.256     0.200
    18.709     1.014     0.200
    18.797     0.939     0.200
    19.250     0.915     0.200
    19.260     1.717     0.200
    19.267    -0.094     0.200
    19.267     1.945     0.200
    19.317     1.282     0.200
    19.387     1.233     0.200
    19.492    -0.939     0.200
    19.553    -0.038     0.200
    19.716    -0.612     0.200
    19.736    -0.213     0.200
    19.724     0.648     0.200
    19.761     1.764     0.200
    20.016    -2.430     0.200
    19.834     1.962     0.200
    20.025     1.991     0.200
    20.129    -0.611     0.200
    20.136     2.210     0.200
    20.147     1.189     0.200
    20.397     2.502     0.200
    20.590     2.263     0.200
    20.622     2.361     0.200
    20.734    -1.007     0.200
    20.734     0.465     0.200
    20.712    -0.394     0.200
    20.680     1.130     0.200
    20.745     2.035     0.200
    20.745     1.754     0.200
    20.953     2.462     0.200
    21.050     1.167     0.200
    21.146    -0.754     0.200
    21.057     2.288     0.200
    21.213     0.130     0.200
    21.148     1.585     0.200
    21.296     2.590     0.200
    21.441    -0.910     0.200
    21.338     1.854     0.200
    21.373     2.320     0.200
    21.521     1.709     0.200
    21.521     1.408     0.200
    21.644    -1.626     0.200
    21.627     0.382     0.200
    21.660    -0.724     0.200
    21.579     1.010     0.200
    21.682     0.848     0.200
    21.791     1.359     0.200
    21.791     1.231     0.200
    21.900     2.041     0.200
    21.900     1.385     0.200
    22.092     0.066     0.200
    22.020     1.718     0.200
    22.133    -1.208     0.200
    22.336    -1.691     0.200
    22.336    -0.530     0.200
    22.280     1.182     0.200
    22.421    -1.633     0.200
    22.421    -0.461     0.200
    22.592    -2.248     0.200
    22.623    -0.654     0.200
    22.636     1.073     0.200
    22.670     0.921     0.200
    22.849    -0.951     0.200
    22.915    -0.280     0.200
    22.947     2.759     0.200
    23.213    -1.266     0.200
    23.224    -1.065     0.200
    23.249    -1.712     0.200
    23.294    -1.548     0.200
    23.294    -0.376     0.200
    23.303    -1.564     0.200
    23.449    -1.294     0.200
    23.651     2.224     0.200
    23.706     2.082     0.200
    23.901    -0.712     0.200
    23.877     2.554     0.200
    24.005    -1.061     0.200
    23.946     2.551     0.200
    23.946     3.304     0.200
    24.038    -0.063     0.200
    24.394    -0.332     0.200
    24.462    -2.063     0.200
    24.348     2.272     0.200
    24.430     0.320     0.200
    24.613     1.211     0.200
    24.731    -1.813     0.200
    24.803    -2.029     0.200
    24.803    -0.396     0.200
    24.963    -1.157     0.200
    24.963     0.905     0.200
    24.963    -1.157     0.200
    24.963     0.550     0.200
    25.174    -0.468     0.200
    25.401    -2.285     0.200
    25.415    -1.993     0.200
    25.732    -0.393     0.200
    25.789     1.031     0.200
    26.320     1.413     0.200
    26.595    -2.633     0.200
    26.876     1.225     0.200
    27.304    -1.067     0.200
    28.089     0.406     0.200
    29.193    -1.270     0.200
    29.910     1.189     0.200
    30.535    -0.566     0.200
    31.109    -0.683     0.200
    31.194    -1.412     0.200
    33.236    -1.992     0.200
    33.281    -1.002     0.200
    33.865    -1.914     0.200
    35.425    -1.242     0.200
    35.572    -1.575     0.200
    36.880    -1.107     0.200
    39.011    -0.825     0.200
    42.770     0.077     0.200
    44.622     0.612     0.200
    45.763     0.571     0.200
    45.855    -1.808     0.200
    46.440     0.645     0.200
    46.636     1.355     0.200
    46.726     0.539     0.200
    46.905     0.992     0.200
    47.916     1.642     0.200
    48.169     0.713     0.200
    48.234     0.942     0.200
    48.341     1.070     0.200
    48.401     1.509     0.200
    48.630     1.967     0.200
    48.823     0.612     0.200
    48.923     1.355     0.200
    49.686     1.796     0.200
    49.846     2.254     0.200
    49.950     1.013     0.200
    50.394     1.221     0.200
    50.760     2.204     0.200
    50.923     1.647     0.200
    51.101     1.661     0.200
    51.185     1.534     0.200
    51.292     1.684     0.200
    51.503     1.299     0.200
    51.697     0.964     0.200
    51.793     1.621     0.200
    51.846     0.594     0.200
    51.929     1.339     0.200
    51.950     1.512     0.200
    52.025     1.389     0.200
    52.216     1.027     0.200
    52.442     0.684     0.200
    52.453     1.042     0.200
    52.466     0.354     0.200
    52.579     1.025     0.200
    52.633     1.039     0.200
    52.676     1.679     0.200
    52.721     0.767     0.200
    52.754     0.588     0.200
    52.925     1.474     0.200
    52.981     0.618     0.200
    53.088     0.801     0.200
    53.178     0.554     0.200
    53.282     0.799     0.200
    53.345     1.229     0.200
    53.448     0.895     0.200
    53.477     1.552     0.200
    53.505     0.676     0.200
    53.795     1.179     0.200
    53.796     1.147     0.200
    53.871     1.273     0.200
    53.941     0.881     0.200
    53.998     0.998     0.200
    54.152     0.990     0.200
    54.245     1.318     0.200
    54.263     1.396     0.200
    54.281     1.311     0.200
    54.386     1.088     0.200
    54.435     0.645     0.200
    54.571     0.630     0.200
    54.683     0.945     0.200
    54.767     0.986     0.200
    54.768     1.547     0.200
    54.894     0.849     0.200
    55.152     0.963     0.200
    55.160     0.729     0.200
    55.246     1.207     0.200
    55.379     0.843     0.200
    55.394     0.239     0.200
    55.427     0.527     0.200
    55.585     1.103     0.200
    55.671     0.580     0.200
    55.697     0.596     0.200
    55.734     1.283     0.200
    55.738     0.942     0.200
    55.751     0.717     0.200
    55.843     0.595     0.200
    55.855     0.481     0.200
    55.919     0.591     0.200
    56.121     1.045     0.200
    56.125     0.930     0.200
    56.123     1.181     0.200
    56.177     0.573     0.200
    56.236     0.667     0.200
    56.244     1.487     0.200
    56.265     0.705     0.200
    56.290     0.733     0.200
    56.444     0.900     0.200
    56.669     0.563     0.200
    56.750     0.911     0.200
    56.791     1.029     0.200
    56.954     0.676     0.200
    56.957     0.842     0.200
    57.091     0.552     0.200
    57.220     0.878     0.200
    57.234     0.770     0.200
    57.258     0.427     0.200
    57.268     1.126     0.200
    57.305     1.365     0.200
    57.333     0.756     0.200
    57.437     0.776     0.200
    57.516     0.770     0.200
    57.560     0.775     0.200
    57.579     0.805     0.200
    57.601     1.115     0.200
    57.779     0.543     0.200
    57.888     0.411     0.200
    57.929     0.763     0.200
    58.001     0.642     0.200
    58.017     0.646     0.200
    58.020    -0.218     0.200
    58.098     0.871     0.200
    58.122     0.876     0.200
    58.326     0.749     0.200
    58.324     0.525     0.200
    58.376     0.636     0.200
    58.447     0.634     0.200
    58.595    -0.009     0.200
    58.931     0.619     0.200
    59.032     0.714     0.200
    59.050     0.388     0.200
    59.109     0.272     0.200
    59.124     0.262     0.200
    59.311     1.060     0.200
    59.355     1.051     0.200
    59.577     1.393     0.200
    59.665     0.826     0.200
    59.664     0.571     0.200
    59.652     0.798     0.200
    59.760     0.848     0.200
    59.790     0.936     0.200
    60.172     0.695     0.200
    60.917     0.711     0.200
    60.938     0.678     0.200
    80.826     1.465     0.200
    85.261    -0.674     0.200
    85.376     0.551     0.200
    85.453     0.870     0.200
    23.951     1.533     0.200
    54.627    -0.264     0.200
    16.080     2.951     0.200
    16.794     2.342     0.200
    17.617     1.446     0.200
    17.813     1.524     0.200
    18.551     0.296     0.200
    18.757    -0.142     0.200
    18.775     0.128     0.200
    18.864     0.250     0.200
    18.874     1.214     0.200
    19.160    -0.593     0.200
    19.659    -0.333     0.200
    19.787     0.933     0.200
    19.806    -0.033     0.200
    20.253     0.934     0.200
    20.539     1.504     0.200
    20.604     0.191     0.200
    20.736    -0.725     0.200
    20.960     0.699     0.200
    21.008     0.982     0.200
    21.042    -1.339     0.200
    21.170     0.354     0.200
    21.370    -0.751     0.200
    21.454     0.023     0.200
    23.088    -1.145     0.200
    23.481     1.454     0.200
    23.812    -2.347     0.200
    24.243     1.470     0.200
    27.523     0.617     0.200
    14.744     5.781     0.200
    14.859     5.355     0.200
    15.285     3.655     0.200
    15.475     3.124     0.200
    16.883     5.500     0.200
    18.412    -0.351     0.200
    18.819     0.100     0.200
    19.452     0.462     0.200
    19.547     0.364     0.200
    19.537     0.948     0.200
    19.600     0.575     0.200
    19.787    -1.050     0.200
    20.176    -0.559     0.200
    20.216    -0.752     0.200
    20.510     1.153     0.200
    20.712    -0.198     0.200
    20.769    -0.315     0.200
    20.758    -0.979     0.200
    21.195    -0.668     0.200
    21.264     1.165     0.200
    21.903    -0.361     0.200
    22.183     0.430     0.200
    22.385    -1.163     0.200
    22.627    -1.010     0.200
    23.249    -1.017     0.200
    23.263    -0.673     0.200
    23.490    -1.355     0.200
    24.010     2.726     0.200
    24.441    -0.185     0.200
    24.413     2.267     0.200
    24.619    -0.540     0.200
    24.769    -1.395     0.200
    25.029     0.788     0.200
    44.917    -0.300     0.200
    45.901    -2.153     0.200
    51.167     1.244     0.200
    54.577     0.542     0.200
    54.832     0.694     0.200
    54.832     0.835     0.200
    54.832     0.574     0.200
    55.264    -0.219     0.200
    55.312     1.341     0.200
    55.803     1.177     0.200
    56.191     1.365     0.200
    57.019     1.054     0.200
    57.157    -0.289     0.200
    57.503     0.248     0.200
    58.442     1.184     0.200
    59.066     1.141     0.200
    59.825     0.882     0.200
    60.597     0.539     0.200
    60.983     0.529     0.200
    61.348     1.852     0.200
    61.685     0.230     0.200
    62.889     0.604     0.200
    80.813    -0.040     0.200
    85.479     0.876     0.200
    15.256     4.772     0.200
    24.616     1.843     0.200
    25.484     2.475     0.200
    45.335    -2.224     0.200
    54.035    -0.959     0.200
    55.374     0.391     0.200
    15.442     2.462     0.200
    16.051     3.347     0.200
    16.020     4.311     0.200
    16.784     3.157     0.200
    16.784     2.923     0.200
    17.179     3.952     0.200
    17.656     2.412     0.200
    17.859     0.595     0.200
    17.771     2.558     0.200
    17.906     3.300     0.200
    18.183     2.301     0.200
    18.378    -1.037     0.200
    18.378    -1.158     0.200
    18.378    -0.287     0.200
    18.289     2.287     0.200
    18.313     2.074     0.200
    18.339     1.653     0.200
    18.535     1.936     0.200
    18.585     1.424     0.200
    18.631     2.215     0.200
    18.644     2.517     0.200
    18.770     0.073     0.200
    18.703     0.481     0.200
    18.945     1.509     0.200
    19.138     2.264     0.200
    19.189     0.831     0.200
    19.186     2.743     0.200
    19.196     1.912     0.200
    19.203     1.597     0.200
    19.203     1.914     0.200
    19.203     1.496     0.200
    19.203     2.957     0.200
    19.255     1.306     0.200
    19.348     1.742     0.200
    19.348     1.887     0.200
    19.564    -0.276     0.200
    19.564    -0.526     0.200
    19.569     0.298     0.200
    19.588     0.639     0.200
    19.603     1.958     0.200
    19.745    -1.639     0.200
    19.674     2.389     0.200
    19.701     2.040     0.200
    19.945     2.972     0.200
    19.957     2.355     0.200
    20.144    -0.172     0.200
    20.212    -0.298     0.200
    20.075     1.804     0.200
    20.169     1.019     0.200
    20.382    -1.659     0.200
    20.316     1.409     0.200
    20.333     1.653     0.200
    20.352     2.005     0.200
    20.453     2.412     0.200
    20.629     0.546     0.200
    20.628     1.325     0.200
    20.668     0.064     0.200
    20.729    -0.662     0.200
    20.769    -0.932     0.200
    20.769    -0.463     0.200
    20.684     2.912     0.200
    20.726     3.112     0.200
    20.742     2.559     0.200
    20.894     2.065     0.200
    20.994     1.886     0.200
    21.224    -0.927     0.200
    21.208     1.617     0.200
    21.276     1.548     0.200
    21.313     1.811     0.200
    21.492     0.450     0.200
    21.492     1.915     0.200
    21.621     1.170     0.200
    21.639     1.900     0.200
    21.666     1.675     0.200
    21.733     2.712     0.200
    21.837     1.567     0.200
    22.166    -1.685     0.200
    22.035     1.412     0.200
    22.140     1.616     0.200
    22.380    -0.433     0.200
    22.380     0.458     0.200
    22.218     0.894     0.200
    22.349    -0.891     0.200
    22.349    -1.453     0.200
    22.349    -1.150     0.200
    22.297     1.956     0.200
    22.446    -1.978     0.200
    22.446    -0.982     0.200
    22.302     1.575     0.200
    22.439     1.652     0.200
    22.625    -1.154     0.200
    22.580    -0.866     0.200
    22.606     0.504     0.200
    22.723    -0.859     0.200
    22.616     1.773     0.200
    22.880    -1.422     0.200
    22.769     2.260     0.200
    22.818     2.037     0.200
    23.116    -1.360     0.200
    23.198    -1.493     0.200
    23.098     1.750     0.200
    23.245    -1.423     0.200
    23.333    -1.870     0.200
    23.333    -2.723     0.200
    23.333    -1.120     0.200
    23.268     2.393     0.200
    23.268     0.426     0.200
    23.473    -1.369     0.200
    23.447    -1.241     0.200
    23.520     1.892     0.200
    23.895    -1.696     0.200
    23.887     1.734     0.200
    23.887     1.864     0.200
    24.311    -0.473     0.200
    24.241     0.747     0.200
    24.292     0.960     0.200
    24.400     0.630     0.200
    24.400     0.064     0.200
    24.495    -0.881     0.200
    24.625     1.029     0.200
    24.826    -0.765     0.200
    24.826    -1.691     0.200
    24.826    -0.994     0.200
    24.926    -0.319     0.200
    24.926     0.508     0.200
    24.926     0.039     0.200
    24.926     0.488     0.200
    25.066     0.387     0.200
    25.066    -1.220     0.200
    25.052     1.334     0.200
    25.206    -1.206     0.200
    25.206    -1.056     0.200
    25.206    -0.935     0.200
    25.268    -1.263     0.200
    25.268    -1.827     0.200
    25.500    -0.962     0.200
    25.771    -1.604     0.200
    25.730     0.958     0.200
    25.730     0.548     0.200
    25.974    -0.464     0.200
    25.974     0.196     0.200
    26.087    -2.078     0.200
    26.311    -1.970     0.200
    26.337     1.835     0.200
    26.619    -2.464     0.200
    26.688     0.509     0.200
    26.931    -1.451     0.200
    26.931    -0.986     0.200
    26.830     1.494     0.200
    26.830     1.644     0.200
    26.932     0.523     0.200
    26.999    -1.823     0.200
    27.095    -1.671     0.200
    27.142    -1.409     0.200
    27.194    -0.681     0.200
    27.171    -0.435     0.200
    27.310     1.747     0.200
    27.475    -1.691     0.200
    27.581     1.493     0.200
    27.579    -1.722     0.200
    27.579    -0.931     0.200
    27.919    -1.673     0.200
    28.045    -2.769     0.200
    28.099    -2.813     0.200
    28.035     1.941     0.200
    28.050     0.978     0.200
    28.245    -2.298     0.200
    28.594    -1.908     0.200
    29.035    -3.407     0.200
    29.212    -1.100     0.200
    29.100     1.177     0.200
    29.246     0.890     0.200
    29.443    -2.103     0.200
    29.731     0.245     0.200
    29.736     0.844     0.200
    29.859     0.751     0.200
    29.994     1.124     0.200
    30.141    -2.034     0.200
    30.082     0.289     0.200
    30.082    -0.109     0.200
    30.080    -0.205     0.200
    30.080    -0.703     0.200
    30.406     1.637     0.200
    30.469     1.356     0.200
    30.525    -1.020     0.200
    30.525    -2.088     0.200
    30.979    -2.041     0.200
    31.107    -2.111     0.200
    31.107    -1.938     0.200
    31.225    -1.612     0.200
    31.225    -1.325     0.200
    31.225    -1.134     0.200
    31.793    -1.774     0.200
    31.893     0.738     0.200
    31.893    -0.768     0.200
    32.057    -2.054     0.200
    32.421    -1.484     0.200
    32.421    -1.282     0.200
    32.421    -1.632     0.200
    32.538    -2.036     0.200
    32.699     1.954     0.200
    33.141     1.943     0.200
    33.258    -2.209     0.200
    33.311    -1.609     0.200
    33.311    -1.144     0.200
    33.899    -1.949     0.200
    34.942    -2.535     0.200
    35.300    -0.520     0.200
    35.409    -1.521     0.200
    35.458    -2.018     0.200
    35.454    -1.771     0.200
    35.537     0.175     0.200
    35.537     1.265     0.200
    35.599    -2.129     0.200
    35.599    -3.240     0.200
    36.032    -0.939     0.200
    36.188    -2.542     0.200
    36.188    -1.281     0.200
    36.188    -1.759     0.200
    36.208     0.368     0.200
    36.355    -0.539     0.200
    36.355    -0.690     0.200
    36.355    -0.850     0.200
    36.623    -1.015     0.200
    36.678    -1.773     0.200
    36.911    -1.197     0.200
    37.061    -1.574     0.200
    37.308    -0.038     0.200
    38.282    -1.569     0.200
    38.988    -1.562     0.200
    39.042    -1.249     0.200
    39.647    -1.342     0.200
    39.727    -1.137     0.200
    39.873    -1.349     0.200
    40.174    -1.328     0.200
    40.959    -1.100     0.200
    42.004    -1.325     0.200
    42.718     0.993     0.200
    43.402     2.292     0.200
    43.402     1.843     0.200
    43.402     1.286     0.200
    43.496     1.506     0.200
    43.496     1.398     0.200
    43.510     0.251     0.200
    43.810     0.463     0.200
    43.874     0.521     0.200
    43.874     1.351     0.200
    44.222     0.366     0.200
    44.326     0.808     0.200
    44.329     1.858     0.200
    44.523     2.145     0.200
    44.574     1.986     0.200
    44.574     2.088     0.200
    44.819    -0.844     0.200
    45.400     0.662     0.200
    45.412     1.040     0.200
    45.412     1.878     0.200
    45.561     1.073     0.200
    45.561     1.221     0.200
    45.632     1.716     0.200
    45.632     1.851     0.200
    45.714     1.569     0.200
    45.714     2.255     0.200
    45.871    -1.689     0.200
    45.931     2.020     0.200
    45.978     1.787     0.200
    46.387     1.805     0.200
    46.592     1.759     0.200
    46.677     1.496     0.200
    46.677     1.631     0.200
    46.857     1.282     0.200
    46.952     0.105     0.200
    47.134     1.484     0.200
    47.134     1.286     0.200
    47.498     1.677     0.200
    47.666     1.374     0.200
    48.118     0.762     0.200
    48.118     1.692     0.200
    48.184     1.851     0.200
    48.352     1.709     0.200
    48.584     0.660     0.200
    48.584     1.330     0.200
    48.865     1.294     0.200
    48.865     0.610     0.200
    48.865     1.735     0.200
    48.760     1.793     0.200
    48.760     1.453     0.200
    48.775     1.352     0.200
    48.775     1.192     0.200
    48.876     1.053     0.200
    48.876     1.352     0.200
    48.888     1.545     0.200
    49.041     1.312     0.200
    49.186     1.754     0.200
    49.186     1.293     0.200
    49.257     2.107     0.200
    49.370     1.634     0.200
    49.636     2.613     0.200
    49.795     2.510     0.200
    49.902     0.669     0.200
    49.902     1.444     0.200
    49.987     2.513     0.200
    50.068     2.239     0.200
    50.128     2.020     0.200
    50.345     1.145     0.200
    50.345     2.029     0.200
    50.343     2.345     0.200
    50.345     1.709     0.200
    50.383     1.313     0.200
    50.383     1.686     0.200
    50.565     1.904     0.200
    50.712     1.912     0.200
    50.870     2.111     0.200
    50.888     1.978     0.200
    51.055     1.596     0.200
    51.055     1.379     0.200
    51.071     0.219     0.200
    51.247     0.872     0.200
    51.247     1.048     0.200
    51.241     1.430     0.200
    51.241     1.887     0.200
    51.267     1.465     0.200
    51.453     1.545     0.200
    51.587     1.507     0.200
    51.709     0.660     0.200
    51.748     1.038     0.200
    51.791     0.754     0.200
    51.792     2.032     0.200
    51.879     1.443     0.200
    51.900     1.553     0.200
    51.973     2.240     0.200
    52.161     1.439     0.200
    52.203     1.526     0.200
    52.396     0.438     0.200
    52.403     1.178     0.200
    52.403     1.588     0.200
    52.413     1.447     0.200
    52.413     1.986     0.200
    52.518     0.837     0.200
    52.525     1.306     0.200
    52.627     1.695     0.200
    52.669     1.865     0.200
    52.710     0.967     0.200
    52.806     0.121     0.200
    52.839     0.785     0.200
    52.839     0.929     0.200
    52.872     2.116     0.200
    52.935     0.516     0.200
    53.043     0.381     0.200
    53.047     0.147     0.200
    53.086     0.943     0.200
    53.127     1.205     0.200
    53.159     1.055     0.200
    53.232     0.561     0.200
    53.232     1.609     0.200
    53.292     0.756     0.200
    53.371     0.831     0.200
    53.371     1.083     0.200
    53.389     0.712     0.200
    53.389     1.208     0.200
    53.389     0.513     0.200
    53.389     2.022     0.200
    53.399     0.813     0.200
    53.426     0.313     0.200
    53.428     1.920     0.200
    53.453     0.313     0.200
    53.462     0.953     0.200
    53.414     1.693     0.200
    53.486     1.599     0.200
    53.486     1.228     0.200
    53.547     0.825     0.200
    53.540     0.455     0.200
    53.673     0.870     0.200
    53.721     0.691     0.200
    53.745     1.173     0.200
    53.743     1.420     0.200
    53.741     1.227     0.200
    53.741     1.108     0.200
    53.824     1.210     0.200
    53.822     1.765     0.200
    53.890     1.047     0.200
    53.952     0.958     0.200
    54.103     1.070     0.200
    54.103     1.230     0.200
    54.106     1.372     0.200
    54.152     2.074     0.200
    54.193     1.009     0.200
    54.203     0.931     0.200
    54.227     0.579     0.200
    54.227     1.129     0.200
    54.332     1.264     0.200
    54.390     0.818     0.200
    54.399     0.506     0.200
    54.468     1.051     0.200
    54.459     0.911     0.200
    54.521     0.449     0.200
    54.537     0.578     0.200
    54.533     1.025     0.200
    54.630     1.006     0.200
    54.717     0.852     0.200
    54.720     1.444     0.200
    54.813     0.668     0.200
    54.843     1.114     0.200
    54.917     1.133     0.200
    54.921     0.740     0.200
    55.103     0.056     0.200
    55.103     0.451     0.200
    55.106     1.029     0.200
    55.110     0.669     0.200
    55.110     0.509     0.200
    55.110     0.058     0.200
    55.110    -0.530     0.200
    55.110     0.368     0.200
    55.111     0.726     0.200
    55.111     0.418     0.200
    55.166    -0.703     0.200
    55.171     1.183     0.200
    55.186     0.974     0.200
    55.286     1.457     0.200
    55.267     0.202     0.200
    55.335     1.099     0.200
    55.335     0.230     0.200
    55.376     0.771     0.200
    55.521     0.608     0.200
    55.530     1.027     0.200
    55.614     0.816     0.200
    55.643     0.992     0.200
    55.687     1.517     0.200
    55.689     1.078     0.200
    55.705     1.238     0.200
    55.721     0.644     0.200
    55.793     1.031     0.200
    55.804     0.257     0.200
    55.822     0.626     0.200
    55.866     0.181     0.200
    55.924     0.540     0.200
    55.903     0.481     0.200
    56.075     1.441     0.200
    56.077     1.321     0.200
    56.068     1.119     0.200
    56.122     0.451     0.200
    56.179     0.746     0.200
    56.179     0.871     0.200
    56.192    -0.039     0.200
    56.215     0.739     0.200
    56.241     0.929     0.200
    56.358     0.817     0.200
    56.392     1.000     0.200
    56.389     0.824     0.200
    56.496     0.308     0.200
    56.497     0.522     0.200
    56.616     0.466     0.200
    56.703     0.707     0.200
    56.700     0.566     0.200
    56.740     0.621     0.200
    56.757     0.399     0.200
    56.888     0.029     0.200
    56.905     0.343     0.200
    56.907     0.273     0.200
    57.039     0.102     0.200
    57.039     0.256     0.200
    57.163     0.070     0.200
    57.179     0.302     0.200
    57.204     0.413     0.200
    57.204     0.294     0.200
    57.221     0.880     0.200
    57.257     1.309     0.200
    57.283     0.405     0.200
    57.394     0.312     0.200
    57.393     0.808     0.200
    57.402     0.557     0.200
    57.433    -0.289     0.200
    57.464     0.108     0.200
    57.511     0.723     0.200
    57.525     0.195     0.200
    57.554     1.520     0.200
    57.694     0.908     0.200
    57.725     0.113     0.200
    57.832     0.386     0.200
    57.883     0.880     0.200
    57.905     0.066     0.200
    57.949     0.190     0.200
    57.971     0.141     0.200
    57.970     0.343     0.200
    58.050     1.191     0.200
    58.039     0.935     0.200
    58.067     0.041     0.200
    58.157    -0.439     0.200
    58.157    -0.599     0.200
    58.183     0.009     0.200
    58.183     0.404     0.200
    58.282     0.316     0.200
    58.276     0.474     0.200
    58.327     0.990     0.200
    58.366    -0.750     0.200
    58.401     1.233     0.200
    58.544    -0.165     0.200
    58.576    -1.024     0.200
    58.663    -0.748     0.200
    58.886     0.208     0.200
    58.954     1.134     0.200
    58.974     0.030     0.200
    59.000     0.309     0.200
    59.127    -0.085     0.200
    59.058     0.234     0.200
    59.067     0.621     0.200
    59.100     0.416     0.200
    59.100     0.595     0.200
    59.120     0.751     0.200
    59.256     0.433     0.200
    59.299     0.860     0.200
    59.497     0.446     0.200
    59.525     0.341     0.200
    59.519     1.198     0.200
    59.520     0.130     0.200
    59.615     0.460     0.200
    59.611     0.837     0.200
    59.586     0.986     0.200
    59.586     0.456     0.200
    59.710     0.780     0.200
    59.740     0.950     0.200
    59.743     1.224     0.200
    59.932     0.505     0.200
    59.966    -0.016     0.200
    60.097     0.767     0.200
    60.120     0.740     0.200
    60.188     0.505     0.200
    60.336     0.805     0.200
    60.336     0.928     0.200
    60.456    -0.227     0.200
    60.422     1.171     0.200
    60.603    -0.059     0.200
    60.603     0.230     0.200
    60.482     0.453     0.200
    60.482     0.558     0.200
    60.712     0.603     0.200
    60.739     0.934     0.200
    60.759    -0.046     0.200
    60.867     0.738     0.200
    60.892     0.778     0.200
    60.872     0.696     0.200
    61.170     0.674     0.200
    61.235     0.708     0.200
    61.268     1.039     0.200
    61.381    -0.016     0.200
    61.510     0.138     0.200
    61.570     0.679     0.200
    61.570     0.124     0.200
    61.673     0.849     0.200
    61.744     0.811     0.200
    61.853     0.668     0.200
    61.923     0.682     0.200
    62.061     0.588     0.200
    62.174     0.109     0.200
    62.335     0.908     0.200
    62.854     0.524     0.200
    62.854     0.119     0.200
    63.019     0.119     0.200
    62.997     0.703     0.200
    63.740    -0.086     0.200
    63.740    -0.676     0.200
    64.134     0.922     0.200
    64.416     0.147     0.200
    65.222    -0.775     0.200
    65.222     0.395     0.200
    65.222     0.125     0.200
    65.515     0.683     0.200
    65.515     0.323     0.200
    65.515     0.102     0.200
    65.515    -0.376     0.200
    66.185    -1.427     0.200
    66.875     0.988     0.200
    66.908     0.510     0.200
    71.091    -1.201     0.200
    71.091    -0.751     0.200
    71.517     0.294     0.200
    73.228     1.171     0.200
    77.969     0.852     0.200
    77.969    -0.086     0.200
    78.489     0.131     0.200
    78.447     1.197     0.200
    79.634     0.412     0.200
    80.153     1.549     0.200
    80.238     0.696     0.200
    80.238     1.548     0.200
    80.778     0.458     0.200
    80.778     0.278     0.200
    80.797     0.744     0.200
    80.888     1.147     0.200
    81.612     0.794     0.200
    81.920     1.738     0.200
    82.068     1.765     0.200
    82.067     1.437     0.200
    82.187     0.736     0.200
    82.233     2.010     0.200
    82.273     1.492     0.200
    82.311     1.289     0.200
    82.561     1.084     0.200
    82.620     1.278     0.200
    82.641     1.271     0.200
    82.661     0.554     0.200
    82.661     0.964     0.200
    82.661     1.304     0.200
    82.700     1.482     0.200
    82.768     2.110     0.200
    82.768     0.591     0.200
    82.770     1.178     0.200
    82.809     1.396     0.200
    82.881     1.621     0.200
    82.880     1.425     0.200
    82.934     0.325     0.200
    82.934     1.645     0.200
    82.934     0.747     0.200
    83.069     1.446     0.200
    83.094     0.548     0.200
    83.094     1.118     0.200
    83.094     1.708     0.200
    83.134     2.213     0.200
    83.144     1.758     0.200
    83.129     1.996     0.200
    83.334     2.278     0.200
    83.447     1.899     0.200
    83.408     1.037     0.200
    83.561    -0.573     0.200
    83.561    -0.393     0.200
    83.561     0.267     0.200
    83.719     1.600     0.200
    83.801     1.271     0.200
    85.082    -0.066     0.200
    85.210     0.455     0.200
    85.261     0.998     0.200
    85.261     1.658     0.200
    85.260     0.313     0.200
    85.260     0.501     0.200
    85.349     0.449     0.200
    85.362     0.024     0.200
    85.372     1.261     0.200
    85.372     0.242     0.200
    85.372     1.054     0.200
    85.390     0.555     0.200
    85.390     0.504     0.200
    85.419     0.022     0.200
    85.497     1.010     0.200
    85.497     1.221     0.200
    85.557     1.655     0.200
    85.495     1.239     0.200
    85.632     2.120     0.200
    85.713     2.364     0.200
    85.798     2.117     0.200
    85.839     2.708     0.200
    86.590     0.610     0.200
    86.590     1.321     0.200
    86.699     2.724     0.200
    86.908    -1.190     0.200
    86.961    -0.406     0.200
    87.132     0.072     0.200
    87.294    -0.371     0.200
    87.474     0.858     0.200
    87.724     0.881     0.200
    87.887     0.823     0.200
    88.386    -0.783     0.200
    88.506     1.299     0.200
    88.590     1.562     0.200
    88.672    -0.199     0.200
    88.757     0.219     0.200
    88.752    -1.154     0.200
    88.947     0.224     0.200
    89.107     1.293     0.200
    89.095     0.001     0.200
    89.193     0.687     0.200
    89.289    -0.390     0.200
    89.571     1.360     0.200
    89.629    -0.402     0.200
    89.631     0.527     0.200
    90.156     0.875     0.200
    90.848     1.265     0.200
    90.928    -1.749     0.200
    90.928    -0.167     0.200
    90.928    -0.518     0.200
    91.256     0.162     0.200
    91.429     0.547     0.200
    91.989     0.995     0.200
    91.981    -0.699     0.200
    92.038     0.340     0.200
    92.233     0.240     0.200
    92.233    -0.260     0.200
    92.624    -1.971     0.200
    92.720    -0.113     0.200
    92.720     0.290     0.200
    92.813    -1.342     0.200
    92.941     0.044     0.200
    92.941     1.021     0.200
    93.543     0.195     0.200
    93.543     0.804     0.200
    93.792    -0.441     0.200
    94.277     0.921     0.200
    94.277     0.812     0.200
    94.308     0.776     0.200
    94.208     0.938     0.200
    94.517     1.023     0.200
    94.517     1.320     0.200
    95.180     1.685     0.200
    95.180     2.166     0.200
    95.182     1.374     0.200
    95.186     1.859     0.200
    95.902     2.195     0.200
    95.955     0.951     0.200
    96.071     1.925     0.200
    96.118     1.111     0.200
    96.867     2.102     0.200
    96.892     0.599     0.200
    97.095     1.580     0.200
    97.652    -0.232     0.200
    97.686    -0.687     0.200
    97.772    -0.075     0.200
    98.137     1.307     0.200
    99.333    -0.765     0.200
    99.533    -1.056     0.200
    99.542    -1.096     0.200
    99.557    -1.063     0.200
    99.557    -1.062     0.200
    99.580    -1.067     0.200
    99.583    -1.078     0.200
    15.489     6.162     0.200
    19.231    -0.357     0.200
    30.782     0.161     0.200
    31.087    -0.654     0.200
    31.842    -0.458     0.200
    34.792    -1.755     0.200
    16.810     5.104     0.200
    18.448    -0.152     0.200
    18.833    -0.578     0.200
    18.937     1.393     0.200
    19.173     1.955     0.200
    19.369     1.445     0.200
    19.475     2.328     0.200
    19.552    -0.467     0.200
    19.640    -0.015     0.200
    19.789    -0.248     0.200
    20.087     0.673     0.200
    20.396     0.744     0.200
    20.718     0.201     0.200
    21.227    -0.628     0.200
    21.309    -1.292     0.200
    21.258     1.715     0.200
    22.419    -1.258     0.200
    22.523    -1.218     0.200
    23.881     0.440     0.200
    23.881     3.185     0.200
    24.123    -1.522     0.200
    24.949     1.969     0.200
    43.504     1.296     0.200
    43.525     1.415     0.200
    43.878     1.709     0.200
    44.531     1.573     0.200
    44.584     1.461     0.200
    44.848     0.213     0.200
    45.404     0.700     0.200
    45.574     1.741     0.200
    45.643     1.394     0.200
    45.723     1.840     0.200
    46.607     0.989     0.200
    46.685     0.413     0.200
    46.867     1.883     0.200
    46.973     1.284     0.200
    48.123     1.336     0.200
    48.191     1.109     0.200
    48.311     1.223     0.200
    48.360     1.102     0.200
    48.882     1.408     0.200
    48.887     1.414     0.200
    49.195     1.050     0.200
    49.264     1.610     0.200
    49.643     1.575     0.200
    49.800     1.457     0.200
    49.912     1.007     0.200
    49.993     1.677     0.200
    50.071     1.887     0.200
    50.350     0.853     0.200
    50.354     0.978     0.200
    50.572     0.959     0.200
    50.722     0.841     0.200
    50.874     0.927     0.200
    51.066     2.000     0.200
    51.066     1.047     0.200
    51.142     1.265     0.200
    51.245     0.572     0.200
    51.260     0.920     0.200
    51.459     0.789     0.200
    51.590     0.771     0.200
    51.670     1.116     0.200
    51.762     1.001     0.200
    51.794     1.207     0.200
    51.802     1.117     0.200
    51.885     0.989     0.200
    51.908     1.446     0.200
    51.977     0.748     0.200
    52.409     1.530     0.200
    52.410     0.844     0.200
    52.416     0.382     0.200
    52.526     0.364     0.200
    52.536     0.942     0.200
    52.636     1.515     0.200
    52.674     1.014     0.200
    52.725     1.465     0.200
    52.824     1.260     0.200
    52.876     0.578     0.200
    52.947     0.927     0.200
    53.021     0.545     0.200
    53.057     0.804     0.200
    53.084     0.780     0.200
    53.133     0.907     0.200
    53.240     0.573     0.200
    53.373     0.888     0.200
    53.385     0.904     0.200
    53.437     0.440     0.200
    53.443     0.541     0.200
    53.472     0.649     0.200
    53.477     0.773     0.200
    53.558     0.775     0.200
    53.722     0.854     0.200
    53.743     0.512     0.200
    53.747     0.523     0.200
    53.752     0.189     0.200
    53.834     0.869     0.200
    53.895     0.406     0.200
    53.965    -0.050     0.200
    54.195    -0.263     0.200
    54.197     0.380     0.200
    54.332     1.391     0.200
    54.403     0.716     0.200
    54.456     1.126     0.200
    54.483     0.821     0.200
    54.528     0.822     0.200
    54.530     1.115     0.200
    54.554     1.263     0.200
    54.632     1.355     0.200
    54.725     0.443     0.200
    54.725     1.122     0.200
    54.729     1.840     0.200
    54.813     1.117     0.200
    54.848     1.143     0.200
    54.915     1.301     0.200
    54.918     1.123     0.200
    55.119     1.230     0.200
    55.118     1.014     0.200
    55.119     1.128     0.200
    55.179     1.049     0.200
    55.198     1.117     0.200
    55.296     1.458     0.200
    55.350     1.221     0.200
    55.383     0.539     0.200
    55.530     0.736     0.200
    55.612     0.718     0.200
    55.646     1.086     0.200
    55.668     0.663     0.200
    55.698     1.092     0.200
    55.698     1.433     0.200
    55.718     0.632     0.200
    55.800     0.516     0.200
    55.869     0.733     0.200
    55.889     0.366     0.200
    55.941     0.609     0.200
    56.067     0.474     0.200
    56.087     0.610     0.200
    56.088     0.386     0.200
    56.123     0.476     0.200
    56.176     0.794     0.200
    56.221     0.727     0.200
    56.249     0.489     0.200
    56.353     1.112     0.200
    56.389     0.798     0.200
    56.405     0.703     0.200
    56.495     0.670     0.200
    56.618     0.681     0.200
    56.696     0.531     0.200
    56.714     0.687     0.200
    56.746     0.910     0.200
    56.751     0.516     0.200
    56.904     0.437     0.200
    56.914     0.676     0.200
    56.915     0.447     0.200
    57.042     0.545     0.200
    57.161     0.399     0.200
    57.178     0.521     0.200
    57.233     0.313     0.200
    57.267     0.430     0.200
    57.289     0.081     0.200
    57.397     0.601     0.200
    57.407     0.410     0.200
    57.426     0.582     0.200
    57.468     0.977     0.200
    57.520     0.525     0.200
    57.528     0.714     0.200
    57.565     0.066     0.200
    57.691     0.135     0.200
    57.727     0.384     0.200
    57.831     0.366     0.200
    57.895     0.499     0.200
    57.955     0.153     0.200
    57.978     0.609     0.200
    57.985     0.604     0.200
    58.060     0.832     0.200
    58.067     0.697     0.200
    58.180     0.681     0.200
    58.287     0.590     0.200
    58.296     0.014     0.200
    58.336     0.702     0.200
    58.413     0.239     0.200
    58.548     0.231     0.200
    58.899     0.206     0.200
    58.965     0.548     0.200
    58.969     0.508     0.200
    59.007     0.547     0.200
    59.064     0.734     0.200
    59.064     0.513     0.200
    59.103     0.536     0.200
    59.131     0.311     0.200
    59.256     0.629     0.200
    59.297     0.504     0.200
    59.493     0.370     0.200
    59.520     1.072     0.200
    59.530     0.286     0.200
    59.568    -0.085     0.200
    59.614     0.504     0.200
    59.621     1.315     0.200
    59.621     0.623     0.200
    59.718     0.731     0.200
    59.749     0.616     0.200
    59.754     0.955     0.200
    59.944     0.942     0.200
    59.979     0.140     0.200
    60.107     1.049     0.200
    60.123     0.476     0.200
    60.491     0.572     0.200
    60.717     1.012     0.200
    60.742     0.325     0.200
    60.874     1.372     0.200
    60.874     0.436     0.200
    61.176    -0.037     0.200
    61.244     0.982     0.200
    61.579     0.508     0.200
    61.859     1.175     0.200
    80.744     2.029     0.200
    80.874     1.157     0.200
    85.319     1.159     0.200
    85.460     1.131     0.200
    85.460     1.281     0.200
    85.583     1.696     0.200
    93.019     1.404     0.200
    16.513     1.649     0.200
    16.654     3.710     0.200
    18.470    -0.205     0.200
    18.719     1.372     0.200
    18.732    -0.625     0.200
    19.003     0.529     0.200
    19.042     1.783     0.200
    19.285     2.517     0.200
    19.480    -1.000     0.200
    20.120    -1.001     0.200
    20.140     0.457     0.200
    20.227    -0.552     0.200
    20.367    -0.767     0.200
    20.446     0.016     0.200
    20.560    -1.221     0.200
    20.566    -1.254     0.200
    20.631     1.531     0.200
    21.259    -0.200     0.200
    22.205    -0.679     0.200
    22.433    -1.424     0.200
    22.488    -1.680     0.200
    22.620    -2.724     0.200
    22.620    -2.841     0.200
    23.435     1.214     0.200
    23.435     2.308     0.200
    23.467    -2.347     0.200
    23.618    -2.301     0.200
    23.618    -2.067     0.200
    23.910     1.161     0.200
    24.633     2.187     0.200
    24.988    -1.009     0.200
    24.988    -0.876     0.200
    25.112     0.174     0.200
    25.362    -0.049     0.200
    25.531    -0.699     0.200
    26.473     2.019     0.200
    30.438    -0.551     0.200
    30.956     1.559     0.200
    32.324    -1.231     0.200
    35.892     0.018     0.200
    36.023    -0.305     0.200
    43.111     1.719     0.200
    43.165     1.272     0.200
    43.410     1.527     0.200
    43.996     1.230     0.200
    44.140     1.728     0.200
    44.201     2.204     0.200
    44.556    -0.295     0.200
    44.992     1.668     0.200
    45.261     1.715     0.200
    45.334     1.741     0.200
    45.583     1.675     0.200
    45.980    -0.901     0.200
    46.248     1.838     0.200
    46.294     1.279     0.200
    46.483     1.638     0.200
    47.298     1.196     0.200
    47.488     1.355     0.200
    47.720     1.407     0.200
    47.793     1.738     0.200
    47.946     0.983     0.200
    47.946     1.788     0.200
    47.969     1.797     0.200
    48.356     1.843     0.200
    48.398     1.519     0.200
    48.486     1.559     0.200
    48.492     1.631     0.200
    48.510     1.859     0.200
    48.804     1.688     0.200
    48.966     1.919     0.200
    49.247     2.207     0.200
    49.420     0.962     0.200
    49.396     1.906     0.200
    49.529     1.841     0.200
    49.594     1.990     0.200
    49.966     1.847     0.200
    50.339     1.623     0.200
    50.462     1.805     0.200
    50.689     1.593     0.200
    50.838     1.832     0.200
    50.891     1.305     0.200
    51.061     1.846     0.200
    51.177     1.597     0.200
    51.314     1.144     0.200
    51.375     2.055     0.200
    51.397     1.305     0.200
    51.421     1.329     0.200
    51.484     1.638     0.200
    51.502     0.264     0.200
    51.514     1.566     0.200
    51.567     2.267     0.200
    52.002     1.767     0.200
    52.039     0.685     0.200
    52.106     1.085     0.200
    52.186     0.743     0.200
    52.248     1.829     0.200
    52.268     2.045     0.200
    52.365     0.879     0.200
    52.466     1.789     0.200
    52.469     0.691     0.200
    52.469     0.253     0.200
    52.479     0.285     0.200
    52.573     0.595     0.200
    52.655     0.766     0.200
    52.692     0.848     0.200
    52.709     1.320     0.200
    52.730     1.509     0.200
    52.747     1.443     0.200
    52.847     1.437     0.200
    52.953     1.114     0.200
    52.989     1.589     0.200
    53.024     1.634     0.200
    53.049     1.560     0.200
    53.093     0.746     0.200
    53.117     0.526     0.200
    53.133     0.321     0.200
    53.181     0.675     0.200
    53.298     1.217     0.200
    53.323     1.196     0.200
    53.337     1.470     0.200
    53.354     1.526     0.200
    53.488     1.154     0.200
    53.592     0.801     0.200
    53.629     1.439     0.200
    53.719     1.148     0.200
    53.786     1.119     0.200
    53.808     1.382     0.200
    53.909     1.487     0.200
    54.033     0.490     0.200
    54.033     0.881     0.200
    54.122     0.801     0.200
    54.122     1.200     0.200
    54.131    -0.185     0.200
    54.131     0.752     0.200
    54.203     0.527     0.200
    54.203     1.387     0.200
    54.215     0.554     0.200
    54.215     1.195     0.200
    54.227     0.932     0.200
    54.419     0.127     0.200
    54.330     0.069     0.200
    54.330     0.842     0.200
    54.377    -0.293     0.200
    54.385     1.842     0.200
    54.384     1.846     0.200
    54.442     0.152     0.200
    54.442     0.926     0.200
    54.497     0.786     0.200
    54.497     1.021     0.200
    54.567     0.278     0.200
    54.571     0.232     0.200
    54.707     1.335     0.200
    54.726     0.876     0.200
    54.744     0.780     0.200
    54.766     0.202     0.200
    54.788     0.663     0.200
    54.788     1.007     0.200
    54.913     1.039     0.200
    54.983     0.538     0.200
    54.989     0.466     0.200
    54.989     0.872     0.200
    55.083     0.770     0.200
    55.105     0.863     0.200
    55.178     0.360     0.200
    55.178     0.641     0.200
    55.229     0.597     0.200
    55.229     0.987     0.200
    55.263     1.409     0.200
    55.296     0.142     0.200
    55.308     1.047     0.200
    55.308     0.898     0.200
    55.318     1.357     0.200
    55.349     0.905     0.200
    55.349     1.217     0.200
    55.402     0.593     0.200
    55.402     0.452     0.200
    55.588     0.629     0.200
    55.701     0.543     0.200
    55.705     1.227     0.200
    55.705     0.868     0.200
    55.713     1.039     0.200
    55.713     1.485     0.200
    55.739     0.487     0.200
    55.785     0.948     0.200
    55.821     0.666     0.200
    55.821     0.830     0.200
    55.909     0.708     0.200
    55.963     0.696     0.200
    56.035     0.935     0.200
    56.035     1.068     0.200
    56.063     1.012     0.200
    56.201     0.612     0.200
    56.304     0.810     0.200
    56.336     1.056     0.200
    56.345     0.703     0.200
    56.519     0.382     0.200
    56.526     0.892     0.200
    56.526     0.611     0.200
    56.547     0.617     0.200
    56.631     0.432     0.200
    56.631     0.283     0.200
    56.727     0.664     0.200
    56.750     0.179     0.200
    56.857     0.909     0.200
    56.882     0.921     0.200
    56.882     0.695     0.200
    56.890     0.452     0.200
    56.890     0.335     0.200
    56.955     0.580     0.200
    57.043     0.489     0.200
    57.043     0.177     0.200
    57.060     0.119     0.200
    57.113     0.456     0.200
    57.113    -0.067     0.200
    57.131     0.393     0.200
    57.187     0.651     0.200
    57.187     1.159     0.200
    57.306     0.183     0.200
    57.306    -0.106     0.200
    57.400     0.226     0.200
    57.521     0.107     0.200
    57.521     0.341     0.200
    57.551     0.086     0.200
    57.583     0.172     0.200
    57.615     0.225     0.200
    57.639     0.406     0.200
    57.673     0.925     0.200
    57.745     0.529     0.200
    57.906     0.793     0.200
    57.906     0.551     0.200
    57.918     1.120     0.200
    57.930     0.455     0.200
    57.946     0.802     0.200
    58.039     1.029     0.200
    58.142    -0.077     0.200
    58.240     0.130     0.200
    58.531     0.230     0.200
    58.531     0.699     0.200
    58.587     0.378     0.200
    58.587     0.823     0.200
    58.612     0.671     0.200
    58.626     0.513     0.200
    58.661    -0.126     0.200
    58.661    -0.001     0.200
    58.692     1.219     0.200
    58.748     0.932     0.200
    58.829     0.726     0.200
    58.863     1.000     0.200
    59.052     0.632     0.200
    59.066     0.547     0.200
    59.081     0.951     0.200
    59.097     0.561     0.200
    59.123     0.797     0.200
    59.199     0.668     0.200
    59.199     0.777     0.200
    59.222     0.915     0.200
    59.222     0.720     0.200
    59.323     0.706     0.200
    59.323     0.456     0.200
    59.362     0.784     0.200
    59.375     1.159     0.200
    59.568     0.485     0.200
    59.610     0.773     0.200
    59.722     0.374     0.200
    59.722     0.718     0.200
    59.791     0.772     0.200
    59.901     1.023     0.200
    60.055     1.604     0.200
    60.103     0.079     0.200
    60.103     0.470     0.200
    60.406     0.796     0.200
    60.475    -0.106     0.200
    60.475     1.340     0.200
    60.527     0.570     0.200
    60.773     0.492     0.200
    60.850     0.397     0.200
    60.858     0.976     0.200
    60.858     0.844     0.200
    61.188     0.966     0.200
    61.188     0.646     0.200
    61.460     0.321     0.200
    61.533     0.789     0.200
    61.533     0.664     0.200
    61.684     0.427     0.200
    61.781     0.545     0.200
    61.788     0.647     0.200
    62.580     0.663     0.200
    63.724     0.547     0.200
    71.044    -0.304     0.200
    71.416     0.100     0.200
    77.884    -0.962     0.200
    80.260     1.137     0.200
    80.965    -0.160     0.200
    81.783     0.976     0.200
    82.138     0.863     0.200
    82.225     1.705     0.200
    82.332     1.449     0.200
    82.361     5.050     0.200
    82.388     1.549     0.200
    82.495     1.250     0.200
    82.581     1.332     0.200
    82.625     1.095     0.200
    82.772     1.226     0.200
    82.889     1.088     0.200
    82.977     0.050     0.200
    82.977     0.956     0.200
    82.983     2.065     0.200
    83.031     1.667     0.200
    83.108     1.229     0.200
    83.110     1.874     0.200
    83.200     1.136     0.200
    83.213     0.874     0.200
    83.229    -0.250     0.200
    83.229     0.320     0.200
    83.273     1.527     0.200
    83.392     1.222     0.200
    83.422     1.122     0.200
    83.474     1.749     0.200
    83.480     1.426     0.200
    83.677     2.011     0.200
    84.052     1.334     0.200
    85.232    -0.221     0.200
    85.471     0.292     0.200
    85.471    -0.153     0.200
    85.810     0.904     0.200
    86.231     2.668     0.200
    86.991     0.032     0.200
    87.579     1.549     0.200
    90.961    -1.202     0.200
    93.122    -1.104     0.200
    97.032     1.542     0.200
    24.689     1.496     0.200
    55.391    -0.541     0.200
    24.760     2.908     0.200
    25.459     1.145     0.200
    55.431     1.177     0.200
    24.786    -0.221     0.200
    54.625    -0.048     0.200
    23.880     1.833     0.200
    24.908     1.066     0.200
    43.864     1.931     0.200
    44.510     1.934     0.200
    44.561     2.094     0.200
    45.401     1.845     0.200
    45.619     1.948     0.200
    47.653     1.773     0.200
    48.282     1.480     0.200
    48.340     1.316     0.200
    48.762     1.066     0.200
    48.860     0.904     0.200
    48.862     1.408     0.200
    48.862     1.291     0.200
    48.877     1.459     0.200
    49.174     1.066     0.200
    49.245     1.011     0.200
    49.777     1.382     0.200
    49.889     1.126     0.200
    49.975     1.724     0.200
    50.333     1.452     0.200
    50.554     1.289     0.200
    50.699     1.133     0.200
    50.860     1.522     0.200
    50.878     1.582     0.200
    51.041     1.041     0.200
    51.123     1.065     0.200
    51.230     1.647     0.200
    51.233     0.743     0.200
    51.441     1.282     0.200
    51.577     1.347     0.200
    51.734     0.661     0.200
    51.778     0.972     0.200
    51.867     1.140     0.200
    52.382     0.784     0.200
    52.391     0.924     0.200
    52.403     1.350     0.200
    52.502     0.974     0.200
    52.516     1.543     0.200
    52.579     0.891     0.200
    52.695     0.977     0.200
    52.790     0.421     0.200
    52.921     0.614     0.200
    53.028     0.935     0.200
    53.031     0.802     0.200
    53.077     1.781     0.200
    53.116     1.230     0.200
    53.149     1.450     0.200
    53.220     1.123     0.200
    53.362     0.975     0.200
    53.366     0.911     0.200
    53.410     0.511     0.200
    53.436     0.276     0.200
    53.446     0.992     0.200
    53.407     1.918     0.200
    53.530     1.577     0.200
    53.533     0.836     0.200
    53.732     0.809     0.200
    53.733     0.563     0.200
    53.734     0.761     0.200
    53.811     1.164     0.200
    53.879     1.131     0.200
    53.938     0.421     0.200
    54.091     0.807     0.200
    54.182     1.078     0.200
    54.376     0.692     0.200
    54.453     0.529     0.200
    54.509     0.881     0.200
    54.521     0.722     0.200
    54.705     0.805     0.200
    54.707     0.883     0.200
    54.832     0.940     0.200
    54.882     0.625     0.200
    54.914     1.221     0.200
    55.087     0.379     0.200
    55.092     0.290     0.200
    55.099     0.664     0.200
    55.166     1.850     0.200
    55.184     0.725     0.200
    55.320     0.774     0.200
    55.365     0.589     0.200
    55.429     0.760     0.200
    55.521     1.365     0.200
    55.606     1.084     0.200
    55.634     0.547     0.200
    55.674     0.721     0.200
    55.677     0.793     0.200
    55.691     0.771     0.200
    55.782     0.803     0.200
    55.815     1.426     0.200
    55.856     0.358     0.200
    55.908     0.344     0.200
    56.061     0.524     0.200
    56.064     0.245     0.200
    56.171     0.827     0.200
    56.203     0.284     0.200
    56.229     0.581     0.200
    56.332     1.755     0.200
    56.351     1.352     0.200
    56.380     0.375     0.200
    56.488     1.034     0.200
    56.491     0.509     0.200
    56.542     2.221     0.200
    56.606     0.780     0.200
    56.689     0.262     0.200
    56.692     1.168     0.200
    56.729     0.592     0.200
    56.750     1.257     0.200
    56.872    -0.086     0.200
    56.892     0.651     0.200
    56.896     0.613     0.200
    57.029     0.878     0.200
    57.156     0.675     0.200
    57.170     0.850     0.200
    57.208     0.649     0.200
    57.244     0.367     0.200
    57.272     0.156     0.200
    57.378     0.229     0.200
    57.379     0.292     0.200
    57.453     0.801     0.200
    57.498     0.538     0.200
    57.516     0.911     0.200
    57.540     0.742     0.200
    57.687     1.481     0.200
    57.869     0.459     0.200
    57.938     0.252     0.200
    58.175     0.698     0.200
    58.267     0.254     0.200
    58.315     0.646     0.200
    58.387     0.636     0.200
    58.871     0.447     0.200
    58.988     0.540     0.200
    59.047     0.684     0.200
    59.060     1.289     0.200
    59.247     0.667     0.200
    59.291     1.145     0.200
    59.585     2.614     0.200
    59.603     0.689     0.200
    59.698     0.732     0.200
    59.727     0.579     0.200
    59.730     0.433     0.200
    59.918     0.075     0.200
    59.951     0.129     0.200
    60.084    -0.012     0.200
    60.470     0.212     0.200
    60.744     0.281     0.200
    61.222     0.360     0.200
    61.558    -0.021     0.200
    62.162    -0.095     0.200
    62.842    -0.222     0.200
    64.151     0.282     0.200
    80.759     0.794     0.200
    85.229    -0.191     0.200
    17.118     2.614     0.200
    17.118     2.454     0.200
    17.505     4.318     0.200
    17.505     1.738     0.200
    18.392     0.099     0.200
    18.999    -0.612     0.200
    19.195     1.043     0.200
    19.701    -0.356     0.200
    19.701     0.984     0.200
    19.709     1.267     0.200
    20.148    -0.810     0.200
    20.632    -0.118     0.200
    21.659     3.097     0.200
    21.792     0.202     0.200
    22.106     1.521     0.200
    22.379    -1.386     0.200
    22.379    -1.597     0.200
    22.705     1.101     0.200
    23.157    -1.374     0.200
    23.672     0.119     0.200
    24.072     0.395     0.200
    24.359     2.889     0.200
    24.621     0.964     0.200
    25.087    -0.093     0.200
    25.274     0.693     0.200
    25.274     0.249     0.200
    26.132     0.042     0.200
    26.132     0.452     0.200
    26.129    -1.037     0.200
    26.302    -0.570     0.200
    27.230    -0.163     0.200
    27.437    -0.967     0.200
    29.940     1.231     0.200
    30.695    -0.361     0.200
    31.224    -1.376     0.200
    31.506     0.710     0.200
    32.289     0.292     0.200
    32.599    -1.254     0.200
    33.204    -1.775     0.200
    34.868    -0.663     0.200
    34.868    -0.044     0.200
    34.998     0.212     0.200
    35.357    -1.991     0.200
    36.602    -1.735     0.200
    36.602    -0.755     0.200
    41.151    -0.160     0.200
    41.900    -0.666     0.200
    42.452    -2.686     0.200
    43.801    -1.078     0.200
    45.113    -0.274     0.200
    45.139    -0.681     0.200
    45.139    -0.220     0.200
    45.859    -1.146     0.200
    45.956     1.208     0.200
    46.455    -0.698     0.200
    48.325     1.809     0.200
    52.307     1.020     0.200
    53.819    -0.324     0.200
    54.641    -0.459     0.200
    55.137     0.996     0.200
    55.137     0.799     0.200
    55.532    -0.086     0.200
    60.039     0.799     0.200
    60.896    -0.913     0.200
    61.291    -1.012     0.200
    61.986    -0.144     0.200
    62.480     0.577     0.200
    64.572     0.356     0.200
    65.317     0.279     0.200
    65.317     0.109     0.200
    65.317    -0.141     0.200
    66.507    -0.284     0.200
    78.129     1.176     0.200
    80.723     1.378     0.200
    81.266     2.348     0.200
    85.281     1.589     0.200
    85.281     0.079     0.200
    85.369     0.193     0.200
    85.369     0.529     0.200
    85.398     1.155     0.200
    85.398     1.118     0.200
    90.980     0.568     0.200
    92.521     1.295     0.200
    53.893    -0.573     0.200
    55.215     0.758     0.200
    23.966     2.972     0.200
    25.014     0.728     0.200
    54.801     0.627     0.200
    15.388     2.189     0.200
    15.388     2.841     0.200
    16.070     3.512     0.200
    16.662     2.010     0.200
    16.662     2.377     0.200
    16.662     3.221     0.200
    17.505     2.624     0.200
    17.872    -0.335     0.200
    18.143    -0.925     0.200
    18.143    -0.535     0.200
    18.552    -0.306     0.200
    19.419     1.598     0.200
    19.331    -0.236     0.200
    19.518    -0.511     0.200
    19.955    -0.619     0.200
    20.322    -0.365     0.200
    20.511    -0.481     0.200
    20.642     0.839     0.200
    21.265     2.217     0.200
    21.354     1.269     0.200
    21.475     1.977     0.200
    21.435    -1.395     0.200
    22.116    -1.121     0.200
    22.197    -1.442     0.200
    22.197    -1.063     0.200
    22.401    -1.225     0.200
    22.989    -1.020     0.200
    23.072    -2.438     0.200
    23.188     2.074     0.200
    23.651    -1.167     0.200
    23.858     2.007     0.200
    24.146     0.481     0.200
    24.238    -1.348     0.200
    24.238    -0.930     0.200
    24.363    -0.973     0.200
    24.498    -0.008     0.200
    24.579    -1.278     0.200
    24.579    -0.966     0.200
    24.813    -0.104     0.200
    24.813    -0.249     0.200
    24.853    -1.354     0.200
    24.949    -0.811     0.200
    25.003    -1.233     0.200
    25.578     1.652     0.200
    26.747    -1.639     0.200
    27.673    -1.536     0.200
    28.034    -1.244     0.200
    30.335    -1.084     0.200
    30.900    -1.715     0.200
    31.808    -0.215     0.200
    32.102     1.355     0.200
    32.233    -2.067     0.200
    33.056    -1.596     0.200
    35.776    -0.967     0.200
    36.194    -0.978     0.200
    36.194    -0.697     0.200
    38.027    -0.990     0.200
    39.665    -1.324     0.200
    39.921    -1.240     0.200
    40.777    -0.293     0.200
    41.749    -1.576     0.200
    43.690    -1.302     0.200
    44.691    -1.841     0.200
    44.691     0.213     0.200
    45.632    -1.809     0.200
    46.064    -1.670     0.200
    48.816     2.750     0.200
    50.273     0.874     0.200
    50.636     1.001     0.200
    50.974     1.073     0.200
    51.162     1.456     0.200
    51.713     0.986     0.200
    51.819     1.129     0.200
    52.567    -1.146     0.200
    53.690     1.044     0.200
    54.648    -0.215     0.200
    54.648     0.777     0.200
    55.042     0.383     0.200
    55.042     0.699     0.200
    55.572     0.766     0.200
    56.141     0.910     0.200
    56.726     0.782     0.200
    57.674     0.013     0.200
    57.718    -0.247     0.200
    58.931     0.523     0.200
    59.462     0.608     0.200
    60.022     0.242     0.200
    60.409    -0.005     0.200
    61.624     0.955     0.200
    62.973     1.563     0.200
    64.022     1.582     0.200
    64.221    -0.450     0.200
    65.009    -1.163     0.200
    65.009     0.790     0.200
    65.009    -0.023     0.200
    66.009    -1.572     0.200
    66.251     2.096     0.200
    69.796     1.073     0.200
    70.888    -0.782     0.200
    70.888    -0.985     0.200
    71.330    -0.359     0.200
    71.330    -0.808     0.200
    73.168     0.720     0.200
    73.168     1.439     0.200
    77.776    -0.048     0.200
    77.780     0.342     0.200
    80.529    -0.006     0.200
    80.547    -0.186     0.200
    80.764     0.916     0.200
    80.764     1.482     0.200
    81.362     0.238     0.200
    82.398     0.567     0.200
    83.463     0.360     0.200
    83.463     0.039     0.200
    84.997     2.419     0.200
    85.051    -1.019     0.200
    85.051    -0.112     0.200
    85.155     0.143     0.200
    85.155     0.041     0.200
    85.234     0.708     0.200
    85.234    -0.620     0.200
    85.373     1.618     0.200
    85.577     2.078     0.200
    86.435     2.068     0.200
    86.673    -0.567     0.200
    89.566     1.597     0.200
    90.704    -0.943     0.200
    92.090    -0.474     0.200
    92.689    -0.615     0.200
    13.856     5.270     0.200
    14.382     3.411     0.200
    14.416     4.546     0.200
    14.483     4.512     0.200
    14.627     3.305     0.200
    14.873     4.721     0.200
    16.557     4.325     0.200
    16.698     2.160     0.200
    16.698     2.219     0.200
    17.042     2.229     0.200
    17.063     1.618     0.200
    17.045     1.029     0.200
    17.195     1.895     0.200
    17.307     2.087     0.200
    17.377     1.458     0.200
    17.432     1.457     0.200
    17.523     1.282     0.200
    17.703     0.609     0.200
    17.791     0.417     0.200
    18.223    -0.652     0.200
    18.221    -0.679     0.200
    18.293     0.016     0.200
    18.531     0.465     0.200
    19.312     0.181     0.200
    19.487    -0.073     0.200
    19.887     0.001     0.200
    20.092     1.074     0.200
    20.333     0.086     0.200
    20.391     0.867     0.200
    20.415     0.486     0.200
    20.473    -0.080     0.200
    20.529    -0.243     0.200
    20.900     0.183     0.200
    21.884     0.129     0.200
    22.091    -0.457     0.200
    23.721     2.021     0.200
    24.254    -0.207     0.200
    24.385    -0.461     0.200
    24.574    -0.301     0.200
    24.704     0.858     0.200
    24.704     1.077     0.200
    24.704     1.507     0.200
    24.872    -0.786     0.200
    25.109    -0.568     0.200
    44.589    -0.288     0.200
    44.589     0.743     0.200
    45.615     0.028     0.200
    54.259     1.119     0.200
    54.522     0.366     0.200
    54.522     0.224     0.200
    54.522     0.923     0.200
    54.937    -0.610     0.200
    55.091     0.498     0.200
    55.350     0.577     0.200
    55.440     0.794     0.200
    55.452     0.930     0.200
    56.006     0.224     0.200
    56.590     1.583     0.200
    56.713     1.506     0.200
    57.001     0.576     0.200
    57.091     0.320     0.200
    57.341     0.316     0.200
    57.592     0.316     0.200
    57.680     0.219     0.200
    58.581     0.561     0.200
    59.898     0.771     0.200
    62.814    -0.060     0.200
    83.348     0.954     0.200
    85.001    -0.667     0.200
    92.138    -0.717     0.200
    14.528     4.788     0.200
    14.793     5.184     0.200
    14.814     4.973     0.200
    14.899     4.293     0.200
    14.974     3.825     0.200
    15.539     6.074     0.200
    15.686     3.738     0.200
    15.995     4.170     0.200
    16.167     4.242     0.200
    16.204     4.335     0.200
    16.551     3.837     0.200
    16.599     3.799     0.200
    17.065     4.640     0.200
    17.065     4.011     0.200
    17.067     3.980     0.200
    17.067     3.736     0.200
    17.068     3.740     0.200
    17.102     2.323     0.200
    18.205     0.031     0.200
    18.518    -0.694     0.200
    18.535     0.324     0.200
    18.826     0.588     0.200
    19.293     0.249     0.200
    19.427    -0.758     0.200
    19.693     1.937     0.200
    19.747    -0.700     0.200
    19.915     1.672     0.200
    20.590     2.320     0.200
    20.630     0.493     0.200
    20.699     1.731     0.200
    20.666     2.759     0.200
    20.767     1.563     0.200
    20.912    -0.635     0.200
    21.185     4.559     0.200
    21.694     1.066     0.200
    22.423     1.714     0.200
    23.475     3.030     0.200
    23.716     2.077     0.200
    23.714     1.445     0.200
    23.791    -1.713     0.200
    23.941     2.584     0.200
    24.187    -2.461     0.200
    24.319    -2.090     0.200
    24.315     1.501     0.200
    24.409     2.393     0.200
    24.520     2.986     0.200
    24.616    -0.041     0.200
    25.069     1.867     0.200
    25.237    -0.491     0.200
    25.237     0.970     0.200
    25.237     0.458     0.200
    25.589     0.532     0.200
    25.870     1.324     0.200
    26.796    -1.880     0.200
    27.266     0.796     0.200
    27.866     1.372     0.200
    29.227     0.057     0.200
    29.438     4.374     0.200
    30.443    -1.797     0.200
    30.443    -0.355     0.200
    32.317     0.138     0.200
    32.317     0.763     0.200
    32.354    -1.981     0.200
    34.489     2.090     0.200
    36.431    -0.463     0.200
    36.431    -0.841     0.200
    45.031     2.327     0.200
    45.056    -0.971     0.200
    46.251    -2.014     0.200
    50.231     1.380     0.200
    52.367     0.013     0.200
    52.674    -1.577     0.200
    52.944     0.682     0.200
    53.164    -0.354     0.200
    53.692     1.015     0.200
    53.984     0.530     0.200
    54.018     0.006     0.200
    54.128     0.940     0.200
    54.198     1.103     0.200
    55.198     0.536     0.200
    55.594     0.753     0.200
    56.080    -0.156     0.200
    56.182     0.796     0.200
    56.199     0.724     0.200
    56.396    -0.616     0.200
    56.529     0.019     0.200
    56.619    -1.906     0.200
    56.717     0.433     0.200
    57.155     0.462     0.200
    57.452     0.932     0.200
    57.452     2.525     0.200
    58.059     0.180     0.200
    58.633     0.125     0.200
    58.796     0.722     0.200
    59.664    -1.206     0.200
    59.687     0.479     0.200
    60.106     0.505     0.200
    60.620     2.258     0.200
    60.946     0.059     0.200
    61.939     2.798     0.200
    62.040    -0.316     0.200
    62.173     1.436     0.200
    62.173     1.159     0.200
    62.173     0.905     0.200
    63.137     1.889     0.200
    63.710     0.347     0.200
    64.299    -1.488     0.200
    64.985    -0.529     0.200
    65.641     2.652     0.200
    65.641     2.227     0.200
    65.641     2.926     0.200
    65.641     2.457     0.200
    65.893     1.526     0.200
    66.175    -1.715     0.200
    66.175    -1.867     0.200
    66.353     1.323     0.200
    67.198     1.211     0.200
    67.198     2.945     0.200
    68.487     2.515     0.200
    70.918    -1.557     0.200
    70.918    -1.752     0.200
    71.440    -1.004     0.200
    73.738     0.594     0.200
    73.738     1.543     0.200
    80.253     0.769     0.200
    80.722     1.703     0.200
    81.487     1.222     0.200
    81.487     2.086     0.200
    81.487     1.222     0.200
    81.888     0.848     0.200
    82.742     0.484     0.200
    82.742     2.152     0.200
    82.742     1.976     0.200
    83.922     0.169     0.200
    83.922    -0.542     0.200
    84.104     1.778     0.200
    84.487     0.070     0.200
    84.487     0.972     0.200
    84.726     0.909     0.200
    84.726     0.323     0.200
    84.727     0.441     0.200
    84.956     1.922     0.200
    84.942     0.806     0.200
    84.968     1.409     0.200
    84.989     0.363     0.200
    84.989     0.714     0.200
    85.048    -1.311     0.200
    85.850     2.214     0.200
    86.354    -1.034     0.200
    87.248     0.600     0.200
    87.379    -0.031     0.200
    87.622     0.017     0.200
    88.056     1.015     0.200
    88.532     0.949     0.200
    89.028     0.829     0.200
    90.122     1.598     0.200
    90.122     0.133     0.200
    90.122     1.723     0.200
    90.608    -0.991     0.200
    90.946    -0.031     0.200
    92.373     0.536     0.200
    92.759     0.390     0.200
    93.012     0.348     0.200
    93.721     0.170     0.200
    93.759     0.371     0.200
    94.627     1.250     0.200
    15.315     2.717     0.200
    15.315     3.236     0.200
    16.447     3.743     0.200
    17.677     0.366     0.200
    18.771     0.554     0.200
    19.122    -0.152     0.200
    19.224    -0.222     0.200
    19.224     1.424     0.200
    19.363    -0.087     0.200
    20.390     2.162     0.200
    20.389     1.639     0.200
    20.426     0.672     0.200
    20.929     0.601     0.200
    21.101     1.855     0.200
    21.181     0.574     0.200
    21.298     0.410     0.200
    21.517     3.081     0.200
    21.579     0.540     0.200
    21.579     1.109     0.200
    21.652    -0.328     0.200
    21.696    -1.029     0.200
    21.696    -1.154     0.200
    21.847    -0.256     0.200
    22.039     0.649     0.200
    22.540    -1.228     0.200
    23.056     1.631     0.200
    23.833     1.855     0.200
    23.546     3.550     0.200
    23.546     4.370     0.200
    23.982     1.342     0.200
    24.082    -0.138     0.200
    24.082    -0.319     0.200
    24.431     0.252     0.200
    24.611     0.393     0.200
    25.293     0.668     0.200
    25.293     0.943     0.200
    25.402    -0.063     0.200
    26.609     1.189     0.200
    27.187     1.498     0.200
    29.966    -0.139     0.200
    30.097     3.575     0.200
    30.493    -0.871     0.200
    31.663     1.027     0.200
    31.870    -1.260     0.200
    31.870    -1.366     0.200
    32.542    -0.844     0.200
    34.638     1.098     0.200
    34.638     0.989     0.200
    34.770     0.729     0.200
    35.887    -0.406     0.200
    35.887    -0.277     0.200
    35.887    -0.517     0.200
    39.604     0.672     0.200
    39.604     3.003     0.200
    40.424    -0.617     0.200
    41.236    -0.794     0.200
    41.286    -0.746     0.200
    41.503    -0.256     0.200
    43.164    -0.437     0.200
    43.520     1.340     0.200
    44.370     0.663     0.200
    44.455    -1.010     0.200
    44.455    -0.491     0.200
    45.154    -1.532     0.200
    45.154    -1.364     0.200
    46.736     0.867     0.200
    48.693     1.160     0.200
    50.397     2.590     0.200
    50.397     2.951     0.200
    50.559    -0.895     0.200
    51.179     1.550     0.200
    51.490     2.201     0.200
    51.643     0.992     0.200
    51.703     1.434     0.200
    51.709     2.073     0.200
    51.813     2.671     0.200
    52.003     1.794     0.200
    52.199    -0.919     0.200
    52.305     0.795     0.200
    52.427     0.980     0.200
    53.253     0.488     0.200
    53.491     1.413     0.200
    54.461    -0.232     0.200
    54.533     0.376     0.200
    54.533     0.896     0.200
    54.733     0.479     0.200
    54.835     0.377     0.200
    54.835     0.223     0.200
    54.929    -0.018     0.200
    54.929     0.683     0.200
    55.428     0.877     0.200
    55.523     3.664     0.200
    55.825     3.759     0.200
    55.754    -0.788     0.200
    55.919    -0.087     0.200
    56.089    -1.550     0.200
    56.759     2.837     0.200
    57.610    -0.360     0.200
    57.684     0.704     0.200
    57.703     0.677     0.200
    57.759     1.044     0.200
    58.119    -1.094     0.200
    58.461    -1.087     0.200
    59.175     1.455     0.200
    59.175     1.654     0.200
    59.559     0.601     0.200
    59.763     2.428     0.200
    59.763     2.324     0.200
    60.005     2.488     0.200
    60.036     0.026     0.200
    60.036    -0.236     0.200
    60.182     2.520     0.200
    60.077    -0.243     0.200
    60.315     2.120     0.200
    60.351     3.101     0.200
    60.356     1.010     0.200
    60.833     2.221     0.200
    60.881     1.591     0.200
    60.881     2.312     0.200
    60.953     2.012     0.200
    61.305     2.178     0.200
    61.378     0.060     0.200
    61.550     1.011     0.200
    61.809     1.960     0.200
    62.857     0.983     0.200
    62.857     0.745     0.200
    62.857     1.110     0.200
    62.810    -1.612     0.200
    63.770     0.717     0.200
    63.770     1.819     0.200
    63.841    -0.171     0.200
    64.588    -0.003     0.200
    64.588     0.481     0.200
    64.588    -0.253     0.200
    64.808     1.576     0.200
    64.849     0.620     0.200
    64.972     2.114     0.200
    65.603    -0.039     0.200
    65.603     0.313     0.200
    65.603     0.153     0.200
    65.668    -1.482     0.200
    65.668    -1.661     0.200
    65.892     0.632     0.200
    66.191     1.403     0.200
    66.319     1.667     0.200
    66.319     2.468     0.200
    66.319     2.017     0.200
    66.535     2.217     0.200
    67.789     1.765     0.200
    67.870     2.319     0.200
    68.285     1.912     0.200
    68.412     1.451     0.200
    68.453     2.247     0.200
    68.688     2.012     0.200
    68.913     1.388     0.200
    69.135     2.513     0.200
    69.818     2.000     0.200
    69.818     2.250     0.200
    70.024    -1.037     0.200
    70.024    -1.162     0.200
    70.488    -1.039     0.200
    70.488    -1.213     0.200
    70.964    -0.083     0.200
    70.964    -0.634     0.200
    71.294     2.022     0.200
    72.060     1.235     0.200
    73.069     0.916     0.200
    73.069     1.205     0.200
    76.258     1.368     0.200
    77.399     0.045     0.200
    80.044     0.823     0.200
    80.045    -0.408     0.200
    80.796     1.387     0.200
    80.796     1.192     0.200
    80.858     0.904     0.200
    81.121     1.040     0.200
    81.266     1.411     0.200
    81.388     1.018     0.200
    81.473     1.009     0.200
    81.511     0.838     0.200
    81.647     0.871     0.200
    81.759     0.964     0.200
    81.828     1.041     0.200
    81.861     0.779     0.200
    81.861     0.890     0.200
    81.881     1.570     0.200
    81.937     1.182     0.200
    81.964     0.976     0.200
    81.964     1.258     0.200
    81.226     4.805     0.200
    82.001     1.263     0.200
    82.058     0.525     0.200
    82.078     1.110     0.200
    82.079     0.876     0.200
    82.131     0.824     0.200
    82.131     1.174     0.200
    82.267     0.980     0.200
    82.292     0.693     0.200
    82.330     1.491     0.200
    82.341     1.246     0.200
    82.530     1.590     0.200
    82.644     1.483     0.200
    82.916     0.970     0.200
    83.286     0.362     0.200
    84.159     1.205     0.200
    84.460     0.951     0.200
    84.460     1.492     0.200
    84.460     1.072     0.200
    84.639    -0.157     0.200
    84.658     0.972     0.200
    84.658     0.843     0.200
    84.687     0.430     0.200
    84.687     0.129     0.200
    84.687     0.078     0.200
    84.697     0.480     0.200
    84.697     0.919     0.200
    84.849     0.992     0.200
    85.834     0.341     0.200
    85.933     0.701     0.200
    86.108     0.397     0.200
    86.203    -0.652     0.200
    86.329    -0.747     0.200
    86.365     0.903     0.200
    86.378     0.631     0.200
    86.638     0.448     0.200
    86.708     0.785     0.200
    86.708     0.225     0.200
    86.805     0.916     0.200
    86.850     0.497     0.200
    86.960     0.138     0.200
    86.960     0.736     0.200
    87.109     0.568     0.200
    87.176     0.582     0.200
    87.461     0.803     0.200
    87.461     1.123     0.200
    87.461     0.928     0.200
    87.601     1.022     0.200
    87.601     0.736     0.200
    87.737    -0.702     0.200
    87.764     0.868     0.200
    87.841    -0.889     0.200
    87.841     0.838     0.200
    88.052     0.341     0.200
    88.140    -0.016     0.200
    88.528     0.516     0.200
    88.528     0.305     0.200
    88.742     0.900     0.200
    88.819     1.290     0.200
    88.819     0.745     0.200
    89.380     0.112     0.200
    89.590     0.313     0.200
    89.706    -0.108     0.200
    90.258    -1.134     0.200
    90.372     1.523     0.200
    90.472     0.550     0.200
    90.505    -0.137     0.200
    90.675     0.973     0.200
    90.675     0.688     0.200
    90.760     0.998     0.200
    91.396     0.558     0.200
    91.457     0.409     0.200
    91.563     0.490     0.200
    91.563     0.613     0.200
    91.821    -0.085     0.200
    92.036     0.839     0.200
    92.182     0.845     0.200
    92.182     0.589     0.200
    92.182    -0.053     0.200
    92.182     0.515     0.200
    92.907     0.074     0.200
    93.030     0.603     0.200
    93.030     0.224     0.200
    93.369     0.519     0.200
    93.524     0.107     0.200
    93.555    -0.233     0.200
    93.557    -0.103     0.200
    93.768     0.486     0.200
    94.363     1.455     0.200
    94.363     1.975     0.200
    95.928     0.709     0.200
    96.116     1.701     0.200
    97.392     0.552     0.200
    98.814    -1.202     0.200
    98.816    -1.211     0.200
    98.952    -1.566     0.200
    99.036    -0.671     0.200
    14.961     5.142     0.200
    14.994     5.515     0.200
    15.067     3.981     0.200
    15.217     4.994     0.200
    15.455     4.021     0.200
    15.859     3.484     0.200
    15.980     3.813     0.200
    16.101     4.557     0.200
    16.287     5.143     0.200
    16.793     2.253     0.200
    17.042     2.884     0.200
    17.168     3.741     0.200
    17.168     2.295     0.200
    17.168     3.975     0.200
    17.741     2.697     0.200
    18.090     2.352     0.200
    18.324    -1.022     0.200
    18.813     0.815     0.200
    18.808    -1.069     0.200
    19.095    -0.862     0.200
    19.827     2.150     0.200
    20.895    -0.058     0.200
    21.218    -1.285     0.200
    21.286    -1.502     0.200
    21.431    -0.018     0.200
    21.481     0.495     0.200
    21.631    -0.576     0.200
    21.827     1.258     0.200
    21.827     3.187     0.200
    21.920    -0.039     0.200
    21.920     0.976     0.200
    22.285    -2.101     0.200
    22.285    -2.390     0.200
    22.301    -1.044     0.200
    22.301    -0.349     0.200
    22.301    -0.560     0.200
    22.534     1.019     0.200
    22.570    -0.862     0.200
    22.916    -2.021     0.200
    22.927     1.355     0.200
    23.031    -2.796     0.200
    23.750     1.478     0.200
    23.786    -1.151     0.200
    23.655     3.805     0.200
    23.655     5.070     0.200
    24.350    -1.582     0.200
    24.349    -1.340     0.200
    24.471     2.578     0.200
    24.471     1.703     0.200
    24.478     2.712     0.200
    24.679    -1.973     0.200
    24.679    -1.567     0.200
    24.679    -1.020     0.200
    24.689     0.711     0.200
    24.971    -1.638     0.200
    24.977    -0.363     0.200
    25.326     0.994     0.200
    25.329     0.425     0.200
    25.329    -0.458     0.200
    25.479    -0.316     0.200
    25.662     0.500     0.200
    25.855    -0.513     0.200
    26.021    -0.643     0.200
    26.021     0.685     0.200
    26.021     1.091     0.200
    26.113    -1.113     0.200
    26.113    -0.113     0.200
    26.113     0.863     0.200
    26.381    -1.018     0.200
    26.857     1.866     0.200
    26.943     2.095     0.200
    27.320    -2.755     0.200
    27.306     1.008     0.200
    27.853     1.385     0.200
    28.579    -2.588     0.200
    29.660     1.423     0.200
    29.660     3.579     0.200
    30.679    -0.806     0.200
    31.189    -1.724     0.200
    32.363    -1.747     0.200
    32.363     0.745     0.200
    32.586    -1.752     0.200
    32.586    -1.979     0.200
    33.487    -1.927     0.200
    34.274    -0.339     0.200
    34.677     0.435     0.200
    34.677     1.279     0.200
    36.614    -1.565     0.200
    36.614    -0.987     0.200
    36.614    -0.745     0.200
    39.126     2.894     0.200
    39.981    -2.039     0.200
    41.143    -1.467     0.200
    41.793    -1.182     0.200
    43.171     1.084     0.200
    44.141    -0.892     0.200
    44.141     1.225     0.200
    45.180    -0.951     0.200
    45.180    -0.302     0.200
    45.780    -1.237     0.200
    45.780    -1.362     0.200
    46.423     0.182     0.200
    46.423     1.143     0.200
    46.457    -2.078     0.200
    47.281     0.025     0.200
    48.173     0.656     0.200
    48.173     2.680     0.200
    48.173     2.250     0.200
    49.842     2.831     0.200
    49.797     2.037     0.200
    49.853     1.532     0.200
    49.859     2.832     0.200
    50.211     2.072     0.200
    50.607     2.883     0.200
    50.658     2.044     0.200
    50.916     2.886     0.200
    51.237     2.892     0.200
    51.350     0.583     0.200
    51.723    -0.663     0.200
    51.839     2.332     0.200
    52.001     0.008     0.200
    52.001     0.914     0.200
    52.333     1.555     0.200
    52.392     0.494     0.200
    52.555     1.472     0.200
    52.929     0.097     0.200
    52.913    -1.566     0.200
    52.945     1.925     0.200
    52.990    -0.205     0.200
    53.692     2.738     0.200
    53.735     2.023     0.200
    53.879     0.233     0.200
    53.973     1.099     0.200
    53.973     1.732     0.200
    54.074    -0.368     0.200
    54.027     1.446     0.200
    54.077     2.023     0.200
    54.077     1.718     0.200
    54.289     0.521     0.200
    54.463     0.012     0.200
    55.225     2.965     0.200
    55.152     1.417     0.200
    55.209     1.209     0.200
    55.221     1.020     0.200
    55.221     0.473     0.200
    55.221    -0.113     0.200
    55.469     0.531     0.200
    55.470     0.528     0.200
    55.617    -0.223     0.200
    55.617     0.933     0.200
    55.721     0.828     0.200
    56.051     0.834     0.200
    56.142     2.834     0.200
    56.128     0.198     0.200
    56.180     1.143     0.200
    56.326    -0.001     0.200
    57.258     0.868     0.200
    57.512     2.399     0.200
    57.512     1.899     0.200
    58.335     2.628     0.200
    58.295    -1.003     0.200
    58.820     1.145     0.200
    58.820     1.613     0.200
    59.084     0.574     0.200
    59.126     2.269     0.200
    59.367     2.506     0.200
    59.713     3.069     0.200
    59.862     2.139     0.200
    60.047     1.320     0.200
    60.069     0.213     0.200
    60.188     2.256     0.200
    60.286     0.804     0.200
    60.301     2.333     0.200
    60.301     2.130     0.200
    60.585     0.654     0.200
    60.585     1.583     0.200
    60.659     2.601     0.200
    61.157     1.925     0.200
    61.966     2.637     0.200
    63.395     2.056     0.200
    63.395     0.509     0.200
    63.457    -0.136     0.200
    63.922     1.014     0.200
    64.307     2.063     0.200
    64.408     0.635     0.200
    64.550    -0.323     0.200
    65.263     1.924     0.200
    65.273    -0.163     0.200
    65.273     0.908     0.200
    65.273     1.119     0.200
    65.273    -0.780     0.200
    65.653     2.260     0.200
    65.653     1.854     0.200
    66.140     1.449     0.200
    66.140     1.886     0.200
    66.173    -0.583     0.200
    66.173     0.230     0.200
    66.173     0.417     0.200
    66.390    -1.436     0.200
    66.528     1.458     0.200
    66.462     0.003     0.200
    67.193     2.731     0.200
    67.918     1.988     0.200
    68.007     1.295     0.200
    68.311     1.695     0.200
    68.459     2.074     0.200
    68.725     1.702     0.200
    68.829     2.497     0.200
    69.135     2.630     0.200
    69.238     2.122     0.200
    69.977     0.665     0.200
    69.977     2.469     0.200
    70.926     1.839     0.200
    70.926     1.730     0.200
    77.472     1.470     0.200
    77.645     2.206     0.200
    78.109    -0.373     0.200
    78.304     0.644     0.200
    78.714     0.536     0.200
    79.079     0.572     0.200
    79.143     0.600     0.200
    79.239    -0.194     0.200
    79.429     0.064     0.200
    79.433     1.040     0.200
    79.731     0.485     0.200
    80.428     0.956     0.200
    80.490     0.531     0.200
    80.490     0.671     0.200
    80.605    -0.517     0.200
    80.605     0.491     0.200
    80.605     1.061     0.200
    80.625     0.884     0.200
    80.736     1.151     0.200
    80.873     0.399     0.200
    80.873     2.133     0.200
    80.873     2.274     0.200
    81.395     1.205     0.200
    81.395     0.377     0.200
    81.395     1.604     0.200
    81.395    -0.091     0.200
    81.436     1.047     0.200
    81.436     1.422     0.200
    81.668     0.722     0.200
    82.081     0.725     0.200
    82.188     1.122     0.200
    82.304     0.856     0.200
    82.304     1.013     0.200
    82.517     0.964     0.200
    82.702     1.439     0.200
    82.720     1.500     0.200
    83.057     1.463     0.200
    84.903     0.494     0.200
    84.903     1.595     0.200
    84.903     1.986     0.200
    85.142     1.038     0.200
    85.142    -0.571     0.200
    85.365     1.250     0.200
    85.452     1.882     0.200
    85.677     2.380     0.200
    85.755     2.016     0.200
    86.780    -0.174     0.200
    86.935     0.702     0.200
    87.785    -0.142     0.200
    88.956     0.677     0.200
    91.821     0.606     0.200
    44.994    -1.908     0.200
    23.499     1.314     0.200
    24.065     2.181     0.200
    54.078     1.604     0.200
    18.919    -1.257     0.200
    19.668     0.154     0.200
    20.247     0.047     0.200
    20.782    -1.266     0.200
    20.822     0.047     0.200
    23.269    -1.094     0.200
    23.533    -0.611     0.200
    24.117    -0.629     0.200
    24.232     2.990     0.200
    24.232     2.008     0.200
    25.219     1.088     0.200
    25.219     1.467     0.200
    45.099    -0.774     0.200
    53.752     0.308     0.200
    55.042     0.697     0.200
    55.042     0.066     0.200
    55.867     1.073     0.200
    56.012     0.523     0.200
    57.371     0.159     0.200
    58.112    -0.179     0.200
    15.197     3.641     0.200
    15.779     3.071     0.200
    16.019     4.354     0.200
    16.442     2.229     0.200
    16.886     2.741     0.200
    16.889     3.120     0.200
    16.889     2.620     0.200
    16.889     4.601     0.200
    17.592     2.372     0.200
    17.610     0.505     0.200
    17.668     0.514     0.200
    17.779    -0.169     0.200
    18.186    -0.527     0.200
    18.253     0.091     0.200
    18.654     0.277     0.200
    18.683    -0.260     0.200
    18.685    -0.365     0.200
    18.729     0.940     0.200
    18.882     1.282     0.200
    18.894    -0.007     0.200
    19.163    -0.869     0.200
    19.357    -1.002     0.200
    19.362    -0.231     0.200
    19.487     1.396     0.200
    19.685     3.919     0.200
    19.799    -0.324     0.200
    19.920    -0.999     0.200
    19.937    -0.274     0.200
    20.143    -0.809     0.200
    20.512     0.954     0.200
    20.530     0.489     0.200
    20.582     1.956     0.200
    20.837     1.291     0.200
    20.846    -0.517     0.200
    20.912    -1.003     0.200
    21.131     2.808     0.200
    21.273    -0.489     0.200
    21.454    -0.373     0.200
    21.529     0.873     0.200
    21.529     3.203     0.200
    21.599     2.591     0.200
    21.584    -0.129     0.200
    21.584     1.130     0.200
    21.906    -1.556     0.200
    21.906    -1.927     0.200
    21.906    -1.725     0.200
    21.925    -0.689     0.200
    21.925    -1.308     0.200
    22.193    -0.537     0.200
    22.232     1.441     0.200
    22.544    -1.131     0.200
    22.662    -1.477     0.200
    22.683    -0.237     0.200
    22.786     2.285     0.200
    23.515     1.003     0.200
    23.515     1.972     0.200
    23.659     1.403     0.200
    23.659     2.274     0.200
    23.396     3.893     0.200
    24.175     1.878     0.200
    24.260     1.349     0.200
    24.297     2.377     0.200
    24.297     1.977     0.200
    24.300    -1.060     0.200
    24.300    -1.419     0.200
    24.436     0.336     0.200
    24.601    -1.488     0.200
    24.943     0.944     0.200
    25.055     0.080     0.200
    25.055    -0.269     0.200
    25.708     0.155     0.200
    25.708     0.584     0.200
    25.708     1.114     0.200
    25.761    -0.671     0.200
    25.761     0.029     0.200
    25.870     2.318     0.200
    25.979     0.803     0.200
    26.060     1.426     0.200
    26.345     1.647     0.200
    26.937     1.403     0.200
    27.066     0.758     0.200
    27.172     0.901     0.200
    28.201     0.660     0.200
    29.515     2.241     0.200
    30.057    -0.330     0.200
    30.330    -1.045     0.200
    30.330    -0.756     0.200
    30.827    -1.261     0.200
    32.120     0.443     0.200
    32.282     2.342     0.200
    32.282     1.223     0.200
    32.282     2.553     0.200
    32.282     2.774     0.200
    32.239    -1.402     0.200
    32.720    -1.607     0.200
    32.911     0.186     0.200
    33.321     0.406     0.200
    34.045     0.306     0.200
    34.224    -0.255     0.200
    34.447     1.310     0.200
    34.447     1.007     0.200
    34.921    -1.794     0.200
    35.701     0.350     0.200
    36.290    -0.726     0.200
    36.290    -0.306     0.200
    36.290    -0.877     0.200
    40.800    -1.181     0.200
    44.887    -1.366     0.200
    45.402    -1.572     0.200
    48.249     1.309     0.200
    48.132     1.292     0.200
    50.770     3.330     0.200
    50.880     3.233     0.200
    50.870    -1.561     0.200
    52.013     1.892     0.200
    52.164     0.715     0.200
    53.506     1.450     0.200
    53.613    -0.132     0.200
    53.613     0.069     0.200
    54.076     0.612     0.200
    54.086     0.504     0.200
    55.068     3.696     0.200
    54.994     0.733     0.200
    54.994     0.134     0.200
    55.144     0.420     0.200
    55.144     1.150     0.200
    55.149     0.400     0.200
    55.390     0.289     0.200
    55.390     0.168     0.200
    55.907     0.353     0.200
    56.296     2.713     0.200
    56.185    -0.346     0.200
    56.484    -1.631     0.200
    58.071    -0.352     0.200
    58.998    -0.978     0.200
    59.712    -0.912     0.200
    59.928     1.166     0.200
    60.370    -1.039     0.200
    60.519     1.185     0.200
    60.397    -1.012     0.200
    62.157     2.313     0.200
    62.411     1.870     0.200
    62.411     0.489     0.200
    63.375     2.805     0.200
    65.855     1.878     0.200
    66.058    -0.756     0.200
    66.058    -0.535     0.200
    66.051    -1.519     0.200
    66.051    -1.679     0.200
    70.826    -1.346     0.200
    71.329    -0.671     0.200
    71.329    -0.510     0.200
    77.755    -0.160     0.200
    78.701     0.331     0.200
    78.861     0.530     0.200
    80.227    -0.129     0.200
    80.227     0.509     0.200
    80.247     0.213     0.200
    81.256     1.558     0.200
    81.256     0.962     0.200
    81.346     1.456     0.200
    81.479     1.253     0.200
    81.597     1.198     0.200
    81.724     0.970     0.200
    81.832     0.444     0.200
    81.897     1.123     0.200
    81.897     0.301     0.200
    81.938     0.715     0.200
    81.945     1.109     0.200
    82.124     1.472     0.200
    82.147     1.309     0.200
    82.147     1.190     0.200
    82.159     0.849     0.200
    82.194     0.504     0.200
    82.345     1.287     0.200
    82.364     1.146     0.200
    82.392     1.517     0.200
    82.406     1.155     0.200
    82.523     0.451     0.200
    82.523     1.390     0.200
    82.523     1.669     0.200
    82.590     1.711     0.200
    82.705     2.034     0.200
    82.705     1.723     0.200
    82.741     1.157     0.200
    82.984     0.974     0.200
    83.010     1.592     0.200
    83.106     1.778     0.200
    83.156     0.905     0.200
    83.312     1.286     0.200
    83.466     1.691     0.200
    83.532     0.795     0.200
    83.558     0.878     0.200
    83.564     1.298     0.200
    83.581     0.840     0.200
    83.588     1.175     0.200
    83.735     0.114     0.200
    83.979     0.287     0.200
    84.189     0.801     0.200
    84.402     0.711     0.200
    84.544     0.142     0.200
    84.544     1.552     0.200
    84.544     2.703     0.200
    84.544     1.382     0.200
    84.688     0.837     0.200
    84.901     3.779     0.200
    84.783     1.302     0.200
    84.783     0.951     0.200
    84.947     0.274     0.200
    84.947     0.825     0.200
    84.965     0.747     0.200
    84.965     0.437     0.200
    84.965     0.048     0.200
    85.049     2.566     0.200
    85.091     1.896     0.200
    85.193     0.786     0.200
    85.207     0.444     0.200
    85.402     2.674     0.200
    85.903     0.758     0.200
    85.932     2.266     0.200
    86.569     2.414     0.200
    86.647    -0.832     0.200
    86.889     0.709     0.200
    87.000     1.255     0.200
    87.036     0.514     0.200
    87.059    -0.579     0.200
    87.145     1.051     0.200
    87.267     0.475     0.200
    87.376     0.814     0.200
    87.640     1.502     0.200
    87.781     1.466     0.200
    87.979     1.497     0.200
    88.044    -0.919     0.200
    88.047     1.456     0.200
    88.144    -0.906     0.200
    89.021     0.763     0.200
    89.225    -0.882     0.200
    89.532     0.911     0.200
    89.918     1.007     0.200
    89.918     1.328     0.200
    90.096     0.385     0.200
    90.548    -0.335     0.200
    90.548    -0.740     0.200
    90.564     1.837     0.200
    90.710    -0.465     0.200
    90.932     1.205     0.200
    91.068     0.284     0.200
    91.482     1.134     0.200
    92.239     0.527     0.200
    92.237     0.724     0.200
    92.373     0.873     0.200
    92.373     0.834     0.200
    92.373    -0.035     0.200
    92.554     1.247     0.200
    92.944     0.231     0.200
    93.002     0.902     0.200
    93.086     0.847     0.200
    93.128     0.471     0.200
    93.216     0.606     0.200
    93.754     0.790     0.200
    93.975     1.014     0.200
    94.089     0.601     0.200
    94.565     1.528     0.200
    94.607     1.303     0.200
    94.623     1.541     0.200
    94.623     1.342     0.200
    95.363     1.670     0.200
    95.407     1.108     0.200
    95.742     1.203     0.200
    96.019     0.936     0.200
    96.096     0.911     0.200
    96.318     1.652     0.200
    96.378     0.421     0.200
    96.615     0.224     0.200
    96.815     1.090     0.200
    99.198    -1.277     0.200
    13.903     6.534     0.200
    15.622     2.667     0.200
    15.622     2.390     0.200
    15.622     3.230     0.200
    16.833     3.087     0.200
    16.833     4.708     0.200
    17.733     2.109     0.200
    17.973     1.517     0.200
    18.056    -0.771     0.200
    18.129     0.285     0.200
    18.129    -0.734     0.200
    18.227    -0.631     0.200
    18.270    -1.455     0.200
    18.312    -0.678     0.200
    18.403    -1.599     0.200
    18.519    -0.846     0.200
    18.638    -1.121     0.200
    18.800    -0.419     0.200
    18.850    -0.423     0.200
    19.106    -0.275     0.200
    19.108     0.154     0.200
    19.321    -0.668     0.200
    19.510    -1.252     0.200
    19.764    -0.249     0.200
    19.868    -0.272     0.200
    20.554     0.458     0.200
    20.575     0.848     0.200
    21.003    -0.950     0.200
    21.152    -1.333     0.200
    21.326    -0.952     0.200
    22.069    -0.278     0.200
    22.104    -0.687     0.200
    22.104    -1.109     0.200
    22.143     1.247     0.200
    22.137    -2.107     0.200
    22.137    -1.799     0.200
    22.137    -1.010     0.200
    22.713     1.991     0.200
    22.659    -1.285     0.200
    22.742     1.174     0.200
    22.759    -1.698     0.200
    22.952    -1.546     0.200
    23.092    -1.234     0.200
    23.166    -1.250     0.200
    23.398     1.587     0.200
    23.539    -1.601     0.200
    23.632    -0.890     0.200
    24.098     2.949     0.200
    24.110     1.095     0.200
    24.110     1.872     0.200
    23.784     3.878     0.200
    23.784     3.136     0.200
    24.143    -1.582     0.200
    24.256    -0.834     0.200
    24.419     0.068     0.200
    24.505     1.800     0.200
    24.525    -1.276     0.200
    24.525    -1.475     0.200
    24.525    -0.846     0.200
    24.837     0.751     0.200
    24.861    -1.615     0.200
    24.861    -1.834     0.200
    24.991     2.220     0.200
    24.991     0.067     0.200
    24.991     0.239     0.200
    25.817    -1.427     0.200
    25.847     0.081     0.200
    25.847    -0.958     0.200
    25.847     1.652     0.200
    25.973     0.850     0.200
    26.305    -1.913     0.200
    26.955     1.043     0.200
    27.843    -1.330     0.200
    28.257    -1.385     0.200
    30.174     0.726     0.200
    30.409    -0.530     0.200
    30.409    -0.800     0.200
    30.884    -0.726     0.200
    30.884    -2.023     0.200
    30.943    -1.556     0.200
    32.312    -1.501     0.200
    32.312    -1.732     0.200
    32.415    -1.739     0.200
    32.660     1.569     0.200
    32.660     0.479     0.200
    32.965    -1.716     0.200
    32.975    -1.371     0.200
    32.975    -1.621     0.200
    34.838     0.717     0.200
    34.838    -0.775     0.200
    35.091    -1.070     0.200
    36.312    -0.825     0.200
    36.312    -1.067     0.200
    36.312     0.085     0.200
    41.714    -1.684     0.200
    42.211    -1.624     0.200
    43.586    -1.727     0.200
    44.851    -1.096     0.200
    44.851    -0.979     0.200
    44.851    -0.069     0.200
    45.603    -1.129     0.200
    45.603    -0.828     0.200
    45.603    -1.321     0.200
    45.681     0.220     0.200
    46.166    -1.578     0.200
    47.081    -1.400     0.200
    48.522     2.100     0.200
    51.012     0.165     0.200
    52.037     0.535     0.200
    53.537    -0.267     0.200
    53.537     0.264     0.200
    53.613     1.282     0.200
    53.900    -0.159     0.200
    53.936     0.568     0.200
    54.855     2.373     0.200
    54.867     0.984     0.200
    54.867     0.484     0.200
    54.867     0.164     0.200
    55.103     0.292     0.200
    55.733     0.383     0.200
    56.213     0.370     0.200
    56.518    -1.699     0.200
    57.940    -0.816     0.200
    58.008     0.223     0.200
    60.291    -0.067     0.200
    61.368    -0.647     0.200
    62.680     1.246     0.200
    65.040    -1.487     0.200
    65.816    -0.125     0.200
    70.475    -0.940     0.200
    70.938    -1.246     0.200
    71.407    -0.431     0.200
    77.844     0.077     0.200
    78.922     3.228     0.200
    80.485     0.106     0.200
    81.021     1.963     0.200
    81.035     2.389     0.200
    81.035     1.342     0.200
    81.596     1.575     0.200
    81.660     1.398     0.200
    81.787     1.210     0.200
    81.908     1.075     0.200
    82.040     1.306     0.200
    82.149     1.009     0.200
    82.174     1.682     0.200
    82.216     1.459     0.200
    82.256     0.928     0.200
    82.256     1.159     0.200
    82.263     1.661     0.200
    81.615     5.157     0.200
    82.412     1.307     0.200
    82.466     1.364     0.200
    82.473     1.292     0.200
    82.516     1.495     0.200
    82.660     1.127     0.200
    82.682     0.763     0.200
    82.682     1.013     0.200
    82.715     1.761     0.200
    82.727     1.287     0.200
    83.028     1.231     0.200
    83.028     1.649     0.200
    83.304     1.285     0.200
    84.856     1.721     0.200
    85.093     1.179     0.200
    85.093     0.061     0.200
    85.090     0.347     0.200
    85.090    -0.114     0.200
    85.138     0.258     0.200
    85.394     2.101     0.200
    85.398     1.938     0.200
    86.266     2.251     0.200
    86.654     0.328     0.200
    87.535     0.545     0.200
    87.711     1.274     0.200
    87.728     1.061     0.200
    88.207     0.751     0.200
    89.133     0.710     0.200
    89.788     0.415     0.200
    90.711     0.661     0.200
    90.711    -0.367     0.200
    91.744     0.982     0.200
    91.744     0.623     0.200
    92.619     0.632     0.200
    92.619    -0.739     0.200
    94.853     0.790     0.200
    95.206     2.384     0.200
    95.473     0.699     0.200
    96.556     1.984     0.200
    24.752    -1.113     0.200
    44.578    -2.085     0.200
    25.176    -1.785     0.200
    24.046     1.797     0.200
    25.045     1.764     0.200
    44.929     0.631     0.200
    54.859     1.042     0.200
    85.430     2.033     0.200
    14.152     5.998     0.200
    14.226     6.405     0.200
    14.236     8.755     0.200
    14.466     5.856     0.200
    15.915     3.033     0.200
    16.833     3.409     0.200
    17.920     1.786     0.200
    18.345    -0.541     0.200
    19.224     1.054     0.200
    19.303     1.305     0.200
    19.405     1.931     0.200
    19.489     0.993     0.200
    19.423     0.841     0.200
    19.423     2.048     0.200
    19.482    -1.792     0.200
    19.533    -0.388     0.200
    19.484     0.100     0.200
    19.540     1.689     0.200
    19.636     1.715     0.200
    19.701    -0.949     0.200
    20.082     1.128     0.200
    20.149    -0.431     0.200
    20.164    -0.611     0.200
    20.204    -1.104     0.200
    20.229    -0.730     0.200
    20.256     2.510     0.200
    20.215     3.169     0.200
    20.291     0.647     0.200
    20.291     0.268     0.200
    20.311     0.936     0.200
    20.393     2.424     0.200
    20.448    -1.873     0.200
    20.368     0.080     0.200
    20.510    -0.983     0.200
    20.488     2.456     0.200
    20.494     1.802     0.200
    20.467     2.258     0.200
    20.504     2.024     0.200
    20.434     1.875     0.200
    20.530     2.227     0.200
    20.552     0.099     0.200
    20.598     2.553     0.200
    20.592    -0.725     0.200
    20.608     0.483     0.200
    20.691    -1.775     0.200
    20.655    -1.013     0.200
    20.666     0.048     0.200
    20.643     0.770     0.200
    20.672     1.357     0.200
    20.685     1.345     0.200
    20.919     1.291     0.200
    21.011    -0.596     0.200
    21.128    -1.919     0.200
    21.143     1.940     0.200
    21.146     3.903     0.200
    21.245     0.983     0.200
    21.340     3.935     0.200
    21.418    -1.795     0.200
    21.387     0.834     0.200
    21.312     2.495     0.200
    21.330     1.416     0.200
    21.415     2.426     0.200
    21.374     2.288     0.200
    21.407     1.696     0.200
    21.497     4.948     0.200
    21.532    -0.210     0.200
    21.532     1.578     0.200
    21.613    -1.697     0.200
    21.605    -0.820     0.200
    21.613    -0.057     0.200
    21.613     1.708     0.200
    21.706     3.765     0.200
    21.706     1.719     0.200
    21.774     1.689     0.200
    21.972    -1.108     0.200
    21.889     3.330     0.200
    21.955     1.222     0.200
    21.969     4.848     0.200
    21.979     5.504     0.200
    21.999     3.589     0.200
    21.985     1.201     0.200
    22.117    -1.519     0.200
    22.085     2.761     0.200
    22.085     3.639     0.200
    22.085     3.468     0.200
    22.165     1.916     0.200
    22.176     0.855     0.200
    22.280    -0.559     0.200
    22.280    -0.738     0.200
    22.280    -1.664     0.200
    22.280    -0.309     0.200
    22.259     0.771     0.200
    22.259     2.212     0.200
    22.198     6.459     0.200
    22.208     4.272     0.200
    22.318    -0.852     0.200
    22.318    -1.703     0.200
    22.306     6.492     0.200
    22.395    -1.935     0.200
    22.395    -2.114     0.200
    22.395    -1.532     0.200
    22.459     5.758     0.200
    22.403     2.166     0.200
    22.502     4.767     0.200
    22.502     6.156     0.200
    22.530     3.780     0.200
    22.550     6.130     0.200
    22.667    -0.918     0.200
    22.647     0.241     0.200
    22.820    -0.585     0.200
    22.894    -1.366     0.200
    22.844     4.917     0.200
    22.755     4.190     0.200
    22.897     1.305     0.200
    23.059    -2.108     0.200
    22.990     1.342     0.200
    23.099     6.541     0.200
    23.095     0.809     0.200
    23.338     1.816     0.200
    23.338     0.534     0.200
    23.377     5.970     0.200
    23.415     1.722     0.200
    23.443     1.632     0.200
    23.557     0.712     0.200
    23.631     5.515     0.200
    23.703     6.495     0.200
    23.801     4.992     0.200
    23.839     1.996     0.200
    23.839     2.140     0.200
    23.845     4.949     0.200
    23.913     4.730     0.200
    23.928     4.250     0.200
    23.910     1.192     0.200
    23.965     2.294     0.200
    23.978     2.498     0.200
    23.978     0.744     0.200
    23.985     2.311     0.200
    24.156     4.349     0.200
    24.105     6.013     0.200
    24.300     1.934     0.200
    24.319    -1.589     0.200
    24.311     2.831     0.200
    24.304     1.540     0.200
    24.362     2.777     0.200
    24.421     1.472     0.200
    24.421     1.882     0.200
    24.421     1.132     0.200
    24.156     3.696     0.200
    24.448     4.996     0.200
    24.552    -1.702     0.200
    24.541     4.864     0.200
    24.596     3.796     0.200
    24.638     3.935     0.200
    24.667     2.387     0.200
    24.778    -1.169     0.200
    24.778    -1.540     0.200
    24.778    -1.317     0.200
    24.833    -0.815     0.200
    24.819     1.848     0.200
    24.849     1.338     0.200
    24.812     2.072     0.200
    24.837     6.363     0.200
    24.871     4.976     0.200
    24.865     3.578     0.200
    24.930     4.443     0.200
    24.977     0.872     0.200
    24.980     0.194     0.200
    24.980     0.944     0.200
    25.008     4.830     0.200
    25.143    -1.614     0.200
    25.120     1.739     0.200
    25.113     2.891     0.200
    25.183     2.288     0.200
    25.291     0.764     0.200
    25.405    -0.176     0.200
    25.405     1.785     0.200
    25.454     1.539     0.200
    25.740     0.445     0.200
    25.762     0.406     0.200
    25.762    -0.516     0.200
    25.762     1.343     0.200
    25.888     1.900     0.200
    25.883     1.167     0.200
    25.988     1.502     0.200
    25.937     2.503     0.200
    25.977    -1.716     0.200
    26.080     1.259     0.200
    26.358     2.553     0.200
    26.405     0.340     0.200
    26.443     1.842     0.200
    26.669     0.715     0.200
    26.908     1.691     0.200
    26.796     1.518     0.200
    26.861     1.884     0.200
    26.899     1.204     0.200
    27.025    -1.580     0.200
    27.006     1.103     0.200
    27.072     1.477     0.200
    27.317    -1.450     0.200
    27.308     1.206     0.200
    27.454     1.743     0.200
    27.393     1.253     0.200
    27.651     0.260     0.200
    27.731     2.708     0.200
    27.917     3.346     0.200
    27.908     4.700     0.200
    27.994    -0.685     0.200
    27.936    -0.230     0.200
    28.074    -0.280     0.200
    28.095     0.844     0.200
    28.427    -0.148     0.200
    28.447     2.624     0.200
    28.620     4.180     0.200
    28.776    -2.036     0.200
    28.686     4.597     0.200
    28.924     2.380     0.200
    28.924     3.899     0.200
    29.055     5.115     0.200
    29.351    -1.850     0.200
    29.324     3.129     0.200
    29.312     3.339     0.200
    29.588     3.209     0.200
    29.588     4.996     0.200
    29.632    -0.759     0.200
    29.790    -3.087     0.200
    29.918     3.163     0.200
    30.033     2.253     0.200
    30.172     3.723     0.200
    30.228     1.227     0.200
    30.197     2.799     0.200
    30.178     1.280     0.200
    30.345     1.403     0.200
    30.345    -0.207     0.200
    30.345     0.164     0.200
    30.261     3.537     0.200
    30.341     3.421     0.200
    30.340     2.082     0.200
    30.389     1.501     0.200
    30.455     1.824     0.200
    30.531    -1.123     0.200
    30.504     3.385     0.200
    30.750    -1.383     0.200
    30.904    -2.748     0.200
    30.871     1.269     0.200
    30.859     1.753     0.200
    30.867     2.882     0.200
    30.904     2.452     0.200
    30.932     3.062     0.200
    31.014     1.286     0.200
    31.164    -1.626     0.200
    31.164    -2.286     0.200
    31.124     2.114     0.200
    31.105     1.458     0.200
    31.132     1.857     0.200
    31.132    -0.003     0.200
    31.172     2.096     0.200
    31.254     3.522     0.200
    31.254     4.369     0.200
    31.229     0.091     0.200
    31.259     0.828     0.200
    31.358     3.657     0.200
    31.368     4.071     0.200
    31.389     0.902     0.200
    31.450    -1.472     0.200
    31.523     2.299     0.200
    31.574     1.853     0.200
    31.581     1.143     0.200
    31.635     3.313     0.200
    31.663     2.168     0.200
    31.647     0.750     0.200
    31.892     0.445     0.200
    31.961     2.517     0.200
    31.961     1.298     0.200
    31.961     0.677     0.200
    31.982     2.567     0.200
    32.080    -2.065     0.200
    32.161     3.492     0.200
    32.264     0.875     0.200
    32.429    -0.955     0.200
    32.697    -1.277     0.200
    32.848     3.173     0.200
    32.937     1.406     0.200
    33.005     0.951     0.200
    33.005     0.272     0.200
    33.005     2.498     0.200
    32.995     0.189     0.200
    33.251    -1.317     0.200
    33.256     3.514     0.200
    33.498     2.101     0.200
    33.826    -2.949     0.200
    33.833    -2.214     0.200
    33.847     2.267     0.200
    33.993    -2.235     0.200
    34.258     0.924     0.200
    34.265     1.763     0.200
    34.615    -1.172     0.200
    34.814    -1.500     0.200
    34.950    -1.813     0.200
    34.987    -1.456     0.200
    35.294    -1.290     0.200
    35.505     1.129     0.200
    35.490     0.711     0.200
    35.776    -0.565     0.200
    35.971    -1.148     0.200
    36.122    -1.195     0.200
    36.122    -1.875     0.200
    36.381    -0.939     0.200
    36.381    -0.568     0.200
    37.353     0.621     0.200
    37.552    -1.587     0.200
    37.875     1.110     0.200
    38.017     1.289     0.200
    38.123     0.034     0.200
    38.281     0.404     0.200
    38.388    -1.190     0.200
    39.765    -1.447     0.200
    39.791     0.554     0.200
    39.717     1.907     0.200
    39.717     2.446     0.200
    39.717     1.258     0.200
    39.840     1.031     0.200
    39.803     0.872     0.200
    40.119    -0.170     0.200
    40.388     1.087     0.200
    40.540     0.872     0.200
    40.577     0.094     0.200
    40.817     6.158     0.200
    41.584     1.025     0.200
    42.000    -2.403     0.200
    42.219    -2.800     0.200
    42.471    -1.721     0.200
    43.483     0.779     0.200
    43.880    -2.597     0.200
    43.889     0.932     0.200
    44.798     1.332     0.200
    44.865    -1.144     0.200
    44.865     0.481     0.200
    45.491     0.933     0.200
    45.314     5.778     0.200
    45.528     3.214     0.200
    45.834    -2.096     0.200
    45.834    -1.198     0.200
    45.574     3.750     0.200
    46.467     1.191     0.200
    47.940     1.615     0.200
    48.748     1.573     0.200
    48.748     2.604     0.200
    48.748     1.932     0.200
    48.748     0.338     0.200
    48.952     3.220     0.200
    48.994     2.970     0.200
    49.059     4.059     0.200
    49.241     2.719     0.200
    49.283     3.783     0.200
    49.353     3.595     0.200
    49.402     4.694     0.200
    49.669     1.998     0.200
    49.750     1.810     0.200
    49.753     2.214     0.200
    49.826     4.573     0.200
    50.207     1.545     0.200
    50.428     1.000     0.200
    50.402     3.069     0.200
    50.452     1.091     0.200
    50.405     4.296     0.200
    50.604     0.915     0.200
    50.669     1.309     0.200
    50.769     2.040     0.200
    50.852     1.650     0.200
    51.157     2.228     0.200
    51.211     1.723     0.200
    51.529     1.639     0.200
    51.386     3.887     0.200
    51.652     1.529     0.200
    51.785     2.155     0.200
    51.875     1.079     0.200
    51.960     0.209     0.200
    51.956     1.479     0.200
    51.918     2.587     0.200
    51.963     0.712     0.200
    52.223     0.391     0.200
    52.286     1.814     0.200
    52.493     1.631     0.200
    52.602     0.365     0.200
    52.602    -0.018     0.200
    52.763    -1.860     0.200
    52.748     1.380     0.200
    52.821     1.898     0.200
    52.911     0.999     0.200
    52.888     4.962     0.200
    53.240     1.832     0.200
    53.307     2.234     0.200
    53.332     5.675     0.200
    53.454     1.297     0.200
    53.431     0.920     0.200
    53.512     0.399     0.200
    53.450     2.366     0.200
    53.502     1.374     0.200
    53.481     1.880     0.200
    53.481     1.177     0.200
    53.481     0.825     0.200
    53.481     0.356     0.200
    53.750     1.225     0.200
    53.805     0.805     0.200
    54.217     3.721     0.200
    54.389     2.902     0.200
    54.708     0.604     0.200
    54.780     1.086     0.200
    54.792     0.599     0.200
    54.792     0.263     0.200
    54.921     1.260     0.200
    55.071    -0.967     0.200
    55.071    -0.232     0.200
    55.071    -0.740     0.200
    55.186     0.650     0.200
    55.186     0.259     0.200
    55.186     0.501     0.200
    55.186    -0.381     0.200
    55.384     2.235     0.200
    55.486     5.909     0.200
    55.724    -0.669     0.200
    55.731     3.458     0.200
    56.436     2.459     0.200
    56.446     3.308     0.200
    56.785     0.635     0.200
    56.789     4.892     0.200
    56.803     5.232     0.200
    57.365     2.083     0.200
    57.433     1.781     0.200
    57.587     2.081     0.200
    57.860     0.722     0.200
    57.860     0.550     0.200
    57.860    -0.004     0.200
    58.035    -0.529     0.200
    58.035     1.994     0.200
    58.035     0.901     0.200
    58.035     0.510     0.200
    58.020     1.728     0.200
    58.020     1.603     0.200
    58.133     4.715     0.200
    58.144     2.697     0.200
    58.150     2.625     0.200
    58.327     4.647     0.200
    58.681     3.470     0.200
    58.906     1.905     0.200
    59.106    -0.968     0.200
    59.106    -0.296     0.200
    59.106     1.055     0.200
    58.966     2.141     0.200
    59.322     0.363     0.200
    59.456     0.432     0.200
    59.456     0.706     0.200
    59.504     4.231     0.200
    59.575     3.747     0.200
    59.616     2.170     0.200
    59.627     2.129     0.200
    59.627     1.629     0.200
    59.772    -0.364     0.200
    59.865     1.765     0.200
    60.034    -0.896     0.200
    59.916     1.915     0.200
    59.937     1.253     0.200
    60.170     1.294     0.200
    60.174     1.785     0.200
    60.212     2.176     0.200
    60.226     0.623     0.200
    60.439     1.702     0.200
    60.348     3.919     0.200
    60.480     0.230     0.200
    60.480     0.535     0.200
    60.442    -0.492     0.200
    60.514     2.492     0.200
    60.759     3.399     0.200
    60.785     1.471     0.200
    60.892     0.598     0.200
    60.997     1.777     0.200
    61.195     0.024     0.200
    61.195     1.399     0.200
    61.195     0.141     0.200
    61.150     2.417     0.200
    61.150     2.120     0.200
    61.307     0.537     0.200
    61.509    -0.390     0.200
    61.715     1.331     0.200
    61.641     1.995     0.200
    61.663     5.682     0.200
    61.757     0.438     0.200
    61.743     0.608     0.200
    61.825     0.870     0.200
    61.914     0.762     0.200
    62.150     1.757     0.200
    62.398     3.978     0.200
    62.464     0.514     0.200
    62.447     1.770     0.200
    62.447     3.653     0.200
    62.903     0.630     0.200
    62.903     0.349     0.200
    62.903     1.630     0.200
    62.900     3.218     0.200
    63.474     0.051     0.200
    63.549     4.094     0.200
    64.004     2.349     0.200
    64.074     1.309     0.200
    64.101    -0.766     0.200
    64.184     0.697     0.200
    64.184     1.509     0.200
    64.184     0.025     0.200
    64.246     0.839     0.200
    64.518     0.393     0.200
    64.518     0.268     0.200
    64.909     2.804     0.200
    64.956     2.503     0.200
    64.925     2.028     0.200
    64.925     1.122     0.200
    65.014     0.568     0.200
    65.014     1.169     0.200
    65.014     0.091     0.200
    65.138    -0.058     0.200
    65.138     0.660     0.200
    65.138     1.793     0.200
    65.138     1.035     0.200
    65.210    -1.097     0.200
    65.531     1.419     0.200
    65.531     0.513     0.200
    65.491     2.165     0.200
    65.629     1.622     0.200
    65.678     1.788     0.200
    65.678    -0.118     0.200
    65.678     1.366     0.200
    65.821     2.453     0.200
    65.821     1.226     0.200
    65.819     1.356     0.200
    66.201    -2.102     0.200
    66.120     1.620     0.200
    66.120     1.722     0.200
    66.120     1.878     0.200
    66.360     2.159     0.200
    66.360     0.635     0.200
    66.746     1.218     0.200
    66.746     1.116     0.200
    66.784     2.492     0.200
    66.784     2.594     0.200
    66.784     0.336     0.200
    66.735     2.115     0.200
    67.075     1.735     0.200
    67.075     0.477     0.200
    67.109     0.888     0.200
    67.109     1.200     0.200
    67.109     0.560     0.200
    67.263     0.364     0.200
    67.665     2.594     0.200
    67.665     2.962     0.200
    67.779     1.477     0.200
    67.748     1.366     0.200
    67.861     1.601     0.200
    68.125     1.215     0.200
    68.125     1.379     0.200
    68.125     0.676     0.200
    68.130    -1.869     0.200
    68.523     2.205     0.200
    68.616     1.006     0.200
    68.607     1.224     0.200
    68.611     1.658     0.200
    68.560    -1.006     0.200
    68.863     0.976     0.200
    68.863     1.547     0.200
    68.919     1.015     0.200
    68.919     1.929     0.200
    69.036     0.403     0.200
    69.054     1.765     0.200
    69.054     2.382     0.200
    69.247     1.092     0.200
    69.247     2.060     0.200
    69.329     2.283     0.200
    69.329     0.533     0.200
    69.329     0.392     0.200
    69.498     1.493     0.200
    69.574     3.907     0.200
    69.574     2.415     0.200
    69.845     1.956     0.200
    69.845     2.846     0.200
    69.998     0.616     0.200
    70.185     2.029     0.200
    70.185     1.201     0.200
    70.185     1.021     0.200
    70.209     1.466     0.200
    70.209     1.864     0.200
    70.578     0.583     0.200
    70.835     1.302     0.200
    71.125     1.606     0.200
    71.125     1.309     0.200
    71.192     0.786     0.200
    71.192     2.310     0.200
    71.192     1.240     0.200
    71.243     0.674     0.200
    71.368     1.883     0.200
    71.368     2.070     0.200
    71.411     1.928     0.200
    71.411     0.921     0.200
    71.526     0.074     0.200
    72.264     3.645     0.200
    72.264     2.825     0.200
    72.460     1.597     0.200
    72.460     0.886     0.200
    73.307     1.457     0.200
    73.327    -0.044     0.200
    73.307     1.043     0.200
    74.339     2.592     0.200
    74.418     3.311     0.200
    74.373     2.755     0.200
    74.373     1.981     0.200
    74.673     0.863     0.200
    74.734     3.835     0.200
    75.812     1.708     0.200
    75.981     2.016     0.200
    76.831     1.223     0.200
    76.831     0.645     0.200
    76.831    -0.285     0.200
    76.831     0.457     0.200
    76.671     2.153     0.200
    77.099     0.698     0.200
    77.099     2.175     0.200
    77.354     3.712     0.200
    77.390     5.115     0.200
    77.174     1.142     0.200
    77.639     0.321     0.200
    77.639     2.892     0.200
    77.744     2.057     0.200
    77.796     1.057     0.200
    77.973     0.711     0.200
    77.973     1.242     0.200
    77.973    -0.532     0.200
    78.435     0.518     0.200
    78.435     0.174     0.200
    78.435     1.042     0.200
    78.449     1.188     0.200
    78.818     0.769     0.200
    78.646     5.084     0.200
    79.207     0.474     0.200
    79.207     0.669     0.200
    79.259     0.708     0.200
    79.372     1.081     0.200
    79.378     0.337     0.200
    79.378     0.094     0.200
    79.577     0.670     0.200
    79.577     1.092     0.200
    79.577     0.014     0.200
    79.577     0.459     0.200
    79.591     0.079     0.200
    79.591     0.345     0.200
    79.591    -0.155     0.200
    79.649     0.784     0.200
    79.649     1.690     0.200
    79.845    -0.022     0.200
    80.042     0.523     0.200
    80.044     0.863     0.200
    80.180     0.858     0.200
    80.230     0.585     0.200
    80.045     2.033     0.200
    80.045     1.689     0.200
    80.045     2.580     0.200
    80.306     0.670     0.200
    80.314     0.137     0.200
    80.239     1.680     0.200
    80.341     2.083     0.200
    80.341     0.926     0.200
    80.499     1.006     0.200
    80.543     0.139     0.200
    80.555     1.002     0.200
    80.593     0.525     0.200
    80.607     0.521     0.200
    80.700     0.026     0.200
    80.726     0.830     0.200
    80.726    -0.990     0.200
    80.726     1.119     0.200
    80.726     0.127     0.200
    80.746     0.514     0.200
    80.746    -0.931     0.200
    80.810     1.008     0.200
    80.850     0.936     0.200
    80.569     4.115     0.200
    80.910     0.380     0.200
    80.850     1.959     0.200
    81.014     0.791     0.200
    81.014     1.165     0.200
    81.014     0.798     0.200
    80.864     1.180     0.200
    80.864     1.680     0.200
    80.864     1.509     0.200
    81.081     2.255     0.200
    81.162     0.662     0.200
    81.162     0.982     0.200
    81.258     0.962     0.200
    81.362     0.905     0.200
    81.388     0.527     0.200
    81.500     0.940     0.200
    81.510     0.940     0.200
    81.566     0.074     0.200
    81.592     0.836     0.200
    81.593     1.020     0.200
    81.721     0.678     0.200
    81.721     1.404     0.200
    81.726     0.674     0.200
    81.728     1.166     0.200
    81.769     0.950     0.200
    81.813     1.210     0.200
    81.816     0.700     0.200
    81.840     1.317     0.200
    81.874     0.961     0.200
    81.890     1.281     0.200
    81.890     1.523     0.200
    81.922     2.073     0.200
    81.920     0.647     0.200
    81.984     1.560     0.200
    82.002     1.405     0.200
    82.011     0.909     0.200
    82.043     0.974     0.200
    82.085     1.007     0.200
    82.106     1.801     0.200
    82.178     1.574     0.200
    82.178     1.254     0.200
    82.192     1.299     0.200
    82.229     1.164     0.200
    82.293     0.157     0.200
    82.343     1.116     0.200
    82.219     1.625     0.200
    82.219     2.219     0.200
    82.219     1.133     0.200
    82.358     0.959     0.200
    82.365     1.128     0.200
    82.447     1.221     0.200
    82.454     1.558     0.200
    82.476     1.017     0.200
    82.481     1.137     0.200
    82.503     0.997     0.200
    82.518     0.452     0.200
    82.552     1.273     0.200
    82.554     1.294     0.200
    82.578     1.145     0.200
    82.596     1.709     0.200
    82.596     1.491     0.200
    82.596     0.319     0.200
    82.603     1.230     0.200
    82.604     0.736     0.200
    82.637     1.298     0.200
    82.644     1.188     0.200
    82.679     1.434     0.200
    82.679     1.544     0.200
    81.943     5.089     0.200
    82.719     1.256     0.200
    82.729     1.065     0.200
    82.784     1.512     0.200
    82.794     1.428     0.200
    82.794     0.459     0.200
    82.794     1.053     0.200
    82.796     1.199     0.200
    82.846     1.501     0.200
    82.846     1.392     0.200
    82.967     0.791     0.200
    82.985     1.223     0.200
    82.987     0.216     0.200
    83.008     1.193     0.200
    83.046     0.999     0.200
    83.046     1.789     0.200
    83.057     1.724     0.200
    83.085     1.182     0.200
    83.092     0.848     0.200
    83.098     1.404     0.200
    83.136     1.204     0.200
    83.193     0.863     0.200
    83.245     1.812     0.200
    83.245     2.258     0.200
    83.243     0.652     0.200
    83.311     0.597     0.200
    83.359     1.696     0.200
    83.359     1.985     0.200
    83.364     1.496     0.200
    83.362     0.921     0.200
    83.396     0.746     0.200
    83.472     0.647     0.200
    83.496     0.521     0.200
    83.510     0.455     0.200
    83.547     0.845     0.200
    83.567     0.165     0.200
    83.633     0.954     0.200
    83.660     0.265     0.200
    83.623    -0.365     0.200
    83.746     0.960     0.200
    83.800     1.565     0.200
    83.859     0.722     0.200
    83.880     1.204     0.200
    84.016     1.390     0.200
    84.035     0.747     0.200
    83.847     6.604     0.200
    83.855     5.852     0.200
    83.865     5.573     0.200
    84.189     0.900     0.200
    84.201     1.772     0.200
    84.201     0.186     0.200
    84.271     1.210     0.200
    84.283     1.151     0.200
    84.284     0.581     0.200
    84.632     1.342     0.200
    84.803     1.171     0.200
    84.803     2.390     0.200
    84.849     0.689     0.200
    84.868     0.866     0.200
    84.868     1.921     0.200
    84.868     0.335     0.200
    84.875     1.884     0.200
    84.939     1.566     0.200
    84.986    -0.002     0.200
    85.178     1.702     0.200
    85.178     0.366     0.200
    85.178     1.257     0.200
    85.244     0.131     0.200
    85.245     1.055     0.200
    85.252     0.692     0.200
    85.252    -0.737     0.200
    85.252    -0.011     0.200
    85.252    -0.597     0.200
    85.336     1.210     0.200
    85.336    -0.477     0.200
    85.336     0.273     0.200
    85.336     0.015     0.200
    85.357     1.063     0.200
    85.357     0.766     0.200
    85.357     0.540     0.200
    85.415     0.204     0.200
    85.415     1.379     0.200
    85.415     0.090     0.200
    85.427     0.511     0.200
    85.429     1.096     0.200
    85.464     0.929     0.200
    85.471     1.652     0.200
    85.488     1.202     0.200
    85.488    -0.368     0.200
    85.488    -0.837     0.200
    85.496     0.343     0.200
    85.234     4.795     0.200
    85.234     6.272     0.200
    85.234     2.928     0.200
    85.234     3.881     0.200
    85.564     1.282     0.200
    85.607     0.421     0.200
    85.624     1.158     0.200
    85.648    -0.362     0.200
    85.717     1.891     0.200
    85.741     2.124     0.200
    86.054     2.330     0.200
    86.345     1.231     0.200
    86.503     0.527     0.200
    86.542     1.821     0.200
    86.606     2.273     0.200
    86.640     0.463     0.200
    86.664     0.884     0.200
    86.718     0.620     0.200
    86.725     0.852     0.200
    86.816     0.673     0.200
    86.879     3.297     0.200
    86.875    -0.034     0.200
    87.074     0.455     0.200
    87.079     1.626     0.200
    87.079     0.455     0.200
    87.086     0.621     0.200
    87.114     1.112     0.200
    87.115     1.055     0.200
    87.126     2.413     0.200
    87.235     0.510     0.200
    87.246     1.665     0.200
    87.371    -0.625     0.200
    87.417     0.648     0.200
    87.417     0.515     0.200
    87.508     1.035     0.200
    87.556     0.874     0.200
    87.579    -0.221     0.200
    87.629     1.275     0.200
    87.673     1.780     0.200
    87.667     0.857     0.200
    87.667     0.490     0.200
    87.676     0.602     0.200
    87.823     0.327     0.200
    87.878     0.359     0.200
    87.878     0.844     0.200
    88.007     0.473     0.200
    88.007     0.247     0.200
    88.018    -0.647     0.200
    88.053     1.233     0.200
    88.169     0.955     0.200
    88.169     0.400     0.200
    88.169     0.806     0.200
    88.308     0.667     0.200
    88.323     0.328     0.200
    88.373     0.351     0.200
    88.370    -1.059     0.200
    88.459     0.529     0.200
    88.459     0.256     0.200
    88.634     1.221     0.200
    88.650     0.833     0.200
    88.672     1.322     0.200
    88.691     0.592     0.200
    88.755     0.461     0.200
    88.739    -0.768     0.200
    88.745     0.160     0.200
    88.745    -0.262     0.200
    88.900    -0.846     0.200
    89.004     3.019     0.200
    89.061     0.971     0.200
    89.091    -0.015     0.200
    89.091     0.110     0.200
    89.166     0.875     0.200
    89.185     0.771     0.200
    89.234     0.878     0.200
    89.234     0.558     0.200
    89.413     0.281     0.200
    89.444     0.948     0.200
    89.444     0.627     0.200
    89.444     0.229     0.200
    89.439     0.977     0.200
    89.480     1.163     0.200
    89.520     0.671     0.200
    89.520     1.069     0.200
    89.538     0.286     0.200
    89.538     0.903     0.200
    89.603     0.814     0.200
    89.603     1.369     0.200
    89.628     0.359     0.200
    89.665     0.532     0.200
    89.665     0.095     0.200
    89.739     0.066     0.200
    89.739    -0.153     0.200
    89.708     1.211     0.200
    89.708     0.945     0.200
    89.708     0.344     0.200
    89.708     1.414     0.200
    89.831     0.342     0.200
    89.876     1.332     0.200
    89.896     2.534     0.200
    89.801     0.388     0.200
    89.994     1.056     0.200
    90.023     6.648     0.200
    90.054    -0.007     0.200
    90.054    -1.100     0.200
    90.054     0.603     0.200
    90.054     0.220     0.200
    90.081     0.658     0.200
    90.102     0.552     0.200
    90.138     0.978     0.200
    90.264     4.126     0.200
    90.275     1.196     0.200
    90.141     2.392     0.200
    90.291     0.748     0.200
    90.343     0.466     0.200
    90.351     0.467     0.200
    90.372     1.440     0.200
    90.416     5.018     0.200
    90.416     0.165     0.200
    90.550     1.223     0.200
    90.596     0.250     0.200
    90.596     0.789     0.200
    90.729    -0.261     0.200
    90.796     0.765     0.200
    90.848     1.010     0.200
    90.904     0.046     0.200
    90.906    -1.428     0.200
    90.906    -0.169     0.200
    90.908     0.524     0.200
    90.995    -0.205     0.200
    90.995     0.326     0.200
    91.041     3.909     0.200
    91.058     1.322     0.200
    91.058     0.799     0.200
    91.058     1.175     0.200
    91.058     0.534     0.200
    91.077     1.310     0.200
    91.154     1.305     0.200
    91.171     2.601     0.200
    91.179     0.730     0.200
    91.174     0.415     0.200
    91.205     0.247     0.200
    91.205     0.349     0.200
    91.205     0.115     0.200
    91.291     0.614     0.200
    91.248     2.329     0.200
    91.258     4.192     0.200
    91.270     2.924     0.200
    91.361     1.070     0.200
    91.377     0.748     0.200
    91.377     0.474     0.200
    91.403     0.869     0.200
    91.414     0.640     0.200
    91.452     1.157     0.200
    91.463     1.019     0.200
    91.471     0.883     0.200
    91.471     1.195     0.200
    91.522     1.153     0.200
    91.535     1.054     0.200
    91.544     2.675     0.200
    91.547     0.100     0.200
    91.559     0.481     0.200
    91.563     1.020     0.200
    91.571     0.890     0.200
    91.592     0.507     0.200
    91.609     1.024     0.200
    91.621     0.290     0.200
    91.626    -0.577     0.200
    91.636     3.649     0.200
    91.668     0.776     0.200
    91.717     0.909     0.200
    91.618     6.437     0.200
    91.805     0.470     0.200
    91.838     1.511     0.200
    91.856     0.654     0.200
    91.856     0.943     0.200
    91.880     1.154     0.200
    91.880     0.904     0.200
    91.895     1.210     0.200
    91.939     0.171     0.200
    91.939     0.593     0.200
    91.961     1.036     0.200
    91.961    -0.667     0.200
    92.025     1.206     0.200
    92.106     1.412     0.200
    92.167     1.085     0.200
    92.198     2.447     0.200
    92.236     1.739     0.200
    92.236     0.442     0.200
    92.268     0.750     0.200
    92.268     1.109     0.200
    92.291     1.207     0.200
    92.143     1.020     0.200
    92.143     0.419     0.200
    92.303     2.455     0.200
    92.303     1.916     0.200
    92.271     0.667     0.200
    92.271     0.816     0.200
    92.271     0.917     0.200
    92.449     1.030     0.200
    92.460     0.597     0.200
    92.460     1.238     0.200
    92.521     1.075     0.200
    92.634     0.761     0.200
    92.634     1.433     0.200
    92.666     0.786     0.200
    92.678     1.733     0.200
    92.676    -1.000     0.200
    92.684    -0.518     0.200
    92.699     2.234     0.200
    92.737     0.636     0.200
    92.737    -0.145     0.200
    92.805    -0.955     0.200
    92.823     1.374     0.200
    92.823     0.694     0.200
    92.887     0.777     0.200
    92.887     0.542     0.200
    92.887     1.222     0.200
    92.887    -0.333     0.200
    92.953     0.986     0.200
    93.047     1.078     0.200
    93.196     1.718     0.200
    93.187    -0.576     0.200
    93.187     0.205     0.200
    93.187    -0.216     0.200
    93.202     0.496     0.200
    93.219     0.683     0.200
    93.240     0.610     0.200
    93.241     0.673     0.200
    93.241     1.735     0.200
    93.300     0.887     0.200
    93.321     0.717     0.200
    93.321     1.366     0.200
    93.462     0.993     0.200
    93.482     0.469     0.200
    93.494     0.885     0.200
    93.494     1.573     0.200
    93.503    -0.018     0.200
    93.581    -1.291     0.200
    93.576     2.091     0.200
    93.576     1.083     0.200
    93.576     1.661     0.200
    93.598     0.194     0.200
    93.615     0.771     0.200
    93.615     1.021     0.200
    93.631     0.580     0.200
    93.631     1.439     0.200
    93.311     2.866     0.200
    93.311     5.553     0.200
    93.714    -1.033     0.200
    93.736     0.559     0.200
    93.736     1.059     0.200
    93.761     1.062     0.200
    93.649     1.653     0.200
    93.646     1.622     0.200
    93.644     1.021     0.200
    93.644     0.427     0.200
    93.893     2.339     0.200
    93.893     1.268     0.200
    93.945     1.206     0.200
    94.025     0.615     0.200
    94.041    -0.444     0.200
    94.041    -1.116     0.200
    94.041     0.056     0.200
    94.078     0.447     0.200
    94.161    -0.959     0.200
    94.225     0.607     0.200
    94.225     1.256     0.200
    94.225     0.412     0.200
    94.256     0.465     0.200
    94.256     0.270     0.200
    94.266     0.731     0.200
    94.293     0.399     0.200
    94.304     0.958     0.200
    94.343     0.467     0.200
    94.080     4.627     0.200
    94.467     0.678     0.200
    94.467     0.498     0.200
    94.594     1.432     0.200
    94.612     1.496     0.200
    94.619     0.334     0.200
    94.619     0.615     0.200
    94.315     4.883     0.200
    94.633     0.736     0.200
    94.324     5.805     0.200
    94.660    -0.334     0.200
    94.752     0.623     0.200
    94.777     0.798     0.200
    94.777     0.274     0.200
    94.808     0.677     0.200
    94.818     1.193     0.200
    94.835     3.014     0.200
    94.843     1.196     0.200
    94.856     0.348     0.200
    94.894     0.798     0.200
    94.960     0.941     0.200
    94.964     1.266     0.200
    95.064     1.938     0.200
    95.064     1.368     0.200
    95.105     1.493     0.200
    95.120     0.905     0.200
    95.128     1.543     0.200
    95.130     1.961     0.200
    94.950     6.021     0.200
    95.064     5.499     0.200
    95.385     0.172     0.200
    95.519     0.684     0.200
    95.575     1.237     0.200
    95.636    -0.060     0.200
    95.645     0.712     0.200
    95.703     2.027     0.200
    95.828     1.198     0.200
    95.853     1.869     0.200
    95.846     1.861     0.200
    95.846    -0.803     0.200
    95.904     1.078     0.200
    95.904     0.633     0.200
    95.960     0.809     0.200
    96.018     1.521     0.200
    96.119     0.155     0.200
    96.127     1.165     0.200
    96.251     0.934     0.200
    96.313     0.665     0.200
    96.366     0.052     0.200
    96.601     0.219     0.200
    96.646     1.414     0.200
    96.646     1.867     0.200
    96.646     0.961     0.200
    96.816     1.393     0.200
    96.816     1.541     0.200
    96.816     0.650     0.200
    96.898     0.587     0.200
    96.796     4.382     0.200
    97.085     0.654     0.200
    96.988     1.606     0.200
    96.988     2.817     0.200
    97.132     2.067     0.200
    97.132     0.385     0.200
    97.132     0.260     0.200
    97.229     0.589     0.200
    97.304     1.280     0.200
    97.389     1.841     0.200
    97.447     0.362     0.200
    97.613     0.092     0.200
    97.647    -0.062     0.200
    97.647     0.040     0.200
    97.733    -0.043     0.200
    98.088     0.927     0.200
    98.338     1.761     0.200
    98.415     0.788     0.200
    98.477     0.410     0.200
    98.614     0.501     0.200
    98.745     0.233     0.200
    98.763    -0.665     0.200
    98.864     0.384     0.200
    98.876     0.374     0.200
    98.916     1.471     0.200
    98.944     1.027     0.200
    98.982     0.252     0.200
    98.990     2.116     0.200
    99.035    -0.084     0.200
    99.126     0.148     0.200
    99.129    -0.502     0.200
    99.148     0.042     0.200
    99.199    -0.519     0.200
    99.311    -0.565     0.200
    99.311    -1.573     0.200
    15.151     3.480     0.200
    15.157     3.478     0.200
    15.157     3.291     0.200
    15.195     4.915     0.200
    15.684     3.131     0.200
    15.700     3.471     0.200
    15.755     3.373     0.200
    15.906     2.724     0.200
    16.500     3.669     0.200
    16.500     2.950     0.200
    16.602     3.720     0.200
    16.602     2.978     0.200
    16.822     2.827     0.200
    17.571     2.483     0.200
    17.761     1.569     0.200
    17.955     1.615     0.200
    18.467    -0.854     0.200
    18.506     0.854     0.200
    18.506     2.284     0.200
    18.857     0.082     0.200
    18.854     3.309     0.200
    19.427     0.022     0.200
    19.633     0.470     0.200
    19.795     0.274     0.200
    19.978    -0.079     0.200
    19.978     0.592     0.200
    20.005     0.827     0.200
    20.157     3.431     0.200
    20.335     0.755     0.200
    20.990     2.486     0.200
    21.056     3.939     0.200
    21.085     1.072     0.200
    21.085     3.642     0.200
    21.119     3.621     0.200
    21.178     2.458     0.200
    21.339     0.650     0.200
    21.922     3.097     0.200
    22.116     2.000     0.200
    22.433    -1.381     0.200
    22.433    -1.561     0.200
    22.483    -1.397     0.200
    22.483    -0.327     0.200
    22.596    -2.364     0.200
    22.596    -2.724     0.200
    22.665     3.282     0.200
    22.665     3.595     0.200
    22.665     3.954     0.200
    22.698    -2.027     0.200
    22.698     0.137     0.200
    23.017     2.652     0.200
    23.032     2.110     0.200
    23.512    -0.517     0.200
    23.553     2.342     0.200
    23.567     2.264     0.200
    23.574     2.756     0.200
    23.890    -0.317     0.200
    23.935     2.439     0.200
    24.014     1.381     0.200
    24.419     2.935     0.200
    24.725     0.445     0.200
    24.728     1.766     0.200
    24.728    -0.570     0.200
    24.728     1.118     0.200
    24.855    -2.153     0.200
    24.967    -1.337     0.200
    24.967    -0.376     0.200
    24.975     1.288     0.200
    24.975     0.663     0.200
    25.016     1.543     0.200
    24.683     4.410     0.200
    25.088    -0.623     0.200
    25.248     3.181     0.200
    25.272    -0.300     0.200
    25.393    -1.315     0.200
    25.393    -1.174     0.200
    25.603     0.201     0.200
    25.603    -0.042     0.200
    25.715     3.219     0.200
    25.943    -0.813     0.200
    25.944     0.710     0.200
    26.447     2.163     0.200
    26.583     1.819     0.200
    26.769     1.735     0.200
    27.018     1.174     0.200
    27.191     2.075     0.200
    27.365    -0.307     0.200
    27.841     1.037     0.200
    28.635     0.713     0.200
    29.333    -1.085     0.200
    29.509     2.266     0.200
    29.629     5.890     0.200
    29.898    -0.781     0.200
    29.898     0.328     0.200
    29.924    -0.145     0.200
    30.171     3.709     0.200
    30.171    10.600     0.200
    30.171     3.553     0.200
    30.483    -1.681     0.200
    30.483    -0.728     0.200
    30.606     2.059     0.200
    30.733     2.426     0.200
    30.738     1.019     0.200
    30.752     2.561     0.200
    30.764     3.161     0.200
    30.816     4.321     0.200
    30.870     0.026     0.200
    30.960     3.334     0.200
    31.037     2.655     0.200
    31.064     5.469     0.200
    31.452     1.600     0.200
    31.452     2.108     0.200
    31.482     3.028     0.200
    31.614    -0.108     0.200
    31.649     1.414     0.200
    31.721     4.129     0.200
    31.765     3.536     0.200
    32.108     1.729     0.200
    32.177     2.921     0.200
    32.248     3.393     0.200
    32.371    -1.281     0.200
    32.371    -1.976     0.200
    32.389     1.340     0.200
    33.433     3.030     0.200
    33.487    -1.771     0.200
    33.570     1.834     0.200
    33.590     2.922     0.200
    33.590     2.562     0.200
    33.590     2.742     0.200
    33.822     4.539     0.200
    35.168     1.418     0.200
    35.357    -0.052     0.200
    36.246    -0.765     0.200
    36.246    -0.523     0.200
    36.246    -0.952     0.200
    37.772    -0.676     0.200
    38.670     0.119     0.200
    39.880    -1.193     0.200
    40.256     3.042     0.200
    40.256     0.644     0.200
    40.256     2.675     0.200
    40.256     0.042     0.200
    40.394    -0.487     0.200
    40.896    -1.058     0.200
    41.454    -0.487     0.200
    42.435     2.338     0.200
    43.114     2.732     0.200
    44.154    -1.547     0.200
    44.644    -1.174     0.200
    45.316     0.610     0.200
    45.655     2.288     0.200
    45.974    -1.052     0.200
    46.047     2.140     0.200
    46.151    -2.068     0.200
    47.604     0.741     0.200
    48.604     0.335     0.200
    49.267     2.217     0.200
    49.267     1.201     0.200
    49.267     1.350     0.200
    49.267     0.272     0.200
    49.267     2.389     0.200
    49.306     1.601     0.200
    49.744     1.570     0.200
    49.781     2.050     0.200
    50.244     2.231     0.200
    50.252     1.544     0.200
    50.301     1.345     0.200
    51.620    -0.073     0.200
    51.644     2.430     0.200
    51.702     2.456     0.200
    52.131     1.944     0.200
    52.269     3.124     0.200
    52.406     3.322     0.200
    52.542     0.152     0.200
    52.583     0.660     0.200
    52.870     1.963     0.200
    52.964     1.572     0.200
    53.065     2.263     0.200
    53.065    -0.143     0.200
    53.065     1.927     0.200
    53.158     2.262     0.200
    53.159    -0.494     0.200
    53.159     0.358     0.200
    53.159     0.772     0.200
    53.235     0.694     0.200
    53.235     0.272     0.200
    53.463     0.108     0.200
    53.472    -0.245     0.200
    53.927     3.601     0.200
    54.263     0.512     0.200
    54.435     1.294     0.200
    54.448     1.001     0.200
    54.448     0.899     0.200
    54.448    -0.077     0.200
    54.563     1.266     0.200
    54.689    -0.246     0.200
    54.687     3.279     0.200
    54.840     0.155     0.200
    54.840     0.514     0.200
    54.840    -0.447     0.200
    55.095     0.112     0.200
    55.097    -0.029     0.200
    55.407    -0.381     0.200
    55.641    -0.385     0.200
    55.641    -0.705     0.200
    55.940     0.153     0.200
    55.999     3.919     0.200
    55.999     3.810     0.200
    56.197     1.590     0.200
    56.642     0.371     0.200
    56.654    -0.396     0.200
    57.108     3.086     0.200
    57.633     1.447     0.200
    57.872     3.034     0.200
    58.095     1.966     0.200
    58.366     0.527     0.200
    58.417     0.422     0.200
    58.417     0.664     0.200
    58.456     2.524     0.200
    58.456     1.047     0.200
    58.618     0.813     0.200
    58.618     0.297     0.200
    58.859     1.486     0.200
    59.110     0.019     0.200
    59.224     1.220     0.200
    59.359     1.631     0.200
    59.834     0.471     0.200
    59.972    -1.833     0.200
    60.009     1.452     0.200
    60.009     1.054     0.200
    60.055     1.187     0.200
    60.076    -0.204     0.200
    60.263     0.620     0.200
    60.290     3.277     0.200
    60.290     2.574     0.200
    60.304     0.046     0.200
    60.361     1.009     0.200
    60.462     0.911     0.200
    60.589     1.125     0.200
    60.640     0.725     0.200
    60.639     3.284     0.200
    60.673    -0.279     0.200
    60.723     0.241     0.200
    61.021     0.016     0.200
    61.021     0.782     0.200
    61.194     2.210     0.200
    61.376     2.228     0.200
    61.456     0.715     0.200
    61.566     1.195     0.200
    61.777     0.434     0.200
    61.777     1.176     0.200
    61.777     2.027     0.200
    62.268     0.879     0.200
    62.852     2.365     0.200
    62.999     1.499     0.200
    63.417     1.398     0.200
    63.417    -0.524     0.200
    63.417     0.624     0.200
    63.443     1.381     0.200
    63.620    -0.221     0.200
    63.620     0.748     0.200
    64.573     0.730     0.200
    64.739     0.146     0.200
    64.739     1.732     0.200
    65.066     1.045     0.200
    65.066     0.311     0.200
    65.066     1.272     0.200
    65.236     0.576     0.200
    65.510     1.273     0.200
    65.577     0.994     0.200
    65.716     0.057     0.200
    65.716     0.901     0.200
    65.716     1.362     0.200
    66.033     1.659     0.200
    66.033     2.050     0.200
    66.105    -0.928     0.200
    66.171     1.165     0.200
    66.213     0.643     0.200
    66.213     0.807     0.200
    66.312     1.269     0.200
    66.510     3.153     0.200
    66.510     0.723     0.200
    66.510     2.302     0.200
    66.915     1.164     0.200
    67.311     1.681     0.200
    67.634     1.012     0.200
    67.634     1.872     0.200
    68.015     4.182     0.200
    68.225     2.349     0.200
    68.225     1.129     0.200
    68.413     0.959     0.200
    68.646     1.605     0.200
    69.108     1.009     0.200
    69.158     2.139     0.200
    69.158     1.819     0.200
    69.162     1.917     0.200
    69.200     1.483     0.200
    69.366     1.844     0.200
    69.366     1.266     0.200
    69.488     1.623     0.200
    69.601     1.632     0.200
    69.890     1.676     0.200
    69.890     1.848     0.200
    69.890     1.301     0.200
    69.934     3.685     0.200
    69.934     3.271     0.200
    70.430     1.347     0.200
    70.794     1.049     0.200
    71.079    -0.304     0.200
    71.419     1.614     0.200
    71.465    -0.068     0.200
    71.703     1.518     0.200
    71.763     0.910     0.200
    71.763     1.473     0.200
    71.954     1.817     0.200
    71.987     0.919     0.200
    71.987     2.240     0.200
    72.947     1.512     0.200
    72.967     0.753     0.200
    72.947     0.441     0.200
    73.027     2.027     0.200
    73.027     1.715     0.200
    76.784     0.848     0.200
    76.784     2.567     0.200
    77.509     1.726     0.200
    77.880     0.205     0.200
    77.929     0.521     0.200
    78.022     0.917     0.200
    78.643    -0.270     0.200
    78.643     1.183     0.200
    79.413     1.013     0.200
    79.413     0.232     0.200
    79.594     0.979     0.200
    79.594    -0.326     0.200
    79.800    -0.795     0.200
    79.800     0.659     0.200
    79.822     0.638     0.200
    79.822     0.036     0.200
    79.850     1.286     0.200
    79.850     0.684     0.200
    80.090     2.306     0.200
    80.229     0.875     0.200
    80.247     0.512     0.200
    80.330     0.507     0.200
    80.388     1.583     0.200
    80.402     1.406     0.200
    80.402    -0.446     0.200
    80.402     0.804     0.200
    80.402     1.609     0.200
    80.776     0.356     0.200
    80.919     0.662     0.200
    80.925     0.717     0.200
    80.925    -0.486     0.200
    80.925     1.108     0.200
    80.925    -0.330     0.200
    80.944     0.403     0.200
    80.944    -0.066     0.200
    81.041     0.235     0.200
    81.128     1.235     0.200
    81.464    -0.447     0.200
    81.731    -0.053     0.200
    81.761     0.415     0.200
    81.808     1.391     0.200
    81.808     1.923     0.200
    81.917     1.343     0.200
    81.925     0.769     0.200
    81.939     0.083     0.200
    82.021     0.115     0.200
    82.039     0.557     0.200
    82.072     1.527     0.200
    82.118    -0.345     0.200
    82.148     0.285     0.200
    82.166     0.946     0.200
    82.268     1.416     0.200
    82.314     0.415     0.200
    82.325     1.093     0.200
    82.341     1.298     0.200
    82.391     1.162     0.200
    82.435     1.174     0.200
    82.521     0.975     0.200
    82.563     0.558     0.200
    82.708     0.937     0.200
    82.824     0.532     0.200
    82.862     1.302     0.200
    82.862     0.810     0.200
    82.860     1.244     0.200
    82.913     1.575     0.200
    82.915     1.232     0.200
    82.915     0.912     0.200
    82.960     1.807     0.200
    82.960     1.940     0.200
    82.960     2.323     0.200
    82.994     1.000     0.200
    82.294     4.971     0.200
    83.042     1.231     0.200
    83.042     1.504     0.200
    83.048     0.907     0.200
    83.052     0.996     0.200
    83.137     0.590     0.200
    83.146     0.947     0.200
    83.204     1.046     0.200
    83.204     1.570     0.200
    83.228     1.197     0.200
    83.334     0.140     0.200
    83.334    -0.188     0.200
    83.357     1.306     0.200
    83.357     1.095     0.200
    83.405     1.262     0.200
    83.412     0.910     0.200
    83.424     0.819     0.200
    83.607     1.472     0.200
    83.719     1.844     0.200
    83.719     1.570     0.200
    83.960     0.909     0.200
    83.985     1.349     0.200
    84.309     0.332     0.200
    84.408     0.292     0.200
    84.500     0.406     0.200
    84.502     0.424     0.200
    84.859     0.670     0.200
    84.998     2.457     0.200
    85.254     1.020     0.200
    85.262     1.081     0.200
    85.262     0.034     0.200
    85.262    -0.099     0.200
    85.258     2.248     0.200
    85.468     1.264     0.200
    85.468     0.554     0.200
    85.468     1.624     0.200
    85.473     0.331     0.200
    85.473     0.831     0.200
    85.473     0.331     0.200
    85.493     1.499     0.200
    85.493    -0.282     0.200
    85.514     1.814     0.200
    85.514     0.064     0.200
    85.514     1.025     0.200
    85.519     0.079     0.200
    85.635     1.321     0.200
    85.725     1.173     0.200
    85.749     0.506     0.200
    85.749    -0.041     0.200
    85.762     1.091     0.200
    85.799     1.112     0.200
    85.819     1.410     0.200
    85.833     1.095     0.200
    86.045     2.034     0.200
    86.479    -0.393     0.200
    86.569     1.212     0.200
    86.766     0.902     0.200
    86.825     1.409     0.200
    86.825     0.776     0.200
    86.896     1.042     0.200
    86.943     0.286     0.200
    86.973    -0.275     0.200
    86.992    -0.443     0.200
    87.402    -0.503     0.200
    87.502    -0.101     0.200
    87.642     0.772     0.200
    87.642     0.405     0.200
    87.714     0.616     0.200
    87.774     0.771     0.200
    87.887     0.823     0.200
    87.887    -0.341     0.200
    87.994     1.960     0.200
    88.076     0.494     0.200
    88.078     1.014     0.200
    88.216     0.807     0.200
    88.234    -0.065     0.200
    88.316    -0.627     0.200
    88.396     0.963     0.200
    88.396     0.299     0.200
    88.395     1.351     0.200
    88.413    -1.172     0.200
    88.525     0.966     0.200
    88.638     0.953     0.200
    88.663     0.720     0.200
    88.694    -1.692     0.200
    88.767    -0.042     0.200
    88.869    -0.196     0.200
    89.308    -0.005     0.200
    89.355     0.717     0.200
    89.355     0.249     0.200
    89.355    -0.619     0.200
    89.355     0.108     0.200
    89.355     1.108     0.200
    89.359    -0.863     0.200
    89.359     0.387     0.200
    89.359     0.699     0.200
    89.370     1.935     0.200
    89.450     1.103     0.200
    89.461     0.635     0.200
    89.480     1.466     0.200
    89.644     1.184     0.200
    89.649    -0.425     0.200
    89.649     0.528     0.200
    89.649     0.278     0.200
    89.716     1.292     0.200
    89.732     0.954     0.200
    90.074     0.467     0.200
    90.233     1.404     0.200
    90.263     2.163     0.200
    90.276    -0.048     0.200
    90.286     0.367     0.200
    90.286    -0.477     0.200
    90.286     1.054     0.200
    90.286     0.921     0.200
    90.369     0.871     0.200
    90.487     0.907     0.200
    90.618     1.006     0.200
    90.652     0.169     0.200
    90.771     1.696     0.200
    90.794     0.981     0.200
    90.813     1.209     0.200
    90.813     1.100     0.200
    90.813     1.694     0.200
    90.999     0.229     0.200
    90.976    -0.881     0.200
    90.978    -0.063     0.200
    91.040     1.048     0.200
    91.196     0.220     0.200
    91.270     0.824     0.200
    91.269     1.341     0.200
    91.398     0.424     0.200
    91.398    -0.318     0.200
    91.579     0.937     0.200
    91.610     1.006     0.200
    91.637     0.980     0.200
    91.646     0.801     0.200
    91.671    -0.083     0.200
    91.671     1.018     0.200
    91.671     1.972     0.200
    91.671     0.120     0.200
    91.707     1.167     0.200
    91.707     1.307     0.200
    91.779     0.990     0.200
    91.870     0.527     0.200
    91.907     2.426     0.200
    92.082    -0.005     0.200
    92.082     1.221     0.200
    92.082     1.018     0.200
    92.126     0.914     0.200
    92.132     0.644     0.200
    92.266     1.481     0.200
    92.341     0.997     0.200
    92.398     1.017     0.200
    92.479     0.104     0.200
    92.523     1.096     0.200
    92.654     0.873     0.200
    92.679     1.032     0.200
    92.751     1.309     0.200
    92.814    -1.366     0.200
    92.875     0.761     0.200
    92.875    -0.544     0.200
    92.936     0.783     0.200
    92.936     0.572     0.200
    93.058     1.817     0.200
    93.097     0.181     0.200
    93.097     0.704     0.200
    93.097    -0.569     0.200
    93.160     0.894     0.200
    93.176     1.092     0.200
    93.236     1.190     0.200
    93.270     1.531     0.200
    93.272     0.960     0.200
    93.366     0.999     0.200
    93.431     0.293     0.200
    93.532     1.149     0.200
    93.682     0.956     0.200
    93.683     0.333     0.200
    93.718     0.636     0.200
    93.856     1.335     0.200
    93.953     0.953     0.200
    93.953     0.828     0.200
    94.152     1.094     0.200
    94.162    -0.377     0.200
    94.162     0.428     0.200
    94.309     0.638     0.200
    94.412     1.483     0.200
    94.422     0.844     0.200
    94.422     0.539     0.200
    94.456     0.385     0.200
    94.462     2.153     0.200
    94.499     0.790     0.200
    94.526     0.472     0.200
    94.554     2.630     0.200
    94.657     0.854     0.200
    94.657     0.651     0.200
    94.677     1.666     0.200
    94.804     1.210     0.200
    94.821     1.369     0.200
    94.845     0.461     0.200
    94.845     0.296     0.200
    94.994    -0.321     0.200
    95.032     0.404     0.200
    95.175     1.083     0.200
    95.194     1.468     0.200
    95.260     2.008     0.200
    95.260     1.500     0.200
    95.330     1.738     0.200
    95.330     1.386     0.200
    95.331     2.382     0.200
    95.330     1.258     0.200
    95.563     0.297     0.200
    95.690     1.241     0.200
    95.810     1.799     0.200
    96.100     1.307     0.200
    96.100     0.674     0.200
    96.144     0.857     0.200
    96.171     1.071     0.200
    96.221     1.983     0.200
    96.221     1.327     0.200
    96.380    -0.602     0.200
    96.457     1.200     0.200
    96.480     0.503     0.200
    96.555    -0.822     0.200
    96.755    -0.075     0.200
    96.803     1.176     0.200
    96.974    -0.143     0.200
    96.974     1.208     0.200
    97.012     1.632     0.200
    97.012     2.054     0.200
    97.346    -0.121     0.200
    97.346    -0.222     0.200
    24.122     2.378     0.200
    25.125     2.280     0.200
    54.938     1.281     0.200
    24.167     2.135     0.200
    25.157     0.869     0.200
    54.978     0.703     0.200
    16.945     2.798     0.200
    16.945     2.230     0.200
    16.945     4.028     0.200
    17.769     1.566     0.200
    17.770     1.723     0.200
    17.909     1.466     0.200
    18.566     1.170     0.200
    18.733     1.138     0.200
    18.909     1.648     0.200
    18.914     1.293     0.200
    19.521     1.072     0.200
    19.747     1.813     0.200
    19.875     0.804     0.200
    20.592     1.281     0.200
    20.647     0.997     0.200
    20.650     0.993     0.200
    20.752     1.865     0.200
    20.772     1.430     0.200
    21.184     2.349     0.200
    22.313     1.689     0.200
    22.428    -0.478     0.200
    22.699     0.904     0.200
    22.794     1.001     0.200
    22.950     1.371     0.200
    23.573     1.512     0.200
    24.108     2.525     0.200
    24.108     1.689     0.200
    24.813    -0.625     0.200
    25.094     2.019     0.200
    25.094     0.368     0.200
    25.094     0.618     0.200
    25.331     1.370     0.200
    25.624     1.493     0.200
    25.863     0.840     0.200
    26.067     1.426     0.200
    26.112     1.530     0.200
    26.200    -2.121     0.200
    27.526    -2.351     0.200
    27.769     1.294     0.200
    28.233     1.379     0.200
    30.061     1.511     0.200
    34.068     0.745     0.200
    44.975    -1.051     0.200
    45.750     1.401     0.200
    45.879    -2.237     0.200
    48.483     1.679     0.200
    51.654     1.719     0.200
    52.087     1.386     0.200
    52.604     1.392     0.200
    53.578     1.523     0.200
    53.625     1.748     0.200
    54.916     0.507     0.200
    54.916     1.216     0.200
    54.916     0.417     0.200
    54.916     0.738     0.200
    55.830     0.759     0.200
    56.396     1.085     0.200
    59.199     0.695     0.200
    62.771    -0.473     0.200
    78.055     0.293     0.200
    80.777    -0.103     0.200
    82.105     1.583     0.200
    82.469     0.918     0.200
    82.575     1.176     0.200
    82.791     1.187     0.200
    82.837     1.792     0.200
    82.979     1.055     0.200
    83.001     1.099     0.200
    83.624     1.799     0.200
    85.174     2.606     0.200
    85.323     0.065     0.200
    85.412     0.921     0.200
    85.407     0.808     0.200
    97.190    -0.293     0.200
    16.046     5.042     0.200
    16.658     2.972     0.200
    16.729     1.945     0.200
    16.729     2.275     0.200
    17.451     2.784     0.200
    18.200     3.288     0.200
    18.287     0.781     0.200
    18.466    -1.484     0.200
    18.847     1.059     0.200
    19.053     0.897     0.200
    19.184    -4.225     0.200
    19.279     0.915     0.200
    19.386     0.271     0.200
    19.474     0.805     0.200
    19.720    -0.420     0.200
    19.817     0.124     0.200
    19.784     1.738     0.200
    19.784     0.054     0.200
    19.918     1.728     0.200
    19.921     2.005     0.200
    19.950     1.689     0.200
    20.188     1.113     0.200
    20.179     1.689     0.200
    20.173    -1.486     0.200
    20.329    -1.559     0.200
    20.348    -1.189     0.200
    20.320     2.054     0.200
    20.320     2.067     0.200
    20.329     0.727     0.200
    20.468    -0.650     0.200
    20.569     1.600     0.200
    20.617     1.310     0.200
    20.683    -1.278     0.200
    20.652     1.108     0.200
    20.652     0.313     0.200
    20.652     1.893     0.200
    20.738    -1.222     0.200
    20.698     1.661     0.200
    20.757     1.202     0.200
    20.763     2.185     0.200
    20.794     2.562     0.200
    20.864     2.496     0.200
    20.883     1.774     0.200
    20.892     0.443     0.200
    20.898     2.136     0.200
    20.954     2.412     0.200
    20.957     2.387     0.200
    20.959     2.711     0.200
    20.959     1.655     0.200
    20.960     2.709     0.200
    20.962     2.507     0.200
    21.025    -2.931     0.200
    21.073     2.015     0.200
    21.279     0.490     0.200
    21.279     0.701     0.200
    21.454     0.862     0.200
    21.505    -1.410     0.200
    21.505     3.703     0.200
    21.572    -1.684     0.200
    21.702     0.712     0.200
    21.859     2.907     0.200
    21.902     1.568     0.200
    21.902     0.861     0.200
    21.984     1.565     0.200
    22.061     1.794     0.200
    22.248     2.269     0.200
    22.313     1.407     0.200
    22.313     0.188     0.200
    22.435    -1.436     0.200
    22.435    -1.865     0.200
    22.444     3.352     0.200
    22.444     2.377     0.200
    22.564    -2.342     0.200
    22.564    -1.771     0.200
    22.535     1.692     0.200
    22.618    -0.098     0.200
    22.618     0.171     0.200
    22.889     3.040     0.200
    23.015    -2.455     0.200
    23.175     0.954     0.200
    23.489    -2.493     0.200
    23.739     2.737     0.200
    23.752     1.040     0.200
    23.752     1.954     0.200
    23.759     2.952     0.200
    24.161     0.746     0.200
    24.197     2.913     0.200
    24.665     1.827     0.200
    24.673     1.709     0.200
    24.719     2.496     0.200
    24.785     0.704     0.200
    24.785     2.175     0.200
    24.785     1.595     0.200
    24.508     4.107     0.200
    24.860     1.413     0.200
    24.863     0.183     0.200
    24.863    -0.366     0.200
    24.863    -0.686     0.200
    24.827     1.968     0.200
    24.827     1.497     0.200
    24.827     1.708     0.200
    24.940    -1.408     0.200
    24.940    -1.668     0.200
    24.940    -1.119     0.200
    25.027     2.389     0.200
    25.159     0.161     0.200
    25.176     0.733     0.200
    25.256    -1.506     0.200
    25.342    -1.722     0.200
    25.331     1.712     0.200
    25.417    -1.462     0.200
    25.464     0.840     0.200
    25.484     1.810     0.200
    25.547     2.116     0.200
    25.706    -0.037     0.200
    25.706    -0.377     0.200
    25.706     0.091     0.200
    26.001    -1.799     0.200
    26.739     1.233     0.200
    26.723     2.433     0.200
    27.193     1.203     0.200
    27.264     1.368     0.200
    28.098     1.381     0.200
    28.098     3.301     0.200
    28.282     2.461     0.200
    28.556    -1.734     0.200
    28.983     3.822     0.200
    29.290     2.402     0.200
    29.694     2.118     0.200
    29.950     2.402     0.200
    29.950     3.771     0.200
    29.950     1.152     0.200
    30.308     1.588     0.200
    30.547    -1.022     0.200
    30.531     2.213     0.200
    30.595     1.990     0.200
    30.681     3.495     0.200
    30.733     2.711     0.200
    30.772     3.937     0.200
    30.816     1.900     0.200
    30.915     0.475     0.200
    30.915     1.385     0.200
    31.205     2.969     0.200
    31.242     0.743     0.200
    31.242     2.061     0.200
    31.242     0.641     0.200
    31.264     4.851     0.200
    31.275     1.765     0.200
    31.358    -1.872     0.200
    31.358    -2.394     0.200
    31.487     2.988     0.200
    31.501     2.965     0.200
    31.544     3.384     0.200
    31.614     2.741     0.200
    31.614     4.666     0.200
    31.614     2.967     0.200
    31.804    -0.009     0.200
    31.821     2.176     0.200
    31.821     3.424     0.200
    31.889     3.053     0.200
    31.924     2.443     0.200
    31.995     4.518     0.200
    32.031     2.705     0.200
    32.438    -2.046     0.200
    32.438    -1.671     0.200
    32.520     2.509     0.200
    33.215     2.637     0.200
    33.367    -2.596     0.200
    33.348     2.070     0.200
    33.375     1.973     0.200
    33.375     2.903     0.200
    33.375     2.432     0.200
    33.442    -1.649     0.200
    33.860     1.018     0.200
    34.203     2.436     0.200
    35.331     1.015     0.200
    35.397    -1.789     0.200
    36.341    -1.009     0.200
    36.341    -1.808     0.200
    36.341    -0.868     0.200
    38.484     0.212     0.200
    38.643     0.860     0.200
    40.038     1.190     0.200
    40.038     0.961     0.200
    40.038     2.389     0.200
    40.156     0.913     0.200
    40.156     0.102     0.200
    40.189    -2.033     0.200
    40.818     0.359     0.200
    40.909    -0.200     0.200
    40.909     0.681     0.200
    40.944     0.627     0.200
    41.125     0.127     0.200
    41.184    -0.592     0.200
    41.377     0.781     0.200
    41.377     0.783     0.200
    42.433    -2.495     0.200
    43.700     0.017     0.200
    44.094    -1.151     0.200
    44.769    -1.490     0.200
    45.126     1.286     0.200
    45.967    -1.763     0.200
    45.967    -0.273     0.200
    45.967    -1.314     0.200
    47.767     1.504     0.200
    49.052     2.352     0.200
    49.052     1.602     0.200
    49.052     1.403     0.200
    49.052     2.098     0.200
    49.533     1.979     0.200
    50.042     1.753     0.200
    50.690     3.250     0.200
    51.017     4.002     0.200
    51.017     2.892     0.200
    51.437     2.697     0.200
    51.437     1.568     0.200
    51.494     2.374     0.200
    51.785     1.268     0.200
    52.063     2.576     0.200
    52.063     0.965     0.200
    52.322     0.664     0.200
    52.322     0.394     0.200
    52.661     1.428     0.200
    52.743     1.121     0.200
    52.775    -0.787     0.200
    52.938     0.684     0.200
    52.938     0.442     0.200
    53.044     1.101     0.200
    53.129     1.769     0.200
    53.253     2.052     0.200
    53.253     0.872     0.200
    53.253     1.462     0.200
    53.253     1.680     0.200
    53.379     0.422     0.200
    53.379     0.231     0.200
    53.723     3.562     0.200
    54.484     3.143     0.200
    54.601     0.605     0.200
    54.613     0.715     0.200
    54.613     0.317     0.200
    54.613     0.487     0.200
    54.733     1.051     0.200
    55.006     0.671     0.200
    55.006     0.308     0.200
    55.006    -0.290     0.200
    55.419     0.110     0.200
    55.419    -0.179     0.200
    55.564     0.515     0.200
    57.470     0.234     0.200
    57.677     2.970     0.200
    57.900     1.469     0.200
    58.196     0.736     0.200
    58.196     0.494     0.200
    58.262     2.689     0.200
    58.262     2.218     0.200
    58.398     0.281     0.200
    58.398     1.270     0.200
    58.398     1.119     0.200
    58.391     2.152     0.200
    58.892     0.249     0.200
    59.194    -2.566     0.200
    59.194    -1.156     0.200
    59.788     1.223     0.200
    59.788     1.075     0.200
    59.788     0.836     0.200
    59.863     1.878     0.200
    59.995     0.696     0.200
    60.107    -0.285     0.200
    60.087     0.061     0.200
    60.100     1.066     0.200
    60.448     3.561     0.200
    60.798     0.873     0.200
    60.803     0.894     0.200
    60.803     0.294     0.200
    61.009     2.753     0.200
    61.234     0.776     0.200
    61.378     2.328     0.200
    61.378     2.088     0.200
    61.553     0.514     0.200
    61.556     0.640     0.200
    61.556     1.871     0.200
    61.556     1.545     0.200
    61.629     0.816     0.200
    62.048     1.567     0.200
    62.667     2.349     0.200
    62.781     0.733     0.200
    63.203     1.355     0.200
    63.203     0.865     0.200
    63.203     1.089     0.200
    63.203     1.246     0.200
    63.228     0.884     0.200
    63.825    -0.167     0.200
    64.351     1.431     0.200
    64.518     0.805     0.200
    64.518     0.647     0.200
    64.846     1.169     0.200
    64.846     0.769     0.200
    64.846     1.371     0.200
    64.846     0.951     0.200
    64.984     1.738     0.200
    65.273     0.520     0.200
    65.294     2.209     0.200
    65.294     1.885     0.200
    65.347     0.595     0.200
    65.355     0.758     0.200
    65.355     0.457     0.200
    65.355     0.920     0.200
    65.495     0.758     0.200
    65.495     1.427     0.200
    65.495     1.017     0.200
    65.822     0.772     0.200
    65.822     1.643     0.200
    65.822     1.803     0.200
    65.952     1.178     0.200
    65.995     0.948     0.200
    65.995     0.628     0.200
    66.103     1.505     0.200
    66.187    -0.433     0.200
    66.191     1.773     0.200
    66.330     2.699     0.200
    66.330     1.354     0.200
    66.330     2.178     0.200
    66.330     0.779     0.200
    66.330     2.535     0.200
    66.694     0.840     0.200
    66.694     1.292     0.200
    67.089     1.448     0.200
    67.110     0.694     0.200
    67.444     1.960     0.200
    67.444     1.630     0.200
    67.418     1.640     0.200
    67.418     1.390     0.200
    67.418     1.189     0.200
    67.850    -1.005     0.200
    67.841     2.704     0.200
    67.841     1.554     0.200
    68.004     1.756     0.200
    68.021     1.541     0.200
    68.149     1.466     0.200
    68.193     1.671     0.200
    68.193     2.132     0.200
    68.193     1.904     0.200
    68.283     0.276     0.200
    68.396     2.041     0.200
    68.624     3.986     0.200
    68.826     0.614     0.200
    68.891     1.929     0.200
    68.938     0.019     0.200
    68.938     1.618     0.200
    68.942     1.191     0.200
    68.979     1.789     0.200
    68.979     1.680     0.200
    69.155     1.828     0.200
    69.155     1.639     0.200
    69.265     1.785     0.200
    69.265     1.500     0.200
    69.381     1.795     0.200
    69.668     1.686     0.200
    69.668     1.530     0.200
    69.668     2.106     0.200
    69.763     2.761     0.200
    70.307     0.343     0.200
    70.307     1.772     0.200
    70.307     0.772     0.200
    70.577     0.951     0.200
    70.577     2.414     0.200
    70.948     1.595     0.200
    71.129    -0.372     0.200
    71.129    -0.734     0.200
    71.199     1.694     0.200
    71.199     1.524     0.200
    71.481     1.338     0.200
    71.481     1.849     0.200
    71.534     0.170     0.200
    71.540     0.981     0.200
    71.540     1.401     0.200
    71.540     1.264     0.200
    71.736     1.412     0.200
    71.736     2.807     0.200
    71.765     1.816     0.200
    72.605     1.214     0.200
    72.605     2.403     0.200
    72.805     1.734     0.200
    73.138     0.419     0.200
    73.118     0.162     0.200
    77.391     2.480     0.200
    77.391     1.336     0.200
    77.391     1.599     0.200
    77.834    -0.713     0.200
    77.834    -0.204     0.200
    77.982     0.336     0.200
    77.982    -0.725     0.200
    77.992     1.196     0.200
    77.992    -0.222     0.200
    77.992    -0.054     0.200
    78.034     1.762     0.200
    78.475     0.663     0.200
    78.610     0.646     0.200
    78.610    -0.104     0.200
    78.978    -0.177     0.200
    79.381     1.082     0.200
    79.425     0.521     0.200
    79.558     0.107     0.200
    79.558    -0.893     0.200
    79.761     0.556     0.200
    79.761     0.705     0.200
    79.761     0.205     0.200
    79.780     0.752     0.200
    79.780    -0.098     0.200
    79.780     0.502     0.200
    79.958     2.429     0.200
    79.958     0.831     0.200
    80.011     0.061     0.200
    80.029     1.076     0.200
    80.029     1.550     0.200
    80.079     1.684     0.200
    80.205     0.010     0.200
    80.215     0.736     0.200
    80.254     1.738     0.200
    80.519     0.981     0.200
    80.592     0.060     0.200
    80.588     1.541     0.200
    80.602     0.866     0.200
    80.602     0.866     0.200
    80.602     0.948     0.200
    80.602     0.585     0.200
    80.709     0.476     0.200
    80.753     0.449     0.200
    80.881    -0.125     0.200
    80.895     0.710     0.200
    80.895    -0.380     0.200
    80.895     0.899     0.200
    80.895    -0.171     0.200
    80.915     0.145     0.200
    80.915     0.415     0.200
    81.015     0.041     0.200
    81.049     1.237     0.200
    81.099     0.404     0.200
    81.187     0.493     0.200
    81.361     0.982     0.200
    81.432     0.495     0.200
    81.556     0.639     0.200
    81.564     1.068     0.200
    81.693     0.417     0.200
    81.693     0.907     0.200
    81.730     0.747     0.200
    81.742     0.777     0.200
    81.835     1.055     0.200
    81.840     0.959     0.200
    81.898     0.415     0.200
    81.905     0.658     0.200
    81.942     0.621     0.200
    81.980     1.121     0.200
    81.980     1.377     0.200
    81.988     0.664     0.200
    82.000     0.358     0.200
    81.994     1.440     0.200
    81.994     0.410     0.200
    81.994     1.199     0.200
    81.994     2.180     0.200
    82.070     0.551     0.200
    82.084     0.916     0.200
    82.107    -0.091     0.200
    82.149     1.256     0.200
    82.149     1.477     0.200
    82.177     1.598     0.200
    82.218     0.744     0.200
    82.237     1.487     0.200
    82.253     1.159     0.200
    82.272     0.541     0.200
    82.356     1.565     0.200
    82.356     1.104     0.200
    82.352     1.595     0.200
    82.438     0.846     0.200
    82.478     1.016     0.200
    82.579     1.671     0.200
    82.619     1.202     0.200
    82.668     0.664     0.200
    82.682     1.681     0.200
    82.682     1.273     0.200
    82.733     1.160     0.200
    82.765     1.142     0.200
    82.816     1.505     0.200
    82.825     1.251     0.200
    82.825     0.981     0.200
    82.829     1.261     0.200
    82.829     1.091     0.200
    82.862     0.197     0.200
    82.862     0.061     0.200
    82.862     1.307     0.200
    82.862     2.112     0.200
    82.899     0.906     0.200
    82.944     1.312     0.200
    82.944     1.433     0.200
    82.202     5.001     0.200
    82.965     1.192     0.200
    82.972     1.009     0.200
    83.049     0.919     0.200
    83.053     1.058     0.200
    83.053     1.187     0.200
    83.109     1.059     0.200
    83.118     1.683     0.200
    83.118     0.184     0.200
    83.173     1.196     0.200
    83.213     1.549     0.200
    83.217     1.572     0.200
    83.223     1.531     0.200
    83.239     1.136     0.200
    83.262     1.691     0.200
    83.265     1.360     0.200
    83.265     0.528     0.200
    83.265     0.900     0.200
    83.309     1.299     0.200
    83.309     1.516     0.200
    83.318     1.420     0.200
    83.329     1.545     0.200
    83.330     1.556     0.200
    83.398     1.715     0.200
    83.450     1.708     0.200
    83.459     1.355     0.200
    83.483     0.161     0.200
    83.483    -0.058     0.200
    83.510     1.115     0.200
    83.510     1.980     0.200
    83.565     0.228     0.200
    83.600     1.671     0.200
    83.623     0.553     0.200
    83.623     1.424     0.200
    83.623     2.229     0.200
    83.646     0.982     0.200
    83.685     1.344     0.200
    83.728     0.846     0.200
    83.746     1.689     0.200
    83.759     1.257     0.200
    83.892     0.577     0.200
    83.892     1.192     0.200
    83.920     1.529     0.200
    83.916     3.136     0.200
    83.924     0.858     0.200
    83.988     1.204     0.200
    84.004     1.451     0.200
    84.012     1.573     0.200
    84.025     1.423     0.200
    84.086     1.621     0.200
    84.101     0.669     0.200
    84.151     2.074     0.200
    84.296     1.075     0.200
    84.347     0.295     0.200
    84.371     0.676     0.200
    84.404     1.425     0.200
    84.460     1.444     0.200
    84.463     1.168     0.200
    84.464    -0.037     0.200
    84.464     1.925     0.200
    84.988     0.950     0.200
    84.988     1.091     0.200
    84.907     5.261     0.200
    85.024     2.480     0.200
    85.046     0.651     0.200
    85.069     2.145     0.200
    85.069     3.133     0.200
    85.133     1.112     0.200
    85.149     0.378     0.200
    85.149     2.030     0.200
    85.149     2.288     0.200
    85.203     1.760     0.200
    85.297     0.843     0.200
    85.305    -0.198     0.200
    85.305     0.004     0.200
    85.305    -0.871     0.200
    85.305    -0.576     0.200
    85.367     0.584     0.200
    85.367     2.215     0.200
    85.428     1.901     0.200
    85.428     1.190     0.200
    85.428     2.010     0.200
    85.428     1.792     0.200
    85.448     2.712     0.200
    85.465     1.269     0.200
    85.465     0.638     0.200
    85.465     1.109     0.200
    85.477     0.249     0.200
    85.477     0.650     0.200
    85.477     0.175     0.200
    85.538     0.593     0.200
    85.538    -0.868     0.200
    85.538     0.290     0.200
    85.558     0.106     0.200
    85.627     1.403     0.200
    85.664     0.693     0.200
    85.664     1.764     0.200
    85.677     1.555     0.200
    85.696     2.846     0.200
    85.713     1.472     0.200
    85.712     2.047     0.200
    85.727     0.701     0.200
    85.728     1.749     0.200
    85.728     1.271     0.200
    85.769     1.037     0.200
    85.819     1.209     0.200
    85.856     1.433     0.200
    85.889     2.034     0.200
    85.891     1.738     0.200
    85.958     2.830     0.200
    86.031     1.475     0.200
    86.031     2.494     0.200
    86.437     2.467     0.200
    86.444     2.431     0.200
    86.475     0.460     0.200
    86.536     2.019     0.200
    86.726     0.748     0.200
    86.811     0.863     0.200
    86.811     0.603     0.200
    86.824     0.371     0.200
    86.824     0.572     0.200
    86.903     0.113     0.200
    86.995    -0.732     0.200
    87.000     0.641     0.200
    87.012    -0.376     0.200
    87.036     2.543     0.200
    87.185     0.322     0.200
    87.223     2.629     0.200
    87.261     0.706     0.200
    87.272     0.822     0.200
    87.393     1.364     0.200
    87.438    -0.591     0.200
    87.451     2.524     0.200
    87.526     2.296     0.200
    87.602     0.970     0.200
    87.602     0.750     0.200
    87.634     0.315     0.200
    87.634     2.646     0.200
    87.637     2.630     0.200
    87.647    -0.026     0.200
    87.682     0.958     0.200
    87.737     0.822     0.200
    87.849     0.839     0.200
    87.849     0.329     0.200
    87.916     0.144     0.200
    87.915     2.057     0.200
    88.024     0.515     0.200
    88.049     0.424     0.200
    88.049     1.092     0.200
    88.183     0.187     0.200
    88.183     1.255     0.200
    88.225     0.045     0.200
    88.306     1.371     0.200
    88.356     0.818     0.200
    88.445    -0.582     0.200
    88.477     0.563     0.200
    88.488     1.183     0.200
    88.488     0.847     0.200
    88.561    -0.602     0.200
    88.591     2.126     0.200
    88.596     0.811     0.200
    88.617     1.054     0.200
    88.617     0.386     0.200
    88.779     0.251     0.200
    88.804    -0.375     0.200
    88.858     0.390     0.200
    88.930     0.461     0.200
    88.963    -0.463     0.200
    89.046     0.017     0.200
    89.295     0.297     0.200
    89.302     0.546     0.200
    89.412     1.530     0.200
    89.413     1.102     0.200
    89.413     0.495     0.200
    89.524     1.466     0.200
    89.524     0.675     0.200
    89.524     0.954     0.200
    89.524     1.056     0.200
    89.605     0.349     0.200
    89.605     0.427     0.200
    89.614     1.161     0.200
    89.614     0.603     0.200
    89.688     1.317     0.200
    89.688     0.758     0.200
    89.705     0.580     0.200
    89.704    -0.337     0.200
    89.705     0.969     0.200
    89.724     1.388     0.200
    89.830     1.174     0.200
    89.903     0.380     0.200
    89.903    -0.047     0.200
    90.026     0.605     0.200
    90.040    -0.959     0.200
    90.003     1.313     0.200
    90.243     0.053     0.200
    90.243    -1.197     0.200
    90.243     0.493     0.200
    90.243    -0.407     0.200
    90.243    -0.185     0.200
    90.248     0.922     0.200
    90.281     0.557     0.200
    90.312     0.955     0.200
    90.415     2.573     0.200
    90.459     0.679     0.200
    90.537     0.917     0.200
    90.537     0.349     0.200
    90.608     0.365     0.200
    90.758     1.339     0.200
    90.758     1.099     0.200
    90.765     0.439     0.200
    90.765     1.056     0.200
    90.941     0.345     0.200
    90.943     1.040     0.200
    90.967     0.997     0.200
    90.992     1.108     0.200
    90.994     0.099     0.200
    90.997    -0.837     0.200
    90.999    -1.023     0.200
    91.153     0.128     0.200
    91.235     1.693     0.200
    91.235     0.283     0.200
    91.235     1.651     0.200
    91.235     1.153     0.200
    91.254     1.644     0.200
    91.331     1.726     0.200
    91.346     0.491     0.200
    91.371     0.391     0.200
    91.371     0.151     0.200
    91.371    -0.027     0.200
    91.390     0.842     0.200
    91.539     1.462     0.200
    91.549     0.970     0.200
    91.549     0.601     0.200
    91.577     0.996     0.200
    91.603     1.387     0.200
    91.603     0.448     0.200
    91.630     1.470     0.200
    91.636     1.284     0.200
    91.663     1.160     0.200
    91.663     1.031     0.200
    91.701     1.604     0.200
    91.715     1.348     0.200
    91.741     1.478     0.200
    91.746     0.916     0.200
    91.759     1.786     0.200
    91.760     0.880     0.200
    91.804     0.575     0.200
    91.820     0.660     0.200
    91.848     1.322     0.200
    91.874     1.820     0.200
    91.874     1.420     0.200
    91.911     0.483     0.200
    91.874     1.121     0.200
    91.973     0.722     0.200
    91.973     0.362     0.200
    92.084     0.831     0.200
    92.105     0.715     0.200
    92.105     0.276     0.200
    92.196     0.132     0.200
    92.196     0.632     0.200
    92.196     0.331     0.200
    92.220     1.574     0.200
    92.297     0.993     0.200
    92.356     0.924     0.200
    92.366     1.449     0.200
    92.445     0.906     0.200
    92.445     1.303     0.200
    92.451    -0.145     0.200
    92.627     0.894     0.200
    92.637     0.746     0.200
    92.804     0.977     0.200
    92.842     1.102     0.200
    92.842     0.051     0.200
    92.858    -1.423     0.200
    92.907     0.810     0.200
    93.063     1.029     0.200
    93.063     0.553     0.200
    93.063     0.106     0.200
    93.063     0.529     0.200
    93.137     1.311     0.200
    93.290    -0.924     0.200
    93.290    -0.514     0.200
    93.290    -0.713     0.200
    93.363     0.546     0.200
    93.363     0.437     0.200
    93.382     0.770     0.200
    93.382     0.460     0.200
    93.405     0.815     0.200
    93.405    -0.246     0.200
    93.366     1.133     0.200
    93.415     0.839     0.200
    93.415     1.108     0.200
    93.406     1.251     0.200
    93.485     1.038     0.200
    93.658     1.002     0.200
    93.658     0.791     0.200
    93.674     0.618     0.200
    93.801     0.856     0.200
    93.916     1.012     0.200
    94.057     0.156     0.200
    94.057     1.045     0.200
    94.032     3.030     0.200
    94.032     1.299     0.200
    94.032     1.969     0.200
    94.032     2.692     0.200
    94.164    -0.593     0.200
    94.164    -0.433     0.200
    94.180     1.369     0.200
    94.212     0.292     0.200
    94.394     0.998     0.200
    94.394     0.428     0.200
    94.394     1.149     0.200
    94.394     0.809     0.200
    94.426     0.621     0.200
    94.487     0.479     0.200
    94.631     1.056     0.200
    94.631     0.720     0.200
    94.792    -0.305     0.200
    94.805     1.136     0.200
    94.805     0.347     0.200
    94.914     0.885     0.200
    94.957     0.788     0.200
    94.957     0.437     0.200
    94.992     0.287     0.200
    95.045     0.539     0.200
    95.123     0.878     0.200
    95.150     0.944     0.200
    95.232     0.872     0.200
    95.297     1.416     0.200
    95.299     1.866     0.200
    95.299     1.465     0.200
    95.301     1.958     0.200
    95.542     0.145     0.200
    95.542    -0.345     0.200
    95.764     0.893     0.200
    95.819     0.293     0.200
    96.015     1.999     0.200
    95.991     1.011     0.200
    96.072     1.223     0.200
    96.072     1.344     0.200
    96.106     1.017     0.200
    96.137     1.038     0.200
    96.190     2.307     0.200
    96.201     0.830     0.200
    96.287     0.965     0.200
    96.287     1.264     0.200
    96.425     1.341     0.200
    96.484    -0.097     0.200
    96.773     1.203     0.200
    96.747     0.196     0.200
    96.892     0.350     0.200
    96.892     2.149     0.200
    96.892     1.225     0.200
    96.912    -0.292     0.200
    96.984     1.897     0.200
    96.984     1.708     0.200
    97.311     0.420     0.200
    97.320    -0.221     0.200
    97.382     0.350     0.200
    97.749    -0.248     0.200
    97.784    -0.204     0.200
    97.870    -0.093     0.200
    98.897    -0.895     0.200
    99.262    -0.525     0.200
    99.273    -1.375     0.200
    99.335    -0.850     0.200
    99.403    -0.935     0.200
    15.701     3.392     0.200
    16.966     1.332     0.200
    16.989     3.182     0.200
    16.989     3.038     0.200
    16.989     3.546     0.200
    17.788     0.614     0.200
    17.820     0.604     0.200
    17.920     0.405     0.200
    19.254    -0.221     0.200
    19.396     0.019     0.200
    19.396    -1.040     0.200
    19.489     0.892     0.200
    19.782    -0.553     0.200
    20.174    -0.574     0.200
    20.174     0.206     0.200
    20.517    -0.593     0.200
    20.560    -0.038     0.200
    21.680     2.100     0.200
    22.387    -0.983     0.200
    22.387    -0.861     0.200
    22.436    -1.239     0.200
    22.436    -1.450     0.200
    22.442    -0.453     0.200
    23.263    -1.776     0.200
    23.508     1.627     0.200
    23.853    -1.882     0.200
    24.148     2.770     0.200
    24.303     2.770     0.200
    24.161     2.701     0.200
    24.168     2.889     0.200
    24.470     1.483     0.200
    24.823    -0.847     0.200
    24.823    -0.554     0.200
    24.814     0.261     0.200
    25.061    -0.920     0.200
    25.167    -0.971     0.200
    25.136     2.267     0.200
    25.139     0.144     0.200
    25.139     0.382     0.200
    25.139     1.042     0.200
    25.298     0.124     0.200
    25.454     1.172     0.200
    25.677     1.671     0.200
    25.902    -0.422     0.200
    26.107    -1.227     0.200
    27.069     2.031     0.200
    27.323     0.442     0.200
    27.370    -0.583     0.200
    27.377     0.398     0.200
    27.389     0.151     0.200
    27.376     1.215     0.200
    27.528    -1.278     0.200
    27.567    -1.280     0.200
    27.475     0.306     0.200
    27.547     0.650     0.200
    27.571     1.539     0.200
    27.740    -1.046     0.200
    27.779    -1.323     0.200
    27.816     0.910     0.200
    30.645    -0.508     0.200
    30.983     0.566     0.200
    31.190    -1.068     0.200
    31.623     0.342     0.200
    32.130     1.768     0.200
    32.545    -1.590     0.200
    32.852     3.226     0.200
    33.261    -1.507     0.200
    33.280    -0.901     0.200
    35.678     1.532     0.200
    36.515     0.012     0.200
    36.515    -0.605     0.200
    36.615    -1.044     0.200
    36.661    -1.052     0.200
    41.699     0.526     0.200
    41.974    -1.283     0.200
    41.915     0.777     0.200
    42.021    -1.414     0.200
    42.512    -1.181     0.200
    42.974     0.042     0.200
    43.661     0.470     0.200
    43.895    -0.876     0.200
    44.064     1.252     0.200
    44.818     1.422     0.200
    44.992    -0.908     0.200
    45.017    -0.838     0.200
    45.017    -0.170     0.200
    45.893    -1.574     0.200
    45.893    -0.676     0.200
    46.383    -1.202     0.200
    47.957    -0.683     0.200
    48.561     1.798     0.200
    52.137     1.243     0.200
    52.400     0.985     0.200
    53.417     2.996     0.200
    53.675     0.801     0.200
    53.663     1.219     0.200
    53.806     0.835     0.200
    54.954     1.491     0.200
    54.966     1.106     0.200
    54.966     0.703     0.200
    54.966     0.313     0.200
    55.097     1.661     0.200
    55.360     0.288     0.200
    55.894     0.483     0.200
    57.835     1.033     0.200
    60.256     0.655     0.200
    60.377     0.457     0.200
    61.132     0.704     0.200
    61.122     0.340     0.200
    62.716     0.234     0.200
    62.716     1.219     0.200
    63.826     1.732     0.200
    65.302     0.249     0.200
    65.941     2.764     0.200
    66.326    -0.657     0.200
    78.084    -0.106     0.200
    78.084    -0.829     0.200
    79.608    -0.109     0.200
    80.766     0.257     0.200
    80.785     0.187     0.200
    80.785     0.043     0.200
    81.050     1.201     0.200
    81.050     0.529     0.200
    81.586     1.722     0.200
    81.834     1.518     0.200
    81.972     1.590     0.200
    81.990     1.023     0.200
    82.099     1.733     0.200
    82.220     1.341     0.200
    82.352     1.422     0.200
    82.461     1.057     0.200
    82.532     1.958     0.200
    82.568     1.360     0.200
    82.575     1.705     0.200
    82.619     1.083     0.200
    82.658     1.731     0.200
    81.927     4.560     0.200
    82.712     1.632     0.200
    82.724     1.238     0.200
    82.785     1.435     0.200
    82.828     1.967     0.200
    82.972     1.061     0.200
    82.994     1.850     0.200
    83.027     1.729     0.200
    83.039     1.532     0.200
    83.225     2.203     0.200
    83.339     0.981     0.200
    83.616     0.149     0.200
    83.788    -0.141     0.200
    85.168     0.684     0.200
    85.348     1.263     0.200
    85.348    -0.217     0.200
    85.405     1.400     0.200
    85.405     0.607     0.200
    85.397    -0.279     0.200
    85.423     0.639     0.200
    85.423     0.963     0.200
    87.083     1.179     0.200
    87.117     0.344     0.200
    90.986     1.256     0.200
    90.986    -0.220     0.200
    91.742     0.153     0.200
    92.416    -0.088     0.200
    92.922     0.952     0.200
    92.922     0.573     0.200
    95.166     2.209     0.200
    95.895     2.358     0.200
    96.056     2.681     0.200
    97.238    -0.171     0.200
    16.513     4.181     0.200
    19.575     0.114     0.200
    23.498     2.951     0.200
    23.498    -0.034     0.200
    24.640     1.859     0.200
    25.230     0.378     0.200
    54.370     0.741     0.200
    55.504     0.343     0.200
    55.753     0.544     0.200
    55.798     0.310     0.200
    56.250     0.546     0.200
    56.559     0.604     0.200
    85.377     0.376     0.200
    85.668     1.440     0.200
    15.548     3.167     0.200
    15.872     4.100     0.200
    16.340     4.680     0.200
    16.848     2.499     0.200
    16.848     3.655     0.200
    17.270     1.486     0.200
    17.318     1.820     0.200
    17.461     2.142     0.200
    17.688     4.413     0.200
    17.884     1.245     0.200
    17.877     2.123     0.200
    18.032     1.126     0.200
    18.216    -0.094     0.200
    18.333    -0.334     0.200
    18.333    -0.686     0.200
    18.381     0.194     0.200
    18.474    -0.542     0.200
    18.559     0.762     0.200
    18.922    -1.102     0.200
    19.069     0.498     0.200
    19.381     1.019     0.200
    19.422     0.797     0.200
    19.439     0.211     0.200
    19.439    -0.023     0.200
    19.520    -0.684     0.200
    20.054     0.362     0.200
    20.097    -0.914     0.200
    20.490     0.790     0.200
    20.610     1.185     0.200
    20.846     1.474     0.200
    21.118    -1.008     0.200
    21.194     1.555     0.200
    21.544     1.767     0.200
    21.544     0.196     0.200
    21.861    -0.456     0.200
    21.974     2.775     0.200
    21.954     0.151     0.200
    22.014     1.489     0.200
    22.042     2.759     0.200
    22.247     0.563     0.200
    22.247     0.181     0.200
    22.307    -0.947     0.200
    22.307    -1.432     0.200
    22.378    -0.576     0.200
    22.378    -0.912     0.200
    22.378    -1.740     0.200
    22.879    -0.522     0.200
    23.102    -1.239     0.200
    23.335     1.284     0.200
    23.359     0.621     0.200
    23.674     1.862     0.200
    23.861    -0.782     0.200
    23.994     1.252     0.200
    24.007     2.578     0.200
    24.007     1.718     0.200
    24.323     1.316     0.200
    24.379     0.816     0.200
    24.408    -1.327     0.200
    24.116     4.756     0.200
    24.116     3.623     0.200
    24.761    -0.511     0.200
    24.761    -0.909     0.200
    24.761    -1.550     0.200
    24.993    -0.661     0.200
    24.996     0.564     0.200
    24.996    -0.225     0.200
    24.996     0.266     0.200
    24.996    -0.882     0.200
    25.122    -0.779     0.200
    25.771     0.942     0.200
    25.771     0.497     0.200
    25.771    -1.222     0.200
    25.977    -0.814     0.200
    26.132    -2.011     0.200
    26.870    -1.768     0.200
    26.920     1.899     0.200
    27.538    -1.257     0.200
    27.670     1.246     0.200
    28.753    -1.421     0.200
    29.563     0.713     0.200
    29.545     1.160     0.200
    30.087     0.869     0.200
    30.221     2.656     0.200
    31.032     1.188     0.200
    31.143    -1.025     0.200
    32.430    -1.222     0.200
    32.430    -1.449     0.200
    32.962     0.431     0.200
    32.962     1.610     0.200
    33.196    -2.152     0.200
    33.967     0.832     0.200
    35.527     0.450     0.200
    36.388    -0.250     0.200
    36.388    -0.883     0.200
    36.388    -0.109     0.200
    36.388    -1.008     0.200
    41.547     0.554     0.200
    41.769     0.805     0.200
    41.925    -1.278     0.200
    41.978    -1.266     0.200
    43.857    -1.333     0.200
    44.879    -0.581     0.200
    44.879    -1.105     0.200
    45.820    -1.170     0.200
    45.820    -1.873     0.200
    46.261    -1.320     0.200
    47.910    -1.076     0.200
    47.963     1.151     0.200
    47.963     0.972     0.200
    48.711     1.155     0.200
    48.711     1.358     0.200
    48.711     2.608     0.200
    48.711     0.913     0.200
    49.205     2.243     0.200
    50.367     1.627     0.200
    50.991     1.095     0.200
    51.123     2.214     0.200
    51.751     1.786     0.200
    51.884     1.501     0.200
    51.986     0.886     0.200
    52.519     1.353     0.200
    52.562     1.072     0.200
    52.932     0.043     0.200
    53.265     0.172     0.200
    53.330     1.879     0.200
    53.330     0.590     0.200
    53.524     1.616     0.200
    53.530     0.051     0.200
    53.530    -0.777     0.200
    53.863     1.121     0.200
    54.803    -0.056     0.200
    54.815     0.652     0.200
    54.815     0.348     0.200
    54.945     0.517     0.200
    55.029     0.174     0.200
    55.209     1.110     0.200
    55.209     0.774     0.200
    55.745    -0.012     0.200
    56.179     0.541     0.200
    57.001     0.276     0.200
    57.819     0.533     0.200
    57.989     2.787     0.200
    57.989     1.435     0.200
    57.992     0.777     0.200
    57.992     1.121     0.200
    58.120     2.377     0.200
    58.773     0.055     0.200
    59.416     1.557     0.200
    59.597     2.360     0.200
    59.808     0.550     0.200
    60.183     1.765     0.200
    60.225     0.621     0.200
    60.441     0.822     0.200
    60.441     0.173     0.200
    61.121     3.202     0.200
    61.121     1.343     0.200
    61.329     0.891     0.200
    62.419     2.797     0.200
    62.866     0.997     0.200
    62.866     0.801     0.200
    63.962     0.863     0.200
    64.972     0.466     0.200
    65.095    -0.432     0.200
    65.205    -0.683     0.200
    65.495     0.780     0.200
    66.094     1.640     0.200
    66.094     3.015     0.200
    66.094     2.117     0.200
    68.567     0.855     0.200
    69.288     1.871     0.200
    70.535     1.849     0.200
    71.527     0.144     0.200
    77.973     0.547     0.200
    77.973     0.782     0.200
    78.417     0.403     0.200
    79.241     0.375     0.200
    79.359     0.036     0.200
    79.557    -0.542     0.200
    79.570     0.081     0.200
    79.570    -0.919     0.200
    80.027     0.206     0.200
    80.525     0.422     0.200
    80.577     0.374     0.200
    80.708     0.654     0.200
    80.708     0.099     0.200
    80.708     1.849     0.200
    80.728     0.338     0.200
    80.728     0.088     0.200
    80.882     1.318     0.200
    80.896     1.665     0.200
    80.832     0.624     0.200
    80.889     0.537     0.200
    80.996     0.337     0.200
    81.240     0.374     0.200
    81.341     0.994     0.200
    81.542     0.782     0.200
    81.547     0.299     0.200
    81.565     2.160     0.200
    81.709     0.423     0.200
    81.750     0.541     0.200
    81.796     0.400     0.200
    81.813     2.024     0.200
    81.900     0.294     0.200
    81.956     1.639     0.200
    82.065     0.896     0.200
    82.079     1.711     0.200
    82.159     2.152     0.200
    82.202     1.467     0.200
    82.336     1.364     0.200
    82.447     1.145     0.200
    82.474     1.027     0.200
    82.523     1.242     0.200
    82.551     1.307     0.200
    82.551     0.768     0.200
    82.566     1.491     0.200
    82.566     1.702     0.200
    82.624     1.204     0.200
    82.649     0.927     0.200
    82.649     1.723     0.200
    81.914     5.274     0.200
    82.692     0.431     0.200
    82.766     0.721     0.200
    82.766     1.666     0.200
    82.768     1.379     0.200
    82.817     0.913     0.200
    82.817     1.757     0.200
    82.923     0.762     0.200
    82.956     1.309     0.200
    82.980     0.304     0.200
    82.980     1.320     0.200
    83.016     1.904     0.200
    83.028     1.533     0.200
    83.216     2.225     0.200
    83.329     1.053     0.200
    83.329     1.733     0.200
    83.604     1.409     0.200
    84.264     1.040     0.200
    84.837     0.707     0.200
    85.150     0.524     0.200
    85.150     1.305     0.200
    85.150     0.633     0.200
    85.240     0.084     0.200
    85.248    -0.058     0.200
    85.248     1.020     0.200
    85.248     0.598     0.200
    85.323     0.481     0.200
    85.323     1.278     0.200
    85.323     2.168     0.200
    85.346     0.953     0.200
    85.346     0.156     0.200
    85.346     0.656     0.200
    85.346     1.258     0.200
    85.387     1.551     0.200
    85.387     1.308     0.200
    85.400     0.784     0.200
    85.437     0.999     0.200
    85.443     1.875     0.200
    85.484     0.606     0.200
    85.541     1.032     0.200
    85.708     0.679     0.200
    86.025     1.032     0.200
    86.575     0.554     0.200
    86.621     0.398     0.200
    86.796     0.944     0.200
    86.863     0.191     0.200
    87.067     0.893     0.200
    87.083     1.619     0.200
    87.397     0.786     0.200
    87.397     0.325     0.200
    87.648     1.250     0.200
    87.648     0.906     0.200
    87.801     0.481     0.200
    88.025     0.566     0.200
    88.149     1.084     0.200
    88.149     0.615     0.200
    88.348     1.658     0.200
    88.364    -1.846     0.200
    89.068     0.049     0.200
    89.392    -0.072     0.200
    89.732     1.299     0.200
    89.732     1.744     0.200
    89.732     0.940     0.200
    90.063     0.892     0.200
    90.396     0.897     0.200
    90.898    -0.267     0.200
    90.898     0.390     0.200
    90.898     0.812     0.200
    91.039     1.094     0.200
    91.039     1.304     0.200
    91.188    -0.738     0.200
    91.450     1.552     0.200
    91.450     0.990     0.200
    92.004     1.479     0.200
    92.085     0.011     0.200
    92.146     0.464     0.200
    92.249     0.520     0.200
    92.270     0.734     0.200
    92.868     0.719     0.200
    92.868     1.219     0.200
    92.868     1.891     0.200
    93.280     1.187     0.200
    93.476     0.195     0.200
    93.717     0.292     0.200
    93.717     0.144     0.200
    93.927     0.318     0.200
    94.207     1.224     0.200
    94.238     0.981     0.200
    94.356     1.145     0.200
    94.284     1.809     0.200
    94.450    -0.489     0.200
    94.575     1.717     0.200
    94.594     1.202     0.200
    94.788     0.748     0.200
    94.946     0.762     0.200
    95.046     2.383     0.200
    95.109     1.802     0.200
    95.109     2.693     0.200
    95.444     0.525     0.200
    95.835     2.779     0.200
    95.887     1.545     0.200
    96.354     0.664     0.200
    96.798     1.696     0.200
    96.798     0.875     0.200
    96.878     0.740     0.200
    97.089     0.066     0.200
    97.599    -0.810     0.200
    97.630    -0.546     0.200
    97.719    -0.249     0.200
    99.484    -0.754     0.200
    15.731     3.343     0.200
    15.731     3.032     0.200
    16.421     2.685     0.200
    16.528     4.524     0.200
    16.770     2.576     0.200
    16.770     2.227     0.200
    17.015     3.049     0.200
    17.015     2.588     0.200
    17.016     3.120     0.200
    17.016     1.874     0.200
    17.016     2.730     0.200
    17.068     2.998     0.200
    17.310     2.926     0.200
    17.310     1.268     0.200
    17.729     2.749     0.200
    17.953     0.034     0.200
    18.001    -0.094     0.200
    18.070     2.141     0.200
    17.876     4.951     0.200
    18.097     3.469     0.200
    18.095     3.742     0.200
    18.176     0.376     0.200
    18.242     0.512     0.200
    18.182     1.579     0.200
    18.423    -1.209     0.200
    18.423    -0.750     0.200
    18.338     3.630     0.200
    18.686     0.434     0.200
    19.379    -0.281     0.200
    20.177    -0.486     0.200
    20.169    -0.038     0.200
    20.184    -0.441     0.200
    20.091     0.500     0.200
    20.092     1.303     0.200
    20.286     0.254     0.200
    20.290    -0.147     0.200
    20.355    -0.137     0.200
    20.302     0.922     0.200
    20.516    -0.502     0.200
    20.500     1.208     0.200
    20.567    -0.224     0.200
    20.578     0.210     0.200
    20.580    -0.240     0.200
    20.560     1.406     0.200
    20.722    -0.461     0.200
    20.654     1.308     0.200
    20.785    -0.569     0.200
    20.818     0.458     0.200
    20.812     0.579     0.200
    20.800     0.470     0.200
    20.912    -3.339     0.200
    21.139    -1.313     0.200
    21.348     1.735     0.200
    21.458    -1.309     0.200
    21.454     0.538     0.200
    21.500     2.272     0.200
    21.635    -1.366     0.200
    21.520     0.492     0.200
    21.661    -1.501     0.200
    21.645    -1.106     0.200
    21.532     1.720     0.200
    21.623     1.333     0.200
    21.706     0.767     0.200
    21.706     0.606     0.200
    21.856    -0.485     0.200
    21.824     0.128     0.200
    21.883     3.604     0.200
    21.883     3.403     0.200
    22.129     0.774     0.200
    22.129    -1.335     0.200
    22.229    -2.117     0.200
    22.397    -1.072     0.200
    22.442    -1.955     0.200
    22.535     2.043     0.200
    22.756    -1.322     0.200
    22.758    -0.330     0.200
    22.849    -1.882     0.200
    22.959    -1.891     0.200
    22.874     1.143     0.200
    22.969    -1.856     0.200
    23.069    -2.011     0.200
    23.136    -2.251     0.200
    23.209    -1.768     0.200
    23.234    -1.855     0.200
    23.262    -2.817     0.200
    23.539     0.948     0.200
    23.636     3.202     0.200
    24.157     2.130     0.200
    24.112     2.749     0.200
    24.157     2.537     0.200
    24.194     2.125     0.200
    24.280     2.406     0.200
    24.280     0.916     0.200
    24.280     2.166     0.200
    24.280     1.176     0.200
    24.335    -1.271     0.200
    24.267     2.287     0.200
    24.267     0.607     0.200
    24.267     2.136     0.200
    24.452    -1.033     0.200
    24.452    -1.613     0.200
    24.466     2.823     0.200
    24.499     0.745     0.200
    24.616     1.955     0.200
    24.675     1.678     0.200
    24.721    -0.069     0.200
    24.829    -0.999     0.200
    24.829    -1.390     0.200
    24.846     1.383     0.200
    24.978     1.994     0.200
    25.041     2.067     0.200
    25.056     2.170     0.200
    25.170    -1.419     0.200
    25.164    -0.036     0.200
    25.167    -0.411     0.200
    25.277    -0.999     0.200
    25.329    -0.571     0.200
    25.484     0.062     0.200
    25.619    -0.752     0.200
    25.863    -0.102     0.200
    25.926     0.069     0.200
    25.926    -0.650     0.200
    25.953    -0.949     0.200
    26.106    -1.258     0.200
    26.162     2.611     0.200
    26.782    -0.290     0.200
    27.099     1.080     0.200
    27.328     1.980     0.200
    27.603     1.356     0.200
    27.706     2.918     0.200
    27.722     3.780     0.200
    28.422     3.429     0.200
    28.730     2.392     0.200
    29.140     2.947     0.200
    29.096     3.835     0.200
    29.330     3.563     0.200
    29.389     3.892     0.200
    29.389     3.642     0.200
    29.758     2.468     0.200
    29.824     2.886     0.200
    29.970     4.396     0.200
    29.985     3.360     0.200
    30.050     1.681     0.200
    30.045     3.432     0.200
    30.045     3.633     0.200
    30.045     2.033     0.200
    30.127     3.806     0.200
    30.179     2.847     0.200
    30.254     3.278     0.200
    30.289     4.168     0.200
    30.664    -0.913     0.200
    30.665     2.849     0.200
    30.698     1.869     0.200
    30.698     1.559     0.200
    30.652     4.165     0.200
    30.699     3.350     0.200
    30.925     3.151     0.200
    30.954     4.100     0.200
    30.991     3.670     0.200
    31.053     4.180     0.200
    31.053     5.529     0.200
    31.193    -1.577     0.200
    31.150     3.075     0.200
    31.329     3.297     0.200
    31.346     1.616     0.200
    31.364     2.982     0.200
    31.433     5.174     0.200
    31.472     3.735     0.200
    31.776     3.258     0.200
    31.959     3.353     0.200
    32.160    -0.244     0.200
    32.160     0.030     0.200
    32.409    -1.441     0.200
    32.513    -2.293     0.200
    32.555    -1.328     0.200
    32.564    -1.210     0.200
    32.564    -2.021     0.200
    32.655     3.546     0.200
    32.822     2.941     0.200
    32.822     2.230     0.200
    32.822     1.390     0.200
    32.788     2.585     0.200
    32.927    -2.006     0.200
    32.926    -0.015     0.200
    33.129    -1.679     0.200
    33.268    -1.662     0.200
    33.268    -1.971     0.200
    33.283    -1.492     0.200
    33.283    -1.852     0.200
    33.307    -2.384     0.200
    33.325    -2.671     0.200
    33.298     2.225     0.200
    33.623    -1.851     0.200
    33.535     1.445     0.200
    33.787    -2.193     0.200
    33.818    -2.312     0.200
    33.836    -1.558     0.200
    33.851    -2.094     0.200
    33.875    -2.307     0.200
    34.014    -1.648     0.200
    34.031    -2.445     0.200
    34.131     0.691     0.200
    34.306    -2.084     0.200
    34.993     4.693     0.200
    35.381    -1.179     0.200
    35.709     0.901     0.200
    36.143    -1.347     0.200
    36.181     0.290     0.200
    36.539    -0.929     0.200
    37.300    -0.858     0.200
    37.880     0.412     0.200
    37.989    -0.045     0.200
    38.143     0.622     0.200
    39.253    -0.701     0.200
    39.253    -0.300     0.200
    39.498     1.458     0.200
    39.498     1.599     0.200
    39.498     1.749     0.200
    39.498     2.481     0.200
    39.648     1.022     0.200
    39.648     0.561     0.200
    39.656     0.806     0.200
    39.699    -0.190     0.200
    39.699     0.470     0.200
    39.581     3.092     0.200
    39.581     2.897     0.200
    39.581     2.403     0.200
    40.132     0.350     0.200
    40.302     1.099     0.200
    40.380     1.448     0.200
    40.428     0.251     0.200
    40.567     0.519     0.200
    40.600     0.967     0.200
    41.541     1.750     0.200
    41.731     1.383     0.200
    41.795     1.688     0.200
    41.795     1.338     0.200
    42.517    -1.579     0.200
    43.006     1.614     0.200
    43.693     2.200     0.200
    44.096     1.718     0.200
    44.580     1.205     0.200
    45.044    -0.884     0.200
    45.390     3.665     0.200
    45.690     2.308     0.200
    45.902    -1.338     0.200
    45.902    -1.187     0.200
    45.828     1.405     0.200
    46.262     1.711     0.200
    46.606     1.823     0.200
    48.144     1.410     0.200
    48.508     3.924     0.200
    48.508     2.555     0.200
    48.527     2.138     0.200
    48.527     1.937     0.200
    48.527     0.347     0.200
    48.527     1.720     0.200
    48.681     1.718     0.200
    49.019     2.826     0.200
    49.019     2.335     0.200
    49.131     2.810     0.200
    49.528     1.831     0.200
    49.532     1.995     0.200
    49.464     2.085     0.200
    49.533     2.590     0.200
    49.583     0.601     0.200
    49.822     1.926     0.200
    50.016     1.943     0.200
    50.180     2.965     0.200
    50.180     2.346     0.200
    50.201     1.916     0.200
    50.160     3.880     0.200
    50.357     2.424     0.200
    50.636     1.239     0.200
    50.652     1.445     0.200
    50.812     0.971     0.200
    50.878     2.012     0.200
    51.011     2.031     0.200
    50.936     2.667     0.200
    50.936     1.937     0.200
    50.990     1.714     0.200
    51.564     2.328     0.200
    51.572     4.546     0.200
    51.572     3.665     0.200
    51.572     3.937     0.200
    51.760     0.499     0.200
    51.760     0.216     0.200
    52.168     1.280     0.200
    52.163     2.045     0.200
    52.386     0.428     0.200
    52.386     0.610     0.200
    52.599     1.680     0.200
    53.113     0.877     0.200
    53.111     2.886     0.200
    53.229     2.694     0.200
    53.449     1.023     0.200
    53.512     0.860     0.200
    53.704     0.181     0.200
    53.697     1.617     0.200
    53.697     1.996     0.200
    53.697     1.005     0.200
    54.169     2.066     0.200
    54.861    -0.053     0.200
    54.861    -0.862     0.200
    54.985     0.528     0.200
    54.997     0.539     0.200
    54.997     0.439     0.200
    54.997     0.709     0.200
    55.128     0.691     0.200
    55.288     3.574     0.200
    55.391     0.294     0.200
    55.391    -0.372     0.200
    55.391     0.476     0.200
    55.391     0.585     0.200
    55.493     4.742     0.200
    55.512     2.260     0.200
    55.608     2.656     0.200
    55.924     0.527     0.200
    56.348     3.142     0.200
    56.441     2.857     0.200
    56.446     1.892     0.200
    56.576     3.788     0.200
    56.580     4.436     0.200
    56.593     4.289     0.200
    57.215     2.328     0.200
    57.449    -0.060     0.200
    57.449    -0.550     0.200
    57.433     3.697     0.200
    57.643    -0.546     0.200
    57.643    -0.376     0.200
    57.644     0.458     0.200
    57.644     0.583     0.200
    57.837     1.222     0.200
    57.837     0.902     0.200
    57.837     1.603     0.200
    57.837     1.070     0.200
    57.801     2.471     0.200
    57.871     5.776     0.200
    58.353     0.290     0.200
    58.619     2.164     0.200
    58.867    -0.983     0.200
    58.867    -1.794     0.200
    59.200    -0.824     0.200
    59.200    -1.230     0.200
    59.239     0.996     0.200
    59.239     0.590     0.200
    59.417    -0.817     0.200
    59.455     0.576     0.200
    59.410     2.276     0.200
    59.552     0.115     0.200
    59.611     3.709     0.200
    59.611     2.809     0.200
    59.648     2.503     0.200
    59.648     2.042     0.200
    60.136    -1.012     0.200
    60.136    -1.563     0.200
    59.954     2.006     0.200
    59.995     4.603     0.200
    60.016     2.689     0.200
    60.227    -0.098     0.200
    60.133     2.698     0.200
    60.261     0.604     0.200
    60.261     0.463     0.200
    60.372     0.799     0.200
    60.409     1.103     0.200
    60.770    -0.203     0.200
    60.570     1.878     0.200
    60.678     0.951     0.200
    60.806    -0.748     0.200
    60.994     1.644     0.200
    60.994     1.314     0.200
    60.994     1.778     0.200
    60.934     1.383     0.200
    61.510     1.166     0.200
    61.498     1.189     0.200
    61.498     1.449     0.200
    61.498     1.290     0.200
    61.426     1.777     0.200
    61.632    -0.347     0.200
    61.632    -0.957     0.200
    62.244     1.030     0.200
    62.233     2.028     0.200
    62.681     1.439     0.200
    62.699     0.782     0.200
    63.555    -1.514     0.200
    63.555    -2.764     0.200
    63.793     1.718     0.200
    63.924     0.293     0.200
    63.924     0.114     0.200
    63.924    -0.119     0.200
    63.968     1.067     0.200
    63.968     0.965     0.200
    64.300     0.704     0.200
    64.738     1.313     0.200
    64.738     1.513     0.200
    64.878     1.611     0.200
    64.927     0.454     0.200
    64.800     0.466     0.200
    64.800     0.696     0.200
    64.933     1.609     0.200
    64.933     0.500     0.200
    64.933     1.080     0.200
    64.933     1.357     0.200
    64.878     2.488     0.200
    65.317    -0.295     0.200
    65.309     1.390     0.200
    65.309     0.958     0.200
    65.410     0.596     0.200
    65.637     1.216     0.200
    65.597     1.583     0.200
    65.908     2.987     0.200
    65.908     2.388     0.200
    65.908     0.778     0.200
    66.144     1.300     0.200
    66.144     0.699     0.200
    66.347    -1.719     0.200
    66.566     0.780     0.200
    66.566     0.516     0.200
    66.526     1.694     0.200
    66.887     1.141     0.200
    66.887     1.494     0.200
    66.888     0.905     0.200
    66.888     1.596     0.200
    66.888     1.455     0.200
    66.888     0.680     0.200
    67.230     1.453     0.200
    67.450     1.536     0.200
    67.450     1.407     0.200
    67.434     3.629     0.200
    67.434     3.187     0.200
    67.527     1.471     0.200
    67.644     1.321     0.200
    67.644     1.462     0.200
    67.644     0.657     0.200
    67.929     1.246     0.200
    68.084     3.765     0.200
    68.332     1.624     0.200
    68.332     1.323     0.200
    68.418     1.508     0.200
    68.418     0.572     0.200
    68.389     1.630     0.200
    68.389     1.036     0.200
    68.394     1.397     0.200
    68.641     1.112     0.200
    68.641     1.260     0.200
    68.707     1.688     0.200
    68.836     1.716     0.200
    68.836     1.300     0.200
    69.026     1.515     0.200
    69.026     1.318     0.200
    69.114     1.769     0.200
    69.114     1.263     0.200
    69.114     0.919     0.200
    69.248    -0.113     0.200
    69.462     1.944     0.200
    69.462     1.534     0.200
    69.367     3.833     0.200
    69.367     2.864     0.200
    69.799     1.716     0.200
    70.095    -0.421     0.200
    70.020     2.341     0.200
    70.020     2.455     0.200
    70.259     0.963     0.200
    70.259    -0.768     0.200
    70.259     0.273     0.200
    70.259    -0.037     0.200
    70.393     1.862     0.200
    70.638     1.326     0.200
    70.638     1.529     0.200
    70.920     1.493     0.200
    70.920     1.290     0.200
    70.982     1.907     0.200
    70.982     1.747     0.200
    70.982     1.183     0.200
    71.206    -0.545     0.200
    71.178     1.237     0.200
    71.178     2.110     0.200
    71.205     1.857     0.200
    71.205     2.132     0.200
    71.489     1.599     0.200
    71.489     0.646     0.200
    71.661     0.071     0.200
    71.661    -0.949     0.200
    72.050     1.775     0.200
    72.050     1.347     0.200
    72.248     2.268     0.200
    72.248     1.000     0.200
    73.515     1.283     0.200
    73.515     1.113     0.200
    74.438    -0.857     0.200
    74.496     1.464     0.200
    75.693     1.782     0.200
    75.693     1.161     0.200
    76.961     1.375     0.200
    76.961     1.925     0.200
    76.961     1.785     0.200
    77.049     1.815     0.200
    77.049     1.514     0.200
    77.304     2.412     0.200
    77.339     2.015     0.200
    77.667     0.500     0.200
    77.667     0.621     0.200
    77.695     1.522     0.200
    77.701     1.810     0.200
    77.830     0.323     0.200
    77.830     0.214     0.200
    78.103     0.873     0.200
    78.103     0.793     0.200
    78.477     0.596     0.200
    78.477     0.727     0.200
    78.575     0.905     0.200
    78.575     0.735     0.200
    78.869     0.377     0.200
    79.249     0.602     0.200
    79.306     0.726     0.200
    79.416     0.552     0.200
    79.416     0.271     0.200
    79.428     0.196     0.200
    79.507     0.380     0.200
    79.583     2.084     0.200
    79.612     0.687     0.200
    79.612     0.087     0.200
    79.622     0.771     0.200
    79.622    -0.049     0.200
    79.893     0.753     0.200
    79.928     0.854     0.200
    79.978     0.213     0.200
    79.832     3.460     0.200
    80.084     0.437     0.200
    80.094     0.723     0.200
    80.346     1.036     0.200
    80.451     1.444     0.200
    80.590     0.985     0.200
    80.644     0.552     0.200
    80.628     1.099     0.200
    80.562     1.277     0.200
    80.677     1.841     0.200
    80.771     0.907     0.200
    80.771     0.756     0.200
    80.771     0.186     0.200
    80.790     0.552     0.200
    80.804     1.239     0.200
    80.897     0.743     0.200
    80.941     0.197     0.200
    81.020     2.504     0.200
    81.055     0.918     0.200
    81.057     1.052     0.200
    81.084     2.114     0.200
    81.084     1.284     0.200
    81.084     1.835     0.200
    81.292     0.737     0.200
    81.300     1.007     0.200
    81.390     0.650     0.200
    81.541     0.640     0.200
    81.546     0.573     0.200
    81.546     0.944     0.200
    81.580     1.102     0.200
    81.583     1.319     0.200
    81.604     1.018     0.200
    81.607     1.534     0.200
    81.700     1.370     0.200
    81.767     1.096     0.200
    81.769     1.395     0.200
    81.811     1.408     0.200
    81.830     0.983     0.200
    81.851     0.916     0.200
    81.853     1.392     0.200
    81.868     1.544     0.200
    81.868     1.714     0.200
    81.900     0.688     0.200
    81.904     1.787     0.200
    81.952     0.731     0.200
    81.968     1.630     0.200
    81.986     1.554     0.200
    82.084     1.247     0.200
    82.096     1.438     0.200
    82.117     0.826     0.200
    82.181     1.312     0.200
    82.217     1.534     0.200
    82.217     1.034     0.200
    82.216     1.347     0.200
    82.325     1.017     0.200
    82.347     1.371     0.200
    82.371     1.687     0.200
    82.385     1.432     0.200
    82.400     1.895     0.200
    82.456     1.292     0.200
    82.480     1.517     0.200
    82.514     1.061     0.200
    82.523     1.484     0.200
    82.527     1.865     0.200
    82.527     0.693     0.200
    82.434     1.417     0.200
    82.434     1.798     0.200
    82.434     1.568     0.200
    82.434     2.411     0.200
    82.560     1.848     0.200
    82.564     1.287     0.200
    82.564     0.957     0.200
    82.569     1.793     0.200
    82.569     1.909     0.200
    82.614     1.289     0.200
    82.625     1.721     0.200
    82.645     1.357     0.200
    82.652     1.438     0.200
    82.652     1.799     0.200
    81.921     5.144     0.200
    82.681     1.381     0.200
    82.681     0.842     0.200
    82.709     1.517     0.200
    82.704     0.441     0.200
    82.721     1.303     0.200
    82.773     1.522     0.200
    82.780     1.334     0.200
    82.816     1.247     0.200
    82.822     1.484     0.200
    82.967     1.254     0.200
    82.982     1.816     0.200
    82.986     1.206     0.200
    82.989     1.332     0.200
    82.989     1.172     0.200
    83.021     1.494     0.200
    83.034     1.320     0.200
    83.057     0.761     0.200
    83.153     1.383     0.200
    83.161     1.584     0.200
    83.175     1.316     0.200
    83.208     1.145     0.200
    83.219     2.249     0.200
    83.225     0.832     0.200
    83.334     1.790     0.200
    83.338     0.805     0.200
    83.354     1.394     0.200
    83.388     0.843     0.200
    83.406     1.390     0.200
    83.456     1.459     0.200
    83.504     1.373     0.200
    83.579     3.507     0.200
    83.604     2.101     0.200
    83.611     1.586     0.200
    83.612     1.487     0.200
    83.666     1.003     0.200
    83.755     1.866     0.200
    83.784     1.597     0.200
    83.832     1.691     0.200
    83.817    -0.088     0.200
    83.817    -0.281     0.200
    83.948     1.808     0.200
    83.968     1.768     0.200
    83.992     0.743     0.200
    84.033     1.495     0.200
    84.047     2.163     0.200
    84.083     1.682     0.200
    84.175     2.241     0.200
    84.226     1.065     0.200
    84.303     1.442     0.200
    84.320     1.274     0.200
    84.351     1.535     0.200
    84.392     0.222     0.200
    84.696     2.058     0.200
    84.776     2.692     0.200
    84.776     1.891     0.200
    84.776     2.945     0.200
    84.828     2.036     0.200
    84.846     2.068     0.200
    84.912     1.224     0.200
    84.912     1.802     0.200
    85.096     1.533     0.200
    85.110     2.738     0.200
    85.164     1.893     0.200
    85.164     2.021     0.200
    85.364     0.180     0.200
    85.364    -0.050     0.200
    85.364     1.251     0.200
    85.394     2.377     0.200
    85.402     1.561     0.200
    85.401     1.414     0.200
    85.401     1.674     0.200
    85.406     1.103     0.200
    85.433     0.655     0.200
    85.433     0.556     0.200
    85.452     1.713     0.200
    85.553     1.328     0.200
    85.553     0.978     0.200
    85.580     1.274     0.200
    85.602    -0.065     0.200
    85.322     4.910     0.200
    85.322     3.999     0.200
    85.322     3.351     0.200
    85.660     2.995     0.200
    85.693     2.144     0.200
    85.693     2.359     0.200
    85.707     2.106     0.200
    85.724     2.121     0.200
    85.765     1.286     0.200
    85.928     1.546     0.200
    86.030     2.363     0.200
    86.106     1.814     0.200
    86.107     2.141     0.200
    86.226     2.342     0.200
    86.415    -0.304     0.200
    86.474     0.294     0.200
    86.505     1.041     0.200
    86.569     2.299     0.200
    86.576     0.675     0.200
    86.675     0.418     0.200
    86.675     1.418     0.200
    86.675     0.287     0.200
    86.724     0.891     0.200
    86.725     2.746     0.200
    86.752     0.442     0.200
    86.808    -0.750     0.200
    86.851     0.570     0.200
    86.916     1.130     0.200
    86.950    -0.262     0.200
    87.058    -0.760     0.200
    87.107     0.562     0.200
    87.120     0.617     0.200
    87.118    -0.771     0.200
    87.129     1.034     0.200
    87.129     0.563     0.200
    87.165     1.237     0.200
    87.208     2.147     0.200
    87.272     0.648     0.200
    87.293     2.976     0.200
    87.310     2.895     0.200
    87.476    -0.838     0.200
    87.550     0.771     0.200
    87.574    -0.298     0.200
    87.593     0.602     0.200
    87.648     1.298     0.200
    87.648     0.486     0.200
    87.666     1.941     0.200
    87.682     1.274     0.200
    87.703     0.543     0.200
    87.691    -0.367     0.200
    87.845     0.439     0.200
    87.848    -0.715     0.200
    87.922     0.550     0.200
    87.922     0.771     0.200
    88.020     1.134     0.200
    88.036     1.172     0.200
    88.047     0.576     0.200
    88.047     0.454     0.200
    88.087     1.479     0.200
    88.152    -0.678     0.200
    88.202     0.822     0.200
    88.202     0.942     0.200
    88.289     2.219     0.200
    88.306     0.234     0.200
    88.306     1.253     0.200
    88.306     0.792     0.200
    88.345     0.848     0.200
    88.379     0.584     0.200
    88.389     0.289     0.200
    88.472    -0.952     0.200
    88.511     0.792     0.200
    88.511     0.462     0.200
    88.580    -0.910     0.200
    88.694     0.501     0.200
    88.694    -0.259     0.200
    88.768    -0.019     0.200
    88.778    -0.354     0.200
    88.796     0.668     0.200
    88.846    -0.724     0.200
    88.861    -0.297     0.200
    88.861    -0.047     0.200
    88.971     0.037     0.200
    89.008    -0.567     0.200
    89.107     0.369     0.200
    89.107     0.818     0.200
    89.107     0.199     0.200
    89.170     0.672     0.200
    89.189     0.904     0.200
    89.213    -0.017     0.200
    89.271     0.837     0.200
    89.442     0.227     0.200
    89.470     1.178     0.200
    89.488     0.973     0.200
    89.494     0.493     0.200
    89.565     1.082     0.200
    89.585     0.617     0.200
    89.585     0.898     0.200
    89.650     0.563     0.200
    89.722     0.678     0.200
    89.722     0.426     0.200
    89.787     0.233     0.200
    89.787     0.122     0.200
    89.857     0.215     0.200
    89.970    -1.193     0.200
    89.915     0.777     0.200
    89.915     0.486     0.200
    89.915     1.267     0.200
    89.915     1.017     0.200
    90.085     0.122     0.200
    90.085    -0.179     0.200
    90.085     0.581     0.200
    90.100     1.750     0.200
    90.118     0.737     0.200
    90.126     0.887     0.200
    90.022     0.114     0.200
    90.199    -0.469     0.200
    90.288     1.086     0.200
    90.336     0.799     0.200
    90.366     1.391     0.200
    90.383    -0.177     0.200
    90.385     0.503     0.200
    90.385     0.732     0.200
    90.445     0.231     0.200
    90.359    -1.155     0.200
    90.567     1.034     0.200
    90.567     0.673     0.200
    90.746     0.045     0.200
    90.476     0.697     0.200
    90.641     0.442     0.200
    90.641     0.842     0.200
    90.743     0.703     0.200
    90.741     0.584     0.200
    90.822     0.949     0.200
    90.838     0.795     0.200
    90.838     0.623     0.200
    90.998    -0.231     0.200
    91.046     0.109     0.200
    91.046     0.240     0.200
    91.097     1.333     0.200
    91.097     0.972     0.200
    91.097     1.313     0.200
    91.097     1.514     0.200
    91.117     1.431     0.200
    91.188     0.878     0.200
    91.193     1.445     0.200
    91.194     0.582     0.200
    91.203    -0.592     0.200
    91.217     0.714     0.200
    91.252     0.374     0.200
    91.252     0.484     0.200
    91.252    -0.106     0.200
    91.305     0.587     0.200
    91.400     1.135     0.200
    91.420     0.803     0.200
    91.445     0.749     0.200
    91.445     0.859     0.200
    91.444     0.892     0.200
    91.491     1.186     0.200
    91.500     0.911     0.200
    91.506     1.036     0.200
    91.562     0.237     0.200
    91.560     1.232     0.200
    91.573     1.117     0.200
    91.596     0.860     0.200
    91.601     1.324     0.200
    91.608     0.295     0.200
    91.611     0.978     0.200
    91.615     0.997     0.200
    91.644     0.394     0.200
    91.647     1.143     0.200
    91.705     0.975     0.200
    91.702     0.907     0.200
    91.667     1.967     0.200
    91.890     0.845     0.200
    91.890     0.987     0.200
    91.962    -0.836     0.200
    91.985     0.649     0.200
    91.840    -0.230     0.200
    92.038    -1.380     0.200
    92.053     1.302     0.200
    92.244     0.802     0.200
    92.307     1.018     0.200
    92.323    -0.505     0.200
    92.361     0.590     0.200
    92.361     0.400     0.200
    92.441     0.666     0.200
    92.441     0.490     0.200
    92.364     0.794     0.200
    92.364     1.443     0.200
    92.364     0.943     0.200
    92.506     0.760     0.200
    92.679     0.902     0.200
    92.679     1.094     0.200
    92.706     0.944     0.200
    92.706     1.165     0.200
    92.782     0.766     0.200
    92.926     0.761     0.200
    92.926     0.703     0.200
    92.917    -0.806     0.200
    92.988     1.057     0.200
    93.208     0.291     0.200
    93.251     0.784     0.200
    93.251     0.644     0.200
    93.267     0.760     0.200
    93.272    -0.722     0.200
    93.272    -0.244     0.200
    93.280     0.630     0.200
    93.289     0.747     0.200
    93.370     0.987     0.200
    93.370     0.805     0.200
    93.512     0.392     0.200
    93.542     0.966     0.200
    93.542     0.716     0.200
    93.609     0.556     0.200
    93.648     0.923     0.200
    93.675     0.683     0.200
    93.675     1.004     0.200
    93.669    -1.773     0.200
    93.669    -1.113     0.200
    93.773     0.811     0.200
    93.792     0.185     0.200
    93.940     0.882     0.200
    93.940     1.132     0.200
    93.868     0.815     0.200
    94.024     0.606     0.200
    94.110     0.423     0.200
    94.114    -0.739     0.200
    94.114    -0.219     0.200
    94.180    -0.450     0.200
    94.270     0.776     0.200
    94.270     0.645     0.200
    94.297     0.541     0.200
    94.300     0.588     0.200
    94.300     0.228     0.200
    94.324     0.180     0.200
    94.373     0.815     0.200
    94.373     1.475     0.200
    94.095     4.243     0.200
    94.515     0.943     0.200
    94.515     0.660     0.200
    94.515     0.043     0.200
    94.633     0.649     0.200
    94.652     0.436     0.200
    94.542     2.118     0.200
    94.542     1.292     0.200
    94.729    -0.848     0.200
    94.800     0.704     0.200
    94.800     1.034     0.200
    94.813     0.281     0.200
    94.813     0.535     0.200
    94.842     0.516     0.200
    94.888     0.724     0.200
    94.897     0.664     0.200
    94.897     1.154     0.200
    94.959     0.346     0.200
    95.109     2.044     0.200
    95.109     1.724     0.200
    95.160     1.020     0.200
    95.171     1.690     0.200
    95.171     1.440     0.200
    95.174     1.726     0.200
    95.175     1.161     0.200
    95.175     1.921     0.200
    94.982     5.644     0.200
    95.437     0.183     0.200
    95.437     0.392     0.200
    95.484     0.380     0.200
    95.606     0.945     0.200
    95.743     2.029     0.200
    95.720     0.361     0.200
    95.720    -0.118     0.200
    95.720     1.005     0.200
    95.753    -2.817     0.200
    95.861     1.330     0.200
    95.901     1.708     0.200
    95.950     1.225     0.200
    95.961     0.765     0.200
    96.000     0.871     0.200
    96.061     1.502     0.200
    96.061     1.682     0.200
    96.137     0.224     0.200
    96.178     0.970     0.200
    96.178     1.149     0.200
    96.288     1.492     0.200
    96.292     1.033     0.200
    96.352     0.826     0.200
    96.442    -0.250     0.200
    96.418     1.160     0.200
    96.635     0.324     0.200
    96.644     0.825     0.200
    96.516     1.084     0.200
    96.840     1.308     0.200
    96.840     1.447     0.200
    96.862     1.738     0.200
    96.862     1.848     0.200
    96.935     0.639     0.200
    97.112     0.814     0.200
    97.017     0.347     0.200
    97.163     0.834     0.200
    97.170     0.371     0.200
    97.170    -0.489     0.200
    97.206     0.583     0.200
    97.268    -0.060     0.200
    97.678     0.063     0.200
    97.711    -0.189     0.200
    97.797    -0.175     0.200
    98.760     0.544     0.200
    98.693     0.705     0.200
    98.829    -0.505     0.200
    98.930    -0.294     0.200
    99.067    -0.314     0.200
    99.194    -0.562     0.200
    99.264    -0.948     0.200
    99.402    -0.701     0.200
    99.562    -0.774     0.200
    15.251     5.435     0.200
    15.588     7.962     0.200
    16.364     3.033     0.200
    16.364     2.681     0.200
    16.364     2.853     0.200
    16.403     4.789     0.200
    16.666     3.134     0.200
    16.666     3.720     0.200
    17.099     2.434     0.200
    17.383     2.113     0.200
    18.115     2.473     0.200
    18.369     2.718     0.200
    18.358     0.870     0.200
    18.410    -1.135     0.200
    18.414     0.517     0.200
    18.449    -0.953     0.200
    18.499    -0.993     0.200
    18.733    -0.985     0.200
    19.211     0.654     0.200
    19.344     0.071     0.200
    19.362    -0.399     0.200
    19.510    -1.461     0.200
    19.733    -0.612     0.200
    19.868     1.249     0.200
    19.868     1.140     0.200
    19.868     3.358     0.200
    19.868     1.197     0.200
    19.868    -0.037     0.200
    20.021     3.711     0.200
    20.121     0.869     0.200
    20.159    -0.371     0.200
    20.351    -0.558     0.200
    20.358     0.755     0.200
    20.397     0.554     0.200
    20.639    -0.472     0.200
    20.919    -0.775     0.200
    21.101    -1.274     0.200
    21.095     2.797     0.200
    21.342     1.222     0.200
    21.404    -0.934     0.200
    21.394     0.992     0.200
    21.628    -1.505     0.200
    21.830     2.042     0.200
    21.826    -1.572     0.200
    21.981     2.223     0.200
    22.147     3.035     0.200
    22.197     0.072     0.200
    22.375     0.415     0.200
    22.417    -1.624     0.200
    22.529     3.453     0.200
    22.529     3.172     0.200
    22.522     1.706     0.200
    22.560    -1.961     0.200
    22.560    -2.187     0.200
    22.608     1.492     0.200
    22.608     0.953     0.200
    22.608     0.203     0.200
    22.608     1.656     0.200
    22.679     1.761     0.200
    23.101     1.766     0.200
    23.274     0.600     0.200
    23.316    -2.091     0.200
    23.502    -2.017     0.200
    23.671     2.235     0.200
    24.000    -1.079     0.200
    24.049     2.361     0.200
    24.073    -2.164     0.200
    24.091     0.448     0.200
    24.282     2.354     0.200
    24.380     1.907     0.200
    24.401    -1.485     0.200
    24.731     1.992     0.200
    24.757     2.221     0.200
    24.804     2.602     0.200
    24.794     0.294     0.200
    24.797     0.124     0.200
    24.797     0.781     0.200
    24.797     0.062     0.200
    24.850     2.320     0.200
    24.850     1.375     0.200
    24.910     1.758     0.200
    24.910     1.524     0.200
    24.910     2.031     0.200
    24.933    -1.462     0.200
    25.111     2.699     0.200
    25.091     0.478     0.200
    25.090     0.870     0.200
    25.250     1.501     0.200
    25.345    -1.244     0.200
    25.395     1.940     0.200
    25.549     1.839     0.200
    25.627     2.160     0.200
    25.651     0.307     0.200
    25.651     0.073     0.200
    25.651    -0.591     0.200
    25.651    -0.302     0.200
    25.829     2.858     0.200
    25.962    -1.821     0.200
    26.263    -2.003     0.200
    26.666     1.967     0.200
    26.805     2.365     0.200
    27.109     0.639     0.200
    27.114     1.645     0.200
    27.870     1.742     0.200
    27.913     0.838     0.200
    28.179     2.018     0.200
    28.364     3.697     0.200
    28.724     1.013     0.200
    29.066     2.953     0.200
    29.306    -1.398     0.200
    29.372     2.244     0.200
    30.034     3.678     0.200
    30.034     2.218     0.200
    30.505    -1.154     0.200
    30.616     3.941     0.200
    30.629     2.324     0.200
    30.773     3.344     0.200
    30.824     2.500     0.200
    30.860     4.178     0.200
    31.199     0.720     0.200
    31.239     3.238     0.200
    31.292     1.972     0.200
    31.318     1.974     0.200
    31.318     1.794     0.200
    31.318     2.138     0.200
    31.345     2.801     0.200
    31.351     3.836     0.200
    31.362     3.652     0.200
    31.360    -1.439     0.200
    31.360    -0.626     0.200
    31.360    -1.056     0.200
    31.433     3.881     0.200
    31.698     2.773     0.200
    31.731     1.306     0.200
    31.971     1.704     0.200
    32.112     1.968     0.200
    32.396    -2.100     0.200
    32.476     1.312     0.200
    33.296     3.293     0.200
    33.302     2.037     0.200
    33.434     0.897     0.200
    33.454     2.885     0.200
    33.454     2.377     0.200
    33.454     1.916     0.200
    33.454     2.994     0.200
    33.443    -1.539     0.200
    33.687     2.691     0.200
    34.739     1.108     0.200
    34.895     0.614     0.200
    35.038     0.235     0.200
    35.237     0.722     0.200
    35.256     1.136     0.200
    35.376    -1.552     0.200
    35.634     0.794     0.200
    35.675     0.473     0.200
    36.289    -1.060     0.200
    36.289    -1.661     0.200
    36.289    -0.450     0.200
    36.738    -0.062     0.200
    38.442     0.828     0.200
    38.547     0.184     0.200
    38.547    -0.167     0.200
    38.706     0.743     0.200
    38.780     1.580     0.200
    39.813    -0.324     0.200
    40.126     2.203     0.200
    40.126     3.039     0.200
    40.126     3.203     0.200
    40.102     1.643     0.200
    40.221     1.535     0.200
    40.221     1.176     0.200
    40.269     0.042     0.200
    40.269    -0.161     0.200
    40.885     0.118     0.200
    40.885     0.454     0.200
    40.925    -1.109     0.200
    40.981     2.275     0.200
    40.981     1.470     0.200
    41.012     1.121     0.200
    41.046     1.616     0.200
    42.133    -0.440     0.200
    42.206    -1.927     0.200
    43.209     2.298     0.200
    43.209     2.626     0.200
    44.100    -2.173     0.200
    44.402     1.257     0.200
    44.707    -1.202     0.200
    45.953    -1.039     0.200
    45.953    -1.141     0.200
    46.187    -1.469     0.200
    49.112     4.293     0.200
    49.112     2.684     0.200
    49.140     2.256     0.200
    49.278     3.253     0.200
    49.620     3.144     0.200
    49.620     2.081     0.200
    49.876     2.540     0.200
    50.122     2.163     0.200
    50.130     2.357     0.200
    50.607     2.933     0.200
    50.777     2.827     0.200
    50.777     1.827     0.200
    50.937     4.146     0.200
    51.143     2.077     0.200
    51.524     2.588     0.200
    51.533     1.507     0.200
    51.580     2.259     0.200
    51.709     1.038     0.200
    52.149     2.757     0.200
    52.221     1.933     0.200
    52.285     3.170     0.200
    52.285     2.092     0.200
    52.406     0.652     0.200
    52.669     0.787     0.200
    52.747     2.504     0.200
    52.965     0.329     0.200
    53.025     0.803     0.200
    53.054     0.278     0.200
    53.171     1.777     0.200
    53.171     0.941     0.200
    53.171     1.621     0.200
    53.171     2.004     0.200
    53.264     2.204     0.200
    53.310     0.251     0.200
    53.536     1.199     0.200
    53.684     2.680     0.200
    53.809     3.061     0.200
    54.538     0.535     0.200
    54.570     3.292     0.200
    54.570     3.143     0.200
    54.656     0.365     0.200
    54.930     0.376     0.200
    54.930     0.540     0.200
    54.930     0.220     0.200
    54.930     0.056     0.200
    55.082     1.156     0.200
    55.320     1.530     0.200
    55.345     2.001     0.200
    55.450     1.332     0.200
    55.506     0.099     0.200
    55.804     1.628     0.200
    55.878     3.637     0.200
    56.900     2.774     0.200
    56.900     2.875     0.200
    56.900     2.242     0.200
    56.900     1.563     0.200
    56.900     2.563     0.200
    56.996     3.031     0.200
    57.625     1.246     0.200
    57.717     1.291     0.200
    57.761     2.443     0.200
    57.984     2.818     0.200
    57.984     2.099     0.200
    58.283     1.026     0.200
    58.283    -0.224     0.200
    58.346     2.362     0.200
    58.346     1.627     0.200
    58.474     1.922     0.200
    58.481     0.869     0.200
    58.481     0.736     0.200
    58.481    -0.193     0.200
    58.481     1.244     0.200
    58.464     0.522     0.200
    58.918    -0.781     0.200
    58.918    -0.063     0.200
    58.980     0.219     0.200
    59.156     2.004     0.200
    59.156     1.504     0.200
    59.169    -0.551     0.200
    59.340    -0.487     0.200
    59.353     0.141     0.200
    59.876     1.147     0.200
    59.946     2.593     0.200
    59.946     1.734     0.200
    59.946     1.593     0.200
    60.050     1.867     0.200
    60.083     0.642     0.200
    60.146     0.989     0.200
    60.175    -0.304     0.200
    60.182     2.280     0.200
    60.182     2.030     0.200
    60.355     1.864     0.200
    60.365     0.318     0.200
    60.483     1.624     0.200
    60.531     3.153     0.200
    60.540     1.866     0.200
    60.550     1.617     0.200
    60.759     2.210     0.200
    60.682     0.202     0.200
    60.729     0.599     0.200
    60.725     0.786     0.200
    60.862     1.609     0.200
    60.891     0.937     0.200
    60.990     2.192     0.200
    61.061     1.287     0.200
    61.090     1.941     0.200
    61.321     0.533     0.200
    61.460     1.379     0.200
    61.474     1.535     0.200
    61.504    -0.274     0.200
    61.640     1.481     0.200
    61.640     1.833     0.200
    61.640     2.122     0.200
    61.945     2.025     0.200
    62.135     1.576     0.200
    62.135     1.435     0.200
    62.749     2.241     0.200
    62.869     1.213     0.200
    63.291     1.191     0.200
    63.291     0.777     0.200
    63.315     1.092     0.200
    63.565    -0.793     0.200
    63.565    -0.019     0.200
    63.739     0.361     0.200
    64.438     2.077     0.200
    64.553     0.642     0.200
    64.553     0.845     0.200
    64.606     1.399     0.200
    64.934     1.013     0.200
    64.934     0.841     0.200
    64.934     1.169     0.200
    64.934     1.685     0.200
    65.064     1.983     0.200
    65.242    -0.133     0.200
    65.242     0.047     0.200
    65.260     0.250     0.200
    65.260     0.094     0.200
    65.260     0.891     0.200
    65.374     2.288     0.200
    65.443     0.740     0.200
    65.443     1.326     0.200
    65.443     1.139     0.200
    65.580     0.495     0.200
    65.580     1.354     0.200
    65.580     1.635     0.200
    65.909     1.274     0.200
    65.909     1.024     0.200
    65.909     1.414     0.200
    65.909     0.672     0.200
    66.040     1.131     0.200
    66.083     1.507     0.200
    66.083     1.148     0.200
    66.083     0.905     0.200
    66.139    -0.023     0.200
    66.139    -0.211     0.200
    66.190     1.689     0.200
    66.270     1.787     0.200
    66.410     2.184     0.200
    66.410     1.879     0.200
    66.782     1.559     0.200
    66.782     1.356     0.200
    67.176     1.965     0.200
    67.176     1.684     0.200
    67.198     1.281     0.200
    67.198     1.547     0.200
    67.198     1.898     0.200
    67.506     1.469     0.200
    67.506     1.734     0.200
    67.524     2.029     0.200
    67.524     1.857     0.200
    68.091     1.502     0.200
    68.107     2.091     0.200
    68.280     0.861     0.200
    68.280     1.861     0.200
    68.280     1.650     0.200
    68.396     2.158     0.200
    68.480     1.255     0.200
    68.509     0.945     0.200
    68.509     1.062     0.200
    68.712     4.145     0.200
    68.746     1.154     0.200
    68.972     2.272     0.200
    68.972     2.373     0.200
    69.025     1.697     0.200
    69.025     2.393     0.200
    69.025     0.814     0.200
    69.030     1.779     0.200
    69.063     1.802     0.200
    69.063     1.489     0.200
    69.242     1.429     0.200
    69.242     1.812     0.200
    69.352     1.843     0.200
    69.352     2.031     0.200
    69.469     2.235     0.200
    69.469     2.102     0.200
    69.755     2.142     0.200
    69.755     2.025     0.200
    69.755     0.799     0.200
    69.840     2.589     0.200
    69.840     2.440     0.200
    70.056     0.436     0.200
    70.056    -0.338     0.200
    70.289     1.145     0.200
    70.289    -0.081     0.200
    70.658     2.629     0.200
    70.658     2.832     0.200
    71.027     0.772     0.200
    71.027     2.124     0.200
    71.027     3.194     0.200
    71.093    -0.491     0.200
    71.093    -0.374     0.200
    71.093    -1.194     0.200
    71.282     1.285     0.200
    71.282     1.605     0.200
    71.491    -0.117     0.200
    71.491    -0.570     0.200
    71.566     1.958     0.200
    71.627     1.711     0.200
    71.627     0.501     0.200
    71.627     1.594     0.200
    71.817     3.082     0.200
    71.817     2.871     0.200
    71.851     2.332     0.200
    71.851     2.176     0.200
    72.130     1.885     0.200
    72.130     1.549     0.200
    72.692     2.524     0.200
    72.692     2.149     0.200
    73.040     1.465     0.200
    73.040     1.161     0.200
    76.807     1.726     0.200
    77.422     1.900     0.200
    77.678     2.426     0.200
    77.835    -0.270     0.200
    77.951     0.927     0.200
    77.951     0.302     0.200
    77.980     0.226     0.200
    77.980    -0.782     0.200
    78.065     1.395     0.200
    78.071     2.122     0.200
    78.606     0.107     0.200
    78.606    -0.448     0.200
    78.970     0.400     0.200
    79.376     0.611     0.200
    79.418     0.576     0.200
    79.555     0.371     0.200
    79.555    -0.043     0.200
    79.759     0.317     0.200
    79.779     0.480     0.200
    79.779    -0.262     0.200
    79.779    -0.458     0.200
    79.995     2.170     0.200
    79.993     1.884     0.200
    79.993     1.673     0.200
    79.993     0.891     0.200
    80.198    -0.001     0.200
    80.464     0.567     0.200
    80.517     0.459     0.200
    80.517     1.561     0.200
    80.517     1.530     0.200
    80.745     0.740     0.200
    80.890     0.544     0.200
    80.890     0.427     0.200
    80.890     1.036     0.200
    80.909     0.682     0.200
    81.008     1.021     0.200
    81.064     0.974     0.200
    81.183     1.262     0.200
    81.670     0.893     0.200
    81.691     0.823     0.200
    81.738     1.144     0.200
    81.851     0.704     0.200
    81.857     1.132     0.200
    81.912     1.131     0.200
    81.912     0.944     0.200
    81.912     1.365     0.200
    81.912     1.998     0.200
    82.000     0.944     0.200
    81.999     0.842     0.200
    82.100     0.987     0.200
    82.106     0.240     0.200
    82.197     1.302     0.200
    82.214     1.258     0.200
    82.255     1.489     0.200
    82.272     1.230     0.200
    82.272     0.441     0.200
    82.353     1.339     0.200
    82.353     0.737     0.200
    82.368     1.381     0.200
    82.454     0.761     0.200
    82.496     1.037     0.200
    82.494     1.498     0.200
    82.527     1.796     0.200
    82.562     1.661     0.200
    82.614     1.792     0.200
    82.638     1.600     0.200
    82.654     1.026     0.200
    82.666     1.618     0.200
    82.752     1.332     0.200
    82.770     1.842     0.200
    82.786     1.157     0.200
    82.825     1.277     0.200
    82.822     0.977     0.200
    82.822     1.187     0.200
    82.839     2.025     0.200
    82.846     1.111     0.200
    82.846     0.845     0.200
    82.885     1.792     0.200
    82.885     1.425     0.200
    82.885     2.230     0.200
    82.921     0.975     0.200
    82.967     1.369     0.200
    82.967     1.033     0.200
    82.222     4.748     0.200
    82.982     1.767     0.200
    82.987     1.092     0.200
    83.067     0.840     0.200
    83.074     1.344     0.200
    83.102     1.713     0.200
    83.114     1.699     0.200
    83.130     1.209     0.200
    83.130     1.420     0.200
    83.130     1.654     0.200
    83.194     1.269     0.200
    83.201     1.647     0.200
    83.207     1.593     0.200
    83.245     1.547     0.200
    83.258     0.995     0.200
    83.285     1.041     0.200
    83.285     0.799     0.200
    83.285     1.252     0.200
    83.302     1.378     0.200
    83.302     1.501     0.200
    83.331     1.589     0.200
    83.339     1.061     0.200
    83.372     1.672     0.200
    83.412    -0.066     0.200
    83.424     1.731     0.200
    83.427     1.389     0.200
    83.412     0.161     0.200
    83.532     2.020     0.200
    83.574     1.783     0.200
    83.618     1.398     0.200
    83.645     1.764     0.200
    83.645     1.444     0.200
    83.645     1.975     0.200
    83.671     1.332     0.200
    83.720     1.596     0.200
    83.888     1.087     0.200
    83.913     1.539     0.200
    83.921     0.598     0.200
    83.981     1.411     0.200
    83.987     1.214     0.200
    83.996     1.925     0.200
    83.999     1.551     0.200
    84.067     1.398     0.200
    84.066     0.630     0.200
    84.136     2.063     0.200
    84.316     0.308     0.200
    84.368     0.392     0.200
    84.387     1.475     0.200
    84.461     0.847     0.200
    84.975     1.620     0.200
    84.975     1.370     0.200
    85.014     0.285     0.200
    85.176     1.955     0.200
    85.264    -0.255     0.200
    85.272    -0.296     0.200
    85.272     0.141     0.200
    85.272     0.032     0.200
    85.272    -0.749     0.200
    85.446     1.655     0.200
    85.446     1.905     0.200
    85.446    -0.064     0.200
    85.446     1.804     0.200
    85.449     1.101     0.200
    85.449     0.820     0.200
    85.449     1.515     0.200
    85.458     0.273     0.200
    85.458     0.500     0.200
    85.504     0.335     0.200
    85.504     0.718     0.200
    85.504     0.866     0.200
    85.504     0.124     0.200
    85.526    -0.282     0.200
    85.613     1.331     0.200
    85.613     1.214     0.200
    85.681     0.867     0.200
    85.694    -0.298     0.200
    85.709    -0.375     0.200
    85.748     1.662     0.200
    85.751     0.616     0.200
    85.782     1.282     0.200
    85.802     0.963     0.200
    85.821     0.627     0.200
    85.978     1.972     0.200
    86.061     2.318     0.200
    86.339     2.421     0.200
    86.725    -0.420     0.200
    86.743     0.881     0.200
    86.800     0.909     0.200
    86.822     0.409     0.200
    86.909     2.195     0.200
    86.976    -0.603     0.200
    86.980    -0.612     0.200
    87.171     0.156     0.200
    87.260     0.794     0.200
    87.407    -0.730     0.200
    87.601     0.736     0.200
    87.601     0.220     0.200
    87.601    -0.188     0.200
    87.633     0.261     0.200
    87.677     0.611     0.200
    87.735     0.601     0.200
    87.775     1.528     0.200
    87.847     0.614     0.200
    87.847     0.489     0.200
    87.901     0.192     0.200
    87.930     2.454     0.200
    88.028     0.363     0.200
    88.043     0.681     0.200
    88.211    -0.241     0.200
    88.325     1.135     0.200
    88.344     1.302     0.200
    88.355     1.035     0.200
    88.415    -0.878     0.200
    88.466     0.899     0.200
    88.485     0.893     0.200
    88.533    -0.870     0.200
    88.597     0.243     0.200
    88.606     0.497     0.200
    88.608     0.665     0.200
    88.706    -1.770     0.200
    88.755    -0.134     0.200
    88.755    -0.235     0.200
    88.755     0.593     0.200
    88.767     0.346     0.200
    88.773    -0.780     0.200
    88.845     0.151     0.200
    88.846     1.274     0.200
    88.931    -0.612     0.200
    89.032     0.062     0.200
    89.307     0.269     0.200
    89.307    -0.403     0.200
    89.307     0.800     0.200
    89.403     0.829     0.200
    89.411     0.747     0.200
    89.422     0.911     0.200
    89.447     1.036     0.200
    89.447     0.536     0.200
    89.447     0.646     0.200
    89.447    -0.058     0.200
    89.447     1.661     0.200
    89.605     0.015     0.200
    89.605    -0.196     0.200
    89.605     0.804     0.200
    89.609     1.075     0.200
    89.682     0.976     0.200
    89.681    -0.660     0.200
    89.698     0.720     0.200
    89.833     0.513     0.200
    89.896     0.200     0.200
    89.919     0.837     0.200
    90.026    -0.521     0.200
    90.028     0.297     0.200
    90.243     0.035     0.200
    90.243    -0.309     0.200
    90.242     0.501     0.200
    90.243     0.644     0.200
    90.269     0.087     0.200
    90.317     0.595     0.200
    90.453     0.699     0.200
    90.536     0.845     0.200
    90.608     0.092     0.200
    90.763     1.108     0.200
    90.763    -0.196     0.200
    90.763     1.577     0.200
    90.759     0.946     0.200
    90.947     0.079     0.200
    90.843     0.632     0.200
    90.949     0.531     0.200
    90.962     0.665     0.200
    90.969    -0.756     0.200
    90.972    -0.838     0.200
    90.972    -1.135     0.200
    90.974    -0.974     0.200
    90.994     0.510     0.200
    91.145     0.192     0.200
    91.193    -0.686     0.200
    91.232     1.329     0.200
    91.231     1.237     0.200
    91.231     0.666     0.200
    91.250     1.321     0.200
    91.328     1.375     0.200
    91.365     0.267     0.200
    91.396     0.402     0.200
    91.512     0.577     0.200
    91.536     1.060     0.200
    91.543     0.735     0.200
    91.573     0.739     0.200
    91.603     0.789     0.200
    91.627     1.138     0.200
    91.631     0.923     0.200
    91.631     0.579     0.200
    91.663     1.018     0.200
    91.698     1.295     0.200
    91.712     1.173     0.200
    91.737     1.282     0.200
    91.738     0.413     0.200
    91.742     0.685     0.200
    91.756     1.041     0.200
    91.766     0.173     0.200
    91.785     1.294     0.200
    91.789     1.140     0.200
    91.789     1.038     0.200
    91.789     0.351     0.200
    91.789     1.749     0.200
    91.789     1.351     0.200
    91.810     0.305     0.200
    91.823     0.315     0.200
    91.846     1.086     0.200
    91.968     0.397     0.200
    91.968     0.522     0.200
    91.967    -0.685     0.200
    92.058    -1.179     0.200
    92.098     0.581     0.200
    92.137     0.683     0.200
    92.137     0.534     0.200
    92.137    -0.263     0.200
    92.221     1.321     0.200
    92.298     1.183     0.200
    92.313    -0.389     0.200
    92.355     0.855     0.200
    92.441     1.028     0.200
    92.480     1.123     0.200
    92.620     0.505     0.200
    92.637     0.680     0.200
    92.659    -0.875     0.200
    92.709     1.044     0.200
    92.798     0.882     0.200
    92.838     0.792     0.200
    92.838     1.003     0.200
    92.901     0.678     0.200
    92.901     0.803     0.200
    93.052     2.313     0.200
    93.060     0.714     0.200
    93.060     0.652     0.200
    93.135     1.100     0.200
    93.231     0.807     0.200
    93.267    -1.680     0.200
    93.267    -1.180     0.200
    93.280     1.934     0.200
    93.356     0.122     0.200
    93.375     0.581     0.200
    93.375    -0.279     0.200
    93.411     0.538     0.200
    93.419     0.160     0.200
    93.478     0.710     0.200
    93.489     0.986     0.200
    93.642     0.828     0.200
    93.639     1.207     0.200
    93.651     0.702     0.200
    93.651     0.350     0.200
    93.674     0.290     0.200
    93.797     0.514     0.200
    93.800     0.789     0.200
    93.800     0.969     0.200
    93.823     0.433     0.200
    93.914     0.797     0.200
    93.951     0.174     0.200
    93.945     2.410     0.200
    93.945     1.355     0.200
    93.945     2.301     0.200
    93.945     2.051     0.200
    93.945     2.918     0.200
    94.050     0.717     0.200
    94.146    -0.926     0.200
    94.180     0.473     0.200
    94.211     0.305     0.200
    94.388     0.713     0.200
    94.421     0.413     0.200
    94.421     0.218     0.200
    94.456     0.494     0.200
    94.482     0.283     0.200
    94.485     0.696     0.200
    94.534     0.967     0.200
    94.624     0.770     0.200
    94.624     0.285     0.200
    94.776    -0.772     0.200
    94.776    -1.178     0.200
    94.804     0.510     0.200
    94.804     0.385     0.200
    94.907     0.655     0.200
    94.955     0.640     0.200
    94.955     0.523     0.200
    94.991     0.450     0.200
    95.062     0.139     0.200
    95.134     0.903     0.200
    95.134     1.465     0.200
    95.150     0.885     0.200
    95.226     1.985     0.200
    95.226     1.626     0.200
    95.293     0.984     0.200
    95.294     1.557     0.200
    95.295     2.012     0.200
    95.301     1.980     0.200
    95.533    -0.481     0.200
    95.533    -0.215     0.200
    95.875     2.306     0.200
    95.911     1.409     0.200
    96.008     1.560     0.200
    96.066     1.094     0.200
    96.066     1.297     0.200
    96.104     0.904     0.200
    96.133     0.851     0.200
    96.185     1.677     0.200
    96.185     1.559     0.200
    96.261     1.067     0.200
    96.261     0.833     0.200
    96.279     1.422     0.200
    96.279     0.820     0.200
    96.420     1.109     0.200
    96.487     1.151     0.200
    96.465    -0.196     0.200
    96.664     1.386     0.200
    96.768     0.596     0.200
    96.839     0.047     0.200
    96.908     1.258     0.200
    96.948     1.795     0.200
    96.978     1.606     0.200
    97.075     0.626     0.200
    97.307     0.279     0.200
    97.372     0.435     0.200
    97.595    -0.472     0.200
    97.770    -1.009     0.200
    97.797    -0.435     0.200
    97.857    -0.602     0.200
    98.882    -1.100     0.200
    99.247    -0.533     0.200
    99.321    -1.159     0.200
    99.378    -0.709     0.200
    99.610    -0.094     0.200
    18.147    -0.253     0.200
    18.417    -0.460     0.200
    18.532    -0.472     0.200
    18.826    -0.772     0.200
    19.604    -0.276     0.200
    19.793    -0.337     0.200
    20.181     0.092     0.200
    20.216    -0.646     0.200
    20.276    -0.295     0.200
    20.574    -0.467     0.200
    20.768    -1.470     0.200
    20.762    -0.413     0.200
    20.704     1.595     0.200
    20.827     1.480     0.200
    22.189    -0.597     0.200
    22.390    -1.689     0.200
    22.464    -1.513     0.200
    22.627    -1.254     0.200
    23.322    -1.524     0.200
    23.492    -0.791     0.200
    23.898    -1.059     0.200
    23.923    -1.928     0.200
    24.028     2.889     0.200
    24.496    -0.731     0.200
    24.618    -0.336     0.200
    24.770    -1.319     0.200
    25.044     2.444     0.200
    25.044     0.163     0.200
    33.282    -1.093     0.200
    33.634    -1.057     0.200
    36.451     0.332     0.200
    53.511     0.425     0.200
    53.878     0.718     0.200
    54.849     1.130     0.200
    54.849     0.622     0.200
    55.028     0.460     0.200
    56.002     0.445     0.200
    56.348     0.984     0.200
    57.174     0.422     0.200
    57.662     0.776     0.200
    85.324    -0.489     0.200
    85.324    -0.024     0.200
    85.475    -0.254     0.200
    85.475    -0.078     0.200
    20.159    -0.056     0.200
    21.183     2.286     0.200
    21.407     2.114     0.200
    21.786     1.521     0.200
    22.681     1.401     0.200
    23.979     2.907     0.200
    53.512     1.085     0.200
    54.471     0.745     0.200
    54.802     0.445     0.200
    55.007     1.432     0.200
    55.773     0.984     0.200
    55.954     0.189     0.200
    56.161     0.691     0.200
    57.126    -0.032     0.200
    57.613    -0.027     0.200
    14.860     5.935     0.200
    14.372     4.726     0.200
    16.465     5.605     0.200
    24.608     1.327     0.200
    54.411     0.061     0.200
    63.256    -0.196     0.200
    16.685     4.032     0.200
    16.741     1.825     0.200
    18.296    -0.134     0.200
    18.304     0.128     0.200
    18.457     0.145     0.200
    18.439     0.254     0.200
    18.520    -0.147     0.200
    18.614    -0.812     0.200
    18.928     0.563     0.200
    19.116    -0.111     0.200
    19.489     0.441     0.200
    19.506     0.340     0.200
    19.638     0.333     0.200
    20.705    -0.138     0.200
    21.004     0.323     0.200
    21.076    -0.780     0.200
    21.056    -0.306     0.200
    21.188     2.143     0.200
    21.401     1.795     0.200
    21.613     0.584     0.200
    22.267    -0.978     0.200
    22.374    -0.958     0.200
    23.796     2.649     0.200
    23.846    -1.076     0.200
    23.942    -0.861     0.200
    23.978    -1.287     0.200
    24.234    -1.004     0.200
    24.431    -0.454     0.200
    24.467     1.844     0.200
    24.275     4.001     0.200
    24.752    -0.571     0.200
    24.828     0.012     0.200
    26.819    -1.238     0.200
    27.516    -0.150     0.200
    32.327    -0.768     0.200
    39.655    -1.528     0.200
    45.792    -0.201     0.200
    45.792    -1.317     0.200
    46.141    -0.793     0.200
    54.622     0.585     0.200
    55.559    -1.576     0.200
    55.593     0.980     0.200
    55.772    -0.015     0.200
    77.876     0.714     0.200
    80.725     0.507     0.200
    82.133     1.883     0.200
    82.398     1.330     0.200
    82.510     1.392     0.200
    82.608     1.600     0.200
    82.828     1.609     0.200
    83.669     0.200     0.200
    85.170    -0.281     0.200
    85.170    -1.392     0.200
    85.309     0.825     0.200
    85.309     0.450     0.200
    85.444     1.201     0.200
    15.009     4.859     0.200
    15.669     2.874     0.200
    15.850     2.445     0.200
    16.080     3.518     0.200
    16.140     2.028     0.200
    16.381     3.685     0.200
    16.570     1.917     0.200
    17.023     2.963     0.200
    17.307     3.102     0.200
    17.307     2.449     0.200
    17.306     2.448     0.200
    17.364     1.864     0.200
    17.527     2.396     0.200
    17.593     0.990     0.200
    17.724     1.343     0.200
    18.116     2.007     0.200
    18.321     1.901     0.200
    18.629    -0.278     0.200
    19.152     0.263     0.200
    19.369    -0.744     0.200
    19.421     0.346     0.200
    19.892     0.704     0.200
    19.954     0.675     0.200
    20.102     0.315     0.200
    20.574    -0.548     0.200
    20.881     0.177     0.200
    21.120    -0.450     0.200
    21.145     1.728     0.200
    21.232     2.312     0.200
    21.498     0.059     0.200
    21.549     1.923     0.200
    21.646     2.625     0.200
    21.692     2.351     0.200
    21.823     2.151     0.200
    21.863     1.608     0.200
    21.946     0.317     0.200
    22.002     2.336     0.200
    22.153     2.109     0.200
    22.495    -1.564     0.200
    22.638     2.318     0.200
    22.659     2.052     0.200
    22.666     2.194     0.200
    22.684    -0.398     0.200
    23.144     1.697     0.200
    23.305     1.147     0.200
    23.439     1.779     0.200
    23.499    -0.624     0.200
    24.195    -0.036     0.200
    24.425     0.129     0.200
    24.437     2.314     0.200
    24.437     2.482     0.200
    24.548     1.271     0.200
    24.810     0.520     0.200
    24.841     2.288     0.200
    25.001     0.284     0.200
    25.101    -0.536     0.200
    25.262     2.321     0.200
    25.309    -0.071     0.200
    25.455     1.809     0.200
    25.455     1.359     0.200
    25.455     1.354     0.200
    25.650     1.828     0.200
    27.860     1.386     0.200
    30.087     1.799     0.200
    32.436     1.737     0.200
    36.840    -0.503     0.200
    55.265     0.010     0.200
    23.946     0.908     0.200
    24.923     0.232     0.200
    15.590     4.054     0.200
    16.861     2.456     0.200
    18.037     0.956     0.200
    18.290     0.332     0.200
    18.290    -0.559     0.200
    18.374    -0.095     0.200
    18.355    -0.645     0.200
    18.414    -0.496     0.200
    18.416    -0.902     0.200
    18.445    -0.801     0.200
    18.486    -0.908     0.200
    18.465    -0.946     0.200
    18.504    -0.874     0.200
    18.515    -0.360     0.200
    18.558    -1.307     0.200
    18.668     0.079     0.200
    18.708    -0.475     0.200
    18.711     0.273     0.200
    18.716    -0.504     0.200
    18.763    -0.243     0.200
    18.768    -1.121     0.200
    18.821     0.077     0.200
    18.828     0.108     0.200
    18.884    -0.673     0.200
    18.882     0.288     0.200
    18.903    -0.881     0.200
    18.926    -0.984     0.200
    18.978    -0.883     0.200
    19.018    -1.208     0.200
    19.081    -1.168     0.200
    19.127    -0.401     0.200
    19.254     0.766     0.200
    19.345    -1.872     0.200
    19.392     0.426     0.200
    19.450     0.028     0.200
    19.474    -0.433     0.200
    19.505    -0.342     0.200
    19.657    -1.363     0.200
    19.674    -1.160     0.200
    19.811     0.186     0.200
    20.052    -0.248     0.200
    20.066    -0.842     0.200
    20.143     0.239     0.200
    20.152     0.199     0.200
    20.431    -0.413     0.200
    20.525     1.035     0.200
    20.528     0.868     0.200
    20.615    -0.589     0.200
    20.630    -0.630     0.200
    20.649    -0.584     0.200
    20.693    -0.209     0.200
    21.076    -0.999     0.200
    21.228     0.495     0.200
    21.326    -0.697     0.200
    21.341    -1.651     0.200
    21.500    -0.505     0.200
    21.527    -1.329     0.200
    21.548    -1.151     0.200
    21.544    -0.530     0.200
    21.553     0.328     0.200
    21.679    -0.828     0.200
    21.727     0.133     0.200
    21.830     0.159     0.200
    22.068    -0.387     0.200
    22.264    -1.885     0.200
    22.264    -1.014     0.200
    22.322    -0.969     0.200
    22.323    -0.428     0.200
    22.475    -1.015     0.200
    22.492     0.328     0.200
    22.546    -0.329     0.200
    22.589    -0.978     0.200
    22.727     0.381     0.200
    22.737    -1.151     0.200
    22.831    -0.377     0.200
    22.829     0.081     0.200
    22.879     0.002     0.200
    22.962    -0.813     0.200
    23.098    -0.966     0.200
    23.118    -0.545     0.200
    23.163    -1.787     0.200
    23.163    -0.877     0.200
    23.175    -0.808     0.200
    23.242    -1.155     0.200
    23.351    -1.242     0.200
    23.401    -0.514     0.200
    23.746    -1.372     0.200
    23.789    -0.593     0.200
    23.810    -0.233     0.200
    23.925    -0.393     0.200
    23.988    -0.410     0.200
    24.043     4.205     0.200
    24.056     3.036     0.200
    24.056     0.876     0.200
    24.125    -0.925     0.200
    24.019     3.435     0.200
    24.319    -1.145     0.200
    24.344    -1.266     0.200
    24.457    -1.270     0.200
    24.462    -0.475     0.200
    24.624    -1.088     0.200
    24.707    -0.212     0.200
    24.707    -1.079     0.200
    24.707     0.351     0.200
    24.711    -1.181     0.200
    24.836    -0.424     0.200
    24.956    -0.608     0.200
    25.015     0.950     0.200
    25.015    -0.397     0.200
    25.017    -0.498     0.200
    25.059    -1.153     0.200
    25.059    -0.664     0.200
    25.096    -0.478     0.200
    25.184    -0.213     0.200
    25.311    -1.607     0.200
    25.330    -1.341     0.200
    25.604    -0.758     0.200
    25.958     1.174     0.200
    27.461     1.816     0.200
    30.516    -0.410     0.200
    30.516    -0.191     0.200
    32.415    -1.123     0.200
    33.170    -1.428     0.200
    36.386     0.292     0.200
    36.386    -0.009     0.200
    36.500    -0.279     0.200
    39.355    -0.676     0.200
    39.779    -0.547     0.200
    41.864    -0.511     0.200
    41.914    -0.808     0.200
    43.791    -0.336     0.200
    45.773    -1.007     0.200
    45.773    -0.156     0.200
    52.965     1.192     0.200
    53.553     1.205     0.200
    53.553     0.955     0.200
    54.943    -0.291     0.200
    54.842    -1.655     0.200
    54.851     1.501     0.200
    54.851    -0.659     0.200
    54.956    -0.476     0.200
    54.977    -1.380     0.200
    55.776    -0.759     0.200
    56.012     0.196     0.200
    63.146    -0.188     0.200
    63.875     1.072     0.200
    65.175    -0.311     0.200
    71.061    -0.782     0.200
    71.512     0.763     0.200
    80.672     0.880     0.200
    80.955     2.466     0.200
    85.221     1.075     0.200
    85.221    -0.484     0.200
    85.312     1.619     0.200
    87.001    -1.339     0.200
    87.001    -1.212     0.200
    15.353     2.729     0.200
    15.353     2.589     0.200
    15.353     2.870     0.200
    16.524     3.034     0.200
    16.524     2.503     0.200
    16.524     3.925     0.200
    17.816     0.141     0.200
    18.971     0.771     0.200
    19.187     1.886     0.200
    21.187     1.198     0.200
    21.791    -0.492     0.200
    21.842    -0.006     0.200
    22.692    -0.840     0.200
    23.268    -1.587     0.200
    23.858     1.845     0.200
    23.858     1.314     0.200
    23.983     2.382     0.200
    24.045     0.786     0.200
    24.228     0.085     0.200
    24.228    -0.387     0.200
    24.228     0.476     0.200
    24.581     0.176     0.200
    24.682     2.843     0.200
    24.684     0.168     0.200
    24.684    -0.312     0.200
    24.684     1.320     0.200
    25.388    -0.512     0.200
    25.520     0.129     0.200
    25.614    -0.151     0.200
    25.637    -1.054     0.200
    26.389    -1.505     0.200
    26.665     0.814     0.200
    27.225     1.118     0.200
    28.211    -0.756     0.200
    30.082    -0.392     0.200
    31.721     0.447     0.200
    31.985    -1.416     0.200
    31.985    -0.763     0.200
    32.683     1.738     0.200
    32.691    -1.175     0.200
    35.988    -0.890     0.200
    35.988    -0.679     0.200
    41.385    -0.945     0.200
    41.437    -0.678     0.200
    43.315    -1.071     0.200
    44.538    -1.420     0.200
    45.296    -0.793     0.200
    45.296    -1.441     0.200
    48.708     2.609     0.200
    48.708     2.383     0.200
    51.636     0.862     0.200
    51.704     3.740     0.200
    51.754     1.394     0.200
    52.684     1.375     0.200
    52.684     0.023     0.200
    53.235     0.036     0.200
    53.235     0.973     0.200
    53.620     1.633     0.200
    54.584     1.041     0.200
    54.584     0.338     0.200
    54.979    -0.228     0.200
    55.486    -0.246     0.200
    61.645     0.639     0.200
    61.777     1.798     0.200
    62.870     1.521     0.200
    63.823     0.869     0.200
    66.281     1.195     0.200
    70.612    -1.223     0.200
    71.080    -0.278     0.200
    73.115     0.848     0.200
    77.518     0.321     0.200
    78.821     0.714     0.200
    80.172     0.305     0.200
    80.192     0.684     0.200
    80.806     0.419     0.200
    80.952     1.345     0.200
    81.621     1.280     0.200
    82.086     0.549     0.200
    83.354    -0.276     0.200
    83.791     0.366     0.200
    84.014     1.386     0.200
    84.612     1.745     0.200
    84.612     0.706     0.200
    84.766    -0.141     0.200
    84.766     0.297     0.200
    84.800     1.736     0.200
    84.827     0.304     0.200
    84.827     0.527     0.200
    84.849     0.946     0.200
    84.906     1.434     0.200
    85.005     0.412     0.200
    86.046     0.802     0.200
    86.344    -1.789     0.200
    86.458    -0.795     0.200
    87.107     2.004     0.200
    87.259     0.255     0.200
    87.525     1.080     0.200
    87.807     0.539     0.200
    87.869    -0.719     0.200
    87.976    -1.238     0.200
    88.618     1.222     0.200
    88.966     0.686     0.200
    89.506     1.276     0.200
    90.393    -1.363     0.200
    90.614     0.581     0.200
    90.822     0.174     0.200
    91.058     0.420     0.200
    92.330     0.381     0.200
    92.330    -0.048     0.200
    92.394     1.077     0.200
    92.921     0.223     0.200
    93.077     0.050     0.200
    93.182     0.892     0.200
    94.322    -0.278     0.200
    94.573     1.393     0.200
    94.573     1.557     0.200
    95.351     0.925     0.200
    95.463     1.542     0.200
    96.263     1.535     0.200
    96.824     0.290     0.200
    97.538     0.710     0.200
    23.239     3.248     0.200
    53.851     1.163     0.200
    20.764     1.444     0.200
    21.225     0.588     0.200
    23.326     3.350     0.200
    23.967     2.284     0.200
    23.967     0.664     0.200
    43.789     0.715     0.200
    52.613     1.350     0.200
    52.639     1.917     0.200
    53.945    -0.261     0.200
    53.945     0.970     0.200
    54.471     0.590     0.200
    54.817     1.416     0.200
    83.930    -0.460     0.200
    83.930     0.720     0.200
    23.284     3.456     0.200
    23.907     2.406     0.200
    53.892     0.746     0.200
    18.254    -0.090     0.200
    18.254    -0.364     0.200
    18.378     1.989     0.200
    18.371    -0.780     0.200
    18.450     0.800     0.200
    18.667    -0.827     0.200
    18.739     0.273     0.200
    18.743     0.098     0.200
    18.775     1.749     0.200
    18.818    -0.836     0.200
    18.840    -1.335     0.200
    18.871    -0.944     0.200
    18.924    -0.958     0.200
    19.003     1.727     0.200
    19.070    -1.605     0.200
    19.151     1.183     0.200
    19.249     2.583     0.200
    19.282     3.210     0.200
    19.282     1.632     0.200
    19.282     2.051     0.200
    19.350     0.520     0.200
    19.397    -0.870     0.200
    19.441    -0.822     0.200
    19.575    -0.285     0.200
    19.613    -1.370     0.200
    19.631    -0.714     0.200
    20.018    -1.847     0.200
    20.114    -1.120     0.200
    20.367    -0.507     0.200
    20.425     0.953     0.200
    20.416    -1.382     0.200
    20.554     1.244     0.200
    20.583    -0.465     0.200
    20.599    -1.356     0.200
    20.600    -0.475     0.200
    20.608    -1.256     0.200
    21.038    -0.666     0.200
    21.303     2.742     0.200
    21.379     2.432     0.200
    21.561     2.482     0.200
    21.878    -1.270     0.200
    22.027    -1.575     0.200
    22.145     1.902     0.200
    22.227    -0.988     0.200
    22.293    -1.038     0.200
    22.301    -1.099     0.200
    22.301    -0.759     0.200
    22.301    -0.146     0.200
    22.382     3.015     0.200
    22.466    -1.502     0.200
    22.512    -0.965     0.200
    22.626     0.700     0.200
    22.801    -0.501     0.200
    22.955    -2.246     0.200
    23.032    -1.546     0.200
    23.088    -1.343     0.200
    23.164    -1.076     0.200
    23.291     1.820     0.200
    23.329    -1.199     0.200
    23.949     0.745     0.200
    23.949     1.718     0.200
    24.178    -0.951     0.200
    24.253     1.758     0.200
    24.336    -1.422     0.200
    24.081     4.891     0.200
    24.081     2.563     0.200
    24.458    -1.034     0.200
    24.608    -1.298     0.200
    24.684    -0.630     0.200
    24.684    -1.048     0.200
    24.684    -0.189     0.200
    24.892     1.800     0.200
    24.922    -0.014     0.200
    24.922     0.994     0.200
    25.049    -0.365     0.200
    25.049    -0.615     0.200
    25.096    -1.627     0.200
    25.176     1.243     0.200
    25.169    -1.493     0.200
    25.284    -1.716     0.200
    25.753    -1.183     0.200
    25.896    -0.571     0.200
    26.851     1.266     0.200
    29.835     0.759     0.200
    29.895     0.045     0.200
    30.451    -0.999     0.200
    32.200     0.987     0.200
    32.349    -1.332     0.200
    32.349    -1.563     0.200
    32.349    -0.281     0.200
    32.959     4.044     0.200
    33.157    -1.136     0.200
    35.308    -2.762     0.200
    35.451    -1.171     0.200
    36.309    -0.251     0.200
    36.309     0.120     0.200
    36.479    -1.110     0.200
    39.333    -1.226     0.200
    44.803    -1.331     0.200
    44.803     0.033     0.200
    45.741    -1.399     0.200
    46.181    -1.514     0.200
    50.024    -0.331     0.200
    50.564     0.941     0.200
    51.103    -0.989     0.200
    51.345     0.400     0.200
    51.487     1.445     0.200
    51.816     1.082     0.200
    51.920     1.060     0.200
    52.057     1.515     0.200
    52.684    -0.727     0.200
    52.865     0.914     0.200
    53.201     2.881     0.200
    54.749     1.275     0.200
    54.749     0.423     0.200
    54.749     0.744     0.200
    54.850     0.830     0.200
    54.872     1.310     0.200
    54.965     1.363     0.200
    54.995     0.259     0.200
    54.993     0.506     0.200
    55.143     1.495     0.200
    55.677     0.084     0.200
    56.235    -0.859     0.200
    58.357     1.175     0.200
    58.707    -0.705     0.200
    60.240     9.658     0.200
    60.124     0.447     0.200
    71.446    -0.508     0.200
    76.750     2.174     0.200
    77.892    -0.008     0.200
    78.367     1.675     0.200
    80.632     0.370     0.200
    80.652    -0.074     0.200
    80.845     0.519     0.200
    80.845     0.410     0.200
    83.570    -0.390     0.200
    84.198     0.353     0.200
    85.167     0.652     0.200
    85.167    -1.141     0.200
    85.266    -0.413     0.200
    85.321     0.981     0.200
    85.321    -0.644     0.200
    85.378     1.149     0.200
    85.651     2.285     0.200
    85.962     2.353     0.200
    87.023    -0.868     0.200
    87.023    -0.620     0.200
    88.283    -0.556     0.200
    89.350     1.334     0.200
    89.666     1.282     0.200
    91.319     0.188     0.200
    93.633     0.153     0.200
    94.131     0.230     0.200
    97.020    -0.148     0.200
    99.539    -0.580     0.200
    99.539    -1.271     0.200
    24.703     1.700     0.200
    19.409     0.198     0.200
    19.577     0.423     0.200
    21.081     2.484     0.200
    21.074    -0.552     0.200
    21.333     2.356     0.200
    22.194    -0.996     0.200
    22.194    -1.425     0.200
    22.273    -0.934     0.200
    22.273    -1.324     0.200
    23.064    -1.534     0.200
    23.144    -0.851     0.200
    23.144    -1.742     0.200
    23.163    -1.540     0.200
    23.244     2.757     0.200
    23.244     1.366     0.200
    23.713    -1.792     0.200
    23.835     2.517     0.200
    23.903     2.108     0.200
    23.903     2.542     0.200
    24.206     1.430     0.200
    24.087     3.019     0.200
    24.087     3.300     0.200
    24.656    -1.009     0.200
    24.656    -1.252     0.200
    24.876    -1.076     0.200
    24.876     0.732     0.200
    25.024    -1.046     0.200
    27.310     0.918     0.200
    30.410    -1.348     0.200
    31.045    -2.870     0.200
    31.252     3.221     0.200
    33.132    -1.905     0.200
    35.151    -0.059     0.200
    36.265    -0.385     0.200
    40.851     0.171     0.200
    41.652     1.457     0.200
    41.825    -1.791     0.200
    43.763    -1.526     0.200
    44.757    -1.381     0.200
    44.757    -0.315     0.200
    45.710    -2.000     0.200
    48.777     8.677     0.200
    50.477     7.370     0.200
    51.873     1.173     0.200
    52.637     7.983     0.200
    53.412     0.493     0.200
    54.702     0.123     0.200
    54.702     0.815     0.200
    55.630    -0.357     0.200
    55.862     0.198     0.200
    57.772    -0.033     0.200
    60.285     8.258     0.200
    61.215     0.888     0.200
    61.386    -0.640     0.200
    61.674     0.687     0.200
    61.740     0.735     0.200
    70.965    -1.220     0.200
    71.405    -0.283     0.200
    73.240    -0.275     0.200
    84.160     0.409     0.200
    84.986     1.109     0.200
    85.067     1.567     0.200
    85.128    -1.131     0.200
    85.128    -0.186     0.200
    85.362     1.625     0.200
    85.641     1.719     0.200
    85.947     1.991     0.200
    86.502     1.937     0.200
    89.620     0.032     0.200
    89.620     0.981     0.200
    90.677     1.569     0.200
    94.537    -0.608     0.200
    95.173     6.849     0.200
    95.006     1.253     0.200
    95.897     1.858     0.200
    96.005     0.666     0.200
    96.694     1.576     0.200
    96.777     0.316     0.200
    97.966     0.610     0.200
    99.233    -0.555     0.200
    25.346    -1.283     0.200
    45.166    -1.900     0.200
    15.702     5.351     0.200
    19.205     1.372     0.200
    19.606     2.011     0.200
    20.694     2.452     0.200
    20.690     2.587     0.200
    20.748     2.704     0.200
    21.074     1.754     0.200
    21.080     2.813     0.200
    22.269     1.667     0.200
    23.041     1.061     0.200
    23.294     1.653     0.200
    23.127     4.700     0.200
    23.873     2.374     0.200
    31.032     1.347     0.200
    31.065     1.097     0.200
    31.054     1.353     0.200
    31.183     1.043     0.200
    32.508     0.929     0.200
    49.052     2.483     0.200
    49.052     0.920     0.200
    58.680     1.862     0.200
    60.362     1.277     0.200
    60.977     1.282     0.200
    61.942     1.498     0.200
    91.019     0.200     0.200
    91.019     0.469     0.200
    15.706     5.369     0.200
    21.192     0.242     0.200
    22.931    -0.141     0.200
    23.066     0.167     0.200
    23.877     0.646     0.200
    32.530     0.043     0.200
    49.064     2.668     0.200
    52.269     0.731     0.200
    53.877     0.292     0.200
    58.686     0.286     0.200
    66.932     2.339     0.200
    16.593     1.135     0.200
    17.064     1.085     0.200
    18.010     0.252     0.200
    19.222    -0.320     0.200
    19.222     0.473     0.200
    20.073     0.549     0.200
    21.056     0.501     0.200
    23.061     0.411     0.200
    23.287     0.435     0.200
    23.546     0.903     0.200
    23.874     0.921     0.200
    31.024    -0.427     0.200
    32.527     0.424     0.200
    44.309    -0.731     0.200
    48.040    -0.624     0.200
    49.064     0.178     0.200
    49.064     0.311     0.200
    53.875     1.562     0.200
    53.875     0.351     0.200
    55.093     0.501     0.200
    66.933     1.519     0.200
    66.933     0.855     0.200
    44.772    -2.292     0.200
    16.998     3.422     0.200
    19.919    -0.198     0.200
    20.531     2.165     0.200
    20.868    -0.680     0.200
    20.889    -0.722     0.200
    20.893    -0.862     0.200
    21.313     0.554     0.200
    21.327    -1.433     0.200
    22.516    -0.524     0.200
    22.591     0.014     0.200
    22.752    -1.082     0.200
    22.978     0.911     0.200
    23.012    -0.849     0.200
    23.394     1.403     0.200
    23.375    -1.323     0.200
    23.390    -0.040     0.200
    23.444    -1.336     0.200
    23.481    -0.176     0.200
    23.486    -1.140     0.200
    23.619    -1.288     0.200
    24.023    -1.109     0.200
    24.050    -0.537     0.200
    24.092     3.605     0.200
    24.092     1.430     0.200
    24.497     1.593     0.200
    24.468    -0.872     0.200
    24.621    -1.826     0.200
    24.957    -0.218     0.200
    24.974    -0.689     0.200
    25.140     0.182     0.200
    25.140     0.942     0.200
    25.377    -0.420     0.200
    25.810     0.872     0.200
    26.247    -1.384     0.200
    27.083    -1.125     0.200
    27.140    -1.385     0.200
    27.705    -2.101     0.200
    28.782     0.150     0.200
    29.367    -1.006     0.200
    33.444    -0.591     0.200
    34.022    -0.324     0.200
    34.187    -0.019     0.200
    36.563    -0.336     0.200
    36.769    -0.730     0.200
    40.509    -0.128     0.200
    45.033    -0.874     0.200
    46.032    -1.452     0.200
    46.442    -0.305     0.200
    52.101     1.030     0.200
    54.734     0.086     0.200
    54.930     1.095     0.200
    54.930     0.816     0.200
    55.011     0.148     0.200
    55.870     0.069     0.200
    56.077     0.175     0.200
    56.598     0.583     0.200
    59.212     0.220     0.200
    61.883     0.593     0.200
    62.840     1.492     0.200
    65.997     1.805     0.200
    65.997     0.700     0.200
    78.166     0.523     0.200
    80.957     2.242     0.200
    80.941     0.459     0.200
    85.448     0.994     0.200
    85.556     0.956     0.200
    85.556     0.664     0.200
    85.595     1.277     0.200
    87.073    -0.000     0.200
    91.104     0.114     0.200
    93.081    -0.353     0.200
    95.326     2.636     0.200
    96.049     2.791     0.200
    97.215     0.248     0.200
    18.427    -2.122     0.200
    19.812     0.648     0.200
    19.812     0.450     0.200
    19.803     0.491     0.200
    20.103    -0.661     0.200
    20.181    -0.487     0.200
    20.296    -1.724     0.200
    20.637    -0.506     0.200
    20.748     0.344     0.200
    21.019    -0.098     0.200
    21.368     0.983     0.200
    21.220    -1.303     0.200
    21.315    -1.096     0.200
    21.405    -1.533     0.200
    21.554     0.134     0.200
    21.592    -1.390     0.200
    22.403    -0.402     0.200
    22.403    -1.771     0.200
    22.398    -2.062     0.200
    22.398    -1.602     0.200
    22.625     1.405     0.200
    22.642     2.111     0.200
    23.772     0.933     0.200
    23.776     3.403     0.200
    23.776     4.733     0.200
    24.455     2.982     0.200
    24.468     1.618     0.200
    24.505     0.425     0.200
    24.791    -0.565     0.200
    24.791    -0.936     0.200
    25.095    -0.589     0.200
    25.367     0.494     0.200
    25.367     2.093     0.200
    25.601    -1.750     0.200
    26.103    -1.603     0.200
    26.133    -1.135     0.200
    26.194    -0.992     0.200
    27.329     0.346     0.200
    27.861     0.535     0.200
    29.184     4.188     0.200
    30.758    -0.529     0.200
    31.120    -0.584     0.200
    31.277    -0.906     0.200
    31.613     0.139     0.200
    32.388     0.272     0.200
    32.663    -1.365     0.200
    33.214    -1.278     0.200
    35.396    -1.684     0.200
    36.058    -0.752     0.200
    36.677    -0.180     0.200
    36.677    -0.700     0.200
    39.368     1.136     0.200
    40.097    -0.621     0.200
    41.218    -0.886     0.200
    41.941    -0.566     0.200
    42.469    -2.301     0.200
    45.226    -0.905     0.200
    45.887    -0.524     0.200
    45.887    -0.174     0.200
    47.381     0.159     0.200
    47.885    -0.518     0.200
    48.212     2.757     0.200
    48.212     0.857     0.200
    49.782     0.855     0.200
    49.872     2.158     0.200
    50.633     1.639     0.200
    51.262     1.653     0.200
    51.862     2.088     0.200
    52.111     2.519     0.200
    53.177     0.263     0.200
    53.971     0.746     0.200
    53.971     1.597     0.200
    53.913     1.115     0.200
    54.303     0.745     0.200
    55.239     0.716     0.200
    55.239     1.175     0.200
    55.634     0.327     0.200
    56.881    -1.515     0.200
    58.851    -1.095     0.200
    59.456     1.349     0.200
    59.863     1.360     0.200
    62.288     1.474     0.200
    78.190     1.497     0.200
    80.713     0.630     0.200
    80.739     1.673     0.200
    81.377     1.016     0.200
    84.030     0.750     0.200
    85.267     1.935     0.200
    85.267     1.604     0.200
    85.420     1.268     0.200
    85.430     1.338     0.200
    92.866     1.402     0.200
    97.493     0.264     0.200
    17.385     2.780     0.200
    19.492     1.876     0.200
    19.948     1.182     0.200
    23.083     0.992     0.200
    18.620    -1.606     0.200
    19.174     0.308     0.200
    19.433     1.455     0.200
    19.433     0.655     0.200
    20.866    -0.241     0.200
    21.733    -0.464     0.200
    21.953    -1.310     0.200
    22.377     0.840     0.200
    22.589    -2.088     0.200
    22.674    -0.422     0.200
    22.709    -2.118     0.200
    22.709    -1.468     0.200
    22.643     1.858     0.200
    23.617    -2.448     0.200
    23.869     3.543     0.200
    23.883     1.666     0.200
    24.170    -1.770     0.200
    24.771    -1.260     0.200
    24.560     4.796     0.200
    24.560     2.566     0.200
    24.902    -1.341     0.200
    25.018     0.295     0.200
    25.018     0.616     0.200
    25.086    -1.015     0.200
    25.086    -0.455     0.200
    25.086    -0.555     0.200
    25.390    -0.953     0.200
    25.479    -1.546     0.200
    25.546    -1.398     0.200
    25.868     1.142     0.200
    26.887     1.672     0.200
    27.331     1.732     0.200
    28.492    -1.212     0.200
    30.709    -1.418     0.200
    31.313    -2.091     0.200
    32.601    -2.207     0.200
    33.363     2.657     0.200
    33.363     1.047     0.200
    33.582    -2.016     0.200
    36.503    -0.893     0.200
    36.503    -0.043     0.200
    44.927    -1.303     0.200
    48.358     1.140     0.200
    51.489     1.189     0.200
    51.841     0.784     0.200
    51.928     1.229     0.200
    52.889     1.421     0.200
    52.938    -1.124     0.200
    53.532     0.419     0.200
    53.532     0.739     0.200
    53.965     1.087     0.200
    54.757     1.501     0.200
    54.757     0.550     0.200
    54.757     0.391     0.200
    55.149     0.821     0.200
    61.767     0.358     0.200
    63.017     0.935     0.200
    63.108     0.712     0.200
    65.434     0.338     0.200
    71.291    -0.897     0.200
    71.291    -0.427     0.200
    73.258     1.236     0.200
    81.958     0.995     0.200
    82.207     1.140     0.200
    82.356     1.880     0.200
    82.474     1.303     0.200
    82.560     1.467     0.200
    82.599     1.112     0.200
    82.738     1.510     0.200
    82.850     1.346     0.200
    82.949     1.283     0.200
    82.949     1.033     0.200
    82.967     1.089     0.200
    82.976     1.174     0.200
    83.087     1.576     0.200
    83.170     1.578     0.200
    83.168     1.298     0.200
    85.255     2.805     0.200
    85.548     1.482     0.200
    85.548     2.252     0.200
    85.618     0.978     0.200
    85.631     0.792     0.200
    85.785    -0.019     0.200
    85.846     1.736     0.200
    85.910     1.619     0.200
    86.084     1.914     0.200
    86.132     1.977     0.200
    87.880     0.510     0.200
    87.991     1.190     0.200
    91.893    -0.104     0.200
    91.958     0.488     0.200
    92.985     0.293     0.200
    93.159     1.260     0.200
    93.207    -0.362     0.200
    93.219     0.886     0.200
    93.947     1.205     0.200
    93.973     0.826     0.200
    94.477     1.079     0.200
    94.596    -0.166     0.200
    94.624     1.077     0.200
    95.444     2.117     0.200
    96.335     0.311     0.200
    96.569     1.070     0.200
    97.129     1.301     0.200
    97.059    -0.508     0.200
    97.613     0.996     0.200
    98.396     0.288     0.200
    15.538     4.451     0.200
    15.986     3.151     0.200
    16.482     2.777     0.200
    18.651     1.907     0.200
    21.286     2.272     0.200
    22.660    -2.102     0.200
    23.374     2.494     0.200
    23.374     3.014     0.200
    23.492    -2.384     0.200
    23.520    -1.279     0.200
    23.673    -1.695     0.200
    24.598     1.641     0.200
    25.004    -0.846     0.200
    24.897     3.723     0.200
    31.047     1.768     0.200
    36.548    -0.698     0.200
    44.152     2.235     0.200
    44.526    -0.668     0.200
    54.279     0.888     0.200
    54.279     0.107     0.200
    77.882     0.230     0.200
    85.239     1.013     0.200
    85.239     1.403     0.200
    85.495     0.754     0.200
    85.869     1.250     0.200
    85.869     1.434     0.200
    96.598     0.404     0.200
    19.241     6.017     0.200
    22.812     2.179     0.200
    22.949     1.839     0.200
    23.996     1.148     0.200
    63.880     0.777     0.200
    16.637     3.487     0.200
    19.625     2.955     0.200
    24.193     1.597     0.200
    24.809    -0.934     0.200
    44.610    -1.662     0.200
    54.811     0.067     0.200
    81.192     0.000     0.200
    14.626     5.276     0.200
    15.253     5.091     0.200
    15.515     3.284     0.200
    16.267     2.798     0.200
    16.354     5.141     0.200
    17.135     1.148     0.200
    18.127     0.629     0.200
    18.273     0.192     0.200
    19.366    -1.845     0.200
    19.728     1.306     0.200
    22.319     1.949     0.200
    24.438    -1.706     0.200
    24.549     1.008     0.200
    24.549     1.246     0.200
    25.302    -0.544     0.200
    25.302    -0.767     0.200
    25.795    -0.387     0.200
    29.109    -0.210     0.200
    30.740    -0.215     0.200
    32.451    -2.694     0.200
    32.451    -1.987     0.200
    45.129    -2.342     0.200
    45.129    -1.557     0.200
    45.553    -2.634     0.200
    46.343    -1.576     0.200
    52.772    -1.126     0.200
    54.881    -1.153     0.200
    59.444    -0.647     0.200
    77.960    -0.929     0.200
    15.258     3.624     0.200
    16.552     4.357     0.200
    16.552     3.919     0.200
    16.552     3.251     0.200
    16.614     4.308     0.200
    17.459     3.682     0.200
    19.061     3.314     0.200
    19.060     2.557     0.200
    19.061     2.962     0.200
    19.472     0.555     0.200
    19.551     2.940     0.200
    19.560     0.956     0.200
    19.700     3.989     0.200
    20.048     2.730     0.200
    20.133     2.743     0.200
    20.194     3.119     0.200
    20.198     3.087     0.200
    20.176     0.603     0.200
    20.276     0.325     0.200
    20.329     2.301     0.200
    20.350     2.725     0.200
    20.301     0.188     0.200
    20.368     3.241     0.200
    20.375     1.917     0.200
    20.385     1.810     0.200
    20.418     0.942     0.200
    20.404     0.891     0.200
    20.457     0.126     0.200
    20.632     3.760     0.200
    21.154     2.349     0.200
    21.756     0.462     0.200
    22.076    -0.352     0.200
    22.162    -0.853     0.200
    22.178    -1.409     0.200
    22.178    -1.526     0.200
    22.178    -1.229     0.200
    22.324     0.462     0.200
    22.998     4.256     0.200
    23.723     2.558     0.200
    23.723     2.878     0.200
    24.428     2.250     0.200
    24.577     2.333     0.200
    24.557    -0.305     0.200
    24.557    -0.647     0.200
    24.557    -0.502     0.200
    24.699     0.206     0.200
    24.793    -0.815     0.200
    24.944    -0.986     0.200
    25.481     0.427     0.200
    25.706    -0.988     0.200
    25.706    -0.613     0.200
    25.935     2.264     0.200
    26.625     1.524     0.200
    26.618     1.575     0.200
    26.618     1.362     0.200
    27.129     1.637     0.200
    27.828     1.419     0.200
    29.710     3.744     0.200
    29.847     0.452     0.200
    30.191    -0.595     0.200
    30.272     2.183     0.200
    30.314     1.300     0.200
    30.540     2.083     0.200
    30.675     4.789     0.200
    30.647     1.944     0.200
    30.838     1.484     0.200
    30.873     1.915     0.200
    30.873     1.790     0.200
    30.888    -0.874     0.200
    30.962    -1.205     0.200
    31.563     2.033     0.200
    31.686     0.332     0.200
    32.155    -1.362     0.200
    32.354    -0.297     0.200
    33.089     2.819     0.200
    33.089     0.287     0.200
    33.320     2.067     0.200
    33.336    -1.171     0.200
    33.577    -0.811     0.200
    35.226     1.729     0.200
    35.233     1.139     0.200
    35.207     0.754     0.200
    35.207     0.453     0.200
    35.527    -1.547     0.200
    35.928    -0.978     0.200
    35.928    -1.202     0.200
    36.101    -0.760     0.200
    36.101    -0.260     0.200
    36.101    -0.542     0.200
    36.132    -0.745     0.200
    36.607     1.776     0.200
    37.237    -0.150     0.200
    37.237     0.190     0.200
    38.016     0.852     0.200
    38.187    -0.161     0.200
    38.280     0.826     0.200
    39.386    -0.242     0.200
    39.800     1.187     0.200
    39.811     0.820     0.200
    39.909     3.039     0.200
    39.909     1.992     0.200
    40.025     3.377     0.200
    40.025     0.267     0.200
    40.128     0.812     0.200
    40.216     0.651     0.200
    40.272    -0.323     0.200
    40.437     0.706     0.200
    40.469     0.624     0.200
    40.578     1.587     0.200
    41.802    -0.975     0.200
    42.029    -0.547     0.200
    42.254    -1.187     0.200
    43.218     2.360     0.200
    43.691    -0.811     0.200
    44.374     1.714     0.200
    44.374     1.974     0.200
    44.584    -1.214     0.200
    44.650    -0.846     0.200
    44.845     1.630     0.200
    44.845     1.460     0.200
    44.845     0.600     0.200
    45.599    -0.786     0.200
    45.599    -1.202     0.200
    46.131     2.046     0.200
    47.669     1.579     0.200
    48.089    -0.083     0.200
    48.089     0.040     0.200
    48.939     2.445     0.200
    49.011     3.221     0.200
    48.946     4.004     0.200
    48.957     2.311     0.200
    48.957     1.411     0.200
    49.051     2.692     0.200
    49.062     2.773     0.200
    49.191     3.115     0.200
    49.208     3.013     0.200
    49.208     2.904     0.200
    49.279     3.651     0.200
    49.326     2.688     0.200
    49.402     3.464     0.200
    49.893     3.417     0.200
    49.882     2.485     0.200
    50.463     2.484     0.200
    50.623     3.843     0.200
    50.649     2.496     0.200
    50.855     2.535     0.200
    51.156     0.837     0.200
    51.385     2.672     0.200
    51.437     2.581     0.200
    52.014     2.736     0.200
    52.145     3.142     0.200
    52.438     1.789     0.200
    52.615     2.650     0.200
    52.632     2.346     0.200
    52.797     3.286     0.200
    52.776     0.854     0.200
    53.052     2.557     0.200
    53.234     0.448     0.200
    53.234     0.211     0.200
    53.682     3.159     0.200
    53.907     0.795     0.200
    54.453     3.377     0.200
    54.453     3.260     0.200
    54.522     0.727     0.200
    54.522     0.987     0.200
    54.629     1.951     0.200
    54.629     2.250     0.200
    54.916     0.421     0.200
    54.916     0.622     0.200
    55.090     1.515     0.200
    55.225     0.190     0.200
    55.225     0.391     0.200
    55.735     3.654     0.200
    55.735     3.943     0.200
    55.975     2.323     0.200
    56.318    -0.894     0.200
    56.318    -1.234     0.200
    56.812     2.725     0.200
    56.812     2.844     0.200
    56.812     3.024     0.200
    56.921     1.304     0.200
    56.904     2.850     0.200
    57.337    -0.118     0.200
    57.681     2.746     0.200
    57.978     2.608     0.200
    57.898     3.031     0.200
    57.898     2.562     0.200
    58.034     1.110     0.200
    58.153     0.573     0.200
    58.268     2.348     0.200
    58.400     2.238     0.200
    58.854     0.022     0.200
    58.854    -0.748     0.200
    58.854    -0.322     0.200
    58.854    -1.078     0.200
    58.854    -0.607     0.200
    59.087     2.374     0.200
    59.453     1.140     0.200
    59.548     2.308     0.200
    59.577     1.439     0.200
    59.634     1.159     0.200
    59.634     1.047     0.200
    59.819     2.167     0.200
    59.880     2.449     0.200
    59.857     0.256     0.200
    59.970    -0.163     0.200
    60.117     2.271     0.200
    60.117     2.507     0.200
    60.404     0.890     0.200
    60.437    -0.390     0.200
    60.604     2.200     0.200
    60.670     0.816     0.200
    60.670     0.976     0.200
    60.702     1.002     0.200
    60.797     2.717     0.200
    60.921     2.885     0.200
    60.933     2.443     0.200
    60.933     2.062     0.200
    61.055     0.768     0.200
    61.173     0.180     0.200
    61.320     2.122     0.200
    61.320     0.883     0.200
    61.404     2.245     0.200
    61.494     1.572     0.200
    61.898     1.930     0.200
    61.892     1.528     0.200
    62.660     1.016     0.200
    62.814     1.309     0.200
    63.114     1.132     0.200
    63.114     1.421     0.200
    63.871     0.474     0.200
    64.158     1.443     0.200
    64.158     2.052     0.200
    64.158     0.552     0.200
    64.359     1.388     0.200
    64.359     1.048     0.200
    64.476     3.007     0.200
    64.702     0.921     0.200
    64.702     1.022     0.200
    65.036     2.057     0.200
    64.949     0.259     0.200
    64.949    -0.411     0.200
    65.017     0.671     0.200
    65.178     1.136     0.200
    65.272     1.362     0.200
    65.272     1.522     0.200
    65.684     0.600     0.200
    65.759     1.617     0.200
    65.750     1.449     0.200
    65.818     0.608     0.200
    65.874     0.852     0.200
    65.954     1.980     0.200
    65.924    -1.143     0.200
    66.043     1.772     0.200
    66.382     2.398     0.200
    66.537     1.022     0.200
    66.909     1.870     0.200
    66.909     0.860     0.200
    67.001     1.923     0.200
    66.970     1.111     0.200
    66.970     0.470     0.200
    67.312     1.470     0.200
    67.312     1.310     0.200
    67.834     1.829     0.200
    67.909     1.894     0.200
    67.864     1.238     0.200
    67.980     1.717     0.200
    68.040     1.653     0.200
    68.040     1.954     0.200
    68.340     1.263     0.200
    68.735     0.806     0.200
    68.786     1.824     0.200
    68.791     2.472     0.200
    69.082     1.441     0.200
    69.082     1.662     0.200
    69.074     1.708     0.200
    69.454     1.406     0.200
    69.454     1.166     0.200
    69.497     1.004     0.200
    69.497     1.983     0.200
    69.521     0.655     0.200
    69.842     2.626     0.200
    69.833     0.944     0.200
    69.785    -1.740     0.200
    69.945     1.983     0.200
    69.945     0.495     0.200
    70.221     1.672     0.200
    70.666     2.471     0.200
    70.666     2.693     0.200
    70.666     2.346     0.200
    71.011     0.252     0.200
    71.209     1.086     0.200
    71.344     1.066     0.200
    71.467     0.533     0.200
    71.788     0.704     0.200
    73.039     1.485     0.200
    73.039     1.680     0.200
    73.060     1.491     0.200
    74.810     2.901     0.200
    74.810     3.128     0.200
    74.810     1.981     0.200
    75.358     4.573     0.200
    75.358     2.498     0.200
    75.358     1.153     0.200
    76.559     1.623     0.200
    76.559     2.183     0.200
    76.559     2.402     0.200
    76.559     1.463     0.200
    76.978     1.772     0.200
    77.233     1.578     0.200
    77.288    -1.279     0.200
    77.380    -1.285     0.200
    77.388    -1.330     0.200
    77.391    -1.296     0.200
    77.404     0.233     0.200
    77.421    -1.235     0.200
    77.421    -1.273     0.200
    77.437     0.056     0.200
    77.437    -0.212     0.200
    77.437     0.345     0.200
    77.443    -1.268     0.200
    77.452    -1.271     0.200
    77.465    -1.238     0.200
    77.472    -1.234     0.200
    77.490    -1.234     0.200
    77.495    -1.264     0.200
    77.498    -1.269     0.200
    77.502    -1.273     0.200
    77.503    -1.267     0.200
    77.513    -1.235     0.200
    77.530    -1.232     0.200
    77.539    -0.651     0.200
    77.574     1.673     0.200
    77.589     0.050     0.200
    77.621     1.531     0.200
    77.702     0.556     0.200
    78.165    -0.206     0.200
    78.222     0.240     0.200
    78.222    -0.219     0.200
    78.437     0.092     0.200
    78.607     6.305     0.200
    78.619     0.590     0.200
    78.623     5.733     0.200
    78.634     4.855     0.200
    78.704     4.565     0.200
    78.724     4.564     0.200
    78.752     4.556     0.200
    78.993     0.255     0.200
    79.147     2.002     0.200
    79.167     0.091     0.200
    79.167    -0.319     0.200
    79.368     0.049     0.200
    79.368     0.254     0.200
    79.385     0.242     0.200
    79.385     0.092     0.200
    79.531     1.774     0.200
    79.547     1.569     0.200
    79.547     1.999     0.200
    79.977     1.780     0.200
    80.103     1.101     0.200
    80.103     1.489     0.200
    80.103     1.601     0.200
    80.306     1.817     0.200
    80.306     2.206     0.200
    80.306     2.876     0.200
    80.306     2.026     0.200
    80.509     0.336     0.200
    80.509     0.816     0.200
    80.509     0.685     0.200
    80.529     0.161     0.200
    80.625     1.745     0.200
    80.640     0.767     0.200
    80.800     0.521     0.200
    81.021     3.164     0.200
    80.963     0.562     0.200
    80.972     2.421     0.200
    81.301     0.494     0.200
    81.306     0.443     0.200
    81.425     0.918     0.200
    81.429     0.716     0.200
    81.567     0.758     0.200
    81.603     0.410     0.200
    81.825     1.160     0.200
    81.841     1.244     0.200
    81.963     1.704     0.200
    81.941     1.987     0.200
    81.966     1.106     0.200
    82.027     0.938     0.200
    82.067     0.908     0.200
    82.207     0.986     0.200
    82.345     0.803     0.200
    82.320     0.507     0.200
    82.320     0.962     0.200
    82.352     0.837     0.200
    82.352     0.987     0.200
    82.391     1.180     0.200
    82.403     1.531     0.200
    82.403     1.379     0.200
    82.417     0.727     0.200
    82.417     0.956     0.200
    82.449     0.766     0.200
    82.449     1.514     0.200
    82.449     1.350     0.200
    82.486     0.935     0.200
    82.522    -0.160     0.200
    82.522     1.020     0.200
    82.531     1.146     0.200
    82.531     1.372     0.200
    81.789     4.978     0.200
    82.554     1.096     0.200
    82.554     1.270     0.200
    82.641     1.161     0.200
    82.641     0.454     0.200
    82.696     1.201     0.200
    82.696     0.834     0.200
    82.729     1.281     0.200
    82.773     0.834     0.200
    82.827     1.034     0.200
    82.853     0.586     0.200
    82.853     0.859     0.200
    82.896     1.247     0.200
    82.905     1.158     0.200
    83.097     1.827     0.200
    83.209     1.444     0.200
    83.345     0.214     0.200
    83.345     0.025     0.200
    83.345     0.509     0.200
    83.479     1.026     0.200
    83.690     2.612     0.200
    83.883    -0.345     0.200
    84.024     0.601     0.200
    84.051     1.450     0.200
    84.202     0.760     0.200
    84.405     0.925     0.200
    84.655     2.340     0.200
    84.735     1.799     0.200
    84.784     2.485     0.200
    84.789     2.013     0.200
    84.953     1.512     0.200
    84.989     0.039     0.200
    84.989     0.213     0.200
    85.016     1.351     0.200
    85.016     1.515     0.200
    85.016     1.743     0.200
    85.099     0.868     0.200
    85.099     0.308     0.200
    85.099     0.608     0.200
    85.309     4.461     0.200
    85.309     4.780     0.200
    85.309     4.590     0.200
    85.117     0.521     0.200
    85.117     0.471     0.200
    85.224     0.067     0.200
    85.224     0.186     0.200
    85.221     1.449     0.200
    85.235    -0.088     0.200
    85.252     1.168     0.200
    85.315     1.389     0.200
    85.373     1.029     0.200
    85.475     0.313     0.200
    85.478     2.310     0.200
    85.586    -0.119     0.200
    85.617     1.767     0.200
    85.617     2.116     0.200
    85.697    -0.938     0.200
    85.711     0.586     0.200
    85.825     0.087     0.200
    85.840     0.109     0.200
    85.904     1.901     0.200
    85.904     2.087     0.200
    85.981     1.243     0.200
    86.025     2.603     0.200
    86.183     1.095     0.200
    86.216     1.304     0.200
    86.265     0.600     0.200
    86.325     0.730     0.200
    86.436     0.671     0.200
    86.432     0.142     0.200
    86.471     2.906     0.200
    86.493     4.929     0.200
    86.514     0.720     0.200
    86.558     2.009     0.200
    86.634    -0.552     0.200
    86.689    -0.369     0.200
    86.763     1.277     0.200
    86.914     1.283     0.200
    86.994     1.030     0.200
    87.014     1.172     0.200
    87.093     1.005     0.200
    87.112    -0.756     0.200
    87.209     0.470     0.200
    87.294     0.680     0.200
    87.346     0.416     0.200
    87.373     1.123     0.200
    87.405     0.644     0.200
    87.454     1.106     0.200
    87.458     0.700     0.200
    87.458     0.459     0.200
    87.479     0.999     0.200
    87.498     1.177     0.200
    87.500     1.009     0.200
    87.505     1.075     0.200
    87.505     1.923     0.200
    87.530     0.553     0.200
    87.548    -0.592     0.200
    87.625     0.186     0.200
    87.662     0.549     0.200
    87.794     0.321     0.200
    87.894     1.054     0.200
    87.962     1.050     0.200
    87.962     0.781     0.200
    88.097     0.991     0.200
    88.097     0.551     0.200
    88.113    -0.804     0.200
    88.165     0.059     0.200
    88.178     0.558     0.200
    88.191     0.091     0.200
    88.194     1.076     0.200
    88.347     1.542     0.200
    88.226    -0.997     0.200
    88.237     0.543     0.200
    88.298     0.810     0.200
    88.321     0.962     0.200
    88.350    -0.173     0.200
    88.361     0.673     0.200
    88.405     0.267     0.200
    88.422     0.518     0.200
    88.479     0.454     0.200
    88.479     0.675     0.200
    88.479    -0.055     0.200
    88.479    -0.744     0.200
    88.542     0.570     0.200
    88.640    -0.690     0.200
    88.670     0.969     0.200
    88.703     0.621     0.200
    88.736     1.016     0.200
    88.900     0.267     0.200
    88.926     0.632     0.200
    88.986     1.083     0.200
    89.006     0.725     0.200
    89.005     0.782     0.200
    89.023     0.797     0.200
    89.023     0.608     0.200
    89.209     0.213     0.200
    89.209    -0.008     0.200
    89.209     0.323     0.200
    89.228     0.745     0.200
    89.355    -0.709     0.200
    89.439     1.237     0.200
    89.439     1.048     0.200
    89.431     0.676     0.200
    89.504     0.773     0.200
    89.520     0.089     0.200
    89.575     0.207     0.200
    89.585    -2.159     0.200
    89.630     0.294     0.200
    89.630     0.034     0.200
    89.686     0.268     0.200
    89.735     0.540     0.200
    89.781     0.265     0.200
    89.786     0.193     0.200
    89.849     0.159     0.200
    89.849     0.040     0.200
    89.849     0.428     0.200
    89.849    -0.081     0.200
    89.863     0.503     0.200
    89.870     0.412     0.200
    89.897     0.596     0.200
    89.908    -0.226     0.200
    89.910     0.493     0.200
    89.937     0.320     0.200
    90.074     0.431     0.200
    90.097     0.420     0.200
    90.101     0.742     0.200
    90.144     0.853     0.200
    90.144     0.353     0.200
    90.186     1.139     0.200
    90.213     0.482     0.200
    90.213     0.032     0.200
    90.379     2.865     0.200
    90.338     0.777     0.200
    90.379     0.497     0.200
    90.539    -0.158     0.200
    90.391     1.089     0.200
    90.435     0.636     0.200
    90.470     0.755     0.200
    90.540     0.589     0.200
    90.524     1.064     0.200
    90.580     0.209     0.200
    90.595     0.800     0.200
    90.626     0.677     0.200
    90.641     1.159     0.200
    90.655    -0.855     0.200
    90.655    -0.615     0.200
    90.772    -0.294     0.200
    90.821     0.970     0.200
    90.846     1.385     0.200
    90.846     1.067     0.200
    90.845     1.097     0.200
    90.868    -0.638     0.200
    90.865     1.277     0.200
    90.927     1.108     0.200
    90.942     1.220     0.200
    90.987     0.150     0.200
    90.988     0.516     0.200
    91.030     1.042     0.200
    91.033     1.397     0.200
    91.150     0.875     0.200
    91.162     0.620     0.200
    91.189     0.661     0.200
    91.209     1.361     0.200
    91.209     0.502     0.200
    91.240     1.004     0.200
    91.267     0.980     0.200
    91.267     0.839     0.200
    91.311     1.238     0.200
    91.311     1.018     0.200
    91.324     0.935     0.200
    91.349     0.490     0.200
    91.351     1.052     0.200
    91.357     0.773     0.200
    91.368     0.703     0.200
    91.368     1.013     0.200
    91.398     0.992     0.200
    91.402     0.237     0.200
    91.422     0.211     0.200
    91.472     1.950     0.200
    91.457     0.797     0.200
    91.588     0.334     0.200
    91.588     0.444     0.200
    91.635    -0.422     0.200
    91.648     0.834     0.200
    91.689     1.444     0.200
    91.720     0.361     0.200
    91.864     1.417     0.200
    91.887     1.284     0.200
    91.909     1.256     0.200
    91.909     1.506     0.200
    91.909     0.856     0.200
    91.823     1.115     0.200
    91.989     0.889     0.200
    92.135     2.084     0.200
    92.135     2.615     0.200
    92.056     0.850     0.200
    92.075    -0.091     0.200
    92.075     0.098     0.200
    92.242     0.507     0.200
    92.242     0.818     0.200
    92.419     0.201     0.200
    92.521     0.629     0.200
    92.521    -0.170     0.200
    92.521     0.029     0.200
    92.628     0.867     0.200
    92.628     0.636     0.200
    92.674     0.563     0.200
    92.674     0.473     0.200
    92.686     0.526     0.200
    92.745     0.727     0.200
    92.940    -1.031     0.200
    92.981     0.297     0.200
    92.981     0.407     0.200
    92.999     0.125     0.200
    93.008     0.993     0.200
    93.022     0.408     0.200
    93.022     0.219     0.200
    93.027     0.498     0.200
    93.102     0.152     0.200
    93.274     0.677     0.200
    93.274     0.356     0.200
    93.279     0.187     0.200
    93.324     0.727     0.200
    93.324    -0.654     0.200
    93.417     1.950     0.200
    93.417     1.409     0.200
    93.416     0.706     0.200
    93.416     0.504     0.200
    93.416    -0.095     0.200
    93.416     0.905     0.200
    93.442     0.483     0.200
    93.460     0.573     0.200
    93.486     0.671     0.200
    93.526     0.539     0.200
    93.674     0.779     0.200
    93.674     1.118     0.200
    93.787     0.399     0.200
    93.802    -0.821     0.200
    93.873     0.311     0.200
    93.948     0.477     0.200
    94.099     2.472     0.200
    94.099     2.361     0.200
    94.099     2.132     0.200
    94.008     0.479     0.200
    94.008     0.659     0.200
    94.008    -0.321     0.200
    94.016     0.605     0.200
    94.241     2.335     0.200
    94.040     0.433     0.200
    94.040    -0.368     0.200
    94.040     0.239     0.200
    94.062     0.434     0.200
    94.088     0.324     0.200
    94.094     0.495     0.200
    94.246     0.585     0.200
    94.248     0.679     0.200
    94.248     1.075     0.200
    94.248    -0.120     0.200
    94.248     0.569     0.200
    94.268     0.214     0.200
    94.381     1.167     0.200
    94.381     0.366     0.200
    94.412     0.727     0.200
    94.412     0.167     0.200
    94.425    -0.885     0.200
    94.425    -1.135     0.200
    94.654     2.788     0.200
    94.532     0.467     0.200
    94.532     0.578     0.200
    94.751     2.623     0.200
    94.566     0.617     0.200
    94.566     0.287     0.200
    94.606     0.336     0.200
    94.637     0.933     0.200
    94.637     1.093     0.200
    94.651     0.552     0.200
    94.673    -0.249     0.200
    94.716     0.993     0.200
    94.716     1.159     0.200
    94.934     3.151     0.200
    94.846     1.636     0.200
    94.846     1.136     0.200
    95.092     2.951     0.200
    95.092     2.830     0.200
    94.908     1.256     0.200
    94.908     0.355     0.200
    94.908     0.904     0.200
    94.918     1.158     0.200
    94.964     0.419     0.200
    95.162    -0.147     0.200
    95.162     0.423     0.200
    95.313     1.101     0.200
    95.385    -0.324     0.200
    95.390     0.552     0.200
    95.427     0.581     0.200
    95.490     1.894     0.200
    95.490     1.025     0.200
    95.490     0.894     0.200
    95.566     1.147     0.200
    95.622     2.095     0.200
    95.622     1.125     0.200
    95.715     1.368     0.200
    95.715     0.729     0.200
    95.715     0.368     0.200
    95.748     0.640     0.200
    95.748     0.922     0.200
    95.826     0.817     0.200
    95.826     1.164     0.200
    95.906     1.410     0.200
    95.906     1.561     0.200
    95.926    -0.023     0.200
    96.074     1.448     0.200
    96.101     0.853     0.200
    96.101     0.712     0.200
    96.386     0.181     0.200
    96.386     0.419     0.200
    96.481     1.065     0.200
    96.572     1.676     0.200
    96.572     1.125     0.200
    96.572     0.975     0.200
    96.786     2.568     0.200
    96.599     1.154     0.200
    96.599     1.727     0.200
    96.599     1.363     0.200
    96.739     1.119     0.200
    96.687     0.353     0.200
    96.794     0.195     0.200
    96.883     0.638     0.200
    96.921     0.395     0.200
    96.921     0.567     0.200
    96.921     0.196     0.200
    96.921    -0.304     0.200
    96.926     1.470     0.200
    97.004     0.722     0.200
    97.004     0.302     0.200
    97.084     1.057     0.200
    97.084     0.797     0.200
    97.084     0.358     0.200
    97.173     2.056     0.200
    97.173     1.392     0.200
    97.173     1.646     0.200
    97.224     0.925     0.200
    97.867     0.226     0.200
    97.867     0.536     0.200
    97.867    -0.473     0.200
    97.998     3.136     0.200
    97.998     0.658     0.200
    97.998     0.437     0.200
    97.999     2.233     0.200
    97.999    -0.167     0.200
    98.222     0.732     0.200
    98.205     0.758     0.200
    98.277     1.483     0.200
    98.575     1.164     0.200
    98.726     0.563     0.200
    98.737     1.163     0.200
    98.802     0.436     0.200
    98.802     0.991     0.200
    98.802     0.276     0.200
    98.939     0.820     0.200
    98.939     1.107     0.200
    99.041     0.027     0.200
    99.060    -0.676     0.200
    99.060    -0.416     0.200
    99.060    -0.023     0.200
    99.092     1.112     0.200
    99.116     1.251     0.200
    99.428     1.193     0.200
    99.134     1.011     0.200
    99.220     2.270     0.200
    99.220     2.031     0.200
    99.363     1.922     0.200
    99.286     0.711     0.200
    99.323     0.711     0.200
    99.396    -0.963     0.200
    99.396    -1.242     0.200
    99.396    -0.813     0.200
    99.393    -0.892     0.200
    99.393    -0.632     0.200
    99.393    -1.152     0.200
    99.478     0.601     0.200
    99.478     0.822     0.200
    99.480     0.413     0.200
    99.480     0.195     0.200
    99.484     1.142     0.200
    99.492     0.890     0.200
    99.508     1.119     0.200
    59.055    -0.582     0.200
    51.692     1.763     0.200
    55.450     1.271     0.200
    57.592     0.171     0.200
    86.979     1.846     0.200
    85.089     0.231     0.200
    14.502     3.979     0.200
    14.893     2.685     0.200
    15.280     2.396     0.200
    15.673     3.659     0.200
    15.673     3.919     0.200
    15.752     2.113     0.200
    15.748     3.507     0.200
    15.918     4.134     0.200
    15.988     3.713     0.200
    15.988     4.451     0.200
    16.330     2.570     0.200
    16.571     3.605     0.200
    16.572     3.284     0.200
    16.572     2.479     0.200
    16.607     1.334     0.200
    16.607     1.212     0.200
    16.700     2.575     0.200
    16.920     1.576     0.200
    17.312     1.447     0.200
    17.390     1.679     0.200
    17.435     1.079     0.200
    17.481     1.266     0.200
    17.669     1.456     0.200
    17.704     0.861     0.200
    17.823     1.588     0.200
    17.811     1.287     0.200
    17.831     0.477     0.200
    17.862     1.253     0.200
    17.728     3.522     0.200
    17.974     0.390     0.200
    18.175     0.831     0.200
    18.116    -0.218     0.200
    18.151    -0.024     0.200
    18.234     1.245     0.200
    18.221     0.691     0.200
    18.234     0.313     0.200
    18.289     0.428     0.200
    18.391    -0.427     0.200
    18.492     0.180     0.200
    18.511    -0.021     0.200
    18.708     0.290     0.200
    19.082     3.551     0.200
    19.152     0.154     0.200
    19.234    -0.377     0.200
    19.375     1.946     0.200
    19.463    -0.681     0.200
    19.484     0.033     0.200
    19.533     1.977     0.200
    19.533     2.371     0.200
    19.568     0.303     0.200
    19.920     0.119     0.200
    20.052     2.565     0.200
    20.110     1.827     0.200
    20.216     1.256     0.200
    20.220     1.627     0.200
    20.235     2.221     0.200
    20.334     1.824     0.200
    20.350     1.436     0.200
    20.404     0.973     0.200
    20.591     0.617     0.200
    20.614     1.178     0.200
    20.638     1.080     0.200
    20.790     1.199     0.200
    20.922     2.198     0.200
    21.016     1.323     0.200
    21.078     1.270     0.200
    21.176     1.608     0.200
    21.254     1.664     0.200
    21.270     2.185     0.200
    21.382     0.860     0.200
    21.424     0.727     0.200
    21.523     1.975     0.200
    21.550     2.147     0.200
    21.772     0.960     0.200
    22.087    -0.992     0.200
    22.161    -0.278     0.200
    22.238     2.499     0.200
    22.603     1.489     0.200
    22.841     1.793     0.200
    23.178     0.897     0.200
    23.239     2.006     0.200
    23.547     0.682     0.200
    23.745     1.566     0.200
    23.745     2.230     0.200
    23.820     1.348     0.200
    24.145     2.532     0.200
    24.146    -0.323     0.200
    24.180     0.942     0.200
    24.417     1.980     0.200
    24.566    -0.845     0.200
    24.720     1.021     0.200
    24.720     0.150     0.200
    24.720     1.482     0.200
    24.950    -1.042     0.200
    25.737     1.566     0.200
    26.589     1.686     0.200
    26.824     1.202     0.200
    27.395     1.903     0.200
    29.689     0.339     0.200
    29.692     3.664     0.200
    29.867     0.320     0.200
    30.262     1.721     0.200
    31.707     1.068     0.200
    32.172    -1.825     0.200
    32.172    -1.524     0.200
    33.073     2.558     0.200
    33.073     2.085     0.200
    33.961     0.224     0.200
    35.059    -1.575     0.200
    35.197     0.794     0.200
    36.119    -0.833     0.200
    39.888     0.848     0.200
    40.197     0.634     0.200
    44.604    -1.441     0.200
    44.604    -0.339     0.200
    44.829     1.173     0.200
    44.829     0.165     0.200
    45.610    -1.726     0.200
    48.069     0.261     0.200
    48.924     3.981     0.200
    48.935     2.037     0.200
    48.935     1.388     0.200
    48.935     0.236     0.200
    51.363     2.636     0.200
    51.992     2.350     0.200
    52.123     3.087     0.200
    52.123     1.779     0.200
    52.249     1.663     0.200
    52.593     3.405     0.200
    52.756     0.840     0.200
    52.876     1.242     0.200
    52.958     1.491     0.200
    53.205     1.266     0.200
    53.254     0.296     0.200
    53.472     1.179     0.200
    54.349     0.667     0.200
    54.468     1.250     0.200
    54.543     0.664     0.200
    54.543     0.652     0.200
    54.543     1.055     0.200
    54.543     1.220     0.200
    54.645     0.861     0.200
    54.675     0.809     0.200
    54.789    -0.065     0.200
    54.937     0.649     0.200
    54.937     0.110     0.200
    55.111     1.306     0.200
    55.206     0.182     0.200
    55.206     0.471     0.200
    55.373     0.885     0.200
    55.621     1.075     0.200
    55.637     0.235     0.200
    55.713     3.724     0.200
    55.837     0.342     0.200
    56.044     0.496     0.200
    56.734     0.551     0.200
    56.882     2.899     0.200
    56.874     0.397     0.200
    57.078     0.647     0.200
    58.013     1.174     0.200
    58.136     0.449     0.200
    58.246     2.355     0.200
    58.246     1.516     0.200
    58.506     0.381     0.200
    58.772     0.527     0.200
    58.826     0.466     0.200
    59.536     0.616     0.200
    59.558     1.452     0.200
    59.614     1.261     0.200
    60.262     1.043     0.200
    60.669     1.796     0.200
    60.649     0.619     0.200
    61.035     1.153     0.200
    61.302     1.154     0.200
    61.302     1.006     0.200
    61.382     2.407     0.200
    61.382     2.267     0.200
    61.750     0.633     0.200
    62.369     1.473     0.200
    62.639     1.048     0.200
    62.836     1.019     0.200
    63.093     0.707     0.200
    63.093     0.195     0.200
    64.139     1.093     0.200
    64.139     1.233     0.200
    64.964     0.038     0.200
    65.001     1.199     0.200
    65.254     0.234     0.200
    66.021     1.753     0.200
    66.360     2.280     0.200
    66.360     2.518     0.200
    66.360     1.342     0.200
    66.516     1.524     0.200
    66.889     1.828     0.200
    66.889     1.590     0.200
    67.291     1.469     0.200
    67.887     2.404     0.200
    68.318     0.952     0.200
    68.718     1.460     0.200
    69.060     1.337     0.200
    69.055     1.220     0.200
    69.477     1.750     0.200
    69.477     1.871     0.200
    69.814     0.943     0.200
    73.061     1.110     0.200
    73.061     1.290     0.200
    77.718     0.112     0.200
    78.172    -0.160     0.200
    78.230     0.008     0.200
    78.626     0.033     0.200
    79.175    -0.018     0.200
    79.175    -0.280     0.200
    79.376     0.125     0.200
    79.393     0.386     0.200
    79.393    -0.864     0.200
    79.999     1.346     0.200
    80.518     0.081     0.200
    80.537    -0.926     0.200
    80.647     1.362     0.200
    80.643     0.410     0.200
    81.432     0.255     0.200
    81.985     1.401     0.200
    81.944     1.023     0.200
    81.974     1.148     0.200
    82.030     0.133     0.200
    82.393     0.283     0.200
    82.420     0.573     0.200
    82.557     0.867     0.200
    82.643     0.802     0.200
    82.643     0.213     0.200
    82.697     0.518     0.200
    83.366     0.091     0.200
    83.366    -0.191     0.200
    83.366     0.290     0.200
    83.481     0.448     0.200
    84.735     1.649     0.200
    85.003    -0.527     0.200
    85.019     1.194     0.200
    85.019     1.041     0.200
    85.110     0.515     0.200
    85.128     0.047     0.200
    85.128     0.347     0.200
    85.249     0.813     0.200
    85.255     0.662     0.200
    85.318     1.049     0.200
    85.379     0.785     0.200
    85.617     1.901     0.200
    85.906     1.929     0.200
    86.646    -0.889     0.200
    87.354     0.193     0.200
    87.508     1.970     0.200
    87.632    -0.103     0.200
    87.671     0.602     0.200
    87.897     1.116     0.200
    87.970     0.750     0.200
    88.550    -0.076     0.200
    89.461     0.827     0.200
    89.461     0.979     0.200
    90.667    -1.823     0.200
    90.950     0.935     0.200
    91.429     0.175     0.200
    91.931     1.329     0.200
    92.008     0.684     0.200
    92.008     0.258     0.200
    92.682     0.169     0.200
    95.399    -0.705     0.200
    96.607     1.127     0.200
    96.607     0.799     0.200
    96.761     1.302     0.200
    96.815     0.132     0.200
    97.876     0.160     0.200
    98.244     0.315     0.200
    51.714     1.385     0.200
    55.471     1.521     0.200
    80.537     0.059     0.200
    86.980     1.996     0.200
    86.980     1.783     0.200
    92.008     0.403     0.200
    77.718     0.323     0.200
    14.418     3.239     0.200
    14.408     6.127     0.200
    14.567     4.921     0.200
    14.915     4.085     0.200
    15.010     4.679     0.200
    15.025     5.248     0.200
    15.226     4.139     0.200
    15.315     5.307     0.200
    15.385     3.135     0.200
    15.560     3.943     0.200
    15.709     4.370     0.200
    15.782     4.422     0.200
    15.959     4.081     0.200
    16.354     2.881     0.200
    16.365     3.339     0.200
    16.459     2.188     0.200
    16.588     1.752     0.200
    16.588     1.049     0.200
    16.588     2.982     0.200
    16.640     0.901     0.200
    16.640     1.768     0.200
    16.734     3.214     0.200
    16.839     2.864     0.200
    16.956     1.991     0.200
    17.342     1.544     0.200
    17.432     1.749     0.200
    17.481     2.164     0.200
    17.516     1.283     0.200
    17.639     0.355     0.200
    17.739     1.110     0.200
    17.713     1.653     0.200
    17.847     3.016     0.200
    17.846     1.620     0.200
    17.867     0.412     0.200
    17.984     2.247     0.200
    18.009     0.750     0.200
    18.156    -0.710     0.200
    18.156    -0.550     0.200
    18.187     0.099     0.200
    18.259     0.548     0.200
    18.269     0.074     0.200
    18.367     0.859     0.200
    18.323     0.237     0.200
    18.432    -1.195     0.200
    18.565     2.857     0.200
    18.547     0.012     0.200
    18.742     0.288     0.200
    18.795    -0.371     0.200
    18.895    -0.046     0.200
    18.938     0.275     0.200
    19.077     2.837     0.200
    19.160     1.762     0.200
    19.241     2.426     0.200
    19.269    -0.193     0.200
    19.392     1.767     0.200
    19.348    -0.343     0.200
    19.500    -0.619     0.200
    19.522    -0.720     0.200
    19.612     0.128     0.200
    19.923    -0.779     0.200
    19.968    -1.264     0.200
    20.011    -0.527     0.200
    20.002    -0.911     0.200
    20.223    -1.247     0.200
    20.382    -0.627     0.200
    20.450    -0.424     0.200
    20.509     0.220     0.200
    20.716    -1.133     0.200
    20.929     1.841     0.200
    20.936    -0.527     0.200
    20.999    -0.901     0.200
    21.258    -0.554     0.200
    21.424    -2.011     0.200
    21.469    -1.262     0.200
    21.479    -1.767     0.200
    21.805    -0.271     0.200
    21.948     1.886     0.200
    21.947     0.980     0.200
    21.846    -1.592     0.200
    21.920    -1.024     0.200
    21.972    -1.988     0.200
    22.127    -1.276     0.200
    22.127    -1.538     0.200
    22.205    -0.980     0.200
    22.230    -1.853     0.200
    22.210    -0.578     0.200
    22.417    -0.905     0.200
    22.476    -0.500     0.200
    22.509    -2.514     0.200
    22.662    -0.413     0.200
    22.669    -1.426     0.200
    22.909    -1.697     0.200
    22.941    -2.693     0.200
    22.994    -1.907     0.200
    23.038    -0.822     0.200
    23.035    -1.121     0.200
    23.088    -1.037     0.200
    23.676    -0.052     0.200
    23.744     1.071     0.200
    23.744     0.266     0.200
    23.651    -1.566     0.200
    23.686    -1.785     0.200
    23.703    -0.690     0.200
    23.818    -1.032     0.200
    23.800    -0.826     0.200
    23.834    -1.224     0.200
    24.144     1.111     0.200
    24.091    -1.482     0.200
    24.186    -0.516     0.200
    24.287    -1.340     0.200
    24.402    -2.223     0.200
    24.425    -1.859     0.200
    24.461     1.335     0.200
    24.461     0.987     0.200
    24.560    -1.410     0.200
    24.609    -1.592     0.200
    24.609    -1.123     0.200
    24.735     0.963     0.200
    24.735     0.291     0.200
    24.905    -1.371     0.200
    24.996    -0.640     0.200
    24.996    -1.179     0.200
    25.061    -1.608     0.200
    25.141    -1.535     0.200
    25.203    -1.204     0.200
    25.255    -1.270     0.200
    25.307    -0.246     0.200
    25.620     0.665     0.200
    25.610    -1.270     0.200
    25.694    -1.903     0.200
    25.715    -0.914     0.200
    25.867    -0.920     0.200
    25.892    -1.607     0.200
    25.978    -1.963     0.200
    26.055    -1.343     0.200
    26.061    -1.197     0.200
    26.129    -1.844     0.200
    26.489    -1.884     0.200
    26.776    -0.851     0.200
    26.634    -1.269     0.200
    26.675    -1.428     0.200
    26.654     2.310     0.200
    26.741    -0.989     0.200
    26.712    -2.163     0.200
    26.784    -1.681     0.200
    26.891    -1.700     0.200
    27.080    -1.734     0.200
    27.406    -0.101     0.200
    27.354    -1.426     0.200
    27.372    -1.182     0.200
    27.437    -1.527     0.200
    27.701    -1.472     0.200
    27.862     0.576     0.200
    27.851     0.896     0.200
    28.022    -0.740     0.200
    28.190     1.248     0.200
    28.252     1.177     0.200
    28.212    -2.018     0.200
    28.208    -0.920     0.200
    28.211    -1.399     0.200
    28.328    -1.386     0.200
    28.469     0.917     0.200
    28.379    -2.203     0.200
    28.638    -0.886     0.200
    29.130    -1.899     0.200
    29.210    -1.428     0.200
    29.249    -0.957     0.200
    29.255    -1.531     0.200
    29.407    -2.316     0.200
    29.524    -1.394     0.200
    29.914    -1.604     0.200
    29.963    -2.183     0.200
    30.243    -0.887     0.200
    30.305    -0.834     0.200
    30.307     1.698     0.200
    30.307     1.920     0.200
    30.530    -2.481     0.200
    30.816    -2.060     0.200
    30.809    -1.518     0.200
    30.940    -1.533     0.200
    31.014    -1.858     0.200
    31.716     0.471     0.200
    31.847    -1.767     0.200
    31.888    -1.753     0.200
    31.897    -1.677     0.200
    32.012    -1.232     0.200
    32.201    -1.527     0.200
    32.201    -1.070     0.200
    32.549    -1.735     0.200
    32.939    -1.475     0.200
    32.961    -1.317     0.200
    33.040    -2.274     0.200
    33.099    -1.332     0.200
    33.110     2.923     0.200
    33.110     1.622     0.200
    33.156    -2.462     0.200
    33.388    -1.951     0.200
    33.658    -2.495     0.200
    33.657    -1.537     0.200
    34.687     0.959     0.200
    34.841     0.105     0.200
    35.018     0.201     0.200
    35.094    -1.060     0.200
    35.238    -2.289     0.200
    35.249    -1.709     0.200
    35.242     0.462     0.200
    35.242    -0.191     0.200
    35.300     0.081     0.200
    36.144    -0.882     0.200
    36.144    -0.401     0.200
    36.144     0.161     0.200
    36.406    -1.739     0.200
    36.850    -1.034     0.200
    37.404    -0.964     0.200
    38.069    -1.050     0.200
    39.261    -1.930     0.200
    39.512    -1.552     0.200
    39.709    -1.859     0.200
    39.843    -1.422     0.200
    39.960    -1.316     0.200
    40.227    -0.012     0.200
    40.741    -0.351     0.200
    41.791    -1.616     0.200
    41.854    -1.542     0.200
    42.081    -1.123     0.200
    43.742    -0.978     0.200
    44.596    -0.438     0.200
    44.621    -0.552     0.200
    45.651    -0.846     0.200
    45.651    -0.600     0.200
    46.022    -1.321     0.200
    48.093    -0.242     0.200
    48.938     4.135     0.200
    48.951     2.234     0.200
    48.951     0.695     0.200
    49.964     2.205     0.200
    50.208     0.433     0.200
    50.982    -0.678     0.200
    51.374     2.588     0.200
    51.426     2.327     0.200
    52.002     2.486     0.200
    52.002     1.619     0.200
    52.134     3.072     0.200
    52.537    -1.120     0.200
    52.603     2.463     0.200
    52.882     0.690     0.200
    53.388     0.315     0.200
    53.669     3.117     0.200
    54.213     0.546     0.200
    54.550     0.853     0.200
    54.550    -0.248     0.200
    54.550    -0.006     0.200
    54.648     1.163     0.200
    54.680     0.552     0.200
    55.232     0.086     0.200
    55.376     1.355     0.200
    55.627     1.428     0.200
    55.707     0.017     0.200
    55.724     3.492     0.200
    55.860     0.941     0.200
    56.087    -0.750     0.200
    56.235     0.945     0.200
    56.707     0.810     0.200
    56.740     0.894     0.200
    56.795     2.777     0.200
    56.878    -0.041     0.200
    56.888     2.882     0.200
    57.048     0.546     0.200
    57.086     1.321     0.200
    57.214     1.414     0.200
    57.681     0.666     0.200
    57.708     1.134     0.200
    57.880     2.989     0.200
    58.193     0.185     0.200
    58.250     2.321     0.200
    58.250     2.121     0.200
    58.381     2.243     0.200
    58.508     0.786     0.200
    58.780     0.690     0.200
    58.894     0.305     0.200
    59.068     2.261     0.200
    59.068     2.023     0.200
    59.452     0.219     0.200
    59.528     1.833     0.200
    59.636     0.980     0.200
    59.799     2.191     0.200
    59.862     2.966     0.200
    59.968     1.608     0.200
    60.097     2.104     0.200
    60.265     1.157     0.200
    60.404     1.617     0.200
    60.459     2.285     0.200
    60.669     0.499     0.200
    60.902     2.908     0.200
    60.913     2.403     0.200
    61.384     2.453     0.200
    61.384     1.874     0.200
    61.518     1.206     0.200
    61.876     2.103     0.200
    62.376     2.087     0.200
    62.839    -0.196     0.200
    63.107     0.408     0.200
    63.107     1.045     0.200
    64.166     1.298     0.200
    64.166     1.747     0.200
    65.012     1.844     0.200
    65.012     1.953     0.200
    64.999    -0.096     0.200
    64.999    -0.229     0.200
    65.734     1.933     0.200
    65.930     1.685     0.200
    66.359     2.665     0.200
    66.359     2.325     0.200
    66.359     1.864     0.200
    66.976     1.793     0.200
    66.914     1.942     0.200
    67.308     1.387     0.200
    67.308     0.407     0.200
    67.884     2.351     0.200
    67.884     2.234     0.200
    68.332     1.050     0.200
    69.073     1.377     0.200
    69.501     1.757     0.200
    69.816     2.581     0.200
    77.749     0.044     0.200
    80.283     1.966     0.200
    80.640     1.382     0.200
    80.561    -0.940     0.200
    80.581     0.045     0.200
    81.875     0.948     0.200
    81.992     1.155     0.200
    82.077     0.167     0.200
    82.370     0.277     0.200
    82.467     0.508     0.200
    82.498     0.428     0.200
    82.605     0.740     0.200
    82.745     0.650     0.200
    83.529     0.265     0.200
    85.037     0.339     0.200
    85.067     1.039     0.200
    85.067     1.148     0.200
    85.151     0.630     0.200
    85.151     0.740     0.200
    85.168     0.185     0.200
    85.168     0.884     0.200
    85.168     0.232     0.200
    85.303     0.735     0.200
    85.303     0.192     0.200
    85.366     1.157     0.200
    85.665     1.846     0.200
    87.510     1.659     0.200
    87.556     2.053     0.200
    87.677    -0.233     0.200
    87.890     1.235     0.200
    87.972     0.969     0.200
    91.474     0.195     0.200
    92.680     1.370     0.200
    96.825     0.308     0.200
    55.480     1.313     0.200
    80.581     0.506     0.200
    57.619     0.030     0.200
    87.028     2.179     0.200
    15.004     5.682     0.200
    15.093     5.335     0.200
    15.120     5.314     0.200
    15.412     4.987     0.200
    15.654     4.614     0.200
    18.251    -1.035     0.200
    18.638    -0.559     0.200
    19.444    -0.856     0.200
    20.019    -0.671     0.200
    20.107    -0.485     0.200
    21.579    -0.198     0.200
    22.222    -1.359     0.200
    22.329    -2.332     0.200
    22.769    -1.445     0.200
    23.009    -1.214     0.200
    23.094    -1.839     0.200
    23.135    -1.469     0.200
    23.138    -1.536     0.200
    23.751    -1.464     0.200
    23.786    -2.188     0.200
    23.897    -0.761     0.200
    23.934    -1.690     0.200
    24.281    -0.700     0.200
    24.387    -1.016     0.200
    24.501    -2.084     0.200
    24.525    -1.871     0.200
    24.708    -1.023     0.200
    24.793     1.670     0.200
    25.005    -1.542     0.200
    25.096    -1.822     0.200
    25.161    -1.440     0.200
    25.301    -1.349     0.200
    26.161    -1.300     0.200
    26.774    -1.310     0.200
    27.019    -0.586     0.200
    27.799    -1.152     0.200
    28.479    -1.352     0.200
    30.630    -2.609     0.200
    33.138    -2.259     0.200
    40.822    -0.840     0.200
    44.684     0.035     0.200
    46.100    -1.751     0.200
    52.620    -1.414     0.200
    54.262     0.715     0.200
    54.592    -0.526     0.200
    54.719     0.078     0.200
    55.410     0.653     0.200
    55.744     0.592     0.200
    56.783     0.727     0.200
    56.917     0.668     0.200
    57.714     0.743     0.200
    57.755     0.764     0.200
    58.934     0.072     0.200
    59.585     0.692     0.200
    60.301     0.679     0.200
    61.553     0.343     0.200
    62.876     0.336     0.200
    57.660    -0.080     0.200
    18.352     0.382     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   100.163     3.936     0.200
   100.042     2.494     0.200
   105.215     0.497     0.200
   106.292    -0.291     0.200
   100.565     1.487     0.200
   101.389     1.820     0.200
   101.424     0.668     0.200
   101.424     3.668     0.200
   102.183    -0.708     0.200
   102.518     0.804     0.200
   107.979     3.824     0.200
    99.744     2.171     0.200
   100.465     3.464     0.200
   100.732     0.278     0.200
   101.291     3.794     0.200
   101.318     1.674     0.200
   101.988     0.694     0.200
   102.386    -1.677     0.200
   102.521    -1.678     0.200
   104.028     0.622     0.200
   105.143     4.668     0.200
   105.330     3.336     0.200
   105.860     0.479     0.200
   106.122     3.314     0.200
   106.259     1.706     0.200
   107.804     1.735     0.200
   108.043     1.774     0.200
   108.348     3.419     0.200
   108.882     3.249     0.200
   110.270    -2.625     0.200
   114.967     3.993     0.200
   117.132     4.366     0.200
   118.683     4.474     0.200
   119.222     2.075     0.200
   124.817     5.205     0.200
    99.766     2.595     0.200
    99.920     4.910     0.200
   102.194     2.800     0.200
   105.394     0.374     0.200
   100.753     0.089     0.200
    99.634    -0.789     0.200
   100.111     3.512     0.200
   100.951     1.777     0.200
   101.328     1.099     0.200
   101.194     2.697     0.200
   106.288     1.550     0.200
   108.235     2.892     0.200
   100.899     2.885     0.200
    99.617     1.015     0.200
    99.738     4.475     0.200
   100.083     0.942     0.200
   100.998     2.873     0.200
   101.297     1.846     0.200
   101.232     3.835     0.200
   101.534     0.992     0.200
   102.010     3.376     0.200
   102.067     4.622     0.200
   102.244     0.734     0.200
   102.323    -0.014     0.200
   104.177     4.744     0.200
   104.368     4.891     0.200
   106.235     4.593     0.200
   106.887     3.693     0.200
   106.851     3.456     0.200
   107.393     3.546     0.200
   108.322    -0.683     0.200
   108.811     1.139     0.200
   113.438     5.174     0.200
   101.343     1.538     0.200
    99.912     0.363     0.200
   100.207     0.552     0.200
   100.714     3.798     0.200
   100.538     1.581     0.200
   100.538     3.081     0.200
   100.799     1.919     0.200
   101.293     0.525     0.200
   101.170     1.270     0.200
   101.422    -1.151     0.200
   101.512     3.749     0.200
   101.772     1.593     0.200
   101.951     0.800     0.200
   102.065    -0.708     0.200
   102.361     2.175     0.200
   102.400    -1.197     0.200
   102.400    -0.697     0.200
   102.406     4.776     0.200
   102.878     1.677     0.200
   102.968     1.277     0.200
   103.818     0.498     0.200
   103.947     1.927     0.200
   104.044     1.493     0.200
   104.044     1.993     0.200
   103.951     1.908     0.200
   105.232     4.213     0.200
   105.909     0.203     0.200
   105.844     1.492     0.200
   105.865     1.398     0.200
   106.238    -0.261     0.200
   106.305     2.443     0.200
   106.431     1.880     0.200
   107.059    -0.713     0.200
   107.305     2.096     0.200
   107.853     4.060     0.200
   108.383     0.703     0.200
   109.735    -1.807     0.200
   110.793     1.489     0.200
   111.638     2.332     0.200
   112.460    -0.922     0.200
   112.873     1.244     0.200
   112.988     3.930     0.200
   113.394     1.524     0.200
   113.434     0.748     0.200
   113.445     0.700     0.200
   113.817     2.045     0.200
   113.826     2.005     0.200
   113.865     2.831     0.200
   114.576     2.671     0.200
   114.960     1.963     0.200
   115.161     2.069     0.200
   115.090     3.387     0.200
   115.068     2.484     0.200
   115.922     0.687     0.200
   115.842     3.046     0.200
   116.265     2.164     0.200
   118.756     3.089     0.200
   119.248    -0.097     0.200
   119.615     2.271     0.200
   119.733     4.746     0.200
   120.909     4.519     0.200
   121.338     0.611     0.200
   124.893     2.805     0.200
   130.103     3.645     0.200
   100.927     4.032     0.200
   101.354     0.332     0.200
   101.583     1.916     0.200
   100.991     2.753     0.200
   107.667     3.175     0.200
    99.607    -0.031     0.200
    99.607    -1.039     0.200
    99.626     3.736     0.200
    99.763     2.827     0.200
    99.816     4.594     0.200
    99.861     0.692     0.200
    99.875     2.926     0.200
   100.797     2.232     0.200
   100.798     2.423     0.200
   101.126     5.067     0.200
   101.176     2.444     0.200
   101.216     3.665     0.200
   101.301     2.288     0.200
   101.376     2.453     0.200
   101.400    -1.652     0.200
   101.517     1.326     0.200
   101.683     2.591     0.200
   101.841     2.593     0.200
   101.985     0.250     0.200
   102.001     1.175     0.200
   102.080     4.325     0.200
   102.309     1.808     0.200
   102.420     1.314     0.200
   102.765     1.778     0.200
   102.879     0.272     0.200
   103.010     1.193     0.200
   103.232     0.281     0.200
   103.299     4.404     0.200
   104.078    -0.055     0.200
   104.120     0.758     0.200
   104.120     0.290     0.200
   104.176     2.506     0.200
   106.035     1.243     0.200
   106.069     4.093     0.200
   106.160    -1.515     0.200
   106.974    -0.637     0.200
   107.158     0.251     0.200
   107.948     0.943     0.200
   108.014     4.444     0.200
   108.476     0.389     0.200
   109.640     5.216     0.200
   110.653     2.510     0.200
   110.653     1.221     0.200
   110.661     2.882     0.200
   110.743     2.814     0.200
   110.926     0.702     0.200
   112.116     0.207     0.200
   113.192     0.425     0.200
   113.343     2.756     0.200
   113.343     4.756     0.200
   115.303     5.038     0.200
   115.316     1.981     0.200
   117.066     2.201     0.200
   118.978     4.701     0.200
   100.956     1.602     0.200
   101.126     1.344     0.200
   101.248     1.303     0.200
   101.339     1.897     0.200
   102.194    -1.404     0.200
   107.231     2.000     0.200
   108.122     3.745     0.200
   100.944     3.461     0.200
   103.086     1.803     0.200
    99.616     1.802     0.200
   100.061     1.425     0.200
   100.425    -0.431     0.200
   100.793    -0.727     0.200
   101.037     1.214     0.200
   101.036     2.702     0.200
   101.059     0.889     0.200
   101.252     0.029     0.200
   101.179     2.956     0.200
   101.279     1.909     0.200
   101.422     1.276     0.200
   101.422     0.577     0.200
   101.609     1.044     0.200
   101.590     0.528     0.200
   101.900     0.149     0.200
   102.787     0.205     0.200
   103.191     0.971     0.200
   103.136     0.657     0.200
   104.135     0.213     0.200
   105.956     0.219     0.200
   106.210    -0.012     0.200
   106.738     1.641     0.200
   107.241    -0.594     0.200
   107.592     4.743     0.200
   107.626     0.696     0.200
   107.875     2.687     0.200
   107.934     3.323     0.200
   108.036     2.048     0.200
   108.309     3.459     0.200
   108.605     2.843     0.200
   108.698     0.930     0.200
   109.224     1.342     0.200
   109.605     1.897     0.200
   109.850     3.808     0.200
   110.059     1.877     0.200
   110.595    -0.305     0.200
   110.686     1.091     0.200
   111.860    -0.128     0.200
   111.880     2.528     0.200
   113.376     2.132     0.200
   115.497     2.704     0.200
   116.304     1.116     0.200
   120.031     2.544     0.200
   101.037     2.997     0.200
   102.116    -2.577     0.200
   100.922     2.759     0.200
   110.610     2.651     0.200
    99.692     0.158     0.200
   101.351     1.718     0.200
   101.636     1.395     0.200
    99.717    -1.282     0.200
    99.717    -0.805     0.200
    99.717    -1.509     0.200
   100.338     0.912     0.200
   100.320     0.310     0.200
    99.665    -0.784     0.200
    99.665    -0.534     0.200
    99.921     0.553     0.200
   100.125     2.159     0.200
   100.126     2.315     0.200
   100.126     1.917     0.200
   100.784     0.591     0.200
    99.705    -1.049     0.200
    99.707    -0.934     0.200
    99.707    -1.159     0.200
    99.907     0.893     0.200
    99.941     1.000     0.200
    99.959     0.714     0.200
   100.358     0.021     0.200
   101.737     1.318     0.200
   101.737     1.129     0.200
   103.073    -0.220     0.200
   103.366     0.274     0.200
   107.316     0.441     0.200
   107.840     0.786     0.200
   108.399     0.523     0.200
   108.477    -0.083     0.200
   110.591     0.257     0.200
   114.618     0.253     0.200
    99.662    -0.526     0.200
   127.250    -0.944     0.200
   126.015    -1.271     0.200
   126.776    -0.444     0.200
   101.217     1.810     0.200
   101.744     1.815     0.200
   127.556     0.368     0.200
   100.015     0.368     0.200
   100.020     0.350     0.200
    99.650    -1.047     0.200
    99.658    -1.626     0.200
    99.658    -0.391     0.200
    99.658    -0.227     0.200
    99.660    -0.738     0.200
    99.660    -1.481     0.200
    99.698     1.493     0.200
    99.776    -0.021     0.200
    99.799     0.268     0.200
    99.804     1.521     0.200
   100.031     1.314     0.200
   100.310     0.762     0.200
   100.487     0.982     0.200
   100.777     0.906     0.200
   100.947     1.937     0.200
   100.965     1.264     0.200
   101.026    -0.210     0.200
   101.276     0.782     0.200
   101.391     0.270     0.200
   101.571     2.069     0.200
   101.571     1.194     0.200
   102.037     0.296     0.200
   102.110     0.871     0.200
   102.227    -0.445     0.200
   102.933     0.915     0.200
   103.424    -0.370     0.200
   104.157    -0.527     0.200
   104.375     0.106     0.200
   106.087    -0.411     0.200
   106.524     3.647     0.200
   107.747    -1.290     0.200
   107.958     3.232     0.200
   108.954     2.833     0.200
   109.723    -1.475     0.200
   110.702    -0.827     0.200
   111.659    -0.275     0.200
   113.443    -2.113     0.200
   116.070     0.207     0.200
   127.217     0.557     0.200
    99.731    -0.952     0.200
    99.667    -0.886     0.200
    99.669    -0.740     0.200
    99.734     2.560     0.200
    99.773     0.876     0.200
    99.849     0.906     0.200
    99.883    -0.184     0.200
    99.888    -1.563     0.200
   100.051     1.611     0.200
   100.051     1.713     0.200
   100.180    -0.193     0.200
   100.180    -1.286     0.200
   100.566    -0.385     0.200
   101.068     0.589     0.200
   101.192    -1.861     0.200
   101.293     1.486     0.200
   101.679     0.951     0.200
   102.128    -0.124     0.200
   103.025    -0.714     0.200
   103.338    -1.302     0.200
   104.265    -0.726     0.200
   107.390     0.632     0.200
   108.536     0.549     0.200
   108.695     5.081     0.200
   113.353    -0.728     0.200
   126.295    -0.766     0.200
   100.133    -0.298     0.200
   100.337     2.147     0.200
   100.561     1.252     0.200
   100.587     3.234     0.200
   100.770     0.564     0.200
   101.192     1.025     0.200
   101.192     1.245     0.200
   101.320     2.307     0.200
   101.321     1.803     0.200
   101.321     1.641     0.200
   101.463    -2.861     0.200
   101.479    -1.092     0.200
   101.479    -1.532     0.200
   101.538     4.008     0.200
   101.941    -0.184     0.200
   101.987    -1.589     0.200
   102.478     3.627     0.200
   102.552     3.798     0.200
   102.562     0.554     0.200
   102.625     3.975     0.200
   102.645     3.885     0.200
   102.819    -1.788     0.200
   102.828     1.070     0.200
   103.089     5.011     0.200
   103.094     0.728     0.200
   103.094     3.488     0.200
   103.165    -1.225     0.200
   103.190     0.511     0.200
   103.190    -1.139     0.200
   103.319     3.488     0.200
   103.330     4.841     0.200
   103.333     4.927     0.200
   103.426    -1.685     0.200
   103.558     4.527     0.200
   103.724     3.790     0.200
   103.744     4.202     0.200
   103.920    -0.281     0.200
   103.969     3.700     0.200
   104.056     0.114     0.200
   104.056     0.314     0.200
   104.131    -1.022     0.200
   104.195     0.596     0.200
   104.640     3.819     0.200
   107.428    -0.879     0.200
   108.045     2.808     0.200
   108.049     2.792     0.200
   108.890     1.603     0.200
   108.931     3.603     0.200
   111.535     1.932     0.200
   112.311    -0.988     0.200
   113.184    -0.969     0.200
   127.645     0.144     0.200
   124.585    -0.691     0.200
   123.491     1.935     0.200
    99.742    -0.650     0.200
    99.701    -0.624     0.200
    99.627    -1.071     0.200
    99.649    -1.073     0.200
    99.659    -1.115     0.200
    99.665    -1.043     0.200
    99.666    -1.045     0.200
    99.668    -0.556     0.200
    99.668    -1.755     0.200
    99.668    -1.056     0.200
    99.670    -1.065     0.200
    99.691    -1.058     0.200
    99.730    -1.028     0.200
   100.165    -0.962     0.200
   100.291     0.272     0.200
   100.939    -1.405     0.200
   113.403    -1.020     0.200
    99.634    -1.250     0.200
    99.631    -0.786     0.200
    99.631    -1.599     0.200
    99.631    -0.638     0.200
    99.694     0.824     0.200
    99.694     0.880     0.200
    99.694     3.863     0.200
    99.694     0.630     0.200
    99.694    -0.018     0.200
    99.701     2.474     0.200
    99.774     0.023     0.200
    99.802     3.618     0.200
    99.903     0.413     0.200
    99.970     1.573     0.200
   100.052     2.539     0.200
    99.956     1.919     0.200
    99.956     1.770     0.200
   100.109     2.730     0.200
   100.149     4.535     0.200
   100.243     3.023     0.200
   100.324     3.844     0.200
   100.417     3.955     0.200
   100.484     4.126     0.200
   100.553     3.773     0.200
   100.582     2.512     0.200
   100.406     2.526     0.200
   100.407     3.530     0.200
   100.407     3.710     0.200
   100.407     2.929     0.200
   100.627     3.738     0.200
   100.702     3.453     0.200
   100.704     3.981     0.200
   100.894     2.373     0.200
   100.959     1.905     0.200
   100.971     3.460     0.200
   101.109     2.291     0.200
   101.040     3.997     0.200
   101.253     3.081     0.200
   101.286     2.708     0.200
   101.089     5.137     0.200
   101.471     3.563     0.200
   101.520     4.114     0.200
   101.609     0.491     0.200
   101.488     3.106     0.200
   101.689     3.892     0.200
   101.708     2.572     0.200
   101.739     3.141     0.200
   101.753     0.123     0.200
   101.760     3.672     0.200
   101.805     3.456     0.200
   101.810     3.409     0.200
   101.926     0.587     0.200
   101.932     4.971     0.200
   101.942     1.884     0.200
   101.971     0.180     0.200
   102.006     4.076     0.200
   102.049     0.692     0.200
   102.074     2.666     0.200
   102.124     4.678     0.200
   102.156     1.309     0.200
   102.159    -0.376     0.200
   102.193     4.816     0.200
   102.279     1.674     0.200
   102.299     1.096     0.200
   102.294     2.873     0.200
   102.305     1.075     0.200
   102.368     0.594     0.200
   102.410     4.924     0.200
   102.429     3.995     0.200
   102.438     0.585     0.200
   102.451     2.881     0.200
   102.462    -0.382     0.200
   102.476    -0.444     0.200
   102.527    -1.441     0.200
   102.523     3.701     0.200
   102.555     2.525     0.200
   102.556     3.694     0.200
   102.578     3.654     0.200
   102.461     2.031     0.200
   102.632     0.292     0.200
   102.690     0.294     0.200
   102.733     5.267     0.200
   102.748     0.552     0.200
   102.788     2.454     0.200
   102.682     3.558     0.200
   102.823     1.516     0.200
   102.855    -0.049     0.200
   102.900     2.402     0.200
   102.961     0.512     0.200
   102.999     1.771     0.200
   103.006     1.867     0.200
   103.039    -0.866     0.200
   103.033     4.237     0.200
   103.033     0.839     0.200
   103.071     1.194     0.200
   103.074     1.440     0.200
   103.084     0.232     0.200
   103.093    -0.980     0.200
   103.101     1.186     0.200
   103.114     2.816     0.200
   103.119    -0.316     0.200
   103.134     2.727     0.200
   103.181     0.830     0.200
   103.222     3.961     0.200
   103.265     3.824     0.200
   103.319     3.695     0.200
   103.336     2.733     0.200
   103.339     1.558     0.200
   103.366     0.398     0.200
   103.361    -0.423     0.200
   103.438     2.930     0.200
   103.447     1.727     0.200
   103.479     4.428     0.200
   103.484     0.133     0.200
   103.495     2.936     0.200
   103.499     0.457     0.200
   103.597    -0.237     0.200
   103.601     2.465     0.200
   103.610    -0.225     0.200
   103.601     3.884     0.200
   103.634     4.128     0.200
   103.635     2.704     0.200
   103.688     1.427     0.200
   103.691     3.360     0.200
   103.793     2.391     0.200
   103.791     1.100     0.200
   103.794     2.903     0.200
   103.852     2.130     0.200
   103.859     2.354     0.200
   103.865     2.329     0.200
   103.917     1.193     0.200
   103.943     3.926     0.200
   103.972     1.460     0.200
   103.977     2.043     0.200
   103.962     2.212     0.200
   104.056    -0.600     0.200
   104.022     2.445     0.200
   104.022     0.843     0.200
   104.075     3.074     0.200
   104.089     2.237     0.200
   104.101     2.960     0.200
   104.099     3.060     0.200
   104.187     0.505     0.200
   104.237     1.056     0.200
   104.289     4.883     0.200
   104.303     1.388     0.200
   104.401     5.124     0.200
   104.457     1.634     0.200
   104.465     4.706     0.200
   104.501     4.682     0.200
   104.566     3.743     0.200
   104.600     4.239     0.200
   104.618     2.090     0.200
   104.626     2.702     0.200
   104.642     3.919     0.200
   104.729     4.705     0.200
   104.781     3.305     0.200
   104.808     1.504     0.200
   104.889     3.996     0.200
   104.945     5.036     0.200
   105.047     0.957     0.200
   105.099     3.062     0.200
   105.105     3.681     0.200
   105.143     2.341     0.200
   105.221     2.128     0.200
   105.499     2.570     0.200
   105.507     4.738     0.200
   105.527     3.312     0.200
   105.619     1.132     0.200
   105.844    -0.507     0.200
   105.790     3.780     0.200
   106.080     3.745     0.200
   106.105     4.808     0.200
   106.173     4.435     0.200
   106.268     2.137     0.200
   106.175     3.568     0.200
   106.468     3.453     0.200
   106.604     5.050     0.200
   106.716     2.349     0.200
   106.788     3.584     0.200
   106.809     3.357     0.200
   106.813     3.598     0.200
   106.860     3.390     0.200
   106.851     4.211     0.200
   107.177     4.316     0.200
   107.188     4.523     0.200
   107.197     3.322     0.200
   107.258     4.738     0.200
   107.500     3.013     0.200
   107.637     4.600     0.200
   107.726     2.100     0.200
   107.734     3.638     0.200
   107.962     3.599     0.200
   107.977     2.703     0.200
   108.026     2.487     0.200
   108.319     1.566     0.200
   108.422     1.759     0.200
   108.403     3.364     0.200
   108.323     4.941     0.200
   108.773     3.667     0.200
   108.762     2.684     0.200
   109.104     3.881     0.200
   109.279     4.666     0.200
   109.659     4.725     0.200
   109.690     1.747     0.200
   110.236     1.309     0.200
   110.655     2.112     0.200
   110.655     2.760     0.200
   111.317     0.604     0.200
   111.938     3.546     0.200
   112.861     4.344     0.200
   113.379    -1.357     0.200
   113.687     4.773     0.200
   114.161     3.766     0.200
   114.739     0.094     0.200
   114.937     0.818     0.200
   116.930     3.459     0.200
   118.229     3.143     0.200
   118.633     4.683     0.200
   118.835     3.682     0.200
   118.854     3.401     0.200
   120.146     4.557     0.200
   124.321     1.599     0.200
   124.618    -1.220     0.200
   130.685     3.807     0.200
   144.474    -1.174     0.200
    99.646    -0.276     0.200
    99.766    -1.538     0.200
    99.766    -1.007     0.200
    99.766    -0.913     0.200
    99.766    -0.812     0.200
    99.759     2.619     0.200
    99.893     0.633     0.200
    99.932     0.852     0.200
    99.934     1.051     0.200
    99.934     0.747     0.200
    99.950     0.576     0.200
    99.978    -0.431     0.200
   100.135    -0.053     0.200
   100.135     0.236     0.200
   100.152     0.874     0.200
   100.638    -0.163     0.200
   100.657    -1.091     0.200
   100.879    -0.093     0.200
   101.069    -0.024     0.200
   101.158     0.266     0.200
   101.170    -1.591     0.200
   101.196     0.552     0.200
   101.229    -4.392     0.200
   101.330     0.762     0.200
   101.766     1.477     0.200
   101.766     1.118     0.200
   101.906    -0.225     0.200
   102.235    -0.387     0.200
   103.114     0.258     0.200
   103.444    -0.662     0.200
   103.481     1.539     0.200
   103.753     0.698     0.200
   103.753     1.253     0.200
   104.373    -0.188     0.200
   108.661     0.600     0.200
   109.817    -0.792     0.200
    99.637    -0.894     0.200
    99.695     1.124     0.200
    99.762    -1.132     0.200
    99.762    -0.851     0.200
    99.762    -0.851     0.200
    99.864     1.737     0.200
    99.897     0.792     0.200
    99.930     0.505     0.200
    99.944    -0.761     0.200
    99.958    -0.075     0.200
   100.104     1.066     0.200
   100.104     0.929     0.200
   100.107     0.985     0.200
   100.185    -0.490     0.200
   100.185    -0.130     0.200
   100.202    -0.882     0.200
   100.202     0.092     0.200
   100.489     1.150     0.200
   100.600     1.453     0.200
   100.638     1.284     0.200
   100.858     0.104     0.200
   101.126     1.503     0.200
   101.157    -0.228     0.200
   101.159    -0.836     0.200
   101.243     4.665     0.200
   101.303     0.319     0.200
   101.741     0.146     0.200
   101.741     0.562     0.200
   102.254    -0.126     0.200
   103.092    -0.265     0.200
   103.320     0.116     0.200
   103.459     1.289     0.200
   103.460    -0.090     0.200
   103.710    -0.400     0.200
   103.730     1.082     0.200
   103.730     0.611     0.200
   104.039    -0.163     0.200
   104.039     1.136     0.200
   104.394    -0.042     0.200
   106.209    -1.513     0.200
   107.644    -0.338     0.200
   108.749     0.000     0.200
   109.024     2.576     0.200
   109.816    -0.347     0.200
   111.042     0.128     0.200
   111.083    -0.378     0.200
   111.316     0.198     0.200
   113.476    -2.718     0.200
   114.954     0.284     0.200
   130.397     1.656     0.200
    99.690    -1.737     0.200
    99.618    -0.293     0.200
    99.618    -0.645     0.200
    99.699    -0.908     0.200
    99.699    -1.083     0.200
    99.699    -0.783     0.200
    99.721     0.770     0.200
    99.738     0.854     0.200
    99.738     2.168     0.200
    99.758     0.470     0.200
    99.855    -1.247     0.200
    99.854    -0.371     0.200
    99.911    -1.593     0.200
    99.974     0.795     0.200
    99.983    -0.443     0.200
   100.092    -1.014     0.200
   100.247     1.215     0.200
   100.279    -0.461     0.200
   100.176     2.572     0.200
   100.452     0.240     0.200
   100.421     0.350     0.200
   100.484     0.139     0.200
   100.484    -0.081     0.200
   100.755    -0.419     0.200
   100.628     1.733     0.200
   100.629     1.036     0.200
   100.629     0.589     0.200
   100.873     0.950     0.200
   101.004     0.401     0.200
   101.004     0.905     0.200
   101.016    -0.094     0.200
   101.072    -1.647     0.200
   101.183     0.712     0.200
   101.406     1.729     0.200
   101.506     0.701     0.200
   101.626     0.681     0.200
   101.626     0.845     0.200
   101.710     1.688     0.200
   101.759    -0.421     0.200
   101.788     2.830     0.200
   101.789    -0.324     0.200
   101.789     0.131     0.200
   101.707     1.794     0.200
   101.837     1.513     0.200
   101.961     0.762     0.200
   102.159     1.683     0.200
   102.249    -0.217     0.200
   102.265    -1.780     0.200
   102.337     1.388     0.200
   102.491     1.098     0.200
   102.504     0.223     0.200
   102.774     0.750     0.200
   102.674     1.171     0.200
   102.888    -0.757     0.200
   103.075     0.811     0.200
   103.129     0.871     0.200
   103.209    -0.386     0.200
   103.330    -0.097     0.200
   103.351     0.170     0.200
   103.401     2.262     0.200
   103.448    -0.249     0.200
   103.619     0.622     0.200
   103.619    -0.374     0.200
   103.697     0.446     0.200
   103.829     0.859     0.200
   103.959     0.677     0.200
   103.925     1.132     0.200
   104.024     0.391     0.200
   104.096    -0.530     0.200
   104.152    -0.076     0.200
   104.222     0.581     0.200
   104.395     0.041     0.200
   106.131     0.725     0.200
   106.394     2.457     0.200
   106.666     2.914     0.200
   106.666     1.240     0.200
   106.820     4.780     0.200
   107.071    -4.084     0.200
   107.383     2.058     0.200
   107.786    -2.232     0.200
   107.899     1.706     0.200
   107.933     1.115     0.200
   108.041     4.852     0.200
   108.119     4.630     0.200
   108.390     0.379     0.200
   108.922     0.801     0.200
   109.150     0.425     0.200
   109.220     1.843     0.200
   109.971    -0.346     0.200
   110.733     0.520     0.200
   111.538     0.118     0.200
   111.534     2.204     0.200
   111.933     2.555     0.200
   113.915    -0.683     0.200
   114.292     2.842     0.200
   114.825    -0.327     0.200
   115.177     2.007     0.200
   115.158    -0.008     0.200
   118.836     2.340     0.200
   119.671     3.930     0.200
   119.820     1.366     0.200
   120.357     2.383     0.200
   120.992     3.056     0.200
   124.126     0.525     0.200
   130.166     2.371     0.200
   144.642    -1.073     0.200
    99.623    -0.505     0.200
    99.667     2.504     0.200
    99.699     0.917     0.200
    99.747    -0.928     0.200
    99.747    -1.451     0.200
    99.747    -1.350     0.200
    99.853     0.559     0.200
    99.858     0.960     0.200
    99.858     1.429     0.200
    99.889     1.110     0.200
    99.894     1.067     0.200
    99.921    -0.529     0.200
    99.933    -1.382     0.200
    99.948     0.824     0.200
   100.019     0.899     0.200
   100.020     2.036     0.200
   100.099     0.864     0.200
   100.166     0.286     0.200
   100.192     0.029     0.200
   100.192    -0.330     0.200
   100.192     0.201     0.200
   100.482     1.656     0.200
   100.598     0.945     0.200
   100.603     0.271     0.200
   100.628     0.310     0.200
   100.849     0.436     0.200
   101.040     0.277     0.200
   101.120     1.069     0.200
   101.120     0.912     0.200
   101.126     0.712     0.200
   101.145    -0.511     0.200
   101.157     0.327     0.200
   101.296     0.831     0.200
   101.414    -0.481     0.200
   101.734     0.972     0.200
   101.734     1.214     0.200
   101.860     0.709     0.200
   101.883    -0.650     0.200
   101.890     0.131     0.200
   101.890    -0.283     0.200
   102.229    -0.988     0.200
   103.084     0.119     0.200
   103.312     0.712     0.200
   103.392     1.809     0.200
   103.425     0.258     0.200
   103.437    -1.060     0.200
   103.451     0.815     0.200
   103.686    -0.771     0.200
   103.722    -0.054     0.200
   103.722     0.649     0.200
   103.722    -0.429     0.200
   103.722     1.110     0.200
   104.369    -0.898     0.200
   107.584     0.895     0.200
   108.699     0.688     0.200
    99.886    -0.882     0.200
   100.099     0.428     0.200
   100.204     4.574     0.200
    99.578     0.305     0.200
    99.716     0.760     0.200
    99.717     0.857     0.200
    99.717     1.148     0.200
    99.805     0.910     0.200
    99.895    -0.332     0.200
    99.994     1.125     0.200
   100.031     0.005     0.200
   100.065     0.905     0.200
   100.194     1.714     0.200
   100.194     1.527     0.200
   100.194     2.335     0.200
   100.194     1.781     0.200
   100.208     1.169     0.200
   100.231     0.829     0.200
   100.259     0.537     0.200
   100.644     0.394     0.200
   100.797     3.457     0.200
   100.710     1.493     0.200
   100.741     0.732     0.200
   100.751     0.400     0.200
   100.783    -0.171     0.200
   100.919     0.846     0.200
   100.919     0.176     0.200
   100.927     1.547     0.200
   100.956     0.617     0.200
   101.043    -0.034     0.200
   101.043    -0.477     0.200
   101.068     0.979     0.200
   101.156     1.161     0.200
   101.279     0.815     0.200
   101.202     1.121     0.200
   101.246     0.863     0.200
   101.251     1.311     0.200
   101.319     0.401     0.200
   101.358     0.962     0.200
   101.358     1.208     0.200
   101.358     0.282     0.200
   101.414     1.710     0.200
   101.450     1.273     0.200
   101.487     0.937     0.200
   101.517     1.057     0.200
   101.517    -0.083     0.200
   101.648     0.833     0.200
   101.535     1.128     0.200
   101.539     0.959     0.200
   101.555     0.684     0.200
   101.585     0.806     0.200
   101.654     1.151     0.200
   101.718     1.546     0.200
   101.718     0.892     0.200
   101.915     1.084     0.200
   102.061    -0.032     0.200
   102.200     1.470     0.200
   102.136    -1.918     0.200
   102.099     0.065     0.200
   102.099     1.069     0.200
   102.173     0.926     0.200
   102.227     0.465     0.200
   102.240     1.094     0.200
   102.293     0.506     0.200
   102.428     0.474     0.200
   102.649     0.626     0.200
   102.712     0.134     0.200
   102.712    -0.424     0.200
   102.866     0.129     0.200
   102.876     0.490     0.200
   102.878     0.803     0.200
   102.883     0.372     0.200
   102.883     0.983     0.200
   102.938     0.402     0.200
   103.055     0.346     0.200
   103.078     0.631     0.200
   103.144     2.192     0.200
   103.192     0.675     0.200
   103.276     0.132     0.200
   103.348     0.936     0.200
   103.348     0.416     0.200
   103.482     1.947     0.200
   103.496     1.254     0.200
   103.541     1.146     0.200
   103.584     0.553     0.200
   103.588     2.544     0.200
   103.599     1.327     0.200
   103.705     0.726     0.200
   103.659     1.327     0.200
   103.664     1.179     0.200
   103.664     0.311     0.200
   103.750     0.191     0.200
   103.758     0.993     0.200
   103.894    -0.004     0.200
   103.909     0.651     0.200
   104.431    -0.326     0.200
   104.432     1.397     0.200
   104.533     2.762     0.200
   105.930     1.940     0.200
   106.192     1.464     0.200
   106.368     1.989     0.200
   106.793     1.961     0.200
   107.444     1.504     0.200
   107.444     0.430     0.200
   108.482     2.310     0.200
   108.497     2.925     0.200
   108.469     1.547     0.200
   108.494     0.987     0.200
   108.745     2.222     0.200
   109.037     4.627     0.200
   109.440     0.683     0.200
   110.685     1.076     0.200
   110.998     1.874     0.200
   111.065     2.408     0.200
   111.093     0.758     0.200
   114.750     1.304     0.200
    99.910    -0.514     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    28.398   193.425     0.200
    27.939   194.883     0.200
    28.781   190.387     0.200
    83.343     6.769     0.200
    97.661     2.115     0.200
    26.532   207.542     0.200
    28.127   196.251     0.200
    55.236    62.526     0.200
    99.113     2.680     0.200
    24.147   223.088     0.200
    25.116   216.265     0.200
    25.303   214.566     0.200
    25.543   213.387     0.200
    26.253   208.967     0.200
    27.684   198.093     0.200
    28.796   189.188     0.200
    31.703   172.493     0.200
    33.655   159.412     0.200
    34.616   156.083     0.200
    48.261    90.279     0.200
    85.626     1.841     0.200
    98.624     0.379     0.200
    98.918     2.064     0.200
    99.254    -0.434     0.200
    26.712   205.487     0.200
    27.430   197.677     0.200
    54.907    62.977     0.200
    54.907    63.977     0.200
    85.082     2.978     0.200
    86.815     3.409     0.200
    97.711     0.910     0.200
    24.660   220.346     0.200
    25.797   212.022     0.200
    27.804   197.947     0.200
    40.676   124.743     0.200
    48.340    90.532     0.200
    55.376    61.061     0.200
    85.499     2.237     0.200
    86.695     5.332     0.200
    91.190     3.094     0.200
    97.799     0.834     0.200
    98.312     3.428     0.200
    99.362    -0.168     0.200
    27.878   195.617     0.200
    29.222   187.659     0.200
    32.214   169.249     0.200
    40.663   126.184     0.200
    55.427    61.027     0.200
    28.791   190.825     0.200
    54.998    60.778     0.200
    84.813     4.944     0.200
    86.548     4.838     0.200
    99.291     1.777     0.200
    64.126    37.305     0.200
    83.459     4.072     0.200
    84.970     4.896     0.200
    85.552     3.492     0.200
    87.121     2.775     0.200
    88.220     1.516     0.200
    88.729     2.910     0.200
    90.845     4.226     0.200
    91.221     4.877     0.200
    91.255     3.319     0.200
    91.989     2.822     0.200
    95.169     3.294     0.200
    97.698    -0.180     0.200
    97.822     0.660     0.200
    98.786     0.936     0.200
    99.048     3.769     0.200
    99.370    -0.170     0.200
    99.324     4.836     0.200
    86.228     4.679     0.200
    87.063     5.086     0.200
    88.416     4.619     0.200
    90.274     2.508     0.200
    91.424     3.563     0.200
    92.964     3.448     0.200
    94.929     1.414     0.200
    97.026     2.878     0.200
    23.689   225.285     0.200
    24.636   218.658     0.200
    85.157     3.438     0.200
    85.570     6.878     0.200
    97.409     1.595     0.200
    99.428     0.545     0.200
    24.242   221.164     0.200
    25.063   215.690     0.200
    25.317   214.392     0.200
    26.025   209.580     0.200
    28.091   194.441     0.200
    45.462    98.837     0.200
    56.522    56.338     0.200
    85.977     2.188     0.200
    87.220     2.113     0.200
    97.212     0.356     0.200
    24.184   221.821     0.200
    24.961   216.739     0.200
    28.004   195.301     0.200
    55.449    61.844     0.200
    56.816    55.980     0.200
    87.642     1.508     0.200
    65.849    34.995     0.200
    81.133     7.782     0.200
    86.375     4.059     0.200
    21.057   246.269     0.200
    24.872   218.126     0.200
    25.117   216.895     0.200
    25.826   211.366     0.200
    26.611   206.381     0.200
    27.904   196.785     0.200
    67.829    24.314     0.200
    94.777     0.681     0.200
    96.136     1.583     0.200
    97.305     1.290     0.200
    63.497    35.587     0.200
    68.220    25.375     0.200
    80.050     6.138     0.200
    80.225     6.291     0.200
    80.380     6.162     0.200
    80.804     6.487     0.200
    82.576     6.438     0.200
    85.028     4.600     0.200
    87.396     4.735     0.200
    88.084     4.949     0.200
    90.736     4.513     0.200
    93.476     3.846     0.200
    97.612     1.690     0.200
    97.625     3.429     0.200
    97.752     4.359     0.200
    98.577     1.953     0.200
    99.392     0.015     0.200
    32.309   167.741     0.200
    90.861     2.319     0.200
    97.727     0.854     0.200
    97.649     2.516     0.200
    97.649     3.317     0.200
    98.546     0.489     0.200
    98.546     1.090     0.200
    67.856    26.334     0.200
    69.951    27.007     0.200
    70.549    24.847     0.200
    82.181     6.664     0.200
    83.750     3.540     0.200
    86.665     4.352     0.200
    87.692     2.372     0.200
    88.722     1.194     0.200
    88.762     1.707     0.200
    90.587     2.470     0.200
    93.635     0.275     0.200
    95.590     2.114     0.200
    96.630     3.588     0.200
    97.681     1.641     0.200
    98.295     1.077     0.200
    99.246    -0.174     0.200
    99.298     3.594     0.200
    99.384     3.212     0.200
    66.813    30.345     0.200
    68.178    26.018     0.200
    84.031     5.791     0.200
    85.053     1.824     0.200
    97.659     1.618     0.200
    97.659     1.919     0.200
    99.166     1.864     0.200
    99.307     0.235     0.200
    54.928    62.381     0.200
    57.626    54.249     0.200
    22.771   231.728     0.200
    24.050   222.762     0.200
    26.221   206.379     0.200
    27.146   200.932     0.200
    27.633   198.411     0.200
    31.069   175.592     0.200
    31.385   173.402     0.200
    33.365   162.140     0.200
    34.996   152.113     0.200
    36.938   141.468     0.200
    52.862    69.517     0.200
    54.321    63.975     0.200
    57.020    56.246     0.200
    64.703    35.406     0.200
    54.854    62.095     0.200
    57.551    52.637     0.200
    92.768     2.596     0.200
    99.120    -0.274     0.200
    17.800   275.270     0.200
    25.031   214.665     0.200
    31.968   170.281     0.200
    32.141   168.762     0.200
    44.846   101.565     0.200
    48.149    89.619     0.200
    48.139    88.398     0.200
    55.003    62.592     0.200
    97.155     1.087     0.200
    22.878   229.358     0.200
    23.950   220.661     0.200
    27.050   199.384     0.200
    31.524   169.805     0.200
    45.159    98.471     0.200
    53.747    65.297     0.200
    82.441     8.379     0.200
    83.122     8.704     0.200
    88.070     5.762     0.200
    97.339     2.878     0.200
    97.726     4.232     0.200
    98.571     4.512     0.200
    98.918     1.889     0.200
    99.080     1.667     0.200
    99.217    -0.445     0.200
    99.311     2.239     0.200
    99.335    -0.071     0.200
    99.335    -0.430     0.200
    25.392   212.622     0.200
    45.236    99.470     0.200
    55.298    60.986     0.200
    97.483     2.654     0.200
    25.321   212.997     0.200
    45.053   101.270     0.200
    45.174   100.102     0.200
    45.793    98.407     0.200
    68.799    26.494     0.200
    76.972    10.753     0.200
    97.402     1.678     0.200
    99.038     1.132     0.200
    99.333    -0.185     0.200
    25.482   211.876     0.200
    29.020   190.716     0.200
    32.733   165.174     0.200
    97.564     1.590     0.200
    45.232    99.327     0.200
    54.225    63.384     0.200
    84.731     1.385     0.200
    23.673   225.211     0.200
    24.340   221.453     0.200
    24.411   221.057     0.200
    25.006   216.117     0.200
    25.241   214.178     0.200
    26.236   208.068     0.200
    26.287   207.912     0.200
    26.535   205.571     0.200
    26.706   205.262     0.200
    26.719   203.435     0.200
    27.785   197.724     0.200
    28.382   194.160     0.200
    28.782   191.998     0.200
    32.479   166.951     0.200
    42.045   114.845     0.200
    45.086   100.556     0.200
    97.385     0.285     0.200
    25.306   212.242     0.200
    45.176   100.162     0.200
    55.154    61.321     0.200
    44.426   103.934     0.200
    24.514   220.514     0.200
    32.390   168.361     0.200
    32.576   165.809     0.200
    45.192   100.651     0.200
    48.113    91.361     0.200
    63.825    36.386     0.200
    67.252    25.540     0.200
    73.783    14.727     0.200
    76.955    13.214     0.200
    90.303     1.716     0.200
    90.940     0.855     0.200
    91.379     1.120     0.200
    94.482     1.509     0.200
    97.503     1.265     0.200
    97.572     3.555     0.200
    97.695     2.029     0.200
    98.027     0.906     0.200
    99.176     1.214     0.200
    78.051     8.635     0.200
    32.568   166.845     0.200
    98.552    -0.114     0.200
    24.406   221.307     0.200
    25.258   214.230     0.200
    32.294   169.044     0.200
    32.517   167.269     0.200
    45.109   101.187     0.200
    45.722    98.057     0.200
    55.153    62.059     0.200
    68.799    26.019     0.200
    83.395     3.411     0.200
    92.481     1.515     0.200
    25.586   212.245     0.200
    29.133   190.130     0.200
    45.025   100.819     0.200
    55.132    61.356     0.200
    45.369    99.360     0.200
    55.489    60.547     0.200
    25.182   214.005     0.200
    45.045   100.835     0.200
    55.051    62.002     0.200
    25.241   212.831     0.200
    73.499    15.856     0.200
    97.212     1.969     0.200
    44.991   100.743     0.200
    21.461   243.203     0.200
    23.177   229.474     0.200
    24.577   218.760     0.200
    24.841   216.649     0.200
    25.240   214.084     0.200
    32.215   169.263     0.200
    32.613   165.783     0.200
    32.613   166.142     0.200
    45.114    99.987     0.200
    55.080    61.545     0.200
    55.474    60.862     0.200
    97.108     1.075     0.200
    97.296     0.196     0.200
    99.431    -0.145     0.200
    24.890   216.415     0.200
    54.670    63.301     0.200
    25.081   214.585     0.200
    32.288   167.427     0.200
    44.918   101.379     0.200
    55.008    61.834     0.200
    23.309   229.207     0.200
    24.520   219.620     0.200
    26.770   205.030     0.200
    28.398   193.368     0.200
    31.420   174.358     0.200
    33.363   162.482     0.200
    99.303    -0.261     0.200
    99.346     0.745     0.200
    23.740   225.167     0.200
    24.816   217.051     0.200
    31.768   171.770     0.200
    32.361   166.836     0.200
    33.267   163.066     0.200
    35.479   149.559     0.200
    85.368     1.329     0.200
    99.311    -0.160     0.200
    23.271   228.725     0.200
    24.488   219.319     0.200
    24.767   217.631     0.200
    25.406   211.993     0.200
    25.403   212.998     0.200
    25.526   213.473     0.200
    25.625   211.744     0.200
    25.646   212.133     0.200
    26.343   209.981     0.200
    26.819   206.214     0.200
    27.822   198.797     0.200
    27.973   197.429     0.200
    28.362   192.847     0.200
    29.182   189.305     0.200
    30.333   180.180     0.200
    31.385   174.194     0.200
    31.385   174.020     0.200
    32.216   167.189     0.200
    32.652   167.589     0.200
    32.966   163.890     0.200
    33.490   160.993     0.200
    33.875   160.282     0.200
    36.267   146.081     0.200
    54.563    64.504     0.200
    72.665    18.164     0.200
    72.665    18.714     0.200
    97.332     0.678     0.200
    97.332     0.379     0.200
    97.591     1.115     0.200
    97.794     0.399     0.200
    99.167     0.946     0.200
    99.186     0.461     0.200
    99.205     0.777     0.200
    99.289    -0.298     0.200
    99.341     1.170     0.200
    99.341     0.861     0.200
    99.365     0.982     0.200
    21.336   244.415     0.200
    21.393   243.588     0.200
    21.481   243.985     0.200
    21.662   242.270     0.200
    21.928   240.945     0.200
    23.836   224.070     0.200
    24.778   216.960     0.200
    25.268   213.908     0.200
    25.996   209.128     0.200
    26.451   206.577     0.200
    26.761   205.291     0.200
    27.745   197.688     0.200
    28.403   192.993     0.200
    29.310   187.226     0.200
    30.405   180.373     0.200
    31.226   174.174     0.200
    32.599   165.152     0.200
    32.618   167.056     0.200
    41.151   118.363     0.200
    44.975   102.186     0.200
    45.134   100.197     0.200
    48.340    87.901     0.200
    48.340    88.190     0.200
    55.522    60.110     0.200
    56.806    55.286     0.200
    73.650    16.230     0.200
    99.388    -0.473     0.200
    54.595    62.863     0.200
    45.274    99.357     0.200
    24.987   215.309     0.200
    32.221   167.664     0.200
    44.829   101.665     0.200
    54.905    62.155     0.200
    21.698   242.372     0.200
    22.118   238.732     0.200
    22.146   236.366     0.200
    23.306   227.642     0.200
    23.842   223.740     0.200
    24.452   218.573     0.200
    24.559   219.084     0.200
    24.630   218.724     0.200
    24.758   217.209     0.200
    25.371   212.163     0.200
    26.369   206.528     0.200
    26.405   206.812     0.200
    26.751   205.027     0.200
    27.269   201.873     0.200
    28.296   191.907     0.200
    28.519   192.708     0.200
    29.336   186.053     0.200
    29.506   185.604     0.200
    30.883   177.190     0.200
    31.061   175.263     0.200
    31.176   175.541     0.200
    32.445   167.288     0.200
    32.445   167.428     0.200
    32.498   165.772     0.200
    32.814   164.911     0.200
    45.194    99.271     0.200
    47.021    92.959     0.200
    47.928    89.917     0.200
    51.963    74.307     0.200
    52.852    69.787     0.200
    55.876    60.347     0.200
    56.762    55.161     0.200
    59.224    48.838     0.200
    73.861    14.814     0.200
    78.003     8.621     0.200
    97.112     0.503     0.200
    97.308     1.617     0.200
    99.147    -0.136     0.200
    24.746   217.218     0.200
    54.569    63.308     0.200
    25.284   213.772     0.200
    32.294   168.169     0.200
    55.140    61.480     0.200
    24.912   215.896     0.200
    54.759    62.679     0.200
    54.261    63.154     0.200
    44.943   101.381     0.200
    55.069    61.426     0.200
    56.522    56.559     0.200
    16.078   299.122     0.200
    23.536   227.113     0.200
    23.536   227.111     0.200
    24.642   217.355     0.200
    24.642   217.357     0.200
    26.861   200.509     0.200
    33.482   163.261     0.200
    44.550   102.700     0.200
    44.550   102.706     0.200
    49.243    85.101     0.200
    54.392    64.332     0.200
    54.392    64.332     0.200
    72.896    18.479     0.200
    19.553   263.640     0.200
    25.243   215.096     0.200
    25.243   214.299     0.200
    26.608   208.222     0.200
    27.604   200.374     0.200
    29.790   185.198     0.200
    32.253   170.092     0.200
    34.915   152.647     0.200
    55.022    63.429     0.200
    73.620    13.958     0.200
    91.432     1.361     0.200
    91.859     1.088     0.200
    92.130     1.463     0.200
    93.264     0.929     0.200
    93.583     1.225     0.200
    93.710     0.928     0.200
    94.572     1.336     0.200
    97.234     0.760     0.200
    97.332     0.745     0.200
    98.085     0.697     0.200
    99.010     1.054     0.200
    99.444     0.073     0.200
    24.882   215.498     0.200
    54.646    63.174     0.200
    44.847   101.300     0.200
    53.555    65.830     0.200
    54.914    61.366     0.200
    54.915    61.896     0.200
    54.915    61.896     0.200
    18.661   269.586     0.200
    22.810   230.329     0.200
    23.432   226.728     0.200
    24.591   217.871     0.200
    24.881   216.463     0.200
    28.116   194.220     0.200
    28.814   189.368     0.200
    29.368   186.916     0.200
    30.360   179.423     0.200
    31.510   173.449     0.200
    32.251   168.021     0.200
    32.247   167.598     0.200
    52.335    70.819     0.200
    54.319    65.229     0.200
    54.702    64.491     0.200
    54.899    60.416     0.200
    57.373    53.538     0.200
    97.284     2.196     0.200
    97.738     0.240     0.200
    98.893     1.161     0.200
    99.126     0.520     0.200
    99.275    -0.143     0.200
    99.276     1.354     0.200
    22.629   233.898     0.200
    24.823   215.066     0.200
    25.267   214.469     0.200
    25.429   212.594     0.200
    25.429   212.594     0.200
    25.429   211.834     0.200
    27.241   197.927     0.200
    28.500   192.005     0.200
    28.579   192.725     0.200
    29.424   186.338     0.200
    30.156   183.163     0.200
    30.193   182.369     0.200
    30.302   178.218     0.200
    30.565   179.269     0.200
    31.936   171.714     0.200
    32.471   167.818     0.200
    32.513   166.875     0.200
    32.517   166.545     0.200
    34.214   157.411     0.200
    34.197   154.786     0.200
    34.478   156.051     0.200
    36.101   144.600     0.200
    38.924   131.259     0.200
    45.243   100.031     0.200
    50.024    81.176     0.200
    51.866    72.339     0.200
    55.395    60.951     0.200
    68.317    28.936     0.200
    76.977    10.497     0.200
    80.953    10.907     0.200
    80.966    10.841     0.200
    81.048    10.601     0.200
    81.211    10.638     0.200
    81.473    10.748     0.200
    81.586    10.349     0.200
    86.197     4.233     0.200
    86.270     2.762     0.200
    86.621     3.190     0.200
    86.901     3.172     0.200
    86.959     3.237     0.200
    87.228     3.250     0.200
    97.712     1.032     0.200
    97.712     0.769     0.200
    97.869     1.842     0.200
    98.515     2.215     0.200
    98.627     1.064     0.200
    98.736     1.176     0.200
    98.760     0.185     0.200
    99.136    -0.146     0.200
    99.338    -0.344     0.200
    99.338    -0.109     0.200
    99.341    -0.325     0.200
    99.341    -0.355     0.200
    99.411     0.561     0.200
    99.429     2.124     0.200
    99.439     1.039     0.200
    23.941   223.500     0.200
    24.995   215.454     0.200
    54.779    62.900     0.200
    22.631   231.583     0.200
    24.983   215.927     0.200
    31.944   170.390     0.200
    96.941     1.413     0.200
    22.773   233.869     0.200
    22.773   233.733     0.200
    23.985   222.593     0.200
    23.985   222.328     0.200
    30.877   176.839     0.200
    30.877   177.243     0.200
    53.664    66.715     0.200
    53.664    66.281     0.200
    23.333   228.803     0.200
    24.988   215.661     0.200
    25.245   213.578     0.200
    24.932   215.554     0.200
    54.711    63.282     0.200
    23.864   224.224     0.200
    24.801   215.689     0.200
    54.645    62.477     0.200
    54.761    63.530     0.200
    54.721    62.768     0.200
    54.767    62.771     0.200
    54.832    62.148     0.200
    23.887   224.665     0.200
    24.926   215.638     0.200
    32.421   166.667     0.200
    87.144     1.725     0.200
    87.294     1.442     0.200
    87.724     2.951     0.200
    97.187     0.364     0.200
    98.471     0.786     0.200
    54.725    63.839     0.200
    24.633   218.078     0.200
    27.185   200.112     0.200
    54.330    63.905     0.200
    25.274   214.259     0.200
    55.137    61.447     0.200
    55.137    61.699     0.200
    24.813   216.403     0.200
    44.691   101.956     0.200
    54.648    62.976     0.200
    24.520   219.635     0.200
    25.069   215.891     0.200
    25.237   213.970     0.200
    32.317   168.263     0.200
    45.031   101.730   